#!/bin/bash
gmt begin sapporo1.54_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance sapporo1.54'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.100     7.402
     0.200     7.948
     0.300     8.777
     0.400     9.805
     0.500    10.965
     0.600    12.206
     0.700    13.495
     0.800    14.813
     0.900    16.148
     1.000    17.494
     1.100    18.846
     1.200    20.203
     1.300    21.564
     1.400    22.927
     1.500    24.292
     1.600    25.659
     1.700    27.026
     1.800    28.395
     1.900    29.764
     2.000    31.133
     2.100    32.504
     2.200    33.874
     2.300    35.245
     2.400    36.616
     2.500    37.987
     2.600    39.359
     2.700    40.731
     2.800    42.103
     2.900    43.475
     3.000    44.847
     3.100    46.219
     3.200    47.591
     3.300    48.963
     3.400    50.336
     3.500    51.708
     3.600    53.081
     3.700    54.453
     3.800    55.826
     3.900    57.198
     4.000    58.571
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    51.081 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.100    13.072
     0.200    14.037
     0.300    15.497
     0.400    17.311
     0.500    19.357
     0.600    21.547
     0.700    23.824
     0.800    26.151
     0.900    28.509
     1.000    30.886
     1.100    33.276
     1.200    35.674
     1.300    38.078
     1.400    40.487
     1.500    42.899
     1.600    45.314
     1.700    47.731
     1.800    50.149
     1.900    52.568
     2.000    54.989
     2.100    57.410
     2.200    59.832
     2.300    62.255
     2.400    64.678
     2.500    67.102
     2.600    69.525
     2.700    71.949
     2.800    74.374
     2.900    76.799
     3.000    79.224
     3.100    81.649
     3.200    84.074
     3.300    86.499
     3.400    88.925
     3.500    91.350
     3.600    93.776
     3.700    96.201
     3.800    98.627
     3.900   101.053
     4.000   103.478
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    91.776 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    16.064
     0.800    17.440
     0.900    18.816
     1.000    20.191
     1.100    21.567
     1.200    22.943
     1.300    24.319
     1.400    25.694
     1.500    27.070
     1.600    28.446
     1.700    29.821
     1.800    31.197
     1.900    32.573
     2.000    33.948
     2.100    35.324
     2.200    36.700
     2.300    38.076
     2.400    39.451
     2.500    40.827
     2.600    42.203
     2.700    43.578
     2.800    44.954
     2.900    46.330
     3.000    47.706
     3.100    49.081
     3.200    50.457
     3.300    51.833
     3.400    53.208
     3.500    54.584
     3.600    55.959
     3.700    57.334
     3.800    58.709
     3.900    60.084
     4.000    61.459
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     2.178
     0.200     3.970
     0.300     5.841
     0.400     7.734
     0.500     9.637
     0.600    11.544
     0.700    13.454
     0.800    15.365
     0.900    17.277
     1.000    19.190
     1.100    21.104
     1.200    23.018
     1.300    24.829
     1.400    26.535
     1.500    28.240
     1.600    29.945
     1.700    31.650
     1.800    33.356
     1.900    35.061
     2.000    36.766
     2.100    38.471
     2.200    40.177
     2.300    41.882
     2.400    43.587
     2.500    45.292
     2.600    46.997
     2.700    48.702
     2.800    50.407
     2.900    52.112
     3.000    53.817
     3.100    55.522
     3.200    57.227
     3.300    58.932
     3.400    60.637
     3.500    62.341
     3.600    64.046
     3.700    65.751
     3.800    67.455
     3.900    69.160
     4.000    70.865
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    28.301
     0.800    30.732
     0.900    33.162
     1.000    35.593
     1.100    38.024
     1.200    40.455
     1.300    42.886
     1.400    45.317
     1.500    47.748
     1.600    50.179
     1.700    52.610
     1.800    55.041
     1.900    57.472
     2.000    59.903
     2.100    62.334
     2.200    64.765
     2.300    67.196
     2.400    69.627
     2.500    72.058
     2.600    74.489
     2.700    76.920
     2.800    79.350
     2.900    81.781
     3.000    84.212
     3.100    86.643
     3.200    89.074
     3.300    91.505
     3.400    93.936
     3.500    96.367
     3.600    98.797
     3.700   101.227
     3.800   103.658
     3.900   106.088
     4.000   108.518
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.886
     0.200     7.084
     0.300    10.424
     0.400    13.803
     0.500    17.198
     0.600    20.601
     0.700    24.009
     0.800    27.420
     0.900    30.833
     1.000    34.247
     1.100    37.662
     1.200    40.711
     1.300    43.667
     1.400    46.623
     1.500    49.578
     1.600    52.534
     1.700    55.490
     1.800    58.446
     1.900    61.401
     2.000    64.357
     2.100    67.313
     2.200    70.268
     2.300    73.224
     2.400    76.179
     2.500    79.135
     2.600    82.090
     2.700    85.046
     2.800    88.001
     2.900    90.957
     3.000    93.912
     3.100    96.867
     3.200    99.822
     3.300   102.777
     3.400   105.732
     3.500   108.687
     3.600   111.642
     3.700   114.597
     3.800   117.552
     3.900   120.506
     4.000   123.461
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    11.397
     0.200    11.706
     0.300    12.201
     0.400    12.860
     0.500    13.657
     0.600    14.565
     0.700    15.564
     0.800    16.634
     0.900    17.760
     1.000    18.929
     1.100    20.134
     1.200    21.365
     1.300    22.619
     1.400    23.890
     1.500    25.175
     1.600    26.471
     1.700    27.777
     1.800    29.090
     1.900    30.410
     2.000    31.736
     2.100    33.066
     2.200    34.400
     2.300    35.738
     2.400    37.079
     2.500    38.421
     2.600    39.767
     2.700    41.114
     2.800    42.463
     2.900    43.814
     3.000    45.166
     3.100    46.519
     3.200    47.874
     3.300    49.229
     3.400    50.585
     3.500    51.942
     3.600    53.300
     3.700    54.658
     3.800    56.017
     3.900    57.377
     4.000    58.737
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    20.135
     0.200    20.681
     0.300    21.555
     0.400    22.719
     0.500    24.126
     0.600    25.730
     0.700    27.494
     0.800    29.383
     0.900    31.372
     1.000    33.438
     1.100    35.566
     1.200    37.741
     1.300    39.956
     1.400    42.201
     1.500    44.472
     1.600    46.762
     1.700    49.070
     1.800    51.391
     1.900    53.724
     2.000    56.067
     2.100    58.418
     2.200    60.776
     2.300    63.140
     2.400    65.509
     2.500    67.884
     2.600    70.262
     2.700    72.643
     2.800    75.028
     2.900    77.415
     3.000    79.805
     3.100    82.197
     3.200    84.591
     3.300    86.987
     3.400    89.384
     3.500    91.783
     3.600    94.183
     3.700    96.584
     3.800    98.987
     3.900   101.390
     4.000   103.794
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
     2.648    57.426     0.150
     2.648    62.526     0.150
     2.858    57.992     0.150
     2.688    53.719     0.150
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.147     9.516     0.200
     0.147     8.617     0.200
     0.147     9.617     0.200
     0.287    10.414     0.200
     0.287     9.617     0.200
     0.287    10.617     0.200
     0.719    14.516     0.200
     0.719    14.617     0.200
     1.247    21.617     0.200
     1.192    21.016     0.200
     1.192    20.617     0.200
     1.600    24.414     0.200
     1.600    24.617     0.200
     1.623    25.820     0.200
     1.623    26.617     0.200
     1.623    25.617     0.200
     1.671    26.914     0.200
     1.671    26.617     0.200
     1.834    29.320     0.200
     1.834    28.617     0.200
     1.834    29.617     0.200
     1.930    30.914     0.200
     1.930    30.617     0.200
     1.989    32.617     0.200
     2.079    33.320     0.200
     2.079    33.617     0.200
     2.112    33.320     0.200
     2.112    32.617     0.200
     2.112    34.516     0.200
     2.112    33.617     0.200
     2.240    33.617     0.200
     2.261    35.414     0.200
     2.261    34.617     0.200
     2.261    35.617     0.200
     2.710    42.719     0.200
     2.710    43.414     0.200
     2.710    42.617     0.200
     2.924    45.719     0.200
     2.924    45.617     0.200
     2.924    45.914     0.200
     3.384    52.320     0.200
     3.390    52.617     0.200
     3.430    53.617     0.200
     4.032    61.219     0.200
     4.032    61.617     0.200
     4.301    64.320     0.200
     4.301    64.617     0.200
     4.494    67.219     0.200
     4.494    67.320     0.200
     4.494    67.617     0.200
     4.760    69.617     0.200
     5.626    81.914     0.200
     6.178    89.219     0.200
     6.178    89.617     0.200
     6.196    89.414     0.200
     6.196    89.617     0.200
     6.392    93.820     0.200
     6.392    93.617     0.200
     6.435    90.617     0.200
     6.606    97.016     0.200
     6.606    96.617     0.200
     6.721    99.719     0.200
     6.721    99.617     0.200
     6.715    97.414     0.200
     6.715    97.617     0.200
     6.831    98.617     0.200
     6.831    99.617     0.200
     7.025   103.016     0.200
     7.025   102.617     0.200
     7.288   106.016     0.200
     7.288   106.914     0.200
     7.288   105.617     0.200
     7.725   112.219     0.200
     7.725   112.820     0.200
     7.725   112.617     0.200
     7.814   113.219     0.200
     7.814   113.617     0.200
     8.168   117.320     0.200
     8.168   117.617     0.200
     8.429   120.617     0.200
     8.775   128.016     0.200
     8.775   127.617     0.200
     9.234   132.719     0.200
     9.234   132.617     0.200
     9.434   133.617     0.200
     9.446   136.617     0.200
    10.564   149.320     0.200
    10.564   149.617     0.200
    12.780   180.719     0.200
    12.780   180.617     0.200
    13.178   183.617     0.200
     0.469    12.473     0.200
     0.469    12.672     0.200
     0.836    15.473     0.200
     0.836    15.273     0.200
     0.764    16.473     0.200
     0.764    16.273     0.200
     0.764    15.473     0.200
     0.878    17.473     0.200
     0.878    17.873     0.200
     1.748    29.473     0.200
     1.595    27.473     0.200
     1.595    27.273     0.200
     1.595    26.473     0.200
     1.788    29.473     0.200
     1.884    28.473     0.200
     2.082    31.473     0.200
     2.082    31.672     0.200
     2.204    33.473     0.200
     2.424    37.473     0.200
     2.424    37.672     0.200
     2.518    39.273     0.200
     2.518    38.473     0.200
     2.532    38.473     0.200
     2.532    38.973     0.200
     2.790    43.473     0.200
     2.793    44.473     0.200
     2.793    44.172     0.200
     2.793    43.473     0.200
     3.034    45.473     0.200
     3.034    45.773     0.200
     3.533    54.273     0.200
     3.533    53.473     0.200
     3.540    54.473     0.200
     3.335    50.473     0.200
     3.335    50.773     0.200
     3.805    58.473     0.200
     3.880    60.473     0.200
     4.353    63.473     0.200
     4.353    63.773     0.200
     4.598    69.473     0.200
     4.598    69.973     0.200
     4.647    68.473     0.200
     4.647    68.072     0.200
     4.647    67.473     0.200
     4.878    72.473     0.200
     4.878    72.273     0.200
     4.878    71.473     0.200
     5.250    76.473     0.200
     5.761    85.473     0.200
     5.761    85.273     0.200
     5.761    84.473     0.200
     5.826    83.473     0.200
     5.897    85.473     0.200
     6.484    92.473     0.200
     6.484    92.973     0.200
     6.541    94.473     0.200
     6.541    93.473     0.200
     6.922    98.473     0.200
     6.709    95.473     0.200
     6.709    95.172     0.200
     6.786    98.473     0.200
     6.786    97.473     0.200
     6.756    94.473     0.200
     6.987   100.473     0.200
     6.981   100.473     0.200
     6.981   100.873     0.200
     7.079   101.473     0.200
     7.302   106.473     0.200
     7.254   104.473     0.200
     7.254   104.072     0.200
     7.261   106.473     0.200
     7.261   106.072     0.200
     7.261   105.473     0.200
     7.333   105.473     0.200
     7.333   105.172     0.200
     7.333   104.473     0.200
     7.326   108.473     0.200
     7.351   104.473     0.200
     7.351   103.473     0.200
     7.629   110.473     0.200
     7.629   110.672     0.200
     7.607   111.473     0.200
     7.612   110.473     0.200
     7.829   116.473     0.200
     7.829   116.172     0.200
     7.829   115.473     0.200
     7.889   117.473     0.200
     8.046   117.473     0.200
     8.028   117.473     0.200
     8.028   117.273     0.200
     8.028   116.473     0.200
     8.164   117.473     0.200
     8.164   117.873     0.200
     8.164   115.473     0.200
     8.164   115.873     0.200
     8.272   120.473     0.200
     8.320   117.473     0.200
     8.489   121.473     0.200
     8.489   121.873     0.200
     8.921   125.473     0.200
     8.868   127.473     0.200
     8.868   127.072     0.200
     8.868   126.473     0.200
     8.889   131.473     0.200
     8.958   127.473     0.200
     8.958   127.672     0.200
     9.029   131.473     0.200
     9.029   131.873     0.200
     9.000   131.473     0.200
     9.226   136.473     0.200
     9.226   135.473     0.200
     9.448   139.473     0.200
     9.527   139.473     0.200
     9.581   139.373     0.200
     9.892   141.473     0.200
     9.893   143.473     0.200
     9.893   143.973     0.200
    10.043   145.373     0.200
    10.043   144.473     0.200
    10.163   144.672     0.200
    10.226   148.473     0.200
    10.596   154.473     0.200
    10.645   152.473     0.200
    10.876   153.473     0.200
    11.028   159.473     0.200
    11.116   156.473     0.200
    11.261   159.473     0.200
    11.261   159.273     0.200
    11.859   169.473     0.200
    11.859   169.773     0.200
    11.871   170.473     0.200
    11.974   168.473     0.200
    11.974   168.172     0.200
    11.974   167.473     0.200
    12.003   170.473     0.200
    12.003   170.873     0.200
    12.179   171.473     0.200
    12.179   171.873     0.200
    12.137   171.473     0.200
    12.137   171.773     0.200
    12.881   181.473     0.200
    13.282   187.473     0.200
    13.729   187.473     0.200
    13.778   194.473     0.200
    13.857   194.473     0.200
    13.857   194.773     0.200
    14.055   197.473     0.200
    14.055   197.873     0.200
    14.054   197.473     0.200
    14.054   197.273     0.200
    14.368   202.473     0.200
    14.431   203.473     0.200
    14.431   203.773     0.200
    14.673   202.973     0.200
    15.133   213.473     0.200
    16.004   222.473     0.200
    11.116   156.973     0.200
     0.123     8.957     0.200
     0.339    10.855     0.200
     1.162    20.555     0.200
     1.654    26.055     0.200
     1.706    27.656     0.200
     1.679    26.555     0.200
     1.884    30.457     0.200
     1.983    32.957     0.200
     2.112    31.957     0.200
     2.076    32.656     0.200
     2.100    35.055     0.200
     2.295    37.156     0.200
     2.939    45.957     0.200
     3.422    52.656     0.200
     3.328    49.656     0.200
     3.422    51.656     0.200
     3.441    55.656     0.200
     4.037    59.656     0.200
     4.171    64.656     0.200
     4.310    65.656     0.200
     4.507    66.656     0.200
     4.780    68.656     0.200
     4.906    73.656     0.200
     5.561    81.656     0.200
     5.652    83.055     0.200
     6.183    88.656     0.200
     6.205    89.656     0.200
     6.398    92.656     0.200
     6.619    95.656     0.200
     6.732    98.656     0.200
     6.942   101.656     0.200
     6.850    99.656     0.200
     6.877   103.656     0.200
     7.032   103.656     0.200
     7.203   105.656     0.200
     7.462   108.656     0.200
     7.533   112.656     0.200
     7.832   110.656     0.200
     7.884   115.656     0.200
     8.414   120.656     0.200
     8.551   124.656     0.200
     9.258   133.656     0.200
     9.332   134.656     0.200
     9.458   135.156     0.200
     0.178     9.583     0.200
     1.626    25.184     0.200
     1.629    25.684     0.200
     1.715    27.684     0.200
     1.826    29.083     0.200
     2.030    32.783     0.200
     2.044    33.983     0.200
     2.136    32.983     0.200
     2.235    35.983     0.200
     2.886    44.983     0.200
     3.434    51.983     0.200
     3.282    49.983     0.200
     3.390    53.983     0.200
     3.990    58.983     0.200
     4.455    65.983     0.200
     4.591    67.983     0.200
     4.806    69.983     0.200
     4.856    72.983     0.200
     5.511    80.983     0.200
     5.594    81.983     0.200
     6.136    88.983     0.200
     6.350    89.983     0.200
     6.681    94.983     0.200
     6.702    98.983     0.200
     6.795    98.783     0.200
     6.824   102.983     0.200
     6.965    98.983     0.200
     7.683   109.983     0.200
     7.782   109.983     0.200
     7.830   114.983     0.200
     8.081   114.983     0.200
     8.367   118.983     0.200
     8.741   127.983     0.200
     9.273   133.983     0.200
     9.401   133.884     0.200
     0.349    10.719     0.200
     0.739    13.820     0.200
     1.157    20.016     0.200
     1.665    25.320     0.200
     1.713    27.414     0.200
     1.690    26.516     0.200
     1.893    30.117     0.200
     1.982    31.117     0.200
     2.121    32.117     0.200
     2.069    32.117     0.200
     2.103    35.117     0.200
     2.301    36.117     0.200
     2.942    45.117     0.200
     3.430    51.117     0.200
     3.328    50.117     0.200
     3.443    54.117     0.200
     4.785    70.117     0.200
     6.853    99.117     0.200
     8.425   121.117     0.200
     0.129     9.094     0.200
     0.309    10.797     0.200
     0.716    14.297     0.200
     1.173    20.797     0.200
     1.617    25.594     0.200
     1.645    26.297     0.200
     1.677    26.797     0.200
     1.856    30.195     0.200
     1.978    33.195     0.200
     2.079    32.594     0.200
     2.092    32.195     0.200
     2.094    35.094     0.200
     2.261    33.195     0.200
     2.280    37.695     0.200
     2.938    45.797     0.200
     3.143    46.992     0.200
     3.395    51.195     0.200
     3.334    50.195     0.200
     3.412    54.195     0.200
     3.442    53.195     0.200
     4.164    64.195     0.200
     4.312    64.195     0.200
     4.543    68.094     0.200
     4.646    69.898     0.200
     4.760    70.094     0.200
     4.908    73.195     0.200
     5.563    82.195     0.200
     6.188    89.094     0.200
     6.402    91.195     0.200
     6.920   100.195     0.200
     6.846    99.492     0.200
     7.693   109.297     0.200
     8.379   120.195     0.200
     9.205   131.297     0.200
    10.187   143.992     0.200
    11.253   159.594     0.200
    11.355   161.898     0.200
    13.291   187.594     0.200
     0.233    10.189     0.200
     0.197     8.990     0.200
     0.733    14.990     0.200
     1.560    24.090     0.200
     1.571    24.090     0.200
     1.662    26.891     0.200
     1.779    28.689     0.200
     2.049    30.689     0.200
     2.020    34.090     0.200
     2.040    34.090     0.200
     2.192    33.090     0.200
     2.162    33.590     0.200
     2.212    35.891     0.200
     2.739    42.590     0.200
     2.888    45.090     0.200
     3.213    47.590     0.200
     3.398    56.090     0.200
     4.606    69.090     0.200
     4.709    71.289     0.200
     4.767    71.090     0.200
     6.792    99.090     0.200
     6.924   100.590     0.200
     8.306   119.090     0.200
     9.268   132.090     0.200
     9.392   133.990     0.200
    10.123   143.789     0.200
    11.187   159.391     0.200
     0.110    10.047     0.200
     0.374    11.047     0.200
     0.525    13.445     0.200
     0.970    18.746     0.200
     1.687    26.148     0.200
     1.754    26.047     0.200
     1.829    29.047     0.200
     2.072    32.348     0.200
     2.285    36.047     0.200
     2.475    39.648     0.200
     2.929    44.348     0.200
     3.612    57.047     0.200
     4.340    66.047     0.200
     4.696    68.047     0.200
     6.601    93.445     0.200
     7.032   102.047     0.200
     7.101   101.746     0.200
     7.486   108.047     0.200
     7.536   107.148     0.200
    10.373   145.945     0.200
     0.178    10.058     0.200
     0.337    10.358     0.200
     0.599    12.958     0.200
     0.964    17.458     0.200
     1.197    18.658     0.200
     1.332    20.758     0.200
     1.374    22.658     0.200
     1.690    26.358     0.200
     1.618    26.358     0.200
     1.859    28.658     0.200
     1.743    27.658     0.200
     1.843    30.458     0.200
     2.304    34.658     0.200
     2.479    39.658     0.200
     2.553    37.658     0.200
     2.610    40.658     0.200
     3.088    46.658     0.200
     3.790    59.658     0.200
     3.781    56.658     0.200
     4.027    60.658     0.200
     4.186    62.658     0.200
     4.870    70.658     0.200
     5.925    85.658     0.200
     6.128    86.658     0.200
     6.168    87.658     0.200
     6.406    94.658     0.200
     6.424    94.658     0.200
     6.483    94.858     0.200
     6.529    95.658     0.200
     6.619    94.858     0.200
     6.786    99.658     0.200
     6.957   100.558     0.200
     7.131   104.658     0.200
     7.131   101.658     0.200
     7.183   105.658     0.200
     7.941   113.658     0.200
     8.178   117.658     0.200
     9.793   138.558     0.200
     9.796   136.658     0.200
    10.819   153.458     0.200
    12.692   177.658     0.200
    12.808   175.658     0.200
    15.378   214.658     0.200
     0.471    10.190     0.200
     0.791    13.890     0.200
     1.271    18.690     0.200
     1.299    20.790     0.200
     1.498    22.790     0.200
     1.916    29.490     0.200
     2.782    43.290     0.200
     2.939    45.590     0.200
     3.448    51.890     0.200
     4.723    70.790     0.200
     4.908    73.790     0.200
     6.336    89.890     0.200
     6.656    97.790     0.200
     6.791    97.890     0.200
     0.511    11.104     0.200
     1.225    19.004     0.200
     1.232    20.402     0.200
     1.472    23.402     0.200
     1.944    30.203     0.200
     2.111    34.703     0.200
     2.684    42.703     0.200
     2.812    43.203     0.200
     2.940    46.703     0.200
     3.293    51.004     0.200
     3.460    51.703     0.200
     3.986    60.004     0.200
     4.232    63.703     0.200
     4.908    74.504     0.200
     6.372    90.504     0.200
     6.678    98.203     0.200
     6.821    98.504     0.200
     7.160   103.504     0.200
     7.955   114.703     0.200
     9.242   133.303     0.200
    10.988   157.303     0.200
     0.146     8.846     0.200
     0.150     8.746     0.200
     0.287    10.546     0.200
     0.718    14.146     0.200
     1.191    20.746     0.200
     1.599    25.746     0.200
     1.623    25.946     0.200
     1.670    27.146     0.200
     1.834    29.646     0.200
     1.988    33.146     0.200
     2.068    32.846     0.200
     2.111    34.146     0.200
     2.080    33.446     0.200
     2.240    34.846     0.200
     2.261    35.346     0.200
     2.693    42.046     0.200
     2.711    42.146     0.200
     2.925    45.546     0.200
     3.163    47.246     0.200
     3.325    50.146     0.200
     3.389    53.146     0.200
     3.431    55.146     0.200
     4.032    59.146     0.200
     4.150    64.346     0.200
     4.302    63.746     0.200
     4.495    67.246     0.200
     4.560    69.146     0.200
     4.663    70.246     0.200
     4.759    70.346     0.200
     4.897    72.446     0.200
     5.553    81.246     0.200
     6.179    88.746     0.200
     6.197    89.446     0.200
     6.393    92.146     0.200
     6.716    97.346     0.200
     6.722   101.146     0.200
     6.739    99.646     0.200
     6.832    98.946     0.200
     6.919   100.646     0.200
     7.166   104.346     0.200
     7.449   110.146     0.200
     7.711   109.146     0.200
     8.357   120.146     0.200
     9.435   134.546     0.200
    10.165   143.246     0.200
    11.235   158.946     0.200
     0.198     6.785     0.200
     0.124     7.188     0.200
     0.124     6.586     0.200
     0.356     9.086     0.200
     0.562    10.387     0.200
     1.086    18.586     0.200
     1.530    23.586     0.200
     1.630    25.484     0.200
     1.630    24.586     0.200
     1.945    30.984     0.200
     1.945    30.586     0.200
     1.842    28.785     0.200
     1.842    28.586     0.200
     1.882    29.086     0.200
     1.882    28.586     0.200
     2.213    34.387     0.200
     2.213    33.586     0.200
     2.021    30.586     0.200
     2.213    35.086     0.200
     2.213    34.586     0.200
     2.367    35.984     0.200
     2.367    35.586     0.200
     2.862    43.586     0.200
     3.240    50.285     0.200
     3.240    49.586     0.200
     3.245    50.285     0.200
     3.064    47.086     0.200
     3.064    46.586     0.200
     3.518    55.188     0.200
     3.518    54.586     0.200
     3.476    52.785     0.200
     3.476    52.586     0.200
     3.575    56.586     0.200
     4.182    61.785     0.200
     4.182    61.586     0.200
     4.280    65.086     0.200
     4.280    64.586     0.200
     4.446    65.586     0.200
     4.605    67.387     0.200
     4.605    66.586     0.200
     4.449    65.785     0.200
     4.449    65.586     0.200
     4.636    68.785     0.200
     4.636    68.586     0.200
     5.043    74.387     0.200
     5.043    73.586     0.200
     5.453    82.285     0.200
     5.453    81.586     0.200
     5.748    84.586     0.200
     5.699    82.785     0.200
     5.684    81.984     0.200
     5.684    81.586     0.200
     6.343    91.387     0.200
     6.329    90.984     0.200
     6.329    90.586     0.200
     6.476    95.086     0.200
     6.541    92.586     0.200
     6.584    92.887     0.200
     6.747    99.086     0.200
     6.871   101.387     0.200
     6.871   100.586     0.200
     6.924   102.586     0.200
     6.866   100.586     0.200
     6.869    98.285     0.200
     6.965   100.984     0.200
     6.999   101.586     0.200
     7.065   100.285     0.200
     7.109   102.785     0.200
     7.109   102.586     0.200
     7.174   102.586     0.200
     7.290   106.586     0.200
     7.319   107.586     0.200
     7.394   105.484     0.200
     7.437   107.387     0.200
     7.531   107.387     0.200
     7.693   112.086     0.200
     7.693   111.586     0.200
     7.665   111.387     0.200
     7.712   113.984     0.200
     7.805   110.285     0.200
     7.805   109.586     0.200
     7.970   112.285     0.200
     7.970   111.586     0.200
     8.004   115.387     0.200
     8.343   119.586     0.200
     8.147   114.984     0.200
     8.147   114.586     0.200
     8.263   116.785     0.200
     8.457   122.086     0.200
     8.457   121.586     0.200
     8.560   123.285     0.200
     8.560   122.586     0.200
     8.665   124.188     0.200
     8.688   125.586     0.200
     8.665   127.484     0.200
     8.665   126.586     0.200
     8.903   129.188     0.200
     9.170   131.586     0.200
     9.223   131.586     0.200
     9.360   135.086     0.200
     9.360   134.586     0.200
     9.419   135.688     0.200
     9.419   135.586     0.200
     9.560   136.285     0.200
     9.574   137.188     0.200
     9.622   134.586     0.200
     9.720   139.188     0.200
     9.720   138.586     0.200
     9.732   139.188     0.200
     9.774   140.887     0.200
     9.795   141.688     0.200
     9.795   141.586     0.200
     9.891   141.785     0.200
     9.891   141.586     0.200
     9.932   141.086     0.200
     9.932   140.586     0.200
    10.269   146.586     0.200
    10.292   145.586     0.200
    10.461   151.188     0.200
    10.549   149.984     0.200
    10.549   149.586     0.200
    10.646   152.586     0.200
    10.687   153.188     0.200
    10.755   152.484     0.200
    11.200   158.586     0.200
    11.344   160.688     0.200
    11.438   163.285     0.200
    11.438   162.586     0.200
    11.541   162.586     0.200
    11.603   164.984     0.200
    11.603   164.586     0.200
    11.799   167.688     0.200
    11.799   167.586     0.200
    12.181   170.586     0.200
    12.387   173.586     0.200
    12.545   176.586     0.200
    13.357   187.887     0.200
    13.357   187.586     0.200
    13.638   191.887     0.200
    13.719   192.887     0.200
    13.719   192.586     0.200
    14.001   195.387     0.200
    14.001   194.586     0.200
    14.260   200.586     0.200
    14.756   204.887     0.200
    14.878   204.586     0.200
    14.906   207.984     0.200
    14.906   207.586     0.200
    15.646   216.484     0.200
    15.646   215.586     0.200
    17.853   244.586     0.200
     0.052     7.055     0.200
     0.257     7.254     0.200
     0.416     9.453     0.200
     0.585    11.453     0.200
     1.034    19.055     0.200
     1.581    25.055     0.200
     1.612    24.453     0.200
     1.954    30.055     0.200
     1.962    32.055     0.200
     2.243    35.754     0.200
     3.088    47.855     0.200
     3.593    59.055     0.200
     6.595    93.453     0.200
     6.994   101.453     0.200
     7.083   101.156     0.200
     7.410   106.355     0.200
     7.538   108.254     0.200
    10.327   145.254     0.200
     0.082     7.039     0.200
     0.570    11.242     0.200
     1.052    18.539     0.200
     1.556    24.141     0.200
     1.577    24.141     0.200
     1.678    26.742     0.200
     1.829    30.141     0.200
     1.926    29.641     0.200
     1.983    31.141     0.200
     2.234    35.340     0.200
     2.399    39.141     0.200
     2.870    44.840     0.200
     3.082    47.242     0.200
     3.484    52.340     0.200
     3.589    58.141     0.200
     4.191    61.840     0.200
     4.461    65.742     0.200
     4.616    68.141     0.200
     5.056    74.641     0.200
     6.595    92.840     0.200
     6.986   102.539     0.200
     7.079   100.742     0.200
     7.407   107.941     0.200
     7.539   107.340     0.200
     8.391   121.141     0.200
     9.585   137.441     0.200
    10.316   146.141     0.200
    11.375   161.340     0.200
     0.107     6.609     0.200
     0.256     7.414     0.200
     0.415     9.812     0.200
     0.535    10.711     0.200
     1.565    24.812     0.200
     1.683    24.812     0.200
     1.796    27.812     0.200
     1.940    30.609     0.200
     1.962    30.812     0.200
     2.265    35.914     0.200
     3.114    48.414     0.200
     6.628    93.516     0.200
     7.017   101.812     0.200
     7.112   101.016     0.200
     7.440   106.211     0.200
    10.346   146.414     0.200
    11.401   162.414     0.200
     0.124     7.805     0.200
     0.227     7.605     0.200
     0.385     9.805     0.200
     0.539    10.105     0.200
     1.057    18.705     0.200
     1.537    23.505     0.200
     1.813    29.305     0.200
     1.907    29.305     0.200
     1.993    31.305     0.200
     2.243    35.705     0.200
     2.396    39.305     0.200
     3.093    47.505     0.200
     3.604    57.305     0.200
     6.612    93.305     0.200
     6.995   101.305     0.200
     7.093   100.805     0.200
     7.422   105.505     0.200
    10.322   145.705     0.200
    11.373   161.405     0.200
     0.124     8.434     0.200
     0.231     9.434     0.200
     0.361    10.734     0.200
     0.746    14.035     0.200
     1.154    20.832     0.200
     1.679    26.035     0.200
     1.702    27.434     0.200
     1.724    27.434     0.200
     1.904    30.332     0.200
     1.985    33.234     0.200
     2.133    32.434     0.200
     2.064    33.434     0.200
     2.105    33.832     0.200
     2.306    37.434     0.200
     2.942    46.434     0.200
     3.442    54.434     0.200
     4.309    64.434     0.200
     6.396    93.434     0.200
     6.440    91.035     0.200
     6.854    99.434     0.200
     6.932    99.434     0.200
     7.257   104.234     0.200
     7.380   105.535     0.200
     9.465   134.934     0.200
    10.192   142.734     0.200
    11.276   159.633     0.200
     0.142     8.742     0.200
     0.155     9.945     0.200
     0.278    10.844     0.200
     0.721    13.844     0.200
     1.593    24.844     0.200
     1.615    25.344     0.200
     1.670    26.445     0.200
     1.825    29.344     0.200
     1.995    31.844     0.200
     2.066    31.844     0.200
     2.072    33.145     0.200
     2.120    33.844     0.200
     2.252    35.844     0.200
     2.702    42.844     0.200
     2.918    45.145     0.200
     3.171    46.945     0.200
     3.319    49.844     0.200
     3.424    52.844     0.200
     4.296    63.844     0.200
     4.569    69.844     0.200
     4.671    70.742     0.200
     4.762    70.145     0.200
     4.891    72.844     0.200
     6.430    91.543     0.200
     6.824    98.945     0.200
     6.921   100.043     0.200
     6.915    98.844     0.200
     7.242   103.445     0.200
     7.375   105.543     0.200
     8.349   118.344     0.200
    10.167   143.445     0.200
    11.226   159.445     0.200
     0.113     8.816     0.200
     0.201    10.016     0.200
     0.234    10.215     0.200
     0.746    14.418     0.200
     1.245    21.816     0.200
     1.571    24.816     0.200
     1.575    24.516     0.200
     1.677    25.918     0.200
     1.780    28.316     0.200
     2.031    32.816     0.200
     2.063    31.418     0.200
     2.031    33.016     0.200
     2.199    33.316     0.200
     2.167    34.316     0.200
     2.206    35.617     0.200
     2.671    41.418     0.200
     2.878    45.316     0.200
     3.397    51.816     0.200
     3.285    50.316     0.200
     3.387    53.215     0.200
     4.259    63.816     0.200
     5.509    80.715     0.200
     6.351    91.816     0.200
     6.677   100.016     0.200
     6.783    98.617     0.200
     6.876    97.816     0.200
     7.205   103.215     0.200
     7.341   105.215     0.200
     9.383   133.715     0.200
    10.124   143.016     0.200
    11.181   158.617     0.200
     0.122     8.418     0.200
     0.188     8.621     0.200
     0.324    10.820     0.200
     0.721    13.918     0.200
     1.165    20.719     0.200
     1.284    22.520     0.200
     1.634    25.520     0.200
     1.688    27.020     0.200
     1.662    25.320     0.200
     1.870    29.820     0.200
     1.977    31.520     0.200
     2.093    32.918     0.200
     2.082    31.918     0.200
     2.100    33.520     0.200
     2.278    35.020     0.200
     2.289    36.219     0.200
     2.720    41.520     0.200
     2.941    46.219     0.200
     3.406    51.621     0.200
     3.334    50.621     0.200
     3.419    54.418     0.200
     3.445    53.520     0.200
     4.042    59.520     0.200
     4.314    64.320     0.200
     4.510    67.320     0.200
     4.767    70.320     0.200
     4.910    71.320     0.200
     5.342    80.219     0.200
     5.565    81.320     0.200
     6.188    88.820     0.200
     6.209    89.320     0.200
     6.403    91.520     0.200
     6.446    91.020     0.200
     6.735   101.320     0.200
     6.833   100.520     0.200
     6.850    99.020     0.200
     6.850    99.219     0.200
     6.935    98.719     0.200
     7.261   104.121     0.200
     7.389   105.121     0.200
     7.464   110.621     0.200
     8.396   119.520     0.200
     8.551   124.320     0.200
     9.457   134.719     0.200
    11.261   159.621     0.200
    11.560   162.820     0.200
    14.987   208.520     0.200
     0.113     9.625     0.200
     0.197     9.625     0.200
     0.334    10.925     0.200
     0.718    13.024     0.200
     1.156    20.225     0.200
     1.292    23.225     0.200
     1.640    25.625     0.200
     1.660    25.524     0.200
     1.689    26.225     0.200
     1.671    26.524     0.200
     1.880    31.024     0.200
     2.095    31.824     0.200
     2.108    34.225     0.200
     2.287    35.425     0.200
     2.299    37.725     0.200
     2.660    41.225     0.200
     2.949    46.225     0.200
     3.123    47.225     0.200
     3.406    50.225     0.200
     3.452    53.225     0.200
     4.049    59.824     0.200
     4.321    64.725     0.200
     4.526    68.225     0.200
     4.517    67.225     0.200
     4.764    70.024     0.200
     4.917    73.725     0.200
     5.572    81.324     0.200
     6.216    89.524     0.200
     6.409    91.225     0.200
     6.453    91.225     0.200
     6.925    99.725     0.200
     6.859    99.625     0.200
     6.942    99.024     0.200
     7.268   102.925     0.200
     7.395   105.625     0.200
     7.450   106.024     0.200
     7.675   109.425     0.200
     8.405   119.225     0.200
     9.466   134.725     0.200
    10.204   143.725     0.200
    11.271   159.024     0.200
     0.119     9.344     0.200
     0.223     9.844     0.200
     0.354    11.445     0.200
     1.153    20.344     0.200
     1.669    25.844     0.200
     1.688    25.844     0.200
     1.715    26.445     0.200
     1.695    26.445     0.200
     1.898    30.047     0.200
     1.980    32.445     0.200
     2.658    41.246     0.200
     3.116    46.746     0.200
     3.445    55.445     0.200
     4.524    67.445     0.200
     4.626    69.746     0.200
     4.785    70.445     0.200
     6.444    91.246     0.200
     6.947    98.246     0.200
     6.856    99.445     0.200
     6.936    99.246     0.200
     7.261   104.246     0.200
     7.385   106.145     0.200
     7.443   105.645     0.200
     8.430   119.445     0.200
    10.204   143.844     0.200
    11.276   159.645     0.200
     0.085     7.039     0.200
     0.257     6.840     0.200
     0.416     9.238     0.200
     0.554    10.539     0.200
     1.028    18.137     0.200
     1.548    24.238     0.200
     1.585    24.238     0.200
     1.615    24.637     0.200
     1.807    30.238     0.200
     1.947    29.238     0.200
     2.258    37.238     0.200
     2.525    39.637     0.200
     3.010    45.238     0.200
     3.612    56.238     0.200
     4.392    66.840     0.200
     4.601    67.840     0.200
     4.496    68.039     0.200
     6.617    93.840     0.200
     7.010   102.238     0.200
     7.102   102.340     0.200
     7.612   108.238     0.200
     0.152     9.086     0.200
     0.156     9.383     0.200
     0.284    10.383     0.200
     0.730    14.086     0.200
     1.249    23.484     0.200
     1.201    20.484     0.200
     1.604    25.285     0.200
     1.621    25.086     0.200
     1.622    24.684     0.200
     1.681    26.684     0.200
     1.829    29.484     0.200
     2.000    33.484     0.200
     2.078    32.484     0.200
     2.069    34.484     0.200
     2.242    34.184     0.200
     2.252    36.086     0.200
     2.703    42.086     0.200
     2.913    45.684     0.200
     3.171    47.883     0.200
     3.400    50.484     0.200
     3.419    54.484     0.200
     4.290    64.484     0.200
     4.570    70.484     0.200
     4.772    70.484     0.200
     6.380    91.484     0.200
     6.423    90.883     0.200
     6.820    97.484     0.200
     6.931   100.586     0.200
     6.909    98.184     0.200
     7.236   103.883     0.200
     7.368   106.086     0.200
     7.419   105.484     0.200
     7.721   109.984     0.200
     8.358   118.984     0.200
     9.424   134.285     0.200
    10.164   143.484     0.200
    11.226   158.184     0.200
    11.526   161.383     0.200
    12.314   171.285     0.200
     0.141     9.066     0.200
     0.172     9.066     0.200
     0.424    11.266     0.200
     0.711    14.465     0.200
     1.292    20.367     0.200
     1.303    20.367     0.200
     1.311    21.066     0.200
     1.388    23.066     0.200
     1.497    25.066     0.200
     1.559    24.066     0.200
     1.995    33.066     0.200
     2.863    44.367     0.200
     3.390    55.066     0.200
     3.377    49.766     0.200
     4.656    69.066     0.200
     4.832    71.566     0.200
     6.414    90.266     0.200
     6.736    98.066     0.200
     7.391   105.465     0.200
     7.890   112.465     0.200
    11.062   158.465     0.200
     0.478    13.711     0.200
     0.707    16.109     0.200
     0.849    16.410     0.200
     0.973    18.609     0.200
     1.129    21.711     0.200
     1.850    28.211     0.200
     1.934    31.812     0.200
     2.253    33.910     0.200
     2.338    37.312     0.200
     3.784    57.812     0.200
     3.884    58.910     0.200
     4.109    63.711     0.200
     6.912    98.711     0.200
     7.054    99.711     0.200
     7.560   108.812     0.200
     7.585   107.711     0.200
     7.896   112.410     0.200
     7.965   114.211     0.200
     8.074   114.410     0.200
    11.550   162.711     0.200
     0.816    16.094     0.200
     1.302    20.789     0.200
     1.350    21.789     0.200
     1.348    21.992     0.200
     1.515    24.594     0.200
     1.459    24.492     0.200
     1.602    26.492     0.200
     1.892    29.492     0.200
     1.936    30.195     0.200
     1.928    31.492     0.200
     2.003    31.594     0.200
     2.152    36.492     0.200
     2.605    41.492     0.200
     2.756    43.492     0.200
     2.944    47.094     0.200
     3.282    51.492     0.200
     3.445    52.789     0.200
     4.166    63.492     0.200
     4.765    71.492     0.200
     4.810    73.094     0.200
     6.305    90.195     0.200
     6.636    97.391     0.200
     6.906   104.195     0.200
     7.100   104.594     0.200
     9.213   131.992     0.200
     9.959   142.492     0.200
    10.978   158.391     0.200
    12.533   177.492     0.200
     0.529    11.059     0.200
     0.869    15.961     0.200
     1.230    19.258     0.200
     1.303    20.359     0.200
     1.306    20.859     0.200
     1.437    22.461     0.200
     1.532    24.859     0.200
     1.872    28.559     0.200
     1.839    27.859     0.200
     1.917    31.859     0.200
     2.209    35.859     0.200
     2.570    40.461     0.200
     2.706    41.859     0.200
     3.015    47.461     0.200
     3.106    51.258     0.200
     3.179    49.059     0.200
     3.236    52.559     0.200
     3.520    53.359     0.200
     3.873    58.859     0.200
     4.121    62.961     0.200
     4.282    64.859     0.200
     4.786    70.859     0.200
     4.880    73.859     0.200
     6.018    85.559     0.200
     6.262    88.961     0.200
     6.578    95.859     0.200
     6.714    96.859     0.200
     7.237   102.961     0.200
     7.615   111.059     0.200
     9.150   131.461     0.200
     9.540   137.559     0.200
    11.236   158.758     0.200
    12.598   177.859     0.200
    18.584   257.859     0.200
     0.135     9.016     0.200
     0.268     9.715     0.200
     0.166     9.715     0.200
     0.727    13.617     0.200
     1.210    20.617     0.200
     1.588    24.016     0.200
     1.605    24.414     0.200
     1.605    25.016     0.200
     1.672    26.316     0.200
     1.814    28.016     0.200
     2.065    32.016     0.200
     2.003    31.414     0.200
     2.062    33.016     0.200
     2.225    34.016     0.200
     2.132    33.117     0.200
     2.241    35.914     0.200
     2.697    42.016     0.200
     2.908    45.016     0.200
     3.311    51.016     0.200
     3.415    54.016     0.200
     4.018    60.016     0.200
     4.287    65.016     0.200
     4.478    66.816     0.200
     4.579    68.016     0.200
     4.766    70.016     0.200
     4.882    74.715     0.200
     5.537    81.016     0.200
     6.181    89.016     0.200
     6.378    92.016     0.200
     6.421    90.516     0.200
     6.814    98.516     0.200
     6.905    98.316     0.200
     7.233   103.617     0.200
     7.367   105.215     0.200
     7.416   105.316     0.200
    11.215   158.414     0.200
     0.169     9.062     0.200
     0.469    11.562     0.200
     0.721    13.363     0.200
     1.266    20.062     0.200
     1.521    23.762     0.200
     1.803    27.164     0.200
     1.871    27.863     0.200
     2.063    31.363     0.200
     1.988    32.062     0.200
     2.068    32.961     0.200
     2.363    35.164     0.200
     2.889    43.062     0.200
     2.720    42.164     0.200
     2.856    44.562     0.200
     3.189    46.664     0.200
     3.248    51.062     0.200
     3.409    49.363     0.200
     3.330    50.863     0.200
     3.387    52.164     0.200
     3.531    53.863     0.200
     4.024    61.863     0.200
     4.025    60.062     0.200
     4.273    63.961     0.200
     4.641    67.062     0.200
     4.432    66.363     0.200
     4.752    70.062     0.200
     4.857    72.062     0.200
     5.473    81.363     0.200
     5.516    81.062     0.200
     5.534    79.562     0.200
     6.157    88.863     0.200
     6.170    88.262     0.200
     6.225    93.062     0.200
     6.373    91.062     0.200
     6.413    90.461     0.200
     6.780    96.262     0.200
     6.536    95.062     0.200
     6.633    97.863     0.200
     6.628    97.961     0.200
     6.725    98.062     0.200
     6.733    95.262     0.200
     6.773    99.062     0.200
     6.865    97.461     0.200
     6.905    98.461     0.200
     7.021   102.062     0.200
     6.998   100.062     0.200
     7.078   103.863     0.200
     7.203   103.062     0.200
     7.376   106.062     0.200
     7.415   107.961     0.200
     7.376   104.664     0.200
     7.388   105.262     0.200
     7.455   108.961     0.200
     7.916   111.062     0.200
     7.773   113.762     0.200
     7.782   110.062     0.200
     8.013   116.062     0.200
     8.056   114.664     0.200
     8.305   120.762     0.200
     8.418   122.062     0.200
     8.640   124.863     0.200
     8.888   129.062     0.200
     9.004   129.262     0.200
     9.127   131.562     0.200
     9.291   133.363     0.200
     9.312   132.863     0.200
     9.456   135.062     0.200
     9.465   135.062     0.200
    10.035   142.062     0.200
    10.040   141.863     0.200
    10.148   145.062     0.200
    10.257   146.062     0.200
    10.413   148.562     0.200
    10.400   145.062     0.200
    11.038   156.664     0.200
    11.246   157.461     0.200
    11.122   159.062     0.200
    11.271   158.062     0.200
    11.297   162.062     0.200
    12.096   168.461     0.200
    12.462   174.062     0.200
    13.287   184.664     0.200
    13.413   188.062     0.200
    14.460   201.562     0.200
    15.143   208.062     0.200
     0.109     9.590     0.200
     0.376    10.789     0.200
     0.736    13.887     0.200
     1.136    20.387     0.200
     1.685    25.789     0.200
     1.705    26.188     0.200
     1.720    26.789     0.200
     1.715    25.988     0.200
     1.920    30.387     0.200
     1.969    31.488     0.200
     2.046    32.887     0.200
     2.122    33.988     0.200
     2.332    35.289     0.200
     2.324    36.988     0.200
     2.641    39.387     0.200
     2.727    41.988     0.200
     3.096    46.887     0.200
     3.341    50.988     0.200
     3.459    52.988     0.200
     3.698    55.988     0.200
     4.050    60.988     0.200
     4.506    68.488     0.200
     4.525    67.590     0.200
     4.783    70.488     0.200
     5.576    81.988     0.200
     6.455    91.590     0.200
     6.871    99.488     0.200
     6.949    99.090     0.200
     6.976   100.188     0.200
     7.273   103.887     0.200
     7.395   105.887     0.200
     7.653   109.988     0.200
    10.220   144.188     0.200
    12.256   170.488     0.200
    18.463   251.988     0.200
     0.139     9.234     0.200
     0.338    10.539     0.200
     0.753    13.836     0.200
     1.175    20.539     0.200
     1.664    25.734     0.200
     1.680    26.336     0.200
     1.723    27.039     0.200
     1.880    30.336     0.200
     2.000    31.938     0.200
     2.127    34.633     0.200
     2.087    33.438     0.200
     2.085    34.039     0.200
     2.302    34.734     0.200
     2.284    36.039     0.200
     2.697    41.336     0.200
     2.924    45.836     0.200
     3.310    50.336     0.200
     3.425    53.336     0.200
     3.660    55.836     0.200
     4.019    60.336     0.200
     4.137    63.336     0.200
     4.293    63.336     0.200
     4.491    67.336     0.200
     4.546    68.336     0.200
     4.799    70.734     0.200
     4.889    74.234     0.200
     5.544    81.039     0.200
     6.834    99.734     0.200
     6.942    99.336     0.200
    11.254   159.734     0.200
     0.173     9.277     0.200
     0.157     8.680     0.200
     0.278    10.180     0.200
     0.752    14.180     0.200
     1.218    20.977     0.200
     1.254    21.078     0.200
     1.526    24.578     0.200
     1.614    25.379     0.200
     1.621    26.078     0.200
     1.701    27.180     0.200
     1.822    29.180     0.200
     2.022    32.777     0.200
     2.094    33.078     0.200
     2.135    32.977     0.200
     2.050    33.379     0.200
     2.245    34.777     0.200
     2.236    36.078     0.200
     2.640    41.277     0.200
     2.677    41.078     0.200
     2.893    45.078     0.200
     3.186    47.180     0.200
     3.286    50.180     0.200
     3.291    50.078     0.200
     3.420    52.379     0.200
     3.368    53.078     0.200
     3.398    53.680     0.200
     3.623    55.078     0.200
     3.999    60.078     0.200
     4.102    62.078     0.200
     4.462    67.277     0.200
     4.588    68.879     0.200
     4.651    69.277     0.200
     4.793    70.879     0.200
     4.864    73.078     0.200
     5.519    81.078     0.200
     5.598    82.578     0.200
     5.872    86.180     0.200
     6.145    88.180     0.200
     6.164    89.477     0.200
     6.390    90.977     0.200
     6.402    90.680     0.200
     6.574    96.680     0.200
     6.682    95.180     0.200
     6.781    99.477     0.200
     6.801    98.680     0.200
     6.952   100.078     0.200
     6.888    98.379     0.200
     6.914    99.078     0.200
     6.946   100.078     0.200
     6.993   101.078     0.200
     7.137   104.078     0.200
     7.215   103.680     0.200
     7.255   104.078     0.200
     7.347   105.277     0.200
     7.398   105.477     0.200
     7.417   106.078     0.200
     7.544   110.078     0.200
     7.553   111.078     0.200
     7.692   110.078     0.200
     7.831   113.078     0.200
     7.886   110.680     0.200
     8.666   125.078     0.200
     9.406   134.078     0.200
    10.145   143.078     0.200
    11.209   159.277     0.200
    12.333   172.078     0.200
    15.037   207.879     0.200
     0.737    12.840     0.200
     1.023    19.141     0.200
     1.061    19.641     0.200
     1.132    18.941     0.200
     1.269    21.539     0.200
     1.271    22.840     0.200
     1.866    29.840     0.200
     1.924    30.840     0.200
     2.037    32.840     0.200
     2.182    34.840     0.200
     2.298    37.340     0.200
     2.802    42.840     0.200
     2.894    44.539     0.200
     3.465    53.641     0.200
     3.463    52.840     0.200
     3.822    57.340     0.200
     4.451    67.840     0.200
     6.644    99.441     0.200
     8.233   119.141     0.200
     0.146     8.852     0.200
     0.161     9.453     0.200
     0.278     9.852     0.200
     0.731    14.352     0.200
     1.205    21.352     0.200
     1.515    25.250     0.200
     1.600    24.953     0.200
     1.616    25.250     0.200
     1.680    26.953     0.200
     1.824    29.352     0.200
     1.968    30.852     0.200
     2.003    31.953     0.200
     2.075    32.750     0.200
     2.065    33.453     0.200
     2.125    33.453     0.200
     2.236    34.250     0.200
     2.247    36.250     0.200
     2.651    41.453     0.200
     2.696    42.047     0.200
     2.910    45.250     0.200
     3.176    47.852     0.200
     3.305    50.453     0.200
     3.310    50.648     0.200
     3.381    54.250     0.200
     3.416    53.250     0.200
     3.638    55.547     0.200
     4.018    61.453     0.200
     4.118    62.852     0.200
     4.479    67.250     0.200
     4.575    68.852     0.200
     4.668    69.852     0.200
     4.772    70.250     0.200
     5.538    81.453     0.200
     5.888    86.250     0.200
     6.408    90.953     0.200
     6.421    90.852     0.200
     6.816    98.453     0.200
     6.931    99.852     0.200
     6.906    97.547     0.200
     6.931    99.250     0.200
     6.961   101.250     0.200
     7.233   103.250     0.200
     7.366   104.250     0.200
     7.416   105.547     0.200
     7.726   109.453     0.200
     7.847   112.250     0.200
     7.904   111.250     0.200
     8.680   125.250     0.200
     9.420   134.547     0.200
    10.160   143.750     0.200
    11.221   159.250     0.200
    11.369   162.047     0.200
    12.319   171.250     0.200
    18.479   252.453     0.200
    20.755   277.250     0.200
     0.195     9.523     0.200
     0.344    10.719     0.200
     0.729    13.922     0.200
     1.155    20.422     0.200
     1.462    24.320     0.200
     1.655    25.922     0.200
     1.702    26.719     0.200
     1.889    30.523     0.200
     1.982    30.719     0.200
     1.976    31.320     0.200
     2.110    33.320     0.200
     2.069    33.320     0.200
     2.107    34.320     0.200
     2.300    35.320     0.200
     2.705    42.219     0.200
     2.721    42.320     0.200
     2.946    46.320     0.200
     3.330    50.320     0.200
     3.681    55.820     0.200
     4.043    59.320     0.200
     4.704    70.320     0.200
     5.567    81.320     0.200
     5.927    86.320     0.200
     6.448    90.922     0.200
     6.857    99.117     0.200
     6.938    99.320     0.200
     7.004   103.320     0.200
     7.389   105.820     0.200
     7.446   106.320     0.200
     7.885   114.320     0.200
     7.933   111.719     0.200
     8.417   119.320     0.200
     8.726   126.320     0.200
     9.465   134.320     0.200
    11.273   159.523     0.200
    13.129   183.117     0.200
     1.336    23.995     0.200
     1.435    25.995     0.200
     1.809    32.995     0.200
     1.954    33.995     0.200
     1.865    31.995     0.200
     1.984    33.995     0.200
     2.236    38.995     0.200
     2.317    39.995     0.200
     3.136    50.995     0.200
     4.426    70.495     0.200
     4.823    75.995     0.200
     4.823    76.495     0.200
     4.899    76.995     0.200
     6.551    99.695     0.200
     6.684    99.794     0.200
     6.701    98.995     0.200
     0.181     9.242     0.200
     0.328    10.242     0.200
     0.710    14.242     0.200
     1.156    20.445     0.200
     1.465    24.141     0.200
     1.630    26.242     0.200
     1.678    27.242     0.200
     1.875    30.242     0.200
     1.960    30.242     0.200
     1.966    31.242     0.200
     2.084    32.242     0.200
     2.074    33.242     0.200
     2.110    34.242     0.200
     2.277    35.242     0.200
     2.298    38.242     0.200
     2.701    42.242     0.200
     2.731    43.242     0.200
     2.952    46.242     0.200
     3.345    50.242     0.200
     3.684    56.242     0.200
     4.054    61.242     0.200
     4.755    70.344     0.200
     4.710    70.242     0.200
     5.576    82.242     0.200
     5.931    87.242     0.200
     6.445    91.242     0.200
     6.457    90.945     0.200
     6.861    99.641     0.200
     6.946    98.742     0.200
     6.972    99.242     0.200
     7.272   104.242     0.200
     7.454   105.641     0.200
     7.942   111.242     0.200
     8.727   125.242     0.200
    13.107   182.242     0.200
     0.559    11.461     0.200
     0.935    17.062     0.200
     1.378    22.562     0.200
     1.438    23.359     0.200
     1.565    26.359     0.200
     1.698    27.359     0.200
     1.773    28.359     0.200
     1.920    30.359     0.200
     1.881    29.859     0.200
     2.002    32.562     0.200
     1.891    30.156     0.200
     2.033    32.656     0.200
     2.271    36.359     0.200
     2.294    35.859     0.200
     2.498    39.359     0.200
     2.491    39.359     0.200
     2.637    41.359     0.200
     3.092    47.359     0.200
     3.164    49.961     0.200
     3.548    52.359     0.200
     3.548    52.758     0.200
     3.816    59.359     0.200
     3.797    57.359     0.200
     4.389    66.961     0.200
     4.922    74.359     0.200
     5.292    79.359     0.200
     5.934    86.359     0.200
     5.943    87.359     0.200
     6.188    88.258     0.200
     6.517    95.961     0.200
     6.504    93.859     0.200
     6.652    98.562     0.200
     6.645    96.758     0.200
     6.663    95.961     0.200
     7.007   104.359     0.200
     6.981   102.258     0.200
     7.149   103.359     0.200
     7.166   102.859     0.200
     7.560   110.359     0.200
     7.560   108.258     0.200
     7.656   109.359     0.200
     8.005   116.359     0.200
     8.005   116.758     0.200
     8.353   123.359     0.200
    10.867   156.562     0.200
    12.648   178.359     0.200
    12.648   178.758     0.200
    15.338   216.359     0.200
     1.386    23.051     0.200
     1.591    26.851     0.200
     1.845    30.851     0.200
     1.784    28.650     0.200
     1.987    32.851     0.200
     1.875    29.851     0.200
     1.909    30.251     0.200
     2.266    36.450     0.200
     2.277    35.851     0.200
     2.529    38.851     0.200
     2.522    40.251     0.200
     2.651    41.551     0.200
     3.074    48.351     0.200
     3.048    48.450     0.200
     3.351    52.851     0.200
     3.121    47.851     0.200
     3.131    48.351     0.200
     3.183    49.251     0.200
     3.578    53.851     0.200
     3.820    59.851     0.200
     3.824    58.251     0.200
     4.070    61.851     0.200
     4.227    64.351     0.200
     4.401    67.851     0.200
     4.827    73.251     0.200
     4.653    69.851     0.200
     4.939    74.851     0.200
     5.003    77.051     0.200
     5.275    79.851     0.200
     5.312    79.351     0.200
     5.603    83.851     0.200
     5.953    86.650     0.200
     5.968    87.051     0.200
     6.201    89.051     0.200
     6.210    88.450     0.200
     6.331    93.851     0.200
     6.439    95.851     0.200
     6.425    96.851     0.200
     6.465    94.851     0.200
     6.521    96.727     0.200
     6.521    97.051     0.200
     6.534    93.650     0.200
     6.652    99.650     0.200
     6.660    95.650     0.200
     6.676    96.950     0.200
     6.822   101.851     0.200
     6.795    99.851     0.200
     6.999   100.851     0.200
     7.057   104.851     0.200
     7.171   106.851     0.200
     7.218   107.851     0.200
     7.183   103.351     0.200
     7.174   104.851     0.200
     7.254   107.950     0.200
     7.510   107.650     0.200
     7.567   111.150     0.200
     7.577   108.851     0.200
     7.674   110.051     0.200
     7.936   115.751     0.200
     7.815   115.851     0.200
     7.768   111.251     0.200
     7.851   114.851     0.200
     8.104   118.950     0.200
     8.216   120.851     0.200
     8.347   123.851     0.200
     8.439   123.851     0.200
     8.692   128.851     0.200
     8.736   126.851     0.200
     8.892   129.851     0.200
     8.933   129.851     0.200
     9.004   130.851     0.200
     9.111   132.851     0.200
     9.256   135.851     0.200
     9.283   134.851     0.200
     9.483   137.851     0.200
     9.802   144.650     0.200
     9.931   144.851     0.200
     9.962   141.851     0.200
    10.064   145.851     0.200
    10.198   147.851     0.200
    10.215   148.851     0.200
    10.541   151.851     0.200
    10.938   156.851     0.200
    11.072   158.851     0.200
    11.108   161.851     0.200
    11.140   160.851     0.200
    12.655   178.851     0.200
    12.657   178.950     0.200
    12.857   185.450     0.200
    12.971   183.851     0.200
    13.517   193.851     0.200
    14.268   201.851     0.200
    14.375   201.851     0.200
    14.681   208.851     0.200
    15.006   208.450     0.200
    15.343   214.851     0.200
    15.343   211.851     0.200
     0.478    10.374     0.200
     0.809    14.974     0.200
     1.309    20.774     0.200
     1.490    23.274     0.200
     1.473    24.374     0.200
     1.792    28.374     0.200
     1.905    30.974     0.200
     1.898    29.374     0.200
     1.996    30.974     0.200
     2.149    34.374     0.200
     2.398    37.374     0.200
     2.412    38.374     0.200
     2.621    42.374     0.200
     2.763    42.974     0.200
     3.167    50.374     0.200
     3.223    50.374     0.200
     3.232    50.374     0.200
     3.927    60.374     0.200
     4.515    68.374     0.200
     4.742    72.374     0.200
     4.742    72.874     0.200
     5.421    81.374     0.200
     6.639    97.774     0.200
     6.790    98.374     0.200
     7.683   111.374     0.200
     8.467   124.374     0.200
    10.970   157.274     0.200
     1.292    21.439     0.200
     1.492    23.739     0.200
     1.464    24.539     0.200
     1.552    26.239     0.200
     1.783    28.539     0.200
     1.872    29.539     0.200
     1.888    30.539     0.200
     1.883    30.539     0.200
     1.915    30.539     0.200
     2.132    34.539     0.200
     2.411    37.539     0.200
     2.405    37.839     0.200
     2.642    41.539     0.200
     2.782    43.539     0.200
     3.243    49.539     0.200
     3.312    51.539     0.200
     4.533    69.539     0.200
     5.440    81.539     0.200
     6.327    90.639     0.200
     6.655    98.139     0.200
     6.808    99.539     0.200
     8.482   125.539     0.200
     0.546    11.221     0.200
     0.880    16.121     0.200
     1.305    21.121     0.200
     1.427    22.621     0.200
     1.619    27.021     0.200
     1.866    30.021     0.200
     1.828    28.621     0.200
     1.863    29.021     0.200
     1.955    32.021     0.200
     1.922    30.621     0.200
     2.220    35.721     0.200
     2.325    35.922     0.200
     2.483    40.021     0.200
     2.560    41.021     0.200
     2.695    42.021     0.200
     3.027    47.021     0.200
     3.027    47.422     0.200
     3.160    48.021     0.200
     3.225    50.021     0.200
     3.532    53.322     0.200
     3.864    59.021     0.200
     4.271    65.021     0.200
     4.445    67.021     0.200
     5.354    79.021     0.200
     5.648    83.021     0.200
     6.242    88.422     0.200
     6.251    88.521     0.200
     6.567    95.922     0.200
     6.698    98.621     0.200
     6.703    96.021     0.200
     6.720    96.721     0.200
     7.041   102.021     0.200
     7.226   103.121     0.200
     7.300   107.021     0.200
     7.612   111.422     0.200
     7.717   109.021     0.200
     8.394   123.021     0.200
     0.514    10.729     0.200
     0.882    16.229     0.200
     1.363    22.229     0.200
     1.470    23.428     0.200
     1.825    28.729     0.200
     1.925    31.029     0.200
     1.987    31.928     0.200
     2.342    36.729     0.200
     2.689    42.729     0.200
     3.143    48.729     0.200
     3.216    52.729     0.200
     4.442    67.729     0.200
     4.824    72.729     0.200
     4.824    73.328     0.200
     6.569    96.428     0.200
     0.483    10.445     0.200
     0.828    15.445     0.200
     1.327    21.445     0.200
     1.488    24.145     0.200
     1.597    26.043     0.200
     1.482    25.043     0.200
     1.909    29.645     0.200
     1.916    31.043     0.200
     1.928    31.246     0.200
     1.800    28.645     0.200
     1.879    28.645     0.200
     1.983    31.445     0.200
     2.166    34.645     0.200
     2.385    37.344     0.200
     2.420    38.145     0.200
     2.600    41.543     0.200
     2.744    42.645     0.200
     2.966    46.543     0.200
     3.152    50.645     0.200
     3.310    50.645     0.200
     3.201    48.645     0.200
     3.210    49.645     0.200
     3.272    51.844     0.200
     3.469    52.645     0.200
     3.920    60.645     0.200
     3.906    58.844     0.200
     4.157    62.645     0.200
     4.320    66.645     0.200
     4.496    68.645     0.200
     4.765    71.246     0.200
     4.742    71.645     0.200
     4.831    73.645     0.200
     5.380    81.645     0.200
     5.401    80.645     0.200
     5.702    84.746     0.200
     6.042    88.145     0.200
     6.052    88.645     0.200
     6.287    89.746     0.200
     6.297    89.945     0.200
     6.426    94.645     0.200
     6.546    96.645     0.200
     6.525    97.645     0.200
     6.557    98.645     0.200
     6.621    97.145     0.200
     6.613    95.645     0.200
     6.754   100.145     0.200
     6.753    96.945     0.200
     6.904    99.945     0.200
     6.771    98.043     0.200
     6.926   102.645     0.200
     6.882    99.645     0.200
     7.090   102.043     0.200
     7.145   103.844     0.200
     7.266   110.645     0.200
     7.258   105.145     0.200
     7.356   109.746     0.200
     7.596   109.645     0.200
     7.665   111.543     0.200
     7.667   113.645     0.200
     7.668   109.645     0.200
     7.764   110.645     0.200
     8.014   115.145     0.200
     7.946   117.645     0.200
     8.206   120.645     0.200
     8.317   123.645     0.200
     8.452   123.645     0.200
     8.830   127.645     0.200
     9.099   131.645     0.200
     9.196   132.844     0.200
     9.321   132.645     0.200
     9.838   140.145     0.200
     9.717   138.645     0.200
    10.039   145.645     0.200
    10.647   151.645     0.200
    11.050   157.145     0.200
    10.958   157.344     0.200
    11.047   159.645     0.200
    12.153   172.645     0.200
    12.551   177.445     0.200
    12.730   180.645     0.200
    13.472   191.645     0.200
    14.482   202.645     0.200
    15.238   210.645     0.200
     0.462    10.828     0.200
     1.369    21.930     0.200
     1.517    23.730     0.200
     1.626    27.930     0.200
     1.782    28.930     0.200
     1.951    30.930     0.200
     1.952    31.930     0.200
     1.876    30.930     0.200
     2.397    37.930     0.200
     3.188    48.930     0.200
     3.264    53.930     0.200
     4.493    68.930     0.200
     6.622    97.930     0.200
     0.564    11.336     0.200
     0.871    16.039     0.200
     1.262    20.336     0.200
     1.403    22.336     0.200
     1.586    25.836     0.200
     1.827    28.133     0.200
     1.840    28.734     0.200
     1.926    30.836     0.200
     1.875    29.836     0.200
     1.921    31.039     0.200
     2.213    35.836     0.200
     2.322    35.938     0.200
     2.496    39.836     0.200
     2.583    39.836     0.200
     2.709    41.836     0.200
     3.182    48.836     0.200
     3.242    51.836     0.200
     4.285    65.836     0.200
     4.457    66.836     0.200
     4.897    73.836     0.200
     6.260    89.336     0.200
     6.575    96.039     0.200
     6.704    98.836     0.200
     6.733    97.836     0.200
     7.622   110.836     0.200
     8.397   122.836     0.200
    19.292   263.836     0.200
     0.496    10.684     0.200
     0.842    15.785     0.200
     1.477    23.285     0.200
     1.608    26.883     0.200
     1.495    24.984     0.200
     1.906    29.484     0.200
     1.924    30.984     0.200
     1.813    28.984     0.200
     1.865    29.883     0.200
     1.940    30.984     0.200
     1.969    32.984     0.200
     2.371    36.984     0.200
     2.433    38.984     0.200
     2.586    41.984     0.200
     2.730    43.984     0.200
     3.188    49.883     0.200
     4.482    67.984     0.200
     4.777    69.984     0.200
     4.777    70.785     0.200
     4.845    73.984     0.200
     4.845    74.383     0.200
     6.607    98.586     0.200
     6.756    98.984     0.200
     7.750   111.984     0.200
     8.008   116.984     0.200
     8.008   117.684     0.200
     9.834   141.984     0.200
    10.944   156.785     0.200
    20.432   278.984     0.200
     0.610    12.332     0.200
     0.859    16.633     0.200
     1.171    20.230     0.200
     1.358    22.832     0.200
     1.520    25.934     0.200
     1.744    28.332     0.200
     1.801    30.332     0.200
     1.870    30.332     0.200
     1.866    31.332     0.200
     1.920    31.332     0.200
     1.903    30.332     0.200
     2.200    36.133     0.200
     2.319    36.832     0.200
     2.527    40.332     0.200
     2.633    41.332     0.200
     2.741    43.332     0.200
     3.228    49.434     0.200
     3.240    50.332     0.200
     3.279    51.832     0.200
     3.894    61.332     0.200
     3.928    59.332     0.200
     4.315    66.332     0.200
     4.484    68.332     0.200
     5.406    80.832     0.200
     5.679    84.730     0.200
     6.308    90.031     0.200
     6.593    97.633     0.200
     6.748    97.332     0.200
     7.275   105.332     0.200
     8.403   124.031     0.200
     9.148   132.332     0.200
    10.884   156.934     0.200
     1.371    22.461     0.200
     1.510    24.859     0.200
     1.474    24.762     0.200
     1.634    26.961     0.200
     1.791    28.762     0.200
     1.865    29.160     0.200
     1.949    29.961     0.200
     1.962    31.961     0.200
     2.178    35.961     0.200
     2.387    36.961     0.200
     2.409    37.961     0.200
     2.575    39.961     0.200
     2.728    42.961     0.200
     3.177    49.160     0.200
     3.186    49.961     0.200
     3.254    51.461     0.200
     3.421    52.859     0.200
     3.884    58.961     0.200
     4.304    64.961     0.200
     4.482    67.961     0.200
     5.382    80.160     0.200
     6.024    87.961     0.200
     6.030    85.961     0.200
     6.266    88.961     0.200
     6.276    89.461     0.200
     6.611    97.359     0.200
     6.736    96.961     0.200
     6.746    99.961     0.200
     6.755    96.961     0.200
     7.072   102.859     0.200
     7.235   103.961     0.200
     7.256   104.262     0.200
     7.746   110.961     0.200
     8.448   124.961     0.200
    10.960   158.062     0.200
     0.664    13.219     0.200
     0.962    17.818     0.200
     1.237    21.119     0.200
     1.306    22.520     0.200
     1.631    27.119     0.200
     1.763    28.318     0.200
     1.758    28.818     0.200
     1.979    32.119     0.200
     1.976    32.119     0.200
     2.225    36.119     0.200
     2.520    39.318     0.200
     2.629    42.119     0.200
     3.114    48.119     0.200
     3.166    51.920     0.200
     3.292    51.520     0.200
     4.373    67.119     0.200
     6.486    96.119     0.200
     0.870    16.180     0.200
     1.226    20.480     0.200
     1.381    23.781     0.200
     1.563    26.078     0.200
     1.792    28.781     0.200
     1.852    30.680     0.200
     1.847    29.879     0.200
     1.905    31.180     0.200
     1.915    30.680     0.200
     1.890    30.680     0.200
     2.212    36.680     0.200
     2.316    36.680     0.200
     2.512    39.680     0.200
     2.599    40.680     0.200
     2.717    42.680     0.200
     3.196    49.879     0.200
     3.252    51.379     0.200
     3.383    52.781     0.200
     3.897    60.680     0.200
     4.292    66.680     0.200
     4.463    68.680     0.200
     5.380    80.680     0.200
     6.271    89.680     0.200
     6.280    89.781     0.200
     6.577    97.281     0.200
     6.705    99.879     0.200
     6.725    97.078     0.200
     6.740    97.680     0.200
     7.626   111.680     0.200
     8.394   125.680     0.200
     9.139   132.680     0.200
     9.721   142.680     0.200
    11.016   159.480     0.200
     0.507    10.820     0.200
     0.823    15.727     0.200
     1.283    21.320     0.200
     1.567    26.227     0.200
     1.499    25.125     0.200
     1.867    29.023     0.200
     1.878    31.125     0.200
     1.901    31.422     0.200
     1.818    29.125     0.200
     1.885    30.023     0.200
     1.975    32.023     0.200
     2.164    35.023     0.200
     2.376    38.023     0.200
     2.439    38.023     0.200
     2.617    41.023     0.200
     2.752    43.023     0.200
     2.977    47.023     0.200
     3.149    51.820     0.200
     3.217    50.023     0.200
     3.227    50.023     0.200
     3.283    52.023     0.200
     3.431    52.922     0.200
     3.487    52.820     0.200
     3.921    60.023     0.200
     4.328    67.023     0.200
     4.502    69.023     0.200
     4.841    74.023     0.200
     5.412    81.023     0.200
     5.705    85.023     0.200
     6.066    88.023     0.200
     6.300    90.023     0.200
     6.309    90.625     0.200
     6.433    96.023     0.200
     6.623    98.227     0.200
     6.630    96.125     0.200
     6.754   100.922     0.200
     6.761    97.922     0.200
     6.778    99.023     0.200
     7.099   103.727     0.200
     7.272   105.922     0.200
     7.284   105.625     0.200
     7.356   109.023     0.200
     7.669   113.023     0.200
     7.678   111.320     0.200
     7.974   116.422     0.200
     8.449   125.023     0.200
     9.193   134.023     0.200
    10.029   145.023     0.200
    11.021   156.820     0.200
    10.948   158.227     0.200
    12.689   179.023     0.200
     0.204     7.172     0.200
     0.607    12.172     0.200
     0.896    16.469     0.200
     1.228    19.672     0.200
     1.359    22.867     0.200
     1.582    25.570     0.200
     1.595    26.266     0.200
     1.783    27.969     0.200
     1.926    29.969     0.200
     1.822    28.969     0.200
     1.889    30.469     0.200
     1.915    30.070     0.200
     2.238    34.969     0.200
     2.290    34.969     0.200
     2.537    39.469     0.200
     2.576    39.969     0.200
     2.692    42.570     0.200
     3.068    46.969     0.200
     3.068    47.367     0.200
     3.173    47.969     0.200
     3.227    51.469     0.200
     3.357    51.969     0.200
     3.584    52.969     0.200
     3.584    53.766     0.200
     3.873    58.969     0.200
     4.267    64.969     0.200
     4.437    66.969     0.200
     4.931    74.367     0.200
     6.247    88.969     0.200
     6.256    87.969     0.200
     6.551    96.070     0.200
     6.679    97.969     0.200
     6.700    95.672     0.200
     7.225   102.172     0.200
     7.600   110.969     0.200
     7.882   115.969     0.200
     8.368   123.969     0.200
     0.609    12.268     0.200
     1.279    20.868     0.200
     1.365    22.968     0.200
     1.635    26.668     0.200
     1.606    26.668     0.200
     1.819    28.668     0.200
     1.782    28.168     0.200
     1.865    29.968     0.200
     1.977    31.668     0.200
     1.924    30.368     0.200
     2.267    35.668     0.200
     2.270    36.668     0.200
     2.528    38.668     0.200
     2.545    39.668     0.200
     2.651    41.668     0.200
     3.041    48.668     0.200
     3.126    47.668     0.200
     3.136    48.668     0.200
     3.185    49.868     0.200
     3.817    60.068     0.200
     3.828    58.668     0.200
     4.227    64.668     0.200
     4.399    66.668     0.200
     4.950    75.168     0.200
     5.313    78.668     0.200
     5.600    83.668     0.200
     5.954    86.668     0.200
     6.203    88.568     0.200
     6.212    88.568     0.200
     6.517    96.068     0.200
     6.647    98.568     0.200
     6.660    95.968     0.200
     6.676    96.668     0.200
     6.999   100.668     0.200
     7.184   103.168     0.200
     7.564   109.668     0.200
     7.675   108.668     0.200
     7.910   115.668     0.200
     7.910   115.968     0.200
     8.340   121.668     0.200
     9.746   139.668     0.200
    10.838   155.468     0.200
    12.666   177.668     0.200
    12.666   178.568     0.200
     1.246    21.258     0.200
     1.400    24.158     0.200
     1.571    26.758     0.200
     1.555    26.758     0.200
     1.814    29.758     0.200
     1.865    30.857     0.200
     1.850    30.758     0.200
     1.911    31.758     0.200
     1.926    31.758     0.200
     1.874    29.758     0.200
     2.205    36.758     0.200
     2.327    36.758     0.200
     2.496    40.758     0.200
     2.597    40.758     0.200
     2.719    42.758     0.200
     3.105    50.758     0.200
     3.194    49.758     0.200
     3.205    50.758     0.200
     3.253    51.658     0.200
     3.883    61.758     0.200
     3.896    58.758     0.200
     4.295    66.758     0.200
     4.467    68.758     0.200
     4.893    74.758     0.200
     5.382    80.758     0.200
     5.667    84.758     0.200
     6.272    89.758     0.200
     6.281    90.458     0.200
     6.583    97.558     0.200
     6.712    99.958     0.200
     6.743    97.758     0.200
     7.631   112.758     0.200
     7.743   111.758     0.200
     8.403   122.758     0.200
     9.743   141.758     0.200
    12.633   178.758     0.200
    20.366   279.458     0.200
     0.669    13.293     0.200
     0.937    17.793     0.200
     1.186    20.691     0.200
     1.582    27.393     0.200
     1.652    27.492     0.200
     1.724    28.691     0.200
     1.847    31.393     0.200
     1.793    29.191     0.200
     1.843    30.691     0.200
     1.932    32.492     0.200
     1.972    31.492     0.200
     2.278    37.393     0.200
     2.242    36.393     0.200
     2.595    41.492     0.200
     2.564    41.293     0.200
     2.665    42.492     0.200
     3.030    49.492     0.200
     3.157    49.191     0.200
     3.169    49.393     0.200
     3.204    50.793     0.200
     3.321    51.492     0.200
     3.641    54.492     0.200
     3.641    54.793     0.200
     3.816    60.492     0.200
     3.855    59.492     0.200
     4.239    65.492     0.200
     4.407    67.492     0.200
     4.771    72.691     0.200
     4.982    76.992     0.200
     5.331    79.492     0.200
     6.225    89.293     0.200
     6.233    89.393     0.200
     6.515    97.092     0.200
     6.640    99.592     0.200
     6.685    97.492     0.200
     7.013   102.691     0.200
     7.199   103.492     0.200
     7.203   103.992     0.200
     7.566   110.492     0.200
     7.820   115.691     0.200
     8.325   123.592     0.200
     8.680   126.492     0.200
     8.680   127.293     0.200
     9.652   140.492     0.200
     9.890   144.492     0.200
    10.809   156.293     0.200
    12.537   174.492     0.200
    12.687   178.492     0.200
     0.230     9.848     0.200
     0.324    10.047     0.200
     0.761    14.246     0.200
     1.497    25.047     0.200
     1.657    25.246     0.200
     1.726    27.648     0.200
     1.865    30.648     0.200
     2.009    30.945     0.200
     2.070    35.047     0.200
     2.292    35.547     0.200
     2.671    42.047     0.200
     3.293    50.047     0.200
     3.411    53.047     0.200
     3.645    55.445     0.200
     4.806    70.445     0.200
     5.890    86.246     0.200
     6.820    99.246     0.200
     7.848   115.047     0.200
     8.690   126.047     0.200
     0.769    15.135     0.200
     1.234    21.035     0.200
     1.499    25.635     0.200
     1.473    24.935     0.200
     1.470    25.635     0.200
     1.841    29.635     0.200
     1.833    30.635     0.200
     1.943    31.535     0.200
     2.419    39.635     0.200
     2.683    43.635     0.200
     3.282    51.635     0.200
     3.345    53.635     0.200
     4.560    69.935     0.200
     4.802    73.635     0.200
     4.802    73.935     0.200
     6.362    91.635     0.200
     6.678    99.335     0.200
     0.733    14.406     0.200
     1.258    20.707     0.200
     1.490    24.605     0.200
     1.426    24.508     0.200
     1.518    24.605     0.200
     1.820    30.406     0.200
     1.746    28.406     0.200
     1.878    29.406     0.200
     1.976    31.605     0.200
     2.074    35.406     0.200
     2.460    39.008     0.200
     3.307    51.406     0.200
     3.520    55.105     0.200
     4.593    70.406     0.200
     6.390    91.406     0.200
     6.713    99.406     0.200
     6.843   103.406     0.200
     6.868   101.406     0.200
     7.759   114.406     0.200
     0.465    10.432     0.200
     0.851    16.132     0.200
     1.393    22.932     0.200
     1.470    25.132     0.200
     1.522    23.432     0.200
     1.787    28.832     0.200
     1.859    29.731     0.200
     1.969    31.932     0.200
     1.979    32.932     0.200
     1.978    32.832     0.200
     2.183    35.231     0.200
     2.388    36.932     0.200
     2.404    38.632     0.200
     2.563    40.032     0.200
     2.721    43.032     0.200
     2.961    46.932     0.200
     3.144    50.932     0.200
     3.166    48.731     0.200
     3.175    48.932     0.200
     3.245    50.231     0.200
     3.417    52.832     0.200
     3.873    57.832     0.200
     4.127    62.932     0.200
     4.297    65.432     0.200
     4.475    67.632     0.200
     4.715    70.932     0.200
     4.813    71.932     0.200
     4.828    72.932     0.200
     4.828    73.432     0.200
     5.374    80.632     0.200
     5.373    79.231     0.200
     5.684    84.231     0.200
     6.015    87.932     0.200
     6.020    87.932     0.200
     6.256    89.032     0.200
     6.267    88.932     0.200
     6.404    93.932     0.200
     6.545    97.932     0.200
     6.577    94.932     0.200
     6.606    97.231     0.200
     6.729    96.731     0.200
     6.742    99.632     0.200
     6.748    97.432     0.200
     6.955   103.832     0.200
     7.064   100.332     0.200
     7.225   103.932     0.200
     7.248   104.432     0.200
     7.318   109.932     0.200
     7.345   108.932     0.200
     7.641   108.932     0.200
     7.648   110.932     0.200
     7.738   109.932     0.200
     7.923   116.932     0.200
     8.325   121.932     0.200
     8.446   124.032     0.200
     8.726   126.932     0.200
     8.726   127.332     0.200
     9.188   132.932     0.200
     9.898   142.932     0.200
    10.643   151.932     0.200
    10.961   157.532     0.200
    11.417   164.832     0.200
    12.555   177.932     0.200
    12.555   178.632     0.200
    12.786   181.332     0.200
    14.480   202.432     0.200
    15.247   212.932     0.200
     0.851    16.133     0.200
     1.557    23.734     0.200
     1.763    28.834     0.200
     2.010    32.133     0.200
     1.866    29.633     0.200
     2.408    36.934     0.200
     2.558    39.633     0.200
     2.725    43.234     0.200
     3.162    48.633     0.200
     3.246    51.934     0.200
     3.428    53.434     0.200
     3.914    61.934     0.200
     4.481    67.934     0.200
     5.692    84.934     0.200
     6.615    97.533     0.200
     6.753   100.934     0.200
     7.655   111.934     0.200
     0.726    14.078     0.200
     1.268    20.676     0.200
     1.530    23.578     0.200
     1.491    24.879     0.200
     1.414    24.277     0.200
     1.889    29.777     0.200
     1.734    27.777     0.200
     1.819    29.676     0.200
     1.982    31.477     0.200
     2.067    33.578     0.200
     2.470    38.176     0.200
     2.357    37.879     0.200
     2.709    41.879     0.200
     3.310    51.676     0.200
     3.320    51.078     0.200
     4.015    61.777     0.200
     4.599    69.777     0.200
     5.507    81.777     0.200
     5.802    85.777     0.200
     6.395    91.379     0.200
     6.404    91.578     0.200
     6.720    98.777     0.200
     6.851   101.477     0.200
     6.858    98.777     0.200
     6.875    99.777     0.200
     7.195   105.078     0.200
     7.766   112.777     0.200
     7.774   112.176     0.200
     7.871   112.379     0.200
     8.544   125.777     0.200
     0.368    10.328     0.200
     0.746    14.125     0.200
     1.148    20.328     0.200
     1.453    24.328     0.200
     1.685    26.125     0.200
     1.727    27.328     0.200
     1.911    30.328     0.200
     2.004    30.930     0.200
     2.110    33.930     0.200
     2.329    34.828     0.200
     2.716    42.125     0.200
     2.947    45.328     0.200
     3.325    50.227     0.200
     3.686    56.328     0.200
     4.513    68.328     0.200
     4.704    70.328     0.200
     5.928    86.328     0.200
     6.430    91.328     0.200
     6.443    90.828     0.200
     6.859    99.727     0.200
     6.936    99.531     0.200
     6.964   100.328     0.200
     7.261   104.625     0.200
     7.443   106.125     0.200
     7.886   115.328     0.200
     7.930   112.328     0.200
     8.732   125.328     0.200
     0.070     8.832     0.200
     0.367    10.734     0.200
     0.770    15.031     0.200
     1.420    22.434     0.200
     1.373    23.234     0.200
     1.614    26.133     0.200
     1.613    25.734     0.200
     1.689    27.133     0.200
     1.930    30.332     0.200
     2.027    31.133     0.200
     1.948    31.133     0.200
     2.095    33.133     0.200
     2.082    33.133     0.200
     2.306    35.234     0.200
     2.637    40.133     0.200
     2.807    44.133     0.200
     3.242    49.031     0.200
     3.249    50.133     0.200
     3.328    52.832     0.200
     3.356    49.133     0.200
     3.356    49.934     0.200
     3.509    53.133     0.200
     3.950    58.133     0.200
     4.382    66.133     0.200
     4.563    68.133     0.200
     4.758    69.133     0.200
     4.758    70.031     0.200
     4.731    71.133     0.200
     4.731    71.434     0.200
     6.098    88.633     0.200
     6.336    89.434     0.200
     6.346    89.633     0.200
     6.697    95.133     0.200
     6.834    97.832     0.200
     7.147   101.633     0.200
     7.302   105.633     0.200
     7.737   112.934     0.200
     7.820   109.434     0.200
     9.956   140.434     0.200
    12.460   176.133     0.200
    12.460   177.031     0.200
    12.852   180.133     0.200
     0.222     7.236     0.200
     0.623    12.036     0.200
     0.904    16.835     0.200
     1.214    20.236     0.200
     1.343    21.736     0.200
     1.578    26.036     0.200
     1.766    28.036     0.200
     1.817    28.536     0.200
     1.879    32.036     0.200
     1.924    30.536     0.200
     1.929    29.835     0.200
     2.246    35.736     0.200
     2.279    36.036     0.200
     2.551    39.936     0.200
     2.576    39.736     0.200
     2.687    41.036     0.200
     3.172    48.636     0.200
     3.183    49.036     0.200
     3.224    51.036     0.200
     3.350    51.736     0.200
     3.598    54.036     0.200
     4.432    66.835     0.200
     4.764    71.036     0.200
     4.764    71.136     0.200
     4.943    75.236     0.200
     6.244    88.036     0.200
     6.253    88.436     0.200
     6.544    96.335     0.200
     6.671    99.036     0.200
     6.709    97.036     0.200
     7.036   102.835     0.200
     8.359   123.036     0.200
    18.583   254.036     0.200
    19.246   262.036     0.200
     0.053     8.779     0.200
     0.387    10.580     0.200
     0.796    14.881     0.200
     1.429    21.881     0.200
     1.393    23.080     0.200
     1.636    25.580     0.200
     1.600    25.381     0.200
     1.709    26.980     0.200
     1.982    30.580     0.200
     2.028    30.580     0.200
     1.923    30.980     0.200
     2.121    32.980     0.200
     2.060    33.080     0.200
     2.326    35.080     0.200
     2.463    38.680     0.200
     2.611    40.480     0.200
     2.782    43.480     0.200
     3.215    50.580     0.200
     3.216    48.580     0.200
     3.224    49.881     0.200
     3.302    52.381     0.200
     3.376    49.580     0.200
     3.376    49.779     0.200
     3.485    53.381     0.200
     3.925    59.580     0.200
     3.971    60.980     0.200
     4.357    65.580     0.200
     4.538    67.779     0.200
     4.753    71.381     0.200
     4.772    71.580     0.200
     5.445    80.779     0.200
     5.430    79.580     0.200
     5.431    78.580     0.200
     5.749    84.381     0.200
     6.072    87.580     0.200
     6.310    89.279     0.200
     6.321    89.279     0.200
     6.466    95.580     0.200
     6.618    97.680     0.200
     6.624    94.580     0.200
     6.673    97.279     0.200
     6.810    99.779     0.200
     6.788    96.779     0.200
     6.809    97.279     0.200
     6.909   101.580     0.200
     7.121   102.580     0.200
     7.276   103.680     0.200
     7.305   104.080     0.200
     7.390   107.580     0.200
     7.414   108.279     0.200
     7.712   110.980     0.200
     7.699   108.881     0.200
     7.795   109.580     0.200
     8.134   115.580     0.200
     7.984   115.580     0.200
     8.263   119.279     0.200
     8.517   123.580     0.200
     8.700   124.580     0.200
     9.138   129.580     0.200
     9.259   131.480     0.200
     9.361   132.580     0.200
     9.957   141.580     0.200
    10.117   143.881     0.200
    10.153   147.580     0.200
    10.715   151.180     0.200
    11.037   156.680     0.200
    11.131   161.180     0.200
    12.237   172.480     0.200
    12.483   173.580     0.200
    12.483   174.480     0.200
    12.849   179.180     0.200
    14.553   201.779     0.200
     1.365    23.049     0.200
     1.570    26.850     0.200
     1.579    25.750     0.200
     1.707    27.750     0.200
     1.891    31.648     0.200
     1.976    31.949     0.200
     1.956    31.850     0.200
     2.087    34.049     0.200
     2.326    36.549     0.200
     2.476    39.549     0.200
     2.660    42.148     0.200
     2.819    44.549     0.200
     3.263    51.049     0.200
     3.343    53.350     0.200
     3.512    54.850     0.200
     3.971    60.449     0.200
     4.394    68.449     0.200
     4.573    70.549     0.200
     4.740    72.449     0.200
     5.471    82.449     0.200
     5.781    86.449     0.200
     6.354    91.850     0.200
     6.364    91.949     0.200
     6.702   100.449     0.200
     6.826    99.949     0.200
     6.837   101.449     0.200
     6.846   100.648     0.200
     7.161   103.449     0.200
     7.744   115.449     0.200
     8.539   128.449     0.200
     9.904   146.049     0.200
    11.048   160.549     0.200
     0.157    10.758     0.200
     0.280    11.957     0.200
     0.617    13.160     0.200
     1.162    20.859     0.200
     1.503    23.660     0.200
     1.554    24.457     0.200
     1.478    24.359     0.200
     1.812    29.359     0.200
     1.912    30.258     0.200
     1.953    30.059     0.200
     2.096    32.559     0.200
     2.167    33.160     0.200
     2.139    34.660     0.200
     2.290    37.059     0.200
     2.656    40.859     0.200
     2.694    42.059     0.200
     2.796    42.660     0.200
     2.992    46.359     0.200
     3.146    47.758     0.200
     3.404    51.457     0.200
     3.441    53.359     0.200
     3.410    51.457     0.200
     3.505    54.059     0.200
     3.706    56.258     0.200
     4.115    60.957     0.200
     4.190    63.957     0.200
     4.523    68.059     0.200
     4.651    67.859     0.200
     4.565    68.359     0.200
     4.749    70.559     0.200
     5.618    81.059     0.200
     5.630    82.660     0.200
     5.672    83.359     0.200
     5.965    87.160     0.200
     6.263    90.059     0.200
     6.273    90.258     0.200
     6.504    91.957     0.200
     6.516    91.859     0.200
     6.676    97.059     0.200
     6.847    98.758     0.200
     6.805    98.059     0.200
     6.891    99.957     0.200
     6.994    99.957     0.200
     7.031   102.258     0.200
     7.017    99.859     0.200
     7.324   104.859     0.200
     7.465   106.957     0.200
     7.637   111.059     0.200
     7.900   111.059     0.200
     7.927   113.957     0.200
     7.996   112.160     0.200
     8.485   124.160     0.200
     8.743   127.059     0.200
    10.090   142.559     0.200
    11.267   158.957     0.200
    12.257   169.758     0.200
    12.999   179.859     0.200
    14.782   204.258     0.200
     0.519    11.082     0.200
     0.833    15.684     0.200
     1.279    21.184     0.200
     1.448    23.184     0.200
     1.572    26.383     0.200
     1.511    26.184     0.200
     1.859    30.184     0.200
     1.907    31.285     0.200
     1.830    30.184     0.200
     1.875    29.484     0.200
     1.963    31.285     0.200
     2.174    35.082     0.200
     2.365    36.984     0.200
     2.451    39.184     0.200
     2.610    40.184     0.200
     2.743    42.484     0.200
     3.209    49.285     0.200
     3.219    49.184     0.200
     3.274    52.383     0.200
     3.420    53.184     0.200
     3.912    61.184     0.200
     3.913    60.184     0.200
     4.319    66.184     0.200
     4.492    68.184     0.200
     4.745    72.184     0.200
     4.853    73.684     0.200
     5.403    80.184     0.200
     5.695    84.184     0.200
     6.291    90.184     0.200
     6.613    97.383     0.200
     6.743   100.184     0.200
     6.768    98.184     0.200
     7.659   112.184     0.200
     7.765   111.184     0.200
     8.438   125.184     0.200
     0.461    12.555     0.200
     0.257    12.352     0.200
     0.693    16.750     0.200
     0.750    15.656     0.200
     1.066    19.156     0.200
     1.510    24.453     0.200
     1.568    25.352     0.200
     1.724    27.750     0.200
     1.685    26.852     0.200
     1.991    31.453     0.200
     2.207    35.453     0.200
     2.248    35.352     0.200
     2.466    38.453     0.200
     2.526    39.656     0.200
     2.734    41.656     0.200
     2.701    42.453     0.200
     3.187    48.453     0.200
     3.105    47.656     0.200
     3.131    47.055     0.200
     3.366    51.156     0.200
     3.741    55.750     0.200
     3.744    55.852     0.200
     3.843    59.156     0.200
     3.866    58.750     0.200
     4.115    61.953     0.200
     4.115    61.852     0.200
     4.100    61.352     0.200
     4.455    64.656     0.200
     4.454    66.555     0.200
     4.579    68.953     0.200
     4.731    71.453     0.200
     4.933    72.852     0.200
     5.124    75.352     0.200
     5.329    79.453     0.200
     5.948    84.750     0.200
     5.983    86.953     0.200
     6.073    88.453     0.200
     6.347    91.852     0.200
     6.626    94.656     0.200
     6.599    94.453     0.200
     6.627    94.852     0.200
     6.860    96.352     0.200
     7.045   102.453     0.200
     7.123   100.852     0.200
     7.156   104.453     0.200
     7.254   105.453     0.200
     7.277   104.555     0.200
     7.356   104.453     0.200
     7.423   107.352     0.200
     7.680   109.656     0.200
     7.714   113.453     0.200
     7.797   111.250     0.200
     7.862   111.352     0.200
     8.019   116.453     0.200
     8.030   115.453     0.200
     8.353   118.555     0.200
     8.145   115.750     0.200
     8.254   117.453     0.200
     8.305   119.055     0.200
     8.600   123.453     0.200
     8.557   121.453     0.200
     8.876   127.453     0.200
     9.142   131.453     0.200
     9.279   132.453     0.200
     9.442   134.453     0.200
     9.713   136.453     0.200
     9.882   139.453     0.200
     9.937   138.953     0.200
    10.093   145.453     0.200
    10.352   145.453     0.200
    10.244   143.453     0.200
    10.794   152.156     0.200
    10.758   152.156     0.200
    11.345   158.555     0.200
    11.677   163.953     0.200
    11.857   163.055     0.200
    13.289   183.250     0.200
    15.187   208.453     0.200
     0.600    12.039     0.200
     0.833    16.438     0.200
     1.372    22.738     0.200
     1.565    26.238     0.200
     1.739    28.641     0.200
     1.835    30.141     0.200
     1.886    29.840     0.200
     1.899    29.539     0.200
     1.945    31.539     0.200
     2.173    35.539     0.200
     2.344    36.938     0.200
     2.510    39.039     0.200
     2.664    41.539     0.200
     2.770    43.539     0.200
     3.259    49.539     0.200
     3.270    50.539     0.200
     3.426    52.539     0.200
     3.922    61.238     0.200
     4.513    68.141     0.200
     5.707    83.539     0.200
     6.329    90.039     0.200
     6.621    97.539     0.200
     6.745    99.539     0.200
     6.791    97.438     0.200
     7.672   111.641     0.200
     8.429   124.340     0.200
     0.193     9.516     0.200
     0.306    10.617     0.200
     0.715    13.918     0.200
     1.176    20.516     0.200
     1.485    24.316     0.200
     1.614    25.516     0.200
     1.675    26.516     0.200
     1.959    30.316     0.200
     1.852    30.016     0.200
     1.979    31.516     0.200
     2.076    32.316     0.200
     2.095    32.316     0.200
     2.093    33.715     0.200
     2.257    34.617     0.200
     2.277    36.316     0.200
     2.679    41.516     0.200
     2.681    42.016     0.200
     2.719    41.516     0.200
     2.936    45.617     0.200
     3.146    47.816     0.200
     3.328    50.215     0.200
     3.333    50.418     0.200
     3.666    55.715     0.200
     4.041    59.816     0.200
     4.545    68.316     0.200
     4.759    70.215     0.200
     4.694    69.816     0.200
     4.907    73.316     0.200
     5.540    80.117     0.200
     5.562    81.516     0.200
     5.640    83.215     0.200
     5.915    86.516     0.200
     6.188    89.316     0.200
     6.206    89.316     0.200
     6.432    91.016     0.200
     6.445    90.918     0.200
     6.617    95.918     0.200
     6.723    95.316     0.200
     6.732    99.316     0.200
     6.919    99.316     0.200
     6.823   100.316     0.200
     6.844    99.316     0.200
     6.932    98.617     0.200
     6.957    99.418     0.200
     6.989   101.816     0.200
     7.258   103.215     0.200
     7.389   105.215     0.200
     7.596   110.316     0.200
     7.874   113.715     0.200
     7.928   111.316     0.200
     8.375   119.316     0.200
     8.709   126.016     0.200
     9.959   141.316     0.200
    10.184   144.516     0.200
    10.331   148.316     0.200
    10.913   154.016     0.200
    11.250   159.617     0.200
    12.290   170.215     0.200
    12.457   175.617     0.200
    13.086   182.316     0.200
    14.586   202.117     0.200
    14.724   202.117     0.200
    14.755   204.215     0.200
    14.994   207.316     0.200
     0.569    11.473     0.200
     1.076    19.072     0.200
     1.392    23.572     0.200
     1.550    24.973     0.200
     1.543    24.672     0.200
     1.819    28.672     0.200
     1.841    30.473     0.200
     1.897    30.172     0.200
     1.961    31.473     0.200
     2.009    33.072     0.200
     2.232    34.771     0.200
     2.217    35.373     0.200
     2.780    43.271     0.200
     2.861    44.373     0.200
     3.067    48.072     0.200
     3.469    52.873     0.200
     3.787    57.873     0.200
     4.181    63.172     0.200
     4.825    72.473     0.200
     5.700    83.973     0.200
     6.584    93.572     0.200
     6.969   103.072     0.200
     7.066   101.873     0.200
     7.577   107.672     0.200
    20.441   281.572     0.200
     0.062     7.672     0.200
     0.392     9.971     0.200
     0.525    10.971     0.200
     1.050    18.871     0.200
     1.368    22.771     0.200
     1.504    24.172     0.200
     1.531    23.971     0.200
     1.778    27.771     0.200
     1.802    29.172     0.200
     1.927    30.570     0.200
     1.910    30.271     0.200
     1.987    31.371     0.200
     2.224    33.971     0.200
     2.253    35.871     0.200
     2.808    43.570     0.200
     2.902    44.371     0.200
     3.104    47.672     0.200
     3.510    52.672     0.200
     3.516    52.871     0.200
     3.821    57.771     0.200
     4.862    71.871     0.200
     7.005   101.871     0.200
     0.225     9.688     0.200
     0.279    10.188     0.200
     0.741    14.289     0.200
     1.210    21.086     0.200
     1.520    24.789     0.200
     1.607    25.188     0.200
     1.690    26.789     0.200
     1.619    25.688     0.200
     1.824    29.289     0.200
     1.978    30.688     0.200
     2.012    32.188     0.200
     2.084    32.188     0.200
     2.129    32.789     0.200
     2.058    33.086     0.200
     2.241    34.188     0.200
     2.243    36.188     0.200
     2.713    41.984     0.200
     2.647    41.484     0.200
     2.688    41.586     0.200
     2.902    45.086     0.200
     3.180    47.086     0.200
     3.409    51.688     0.200
     3.297    50.086     0.200
     3.301    49.891     0.200
     3.376    52.688     0.200
     3.408    53.289     0.200
     3.631    55.086     0.200
     4.009    60.086     0.200
     4.111    63.289     0.200
     4.472    67.086     0.200
     4.782    70.688     0.200
     4.660    69.188     0.200
     5.301    79.688     0.200
     5.509    80.688     0.200
     5.529    81.188     0.200
     5.606    82.391     0.200
     5.881    85.891     0.200
     6.156    89.289     0.200
     6.400    90.984     0.200
     6.699    97.984     0.200
     6.692    95.891     0.200
     6.941   100.086     0.200
     6.789    99.586     0.200
     6.810    98.586     0.200
     6.898    98.586     0.200
     6.924    98.984     0.200
     6.955   101.789     0.200
     7.225   103.188     0.200
     7.357   106.289     0.200
     7.408   104.688     0.200
     7.562   110.586     0.200
     7.840   113.188     0.200
     7.865   112.789     0.200
     7.896   111.391     0.200
     8.098   116.484     0.200
     8.355   117.688     0.200
     8.693   125.688     0.200
     8.674   125.891     0.200
     9.446   131.586     0.200
    10.169   143.789     0.200
    11.216   157.891     0.200
    12.325   172.688     0.200
    13.068   181.891     0.200
    14.564   202.289     0.200
    14.702   202.289     0.200
    16.681   228.789     0.200
     0.598    11.986     0.200
     0.922    18.086     0.200
     1.286    21.686     0.200
     1.376    22.486     0.200
     1.596    27.086     0.200
     1.829    28.986     0.200
     1.788    29.186     0.200
     1.874    31.286     0.200
     1.914    30.186     0.200
     1.976    32.786     0.200
     2.264    36.286     0.200
     2.276    36.186     0.200
     2.535    40.586     0.200
     2.531    38.886     0.200
     2.656    42.486     0.200
     3.129    47.885     0.200
     3.139    49.486     0.200
     3.331    51.885     0.200
     4.405    67.486     0.200
     6.524    97.686     0.200
     0.656    12.688     0.200
     0.906    16.586     0.200
     1.078    16.586     0.200
     1.162    18.586     0.200
     1.311    20.785     0.200
     1.545    25.688     0.200
     1.715    25.887     0.200
     1.631    27.086     0.200
     1.813    29.387     0.200
     1.895    30.688     0.200
     1.829    29.387     0.200
     1.952    30.387     0.200
     2.246    36.188     0.200
     2.272    35.887     0.200
     2.575    40.188     0.200
     2.601    40.484     0.200
     2.700    42.484     0.200
     3.194    49.188     0.200
     3.206    49.285     0.200
     3.354    51.785     0.200
     4.442    66.887     0.200
     5.367    79.586     0.200
     6.269    89.586     0.200
     6.548    94.586     0.200
     7.656   112.387     0.200
     0.223     9.773     0.200
     0.294    10.273     0.200
     0.744    14.273     0.200
     1.202    21.172     0.200
     1.510    24.977     0.200
     1.622    25.172     0.200
     1.699    26.773     0.200
     1.838    29.477     0.200
     1.985    30.773     0.200
     2.009    32.273     0.200
     2.096    31.375     0.200
     2.064    33.078     0.200
     2.118    33.273     0.200
     2.257    34.172     0.200
     2.253    36.078     0.200
     2.656    41.375     0.200
     2.689    41.578     0.200
     2.907    44.977     0.200
     3.298    50.078     0.200
     3.303    50.078     0.200
     3.638    54.773     0.200
     4.011    60.172     0.200
     4.117    61.875     0.200
     4.476    66.875     0.200
     4.572    68.875     0.200
     4.665    69.477     0.200
     5.510    80.875     0.200
     5.532    81.375     0.200
     5.886    86.078     0.200
     6.402    90.773     0.200
     6.415    90.977     0.200
     6.815    98.875     0.200
     6.902    98.477     0.200
     6.928    99.172     0.200
     6.961   101.773     0.200
     7.411   105.672     0.200
     7.804   109.773     0.200
     7.845   112.773     0.200
     7.870   112.273     0.200
     7.899   111.172     0.200
     8.682   125.578     0.200
    10.184   147.078     0.200
    13.084   181.875     0.200
    14.580   202.375     0.200
    14.718   202.375     0.200
     0.141     9.059     0.200
     0.208     9.359     0.200
     0.306    10.359     0.200
     0.732    14.059     0.200
     1.185    20.660     0.200
     1.494    24.359     0.200
     1.625    25.758     0.200
     1.692    26.859     0.200
     1.646    26.559     0.200
     1.852    30.160     0.200
     1.977    30.758     0.200
     1.994    31.660     0.200
     2.093    32.258     0.200
     2.102    32.559     0.200
     2.081    33.359     0.200
     2.265    34.859     0.200
     2.269    36.559     0.200
     2.673    41.957     0.200
     2.704    41.258     0.200
     2.923    45.359     0.200
     3.153    47.059     0.200
     3.410    51.059     0.200
     3.313    50.059     0.200
     3.318    50.059     0.200
     3.400    52.160     0.200
     3.427    53.559     0.200
     3.655    55.457     0.200
     4.026    59.660     0.200
     4.133    63.160     0.200
     4.297    65.059     0.200
     4.555    68.559     0.200
     4.492    67.359     0.200
     4.681    69.957     0.200
     4.893    73.059     0.200
     5.323    78.859     0.200
     5.525    81.160     0.200
     5.548    81.359     0.200
     5.630    83.059     0.200
     5.903    86.359     0.200
     6.172    89.059     0.200
     6.192    89.059     0.200
     6.348    92.859     0.200
     6.417    90.859     0.200
     6.430    90.957     0.200
     6.707    95.160     0.200
     6.718    97.660     0.200
     6.814    99.859     0.200
     6.936    99.859     0.200
     6.832    99.059     0.200
     6.918    98.859     0.200
     6.943    99.359     0.200
     6.978   101.660     0.200
     7.244   103.160     0.200
     7.373   105.457     0.200
     7.426   105.859     0.200
     7.576   109.660     0.200
     7.585   110.859     0.200
     7.649   108.957     0.200
     7.819   109.859     0.200
     7.861   113.258     0.200
     7.885   112.660     0.200
     7.914   110.957     0.200
     8.118   115.559     0.200
     8.431   121.859     0.200
     8.698   125.160     0.200
     8.778   126.660     0.200
     8.838   125.859     0.200
     9.002   128.059     0.200
     9.055   131.957     0.200
     9.273   130.957     0.200
     9.448   138.660     0.200
     9.462   132.957     0.200
     9.497   133.660     0.200
     9.655   138.660     0.200
     9.704   139.859     0.200
     9.916   141.258     0.200
     9.948   140.559     0.200
    10.192   143.457     0.200
    10.187   144.160     0.200
    10.322   147.160     0.200
    10.449   148.457     0.200
    10.513   148.059     0.200
    10.902   153.957     0.200
    11.242   159.258     0.200
    11.418   160.859     0.200
    12.301   171.059     0.200
    12.301   171.359     0.200
    12.450   175.457     0.200
    13.093   181.660     0.200
    13.257   185.660     0.200
    13.752   192.359     0.200
    14.591   202.258     0.200
    14.729   202.258     0.200
    14.745   204.457     0.200
    15.132   209.559     0.200
     0.184     9.566     0.200
     0.349    10.766     0.200
     0.718    13.766     0.200
     1.145    20.465     0.200
     1.452    24.168     0.200
     1.653    25.566     0.200
     1.694    26.465     0.200
     1.895    30.266     0.200
     1.972    30.367     0.200
     1.965    31.367     0.200
     2.103    32.668     0.200
     2.060    32.766     0.200
     2.117    33.867     0.200
     2.301    34.965     0.200
     2.311    37.066     0.200
     2.714    42.168     0.200
     2.732    41.766     0.200
     2.957    46.066     0.200
     3.341    50.566     0.200
     3.346    50.668     0.200
     3.439    52.668     0.200
     3.459    56.066     0.200
     3.692    56.066     0.200
     4.055    60.566     0.200
     4.170    63.367     0.200
     4.525    67.766     0.200
     4.715    70.266     0.200
     5.552    81.168     0.200
     5.578    81.766     0.200
     5.938    87.168     0.200
     6.446    91.465     0.200
     6.868    99.566     0.200
     6.976    99.965     0.200
     7.896   113.965     0.200
     7.918   113.465     0.200
     7.945   111.367     0.200
     8.737   127.465     0.200
     0.232    10.023     0.200
     0.263    10.023     0.200
     0.742    14.328     0.200
     1.222    21.828     0.200
     1.593    23.727     0.200
     1.532    25.227     0.200
     1.684    26.227     0.200
     1.808    28.523     0.200
     2.017    32.422     0.200
     2.076    32.922     0.200
     2.049    33.125     0.200
     2.226    33.422     0.200
     2.142    33.727     0.200
     2.683    41.125     0.200
     2.895    44.828     0.200
     3.292    49.828     0.200
     3.297    50.023     0.200
     3.622    54.922     0.200
     4.004    59.828     0.200
     4.465    66.922     0.200
     4.652    69.328     0.200
     5.523    81.125     0.200
     6.407    90.727     0.200
     6.801    98.625     0.200
     6.891    99.523     0.200
     6.916    99.125     0.200
     7.401   104.625     0.200
     7.794   110.828     0.200
     7.832   113.727     0.200
     7.858   114.227     0.200
     8.664   125.227     0.200
     0.248    10.074     0.200
     0.215     9.973     0.200
     0.731    14.676     0.200
     1.250    21.773     0.200
     1.543    24.574     0.200
     1.552    24.773     0.200
     1.562    25.574     0.200
     1.653    26.676     0.200
     1.762    28.875     0.200
     1.949    30.773     0.200
     2.036    31.973     0.200
     2.024    32.375     0.200
     2.033    32.773     0.200
     2.173    33.473     0.200
     2.175    33.473     0.200
     2.200    34.074     0.200
     2.604    40.973     0.200
     2.750    42.574     0.200
     2.682    41.273     0.200
     2.883    44.676     0.200
     3.226    48.074     0.200
     3.290    49.676     0.200
     3.296    49.875     0.200
     3.342    52.375     0.200
     3.393    54.074     0.200
     3.603    54.875     0.200
     4.002    59.574     0.200
     4.085    62.875     0.200
     4.454    66.773     0.200
     4.617    69.273     0.200
     4.762    70.074     0.200
     4.640    68.973     0.200
     5.504    79.676     0.200
     5.517    80.973     0.200
     5.573    82.176     0.200
     5.858    85.676     0.200
     6.149    88.473     0.200
     6.161    88.875     0.200
     6.391    90.574     0.200
     6.403    91.176     0.200
     6.690    95.773     0.200
     6.752    97.473     0.200
     6.785    98.273     0.200
     6.917    99.473     0.200
     6.883    98.273     0.200
     6.907    98.973     0.200
     6.927   101.074     0.200
     7.212   103.176     0.200
     7.351   106.074     0.200
     7.395   104.574     0.200
     7.534   109.473     0.200
     7.788   108.875     0.200
     7.819   113.176     0.200
     7.848   111.973     0.200
     7.883   110.875     0.200
     8.381   121.273     0.200
     8.642   125.273     0.200
     9.383   133.074     0.200
     9.896   139.875     0.200
    10.101   143.676     0.200
    10.257   146.773     0.200
    10.844   152.574     0.200
    11.076   156.375     0.200
    11.176   158.676     0.200
    12.357   171.574     0.200
    12.380   174.375     0.200
    13.000   181.074     0.200
    14.497   201.676     0.200
    14.635   201.676     0.200
    16.617   226.574     0.200
     0.207     9.832     0.200
     0.305    10.533     0.200
     0.731    14.232     0.200
     1.185    21.033     0.200
     1.494    24.732     0.200
     1.623    25.332     0.200
     1.690    26.934     0.200
     1.851    29.732     0.200
     1.975    30.533     0.200
     1.993    32.033     0.200
     2.090    32.732     0.200
     2.102    33.434     0.200
     2.081    33.434     0.200
     2.263    34.732     0.200
     2.269    36.633     0.200
     2.689    42.934     0.200
     2.673    41.832     0.200
     2.705    41.732     0.200
     2.924    45.332     0.200
     3.153    47.633     0.200
     3.314    50.332     0.200
     3.319    50.232     0.200
     3.428    54.633     0.200
     3.655    55.533     0.200
     4.027    60.533     0.200
     4.134    62.832     0.200
     4.493    67.033     0.200
     4.682    69.832     0.200
     4.774    69.934     0.200
     5.549    81.434     0.200
     6.431    91.133     0.200
     6.832    98.633     0.200
     6.919    99.332     0.200
     6.944    99.533     0.200
     6.978   102.033     0.200
     7.245   104.033     0.200
     7.427   105.633     0.200
     7.820   110.633     0.200
     7.862   114.232     0.200
     7.886   112.232     0.200
     7.915   110.934     0.200
     0.218    10.297     0.200
     0.268    10.594     0.200
     0.727    14.195     0.200
     1.210    21.395     0.200
     1.588    24.395     0.200
     1.520    25.195     0.200
     1.606    25.195     0.200
     1.671    26.195     0.200
     1.815    28.895     0.200
     1.961    30.195     0.200
     2.003    31.695     0.200
     2.065    31.996     0.200
     2.063    33.297     0.200
     2.225    33.594     0.200
     2.131    33.195     0.200
     2.242    36.297     0.200
     2.646    41.496     0.200
     2.712    42.195     0.200
     2.698    41.395     0.200
     2.909    45.297     0.200
     3.182    47.695     0.200
     3.307    50.195     0.200
     3.312    50.195     0.200
     3.378    52.395     0.200
     3.416    52.695     0.200
     3.635    55.297     0.200
     4.019    59.797     0.200
     4.116    62.695     0.200
     4.479    67.094     0.200
     4.578    69.594     0.200
     4.766    70.195     0.200
     4.667    69.496     0.200
     5.519    79.496     0.200
     5.538    81.195     0.200
     5.608    82.797     0.200
     5.887    86.094     0.200
     6.166    87.895     0.200
     6.182    89.195     0.200
     6.409    90.695     0.200
     6.422    91.094     0.200
     6.703    95.496     0.200
     6.790    99.496     0.200
     6.815    98.797     0.200
     6.906    98.496     0.200
     6.931    98.797     0.200
     6.959   101.496     0.200
     7.234   103.395     0.200
     7.367   104.996     0.200
     7.416   105.695     0.200
     7.554   110.297     0.200
     7.566   109.895     0.200
     7.809   109.395     0.200
     7.846   112.695     0.200
     7.873   112.195     0.200
     7.904   110.797     0.200
     8.341   117.195     0.200
     8.677   125.297     0.200
     8.825   125.395     0.200
     8.990   127.594     0.200
     9.261   130.094     0.200
     9.457   132.594     0.200
     9.485   132.695     0.200
     9.782   137.895     0.200
     9.929   139.797     0.200
    10.153   144.094     0.200
    10.297   147.395     0.200
    10.880   152.996     0.200
    13.053   183.594     0.200
     0.667    12.883     0.200
     0.960    17.582     0.200
     1.230    20.082     0.200
     1.302    21.082     0.200
     1.625    26.883     0.200
     1.658    27.883     0.200
     1.756    27.285     0.200
     1.761    28.383     0.200
     1.893    30.984     0.200
     1.824    29.582     0.200
     1.974    31.785     0.200
     1.978    30.883     0.200
     2.224    34.883     0.200
     2.302    37.285     0.200
     2.524    39.285     0.200
     2.599    40.082     0.200
     2.632    41.285     0.200
     3.119    47.883     0.200
     3.130    48.383     0.200
     3.294    50.785     0.200
     3.788    59.684     0.200
     4.206    65.082     0.200
     4.376    67.184     0.200
     6.488    96.684     0.200
     6.615    98.883     0.200
     6.653    97.184     0.200
     7.590   110.984     0.200
     0.879    16.078     0.200
     1.262    18.977     0.200
     1.346    21.578     0.200
     1.459    23.078     0.200
     1.524    25.875     0.200
     1.643    26.777     0.200
     1.909    29.977     0.200
     1.828    28.277     0.200
     1.841    28.875     0.200
     1.954    31.875     0.200
     1.976    31.676     0.200
     1.936    30.676     0.200
     2.217    35.375     0.200
     2.339    36.277     0.200
     2.460    38.676     0.200
     2.548    38.676     0.200
     2.693    41.277     0.200
     3.150    47.875     0.200
     3.159    48.078     0.200
     3.379    51.375     0.200
     3.869    60.277     0.200
     3.855    58.477     0.200
     4.269    65.578     0.200
     4.445    67.176     0.200
     5.349    79.375     0.200
     5.363    78.777     0.200
     5.651    83.676     0.200
     6.235    88.676     0.200
     6.571    95.977     0.200
     6.704    99.078     0.200
     6.719    97.176     0.200
     7.614   110.777     0.200
     7.616   108.676     0.200
     7.658   110.477     0.200
     7.713   108.977     0.200
     8.404   124.375     0.200
     0.207     9.820     0.200
     0.265    10.320     0.200
     0.710    14.219     0.200
     1.204    21.023     0.200
     1.515    24.719     0.200
     1.573    24.922     0.200
     1.653    26.320     0.200
     1.598    25.422     0.200
     1.812    29.219     0.200
     1.943    30.320     0.200
     1.990    31.922     0.200
     2.047    31.719     0.200
     2.127    32.820     0.200
     2.073    33.320     0.200
     2.214    34.023     0.200
     2.247    36.320     0.200
     2.705    41.422     0.200
     2.705    41.719     0.200
     2.651    41.523     0.200
     2.712    41.219     0.200
     2.920    45.219     0.200
     3.178    47.922     0.200
     3.372    52.422     0.200
     3.320    50.125     0.200
     3.326    50.125     0.200
     3.386    53.023     0.200
     3.645    55.219     0.200
     4.033    59.719     0.200
     4.126    62.922     0.200
     4.572    67.922     0.200
     4.491    67.023     0.200
     4.749    69.219     0.200
     4.678    69.320     0.200
     4.895    72.422     0.200
     5.533    80.320     0.200
     5.551    81.523     0.200
     5.897    86.023     0.200
     6.180    90.023     0.200
     6.423    90.719     0.200
     6.737    95.219     0.200
     6.907    99.422     0.200
     6.825    98.625     0.200
     6.943    99.422     0.200
     6.969   101.422     0.200
     7.535   107.125     0.200
     7.575   110.320     0.200
     7.678   108.922     0.200
     7.678   108.422     0.200
     7.733   108.023     0.200
     7.822   109.719     0.200
     7.857   113.219     0.200
     7.884   112.125     0.200
     7.917   111.023     0.200
     8.331   117.922     0.200
     8.660   124.023     0.200
     8.686   125.320     0.200
     9.151   130.922     0.200
     9.426   133.422     0.200
     9.637   139.625     0.200
     9.792   138.125     0.200
     9.901   140.922     0.200
     9.938   140.719     0.200
    10.141   143.922     0.200
    10.303   146.820     0.200
    10.506   147.922     0.200
    10.888   153.320     0.200
    11.067   155.422     0.200
    11.222   158.625     0.200
    11.322   164.422     0.200
    11.361   160.523     0.200
    11.407   161.023     0.200
    12.260   171.320     0.200
    13.043   180.422     0.200
    16.665   227.523     0.200
     0.330     8.549     0.200
     0.371     8.549     0.200
     1.109    19.250     0.200
     1.190    19.850     0.200
     1.254    19.750     0.200
     1.482    24.150     0.200
     1.429    23.150     0.200
     1.603    25.350     0.200
     1.672    27.850     0.200
     1.830    27.949     0.200
     2.000    30.150     0.200
     2.052    32.049     0.200
     2.381    36.850     0.200
     2.848    43.350     0.200
     3.098    47.250     0.200
     3.248    49.850     0.200
     3.701    55.850     0.200
     3.710    55.549     0.200
     3.923    59.350     0.200
     4.416    67.449     0.200
     4.824    71.850     0.200
     4.998    74.449     0.200
     5.905    86.549     0.200
     6.200    90.750     0.200
     6.790    95.750     0.200
     7.117   103.250     0.200
     7.245   105.650     0.200
     7.274   103.850     0.200
     8.164   117.949     0.200
     8.212   117.250     0.200
     8.932   130.350     0.200
     0.095     7.957     0.200
     0.499    11.857     0.200
     0.831    16.057     0.200
     1.307    20.557     0.200
     1.470    22.557     0.200
     1.495    24.557     0.200
     1.587    25.157     0.200
     1.888    28.757     0.200
     1.902    29.257     0.200
     1.813    28.457     0.200
     1.920    29.957     0.200
     1.876    29.457     0.200
     1.973    30.957     0.200
     2.170    34.057     0.200
     2.376    36.857     0.200
     2.434    36.257     0.200
     2.603    40.257     0.200
     2.742    42.657     0.200
     3.203    48.757     0.200
     3.213    48.857     0.200
     3.425    52.057     0.200
     3.915    58.957     0.200
     3.908    58.657     0.200
     4.318    65.557     0.200
     4.493    66.657     0.200
     5.400    79.757     0.200
     5.698    84.157     0.200
     6.287    88.657     0.200
     6.617    97.057     0.200
     6.635    93.657     0.200
     6.748    99.257     0.200
     6.768    97.857     0.200
     7.422   105.857     0.200
     7.573   107.257     0.200
     7.582   107.257     0.200
     7.661   112.657     0.200
     7.646   107.857     0.200
     7.707   111.557     0.200
     8.445   123.757     0.200
     0.212     9.672     0.200
     0.277    10.172     0.200
     0.725    14.172     0.200
     1.202    21.078     0.200
     1.512    24.875     0.200
     1.595    25.172     0.200
     1.615    25.375     0.200
     1.674    26.672     0.200
     1.824    29.273     0.200
     1.962    30.672     0.200
     1.998    31.875     0.200
     2.069    32.078     0.200
     2.123    33.273     0.200
     2.069    33.172     0.200
     2.233    34.273     0.200
     2.250    36.977     0.200
     2.704    41.375     0.200
     2.704    41.977     0.200
     2.654    41.477     0.200
     2.702    41.273     0.200
     2.914    44.977     0.200
     3.311    50.078     0.200
     3.316    50.078     0.200
     3.385    53.773     0.200
     3.642    55.078     0.200
     4.023    59.977     0.200
     4.122    63.375     0.200
     4.484    66.875     0.200
     4.571    68.875     0.200
     4.766    69.977     0.200
     4.672    69.273     0.200
     5.543    81.375     0.200
     6.170    89.672     0.200
     6.414    90.977     0.200
     6.821    98.375     0.200
     6.936    99.273     0.200
     6.966   101.273     0.200
     7.524   107.977     0.200
     7.667   109.078     0.200
     7.814   110.875     0.200
     7.852   113.477     0.200
     7.878   111.773     0.200
     7.909   112.977     0.200
     8.350   119.375     0.200
     8.684   125.773     0.200
     9.148   129.977     0.200
     9.424   134.375     0.200
    10.161   144.477     0.200
    13.062   181.578     0.200
    13.735   192.977     0.200
    14.560   201.875     0.200
    20.757   276.875     0.200
     0.043     6.297     0.200
     0.395     9.992     0.200
     0.797    15.594     0.200
     1.384    22.594     0.200
     1.401    23.797     0.200
     1.590    25.297     0.200
     1.631    27.094     0.200
     1.717    27.695     0.200
     1.950    31.695     0.200
     1.975    31.594     0.200
     1.919    30.391     0.200
     2.017    31.695     0.200
     2.053    32.992     0.200
     2.124    34.195     0.200
     2.334    35.695     0.200
     2.457    38.492     0.200
     2.610    40.695     0.200
     2.779    43.492     0.200
     3.210    49.992     0.200
     3.215    48.891     0.200
     3.223    49.094     0.200
     3.350    53.094     0.200
     3.480    53.195     0.200
     3.924    58.594     0.200
     3.967    60.797     0.200
     4.181    63.094     0.200
     4.354    65.797     0.200
     4.534    68.094     0.200
     4.780    71.094     0.200
     4.759    72.297     0.200
     4.770    71.391     0.200
     5.154    77.094     0.200
     5.440    80.992     0.200
     5.427    79.992     0.200
     5.430    78.297     0.200
     5.745    84.891     0.200
     6.070    87.797     0.200
     6.071    87.094     0.200
     6.176    91.594     0.200
     6.309    89.492     0.200
     6.463    94.492     0.200
     6.574    98.094     0.200
     6.612    98.094     0.200
     6.589    95.891     0.200
     6.609    96.094     0.200
     6.643    93.891     0.200
     6.668    97.797     0.200
     6.805   100.195     0.200
     6.806    97.695     0.200
     6.907    99.094     0.200
     6.984   103.094     0.200
     7.170   102.094     0.200
     7.287   103.492     0.200
     7.304   109.094     0.200
     7.384   109.094     0.200
     7.409   108.891     0.200
     7.434   106.391     0.200
     7.546   106.797     0.200
     7.583   105.992     0.200
     7.588   107.195     0.200
     7.648   107.594     0.200
     7.696   108.594     0.200
     7.708   111.594     0.200
     7.711   112.094     0.200
     7.746   110.797     0.200
     7.793   109.891     0.200
     7.981   116.891     0.200
     7.981   114.891     0.200
     8.183   115.891     0.200
     8.258   119.797     0.200
     8.246   115.492     0.200
     8.366   122.094     0.200
     8.383   122.195     0.200
     8.511   124.195     0.200
     8.598   124.891     0.200
     8.697   124.695     0.200
     8.861   129.094     0.200
     8.866   126.594     0.200
     8.990   128.695     0.200
     9.135   129.992     0.200
     9.254   133.094     0.200
     9.270   134.797     0.200
     9.358   131.891     0.200
     9.372   131.594     0.200
     9.416   134.992     0.200
     9.426   135.094     0.200
     9.448   136.695     0.200
     9.480   138.094     0.200
     9.634   137.594     0.200
     9.771   138.594     0.200
     9.946   143.391     0.200
    10.001   143.195     0.200
    10.111   145.695     0.200
    10.146   147.594     0.200
    10.348   146.594     0.200
    10.710   152.297     0.200
    11.124   161.297     0.200
    11.169   159.391     0.200
    11.235   159.797     0.200
    12.076   170.195     0.200
    12.449   176.094     0.200
    12.489   174.297     0.200
    12.578   178.297     0.200
    12.838   182.094     0.200
    13.042   184.891     0.200
    13.054   184.492     0.200
    13.290   186.992     0.200
    13.405   188.594     0.200
    13.543   190.695     0.200
    13.714   191.492     0.200
    13.946   196.391     0.200
    14.328   201.094     0.200
    14.547   202.797     0.200
    14.939   207.992     0.200
    15.057   206.891     0.200
    15.182   210.094     0.200
    16.444   227.094     0.200
    17.521   239.391     0.200
     0.371     8.938     0.200
     0.801    14.336     0.200
     1.378    23.039     0.200
     1.464    22.336     0.200
     1.659    26.836     0.200
     1.627    25.039     0.200
     1.692    26.836     0.200
     1.973    31.336     0.200
     2.011    32.039     0.200
     1.926    30.438     0.200
     2.063    31.734     0.200
     2.120    34.438     0.200
     2.307    36.234     0.200
     2.477    38.234     0.200
     2.604    40.539     0.200
     2.782    43.336     0.200
     3.210    48.836     0.200
     3.217    49.539     0.200
     3.491    53.539     0.200
     3.919    58.734     0.200
     4.357    65.734     0.200
     4.539    68.234     0.200
     5.427    79.734     0.200
     6.677    97.836     0.200
     6.816   101.234     0.200
     7.580   108.336     0.200
     7.714   113.539     0.200
     7.749   113.133     0.200
     0.215     9.883     0.200
     0.253     9.883     0.200
     0.738    14.281     0.200
     1.254    21.680     0.200
     1.548    24.082     0.200
     1.554    24.582     0.200
     1.566    25.281     0.200
     1.660    26.383     0.200
     1.762    28.180     0.200
     1.957    30.281     0.200
     2.043    31.582     0.200
     2.030    32.082     0.200
     2.186    33.281     0.200
     2.178    33.582     0.200
     2.201    35.281     0.200
     2.203    35.082     0.200
     2.601    40.781     0.200
     2.776    42.680     0.200
     2.877    44.680     0.200
     3.305    51.281     0.200
     3.283    49.781     0.200
     3.289    49.781     0.200
     3.339    52.281     0.200
     3.598    54.781     0.200
     3.995    59.582     0.200
     4.080    62.480     0.200
     4.448    66.480     0.200
     4.621    69.082     0.200
     4.634    68.980     0.200
     5.555    80.883     0.200
     5.853    85.582     0.200
     6.142    88.480     0.200
     6.155    88.781     0.200
     6.384    90.383     0.200
     6.397    93.180     0.200
     6.780    98.281     0.200
     6.901    98.680     0.200
     6.922   100.980     0.200
     7.499   107.680     0.200
     7.643   108.781     0.200
     7.645   109.383     0.200
     7.700   109.582     0.200
     7.782   109.480     0.200
     7.813   113.082     0.200
     7.842   111.980     0.200
     7.901   110.680     0.200
     8.020   115.480     0.200
     8.434   120.582     0.200
     8.638   124.883     0.200
     9.105   130.281     0.200
     9.378   133.281     0.200
    10.105   143.781     0.200
    12.361   170.281     0.200
    12.361   170.383     0.200
    13.003   181.082     0.200
    14.499   200.281     0.200
    16.618   228.082     0.200
     0.365    11.898     0.200
     0.602    12.699     0.200
     0.682    15.000     0.200
     0.795    16.801     0.200
     0.983    18.500     0.200
     1.587    25.801     0.200
     1.590    26.102     0.200
     1.649    25.801     0.200
     1.885    29.500     0.200
     2.140    33.398     0.200
     2.331    36.398     0.200
     2.629    40.500     0.200
     2.785    43.000     0.200
     3.185    48.500     0.200
     3.246    49.500     0.200
     3.399    51.398     0.200
     3.745    55.898     0.200
     3.746    56.000     0.200
     3.870    59.301     0.200
     4.149    61.898     0.200
     4.459    66.199     0.200
     4.622    69.199     0.200
     4.957    73.699     0.200
     5.154    75.602     0.200
     5.831    83.301     0.200
     6.037    88.000     0.200
     6.382    93.199     0.200
     6.850    97.000     0.200
     6.906   100.398     0.200
     7.315   105.898     0.200
     7.405   107.102     0.200
     7.468   108.301     0.200
     8.062   115.000     0.200
     8.107   115.000     0.200
     8.348   119.699     0.200
     0.569    11.681     0.200
     1.091    19.580     0.200
     1.408    23.181     0.200
     1.533    24.780     0.200
     1.815    29.181     0.200
     1.849    30.580     0.200
     1.879    30.080     0.200
     2.026    32.580     0.200
     2.222    34.980     0.200
     2.306    36.580     0.200
     2.369    37.681     0.200
     2.765    43.880     0.200
     2.956    45.280     0.200
     3.057    47.580     0.200
     3.463    52.480     0.200
     3.468    52.681     0.200
     3.775    57.880     0.200
     4.629    69.380     0.200
     4.815    72.181     0.200
     5.554    80.681     0.200
     5.736    84.280     0.200
     6.032    88.480     0.200
     6.335    91.681     0.200
     6.565    93.380     0.200
     6.578    96.380     0.200
     6.958   100.780     0.200
     7.081   101.181     0.200
     7.100   103.880     0.200
     7.821   110.080     0.200
     7.876   110.880     0.200
     7.962   113.681     0.200
     7.993   117.580     0.200
     8.023   114.080     0.200
     8.082   113.980     0.200
     0.227     9.492     0.200
     0.241    10.297     0.200
     0.295     9.695     0.200
     0.722    13.898     0.200
     1.226    20.992     0.200
     1.538    24.594     0.200
     1.560    24.992     0.200
     1.577    25.492     0.200
     1.655    26.797     0.200
     1.770    28.797     0.200
     1.788    29.094     0.200
     1.948    30.594     0.200
     2.007    31.992     0.200
     2.044    32.195     0.200
     2.053    33.195     0.200
     2.150    32.898     0.200
     2.205    34.297     0.200
     2.151    34.195     0.200
     2.228    35.898     0.200
     2.230    35.594     0.200
     2.628    41.398     0.200
     2.798    42.695     0.200
     2.930    44.898     0.200
     3.304    49.797     0.200
     3.310    49.992     0.200
     3.331    52.195     0.200
     3.624    55.094     0.200
     4.016    59.695     0.200
     4.105    62.297     0.200
     4.472    66.898     0.200
     4.594    68.195     0.200
     4.659    69.398     0.200
     4.757    70.297     0.200
     5.395    77.594     0.200
     5.577    81.094     0.200
     5.594    82.594     0.200
     5.877    85.992     0.200
     6.163    88.594     0.200
     6.177    89.195     0.200
     6.406    90.297     0.200
     6.421    93.797     0.200
     6.722    95.492     0.200
     6.805    98.594     0.200
     6.924    98.992     0.200
     6.948   101.695     0.200
     7.519   106.398     0.200
     7.588   108.297     0.200
     7.663   108.898     0.200
     7.664   108.297     0.200
     7.719   109.398     0.200
     7.804   109.992     0.200
     7.838   112.594     0.200
     7.866   112.398     0.200
     7.923   111.195     0.200
     8.044   113.797     0.200
     8.311   119.195     0.200
     8.664   125.297     0.200
     8.746   126.195     0.200
     9.018   131.492     0.200
     9.131   130.398     0.200
     9.404   133.195     0.200
     9.614   138.195     0.200
     9.657   139.398     0.200
     9.772   137.695     0.200
     9.879   140.695     0.200
     9.917   140.398     0.200
    10.123   143.797     0.200
    10.153   144.594     0.200
    10.280   146.797     0.200
    10.320   144.797     0.200
    10.411   147.992     0.200
    10.486   147.594     0.200
    10.866   153.492     0.200
    11.299   162.398     0.200
    11.339   160.898     0.200
    11.385   160.797     0.200
    12.238   171.898     0.200
    12.624   178.094     0.200
    13.023   181.992     0.200
    13.711   191.398     0.200
    14.119   197.297     0.200
    14.522   201.594     0.200
    14.708   203.898     0.200
    15.096   209.195     0.200
    16.643   228.398     0.200
     0.522    11.371     0.200
     0.555    10.672     0.200
     0.633    12.672     0.200
     0.672    12.672     0.200
     0.933    15.270     0.200
     1.011    17.672     0.200
     1.348    22.570     0.200
     1.351    22.871     0.200
     1.378    23.070     0.200
     1.604    24.973     0.200
     1.627    25.371     0.200
     1.701    26.172     0.200
     1.690    26.672     0.200
     1.782    29.871     0.200
     2.306    35.973     0.200
     2.368    36.371     0.200
     2.481    37.871     0.200
     2.737    42.070     0.200
     3.232    48.871     0.200
     3.294    49.871     0.200
     3.752    56.871     0.200
     3.863    58.371     0.200
     4.968    73.973     0.200
     7.055   100.871     0.200
     0.235     9.875     0.200
     0.235     9.875     0.200
     0.289     9.578     0.200
     0.727    14.680     0.200
     1.234    21.680     0.200
     1.558    24.578     0.200
     1.546    25.477     0.200
     1.658    26.977     0.200
     1.763    28.180     0.200
     1.782    28.781     0.200
     1.952    30.875     0.200
     2.014    32.977     0.200
     2.045    32.180     0.200
     2.144    33.977     0.200
     2.200    33.781     0.200
     2.158    33.477     0.200
     2.223    35.375     0.200
     2.620    41.180     0.200
     2.791    42.477     0.200
     2.922    44.781     0.200
     3.298    50.078     0.200
     3.303    49.977     0.200
     3.616    55.281     0.200
     4.009    60.078     0.200
     4.098    62.875     0.200
     4.465    67.180     0.200
     5.389    77.578     0.200
     5.570    81.078     0.200
     6.797    98.578     0.200
     0.129     7.129     0.200
     0.153     8.328     0.200
     0.339     9.828     0.200
     0.674    13.828     0.200
     1.344    21.229     0.200
     1.325    22.328     0.200
     1.504    25.027     0.200
     1.607    25.129     0.200
     1.627    25.629     0.200
     1.644    26.129     0.200
     1.820    29.229     0.200
     1.860    29.828     0.200
     1.992    30.328     0.200
     2.008    32.027     0.200
     2.154    33.328     0.200
     2.141    33.129     0.200
     2.266    34.928     0.200
     2.547    39.328     0.200
     2.833    42.928     0.200
     2.938    45.027     0.200
     3.342    50.027     0.200
     3.351    50.229     0.200
     3.589    55.129     0.200
     4.050    59.729     0.200
     4.651    69.328     0.200
     5.430    78.328     0.200
     6.419    94.027     0.200
     6.433    91.027     0.200
     6.780    98.828     0.200
     6.925    99.729     0.200
     7.711   108.527     0.200
     7.717   109.527     0.200
     7.864   113.527     0.200
     0.477    10.566     0.200
     0.496     9.969     0.200
     0.570    12.266     0.200
     0.590    11.566     0.200
     1.013    16.168     0.200
     1.069    17.969     0.200
     1.321    21.969     0.200
     1.399    23.066     0.200
     1.423    23.367     0.200
     1.634    25.469     0.200
     1.656    25.969     0.200
     1.636    25.867     0.200
     1.770    27.066     0.200
     1.771    29.469     0.200
     2.366    36.367     0.200
     2.372    36.266     0.200
     2.457    37.469     0.200
     2.740    41.867     0.200
     3.197    47.867     0.200
     3.706    55.266     0.200
     3.717    56.066     0.200
     4.951    73.469     0.200
     5.783    82.867     0.200
     0.492    10.332     0.200
     0.693    13.532     0.200
     1.167    19.532     0.200
     1.219    18.732     0.200
     1.399    23.532     0.200
     1.479    23.932     0.200
     1.499    24.732     0.200
     1.719    28.832     0.200
     1.733    28.432     0.200
     1.815    28.832     0.200
     1.753    27.732     0.200
     2.033    33.232     0.200
     2.143    33.332     0.200
     2.495    38.432     0.200
     2.869    44.432     0.200
     2.950    45.732     0.200
     3.243    50.532     0.200
     3.564    54.932     0.200
     4.646    70.632     0.200
     5.610    81.932     0.200
     6.758    98.732     0.200
     0.195     9.370     0.200
     0.310    10.671     0.200
     0.365    10.171     0.200
     0.720    13.870     0.200
     1.175    20.671     0.200
     1.484    24.271     0.200
     1.620    25.971     0.200
     1.681    26.971     0.200
     1.647    25.771     0.200
     1.838    29.570     0.200
     1.856    30.070     0.200
     1.965    30.870     0.200
     1.981    31.870     0.200
     2.083    32.471     0.200
     2.093    32.671     0.200
     2.092    32.771     0.200
     2.208    33.771     0.200
     2.188    34.771     0.200
     2.272    35.370     0.200
     2.282    36.771     0.200
     2.283    36.370     0.200
     2.682    42.070     0.200
     2.821    42.971     0.200
     2.935    45.771     0.200
     2.960    45.471     0.200
     3.326    50.271     0.200
     3.330    50.271     0.200
     3.377    52.570     0.200
     3.412    52.771     0.200
     3.666    55.771     0.200
     4.039    60.070     0.200
     4.145    63.171     0.200
     4.545    68.271     0.200
     4.504    67.271     0.200
     4.763    69.971     0.200
     4.693    69.570     0.200
     4.905    73.771     0.200
     5.417    78.070     0.200
     5.604    81.771     0.200
     5.914    86.370     0.200
     6.185    88.971     0.200
     6.204    89.471     0.200
     6.430    90.870     0.200
     6.453    94.171     0.200
     6.738    95.471     0.200
     6.824    99.471     0.200
     6.843    99.271     0.200
     6.956    99.471     0.200
     6.989   101.870     0.200
     7.537   109.570     0.200
     7.538   107.870     0.200
     7.596   110.870     0.200
     7.679   108.971     0.200
     7.680   109.471     0.200
     7.733   109.471     0.200
     7.873   114.070     0.200
     7.897   112.870     0.200
     7.950   111.271     0.200
     8.075   114.971     0.200
     8.493   119.671     0.200
     8.709   125.671     0.200
     8.850   126.471     0.200
     9.171   130.971     0.200
     9.459   138.271     0.200
     9.665   138.971     0.200
     9.713   139.971     0.200
     9.811   138.271     0.200
     9.926   141.370     0.200
     9.959   140.870     0.200
    10.190   144.971     0.200
    10.198   145.070     0.200
    10.332   147.271     0.200
    10.459   148.570     0.200
    10.525   148.570     0.200
    10.644   149.570     0.200
    10.913   154.070     0.200
    11.359   160.771     0.200
    11.353   162.870     0.200
    11.391   161.471     0.200
    12.290   170.771     0.200
    12.459   175.771     0.200
    12.678   178.971     0.200
    13.092   181.771     0.200
    13.267   185.771     0.200
    13.522   191.370     0.200
    13.762   192.771     0.200
    13.935   195.271     0.200
    14.592   202.070     0.200
    14.756   204.671     0.200
    16.712   229.771     0.200
     0.640    11.414     0.200
     0.727    13.613     0.200
     0.864    15.414     0.200
     1.114    19.312     0.200
     1.310    21.812     0.200
     1.287    19.812     0.200
     1.311    20.414     0.200
     1.377    21.613     0.200
     1.487    24.715     0.200
     1.719    27.215     0.200
     2.032    30.812     0.200
     2.086    33.113     0.200
     2.123    33.016     0.200
     2.313    35.113     0.200
     2.475    38.016     0.200
     2.649    40.016     0.200
     2.766    41.215     0.200
     3.102    45.914     0.200
     3.606    53.516     0.200
     3.621    54.812     0.200
     3.636    55.215     0.200
     4.762    71.215     0.200
     5.655    81.914     0.200
     6.818   100.914     0.200
     6.922   102.312     0.200
     7.038   102.113     0.200
     8.562   124.914     0.200
    19.608   267.414     0.200
     0.165    10.641     0.200
     0.296    11.141     0.200
     0.274    12.039     0.200
     0.615    13.141     0.200
     1.169    20.539     0.200
     1.493    23.641     0.200
     1.548    24.441     0.200
     1.485    24.340     0.200
     1.561    24.941     0.200
     1.784    28.840     0.200
     1.803    29.340     0.200
     1.914    30.141     0.200
     1.946    29.742     0.200
     2.103    32.742     0.200
     2.166    33.340     0.200
     2.136    34.840     0.200
     2.219    33.840     0.200
     2.237    35.840     0.200
     2.288    36.641     0.200
     2.292    36.340     0.200
     2.719    41.840     0.200
     2.688    41.840     0.200
     2.896    44.242     0.200
     3.021    46.641     0.200
     3.268    47.641     0.200
     3.404    52.941     0.200
     3.403    51.340     0.200
     3.409    51.340     0.200
     3.439    53.641     0.200
     3.703    56.242     0.200
     4.115    60.941     0.200
     4.187    63.539     0.200
     4.528    67.641     0.200
     4.647    67.840     0.200
     4.563    68.039     0.200
     4.747    70.340     0.200
     5.494    79.141     0.200
     5.667    83.242     0.200
     5.672    82.441     0.200
     5.962    86.941     0.200
     6.262    89.340     0.200
     6.272    90.242     0.200
     6.511    94.840     0.200
     6.503    92.039     0.200
     6.842    99.840     0.200
     6.824    96.641     0.200
     6.888    99.441     0.200
     7.015   100.141     0.200
     7.028   102.141     0.200
     7.633   110.641     0.200
     7.620   108.441     0.200
     7.686   109.742     0.200
     7.765   110.141     0.200
     7.767   109.941     0.200
     7.823   110.141     0.200
     7.899   110.641     0.200
     7.924   113.641     0.200
     7.956   114.641     0.200
     8.018   112.340     0.200
     8.176   116.539     0.200
     8.546   121.941     0.200
     8.738   126.539     0.200
     8.823   126.441     0.200
     9.211   131.141     0.200
     9.480   134.641     0.200
     9.494   137.641     0.200
     9.679   138.539     0.200
     9.854   139.539     0.200
    10.079   142.539     0.200
    10.079   144.742     0.200
     9.995   140.742     0.200
    10.342   146.039     0.200
    10.378   149.840     0.200
    10.938   152.941     0.200
    11.401   161.340     0.200
    12.261   168.742     0.200
    12.279   171.539     0.200
    12.461   175.539     0.200
    12.989   179.840     0.200
    14.502   200.840     0.200
    14.777   205.141     0.200
    16.641   227.641     0.200
     0.509    10.938     0.200
     0.587    13.037     0.200
     0.852    14.637     0.200
     0.911    16.736     0.200
     1.003    18.236     0.200
     1.105    18.736     0.200
     1.127    19.137     0.200
     1.394    23.736     0.200
     1.408    23.037     0.200
     1.765    28.537     0.200
     1.866    29.938     0.200
     1.969    30.836     0.200
     2.033    32.236     0.200
     2.136    32.438     0.200
     2.821    42.637     0.200
     2.877    42.438     0.200
     2.848    43.736     0.200
     3.324    50.037     0.200
     3.340    50.736     0.200
     3.371    51.537     0.200
     0.148     5.898     0.200
     0.217     7.301     0.200
     0.599    11.598     0.200
     0.866    16.098     0.200
     1.198    19.598     0.200
     1.347    21.598     0.200
     1.367    22.199     0.200
     1.776    27.598     0.200
     1.886    29.598     0.200
     1.899    29.199     0.200
     1.929    29.898     0.200
     1.970    29.801     0.200
     2.207    35.098     0.200
     2.284    35.000     0.200
     2.316    36.000     0.200
     2.638    39.199     0.200
     2.702    40.898     0.200
     2.778    42.098     0.200
     3.211    48.500     0.200
     3.222    49.398     0.200
     3.389    51.898     0.200
     3.884    60.098     0.200
     4.472    67.000     0.200
     5.289    76.500     0.200
     5.324    79.398     0.200
     5.438    79.598     0.200
     5.669    83.598     0.200
     6.241    91.699     0.200
     6.284    89.098     0.200
     6.583    95.699     0.200
     6.710    99.301     0.200
     6.749    97.699     0.200
     7.633   111.598     0.200
     8.397   123.398     0.200
     9.964   143.898     0.200
     0.066     6.891     0.200
     0.181     8.492     0.200
     0.537    11.992     0.200
     0.808    15.594     0.200
     1.218    19.789     0.200
     1.410    22.891     0.200
     1.430    23.391     0.200
     1.516    24.891     0.200
     1.514    24.789     0.200
     1.819    28.391     0.200
     1.818    28.992     0.200
     1.854    29.094     0.200
     1.834    28.594     0.200
     1.989    31.188     0.200
     2.019    31.289     0.200
     2.150    33.594     0.200
     2.342    35.992     0.200
     2.377    37.094     0.200
     2.457    37.688     0.200
     2.574    38.188     0.200
     2.744    42.094     0.200
     2.826    43.391     0.200
     3.127    49.492     0.200
     3.253    49.688     0.200
     3.263    49.891     0.200
     3.445    52.391     0.200
     3.939    60.992     0.200
     3.955    59.391     0.200
     4.353    65.992     0.200
     4.524    67.891     0.200
     5.334    76.891     0.200
     5.486    79.289     0.200
     6.639    97.891     0.200
     0.191     8.039     0.200
     0.345     9.539     0.200
     0.642    13.141     0.200
     1.316    22.039     0.200
     1.460    23.641     0.200
     1.606    24.738     0.200
     1.627    25.141     0.200
     1.636    25.941     0.200
     1.776    27.941     0.200
     1.817    27.738     0.200
     1.968    29.340     0.200
     1.980    31.539     0.200
     2.065    32.840     0.200
     2.175    33.340     0.200
     2.172    33.340     0.200
     2.259    34.641     0.200
     2.376    35.539     0.200
     2.527    38.238     0.200
     2.565    39.340     0.200
     2.870    44.039     0.200
     2.971    45.441     0.200
     3.379    50.840     0.200
     3.388    51.340     0.200
     4.106    62.539     0.200
     4.682    69.738     0.200
     5.466    78.441     0.200
     5.564    81.840     0.200
     5.629    81.941     0.200
     5.888    85.941     0.200
     6.226    89.340     0.200
     6.233    89.340     0.200
     6.450    93.941     0.200
     6.469    91.039     0.200
     6.728    99.039     0.200
     6.808    97.840     0.200
     6.809    96.141     0.200
     6.940   101.738     0.200
     6.956    99.340     0.200
     7.461   108.738     0.200
     7.542   109.840     0.200
     7.655   108.641     0.200
     7.748   111.941     0.200
     7.755   109.141     0.200
     7.816   109.441     0.200
     7.852   114.141     0.200
     7.852   110.238     0.200
     7.895   113.738     0.200
     7.972   111.441     0.200
     8.114   116.340     0.200
     8.339   117.941     0.200
     8.404   118.141     0.200
     8.477   121.441     0.200
     8.637   125.441     0.200
     8.728   127.141     0.200
     9.125   129.840     0.200
     9.285   135.141     0.200
     9.507   133.738     0.200
     9.536   133.340     0.200
     9.558   139.738     0.200
     9.840   140.641     0.200
     9.903   140.941     0.200
    10.126   144.539     0.200
    10.217   147.641     0.200
    10.830   153.039     0.200
    11.222   162.738     0.200
    12.165   170.539     0.200
    13.651   191.141     0.200
    15.224   209.738     0.200
     0.212     9.494     0.200
     0.283    10.594     0.200
     0.369     9.994     0.200
     0.728    14.395     0.200
     1.199    20.994     0.200
     1.509    24.594     0.200
     1.602    25.494     0.200
     1.621    25.795     0.200
     1.679    26.795     0.200
     1.728    27.895     0.200
     1.811    29.295     0.200
     1.829    29.695     0.200
     1.966    30.695     0.200
     1.998    32.695     0.200
     2.075    32.195     0.200
     2.071    32.395     0.200
     2.119    32.895     0.200
     2.167    34.594     0.200
     2.250    34.994     0.200
     2.233    33.895     0.200
     2.257    36.395     0.200
     2.258    35.895     0.200
     2.657    40.395     0.200
     2.657    41.094     0.200
     2.804    42.695     0.200
     2.915    46.395     0.200
     2.942    44.994     0.200
     3.310    49.895     0.200
     3.315    50.195     0.200
     3.354    51.994     0.200
     3.398    52.395     0.200
     3.389    52.395     0.200
     3.644    55.195     0.200
     4.022    59.695     0.200
     4.123    62.594     0.200
     4.485    67.195     0.200
     4.673    69.395     0.200
     4.673    69.695     0.200
     4.769    70.395     0.200
     5.313    79.395     0.200
     5.401    77.695     0.200
     5.586    81.395     0.200
     5.617    82.895     0.200
     5.894    85.895     0.200
     6.169    88.494     0.200
     6.187    89.195     0.200
     6.413    90.594     0.200
     6.434    93.594     0.200
     6.729    98.395     0.200
     6.800    99.395     0.200
     6.822    98.395     0.200
     6.937   100.395     0.200
     6.967   102.395     0.200
     6.967   102.594     0.200
     7.514   109.494     0.200
     7.523   108.195     0.200
     7.574   110.494     0.200
     7.665   108.295     0.200
     7.666   108.094     0.200
     7.720   109.295     0.200
     7.814   110.494     0.200
     7.853   113.395     0.200
     7.878   112.395     0.200
     7.933   112.094     0.200
     8.100   115.994     0.200
     8.301   116.494     0.200
     8.356   120.395     0.200
     8.473   119.994     0.200
     8.513   122.994     0.200
     8.686   125.395     0.200
     8.831   125.594     0.200
     8.996   127.795     0.200
     9.092   130.795     0.200
     9.149   130.594     0.200
     9.267   131.395     0.200
     9.426   134.395     0.200
     9.490   132.895     0.200
     9.641   138.695     0.200
     9.790   137.395     0.200
     9.903   140.895     0.200
     9.937   140.994     0.200
    10.168   143.895     0.200
    10.308   146.395     0.200
    10.308   146.994     0.200
    10.630   150.395     0.200
    10.890   153.295     0.200
    11.314   157.395     0.200
    11.366   161.195     0.200
    12.236   171.094     0.200
    12.313   173.895     0.200
    12.434   175.395     0.200
    13.069   182.195     0.200
    13.738   192.395     0.200
    13.910   194.895     0.200
    14.566   202.395     0.200
    14.732   204.195     0.200
    16.686   229.395     0.200
     0.021     6.488     0.200
     0.106     7.787     0.200
     0.486    11.188     0.200
     0.806    15.688     0.200
     1.461    23.389     0.200
     1.478    24.188     0.200
     1.480    23.787     0.200
     1.797    27.988     0.200
     1.843    29.488     0.200
     1.894    30.988     0.200
     1.892    29.588     0.200
     2.005    31.787     0.200
     2.010    31.488     0.200
     2.396    37.488     0.200
     2.403    36.688     0.200
     2.418    37.188     0.200
     2.535    38.188     0.200
     2.720    41.787     0.200
     2.812    43.389     0.200
     3.230    48.688     0.200
     3.239    49.389     0.200
     3.448    53.188     0.200
     3.934    58.389     0.200
     3.939    59.988     0.200
     4.344    65.287     0.200
     4.518    67.389     0.200
     5.314    76.287     0.200
     5.472    79.787     0.200
     6.313    88.988     0.200
     6.640    99.088     0.200
     6.661    94.287     0.200
     6.772    99.688     0.200
     6.793    98.287     0.200
     7.448   105.188     0.200
     7.599   106.389     0.200
     7.609   106.988     0.200
     7.672   107.588     0.200
     7.686   112.488     0.200
     7.732   111.787     0.200
     7.813   109.287     0.200
     8.467   124.088     0.200
     0.126     9.250     0.200
     0.226     8.949     0.200
     0.334    10.551     0.200
     0.783    15.551     0.200
     1.339    22.949     0.200
     1.653    26.551     0.200
     1.662    27.148     0.200
     1.652    26.449     0.200
     1.671    26.949     0.200
     1.809    29.250     0.200
     1.971    31.750     0.200
     2.024    32.250     0.200
     2.056    32.648     0.200
     2.110    32.648     0.200
     2.118    33.949     0.200
     2.382    36.750     0.200
     2.515    39.250     0.200
     2.721    41.648     0.200
     2.842    43.551     0.200
     3.229    48.949     0.200
     3.939    59.148     0.200
     4.566    67.648     0.200
     6.327    89.648     0.200
     6.707    99.449     0.200
     6.835    99.551     0.200
     6.847   101.551     0.200
     7.720   109.250     0.200
     0.814    15.430     0.200
     1.179    20.531     0.200
     1.257    21.031     0.200
     1.460    24.930     0.200
     1.489    24.531     0.200
     1.758    28.430     0.200
     1.875    29.031     0.200
     2.099    32.031     0.200
     2.120    33.633     0.200
     2.290    35.227     0.200
     2.689    41.828     0.200
     3.103    47.727     0.200
     3.350    49.930     0.200
     3.476    52.227     0.200
     3.857    57.133     0.200
     4.146    62.430     0.200
     4.569    67.227     0.200
     5.017    73.930     0.200
     5.199    76.633     0.200
     6.128    89.133     0.200
     6.412    94.328     0.200
     6.958    98.133     0.200
     7.335   107.430     0.200
     8.216   117.633     0.200
     8.374   122.633     0.200
     8.409   120.031     0.200
     0.159     9.531     0.200
     0.333    11.031     0.200
     0.410    10.633     0.200
     0.688    13.732     0.200
     1.141    20.432     0.200
     1.450    24.133     0.200
     1.658    26.732     0.200
     1.678    27.432     0.200
     1.832    29.633     0.200
     1.862    29.633     0.200
     1.880    30.232     0.200
     1.938    30.633     0.200
     2.061    32.832     0.200
     2.175    33.432     0.200
     2.167    34.633     0.200
     2.224    35.133     0.200
     2.281    35.133     0.200
     2.317    36.332     0.200
     2.420    38.133     0.200
     2.510    38.332     0.200
     2.661    41.031     0.200
     2.813    43.031     0.200
     2.822    43.832     0.200
     2.857    43.332     0.200
     2.918    44.633     0.200
     2.997    45.932     0.200
     3.120    47.633     0.200
     3.362    50.332     0.200
     3.413    52.531     0.200
     3.446    52.932     0.200
     3.490    53.732     0.200
     3.613    54.031     0.200
     3.963    59.432     0.200
     4.035    59.232     0.200
     4.328    64.133     0.200
     4.513    67.432     0.200
     4.677    69.732     0.200
     4.741    69.133     0.200
     5.184    74.832     0.200
     5.204    76.232     0.200
     5.453    78.633     0.200
     5.526    80.932     0.200
     5.640    82.232     0.200
     5.951    86.732     0.200
     6.241    89.732     0.200
     6.466    91.133     0.200
     6.879    98.832     0.200
     6.879    99.332     0.200
     6.992    98.932     0.200
     7.572   109.633     0.200
     7.714   110.232     0.200
     7.768   110.031     0.200
     7.910   113.832     0.200
     7.910   114.432     0.200
     7.934   112.432     0.200
     7.987   111.432     0.200
     8.156   116.031     0.200
     8.529   121.031     0.200
     8.745   125.832     0.200
     8.745   126.232     0.200
     8.887   126.633     0.200
     9.207   130.232     0.200
     9.546   133.432     0.200
     0.247    10.375     0.200
     0.211     9.477     0.200
     0.277     9.578     0.200
     0.685    13.477     0.200
     0.754    16.477     0.200
     0.973    16.375     0.200
     1.179    19.977     0.200
     1.235    21.477     0.200
     1.316    22.477     0.200
     1.393    23.477     0.200
     1.500    23.977     0.200
     1.537    25.273     0.200
     1.570    25.680     0.200
     1.706    27.875     0.200
     1.722    28.180     0.200
     1.735    28.078     0.200
     1.775    28.578     0.200
     1.779    29.375     0.200
     1.819    28.773     0.200
     1.896    30.375     0.200
     2.079    33.477     0.200
     2.070    32.680     0.200
     2.164    33.773     0.200
     2.187    33.773     0.200
     2.224    35.180     0.200
     2.281    34.375     0.200
     2.276    36.375     0.200
     2.252    34.875     0.200
     2.296    36.375     0.200
     2.312    36.773     0.200
     2.319    37.273     0.200
     2.472    37.477     0.200
     2.476    38.680     0.200
     2.604    40.180     0.200
     2.679    41.773     0.200
     2.742    42.773     0.200
     2.731    42.273     0.200
     2.823    42.273     0.200
     2.817    43.180     0.200
     2.948    44.680     0.200
     3.072    46.273     0.200
     3.150    48.680     0.200
     3.331    49.578     0.200
     3.383    52.180     0.200
     3.571    52.773     0.200
     3.902    58.078     0.200
     4.003    58.680     0.200
     4.281    62.078     0.200
     4.621    68.375     0.200
     4.703    67.977     0.200
     4.711    72.477     0.200
     5.152    73.773     0.200
     5.160    75.078     0.200
     5.422    77.578     0.200
     5.473    79.773     0.200
     6.189    87.875     0.200
     6.431    90.578     0.200
     6.752    95.078     0.200
     6.815    98.477     0.200
     6.815    98.273     0.200
     6.941    98.875     0.200
     0.079     7.612     0.200
     0.508    11.612     0.200
     0.447    11.612     0.200
     0.664    13.112     0.200
     0.874    16.013     0.200
     1.001    18.312     0.200
     1.111    19.612     0.200
     1.157    20.112     0.200
     1.220    20.513     0.200
     1.243    22.013     0.200
     1.334    22.013     0.200
     1.417    23.413     0.200
     1.460    23.713     0.200
     1.583    27.013     0.200
     1.714    27.112     0.200
     1.730    28.013     0.200
     1.817    29.312     0.200
     1.810    29.513     0.200
     1.882    30.112     0.200
     1.878    29.913     0.200
     1.978    31.513     0.200
     2.009    32.112     0.200
     2.044    32.312     0.200
     2.049    33.013     0.200
     2.036    31.513     0.200
     2.410    37.213     0.200
     2.488    38.812     0.200
     2.486    38.913     0.200
     2.560    39.513     0.200
     2.572    39.913     0.200
     2.563    37.913     0.200
     2.770    41.713     0.200
     2.851    43.812     0.200
     2.978    45.913     0.200
     3.245    50.112     0.200
     3.279    49.513     0.200
     3.491    53.413     0.200
     3.944    58.413     0.200
     0.314     7.638     0.200
     0.392     9.138     0.200
     0.618    11.738     0.200
     0.660    12.038     0.200
     0.688    13.538     0.200
     0.793    14.838     0.200
     0.962    16.938     0.200
     0.958    17.138     0.200
     0.986    18.138     0.200
     1.012    17.638     0.200
     1.066    19.638     0.200
     1.164    18.938     0.200
     1.264    22.138     0.200
     1.303    22.438     0.200
     1.391    23.738     0.200
     1.469    23.738     0.200
     1.600    25.238     0.200
     1.584    25.538     0.200
     1.622    27.338     0.200
     1.649    26.338     0.200
     1.761    28.038     0.200
     1.765    29.038     0.200
     1.803    29.338     0.200
     1.836    29.138     0.200
     1.841    29.638     0.200
     2.106    33.538     0.200
     2.335    36.038     0.200
     2.410    35.838     0.200
     2.437    37.838     0.200
     2.562    39.338     0.200
     2.954    45.838     0.200
     2.942    44.838     0.200
     3.004    46.338     0.200
     3.375    51.338     0.200
     3.503    53.638     0.200
     3.825    57.738     0.200
     4.021    60.038     0.200
     0.408     9.727     0.200
     0.428     9.523     0.200
     0.483    11.625     0.200
     0.540    10.828     0.200
     0.684    14.023     0.200
     0.817    15.227     0.200
     0.976    17.023     0.200
     0.956    17.828     0.200
     1.003    17.828     0.200
     1.171    20.727     0.200
     1.301    21.125     0.200
     1.346    23.930     0.200
     1.439    24.227     0.200
     1.428    24.125     0.200
     1.502    23.930     0.200
     1.481    25.523     0.200
     1.694    27.227     0.200
     1.702    27.430     0.200
     1.805    28.930     0.200
     1.836    29.727     0.200
     1.884    31.523     0.200
     1.925    30.727     0.200
     2.021    32.023     0.200
     2.143    34.328     0.200
     2.255    35.227     0.200
     2.244    34.828     0.200
     2.288    34.227     0.200
     2.375    37.328     0.200
     2.321    37.023     0.200
     2.386    36.930     0.200
     2.427    37.930     0.200
     2.788    43.125     0.200
     2.871    44.328     0.200
     2.919    44.328     0.200
     3.147    47.727     0.200
     3.233    49.023     0.200
     3.360    51.023     0.200
     3.657    55.125     0.200
     3.872    58.227     0.200
     4.323    63.930     0.200
     0.377     9.969     0.200
     0.536    12.562     0.200
     0.815    15.469     0.200
     0.926    16.867     0.200
     1.164    18.664     0.200
     1.217    21.766     0.200
     1.406    23.266     0.200
     1.473    24.664     0.200
     1.586    25.969     0.200
     1.595    26.062     0.200
     1.661    26.766     0.200
     1.763    28.867     0.200
     1.769    28.367     0.200
     1.860    30.367     0.200
     1.939    30.867     0.200
     2.022    32.164     0.200
     2.248    35.766     0.200
     2.277    36.266     0.200
     2.456    38.867     0.200
     2.601    40.664     0.200
     2.561    39.664     0.200
     2.601    40.469     0.200
     2.664    40.664     0.200
     2.577    39.469     0.200
     2.723    41.367     0.200
     2.755    43.062     0.200
     2.717    41.562     0.200
     2.838    43.867     0.200
     2.835    43.664     0.200
     2.817    43.164     0.200
     3.004    45.664     0.200
     3.151    47.062     0.200
     3.204    48.766     0.200
     3.327    50.062     0.200
     3.323    50.164     0.200
     3.442    51.969     0.200
     3.648    55.062     0.200
     3.920    58.562     0.200
     4.320    63.766     0.200
     1.055    18.965     0.200
     1.028    19.762     0.200
     1.091    19.562     0.200
     1.256    22.762     0.200
     1.299    22.562     0.200
     1.376    24.363     0.200
     1.452    25.363     0.200
     1.410    25.164     0.200
     1.471    25.465     0.200
     1.562    26.465     0.200
     1.625    28.262     0.200
     1.687    29.062     0.200
     1.830    30.965     0.200
     1.831    31.062     0.200
     1.848    31.262     0.200
     1.947    32.363     0.200
     1.915    32.465     0.200
     1.903    32.164     0.200
     1.965    33.762     0.200
     2.088    33.363     0.200
     2.119    33.965     0.200
     2.307    37.363     0.200
     2.394    39.062     0.200
     2.504    41.262     0.200
     2.508    41.262     0.200
     2.557    39.664     0.200
     2.553    40.664     0.200
     2.733    44.164     0.200
     2.922    44.863     0.200
     2.919    45.164     0.200
     2.933    46.363     0.200
     3.061    47.863     0.200
     3.253    51.863     0.200
     3.420    53.363     0.200
     3.584    54.965     0.200
     4.064    61.965     0.200
     4.709    72.164     0.200
     6.610    99.965     0.200
     6.610   100.062     0.200
     1.053    18.938     0.200
     1.092    19.535     0.200
     1.289    23.336     0.200
     1.299    22.535     0.200
     1.379    24.637     0.200
     1.413    25.238     0.200
     1.450    25.438     0.200
     1.471    25.738     0.200
     1.561    26.738     0.200
     1.627    28.438     0.200
     1.688    29.336     0.200
     1.830    31.035     0.200
     1.830    31.137     0.200
     1.848    31.438     0.200
     1.905    32.535     0.200
     1.947    32.637     0.200
     1.915    32.535     0.200
     1.967    32.938     0.200
     2.086    33.637     0.200
     2.118    34.738     0.200
     2.306    36.836     0.200
     2.507    41.637     0.200
     2.551    41.137     0.200
     2.555    41.336     0.200
     2.732    44.438     0.200
     2.920    44.836     0.200
     2.918    45.938     0.200
     3.060    48.438     0.200
     3.418    53.637     0.200
     3.583    56.035     0.200
     0.441     8.773     0.200
     0.655    13.070     0.200
     0.743    14.672     0.200
     1.001    17.070     0.200
     1.179    19.273     0.200
     1.073    20.273     0.200
     1.111    19.570     0.200
     1.304    21.273     0.200
     1.364    23.477     0.200
     1.483    23.875     0.200
     1.449    24.273     0.200
     1.483    24.773     0.200
     1.554    25.672     0.200
     1.682    26.773     0.200
     1.639    26.977     0.200
     1.692    27.273     0.200
     1.786    29.977     0.200
     1.928    29.773     0.200
     2.010    31.875     0.200
     2.192    33.875     0.200
     2.239    35.172     0.200
     2.288    35.570     0.200
     2.250    35.477     0.200
     2.200    35.070     0.200
     2.347    37.172     0.200
     2.439    36.875     0.200
     2.569    37.477     0.200
     2.784    42.672     0.200
     2.847    43.477     0.200
     2.880    43.172     0.200
     2.873    44.070     0.200
     3.210    47.875     0.200
     3.254    49.070     0.200
     3.382    50.977     0.200
     3.603    56.273     0.200
     3.716    55.875     0.200
     3.903    58.273     0.200
     4.372    64.273     0.200
     4.576    68.672     0.200
     4.620    68.875     0.200
     4.858    72.773     0.200
     5.034    73.570     0.200
     6.296    89.773     0.200
     6.711    96.477     0.200
     0.544    11.641     0.200
     0.623    11.840     0.200
     0.929    16.641     0.200
     1.075    18.840     0.200
     1.099    19.738     0.200
     1.248    20.539     0.200
     1.285    21.340     0.200
     1.323    21.539     0.200
     1.313    23.039     0.200
     1.497    24.340     0.200
     1.482    24.238     0.200
     1.662    26.340     0.200
     1.665    28.141     0.200
     1.813    29.141     0.200
     1.821    29.340     0.200
     1.894    30.340     0.200
     1.835    29.840     0.200
     2.031    31.938     0.200
     2.028    32.039     0.200
     1.977    31.438     0.200
     2.008    31.039     0.200
     2.087    33.340     0.200
     2.380    36.438     0.200
     2.475    38.238     0.200
     2.461    38.641     0.200
     2.512    38.340     0.200
     2.739    42.238     0.200
     2.832    43.641     0.200
     2.958    44.840     0.200
     3.248    49.539     0.200
     3.468    52.641     0.200
     3.915    59.238     0.200
     0.239     7.392     0.200
     0.396     8.791     0.200
     0.456     9.892     0.200
     0.691    13.791     0.200
     0.728    14.592     0.200
     0.788    12.892     0.200
     0.960    16.691     0.200
     1.220    20.892     0.200
     1.276    21.892     0.200
     1.285    21.092     0.200
     1.354    22.592     0.200
     1.481    24.491     0.200
     1.529    24.191     0.200
     1.547    25.392     0.200
     1.625    26.991     0.200
     1.626    25.892     0.200
     1.647    26.592     0.200
     1.687    27.392     0.200
     1.843    29.191     0.200
     1.881    29.991     0.200
     2.080    33.392     0.200
     2.123    33.491     0.200
     2.131    34.092     0.200
     2.133    34.191     0.200
     2.134    31.892     0.200
     2.268    34.991     0.200
     2.272    35.991     0.200
     2.306    35.592     0.200
     2.380    36.592     0.200
     2.403    37.592     0.200
     2.409    38.191     0.200
     2.471    38.791     0.200
     2.821    42.991     0.200
     2.942    45.592     0.200
     3.050    45.291     0.200
     3.169    47.491     0.200
     3.294    49.291     0.200
     3.558    52.491     0.200
     3.596    54.691     0.200
     3.795    55.991     0.200
     4.229    61.592     0.200
     4.503    66.791     0.200
     4.838    71.791     0.200
     4.928    70.892     0.200
     5.378    76.892     0.200
     5.383    78.991     0.200
     5.648    80.491     0.200
     1.142    20.705     0.200
     1.136    20.205     0.200
     1.191    20.905     0.200
     1.365    23.205     0.200
     1.388    23.905     0.200
     1.429    24.205     0.200
     1.705    28.805     0.200
     1.836    31.005     0.200
     1.846    30.705     0.200
     1.851    30.605     0.200
     1.890    31.705     0.200
     1.949    32.405     0.200
     1.978    32.705     0.200
     2.067    33.005     0.200
     2.461    39.705     0.200
     2.517    40.605     0.200
     2.530    40.905     0.200
     2.593    40.205     0.200
     2.746    42.905     0.200
     2.951    46.605     0.200
     3.216    51.705     0.200
     0.271     7.547     0.200
     0.352     8.148     0.200
     0.390     7.945     0.200
     0.780    14.844     0.200
     0.838    15.547     0.200
     0.981    15.445     0.200
     1.097    18.445     0.200
     1.319    21.648     0.200
     1.399    23.445     0.200
     1.409    23.250     0.200
     1.545    25.445     0.200
     1.604    25.344     0.200
     1.633    26.547     0.200
     1.654    26.445     0.200
     1.725    27.648     0.200
     1.717    27.047     0.200
     1.809    29.945     0.200
     1.837    29.250     0.200
     1.851    29.547     0.200
     1.880    30.047     0.200
     2.166    32.750     0.200
     2.175    34.750     0.200
     2.181    34.148     0.200
     2.186    34.945     0.200
     2.257    35.047     0.200
     2.327    37.250     0.200
     2.334    36.750     0.200
     2.354    37.047     0.200
     2.413    37.547     0.200
     2.427    38.344     0.200
     2.550    38.945     0.200
     2.694    41.547     0.200
     2.791    43.250     0.200
     2.846    43.648     0.200
     2.899    43.344     0.200
     2.930    44.445     0.200
     3.034    45.750     0.200
     3.157    47.445     0.200
     3.405    50.250     0.200
     3.477    52.648     0.200
     3.652    53.844     0.200
     4.077    59.445     0.200
     4.366    64.547     0.200
     5.226    75.547     0.200
     5.496    79.648     0.200
     6.529    94.148     0.200
     0.124     8.297     0.200
     0.542    12.498     0.200
     0.635    12.898     0.200
     0.814    15.398     0.200
     0.970    17.898     0.200
     1.077    19.197     0.200
     1.184    20.598     0.200
     1.242    21.197     0.200
     1.288    21.398     0.200
     1.499    25.197     0.200
     1.528    26.297     0.200
     1.688    26.797     0.200
     1.735    27.797     0.200
     1.752    28.797     0.200
     1.765    29.098     0.200
     1.767    29.898     0.200
     1.845    29.898     0.200
     1.931    31.297     0.200
     1.996    31.598     0.200
     2.100    33.197     0.200
     2.118    34.797     0.200
     2.469    38.797     0.200
     2.444    37.898     0.200
     2.545    40.098     0.200
     2.829    43.898     0.200
     3.035    46.898     0.200
     0.267    10.258     0.200
     0.366     9.859     0.200
     0.361    10.062     0.200
     0.813    16.859     0.200
     0.799    15.859     0.200
     0.971    16.359     0.200
     1.111    19.062     0.200
     1.374    23.258     0.200
     1.345    22.359     0.200
     1.398    23.461     0.200
     1.544    25.461     0.200
     1.576    25.258     0.200
     1.625    26.758     0.200
     1.644    26.961     0.200
     1.730    27.859     0.200
     1.738    27.758     0.200
     1.795    29.758     0.200
     1.811    29.164     0.200
     1.823    29.461     0.200
     1.877    30.164     0.200
     2.153    33.961     0.200
     2.163    34.062     0.200
     2.195    34.961     0.200
     2.192    33.562     0.200
     2.238    35.758     0.200
     2.326    36.664     0.200
     2.384    37.359     0.200
     2.401    38.062     0.200
     2.677    41.164     0.200
     2.824    42.562     0.200
     2.886    42.859     0.200
     3.018    45.258     0.200
     3.141    47.164     0.200
     3.392    50.461     0.200
     3.459    53.164     0.200
     3.638    53.562     0.200
     4.065    59.164     0.200
     4.768    68.758     0.200
     5.214    74.859     0.200
     5.483    79.562     0.200
     0.817    16.371     0.200
     0.999    17.773     0.200
     1.130    20.172     0.200
     1.181    21.273     0.200
     1.324    23.074     0.200
     1.355    23.473     0.200
     1.427    24.473     0.200
     1.594    27.574     0.200
     1.694    29.371     0.200
     1.720    30.172     0.200
     1.747    30.371     0.200
     1.755    30.473     0.200
     1.804    29.172     0.200
     1.893    31.871     0.200
     2.033    34.973     0.200
     2.081    33.473     0.200
     2.544    40.371     0.200
     2.522    41.074     0.200
     2.575    41.371     0.200
     2.649    40.973     0.200
     2.856    44.574     0.200
     2.914    45.871     0.200
     3.042    47.773     0.200
     3.284    51.473     0.200
     3.364    52.574     0.200
     3.559    54.672     0.200
     4.023    61.273     0.200
     0.233    10.250     0.200
     0.309     9.750     0.200
     1.169    19.750     0.200
     1.347    22.852     0.200
     1.533    24.453     0.200
     1.578    25.750     0.200
     1.699    27.652     0.200
     1.748    28.453     0.200
     1.801    28.352     0.200
     1.776    28.453     0.200
     1.765    28.551     0.200
     1.907    30.453     0.200
     2.099    33.453     0.200
     2.103    33.152     0.200
     2.256    33.852     0.200
     2.259    35.750     0.200
     2.216    34.852     0.200
     2.217    34.051     0.200
     2.285    35.352     0.200
     2.337    36.953     0.200
     2.327    36.953     0.200
     2.336    37.352     0.200
     2.479    37.551     0.200
     2.496    38.652     0.200
     2.616    40.250     0.200
     2.711    41.750     0.200
     2.760    42.551     0.200
     2.740    41.750     0.200
     2.830    42.352     0.200
     2.841    43.652     0.200
     2.958    44.652     0.200
     3.082    46.453     0.200
     3.167    49.152     0.200
     3.191    49.152     0.200
     3.337    49.551     0.200
     3.397    51.453     0.200
     3.406    52.152     0.200
     3.580    53.250     0.200
     3.916    58.453     0.200
     4.009    58.453     0.200
     4.291    63.152     0.200
     4.461    66.250     0.200
     4.633    68.453     0.200
     4.711    68.250     0.200
     4.717    69.453     0.200
     5.158    74.051     0.200
     5.169    75.250     0.200
     5.428    77.453     0.200
     5.485    79.953     0.200
     5.783    84.852     0.200
     5.805    84.250     0.200
     5.951    84.551     0.200
     6.382    93.953     0.200
     6.450    90.750     0.200
     6.454    92.152     0.200
     6.829    98.051     0.200
     6.829    97.852     0.200
     6.829    98.352     0.200
     7.014    99.652     0.200
     7.033    98.852     0.200
     7.499   105.551     0.200
     7.493   108.352     0.200
     7.607   109.051     0.200
     7.699   108.551     0.200
     7.697   108.250     0.200
     7.954   110.652     0.200
     7.990   114.852     0.200
     7.992   116.852     0.200
     8.013   111.852     0.200
     8.115   116.051     0.200
     8.203   117.750     0.200
     8.691   125.352     0.200
     8.911   126.551     0.200
    11.215   158.750     0.200
    13.003   182.250     0.200
     0.238    10.109     0.200
     0.297     9.609     0.200
     0.430    10.707     0.200
     0.773    16.207     0.200
     0.869    16.809     0.200
     0.983    16.410     0.200
     1.172    19.809     0.200
     1.335    22.809     0.200
     1.418    23.410     0.200
     1.404    23.910     0.200
     1.520    24.609     0.200
     1.556    25.707     0.200
     1.575    25.910     0.200
     1.702    27.707     0.200
     1.738    28.207     0.200
     1.754    28.707     0.200
     1.775    28.309     0.200
     1.793    30.109     0.200
     1.903    30.609     0.200
     2.091    33.309     0.200
     2.090    33.008     0.200
     2.206    34.508     0.200
     2.266    34.910     0.200
     2.265    36.008     0.200
     2.272    35.609     0.200
     2.315    36.707     0.200
     2.327    36.910     0.200
     2.330    37.410     0.200
     2.476    37.410     0.200
     2.489    38.910     0.200
     2.611    40.109     0.200
     2.699    41.109     0.200
     2.736    42.008     0.200
     2.753    42.609     0.200
     2.827    42.309     0.200
     2.954    44.508     0.200
     3.078    46.207     0.200
     3.186    49.609     0.200
     3.335    49.707     0.200
     3.391    51.410     0.200
     3.577    53.207     0.200
     3.910    58.109     0.200
     4.007    58.508     0.200
     4.288    63.508     0.200
     4.455    66.008     0.200
     4.708    68.109     0.200
     5.156    73.910     0.200
     5.166    75.309     0.200
     5.426    77.309     0.200
     5.948    85.008     0.200
     6.450    92.207     0.200
     6.824    98.508     0.200
     6.824    98.207     0.200
     7.010    99.910     0.200
     0.697    13.548     0.200
     0.700    12.449     0.200
     0.823    15.148     0.200
     1.045    19.048     0.200
     1.042    17.648     0.200
     1.110    19.349     0.200
     1.203    20.449     0.200
     1.275    21.249     0.200
     1.376    23.648     0.200
     1.395    24.048     0.200
     1.508    25.148     0.200
     1.648    27.249     0.200
     1.673    27.548     0.200
     1.783    28.849     0.200
     1.975    32.349     0.200
     1.976    32.249     0.200
     2.087    33.849     0.200
     2.444    38.349     0.200
     2.580    39.048     0.200
     0.152     7.648     0.200
     0.487    11.547     0.200
     0.487    11.848     0.200
     0.518    11.348     0.200
     0.783    14.748     0.200
     0.963    17.547     0.200
     1.050    18.848     0.200
     1.187    20.047     0.200
     1.257    20.848     0.200
     1.359    22.447     0.200
     1.571    24.947     0.200
     1.609    25.748     0.200
     1.676    27.348     0.200
     1.683    27.848     0.200
     1.849    29.148     0.200
     1.887    29.748     0.200
     1.920    31.047     0.200
     2.419    36.748     0.200
     2.532    38.047     0.200
     2.623    40.947     0.200
     2.721    42.148     0.200
     2.891    43.748     0.200
     2.982    45.348     0.200
     3.109    47.248     0.200
     3.401    50.748     0.200
     0.368    10.719     0.200
     0.446    11.023     0.200
     0.762    14.719     0.200
     0.798    15.219     0.200
     1.005    17.820     0.200
     1.179    19.422     0.200
     1.178    20.320     0.200
     1.296    22.320     0.200
     1.350    23.922     0.200
     1.503    25.219     0.200
     1.524    24.820     0.200
     1.544    25.117     0.200
     1.593    26.219     0.200
     1.629    27.320     0.200
     1.857    29.922     0.200
     1.873    30.117     0.200
     2.026    32.523     0.200
     2.404    38.320     0.200
     2.469    38.719     0.200
     2.464    38.820     0.200
     2.609    39.922     0.200
     2.632    40.320     0.200
     2.682    40.820     0.200
     2.790    43.023     0.200
     3.030    46.023     0.200
     3.053    47.117     0.200
     3.048    45.023     0.200
     3.238    48.922     0.200
     3.380    50.023     0.200
     3.436    52.219     0.200
     3.550    53.320     0.200
     3.556    52.922     0.200
     3.675    55.023     0.200
     3.875    57.320     0.200
     4.030    60.117     0.200
     4.151    61.320     0.200
     4.547    65.719     0.200
     4.875    72.023     0.200
     5.104    74.922     0.200
     5.245    77.523     0.200
     5.266    75.922     0.200
     5.691    80.922     0.200
     5.740    84.023     0.200
     5.957    84.422     0.200
     6.480    92.023     0.200
     7.036   100.523     0.200
     0.312     9.551     0.200
     0.510    12.551     0.200
     0.549    12.551     0.200
     0.766    14.852     0.200
     0.893    16.551     0.200
     1.099    18.449     0.200
     1.156    21.250     0.200
     1.405    23.449     0.200
     1.442    24.148     0.200
     1.531    25.148     0.200
     1.617    26.148     0.200
     1.700    28.449     0.200
     1.796    28.352     0.200
     1.861    30.148     0.200
     1.883    30.250     0.200
     1.957    31.648     0.200
     2.213    35.449     0.200
     2.231    35.852     0.200
     2.395    37.852     0.200
     2.536    39.051     0.200
     2.539    39.449     0.200
     2.672    40.551     0.200
     2.802    43.352     0.200
     2.819    41.852     0.200
     2.998    45.551     0.200
     3.157    47.051     0.200
     3.187    48.449     0.200
     3.298    49.648     0.200
     3.322    49.750     0.200
     3.442    51.551     0.200
     3.656    53.949     0.200
     3.789    56.750     0.200
     3.924    57.949     0.200
     4.302    64.551     0.200
     4.329    62.750     0.200
     4.645    68.852     0.200
     4.861    71.551     0.200
     5.009    73.551     0.200
     5.044    73.148     0.200
     5.475    79.148     0.200
     5.515    80.051     0.200
     6.266    89.250     0.200
     6.808    97.148     0.200
     7.382   104.051     0.200
     0.236    10.242     0.200
     0.312     9.742     0.200
     0.987    16.441     0.200
     1.164    19.844     0.200
     1.404    23.242     0.200
     1.348    22.941     0.200
     1.409    23.742     0.200
     1.535    24.844     0.200
     1.575    25.742     0.200
     1.571    26.242     0.200
     1.695    27.641     0.200
     1.752    28.543     0.200
     1.771    28.441     0.200
     1.797    28.441     0.200
     1.769    28.844     0.200
     1.799    29.941     0.200
     1.904    30.543     0.200
     2.104    33.441     0.200
     2.106    33.242     0.200
     2.252    33.844     0.200
     2.254    35.742     0.200
     2.218    34.543     0.200
     2.287    35.844     0.200
     2.334    37.441     0.200
     2.330    36.844     0.200
     2.342    37.344     0.200
     2.484    37.543     0.200
     2.494    39.043     0.200
     2.621    40.242     0.200
     2.714    42.344     0.200
     2.736    42.043     0.200
     2.765    42.941     0.200
     2.834    42.344     0.200
     2.845    43.543     0.200
     2.963    44.844     0.200
     3.087    46.543     0.200
     3.188    49.844     0.200
     3.401    51.844     0.200
     3.585    52.941     0.200
     3.920    58.242     0.200
     4.014    58.742     0.200
     4.296    63.242     0.200
     4.466    66.344     0.200
     4.716    68.242     0.200
     5.163    73.844     0.200
     5.174    75.441     0.200
     5.433    77.543     0.200
     5.489    80.141     0.200
     5.955    84.641     0.200
     6.459    92.242     0.200
     6.834    99.742     0.200
     6.834    99.242     0.200
     7.019   102.344     0.200
     7.612   109.043     0.200
    12.627   177.242     0.200
     0.801    13.844     0.200
     1.095    19.844     0.200
     1.132    20.344     0.200
     1.219    20.742     0.200
     1.203    21.242     0.200
     1.447    24.844     0.200
     1.464    24.539     0.200
     1.564    27.039     0.200
     1.670    28.141     0.200
     1.778    27.438     0.200
     1.803    28.641     0.200
     2.006    31.539     0.200
     1.967    32.242     0.200
     2.199    34.844     0.200
     2.278    36.242     0.200
     2.239    34.938     0.200
     2.240    35.539     0.200
     2.432    38.242     0.200
     2.506    38.938     0.200
     2.629    40.742     0.200
     2.752    42.742     0.200
     2.746    43.938     0.200
     3.099    45.844     0.200
     3.234    49.141     0.200
     3.356    51.844     0.200
     3.449    51.141     0.200
     3.578    53.641     0.200
     3.702    55.242     0.200
     3.955    58.141     0.200
     4.011    60.242     0.200
     4.201    62.141     0.200
     4.531    67.141     0.200
     4.628    66.242     0.200
     4.912    72.039     0.200
     5.071    75.344     0.200
     5.251    76.641     0.200
     5.331    76.539     0.200
     5.777    82.844     0.200
     5.790    84.438     0.200
     6.046    86.141     0.200
     6.104    88.938     0.200
     6.569    93.141     0.200
     7.074   101.141     0.200
     7.441   107.742     0.200
     7.441   107.539     0.200
     7.633   109.242     0.200
     8.226   117.938     0.200
     8.605   124.039     0.200
    11.779   166.938     0.200
    13.048   184.141     0.200
     0.238     9.074     0.200
     0.256    10.174     0.200
     0.466    11.475     0.200
     1.575    26.574     0.200
     1.684    27.373     0.200
     1.695    27.174     0.200
     1.898    30.174     0.200
     2.045    32.873     0.200
     2.146    33.574     0.200
     2.215    34.373     0.200
     2.256    35.273     0.200
     2.319    34.174     0.200
     2.274    35.873     0.200
     2.465    37.975     0.200
     2.450    36.674     0.200
     2.577    39.674     0.200
     2.640    40.773     0.200
     2.734    41.373     0.200
     2.765    41.674     0.200
     2.710    42.574     0.200
     2.780    42.574     0.200
     2.803    41.975     0.200
     2.924    44.174     0.200
     3.048    45.873     0.200
     3.142    48.975     0.200
     3.176    49.174     0.200
     3.311    48.873     0.200
     3.351    50.373     0.200
     3.355    51.373     0.200
     3.549    52.373     0.200
     3.875    57.873     0.200
     3.983    58.273     0.200
     4.258    62.773     0.200
     4.417    65.373     0.200
     4.632    68.674     0.200
     4.594    68.074     0.200
     4.717    69.475     0.200
     4.681    67.574     0.200
     5.131    73.174     0.200
     5.137    73.975     0.200
     5.402    77.273     0.200
     5.447    79.873     0.200
     6.182    90.475     0.200
     6.336    91.273     0.200
     6.419    91.873     0.200
     6.421    90.273     0.200
     6.786    97.773     0.200
     6.786    97.273     0.200
     6.870    99.373     0.200
     6.870    99.574     0.200
     6.947   100.574     0.200
     6.977    99.773     0.200
     6.999    98.574     0.200
     7.149   102.975     0.200
     7.389   107.475     0.200
     7.446   108.273     0.200
     7.470   105.975     0.200
     7.570   108.373     0.200
     7.802   109.373     0.200
     7.922   111.674     0.200
     7.948   114.574     0.200
     7.984   111.174     0.200
     8.152   117.174     0.200
     8.171   114.074     0.200
     8.274   119.975     0.200
     8.446   119.674     0.200
     8.630   123.674     0.200
     8.642   125.373     0.200
     8.767   125.674     0.200
     8.869   126.574     0.200
     9.013   128.174     0.200
     9.037   131.873     0.200
     9.126   131.873     0.200
     9.257   130.273     0.200
     9.457   136.273     0.200
     9.492   135.174     0.200
     9.568   134.574     0.200
     9.645   139.475     0.200
    10.032   145.674     0.200
    10.033   143.475     0.200
    10.508   149.475     0.200
    11.027   156.174     0.200
    11.158   158.475     0.200
    12.365   170.273     0.200
    12.555   175.674     0.200
    12.933   181.074     0.200
    14.435   199.475     0.200
    17.637   239.475     0.200
     0.235     9.363     0.200
     0.438    12.062     0.200
     0.581    13.562     0.200
     0.607    13.664     0.200
     0.933    17.262     0.200
     1.002    16.664     0.200
     1.093    19.562     0.200
     1.437    24.363     0.200
     1.490    24.762     0.200
     1.481    24.762     0.200
     1.509    24.965     0.200
     1.551    26.262     0.200
     1.617    26.363     0.200
     1.856    30.062     0.200
     1.875    30.363     0.200
     1.939    30.062     0.200
     1.966    32.262     0.200
     2.073    33.562     0.200
     2.065    33.164     0.200
     2.325    36.965     0.200
     2.396    37.664     0.200
     2.406    37.863     0.200
     2.731    40.465     0.200
     2.893    44.062     0.200
     3.074    46.062     0.200
     3.224    48.164     0.200
     3.346    50.164     0.200
     3.577    53.262     0.200
     3.680    55.262     0.200
     3.835    56.965     0.200
     4.250    61.762     0.200
     0.390     8.535     0.200
     0.532    10.434     0.200
     0.559    10.734     0.200
     0.790    14.934     0.200
     0.875    15.836     0.200
     0.891    16.234     0.200
     0.982    17.336     0.200
     1.048    18.836     0.200
     1.218    20.133     0.200
     1.175    21.336     0.200
     1.342    23.336     0.200
     1.340    23.234     0.200
     1.483    23.734     0.200
     1.531    24.133     0.200
     1.668    26.836     0.200
     1.826    28.934     0.200
     1.853    30.035     0.200
     1.914    30.234     0.200
     2.206    35.035     0.200
     2.306    36.336     0.200
     2.352    35.434     0.200
     2.956    45.734     0.200
     3.451    53.133     0.200
     4.425    66.836     0.200
     0.247    10.215     0.200
     0.409    10.617     0.200
     1.014    16.516     0.200
     1.114    19.316     0.200
     1.317    22.215     0.200
     1.429    24.215     0.200
     1.443    24.215     0.200
     1.575    25.816     0.200
     1.652    27.215     0.200
     1.628    25.914     0.200
     1.668    27.316     0.200
     1.724    27.617     0.200
     1.750    28.316     0.200
     1.843    29.816     0.200
     1.843    30.117     0.200
     1.866    30.016     0.200
     1.911    30.516     0.200
     2.162    32.816     0.200
     2.182    34.914     0.200
     2.184    34.617     0.200
     2.202    34.715     0.200
     2.294    35.816     0.200
     2.360    37.617     0.200
     2.379    37.215     0.200
     2.427    38.215     0.200
     2.534    38.215     0.200
     2.530    39.117     0.200
     2.683    41.316     0.200
     2.737    41.816     0.200
     2.811    43.117     0.200
     2.841    43.715     0.200
     2.881    43.016     0.200
     2.932    44.715     0.200
     3.020    45.516     0.200
     3.143    47.316     0.200
     3.192    49.617     0.200
     3.202    49.715     0.200
     3.387    50.215     0.200
     3.467    52.617     0.200
     3.491    53.016     0.200
     3.637    54.016     0.200
     3.984    58.516     0.200
     4.060    59.016     0.200
     4.351    63.914     0.200
     4.534    67.215     0.200
     4.699    69.316     0.200
     4.706    69.715     0.200
     4.766    68.816     0.200
     4.860    71.715     0.200
     5.209    74.215     0.200
     5.227    76.316     0.200
     5.478    77.914     0.200
     5.549    81.016     0.200
     5.674    83.016     0.200
     6.001    85.414     0.200
     6.515    93.316     0.200
     6.800    95.816     0.200
     6.901   100.016     0.200
     6.901    98.016     0.200
     7.077   102.215     0.200
     7.092   100.117     0.200
     7.498   108.617     0.200
     7.671   109.914     0.200
     7.742   109.617     0.200
     7.794   109.016     0.200
     8.889   128.316     0.200
    12.723   178.215     0.200
    13.095   182.516     0.200
    17.772   240.914     0.200
     0.651    12.775     0.200
     0.877    16.775     0.200
     1.061    19.475     0.200
     1.100    18.775     0.200
     1.235    21.175     0.200
     1.251    21.275     0.200
     1.365    24.175     0.200
     1.404    25.175     0.200
     1.445    23.775     0.200
     1.546    24.975     0.200
     1.656    28.075     0.200
     1.650    27.875     0.200
     1.705    27.875     0.200
     1.746    28.675     0.200
     1.841    29.875     0.200
     1.959    30.775     0.200
     1.993    33.375     0.200
     2.003    32.075     0.200
     1.999    32.375     0.200
     2.402    37.475     0.200
     2.529    37.875     0.200
     2.575    40.875     0.200
     2.639    41.175     0.200
     2.661    41.475     0.200
     2.684    42.275     0.200
     2.936    44.875     0.200
     3.006    46.575     0.200
     3.133    48.375     0.200
     3.385    53.275     0.200
     3.909    60.875     0.200
     4.107    62.375     0.200
     4.423    67.475     0.200
     4.783    70.975     0.200
     6.792   102.175     0.200
     0.257    10.422     0.200
     0.373     9.922     0.200
     0.364    10.227     0.200
     0.804    16.125     0.200
     0.981    16.125     0.200
     1.118    19.227     0.200
     1.382    23.727     0.200
     1.409    23.727     0.200
     1.347    22.523     0.200
     1.554    25.227     0.200
     1.582    25.422     0.200
     1.652    27.125     0.200
     1.627    26.828     0.200
     1.739    28.023     0.200
     1.742    27.922     0.200
     1.805    29.922     0.200
     1.825    29.828     0.200
     1.810    29.422     0.200
     1.887    30.328     0.200
     2.157    34.023     0.200
     2.200    35.125     0.200
     2.160    34.227     0.200
     2.248    34.922     0.200
     2.194    33.328     0.200
     2.328    37.328     0.200
     2.332    36.328     0.200
     2.386    37.625     0.200
     2.529    37.727     0.200
     2.671    41.125     0.200
     2.820    43.625     0.200
     2.903    44.328     0.200
     2.878    42.922     0.200
     3.011    45.422     0.200
     3.134    47.125     0.200
     3.384    50.125     0.200
     3.453    52.523     0.200
     3.631    53.727     0.200
     4.057    59.227     0.200
     4.343    64.227     0.200
     4.518    67.125     0.200
     4.688    69.328     0.200
     4.761    68.828     0.200
     5.206    74.328     0.200
     6.506    93.328     0.200
     0.186     7.598     0.200
     0.438    10.895     0.200
     0.619    11.496     0.200
     0.633    12.598     0.200
     0.698    13.098     0.200
     0.772    14.195     0.200
     1.046    18.695     0.200
     1.070    19.195     0.200
     1.076    18.195     0.200
     1.146    20.098     0.200
     1.224    20.895     0.200
     1.334    22.395     0.200
     1.333    22.297     0.200
     1.416    23.996     0.200
     1.476    24.695     0.200
     1.671    26.598     0.200
     1.780    29.496     0.200
     1.880    30.098     0.200
     1.911    31.695     0.200
     1.908    29.297     0.200
     2.073    32.598     0.200
     2.119    32.895     0.200
     2.163    34.395     0.200
     2.228    34.797     0.200
     2.300    35.996     0.200
     2.375    36.598     0.200
     2.584    40.895     0.200
     2.624    40.395     0.200
     3.032    45.395     0.200
     3.153    47.996     0.200
     3.259    50.195     0.200
     3.385    50.395     0.200
     3.503    52.395     0.200
     3.628    54.098     0.200
     3.893    57.797     0.200
     3.925    60.098     0.200
     4.130    60.797     0.200
     4.564    66.496     0.200
     4.837    71.195     0.200
     0.372     9.305     0.200
     0.595    12.008     0.200
     0.715    13.109     0.200
     0.721    14.008     0.200
     0.709    14.211     0.200
     0.961    17.805     0.200
     1.037    18.211     0.200
     1.082    18.305     0.200
     1.045    18.609     0.200
     1.064    20.008     0.200
     1.095    18.906     0.200
     1.310    22.711     0.200
     1.387    22.711     0.200
     1.374    23.508     0.200
     1.471    24.805     0.200
     1.567    25.305     0.200
     1.530    25.211     0.200
     1.642    28.109     0.200
     1.721    28.211     0.200
     1.760    28.406     0.200
     1.765    28.211     0.200
     1.772    29.008     0.200
     2.094    33.008     0.200
     2.150    34.305     0.200
     2.265    35.211     0.200
     2.263    36.305     0.200
     2.489    37.008     0.200
     2.864    43.906     0.200
     2.902    44.805     0.200
     2.943    44.609     0.200
     2.946    45.008     0.200
     3.264    48.508     0.200
     3.316    49.805     0.200
     3.444    52.805     0.200
     3.672    56.406     0.200
     4.429    65.211     0.200
     4.692    70.406     0.200
     5.096    73.906     0.200
     6.779    97.109     0.200
     0.179     8.766     0.200
     0.255     9.766     0.200
     0.558    12.070     0.200
     1.006    18.672     0.200
     1.010    17.469     0.200
     1.255    21.766     0.200
     1.292    21.367     0.200
     1.405    23.070     0.200
     1.415    24.266     0.200
     1.415    23.469     0.200
     1.563    25.266     0.200
     1.592    26.172     0.200
     1.613    26.469     0.200
     1.634    27.070     0.200
     1.784    29.766     0.200
     1.811    29.070     0.200
     1.860    29.867     0.200
     1.945    30.766     0.200
     1.950    31.672     0.200
     1.952    31.367     0.200
     1.961    31.266     0.200
     2.132    33.172     0.200
     2.159    33.969     0.200
     2.174    34.766     0.200
     2.347    37.570     0.200
     2.368    36.867     0.200
     2.401    37.969     0.200
     2.411    36.367     0.200
     2.489    38.766     0.200
     2.723    41.070     0.200
     2.789    43.070     0.200
     2.837    43.367     0.200
     2.962    44.969     0.200
     3.219    50.070     0.200
     3.231    48.969     0.200
     3.465    51.367     0.200
     3.902    57.469     0.200
     4.598    66.766     0.200
     0.083     6.812     0.200
     0.355     9.211     0.200
     0.642    12.312     0.200
     0.993    17.012     0.200
     1.094    19.211     0.200
     1.157    20.211     0.200
     1.289    21.012     0.200
     1.297    21.412     0.200
     1.380    23.611     0.200
     1.494    24.211     0.200
     1.668    26.211     0.200
     1.638    26.912     0.200
     1.733    29.111     0.200
     1.864    29.812     0.200
     1.841    29.211     0.200
     1.866    30.012     0.200
     1.889    30.312     0.200
     1.943    31.611     0.200
     2.031    31.312     0.200
     2.035    31.912     0.200
     2.043    32.711     0.200
     2.055    32.312     0.200
     2.328    35.512     0.200
     2.314    37.012     0.200
     2.431    38.111     0.200
     2.444    38.111     0.200
     2.485    38.812     0.200
     2.446    38.412     0.200
     2.517    37.312     0.200
     2.537    39.912     0.200
     2.588    39.812     0.200
     2.686    40.812     0.200
     2.785    42.812     0.200
     2.785    43.211     0.200
     2.911    44.512     0.200
     3.195    48.312     0.200
     3.199    50.012     0.200
     3.198    49.812     0.200
     3.419    51.611     0.200
     3.721    57.111     0.200
     3.863    57.211     0.200
     4.120    61.512     0.200
     4.255    64.312     0.200
     4.445    68.912     0.200
     4.553    66.412     0.200
     5.002    73.812     0.200
     5.010    71.912     0.200
     5.281    75.812     0.200
     5.803    82.611     0.200
     6.278    90.312     0.200
     6.626    97.111     0.200
     6.626    97.111     0.200
     7.278   109.412     0.200
     0.229     9.342     0.200
     0.483    12.143     0.200
     0.544    13.041     0.200
     0.714    14.643     0.200
     0.851    16.143     0.200
     1.017    17.541     0.200
     0.980    17.742     0.200
     1.400    23.643     0.200
     1.401    23.441     0.200
     1.449    24.541     0.200
     1.459    24.541     0.200
     1.559    25.541     0.200
     1.810    29.541     0.200
     1.874    30.941     0.200
     1.826    28.643     0.200
     1.858    31.041     0.200
     2.317    37.342     0.200
     2.455    38.242     0.200
     2.519    39.541     0.200
     2.605    39.742     0.200
     2.999    45.541     0.200
     3.172    46.742     0.200
     3.328    49.643     0.200
     3.450    51.842     0.200
     3.674    53.842     0.200
     3.936    58.143     0.200
     4.347    62.941     0.200
     4.655    68.342     0.200
     5.059    73.742     0.200
     0.079     6.773     0.200
     0.359     9.172     0.200
     0.643    12.273     0.200
     1.153    20.172     0.200
     1.285    21.070     0.200
     1.294    21.477     0.200
     1.378    23.375     0.200
     1.485    23.875     0.200
     1.492    23.875     0.200
     1.636    26.875     0.200
     1.670    26.172     0.200
     1.729    28.773     0.200
     1.864    29.773     0.200
     1.866    29.773     0.200
     1.887    30.375     0.200
     1.941    31.977     0.200
     1.943    30.477     0.200
     2.032    31.273     0.200
     2.031    31.773     0.200
     2.040    32.172     0.200
     2.053    32.070     0.200
     2.329    35.375     0.200
     2.312    37.375     0.200
     2.431    37.875     0.200
     2.443    37.672     0.200
     2.441    37.977     0.200
     2.486    38.570     0.200
     2.519    36.773     0.200
     2.537    39.875     0.200
     2.587    39.977     0.200
     2.687    41.172     0.200
     2.786    42.570     0.200
     2.783    43.172     0.200
     2.912    44.172     0.200
     3.167    48.570     0.200
     3.196    48.172     0.200
     3.200    49.375     0.200
     3.195    49.672     0.200
     3.420    50.875     0.200
     3.721    55.977     0.200
     3.864    57.172     0.200
     4.121    60.977     0.200
     4.255    64.070     0.200
     4.445    66.672     0.200
     4.554    66.375     0.200
     5.003    73.172     0.200
     5.011    72.070     0.200
     5.282    75.570     0.200
     5.301    77.672     0.200
     5.368    79.172     0.200
     5.804    82.375     0.200
     6.279    89.977     0.200
     6.626    97.477     0.200
     6.626    95.070     0.200
     6.787    97.977     0.200
     6.832    97.672     0.200
     6.861    97.070     0.200
     7.278   108.070     0.200
     7.795   113.070     0.200
    12.351   174.977     0.200
     0.375     8.398     0.200
     0.406     8.500     0.200
     0.572    10.602     0.200
     0.649    12.805     0.200
     0.773    14.398     0.200
     0.950    16.500     0.200
     0.994    18.000     0.200
     1.058    18.898     0.200
     1.186    19.898     0.200
     1.352    21.805     0.200
     1.390    23.703     0.200
     1.425    23.898     0.200
     1.430    24.000     0.200
     1.503    25.500     0.200
     1.541    24.305     0.200
     1.669    26.305     0.200
     1.733    27.203     0.200
     1.832    28.703     0.200
     1.891    30.500     0.200
     1.918    31.805     0.200
     1.973    32.000     0.200
     2.079    33.398     0.200
     2.112    34.398     0.200
     2.244    33.500     0.200
     2.272    35.398     0.200
     2.786    43.203     0.200
     2.877    44.203     0.200
     2.951    46.398     0.200
     3.363    50.305     0.200
     3.637    56.102     0.200
     3.873    57.805     0.200
     4.321    63.398     0.200
     0.139     8.617     0.200
     0.379    11.117     0.200
     0.726    14.719     0.200
     0.738    14.418     0.200
     0.893    15.719     0.200
     0.907    15.918     0.200
     0.939    16.918     0.200
     1.274    22.016     0.200
     1.315    21.816     0.200
     1.334    22.918     0.200
     1.410    23.816     0.200
     1.424    24.016     0.200
     1.566    26.117     0.200
     1.676    27.816     0.200
     2.223    34.617     0.200
     4.090    61.617     0.200
     4.401    64.117     0.200
     4.401    65.316     0.200
     6.572    94.117     0.200
     7.311   104.117     0.200
     7.311   104.516     0.200
     8.300   118.816     0.200
     9.531   137.016     0.200
     9.909   136.516     0.200
    10.561   151.117     0.200
    10.741   151.617     0.200
    12.659   178.617     0.200
    13.056   181.316     0.200
    13.266   187.117     0.200
    16.108   223.117     0.200
    17.584   240.016     0.200
    17.814   243.117     0.200
    20.067   270.016     0.200
     0.349     9.621     0.200
     0.311    10.121     0.200
     0.331     9.820     0.200
     0.708    14.320     0.200
     0.793    15.723     0.200
     0.918    15.723     0.200
     1.090    18.820     0.200
     1.323    23.023     0.200
     1.344    23.223     0.200
     1.356    22.523     0.200
     2.646    40.922     0.200
     4.513    67.422     0.200
     4.635    70.121     0.200
     4.635    71.422     0.200
     4.635    69.422     0.200
     6.904    98.422     0.200
     6.904    98.922     0.200
     8.547   123.820     0.200
    12.660   177.922     0.200
    17.664   240.223     0.200
     0.307    10.367     0.200
     0.343     9.766     0.200
     0.345    10.070     0.200
     0.721    14.469     0.200
     0.785    15.867     0.200
     0.926    15.766     0.200
     1.085    18.867     0.200
     1.345    22.367     0.200
     1.337    23.172     0.200
     1.353    23.266     0.200
     1.833    29.672     0.200
     2.637    40.367     0.200
     4.504    67.469     0.200
     4.639    68.867     0.200
     6.910    99.469     0.200
     6.910    99.766     0.200
     8.550   123.469     0.200
     9.558   132.570     0.200
    12.673   177.969     0.200
    16.134   222.469     0.200
     0.240     7.225     0.200
     0.398     8.725     0.200
     0.595    11.123     0.200
     0.689    13.725     0.200
     0.752    12.623     0.200
     0.945    16.523     0.200
     1.183    20.424     0.200
     1.247    21.623     0.200
     1.292    20.824     0.200
     2.547    39.123     0.200
     4.411    66.725     0.200
     4.459    65.924     0.200
     4.459    67.225     0.200
     6.616    95.725     0.200
     7.039   101.424     0.200
     7.039   101.523     0.200
     8.371   120.523     0.200
    10.370   149.424     0.200
     0.134     8.180     0.200
     0.356    10.480     0.200
     0.614    12.680     0.200
     0.739    14.480     0.200
     0.751    14.180     0.200
     0.725    13.379     0.200
     0.985    17.277     0.200
     1.149    20.180     0.200
     1.148    20.379     0.200
     1.224    21.180     0.200
     1.262    21.379     0.200
     1.279    21.379     0.200
     1.439    24.180     0.200
     1.489    24.980     0.200
     2.209    34.980     0.200
     4.071    61.879     0.200
     4.233    62.480     0.200
     7.376   107.879     0.200
     8.137   117.680     0.200
    10.569   151.680     0.200
    20.107   272.980     0.200
     0.284     9.840     0.200
     0.370     9.840     0.200
     0.329     9.742     0.200
     0.811    15.941     0.200
     0.944    16.141     0.200
     1.113    19.141     0.200
     1.337    23.340     0.200
     1.367    22.441     0.200
     1.369    23.641     0.200
     1.855    30.141     0.200
     2.662    40.641     0.200
     4.529    67.641     0.200
     4.663    69.641     0.200
     4.663    71.941     0.200
     6.820    99.039     0.200
     6.883    98.641     0.200
     6.883    99.641     0.200
     8.298   118.641     0.200
     8.574   123.441     0.200
     9.639   139.242     0.200
    10.096   143.641     0.200
    10.527   150.840     0.200
    10.980   156.242     0.200
    12.264   171.141     0.200
    12.654   177.742     0.200
    12.750   178.641     0.200
    13.005   182.242     0.200
    13.313   185.441     0.200
    14.516   202.242     0.200
    15.184   209.441     0.200
    16.148   222.840     0.200
    17.681   241.172     0.200
     0.331     9.826     0.200
     0.351     9.826     0.200
     0.308    10.226     0.200
     0.710    14.426     0.200
     0.795    15.926     0.200
     0.921    15.826     0.200
     1.092    18.926     0.200
     1.324    23.026     0.200
     1.346    23.226     0.200
     1.357    22.426     0.200
     2.648    40.426     0.200
     4.515    67.226     0.200
     4.638    69.226     0.200
     4.638    71.226     0.200
     6.796    97.926     0.200
     6.901    98.526     0.200
     6.901    98.226     0.200
     6.901    98.826     0.200
     8.291   119.226     0.200
     8.550   123.026     0.200
     9.616   139.226     0.200
    10.086   143.226     0.200
    10.508   149.026     0.200
    10.956   155.226     0.200
    12.248   169.526     0.200
    12.659   177.426     0.200
    12.727   177.726     0.200
    12.997   181.626     0.200
    13.079   181.226     0.200
    14.511   201.826     0.200
    14.918   207.326     0.200
    15.542   215.426     0.200
    15.546   214.526     0.200
    16.126   222.226     0.200
    17.665   240.526     0.200
     0.285     9.867     0.200
     0.291     9.367     0.200
     0.396    10.266     0.200
     0.705    14.164     0.200
     0.841    16.367     0.200
     0.936    15.965     0.200
     1.135    19.367     0.200
     1.306    22.465     0.200
     1.358    23.266     0.200
     1.402    22.965     0.200
     2.694    40.867     0.200
     4.561    67.766     0.200
     4.667    69.465     0.200
     6.823    99.465     0.200
     6.857    97.766     0.200
     6.857    99.254     0.200
     8.262   118.766     0.200
     8.579   123.766     0.200
     9.514   131.867     0.200
     9.629   139.066     0.200
    10.063   146.266     0.200
    10.506   149.766     0.200
    10.982   156.867     0.200
    11.267   160.566     0.200
    12.293   171.766     0.200
    12.617   177.414     0.200
    12.738   181.465     0.200
    12.970   181.766     0.200
    13.125   185.465     0.200
    14.989   206.527     0.200
    15.545   216.465     0.200
    16.131   223.164     0.200
    20.732   280.766     0.200
     0.331    10.223     0.200
     0.547    12.020     0.200
     0.565    12.223     0.200
     1.049    18.320     0.200
     1.134    19.020     0.200
     1.215    21.422     0.200
     1.227    20.723     0.200
     1.290    20.820     0.200
     1.405    22.223     0.200
     1.472    24.820     0.200
     1.497    24.820     0.200
     1.582    26.422     0.200
     1.627    27.422     0.200
     1.896    29.820     0.200
     3.758    57.320     0.200
     4.421    65.520     0.200
     7.599   107.320     0.200
    10.707   153.520     0.200
    11.516   163.121     0.200
    13.462   188.934     0.200
    13.658   192.422     0.200
    14.234   199.422     0.200
    15.228   211.121     0.200
    17.452   236.621     0.200
     0.151     8.699     0.200
     0.375    11.199     0.200
     0.747    14.398     0.200
     0.727    14.699     0.200
     0.905    15.797     0.200
     0.929    16.898     0.200
     0.918    15.898     0.200
     1.310    21.699     0.200
     1.345    22.898     0.200
     1.407    23.898     0.200
     1.418    23.898     0.200
     1.429    23.898     0.200
     1.578    25.996     0.200
     1.685    27.898     0.200
     2.216    34.598     0.200
     4.083    62.098     0.200
     4.406    64.598     0.200
     6.577    94.598     0.200
     7.315   104.098     0.200
     8.304   119.598     0.200
     9.539   136.898     0.200
     9.910   137.199     0.200
    10.572   151.398     0.200
    10.746   153.098     0.200
    11.821   166.098     0.200
    12.655   176.996     0.200
    12.667   178.797     0.200
    13.066   182.547     0.200
    14.922   206.898     0.200
    15.510   215.598     0.200
    15.544   214.898     0.200
    16.117   222.699     0.200
    17.585   239.887     0.200
     0.457    10.312     0.200
     0.737    13.812     0.200
     1.000    17.312     0.200
     1.073    19.410     0.200
     1.180    20.012     0.200
     1.182    20.512     0.200
     1.189    21.012     0.200
     1.953    31.910     0.200
     3.048    46.109     0.200
     4.792    71.711     0.200
     4.913    73.211     0.200
     6.553    96.711     0.200
     6.553    97.262     0.200
     8.703   126.012     0.200
     9.294   130.512     0.200
    10.351   150.910     0.200
    12.629   176.711     0.200
    15.035   208.562     0.200
    15.313   215.711     0.200
    18.160   248.312     0.200
     0.234     8.969     0.200
     0.312    10.070     0.200
     0.429    10.672     0.200
     0.660    13.367     0.200
     0.911    15.969     0.200
     0.879    16.766     0.200
     1.159    19.766     0.200
     1.250    21.469     0.200
     1.328    22.766     0.200
     1.444    23.367     0.200
     1.451    23.570     0.200
     1.501    24.570     0.200
     1.840    30.516     0.200
     2.735    41.867     0.200
     4.602    68.570     0.200
     4.660    69.469     0.200
     6.827    98.070     0.200
     6.827    99.305     0.200
     9.598   137.469     0.200
    10.004   144.570     0.200
    10.969   153.969     0.200
    12.330   171.969     0.200
    12.562   176.719     0.200
    12.704   177.672     0.200
    13.160   182.070     0.200
    13.238   184.820     0.200
    14.420   201.070     0.200
    15.178   210.016     0.200
    15.517   213.172     0.200
    17.598   240.375     0.200
     0.174     8.767     0.200
     0.481    11.367     0.200
     0.539    12.767     0.200
     0.608    13.167     0.200
     0.859    15.167     0.200
     0.881    16.467     0.200
     0.947    15.867     0.200
     1.076    18.667     0.200
     1.381    23.267     0.200
     1.473    23.867     0.200
     1.510    24.967     0.200
     1.519    25.667     0.200
     1.776    28.967     0.200
     2.376    36.567     0.200
     4.243    63.367     0.200
     4.530    65.667     0.200
     7.151   104.567     0.200
     7.151   103.255     0.200
     8.434   121.367     0.200
     9.752   135.967     0.200
    10.598   153.067     0.200
    10.865   153.567     0.200
    11.984   170.567     0.200
    12.739   179.967     0.200
    12.937   183.867     0.200
    15.352   211.117     0.200
     0.286     9.797     0.200
     0.363     9.797     0.200
     0.337     9.695     0.200
     0.732    14.500     0.200
     0.804    15.898     0.200
     0.944    16.000     0.200
     1.106    19.195     0.200
     1.343    23.195     0.200
     1.370    23.500     0.200
     1.359    22.297     0.200
     1.854    29.898     0.200
     2.654    42.000     0.200
     4.521    66.797     0.200
     4.660    69.000     0.200
     6.818    98.797     0.200
     6.890    98.797     0.200
     6.890    97.906     0.200
     8.571   123.594     0.200
     9.537   132.297     0.200
    10.102   145.094     0.200
    10.530   150.898     0.200
    10.978   155.594     0.200
    12.663   178.047     0.200
    12.663   177.703     0.200
    12.751   177.898     0.200
    13.012   181.898     0.200
    13.321   184.695     0.200
    14.523   202.195     0.200
    14.941   208.094     0.200
    15.188   209.594     0.200
    16.150   222.297     0.200
     0.629    12.012     0.200
     0.614    12.312     0.200
     0.732    13.211     0.200
     0.908    17.211     0.200
     1.059    18.711     0.200
     1.099    19.512     0.200
     1.119    19.012     0.200
     1.246    20.910     0.200
     1.252    21.312     0.200
     2.903    44.609     0.200
     4.524    67.812     0.200
     4.758    70.711     0.200
     6.771    99.711     0.200
     6.771    99.672     0.200
     8.435   120.812     0.200
     9.341   136.711     0.200
     9.550   133.910     0.200
    10.143   147.609     0.200
    10.798   156.211     0.200
    12.306   174.211     0.200
    12.436   177.012     0.200
    13.268   187.910     0.200
    14.584   204.211     0.200
    15.208   212.711     0.200
    15.236   212.410     0.200
    15.303   211.812     0.200
    17.259   238.609     0.200
    17.903   245.512     0.200
     0.148     9.383     0.200
     0.543    12.984     0.200
     0.577    12.883     0.200
     0.774    15.281     0.200
     0.961    17.383     0.200
     0.987    18.680     0.200
     1.096    18.883     0.200
     1.120    19.883     0.200
     1.223    21.586     0.200
     1.310    22.586     0.200
     1.347    22.883     0.200
     1.449    23.781     0.200
     1.566    25.680     0.200
     1.631    27.680     0.200
     1.678    27.484     0.200
     1.768    28.984     0.200
     1.911    31.086     0.200
     3.081    46.383     0.200
     4.751    70.383     0.200
     4.942    72.883     0.200
     6.550    94.383     0.200
     6.550    93.930     0.200
     6.878    98.883     0.200
     8.660   124.281     0.200
     9.318   128.586     0.200
     9.680   139.484     0.200
    10.267   147.180     0.200
    11.016   157.383     0.200
    12.181   172.641     0.200
    12.181   172.383     0.200
    12.569   177.180     0.200
    12.610   179.883     0.200
    15.356   212.984     0.200
    15.400   214.180     0.200
    15.952   220.383     0.200
    17.329   236.195     0.200
     0.230     9.094     0.200
     0.267    10.094     0.200
     0.268    10.586     0.200
     0.406    10.496     0.200
     0.722    14.395     0.200
     0.849    16.496     0.200
     0.955    16.195     0.200
     1.147    19.496     0.200
     1.320    22.797     0.200
     1.377    23.594     0.200
     1.405    23.094     0.200
     1.874    30.246     0.200
     2.700    40.996     0.200
     4.567    67.695     0.200
     4.685    69.594     0.200
     5.439    79.695     0.200
     6.846    97.965     0.200
     6.846    97.695     0.200
     6.846    98.230     0.200
     6.841    98.695     0.200
     8.272   118.695     0.200
     8.597   123.695     0.200
     9.500   132.145     0.200
     9.647   137.695     0.200
    10.074   142.996     0.200
    10.523   148.695     0.200
    11.000   154.695     0.200
    12.618   176.504     0.200
    12.618   177.195     0.200
    12.756   177.797     0.200
    12.981   180.695     0.200
    13.134   182.297     0.200
    13.274   184.645     0.200
    14.488   201.695     0.200
    14.940   206.996     0.200
    15.159   210.195     0.200
    15.159   210.195     0.200
    15.563   214.797     0.200
    15.572   214.395     0.200
    16.149   222.695     0.200
    16.620   227.496     0.200
     0.162     8.922     0.200
     0.305    10.422     0.200
     0.436    10.922     0.200
     0.664    13.820     0.200
     0.886    17.023     0.200
     0.918    16.117     0.200
     1.167    19.922     0.200
     1.252    21.820     0.200
     1.334    22.922     0.200
     1.457    23.922     0.200
     1.443    23.422     0.200
     1.848    30.117     0.200
     2.742    41.820     0.200
     4.608    68.320     0.200
     4.668    69.617     0.200
     6.820    98.539     0.200
     6.820    98.258     0.200
    10.005   141.617     0.200
    12.911   182.820     0.200
    17.601   240.188     0.200
    18.606   252.320     0.200
    19.556   263.469     0.200
     0.278     9.855     0.200
     0.318     9.555     0.200
     0.348     9.457     0.200
     0.778    15.555     0.200
     0.774    14.957     0.200
     0.971    16.156     0.200
     1.093    18.957     0.200
     1.321    21.855     0.200
     1.390    23.855     0.200
     1.400    23.855     0.200
     1.872    30.656     0.200
     2.622    40.258     0.200
     4.670    70.156     0.200
     6.913   100.957     0.200
     6.913    99.941     0.200
     0.253     9.188     0.200
     0.459    10.891     0.200
     0.578    12.492     0.200
     0.565    12.992     0.200
     0.938    16.391     0.200
     0.927    16.992     0.200
     1.031    17.086     0.200
     1.060    18.391     0.200
     1.466    24.688     0.200
     4.597    67.688     0.200
     7.137   102.586     0.200
     7.137   102.289     0.200
     0.220     9.164     0.200
     0.301    10.469     0.200
     0.387    10.266     0.200
     0.692    14.164     0.200
     0.834    16.367     0.200
     0.920    15.867     0.200
     1.124    19.367     0.200
     1.295    22.570     0.200
     1.343    23.164     0.200
     1.399    23.164     0.200
     1.840    29.664     0.200
     2.688    40.867     0.200
     4.555    67.266     0.200
     4.652    68.867     0.200
     4.652    68.750     0.200
     6.866    98.273     0.200
     6.866    98.266     0.200
     6.866    97.867     0.200
     6.866    98.914     0.200
     9.527   133.070     0.200
    10.053   143.164     0.200
    12.962   181.367     0.200
    13.286   184.969     0.200
    14.473   201.469     0.200
    17.640   240.758     0.200
     0.272     9.512     0.200
     0.342     9.711     0.200
     0.311    10.411     0.200
     0.715    14.512     0.200
     0.785    15.812     0.200
     0.921    15.812     0.200
     1.084    18.812     0.200
     1.332    23.111     0.200
     1.348    23.312     0.200
     1.346    22.312     0.200
     2.638    40.312     0.200
     4.504    67.911     0.200
     4.635    68.111     0.200
     6.910    98.802     0.200
     6.910    98.611     0.200
     6.910    99.111     0.200
     6.910    99.161     0.200
     8.546   122.611     0.200
    10.953   155.111     0.200
    13.006   181.111     0.200
    17.672   241.052     0.200
     0.160    10.723     0.200
     0.401    12.824     0.200
     0.618    14.223     0.200
     0.661    14.723     0.200
     0.756    16.023     0.200
     0.913    17.324     0.200
     0.937    17.121     0.200
     0.943    17.922     0.200
     1.366    23.723     0.200
     1.332    22.621     0.200
     1.445    24.723     0.200
     1.437    24.621     0.200
     1.458    24.723     0.200
     1.584    27.023     0.200
     2.236    35.023     0.200
     4.103    61.223     0.200
     4.435    66.223     0.200
     7.291   103.812     0.200
     7.291   103.922     0.200
     7.291   104.223     0.200
     7.291   103.621     0.200
    10.346   147.523     0.200
    10.346   144.164     0.200
    13.057   184.473     0.200
    13.284   184.223     0.200
    14.546   198.121     0.200
     0.231     9.369     0.200
     0.285    10.469     0.200
     0.391    10.369     0.200
     0.710    14.469     0.200
     0.835    16.469     0.200
     0.937    16.268     0.200
     1.131    19.469     0.200
     1.312    22.768     0.200
     1.360    23.369     0.200
     1.395    23.068     0.200
     1.855    29.869     0.200
     4.554    68.768     0.200
     4.667    69.869     0.200
     4.667    68.568     0.200
     6.862    98.178     0.200
     6.862    98.568     0.200
     6.862    98.369     0.200
     6.862    98.994     0.200
     8.578   125.568     0.200
     9.631   137.369     0.200
     9.517   131.869     0.200
    10.069   141.279     0.200
    12.740   180.568     0.200
    12.977   182.668     0.200
    14.925   208.068     0.200
    16.134   222.568     0.200
    17.658   241.180     0.200
     0.392    10.055     0.200
     0.439    10.750     0.200
     0.684    13.648     0.200
     0.835    15.352     0.200
     0.818    14.852     0.200
     0.836    15.055     0.200
     1.161    19.750     0.200
     1.143    18.648     0.200
     7.348   105.453     0.200
     7.348   105.250     0.200
     7.348   104.852     0.200
    10.577   153.648     0.200
    13.512   188.852     0.200
     0.408    10.266     0.200
     0.418    10.465     0.200
     0.718    13.664     0.200
     0.784    14.266     0.200
     0.814    14.965     0.200
     0.865    15.363     0.200
     1.161    19.066     0.200
     1.167    19.363     0.200
     1.256    20.465     0.200
     1.483    24.766     0.200
     1.567    25.566     0.200
     1.589    26.566     0.200
     1.616    26.566     0.200
     1.881    30.465     0.200
     3.977    62.965     0.200
     4.538    66.965     0.200
     7.382   105.465     0.200
     7.382   105.066     0.200
     7.382   104.965     0.200
     9.898   137.566     0.200
    13.532   192.363     0.200
    17.632   239.766     0.200
     0.195     9.086     0.200
     0.319     9.285     0.200
     0.427    10.184     0.200
     0.824    15.586     0.200
     0.848    16.285     0.200
     1.043    17.184     0.200
     1.172    19.984     0.200
     1.373    22.484     0.200
     1.951    31.387     0.200
     2.684    40.785     0.200
     4.752    70.086     0.200
     6.842    97.484     0.200
     6.842    98.586     0.200
     6.842    98.285     0.200
     9.463   132.336     0.200
    15.101   207.184     0.200
    15.101   207.184     0.200
    19.601   265.785     0.200
     0.160     8.895     0.200
     0.311    10.297     0.200
     0.434    10.996     0.200
     0.659    13.598     0.200
     0.885    17.098     0.200
     0.913    16.098     0.200
     1.164    19.797     0.200
     1.247    21.895     0.200
     1.329    22.996     0.200
     1.457    23.895     0.200
     1.843    30.195     0.200
     2.741    41.598     0.200
     4.607    67.496     0.200
     4.663    69.496     0.200
     4.663    70.027     0.200
     6.822    98.297     0.200
     6.822    97.996     0.200
     6.822    98.496     0.200
     6.815    97.797     0.200
     8.576   123.496     0.200
    10.001   144.574     0.200
    10.459   150.496     0.200
    10.459   150.996     0.200
    10.971   155.496     0.200
    12.556   177.297     0.200
    12.705   179.496     0.200
    13.232   184.746     0.200
    14.881   206.297     0.200
    15.175   208.195     0.200
    15.175   208.195     0.200
    15.517   215.895     0.200
    17.596   240.297     0.200
    19.558   263.945     0.200
     0.203     8.867     0.200
     0.258    10.168     0.200
     0.439    10.867     0.200
     0.716    14.066     0.200
     0.883    17.066     0.200
     0.963    16.168     0.200
     1.178    19.867     0.200
     1.302    22.168     0.200
     1.382    23.266     0.200
     1.487    23.668     0.200
     1.527    24.766     0.200
     1.441    23.766     0.200
     1.631    26.469     0.200
     1.714    27.469     0.200
     1.770    28.367     0.200
     1.834    29.266     0.200
     1.823    28.668     0.200
     1.888    30.219     0.200
     2.074    32.867     0.200
     2.173    33.469     0.200
     2.195    33.766     0.200
     2.293    36.066     0.200
     2.279    35.867     0.200
     2.289    34.168     0.200
     2.603    39.668     0.200
     2.810    42.867     0.200
     2.735    41.367     0.200
     3.072    45.867     0.200
     3.381    50.766     0.200
     3.449    52.168     0.200
     3.573    52.469     0.200
     3.901    57.566     0.200
     4.005    57.766     0.200
     4.282    62.469     0.200
     4.444    65.469     0.200
     4.620    67.668     0.200
     4.602    68.367     0.200
     4.704    69.566     0.200
     4.764    70.266     0.200
     5.161    74.566     0.200
     5.264    76.766     0.200
     5.765    84.566     0.200
     5.875    84.969     0.200
     6.208    89.668     0.200
     6.444    91.668     0.200
     6.813    97.266     0.200
     6.813    97.969     0.200
     6.813    97.367     0.200
     6.813    97.867     0.200
     6.858    99.367     0.200
     7.626   105.867     0.200
     7.696   107.469     0.200
     8.246   116.867     0.200
     8.301   118.566     0.200
     8.616   122.867     0.200
     9.309   132.766     0.200
     9.472   131.668     0.200
     9.652   139.668     0.200
    10.053   144.676     0.200
    10.516   146.867     0.200
    10.516   147.367     0.200
    11.016   154.867     0.200
    11.899   166.469     0.200
    12.336   170.367     0.200
    12.584   175.676     0.200
    12.759   179.668     0.200
    13.239   184.566     0.200
    13.168   181.266     0.200
    13.458   185.738     0.200
    13.800   193.266     0.200
    14.125   195.668     0.200
    14.937   207.168     0.200
    15.032   210.168     0.200
    15.032   209.867     0.200
    15.138   209.016     0.200
    15.138   209.016     0.200
    15.573   216.469     0.200
    16.148   223.367     0.200
    17.652   239.469     0.200
    17.652   240.766     0.200
    17.995   245.668     0.200
    19.557   263.617     0.200
    20.696   276.969     0.200
     0.245    10.491     0.200
     0.318    10.491     0.200
     0.436    12.691     0.200
     0.583    13.491     0.200
     0.769    15.991     0.200
     0.786    14.691     0.200
     1.026    18.491     0.200
     1.216    21.491     0.200
     1.211    21.491     0.200
     1.366    22.991     0.200
     1.456    23.891     0.200
     1.447    24.491     0.200
     1.566    25.991     0.200
     1.590    26.491     0.200
     1.607    27.291     0.200
     1.669    27.491     0.200
     1.704    28.241     0.200
     1.982    31.591     0.200
     2.071    32.591     0.200
     2.155    34.591     0.200
     2.539    39.591     0.200
     2.628    40.391     0.200
     3.233    47.891     0.200
     4.492    66.991     0.200
     4.519    66.691     0.200
     4.901    71.891     0.200
     5.316    74.491     0.200
     5.700    82.591     0.200
     6.022    86.391     0.200
     6.502    94.391     0.200
     6.674    96.491     0.200
     6.957    98.891     0.200
     6.957    99.191     0.200
     6.957    99.491     0.200
     7.118   101.891     0.200
     8.432   121.291     0.200
     9.481   135.491     0.200
     9.644   134.291     0.200
     9.984   143.291     0.200
     9.984   139.911     0.200
    10.376   146.491     0.200
    10.832   151.491     0.200
    11.120   160.591     0.200
    11.120   159.891     0.200
    12.099   169.791     0.200
    12.210   168.891     0.200
    12.581   176.391     0.200
    12.628   176.031     0.200
    12.592   175.491     0.200
    13.346   184.941     0.200
    14.157   196.791     0.200
    14.237   196.891     0.200
    14.355   199.191     0.200
    14.432   200.891     0.200
    14.802   203.791     0.200
    14.822   205.191     0.200
    14.783   204.991     0.200
    15.201   209.391     0.200
    15.321   210.991     0.200
    15.321   210.991     0.200
    15.407   213.091     0.200
    15.410   211.991     0.200
    15.991   220.891     0.200
    17.545   235.891     0.200
     0.190     8.980     0.200
     0.283    10.180     0.200
     0.427    10.680     0.200
     0.692    14.078     0.200
     0.874    16.777     0.200
     0.937    16.180     0.200
     1.163    19.777     0.200
     1.282    22.277     0.200
     1.356    23.180     0.200
     1.438    23.578     0.200
     1.863    30.230     0.200
     2.729    42.379     0.200
     4.680    69.008     0.200
     6.826    97.969     0.200
     6.826    98.180     0.200
     6.826    97.879     0.200
     0.465    10.430     0.200
     0.440     9.836     0.200
     0.808    15.531     0.200
     0.954    16.734     0.200
     1.139    18.234     0.200
     1.161    19.836     0.200
     1.283    21.133     0.200
     2.609    40.031     0.200
     4.473    68.836     0.200
     4.798    70.734     0.200
     4.798    71.289     0.200
     6.897    99.836     0.200
     6.897   100.133     0.200
     8.705   125.133     0.200
    13.219   185.430     0.200
    17.908   243.594     0.200
     0.267     9.277     0.200
     0.344     9.676     0.200
     0.314    10.176     0.200
     0.710    14.477     0.200
     0.788    15.777     0.200
     0.917    15.875     0.200
     1.085    18.875     0.200
     1.327    23.078     0.200
     1.344    23.277     0.200
     1.350    22.277     0.200
     1.827    29.727     0.200
     2.640    40.578     0.200
     4.507    67.078     0.200
     4.507    67.477     0.200
     4.633    68.977     0.200
     6.791    98.977     0.200
     6.909    99.156     0.200
     6.909    98.777     0.200
     6.909    98.977     0.200
     8.544   122.875     0.200
     9.560   133.578     0.200
    10.089   144.578     0.200
    10.089   145.176     0.200
    10.951   153.977     0.200
    11.231   159.977     0.200
    11.231   160.777     0.200
    12.665   176.277     0.200
    13.000   181.977     0.200
    13.333   185.227     0.200
    15.540   216.375     0.200
    17.667   239.578     0.200
    19.653   264.777     0.200
     0.272     9.258     0.200
     0.278     9.664     0.200
     0.368     9.758     0.200
     0.740    14.758     0.200
     0.807    15.859     0.200
     0.953    16.164     0.200
     1.112    19.164     0.200
     1.349    23.562     0.200
     1.379    23.758     0.200
     1.359    22.164     0.200
     1.552    24.961     0.200
     1.603    26.359     0.200
     1.605    26.258     0.200
     1.722    28.062     0.200
     1.746    27.461     0.200
     1.795    28.859     0.200
     1.862    30.211     0.200
     1.862    30.062     0.200
     2.153    33.664     0.200
     2.375    37.258     0.200
     2.656    40.461     0.200
     2.673    40.258     0.200
     2.891    43.859     0.200
     4.523    67.258     0.200
     4.668    69.461     0.200
     4.668    69.359     0.200
     5.336    78.164     0.200
     5.464    80.461     0.200
     5.649    81.859     0.200
     5.839    85.758     0.200
     6.503    94.859     0.200
     6.826    99.461     0.200
     6.886    98.930     0.200
     6.886    98.758     0.200
     6.886    98.461     0.200
     8.310   118.461     0.200
     9.530   131.812     0.200
    10.108   145.258     0.200
    10.108   143.133     0.200
    10.539   149.664     0.200
    10.986   152.461     0.200
    12.259   170.461     0.200
    12.664   176.219     0.200
    13.017   182.062     0.200
    13.319   186.109     0.200
    13.537   187.453     0.200
    14.957   208.258     0.200
    15.180   209.859     0.200
    15.181   209.859     0.200
    15.573   215.758     0.200
    17.693   240.242     0.200
    20.777   280.062     0.200
     0.549    10.963     0.200
     0.642    12.562     0.200
     0.944    16.361     0.200
     1.000    18.463     0.200
     1.888    31.213     0.200
     2.858    44.062     0.200
     4.719    71.271     0.200
     4.724    74.162     0.200
     6.716    99.732     0.200
     6.716    98.562     0.200
     6.716    99.662     0.200
     0.271     9.492     0.200
     0.298     9.292     0.200
     0.392    10.892     0.200
     0.646    13.691     0.200
     0.749    15.191     0.200
     0.838    14.792     0.200
     1.027    18.092     0.200
     1.266    22.191     0.200
     1.278    22.392     0.200
     1.332    21.892     0.200
     1.747    28.742     0.200
     2.607    39.592     0.200
     4.473    65.592     0.200
     4.555    67.191     0.200
     4.555    67.792     0.200
     5.379    77.592     0.200
     6.712    97.092     0.200
     6.959    99.901     0.200
     6.959    98.691     0.200
     8.467   120.792     0.200
    10.045   142.392     0.200
    10.438   149.792     0.200
    10.872   152.592     0.200
    12.199   170.892     0.200
    12.963   181.392     0.200
    15.466   215.191     0.200
    17.840   244.292     0.200
    17.840   243.502     0.200
     0.126     8.695     0.200
     0.274     9.891     0.200
     0.554    12.094     0.200
     0.697    13.992     0.200
     1.003    18.594     0.200
     0.992    17.195     0.200
     1.237    21.695     0.200
     1.284    21.391     0.200
     1.390    22.789     0.200
     1.407    23.594     0.200
     1.396    23.391     0.200
     1.933    31.641     0.200
     2.858    43.094     0.200
     4.761    71.391     0.200
     6.701   100.125     0.200
     6.701    97.789     0.200
     9.383   130.945     0.200
     9.968   143.641     0.200
    12.863   180.695     0.200
    17.590   240.312     0.200
     0.256     9.481     0.200
     0.367     9.881     0.200
     0.292    10.381     0.200
     0.719    14.581     0.200
     0.810    15.981     0.200
     0.935    15.881     0.200
     1.109    19.081     0.200
     1.329    23.081     0.200
     1.360    23.381     0.200
     1.368    22.581     0.200
     1.533    24.781     0.200
     1.588    25.981     0.200
     1.591    26.182     0.200
     1.713    27.781     0.200
     1.754    29.281     0.200
     1.768    28.682     0.200
     1.749    27.682     0.200
     1.848    29.085     0.200
     1.848    29.781     0.200
     1.786    28.781     0.200
     2.034    32.381     0.200
     2.144    33.781     0.200
     2.194    34.281     0.200
     2.149    33.881     0.200
     2.206    34.781     0.200
     2.282    36.682     0.200
     2.282    35.781     0.200
     2.217    32.981     0.200
     2.366    37.182     0.200
     2.446    37.981     0.200
     2.679    41.182     0.200
     2.661    40.781     0.200
     2.700    41.281     0.200
     2.674    40.682     0.200
     2.812    42.881     0.200
     2.884    43.981     0.200
     3.142    46.881     0.200
     3.454    51.682     0.200
     3.523    53.081     0.200
     3.973    58.581     0.200
     4.071    58.581     0.200
     4.528    66.781     0.200
     4.655    69.081     0.200
     4.655    68.131     0.200
     4.838    70.981     0.200
     5.443    78.281     0.200
     5.646    82.182     0.200
     6.498    94.381     0.200
     6.514    92.481     0.200
     6.813    97.881     0.200
     6.813    98.281     0.200
     6.886    97.991     0.200
     6.886    98.481     0.200
     6.886    98.281     0.200
     7.046   101.081     0.200
     8.291   117.281     0.200
     8.567   122.281     0.200
     9.536   131.231     0.200
    10.088   143.981     0.200
    10.088   143.501     0.200
    10.518   149.281     0.200
    10.972   153.281     0.200
    12.392   174.481     0.200
    12.937   180.781     0.200
    12.998   180.581     0.200
    13.313   185.131     0.200
    13.313   185.381     0.200
    14.199   196.781     0.200
    14.510   201.881     0.200
    14.898   206.781     0.200
    15.191   206.531     0.200
    15.191   206.531     0.200
    16.647   228.581     0.200
    17.672   239.182     0.200
    18.642   252.682     0.200
     0.271     9.391     0.200
     0.281    10.094     0.200
     0.282     9.891     0.200
     0.282    10.820     0.200
     0.366     9.891     0.200
     0.737    14.594     0.200
     0.806    15.992     0.200
     0.949    15.992     0.200
     1.110    19.094     0.200
     1.347    23.297     0.200
     1.375    23.594     0.200
     1.359    22.391     0.200
     1.550    24.992     0.200
     1.599    26.195     0.200
     1.605    26.391     0.200
     1.719    27.891     0.200
     1.745    27.492     0.200
     1.771    28.695     0.200
     1.796    28.891     0.200
     1.859    29.742     0.200
     1.859    29.891     0.200
     2.154    33.891     0.200
     2.268    34.891     0.200
     2.655    39.992     0.200
     2.675    40.594     0.200
     2.892    43.992     0.200
     3.141    46.695     0.200
     3.639    53.195     0.200
     4.068    58.492     0.200
     4.351    63.297     0.200
     4.519    66.492     0.200
     4.665    68.992     0.200
     4.665    69.336     0.200
     4.841    70.891     0.200
     5.461    80.594     0.200
     5.650    82.094     0.200
     6.504    94.391     0.200
     6.513    92.492     0.200
     6.888    98.633     0.200
     6.888    98.695     0.200
     6.888    98.594     0.200
     7.048   101.094     0.200
     8.256   118.094     0.200
     9.122   130.195     0.200
     9.533   131.992     0.200
    10.106   143.992     0.200
    10.106   141.070     0.200
    10.535   147.094     0.200
    12.258   173.492     0.200
    12.664   177.297     0.200
    13.015   182.094     0.200
    13.536   188.266     0.200
    14.526   202.094     0.200
    15.183   209.297     0.200
    15.184   209.297     0.200
    16.662   228.891     0.200
    17.690   240.344     0.200
    18.658   252.992     0.200
    20.777   280.594     0.200
     0.221     8.992     0.200
     0.284     9.992     0.200
     0.399    10.188     0.200
     0.706    14.391     0.200
     0.845    16.289     0.200
     0.937    16.094     0.200
     1.139    19.289     0.200
     1.305    22.789     0.200
     1.359    23.492     0.200
     1.406    22.789     0.200
     1.555    25.594     0.200
     1.749    29.391     0.200
     1.749    28.289     0.200
     1.795    28.891     0.200
     1.857    30.094     0.200
     2.113    33.391     0.200
     2.252    35.391     0.200
     2.284    36.688     0.200
     2.235    34.289     0.200
     2.643    40.188     0.200
     2.697    40.594     0.200
     3.941    57.992     0.200
     4.670    68.594     0.200
     4.670    68.891     0.200
     4.670    69.703     0.200
     5.424    75.891     0.200
     6.484    91.992     0.200
     6.659    96.188     0.200
     6.853    98.047     0.200
     6.853    97.891     0.200
     6.853    97.992     0.200
     7.014   100.391     0.200
     7.666   106.391     0.200
     8.014   114.289     0.200
     8.016   114.094     0.200
     8.260   118.891     0.200
     9.511   132.039     0.200
     9.630   137.891     0.200
    10.061   143.891     0.200
    10.061   144.164     0.200
    10.506   145.891     0.200
    10.984   151.891     0.200
    12.828   178.492     0.200
    12.900   180.492     0.200
    12.968   181.391     0.200
    13.276   184.594     0.200
    13.486   188.031     0.200
    13.590   188.992     0.200
    13.837   193.391     0.200
    14.181   197.188     0.200
    14.477   201.391     0.200
    14.740   203.594     0.200
    14.922   207.094     0.200
    15.116   208.492     0.200
    15.546   213.391     0.200
    16.612   227.391     0.200
    17.651   239.594     0.200
    20.729   277.391     0.200
    20.729   277.289     0.200
     0.268     9.414     0.200
     0.304    10.312     0.200
     0.350     9.812     0.200
     0.718    14.512     0.200
     0.793    15.914     0.200
     0.927    15.812     0.200
     1.092    19.012     0.200
     1.333    23.211     0.200
     1.353    23.312     0.200
     1.353    22.414     0.200
     2.645    41.211     0.200
     4.512    66.312     0.200
     4.642    69.312     0.200
     4.642    69.031     0.200
     6.902    97.711     0.200
     6.902    99.312     0.200
     6.902    99.512     0.200
    12.734   179.414     0.200
     0.156     9.017     0.200
     0.339    10.717     0.200
     0.421    10.917     0.200
     0.633    13.717     0.200
     0.884    16.017     0.200
     0.872    17.017     0.200
     1.145    19.717     0.200
     1.228    22.017     0.200
     1.300    22.816     0.200
     1.451    23.816     0.200
     1.815    29.917     0.200
     2.730    41.517     0.200
     4.596    67.017     0.200
     5.347    76.017     0.200
     6.788    96.517     0.200
     6.839    99.017     0.200
     6.839    98.816     0.200
     9.571   139.017     0.200
     9.521   132.148     0.200
     9.984   139.896     0.200
    10.434   147.017     0.200
    12.556   176.227     0.200
    12.677   176.816     0.200
    12.892   180.116     0.200
    15.478   212.316     0.200
    15.490   212.816     0.200
    16.065   219.616     0.200
    17.575   239.717     0.200
     0.263     9.941     0.200
     0.264    10.340     0.200
     0.219     8.941     0.200
     0.419    10.543     0.200
     0.719    14.340     0.200
     0.862    16.641     0.200
     0.957    16.242     0.200
     1.159    19.742     0.200
     1.312    22.742     0.200
     1.378    23.742     0.200
     1.878    30.340     0.200
     4.692    70.941     0.200
     4.692    70.012     0.200
     6.833    98.941     0.200
     0.266    10.047     0.200
     0.298    10.547     0.200
     0.469    12.445     0.200
     0.470    12.648     0.200
     0.590    13.344     0.200
     0.716    15.344     0.200
     0.763    14.445     0.200
     0.973    17.844     0.200
     1.193    21.344     0.200
     1.237    21.750     0.200
     1.317    22.047     0.200
     1.411    24.047     0.200
     1.671    27.797     0.200
     2.574    38.547     0.200
     4.480    66.844     0.200
     4.480    66.430     0.200
     7.011    98.945     0.200
     7.011   100.047     0.200
     7.011    99.547     0.200
     9.694   133.898     0.200
    10.006   144.648     0.200
    10.006   140.477     0.200
    10.373   147.844     0.200
    12.930   182.445     0.200
    17.555   237.750     0.200
    17.771   243.445     0.200
     0.210     9.219     0.200
     0.318    10.516     0.200
     0.383    10.422     0.200
     0.672    14.219     0.200
     0.832    16.320     0.200
     0.902    16.016     0.200
     1.118    19.422     0.200
     1.278    22.219     0.200
     1.324    23.219     0.200
     1.403    23.117     0.200
     1.823    29.867     0.200
     2.688    40.422     0.200
     4.554    66.219     0.200
     4.637    69.219     0.200
     4.637    69.477     0.200
     4.637    69.820     0.200
     5.394    77.219     0.200
     6.792    99.219     0.200
     6.871    98.625     0.200
     6.871    98.117     0.200
     6.871    98.219     0.200
     6.871    98.359     0.200
     9.537   134.117     0.200
    10.037   143.516     0.200
    10.472   148.117     0.200
    12.946   181.719     0.200
    13.285   184.516     0.200
    14.460   200.516     0.200
    15.511   214.219     0.200
    17.622   239.547     0.200
     0.301    10.609     0.200
     0.283     9.711     0.200
     0.343     9.910     0.200
     0.783    16.012     0.200
     0.731    14.711     0.200
     0.935    16.012     0.200
     1.087    19.109     0.200
     1.340    22.512     0.200
     1.348    23.309     0.200
     1.362    23.410     0.200
     1.841    30.160     0.200
     2.634    40.711     0.200
     4.501    66.410     0.200
     4.645    70.109     0.200
     4.645    69.371     0.200
     6.803    99.410     0.200
     6.910    97.711     0.200
     6.910    98.711     0.200
     6.910    99.031     0.200
     8.315   119.609     0.200
     8.377   119.809     0.200
     8.556   123.910     0.200
     9.556   131.746     0.200
    10.528   148.410     0.200
    13.021   182.410     0.200
    15.560   214.609     0.200
     0.303    10.258     0.200
     0.304    11.289     0.200
     0.423    10.859     0.200
     0.671    13.656     0.200
     0.872    16.953     0.200
     0.918    16.656     0.200
     1.156    19.859     0.200
     1.263    21.758     0.200
     1.336    22.859     0.200
     1.441    23.758     0.200
     1.846    30.008     0.200
     2.728    42.156     0.200
     4.664    70.359     0.200
     4.664    69.508     0.200
     6.817    99.656     0.200
     6.832    97.695     0.200
     6.832    97.453     0.200
     6.832    97.156     0.200
     6.832    98.219     0.200
     8.216   117.953     0.200
     8.329   120.156     0.200
     8.576   123.156     0.200
    10.018   142.953     0.200
    12.573   175.938     0.200
    12.924   180.953     0.200
    13.245   184.508     0.200
    15.175   209.953     0.200
    15.176   209.953     0.200
    17.611   240.547     0.200
     0.200     8.965     0.200
     0.281    10.168     0.200
     0.282    10.078     0.200
     0.419    10.766     0.200
     0.698    14.168     0.200
     0.866    16.867     0.200
     0.939    16.168     0.200
     1.157    19.867     0.200
     1.290    22.266     0.200
     1.359    23.266     0.200
     1.863    30.266     0.200
     2.720    42.566     0.200
     4.586    66.066     0.200
     4.679    69.367     0.200
     6.833    97.965     0.200
     6.833    98.102     0.200
     9.496   134.367     0.200
     0.224     8.953     0.200
     0.281     9.953     0.200
     0.281    10.055     0.200
     0.400    10.352     0.200
     0.709    14.352     0.200
     0.844    16.453     0.200
     0.940    16.250     0.200
     1.139    19.555     0.200
     1.308    22.750     0.200
     1.362    23.750     0.200
     1.404    23.055     0.200
     1.860    29.453     0.200
     2.697    41.656     0.200
     4.672    69.453     0.200
     6.853    98.953     0.200
     6.853    98.242     0.200
    10.064   142.172     0.200
     0.257     9.344     0.200
     0.330    10.445     0.200
     0.386    11.047     0.200
     0.387    11.344     0.200
     0.703    14.945     0.200
     0.869    15.145     0.200
     0.998    17.945     0.200
     1.275    21.344     0.200
     1.301    22.645     0.200
     1.340    23.246     0.200
     1.763    29.094     0.200
     2.558    40.844     0.200
     4.560    67.746     0.200
     4.560    67.414     0.200
     6.995    98.746     0.200
     6.995    99.246     0.200
     6.995    99.082     0.200
     9.645   132.594     0.200
    10.486   149.145     0.200
    13.415   186.297     0.200
    15.292   209.445     0.200
    15.292   209.445     0.200
    17.665   240.547     0.200
     0.258     9.289     0.200
     0.366     9.988     0.200
     0.292     9.887     0.200
     0.293     9.918     0.200
     0.721    14.688     0.200
     0.808    15.988     0.200
     0.936    16.188     0.200
     1.108    19.289     0.200
     1.331    23.387     0.200
     1.361    23.789     0.200
     1.366    22.387     0.200
     1.848    30.188     0.200
     2.660    40.988     0.200
     4.655    69.590     0.200
     4.655    68.879     0.200
     6.887    98.789     0.200
     6.887    98.555     0.200
     8.293   119.387     0.200
     8.293   118.488     0.200
     9.537   132.488     0.200
    10.090   142.910     0.200
    10.519   146.688     0.200
    12.261   170.988     0.200
    13.000   182.188     0.200
    13.314   185.137     0.200
    14.512   201.988     0.200
    14.957   208.887     0.200
    15.191   208.887     0.200
    15.192   208.887     0.200
    16.649   228.887     0.200
    17.673   239.289     0.200
     0.312     9.910     0.200
     0.285     9.312     0.200
     0.531    11.512     0.200
     0.582    12.609     0.200
     0.682    14.609     0.200
     0.683    14.121     0.200
     0.917    17.109     0.200
     0.934    17.211     0.200
     0.972    18.012     0.200
     1.092    18.910     0.200
     1.193    20.211     0.200
     1.292    22.711     0.200
     1.341    23.910     0.200
     1.384    22.812     0.200
     1.534    26.211     0.200
     2.761    43.012     0.200
     4.372    66.211     0.200
     6.936   100.109     0.200
     6.936    99.484     0.200
    12.422   175.410     0.200
     0.177     8.965     0.200
     0.281    10.164     0.200
     0.282    10.164     0.200
     0.441    10.965     0.200
     0.689    14.164     0.200
     0.889    17.164     0.200
     0.941    16.363     0.200
     1.176    20.062     0.200
     1.274    22.262     0.200
     1.358    23.664     0.200
     1.869    30.465     0.200
     2.743    41.863     0.200
     4.688    70.164     0.200
     4.688    68.863     0.200
     6.812    98.262     0.200
     6.812    97.562     0.200
     6.812    98.164     0.200
     0.188     8.852     0.200
     0.189     8.898     0.200
     0.312     9.055     0.200
     0.437    10.156     0.200
     0.822    15.258     0.200
     0.859    16.258     0.200
     1.046    16.953     0.200
     1.181    19.758     0.200
     1.384    22.453     0.200
     1.956    31.555     0.200
     2.695    40.953     0.200
     4.562    66.055     0.200
     4.758    71.172     0.200
     4.758    70.758     0.200
     6.831    97.766     0.200
     6.831    97.852     0.200
     6.831    97.930     0.200
     8.477   121.656     0.200
     9.454   131.352     0.200
    10.164   142.555     0.200
    10.623   149.156     0.200
    12.666   177.805     0.200
    13.066   183.555     0.200
    13.286   184.805     0.200
    15.093   206.953     0.200
    15.093   206.953     0.200
    16.686   229.555     0.200
     0.343     9.785     0.200
     0.561    12.484     0.200
     0.508    11.383     0.200
     0.509    12.184     0.200
     0.509    11.453     0.200
     0.682    13.484     0.200
     0.944    16.984     0.200
     1.051    17.684     0.200
     0.994    17.285     0.200
     1.130    18.383     0.200
     1.452    23.285     0.200
     1.563    25.984     0.200
     1.624    26.785     0.200
     1.926    31.082     0.200
     2.184    34.484     0.200
     2.322    35.984     0.200
     2.501    38.785     0.200
     2.558    38.684     0.200
     2.953    44.484     0.200
     4.279    61.285     0.200
     4.644    67.523     0.200
     4.644    67.684     0.200
     5.151    75.184     0.200
     5.626    81.383     0.200
     5.977    86.383     0.200
     6.107    87.383     0.200
     6.140    89.383     0.200
     6.230    89.582     0.200
     6.744    97.484     0.200
     6.761    95.883     0.200
     6.855    99.184     0.200
     7.177   102.355     0.200
     7.177   102.484     0.200
     7.177   102.684     0.200
     7.338   104.883     0.200
     7.589   108.984     0.200
     7.856   112.684     0.200
     7.931   109.883     0.200
     8.323   117.883     0.200
     8.342   118.383     0.200
     8.607   121.582     0.200
     8.497   117.684     0.200
     8.565   122.383     0.200
     8.700   123.883     0.200
     8.664   123.582     0.200
     9.068   129.684     0.200
     9.249   129.883     0.200
     9.509   134.184     0.200
     9.643   135.383     0.200
     9.718   134.082     0.200
     9.966   139.082     0.200
    10.476   149.984     0.200
    10.785   149.684     0.200
    11.213   160.684     0.200
    12.765   179.184     0.200
    12.906   180.184     0.200
    13.070   182.984     0.200
    13.399   187.184     0.200
    13.674   189.734     0.200
    13.944   192.363     0.200
    14.927   207.184     0.200
    15.114   208.285     0.200
    15.273   211.285     0.200
    15.272   208.832     0.200
    15.272   208.832     0.200
    17.072   233.684     0.200
    17.794   240.312     0.200
    17.794   240.883     0.200
     0.128     8.795     0.200
     0.273    10.074     0.200
     0.273     9.994     0.200
     0.554    12.195     0.200
     0.699    14.094     0.200
     0.993    17.295     0.200
     1.003    18.594     0.200
     1.238    21.695     0.200
     1.285    21.494     0.200
     1.397    24.295     0.200
     1.391    22.795     0.200
     1.407    23.695     0.200
     1.935    31.744     0.200
     2.858    43.395     0.200
     4.724    72.395     0.200
     4.762    69.395     0.200
     6.701    98.795     0.200
     6.701    97.795     0.200
     6.701    98.033     0.200
    10.485   146.094     0.200
    12.462   175.594     0.200
    14.766   202.898     0.200
    17.592   240.395     0.200
     0.235     9.246     0.200
     0.378    10.145     0.200
     0.296    10.246     0.200
     0.297    10.406     0.200
     0.703    14.246     0.200
     0.824    16.246     0.200
     0.927    15.945     0.200
     1.118    19.246     0.200
     1.309    22.746     0.200
     1.350    23.246     0.200
     1.386    22.848     0.200
     1.843    29.047     0.200
     2.677    41.746     0.200
     4.654    69.047     0.200
     6.874    98.566     0.200
     6.874    98.645     0.200
     6.874    98.645     0.200
     9.531   132.695     0.200
    12.631   177.047     0.200
    14.590   200.820     0.200
    17.654   241.715     0.200
     0.227     9.125     0.200
     0.290    10.023     0.200
     0.289    10.023     0.200
     0.390    10.422     0.200
     0.705    14.328     0.200
     0.835    16.523     0.200
     0.933    16.227     0.200
     1.129    19.625     0.200
     1.307    22.727     0.200
     1.355    23.523     0.200
     1.397    23.125     0.200
     1.851    30.227     0.200
     2.688    41.125     0.200
     4.663    69.445     0.200
     4.663    69.625     0.200
     6.819    99.125     0.200
     6.862    98.062     0.200
     6.862    98.023     0.200
     6.862    98.227     0.200
     9.520   132.672     0.200
    10.064   142.227     0.200
    10.064   143.188     0.200
    12.288   169.828     0.200
    12.622   177.227     0.200
    12.972   181.523     0.200
    13.494   187.438     0.200
    14.482   201.727     0.200
    14.602   202.594     0.200
    15.181   210.922     0.200
    15.181   210.922     0.200
    17.652   240.438     0.200
     0.273    10.281     0.200
     0.274    10.184     0.200
     0.307     9.684     0.200
     0.356     9.781     0.200
     0.769    14.984     0.200
     0.787    15.781     0.200
     0.971    16.383     0.200
     1.101    18.984     0.200
     1.332    22.184     0.200
     1.383    23.582     0.200
     1.399    23.984     0.200
     1.873    30.781     0.200
     2.633    40.383     0.200
     4.500    66.883     0.200
     4.673    68.281     0.200
     6.903    98.781     0.200
     6.903    98.184     0.200
     6.903    99.184     0.200
     9.537   130.707     0.200
    12.696   178.281     0.200
     0.182     8.972     0.200
     0.291    10.272     0.200
     0.291    10.472     0.200
     0.428    10.872     0.200
     0.683    14.072     0.200
     0.876    16.972     0.200
     0.931    16.072     0.200
     1.163    19.872     0.200
     1.273    22.272     0.200
     1.349    23.272     0.200
     1.443    23.672     0.200
     1.858    30.172     0.200
     2.731    42.972     0.200
     4.598    68.672     0.200
     4.675    69.972     0.200
     4.675    69.842     0.200
     6.825    98.872     0.200
     6.825    97.972     0.200
    10.483   147.072     0.200
    12.575   177.072     0.200
     0.139     8.711     0.200
     0.461    11.508     0.200
     0.478    12.414     0.200
     0.479    11.414     0.200
     0.572    13.312     0.200
     0.762    14.609     0.200
     0.865    15.609     0.200
     0.883    16.711     0.200
     1.142    19.609     0.200
     1.299    22.609     0.200
     1.717    28.312     0.200
     2.425    37.914     0.200
     4.491    66.211     0.200
     4.491    66.359     0.200
     7.122   101.414     0.200
     7.122   101.312     0.200
     7.122   101.234     0.200
     0.190     8.641     0.200
     0.276     9.742     0.200
     0.277     9.742     0.200
     0.433    10.641     0.200
     0.697    14.043     0.200
     0.880    16.844     0.200
     0.945    16.543     0.200
     1.170    19.844     0.200
     1.285    22.242     0.200
     1.871    30.344     0.200
     1.871    30.133     0.200
     4.688    72.242     0.200
     4.688    69.293     0.200
     6.819    98.879     0.200
     9.483   132.918     0.200
     0.189     8.469     0.200
     0.451    11.270     0.200
     0.569    12.270     0.200
     0.640    12.770     0.200
     0.813    15.172     0.200
     0.929    15.969     0.200
     0.971    17.070     0.200
     0.976    16.469     0.200
     1.377    22.172     0.200
     1.407    23.672     0.200
     1.765    28.820     0.200
     2.275    35.672     0.200
     4.141    63.070     0.200
     4.493    64.980     0.200
     7.245   104.172     0.200
     7.245   105.969     0.200
     7.245   104.758     0.200
    11.886   166.871     0.200
    13.040   184.121     0.200
    14.215   195.051     0.200
    14.215   195.672     0.200
     0.345     9.758     0.200
     0.266     9.461     0.200
     0.313    10.359     0.200
     0.314    10.258     0.200
     0.710    14.461     0.200
     0.789    15.859     0.200
     0.918    15.859     0.200
     1.086    18.859     0.200
     1.344    23.258     0.200
     1.326    23.062     0.200
     1.351    22.359     0.200
     1.828    29.758     0.200
     1.828    29.234     0.200
     2.642    41.062     0.200
     4.509    68.359     0.200
     4.634    68.938     0.200
     4.634    69.164     0.200
     6.907    98.664     0.200
     6.907    98.859     0.200
     6.907    99.445     0.200
    10.088   142.461     0.200
    10.088   143.188     0.200
    10.507   147.562     0.200
    12.664   178.062     0.200
    13.000   181.758     0.200
    14.556   199.320     0.200
     0.360     9.805     0.200
     0.509    11.602     0.200
     0.508    11.305     0.200
     0.572    12.500     0.200
     0.691    13.500     0.200
     0.956    17.203     0.200
     0.994    17.500     0.200
     1.066    17.805     0.200
     1.147    18.203     0.200
     1.457    23.500     0.200
     1.942    31.250     0.200
     2.325    36.203     0.200
     4.658    67.602     0.200
     7.174   102.500     0.200
     7.174   102.703     0.200
     7.174   103.367     0.200
     8.732   126.055     0.200
    13.077   183.305     0.200
    13.077   183.305     0.200
    14.288   198.305     0.200
     0.267     9.446     0.200
     0.351     9.746     0.200
     0.305    10.246     0.200
     0.304    10.346     0.200
     0.718    14.446     0.200
     0.793    15.846     0.200
     0.926    15.846     0.200
     1.093    18.946     0.200
     1.332    23.146     0.200
     1.353    23.446     0.200
     1.353    22.346     0.200
     1.836    29.896     0.200
     2.645    41.346     0.200
     4.512    68.146     0.200
     4.642    69.846     0.200
     6.902    99.246     0.200
     6.902    98.946     0.200
     6.902    99.546     0.200
     8.332   120.121     0.200
    10.515   147.546     0.200
    12.664   178.096     0.200
    12.664   178.096     0.200
    14.562   202.594     0.200
     0.160     8.879     0.200
     0.320    10.379     0.200
     0.320    10.180     0.200
     0.320    10.660     0.200
     0.428    10.879     0.200
     0.652    13.779     0.200
     0.903    16.379     0.200
     0.879    17.080     0.200
     1.157    19.980     0.200
     1.242    21.879     0.200
     1.320    22.980     0.200
     1.453    23.779     0.200
     1.833    30.061     0.200
     2.736    41.279     0.200
     4.602    68.680     0.200
     4.654    69.680     0.200
     4.654    69.820     0.200
     6.829    98.180     0.200
     6.829    97.680     0.200
     6.829    98.629     0.200
     8.235   118.105     0.200
     9.507   132.480     0.200
    10.452   146.480     0.200
    12.558   176.980     0.200
    12.558   176.980     0.200
    13.237   184.529     0.200
    14.414   201.379     0.200
    14.638   202.379     0.200
    15.184   208.660     0.200
    15.184   208.654     0.200
     0.221     9.164     0.200
     0.255    10.164     0.200
     0.425    10.664     0.200
     0.726    14.465     0.200
     0.868    16.863     0.200
     0.966    16.465     0.200
     1.166    19.762     0.200
     1.318    22.863     0.200
     1.386    23.863     0.200
     1.422    23.363     0.200
     1.887    30.688     0.200
     2.718    42.164     0.200
     6.827    98.324     0.200
    12.604   177.762     0.200
     0.202     8.836     0.200
     0.198     9.137     0.200
     0.554    11.938     0.200
     0.768    14.938     0.200
     0.995    18.539     0.200
     1.050    17.738     0.200
     1.295    21.539     0.200
     1.313    22.738     0.200
     1.460    24.539     0.200
     1.985    31.637     0.200
     1.985    32.359     0.200
     2.842    43.539     0.200
     4.709    69.738     0.200
     4.808    72.336     0.200
     6.699    96.438     0.200
     6.699    96.539     0.200
     8.217   117.637     0.200
     8.276   116.887     0.200
     8.426   115.938     0.200
    10.040   141.539     0.200
    10.040   144.379     0.200
    12.507   175.039     0.200
    12.507   175.039     0.200
    12.933   181.336     0.200
    13.134   183.699     0.200
    13.134   183.012     0.200
    13.381   189.438     0.200
    14.765   203.438     0.200
    17.666   239.836     0.200
     0.091     7.307     0.200
     0.365    10.106     0.200
     0.649    12.707     0.200
     0.657    12.807     0.200
     0.795    14.207     0.200
     0.780    14.007     0.200
     0.978    16.906     0.200
     1.206    21.106     0.200
     1.287    22.007     0.200
     1.320    22.207     0.200
     1.299    21.406     0.200
     1.328    22.707     0.200
     1.554    25.807     0.200
     2.224    35.406     0.200
     4.088    62.406     0.200
     0.453    10.508     0.200
     0.462    10.809     0.200
     0.715    14.406     0.200
     0.819    15.707     0.200
     0.819    15.508     0.200
     0.831    15.008     0.200
     0.882    15.906     0.200
     0.938    16.508     0.200
     0.947    17.105     0.200
     1.161    20.605     0.200
     1.265    21.309     0.200
     1.340    22.605     0.200
     1.364    22.707     0.200
     1.432    24.605     0.200
     1.526    24.508     0.200
     1.802    29.309     0.200
     3.198    48.309     0.200
     4.629    68.605     0.200
     5.047    76.207     0.200
     6.547    96.105     0.200
    11.997   170.809     0.200
    14.979   208.008     0.200
     0.638    13.836     0.200
     1.014    19.536     0.200
     1.138    20.936     0.200
     4.591    70.836     0.200
     5.304    83.336     0.200
     6.452    98.836     0.200
     6.452    97.136     0.200
     6.452    98.536     0.200
     7.256   105.718     0.200
     9.021   133.256     0.200
     9.681   142.036     0.200
    11.672   170.836     0.200
    11.648   170.256     0.200
    11.915   171.036     0.200
    12.581   178.836     0.200
    12.592   179.566     0.200
    12.592   178.261     0.200
    15.149   209.006     0.200
    15.149   213.136     0.200
    16.683   233.236     0.200
     0.251     9.086     0.200
     0.328     9.883     0.200
     0.447    11.383     0.200
     0.588    12.383     0.200
     0.692    13.484     0.200
     0.823    15.586     0.200
     0.930    16.586     0.200
     0.994    16.883     0.200
     1.035    17.484     0.200
     1.357    22.086     0.200
     1.464    24.680     0.200
     1.504    24.984     0.200
     1.807    29.383     0.200
     1.808    29.383     0.200
     2.244    34.984     0.200
     2.244    35.086     0.200
     4.520    66.680     0.200
     7.266   104.180     0.200
     8.671   126.031     0.200
     0.222     8.984     0.200
     0.283     9.984     0.200
     0.284     9.984     0.200
     0.399    10.387     0.200
     0.706    14.285     0.200
     0.844    16.484     0.200
     0.938    16.184     0.200
     1.139    19.484     0.200
     1.305    22.684     0.200
     1.360    23.785     0.200
     1.858    29.887     0.200
     1.858    30.184     0.200
     2.697    41.984     0.200
     4.670    69.086     0.200
     6.853    97.984     0.200
     6.853    98.445     0.200
     6.853    98.184     0.200
     6.853    99.086     0.200
     8.299   118.211     0.200
    12.614   176.887     0.200
    12.614   176.887     0.200
    14.611   205.387     0.200
     0.122     6.039     0.200
     0.477    10.438     0.200
     0.513    10.734     0.200
     0.559    10.641     0.200
     0.677    12.539     0.200
     0.917    15.836     0.200
     1.034    18.141     0.200
     1.127    19.539     0.200
     1.175    19.438     0.200
     1.217    20.641     0.200
     1.281    21.641     0.200
     1.287    21.938     0.200
     1.361    22.039     0.200
     1.870    30.539     0.200
     2.985    45.734     0.200
     4.848    73.641     0.200
     6.631    96.641     0.200
     6.631    97.539     0.200
     7.989   115.359     0.200
    12.279   176.836     0.200
    14.851   207.039     0.200
     0.154     8.695     0.200
     0.244     9.391     0.200
     0.367     9.891     0.200
     0.304    10.891     0.200
     0.304    10.391     0.200
     0.304    10.102     0.200
     0.303    10.289     0.200
     0.704    14.492     0.200
     0.812    15.891     0.200
     0.922    15.891     0.200
     1.107    18.992     0.200
     1.153    19.891     0.200
     1.313    23.094     0.200
     1.346    23.289     0.200
     1.375    22.492     0.200
     1.520    24.789     0.200
     1.581    26.195     0.200
     1.740    29.195     0.200
     1.764    28.594     0.200
     1.837    29.891     0.200
     1.780    28.789     0.200
     2.145    33.789     0.200
     2.267    34.695     0.200
     2.359    37.195     0.200
     2.544    37.289     0.200
     2.665    40.789     0.200
     2.675    40.695     0.200
     2.810    43.195     0.200
     2.878    43.992     0.200
     3.157    46.992     0.200
     3.144    46.789     0.200
     3.454    51.594     0.200
     3.521    53.094     0.200
     3.643    53.195     0.200
     3.973    58.594     0.200
     4.075    58.492     0.200
     4.449    68.195     0.200
     4.353    63.391     0.200
     4.532    68.195     0.200
     4.646    68.992     0.200
     4.646    68.219     0.200
     4.797    71.992     0.200
     4.837    70.992     0.200
     5.336    77.492     0.200
     5.545    80.391     0.200
     5.644    82.195     0.200
     5.947    85.695     0.200
     6.280    90.695     0.200
     6.436    93.594     0.200
     6.516    92.594     0.200
     6.691    96.695     0.200
     6.885    98.594     0.200
     6.885    98.391     0.200
     6.885    98.695     0.200
     6.885    98.992     0.200
     7.046   101.094     0.200
     7.074    99.594     0.200
     7.546   108.492     0.200
     7.697   106.789     0.200
     7.765   108.594     0.200
     8.047   114.789     0.200
     8.048   114.195     0.200
     8.277   119.094     0.200
     8.277   118.289     0.200
     8.252   117.695     0.200
     8.312   119.141     0.200
     8.354   119.289     0.200
     8.416   118.289     0.200
     8.742   125.594     0.200
     9.671   134.492     0.200
    10.073   143.891     0.200
    10.133   143.594     0.200
    11.689   165.492     0.200
    12.641   177.672     0.200
    12.641   177.672     0.200
    12.983   181.594     0.200
    13.308   185.000     0.200
    13.308   185.391     0.200
    14.579   200.953     0.200
    14.579   199.891     0.200
    16.635   229.094     0.200
    17.656   239.672     0.200
     0.257     9.258     0.200
     0.330    10.359     0.200
     0.387    10.957     0.200
     0.703    14.859     0.200
     0.701    14.059     0.200
     0.869    15.156     0.200
     0.998    17.859     0.200
     1.275    21.359     0.200
     1.301    22.559     0.200
     1.340    23.156     0.200
     1.763    29.082     0.200
     2.558    39.957     0.200
     4.424    66.359     0.200
     4.560    68.758     0.200
     6.996   100.156     0.200
     6.996   100.109     0.200
     8.348   117.633     0.200
     8.470   122.258     0.200
    12.730   178.109     0.200
     0.195     8.938     0.200
     0.283    10.133     0.200
     0.283    10.336     0.200
     0.423    10.734     0.200
     0.694    14.133     0.200
     0.870    16.734     0.200
     0.938    16.234     0.200
     1.160    19.836     0.200
     1.286    22.336     0.200
     1.357    23.234     0.200
     1.863    30.039     0.200
     2.724    42.039     0.200
     4.591    69.438     0.200
     4.679    70.938     0.200
     6.830    98.836     0.200
     6.830    98.445     0.200
     6.833    98.133     0.200
     8.277   117.109     0.200
     8.351   119.438     0.200
     9.494   131.914     0.200
    12.322   172.836     0.200
    12.945   183.734     0.200
    13.466   191.133     0.200
     0.200     8.590     0.200
     0.292     9.590     0.200
     0.292    10.090     0.200
     0.292     9.590     0.200
     0.411     9.988     0.200
     0.690    13.988     0.200
     0.858    16.090     0.200
     0.929    15.789     0.200
     1.285    22.387     0.200
     1.349    23.188     0.200
     1.595    26.090     0.200
     1.732    27.988     0.200
     1.801    28.789     0.200
     1.797    27.789     0.200
     1.852    29.438     0.200
     2.226    33.887     0.200
     2.634    39.688     0.200
     2.712    41.590     0.200
     2.831    42.988     0.200
     3.206    46.789     0.200
     4.579    68.090     0.200
     4.668    68.988     0.200
     4.792    70.590     0.200
     5.598    81.789     0.200
     5.794    85.090     0.200
     5.904    85.387     0.200
     6.447    93.988     0.200
     6.822    98.887     0.200
     6.842    97.988     0.200
     6.842    98.188     0.200
     6.842    98.387     0.200
     6.842    98.387     0.200
     7.003   100.590     0.200
     8.239   118.387     0.200
     8.279   118.812     0.200
     9.067   129.789     0.200
     9.180   131.188     0.200
     9.333   133.387     0.200
     9.506   131.289     0.200
    10.041   140.789     0.200
    10.041   143.379     0.200
    10.490   146.188     0.200
    10.481   149.262     0.200
    11.268   160.887     0.200
    11.771   166.785     0.200
    11.779   166.777     0.200
    11.779   166.617     0.200
    11.901   169.676     0.200
    11.923   168.980     0.200
    11.923   168.871     0.200
    11.973   169.672     0.200
    11.998   170.207     0.200
    12.050   170.836     0.200
    12.192   172.555     0.200
    12.204   173.426     0.200
    12.494   176.469     0.200
    12.594   177.484     0.200
    12.578   177.637     0.200
    12.579   178.457     0.200
    12.594   177.488     0.200
    12.608   178.277     0.200
    12.760   179.945     0.200
    12.802   180.789     0.200
    12.947   181.887     0.200
    12.911   182.508     0.200
    12.984   183.109     0.200
    12.995   182.641     0.200
    13.021   183.414     0.200
    13.110   185.723     0.200
    13.137   185.840     0.200
    13.203   185.699     0.200
    13.260   186.090     0.200
    13.261   184.789     0.200
    13.261   184.688     0.200
    13.325   186.902     0.200
    13.328   187.645     0.200
    13.475   190.270     0.200
    13.475   188.488     0.200
    13.504   189.457     0.200
    13.688   193.074     0.200
    13.910   194.906     0.200
    13.960   195.965     0.200
    14.053   197.379     0.200
    14.064   195.688     0.200
    14.148   196.188     0.200
    14.241   199.277     0.200
    14.456   201.387     0.200
    14.623   200.430     0.200
    16.591   228.289     0.200
    17.633   238.887     0.200
    20.710   280.090     0.200
     0.349     9.434     0.200
     0.536    11.734     0.200
     0.688    13.834     0.200
     0.857    16.135     0.200
     0.879    15.934     0.200
     0.946    16.635     0.200
     0.951    17.135     0.200
     0.998    18.035     0.200
     1.260    21.834     0.200
     1.264    21.334     0.200
     1.320    22.234     0.200
     1.429    23.834     0.200
     1.517    24.434     0.200
     1.885    30.510     0.200
     3.170    48.535     0.200
     5.027    76.734     0.200
     6.510    95.635     0.200
     6.511    95.771     0.200
     7.770   113.309     0.200
    12.060   172.334     0.200
    14.993   209.609     0.200
     6.813   103.531     0.200
     6.813   103.547     0.200
     7.000   102.258     0.200
     7.159   101.438     0.200
     7.586   111.531     0.200
     8.758   130.531     0.200
     8.758   130.234     0.200
     9.253   131.938     0.200
    11.714   171.086     0.200
    20.408   277.531     0.200
    20.408   279.766     0.200
     0.121     8.246     0.200
     0.286     9.844     0.200
     0.274     9.145     0.200
     0.360     9.746     0.200
     0.735    14.445     0.200
     0.800    15.844     0.200
     0.945    15.844     0.200
     1.104    18.945     0.200
     1.165    19.945     0.200
     1.347    23.145     0.200
     1.354    22.246     0.200
     1.372    23.344     0.200
     1.854    30.145     0.200
     1.855    30.094     0.200
     2.650    41.445     0.200
     2.650    41.547     0.200
     4.517    68.547     0.200
     4.659    69.445     0.200
     6.894   100.094     0.200
     0.154     8.809     0.200
     0.321    10.408     0.200
     0.322    10.408     0.200
     0.322    10.607     0.200
     0.322    10.268     0.200
     0.433    10.908     0.200
     0.648    13.707     0.200
     0.884    17.008     0.200
     0.903    16.008     0.200
     1.161    19.908     0.200
     1.238    21.809     0.200
     1.318    22.908     0.200
     1.834    29.783     0.200
     1.834    30.158     0.200
     2.741    42.309     0.200
     3.241    47.309     0.200
     4.607    69.607     0.200
     4.654    69.508     0.200
     4.654    69.617     0.200
     6.823    98.877     0.200
     6.825    98.508     0.200
     6.825    98.688     0.200
     6.825    98.508     0.200
     6.825    98.434     0.200
     8.190   116.809     0.200
     8.230   117.559     0.200
     8.307   114.707     0.200
     8.345   118.668     0.200
     9.992   143.107     0.200
     9.992   143.328     0.200
    10.962   156.008     0.200
    12.552   176.758     0.200
    12.530   177.498     0.200
    12.552   175.377     0.200
    12.552   176.809     0.200
    12.898   180.908     0.200
    13.232   184.332     0.200
    13.232   184.508     0.200
    13.435   188.408     0.200
    14.643   203.188     0.200
    14.643   203.389     0.200
    14.643   202.059     0.200
    15.183   210.328     0.200
    17.586   240.107     0.200
    17.586   240.318     0.200
     0.858    15.391     0.200
     0.999    18.090     0.200
     1.095    19.590     0.200
     1.229    22.191     0.200
     2.951    46.992     0.200
     3.476    51.391     0.200
     4.812    72.391     0.200
     6.680    97.789     0.200
     6.680    96.812     0.200
     7.969   114.852     0.200
     9.435   132.523     0.200
     9.436   130.699     0.200
    10.256   148.965     0.200
    12.296   178.539     0.200
    14.805   208.801     0.200
     0.271     9.631     0.200
     0.302    10.430     0.200
     0.303    10.330     0.200
     0.350     9.830     0.200
     0.722    14.631     0.200
     0.792    15.930     0.200
     0.930    16.330     0.200
     1.092    19.031     0.200
     1.350    22.531     0.200
     1.336    23.430     0.200
     1.356    23.430     0.200
     1.839    29.480     0.200
     2.643    41.230     0.200
     3.133    46.631     0.200
     4.510    68.531     0.200
     6.903    99.031     0.200
     6.903    99.730     0.200
     6.903    99.119     0.200
     8.336   118.281     0.200
     8.555   121.230     0.200
    15.204   209.740     0.200
    15.204   209.744     0.200
     0.783    15.395     0.200
     1.514    26.895     0.200
     1.514    26.725     0.200
     2.288    37.995     0.200
     2.288    36.895     0.200
     2.822    42.995     0.200
     4.150    64.695     0.200
     4.277    65.495     0.200
     4.277    63.295     0.200
     4.277    63.625     0.200
     6.443    94.595     0.200
     6.443    93.895     0.200
     7.298   105.564     0.200
     7.300   106.595     0.200
     7.300   105.775     0.200
     7.300   105.595     0.200
     7.300   106.507     0.200
     8.181   116.895     0.200
     8.183   120.095     0.200
     8.183   117.795     0.200
     8.379   120.845     0.200
     8.397   124.595     0.200
     8.820   126.985     0.200
     8.966   130.895     0.200
     9.958   140.670     0.200
    10.363   149.045     0.200
    10.363   151.395     0.200
    10.609   154.395     0.200
    11.865   167.495     0.200
    12.927   184.194     0.200
    12.904   182.845     0.200
    12.928   184.194     0.200
    13.077   186.895     0.200
    13.688   191.870     0.200
    13.688   193.295     0.200
    14.169   199.824     0.200
    14.169   198.694     0.200
    14.169   198.870     0.200
    16.844   232.095     0.200
     0.979    19.719     0.200
     1.883    32.641     0.200
     1.883    32.195     0.200
     3.054    48.320     0.200
     4.723    71.750     0.200
     4.915    74.516     0.200
     6.578    96.078     0.200
     6.580    98.516     0.200
     6.580    98.273     0.200
     6.580    98.219     0.200
     6.580    97.914     0.200
     8.093   119.008     0.200
     8.144   118.016     0.200
    10.256   149.117     0.200
    12.202   176.977     0.200
    14.908   208.859     0.200
    14.911   208.867     0.200
    18.105   249.023     0.200
     1.949    32.895     0.200
     3.068    48.672     0.200
     3.579    54.973     0.200
     4.789    73.812     0.200
     4.932    75.172     0.200
     6.540    98.543     0.200
     6.541    96.973     0.200
     6.541    98.484     0.200
     6.541    97.996     0.200
     7.906   115.074     0.200
     7.972   117.324     0.200
     8.056   118.562     0.200
     8.437   120.773     0.200
     9.291   132.199     0.200
     9.293   132.422     0.200
    10.328   151.797     0.200
    11.060   157.973     0.200
    12.214   177.371     0.200
    12.191   174.461     0.200
    12.214   173.582     0.200
    12.624   181.473     0.200
    12.645   179.074     0.200
    14.939   209.223     0.200
    14.939   210.211     0.200
    14.939   209.172     0.200
    18.162   251.043     0.200
     1.917    32.609     0.200
     1.917    32.350     0.200
     3.020    47.809     0.200
     3.531    53.910     0.200
     4.757    72.719     0.200
     4.883    75.309     0.200
     6.586    95.379     0.200
     6.587    98.010     0.200
     6.587    95.270     0.200
     6.587    97.809     0.200
     6.587    97.088     0.200
     7.998   117.660     0.200
     8.103   117.260     0.200
     8.215   118.209     0.200
    10.330   150.709     0.200
    12.258   177.260     0.200
    12.258   174.160     0.200
    14.892   209.260     0.200
    14.895   209.260     0.200
     0.303     9.145     0.200
     0.310     9.043     0.200
     0.500    10.742     0.200
     0.588    12.242     0.200
     0.662    13.645     0.200
     0.906    16.543     0.200
     0.948    17.145     0.200
     0.985    17.941     0.200
     1.071    18.441     0.200
     1.224    20.145     0.200
     1.294    22.543     0.200
     1.538    26.168     0.200
     2.375    36.645     0.200
     2.659    41.645     0.200
     2.701    42.441     0.200
     2.736    42.344     0.200
     3.292    48.043     0.200
     4.587    69.941     0.200
     6.950   100.699     0.200
    12.450   177.938     0.200
    14.547   204.543     0.200
     0.128     8.594     0.200
     0.272     9.793     0.200
     0.272     9.773     0.200
     0.546    12.094     0.200
     0.697    13.893     0.200
     0.995    18.393     0.200
     0.989    16.992     0.200
     1.277    21.293     0.200
     1.240    21.693     0.200
     1.394    23.393     0.200
     1.396    22.793     0.200
     1.415    23.492     0.200
     1.930    31.594     0.200
     2.849    44.293     0.200
     3.340    48.693     0.200
     4.716    70.793     0.200
     4.757    71.072     0.200
     4.757    71.293     0.200
     5.371    76.793     0.200
     6.709   100.434     0.200
     6.709    97.893     0.200
     6.709    97.881     0.200
     8.209   117.268     0.200
     8.230   119.703     0.200
     8.670   125.094     0.200
    10.485   149.117     0.200
    10.485   150.594     0.200
    11.058   157.793     0.200
    12.869   180.393     0.200
    14.758   204.574     0.200
     0.270     9.438     0.200
     0.300    10.238     0.200
     0.301    10.336     0.200
     0.352     9.738     0.200
     0.723    14.535     0.200
     0.794    15.836     0.200
     0.931    15.938     0.200
     1.094    18.938     0.200
     1.337    23.238     0.200
     1.352    22.438     0.200
     1.358    23.438     0.200
     1.841    29.863     0.200
     2.267    35.137     0.200
     2.267    35.535     0.200
     2.569    40.336     0.200
     2.617    41.137     0.200
     2.617    41.238     0.200
     2.645    41.137     0.200
     4.512    67.137     0.200
     4.512    67.438     0.200
     4.646    69.438     0.200
     4.646    67.496     0.200
     6.900    98.445     0.200
     6.901    98.738     0.200
     6.901    99.637     0.200
     6.901    99.238     0.200
     6.901    99.836     0.200
     8.336   118.711     0.200
     8.424   119.707     0.200
     8.847   127.137     0.200
     9.550   133.086     0.200
     9.550   132.668     0.200
     9.627   139.137     0.200
    10.520   147.910     0.200
    10.520   149.938     0.200
    12.666   177.738     0.200
    12.666   176.797     0.200
    12.666   177.738     0.200
    13.547   190.738     0.200
    14.562   200.438     0.200
    14.562   202.363     0.200
    14.562   199.797     0.200
    14.565   202.355     0.200
     0.270    10.305     0.200
     0.240    10.305     0.200
     0.280    10.404     0.200
     0.325    10.104     0.200
     0.386    11.604     0.200
     0.450    12.604     0.200
     0.451    12.225     0.200
     0.451    12.805     0.200
     0.566    13.203     0.200
     0.774    15.904     0.200
     0.772    14.604     0.200
     1.026    18.404     0.200
     1.024    18.703     0.200
     1.196    21.203     0.200
     1.199    21.305     0.200
     1.375    22.904     0.200
     1.435    24.305     0.200
     1.441    23.703     0.200
     1.583    26.305     0.200
     1.591    27.203     0.200
     1.556    25.805     0.200
     1.692    28.154     0.200
     1.692    27.244     0.200
     1.692    28.004     0.200
     1.706    27.305     0.200
     1.796    28.904     0.200
     1.969    31.404     0.200
     2.119    34.404     0.200
     2.123    33.504     0.200
     2.182    34.404     0.200
     2.195    34.305     0.200
     2.260    35.004     0.200
     2.260    35.604     0.200
     2.281    35.904     0.200
     2.556    39.004     0.200
     2.556    39.703     0.200
     2.602    41.004     0.200
     2.633    41.004     0.200
     2.904    44.104     0.200
     2.974    46.305     0.200
     3.152    47.004     0.200
     3.152    47.703     0.200
     3.236    47.805     0.200
     3.741    54.404     0.200
     4.179    59.904     0.200
     4.497    67.404     0.200
     4.446    64.504     0.200
     4.509    67.004     0.200
     4.509    67.443     0.200
     4.587    67.203     0.200
     5.298    75.604     0.200
     6.533    94.404     0.200
     6.663    95.904     0.200
     6.956    99.754     0.200
     6.957    99.203     0.200
     6.957    99.385     0.200
     6.958    99.104     0.200
     6.958    99.453     0.200
     7.610   109.004     0.200
     8.208   117.332     0.200
     8.422   122.104     0.200
     8.445   119.904     0.200
     8.476   119.164     0.200
     8.740   124.604     0.200
     9.159   130.305     0.200
     9.466   138.404     0.200
     9.650   132.254     0.200
     9.650   132.023     0.200
     9.967   140.305     0.200
    10.359   146.854     0.200
    10.359   147.004     0.200
    10.820   154.004     0.200
    11.110   157.404     0.200
    12.213   172.305     0.200
    12.617   176.805     0.200
    12.594   175.043     0.200
    12.617   176.975     0.200
    12.617   176.805     0.200
    12.887   180.305     0.200
    13.342   185.180     0.200
    13.483   187.863     0.200
    13.507   189.404     0.200
    14.514   201.453     0.200
    14.514   200.768     0.200
    14.514   199.254     0.200
    14.900   206.604     0.200
    14.900   204.885     0.200
    15.390   211.203     0.200
    17.528   238.014     0.200
     0.229     8.958     0.200
     0.188     8.958     0.200
     0.341    10.158     0.200
     0.341    10.378     0.200
     0.389    10.158     0.200
     0.399    11.358     0.200
     0.644    13.958     0.200
     0.840    16.158     0.200
     0.880    15.658     0.200
     1.117    19.158     0.200
     1.248    22.258     0.200
     1.300    22.958     0.200
     1.805    29.708     0.200
     1.805    28.998     0.200
     2.621    40.058     0.200
     2.669    41.058     0.200
     2.698    41.458     0.200
     3.200    47.558     0.200
     4.564    69.158     0.200
     4.622    69.558     0.200
     5.364    78.258     0.200
     6.775    99.158     0.200
     6.867    98.558     0.200
     6.868    98.538     0.200
     6.868    98.158     0.200
     6.868    98.746     0.200
     8.247   119.378     0.200
     8.247   118.033     0.200
     8.389   119.068     0.200
     8.758   124.758     0.200
     9.570   138.658     0.200
     9.544   131.008     0.200
     9.544   131.048     0.200
    10.008   141.658     0.200
    10.008   145.218     0.200
    10.444   148.508     0.200
    10.444   145.558     0.200
    10.933   156.658     0.200
    11.223   159.058     0.200
    12.290   170.658     0.200
    12.589   176.958     0.200
    12.567   175.698     0.200
    12.589   177.308     0.200
    12.589   176.958     0.200
    12.918   181.458     0.200
    13.275   184.483     0.200
    13.275   184.898     0.200
    13.473   189.458     0.200
    14.433   201.458     0.200
    14.599   201.678     0.200
    14.599   201.817     0.200
    14.599   199.928     0.200
    14.602   201.818     0.200
    14.982   208.958     0.200
    15.484   212.858     0.200
    16.575   227.458     0.200
     0.162     8.332     0.200
     0.243     9.234     0.200
     0.284     9.832     0.200
     0.285     9.762     0.200
     0.285     9.531     0.200
     0.382     9.934     0.200
     0.469    11.832     0.200
     0.717    14.531     0.200
     0.825    15.934     0.200
     0.940    16.031     0.200
     1.123    19.234     0.200
     1.322    23.332     0.200
     1.364    23.633     0.200
     1.384    22.332     0.200
     1.724    28.031     0.200
     1.782    28.734     0.200
     1.855    30.184     0.200
     1.855    29.742     0.200
     2.021    32.332     0.200
     2.133    33.734     0.200
     2.299    36.031     0.200
     2.273    35.934     0.200
     2.350    37.133     0.200
     2.526    37.031     0.200
     2.601    39.832     0.200
     2.649    41.031     0.200
     2.677    40.934     0.200
     2.688    41.434     0.200
     2.659    40.332     0.200
     2.797    42.734     0.200
     2.868    43.832     0.200
     3.166    47.133     0.200
     3.127    46.531     0.200
     3.438    51.434     0.200
     3.507    52.832     0.200
     3.626    52.934     0.200
     3.958    58.234     0.200
     4.057    58.234     0.200
     4.337    63.031     0.200
     4.544    67.633     0.200
     4.665    68.723     0.200
     5.215    75.031     0.200
     5.439    78.531     0.200
     5.630    81.934     0.200
     6.499    92.234     0.200
     6.822    99.234     0.200
     6.869    98.324     0.200
     6.870    98.055     0.200
     6.870    98.434     0.200
     6.870    98.434     0.200
     6.870    98.582     0.200
     7.302   105.434     0.200
     8.318   118.711     0.200
     8.318   119.484     0.200
     8.393   118.574     0.200
     8.577   123.734     0.200
     9.101   130.031     0.200
     9.213   131.332     0.200
     9.523   132.184     0.200
     9.523   132.113     0.200
     9.634   138.133     0.200
     9.979   140.133     0.200
    10.080   143.902     0.200
    10.517   149.781     0.200
    10.517   148.332     0.200
    10.660   151.031     0.200
    10.981   156.133     0.200
    11.264   159.633     0.200
    12.278   171.133     0.200
    12.637   177.582     0.200
    12.614   176.422     0.200
    12.637   176.613     0.200
    12.637   177.582     0.200
    12.839   179.531     0.200
    12.988   182.133     0.200
    13.297   185.109     0.200
    13.297   184.363     0.200
    13.509   188.305     0.200
    13.509   189.562     0.200
    13.517   189.332     0.200
    14.499   201.633     0.200
    14.974   204.352     0.200
    14.974   204.633     0.200
    15.180   206.793     0.200
    15.554   213.133     0.200
    16.634   228.434     0.200
    19.615   266.406     0.200
     0.164     8.508     0.200
     0.241     8.805     0.200
     0.283     9.906     0.200
     0.384    10.008     0.200
     0.468    11.508     0.200
     0.717    14.305     0.200
     0.828    16.102     0.200
     0.941    16.102     0.200
     1.126    19.102     0.200
     1.321    22.703     0.200
     1.364    23.406     0.200
     1.386    22.703     0.200
     1.857    30.406     0.200
     2.603    40.805     0.200
     2.651    42.008     0.200
     2.680    41.805     0.200
     3.169    48.508     0.200
     4.546    69.906     0.200
     6.868    99.641     0.200
     8.317   118.836     0.200
     0.309    10.712     0.200
     0.163     9.111     0.200
     0.242     9.611     0.200
     0.393    11.212     0.200
     0.432    11.012     0.200
     0.662    13.712     0.200
     0.882    17.012     0.200
     0.914    16.012     0.200
     1.163    19.812     0.200
     1.251    21.911     0.200
     1.331    22.812     0.200
     1.454    23.911     0.200
     1.844    30.236     0.200
     2.362    37.312     0.200
     2.662    42.012     0.200
     2.710    42.712     0.200
     2.739    42.812     0.200
     3.236    48.611     0.200
     4.605    70.012     0.200
     4.663    70.512     0.200
     6.824    98.662     0.200
     8.242   119.486     0.200
     9.498   131.937     0.200
    12.560   174.985     0.200
     0.411     9.023     0.200
     0.492     9.824     0.200
     0.579    10.922     0.200
     0.782    14.324     0.200
     0.851    16.121     0.200
     0.874    15.922     0.200
     1.073    18.023     0.200
     1.158    19.621     0.200
     1.208    20.824     0.200
     1.445    24.098     0.200
     1.445    24.512     0.200
     2.398    37.723     0.200
     2.677    41.523     0.200
     2.753    43.324     0.200
     4.284    64.723     0.200
     4.596    69.621     0.200
     6.974   103.223     0.200
     6.987   101.934     0.200
     6.989   102.023     0.200
     6.989   102.121     0.200
     6.989   101.934     0.200
     7.860   113.051     0.200
     8.496   122.363     0.200
     9.990   145.398     0.200
    12.408   179.750     0.200
    14.524   205.371     0.200
    14.524   205.152     0.200
    14.524   205.473     0.200
    15.032   209.723     0.200
    19.982   271.094     0.200
     0.136     8.461     0.200
     0.273     9.262     0.200
     0.300     9.582     0.200
     0.299    10.059     0.200
     0.351     9.559     0.200
     0.492    11.762     0.200
     0.726    14.359     0.200
     0.792    15.660     0.200
     0.933    15.660     0.200
     0.938    18.559     0.200
     1.093    18.859     0.200
     1.340    23.262     0.200
     1.350    22.160     0.200
     1.360    23.359     0.200
     1.842    29.871     0.200
     2.265    35.559     0.200
     2.567    40.059     0.200
     2.615    41.461     0.200
     2.643    41.961     0.200
     3.132    46.762     0.200
     4.510    68.262     0.200
     6.901    99.121     0.200
     6.902    99.180     0.200
     6.902    98.711     0.200
     8.425   121.320     0.200
     0.337    11.594     0.200
     0.376    11.797     0.200
     0.458    13.094     0.200
     0.622    14.195     0.200
     0.765    15.695     0.200
     0.848    16.898     0.200
     0.881    17.094     0.200
     0.958    18.398     0.200
     1.082    19.094     0.200
     1.117    19.398     0.200
     1.211    21.398     0.200
     1.337    22.695     0.200
     1.525    25.898     0.200
     1.545    26.195     0.200
     1.585    26.297     0.200
     1.605    26.695     0.200
     1.823    30.297     0.200
     1.823    30.094     0.200
     2.132    34.500     0.200
     2.132    34.195     0.200
     2.185    35.297     0.200
     2.207    35.195     0.200
     2.207    35.297     0.200
     2.658    40.297     0.200
     2.658    40.094     0.200
     4.071    61.500     0.200
     4.071    62.297     0.200
     0.198     9.492     0.200
     0.198     9.742     0.200
     0.198     9.492     0.200
     0.246     9.492     0.200
     0.213     9.094     0.200
     0.510    11.695     0.200
     0.462    11.492     0.200
     0.765    14.895     0.200
     0.950    17.992     0.200
     0.918    17.895     0.200
     1.031    17.594     0.200
     1.252    20.992     0.200
     1.327    22.895     0.200
     1.445    24.492     0.200
     1.961    31.785     0.200
     2.417    37.395     0.200
     2.720    41.395     0.200
     2.769    42.793     0.200
     2.797    42.395     0.200
     3.275    47.594     0.200
     4.664    69.094     0.200
     4.779    71.293     0.200
     6.742    97.172     0.200
     6.743    97.164     0.200
     6.743    97.594     0.200
     6.743    97.195     0.200
     6.932   100.992     0.200
     8.266   118.152     0.200
     8.300   121.543     0.200
     8.300   119.105     0.200
     8.692   125.293     0.200
     9.395   129.020     0.200
     9.396   131.312     0.200
    10.561   151.793     0.200
    12.548   179.242     0.200
    12.526   179.504     0.200
    13.180   184.918     0.200
    14.720   201.055     0.200
    14.720   200.793     0.200
    15.061   206.992     0.200
    15.061   206.992     0.200
     0.174     9.125     0.200
     0.234     9.625     0.200
     0.320    10.727     0.200
     0.397    11.125     0.200
     0.414    10.930     0.200
     0.656    13.625     0.200
     0.847    17.125     0.200
     0.864    16.930     0.200
     0.901    16.031     0.200
     1.143    19.625     0.200
     1.251    21.828     0.200
     1.319    22.828     0.200
     1.828    29.930     0.200
     2.344    37.125     0.200
     2.644    41.328     0.200
     2.721    42.227     0.200
     3.220    47.531     0.200
     4.587    69.727     0.200
     6.843    98.547     0.200
     8.246   120.383     0.200
     0.134     8.029     0.200
     0.188     9.129     0.200
     0.313     9.330     0.200
     0.436    10.430     0.200
     0.555    12.330     0.200
     0.823    15.529     0.200
     0.857    16.430     0.200
     1.046    17.430     0.200
     1.180    20.129     0.200
     1.382    22.830     0.200
     1.955    31.529     0.200
     2.312    35.029     0.200
     2.312    35.930     0.200
     2.617    41.029     0.200
     2.617    41.330     0.200
     2.667    42.029     0.200
     2.693    42.029     0.200
     4.560    68.029     0.200
     4.560    70.930     0.200
     6.832    98.857     0.200
     0.146     8.867     0.200
     0.260     9.266     0.200
     0.317    10.266     0.200
     0.318     9.867     0.200
     0.318    10.447     0.200
     0.444    10.967     0.200
     0.376    10.967     0.200
     0.650    13.766     0.200
     0.895    16.967     0.200
     0.829    17.166     0.200
     0.909    15.967     0.200
     1.172    19.766     0.200
     1.235    21.867     0.200
     1.323    22.867     0.200
     1.469    23.766     0.200
     1.426    23.367     0.200
     1.841    30.066     0.200
     4.618    68.867     0.200
     4.663    69.967     0.200
     4.663    69.855     0.200
     5.357    78.166     0.200
     6.812    98.117     0.200
     6.814    98.086     0.200
     6.814    97.766     0.200
     6.814    98.303     0.200
     6.814    97.967     0.200
     8.225   118.586     0.200
     8.225   117.541     0.200
     8.225   118.887     0.200
     8.334   118.516     0.200
     8.576   124.166     0.200
     9.493   130.641     0.200
     9.593   138.867     0.200
     9.988   141.566     0.200
    10.449   147.242     0.200
    10.449   148.266     0.200
    10.970   156.066     0.200
    12.543   176.467     0.200
    12.543   175.176     0.200
    12.893   180.166     0.200
    13.221   184.467     0.200
    13.221   183.236     0.200
    14.654   202.717     0.200
    14.657   202.717     0.200
    15.037   207.467     0.200
    17.584   237.166     0.200
     0.193     8.559     0.200
     0.292     9.659     0.200
     0.292     9.879     0.200
     0.291     9.659     0.200
     0.213     8.659     0.200
     0.400    10.159     0.200
     0.440    11.159     0.200
     0.696    14.059     0.200
     0.847    16.159     0.200
     0.929    15.959     0.200
     1.138    19.259     0.200
     1.295    22.459     0.200
     1.351    23.459     0.200
     1.851    30.034     0.200
     1.850    30.039     0.200
     2.252    33.359     0.200
     2.624    40.359     0.200
     2.624    39.459     0.200
     2.672    42.259     0.200
     2.672    41.459     0.200
     2.701    41.759     0.200
     2.701    41.459     0.200
     4.567    68.659     0.200
     4.567    67.459     0.200
     4.664    70.059     0.200
     4.664    69.459     0.200
     4.664    68.429     0.200
     5.413    79.059     0.200
     6.851    98.769     0.200
     6.852    99.159     0.200
     6.852    98.089     0.200
     6.852    98.659     0.200
     6.852    98.863     0.200
     8.289   116.559     0.200
     8.289   116.475     0.200
     8.374   119.519     0.200
     8.577   124.759     0.200
     9.513   131.868     0.200
     9.514   132.239     0.200
     9.622   139.459     0.200
    10.496   150.657     0.200
    10.496   151.159     0.200
    12.607   178.409     0.200
    12.592   174.399     0.200
    12.607   177.259     0.200
    12.958   182.959     0.200
    13.273   183.773     0.200
    13.273   183.659     0.200
    14.613   203.059     0.200
    17.641   239.959     0.200
     0.266    10.148     0.200
     0.267    10.148     0.200
     0.267    10.039     0.200
     0.192     8.849     0.200
     0.217     9.249     0.200
     0.430    11.148     0.200
     0.441    10.948     0.200
     0.705    14.148     0.200
     0.887    17.249     0.200
     0.884    17.548     0.200
     0.955    16.648     0.200
     1.179    20.048     0.200
     1.291    22.349     0.200
     1.373    24.048     0.200
     2.288    34.249     0.200
     2.288    34.148     0.200
     2.663    40.548     0.200
     2.663    40.148     0.200
     2.712    41.948     0.200
     2.712    41.148     0.200
     2.740    42.349     0.200
     2.740    42.148     0.200
     4.607    68.849     0.200
     4.607    68.148     0.200
     4.698    72.048     0.200
     4.698    68.148     0.200
     6.811    98.704     0.200
     8.279   118.702     0.200
     0.167     8.812     0.200
     0.239     9.113     0.200
     0.267    10.113     0.200
     0.268    10.012     0.200
     0.268    10.121     0.200
     0.399    10.312     0.200
     0.470    11.613     0.200
     0.727    14.512     0.200
     0.841    16.410     0.200
     0.922    18.312     0.200
     0.955    16.211     0.200
     1.141    19.512     0.200
     1.327    23.012     0.200
     1.378    23.613     0.200
     1.396    23.012     0.200
     1.871    30.312     0.200
     1.872    30.312     0.200
     2.237    33.613     0.200
     2.615    40.312     0.200
     2.664    41.711     0.200
     2.692    41.613     0.200
     4.559    68.711     0.200
     4.683    67.602     0.200
     6.837    99.410     0.200
     6.852    97.922     0.200
     6.854    98.812     0.200
     6.854    97.793     0.200
     6.854    99.027     0.200
     6.854    98.891     0.200
     8.280   118.711     0.200
     8.320   117.781     0.200
     8.595   124.711     0.200
    10.527   147.613     0.200
    12.628   177.992     0.200
     0.100     6.613     0.200
     0.245     7.312     0.200
     0.466     9.914     0.200
     0.484    11.613     0.200
     0.620    12.113     0.200
     0.621    12.715     0.200
     0.648    12.414     0.200
     0.755    13.914     0.200
     0.858    15.113     0.200
     0.892    16.516     0.200
     1.039    17.414     0.200
     1.195    20.516     0.200
     1.121    19.016     0.200
     1.199    20.414     0.200
     1.214    20.812     0.200
     1.394    22.516     0.200
     1.805    29.113     0.200
     1.806    29.113     0.200
     2.648    39.312     0.200
     2.648    38.914     0.200
     2.678    41.312     0.200
     2.678    40.914     0.200
     2.968    45.516     0.200
     2.968    44.914     0.200
     3.045    47.113     0.200
     3.045    46.914     0.200
     4.645    69.613     0.200
     4.645    68.766     0.200
     4.902    74.715     0.200
     4.902    73.914     0.200
     5.023    72.516     0.200
     5.023    73.914     0.200
     6.622    96.895     0.200
     6.624    96.715     0.200
     6.624    96.555     0.200
     6.624    96.715     0.200
     6.624    96.914     0.200
     6.624    96.402     0.200
     7.849   114.715     0.200
     7.848   114.312     0.200
     7.848   112.109     0.200
     8.134   117.375     0.200
     8.339   120.113     0.200
     8.553   124.516     0.200
     9.414   130.188     0.200
     9.416   131.223     0.200
    10.164   146.414     0.200
    10.164   145.738     0.200
    12.181   174.062     0.200
    12.595   177.914     0.200
    12.595   176.414     0.200
    12.941   181.789     0.200
    13.072   187.312     0.200
    14.874   206.215     0.200
    14.874   206.312     0.200
    14.874   205.023     0.200
    15.267   211.613     0.200
    15.267   210.914     0.200
    18.038   245.484     0.200
     0.130     8.681     0.200
     0.271     9.881     0.200
     0.271     9.780     0.200
     0.328     9.980     0.200
     0.377    10.681     0.200
     0.555    11.980     0.200
     0.701    13.980     0.200
     0.831    16.881     0.200
     1.004    18.480     0.200
     0.996    17.181     0.200
     1.240    21.780     0.200
     1.286    21.280     0.200
     1.393    22.681     0.200
     1.408    23.480     0.200
     1.400    24.081     0.200
     1.936    31.631     0.200
     1.937    31.631     0.200
     2.406    35.881     0.200
     2.480    38.280     0.200
     2.782    41.081     0.200
     2.858    42.181     0.200
     8.207   115.980     0.200
     8.207   118.724     0.200
     0.187     8.748     0.200
     0.275     9.848     0.200
     0.219     8.848     0.200
     0.408    10.449     0.200
     0.450    11.248     0.200
     0.710    14.148     0.200
     0.853    16.549     0.200
     0.902    17.949     0.200
     0.945    16.148     0.200
     1.148    19.449     0.200
     1.307    22.648     0.200
     1.367    23.648     0.200
     1.412    23.148     0.200
     1.865    30.449     0.200
     1.866    30.473     0.200
     2.253    33.748     0.200
     2.327    36.248     0.200
     2.629    40.748     0.200
     2.705    41.949     0.200
     3.195    47.049     0.200
     4.572    67.549     0.200
     4.679    70.248     0.200
     0.100     5.682     0.200
     0.223     6.682     0.200
     0.353     7.982     0.200
     0.513    12.082     0.200
     0.619    12.281     0.200
     0.620    12.582     0.200
     0.597    11.281     0.200
     0.700    12.682     0.200
     0.915    17.182     0.200
     1.024    17.883     0.200
     1.073    18.781     0.200
     1.141    18.883     0.200
     1.179    20.582     0.200
     1.207    19.982     0.200
     1.653    27.607     0.200
     1.652    27.582     0.200
     2.483    37.082     0.200
     2.501    38.883     0.200
     2.789    43.182     0.200
     2.866    44.281     0.200
     3.412    50.182     0.200
     4.492    68.982     0.200
     4.720    71.883     0.200
     4.720    70.682     0.200
     6.810    99.082     0.200
     7.889   111.682     0.200
    12.338   173.254     0.200
     0.131     8.844     0.200
     0.294    10.344     0.200
     0.295    10.578     0.200
     0.295    10.445     0.200
     0.277     9.547     0.200
     0.352     9.844     0.200
     0.498    12.047     0.200
     0.732    14.445     0.200
     0.792    15.844     0.200
     0.939    15.844     0.200
     0.944    18.547     0.200
     1.095    18.844     0.200
     1.348    22.445     0.200
     1.346    23.250     0.200
     1.366    23.344     0.200
     1.846    29.844     0.200
     1.847    29.820     0.200
     2.189    32.547     0.200
     2.189    33.148     0.200
     2.264    35.547     0.200
     2.566    39.547     0.200
     2.566    39.750     0.200
     2.643    40.547     0.200
     3.131    46.547     0.200
     4.510    67.547     0.200
     4.510    68.445     0.200
     4.652    69.547     0.200
     4.652    68.008     0.200
     4.652    69.844     0.200
     6.900    98.109     0.200
     6.901    98.219     0.200
     6.901    99.047     0.200
     6.901    99.047     0.200
     6.901    99.938     0.200
     6.901    97.555     0.200
     8.345   119.219     0.200
     8.345   118.438     0.200
     8.424   118.906     0.200
     9.635   138.945     0.200
    10.529   149.422     0.200
    10.529   151.148     0.200
    12.672   178.047     0.200
    12.747   179.547     0.200
    13.553   189.844     0.200
    14.562   204.328     0.200
    14.562   201.695     0.200
    15.562   216.844     0.200
     0.292     9.535     0.200
     0.329     9.637     0.200
     0.335     9.336     0.200
     0.447    10.434     0.200
     0.512    11.137     0.200
     0.567    11.637     0.200
     0.617    13.734     0.200
     0.847    16.035     0.200
     0.977    17.637     0.200
     1.013    17.836     0.200
     0.990    17.734     0.200
     1.187    21.234     0.200
     1.263    21.934     0.200
     1.277    20.934     0.200
     1.362    23.934     0.200
     1.511    25.961     0.200
     2.309    34.535     0.200
     2.315    35.535     0.200
     2.600    40.535     0.200
     2.677    42.035     0.200
     3.232    48.234     0.200
     4.529    67.535     0.200
     7.002   102.262     0.200
     0.199     6.172     0.200
     0.350     8.969     0.200
     0.425     8.570     0.200
     0.555    10.969     0.200
     0.535    12.469     0.200
     0.668    12.375     0.200
     0.823    15.375     0.200
     0.823    15.078     0.200
     0.821    14.875     0.200
     0.902    16.172     0.200
     0.874    16.469     0.200
     1.005    17.375     0.200
     1.037    18.773     0.200
     1.137    19.570     0.200
     1.201    21.172     0.200
     1.377    23.195     0.200
     2.337    36.875     0.200
     2.357    35.469     0.200
     2.357    35.273     0.200
     2.612    40.969     0.200
     2.689    42.672     0.200
     4.215    63.969     0.200
     4.215    61.672     0.200
     4.528    69.172     0.200
     6.352    94.672     0.200
     7.064   103.852     0.200
     7.065   103.875     0.200
     7.065   103.562     0.200
     7.065   102.773     0.200
     7.877   115.125     0.200
     8.127   120.773     0.200
     9.967   142.672     0.200
     9.967   143.969     0.200
    10.499   151.773     0.200
    12.193   174.172     0.200
    12.464   177.625     0.200
    12.464   179.570     0.200
    14.449   203.984     0.200
    14.998   207.172     0.200
    15.007   209.172     0.200
    17.590   242.727     0.200
    17.590   241.812     0.200
     0.216     6.812     0.200
     0.367     9.113     0.200
     0.415     8.715     0.200
     0.476    10.215     0.200
     0.539    10.715     0.200
     0.556    12.215     0.200
     0.661    12.113     0.200
     0.882    15.914     0.200
     0.891    16.113     0.200
     0.983    17.012     0.200
     1.048    18.512     0.200
     1.124    19.414     0.200
     2.315    36.113     0.200
     2.315    36.914     0.200
     2.336    35.113     0.200
     2.590    40.113     0.200
     2.590    40.715     0.200
     2.667    41.113     0.200
     2.667    41.715     0.200
     4.204    65.312     0.200
     4.506    67.914     0.200
     4.506    69.414     0.200
     0.227    11.451     0.200
     0.316    11.951     0.200
     0.324    12.053     0.200
     0.436    13.451     0.200
     0.593    14.951     0.200
     0.593    14.332     0.200
     0.592    14.252     0.200
     0.681    15.352     0.200
     0.808    16.752     0.200
     0.935    17.951     0.200
     0.972    18.252     0.200
     1.010    18.152     0.200
     1.036    19.451     0.200
     1.274    22.252     0.200
     1.353    22.951     0.200
     1.440    24.553     0.200
     1.489    25.252     0.200
     1.523    25.553     0.200
     1.518    25.652     0.200
     1.640    28.053     0.200
     1.775    27.252     0.200
     1.784    29.553     0.200
     1.785    29.553     0.200
     1.862    30.252     0.200
     2.168    34.252     0.200
     2.244    35.252     0.200
     4.111    60.451     0.200
     4.501    66.852     0.200
     4.501    65.271     0.200
     6.673    96.252     0.200
     7.269   103.502     0.200
     7.270   103.053     0.200
     7.270   103.342     0.200
     7.270   102.951     0.200
     7.270   103.002     0.200
     8.397   120.053     0.200
     8.650   122.352     0.200
     8.797   124.092     0.200
     9.839   135.861     0.200
     9.840   135.666     0.200
    10.406   145.553     0.200
    10.666   150.902     0.200
    10.842   152.652     0.200
    11.071   156.752     0.200
    12.768   179.252     0.200
    13.082   183.074     0.200
    14.190   195.713     0.200
    14.190   194.418     0.200
    15.409   210.951     0.200
    15.610   214.252     0.200
     1.073    21.270     0.200
     1.310    23.971     0.200
     1.347    24.371     0.200
     1.595    29.070     0.200
     1.735    31.195     0.200
     1.736    31.270     0.200
     3.545    57.570     0.200
     4.239    63.570     0.200
     4.217    65.969     0.200
     4.446    70.172     0.200
     4.446    67.039     0.200
     5.049    80.570     0.200
     5.165    78.871     0.200
     5.349    84.270     0.200
     5.349    84.871     0.200
     6.042    92.270     0.200
     6.071    95.172     0.200
     6.484    99.570     0.200
     6.484    98.070     0.200
     6.544    99.371     0.200
     6.546    99.469     0.200
     6.546    99.242     0.200
     6.546    99.172     0.200
     6.546    99.371     0.200
     6.546    99.480     0.200
     6.774   102.672     0.200
     6.867   105.371     0.200
     7.012   103.070     0.200
     7.044   102.969     0.200
     7.044   102.770     0.200
     7.044   102.945     0.200
     7.123   108.070     0.200
     7.190   110.570     0.200
     7.206   110.770     0.200
     7.567   110.969     0.200
     7.751   117.469     0.200
     7.868   118.570     0.200
     8.015   120.969     0.200
     8.017   120.590     0.200
     8.298   124.570     0.200
     8.298   124.969     0.200
     8.660   124.172     0.200
     8.806   129.371     0.200
     8.806   129.090     0.200
     8.848   128.871     0.200
     9.436   136.770     0.200
     9.567   138.461     0.200
    10.556   154.570     0.200
    10.556   155.172     0.200
    10.789   158.371     0.200
    10.993   161.070     0.200
    11.136   162.969     0.200
    11.580   168.570     0.200
    11.897   170.070     0.200
    12.235   177.371     0.200
    12.378   179.871     0.200
    12.807   186.672     0.200
    12.915   185.570     0.200
    12.957   186.672     0.200
    14.568   203.570     0.200
    14.568   207.871     0.200
    14.651   206.570     0.200
    15.120   214.172     0.200
    15.120   212.250     0.200
    15.175   213.570     0.200
    15.438   217.469     0.200
    15.534   217.969     0.200
    15.534   217.230     0.200
    16.446   232.270     0.200
    17.942   249.570     0.200
    20.987   291.070     0.200
     0.157     8.591     0.200
     0.256     9.391     0.200
     0.313    10.311     0.200
     0.313    10.191     0.200
     0.351     9.691     0.200
     0.472    11.891     0.200
     0.704    14.391     0.200
     0.796    15.891     0.200
     0.917    18.591     0.200
     0.915    15.791     0.200
     1.092    18.990     0.200
     1.318    23.191     0.200
     1.341    23.291     0.200
     1.360    22.391     0.200
     1.827    28.865     0.200
     1.826    28.891     0.200
     1.826    28.691     0.200
     2.573    40.291     0.200
     2.650    42.191     0.200
     4.516    68.591     0.200
     4.635    67.990     0.200
     4.635    69.291     0.200
     5.430    79.490     0.200
     6.900    97.581     0.200
     6.901   102.591     0.200
     6.901    97.841     0.200
     6.901    98.391     0.200
     6.901    98.716     0.200
     6.901    97.601     0.200
     8.318   117.391     0.200
     8.318   119.240     0.200
     9.611   136.091     0.200
     9.611   138.891     0.200
    10.502   148.791     0.200
    10.502   148.191     0.200
    12.249   171.990     0.200
    12.655   177.841     0.200
    13.537   190.591     0.200
     0.541    11.797     0.200
     0.571    11.898     0.200
     0.713    13.602     0.200
     0.704    13.797     0.200
     0.871    16.000     0.200
     0.961    16.695     0.200
     1.032    17.898     0.200
     1.245    20.602     0.200
     1.335    22.898     0.200
     1.374    21.797     0.200
     1.381    21.797     0.200
     1.474    24.398     0.200
     1.489    23.898     0.200
     1.489    24.695     0.200
     1.591    25.797     0.200
     1.635    27.602     0.200
     1.800    28.398     0.200
     1.847    29.586     0.200
     1.849    30.023     0.200
     1.874    30.195     0.200
     3.735    57.195     0.200
     4.418    65.000     0.200
     4.418    64.531     0.200
     7.620   108.102     0.200
     7.620   107.406     0.200
     7.620   108.102     0.200
     7.620   108.234     0.200
     7.620   107.969     0.200
     8.977   129.602     0.200
     8.977   127.906     0.200
    10.843   155.625     0.200
    10.843   153.695     0.200
    13.487   192.688     0.200
    13.845   194.297     0.200
    14.126   197.438     0.200
    15.596   216.375     0.200
     0.235     6.594     0.200
     0.411     9.195     0.200
     0.586    12.891     0.200
     0.674    12.797     0.200
     0.850    15.391     0.200
     0.790    15.297     0.200
     0.908    16.797     0.200
     1.047    19.094     0.200
     1.328    23.312     0.200
     1.329    23.547     0.200
     1.603    25.797     0.200
     2.279    36.695     0.200
     2.554    40.891     0.200
     2.630    42.695     0.200
     4.165    63.297     0.200
     4.165    62.914     0.200
     4.467    68.594     0.200
     4.467    69.195     0.200
     4.933    70.297     0.200
     6.305    93.992     0.200
     7.128   103.492     0.200
     7.128   102.891     0.200
     7.128   104.133     0.200
     7.128   103.797     0.200
     7.903   112.992     0.200
     7.903   113.469     0.200
     8.078   117.992     0.200
     8.078   118.891     0.200
     9.061   132.797     0.200
     9.657   136.992     0.200
     9.921   140.617     0.200
     9.961   141.945     0.200
     9.961   143.094     0.200
     9.961   145.391     0.200
    10.454   150.195     0.200
    12.123   172.492     0.200
    12.169   172.195     0.200
    12.518   177.742     0.200
    12.501   177.391     0.200
    12.519   177.195     0.200
    13.398   189.023     0.200
    14.385   200.992     0.200
    14.385   201.305     0.200
    14.385   203.547     0.200
    14.385   202.102     0.200
    14.983   210.992     0.200
    14.986   208.391     0.200
    15.567   214.594     0.200
    15.662   216.094     0.200
    15.662   216.875     0.200
    17.162   238.195     0.200
    20.764   280.297     0.200
     0.158     7.734     0.200
     0.248     8.336     0.200
     0.331     8.936     0.200
     0.542    11.336     0.200
     0.550    11.436     0.200
     0.631    13.336     0.200
     0.536    12.836     0.200
     0.652    12.836     0.200
     0.931    17.234     0.200
     0.970    17.436     0.200
     1.036    18.734     0.200
     1.179    19.836     0.200
     1.147    19.336     0.200
     1.174    20.535     0.200
     1.363    23.234     0.200
     1.604    27.035     0.200
     1.604    27.061     0.200
     2.430    36.035     0.200
     2.444    37.035     0.200
     2.444    37.836     0.200
     2.486    39.635     0.200
     2.731    41.035     0.200
     2.731    41.936     0.200
     2.808    43.035     0.200
     4.661    67.836     0.200
     6.871   100.109     0.200
     9.642   133.510     0.200
     0.457     9.610     0.200
     0.517    11.110     0.200
     0.578    11.910     0.200
     0.762    14.110     0.200
     0.753    14.910     0.200
     0.823    15.210     0.200
     0.975    18.010     0.200
     1.150    20.210     0.200
     1.150    19.710     0.200
     1.150    19.610     0.200
     1.166    20.810     0.200
     1.642    27.935     0.200
     1.643    27.910     0.200
     1.643    27.670     0.200
     1.873    30.850     0.200
     2.985    44.510     0.200
     3.223    51.110     0.200
     4.427    67.560     0.200
     4.770    71.280     0.200
     5.284    79.700     0.200
     6.637    95.810     0.200
     6.637    99.410     0.200
     6.637    99.010     0.200
     6.637    98.541     0.200
     6.637    99.410     0.200
     7.333   107.910     0.200
     8.124   119.170     0.200
     9.577   132.910     0.200
     9.658   137.885     0.200
    11.005   160.810     0.200
    14.958   210.710     0.200
    14.958   211.160     0.200
    14.958   210.860     0.200
    15.366   213.710     0.200
    16.713   230.410     0.200
     0.508    11.008     0.200
     0.594    11.707     0.200
     0.747    14.707     0.200
     0.916    16.508     0.200
     1.136    19.508     0.200
     1.155    20.508     0.200
     1.143    19.879     0.200
     1.143    19.609     0.200
     1.626    27.684     0.200
     1.627    26.949     0.200
     1.889    30.688     0.200
     4.413    67.988     0.200
     4.784    70.887     0.200
     5.301    79.496     0.200
     6.478    92.746     0.200
     6.654    98.227     0.200
     6.654    99.109     0.200
     6.654    99.418     0.200
     7.343   106.656     0.200
     7.343   105.758     0.200
     8.141   119.316     0.200
     9.658   138.258     0.200
    11.857   171.059     0.200
    14.940   210.133     0.200
     0.162     9.094     0.200
     0.235     9.594     0.200
     0.246     9.594     0.200
     0.327    10.695     0.200
     0.328    10.719     0.200
     0.421    10.898     0.200
     0.384    11.094     0.200
     0.646    13.594     0.200
     0.872    16.797     0.200
     0.835    17.094     0.200
     0.896    15.695     0.200
     1.149    19.594     0.200
     1.161    20.398     0.200
     1.240    21.797     0.200
     1.312    22.594     0.200
     1.448    23.797     0.200
     1.552    25.195     0.200
     1.824    29.852     0.200
     1.825    29.547     0.200
     1.825    29.898     0.200
     2.086    33.133     0.200
     2.289    34.797     0.200
     2.289    34.695     0.200
     2.353    37.094     0.200
     2.353    37.195     0.200
     2.653    41.594     0.200
     2.653    40.992     0.200
     2.729    42.594     0.200
     2.729    41.992     0.200
     4.595    68.195     0.200
     4.645    69.695     0.200
     4.645    67.672     0.200
     4.645    69.195     0.200
     4.742    68.203     0.200
     5.587    81.195     0.200
     6.444    91.516     0.200
     6.837    97.898     0.200
     6.837    98.508     0.200
     6.837    97.805     0.200
     7.998   113.703     0.200
     8.234   120.422     0.200
     8.357   119.023     0.200
     9.168   130.758     0.200
     9.515   131.062     0.200
    10.446   149.172     0.200
    10.607   151.172     0.200
    12.322   171.695     0.200
    12.562   176.594     0.200
    12.689   178.195     0.200
    16.078   220.094     0.200
     0.213     9.023     0.200
     0.193     8.820     0.200
     0.286    10.023     0.200
     0.422    10.621     0.200
     0.424    11.121     0.200
     0.691    14.023     0.200
     0.869    16.723     0.200
     0.877    17.621     0.200
     0.934    16.023     0.200
     1.158    19.723     0.200
     1.282    22.223     0.200
     1.353    23.223     0.200
     1.434    23.523     0.200
     1.860    30.320     0.200
     2.275    34.320     0.200
     2.346    36.820     0.200
     2.647    40.523     0.200
     2.724    42.023     0.200
     4.676    70.422     0.200
     6.831    98.934     0.200
     8.274   118.570     0.200
    12.584   176.773     0.200
     0.100     8.812     0.200
     0.149     8.914     0.200
     0.454    10.812     0.200
     0.547    12.211     0.200
     0.547    12.812     0.200
     0.547    12.711     0.200
     0.539    12.312     0.200
     0.556    13.211     0.200
     0.637    13.117     0.200
     0.811    14.914     0.200
     0.965    17.812     0.200
     0.965    17.938     0.200
     1.079    19.211     0.200
     1.146    19.016     0.200
     1.181    20.211     0.200
     1.239    21.016     0.200
     1.257    21.516     0.200
     1.289    21.312     0.200
     1.764    28.336     0.200
     1.764    28.711     0.200
     1.763    28.758     0.200
     1.798    28.016     0.200
     1.931    30.758     0.200
     2.530    37.414     0.200
     2.564    39.211     0.200
     2.622    41.016     0.200
     2.855    43.211     0.200
     2.932    44.211     0.200
     2.932    44.711     0.200
     4.603    68.914     0.200
     4.603    68.633     0.200
     4.685    67.453     0.200
     4.791    71.312     0.200
     5.095    73.812     0.200
     5.431    79.492     0.200
     6.389    90.906     0.200
     6.712    96.664     0.200
     6.714    97.414     0.200
     6.714    97.117     0.200
     6.714    96.500     0.200
     6.714    97.570     0.200
     6.737    98.617     0.200
     7.870   112.508     0.200
     7.945   112.914     0.200
     7.945   114.562     0.200
     7.945   112.836     0.200
     7.945   113.914     0.200
     8.226   118.445     0.200
     8.447   118.117     0.200
     8.514   123.016     0.200
     9.007   128.727     0.200
     9.423   134.312     0.200
     9.478   132.336     0.200
     9.707   140.016     0.200
    10.215   144.336     0.200
    10.215   143.812     0.200
    10.415   148.383     0.200
    10.879   154.914     0.200
    11.000   155.531     0.200
    11.208   157.914     0.200
    12.300   173.367     0.200
    12.284   174.047     0.200
    12.300   173.117     0.200
    12.490   175.211     0.200
    12.490   174.414     0.200
    12.517   174.914     0.200
    13.050   181.492     0.200
    13.190   183.312     0.200
    13.313   185.016     0.200
    14.775   205.312     0.200
    14.775   202.742     0.200
    14.775   203.914     0.200
    15.166   210.914     0.200
    15.166   209.312     0.200
    15.224   209.117     0.200
    15.224   210.336     0.200
    15.284   212.711     0.200
    15.284   210.711     0.200
    15.315   211.617     0.200
    15.877   218.414     0.200
     0.164     8.749     0.200
     0.244     9.348     0.200
     0.298    10.348     0.200
     0.299    10.549     0.200
     0.370     9.948     0.200
     0.465    11.848     0.200
     0.707    14.448     0.200
     0.815    15.948     0.200
     0.913    18.549     0.200
     0.926    15.848     0.200
     1.111    19.049     0.200
     1.316    23.148     0.200
     1.351    23.348     0.200
     1.377    22.549     0.200
     1.668    27.648     0.200
     1.769    28.648     0.200
     1.840    29.888     0.200
     1.841    29.499     0.200
     1.841    29.848     0.200
     2.142    33.848     0.200
     2.142    34.088     0.200
     2.218    33.148     0.200
     2.290    36.049     0.200
     2.395    37.948     0.200
     2.592    40.648     0.200
     2.668    41.148     0.200
     2.668    41.249     0.200
     4.535    67.948     0.200
     4.535    67.549     0.200
     4.651    69.648     0.200
     4.651    69.408     0.200
     4.651    68.948     0.200
     4.771    68.769     0.200
     5.431    78.448     0.200
     5.431    79.148     0.200
     5.641    82.148     0.200
     6.012    84.749     0.200
     6.276    90.749     0.200
     6.433    94.348     0.200
     6.471    90.559     0.200
     6.512    92.648     0.200
     6.807    98.848     0.200
     6.880    99.309     0.200
     6.882    98.648     0.200
     6.882    98.888     0.200
     6.882    98.348     0.200
     6.882    98.948     0.200
     6.882    98.211     0.200
     6.882    98.549     0.200
     7.043   101.348     0.200
     7.071   100.348     0.200
     7.344   103.848     0.200
     7.484   105.249     0.200
     7.484   109.249     0.200
     7.543   109.049     0.200
     7.615   106.648     0.200
     7.693   106.948     0.200
     7.893   109.749     0.200
     7.999   111.348     0.200
     8.043   115.249     0.200
     8.043   114.789     0.200
     8.044   114.848     0.200
     8.100   111.549     0.200
     8.171   117.148     0.200
     8.262   114.448     0.200
     8.313   118.973     0.200
     8.313   119.088     0.200
     8.314   120.049     0.200
     8.314   118.958     0.200
     8.404   119.469     0.200
     8.412   118.148     0.200
     8.531   121.989     0.200
     8.562   123.648     0.200
     8.822   126.549     0.200
     9.223   131.118     0.200
     9.352   131.549     0.200
     9.537   131.924     0.200
     9.537   131.598     0.200
     9.621   138.749     0.200
    10.075   140.948     0.200
    10.075   143.858     0.200
    10.506   148.948     0.200
    10.506   148.749     0.200
    10.669   151.128     0.200
    10.967   156.749     0.200
    11.219   156.789     0.200
    11.249   160.648     0.200
    12.268   171.148     0.200
    12.640   177.226     0.200
    12.625   177.188     0.200
    12.640   176.448     0.200
    12.731   177.448     0.200
    12.985   181.948     0.200
    13.099   182.249     0.200
    13.235   186.469     0.200
    13.306   184.723     0.200
    13.521   190.049     0.200
    14.582   202.848     0.200
    14.582   201.408     0.200
    14.582   199.573     0.200
    14.582   199.378     0.200
    14.754   204.078     0.200
    15.195   207.284     0.200
    15.195   207.118     0.200
    15.543   215.148     0.200
    15.543   214.648     0.200
    16.128   222.148     0.200
    16.635   228.348     0.200
    17.659   239.948     0.200
     0.270    10.211     0.200
     0.219     9.711     0.200
     0.547    12.609     0.200
     0.547    12.711     0.200
     0.478    12.414     0.200
     0.639    13.609     0.200
     0.825    16.312     0.200
     0.844    16.312     0.200
     0.950    17.008     0.200
     0.980    17.812     0.200
     1.007    17.711     0.200
     1.319    22.312     0.200
     1.398    23.211     0.200
     1.439    24.812     0.200
     1.820    28.211     0.200
     1.820    27.711     0.200
     1.908    31.008     0.200
     1.908    30.711     0.200
     2.043    33.211     0.200
     2.214    35.109     0.200
     2.214    34.711     0.200
     2.290    36.008     0.200
     2.290    35.711     0.200
     4.157    64.312     0.200
     4.157    61.711     0.200
     4.527    67.508     0.200
     4.527    66.711     0.200
     7.225   101.312     0.200
     7.224   103.172     0.200
     8.426   121.711     0.200
     8.426   121.211     0.200
     8.626   121.805     0.200
    13.040   182.484     0.200
    14.235   195.859     0.200
     0.496    11.523     0.200
     0.608    12.828     0.200
     0.651    13.227     0.200
     0.754    14.422     0.200
     0.851    15.727     0.200
     0.851    15.625     0.200
     0.851    16.031     0.200
     0.978    17.422     0.200
     1.136    19.328     0.200
     1.213    20.227     0.200
     1.248    20.125     0.200
     1.406    23.727     0.200
     1.481    23.328     0.200
     1.481    23.523     0.200
     1.488    23.328     0.200
     1.521    24.922     0.200
     1.585    25.922     0.200
     1.607    26.328     0.200
     1.623    27.023     0.200
     1.775    29.227     0.200
     1.867    30.172     0.200
     1.867    30.328     0.200
     1.869    30.297     0.200
     1.910    30.125     0.200
     1.984    31.523     0.200
     1.984    31.625     0.200
     2.844    43.203     0.200
     3.845    59.523     0.200
     3.845    58.922     0.200
     4.480    67.023     0.200
     4.480    64.422     0.200
     4.480    66.125     0.200
     5.309    74.688     0.200
     6.318    90.172     0.200
     6.655    98.422     0.200
     6.992    97.688     0.200
     7.510   106.539     0.200
     7.511   106.625     0.200
     8.353   120.625     0.200
     8.675   122.977     0.200
     8.759   127.523     0.200
     8.922   127.023     0.200
     9.040   128.047     0.200
     9.724   139.922     0.200
     9.900   138.617     0.200
    10.839   155.797     0.200
    10.839   155.625     0.200
    11.015   157.922     0.200
    11.604   163.227     0.200
    12.446   173.828     0.200
    12.861   180.828     0.200
    13.390   189.172     0.200
    13.954   193.828     0.200
    13.954   196.023     0.200
    13.954   194.367     0.200
    14.323   198.125     0.200
    15.775   218.922     0.200
    15.775   217.523     0.200
     0.132     8.633     0.200
     0.287    10.133     0.200
     0.288    10.332     0.200
     0.275     9.434     0.200
     0.359     9.832     0.200
     0.497    11.934     0.200
     0.799    15.832     0.200
     0.735    14.535     0.200
     1.102    19.035     0.200
     1.353    22.234     0.200
     1.456    23.832     0.200
     1.347    23.332     0.200
     1.347    23.145     0.200
     1.371    23.434     0.200
     1.853    30.133     0.200
     1.854    30.160     0.200
     2.194    33.434     0.200
     2.161    33.953     0.200
     2.379    37.934     0.200
     3.136    46.234     0.200
     4.515    67.734     0.200
     4.515    66.434     0.200
     4.658    68.934     0.200
     4.777    68.703     0.200
     5.657    81.934     0.200
     0.175     8.945     0.200
     0.256    10.141     0.200
     0.256    10.242     0.200
     0.233     9.141     0.200
     0.415    10.547     0.200
     0.468    11.641     0.200
     0.732    14.445     0.200
     0.856    16.641     0.200
     0.921    18.344     0.200
     0.965    16.945     0.200
     1.156    19.742     0.200
     1.326    23.141     0.200
     1.326    22.734     0.200
     1.409    23.141     0.200
     1.387    23.945     0.200
     1.512    24.547     0.200
     1.884    30.641     0.200
     1.884    30.375     0.200
     1.885    30.617     0.200
     2.103    33.875     0.200
     2.250    33.742     0.200
     2.250    34.344     0.200
     2.327    36.445     0.200
     2.436    39.344     0.200
     2.706    42.242     0.200
     3.192    47.641     0.200
     4.573    66.445     0.200
     4.573    67.742     0.200
     4.724    68.500     0.200
     4.696    70.141     0.200
     6.838    97.477     0.200
     6.838    96.195     0.200
     8.361   119.094     0.200
     8.317   117.531     0.200
    12.617   177.297     0.200
     0.148     8.914     0.200
     0.257     9.516     0.200
     0.304    10.414     0.200
     0.305    10.113     0.200
     0.305    10.406     0.200
     0.383    11.113     0.200
     0.452    11.016     0.200
     0.662    13.715     0.200
     0.837    17.215     0.200
     0.902    17.113     0.200
     0.923    16.414     0.200
     1.182    20.113     0.200
     1.244    22.016     0.200
     1.244    21.684     0.200
     1.337    23.113     0.200
     1.578    25.414     0.200
     1.854    30.094     0.200
     1.855    30.641     0.200
     2.055    32.734     0.200
     2.315    34.613     0.200
     2.382    37.613     0.200
     2.759    43.316     0.200
     2.759    42.414     0.200
     3.256    48.613     0.200
     4.625    67.816     0.200
     4.625    68.516     0.200
     4.708    67.465     0.200
     4.677    70.113     0.200
     4.677    69.594     0.200
     6.803    95.555     0.200
     6.804    99.316     0.200
     6.804    95.504     0.200
     6.804    98.375     0.200
     8.232   118.527     0.200
     8.590   125.816     0.200
     8.590   124.215     0.200
    10.461   149.863     0.200
    10.461   150.016     0.200
    10.461   149.215     0.200
    12.353   174.016     0.200
    12.353   172.715     0.200
    12.542   177.113     0.200
     0.143     8.871     0.200
     0.264     9.672     0.200
     0.298    10.473     0.200
     0.298    10.371     0.200
     0.382    10.871     0.200
     0.464    11.172     0.200
     0.667    13.672     0.200
     0.837    16.973     0.200
     0.914    17.371     0.200
     0.932    16.172     0.200
     1.194    20.172     0.200
     1.244    21.770     0.200
     1.244    21.641     0.200
     1.345    23.172     0.200
     1.588    25.770     0.200
     1.864    30.691     0.200
     1.864    30.473     0.200
     1.865    30.473     0.200
     2.043    32.301     0.200
     2.325    34.770     0.200
     2.325    34.871     0.200
     2.491    39.270     0.200
     2.770    42.672     0.200
     3.266    47.973     0.200
     3.266    48.371     0.200
     4.636    67.070     0.200
     4.687    69.973     0.200
     4.696    67.531     0.200
     5.544    80.949     0.200
     6.398    89.551     0.200
     6.791    97.512     0.200
     6.792    97.672     0.200
     6.792    98.098     0.200
     6.792    97.582     0.200
     7.953   113.402     0.200
     8.230   118.070     0.200
     8.313   118.551     0.200
     8.600   124.371     0.200
    10.465   149.895     0.200
    10.567   149.859     0.200
    11.121   154.941     0.200
    12.533   177.820     0.200
    13.203   183.973     0.200
    13.203   184.152     0.200
    14.675   201.746     0.200
     0.126     8.603     0.200
     0.261     9.143     0.200
     0.341    10.283     0.200
     0.372    10.953     0.200
     0.535    12.623     0.200
     0.702    14.793     0.200
     0.967    19.133     0.200
     1.004    17.823     0.200
     1.267    21.353     0.200
     1.322    22.663     0.200
     1.361    23.273     0.200
     1.372    22.583     0.200
     1.780    29.083     0.200
     1.781    29.033     0.200
     2.109    31.683     0.200
     2.109    31.883     0.200
     2.282    37.083     0.200
     2.555    41.083     0.200
     2.555    39.583     0.200
     4.422    68.883     0.200
     4.576    69.483     0.200
     4.576    68.083     0.200
     5.458    79.583     0.200
     6.993   100.632     0.200
     8.369   119.727     0.200
     8.486   121.383     0.200
     9.587   136.383     0.200
    10.508   148.533     0.200
    12.742   179.511     0.200
     0.154     9.301     0.200
     0.251     9.871     0.200
     0.316    10.930     0.200
     0.315    10.871     0.200
     0.383    11.363     0.200
     0.436    11.172     0.200
     0.836    17.363     0.200
     0.887    17.203     0.200
     0.909    16.062     0.200
     1.165    19.930     0.200
     1.241    21.902     0.200
     1.241    22.023     0.200
     1.324    22.883     0.200
     1.460    24.102     0.200
     1.565    25.453     0.200
     2.071    33.160     0.200
     2.302    34.551     0.200
     2.302    34.750     0.200
     2.463    39.352     0.200
     2.744    43.051     0.200
     2.744    42.352     0.200
     3.243    48.453     0.200
     4.610    69.852     0.200
     4.610    68.051     0.200
     4.726    67.801     0.200
     4.661    69.430     0.200
     4.661    69.953     0.200
     4.661    68.051     0.200
     5.571    81.293     0.200
     6.427    90.543     0.200
     6.821    98.410     0.200
     6.821    95.715     0.200
     7.981   114.523     0.200
     8.233   116.676     0.200
     8.341   119.273     0.200
     8.573   122.152     0.200
     9.498   131.125     0.200
     9.499   130.070     0.200
    11.149   155.742     0.200
    11.262   159.152     0.200
    11.930   166.762     0.200
    12.552   175.262     0.200
    14.647   202.641     0.200
    14.647   202.750     0.200
    15.177   206.977     0.200
    15.177   207.832     0.200
     0.218     9.109     0.200
     0.193     8.961     0.200
     0.260    10.008     0.200
     0.447    10.922     0.200
     0.432    11.320     0.200
     0.892    17.070     0.200
     0.887    17.859     0.200
     0.961    16.883     0.200
     1.185    20.180     0.200
     1.294    22.648     0.200
     1.379    23.758     0.200
     1.451    23.922     0.200
     1.554    25.008     0.200
     2.291    35.008     0.200
     2.472    39.711     0.200
     2.744    43.312     0.200
     2.744    43.109     0.200
     3.233    48.109     0.200
     4.611    69.812     0.200
     4.611    68.211     0.200
     4.705    71.109     0.200
     4.705    69.406     0.200
     6.806    97.078     0.200
     8.280   118.195     0.200
     9.467   133.883     0.200
    12.574   176.336     0.200
     0.185     8.879     0.200
     0.255     9.929     0.200
     0.256    10.129     0.200
     0.225     8.959     0.200
     0.422    10.539     0.200
     0.461    11.419     0.200
     0.864    16.629     0.200
     0.914    18.079     0.200
     0.966    16.319     0.200
     1.163    19.669     0.200
     1.320    22.979     0.200
     1.320    22.849     0.200
     1.387    23.809     0.200
     1.522    24.519     0.200
     2.094    33.659     0.200
     2.259    34.119     0.200
     2.445    39.319     0.200
     2.715    42.219     0.200
     4.718    68.699     0.200
     5.591    81.609     0.200
     6.830    98.559     0.200
     8.353   119.879     0.200
     0.193     8.812     0.200
     0.212     9.062     0.200
     0.286    10.078     0.200
     0.286     9.945     0.200
     0.286    10.188     0.200
     0.286    10.688     0.200
     0.405    10.461     0.200
     0.441    11.508     0.200
     0.699    14.273     0.200
     0.851    16.578     0.200
     0.893    18.078     0.200
     0.935    16.172     0.200
     1.143    19.586     0.200
     1.297    22.125     0.200
     1.297    22.797     0.200
     1.356    23.547     0.200
     1.517    24.484     0.200
     2.106    33.078     0.200
     2.255    33.688     0.200
     2.430    38.586     0.200
     2.704    41.688     0.200
     4.571    68.086     0.200
     4.670    69.203     0.200
     4.670    69.984     0.200
     4.670    68.984     0.200
     4.670    69.883     0.200
     4.740    67.891     0.200
     5.416    77.883     0.200
     5.416    78.781     0.200
     5.605    81.727     0.200
     6.441    90.062     0.200
     6.825    99.086     0.200
     6.825   100.086     0.200
     6.847    98.117     0.200
     6.847    98.586     0.200
     6.847    99.781     0.200
     6.847    98.133     0.200
     8.009   112.844     0.200
     8.252   118.688     0.200
     8.291   118.422     0.200
     8.291   117.859     0.200
     8.291   118.383     0.200
     8.370   118.078     0.200
     8.370   120.383     0.200
     8.582   124.281     0.200
     8.794   125.984     0.200
     9.508   132.633     0.200
     9.508   132.305     0.200
     9.627   139.188     0.200
    10.053   142.625     0.200
    10.053   143.281     0.200
    10.053   144.984     0.200
    10.500   147.383     0.200
    10.500   148.883     0.200
    10.632   150.227     0.200
    11.183   157.094     0.200
    11.270   160.281     0.200
    11.774   166.984     0.200
    12.303   170.883     0.200
    12.303   171.086     0.200
    12.605   177.336     0.200
    12.590   176.836     0.200
    12.605   176.492     0.200
    12.960   179.883     0.200
    13.199   184.117     0.200
    13.477   186.891     0.200
    13.486   188.344     0.200
    13.486   189.883     0.200
    13.486   191.086     0.200
    14.468   201.781     0.200
    14.617   202.391     0.200
    14.617   201.688     0.200
    14.617   200.109     0.200
    14.617   202.047     0.200
    14.718   202.484     0.200
    14.999   208.016     0.200
    14.999   206.781     0.200
    14.999   206.984     0.200
    15.172   208.906     0.200
    15.541   213.781     0.200
    16.603   227.383     0.200
    17.644   239.727     0.200
    17.960   244.984     0.200
    18.876   256.688     0.200
    19.590   264.883     0.200
     0.132     8.742     0.200
     0.301    10.422     0.200
     0.301    10.312     0.200
     0.300    10.383     0.200
     0.277     9.543     0.200
     0.347     9.703     0.200
     0.496    11.961     0.200
     0.728    14.473     0.200
     0.788    15.844     0.200
     0.933    15.812     0.200
     0.942    18.574     0.200
     1.090    18.914     0.200
     1.345    22.324     0.200
     1.343    23.152     0.200
     1.360    23.293     0.200
     1.449    23.711     0.200
     2.186    32.812     0.200
     2.171    34.191     0.200
     2.368    37.613     0.200
     2.639    40.711     0.200
     4.506    67.512     0.200
     4.506    67.012     0.200
     4.646    68.902     0.200
     4.646    68.414     0.200
     4.790    68.852     0.200
     5.668    82.203     0.200
     6.490    90.504     0.200
     6.804    99.613     0.200
     6.905   100.121     0.200
     6.906    99.031     0.200
     6.906    98.613     0.200
     6.906    98.977     0.200
     8.068   114.953     0.200
     8.343   118.379     0.200
     8.429   120.672     0.200
     8.557   123.312     0.200
     9.553   134.113     0.200
     9.630   138.914     0.200
    10.525   148.113     0.200
    10.525   151.012     0.200
    10.525   149.512     0.200
    10.699   152.801     0.200
    11.822   167.812     0.200
    12.674   178.012     0.200
    13.015   182.711     0.200
    13.555   190.312     0.200
    14.557   201.113     0.200
    15.557   213.414     0.200
     0.224     9.383     0.200
     0.182     9.078     0.200
     0.289    10.375     0.200
     0.290    10.430     0.200
     0.430    10.922     0.200
     0.415    11.328     0.200
     0.684    14.148     0.200
     0.878    16.992     0.200
     0.868    17.625     0.200
     0.932    16.211     0.200
     1.165    19.891     0.200
     1.273    22.234     0.200
     1.350    23.219     0.200
     1.444    23.758     0.200
     1.548    25.055     0.200
     1.859    30.242     0.200
     1.859    30.227     0.200
     2.079    32.992     0.200
     2.285    34.250     0.200
     2.285    34.453     0.200
     2.456    38.750     0.200
     2.733    42.453     0.200
     4.599    68.648     0.200
     4.677    67.758     0.200
     4.677    69.750     0.200
     4.721    67.945     0.200
     5.578    81.594     0.200
     6.822    99.453     0.200
     6.823    98.352     0.200
     6.823    98.539     0.200
     7.985   114.523     0.200
    10.484   149.602     0.200
    10.484   149.453     0.200
    10.988   156.852     0.200
    12.574   177.305     0.200
     0.205     9.152     0.200
     0.298    10.352     0.200
     0.298    10.453     0.200
     0.297    10.363     0.200
     0.431    11.430     0.200
     0.687    14.102     0.200
     0.850    16.352     0.200
     0.882    17.840     0.200
     0.923    15.840     0.200
     1.286    22.531     0.200
     1.344    23.070     0.200
     1.416    23.043     0.200
     1.520    24.352     0.200
     1.845    29.773     0.200
     1.846    29.242     0.200
     1.846    29.750     0.200
     2.107    33.453     0.200
     2.257    33.551     0.200
     2.428    38.250     0.200
     2.704    41.453     0.200
     4.571    67.953     0.200
     4.660    69.332     0.200
     4.660    69.551     0.200
     4.746    67.402     0.200
     5.405    77.852     0.200
     5.606    81.430     0.200
     6.815    98.551     0.200
     6.815    99.152     0.200
     6.849    99.301     0.200
     6.851    98.160     0.200
     6.851    96.652     0.200
     6.851    98.277     0.200
     8.012   114.512     0.200
     8.242   116.750     0.200
     8.280   119.352     0.200
     8.280   118.027     0.200
     8.372   119.070     0.200
     8.503   119.793     0.200
     8.573   123.953     0.200
     9.615   138.453     0.200
    10.042   142.652     0.200
    10.488   146.828     0.200
    10.488   148.250     0.200
    10.632   149.680     0.200
    10.973   155.652     0.200
    11.184   155.332     0.200
    11.261   160.750     0.200
    12.302   169.250     0.200
    12.302   171.250     0.200
    12.600   176.652     0.200
    12.586   176.570     0.200
    12.601   176.293     0.200
    12.950   180.852     0.200
    13.269   184.203     0.200
    13.269   184.652     0.200
    13.397   187.852     0.200
    13.482   188.551     0.200
    13.482   189.250     0.200
    14.460   201.352     0.200
    14.614   200.250     0.200
    14.718   203.070     0.200
    15.181   210.102     0.200
    15.181   207.992     0.200
    15.529   215.051     0.200
    16.596   228.152     0.200
     0.133     9.006     0.200
     0.277     9.896     0.200
     0.345    10.855     0.200
     0.354    10.955     0.200
     0.440    11.156     0.200
     0.622    13.385     0.200
     0.805    16.816     0.200
     0.892    17.195     0.200
     0.883    15.826     0.200
     1.161    19.875     0.200
     1.210    21.496     0.200
     1.296    22.535     0.200
     1.407    22.986     0.200
     1.578    25.416     0.200
     1.817    29.090     0.200
     2.314    34.615     0.200
     2.750    42.316     0.200
     4.616    67.516     0.200
     4.640    68.816     0.200
     6.823    98.119     0.200
     9.511   131.840     0.200
    10.422   147.365     0.200
    12.534   174.328     0.200
    13.223   183.715     0.200
    14.646   202.016     0.200
     0.167     8.754     0.200
     0.239     9.027     0.200
     0.277     9.984     0.200
     0.277    10.324     0.200
     0.277    10.227     0.200
     0.277    10.074     0.200
     0.392    10.305     0.200
     0.467    11.477     0.200
     0.720    14.305     0.200
     0.835    16.395     0.200
     0.918    18.125     0.200
     0.946    16.156     0.200
     1.133    19.484     0.200
     1.322    22.906     0.200
     1.369    23.566     0.200
     1.392    22.914     0.200
     1.495    24.426     0.200
     1.862    30.035     0.200
     1.863    30.199     0.200
     1.863    30.027     0.200
     2.124    32.957     0.200
     2.233    33.625     0.200
     2.415    38.426     0.200
     2.686    41.426     0.200
     2.686    41.625     0.200
     3.175    47.027     0.200
     4.553    68.125     0.200
     4.553    67.727     0.200
     4.673    69.387     0.200
     4.673    69.824     0.200
     4.673    70.125     0.200
     4.748    68.086     0.200
     4.748    68.625     0.200
     5.440    79.527     0.200
     5.621    81.277     0.200
     5.621    81.926     0.200
     6.830    99.625     0.200
     6.859    98.754     0.200
     6.861    97.926     0.200
     6.861    98.426     0.200
     6.861    98.227     0.200
     6.861    98.703     0.200
     8.023   114.074     0.200
     8.023   114.527     0.200
     8.278   119.625     0.200
     8.278   119.125     0.200
     8.317   116.727     0.200
     8.317   119.324     0.200
     8.317   119.250     0.200
     8.317   116.996     0.200
     8.383   118.566     0.200
     8.383   119.324     0.200
     8.509   119.938     0.200
     8.509   121.527     0.200
     8.585   124.324     0.200
     8.585   123.926     0.200
     8.820   126.227     0.200
     9.514   131.324     0.200
     9.514   131.234     0.200
     9.514   132.625     0.200
     9.640   138.227     0.200
    10.079   141.926     0.200
    10.079   141.414     0.200
    10.079   143.527     0.200
    10.520   148.801     0.200
    10.520   148.527     0.200
    10.989   155.125     0.200
    11.200   154.797     0.200
    11.200   157.125     0.200
    11.272   160.227     0.200
    11.272   159.926     0.200
    11.799   166.926     0.200
    12.287   170.324     0.200
    12.287   170.527     0.200
    12.630   177.375     0.200
    12.615   176.535     0.200
    12.630   177.125     0.200
    12.986   181.727     0.200
    13.288   184.902     0.200
    13.288   185.324     0.200
    13.430   186.727     0.200
    13.502   188.266     0.200
    13.502   189.426     0.200
    13.502   187.980     0.200
    13.510   188.727     0.200
    13.510   190.727     0.200
    13.510   189.527     0.200
    14.495   201.727     0.200
    14.603   201.316     0.200
    14.603   202.426     0.200
    14.603   200.230     0.200
    14.603   200.676     0.200
    14.736   202.766     0.200
    14.736   204.227     0.200
    14.984   209.227     0.200
    14.984   205.727     0.200
    15.559   213.926     0.200
    15.559   215.426     0.200
    16.629   227.727     0.200
    17.668   240.016     0.200
    17.956   244.926     0.200
    19.104   260.727     0.200
     0.690    12.762     0.200
     0.957    17.762     0.200
     1.094    18.859     0.200
     1.163    20.652     0.200
     1.232    21.859     0.200
     1.259    22.289     0.200
     1.295    22.441     0.200
     1.350    23.121     0.200
     1.428    24.859     0.200
     1.428    24.910     0.200
     1.453    24.590     0.200
     1.514    25.711     0.200
     1.534    25.062     0.200
     1.608    27.852     0.200
     1.632    27.840     0.200
     1.666    28.062     0.200
     1.874    31.121     0.200
     1.906    30.992     0.200
     2.091    32.332     0.200
     2.090    33.211     0.200
     2.199    34.242     0.200
     2.228    36.172     0.200
     2.438    37.781     0.200
     2.430    37.250     0.200
     2.525    40.992     0.200
     2.637    41.980     0.200
     2.694    42.281     0.200
     2.759    43.430     0.200
     2.791    44.242     0.200
     2.898    43.629     0.200
     3.166    49.441     0.200
     3.166    49.641     0.200
     3.343    50.500     0.200
     3.517    54.562     0.200
     3.779    56.840     0.200
     4.210    63.199     0.200
     4.210    63.641     0.200
     4.415    64.641     0.200
     4.969    74.641     0.200
     4.969    76.441     0.200
     4.987    73.852     0.200
     4.987    74.941     0.200
     5.488    81.891     0.200
     6.290    92.539     0.200
     6.846   102.801     0.200
     6.848   101.980     0.200
     6.848   102.141     0.200
     6.848   102.941     0.200
     6.848   102.316     0.200
     7.319   106.820     0.200
     7.319   106.770     0.200
     7.319   105.840     0.200
     7.986   117.660     0.200
     7.986   118.242     0.200
     8.093   117.641     0.200
     8.093   118.539     0.200
     8.332   120.340     0.200
     8.332   122.539     0.200
     8.808   126.742     0.200
     9.077   130.242     0.200
    10.396   148.641     0.200
    10.396   145.941     0.200
    10.790   155.441     0.200
    11.958   172.289     0.200
    12.427   175.340     0.200
    12.549   176.141     0.200
    12.758   183.570     0.200
    14.619   203.539     0.200
    14.619   207.039     0.200
    14.767   206.812     0.200
    14.767   205.852     0.200
    14.767   206.223     0.200
    15.177   209.719     0.200
    15.177   210.641     0.200
    15.662   216.160     0.200
    15.662   217.539     0.200
    17.680   243.062     0.200
    17.680   244.539     0.200
    17.680   244.336     0.200
    19.401   266.242     0.200
     0.606    12.629     0.200
     0.667    12.859     0.200
     0.673    13.148     0.200
     0.762    15.020     0.200
     0.853    15.889     0.200
     0.949    17.590     0.200
     1.086    19.340     0.200
     1.141    19.609     0.200
     1.431    25.100     0.200
     2.221    34.100     0.200
     2.909    44.000     0.200
     3.184    50.799     0.200
     3.799    57.000     0.200
     4.208    65.100     0.200
     4.985    75.199     0.200
     6.844    99.518     0.200
     7.296   106.209     0.200
     9.514   136.424     0.200
    11.939   170.197     0.200
    14.777   207.842     0.200
     0.181     9.156     0.200
     0.225     9.506     0.200
     0.295    10.506     0.200
     0.295    10.406     0.200
     0.412    11.326     0.200
     0.426    10.977     0.200
     0.679    14.096     0.200
     0.875    17.045     0.200
     0.864    17.557     0.200
     0.927    16.375     0.200
     1.160    19.926     0.200
     1.270    22.266     0.200
     1.344    23.217     0.200
     1.442    23.887     0.200
     1.546    25.006     0.200
     1.853    29.705     0.200
     1.854    29.730     0.200
     2.283    34.307     0.200
     2.283    34.506     0.200
     2.453    38.807     0.200
     2.730    42.307     0.200
     2.730    42.105     0.200
     3.225    47.906     0.200
     4.596    69.006     0.200
     4.596    68.506     0.200
     4.671    70.006     0.200
     8.261   116.906     0.200
    12.574   173.920     0.200
     0.325    10.827     0.200
     0.304    10.277     0.200
     0.454    11.548     0.200
     0.715    14.628     0.200
     0.726    15.348     0.200
     0.727    14.367     0.200
     0.727    15.348     0.200
     0.900    16.447     0.200
     0.812    15.277     0.200
     1.138    19.527     0.200
     1.044    18.338     0.200
     1.057    18.367     0.200
     1.220    20.518     0.200
     1.393    23.857     0.200
     1.457    24.508     0.200
     1.638    25.348     0.200
     1.463    25.197     0.200
     1.492    25.178     0.200
     1.865    30.447     0.200
     1.756    29.037     0.200
     1.756    29.147     0.200
     1.758    29.122     0.200
     2.107    33.048     0.200
     2.580    38.348     0.200
     2.704    41.048     0.200
     2.704    41.747     0.200
     3.973    59.447     0.200
     3.973    59.848     0.200
     4.432    64.888     0.200
     4.432    65.447     0.200
     5.232    74.327     0.200
     5.232    74.548     0.200
     5.738    83.747     0.200
     6.191    88.468     0.200
     6.191    89.147     0.200
     6.606    95.647     0.200
     6.606    95.348     0.200
     7.402   104.867     0.200
     7.404   104.798     0.200
     7.404   105.647     0.200
     7.404   105.072     0.200
     8.320   119.848     0.200
     8.320   119.747     0.200
     8.733   124.128     0.200
     8.733   126.147     0.200
     8.733   123.798     0.200
     8.733   125.173     0.200
     8.745   125.747     0.200
     8.931   125.518     0.200
     8.931   126.647     0.200
     9.021   126.197     0.200
     9.309   132.848     0.200
     9.618   138.048     0.200
     9.955   137.577     0.200
     9.955   137.147     0.200
     9.956   137.098     0.200
    10.486   149.048     0.200
    10.486   147.247     0.200
    10.688   152.947     0.200
    10.688   153.548     0.200
    10.991   155.848     0.200
    11.721   162.947     0.200
    11.770   162.628     0.200
    11.770   163.548     0.200
    12.172   172.147     0.200
    13.211   184.147     0.200
    13.196   184.667     0.200
    13.211   183.938     0.200
    13.429   188.447     0.200
    13.628   190.548     0.200
    13.815   193.848     0.200
    13.875   191.537     0.200
    13.875   192.048     0.200
    13.875   191.798     0.200
    14.057   193.707     0.200
    14.057   193.098     0.200
    14.079   195.628     0.200
    14.097   195.938     0.200
    14.097   196.048     0.200
    14.430   199.907     0.200
    14.430   198.048     0.200
    15.504   212.617     0.200
    15.504   211.747     0.200
    15.599   215.947     0.200
    15.644   216.348     0.200
    15.644   217.348     0.200
    17.557   236.798     0.200
    17.557   238.048     0.200
    17.557   237.791     0.200
    17.961   246.247     0.200
    19.642   265.447     0.200
    20.185   272.348     0.200
     0.134     8.377     0.200
     0.274     9.236     0.200
     0.295     9.977     0.200
     0.353     9.518     0.200
     0.495    11.676     0.200
     0.729    14.357     0.200
     0.794    15.617     0.200
     0.941    18.666     0.200
     0.937    15.857     0.200
     1.096    18.746     0.200
     1.343    23.277     0.200
     1.364    23.377     0.200
     2.191    33.688     0.200
     2.191    32.688     0.200
     2.374    37.887     0.200
     2.644    41.887     0.200
     3.133    47.086     0.200
     3.133    46.787     0.200
     4.511    67.887     0.200
     0.236     7.533     0.200
     0.343     8.724     0.200
     0.496    11.663     0.200
     0.633    12.804     0.200
     0.613    12.014     0.200
     0.697    13.283     0.200
     0.899    16.554     0.200
     1.038    18.264     0.200
     1.066    18.873     0.200
     1.124    18.523     0.200
     1.165    20.153     0.200
     1.217    20.304     0.200
     1.650    27.408     0.200
     1.771    27.283     0.200
     2.497    37.184     0.200
     2.878    44.384     0.200
     3.426    50.384     0.200
     4.732    69.983     0.200
     6.804    98.833     0.200
    12.323   177.934     0.200
     0.242     9.430     0.200
     0.266     9.711     0.200
     0.493    12.312     0.200
     0.536    12.289     0.200
     0.537    12.680     0.200
     0.644    13.312     0.200
     0.835    16.094     0.200
     0.863    16.234     0.200
     0.983    17.562     0.200
     0.968    16.812     0.200
     1.084    18.820     0.200
     1.029    17.750     0.200
     1.319    22.070     0.200
     1.409    23.023     0.200
     1.462    24.750     0.200
     1.544    25.719     0.200
     1.557    25.859     0.200
     1.572    25.930     0.200
     1.821    27.922     0.200
     1.821    28.125     0.200
     1.823    29.812     0.200
     1.824    29.797     0.200
     2.053    33.023     0.200
     2.297    36.023     0.200
     2.297    35.719     0.200
     2.515    38.250     0.200
     2.764    41.320     0.200
     4.163    63.922     0.200
     4.163    62.523     0.200
     4.550    67.922     0.200
     5.050    71.891     0.200
     7.213   103.984     0.200
     7.214   103.094     0.200
     7.214   103.422     0.200
     8.378   120.375     0.200
     8.641   124.047     0.200
     8.741   123.984     0.200
    13.044   183.086     0.200
    14.246   196.344     0.200
    17.719   240.039     0.200
     0.206     9.523     0.200
     0.201     8.992     0.200
     0.276    10.504     0.200
     0.276    10.672     0.200
     0.424    11.082     0.200
     0.434    11.141     0.200
     0.702    13.844     0.200
     0.888    17.262     0.200
     0.945    16.301     0.200
     1.162    20.141     0.200
     1.293    21.973     0.200
     1.364    23.141     0.200
     1.868    30.551     0.200
     1.869    30.508     0.200
     2.087    32.992     0.200
     2.087    33.230     0.200
     2.723    42.531     0.200
     2.723    42.633     0.200
     3.214    48.332     0.200
     3.214    47.832     0.200
     4.590    68.832     0.200
     4.590    69.332     0.200
     4.684    70.262     0.200
     4.684    69.832     0.200
     4.684    69.934     0.200
     4.684    70.383     0.200
     4.722    67.562     0.200
     4.722    68.281     0.200
     5.414    77.434     0.200
     5.586    81.402     0.200
     5.586    82.082     0.200
     6.839    99.633     0.200
     6.827    97.812     0.200
     6.829    97.832     0.200
     6.829    98.242     0.200
     6.829    98.020     0.200
     7.990   113.820     0.200
     7.990   114.480     0.200
     8.242   117.633     0.200
     8.284   118.203     0.200
     8.284   118.312     0.200
     8.284   117.934     0.200
     8.351   118.691     0.200
     8.351   119.043     0.200
     8.480   120.551     0.200
     8.480   121.684     0.200
     8.597   123.332     0.200
     8.597   124.633     0.200
     8.784   124.832     0.200
     9.042   128.434     0.200
     9.490   131.684     0.200
     9.490   131.172     0.200
     9.490   132.133     0.200
     9.635   138.730     0.200
    10.046   140.633     0.200
    10.502   148.730     0.200
    10.502   147.531     0.200
    10.502   148.531     0.200
    10.997   155.434     0.200
    11.164   155.762     0.200
    11.285   159.832     0.200
    11.769   166.434     0.200
    12.322   172.332     0.200
    12.590   176.355     0.200
    12.575   176.531     0.200
    12.590   176.402     0.200
    12.951   180.633     0.200
    13.251   184.332     0.200
    13.251   184.156     0.200
    13.251   184.434     0.200
    13.410   185.730     0.200
    13.470   188.973     0.200
    13.470   189.730     0.200
    13.470   190.043     0.200
    14.458   201.133     0.200
    15.018   207.242     0.200
    15.018   206.031     0.200
    15.157   207.441     0.200
    15.546   213.832     0.200
    15.546   215.832     0.200
    16.590   228.633     0.200
    17.642   239.973     0.200
     0.721    13.027     0.200
     0.672    12.387     0.200
     1.046    17.496     0.200
     1.048    17.969     0.200
     1.119    18.898     0.200
     1.069    19.867     0.200
     1.300    22.258     0.200
     1.269    22.105     0.200
     1.322    22.328     0.200
     1.406    23.246     0.200
     1.466    23.707     0.200
     1.404    23.738     0.200
     1.469    23.738     0.200
     1.506    26.168     0.200
     1.506    25.168     0.200
     1.506    25.348     0.200
     1.506    25.195     0.200
     1.553    26.008     0.200
     1.623    26.766     0.200
     1.674    27.695     0.200
     1.781    29.508     0.200
     1.853    30.648     0.200
     1.922    30.688     0.200
     1.929    30.926     0.200
     2.009    31.105     0.200
     2.009    32.367     0.200
     2.009    31.348     0.200
     2.009    31.516     0.200
     2.218    34.258     0.200
     2.334    35.617     0.200
     2.318    37.148     0.200
     2.394    35.809     0.200
     2.548    39.738     0.200
     2.633    40.988     0.200
     2.683    41.918     0.200
     2.629    42.438     0.200
     2.864    42.387     0.200
     2.809    44.047     0.200
     3.156    48.566     0.200
     3.156    49.168     0.200
     3.248    48.605     0.200
     3.434    52.637     0.200
     3.771    55.977     0.200
     3.756    55.867     0.200
     3.756    55.566     0.200
     3.953    59.738     0.200
     4.252    62.578     0.200
     4.306    64.547     0.200
     4.306    66.266     0.200
     4.306    65.668     0.200
     4.306    65.469     0.200
     4.306    65.117     0.200
     4.426    66.105     0.200
     4.428    66.738     0.200
     4.522    66.969     0.200
     4.686    70.836     0.200
     4.895    71.605     0.200
     4.895    72.367     0.200
     4.895    71.969     0.200
     4.895    71.719     0.200
     4.973    74.766     0.200
     5.262    79.309     0.200
     5.377    77.898     0.200
     5.431    80.207     0.200
     5.431    80.668     0.200
     5.431    80.566     0.200
     5.905    88.039     0.200
     6.267    92.828     0.200
     6.303    93.219     0.200
     6.393    95.766     0.200
     6.543    94.598     0.200
     6.779    98.719     0.200
     6.780    96.719     0.200
     6.780   100.766     0.200
     6.780   100.238     0.200
     6.780   100.098     0.200
     6.781    99.742     0.200
     7.039   103.938     0.200
     7.066   102.316     0.200
     7.477   106.621     0.200
     7.405   106.195     0.200
     7.405   105.668     0.200
     7.405   106.816     0.200
     7.650   110.227     0.200
     7.922   113.539     0.200
     7.922   114.566     0.200
     7.922   115.918     0.200
     7.959   114.266     0.200
     8.057   112.688     0.200
     8.157   119.309     0.200
     8.194   119.867     0.200
     8.269   117.027     0.200
     8.269   120.066     0.200
     8.269   120.426     0.200
     8.214   116.969     0.200
     8.310   119.508     0.200
     8.522   122.117     0.200
     8.522   120.969     0.200
     8.522   126.668     0.200
     8.824   129.316     0.200
     8.976   130.836     0.200
     9.067   132.469     0.200
     9.164   133.566     0.200
     9.164   129.848     0.200
     9.164   130.867     0.200
     9.241   131.566     0.200
     9.394   135.445     0.200
     9.476   137.816     0.200
     9.533   135.539     0.200
     9.703   134.617     0.200
     9.705   136.117     0.200
     9.705   140.168     0.200
     9.705   135.117     0.200
     9.651   138.117     0.200
     9.828   142.727     0.200
     9.868   141.887     0.200
    10.505   151.266     0.200
    10.581   154.129     0.200
    10.931   158.797     0.200
    10.877   156.367     0.200
    10.891   157.566     0.200
    10.961   153.105     0.200
    10.961   155.469     0.200
    10.961   159.566     0.200
    11.976   172.617     0.200
    11.959   169.277     0.200
    11.976   169.387     0.200
    12.089   173.266     0.200
    12.578   177.367     0.200
    12.578   177.066     0.200
    12.542   178.566     0.200
    12.746   179.566     0.200
    12.823   180.008     0.200
    12.823   179.266     0.200
    12.823   183.688     0.200
    12.894   181.578     0.200
    12.894   180.969     0.200
    12.933   181.809     0.200
    12.933   182.168     0.200
    12.933   182.617     0.200
    12.933   186.566     0.200
    13.414   190.367     0.200
    13.792   194.828     0.200
    14.672   205.457     0.200
    14.739   205.867     0.200
    14.739   208.566     0.200
    14.808   205.469     0.200
    14.808   205.766     0.200
    14.808   206.559     0.200
    14.808   205.668     0.200
    15.215   211.695     0.200
    15.215   212.266     0.200
    15.215   212.969     0.200
    15.215   210.188     0.200
    15.556   213.086     0.200
    15.556   219.266     0.200
    15.556   213.469     0.200
    16.747   230.008     0.200
    16.747   232.566     0.200
    17.766   244.137     0.200
    17.766   246.469     0.200
    17.766   243.387     0.200
    17.766   244.969     0.200
    17.766   244.836     0.200
    18.850   264.070     0.200
    18.990   260.469     0.200
    18.990   263.320     0.200
     0.456    10.211     0.200
     0.677    13.109     0.200
     0.704    13.344     0.200
     0.745    14.922     0.200
     0.997    18.141     0.200
     1.059    18.453     0.200
     1.100    19.602     0.200
     1.100    19.797     0.200
     1.100    19.398     0.200
     1.563    26.820     0.200
     1.952    32.648     0.200
     3.194    49.898     0.200
     3.789    56.102     0.200
     4.362    66.117     0.200
     4.362    66.797     0.200
     4.838    72.828     0.200
     4.838    73.500     0.200
     5.016    75.500     0.200
     5.016    76.102     0.200
     5.377    80.648     0.200
     5.377    81.898     0.200
     6.723    97.820     0.200
     6.725   101.273     0.200
     6.725   100.797     0.200
     6.725   100.727     0.200
     7.867   113.867     0.200
     7.867   116.898     0.200
     8.214   118.594     0.200
     8.214   121.203     0.200
     9.649   136.961     0.200
     9.649   138.102     0.200
    11.925   169.969     0.200
    11.943   169.617     0.200
    12.792   179.609     0.200
    12.858   180.742     0.200
     0.461    10.141     0.200
     0.620    12.891     0.200
     0.816    15.016     0.200
     0.802    16.219     0.200
     1.092    19.266     0.200
     1.092    18.906     0.200
     1.104    18.719     0.200
     1.856    31.258     0.200
     3.272    50.656     0.200
     3.272    50.961     0.200
     3.860    56.859     0.200
     3.860    56.562     0.200
     4.454    65.641     0.200
     4.454    68.062     0.200
     4.454    66.461     0.200
     4.454    65.867     0.200
     4.746    71.117     0.200
     4.746    72.258     0.200
     4.746    72.062     0.200
     5.099    76.758     0.200
     5.281    79.219     0.200
     5.281    80.562     0.200
     6.536    95.461     0.200
     6.615   100.859     0.200
     6.626    97.688     0.200
     6.628    98.531     0.200
     6.628   100.156     0.200
     6.628    98.062     0.200
     6.628    99.648     0.200
     7.388   108.109     0.200
     7.388   109.461     0.200
     7.770   114.297     0.200
     7.770   115.109     0.200
     8.118   119.008     0.200
     8.118   121.156     0.200
     8.118   120.219     0.200
     8.370   122.258     0.200
     8.370   122.570     0.200
     9.553   133.633     0.200
     9.556   133.461     0.200
     9.715   139.508     0.200
    10.814   154.836     0.200
    10.814   156.352     0.200
    12.595   180.062     0.200
    12.719   178.258     0.200
    12.794   178.547     0.200
    12.794   179.906     0.200
    14.953   207.211     0.200
    14.953   207.938     0.200
    14.953   207.234     0.200
    15.359   214.961     0.200
    15.415   217.062     0.200
    15.415   212.297     0.200
    15.415   214.562     0.200
    15.767   220.656     0.200
    16.771   233.961     0.200
    17.917   246.727     0.200
     0.360     9.258     0.200
     0.561    11.758     0.200
     0.599    12.797     0.200
     1.068    18.141     0.200
     1.143    19.953     0.200
     1.205    20.633     0.200
     1.389    23.102     0.200
     4.181    63.688     0.200
     5.018    73.492     0.200
     5.534    81.211     0.200
     6.889    98.180     0.200
     6.891    97.828     0.200
     7.366   106.492     0.200
     8.377   119.391     0.200
    12.016   172.492     0.200
    14.715   206.719     0.200
    14.715   207.062     0.200
    17.645   242.047     0.200
     0.309     7.367     0.200
     0.396     9.836     0.200
     0.480    10.539     0.200
     0.655    12.398     0.200
     0.693    14.086     0.200
     0.727    13.367     0.200
     0.718    13.508     0.200
     0.822    16.484     0.200
     1.042    17.703     0.200
     1.050    19.539     0.200
     1.066    18.633     0.200
     1.127    19.375     0.200
     1.486    25.727     0.200
     1.486    25.719     0.200
     5.450    79.906     0.200
     6.800    99.242     0.200
     8.289   121.078     0.200
    17.745   243.797     0.200
     0.403     9.820     0.200
     0.631    12.367     0.200
     0.685    14.000     0.200
     0.738    14.039     0.200
     0.800    16.219     0.200
     1.127    18.820     0.200
     1.463    25.383     0.200
     2.052    32.508     0.200
     2.052    33.578     0.200
     3.121    47.680     0.200
     3.724    54.680     0.200
     4.265    62.688     0.200
     4.265    65.383     0.200
     4.265    64.781     0.200
     4.937    73.172     0.200
     4.937    73.477     0.200
     4.936    73.281     0.200
     5.474    79.711     0.200
     6.822    98.312     0.200
     6.824    97.930     0.200
     6.824   100.906     0.200
     7.414   107.172     0.200
     7.414   107.938     0.200
     7.414   107.719     0.200
     7.966   115.289     0.200
     8.313   121.438     0.200
     8.566   125.383     0.200
     9.744   137.906     0.200
     9.747   137.570     0.200
    12.009   173.953     0.200
    11.991   168.969     0.200
    12.009   169.156     0.200
    12.928   180.602     0.200
    12.974   181.672     0.200
     0.370     9.578     0.200
     0.501    10.867     0.200
     0.679    12.531     0.200
     0.688    13.328     0.200
     0.680    13.906     0.200
     0.749    13.656     0.200
     0.833    16.344     0.200
     1.045    18.531     0.200
     1.071    18.031     0.200
     1.050    19.492     0.200
     1.148    20.203     0.200
     1.148    19.875     0.200
     1.499    25.602     0.200
     1.499    25.414     0.200
     2.016    31.633     0.200
     4.906    71.836     0.200
     0.400     9.914     0.200
     0.470    10.430     0.200
     0.674    12.625     0.200
     0.706    13.414     0.200
     0.709    14.352     0.200
     0.845    16.734     0.200
     1.046    18.359     0.200
     1.045    17.867     0.200
     1.117    19.867     0.200
     1.509    24.688     0.200
     2.006    31.969     0.200
     2.006    32.711     0.200
     3.156    50.055     0.200
     3.156    50.258     0.200
     3.756    55.859     0.200
     4.309    63.859     0.200
     4.309    66.258     0.200
     4.309    65.758     0.200
     4.525    67.758     0.200
     4.892    71.945     0.200
     4.892    72.758     0.200
     4.974    76.555     0.200
     5.429    80.734     0.200
     5.429    81.258     0.200
     5.429    81.359     0.200
     6.776    98.688     0.200
     6.778    98.688     0.200
     6.778   101.258     0.200
     6.778    99.156     0.200
     6.778   102.117     0.200
     6.778   100.312     0.200
     7.407   106.125     0.200
     7.407   107.156     0.200
     7.407   106.664     0.200
     7.920   114.820     0.200
     7.920   117.055     0.200
     8.197   120.055     0.200
     8.267   118.367     0.200
     8.267   122.758     0.200
     8.520   125.156     0.200
     9.654   138.930     0.200
     9.700   135.109     0.200
     9.703   136.711     0.200
     9.703   138.359     0.200
    10.879   159.156     0.200
    10.959   158.359     0.200
    11.976   169.609     0.200
    11.958   167.586     0.200
    11.976   170.680     0.200
    12.545   177.961     0.200
    12.580   178.156     0.200
    14.742   204.859     0.200
    14.809   204.602     0.200
    14.809   204.984     0.200
    14.809   208.305     0.200
    15.553   216.758     0.200
    18.851   259.055     0.200
    19.357   263.281     0.200
    20.707   280.961     0.200
     0.336     7.586     0.200
     0.453     9.969     0.200
     0.413    10.039     0.200
     0.701    12.789     0.200
     0.704    12.750     0.200
     0.692    13.109     0.200
     0.738    14.602     0.200
     0.882    17.031     0.200
     1.047    17.531     0.200
     1.016    17.836     0.200
     1.098    19.148     0.200
     1.098    18.789     0.200
     1.108    20.180     0.200
     1.280    22.289     0.200
     1.401    23.867     0.200
     1.545    26.125     0.200
     1.970    31.750     0.200
     4.855    71.352     0.200
     6.743    99.445     0.200
     6.743   100.445     0.200
     7.413   106.758     0.200
     0.364     8.242     0.200
     0.444    10.094     0.200
     0.423    10.242     0.200
     0.692    12.883     0.200
     0.672    13.086     0.200
     0.741    13.492     0.200
     0.767    15.117     0.200
     0.924    17.812     0.200
     0.979    17.633     0.200
     1.059    18.023     0.200
     1.086    18.328     0.200
     1.086    18.883     0.200
     1.146    20.633     0.200
     1.254    22.227     0.200
     1.388    23.328     0.200
     1.435    23.594     0.200
     1.401    23.492     0.200
     1.587    26.656     0.200
     1.587    26.688     0.200
     1.928    30.562     0.200
     3.206    49.234     0.200
     3.798    55.836     0.200
     4.387    65.578     0.200
     4.387    66.039     0.200
     4.813    70.836     0.200
     5.029    74.234     0.200
     5.029    73.633     0.200
     5.355    76.617     0.200
     6.700    94.734     0.200
     6.702    94.930     0.200
     6.702    98.930     0.200
     7.413   108.273     0.200
     7.413   108.102     0.200
     7.844   111.398     0.200
     9.621   132.836     0.200
     9.700   138.078     0.200
    11.934   171.555     0.200
    12.645   178.133     0.200
    14.796   209.734     0.200
    15.285   211.133     0.200
     0.402     9.812     0.200
     0.471    10.641     0.200
     0.663    12.734     0.200
     0.719    13.523     0.200
     0.715    13.570     0.200
     0.704    14.375     0.200
     0.834    16.812     0.200
     1.039    17.961     0.200
     1.058    18.484     0.200
     1.118    19.961     0.200
     1.118    19.664     0.200
     1.063    19.742     0.200
     1.497    25.977     0.200
     1.497    26.211     0.200
     1.497    26.023     0.200
     2.018    32.594     0.200
     2.018    32.820     0.200
     3.147    48.523     0.200
     3.147    49.922     0.200
     3.747    55.820     0.200
     3.747    55.625     0.200
     4.298    64.875     0.200
     4.298    66.320     0.200
     4.525    67.523     0.200
     4.903    72.797     0.200
     4.903    73.227     0.200
     4.964    74.023     0.200
     4.964    77.125     0.200
     5.440    80.406     0.200
     5.440    81.320     0.200
     6.788    98.555     0.200
     6.790    98.906     0.200
     6.790   101.125     0.200
     6.790   100.922     0.200
     6.790   100.125     0.200
     7.410   105.922     0.200
     7.410   105.891     0.200
     7.410   107.445     0.200
     7.931   115.023     0.200
     8.187   116.625     0.200
     8.220   116.523     0.200
     8.279   119.617     0.200
     9.169   133.320     0.200
     9.651   138.672     0.200
    10.881   154.727     0.200
    11.985   172.570     0.200
    11.986   169.766     0.200
    14.738   209.227     0.200
    14.798   207.664     0.200
    14.798   206.148     0.200
    17.757   244.664     0.200
    20.201   275.727     0.200
     0.456    10.227     0.200
     0.411     9.820     0.200
     0.687    12.734     0.200
     0.703    13.508     0.200
     0.728    14.547     0.200
     1.041    17.945     0.200
     1.032    18.445     0.200
     1.528    25.961     0.200
     1.528    26.016     0.200
     1.987    31.930     0.200
     5.412    80.539     0.200
     6.758    99.227     0.200
     6.760    99.070     0.200
     9.682   138.188     0.200
     0.302     7.602     0.200
     0.419    10.172     0.200
     0.452    10.352     0.200
     0.663    12.609     0.200
     0.700    13.148     0.200
     0.723    14.461     0.200
     0.724    13.508     0.200
     1.025    17.617     0.200
     1.057    18.297     0.200
     1.078    19.828     0.200
     1.099    18.750     0.200
     1.099    19.594     0.200
     1.099    18.688     0.200
     1.289    22.484     0.200
     1.316    22.680     0.200
     1.319    22.562     0.200
     1.387    23.062     0.200
     1.425    24.023     0.200
     1.469    24.023     0.200
     1.506    25.742     0.200
     1.506    25.492     0.200
     1.506    25.641     0.200
     1.506    25.523     0.200
     1.572    26.531     0.200
     1.633    27.234     0.200
     1.667    27.523     0.200
     1.791    29.633     0.200
     1.865    30.398     0.200
     1.911    30.617     0.200
     1.946    31.367     0.200
     2.010    31.750     0.200
     2.010    32.391     0.200
     2.010    32.094     0.200
     2.010    31.938     0.200
     2.026    30.891     0.200
     2.320    37.422     0.200
     2.330    35.734     0.200
     2.375    35.711     0.200
     2.618    40.922     0.200
     2.685    41.953     0.200
     2.846    42.344     0.200
     3.141    49.289     0.200
     3.141    49.688     0.200
     3.245    48.984     0.200
     3.434    52.711     0.200
     3.739    55.492     0.200
     3.768    55.898     0.200
     3.953    59.734     0.200
     4.248    62.391     0.200
     4.310    64.273     0.200
     4.310    66.492     0.200
     4.310    66.789     0.200
     4.310    65.391     0.200
     4.310    65.492     0.200
     4.424    66.023     0.200
     4.430    67.039     0.200
     4.543    66.992     0.200
     4.686    71.141     0.200
     4.893    71.578     0.200
     4.893    72.688     0.200
     4.893    72.094     0.200
     4.893    71.711     0.200
     4.893    72.242     0.200
     4.960    74.094     0.200
     4.960    75.391     0.200
     5.264    78.711     0.200
     5.374    77.992     0.200
     5.436    80.758     0.200
     5.436    80.992     0.200
     5.436    81.094     0.200
     5.907    87.914     0.200
     6.183    91.188     0.200
     6.268    92.539     0.200
     6.309    93.328     0.200
     6.400    94.789     0.200
     6.400    95.492     0.200
     6.543    94.938     0.200
     6.782    99.773     0.200
     6.784    99.867     0.200
     6.784   100.789     0.200
     6.784   100.688     0.200
     6.784   100.492     0.200
     6.784   100.594     0.200
     7.044   104.023     0.200
     7.067   102.547     0.200
     7.427   106.742     0.200
     7.426   107.141     0.200
     7.740   113.969     0.200
     7.926   116.031     0.200
     7.926   116.891     0.200
     7.926   116.492     0.200
     7.926   116.688     0.200
     7.980   112.789     0.200
     8.149   117.508     0.200
     8.162   119.617     0.200
     8.200   119.688     0.200
     8.234   116.289     0.200
     8.274   120.367     0.200
     8.274   120.688     0.200
     8.274   120.953     0.200
     8.310   116.234     0.200
     8.524   122.758     0.200
     8.524   124.094     0.200
     8.943   128.188     0.200
     9.063   130.641     0.200
     9.075   132.969     0.200
     9.186   131.789     0.200
     9.186   131.914     0.200
     9.186   132.992     0.200
     9.282   135.922     0.200
     9.400   135.797     0.200
     9.484   138.102     0.200
     9.537   136.242     0.200
     9.670   138.664     0.200
     9.670   137.594     0.200
     9.700   134.641     0.200
     9.703   135.344     0.200
     9.703   138.594     0.200
     9.836   143.102     0.200
     9.875   143.523     0.200
    10.234   145.039     0.200
    10.513   150.789     0.200
    10.592   154.664     0.200
    10.896   155.891     0.200
    10.896   152.992     0.200
    10.898   153.688     0.200
    10.941   159.539     0.200
    10.968   156.453     0.200
    10.968   157.289     0.200
    10.968   157.391     0.200
    10.968   156.203     0.200
    11.557   167.070     0.200
    11.993   171.492     0.200
    11.993   169.531     0.200
    12.562   176.789     0.200
    12.568   178.891     0.200
    12.568   175.992     0.200
    12.759   180.992     0.200
    12.759   179.992     0.200
    12.759   181.500     0.200
    12.841   180.617     0.200
    12.841   180.750     0.200
    12.910   183.234     0.200
    12.910   182.492     0.200
    12.910   183.594     0.200
    12.910   185.031     0.200
    12.943   182.703     0.200
    14.757   207.594     0.200
    14.800   206.258     0.200
    14.800   206.492     0.200
    14.800   205.391     0.200
    15.206   212.367     0.200
    15.206   213.289     0.200
    15.206   212.594     0.200
    15.206   211.594     0.200
    15.549   213.164     0.200
    15.549   213.633     0.200
    15.549   215.891     0.200
    16.768   231.523     0.200
    17.767   244.211     0.200
    17.767   243.711     0.200
    18.995   259.992     0.200
    19.535   265.391     0.200
     0.365     8.070     0.200
     0.418    10.070     0.200
     0.697    12.781     0.200
     0.670    12.992     0.200
     0.739    13.312     0.200
     0.761    14.898     0.200
     0.919    17.602     0.200
     0.980    17.602     0.200
     1.062    17.844     0.200
     1.091    18.859     0.200
     1.091    18.922     0.200
     1.141    20.648     0.200
     1.253    22.141     0.200
     1.397    23.367     0.200
     1.437    23.664     0.200
     1.518    24.484     0.200
     1.583    26.562     0.200
     1.583    26.320     0.200
     1.932    30.688     0.200
     4.818    70.062     0.200
     0.372     9.227     0.200
     0.590    11.438     0.200
     0.611    12.758     0.200
     0.755    14.141     0.200
     0.725    14.828     0.200
     0.951    17.977     0.200
     1.144    19.703     0.200
     1.213    21.586     0.200
     1.391    24.383     0.200
     1.391    23.570     0.200
     1.391    24.359     0.200
     2.124    32.656     0.200
     3.100    46.656     0.200
     3.713    54.859     0.200
     3.713    55.062     0.200
     4.186    62.016     0.200
     4.906    71.562     0.200
     5.014    72.711     0.200
     5.535    80.070     0.200
     6.888    98.438     0.200
     6.890   101.445     0.200
     7.379   106.367     0.200
     7.379   105.258     0.200
     9.568   137.234     0.200
     0.357     8.234     0.200
     0.447    10.125     0.200
     0.419    10.289     0.200
     0.695    12.938     0.200
     0.677    13.156     0.200
     0.731    13.453     0.200
     0.758    15.023     0.200
     0.912    17.797     0.200
     0.989    17.734     0.200
     1.056    18.023     0.200
     1.090    18.836     0.200
     1.090    18.969     0.200
     1.135    20.516     0.200
     1.261    22.297     0.200
     1.389    23.469     0.200
     1.430    23.836     0.200
     1.399    23.469     0.200
     1.575    26.781     0.200
     1.575    26.500     0.200
     1.940    31.188     0.200
     4.826    70.500     0.200
     5.367    79.234     0.200
     6.712    97.500     0.200
     6.714   100.086     0.200
     7.412   108.984     0.200
     9.693   139.281     0.200
    11.941   171.680     0.200
     0.033     6.109     0.200
     0.333     7.836     0.200
     0.453    10.180     0.200
     0.412    10.273     0.200
     0.702    12.914     0.200
     0.700    13.188     0.200
     0.695    13.430     0.200
     0.736    14.758     0.200
     0.878    17.125     0.200
     1.020    18.086     0.200
     1.045    17.727     0.200
     1.099    18.547     0.200
     1.099    18.805     0.200
     1.105    20.664     0.200
     1.541    26.188     0.200
     1.541    26.055     0.200
     1.974    31.234     0.200
     4.859    71.062     0.200
     5.399    78.086     0.200
     6.747    97.867     0.200
     7.414   105.492     0.200
     0.046     6.125     0.200
     0.341     7.797     0.200
     0.390    10.062     0.200
     0.477    10.445     0.200
     0.697    12.852     0.200
     0.725    13.195     0.200
     0.685    13.305     0.200
     0.712    14.453     0.200
     0.864    16.852     0.200
     1.062    17.766     0.200
     1.023    18.102     0.200
     1.123    19.797     0.200
     1.123    19.773     0.200
     1.084    20.336     0.200
     1.277    22.438     0.200
     1.346    22.695     0.200
     1.528    25.953     0.200
     1.528    25.648     0.200
     1.986    32.164     0.200
     4.874    71.266     0.200
     5.407    80.062     0.200
     6.757    97.273     0.200
     0.367     9.352     0.200
     0.554    11.344     0.200
     0.592    11.336     0.200
     0.606    12.844     0.200
     0.752    14.047     0.200
     0.723    14.805     0.200
     0.797    14.633     0.200
     0.947    17.852     0.200
     1.061    17.883     0.200
     1.144    19.680     0.200
     1.197    20.977     0.200
     1.213    21.500     0.200
     1.389    24.102     0.200
     1.389    23.820     0.200
     1.390    23.836     0.200
     2.125    33.750     0.200
     3.103    48.023     0.200
     3.716    54.820     0.200
     4.183    63.523     0.200
     4.908    74.922     0.200
     5.016    74.000     0.200
     6.889    98.633     0.200
     6.891    99.289     0.200
     7.373   105.391     0.200
     7.373   106.445     0.200
     7.373   105.805     0.200
     9.562   136.234     0.200
    12.021   170.477     0.200
     0.367     8.070     0.200
     0.451     9.930     0.200
     0.416    10.086     0.200
     0.698    12.742     0.200
     0.667    12.961     0.200
     0.742    13.523     0.200
     0.761    14.961     0.200
     0.921    17.711     0.200
     0.978    17.656     0.200
     1.064    17.883     0.200
     1.093    18.305     0.200
     1.093    18.867     0.200
     1.142    20.477     0.200
     1.250    22.094     0.200
     1.585    26.922     0.200
     1.585    26.680     0.200
     1.930    30.422     0.200
     4.816    70.586     0.200
     0.384     9.749     0.200
     0.487    10.659     0.200
     0.671    12.519     0.200
     0.735    13.589     0.200
     0.700    13.389     0.200
     1.057    17.919     0.200
     1.050    18.459     0.200
     1.134    19.689     0.200
     1.498    25.529     0.200
     1.498    25.039     0.200
     2.017    32.469     0.200
     4.905    72.339     0.200
     5.435    80.469     0.200
     6.784    98.759     0.200
     6.787    96.179     0.200
    14.805   205.367     0.200
     0.365     9.478     0.200
     0.505    10.817     0.200
     0.681    12.768     0.200
     0.685    13.058     0.200
     0.676    13.788     0.200
     0.753    13.627     0.200
     0.833    16.598     0.200
     1.043    18.118     0.200
     1.075    18.127     0.200
     1.048    19.397     0.200
     1.152    20.018     0.200
     1.499    25.567     0.200
     2.016    32.618     0.200
     4.907    72.718     0.200
     6.783    99.643     0.200
     8.973   126.317     0.200
     0.451    10.209     0.200
     0.417     9.868     0.200
     0.664    12.889     0.200
     0.747    14.019     0.200
     0.763    15.049     0.200
     1.067    18.479     0.200
     1.145    20.599     0.200
     1.589    27.184     0.200
     7.405   108.862     0.200
     0.696    12.896     0.200
     1.069    18.297     0.200
     1.089    19.047     0.200
     1.089    18.926     0.200
     1.156    20.615     0.200
     1.240    22.076     0.200
     1.600    27.301     0.200
     1.601    27.195     0.200
     1.914    31.826     0.200
     3.220    48.676     0.200
     3.220    47.977     0.200
     3.812    56.275     0.200
     4.400    67.396     0.200
     4.400    67.775     0.200
     4.801    72.957     0.200
     5.044    75.076     0.200
     5.044    76.576     0.200
     5.340    79.916     0.200
     6.686    99.406     0.200
     6.687    99.266     0.200
     6.688    97.514     0.200
     7.405   106.641     0.200
     9.700   138.326     0.200
     9.700   138.676     0.200
    10.887   158.676     0.200
    11.920   169.137     0.200
    11.903   170.227     0.200
    12.585   178.775     0.200
    14.798   207.377     0.200
     0.606    11.514     0.200
     0.616    12.865     0.200
     0.740    13.705     0.200
     0.790    14.334     0.200
     0.963    18.135     0.200
     1.063    17.734     0.200
     1.127    19.264     0.200
     1.190    20.434     0.200
     1.190    20.795     0.200
     1.230    21.344     0.200
     1.407    24.189     0.200
     1.407    24.094     0.200
     2.108    33.725     0.200
     4.999    72.994     0.200
     5.518    80.725     0.200
     6.871    99.504     0.200
     6.873    99.775     0.200
     6.874   101.262     0.200
     7.372   109.088     0.200
    12.010   170.629     0.200
     0.487    10.645     0.200
     0.384     9.324     0.200
     0.673    12.514     0.200
     0.735    13.475     0.200
     0.699    13.104     0.200
     1.057    17.984     0.200
     1.049    18.184     0.200
     1.134    19.613     0.200
     1.134    19.465     0.200
     1.500    25.545     0.200
     1.500    25.564     0.200
     2.015    31.814     0.200
     3.161    48.244     0.200
     3.763    56.045     0.200
     4.297    64.773     0.200
     4.297    65.244     0.200
     4.297    65.844     0.200
     4.508    66.744     0.200
     4.903    72.395     0.200
     4.977    74.045     0.200
     5.433    81.084     0.200
     6.783    99.033     0.200
     6.784   100.504     0.200
     6.785   101.045     0.200
     7.392   107.869     0.200
     7.926   115.125     0.200
     8.273   119.295     0.200
     9.710   135.193     0.200
    11.970   173.494     0.200
    14.807   207.164     0.200
    14.807   206.020     0.200
    15.566   214.484     0.200
     0.180     7.102     0.200
     0.732    13.820     0.200
     0.767    15.820     0.200
     0.832    14.539     0.200
     1.037    18.941     0.200
     1.166    20.020     0.200
     1.420    25.004     0.200
     1.420    24.711     0.200
     2.102    33.230     0.200
     4.236    63.840     0.200
     4.236    65.031     0.200
     4.973    73.629     0.200
     4.973    74.230     0.200
     5.540    80.961     0.200
     5.540    82.730     0.200
     6.880   101.219     0.200
     6.882   102.504     0.200
     7.500   110.430     0.200
     8.026   118.031     0.200
     8.374   118.031     0.200
     8.374   123.531     0.200
     9.782   136.070     0.200
     9.782   139.031     0.200
    12.103   174.230     0.200
     0.455    10.117     0.200
     0.412     9.859     0.200
     0.739    13.656     0.200
     1.066    18.367     0.200
     1.136    20.469     0.200
     1.580    26.852     0.200
     3.208    49.430     0.200
     3.802    56.227     0.200
     4.379    66.625     0.200
     5.031    75.227     0.200
     7.403   107.008     0.200
     0.372     9.461     0.200
     0.509    10.727     0.200
     0.650    12.070     0.200
     0.710    13.406     0.200
     0.756    13.891     0.200
     0.662    13.461     0.200
     0.802    15.852     0.200
     1.075    18.750     0.200
     1.061    17.930     0.200
     1.023    18.883     0.200
     1.155    19.867     0.200
     1.467    24.914     0.200
     3.147    47.938     0.200
     3.752    55.539     0.200
     4.263    64.836     0.200
     4.959    75.336     0.200
     6.815   101.789     0.200
     9.744   134.992     0.200
     0.364     8.297     0.200
     0.446    10.031     0.200
     0.420    10.156     0.200
     0.672    13.078     0.200
     0.695    12.852     0.200
     0.739    13.508     0.200
     0.763    15.047     0.200
     0.981    17.523     0.200
     1.089    19.227     0.200
     1.089    18.445     0.200
     1.089    18.516     0.200
     1.060    18.047     0.200
     1.142    20.625     0.200
     1.254    22.125     0.200
     1.583    27.078     0.200
     1.584    26.766     0.200
     1.584    27.125     0.200
     1.932    30.836     0.200
     1.932    31.125     0.200
     3.205    48.922     0.200
     3.798    56.023     0.200
     4.384    66.008     0.200
     4.384    67.328     0.200
     4.384    67.023     0.200
     4.817    70.625     0.200
     4.817    71.422     0.200
     5.028    74.727     0.200
     5.358    79.844     0.200
     5.358    80.422     0.200
     6.703    97.422     0.200
     6.705    98.031     0.200
     6.705    99.023     0.200
     6.705    98.773     0.200
     7.410   106.500     0.200
     9.627   133.555     0.200
     9.627   136.625     0.200
     9.696   139.227     0.200
    11.934   167.867     0.200
     0.447     9.969     0.200
     0.423    10.000     0.200
     0.660    12.820     0.200
     0.757    13.297     0.200
     0.774    14.797     0.200
     0.938    17.648     0.200
     0.963    17.320     0.200
     1.068    17.891     0.200
     1.087    18.617     0.200
     1.087    18.609     0.200
     1.158    20.297     0.200
     1.241    21.906     0.200
     1.416    23.375     0.200
     1.602    26.781     0.200
     1.602    26.117     0.200
     1.602    26.805     0.200
     1.913    30.555     0.200
     3.220    47.805     0.200
     3.220    47.508     0.200
     3.811    55.711     0.200
     3.811    55.609     0.200
     4.401    66.609     0.200
     4.554    67.609     0.200
     4.799    70.781     0.200
     5.044    73.109     0.200
     5.044    77.406     0.200
     5.339    79.375     0.200
     6.685    97.984     0.200
     6.686    97.289     0.200
     6.687    99.727     0.200
     7.407   105.648     0.200
     7.407   108.906     0.200
     7.829   113.664     0.200
     9.703   138.680     0.200
     9.703   137.609     0.200
     9.703   139.211     0.200
    11.921   171.406     0.200
    14.800   209.305     0.200
    14.895   208.805     0.200
    20.787   280.805     0.200
     0.380     9.447     0.200
     0.499    10.856     0.200
     0.714    13.257     0.200
     0.650    12.577     0.200
     0.672    13.747     0.200
     0.807    16.316     0.200
     1.074    18.537     0.200
     1.031    19.066     0.200
     1.093    18.627     0.200
     1.146    19.967     0.200
     1.146    19.787     0.200
     1.472    25.481     0.200
     1.472    25.327     0.200
     1.472    25.507     0.200
     2.043    32.117     0.200
     2.043    32.907     0.200
     2.043    33.606     0.200
     3.144    47.707     0.200
     3.144    48.606     0.200
     3.748    55.707     0.200
     4.269    62.747     0.200
     4.269    65.007     0.200
     4.269    65.257     0.200
     4.498    64.807     0.200
     4.931    72.816     0.200
     4.931    73.007     0.200
     4.931    73.457     0.200
     4.957    73.507     0.200
     4.957    75.207     0.200
     5.460    81.497     0.200
     5.460    81.606     0.200
     5.460    82.007     0.200
     6.810    99.377     0.200
     6.812    99.737     0.200
     6.812   102.106     0.200
     6.812   101.707     0.200
     6.812   100.494     0.200
     7.391   105.407     0.200
     7.391   106.507     0.200
     7.391   105.737     0.200
     7.391   106.582     0.200
     7.953   114.896     0.200
     7.953   117.807     0.200
     7.953   116.047     0.200
     8.157   119.507     0.200
     8.157   119.707     0.200
     8.300   119.657     0.200
     8.300   120.707     0.200
     8.300   122.217     0.200
     9.621   137.532     0.200
     9.741   137.837     0.200
    10.859   157.707     0.200
    11.986   171.775     0.200
    11.986   169.797     0.200
    12.514   176.606     0.200
    12.956   182.356     0.200
    14.706   206.106     0.200
    14.706   208.106     0.200
    14.782   205.587     0.200
    14.782   207.407     0.200
    14.782   205.367     0.200
    14.782   206.416     0.200
     0.394     9.812     0.200
     0.618    11.715     0.200
     0.744    13.805     0.200
     0.742    13.902     0.200
     1.105    19.203     0.200
     1.144    19.625     0.200
     1.144    19.766     0.200
     1.144    20.453     0.200
     1.260    21.832     0.200
     1.443    24.730     0.200
     1.443    24.176     0.200
     1.443    24.754     0.200
     2.072    33.043     0.200
     3.114    47.953     0.200
     3.720    55.055     0.200
     3.720    54.953     0.200
     4.243    63.516     0.200
     4.243    64.555     0.200
     4.243    64.793     0.200
     4.503    65.652     0.200
     4.927    73.652     0.200
     4.927    74.855     0.200
     4.958    73.145     0.200
     4.958    70.305     0.200
     5.491    81.414     0.200
     5.491    82.953     0.200
     5.491    82.754     0.200
     6.841   101.695     0.200
     6.842   101.254     0.200
     6.842   102.254     0.200
     6.842   101.613     0.200
     6.843   101.191     0.200
     7.405   106.828     0.200
     7.405   106.676     0.200
     7.984   117.363     0.200
     7.984   118.254     0.200
     8.132   119.555     0.200
     8.226   117.855     0.200
     8.331   120.535     0.200
     8.331   121.254     0.200
     9.619   137.180     0.200
     9.619   137.855     0.200
     9.768   136.785     0.200
     9.768   135.953     0.200
    10.870   158.652     0.200
    12.014   171.668     0.200
    12.514   175.953     0.200
    14.700   206.152     0.200
    14.700   207.754     0.200
    14.750   206.516     0.200
    15.617   214.742     0.200
    17.702   243.492     0.200
     0.394     9.766     0.200
     0.474    10.406     0.200
     0.683    12.676     0.200
     0.722    13.254     0.200
     0.697    13.336     0.200
     0.708    14.355     0.200
     0.851    16.797     0.200
     1.053    17.844     0.200
     1.038    18.227     0.200
     1.121    19.715     0.200
     1.120    19.816     0.200
     1.120    19.406     0.200
     1.515    25.941     0.200
     3.166    49.117     0.200
     3.765    55.715     0.200
     4.314    65.617     0.200
     4.886    72.816     0.200
     4.983    73.215     0.200
     5.420    83.316     0.200
     6.770   101.215     0.200
     6.771    97.816     0.200
     7.400   106.914     0.200
     9.652   137.867     0.200
    11.967   169.766     0.200
    14.818   206.754     0.200
     0.374     9.438     0.200
     0.499    10.719     0.200
     0.697    13.250     0.200
     0.670    12.609     0.200
     0.747    13.699     0.200
     0.679    13.828     0.200
     0.826    16.379     0.200
     1.053    18.320     0.200
     1.065    18.008     0.200
     1.046    19.211     0.200
     1.145    20.340     0.200
     1.145    19.910     0.200
     1.146    20.219     0.200
     1.146    20.340     0.200
     1.492    25.715     0.200
     1.492    24.559     0.200
     1.492    25.738     0.200
     2.023    32.348     0.200
     3.162    48.141     0.200
     3.765    55.539     0.200
     3.765    55.641     0.200
     4.287    64.039     0.200
     4.287    65.438     0.200
     4.912    72.711     0.200
     4.912    73.238     0.200
     4.977    73.238     0.200
     4.977    74.938     0.200
     5.439    79.328     0.200
     5.439    82.438     0.200
     6.789    99.828     0.200
     6.791    99.660     0.200
     6.791    99.938     0.200
     6.791   101.438     0.200
     6.792   100.965     0.200
     7.383   105.168     0.200
     7.383   104.820     0.200
     7.383   106.738     0.200
     7.932   112.438     0.200
     8.279   120.438     0.200
     9.720   135.766     0.200
     9.624   137.863     0.200
     9.723   138.551     0.200
     9.723   136.738     0.200
    11.968   170.996     0.200
    11.968   173.641     0.200
    14.712   206.641     0.200
    14.712   209.039     0.200
    17.750   245.570     0.200
     0.388     9.484     0.200
     0.524    10.754     0.200
     0.592    11.223     0.200
     0.636    13.062     0.200
     0.767    14.094     0.200
     0.759    13.992     0.200
     1.039    17.531     0.200
     1.167    20.141     0.200
     1.137    19.484     0.200
     1.225    21.273     0.200
     1.405    24.211     0.200
     3.096    48.211     0.200
     3.706    55.012     0.200
     4.905    73.113     0.200
     6.878   101.664     0.200
     7.397   106.242     0.200
    12.030   171.918     0.200
     0.399     9.602     0.200
     0.484    10.453     0.200
     0.636    12.023     0.200
     0.730    13.633     0.200
     0.683    13.797     0.200
     0.732    13.695     0.200
     0.803    16.055     0.200
     1.034    17.578     0.200
     1.034    19.242     0.200
     1.086    19.023     0.200
     1.130    19.984     0.200
     1.466    25.352     0.200
     3.126    47.922     0.200
     3.730    55.523     0.200
     4.267    63.125     0.200
     4.941    73.227     0.200
     6.820   101.016     0.200
     7.409   109.914     0.200
     9.635   141.094     0.200
    12.003   173.297     0.200
    17.726   241.828     0.200
     0.468    10.286     0.200
     0.399     9.766     0.200
     0.717    13.176     0.200
     0.687    12.786     0.200
     0.697    13.326     0.200
     0.716    14.406     0.200
     0.858    16.876     0.200
     1.033    18.216     0.200
     1.050    17.836     0.200
     1.114    19.286     0.200
     1.115    19.326     0.200
     1.083    19.836     0.200
     1.522    25.956     0.200
     1.993    31.966     0.200
     4.879    71.756     0.200
     1.196    20.246     0.200
     2.133    34.188     0.200
     2.133    34.777     0.200
     2.133    34.527     0.200
     4.207    64.387     0.200
     4.207    64.777     0.200
     4.207    65.027     0.200
     4.585    66.176     0.200
     4.821    74.477     0.200
     5.003    73.887     0.200
     5.003    74.477     0.200
     5.003    74.727     0.200
     5.571    82.387     0.200
     5.571    83.078     0.200
     5.571    83.379     0.200
     6.911   102.789     0.200
     6.913   102.039     0.200
     6.913   102.777     0.200
     6.913   102.566     0.200
     7.507   105.766     0.200
     7.507   107.301     0.200
     8.082   114.477     0.200
     8.057   115.516     0.200
     8.057   118.777     0.200
     8.057   118.328     0.200
     8.104   118.578     0.200
     8.336   116.777     0.200
     8.336   117.379     0.200
     8.648   124.496     0.200
     8.648   126.277     0.200
     8.903   127.777     0.200
     9.264   132.277     0.200
     9.264   131.039     0.200
     9.680   137.879     0.200
     9.680   136.676     0.200
     9.810   136.578     0.200
     9.812   136.297     0.200
     9.812   139.578     0.200
    10.966   156.777     0.200
    12.126   173.777     0.200
    12.126   170.148     0.200
    12.429   176.578     0.200
    12.429   175.477     0.200
    12.581   176.379     0.200
    12.899   184.879     0.200
    13.083   183.238     0.200
    14.662   206.348     0.200
    14.662   207.078     0.200
    14.662   206.297     0.200
    15.067   211.379     0.200
    15.067   212.176     0.200
    15.639   216.977     0.200
    16.814   233.469     0.200
    19.128   263.176     0.200
    19.504   267.977     0.200
     0.393     9.633     0.200
     0.476    10.477     0.200
     0.679    12.656     0.200
     0.724    13.336     0.200
     0.704    14.180     0.200
     0.699    13.266     0.200
     1.052    17.867     0.200
     1.042    18.250     0.200
     1.123    19.555     0.200
     3.163    48.453     0.200
     3.763    55.859     0.200
     4.980    73.555     0.200
     6.775    99.180     0.200
     0.447     9.914     0.200
     0.423     9.961     0.200
     0.694    13.070     0.200
     0.757    14.180     0.200
     0.774    15.266     0.200
     0.963    17.484     0.200
     1.087    18.930     0.200
     1.068    18.375     0.200
     1.157    20.953     0.200
     1.601    27.344     0.200
     6.687    97.914     0.200
     9.607   135.531     0.200
    15.463   215.195     0.200
     0.396     9.758     0.200
     0.480    10.648     0.200
     0.654    12.477     0.200
     0.728    13.688     0.200
     0.692    14.070     0.200
     0.718    13.688     0.200
     0.821    16.359     0.200
     1.042    17.875     0.200
     1.067    18.844     0.200
     1.049    19.406     0.200
     1.127    19.539     0.200
     1.127    20.438     0.200
     1.127    19.547     0.200
     1.485    25.586     0.200
     1.485    24.789     0.200
     1.485    25.641     0.200
     2.030    31.789     0.200
     2.030    33.141     0.200
     2.030    33.039     0.200
     3.142    48.641     0.200
     3.142    48.438     0.200
     3.744    55.734     0.200
     3.744    55.539     0.200
     4.285    63.758     0.200
     4.285    65.938     0.200
     4.285    65.141     0.200
     4.285    65.289     0.200
     4.916    72.391     0.200
     4.916    73.688     0.200
     4.957    74.539     0.200
     4.957    75.539     0.200
     5.451    80.367     0.200
     5.451    81.641     0.200
     6.799    97.547     0.200
     6.801    96.508     0.200
     6.801   101.438     0.200
     6.801   100.695     0.200
     6.801   100.625     0.200
     7.405   106.578     0.200
     7.405   107.164     0.200
     7.405   106.734     0.200
     7.943   112.789     0.200
     7.943   116.641     0.200
     7.943   116.438     0.200
     8.543   121.430     0.200
     9.641   138.234     0.200
     9.724   135.891     0.200
     9.726   136.234     0.200
     9.726   137.141     0.200
    11.989   172.406     0.200
    12.533   179.336     0.200
    12.763   182.836     0.200
    12.951   182.711     0.200
    14.726   209.141     0.200
    14.788   205.883     0.200
    15.576   217.336     0.200
    17.744   245.031     0.200
    17.744   244.383     0.200
    20.686   281.938     0.200
     0.538    12.186     0.200
     0.674    13.476     0.200
     0.785    15.836     0.200
     1.185    21.985     0.200
     1.184    21.985     0.200
     1.476    26.786     0.200
     1.476    26.536     0.200
     1.476    26.786     0.200
     2.039    34.105     0.200
     3.176    50.886     0.200
     3.783    58.586     0.200
     4.265    64.666     0.200
     4.265    65.586     0.200
     4.458    68.786     0.200
     4.986    75.985     0.200
     4.986    78.286     0.200
     4.934    76.096     0.200
     4.934    76.286     0.200
     5.447    82.636     0.200
     6.801   100.096     0.200
     6.803    99.326     0.200
     6.803   102.485     0.200
     6.803   102.647     0.200
     7.349   109.276     0.200
     8.289   119.405     0.200
     9.585   138.686     0.200
    10.846   156.286     0.200
    11.951   173.436     0.200
    11.951   174.586     0.200
    12.578   177.886     0.200
    14.674   207.186     0.200
    14.801   206.195     0.200
    14.801   209.086     0.200
     0.376     9.289     0.200
     0.553    11.332     0.200
     0.580    11.219     0.200
     0.606    12.691     0.200
     0.713    14.582     0.200
     0.795    14.570     0.200
     0.764    14.160     0.200
     0.941    17.859     0.200
     1.054    17.891     0.200
     1.155    19.832     0.200
     1.195    20.730     0.200
     1.196    20.680     0.200
     1.196    21.281     0.200
     1.202    21.172     0.200
     1.379    23.957     0.200
     2.135    33.789     0.200
     3.092    46.980     0.200
     3.705    54.980     0.200
     3.705    54.781     0.200
     4.175    63.480     0.200
     4.175    63.281     0.200
     4.896    75.082     0.200
     5.025    73.559     0.200
     5.546    81.680     0.200
     6.889   103.082     0.200
     6.900   100.270     0.200
     6.901   100.141     0.200
     6.901   102.879     0.200
     6.902   102.781     0.200
     7.380   105.992     0.200
     7.380   106.812     0.200
     8.042   114.520     0.200
     8.647   122.352     0.200
     9.137   129.969     0.200
     9.563   136.531     0.200
     9.563   138.980     0.200
     9.836   140.012     0.200
    11.069   157.102     0.200
    12.032   171.750     0.200
    12.032   174.180     0.200
    14.639   203.980     0.200
    14.639   207.582     0.200
    14.702   204.570     0.200
    14.702   207.230     0.200
    15.111   208.172     0.200
    15.687   217.332     0.200
    17.637   241.820     0.200
    20.581   278.379     0.200
     0.398     9.664     0.200
     0.470    10.434     0.200
     0.681    12.723     0.200
     0.719    13.355     0.200
     0.700    13.344     0.200
     0.711    14.414     0.200
     0.852    16.855     0.200
     1.039    18.293     0.200
     1.049    17.914     0.200
     1.117    19.793     0.200
     1.117    19.914     0.200
     1.117    19.215     0.200
     1.117    19.914     0.200
     1.117    19.266     0.200
     1.077    19.676     0.200
     1.515    26.590     0.200
     1.515    25.363     0.200
     1.515    26.613     0.200
     2.000    32.344     0.200
     3.163    49.113     0.200
     3.762    55.812     0.200
     4.315    64.004     0.200
     4.315    65.715     0.200
     4.315    65.953     0.200
     4.524    66.914     0.200
     4.886    72.605     0.200
     4.886    73.363     0.200
     5.422    79.836     0.200
     5.422    81.312     0.200
     5.422    81.465     0.200
     6.769    99.363     0.200
     6.771    98.684     0.200
     6.771   101.113     0.200
     6.771   100.754     0.200
     7.404   106.145     0.200
     7.404   105.734     0.200
     7.404   109.938     0.200
     7.913   113.164     0.200
     8.203   118.812     0.200
     8.203   122.113     0.200
     8.513   121.652     0.200
     9.655   140.914     0.200
     9.655   138.414     0.200
    10.877   159.516     0.200
    10.900   155.414     0.200
    14.744   208.414     0.200
    14.817   207.113     0.200
    14.817   206.562     0.200
    15.224   212.164     0.200
    17.775   245.336     0.200
    20.711   279.832     0.200
    20.711   280.812     0.200
     0.452    10.035     0.200
     0.415     9.754     0.200
     0.700    13.043     0.200
     0.739    13.605     0.200
     0.758    14.914     0.200
     0.981    17.656     0.200
     1.064    18.293     0.200
     1.094    18.973     0.200
     1.095    18.984     0.200
     1.138    20.523     0.200
     1.581    26.844     0.200
     1.581    26.406     0.200
     1.581    26.844     0.200
     1.934    31.793     0.200
     3.207    50.043     0.200
     3.800    56.543     0.200
     3.800    56.344     0.200
     4.380    65.996     0.200
     4.380    66.645     0.200
     4.546    67.844     0.200
     4.820    71.805     0.200
     5.029    74.445     0.200
     5.029    76.043     0.200
     5.359    79.344     0.200
     6.705   100.664     0.200
     6.707   100.246     0.200
     7.406   106.516     0.200
     9.690   141.145     0.200
    14.786   206.945     0.200
    14.786   210.246     0.200
    14.876   209.266     0.200
    17.841   245.738     0.200
    20.768   280.344     0.200
     0.402     9.734     0.200
     0.480    10.430     0.200
     0.637    12.047     0.200
     0.687    13.898     0.200
     0.805    16.125     0.200
     1.032    17.594     0.200
     1.038    19.500     0.200
     1.085    19.078     0.200
     1.468    25.438     0.200
     3.126    49.086     0.200
     3.729    55.391     0.200
     6.818    98.922     0.200
    12.004   168.438     0.200
     0.384     9.709     0.200
     0.488    10.648     0.200
     0.669    12.518     0.200
     0.702    13.428     0.200
     0.736    13.508     0.200
     0.689    14.039     0.200
     0.831    16.559     0.200
     1.053    18.498     0.200
     1.056    17.918     0.200
     1.054    19.338     0.200
     1.135    20.008     0.200
     1.135    19.648     0.200
     1.495    25.789     0.200
     1.496    25.309     0.200
     2.019    32.389     0.200
     4.907    72.428     0.200
     5.438    78.809     0.200
     6.789    96.199     0.200
     6.789    98.938     0.200
     7.393   105.730     0.200
    11.973   170.268     0.200
    16.733   231.857     0.200
     0.476    10.594     0.200
     0.725    13.875     0.200
     0.694    13.227     0.200
     0.687    13.164     0.200
     0.711    14.188     0.200
     0.861    17.156     0.200
     1.026    18.609     0.200
     1.060    18.453     0.200
     1.122    19.898     0.200
     1.122    19.797     0.200
     1.123    20.023     0.200
     1.123    19.898     0.200
     1.082    19.773     0.200
     1.525    26.500     0.200
     1.525    26.000     0.200
     1.526    25.945     0.200
     1.989    32.328     0.200
     1.989    32.695     0.200
     3.176    49.500     0.200
     3.775    56.594     0.200
     3.775    56.398     0.200
     4.323    65.797     0.200
     4.323    66.000     0.200
     4.323    66.336     0.200
     4.519    65.898     0.200
     4.877    72.945     0.200
     4.994    75.398     0.200
     4.994    76.195     0.200
     5.410    80.914     0.200
     5.410    81.297     0.200
     5.410    81.648     0.200
     6.758    99.523     0.200
     6.760    99.664     0.200
     6.760   101.094     0.200
     6.760    98.023     0.200
     7.395   106.969     0.200
     7.395   104.898     0.200
     7.395   106.898     0.200
     7.395   105.125     0.200
     7.901   114.367     0.200
     7.901   117.195     0.200
     8.200   118.297     0.200
     8.211   120.094     0.200
     8.211   122.094     0.200
     9.154   134.898     0.200
     9.154   130.297     0.200
     9.684   137.000     0.200
     9.652   136.844     0.200
     9.652   137.797     0.200
    10.869   156.695     0.200
    11.957   172.305     0.200
    11.939   168.570     0.200
    11.957   168.953     0.200
    12.542   177.094     0.200
    12.600   178.195     0.200
    12.600   176.695     0.200
    14.743   208.797     0.200
    14.829   208.266     0.200
    14.829   207.898     0.200
    14.829   208.266     0.200
    14.829   207.148     0.200
    15.541   218.367     0.200
    16.742   231.539     0.200
    17.785   244.820     0.200
    17.785   245.812     0.200
     0.363     9.102     0.200
     0.551    11.252     0.200
     0.601    11.132     0.200
     0.744    13.772     0.200
     0.794    14.432     0.200
     1.064    17.692     0.200
     1.134    19.412     0.200
     1.195    20.482     0.200
     1.195    20.562     0.200
     1.195    20.152     0.200
     1.223    21.122     0.200
     1.399    23.902     0.200
     1.400    23.152     0.200
     2.116    33.802     0.200
     3.111    48.652     0.200
     3.724    54.952     0.200
     4.193    62.852     0.200
     4.193    63.852     0.200
     4.917    73.852     0.200
     4.917    75.352     0.200
     5.007    74.042     0.200
     5.525    82.172     0.200
     6.879   101.192     0.200
     6.881   101.192     0.200
     6.881   101.852     0.200
     6.881   100.977     0.200
     7.371   106.842     0.200
     7.371   105.252     0.200
     7.371   105.443     0.200
     8.021   117.402     0.200
     8.080   116.952     0.200
     9.565   136.777     0.200
     9.565   136.352     0.200
    12.013   168.952     0.200
    14.724   206.992     0.200
    17.656   243.721     0.200
     0.017     6.061     0.200
     0.356     8.170     0.200
     0.441    10.150     0.200
     0.426    10.291     0.200
     0.689    12.830     0.200
     0.679    13.131     0.200
     0.733    13.240     0.200
     0.766    15.031     0.200
     0.917    17.631     0.200
     0.987    17.621     0.200
     1.052    17.840     0.200
     1.084    18.701     0.200
     1.084    19.000     0.200
     1.083    18.811     0.200
     1.142    20.490     0.200
     1.262    22.191     0.200
     1.395    23.330     0.200
     1.580    27.227     0.200
     1.580    26.080     0.200
     1.935    30.910     0.200
     3.198    49.301     0.200
     3.790    55.701     0.200
     4.381    65.041     0.200
     4.381    64.801     0.200
     4.557    66.900     0.200
     4.820    70.441     0.200
     5.021    74.801     0.200
     5.021    75.400     0.200
     5.363    77.361     0.200
     6.707    96.861     0.200
     6.709    96.590     0.200
     6.710    99.977     0.200
     7.417   108.740     0.200
     7.417   106.830     0.200
     7.417   107.227     0.200
     7.852   114.391     0.200
     9.700   138.102     0.200
     9.700   137.301     0.200
     9.700   138.301     0.200
     1.068    18.656     0.200
     1.021    19.258     0.200
     1.166    21.098     0.200
     1.166    21.418     0.200
     1.166    21.316     0.200
     1.299    22.645     0.200
     1.471    26.340     0.200
     1.471    26.258     0.200
     2.044    32.887     0.200
     2.044    33.215     0.200
     3.763    57.215     0.200
     4.264    65.738     0.200
     4.264    66.715     0.200
     4.264    66.418     0.200
     4.478    65.816     0.200
     4.935    72.828     0.200
     4.935    73.316     0.200
     4.969    76.617     0.200
     4.969    76.016     0.200
     5.456    80.465     0.200
     5.456    81.715     0.200
     5.456    81.867     0.200
     6.808   100.938     0.200
     6.810   100.777     0.200
     6.810   101.316     0.200
     6.810   100.566     0.200
     6.810   100.766     0.200
     7.367   106.715     0.200
     7.370   106.875     0.200
     7.370   106.367     0.200
     7.370   106.195     0.200
     7.951   113.488     0.200
     7.951   118.117     0.200
     7.951   115.336     0.200
     8.151   121.117     0.200
     8.297   118.547     0.200
     8.297   121.316     0.200
     8.297   121.676     0.200
     8.556   125.266     0.200
     8.878   128.117     0.200
     9.129   133.117     0.200
     9.129   129.988     0.200
     9.129   132.406     0.200
     9.602   137.566     0.200
     9.602   137.715     0.200
     9.742   137.992     0.200
     9.745   137.695     0.200
     9.745   139.418     0.200
    10.838   155.316     0.200
    10.982   158.816     0.200
    11.971   169.262     0.200
    12.494   176.816     0.200
    12.891   181.668     0.200
    12.947   183.008     0.200
    12.947   182.441     0.200
    14.689   203.816     0.200
    14.689   208.316     0.200
    14.789   208.793     0.200
    16.704   232.766     0.200
    17.728   245.137     0.200
    19.478   268.918     0.200
     0.452    10.016     0.200
     0.414     9.977     0.200
     0.701    12.773     0.200
     0.692    12.922     0.200
     0.701    13.117     0.200
     0.733    14.711     0.200
     0.871    17.047     0.200
     1.041    17.586     0.200
     1.028    17.836     0.200
     1.098    18.875     0.200
     1.099    19.195     0.200
     1.099    18.773     0.200
     1.099    19.922     0.200
     1.533    26.297     0.200
     1.534    25.406     0.200
     1.982    32.312     0.200
     2.859    42.375     0.200
     3.166    47.977     0.200
     3.763    55.477     0.200
     4.335    62.945     0.200
     4.335    64.875     0.200
     4.866    72.031     0.200
     4.987    73.273     0.200
     4.987    76.273     0.200
     5.407    80.172     0.200
     6.742   100.773     0.200
     6.753    98.141     0.200
     6.755    98.297     0.200
     6.755   100.672     0.200
     6.755   100.344     0.200
     7.417   107.641     0.200
     9.676   138.070     0.200
     9.676   140.773     0.200
    11.969   171.867     0.200
    14.766   204.773     0.200
     0.218     9.430     0.200
     0.188     9.070     0.200
     0.281    10.430     0.200
     0.282     9.984     0.200
     0.431    10.930     0.200
     0.422    11.273     0.200
     0.693    14.031     0.200
     0.878    16.789     0.200
     0.876    17.500     0.200
     0.940    16.328     0.200
     1.167    19.852     0.200
     1.865    29.922     0.200
     1.866    30.242     0.200
     2.079    33.359     0.200
     4.683    68.273     0.200
     4.718    67.930     0.200
     6.821    97.547     0.200
     6.822    96.344     0.200
     6.822    98.391     0.200
     7.984   113.688     0.200
     8.344   120.039     0.200
    12.578   175.734     0.200
     0.031     6.285     0.200
     0.331     7.945     0.200
     0.440    10.145     0.200
     0.425    10.305     0.200
     0.689    12.797     0.200
     0.700    13.328     0.200
     0.703    12.758     0.200
     0.750    14.797     0.200
     0.887    17.188     0.200
     1.017    17.836     0.200
     1.037    17.508     0.200
     1.086    18.785     0.200
     1.086    19.055     0.200
     1.086    19.055     0.200
     1.086    18.547     0.200
     1.117    20.105     0.200
     1.549    26.281     0.200
     1.549    25.855     0.200
     1.550    25.836     0.200
     1.966    31.266     0.200
     1.966    31.758     0.200
     3.172    48.758     0.200
     3.172    49.055     0.200
     3.766    55.258     0.200
     3.766    55.055     0.200
     4.352    63.285     0.200
     4.352    64.457     0.200
     4.352    65.855     0.200
     4.849    70.855     0.200
     4.849    71.457     0.200
     4.994    74.355     0.200
     4.994    75.156     0.200
     5.394    78.785     0.200
     5.394    80.555     0.200
     6.739    96.836     0.200
     6.741    97.387     0.200
     6.741   100.656     0.200
     6.741   100.258     0.200
     6.741    99.871     0.200
     7.424   106.516     0.200
     7.883   114.977     0.200
     7.883   115.656     0.200
     8.231   119.035     0.200
     8.231   121.555     0.200
     9.657   133.656     0.200
     9.659   136.484     0.200
     9.659   136.258     0.200
     9.691   138.805     0.200
     9.691   139.457     0.200
     9.691   141.457     0.200
    10.901   157.957     0.200
    11.966   169.957     0.200
    11.966   170.426     0.200
    12.104   171.555     0.200
    14.782   204.457     0.200
    14.782   209.258     0.200
    14.840   207.457     0.200
     0.375     9.426     0.200
     0.525    10.969     0.200
     0.614    11.668     0.200
     0.738    13.816     0.200
     0.770    14.199     0.200
     0.760    15.219     0.200
     0.986    18.266     0.200
     1.053    17.746     0.200
     1.114    19.238     0.200
     1.170    20.578     0.200
     1.170    20.289     0.200
     1.170    20.078     0.200
     1.246    21.539     0.200
     1.426    24.414     0.200
     1.426    24.457     0.200
     2.089    33.059     0.200
     3.118    47.789     0.200
     3.118    48.789     0.200
     3.726    54.988     0.200
     4.222    62.219     0.200
     4.222    63.988     0.200
     4.479    66.289     0.200
     4.927    73.289     0.200
     4.927    74.789     0.200
     4.978    73.039     0.200
     5.503    81.777     0.200
     6.855    98.289     0.200
     6.856    97.477     0.200
     6.856   102.188     0.200
     6.857   100.875     0.200
     7.385   105.816     0.200
     7.385   106.887     0.200
     7.385   105.863     0.200
     7.997   113.809     0.200
     9.592   137.137     0.200
    12.009   172.699     0.200
    14.673   208.289     0.200
    14.742   206.207     0.200
    14.742   206.727     0.200
     0.743    13.322     0.200
     1.017    17.402     0.200
     1.586    27.352     0.200
     1.587    27.121     0.200
     1.935    30.752     0.200
     1.935    31.201     0.200
     1.935    31.701     0.200
     3.149    49.902     0.200
     3.149    49.801     0.200
     3.735    55.902     0.200
     4.400    66.631     0.200
     4.400    67.902     0.200
     4.400    67.402     0.200
     4.400    67.051     0.200
     4.807    71.691     0.200
     4.807    72.002     0.200
     4.631    67.801     0.200
     4.978    76.301     0.200
     5.379    80.562     0.200
     5.379    80.002     0.200
     6.715    99.211     0.200
     6.717    97.162     0.200
     6.717    99.701     0.200
     6.717    97.002     0.200
     6.717   100.662     0.200
     6.717    99.646     0.200
     7.471   107.201     0.200
     7.492   107.092     0.200
     7.492   108.002     0.200
     7.492   107.502     0.200
     7.862   112.252     0.200
     7.862   116.502     0.200
     7.862   115.842     0.200
     8.026   115.602     0.200
     8.282   120.002     0.200
     9.047   130.002     0.200
     9.614   133.877     0.200
     9.617   135.732     0.200
     9.768   139.451     0.200
     9.768   139.801     0.200
    10.990   160.801     0.200
    11.998   172.951     0.200
    11.980   169.602     0.200
    11.998   169.082     0.200
    12.169   172.902     0.200
    12.657   178.902     0.200
    12.907   182.176     0.200
    12.908   182.402     0.200
    14.847   207.432     0.200
    14.847   207.102     0.200
    14.847   208.781     0.200
    14.847   207.902     0.200
    14.858   209.801     0.200
    16.853   234.012     0.200
    17.849   244.881     0.200
    17.849   245.795     0.200
    17.849   246.602     0.200
    18.932   261.402     0.200
     0.433     9.605     0.200
     0.506    11.255     0.200
     0.654    13.195     0.200
     0.810    14.186     0.200
     0.965    18.186     0.200
     1.145    20.476     0.200
     1.373    24.465     0.200
     1.373    24.295     0.200
     1.373    24.465     0.200
     2.142    34.226     0.200
     3.046    48.465     0.200
     4.180    63.965     0.200
     4.180    64.165     0.200
     4.180    64.266     0.200
     4.180    64.915     0.200
     4.515    66.865     0.200
     4.515    65.565     0.200
     4.855    74.065     0.200
     4.855    74.365     0.200
     5.024    74.135     0.200
     5.566    82.346     0.200
     6.914   103.745     0.200
     6.915   101.295     0.200
     6.915   102.165     0.200
     6.915   103.675     0.200
     6.916   101.953     0.200
     7.438   105.965     0.200
     7.438   106.766     0.200
     7.438   106.840     0.200
     7.448   106.865     0.200
     8.019   115.365     0.200
     8.057   117.936     0.200
     8.073   119.065     0.200
     8.272   118.766     0.200
     8.404   123.056     0.200
     8.846   127.065     0.200
     9.612   136.490     0.200
     9.612   136.766     0.200
     9.612   136.065     0.200
    10.770   155.465     0.200
    10.896   157.665     0.200
    11.931   170.465     0.200
    12.080   172.584     0.200
    12.081   170.905     0.200
    12.449   175.665     0.200
    12.449   177.465     0.200
    12.512   175.965     0.200
    13.580   191.865     0.200
    14.683   205.465     0.200
    14.683   207.465     0.200
    14.675   205.838     0.200
    16.743   231.846     0.200
    16.743   232.065     0.200
     0.651    12.789     0.200
     0.928    18.195     0.200
     1.165    20.883     0.200
     1.285    22.516     0.200
     1.397    24.000     0.200
     1.340    23.227     0.200
     1.430    24.289     0.200
     1.576    26.680     0.200
     1.588    26.109     0.200
     1.588    26.930     0.200
     1.588    27.094     0.200
     1.588    26.961     0.200
     1.735    29.352     0.200
     1.930    31.602     0.200
     1.969    32.430     0.200
     1.877    30.977     0.200
     2.487    39.625     0.200
     3.178    49.734     0.200
     3.178    50.531     0.200
     3.766    56.531     0.200
     4.395    65.539     0.200
     4.395    67.031     0.200
     4.395    67.234     0.200
     4.594    67.633     0.200
     4.594    66.836     0.200
     4.808    71.344     0.200
     4.808    71.633     0.200
     5.004    75.531     0.200
     5.004    77.031     0.200
     5.366    79.711     0.200
     5.366    80.586     0.200
     6.706    99.570     0.200
     6.708    99.172     0.200
     6.708    98.133     0.200
     6.708    97.539     0.200
     7.453   108.500     0.200
     7.453   108.836     0.200
     7.453   108.773     0.200
     7.453   107.273     0.200
     7.852   114.062     0.200
     7.988   115.133     0.200
     8.200   119.523     0.200
     8.200   120.242     0.200
     8.244   118.734     0.200
     8.286   122.133     0.200
     8.444   121.734     0.200
     9.024   130.133     0.200
     9.024   129.336     0.200
     9.214   133.406     0.200
     9.616   133.508     0.200
     9.735   139.336     0.200
    10.600   152.734     0.200
    10.983   157.836     0.200
    10.934   159.633     0.200
    11.966   170.742     0.200
    11.948   170.656     0.200
    12.100   172.133     0.200
    12.627   177.930     0.200
    12.623   178.336     0.200
    12.817   181.422     0.200
    13.726   192.133     0.200
    14.864   207.672     0.200
    14.864   209.930     0.200
    14.864   207.195     0.200
    14.829   206.234     0.200
    14.829   209.734     0.200
    15.269   213.430     0.200
    16.816   233.883     0.200
    16.816   234.734     0.200
    17.850   246.695     0.200
    17.850   245.328     0.200
    18.894   265.031     0.200
    20.800   282.398     0.200
     0.394     9.774     0.200
     0.476    10.444     0.200
     0.675    12.614     0.200
     0.702    13.374     0.200
     0.724    13.284     0.200
     0.703    14.204     0.200
     0.843    16.715     0.200
     1.046    18.305     0.200
     1.050    17.814     0.200
     1.123    19.555     0.200
     1.123    20.015     0.200
     1.123    19.715     0.200
     1.507    25.715     0.200
     1.507    25.784     0.200
     2.008    31.984     0.200
     2.008    32.614     0.200
     3.160    49.314     0.200
     3.160    50.015     0.200
     3.760    56.015     0.200
     3.760    55.814     0.200
     4.306    62.984     0.200
     4.306    65.614     0.200
     4.306    66.015     0.200
     4.519    67.015     0.200
     4.895    71.965     0.200
     4.895    72.515     0.200
     4.977    75.215     0.200
     5.429    79.324     0.200
     5.429    81.015     0.200
     6.766   103.015     0.200
     6.777    99.084     0.200
     6.779    98.765     0.200
     6.779    99.914     0.200
     6.779    99.414     0.200
     6.779    99.814     0.200
     7.401   106.555     0.200
     7.401   106.395     0.200
     7.401   108.590     0.200
     7.920   114.274     0.200
     8.194   118.914     0.200
     9.648   139.340     0.200
     9.648   138.914     0.200
     9.648   140.114     0.200
    10.891   156.314     0.200
    11.973   172.614     0.200
    12.004   171.314     0.200
    12.581   176.414     0.200
    14.737   204.814     0.200
    14.737   209.314     0.200
    14.810   207.529     0.200
    20.703   279.814     0.200
     0.358     8.020     0.200
     0.425     9.520     0.200
     0.443    10.473     0.200
     0.673    12.352     0.200
     0.684    13.211     0.200
     0.742    13.383     0.200
     0.785    15.281     0.200
     0.979    17.492     0.200
     0.933    17.762     0.200
     1.044    17.633     0.200
     1.066    18.430     0.200
     1.161    20.762     0.200
     1.263    22.180     0.200
     1.595    26.871     0.200
     1.595    26.871     0.200
     3.199    49.371     0.200
     3.199    49.570     0.200
     3.789    55.672     0.200
     3.789    55.172     0.200
     5.024    76.172     0.200
     5.024    77.270     0.200
     6.697    99.020     0.200
     7.430   105.273     0.200
     0.414     9.887     0.200
     0.451    10.047     0.200
     0.700    13.098     0.200
     0.723    13.438     0.200
     1.056    18.227     0.200
     1.096    19.148     0.200
     1.095    18.906     0.200
     1.125    20.359     0.200
     1.565    26.227     0.200
     1.565    26.680     0.200
     1.565    26.688     0.200
     1.950    31.637     0.200
     1.950    32.277     0.200
     3.193    48.879     0.200
     3.193    49.379     0.200
     3.787    56.180     0.200
     4.365    65.598     0.200
     4.365    66.578     0.200
     4.365    66.477     0.200
     4.365    65.898     0.200
     4.545    66.680     0.200
     4.545    66.180     0.200
     4.836    72.000     0.200
     4.836    72.879     0.200
     4.836    72.258     0.200
     5.015    75.180     0.200
     5.015    75.777     0.200
     5.375    80.340     0.200
     5.375    80.777     0.200
     5.375    81.027     0.200
     6.723    98.809     0.200
     6.723   101.078     0.200
     6.723    98.180     0.200
     6.723   100.457     0.200
     7.409   109.078     0.200
     7.409   106.754     0.200
     7.409   107.098     0.200
     7.409   104.477     0.200
     8.212   120.777     0.200
     8.253   119.477     0.200
     9.643   135.703     0.200
     9.646   138.180     0.200
     9.686   138.578     0.200
     9.686   137.977     0.200
    10.950   157.277     0.200
    12.628   178.180     0.200
    12.628   179.680     0.200
    14.779   205.578     0.200
    14.779   208.977     0.200
    14.860   205.406     0.200
    14.860   207.848     0.200
    14.860   207.715     0.200
    20.757   281.070     0.200
     1.062    18.387     0.200
     1.098    19.047     0.200
     1.098    18.758     0.200
     1.098    19.129     0.200
     1.129    20.398     0.200
     1.257    22.477     0.200
     1.572    26.508     0.200
     1.572    26.105     0.200
     1.572    26.559     0.200
     1.943    31.219     0.200
     1.943    31.906     0.200
     3.201    49.457     0.200
     3.201    49.758     0.200
     3.795    56.059     0.200
     3.795    56.355     0.200
     4.371    66.566     0.200
     4.371    66.457     0.200
     4.543    66.855     0.200
     4.829    71.566     0.200
     4.829    71.285     0.200
     5.023    75.559     0.200
     5.023    75.758     0.200
     5.368    80.285     0.200
     5.368    80.656     0.200
     6.714    96.695     0.200
     6.716    96.129     0.200
     6.716    96.613     0.200
     7.405   104.547     0.200
     7.405   106.109     0.200
     7.858   115.848     0.200
     8.205   116.977     0.200
     9.685   136.383     0.200
     9.685   138.156     0.200
    10.955   157.656     0.200
    12.636   178.758     0.200
    14.780   205.656     0.200
    14.780   209.059     0.200
    14.868   207.309     0.200
    14.868   208.684     0.200
    16.765   230.797     0.200
     1.084    18.750     0.200
     1.074    19.620     0.200
     1.652    27.900     0.200
     1.652    27.770     0.200
     1.652    27.950     0.200
     1.863    31.080     0.200
     2.219    34.350     0.200
     2.930    44.050     0.200
     2.930    43.750     0.200
     3.254    50.450     0.200
     3.841    57.350     0.200
     4.450    65.040     0.200
     4.450    69.950     0.200
     4.450    66.950     0.200
     4.450    67.060     0.200
     4.570    70.950     0.200
     4.570    67.950     0.200
     4.750    70.710     0.200
     4.750    72.150     0.200
     4.750    71.100     0.200
     5.082    76.450     0.200
     5.082    77.450     0.200
     5.292    79.830     0.200
     5.292    80.650     0.200
     6.535    97.950     0.200
     6.636    97.070     0.200
     6.637    99.820     0.200
     6.637   100.550     0.200
     6.637    98.850     0.200
     6.638    99.663     0.200
     7.377   108.750     0.200
     7.408   106.960     0.200
     7.407   106.450     0.200
     7.780   114.980     0.200
     7.780   114.670     0.200
     7.930   116.250     0.200
     8.128   118.690     0.200
     8.128   121.250     0.200
     8.128   119.760     0.200
     8.186   119.750     0.200
     8.337   124.550     0.200
     9.560   135.420     0.200
     9.728   139.150     0.200
     9.728   139.950     0.200
     9.728   138.650     0.200
    10.894   158.950     0.200
    11.034   160.850     0.200
    11.034   160.450     0.200
    12.115   174.950     0.200
    12.704   179.750     0.200
    14.831   210.150     0.200
    14.940   210.670     0.200
    14.940   208.375     0.200
    15.345   213.950     0.200
    17.912   245.850     0.200
    20.829   281.810     0.200
    20.829   282.250     0.200
     0.570    11.523     0.200
     0.578    11.246     0.200
     0.589    12.605     0.200
     0.701    14.414     0.200
     0.812    14.664     0.200
     0.924    17.594     0.200
     1.065    18.016     0.200
     1.162    19.957     0.200
     1.212    21.246     0.200
     1.193    21.246     0.200
     1.368    24.094     0.200
     1.368    23.676     0.200
     2.147    34.016     0.200
     3.094    47.844     0.200
     3.709    55.445     0.200
     3.709    55.145     0.200
     4.161    62.246     0.200
     4.161    62.145     0.200
     4.444    66.645     0.200
     4.444    65.047     0.200
     4.896    73.844     0.200
     4.896    75.844     0.200
     5.039    74.684     0.200
     5.554    82.156     0.200
     6.909   103.137     0.200
     6.911   102.137     0.200
     6.911   100.047     0.200
     6.912   102.707     0.200
     7.368   103.844     0.200
     7.368   107.441     0.200
     9.546   136.746     0.200
    14.621   202.645     0.200
    17.625   243.215     0.200
    17.625   240.547     0.200
     0.154     5.828     0.200
     0.287     7.777     0.200
     0.390     9.367     0.200
     0.390     9.227     0.200
     0.390     9.098     0.200
     0.390     9.508     0.200
     0.342     8.047     0.200
     0.408     9.086     0.200
     0.585    10.996     0.200
     0.786    15.898     0.200
     0.860    16.047     0.200
     0.834    13.918     0.200
     1.119    18.777     0.200
     1.188    20.785     0.200
     1.250    21.758     0.200
     1.766    28.496     0.200
     1.767    29.547     0.200
     1.767    28.496     0.200
     2.104    32.777     0.200
     2.104    33.648     0.200
     2.719    41.996     0.200
     3.230    47.598     0.200
     4.584    68.297     0.200
     4.584    69.297     0.200
     4.590    68.387     0.200
     4.590    68.996     0.200
     4.782    69.777     0.200
     4.782    70.047     0.200
     5.303    78.297     0.200
     5.607    81.977     0.200
     6.863    98.887     0.200
     6.864    98.156     0.200
     6.864   100.012     0.200
     6.740    99.098     0.200
     8.024   113.875     0.200
     8.156   118.598     0.200
     8.188   116.105     0.200
     8.188   119.297     0.200
     8.187   115.945     0.200
     8.187   117.496     0.200
     8.383   118.738     0.200
     8.503   123.297     0.200
     8.503   125.996     0.200
     8.702   125.598     0.200
     9.520   138.098     0.200
     9.949   141.797     0.200
    10.385   148.371     0.200
    10.385   148.098     0.200
    10.385   150.496     0.200
    11.666   166.695     0.200
    12.549   177.496     0.200
    12.533   175.516     0.200
    13.254   183.707     0.200
    13.254   185.695     0.200
    13.294   187.398     0.200
    14.607   201.559     0.200
    14.607   201.316     0.200
    14.607   202.898     0.200
    15.246   209.105     0.200
    15.428   213.898     0.200
    15.428   215.398     0.200
    17.903   246.078     0.200
    19.590   265.648     0.200
     0.212     9.156     0.200
     0.196     8.922     0.200
     0.272    10.125     0.200
     0.273    10.266     0.200
     0.432    10.742     0.200
     0.431    11.281     0.200
     0.703    14.047     0.200
     0.878    16.875     0.200
     0.885    17.648     0.200
     0.949    16.477     0.200
     1.169    19.984     0.200
     1.291    22.508     0.200
     1.367    23.555     0.200
     1.439    23.656     0.200
     1.874    30.430     0.200
     1.873    30.336     0.200
     2.080    33.062     0.200
     2.731    41.703     0.200
     2.731    42.406     0.200
     3.221    47.203     0.200
     3.221    48.203     0.200
     4.598    67.508     0.200
     4.598    69.602     0.200
     4.690    70.906     0.200
     4.690    70.203     0.200
     4.715    67.906     0.200
     5.578    81.148     0.200
     6.819    98.234     0.200
     6.821    98.031     0.200
     6.821    98.953     0.200
     7.982   114.586     0.200
     8.281   117.977     0.200
     8.281   118.875     0.200
     8.343   119.188     0.200
    10.503   150.508     0.200
    12.583   176.555     0.200
     0.483    10.844     0.200
     0.626    12.832     0.200
     0.729    13.863     0.200
     0.682    14.145     0.200
     0.741    13.484     0.200
     1.028    18.234     0.200
     1.095    18.695     0.200
     1.029    19.535     0.200
     1.129    19.832     0.200
     1.129    20.145     0.200
     1.129    19.645     0.200
     1.129    20.094     0.200
     1.458    25.945     0.200
     1.458    25.715     0.200
     2.057    32.293     0.200
     2.057    33.145     0.200
     2.057    33.293     0.200
     2.125    33.344     0.200
     2.823    42.645     0.200
     3.117    48.844     0.200
     3.117    49.445     0.200
     3.721    56.043     0.200
     3.721    56.145     0.200
     4.260    65.473     0.200
     4.260    66.344     0.200
     4.260    65.844     0.200
     4.517    66.742     0.200
     4.942    73.094     0.200
     4.942    72.742     0.200
     4.942    73.844     0.200
     4.932    74.844     0.200
     5.479    80.766     0.200
     5.479    81.344     0.200
     5.479    81.742     0.200
     6.827   101.766     0.200
     6.829   101.355     0.200
     6.829   101.008     0.200
     7.415   105.285     0.200
     7.415   105.402     0.200
     7.415   107.418     0.200
     7.971   117.273     0.200
     7.971   115.555     0.200
     8.233   117.043     0.200
     8.233   120.445     0.200
     8.318   118.785     0.200
     8.318   122.242     0.200
     8.571   122.324     0.200
     8.897   128.543     0.200
     9.635   138.320     0.200
     9.635   137.543     0.200
     9.635   138.543     0.200
    10.881   159.445     0.200
    11.009   155.652     0.200
    12.012   172.793     0.200
    11.994   168.855     0.200
    12.012   169.094     0.200
    12.529   177.645     0.200
    12.932   186.043     0.200
    12.979   181.355     0.200
    14.717   208.945     0.200
    14.760   207.414     0.200
    14.760   207.812     0.200
    15.168   212.594     0.200
    15.599   217.016     0.200
    15.599   217.645     0.200
    15.867   220.742     0.200
    17.718   244.605     0.200
    17.718   243.844     0.200
    19.406   267.742     0.200
     0.387     9.414     0.200
     0.482    10.633     0.200
     0.680    12.695     0.200
     0.730    13.625     0.200
     0.695    13.312     0.200
     1.057    18.031     0.200
     1.041    18.531     0.200
     1.509    25.805     0.200
     2.006    32.766     0.200
     4.893    73.344     0.200
     7.917   117.703     0.200
     0.152     8.383     0.200
     0.254     9.242     0.200
     0.284     9.789     0.200
     0.285     9.844     0.200
     0.285     9.492     0.200
     0.285    10.000     0.200
     0.374     9.891     0.200
     0.479    11.820     0.200
     0.724    14.578     0.200
     0.816    15.969     0.200
     0.942    16.109     0.200
     1.116    19.188     0.200
     1.373    22.367     0.200
     1.367    23.648     0.200
     1.477    23.789     0.200
     1.854    29.742     0.200
     1.854    29.492     0.200
     1.855    29.492     0.200
     2.214    33.594     0.200
     2.142    33.672     0.200
     2.142    33.789     0.200
     2.142    33.938     0.200
     2.667    41.289     0.200
     2.667    41.188     0.200
     4.534    68.594     0.200
     4.663    68.680     0.200
     4.663    69.688     0.200
     4.663    69.789     0.200
     4.663    69.492     0.200
     4.663    68.781     0.200
     4.764    68.188     0.200
     4.764    68.391     0.200
     5.447    78.391     0.200
     5.639    81.969     0.200
     5.639    82.094     0.200
     5.639    82.289     0.200
     6.821    99.391     0.200
     6.877    99.328     0.200
     6.878    98.523     0.200
     6.878    98.891     0.200
     6.878    99.000     0.200
     6.878    98.977     0.200
     8.040   114.617     0.200
     8.040   115.344     0.200
     8.291   119.992     0.200
     8.328   119.414     0.200
     8.328   118.523     0.200
     8.401   118.938     0.200
     8.401   119.492     0.200
     8.575   123.688     0.200
     8.526   119.969     0.200
     8.526   120.891     0.200
     8.834   126.891     0.200
     9.092   130.594     0.200
     9.528   132.328     0.200
     9.637   139.289     0.200
    10.090   144.031     0.200
    10.090   144.188     0.200
    10.090   142.789     0.200
    10.980   156.391     0.200
    11.261   158.391     0.200
    11.218   155.914     0.200
    11.218   157.141     0.200
    11.809   165.688     0.200
    12.269   170.789     0.200
    12.648   177.594     0.200
    12.633   176.844     0.200
    12.998   181.391     0.200
    13.307   185.281     0.200
    13.307   184.914     0.200
    13.307   185.141     0.200
    13.434   187.891     0.200
    13.520   188.602     0.200
    13.520   188.789     0.200
    13.520   189.000     0.200
    13.528   190.117     0.200
    14.585   199.414     0.200
    14.585   203.094     0.200
    14.585   199.453     0.200
    14.509   201.891     0.200
    14.966   208.289     0.200
    15.183   210.438     0.200
    15.559   214.094     0.200
    15.559   215.992     0.200
    16.645   228.688     0.200
    17.675   240.641     0.200
    17.675   241.188     0.200
     1.045    17.941     0.200
     1.110    19.410     0.200
     1.159    20.723     0.200
     1.159    20.312     0.200
     1.159    20.012     0.200
     1.158    20.410     0.200
     1.158    20.039     0.200
     1.387    23.062     0.200
     1.340    23.371     0.200
     1.432    23.590     0.200
     1.433    23.910     0.200
     1.416    24.152     0.200
     1.535    25.262     0.200
     1.611    26.973     0.200
     1.574    26.672     0.200
     1.710    28.402     0.200
     1.681    28.281     0.200
     1.867    30.180     0.200
     1.906    31.352     0.200
     1.960    31.883     0.200
     2.081    33.590     0.200
     2.081    34.211     0.200
     2.081    33.191     0.200
     2.081    33.410     0.200
     2.181    34.039     0.200
     2.244    36.230     0.200
     2.374    35.562     0.200
     2.590    40.531     0.200
     2.747    42.609     0.200
     2.739    42.660     0.200
     2.755    43.332     0.200
     2.828    41.512     0.200
     2.828    42.410     0.200
     2.838    42.262     0.200
     3.116    48.012     0.200
     3.116    47.812     0.200
     3.322    50.391     0.200
     3.507    54.289     0.200
     3.846    57.410     0.200
     4.026    61.082     0.200
     4.231    64.070     0.200
     4.231    64.609     0.200
     4.231    63.812     0.200
     4.231    64.262     0.200
     4.326    65.160     0.200
     4.489    65.609     0.200
     4.499    67.812     0.200
     4.499    68.152     0.200
     4.758    72.172     0.200
     4.927    74.609     0.200
     4.969    73.352     0.200
     4.969    73.859     0.200
     5.333    80.562     0.200
     5.497    81.551     0.200
     5.497    82.312     0.200
     6.319    93.711     0.200
     6.367    94.430     0.200
     6.616    96.262     0.200
     6.850   101.582     0.200
     6.850   101.812     0.200
     6.850   100.910     0.200
     6.850   101.371     0.200
     6.850   100.676     0.200
     7.106   105.160     0.200
     7.138   104.039     0.200
     7.394   106.441     0.200
     7.394   105.910     0.200
     7.394   106.102     0.200
     7.394   106.562     0.200
     7.396   106.512     0.200
     7.964   114.512     0.200
     7.991   116.781     0.200
     7.991   116.609     0.200
     7.991   117.211     0.200
     8.120   118.910     0.200
     8.217   118.109     0.200
     8.224   120.621     0.200
     8.338   120.582     0.200
     8.338   121.211     0.200
     8.594   122.930     0.200
     8.594   123.711     0.200
     8.864   127.109     0.200
     9.152   130.312     0.200
     9.152   131.012     0.200
     9.152   131.609     0.200
     9.152   132.070     0.200
     9.604   136.586     0.200
     9.604   136.812     0.200
     9.777   138.562     0.200
     9.779   136.781     0.200
     9.779   139.109     0.200
    10.432   150.711     0.200
    10.817   154.211     0.200
    10.817   152.910     0.200
    10.858   154.211     0.200
    11.024   157.930     0.200
    11.024   158.312     0.200
    12.011   170.910     0.200
    12.083   172.512     0.200
    12.521   176.312     0.200
    12.499   176.012     0.200
    12.796   183.109     0.200
    12.932   184.992     0.200
    12.932   184.609     0.200
    14.685   206.312     0.200
    14.685   203.910     0.200
    14.746   204.812     0.200
    14.746   205.512     0.200
    14.746   204.723     0.200
    14.746   205.340     0.200
    15.154   209.770     0.200
    15.154   210.512     0.200
    15.154   209.012     0.200
    15.154   210.371     0.200
    15.630   214.133     0.200
    16.717   231.699     0.200
    16.717   231.922     0.200
    17.692   243.406     0.200
    19.058   261.312     0.200
    19.420   265.812     0.200
    19.521   265.012     0.200
     0.532    11.160     0.200
     0.622    12.012     0.200
     0.632    13.133     0.200
     0.728    13.840     0.200
     0.778    14.391     0.200
     0.984    18.523     0.200
     1.063    18.262     0.200
     1.108    19.523     0.200
     1.178    20.840     0.200
     1.178    20.551     0.200
     1.178    20.551     0.200
     1.429    25.102     0.200
     1.429    25.133     0.200
     2.086    33.203     0.200
     2.086    33.750     0.200
     2.150    33.250     0.200
     2.842    42.652     0.200
     3.127    49.051     0.200
     4.223    63.250     0.200
     4.470    66.652     0.200
     4.935    74.953     0.200
     4.977    74.023     0.200
     5.498    82.113     0.200
     6.850   100.312     0.200
     6.852   101.801     0.200
     6.852   100.652     0.200
     6.853   102.426     0.200
     7.375   104.102     0.200
     7.375   108.551     0.200
     7.993   115.293     0.200
     8.339   120.590     0.200
     9.585   137.250     0.200
    11.022   153.672     0.200
    11.999   172.141     0.200
    14.666   206.352     0.200
    14.749   208.500     0.200
    14.749   207.883     0.200
    14.749   205.910     0.200
    17.686   243.672     0.200
     0.356     9.277     0.200
     0.533    11.176     0.200
     0.639    11.848     0.200
     0.635    13.125     0.200
     0.712    13.387     0.200
     0.779    14.117     0.200
     0.779    15.406     0.200
     0.995    18.426     0.200
     1.073    17.918     0.200
     1.091    18.816     0.200
     1.179    20.367     0.200
     1.268    21.707     0.200
     1.445    24.555     0.200
     2.163    32.957     0.200
     2.856    42.258     0.200
     3.143    47.656     0.200
     3.751    55.555     0.200
     4.238    64.457     0.200
     6.836   100.012     0.200
     0.513    10.996     0.200
     0.759    14.125     0.200
     0.728    13.727     0.200
     1.005    18.336     0.200
     1.052    18.047     0.200
     1.098    19.336     0.200
     2.144    32.945     0.200
     2.839    42.344     0.200
     3.128    47.445     0.200
     3.735    55.445     0.200
    17.703   244.215     0.200
     0.181     8.809     0.200
     0.256     9.879     0.200
     0.257     9.922     0.200
     0.227     8.898     0.200
     0.419    10.469     0.200
     0.463    11.328     0.200
     0.728    14.219     0.200
     0.861    16.590     0.200
     0.916    18.020     0.200
     0.965    16.238     0.200
     1.160    19.629     0.200
     1.322    22.730     0.200
     1.415    23.141     0.200
     1.386    23.551     0.200
     1.518    24.449     0.200
     1.884    30.191     0.200
     1.884    30.449     0.200
     1.885    30.426     0.200
     2.098    32.730     0.200
     2.255    33.648     0.200
     2.255    33.750     0.200
     2.441    38.449     0.200
     2.711    41.648     0.200
     3.198    47.352     0.200
     4.578    68.750     0.200
     4.578    68.648     0.200
     4.721    67.961     0.200
     4.697    67.859     0.200
     4.697    70.148     0.200
     5.595    79.422     0.200
     6.832    95.691     0.200
     6.834    99.234     0.200
     7.996   112.199     0.200
     8.312   120.789     0.200
    12.611   179.332     0.200
     0.133     8.562     0.200
     0.291    10.145     0.200
     0.274     9.383     0.200
     0.357     9.754     0.200
     0.496    11.914     0.200
     0.732    14.531     0.200
     0.797    15.793     0.200
     0.942    15.793     0.200
     0.943    18.602     0.200
     1.100    18.895     0.200
     1.352    22.312     0.200
     1.345    23.293     0.200
     1.368    23.504     0.200
     1.456    23.621     0.200
     2.193    32.824     0.200
     2.377    38.223     0.200
     2.647    41.324     0.200
     2.647    41.621     0.200
     3.135    47.422     0.200
     4.514    68.223     0.200
     4.514    67.824     0.200
     6.897    98.875     0.200
     8.344   118.629     0.200
    12.669   180.359     0.200
     1.092    20.477     0.200
     1.427    25.555     0.200
     1.428    25.582     0.200
     2.340    36.156     0.200
     2.340    35.855     0.200
     2.349    38.055     0.200
     2.685    42.758     0.200
     2.685    42.156     0.200
     3.256    49.457     0.200
     3.256    49.656     0.200
     4.265    65.258     0.200
     4.265    66.156     0.200
     4.529    70.855     0.200
     4.529    68.258     0.200
     7.040   101.031     0.200
    12.479   178.336     0.200
     0.560    11.426     0.200
     0.598    11.215     0.200
     0.600    12.645     0.200
     0.745    13.938     0.200
     0.803    14.496     0.200
     0.725    14.547     0.200
     0.945    17.547     0.200
     1.069    17.848     0.200
     1.140    19.625     0.200
     1.203    20.676     0.200
     1.204    20.734     0.200
     1.216    21.066     0.200
     1.391    23.973     0.200
     1.392    23.836     0.200
     1.392    23.996     0.200
     2.123    33.836     0.200
     2.145    32.496     0.200
     2.736    43.395     0.200
     2.776    43.695     0.200
     2.833    42.098     0.200
     2.833    42.395     0.200
     3.111    47.496     0.200
     3.111    47.598     0.200
     3.724    55.195     0.200
     4.184    62.574     0.200
     4.184    64.598     0.200
     4.915    75.098     0.200
     4.915    74.098     0.200
     5.015    73.375     0.200
     6.886    99.605     0.200
     6.888    99.336     0.200
     6.888   101.977     0.200
     7.365   106.324     0.200
     7.365   106.070     0.200
     8.027   113.348     0.200
     8.635   122.836     0.200
     9.556   135.820     0.200
     9.556   135.996     0.200
     9.823   137.297     0.200
     9.825   137.734     0.200
    11.053   157.336     0.200
    12.014   168.996     0.200
    14.718   206.703     0.200
    17.648   243.738     0.200
     0.175     8.964     0.200
     0.232     9.144     0.200
     0.265    10.124     0.200
     0.265    10.174     0.200
     0.407    10.514     0.200
     0.465    11.624     0.200
     0.725    14.744     0.200
     0.850    16.614     0.200
     0.917    18.104     0.200
     0.957    16.304     0.200
     1.149    19.654     0.200
     1.508    24.204     0.200
     1.875    30.194     0.200
     1.876    30.454     0.200
     2.109    32.734     0.200
     2.246    33.604     0.200
     2.430    38.404     0.200
     2.701    42.904     0.200
     2.701    41.004     0.200
     3.188    47.804     0.200
     4.567    69.404     0.200
     4.567    66.304     0.200
     4.687    70.304     0.200
     4.687    70.104     0.200
     4.733    67.914     0.200
     6.828    98.904     0.200
     6.844    99.474     0.200
     6.845    99.704     0.200
     6.845    98.488     0.200
     8.007   114.984     0.200
     8.314   119.103     0.200
     8.599   124.004     0.200
     9.650   139.004     0.200
    10.525   149.929     0.200
    10.525   151.204     0.200
    10.525   149.104     0.200
    11.798   167.404     0.200
    11.798   167.504     0.200
    12.619   177.059     0.200
    12.619   177.704     0.200
     0.179     8.781     0.200
     0.270     9.961     0.200
     0.269     9.941     0.200
     0.227     8.980     0.200
     0.407    10.352     0.200
     0.459    11.430     0.200
     0.719    14.293     0.200
     0.850    16.480     0.200
     0.952    16.172     0.200
     1.148    19.551     0.200
     1.316    22.902     0.200
     1.407    23.031     0.200
     1.374    23.480     0.200
     1.510    24.531     0.200
     1.871    30.172     0.200
     1.872    30.355     0.200
     2.108    33.371     0.200
     2.248    33.930     0.200
     2.248    34.430     0.200
     2.430    39.031     0.200
     2.702    41.531     0.200
     2.702    42.031     0.200
     3.190    47.832     0.200
     3.190    48.031     0.200
     4.569    69.031     0.200
     4.569    68.531     0.200
     4.734    67.883     0.200
     6.844    98.000     0.200
     6.845    97.262     0.200
     8.007   113.090     0.200
     8.368   118.930     0.200
     0.154     8.742     0.200
     0.257     9.502     0.200
     0.306    10.372     0.200
     0.307    10.642     0.200
     0.307    10.372     0.200
     0.356     9.722     0.200
     0.474    11.932     0.200
     0.709    14.472     0.200
     0.800    15.832     0.200
     0.921    15.792     0.200
     0.920    18.572     0.200
     1.096    18.872     0.200
     1.322    23.191     0.200
     1.347    23.191     0.200
     1.362    22.322     0.200
     1.466    23.872     0.200
     1.832    29.922     0.200
     1.833    29.347     0.200
     1.833    29.972     0.200
     2.158    34.032     0.200
     2.158    34.372     0.200
     2.158    34.222     0.200
     2.203    32.672     0.200
     2.203    32.972     0.200
     2.275    35.072     0.200
     2.380    37.572     0.200
     2.653    40.472     0.200
     3.145    47.172     0.200
     4.520    66.771     0.200
     4.641    67.242     0.200
     4.641    70.172     0.200
     4.641    69.372     0.200
     4.785    68.592     0.200
     4.785    68.872     0.200
     5.435    78.271     0.200
     5.656    82.472     0.200
     6.895    99.481     0.200
     6.897    99.212     0.200
     6.897    99.771     0.200
     6.897    98.572     0.200
     6.897    99.452     0.200
     6.897    99.335     0.200
     8.058   113.712     0.200
     8.058   115.271     0.200
     8.058   115.472     0.200
     8.321   116.602     0.200
     8.321   119.672     0.200
     8.321   117.082     0.200
     8.321   118.646     0.200
     8.419   118.792     0.200
     8.419   121.472     0.200
     8.553   123.271     0.200
     9.550   132.572     0.200
     9.617   138.872     0.200
    12.654   177.872     0.200
    13.321   185.447     0.200
    14.567   202.076     0.200
    17.920   245.271     0.200
     0.727    13.439     0.200
     1.036    18.068     0.200
     1.066    18.330     0.200
     1.151    20.689     0.200
     1.581    27.045     0.200
     1.581    27.049     0.200
     1.935    31.238     0.200
     2.161    33.170     0.200
     2.869    43.369     0.200
     4.386    67.170     0.200
     4.386    66.770     0.200
     4.816    70.680     0.200
     5.011    78.068     0.200
     5.011    75.969     0.200
     5.367    79.010     0.200
     6.709    97.250     0.200
     6.711    97.520     0.200
     6.711    97.080     0.200
     6.711    95.535     0.200
     7.854   113.430     0.200
    14.865   208.920     0.200
    14.865   209.068     0.200
    14.865   208.051     0.200
    19.301   263.369     0.200
     0.741    15.180     0.200
     1.020    18.279     0.200
     1.429    23.560     0.200
     1.744    28.750     0.200
     1.744    29.560     0.200
     1.745    29.585     0.200
     2.165    32.960     0.200
     2.165    33.160     0.200
     2.218    35.710     0.200
     2.218    36.310     0.200
     2.223    35.760     0.200
     2.316    37.560     0.200
     2.599    41.260     0.200
     3.104    48.660     0.200
     3.104    48.160     0.200
     4.464    67.160     0.200
     4.551    66.660     0.200
     4.551    68.660     0.200
     4.866    71.010     0.200
     4.866    71.310     0.200
     5.383    81.859     0.200
     5.383    81.160     0.200
     5.719    85.060     0.200
     6.966   101.090     0.200
     6.967   100.910     0.200
     6.967   101.060     0.200
     6.967   101.380     0.200
     6.967   101.069     0.200
     6.967   101.598     0.200
     8.128   117.020     0.200
     8.128   117.819     0.200
     8.291   120.060     0.200
     8.291   121.202     0.200
     8.488   122.470     0.200
     8.488   124.120     0.200
     8.463   124.960     0.200
     9.634   134.635     0.200
    10.869   153.960     0.200
    11.150   160.960     0.200
    12.190   172.960     0.200
    12.677   180.160     0.200
    13.374   188.935     0.200
    14.499   203.535     0.200
    15.295   211.234     0.200
    15.467   216.760     0.200
     0.176     8.941     0.200
     0.262    10.131     0.200
     0.231     9.191     0.200
     0.410    10.461     0.200
     0.465    11.621     0.200
     0.726    14.531     0.200
     0.852    16.562     0.200
     0.917    18.352     0.200
     0.959    16.361     0.200
     1.151    19.611     0.200
     1.322    23.143     0.200
     1.381    23.691     0.200
     1.510    24.592     0.200
     1.877    31.092     0.200
     1.878    30.742     0.200
     2.107    33.791     0.200
     2.247    33.492     0.200
     2.324    36.393     0.200
     2.432    38.592     0.200
     2.703    41.992     0.200
     2.703    41.492     0.200
     4.570    68.691     0.200
     4.570    67.592     0.200
     4.690    69.871     0.200
     4.690    72.291     0.200
     4.690    69.492     0.200
     4.730    68.252     0.200
     5.604    80.643     0.200
     6.842    98.082     0.200
     6.843    98.223     0.200
     6.843    97.395     0.200
     8.005   114.143     0.200
     8.366   118.961     0.200
    14.621   205.477     0.200
     0.319     9.223     0.200
     0.357     9.633     0.200
     0.539    12.062     0.200
     0.546    11.652     0.200
     0.720    13.553     0.200
     0.926    16.752     0.200
     0.926    16.682     0.200
     0.956    16.781     0.200
     1.078    17.793     0.200
     1.052    18.043     0.200
     1.144    18.953     0.200
     1.281    21.182     0.200
     1.420    22.852     0.200
     1.785    28.143     0.200
     1.925    30.822     0.200
     1.925    31.143     0.200
     1.927    31.168     0.200
     1.902    30.143     0.200
     2.063    33.043     0.200
     2.286    36.143     0.200
     2.539    39.611     0.200
     4.149    63.742     0.200
     4.149    62.643     0.200
     4.633    69.242     0.200
     5.026    72.893     0.200
     6.014    87.432     0.200
     7.211   104.002     0.200
     7.212   103.062     0.200
     7.212   104.029     0.200
     8.376   119.402     0.200
     8.748   125.668     0.200
    11.592   163.172     0.200
    13.109   184.807     0.200
    14.250   199.748     0.200
     0.174     8.820     0.200
     0.231     9.188     0.200
     0.305    10.242     0.200
     0.403    11.078     0.200
     0.424    10.727     0.200
     0.668    13.828     0.200
     0.855    17.266     0.200
     0.873    16.727     0.200
     0.916    16.016     0.200
     1.156    19.578     0.200
     1.260    22.047     0.200
     1.334    23.008     0.200
     1.443    23.609     0.200
     1.548    25.039     0.200
     1.843    30.242     0.200
     1.844    30.188     0.200
     2.285    34.141     0.200
     2.352    36.742     0.200
     2.451    39.336     0.200
     2.729    42.141     0.200
     2.729    42.039     0.200
     4.596    66.836     0.200
     4.596    68.242     0.200
     6.831    97.312     0.200
     0.170     9.090     0.200
     0.237     9.630     0.200
     0.317    10.710     0.200
     0.316    10.640     0.200
     0.395    11.160     0.200
     0.421    10.860     0.200
     0.658    13.670     0.200
     0.846    16.970     0.200
     0.871    16.630     0.200
     0.906    15.870     0.200
     1.151    19.820     0.200
     1.251    21.880     0.200
     1.323    22.930     0.200
     1.548    25.290     0.200
     1.833    29.910     0.200
     1.834    30.563     0.200
     2.086    32.780     0.200
     2.285    34.390     0.200
     2.448    38.790     0.200
     2.728    42.590     0.200
     2.728    42.190     0.200
     4.594    68.190     0.200
     4.653    69.990     0.200
     4.653    69.090     0.200
     4.738    67.950     0.200
     5.587    81.200     0.200
     6.835    99.196     0.200
     7.996   113.860     0.200
     8.244   119.125     0.200
    12.568   177.316     0.200
    17.668   241.101     0.200
     0.169     8.984     0.200
     0.237     9.273     0.200
     0.287    10.355     0.200
     0.287    10.324     0.200
     0.287    10.574     0.200
     0.385    10.246     0.200
     0.462    11.637     0.200
     0.711    14.336     0.200
     0.829    16.324     0.200
     0.912    18.184     0.200
     0.936    15.965     0.200
     1.125    19.355     0.200
     1.315    22.875     0.200
     1.360    23.324     0.200
     1.389    22.926     0.200
     1.493    24.316     0.200
     1.852    29.113     0.200
     1.852    31.016     0.200
     1.852    30.516     0.200
     1.853    31.039     0.200
     2.129    33.574     0.200
     2.129    33.715     0.200
     2.230    33.516     0.200
     2.303    36.016     0.200
     2.409    38.215     0.200
     2.681    41.215     0.200
     2.681    41.816     0.200
     4.548    67.816     0.200
     4.548    66.715     0.200
     4.663    67.344     0.200
     4.663    69.516     0.200
     4.663    68.715     0.200
     4.756    68.125     0.200
     4.756    68.516     0.200
     4.814    72.816     0.200
     5.432    79.316     0.200
     5.627    81.363     0.200
     6.866    98.254     0.200
     6.867    98.293     0.200
     6.867    98.414     0.200
     6.867    98.145     0.200
     6.867    98.023     0.200
     6.867    98.590     0.200
     8.029   114.516     0.200
     8.029   113.984     0.200
     8.311   119.227     0.200
     8.390   119.586     0.200
     8.390   119.426     0.200
     8.575   124.113     0.200
     9.522   132.238     0.200
     9.630   138.516     0.200
    10.979   156.316     0.200
    11.793   167.316     0.200
    12.282   171.914     0.200
    12.282   171.715     0.200
    12.630   177.465     0.200
    13.113   181.715     0.200
    13.292   185.039     0.200
    13.421   188.613     0.200
    13.511   189.203     0.200
    14.597   204.215     0.200
    14.597   201.105     0.200
    14.597   202.016     0.200
    14.978   204.715     0.200
     0.564    11.852     0.200
     0.612    12.633     0.200
     0.677    12.922     0.200
     0.812    14.961     0.200
     0.790    15.523     0.200
     0.989    18.273     0.200
     1.068    18.711     0.200
     1.113    18.953     0.200
     1.211    21.133     0.200
     1.211    21.625     0.200
     1.458    25.883     0.200
     1.458    25.906     0.200
     2.202    33.805     0.200
     2.843    44.406     0.200
     2.895    43.102     0.200
     3.179    49.906     0.200
     3.179    49.508     0.200
     4.242    64.805     0.200
     4.432    66.203     0.200
     4.985    75.203     0.200
     4.985    74.602     0.200
     5.461    81.461     0.200
     5.461    81.578     0.200
     6.817   101.047     0.200
     6.819   101.008     0.200
     6.819   100.406     0.200
     6.819   101.898     0.200
     6.819   102.539     0.200
     6.819   101.914     0.200
     7.328   108.188     0.200
     8.125   119.906     0.200
     8.125   117.703     0.200
    10.822   154.703     0.200
    11.947   171.055     0.200
    12.016   170.102     0.200
    14.645   208.008     0.200
    14.645   204.008     0.200
    14.791   209.227     0.200
    17.711   244.516     0.200
    17.711   243.906     0.200
    17.711   244.008     0.200
     0.079     6.398     0.200
     0.320     7.797     0.200
     0.389     9.648     0.200
     0.484    10.770     0.200
     0.665    12.258     0.200
     0.732    13.430     0.200
     0.707    13.277     0.200
     0.692    13.859     0.200
     0.829    16.270     0.200
     1.051    17.598     0.200
     1.056    18.258     0.200
     1.054    19.270     0.200
     1.131    19.387     0.200
     1.311    22.207     0.200
     1.494    25.824     0.200
     1.494    25.398     0.200
     1.494    25.367     0.200
     2.813    43.000     0.200
     2.855    41.898     0.200
     3.153    47.598     0.200
     4.292    64.148     0.200
     4.292    65.098     0.200
     4.969    72.398     0.200
     7.397   105.582     0.200
    11.978   170.848     0.200
    14.800   207.039     0.200
    17.753   244.191     0.200
    19.367   265.500     0.200
    20.689   279.793     0.200
    20.689   280.199     0.200
     0.121     8.780     0.200
     0.284     9.600     0.200
     0.361     9.970     0.200
     0.278    10.380     0.200
     0.509    12.140     0.200
     0.748    14.750     0.200
     0.798    16.040     0.200
     0.956    16.420     0.200
     0.957    19.030     0.200
     1.106    19.120     0.200
     1.349    22.540     0.200
     1.383    23.850     0.200
     1.360    23.650     0.200
     1.452    23.530     0.200
     1.863    29.490     0.200
     2.189    33.630     0.200
     2.162    34.290     0.200
     2.646    39.730     0.200
     6.894    98.320     0.200
     8.056   113.900     0.200
     0.189     9.057     0.200
     0.182     8.887     0.200
     0.479    11.855     0.200
     0.480    11.637     0.200
     0.541    12.146     0.200
     0.540    12.836     0.200
     0.728    14.787     0.200
     0.868    15.486     0.200
     0.885    16.516     0.200
     0.956    16.406     0.200
     1.072    18.787     0.200
     1.144    21.666     0.200
     1.176    19.736     0.200
     1.783    28.297     0.200
     1.784    28.336     0.200
     1.913    29.236     0.200
     2.117    34.037     0.200
     2.374    36.836     0.200
     2.374    37.137     0.200
     2.435    37.896     0.200
     4.241    64.336     0.200
     4.344    65.137     0.200
     4.537    70.236     0.200
     7.151   103.771     0.200
     7.151   102.426     0.200
     8.440   122.836     0.200
    10.872   153.736     0.200
    12.942   183.221     0.200
     0.369     9.797     0.200
     0.377     9.906     0.200
     0.511    11.672     0.200
     0.596    12.055     0.200
     0.596    12.164     0.200
     0.768    14.094     0.200
     0.907    16.172     0.200
     0.902    16.336     0.200
     0.971    17.445     0.200
     1.002    17.367     0.200
     1.112    18.281     0.200
     1.377    22.281     0.200
     1.579    26.117     0.200
     1.592    26.477     0.200
     1.734    26.766     0.200
     1.924    31.047     0.200
     1.926    31.039     0.200
     2.019    32.961     0.200
     2.239    34.766     0.200
     2.590    40.195     0.200
     4.100    62.562     0.200
     4.100    61.766     0.200
     4.202    62.961     0.200
     4.617    68.461     0.200
     7.257   104.781     0.200
     7.258   103.266     0.200
     7.258   104.180     0.200
     7.258   102.625     0.200
     8.423   118.961     0.200
    12.699   178.664     0.200
    14.205   197.664     0.200
    14.205   199.250     0.200
    14.205   198.664     0.200
     0.161     8.918     0.200
     0.244     9.449     0.200
     0.305    10.328     0.200
     0.392    11.027     0.200
     0.438    10.977     0.200
     0.665    13.719     0.200
     0.846    17.137     0.200
     0.888    17.078     0.200
     0.919    16.105     0.200
     1.169    19.879     0.200
     1.251    21.809     0.200
     1.335    23.168     0.200
     1.563    25.277     0.200
     1.848    30.477     0.200
     1.849    30.504     0.200
     2.300    34.277     0.200
     2.465    38.578     0.200
     2.744    42.578     0.200
     2.744    42.977     0.200
     4.610    69.379     0.200
     4.669    70.676     0.200
     4.669    70.379     0.200
     6.818    98.664     0.200
     8.242   119.281     0.200
    12.556   178.227     0.200
     0.132     8.723     0.200
     0.269    10.055     0.200
     0.269     9.883     0.200
     0.269     9.934     0.200
     0.329    10.074     0.200
     0.378    10.715     0.200
     0.557    12.133     0.200
     0.703    14.023     0.200
     0.833    16.973     0.200
     0.998    17.234     0.200
     1.005    18.555     0.200
     1.242    21.715     0.200
     1.288    21.395     0.200
     1.394    22.762     0.200
     1.408    23.613     0.200
     1.402    23.555     0.200
     1.670    26.453     0.200
     1.939    31.512     0.200
     1.939    31.215     0.200
     1.939    31.629     0.200
     1.952    31.613     0.200
     1.952    30.832     0.200
     2.407    36.254     0.200
     2.584    40.352     0.200
     2.860    44.152     0.200
     2.860    44.254     0.200
     4.726    70.953     0.200
     4.767    70.852     0.200
     4.767    70.215     0.200
     6.696    95.332     0.200
     6.698    95.953     0.200
     6.698    93.832     0.200
     6.698    94.152     0.200
     6.698    97.680     0.200
     6.698    93.965     0.200
     7.859   111.652     0.200
     7.859   112.383     0.200
     8.208   116.805     0.200
     8.208   117.152     0.200
     8.219   115.922     0.200
     8.219   116.824     0.200
    10.489   148.098     0.200
    10.489   149.055     0.200
    11.703   166.254     0.200
    12.462   175.152     0.200
    12.462   175.852     0.200
    12.448   173.184     0.200
    12.462   173.652     0.200
    13.339   188.152     0.200
    17.667   240.004     0.200
     0.351    10.611     0.200
     0.472    11.472     0.200
     0.570    12.501     0.200
     0.630    13.231     0.200
     0.690    13.901     0.200
     0.803    15.441     0.200
     0.972    17.251     0.200
     1.029    18.651     0.200
     1.030    19.202     0.200
     1.305    21.102     0.200
     1.280    21.622     0.200
     1.302    22.501     0.200
     1.312    21.142     0.200
     1.364    21.932     0.200
     1.416    23.972     0.200
     1.458    24.292     0.200
     1.606    26.801     0.200
     1.596    26.301     0.200
     1.669    28.162     0.200
     1.807    29.202     0.200
     1.849    29.771     0.200
     1.849    30.452     0.200
     1.851    29.676     0.200
     1.851    29.801     0.200
     3.022    45.501     0.200
     3.022    45.301     0.200
     3.667    55.702     0.200
     3.667    54.401     0.200
     4.390    66.001     0.200
     4.390    64.662     0.200
     4.390    64.901     0.200
     4.390    65.801     0.200
     4.390    65.452     0.200
     6.565    96.602     0.200
     7.687   108.702     0.200
     7.687   108.591     0.200
     7.687   108.001     0.200
     7.687   109.011     0.200
     7.687   108.665     0.200
     8.248   119.001     0.200
     8.852   124.602     0.200
     8.852   124.151     0.200
     8.852   125.051     0.200
     9.021   128.751     0.200
     9.021   128.102     0.200
     9.021   127.977     0.200
     9.021   129.301     0.200
     9.053   127.301     0.200
     9.217   130.202     0.200
     9.217   129.312     0.200
     9.281   129.671     0.200
     9.281   128.801     0.200
     9.624   135.801     0.200
     9.687   138.702     0.200
    10.168   140.901     0.200
    10.170   141.251     0.200
    10.733   152.001     0.200
    10.770   153.602     0.200
    10.770   151.042     0.200
    10.858   151.645     0.200
    10.858   153.602     0.200
    10.858   153.301     0.200
    11.427   156.901     0.200
    12.075   167.202     0.200
    12.075   166.872     0.200
    12.075   167.401     0.200
    12.269   169.801     0.200
    12.439   174.401     0.200
    13.552   188.751     0.200
    13.537   187.742     0.200
    13.726   191.102     0.200
    13.779   189.731     0.200
    13.779   189.518     0.200
    13.779   189.711     0.200
    13.811   194.301     0.200
    14.147   195.571     0.200
    14.147   196.901     0.200
    14.195   195.501     0.200
    14.438   202.301     0.200
    14.438   199.901     0.200
    15.304   210.801     0.200
    15.629   214.332     0.200
    15.643   215.021     0.200
    15.766   218.001     0.200
    17.389   235.746     0.200
    17.389   236.631     0.200
    17.389   236.401     0.200
    17.389   237.801     0.200
    17.389   236.501     0.200
     0.104     7.094     0.200
     0.232     7.965     0.200
     0.434    10.344     0.200
     0.434    10.652     0.200
     0.433    10.684     0.200
     0.494    11.082     0.200
     0.597    11.934     0.200
     0.665    12.984     0.200
     0.670    14.191     0.200
     0.946    16.555     0.200
     1.117    19.645     0.200
     1.079    19.062     0.200
     1.215    19.914     0.200
     1.243    21.004     0.200
     1.323    22.434     0.200
     1.362    22.125     0.200
     1.810    28.254     0.200
     1.855    29.973     0.200
     1.855    29.812     0.200
     1.899    31.055     0.200
     1.898    30.422     0.200
     2.547    37.555     0.200
     2.682    42.352     0.200
     2.976    45.055     0.200
     2.976    45.555     0.200
     4.737    68.094     0.200
     4.737    70.953     0.200
     4.737    70.555     0.200
     4.737    70.113     0.200
     4.840    72.152     0.200
     4.840    71.352     0.200
     5.210    76.453     0.200
     6.624    97.934     0.200
     6.625    97.395     0.200
     6.625    96.953     0.200
     6.625    96.062     0.200
     6.626    97.078     0.200
     6.626    96.145     0.200
     7.784   112.965     0.200
     7.784   111.543     0.200
     8.031   115.723     0.200
     8.031   114.555     0.200
     8.031   115.027     0.200
     8.031   116.062     0.200
     8.142   118.273     0.200
     8.142   116.863     0.200
     8.649   125.652     0.200
     8.649   124.652     0.200
    10.345   147.695     0.200
    10.345   148.953     0.200
    11.018   155.754     0.200
    11.529   165.555     0.200
    12.303   175.352     0.200
    12.303   174.574     0.200
    14.852   206.879     0.200
    14.852   205.004     0.200
    15.239   210.164     0.200
     0.143     9.135     0.200
     0.200     9.215     0.200
     0.422    11.795     0.200
     0.422    11.943     0.200
     0.421    11.484     0.200
     0.637    14.064     0.200
     0.744    14.814     0.200
     0.879    15.523     0.200
     0.944    17.354     0.200
     1.005    20.113     0.200
     1.203    20.354     0.200
     1.308    21.744     0.200
     1.751    28.344     0.200
     1.752    28.994     0.200
     1.752    28.344     0.200
     1.751    29.094     0.200
     2.045    30.844     0.200
     2.045    31.545     0.200
     2.217    35.443     0.200
     2.321    36.074     0.200
     2.321    35.943     0.200
     2.489    38.844     0.200
     2.489    38.545     0.200
     4.356    66.244     0.200
     4.356    64.645     0.200
     4.536    68.443     0.200
     4.536    67.844     0.200
     4.536    65.184     0.200
     4.536    67.680     0.200
     5.478    79.344     0.200
     5.478    80.244     0.200
     5.819    82.871     0.200
     6.633    93.049     0.200
     6.700    97.943     0.200
     6.700    97.443     0.200
     7.057    99.844     0.200
     7.057   100.516     0.200
     7.055   101.094     0.200
     7.057   101.443     0.200
     7.057   101.295     0.200
     7.057   100.434     0.200
     8.219   117.795     0.200
     8.219   117.064     0.200
     8.404   119.154     0.200
     8.404   120.193     0.200
     8.404   121.033     0.200
     8.445   122.045     0.200
     8.445   121.145     0.200
     8.580   122.084     0.200
     8.580   122.719     0.200
     9.196   129.943     0.200
     9.570   137.943     0.200
     9.570   135.943     0.200
     9.692   133.875     0.200
     9.692   133.920     0.200
    10.513   148.262     0.200
    10.513   148.045     0.200
    11.129   156.744     0.200
    11.397   160.113     0.200
    11.869   171.045     0.200
    12.089   168.244     0.200
    12.688   176.545     0.200
    12.802   180.844     0.200
    13.434   190.545     0.200
    13.484   189.949     0.200
    14.406   196.984     0.200
    14.406   197.545     0.200
    14.406   197.395     0.200
    14.406   197.215     0.200
    14.786   205.443     0.200
    14.786   204.844     0.200
    14.786   203.244     0.200
    15.525   215.344     0.200
    15.525   212.244     0.200
    16.775   229.045     0.200
    17.785   242.088     0.200
    17.785   242.443     0.200
    17.785   241.705     0.200
    17.785   242.564     0.200
    17.773   242.738     0.200
     0.507    12.168     0.200
     0.608    13.078     0.200
     0.608    13.438     0.200
     0.608    13.035     0.200
     0.608    13.137     0.200
     0.608    13.258     0.200
     0.628    12.566     0.200
     1.060    19.328     0.200
     1.105    20.156     0.200
     1.691    27.961     0.200
     1.690    28.738     0.200
     1.979    32.176     0.200
     1.979    32.488     0.200
     2.517    37.637     0.200
     2.587    41.438     0.200
     2.905    45.438     0.200
     2.905    45.938     0.200
     4.531    68.137     0.200
     4.531    68.438     0.200
     4.531    69.035     0.200
     4.760    71.836     0.200
     4.760    72.637     0.200
     6.767    97.027     0.200
     6.767   100.508     0.200
     6.765    97.488     0.200
     6.767    95.938     0.200
     6.767   100.148     0.200
     6.767    96.938     0.200
     7.922   113.016     0.200
     7.922   116.688     0.200
     7.906   116.535     0.200
     7.906   112.137     0.200
     7.906   112.637     0.200
     8.277   117.465     0.200
     8.277   121.047     0.200
     8.277   118.637     0.200
     8.441   123.336     0.200
     8.441   122.738     0.200
     8.679   125.035     0.200
     9.348   133.438     0.200
     9.544   133.363     0.200
     9.667   141.035     0.200
    10.149   143.531     0.200
    10.149   146.938     0.200
    10.149   144.938     0.200
    11.043   155.648     0.200
    11.043   154.938     0.200
    11.135   158.637     0.200
    11.388   166.035     0.200
    12.306   174.137     0.200
    12.306   173.258     0.200
    12.306   173.238     0.200
    12.450   176.938     0.200
    13.084   184.086     0.200
    13.048   183.137     0.200
    13.201   185.836     0.200
    13.201   185.438     0.200
    13.201   189.309     0.200
    13.271   186.336     0.200
    14.729   205.738     0.200
    14.729   206.121     0.200
    14.729   206.238     0.200
    15.122   210.766     0.200
    15.122   212.637     0.200
    15.215   213.336     0.200
    15.297   213.656     0.200
    17.335   237.789     0.200
    17.909   245.879     0.200
    17.909   246.336     0.200
    17.909   246.695     0.200
    17.909   247.207     0.200
    17.909   247.336     0.200
    19.343   267.938     0.200
     0.063     8.640     0.200
     0.338    10.380     0.200
     0.401    11.850     0.200
     0.432    10.699     0.200
     0.522    11.729     0.200
     0.695    13.640     0.200
     0.733    15.069     0.200
     0.773    15.510     0.200
     0.905    17.239     0.200
     0.905    17.420     0.200
     0.916    17.710     0.200
     1.040    18.550     0.200
     1.070    18.590     0.200
     1.121    19.380     0.200
     1.124    20.800     0.200
     1.148    20.479     0.200
     1.350    22.529     0.200
     1.374    23.795     0.200
     1.374    23.680     0.200
     1.428    24.319     0.200
     2.456    38.319     0.200
     2.491    37.119     0.200
     2.808    43.920     0.200
     3.871    59.220     0.200
     4.213    63.420     0.200
     4.213    63.319     0.200
     4.639    72.020     0.200
     4.639    70.819     0.200
     7.002   101.220     0.200
     7.002   101.162     0.200
     7.738   112.201     0.200
     8.121   116.920     0.200
     9.861   141.616     0.200
     9.861   142.920     0.200
    12.335   174.019     0.200
    13.237   186.041     0.200
    14.532   200.744     0.200
     0.161     8.695     0.200
     0.254     9.453     0.200
     0.349     9.797     0.200
     0.318    10.297     0.200
     0.319    10.234     0.200
     0.319     9.926     0.200
     0.319    10.434     0.200
     0.467    11.926     0.200
     0.698    14.516     0.200
     0.795    15.895     0.200
     0.909    15.863     0.200
     1.088    19.016     0.200
     1.335    23.363     0.200
     1.360    22.453     0.200
     1.464    23.625     0.200
     1.821    29.199     0.200
     1.821    29.625     0.200
     1.820    29.645     0.200
     1.820    30.074     0.200
     2.202    32.824     0.200
     2.202    33.727     0.200
     2.162    33.977     0.200
     2.162    34.227     0.200
     2.374    37.727     0.200
     2.649    41.125     0.200
     2.649    40.625     0.200
     4.515    68.523     0.200
     4.515    67.625     0.200
     4.629    69.426     0.200
     4.629    69.125     0.200
     4.629    68.164     0.200
     4.629    69.727     0.200
     6.787    97.625     0.200
     6.787    98.625     0.200
     6.858    99.125     0.200
     6.892    99.125     0.200
     6.903    99.004     0.200
     6.903    99.285     0.200
     6.902    99.125     0.200
     6.903    98.824     0.200
     6.903    99.238     0.200
     6.903    99.105     0.200
     8.065   114.785     0.200
     8.065   115.824     0.200
     8.314   119.227     0.200
     8.314   119.176     0.200
     8.314   118.676     0.200
     8.541   123.023     0.200
     8.425   119.734     0.200
     8.425   121.586     0.200
     8.425   120.625     0.200
     8.553   121.523     0.200
     8.826   126.125     0.200
     9.084   129.727     0.200
     9.605   138.824     0.200
     9.559   132.324     0.200
    10.075   146.125     0.200
    10.496   147.742     0.200
    10.496   150.426     0.200
    10.946   156.023     0.200
    11.239   157.613     0.200
    11.792   167.125     0.200
    12.247   170.125     0.200
    12.596   177.023     0.200
    12.613   177.227     0.200
    12.653   177.773     0.200
    12.653   177.094     0.200
    12.986   182.426     0.200
    13.079   182.227     0.200
    13.408   188.426     0.200
    13.325   184.852     0.200
    13.535   189.246     0.200
    13.535   189.926     0.200
    13.535   190.684     0.200
    14.561   203.023     0.200
    14.561   199.676     0.200
    14.774   204.594     0.200
    14.942   204.734     0.200
    14.942   204.926     0.200
    14.942   206.523     0.200
    14.942   207.125     0.200
    14.942   207.227     0.200
    15.217   207.426     0.200
    16.643   229.824     0.200
    17.722   242.125     0.200
     0.186     8.938     0.200
     0.229     9.109     0.200
     0.238    10.062     0.200
     0.239     9.930     0.200
     0.436    10.617     0.200
     0.469    11.508     0.200
     0.742    14.469     0.200
     0.876    16.828     0.200
     0.924    18.164     0.200
     0.983    16.594     0.200
     1.178    19.922     0.200
     1.528    24.570     0.200
     1.904    30.945     0.200
     1.903    30.883     0.200
     2.084    33.641     0.200
     2.266    34.469     0.200
     2.266    34.773     0.200
     2.456    39.570     0.200
     2.725    42.367     0.200
     2.725    41.867     0.200
     4.592    68.773     0.200
     6.818    97.914     0.200
     6.816    99.047     0.200
     6.818    98.922     0.200
     6.818    97.812     0.200
     7.980   114.180     0.200
     8.317   119.984     0.200
     8.317   117.438     0.200
     8.341   118.773     0.200
     8.465   118.602     0.200
    12.605   180.500     0.200
    12.605   175.047     0.200
    14.645   202.070     0.200
     0.115     6.633     0.200
     0.135     6.812     0.200
     0.471     9.883     0.200
     0.515    11.473     0.200
     0.515    11.621     0.200
     0.515    11.473     0.200
     0.602    12.102     0.200
     0.591    12.812     0.200
     0.813    14.570     0.200
     1.000    17.801     0.200
     1.046    18.820     0.200
     1.761    27.711     0.200
     1.765    28.062     0.200
     1.764    28.090     0.200
     1.764    29.410     0.200
     1.764    29.609     0.200
     1.954    30.891     0.200
     1.954    31.012     0.200
     2.494    36.910     0.200
     2.494    37.512     0.200
     2.594    40.812     0.200
     2.900    44.312     0.200
     2.900    44.609     0.200
     4.260    65.012     0.200
     4.603    68.211     0.200
     4.603    69.312     0.200
     4.603    69.211     0.200
     4.603    66.770     0.200
     4.603    70.910     0.200
     4.603    69.012     0.200
     4.722    71.410     0.200
     4.761    71.109     0.200
     4.761    71.312     0.200
     5.128    74.211     0.200
     6.692    98.512     0.200
     6.724    98.609     0.200
     6.740    99.211     0.200
     6.734    98.250     0.200
     6.734    98.770     0.200
     6.734    97.609     0.200
     6.734    98.324     0.200
     6.734    95.910     0.200
     7.891   112.762     0.200
     7.891   115.312     0.200
     7.891   112.410     0.200
     7.943   114.512     0.200
     7.973   114.711     0.200
     7.983   113.762     0.200
     7.984   115.410     0.200
     7.983   114.551     0.200
     7.983   113.691     0.200
     8.248   117.371     0.200
     8.248   119.070     0.200
     8.248   118.711     0.200
     8.248   117.211     0.200
     8.418   119.602     0.200
     8.418   122.562     0.200
     8.418   120.012     0.200
     8.515   123.512     0.200
     9.440   137.910     0.200
     9.487   132.012     0.200
     9.746   137.461     0.200
     9.746   140.723     0.200
     9.746   140.512     0.200
    10.243   147.805     0.200
    10.243   145.512     0.200
    10.243   144.711     0.200
    10.885   155.312     0.200
    11.026   155.441     0.200
    11.026   156.609     0.200
    11.026   156.312     0.200
    11.026   154.312     0.200
    11.470   164.512     0.200
    12.280   175.211     0.200
    12.337   175.410     0.200
    12.337   173.371     0.200
    12.337   175.180     0.200
    12.463   175.910     0.200
    12.463   174.012     0.200
    12.651   179.711     0.200
    12.976   182.371     0.200
    13.079   184.211     0.200
    13.142   184.312     0.200
    13.227   183.410     0.200
    13.227   187.211     0.200
    13.287   183.711     0.200
    14.542   202.820     0.200
    14.542   201.410     0.200
    14.751   205.312     0.200
    14.751   203.512     0.200
    14.751   203.871     0.200
    14.763   202.410     0.200
    15.141   209.172     0.200
    15.141   207.910     0.200
    15.141   210.711     0.200
    15.141   210.211     0.200
    15.309   214.109     0.200
    17.424   239.910     0.200
    17.967   245.379     0.200
    17.967   245.672     0.200
    18.975   258.852     0.200
     0.154     9.148     0.200
     0.254     9.688     0.200
     0.329    10.812     0.200
     0.328    10.742     0.200
     0.428    10.938     0.200
     0.377    11.172     0.200
     0.642    13.672     0.200
     0.879    16.945     0.200
     0.829    17.156     0.200
     0.895    16.133     0.200
     1.155    19.695     0.200
     1.233    21.773     0.200
     1.311    22.836     0.200
     1.456    23.836     0.200
     1.560    25.195     0.200
     1.826    30.094     0.200
     2.079    33.008     0.200
     2.297    35.492     0.200
     2.737    42.797     0.200
     4.603    69.898     0.200
     4.647    71.297     0.200
     6.831    98.562     0.200
     6.829    98.562     0.200
     6.831    98.547     0.200
     7.991   112.758     0.200
     8.227   116.492     0.200
     8.351   119.844     0.200
    12.554   175.594     0.200
    17.651   241.000     0.200
     0.198     8.648     0.200
     0.209     8.805     0.200
     0.296     9.875     0.200
     0.297     9.953     0.200
     0.297    10.062     0.200
     0.400    10.203     0.200
     0.434    11.211     0.200
     0.689    14.094     0.200
     0.847    16.328     0.200
     0.885    17.844     0.200
     0.924    16.008     0.200
     1.136    19.328     0.200
     1.289    22.508     0.200
     1.345    23.312     0.200
     1.412    22.984     0.200
     1.516    24.805     0.200
     1.846    30.133     0.200
     1.845    29.734     0.200
     2.110    33.258     0.200
     2.110    33.758     0.200
     2.253    33.703     0.200
     2.253    33.805     0.200
     2.426    38.305     0.200
     2.701    42.008     0.200
     4.568    67.906     0.200
     4.568    68.008     0.200
     4.660    70.008     0.200
     4.660    68.617     0.200
     4.660    70.148     0.200
     5.407    78.102     0.200
     6.815    99.805     0.200
     6.815    99.906     0.200
     6.853    98.297     0.200
     6.853    98.562     0.200
     6.853    98.703     0.200
     6.853    97.938     0.200
     8.015   114.234     0.200
     8.015   115.102     0.200
     8.246   118.703     0.200
     8.284   117.406     0.200
     8.284   118.203     0.200
     8.284   118.164     0.200
     8.284   118.305     0.200
     8.375   119.102     0.200
     8.375   119.516     0.200
     8.375   119.203     0.200
     8.505   120.258     0.200
     8.572   124.508     0.200
     8.572   123.906     0.200
     9.516   132.125     0.200
     9.516   132.203     0.200
    10.046   141.875     0.200
    10.046   143.102     0.200
    10.490   148.070     0.200
    10.490   149.602     0.200
    11.187   156.336     0.200
    11.187   160.258     0.200
    11.766   167.602     0.200
    12.299   169.602     0.200
    12.299   171.406     0.200
    12.604   177.508     0.200
    12.604   177.406     0.200
    12.604   176.773     0.200
    12.953   181.805     0.200
    13.130   182.703     0.200
    13.200   184.797     0.200
    13.272   185.031     0.200
    13.399   188.102     0.200
    13.476   187.305     0.200
    13.476   188.812     0.200
    13.485   187.727     0.200
    13.485   190.562     0.200
    13.485   188.805     0.200
    14.463   201.805     0.200
    14.612   199.531     0.200
    14.612   203.305     0.200
    14.612   199.898     0.200
    14.612   199.531     0.200
    14.722   202.688     0.200
    14.722   203.703     0.200
    14.994   206.305     0.200
    15.530   215.305     0.200
    16.600   228.805     0.200
    17.635   238.805     0.200
    17.704   241.453     0.200
     1.019    18.977     0.200
     1.095    19.977     0.200
     1.241    21.266     0.200
     1.617    27.855     0.200
     1.616    27.277     0.200
     1.616    27.438     0.200
     2.011    32.246     0.200
     2.543    38.309     0.200
     2.543    38.906     0.200
     2.911    46.207     0.200
     4.456    68.809     0.200
     4.456    69.309     0.200
     4.760    72.809     0.200
     4.760    72.309     0.200
     6.802    99.969     0.200
     6.801   100.246     0.200
     6.803   100.219     0.200
     7.828   114.047     0.200
     7.828   114.430     0.200
     7.828   114.238     0.200
     7.956   116.379     0.200
     8.310   121.379     0.200
     8.310   123.258     0.200
     9.606   134.777     0.200
    10.053   145.250     0.200
    10.053   146.207     0.200
    12.275   175.316     0.200
    12.276   172.398     0.200
    14.706   203.035     0.200
    14.706   208.137     0.200
    15.101   210.809     0.200
    15.118   213.809     0.200
    17.848   243.195     0.200
    20.542   282.707     0.200
     0.216     9.164     0.200
     0.190     8.963     0.200
     0.279    10.174     0.200
     0.279    10.164     0.200
     0.431    10.783     0.200
     0.425    11.283     0.200
     0.695    14.084     0.200
     0.878    16.902     0.200
     0.878    17.684     0.200
     0.942    16.143     0.200
     1.168    19.824     0.200
     1.284    22.324     0.200
     1.361    23.303     0.200
     1.441    23.643     0.200
     1.869    30.264     0.200
     1.868    29.664     0.200
     2.079    32.463     0.200
     2.282    34.164     0.200
     2.282    34.363     0.200
     2.457    39.562     0.200
     2.732    42.363     0.200
     4.599    68.963     0.200
     4.685    70.764     0.200
     4.685    68.393     0.200
     5.406    79.664     0.200
     6.821    96.732     0.200
     6.821    98.664     0.200
     6.821    98.602     0.200
     6.821    98.254     0.200
     7.983   112.744     0.200
     8.343   119.684     0.200
     8.598   124.164     0.200
     9.486   132.289     0.200
    10.496   148.006     0.200
    10.496   148.562     0.200
    12.579   177.463     0.200
    12.579   174.303     0.200
    17.703   242.148     0.200
     0.156     9.062     0.200
     0.249     9.572     0.200
     0.306    10.482     0.200
     0.307    10.633     0.200
     0.388    11.223     0.200
     0.442    11.082     0.200
     0.662    13.973     0.200
     0.841    17.303     0.200
     0.892    17.232     0.200
     0.918    16.213     0.200
     1.172    20.102     0.200
     1.247    22.053     0.200
     1.334    23.133     0.200
     1.567    25.373     0.200
     1.849    30.223     0.200
     1.848    30.123     0.200
     2.066    32.982     0.200
     2.304    34.473     0.200
     2.469    39.072     0.200
     2.748    42.271     0.200
     4.614    68.672     0.200
     4.614    68.973     0.200
     4.670    69.973     0.200
     4.670    68.082     0.200
     4.718    67.822     0.200
     5.370    77.373     0.200
     6.769    96.873     0.200
     6.822    99.973     0.200
     6.803    97.271     0.200
     6.814    98.043     0.200
     6.814    97.783     0.200
     6.814    97.672     0.200
     6.814    98.436     0.200
     6.814    97.342     0.200
     7.975   114.111     0.200
     7.975   113.312     0.200
     8.227   115.771     0.200
     8.237   116.713     0.200
     8.238   116.271     0.200
     8.237   118.109     0.200
     8.237   117.053     0.200
     8.471   121.453     0.200
     8.582   124.172     0.200
     9.490   131.547     0.200
     9.604   138.672     0.200
    10.000   139.412     0.200
    10.000   144.572     0.200
    10.461   148.115     0.200
    10.461   148.473     0.200
    10.978   155.873     0.200
    11.722   166.473     0.200
    12.343   172.973     0.200
    12.494   174.672     0.200
    12.511   175.072     0.200
    12.551   176.572     0.200
    12.551   174.592     0.200
    12.551   175.293     0.200
    12.905   179.873     0.200
    13.173   182.771     0.200
    13.150   185.611     0.200
    13.368   185.973     0.200
    13.423   187.373     0.200
    13.433   189.033     0.200
    13.433   186.883     0.200
    14.413   199.873     0.200
    14.652   202.672     0.200
    14.652   202.053     0.200
    14.652   203.672     0.200
    14.652   203.572     0.200
    14.652   201.473     0.200
    14.664   202.771     0.200
    14.676   202.902     0.200
    14.676   202.602     0.200
    15.035   207.271     0.200
    15.168   209.783     0.200
    15.168   208.498     0.200
    15.508   215.271     0.200
    17.597   239.572     0.200
    17.666   241.447     0.200
    19.550   264.203     0.200
     0.142     8.824     0.200
     0.270     9.523     0.200
     0.347     9.781     0.200
     0.306    10.453     0.200
     0.307    10.461     0.200
     0.307    10.234     0.200
     0.487    12.012     0.200
     0.718    14.574     0.200
     0.790    15.812     0.200
     0.925    15.812     0.200
     0.932    18.633     0.200
     1.089    18.914     0.200
     1.333    23.113     0.200
     1.351    23.305     0.200
     1.350    22.422     0.200
     1.454    23.633     0.200
     1.834    29.582     0.200
     1.833    30.031     0.200
     1.833    29.504     0.200
     2.168    33.895     0.200
     2.191    32.734     0.200
     2.191    33.234     0.200
     2.370    36.934     0.200
     2.642    40.832     0.200
     2.642    40.934     0.200
     4.509    67.434     0.200
     4.509    67.234     0.200
     4.640    69.734     0.200
     4.640    69.332     0.200
     4.640    70.023     0.200
     4.640    66.992     0.200
     4.640    70.234     0.200
     5.445    79.434     0.200
     6.860    98.832     0.200
     6.894   101.434     0.200
     6.906    98.992     0.200
     6.906    98.344     0.200
     6.906    98.234     0.200
     6.906    99.270     0.200
     6.906    98.902     0.200
     8.067   115.363     0.200
     8.067   115.023     0.200
     8.323   122.633     0.200
     8.333   116.652     0.200
     8.333   118.531     0.200
     8.334   122.133     0.200
     8.333   117.758     0.200
     8.428   121.582     0.200
     8.428   119.594     0.200
     8.428   121.434     0.200
     8.551   124.133     0.200
     8.553   119.812     0.200
     9.555   131.902     0.200
     9.621   138.832     0.200
    10.515   146.074     0.200
    10.515   148.633     0.200
    11.244   159.895     0.200
    11.812   167.434     0.200
    12.667   177.434     0.200
    12.667   176.281     0.200
    13.548   189.734     0.200
    14.558   203.434     0.200
    14.558   200.824     0.200
    14.558   199.734     0.200
    17.742   241.395     0.200
    19.651   265.453     0.200
     0.228     9.594     0.200
     0.178     9.242     0.200
     0.292    10.672     0.200
     0.291    10.633     0.200
     0.433    11.082     0.200
     0.411    11.441     0.200
     0.681    14.191     0.200
     0.881    17.164     0.200
     0.864    17.652     0.200
     0.931    16.301     0.200
     1.167    19.961     0.200
     1.270    22.332     0.200
     1.348    23.281     0.200
     1.447    23.992     0.200
     1.551    25.344     0.200
     1.859    29.516     0.200
     1.858    29.941     0.200
     2.076    32.953     0.200
     2.289    34.441     0.200
     2.736    42.641     0.200
     4.602    68.742     0.200
     4.677    70.141     0.200
     4.677    68.312     0.200
     6.821    98.617     0.200
     6.821    96.871     0.200
     8.260   120.344     0.200
     8.343   118.832     0.200
    12.570   177.250     0.200
     0.194     8.742     0.200
     0.208     9.023     0.200
     0.207     9.055     0.200
     0.284     9.492     0.200
     0.442    11.156     0.200
     0.543    11.906     0.200
     0.758    14.820     0.200
     0.897    17.891     0.200
     0.984    18.414     0.200
     1.037    17.656     0.200
     1.078    19.180     0.200
     1.282    21.492     0.200
     1.306    22.664     0.200
     1.633    26.086     0.200
     1.972    31.461     0.200
     1.971    32.781     0.200
     1.971    31.734     0.200
     1.976    31.711     0.200
     2.370    35.180     0.200
     2.370    35.586     0.200
     2.565    40.586     0.200
     2.565    40.281     0.200
     3.313    50.586     0.200
     4.700    70.484     0.200
     4.700    69.586     0.200
     4.794    71.281     0.200
     4.794    70.781     0.200
     4.794    70.156     0.200
     4.794    70.516     0.200
     6.946   100.586     0.200
     8.215   118.586     0.200
     8.272   116.984     0.200
     8.272   119.586     0.200
     8.272   117.984     0.200
     8.272   117.234     0.200
     8.707   126.586     0.200
     9.008   129.586     0.200
     9.715   138.484     0.200
    10.036   142.461     0.200
    10.036   142.852     0.200
    10.036   143.984     0.200
    10.549   148.578     0.200
    10.549   151.984     0.200
    11.768   166.586     0.200
    12.437   171.281     0.200
    12.511   175.430     0.200
    12.511   175.273     0.200
    12.511   175.844     0.200
    13.082   183.164     0.200
    13.269   182.180     0.200
    13.386   188.391     0.200
    13.449   186.586     0.200
    14.420   201.383     0.200
    14.589   200.141     0.200
    14.754   202.180     0.200
    14.754   202.680     0.200
    14.754   201.531     0.200
    15.606   216.086     0.200
    16.534   226.484     0.200
    17.659   240.586     0.200
    17.659   239.844     0.200
    17.731   241.633     0.200
    19.699   266.984     0.200
     0.162     9.098     0.200
     0.245     9.637     0.200
     0.318    10.676     0.200
     0.319    10.746     0.200
     0.319    10.598     0.200
     0.388    11.148     0.200
     0.427    10.977     0.200
     0.653    13.676     0.200
     0.840    17.117     0.200
     0.877    16.996     0.200
     0.904    15.887     0.200
     0.937    17.098     0.200
     1.156    19.777     0.200
     1.245    21.758     0.200
     1.321    22.809     0.200
     1.451    23.867     0.200
     1.555    25.199     0.200
     1.834    29.996     0.200
     1.833    29.887     0.200
     2.080    32.719     0.200
     2.292    34.297     0.200
     2.292    34.496     0.200
     2.454    38.898     0.200
     2.734    42.199     0.200
     3.233    49.398     0.200
     4.600    70.398     0.200
     4.654    69.996     0.200
     4.654    69.258     0.200
     6.830    98.938     0.200
     6.830    96.598     0.200
     6.830    98.547     0.200
     6.830    97.027     0.200
     7.991   114.938     0.200
     8.237   118.449     0.200
     8.237   116.609     0.200
     8.351   120.508     0.200
    10.454   146.664     0.200
    10.454   147.199     0.200
    12.561   176.297     0.200
     0.195     8.914     0.200
     0.216     9.375     0.200
     0.413    11.016     0.200
     0.322    10.742     0.200
     0.322    10.883     0.200
     0.321    10.723     0.200
     0.394    10.445     0.200
     0.663    13.453     0.200
     0.862    17.195     0.200
     0.899    15.375     0.200
     0.844    16.445     0.200
     0.920    16.562     0.200
     1.126    19.195     0.200
     1.265    21.703     0.200
     1.319    22.336     0.200
     1.416    23.324     0.200
     1.521    24.664     0.200
     1.823    29.289     0.200
     1.822    29.363     0.200
     1.822    29.465     0.200
     2.113    33.324     0.200
     2.113    33.176     0.200
     2.258    33.863     0.200
     2.258    33.965     0.200
     2.421    38.164     0.200
     2.700    41.465     0.200
     2.700    41.766     0.200
     4.567    67.965     0.200
     4.639    68.664     0.200
     4.639    68.863     0.200
     4.639    67.664     0.200
     5.382    76.965     0.200
     6.793    98.562     0.200
     6.861    98.086     0.200
     6.861    97.945     0.200
     6.861    98.164     0.200
     6.861    97.945     0.200
     8.022   113.895     0.200
     8.022   113.766     0.200
     8.226   118.363     0.200
     8.262   117.836     0.200
     8.262   118.465     0.200
     8.262   117.391     0.200
     8.262   117.723     0.200
     8.382   118.562     0.200
     8.382   118.457     0.200
     8.382   118.863     0.200
     8.551   123.766     0.200
     8.516   121.023     0.200
     8.516   121.176     0.200
     8.516   119.734     0.200
     9.028   129.164     0.200
     9.590   137.465     0.200
     9.531   130.762     0.200
     9.531   130.938     0.200
    10.023   142.613     0.200
    10.023   142.324     0.200
    10.023   143.965     0.200
    10.463   147.383     0.200
    10.463   148.062     0.200
    10.950   154.363     0.200
    11.239   158.266     0.200
    11.191   156.176     0.200
    11.191   156.676     0.200
    11.191   156.004     0.200
    11.743   166.465     0.200
    12.295   170.766     0.200
    12.594   176.715     0.200
    12.594   177.000     0.200
    12.594   176.383     0.200
    12.594   175.934     0.200
    12.932   181.164     0.200
    13.197   187.012     0.200
    13.273   184.641     0.200
    13.373   186.465     0.200
    13.465   187.965     0.200
    13.465   190.195     0.200
    13.465   185.695     0.200
    13.465   188.371     0.200
    13.465   187.766     0.200
    13.477   189.516     0.200
    13.477   189.723     0.200
    13.477   188.836     0.200
    14.445   201.062     0.200
    14.606   200.633     0.200
    14.606   202.062     0.200
    14.606   199.586     0.200
    14.723   202.742     0.200
    14.723   202.914     0.200
    14.723   202.586     0.200
    14.988   209.230     0.200
    14.988   205.953     0.200
    14.988   208.664     0.200
    15.504   213.266     0.200
    16.585   226.965     0.200
    17.610   240.465     0.200
    17.610   239.836     0.200
    17.679   240.750     0.200
     0.129     8.719     0.200
     0.272     9.930     0.200
     0.272     9.648     0.200
     0.271     9.918     0.200
     0.325    10.059     0.200
     0.376    10.699     0.200
     0.551    12.090     0.200
     0.699    14.051     0.200
     0.831    16.949     0.200
     1.000    18.551     0.200
     0.993    17.230     0.200
     1.051    18.551     0.200
     1.240    21.711     0.200
     1.282    21.391     0.200
     1.394    22.711     0.200
     1.411    23.590     0.200
     1.397    23.559     0.200
     1.665    26.348     0.200
     1.957    31.609     0.200
     1.957    31.777     0.200
     1.934    31.625     0.200
     1.933    31.590     0.200
     2.403    35.750     0.200
     2.403    36.051     0.200
     2.578    40.348     0.200
     2.854    44.148     0.200
     2.854    44.848     0.200
     4.721    71.348     0.200
     4.721    70.949     0.200
     4.761    71.051     0.200
     4.761    71.840     0.200
     5.371    78.051     0.200
     6.693   100.551     0.200
     6.704    97.879     0.200
     6.704    97.988     0.200
     6.704    98.148     0.200
     6.704    98.398     0.200
     6.704    97.668     0.200
     7.865   113.348     0.200
     7.865   114.000     0.200
     8.225   117.910     0.200
     8.225   117.590     0.200
     8.225   119.750     0.200
     8.208   115.238     0.200
     8.208   117.648     0.200
     8.208   116.324     0.200
     8.208   117.301     0.200
     8.674   126.551     0.200
     9.385   130.480     0.200
     9.384   131.250     0.200
    10.486   148.168     0.200
    10.486   148.051     0.200
    11.035   152.910     0.200
    12.466   174.801     0.200
    13.050   180.539     0.200
    13.119   183.324     0.200
    13.344   188.949     0.200
    13.344   186.750     0.200
    14.568   202.188     0.200
    14.763   205.340     0.200
    17.594   240.750     0.200
     0.237    10.408     0.200
     0.288    10.488     0.200
     0.330    10.408     0.200
     0.378    12.059     0.200
     0.455    12.729     0.200
     0.456    12.908     0.200
     0.557    13.229     0.200
     0.765    14.588     0.200
     0.779    15.938     0.200
     0.788    15.697     0.200
     0.798    17.127     0.200
     1.028    18.348     0.200
     1.190    21.348     0.200
     1.381    22.967     0.200
     1.410    24.668     0.200
     1.431    24.309     0.200
     1.488    24.297     0.200
     1.688    27.322     0.200
     1.688    27.998     0.200
     1.687    28.248     0.200
     1.687    27.967     0.200
     2.192    34.598     0.200
     2.192    34.287     0.200
     2.222    33.598     0.200
     2.222    33.797     0.200
     2.343    37.297     0.200
     2.343    37.398     0.200
     2.637    40.898     0.200
     2.637    41.197     0.200
     4.505    67.398     0.200
     4.505    67.998     0.200
     4.501    67.797     0.200
     4.501    67.498     0.200
     4.505    68.148     0.200
     4.505    67.137     0.200
     5.289    76.297     0.200
     6.945    99.697     0.200
     6.956    99.607     0.200
     6.956    99.148     0.200
     6.956    99.510     0.200
     8.115   115.348     0.200
     8.199   116.697     0.200
     8.199   116.398     0.200
     8.474   120.258     0.200
     8.474   120.668     0.200
     8.474   121.598     0.200
     8.621   125.498     0.200
     8.621   121.988     0.200
     8.988   128.098     0.200
     9.459   136.197     0.200
     9.651   133.658     0.200
     9.958   143.197     0.200
    10.351   146.490     0.200
    10.351   146.998     0.200
    10.816   150.998     0.200
    11.107   159.697     0.200
    11.270   156.547     0.200
    11.270   157.248     0.200
    11.669   164.998     0.200
    12.553   176.398     0.200
    12.570   176.598     0.200
    12.610   176.848     0.200
    12.610   175.787     0.200
    12.610   175.188     0.200
    12.878   181.398     0.200
    13.244   185.107     0.200
    13.265   183.998     0.200
    13.337   184.723     0.200
    13.476   186.898     0.200
    13.476   187.062     0.200
    13.500   189.857     0.200
    13.500   187.537     0.200
    13.500   188.998     0.200
    14.517   199.668     0.200
    14.517   200.373     0.200
    14.795   203.998     0.200
    14.795   202.697     0.200
    15.382   213.297     0.200
    16.569   226.998     0.200
    17.812   242.998     0.200
     0.527    12.418     0.200
     0.581    12.699     0.200
     0.581    12.539     0.200
     0.581    12.527     0.200
     0.632    12.520     0.200
     0.771    14.340     0.200
     0.915    16.508     0.200
     0.935    17.867     0.200
     1.131    19.539     0.200
     1.220    22.160     0.200
     1.724    29.359     0.200
     1.723    29.129     0.200
     1.793    28.508     0.200
     1.956    31.957     0.200
     1.956    31.527     0.200
     2.604    42.109     0.200
     2.604    41.109     0.200
     2.918    45.809     0.200
     2.918    46.207     0.200
     3.456    51.008     0.200
     4.563    69.410     0.200
     4.563    69.207     0.200
     4.563    70.000     0.200
     4.563    68.129     0.200
     4.563    70.109     0.200
     4.775    72.809     0.200
     4.775    72.207     0.200
     6.733    99.309     0.200
     6.742    99.797     0.200
     6.742    98.270     0.200
     7.898   115.828     0.200
     7.922   113.758     0.200
     7.922   113.957     0.200
     8.254   120.379     0.200
     8.254   118.820     0.200
     8.474   125.109     0.200
     8.474   124.508     0.200
     8.689   127.309     0.200
     9.515   134.539     0.200
    10.178   146.777     0.200
    10.178   145.910     0.200
    10.178   147.707     0.200
    10.838   156.910     0.200
    11.023   155.629     0.200
    12.302   176.410     0.200
    12.302   171.949     0.200
    12.302   171.590     0.200
    12.469   176.609     0.200
    13.076   185.410     0.200
    13.195   187.309     0.200
    14.751   208.508     0.200
    14.751   206.047     0.200
    14.751   206.285     0.200
    14.751   206.078     0.200
    15.245   213.008     0.200
    17.358   240.082     0.200
     0.163     8.734     0.200
     0.248     9.375     0.200
     0.361     9.906     0.200
     0.308    10.336     0.200
     0.309    10.328     0.200
     0.465    11.844     0.200
     0.702    14.469     0.200
     0.806    16.016     0.200
     0.919    16.727     0.200
     0.918    15.898     0.200
     0.912    18.516     0.200
     1.100    19.062     0.200
     1.313    23.078     0.200
     1.370    22.516     0.200
     1.474    23.922     0.200
     1.831    29.625     0.200
     1.830    29.977     0.200
     1.830    29.742     0.200
     2.151    33.812     0.200
     2.211    32.922     0.200
     2.211    33.227     0.200
     2.385    37.727     0.200
     2.385    37.828     0.200
     2.659    40.828     0.200
     2.659    41.227     0.200
     4.526    67.727     0.200
     4.526    67.523     0.200
     4.640    69.727     0.200
     4.640    69.625     0.200
     4.640    68.727     0.200
     5.427    78.125     0.200
     6.797    99.328     0.200
     6.892    98.867     0.200
     6.892    98.375     0.200
     6.892    97.922     0.200
     6.892    98.828     0.200
     6.892    96.648     0.200
     8.053   114.633     0.200
     8.053   113.875     0.200
     8.278   119.023     0.200
     8.313   118.242     0.200
     8.313   119.125     0.200
     8.313   119.102     0.200
     8.313   118.633     0.200
     8.414   119.438     0.200
     8.414   119.234     0.200
     8.414   121.133     0.200
     8.552   123.922     0.200
     8.542   120.875     0.200
     8.542   119.875     0.200
     9.081   129.828     0.200
     9.547   131.453     0.200
     9.547   131.453     0.200
     9.613   138.523     0.200
    10.074   143.422     0.200
    10.501   148.695     0.200
    10.501   149.227     0.200
    10.501   149.625     0.200
    10.957   152.328     0.200
    11.239   158.523     0.200
    11.228   157.273     0.200
    11.228   156.188     0.200
    11.792   165.922     0.200
    12.258   173.023     0.200
    12.646   177.523     0.200
    12.646   176.234     0.200
    12.646   177.016     0.200
    12.984   181.625     0.200
    13.090   181.625     0.200
    13.243   185.719     0.200
    13.243   184.969     0.200
    13.517   188.727     0.200
    13.527   189.617     0.200
    13.527   189.023     0.200
    14.498   202.125     0.200
    14.573   201.648     0.200
    14.573   202.922     0.200
    14.573   200.102     0.200
    14.763   203.695     0.200
    14.763   203.508     0.200
    14.954   205.023     0.200
    14.954   205.453     0.200
    14.954   205.625     0.200
    16.638   229.023     0.200
    17.655   239.422     0.200
    17.724   241.328     0.200
     0.084     5.844     0.200
     0.370     8.564     0.200
     0.395     9.514     0.200
     0.445    11.254     0.200
     0.600    12.363     0.200
     0.684    12.604     0.200
     0.752    14.654     0.200
     0.904    16.975     0.200
     1.007    17.975     0.200
     1.087    18.994     0.200
     1.085    19.754     0.200
     1.071    18.594     0.200
     1.109    18.895     0.200
     1.314    22.453     0.200
     1.755    27.465     0.200
     2.273    35.703     0.200
     2.452    37.064     0.200
     2.452    36.764     0.200
     2.759    43.764     0.200
     4.154    62.465     0.200
     4.154    61.965     0.200
     4.154    62.635     0.200
     4.154    61.283     0.200
     4.154    63.564     0.200
     4.189    60.389     0.200
     4.586    69.664     0.200
     4.586    71.664     0.200
     5.744    83.934     0.200
     7.065   103.154     0.200
     7.065   102.395     0.200
     7.065   101.777     0.200
     7.065   102.885     0.200
     7.748   110.689     0.200
     7.748   112.023     0.200
     8.062   117.164     0.200
     8.062   119.064     0.200
     8.215   119.154     0.200
     8.215   118.395     0.200
     8.566   123.754     0.200
     8.566   123.305     0.200
     8.566   125.363     0.200
     8.780   126.064     0.200
     8.780   125.844     0.200
     9.838   139.258     0.200
     9.838   142.164     0.200
     9.838   141.863     0.200
     9.899   137.363     0.200
    10.421   149.264     0.200
    11.294   162.453     0.200
    12.379   173.264     0.200
    13.295   186.238     0.200
    14.471   201.113     0.200
    14.471   201.545     0.200
    17.085   233.889     0.200
    17.555   239.457     0.200
     1.428    24.363     0.200
     1.428    24.391     0.200
     2.150    35.312     0.200
     2.536    39.062     0.200
     4.266    64.660     0.200
     4.695    72.961     0.200
     6.942   100.871     0.200
     6.942   101.664     0.200
     7.720   111.863     0.200
     8.091   116.070     0.200
     9.875   143.004     0.200
    12.287   175.812     0.200
    14.592   205.785     0.200
    14.592   203.441     0.200
    17.675   244.062     0.200
     0.272     9.771     0.200
     1.868    30.360     0.200
     1.867    30.131     0.200
     2.117    33.101     0.200
     4.713    68.689     0.200
     6.854    98.601     0.200
     6.854    99.370     0.200
     6.854    97.641     0.200
     8.016   112.041     0.200
     8.316   119.742     0.200
     8.377   120.211     0.200
     0.808    16.869     0.200
     0.808    16.329     0.200
     0.808    15.739     0.200
     1.974    31.270     0.200
     1.972    31.569     0.200
     1.972    31.069     0.200
     2.050    31.970     0.200
     2.800    43.020     0.200
     2.800    42.539     0.200
     3.905    58.170     0.200
     4.590    66.619     0.200
     4.623    66.144     0.200
     6.263    89.069     0.200
     7.443   106.430     0.200
     7.443   105.270     0.200
     7.443   106.270     0.200
     7.443   105.542     0.200
     8.608   125.819     0.200
     8.608   121.279     0.200
     8.974   126.329     0.200
     8.974   129.579     0.200
     8.974   127.779     0.200
     9.917   139.100     0.200
     9.919   137.709     0.200
    10.930   153.869     0.200
    11.839   166.119     0.200
    12.418   174.369     0.200
    13.383   186.973     0.200
    13.873   192.569     0.200
    14.026   192.840     0.200
    14.026   192.260     0.200
    15.405   212.179     0.200
    17.633   238.413     0.200
    17.633   238.220     0.200
     0.515    11.730     0.200
     1.966    30.578     0.200
     4.629    67.258     0.200
     6.746    96.938     0.200
     6.746    98.023     0.200
     7.903   114.250     0.200
     8.260   118.609     0.200
    11.038   156.578     0.200
    12.348   175.160     0.200
     0.316    10.367     0.200
     1.824    28.844     0.200
     1.823    29.531     0.200
     2.163    34.062     0.200
     2.163    33.820     0.200
     4.632    69.422     0.200
     4.666    67.742     0.200
     5.661    82.266     0.200
     6.903    96.906     0.200
     6.903    99.766     0.200
     6.903    99.070     0.200
     6.903    98.531     0.200
     8.065   115.102     0.200
     8.065   114.508     0.200
     8.317   118.219     0.200
     8.317   117.828     0.200
     8.426   118.789     0.200
    11.240   159.242     0.200
    11.240   157.195     0.200
    13.538   191.258     0.200
    14.561   201.062     0.200
    14.561   201.695     0.200
    14.561   200.641     0.200
     8.317   117.789     0.200
     0.273    10.082     0.200
     0.273     9.566     0.200
     0.273    10.543     0.200
     1.869    29.982     0.200
     1.869    29.680     0.200
     1.868    30.115     0.200
     2.113    33.305     0.200
     2.697    40.883     0.200
     4.680    69.582     0.200
     4.680    69.723     0.200
     4.680    69.043     0.200
     4.680    68.453     0.200
     4.714    68.582     0.200
     5.610    81.723     0.200
     6.850    98.217     0.200
     6.850    98.572     0.200
     6.850    98.252     0.200
     6.850    99.842     0.200
     8.012   113.898     0.200
     8.012   114.123     0.200
     8.012   114.232     0.200
     8.271   117.783     0.200
     8.310   118.492     0.200
     8.310   118.770     0.200
     8.373   118.436     0.200
     8.373   118.693     0.200
     8.373   119.264     0.200
     9.071   130.082     0.200
     9.504   132.381     0.200
     9.504   132.992     0.200
     9.504   131.064     0.200
    10.073   143.100     0.200
    10.073   143.332     0.200
    10.519   149.383     0.200
    10.519   148.707     0.200
    11.188   156.221     0.200
    11.188   155.893     0.200
    12.298   169.883     0.200
    12.619   177.232     0.200
    12.619   177.133     0.200
    12.619   177.242     0.200
    12.979   181.383     0.200
    13.209   185.168     0.200
    13.209   184.322     0.200
    13.277   185.434     0.200
    13.428   186.383     0.200
    13.499   188.783     0.200
    13.499   189.033     0.200
    13.499   189.463     0.200
    13.492   188.383     0.200
    13.492   186.113     0.200
    14.487   201.383     0.200
    14.614   201.152     0.200
    14.614   200.727     0.200
    14.725   202.947     0.200
    14.725   203.223     0.200
    14.995   207.582     0.200
    15.164   206.951     0.200
    15.164   206.492     0.200
    15.164   207.707     0.200
    15.559   216.082     0.200
    16.620   227.883     0.200
    17.664   238.963     0.200
    17.733   241.795     0.200
    17.733   241.652     0.200
     8.311   118.152     0.200
     0.302    10.438     0.200
     0.303    10.090     0.200
     0.303    10.199     0.200
     0.303     9.977     0.200
     1.843    30.090     0.200
     1.842    30.289     0.200
     1.842    29.859     0.200
     2.099    33.438     0.200
     2.099    32.848     0.200
     2.714    41.688     0.200
     4.659    69.090     0.200
     4.659    68.758     0.200
     4.693    69.965     0.200
     5.598    81.680     0.200
     6.844    98.527     0.200
     6.844    98.309     0.200
     6.844    97.988     0.200
     6.844    98.938     0.200
     8.005   115.039     0.200
     8.005   114.059     0.200
     8.229   117.488     0.200
     8.267   116.938     0.200
     8.267   119.242     0.200
     8.365   120.848     0.200
     8.365   119.258     0.200
     9.030   127.387     0.200
     9.512   131.539     0.200
    10.030   142.020     0.200
    10.478   147.188     0.200
    10.478   149.531     0.200
    11.176   158.078     0.200
    11.176   155.277     0.200
    12.588   177.188     0.200
    12.588   176.270     0.200
    12.937   181.789     0.200
    13.186   185.719     0.200
    13.260   184.789     0.200
    13.470   190.090     0.200
    13.470   190.297     0.200
    13.470   189.617     0.200
    14.622   204.430     0.200
    14.622   204.137     0.200
    14.622   203.836     0.200
    14.709   203.566     0.200
    15.004   207.387     0.200
    15.182   207.312     0.200
    15.520   215.488     0.200
    17.621   240.680     0.200
    17.690   241.488     0.200
    17.690   241.000     0.200
     8.268   116.449     0.200
     1.459    27.805     0.200
     2.322    39.461     0.200
     4.237    67.961     0.200
     4.237    64.562     0.200
     4.271    67.062     0.200
     7.291   107.320     0.200
     7.291   108.023     0.200
     7.291   110.961     0.200
     8.451   123.133     0.200
     8.809   130.195     0.200
    10.291   147.461     0.200
    10.291   152.055     0.200
    15.276   217.164     0.200
     0.298     9.963     0.200
     0.298     9.767     0.200
     1.842    30.263     0.200
     1.842    30.669     0.200
     1.842    30.242     0.200
     2.147    33.896     0.200
     2.147    33.763     0.200
     2.663    41.363     0.200
     4.530    67.863     0.200
     4.651    69.062     0.200
     4.651    69.402     0.200
     4.651    69.533     0.200
     4.651    68.383     0.200
     4.685    70.397     0.200
     5.645    82.333     0.200
     6.885    98.588     0.200
     6.885    98.763     0.200
     6.885    98.863     0.200
     6.885    99.460     0.200
     8.047   114.910     0.200
     8.047   115.053     0.200
     8.047   114.763     0.200
     8.284   120.363     0.200
     8.319   118.943     0.200
     8.319   120.175     0.200
     8.408   119.562     0.200
     8.408   119.763     0.200
     8.828   127.863     0.200
     9.086   130.562     0.200
     9.538   132.005     0.200
     9.538   131.873     0.200
     9.538   132.613     0.200
     9.538   132.334     0.200
    10.081   143.971     0.200
    10.081   142.943     0.200
    10.511   149.663     0.200
    10.511   149.506     0.200
    11.223   157.213     0.200
    11.223   156.653     0.200
    12.263   172.863     0.200
    12.646   177.763     0.200
    12.646   177.785     0.200
    12.646   177.333     0.200
    12.646   177.573     0.200
    13.241   185.842     0.200
    13.311   185.113     0.200
    13.518   189.377     0.200
    13.518   188.993     0.200
    13.518   187.982     0.200
    13.527   190.427     0.200
    13.527   190.583     0.200
    13.527   190.293     0.200
    14.579   201.652     0.200
    14.759   203.834     0.200
    14.759   204.093     0.200
    14.759   204.243     0.200
    15.195   209.423     0.200
    15.195   209.647     0.200
    17.664   239.945     0.200
    17.664   240.803     0.200
    17.733   241.866     0.200
     8.320   119.143     0.200
     5.399    83.591     0.200
     6.636   100.481     0.200
     6.636   100.351     0.200
     7.798   116.591     0.200
     8.159   122.181     0.200
    14.517   205.151     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     3.169    58.684     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.099     5.590     0.200
     0.206     6.390     0.200
     1.556    27.790     0.200
     0.167     5.902     0.200
     0.253     6.803     0.200
     0.769    14.803     0.200
     1.498    26.703     0.200
     1.812    30.703     0.200
     0.050     4.695     0.200
     0.452    10.094     0.200
     0.115     6.160     0.200
     0.262     6.258     0.200
     0.678    11.441     0.200
     0.740    14.441     0.200
     0.112     3.595     0.200
     0.545     9.995     0.200
     1.649    29.995     0.200
     1.547    29.995     0.200
     1.891    33.995     0.200
     3.082    52.995     0.200
     0.122     5.359     0.200
     0.161     5.650     0.200
     0.591    11.551     0.200
     0.925    17.150     0.200
     1.303    22.650     0.200
     1.647    28.251     0.200
     1.938    32.950     0.200
     0.090     4.874     0.200
     1.574    27.474     0.200
     3.292    56.374     0.200
     0.106     4.939     0.200
     0.792    15.039     0.200
     0.124     6.021     0.200
     1.544    28.021     0.200
     0.078     5.328     0.200
     1.518    27.729     0.200
     1.655    28.729     0.200
     0.074     4.645     0.200
     0.033     4.930     0.200
     0.832    15.730     0.200
     1.465    27.930     0.200
     0.159     6.039     0.200
     0.078     4.285     0.200
     2.180    36.984     0.200
     0.240     7.031     0.200
     1.583    29.332     0.200
     0.037     4.562     0.200
     0.470    10.359     0.200
     0.843    15.961     0.200
     0.243     7.119     0.200
     0.192     5.578     0.200
     1.570    28.680     0.200
     0.118     5.023     0.200
     1.460    25.125     0.200
     0.184     6.268     0.200
     0.929    17.168     0.200
     0.170     5.158     0.200
     0.863    16.258     0.200
     0.267     7.293     0.200
     1.297    23.492     0.200
     0.166     4.635     0.200
     0.494    10.535     0.200
     2.111    36.635     0.200
     0.154     5.305     0.200
     0.450    10.105     0.200
     0.028     4.932     0.200
     1.652    29.632     0.200
     1.985    34.132     0.200
     0.037     5.133     0.200
     0.150     5.477     0.200
     0.437     9.977     0.200
     3.379    56.977     0.200
     0.074     3.148     0.200
     0.390     8.750     0.200
     0.753    14.648     0.200
     0.125     5.785     0.200
     0.250     7.539     0.200
     1.154    20.141     0.200
     1.490    25.641     0.200
     0.070     6.373     0.200
     0.367     7.873     0.200
     0.173     5.986     0.200
     0.270     7.285     0.200
     3.240    54.586     0.200
     0.248     6.883     0.200
     0.088     5.777     0.200
     0.521    10.977     0.200
     0.083     5.539     0.200
     0.088     6.480     0.200
     0.351     8.480     0.200
     0.372     7.780     0.200
     0.169     4.332     0.200
     0.253     6.732     0.200
     0.211     6.531     0.200
     0.346     8.328     0.200
     0.168     4.465     0.200
     0.500    10.465     0.200
     0.593    11.664     0.200
     0.670    12.562     0.200
     0.820    15.363     0.200
     0.911    16.664     0.200
     1.903    33.762     0.200
     0.167     3.137     0.200
     0.503    10.535     0.200
     0.591    11.637     0.200
     0.673    12.637     0.200
     0.820    15.438     0.200
     0.911    16.637     0.200
     1.257    22.938     0.200
     1.905    33.535     0.200
     2.505    42.238     0.200
     0.230     5.977     0.200
     0.020     5.238     0.200
     0.444     9.505     0.200
     0.695    12.605     0.200
     0.895    16.005     0.200
     0.992    18.905     0.200
     1.258    23.505     0.200
     1.592    28.705     0.200
     2.189    37.305     0.200
     0.263     5.871     0.200
     0.264     6.273     0.200
     0.692    12.371     0.200
     0.753    14.172     0.200
     0.776    14.273     0.200
     1.107    21.074     0.200
     1.448    26.172     0.200
     0.260     6.849     0.200
     0.281     7.249     0.200
     0.199     6.242     0.200
     0.307     8.938     0.200
     0.247     6.475     0.200
     0.636    11.975     0.200
     0.698    12.775     0.200
     0.105     5.211     0.200
     0.635    11.910     0.200
     0.208     6.312     0.200
     0.373     8.109     0.200
     0.071     4.762     0.200
     0.329     7.562     0.200
     0.445     8.636     0.200
     0.706    13.636     0.200
     1.255    22.536     0.200
     1.203    23.736     0.200
     1.203    23.286     0.200
     1.823    31.736     0.200
     1.823    31.856     0.200
     0.518    10.336     0.200
     0.680    13.031     0.200
     0.852    14.336     0.200
     3.409    59.531     0.200
     4.169    70.734     0.200
     4.169    71.734     0.200
     0.121     4.891     0.200
     0.510     9.992     0.200
     0.510     9.992     0.200
     0.502     9.691     0.200
     0.648    12.191     0.200
     0.404     8.795     0.200
     0.434    10.595     0.200
     0.588    11.395     0.200
     0.689    12.695     0.200
     0.690    12.795     0.200
     0.690    13.025     0.200
     0.707    13.095     0.200
     0.708    13.395     0.200
     1.138    21.395     0.200
     0.200     3.820     0.200
     0.542    10.117     0.200
     0.542     9.914     0.200
     0.749    13.719     0.200
     0.932    17.516     0.200
     0.196     3.871     0.200
     0.486    10.273     0.200
     0.486    10.172     0.200
     0.486    10.172     0.200
     0.624    11.371     0.200
     0.757    13.672     0.200
     0.148     3.410     0.200
     0.462    10.010     0.200
     0.462     9.709     0.200
     0.603    11.109     0.200
     0.709    13.410     0.200
     0.965    17.510     0.200
     0.193     6.324     0.200
     0.274     7.422     0.200
     0.230     5.570     0.200
     0.310     5.770     0.200
     0.776    14.770     0.200
     0.916    16.871     0.200
     1.009    17.971     0.200
     1.009    17.871     0.200
     1.426    28.371     0.200
     1.426    27.641     0.200
     1.426    27.471     0.200
     1.434    27.570     0.200
     0.096     5.210     0.200
     0.371     9.410     0.200
     0.898    16.610     0.200
     0.078     5.207     0.200
     0.372     9.309     0.200
     0.754    14.008     0.200
     0.805    14.707     0.200
     1.177    21.008     0.200
     0.310     8.082     0.200
     0.367     8.480     0.200
     0.585    12.562     0.200
     0.585    12.180     0.200
     0.760    15.191     0.200
     0.831    15.652     0.200
     0.185     5.910     0.200
     0.286     8.020     0.200
     0.390     8.219     0.200
     0.067     6.176     0.200
     0.320     7.648     0.200
     0.473    10.426     0.200
     0.398     9.898     0.200
     0.706    13.195     0.200
     0.706    14.098     0.200
     0.842    16.488     0.200
     0.010     4.930     0.200
     0.410     9.750     0.200
     0.722    13.648     0.200
     0.899    17.711     0.200
     1.121    20.531     0.200
     1.563    27.023     0.200
     1.563    27.000     0.200
     1.952    34.102     0.200
     0.086     5.242     0.200
     0.432     8.633     0.200
     0.705    13.109     0.200
     1.092    19.508     0.200
     1.856    31.453     0.200
     0.191     6.797     0.200
     0.315     7.539     0.200
     0.595    11.539     0.200
     0.722    14.758     0.200
     0.748    14.297     0.200
     1.213    21.484     0.200
     1.388    24.188     0.200
     0.110     6.289     0.200
     0.291     7.562     0.200
     0.079     5.781     0.200
     0.339     7.602     0.200
     0.064     5.578     0.200
     0.320     7.414     0.200
     0.718    13.516     0.200
     1.072    20.125     0.200
     1.117    20.258     0.200
     1.508    26.055     0.200
     1.509    26.055     0.200
     2.006    33.961     0.200
     0.076     5.781     0.200
     0.311     7.570     0.200
     0.046     5.438     0.200
     0.324     7.336     0.200
     0.704    13.414     0.200
     0.865    17.102     0.200
     1.102    19.555     0.200
     1.102    20.305     0.200
     1.093    20.281     0.200
     0.012     5.742     0.200
     0.186     6.727     0.200
     0.303     7.391     0.200
     0.010     5.969     0.200
     0.188     6.844     0.200
     0.308     7.266     0.200
     0.076     5.779     0.200
     0.326     7.489     0.200
     0.691    13.979     0.200
     0.834    16.559     0.200
     1.056    19.469     0.200
     1.134    19.769     0.200
     0.081     5.718     0.200
     0.343     7.868     0.200
     0.017     5.148     0.200
     0.371     8.358     0.200
     0.699    13.188     0.200
     0.926    18.019     0.200
     0.973    17.729     0.200
     1.093    19.278     0.200
     1.247    22.269     0.200
     0.028     5.146     0.200
     0.379     8.346     0.200
     0.449     9.916     0.200
     0.421     9.967     0.200
     0.659    12.807     0.200
     0.757    13.945     0.200
     0.772    15.156     0.200
     0.963    17.406     0.200
     0.937    18.037     0.200
     0.171     6.594     0.200
     0.312     7.434     0.200
     0.364     9.215     0.200
     0.546    11.234     0.200
     0.741    15.014     0.200
     0.074     5.574     0.200
     0.327     7.564     0.200
     0.692    13.814     0.200
     0.835    16.533     0.200
     1.057    19.205     0.200
     1.500    25.895     0.200
     0.008     5.148     0.200
     0.367     8.055     0.200
     0.666    13.102     0.200
     0.703    13.117     0.200
     0.755    14.984     0.200
     0.980    17.859     0.200
     0.916    17.727     0.200
     1.097    20.945     0.200
     0.109     5.922     0.200
     0.321     7.430     0.200
     0.014     5.695     0.200
     0.102     5.617     0.200
     0.316     7.526     0.200
     0.130     6.242     0.200
     0.291     7.074     0.200
     0.498    10.664     0.200
     0.665    13.613     0.200
     0.779    15.633     0.200
     1.011    18.703     0.200
     1.144    20.062     0.200
     0.057     5.637     0.200
     0.329     7.527     0.200
     0.084     5.469     0.200
     0.331     7.520     0.200
     0.168     6.391     0.200
     0.288     6.852     0.200
     0.741    14.922     0.200
     0.973    18.141     0.200
     0.107     5.672     0.200
     0.297     6.984     0.200
     0.051     5.546     0.200
     0.329     7.526     0.200
     1.014    19.008     0.200
     1.077    21.488     0.200
     0.062     5.484     0.200
     0.327     7.477     0.200
     0.846    16.727     0.200
     1.070    19.812     0.200
     1.510    26.203     0.200
     0.029     4.969     0.200
     0.378     8.250     0.200
     0.661    12.844     0.200
     0.938    18.148     0.200
     1.241    22.125     0.200
     0.088     5.711     0.200
     0.309     7.266     0.200
     0.355     7.445     0.200
     0.338     7.815     0.200
     0.680    12.576     0.200
     0.809    16.216     0.200
     1.016    19.105     0.200
     1.185    22.616     0.200
     1.185    22.886     0.200
     0.197     6.699     0.200
     0.300     7.152     0.200
     0.057     5.473     0.200
     0.326     7.484     0.200
     1.117    20.973     0.200
     2.000    34.113     0.200
     0.009     5.066     0.200
     0.365     8.066     0.200
     0.669    12.965     0.200
     0.917    17.824     0.200
     1.095    19.246     0.200
     0.104     5.734     0.200
     0.295     6.961     0.200
     0.727    13.578     0.200
     0.733    13.789     0.200
     1.127    21.008     0.200
     0.078     5.758     0.200
     0.325     7.479     0.200
     0.048     4.859     0.200
     0.339     7.609     0.200
     0.391     9.320     0.200
     1.123    20.453     0.200
     1.989    33.398     0.200
     0.179     6.512     0.200
     0.312     7.162     0.200
     0.610    12.682     0.200
     0.733    14.652     0.200
     0.955    17.982     0.200
     0.109     5.645     0.200
     0.360     8.477     0.200
     0.519    12.285     0.200
     0.655    13.547     0.200
     0.766    15.375     0.200
     1.166    21.777     0.200
     1.165    21.527     0.200
     3.158    54.215     0.200
     0.041     5.625     0.200
     0.326     7.562     0.200
     0.149     6.328     0.200
     0.305     7.156     0.200
     0.091     5.852     0.200
     0.366     9.391     0.200
     0.614    12.232     0.200
     0.500    10.771     0.200
     0.711    13.871     0.200
     1.010    18.381     0.200
     1.010    18.771     0.200
     1.010    18.902     0.200
     1.010    18.402     0.200
     1.010    19.461     0.200
     0.825    15.842     0.200
     0.983    17.691     0.200
     0.201     6.625     0.200
     0.242     7.186     0.200
     1.145    21.325     0.200
     2.142    35.965     0.200
     0.053     5.094     0.200
     0.403     9.680     0.200
     0.727    13.789     0.200
     0.708    13.180     0.200
     0.798    15.359     0.200
     1.020    18.156     0.200
     1.047    19.305     0.200
     1.047    18.930     0.200
     1.046    18.883     0.200
     0.996    17.844     0.200
     1.400    24.125     0.200
     0.066     5.654     0.200
     0.324     7.465     0.200
     0.036     5.762     0.200
     0.010     5.250     0.200
     0.352     7.918     0.200
     0.679    13.199     0.200
     0.749    14.887     0.200
     0.902    17.637     0.200
     0.997    17.977     0.200
     1.096    19.680     0.200
     1.265    22.578     0.200
     1.950    33.879     0.200
     0.003     5.309     0.200
     0.360     8.078     0.200
     0.411     9.898     0.200
     0.454    10.195     0.200
     0.672    13.168     0.200
     0.703    13.238     0.200
     0.731    13.578     0.200
     0.751    14.926     0.200
     0.908    17.707     0.200
     0.989    17.926     0.200
     1.098    20.016     0.200
     0.079     4.520     0.200
     0.415     8.260     0.200
     0.442     9.830     0.200
     0.443    10.040     0.200
     0.640    12.990     0.200
     0.686    13.220     0.200
     0.802    14.360     0.200
     0.988    18.770     0.200
     1.074    19.740     0.200
     1.074    20.450     0.200
     1.074    20.050     0.200
     1.074    20.260     0.200
     1.863    31.950     0.200
     4.450    74.450     0.200
     0.211     6.855     0.200
     0.311     7.254     0.200
     0.366     9.266     0.200
     0.763    14.145     0.200
     0.115     5.562     0.200
     0.404     9.332     0.200
     1.129    20.605     0.200
     0.065     5.375     0.200
     0.331     7.508     0.200
     0.699    14.047     0.200
     0.845    16.852     0.200
     1.067    19.531     0.200
     1.129    20.273     0.200
     1.129    19.938     0.200
     1.509    26.078     0.200
     0.140     6.191     0.200
     0.299     7.141     0.200
     0.383     9.492     0.200
     0.513    10.973     0.200
     0.616    11.781     0.200
     0.650    13.340     0.200
     0.769    15.422     0.200
     0.758    14.109     0.200
     0.739    13.973     0.200
     0.997    18.340     0.200
     1.252    21.723     0.200
     1.238    21.750     0.200
     1.433    24.910     0.200
     1.433    24.730     0.200
     1.433    24.902     0.200
     1.641    28.000     0.200
     0.148     5.891     0.200
     0.315     7.133     0.200
     0.365     9.230     0.200
     0.763    15.422     0.200
     2.756    46.051     0.200
     0.135     6.297     0.200
     0.327     7.516     0.200
     0.130     5.805     0.200
     0.308     7.023     0.200
     0.377     9.117     0.200
     0.628    11.844     0.200
     0.780    15.465     0.200
     1.159    20.977     0.200
     1.445    25.195     0.200
     1.445    25.246     0.200
     2.758    45.945     0.200
     0.319     7.098     0.200
     0.245     5.555     0.200
     0.413     8.285     0.200
     0.513    10.266     0.200
     0.477     9.156     0.200
     0.763    14.188     0.200
     0.881    16.445     0.200
     0.879    16.926     0.200
     0.914    17.676     0.200
     1.007    18.227     0.200
     0.188     6.777     0.200
     0.316     7.375     0.200
     0.359     9.195     0.200
     0.034     5.080     0.200
     0.345     7.699     0.200
     0.422     9.699     0.200
     0.443    10.158     0.200
     0.671    12.879     0.200
     0.694    13.449     0.200
     0.780    15.158     0.200
     0.920    17.898     0.200
     0.994    18.250     0.200
     1.065    19.029     0.200
     1.066    18.969     0.200
     0.279     6.899     0.200
     0.396     8.310     0.200
     0.396     8.479     0.200
     0.396     8.359     0.200
     0.650    12.310     0.200
     1.744    30.210     0.200
     0.142     5.547     0.200
     0.317     8.398     0.200
     0.367     7.945     0.200
     0.670    12.633     0.200
     1.458    24.945     0.200
     0.065     5.348     0.200
     0.379     8.105     0.200
     0.738    13.578     0.200
     0.913    17.457     0.200
     0.092     4.926     0.200
     0.304     7.238     0.200
     0.288     6.617     0.200
     0.667    12.586     0.200
     0.703    13.605     0.200
     0.667    12.285     0.200
     0.704    13.566     0.200
     0.704    13.738     0.200
     1.081    19.348     0.200
     2.582    43.105     0.200
     0.073     5.027     0.200
     0.413     8.609     0.200
     1.069    19.457     0.200
     0.291     7.141     0.200
     0.493    10.152     0.200
     0.710    14.402     0.200
     0.719    13.312     0.200
     0.921    17.613     0.200
     0.884    17.141     0.200
     0.885    16.891     0.200
     1.026    18.551     0.200
     1.428    24.613     0.200
     0.716    14.164     0.200
     1.904    33.111     0.200
     2.904    50.651     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.147    15.719     0.200
     0.147    15.820     0.200
     0.147    15.617     0.200
     0.287    18.016     0.200
     0.287    17.617     0.200
     0.719    24.117     0.200
     1.247    36.617     0.200
     1.192    36.719     0.200
     1.192    36.617     0.200
     1.623    44.117     0.200
     1.623    43.617     0.200
     1.671    47.320     0.200
     1.671    47.617     0.200
     1.834    50.719     0.200
     1.834    50.617     0.200
     1.930    52.914     0.200
     1.930    52.617     0.200
     1.989    56.516     0.200
     1.989    56.617     0.200
     2.079    59.117     0.200
     2.079    58.617     0.200
     2.112    57.914     0.200
     2.112    57.617     0.200
     2.261    60.414     0.200
     2.261    60.617     0.200
     2.710    70.414     0.200
     2.710    70.719     0.200
     2.710    70.617     0.200
     2.924    80.117     0.200
     2.924    79.617     0.200
     3.384    98.617     0.200
     3.396    93.516     0.200
     3.430    93.617     0.200
     4.032   106.219     0.200
     4.032   106.617     0.200
     4.149   110.219     0.200
     4.149   110.617     0.200
     4.301   113.820     0.200
     4.301   113.617     0.200
     4.494   115.516     0.200
     4.494   115.617     0.200
     4.760   122.617     0.200
     5.532   144.516     0.200
     5.552   142.117     0.200
     6.178   157.617     0.200
     6.196   156.617     0.200
     6.392   163.516     0.200
     6.392   163.617     0.200
     6.606   172.719     0.200
     6.606   172.617     0.200
     6.721   172.219     0.200
     6.721   172.617     0.200
     7.025   178.320     0.200
     7.025   177.516     0.200
     7.025   177.617     0.200
     7.288   186.117     0.200
     7.288   185.617     0.200
     7.521   193.617     0.200
     7.823   195.820     0.200
     7.823   195.617     0.200
     7.998   197.617     0.200
     9.767   250.219     0.200
     9.767   247.820     0.200
     9.767   250.617     0.200
     0.469    20.873     0.200
     0.764    27.473     0.200
     0.878    30.473     0.200
     1.788    48.473     0.200
     1.884    52.473     0.200
     1.884    52.973     0.200
     2.204    57.473     0.200
     2.424    65.473     0.200
     2.518    68.273     0.200
     2.532    69.473     0.200
     2.532    69.072     0.200
     2.790    76.473     0.200
     3.034    80.473     0.200
     3.034    80.273     0.200
     3.533    87.473     0.200
     3.335    89.473     0.200
     3.880   106.473     0.200
     3.880   106.773     0.200
     4.353   111.473     0.200
     4.748   120.473     0.200
     4.598   122.473     0.200
     4.647   120.473     0.200
     4.878   128.473     0.200
     5.250   139.473     0.200
     5.826   152.473     0.200
     6.484   164.473     0.200
     6.541   166.473     0.200
     6.709   169.473     0.200
     6.756   171.473     0.200
     6.981   179.473     0.200
     7.302   190.473     0.200
     7.351   187.473     0.200
     7.612   195.473     0.200
     7.829   201.473     0.200
     7.829   201.773     0.200
     7.889   204.473     0.200
     7.889   204.273     0.200
     8.046   207.473     0.200
     8.028   205.473     0.200
     8.028   205.273     0.200
     8.164   206.473     0.200
     8.164   206.873     0.200
     8.320   208.473     0.200
     8.489   211.473     0.200
     8.489   211.273     0.200
     8.651   222.473     0.200
     8.651   222.072     0.200
     8.868   228.473     0.200
     8.868   228.773     0.200
     8.958   232.473     0.200
     9.029   232.473     0.200
     9.029   232.973     0.200
     9.226   237.473     0.200
     9.527   244.473     0.200
     9.581   244.973     0.200
     9.739   239.473     0.200
    10.163   257.773     0.200
    10.226   261.473     0.200
    10.226   261.773     0.200
    10.231   260.473     0.200
    12.003   304.473     0.200
    12.003   304.172     0.200
    12.137   299.473     0.200
    12.137   299.672     0.200
    13.729   337.473     0.200
    13.857   348.473     0.200
    13.857   348.172     0.200
    16.004   395.473     0.200
    16.004   395.873     0.200
    17.807   435.473     0.200
    20.849   520.473     0.200
    20.862   520.672     0.200
     0.123    14.656     0.200
     0.339    17.656     0.200
     0.734    24.656     0.200
     1.162    34.656     0.200
     1.706    47.656     0.200
     1.679    45.656     0.200
     1.884    52.656     0.200
     1.983    57.656     0.200
     2.112    56.656     0.200
     2.076    56.656     0.200
     2.100    56.656     0.200
     2.295    63.656     0.200
     2.939    78.656     0.200
     3.328    87.656     0.200
     3.441    92.656     0.200
     4.037   104.656     0.200
     4.310   114.656     0.200
     4.507   117.656     0.200
     4.906   130.656     0.200
     5.561   142.656     0.200
     6.183   158.656     0.200
     6.205   157.656     0.200
     6.732   172.656     0.200
     6.850   180.656     0.200
     6.977   179.656     0.200
     7.032   177.656     0.200
     7.884   204.656     0.200
    18.013   444.656     0.200
     0.178    15.983     0.200
     0.764    24.983     0.200
     1.221    35.983     0.200
     1.629    43.983     0.200
     1.715    48.983     0.200
     1.826    50.983     0.200
     2.030    56.983     0.200
     2.044    57.983     0.200
     2.136    56.983     0.200
     2.235    60.983     0.200
     2.886    77.983     0.200
     3.282    86.983     0.200
     3.990   102.983     0.200
     4.260   112.983     0.200
     4.591   121.983     0.200
     4.806   125.983     0.200
     4.856   127.983     0.200
     5.511   140.983     0.200
     6.136   156.983     0.200
     6.155   156.983     0.200
     6.350   161.983     0.200
     6.795   173.983     0.200
     0.122    18.117     0.200
     0.739    24.117     0.200
     1.157    35.117     0.200
     1.713    46.117     0.200
     1.690    46.117     0.200
     1.893    52.117     0.200
     1.982    55.117     0.200
     2.121    57.117     0.200
     2.069    56.117     0.200
     2.103    59.117     0.200
     2.301    64.117     0.200
     2.942    79.117     0.200
     3.430    87.117     0.200
     3.328    87.117     0.200
     3.443    94.117     0.200
     6.183   158.117     0.200
     6.853   181.117     0.200
     8.425   217.117     0.200
     0.129    15.195     0.200
     0.309    18.195     0.200
     0.716    24.195     0.200
     1.173    35.195     0.200
     1.645    45.195     0.200
     1.677    47.195     0.200
     1.856    51.195     0.200
     1.978    55.195     0.200
     2.079    55.195     0.200
     2.092    56.195     0.200
     2.094    59.195     0.200
     2.261    62.195     0.200
     2.280    63.195     0.200
     2.720    73.195     0.200
     2.938    79.195     0.200
     3.143    82.195     0.200
     3.334    88.195     0.200
     3.442    94.195     0.200
     4.312   112.195     0.200
     4.543   120.195     0.200
     4.646   124.195     0.200
     4.760   122.195     0.200
     5.563   142.195     0.200
     6.188   157.195     0.200
     6.402   163.195     0.200
     6.920   177.195     0.200
     7.693   191.195     0.200
     9.205   235.195     0.200
     0.233    17.090     0.200
     0.197    16.090     0.200
     0.733    25.090     0.200
     1.239    38.090     0.200
     1.571    43.090     0.200
     1.662    48.090     0.200
     1.779    50.090     0.200
     2.049    55.090     0.200
     2.020    58.090     0.200
     2.040    58.090     0.200
     2.192    59.090     0.200
     2.162    59.090     0.200
     2.212    60.090     0.200
     2.739    74.090     0.200
     2.888    77.090     0.200
     3.213    85.090     0.200
     3.398    92.090     0.200
     4.767   124.090     0.200
     6.924   178.090     0.200
     8.306   213.090     0.200
     0.110    16.047     0.200
     0.970    31.047     0.200
     1.687    46.047     0.200
     1.829    51.047     0.200
     2.072    55.047     0.200
     2.285    62.047     0.200
     2.475    69.047     0.200
     2.929    78.047     0.200
     3.612    97.047     0.200
     4.340   119.047     0.200
     4.696   119.047     0.200
     7.101   180.047     0.200
     7.486   188.047     0.200
     0.178    17.658     0.200
     0.599    21.658     0.200
     0.964    30.658     0.200
     1.197    32.658     0.200
     1.374    38.658     0.200
     1.690    46.658     0.200
     1.618    46.658     0.200
     1.859    50.658     0.200
     1.743    48.658     0.200
     1.843    51.658     0.200
     1.978    51.658     0.200
     2.304    64.658     0.200
     2.479    66.658     0.200
     2.553    67.658     0.200
     2.610    72.658     0.200
     3.088    83.658     0.200
     3.790   105.658     0.200
     3.781    99.658     0.200
     4.027   105.658     0.200
     4.186   112.658     0.200
     4.870   126.658     0.200
     5.925   152.658     0.200
     6.128   157.658     0.200
     6.291   167.658     0.200
     6.483   166.658     0.200
     6.529   172.658     0.200
     7.941   205.658     0.200
    18.224   449.658     0.200
     1.498    40.790     0.200
     1.460    42.790     0.200
     1.916    53.790     0.200
     2.782    77.790     0.200
     2.939    78.790     0.200
     3.311    93.790     0.200
     3.448    89.790     0.200
     4.908   130.790     0.200
     0.511    19.703     0.200
     1.225    33.703     0.200
     1.472    41.703     0.200
     1.812    52.703     0.200
     1.944    53.703     0.200
     2.111    60.703     0.200
     2.684    72.703     0.200
     2.812    77.703     0.200
     3.293    90.703     0.200
     3.460    91.703     0.200
     4.232   112.703     0.200
     4.908   131.703     0.200
    10.988   279.703     0.200
     0.146    15.146     0.200
     0.287    17.146     0.200
     0.718    25.146     0.200
     1.191    36.146     0.200
     1.670    47.146     0.200
     1.834    51.146     0.200
     1.988    56.146     0.200
     2.068    57.146     0.200
     2.111    58.146     0.200
     2.080    57.146     0.200
     2.240    60.146     0.200
     2.261    63.146     0.200
     2.693    73.146     0.200
     2.711    72.146     0.200
     2.925    78.146     0.200
     3.163    82.146     0.200
     3.325    88.146     0.200
     4.302   110.146     0.200
     4.495   115.146     0.200
     4.560   123.146     0.200
     4.759   123.146     0.200
     4.897   129.146     0.200
     5.553   143.146     0.200
     6.179   158.146     0.200
     6.197   157.146     0.200
     6.393   162.146     0.200
     6.716   170.146     0.200
     6.722   173.146     0.200
     6.919   179.146     0.200
     7.166   187.146     0.200
     7.522   193.146     0.200
     8.357   215.146     0.200
    18.008   442.146     0.200
     0.356    17.086     0.200
     0.562    20.586     0.200
     1.086    32.586     0.200
     1.630    44.586     0.200
     1.630    44.086     0.200
     1.945    52.586     0.200
     1.945    52.984     0.200
     1.842    50.586     0.200
     1.882    51.586     0.200
     1.882    51.387     0.200
     2.213    59.586     0.200
     2.213    59.086     0.200
     2.021    55.586     0.200
     2.213    62.586     0.200
     2.213    62.285     0.200
     2.367    66.586     0.200
     2.367    66.086     0.200
     2.862    76.586     0.200
     2.862    76.387     0.200
     3.240    89.688     0.200
     3.245    89.586     0.200
     3.064    83.586     0.200
     3.064    83.387     0.200
     3.518    98.586     0.200
     3.476    94.586     0.200
     3.476    94.387     0.200
     3.575    97.586     0.200
     4.182   110.586     0.200
     4.182   110.188     0.200
     4.280   117.586     0.200
     4.280   117.984     0.200
     4.449   119.586     0.200
     4.449   119.387     0.200
     4.636   122.586     0.200
     4.636   122.887     0.200
     5.453   147.586     0.200
     5.453   147.785     0.200
     5.684   147.586     0.200
     6.541   168.586     0.200
     6.869   175.586     0.200
     6.999   184.586     0.200
     6.999   184.785     0.200
     7.109   184.586     0.200
     7.109   184.984     0.200
     7.437   193.586     0.200
     8.343   213.586     0.200
     9.253   226.984     0.200
     9.419   242.586     0.200
     9.419   242.086     0.200
     9.622   237.586     0.200
     9.795   251.586     0.200
     9.795   251.285     0.200
    10.269   260.586     0.200
    10.269   260.785     0.200
    20.518   510.586     0.200
     0.052    12.055     0.200
     0.416    17.055     0.200
     0.585    20.055     0.200
     1.954    53.055     0.200
     1.962    56.055     0.200
     2.243    64.055     0.200
     2.416    68.055     0.200
     3.088    84.055     0.200
     0.082    13.141     0.200
     0.570    19.141     0.200
     1.678    44.141     0.200
     1.829    53.141     0.200
     1.926    53.141     0.200
     1.983    56.141     0.200
     2.234    62.141     0.200
     2.399    65.141     0.200
     2.870    76.141     0.200
     3.082    82.141     0.200
     3.484    92.141     0.200
     3.589   100.141     0.200
     4.191   109.141     0.200
     6.338   163.141     0.200
     0.107    11.812     0.200
     0.415    17.812     0.200
     0.535    19.812     0.200
     1.028    32.812     0.200
     1.683    43.812     0.200
     1.796    50.812     0.200
     1.940    52.812     0.200
     1.962    54.812     0.200
     2.265    62.812     0.200
     2.424    67.812     0.200
     3.114    85.812     0.200
     0.124    13.305     0.200
     0.385    17.305     0.200
     0.539    18.305     0.200
     1.057    33.305     0.200
     1.813    51.305     0.200
     1.907    52.305     0.200
     1.993    54.305     0.200
     2.243    63.305     0.200
     2.396    67.305     0.200
     3.093    84.305     0.200
     0.124    14.434     0.200
     0.361    18.434     0.200
     1.154    36.434     0.200
     1.702    45.434     0.200
     1.904    52.434     0.200
     1.985    55.434     0.200
     2.064    56.434     0.200
     2.105    58.434     0.200
     2.306    64.434     0.200
     2.942    78.434     0.200
     6.440   160.434     0.200
     6.854   180.434     0.200
     6.932   175.434     0.200
     0.155    15.844     0.200
     0.278    18.844     0.200
     1.615    43.844     0.200
     1.825    50.844     0.200
     1.995    55.844     0.200
     2.066    56.844     0.200
     2.072    57.844     0.200
     2.120    58.844     0.200
     2.252    63.844     0.200
     2.918    78.844     0.200
     3.171    82.945     0.200
     3.319    87.844     0.200
     3.424    93.844     0.200
     4.296   110.844     0.200
     4.569   122.844     0.200
     4.671   124.242     0.200
     6.824   175.844     0.200
     6.921   179.043     0.200
     6.915   174.844     0.200
     0.201    16.816     0.200
     0.234    17.816     0.200
     1.245    37.816     0.200
     1.575    42.816     0.200
     1.677    46.816     0.200
     1.780    49.816     0.200
     2.031    58.816     0.200
     2.063    54.816     0.200
     2.031    56.816     0.200
     2.199    58.816     0.200
     2.206    61.816     0.200
     2.671    71.816     0.200
     2.878    76.816     0.200
     3.397    91.816     0.200
     3.285    87.816     0.200
     3.344    91.816     0.200
     3.387    92.816     0.200
     4.259   110.816     0.200
     5.493   144.816     0.200
     5.509   140.816     0.200
     6.351   163.816     0.200
     6.394   158.816     0.200
     6.783   178.816     0.200
     6.876   172.816     0.200
     0.122    16.520     0.200
     0.324    18.520     0.200
     1.165    35.520     0.200
     1.688    45.520     0.200
     1.662    44.520     0.200
     1.870    52.520     0.200
     1.977    56.520     0.200
     2.093    58.520     0.200
     2.082    56.520     0.200
     2.100    58.520     0.200
     2.278    62.520     0.200
     2.289    64.520     0.200
     2.720    71.520     0.200
     2.941    77.520     0.200
     3.334    88.520     0.200
     3.419    93.520     0.200
     4.042   103.520     0.200
     4.314   111.520     0.200
     4.510   116.520     0.200
     4.910   129.520     0.200
     5.342   140.520     0.200
     5.565   143.520     0.200
     6.188   157.520     0.200
     6.209   158.520     0.200
     6.403   160.520     0.200
     6.446   161.320     0.200
     6.735   173.520     0.200
     6.935   174.520     0.200
     7.037   177.520     0.200
     7.261   186.020     0.200
     7.464   191.520     0.200
     0.113    15.225     0.200
     0.334    19.225     0.200
     1.156    35.225     0.200
     1.689    46.225     0.200
     1.671    45.225     0.200
     1.880    53.225     0.200
     1.971    55.225     0.200
     2.095    57.225     0.200
     2.072    58.225     0.200
     2.108    59.225     0.200
     2.287    60.225     0.200
     2.299    65.225     0.200
     2.726    73.225     0.200
     2.949    79.225     0.200
     3.123    83.324     0.200
     3.340    88.225     0.200
     3.452    95.225     0.200
     4.049   105.225     0.200
     4.321   112.225     0.200
     4.517   118.225     0.200
     4.629   119.324     0.200
     4.917   130.225     0.200
     5.572   143.225     0.200
     6.195   157.225     0.200
     6.216   157.225     0.200
     6.409   161.225     0.200
     6.859   179.225     0.200
     7.675   190.524     0.200
     8.405   217.225     0.200
     0.119    15.445     0.200
     0.354    18.445     0.200
     1.153    35.445     0.200
     1.715    45.445     0.200
     1.695    46.445     0.200
     1.898    52.445     0.200
     1.980    56.445     0.200
     2.124    57.445     0.200
     2.106    59.445     0.200
     2.658    71.844     0.200
     2.945    78.445     0.200
     3.116    81.445     0.200
     3.445    94.445     0.200
     4.626   122.945     0.200
     4.785   124.445     0.200
     6.856   179.445     0.200
     0.085    11.238     0.200
     1.028    32.238     0.200
     1.548    42.238     0.200
     1.615    43.438     0.200
     1.807    53.238     0.200
     1.947    53.238     0.200
     2.258    63.238     0.200
     2.525    70.039     0.200
     3.010    79.637     0.200
     3.612    99.238     0.200
     4.601   119.238     0.200
     4.496   119.438     0.200
     0.156    16.484     0.200
     0.284    17.484     0.200
     1.201    36.484     0.200
     1.621    46.785     0.200
     1.622    43.484     0.200
     1.829    50.484     0.200
     2.000    58.484     0.200
     2.078    56.484     0.200
     2.120    60.484     0.200
     2.242    60.484     0.200
     2.252    63.484     0.200
     2.703    74.086     0.200
     2.699    70.484     0.200
     2.913    79.484     0.200
     3.171    82.785     0.200
     3.313    86.484     0.200
     3.419    93.484     0.200
     4.290   110.484     0.200
     4.570   119.086     0.200
     4.772   123.484     0.200
     6.167   157.484     0.200
     6.380   162.484     0.200
     6.820   178.484     0.200
     6.931   173.484     0.200
     6.909   173.785     0.200
     7.014   177.484     0.200
    18.477   451.383     0.200
     0.141    17.066     0.200
     0.172    15.465     0.200
     0.424    19.066     0.200
     0.711    25.066     0.200
     1.303    36.668     0.200
     1.311    36.066     0.200
     1.388    41.066     0.200
     1.497    42.066     0.200
     1.559    43.066     0.200
     1.995    56.066     0.200
     2.715    72.066     0.200
     2.863    78.266     0.200
     3.390    95.066     0.200
     3.377    88.066     0.200
     7.890   197.867     0.200
     0.478    22.711     0.200
     0.707    26.711     0.200
     1.129    36.711     0.200
     1.291    40.711     0.200
     1.850    49.711     0.200
     1.934    54.812     0.200
     2.253    58.512     0.200
     2.338    63.211     0.200
     3.784   100.910     0.200
     3.884   103.012     0.200
     4.109   108.711     0.200
     6.912   170.609     0.200
     7.560   191.711     0.200
     7.585   189.312     0.200
     1.302    36.492     0.200
     1.515    43.492     0.200
     1.459    43.492     0.200
     1.892    53.492     0.200
     1.936    55.492     0.200
     1.928    55.492     0.200
     2.003    55.492     0.200
     2.605    72.492     0.200
     3.445    90.789     0.200
     4.166   111.492     0.200
     4.810   127.992     0.200
     1.230    33.859     0.200
     1.303    34.160     0.200
     1.437    39.859     0.200
     1.872    53.859     0.200
     1.839    51.859     0.200
     1.917    53.859     0.200
     2.570    70.859     0.200
     2.706    72.859     0.200
     3.179    84.859     0.200
     3.236    89.859     0.200
     3.520    92.059     0.200
     3.873   101.859     0.200
     4.121   107.859     0.200
     4.282   115.859     0.200
     4.880   129.859     0.200
     6.482   172.859     0.200
     6.578   169.859     0.200
    18.584   456.859     0.200
     0.268    18.016     0.200
     0.166    16.617     0.200
     1.210    36.516     0.200
     1.605    42.715     0.200
     1.672    46.816     0.200
     1.814    49.516     0.200
     2.065    54.914     0.200
     2.003    56.016     0.200
     2.062    58.016     0.200
     2.132    60.215     0.200
     2.241    63.816     0.200
     2.697    72.816     0.200
     2.908    78.016     0.200
     3.311    87.215     0.200
     3.415    93.016     0.200
     4.018   104.617     0.200
     4.478   118.516     0.200
     4.579   122.016     0.200
     5.537   142.715     0.200
     6.165   155.516     0.200
     6.378   162.016     0.200
     6.421   161.016     0.200
     6.703   169.117     0.200
     6.814   174.016     0.200
     6.905   174.016     0.200
     7.011   178.016     0.200
     0.169    17.262     0.200
     0.469    20.961     0.200
     0.721    25.562     0.200
     1.266    34.363     0.200
     1.475    41.262     0.200
     1.420    40.461     0.200
     1.521    42.562     0.200
     1.803    47.262     0.200
     1.871    49.961     0.200
     2.063    57.062     0.200
     1.988    57.363     0.200
     2.068    59.164     0.200
     2.889    77.562     0.200
     2.720    73.062     0.200
     2.856    79.363     0.200
     3.189    84.062     0.200
     3.248    90.062     0.200
     3.409    87.363     0.200
     3.330    90.062     0.200
     4.025   104.863     0.200
     4.273   111.562     0.200
     4.641   118.062     0.200
     4.432   117.461     0.200
     4.752   125.562     0.200
     5.534   142.062     0.200
     6.157   159.062     0.200
     6.170   159.062     0.200
     6.780   170.363     0.200
     6.633   172.062     0.200
     6.670   171.062     0.200
     6.725   173.062     0.200
     6.733   170.461     0.200
     6.865   174.363     0.200
     6.905   177.863     0.200
     7.021   185.062     0.200
     6.998   178.262     0.200
     7.261   186.363     0.200
     7.376   191.062     0.200
     9.477   233.363     0.200
    13.324   329.762     0.200
     0.109    15.789     0.200
     0.376    19.188     0.200
     1.136    35.688     0.200
     1.720    47.090     0.200
     1.715    46.590     0.200
     1.920    52.688     0.200
     1.969    54.988     0.200
     2.133    59.988     0.200
     2.046    58.988     0.200
     2.122    59.488     0.200
     2.332    61.789     0.200
     2.324    60.988     0.200
     2.641    69.789     0.200
     2.727    74.188     0.200
     3.096    83.188     0.200
     3.341    89.988     0.200
     3.459    92.988     0.200
     3.698   100.090     0.200
     4.050   105.988     0.200
     4.506   119.988     0.200
     4.525   118.988     0.200
     4.783   122.988     0.200
     5.576   143.988     0.200
     6.949   174.688     0.200
     0.139    15.734     0.200
     0.338    18.438     0.200
     0.753    24.336     0.200
     1.175    36.336     0.200
     1.680    46.336     0.200
     1.723    47.336     0.200
     1.880    52.438     0.200
     2.000    55.938     0.200
     2.127    58.234     0.200
     2.087    59.133     0.200
     2.085    58.836     0.200
     2.302    61.336     0.200
     2.284    64.336     0.200
     2.697    73.336     0.200
     2.924    79.539     0.200
     3.310    87.336     0.200
     4.019   106.336     0.200
     4.137   111.438     0.200
     4.293   114.133     0.200
     4.491   117.336     0.200
     4.546   122.336     0.200
     5.544   141.938     0.200
     6.411   162.336     0.200
     6.834   176.336     0.200
    18.488   450.336     0.200
     0.173    16.379     0.200
     0.278    18.078     0.200
     0.752    25.078     0.200
     1.218    36.879     0.200
     1.526    43.477     0.200
     1.621    45.078     0.200
     1.701    47.379     0.200
     1.822    51.477     0.200
     2.022    57.578     0.200
     2.094    58.180     0.200
     2.135    57.277     0.200
     2.050    57.578     0.200
     2.236    63.879     0.200
     2.640    73.078     0.200
     2.677    72.379     0.200
     2.893    78.078     0.200
     3.186    83.078     0.200
     3.286    87.078     0.200
     3.291    88.078     0.200
     3.420    91.078     0.200
     3.368    92.078     0.200
     3.623   101.078     0.200
     3.999   103.977     0.200
     4.102   109.078     0.200
     4.269   111.078     0.200
     4.462   116.078     0.200
     4.588   120.078     0.200
     4.651   122.680     0.200
     4.793   124.078     0.200
     4.864   129.078     0.200
     5.498   144.078     0.200
     5.519   141.078     0.200
     6.145   158.078     0.200
     6.164   157.578     0.200
     6.574   171.578     0.200
     6.689   171.180     0.200
     6.888   174.379     0.200
     6.993   176.379     0.200
     7.255   185.477     0.200
     7.791   193.379     0.200
     7.836   202.078     0.200
     7.886   194.078     0.200
    12.333   309.578     0.200
     1.132    34.141     0.200
     1.269    38.039     0.200
     1.866    52.840     0.200
     2.037    57.840     0.200
     2.182    59.840     0.200
     2.802    74.840     0.200
     2.899    78.840     0.200
     2.894    77.840     0.200
     3.463    93.738     0.200
     3.480    92.840     0.200
     3.822    99.941     0.200
     4.139   109.840     0.200
     0.161    16.250     0.200
     0.278    17.953     0.200
     0.731    24.953     0.200
     1.205    37.047     0.200
     1.515    43.852     0.200
     1.616    44.547     0.200
     1.680    48.250     0.200
     1.824    50.750     0.200
     2.003    55.750     0.200
     2.075    57.148     0.200
     2.065    56.953     0.200
     2.125    57.547     0.200
     2.236    60.352     0.200
     2.247    63.352     0.200
     2.696    72.250     0.200
     2.910    78.250     0.200
     3.176    83.453     0.200
     3.399    91.250     0.200
     3.305    87.953     0.200
     3.310    86.648     0.200
     3.381    91.250     0.200
     3.416    91.250     0.200
     3.638   101.047     0.200
     4.018   103.250     0.200
     4.118   110.250     0.200
     4.287   114.148     0.200
     4.479   117.648     0.200
     4.575   120.250     0.200
     4.668   122.250     0.200
     5.538   142.953     0.200
     6.164   158.148     0.200
     6.182   156.547     0.200
     6.816   178.250     0.200
     6.931   175.852     0.200
     6.906   174.250     0.200
     7.011   179.250     0.200
     7.274   185.250     0.200
     7.904   195.352     0.200
     0.344    18.719     0.200
     0.729    24.422     0.200
     1.155    35.719     0.200
     1.462    42.320     0.200
     1.889    52.320     0.200
     1.976    55.719     0.200
     2.110    58.320     0.200
     2.069    57.320     0.200
     2.107    58.922     0.200
     2.300    63.320     0.200
     2.301    64.320     0.200
     2.705    74.320     0.200
     2.721    73.320     0.200
     2.946    78.320     0.200
     3.330    89.320     0.200
     3.334    87.320     0.200
     4.043   104.320     0.200
     4.704   122.320     0.200
     5.567   143.320     0.200
     5.927   151.320     0.200
     6.189   157.320     0.200
     6.857   175.320     0.200
     6.938   174.922     0.200
     7.933   196.820     0.200
    18.464   452.320     0.200
     0.898    32.695     0.200
     1.435    44.995     0.200
     1.891    57.995     0.200
     2.317    68.995     0.200
     2.535    71.895     0.200
     2.675    77.895     0.200
     3.145    90.995     0.200
     4.899   136.995     0.200
     0.181    15.242     0.200
     0.328    18.539     0.200
     0.710    24.242     0.200
     1.156    35.641     0.200
     1.465    42.242     0.200
     1.678    47.242     0.200
     1.875    52.445     0.200
     1.960    53.242     0.200
     1.966    55.344     0.200
     2.084    55.242     0.200
     2.074    58.242     0.200
     2.110    59.039     0.200
     2.298    63.242     0.200
     2.701    75.242     0.200
     2.731    73.242     0.200
     2.952    78.242     0.200
     3.345    87.242     0.200
     3.429    92.242     0.200
     4.710   122.039     0.200
     5.576   143.242     0.200
     6.861   180.242     0.200
     6.946   174.445     0.200
     1.438    41.062     0.200
     1.773    51.156     0.200
     1.920    54.359     0.200
     1.881    54.961     0.200
     2.002    56.359     0.200
     1.891    54.359     0.200
     2.498    70.359     0.200
     2.491    70.359     0.200
     2.637    73.359     0.200
     3.092    87.359     0.200
     3.164    89.359     0.200
     3.548    94.859     0.200
     3.797   103.359     0.200
     4.922   133.562     0.200
    12.648   319.359     0.200
     1.192    34.851     0.200
     1.386    39.851     0.200
     1.647    48.851     0.200
     1.845    51.851     0.200
     2.651    74.851     0.200
     3.048    85.851     0.200
     3.131    88.551     0.200
     3.828   105.851     0.200
     3.824   103.851     0.200
     4.070   107.051     0.200
     4.227   114.851     0.200
     4.653   124.851     0.200
     5.275   144.950     0.200
     5.953   157.851     0.200
     5.968   155.851     0.200
     6.534   169.251     0.200
     7.171   189.851     0.200
     7.569   199.251     0.200
     7.851   199.851     0.200
     8.439   220.351     0.200
    11.108   284.851     0.200
    11.311   289.351     0.200
    12.264   312.351     0.200
    13.139   330.851     0.200
    13.517   337.851     0.200
    13.762   344.450     0.200
    15.006   377.851     0.200
    15.343   383.851     0.200
    18.633   457.851     0.200
    19.335   476.351     0.200
     0.478    19.374     0.200
     0.809    27.774     0.200
     1.490    41.374     0.200
     1.792    51.474     0.200
     1.898    52.374     0.200
     1.996    55.374     0.200
     2.398    66.074     0.200
     2.412    67.374     0.200
     2.621    74.374     0.200
     2.763    74.374     0.200
     3.223    90.374     0.200
     3.232    87.374     0.200
     3.292    91.374     0.200
     0.792    26.739     0.200
     1.783    50.539     0.200
     1.872    54.539     0.200
     1.915    52.539     0.200
     2.009    57.539     0.200
     2.411    66.539     0.200
     2.405    67.239     0.200
     2.782    76.539     0.200
     3.243    88.539     0.200
     3.252    88.539     0.200
     3.312    91.539     0.200
     1.427    40.221     0.200
     1.866    51.021     0.200
     1.828    51.221     0.200
     1.922    53.021     0.200
     2.483    69.021     0.200
     2.560    72.021     0.200
     2.695    73.021     0.200
     3.027    80.721     0.200
     3.160    86.021     0.200
     3.170    86.021     0.200
     3.225    91.021     0.200
     3.864   105.021     0.200
     0.514    19.729     0.200
     1.470    40.229     0.200
     1.825    51.229     0.200
     1.925    53.729     0.200
     1.939    52.729     0.200
     2.342    63.729     0.200
     2.453    68.729     0.200
     2.689    72.729     0.200
     3.143    86.729     0.200
     3.152    86.729     0.200
     3.216    90.729     0.200
     0.828    28.645     0.200
     1.274    36.145     0.200
     1.488    42.445     0.200
     1.909    54.043     0.200
     1.916    55.645     0.200
     1.983    55.645     0.200
     2.166    62.945     0.200
     2.385    66.645     0.200
     2.420    65.645     0.200
     2.600    71.645     0.200
     2.744    77.145     0.200
     3.152    88.645     0.200
     3.210    87.145     0.200
     3.272    90.645     0.200
     3.469    91.145     0.200
     3.906   105.344     0.200
     4.320   117.645     0.200
     4.831   129.645     0.200
     6.042   158.645     0.200
     6.052   155.645     0.200
     6.546   173.645     0.200
     6.621   173.645     0.200
     6.882   179.645     0.200
    10.958   282.344     0.200
    12.551   315.945     0.200
     0.462    18.930     0.200
     1.517    42.328     0.200
     1.465    43.930     0.200
     1.626    48.230     0.200
     1.782    51.930     0.200
     1.952    56.930     0.200
     1.876    52.930     0.200
     1.994    56.930     0.200
     2.397    65.930     0.200
     2.400    67.930     0.200
     2.585    72.930     0.200
     2.739    76.930     0.200
     3.188    90.930     0.200
     3.264    91.930     0.200
     1.403    40.234     0.200
     1.840    51.039     0.200
     1.926    54.836     0.200
     1.875    52.836     0.200
     1.921    54.133     0.200
     2.322    64.133     0.200
     2.496    68.836     0.200
     2.583    69.836     0.200
     2.709    71.836     0.200
     3.182    85.836     0.200
     3.192    85.836     0.200
     3.242    89.836     0.200
     3.884   103.633     0.200
     4.897   131.633     0.200
     6.260   159.836     0.200
     0.842    29.586     0.200
     1.477    41.285     0.200
     1.906    54.586     0.200
     1.924    54.984     0.200
     1.865    53.285     0.200
     1.969    55.984     0.200
     2.371    65.984     0.200
     2.433    67.984     0.200
     2.586    71.984     0.200
     2.730    75.984     0.200
     3.188    89.586     0.200
     3.197    88.984     0.200
     4.845   132.984     0.200
     0.610    22.133     0.200
     0.859    29.531     0.200
     1.358    38.332     0.200
     1.583    46.332     0.200
     1.870    52.230     0.200
     1.903    55.332     0.200
     2.527    72.332     0.200
     2.633    71.332     0.200
     2.741    75.332     0.200
     3.228    90.332     0.200
     3.240    89.332     0.200
     3.279    92.332     0.200
     3.928   105.730     0.200
     0.470    18.961     0.200
     1.510    42.359     0.200
     1.865    51.961     0.200
     1.949    55.660     0.200
     2.387    64.762     0.200
     2.409    66.961     0.200
     2.575    71.961     0.200
     2.728    75.961     0.200
     3.177    87.961     0.200
     3.186    86.961     0.200
     3.254    88.961     0.200
     3.884   103.961     0.200
     4.304   116.961     0.200
     6.024   157.961     0.200
     6.030   156.961     0.200
     6.266   160.961     0.200
     6.736   171.859     0.200
     0.664    23.920     0.200
     1.306    38.119     0.200
     1.763    50.420     0.200
     1.758    49.920     0.200
     1.824    50.119     0.200
     2.225    63.119     0.200
     2.520    69.020     0.200
     2.597    73.119     0.200
     2.629    72.119     0.200
     3.114    86.119     0.200
     3.126    86.119     0.200
     3.166    87.119     0.200
     3.814   105.119     0.200
     4.204   115.020     0.200
     0.585    22.281     0.200
     0.870    29.980     0.200
     1.381    40.680     0.200
     1.852    53.680     0.200
     1.847    52.980     0.200
     1.915    54.680     0.200
     2.316    64.180     0.200
     2.599    71.680     0.200
     2.717    76.680     0.200
     3.196    88.680     0.200
     3.207    89.680     0.200
     3.252    92.680     0.200
     3.897   105.680     0.200
    21.552   533.281     0.200
     0.823    28.523     0.200
     1.460    43.023     0.200
     1.499    44.422     0.200
     1.867    54.320     0.200
     1.878    55.227     0.200
     1.818    52.023     0.200
     1.885    53.023     0.200
     1.975    55.125     0.200
     2.439    67.023     0.200
     2.617    71.227     0.200
     2.752    76.023     0.200
     2.977    81.023     0.200
     3.217    89.023     0.200
     3.227    89.023     0.200
     3.283    91.023     0.200
     3.487    90.922     0.200
     3.921   105.023     0.200
     4.328   118.023     0.200
     4.841   131.023     0.200
     6.623   173.023     0.200
     0.204    14.172     0.200
     0.607    21.969     0.200
     0.896    29.469     0.200
     1.359    37.969     0.200
     1.582    46.969     0.200
     1.595    46.867     0.200
     1.822    49.672     0.200
     1.889    52.969     0.200
     2.238    63.367     0.200
     2.290    63.969     0.200
     2.537    69.469     0.200
     2.576    71.969     0.200
     2.692    72.969     0.200
     3.068    84.469     0.200
     3.173    85.969     0.200
     3.183    85.969     0.200
     3.584    94.172     0.200
     4.931   132.969     0.200
     0.609    22.668     0.200
     1.365    39.268     0.200
     1.819    51.168     0.200
     1.782    50.668     0.200
     1.865    52.668     0.200
     2.528    68.668     0.200
     2.651    72.668     0.200
     3.126    85.668     0.200
     3.136    84.668     0.200
     3.185    89.668     0.200
     3.828   102.668     0.200
     0.567    21.758     0.200
     0.863    30.058     0.200
     1.400    41.258     0.200
     1.555    46.758     0.200
     1.865    54.758     0.200
     1.850    52.058     0.200
     1.926    55.758     0.200
     2.597    70.758     0.200
     2.719    75.758     0.200
     3.194    88.758     0.200
     3.205    88.758     0.200
     3.896   104.458     0.200
    21.554   534.758     0.200
     0.669    24.793     0.200
     1.297    38.992     0.200
     1.652    48.691     0.200
     1.847    54.492     0.200
     1.793    50.893     0.200
     1.843    54.492     0.200
     2.278    65.691     0.200
     2.595    71.492     0.200
     2.564    71.893     0.200
     2.665    74.992     0.200
     3.157    88.492     0.200
     3.169    86.492     0.200
     3.641    97.492     0.200
     4.093   111.492     0.200
     4.982   135.492     0.200
     0.230    16.945     0.200
     0.324    17.945     0.200
     0.761    25.148     0.200
     1.191    37.746     0.200
     1.497    44.047     0.200
     1.726    47.848     0.200
     1.865    52.148     0.200
     2.013    53.648     0.200
     2.102    58.047     0.200
     2.070    57.945     0.200
     2.292    62.047     0.200
     2.268    63.047     0.200
     2.671    75.047     0.200
     2.684    72.945     0.200
     2.909    78.047     0.200
     3.293    88.047     0.200
     3.297    86.047     0.200
     3.645   100.547     0.200
     4.477   117.246     0.200
     6.820   178.047     0.200
     0.769    27.935     0.200
     1.473    43.435     0.200
     1.841    53.635     0.200
     1.943    56.935     0.200
     2.683    75.635     0.200
     2.812    79.635     0.200
     3.282    92.635     0.200
     3.292    92.635     0.200
     0.733    26.605     0.200
     1.518    43.805     0.200
     1.746    50.406     0.200
     1.878    53.406     0.200
     1.976    55.906     0.200
     2.368    67.008     0.200
     2.460    67.508     0.200
     2.706    76.406     0.200
     2.843    78.508     0.200
     3.307    93.406     0.200
     3.316    92.406     0.200
     1.522    43.032     0.200
     1.859    51.932     0.200
     1.969    54.932     0.200
     1.979    57.132     0.200
     1.985    53.932     0.200
     2.388    66.932     0.200
     2.404    66.932     0.200
     2.563    70.731     0.200
     2.721    76.032     0.200
     2.961    82.032     0.200
     3.166    88.932     0.200
     3.175    86.832     0.200
     3.454    92.432     0.200
     3.873   104.231     0.200
     4.813   127.432     0.200
     4.828   131.932     0.200
     6.020   156.132     0.200
     6.606   174.932     0.200
    18.591   456.932     0.200
     1.557    42.334     0.200
     1.763    51.934     0.200
     2.010    56.734     0.200
     1.866    51.934     0.200
     2.004    54.934     0.200
     2.379    66.934     0.200
     2.558    69.934     0.200
     2.725    75.834     0.200
     3.162    89.533     0.200
     3.170    87.834     0.200
     3.246    89.934     0.200
     3.871   102.934     0.200
     6.255   161.633     0.200
     0.726    25.777     0.200
     1.530    42.879     0.200
     1.889    52.777     0.200
     1.982    54.379     0.200
     2.068    57.777     0.200
     2.470    68.777     0.200
     2.357    65.977     0.200
     2.709    73.777     0.200
     2.849    78.777     0.200
     3.310    93.176     0.200
     3.320    89.777     0.200
     3.379    92.777     0.200
     4.015   108.777     0.200
     0.368    18.828     0.200
     0.746    24.625     0.200
     1.148    35.727     0.200
     1.453    43.031     0.200
     1.911    51.328     0.200
     1.981    56.031     0.200
     2.057    58.328     0.200
     2.110    58.531     0.200
     2.313    61.328     0.200
     2.716    73.625     0.200
     2.715    72.531     0.200
     2.947    78.328     0.200
     3.325    87.328     0.200
     3.328    87.328     0.200
     3.686   100.727     0.200
     4.038   104.328     0.200
     4.513   118.328     0.200
     6.430   160.328     0.200
     6.936   174.828     0.200
     7.930   196.328     0.200
     0.070    15.934     0.200
     0.367    19.133     0.200
     0.770    26.234     0.200
     1.373    40.633     0.200
     1.614    47.133     0.200
     1.613    44.832     0.200
     1.689    48.031     0.200
     2.027    54.133     0.200
     1.948    54.934     0.200
     2.095    57.531     0.200
     2.082    58.934     0.200
     2.306    63.133     0.200
     2.637    74.133     0.200
     2.807    77.133     0.200
     3.249    86.133     0.200
     3.328    92.133     0.200
     4.382   117.133     0.200
     4.731   125.133     0.200
     6.098   159.133     0.200
     6.098   156.133     0.200
     6.697   173.133     0.200
     0.222    13.536     0.200
     1.343    38.236     0.200
     1.817    50.636     0.200
     1.879    53.835     0.200
     2.279    63.036     0.200
     2.551    70.036     0.200
     2.576    68.036     0.200
     3.172    87.036     0.200
     3.183    85.036     0.200
     3.598    94.536     0.200
     3.872   105.036     0.200
     0.053    15.980     0.200
     0.796    26.080     0.200
     1.393    40.580     0.200
     1.636    45.580     0.200
     1.600    44.881     0.200
     1.709    47.779     0.200
     2.028    54.381     0.200
     1.923    54.480     0.200
     2.121    57.779     0.200
     2.060    58.779     0.200
     2.326    62.680     0.200
     2.611    70.080     0.200
     2.782    77.881     0.200
     3.215    88.580     0.200
     3.216    86.580     0.200
     3.224    85.080     0.200
     3.302    91.580     0.200
     3.376    89.080     0.200
     3.925   103.580     0.200
     4.182   109.580     0.200
     4.357   114.580     0.200
     4.753   125.580     0.200
     6.072   157.580     0.200
     6.072   157.580     0.200
     6.310   158.580     0.200
     6.624   167.580     0.200
     6.673   173.580     0.200
     6.788   172.580     0.200
     6.909   176.279     0.200
     7.171   185.480     0.200
     8.134   209.580     0.200
    12.849   317.580     0.200
    20.544   508.580     0.200
     0.753    26.449     0.200
     1.891    56.148     0.200
     1.913    55.449     0.200
     1.976    58.350     0.200
     2.326    66.049     0.200
     2.660    75.148     0.200
     2.819    81.549     0.200
     3.971   109.449     0.200
     4.573   124.449     0.200
     0.280    20.660     0.200
     1.162    35.859     0.200
     1.554    43.059     0.200
     1.478    42.457     0.200
     1.812    50.957     0.200
     1.953    51.059     0.200
     2.096    57.258     0.200
     2.167    58.359     0.200
     2.139    59.258     0.200
     2.290    62.059     0.200
     2.656    71.258     0.200
     2.796    74.758     0.200
     2.992    80.359     0.200
     3.146    81.758     0.200
     3.404    90.457     0.200
     3.441    93.957     0.200
     3.410    89.258     0.200
     3.505    93.059     0.200
     3.706    99.059     0.200
     4.115   106.160     0.200
     4.523   119.059     0.200
     4.565   119.160     0.200
     5.630   143.957     0.200
     6.263   159.059     0.200
     6.504   163.059     0.200
     6.796   174.059     0.200
     6.805   172.059     0.200
     6.891   181.059     0.200
     6.994   175.957     0.200
     7.106   179.059     0.200
     7.996   198.059     0.200
    18.371   448.059     0.200
     0.519    19.984     0.200
     1.448    40.785     0.200
     1.859    53.184     0.200
     1.830    53.184     0.200
     1.875    52.582     0.200
     2.365    65.184     0.200
     2.451    70.184     0.200
     2.610    73.184     0.200
     2.743    76.184     0.200
     3.209    89.184     0.200
     3.219    87.184     0.200
     3.274    92.184     0.200
     4.853   128.684     0.200
     6.291   161.184     0.200
     0.461    21.852     0.200
     0.693    29.156     0.200
     1.510    42.953     0.200
     1.568    44.156     0.200
     1.685    46.852     0.200
     1.991    54.055     0.200
     2.207    61.055     0.200
     2.248    61.250     0.200
     2.466    66.656     0.200
     2.526    68.953     0.200
     2.734    71.953     0.200
     2.701    74.953     0.200
     3.187    84.453     0.200
     3.131    82.055     0.200
     3.366    88.953     0.200
     3.741    97.852     0.200
     3.744    98.055     0.200
     3.843   103.453     0.200
     4.115   109.453     0.200
     4.455   113.453     0.200
     4.454   115.453     0.200
     4.579   120.250     0.200
     4.731   122.953     0.200
     4.933   129.055     0.200
     5.329   141.453     0.200
     5.948   152.750     0.200
     5.983   153.852     0.200
     6.626   169.453     0.200
     6.599   166.852     0.200
     6.627   167.953     0.200
     6.846   171.453     0.200
     7.045   186.453     0.200
     7.123   178.453     0.200
     7.277   186.453     0.200
     7.384   186.055     0.200
     7.452   188.656     0.200
     8.353   212.656     0.200
     8.254   204.453     0.200
     8.348   206.250     0.200
     8.600   219.453     0.200
     8.424   206.953     0.200
     8.557   215.453     0.200
     9.880   244.453     0.200
    10.794   272.453     0.200
    11.857   295.656     0.200
     0.600    21.539     0.200
     1.372    40.141     0.200
     1.886    53.340     0.200
     1.899    53.340     0.200
     2.173    62.438     0.200
     2.344    66.539     0.200
     2.510    69.039     0.200
     2.664    73.539     0.200
     3.259    89.539     0.200
     3.270    91.539     0.200
     0.306    18.617     0.200
     0.715    23.617     0.200
     1.176    35.617     0.200
     1.485    42.316     0.200
     1.675    46.617     0.200
     1.852    52.215     0.200
     1.979    55.117     0.200
     2.076    57.117     0.200
     2.095    58.215     0.200
     2.093    58.516     0.200
     2.257    60.816     0.200
     2.277    64.316     0.200
     2.679    71.516     0.200
     2.719    73.918     0.200
     2.936    78.816     0.200
     3.146    83.316     0.200
     3.328    88.418     0.200
     3.333    88.816     0.200
     3.410    93.316     0.200
     4.041   105.117     0.200
     4.545   120.316     0.200
     4.694   122.316     0.200
     4.907   130.016     0.200
     5.562   143.418     0.200
     6.188   159.316     0.200
     6.206   158.316     0.200
     6.432   162.215     0.200
     6.723   170.316     0.200
     6.732   172.316     0.200
     6.844   178.316     0.200
     7.035   177.816     0.200
     7.874   202.617     0.200
     7.928   196.016     0.200
    18.459   452.316     0.200
     0.569    19.672     0.200
     1.392    41.473     0.200
     1.897    52.271     0.200
     1.961    55.873     0.200
     2.009    56.672     0.200
     2.232    62.172     0.200
     2.217    62.672     0.200
     2.780    75.672     0.200
     2.861    78.672     0.200
     3.067    83.072     0.200
     3.469    93.873     0.200
     3.474    92.771     0.200
     3.577   101.072     0.200
     6.572   166.973     0.200
     6.969   182.072     0.200
     7.066   179.873     0.200
     7.090   180.771     0.200
     0.062    12.771     0.200
     0.392    17.471     0.200
     0.525    19.771     0.200
     1.050    33.371     0.200
     1.368    40.172     0.200
     1.504    42.070     0.200
     1.778    47.771     0.200
     1.802    51.371     0.200
     1.927    51.971     0.200
     1.910    52.771     0.200
     1.987    55.471     0.200
     2.224    59.771     0.200
     2.253    63.271     0.200
     2.808    77.172     0.200
     2.902    78.070     0.200
     3.104    83.672     0.200
     3.510    92.871     0.200
     3.516    93.271     0.200
     0.279    17.688     0.200
     0.741    24.586     0.200
     1.210    36.289     0.200
     1.520    43.789     0.200
     1.690    47.188     0.200
     1.619    44.188     0.200
     1.824    50.688     0.200
     1.978    55.484     0.200
     2.012    56.891     0.200
     2.084    57.289     0.200
     2.129    57.391     0.200
     2.058    56.688     0.200
     2.241    61.289     0.200
     2.243    63.688     0.200
     2.647    73.188     0.200
     2.688    71.086     0.200
     2.902    79.688     0.200
     3.180    82.688     0.200
     3.409    89.688     0.200
     3.297    89.484     0.200
     3.301    88.789     0.200
     3.408    92.688     0.200
     4.009   103.586     0.200
     4.472   117.586     0.200
     5.509   143.789     0.200
     6.156   155.688     0.200
     6.174   159.086     0.200
     6.400   161.984     0.200
     6.699   171.484     0.200
     6.692   169.891     0.200
     6.941   173.688     0.200
     6.810   178.688     0.200
     6.898   172.891     0.200
     7.865   199.586     0.200
     7.896   195.484     0.200
    13.068   328.688     0.200
    14.702   359.688     0.200
     0.598    21.386     0.200
     1.376    39.886     0.200
     1.829    52.186     0.200
     1.788    49.586     0.200
     1.923    56.186     0.200
     1.914    54.486     0.200
     2.276    62.885     0.200
     2.535    71.786     0.200
     2.531    68.686     0.200
     2.656    72.186     0.200
     3.129    85.586     0.200
     3.139    85.486     0.200
     3.189    87.686     0.200
     3.831   103.885     0.200
     1.311    37.586     0.200
     1.715    49.086     0.200
     1.631    47.387     0.200
     1.829    52.484     0.200
     1.873    54.586     0.200
     2.272    63.285     0.200
     2.575    71.688     0.200
     2.601    72.285     0.200
     2.700    75.086     0.200
     3.194    87.785     0.200
     3.206    88.285     0.200
     3.240    87.586     0.200
     3.892   106.484     0.200
     0.223    16.875     0.200
     0.294    17.578     0.200
     0.744    24.773     0.200
     1.202    36.977     0.200
     1.510    43.773     0.200
     1.699    47.977     0.200
     1.838    49.875     0.200
     1.985    56.773     0.200
     2.009    55.672     0.200
     2.096    56.172     0.200
     2.064    57.773     0.200
     2.118    58.773     0.200
     2.257    61.578     0.200
     2.253    59.875     0.200
     2.656    74.273     0.200
     2.689    73.773     0.200
     2.907    78.672     0.200
     3.298    87.672     0.200
     3.303    88.273     0.200
     3.412    93.875     0.200
     3.638   100.375     0.200
     4.011   104.773     0.200
     4.476   117.477     0.200
     4.572   122.875     0.200
     4.665   122.273     0.200
     5.510   142.578     0.200
     5.532   142.578     0.200
     6.158   158.477     0.200
     6.402   160.773     0.200
     6.693   168.875     0.200
     6.815   178.875     0.200
     7.804   193.172     0.200
     7.845   200.578     0.200
     7.870   199.078     0.200
     7.899   195.172     0.200
     0.306    18.457     0.200
     0.732    24.660     0.200
     1.185    36.258     0.200
     1.494    42.457     0.200
     1.692    48.059     0.200
     1.646    45.758     0.200
     1.852    52.059     0.200
     1.994    55.859     0.200
     2.093    57.758     0.200
     2.102    56.758     0.200
     2.081    57.957     0.200
     2.265    62.059     0.200
     2.269    62.660     0.200
     2.704    72.059     0.200
     2.923    78.859     0.200
     3.153    81.059     0.200
     3.313    88.559     0.200
     3.318    88.559     0.200
     3.400    93.059     0.200
     3.427    94.059     0.200
     4.026   105.059     0.200
     4.297   111.359     0.200
     4.555   119.059     0.200
     4.492   115.559     0.200
     4.681   122.559     0.200
     4.893   129.258     0.200
     5.525   143.457     0.200
     5.548   142.957     0.200
     6.172   157.059     0.200
     6.192   157.559     0.200
     6.417   161.758     0.200
     6.707   168.160     0.200
     6.718   173.059     0.200
     6.832   175.059     0.200
     6.918   173.957     0.200
     7.283   186.059     0.200
     7.819   197.258     0.200
     7.861   201.457     0.200
     7.885   198.660     0.200
     7.914   195.859     0.200
     9.462   234.457     0.200
    13.093   329.059     0.200
     0.184    16.066     0.200
     0.349    18.465     0.200
     0.718    23.566     0.200
     1.145    35.668     0.200
     1.452    42.465     0.200
     1.694    44.668     0.200
     1.895    51.965     0.200
     1.965    55.168     0.200
     2.103    57.066     0.200
     2.060    58.066     0.200
     2.117    59.168     0.200
     2.301    62.566     0.200
     2.714    74.465     0.200
     2.732    73.066     0.200
     2.957    79.168     0.200
     3.341    87.965     0.200
     3.346    88.766     0.200
     3.459    93.066     0.200
     4.055   105.168     0.200
     4.525   118.867     0.200
     4.715   122.867     0.200
     5.552   143.668     0.200
     5.578   144.066     0.200
     6.201   158.867     0.200
     6.446   160.465     0.200
     6.976   176.066     0.200
     7.850   197.066     0.200
     7.918   198.465     0.200
     7.945   196.266     0.200
     0.232    17.828     0.200
     0.263    18.023     0.200
     0.742    24.523     0.200
     1.222    37.922     0.200
     1.532    44.328     0.200
     1.684    46.227     0.200
     1.808    50.023     0.200
     2.017    54.328     0.200
     2.076    54.828     0.200
     2.049    57.523     0.200
     2.142    59.023     0.200
     2.634    71.625     0.200
     2.683    72.328     0.200
     2.895    78.023     0.200
     3.292    87.625     0.200
     3.297    87.023     0.200
     3.401    94.625     0.200
     4.004   104.328     0.200
     4.465   117.227     0.200
     5.523   142.625     0.200
     6.394   160.828     0.200
     7.794   193.625     0.200
     7.858   197.922     0.200
     0.215    17.273     0.200
     0.731    25.176     0.200
     1.250    37.574     0.200
     1.552    42.875     0.200
     1.562    44.773     0.200
     1.653    47.375     0.200
     1.762    49.773     0.200
     2.036    55.074     0.200
     2.024    56.875     0.200
     2.033    57.574     0.200
     2.173    58.074     0.200
     2.175    60.473     0.200
     2.200    62.074     0.200
     2.604    72.273     0.200
     2.750    75.074     0.200
     2.682    72.473     0.200
     2.883    76.273     0.200
     3.226    83.074     0.200
     3.290    87.273     0.200
     3.296    87.473     0.200
     3.342    93.074     0.200
     3.603    96.773     0.200
     4.002   103.773     0.200
     4.454   116.473     0.200
     4.617   123.074     0.200
     4.762   121.375     0.200
     5.504   142.676     0.200
     5.517   142.176     0.200
     6.149   158.676     0.200
     6.161   157.273     0.200
     6.391   161.973     0.200
     6.566   172.273     0.200
     6.690   167.473     0.200
     6.917   174.074     0.200
     7.788   192.574     0.200
     7.819   200.574     0.200
     7.848   196.074     0.200
     7.883   196.375     0.200
     8.287   212.074     0.200
    10.101   253.074     0.200
    18.485   453.375     0.200
     0.207    16.533     0.200
     0.305    18.633     0.200
     1.185    36.934     0.200
     1.494    43.633     0.200
     1.690    47.332     0.200
     1.851    51.533     0.200
     1.993    55.633     0.200
     2.090    57.033     0.200
     2.102    59.033     0.200
     2.081    58.133     0.200
     2.263    61.533     0.200
     2.673    74.033     0.200
     2.705    73.133     0.200
     2.924    78.232     0.200
     3.314    88.133     0.200
     3.319    88.133     0.200
     3.428    94.633     0.200
     3.655    98.533     0.200
     4.027   105.434     0.200
     4.493   118.033     0.200
     4.774   124.434     0.200
     5.549   143.332     0.200
     6.174   156.533     0.200
     6.418   162.133     0.200
     6.709   167.832     0.200
     6.944   176.133     0.200
     7.820   195.533     0.200
     7.886   199.232     0.200
     7.915   196.033     0.200
     0.218    17.195     0.200
     0.268    18.695     0.200
     0.727    24.395     0.200
     1.210    36.996     0.200
     1.520    44.195     0.200
     1.606    43.695     0.200
     1.671    46.594     0.200
     1.815    51.395     0.200
     1.961    52.895     0.200
     2.003    54.797     0.200
     2.065    55.496     0.200
     2.063    58.297     0.200
     2.225    59.695     0.200
     2.131    59.996     0.200
     2.242    63.094     0.200
     2.646    73.594     0.200
     2.712    73.195     0.200
     2.698    73.195     0.200
     2.909    78.996     0.200
     3.182    83.195     0.200
     3.307    88.496     0.200
     3.312    88.496     0.200
     3.378    93.195     0.200
     3.416    92.195     0.200
     3.635    96.996     0.200
     4.019   105.496     0.200
     4.479   118.195     0.200
     4.578   121.695     0.200
     5.519   143.594     0.200
     5.538   142.797     0.200
     6.166   156.496     0.200
     6.182   159.195     0.200
     6.409   160.797     0.200
     7.873   198.195     0.200
     7.904   196.594     0.200
     0.667    23.984     0.200
     1.302    38.684     0.200
     1.761    50.582     0.200
     2.224    62.984     0.200
     2.524    70.082     0.200
     2.599    73.383     0.200
     2.632    72.184     0.200
     3.119    87.484     0.200
     3.130    85.883     0.200
     3.169    88.684     0.200
     1.262    34.676     0.200
     1.459    41.578     0.200
     1.524    44.375     0.200
     1.828    50.676     0.200
     1.841    53.176     0.200
     1.954    56.176     0.200
     1.936    51.977     0.200
     2.460    67.777     0.200
     2.548    70.977     0.200
     2.693    73.578     0.200
     3.150    86.277     0.200
     3.159    85.676     0.200
     3.855   102.875     0.200
     6.235   160.277     0.200
     6.719   173.875     0.200
     0.265    18.422     0.200
     0.710    24.422     0.200
     1.204    36.422     0.200
     1.515    43.320     0.200
     1.653    46.125     0.200
     1.598    44.023     0.200
     1.812    51.820     0.200
     1.990    54.523     0.200
     2.047    57.422     0.200
     2.127    57.820     0.200
     2.073    55.422     0.200
     2.214    58.422     0.200
     2.247    63.523     0.200
     2.705    71.719     0.200
     2.651    75.523     0.200
     2.712    72.922     0.200
     2.920    78.922     0.200
     3.178    82.922     0.200
     3.372    88.422     0.200
     3.320    87.922     0.200
     3.326    88.320     0.200
     3.386    92.422     0.200
     4.033   105.422     0.200
     4.572   119.422     0.200
     4.491   118.422     0.200
     5.533   143.219     0.200
     5.551   143.219     0.200
     6.180   156.023     0.200
     6.423   159.922     0.200
     6.737   168.625     0.200
     6.907   177.422     0.200
     7.678   195.125     0.200
     7.678   193.719     0.200
     7.733   195.523     0.200
     7.822   194.523     0.200
     8.331   215.422     0.200
     8.660   223.422     0.200
    11.067   279.422     0.200
     0.330    15.850     0.200
     0.371    15.150     0.200
     1.109    34.449     0.200
     1.190    35.850     0.200
     1.482    42.650     0.200
     1.429    41.350     0.200
     1.603    44.549     0.200
     1.830    49.250     0.200
     2.000    54.750     0.200
     2.052    57.350     0.200
     2.381    65.750     0.200
     2.848    76.449     0.200
     3.098    84.049     0.200
     3.248    87.850     0.200
     3.701    98.350     0.200
     3.710    98.449     0.200
     3.923   105.049     0.200
     4.408   115.350     0.200
     4.824   126.949     0.200
     6.790   173.350     0.200
     7.117   185.850     0.200
     0.095    14.757     0.200
     0.831    28.557     0.200
     1.470    40.857     0.200
     1.495    44.157     0.200
     1.587    45.957     0.200
     1.902    53.457     0.200
     1.813    50.957     0.200
     1.876    53.457     0.200
     1.973    56.157     0.200
     2.376    65.857     0.200
     2.434    66.057     0.200
     2.603    71.657     0.200
     2.742    75.457     0.200
     3.203    87.857     0.200
     3.213    86.057     0.200
     3.425    93.957     0.200
     3.908   102.457     0.200
     4.318   115.957     0.200
     5.417   143.257     0.200
     6.287   160.057     0.200
     0.277    17.773     0.200
     0.725    24.773     0.200
     1.202    36.578     0.200
     1.512    43.578     0.200
     1.615    44.477     0.200
     1.674    47.375     0.200
     1.824    51.375     0.200
     1.998    56.375     0.200
     2.069    56.375     0.200
     2.123    57.375     0.200
     2.069    57.977     0.200
     2.250    63.875     0.200
     2.702    72.477     0.200
     2.914    78.578     0.200
     3.311    88.773     0.200
     3.316    88.875     0.200
     4.023   105.078     0.200
     4.484   117.672     0.200
     4.766   121.375     0.200
     5.523   143.273     0.200
     5.543   142.977     0.200
     6.170   158.578     0.200
     6.414   161.578     0.200
     7.667   193.977     0.200
     7.667   193.578     0.200
     7.814   194.375     0.200
     7.909   195.273     0.200
    18.473   451.375     0.200
    20.757   513.375     0.200
     0.043    11.094     0.200
     0.797    27.297     0.200
     1.384    38.891     0.200
     1.401    41.797     0.200
     1.590    44.797     0.200
     1.631    46.992     0.200
     1.717    49.797     0.200
     1.950    56.297     0.200
     1.975    56.094     0.200
     1.919    54.094     0.200
     2.053    57.094     0.200
     2.124    56.992     0.200
     2.334    64.695     0.200
     2.610    70.492     0.200
     2.779    76.797     0.200
     3.210    87.992     0.200
     3.215    87.195     0.200
     3.924   102.797     0.200
     4.181   111.094     0.200
     4.759   127.094     0.200
     4.770   128.094     0.200
     5.440   143.391     0.200
     6.071   155.891     0.200
     6.309   160.195     0.200
     6.589   168.992     0.200
     6.668   171.094     0.200
     6.806   171.094     0.200
     6.907   176.094     0.200
     7.170   184.992     0.200
     7.287   182.391     0.200
     7.434   188.391     0.200
     7.546   192.992     0.200
     7.588   191.492     0.200
     7.648   193.891     0.200
     7.696   192.992     0.200
     7.881   197.797     0.200
     7.981   203.391     0.200
     8.246   208.594     0.200
     9.372   230.797     0.200
    12.838   321.094     0.200
    14.328   361.094     0.200
    18.545   457.094     0.200
     0.371    16.836     0.200
     1.378    40.836     0.200
     1.659    47.938     0.200
     1.627    44.539     0.200
     1.692    48.438     0.200
     2.011    56.836     0.200
     1.926    53.539     0.200
     2.063    55.836     0.200
     2.073    57.836     0.200
     2.120    60.633     0.200
     2.307    63.234     0.200
     2.477    67.133     0.200
     2.604    71.234     0.200
     2.782    75.633     0.200
     3.210    86.039     0.200
     3.217    87.336     0.200
     3.919   103.336     0.200
     4.357   115.133     0.200
     5.425   142.539     0.200
     6.306   156.234     0.200
     6.809   173.633     0.200
     7.580   190.836     0.200
     7.714   200.438     0.200
     0.215    17.281     0.200
     0.738    24.883     0.200
     1.254    37.582     0.200
     1.554    42.680     0.200
     1.566    44.980     0.200
     1.660    47.281     0.200
     1.762    50.281     0.200
     1.957    54.781     0.200
     2.043    56.383     0.200
     2.030    56.281     0.200
     2.186    60.082     0.200
     2.178    59.883     0.200
     2.201    60.980     0.200
     2.203    61.680     0.200
     2.601    72.180     0.200
     2.776    75.281     0.200
     2.877    78.980     0.200
     3.283    87.383     0.200
     3.289    87.582     0.200
     3.995   103.781     0.200
     4.448   117.082     0.200
     4.621   120.281     0.200
     6.142   154.980     0.200
     6.155   157.582     0.200
     6.384   161.180     0.200
     6.780   178.281     0.200
     7.499   189.082     0.200
     7.645   192.582     0.200
     7.700   193.680     0.200
     7.782   194.383     0.200
     7.901   196.281     0.200
     8.020   201.680     0.200
     0.365    19.801     0.200
     0.682    25.699     0.200
     0.795    29.199     0.200
     0.983    31.801     0.200
     1.587    45.398     0.200
     1.590    46.699     0.200
     1.649    44.898     0.200
     1.851    51.602     0.200
     2.140    56.000     0.200
     2.331    64.000     0.200
     2.572    68.500     0.200
     2.629    70.398     0.200
     2.785    74.801     0.200
     3.185    84.301     0.200
     3.246    85.398     0.200
     3.399    88.699     0.200
     3.745    97.102     0.200
     3.746    97.500     0.200
     4.149   111.102     0.200
     4.459   114.199     0.200
     4.622   121.898     0.200
     4.957   128.801     0.200
     5.154   136.500     0.200
     6.598   166.699     0.200
     6.639   167.398     0.200
     6.850   169.301     0.200
     6.906   177.898     0.200
     7.315   188.500     0.200
     7.405   186.898     0.200
     7.937   199.801     0.200
     8.062   202.602     0.200
     8.107   202.699     0.200
     0.569    19.780     0.200
     1.408    40.780     0.200
     1.879    53.080     0.200
     2.026    56.780     0.200
     2.222    60.780     0.200
     2.306    64.181     0.200
     2.765    76.980     0.200
     2.956    80.380     0.200
     3.057    82.580     0.200
     3.463    93.681     0.200
     3.468    92.880     0.200
     4.175   109.681     0.200
     4.629   122.780     0.200
     5.554   143.181     0.200
     5.736   148.480     0.200
     6.322   163.280     0.200
     6.335   162.280     0.200
     6.565   164.280     0.200
     6.578   173.580     0.200
     7.081   178.380     0.200
     7.678   193.980     0.200
     7.822   198.280     0.200
     7.821   196.280     0.200
     8.082   200.780     0.200
     0.241    17.594     0.200
     0.295    17.297     0.200
     0.722    24.195     0.200
     1.226    36.797     0.200
     1.538    43.594     0.200
     1.577    44.094     0.200
     1.655    47.398     0.200
     1.770    50.195     0.200
     1.788    50.195     0.200
     1.948    55.492     0.200
     2.007    56.195     0.200
     2.044    56.898     0.200
     2.053    56.898     0.200
     2.150    58.195     0.200
     2.151    61.094     0.200
     2.228    63.695     0.200
     2.230    61.695     0.200
     2.628    74.398     0.200
     2.798    75.492     0.200
     2.930    78.492     0.200
     3.304    87.992     0.200
     3.310    87.695     0.200
     3.624    99.992     0.200
     4.016   104.398     0.200
     4.472   117.695     0.200
     4.594   122.695     0.200
     4.659   122.492     0.200
     4.757   123.195     0.200
     5.395   138.492     0.200
     5.518   141.195     0.200
     5.577   142.492     0.200
     6.163   158.695     0.200
     6.177   156.094     0.200
     6.406   162.195     0.200
     6.701   171.594     0.200
     6.924   174.297     0.200
     7.663   193.695     0.200
     7.664   194.695     0.200
     7.804   195.695     0.200
     7.838   200.094     0.200
     7.866   197.695     0.200
     7.923   196.594     0.200
     8.044   202.492     0.200
     0.555    20.070     0.200
     1.011    31.070     0.200
     1.348    40.070     0.200
     1.351    40.871     0.200
     1.378    41.570     0.200
     1.604    44.770     0.200
     1.627    45.371     0.200
     1.701    48.371     0.200
     1.690    48.070     0.200
     1.782    51.672     0.200
     2.306    62.973     0.200
     2.368    65.172     0.200
     3.232    88.371     0.200
     3.741   101.270     0.200
     3.752   101.973     0.200
     0.235    17.875     0.200
     0.235    17.281     0.200
     1.234    36.477     0.200
     1.546    44.578     0.200
     1.763    49.180     0.200
     1.782    50.078     0.200
     2.014    57.680     0.200
     2.045    57.078     0.200
     2.144    60.375     0.200
     2.200    60.180     0.200
     2.158    59.781     0.200
     2.223    61.680     0.200
     2.620    72.180     0.200
     2.791    75.875     0.200
     2.922    78.578     0.200
     3.298    87.078     0.200
     3.303    87.281     0.200
     4.009   103.578     0.200
     4.465   117.078     0.200
     4.651   123.281     0.200
     5.389   139.477     0.200
     5.570   145.578     0.200
     0.153    15.328     0.200
     0.339    17.129     0.200
     0.674    24.629     0.200
     1.504    44.129     0.200
     1.607    43.729     0.200
     1.627    45.229     0.200
     1.644    46.527     0.200
     1.860    53.428     0.200
     1.992    54.129     0.200
     2.154    60.729     0.200
     2.141    60.428     0.200
     2.266    62.129     0.200
     2.547    68.629     0.200
     2.833    78.729     0.200
     2.938    78.629     0.200
     3.342    90.428     0.200
     4.050   104.928     0.200
     5.430   138.828     0.200
     5.595   145.928     0.200
     6.433   160.527     0.200
     6.925   179.527     0.200
     7.717   195.828     0.200
     7.864   199.129     0.200
     0.477    19.566     0.200
     0.496    19.066     0.200
     0.570    21.168     0.200
     0.590    21.066     0.200
     1.069    31.969     0.200
     1.399    40.766     0.200
     1.423    40.867     0.200
     1.634    44.969     0.200
     1.656    46.566     0.200
     1.636    45.766     0.200
     2.255    61.867     0.200
     2.366    65.066     0.200
     2.372    62.867     0.200
     2.457    67.367     0.200
     2.740    74.566     0.200
     3.197    85.668     0.200
     3.706    99.867     0.200
     4.405   117.469     0.200
     0.492    18.432     0.200
     0.693    24.732     0.200
     1.219    35.232     0.200
     1.479    42.932     0.200
     1.499    42.732     0.200
     1.753    51.332     0.200
     2.033    59.432     0.200
     2.100    60.732     0.200
     2.143    61.232     0.200
     2.485    69.132     0.200
     2.869    79.232     0.200
     2.950    81.432     0.200
     3.378    95.732     0.200
     3.388    94.032     0.200
     4.080   111.632     0.200
     5.459   144.732     0.200
     0.310    17.570     0.200
     0.365    18.171     0.200
     0.720    24.271     0.200
     1.175    36.271     0.200
     1.484    42.570     0.200
     1.681    47.570     0.200
     1.647    45.471     0.200
     1.838    51.471     0.200
     1.856    51.771     0.200
     1.981    55.870     0.200
     2.083    56.771     0.200
     2.093    56.771     0.200
     2.092    58.271     0.200
     2.208    60.070     0.200
     2.188    61.271     0.200
     2.272    61.771     0.200
     2.282    63.771     0.200
     2.682    73.471     0.200
     2.821    75.070     0.200
     2.935    79.271     0.200
     2.960    79.671     0.200
     3.326    87.771     0.200
     3.330    87.471     0.200
     4.039   104.870     0.200
     4.545   121.271     0.200
     4.504   117.070     0.200
     4.905   129.771     0.200
     5.417   136.671     0.200
     5.538   141.771     0.200
     5.604   144.070     0.200
     6.185   154.870     0.200
     6.204   157.771     0.200
     6.430   160.471     0.200
     6.453   166.171     0.200
     6.738   168.370     0.200
     6.843   178.771     0.200
     6.956   176.171     0.200
     7.538   191.070     0.200
     7.679   193.070     0.200
     7.733   195.671     0.200
     7.873   201.271     0.200
     7.897   198.570     0.200
     7.950   196.471     0.200
     8.493   215.070     0.200
     8.709   225.870     0.200
    10.190   259.771     0.200
    13.092   329.771     0.200
    18.462   454.771     0.200
     0.640    22.812     0.200
     0.931    30.613     0.200
     1.114    36.414     0.200
     1.310    39.914     0.200
     1.287    36.613     0.200
     1.311    38.113     0.200
     1.377    40.414     0.200
     2.032    56.914     0.200
     2.313    64.312     0.200
     2.649    72.312     0.200
     2.766    73.414     0.200
     3.102    82.715     0.200
     3.128    84.414     0.200
     3.606    97.215     0.200
     3.621    96.613     0.200
     4.140   113.113     0.200
     4.613   124.215     0.200
     0.296    19.941     0.200
     0.274    20.840     0.200
     1.169    35.539     0.200
     1.548    43.039     0.200
     1.485    42.641     0.200
     1.561    43.340     0.200
     1.784    50.742     0.200
     1.803    51.039     0.200
     1.914    52.840     0.200
     1.946    51.641     0.200
     2.103    57.742     0.200
     2.166    59.742     0.200
     2.136    59.340     0.200
     2.219    59.242     0.200
     2.237    62.539     0.200
     2.288    64.641     0.200
     2.719    74.441     0.200
     2.688    76.039     0.200
     2.896    77.742     0.200
     3.021    80.441     0.200
     3.404    93.539     0.200
     3.403    89.340     0.200
     3.409    90.539     0.200
     3.439    93.641     0.200
     3.703    99.242     0.200
     4.115   106.441     0.200
     4.528   120.641     0.200
     4.647   119.641     0.200
     4.563   119.539     0.200
     5.618   143.141     0.200
     5.672   145.840     0.200
     6.262   158.840     0.200
     6.272   158.941     0.200
     6.503   161.742     0.200
     6.824   170.441     0.200
     7.686   193.641     0.200
     7.765   195.641     0.200
     7.767   194.539     0.200
     7.956   200.141     0.200
     8.018   196.941     0.200
     8.176   206.141     0.200
    10.079   256.641     0.200
     0.509    21.037     0.200
     0.587    23.836     0.200
     0.911    29.836     0.200
     1.003    32.736     0.200
     1.105    33.037     0.200
     1.127    34.736     0.200
     1.394    42.637     0.200
     1.408    40.836     0.200
     1.578    45.537     0.200
     1.765    50.736     0.200
     1.816    51.236     0.200
     1.866    53.537     0.200
     2.033    56.938     0.200
     2.136    57.037     0.200
     2.228    63.137     0.200
     2.759    71.836     0.200
     2.821    76.137     0.200
     2.877    74.537     0.200
     2.848    76.736     0.200
     3.324    89.438     0.200
     3.340    89.836     0.200
     4.007   106.236     0.200
     5.375   140.637     0.200
     0.148    11.598     0.200
     0.217    14.098     0.200
     0.599    21.398     0.200
     0.866    29.000     0.200
     1.347    38.098     0.200
     1.367    39.301     0.200
     1.578    45.398     0.200
     1.776    49.199     0.200
     1.826    52.199     0.200
     1.899    52.398     0.200
     1.929    54.699     0.200
     1.970    54.199     0.200
     2.284    62.699     0.200
     2.316    64.098     0.200
     2.638    69.301     0.200
     2.702    73.199     0.200
     2.778    75.301     0.200
     3.211    87.199     0.200
     3.222    86.898     0.200
     3.911   104.199     0.200
     5.289   139.301     0.200
     6.284   161.301     0.200
     0.066    12.492     0.200
     0.181    15.391     0.200
     0.537    21.391     0.200
     0.808    27.789     0.200
     1.410    40.094     0.200
     1.430    41.094     0.200
     1.514    44.188     0.200
     1.819    50.289     0.200
     1.818    51.094     0.200
     1.834    50.289     0.200
     1.989    55.688     0.200
     2.019    55.891     0.200
     2.342    63.891     0.200
     2.377    67.891     0.200
     2.457    65.891     0.200
     2.574    67.289     0.200
     2.744    75.094     0.200
     2.826    76.789     0.200
     3.253    88.594     0.200
     3.263    86.789     0.200
     3.445    95.992     0.200
     3.955   103.789     0.200
     4.353   116.789     0.200
     5.334   135.891     0.200
     0.191    15.141     0.200
     0.345    16.941     0.200
     0.642    23.340     0.200
     1.316    39.238     0.200
     1.606    44.238     0.200
     1.627    44.441     0.200
     1.636    46.238     0.200
     2.065    57.840     0.200
     2.175    59.441     0.200
     2.172    60.941     0.200
     2.259    61.441     0.200
     2.376    62.641     0.200
     2.565    70.039     0.200
     2.870    78.738     0.200
     2.971    80.539     0.200
     3.379    91.039     0.200
     3.388    91.738     0.200
     4.086   109.840     0.200
     4.506   118.441     0.200
     5.466   143.238     0.200
     5.629   148.039     0.200
     6.226   161.441     0.200
     6.233   158.840     0.200
     6.469   161.340     0.200
     6.742   172.641     0.200
     6.809   170.141     0.200
     6.956   180.141     0.200
     7.450   189.238     0.200
     7.598   192.141     0.200
     7.655   196.238     0.200
     7.748   193.840     0.200
     7.755   193.641     0.200
     7.816   197.441     0.200
     7.852   196.238     0.200
     7.895   201.941     0.200
     7.972   197.840     0.200
     8.114   206.340     0.200
     8.404   210.238     0.200
     0.283    17.895     0.200
     0.728    24.795     0.200
     1.199    36.695     0.200
     1.509    43.494     0.200
     1.621    44.895     0.200
     1.679    47.395     0.200
     1.728    48.594     0.200
     1.811    50.795     0.200
     1.829    50.395     0.200
     1.998    56.195     0.200
     2.075    57.395     0.200
     2.071    58.594     0.200
     2.119    58.695     0.200
     2.250    60.395     0.200
     2.233    59.795     0.200
     2.257    63.994     0.200
     2.804    75.895     0.200
     2.915    78.395     0.200
     2.942    79.195     0.200
     3.310    88.094     0.200
     3.315    87.594     0.200
     3.398    90.395     0.200
     3.389    91.395     0.200
     4.022   104.795     0.200
     4.292   110.395     0.200
     4.485   115.395     0.200
     4.673   122.695     0.200
     4.769   126.395     0.200
     5.401   139.994     0.200
     5.522   143.795     0.200
     5.586   145.094     0.200
     6.169   155.594     0.200
     6.413   162.094     0.200
     6.434   169.395     0.200
     7.016   178.395     0.200
     7.279   186.395     0.200
     7.523   189.895     0.200
     7.594   191.395     0.200
     7.665   194.494     0.200
     7.933   196.395     0.200
     8.356   216.395     0.200
    10.630   271.395     0.200
     0.021    11.688     0.200
     0.106    14.588     0.200
     0.486    19.889     0.200
     0.806    27.787     0.200
     1.461    41.287     0.200
     1.478    43.389     0.200
     1.480    42.488     0.200
     1.797    50.088     0.200
     1.843    51.988     0.200
     1.879    55.588     0.200
     1.892    52.088     0.200
     2.005    56.188     0.200
     2.010    56.287     0.200
     2.396    66.389     0.200
     2.403    65.389     0.200
     2.418    64.988     0.200
     2.535    66.389     0.200
     2.720    74.688     0.200
     2.812    76.688     0.200
     3.230    87.787     0.200
     3.239    87.588     0.200
     3.934   105.188     0.200
     4.344   117.188     0.200
     4.518   118.889     0.200
     5.314   134.787     0.200
     5.472   142.988     0.200
     6.313   157.488     0.200
     7.448   187.787     0.200
     7.599   189.988     0.200
     7.672   191.787     0.200
     7.732   197.588     0.200
     7.813   194.287     0.200
     0.126    16.750     0.200
     0.226    16.051     0.200
     0.334    18.051     0.200
     0.783    27.051     0.200
     1.339    40.051     0.200
     1.653    46.348     0.200
     1.652    46.148     0.200
     1.671    46.750     0.200
     1.809    50.949     0.200
     2.024    57.051     0.200
     2.056    57.148     0.200
     2.110    57.848     0.200
     2.118    60.449     0.200
     2.267    62.051     0.200
     2.382    64.051     0.200
     2.515    70.051     0.200
     2.611    69.949     0.200
     2.721    73.648     0.200
     2.842    75.551     0.200
     3.229    88.148     0.200
     3.236    85.449     0.200
     3.939   101.648     0.200
     6.327   156.848     0.200
     7.720   193.551     0.200
     7.776   197.250     0.200
     1.134    34.031     0.200
     1.179    34.633     0.200
     1.758    49.828     0.200
     1.875    51.227     0.200
     2.099    56.828     0.200
     2.120    57.133     0.200
     2.689    73.133     0.200
     2.712    73.430     0.200
     3.103    84.328     0.200
     3.350    88.633     0.200
     3.476    91.828     0.200
     3.857   102.328     0.200
     3.863   102.328     0.200
     4.569   121.227     0.200
     6.958   173.930     0.200
     7.469   189.328     0.200
     0.159    16.031     0.200
     0.333    19.332     0.200
     0.410    18.432     0.200
     0.688    23.932     0.200
     1.141    35.531     0.200
     1.450    42.432     0.200
     1.678    47.432     0.200
     1.832    52.332     0.200
     1.862    51.332     0.200
     1.880    52.332     0.200
     1.945    55.031     0.200
     2.061    57.932     0.200
     2.175    59.031     0.200
     2.167    60.633     0.200
     2.224    61.832     0.200
     2.281    60.832     0.200
     2.317    64.932     0.200
     2.420    67.932     0.200
     2.510    68.932     0.200
     2.661    72.633     0.200
     2.822    77.732     0.200
     2.857    77.432     0.200
     2.997    80.932     0.200
     3.120    83.232     0.200
     3.362    89.133     0.200
     3.613    96.232     0.200
     4.035   105.932     0.200
     4.328   113.732     0.200
     4.513   119.133     0.200
     4.677   124.232     0.200
     4.741   124.133     0.200
     5.640   147.133     0.200
     6.221   154.732     0.200
     6.466   159.633     0.200
     6.879   179.832     0.200
     6.992   174.432     0.200
     7.716   190.031     0.200
     7.934   197.832     0.200
     7.987   196.232     0.200
     8.156   206.133     0.200
     0.247    18.180     0.200
     0.211    17.875     0.200
     0.277    17.477     0.200
     0.438    18.875     0.200
     0.685    24.773     0.200
     0.880    29.773     0.200
     1.179    34.180     0.200
     1.235    37.578     0.200
     1.316    39.273     0.200
     1.434    42.773     0.200
     1.500    43.078     0.200
     1.537    44.875     0.200
     1.570    45.773     0.200
     1.706    48.680     0.200
     1.722    49.680     0.200
     1.735    49.680     0.200
     1.775    50.773     0.200
     1.819    50.875     0.200
     1.896    54.180     0.200
     2.079    58.680     0.200
     2.070    58.078     0.200
     2.187    61.078     0.200
     2.281    60.273     0.200
     2.276    63.773     0.200
     2.252    62.477     0.200
     2.319    65.375     0.200
     2.604    70.578     0.200
     2.948    78.078     0.200
     3.383    90.578     0.200
     3.571    93.375     0.200
     4.003   102.680     0.200
     4.281   111.078     0.200
     5.160   134.273     0.200
     6.189   154.477     0.200
     6.431   158.773     0.200
     6.941   173.773     0.200
     0.079    13.713     0.200
     0.508    20.713     0.200
     0.447    20.713     0.200
     0.664    23.013     0.200
     1.001    31.513     0.200
     1.111    34.513     0.200
     1.157    34.713     0.200
     1.220    36.612     0.200
     1.243    39.713     0.200
     1.334    38.713     0.200
     1.417    41.213     0.200
     1.460    42.513     0.200
     1.583    48.013     0.200
     1.714    48.213     0.200
     1.730    49.913     0.200
     1.817    51.413     0.200
     1.810    52.112     0.200
     1.882    53.213     0.200
     1.878    53.913     0.200
     1.909    55.513     0.200
     1.978    56.812     0.200
     2.009    56.612     0.200
     2.044    57.112     0.200
     2.049    59.112     0.200
     2.036    55.913     0.200
     2.410    65.612     0.200
     2.488    69.013     0.200
     2.486    68.213     0.200
     2.563    66.213     0.200
     2.770    75.913     0.200
     2.851    78.913     0.200
     2.978    81.112     0.200
     3.491    93.812     0.200
     0.392    17.838     0.200
     0.618    21.238     0.200
     0.660    20.938     0.200
     0.793    26.238     0.200
     0.962    30.238     0.200
     1.066    34.938     0.200
     1.164    34.238     0.200
     1.264    38.738     0.200
     1.469    42.138     0.200
     1.600    44.538     0.200
     1.584    46.138     0.200
     1.622    48.738     0.200
     1.649    46.838     0.200
     1.836    51.838     0.200
     2.335    65.238     0.200
     2.410    63.238     0.200
     2.437    67.538     0.200
     3.316    90.038     0.200
     3.375    90.738     0.200
     0.408    17.430     0.200
     0.428    16.930     0.200
     0.483    21.023     0.200
     0.817    26.828     0.200
     0.976    29.828     0.200
     0.956    30.227     0.200
     1.003    31.727     0.200
     1.301    37.328     0.200
     1.346    41.523     0.200
     1.451    40.328     0.200
     1.439    42.328     0.200
     1.428    42.625     0.200
     1.502    43.023     0.200
     1.694    47.930     0.200
     1.702    47.828     0.200
     1.925    54.828     0.200
     2.143    61.125     0.200
     2.255    63.125     0.200
     2.244    60.930     0.200
     2.288    59.430     0.200
     2.375    65.023     0.200
     2.386    66.023     0.200
     2.427    66.930     0.200
     3.147    86.523     0.200
     3.360    90.523     0.200
     0.536    21.266     0.200
     0.815    26.469     0.200
     0.926    29.164     0.200
     0.936    30.867     0.200
     1.217    38.367     0.200
     1.406    40.266     0.200
     1.473    42.469     0.200
     1.586    46.766     0.200
     1.595    45.367     0.200
     1.661    46.867     0.200
     1.763    50.266     0.200
     1.769    48.969     0.200
     1.860    52.969     0.200
     1.939    55.664     0.200
     2.248    61.266     0.200
     2.277    62.664     0.200
     2.561    68.367     0.200
     2.577    68.766     0.200
     2.723    71.766     0.200
     2.835    76.766     0.200
     3.004    79.062     0.200
     3.204    85.164     0.200
     3.323    86.164     0.200
     3.442    89.062     0.200
     3.796    99.266     0.200
     3.920   100.562     0.200
     4.320   108.664     0.200
     4.644   119.562     0.200
     5.038   126.664     0.200
     5.466   136.766     0.200
     5.733   144.367     0.200
     1.055    33.465     0.200
     1.091    34.164     0.200
     1.562    47.062     0.200
     1.915    56.965     0.200
     1.903    56.863     0.200
     2.088    60.164     0.200
     2.119    61.762     0.200
     2.557    71.664     0.200
     2.553    71.465     0.200
     2.733    78.664     0.200
     2.922    78.363     0.200
     2.919    79.762     0.200
     2.933    81.965     0.200
     3.061    85.164     0.200
     3.420    94.562     0.200
     4.064   109.465     0.200
     6.610   172.465     0.200
     1.019    31.938     0.200
     1.092    34.438     0.200
     1.299    40.137     0.200
     1.830    54.637     0.200
     1.848    54.836     0.200
     1.915    56.438     0.200
     2.551    72.238     0.200
     2.920    78.738     0.200
     2.918    81.035     0.200
     3.060    85.738     0.200
     3.418    94.535     0.200
     4.062   109.738     0.200
     1.001    30.477     0.200
     1.179    34.477     0.200
     1.304    37.977     0.200
     1.483    42.773     0.200
     1.449    42.977     0.200
     1.554    45.172     0.200
     1.682    48.570     0.200
     1.692    49.773     0.200
     2.010    56.375     0.200
     2.192    60.570     0.200
     2.239    61.273     0.200
     2.288    62.977     0.200
     2.347    64.070     0.200
     2.569    66.672     0.200
     2.784    76.570     0.200
     2.847    77.977     0.200
     2.880    77.672     0.200
     2.873    78.273     0.200
     3.210    85.070     0.200
     3.254    87.875     0.200
     3.382    90.375     0.200
     3.603    95.977     0.200
     3.716    97.672     0.200
     3.903   104.070     0.200
     4.125   108.672     0.200
     4.372   115.570     0.200
     4.576   121.773     0.200
     4.858   128.773     0.200
     5.034   130.977     0.200
     5.779   150.570     0.200
     5.907   154.375     0.200
     6.296   160.672     0.200
     1.099    33.438     0.200
     1.248    36.738     0.200
     1.285    37.840     0.200
     1.323    38.340     0.200
     1.497    43.238     0.200
     1.482    42.539     0.200
     1.662    47.340     0.200
     1.813    51.340     0.200
     1.821    51.641     0.200
     1.894    53.141     0.200
     1.977    56.438     0.200
     2.008    55.340     0.200
     2.475    67.938     0.200
     2.461    68.738     0.200
     2.512    66.438     0.200
     2.739    74.641     0.200
     2.832    77.039     0.200
     0.239    12.991     0.200
     0.396    15.491     0.200
     0.456    17.892     0.200
     0.691    24.291     0.200
     0.960    29.191     0.200
     1.276    39.092     0.200
     1.285    36.991     0.200
     1.481    43.291     0.200
     1.529    43.491     0.200
     1.547    45.592     0.200
     1.625    47.691     0.200
     1.626    45.791     0.200
     1.647    46.892     0.200
     1.843    51.491     0.200
     1.881    53.092     0.200
     2.080    58.892     0.200
     2.123    59.291     0.200
     2.134    55.791     0.200
     2.272    63.291     0.200
     2.409    67.592     0.200
     2.471    68.892     0.200
     2.697    72.291     0.200
     2.821    77.092     0.200
     3.050    81.592     0.200
     3.169    84.491     0.200
     3.294    87.291     0.200
     3.558    95.592     0.200
     5.648   144.092     0.200
     0.695    24.105     0.200
     1.365    41.305     0.200
     1.429    42.105     0.200
     1.851    53.305     0.200
     1.978    57.405     0.200
     2.746    77.105     0.200
     2.951    80.505     0.200
     3.255    89.405     0.200
     0.271    13.750     0.200
     0.352    14.344     0.200
     0.780    25.648     0.200
     1.097    32.547     0.200
     1.399    40.945     0.200
     1.409    41.344     0.200
     1.633    46.344     0.200
     1.654    46.945     0.200
     1.725    48.648     0.200
     1.717    47.945     0.200
     1.837    50.844     0.200
     1.851    52.047     0.200
     2.166    57.445     0.200
     2.175    61.344     0.200
     2.181    60.844     0.200
     2.186    60.844     0.200
     2.263    63.047     0.200
     2.257    63.547     0.200
     2.334    64.445     0.200
     2.413    66.547     0.200
     2.427    67.547     0.200
     2.694    74.047     0.200
     2.846    78.648     0.200
     2.899    78.047     0.200
     3.034    80.945     0.200
     3.157    83.547     0.200
     3.652    96.344     0.200
     4.366   115.047     0.200
     0.124    14.998     0.200
     0.635    22.598     0.200
     0.970    31.297     0.200
     1.077    33.898     0.200
     1.184    38.498     0.200
     1.242    37.197     0.200
     1.288    37.098     0.200
     1.499    43.197     0.200
     1.528    46.598     0.200
     1.688    47.797     0.200
     1.735    50.197     0.200
     1.752    50.797     0.200
     1.765    50.297     0.200
     1.845    52.297     0.200
     1.931    54.697     0.200
     1.900    55.398     0.200
     1.996    54.398     0.200
     2.100    58.297     0.200
     2.118    60.998     0.200
     2.469    68.297     0.200
     2.545    69.297     0.200
     2.536    66.498     0.200
     2.829    77.398     0.200
     2.908    78.297     0.200
     3.035    81.998     0.200
     0.267    17.859     0.200
     0.366    17.164     0.200
     0.361    17.758     0.200
     0.799    27.758     0.200
     1.111    33.062     0.200
     1.374    41.359     0.200
     1.345    40.758     0.200
     1.576    44.859     0.200
     1.625    46.859     0.200
     1.644    47.258     0.200
     1.730    49.461     0.200
     1.738    48.961     0.200
     1.811    52.359     0.200
     1.823    51.961     0.200
     2.153    59.961     0.200
     2.163    60.258     0.200
     2.195    61.961     0.200
     2.192    58.664     0.200
     2.239    62.258     0.200
     2.384    66.562     0.200
     2.401    67.062     0.200
     2.824    76.562     0.200
     3.018    78.461     0.200
     3.392    88.961     0.200
     3.638    96.359     0.200
     4.768   120.359     0.200
     5.214   130.758     0.200
     0.999    31.871     0.200
     1.324    40.574     0.200
     1.355    40.973     0.200
     1.803    53.371     0.200
     1.893    56.074     0.200
     2.081    57.672     0.200
     2.544    71.773     0.200
     2.522    70.172     0.200
     2.649    71.773     0.200
     2.856    79.273     0.200
     2.914    79.574     0.200
     3.042    84.074     0.200
     3.559    99.074     0.200
     0.233    18.051     0.200
     0.309    17.152     0.200
     0.425    18.352     0.200
     0.863    29.551     0.200
     1.169    34.051     0.200
     1.409    41.551     0.200
     1.347    40.250     0.200
     1.411    43.750     0.200
     1.533    43.852     0.200
     1.568    45.352     0.200
     1.578    46.750     0.200
     1.699    48.250     0.200
     1.748    49.750     0.200
     1.801    50.352     0.200
     1.776    50.852     0.200
     1.765    49.750     0.200
     1.801    53.453     0.200
     2.099    58.953     0.200
     2.103    58.652     0.200
     2.256    59.953     0.200
     2.259    63.852     0.200
     2.216    60.953     0.200
     2.217    61.152     0.200
     2.285    64.152     0.200
     2.337    66.551     0.200
     2.327    65.551     0.200
     2.336    66.652     0.200
     2.496    68.152     0.200
     2.616    71.152     0.200
     2.711    73.953     0.200
     2.830    74.453     0.200
     2.958    78.750     0.200
     3.082    80.953     0.200
     3.191    87.652     0.200
     3.397    92.352     0.200
     4.009   102.152     0.200
     4.291   112.352     0.200
     4.711   119.152     0.200
     5.158   129.953     0.200
     5.428   137.352     0.200
     5.951   151.652     0.200
     6.450   161.551     0.200
     6.454   165.551     0.200
     6.756   168.953     0.200
     6.829   178.152     0.200
     6.829   177.852     0.200
     7.014   177.352     0.200
     7.033   174.551     0.200
     7.499   189.453     0.200
     7.607   190.953     0.200
     7.954   196.152     0.200
     7.990   201.953     0.200
     8.013   196.453     0.200
     8.115   205.051     0.200
     8.203   202.953     0.200
     0.238    17.109     0.200
     0.297    16.309     0.200
     0.430    18.309     0.200
     0.869    29.207     0.200
     1.335    40.207     0.200
     1.418    42.008     0.200
     1.404    42.707     0.200
     1.520    43.609     0.200
     1.556    45.410     0.200
     1.702    48.609     0.200
     1.738    50.410     0.200
     1.754    49.309     0.200
     1.775    50.707     0.200
     1.808    51.008     0.200
     1.793    52.809     0.200
     2.265    63.609     0.200
     2.272    64.109     0.200
     2.315    64.609     0.200
     2.753    74.508     0.200
     2.954    79.309     0.200
     3.078    81.707     0.200
     3.391    91.410     0.200
     4.288   112.508     0.200
     4.708   121.609     0.200
     5.948   151.309     0.200
     6.450   165.109     0.200
     0.691    22.648     0.200
     1.275    37.349     0.200
     1.508    44.048     0.200
     1.648    48.648     0.200
     1.649    48.048     0.200
     1.695    49.449     0.200
     1.738    48.548     0.200
     1.975    57.449     0.200
     2.003    55.548     0.200
     2.087    58.048     0.200
     2.444    67.749     0.200
     2.580    67.148     0.200
     0.152    13.547     0.200
     0.487    20.348     0.200
     0.487    21.748     0.200
     0.518    19.748     0.200
     0.963    31.447     0.200
     1.050    32.348     0.200
     1.187    34.947     0.200
     1.178    38.047     0.200
     1.257    36.648     0.200
     1.359    40.348     0.200
     1.556    44.748     0.200
     1.571    44.148     0.200
     1.609    46.547     0.200
     1.676    48.148     0.200
     1.887    52.447     0.200
     2.028    57.348     0.200
     2.198    61.348     0.200
     2.419    63.248     0.200
     2.532    70.848     0.200
     2.623    71.648     0.200
     2.891    78.547     0.200
     2.982    80.248     0.200
     3.109    82.947     0.200
     3.401    90.947     0.200
     3.619    95.848     0.200
     0.368    17.922     0.200
     0.446    18.320     0.200
     0.704    25.023     0.200
     0.762    24.820     0.200
     0.798    26.617     0.200
     1.005    30.719     0.200
     1.178    35.023     0.200
     1.296    38.320     0.200
     1.503    44.523     0.200
     1.524    43.023     0.200
     1.544    43.523     0.200
     1.593    45.422     0.200
     1.629    47.617     0.200
     1.873    52.719     0.200
     2.162    59.422     0.200
     2.469    68.117     0.200
     2.464    67.719     0.200
     2.632    71.117     0.200
     2.682    73.219     0.200
     2.790    74.922     0.200
     3.053    82.422     0.200
     3.048    80.320     0.200
     3.238    85.117     0.200
     3.380    86.617     0.200
     3.436    90.719     0.200
     3.550    93.117     0.200
     3.675    95.820     0.200
     4.030   104.320     0.200
     4.151   107.922     0.200
     4.547   115.617     0.200
     4.875   124.719     0.200
     5.266   132.617     0.200
     5.691   142.523     0.200
     6.480   161.117     0.200
     7.036   178.320     0.200
     0.510    21.352     0.200
     0.549    22.852     0.200
     0.766    25.352     0.200
     0.893    28.148     0.200
     0.956    31.449     0.200
     1.156    36.949     0.200
     1.405    40.449     0.200
     1.442    41.852     0.200
     1.617    44.148     0.200
     1.700    49.250     0.200
     1.796    49.051     0.200
     1.861    53.352     0.200
     1.883    53.648     0.200
     2.213    60.750     0.200
     2.539    69.551     0.200
     2.802    76.148     0.200
     2.819    75.648     0.200
     2.998    79.750     0.200
     3.157    83.449     0.200
     3.187    85.750     0.200
     3.298    88.449     0.200
     3.322    87.551     0.200
     3.442    90.949     0.200
     3.656    96.648     0.200
     3.789    99.852     0.200
     3.924   102.648     0.200
     4.302   112.449     0.200
     4.645   120.852     0.200
     4.861   126.852     0.200
     5.515   142.852     0.200
     6.266   157.949     0.200
     6.808   173.051     0.200
     7.382   182.551     0.200
     0.236    17.543     0.200
     0.312    16.941     0.200
     0.421    18.344     0.200
     0.858    29.344     0.200
     1.164    34.043     0.200
     1.404    41.844     0.200
     1.348    39.941     0.200
     1.535    43.941     0.200
     1.571    45.441     0.200
     1.695    48.242     0.200
     1.752    50.141     0.200
     1.797    49.641     0.200
     1.769    50.742     0.200
     1.799    52.742     0.200
     2.104    59.043     0.200
     2.106    58.941     0.200
     2.252    59.742     0.200
     2.254    63.242     0.200
     2.218    61.441     0.200
     2.287    64.441     0.200
     2.330    64.641     0.200
     2.834    75.344     0.200
     2.963    78.441     0.200
     5.955   150.844     0.200
     6.459   165.242     0.200
     7.019   176.844     0.200
     7.612   192.242     0.200
     1.219    36.242     0.200
     1.778    47.938     0.200
     1.803    50.039     0.200
     2.006    55.141     0.200
     2.199    60.141     0.200
     2.278    63.242     0.200
     2.239    61.539     0.200
     2.506    68.438     0.200
     2.629    72.438     0.200
     2.685    74.539     0.200
     2.752    73.844     0.200
     2.865    78.438     0.200
     3.099    82.438     0.200
     3.234    85.742     0.200
     3.356    90.039     0.200
     3.449    89.844     0.200
     3.578    93.539     0.200
     3.702    96.039     0.200
     3.955   103.242     0.200
     4.201   109.938     0.200
     4.628   118.641     0.200
     4.912   127.344     0.200
     5.071   132.844     0.200
     5.251   137.742     0.200
     5.331   135.641     0.200
     5.777   145.438     0.200
     5.790   149.844     0.200
     6.046   151.844     0.200
     6.569   166.641     0.200
     7.074   183.039     0.200
     0.256    18.475     0.200
     0.912    29.873     0.200
     1.285    38.975     0.200
     1.498    43.373     0.200
     1.727    48.674     0.200
     1.684    48.475     0.200
     1.695    48.273     0.200
     1.851    50.975     0.200
     2.045    58.273     0.200
     2.158    59.773     0.200
     2.146    59.975     0.200
     2.308    64.174     0.200
     2.319    61.074     0.200
     2.274    64.574     0.200
     2.450    67.873     0.200
     2.577    70.273     0.200
     2.765    72.674     0.200
     2.765    73.273     0.200
     2.803    74.773     0.200
     2.924    78.174     0.200
     3.048    81.475     0.200
     3.311    87.574     0.200
     3.549    93.574     0.200
     3.983   103.574     0.200
     4.258   112.475     0.200
     4.632   120.674     0.200
     4.717   122.674     0.200
     5.137   133.674     0.200
     6.419   164.574     0.200
     6.421   161.674     0.200
     6.786   175.975     0.200
     6.786   175.674     0.200
     6.870   173.674     0.200
     6.977   176.574     0.200
     6.999   174.273     0.200
     7.570   189.975     0.200
     7.602   188.975     0.200
     7.922   195.275     0.200
     7.984   195.572     0.200
     8.171   202.975     0.200
    12.365   306.174     0.200
     0.438    21.363     0.200
     0.581    23.465     0.200
     0.607    23.262     0.200
     0.933    29.262     0.200
     1.093    34.762     0.200
     1.490    43.664     0.200
     1.481    43.262     0.200
     1.509    43.465     0.200
     1.551    46.762     0.200
     1.617    45.863     0.200
     1.796    50.965     0.200
     1.875    52.664     0.200
     1.939    52.664     0.200
     1.966    56.965     0.200
     2.073    58.062     0.200
     2.065    57.762     0.200
     2.406    65.262     0.200
     2.731    71.863     0.200
     2.893    75.965     0.200
     3.074    79.863     0.200
     3.224    83.762     0.200
     3.346    86.762     0.200
     3.577    92.164     0.200
     3.680    96.363     0.200
     3.835    98.762     0.200
     0.532    18.633     0.200
     0.559    18.934     0.200
     0.875    28.336     0.200
     0.891    28.535     0.200
     0.982    29.934     0.200
     1.218    35.836     0.200
     1.483    42.035     0.200
     1.531    43.234     0.200
     1.668    46.934     0.200
     1.826    51.434     0.200
     2.206    61.035     0.200
     2.306    64.035     0.200
     2.956    80.234     0.200
     3.254    88.434     0.200
     3.324    89.734     0.200
     3.451    92.035     0.200
     3.967   107.336     0.200
     4.425   116.336     0.200
     0.247    18.215     0.200
     0.371    17.215     0.200
     0.409    18.414     0.200
     0.789    27.016     0.200
     1.114    33.215     0.200
     1.317    39.816     0.200
     1.429    41.914     0.200
     1.652    47.617     0.200
     1.628    46.117     0.200
     1.668    48.215     0.200
     1.724    48.016     0.200
     1.750    49.516     0.200
     1.843    52.914     0.200
     1.866    51.816     0.200
     1.911    53.016     0.200
     2.162    57.016     0.200
     2.182    61.414     0.200
     2.184    60.914     0.200
     2.202    61.617     0.200
     2.294    63.414     0.200
     2.317    66.715     0.200
     2.379    66.414     0.200
     2.427    67.316     0.200
     2.534    68.617     0.200
     2.530    69.016     0.200
     2.683    71.516     0.200
     2.811    76.414     0.200
     2.841    77.617     0.200
     2.881    76.117     0.200
     3.020    79.516     0.200
     3.143    82.414     0.200
     3.467    92.816     0.200
     3.637    95.516     0.200
     3.984   105.016     0.200
     4.060   104.414     0.200
     4.351   112.016     0.200
     4.534   119.816     0.200
     4.699   122.215     0.200
     4.706   122.617     0.200
     4.766   122.016     0.200
     5.209   131.715     0.200
     5.478   136.715     0.200
     5.549   146.414     0.200
     6.001   149.617     0.200
     6.901   175.414     0.200
     7.092   176.215     0.200
     7.671   192.914     0.200
     8.011   196.117     0.200
     1.100    33.475     0.200
     1.235    37.175     0.200
     1.251    38.075     0.200
     1.445    42.275     0.200
     1.546    44.675     0.200
     1.656    48.875     0.200
     1.685    47.175     0.200
     1.690    49.375     0.200
     1.746    51.075     0.200
     1.959    54.375     0.200
     1.993    58.175     0.200
     2.003    56.375     0.200
     2.529    66.275     0.200
     2.639    71.875     0.200
     2.936    79.875     0.200
     3.006    82.375     0.200
     3.133    85.475     0.200
     3.445    93.575     0.200
     4.107   110.575     0.200
     4.783   126.875     0.200
     6.040   155.775     0.200
     6.484   170.775     0.200
     0.257    17.523     0.200
     0.373    17.422     0.200
     0.804    27.727     0.200
     1.118    33.125     0.200
     1.382    41.125     0.200
     1.347    40.422     0.200
     1.582    45.125     0.200
     1.652    47.422     0.200
     1.627    47.227     0.200
     1.739    49.023     0.200
     1.742    49.227     0.200
     1.825    51.422     0.200
     1.810    51.727     0.200
     2.157    60.227     0.200
     2.200    61.727     0.200
     2.160    59.625     0.200
     2.248    62.328     0.200
     2.194    57.828     0.200
     2.332    65.125     0.200
     2.386    66.422     0.200
     2.529    70.023     0.200
     2.671    71.922     0.200
     2.820    77.727     0.200
     2.878    75.422     0.200
     3.011    78.828     0.200
     3.134    81.727     0.200
     3.384    88.422     0.200
     3.453    92.727     0.200
     3.631    95.328     0.200
     4.057   103.523     0.200
     4.343   111.922     0.200
     4.761   120.625     0.200
     5.206   131.023     0.200
     5.476   137.523     0.200
     0.186    12.797     0.200
     0.438    18.895     0.200
     0.633    21.598     0.200
     0.698    22.797     0.200
     1.046    31.297     0.200
     1.076    31.297     0.200
     1.146    35.098     0.200
     1.224    36.996     0.200
     1.334    40.195     0.200
     1.333    38.496     0.200
     1.416    41.996     0.200
     1.671    46.598     0.200
     1.780    51.695     0.200
     1.880    52.395     0.200
     1.908    50.895     0.200
     2.073    57.098     0.200
     2.119    58.895     0.200
     2.114    58.496     0.200
     2.163    59.496     0.200
     2.300    63.598     0.200
     2.584    71.496     0.200
     3.032    80.098     0.200
     3.153    83.996     0.200
     3.259    88.098     0.200
     3.385    88.395     0.200
     3.503    91.797     0.200
     3.628    94.695     0.200
     3.925   104.297     0.200
     4.564   116.797     0.200
     0.595    22.008     0.200
     0.715    22.906     0.200
     0.721    25.008     0.200
     0.709    25.008     0.200
     0.961    31.508     0.200
     1.037    31.805     0.200
     1.082    32.406     0.200
     1.045    33.305     0.200
     1.064    35.406     0.200
     1.310    39.906     0.200
     1.387    40.406     0.200
     1.567    44.805     0.200
     1.530    45.609     0.200
     1.676    46.109     0.200
     1.642    49.508     0.200
     1.760    50.109     0.200
     1.844    51.711     0.200
     2.265    62.211     0.200
     2.263    63.711     0.200
     2.489    64.609     0.200
     2.533    71.711     0.200
     2.902    77.711     0.200
     3.264    88.406     0.200
     3.316    88.109     0.200
     3.444    91.711     0.200
     3.963   104.508     0.200
     6.356   159.305     0.200
     6.779   177.008     0.200
     0.179    15.570     0.200
     0.255    16.570     0.200
     0.558    20.867     0.200
     1.006    32.266     0.200
     1.255    38.266     0.200
     1.292    37.766     0.200
     1.405    40.672     0.200
     1.415    42.766     0.200
     1.415    41.766     0.200
     1.563    44.867     0.200
     1.592    45.867     0.200
     1.613    46.672     0.200
     1.784    52.570     0.200
     1.811    50.969     0.200
     1.860    53.266     0.200
     1.945    53.469     0.200
     1.952    55.570     0.200
     1.961    55.867     0.200
     2.132    59.469     0.200
     2.159    60.367     0.200
     2.174    60.570     0.200
     2.347    65.969     0.200
     2.368    65.172     0.200
     2.401    66.766     0.200
     2.411    62.570     0.200
     2.489    68.172     0.200
     2.617    71.867     0.200
     2.723    73.266     0.200
     2.837    76.070     0.200
     2.962    78.469     0.200
     3.465    91.969     0.200
     4.172   108.969     0.200
     0.083    12.412     0.200
     0.355    16.711     0.200
     0.642    21.912     0.200
     1.094    33.812     0.200
     1.157    35.812     0.200
     1.289    37.412     0.200
     1.297    38.012     0.200
     1.358    38.312     0.200
     1.380    41.312     0.200
     1.494    42.211     0.200
     1.668    46.512     0.200
     1.733    51.312     0.200
     1.864    52.611     0.200
     1.841    52.312     0.200
     1.866    53.211     0.200
     1.889    54.211     0.200
     1.943    55.912     0.200
     2.031    55.512     0.200
     2.035    56.412     0.200
     2.043    57.512     0.200
     2.431    67.211     0.200
     2.485    68.512     0.200
     2.517    65.412     0.200
     2.686    74.912     0.200
     2.911    80.012     0.200
     5.803   146.412     0.200
     6.278   163.012     0.200
     0.229    15.342     0.200
     0.483    20.742     0.200
     0.714    25.041     0.200
     0.851    26.842     0.200
     0.980    30.842     0.200
     1.400    40.842     0.200
     1.401    40.041     0.200
     1.449    42.441     0.200
     1.559    44.541     0.200
     1.810    51.041     0.200
     1.858    52.742     0.200
     2.177    60.742     0.200
     2.455    67.242     0.200
     2.519    69.041     0.200
     2.999    79.143     0.200
     3.173    84.242     0.200
     3.172    82.041     0.200
     3.328    85.941     0.200
     3.450    89.742     0.200
     3.674    95.842     0.200
     3.788   100.041     0.200
     3.936   102.143     0.200
     4.347   110.242     0.200
     4.655   118.941     0.200
     5.059   129.242     0.200
     5.494   138.342     0.200
     0.079    12.375     0.200
     0.643    21.875     0.200
     1.153    35.273     0.200
     1.285    37.172     0.200
     1.294    37.977     0.200
     1.378    41.977     0.200
     1.485    42.773     0.200
     1.492    42.977     0.200
     1.670    47.477     0.200
     1.864    52.477     0.200
     1.866    54.070     0.200
     1.943    54.773     0.200
     2.032    56.477     0.200
     2.031    56.672     0.200
     2.040    57.875     0.200
     2.431    66.875     0.200
     2.443    67.273     0.200
     2.486    68.477     0.200
     2.519    66.672     0.200
     2.537    68.375     0.200
     2.687    73.672     0.200
     2.786    74.570     0.200
     2.912    78.172     0.200
     3.196    86.875     0.200
     3.420    92.570     0.200
     3.864   100.172     0.200
     4.121   109.773     0.200
     4.255   112.672     0.200
     5.282   136.570     0.200
     5.804   146.570     0.200
     6.279   162.375     0.200
     6.626   174.273     0.200
     6.832   173.172     0.200
     6.861   171.477     0.200
     7.465   185.273     0.200
     7.636   190.477     0.200
     0.375    14.500     0.200
     0.406    15.805     0.200
     0.649    23.305     0.200
     0.773    25.500     0.200
     0.950    28.805     0.200
     1.058    33.000     0.200
     1.352    38.203     0.200
     1.405    39.000     0.200
     1.425    42.000     0.200
     1.430    42.602     0.200
     1.503    44.305     0.200
     1.541    43.398     0.200
     1.669    46.898     0.200
     1.733    48.398     0.200
     1.832    51.602     0.200
     1.891    53.500     0.200
     1.918    55.703     0.200
     1.973    55.602     0.200
     2.112    60.102     0.200
     2.244    58.398     0.200
     2.272    63.102     0.200
     2.786    75.000     0.200
     2.877    79.398     0.200
     3.144    84.102     0.200
     3.363    88.898     0.200
     3.654    97.602     0.200
     3.873   103.305     0.200
     4.321   112.898     0.200
     0.139    14.617     0.200
     0.379    19.418     0.200
     0.726    25.719     0.200
     0.738    25.016     0.200
     0.893    28.316     0.200
     0.939    29.617     0.200
     1.274    38.316     0.200
     1.315    37.719     0.200
     1.334    39.918     0.200
     1.410    41.719     0.200
     1.424    41.516     0.200
     1.566    46.219     0.200
     1.676    49.117     0.200
     2.223    60.117     0.200
     4.090   109.117     0.200
     4.401   113.316     0.200
     4.401   113.719     0.200
     7.311   188.117     0.200
     0.349    17.023     0.200
     0.311    18.422     0.200
     0.331    17.422     0.200
     0.708    25.320     0.200
     0.793    27.621     0.200
     1.090    32.723     0.200
     1.323    40.621     0.200
     1.356    40.023     0.200
     2.646    70.820     0.200
     4.513   117.422     0.200
     4.635   122.422     0.200
     6.904   177.422     0.200
     0.307    18.172     0.200
     0.343    17.070     0.200
     0.345    17.469     0.200
     0.721    25.867     0.200
     0.785    27.070     0.200
     1.085    32.469     0.200
     1.345    40.266     0.200
     1.337    41.266     0.200
     1.353    40.867     0.200
     2.637    71.266     0.200
     4.504   117.969     0.200
     4.639   123.172     0.200
     6.910   176.469     0.200
     6.910   177.969     0.200
     0.398    15.424     0.200
     0.595    19.523     0.200
     0.689    24.225     0.200
     0.945    28.623     0.200
     1.247    38.023     0.200
     1.292    37.225     0.200
     2.547    67.924     0.200
     4.411   116.623     0.200
     4.459   116.424     0.200
     0.134    13.680     0.200
     0.356    17.980     0.200
     0.614    21.480     0.200
     0.739    24.379     0.200
     0.985    30.578     0.200
     1.148    35.180     0.200
     1.224    38.180     0.200
     1.262    37.480     0.200
     1.279    37.180     0.200
     1.489    44.680     0.200
     2.209    60.277     0.200
     4.071   109.480     0.200
     4.233   111.379     0.200
     0.284    17.539     0.200
     0.370    17.141     0.200
     0.811    28.141     0.200
     1.113    33.641     0.200
     1.337    40.141     0.200
     1.367    40.141     0.200
     1.855    52.141     0.200
     2.662    71.242     0.200
     4.529   120.441     0.200
     4.663   123.641     0.200
     6.883   174.641     0.200
     8.298   215.641     0.200
     0.351    17.826     0.200
     0.308    17.826     0.200
     0.710    25.826     0.200
     0.795    27.726     0.200
     1.092    32.926     0.200
     1.324    39.926     0.200
     1.357    40.426     0.200
     2.648    71.226     0.200
     4.515   119.226     0.200
     4.638   119.726     0.200
     6.901   178.426     0.200
     6.901   178.226     0.200
    10.508   265.726     0.200
    16.651   412.226     0.200
     0.285    18.164     0.200
     0.396    17.965     0.200
     0.705    25.367     0.200
     1.135    33.766     0.200
     1.402    40.566     0.200
     2.694    72.164     0.200
     4.561   119.766     0.200
     4.667   123.965     0.200
     6.823   176.367     0.200
     8.579   219.566     0.200
    17.954   441.367     0.200
     0.331    17.820     0.200
     0.547    19.922     0.200
     0.565    20.520     0.200
     0.703    23.121     0.200
     1.049    31.820     0.200
     1.215    36.820     0.200
     1.405    39.020     0.200
     1.472    42.121     0.200
     1.582    44.723     0.200
     1.627    47.922     0.200
     1.896    52.320     0.200
     3.758   100.320     0.200
     4.421   112.922     0.200
    10.707   268.922     0.200
     0.151    14.797     0.200
     0.375    19.098     0.200
     0.747    25.297     0.200
     0.727    25.496     0.200
     0.929    29.598     0.200
     1.310    38.297     0.200
     1.345    40.098     0.200
     1.407    41.098     0.200
     1.418    41.898     0.200
     1.429    42.098     0.200
     1.578    46.797     0.200
     1.685    49.246     0.200
     2.216    60.098     0.200
     4.083   108.098     0.200
     7.315   186.098     0.200
     1.180    35.211     0.200
     1.182    35.609     0.200
     3.048    83.910     0.200
     4.913   132.512     0.200
    14.136   353.711     0.200
     0.234    16.570     0.200
     0.429    18.672     0.200
     0.660    24.867     0.200
     0.879    29.766     0.200
     1.159    34.570     0.200
     1.444    41.672     0.200
     1.451    42.367     0.200
     1.501    43.867     0.200
     2.735    72.570     0.200
     4.602   121.969     0.200
     4.660   120.570     0.200
     0.174    15.067     0.200
     0.481    21.267     0.200
     0.539    21.767     0.200
     0.608    22.767     0.200
     0.859    27.267     0.200
     0.881    28.167     0.200
     1.076    33.467     0.200
     1.381    40.867     0.200
     1.473    41.967     0.200
     1.510    44.567     0.200
     1.519    45.167     0.200
     1.776    51.467     0.200
     2.376    65.267     0.200
     4.243   112.567     0.200
     7.151   182.567     0.200
     7.151   182.980     0.200
     0.286    17.594     0.200
     0.363    17.195     0.200
     0.732    26.797     0.200
     0.804    28.094     0.200
     1.106    33.195     0.200
     1.343    39.500     0.200
     1.359    40.297     0.200
     2.654    70.594     0.200
     4.660   118.797     0.200
     6.890   177.797     0.200
     1.119    33.512     0.200
     1.246    36.012     0.200
     2.903    77.211     0.200
     4.524   119.512     0.200
     4.758   126.711     0.200
     6.771   176.711     0.200
     0.148    16.586     0.200
     0.543    22.680     0.200
     0.577    23.086     0.200
     0.774    26.586     0.200
     0.987    32.586     0.200
     1.096    33.383     0.200
     1.120    34.984     0.200
     1.223    37.781     0.200
     1.310    40.883     0.200
     1.347    40.086     0.200
     1.449    41.883     0.200
     1.678    48.086     0.200
     1.768    50.680     0.200
     1.911    55.180     0.200
     3.081    80.586     0.200
     4.751   121.383     0.200
     4.942   129.180     0.200
     6.550   170.383     0.200
     0.230    16.094     0.200
     0.267    16.594     0.200
     0.406    18.195     0.200
     0.722    25.996     0.200
     0.849    29.195     0.200
     1.147    35.094     0.200
     1.320    39.594     0.200
     1.377    41.797     0.200
     1.405    41.496     0.200
     1.874    54.395     0.200
     2.700    71.996     0.200
     4.567   118.695     0.200
     4.685   122.395     0.200
     5.439   139.195     0.200
     6.846   175.695     0.200
     6.841   172.895     0.200
     8.272   213.695     0.200
    10.074   252.695     0.200
    17.970   441.395     0.200
     0.162    15.922     0.200
     0.305    19.219     0.200
     0.436    19.117     0.200
     0.664    24.617     0.200
     0.886    29.617     0.200
     1.167    34.719     0.200
     1.252    38.617     0.200
     1.457    42.523     0.200
     1.443    41.922     0.200
     1.848    50.422     0.200
     2.742    73.320     0.200
    10.005   253.820     0.200
     0.278    17.258     0.200
     0.318    16.855     0.200
     0.348    16.555     0.200
     0.778    27.258     0.200
     1.093    32.656     0.200
     1.321    38.457     0.200
     1.390    41.855     0.200
     1.872    55.055     0.200
     2.622    70.055     0.200
     0.253    15.492     0.200
     0.578    21.586     0.200
     0.565    22.188     0.200
     0.938    28.688     0.200
     0.927    28.586     0.200
     1.060    32.586     0.200
     1.854    52.438     0.200
     2.375    62.188     0.200
     4.241   113.289     0.200
     4.597   118.688     0.200
     0.220    16.367     0.200
     0.387    18.164     0.200
     0.692    25.664     0.200
     0.834    28.766     0.200
     1.124    33.469     0.200
     1.295    38.969     0.200
     1.399    41.266     0.200
     2.688    71.070     0.200
     4.555   121.867     0.200
     4.652   120.867     0.200
     6.866   175.664     0.200
     6.866   175.867     0.200
     9.527   232.469     0.200
    10.053   252.766     0.200
    12.962   323.867     0.200
     0.272    16.711     0.200
     0.342    17.211     0.200
     0.311    18.211     0.200
     0.715    25.911     0.200
     0.785    27.711     0.200
     1.084    32.411     0.200
     1.348    40.611     0.200
     1.346    40.111     0.200
     2.638    70.111     0.200
     4.504   120.611     0.200
     6.910   180.611     0.200
     6.910   181.111     0.200
     6.910   179.682     0.200
     0.160    18.223     0.200
     0.401    22.121     0.200
     0.661    25.723     0.200
     0.756    28.023     0.200
     0.943    31.621     0.200
     1.366    40.922     0.200
     1.332    39.723     0.200
     1.437    42.621     0.200
     1.458    43.324     0.200
     2.236    61.121     0.200
     4.103   110.223     0.200
     4.435   114.223     0.200
     7.291   185.742     0.200
     0.231    16.268     0.200
     0.285    17.768     0.200
     0.391    17.969     0.200
     1.131    33.469     0.200
     1.312    39.568     0.200
     1.395    41.469     0.200
     4.554   122.068     0.200
     4.554   123.568     0.200
     4.667   119.568     0.200
     6.862   175.568     0.200
     6.862   177.369     0.200
     0.392    16.750     0.200
     0.439    18.453     0.200
     0.835    26.453     0.200
     0.818    26.055     0.200
     0.836    26.352     0.200
     7.348   192.555     0.200
     7.348   192.852     0.200
    10.577   268.852     0.200
     0.408    17.465     0.200
     0.418    18.066     0.200
     0.718    23.965     0.200
     0.784    25.266     0.200
     0.814    25.965     0.200
     0.865    26.766     0.200
     1.161    33.363     0.200
     1.256    35.363     0.200
     1.483    43.164     0.200
     1.567    44.766     0.200
     3.977   108.965     0.200
     7.382   187.164     0.200
     7.382   186.965     0.200
     0.195    15.887     0.200
     0.319    16.387     0.200
     0.427    17.684     0.200
     0.824    28.184     0.200
     0.848    28.484     0.200
     1.172    34.285     0.200
     1.373    39.586     0.200
     1.951    55.637     0.200
     2.684    71.285     0.200
     4.752   123.285     0.200
     6.842   175.484     0.200
     6.842   175.285     0.200
     9.463   233.750     0.200
     0.160    15.895     0.200
     0.311    18.297     0.200
     0.434    19.195     0.200
     0.659    24.496     0.200
     0.885    28.695     0.200
     1.164    34.496     0.200
     1.247    38.496     0.200
     1.457    42.598     0.200
     2.741    73.098     0.200
     4.607   121.996     0.200
     4.663   123.496     0.200
     6.822   176.797     0.200
     9.498   231.848     0.200
     0.203    15.766     0.200
     0.439    19.066     0.200
     0.716    24.867     0.200
     1.178    34.266     0.200
     1.302    39.266     0.200
     1.441    42.066     0.200
     1.888    54.168     0.200
     2.735    74.367     0.200
     4.602   121.367     0.200
     4.704   123.367     0.200
     6.813   172.969     0.200
     6.813   172.867     0.200
     6.858   175.867     0.200
     8.246   211.867     0.200
     8.616   222.867     0.200
     9.472   232.016     0.200
    12.336   305.867     0.200
    21.349   527.766     0.200
    21.435   531.266     0.200
     0.245    18.391     0.200
     0.318    17.991     0.200
     0.583    23.691     0.200
     0.769    27.991     0.200
     1.026    31.991     0.200
     1.216    38.591     0.200
     1.366    40.791     0.200
     1.456    42.291     0.200
     1.447    42.691     0.200
     1.704    50.291     0.200
     2.628    70.291     0.200
     4.492   119.491     0.200
     4.519   117.491     0.200
     6.957   178.591     0.200
     6.957   178.491     0.200
    17.819   437.491     0.200
    20.763   512.291     0.200
    21.258   523.891     0.200
     0.190    15.777     0.200
     0.283    17.180     0.200
     0.427    18.578     0.200
     1.163    34.578     0.200
     1.282    38.980     0.200
     1.438    41.879     0.200
     1.863    53.379     0.200
     2.729    73.379     0.200
     6.826   176.180     0.200
     0.465    18.430     0.200
     0.440    17.531     0.200
     1.161    34.430     0.200
     1.283    37.430     0.200
     2.609    69.133     0.200
     4.473   118.133     0.200
     4.798   124.133     0.200
     0.267    16.777     0.200
     0.344    17.176     0.200
     0.314    17.875     0.200
     1.085    33.078     0.200
     1.350    39.875     0.200
     2.640    70.477     0.200
     4.507   118.777     0.200
     4.633   121.977     0.200
     6.909   176.875     0.200
     6.909   176.977     0.200
    13.000   323.977     0.200
    21.298   521.676     0.200
    21.807   539.977     0.200
     0.272    16.562     0.200
     0.368    17.062     0.200
     0.807    27.859     0.200
     1.112    33.258     0.200
     1.349    41.562     0.200
     1.359    39.859     0.200
     2.656    71.461     0.200
     4.523   120.461     0.200
     4.668   122.461     0.200
     6.826   176.461     0.200
     6.886   176.461     0.200
     6.886   177.461     0.200
     8.310   215.461     0.200
     9.530   233.211     0.200
    12.259   306.359     0.200
    18.661   459.359     0.200
     0.642    22.162     0.200
     2.858    77.162     0.200
     4.724   127.162     0.200
     0.271    16.792     0.200
     0.392    19.592     0.200
     0.646    24.292     0.200
     1.027    31.292     0.200
     1.332    38.792     0.200
     1.747    50.941     0.200
     2.607    70.592     0.200
     4.473   119.592     0.200
     4.555   119.191     0.200
     6.959   178.691     0.200
     6.959   180.592     0.200
    21.813   538.592     0.200
     0.126    15.492     0.200
     0.274    16.992     0.200
     0.554    20.289     0.200
     0.697    25.094     0.200
     1.003    31.992     0.200
     1.237    37.195     0.200
     1.284    37.789     0.200
     1.390    40.289     0.200
     1.407    40.992     0.200
     1.933    55.945     0.200
     2.858    75.195     0.200
     4.761   125.492     0.200
     9.383   228.539     0.200
     0.256    16.682     0.200
     0.367    17.182     0.200
     0.292    18.481     0.200
     0.719    25.981     0.200
     0.810    27.682     0.200
     1.109    33.081     0.200
     1.368    40.581     0.200
     2.661    70.781     0.200
     4.528   119.281     0.200
     4.655   119.281     0.200
     6.886   175.682     0.200
     6.886   175.281     0.200
    10.518   263.781     0.200
    12.998   322.481     0.200
    21.791   536.281     0.200
     0.271    16.492     0.200
     0.281    17.297     0.200
     0.282    17.516     0.200
     0.366    17.297     0.200
     0.806    27.391     0.200
     1.110    33.297     0.200
     1.359    40.094     0.200
     2.655    70.594     0.200
     4.522   117.594     0.200
     4.665   122.594     0.200
     6.823   173.594     0.200
     6.888   177.094     0.200
     6.888   177.594     0.200
     9.533   232.547     0.200
    10.106   254.594     0.200
    10.535   269.094     0.200
    13.015   325.695     0.200
    16.662   414.594     0.200
    21.379   528.992     0.200
     0.221    16.094     0.200
     0.284    17.492     0.200
     0.399    17.891     0.200
     1.305    40.094     0.200
     1.406    40.891     0.200
     2.697    71.891     0.200
     4.564   119.188     0.200
     4.670   121.891     0.200
    14.477   362.391     0.200
    20.729   509.789     0.200
    21.397   530.094     0.200
     0.268    16.711     0.200
     0.304    17.711     0.200
     0.350    17.113     0.200
     0.718    25.812     0.200
     0.793    27.711     0.200
     1.092    32.312     0.200
     1.333    39.113     0.200
     1.353    40.113     0.200
     2.645    71.812     0.200
     4.512   117.312     0.200
     4.642   122.113     0.200
     0.156    15.717     0.200
     0.421    19.017     0.200
     0.633    24.816     0.200
     0.872    29.917     0.200
     1.145    33.917     0.200
     1.228    38.616     0.200
     1.451    41.917     0.200
     1.815    49.417     0.200
     2.730    71.517     0.200
     4.596   119.017     0.200
     4.636   122.917     0.200
     6.839   178.017     0.200
     6.839   178.417     0.200
    12.892   320.116     0.200
     0.263    17.043     0.200
     0.219    15.941     0.200
     0.419    18.340     0.200
     0.719    25.141     0.200
     0.862    29.242     0.200
     1.159    34.242     0.200
     1.312    40.043     0.200
     1.878    54.441     0.200
     2.714    70.742     0.200
     0.266    17.344     0.200
     0.298    18.547     0.200
     0.716    26.148     0.200
     0.973    30.547     0.200
     1.237    38.047     0.200
     1.317    38.344     0.200
     1.411    41.250     0.200
     1.671    49.148     0.200
     7.011   183.047     0.200
     7.011   182.750     0.200
     0.383    17.219     0.200
     1.118    33.422     0.200
     1.278    38.719     0.200
     1.403    41.219     0.200
     2.688    70.922     0.200
     4.554   118.422     0.200
     4.637   119.922     0.200
     9.537   233.922     0.200
    10.037   256.117     0.200
    12.946   323.219     0.200
    21.287   522.320     0.200
     0.301    18.410     0.200
     0.283    16.711     0.200
     0.343    17.309     0.200
     0.731    26.410     0.200
     1.087    32.809     0.200
     1.340    40.512     0.200
     1.348    41.410     0.200
     2.634    72.012     0.200
     4.501   116.910     0.200
     4.645   123.410     0.200
     6.910   180.109     0.200
     6.910   179.625     0.200
     0.304    20.336     0.200
     0.423    18.953     0.200
     0.671    24.758     0.200
     1.156    34.555     0.200
     1.263    38.055     0.200
     2.728    73.055     0.200
     4.594   119.656     0.200
     4.664   122.156     0.200
     6.832   177.555     0.200
     6.832   177.156     0.200
     8.329   215.953     0.200
    10.018   255.453     0.200
    12.924   324.258     0.200
     0.200    15.766     0.200
     0.281    17.465     0.200
     0.419    18.766     0.200
     0.866    28.965     0.200
     1.157    33.965     0.200
     1.863    53.766     0.200
     2.720    73.367     0.200
     4.586   119.566     0.200
     0.224    15.953     0.200
     0.281    17.953     0.200
     0.400    18.055     0.200
     0.709    24.656     0.200
     0.844    28.953     0.200
     1.139    33.250     0.200
     1.308    39.156     0.200
     1.404    40.250     0.200
     2.697    72.453     0.200
     0.257    16.344     0.200
     0.330    18.145     0.200
     0.386    19.246     0.200
     0.387    19.945     0.200
     0.703    25.445     0.200
     0.998    30.844     0.200
     1.275    38.145     0.200
     1.340    41.145     0.200
     2.558    70.344     0.200
     4.425   115.445     0.200
     4.560   121.445     0.200
     6.995   182.445     0.200
     6.995   179.195     0.200
     0.258    16.090     0.200
     0.366    16.688     0.200
     0.293    17.539     0.200
     0.721    26.090     0.200
     0.808    27.988     0.200
     1.108    33.188     0.200
     1.331    40.090     0.200
     1.366    39.188     0.200
     1.848    49.938     0.200
     2.660    71.988     0.200
     6.887   177.887     0.200
     6.887   177.113     0.200
    16.649   412.688     0.200
    18.643   457.289     0.200
     0.312    17.512     0.200
     0.285    16.512     0.200
     0.531    20.109     0.200
     0.683    26.371     0.200
     0.917    30.312     0.200
     0.934    30.312     0.200
     0.972    32.512     0.200
     1.092    32.812     0.200
     1.193    35.410     0.200
     1.292    39.812     0.200
     1.341    42.609     0.200
     1.384    40.109     0.200
     2.761    74.410     0.200
     0.177    15.762     0.200
     0.441    18.965     0.200
     1.176    34.562     0.200
     2.743    72.363     0.200
     6.812   175.863     0.200
     0.188    15.656     0.200
     0.189    16.383     0.200
     0.312    16.156     0.200
     0.437    17.852     0.200
     0.822    27.453     0.200
     0.859    28.555     0.200
     1.181    35.453     0.200
     1.384    39.453     0.200
     1.956    56.555     0.200
     2.695    71.953     0.200
     4.562   117.758     0.200
     4.758   125.156     0.200
     6.831   174.156     0.200
     8.477   218.852     0.200
    13.066   327.352     0.200
    16.686   412.852     0.200
     0.343    16.582     0.200
     0.561    21.684     0.200
     0.509    19.094     0.200
     0.682    23.484     0.200
     0.944    29.684     0.200
     0.994    30.484     0.200
     1.452    40.285     0.200
     1.926    55.082     0.200
     2.322    62.582     0.200
     4.644   118.684     0.200
     7.177   185.285     0.200
     8.607   219.383     0.200
    10.476   267.484     0.200
    13.399   334.484     0.200
    22.207   548.684     0.200
     0.128    15.594     0.200
     0.273    17.375     0.200
     0.554    21.094     0.200
     1.003    31.994     0.200
     1.238    37.594     0.200
     1.391    40.895     0.200
     1.407    41.094     0.200
     1.935    56.395     0.200
     2.858    75.895     0.200
     0.235    16.145     0.200
     0.378    17.746     0.200
     0.297    18.016     0.200
     0.703    25.547     0.200
     1.118    33.145     0.200
     1.309    40.047     0.200
     1.386    40.746     0.200
     2.677    71.746     0.200
     4.544   117.246     0.200
     0.290    17.695     0.200
     0.390    18.227     0.200
     0.835    28.328     0.200
     1.129    33.422     0.200
     2.688    72.625     0.200
     4.555   117.625     0.200
     4.663   120.016     0.200
     4.663   123.625     0.200
     6.862   178.828     0.200
     6.862   177.727     0.200
     8.358   214.125     0.200
     9.520   232.578     0.200
    14.482   362.727     0.200
     0.307    16.883     0.200
     0.356    17.281     0.200
     0.769    26.582     0.200
     0.787    27.383     0.200
     1.101    32.781     0.200
     1.332    39.684     0.200
     1.383    41.883     0.200
     1.399    41.984     0.200
     1.873    53.781     0.200
     2.633    70.781     0.200
     4.500   117.883     0.200
     6.903   179.383     0.200
     0.291    17.872     0.200
     0.291    17.672     0.200
     0.428    18.872     0.200
     0.683    24.872     0.200
     1.163    33.972     0.200
     1.858    53.322     0.200
     2.731    73.672     0.200
     4.598   122.172     0.200
     6.825   174.672     0.200
     0.139    14.711     0.200
     0.461    20.414     0.200
     0.572    23.211     0.200
     0.762    25.914     0.200
     0.883    28.812     0.200
     1.142    34.211     0.200
     1.717    49.711     0.200
     2.425    65.812     0.200
     4.291   112.711     0.200
     7.122   182.914     0.200
     0.190    15.043     0.200
     0.433    18.141     0.200
     1.170    34.441     0.200
     1.871    51.793     0.200
     9.483   232.492     0.200
     0.189    14.469     0.200
     0.451    19.469     0.200
     0.640    22.070     0.200
     0.813    26.469     0.200
     0.929    27.770     0.200
     0.971    29.871     0.200
     1.377    38.672     0.200
     1.407    41.570     0.200
     2.275    61.770     0.200
     4.141   109.070     0.200
     7.245   185.672     0.200
     0.345    17.164     0.200
     0.266    16.664     0.200
     0.313    18.461     0.200
     0.314    17.742     0.200
     0.710    25.859     0.200
     0.789    27.164     0.200
     1.086    32.562     0.200
     2.642    72.859     0.200
     4.509   119.461     0.200
     4.634   121.859     0.200
     6.907   181.359     0.200
     6.907   179.852     0.200
    10.088   254.758     0.200
     0.360    16.203     0.200
     0.509    20.500     0.200
     0.572    21.602     0.200
     0.956    29.102     0.200
     1.457    40.102     0.200
     1.942    54.148     0.200
     7.174   184.703     0.200
     0.305    17.646     0.200
     0.793    27.946     0.200
     1.093    32.946     0.200
     2.645    72.846     0.200
     4.512   119.246     0.200
     4.642   122.846     0.200
     6.902   177.296     0.200
     6.902   179.046     0.200
     0.160    15.779     0.200
     0.320    18.760     0.200
     0.428    19.080     0.200
     0.652    24.980     0.200
     0.879    30.080     0.200
     1.157    34.980     0.200
     1.242    39.180     0.200
     1.453    42.779     0.200
     1.833    53.230     0.200
     2.736    73.580     0.200
     4.602   122.680     0.200
     4.654   122.680     0.200
     6.829   176.480     0.200
    21.290   524.879     0.200
     0.221    16.062     0.200
     0.255    17.164     0.200
     0.425    18.562     0.200
     0.726    25.363     0.200
     0.868    29.262     0.200
     1.166    34.262     0.200
     1.318    40.262     0.200
     1.887    55.938     0.200
     2.718    74.062     0.200
     0.202    15.438     0.200
     0.198    15.938     0.200
     0.554    20.738     0.200
     0.768    26.637     0.200
     0.995    32.137     0.200
     1.295    37.438     0.200
     1.985    55.938     0.200
     2.842    77.238     0.200
     4.709   124.539     0.200
     4.808   126.539     0.200
     6.699   175.238     0.200
    12.933   322.938     0.200
     0.091    12.007     0.200
     0.365    17.007     0.200
     0.649    21.707     0.200
     0.657    21.606     0.200
     0.978    29.906     0.200
     1.299    36.906     0.200
     1.554    44.707     0.200
     2.224    62.307     0.200
     4.088   110.406     0.200
     0.453    18.707     0.200
     0.462    19.207     0.200
     0.715    25.105     0.200
     0.831    26.406     0.200
     0.938    28.809     0.200
     0.947    29.809     0.200
     1.161    36.605     0.200
     1.265    37.406     0.200
     1.364    39.707     0.200
     1.432    43.508     0.200
     1.526    43.207     0.200
     1.802    50.707     0.200
     3.198    87.508     0.200
     5.047   133.309     0.200
    11.997   304.809     0.200
     1.138    36.136     0.200
     1.823    54.036     0.200
     4.591   122.336     0.200
     6.452   169.236     0.200
    11.672   301.006     0.200
    11.915   303.936     0.200
    19.279   477.336     0.200
     0.251    15.086     0.200
     0.447    19.484     0.200
     0.692    23.180     0.200
     0.823    26.781     0.200
     0.930    28.883     0.200
     0.994    29.484     0.200
     1.357    38.383     0.200
     1.504    43.383     0.200
     2.244    61.383     0.200
     2.244    61.484     0.200
     0.222    15.984     0.200
     0.284    18.285     0.200
     0.399    18.184     0.200
     0.844    28.887     0.200
     1.139    33.887     0.200
     1.305    40.387     0.200
     1.858    49.934     0.200
     1.858    52.086     0.200
     2.697    73.484     0.200
     4.670   122.285     0.200
     0.122    11.438     0.200
     0.513    19.141     0.200
     0.559    19.734     0.200
     0.677    22.438     0.200
     1.034    32.438     0.200
     1.127    34.336     0.200
     1.175    34.641     0.200
     1.281    37.438     0.200
     1.361    38.039     0.200
     1.870    53.938     0.200
     2.985    78.641     0.200
     2.985    80.539     0.200
     4.848   129.438     0.200
     6.631   171.641     0.200
     0.154    14.992     0.200
     0.244    16.492     0.200
     0.367    17.094     0.200
     0.303    18.094     0.200
     0.704    25.195     0.200
     0.812    27.992     0.200
     1.107    32.695     0.200
     1.153    34.695     0.200
     1.313    39.992     0.200
     1.375    39.891     0.200
     1.837    51.492     0.200
     2.665    71.492     0.200
     3.157    82.594     0.200
     4.532   119.992     0.200
     4.532   119.492     0.200
     4.646   119.992     0.200
     5.947   151.992     0.200
     6.885   177.094     0.200
     6.885   179.492     0.200
    12.983   323.289     0.200
    16.635   412.891     0.200
     0.330    17.957     0.200
     0.703    26.059     0.200
     0.998    31.059     0.200
     1.275    37.859     0.200
     1.763    51.031     0.200
     2.558    70.258     0.200
     4.424   117.859     0.200
     0.195    15.836     0.200
     0.283    17.438     0.200
     0.283    18.438     0.200
     0.423    18.734     0.200
     0.694    25.438     0.200
     0.870    29.633     0.200
     1.160    34.039     0.200
     1.286    39.133     0.200
     1.863    51.789     0.200
     2.724    73.039     0.200
     4.591   123.539     0.200
     4.679   124.133     0.200
     6.833   176.039     0.200
     8.351   214.539     0.200
     0.411    17.988     0.200
     0.858    28.887     0.200
     1.147    33.887     0.200
     1.423    40.789     0.200
     2.712    72.887     0.200
     3.206    82.590     0.200
     4.579   122.387     0.200
     4.668   120.488     0.200
     6.822   173.887     0.200
     6.842   176.289     0.200
    10.041   253.590     0.200
    12.947   324.289     0.200
    16.591   410.988     0.200
    18.625   456.789     0.200
    21.315   525.887     0.200
     0.349    16.434     0.200
     0.536    20.434     0.200
     0.879    27.934     0.200
     0.951    30.135     0.200
     0.998    31.635     0.200
     1.260    38.135     0.200
     1.264    37.635     0.200
     1.517    42.734     0.200
     1.885    53.209     0.200
     3.170    86.135     0.200
     5.027   134.135     0.200
     0.680    23.938     0.200
     1.484    44.188     0.200
     1.535    46.617     0.200
     0.286    17.145     0.200
     0.274    16.246     0.200
     0.360    17.047     0.200
     0.800    27.844     0.200
     1.104    33.047     0.200
     1.165    35.047     0.200
     1.347    40.445     0.200
     1.354    39.645     0.200
     2.650    71.246     0.200
     4.517   118.945     0.200
     4.517   119.047     0.200
     4.659   120.344     0.200
     0.154    15.809     0.200
     0.433    18.508     0.200
     0.648    24.809     0.200
     1.161    34.607     0.200
     1.834    51.508     0.200
     2.741    73.508     0.200
     3.241    84.607     0.200
     4.607   122.408     0.200
     4.654   121.309     0.200
     6.825   173.908     0.200
     9.992   253.309     0.200
    12.552   318.908     0.200
    12.552   318.908     0.200
    12.898   322.008     0.200
    21.290   523.809     0.200
     0.510    18.391     0.200
     0.648    21.891     0.200
     2.951    81.691     0.200
     3.476    90.289     0.200
     4.812   127.992     0.200
     9.435   233.906     0.200
     0.271    16.830     0.200
     0.303    17.531     0.200
     0.350    17.330     0.200
     0.722    25.730     0.200
     0.792    27.230     0.200
     1.092    32.730     0.200
     1.350    40.230     0.200
     1.336    41.230     0.200
     1.356    40.730     0.200
     2.643    72.131     0.200
     3.133    81.430     0.200
     4.510   119.631     0.200
     6.903   180.230     0.200
     0.687    24.195     0.200
     2.288    64.695     0.200
     2.822    75.495     0.200
     4.150   113.795     0.200
     4.277   114.295     0.200
     7.300   187.795     0.200
    13.077   330.995     0.200
     4.915   133.820     0.200
     6.580   173.117     0.200
     3.068    87.574     0.200
     4.932   132.672     0.200
     9.737   249.273     0.200
    12.624   321.473     0.200
    14.108   359.773     0.200
    16.222   410.172     0.200
    18.538   463.672     0.200
    21.326   528.773     0.200
     1.917    56.869     0.200
     3.020    85.109     0.200
     3.531    94.510     0.200
     4.757   130.080     0.200
     6.587   170.809     0.200
     0.303    16.344     0.200
     0.310    16.242     0.200
     0.500    18.941     0.200
     0.906    29.344     0.200
     0.948    30.242     0.200
     1.071    32.543     0.200
     1.224    35.543     0.200
     1.294    40.145     0.200
     1.538    45.941     0.200
     2.375    64.543     0.200
     2.659    71.645     0.200
     2.701    75.043     0.200
     2.736    74.543     0.200
     3.292    83.645     0.200
     4.587   121.242     0.200
     0.128    15.693     0.200
     0.546    20.992     0.200
     1.396    40.492     0.200
     1.415    40.992     0.200
     2.849    76.992     0.200
     3.340    85.793     0.200
     4.716   125.293     0.200
     0.270    16.738     0.200
     0.352    17.336     0.200
     0.794    27.836     0.200
     1.094    32.938     0.200
     1.352    39.836     0.200
     2.267    62.137     0.200
     2.267    62.438     0.200
     2.569    71.137     0.200
     2.617    71.137     0.200
     2.617    71.438     0.200
     2.645    71.137     0.200
     2.645    71.238     0.200
     4.512   119.035     0.200
     4.512   119.836     0.200
     4.646   121.938     0.200
     4.646   123.238     0.200
     6.901   176.637     0.200
     0.240    18.404     0.200
     0.280    17.805     0.200
     0.325    18.104     0.200
     0.386    21.104     0.200
     0.451    22.844     0.200
     0.566    23.404     0.200
     0.774    27.805     0.200
     1.026    31.805     0.200
     1.024    32.104     0.200
     1.196    39.305     0.200
     1.199    38.404     0.200
     1.375    40.404     0.200
     1.441    42.604     0.200
     1.556    45.004     0.200
     1.692    49.180     0.200
     2.159    61.604     0.200
     2.260    62.004     0.200
     2.260    62.203     0.200
     2.556    69.004     0.200
     2.556    69.604     0.200
     2.602    72.004     0.200
     2.602    72.805     0.200
     2.633    72.004     0.200
     2.633    72.504     0.200
     3.152    83.004     0.200
     3.152    83.703     0.200
     4.497   120.004     0.200
     4.497   120.404     0.200
     4.509   117.104     0.200
     6.958   178.203     0.200
     8.422   214.404     0.200
     9.967   251.805     0.200
    10.820   274.004     0.200
    12.887   321.305     0.200
     0.188    16.158     0.200
     0.389    17.958     0.200
     1.117    33.358     0.200
     2.621    70.558     0.200
     2.669    72.658     0.200
     2.698    71.858     0.200
     3.200    83.358     0.200
     4.564   120.658     0.200
     4.622   123.058     0.200
     5.364   136.658     0.200
     6.868   175.348     0.200
     6.868   178.258     0.200
     6.868   177.996     0.200
    12.567   317.118     0.200
    21.266   525.758     0.200
     0.162    14.531     0.200
     0.382    18.234     0.200
     1.384    41.031     0.200
     2.299    63.633     0.200
     2.601    71.734     0.200
     2.649    73.434     0.200
     2.677    73.934     0.200
     3.166    84.734     0.200
     4.544   123.133     0.200
     4.665   121.531     0.200
     5.439   139.031     0.200
     7.302   185.582     0.200
     8.577   221.934     0.200
    12.988   325.133     0.200
    14.499   361.633     0.200
    15.554   387.133     0.200
    16.634   414.934     0.200
    23.232   564.934     0.200
     0.164    14.602     0.200
     0.241    15.906     0.200
     0.283    17.406     0.200
     0.384    17.406     0.200
     0.468    20.805     0.200
     0.717    25.703     0.200
     0.828    28.305     0.200
     1.126    33.305     0.200
     1.321    40.703     0.200
     1.386    40.203     0.200
     1.857    53.383     0.200
     2.603    70.406     0.200
     2.651    73.102     0.200
     2.680    73.102     0.200
     3.169    84.008     0.200
     4.546   120.906     0.200
     0.163    16.212     0.200
     0.242    16.512     0.200
     0.432    19.212     0.200
     0.662    24.512     0.200
     0.882    30.012     0.200
     1.163    34.312     0.200
     1.454    41.812     0.200
     2.362    64.712     0.200
     2.662    72.012     0.200
     2.710    74.111     0.200
     2.739    74.312     0.200
     3.236    84.312     0.200
     4.605   122.012     0.200
     0.579    19.223     0.200
     1.158    35.121     0.200
     1.445    42.996     0.200
     2.398    66.523     0.200
     2.677    73.324     0.200
     2.753    75.922     0.200
     4.284   114.023     0.200
     4.596   123.324     0.200
     0.136    14.559     0.200
     0.792    27.359     0.200
     1.093    32.660     0.200
     1.350    39.961     0.200
     2.265    62.559     0.200
     2.567    69.660     0.200
     2.615    72.762     0.200
     2.643    73.059     0.200
     3.132    81.961     0.200
     4.510   119.859     0.200
     0.337    19.695     0.200
     0.376    20.094     0.200
     0.458    22.797     0.200
     0.765    27.094     0.200
     0.848    29.297     0.200
     0.881    30.195     0.200
     1.082    33.398     0.200
     1.211    37.195     0.200
     1.337    39.500     0.200
     1.525    45.094     0.200
     1.585    46.000     0.200
     1.823    51.500     0.200
     1.823    51.797     0.200
     2.132    58.297     0.200
     2.132    58.594     0.200
     2.185    60.297     0.200
     2.185    61.000     0.200
     2.207    60.297     0.200
     2.207    60.797     0.200
     2.658    69.297     0.200
     2.658    69.797     0.200
     4.071   106.297     0.200
     4.071   108.500     0.200
     0.198    18.414     0.200
     0.246    16.492     0.200
     0.213    16.395     0.200
     0.510    20.594     0.200
     0.765    26.992     0.200
     1.327    39.992     0.200
     2.417    66.992     0.200
     2.720    74.094     0.200
     2.769    76.695     0.200
     2.797    75.992     0.200
     3.275    85.094     0.200
     4.664   122.793     0.200
     4.779   125.895     0.200
     6.743   171.793     0.200
     0.234    16.430     0.200
     0.414    19.031     0.200
     0.656    24.430     0.200
     1.143    33.930     0.200
     1.828    49.703     0.200
     2.344    64.930     0.200
     2.644    72.031     0.200
     2.721    74.031     0.200
     3.220    84.031     0.200
     4.587   121.531     0.200
     0.134    13.830     0.200
     0.313    16.430     0.200
     0.436    17.930     0.200
     1.955    55.205     0.200
     2.312    62.029     0.200
     2.617    70.029     0.200
     2.617    70.430     0.200
     2.667    71.729     0.200
     2.667    71.129     0.200
     2.693    72.029     0.200
     4.560   119.029     0.200
     4.560   123.129     0.200
     0.146    15.666     0.200
     0.260    16.367     0.200
     0.318    19.307     0.200
     0.444    18.967     0.200
     0.376    19.967     0.200
     1.172    34.867     0.200
     1.235    38.967     0.200
     1.469    42.266     0.200
     1.841    50.066     0.200
     4.618   123.266     0.200
     4.663   122.867     0.200
     6.814   176.426     0.200
     6.814   176.666     0.200
     6.814   176.428     0.200
     9.988   252.066     0.200
    12.893   321.367     0.200
    15.037   373.766     0.200
     0.400    18.059     0.200
     2.252    59.459     0.200
     2.624    70.559     0.200
     2.672    73.559     0.200
     2.701    73.059     0.200
     2.701    72.459     0.200
     4.567   121.259     0.200
     4.567   118.459     0.200
     4.664   123.459     0.200
     6.852   176.959     0.200
     9.513   234.091     0.200
     9.514   231.749     0.200
    12.958   322.959     0.200
     0.192    15.749     0.200
     0.217    15.749     0.200
     0.441    18.948     0.200
     0.705    24.548     0.200
     0.887    29.948     0.200
     1.179    34.849     0.200
     1.880    53.979     0.200
     1.881    53.974     0.200
     2.288    60.148     0.200
     2.663    72.048     0.200
     2.663    71.148     0.200
     2.712    74.249     0.200
     2.712    73.148     0.200
     2.740    73.448     0.200
     2.740    73.148     0.200
     4.607   122.148     0.200
     4.607   119.148     0.200
     0.167    15.113     0.200
     0.239    16.211     0.200
     0.399    17.910     0.200
     0.470    20.910     0.200
     0.727    26.312     0.200
     0.841    28.812     0.200
     0.922    31.312     0.200
     1.141    33.613     0.200
     1.327    39.910     0.200
     1.396    41.012     0.200
     2.237    59.312     0.200
     2.615    70.410     0.200
     2.664    74.410     0.200
     2.692    72.711     0.200
     4.559   121.910     0.200
     0.100    12.812     0.200
     0.245    13.516     0.200
     1.039    31.016     0.200
     1.195    36.016     0.200
     1.121    33.613     0.200
     1.214    36.812     0.200
     1.805    50.543     0.200
     1.806    50.539     0.200
     2.648    69.016     0.200
     2.678    72.613     0.200
     2.678    71.914     0.200
     2.968    79.414     0.200
     2.968    78.914     0.200
     3.045    81.812     0.200
     3.045    80.914     0.200
     4.902   130.516     0.200
     4.902   128.914     0.200
     6.622   166.824     0.200
     6.624   171.016     0.200
     8.134   204.836     0.200
     9.414   229.465     0.200
    12.181   310.344     0.200
     0.130    15.381     0.200
     0.328    17.280     0.200
     0.377    18.980     0.200
     0.555    20.980     0.200
     1.004    32.280     0.200
     1.286    37.480     0.200
     1.393    40.681     0.200
     1.408    41.480     0.200
     1.936    56.110     0.200
     1.937    56.106     0.200
     2.406    63.780     0.200
     2.480    66.780     0.200
     2.858    76.081     0.200
     0.187    15.248     0.200
     0.219    15.748     0.200
     0.408    18.148     0.200
     0.853    28.848     0.200
     1.148    33.949     0.200
     1.412    41.348     0.200
     2.253    59.748     0.200
     2.327    64.049     0.200
     2.629    70.449     0.200
     2.705    73.148     0.200
     3.195    82.348     0.200
     4.572   118.549     0.200
     0.353    14.582     0.200
     0.559    19.182     0.200
     0.597    20.182     0.200
     0.915    30.082     0.200
     1.141    33.383     0.200
     1.653    49.406     0.200
     1.652    49.383     0.200
     2.483    64.082     0.200
     2.501    68.182     0.200
     2.789    75.781     0.200
     2.866    77.682     0.200
     3.412    88.082     0.200
     4.720   126.281     0.200
     4.720   124.383     0.200
     0.131    15.047     0.200
     0.294    18.148     0.200
     0.295    17.539     0.200
     0.277    16.445     0.200
     0.352    17.344     0.200
     0.792    27.750     0.200
     1.095    32.648     0.200
     1.348    40.445     0.200
     1.847    55.250     0.200
     2.189    57.547     0.200
     2.189    58.445     0.200
     2.264    61.547     0.200
     2.264    62.047     0.200
     2.566    69.547     0.200
     2.566    70.148     0.200
     2.643    70.547     0.200
     2.643    71.445     0.200
     3.131    80.547     0.200
     3.131    81.445     0.200
     4.510   119.547     0.200
     4.652   122.547     0.200
     4.652   122.750     0.200
     6.901   177.250     0.200
     0.335    16.434     0.200
     0.447    18.035     0.200
     0.617    24.637     0.200
     0.847    28.035     0.200
     1.013    31.336     0.200
     0.990    31.234     0.200
     1.187    37.234     0.200
     1.277    36.836     0.200
     1.362    42.336     0.200
     1.511    43.969     0.200
     2.309    59.535     0.200
     2.315    62.535     0.200
     2.600    70.535     0.200
     2.677    71.836     0.200
     3.232    83.637     0.200
     4.529   117.035     0.200
     0.555    18.570     0.200
     0.668    21.375     0.200
     1.005    30.375     0.200
     1.037    33.172     0.200
     1.137    34.875     0.200
     1.377    40.500     0.200
     2.337    63.773     0.200
     2.337    64.375     0.200
     2.357    62.375     0.200
     2.357    61.469     0.200
     2.612    72.070     0.200
     2.689    74.773     0.200
     4.215   112.875     0.200
     4.215   108.773     0.200
     4.528   120.969     0.200
     4.528   122.672     0.200
     8.127   209.672     0.200
     0.216    11.414     0.200
     0.539    18.613     0.200
     0.661    21.012     0.200
     0.891    29.012     0.200
     0.983    29.812     0.200
     1.124    34.414     0.200
     2.315    63.113     0.200
     2.315    63.613     0.200
     2.336    61.113     0.200
     2.336    61.012     0.200
     2.590    70.113     0.200
     2.590    70.914     0.200
     2.667    72.113     0.200
     2.667    72.215     0.200
     4.506   118.113     0.200
     4.506   121.312     0.200
     0.227    19.652     0.200
     0.316    20.553     0.200
     0.436    23.652     0.200
     0.593    26.021     0.200
     0.681    26.451     0.200
     0.808    29.553     0.200
     0.935    31.652     0.200
     1.274    39.152     0.200
     1.353    40.553     0.200
     1.489    44.352     0.200
     1.523    45.053     0.200
     1.518    45.451     0.200
     1.784    51.832     0.200
     1.785    51.826     0.200
     1.862    52.951     0.200
     2.168    59.951     0.200
     2.244    62.252     0.200
     4.111   108.053     0.200
     4.501   116.652     0.200
     4.501   116.291     0.200
     6.673   168.252     0.200
     7.270   186.152     0.200
     1.735    53.344     0.200
     3.545   100.570     0.200
     4.446   120.570     0.200
     5.349   145.270     0.200
     6.484   171.172     0.200
     6.546   177.371     0.200
     7.044   181.820     0.200
     8.298   217.172     0.200
     8.806   227.270     0.200
     9.563   241.270     0.200
    12.378   316.469     0.200
    12.915   326.871     0.200
    13.245   339.469     0.200
    15.438   386.270     0.200
    15.534   389.070     0.200
    19.789   500.570     0.200
    20.745   516.672     0.200
     0.157    14.791     0.200
     0.256    16.591     0.200
     0.351    17.191     0.200
     0.796    27.891     0.200
     1.092    32.891     0.200
     1.360    40.091     0.200
     2.573    70.091     0.200
     2.573    69.591     0.200
     2.650    72.490     0.200
     4.516   118.891     0.200
     4.516   119.490     0.200
     0.541    20.797     0.200
     0.571    20.195     0.200
     0.713    23.797     0.200
     0.704    23.797     0.200
     0.871    28.000     0.200
     0.961    30.602     0.200
     1.032    30.797     0.200
     1.312    37.102     0.200
     1.335    40.000     0.200
     1.374    38.195     0.200
     1.381    38.000     0.200
     1.474    43.102     0.200
     1.489    41.898     0.200
     1.489    42.602     0.200
     1.800    49.797     0.200
     1.874    52.898     0.200
     3.735    99.195     0.200
     3.735   100.398     0.200
     4.418   114.398     0.200
     0.235    11.891     0.200
     0.674    21.695     0.200
     0.850    28.195     0.200
     1.328    40.562     0.200
     1.329    40.469     0.200
     1.603    45.594     0.200
     2.279    64.195     0.200
     2.285    67.797     0.200
     2.306    61.797     0.200
     2.630    73.992     0.200
     2.630    74.391     0.200
     4.165   109.992     0.200
     4.467   119.992     0.200
     4.467   121.891     0.200
     6.305   161.594     0.200
     9.657   247.695     0.200
     0.550    20.035     0.200
     1.179    34.635     0.200
     1.604    47.385     0.200
     2.430    63.035     0.200
     2.444    67.035     0.200
     2.486    71.734     0.200
     2.731    74.035     0.200
     2.808    76.936     0.200
     4.661   122.836     0.200
     9.642   237.260     0.200
     0.578    20.410     0.200
     1.150    34.610     0.200
     1.642    48.060     0.200
     1.873    53.570     0.200
     2.954    81.310     0.200
     3.299    90.410     0.200
     5.120   135.210     0.200
     5.120   138.710     0.200
     6.637   169.210     0.200
     0.440    16.609     0.200
     1.136    34.406     0.200
     6.654   176.008     0.200
     0.162    15.992     0.200
     0.235    16.594     0.200
     0.246    16.797     0.200
     0.328    19.352     0.200
     0.328    18.695     0.200
     0.421    18.992     0.200
     0.384    20.398     0.200
     0.646    24.398     0.200
     0.872    29.695     0.200
     1.149    34.297     0.200
     1.240    38.398     0.200
     1.240    38.062     0.200
     1.448    41.797     0.200
     1.552    44.297     0.200
     2.289    60.695     0.200
     2.289    60.898     0.200
     2.353    64.492     0.200
     2.653    71.594     0.200
     2.653    71.195     0.200
     2.729    74.094     0.200
     2.729    73.195     0.200
     4.595   121.797     0.200
     4.595   119.195     0.200
     4.645   121.297     0.200
     4.645   121.195     0.200
     0.213    15.621     0.200
     0.193    15.723     0.200
     0.422    18.621     0.200
     0.869    29.223     0.200
     1.158    33.820     0.200
     1.282    39.223     0.200
     1.434    41.820     0.200
     1.860    53.398     0.200
     2.275    60.023     0.200
     2.346    64.223     0.200
     2.647    71.820     0.200
     2.724    73.320     0.200
     4.590   119.723     0.200
     0.149    15.914     0.200
     0.454    19.211     0.200
     0.637    22.812     0.200
     0.965    31.016     0.200
     1.146    33.914     0.200
     1.239    36.812     0.200
     1.764    49.562     0.200
     1.798    49.711     0.200
     2.530    66.211     0.200
     2.530    67.016     0.200
     2.564    70.617     0.200
     2.622    74.914     0.200
     2.855    77.617     0.200
     2.932    79.617     0.200
     4.603   121.516     0.200
     4.791   126.414     0.200
     6.714   171.812     0.200
     6.737   173.414     0.200
     9.707   245.914     0.200
    11.208   283.117     0.200
    12.300   312.727     0.200
    12.490   309.516     0.200
    15.166   371.914     0.200
     0.244    16.549     0.200
     0.299    18.448     0.200
     0.370    17.249     0.200
     0.815    27.448     0.200
     1.111    33.049     0.200
     1.316    39.578     0.200
     1.377    40.148     0.200
     2.218    58.448     0.200
     2.290    63.549     0.200
     2.395    67.348     0.200
     2.592    70.148     0.200
     2.668    72.049     0.200
     4.535   119.948     0.200
     4.535   118.648     0.200
     4.651   122.549     0.200
     6.512   165.148     0.200
     6.807   176.948     0.200
     6.807   174.948     0.200
     6.882   177.249     0.200
     7.693   190.249     0.200
     7.999   199.049     0.200
     8.100   197.749     0.200
    10.075   253.948     0.200
    11.249   283.049     0.200
    13.099   321.448     0.200
     0.270    17.008     0.200
     0.219    15.914     0.200
     0.478    21.312     0.200
     0.639    23.312     0.200
     0.844    27.312     0.200
     0.950    29.211     0.200
     0.980    31.008     0.200
     1.319    38.812     0.200
     1.398    40.008     0.200
     1.820    48.711     0.200
     1.908    54.008     0.200
     1.908    53.711     0.200
     2.043    58.312     0.200
     2.214    60.711     0.200
     2.290    62.312     0.200
     2.290    62.711     0.200
     4.157   113.508     0.200
     4.527   118.812     0.200
     0.366    18.023     0.200
     0.496    19.625     0.200
     0.651    23.328     0.200
     0.754    24.828     0.200
     0.978    30.727     0.200
     1.136    33.625     0.200
     1.406    41.422     0.200
     1.481    40.727     0.200
     1.481    40.922     0.200
     1.488    40.828     0.200
     1.521    43.523     0.200
     1.585    45.727     0.200
     1.623    46.523     0.200
     1.775    51.422     0.200
     1.867    51.742     0.200
     1.869    52.648     0.200
     1.910    52.828     0.200
     1.910    52.125     0.200
     1.922    53.023     0.200
     1.984    54.625     0.200
     1.984    55.227     0.200
     2.844    74.594     0.200
     3.845   102.523     0.200
     3.845   101.828     0.200
     4.480   115.227     0.200
     6.655   171.125     0.200
     0.132    14.734     0.200
     0.275    16.535     0.200
     0.359    17.133     0.200
     1.102    32.934     0.200
     1.353    40.133     0.200
     1.456    41.734     0.200
     2.194    58.535     0.200
     2.379    66.934     0.200
     3.136    81.234     0.200
     4.515   119.535     0.200
     4.515   116.035     0.200
     0.175    15.344     0.200
     0.256    17.344     0.200
     0.233    15.945     0.200
     0.415    18.141     0.200
     0.856    29.047     0.200
     1.156    33.945     0.200
     1.326    40.047     0.200
     1.326    39.906     0.200
     1.409    40.344     0.200
     1.512    42.047     0.200
     2.250    59.641     0.200
     2.327    63.242     0.200
     2.436    67.945     0.200
     2.706    72.742     0.200
     3.192    82.641     0.200
     3.192    83.047     0.200
     4.573   121.344     0.200
     4.573   118.242     0.200
     4.696   122.844     0.200
     0.257    16.016     0.200
     0.305    16.715     0.200
     0.452    19.113     0.200
     1.182    34.516     0.200
     1.578    44.715     0.200
     1.855    53.215     0.200
     2.315    60.914     0.200
     2.382    66.113     0.200
     2.479    71.516     0.200
     2.759    74.316     0.200
     3.256    85.016     0.200
     4.625   122.016     0.200
     4.625   120.215     0.200
     4.677   121.113     0.200
     8.590   220.215     0.200
     0.143    15.672     0.200
     0.264    16.473     0.200
     0.298    17.473     0.200
     0.464    19.473     0.200
     0.914    30.473     0.200
     1.194    34.973     0.200
     1.244    38.270     0.200
     1.588    45.473     0.200
     1.865    53.121     0.200
     2.325    61.570     0.200
     2.491    70.770     0.200
     2.770    74.172     0.200
     2.770    73.973     0.200
     3.266    84.973     0.200
     3.266    84.871     0.200
     4.636   119.570     0.200
     4.687   121.172     0.200
     0.126    15.163     0.200
     0.261    16.323     0.200
     0.341    18.063     0.200
     1.004    30.943     0.200
     1.267    37.863     0.200
     1.361    41.223     0.200
     1.372    40.083     0.200
     1.780    50.083     0.200
     1.781    50.108     0.200
     2.109    56.283     0.200
     2.282    65.683     0.200
     2.555    71.183     0.200
     2.555    70.183     0.200
     4.422   118.983     0.200
     4.576   120.683     0.200
     4.576   119.283     0.200
     0.154    16.090     0.200
     0.251    16.730     0.200
     0.316    18.820     0.200
     0.315    18.910     0.200
     0.383    19.633     0.200
     0.436    19.332     0.200
     0.654    23.590     0.200
     0.836    29.422     0.200
     1.165    33.992     0.200
     1.241    37.621     0.200
     1.241    38.281     0.200
     1.460    41.391     0.200
     2.071    57.773     0.200
     2.302    60.551     0.200
     2.302    61.250     0.200
     2.463    69.051     0.200
     2.744    74.750     0.200
     2.744    74.352     0.200
     3.243    85.051     0.200
     3.243    85.352     0.200
     4.610   122.250     0.200
     4.610   119.852     0.200
     4.726   118.250     0.200
     4.661   124.453     0.200
     6.427   158.641     0.200
     6.821   175.770     0.200
     0.218    15.492     0.200
     0.260    17.391     0.200
     0.447    18.750     0.200
     0.432    20.250     0.200
     0.710    25.969     0.200
     0.892    28.789     0.200
     1.185    34.789     0.200
     1.451    41.219     0.200
     1.554    44.008     0.200
     2.291    61.008     0.200
     2.744    74.508     0.200
     2.744    73.906     0.200
     3.233    83.406     0.200
     4.611   124.008     0.200
     4.705   123.211     0.200
     0.185    15.349     0.200
     0.225    15.829     0.200
     0.422    18.229     0.200
     0.461    21.049     0.200
     0.864    29.089     0.200
     1.320    40.909     0.200
     1.522    43.319     0.200
     2.259    59.919     0.200
     2.445    70.219     0.200
     2.715    74.219     0.200
     2.715    73.319     0.200
     4.718   119.429     0.200
     0.193    15.336     0.200
     0.286    16.094     0.200
     0.405    18.125     0.200
     0.851    28.742     0.200
     1.143    33.703     0.200
     1.297    39.086     0.200
     1.517    42.781     0.200
     2.106    58.555     0.200
     2.255    58.883     0.200
     2.255    59.383     0.200
     2.430    68.883     0.200
     2.704    72.781     0.200
     4.571   118.883     0.200
     4.670   122.688     0.200
     6.825   175.188     0.200
     8.582   218.586     0.200
    10.053   257.484     0.200
    12.960   323.484     0.200
    16.603   411.883     0.200
    21.320   525.984     0.200
     0.277    16.734     0.200
     0.347    16.973     0.200
     1.090    32.484     0.200
     1.345    39.781     0.200
     1.449    42.012     0.200
     2.186    57.012     0.200
     2.186    57.113     0.200
     2.368    65.812     0.200
     2.639    70.914     0.200
     4.506   118.512     0.200
     4.506   116.414     0.200
     4.646   121.711     0.200
     4.646   121.211     0.200
     6.906   177.664     0.200
     8.557   221.812     0.200
     0.224    16.203     0.200
     0.182    15.914     0.200
     0.289    18.320     0.200
     0.290    18.305     0.200
     0.430    18.820     0.200
     0.415    19.945     0.200
     0.684    25.391     0.200
     0.878    29.719     0.200
     1.165    34.492     0.200
     1.273    39.422     0.200
     1.444    42.242     0.200
     1.548    44.055     0.200
     1.859    51.875     0.200
     2.285    60.648     0.200
     2.285    60.750     0.200
     2.456    68.055     0.200
     2.733    73.148     0.200
     2.733    73.750     0.200
     4.599   122.852     0.200
     4.599   119.352     0.200
     4.677   122.055     0.200
     0.205    16.273     0.200
     0.402    18.070     0.200
     0.431    20.773     0.200
     0.687    25.473     0.200
     0.850    28.660     0.200
     1.139    33.320     0.200
     2.257    59.152     0.200
     2.257    59.453     0.200
     2.428    68.852     0.200
     2.704    73.750     0.200
     4.571   120.453     0.200
     4.571   120.250     0.200
     4.660   122.453     0.200
     6.815   175.051     0.200
     6.851   175.488     0.200
     8.573   217.551     0.200
    11.261   282.953     0.200
    12.950   322.652     0.200
     0.133    15.926     0.200
     0.277    17.115     0.200
     0.345    19.156     0.200
     0.354    19.285     0.200
     0.440    19.455     0.200
     0.622    23.416     0.200
     1.161    34.436     0.200
     1.210    37.506     0.200
     1.578    44.816     0.200
     1.817    52.016     0.200
     2.314    61.215     0.200
     2.750    72.115     0.200
     4.640   120.816     0.200
     9.511   231.416     0.200
     0.167    15.234     0.200
     0.239    16.055     0.200
     0.277    17.848     0.200
     0.392    18.035     0.200
     0.467    20.598     0.200
     0.720    26.086     0.200
     0.835    28.746     0.200
     1.133    33.598     0.200
     1.322    39.676     0.200
     1.392    40.727     0.200
     2.233    59.125     0.200
     2.415    69.426     0.200
     2.686    72.426     0.200
     2.686    71.824     0.200
     3.175    83.027     0.200
     4.553   120.824     0.200
     4.673   122.125     0.200
     6.830   177.625     0.200
     6.830   175.027     0.200
     6.861   176.102     0.200
     8.317   211.449     0.200
     8.585   217.426     0.200
    12.986   324.426     0.200
    13.430   333.926     0.200
    14.984   367.824     0.200
    20.743   512.426     0.200
    22.269   547.926     0.200
     1.094    33.461     0.200
     2.791    79.340     0.200
     3.166    86.840     0.200
     3.779    99.539     0.200
     3.779    98.441     0.200
     4.210   110.742     0.200
     4.210   109.242     0.200
     4.969   130.641     0.200
     6.290   161.039     0.200
     8.093   205.941     0.200
     8.093   210.641     0.200
     9.077   233.742     0.200
    12.427   315.039     0.200
    14.619   361.742     0.200
     0.606    21.660     0.200
     0.673    23.160     0.200
     2.221    59.500     0.200
     2.909    76.898     0.200
     3.184    84.898     0.200
     3.799    99.699     0.200
     4.208   112.600     0.200
     4.985   130.000     0.200
     0.181    16.057     0.200
     0.225    16.387     0.200
     0.295    18.766     0.200
     0.426    19.025     0.200
     0.679    25.307     0.200
     1.160    34.146     0.200
     1.270    38.705     0.200
     1.442    41.676     0.200
     1.546    43.705     0.200
     1.854    52.906     0.200
     2.283    60.406     0.200
     2.453    70.105     0.200
     2.730    73.807     0.200
     2.730    73.605     0.200
     3.225    83.105     0.200
     3.225    83.906     0.200
     4.596   123.406     0.200
     4.596   119.307     0.200
     0.325    18.838     0.200
     0.304    17.707     0.200
     0.454    20.067     0.200
     0.715    25.638     0.200
     0.900    28.947     0.200
     0.812    26.857     0.200
     1.138    34.378     0.200
     1.220    35.758     0.200
     1.393    41.718     0.200
     1.457    42.907     0.200
     1.638    44.747     0.200
     1.638    44.348     0.200
     1.865    53.647     0.200
     1.758    49.947     0.200
     2.107    58.247     0.200
     2.580    67.848     0.200
     2.580    67.048     0.200
     3.973   103.747     0.200
     3.973   104.848     0.200
     4.432   114.447     0.200
     6.606   167.947     0.200
     7.404   190.741     0.200
     8.733   219.673     0.200
     9.618   248.848     0.200
    10.486   267.447     0.200
    13.211   335.998     0.200
     0.134    14.396     0.200
     0.274    16.387     0.200
     0.295    17.518     0.200
     0.353    16.957     0.200
     0.794    27.627     0.200
     1.096    32.756     0.200
     1.343    41.246     0.200
     2.191    59.086     0.200
     2.191    58.287     0.200
     2.374    68.287     0.200
     2.644    72.986     0.200
     3.133    82.688     0.200
     4.511   118.887     0.200
     0.236    14.224     0.200
     0.343    15.674     0.200
     0.613    21.424     0.200
     0.899    29.163     0.200
     1.066    34.804     0.200
     1.124    32.833     0.200
     1.165    35.974     0.200
     1.217    35.674     0.200
     1.650    47.158     0.200
     1.771    48.483     0.200
     2.497    64.884     0.200
     2.878    76.384     0.200
     3.426    88.483     0.200
     4.732   123.184     0.200
     0.242    15.805     0.200
     0.266    16.555     0.200
     0.493    21.273     0.200
     0.644    23.000     0.200
     0.983    30.945     0.200
     1.084    32.320     0.200
     1.319    38.680     0.200
     1.409    40.109     0.200
     1.544    44.859     0.200
     1.572    45.164     0.200
     1.821    48.820     0.200
     1.824    51.594     0.200
     2.053    59.023     0.200
     2.297    62.422     0.200
     2.297    62.125     0.200
     2.764    72.422     0.200
     4.163   110.625     0.200
     4.163   108.625     0.200
     4.550   119.219     0.200
     4.550   118.320     0.200
     0.201    16.082     0.200
     0.276    17.980     0.200
     0.276    18.051     0.200
     0.424    19.191     0.200
     0.434    20.332     0.200
     0.702    25.332     0.200
     0.870    28.934     0.200
     1.162    35.480     0.200
     1.293    39.602     0.200
     1.869    53.258     0.200
     2.723    74.031     0.200
     2.723    74.531     0.200
     3.214    85.133     0.200
     3.214    83.832     0.200
     4.590   120.133     0.200
     4.590   122.531     0.200
     6.839   174.434     0.200
    12.322   304.133     0.200
    13.410   337.133     0.200
     1.506    43.945     0.200
     3.156    84.168     0.200
     3.756    98.867     0.200
     4.306   115.168     0.200
     4.306   115.766     0.200
     4.973   131.367     0.200
     6.393   165.566     0.200
     7.477   193.668     0.200
     8.194   209.168     0.200
     9.164   237.367     0.200
     9.703   243.418     0.200
     9.651   246.043     0.200
    10.877   280.367     0.200
    10.891   273.969     0.200
    12.089   307.969     0.200
    12.933   327.445     0.200
    14.739   365.969     0.200
    14.808   370.891     0.200
    15.215   372.164     0.200
    15.556   376.039     0.200
    15.840   399.367     0.200
    18.850   466.664     0.200
    19.358   480.195     0.200
    20.704   510.070     0.200
    21.264   531.469     0.200
    22.682   553.070     0.200
     0.677    22.703     0.200
     3.194    86.797     0.200
     3.789    98.000     0.200
     3.789    98.297     0.200
     5.016   134.797     0.200
     0.461    17.891     0.200
     0.428    17.930     0.200
     0.705    23.969     0.200
     0.620    22.266     0.200
     1.104    33.031     0.200
     3.272    87.961     0.200
     3.860   100.062     0.200
     4.454   116.062     0.200
     5.099   134.062     0.200
     5.099   136.461     0.200
     9.553   236.711     0.200
    12.719   315.359     0.200
     1.143    34.578     0.200
     1.388    40.141     0.200
     0.087    10.984     0.200
     0.309    13.023     0.200
     0.396    17.234     0.200
     0.480    18.875     0.200
     0.693    24.820     0.200
     0.718    23.695     0.200
     0.822    28.930     0.200
     1.042    31.328     0.200
     1.066    32.367     0.200
     1.486    44.430     0.200
     1.091    33.211     0.200
     3.121    82.977     0.200
     3.724    95.883     0.200
     4.265   112.680     0.200
     4.936   127.281     0.200
     0.370    16.148     0.200
     0.501    18.688     0.200
     1.045    32.258     0.200
     1.071    31.906     0.200
     1.499    44.133     0.200
     0.400    16.508     0.200
     1.046    32.258     0.200
     1.045    31.508     0.200
     3.156    85.758     0.200
     3.756    98.156     0.200
     4.309   113.859     0.200
     4.974   132.555     0.200
     4.974   134.156     0.200
     8.197   214.156     0.200
     9.700   239.945     0.200
    11.976   306.000     0.200
     0.029    10.922     0.200
     0.336    13.852     0.200
     0.413    17.430     0.200
     0.701    23.227     0.200
     0.738    25.805     0.200
     0.882    30.406     0.200
     1.047    30.906     0.200
     1.016    31.242     0.200
     1.280    39.727     0.200
     1.545    45.391     0.200
     0.018    10.656     0.200
     0.364    14.766     0.200
     0.423    17.180     0.200
     0.672    22.633     0.200
     0.767    26.539     0.200
     0.924    30.977     0.200
     0.979    30.836     0.200
     1.059    31.680     0.200
     1.146    37.305     0.200
     1.254    38.977     0.200
     1.388    41.312     0.200
     1.435    42.227     0.200
     1.401    41.766     0.200
     1.587    48.062     0.200
     3.206    84.633     0.200
     3.798    97.438     0.200
     4.387   115.234     0.200
     0.402    16.281     0.200
     0.719    23.406     0.200
     1.058    32.422     0.200
     1.118    33.500     0.200
     1.118    33.547     0.200
     1.497    43.477     0.200
     1.497    43.906     0.200
     2.018    57.477     0.200
     3.147    84.125     0.200
     3.747    97.320     0.200
     4.298   113.125     0.200
     4.964   128.320     0.200
     4.964   133.820     0.200
     8.187   208.625     0.200
     0.456    17.500     0.200
     0.411    17.141     0.200
     1.041    31.352     0.200
     1.528    45.445     0.200
     0.070    10.281     0.200
     0.302    13.570     0.200
     0.419    17.367     0.200
     0.723    25.539     0.200
     0.724    23.953     0.200
     1.025    30.391     0.200
     1.057    32.188     0.200
     1.078    34.914     0.200
     1.099    33.383     0.200
     1.099    32.133     0.200
     1.289    39.359     0.200
     1.316    40.539     0.200
     1.319    38.750     0.200
     1.387    40.703     0.200
     1.506    43.391     0.200
     1.506    44.094     0.200
     1.506    45.633     0.200
     1.506    44.070     0.200
     1.946    54.844     0.200
     2.010    55.930     0.200
     2.010    56.320     0.200
     2.026    55.031     0.200
     2.330    63.711     0.200
     2.375    63.664     0.200
     2.846    74.594     0.200
     3.141    84.891     0.200
     3.739    96.891     0.200
     4.248   110.922     0.200
     4.310   114.891     0.200
     4.310   115.891     0.200
     4.424   117.859     0.200
     4.960   129.992     0.200
     4.960   133.688     0.200
     9.186   233.391     0.200
    10.898   274.992     0.200
    12.562   315.891     0.200
    13.659   341.094     0.200
    13.659   342.289     0.200
    14.757   366.188     0.200
    22.703   558.688     0.200
     1.062    31.633     0.200
     1.144    34.547     0.200
     3.100    80.656     0.200
     3.713    96.062     0.200
     0.695    22.430     0.200
     1.389    41.312     0.200
     1.430    41.180     0.200
     1.575    45.883     0.200
     0.033    11.430     0.200
     0.333    13.609     0.200
     0.453    18.633     0.200
     0.412    17.688     0.200
     0.702    23.180     0.200
     0.695    23.305     0.200
     0.736    26.016     0.200
     0.878    29.914     0.200
     1.020    31.812     0.200
     1.045    31.039     0.200
     1.099    32.812     0.200
     1.105    36.039     0.200
     1.541    44.461     0.200
     1.541    43.297     0.200
     0.046    11.203     0.200
     0.341    13.977     0.200
     0.390    17.148     0.200
     0.477    18.602     0.200
     0.725    23.352     0.200
     0.685    23.133     0.200
     0.712    25.484     0.200
     1.062    31.148     0.200
     1.023    31.633     0.200
     1.123    34.227     0.200
     1.277    39.508     0.200
     1.346    39.516     0.200
     1.528    45.102     0.200
     0.367    15.977     0.200
     1.061    31.656     0.200
     1.144    34.625     0.200
     3.103    83.820     0.200
     3.716    96.625     0.200
     4.183   111.422     0.200
     4.908   131.625     0.200
     4.908   132.625     0.200
     0.013    10.430     0.200
     0.367    14.531     0.200
     0.451    17.977     0.200
     0.416    17.320     0.200
     0.698    23.352     0.200
     0.667    22.453     0.200
     0.761    26.211     0.200
     0.921    31.250     0.200
     0.978    30.531     0.200
     1.064    31.820     0.200
     1.142    37.031     0.200
     1.250    39.133     0.200
     1.585    45.047     0.200
     1.057    31.509     0.200
     1.050    32.189     0.200
     1.498    43.589     0.200
     1.043    31.958     0.200
     1.075    31.768     0.200
     1.152    34.277     0.200
     0.451    16.858     0.200
     0.699    22.738     0.200
     1.067    32.309     0.200
     0.449    17.576     0.200
     0.421    17.105     0.200
     1.069    32.096     0.200
     3.220    86.775     0.200
     3.812    97.377     0.200
     3.812    99.977     0.200
     4.400   118.877     0.200
     5.044   130.576     0.200
    12.082   306.977     0.200
     1.063    31.574     0.200
     1.127    33.705     0.200
     0.487    19.205     0.200
     0.384    16.434     0.200
     1.057    31.555     0.200
     1.049    32.184     0.200
     1.500    44.545     0.200
     1.500    44.555     0.200
     2.015    55.424     0.200
     3.161    83.744     0.200
     3.763    97.443     0.200
     3.763    97.145     0.200
     4.297   114.744     0.200
     4.297   114.244     0.200
     4.977   130.443     0.200
     4.977   133.344     0.200
     9.710   239.145     0.200
     0.180    12.270     0.200
     0.196    13.289     0.200
     0.767    26.719     0.200
     1.166    34.531     0.200
     1.420    43.379     0.200
     0.455    17.906     0.200
     0.412    17.211     0.200
     1.066    32.539     0.200
     3.208    87.828     0.200
     3.802    98.531     0.200
     4.379   118.531     0.200
     5.031   133.430     0.200
     0.372    16.156     0.200
     1.075    32.766     0.200
     1.061    31.812     0.200
     3.147    83.641     0.200
     3.752    96.438     0.200
     4.263   114.438     0.200
     4.959   129.336     0.200
     0.364    14.172     0.200
     1.060    31.844     0.200
     1.583    46.672     0.200
     3.205    85.727     0.200
     3.798    97.625     0.200
     4.384   118.125     0.200
     4.384   117.828     0.200
     5.028   131.227     0.200
     5.028   135.625     0.200
     0.379    14.555     0.200
     0.447    17.977     0.200
     0.423    17.367     0.200
     0.660    22.297     0.200
     0.774    26.391     0.200
     0.938    31.250     0.200
     0.963    30.328     0.200
     1.068    31.648     0.200
     1.241    38.867     0.200
     1.416    41.688     0.200
     1.602    47.305     0.200
     3.811    96.609     0.200
     0.380    16.396     0.200
     0.499    19.017     0.200
     0.714    23.167     0.200
     1.074    32.566     0.200
     1.472    43.807     0.200
     3.144    84.207     0.200
     3.748    97.807     0.200
     4.269   114.407     0.200
     4.269   114.207     0.200
     4.957   129.507     0.200
     8.157   210.007     0.200
     9.149   233.507     0.200
    12.077   306.007     0.200
     0.744    23.766     0.200
     1.105    33.613     0.200
     1.443    42.027     0.200
     3.114    84.453     0.200
     3.720    97.055     0.200
     4.243   113.754     0.200
     4.243   110.855     0.200
     4.503   117.055     0.200
     4.927   129.254     0.200
     8.132   209.055     0.200
    12.093   307.652     0.200
     0.394    17.105     0.200
     0.474    18.477     0.200
     1.053    31.445     0.200
     1.038    31.875     0.200
     1.515    42.766     0.200
     3.166    83.816     0.200
     3.765    97.117     0.200
     4.314   114.516     0.200
     4.983   127.914     0.200
     0.499    19.367     0.200
     1.053    32.160     0.200
     1.065    31.750     0.200
     3.162    82.438     0.200
     3.765    96.340     0.200
     3.765    97.539     0.200
     4.977   133.539     0.200
     9.720   237.863     0.200
     0.388    16.594     0.200
     0.759    24.371     0.200
     1.039    31.273     0.200
     1.137    34.133     0.200
     3.096    82.613     0.200
     3.706    96.711     0.200
     4.905   127.512     0.200
     0.399    16.906     0.200
     0.484    19.625     0.200
     1.034    30.469     0.200
     1.086    33.344     0.200
     3.126    84.125     0.200
     3.730    97.523     0.200
     4.267   110.727     0.200
     4.941   128.922     0.200
     0.399    16.776     0.200
     1.033    31.796     0.200
     1.050    31.326     0.200
     4.207   113.477     0.200
     4.207   112.176     0.200
     4.821   130.477     0.200
    12.198   308.879     0.200
    12.429   312.277     0.200
    14.748   366.777     0.200
    15.067   374.277     0.200
     0.393    16.609     0.200
     0.476    18.695     0.200
     1.052    31.664     0.200
     1.042    31.977     0.200
     3.163    81.758     0.200
     3.763    96.656     0.200
     4.980   130.055     0.200
     0.423    17.320     0.200
     0.396    16.781     0.200
     0.480    19.047     0.200
     1.042    31.617     0.200
     1.485    42.812     0.200
     3.142    85.039     0.200
     3.142    86.734     0.200
     3.744    97.039     0.200
     4.285   113.734     0.200
     4.285   113.438     0.200
     4.957   130.039     0.200
     9.724   241.312     0.200
    11.989   305.289     0.200
     3.176    85.586     0.200
     3.783   100.186     0.200
     4.265   112.286     0.200
     4.986   130.686     0.200
     0.553    20.691     0.200
     1.054    31.410     0.200
     1.155    34.629     0.200
     1.379    40.855     0.200
     3.092    81.980     0.200
     3.705    96.281     0.200
     3.705    96.680     0.200
     4.175   110.680     0.200
     4.175   110.480     0.200
     0.398    16.902     0.200
     0.470    18.445     0.200
     1.049    31.695     0.200
     3.163    85.113     0.200
     3.762    97.812     0.200
     4.981   134.613     0.200
    20.711   510.715     0.200
     0.415    17.246     0.200
     1.064    32.176     0.200
     1.581    46.094     0.200
     3.207    84.043     0.200
     3.800    97.945     0.200
     4.380   115.645     0.200
     5.029   135.543     0.200
     0.402    17.031     0.200
     0.727    23.625     0.200
     1.032    31.719     0.200
     1.085    33.320     0.200
     1.127    33.828     0.200
     3.126    83.789     0.200
     3.729    95.688     0.200
     0.384    16.629     0.200
     0.488    19.039     0.200
     1.053    32.258     0.200
     1.495    44.463     0.200
     7.393   187.480     0.200
     0.476    19.086     0.200
     0.711    25.375     0.200
     1.060    32.688     0.200
     3.176    86.797     0.200
     3.775    99.500     0.200
     4.323   115.195     0.200
     4.994   132.000     0.200
     8.211   210.797     0.200
    11.957   305.234     0.200
    12.600   314.898     0.200
     1.064    32.182     0.200
     1.134    34.022     0.200
     1.399    40.877     0.200
     3.111    85.052     0.200
     3.724    96.352     0.200
     4.193   110.052     0.200
     4.193   111.152     0.200
     4.917   128.852     0.200
     0.017    11.160     0.200
     0.356    14.682     0.200
     0.426    17.990     0.200
     0.679    22.801     0.200
     0.766    26.631     0.200
     0.987    30.801     0.200
     1.052    31.660     0.200
     1.262    39.410     0.200
     1.580    47.775     0.200
     3.198    86.801     0.200
     3.198    88.000     0.200
     3.790    97.801     0.200
     4.381   114.500     0.200
     4.381   117.201     0.200
     5.021   131.701     0.200
     5.021   134.701     0.200
     0.519    20.145     0.200
     0.655    23.527     0.200
     1.068    32.578     0.200
     3.763   100.617     0.200
     4.969   134.418     0.200
     8.151   211.016     0.200
    12.057   306.617     0.200
    14.689   363.617     0.200
     0.701    22.961     0.200
     1.041    30.625     0.200
     1.028    31.250     0.200
     2.859    74.273     0.200
     3.166    83.672     0.200
     3.763    97.375     0.200
     3.763    97.570     0.200
     4.335   113.773     0.200
     0.218    16.367     0.200
     0.188    15.930     0.200
     0.281    18.688     0.200
     0.282    17.438     0.200
     0.431    18.992     0.200
     0.422    19.883     0.200
     0.693    25.391     0.200
     0.878    29.812     0.200
     1.866    52.914     0.200
     2.079    58.469     0.200
     4.718   118.734     0.200
     0.031    11.508     0.200
     0.331    13.656     0.200
     0.425    17.836     0.200
     0.700    23.078     0.200
     0.750    26.055     0.200
     0.887    30.418     0.200
     1.017    31.066     0.200
     1.549    45.930     0.200
     3.172    85.656     0.200
     3.172    86.855     0.200
     3.766    97.355     0.200
     3.766    96.656     0.200
     4.352   114.656     0.200
     4.352   115.555     0.200
     4.994   130.156     0.200
     9.657   237.355     0.200
    12.104   308.156     0.200
     0.375    15.816     0.200
     1.114    33.719     0.200
     3.118    83.387     0.200
     3.726    96.188     0.200
     4.222   114.586     0.200
     4.927   127.988     0.200
     0.500    18.971     0.200
     1.017    31.092     0.200
     3.149    87.402     0.200
     3.735    97.902     0.200
     4.400   118.602     0.200
     4.978   133.102     0.200
     8.293   215.301     0.200
     9.614   238.238     0.200
    10.990   281.902     0.200
    22.754   561.402     0.200
     3.046    83.465     0.200
     4.180   112.165     0.200
     4.855   128.565     0.200
     8.073   207.266     0.200
    12.131   307.565     0.200
    12.449   309.766     0.200
     0.798    27.031     0.200
     0.996    31.172     0.200
     3.178    87.531     0.200
     3.766    99.430     0.200
     4.395   117.633     0.200
     4.395   119.133     0.200
     5.004   132.531     0.200
     6.486   167.836     0.200
     9.214   238.336     0.200
     9.616   235.805     0.200
    21.483   531.430     0.200
     1.050    31.114     0.200
     1.123    33.755     0.200
     1.507    44.564     0.200
     1.507    44.104     0.200
     3.160    85.515     0.200
     3.160    87.414     0.200
     3.760    97.715     0.200
     4.306   113.114     0.200
     4.977   130.515     0.200
     8.194   213.015     0.200
     0.358    14.449     0.200
     1.044    31.180     0.200
     1.595    46.621     0.200
     3.199    86.672     0.200
     3.199    86.871     0.200
     5.024   133.371     0.200
     5.024   134.172     0.200
     0.414    17.277     0.200
     0.451    18.027     0.200
     3.193    86.078     0.200
     3.193    87.977     0.200
     3.787    99.078     0.200
     4.365   117.379     0.200
     5.015   132.277     0.200
     8.253   210.379     0.200
     0.411    17.008     0.200
     3.201    88.559     0.200
     3.795    98.457     0.200
     4.371   117.957     0.200
     4.371   115.957     0.200
     5.023   133.457     0.200
     5.023   135.656     0.200
     0.686    24.120     0.200
     1.084    33.430     0.200
     1.652    48.100     0.200
     1.652    48.030     0.200
     2.219    60.050     0.200
     2.930    77.150     0.200
     3.254    87.750     0.200
     3.841    99.750     0.200
     4.450   120.150     0.200
     5.082   133.950     0.200
     5.082   136.950     0.200
     6.535   172.150     0.200
     7.407   190.452     0.200
     8.337   216.450     0.200
    15.345   379.550     0.200
     0.589    22.145     0.200
     1.065    31.797     0.200
     3.094    83.645     0.200
     3.709    97.145     0.200
     4.161   108.547     0.200
     4.161   109.246     0.200
     4.896   128.145     0.200
     0.154    10.445     0.200
     0.390    16.438     0.200
     0.390    17.168     0.200
     0.408    15.719     0.200
     0.860    28.188     0.200
     1.119    32.336     0.200
     1.188    36.027     0.200
     1.766    49.336     0.200
     1.766    50.297     0.200
     1.767    49.672     0.200
     1.767    49.297     0.200
     2.104    57.438     0.200
     2.104    59.488     0.200
     2.719    73.098     0.200
     3.230    82.695     0.200
     3.230    82.297     0.200
     4.584   119.695     0.200
     4.584   121.695     0.200
     4.590   119.898     0.200
     4.782   123.035     0.200
     6.864   178.098     0.200
     6.740   172.398     0.200
     0.212    15.945     0.200
     0.196    15.906     0.200
     0.272    17.383     0.200
     0.273    18.086     0.200
     0.432    18.633     0.200
     0.431    19.242     0.200
     0.703    25.461     0.200
     0.878    29.664     0.200
     1.169    34.461     0.200
     1.291    39.242     0.200
     1.439    42.016     0.200
     1.874    53.477     0.200
     1.873    52.805     0.200
     2.080    59.094     0.200
     2.731    73.203     0.200
     2.731    74.102     0.200
     3.221    83.203     0.200
     4.598   118.805     0.200
     4.598   122.406     0.200
     0.483    18.992     0.200
     0.682    24.715     0.200
     1.028    31.625     0.200
     1.458    43.469     0.200
     2.125    59.344     0.200
     3.117    86.543     0.200
     3.721    99.043     0.200
     4.932   131.543     0.200
    12.102   308.344     0.200
    15.867   397.645     0.200
     0.482    19.094     0.200
     1.057    31.883     0.200
     0.152    14.594     0.200
     0.254    16.398     0.200
     0.284    18.117     0.200
     0.285    17.383     0.200
     0.374    17.461     0.200
     0.479    21.078     0.200
     0.724    26.641     0.200
     0.816    27.578     0.200
     1.116    33.523     0.200
     1.331    40.273     0.200
     2.214    59.391     0.200
     2.142    58.469     0.200
     2.667    71.492     0.200
     4.534   120.391     0.200
     4.663   122.094     0.200
     4.663   124.188     0.200
     6.821   173.391     0.200
     6.878   177.352     0.200
     8.328   210.992     0.200
     8.575   217.289     0.200
     8.575   220.188     0.200
    12.998   325.391     0.200
    13.434   337.391     0.200
    14.966   366.789     0.200
    19.764   488.688     0.200
     0.383    16.391     0.200
     1.045    31.832     0.200
     1.110    33.891     0.200
     1.433    41.609     0.200
     2.747    75.711     0.200
     2.828    74.312     0.200
     3.116    86.211     0.200
     3.116    83.812     0.200
     4.231   110.609     0.200
     4.927   132.609     0.200
     4.927   128.812     0.200
     6.319   163.711     0.200
     8.120   207.512     0.200
     9.777   239.812     0.200
    10.858   274.812     0.200
    12.083   306.109     0.200
    12.521   310.711     0.200
     0.632    23.172     0.200
     1.063    32.641     0.200
     1.429    40.191     0.200
     2.086    58.941     0.200
     2.842    74.453     0.200
     3.127    85.652     0.200
     4.223   111.250     0.200
     4.935   130.852     0.200
     4.977   130.223     0.200
     1.091    33.355     0.200
     1.445    42.656     0.200
     2.163    56.957     0.200
     2.856    74.055     0.200
     3.143    82.656     0.200
     3.751    96.457     0.200
     4.238   112.758     0.200
     0.513    20.496     0.200
     1.098    33.867     0.200
     2.839    74.547     0.200
     3.128    83.746     0.200
     3.735    98.047     0.200
     0.181    15.340     0.200
     0.257    17.648     0.200
     0.227    16.000     0.200
     0.419    18.391     0.200
     0.861    29.102     0.200
     1.160    34.262     0.200
     1.322    40.480     0.200
     1.518    43.449     0.200
     1.884    53.051     0.200
     1.885    53.051     0.200
     2.098    58.000     0.200
     2.255    59.648     0.200
     2.255    59.852     0.200
     2.441    68.949     0.200
     2.711    73.051     0.200
     3.198    84.148     0.200
     4.578   120.648     0.200
     4.578   120.051     0.200
     4.721   120.281     0.200
     4.697   123.551     0.200
     0.133    14.543     0.200
     0.291    17.352     0.200
     0.274    16.223     0.200
     0.357    16.844     0.200
     0.496    20.684     0.200
     0.732    25.262     0.200
     0.797    27.562     0.200
     1.100    32.973     0.200
     1.352    39.664     0.200
     1.345    41.172     0.200
     1.456    41.824     0.200
     2.193    58.422     0.200
     2.377    67.523     0.200
     2.647    72.324     0.200
     3.135    82.324     0.200
     4.514   119.324     0.200
     0.881    30.426     0.200
     0.914    31.637     0.200
     2.340    62.457     0.200
     2.340    63.457     0.200
     2.685    76.156     0.200
     2.685    74.656     0.200
     3.256    86.156     0.200
     4.265   112.555     0.200
     4.529   123.957     0.200
     1.140    34.246     0.200
     2.145    57.195     0.200
     2.736    76.996     0.200
     2.833    74.195     0.200
     3.111    84.195     0.200
     3.724    97.195     0.200
     4.184   113.598     0.200
     4.184   113.496     0.200
     4.915   129.395     0.200
     0.175    15.514     0.200
     0.232    16.294     0.200
     0.265    17.204     0.200
     0.265    17.774     0.200
     0.407    18.024     0.200
     0.465    20.764     0.200
     0.725    25.884     0.200
     0.850    28.774     0.200
     0.917    30.364     0.200
     1.149    33.634     0.200
     2.109    58.284     0.200
     2.246    59.604     0.200
     2.430    69.204     0.200
     2.701    72.904     0.200
     3.188    83.104     0.200
     3.188    84.504     0.200
     4.567   122.504     0.200
     4.687   125.204     0.200
     4.687   122.704     0.200
     0.179    15.191     0.200
     0.270    18.000     0.200
     0.269    17.621     0.200
     0.227    16.020     0.200
     0.407    18.020     0.200
     0.459    21.062     0.200
     0.719    25.691     0.200
     0.850    28.980     0.200
     1.148    33.812     0.200
     1.316    40.152     0.200
     2.108    59.621     0.200
     2.248    59.332     0.200
     2.430    68.930     0.200
     2.702    72.730     0.200
     2.702    72.832     0.200
     3.190    82.832     0.200
     3.190    83.430     0.200
     4.569   122.531     0.200
     4.569   118.531     0.200
     0.154    14.812     0.200
     0.257    16.562     0.200
     0.306    17.332     0.200
     0.307    17.521     0.200
     0.356    16.832     0.200
     1.096    32.271     0.200
     1.362    39.512     0.200
     2.158    59.231     0.200
     2.203    58.172     0.200
     2.203    58.572     0.200
     2.275    62.972     0.200
     2.275    62.572     0.200
     2.380    67.771     0.200
     2.653    71.872     0.200
     3.145    83.372     0.200
     4.520   118.572     0.200
     4.520   117.972     0.200
     4.641   122.472     0.200
     4.641   120.972     0.200
     4.785   121.012     0.200
    14.567   362.243     0.200
     0.422    17.760     0.200
     0.443    17.680     0.200
     2.161    58.568     0.200
     2.869    75.068     0.200
     3.777    99.068     0.200
     3.777   100.469     0.200
     5.011   132.770     0.200
     0.741    26.250     0.200
     1.429    41.060     0.200
     2.165    57.760     0.200
     2.165    58.060     0.200
     2.223    61.960     0.200
     2.599    71.859     0.200
     2.599    72.359     0.200
     3.104    84.160     0.200
     4.464   118.660     0.200
     4.464   118.160     0.200
     4.551   120.359     0.200
     6.967   183.571     0.200
     0.176    14.912     0.200
     0.262    17.742     0.200
     0.231    16.342     0.200
     0.410    18.041     0.200
     0.465    20.131     0.200
     0.726    25.982     0.200
     0.852    28.893     0.200
     1.151    33.832     0.200
     1.878    52.092     0.200
     2.247    59.592     0.200
     2.324    64.893     0.200
     2.324    64.691     0.200
     2.432    69.092     0.200
     2.703    72.592     0.200
     2.703    73.291     0.200
     4.570   122.092     0.200
     4.570   119.791     0.200
     4.690   124.791     0.200
     0.319    15.672     0.200
     0.357    16.182     0.200
     0.539    20.883     0.200
     0.720    23.861     0.200
     0.926    29.793     0.200
     0.926    29.281     0.200
     0.956    30.021     0.200
     1.078    31.152     0.200
     1.420    39.732     0.200
     1.785    48.842     0.200
     1.927    53.717     0.200
     1.902    52.643     0.200
     2.063    57.742     0.200
     2.286    61.543     0.200
     2.286    62.543     0.200
     4.149   111.543     0.200
     4.149   108.742     0.200
     4.633   118.941     0.200
     0.174    15.570     0.200
     0.231    15.930     0.200
     0.305    17.047     0.200
     0.424    18.781     0.200
     0.668    23.258     0.200
     1.156    34.211     0.200
     1.844    52.312     0.200
     2.285    59.938     0.200
     2.352    64.336     0.200
     2.451    69.641     0.200
     2.729    73.438     0.200
     2.729    73.539     0.200
     4.596   122.641     0.200
     4.596   119.641     0.200
     0.237    16.040     0.200
     0.317    18.250     0.200
     0.316    19.000     0.200
     0.658    23.260     0.200
     1.151    34.320     0.200
     1.251    38.030     0.200
     2.285    60.590     0.200
     2.448    68.490     0.200
     2.728    73.890     0.200
     2.728    74.190     0.200
     4.594   123.090     0.200
     4.594   119.490     0.200
     4.653   120.790     0.200
     0.169    15.605     0.200
     0.237    16.535     0.200
     0.287    17.734     0.200
     0.385    17.855     0.200
     0.711    25.773     0.200
     0.829    28.684     0.200
     1.125    33.434     0.200
     1.315    39.746     0.200
     1.389    40.605     0.200
     1.493    42.816     0.200
     2.230    59.316     0.200
     2.230    59.516     0.200
     2.303    63.516     0.200
     2.409    68.816     0.200
     2.681    71.914     0.200
     2.681    72.016     0.200
     4.548   120.016     0.200
     4.548   118.914     0.200
     4.663   122.113     0.200
     4.663   123.516     0.200
     0.612    22.516     0.200
     0.677    22.578     0.200
     1.068    32.883     0.200
     1.458    43.562     0.200
     2.843    78.703     0.200
     2.895    75.406     0.200
     3.179    87.805     0.200
     3.179    84.805     0.200
     4.242   113.805     0.200
     4.242   111.805     0.200
     4.985   130.203     0.200
    12.016   304.102     0.200
     0.079    11.547     0.200
     0.320    13.727     0.200
     0.389    16.277     0.200
     0.484    19.738     0.200
     0.707    23.258     0.200
     0.692    24.508     0.200
     0.829    28.828     0.200
     1.051    31.129     0.200
     1.056    32.027     0.200
     1.054    34.828     0.200
     1.311    38.977     0.200
     2.156    56.699     0.200
     2.813    76.199     0.200
     2.855    73.598     0.200
     3.153    87.000     0.200
     3.153    84.000     0.200
     4.292   111.797     0.200
     4.292   114.297     0.200
     0.121    14.790     0.200
     0.361    17.330     0.200
     0.278    17.930     0.200
     0.509    21.460     0.200
     0.798    27.970     0.200
     1.106    33.100     0.200
     1.349    40.060     0.200
     1.360    40.340     0.200
     1.452    41.230     0.200
     2.189    58.830     0.200
     2.646    69.030     0.200
     0.189    15.227     0.200
     0.182    14.537     0.200
     0.540    22.156     0.200
     0.885    28.377     0.200
     1.072    33.346     0.200
     1.176    35.436     0.200
     1.783    50.686     0.200
     1.784    50.736     0.200
     1.913    51.436     0.200
     2.117    61.037     0.200
     2.374    66.236     0.200
     2.374    63.936     0.200
     4.241   114.436     0.200
     4.344   113.936     0.200
     0.369    16.688     0.200
     0.377    16.641     0.200
     0.511    20.203     0.200
     0.902    27.883     0.200
     1.579    45.547     0.200
     1.734    47.062     0.200
     1.924    53.820     0.200
     1.926    54.711     0.200
     2.019    57.266     0.200
     2.239    60.867     0.200
     4.100   110.367     0.200
     4.100   106.961     0.200
     4.202   109.766     0.200
     4.617   118.867     0.200
     4.617   118.766     0.200
     0.161    15.887     0.200
     0.244    16.406     0.200
     0.438    19.219     0.200
     0.888    29.957     0.200
     1.849    51.027     0.200
     2.300    60.078     0.200
     2.300    61.477     0.200
     2.465    69.977     0.200
     2.744    74.078     0.200
     2.744    73.477     0.200
     4.610   120.977     0.200
     4.610   119.977     0.200
     0.132    15.684     0.200
     0.269    18.352     0.200
     0.378    18.953     0.200
     0.557    20.922     0.200
     0.703    25.223     0.200
     1.005    31.965     0.200
     1.242    38.223     0.200
     1.394    40.754     0.200
     1.670    45.953     0.200
     1.939    55.402     0.200
     1.952    54.012     0.200
     2.407    63.953     0.200
     2.584    71.754     0.200
     2.860    75.754     0.200
     4.726   125.555     0.200
     0.351    18.682     0.200
     0.472    20.742     0.200
     0.570    22.501     0.200
     0.630    23.151     0.200
     0.690    24.321     0.200
     0.803    26.932     0.200
     0.972    30.531     0.200
     1.030    31.122     0.200
     1.305    37.401     0.200
     1.302    39.792     0.200
     1.312    37.671     0.200
     1.416    42.392     0.200
     1.458    43.021     0.200
     1.606    46.301     0.200
     1.669    49.932     0.200
     1.807    50.801     0.200
     1.849    49.722     0.200
     1.851    50.827     0.200
     1.851    49.702     0.200
     3.022    80.501     0.200
     3.667    97.801     0.200
     4.390   113.202     0.200
     4.390   115.501     0.200
     6.565   168.401     0.200
     8.852   222.202     0.200
    10.770   273.602     0.200
    13.552   343.196     0.200
    17.500   435.401     0.200
    21.182   518.401     0.200
     0.104    12.562     0.200
     0.434    17.062     0.200
     0.597    21.504     0.200
     1.079    33.273     0.200
     1.215    35.145     0.200
     1.243    37.332     0.200
     1.810    50.152     0.200
     1.899    52.930     0.200
     1.898    52.922     0.200
     2.547    66.254     0.200
     2.682    75.352     0.200
     2.976    79.652     0.200
     2.976    79.254     0.200
     4.737   123.254     0.200
     4.840   128.453     0.200
     4.840   125.352     0.200
     8.649   224.152     0.200
    12.303   312.207     0.200
     0.143    15.545     0.200
     0.200    15.654     0.200
     0.637    23.795     0.200
     0.944    30.104     0.200
     1.308    38.443     0.200
     1.752    50.094     0.200
     2.045    55.045     0.200
     2.045    55.443     0.200
     2.217    64.344     0.200
     2.489    67.744     0.200
     2.489    67.443     0.200
     4.356   116.244     0.200
     4.356   113.443     0.200
     4.536   119.645     0.200
     4.536   118.744     0.200
     7.057   183.955     0.200
     8.445   218.744     0.200
    12.802   323.662     0.200
     0.608    22.535     0.200
     1.691    47.660     0.200
     1.690    46.855     0.200
     1.979    55.598     0.200
     2.517    67.035     0.200
     2.587    74.438     0.200
     2.905    80.137     0.200
     2.905    79.637     0.200
     4.531   118.137     0.200
     4.760   127.336     0.200
     4.760   125.938     0.200
     8.441   220.836     0.200
     9.544   235.262     0.200
     9.667   251.035     0.200
    11.388   288.938     0.200
    13.048   329.738     0.200
    16.256   405.438     0.200
     0.063    15.100     0.200
     0.338    18.840     0.200
     0.695    23.920     0.200
     0.733    26.069     0.200
     0.916    31.029     0.200
     1.070    32.560     0.200
     1.121    34.109     0.200
     1.124    37.170     0.200
     1.148    35.409     0.200
     1.374    41.595     0.200
     1.374    41.949     0.200
     2.491    64.520     0.200
     2.808    76.420     0.200
     4.213   110.319     0.200
     4.213   110.619     0.200
     4.639   125.020     0.200
     4.639   122.220     0.200
     0.161    14.875     0.200
     0.254    16.934     0.200
     0.349    17.227     0.200
     0.318    17.906     0.200
     0.319    18.766     0.200
     0.467    21.137     0.200
     0.795    27.844     0.200
     1.088    32.863     0.200
     1.464    41.926     0.200
     2.202    58.727     0.200
     2.374    67.926     0.200
     2.649    71.227     0.200
     2.649    71.426     0.200
     4.515   120.523     0.200
     4.515   117.227     0.200
     4.629   120.625     0.200
     4.629   121.625     0.200
     6.903   177.324     0.200
     8.541   220.426     0.200
    13.079   319.926     0.200
     0.186    15.430     0.200
     0.239    17.047     0.200
     2.266    59.867     0.200
     2.266    59.469     0.200
     2.456    68.570     0.200
     2.725    73.867     0.200
     2.725    72.172     0.200
     4.592   122.469     0.200
     0.135    13.652     0.200
     0.471    17.172     0.200
     0.515    19.152     0.200
     1.000    30.801     0.200
     1.761    48.312     0.200
     1.954    55.102     0.200
     2.494    65.609     0.200
     2.494    66.211     0.200
     2.594    74.312     0.200
     2.900    78.609     0.200
     2.900    79.012     0.200
     4.260   112.711     0.200
     4.603   121.812     0.200
     4.761   126.812     0.200
     4.761   124.812     0.200
     9.487   232.461     0.200
    11.470   289.012     0.200
    15.141   371.812     0.200
     0.154    16.023     0.200
     0.254    16.828     0.200
     0.329    18.844     0.200
     0.328    19.672     0.200
     0.428    18.992     0.200
     0.642    24.492     0.200
     0.879    29.805     0.200
     1.155    34.367     0.200
     1.233    38.523     0.200
     1.456    41.898     0.200
     1.560    43.398     0.200
     1.826    48.672     0.200
     2.297    61.195     0.200
     2.737    72.195     0.200
     4.647   121.695     0.200
     0.198    15.422     0.200
     0.209    16.305     0.200
     0.297    18.117     0.200
     0.400    18.312     0.200
     0.434    21.102     0.200
     0.689    25.797     0.200
     0.847    29.102     0.200
     1.136    34.203     0.200
     1.289    39.766     0.200
     1.412    41.336     0.200
     1.516    43.406     0.200
     2.110    58.672     0.200
     2.253    59.305     0.200
     2.253    58.602     0.200
     2.426    69.203     0.200
     2.701    72.508     0.200
     2.701    73.305     0.200
     4.568   122.406     0.200
     4.568   117.805     0.200
     4.660   123.102     0.200
     6.853   179.195     0.200
    13.130   320.805     0.200
    13.399   338.305     0.200
    14.994   369.305     0.200
    16.600   413.805     0.200
     0.667    22.516     0.200
     1.820    49.906     0.200
     2.543    66.906     0.200
     2.911    79.707     0.200
     2.911    78.406     0.200
     4.456   118.309     0.200
     4.456   119.406     0.200
     4.760   128.406     0.200
     0.216    15.693     0.200
     0.695    25.434     0.200
     0.878    29.324     0.200
     1.168    33.982     0.200
     1.869    51.389     0.200
     2.282    60.264     0.200
     2.282    60.062     0.200
     2.457    69.963     0.200
     2.732    74.363     0.200
     4.599   122.764     0.200
     4.599   120.863     0.200
     4.685   124.264     0.200
     0.156    16.002     0.200
     0.249    16.553     0.200
     0.306    17.861     0.200
     0.307    17.783     0.200
     0.442    18.963     0.200
     0.662    23.803     0.200
     0.841    28.283     0.200
     1.172    34.623     0.200
     1.247    38.043     0.200
     1.334    39.521     0.200
     1.567    44.672     0.200
     2.066    57.182     0.200
     2.304    61.572     0.200
     2.304    60.873     0.200
     2.469    70.373     0.200
     2.748    73.672     0.200
     2.748    74.172     0.200
     4.614   123.672     0.200
     4.670   122.072     0.200
     4.670   121.271     0.200
     6.814   175.213     0.200
    12.343   304.973     0.200
    21.305   526.072     0.200
     0.142    15.043     0.200
     0.347    17.293     0.200
     0.306    18.363     0.200
     0.487    21.352     0.200
     0.718    24.773     0.200
     0.790    27.922     0.200
     1.089    32.633     0.200
     1.351    40.562     0.200
     1.350    40.254     0.200
     1.454    42.133     0.200
     2.191    57.934     0.200
     2.191    58.934     0.200
     2.370    65.531     0.200
     2.642    71.934     0.200
     4.509   119.531     0.200
     4.509   118.434     0.200
     4.640   122.332     0.200
     0.228    16.371     0.200
     0.291    18.602     0.200
     0.433    19.172     0.200
     0.411    20.773     0.200
     0.681    25.434     0.200
     0.881    29.934     0.200
     1.270    39.352     0.200
     1.447    42.242     0.200
     1.551    44.344     0.200
     1.859    51.832     0.200
     1.858    51.832     0.200
     2.289    61.141     0.200
     2.736    73.543     0.200
     4.602   119.641     0.200
     4.677   121.141     0.200
     0.208    15.984     0.200
     0.284    16.383     0.200
     0.543    20.656     0.200
     0.758    26.539     0.200
     0.984    32.414     0.200
     1.078    32.586     0.200
     1.633    45.883     0.200
     1.972    57.406     0.200
     1.971    55.742     0.200
     1.976    55.602     0.200
     2.370    62.281     0.200
     2.370    61.984     0.200
     2.565    70.883     0.200
     2.565    68.984     0.200
     3.313    87.180     0.200
     4.700   123.984     0.200
     4.700   121.781     0.200
     4.794   125.586     0.200
     4.794   125.781     0.200
    11.768   294.883     0.200
    12.437   308.281     0.200
    12.511   317.055     0.200
     0.245    16.598     0.200
     0.319    19.199     0.200
     0.388    20.477     0.200
     0.427    19.188     0.200
     0.877    29.836     0.200
     0.937    29.598     0.200
     1.451    42.039     0.200
     1.555    44.496     0.200
     1.834    49.699     0.200
     2.292    60.199     0.200
     2.454    67.598     0.200
     2.734    72.598     0.200
     3.233    84.699     0.200
     4.600   122.199     0.200
     4.654   121.297     0.200
     0.216    16.395     0.200
     0.413    20.145     0.200
     0.322    19.223     0.200
     0.394    18.605     0.200
     0.663    24.305     0.200
     0.844    28.953     0.200
     1.126    33.484     0.200
     1.265    37.984     0.200
     1.416    41.785     0.200
     1.521    43.766     0.200
     1.823    50.039     0.200
     1.822    51.324     0.200
     1.822    51.781     0.200
     1.822    50.043     0.200
     2.113    58.285     0.200
     2.113    58.594     0.200
     2.421    68.266     0.200
     2.700    73.363     0.200
     2.700    72.863     0.200
     4.567   121.164     0.200
     4.639   120.164     0.200
     4.639   120.266     0.200
    10.950   277.266     0.200
    11.743   294.766     0.200
    12.594   316.648     0.200
     0.325    17.438     0.200
     0.376    18.961     0.200
     0.551    21.027     0.200
     0.699    25.098     0.200
     1.000    32.230     0.200
     1.051    31.949     0.200
     1.240    37.758     0.200
     1.394    40.449     0.200
     1.665    45.949     0.200
     1.934    53.926     0.200
     2.403    62.750     0.200
     2.578    71.750     0.200
     2.578    69.648     0.200
     2.854    76.449     0.200
     2.854    76.750     0.200
     4.721   126.551     0.200
     4.721   123.750     0.200
     4.761   123.148     0.200
     4.761   124.148     0.200
     0.288    18.217     0.200
     0.330    18.127     0.200
     0.378    21.297     0.200
     0.557    23.527     0.200
     0.779    27.887     0.200
     0.788    26.998     0.200
     1.028    32.547     0.200
     1.381    40.178     0.200
     1.488    42.197     0.200
     1.688    46.697     0.200
     1.687    46.707     0.200
     2.192    59.498     0.200
     2.343    67.098     0.200
     2.343    65.197     0.200
     2.637    71.697     0.200
     2.637    71.898     0.200
     4.505   118.098     0.200
     4.505   118.598     0.200
     4.501   120.697     0.200
     4.501   120.498     0.200
    10.351   263.797     0.200
    16.569   411.398     0.200
    21.151   521.697     0.200
     0.581    20.707     0.200
     0.632    21.789     0.200
     0.915    28.508     0.200
     1.793    50.008     0.200
     2.524    66.609     0.200
     2.524    67.309     0.200
     2.604    72.410     0.200
     2.604    70.707     0.200
     2.918    80.207     0.200
     2.918    78.707     0.200
     3.456    91.207     0.200
     4.563   120.609     0.200
     4.775   129.008     0.200
     4.775   124.910     0.200
    15.142   372.910     0.200
     0.163    15.086     0.200
     0.361    17.453     0.200
     0.309    17.812     0.200
     0.465    19.977     0.200
     0.702    26.023     0.200
     0.806    28.016     0.200
     1.100    32.844     0.200
     2.151    58.617     0.200
     2.211    58.922     0.200
     2.211    58.328     0.200
     2.385    66.125     0.200
     2.659    72.422     0.200
     2.659    70.328     0.200
     4.526   120.227     0.200
     4.526   117.023     0.200
     4.640   122.125     0.200
     4.640   121.227     0.200
     6.892   176.688     0.200
     6.892   177.414     0.200
     8.053   203.148     0.200
     8.313   208.852     0.200
     8.414   211.688     0.200
     8.552   221.227     0.200
    11.792   297.922     0.200
    13.412   335.023     0.200
    14.954   370.625     0.200
    16.638   412.727     0.200
    19.635   483.273     0.200
     0.084    11.084     0.200
     0.684    22.385     0.200
     0.752    25.674     0.200
     1.007    31.523     0.200
     1.085    35.725     0.200
     1.314    37.533     0.200
     1.755    47.965     0.200
     2.273    62.295     0.200
     2.403    68.064     0.200
     2.452    63.863     0.200
     2.452    64.064     0.200
     2.759    75.664     0.200
     2.759    77.064     0.200
     4.189   107.238     0.200
     4.586   124.465     0.200
     9.899   243.064     0.200
     0.710    25.441     0.200
     0.719    24.012     0.200
     2.536    67.762     0.200
     2.861    81.262     0.200
     4.266   114.363     0.200
     4.695   128.160     0.200
     0.272    17.610     0.200
     1.868    52.284     0.200
     2.117    58.091     0.200
     0.808    28.619     0.200
     1.972    54.340     0.200
     4.623   117.448     0.200
     9.919   241.094     0.200
    13.383   336.554     0.200
     0.515    22.078     0.200
     1.756    48.035     0.200
     1.966    56.758     0.200
     0.316    18.078     0.200
     2.163    59.781     0.200
     0.273    17.783     0.200
     1.869    49.744     0.200
     2.113    58.139     0.200
     2.113    59.293     0.200
     4.714   120.725     0.200
     5.610   142.150     0.200
     8.012   205.766     0.200
     8.310   209.572     0.200
     9.504   231.721     0.200
    10.519   264.979     0.200
    13.428   335.883     0.200
    14.487   360.383     0.200
    14.614   364.023     0.200
    17.733   436.859     0.200
    17.965   441.629     0.200
     0.303    17.949     0.200
     2.099    58.168     0.200
     4.693   121.965     0.200
    12.588   318.637     0.200
    22.223   548.289     0.200
     1.459    45.805     0.200
     2.525    72.711     0.200
     4.271   116.141     0.200
     0.298    18.110     0.200
     0.298    16.843     0.200
     1.842    49.863     0.200
     2.147    59.356     0.200
     2.147    59.053     0.200
     2.147    58.753     0.200
     4.651   123.922     0.200
     6.885   180.109     0.200
     6.885   178.181     0.200
     8.047   203.784     0.200
     8.408   215.088     0.200
     9.538   231.751     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.471    18.790     0.200
     0.791    26.790     0.200
     1.556    50.790     0.200
     0.253    11.703     0.200
     0.769    26.703     0.200
     1.498    48.703     0.200
     3.345    97.703     0.200
     0.452    17.492     0.200
     0.816    26.492     0.200
     1.350    43.289     0.200
     1.602    51.492     0.200
     4.765   140.492     0.200
     0.529    19.859     0.200
     0.869    29.859     0.200
     1.532    45.859     0.200
     2.209    64.859     0.200
     0.678    21.340     0.200
     1.023    33.441     0.200
     1.061    34.840     0.200
     1.271    40.441     0.200
     1.924    56.641     0.200
     2.298    68.840     0.200
     3.456   100.840     0.200
     1.547    52.995     0.200
     1.809    57.195     0.200
     3.136    92.995     0.200
     0.935    30.758     0.200
     1.565    50.859     0.200
     1.698    51.359     0.200
     2.033    60.656     0.200
     2.271    68.359     0.200
     0.925    31.551     0.200
     1.938    57.650     0.200
     2.266    67.851     0.200
     2.529    77.851     0.200
     3.074    89.150     0.200
     1.473    45.374     0.200
     1.574    50.374     0.200
     1.464    44.739     0.200
     1.552    50.539     0.200
     1.888    55.539     0.200
     2.132    64.239     0.200
     0.880    29.322     0.200
     1.619    50.021     0.200
     1.544    48.121     0.200
     0.882    29.428     0.200
     1.518    47.729     0.200
     1.597    50.746     0.200
     1.482    44.645     0.200
     0.832    27.031     0.200
     0.871    29.234     0.200
     1.586    47.836     0.200
     1.556    46.836     0.200
     1.608    51.184     0.200
     1.813    54.984     0.200
     2.180    64.883     0.200
     3.258    94.984     0.200
     1.520    48.332     0.200
     1.866    56.332     0.200
     0.843    28.562     0.200
     1.962    58.961     0.200
     0.962    32.119     0.200
     1.656    52.119     0.200
     1.976    59.119     0.200
     1.226    38.281     0.200
     1.563    51.480     0.200
     1.570    48.680     0.200
     1.792    53.281     0.200
     1.567    50.227     0.200
     3.149    91.023     0.200
     0.929    31.268     0.200
     1.635    51.668     0.200
     1.606    49.668     0.200
     1.814    54.357     0.200
     3.105    89.758     0.200
     0.937    31.893     0.200
     1.186    36.592     0.200
     1.582    49.191     0.200
     1.724    51.293     0.200
     1.972    59.092     0.200
     1.234    39.035     0.200
     1.499    46.635     0.200
     1.490    46.707     0.200
     1.426    44.207     0.200
     3.374    98.406     0.200
     0.851    28.132     0.200
     1.470    44.231     0.200
     1.652    53.231     0.200
     2.183    64.231     0.200
     3.144    90.932     0.200
     0.851    29.334     0.200
     1.448    47.133     0.200
     1.491    48.879     0.200
     1.414    44.277     0.200
     1.389    47.250     0.200
     1.570    48.449     0.200
     1.956    60.148     0.200
     2.476    73.449     0.200
     3.263    95.449     0.200
     4.723   137.949     0.200
     0.833    27.484     0.200
     1.572    49.184     0.200
     1.511    46.184     0.200
     1.154    35.438     0.200
     1.565    47.141     0.200
     1.945    57.539     0.200
     1.076    35.572     0.200
     1.841    55.271     0.200
     1.286    38.786     0.200
     1.596    50.286     0.200
     1.976    58.786     0.200
     2.264    66.586     0.200
     0.906    30.086     0.200
     1.545    46.387     0.200
     1.813    54.586     0.200
     0.960    31.484     0.200
     1.625    50.684     0.200
     1.658    52.883     0.200
     1.893    56.484     0.200
     1.974    58.785     0.200
     0.879    28.977     0.200
     0.801    26.734     0.200
     0.372    14.380     0.200
     1.091    34.681     0.200
     0.169     9.332     0.200
     1.399    43.732     0.200
     0.211    11.328     0.200
     0.814    27.227     0.200
     1.460    43.727     0.200
     0.670    22.262     0.200
     0.911    29.363     0.200
     1.028    35.465     0.200
     1.256    40.762     0.200
     1.299    40.664     0.200
     1.287    42.965     0.200
     1.376    43.664     0.200
     1.452    45.164     0.200
     1.410    44.965     0.200
     1.625    49.863     0.200
     1.831    55.465     0.200
     1.848    55.664     0.200
     0.503    19.137     0.200
     0.673    22.336     0.200
     0.911    29.637     0.200
     1.257    41.035     0.200
     1.289    41.738     0.200
     1.379    44.137     0.200
     1.413    44.238     0.200
     1.471    46.238     0.200
     1.627    50.535     0.200
     0.230    11.773     0.200
     0.441    17.273     0.200
     0.655    23.477     0.200
     0.743    26.172     0.200
     1.073    34.375     0.200
     1.111    35.375     0.200
     1.364    42.375     0.200
     1.483    45.773     0.200
     1.670    51.375     0.200
     1.786    53.070     0.200
     0.020     9.738     0.200
     0.410    15.141     0.200
     0.623    21.438     0.200
     0.929    29.238     0.200
     1.075    33.141     0.200
     1.835    54.141     0.200
     1.136    35.805     0.200
     1.191    37.105     0.200
     1.388    43.005     0.200
     1.705    52.305     0.200
     1.846    54.905     0.200
     1.890    58.305     0.200
     2.517    73.405     0.200
     0.263    11.273     0.200
     0.264    12.172     0.200
     0.692    22.172     0.200
     0.753    23.672     0.200
     1.130    35.473     0.200
     1.427    43.773     0.200
     1.424    45.371     0.200
     1.720    52.273     0.200
     1.755    52.773     0.200
     0.260    13.249     0.200
     0.281    13.349     0.200
     0.697    23.849     0.200
     0.700    22.949     0.200
     1.110    34.548     0.200
     1.376    42.749     0.200
     0.199    10.438     0.200
     1.095    34.938     0.200
     1.203    36.938     0.200
     1.670    49.539     0.200
     0.247    11.775     0.200
     0.636    21.275     0.200
     0.698    22.675     0.200
     0.877    29.475     0.200
     1.060    32.975     0.200
     0.737    24.211     0.200
     1.189    37.012     0.200
     1.953    57.512     0.200
     0.373    14.711     0.200
     0.629    21.410     0.200
     0.732    24.609     0.200
     0.908    29.910     0.200
     1.059    33.312     0.200
     1.685    50.859     0.200
     0.071     8.963     0.200
     0.549    18.562     0.200
     0.706    23.136     0.200
     0.992    31.436     0.200
     0.121     9.289     0.200
     0.999    32.492     0.200
     0.088     7.995     0.200
     0.404    15.095     0.200
     0.690    22.585     0.200
     2.288    66.895     0.200
     0.200     7.719     0.200
     0.757    25.973     0.200
     0.148     7.209     0.200
     0.851    28.922     0.200
     0.663    23.170     0.200
     0.776    25.270     0.200
     0.096     9.510     0.200
     0.371    16.120     0.200
     0.898    29.010     0.200
     1.150    36.510     0.200
     0.078     9.508     0.200
     0.372    16.008     0.200
     0.594    20.109     0.200
     0.754    25.109     0.200
     0.805    26.906     0.200
     0.916    28.906     0.200
     1.177    37.309     0.200
     1.626    49.609     0.200
     0.310    13.602     0.200
     0.367    14.840     0.200
     0.585    21.422     0.200
     0.690    22.879     0.200
     0.760    27.480     0.200
     1.163    36.609     0.200
     1.428    43.789     0.200
     0.185    10.549     0.200
     0.390    14.459     0.200
     1.086    33.799     0.200
     1.431    43.250     0.200
     0.067    10.367     0.200
     0.398    16.168     0.200
     0.706    23.328     0.200
     0.010     9.273     0.200
     0.353    13.398     0.200
     0.410    16.961     0.200
     0.745    25.961     0.200
     0.899    30.883     0.200
     0.997    31.328     0.200
     1.563    47.352     0.200
     0.086     9.922     0.200
     0.432    15.000     0.200
     0.802    27.562     0.200
     0.994    33.070     0.200
     0.191    12.883     0.200
     0.315    13.188     0.200
     0.360    16.031     0.200
     0.595    20.680     0.200
     0.599    22.203     0.200
     0.722    25.523     0.200
     0.748    24.773     0.200
     0.804    27.070     0.200
     0.942    31.820     0.200
     1.213    37.781     0.200
     0.110    10.953     0.200
     0.291    13.180     0.200
     0.403    16.508     0.200
     0.685    24.328     0.200
     0.738    24.172     0.200
     1.034    34.047     0.200
     0.079    10.688     0.200
     0.339    13.625     0.200
     0.688    23.117     0.200
     0.680    24.258     0.200
     0.749    24.797     0.200
     0.833    29.367     0.200
     0.064    10.469     0.200
     0.320    13.195     0.200
     0.706    23.469     0.200
     0.709    25.234     0.200
     1.508    46.039     0.200
     0.076    10.266     0.200
     0.311    12.750     0.200
     0.663    22.375     0.200
     0.715    23.586     0.200
     0.704    25.273     0.200
     0.046    10.102     0.200
     0.324    13.234     0.200
     0.703    23.297     0.200
     0.728    25.461     0.200
     0.865    29.578     0.200
     1.032    32.391     0.200
     1.102    34.586     0.200
     1.093    36.438     0.200
     1.528    45.828     0.200
     0.012    10.594     0.200
     0.365    14.602     0.200
     0.418    17.367     0.200
     0.670    22.844     0.200
     0.761    26.391     0.200
     0.980    30.711     0.200
     1.253    39.219     0.200
     0.186    12.430     0.200
     0.303    12.898     0.200
     0.372    15.906     0.200
     0.611    22.180     0.200
     0.755    24.820     0.200
     0.725    25.492     0.200
     0.951    31.602     0.200
     1.213    36.992     0.200
     1.391    42.484     0.200
     0.010    10.703     0.200
     0.357    14.109     0.200
     0.447    18.258     0.200
     0.419    17.703     0.200
     0.677    22.766     0.200
     0.758    26.383     0.200
     0.912    31.273     0.200
     0.989    30.859     0.200
     1.090    33.555     0.200
     1.135    36.930     0.200
     1.261    39.438     0.200
     0.308    12.820     0.200
     0.606    22.500     0.200
     0.752    24.922     0.200
     0.723    25.844     0.200
     0.947    32.375     0.200
     1.197    37.344     0.200
     1.213    36.930     0.200
     1.389    41.820     0.200
     1.389    42.125     0.200
     1.390    42.133     0.200
     0.076    10.709     0.200
     0.326    13.469     0.200
     0.384    16.449     0.200
     0.487    18.759     0.200
     0.671    22.539     0.200
     0.691    24.719     0.200
     0.700    23.279     0.200
     0.834    28.879     0.200
     1.056    34.839     0.200
     1.134    35.209     0.200
     1.498    45.579     0.200
     0.081    10.667     0.200
     0.343    13.647     0.200
     0.365    16.348     0.200
     0.685    22.718     0.200
     0.676    24.308     0.200
     0.833    28.658     0.200
     1.048    33.547     0.200
     1.499    45.643     0.200
     0.017     9.429     0.200
     0.371    14.709     0.200
     0.664    22.229     0.200
     0.763    26.559     0.200
     0.926    31.568     0.200
     0.973    30.729     0.200
     1.145    36.368     0.200
     1.247    39.419     0.200
     1.589    47.533     0.200
     0.028     9.307     0.200
     0.379    14.916     0.200
     0.696    23.547     0.200
     0.659    22.207     0.200
     0.772    26.936     0.200
     0.963    30.326     0.200
     0.937    31.986     0.200
     1.156    36.816     0.200
     1.240    38.877     0.200
     1.600    47.627     0.200
     0.171    12.014     0.200
     0.312    13.104     0.200
     0.364    16.014     0.200
     0.546    21.395     0.200
     0.616    22.564     0.200
     0.741    26.264     0.200
     0.740    24.264     0.200
     0.790    25.955     0.200
     0.963    32.775     0.200
     1.230    37.654     0.200
     1.407    42.215     0.200
     0.074    10.385     0.200
     0.327    13.254     0.200
     0.699    23.084     0.200
     0.692    24.424     0.200
     0.835    29.375     0.200
     1.500    46.344     0.200
     0.008     9.508     0.200
     0.367    14.031     0.200
     0.666    22.609     0.200
     0.703    23.859     0.200
     0.739    25.141     0.200
     0.755    26.352     0.200
     0.980    31.070     0.200
     0.916    31.766     0.200
     1.580    47.781     0.200
     0.109    10.672     0.200
     0.321    13.039     0.200
     0.710    23.609     0.200
     0.756    25.047     0.200
     0.662    23.695     0.200
     0.802    27.680     0.200
     1.467    45.242     0.200
     0.014    10.516     0.200
     0.446    17.719     0.200
     0.420    17.633     0.200
     0.672    23.047     0.200
     0.695    23.227     0.200
     0.739    24.766     0.200
     0.763    26.422     0.200
     0.981    30.656     0.200
     0.920    31.531     0.200
     1.254    39.227     0.200
     0.102    10.657     0.200
     0.316    13.367     0.200
     0.650    22.356     0.200
     0.672    24.227     0.200
     0.807    28.457     0.200
     1.031    34.146     0.200
     1.146    36.356     0.200
     1.472    44.657     0.200
     0.130    11.535     0.200
     0.291    12.715     0.200
     0.394    16.754     0.200
     0.498    19.766     0.200
     0.665    23.992     0.200
     0.742    24.203     0.200
     0.779    27.613     0.200
     1.011    33.426     0.200
     1.260    38.754     0.200
     0.057    10.336     0.200
     0.329    13.105     0.200
     0.722    24.227     0.200
     0.697    23.195     0.200
     0.708    25.324     0.200
     0.851    29.316     0.200
     0.084    10.398     0.200
     0.331    13.379     0.200
     0.374    16.590     0.200
     0.697    23.070     0.200
     0.747    24.930     0.200
     0.679    24.340     0.200
     0.826    28.520     0.200
     1.046    34.078     0.200
     1.492    45.113     0.200
     0.168    11.812     0.200
     0.288    12.281     0.200
     0.524    20.652     0.200
     0.592    20.391     0.200
     0.636    23.012     0.200
     0.741    26.484     0.200
     0.767    25.391     0.200
     0.973    32.973     0.200
     1.225    37.723     0.200
     1.405    42.137     0.200
     0.107    10.414     0.200
     0.297    12.234     0.200
     0.730    24.727     0.200
     0.683    24.297     0.200
     0.732    23.984     0.200
     0.803    28.023     0.200
     1.466    45.195     0.200
     0.051    10.356     0.200
     0.329    13.396     0.200
     0.697    23.106     0.200
     0.716    25.246     0.200
     0.858    29.636     0.200
     1.083    35.546     0.200
     0.209    11.938     0.200
     0.738    26.516     0.200
     1.014    33.098     0.200
     0.062    10.203     0.200
     0.327    13.180     0.200
     0.704    24.953     0.200
     0.699    23.258     0.200
     0.846    29.594     0.200
     1.510    45.055     0.200
     0.029     9.203     0.200
     0.378    15.062     0.200
     0.661    22.172     0.200
     0.757    24.859     0.200
     0.774    26.914     0.200
     0.963    30.414     0.200
     0.938    31.812     0.200
     1.157    37.703     0.200
     1.241    39.219     0.200
     1.601    48.727     0.200
     0.088    10.344     0.200
     0.309    12.906     0.200
     0.728    24.695     0.200
     0.692    24.438     0.200
     0.718    23.789     0.200
     0.821    28.617     0.200
     1.067    33.008     0.200
     0.114     7.025     0.200
     0.338    13.976     0.200
     0.680    22.836     0.200
     1.476    46.286     0.200
     0.197    12.332     0.200
     0.300    12.660     0.200
     0.376    15.652     0.200
     0.580    21.102     0.200
     0.606    22.332     0.200
     0.764    24.840     0.200
     1.202    37.180     0.200
     0.057    10.273     0.200
     0.326    13.004     0.200
     0.700    23.445     0.200
     0.711    25.133     0.200
     0.852    29.414     0.200
     1.039    32.504     0.200
     1.077    35.504     0.200
     1.515    46.090     0.200
     0.009     9.566     0.200
     0.365    14.496     0.200
     0.669    22.516     0.200
     0.758    26.305     0.200
     0.917    31.453     0.200
     0.981    30.953     0.200
     1.138    37.293     0.200
     0.104    10.609     0.200
     0.295    12.234     0.200
     0.687    24.391     0.200
     0.733    24.320     0.200
     1.038    33.688     0.200
     1.468    44.586     0.200
     0.078    10.559     0.200
     0.325    12.969     0.200
     0.702    23.268     0.200
     0.689    24.508     0.200
     0.831    28.969     0.200
     1.054    34.699     0.200
     0.048     9.047     0.200
     0.339    13.648     0.200
     0.391    16.398     0.200
     0.687    22.766     0.200
     1.026    32.266     0.200
     1.525    46.219     0.200
     0.179    12.232     0.200
     0.312    12.972     0.200
     0.363    15.802     0.200
     0.551    21.582     0.200
     0.610    22.502     0.200
     0.733    26.052     0.200
     0.744    24.372     0.200
     0.794    26.512     0.200
     0.955    32.362     0.200
     1.223    37.792     0.200
     0.360    14.465     0.200
     0.805    28.957     0.200
     1.073    34.816     0.200
     1.299    39.598     0.200
     0.041    10.570     0.200
     0.326    13.875     0.200
     0.452    18.094     0.200
     0.414    17.156     0.200
     0.692    23.625     0.200
     0.733    25.711     0.200
     0.871    29.820     0.200
     1.533    45.945     0.200
     0.305    12.637     0.200
     0.638    23.098     0.200
     0.738    24.098     0.200
     0.770    25.547     0.200
     1.246    37.977     0.200
     1.426    42.938     0.200
     0.091    10.832     0.200
     0.825    28.041     0.200
     1.586    47.402     0.200
     0.201    12.105     0.200
     0.506    20.525     0.200
     0.654    23.165     0.200
     1.373    42.690     0.200
     0.053     9.062     0.200
     0.727    22.844     0.200
     0.708    22.820     0.200
     1.340    41.141     0.200
     1.588    48.406     0.200
     0.066    10.364     0.200
     0.394    16.874     0.200
     0.476    18.904     0.200
     0.702    23.354     0.200
     0.703    24.944     0.200
     0.843    29.404     0.200
     0.036    10.723     0.200
     0.425    17.570     0.200
     0.443    17.871     0.200
     0.673    22.691     0.200
     0.684    22.961     0.200
     0.785    27.102     0.200
     0.979    30.672     0.200
     0.933    31.570     0.200
     1.161    37.602     0.200
     1.263    39.492     0.200
     0.010     9.598     0.200
     0.352    14.098     0.200
     0.679    22.816     0.200
     0.700    23.809     0.200
     0.723    23.887     0.200
     0.749    26.180     0.200
     0.902    30.758     0.200
     0.997    31.270     0.200
     1.565    47.078     0.200
     0.003     9.668     0.200
     0.360    14.277     0.200
     0.672    22.766     0.200
     0.703    24.148     0.200
     0.751    26.227     0.200
     0.908    31.027     0.200
     0.989    31.309     0.200
     1.129    36.578     0.200
     1.257    39.527     0.200
     1.572    47.355     0.200
     0.079     8.210     0.200
     0.443    17.440     0.200
     1.863    55.850     0.200
     2.899    85.650     0.200
     0.211    12.336     0.200
     0.311    12.664     0.200
     0.366    15.785     0.200
     0.701    25.344     0.200
     1.193    36.965     0.200
     1.368    41.820     0.200
     0.115     9.973     0.200
     0.404    16.145     0.200
     0.795    28.434     0.200
     2.750    82.645     0.200
     0.065     9.977     0.200
     0.331    13.156     0.200
     0.387    16.383     0.200
     0.699    24.602     0.200
     0.695    23.188     0.200
     0.845    29.094     0.200
     1.067    34.953     0.200
     1.041    32.352     0.200
     1.509    45.102     0.200
     0.299    12.539     0.200
     0.513    20.152     0.200
     0.650    23.270     0.200
     0.758    25.430     0.200
     0.739    24.070     0.200
     1.252    38.891     0.200
     0.148    10.641     0.200
     0.315    12.562     0.200
     0.365    16.070     0.200
     0.728    24.230     0.200
     0.778    26.211     0.200
     1.108    34.402     0.200
     1.178    37.621     0.200
     1.429    43.027     0.200
     0.135    10.848     0.200
     0.327    13.605     0.200
     0.356    15.637     0.200
     0.533    20.734     0.200
     0.635    23.137     0.200
     0.712    23.484     0.200
     0.779    27.676     0.200
     0.995    32.395     0.200
     0.130    10.785     0.200
     0.308    12.367     0.200
     0.377    15.375     0.200
     0.759    26.074     0.200
     0.728    23.965     0.200
     1.005    32.664     0.200
     1.445    44.520     0.200
     2.758    81.445     0.200
     0.319    13.367     0.200
     0.245     9.715     0.200
     0.413    14.695     0.200
     0.513    17.977     0.200
     0.477    16.438     0.200
     1.007    32.285     0.200
     1.092    36.145     0.200
     0.188    12.387     0.200
     0.316    12.957     0.200
     0.359    15.906     0.200
     0.600    22.105     0.200
     0.745    24.625     0.200
     0.803    26.375     0.200
     0.945    31.848     0.200
     1.204    39.137     0.200
     1.216    37.188     0.200
     1.391    42.246     0.200
     0.034     9.318     0.200
     0.345    13.549     0.200
     0.671    21.979     0.200
     0.694    23.199     0.200
     0.780    26.840     0.200
     0.920    31.309     0.200
     0.994    31.529     0.200
     0.195    10.170     0.200
     0.279    11.979     0.200
     0.396    14.840     0.200
     0.396    14.569     0.200
     0.460    17.330     0.200
     1.745    53.185     0.200
     2.316    67.660     0.200
     0.142    10.523     0.200
     0.317    14.656     0.200
     0.367    14.125     0.200
     0.790    27.711     0.200
     0.989    32.906     0.200
     1.211    37.234     0.200
     1.458    43.758     0.200
     2.806    81.102     0.200
     0.379    13.559     0.200
     0.608    20.027     0.200
     0.738    24.375     0.200
     0.092     8.836     0.200
     0.704    22.605     0.200
     0.827    28.559     0.200
     1.095    35.836     0.200
     1.617    49.355     0.200
     2.582    77.008     0.200
     0.073     9.488     0.200
     0.413    15.090     0.200
     0.771    25.637     0.200
     0.935    30.848     0.200
     1.131    35.168     0.200
     1.724    51.758     0.200
     0.291    13.043     0.200
     0.921    31.363     0.200
     1.026    32.410     0.200
     2.512    74.961     0.200
     0.716    23.594     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     8.665   267.688     0.200
     4.656   149.566     0.200
     3.241   103.277     0.200
     3.350   104.254     0.200
     3.486   112.453     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.471    18.790     0.200
     0.791    26.790     0.200
     1.556    50.790     0.200
     0.253    11.703     0.200
     0.769    26.703     0.200
     1.498    48.703     0.200
     3.345    97.703     0.200
     0.452    17.492     0.200
     0.816    26.492     0.200
     1.350    43.289     0.200
     1.602    51.492     0.200
     4.765   140.492     0.200
     0.529    19.859     0.200
     0.869    29.859     0.200
     1.532    45.859     0.200
     2.209    64.859     0.200
     0.678    21.340     0.200
     1.023    33.441     0.200
     1.061    34.840     0.200
     1.271    40.441     0.200
     1.924    56.641     0.200
     2.298    68.840     0.200
     3.456   100.840     0.200
     1.547    52.995     0.200
     1.809    57.195     0.200
     3.136    92.995     0.200
     0.935    30.758     0.200
     1.565    50.859     0.200
     1.698    51.359     0.200
     2.033    60.656     0.200
     2.271    68.359     0.200
     0.925    31.551     0.200
     1.938    57.650     0.200
     2.266    67.851     0.200
     2.529    77.851     0.200
     3.074    89.150     0.200
     1.473    45.374     0.200
     1.574    50.374     0.200
     1.464    44.739     0.200
     1.552    50.539     0.200
     1.888    55.539     0.200
     2.132    64.239     0.200
     0.880    29.322     0.200
     1.619    50.021     0.200
     1.544    48.121     0.200
     0.882    29.428     0.200
     1.518    47.729     0.200
     1.597    50.746     0.200
     1.482    44.645     0.200
     0.832    27.031     0.200
     0.871    29.234     0.200
     1.586    47.836     0.200
     1.556    46.836     0.200
     1.608    51.184     0.200
     1.813    54.984     0.200
     2.180    64.883     0.200
     3.258    94.984     0.200
     1.520    48.332     0.200
     1.866    56.332     0.200
     0.843    28.562     0.200
     1.962    58.961     0.200
     0.962    32.119     0.200
     1.656    52.119     0.200
     1.976    59.119     0.200
     1.226    38.281     0.200
     1.563    51.480     0.200
     1.570    48.680     0.200
     1.792    53.281     0.200
     1.567    50.227     0.200
     3.149    91.023     0.200
     0.929    31.268     0.200
     1.635    51.668     0.200
     1.606    49.668     0.200
     1.814    54.357     0.200
     3.105    89.758     0.200
     0.937    31.893     0.200
     1.186    36.592     0.200
     1.582    49.191     0.200
     1.724    51.293     0.200
     1.972    59.092     0.200
     1.234    39.035     0.200
     1.499    46.635     0.200
     1.490    46.707     0.200
     1.426    44.207     0.200
     3.374    98.406     0.200
     0.851    28.132     0.200
     1.470    44.231     0.200
     1.652    53.231     0.200
     2.183    64.231     0.200
     3.144    90.932     0.200
     0.851    29.334     0.200
     1.448    47.133     0.200
     1.491    48.879     0.200
     1.414    44.277     0.200
     1.389    47.250     0.200
     1.570    48.449     0.200
     1.956    60.148     0.200
     2.476    73.449     0.200
     3.263    95.449     0.200
     4.723   137.949     0.200
     0.833    27.484     0.200
     1.572    49.184     0.200
     1.511    46.184     0.200
     1.154    35.438     0.200
     1.565    47.141     0.200
     1.945    57.539     0.200
     1.076    35.572     0.200
     1.841    55.271     0.200
     1.286    38.786     0.200
     1.596    50.286     0.200
     1.976    58.786     0.200
     2.264    66.586     0.200
     0.906    30.086     0.200
     1.545    46.387     0.200
     1.813    54.586     0.200
     0.960    31.484     0.200
     1.625    50.684     0.200
     1.658    52.883     0.200
     1.893    56.484     0.200
     1.974    58.785     0.200
     0.879    28.977     0.200
     0.801    26.734     0.200
     0.372    14.380     0.200
     1.091    34.681     0.200
     0.169     9.332     0.200
     1.399    43.732     0.200
     0.211    11.328     0.200
     0.814    27.227     0.200
     1.460    43.727     0.200
     0.670    22.262     0.200
     0.911    29.363     0.200
     1.028    35.465     0.200
     1.256    40.762     0.200
     1.299    40.664     0.200
     1.287    42.965     0.200
     1.376    43.664     0.200
     1.452    45.164     0.200
     1.410    44.965     0.200
     1.625    49.863     0.200
     1.831    55.465     0.200
     1.848    55.664     0.200
     0.503    19.137     0.200
     0.673    22.336     0.200
     0.911    29.637     0.200
     1.257    41.035     0.200
     1.289    41.738     0.200
     1.379    44.137     0.200
     1.413    44.238     0.200
     1.471    46.238     0.200
     1.627    50.535     0.200
     0.230    11.773     0.200
     0.441    17.273     0.200
     0.655    23.477     0.200
     0.743    26.172     0.200
     1.073    34.375     0.200
     1.111    35.375     0.200
     1.364    42.375     0.200
     1.483    45.773     0.200
     1.670    51.375     0.200
     1.786    53.070     0.200
     0.020     9.738     0.200
     0.410    15.141     0.200
     0.623    21.438     0.200
     0.929    29.238     0.200
     1.075    33.141     0.200
     1.835    54.141     0.200
     1.136    35.805     0.200
     1.191    37.105     0.200
     1.388    43.005     0.200
     1.705    52.305     0.200
     1.846    54.905     0.200
     1.890    58.305     0.200
     2.517    73.405     0.200
     0.263    11.273     0.200
     0.264    12.172     0.200
     0.692    22.172     0.200
     0.753    23.672     0.200
     1.130    35.473     0.200
     1.427    43.773     0.200
     1.424    45.371     0.200
     1.720    52.273     0.200
     1.755    52.773     0.200
     0.260    13.249     0.200
     0.281    13.349     0.200
     0.697    23.849     0.200
     0.700    22.949     0.200
     1.110    34.548     0.200
     1.376    42.749     0.200
     0.199    10.438     0.200
     1.095    34.938     0.200
     1.203    36.938     0.200
     1.670    49.539     0.200
     0.247    11.775     0.200
     0.636    21.275     0.200
     0.698    22.675     0.200
     0.877    29.475     0.200
     1.060    32.975     0.200
     0.737    24.211     0.200
     1.189    37.012     0.200
     1.953    57.512     0.200
     0.373    14.711     0.200
     0.629    21.410     0.200
     0.732    24.609     0.200
     0.908    29.910     0.200
     1.059    33.312     0.200
     1.685    50.859     0.200
     0.071     8.963     0.200
     0.549    18.562     0.200
     0.706    23.136     0.200
     0.992    31.436     0.200
     0.121     9.289     0.200
     0.999    32.492     0.200
     0.088     7.995     0.200
     0.404    15.095     0.200
     0.690    22.585     0.200
     2.288    66.895     0.200
     0.200     7.719     0.200
     0.757    25.973     0.200
     0.148     7.209     0.200
     0.851    28.922     0.200
     0.663    23.170     0.200
     0.776    25.270     0.200
     0.096     9.510     0.200
     0.371    16.120     0.200
     0.898    29.010     0.200
     1.150    36.510     0.200
     0.078     9.508     0.200
     0.372    16.008     0.200
     0.594    20.109     0.200
     0.754    25.109     0.200
     0.805    26.906     0.200
     0.916    28.906     0.200
     1.177    37.309     0.200
     1.626    49.609     0.200
     0.310    13.602     0.200
     0.367    14.840     0.200
     0.585    21.422     0.200
     0.690    22.879     0.200
     0.760    27.480     0.200
     1.163    36.609     0.200
     1.428    43.789     0.200
     0.185    10.549     0.200
     0.390    14.459     0.200
     1.086    33.799     0.200
     1.431    43.250     0.200
     0.067    10.367     0.200
     0.398    16.168     0.200
     0.706    23.328     0.200
     0.010     9.273     0.200
     0.353    13.398     0.200
     0.410    16.961     0.200
     0.745    25.961     0.200
     0.899    30.883     0.200
     0.997    31.328     0.200
     1.563    47.352     0.200
     0.086     9.922     0.200
     0.432    15.000     0.200
     0.802    27.562     0.200
     0.994    33.070     0.200
     0.191    12.883     0.200
     0.315    13.188     0.200
     0.360    16.031     0.200
     0.595    20.680     0.200
     0.599    22.203     0.200
     0.722    25.523     0.200
     0.748    24.773     0.200
     0.804    27.070     0.200
     0.942    31.820     0.200
     1.213    37.781     0.200
     0.110    10.953     0.200
     0.291    13.180     0.200
     0.403    16.508     0.200
     0.685    24.328     0.200
     0.738    24.172     0.200
     1.034    34.047     0.200
     0.079    10.688     0.200
     0.339    13.625     0.200
     0.688    23.117     0.200
     0.680    24.258     0.200
     0.749    24.797     0.200
     0.833    29.367     0.200
     0.064    10.469     0.200
     0.320    13.195     0.200
     0.706    23.469     0.200
     0.709    25.234     0.200
     1.508    46.039     0.200
     0.076    10.266     0.200
     0.311    12.750     0.200
     0.663    22.375     0.200
     0.715    23.586     0.200
     0.704    25.273     0.200
     0.046    10.102     0.200
     0.324    13.234     0.200
     0.703    23.297     0.200
     0.728    25.461     0.200
     0.865    29.578     0.200
     1.032    32.391     0.200
     1.102    34.586     0.200
     1.093    36.438     0.200
     1.528    45.828     0.200
     0.012    10.594     0.200
     0.365    14.602     0.200
     0.418    17.367     0.200
     0.670    22.844     0.200
     0.761    26.391     0.200
     0.980    30.711     0.200
     1.253    39.219     0.200
     0.186    12.430     0.200
     0.303    12.898     0.200
     0.372    15.906     0.200
     0.611    22.180     0.200
     0.755    24.820     0.200
     0.725    25.492     0.200
     0.951    31.602     0.200
     1.213    36.992     0.200
     1.391    42.484     0.200
     0.010    10.703     0.200
     0.357    14.109     0.200
     0.447    18.258     0.200
     0.419    17.703     0.200
     0.677    22.766     0.200
     0.758    26.383     0.200
     0.912    31.273     0.200
     0.989    30.859     0.200
     1.090    33.555     0.200
     1.135    36.930     0.200
     1.261    39.438     0.200
     0.308    12.820     0.200
     0.606    22.500     0.200
     0.752    24.922     0.200
     0.723    25.844     0.200
     0.947    32.375     0.200
     1.197    37.344     0.200
     1.213    36.930     0.200
     1.389    41.820     0.200
     1.389    42.125     0.200
     1.390    42.133     0.200
     0.076    10.709     0.200
     0.326    13.469     0.200
     0.384    16.449     0.200
     0.487    18.759     0.200
     0.671    22.539     0.200
     0.691    24.719     0.200
     0.700    23.279     0.200
     0.834    28.879     0.200
     1.056    34.839     0.200
     1.134    35.209     0.200
     1.498    45.579     0.200
     0.081    10.667     0.200
     0.343    13.647     0.200
     0.365    16.348     0.200
     0.685    22.718     0.200
     0.676    24.308     0.200
     0.833    28.658     0.200
     1.048    33.547     0.200
     1.499    45.643     0.200
     0.017     9.429     0.200
     0.371    14.709     0.200
     0.664    22.229     0.200
     0.763    26.559     0.200
     0.926    31.568     0.200
     0.973    30.729     0.200
     1.145    36.368     0.200
     1.247    39.419     0.200
     1.589    47.533     0.200
     0.028     9.307     0.200
     0.379    14.916     0.200
     0.696    23.547     0.200
     0.659    22.207     0.200
     0.772    26.936     0.200
     0.963    30.326     0.200
     0.937    31.986     0.200
     1.156    36.816     0.200
     1.240    38.877     0.200
     1.600    47.627     0.200
     0.171    12.014     0.200
     0.312    13.104     0.200
     0.364    16.014     0.200
     0.546    21.395     0.200
     0.616    22.564     0.200
     0.741    26.264     0.200
     0.740    24.264     0.200
     0.790    25.955     0.200
     0.963    32.775     0.200
     1.230    37.654     0.200
     1.407    42.215     0.200
     0.074    10.385     0.200
     0.327    13.254     0.200
     0.699    23.084     0.200
     0.692    24.424     0.200
     0.835    29.375     0.200
     1.500    46.344     0.200
     0.008     9.508     0.200
     0.367    14.031     0.200
     0.666    22.609     0.200
     0.703    23.859     0.200
     0.739    25.141     0.200
     0.755    26.352     0.200
     0.980    31.070     0.200
     0.916    31.766     0.200
     1.580    47.781     0.200
     0.109    10.672     0.200
     0.321    13.039     0.200
     0.710    23.609     0.200
     0.756    25.047     0.200
     0.662    23.695     0.200
     0.802    27.680     0.200
     1.467    45.242     0.200
     0.014    10.516     0.200
     0.446    17.719     0.200
     0.420    17.633     0.200
     0.672    23.047     0.200
     0.695    23.227     0.200
     0.739    24.766     0.200
     0.763    26.422     0.200
     0.981    30.656     0.200
     0.920    31.531     0.200
     1.254    39.227     0.200
     0.102    10.657     0.200
     0.316    13.367     0.200
     0.650    22.356     0.200
     0.672    24.227     0.200
     0.807    28.457     0.200
     1.031    34.146     0.200
     1.146    36.356     0.200
     1.472    44.657     0.200
     0.130    11.535     0.200
     0.291    12.715     0.200
     0.394    16.754     0.200
     0.498    19.766     0.200
     0.665    23.992     0.200
     0.742    24.203     0.200
     0.779    27.613     0.200
     1.011    33.426     0.200
     1.260    38.754     0.200
     0.057    10.336     0.200
     0.329    13.105     0.200
     0.722    24.227     0.200
     0.697    23.195     0.200
     0.708    25.324     0.200
     0.851    29.316     0.200
     0.084    10.398     0.200
     0.331    13.379     0.200
     0.374    16.590     0.200
     0.697    23.070     0.200
     0.747    24.930     0.200
     0.679    24.340     0.200
     0.826    28.520     0.200
     1.046    34.078     0.200
     1.492    45.113     0.200
     0.168    11.812     0.200
     0.288    12.281     0.200
     0.524    20.652     0.200
     0.592    20.391     0.200
     0.636    23.012     0.200
     0.741    26.484     0.200
     0.767    25.391     0.200
     0.973    32.973     0.200
     1.225    37.723     0.200
     1.405    42.137     0.200
     0.107    10.414     0.200
     0.297    12.234     0.200
     0.730    24.727     0.200
     0.683    24.297     0.200
     0.732    23.984     0.200
     0.803    28.023     0.200
     1.466    45.195     0.200
     0.051    10.356     0.200
     0.329    13.396     0.200
     0.697    23.106     0.200
     0.716    25.246     0.200
     0.858    29.636     0.200
     1.083    35.546     0.200
     0.209    11.938     0.200
     0.738    26.516     0.200
     1.014    33.098     0.200
     0.062    10.203     0.200
     0.327    13.180     0.200
     0.704    24.953     0.200
     0.699    23.258     0.200
     0.846    29.594     0.200
     1.510    45.055     0.200
     0.029     9.203     0.200
     0.378    15.062     0.200
     0.661    22.172     0.200
     0.757    24.859     0.200
     0.774    26.914     0.200
     0.963    30.414     0.200
     0.938    31.812     0.200
     1.157    37.703     0.200
     1.241    39.219     0.200
     1.601    48.727     0.200
     0.088    10.344     0.200
     0.309    12.906     0.200
     0.728    24.695     0.200
     0.692    24.438     0.200
     0.718    23.789     0.200
     0.821    28.617     0.200
     1.067    33.008     0.200
     0.114     7.025     0.200
     0.338    13.976     0.200
     0.680    22.836     0.200
     1.476    46.286     0.200
     0.197    12.332     0.200
     0.300    12.660     0.200
     0.376    15.652     0.200
     0.580    21.102     0.200
     0.606    22.332     0.200
     0.764    24.840     0.200
     1.202    37.180     0.200
     0.057    10.273     0.200
     0.326    13.004     0.200
     0.700    23.445     0.200
     0.711    25.133     0.200
     0.852    29.414     0.200
     1.039    32.504     0.200
     1.077    35.504     0.200
     1.515    46.090     0.200
     0.009     9.566     0.200
     0.365    14.496     0.200
     0.669    22.516     0.200
     0.758    26.305     0.200
     0.917    31.453     0.200
     0.981    30.953     0.200
     1.138    37.293     0.200
     0.104    10.609     0.200
     0.295    12.234     0.200
     0.687    24.391     0.200
     0.733    24.320     0.200
     1.038    33.688     0.200
     1.468    44.586     0.200
     0.078    10.559     0.200
     0.325    12.969     0.200
     0.702    23.268     0.200
     0.689    24.508     0.200
     0.831    28.969     0.200
     1.054    34.699     0.200
     0.048     9.047     0.200
     0.339    13.648     0.200
     0.391    16.398     0.200
     0.687    22.766     0.200
     1.026    32.266     0.200
     1.525    46.219     0.200
     0.179    12.232     0.200
     0.312    12.972     0.200
     0.363    15.802     0.200
     0.551    21.582     0.200
     0.610    22.502     0.200
     0.733    26.052     0.200
     0.744    24.372     0.200
     0.794    26.512     0.200
     0.955    32.362     0.200
     1.223    37.792     0.200
     0.360    14.465     0.200
     0.805    28.957     0.200
     1.073    34.816     0.200
     1.299    39.598     0.200
     0.041    10.570     0.200
     0.326    13.875     0.200
     0.452    18.094     0.200
     0.414    17.156     0.200
     0.692    23.625     0.200
     0.733    25.711     0.200
     0.871    29.820     0.200
     1.533    45.945     0.200
     0.305    12.637     0.200
     0.638    23.098     0.200
     0.738    24.098     0.200
     0.770    25.547     0.200
     1.246    37.977     0.200
     1.426    42.938     0.200
     0.091    10.832     0.200
     0.825    28.041     0.200
     1.586    47.402     0.200
     0.201    12.105     0.200
     0.506    20.525     0.200
     0.654    23.165     0.200
     1.373    42.690     0.200
     0.053     9.062     0.200
     0.727    22.844     0.200
     0.708    22.820     0.200
     1.340    41.141     0.200
     1.588    48.406     0.200
     0.066    10.364     0.200
     0.394    16.874     0.200
     0.476    18.904     0.200
     0.702    23.354     0.200
     0.703    24.944     0.200
     0.843    29.404     0.200
     0.036    10.723     0.200
     0.425    17.570     0.200
     0.443    17.871     0.200
     0.673    22.691     0.200
     0.684    22.961     0.200
     0.785    27.102     0.200
     0.979    30.672     0.200
     0.933    31.570     0.200
     1.161    37.602     0.200
     1.263    39.492     0.200
     0.010     9.598     0.200
     0.352    14.098     0.200
     0.679    22.816     0.200
     0.700    23.809     0.200
     0.723    23.887     0.200
     0.749    26.180     0.200
     0.902    30.758     0.200
     0.997    31.270     0.200
     1.565    47.078     0.200
     0.003     9.668     0.200
     0.360    14.277     0.200
     0.672    22.766     0.200
     0.703    24.148     0.200
     0.751    26.227     0.200
     0.908    31.027     0.200
     0.989    31.309     0.200
     1.129    36.578     0.200
     1.257    39.527     0.200
     1.572    47.355     0.200
     0.079     8.210     0.200
     0.443    17.440     0.200
     1.863    55.850     0.200
     2.899    85.650     0.200
     0.211    12.336     0.200
     0.311    12.664     0.200
     0.366    15.785     0.200
     0.701    25.344     0.200
     1.193    36.965     0.200
     1.368    41.820     0.200
     0.115     9.973     0.200
     0.404    16.145     0.200
     0.795    28.434     0.200
     2.750    82.645     0.200
     0.065     9.977     0.200
     0.331    13.156     0.200
     0.387    16.383     0.200
     0.699    24.602     0.200
     0.695    23.188     0.200
     0.845    29.094     0.200
     1.067    34.953     0.200
     1.041    32.352     0.200
     1.509    45.102     0.200
     0.299    12.539     0.200
     0.513    20.152     0.200
     0.650    23.270     0.200
     0.758    25.430     0.200
     0.739    24.070     0.200
     1.252    38.891     0.200
     0.148    10.641     0.200
     0.315    12.562     0.200
     0.365    16.070     0.200
     0.728    24.230     0.200
     0.778    26.211     0.200
     1.108    34.402     0.200
     1.178    37.621     0.200
     1.429    43.027     0.200
     0.135    10.848     0.200
     0.327    13.605     0.200
     0.356    15.637     0.200
     0.533    20.734     0.200
     0.635    23.137     0.200
     0.712    23.484     0.200
     0.779    27.676     0.200
     0.995    32.395     0.200
     0.130    10.785     0.200
     0.308    12.367     0.200
     0.377    15.375     0.200
     0.759    26.074     0.200
     0.728    23.965     0.200
     1.005    32.664     0.200
     1.445    44.520     0.200
     2.758    81.445     0.200
     0.319    13.367     0.200
     0.245     9.715     0.200
     0.413    14.695     0.200
     0.513    17.977     0.200
     0.477    16.438     0.200
     1.007    32.285     0.200
     1.092    36.145     0.200
     0.188    12.387     0.200
     0.316    12.957     0.200
     0.359    15.906     0.200
     0.600    22.105     0.200
     0.745    24.625     0.200
     0.803    26.375     0.200
     0.945    31.848     0.200
     1.204    39.137     0.200
     1.216    37.188     0.200
     1.391    42.246     0.200
     0.034     9.318     0.200
     0.345    13.549     0.200
     0.671    21.979     0.200
     0.694    23.199     0.200
     0.780    26.840     0.200
     0.920    31.309     0.200
     0.994    31.529     0.200
     0.195    10.170     0.200
     0.279    11.979     0.200
     0.396    14.840     0.200
     0.396    14.569     0.200
     0.460    17.330     0.200
     1.745    53.185     0.200
     2.316    67.660     0.200
     0.142    10.523     0.200
     0.317    14.656     0.200
     0.367    14.125     0.200
     0.790    27.711     0.200
     0.989    32.906     0.200
     1.211    37.234     0.200
     1.458    43.758     0.200
     2.806    81.102     0.200
     0.379    13.559     0.200
     0.608    20.027     0.200
     0.738    24.375     0.200
     0.092     8.836     0.200
     0.704    22.605     0.200
     0.827    28.559     0.200
     1.095    35.836     0.200
     1.617    49.355     0.200
     2.582    77.008     0.200
     0.073     9.488     0.200
     0.413    15.090     0.200
     0.771    25.637     0.200
     0.935    30.848     0.200
     1.131    35.168     0.200
     1.724    51.758     0.200
     0.291    13.043     0.200
     0.921    31.363     0.200
     1.026    32.410     0.200
     2.512    74.961     0.200
     0.716    23.594     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
