#!/bin/bash
gmt begin sapporo1.54_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source sapporo1.54'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.099    -0.158     0.200
     0.206    -0.255     0.200
     0.167     0.408     0.200
     0.253     0.265     0.200
     0.769     0.049     0.200
     0.050     0.818     0.200
     0.452     0.799     0.200
     0.115     0.316     0.200
     0.262    -1.015     0.200
     0.678    -1.807     0.200
     0.740     0.150     0.200
     0.112     1.214     0.200
     0.545    -0.501     0.200
     0.122     0.425     0.200
     0.161     0.692     0.200
     0.591    -0.123     0.200
     0.925    -0.202     0.200
     0.090     0.331     0.200
     0.106     0.135     0.200
     0.792    -0.084     0.200
     0.124     0.116     0.200
     0.078    -0.013     0.200
     0.074     0.199     0.200
     0.033     0.662     0.200
     0.832    -0.067     0.200
     0.159    -0.004     0.200
     0.078     0.242     0.200
     0.240     0.964     0.200
     0.037    -0.020     0.200
     0.470     0.567     0.200
     0.843    -0.053     0.200
     0.243     0.915     0.200
     0.192     0.253     0.200
     0.118     0.522     0.200
     0.184     0.481     0.200
     0.929    -0.309     0.200
     0.170     0.418     0.200
     0.863    -0.027     0.200
     0.267     0.841     0.200
     0.166     0.429     0.200
     0.494     0.675     0.200
     0.154     0.762     0.200
     0.450     0.872     0.200
     0.028     0.219     0.200
     0.037     0.400     0.200
     0.150     0.407     0.200
     0.437     0.814     0.200
     0.074     0.193     0.200
     0.390     0.847     0.200
     0.753    -0.011     0.200
     0.125     0.831     0.200
     0.250     0.863     0.200
     0.070     1.518     0.200
     0.367    -0.367     0.200
     0.173     0.557     0.200
     0.270     0.442     0.200
     0.248     0.517     0.200
     0.088     0.238     0.200
     0.521     0.106     0.200
     0.083     0.028     0.200
     0.088     1.385     0.200
     0.351     0.405     0.200
     0.372    -0.610     0.200
     0.169    -1.063     0.200
     0.253     0.300     0.200
     0.211    -0.032     0.200
     0.346     0.074     0.200
     0.168     0.098     0.200
     0.500     0.439     0.200
     0.593    -0.070     0.200
     0.670    -0.606     0.200
     0.820    -0.446     0.200
     0.911    -0.667     0.200
     0.167    -1.215     0.200
     0.503     0.458     0.200
     0.591    -0.045     0.200
     0.673    -0.575     0.200
     0.820    -0.371     0.200
     0.911    -0.706     0.200
     0.230    -0.912     0.200
     0.020    -0.074     0.200
     0.444     0.359     0.200
     0.695    -0.818     0.200
     0.895    -0.845     0.200
     0.992     0.409     0.200
     0.263    -0.143     0.200
     0.264     0.247     0.200
     0.692    -1.075     0.200
     0.753    -0.320     0.200
     0.776    -0.624     0.200
     0.260    -0.281     0.200
     0.281    -0.136     0.200
     0.199    -0.321     0.200
     0.307     1.113     0.200
     0.247     0.027     0.200
     0.636    -0.561     0.200
     0.698    -0.818     0.200
     0.105    -0.003     0.200
     0.635    -0.677     0.200
     0.208    -0.095     0.200
     0.373    -0.452     0.200
     0.071    -0.118     0.200
     0.329    -0.116     0.200
     0.445    -0.330     0.200
     0.706    -0.166     0.200
     0.518     0.027     0.200
     0.680    -0.287     0.200
     0.852    -2.067     0.200
     0.121    -0.319     0.200
     0.510    -0.494     0.200
     0.510    -0.489     0.200
     0.502    -0.683     0.200
     0.648    -0.576     0.200
     0.404     0.319     0.200
     0.434     1.606     0.200
     0.588    -0.216     0.200
     0.689    -0.631     0.200
     0.690    -0.546     0.200
     0.690    -0.316     0.200
     0.707    -0.538     0.200
     0.708    -0.268     0.200
     0.200    -0.389     0.200
     0.542    -0.409     0.200
     0.542    -0.609     0.200
     0.749    -0.738     0.200
     0.932    -0.431     0.200
     0.196    -0.345     0.200
     0.486     0.774     0.200
     0.486     0.672     0.200
     0.486     0.674     0.200
     0.624    -0.743     0.200
     0.757    -0.964     0.200
     0.148    -0.559     0.200
     0.462     0.733     0.200
     0.462     0.435     0.200
     0.603    -0.763     0.200
     0.709    -0.453     0.200
     0.965    -0.848     0.200
     0.193    -0.192     0.200
     0.274     0.010     0.200
     0.230     0.825     0.200
     0.310    -0.422     0.200
     0.776    -0.199     0.200
     0.916    -0.764     0.200
     0.096     0.063     0.200
     0.371     1.033     0.200
     0.898    -0.362     0.200
     0.078     0.016     0.200
     0.372     0.826     0.200
     0.754    -0.581     0.200
     0.805    -0.759     0.200
     0.310     0.403     0.200
     0.367    -0.002     0.200
     0.585     0.714     0.200
     0.585     0.339     0.200
     0.760     0.467     0.200
     0.831    -0.262     0.200
     0.185     0.337     0.200
     0.286     1.111     0.200
     0.390    -0.254     0.200
     0.067     0.590     0.200
     0.320    -0.355     0.200
     0.473     0.235     0.200
     0.398     0.809     0.200
     0.706    -0.717     0.200
     0.706     0.199     0.200
     0.842     0.325     0.200
     0.010     0.245     0.200
     0.410     0.848     0.200
     0.722    -0.380     0.200
     0.899     0.722     0.200
     0.086     0.296     0.200
     0.432    -0.623     0.200
     0.705    -0.604     0.200
     0.191     0.327     0.200
     0.315    -0.403     0.200
     0.595    -0.592     0.200
     0.722     0.584     0.200
     0.748    -0.300     0.200
     0.110     0.479     0.200
     0.291    -0.070     0.200
     0.079     0.290     0.200
     0.339    -0.568     0.200
     0.064     0.451     0.200
     0.320    -0.310     0.200
     0.718    -0.478     0.200
     0.076     0.454     0.200
     0.311    -0.127     0.200
     0.046     0.226     0.200
     0.324    -0.539     0.200
     0.704    -0.383     0.200
     0.865     0.617     0.200
     0.012     0.288     0.200
     0.186     0.308     0.200
     0.303    -0.396     0.200
     0.010     0.515     0.200
     0.188     0.527     0.200
     0.308    -0.489     0.200
     0.076     0.155     0.200
     0.326    -0.601     0.200
     0.691     0.325     0.200
     0.834     0.539     0.200
     0.081     0.070     0.200
     0.343    -0.445     0.200
     0.017     0.150     0.200
     0.371    -0.106     0.200
     0.699    -0.486     0.200
     0.926     0.541     0.200
     0.973    -0.535     0.200
     0.028     0.131     0.200
     0.379    -0.229     0.200
     0.449     0.292     0.200
     0.421     0.758     0.200
     0.659    -0.217     0.200
     0.757    -0.712     0.200
     0.772     0.273     0.200
     0.963    -0.692     0.200
     0.937     0.368     0.200
     0.171     0.314     0.200
     0.312    -0.469     0.200
     0.364     0.608     0.200
     0.546    -0.089     0.200
     0.741     0.527     0.200
     0.074     0.106     0.200
     0.327    -0.446     0.200
     0.692     0.187     0.200
     0.835     0.517     0.200
     0.008     0.158     0.200
     0.367    -0.342     0.200
     0.666    -0.036     0.200
     0.703    -0.626     0.200
     0.755     0.381     0.200
     0.980    -0.526     0.200
     0.916     0.405     0.200
     0.109     0.264     0.200
     0.321    -0.498     0.200
     0.014     0.239     0.200
     0.102    -0.001     0.200
     0.316    -0.328     0.200
     0.130     0.296     0.200
     0.291    -0.561     0.200
     0.498     0.079     0.200
     0.665     0.372     0.200
     0.779     0.517     0.200
     0.057     0.237     0.200
     0.329    -0.505     0.200
     0.084     0.098     0.200
     0.331    -0.454     0.200
     0.168     0.268     0.200
     0.288    -0.641     0.200
     0.741     0.468     0.200
     0.973    -0.189     0.200
     0.107     0.169     0.200
     0.297    -0.522     0.200
     0.051     0.169     0.200
     0.329    -0.514     0.200
     0.062     0.066     0.200
     0.327    -0.526     0.200
     0.846     0.525     0.200
     0.029    -0.049     0.200
     0.378    -0.314     0.200
     0.661    -0.201     0.200
     0.938     0.464     0.200
     0.088     0.321     0.200
     0.309    -0.402     0.200
     0.355     0.037     0.200
     0.338     0.696     0.200
     0.680    -0.766     0.200
     0.809     0.607     0.200
     0.197     0.417     0.200
     0.300    -0.397     0.200
     0.057     0.373     0.200
     0.326    -0.325     0.200
     0.009     0.075     0.200
     0.365    -0.307     0.200
     0.669    -0.209     0.200
     0.917     0.485     0.200
     0.104     0.247     0.200
     0.295    -0.526     0.200
     0.727    -0.594     0.200
     0.733    -0.485     0.200
     0.078     0.271     0.200
     0.325    -0.495     0.200
     0.048     0.244     0.200
     0.339    -0.145     0.200
     0.391     0.777     0.200
     0.179     0.286     0.200
     0.312    -0.645     0.200
     0.610     0.388     0.200
     0.733     0.332     0.200
     0.955    -0.035     0.200
     0.109     0.549     0.200
     0.360     0.336     0.200
     0.519     1.654     0.200
     0.655     0.673     0.200
     0.766     0.636     0.200
     0.041     0.123     0.200
     0.326    -0.528     0.200
     0.149     0.367     0.200
     0.305    -0.549     0.200
     0.091     0.445     0.200
     0.366     0.939     0.200
     0.614    -0.088     0.200
     0.500     0.279     0.200
     0.711    -0.069     0.200
     0.825     0.033     0.200
     0.983    -0.767     0.200
     0.201     0.053     0.200
     0.242     0.146     0.200
     0.053     0.608     0.200
     0.403     1.006     0.200
     0.727    -0.260     0.200
     0.708    -0.528     0.200
     0.798     0.135     0.200
     0.996    -0.747     0.200
     0.066     0.073     0.200
     0.324    -0.589     0.200
     0.036     0.272     0.200
     0.010     0.258     0.200
     0.352    -0.263     0.200
     0.679    -0.153     0.200
     0.749     0.376     0.200
     0.902     0.560     0.200
     0.997    -0.682     0.200
     0.003     0.165     0.200
     0.360    -0.297     0.200
     0.411     0.765     0.200
     0.454     0.417     0.200
     0.672    -0.103     0.200
     0.703    -0.537     0.200
     0.731    -0.686     0.200
     0.751     0.362     0.200
     0.908     0.499     0.200
     0.989    -0.621     0.200
     0.079     0.332     0.200
     0.415    -0.473     0.200
     0.442     0.659     0.200
     0.443     0.853     0.200
     0.640     0.481     0.200
     0.686    -0.079     0.200
     0.802    -0.932     0.200
     0.988     0.329     0.200
     0.211     0.539     0.200
     0.311    -0.353     0.200
     0.366     0.878     0.200
     0.763    -0.596     0.200
     0.115     0.419     0.200
     0.404     0.521     0.200
     0.065     0.246     0.200
     0.331    -0.370     0.200
     0.699     0.370     0.200
     0.845     0.735     0.200
     0.140     0.305     0.200
     0.299    -0.487     0.200
     0.383     0.696     0.200
     0.513     0.220     0.200
     0.616    -0.641     0.200
     0.650     0.391     0.200
     0.769     0.512     0.200
     0.758    -0.618     0.200
     0.739    -0.445     0.200
     0.997    -0.389     0.200
     0.148     0.463     0.200
     0.315    -0.349     0.200
     0.365     1.013     0.200
     0.763     0.731     0.200
     0.135     0.314     0.200
     0.327    -0.586     0.200
     0.130     0.543     0.200
     0.308    -0.356     0.200
     0.377     0.712     0.200
     0.628    -0.612     0.200
     0.780     0.491     0.200
     0.319     0.042     0.200
     0.245    -0.359     0.200
     0.413    -0.349     0.200
     0.513    -0.068     0.200
     0.477    -0.587     0.200
     0.763    -0.387     0.200
     0.881    -0.144     0.200
     0.879     0.353     0.200
     0.914     0.507     0.200
     0.188     0.462     0.200
     0.316    -0.488     0.200
     0.359     0.744     0.200
     0.034     0.204     0.200
     0.345    -0.299     0.200
     0.422     0.545     0.200
     0.443     0.666     0.200
     0.671    -0.294     0.200
     0.694    -0.118     0.200
     0.780     0.168     0.200
     0.920     0.536     0.200
     0.994    -0.339     0.200
     0.279     0.259     0.200
     0.396    -0.131     0.200
     0.396     0.026     0.200
     0.396    -0.094     0.200
     0.650    -0.391     0.200
     0.142     0.048     0.200
     0.317     0.797     0.200
     0.367    -0.376     0.200
     0.670    -0.546     0.200
     0.065     0.945     0.200
     0.379    -0.139     0.200
     0.738    -0.652     0.200
     0.913     0.280     0.200
     0.092     0.076     0.200
     0.304     0.004     0.200
     0.288    -0.398     0.200
     0.667    -0.464     0.200
     0.703    -0.044     0.200
     0.667    -0.790     0.200
     0.704    -0.091     0.200
     0.704     0.081     0.200
     0.073     0.292     0.200
     0.413    -0.280     0.200
     0.291     0.339     0.200
     0.493     0.103     0.200
     0.710     0.684     0.200
     0.719    -0.554     0.200
     0.921     0.312     0.200
     0.884     0.477     0.200
     0.885     0.217     0.200
     0.716     0.368     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.147     0.638     0.200
     0.147    -0.261     0.200
     0.147     0.739     0.200
     0.287     0.704     0.200
     0.287    -0.093     0.200
     0.287     0.907     0.200
     0.719     0.264     0.200
     0.719     0.365     0.200
     0.469     0.147     0.200
     0.469     0.346     0.200
     0.836    -0.834     0.200
     0.836    -1.033     0.200
     0.764     1.019     0.200
     0.764     0.820     0.200
     0.764     0.019     0.200
     0.878     0.676     0.200
     0.878     1.077     0.200
     0.123     0.405     0.200
     0.339     0.914     0.200
     0.178     0.556     0.200
     0.349     0.009     0.200
     0.739    -0.962     0.200
     0.129     0.168     0.200
     0.309     0.811     0.200
     0.716     0.022     0.200
     0.233     0.641     0.200
     0.197    -0.358     0.200
     0.733     0.453     0.200
     0.110     0.353     0.200
     0.374    -0.190     0.200
     0.525     0.844     0.200
     0.970     0.967     0.200
     0.178     0.924     0.200
     0.337     0.117     0.200
     0.599     0.086     0.200
     0.964     0.062     0.200
     0.471     0.138     0.200
     0.791    -0.572     0.200
     0.511    -0.031     0.200
     0.146    -0.029     0.200
     0.150    -0.163     0.200
     0.287     0.835     0.200
     0.718    -0.096     0.200
     0.198    -0.220     0.200
     0.124     0.749     0.200
     0.124     0.147     0.200
     0.356     0.410     0.200
     0.562    -0.989     0.200
     0.052     1.048     0.200
     0.257    -0.237     0.200
     0.416     0.074     0.200
     0.585    -0.213     0.200
     0.082     0.454     0.200
     0.570    -0.326     0.200
     0.107     0.149     0.200
     0.256    -0.225     0.200
     0.415     0.359     0.200
     0.535    -0.335     0.200
     0.124     0.913     0.200
     0.227    -0.038     0.200
     0.385     0.543     0.200
     0.539    -1.094     0.200
     0.124    -0.244     0.200
     0.231     0.194     0.200
     0.361     0.509     0.200
     0.746    -0.498     0.200
     0.142    -0.490     0.200
     0.155     0.679     0.200
     0.278     0.885     0.200
     0.721    -0.613     0.200
     0.113    -0.317     0.200
     0.201     0.526     0.200
     0.234     0.545     0.200
     0.746    -0.341     0.200
     0.122    -0.366     0.200
     0.188    -0.474     0.200
     0.324     0.813     0.200
     0.721    -0.368     0.200
     0.113     0.629     0.200
     0.197     0.254     0.200
     0.334     0.636     0.200
     0.718    -1.336     0.200
     0.119     0.323     0.200
     0.223     0.325     0.200
     0.354     0.988     0.200
     0.085     1.150     0.200
     0.257    -0.495     0.200
     0.416    -0.081     0.200
     0.554    -0.676     0.200
     0.152    -0.067     0.200
     0.156     0.230     0.200
     0.284     0.490     0.200
     0.730    -0.421     0.200
     0.141     0.331     0.200
     0.172     0.173     0.200
     0.424     0.439     0.200
     0.711     0.363     0.200
     0.478     0.430     0.200
     0.707     0.645     0.200
     0.849    -0.618     0.200
     0.973     0.118     0.200
     0.816     0.292     0.200
     0.529     0.214     0.200
     0.869     0.433     0.200
     0.135     0.170     0.200
     0.268     0.148     0.200
     0.166     0.750     0.200
     0.727    -0.739     0.200
     0.169     0.320     0.200
     0.469     0.355     0.200
     0.721    -0.809     0.200
     0.109     0.599     0.200
     0.376     0.146     0.200
     0.736    -0.688     0.200
     0.139     0.378     0.200
     0.338     0.418     0.200
     0.753    -0.834     0.200
     0.173     0.159     0.200
     0.157    -0.381     0.200
     0.278     0.428     0.200
     0.752    -0.539     0.200
     0.737    -1.323     0.200
     0.146    -0.161     0.200
     0.161     0.397     0.200
     0.278     0.106     0.200
     0.731    -0.110     0.200
     0.195     0.286     0.200
     0.344     0.448     0.200
     0.729    -0.511     0.200
     0.181     0.080     0.200
     0.328     0.105     0.200
     0.710     0.038     0.200
     0.559    -0.435     0.200
     0.935    -0.011     0.200
     0.478    -0.498     0.200
     0.809    -0.465     0.200
     0.546     0.138     0.200
     0.880     0.438     0.200
     0.514    -0.098     0.200
     0.882     0.328     0.200
     0.483    -0.501     0.200
     0.828    -0.249     0.200
     0.462     0.182     0.200
     0.564    -0.083     0.200
     0.871     0.386     0.200
     0.496    -0.706     0.200
     0.842    -0.378     0.200
     0.610    -0.440     0.200
     0.859     0.415     0.200
     0.664    -0.204     0.200
     0.962     0.286     0.200
     0.870    -0.274     0.200
     0.507    -0.632     0.200
     0.823    -0.081     0.200
     0.204     0.136     0.200
     0.607     0.202     0.200
     0.896     0.539     0.200
     0.609    -0.125     0.200
     0.669    -0.296     0.200
     0.937     0.508     0.200
     0.230     0.404     0.200
     0.324    -0.060     0.200
     0.761    -0.581     0.200
     0.769    -0.680     0.200
     0.733    -0.440     0.200
     0.465     0.010     0.200
     0.851     0.387     0.200
     0.851     0.398     0.200
     0.726    -0.216     0.200
     0.368     0.122     0.200
     0.746    -0.360     0.200
     0.070     0.213     0.200
     0.367     0.350     0.200
     0.770     0.148     0.200
     0.222     0.380     0.200
     0.623    -0.103     0.200
     0.904     0.818     0.200
     0.053     0.440     0.200
     0.387     0.195     0.200
     0.796    -0.226     0.200
     0.157     0.305     0.200
     0.280     0.891     0.200
     0.617    -0.816     0.200
     0.519    -0.259     0.200
     0.833     0.006     0.200
     0.461    -0.679     0.200
     0.257     0.519     0.200
     0.693     1.353     0.200
     0.750    -0.346     0.200
     0.600    -0.136     0.200
     0.833     1.034     0.200
     0.193     0.179     0.200
     0.306     0.558     0.200
     0.715    -0.405     0.200
     0.569    -0.389     0.200
     0.062     0.669     0.200
     0.392     0.419     0.200
     0.525    -0.196     0.200
     0.225     0.167     0.200
     0.279     0.330     0.200
     0.741    -0.347     0.200
     0.598    -0.446     0.200
     0.922     1.185     0.200
     0.656    -0.349     0.200
     0.906     0.091     0.200
     0.223     0.267     0.200
     0.294     0.306     0.200
     0.744    -0.401     0.200
     0.141     0.083     0.200
     0.208     0.052     0.200
     0.306     0.397     0.200
     0.732    -0.416     0.200
     0.184     0.389     0.200
     0.349     0.452     0.200
     0.718    -0.538     0.200
     0.232     0.129     0.200
     0.263    -0.049     0.200
     0.742    -0.490     0.200
     0.248     0.308     0.200
     0.215     0.417     0.200
     0.731     0.102     0.200
     0.207     0.305     0.200
     0.305     0.375     0.200
     0.731    -0.336     0.200
     0.218     0.372     0.200
     0.268     0.379     0.200
     0.727    -0.509     0.200
     0.667    -0.491     0.200
     0.960     0.156     0.200
     0.879     0.313     0.200
     0.207     0.185     0.200
     0.265     0.346     0.200
     0.710    -0.165     0.200
     0.330     0.293     0.200
     0.371    -0.199     0.200
     0.095     0.002     0.200
     0.499     0.611     0.200
     0.831     0.670     0.200
     0.212     0.229     0.200
     0.277     0.323     0.200
     0.725    -0.271     0.200
     0.043     0.068     0.200
     0.395     0.782     0.200
     0.797     1.004     0.200
     0.371     0.168     0.200
     0.801    -0.359     0.200
     0.215     0.325     0.200
     0.253     0.085     0.200
     0.738    -0.381     0.200
     0.365     0.358     0.200
     0.602    -1.040     0.200
     0.682     0.413     0.200
     0.795     0.937     0.200
     0.983     0.363     0.200
     0.569    -0.097     0.200
     0.227    -0.034     0.200
     0.241     0.693     0.200
     0.295    -0.284     0.200
     0.722    -0.502     0.200
     0.522     0.618     0.200
     0.555    -0.530     0.200
     0.633     0.391     0.200
     0.672    -0.136     0.200
     0.933    -1.137     0.200
     0.235     0.203     0.200
     0.235     0.192     0.200
     0.289    -0.465     0.200
     0.727     0.152     0.200
     0.129    -0.840     0.200
     0.153     0.242     0.200
     0.339     0.351     0.200
     0.674     0.496     0.200
     0.477     0.220     0.200
     0.496    -0.617     0.200
     0.570     0.709     0.200
     0.590    -0.239     0.200
     0.492    -0.632     0.200
     0.693    -0.213     0.200
     0.195     0.248     0.200
     0.310     0.782     0.200
     0.365    -0.188     0.200
     0.720    -0.392     0.200
     0.640    -1.020     0.200
     0.727    -0.005     0.200
     0.864    -0.076     0.200
     0.165     0.041     0.200
     0.296    -0.134     0.200
     0.274     0.902     0.200
     0.615    -0.902     0.200
     0.509    -0.641     0.200
     0.587     0.568     0.200
     0.852    -1.136     0.200
     0.911     0.211     0.200
     0.148    -0.588     0.200
     0.217     0.237     0.200
     0.599    -0.239     0.200
     0.866     0.592     0.200
     0.066    -0.615     0.200
     0.181     0.483     0.200
     0.537     0.491     0.200
     0.808     0.617     0.200
     0.191     0.066     0.200
     0.345     0.262     0.200
     0.642     0.359     0.200
     0.212     0.052     0.200
     0.283     0.703     0.200
     0.369    -0.594     0.200
     0.728    -0.081     0.200
     0.021    -0.724     0.200
     0.106     0.393     0.200
     0.486     0.410     0.200
     0.806     0.794     0.200
     0.126     0.110     0.200
     0.226    -0.673     0.200
     0.334     0.162     0.200
     0.783     0.348     0.200
     0.814     0.576     0.200
     0.159     0.239     0.200
     0.333     0.652     0.200
     0.410    -0.416     0.200
     0.688    -0.324     0.200
     0.247     0.502     0.200
     0.211    -0.173     0.200
     0.277    -0.480     0.200
     0.685    -0.611     0.200
     0.754     1.581     0.200
     0.973    -1.307     0.200
     0.079    -0.661     0.200
     0.508     0.046     0.200
     0.447     0.688     0.200
     0.664    -0.296     0.200
     0.874    -0.102     0.200
     0.314    -0.748     0.200
     0.392    -0.091     0.200
     0.618    -0.430     0.200
     0.660    -0.692     0.200
     0.688     0.391     0.200
     0.793     0.293     0.200
     0.962     0.096     0.200
     0.958     0.357     0.200
     0.986     0.903     0.200
     0.408    -0.292     0.200
     0.428    -0.723     0.200
     0.483     0.757     0.200
     0.540    -0.781     0.200
     0.684     0.671     0.200
     0.817     0.140     0.200
     0.976    -0.206     0.200
     0.956     0.870     0.200
     0.377    -0.528     0.200
     0.536     0.447     0.200
     0.815     0.044     0.200
     0.926    -0.019     0.200
     0.441    -0.915     0.200
     0.655     0.479     0.200
     0.743     0.852     0.200
     0.544     0.480     0.200
     0.623    -0.402     0.200
     0.929     0.150     0.200
     0.239    -0.171     0.200
     0.396    -0.484     0.200
     0.456    -0.137     0.200
     0.691     0.639     0.200
     0.728     0.937     0.200
     0.788    -1.632     0.200
     0.960    -0.149     0.200
     0.271     0.067     0.200
     0.352    -0.354     0.200
     0.390    -1.020     0.200
     0.780     0.534     0.200
     0.838     0.436     0.200
     0.981    -1.663     0.200
     0.124    -0.724     0.200
     0.542     0.190     0.200
     0.635    -0.469     0.200
     0.814    -0.178     0.200
     0.970     0.382     0.200
     0.267     0.573     0.200
     0.366    -0.637     0.200
     0.361    -0.356     0.200
     0.813     1.398     0.200
     0.799     0.560     0.200
     0.971    -1.163     0.200
     0.817     0.239     0.200
     0.999    -0.848     0.200
     0.233     0.465     0.200
     0.309    -0.545     0.200
     0.238     0.516     0.200
     0.297    -0.384     0.200
     0.430    -0.470     0.200
     0.773     1.188     0.200
     0.869     0.585     0.200
     0.983    -1.312     0.200
     0.697     0.304     0.200
     0.700    -0.889     0.200
     0.823     0.153     0.200
     0.152    -0.780     0.200
     0.487     0.287     0.200
     0.487     0.574     0.200
     0.518    -0.275     0.200
     0.783    -0.149     0.200
     0.963     0.360     0.200
     0.368     0.400     0.200
     0.446    -0.046     0.200
     0.762    -0.041     0.200
     0.798     0.050     0.200
     0.312    -0.481     0.200
     0.510     0.639     0.200
     0.549     0.242     0.200
     0.766    -0.016     0.200
     0.893     0.047     0.200
     0.236     0.549     0.200
     0.312    -0.470     0.200
     0.987    -1.368     0.200
     0.801    -0.734     0.200
     0.238    -0.841     0.200
     0.256     0.132     0.200
     0.466    -0.317     0.200
     0.235    -0.796     0.200
     0.438     0.381     0.200
     0.581     0.430     0.200
     0.607     0.271     0.200
     0.933    -0.039     0.200
     0.390    -0.674     0.200
     0.532    -0.551     0.200
     0.559    -0.621     0.200
     0.790     0.431     0.200
     0.875     0.182     0.200
     0.891     0.370     0.200
     0.982     0.212     0.200
     0.247     0.559     0.200
     0.409    -0.328     0.200
     0.651    -0.287     0.200
     0.877     0.585     0.200
     0.257     0.698     0.200
     0.373    -0.733     0.200
     0.364    -0.317     0.200
     0.804     0.712     0.200
     0.981    -1.576     0.200
     0.186    -0.354     0.200
     0.438     0.613     0.200
     0.619    -1.031     0.200
     0.633    -0.087     0.200
     0.698    -0.388     0.200
     0.772    -0.276     0.200
     0.372    -0.649     0.200
     0.595    -0.381     0.200
     0.715    -0.781     0.200
     0.721     0.028     0.200
     0.709     0.370     0.200
     0.961     0.718     0.200
     0.179    -0.375     0.200
     0.255     0.174     0.200
     0.558    -0.367     0.200
     0.083    -0.396     0.200
     0.355    -0.010     0.200
     0.642    -0.390     0.200
     0.993    -0.407     0.200
     0.229    -0.323     0.200
     0.483     0.361     0.200
     0.544     0.635     0.200
     0.714     0.293     0.200
     0.851     0.076     0.200
     0.980     0.073     0.200
     0.079    -0.425     0.200
     0.359    -0.088     0.200
     0.643    -0.440     0.200
     0.375    -0.416     0.200
     0.406    -0.719     0.200
     0.572    -0.907     0.200
     0.649     0.299     0.200
     0.773     0.179     0.200
     0.950    -0.164     0.200
     0.994     0.727     0.200
     0.139    -0.590     0.200
     0.379     0.330     0.200
     0.726     0.182     0.200
     0.738    -0.221     0.200
     0.893    -0.863     0.200
     0.907    -0.863     0.200
     0.939    -0.220     0.200
     0.349    -0.721     0.200
     0.311     0.104     0.200
     0.331    -0.343     0.200
     0.708     0.133     0.200
     0.793     0.505     0.200
     0.918    -1.116     0.200
     0.307     0.281     0.200
     0.343    -0.627     0.200
     0.345    -0.303     0.200
     0.721     0.070     0.200
     0.785     0.695     0.200
     0.926    -1.222     0.200
     0.240    -0.085     0.200
     0.398    -0.422     0.200
     0.595    -0.684     0.200
     0.689     0.649     0.200
     0.752    -1.362     0.200
     0.945    -0.086     0.200
     0.134    -0.182     0.200
     0.356     0.561     0.200
     0.614    -0.091     0.200
     0.739     0.196     0.200
     0.751    -0.259     0.200
     0.725    -0.777     0.200
     0.985    -0.189     0.200
     0.284     0.139     0.200
     0.370    -0.597     0.200
     0.329    -0.302     0.200
     0.811     0.546     0.200
     0.944    -0.995     0.200
     0.331    -0.533     0.200
     0.351    -0.732     0.200
     0.308     0.028     0.200
     0.710     0.095     0.200
     0.795     0.577     0.200
     0.921    -1.139     0.200
     0.285     0.052     0.200
     0.291    -0.477     0.200
     0.396    -0.497     0.200
     0.705     0.009     0.200
     0.841     0.550     0.200
     0.936    -1.107     0.200
     0.331     0.430     0.200
     0.547     0.001     0.200
     0.565     0.009     0.200
     0.151    -0.556     0.200
     0.375     0.445     0.200
     0.747    -0.348     0.200
     0.727     0.156     0.200
     0.905    -0.937     0.200
     0.929    -0.125     0.200
     0.918    -1.021     0.200
     0.457     0.094     0.200
     0.737    -0.279     0.200
     0.234    -0.696     0.200
     0.312    -0.150     0.200
     0.429    -0.580     0.200
     0.660    -0.371     0.200
     0.911    -0.876     0.200
     0.879     0.373     0.200
     0.174    -0.495     0.200
     0.481    -0.304     0.200
     0.539     0.471     0.200
     0.608     0.123     0.200
     0.859    -0.935     0.200
     0.881     0.068     0.200
     0.947    -1.382     0.200
     0.286    -0.130     0.200
     0.363    -0.770     0.200
     0.337    -0.614     0.200
     0.732    -0.034     0.200
     0.804     0.497     0.200
     0.944    -1.220     0.200
     0.629    -0.396     0.200
     0.614     0.120     0.200
     0.732    -0.667     0.200
     0.908     0.951     0.200
     0.148    -0.560     0.200
     0.543     0.109     0.200
     0.577    -0.382     0.200
     0.774    -0.168     0.200
     0.961    -0.378     0.200
     0.987     0.623     0.200
     0.230    -0.567     0.200
     0.267     0.199     0.200
     0.268     0.686     0.200
     0.406    -0.549     0.200
     0.722    -0.084     0.200
     0.849     0.476     0.200
     0.955    -1.204     0.200
     0.162    -0.496     0.200
     0.305     0.146     0.200
     0.436    -0.488     0.200
     0.664    -0.037     0.200
     0.886     0.496     0.200
     0.918    -0.863     0.200
     0.278     0.408     0.200
     0.318    -0.215     0.200
     0.348    -0.595     0.200
     0.778     0.677     0.200
     0.774     0.113     0.200
     0.971    -1.256     0.200
     0.253    -0.314     0.200
     0.459    -0.384     0.200
     0.578    -0.080     0.200
     0.565     0.555     0.200
     0.938    -0.625     0.200
     0.927     0.100     0.200
     0.220    -0.546     0.200
     0.301     0.224     0.200
     0.387    -0.694     0.200
     0.692    -0.009     0.200
     0.834     0.490     0.200
     0.920    -1.141     0.200
     0.272    -0.309     0.200
     0.342    -0.675     0.200
     0.311     0.295     0.200
     0.715     0.179     0.200
     0.785     0.637     0.200
     0.921    -1.113     0.200
     0.160    -0.357     0.200
     0.401     0.370     0.200
     0.618    -0.174     0.200
     0.661    -0.110     0.200
     0.756     0.142     0.200
     0.913    -0.326     0.200
     0.937    -0.850     0.200
     0.943    -0.066     0.200
     0.231    -0.294     0.200
     0.285     0.448     0.200
     0.391    -0.532     0.200
     0.710     0.143     0.200
     0.835     0.625     0.200
     0.937    -0.911     0.200
     0.392     0.028     0.200
     0.439     0.217     0.200
     0.684     0.210     0.200
     0.835    -0.073     0.200
     0.818    -0.323     0.200
     0.836    -0.355     0.200
     0.408    -0.002     0.200
     0.418     0.085     0.200
     0.718    -0.255     0.200
     0.784    -0.505     0.200
     0.814    -0.227     0.200
     0.865    -0.472     0.200
     0.195     0.423     0.200
     0.319    -0.300     0.200
     0.427    -0.466     0.200
     0.824     0.196     0.200
     0.848     0.593     0.200
     0.160    -0.394     0.200
     0.311     0.083     0.200
     0.434    -0.310     0.200
     0.659    -0.130     0.200
     0.885     0.633     0.200
     0.913    -0.768     0.200
     0.203    -0.521     0.200
     0.258     0.444     0.200
     0.439    -0.399     0.200
     0.716    -0.277     0.200
     0.883     0.662     0.200
     0.963    -1.295     0.200
     0.245    -0.041     0.200
     0.318    -0.516     0.200
     0.436     0.737     0.200
     0.583     0.098     0.200
     0.769     0.548     0.200
     0.786    -1.006     0.200
     0.190    -0.222     0.200
     0.283     0.381     0.200
     0.427    -0.382     0.200
     0.692     0.088     0.200
     0.874     0.536     0.200
     0.937    -0.914     0.200
     0.465    -0.376     0.200
     0.440    -0.710     0.200
     0.808     0.479     0.200
     0.954    -0.251     0.200
     0.267    -0.403     0.200
     0.344    -0.623     0.200
     0.314     0.142     0.200
     0.710     0.264     0.200
     0.788     0.628     0.200
     0.917    -0.957     0.200
     0.272    -0.253     0.200
     0.278     0.110     0.200
     0.368    -0.570     0.200
     0.740     0.292     0.200
     0.807     0.564     0.200
     0.953    -1.043     0.200
     0.549    -0.626     0.200
     0.642    -0.319     0.200
     0.944    -0.695     0.200
     0.271    -0.324     0.200
     0.298    -0.734     0.200
     0.392     0.083     0.200
     0.646     0.181     0.200
     0.749     0.463     0.200
     0.838    -1.089     0.200
     0.126    -0.236     0.200
     0.274     0.164     0.200
     0.554    -0.295     0.200
     0.697    -0.064     0.200
     0.992    -0.603     0.200
     0.256    -0.340     0.200
     0.367    -0.812     0.200
     0.292     0.305     0.200
     0.719     0.144     0.200
     0.810     0.453     0.200
     0.935    -1.266     0.200
     0.271    -0.427     0.200
     0.281     0.202     0.200
     0.282    -0.008     0.200
     0.282     0.922     0.200
     0.366    -0.701     0.200
     0.737     0.002     0.200
     0.806     0.566     0.200
     0.949    -1.294     0.200
     0.221    -0.501     0.200
     0.284     0.086     0.200
     0.399    -0.700     0.200
     0.706     0.176     0.200
     0.845     0.377     0.200
     0.937    -1.042     0.200
     0.268    -0.379     0.200
     0.304     0.252     0.200
     0.350    -0.640     0.200
     0.718     0.146     0.200
     0.793     0.647     0.200
     0.927    -1.187     0.200
     0.156    -0.373     0.200
     0.339     0.180     0.200
     0.421    -0.349     0.200
     0.633     0.218     0.200
     0.884    -0.539     0.200
     0.872     0.657     0.200
     0.263     0.286     0.200
     0.264     0.679     0.200
     0.219    -0.427     0.200
     0.419    -0.440     0.200
     0.719     0.018     0.200
     0.862     0.551     0.200
     0.957    -1.103     0.200
     0.266    -0.504     0.200
     0.298    -0.214     0.200
     0.469     0.286     0.200
     0.470     0.481     0.200
     0.590    -0.045     0.200
     0.716     0.582     0.200
     0.763    -0.921     0.200
     0.973    -0.043     0.200
     0.210    -0.207     0.200
     0.318     0.343     0.200
     0.383    -0.317     0.200
     0.672     0.398     0.200
     0.832     0.564     0.200
     0.902    -0.670     0.200
     0.301     0.363     0.200
     0.283    -0.405     0.200
     0.343    -0.683     0.200
     0.783     0.753     0.200
     0.731     0.068     0.200
     0.935    -1.179     0.200
     0.303    -0.212     0.200
     0.304     0.814     0.200
     0.423    -0.610     0.200
     0.671    -0.411     0.200
     0.872     0.495     0.200
     0.918    -0.424     0.200
     0.200    -0.408     0.200
     0.281     0.280     0.200
     0.282     0.185     0.200
     0.419    -0.311     0.200
     0.698     0.048     0.200
     0.866     0.686     0.200
     0.939    -0.992     0.200
     0.224    -0.444     0.200
     0.281     0.173     0.200
     0.281     0.269     0.200
     0.400    -0.448     0.200
     0.709     0.154     0.200
     0.844     0.593     0.200
     0.940    -0.881     0.200
     0.257    -0.612     0.200
     0.330    -0.019     0.200
     0.386     0.104     0.200
     0.387     0.393     0.200
     0.703     0.653     0.200
     0.869    -1.221     0.200
     0.998    -0.034     0.200
     0.258    -0.224     0.200
     0.366    -0.410     0.200
     0.292     0.126     0.200
     0.293     0.151     0.200
     0.721     0.404     0.200
     0.808     0.631     0.200
     0.936    -0.841     0.200
     0.312    -0.227     0.200
     0.285    -0.627     0.200
     0.531    -0.689     0.200
     0.582    -0.208     0.200
     0.682     0.694     0.200
     0.683     0.198     0.200
     0.917     0.267     0.200
     0.934     0.173     0.200
     0.972     0.451     0.200
     0.177    -0.290     0.200
     0.281     0.275     0.200
     0.282     0.270     0.200
     0.441    -0.322     0.200
     0.689     0.148     0.200
     0.889     0.691     0.200
     0.941    -0.819     0.200
     0.188     0.117     0.200
     0.189     0.159     0.200
     0.312    -0.568     0.200
     0.437    -0.672     0.200
     0.822    -0.155     0.200
     0.859     0.386     0.200
     0.343    -0.121     0.200
     0.561     0.290     0.200
     0.508    -0.185     0.200
     0.509     0.608     0.200
     0.509    -0.123     0.200
     0.682    -0.138     0.200
     0.944    -0.018     0.200
     0.994    -0.336     0.200
     0.128    -0.262     0.200
     0.273     0.251     0.200
     0.273     0.174     0.200
     0.554    -0.272     0.200
     0.699    -0.043     0.200
     0.993    -0.564     0.200
     0.235    -0.441     0.200
     0.378    -0.648     0.200
     0.296     0.140     0.200
     0.297     0.294     0.200
     0.703    -0.002     0.200
     0.824     0.543     0.200
     0.927    -1.097     0.200
     0.227    -0.404     0.200
     0.290     0.071     0.200
     0.289     0.077     0.200
     0.390    -0.381     0.200
     0.705     0.125     0.200
     0.835     0.728     0.200
     0.933    -0.848     0.200
     0.273     0.448     0.200
     0.274     0.344     0.200
     0.307    -0.402     0.200
     0.356    -0.721     0.200
     0.769    -0.001     0.200
     0.787     0.580     0.200
     0.971    -1.178     0.200
     0.182    -0.422     0.200
     0.291     0.211     0.200
     0.291     0.405     0.200
     0.428    -0.376     0.200
     0.683     0.061     0.200
     0.876     0.611     0.200
     0.931    -1.024     0.200
     0.139    -0.637     0.200
     0.461    -0.132     0.200
     0.478     0.605     0.200
     0.479    -0.404     0.200
     0.572     0.520     0.200
     0.762    -0.395     0.200
     0.865    -0.693     0.200
     0.883     0.198     0.200
     0.190    -0.337     0.200
     0.276     0.207     0.200
     0.277     0.202     0.200
     0.433    -0.312     0.200
     0.697     0.097     0.200
     0.880     0.619     0.200
     0.945    -0.567     0.200
     0.189    -0.064     0.200
     0.451     0.456     0.200
     0.569     0.134     0.200
     0.640    -0.228     0.200
     0.813    -0.043     0.200
     0.929    -0.752     0.200
     0.971    -0.185     0.200
     0.976    -0.899     0.200
     0.345    -0.650     0.200
     0.266    -0.318     0.200
     0.313     0.231     0.200
     0.314     0.123     0.200
     0.710     0.192     0.200
     0.789     0.641     0.200
     0.918    -1.023     0.200
     0.360    -0.076     0.200
     0.509     0.170     0.200
     0.508    -0.119     0.200
     0.572     0.311     0.200
     0.691    -0.138     0.200
     0.956     0.111     0.200
     0.994    -0.060     0.200
     0.267    -0.342     0.200
     0.351    -0.711     0.200
     0.305     0.178     0.200
     0.304     0.285     0.200
     0.718     0.087     0.200
     0.793     0.571     0.200
     0.926    -1.149     0.200
     0.160    -0.410     0.200
     0.320     0.097     0.200
     0.320    -0.108     0.200
     0.320     0.373     0.200
     0.428    -0.366     0.200
     0.652     0.138     0.200
     0.903    -0.370     0.200
     0.879     0.691     0.200
     0.221    -0.331     0.200
     0.255     0.460     0.200
     0.425    -0.467     0.200
     0.726    -0.004     0.200
     0.868     0.660     0.200
     0.966    -1.034     0.200
     0.202    -0.332     0.200
     0.198     0.009     0.200
     0.554    -0.381     0.200
     0.768     0.061     0.200
     0.995     0.786     0.200
     0.091    -0.168     0.200
     0.365     0.615     0.200
     0.649    -0.156     0.200
     0.657    -0.185     0.200
     0.795    -0.565     0.200
     0.780    -0.604     0.200
     0.978    -0.291     0.200
     0.453    -0.311     0.200
     0.462    -0.139     0.200
     0.715     0.446     0.200
     0.819     0.450     0.200
     0.819     0.253     0.200
     0.831    -0.422     0.200
     0.882    -0.230     0.200
     0.938    -0.317     0.200
     0.947     0.169     0.200
     0.638    -0.189     0.200
     0.251    -0.067     0.200
     0.328     0.130     0.200
     0.447     0.460     0.200
     0.588    -0.106     0.200
     0.692    -0.264     0.200
     0.823     0.149     0.200
     0.930    -0.202     0.200
     0.994    -0.754     0.200
     0.222    -0.511     0.200
     0.283     0.081     0.200
     0.284     0.075     0.200
     0.399    -0.500     0.200
     0.706     0.065     0.200
     0.844     0.574     0.200
     0.938    -0.956     0.200
     0.122    -0.633     0.200
     0.477     0.138     0.200
     0.513    -0.040     0.200
     0.559    -0.768     0.200
     0.677    -0.435     0.200
     0.917    -0.445     0.200
     0.154    -0.443     0.200
     0.244    -0.245     0.200
     0.367    -0.705     0.200
     0.304     0.833     0.200
     0.304     0.333     0.200
     0.304     0.044     0.200
     0.303     0.238     0.200
     0.704     0.298     0.200
     0.812     0.386     0.200
     0.922    -1.048     0.200
     0.257    -0.696     0.200
     0.330    -0.107     0.200
     0.387     0.012     0.200
     0.703     0.570     0.200
     0.701    -0.223     0.200
     0.869    -1.207     0.200
     0.998    -0.117     0.200
     0.195    -0.406     0.200
     0.283     0.235     0.200
     0.283     0.432     0.200
     0.423    -0.376     0.200
     0.694     0.052     0.200
     0.870     0.502     0.200
     0.938    -0.908     0.200
     0.200    -0.444     0.200
     0.292    -0.064     0.200
     0.292     0.430     0.200
     0.292    -0.070     0.200
     0.411    -0.738     0.200
     0.690     0.140     0.200
     0.858     0.149     0.200
     0.929    -1.109     0.200
     0.349    -0.243     0.200
     0.536     0.012     0.200
     0.688     0.295     0.200
     0.857     0.387     0.200
     0.879    -0.085     0.200
     0.946    -0.310     0.200
     0.951     0.174     0.200
     0.998     0.453     0.200
     0.121    -0.286     0.200
     0.286     0.330     0.200
     0.274    -0.276     0.200
     0.360    -0.416     0.200
     0.735     0.088     0.200
     0.800     0.687     0.200
     0.945    -1.232     0.200
     0.154    -0.337     0.200
     0.321     0.215     0.200
     0.322     0.209     0.200
     0.322     0.408     0.200
     0.322     0.068     0.200
     0.433    -0.295     0.200
     0.648     0.167     0.200
     0.884     0.601     0.200
     0.903    -0.686     0.200
     0.858    -0.489     0.200
     0.999     0.301     0.200
     0.271    -0.184     0.200
     0.302     0.385     0.200
     0.303     0.279     0.200
     0.350    -0.620     0.200
     0.722     0.221     0.200
     0.792     0.675     0.200
     0.930    -0.705     0.200
     0.783    -0.124     0.200
     0.979     0.277     0.200
     0.303    -0.216     0.200
     0.310    -0.392     0.200
     0.500    -0.601     0.200
     0.588    -0.179     0.200
     0.662     0.369     0.200
     0.906     0.149     0.200
     0.948     0.174     0.200
     0.985     0.468     0.200
     0.128    -0.463     0.200
     0.272    -0.023     0.200
     0.272    -0.046     0.200
     0.546    -0.281     0.200
     0.697    -0.224     0.200
     0.995     0.565     0.200
     0.989    -0.809     0.200
     0.270    -0.372     0.200
     0.300     0.208     0.200
     0.301     0.300     0.200
     0.352    -0.729     0.200
     0.723     0.115     0.200
     0.794     0.558     0.200
     0.931    -1.119     0.200
     0.270    -0.374     0.200
     0.240    -0.206     0.200
     0.280    -0.330     0.200
     0.325    -0.952     0.200
     0.386     0.090     0.200
     0.450     0.530     0.200
     0.451     0.144     0.200
     0.451     0.724     0.200
     0.566    -0.010     0.200
     0.774     0.396     0.200
     0.772    -0.924     0.200
     0.229    -0.572     0.200
     0.188    -0.352     0.200
     0.341    -0.195     0.200
     0.341     0.019     0.200
     0.389    -0.635     0.200
     0.399     0.493     0.200
     0.644     0.472     0.200
     0.840     0.298     0.200
     0.880    -0.743     0.200
     0.162    -0.607     0.200
     0.243    -0.178     0.200
     0.284     0.131     0.200
     0.285     0.055     0.200
     0.285    -0.176     0.200
     0.382    -0.613     0.200
     0.469     0.450     0.200
     0.717     0.289     0.200
     0.825     0.361     0.200
     0.940    -1.052     0.200
     0.164    -0.325     0.200
     0.241    -0.486     0.200
     0.283     0.317     0.200
     0.384    -0.469     0.200
     0.468     0.222     0.200
     0.717     0.123     0.200
     0.828     0.544     0.200
     0.941    -0.950     0.200
     0.309     0.306     0.200
     0.163    -0.429     0.200
     0.242    -0.334     0.200
     0.393     0.125     0.200
     0.432    -0.452     0.200
     0.662    -0.181     0.200
     0.882     0.480     0.200
     0.914    -0.968     0.200
     0.411    -0.202     0.200
     0.492    -0.575     0.200
     0.579    -0.616     0.200
     0.782     0.007     0.200
     0.851     0.836     0.200
     0.874     0.306     0.200
     0.136    -0.245     0.200
     0.273    -0.254     0.200
     0.300    -0.140     0.200
     0.299     0.344     0.200
     0.351    -0.611     0.200
     0.492     0.216     0.200
     0.726     0.072     0.200
     0.792     0.554     0.200
     0.933    -1.295     0.200
     0.938     1.594     0.200
     0.337    -0.188     0.200
     0.376    -0.247     0.200
     0.458     0.367     0.200
     0.622    -0.069     0.200
     0.765    -0.111     0.200
     0.848     0.111     0.200
     0.881    -0.042     0.200
     0.958     0.342     0.200
     0.198     0.024     0.200
     0.198     0.270     0.200
     0.198     0.020     0.200
     0.246    -0.263     0.200
     0.213    -0.473     0.200
     0.510    -0.379     0.200
     0.462    -0.068     0.200
     0.765    -0.101     0.200
     0.950     0.697     0.200
     0.918     1.018     0.200
     0.174    -0.464     0.200
     0.234    -0.269     0.200
     0.320     0.232     0.200
     0.397     0.003     0.200
     0.414    -0.362     0.200
     0.656    -0.197     0.200
     0.847     1.041     0.200
     0.864     0.626     0.200
     0.901    -0.780     0.200
     0.134    -0.444     0.200
     0.188     0.390     0.200
     0.313    -0.304     0.200
     0.436    -0.386     0.200
     0.555     0.225     0.200
     0.823     0.108     0.200
     0.857     0.577     0.200
     0.146    -0.363     0.200
     0.260    -0.573     0.200
     0.317     0.004     0.200
     0.318    -0.400     0.200
     0.318     0.180     0.200
     0.444    -0.433     0.200
     0.376     0.217     0.200
     0.650     0.142     0.200
     0.895     0.372     0.200
     0.829     1.409     0.200
     0.909    -0.852     0.200
     0.193    -0.424     0.200
     0.292     0.002     0.200
     0.292     0.222     0.200
     0.291     0.008     0.200
     0.213    -0.447     0.200
     0.400    -0.468     0.200
     0.440     0.162     0.200
     0.696     0.138     0.200
     0.847     0.359     0.200
     0.929    -0.948     0.200
     0.266     0.365     0.200
     0.267     0.360     0.200
     0.267     0.251     0.200
     0.192    -0.480     0.200
     0.217    -0.212     0.200
     0.430    -0.010     0.200
     0.441    -0.337     0.200
     0.705    -0.067     0.200
     0.887     0.802     0.200
     0.884     1.146     0.200
     0.955    -0.712     0.200
     0.167    -0.265     0.200
     0.239    -0.382     0.200
     0.267     0.429     0.200
     0.268     0.322     0.200
     0.268     0.431     0.200
     0.399    -0.484     0.200
     0.470     0.136     0.200
     0.727     0.095     0.200
     0.841     0.590     0.200
     0.922     1.474     0.200
     0.955    -1.111     0.200
     0.100    -0.196     0.200
     0.245    -0.482     0.200
     0.466    -0.372     0.200
     0.484     1.126     0.200
     0.620    -0.140     0.200
     0.621     0.458     0.200
     0.648    -0.209     0.200
     0.755    -0.158     0.200
     0.858    -0.387     0.200
     0.892     0.579     0.200
     0.130    -0.264     0.200
     0.271     0.181     0.200
     0.271     0.078     0.200
     0.328    -0.165     0.200
     0.377     0.107     0.200
     0.555    -0.423     0.200
     0.701    -0.124     0.200
     0.831     1.196     0.200
     0.996    -0.667     0.200
     0.187    -0.316     0.200
     0.275     0.213     0.200
     0.219    -0.407     0.200
     0.408    -0.345     0.200
     0.450     0.063     0.200
     0.710    -0.010     0.200
     0.853     0.624     0.200
     0.902     1.411     0.200
     0.945    -1.006     0.200
     0.100    -0.174     0.200
     0.223    -0.201     0.200
     0.353    -0.502     0.200
     0.513     1.450     0.200
     0.619     0.197     0.200
     0.620     0.491     0.200
     0.597    -0.513     0.200
     0.700    -0.571     0.200
     0.915     1.000     0.200
     0.131    -0.199     0.200
     0.294     0.358     0.200
     0.295     0.586     0.200
     0.295     0.453     0.200
     0.277    -0.313     0.200
     0.352    -0.627     0.200
     0.498     0.209     0.200
     0.732    -0.087     0.200
     0.792     0.582     0.200
     0.939    -1.313     0.200
     0.944     1.384     0.200
     0.292     0.177     0.200
     0.329    -0.046     0.200
     0.335    -0.410     0.200
     0.447    -0.405     0.200
     0.512    -0.403     0.200
     0.567    -0.597     0.200
     0.617     0.971     0.200
     0.847     0.368     0.200
     0.977     0.246     0.200
     0.990     0.180     0.200
     0.199    -0.656     0.200
     0.350     0.469     0.200
     0.425    -0.955     0.200
     0.555    -0.269     0.200
     0.535     1.523     0.200
     0.668    -0.394     0.200
     0.823     0.477     0.200
     0.823     0.180     0.200
     0.821    -0.020     0.200
     0.902     0.180     0.200
     0.874     0.861     0.200
     0.216    -0.006     0.200
     0.367     0.470     0.200
     0.415    -0.635     0.200
     0.476     0.092     0.200
     0.539    -0.282     0.200
     0.556     1.002     0.200
     0.661    -0.552     0.200
     0.882     0.216     0.200
     0.891     0.268     0.200
     0.983    -0.108     0.200
     0.227    -0.376     0.200
     0.316    -0.340     0.200
     0.324    -0.293     0.200
     0.436     0.313     0.200
     0.593     0.459     0.200
     0.593    -0.160     0.200
     0.592    -0.232     0.200
     0.681    -0.010     0.200
     0.808     0.008     0.200
     0.935    -0.193     0.200
     0.972    -0.348     0.200
     0.157    -0.438     0.200
     0.256    -0.216     0.200
     0.313     0.279     0.200
     0.313     0.166     0.200
     0.351    -0.675     0.200
     0.472     0.403     0.200
     0.704     0.254     0.200
     0.796     0.631     0.200
     0.917     1.819     0.200
     0.915    -1.018     0.200
     0.541    -0.083     0.200
     0.571    -0.333     0.200
     0.713    -0.353     0.200
     0.704    -0.079     0.200
     0.871     0.015     0.200
     0.961    -0.461     0.200
     0.235    -0.421     0.200
     0.411    -0.036     0.200
     0.586     1.273     0.200
     0.674    -0.050     0.200
     0.850     0.135     0.200
     0.790     0.825     0.200
     0.908     0.718     0.200
     0.158    -0.267     0.200
     0.248    -0.276     0.200
     0.331    -0.418     0.200
     0.542    -0.287     0.200
     0.550    -0.301     0.200
     0.631     0.609     0.200
     0.536     1.280     0.200
     0.652    -0.213     0.200
     0.931     0.589     0.200
     0.970     0.284     0.200
     0.457    -0.634     0.200
     0.517     0.065     0.200
     0.578     0.025     0.200
     0.762    -0.306     0.200
     0.753     0.609     0.200
     0.823    -0.090     0.200
     0.975     0.637     0.200
     0.508     0.179     0.200
     0.594    -0.305     0.200
     0.747     0.571     0.200
     0.916     0.077     0.200
     0.162    -0.442     0.200
     0.235    -0.313     0.200
     0.246    -0.376     0.200
     0.327     0.152     0.200
     0.328     0.170     0.200
     0.421    -0.462     0.200
     0.384     0.081     0.200
     0.646    -0.119     0.200
     0.872     0.392     0.200
     0.835     1.158     0.200
     0.896    -1.052     0.200
     0.213    -0.300     0.200
     0.193    -0.397     0.200
     0.286     0.204     0.200
     0.422    -0.392     0.200
     0.424     0.105     0.200
     0.691     0.046     0.200
     0.869     0.544     0.200
     0.877     1.357     0.200
     0.934    -1.032     0.200
     0.100    -0.266     0.200
     0.149    -0.330     0.200
     0.454    -0.702     0.200
     0.547    -0.229     0.200
     0.547     0.373     0.200
     0.547     0.276     0.200
     0.539    -0.035     0.200
     0.556     0.676     0.200
     0.637    -0.346     0.200
     0.811    -0.682     0.200
     0.965     0.315     0.200
     0.965     0.440     0.200
     0.164    -0.431     0.200
     0.244    -0.286     0.200
     0.298     0.332     0.200
     0.299     0.526     0.200
     0.370    -0.679     0.200
     0.465     0.344     0.200
     0.707     0.215     0.200
     0.815     0.405     0.200
     0.913     1.782     0.200
     0.926    -1.145     0.200
     0.270    -0.025     0.200
     0.219    -0.236     0.200
     0.547    -0.064     0.200
     0.547     0.029     0.200
     0.478     0.429     0.200
     0.639    -0.077     0.200
     0.825     0.441     0.200
     0.844     0.174     0.200
     0.950    -0.436     0.200
     0.980     0.005     0.200
     0.496    -0.146     0.200
     0.608    -0.085     0.200
     0.651    -0.197     0.200
     0.754    -0.290     0.200
     0.851    -0.160     0.200
     0.851    -0.270     0.200
     0.851     0.136     0.200
     0.978    -0.106     0.200
     0.132    -0.294     0.200
     0.287     0.301     0.200
     0.288     0.494     0.200
     0.275    -0.305     0.200
     0.359    -0.601     0.200
     0.497     0.176     0.200
     0.799     0.545     0.200
     0.735     0.020     0.200
     0.175    -0.291     0.200
     0.256     0.430     0.200
     0.256     0.526     0.200
     0.233    -0.425     0.200
     0.415    -0.484     0.200
     0.468     0.106     0.200
     0.732    -0.085     0.200
     0.856     0.583     0.200
     0.921     1.475     0.200
     0.965    -0.551     0.200
     0.148    -0.208     0.200
     0.257    -0.198     0.200
     0.304     0.358     0.200
     0.305     0.052     0.200
     0.305     0.345     0.200
     0.383     0.393     0.200
     0.452    -0.377     0.200
     0.662     0.013     0.200
     0.837     1.405     0.200
     0.902     0.472     0.200
     0.923    -0.536     0.200
     0.143    -0.349     0.200
     0.264    -0.193     0.200
     0.298     0.356     0.200
     0.298     0.260     0.200
     0.382     0.068     0.200
     0.464    -0.423     0.200
     0.667    -0.148     0.200
     0.837     1.119     0.200
     0.914     0.538     0.200
     0.932    -0.935     0.200
     0.126    -0.549     0.200
     0.261    -0.730     0.200
     0.341    -0.170     0.200
     0.372     0.231     0.200
     0.535     0.308     0.200
     0.702     0.572     0.200
     0.967     1.636     0.200
     0.154    -0.320     0.200
     0.251    -0.241     0.200
     0.316     0.366     0.200
     0.315     0.312     0.200
     0.383     0.262     0.200
     0.436    -0.422     0.200
     0.836     1.363     0.200
     0.887     0.561     0.200
     0.909    -0.901     0.200
     0.218    -0.360     0.200
     0.193    -0.372     0.200
     0.260     0.267     0.200
     0.447    -0.419     0.200
     0.432     0.139     0.200
     0.892     0.558     0.200
     0.887     1.422     0.200
     0.961    -0.560     0.200
     0.185    -0.288     0.200
     0.255     0.332     0.200
     0.256     0.527     0.200
     0.225    -0.445     0.200
     0.422    -0.476     0.200
     0.461     0.039     0.200
     0.864     0.513     0.200
     0.914     1.338     0.200
     0.966    -1.138     0.200
     0.193    -0.398     0.200
     0.212    -0.266     0.200
     0.286     0.261     0.200
     0.286     0.122     0.200
     0.286     0.365     0.200
     0.286     0.865     0.200
     0.405    -0.388     0.200
     0.441     0.327     0.200
     0.699     0.190     0.200
     0.851     0.634     0.200
     0.893     1.617     0.200
     0.935    -0.886     0.200
     0.132    -0.305     0.200
     0.301     0.383     0.200
     0.301     0.273     0.200
     0.300     0.350     0.200
     0.277    -0.319     0.200
     0.347    -0.724     0.200
     0.496     0.140     0.200
     0.728    -0.008     0.200
     0.788     0.636     0.200
     0.933    -1.270     0.200
     0.942     1.442     0.200
     0.224    -0.341     0.200
     0.182    -0.430     0.200
     0.289     0.219     0.200
     0.290     0.268     0.200
     0.430    -0.432     0.200
     0.415     0.136     0.200
     0.684     0.062     0.200
     0.878     0.562     0.200
     0.868     1.335     0.200
     0.932    -0.951     0.200
     0.205    -0.474     0.200
     0.298     0.131     0.200
     0.298     0.232     0.200
     0.297     0.148     0.200
     0.431     0.085     0.200
     0.687    -0.021     0.200
     0.850     0.274     0.200
     0.882     1.376     0.200
     0.923    -1.206     0.200
     0.133    -0.416     0.200
     0.277    -0.276     0.200
     0.345     0.170     0.200
     0.354     0.201     0.200
     0.440    -0.378     0.200
     0.622    -0.058     0.200
     0.805     1.249     0.200
     0.892     0.544     0.200
     0.883    -0.759     0.200
     0.167    -0.440     0.200
     0.239    -0.573     0.200
     0.277     0.122     0.200
     0.277     0.462     0.200
     0.277     0.370     0.200
     0.277     0.217     0.200
     0.392    -0.513     0.200
     0.467    -0.049     0.200
     0.720    -0.083     0.200
     0.835     0.607     0.200
     0.918     1.298     0.200
     0.946    -1.091     0.200
     0.690    -0.486     0.200
     0.957     0.817     0.200
     0.606     0.083     0.200
     0.667    -0.560     0.200
     0.673    -0.316     0.200
     0.762     0.300     0.200
     0.853    -0.054     0.200
     0.949     0.302     0.200
     0.181    -0.462     0.200
     0.225    -0.335     0.200
     0.295     0.202     0.200
     0.295     0.098     0.200
     0.412     0.068     0.200
     0.426    -0.432     0.200
     0.679     0.002     0.200
     0.875     0.606     0.200
     0.864     1.257     0.200
     0.927    -0.761     0.200
     0.325     0.176     0.200
     0.304    -0.201     0.200
     0.454    -0.195     0.200
     0.715     0.033     0.200
     0.726     0.666     0.200
     0.727    -0.324     0.200
     0.727     0.656     0.200
     0.900    -0.362     0.200
     0.812    -0.444     0.200
     0.134    -0.319     0.200
     0.274    -0.289     0.200
     0.295     0.292     0.200
     0.353    -0.672     0.200
     0.495     0.104     0.200
     0.729     0.024     0.200
     0.794     0.491     0.200
     0.941     1.663     0.200
     0.937    -1.150     0.200
     0.236    -0.568     0.200
     0.343    -0.409     0.200
     0.496     0.823     0.200
     0.633     0.236     0.200
     0.613    -0.301     0.200
     0.697    -0.180     0.200
     0.899     0.444     0.200
     0.242    -0.314     0.200
     0.266    -0.171     0.200
     0.493     0.425     0.200
     0.536    -0.036     0.200
     0.537     0.346     0.200
     0.644    -0.223     0.200
     0.835     0.261     0.200
     0.863     0.014     0.200
     0.983    -0.148     0.200
     0.968    -0.716     0.200
     0.206    -0.098     0.200
     0.201    -0.611     0.200
     0.276     0.442     0.200
     0.276     0.604     0.200
     0.424    -0.216     0.200
     0.434    -0.237     0.200
     0.702    -0.451     0.200
     0.888     0.723     0.200
     0.945    -1.018     0.200
     0.721    -0.459     0.200
     0.672    -0.480     0.200
     0.456    -0.079     0.200
     0.677    -0.235     0.200
     0.704    -0.368     0.200
     0.745     0.639     0.200
     0.997     0.409     0.200
     0.461    -0.228     0.200
     0.620     0.334     0.200
     0.816    -0.274     0.200
     0.802     1.143     0.200
     0.360     0.716     0.200
     0.561     0.471     0.200
     0.599     0.972     0.200
     0.309    -0.533     0.200
     0.396     0.792     0.200
     0.480     0.364     0.200
     0.655    -0.228     0.200
     0.693     0.974     0.200
     0.727    -0.212     0.200
     0.718     0.063     0.200
     0.822     1.574     0.200
     0.403     0.683     0.200
     0.631     0.072     0.200
     0.685     0.991     0.200
     0.738     0.319     0.200
     0.800     1.616     0.200
     0.370     0.811     0.200
     0.501     0.315     0.200
     0.679    -0.513     0.200
     0.688     0.194     0.200
     0.680     0.881     0.200
     0.749    -0.312     0.200
     0.833     1.190     0.200
     0.400     0.550     0.200
     0.470     0.124     0.200
     0.674    -0.534     0.200
     0.706    -0.148     0.200
     0.709     0.746     0.200
     0.845     1.239     0.200
     0.336    -0.664     0.200
     0.453     0.166     0.200
     0.413     0.764     0.200
     0.701    -0.434     0.200
     0.704    -0.549     0.200
     0.692     0.012     0.200
     0.738     0.861     0.200
     0.882     1.295     0.200
     0.364    -0.378     0.200
     0.444     0.415     0.200
     0.423     0.818     0.200
     0.692    -0.207     0.200
     0.672     0.267     0.200
     0.741    -0.324     0.200
     0.767     0.980     0.200
     0.924     1.504     0.200
     0.979     0.608     0.200
     0.402     0.515     0.200
     0.471     0.412     0.200
     0.663    -0.178     0.200
     0.719    -0.118     0.200
     0.715    -0.021     0.200
     0.704     0.928     0.200
     0.834     1.560     0.200
     0.456     0.209     0.200
     0.411     0.389     0.200
     0.687    -0.520     0.200
     0.703     0.084     0.200
     0.728     0.764     0.200
     0.302    -0.329     0.200
     0.419     0.761     0.200
     0.452     0.517     0.200
     0.663    -0.144     0.200
     0.700    -0.070     0.200
     0.723     0.928     0.200
     0.724    -0.034     0.200
     0.365    -0.535     0.200
     0.418     0.730     0.200
     0.697    -0.379     0.200
     0.670     0.203     0.200
     0.739    -0.476     0.200
     0.761     0.848     0.200
     0.919     1.355     0.200
     0.980     0.554     0.200
     0.372     0.522     0.200
     0.590    -0.287     0.200
     0.611     0.766     0.200
     0.755     0.179     0.200
     0.725     1.257     0.200
     0.951     1.300     0.200
     0.357    -0.260     0.200
     0.447     0.411     0.200
     0.419     0.932     0.200
     0.695    -0.196     0.200
     0.677     0.271     0.200
     0.731    -0.215     0.200
     0.758     1.013     0.200
     0.912     1.656     0.200
     0.989     0.567     0.200
     0.033     0.519     0.200
     0.333    -0.372     0.200
     0.453     0.371     0.200
     0.412     1.001     0.200
     0.702    -0.315     0.200
     0.700    -0.056     0.200
     0.695     0.294     0.200
     0.736     1.049     0.200
     0.878     1.446     0.200
     0.046     0.503     0.200
     0.341    -0.518     0.200
     0.390     1.097     0.200
     0.477     0.316     0.200
     0.697    -0.357     0.200
     0.725    -0.354     0.200
     0.685     0.311     0.200
     0.712     1.076     0.200
     0.864     1.368     0.200
     0.367     0.626     0.200
     0.554     0.062     0.200
     0.592    -0.507     0.200
     0.606     0.835     0.200
     0.752     0.036     0.200
     0.723     1.165     0.200
     0.797     0.008     0.200
     0.947     1.136     0.200
     0.367    -0.592     0.200
     0.451     0.158     0.200
     0.416     0.756     0.200
     0.698    -0.442     0.200
     0.667     0.207     0.200
     0.742    -0.303     0.200
     0.761     0.910     0.200
     0.921     1.437     0.200
     0.978     0.645     0.200
     0.384     0.873     0.200
     0.487     0.386     0.200
     0.671    -0.333     0.200
     0.735    -0.099     0.200
     0.700     0.180     0.200
     0.365     0.864     0.200
     0.505     0.296     0.200
     0.681    -0.214     0.200
     0.685     0.062     0.200
     0.676     0.903     0.200
     0.753    -0.311     0.200
     0.833     1.540     0.200
     0.451     0.164     0.200
     0.417     0.271     0.200
     0.664    -0.092     0.200
     0.747    -0.140     0.200
     0.763     0.696     0.200
     0.696    -0.524     0.200
     0.606    -0.435     0.200
     0.616     0.811     0.200
     0.740    -0.050     0.200
     0.790    -0.101     0.200
     0.963     1.293     0.200
     0.487     0.286     0.200
     0.384     0.358     0.200
     0.673    -0.452     0.200
     0.735    -0.299     0.200
     0.699    -0.179     0.200
     0.180     0.664     0.200
     0.732     0.174     0.200
     0.767     1.673     0.200
     0.832    -0.476     0.200
     0.455     0.019     0.200
     0.412     0.332     0.200
     0.739    -0.402     0.200
     0.372     0.670     0.200
     0.509     0.068     0.200
     0.650    -0.577     0.200
     0.710    -0.028     0.200
     0.756    -0.170     0.200
     0.662     0.677     0.200
     0.802     1.129     0.200
     0.364    -0.294     0.200
     0.446     0.320     0.200
     0.420     0.783     0.200
     0.672     0.267     0.200
     0.695    -0.276     0.200
     0.739    -0.278     0.200
     0.763     0.966     0.200
     0.981     0.473     0.200
     0.447     0.234     0.200
     0.423     0.560     0.200
     0.660     0.154     0.200
     0.757    -0.739     0.200
     0.774     0.563     0.200
     0.938     1.137     0.200
     0.963     0.509     0.200
     0.380     0.538     0.200
     0.499     0.331     0.200
     0.714    -0.228     0.200
     0.650    -0.069     0.200
     0.672     0.830     0.200
     0.807     1.523     0.200
     0.394     0.803     0.200
     0.618    -0.405     0.200
     0.744     0.002     0.200
     0.742     0.118     0.200
     0.394     0.660     0.200
     0.474     0.226     0.200
     0.683    -0.426     0.200
     0.722    -0.346     0.200
     0.697     0.082     0.200
     0.708     0.938     0.200
     0.851     1.394     0.200
     0.374     0.521     0.200
     0.499     0.108     0.200
     0.697    -0.086     0.200
     0.670    -0.409     0.200
     0.747    -0.325     0.200
     0.679     0.724     0.200
     0.826     1.229     0.200
     0.388     0.466     0.200
     0.524    -0.116     0.200
     0.592    -0.622     0.200
     0.636     0.640     0.200
     0.767    -0.123     0.200
     0.759    -0.110     0.200
     0.399     0.348     0.200
     0.484     0.044     0.200
     0.636    -0.522     0.200
     0.730    -0.171     0.200
     0.683     0.633     0.200
     0.732    -0.129     0.200
     0.803     1.232     0.200
     0.468     0.186     0.200
     0.399     0.592     0.200
     0.717    -0.345     0.200
     0.687    -0.373     0.200
     0.697     0.078     0.200
     0.716     0.887     0.200
     0.858     1.378     0.200
     0.393     0.547     0.200
     0.476     0.264     0.200
     0.679    -0.390     0.200
     0.724    -0.294     0.200
     0.704     0.815     0.200
     0.699    -0.017     0.200
     0.447    -0.071     0.200
     0.423     0.276     0.200
     0.694    -0.322     0.200
     0.757    -0.116     0.200
     0.774     0.768     0.200
     0.963     0.398     0.200
     0.396     0.544     0.200
     0.480     0.292     0.200
     0.654    -0.317     0.200
     0.728    -0.075     0.200
     0.692     0.787     0.200
     0.718     0.054     0.200
     0.821     1.284     0.200
     0.538    -0.317     0.200
     0.674    -0.953     0.200
     0.785    -0.078     0.200
     0.376     0.356     0.200
     0.553    -0.030     0.200
     0.580    -0.553     0.200
     0.606     0.590     0.200
     0.713     0.985     0.200
     0.795    -0.120     0.200
     0.764    -0.100     0.200
     0.941     1.133     0.200
     0.398     0.326     0.200
     0.470     0.120     0.200
     0.681    -0.536     0.200
     0.719    -0.377     0.200
     0.700    -0.134     0.200
     0.711     0.777     0.200
     0.852     1.270     0.200
     0.452    -0.020     0.200
     0.415     0.183     0.200
     0.700    -0.430     0.200
     0.739    -0.447     0.200
     0.758     0.635     0.200
     0.981     0.330     0.200
     0.402     0.438     0.200
     0.480     0.073     0.200
     0.637    -0.510     0.200
     0.687     0.680     0.200
     0.805     1.264     0.200
     0.384     0.741     0.200
     0.488     0.278     0.200
     0.669    -0.392     0.200
     0.702     0.105     0.200
     0.736    -0.277     0.200
     0.689     0.883     0.200
     0.831     1.437     0.200
     0.476    -0.070     0.200
     0.725    -0.210     0.200
     0.694    -0.482     0.200
     0.687    -0.408     0.200
     0.711     0.281     0.200
     0.861     1.168     0.200
     0.363     0.429     0.200
     0.551     0.012     0.200
     0.601    -0.837     0.200
     0.744    -0.127     0.200
     0.794    -0.161     0.200
     0.017     0.477     0.200
     0.356    -0.346     0.200
     0.441     0.515     0.200
     0.426     0.837     0.200
     0.689    -0.219     0.200
     0.679     0.216     0.200
     0.733    -0.467     0.200
     0.766     0.916     0.200
     0.917     1.411     0.200
     0.987     0.487     0.200
     0.452     0.223     0.200
     0.414     0.692     0.200
     0.701    -0.441     0.200
     0.692    -0.211     0.200
     0.701    -0.104     0.200
     0.733     1.041     0.200
     0.871     1.468     0.200
     0.218    -0.260     0.200
     0.188    -0.469     0.200
     0.281     0.328     0.200
     0.282    -0.122     0.200
     0.431    -0.430     0.200
     0.422     0.009     0.200
     0.693    -0.154     0.200
     0.878     0.362     0.200
     0.876     1.109     0.200
     0.940    -0.927     0.200
     0.031     0.452     0.200
     0.331    -0.327     0.200
     0.440     0.469     0.200
     0.425     0.816     0.200
     0.689    -0.269     0.200
     0.700     0.114     0.200
     0.703    -0.540     0.200
     0.750     0.888     0.200
     0.887     1.373     0.200
     0.375     0.592     0.200
     0.525     0.089     0.200
     0.614    -0.486     0.200
     0.738     0.006     0.200
     0.770    -0.051     0.200
     0.760     1.068     0.200
     0.986     1.013     0.200
     0.743    -0.659     0.200
     0.433     0.060     0.200
     0.506     0.718     0.200
     0.654     0.622     0.200
     0.810    -0.525     0.200
     0.965     1.309     0.200
     0.651    -0.381     0.200
     0.928     1.192     0.200
     0.394     0.763     0.200
     0.476     0.329     0.200
     0.675    -0.290     0.200
     0.702     0.138     0.200
     0.724    -0.249     0.200
     0.703     0.945     0.200
     0.843     1.518     0.200
     0.358    -0.496     0.200
     0.425     0.105     0.200
     0.443     0.791     0.200
     0.673    -0.476     0.200
     0.684     0.229     0.200
     0.742    -0.436     0.200
     0.785     0.894     0.200
     0.979     0.457     0.200
     0.933     1.328     0.200
     0.414     0.328     0.200
     0.451    -0.003     0.200
     0.700    -0.374     0.200
     0.723    -0.398     0.200
     0.570    -0.166     0.200
     0.578    -0.592     0.200
     0.589     0.652     0.200
     0.701     0.894     0.200
     0.812    -0.349     0.200
     0.924     1.005     0.200
     0.154    -0.606     0.200
     0.287     0.049     0.200
     0.390     0.364     0.200
     0.390     0.214     0.200
     0.390     0.085     0.200
     0.390     0.495     0.200
     0.342    -0.354     0.200
     0.408    -0.178     0.200
     0.585    -0.664     0.200
     0.786     1.509     0.200
     0.860     0.630     0.200
     0.834    -1.186     0.200
     0.212    -0.271     0.200
     0.196    -0.427     0.200
     0.272     0.302     0.200
     0.273     0.437     0.200
     0.432    -0.452     0.200
     0.431     0.109     0.200
     0.703    -0.133     0.200
     0.878     0.544     0.200
     0.885     1.236     0.200
     0.949    -0.802     0.200
     0.483     0.180     0.200
     0.626     0.145     0.200
     0.729    -0.187     0.200
     0.682     0.721     0.200
     0.741    -0.734     0.200
     0.387     0.226     0.200
     0.482     0.159     0.200
     0.680    -0.551     0.200
     0.730    -0.267     0.200
     0.695    -0.099     0.200
     0.152    -0.625     0.200
     0.254    -0.352     0.200
     0.284    -0.019     0.200
     0.285     0.030     0.200
     0.285    -0.322     0.200
     0.285     0.186     0.200
     0.374    -0.678     0.200
     0.479     0.255     0.200
     0.724     0.201     0.200
     0.816     0.459     0.200
     0.942    -1.041     0.200
     0.532    -0.187     0.200
     0.622    -0.611     0.200
     0.632     0.407     0.200
     0.728    -0.206     0.200
     0.778    -0.333     0.200
     0.984     0.935     0.200
     0.356     0.793     0.200
     0.533     0.278     0.200
     0.639    -0.560     0.200
     0.635     0.804     0.200
     0.712     0.015     0.200
     0.779    -0.171     0.200
     0.779     1.096     0.200
     0.995     1.138     0.200
     0.513    -0.084     0.200
     0.759    -0.340     0.200
     0.728    -0.318     0.200
     0.181    -0.342     0.200
     0.256     0.274     0.200
     0.257     0.312     0.200
     0.227    -0.521     0.200
     0.419    -0.515     0.200
     0.463    -0.071     0.200
     0.728    -0.216     0.200
     0.861     0.518     0.200
     0.916     1.257     0.200
     0.965    -1.206     0.200
     0.133    -0.249     0.200
     0.291     0.394     0.200
     0.274    -0.246     0.200
     0.357    -0.565     0.200
     0.496     0.251     0.200
     0.732     0.104     0.200
     0.797     0.576     0.200
     0.942    -1.312     0.200
     0.943     1.535     0.200
     0.560     0.061     0.200
     0.598    -0.713     0.200
     0.600     0.712     0.200
     0.745     0.023     0.200
     0.803    -0.217     0.200
     0.725     0.883     0.200
     0.945     0.858     0.200
     0.175    -0.269     0.200
     0.232    -0.415     0.200
     0.265     0.346     0.200
     0.265     0.402     0.200
     0.407    -0.449     0.200
     0.465     0.124     0.200
     0.725     0.297     0.200
     0.850     0.637     0.200
     0.917     1.288     0.200
     0.957    -1.081     0.200
     0.179    -0.355     0.200
     0.270     0.261     0.200
     0.269     0.247     0.200
     0.227    -0.439     0.200
     0.407    -0.518     0.200
     0.459     0.065     0.200
     0.719    -0.032     0.200
     0.850     0.545     0.200
     0.952    -1.112     0.200
     0.154    -0.276     0.200
     0.257    -0.107     0.200
     0.306     0.396     0.200
     0.307     0.659     0.200
     0.307     0.390     0.200
     0.356    -0.681     0.200
     0.474     0.418     0.200
     0.709     0.275     0.200
     0.800     0.529     0.200
     0.921    -1.095     0.200
     0.920     1.758     0.200
     0.727    -0.547     0.200
     0.741     0.595     0.200
     0.176    -0.295     0.200
     0.262     0.375     0.200
     0.231    -0.364     0.200
     0.410    -0.525     0.200
     0.465     0.119     0.200
     0.726     0.068     0.200
     0.852     0.557     0.200
     0.917     1.530     0.200
     0.959    -1.051     0.200
     0.319    -0.163     0.200
     0.357    -0.130     0.200
     0.539     0.321     0.200
     0.546    -0.144     0.200
     0.720    -0.394     0.200
     0.926     0.127     0.200
     0.926     0.016     0.200
     0.956    -0.245     0.200
     0.174    -0.304     0.200
     0.231    -0.247     0.200
     0.305     0.275     0.200
     0.403     0.269     0.200
     0.424    -0.301     0.200
     0.668     0.118     0.200
     0.855     1.284     0.200
     0.873     0.500     0.200
     0.916    -0.804     0.200
     0.170    -0.361     0.200
     0.237    -0.171     0.200
     0.317     0.348     0.200
     0.316     0.284     0.200
     0.395     0.147     0.200
     0.421    -0.405     0.200
     0.658    -0.111     0.200
     0.846     0.948     0.200
     0.871     0.290     0.200
     0.906    -0.956     0.200
     0.169    -0.337     0.200
     0.237    -0.424     0.200
     0.287     0.321     0.200
     0.287     0.284     0.200
     0.287     0.534     0.200
     0.385    -0.604     0.200
     0.462     0.077     0.200
     0.711    -0.010     0.200
     0.829     0.555     0.200
     0.912     1.386     0.200
     0.936    -1.200     0.200
     0.564     0.157     0.200
     0.612     0.267     0.200
     0.677    -0.320     0.200
     0.812    -0.139     0.200
     0.790     0.699     0.200
     0.989     0.707     0.200
     0.079     0.300     0.200
     0.320    -0.403     0.200
     0.389     0.596     0.200
     0.484     0.478     0.200
     0.665    -0.539     0.200
     0.732    -0.237     0.200
     0.707    -0.040     0.200
     0.692     0.739     0.200
     0.829     1.243     0.200
     0.121    -0.348     0.200
     0.284    -0.419     0.200
     0.361    -0.677     0.200
     0.278     0.404     0.200
     0.509     0.100     0.200
     0.748    -0.038     0.200
     0.798     0.651     0.200
     0.956    -1.002     0.200
     0.957     1.653     0.200
     0.189    -0.252     0.200
     0.182    -0.414     0.200
     0.479     0.203     0.200
     0.480    -0.025     0.200
     0.541    -0.163     0.200
     0.540     0.531     0.200
     0.728     0.324     0.200
     0.868    -0.729     0.200
     0.885     0.073     0.200
     0.956    -0.960     0.200
     0.369    -0.063     0.200
     0.377    -0.057     0.200
     0.511     0.262     0.200
     0.596    -0.340     0.200
     0.596    -0.239     0.200
     0.768    -0.473     0.200
     0.907    -0.200     0.200
     0.902    -0.015     0.200
     0.971     0.226     0.200
     0.161    -0.376     0.200
     0.244    -0.288     0.200
     0.305     0.162     0.200
     0.392     0.130     0.200
     0.438    -0.362     0.200
     0.665    -0.075     0.200
     0.846     1.173     0.200
     0.888     0.576     0.200
     0.919    -0.840     0.200
     0.132    -0.468     0.200
     0.269     0.151     0.200
     0.269    -0.021     0.200
     0.269     0.033     0.200
     0.329    -0.275     0.200
     0.378    -0.062     0.200
     0.557    -0.437     0.200
     0.703    -0.227     0.200
     0.833     1.170     0.200
     0.998    -0.726     0.200
     0.351     0.069     0.200
     0.472    -0.191     0.200
     0.570    -0.196     0.200
     0.630    -0.142     0.200
     0.690    -0.203     0.200
     0.803     0.007     0.200
     0.972    -0.353     0.200
     0.104    -0.436     0.200
     0.232    -0.321     0.200
     0.434     0.115     0.200
     0.434     0.423     0.200
     0.433     0.458     0.200
     0.494     0.154     0.200
     0.597    -0.299     0.200
     0.665    -0.097     0.200
     0.670     1.057     0.200
     0.946    -0.279     0.200
     0.143    -0.326     0.200
     0.200    -0.521     0.200
     0.422     0.437     0.200
     0.422     0.586     0.200
     0.421     0.135     0.200
     0.637     0.472     0.200
     0.744    -0.036     0.200
     0.879    -1.015     0.200
     0.944     0.013     0.200
     0.507     0.900     0.200
     0.608     0.425     0.200
     0.608     0.778     0.200
     0.608     0.376     0.200
     0.608     0.477     0.200
     0.608     0.598     0.200
     0.628    -0.382     0.200
     0.063    -0.120     0.200
     0.338     0.145     0.200
     0.401     1.072     0.200
     0.432    -0.450     0.200
     0.522    -0.298     0.200
     0.695    -0.369     0.200
     0.733     0.588     0.200
     0.773     0.512     0.200
     0.905     0.617     0.200
     0.905     0.790     0.200
     0.916     0.943     0.200
     0.161    -0.354     0.200
     0.254    -0.138     0.200
     0.349    -0.547     0.200
     0.318     0.226     0.200
     0.319     0.157     0.200
     0.319    -0.151     0.200
     0.319     0.356     0.200
     0.467     0.481     0.200
     0.698     0.450     0.200
     0.795     0.655     0.200
     0.909    -0.867     0.200
     0.186    -0.354     0.200
     0.229    -0.434     0.200
     0.238     0.469     0.200
     0.239     0.331     0.200
     0.436    -0.615     0.200
     0.469    -0.038     0.200
     0.742    -0.187     0.200
     0.876     0.521     0.200
     0.924     1.263     0.200
     0.983    -1.122     0.200
     0.115    -0.344     0.200
     0.135    -0.271     0.200
     0.471    -0.510     0.200
     0.515     0.548     0.200
     0.515     0.697     0.200
     0.515     0.554     0.200
     0.602     0.046     0.200
     0.591     0.904     0.200
     0.813    -0.342     0.200
     1.000     0.382     0.200
     0.154    -0.353     0.200
     0.254    -0.332     0.200
     0.329     0.252     0.200
     0.328     0.188     0.200
     0.428    -0.487     0.200
     0.377     0.219     0.200
     0.642     0.002     0.200
     0.879     0.450     0.200
     0.829     1.301     0.200
     0.895    -0.611     0.200
     0.198    -0.586     0.200
     0.209    -0.501     0.200
     0.296    -0.024     0.200
     0.297     0.049     0.200
     0.297     0.158     0.200
     0.400    -0.595     0.200
     0.434     0.098     0.200
     0.689     0.131     0.200
     0.847     0.437     0.200
     0.885     1.482     0.200
     0.924    -0.911     0.200
     0.216    -0.292     0.200
     0.190    -0.356     0.200
     0.279     0.305     0.200
     0.279     0.290     0.200
     0.431    -0.406     0.200
     0.425     0.175     0.200
     0.695    -0.012     0.200
     0.878     0.567     0.200
     0.878     1.358     0.200
     0.942    -1.058     0.200
     0.156    -0.210     0.200
     0.249    -0.197     0.200
     0.306     0.303     0.200
     0.307     0.449     0.200
     0.388     0.365     0.200
     0.442    -0.294     0.200
     0.662     0.211     0.200
     0.841     1.392     0.200
     0.892     0.679     0.200
     0.918    -0.723     0.200
     0.142    -0.260     0.200
     0.270    -0.284     0.200
     0.347    -0.645     0.200
     0.306     0.374     0.200
     0.307     0.375     0.200
     0.307     0.148     0.200
     0.487     0.288     0.200
     0.718     0.214     0.200
     0.790     0.583     0.200
     0.925    -1.163     0.200
     0.932     1.626     0.200
     0.228    -0.379     0.200
     0.178    -0.479     0.200
     0.292     0.285     0.200
     0.291     0.251     0.200
     0.433    -0.477     0.200
     0.411     0.100     0.200
     0.681     0.008     0.200
     0.881     0.596     0.200
     0.864     1.308     0.200
     0.931    -0.939     0.200
     0.194    -0.493     0.200
     0.208    -0.271     0.200
     0.207    -0.237     0.200
     0.284    -0.311     0.200
     0.442    -0.035     0.200
     0.543    -0.358     0.200
     0.758     0.023     0.200
     0.897     1.374     0.200
     0.984     0.758     0.200
     0.162    -0.438     0.200
     0.245    -0.323     0.200
     0.318     0.198     0.200
     0.319     0.263     0.200
     0.319     0.115     0.200
     0.388     0.104     0.200
     0.427    -0.435     0.200
     0.653    -0.120     0.200
     0.840     1.126     0.200
     0.877     0.527     0.200
     0.904    -0.971     0.200
     0.937    -0.186     0.200
     0.195    -0.544     0.200
     0.216    -0.188     0.200
     0.413    -0.070     0.200
     0.322     0.439     0.200
     0.322     0.580     0.200
     0.321     0.426     0.200
     0.394    -0.486     0.200
     0.663    -0.321     0.200
     0.862     1.031     0.200
     0.899    -1.315     0.200
     0.844     0.491     0.200
     0.920    -0.408     0.200
     0.129    -0.462     0.200
     0.272     0.010     0.200
     0.272    -0.272     0.200
     0.271     0.001     0.200
     0.325    -0.260     0.200
     0.376    -0.061     0.200
     0.551    -0.415     0.200
     0.699    -0.152     0.200
     0.831     1.164     0.200
     1.000     0.617     0.200
     0.993    -0.659     0.200
     0.237    -0.083     0.200
     0.288    -0.303     0.200
     0.330    -0.686     0.200
     0.378     0.609     0.200
     0.455     0.604     0.200
     0.456     0.776     0.200
     0.557     0.105     0.200
     0.765    -0.867     0.200
     0.779     0.374     0.200
     0.788    -0.043     0.200
     0.798     1.358     0.200
     0.527     1.050     0.200
     0.581     0.596     0.200
     0.581     0.436     0.200
     0.581     0.430     0.200
     0.632    -0.304     0.200
     0.771    -0.437     0.200
     0.915    -0.255     0.200
     0.935     0.871     0.200
     0.163    -0.441     0.200
     0.248    -0.283     0.200
     0.361    -0.634     0.200
     0.308     0.244     0.200
     0.309     0.229     0.200
     0.465     0.339     0.200
     0.702     0.298     0.200
     0.806     0.587     0.200
     0.919    -0.193     0.200
     0.918    -0.983     0.200
     0.912     1.768     0.200
     0.084    -0.531     0.200
     0.370    -0.394     0.200
     0.395     0.300     0.200
     0.445     1.420     0.200
     0.600     0.409     0.200
     0.684    -0.434     0.200
     0.752     0.675     0.200
     0.904     0.927     0.200
     0.272    -0.055     0.200
     0.808     0.909     0.200
     0.808     0.369     0.200
     0.808    -0.221     0.200
     0.515    -0.290     0.200
     0.316     0.210     0.200
     0.273     0.255     0.200
     0.273    -0.261     0.200
     0.273     0.716     0.200
     0.302     0.595     0.200
     0.303     0.242     0.200
     0.303     0.351     0.200
     0.303     0.128     0.200
     0.298     0.258     0.200
     0.298     0.061     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.471     0.879     0.200
     0.791    -0.069     0.200
     0.253     0.130     0.200
     0.769     0.774     0.200
     0.452     1.024     0.200
     0.816    -0.716     0.200
     0.529     0.396     0.200
     0.869     0.761     0.200
     0.678    -1.972     0.200
     0.935    -0.019     0.200
     0.925     1.105     0.200
     0.880    -0.105     0.200
     0.882     0.020     0.200
     0.832    -0.714     0.200
     0.871     0.110     0.200
     0.843     0.447     0.200
     0.962     0.567     0.200
     0.929     0.615     0.200
     0.937     1.081     0.200
     0.851    -0.249     0.200
     0.851     0.974     0.200
     0.833    -0.308     0.200
     0.906     0.097     0.200
     0.960    -0.053     0.200
     0.879    -0.381     0.200
     0.801    -0.363     0.200
     0.372    -0.442     0.200
     0.169    -0.233     0.200
     0.211    -0.261     0.200
     0.814    -0.237     0.200
     0.670    -1.110     0.200
     0.911    -1.102     0.200
     0.503     1.162     0.200
     0.673    -1.103     0.200
     0.911    -0.849     0.200
     0.230    -0.381     0.200
     0.441     0.113     0.200
     0.655     0.485     0.200
     0.743     0.674     0.200
     0.020     0.353     0.200
     0.410    -1.034     0.200
     0.623    -0.562     0.200
     0.929    -1.606     0.200
     0.263     0.541     0.200
     0.264     1.421     0.200
     0.692    -1.522     0.200
     0.753    -1.833     0.200
     0.260     0.663     0.200
     0.281     0.314     0.200
     0.697    -0.254     0.200
     0.700    -1.272     0.200
     0.199    -1.145     0.200
     0.247     0.356     0.200
     0.636    -0.800     0.200
     0.698    -1.232     0.200
     0.877     0.366     0.200
     0.737    -0.896     0.200
     0.373    -0.393     0.200
     0.629    -0.683     0.200
     0.732    -0.487     0.200
     0.908    -0.260     0.200
     0.071     0.324     0.200
     0.549    -1.043     0.200
     0.706    -1.441     0.200
     0.992    -1.607     0.200
     0.121     0.066     0.200
     0.999    -0.250     0.200
     0.088     0.884     0.200
     0.404     0.044     0.200
     0.690    -0.908     0.200
     0.200     0.212     0.200
     0.757    -0.152     0.200
     0.148     0.129     0.200
     0.851     0.324     0.200
     0.663     0.282     0.200
     0.776    -1.443     0.200
     0.096     0.401     0.200
     0.371     1.324     0.200
     0.898    -0.767     0.200
     0.078     0.326     0.200
     0.372     1.035     0.200
     0.594    -0.918     0.200
     0.754    -0.523     0.200
     0.805    -0.244     0.200
     0.916    -1.429     0.200
     0.310     0.046     0.200
     0.367    -0.127     0.200
     0.585     0.578     0.200
     0.690    -0.972     0.200
     0.760     1.618     0.200
     0.185     0.669     0.200
     0.390    -0.529     0.200
     0.067     0.505     0.200
     0.398     0.149     0.200
     0.706    -1.115     0.200
     0.010     0.976     0.200
     0.353    -0.815     0.200
     0.410     1.237     0.200
     0.745     0.687     0.200
     0.899     1.080     0.200
     0.997    -1.331     0.200
     0.086     1.163     0.200
     0.432    -1.344     0.200
     0.802     0.606     0.200
     0.994     0.495     0.200
     0.191     1.463     0.200
     0.315    -0.818     0.200
     0.360     0.945     0.200
     0.595    -0.654     0.200
     0.599     0.789     0.200
     0.722     0.628     0.200
     0.748    -0.862     0.200
     0.804    -0.171     0.200
     0.942     0.560     0.200
     0.110     0.696     0.200
     0.291    -0.282     0.200
     0.403     0.345     0.200
     0.685     0.489     0.200
     0.738    -1.169     0.200
     0.079     0.987     0.200
     0.339    -0.786     0.200
     0.688    -0.750     0.200
     0.680     0.644     0.200
     0.749    -0.809     0.200
     0.833     1.319     0.200
     0.064     1.401     0.200
     0.320    -0.446     0.200
     0.706    -0.790     0.200
     0.709     0.909     0.200
     0.076     0.850     0.200
     0.311    -0.837     0.200
     0.663    -0.722     0.200
     0.715    -0.981     0.200
     0.704     1.033     0.200
     0.046     0.889     0.200
     0.324    -0.666     0.200
     0.703    -0.922     0.200
     0.728     0.519     0.200
     0.865     0.657     0.200
     0.012     0.962     0.200
     0.365    -0.587     0.200
     0.418     0.837     0.200
     0.670    -0.568     0.200
     0.761     0.391     0.200
     0.980    -1.628     0.200
     0.186     1.100     0.200
     0.303    -0.834     0.200
     0.372     0.529     0.200
     0.611     0.425     0.200
     0.755    -1.022     0.200
     0.725     0.510     0.200
     0.951     0.101     0.200
     0.010     1.074     0.200
     0.357    -0.881     0.200
     0.447     0.993     0.200
     0.419     1.140     0.200
     0.677    -0.844     0.200
     0.758     0.466     0.200
     0.912     0.905     0.200
     0.989    -1.733     0.200
     0.308    -0.862     0.200
     0.606     0.979     0.200
     0.752    -0.774     0.200
     0.723     0.971     0.200
     0.947     1.029     0.200
     0.076     0.779     0.200
     0.326    -0.796     0.200
     0.384     0.769     0.200
     0.487     0.415     0.200
     0.671    -0.949     0.200
     0.691     0.724     0.200
     0.700    -0.999     0.200
     0.834     0.773     0.200
     0.081     0.695     0.200
     0.343    -1.008     0.200
     0.365     1.141     0.200
     0.685    -1.121     0.200
     0.676     0.727     0.200
     0.833     0.568     0.200
     0.017     0.588     0.200
     0.371    -0.233     0.200
     0.664    -0.813     0.200
     0.763     0.662     0.200
     0.926     0.922     0.200
     0.973    -1.286     0.200
     0.028     0.435     0.200
     0.379    -0.220     0.200
     0.696    -0.414     0.200
     0.659    -0.702     0.200
     0.772     0.791     0.200
     0.963    -1.401     0.200
     0.937     1.007     0.200
     0.171     0.929     0.200
     0.312    -0.834     0.200
     0.364     0.841     0.200
     0.546     1.464     0.200
     0.616     0.683     0.200
     0.741     0.823     0.200
     0.740    -1.150     0.200
     0.790    -0.874     0.200
     0.963     0.926     0.200
     0.074     0.726     0.200
     0.327    -0.878     0.200
     0.699    -1.091     0.200
     0.692     0.471     0.200
     0.835     1.271     0.200
     0.008     0.680     0.200
     0.367    -0.792     0.200
     0.666    -0.498     0.200
     0.703    -0.302     0.200
     0.739    -0.103     0.200
     0.755     0.692     0.200
     0.980    -1.155     0.200
     0.916     1.391     0.200
     0.109     0.678     0.200
     0.321    -0.947     0.200
     0.710    -0.882     0.200
     0.756    -0.750     0.200
     0.662     0.580     0.200
     0.802     0.540     0.200
     0.014     0.882     0.200
     0.446     0.460     0.200
     0.420     1.040     0.200
     0.672    -0.410     0.200
     0.695    -0.883     0.200
     0.739    -0.653     0.200
     0.763     0.359     0.200
     0.981    -1.690     0.200
     0.920     0.912     0.200
     0.102     0.733     0.200
     0.316    -0.490     0.200
     0.650    -0.447     0.200
     0.672     0.836     0.200
     0.807     1.169     0.200
     0.130     1.038     0.200
     0.291    -0.751     0.200
     0.394     0.826     0.200
     0.498     1.126     0.200
     0.665     0.716     0.200
     0.742    -1.271     0.200
     0.779     1.078     0.200
     0.057     0.796     0.200
     0.329    -1.064     0.200
     0.722    -0.609     0.200
     0.697    -0.920     0.200
     0.708     0.895     0.200
     0.851     0.744     0.200
     0.084     0.905     0.200
     0.331    -0.693     0.200
     0.374     1.444     0.200
     0.697    -0.965     0.200
     0.747    -0.544     0.200
     0.679     0.816     0.200
     0.826     0.720     0.200
     0.168     0.999     0.200
     0.288    -0.941     0.200
     0.524     1.412     0.200
     0.592    -0.771     0.200
     0.636     0.640     0.200
     0.741     1.096     0.200
     0.767    -0.734     0.200
     0.973     0.851     0.200
     0.107     0.687     0.200
     0.297    -1.017     0.200
     0.730    -0.286     0.200
     0.683     0.648     0.200
     0.732    -1.071     0.200
     0.803     0.917     0.200
     0.051     0.857     0.200
     0.329    -0.788     0.200
     0.697    -0.997     0.200
     0.716     0.604     0.200
     0.858     0.863     0.200
     0.209     0.605     0.200
     0.738     1.291     0.200
     0.062     0.630     0.200
     0.327    -0.939     0.200
     0.704     0.635     0.200
     0.699    -0.918     0.200
     0.846     1.167     0.200
     0.029     0.328     0.200
     0.378    -0.055     0.200
     0.661    -0.774     0.200
     0.757    -0.885     0.200
     0.774     0.714     0.200
     0.963    -1.316     0.200
     0.938     0.806     0.200
     0.088     0.816     0.200
     0.309    -0.629     0.200
     0.728    -0.232     0.200
     0.692     0.539     0.200
     0.718    -0.867     0.200
     0.821     0.976     0.200
     0.114     0.500     0.200
     0.338     1.280     0.200
     0.680    -0.810     0.200
     0.197     1.233     0.200
     0.300    -0.668     0.200
     0.376     0.467     0.200
     0.580     0.356     0.200
     0.606     0.884     0.200
     0.764    -1.132     0.200
     0.057     1.254     0.200
     0.326    -0.787     0.200
     0.700    -0.638     0.200
     0.711     0.743     0.200
     0.852     0.931     0.200
     0.009     0.738     0.200
     0.365    -0.286     0.200
     0.669    -0.655     0.200
     0.758     0.565     0.200
     0.917     1.048     0.200
     0.981    -1.287     0.200
     0.104     0.910     0.200
     0.295    -0.983     0.200
     0.687     0.627     0.200
     0.733    -0.760     0.200
     0.078     0.865     0.200
     0.325    -1.099     0.200
     0.702    -0.992     0.200
     0.689     0.621     0.200
     0.831     0.989     0.200
     0.048     0.867     0.200
     0.339    -0.068     0.200
     0.391     1.295     0.200
     0.687    -0.795     0.200
     0.179     1.237     0.200
     0.312    -0.803     0.200
     0.363     0.790     0.200
     0.551     1.597     0.200
     0.610     0.871     0.200
     0.733     0.897     0.200
     0.744    -1.088     0.200
     0.794    -0.402     0.200
     0.955     0.784     0.200
     0.360     0.078     0.200
     0.805     1.914     0.200
     0.041     0.855     0.200
     0.326    -0.392     0.200
     0.452     0.679     0.200
     0.414     0.725     0.200
     0.692    -0.441     0.200
     0.733     0.503     0.200
     0.871     0.637     0.200
     0.305    -0.959     0.200
     0.638     0.669     0.200
     0.738    -1.178     0.200
     0.770    -0.648     0.200
     0.091     1.276     0.200
     0.825     0.292     0.200
     0.201     0.506     0.200
     0.506     1.666     0.200
     0.654     0.218     0.200
     0.053     1.106     0.200
     0.727    -1.860     0.200
     0.708    -1.296     0.200
     0.066     0.509     0.200
     0.394     0.948     0.200
     0.476     0.866     0.200
     0.702    -0.982     0.200
     0.703     0.587     0.200
     0.843     1.023     0.200
     0.036     1.029     0.200
     0.425     0.873     0.200
     0.443     0.696     0.200
     0.673    -0.799     0.200
     0.684    -0.848     0.200
     0.785     0.399     0.200
     0.979    -1.642     0.200
     0.933     0.583     0.200
     0.010     0.768     0.200
     0.352    -0.346     0.200
     0.679    -0.665     0.200
     0.700    -0.260     0.200
     0.723    -0.888     0.200
     0.749     0.683     0.200
     0.902     0.807     0.200
     0.997    -1.430     0.200
     0.003     0.577     0.200
     0.360    -0.501     0.200
     0.672    -0.570     0.200
     0.703    -0.064     0.200
     0.751     0.640     0.200
     0.908     0.850     0.200
     0.989    -1.195     0.200
     0.079     0.761     0.200
     0.443     1.173     0.200
     0.211     1.169     0.200
     0.311    -0.770     0.200
     0.366     0.978     0.200
     0.701     1.220     0.200
     0.115     0.865     0.200
     0.404     0.581     0.200
     0.795     1.685     0.200
     0.065     0.906     0.200
     0.331    -0.755     0.200
     0.387     1.029     0.200
     0.699     0.555     0.200
     0.695    -0.757     0.200
     0.845     0.810     0.200
     0.299    -0.920     0.200
     0.513     1.213     0.200
     0.650     0.498     0.200
     0.758    -0.435     0.200
     0.739    -1.256     0.200
     0.148     1.030     0.200
     0.315    -0.666     0.200
     0.365     1.548     0.200
     0.728    -0.571     0.200
     0.778    -0.027     0.200
     0.135     0.285     0.200
     0.327    -0.680     0.200
     0.356     0.657     0.200
     0.533     1.158     0.200
     0.635     0.713     0.200
     0.712    -1.132     0.200
     0.779     1.153     0.200
     0.995    -0.398     0.200
     0.130     1.468     0.200
     0.308    -0.682     0.200
     0.377     0.523     0.200
     0.759     0.386     0.200
     0.728    -0.832     0.200
     0.319     0.808     0.200
     0.245    -0.816     0.200
     0.413    -0.631     0.200
     0.513    -0.301     0.200
     0.477    -0.810     0.200
     0.188     1.233     0.200
     0.316    -0.916     0.200
     0.359     1.001     0.200
     0.600     0.742     0.200
     0.745    -0.869     0.200
     0.803    -0.791     0.200
     0.945     0.557     0.200
     0.034     0.689     0.200
     0.345    -0.580     0.200
     0.671    -1.195     0.200
     0.694    -0.660     0.200
     0.780     0.507     0.200
     0.920     0.860     0.200
     0.994    -1.051     0.200
     0.195     0.440     0.200
     0.279     0.197     0.200
     0.396    -0.138     0.200
     0.396    -0.408     0.200
     0.460     0.527     0.200
     0.142     0.793     0.200
     0.317     1.224     0.200
     0.367    -0.572     0.200
     0.790     1.074     0.200
     0.989     0.437     0.200
     0.379    -1.038     0.200
     0.608    -1.140     0.200
     0.738    -0.646     0.200
     0.092     0.242     0.200
     0.704    -1.421     0.200
     0.827     0.915     0.200
     0.073     1.098     0.200
     0.413    -0.620     0.200
     0.771    -0.408     0.200
     0.935     0.019     0.200
     0.291     0.975     0.200
     0.921     1.008     0.200
     0.716    -1.030     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.147     0.026     0.200
     0.147     0.127     0.200
     0.147    -0.076     0.200
     0.287     0.852     0.200
     0.287     0.454     0.200
     0.719    -1.048     0.200
     0.469    -0.918     0.200
     0.764     0.176     0.200
     0.878     0.791     0.200
     0.123    -0.453     0.200
     0.339     0.085     0.200
     0.734    -0.653     0.200
     0.178     0.031     0.200
     0.764    -1.175     0.200
     0.122     1.528     0.200
     0.739    -1.987     0.200
     0.129    -0.581     0.200
     0.309     0.543     0.200
     0.716    -1.010     0.200
     0.233     0.210     0.200
     0.197    -0.437     0.200
     0.733    -0.580     0.200
     0.110    -1.097     0.200
     0.970    -0.361     0.200
     0.178     1.509     0.200
     0.599    -1.088     0.200
     0.964    -0.065     0.200
     0.511     0.103     0.200
     0.146    -0.543     0.200
     0.287    -0.020     0.200
     0.718    -0.002     0.200
     0.356     1.773     0.200
     0.562     0.513     0.200
     0.052     1.456     0.200
     0.416     0.501     0.200
     0.585    -0.531     0.200
     0.082     1.515     0.200
     0.570    -1.276     0.200
     0.107     0.412     0.200
     0.415     1.127     0.200
     0.535     0.320     0.200
     0.124     1.138     0.200
     0.385     0.953     0.200
     0.539    -1.461     0.200
     0.124    -0.896     0.200
     0.361     0.359     0.200
     0.155    -0.537     0.200
     0.278     1.238     0.200
     0.201     0.041     0.200
     0.234     0.721     0.200
     0.122     0.996     0.200
     0.324     0.830     0.200
     0.113    -0.674     0.200
     0.334     1.038     0.200
     0.119    -0.491     0.200
     0.354    -0.039     0.200
     0.085     0.848     0.200
     0.156     0.307     0.200
     0.284    -0.004     0.200
     0.141     1.656     0.200
     0.172    -0.251     0.200
     0.424    -0.069     0.200
     0.711     0.163     0.200
     0.478    -0.751     0.200
     0.707    -0.619     0.200
     0.268     1.105     0.200
     0.166     0.770     0.200
     0.169     1.834     0.200
     0.469     1.155     0.200
     0.721     0.534     0.200
     0.109    -0.092     0.200
     0.376     0.374     0.200
     0.139     0.088     0.200
     0.338     0.546     0.200
     0.753    -1.568     0.200
     0.173     0.264     0.200
     0.278     0.839     0.200
     0.752    -0.912     0.200
     0.161     0.242     0.200
     0.278     0.726     0.200
     0.731    -0.583     0.200
     0.344     0.563     0.200
     0.729    -1.063     0.200
     0.898    -0.419     0.200
     0.181    -0.943     0.200
     0.328     0.620     0.200
     0.710    -0.839     0.200
     0.478     0.256     0.200
     0.809     0.593     0.200
     0.792     0.134     0.200
     0.514     0.637     0.200
     0.828     1.012     0.200
     0.462     0.213     0.200
     0.842     1.151     0.200
     0.610    -0.332     0.200
     0.859     0.981     0.200
     0.470     0.331     0.200
     0.664     0.295     0.200
     0.585     0.271     0.200
     0.870     1.023     0.200
     0.823     0.707     0.200
     0.204     1.741     0.200
     0.607     0.834     0.200
     0.896     1.345     0.200
     0.609     0.835     0.200
     0.567    -0.266     0.200
     0.863     0.813     0.200
     0.669     0.885     0.200
     0.230     0.265     0.200
     0.324     0.079     0.200
     0.761    -1.032     0.200
     0.769     0.116     0.200
     0.733     0.515     0.200
     0.726     0.619     0.200
     0.368     0.789     0.200
     0.746    -0.950     0.200
     0.070     0.705     0.200
     0.367     0.779     0.200
     0.770    -0.049     0.200
     0.222     1.427     0.200
     0.053     1.239     0.200
     0.796    -0.596     0.200
     0.753    -1.220     0.200
     0.280     1.108     0.200
     0.519     0.029     0.200
     0.461    -1.535     0.200
     0.693     1.953     0.200
     0.600     0.080     0.200
     0.306     0.837     0.200
     0.715    -1.675     0.200
     0.569    -1.213     0.200
     0.062     0.393     0.200
     0.392     0.606     0.200
     0.525     0.061     0.200
     0.279     0.260     0.200
     0.741    -1.258     0.200
     0.598    -0.497     0.200
     0.223     0.081     0.200
     0.294    -0.043     0.200
     0.744    -1.138     0.200
     0.306     0.846     0.200
     0.732    -0.898     0.200
     0.184    -0.144     0.200
     0.349     0.234     0.200
     0.718    -1.690     0.200
     0.232     0.345     0.200
     0.263     0.215     0.200
     0.742    -1.645     0.200
     0.215     0.380     0.200
     0.731    -0.560     0.200
     0.207    -0.297     0.200
     0.305     0.676     0.200
     0.218    -0.341     0.200
     0.268     0.636     0.200
     0.727    -1.572     0.200
     0.667     0.438     0.200
     0.265     0.791     0.200
     0.710    -0.978     0.200
     0.330     1.276     0.200
     0.371    -0.283     0.200
     0.095     0.700     0.200
     0.831     1.386     0.200
     0.277     0.364     0.200
     0.725    -0.730     0.200
     0.043     0.088     0.200
     0.797     1.543     0.200
     0.371     1.371     0.200
     0.215     0.384     0.200
     0.738    -1.009     0.200
     0.365    -0.599     0.200
     0.682    -0.076     0.200
     0.795     1.171     0.200
     0.983    -0.246     0.200
     0.569    -0.967     0.200
     0.241     0.617     0.200
     0.295    -0.345     0.200
     0.722    -1.234     0.200
     0.555     0.316     0.200
     0.235     0.777     0.200
     0.235     0.170     0.200
     0.153     1.062     0.200
     0.339     0.379     0.200
     0.674     1.089     0.200
     0.477     1.296     0.200
     0.496     0.397     0.200
     0.570     0.784     0.200
     0.590     0.229     0.200
     0.492    -0.857     0.200
     0.693     0.534     0.200
     0.310     0.090     0.200
     0.365    -0.139     0.200
     0.720    -0.914     0.200
     0.640     0.870     0.200
     0.931     1.655     0.200
     0.296     0.010     0.200
     0.274     1.163     0.200
     0.509     0.583     0.200
     0.587     1.811     0.200
     0.911     0.643     0.200
     0.148     0.134     0.200
     0.217     1.621     0.200
     0.599     0.500     0.200
     0.866     1.627     0.200
     0.066    -0.774     0.200
     0.181     1.244     0.200
     0.537     1.071     0.200
     0.808     1.343     0.200
     0.191     1.076     0.200
     0.345     0.547     0.200
     0.642     0.773     0.200
     0.283     0.409     0.200
     0.728    -0.766     0.200
     0.021    -1.051     0.200
     0.106     1.529     0.200
     0.486     0.849     0.200
     0.806     1.491     0.200
     0.126     0.587     0.200
     0.226    -0.963     0.200
     0.334    -0.311     0.200
     0.783     0.204     0.200
     0.159    -0.384     0.200
     0.333     0.986     0.200
     0.410    -1.099     0.200
     0.688    -0.890     0.200
     0.247     0.758     0.200
     0.211     0.823     0.200
     0.277    -0.306     0.200
     0.438    -1.316     0.200
     0.685    -0.104     0.200
     0.880     0.701     0.200
     0.079    -0.902     0.200
     0.508     0.285     0.200
     0.447     1.414     0.200
     0.664    -0.674     0.200
     0.392     1.552     0.200
     0.618    -0.225     0.200
     0.660    -1.534     0.200
     0.793     0.557     0.200
     0.962     0.497     0.200
     0.408    -0.246     0.200
     0.428    -1.173     0.200
     0.483     1.825     0.200
     0.817     0.180     0.200
     0.976    -0.597     0.200
     0.956     0.286     0.200
     0.536    -0.129     0.200
     0.815    -0.782     0.200
     0.926    -0.649     0.200
     0.936     0.869     0.200
     0.239    -0.368     0.200
     0.396    -0.881     0.200
     0.456     0.205     0.200
     0.691     1.072     0.200
     0.960    -0.537     0.200
     0.695    -0.905     0.200
     0.271     0.562     0.200
     0.352    -0.657     0.200
     0.780     0.389     0.200
     0.124    -0.924     0.200
     0.635    -1.022     0.200
     0.970     0.354     0.200
     0.267     0.773     0.200
     0.366    -1.376     0.200
     0.361    -0.658     0.200
     0.799     0.735     0.200
     0.999    -0.895     0.200
     0.233     0.786     0.200
     0.309    -1.048     0.200
     0.425    -1.631     0.200
     0.863     0.865     0.200
     0.238     0.182     0.200
     0.297    -1.358     0.200
     0.430    -1.434     0.200
     0.869     0.550     0.200
     0.691    -0.607     0.200
     0.152    -1.324     0.200
     0.487     0.471     0.200
     0.487     1.828     0.200
     0.518    -0.787     0.200
     0.963     1.088     0.200
     0.368    -0.301     0.200
     0.446    -1.242     0.200
     0.704     0.283     0.200
     0.762    -1.238     0.200
     0.798    -0.165     0.200
     0.510     0.316     0.200
     0.549     1.118     0.200
     0.766    -0.915     0.200
     0.893    -0.990     0.200
     0.956     0.933     0.200
     0.236     0.441     0.200
     0.312    -1.112     0.200
     0.421    -1.402     0.200
     0.858     0.851     0.200
     0.256     0.751     0.200
     0.912     0.005     0.200
     0.438     0.743     0.200
     0.581     0.267     0.200
     0.607    -0.405     0.200
     0.933    -1.289     0.200
     0.532    -0.739     0.200
     0.559    -1.112     0.200
     0.875     0.696     0.200
     0.891     0.521     0.200
     0.982    -0.302     0.200
     0.247     1.179     0.200
     0.371    -1.568     0.200
     0.409    -0.932     0.200
     0.789     0.132     0.200
     0.257     0.368     0.200
     0.373    -1.397     0.200
     0.804     0.502     0.200
     0.186    -1.233     0.200
     0.438     0.728     0.200
     0.633    -0.797     0.200
     0.698    -1.006     0.200
     0.595     0.148     0.200
     0.715    -1.627     0.200
     0.721     0.315     0.200
     0.709     0.573     0.200
     0.961     1.346     0.200
     0.179    -0.591     0.200
     0.255    -0.370     0.200
     0.558    -1.101     0.200
     0.083    -0.324     0.200
     0.355     0.426     0.200
     0.642    -0.517     0.200
     0.229    -1.737     0.200
     0.483    -0.066     0.200
     0.714    -0.311     0.200
     0.851    -1.526     0.200
     0.980    -0.373     0.200
     0.079    -0.342     0.200
     0.643    -0.573     0.200
     0.375    -1.061     0.200
     0.406    -0.452     0.200
     0.649     1.245     0.200
     0.773     0.394     0.200
     0.950    -0.614     0.200
     0.139    -1.663     0.200
     0.379     0.361     0.200
     0.726     0.050     0.200
     0.738    -0.842     0.200
     0.893    -0.980     0.200
     0.939    -0.663     0.200
     0.349    -1.247     0.200
     0.311     0.750     0.200
     0.331    -0.541     0.200
     0.708     0.260     0.200
     0.793     0.741     0.200
     0.307     0.378     0.200
     0.343    -1.289     0.200
     0.345    -0.866     0.200
     0.721     0.433     0.200
     0.785     0.269     0.200
     0.398    -0.716     0.200
     0.595    -1.318     0.200
     0.689     1.140     0.200
     0.945    -0.696     0.200
     0.134    -1.070     0.200
     0.356     0.450     0.200
     0.614    -1.068     0.200
     0.739    -0.841     0.200
     0.985    -0.277     0.200
     0.284     0.425     0.200
     0.370    -1.295     0.200
     0.811     0.949     0.200
     0.351    -0.825     0.200
     0.308    -0.167     0.200
     0.710     0.510     0.200
     0.795     0.614     0.200
     0.285     0.846     0.200
     0.396    -1.048     0.200
     0.705     0.364     0.200
     0.331     0.519     0.200
     0.547    -1.313     0.200
     0.565    -1.058     0.200
     0.703    -1.442     0.200
     0.151    -1.568     0.200
     0.375     0.098     0.200
     0.747    -0.751     0.200
     0.727    -0.183     0.200
     0.929    -0.479     0.200
     0.234    -0.515     0.200
     0.429    -1.208     0.200
     0.660     0.600     0.200
     0.879     0.809     0.200
     0.174    -1.294     0.200
     0.481     0.669     0.200
     0.539     0.048     0.200
     0.608    -0.279     0.200
     0.859    -1.179     0.200
     0.881    -0.789     0.200
     0.286     0.080     0.200
     0.363    -1.470     0.200
     0.732     1.123     0.200
     0.804     0.889     0.200
     0.148    -0.998     0.200
     0.543    -0.071     0.200
     0.577    -0.338     0.200
     0.774    -0.713     0.200
     0.987     0.688     0.200
     0.230    -0.985     0.200
     0.267    -0.864     0.200
     0.406    -1.316     0.200
     0.722     0.421     0.200
     0.849     0.897     0.200
     0.162    -0.729     0.200
     0.305     1.084     0.200
     0.436    -1.041     0.200
     0.664     0.139     0.200
     0.886     0.421     0.200
     0.278     0.591     0.200
     0.318    -0.411     0.200
     0.348    -1.198     0.200
     0.778     0.981     0.200
     0.253    -1.293     0.200
     0.578    -0.626     0.200
     0.565     0.222     0.200
     0.938    -1.371     0.200
     0.927    -1.240     0.200
     0.220    -0.798     0.200
     0.387    -1.199     0.200
     0.692     0.627     0.200
     0.834     0.719     0.200
     0.272    -0.648     0.200
     0.342    -1.137     0.200
     0.311     0.363     0.200
     0.715     0.592     0.200
     0.785     0.906     0.200
     0.160    -1.372     0.200
     0.401     0.115     0.200
     0.661    -0.486     0.200
     0.756    -0.025     0.200
     0.943    -0.170     0.200
     0.231    -0.816     0.200
     0.285     0.087     0.200
     0.391    -1.289     0.200
     0.392    -0.967     0.200
     0.439    -0.145     0.200
     0.835    -0.775     0.200
     0.818    -0.746     0.200
     0.836    -0.864     0.200
     0.408    -0.678     0.200
     0.418    -0.261     0.200
     0.718    -0.608     0.200
     0.784    -0.821     0.200
     0.814    -0.853     0.200
     0.865    -1.202     0.200
     0.195     0.604     0.200
     0.319    -0.555     0.200
     0.427    -1.122     0.200
     0.824     1.005     0.200
     0.848     0.772     0.200
     0.160    -0.527     0.200
     0.311     0.270     0.200
     0.434    -0.780     0.200
     0.659     0.247     0.200
     0.885    -0.389     0.200
     0.203    -0.832     0.200
     0.439    -0.835     0.200
     0.716    -0.468     0.200
     0.245    -0.212     0.200
     0.318    -1.465     0.200
     0.583     0.024     0.200
     0.769     0.704     0.200
     0.190    -0.493     0.200
     0.283    -0.112     0.200
     0.427    -0.964     0.200
     0.465    -0.663     0.200
     0.440    -1.088     0.200
     0.267    -0.333     0.200
     0.344    -1.018     0.200
     0.314     0.173     0.200
     0.272    -0.249     0.200
     0.368    -1.179     0.200
     0.807     0.845     0.200
     0.642    -0.525     0.200
     0.271    -0.551     0.200
     0.392     0.522     0.200
     0.646     0.423     0.200
     0.126    -0.292     0.200
     0.274    -0.186     0.200
     0.554    -1.594     0.200
     0.697     0.269     0.200
     0.256    -0.680     0.200
     0.367    -1.708     0.200
     0.292     0.706     0.200
     0.719     0.479     0.200
     0.810     0.252     0.200
     0.271    -0.863     0.200
     0.281    -0.155     0.200
     0.282     0.053     0.200
     0.366    -1.412     0.200
     0.806     0.143     0.200
     0.221    -0.688     0.200
     0.284     0.014     0.200
     0.399    -1.343     0.200
     0.268    -0.600     0.200
     0.304    -0.038     0.200
     0.350    -1.352     0.200
     0.718     0.435     0.200
     0.793     0.743     0.200
     0.156    -0.880     0.200
     0.421    -0.890     0.200
     0.633     0.971     0.200
     0.872     1.017     0.200
     0.263     0.006     0.200
     0.219    -0.622     0.200
     0.419    -1.060     0.200
     0.719    -0.156     0.200
     0.862     0.823     0.200
     0.266    -1.308     0.200
     0.298    -0.458     0.200
     0.716     0.065     0.200
     0.973    -1.045     0.200
     0.383    -1.755     0.200
     0.301     0.332     0.200
     0.283    -1.171     0.200
     0.343    -1.404     0.200
     0.731     0.543     0.200
     0.304     1.849     0.200
     0.423    -1.312     0.200
     0.671    -0.092     0.200
     0.200    -0.805     0.200
     0.281     0.017     0.200
     0.419    -0.801     0.200
     0.866     0.382     0.200
     0.224    -0.660     0.200
     0.281     0.686     0.200
     0.400    -1.022     0.200
     0.709    -0.421     0.200
     0.844     0.939     0.200
     0.257    -1.246     0.200
     0.330    -0.347     0.200
     0.386    -0.062     0.200
     0.387     0.624     0.200
     0.703     0.196     0.200
     0.998    -0.907     0.200
     0.258    -0.725     0.200
     0.366    -1.680     0.200
     0.293     0.308     0.200
     0.721     0.860     0.200
     0.808     0.862     0.200
     0.312    -0.373     0.200
     0.285    -1.052     0.200
     0.531    -1.451     0.200
     0.683     1.794     0.200
     0.917     0.558     0.200
     0.934     0.209     0.200
     0.972     1.503     0.200
     0.177    -0.601     0.200
     0.441    -0.973     0.200
     0.188     0.248     0.200
     0.189     0.966     0.200
     0.312    -0.852     0.200
     0.437    -1.270     0.200
     0.822     0.232     0.200
     0.859     0.525     0.200
     0.343    -0.919     0.200
     0.561     0.152     0.200
     0.509    -1.345     0.200
     0.682    -0.581     0.200
     0.944    -0.333     0.200
     0.994    -0.641     0.200
     0.128    -0.413     0.200
     0.273     0.025     0.200
     0.554    -0.929     0.200
     0.235    -0.981     0.200
     0.378    -1.320     0.200
     0.297     0.174     0.200
     0.703     0.377     0.200
     0.290     0.135     0.200
     0.390    -0.857     0.200
     0.835     0.426     0.200
     0.307    -0.946     0.200
     0.356    -1.270     0.200
     0.769     0.112     0.200
     0.787     0.532     0.200
     0.291     0.116     0.200
     0.291    -0.093     0.200
     0.428    -0.999     0.200
     0.683     0.124     0.200
     0.139    -1.801     0.200
     0.461    -0.150     0.200
     0.572     0.610     0.200
     0.762    -0.596     0.200
     0.883    -0.347     0.200
     0.190    -0.828     0.200
     0.433    -1.205     0.200
     0.189    -0.612     0.200
     0.451     0.371     0.200
     0.640    -0.885     0.200
     0.813    -0.391     0.200
     0.929    -1.765     0.200
     0.971    -0.609     0.200
     0.345    -1.222     0.200
     0.266    -0.621     0.200
     0.313     0.591     0.200
     0.314    -0.139     0.200
     0.710     0.653     0.200
     0.789     0.282     0.200
     0.360    -1.252     0.200
     0.509     0.316     0.200
     0.572     0.080     0.200
     0.956    -1.074     0.200
     0.305    -0.115     0.200
     0.793     0.965     0.200
     0.160    -0.643     0.200
     0.320     0.603     0.200
     0.428    -0.787     0.200
     0.652     0.884     0.200
     0.879     1.128     0.200
     0.221    -0.725     0.200
     0.255     0.041     0.200
     0.425    -1.099     0.200
     0.726    -0.193     0.200
     0.868     0.642     0.200
     0.202    -0.765     0.200
     0.198    -0.183     0.200
     0.554    -1.019     0.200
     0.768     0.364     0.200
     0.995     0.781     0.200
     0.091    -1.187     0.200
     0.365     0.237     0.200
     0.649    -0.998     0.200
     0.657    -1.328     0.200
     0.978    -0.469     0.200
     0.453    -0.407     0.200
     0.462    -0.123     0.200
     0.715     0.451     0.200
     0.831    -0.851     0.200
     0.938    -0.910     0.200
     0.947    -0.101     0.200
     0.251    -1.091     0.200
     0.447     0.195     0.200
     0.692    -1.105     0.200
     0.823    -0.471     0.200
     0.930    -0.773     0.200
     0.994    -1.670     0.200
     0.222    -0.802     0.200
     0.284     0.800     0.200
     0.399    -1.049     0.200
     0.844     0.783     0.200
     0.122    -0.354     0.200
     0.513     0.115     0.200
     0.559    -0.397     0.200
     0.677    -0.467     0.200
     0.154    -1.163     0.200
     0.244    -0.541     0.200
     0.367    -1.624     0.200
     0.303     0.360     0.200
     0.704     0.122     0.200
     0.812     0.605     0.200
     0.330    -0.538     0.200
     0.703     0.815     0.200
     0.998    -0.686     0.200
     0.195    -0.684     0.200
     0.283    -0.030     0.200
     0.283     0.961     0.200
     0.423    -0.893     0.200
     0.694     0.567     0.200
     0.870     0.960     0.200
     0.411    -0.960     0.200
     0.858     0.730     0.200
     0.349    -0.667     0.200
     0.536    -0.262     0.200
     0.879    -0.360     0.200
     0.951     0.176     0.200
     0.998     0.581     0.200
     0.680    -1.727     0.200
     0.286     0.361     0.200
     0.274    -0.405     0.200
     0.360    -0.903     0.200
     0.800     1.074     0.200
     0.154    -0.359     0.200
     0.433    -1.286     0.200
     0.648     0.893     0.200
     0.510    -1.036     0.200
     0.648    -0.931     0.200
     0.271    -0.519     0.200
     0.303    -0.202     0.200
     0.350    -1.129     0.200
     0.722     0.276     0.200
     0.792     0.285     0.200
     0.687    -0.656     0.200
     0.303    -0.168     0.200
     0.310    -0.429     0.200
     0.500    -1.101     0.200
     0.906     0.384     0.200
     0.948     0.267     0.200
     0.128    -0.315     0.200
     0.546    -0.867     0.200
     0.270    -0.601     0.200
     0.352    -1.154     0.200
     0.794     0.849     0.200
     0.240    -0.157     0.200
     0.280    -1.160     0.200
     0.325    -1.439     0.200
     0.386     0.749     0.200
     0.451     1.525     0.200
     0.566     0.056     0.200
     0.774     0.402     0.200
     0.188    -0.297     0.200
     0.389    -1.112     0.200
     0.162    -1.274     0.200
     0.382    -0.395     0.200
     0.164    -1.015     0.200
     0.241    -0.517     0.200
     0.283     0.489     0.200
     0.384    -1.100     0.200
     0.468     0.860     0.200
     0.717     0.654     0.200
     0.828     0.826     0.200
     0.163    -0.655     0.200
     0.242    -1.072     0.200
     0.432    -1.042     0.200
     0.662    -0.030     0.200
     0.882     0.808     0.200
     0.579    -1.143     0.200
     0.136    -0.832     0.200
     0.792     0.679     0.200
     0.337    -1.134     0.200
     0.376    -1.192     0.200
     0.458     0.317     0.200
     0.765    -0.839     0.200
     0.848    -0.350     0.200
     0.881    -0.086     0.200
     0.198     1.693     0.200
     0.246    -0.754     0.200
     0.213    -0.518     0.200
     0.510    -0.734     0.200
     0.765     0.507     0.200
     0.234    -1.063     0.200
     0.414    -0.919     0.200
     0.656     0.013     0.200
     0.134    -1.145     0.200
     0.313    -0.600     0.200
     0.436    -1.170     0.200
     0.146    -0.652     0.200
     0.260    -1.028     0.200
     0.318     1.186     0.200
     0.444    -1.174     0.200
     0.376     0.965     0.200
     0.400    -0.714     0.200
     0.192    -0.746     0.200
     0.217    -0.979     0.200
     0.441    -0.987     0.200
     0.705    -0.561     0.200
     0.887     0.897     0.200
     0.167    -0.937     0.200
     0.239    -0.576     0.200
     0.399    -1.161     0.200
     0.470     0.626     0.200
     0.727     0.848     0.200
     0.841     0.869     0.200
     0.922     1.562     0.200
     0.100     0.787     0.200
     0.245    -0.255     0.200
     0.130    -0.428     0.200
     0.328    -0.654     0.200
     0.377     0.294     0.200
     0.555    -0.929     0.200
     0.187    -0.779     0.200
     0.219    -0.613     0.200
     0.408    -0.918     0.200
     0.853     0.720     0.200
     0.353    -0.384     0.200
     0.559    -0.693     0.200
     0.597    -0.637     0.200
     0.915     1.514     0.200
     0.131    -0.940     0.200
     0.294     0.530     0.200
     0.295    -0.090     0.200
     0.277    -0.984     0.200
     0.352    -1.152     0.200
     0.792     0.792     0.200
     0.335    -0.789     0.200
     0.447    -1.118     0.200
     0.617     2.085     0.200
     0.847     0.358     0.200
     0.990     0.227     0.200
     0.555    -1.264     0.200
     0.668    -1.157     0.200
     0.216    -0.629     0.200
     0.539    -0.793     0.200
     0.661    -1.336     0.200
     0.891     1.037     0.200
     0.983    -0.413     0.200
     0.227    -1.260     0.200
     0.316    -1.160     0.200
     0.436     0.440     0.200
     0.593     0.432     0.200
     0.681    -0.698     0.200
     0.808    -0.020     0.200
     0.935    -0.416     0.200
     0.157    -1.171     0.200
     0.256    -0.390     0.200
     0.351    -1.120     0.200
     0.796     0.937     0.200
     0.541    -0.191     0.200
     0.571    -1.414     0.200
     0.713    -0.847     0.200
     0.704    -0.702     0.200
     0.871    -0.236     0.200
     0.961     0.310     0.200
     0.235    -0.497     0.200
     0.674    -0.972     0.200
     0.850     1.276     0.200
     0.550    -0.698     0.200
     0.578    -0.530     0.200
     0.440    -0.854     0.200
     0.162    -0.865     0.200
     0.235    -0.920     0.200
     0.246    -0.831     0.200
     0.328     0.735     0.200
     0.328     0.079     0.200
     0.421    -1.080     0.200
     0.384     0.929     0.200
     0.646     0.174     0.200
     0.872     0.715     0.200
     0.213    -0.862     0.200
     0.193    -0.574     0.200
     0.422    -0.834     0.200
     0.869     0.645     0.200
     0.149    -0.418     0.200
     0.454    -1.125     0.200
     0.637    -0.976     0.200
     0.965     0.105     0.200
     0.244    -0.482     0.200
     0.299     0.765     0.200
     0.370    -1.525     0.200
     0.815    -0.007     0.200
     0.270    -1.071     0.200
     0.219    -1.665     0.200
     0.478     0.142     0.200
     0.639    -0.868     0.200
     0.844    -1.185     0.200
     0.950    -1.609     0.200
     0.980    -0.454     0.200
     0.366    -0.333     0.200
     0.496    -0.997     0.200
     0.651    -0.386     0.200
     0.754    -1.147     0.200
     0.978    -0.237     0.200
     0.132    -1.048     0.200
     0.275    -0.680     0.200
     0.359    -1.296     0.200
     0.175    -0.988     0.200
     0.256     0.200     0.200
     0.233    -0.967     0.200
     0.415    -1.346     0.200
     0.856     0.684     0.200
     0.257    -1.159     0.200
     0.305    -1.043     0.200
     0.452    -1.014     0.200
     0.143    -0.632     0.200
     0.264    -0.969     0.200
     0.298    -0.384     0.200
     0.464    -1.013     0.200
     0.914     0.737     0.200
     0.126    -0.996     0.200
     0.261    -1.118     0.200
     0.341    -0.409     0.200
     0.154    -0.920     0.200
     0.251    -1.149     0.200
     0.316     0.175     0.200
     0.315     0.274     0.200
     0.383     0.009     0.200
     0.436    -1.153     0.200
     0.654    -0.910     0.200
     0.836     1.149     0.200
     0.218    -1.250     0.200
     0.260     0.201     0.200
     0.447    -1.284     0.200
     0.432     0.488     0.200
     0.710     0.754     0.200
     0.892    -0.377     0.200
     0.185    -0.859     0.200
     0.225    -0.796     0.200
     0.422    -1.228     0.200
     0.461     0.936     0.200
     0.864     0.624     0.200
     0.193    -0.950     0.200
     0.286    -1.239     0.200
     0.405    -1.040     0.200
     0.851     0.579     0.200
     0.277    -0.699     0.200
     0.347    -1.447     0.200
     0.224    -0.989     0.200
     0.182    -0.896     0.200
     0.289     0.397     0.200
     0.290     0.372     0.200
     0.430    -1.239     0.200
     0.415     0.162     0.200
     0.684     0.508     0.200
     0.878     0.695     0.200
     0.205    -0.745     0.200
     0.402    -1.537     0.200
     0.431     0.720     0.200
     0.687     0.526     0.200
     0.850     0.261     0.200
     0.133    -0.729     0.200
     0.277    -0.868     0.200
     0.345     0.296     0.200
     0.354     0.274     0.200
     0.440    -0.926     0.200
     0.622    -0.331     0.200
     0.167    -1.022     0.200
     0.239    -0.917     0.200
     0.277     0.457     0.200
     0.392    -1.075     0.200
     0.467     0.228     0.200
     0.720     0.671     0.200
     0.835     0.859     0.200
     0.606    -0.416     0.200
     0.673    -0.541     0.200
     0.181    -0.950     0.200
     0.225    -1.013     0.200
     0.295     0.582     0.200
     0.426    -1.132     0.200
     0.679     0.411     0.200
     0.325     0.026     0.200
     0.304    -0.818     0.200
     0.454    -0.673     0.200
     0.715    -0.134     0.200
     0.900    -0.751     0.200
     0.812    -0.914     0.200
     0.134    -0.978     0.200
     0.274    -0.450     0.200
     0.295     0.432     0.200
     0.353    -1.042     0.200
     0.794     0.911     0.200
     0.236    -0.075     0.200
     0.343    -0.450     0.200
     0.613    -0.325     0.200
     0.899     0.714     0.200
     0.242    -1.415     0.200
     0.266    -0.901     0.200
     0.493     0.278     0.200
     0.644    -0.913     0.200
     0.983    -0.343     0.200
     0.201    -0.897     0.200
     0.276     0.224     0.200
     0.276     0.285     0.200
     0.424    -0.767     0.200
     0.434     0.220     0.200
     0.702     0.082     0.200
     0.870     0.090     0.200
     0.677    -0.806     0.200
     0.461    -0.361     0.200
     0.428     0.436     0.200
     0.705    -0.210     0.200
     0.620     0.147     0.200
     0.087     0.791     0.200
     0.309    -0.923     0.200
     0.396     1.276     0.200
     0.480     0.926     0.200
     0.693     1.677     0.200
     0.718    -0.037     0.200
     0.822     2.616     0.200
     0.370     0.690     0.200
     0.501     0.080     0.200
     0.400     0.013     0.200
     0.029     1.067     0.200
     0.336    -0.709     0.200
     0.413     1.063     0.200
     0.701    -0.109     0.200
     0.738     1.552     0.200
     0.882     2.633     0.200
     0.018     0.778     0.200
     0.364    -0.446     0.200
     0.423     0.552     0.200
     0.672     0.005     0.200
     0.767     1.586     0.200
     0.924     2.191     0.200
     0.979     0.785     0.200
     0.402    -0.105     0.200
     0.719    -0.650     0.200
     0.456    -0.155     0.200
     0.411     0.519     0.200
     0.070    -0.203     0.200
     0.302    -0.432     0.200
     0.419     0.756     0.200
     0.723     1.652     0.200
     0.724     0.048     0.200
     0.695    -0.750     0.200
     0.033     1.562     0.200
     0.333    -0.878     0.200
     0.453     1.328     0.200
     0.412     1.325     0.200
     0.702    -0.167     0.200
     0.695     0.119     0.200
     0.736     1.820     0.200
     0.878     2.242     0.200
     0.046     1.287     0.200
     0.341    -0.699     0.200
     0.390     1.329     0.200
     0.477     0.731     0.200
     0.725    -0.561     0.200
     0.685     0.198     0.200
     0.712     1.874     0.200
     0.367     0.591     0.200
     0.013     0.557     0.200
     0.367    -0.755     0.200
     0.451     0.735     0.200
     0.416     0.859     0.200
     0.698     0.083     0.200
     0.667    -0.059     0.200
     0.761     1.409     0.200
     0.921     2.526     0.200
     0.978     0.503     0.200
     0.451    -0.837     0.200
     0.699    -0.988     0.200
     0.449    -0.062     0.200
     0.421     0.095     0.200
     0.487     0.940     0.200
     0.384     0.624     0.200
     0.180     0.905     0.200
     0.196     1.597     0.200
     0.767     1.753     0.200
     0.455     0.116     0.200
     0.412     0.429     0.200
     0.372     0.654     0.200
     0.364    -0.985     0.200
     0.379    -1.051     0.200
     0.447     0.799     0.200
     0.423     0.709     0.200
     0.660    -0.061     0.200
     0.774     1.266     0.200
     0.938     2.107     0.200
     0.963     0.653     0.200
     0.380     0.686     0.200
     0.499     0.457     0.200
     0.714    -0.627     0.200
     0.744    -0.593     0.200
     0.394     1.048     0.200
     0.474     0.526     0.200
     0.499     0.666     0.200
     0.388     0.690     0.200
     0.759    -0.512     0.200
     0.399     0.597     0.200
     0.484     1.280     0.200
     0.399     0.600     0.200
     0.393     0.588     0.200
     0.476     0.688     0.200
     0.423     0.261     0.200
     0.396     0.542     0.200
     0.480     0.795     0.200
     0.553     0.666     0.200
     0.398     0.454     0.200
     0.470     0.278     0.200
     0.415     0.387     0.200
     0.402     0.647     0.200
     0.727    -0.626     0.200
     0.384     0.815     0.200
     0.488     0.752     0.200
     0.476     0.326     0.200
     0.711     0.883     0.200
     0.017     1.294     0.200
     0.356    -0.346     0.200
     0.426     1.309     0.200
     0.679     0.003     0.200
     0.766     1.716     0.200
     0.987     0.556     0.200
     0.519     0.501     0.200
     0.655     0.546     0.200
     0.701    -0.376     0.200
     0.218    -0.766     0.200
     0.188    -0.937     0.200
     0.281     0.861     0.200
     0.282    -0.398     0.200
     0.431    -1.077     0.200
     0.422    -0.028     0.200
     0.693     0.333     0.200
     0.878     0.795     0.200
     0.031     1.204     0.200
     0.331    -0.948     0.200
     0.425     1.088     0.200
     0.700    -0.249     0.200
     0.750     1.504     0.200
     0.887     2.507     0.200
     0.375     0.240     0.200
     0.500     0.202     0.200
     0.798     0.281     0.200
     0.996    -0.368     0.200
     0.358    -0.573     0.200
     0.414     0.440     0.200
     0.451     0.324     0.200
     0.411     0.386     0.200
     0.686    -0.368     0.200
     0.589     1.076     0.200
     0.154    -0.915     0.200
     0.390     0.544     0.200
     0.390     1.275     0.200
     0.408    -0.632     0.200
     0.860     0.968     0.200
     0.212    -0.724     0.200
     0.196    -0.623     0.200
     0.272     0.047     0.200
     0.273     0.741     0.200
     0.432    -1.142     0.200
     0.431    -0.504     0.200
     0.703     0.414     0.200
     0.878     0.818     0.200
     0.483     0.225     0.200
     0.682     1.066     0.200
     0.482     0.643     0.200
     0.152    -1.333     0.200
     0.254    -0.562     0.200
     0.284     0.814     0.200
     0.285     0.069     0.200
     0.374    -1.208     0.200
     0.479     0.637     0.200
     0.724     1.246     0.200
     0.816     0.184     0.200
     0.383     0.611     0.200
     0.632     0.755     0.200
     0.513     0.993     0.200
     0.181    -0.840     0.200
     0.257     0.692     0.200
     0.227    -0.653     0.200
     0.419    -1.010     0.200
     0.861     0.714     0.200
     0.133    -1.037     0.200
     0.291     0.149     0.200
     0.274    -0.797     0.200
     0.357    -1.384     0.200
     0.496     0.072     0.200
     0.732    -0.222     0.200
     0.797     0.685     0.200
     0.881     0.915     0.200
     0.914     1.293     0.200
     0.175    -0.811     0.200
     0.232    -0.604     0.200
     0.265    -0.047     0.200
     0.265     0.533     0.200
     0.407    -1.341     0.200
     0.465     0.438     0.200
     0.725     0.365     0.200
     0.850     0.553     0.200
     0.917     0.654     0.200
     0.179    -0.963     0.200
     0.270     0.885     0.200
     0.269     0.516     0.200
     0.227    -0.634     0.200
     0.407    -1.180     0.200
     0.459     0.976     0.200
     0.719     0.389     0.200
     0.850     0.833     0.200
     0.154    -1.131     0.200
     0.257    -0.424     0.200
     0.306    -0.268     0.200
     0.307    -0.090     0.200
     0.356    -1.545     0.200
     0.422     0.607     0.200
     0.443    -0.028     0.200
     0.741     0.585     0.200
     0.176    -1.421     0.200
     0.262     0.529     0.200
     0.231    -0.552     0.200
     0.410    -1.364     0.200
     0.465    -0.198     0.200
     0.726     0.434     0.200
     0.852     0.621     0.200
     0.319    -0.913     0.200
     0.357    -1.066     0.200
     0.539     0.152     0.200
     0.720    -0.773     0.200
     0.926     0.427     0.200
     0.926    -0.140     0.200
     0.956    -0.051     0.200
     0.174    -0.560     0.200
     0.231    -0.750     0.200
     0.305    -0.543     0.200
     0.424    -0.701     0.200
     0.668    -0.959     0.200
     0.237    -1.289     0.200
     0.317    -0.037     0.200
     0.316     0.723     0.200
     0.658    -1.083     0.200
     0.169    -0.876     0.200
     0.237    -0.608     0.200
     0.287     0.029     0.200
     0.385    -1.312     0.200
     0.711     0.432     0.200
     0.829     0.829     0.200
     0.612     0.727     0.200
     0.677    -0.757     0.200
     0.079     0.790     0.200
     0.320    -0.754     0.200
     0.389     0.297     0.200
     0.484     1.579     0.200
     0.707    -0.251     0.200
     0.692     1.349     0.200
     0.829     2.307     0.200
     0.121    -1.351     0.200
     0.361    -1.478     0.200
     0.278     0.329     0.200
     0.509     0.180     0.200
     0.798     0.788     0.200
     0.189    -1.206     0.200
     0.182    -1.891     0.200
     0.540     0.421     0.200
     0.885    -0.657     0.200
     0.369    -0.733     0.200
     0.377    -0.962     0.200
     0.511     0.058     0.200
     0.902    -0.982     0.200
     0.161    -0.546     0.200
     0.244    -0.810     0.200
     0.438    -0.814     0.200
     0.888     0.806     0.200
     0.132    -0.561     0.200
     0.269     0.859     0.200
     0.378    -0.092     0.200
     0.557    -1.283     0.200
     0.703     0.056     0.200
     0.351     0.050     0.200
     0.472     0.133     0.200
     0.570     0.065     0.200
     0.630    -0.479     0.200
     0.690    -0.587     0.200
     0.803    -0.338     0.200
     0.972    -0.555     0.200
     0.104    -0.746     0.200
     0.434    -1.002     0.200
     0.597    -0.091     0.200
     0.143    -1.147     0.200
     0.200    -1.544     0.200
     0.637    -0.219     0.200
     0.944    -0.519     0.200
     0.608     0.267     0.200
     0.063    -0.385     0.200
     0.338     0.783     0.200
     0.695    -0.829     0.200
     0.733     0.484     0.200
     0.916     1.410     0.200
     0.161    -1.121     0.200
     0.254    -0.020     0.200
     0.349    -1.048     0.200
     0.318     0.139     0.200
     0.319     0.986     0.200
     0.467     0.908     0.200
     0.795     0.925     0.200
     0.186    -0.999     0.200
     0.239     0.110     0.200
     0.135     1.133     0.200
     0.471    -1.173     0.200
     0.515    -0.130     0.200
     1.000     0.043     0.200
     0.154    -0.773     0.200
     0.254    -0.885     0.200
     0.329     0.206     0.200
     0.328     1.043     0.200
     0.428    -1.195     0.200
     0.642     0.345     0.200
     0.879     0.664     0.200
     0.198    -0.905     0.200
     0.209    -0.147     0.200
     0.297     0.641     0.200
     0.400    -0.763     0.200
     0.434     1.460     0.200
     0.689     1.135     0.200
     0.847     1.031     0.200
     0.667    -0.905     0.200
     0.216    -1.025     0.200
     0.695     0.536     0.200
     0.878     0.469     0.200
     0.156    -0.393     0.200
     0.249    -0.720     0.200
     0.306    -0.104     0.200
     0.307    -0.191     0.200
     0.442    -1.135     0.200
     0.662    -0.506     0.200
     0.841     0.170     0.200
     0.142    -1.016     0.200
     0.347    -1.125     0.200
     0.306     0.581     0.200
     0.487     0.632     0.200
     0.718    -0.594     0.200
     0.790     1.021     0.200
     0.228    -1.262     0.200
     0.291     0.279     0.200
     0.433    -1.251     0.200
     0.411     0.726     0.200
     0.681     0.378     0.200
     0.881     0.665     0.200
     0.208    -0.429     0.200
     0.284    -0.946     0.200
     0.543    -1.006     0.200
     0.758     0.407     0.200
     0.984     1.228     0.200
     0.245    -1.011     0.200
     0.319     0.698     0.200
     0.388     0.952     0.200
     0.427    -0.975     0.200
     0.877     0.742     0.200
     0.937    -0.914     0.200
     0.216    -0.512     0.200
     0.413     0.548     0.200
     0.322     1.041     0.200
     0.394    -0.708     0.200
     0.663    -0.027     0.200
     0.844     0.770     0.200
     0.325    -0.804     0.200
     0.376    -0.055     0.200
     0.551    -1.063     0.200
     0.699     0.014     0.200
     1.000     0.552     0.200
     0.288    -0.849     0.200
     0.330    -1.485     0.200
     0.378     1.057     0.200
     0.557     0.336     0.200
     0.779     0.385     0.200
     0.788    -0.793     0.200
     0.581    -0.596     0.200
     0.632    -0.792     0.200
     0.915    -1.022     0.200
     0.163    -1.136     0.200
     0.361    -1.168     0.200
     0.309    -0.005     0.200
     0.465    -0.358     0.200
     0.702     0.992     0.200
     0.806     0.762     0.200
     0.084    -0.179     0.200
     0.684    -0.630     0.200
     0.752     0.993     0.200
     0.710     0.508     0.200
     0.719    -1.122     0.200
     0.272     0.274     0.200
     0.808     0.426     0.200
     0.515     0.851     0.200
     0.316     0.157     0.200
     0.273     0.443     0.200
     0.303     0.571     0.200
     0.298     0.988     0.200
     0.298    -0.280     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.030
 1.00    0.030
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00    0.037
 1.00    0.037
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.1
 1.00    0.1
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -0.1
 1.00   -0.1
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =   0.0 (solid red line)
     0.050     5.000   Pn = green x; average =   0.0 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.1 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -0.1 (dashed green line)
EOF
gmt end
