#!/bin/bash
gmt begin sapporo1.54_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic sapporo1.54'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.476
   135.500     1.559
   136.000     1.644
   136.500     1.733
   137.000     1.824
   137.500     1.919
   138.000     2.018
   138.500     2.120
   139.000     2.225
   139.500     2.334
   140.000     2.447
   140.500     2.565
   141.000     2.686
   141.500     2.812
   142.000     2.942
   142.500     3.078
   143.000     3.218
   143.500     3.364
   144.000     3.515
   144.500     3.671
   145.000     3.834
   145.500     4.003
   146.000     4.178
   146.500     4.360
   147.000     4.549
   147.500     4.745
   148.000     4.949
   148.500     5.160
   149.000     5.380
   149.500     5.609
   150.000     5.848
   150.500     6.097
   151.000     6.356
   151.500     6.625
   152.000     6.904
   152.500     7.194
   153.000     7.493
   153.500     7.803
   154.000     8.124
   154.500     8.456
   155.000     8.798
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.588
   145.500     0.388
   146.000     1.421
   146.500     2.496
   147.000     3.604
   147.500     4.742
   148.000     5.907
   148.500     7.096
   149.000     8.309
   149.500     9.545
   150.000    10.802
   150.500    12.081
   151.000    13.380
   151.500    14.698
   152.000    16.035
   152.500    17.391
   153.000    18.764
   153.500    20.155
   154.000    21.564
   154.500    22.990
   155.000    24.433
   155.500    25.893
   156.000    27.370
   156.500    28.864
   157.000    30.374
   157.500    31.901
   158.000    33.444
   158.500    35.004
   159.000    36.581
   159.500    38.173
   160.000    39.782
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.605
   145.500     0.147
   146.000     0.833
   146.500     1.469
   147.000     2.062
   147.500     2.618
   148.000     3.139
   148.500     3.628
   149.000     4.091
   149.500     4.535
   150.000     4.963
   150.500     5.379
   151.000     5.784
   151.500     6.180
   152.000     6.568
   152.500     6.948
   153.000     7.323
   153.500     7.694
   154.000     8.062
   154.500     8.428
   155.000     8.792
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   142.404    -0.243     0.200
   142.454    -0.331     0.200
   142.573    -4.962     0.200
   142.525    -4.302     0.200
   143.010     0.838     0.200
   142.602    -0.086     0.200
   143.035    -0.353     0.200
   142.276    -5.063     0.200
   142.987    -0.322     0.200
   152.361     0.071     0.200
   142.714    -4.500     0.200
   142.888    -0.809     0.200
   151.934     1.639     0.200
   151.842     0.878     0.200
   152.007     1.630     0.200
   152.352    -1.384     0.200
   153.058    -0.420     0.200
   142.607    -0.245     0.200
   143.041     0.988     0.200
   142.523    -0.763     0.200
   142.956    -1.530     0.200
   152.071     1.640     0.200
   142.513    -0.794     0.200
   151.818     0.771     0.200
   151.872     1.691     0.200
   142.561    -0.618     0.200
   142.372    -5.296     0.200
   143.333    -0.997     0.200
   143.213    -1.386     0.200
   151.871     0.735     0.200
   152.057     0.258     0.200
   142.961    -1.120     0.200
   142.533    -4.099     0.200
   142.792    -2.058     0.200
   143.009    -0.941     0.200
   146.806    -0.094     0.200
   147.010    -0.459     0.200
   151.851    -2.478     0.200
   143.149    -1.541     0.200
   143.174    -2.056     0.200
   143.392    -0.540     0.200
   146.100    -0.325     0.200
   147.595     1.764     0.200
   150.709     2.360     0.200
   151.756     1.062     0.200
   152.141     0.385     0.200
   152.165     2.450     0.200
   152.322     1.616     0.200
   152.486    -0.027     0.200
   152.951     0.791     0.200
   153.132     1.428     0.200
   153.340     2.426     0.200
   154.707     0.096     0.200
   155.808     3.601     0.200
   159.331     1.010     0.200
   141.110    -2.478     0.200
   143.065    -1.565     0.200
   143.283    -1.348     0.200
   150.607     0.720     0.200
   151.985     0.318     0.200
   152.224    -1.538     0.200
   152.388     0.718     0.200
   152.849     1.040     0.200
   159.237    -0.180     0.200
   151.999     0.279     0.200
   143.080    -2.713     0.200
   143.298    -1.301     0.200
   151.975    -1.594     0.200
   152.256     2.190     0.200
   143.134    -3.037     0.200
   143.352     0.879     0.200
   143.227    -2.356     0.200
   143.445    -0.939     0.200
   143.055    -2.199     0.200
   143.272    -0.583     0.200
   142.977    -1.253     0.200
   143.195    -0.137     0.200
   146.949     0.221     0.200
   142.747    -0.416     0.200
   142.964     0.598     0.200
   143.309     0.298     0.200
   142.334    -1.108     0.200
   142.552    -0.291     0.200
   159.612    -2.016     0.200
   142.752    -1.524     0.200
   142.969    -1.509     0.200
   146.661    -0.585     0.200
   146.514     0.960     0.200
   142.759    -0.519     0.200
   143.261     0.395     0.200
   144.826     0.465     0.200
   151.895     1.468     0.200
   146.969     0.276     0.200
   142.788     0.184     0.200
   143.290     1.298     0.200
   142.783    -0.531     0.200
   143.286     1.285     0.200
   144.849     1.557     0.200
   150.365     0.442     0.200
   151.200     2.653     0.200
   143.282     0.998     0.200
   142.985    -3.349     0.200
   143.203     1.267     0.200
   143.488     0.764     0.200
   143.336     0.932     0.200
   148.035     0.206     0.200
   150.375     1.552     0.200
   142.751     0.085     0.200
   142.643    -3.128     0.200
   142.786    -2.707     0.200
   142.993    -0.473     0.200
   142.865    -0.699     0.200
   142.761    -0.665     0.200
   146.134    -0.971     0.200
   145.899    -1.206     0.200
   147.479    -0.564     0.200
   147.878     0.077     0.200
   152.042    -3.587     0.200
   142.841     0.532     0.200
   146.120    -0.299     0.200
   146.158    -0.157     0.200
   146.120    -0.571     0.200
   147.695    -0.008     0.200
   147.948    -0.227     0.200
   148.093     0.132     0.200
   146.112    -1.005     0.200
   146.112    -1.466     0.200
   146.336    -0.214     0.200
   146.181    -0.081     0.200
   142.835    -0.772     0.200
   146.092    -0.073     0.200
   156.958    -0.047     0.200
   142.758    -4.475     0.200
   147.838     0.013     0.200
   148.093    -0.307     0.200
   148.066    -0.722     0.200
   142.743     0.253     0.200
   146.247    -0.012     0.200
   139.535     0.137     0.200
   146.157    -0.047     0.200
   147.732     0.915     0.200
   147.985     1.197     0.200
   151.761     1.168     0.200
   151.762     1.886     0.200
   156.885    -0.563     0.200
   139.530     0.537     0.200
   142.754    -1.124     0.200
   146.154    -0.456     0.200
   151.763     1.200     0.200
   139.569     0.786     0.200
   142.636    -4.447     0.200
   142.799    -1.657     0.200
   146.131    -0.214     0.200
   151.790     1.471     0.200
   151.790     1.418     0.200
   156.922     0.246     0.200
   142.793    -0.897     0.200
   146.266    -0.044     0.200
   142.666    -4.445     0.200
   146.158    -0.912     0.200
   146.158    -0.213     0.200
   146.158    -0.541     0.200
   147.733    -0.851     0.200
   147.985    -0.866     0.200
   146.077    -0.176     0.200
   147.650    -1.417     0.200
   147.901    -1.433     0.200
   148.048    -0.676     0.200
   142.384     0.478     0.200
   146.339    -0.895     0.200
   147.908    -0.214     0.200
   148.151    -0.414     0.200
   148.306    -0.168     0.200
   149.292    -0.984     0.200
   146.151    -0.272     0.200
   146.594     0.893     0.200
   147.715    -0.133     0.200
   148.113     0.007     0.200
   148.146     0.274     0.200
   142.842    -0.968     0.200
   146.124    -0.333     0.200
   145.976    -0.752     0.200
   145.976    -0.455     0.200
   145.976    -1.084     0.200
   147.950     0.442     0.200
   145.929    -1.196     0.200
   142.768     0.273     0.200
   143.656     0.777     0.200
   146.161    -0.429     0.200
   154.861     1.009     0.200
   139.582     0.373     0.200
   146.126    -0.922     0.200
   146.126    -1.180     0.200
   147.701     0.456     0.200
   147.955     0.361     0.200
   148.100     0.612     0.200
   156.937    -0.770     0.200
   146.314    -1.458     0.200
   146.314    -0.388     0.200
   142.848     0.422     0.200
   146.121    -0.279     0.200
   146.173    -0.577     0.200
   146.579    -1.600     0.200
   146.579     0.210     0.200
   148.405    -0.908     0.200
   147.527     0.686     0.200
   147.791    -0.711     0.200
   139.915     0.022     0.200
   144.817    -0.021     0.200
   145.894    -0.894     0.200
   145.894    -0.359     0.200
   147.736     0.555     0.200
   144.576     0.653     0.200
   146.171    -0.187     0.200
   144.390    -0.236     0.200
   145.885     0.512     0.200
   146.266    -0.687     0.200
   142.806    -0.154     0.200
   144.438     0.498     0.200
   146.162    -0.215     0.200
   146.162    -0.435     0.200
   146.162    -1.542     0.200
   151.763    -0.512     0.200
   142.778    -0.100     0.200
   146.144    -0.247     0.200
   147.247     1.990     0.200
   147.971    -0.480     0.200
   154.858     2.579     0.200
   155.180     0.147     0.200
   146.142    -0.547     0.200
   149.982     1.751     0.200
   142.859    -1.890     0.200
   146.111    -0.525     0.200
   146.655     1.298     0.200
   147.943    -0.907     0.200
   148.086    -0.723     0.200
   142.803     1.149     0.200
   142.803     1.257     0.200
   146.007    -0.295     0.200
   151.749    -0.373     0.200
   143.593     1.074     0.200
   144.587    -3.313     0.200
   146.043    -0.885     0.200
   151.930     2.932     0.200
   156.123     2.099     0.200
   157.663     0.053     0.200
   157.663    -0.150     0.200
   146.176    -0.158     0.200
   146.724    -1.237     0.200
   144.112     0.665     0.200
   144.652    -0.033     0.200
   145.080     0.098     0.200
   146.107    -0.564     0.200
   146.107    -0.261     0.200
   146.122     0.615     0.200
   147.974    -0.747     0.200
   144.346    -4.413     0.200
   146.079    -0.517     0.200
   142.770    -1.674     0.200
   144.997     0.302     0.200
   146.157    -0.603     0.200
   150.994     2.747     0.200
   151.422     2.303     0.200
   152.632     1.955     0.200
   153.085     2.344     0.200
   153.912     2.408     0.200
   154.758     2.066     0.200
   154.860    -0.485     0.200
   155.384     2.672     0.200
   156.892    -1.611     0.200
   142.807    -0.802     0.200
   142.807    -1.278     0.200
   144.601    -1.719     0.200
   146.128    -1.456     0.200
   146.128    -0.941     0.200
   147.703    -0.909     0.200
   148.101    -1.511     0.200
   153.813     3.179     0.200
   153.944     2.407     0.200
   155.413     4.198     0.200
   144.648    -1.709     0.200
   146.174    -0.060     0.200
   142.808    -0.891     0.200
   144.018     0.961     0.200
   144.436    -0.137     0.200
   144.487    -0.277     0.200
   144.607    -1.484     0.200
   145.387    -0.818     0.200
   139.560    -0.450     0.200
   142.615    -4.672     0.200
   143.994    -0.591     0.200
   144.286    -3.138     0.200
   144.473    -0.644     0.200
   144.608    -1.491     0.200
   146.134    -1.238     0.200
   146.134    -1.008     0.200
   146.134    -1.387     0.200
   146.537    -0.940     0.200
   155.512     4.355     0.200
   156.909     0.524     0.200
   144.668     0.346     0.200
   144.668     0.205     0.200
   144.671    -0.679     0.200
   144.772    -1.859     0.200
   144.980     0.254     0.200
   146.323    -0.517     0.200
   147.237     1.724     0.200
   147.338     1.504     0.200
   147.338     2.145     0.200
   147.476     2.505     0.200
   148.102     0.592     0.200
   149.271     1.342     0.200
   150.570     1.943     0.200
   151.131     1.077     0.200
   151.857    -0.613     0.200
   152.780     0.678     0.200
   154.778     1.913     0.200
   155.135     0.585     0.200
   155.552     1.489     0.200
   157.292     0.704     0.200
   157.567     1.531     0.200
   138.132    -1.021     0.200
   138.992    -1.269     0.200
   142.193    -0.238     0.200
   143.909    -1.526     0.200
   145.534    -1.349     0.200
   151.102    -1.875     0.200
   138.706     0.433     0.200
   144.272    -2.224     0.200
   144.583    -1.447     0.200
   146.110    -0.552     0.200
   138.755    -5.121     0.200
   139.811    -2.119     0.200
   142.175     0.516     0.200
   143.231     1.261     0.200
   143.245     0.712     0.200
   144.696    -2.096     0.200
   144.710     0.177     0.200
   145.631     0.092     0.200
   146.244    -1.671     0.200
   146.244     0.063     0.200
   146.244    -0.827     0.200
   146.892     0.681     0.200
   147.307     2.128     0.200
   147.379     1.633     0.200
   147.472     0.666     0.200
   147.472     1.064     0.200
   147.472     2.033     0.200
   148.135     2.632     0.200
   148.426     2.524     0.200
   149.252     2.506     0.200
   149.322     2.206     0.200
   150.634     2.755     0.200
   151.107     2.377     0.200
   151.630     2.333     0.200
   151.723     4.973     0.200
   151.946     1.670     0.200
   152.663     2.292     0.200
   152.739     2.182     0.200
   153.066     2.821     0.200
   153.342     4.249     0.200
   153.342     0.921     0.200
   153.425     1.747     0.200
   153.941     2.511     0.200
   154.897     2.677     0.200
   155.052     1.715     0.200
   155.175     3.047     0.200
   155.223     4.185     0.200
   155.737    -0.656     0.200
   155.737     3.524     0.200
   155.776     2.324     0.200
   156.929     3.240     0.200
   157.313    -1.621     0.200
   157.313     4.035     0.200
   157.650     2.972     0.200
   157.881     4.288     0.200
   157.911     3.291     0.200
   158.297     3.140     0.200
   158.470     2.932     0.200
   158.671     3.644     0.200
   158.981     4.238     0.200
   159.015     3.557     0.200
   159.159     2.756     0.200
   159.427     2.445     0.200
   159.705     4.135     0.200
   144.639    -2.200     0.200
   144.762    -0.733     0.200
   145.428    -1.701     0.200
   146.017     0.527     0.200
   146.187    -0.301     0.200
   146.187    -0.950     0.200
   146.187    -0.145     0.200
   146.716    -1.203     0.200
   147.903     1.914     0.200
   144.543    -1.940     0.200
   146.091    -0.670     0.200
   146.091    -0.373     0.200
   147.524     0.243     0.200
   146.361     0.122     0.200
   146.264    -0.701     0.200
   144.710    -4.058     0.200
   146.287    -0.362     0.200
   146.287     0.005     0.200
   146.250    -0.984     0.200
   143.232     0.496     0.200
   144.693    -2.230     0.200
   146.241    -0.806     0.200
   146.241    -0.962     0.200
   146.205    -0.928     0.200
   146.924     0.750     0.200
   155.743    -1.595     0.200
   146.253    -0.469     0.200
   146.222     0.028     0.200
   136.024    -1.252     0.200
   138.725    -0.294     0.200
   139.023     0.231     0.200
   139.803    -1.346     0.200
   141.351    -1.410     0.200
   142.174     0.579     0.200
   142.637    -5.205     0.200
   142.993    -1.281     0.200
   143.218    -2.459     0.200
   143.253    -1.255     0.200
   144.697    -1.637     0.200
   144.702    -0.833     0.200
   144.724    -1.176     0.200
   145.283     0.101     0.200
   145.638     0.078     0.200
   146.244    -1.071     0.200
   146.244    -0.664     0.200
   146.244    -0.906     0.200
   146.662     0.521     0.200
   147.304     0.546     0.200
   147.371     0.388     0.200
   147.371     0.638     0.200
   147.457     1.511     0.200
   147.457     0.690     0.200
   148.126     0.476     0.200
   148.231     0.795     0.200
   148.432     0.177     0.200
   148.715     0.069     0.200
   149.254     0.433     0.200
   149.316     0.435     0.200
   150.191    -0.467     0.200
   150.631     0.456     0.200
   151.113     0.408     0.200
   151.722     1.115     0.200
   151.948     0.503     0.200
   152.611    -0.787     0.200
   152.652     0.629     0.200
   152.744     0.447     0.200
   152.761    -1.397     0.200
   152.981    -0.570     0.200
   153.139    -1.004     0.200
   153.258    -1.433     0.200
   153.287    -1.404     0.200
   153.334     0.597     0.200
   153.368    -1.584     0.200
   153.387    -0.291     0.200
   153.411     0.839     0.200
   153.823    -1.025     0.200
   153.902     0.082     0.200
   155.180     0.471     0.200
   155.717     0.006     0.200
   155.717     1.037     0.200
   155.768     0.367     0.200
   156.919     0.567     0.200
   157.301    -0.754     0.200
   158.465     0.337     0.200
   158.664    -1.409     0.200
   146.175    -0.547     0.200
   146.251    -0.407     0.200
   146.149    -0.314     0.200
   146.149    -0.513     0.200
   146.342    -0.776     0.200
   146.166    -0.594     0.200
   146.148    -0.320     0.200
   143.212    -0.290     0.200
   144.729    -1.687     0.200
   146.278    -0.257     0.200
   146.278    -0.476     0.200
   146.307    -0.024     0.200
   146.234    -0.292     0.200
   144.709    -2.046     0.200
   146.258    -0.438     0.200
   146.284    -1.068     0.200
   144.564     0.065     0.200
   144.819    -1.127     0.200
   146.365    -0.272     0.200
   147.233     0.227     0.200
   147.320     2.163     0.200
   151.600     1.161     0.200
   155.620    -0.118     0.200
   157.161     0.299     0.200
   146.239    -0.613     0.200
   146.265    -0.380     0.200
   146.370    -0.636     0.200
   144.686    -1.996     0.200
   146.234    -0.482     0.200
   148.099     1.018     0.200
   146.281     0.022     0.200
   146.254    -0.580     0.200
   143.252     0.766     0.200
   144.655    -3.115     0.200
   144.676    -1.878     0.200
   146.224    -0.298     0.200
   146.224    -0.689     0.200
   146.170    -0.418     0.200
   138.786     0.113     0.200
   146.278    -0.679     0.200
   146.201    -0.364     0.200
   146.324    -1.444     0.200
   138.687    -1.893     0.200
   144.621    -2.179     0.200
   146.167    -1.613     0.200
   146.167    -0.711     0.200
   146.167    -0.473     0.200
   149.371     1.764     0.200
   144.577    -0.135     0.200
   144.790    -2.455     0.200
   144.829    -1.512     0.200
   145.040     0.344     0.200
   145.274     0.591     0.200
   146.377    -0.550     0.200
   146.377     0.110     0.200
   146.377    -0.133     0.200
   138.680    -0.913     0.200
   139.082    -0.157     0.200
   142.560    -5.225     0.200
   143.267    -2.475     0.200
   144.617    -1.929     0.200
   146.164    -0.786     0.200
   146.164    -0.997     0.200
   146.943     0.289     0.200
   155.703    -1.667     0.200
   146.243    -0.257     0.200
   146.185    -0.554     0.200
   146.178    -0.748     0.200
   146.178    -0.885     0.200
   143.345     1.168     0.200
   144.550    -2.228     0.200
   146.098    -1.564     0.200
   146.098    -0.654     0.200
   146.098    -0.257     0.200
   147.511     1.292     0.200
   147.962     0.974     0.200
   146.382    -0.196     0.200
   146.382    -0.543     0.200
   146.174    -0.128     0.200
   146.103    -0.439     0.200
   144.744    -2.047     0.200
   146.292    -0.120     0.200
   148.279     0.970     0.200
   138.693    -0.126     0.200
   138.750    -0.309     0.200
   142.631    -4.663     0.200
   142.767    -1.600     0.200
   144.447    -0.640     0.200
   144.455     0.620     0.200
   144.625     0.021     0.200
   144.624    -0.642     0.200
   144.623    -1.531     0.200
   146.149    -0.469     0.200
   146.149    -1.048     0.200
   146.149    -1.180     0.200
   147.115     0.920     0.200
   147.724    -0.327     0.200
   147.977    -0.666     0.200
   148.122    -0.671     0.200
   151.769     0.137     0.200
   154.847    -0.470     0.200
   156.891     0.068     0.200
   138.976     0.064     0.200
   142.705    -4.588     0.200
   144.648    -0.314     0.200
   144.648    -0.646     0.200
   144.661    -2.197     0.200
   144.728    -0.973     0.200
   144.768    -1.580     0.200
   145.210    -0.406     0.200
   145.557    -0.061     0.200
   146.316     0.088     0.200
   146.316    -1.033     0.200
   146.316    -1.638     0.200
   147.001     0.494     0.200
   147.237     0.307     0.200
   147.318     0.074     0.200
   148.352     0.175     0.200
   148.736     1.017     0.200
   149.179     0.295     0.200
   149.257     0.579     0.200
   149.263     1.999     0.200
   150.145     1.330     0.200
   150.565     0.173     0.200
   151.651    -0.061     0.200
   151.741     1.074     0.200
   151.872    -0.373     0.200
   151.939     1.379     0.200
   151.975     1.094     0.200
   151.975     1.825     0.200
   152.190     1.131     0.200
   152.230     0.341     0.200
   152.348    -0.282     0.200
   152.468    -0.011     0.200
   152.656     0.083     0.200
   152.656     0.814     0.200
   152.665     0.110     0.200
   152.758    -0.027     0.200
   152.974    -0.383     0.200
   153.136    -0.259     0.200
   153.262    -1.172     0.200
   153.278    -0.464     0.200
   153.434     0.781     0.200
   153.644    -0.990     0.200
   153.727    -0.736     0.200
   153.986     0.692     0.200
   154.138     0.029     0.200
   154.489     0.019     0.200
   155.526    -2.800     0.200
   155.738    -0.915     0.200
   155.738    -2.415     0.200
   157.259    -0.301     0.200
   157.259    -0.441     0.200
   146.119    -0.443     0.200
   146.119    -0.041     0.200
   146.170    -0.283     0.200
   146.169    -0.956     0.200
   146.169     0.011     0.200
   146.253    -1.232     0.200
   146.365    -0.557     0.200
   146.128    -0.336     0.200
   144.616    -1.542     0.200
   146.143    -0.782     0.200
   146.143    -0.246     0.200
   146.293    -0.561     0.200
   146.256    -0.240     0.200
   146.256    -0.107     0.200
   145.645    -0.663     0.200
   150.873    -0.520     0.200
   137.922    -0.030     0.200
   141.865    -0.799     0.200
   141.865     0.681     0.200
   143.612    -1.332     0.200
   143.612    -1.152     0.200
   143.820    -0.608     0.200
   144.079    -0.560     0.200
   144.081    -0.604     0.200
   144.724    -0.501     0.200
   144.750    -0.126     0.200
   144.750     0.124     0.200
   146.267    -0.404     0.200
   146.780     0.381     0.200
   146.941     0.331     0.200
   148.048     0.903     0.200
   148.324     0.991     0.200
   149.803     1.561     0.200
   150.180     1.016     0.200
   150.687    -0.714     0.200
   152.207     0.380     0.200
   152.241    -0.809     0.200
   153.205     0.686     0.200
   144.434    -2.196     0.200
   144.428    -0.594     0.200
   144.823     0.518     0.200
   144.606    -1.884     0.200
   146.180    -0.146     0.200
   146.180    -0.568     0.200
   143.018     0.129     0.200
   144.556    -2.718     0.200
   144.903    -0.912     0.200
   146.091    -0.864     0.200
   146.091    -0.235     0.200
   155.196    -0.059     0.200
   142.804    -0.228     0.200
   143.487     0.099     0.200
   144.484    -0.260     0.200
   144.664     0.812     0.200
   144.608    -1.693     0.200
   145.175     0.532     0.200
   146.136    -0.103     0.200
   146.136    -1.517     0.200
   146.136    -0.704     0.200
   146.136    -0.431     0.200
   159.766     0.885     0.200
   146.108    -0.104     0.200
   146.108    -0.425     0.200
   147.939    -0.777     0.200
   148.083    -0.247     0.200
   142.927     1.180     0.200
   142.927     0.500     0.200
   144.462    -1.978     0.200
   144.774     1.411     0.200
   145.989    -0.752     0.200
   145.989    -0.268     0.200
   147.819     0.485     0.200
   147.963    -1.346     0.200
   143.308     0.685     0.200
   144.480     0.526     0.200
   144.480    -0.525     0.200
   144.480    -1.365     0.200
   144.621    -1.231     0.200
   144.622    -1.607     0.200
   144.670     0.838     0.200
   145.395    -0.955     0.200
   146.034    -0.184     0.200
   146.150    -0.950     0.200
   146.150    -0.540     0.200
   146.150    -0.236     0.200
   146.150    -1.411     0.200
   147.300     1.104     0.200
   147.300     0.194     0.200
   147.726    -0.161     0.200
   147.980    -1.002     0.200
   148.124    -0.497     0.200
   148.787     0.250     0.200
   149.159    -0.351     0.200
   149.416     0.399     0.200
   150.576    -0.089     0.200
   152.606    -0.958     0.200
   152.562    -0.003     0.200
   152.939    -0.755     0.200
   153.109    -0.422     0.200
   153.925    -0.241     0.200
   154.411     2.276     0.200
   156.927     0.163     0.200
   146.001    -0.163     0.200
   146.001    -0.971     0.200
   142.753     0.942     0.200
   142.753     0.661     0.200
   146.267    -0.305     0.200
   146.267     0.113     0.200
   146.267    -0.174     0.200
   148.242     1.388     0.200
   143.036     1.007     0.200
   144.577    -1.422     0.200
   146.113    -0.462     0.200
   142.648    -4.929     0.200
   142.762     0.416     0.200
   146.168    -1.104     0.200
   146.168    -0.042     0.200
   147.236     1.880     0.200
   147.743    -0.812     0.200
   148.141     0.109     0.200
   151.832    -1.919     0.200
   152.553    -0.719     0.200
   152.497    -0.948     0.200
   152.606    -0.632     0.200
   153.076    -1.209     0.200
   156.884     0.708     0.200
   146.179    -0.224     0.200
   142.797    -0.365     0.200
   146.125    -0.347     0.200
   146.125    -0.070     0.200
   147.700    -0.198     0.200
   148.098    -0.132     0.200
   146.131    -0.300     0.200
   142.765    -3.147     0.200
   143.661     1.280     0.200
   144.822     0.029     0.200
   145.417     0.623     0.200
   146.159    -0.551     0.200
   146.159    -0.245     0.200
   149.410     0.564     0.200
   145.918    -0.965     0.200
   147.494     0.479     0.200
   147.748     0.932     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   146.572     0.981     0.200
   146.667     0.454     0.200
   146.826     0.789     0.200
   151.884     5.903     0.200
   147.010     1.041     0.200
   147.048     2.075     0.200
   152.075     5.183     0.200
   145.991    -0.042     0.200
   152.051     3.219     0.200
   152.034     4.473     0.200
   147.012     1.505     0.200
   147.004     1.808     0.200
   148.789     3.298     0.200
   149.140     2.430     0.200
   146.687     1.840     0.200
   146.967     1.970     0.200
   148.820     2.917     0.200
   146.678     0.806     0.200
   148.793     3.810     0.200
   151.533     5.213     0.200
   146.687     1.850     0.200
   151.923     6.088     0.200
   146.671     1.156     0.200
   146.830     2.090     0.200
   149.834     3.106     0.200
   150.375     4.849     0.200
   148.038     2.899     0.200
   148.059     3.065     0.200
   146.571     1.342     0.200
   147.727     2.412     0.200
   147.979     2.195     0.200
   146.547     1.438     0.200
   147.749     3.331     0.200
   148.274     2.821     0.200
   148.104     2.516     0.200
   148.351     2.413     0.200
   148.503     2.767     0.200
   151.366     5.447     0.200
   146.721     0.602     0.200
   147.479     1.737     0.200
   147.878     2.175     0.200
   146.577     1.632     0.200
   146.375     0.546     0.200
   147.947     2.622     0.200
   148.195     2.515     0.200
   151.528     5.388     0.200
   146.568     1.251     0.200
   147.732     2.205     0.200
   147.985     2.187     0.200
   146.147     0.577     0.200
   147.729     2.129     0.200
   147.992     1.792     0.200
   147.695     2.289     0.200
   147.948     2.371     0.200
   148.093     2.835     0.200
   147.688     2.150     0.200
   147.943     2.627     0.200
   147.906     2.764     0.200
   148.152     2.758     0.200
   146.147     0.178     0.200
   147.722     1.344     0.200
   147.976     1.519     0.200
   148.120     1.781     0.200
   151.737     5.300     0.200
   146.138     0.174     0.200
   147.966     2.415     0.200
   146.486     0.434     0.200
   146.516     0.918     0.200
   146.516     0.668     0.200
   146.116     0.037     0.200
   147.692     2.395     0.200
   146.092     0.126     0.200
   148.066     2.628     0.200
   147.838     2.613     0.200
   148.093     2.393     0.200
   148.236     2.958     0.200
   148.221     3.297     0.200
   147.975     3.478     0.200
   146.892     1.545     0.200
   148.130     2.159     0.200
   147.728     2.312     0.200
   147.981     1.990     0.200
   147.706     2.545     0.200
   147.960     2.228     0.200
   148.104     3.287     0.200
   147.715     1.202     0.200
   147.970     1.980     0.200
   146.156     0.071     0.200
   147.732     2.830     0.200
   147.986     2.606     0.200
   148.130     3.471     0.200
   147.697     2.116     0.200
   147.952     2.001     0.200
   146.266     0.956     0.200
   147.841     2.624     0.200
   148.093     2.408     0.200
   146.158     0.889     0.200
   147.733     2.051     0.200
   147.985     2.033     0.200
   147.650     2.184     0.200
   147.901     1.270     0.200
   147.901     3.270     0.200
   148.048     2.723     0.200
   146.339     0.207     0.200
   146.339     0.707     0.200
   147.908     2.985     0.200
   148.151     2.687     0.200
   148.306     3.531     0.200
   147.726     2.288     0.200
   147.979     2.472     0.200
   147.747     2.730     0.200
   147.552     2.198     0.200
   147.806     1.578     0.200
   150.719     4.934     0.200
   146.618     1.629     0.200
   146.947     2.204     0.200
   146.947     1.903     0.200
   147.908     2.149     0.200
   148.194     2.335     0.200
   151.659     5.156     0.200
   146.985     1.861     0.200
   147.698     1.790     0.200
   147.747     2.411     0.200
   148.000     2.115     0.200
   146.579     0.524     0.200
   148.552     3.043     0.200
   147.873     2.114     0.200
   146.006     0.639     0.200
   146.171     0.278     0.200
   146.266     0.222     0.200
   147.993     2.158     0.200
   148.137     2.496     0.200
   148.117     2.856     0.200
   146.382     0.271     0.200
   146.382     1.209     0.200
   147.687     2.040     0.200
   146.133     0.437     0.200
   147.708     2.284     0.200
   147.962     1.942     0.200
   148.107     2.165     0.200
   147.589     1.142     0.200
   147.854     1.653     0.200
   146.168     0.106     0.200
   147.743     2.274     0.200
   147.995     2.381     0.200
   146.463     0.856     0.200
   148.032     2.417     0.200
   148.430     3.196     0.200
   145.312    -1.777     0.200
   146.043     0.311     0.200
   147.636     2.033     0.200
   147.921     2.230     0.200
   148.035     2.366     0.200
   151.430     5.269     0.200
   151.930     4.143     0.200
   148.099     3.463     0.200
   148.362     3.335     0.200
   148.497     3.810     0.200
   147.697     1.149     0.200
   148.096     2.453     0.200
   152.540     6.322     0.200
   147.659     1.589     0.200
   147.922     1.656     0.200
   148.058     2.674     0.200
   146.157     0.157     0.200
   146.574     1.291     0.200
   146.901     1.587     0.200
   146.901     2.042     0.200
   146.930     2.194     0.200
   147.113     2.626     0.200
   147.286     2.339     0.200
   147.484     2.840     0.200
   147.732     2.227     0.200
   147.985     2.208     0.200
   148.079     3.516     0.200
   148.130     2.687     0.200
   148.318     3.134     0.200
   148.528     2.371     0.200
   148.795     2.668     0.200
   149.411     2.517     0.200
   150.558     2.799     0.200
   152.729     4.963     0.200
   146.625     0.837     0.200
   152.641     5.193     0.200
   152.723     3.572     0.200
   146.134     0.149     0.200
   147.148     2.099     0.200
   147.709     2.060     0.200
   147.963     3.352     0.200
   149.171     4.312     0.200
   151.875     6.138     0.200
   152.245     4.587     0.200
   147.133     1.251     0.200
   148.163     3.215     0.200
   149.006     3.893     0.200
   151.605     5.263     0.200
   151.785     3.671     0.200
   145.200     1.056     0.200
   146.323     0.588     0.200
   147.912     1.669     0.200
   148.191     2.048     0.200
   148.311     2.998     0.200
   145.058    -1.172     0.200
   146.566     1.128     0.200
   147.573     1.873     0.200
   148.146     2.548     0.200
   148.389     2.441     0.200
   148.544     2.886     0.200
   149.160     2.933     0.200
   149.363     3.467     0.200
   149.604     3.612     0.200
   151.102     4.495     0.200
   146.110     0.046     0.200
   147.865     3.319     0.200
   147.939     2.853     0.200
   148.832     2.828     0.200
   145.283     0.868     0.200
   148.108     1.864     0.200
   148.231     2.545     0.200
   145.206    -0.554     0.200
   145.226    -1.440     0.200
   146.942     1.691     0.200
   147.431     2.500     0.200
   148.051     1.794     0.200
   148.174     1.521     0.200
   147.589     1.518     0.200
   147.956     1.435     0.200
   148.079     1.788     0.200
   150.093     4.029     0.200
   152.706     5.783     0.200
   148.106     1.807     0.200
   148.229     3.348     0.200
   151.726     6.001     0.200
   146.163     0.033     0.200
   145.029    -0.915     0.200
   145.151    -0.547     0.200
   146.451     1.103     0.200
   147.457     1.706     0.200
   148.108     1.466     0.200
   148.758     2.296     0.200
   150.691     4.433     0.200
   151.460     5.152     0.200
   152.401     6.446     0.200
   152.611     5.830     0.200
   152.642     5.965     0.200
   152.673     6.248     0.200
   153.139     6.848     0.200
   153.287     6.596     0.200
   153.368     7.033     0.200
   153.411     7.089     0.200
   153.823     6.827     0.200
   146.360     0.948     0.200
   146.250     0.459     0.200
   146.334     1.083     0.200
   147.866     1.857     0.200
   148.143     1.638     0.200
   148.265     2.847     0.200
   151.690     4.937     0.200
   146.344     1.018     0.200
   146.365     0.239     0.200
   146.365     0.517     0.200
   147.952     1.932     0.200
   148.226     2.096     0.200
   148.351     2.320     0.200
   147.823     1.547     0.200
   148.222     2.183     0.200
   147.401     2.764     0.200
   147.813     1.510     0.200
   148.089     1.719     0.200
   148.212     1.791     0.200
   146.350     0.546     0.200
   146.216     0.297     0.200
   147.466     2.401     0.200
   147.466     2.124     0.200
   147.755     1.739     0.200
   148.028     1.303     0.200
   148.153     2.089     0.200
   151.797     4.945     0.200
   145.050    -0.733     0.200
   147.247     2.039     0.200
   147.965     2.074     0.200
   148.240     2.013     0.200
   148.364     2.438     0.200
   151.365     5.481     0.200
   151.590     5.770     0.200
   152.337     5.892     0.200
   147.751     1.162     0.200
   148.026     2.060     0.200
   148.150     1.856     0.200
   151.802     5.602     0.200
   146.156     0.447     0.200
   151.782     4.354     0.200
   147.687     1.444     0.200
   148.085     1.810     0.200
   150.087     3.721     0.200
   146.292     0.150     0.200
   147.880     1.626     0.200
   148.156     1.348     0.200
   151.675     5.904     0.200
   146.929     1.708     0.200
   147.236     1.444     0.200
   148.072     3.529     0.200
   148.144     3.590     0.200
   149.529     4.326     0.200
   149.962     3.702     0.200
   151.179     5.524     0.200
   151.992     5.905     0.200
   152.167     6.073     0.200
   144.969    -1.651     0.200
   147.905     1.917     0.200
   148.181     1.435     0.200
   148.304     2.363     0.200
   151.042     2.868     0.200
   151.118     4.950     0.200
   146.358     0.604     0.200
   146.116     0.126     0.200
   151.516     5.386     0.200
   146.128     0.095     0.200
   147.717     2.216     0.200
   147.971     2.173     0.200
   147.969     2.709     0.200
   148.210     2.571     0.200
   146.765     1.819     0.200
   146.267     0.747     0.200
   146.564     1.016     0.200
   146.780     1.247     0.200
   146.780     1.388     0.200
   148.344     3.020     0.200
   148.580     2.925     0.200
   148.742     3.561     0.200
   149.077     4.269     0.200
   150.767     5.043     0.200
   146.869     1.720     0.200
   147.546     1.548     0.200
   147.806     1.234     0.200
   151.972     4.696     0.200
   146.142     0.487     0.200
   146.769     1.557     0.200
   147.723     1.578     0.200
   147.987     3.007     0.200
   145.032    -1.313     0.200
   147.932     1.335     0.200
   146.607     1.414     0.200
   147.711     1.874     0.200
   147.965     2.197     0.200
   148.543     2.431     0.200
   151.786     6.073     0.200
   152.734     5.181     0.200
   147.565     1.570     0.200
   145.184     0.119     0.200
   151.907     6.039     0.200
   151.979     6.091     0.200
   146.113     0.479     0.200
   146.113     0.163     0.200
   147.694     1.668     0.200
   145.341     0.338     0.200
   146.168     0.279     0.200
   147.743     2.336     0.200
   148.073     2.463     0.200
   149.218     3.940     0.200
   150.710     5.073     0.200
   154.860     7.668     0.200
   146.531     1.019     0.200
   145.342     0.892     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   148.837     8.491     0.200
   152.190    17.383     0.200
   145.969     1.339     0.200
   146.540     2.570     0.200
   146.715     2.975     0.200
   151.818    16.470     0.200
   146.892     2.977     0.200
   152.054    20.762     0.200
   153.424    19.953     0.200
   147.030     3.132     0.200
   147.595     6.464     0.200
   159.331    37.811     0.200
   146.941     2.355     0.200
   159.237    37.421     0.200
   146.963     3.390     0.200
   147.329     3.779     0.200
   147.502     3.694     0.200
   147.022     2.567     0.200
   147.374     3.327     0.200
   147.004     3.007     0.200
   146.949     2.422     0.200
   151.914    17.404     0.200
   146.574     2.140     0.200
   158.636    37.123     0.200
   146.661     2.012     0.200
   146.969     2.655     0.200
   146.956     2.635     0.200
   146.937     3.277     0.200
   146.969     2.776     0.200
   159.106    37.959     0.200
   146.676     2.028     0.200
   146.672     2.166     0.200
   146.954     3.096     0.200
   149.625     7.606     0.200
   150.365    11.645     0.200
   146.847     2.283     0.200
   146.847     3.283     0.200
   146.966     2.490     0.200
   150.375    11.052     0.200
   146.533     1.645     0.200
   146.568     2.176     0.200
   146.843     2.214     0.200
   146.612     2.674     0.200
   146.673     2.171     0.200
   146.633     1.888     0.200
   151.853    15.738     0.200
   155.211    25.244     0.200
   145.917     1.202     0.200
   147.695     9.589     0.200
   147.948     9.371     0.200
   148.093     8.034     0.200
   146.565     1.776     0.200
   146.505     2.154     0.200
   150.293    11.140     0.200
   146.050     1.908     0.200
   156.958    30.855     0.200
   150.147    10.830     0.200
   147.915     5.230     0.200
   150.251    11.068     0.200
   156.865    29.984     0.200
   146.013     1.890     0.200
   146.881     2.275     0.200
   147.726     8.509     0.200
   147.726     9.611     0.200
   147.978     8.194     0.200
   147.978     9.397     0.200
   148.124     5.251     0.200
   148.124     7.954     0.200
   148.124    10.556     0.200
   156.878    28.579     0.200
   148.221     5.698     0.200
   154.875    25.390     0.200
   147.576     4.535     0.200
   151.762    16.636     0.200
   156.885    30.835     0.200
   146.154     2.146     0.200
   146.881     2.739     0.200
   147.728     4.906     0.200
   147.728     7.312     0.200
   147.981     5.295     0.200
   147.981     7.193     0.200
   148.127     6.750     0.200
   148.127     8.555     0.200
   151.764    17.230     0.200
   156.877    30.662     0.200
   146.131     1.583     0.200
   146.929     2.847     0.200
   147.706     6.443     0.200
   147.706     7.740     0.200
   147.960     5.822     0.200
   147.960     7.322     0.200
   147.960     9.923     0.200
   148.104     6.990     0.200
   148.104     8.490     0.200
   148.104    10.990     0.200
   146.139     2.243     0.200
   147.715     5.401     0.200
   147.715     6.601     0.200
   147.970     6.180     0.200
   147.970     7.580     0.200
   151.788    16.326     0.200
   147.986     6.013     0.200
   147.697     5.421     0.200
   147.952     5.594     0.200
   146.266     2.155     0.200
   147.841     9.823     0.200
   147.841    10.323     0.200
   148.093     9.107     0.200
   147.733     7.950     0.200
   147.985     5.634     0.200
   147.650     4.981     0.200
   147.650     7.380     0.200
   147.650    10.184     0.200
   147.901     6.770     0.200
   147.901     8.465     0.200
   148.048     7.824     0.200
   148.048    10.324     0.200
   146.229     1.895     0.200
   146.339     2.305     0.200
   147.908     5.286     0.200
   147.908     9.485     0.200
   154.436    24.788     0.200
   156.515    29.420     0.200
   146.921     2.845     0.200
   154.874    23.070     0.200
   151.801    15.106     0.200
   146.751     2.696     0.200
   147.552     6.601     0.200
   157.061    30.845     0.200
   147.036     2.690     0.200
   155.936    27.169     0.200
   146.899     2.733     0.200
   151.759    15.855     0.200
   156.890    31.045     0.200
   146.178     1.859     0.200
   146.579     1.830     0.200
   145.845     1.206     0.200
   145.601     1.747     0.200
   146.006     1.088     0.200
   145.419     1.458     0.200
   151.647    13.627     0.200
   156.863    29.852     0.200
   145.465     1.096     0.200
   156.926    28.761     0.200
   149.227     8.659     0.200
   150.614     9.259     0.200
   156.900    30.346     0.200
   146.586     2.295     0.200
   146.764     2.311     0.200
   145.910     2.232     0.200
   146.358     2.099     0.200
   156.123    28.849     0.200
   156.123    26.764     0.200
   146.556     2.321     0.200
   145.678     1.242     0.200
   145.387     1.680     0.200
   146.406     1.726     0.200
   146.468     1.930     0.200
   146.901     2.562     0.200
   151.763    16.329     0.200
   151.763    15.959     0.200
   152.729    18.663     0.200
   152.729    19.123     0.200
   154.860    23.415     0.200
   156.892    30.244     0.200
   146.546     1.862     0.200
   145.462     1.471     0.200
   145.678     2.024     0.200
   145.921     1.909     0.200
   146.563     2.321     0.200
   147.148     3.400     0.200
   147.282     3.656     0.200
   147.313     3.835     0.200
   168.000    67.404     0.200
   146.593     1.716     0.200
   156.909    28.074     0.200
   146.321     1.351     0.200
   154.389    24.037     0.200
   156.319    27.755     0.200
   146.110     1.018     0.200
   147.168     3.116     0.200
   146.097     0.821     0.200
   151.726    15.056     0.200
   155.736    26.011     0.200
   153.287    19.650     0.200
   155.717    27.404     0.200
   157.301    29.715     0.200
   157.301    29.996     0.200
   161.193    42.882     0.200
   163.514    51.132     0.200
   155.746    27.320     0.200
   151.600    15.052     0.200
   155.620    27.854     0.200
   155.734    26.386     0.200
   146.274     2.157     0.200
   155.751    26.539     0.200
   157.329    32.741     0.200
   155.664    26.971     0.200
   157.330    31.382     0.200
   147.495     3.369     0.200
   155.758    27.367     0.200
   146.616     2.106     0.200
   155.721    27.678     0.200
   145.418     0.332     0.200
   146.519     1.624     0.200
   154.847    23.600     0.200
   156.891    30.443     0.200
   155.526    25.817     0.200
   155.738    27.585     0.200
   157.259    28.934     0.200
   163.476    50.763     0.200
   155.805    26.828     0.200
   146.256     1.147     0.200
   146.284     1.670     0.200
   144.886    -1.194     0.200
   151.077    13.547     0.200
   154.082    21.425     0.200
   155.995    27.763     0.200
   146.142     1.222     0.200
   151.851    16.478     0.200
   155.196    26.090     0.200
   145.409     0.106     0.200
   145.409     1.575     0.200
   145.314     1.175     0.200
   145.555     1.261     0.200
   145.395     1.236     0.200
   148.194     5.310     0.200
   156.927    30.066     0.200
   145.416     0.905     0.200
   156.884    29.958     0.200
   145.942     1.533     0.200
   146.554     1.790     0.200
   154.869    24.277     0.200
   156.920    30.744     0.200
   146.001     1.925     0.200
   145.385     1.058     0.200
   145.385     0.478     0.200
   145.945     1.402     0.200
   154.854    24.894     0.200
   156.887    29.594     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   142.986     2.516     0.200
   142.404     7.757     0.200
   142.950     6.371     0.200
   146.568     3.815     0.200
   135.068     4.324     0.200
   146.629     4.288     0.200
   146.629     4.588     0.200
   142.533     2.722     0.200
   151.928     7.471     0.200
   143.420     3.915     0.200
   147.068     4.248     0.200
   152.190     7.483     0.200
   143.264     2.050     0.200
   152.158     7.425     0.200
   142.552     6.412     0.200
   142.985     2.045     0.200
   151.874     7.662     0.200
   152.081     7.552     0.200
   142.888     4.191     0.200
   151.922     7.183     0.200
   151.889     7.658     0.200
   151.895     8.199     0.200
   146.668     3.725     0.200
   150.316     7.288     0.200
   151.931     8.317     0.200
   152.466     8.854     0.200
   146.568     4.177     0.200
   151.818     7.572     0.200
   151.872     7.691     0.200
   151.881     8.898     0.200
   146.619     4.052     0.200
   151.848     8.186     0.200
   152.022     7.305     0.200
   143.005     2.880     0.200
   151.736     7.438     0.200
   152.522     8.267     0.200
   135.292     5.239     0.200
   141.048     3.172     0.200
   150.580     7.006     0.200
   152.874     8.550     0.200
   151.847     8.193     0.200
   142.533     2.901     0.200
   147.030     4.530     0.200
   150.621     6.328     0.200
   151.869     7.225     0.200
   152.837     8.491     0.200
   147.010     4.135     0.200
   151.824     8.735     0.200
   151.814     7.672     0.200
   143.367     2.373     0.200
   152.093     7.025     0.200
   135.096     4.472     0.200
   147.153     4.900     0.200
   152.330     8.303     0.200
   147.479     5.503     0.200
   135.355     3.087     0.200
   150.607     6.317     0.200
   152.068     7.194     0.200
   147.502     5.991     0.200
   150.636     6.446     0.200
   152.087     6.738     0.200
   152.256     7.385     0.200
   147.122     3.746     0.200
   150.573     6.518     0.200
   152.185     7.267     0.200
   147.012     7.005     0.200
   147.004     5.308     0.200
   151.956     8.426     0.200
   151.813     7.355     0.200
   152.488     8.650     0.200
   146.574     3.741     0.200
   149.897     6.204     0.200
   151.374     8.018     0.200
   151.388     7.895     0.200
   151.534     7.276     0.200
   151.777     7.909     0.200
   151.889     7.741     0.200
   151.912     8.706     0.200
   146.661     7.215     0.200
   151.533     7.793     0.200
   151.827     7.850     0.200
   151.855     7.108     0.200
   151.909     7.527     0.200
   152.207     7.981     0.200
   152.234     8.742     0.200
   152.484     8.871     0.200
   151.859     7.571     0.200
   142.561     1.832     0.200
   142.976     3.097     0.200
   146.598     3.338     0.200
   148.149     4.458     0.200
   151.700     7.460     0.200
   151.697     7.562     0.200
   151.895     7.867     0.200
   151.855     7.728     0.200
   151.908     7.846     0.200
   152.206     8.003     0.200
   152.233     8.862     0.200
   146.937     8.675     0.200
   146.681     3.860     0.200
   143.005     4.800     0.200
   151.850     7.888     0.200
   143.000     4.788     0.200
   146.631     3.813     0.200
   150.365     5.840     0.200
   151.575     7.786     0.200
   151.741     7.332     0.200
   151.837     6.891     0.200
   151.897     7.800     0.200
   152.061     7.852     0.200
   152.249     8.073     0.200
   143.077     4.955     0.200
   143.295     3.570     0.200
   145.138     2.360     0.200
   142.779     3.182     0.200
   142.997     5.501     0.200
   144.846     2.270     0.200
   146.671     7.054     0.200
   151.846     7.381     0.200
   151.962     7.126     0.200
   152.119     7.095     0.200
   152.283     7.554     0.200
   152.470     7.776     0.200
   152.497     8.533     0.200
   142.834     2.818     0.200
   143.051     2.434     0.200
   146.094     3.887     0.200
   143.024     3.273     0.200
   151.854     7.985     0.200
   152.436     7.821     0.200
   142.968     1.701     0.200
   146.588     7.443     0.200
   142.753     4.676     0.200
   142.971     3.291     0.200
   143.256     2.390     0.200
   151.758     7.261     0.200
   151.846     8.300     0.200
   151.792     7.241     0.200
   151.822     7.940     0.200
   151.853     7.539     0.200
   151.766     7.328     0.200
   151.787     8.236     0.200
   151.760     7.532     0.200
   151.800     7.132     0.200
   146.924     4.118     0.200
   151.775     7.523     0.200
   148.451     4.171     0.200
   150.293     5.226     0.200
   150.329     5.332     0.200
   150.147     5.093     0.200
   150.251     5.498     0.200
   147.978     4.093     0.200
   151.765     6.935     0.200
   154.829     8.949     0.200
   146.892     3.875     0.200
   147.732     4.415     0.200
   147.985     4.398     0.200
   151.761     7.588     0.200
   151.762     7.696     0.200
   146.154     3.450     0.200
   148.127     3.750     0.200
   151.763     7.731     0.200
   151.764     7.519     0.200
   146.131     4.583     0.200
   146.929     3.886     0.200
   151.790     7.237     0.200
   151.790     7.621     0.200
   146.139     6.643     0.200
   151.788     7.156     0.200
   146.156     4.470     0.200
   151.766     6.797     0.200
   151.803     7.760     0.200
   147.841     3.722     0.200
   146.158     2.689     0.200
   146.077     2.723     0.200
   146.077     5.723     0.200
   148.048     4.824     0.200
   148.151     4.886     0.200
   148.306     5.332     0.200
   149.292     5.016     0.200
   151.545     7.223     0.200
   152.495     7.229     0.200
   154.436     9.101     0.200
   151.781     6.431     0.200
   152.948     7.250     0.200
   151.746     7.112     0.200
   151.801     7.846     0.200
   147.053     3.729     0.200
   151.946     7.148     0.200
   152.041     6.372     0.200
   152.041     6.832     0.200
   151.759     7.136     0.200
   154.861     9.455     0.200
   146.947     3.965     0.200
   149.770     5.864     0.200
   151.797     7.048     0.200
   152.976     7.179     0.200
   149.813     5.867     0.200
   151.805     7.114     0.200
   151.805     7.466     0.200
   143.181     2.775     0.200
   143.181     2.920     0.200
   139.484     0.805     0.200
   148.162     4.392     0.200
   149.755     5.943     0.200
   150.342     6.400     0.200
   151.647     7.056     0.200
   151.662     6.724     0.200
   151.971     6.750     0.200
   154.948     9.716     0.200
   139.562     0.919     0.200
   142.636     3.722     0.200
   149.274     5.256     0.200
   149.778     5.213     0.200
   150.360     5.757     0.200
   151.656     6.159     0.200
   151.763     7.158     0.200
   146.411     4.593     0.200
   148.809     5.394     0.200
   149.617     6.778     0.200
   150.556     6.670     0.200
   150.758     6.740     0.200
   150.964     7.082     0.200
   151.199     9.901     0.200
   151.343     7.162     0.200
   151.599     7.043     0.200
   151.776     7.067     0.200
   152.111     7.643     0.200
   152.266     7.572     0.200
   152.391     8.000     0.200
   152.419    11.018     0.200
   152.615     7.448     0.200
   152.634     7.861     0.200
   152.716     7.119     0.200
   152.716     7.010     0.200
   152.844     7.872     0.200
   152.849     7.546     0.200
   153.007     8.245     0.200
   153.061    10.737     0.200
   153.494     8.029     0.200
   154.042    10.813     0.200
   146.382     3.248     0.200
   151.815     7.030     0.200
   147.988     4.862     0.200
   151.749     6.510     0.200
   154.827     9.056     0.200
   143.593     1.539     0.200
   150.575     6.449     0.200
   151.024     6.037     0.200
   151.820     7.457     0.200
   151.858     7.598     0.200
   151.432     6.473     0.200
   150.756     6.876     0.200
   151.548     6.635     0.200
   153.522     7.793     0.200
   143.050     2.491     0.200
   150.073     5.971     0.200
   151.866     7.045     0.200
   151.866     7.537     0.200
   153.387     7.815     0.200
   135.612     3.012     0.200
   136.073     2.773     0.200
   136.822     3.264     0.200
   138.666     2.588     0.200
   138.693     3.158     0.200
   138.995     2.404     0.200
   140.234     3.069     0.200
   141.072     2.387     0.200
   141.277     2.858     0.200
   142.033     2.125     0.200
   142.060     2.497     0.200
   142.239     2.388     0.200
   142.770     3.115     0.200
   143.313     2.576     0.200
   143.595     2.391     0.200
   144.229     2.642     0.200
   144.453     2.882     0.200
   144.602     2.825     0.200
   145.162     2.367     0.200
   145.199     2.093     0.200
   149.725     5.728     0.200
   150.714     5.449     0.200
   151.644     5.997     0.200
   151.763     7.139     0.200
   151.763     7.279     0.200
   152.002     6.831     0.200
   152.609     7.239     0.200
   153.016     7.235     0.200
   154.860     9.415     0.200
   135.646     3.480     0.200
   136.104     3.222     0.200
   136.854     2.417     0.200
   138.699     3.722     0.200
   140.261     1.908     0.200
   141.310     1.483     0.200
   142.269     3.073     0.200
   151.794     6.804     0.200
   146.153     2.863     0.200
   146.940     4.356     0.200
   149.168     5.528     0.200
   149.433     5.401     0.200
   149.765     5.327     0.200
   149.970     5.870     0.200
   150.011     5.156     0.200
   150.345     5.690     0.200
   151.637     6.770     0.200
   151.684     6.579     0.200
   151.788     6.191     0.200
   151.788     7.499     0.200
   151.884     7.098     0.200
   152.246     6.416     0.200
   152.619     7.782     0.200
   152.648     6.990     0.200
   146.915     4.265     0.200
   146.915     3.816     0.200
   151.785     7.042     0.200
   152.382     6.870     0.200
   152.615     7.308     0.200
   152.939     7.915     0.200
   154.861     9.318     0.200
   143.217     2.182     0.200
   151.647     6.981     0.200
   151.308     6.550     0.200
   154.389     8.862     0.200
   138.717     2.143     0.200
   138.748     3.267     0.200
   144.508     2.577     0.200
   144.930     2.929     0.200
   145.435     2.357     0.200
   151.812     7.444     0.200
   154.897     9.547     0.200
   136.025     1.247     0.200
   141.355     2.536     0.200
   141.702     2.478     0.200
   142.987     1.323     0.200
   143.245     2.736     0.200
   151.780     6.262     0.200
   150.522     5.687     0.200
   151.119     5.672     0.200
   151.876     6.609     0.200
   153.355     7.636     0.200
   153.407     8.148     0.200
   150.593     6.655     0.200
   143.221     1.910     0.200
   151.010     5.660     0.200
   151.436     5.946     0.200
   151.722     7.146     0.200
   152.761     6.720     0.200
   152.981     7.031     0.200
   153.258     7.520     0.200
   153.387     7.490     0.200
   151.818     6.127     0.200
   151.819     6.494     0.200
   151.660     6.302     0.200
   150.236     5.390     0.200
   151.600     6.560     0.200
   153.713     8.095     0.200
   138.775     1.660     0.200
   146.274     5.140     0.200
   151.733     6.913     0.200
   138.734     1.304     0.200
   151.743     6.734     0.200
   151.797     6.176     0.200
   151.750     6.143     0.200
   153.618     7.379     0.200
   150.526     6.152     0.200
   153.328     7.391     0.200
   151.802     7.133     0.200
   153.392     7.502     0.200
   151.725     6.496     0.200
   138.696     1.105     0.200
   150.701     6.242     0.200
   151.869     6.172     0.200
   153.458     7.845     0.200
   151.755     7.593     0.200
   149.717     5.020     0.200
   149.922     5.688     0.200
   150.297     5.372     0.200
   151.635     6.348     0.200
   151.769     6.809     0.200
   151.769     7.254     0.200
   151.826     6.599     0.200
   151.843     6.206     0.200
   151.912     6.251     0.200
   152.197     6.521     0.200
   152.500     6.721     0.200
   152.599     7.309     0.200
   150.231     5.223     0.200
   150.270     5.372     0.200
   151.651     6.740     0.200
   152.672     6.799     0.200
   151.749     6.330     0.200
   141.865     1.336     0.200
   151.077     6.047     0.200
   151.077     5.687     0.200
   149.543     6.602     0.200
   151.599     7.512     0.200
   151.740     7.486     0.200
   151.851     6.997     0.200
   142.804     2.249     0.200
   149.761     6.200     0.200
   151.786     7.456     0.200
   144.578     4.219     0.200
   151.817     7.424     0.200
   151.933     7.806     0.200
   149.756     7.189     0.200
   149.772     6.614     0.200
   150.795     6.319     0.200
   151.774     6.901     0.200
   154.912     9.407     0.200
   151.662     6.259     0.200
   151.662     6.458     0.200
   149.720     5.303     0.200
   150.702     6.264     0.200
   150.742     5.593     0.200
   151.162     6.135     0.200
   151.641     6.556     0.200
   151.752     7.177     0.200
   151.752     6.779     0.200
   151.832     6.557     0.200
   151.918     6.420     0.200
   151.994     6.455     0.200
   152.173     7.141     0.200
   152.204     6.454     0.200
   152.553     7.961     0.200
   152.497     7.623     0.200
   152.606     7.618     0.200
   152.926     7.658     0.200
   153.013     7.131     0.200
   153.076     7.814     0.200
   151.328     6.820     0.200
   152.184     7.119     0.200
   151.795     7.304     0.200
   150.023     5.010     0.200
   150.759     6.523     0.200
   150.766     6.140     0.200
   152.661     7.516     0.200
   149.410     5.323     0.200
   149.710     6.915     0.200
   149.719     6.202     0.200
   149.719     5.841     0.200
   150.740     6.106     0.200
   151.760     7.086     0.200
   151.915     7.143     0.200
   154.854     9.142     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
