#!/bin/bash
gmt begin sapporo1.54_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P sapporo1.54'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.581
    79.000     8.416
    80.000     7.335
    81.000     6.340
    82.000     5.431
    83.000     4.605
    84.000     3.863
    85.000     3.209
    86.000     2.640
    87.000     2.148
    88.000     1.765
    89.000     1.471
    90.000     1.216
    91.000     0.993
    92.000     0.794
    93.000     0.613
    94.000     0.450
    95.000     0.307
    96.000     0.190
    97.000     0.099
    98.000     0.037
    99.000     0.004
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.008     7.085     0.200
    18.009    -1.347     0.200
    20.419    -2.659     0.200
    20.767    -3.421     0.200
    21.847     0.007     0.200
    26.028    -0.999     0.200
    27.946    -2.214     0.200
    30.921     0.431     0.200
    31.287     1.206     0.200
    33.270    -1.158     0.200
    37.313     0.107     0.200
    43.046    -1.330     0.200
    43.415     1.699     0.200
    44.040    -0.318     0.200
    45.006    -1.021     0.200
    46.895     4.114     0.200
    52.253    -0.652     0.200
    54.721    -0.733     0.200
    55.461    -1.067     0.200
    57.266    -1.915     0.200
    60.747    -2.012     0.200
    60.781    -0.241     0.200
    61.552     2.540     0.200
    61.938     1.944     0.200
    62.177    -1.655     0.200
    62.040     1.265     0.200
    63.937    -2.320     0.200
    64.628     3.157     0.200
    66.041    -0.982     0.200
    66.166    -0.779     0.200
    66.992     3.952     0.200
    67.127     3.098     0.200
    68.730     0.033     0.200
    68.911    -2.092     0.200
    69.262    -3.271     0.200
    71.613     2.394     0.200
    72.430     0.509     0.200
    72.601    -1.509     0.200
    73.918    -1.268     0.200
    74.004     0.232     0.200
    74.566     1.964     0.200
    77.280    -1.492     0.200
    77.772    -0.238     0.200
    78.086    -0.978     0.200
    79.534     4.082     0.200
    80.759    -0.517     0.200
    81.056     0.899     0.200
    81.424    -0.049     0.200
    85.027     3.396     0.200
    89.637     3.168     0.200
    17.807    -3.457     0.200
    20.999    -3.217     0.200
    20.849     4.395     0.200
    20.862     4.053     0.200
    21.333    -1.801     0.200
    22.426    -2.428     0.200
    24.273    -3.189     0.200
    24.273    -2.789     0.200
    25.397    -0.404     0.200
    25.273     4.719     0.200
    25.333     5.176     0.200
    25.773     5.189     0.200
    26.015    -0.993     0.200
    26.827    -1.310     0.200
    27.675     4.098     0.200
    28.040     3.844     0.200
    28.383    -2.211     0.200
    28.496    -0.217     0.200
    28.651     2.409     0.200
    31.504     0.206     0.200
    31.844     1.221     0.200
    31.854     2.134     0.200
    33.950     2.843     0.200
    33.861    -0.385     0.200
    37.901     1.072     0.200
    43.637     0.876     0.200
    43.999     1.970     0.200
    45.596    -0.722     0.200
    47.538     0.094     0.200
    48.458    -2.011     0.200
    48.381    -1.418     0.200
    50.939    -0.854     0.200
    51.187     2.289     0.200
    52.597    -1.194     0.200
    52.450     4.896     0.200
    53.219     0.229     0.200
    53.508     2.108     0.200
    54.233    -0.183     0.200
    54.718    -0.700     0.200
    54.767    -2.049     0.200
    55.771     2.730     0.200
    55.996    -0.879     0.200
    55.687     4.332     0.200
    56.650     2.471     0.200
    57.030    -1.221     0.200
    57.961     0.236     0.200
    58.733    -2.141     0.200
    58.893     2.746     0.200
    59.245    -1.686     0.200
    58.982     0.129     0.200
    59.803    -2.522     0.200
    60.253     0.397     0.200
    60.439     1.125     0.200
    60.904    -1.034     0.200
    61.395    -1.351     0.200
    61.443     0.320     0.200
    61.997     2.601     0.200
    62.091     1.966     0.200
    62.745    -1.393     0.200
    62.904     2.549     0.200
    63.169    -1.208     0.200
    63.098     1.261     0.200
    63.711     2.216     0.200
    64.226    -1.161     0.200
    63.815     5.536     0.200
    64.167     0.224     0.200
    64.686    -2.161     0.200
    65.293    -2.102     0.200
    65.290     1.922     0.200
    66.247    -2.237     0.200
    66.375    -2.055     0.200
    67.081    -1.547     0.200
    66.871     2.787     0.200
    67.149     1.024     0.200
    67.742    -1.719     0.200
    67.561     1.422     0.200
    67.549     3.498     0.200
    68.223     1.267     0.200
    68.040     2.413     0.200
    68.721     0.162     0.200
    69.094    -2.154     0.200
    69.145    -0.467     0.200
    68.935     1.830     0.200
    69.930     1.698     0.200
    69.802     2.478     0.200
    70.291     2.489     0.200
    72.229    -1.206     0.200
    72.603    -2.432     0.200
    72.680     1.110     0.200
    72.954    -0.511     0.200
    73.315     1.358     0.200
    73.344     1.189     0.200
    73.131     1.446     0.200
    73.707     3.061     0.200
    74.105    -1.267     0.200
    74.281    -0.290     0.200
    74.037     2.134     0.200
    74.616     1.769     0.200
    75.106     0.940     0.200
    75.377     2.384     0.200
    75.823    -0.164     0.200
    76.507    -0.045     0.200
    76.030     2.659     0.200
    76.894    -0.226     0.200
    77.350     2.223     0.200
    77.496    -0.591     0.200
    77.712    -0.796     0.200
    77.368     2.122     0.200
    77.978     0.729     0.200
    78.296    -1.033     0.200
    78.361    -0.391     0.200
    78.367    -0.422     0.200
    78.461     2.060     0.200
    78.177    -0.378     0.200
    78.696     0.763     0.200
    78.733     2.561     0.200
    78.786    -0.729     0.200
    78.977     3.225     0.200
    78.981     2.201     0.200
    79.787    -1.179     0.200
    79.760     1.965     0.200
    80.600    -0.553     0.200
    80.794     3.410     0.200
    80.825    -0.757     0.200
    80.968    -0.517     0.200
    81.039    -0.894     0.200
    81.216    -0.832     0.200
    81.223    -0.869     0.200
    81.489    -0.274     0.200
    81.554    -0.618     0.200
    81.594    -0.829     0.200
    81.626    -1.000     0.200
    81.648    -1.117     0.200
    81.797    -1.898     0.200
    82.052     0.766     0.200
    82.471    -0.424     0.200
    82.319    -0.634     0.200
    82.584    -2.014     0.200
    82.789     3.924     0.200
    83.152     0.050     0.200
    83.269    -1.552     0.200
    83.385    -2.151     0.200
    84.017     4.620     0.200
    84.141     0.991     0.200
    84.540     4.971     0.200
    84.367     0.845     0.200
    84.445     0.451     0.200
    84.880     2.262     0.200
    84.855     3.389     0.200
    85.447     1.431     0.200
    85.384    -0.255     0.200
    85.404     0.645     0.200
    85.658    -0.617     0.200
    85.599    -0.324     0.200
    85.725    -0.948     0.200
    85.648     0.432     0.200
    85.909    -0.859     0.200
    86.393    -0.243     0.200
    86.030     2.544     0.200
    86.169     0.861     0.200
    86.763     0.950     0.200
    86.872     0.417     0.200
    87.155     1.046     0.200
    86.986     4.864     0.200
    86.972     2.930     0.200
    87.723     2.319     0.200
    89.016    -1.784     0.200
    89.063     0.998     0.200
    89.384     1.493     0.200
    90.022    -0.488     0.200
    90.438     3.575     0.200
    90.258     3.413     0.200
    90.917     3.348     0.200
    91.033     3.811     0.200
    93.220     0.702     0.200
    93.463    -0.415     0.200
    93.609     2.910     0.200
    94.155    -0.599     0.200
    95.484    -0.677     0.200
    95.545     2.043     0.200
    95.453     2.462     0.200
    95.750     1.111     0.200
    96.228     0.938     0.200
    18.013    -1.500     0.200
    24.179    -5.360     0.200
    28.000    -1.846     0.200
    32.207     2.976     0.200
    38.918    -1.551     0.200
    43.101    -0.931     0.200
    44.037     0.040     0.200
    44.080     2.199     0.200
    47.354    -0.626     0.200
    51.195    -1.935     0.200
    53.495    -0.979     0.200
    53.884    -0.823     0.200
    54.777    -0.315     0.200
    55.813    -0.763     0.200
    56.005    -2.136     0.200
    57.268    -1.596     0.200
    58.597    -1.408     0.200
    58.541     0.986     0.200
    58.736    -0.372     0.200
    59.145    -1.606     0.200
    60.784    -1.539     0.200
    60.838    -0.803     0.200
    61.312    -0.917     0.200
    62.212    -1.668     0.200
    62.639    -0.916     0.200
    63.792     1.454     0.200
    63.983    -1.801     0.200
    64.441    -1.801     0.200
    64.496    -2.161     0.200
    64.475     0.976     0.200
    66.082    -1.722     0.200
    67.100     1.286     0.200
    67.456     1.835     0.200
    67.640    -1.929     0.200
    68.547    -1.014     0.200
    68.783     0.520     0.200
    68.949    -1.514     0.200
    69.223    -0.208     0.200
    69.535     0.866     0.200
    71.272    -0.734     0.200
    71.469    -1.923     0.200
    71.491     0.345     0.200
    71.579     2.312     0.200
    72.223     0.560     0.200
    72.468    -1.799     0.200
    72.504    -2.115     0.200
    72.971     1.713     0.200
    73.957    -0.681     0.200
    74.530     2.183     0.200
    74.737     1.785     0.200
    75.610    -1.234     0.200
    75.695    -0.717     0.200
    77.321    -1.108     0.200
    77.496     2.114     0.200
    77.814     0.141     0.200
    77.845     2.170     0.200
    78.368    -0.727     0.200
    78.734    -0.741     0.200
    78.760    -1.282     0.200
    78.878    -0.528     0.200
    79.477     1.501     0.200
    80.799     0.077     0.200
    81.007    -1.027     0.200
    81.110     0.422     0.200
    81.590    -1.514     0.200
    83.962    -0.813     0.200
    84.011    -1.065     0.200
    84.408    -0.781     0.200
    84.822     1.231     0.200
    84.989     3.393     0.200
    85.401     0.737     0.200
    86.084     1.055     0.200
    89.414     0.317     0.200
    89.622     1.743     0.200
    90.645     1.276     0.200
    21.474    -4.646     0.200
    27.973    -2.090     0.200
    30.391    -4.527     0.200
    31.283     0.609     0.200
    37.338     2.761     0.200
    38.893    -1.818     0.200
    43.073    -1.177     0.200
    44.020     0.205     0.200
    44.091     0.533     0.200
    47.318    -0.816     0.200
    47.934    -0.590     0.200
    53.460    -2.185     0.200
    53.846    -1.011     0.200
    54.159    -0.288     0.200
    54.935    -1.913     0.200
    55.863    -1.583     0.200
    56.031    -1.783     0.200
    58.602    -1.896     0.200
    58.789    -0.200     0.200
    59.153    -1.623     0.200
    60.790    -1.635     0.200
    60.794    -0.467     0.200
    61.967     1.115     0.200
    61.994     1.938     0.200
    63.611     0.191     0.200
    63.974    -1.198     0.200
    64.440    -3.250     0.200
    64.494    -1.601     0.200
    65.171    -2.301     0.200
    66.082    -0.879     0.200
    67.158     1.565     0.200
    67.515     2.008     0.200
    67.648    -2.231     0.200
    67.703     1.624     0.200
    68.244     1.130     0.200
    68.952    -2.084     0.200
    69.246     2.898     0.200
    69.881     0.685     0.200
    70.171     1.207     0.200
    71.235    -0.959     0.200
    71.592    -1.213     0.200
    71.640     1.603     0.200
    72.472    -2.275     0.200
    72.505    -2.672     0.200
    73.031     2.010     0.200
    73.960    -0.444     0.200
    74.591     2.387     0.200
    74.797     0.994     0.200
    75.263     0.312     0.200
    75.688    -0.122     0.200
    77.321    -1.353     0.200
    77.812     0.206     0.200
    78.022    -0.057     0.200
    77.905     2.390     0.200
    78.368    -0.672     0.200
    78.745    -0.445     0.200
    78.771    -0.088     0.200
    79.243     0.030     0.200
    79.377     0.299     0.200
    79.641    -1.137     0.200
    80.074    -0.477     0.200
    81.030     0.408     0.200
    83.934    -0.414     0.200
    84.168    -0.607     0.200
    84.231    -0.827     0.200
    84.344    -0.797     0.200
    84.475    -1.460     0.200
    84.881     1.494     0.200
    85.478    -1.086     0.200
    85.478    -0.486     0.200
    85.862     0.611     0.200
    86.068    -0.406     0.200
    86.142     0.327     0.200
    86.180    -0.960     0.200
    88.875    -0.895     0.200
    90.286     1.005     0.200
    90.701     0.577     0.200
    41.141    -0.814     0.200
    44.034     0.330     0.200
    45.069    -0.515     0.200
    51.195    -0.752     0.200
    52.312    -1.071     0.200
    54.218    -0.559     0.200
    55.812     0.447     0.200
    56.010    -1.966     0.200
    57.269    -1.898     0.200
    58.369     1.392     0.200
    58.606    -4.255     0.200
    58.734    -0.147     0.200
    59.153    -1.049     0.200
    60.792    -1.674     0.200
    60.849    -1.163     0.200
    62.220    -1.397     0.200
    62.604    -1.261     0.200
    62.650    -0.567     0.200
    63.547     0.289     0.200
    63.992    -0.640     0.200
    65.174    -1.941     0.200
    66.090    -1.247     0.200
    67.450     1.102     0.200
    68.958    -1.533     0.200
    71.283    -0.857     0.200
    71.471    -2.689     0.200
    71.574     2.294     0.200
    72.966     1.789     0.200
    73.385     1.714     0.200
    73.965    -0.482     0.200
    74.524     2.872     0.200
    74.732     2.065     0.200
    76.821     0.650     0.200
    77.330    -0.602     0.200
    77.823    -0.657     0.200
    77.839     2.164     0.200
    78.742    -1.523     0.200
    78.887    -0.319     0.200
    83.939    -0.736     0.200
    84.237    -0.444     0.200
    84.818     0.526     0.200
    87.315     0.720     0.200
    90.642     0.570     0.200
    24.145    -4.229     0.200
    30.347    -4.833     0.200
    43.064    -1.294     0.200
    44.040     0.057     0.200
    45.028    -0.020     0.200
    47.317    -0.495     0.200
    51.187    -1.028     0.200
    52.267    -1.073     0.200
    53.458    -0.855     0.200
    54.173    -0.072     0.200
    57.259    -1.675     0.200
    58.295    -0.941     0.200
    58.382     1.952     0.200
    58.567    -2.339     0.200
    58.738    -0.523     0.200
    59.117    -1.852     0.200
    60.754    -1.578     0.200
    61.285    -1.366     0.200
    62.183    -1.808     0.200
    62.441     0.265     0.200
    62.521     0.737     0.200
    62.565    -1.264     0.200
    62.607    -0.341     0.200
    62.561     1.469     0.200
    63.206    -0.813     0.200
    63.563     0.829     0.200
    63.804     1.237     0.200
    64.482     0.798     0.200
    65.136    -1.853     0.200
    65.243     1.056     0.200
    65.517     0.782     0.200
    66.050    -1.649     0.200
    67.110     1.098     0.200
    67.354     0.451     0.200
    67.468     1.330     0.200
    67.611    -2.074     0.200
    67.659     1.223     0.200
    68.200     1.528     0.200
    68.643    -0.741     0.200
    68.919    -1.556     0.200
    69.355     0.547     0.200
    69.837     1.672     0.200
    69.885     1.083     0.200
    70.041    -1.171     0.200
    70.073     1.136     0.200
    70.123     1.625     0.200
    71.460    -1.990     0.200
    71.557    -0.575     0.200
    71.594     1.597     0.200
    72.108    -0.878     0.200
    72.205     0.838     0.200
    72.240     1.330     0.200
    72.438    -1.449     0.200
    72.473    -2.352     0.200
    73.926    -1.024     0.200
    74.319    -1.912     0.200
    74.750     1.489     0.200
    75.246     0.734     0.200
    75.577    -1.168     0.200
    75.661     0.353     0.200
    75.903    -0.028     0.200
    76.822    -1.230     0.200
    77.290    -1.454     0.200
    77.507     1.830     0.200
    77.782    -0.101     0.200
    77.861     2.065     0.200
    78.337    -0.673     0.200
    78.457    -1.540     0.200
    78.707    -0.209     0.200
    78.732    -0.953     0.200
    78.845    -0.073     0.200
    79.232     0.416     0.200
    79.493     0.594     0.200
    79.608    -1.029     0.200
    80.511     0.501     0.200
    80.765    -0.656     0.200
    81.074     0.500     0.200
    81.557    -1.560     0.200
    81.788     1.023     0.200
    82.003    -0.108     0.200
    83.932    -0.676     0.200
    83.982    -0.335     0.200
    84.135    -0.706     0.200
    84.379    -0.247     0.200
    84.466    -0.793     0.200
    84.550    -0.309     0.200
    84.731    -0.026     0.200
    84.833     0.664     0.200
    85.274    -0.940     0.200
    86.128    -1.376     0.200
    86.997    -0.233     0.200
    87.333     1.641     0.200
    87.470     2.085     0.200
    88.254     0.462     0.200
    88.301     0.340     0.200
    89.193     0.239     0.200
    90.234     0.576     0.200
    90.650     0.242     0.200
    24.105    -2.879     0.200
    43.007    -1.638     0.200
    44.093     0.328     0.200
    44.952     0.084     0.200
    47.253     0.002     0.200
    51.215    -0.737     0.200
    52.223    -0.747     0.200
    53.667     0.615     0.200
    53.782    -1.221     0.200
    54.099    -0.537     0.200
    54.902    -2.360     0.200
    55.991    -1.880     0.200
    59.100    -1.028     0.200
    60.732    -0.718     0.200
    60.734    -1.337     0.200
    61.270    -1.668     0.200
    62.166    -1.594     0.200
    62.347     0.897     0.200
    62.532    -0.333     0.200
    62.540    -1.388     0.200
    62.541    -1.199     0.200
    63.625     0.418     0.200
    65.115    -2.014     0.200
    65.166     0.754     0.200
    65.580     0.679     0.200
    66.024    -1.580     0.200
    67.171    -0.090     0.200
    67.413    -0.019     0.200
    67.533     1.622     0.200
    68.206     0.993     0.200
    68.456    -0.565     0.200
    68.695    -0.060     0.200
    68.895    -1.903     0.200
    69.445     0.294     0.200
    70.022    -1.254     0.200
    71.170    -1.237     0.200
    71.489    -1.162     0.200
    71.538    -0.453     0.200
    72.264     0.791     0.200
    73.051     1.623     0.200
    73.840     1.885     0.200
    74.615     2.376     0.200
    74.815     1.323     0.200
    75.197     0.018     0.200
    75.545     0.028     0.200
    75.870     0.172     0.200
    77.753    -0.128     0.200
    77.929     2.091     0.200
    78.719    -0.667     0.200
    78.816    -0.300     0.200
    79.562     1.825     0.200
    80.317     2.049     0.200
    80.965     1.089     0.200
    81.018     0.806     0.200
    81.739     0.690     0.200
    83.876    -0.386     0.200
    83.913    -0.869     0.200
    83.962    -0.820     0.200
    84.111    -0.781     0.200
    84.174    -0.700     0.200
    84.359    -0.736     0.200
    84.424    -0.966     0.200
    84.523    -0.063     0.200
    84.685    -0.080     0.200
    84.896     0.756     0.200
    85.247    -0.301     0.200
    90.705    -0.605     0.200
    43.857     0.378     0.200
    51.048    -0.405     0.200
    60.029     1.178     0.200
    60.761    -1.811     0.200
    61.275    -1.296     0.200
    62.524    -2.473     0.200
    62.484     1.091     0.200
    66.076    -1.895     0.200
    67.261     2.161     0.200
    70.044    -1.262     0.200
    71.608     1.751     0.200
    18.224    -1.596     0.200
    23.940    -4.597     0.200
    41.022     1.706     0.200
    41.445    -0.968     0.200
    42.739    -1.701     0.200
    42.890    -0.922     0.200
    43.573     0.468     0.200
    44.108     0.775     0.200
    44.406    -0.105     0.200
    44.517    -0.091     0.200
    44.527    -0.571     0.200
    44.552    -0.267     0.200
    44.931    -0.286     0.200
    45.393    -0.051     0.200
    46.941    -0.109     0.200
    48.858    -0.926     0.200
    51.443    -1.477     0.200
    53.088    -0.673     0.200
    53.726    -0.351     0.200
    55.037    -0.868     0.200
    55.409    -1.547     0.200
    55.853    -0.732     0.200
    56.074    -2.013     0.200
    56.552    -1.211     0.200
    58.228    -1.513     0.200
    59.331    -0.070     0.200
    60.382    -1.279     0.200
    61.242    -1.216     0.200
    61.951     0.210     0.200
    62.241    -0.934     0.200
    62.179    -0.021     0.200
    62.419    -2.121     0.200
    62.419    -0.121     0.200
    62.462    -1.408     0.200
    63.759    -0.001     0.200
    63.983     0.523     0.200
    64.412    -1.284     0.200
    64.875    -0.302     0.200
    65.051    -1.845     0.200
    65.932    -0.927     0.200
    65.937    -0.164     0.200
    67.524     0.438     0.200
    67.754     0.287     0.200
    67.900     0.767     0.200
    68.819    -0.770     0.200
    68.868     0.323     0.200
    69.005    -0.528     0.200
    69.747     0.891     0.200
    69.775     1.422     0.200
    69.924    -0.896     0.200
    69.971    -1.381     0.200
    69.915     1.960     0.200
    70.294     1.443     0.200
    70.851    -0.850     0.200
    71.484    -0.074     0.200
    71.689    -1.909     0.200
    71.755     0.697     0.200
    72.040     2.188     0.200
    72.346    -0.339     0.200
    72.359    -0.518     0.200
    73.423     1.287     0.200
    74.982    -0.285     0.200
    75.181     1.266     0.200
    75.736     0.391     0.200
    77.111    -2.391     0.200
    77.931     1.533     0.200
    78.922     1.573     0.200
    80.272     1.245     0.200
    80.690     2.104     0.200
    84.609     1.653     0.200
    85.255     1.113     0.200
    41.273    -0.888     0.200
    43.936     1.093     0.200
    44.232     0.017     0.200
    44.354     0.247     0.200
    51.269    -0.224     0.200
    51.275    -1.870     0.200
    54.885    -1.455     0.200
    57.333    -1.942     0.200
    62.327    -2.166     0.200
    62.374    -1.578     0.200
    64.240    -1.936     0.200
    64.957    -1.917     0.200
    65.848    -1.382     0.200
    67.354     1.608     0.200
    67.734     0.409     0.200
    69.873    -1.302     0.200
    71.583     0.988     0.200
    75.014     1.061     0.200
    85.087     0.715     0.200
    18.019     0.287     0.200
    21.235    -3.101     0.200
    41.244    -1.343     0.200
    43.923    -0.705     0.200
    44.214    -0.038     0.200
    44.335     0.094     0.200
    51.232    -0.960     0.200
    51.238    -1.507     0.200
    54.835    -2.017     0.200
    55.927    -0.877     0.200
    56.537    -1.832     0.200
    57.293    -1.592     0.200
    58.609     1.184     0.200
    58.890    -1.773     0.200
    58.891    -0.778     0.200
    60.515    -1.759     0.200
    61.071    -1.141     0.200
    62.190    -1.283     0.200
    62.261    -2.258     0.200
    62.146     0.013     0.200
    62.307    -1.068     0.200
    63.809     0.258     0.200
    64.070     1.141     0.200
    64.210    -1.677     0.200
    64.691     0.181     0.200
    64.891    -2.226     0.200
    65.781    -1.692     0.200
    65.763     0.426     0.200
    67.347     0.411     0.200
    67.572    -0.313     0.200
    67.732     1.075     0.200
    68.125     0.203     0.200
    68.812    -1.091     0.200
    68.908    -0.687     0.200
    69.120     0.996     0.200
    69.807    -1.247     0.200
    69.956     1.840     0.200
    71.484    -2.463     0.200
    71.573     0.698     0.200
    73.258     1.454     0.200
    74.076     1.151     0.200
    75.012     0.717     0.200
    75.278     0.184     0.200
    75.601     0.333     0.200
    76.908    -1.089     0.200
    77.014    -0.488     0.200
    77.498     0.600     0.200
    78.561     0.699     0.200
    79.793     0.967     0.200
    80.067    -1.519     0.200
    80.526     1.513     0.200
    83.515    -0.681     0.200
    83.642    -0.332     0.200
    83.940    -0.659     0.200
    84.126     0.696     0.200
    85.082     0.172     0.200
    91.142     1.170     0.200
    18.008    -3.809     0.200
    24.635     1.168     0.200
    27.946    -1.681     0.200
    30.345    -3.956     0.200
    31.305     1.576     0.200
    32.182    -1.621     0.200
    33.417     1.090     0.200
    33.437     1.914     0.200
    37.355     1.278     0.200
    38.296     3.345     0.200
    40.911     1.605     0.200
    42.488    -0.384     0.200
    44.054     0.095     0.200
    44.166     0.197     0.200
    44.176     0.120     0.200
    44.558     0.072     0.200
    45.006     0.407     0.200
    45.032     0.499     0.200
    47.888    -3.074     0.200
    49.198    -1.141     0.200
    49.212    -0.241     0.200
    51.195    -2.240     0.200
    51.227     4.020     0.200
    52.252    -1.119     0.200
    53.439     0.135     0.200
    54.888    -2.415     0.200
    55.095    -0.910     0.200
    55.816    -1.283     0.200
    55.822    -1.127     0.200
    55.984    -2.288     0.200
    56.937    -1.058     0.200
    57.266    -1.380     0.200
    58.580     0.416     0.200
    58.750    -0.768     0.200
    59.110    -1.657     0.200
    59.784     0.097     0.200
    60.746    -1.679     0.200
    61.278    -2.082     0.200
    62.176    -1.721     0.200
    62.366     0.111     0.200
    62.502    -2.598     0.200
    62.501     0.711     0.200
    62.556    -1.359     0.200
    62.585    -0.051     0.200
    63.038     1.140     0.200
    63.187     0.154     0.200
    63.579     0.559     0.200
    63.822     0.962     0.200
    63.936    -0.787     0.200
    64.120    -1.195     0.200
    64.453    -1.173     0.200
    64.497    -0.461     0.200
    65.128    -1.660     0.200
    65.220     1.138     0.200
    65.402     0.662     0.200
    65.534     0.712     0.200
    66.041    -1.449     0.200
    67.126     1.031     0.200
    67.176    -1.084     0.200
    67.369     0.091     0.200
    67.486     1.155     0.200
    68.493    -0.965     0.200
    68.657     0.015     0.200
    68.729     0.564     0.200
    68.795    -0.843     0.200
    68.910    -1.659     0.200
    69.168    -0.159     0.200
    69.481     0.907     0.200
    70.055     0.383     0.200
    71.215    -0.478     0.200
    71.466     1.008     0.200
    71.466    -2.191     0.200
    71.613     2.127     0.200
    71.838    -0.426     0.200
    72.221     1.085     0.200
    72.601     0.023     0.200
    73.844    -1.303     0.200
    73.917     0.265     0.200
    74.767     1.527     0.200
    75.230     0.662     0.200
    75.566    -0.064     0.200
    75.892     0.676     0.200
    76.832    -0.447     0.200
    77.524     1.673     0.200
    77.747    -0.569     0.200
    77.772    -0.505     0.200
    77.880     2.195     0.200
    78.327    -0.781     0.200
    78.450     0.539     0.200
    78.835    -0.076     0.200
    79.214     1.348     0.200
    79.257     0.116     0.200
    79.512     1.726     0.200
    79.599    -1.745     0.200
    80.030    -1.076     0.200
    80.269     1.636     0.200
    80.501    -0.607     0.200
    80.751     0.057     0.200
    80.962    -1.073     0.200
    80.997     0.646     0.200
    81.056     1.130     0.200
    81.348    -0.119     0.200
    81.546    -1.164     0.200
    81.987    -0.486     0.200
    82.675     0.924     0.200
    83.177     0.624     0.200
    83.879     1.228     0.200
    83.891    -0.736     0.200
    83.924    -0.504     0.200
    83.974    -1.456     0.200
    84.189    -0.551     0.200
    84.355     1.309     0.200
    84.371    -0.771     0.200
    84.540    -0.327     0.200
    84.850     1.312     0.200
    85.178     0.169     0.200
    86.086     1.068     0.200
    86.716    -0.424     0.200
    89.636     2.601     0.200
    90.665     0.807     0.200
    90.721     0.344     0.200
    19.478    -2.978     0.200
    21.284    -3.561     0.200
    24.019    -4.642     0.200
    23.898    -1.530     0.200
    24.738     0.811     0.200
    26.023     3.150     0.200
    26.825     2.907     0.200
    27.867    -0.433     0.200
    28.391    -2.097     0.200
    28.597     0.267     0.200
    28.754     1.675     0.200
    29.860     0.867     0.200
    30.193    -5.077     0.200
    31.394     3.327     0.200
    32.302    -0.651     0.200
    33.541     1.522     0.200
    33.562    -0.655     0.200
    37.428     1.645     0.200
    37.954    -1.301     0.200
    38.438     1.625     0.200
    38.780    -1.246     0.200
    38.780    -2.246     0.200
    41.003    -1.103     0.200
    42.371     0.301     0.200
    42.970    -1.754     0.200
    42.970    -0.754     0.200
    43.605    -0.882     0.200
    43.920    -0.010     0.200
    44.041    -0.282     0.200
    44.093     0.205     0.200
    44.359     1.073     0.200
    45.031    -1.279     0.200
    46.270     2.929     0.200
    46.981     1.364     0.200
    47.243    -0.678     0.200
    47.045     2.863     0.200
    47.049     2.834     0.200
    47.076     3.020     0.200
    47.078     2.705     0.200
    47.092     2.896     0.200
    47.131     3.092     0.200
    47.163     0.944     0.200
    48.244     3.065     0.200
    48.799     0.289     0.200
    49.156    -1.441     0.200
    49.057    -0.684     0.200
    51.037    -1.596     0.200
    51.043    -1.744     0.200
    51.316     3.206     0.200
    51.572     0.296     0.200
    51.582     3.222     0.200
    51.529     2.314     0.200
    51.639     1.791     0.200
    52.147    -0.994     0.200
    53.027     3.499     0.200
    53.382    -0.109     0.200
    53.097     3.986     0.200
    53.097     4.486     0.200
    53.670    -0.226     0.200
    53.670    -1.226     0.200
    53.778    -0.013     0.200
    53.777     2.495     0.200
    54.140    -1.159     0.200
    54.281     0.713     0.200
    54.378    -0.391     0.200
    54.679    -0.577     0.200
    54.698     0.091     0.200
    54.732    -1.460     0.200
    55.046    -1.226     0.200
    55.320     2.492     0.200
    55.830    -2.063     0.200
    56.264     3.730     0.200
    56.898    -1.174     0.200
    56.864     0.567     0.200
    58.423    -1.191     0.200
    58.277     1.727     0.200
    58.457     1.169     0.200
    58.612    -0.513     0.200
    58.636     2.720     0.200
    58.703     1.859     0.200
    58.969    -0.989     0.200
    59.805    -0.762     0.200
    60.608    -2.457     0.200
    60.750    -0.826     0.200
    60.635     0.562     0.200
    61.135    -2.037     0.200
    61.826     0.495     0.200
    61.671     3.539     0.200
    62.366    -2.822     0.200
    62.366    -0.123     0.200
    62.361     0.912     0.200
    62.445     1.349     0.200
    62.195     1.021     0.200
    62.456    -0.723     0.200
    62.595     0.349     0.200
    62.328     0.832     0.200
    62.521     0.839     0.200
    62.922     3.270     0.200
    63.120    -0.146     0.200
    63.066     0.217     0.200
    62.941     1.747     0.200
    63.136    -1.248     0.200
    63.653     0.232     0.200
    63.819    -0.763     0.200
    63.713     0.838     0.200
    63.974    -1.778     0.200
    64.326    -0.088     0.200
    64.371     0.616     0.200
    64.679    -1.393     0.200
    64.990    -2.523     0.200
    65.286     0.561     0.200
    65.418     0.204     0.200
    65.909    -1.964     0.200
    65.569     2.832     0.200
    65.851     3.211     0.200
    66.427     0.318     0.200
    66.634     2.798     0.200
    67.022     0.527     0.200
    67.008     0.218     0.200
    67.246    -0.894     0.200
    67.314     1.574     0.200
    67.376     0.482     0.200
    67.580     1.097     0.200
    68.024    -1.305     0.200
    68.183     0.199     0.200
    68.412     0.768     0.200
    68.644    -0.682     0.200
    68.522    -0.919     0.200
    68.652    -0.730     0.200
    68.775    -2.101     0.200
    68.775    -0.999     0.200
    68.437     3.613     0.200
    68.864     0.846     0.200
    68.669     1.160     0.200
    68.684     1.872     0.200
    69.395     0.660     0.200
    69.256     0.717     0.200
    69.383     1.432     0.200
    69.802    -1.855     0.200
    69.978     1.366     0.200
    69.762     1.396     0.200
    69.623     3.252     0.200
    69.812     2.485     0.200
    69.861     1.886     0.200
    69.964     1.955     0.200
    70.382    -0.404     0.200
    70.741     2.204     0.200
    71.165    -1.166     0.200
    71.312    -3.057     0.200
    71.410    -0.948     0.200
    71.510     2.248     0.200
    71.770     0.583     0.200
    71.854    -1.317     0.200
    71.959    -0.050     0.200
    72.498    -0.169     0.200
    72.297     0.929     0.200
    72.896     0.968     0.200
    73.203     1.049     0.200
    73.073     1.420     0.200
    73.733    -0.464     0.200
    73.783    -0.159     0.200
    73.583     1.416     0.200
    73.884     0.649     0.200
    74.193    -0.154     0.200
    74.467     2.250     0.200
    74.954    -0.565     0.200
    74.629     4.314     0.200
    75.133     0.902     0.200
    75.443     0.420     0.200
    75.457    -0.459     0.200
    75.530    -0.680     0.200
    75.530    -0.879     0.200
    75.478     0.917     0.200
    75.770     1.249     0.200
    75.754     1.341     0.200
    76.443     0.919     0.200
    76.170     2.470     0.200
    76.796     0.929     0.200
    76.684    -1.439     0.200
    77.150    -0.062     0.200
    77.410     1.478     0.200
    77.644     0.671     0.200
    77.488     2.240     0.200
    77.862    -0.645     0.200
    77.910     0.692     0.200
    77.780     2.414     0.200
    77.846     2.545     0.200
    78.082    -1.265     0.200
    78.196     0.103     0.200
    78.207     0.446     0.200
    78.018     0.992     0.200
    78.326     0.386     0.200
    78.484    -1.484     0.200
    78.681     1.430     0.200
    78.708     0.182     0.200
    79.132     0.954     0.200
    79.130    -0.034     0.200
    79.258     0.267     0.200
    79.465    -0.161     0.200
    79.415     0.910     0.200
    79.579     1.520     0.200
    79.579     2.520     0.200
    79.878    -0.100     0.200
    80.178     0.278     0.200
    80.163     1.962     0.200
    80.372     0.233     0.200
    80.410     0.031     0.200
    80.410     1.031     0.200
    80.516     0.460     0.200
    80.627     0.063     0.200
    80.648    -0.245     0.200
    80.703     0.459     0.200
    80.839    -0.266     0.200
    80.898     0.416     0.200
    80.979    -0.016     0.200
    80.996     0.093     0.200
    81.026     1.735     0.200
    81.052    -0.705     0.200
    81.291     0.627     0.200
    81.422    -1.063     0.200
    81.058     4.565     0.200
    81.581     0.192     0.200
    81.891    -0.238     0.200
    82.386    -1.435     0.200
    82.599    -0.541     0.200
    82.607     0.219     0.200
    82.925    -2.233     0.200
    83.053     0.102     0.200
    83.292     0.369     0.200
    83.254    -0.934     0.200
    83.360     2.518     0.200
    83.836    -0.319     0.200
    83.904     0.330     0.200
    83.628     3.144     0.200
    83.769     1.420     0.200
    83.773     3.097     0.200
    84.172    -0.634     0.200
    84.232    -0.139     0.200
    84.204    -0.796     0.200
    84.344    -0.207     0.200
    84.434    -0.963     0.200
    84.616     0.118     0.200
    84.664     0.877     0.200
    84.330     3.264     0.200
    85.057    -0.202     0.200
    84.965     2.360     0.200
    85.308    -1.655     0.200
    85.307     0.651     0.200
    85.164     3.365     0.200
    85.303     3.970     0.200
    85.709     1.049     0.200
    85.759     0.904     0.200
    85.939    -0.490     0.200
    85.904    -1.418     0.200
    85.994    -1.762     0.200
    85.964     2.489     0.200
    85.865     3.877     0.200
    85.932     3.743     0.200
    86.245     1.000     0.200
    86.427     1.106     0.200
    86.533     0.387     0.200
    86.569    -0.991     0.200
    86.335     1.956     0.200
    87.290     0.898     0.200
    87.254     2.073     0.200
    88.117    -0.052     0.200
    88.016     1.424     0.200
    89.353     0.129     0.200
    89.373     1.533     0.200
    89.431     2.364     0.200
    90.138     0.961     0.200
    90.588    -1.338     0.200
    90.534     0.812     0.200
    90.415     2.166     0.200
    90.841     1.290     0.200
    91.087     0.547     0.200
    91.240     1.336     0.200
    92.915     0.791     0.200
    93.059    -0.574     0.200
    93.131     0.596     0.200
    93.077     2.344     0.200
    94.450     2.032     0.200
    95.914    -1.160     0.200
    95.896     1.922     0.200
    99.087    -0.461     0.200
    99.257    -1.219     0.200
    43.891     0.690     0.200
    44.013     0.412     0.200
    51.033    -0.200     0.200
    58.588     0.020     0.200
    60.660    -2.247     0.200
    62.420    -2.120     0.200
    63.960    -2.326     0.200
    64.335     0.210     0.200
    65.243     1.300     0.200
    65.375     0.446     0.200
    65.966    -1.370     0.200
    66.966     1.638     0.200
    67.208    -0.296     0.200
    67.329     1.639     0.200
    69.695    -1.836     0.200
    69.855    -1.421     0.200
    71.459     1.417     0.200
    77.727     1.965     0.200
    21.307    -2.014     0.200
    32.607    -2.480     0.200
    43.015    -1.059     0.200
    43.899     0.514     0.200
    44.021     0.339     0.200
    45.078     0.207     0.200
    49.041    -0.696     0.200
    51.030    -0.581     0.200
    51.036    -0.826     0.200
    54.737    -1.124     0.200
    56.946    -1.742     0.200
    57.108    -2.083     0.200
    58.594    -0.508     0.200
    61.159    -1.318     0.200
    62.060    -1.694     0.200
    62.184     1.975     0.200
    62.394    -1.428     0.200
    62.451    -1.809     0.200
    62.521     0.722     0.200
    63.961    -0.814     0.200
    64.346     0.661     0.200
    65.018    -2.016     0.200
    65.257     1.334     0.200
    65.389     1.076     0.200
    65.939    -1.672     0.200
    67.220     0.156     0.200
    67.345     1.564     0.200
    68.501    -0.905     0.200
    69.437     1.284     0.200
    69.437    -1.211     0.200
    69.830    -1.235     0.200
    71.309    -2.145     0.200
    71.477     1.941     0.200
    72.131     1.914     0.200
    72.864     2.151     0.200
    74.433     2.345     0.200
    77.180    -1.339     0.200
    77.746     2.103     0.200
    78.739     0.006     0.200
    79.380     1.998     0.200
    80.131     1.432     0.200
    43.868     0.632     0.200
    43.990     0.460     0.200
    49.008    -0.981     0.200
    50.996    -0.956     0.200
    51.002    -1.104     0.200
    54.702    -1.410     0.200
    58.562    -0.829     0.200
    58.963    -2.617     0.200
    60.605    -1.899     0.200
    62.364    -1.878     0.200
    62.422    -1.458     0.200
    62.556     0.443     0.200
    63.928    -1.141     0.200
    64.317     0.306     0.200
    64.988    -2.170     0.200
    65.230     1.362     0.200
    65.362     1.107     0.200
    65.911    -1.834     0.200
    66.952     1.308     0.200
    67.191     0.587     0.200
    67.319     1.184     0.200
    67.521     0.997     0.200
    68.470    -0.260     0.200
    68.604    -0.093     0.200
    69.407    -1.577     0.200
    69.640    -1.416     0.200
    69.800    -1.399     0.200
    69.703     1.492     0.200
    71.274    -2.486     0.200
    71.452     1.138     0.200
    72.839     1.545     0.200
    76.639    -0.847     0.200
    77.152    -0.737     0.200
    77.722     2.078     0.200
    79.357     1.966     0.200
    43.890     0.951     0.200
    44.012     0.475     0.200
    49.028    -0.330     0.200
    51.010    -0.458     0.200
    51.016    -0.404     0.200
    54.156    -1.634     0.200
    54.708    -1.646     0.200
    56.909    -1.108     0.200
    57.086    -1.657     0.200
    58.583    -0.161     0.200
    60.595    -1.718     0.200
    61.120    -1.585     0.200
    62.354    -2.188     0.200
    62.411    -1.267     0.200
    63.087     1.229     0.200
    63.945    -0.436     0.200
    64.342     0.966     0.200
    64.978    -1.982     0.200
    65.256     1.010     0.200
    65.389    -0.847     0.200
    65.899    -1.936     0.200
    67.216    -0.546     0.200
    67.347     1.028     0.200
    68.492     0.427     0.200
    68.764    -2.064     0.200
    69.397    -1.790     0.200
    69.630    -1.631     0.200
    69.790    -1.613     0.200
    71.286    -1.732     0.200
    72.867     1.808     0.200
    77.635     0.396     0.200
    78.698    -0.290     0.200
    44.033     0.447     0.200
    44.097     0.437     0.200
    44.155     0.471     0.200
    45.080    -0.393     0.200
    54.490    -0.048     0.200
    54.911    -2.398     0.200
    57.018    -0.953     0.200
    59.164    -0.450     0.200
    59.858    -0.235     0.200
    60.803    -1.482     0.200
    60.862    -0.184     0.200
    61.330    -2.053     0.200
    62.560    -1.505     0.200
    62.616    -1.375     0.200
    64.114    -1.776     0.200
    65.185    -1.451     0.200
    65.367     1.068     0.200
    65.498     0.221     0.200
    66.102    -2.163     0.200
    67.092     0.523     0.200
    67.339     0.457     0.200
    67.446     1.283     0.200
    68.637     0.316     0.200
    68.969    -2.146     0.200
    71.568     2.369     0.200
    72.917     1.323     0.200
    72.961     0.959     0.200
    74.728     1.530     0.200
    75.632    -0.467     0.200
    75.958    -0.628     0.200
    76.451     1.876     0.200
    77.342    -1.234     0.200
    77.835     0.115     0.200
    77.833     1.926     0.200
    78.389    -0.948     0.200
    78.898    -0.552     0.200
    79.319    -0.049     0.200
    83.951    -0.568     0.200
    84.248    -0.580     0.200
    21.429    -5.075     0.200
    24.128    -4.242     0.200
    27.940    -1.651     0.200
    28.453    -1.219     0.200
    32.772    -1.305     0.200
    41.597    -0.329     0.200
    42.497    -0.353     0.200
    43.740     0.411     0.200
    44.061     0.337     0.200
    44.183     0.062     0.200
    46.782     0.527     0.200
    47.290    -0.435     0.200
    49.205    -0.183     0.200
    51.200    -1.372     0.200
    54.892    -2.426     0.200
    55.817    -1.076     0.200
    55.987    -2.289     0.200
    56.929    -1.688     0.200
    57.271    -1.700     0.200
    59.109    -1.234     0.200
    59.775     0.179     0.200
    60.746    -1.850     0.200
    60.773    -0.536     0.200
    61.278    -2.059     0.200
    62.479    -1.121     0.200
    62.501    -2.166     0.200
    62.555    -1.626     0.200
    63.029     0.224     0.200
    64.505    -0.487     0.200
    64.792    -1.357     0.200
    65.127    -1.926     0.200
    66.039    -1.411     0.200
    67.377     1.068     0.200
    67.494     1.229     0.200
    67.686     0.518     0.200
    69.476     0.969     0.200
    69.939    -1.875     0.200
    69.866     1.772     0.200
    70.230    -2.058     0.200
    71.208    -1.604     0.200
    71.622     1.907     0.200
    72.229     0.669     0.200
    73.012     0.724     0.200
    74.776     1.013     0.200
    75.563    -0.413     0.200
    77.278    -0.911     0.200
    77.770    -0.655     0.200
    78.325    -0.732     0.200
    78.833    -0.326     0.200
    79.255     0.165     0.200
    82.669    -0.004     0.200
    83.890    -0.485     0.200
    83.924    -0.656     0.200
    83.973    -0.509     0.200
    84.099    -0.546     0.200
    84.188    -0.499     0.200
    84.370    -0.324     0.200
    84.744    -0.010     0.200
    85.293    -0.160     0.200
    85.547    -0.122     0.200
    85.759     0.325     0.200
    38.470    -0.546     0.200
    41.638    -0.387     0.200
    42.541    -0.641     0.200
    43.783    -0.364     0.200
    44.103     0.479     0.200
    44.225    -0.194     0.200
    44.954    -0.105     0.200
    45.082    -0.018     0.200
    45.113     0.828     0.200
    47.745    -0.991     0.200
    49.244    -1.010     0.200
    52.609    -0.775     0.200
    54.104    -0.244     0.200
    54.367     0.350     0.200
    54.916    -2.026     0.200
    55.420    -0.954     0.200
    55.477     1.334     0.200
    56.005    -1.950     0.200
    56.897    -1.286     0.200
    58.450     1.312     0.200
    58.528     0.768     0.200
    58.798    -0.604     0.200
    59.114    -1.895     0.200
    59.134     1.569     0.200
    59.732    -0.156     0.200
    60.749    -1.801     0.200
    60.739    -0.130     0.200
    61.284    -1.630     0.200
    62.181    -1.855     0.200
    62.480    -1.152     0.200
    62.334     0.821     0.200
    62.535    -0.521     0.200
    62.985     0.486     0.200
    63.633     0.206     0.200
    64.163    -1.079     0.200
    64.548     0.306     0.200
    65.129    -1.872     0.200
    65.587    -0.532     0.200
    66.038    -1.534     0.200
    66.078     2.311     0.200
    67.195    -1.005     0.200
    67.421     0.664     0.200
    67.540     1.118     0.200
    67.733     0.602     0.200
    68.705     0.017     0.200
    68.840    -0.421     0.200
    68.910    -1.753     0.200
    69.941    -1.917     0.200
    69.912     1.261     0.200
    70.234    -1.811     0.200
    71.502    -1.601     0.200
    71.552    -1.701     0.200
    71.668     1.603     0.200
    71.807    -0.232     0.200
    72.106    -1.023     0.200
    72.273     0.681     0.200
    73.057     1.325     0.200
    73.917    -0.922     0.200
    74.821     1.325     0.200
    75.558    -0.608     0.200
    75.648     0.274     0.200
    75.883     0.634     0.200
    76.501    -0.571     0.200
    76.556     2.119     0.200
    76.873    -1.671     0.200
    77.276    -0.928     0.200
    77.280    -0.452     0.200
    77.569    -0.567     0.200
    77.742    -0.530     0.200
    77.767    -0.665     0.200
    77.839    -0.066     0.200
    77.946    -0.663     0.200
    77.957    -0.724     0.200
    78.075     0.120     0.200
    78.126    -0.659     0.200
    78.279    -0.507     0.200
    78.324    -0.751     0.200
    78.707    -0.464     0.200
    78.830    -0.336     0.200
    79.568     1.438     0.200
    80.276    -0.389     0.200
    80.496     0.431     0.200
    80.755    -0.556     0.200
    81.188    -0.757     0.200
    81.711    -0.622     0.200
    81.739    -0.566     0.200
    81.831    -1.650     0.200
    82.404    -0.648     0.200
    82.409    -0.675     0.200
    82.647    -0.412     0.200
    83.891    -0.515     0.200
    83.927    -0.500     0.200
    83.976    -0.750     0.200
    84.034    -0.046     0.200
    84.099    -0.477     0.200
    84.125    -0.612     0.200
    84.188    -0.432     0.200
    84.373    -0.165     0.200
    84.537    -0.592     0.200
    84.748     0.146     0.200
    85.027     3.743     0.200
    85.261    -1.227     0.200
    85.294     0.210     0.200
    85.479     1.389     0.200
    85.878    -0.392     0.200
    86.095    -0.258     0.200
    86.138    -0.371     0.200
    86.314    -0.638     0.200
    87.476     1.908     0.200
    89.224     2.951     0.200
    89.541    -0.134     0.200
    90.715     0.497     0.200
    19.612    -4.002     0.200
    21.445    -3.802     0.200
    24.160    -4.931     0.200
    27.980    -0.612     0.200
    28.663     0.505     0.200
    29.969    -0.267     0.200
    30.355    -4.676     0.200
    32.205     0.051     0.200
    32.754    -2.253     0.200
    38.404    -0.690     0.200
    38.311     1.597     0.200
    38.897    -1.422     0.200
    41.573    -0.351     0.200
    42.464    -0.215     0.200
    43.080    -1.304     0.200
    43.712    -0.485     0.200
    44.036     0.413     0.200
    44.158     0.337     0.200
    45.013    -0.175     0.200
    45.043     1.088     0.200
    45.044    -0.419     0.200
    46.883     1.609     0.200
    47.334    -0.404     0.200
    47.466     3.568     0.200
    47.834    -0.281     0.200
    48.749     4.667     0.200
    49.184    -1.258     0.200
    49.248    -0.147     0.200
    51.188    -1.312     0.200
    51.056     4.174     0.200
    52.282     0.034     0.200
    52.148     4.525     0.200
    52.693     0.094     0.200
    53.316     0.410     0.200
    53.475    -0.759     0.200
    53.751     0.219     0.200
    54.189    -0.076     0.200
    54.348     0.875     0.200
    54.447     0.456     0.200
    54.759    -1.107     0.200
    54.890    -1.756     0.200
    55.498    -1.635     0.200
    55.827    -1.290     0.200
    55.884     0.999     0.200
    56.975    -1.350     0.200
    57.260    -1.666     0.200
    58.375     1.614     0.200
    58.579    -1.404     0.200
    58.603     1.133     0.200
    59.128    -2.510     0.200
    59.177     1.650     0.200
    59.822     0.011     0.200
    60.766    -1.937     0.200
    60.819    -0.295     0.200
    61.295    -2.023     0.200
    61.443    -0.819     0.200
    62.194    -1.670     0.200
    62.034     2.708     0.200
    62.458     0.068     0.200
    62.502    -1.222     0.200
    62.368     0.974     0.200
    62.537     1.141     0.200
    62.623     0.268     0.200
    63.075    -0.735     0.200
    63.222    -0.708     0.200
    63.555     0.094     0.200
    64.108    -0.943     0.200
    64.477    -0.955     0.200
    64.476     0.153     0.200
    64.822    -1.204     0.200
    65.147    -1.918     0.200
    65.257     0.972     0.200
    65.378     0.992     0.200
    65.510     0.643     0.200
    65.918     2.710     0.200
    66.063    -1.418     0.200
    66.112     0.469     0.200
    67.184    -0.363     0.200
    67.228     0.660     0.200
    67.347     0.603     0.200
    67.460     1.393     0.200
    67.649     1.100     0.200
    68.284     1.715     0.200
    68.345    -0.769     0.200
    68.527    -3.803     0.200
    68.639    -0.001     0.200
    68.762    -1.269     0.200
    68.931    -1.816     0.200
    69.514     1.077     0.200
    69.827     1.651     0.200
    70.089     0.545     0.200
    70.250    -1.739     0.200
    70.803     1.195     0.200
    70.875     1.054     0.200
    71.252    -0.528     0.200
    71.461    -1.589     0.200
    71.476    -0.680     0.200
    71.568    -1.330     0.200
    71.585     1.666     0.200
    71.727     1.914     0.200
    72.976     1.471     0.200
    73.163     1.964     0.200
    73.643     1.242     0.200
    73.939    -0.786     0.200
    74.333    -2.785     0.200
    74.333    -0.285     0.200
    74.333     0.215     0.200
    74.742     1.350     0.200
    75.261     1.157     0.200
    75.591    -0.335     0.200
    75.675     0.484     0.200
    75.691    -0.604     0.200
    75.917     0.105     0.200
    76.536    -0.405     0.200
    76.790     0.762     0.200
    76.936    -0.659     0.200
    77.302    -1.015     0.200
    77.308    -1.244     0.200
    77.499     1.986     0.200
    77.579    -1.257     0.200
    77.771    -1.327     0.200
    77.795    -0.065     0.200
    77.889     0.118     0.200
    77.966    -0.413     0.200
    77.995    -0.570     0.200
    78.122    -0.176     0.200
    78.213    -0.777     0.200
    78.231     0.123     0.200
    78.350    -1.033     0.200
    78.717    -0.557     0.200
    78.743    -0.598     0.200
    78.859    -0.134     0.200
    79.280     0.165     0.200
    79.483     1.257     0.200
    79.418     2.313     0.200
    79.620    -0.987     0.200
    80.023    -0.467     0.200
    80.324    -0.485     0.200
    80.524    -0.359     0.200
    80.987    -0.832     0.200
    81.028     0.055     0.200
    81.090     0.123     0.200
    81.136     0.274     0.200
    81.209    -1.007     0.200
    81.445    -1.261     0.200
    81.571    -1.422     0.200
    82.710    -0.382     0.200
    83.207    -0.456     0.200
    83.199     2.588     0.200
    83.453    -0.022     0.200
    83.612     2.966     0.200
    83.913    -0.469     0.200
    83.944    -0.730     0.200
    83.993    -0.783     0.200
    84.058    -0.513     0.200
    84.121    -0.531     0.200
    84.147    -0.461     0.200
    84.210    -0.385     0.200
    84.325     0.033     0.200
    84.168     2.929     0.200
    84.390    -0.394     0.200
    84.563    -0.169     0.200
    84.765     0.116     0.200
    84.779     0.543     0.200
    85.204    -1.785     0.200
    85.287    -0.999     0.200
    85.316    -0.040     0.200
    85.403    -0.078     0.200
    85.569     0.199     0.200
    85.780    -0.350     0.200
    86.063     0.552     0.200
    86.122    -0.742     0.200
    86.126    -0.659     0.200
    86.341    -0.519     0.200
    86.390    -0.456     0.200
    86.704    -0.492     0.200
    87.458     2.349     0.200
    90.645     0.173     0.200
    93.072     0.344     0.200
    18.456    -2.508     0.200
    19.616    -3.493     0.200
    21.445    -3.940     0.200
    24.163    -5.274     0.200
    27.986    -0.773     0.200
    28.501    -0.560     0.200
    29.976    -0.428     0.200
    30.354    -4.766     0.200
    32.746    -2.795     0.200
    38.396    -0.221     0.200
    38.903    -1.168     0.200
    41.565    -0.483     0.200
    42.455    -0.235     0.200
    43.703    -0.309     0.200
    44.028     0.385     0.200
    44.150     0.110     0.200
    45.034     0.565     0.200
    47.341    -0.552     0.200
    49.176    -0.287     0.200
    49.255    -0.292     0.200
    51.182    -1.354     0.200
    51.668    -0.490     0.200
    52.286    -0.084     0.200
    52.702     0.340     0.200
    53.324     0.359     0.200
    53.482    -0.898     0.200
    53.759     0.077     0.200
    53.872    -0.746     0.200
    54.198    -0.625     0.200
    54.455     0.010     0.200
    54.886    -1.812     0.200
    55.140     0.058     0.200
    55.826    -1.162     0.200
    56.983    -0.992     0.200
    57.254    -1.607     0.200
    58.366     1.198     0.200
    58.580    -3.893     0.200
    58.611     1.490     0.200
    58.726    -0.507     0.200
    59.128    -1.393     0.200
    59.832     0.063     0.200
    60.759    -2.167     0.200
    60.767    -1.822     0.200
    60.827    -0.633     0.200
    61.295    -1.703     0.200
    62.195    -1.750     0.200
    62.036     1.412     0.200
    62.503    -1.909     0.200
    62.372     1.064     0.200
    62.545     0.713     0.200
    62.633     0.526     0.200
    63.085     1.121     0.200
    63.546     1.078     0.200
    63.966    -1.689     0.200
    64.101    -1.076     0.200
    64.467     0.132     0.200
    64.825    -1.302     0.200
    65.149    -2.099     0.200
    65.268     0.830     0.200
    65.369     1.176     0.200
    66.065    -1.605     0.200
    66.927     1.491     0.200
    67.112     1.519     0.200
    67.093     0.138     0.200
    67.182    -0.823     0.200
    67.338     0.585     0.200
    67.450     1.178     0.200
    68.084     0.991     0.200
    68.177    -1.487     0.200
    68.291     0.598     0.200
    68.533     0.086     0.200
    68.631     0.276     0.200
    68.773    -1.010     0.200
    68.932    -1.698     0.200
    69.208    -1.108     0.200
    69.520     0.969     0.200
    69.817     1.639     0.200
    69.961    -1.641     0.200
    70.251    -1.815     0.200
    70.239     2.555     0.200
    71.260    -0.346     0.200
    71.429    -1.164     0.200
    71.569    -1.307     0.200
    71.575     1.954     0.200
    72.119    -1.104     0.200
    72.189     0.575     0.200
    72.967     2.157     0.200
    73.940    -0.464     0.200
    75.594     0.081     0.200
    75.678    -0.603     0.200
    75.694     0.306     0.200
    75.920     0.020     0.200
    76.437     1.184     0.200
    76.461     1.952     0.200
    77.304    -0.593     0.200
    77.310     0.176     0.200
    77.798    -0.143     0.200
    77.740     2.579     0.200
    77.894    -0.677     0.200
    77.968    -0.489     0.200
    78.127    -0.169     0.200
    78.351    -0.610     0.200
    78.597    -0.962     0.200
    78.717    -0.424     0.200
    78.861    -0.112     0.200
    78.883    -0.534     0.200
    79.282    -0.013     0.200
    79.474     1.244     0.200
    80.233     1.640     0.200
    80.526    -0.436     0.200
    80.783    -0.807     0.200
    80.890    -0.778     0.200
    80.990    -0.812     0.200
    81.093     0.138     0.200
    81.140     0.191     0.200
    81.207    -1.066     0.200
    81.210    -1.079     0.200
    81.765    -0.010     0.200
    81.858    -1.502     0.200
    82.110    -0.820     0.200
    82.429    -0.690     0.200
    82.434    -0.514     0.200
    83.914    -0.442     0.200
    83.945    -0.699     0.200
    83.994    -0.751     0.200
    84.123    -0.304     0.200
    84.212    -0.356     0.200
    84.391    -0.264     0.200
    84.765    -0.051     0.200
    85.289    -1.471     0.200
    85.317     0.189     0.200
    85.394     0.904     0.200
    85.462    -1.035     0.200
    85.570     0.228     0.200
    85.782     0.181     0.200
    85.797     0.203     0.200
    86.054     0.535     0.200
    86.119    -1.186     0.200
    86.742    -0.041     0.200
    86.989     0.054     0.200
    87.073     0.148     0.200
    87.457     2.292     0.200
    90.636     0.450     0.200
    18.471    -1.445     0.200
    19.646    -3.290     0.200
    21.470    -4.988     0.200
    24.192    -5.317     0.200
    28.530    -1.094     0.200
    30.005    -0.463     0.200
    32.754    -1.644     0.200
    38.400    -0.033     0.200
    38.932    -1.491     0.200
    41.569    -0.296     0.200
    44.031     0.280     0.200
    44.153    -0.196     0.200
    47.369    -0.549     0.200
    47.865    -0.996     0.200
    49.182    -0.514     0.200
    51.193    -0.721     0.200
    54.482     0.141     0.200
    57.010    -1.163     0.200
    57.267    -1.776     0.200
    60.780    -2.088     0.200
    60.793    -1.782     0.200
    60.854    -0.191     0.200
    62.530    -1.969     0.200
    64.110    -1.411     0.200
    66.092    -1.460     0.200
    67.446     1.125     0.200
    68.562    -0.874     0.200
    68.634     0.175     0.200
    68.780    -0.232     0.200
    68.959    -1.744     0.200
    69.549     1.009     0.200
    69.987    -1.383     0.200
    70.277    -1.955     0.200
    71.442    -1.524     0.200
    72.189     0.698     0.200
    77.332    -1.426     0.200
    77.826     0.522     0.200
    78.889    -0.344     0.200
    79.309     0.357     0.200
    85.597     0.013     0.200
    41.411    -0.198     0.200
    43.875     0.298     0.200
    43.997    -0.179     0.200
    51.015    -1.193     0.200
    57.087    -1.478     0.200
    58.570    -0.390     0.200
    65.933    -1.891     0.200
    67.196    -0.756     0.200
    70.109    -2.417     0.200
    71.453     1.411     0.200
    72.048     0.337     0.200
    18.477    -1.979     0.200
    21.440    -5.631     0.200
    24.140    -4.800     0.200
    27.951    -1.202     0.200
    28.464    -0.666     0.200
    29.940    -0.851     0.200
    30.357    -3.533     0.200
    32.778    -2.309     0.200
    38.870    -1.029     0.200
    40.473     0.349     0.200
    40.652     0.876     0.200
    41.602    -0.521     0.200
    43.051    -1.500     0.200
    43.743    -1.772     0.200
    44.065     0.244     0.200
    44.187    -0.031     0.200
    45.003     0.071     0.200
    45.005     0.156     0.200
    46.792    -0.013     0.200
    47.300     0.024     0.200
    47.794    -2.100     0.200
    49.215    -0.723     0.200
    49.210    -0.686     0.200
    51.207    -1.684     0.200
    51.627     0.078     0.200
    52.260    -0.429     0.200
    52.655    -1.050     0.200
    53.442    -1.344     0.200
    53.716    -0.350     0.200
    53.830    -1.181     0.200
    54.410    -0.004     0.200
    54.901    -1.854     0.200
    55.098    -0.382     0.200
    55.462    -0.999     0.200
    55.767    -0.684     0.200
    55.828    -0.918     0.200
    55.867     1.101     0.200
    57.278    -1.717     0.200
    58.408     0.164     0.200
    58.569    -1.956     0.200
    58.570     1.041     0.200
    58.762    -0.295     0.200
    59.120    -1.380     0.200
    59.159     0.957     0.200
    60.757    -1.996     0.200
    60.765    -1.952     0.200
    60.782    -0.365     0.200
    61.289    -1.703     0.200
    62.187    -1.638     0.200
    62.426     1.164     0.200
    62.491    -1.666     0.200
    62.353     1.148     0.200
    63.035     0.718     0.200
    63.589     0.050     0.200
    63.945    -1.288     0.200
    64.132    -1.119     0.200
    64.508     0.226     0.200
    64.804    -1.901     0.200
    65.138    -1.770     0.200
    65.217     1.420     0.200
    65.412     1.155     0.200
    65.544     1.305     0.200
    66.051    -1.455     0.200
    66.974     1.850     0.200
    67.380     0.083     0.200
    67.495     1.753     0.200
    67.686     1.152     0.200
    68.128     0.980     0.200
    68.193    -1.331     0.200
    68.252     0.098     0.200
    68.499    -1.441     0.200
    68.668    -0.495     0.200
    68.807    -0.755     0.200
    68.920    -1.762     0.200
    69.174    -0.633     0.200
    69.950    -1.717     0.200
    69.865     1.707     0.200
    70.241    -1.801     0.200
    70.286     2.030     0.200
    70.971     1.862     0.200
    71.218    -0.334     0.200
    71.452    -1.542     0.200
    71.622     1.434     0.200
    72.112    -0.701     0.200
    72.231     0.684     0.200
    72.688     1.964     0.200
    74.625     2.714     0.200
    75.575    -0.252     0.200
    75.658    -1.226     0.200
    75.671    -0.298     0.200
    76.509     0.940     0.200
    77.239    -0.169     0.200
    77.289    -0.847     0.200
    77.573    -0.836     0.200
    77.534     2.183     0.200
    77.781    -0.193     0.200
    77.787     2.378     0.200
    77.961    -0.492     0.200
    78.130    -0.629     0.200
    78.208    -0.358     0.200
    78.314    -0.342     0.200
    78.337    -0.769     0.200
    78.711    -0.333     0.200
    78.737    -0.475     0.200
    78.844     0.039     0.200
    79.267     0.027     0.200
    80.278     2.153     0.200
    80.510    -0.092     0.200
    80.972    -0.656     0.200
    81.069    -0.173     0.200
    81.117    -0.125     0.200
    81.198    -1.058     0.200
    81.723    -0.731     0.200
    81.751    -0.178     0.200
    82.086    -0.435     0.200
    82.347     0.401     0.200
    83.902    -0.420     0.200
    83.935    -0.688     0.200
    83.984    -0.842     0.200
    84.199    -0.333     0.200
    84.381    -0.556     0.200
    84.756    -0.143     0.200
    85.274    -1.040     0.200
    85.447    -1.399     0.200
    85.437     0.651     0.200
    85.771    -0.008     0.200
    86.109    -0.877     0.200
    86.096     0.488     0.200
    86.328    -0.455     0.200
    86.377    -0.193     0.200
    86.730     0.378     0.200
    86.977     0.472     0.200
    87.061     0.467     0.200
    90.676     0.530     0.200
    93.062     0.389     0.200
    99.232    -0.620     0.200
    44.274     0.356     0.200
    57.256    -1.502     0.200
    70.024    -0.924     0.200
    72.358     1.073     0.200
    18.007    -3.253     0.200
    37.726     0.166     0.200
    40.899     0.060     0.200
    43.348     0.340     0.200
    43.471     0.552     0.200
    50.659    -1.475     0.200
    56.755    -1.078     0.200
    60.774    -1.744     0.200
    62.171    -1.952     0.200
    62.553    -1.902     0.200
    66.142    -2.233     0.200
    66.684     1.601     0.200
    68.977    -1.994     0.200
    69.979    -1.669     0.200
    71.458     0.959     0.200
    20.096    -3.583     0.200
    40.673    -0.626     0.200
    40.864     1.301     0.200
    43.951     0.184     0.200
    44.251    -0.227     0.200
    44.373     0.006     0.200
    51.307    -1.131     0.200
    53.833     0.371     0.200
    54.925    -1.079     0.200
    59.005    -2.484     0.200
    60.631    -1.767     0.200
    60.741    -1.414     0.200
    61.185    -1.031     0.200
    62.073    -1.714     0.200
    62.300    -1.143     0.200
    62.349    -1.268     0.200
    62.715    -0.709     0.200
    64.268    -0.974     0.200
    64.718     0.084     0.200
    65.008    -1.806     0.200
    65.645     1.068     0.200
    65.778     0.209     0.200
    65.899    -1.472     0.200
    67.741     1.095     0.200
    68.361     0.598     0.200
    68.780    -1.022     0.200
    68.851    -0.260     0.200
    68.959    -0.932     0.200
    70.119    -1.594     0.200
    70.923    -0.398     0.200
    71.533    -0.686     0.200
    72.450     0.112     0.200
    73.263     0.991     0.200
    77.134    -0.499     0.200
    78.182    -0.142     0.200
    79.110    -0.254     0.200
    20.023    -3.112     0.200
    23.906    -2.868     0.200
    28.134    -1.086     0.200
    29.620     0.712     0.200
    30.319    -3.464     0.200
    32.970    -1.272     0.200
    38.565    -1.731     0.200
    38.672     0.175     0.200
    44.014    -0.764     0.200
    44.311     1.359     0.200
    44.432    -0.109     0.200
    46.437     0.315     0.200
    46.950    -0.702     0.200
    46.949     1.305     0.200
    48.866    -0.533     0.200
    49.423    -0.792     0.200
    51.273     0.215     0.200
    51.349    -1.053     0.200
    53.095    -1.319     0.200
    53.353    -0.218     0.200
    53.761    -0.213     0.200
    54.034    -0.206     0.200
    54.742    -1.353     0.200
    54.950    -1.361     0.200
    55.090    -0.368     0.200
    55.780    -0.830     0.200
    56.570    -1.577     0.200
    57.406    -1.387     0.200
    58.695     0.580     0.200
    58.997    -1.910     0.200
    60.406    -0.609     0.200
    60.620    -1.772     0.200
    60.755    -2.589     0.200
    61.179    -1.470     0.200
    62.065    -2.040     0.200
    62.269    -0.306     0.200
    62.334    -0.940     0.200
    62.638     0.725     0.200
    63.722    -1.458     0.200
    63.892     1.424     0.200
    64.277    -1.104     0.200
    64.317    -1.566     0.200
    64.580    -0.088     0.200
    64.822     1.335     0.200
    64.781    -0.200     0.200
    64.995    -1.492     0.200
    65.712     0.566     0.200
    65.881    -1.625     0.200
    65.846     0.706     0.200
    66.013     0.627     0.200
    66.297     2.006     0.200
    67.314     1.231     0.200
    67.810     0.998     0.200
    68.190    -3.185     0.200
    68.428     0.819     0.200
    68.765    -1.384     0.200
    68.910    -0.682     0.200
    69.807    -1.728     0.200
    70.109    -1.884     0.200
    70.208     1.308     0.200
    70.862    -1.482     0.200
    71.190     1.835     0.200
    71.258     1.121     0.200
    71.309     1.616     0.200
    71.570    -1.963     0.200
    71.993    -0.503     0.200
    71.952     1.943     0.200
    72.515    -0.320     0.200
    72.619     1.762     0.200
    73.334     1.428     0.200
    73.691     0.431     0.200
    74.961     0.740     0.200
    75.372    -0.330     0.200
    75.431    -0.667     0.200
    75.442    -0.732     0.200
    76.081    -0.381     0.200
    77.113    -0.114     0.200
    77.113    -1.113     0.200
    77.571    -0.781     0.200
    77.595    -0.914     0.200
    77.738     1.289     0.200
    77.840     1.722     0.200
    78.014    -0.243     0.200
    78.163    -0.068     0.200
    78.658    -0.505     0.200
    78.912    -0.199     0.200
    78.864    -0.937     0.200
    79.091    -0.177     0.200
    79.404     1.114     0.200
    79.861     0.630     0.200
    80.601     1.341     0.200
    80.730    -0.045     0.200
    80.825    -0.452     0.200
    80.879    -0.239     0.200
    85.102    -0.494     0.200
    85.728    -0.514     0.200
    86.346    -1.864     0.200
    86.382    -0.645     0.200
    86.744    -0.119     0.200
    86.914    -0.249     0.200
    90.935     0.177     0.200
    18.476    -2.089     0.200
    20.401    -4.064     0.200
    21.431    -3.259     0.200
    32.781    -2.499     0.200
    38.854    -2.460     0.200
    43.751     0.698     0.200
    44.013     0.294     0.200
    44.071    -0.174     0.200
    44.193    -0.750     0.200
    47.284    -0.518     0.200
    49.215    -1.395     0.200
    51.208    -1.470     0.200
    54.133    -1.072     0.200
    55.081     1.061     0.200
    55.542    -0.556     0.200
    55.867     1.419     0.200
    58.417     2.423     0.200
    59.110    -0.892     0.200
    60.746    -1.609     0.200
    60.765    -0.433     0.200
    60.760    -1.399     0.200
    61.280    -2.222     0.200
    61.538     1.931     0.200
    62.479    -1.878     0.200
    62.345     0.620     0.200
    63.018     1.138     0.200
    64.135    -1.224     0.200
    65.553     0.859     0.200
    66.039    -1.967     0.200
    65.967     1.891     0.200
    66.986     0.389     0.200
    68.137     0.132     0.200
    68.674     0.578     0.200
    69.463     2.991     0.200
    69.495     0.689     0.200
    70.296     0.773     0.200
    70.853     2.386     0.200
    70.925     0.949     0.200
    70.982     0.602     0.200
    71.633     1.177     0.200
    71.774     1.527     0.200
    72.303     0.264     0.200
    73.023     1.592     0.200
    73.717     2.306     0.200
    75.645     0.155     0.200
    77.277    -0.578     0.200
    77.282    -0.706     0.200
    77.769     0.179     0.200
    78.325     0.100     0.200
    78.702     0.023     0.200
    78.832    -0.692     0.200
    79.532     1.487     0.200
    80.289     1.400     0.200
    80.607    -0.306     0.200
    83.890    -0.160     0.200
    84.099    -0.124     0.200
    84.125     0.044     0.200
    84.745     0.409     0.200
    85.029     3.788     0.200
    85.445     0.709     0.200
    86.104     0.645     0.200
    86.483     1.187     0.200
    87.478     1.749     0.200
    89.229     3.376     0.200
    89.257     3.543     0.200
    90.307     0.243     0.200
    90.400    -0.291     0.200
    90.466     0.201     0.200
    90.689     0.763     0.200
    18.433    -2.718     0.200
    19.261    -3.981     0.200
    20.062    -2.499     0.200
    21.429    -2.740     0.200
    24.421    -0.152     0.200
    27.593    -2.412     0.200
    28.100    -1.331     0.200
    31.058     1.477     0.200
    32.020    -0.973     0.200
    32.092     0.393     0.200
    32.820    -1.982     0.200
    33.269     1.501     0.200
    33.289     1.926     0.200
    38.516    -1.380     0.200
    38.526    -0.470     0.200
    38.809    -4.735     0.200
    42.691    -2.214     0.200
    42.664    -0.492     0.200
    43.734     0.379     0.200
    43.874    -0.347     0.200
    44.166    -0.388     0.200
    44.287    -0.055     0.200
    44.684    -0.918     0.200
    44.665    -0.766     0.200
    45.090     0.251     0.200
    46.422     0.051     0.200
    46.931    -0.932     0.200
    47.704    -0.935     0.200
    47.588     1.964     0.200
    47.637     2.081     0.200
    48.482    -0.944     0.200
    48.846    -0.737     0.200
    48.900     2.853     0.200
    49.274    -1.512     0.200
    49.110     2.943     0.200
    51.257     0.002     0.200
    51.930    -1.017     0.200
    53.074    -0.479     0.200
    53.143    -0.987     0.200
    53.346    -0.477     0.200
    53.787    -0.708     0.200
    53.941     0.866     0.200
    54.040    -1.356     0.200
    54.359    -0.872     0.200
    54.728     0.446     0.200
    55.092    -1.178     0.200
    54.988     2.073     0.200
    55.189    -1.080     0.200
    55.901     0.812     0.200
    57.254    -1.596     0.200
    58.310    -3.001     0.200
    58.559     1.265     0.200
    58.424     0.204     0.200
    58.784     0.098     0.200
    59.180     0.959     0.200
    59.440    -0.833     0.200
    60.506    -1.741     0.200
    60.615    -1.684     0.200
    61.058    -1.291     0.200
    61.947    -1.883     0.200
    62.059    -0.634     0.200
    62.225    -1.548     0.200
    62.130     2.189     0.200
    62.215    -0.181     0.200
    62.220     0.289     0.200
    62.397     0.203     0.200
    62.418     0.062     0.200
    62.700     0.085     0.200
    62.826     0.246     0.200
    63.019     1.463     0.200
    63.635    -0.108     0.200
    63.992    -0.457     0.200
    64.177    -1.669     0.200
    64.289     0.095     0.200
    64.493    -0.739     0.200
    64.641    -0.203     0.200
    64.883    -1.773     0.200
    64.890     0.781     0.200
    65.776    -1.253     0.200
    65.713     1.357     0.200
    66.163     1.463     0.200
    66.427     1.971     0.200
    67.033    -0.584     0.200
    67.194     1.696     0.200
    67.887     1.026     0.200
    67.973    -0.513     0.200
    68.110    -1.174     0.200
    68.143    -1.081     0.200
    68.295     0.364     0.200
    68.382     1.421     0.200
    68.423     0.064     0.200
    68.316     0.838     0.200
    68.575     1.917     0.200
    68.656    -1.387     0.200
    68.551     1.368     0.200
    68.765    -0.962     0.200
    68.816    -0.281     0.200
    69.136     1.734     0.200
    69.694    -1.712     0.200
    69.700     1.252     0.200
    70.091     1.355     0.200
    70.492     1.304     0.200
    71.308     0.757     0.200
    71.311    -2.163     0.200
    71.478    -0.071     0.200
    71.594     1.235     0.200
    71.874    -0.149     0.200
    71.829     1.823     0.200
    71.979     1.621     0.200
    72.124     0.756     0.200
    72.113     0.619     0.200
    72.378    -0.357     0.200
    72.440    -0.330     0.200
    73.662    -0.546     0.200
    73.707    -1.811     0.200
    75.278    -0.925     0.200
    75.353     1.146     0.200
    75.316     0.856     0.200
    76.001    -0.053     0.200
    76.598     3.561     0.200
    76.397     1.796     0.200
    76.739     0.768     0.200
    77.010    -0.659     0.200
    77.012    -0.372     0.200
    77.142     1.501     0.200
    77.496     0.323     0.200
    77.647    -0.321     0.200
    77.638    -2.271     0.200
    77.770    -0.006     0.200
    77.475     3.339     0.200
    77.898     0.081     0.200
    77.919     0.965     0.200
    78.059    -0.612     0.200
    77.785     0.908     0.200
    78.166    -0.400     0.200
    78.482    -0.148     0.200
    78.559    -0.370     0.200
    78.586    -0.221     0.200
    78.438     1.296     0.200
    78.718    -0.245     0.200
    78.785     0.085     0.200
    78.817    -0.287     0.200
    78.865     0.949     0.200
    78.988    -0.026     0.200
    79.325     0.034     0.200
    79.343    -0.665     0.200
    79.390     1.082     0.200
    79.806     0.824     0.200
    79.976     0.502     0.200
    79.969    -0.062     0.200
    80.475     1.718     0.200
    80.676    -0.860     0.200
    80.747     0.367     0.200
    80.798     0.493     0.200
    80.878     0.367     0.200
    80.897     0.465     0.200
    80.919    -0.553     0.200
    81.143    -0.445     0.200
    81.207     0.513     0.200
    81.224    -0.376     0.200
    81.261    -1.368     0.200
    81.451    -0.173     0.200
    81.479    -0.321     0.200
    81.477     0.386     0.200
    81.609    -0.011     0.200
    81.655    -0.051     0.200
    81.766    -0.339     0.200
    81.870    -2.182     0.200
    82.029    -0.322     0.200
    82.069    -1.230     0.200
    82.143    -0.417     0.200
    82.150    -0.650     0.200
    82.321     0.455     0.200
    82.637    -1.190     0.200
    82.676    -0.394     0.200
    82.889    -1.898     0.200
    83.635    -0.541     0.200
    83.684    -0.592     0.200
    83.732    -0.735     0.200
    83.843    -0.602     0.200
    83.934    -0.366     0.200
    84.131    -0.369     0.200
    84.144     0.065     0.200
    84.075     1.415     0.200
    84.396     0.788     0.200
    84.505     0.037     0.200
    84.628     1.414     0.200
    85.041    -0.260     0.200
    85.297    -0.236     0.200
    85.213     0.581     0.200
    85.514     0.379     0.200
    85.593    -0.210     0.200
    85.674     0.784     0.200
    85.827    -0.671     0.200
    85.835    -0.711     0.200
    86.047    -0.257     0.200
    86.095    -0.493     0.200
    86.137     0.296     0.200
    86.196     0.809     0.200
    86.245     1.167     0.200
    86.604     0.308     0.200
    86.715     0.564     0.200
    86.796     0.468     0.200
    86.764     0.025     0.200
    87.028     0.134     0.200
    87.722     2.396     0.200
    88.900     2.434     0.200
    89.491     1.563     0.200
    89.478     5.124     0.200
    92.804     0.187     0.200
    19.658    -0.878     0.200
    21.473    -4.478     0.200
    21.463    -4.167     0.200
    28.547    -0.600     0.200
    38.947    -1.174     0.200
    43.131    -1.446     0.200
    47.382    -0.107     0.200
    53.540    -0.956     0.200
    54.243    -0.688     0.200
    62.342     1.827     0.200
    66.099    -1.763     0.200
    69.564     1.463     0.200
    69.993    -1.073     0.200
    18.488    -2.900     0.200
    20.474    -1.544     0.200
    21.488    -3.546     0.200
    24.194    -4.124     0.200
    28.010    -0.865     0.200
    28.524    -0.537     0.200
    30.000    -0.717     0.200
    32.775    -2.122     0.200
    38.421     0.084     0.200
    38.928    -1.264     0.200
    39.125    -4.607     0.200
    43.111    -1.232     0.200
    43.725     0.420     0.200
    44.052     0.298     0.200
    44.073     1.130     0.200
    44.174     0.423     0.200
    45.057    -0.707     0.200
    46.852     0.161     0.200
    47.640     2.635     0.200
    49.276    -1.540     0.200
    51.688     0.066     0.200
    52.714    -0.343     0.200
    53.503    -1.145     0.200
    53.528    -0.729     0.200
    53.777    -0.151     0.200
    53.891    -0.881     0.200
    54.209    -0.303     0.200
    54.470    -0.198     0.200
    54.781    -1.951     0.200
    55.159    -0.178     0.200
    55.620    -0.592     0.200
    55.764     0.979     0.200
    55.860    -1.212     0.200
    58.692     0.625     0.200
    59.163    -1.433     0.200
    59.836    -0.271     0.200
    60.801    -1.657     0.200
    60.842    -0.439     0.200
    61.330    -1.342     0.200
    62.229    -1.886     0.200
    62.330     0.442     0.200
    62.486     0.497     0.200
    62.340     0.579     0.200
    62.536    -1.337     0.200
    62.639     2.180     0.200
    63.088     0.202     0.200
    63.997    -1.999     0.200
    64.489     0.280     0.200
    64.856    -1.313     0.200
    65.182    -2.022     0.200
    65.268     0.718     0.200
    65.520     1.094     0.200
    66.098    -1.625     0.200
    66.084     1.465     0.200
    68.104     0.957     0.200
    68.656     0.211     0.200
    68.849     0.308     0.200
    68.966    -1.817     0.200
    68.999    -0.123     0.200
    69.994    -1.558     0.200
    70.119     0.176     0.200
    71.279    -0.873     0.200
    71.461    -0.967     0.200
    71.591     1.646     0.200
    72.210     0.934     0.200
    74.234     0.506     0.200
    75.294     1.087     0.200
    75.626    -0.416     0.200
    75.952     0.725     0.200
    76.474     1.762     0.200
    77.337     0.010     0.200
    77.342    -0.723     0.200
    77.830    -0.239     0.200
    78.384    -0.408     0.200
    78.752    -0.328     0.200
    78.893    -0.207     0.200
    78.894    -0.712     0.200
    79.315     0.093     0.200
    80.313     0.089     0.200
    80.249     1.933     0.200
    80.633    -1.127     0.200
    81.170     0.716     0.200
    81.210    -0.097     0.200
    81.534    -0.210     0.200
    81.731     0.550     0.200
    81.798    -0.302     0.200
    81.895    -0.812     0.200
    82.140    -1.197     0.200
    82.195    -1.383     0.200
    82.463    -0.781     0.200
    82.467    -0.704     0.200
    82.740    -0.222     0.200
    83.742    -0.882     0.200
    83.947    -0.635     0.200
    83.979    -0.887     0.200
    84.156    -0.790     0.200
    84.245    -0.648     0.200
    84.425    -0.558     0.200
    84.498    -0.427     0.200
    84.533    -0.300     0.200
    84.799    -0.343     0.200
    85.292     0.292     0.200
    85.350    -0.202     0.200
    85.414     1.284     0.200
    85.604    -0.056     0.200
    85.815    -0.010     0.200
    86.425    -0.607     0.200
    86.447     0.081     0.200
    86.602     0.617     0.200
    87.023     0.371     0.200
    87.106     0.264     0.200
    18.499    -2.701     0.200
    19.603    -3.575     0.200
    20.415    -3.083     0.200
    21.460    -3.524     0.200
    21.498    -3.734     0.200
    27.960    -1.389     0.200
    28.472    -0.539     0.200
    30.378    -3.719     0.200
    31.283    -0.204     0.200
    32.153     0.156     0.200
    32.799    -2.496     0.200
    38.264     1.648     0.200
    38.880    -1.416     0.200
    39.096    -4.823     0.200
    40.439    -1.074     0.200
    44.085     0.480     0.200
    44.017     1.621     0.200
    45.027     1.569     0.200
    45.151     1.686     0.200
    47.302     0.507     0.200
    47.621     2.726     0.200
    47.920    -1.686     0.200
    49.231    -0.353     0.200
    49.221    -0.479     0.200
    51.032     4.020     0.200
    51.229    -1.459     0.200
    51.205     2.721     0.200
    51.632    -0.373     0.200
    52.273    -0.238     0.200
    52.655    -0.761     0.200
    53.448    -0.401     0.200
    53.486    -1.374     0.200
    53.568     2.825     0.200
    53.835    -0.832     0.200
    54.150    -0.526     0.200
    54.412     0.068     0.200
    54.734    -1.160     0.200
    54.923    -1.626     0.200
    55.104    -0.330     0.200
    55.563    -1.231     0.200
    55.715     1.281     0.200
    55.773    -0.540     0.200
    55.848    -1.778     0.200
    56.943    -1.459     0.200
    56.931     1.519     0.200
    57.281     1.350     0.200
    58.587    -1.397     0.200
    58.722     0.866     0.200
    59.139    -1.224     0.200
    59.776     0.188     0.200
    60.787    -1.713     0.200
    60.776    -1.336     0.200
    60.784     0.201     0.200
    61.309    -1.646     0.200
    61.509     2.400     0.200
    62.007     1.356     0.200
    62.206    -1.480     0.200
    62.321     0.648     0.200
    62.433     0.904     0.200
    62.509    -1.101     0.200
    62.590     0.157     0.200
    62.580     0.224     0.200
    63.029     0.342     0.200
    63.199     0.616     0.200
    63.607     0.419     0.200
    63.920     2.360     0.200
    64.527     0.388     0.200
    64.665    -1.512     0.200
    64.819     0.286     0.200
    65.156    -1.706     0.200
    65.534    -4.846     0.200
    65.561     0.676     0.200
    66.068    -0.884     0.200
    66.076     1.369     0.200
    66.990     1.839     0.200
    67.209    -0.455     0.200
    68.145     0.951     0.200
    68.260    -0.465     0.200
    68.688     0.063     0.200
    68.938    -1.590     0.200
    68.917     0.638     0.200
    69.183    -0.209     0.200
    69.467     2.038     0.200
    69.498    -0.153     0.200
    69.880     1.197     0.200
    69.779     4.116     0.200
    69.896     1.399     0.200
    69.968    -1.546     0.200
    70.069     0.339     0.200
    70.301     2.018     0.200
    70.494    -0.260     0.200
    71.224     0.315     0.200
    71.474    -0.493     0.200
    71.499     0.852     0.200
    71.638     1.821     0.200
    71.778     1.978     0.200
    71.850    -0.457     0.200
    72.131    -1.137     0.200
    72.215     0.865     0.200
    72.749     2.290     0.200
    73.029     1.231     0.200
    73.141     1.066     0.200
    73.569     1.351     0.200
    73.699     1.587     0.200
    73.866    -0.890     0.200
    73.946    -0.655     0.200
    74.189     0.427     0.200
    75.249     1.398     0.200
    75.498    -0.828     0.200
    75.591    -0.364     0.200
    75.674    -0.834     0.200
    76.129     2.471     0.200
    76.334    -0.592     0.200
    76.535    -0.625     0.200
    76.523     2.338     0.200
    76.931     1.043     0.200
    77.307    -0.565     0.200
    77.311    -0.591     0.200
    77.301     2.866     0.200
    77.551     2.169     0.200
    77.599     2.300     0.200
    77.798    -0.306     0.200
    77.964     0.374     0.200
    78.210     0.909     0.200
    78.354    -0.885     0.200
    78.476    -0.955     0.200
    78.531    -0.163     0.200
    78.731    -0.261     0.200
    78.840     0.442     0.200
    78.861     0.325     0.200
    78.867    -0.406     0.200
    78.866    -0.203     0.200
    79.118     0.122     0.200
    79.230     1.309     0.200
    79.284     0.515     0.200
    79.398    -1.607     0.200
    79.390     1.439     0.200
    79.632    -0.378     0.200
    80.281     0.319     0.200
    80.295     2.045     0.200
    80.527    -0.204     0.200
    80.610    -0.148     0.200
    80.988    -0.962     0.200
    81.083    -0.065     0.200
    81.131     0.477     0.200
    81.216    -1.175     0.200
    81.249     0.951     0.200
    81.699     0.176     0.200
    81.741    -0.645     0.200
    81.769    -0.690     0.200
    81.861    -0.277     0.200
    81.872    -1.231     0.200
    81.977    -0.888     0.200
    82.100     1.269     0.200
    82.164    -0.867     0.200
    82.360    -0.889     0.200
    82.433    -0.873     0.200
    82.438    -0.797     0.200
    82.689     0.397     0.200
    82.940    -0.604     0.200
    83.049    -2.968     0.200
    83.919    -0.932     0.200
    83.954    -1.004     0.200
    83.970    -1.189     0.200
    84.003    -0.958     0.200
    84.128    -0.891     0.200
    84.217    -0.844     0.200
    84.400    -0.973     0.200
    84.470    -0.325     0.200
    84.505    -0.403     0.200
    84.519     2.130     0.200
    84.741    -0.589     0.200
    84.774    -0.360     0.200
    84.779     1.317     0.200
    84.966    -0.220     0.200
    85.055    -1.164     0.200
    84.999     4.112     0.200
    85.264    -0.013     0.200
    85.455     0.441     0.200
    85.577    -0.368     0.200
    85.656     0.842     0.200
    85.789    -0.121     0.200
    86.126    -1.284     0.200
    86.394    -0.799     0.200
    86.494     0.406     0.200
    86.574     0.316     0.200
    86.749     0.064     0.200
    86.996     0.260     0.200
    87.040    -0.058     0.200
    87.079     0.256     0.200
    87.449     1.568     0.200
    87.621     0.943     0.200
    88.297     0.538     0.200
    88.642     0.411     0.200
    88.828    -0.265     0.200
    93.080     0.781     0.200
    40.762     0.497     0.200
    42.909    -0.451     0.200
    43.276     0.478     0.200
    44.060     0.169     0.200
    44.303    -0.475     0.200
    44.303    -0.276     0.200
    51.151    -1.581     0.200
    57.184    -1.541     0.200
    58.888     0.019     0.200
    62.562    -0.690     0.200
    65.305    -1.531     0.200
    67.725     0.000     0.200
    68.540     0.385     0.200
    68.891    -0.303     0.200
    68.923    -0.499     0.200
    69.251    -1.137     0.200
    69.277    -1.396     0.200
    70.802     1.049     0.200
    71.333    -2.270     0.200
    72.556    -0.605     0.200
    73.498     1.222     0.200
    77.089     0.778     0.200
    15.022     5.572     0.200
    20.412    -2.873     0.200
    21.439    -3.532     0.200
    21.478    -3.244     0.200
    24.821    -0.331     0.200
    27.947    -1.194     0.200
    27.990    -0.880     0.200
    28.459    -0.554     0.200
    28.459    -0.656     0.200
    29.935    -0.140     0.200
    30.356    -3.860     0.200
    30.891     0.425     0.200
    31.292     2.892     0.200
    32.781    -2.166     0.200
    33.682    -1.017     0.200
    37.303     0.926     0.200
    38.865    -1.224     0.200
    39.076    -4.384     0.200
    41.605    -0.386     0.200
    43.047    -1.200     0.200
    43.747    -0.742     0.200
    44.069     0.179     0.200
    44.069    -0.025     0.200
    44.997    -0.218     0.200
    45.032     0.299     0.200
    45.158     0.708     0.200
    47.291    -0.236     0.200
    47.295    -0.273     0.200
    47.640     2.552     0.200
    47.899    -1.952     0.200
    49.210    -0.226     0.200
    49.214    -0.549     0.200
    51.210    -1.439     0.200
    51.214     1.828     0.200
    51.622     0.176     0.200
    52.256     0.060     0.200
    53.028    -0.039     0.200
    53.437    -0.646     0.200
    53.469    -0.176     0.200
    53.579     2.315     0.200
    53.825    -0.882     0.200
    54.145    -0.612     0.200
    54.724    -1.813     0.200
    54.902    -1.303     0.200
    55.724     1.183     0.200
    55.762    -0.887     0.200
    55.827    -1.157     0.200
    56.934    -1.325     0.200
    58.706     0.458     0.200
    58.766    -0.662     0.200
    59.119    -1.211     0.200
    59.775     0.071     0.200
    60.755    -1.428     0.200
    60.755    -1.327     0.200
    61.288    -1.334     0.200
    62.186    -1.674     0.200
    62.421     0.354     0.200
    62.489    -1.393     0.200
    62.579    -0.597     0.200
    62.582    -0.616     0.200
    63.029    -0.586     0.200
    63.594     1.175     0.200
    63.942    -0.611     0.200
    64.460    -1.006     0.200
    64.512     0.655     0.200
    64.801    -1.225     0.200
    65.136    -2.106     0.200
    65.211     0.114     0.200
    65.549     0.931     0.200
    66.048    -2.285     0.200
    67.188    -1.047     0.200
    67.384     0.211     0.200
    68.132     0.005     0.200
    68.494     0.242     0.200
    68.810    -0.722     0.200
    68.905     0.687     0.200
    68.918    -1.794     0.200
    68.934    -0.696     0.200
    69.169    -0.552     0.200
    69.948    -1.352     0.200
    69.955    -1.493     0.200
    70.055     0.594     0.200
    70.087    -2.302     0.200
    71.213    -0.450     0.200
    71.454    -1.901     0.200
    71.478     0.554     0.200
    71.558    -0.926     0.200
    71.838    -0.209     0.200
    72.111    -0.842     0.200
    72.529     0.667     0.200
    73.017     1.169     0.200
    74.173     1.788     0.200
    75.572    -0.084     0.200
    75.655    -0.556     0.200
    75.898     0.058     0.200
    76.317    -0.320     0.200
    76.317     0.680     0.200
    76.516    -0.950     0.200
    77.287    -0.682     0.200
    77.292    -0.607     0.200
    77.754     0.109     0.200
    77.779    -0.527     0.200
    77.804    -0.466     0.200
    77.862    -0.487     0.200
    77.960    -0.329     0.200
    78.129    -0.470     0.200
    78.207    -0.195     0.200
    78.312    -0.281     0.200
    78.334     0.395     0.200
    78.512    -0.286     0.200
    78.636    -1.269     0.200
    78.710    -0.275     0.200
    78.736    -0.316     0.200
    78.758    -0.937     0.200
    78.821     0.116     0.200
    78.842     0.001     0.200
    78.847    -0.128     0.200
    79.115     0.109     0.200
    79.264     0.293     0.200
    79.380     0.164     0.200
    79.613    -0.603     0.200
    79.729    -0.933     0.200
    79.806    -0.750     0.200
    80.261     0.192     0.200
    80.296    -1.188     0.200
    80.298     0.301     0.200
    80.283     0.778     0.200
    80.508    -0.131     0.200
    80.590    -0.866     0.200
    80.618    -0.518     0.200
    80.897    -0.403     0.200
    80.969    -0.889     0.200
    81.066    -0.105     0.200
    81.196    -0.697     0.200
    81.233     0.310     0.200
    81.243    -0.640     0.200
    81.347    -0.397     0.200
    81.494    -0.376     0.200
    81.680    -0.050     0.200
    81.721    -0.869     0.200
    81.749    -0.414     0.200
    81.851    -0.553     0.200
    81.958    -0.713     0.200
    82.083    -1.666     0.200
    82.145    -1.593     0.200
    82.340    -0.911     0.200
    82.413    -0.699     0.200
    82.418    -0.725     0.200
    83.692    -1.597     0.200
    83.899    -0.658     0.200
    83.933    -0.729     0.200
    83.983    -0.878     0.200
    84.108    -0.821     0.200
    84.197    -0.673     0.200
    84.380    -0.495     0.200
    84.450    -0.552     0.200
    84.485    -0.334     0.200
    84.754    -0.282     0.200
    85.035    -1.395     0.200
    85.244     0.263     0.200
    85.288    -2.956     0.200
    85.303    -0.029     0.200
    85.402    -0.122     0.200
    85.557     0.005     0.200
    85.769     0.054     0.200
    86.106    -0.715     0.200
    86.326    -0.395     0.200
    86.374    -0.633     0.200
    86.399     0.141     0.200
    86.554     0.585     0.200
    86.975     0.428     0.200
    87.059     0.525     0.200
    88.623     0.176     0.200
    88.808    -0.199     0.200
    90.234     1.132     0.200
    93.060     0.046     0.200
    14.980     8.191     0.200
    18.464    -3.574     0.200
    18.464    -3.175     0.200
    19.631    -1.336     0.200
    19.631    -1.133     0.200
    20.478    -3.021     0.200
    20.816    -2.168     0.200
    21.060    -2.698     0.200
    21.458    -4.665     0.200
    21.464    -3.325     0.200
    21.855    -2.702     0.200
    24.178    -3.407     0.200
    24.178    -3.110     0.200
    25.883    -0.390     0.200
    28.001    -1.904     0.200
    28.001    -1.107     0.200
    28.057    -0.402     0.200
    28.516    -0.887     0.200
    29.991    -0.159     0.200
    30.957     0.409     0.200
    32.732    -0.065     0.200
    32.751    -1.836     0.200
    33.385    -0.762     0.200
    33.746     0.292     0.200
    37.368     0.947     0.200
    38.918    -0.993     0.200
    40.005    -0.345     0.200
    43.102    -0.972     0.200
    43.357     2.674     0.200
    44.030     0.562     0.200
    44.085     1.120     0.200
    44.085     0.620     0.200
    45.064    -0.675     0.200
    45.219     1.295     0.200
    49.180    -0.724     0.200
    49.270    -1.408     0.200
    49.270    -1.111     0.200
    51.188    -0.912     0.200
    51.682    -0.205     0.200
    52.301    -0.204     0.200
    53.514    -1.740     0.200
    54.211    -0.723     0.200
    55.154    -0.350     0.200
    55.781     0.948     0.200
    55.838    -1.061     0.200
    56.996    -1.097     0.200
    57.261    -2.069     0.200
    57.332    -0.861     0.200
    59.142    -0.996     0.200
    59.842    -0.019     0.200
    60.781    -1.030     0.200
    60.781    -1.429     0.200
    62.209    -1.758     0.200
    62.363     0.518     0.200
    62.364     0.806     0.200
    62.517    -2.116     0.200
    62.640    -0.936     0.200
    62.640    -0.733     0.200
    63.095     0.247     0.200
    66.079    -1.411     0.200
    68.177     1.594     0.200
    68.548    -1.021     0.200
    68.633     0.446     0.200
    68.778    -1.451     0.200
    68.946    -1.399     0.200
    69.535     1.065     0.200
    69.582    -1.474     0.200
    69.815    -1.388     0.200
    69.975    -1.443     0.200
    69.979    -0.871     0.200
    70.280    -1.595     0.200
    70.237     2.257     0.200
    71.436    -1.725     0.200
    72.472     1.076     0.200
    75.609    -1.220     0.200
    75.609    -0.619     0.200
    76.454    -0.327     0.200
    77.319    -1.188     0.200
    77.324    -0.922     0.200
    77.812     0.357     0.200
    78.731    -0.817     0.200
    78.875    -0.111     0.200
    78.875    -0.508     0.200
    79.131    -0.308     0.200
    79.296     0.190     0.200
    80.215    -0.286     0.200
    81.713     0.040     0.200
    81.779    -0.503     0.200
    82.125    -1.214     0.200
    82.448    -0.709     0.200
    83.928    -0.836     0.200
    83.958    -0.685     0.200
    84.008    -0.844     0.200
    84.137    -0.897     0.200
    84.162    -0.721     0.200
    84.226    -0.747     0.200
    84.405    -0.052     0.200
    84.479    -0.629     0.200
    84.514    -0.603     0.200
    84.779    -0.440     0.200
    85.273     0.285     0.200
    85.331    -0.200     0.200
    85.584    -0.164     0.200
    85.795    -0.109     0.200
    86.358    -0.281     0.200
    86.407    -0.621     0.200
    86.428     0.073     0.200
    86.544    -1.793     0.200
    86.583     0.812     0.200
    87.003     0.566     0.200
    87.087     0.458     0.200
    88.652     0.813     0.200
    88.837     0.941     0.200
    18.619    -4.126     0.200
    18.619    -3.626     0.200
    21.381    -0.216     0.200
    21.381     0.583     0.200
    21.614    -2.717     0.200
    21.614    -1.817     0.200
    28.158    -2.004     0.200
    28.158    -1.404     0.200
    42.758    -1.143     0.200
    42.758    -0.643     0.200
    43.638     1.336     0.200
    44.337     0.125     0.200
    44.785     0.847     0.200
    51.382    -0.483     0.200
    52.033    -0.349     0.200
    53.246    -0.533     0.200
    54.986    -1.032     0.200
    60.656    -0.868     0.200
    62.232    -0.227     0.200
    62.233     0.365     0.200
    62.369    -1.444     0.200
    65.916    -0.839     0.200
    68.801    -1.512     0.200
    69.216     1.510     0.200
    69.451    -1.298     0.200
    69.843    -1.264     0.200
    69.860    -0.569     0.200
    70.151    -1.407     0.200
    70.633     1.496     0.200
    73.450     1.006     0.200
    76.269    -0.505     0.200
    77.148    -0.471     0.200
    78.693    -0.064     0.200
    80.620     1.464     0.200
    83.779    -0.995     0.200
    83.986    -1.054     0.200
    84.017    -0.911     0.200
    84.078    -0.920     0.200
    84.327    -0.492     0.200
    84.365    -0.284     0.200
    85.126     0.083     0.200
    85.186    -0.419     0.200
    86.434     0.592     0.200
    86.860     0.300     0.200
    86.941     0.208     0.200
    19.605    -4.130     0.200
    20.459    -2.391     0.200
    21.435    -3.596     0.200
    21.449    -2.341     0.200
    24.152    -4.248     0.200
    24.152    -3.951     0.200
    28.040     1.167     0.200
    28.491    -0.944     0.200
    28.552    -1.286     0.200
    29.965    -1.114     0.200
    32.710     0.442     0.200
    32.742    -2.235     0.200
    33.369    -0.700     0.200
    33.734    -0.076     0.200
    37.354     0.482     0.200
    38.892    -1.856     0.200
    39.981    -0.319     0.200
    43.076    -1.844     0.200
    43.076    -1.446     0.200
    44.025    -0.479     0.200
    44.074     1.135     0.200
    44.074     1.237     0.200
    45.210     2.881     0.200
    47.331    -1.354     0.200
    49.173    -0.746     0.200
    51.176    -1.399     0.200
    51.658    -1.501     0.200
    51.658    -0.704     0.200
    52.275    -0.690     0.200
    53.488    -1.025     0.200
    53.488    -0.627     0.200
    54.190    -1.353     0.200
    55.130    -1.957     0.200
    55.130    -1.356     0.200
    55.122     1.597     0.200
    55.775     0.410     0.200
    57.248    -2.055     0.200
    59.825     0.021     0.200
    60.756    -1.342     0.200
    62.492    -1.029     0.200
    62.378     0.236     0.200
    62.379     0.829     0.200
    62.625     1.085     0.200
    63.079     0.371     0.200
    64.006    -1.745     0.200
    64.814    -1.525     0.200
    65.138    -1.923     0.200
    65.500     1.236     0.200
    66.054    -1.329     0.200
    67.337     0.499     0.200
    68.522     0.061     0.200
    68.628     0.399     0.200
    68.922    -1.925     0.200
    69.028    -1.084     0.200
    69.198    -0.134     0.200
    69.509     0.943     0.200
    69.557    -1.628     0.200
    69.791    -1.691     0.200
    69.950    -1.566     0.200
    70.240    -3.147     0.200
    71.576     1.455     0.200
    72.477     0.964     0.200
    73.080     0.995     0.200
    75.583    -0.253     0.200
    76.429    -0.168     0.200
    77.299    -0.562     0.200
    77.787    -0.580     0.200
    77.787    -0.181     0.200
    78.518    -0.830     0.200
    78.850     0.348     0.200
    78.850     0.449     0.200
    79.106    -0.053     0.200
    79.251     0.359     0.200
    80.233     1.039     0.200
    81.082    -0.296     0.200
    81.129     0.752     0.200
    81.688    -0.404     0.200
    81.754    -0.152     0.200
    82.099    -0.562     0.200
    82.462    -0.758     0.200
    83.903    -0.686     0.200
    84.112    -0.646     0.200
    84.201    -0.598     0.200
    84.380    -0.109     0.200
    84.454    -0.378     0.200
    84.489    -0.260     0.200
    84.755    -0.099     0.200
    85.248     0.135     0.200
    85.560    -0.120     0.200
    86.333    -0.336     0.200
    86.381    -0.372     0.200
    86.558     0.855     0.200
    86.979     0.710     0.200
    87.062     0.601     0.200
    18.663    -2.565     0.200
    19.410    -1.751     0.200
    19.410    -1.352     0.200
    20.373     0.256     0.200
    21.431    -4.668     0.200
    21.431    -3.872     0.200
    21.658    -3.112     0.200
    21.658    -2.714     0.200
    23.982    -3.978     0.200
    23.982    -3.580     0.200
    28.193    -1.024     0.200
    28.193    -0.321     0.200
    30.405    -2.646     0.200
    32.317    -0.484     0.200
    33.038    -1.794     0.200
    33.294    -1.632     0.200
    36.902     0.892     0.200
    39.637     0.871     0.200
    39.869    -2.064     0.200
    39.869    -1.267     0.200
    41.140     0.432     0.200
    41.899    -0.488     0.200
    42.794    -1.074     0.200
    42.794    -0.472     0.200
    42.844    -0.080     0.200
    42.918     2.216     0.200
    43.634     0.636     0.200
    43.634     0.339     0.200
    44.370     0.338     0.200
    44.370     0.034     0.200
    44.775     2.203     0.200
    46.486     1.469     0.200
    47.001    -1.162     0.200
    48.545    -1.531     0.200
    48.545    -1.133     0.200
    48.610     0.368     0.200
    49.488    -0.752     0.200
    51.323    -0.628     0.200
    52.076    -0.249     0.200
    53.289    -1.222     0.200
    53.791    -0.900     0.200
    54.791    -1.184     0.200
    55.353     0.463     0.200
    57.482    -1.806     0.200
    58.993    -0.072     0.200
    59.082    -1.382     0.200
    59.053    -0.387     0.200
    60.704    -1.530     0.200
    60.841    -1.956     0.200
    61.265    -0.936     0.200
    62.150    -1.500     0.200
    62.300    -2.503     0.200
    62.300    -1.902     0.200
    62.187    -0.646     0.200
    62.188    -0.256     0.200
    62.647    -0.423     0.200
    63.800    -0.464     0.200
    63.925    -1.589     0.200
    63.937     0.529     0.200
    64.263     2.194     0.200
    64.658    -1.090     0.200
    64.834    -0.443     0.200
    65.080    -1.438     0.200
    65.891     0.915     0.200
    67.347     1.122     0.200
    67.663     1.625     0.200
    68.253    -1.085     0.200
    68.849    -1.305     0.200
    68.970    -0.557     0.200
    69.078    -0.731     0.200
    69.254     0.280     0.200
    69.499    -0.830     0.200
    69.469     0.644     0.200
    69.735    -0.742     0.200
    69.891    -0.751     0.200
    69.908    -1.256     0.200
    69.912     1.022     0.200
    70.199    -0.861     0.200
    70.240     1.108     0.200
    70.652     1.592     0.200
    71.511    -1.508     0.200
    71.989     1.719     0.200
    72.900    -0.417     0.200
    73.474     0.793     0.200
    75.452    -0.303     0.200
    75.460     0.451     0.200
    75.774     0.856     0.200
    76.885     1.346     0.200
    77.195    -1.193     0.200
    77.677    -0.885     0.200
    78.689    -0.495     0.200
    78.740    -0.069     0.200
    78.780    -0.492     0.200
    80.255    -0.018     0.200
    80.640     0.910     0.200
    80.900     0.920     0.200
    83.827    -0.770     0.200
    84.034    -0.827     0.200
    84.126    -0.895     0.200
    84.375    -0.663     0.200
    84.413    -0.551     0.200
    85.174    -0.081     0.200
    85.490    -0.162     0.200
    85.777     0.914     0.200
    85.975     0.135     0.200
    86.135    -0.059     0.200
    86.482     0.734     0.200
    86.798    -0.614     0.200
    86.989     0.456     0.200
    87.720     0.928     0.200
    88.002    -0.120     0.200
    88.526     0.404     0.200
    88.564     0.227     0.200
    90.512     0.411     0.200
    90.722     0.627     0.200
    90.945    -0.503     0.200
    14.404     4.244     0.200
    17.354     3.224     0.200
    18.633    -2.097     0.200
    19.335    -2.793     0.200
    19.981    -2.846     0.200
    20.336    -2.014     0.200
    21.370    -3.681     0.200
    21.363    -2.606     0.200
    21.628    -2.850     0.200
    23.465    -3.140     0.200
    23.908    -4.201     0.200
    23.908    -3.801     0.200
    24.237    -0.704     0.200
    24.416    -0.140     0.200
    25.114     0.609     0.200
    25.387    -2.664     0.200
    26.193     0.032     0.200
    26.330     4.087     0.200
    27.152     2.386     0.200
    27.552    -2.302     0.200
    27.624    -1.849     0.200
    27.624    -1.449     0.200
    28.116    -0.847     0.200
    28.505    -1.209     0.200
    28.557    -0.170     0.200
    29.102    -0.614     0.200
    29.605    -0.775     0.200
    30.351    -5.076     0.200
    30.351    -4.576     0.200
    30.202     4.543     0.200
    30.863    -0.599     0.200
    30.887     2.196     0.200
    30.931     3.809     0.200
    31.824    -1.055     0.200
    32.249    -0.286     0.200
    32.880    -2.315     0.200
    33.025    -2.381     0.200
    33.071     1.117     0.200
    33.180     2.064     0.200
    33.910    -2.799     0.200
    34.469    -0.542     0.200
    35.150     4.178     0.200
    36.866     0.283     0.200
    36.862     0.321     0.200
    37.060    -0.862     0.200
    37.423    -0.043     0.200
    38.020    -0.487     0.200
    38.553    -1.279     0.200
    38.426     2.592     0.200
    38.705    -0.955     0.200
    38.931    -3.649     0.200
    39.563    -0.422     0.200
    39.793    -1.140     0.200
    40.127    -1.115     0.200
    40.793     0.276     0.200
    40.987     1.183     0.200
    41.083    -1.013     0.200
    41.895    -0.269     0.200
    42.718    -2.069     0.200
    42.856     1.009     0.200
    42.857    -0.197     0.200
    42.876     2.245     0.200
    43.590     0.079     0.200
    43.590     0.079     0.200
    43.525     0.098     0.200
    44.073    -0.400     0.200
    44.116    -0.146     0.200
    44.368     0.532     0.200
    44.368     0.403     0.200
    44.368     0.331     0.200
    44.559    -0.691     0.200
    44.603    -2.644     0.200
    44.466     1.348     0.200
    44.738     1.178     0.200
    45.398     1.034     0.200
    46.002     3.363     0.200
    46.064     3.374     0.200
    46.412     0.137     0.200
    46.596     2.292     0.200
    46.921    -0.356     0.200
    46.926    -0.393     0.200
    46.920     0.653     0.200
    47.185     1.087     0.200
    47.242     0.643     0.200
    47.434     2.151     0.200
    47.863    -2.184     0.200
    48.471     0.122     0.200
    48.617     0.300     0.200
    48.843    -0.938     0.200
    49.027     1.846     0.200
    49.299     1.767     0.200
    49.479    -0.904     0.200
    50.809     1.311     0.200
    51.248    -0.590     0.200
    51.298     1.636     0.200
    51.453     0.977     0.200
    51.605     1.343     0.200
    52.001    -0.613     0.200
    52.008     1.632     0.200
    52.631     0.907     0.200
    53.072    -1.047     0.200
    53.214    -0.793     0.200
    53.197     0.131     0.200
    53.447    -1.309     0.200
    53.447    -0.809     0.200
    53.465     2.562     0.200
    53.723    -1.331     0.200
    53.725     1.656     0.200
    54.343    -1.254     0.200
    54.717    -1.070     0.200
    54.927     0.409     0.200
    54.856     1.918     0.200
    55.325     0.131     0.200
    55.394    -1.460     0.200
    55.811    -0.658     0.200
    55.701    -0.172     0.200
    56.638     0.335     0.200
    56.843    -0.815     0.200
    56.942     0.480     0.200
    56.906     0.237     0.200
    57.455    -2.148     0.200
    58.438    -2.042     0.200
    58.438    -1.542     0.200
    59.017    -1.269     0.200
    58.988     0.036     0.200
    58.949    -0.092     0.200
    59.048    -0.280     0.200
    60.639    -1.516     0.200
    60.791    -2.051     0.200
    61.202    -1.643     0.200
    62.063    -0.348     0.200
    62.085    -1.801     0.200
    62.143    -0.690     0.200
    62.211    -0.646     0.200
    62.224    -1.930     0.200
    62.224    -1.230     0.200
    61.994     0.712     0.200
    61.994     2.312     0.200
    62.349    -1.369     0.200
    62.228     0.445     0.200
    62.222    -1.614     0.200
    62.223    -0.323     0.200
    62.590    -0.378     0.200
    62.688    -0.035     0.200
    62.837    -0.524     0.200
    63.726    -1.915     0.200
    63.857    -1.276     0.200
    63.983    -0.605     0.200
    63.951     0.606     0.200
    64.287    -1.604     0.200
    64.275    -0.524     0.200
    64.207     1.021     0.200
    64.282     2.032     0.200
    64.138     1.176     0.200
    64.584    -1.546     0.200
    64.840     0.188     0.200
    65.526     1.537     0.200
    65.895    -1.644     0.200
    65.905     0.192     0.200
    66.071     1.423     0.200
    66.176     3.147     0.200
    65.951    -0.405     0.200
    66.292    -0.595     0.200
    66.356     2.497     0.200
    66.387    -1.201     0.200
    66.749     1.486     0.200
    66.896    -0.450     0.200
    67.372     1.523     0.200
    67.719     0.132     0.200
    67.689     2.022     0.200
    67.896     2.218     0.200
    68.022    -0.573     0.200
    67.731     5.258     0.200
    68.177     0.457     0.200
    68.440    -0.595     0.200
    68.488     0.608     0.200
    68.400     2.859     0.200
    68.781    -1.723     0.200
    68.821    -0.573     0.200
    68.493     4.473     0.200
    68.846     0.073     0.200
    68.967    -0.280     0.200
    69.068    -0.702     0.200
    69.178     0.214     0.200
    69.045     0.039     0.200
    69.190     1.237     0.200
    69.568    -0.201     0.200
    69.571     0.784     0.200
    69.483     0.425     0.200
    69.726     0.825     0.200
    69.514     0.930     0.200
    69.742     0.726     0.200
    69.889     1.022     0.200
    69.925     0.701     0.200
    69.801     3.364     0.200
    69.953     0.427     0.200
    70.193    -1.040     0.200
    70.267     1.004     0.200
    70.368     0.887     0.200
    70.669    -0.950     0.200
    70.674     1.217     0.200
    70.837    -0.974     0.200
    71.248     1.535     0.200
    71.445    -1.455     0.200
    71.477     0.751     0.200
    71.492    -0.437     0.200
    72.015    -0.783     0.200
    71.909     2.853     0.200
    72.011     1.141     0.200
    72.341    -1.336     0.200
    72.854     1.915     0.200
    73.279     0.399     0.200
    73.377     1.221     0.200
    73.612    -1.561     0.200
    73.489     0.363     0.200
    73.785    -0.779     0.200
    73.802    -0.376     0.200
    73.886     0.630     0.200
    73.650     1.215     0.200
    73.964    -0.125     0.200
    74.079     0.703     0.200
    74.090     0.641     0.200
    74.839    -0.712     0.200
    75.039     3.133     0.200
    75.113     0.202     0.200
    75.380    -0.833     0.200
    75.448    -0.223     0.200
    75.469     0.456     0.200
    75.702     0.924     0.200
    75.913    -1.983     0.200
    76.083     1.151     0.200
    76.129    -2.415     0.200
    76.154     0.246     0.200
    76.245    -0.773     0.200
    76.290    -0.028     0.200
    76.290     0.672     0.200
    75.998    -0.864     0.200
    76.315    -1.070     0.200
    76.349    -3.365     0.200
    76.254     0.678     0.200
    76.445     0.095     0.200
    76.526     0.298     0.200
    76.681     2.757     0.200
    76.551     0.492     0.200
    76.794    -0.881     0.200
    76.876    -1.341     0.200
    77.035    -0.835     0.200
    76.830    -0.084     0.200
    76.803     0.568     0.200
    76.913     0.947     0.200
    77.126    -1.346     0.200
    77.230     0.667     0.200
    77.492    -0.898     0.200
    77.582    -0.304     0.200
    77.300     0.377     0.200
    77.606    -0.436     0.200
    77.656     0.283     0.200
    77.704     0.517     0.200
    77.727    -0.709     0.200
    77.752    -1.249     0.200
    77.793     0.522     0.200
    77.629     0.436     0.200
    77.881    -0.667     0.200
    78.001    -0.337     0.200
    78.047     3.107     0.200
    77.899     0.930     0.200
    78.098    -0.976     0.200
    78.113     0.144     0.200
    78.130    -0.953     0.200
    78.175    -0.903     0.200
    78.175    -1.103     0.200
    78.200    -0.438     0.200
    78.265    -0.101     0.200
    78.324    -0.427     0.200
    78.350    -0.671     0.200
    78.159     1.490     0.200
    78.234     0.375     0.200
    78.536    -0.598     0.200
    78.574    -0.305     0.200
    78.631     0.181     0.200
    78.627    -0.096     0.200
    78.669    -0.330     0.200
    78.712    -0.566     0.200
    78.852    -0.833     0.200
    78.928    -0.154     0.200
    78.987     0.023     0.200
    78.921    -0.815     0.200
    79.147     0.048     0.200
    79.161     0.972     0.200
    79.163    -0.538     0.200
    78.926     0.257     0.200
    79.319    -0.891     0.200
    79.444    -0.573     0.200
    79.467    -0.698     0.200
    79.564    -0.525     0.200
    79.366     1.754     0.200
    80.051    -0.866     0.200
    79.827     2.347     0.200
    80.153     0.583     0.200
    80.159    -1.148     0.200
    80.230    -0.830     0.200
    80.340    -0.326     0.200
    80.424    -0.475     0.200
    80.531    -0.651     0.200
    80.589    -0.858     0.200
    80.609    -0.867     0.200
    80.724     1.514     0.200
    80.780    -1.282     0.200
    80.784    -0.406     0.200
    80.815     0.730     0.200
    80.814     0.534     0.200
    80.658     1.327     0.200
    80.660     1.156     0.200
    80.826    -0.427     0.200
    80.865     0.165     0.200
    80.880     0.181     0.200
    80.918     2.478     0.200
    80.955     0.282     0.200
    80.997    -0.943     0.200
    81.063    -0.793     0.200
    81.151     0.038     0.200
    81.185     0.059     0.200
    81.279    -0.442     0.200
    81.323    -0.274     0.200
    81.365    -1.596     0.200
    81.365    -0.896     0.200
    81.508    -0.153     0.200
    81.561    -0.434     0.200
    81.598    -0.032     0.200
    81.710    -1.922     0.200
    81.774    -0.458     0.200
    81.790    -0.344     0.200
    81.848    -1.451     0.200
    81.940    -0.933     0.200
    81.986    -1.674     0.200
    82.114    -0.845     0.200
    82.213    -0.165     0.200
    82.263    -0.325     0.200
    82.270    -0.365     0.200
    82.291    -1.776     0.200
    82.288    -0.355     0.200
    82.320    -1.724     0.200
    82.709     0.044     0.200
    82.746    -0.647     0.200
    82.774    -1.093     0.200
    82.477     2.254     0.200
    82.911    -2.000     0.200
    83.385    -0.450     0.200
    83.532    -0.906     0.200
    83.546     0.721     0.200
    83.703    -1.084     0.200
    83.715    -1.345     0.200
    83.731     3.774     0.200
    83.735     0.753     0.200
    83.759    -0.371     0.200
    83.821     0.214     0.200
    83.864    -0.208     0.200
    83.893     3.345     0.200
    83.953    -0.061     0.200
    83.966    -0.329     0.200
    83.975     0.524     0.200
    84.028     0.254     0.200
    84.058     2.604     0.200
    84.058    -0.297     0.200
    84.242     0.164     0.200
    84.264     0.055     0.200
    84.346     0.136     0.200
    84.362    -1.242     0.200
    84.263     0.559     0.200
    84.430     1.213     0.200
    84.525    -0.770     0.200
    84.553    -1.812     0.200
    84.638     0.362     0.200
    84.726     0.715     0.200
    84.986     0.410     0.200
    84.884    -1.078     0.200
    84.761     1.538     0.200
    85.106     0.509     0.200
    85.166     0.006     0.200
    85.251     0.182     0.200
    85.423     0.024     0.200
    85.446     2.111     0.200
    85.619     2.250     0.200
    85.788     0.111     0.200
    85.943    -0.956     0.200
    85.962    -0.453     0.200
    85.679    -0.552     0.200
    85.793     2.386     0.200
    85.985     0.733     0.200
    86.160    -0.033     0.200
    86.208    -0.266     0.200
    85.923     2.738     0.200
    86.263     0.364     0.200
    86.145    -0.057     0.200
    86.197     0.586     0.200
    86.526     3.768     0.200
    86.745    -0.005     0.200
    86.769     2.079     0.200
    86.921     0.836     0.200
    86.803    -0.386     0.200
    86.857     0.051     0.200
    86.861     0.328     0.200
    87.144     0.150     0.200
    87.191     0.225     0.200
    87.232    -0.078     0.200
    87.238     0.097     0.200
    87.359     0.211     0.200
    87.212     1.423     0.200
    87.537    -0.650     0.200
    87.652    -0.202     0.200
    87.609     0.303     0.200
    87.669     0.218     0.200
    87.724     0.655     0.200
    87.738    -0.113     0.200
    87.592    -0.313     0.200
    87.851     0.253     0.200
    87.899     0.122     0.200
    87.982     0.226     0.200
    88.129     1.032     0.200
    87.986     1.710     0.200
    88.480     0.073     0.200
    88.545     0.366     0.200
    88.669     0.379     0.200
    88.928     0.362     0.200
    89.050     1.989     0.200
    89.002     0.815     0.200
    88.956     0.132     0.200
    89.452     0.903     0.200
    89.431     0.303     0.200
    89.319     1.425     0.200
    89.349     2.688     0.200
    89.662     0.322     0.200
    89.710     1.258     0.200
    89.923     0.600     0.200
    89.932     0.260     0.200
    90.107     1.742     0.200
    90.104     0.557     0.200
    90.331     0.196     0.200
    90.363     2.750     0.200
    90.582     0.527     0.200
    90.496     0.927     0.200
    90.619    -1.146     0.200
    90.310     1.797     0.200
    90.708     0.943     0.200
    90.714    -0.086     0.200
    90.922     0.047     0.200
    91.296     1.814     0.200
    92.933     0.644     0.200
    93.121    -0.222     0.200
    93.688     0.767     0.200
    94.078     4.673     0.200
    95.155     1.034     0.200
    95.234     1.277     0.200
    95.520     1.971     0.200
    95.923    -1.567     0.200
    96.091     3.669     0.200
    96.098     2.940     0.200
    96.468     2.456     0.200
    96.738     1.234     0.200
    96.617     4.782     0.200
    18.532    -1.230     0.200
    18.532    -0.530     0.200
    21.527    -0.813     0.200
    32.911    -1.805     0.200
    34.586    -0.163     0.200
    37.176    -0.558     0.200
    41.777     0.086     0.200
    44.250     0.073     0.200
    44.250     0.274     0.200
    57.352    -1.613     0.200
    60.597    -1.025     0.200
    61.152    -1.299     0.200
    62.319    -1.159     0.200
    62.686     0.791     0.200
    63.823    -1.543     0.200
    64.973    -1.970     0.200
    65.863    -1.831     0.200
    68.745    -1.786     0.200
    69.393    -1.267     0.200
    69.628    -1.178     0.200
    69.784    -1.224     0.200
    70.092    -1.335     0.200
    77.580    -0.476     0.200
    78.643    -0.471     0.200
    81.566    -0.344     0.200
    83.724    -0.774     0.200
    83.931    -0.934     0.200
    84.272    -0.371     0.200
    84.310    -0.362     0.200
    85.070     0.006     0.200
    85.386    -0.273     0.200
    85.604    -0.062     0.200
    86.378     0.612     0.200
    41.761    -0.180     0.200
    44.234     0.403     0.200
    44.234     0.503     0.200
    57.331    -1.165     0.200
    58.854     0.774     0.200
    58.914    -0.242     0.200
    60.575    -1.673     0.200
    61.130    -1.346     0.200
    62.018    -1.633     0.200
    62.339    -0.785     0.200
    62.340    -0.994     0.200
    63.802    -1.398     0.200
    64.952    -1.825     0.200
    65.842    -1.590     0.200
    69.371    -1.296     0.200
    69.606    -1.318     0.200
    69.763    -1.285     0.200
    69.792     1.041     0.200
    83.703    -0.854     0.200
    83.910    -0.814     0.200
    84.001    -0.979     0.200
    84.200    -0.793     0.200
    86.159    -0.896     0.200
    86.357     0.528     0.200
    86.911    -3.987     0.200
    18.594    -0.324     0.200
    19.335    -1.445     0.200
    20.382    -2.447     0.200
    20.594    -3.554     0.200
    21.349    -3.296     0.200
    21.589    -2.870     0.200
    21.589    -2.270     0.200
    23.906    -3.706     0.200
    23.906    -2.806     0.200
    28.130    -0.887     0.200
    30.325    -4.357     0.200
    32.981    -1.706     0.200
    39.583     2.220     0.200
    41.121     0.193     0.200
    41.849    -0.374     0.200
    43.633     0.560     0.200
    43.633     0.560     0.200
    44.069    -0.243     0.200
    44.322     0.229     0.200
    44.322     0.329     0.200
    49.434    -0.716     0.200
    53.215    -0.041     0.200
    57.415    -1.394     0.200
    59.000    -2.375     0.200
    58.942     0.328     0.200
    59.002    -0.389     0.200
    59.374     0.036     0.200
    60.623    -1.230     0.200
    61.183    -1.335     0.200
    62.336    -0.997     0.200
    62.258    -2.376     0.200
    62.260    -0.584     0.200
    63.845    -1.304     0.200
    63.904     0.506     0.200
    64.998    -1.751     0.200
    65.884    -1.376     0.200
    65.858     0.791     0.200
    68.186    -2.003     0.200
    68.768    -2.038     0.200
    68.921    -0.592     0.200
    69.023    -1.223     0.200
    69.418    -1.270     0.200
    69.654    -1.633     0.200
    69.810    -1.185     0.200
    70.118    -1.859     0.200
    70.627     1.311     0.200
    73.442     0.856     0.200
    77.115    -1.064     0.200
    77.597    -0.761     0.200
    77.597     0.040     0.200
    78.660     0.347     0.200
    80.613     1.739     0.200
    83.746    -0.867     0.200
    83.953    -0.726     0.200
    84.045    -0.992     0.200
    84.295    -0.462     0.200
    84.333    -0.455     0.200
    85.093     0.115     0.200
    86.401     0.528     0.200
    87.190    -0.327     0.200
    88.466     0.085     0.200
    88.502     0.015     0.200
    89.187     0.693     0.200
    90.453     0.681     0.200
    90.603    -0.118     0.200
    90.847    -0.053     0.200
    18.612    -0.054     0.200
    21.393    -1.301     0.200
    21.393    -0.501     0.200
    21.608    -1.606     0.200
    32.986    -2.308     0.200
    41.847    -0.316     0.200
    42.789    -1.985     0.200
    42.789    -1.286     0.200
    43.672     0.781     0.200
    43.672     0.881     0.200
    44.060    -0.033     0.200
    44.318     0.700     0.200
    44.318     0.100     0.200
    49.436    -0.297     0.200
    53.272    -1.034     0.200
    57.431    -1.979     0.200
    58.941     0.763     0.200
    60.672    -1.236     0.200
    62.387    -1.409     0.200
    62.676     0.161     0.200
    63.895    -1.416     0.200
    65.935    -1.284     0.200
    69.245    -0.178     0.200
    69.467    -1.162     0.200
    69.702    -1.093     0.200
    69.859    -1.166     0.200
    70.167    -1.267     0.200
    78.713    -0.527     0.200
    78.713    -0.027     0.200
    80.593     1.266     0.200
    83.797    -0.812     0.200
    84.004    -0.970     0.200
    84.095    -0.835     0.200
    84.345    -0.705     0.200
    84.383    -0.596     0.200
    85.143     0.077     0.200
    85.459    -0.303     0.200
    86.451     0.692     0.200
    86.958     0.613     0.200
    18.554    -1.199     0.200
    19.352    -2.954     0.200
    19.352    -2.653     0.200
    20.068    -2.770     0.200
    20.444    -2.055     0.200
    20.654    -3.325     0.200
    21.338    -4.709     0.200
    21.469    -1.914     0.200
    21.549    -1.777     0.200
    23.556    -3.529     0.200
    23.919    -4.244     0.200
    23.919    -4.045     0.200
    24.346    -0.143     0.200
    25.492    -1.363     0.200
    26.302     0.300     0.200
    27.664    -1.154     0.200
    27.664    -0.955     0.200
    27.648    -2.812     0.200
    28.164    -0.914     0.200
    29.648    -0.697     0.200
    30.305    -4.611     0.200
    30.305    -4.111     0.200
    30.548    -0.754     0.200
    30.972    -0.102     0.200
    30.996     3.292     0.200
    32.931    -2.304     0.200
    32.977    -2.111     0.200
    33.176     1.358     0.200
    33.352    -1.378     0.200
    33.953    -0.615     0.200
    34.568     0.060     0.200
    35.253     1.153     0.200
    36.969     0.467     0.200
    36.969     1.470     0.200
    37.158    -0.134     0.200
    37.322     0.177     0.200
    38.116     0.764     0.200
    38.590    -2.227     0.200
    38.590    -1.828     0.200
    38.530     2.275     0.200
    38.919    -2.986     0.200
    39.625    -0.877     0.200
    39.836    -1.435     0.200
    40.159    -1.714     0.200
    41.180    -0.745     0.200
    41.795    -0.285     0.200
    42.760    -0.951     0.200
    42.750    -0.165     0.200
    42.946     0.641     0.200
    43.695    -0.204     0.200
    43.620     0.902     0.200
    44.011    -0.141     0.200
    44.267     0.209     0.200
    44.267     0.311     0.200
    44.655    -0.191     0.200
    44.531     1.398     0.200
    44.709    -2.126     0.200
    44.846     1.284     0.200
    46.984    -0.376     0.200
    46.959     1.920     0.200
    47.521     1.738     0.200
    47.824    -1.814     0.200
    48.531    -0.672     0.200
    48.512     0.076     0.200
    48.899    -1.104     0.200
    49.382    -1.096     0.200
    50.918     1.060     0.200
    51.308    -0.363     0.200
    51.308     0.035     0.200
    51.504     1.267     0.200
    51.702     2.383     0.200
    52.020     0.317     0.200
    51.902     1.695     0.200
    52.740     0.869     0.200
    53.128    -1.388     0.200
    53.233    -0.059     0.200
    53.389    -0.811     0.200
    53.389    -0.112     0.200
    53.306     0.701     0.200
    53.805    -1.357     0.200
    53.748     1.558     0.200
    54.405    -1.234     0.200
    54.405    -0.934     0.200
    54.777    -1.135     0.200
    55.036     0.893     0.200
    55.451    -1.299     0.200
    55.767    -0.773     0.200
    55.781     0.327     0.200
    57.015     0.340     0.200
    57.373    -1.392     0.200
    58.422    -0.855     0.200
    58.888     0.599     0.200
    58.994    -1.635     0.200
    58.948    -0.516     0.200
    59.432    -0.865     0.200
    60.619    -1.010     0.200
    60.738    -1.919     0.200
    62.062    -1.370     0.200
    62.116     0.871     0.200
    62.120     0.947     0.200
    62.234    -0.720     0.200
    62.268    -0.451     0.200
    62.277    -0.209     0.200
    62.048    -0.073     0.200
    62.336    -0.603     0.200
    62.295    -0.729     0.200
    62.296    -0.440     0.200
    62.687    -0.146     0.200
    62.887    -0.279     0.200
    63.734    -0.886     0.200
    63.845    -1.120     0.200
    63.843     0.391     0.200
    64.042    -0.316     0.200
    64.283    -0.997     0.200
    64.592    -1.018     0.200
    64.735     0.150     0.200
    64.996    -1.749     0.200
    65.885    -0.904     0.200
    65.797     0.662     0.200
    66.024     0.201     0.200
    66.247     0.775     0.200
    66.478    -0.105     0.200
    66.790     0.304     0.200
    66.930    -0.589     0.200
    67.263     1.294     0.200
    67.580     1.290     0.200
    67.947     2.979     0.200
    68.053     0.313     0.200
    67.974     0.807     0.200
    68.215     0.293     0.200
    68.380     0.658     0.200
    68.394     3.177     0.200
    68.518     0.601     0.200
    68.767    -1.757     0.200
    68.823     0.496     0.200
    68.887    -0.298     0.200
    68.866     0.029     0.200
    68.972    -1.029     0.200
    69.212    -0.120     0.200
    69.081     1.395     0.200
    69.140     0.531     0.200
    69.415    -1.177     0.200
    69.376     0.870     0.200
    69.606     0.645     0.200
    69.607     0.639     0.200
    69.650    -1.019     0.200
    69.769     0.642     0.200
    69.597     0.703     0.200
    69.807    -1.093     0.200
    69.823    -0.887     0.200
    69.780     1.375     0.200
    69.818     1.042     0.200
    69.844     1.280     0.200
    69.855     0.913     0.200
    70.115    -1.273     0.200
    70.221     0.866     0.200
    70.158     1.452     0.200
    70.259     0.334     0.200
    70.694    -1.019     0.200
    70.566     1.761     0.200
    70.897    -0.258     0.200
    71.139     1.776     0.200
    71.208     1.061     0.200
    71.258     1.054     0.200
    71.425    -1.554     0.200
    71.430     0.316     0.200
    71.541     0.350     0.200
    71.991    -0.156     0.200
    71.902     1.375     0.200
    72.363    -0.081     0.200
    72.900     1.721     0.200
    73.381     1.079     0.200
    73.626    -2.557     0.200
    73.772    -0.419     0.200
    73.807    -0.623     0.200
    73.915     1.143     0.200
    73.981     0.361     0.200
    75.381    -0.755     0.200
    75.446    -0.124     0.200
    75.453     0.332     0.200
    75.363     0.650     0.200
    75.704     1.397     0.200
    75.915    -0.710     0.200
    76.095     0.162     0.200
    76.155    -0.572     0.200
    76.242    -0.669     0.200
    76.299     0.006     0.200
    76.299     0.905     0.200
    76.318     0.696     0.200
    76.274     1.345     0.200
    76.693     4.773     0.200
    76.804     1.447     0.200
    77.038     0.028     0.200
    76.869     0.884     0.200
    77.119    -0.523     0.200
    77.118     0.079     0.200
    77.464    -0.658     0.200
    77.578    -0.194     0.200
    77.351     0.271     0.200
    77.602    -0.128     0.200
    77.666     0.314     0.200
    77.698    -0.564     0.200
    77.748     0.855     0.200
    77.852    -0.423     0.200
    77.720     0.014     0.200
    77.792     1.614     0.200
    77.839     1.850     0.200
    78.002     0.247     0.200
    78.048     0.890     0.200
    78.101    -0.408     0.200
    78.167    -0.473     0.200
    78.167     0.027     0.200
    78.172    -0.500     0.200
    78.269     0.461     0.200
    78.347    -0.571     0.200
    78.343    -0.344     0.200
    78.211     1.388     0.200
    78.323     0.664     0.200
    78.546    -1.564     0.200
    78.600     0.139     0.200
    78.599    -0.661     0.200
    78.631    -0.036     0.200
    78.625    -0.003     0.200
    78.665    -0.022     0.200
    78.698    -0.402     0.200
    78.824     0.904     0.200
    78.873    -1.366     0.200
    78.923     0.161     0.200
    79.171     0.004     0.200
    79.178     0.963     0.200
    79.472    -0.641     0.200
    79.557    -0.304     0.200
    79.647    -0.790     0.200
    79.422     0.731     0.200
    80.037    -0.603     0.200
    80.082     0.252     0.200
    80.145    -0.288     0.200
    80.194     0.449     0.200
    80.146    -0.490     0.200
    80.335    -0.008     0.200
    80.422    -0.277     0.200
    80.515    -0.281     0.200
    80.612    -0.900     0.200
    80.552     1.325     0.200
    80.780    -0.798     0.200
    80.840    -0.319     0.200
    80.893     0.200     0.200
    80.981     0.229     0.200
    80.984     0.013     0.200
    80.987    -0.601     0.200
    81.028    -0.623     0.200
    81.048    -0.929     0.200
    81.503     0.156     0.200
    81.570    -0.699     0.200
    81.588    -0.491     0.200
    81.702    -1.592     0.200
    81.745    -0.521     0.200
    81.796    -0.892     0.200
    81.861    -0.331     0.200
    81.937    -1.830     0.200
    81.978    -1.045     0.200
    82.125     0.580     0.200
    82.178    -0.899     0.200
    82.252    -0.786     0.200
    82.259    -0.822     0.200
    82.259    -0.623     0.200
    82.285    -1.154     0.200
    82.311    -1.290     0.200
    82.693     0.115     0.200
    82.901    -1.365     0.200
    83.344    -0.154     0.200
    83.524    -0.578     0.200
    83.542    -0.170     0.200
    83.707    -1.214     0.200
    83.746    -0.718     0.200
    83.798    -0.681     0.200
    83.823     0.285     0.200
    83.845    -0.527     0.200
    83.864     0.682     0.200
    83.953    -0.676     0.200
    83.974     1.617     0.200
    84.044    -0.640     0.200
    84.245     0.736     0.200
    84.244    -0.658     0.200
    84.295    -0.515     0.200
    84.155     1.697     0.200
    84.332    -0.404     0.200
    84.352     0.299     0.200
    84.527    -1.193     0.200
    84.619    -0.154     0.200
    84.736     0.756     0.200
    84.782    -0.479     0.200
    84.816     1.350     0.200
    85.092     0.163     0.200
    85.152    -0.137     0.200
    85.241    -0.177     0.200
    85.358     0.134     0.200
    85.408     0.084     0.200
    85.627     0.096     0.200
    85.681    -0.074     0.200
    85.956    -0.834     0.200
    85.693    -0.031     0.200
    85.879     0.047     0.200
    86.154    -0.415     0.200
    86.202    -0.650     0.200
    86.249     0.021     0.200
    86.401     0.672     0.200
    86.698     0.012     0.200
    86.827     0.386     0.200
    86.907     0.593     0.200
    87.144     0.040     0.200
    87.233    -0.092     0.200
    87.443    -0.609     0.200
    87.630     1.296     0.200
    87.609     0.093     0.200
    87.807     0.149     0.200
    87.894     0.037     0.200
    88.005     0.709     0.200
    88.467     0.720     0.200
    88.418     0.653     0.200
    88.455     0.380     0.200
    88.656    -0.268     0.200
    88.835     0.291     0.200
    88.847     1.231     0.200
    89.524     1.356     0.200
    89.346     0.490     0.200
    89.379     2.237     0.200
    89.586    -0.234     0.200
    89.829     0.527     0.200
    89.833     1.412     0.200
    90.404    -0.352     0.200
    90.553    -0.546     0.200
    90.619     0.248     0.200
    90.797    -0.082     0.200
    93.585     0.329     0.200
    42.050     0.414     0.200
    43.722     0.669     0.200
    44.265    -0.492     0.200
    49.384    -0.530     0.200
    60.655    -1.765     0.200
    62.372    -0.561     0.200
    62.278    -1.232     0.200
    63.882    -1.576     0.200
    65.922    -1.858     0.200
    69.451    -1.439     0.200
    69.686    -1.440     0.200
    69.843    -1.425     0.200
    69.857    -1.219     0.200
    70.150    -1.725     0.200
    18.572    -4.387     0.200
    20.366    -2.984     0.200
    21.312    -2.199     0.200
    21.312    -2.097     0.200
    21.567    -2.936     0.200
    21.567    -2.639     0.200
    28.088    -1.828     0.200
    28.088    -1.531     0.200
    32.968    -2.114     0.200
    42.686    -0.913     0.200
    42.686    -0.710     0.200
    43.613     0.102     0.200
    44.066    -0.043     0.200
    44.316    -0.042     0.200
    44.316     0.254     0.200
    49.424    -0.959     0.200
    53.172    -1.048     0.200
    53.172    -0.649     0.200
    55.362    -1.287     0.200
    57.395    -1.478     0.200
    58.961    -0.430     0.200
    58.934     0.463     0.200
    58.994    -0.656     0.200
    60.730    -1.878     0.200
    62.188    -0.933     0.200
    62.296    -2.152     0.200
    62.283    -1.363     0.200
    62.284    -0.074     0.200
    62.600    -0.185     0.200
    63.804    -1.961     0.200
    63.906     0.164     0.200
    64.958    -1.922     0.200
    65.842    -1.440     0.200
    67.652     2.027     0.200
    68.143    -2.063     0.200
    69.012    -1.481     0.200
    69.378    -1.354     0.200
    69.614    -1.284     0.200
    69.770    -1.168     0.200
    69.788    -0.879     0.200
    69.880     0.757     0.200
    70.635     0.740     0.200
    71.559    -2.062     0.200
    18.567    -2.358     0.200
    19.355    -0.001     0.200
    20.061    -3.702     0.200
    21.347    -1.624     0.200
    21.347    -1.522     0.200
    21.457     0.394     0.200
    21.563    -2.939     0.200
    21.563    -2.540     0.200
    25.480    -2.408     0.200
    27.639    -0.780     0.200
    28.163    -1.857     0.200
    32.945    -2.883     0.200
    36.957     0.412     0.200
    41.171     0.268     0.200
    41.809    -0.366     0.200
    42.008     0.409     0.200
    42.760    -2.314     0.200
    43.684     1.623     0.200
    43.684     0.323     0.200
    44.281     0.027     0.200
    44.281     0.327     0.200
    51.305    -0.417     0.200
    51.305    -0.018     0.200
    51.329    -1.097     0.200
    52.023    -0.780     0.200
    52.023    -0.581     0.200
    54.939    -1.184     0.200
    55.421     0.836     0.200
    57.387    -1.669     0.200
    58.963    -0.198     0.200
    60.749    -1.875     0.200
    62.284     0.362     0.200
    63.852    -1.750     0.200
    68.881     0.048     0.200
    68.986    -0.606     0.200
    69.423    -0.961     0.200
    69.658    -0.752     0.200
    69.815    -0.928     0.200
    69.830    -1.025     0.200
    69.832     1.267     0.200
    70.579     1.586     0.200
    71.552    -1.312     0.200
    77.125    -0.754     0.200
    77.124    -0.750     0.200
    77.607    -0.257     0.200
    77.607    -0.155     0.200
    78.608    -0.003     0.200
    78.671     0.651     0.200
    80.566     1.352     0.200
    85.893     1.074     0.200
    86.053     1.187     0.200
    19.912    -3.502     0.200
    34.541    -0.655     0.200
    37.135    -1.387     0.200
    43.570    -0.645     0.200
    44.303     0.472     0.200
    44.303     0.073     0.200
    51.302    -1.769     0.200
    54.874    -1.089     0.200
    57.353    -1.805     0.200
    58.976    -1.160     0.200
    60.662    -1.755     0.200
    62.211    -1.220     0.200
    63.719    -1.241     0.200
    64.875    -2.117     0.200
    65.757    -1.330     0.200
    68.643    -1.636     0.200
    68.900     0.561     0.200
    68.988     0.019     0.200
    69.295    -1.597     0.200
    69.530    -1.503     0.200
    69.686    -1.605     0.200
    69.705    -1.021     0.200
    69.995    -1.683     0.200
    71.515    -0.451     0.200
    75.565     0.736     0.200
    76.987    -1.342     0.200
    77.468    -0.039     0.200
    80.631     1.139     0.200
    83.621    -0.932     0.200
    18.579    -1.923     0.200
    18.579    -1.423     0.200
    19.397    -2.892     0.200
    19.397    -2.693     0.200
    21.378    -4.387     0.200
    21.378    -3.785     0.200
    21.575    -2.495     0.200
    21.575    -1.796     0.200
    28.207    -1.419     0.200
    28.207    -0.919     0.200
    29.692    -0.707     0.200
    32.947    -2.262     0.200
    36.985     1.119     0.200
    40.203    -2.099     0.200
    40.203    -1.798     0.200
    41.207    -1.382     0.200
    41.805    -0.284     0.200
    42.804    -1.417     0.200
    42.804    -1.315     0.200
    43.714     0.432     0.200
    43.714     0.233     0.200
    44.017     0.201     0.200
    44.276    -0.275     0.200
    44.276    -0.275     0.200
    49.395    -0.607     0.200
    54.957    -1.642     0.200
    57.396    -2.060     0.200
    58.960    -0.998     0.200
    59.036    -1.525     0.200
    60.662    -1.199     0.200
    60.662    -1.898     0.200
    60.773    -1.657     0.200
    61.216    -1.066     0.200
    62.268    -1.246     0.200
    62.269    -0.856     0.200
    62.310    -0.228     0.200
    62.379    -1.291     0.200
    63.888    -1.405     0.200
    64.637    -0.208     0.200
    65.038    -1.822     0.200
    65.929    -1.183     0.200
    68.259    -1.381     0.200
    68.810    -1.718     0.200
    68.876    -0.229     0.200
    68.986    -0.414     0.200
    69.458    -1.336     0.200
    69.693    -1.254     0.200
    69.850    -1.251     0.200
    69.865    -0.843     0.200
    69.818     1.045     0.200
    70.157    -1.461     0.200
    71.563    -1.680     0.200
    78.709     0.247     0.200
    80.548     1.151     0.200
    83.789    -0.828     0.200
    84.375    -0.614     0.200
    85.135     0.160     0.200
    86.444     0.372     0.200
    44.407    -0.438     0.200
    49.510     0.204     0.200
    57.467    -1.679     0.200
    63.808    -1.903     0.200
    65.845    -2.167     0.200
    69.388    -1.532     0.200
    69.624    -1.418     0.200
    69.779    -1.446     0.200
    69.800    -1.272     0.200
    19.257    -3.110     0.200
    19.257    -2.911     0.200
    21.283    -4.122     0.200
    21.283    -3.622     0.200
    21.368    -1.228     0.200
    21.552    -3.013     0.200
    21.552    -2.615     0.200
    23.828    -2.639     0.200
    23.828    -1.838     0.200
    25.388    -2.544     0.200
    28.052    -1.846     0.200
    28.052    -1.346     0.200
    29.538    -1.055     0.200
    29.538    -0.255     0.200
    32.865     1.045     0.200
    32.961    -2.200     0.200
    33.246     1.311     0.200
    38.483    -1.665     0.200
    38.846    -3.607     0.200
    39.508    -0.340     0.200
    41.067    -0.047     0.200
    41.904     0.089     0.200
    41.840    -0.289     0.200
    42.651    -1.997     0.200
    42.651    -1.696     0.200
    43.592     0.892     0.200
    43.592     0.392     0.200
    44.068    -0.040     0.200
    46.356     0.406     0.200
    49.419    -0.719     0.200
    51.329    -0.267     0.200
    51.923    -0.207     0.200
    53.136    -1.194     0.200
    54.912    -1.158     0.200
    57.383    -1.607     0.200
    58.931    -1.841     0.200
    58.991    -0.559     0.200
    60.553    -1.199     0.200
    60.706    -1.848     0.200
    61.115    -0.629     0.200
    61.999    -1.593     0.200
    62.264    -2.170     0.200
    62.299    -1.606     0.200
    62.301    -0.813     0.200
    62.574     0.560     0.200
    63.645    -0.551     0.200
    63.772    -1.387     0.200
    63.912     0.689     0.200
    64.503    -1.187     0.200
    64.503    -0.687     0.200
    64.927    -1.953     0.200
    65.810    -1.369     0.200
    65.866     0.971     0.200
    67.347     1.215     0.200
    68.057     0.638     0.200
    68.696    -1.660     0.200
    68.601     0.628     0.200
    68.739    -0.230     0.200
    68.913    -0.316     0.200
    69.006    -0.894     0.200
    69.347    -1.358     0.200
    69.444     0.793     0.200
    69.583    -1.282     0.200
    69.739    -1.322     0.200
    69.757    -0.934     0.200
    69.886     1.170     0.200
    70.047    -1.492     0.200
    70.243     1.282     0.200
    71.359    -0.205     0.200
    71.546    -0.933     0.200
    71.982     1.445     0.200
    72.905     0.441     0.200
    77.041    -1.443     0.200
    77.522     0.861     0.200
    78.585     0.660     0.200
    79.019     0.580     0.200
    80.158     0.386     0.200
    80.629     0.856     0.200
    81.513    -0.655     0.200
    83.674    -0.707     0.200
    83.881    -0.766     0.200
    83.972    -0.734     0.200
    84.222    -0.602     0.200
    84.260    -0.496     0.200
    85.020    -0.036     0.200
    85.081    -0.338     0.200
    85.337    -0.321     0.200
    85.558     0.078     0.200
    85.746     0.947     0.200
    85.943     0.472     0.200
    86.103     0.579     0.200
    86.328     0.468     0.200
    86.755     0.372     0.200
    86.836     0.281     0.200
    87.678     1.006     0.200
    87.705     1.376     0.200
    18.537    -1.866     0.200
    19.309    -2.135     0.200
    20.031    -3.226     0.200
    20.424    -2.189     0.200
    20.622    -2.642     0.200
    21.303    -3.594     0.200
    21.444    -2.908     0.200
    21.532    -1.245     0.200
    23.521    -3.687     0.200
    23.876    -4.736     0.200
    23.876    -4.533     0.200
    25.465    -3.207     0.200
    26.286     1.362     0.200
    27.620    -2.643     0.200
    27.620    -2.244     0.200
    27.615    -2.099     0.200
    28.120    -1.707     0.200
    28.638     4.177     0.200
    29.604    -1.293     0.200
    30.274    -4.223     0.200
    30.302     3.534     0.200
    30.511    -1.316     0.200
    30.953     0.783     0.200
    31.031     2.100     0.200
    31.924     1.234     0.200
    33.909    -1.822     0.200
    35.252     3.272     0.200
    36.946     0.379     0.200
    37.162    -1.057     0.200
    37.321     0.096     0.200
    38.122     0.827     0.200
    38.546    -1.847     0.200
    38.527     2.413     0.200
    38.880    -4.944     0.200
    39.582    -0.911     0.200
    39.792    -1.455     0.200
    40.115    -1.442     0.200
    41.147    -1.366     0.200
    41.793    -0.262     0.200
    42.716    -1.583     0.200
    42.911     0.443     0.200
    42.977     2.494     0.200
    43.669     0.010     0.200
    43.669     0.111     0.200
    44.014    -0.159     0.200
    44.266     0.220     0.200
    44.266     0.322     0.200
    44.621    -1.314     0.200
    44.684    -3.318     0.200
    44.825     1.362     0.200
    46.428     0.179     0.200
    46.936     0.003     0.200
    46.940    -0.034     0.200
    47.533     0.049     0.200
    47.791    -2.454     0.200
    47.791    -2.055     0.200
    48.488    -1.838     0.200
    48.856    -1.667     0.200
    48.856    -0.870     0.200
    49.377    -0.254     0.200
    50.901     1.294     0.200
    51.264    -0.938     0.200
    51.264    -0.735     0.200
    51.301    -0.918     0.200
    51.976    -0.259     0.200
    52.725     0.391     0.200
    53.084    -1.467     0.200
    53.084    -0.670     0.200
    53.190    -0.537     0.200
    53.347    -0.695     0.200
    53.293     0.496     0.200
    53.766    -1.174     0.200
    54.362    -1.424     0.200
    54.734    -1.321     0.200
    54.903    -0.749     0.200
    55.019     0.414     0.200
    55.407    -1.387     0.200
    55.407    -1.286     0.200
    55.736    -0.645     0.200
    55.798    -0.192     0.200
    57.001     0.233     0.200
    57.358    -1.490     0.200
    58.384    -1.488     0.200
    58.957    -1.276     0.200
    58.946    -0.398     0.200
    59.398    -0.533     0.200
    60.582    -1.451     0.200
    60.709    -1.823     0.200
    61.139    -1.444     0.200
    62.025    -1.822     0.200
    62.072     0.259     0.200
    62.129     0.877     0.200
    62.198    -1.082     0.200
    62.225    -0.264     0.200
    62.233    -1.821     0.200
    62.233    -1.618     0.200
    62.297    -0.847     0.200
    62.315    -0.469     0.200
    62.316    -0.978     0.200
    62.654    -0.633     0.200
    62.843     0.507     0.200
    63.691    -1.512     0.200
    63.806    -1.469     0.200
    63.851     0.432     0.200
    63.999    -0.539     0.200
    64.242    -1.136     0.200
    64.184     2.244     0.200
    64.550    -1.850     0.200
    64.738     0.121     0.200
    64.957    -2.203     0.200
    65.846    -1.351     0.200
    65.805     0.502     0.200
    66.044     0.167     0.200
    66.262     2.771     0.200
    66.886     0.184     0.200
    67.278     0.293     0.200
    67.618     0.142     0.200
    67.595     1.786     0.200
    68.009    -0.318     0.200
    67.989     0.605     0.200
    68.171    -0.338     0.200
    68.388     1.007     0.200
    68.533     0.401     0.200
    68.728    -2.024     0.200
    68.782    -0.153     0.200
    68.843     0.069     0.200
    68.865     0.328     0.200
    68.966    -0.196     0.200
    69.097     1.682     0.200
    69.377    -1.489     0.200
    69.383     0.613     0.200
    69.562     0.010     0.200
    69.563     1.003     0.200
    69.612    -1.332     0.200
    69.725     1.006     0.200
    69.769    -1.469     0.200
    69.785    -0.763     0.200
    69.797     1.166     0.200
    69.826     0.987     0.200
    69.861     1.169     0.200
    69.886     0.309     0.200
    70.077    -1.557     0.200
    70.174     1.046     0.200
    70.579     1.274     0.200
    70.854    -0.905     0.200
    71.156     1.469     0.200
    71.223     0.755     0.200
    71.273     0.557     0.200
    71.497    -0.294     0.200
    71.523    -1.950     0.200
    71.915     1.688     0.200
    72.835     0.199     0.200
    73.390     1.216     0.200
    73.583    -2.216     0.200
    73.733    -0.100     0.200
    73.765     1.713     0.200
    75.340    -0.428     0.200
    75.369     0.507     0.200
    75.662    -0.276     0.200
    75.874    -0.986     0.200
    76.201    -0.349     0.200
    76.256     0.336     0.200
    76.277    -0.779     0.200
    76.821     1.143     0.200
    76.997    -0.247     0.200
    77.079    -0.411     0.200
    77.078    -0.705     0.200
    77.537     0.121     0.200
    77.561    -0.012     0.200
    77.662    -0.476     0.200
    77.800     1.653     0.200
    77.848     1.390     0.200
    77.960     0.763     0.200
    78.009     0.993     0.200
    78.127    -0.164     0.200
    78.224    -3.698     0.200
    78.503    -2.242     0.200
    78.563    -0.574     0.200
    78.590     0.381     0.200
    78.624    -0.409     0.200
    78.624    -0.511     0.200
    78.883     0.170     0.200
    78.819    -0.481     0.200
    79.056    -0.278     0.200
    79.128    -0.576     0.200
    79.428    -0.112     0.200
    79.607    -0.289     0.200
    79.998    -0.907     0.200
    80.131    -1.127     0.200
    80.294     0.394     0.200
    80.477    -0.190     0.200
    80.564     1.048     0.200
    80.759     1.401     0.200
    80.797    -0.101     0.200
    80.850     0.515     0.200
    80.947    -0.003     0.200
    81.009    -0.632     0.200
    81.102     1.971     0.200
    81.206     0.519     0.200
    81.241    -0.271     0.200
    81.548    -0.297     0.200
    81.818    -0.519     0.200
    81.896    -1.529     0.200
    81.938    -1.749     0.200
    82.213    -0.895     0.200
    82.220    -0.431     0.200
    82.702    -1.743     0.200
    83.484    -0.787     0.200
    83.501    -1.876     0.200
    83.656    -0.171     0.200
    83.707    -0.533     0.200
    83.823     0.474     0.200
    83.914    -0.391     0.200
    84.005    -0.559     0.200
    84.204     0.736     0.200
    84.256    -0.332     0.200
    84.293    -0.320     0.200
    84.310     0.496     0.200
    84.486    -0.898     0.200
    84.693     0.555     0.200
    85.053     0.143     0.200
    85.113    -0.259     0.200
    85.369    -0.040     0.200
    85.589     0.173     0.200
    85.687    -0.020     0.200
    85.916    -0.753     0.200
    85.885     0.501     0.200
    86.114    -0.429     0.200
    86.045     0.913     0.200
    86.161    -0.562     0.200
    86.362     0.648     0.200
    86.788     0.457     0.200
    86.868     0.562     0.200
    87.132     0.082     0.200
    87.648     0.493     0.200
    87.882    -0.024     0.200
    88.428     0.086     0.200
    88.408     0.382     0.200
    88.444     0.212     0.200
    88.617     0.898     0.200
    88.826     0.014     0.200
    88.857     0.767     0.200
    89.107     0.491     0.200
    89.382     2.302     0.200
    89.822     0.645     0.200
    90.052     2.170     0.200
    90.395     0.571     0.200
    90.606     0.588     0.200
    92.878     0.070     0.200
    18.582    -1.782     0.200
    19.260    -2.216     0.200
    19.260    -1.919     0.200
    19.935    -0.583     0.200
    21.344    -0.428     0.200
    21.576    -2.308     0.200
    23.833    -2.558     0.200
    23.833    -1.761     0.200
    27.516    -0.510     0.200
    28.048    -0.661     0.200
    28.048    -0.458     0.200
    30.283    -2.493     0.200
    32.987    -1.966     0.200
    39.500     1.125     0.200
    41.866    -0.795     0.200
    43.569     1.792     0.200
    43.569     1.792     0.200
    44.342    -0.404     0.200
    44.342    -0.107     0.200
    49.445    -1.269     0.200
    51.354    -1.191     0.200
    51.926     0.035     0.200
    53.139    -0.946     0.200
    53.672    -0.858     0.200
    54.934    -2.034     0.200
    57.407    -1.686     0.200
    59.017    -0.943     0.200
    60.564    -1.576     0.200
    60.725    -1.670     0.200
    62.146     0.129     0.200
    62.274    -1.126     0.200
    62.278    -0.447     0.200
    62.554    -0.998     0.200
    63.782    -1.837     0.200
    65.820    -1.404     0.200
    68.106     1.068     0.200
    68.940    -0.139     0.200
    69.032    -0.816     0.200
    69.359    -1.141     0.200
    69.470     0.575     0.200
    69.594    -1.126     0.200
    69.750    -1.149     0.200
    69.769    -1.469     0.200
    69.912     0.954     0.200
    70.059    -1.428     0.200
    70.671     1.216     0.200
    71.569    -2.225     0.200
    77.050    -0.121     0.200
    78.594    -0.004     0.200
    78.594     0.191     0.200
    80.182    -0.362     0.200
    83.684    -0.864     0.200
    83.891    -0.820     0.200
    83.983    -0.687     0.200
    84.232    -0.456     0.200
    84.270    -0.353     0.200
    85.031    -0.086     0.200
    85.091    -0.092     0.200
    85.348    -0.375     0.200
    85.772     0.016     0.200
    85.969    -0.051     0.200
    86.339     0.423     0.200
    86.766     0.531     0.200
    86.846     0.437     0.200
    18.628    -1.638     0.200
    19.311    -3.124     0.200
    19.311    -2.524     0.200
    19.956    -3.171     0.200
    20.319    -2.620     0.200
    21.622    -2.179     0.200
    25.367    -3.019     0.200
    28.090    -1.543     0.200
    28.090    -0.743     0.200
    29.579    -0.773     0.200
    29.579    -0.473     0.200
    33.026    -1.711     0.200
    37.057    -1.152     0.200
    37.081     2.939     0.200
    38.419     3.140     0.200
    39.536    -0.716     0.200
    41.061    -0.335     0.200
    41.899    -0.312     0.200
    42.692    -1.666     0.200
    42.692    -1.366     0.200
    43.571     0.230     0.200
    44.123    -0.107     0.200
    44.373     0.787     0.200
    44.373    -0.012     0.200
    49.481    -0.818     0.200
    51.397    -0.799     0.200
    51.977     0.076     0.200
    52.617     0.221     0.200
    53.185     0.134     0.200
    53.299    -0.708     0.200
    53.698    -1.635     0.200
    54.984    -1.992     0.200
    55.311    -0.851     0.200
    57.452    -1.604     0.200
    58.999    -1.420     0.200
    58.992     0.230     0.200
    59.051     0.214     0.200
    59.314    -0.606     0.200
    60.619    -1.464     0.200
    60.778    -1.644     0.200
    62.185     0.054     0.200
    62.198    -1.230     0.200
    62.198    -1.030     0.200
    62.329    -1.110     0.200
    62.228    -0.734     0.200
    62.230    -0.743     0.200
    62.567    -0.702     0.200
    63.837    -1.316     0.200
    63.961     0.567     0.200
    64.561     0.132     0.200
    64.847     0.268     0.200
    64.994    -1.685     0.200
    65.874    -1.382     0.200
    65.915     0.358     0.200
    67.727     0.813     0.200
    68.151    -0.850     0.200
    68.972     0.024     0.200
    69.069    -0.581     0.200
    69.414    -0.992     0.200
    69.649    -0.816     0.200
    69.805    -0.826     0.200
    69.824    -0.843     0.200
    69.935     1.175     0.200
    70.114    -1.041     0.200
    70.687     1.675     0.200
    71.615    -2.143     0.200
    72.024     1.401     0.200
    73.499     1.142     0.200
    77.585    -0.073     0.200
    78.609    -0.453     0.200
    78.648     0.333     0.200
    80.031    -0.211     0.200
    80.672     1.339     0.200
    83.739    -0.816     0.200
    83.946    -0.774     0.200
    84.037    -0.842     0.200
    84.287    -0.411     0.200
    84.325    -0.505     0.200
    84.619    -0.390     0.200
    85.086    -0.038     0.200
    85.403    -0.324     0.200
    86.393     0.374     0.200
    18.559    -2.735     0.200
    19.275    -3.592     0.200
    19.275    -2.692     0.200
    19.973    -2.205     0.200
    20.562    -2.611     0.200
    21.295    -4.531     0.200
    21.554    -2.310     0.200
    23.461    -3.060     0.200
    23.846    -5.216     0.200
    25.406    -2.523     0.200
    27.555    -0.318     0.200
    27.577    -1.912     0.200
    27.577    -1.512     0.200
    28.074    -1.752     0.200
    29.560    -1.158     0.200
    32.958    -2.486     0.200
    37.363     0.474     0.200
    38.504    -1.660     0.200
    38.861    -5.057     0.200
    39.530    -1.549     0.200
    39.747    -1.457     0.200
    40.075    -1.680     0.200
    41.087     0.459     0.200
    41.924     0.596     0.200
    41.834    -0.365     0.200
    42.672    -1.696     0.200
    43.610     0.918     0.200
    44.060     0.103     0.200
    44.308    -0.688     0.200
    44.308     0.012     0.200
    44.767     3.651     0.200
    48.806    -0.963     0.200
    49.414    -0.617     0.200
    51.214    -1.238     0.200
    51.214    -0.438     0.200
    51.329    -1.199     0.200
    51.942     0.314     0.200
    53.294    -0.694     0.200
    53.708    -0.731     0.200
    54.917    -1.131     0.200
    55.363    -0.253     0.200
    57.383    -2.150     0.200
    58.945    -2.078     0.200
    58.925    -0.045     0.200
    60.567    -0.942     0.200
    60.714    -1.346     0.200
    62.185    -1.186     0.200
    62.185    -0.386     0.200
    62.279    -0.615     0.200
    62.296    -0.732     0.200
    62.298     1.059     0.200
    63.663    -0.015     0.200
    63.787    -1.534     0.200
    63.901     0.414     0.200
    64.220    -0.680     0.200
    64.521    -0.652     0.200
    64.784    -0.370     0.200
    64.942    -2.295     0.200
    65.826    -2.119     0.200
    65.855     1.192     0.200
    67.665    -0.348     0.200
    67.969    -0.765     0.200
    68.438     0.898     0.200
    68.711    -1.306     0.200
    68.756    -0.688     0.200
    68.907    -0.626     0.200
    69.002    -1.219     0.200
    69.127     1.203     0.200
    69.362    -1.098     0.200
    69.433     0.310     0.200
    69.597    -1.031     0.200
    69.753    -1.065     0.200
    69.771    -1.374     0.200
    69.875     0.885     0.200
    69.916     3.132     0.200
    70.061    -1.180     0.200
    70.632     0.952     0.200
    71.373    -1.044     0.200
    71.546    -0.791     0.200
    71.969     1.470     0.200
    73.551    -0.729     0.200
    73.440     0.925     0.200
    74.054     0.326     0.200
    75.315    -0.983     0.200
    75.848    -0.838     0.200
    76.250    -0.329     0.200
    76.970     0.600     0.200
    76.876     1.230     0.200
    77.057    -0.289     0.200
    77.538    -0.588     0.200
    77.538    -0.088     0.200
    77.935     0.201     0.200
    77.992     0.885     0.200
    77.898     2.409     0.200
    78.107     0.249     0.200
    78.565     0.615     0.200
    78.553    -0.219     0.200
    78.602    -0.487     0.200
    78.602     0.413     0.200
    78.860    -0.111     0.200
    78.859    -0.904     0.200
    79.034     0.134     0.200
    79.102     0.766     0.200
    79.100    -1.223     0.200
    79.981    -1.016     0.200
    80.460    -0.401     0.200
    80.616     1.564     0.200
    80.765    -0.235     0.200
    80.819     0.377     0.200
    80.928    -1.103     0.200
    80.992    -0.247     0.200
    81.440    -0.327     0.200
    81.529    -0.296     0.200
    81.787    -1.261     0.200
    82.139     0.190     0.200
    82.214    -0.901     0.200
    83.689    -0.844     0.200
    83.792    -0.575     0.200
    83.896    -0.804     0.200
    83.987    -0.871     0.200
    84.177     0.461     0.200
    84.192    -0.712     0.200
    84.237    -0.343     0.200
    84.282     0.428     0.200
    84.275    -0.436     0.200
    84.217     0.762     0.200
    84.566    -0.509     0.200
    85.035     0.227     0.200
    85.096    -0.175     0.200
    85.109     1.761     0.200
    85.352     0.042     0.200
    85.573     0.043     0.200
    85.736    -0.066     0.200
    86.093     0.067     0.200
    86.343     0.931     0.200
    86.770     0.337     0.200
    86.851     0.545     0.200
    87.693     0.570     0.200
    92.862     0.435     0.200
    18.599    -1.966     0.200
    19.218    -2.761     0.200
    19.871    -2.892     0.200
    20.266    -1.194     0.200
    20.458    -2.476     0.200
    21.282    -4.177     0.200
    21.282    -3.876     0.200
    21.283     1.408     0.200
    21.592    -2.510     0.200
    23.358    -3.065     0.200
    23.795    -4.391     0.200
    25.303    -1.836     0.200
    26.136    -0.186     0.200
    27.451    -2.334     0.200
    27.994    -1.384     0.200
    29.483    -0.621     0.200
    30.276    -4.643     0.200
    30.276    -4.143     0.200
    30.350    -0.792     0.200
    30.799     0.547     0.200
    31.795     1.974     0.200
    32.781    -2.080     0.200
    33.018    -2.246     0.200
    37.435    -0.073     0.200
    38.432    -1.784     0.200
    38.829    -3.821     0.200
    39.441    -0.635     0.200
    39.671    -1.549     0.200
    39.671    -1.049     0.200
    41.820     0.717     0.200
    41.904    -0.366     0.200
    42.596    -1.601     0.200
    42.596    -1.101     0.200
    42.749     1.155     0.200
    42.891    -0.701     0.200
    43.508     0.019     0.200
    44.138    -0.248     0.200
    44.381     0.311     0.200
    44.381     0.209     0.200
    44.523    -2.132     0.200
    44.667     1.324     0.200
    46.290    -0.129     0.200
    46.799    -0.425     0.200
    46.804    -0.462     0.200
    47.782    -2.773     0.200
    47.782    -2.273     0.200
    48.349    -1.162     0.200
    48.349    -0.361     0.200
    48.721    -1.022     0.200
    48.721    -0.823     0.200
    49.479    -0.726     0.200
    51.127    -0.297     0.200
    51.376    -1.067     0.200
    51.884    -0.161     0.200
    52.576     0.900     0.200
    52.950    -1.867     0.200
    52.950    -1.267     0.200
    53.097    -0.753     0.200
    53.149     0.163     0.200
    53.204    -0.741     0.200
    53.204    -0.440     0.200
    53.609    -0.715     0.200
    54.221    -3.190     0.200
    54.221    -2.491     0.200
    54.595    -0.908     0.200
    54.941    -1.413     0.200
    55.268    -0.277     0.200
    55.734    -0.127     0.200
    56.856    -0.826     0.200
    58.339    -1.567     0.200
    58.923    -1.631     0.200
    58.994     0.177     0.200
    59.054    -0.539     0.200
    59.235    -0.795     0.200
    60.541    -1.171     0.200
    60.722    -2.004     0.200
    61.110    -1.440     0.200
    61.991    -1.585     0.200
    62.036    -1.087     0.200
    62.089    -0.345     0.200
    62.248    -1.309     0.200
    62.264    -1.017     0.200
    62.265    -0.624     0.200
    62.490     0.269     0.200
    62.715     0.574     0.200
    62.715     1.074     0.200
    63.614    -1.390     0.200
    63.755    -1.321     0.200
    64.181    -1.123     0.200
    64.472    -1.527     0.200
    64.863    -0.081     0.200
    64.915    -1.717     0.200
    65.791    -1.594     0.200
    65.940     0.046     0.200
    66.411     1.929     0.200
    67.426     1.165     0.200
    67.902    -0.033     0.200
    68.137     0.491     0.200
    68.523     0.173     0.200
    68.680    -1.410     0.200
    68.681     0.485     0.200
    68.978    -0.063     0.200
    69.057     0.749     0.200
    69.065    -0.800     0.200
    69.335    -1.233     0.200
    69.518     0.590     0.200
    69.570    -1.049     0.200
    69.726    -1.190     0.200
    69.747    -1.115     0.200
    69.960     0.969     0.200
    70.035    -1.288     0.200
    70.323     1.246     0.200
    70.724     1.303     0.200
    71.348    -0.686     0.200
    71.307     1.462     0.200
    71.374     1.061     0.200
    71.588    -1.729     0.200
    72.060     1.430     0.200
    73.433     0.275     0.200
    73.497    -1.099     0.200
    73.526     0.928     0.200
    73.691     0.763     0.200
    75.271    -0.419     0.200
    75.592    -0.260     0.200
    75.803    -0.168     0.200
    76.138     0.220     0.200
    76.204    -0.755     0.200
    76.924     1.173     0.200
    77.019    -0.763     0.200
    77.021    -0.771     0.200
    77.476     0.077     0.200
    77.500     0.445     0.200
    77.937     1.309     0.200
    78.071    -0.237     0.200
    78.250     0.872     0.200
    78.522     0.468     0.200
    78.535    -0.905     0.200
    78.563    -0.155     0.200
    78.822     0.116     0.200
    78.928    -0.965     0.200
    78.998     0.249     0.200
    79.000     0.142     0.200
    79.950    -0.534     0.200
    80.203    -0.901     0.200
    80.432    -0.128     0.200
    80.710     0.077     0.200
    80.706     0.399     0.200
    80.766    -0.419     0.200
    80.894    -0.407     0.200
    80.963    -0.571     0.200
    81.401     0.098     0.200
    81.495    -0.399     0.200
    81.606    -1.884     0.200
    81.703    -0.900     0.200
    81.734    -0.959     0.200
    81.882    -1.838     0.200
    82.085    -0.908     0.200
    82.160    -0.698     0.200
    82.167    -0.639     0.200
    82.186    -1.437     0.200
    82.216    -1.592     0.200
    83.658    -0.663     0.200
    83.864    -0.621     0.200
    83.956    -0.591     0.200
    84.205    -0.359     0.200
    84.244    -0.255     0.200
    84.760    -1.668     0.200
    85.005     0.104     0.200
    85.065    -0.200     0.200
    85.200     1.126     0.200
    85.323    -0.288     0.200
    85.545     0.205     0.200
    85.835    -1.035     0.200
    85.856    -0.741     0.200
    86.055    -0.425     0.200
    86.102    -0.556     0.200
    86.162     0.049     0.200
    86.312     0.609     0.200
    86.740     0.507     0.200
    86.820     0.418     0.200
    86.824    -0.102     0.200
    87.214    -0.799     0.200
    87.690     0.005     0.200
    87.782     1.770     0.200
    87.965    -0.400     0.200
    88.378     0.143     0.200
    88.529     0.029     0.200
    88.919    -0.106     0.200
    90.486     0.565     0.200
    90.700     0.470     0.200
    90.883     0.318     0.200
    18.500    -3.236     0.200
    19.642     0.271     0.200
    21.483    -3.307     0.200
    21.499    -3.773     0.200
    21.499    -3.375     0.200
    28.517    -1.769     0.200
    28.517    -1.069     0.200
    32.788    -1.433     0.200
    44.067     0.594     0.200
    49.217    -0.281     0.200
    53.525    -1.492     0.200
    53.525    -0.992     0.200
    58.706     0.945     0.200
    62.538    -0.528     0.200
    63.073     0.015     0.200
    64.051    -1.933     0.200
    66.099    -1.812     0.200
    68.968    -1.803     0.200
    69.604    -1.137     0.200
    69.838    -1.274     0.200
    69.997    -1.250     0.200
    70.002    -1.284     0.200
    70.302    -1.422     0.200
    83.949    -0.715     0.200
    84.158    -0.776     0.200
    84.247    -0.525     0.200
    84.499    -0.405     0.200
    84.535    -0.482     0.200
    85.294     0.009     0.200
    86.604     0.538     0.200
    87.108     0.485     0.200
    18.472    -2.458     0.200
    18.472    -2.058     0.200
    21.237    -0.591     0.200
    21.237    -0.190     0.200
    21.467    -2.067     0.200
    21.467    -1.166     0.200
    28.080    -1.145     0.200
    30.206    -5.016     0.200
    30.206    -4.516     0.200
    41.739    -0.140     0.200
    43.685     0.561     0.200
    43.966    -0.292     0.200
    44.214     0.318     0.200
    49.320    -0.655     0.200
    51.923    -0.301     0.200
    58.831     0.844     0.200
    60.517    -1.669     0.200
    62.233    -1.280     0.200
    63.743    -1.511     0.200
    63.809     0.251     0.200
    64.690    -0.029     0.200
    64.893    -1.850     0.200
    65.783    -1.617     0.200
    65.763     0.515     0.200
    68.127    -0.530     0.200
    68.665    -0.895     0.200
    68.812     0.186     0.200
    69.313    -1.841     0.200
    69.548    -1.836     0.200
    69.705    -1.742     0.200
    69.720    -1.437     0.200
    70.542     2.021     0.200
    73.348     1.489     0.200
    75.323     0.487     0.200
    76.789     1.838     0.200
    77.758     1.402     0.200
    80.526     1.263     0.200
    43.884     0.560     0.200
    44.177     1.009     0.200
    49.287     0.006     0.200
    51.211    -0.071     0.200
    62.403    -2.393     0.200
    62.404     0.997     0.200
    63.749    -1.436     0.200
    69.317    -1.625     0.200
    69.709    -1.545     0.200
    69.723    -0.929     0.200
    70.017    -2.257     0.200
    71.836     1.415     0.200
    80.483     1.425     0.200
    18.591    -2.965     0.200
    18.591    -2.765     0.200
    19.419    -3.044     0.200
    19.419    -2.244     0.200
    20.117    -3.656     0.200
    20.465    -1.037     0.200
    20.693    -2.903     0.200
    21.398    -3.506     0.200
    21.398    -2.906     0.200
    21.587    -2.335     0.200
    23.602    -3.267     0.200
    24.533    -1.567     0.200
    25.521    -1.150     0.200
    27.689    -1.398     0.200
    27.730    -1.059     0.200
    27.730    -0.959     0.200
    28.228    -0.906     0.200
    29.713    -0.694     0.200
    29.713    -0.494     0.200
    30.360    -4.412     0.200
    30.360    -3.912     0.200
    30.595    -0.991     0.200
    31.926     3.784     0.200
    32.382     0.388     0.200
    32.954    -2.224     0.200
    33.017    -1.276     0.200
    33.382    -0.762     0.200
    34.229     5.182     0.200
    34.551    -0.111     0.200
    37.002    -0.123     0.200
    38.656    -1.091     0.200
    38.983    -3.333     0.200
    39.685     0.607     0.200
    40.225    -0.775     0.200
    40.699     0.104     0.200
    41.810    -0.216     0.200
    42.825    -1.185     0.200
    43.724     0.061     0.200
    43.724    -0.239     0.200
    44.019    -0.310     0.200
    44.280     0.399     0.200
    44.280    -0.001     0.200
    44.867     1.509     0.200
    47.041    -0.025     0.200
    47.046    -0.061     0.200
    48.592    -1.046     0.200
    48.962    -0.882     0.200
    48.962    -0.282     0.200
    49.402    -0.646     0.200
    50.933     2.151     0.200
    51.369    -1.124     0.200
    51.369    -0.423     0.200
    51.347    -0.957     0.200
    52.087     0.322     0.200
    52.752     1.787     0.200
    53.190    -0.644     0.200
    53.190    -0.345     0.200
    53.300    -1.449     0.200
    53.300    -0.949     0.200
    53.449    -0.549     0.200
    53.857    -1.136     0.200
    54.466     0.029     0.200
    54.838    -0.674     0.200
    54.971    -1.637     0.200
    55.745     0.790     0.200
    58.486    -1.589     0.200
    58.486    -1.289     0.200
    58.905     0.194     0.200
    58.965    -0.923     0.200
    59.056    -1.554     0.200
    59.475    -0.452     0.200
    60.682    -1.427     0.200
    60.790    -1.461     0.200
    61.236    -1.487     0.200
    61.997     0.180     0.200
    62.179     0.159     0.200
    62.179     0.659     0.200
    62.280    -2.019     0.200
    62.255    -0.647     0.200
    62.330    -0.555     0.200
    62.340    -1.920     0.200
    62.340    -1.720     0.200
    62.400    -1.319     0.200
    62.727    -0.406     0.200
    62.951     1.009     0.200
    63.443     0.744     0.200
    63.800     0.389     0.200
    63.843     0.503     0.200
    63.909    -1.329     0.200
    64.348    -0.211     0.200
    64.658    -1.238     0.200
    64.742     0.216     0.200
    64.909     1.128     0.200
    65.059    -1.743     0.200
    65.798     0.675     0.200
    65.950    -1.604     0.200
    67.253     1.276     0.200
    67.569     2.077     0.200
    68.119    -0.388     0.200
    68.281    -1.402     0.200
    68.276    -0.268     0.200
    68.507     0.188     0.200
    68.831    -1.735     0.200
    68.889    -1.198     0.200
    68.880    -0.142     0.200
    68.952    -0.389     0.200
    68.993    -0.542     0.200
    69.279     1.387     0.200
    69.376     0.585     0.200
    69.478    -1.549     0.200
    69.713    -1.358     0.200
    69.834     0.959     0.200
    69.870    -1.364     0.200
    69.885    -0.854     0.200
    70.178    -1.552     0.200
    70.146     1.444     0.200
    70.288     0.177     0.200
    70.558     1.526     0.200
    71.487    -1.010     0.200
    71.485     0.106     0.200
    71.574    -1.635     0.200
    71.894     1.141     0.200
    72.806     0.001     0.200
    73.380     0.705     0.200
    73.692     0.271     0.200
    73.836    -0.773     0.200
    73.873     1.710     0.200
    73.982    -0.024     0.200
    74.688     0.968     0.200
    74.752    -0.405     0.200
    75.320    -0.679     0.200
    75.512    -0.785     0.200
    75.512     0.215     0.200
    75.519     0.174     0.200
    75.981     0.534     0.200
    76.162    -0.495     0.200
    76.385     0.242     0.200
    76.760     4.119     0.200
    76.791     1.442     0.200
    77.104     1.180     0.200
    77.183    -0.961     0.200
    77.184     0.033     0.200
    77.643    -0.835     0.200
    77.667    -0.268     0.200
    77.814    -0.789     0.200
    77.791     1.842     0.200
    78.067    -0.396     0.200
    78.111     2.062     0.200
    78.232    -0.108     0.200
    78.335     0.822     0.200
    78.408    -0.580     0.200
    78.660     0.329     0.200
    78.730     0.144     0.200
    78.761    -0.528     0.200
    78.940    -0.209     0.200
    78.988     0.027     0.200
    79.160     0.284     0.200
    79.162     0.277     0.200
    79.194    -1.400     0.200
    79.237    -1.035     0.200
    79.539    -0.179     0.200
    79.711    -0.215     0.200
    80.101    -0.824     0.200
    80.147     0.125     0.200
    80.400    -0.134     0.200
    80.579    -0.295     0.200
    80.546     0.980     0.200
    80.846    -0.823     0.200
    80.907    -0.250     0.200
    80.959     0.070     0.200
    81.093    -0.539     0.200
    81.112    -0.341     0.200
    81.337    -0.836     0.200
    81.430    -1.630     0.200
    81.451     0.256     0.200
    81.568    -0.062     0.200
    81.652    -0.405     0.200
    81.766    -0.707     0.200
    81.928    -0.557     0.200
    82.043    -1.159     0.200
    82.317    -0.796     0.200
    82.324    -0.731     0.200
    82.350    -1.267     0.200
    82.808    -1.153     0.200
    83.264    -1.211     0.200
    83.589    -0.184     0.200
    83.761     0.433     0.200
    83.771    -1.119     0.200
    83.810    -0.617     0.200
    83.860    -0.875     0.200
    83.889    -0.723     0.200
    83.908    -0.319     0.200
    83.929    -0.424     0.200
    84.017    -0.676     0.200
    84.108    -0.639     0.200
    84.307    -0.550     0.200
    84.311     0.129     0.200
    84.359    -0.411     0.200
    84.396    -0.301     0.200
    84.418    -0.410     0.200
    84.593    -1.298     0.200
    84.681    -0.242     0.200
    84.802     0.149     0.200
    84.926    -1.473     0.200
    85.055    -0.619     0.200
    85.035     0.979     0.200
    85.101     0.950     0.200
    85.156     0.073     0.200
    85.181    -2.250     0.200
    85.216    -0.226     0.200
    85.305    -0.271     0.200
    85.472    -0.203     0.200
    85.690     0.211     0.200
    85.684     0.443     0.200
    85.882     0.459     0.200
    86.006    -1.151     0.200
    86.021    -0.926     0.200
    86.219    -0.505     0.200
    86.267    -0.539     0.200
    86.312     0.336     0.200
    86.330    -1.449     0.200
    86.465     0.687     0.200
    86.707    -0.299     0.200
    86.890     0.505     0.200
    86.900    -0.445     0.200
    86.971     0.510     0.200
    87.345    -0.007     0.200
    87.626     0.446     0.200
    88.531    -0.051     0.200
    88.720     0.060     0.200
    90.635     3.102     0.200
    92.980     1.249     0.200
    44.270    -0.122     0.200
    49.396    -0.201     0.200
    51.350     0.025     0.200
    60.711    -1.522     0.200
    60.808    -1.582     0.200
    62.430    -1.421     0.200
    62.246    -0.787     0.200
    62.764    -0.548     0.200
    63.940    -1.430     0.200
    65.088    -1.732     0.200
    65.981    -1.305     0.200
    68.861    -1.923     0.200
    69.508    -1.429     0.200
    69.743    -1.346     0.200
    69.900    -1.244     0.200
    69.914    -1.228     0.200
    78.763     0.467     0.200
    80.526     1.391     0.200
    83.841    -0.872     0.200
    84.390    -0.666     0.200
    84.427    -0.554     0.200
    85.187    -0.079     0.200
    86.251    -0.661     0.200
    86.299    -0.697     0.200
    86.495     0.339     0.200
    41.205     0.183     0.200
    44.170     1.121     0.200
    62.405    -0.735     0.200
    62.407    -0.544     0.200
    63.754    -1.786     0.200
    69.321    -1.383     0.200
    69.556    -1.733     0.200
    69.713    -1.382     0.200
    69.727    -0.967     0.200
    44.029     0.279     0.200
    44.105    -0.033     0.200
    51.196    -2.273     0.200
    57.026    -1.420     0.200
    62.543    -1.606     0.200
    62.669    -0.442     0.200
    64.057    -1.718     0.200
    66.105    -1.902     0.200
    69.607    -1.508     0.200
    69.840    -1.500     0.200
    70.000    -1.524     0.200
    70.004    -1.551     0.200
    70.305    -1.668     0.200
    83.954    -0.704     0.200
    84.163    -0.562     0.200
    84.505    -0.293     0.200
    84.540    -0.377     0.200
    85.298     0.317     0.200
    18.519    -4.441     0.200
    18.519    -4.140     0.200
    20.195    -3.220     0.200
    20.781    -2.851     0.200
    21.369    -1.373     0.200
    21.369    -0.474     0.200
    21.516    -0.950     0.200
    21.516    -0.552     0.200
    28.269    -0.579     0.200
    28.269    -0.379     0.200
    32.452    -0.301     0.200
    41.307     1.342     0.200
    42.862    -1.327     0.200
    43.818     0.976     0.200
    62.322     1.092     0.200
    62.323     1.283     0.200
    63.897    -1.345     0.200
    65.940    -1.213     0.200
    68.315    -1.864     0.200
    69.461    -1.335     0.200
    69.853    -1.295     0.200
    21.577    -2.604     0.200
    21.577    -2.104     0.200
    39.707    -1.962     0.200
    39.707    -1.262     0.200
    41.030     1.090     0.200
    41.874    -0.024     0.200
    43.554     0.548     0.200
    44.349     0.162     0.200
    44.349     0.262     0.200
    49.451    -1.696     0.200
    51.356    -1.594     0.200
    53.125    -0.228     0.200
    60.555    -1.909     0.200
    62.264    -1.457     0.200
    62.277    -1.044     0.200
    62.278    -1.152     0.200
    63.771    -1.667     0.200
    64.829    -0.392     0.200
    67.711     0.144     0.200
    68.947    -0.595     0.200
    69.090     0.518     0.200
    69.038    -0.658     0.200
    69.349    -1.583     0.200
    69.740    -1.498     0.200
    69.923     0.677     0.200
    70.045    -1.370     0.200
    70.049    -1.945     0.200
    71.571    -1.646     0.200
    80.666     0.616     0.200
    18.545    -1.422     0.200
    18.545    -1.223     0.200
    19.446    -2.283     0.200
    20.188    -0.353     0.200
    20.544    -2.206     0.200
    20.769    -3.236     0.200
    21.542    -2.931     0.200
    21.542    -2.331     0.200
    21.575    -3.083     0.200
    23.675    -2.831     0.200
    24.008    -4.872     0.200
    24.008    -4.673     0.200
    24.601    -1.975     0.200
    25.600    -1.843     0.200
    26.392    -0.006     0.200
    27.772    -0.889     0.200
    27.765    -0.324     0.200
    28.275    -0.970     0.200
    28.583     4.088     0.200
    29.757     0.080     0.200
    30.340    -4.672     0.200
    30.340    -4.172     0.200
    30.667    -1.056     0.200
    31.068    -0.093     0.200
    32.448    -0.113     0.200
    32.895    -2.118     0.200
    33.093    -1.051     0.200
    33.461    -0.054     0.200
    34.063    -0.581     0.200
    37.080     0.847     0.200
    38.696    -1.273     0.200
    38.989    -4.925     0.200
    39.742     0.005     0.200
    39.945    -2.182     0.200
    39.945    -1.483     0.200
    40.262    -1.106     0.200
    40.630     0.351     0.200
    41.296    -1.825     0.200
    43.066     1.976     0.200
    43.803     0.343     0.200
    43.949    -0.328     0.200
    44.213     0.056     0.200
    44.213     0.056     0.200
    44.815     0.756     0.200
    44.946     2.210     0.200
    46.588     0.270     0.200
    48.441     0.087     0.200
    48.465     0.109     0.200
    48.648    -0.696     0.200
    48.648    -0.497     0.200
    49.015    -1.509     0.200
    49.015    -0.708     0.200
    49.339    -0.987     0.200
    51.295    -0.767     0.200
    51.424    -0.424     0.200
    52.115     0.127     0.200
    52.830     0.333     0.200
    53.328    -0.827     0.200
    53.328    -0.327     0.200
    53.507    -0.143     0.200
    53.925    -0.398     0.200
    54.894    -1.031     0.200
    54.936    -1.035     0.200
    55.525    -0.276     0.200
    55.566    -1.071     0.200
    55.566    -0.472     0.200
    55.793     1.304     0.200
    57.100     1.011     0.200
    58.840     0.129     0.200
    58.900    -0.588     0.200
    59.054    -0.653     0.200
    59.550    -0.075     0.200
    60.765    -1.389     0.200
    62.383     0.711     0.200
    62.353    -0.085     0.200
    62.803     0.913     0.200
    63.769     1.024     0.200
    64.672    -0.183     0.200
    65.958    -1.701     0.200
    66.026     1.862     0.200
    67.117     0.900     0.200
    67.175     1.231     0.200
    67.548     0.178     0.200
    68.323    -1.687     0.200
    68.307     0.711     0.200
    68.429     0.549     0.200
    68.814    -0.749     0.200
    68.931    -0.480     0.200
    69.302     1.027     0.200
    69.480    -1.276     0.200
    69.715    -1.202     0.200
    69.744     1.100     0.200
    69.872    -1.288     0.200
    70.170    -0.712     0.200
    70.180    -1.460     0.200
    70.068     0.812     0.200
    73.120     0.154     0.200
    73.306     1.061     0.200
    73.760     1.396     0.200
    75.462     0.537     0.200
    75.786     0.688     0.200
    76.402     0.189     0.200
    77.075     1.894     0.200
    77.831     2.171     0.200
    77.983     1.330     0.200
    78.082     0.278     0.200
    78.742     0.142     0.200
    80.128     0.602     0.200
    80.500    -0.098     0.200
    80.468     1.774     0.200
    80.470     0.762     0.200
    80.932    -0.005     0.200
    80.983     1.324     0.200
    81.952    -0.896     0.200
    81.952     1.305     0.200
    85.099     2.770     0.200
    85.611     0.718     0.200
    85.810     0.732     0.200
    85.969     0.246     0.200
    18.494    -4.035     0.200
    19.379    -2.736     0.200
    19.379    -1.835     0.200
    21.323    -2.846     0.200
    21.323    -2.647     0.200
    21.491    -2.655     0.200
    21.491    -1.956     0.200
    25.584     1.493     0.200
    32.403     0.194     0.200
    32.857    -1.676     0.200
    36.659     0.676     0.200
    38.632    -1.220     0.200
    38.632    -0.720     0.200
    39.687     1.262     0.200
    40.605     0.246     0.200
    41.714    -0.371     0.200
    42.660    -0.293     0.200
    43.788     0.395     0.200
    43.925    -0.210     0.200
    44.184     0.212     0.200
    44.184     0.212     0.200
    48.428     0.253     0.200
    48.632     0.281     0.200
    49.304     0.123     0.200
    51.250    -0.608     0.200
    51.367    -0.492     0.200
    51.367     0.309     0.200
    52.047    -0.569     0.200
    53.185     0.005     0.200
    53.260    -0.547     0.200
    53.882    -0.107     0.200
    54.838    -1.066     0.200
    54.838    -0.367     0.200
    54.879    -1.362     0.200
    58.809     0.055     0.200
    58.869    -0.663     0.200
    58.986    -2.477     0.200
    59.519    -0.163     0.200
    60.614    -1.581     0.200
    60.703    -2.087     0.200
    62.326     0.751     0.200
    62.332    -2.288     0.200
    62.336    -1.313     0.200
    63.754     0.766     0.200
    63.846    -1.342     0.200
    64.649    -0.106     0.200
    64.960     0.363     0.200
    64.992    -1.841     0.200
    65.708     0.920     0.200
    65.888    -1.544     0.200
    67.171     1.159     0.200
    67.527    -0.097     0.200
    67.882     0.666     0.200
    68.259    -0.707     0.200
    68.291     0.693     0.200
    68.425     0.257     0.200
    68.785     0.010     0.200
    68.895    -1.180     0.200
    69.412    -1.432     0.200
    69.646    -1.331     0.200
    69.728     1.264     0.200
    69.804    -1.300     0.200
    70.102    -1.731     0.200
    70.065     0.895     0.200
    71.478    -0.603     0.200
    72.726     1.022     0.200
    73.291     0.872     0.200
    75.037    -1.214     0.200
    75.275     0.414     0.200
    75.393    -1.265     0.200
    75.717    -0.420     0.200
    76.250    -0.459     0.200
    77.007     1.262     0.200
    77.123    -0.393     0.200
    77.609     0.483     0.200
    77.749     2.103     0.200
    78.672    -0.211     0.200
    80.081    -0.195     0.200
    80.458     1.274     0.200
    80.460     1.063     0.200
    85.593     0.203     0.200
    85.791     0.619     0.200
    85.950     0.429     0.200
    86.803    -0.263     0.200
    87.539     0.664     0.200
    18.371    -2.919     0.200
    18.371    -2.618     0.200
    19.473    -3.969     0.200
    19.473    -3.168     0.200
    20.366    -3.163     0.200
    20.771     0.479     0.200
    20.972    -2.587     0.200
    21.314    -4.548     0.200
    21.369    -3.642     0.200
    21.796     0.004     0.200
    23.570    -0.010     0.200
    23.862    -0.671     0.200
    24.020    -4.112     0.200
    24.767     0.086     0.200
    25.818    -1.940     0.200
    27.963    -0.697     0.200
    28.365    -0.672     0.200
    29.838    -0.629     0.200
    30.848     0.751     0.200
    32.607     0.307     0.200
    32.690    -2.419     0.200
    33.294    -0.284     0.200
    33.677     0.184     0.200
    37.294     0.981     0.200
    38.763    -1.978     0.200
    38.952    -4.961     0.200
    38.952    -4.261     0.200
    39.863    -0.540     0.200
    40.025    -0.578     0.200
    41.527    -0.242     0.200
    41.495     1.021     0.200
    43.724    -0.340     0.200
    43.994    -0.099     0.200
    43.994     0.299     0.200
    44.022     1.078     0.200
    44.022     1.277     0.200
    45.036     0.497     0.200
    45.172     2.717     0.200
    48.622     0.725     0.200
    48.646     0.541     0.200
    48.765    -0.570     0.200
    48.765     0.031     0.200
    48.849     0.780     0.200
    49.129    -0.554     0.200
    51.108    -1.824     0.200
    51.538    -0.538     0.200
    51.538     0.064     0.200
    53.060     1.386     0.200
    53.355    -0.479     0.200
    53.350    -0.940     0.200
    53.350    -0.139     0.200
    53.633    -0.008     0.200
    53.633     0.093     0.200
    53.620     3.584     0.200
    54.089    -0.338     0.200
    55.011    -1.013     0.200
    55.011    -0.513     0.200
    55.676    -0.794     0.200
    55.676    -0.692     0.200
    55.755     0.841     0.200
    55.971     1.598     0.200
    57.331     1.659     0.200
    58.625     0.007     0.200
    58.685    -0.511     0.200
    58.994    -1.147     0.200
    59.744     0.185     0.200
    60.630    -1.874     0.200
    60.644    -2.265     0.200
    62.060    -1.721     0.200
    62.364    -1.555     0.200
    62.331     0.164     0.200
    62.331     0.363     0.200
    62.149     2.484     0.200
    62.492    -0.907     0.200
    62.492    -0.407     0.200
    62.493     0.191     0.200
    62.537    -0.206     0.200
    62.462     0.896     0.200
    63.002     0.202     0.200
    63.540     0.145     0.200
    63.878    -1.471     0.200
    64.273     0.336     0.200
    64.447     0.202     0.200
    64.682    -1.333     0.200
    65.011    -2.073     0.200
    65.925    -1.468     0.200
    66.191     1.930     0.200
    67.322     0.238     0.200
    68.080    -1.533     0.200
    68.078     1.081     0.200
    68.393     1.010     0.200
    68.596    -0.253     0.200
    68.723    -1.045     0.200
    68.794    -1.685     0.200
    69.073     1.085     0.200
    69.431    -1.797     0.200
    69.515     1.452     0.200
    69.664    -1.726     0.200
    69.823    -1.741     0.200
    69.830    -1.681     0.200
    70.129    -1.877     0.200
    71.348    -1.115     0.200
    72.498     1.002     0.200
    73.077     1.376     0.200
    75.067     0.777     0.200
    75.452    -0.030     0.200
    75.777    -0.091     0.200
    76.396    -0.604     0.200
    76.369     2.849     0.200
    76.699     0.086     0.200
    77.086     1.510     0.200
    77.164    -1.124     0.200
    77.169    -0.953     0.200
    77.169    -0.555     0.200
    77.656     0.024     0.200
    77.656     0.126     0.200
    78.070    -0.773     0.200
    78.211    -0.751     0.200
    78.389    -0.531     0.200
    78.304     3.633     0.200
    78.720    -0.051     0.200
    78.548     1.393     0.200
    78.976    -0.153     0.200
    79.141     0.141     0.200
    79.942    -0.205     0.200
    80.240     1.194     0.200
    80.771    -1.255     0.200
    80.950    -0.206     0.200
    81.072    -0.752     0.200
    81.222    -0.549     0.200
    81.256    -0.430     0.200
    81.557    -0.020     0.200
    81.625    -0.280     0.200
    81.745    -1.809     0.200
    81.966    -0.369     0.200
    82.022    -1.261     0.200
    82.242    -0.312     0.200
    82.290    -0.964     0.200
    82.332    -1.385     0.200
    83.008    -1.192     0.200
    83.569    -0.275     0.200
    83.750    -0.701     0.200
    83.775    -0.433     0.200
    83.808    -0.601     0.200
    83.854    -0.629     0.200
    83.984    -0.496     0.200
    84.073    -0.450     0.200
    84.255    -0.370     0.200
    84.326    -0.328     0.200
    84.361    -0.308     0.200
    84.629    -0.261     0.200
    85.120     0.077     0.200
    85.178    -0.113     0.200
    85.144     3.758     0.200
    85.432    -0.279     0.200
    85.383     1.367     0.200
    85.644     0.168     0.200
    85.583     0.775     0.200
    85.741     0.889     0.200
    86.005    -0.817     0.200
    86.231    -0.329     0.200
    86.251    -0.626     0.200
    86.275     0.156     0.200
    86.430     0.696     0.200
    86.851     0.537     0.200
    86.934     0.535     0.200
    87.319     0.268     0.200
    88.498     0.669     0.200
    88.684    -0.205     0.200
    19.306    -0.793     0.200
    21.306    -3.502     0.200
    21.540    -3.014     0.200
    23.874    -4.167     0.200
    28.114    -1.499     0.200
    32.933    -2.050     0.200
    41.803    -0.483     0.200
    43.982    -0.035     0.200
    44.277    -0.197     0.200
    44.277     0.104     0.200
    49.387    -1.157     0.200
    51.310    -1.205     0.200
    54.910    -1.718     0.200
    58.896     0.129     0.200
    58.956    -0.389     0.200
    60.714    -1.675     0.200
    62.297    -1.665     0.200
    62.308    -1.035     0.200
    62.309    -0.641     0.200
    62.643     0.025     0.200
    62.699    -2.349     0.200
    63.863    -0.057     0.200
    64.750    -0.065     0.200
    64.958    -1.724     0.200
    68.876    -0.149     0.200
    69.770    -1.681     0.200
    69.786    -0.981     0.200
    69.837     0.906     0.200
    76.200     0.250     0.200
    80.575     1.083     0.200
    84.256    -0.530     0.200
    84.294    -0.425     0.200
    85.054     0.144     0.200
    85.370    -0.137     0.200
    85.699     1.025     0.200
    85.896     0.648     0.200
    86.877    -1.173     0.200
    87.361    -0.127     0.200
    13.289    11.478     0.200
    18.077    -3.711     0.200
    19.549    -4.796     0.200
    19.549    -3.898     0.200
    20.701    -1.761     0.200
    21.078    -3.211     0.200
    21.179    -1.399     0.200
    21.346    -2.783     0.200
    22.197    -2.237     0.200
    23.885    -1.745     0.200
    24.067    -4.411     0.200
    24.067    -3.614     0.200
    24.210    -0.708     0.200
    25.080    -0.623     0.200
    25.073     2.446     0.200
    26.215     0.114     0.200
    27.035     2.239     0.200
    28.004    -1.914     0.200
    28.329     0.198     0.200
    28.549    -0.357     0.200
    30.004    -0.250     0.200
    31.186     0.929     0.200
    31.731     2.146     0.200
    32.336    -2.164     0.200
    32.628     1.282     0.200
    32.909     0.536     0.200
    33.663     1.065     0.200
    34.071     0.731     0.200
    34.310    -1.532     0.200
    35.208     1.636     0.200
    36.086    -0.085     0.200
    37.684     1.364     0.200
    38.910    -4.425     0.200
    38.910    -4.027     0.200
    38.905    -1.383     0.200
    38.732     3.057     0.200
    40.016     0.079     0.200
    40.100    -0.315     0.200
    40.189    -1.055     0.200
    40.440    -1.229     0.200
    41.148    -0.649     0.200
    42.042    -0.753     0.200
    43.112    -1.311     0.200
    43.286    -0.714     0.200
    43.592     1.722     0.200
    43.610     0.374     0.200
    43.610    -0.025     0.200
    44.223     2.466     0.200
    44.420     0.201     0.200
    44.917     2.648     0.200
    45.331     0.072     0.200
    45.437     1.527     0.200
    45.580     3.398     0.200
    46.974     0.973     0.200
    47.423    -0.017     0.200
    47.428    -0.056     0.200
    47.159     1.830     0.200
    47.600     0.615     0.200
    48.072     2.765     0.200
    48.762    -0.831     0.200
    48.993    -0.102     0.200
    48.957     0.775     0.200
    48.983     0.581     0.200
    49.185     0.829     0.200
    49.339    -0.738     0.200
    49.339    -0.339     0.200
    49.848     0.397     0.200
    50.786    -1.185     0.200
    51.762    -0.183     0.200
    51.653     2.833     0.200
    52.031     0.122     0.200
    53.562    -1.258     0.200
    53.562    -0.657     0.200
    53.473     1.894     0.200
    53.876     0.052     0.200
    53.973    -0.656     0.200
    54.032     2.714     0.200
    54.398    -0.346     0.200
    54.879    -0.621     0.200
    55.240    -0.022     0.200
    55.893    -1.101     0.200
    56.168     1.540     0.200
    57.662     2.381     0.200
    57.743     1.813     0.200
    58.126     0.135     0.200
    58.249    -0.025     0.200
    58.310    -1.147     0.200
    58.383    -1.258     0.200
    58.907    -0.696     0.200
    59.575     2.596     0.200
    60.101     0.489     0.200
    60.445    -1.653     0.200
    61.403     0.652     0.200
    62.314    -1.460     0.200
    62.357     2.652     0.200
    62.357     2.550     0.200
    62.693    -0.685     0.200
    62.707     0.126     0.200
    62.879    -0.714     0.200
    62.743     0.890     0.200
    63.076    -0.319     0.200
    63.134     0.594     0.200
    63.282     0.113     0.200
    63.369    -1.559     0.200
    63.398    -1.649     0.200
    63.379     1.371     0.200
    63.833    -1.613     0.200
    63.851    -1.634     0.200
    64.050     0.062     0.200
    64.321    -0.712     0.200
    64.497    -0.258     0.200
    64.712    -1.458     0.200
    64.945    -1.875     0.200
    65.088     1.299     0.200
    65.515     2.045     0.200
    65.566     0.216     0.200
    65.889    -1.963     0.200
    66.289     1.572     0.200
    66.532     1.227     0.200
    66.472     3.410     0.200
    66.803     0.297     0.200
    66.922    -0.059     0.200
    67.224    -0.371     0.200
    67.243     1.510     0.200
    67.816     0.106     0.200
    67.786     0.693     0.200
    68.213    -0.587     0.200
    68.325     0.714     0.200
    68.360    -1.505     0.200
    68.540    -0.628     0.200
    68.741    -1.980     0.200
    68.903     0.116     0.200
    68.881     0.460     0.200
    69.046     1.231     0.200
    69.109     1.140     0.200
    69.425     1.390     0.200
    69.752    -1.326     0.200
    69.916     0.872     0.200
    69.925    -1.179     0.200
    69.745     2.217     0.200
    70.118     1.635     0.200
    70.108     2.800     0.200
    70.478    -0.560     0.200
    70.925    -0.274     0.200
    71.042    -1.483     0.200
    71.177     1.200     0.200
    71.175     1.216     0.200
    71.357    -0.881     0.200
    71.358     0.113     0.200
    71.893    -0.897     0.200
    72.562     1.514     0.200
    72.573     1.448     0.200
    73.122    -0.400     0.200
    73.117     1.626     0.200
    73.752    -0.098     0.200
    73.783    -0.281     0.200
    73.908    -1.014     0.200
    74.147    -0.301     0.200
    74.173     0.146     0.200
    74.471    -0.991     0.200
    74.779    -0.065     0.200
    74.837    -0.400     0.200
    75.422    -0.764     0.200
    75.454    -0.548     0.200
    75.554    -1.516     0.200
    75.554    -1.117     0.200
    75.600    -0.277     0.200
    75.600    -0.379     0.200
    75.898    -0.477     0.200
    75.998     1.556     0.200
    75.741     1.416     0.200
    76.071     1.641     0.200
    76.248    -0.463     0.200
    76.248     1.537     0.200
    76.284     0.034     0.200
    76.369    -2.150     0.200
    76.409    -0.374     0.200
    76.425     0.535     0.200
    76.425     0.738     0.200
    76.801    -0.088     0.200
    76.570     3.315     0.200
    76.863     2.063     0.200
    77.129     0.573     0.200
    77.135    -0.563     0.200
    77.145     0.378     0.200
    77.079     1.350     0.200
    77.201    -0.829     0.200
    77.127     1.082     0.200
    77.367    -0.761     0.200
    77.614    -0.135     0.200
    77.639    -0.276     0.200
    77.836    -0.372     0.200
    78.011     1.662     0.200
    78.071    -0.772     0.200
    78.180    -0.273     0.200
    78.180     0.227     0.200
    78.480    -0.931     0.200
    78.667    -0.458     0.200
    78.674    -2.997     0.200
    78.702    -0.048     0.200
    78.955     0.064     0.200
    79.112     0.106     0.200
    79.360     0.258     0.200
    79.623    -0.775     0.200
    79.727     0.268     0.200
    79.828     0.920     0.200
    80.009    -0.755     0.200
    80.118     0.654     0.200
    80.262    -0.617     0.200
    80.363    -0.057     0.200
    80.473    -0.249     0.200
    80.473     1.251     0.200
    80.657     0.471     0.200
    80.662     0.036     0.200
    80.967    -0.384     0.200
    80.983    -1.468     0.200
    80.984     0.625     0.200
    81.006     0.406     0.200
    81.004    -0.183     0.200
    81.015    -1.036     0.200
    81.043     0.211     0.200
    81.109     0.863     0.200
    81.145    -0.227     0.200
    81.254    -0.205     0.200
    81.429    -1.832     0.200
    81.539     0.088     0.200
    81.585    -0.656     0.200
    81.713    -1.326     0.200
    81.794    -0.552     0.200
    81.983    -1.248     0.200
    81.979    -0.930     0.200
    81.990    -0.781     0.200
    82.014    -0.704     0.200
    82.055    -0.023     0.200
    82.134    -0.139     0.200
    82.178    -0.561     0.200
    82.250    -0.541     0.200
    82.269    -0.538     0.200
    82.306    -0.432     0.200
    82.621     0.226     0.200
    82.784    -0.916     0.200
    82.983    -0.848     0.200
    83.200     0.932     0.200
    83.363     0.394     0.200
    83.538    -0.098     0.200
    83.718     0.076     0.200
    83.725    -0.657     0.200
    83.898     0.858     0.200
    84.022    -0.373     0.200
    84.034     1.668     0.200
    84.181     0.026     0.200
    84.278    -0.364     0.200
    84.310    -0.530     0.200
    84.555     0.132     0.200
    84.608    -0.736     0.200
    84.680     0.104     0.200
    84.974    -0.072     0.200
    85.068     0.060     0.200
    85.074    -0.071     0.200
    84.980     1.899     0.200
    85.111     0.741     0.200
    85.125    -0.324     0.200
    85.141    -1.909     0.200
    85.180     0.101     0.200
    85.340    -0.001     0.200
    85.375    -0.278     0.200
    85.579    -0.085     0.200
    85.708     0.276     0.200
    85.981    -0.869     0.200
    86.018     0.542     0.200
    86.177    -0.440     0.200
    86.227    -0.582     0.200
    86.380     0.464     0.200
    86.588     0.740     0.200
    86.795     0.333     0.200
    86.881     0.516     0.200
    86.909     0.176     0.200
    87.838     0.317     0.200
    87.889     0.474     0.200
    88.130     0.241     0.200
    88.632     0.964     0.200
    88.783    -0.243     0.200
    89.540     1.206     0.200
    89.817     1.619     0.200
    90.215     1.262     0.200
    90.561     0.149     0.200
    92.872     1.458     0.200
    44.276    -0.225     0.200
    49.373    -0.283     0.200
    65.732    -1.453     0.200
    69.269    -1.604     0.200
    69.504    -1.459     0.200
    69.661    -1.523     0.200
    69.679    -1.534     0.200
    69.969    -1.721     0.200
    18.459    -2.446     0.200
    18.459    -2.048     0.200
    20.437    -2.505     0.200
    20.785    -1.663     0.200
    21.022    -2.516     0.200
    21.458    -3.489     0.200
    21.822    -1.975     0.200
    23.649    -0.484     0.200
    23.926    -1.916     0.200
    24.142    -3.986     0.200
    24.142    -3.588     0.200
    25.849    -0.489     0.200
    27.960    -1.447     0.200
    28.018    -1.266     0.200
    28.474    -0.726     0.200
    29.949    -0.203     0.200
    30.346    -3.604     0.200
    30.917     0.359     0.200
    32.756    -2.787     0.200
    32.690     0.595     0.200
    33.711    -0.109     0.200
    34.778     2.261     0.200
    37.332     0.844     0.200
    38.877    -0.961     0.200
    39.075    -4.412     0.200
    39.962    -0.194     0.200
    40.137    -0.937     0.200
    41.140    -1.403     0.200
    41.579    -0.301     0.200
    42.474    -0.295     0.200
    43.060    -1.144     0.200
    43.316     2.093     0.200
    43.763    -0.197     0.200
    44.042     0.166     0.200
    44.051     0.989     0.200
    45.024     0.334     0.200
    45.062     0.934     0.200
    45.188     2.536     0.200
    45.360     2.577     0.200
    46.805    -0.283     0.200
    46.805     0.116     0.200
    47.890    -1.715     0.200
    47.816     1.857     0.200
    48.691     0.819     0.200
    48.714     0.439     0.200
    48.865    -1.219     0.200
    48.865    -0.418     0.200
    48.919     0.675     0.200
    49.188    -0.682     0.200
    49.227    -0.985     0.200
    49.227    -0.184     0.200
    51.187    -1.004     0.200
    51.640    -0.186     0.200
    51.640     0.013     0.200
    52.263    -0.522     0.200
    52.672     0.253     0.200
    53.058     2.309     0.200
    53.476    -0.460     0.200
    53.454    -1.600     0.200
    53.454    -1.401     0.200
    53.609     2.768     0.200
    53.730    -0.621     0.200
    53.730    -0.121     0.200
    54.169    -0.817     0.200
    54.743    -1.981     0.200
    54.743    -1.582     0.200
    54.885    -1.510     0.200
    55.754     1.241     0.200
    55.779    -0.640     0.200
    57.322     1.108     0.200
    58.679     0.012     0.200
    58.691    -0.172     0.200
    58.739    -0.304     0.200
    59.114    -1.405     0.200
    59.802    -0.144     0.200
    60.753    -2.136     0.200
    60.752    -1.528     0.200
    62.181    -1.766     0.200
    62.437     2.521     0.200
    62.487    -1.809     0.200
    62.370     0.673     0.200
    62.371     0.664     0.200
    62.596     0.064     0.200
    62.603     0.016     0.200
    63.056    -1.395     0.200
    63.115    -0.984     0.200
    63.565     0.743     0.200
    63.946    -1.462     0.200
    64.000    -1.621     0.200
    64.375    -0.074     0.200
    64.484     0.016     0.200
    64.805    -1.576     0.200
    65.133    -2.107     0.200
    65.519     1.097     0.200
    65.931     3.445     0.200
    66.048    -1.503     0.200
    66.098     1.571     0.200
    66.950     1.441     0.200
    67.356     0.568     0.200
    67.661     0.941     0.200
    68.176    -0.595     0.200
    68.202     0.743     0.200
    68.507    -1.660     0.200
    68.645     0.482     0.200
    68.636     0.035     0.200
    68.784    -1.387     0.200
    68.916    -1.808     0.200
    69.182     0.146     0.200
    69.540     1.337     0.200
    69.553    -1.531     0.200
    69.786    -1.438     0.200
    69.840     1.591     0.200
    69.864     1.445     0.200
    69.945    -1.454     0.200
    69.951    -1.289     0.200
    70.251    -1.556     0.200
    70.261     2.515     0.200
    70.944     1.858     0.200
    71.433    -1.596     0.200
    71.597     1.615     0.200
    72.251     1.501     0.200
    72.498     1.025     0.200
    73.099     0.664     0.200
    73.236    -1.341     0.200
    73.529     1.933     0.200
    73.773     1.503     0.200
    74.902    -0.754     0.200
    75.002     1.372     0.200
    75.098     0.215     0.200
    75.242     0.886     0.200
    75.575    -0.417     0.200
    75.900    -0.175     0.200
    76.113     0.816     0.200
    76.422     0.265     0.200
    76.519    -0.286     0.200
    77.287    -0.904     0.200
    77.292    -0.831     0.200
    77.509     1.153     0.200
    77.557     1.886     0.200
    77.780    -0.050     0.200
    78.334    -0.423     0.200
    78.704    -0.462     0.200
    78.763    -0.679     0.200
    78.845    -0.733     0.200
    78.843     0.279     0.200
    79.099    -0.021     0.200
    79.264    -0.026     0.200
    79.798     0.578     0.200
    80.023    -0.638     0.200
    80.185    -1.014     0.200
    80.294    -0.298     0.200
    80.301     0.863     0.200
    80.508    -0.147     0.200
    80.606     0.231     0.200
    80.890    -0.489     0.200
    81.071    -0.253     0.200
    81.119     0.297     0.200
    81.146    -0.649     0.200
    81.194    -0.903     0.200
    81.461     0.285     0.200
    81.488    -0.657     0.200
    81.554    -1.309     0.200
    81.680    -0.076     0.200
    81.748    -0.431     0.200
    81.868    -1.062     0.200
    81.957    -0.926     0.200
    81.991    -0.406     0.200
    82.088    -0.216     0.200
    82.144    -0.910     0.200
    82.166    -0.324     0.200
    82.339    -0.928     0.200
    82.413    -0.810     0.200
    82.417    -0.636     0.200
    82.455    -0.634     0.200
    82.598    -0.273     0.200
    83.131    -1.034     0.200
    83.514    -0.305     0.200
    83.898    -0.468     0.200
    83.930    -0.733     0.200
    83.975    -0.663     0.200
    84.106    -0.729     0.200
    84.132    -0.261     0.200
    84.196    -0.583     0.200
    84.376    -0.499     0.200
    84.448    -0.562     0.200
    84.484    -0.542     0.200
    84.751    -0.184     0.200
    84.739     1.076     0.200
    85.243     0.251     0.200
    85.301    -0.141     0.200
    85.412     0.804     0.200
    85.511     0.412     0.200
    85.554    -0.200     0.200
    85.613     0.806     0.200
    85.766     0.148     0.200
    85.771     0.225     0.200
    86.129    -0.144     0.200
    86.128    -0.742     0.200
    86.326    -0.311     0.200
    86.374    -0.549     0.200
    86.397     0.235     0.200
    86.451     0.772     0.200
    86.553     0.577     0.200
    86.706    -0.576     0.200
    86.973     0.523     0.200
    87.073     0.639     0.200
    87.268    -0.506     0.200
    87.336     0.969     0.200
    88.255     0.094     0.200
    43.916     0.859     0.200
    49.055     0.047     0.200
    51.045    -0.549     0.200
    60.622    -2.176     0.200
    62.361    -1.917     0.200
    63.456     0.799     0.200
    63.875    -1.464     0.200
    65.924    -2.299     0.200
    43.880     0.905     0.200
    48.696     0.692     0.200
    63.837    -1.831     0.200
    65.887    -1.163     0.200
    69.778    -1.938     0.200
    69.781    -1.657     0.200
    18.488    -3.396     0.200
    18.488    -2.693     0.200
    19.595    -1.496     0.200
    20.414    -2.885     0.200
    20.995    -3.251     0.200
    21.449    -5.521     0.200
    21.487    -3.531     0.200
    23.628    -1.023     0.200
    23.902    -3.024     0.200
    24.145    -4.647     0.200
    24.145    -3.749     0.200
    24.616     1.062     0.200
    24.824    -0.227     0.200
    25.818    -1.841     0.200
    26.587     0.717     0.200
    27.991    -1.357     0.200
    28.466    -0.878     0.200
    28.577    -0.464     0.200
    29.942    -0.669     0.200
    29.942    -0.271     0.200
    30.366    -5.415     0.200
    30.366    -5.017     0.200
    30.893     0.438     0.200
    31.272     2.205     0.200
    32.161     1.792     0.200
    32.670     0.439     0.200
    32.789    -1.703     0.200
    33.319    -0.431     0.200
    33.681    -0.077     0.200
    36.444     2.153     0.200
    37.285     0.816     0.200
    37.302     0.466     0.200
    37.635     2.753     0.200
    38.873    -1.148     0.200
    39.086    -3.326     0.200
    39.949    -0.414     0.200
    40.130    -0.810     0.200
    40.431    -1.404     0.200
    43.054    -1.117     0.200
    43.292     0.756     0.200
    44.076    -0.339     0.200
    44.020     1.006     0.200
    44.998    -0.289     0.200
    46.792    -0.814     0.200
    46.792    -0.415     0.200
    47.296    -0.140     0.200
    47.301    -0.177     0.200
    48.668     0.670     0.200
    48.691     0.491     0.200
    48.853    -0.750     0.200
    48.853    -0.547     0.200
    48.895     0.925     0.200
    49.221    -0.567     0.200
    49.216    -0.527     0.200
    52.652     0.271     0.200
    53.024     1.633     0.200
    53.443    -1.147     0.200
    53.477    -0.398     0.200
    53.574     2.093     0.200
    53.716    -0.248     0.200
    54.148    -0.796     0.200
    54.729    -0.513     0.200
    54.729    -0.216     0.200
    54.911    -1.830     0.200
    55.099    -0.783     0.200
    55.720     1.151     0.200
    55.768    -1.986     0.200
    55.768    -1.588     0.200
    57.269     1.352     0.200
    58.713     0.351     0.200
    58.896    -1.525     0.200
    59.129    -1.031     0.200
    59.777    -0.096     0.200
    60.765    -1.550     0.200
    60.775    -2.317     0.200
    60.781    -0.956     0.200
    61.298    -0.956     0.200
    62.498    -1.513     0.200
    62.341     0.738     0.200
    62.588    -1.111     0.200
    62.588    -1.010     0.200
    62.585     0.207     0.200
    63.029     0.056     0.200
    63.090    -0.450     0.200
    63.951    -0.123     0.200
    64.011    -1.817     0.200
    64.470    -1.521     0.200
    64.518     0.161     0.200
    64.810    -1.736     0.200
    65.146    -1.716     0.200
    65.211    -0.341     0.200
    65.554     0.443     0.200
    66.058    -1.595     0.200
    68.204    -1.394     0.200
    68.323    -0.140     0.200
    68.627    -0.036     0.200
    68.679    -0.360     0.200
    68.928    -1.907     0.200
    69.176     0.351     0.200
    69.491     1.511     0.200
    69.890     0.153     0.200
    69.958    -1.659     0.200
    70.486    -0.492     0.200
    70.486    -0.093     0.200
    71.219     0.065     0.200
    71.463    -0.406     0.200
    71.631     1.581     0.200
    71.844    -0.699     0.200
    72.983     1.522     0.200
    73.242    -0.009     0.200
    73.857    -0.217     0.200
    73.807     1.676     0.200
    74.018     1.444     0.200
    74.345    -0.359     0.200
    75.241     1.365     0.200
    75.582    -0.485     0.200
    75.664    -1.057     0.200
    75.676     0.874     0.200
    76.119     0.552     0.200
    76.325    -0.819     0.200
    76.325     0.181     0.200
    76.430    -0.412     0.200
    76.237     3.382     0.200
    76.922     3.816     0.200
    77.296    -0.489     0.200
    77.301    -0.312     0.200
    77.764     0.108     0.200
    77.788    -0.028     0.200
    78.344    -0.606     0.200
    78.344    -0.707     0.200
    78.521    -0.380     0.200
    78.720    -0.380     0.200
    78.767    -0.934     0.200
    78.851     0.204     0.200
    78.851     0.306     0.200
    78.857    -0.426     0.200
    79.123    -0.181     0.200
    79.274     0.090     0.200
    79.264    -0.256     0.200
    79.418     0.006     0.200
    79.702     0.468     0.200
    79.801    -0.067     0.200
    80.197    -0.205     0.200
    80.271     0.100     0.200
    80.306     0.007     0.200
    80.304     0.221     0.200
    80.517    -0.223     0.200
    80.614     0.262     0.200
    80.978    -0.386     0.200
    81.044    -0.836     0.200
    81.074    -0.193     0.200
    81.064    -0.343     0.200
    81.122     0.553     0.200
    81.206    -0.595     0.200
    81.231    -0.227     0.200
    81.562    -0.680     0.200
    81.758    -0.717     0.200
    81.863    -0.562     0.200
    81.878    -0.938     0.200
    82.000     0.013     0.200
    82.091    -0.964     0.200
    82.127    -1.151     0.200
    82.154    -0.488     0.200
    82.175     0.098     0.200
    82.173     0.813     0.200
    82.301    -0.355     0.200
    82.377    -0.357     0.200
    82.423    -0.790     0.200
    82.428    -0.816     0.200
    82.465    -0.312     0.200
    82.607     0.050     0.200
    82.931    -0.832     0.200
    83.381    -0.949     0.200
    83.523     0.216     0.200
    83.708    -0.126     0.200
    83.876     0.410     0.200
    83.882    -0.018     0.200
    83.909    -0.654     0.200
    83.943    -0.928     0.200
    83.988    -0.956     0.200
    84.015    -0.194     0.200
    84.118    -0.816     0.200
    84.144    -0.449     0.200
    84.207    -0.567     0.200
    84.389    -0.593     0.200
    84.459    -0.446     0.200
    84.485     0.426     0.200
    84.495    -0.329     0.200
    84.562     0.135     0.200
    84.731    -0.815     0.200
    84.764    -0.277     0.200
    84.791    -1.117     0.200
    84.803    -0.676     0.200
    84.866     0.207     0.200
    84.957     0.450     0.200
    85.113    -0.435     0.200
    85.254     0.167     0.200
    85.312    -0.328     0.200
    85.566    -0.193     0.200
    85.779     0.160     0.200
    86.137    -0.814     0.200
    86.335    -0.583     0.200
    86.364    -0.428     0.200
    86.384    -0.626     0.200
    86.409     0.054     0.200
    86.564     0.889     0.200
    86.985     0.638     0.200
    87.068     0.633     0.200
    88.632     0.084     0.200
    88.818     0.709     0.200
    90.244     1.641     0.200
    93.070     1.056     0.200
    63.841    -1.712     0.200
    69.809    -1.720     0.200
    44.348    -0.095     0.200
    49.445     0.077     0.200
    63.724    -1.558     0.200
    64.833     0.281     0.200
    69.694    -0.627     0.200
    69.714    -1.547     0.200
    18.489    -3.216     0.200
    19.608    -2.453     0.200
    19.608    -1.852     0.200
    20.429    -3.365     0.200
    21.009    -2.822     0.200
    21.457    -4.024     0.200
    21.488    -3.750     0.200
    21.488    -3.352     0.200
    24.158    -3.576     0.200
    24.158    -2.974     0.200
    28.006    -0.598     0.200
    28.481    -1.528     0.200
    28.481    -1.231     0.200
    29.957    -0.613     0.200
    29.957    -0.215     0.200
    32.686     0.591     0.200
    32.786    -2.489     0.200
    32.786    -2.090     0.200
    33.334    -0.770     0.200
    38.887    -2.082     0.200
    39.965    -0.653     0.200
    43.068    -2.050     0.200
    43.068    -1.151     0.200
    44.034     1.188     0.200
    44.071    -0.107     0.200
    48.683     0.943     0.200
    48.706     0.763     0.200
    48.911     0.994     0.200
    51.217    -1.472     0.200
    52.278    -0.474     0.200
    54.164    -0.723     0.200
    59.792    -0.012     0.200
    60.775    -1.725     0.200
    60.797     0.125     0.200
    62.508    -2.394     0.200
    63.044     0.341     0.200
    63.106    -0.363     0.200
    64.022    -1.604     0.200
    66.069    -1.281     0.200
    68.516    -0.159     0.200
    69.974    -1.375     0.200
    77.307    -1.159     0.200
    77.799    -0.200     0.200
    78.863    -0.271     0.200
    78.863    -0.373     0.200
    79.716     1.076     0.200
    82.188     0.923     0.200
    83.919    -0.621     0.200
    84.128    -0.682     0.200
    84.154    -0.313     0.200
    84.217    -0.330     0.200
    84.470    -0.413     0.200
    84.505    -0.389     0.200
    85.264    -0.197     0.200
    85.576    -0.055     0.200
    85.789     0.198     0.200
    86.995     0.675     0.200
    87.078     0.568     0.200
    13.914     5.992     0.200
    18.475    -3.957     0.200
    18.475    -3.059     0.200
    19.608    -3.344     0.200
    19.608    -2.446     0.200
    20.441    -2.380     0.200
    20.781    -3.048     0.200
    21.023    -2.555     0.200
    21.450    -4.938     0.200
    21.819    -2.778     0.200
    23.654    -0.881     0.200
    23.929    -3.092     0.200
    24.643     1.101     0.200
    24.850    -0.787     0.200
    25.846    -0.818     0.200
    26.614     1.251     0.200
    27.972    -1.908     0.200
    27.972    -1.209     0.200
    28.019    -1.328     0.200
    28.485    -0.280     0.200
    29.961    -0.359     0.200
    30.363    -4.111     0.200
    30.920    -1.024     0.200
    31.316     1.490     0.200
    32.695     0.589     0.200
    32.770    -2.067     0.200
    33.347    -0.497     0.200
    33.709     0.555     0.200
    36.471     2.397     0.200
    37.313     3.251     0.200
    37.330     0.501     0.200
    37.663     1.188     0.200
    38.890    -1.622     0.200
    39.092    -4.306     0.200
    39.972    -0.626     0.200
    40.148    -1.091     0.200
    40.448    -1.462     0.200
    40.639     1.857     0.200
    41.591    -0.463     0.200
    42.388     0.547     0.200
    42.484    -0.133     0.200
    43.072    -1.196     0.200
    43.056    -0.466     0.200
    43.319     0.612     0.200
    43.561    -0.239     0.200
    44.054     0.406     0.200
    44.054     0.105     0.200
    44.049     1.351     0.200
    45.026     0.061     0.200
    45.062     0.977     0.200
    45.184     1.510     0.200
    45.356     1.948     0.200
    47.496    -0.019     0.200
    47.648     2.400     0.200
    48.694     0.931     0.200
    48.718     0.751     0.200
    48.922     0.987     0.200
    49.201    -1.046     0.200
    49.237    -0.422     0.200
    49.237    -0.223     0.200
    49.712     0.961     0.200
    51.203    -1.084     0.200
    51.238     2.458     0.200
    51.649    -0.620     0.200
    51.649    -0.018     0.200
    52.278    -0.293     0.200
    53.051    -1.001     0.200
    53.464    -0.236     0.200
    53.491    -1.229     0.200
    53.601     2.066     0.200
    53.739     0.054     0.200
    54.174    -0.219     0.200
    54.752    -2.410     0.200
    54.902    -1.696     0.200
    55.121    -0.474     0.200
    55.747     0.926     0.200
    55.789    -0.477     0.200
    55.870     1.548     0.200
    57.295    -1.466     0.200
    58.582    -1.677     0.200
    58.924    -1.750     0.200
    59.132    -1.389     0.200
    59.162     1.797     0.200
    59.804     0.376     0.200
    60.770    -2.319     0.200
    60.769    -1.412     0.200
    60.805    -0.658     0.200
    61.300    -1.406     0.200
    62.024     0.920     0.200
    62.024     0.920     0.200
    62.198    -1.747     0.200
    62.448     0.085     0.200
    62.354     0.710     0.200
    62.504    -1.388     0.200
    62.356     0.599     0.200
    62.609    -0.487     0.200
    62.606     0.028     0.200
    63.057     0.430     0.200
    63.118    -1.369     0.200
    63.213    -0.497     0.200
    63.575     0.612     0.200
    63.961    -0.930     0.200
    64.017    -1.398     0.200
    64.477    -1.309     0.200
    64.495     0.177     0.200
    64.820    -1.743     0.200
    65.150    -1.885     0.200
    65.239     1.040     0.200
    65.529     0.865     0.200
    66.064    -1.476     0.200
    66.957     1.527     0.200
    67.224     1.035     0.200
    67.367     0.432     0.200
    67.669     0.924     0.200
    68.210     0.829     0.200
    68.339    -0.479     0.200
    68.519    -0.106     0.200
    68.657     0.136     0.200
    68.774     0.509     0.200
    68.775     0.504     0.200
    68.933    -1.578     0.200
    69.035     0.686     0.200
    69.194    -0.099     0.200
    69.507     1.667     0.200
    69.550     1.208     0.200
    69.696     2.106     0.200
    69.908     0.305     0.200
    69.871     1.533     0.200
    69.962    -1.426     0.200
    70.269     1.897     0.200
    70.895     1.283     0.200
    70.965    -0.641     0.200
    70.951     1.842     0.200
    71.449    -2.062     0.200
    71.605     1.799     0.200
    71.864     0.442     0.200
    72.956     1.940     0.200
    73.066     1.790     0.200
    73.109     1.039     0.200
    73.252    -0.203     0.200
    73.536     1.523     0.200
    73.687     1.639     0.200
    73.780     1.092     0.200
    75.008     2.964     0.200
    75.030     0.835     0.200
    75.349     1.307     0.200
    75.591    -0.578     0.200
    75.568     0.751     0.200
    75.674    -0.856     0.200
    75.674    -0.356     0.200
    75.688     0.065     0.200
    75.688     1.065     0.200
    76.129     0.453     0.200
    76.337     0.372     0.200
    76.438    -0.198     0.200
    76.491     1.503     0.200
    76.433     1.528     0.200
    77.303    -0.867     0.200
    77.308    -0.294     0.200
    77.567     1.859     0.200
    77.771    -0.677     0.200
    77.796    -0.012     0.200
    78.007    -0.386     0.200
    78.209     0.699     0.200
    78.209     0.293     0.200
    78.261    -0.391     0.200
    78.351    -0.885     0.200
    78.528    -0.563     0.200
    78.722    -0.628     0.200
    78.778    -1.237     0.200
    78.839    -0.073     0.200
    78.859    -0.080     0.200
    78.862    -0.498     0.200
    79.076     0.130     0.200
    79.115    -0.083     0.200
    79.352    -0.478     0.200
    79.400    -0.634     0.200
    79.431     1.193     0.200
    79.622    -0.544     0.200
    79.752    -0.848     0.200
    79.813     0.125     0.200
    79.963     0.309     0.200
    80.202    -0.375     0.200
    80.279     0.112     0.200
    80.311    -0.862     0.200
    80.262     1.303     0.200
    80.316     0.411     0.200
    80.622     0.272     0.200
    80.675     0.486     0.200
    80.951    -0.787     0.200
    80.987    -0.977     0.200
    81.052    -1.022     0.200
    81.075     0.358     0.200
    81.086     0.096     0.200
    81.082    -1.182     0.200
    81.134     0.443     0.200
    81.176     0.121     0.200
    81.207    -0.544     0.200
    81.211    -1.064     0.200
    81.239    -1.514     0.200
    81.255    -1.298     0.200
    81.570    -1.266     0.200
    81.697     0.169     0.200
    81.765    -0.489     0.200
    81.803    -0.392     0.200
    82.007    -0.463     0.200
    82.135    -1.234     0.200
    82.161    -0.670     0.200
    82.182    -0.282     0.200
    82.302    -0.504     0.200
    82.364    -0.428     0.200
    82.379    -0.609     0.200
    82.429    -0.668     0.200
    82.434    -0.596     0.200
    82.472    -0.491     0.200
    82.614    -0.231     0.200
    82.938    -0.913     0.200
    83.147    -0.793     0.200
    83.388    -0.731     0.200
    83.530     0.140     0.200
    83.708    -0.071     0.200
    83.717    -0.917     0.200
    83.889    -0.296     0.200
    83.915    -0.727     0.200
    83.947    -0.692     0.200
    83.982     0.231     0.200
    83.992    -0.623     0.200
    84.024     0.017     0.200
    84.123    -0.788     0.200
    84.178     0.734     0.200
    84.201    -0.880     0.200
    84.212    -0.542     0.200
    84.393    -0.255     0.200
    84.444     0.186     0.200
    84.461     0.803     0.200
    84.465    -0.320     0.200
    84.500    -0.296     0.200
    84.768    -0.143     0.200
    84.813    -0.970     0.200
    84.872    -0.369     0.200
    84.968     0.252     0.200
    85.086    -0.341     0.200
    85.005     4.064     0.200
    85.241    -0.612     0.200
    85.259     0.294     0.200
    85.318    -0.196     0.200
    85.423     0.980     0.200
    85.571    -0.259     0.200
    85.623     0.681     0.200
    85.783     0.089     0.200
    85.892     1.051     0.200
    85.925     1.590     0.200
    86.145    -0.794     0.200
    86.143    -0.588     0.200
    86.342    -0.266     0.200
    86.371    -0.508     0.200
    86.391    -0.605     0.200
    86.414    -0.119     0.200
    86.463     0.541     0.200
    86.569     0.519     0.200
    86.720    -0.220     0.200
    86.990     0.267     0.200
    87.073     0.363     0.200
    87.083     0.617     0.200
    87.344     0.353     0.200
    88.638     0.214     0.200
    88.823    -0.359     0.200
    89.265     1.468     0.200
    90.248     0.874     0.200
    90.745    -0.436     0.200
    93.074    -0.211     0.200
    93.222    -0.393     0.200
    20.481    -3.311     0.200
    44.019     0.396     0.200
    48.735     0.626     0.200
    48.759     0.547     0.200
    48.963     0.784     0.200
    49.169    -0.892     0.200
    51.177    -0.080     0.200
    59.846    -0.304     0.200
    62.509    -2.317     0.200
    63.100    -0.243     0.200
    64.023    -1.830     0.200
    66.072    -1.616     0.200
    69.966    -1.545     0.200
    69.971    -1.573     0.200
    83.920    -0.749     0.200
    84.129    -0.408     0.200
    84.452     0.253     0.200
    84.471    -0.441     0.200
    84.506    -0.419     0.200
    85.265     0.075     0.200
    44.085     0.833     0.200
    48.652     0.834     0.200
    48.675     0.560     0.200
    48.880     0.690     0.200
    49.228    -0.374     0.200
    54.133    -0.429     0.200
    59.761     0.271     0.200
    64.003    -1.408     0.200
    66.050    -1.879     0.200
    69.951    -1.744     0.200
    18.485    -2.906     0.200
    18.485    -2.105     0.200
    19.537    -3.406     0.200
    19.537    -2.906     0.200
    20.347    -2.699     0.200
    20.700    -1.410     0.200
    20.932    -2.609     0.200
    21.413    -4.672     0.200
    21.484    -3.430     0.200
    21.734    -2.103     0.200
    24.090    -3.665     0.200
    24.757    -2.234     0.200
    27.890    -1.971     0.200
    27.927    -1.304     0.200
    28.400    -0.818     0.200
    29.878    -0.015     0.200
    30.339    -3.696     0.200
    30.827     0.506     0.200
    32.602    -0.187     0.200
    32.802    -1.938     0.200
    33.256    -0.094     0.200
    33.622    -0.681     0.200
    36.394    -0.339     0.200
    37.242     0.458     0.200
    38.810    -0.936     0.200
    39.040    -3.364     0.200
    39.881    -0.364     0.200
    40.065    -0.689     0.200
    40.370    -1.705     0.200
    40.511     0.623     0.200
    40.693     1.628     0.200
    41.185    -1.020     0.200
    41.635    -0.300     0.200
    42.989    -1.109     0.200
    42.973    -0.980     0.200
    43.226     0.582     0.200
    43.826    -0.350     0.200
    44.100    -0.043     0.200
    44.100    -0.043     0.200
    44.934     0.113     0.200
    44.974     1.989     0.200
    45.103     1.970     0.200
    45.273     2.019     0.200
    46.725     0.201     0.200
    46.952     1.929     0.200
    47.229    -0.032     0.200
    47.234    -0.069     0.200
    47.731     2.376     0.200
    48.601     0.773     0.200
    48.624     0.792     0.200
    48.785    -0.744     0.200
    48.785     0.057     0.200
    48.829     1.026     0.200
    49.149    -0.525     0.200
    49.149    -0.127     0.200
    49.239    -1.210     0.200
    49.622     0.872     0.200
    51.222    -1.205     0.200
    51.560    -0.730     0.200
    51.560    -0.230     0.200
    52.207    -0.541     0.200
    52.584     0.062     0.200
    52.978     1.659     0.200
    53.376    -2.165     0.200
    53.376    -1.966     0.200
    53.420    -0.682     0.200
    53.532     2.492     0.200
    54.080    -0.611     0.200
    54.662    -0.531     0.200
    54.899    -1.748     0.200
    55.031    -1.203     0.200
    55.031    -0.703     0.200
    55.674     0.880     0.200
    55.701    -1.014     0.200
    55.856     1.073     0.200
    56.237     0.754     0.200
    57.201     1.123     0.200
    58.734     0.099     0.200
    58.746    -1.686     0.200
    58.794    -0.318     0.200
    59.089    -1.363     0.200
    59.712     0.043     0.200
    60.723    -1.670     0.200
    60.753    -1.772     0.200
    62.156    -1.832     0.200
    62.454    -1.720     0.200
    62.347     0.790     0.200
    62.349     0.879     0.200
    62.513     0.281     0.200
    62.966     0.174     0.200
    63.025    -0.518     0.200
    63.636     0.444     0.200
    64.295    -0.186     0.200
    64.548    -0.038     0.200
    64.756    -1.090     0.200
    65.103    -1.646     0.200
    65.148     0.561     0.200
    65.590     1.508     0.200
    66.012    -1.403     0.200
    68.438    -0.362     0.200
    68.561     0.872     0.200
    68.694     0.244     0.200
    68.695     0.238     0.200
    68.702    -0.007     0.200
    68.884    -2.533     0.200
    68.975    -0.701     0.200
    69.428     0.996     0.200
    69.470     0.238     0.200
    69.523    -1.189     0.200
    69.610     1.270     0.200
    69.680     1.944     0.200
    69.923    -1.450     0.200
    70.076    -2.085     0.200
    70.338     1.914     0.200
    71.674     1.623     0.200
    71.779     0.193     0.200
    73.171     1.112     0.200
    74.958    -0.707     0.200
    75.531    -0.495     0.200
    75.612    -1.258     0.200
    76.068    -1.058     0.200
    76.270    -0.004     0.200
    76.381    -0.635     0.200
    77.249    -0.822     0.200
    77.253    -0.743     0.200
    77.581     1.624     0.200
    77.629     2.358     0.200
    77.740    -0.656     0.200
    78.150    -0.534     0.200
    78.297    -0.346     0.200
    78.683    -0.369     0.200
    78.813    -0.286     0.200
    79.227     0.052     0.200
    79.573    -0.332     0.200
    79.638     0.614     0.200
    79.745    -0.264     0.200
    80.057     0.051     0.200
    80.153    -0.568     0.200
    80.222     0.361     0.200
    80.261    -0.351     0.200
    80.329     1.586     0.200
    80.469     0.231     0.200
    80.564     0.524     0.200
    81.000     0.799     0.200
    81.018     0.205     0.200
    81.067     0.446     0.200
    81.162    -0.361     0.200
    81.355    -0.284     0.200
    81.641    -0.091     0.200
    81.712    -0.571     0.200
    81.831    -0.494     0.200
    81.953     0.167     0.200
    82.107    -0.241     0.200
    82.107    -0.343     0.200
    82.108     1.151     0.200
    82.127     0.254     0.200
    82.297    -0.835     0.200
    82.377    -0.854     0.200
    82.382    -0.678     0.200
    82.417    -0.063     0.200
    82.559     0.001     0.200
    83.092    -0.360     0.200
    83.476     0.164     0.200
    83.836     0.122     0.200
    83.864    -0.924     0.200
    83.901    -0.812     0.200
    83.946    -0.740     0.200
    84.073    -0.883     0.200
    84.099    -0.421     0.200
    84.162    -1.041     0.200
    84.348    -0.579     0.200
    84.390     0.303     0.200
    84.414    -0.517     0.200
    84.450    -0.398     0.200
    84.722    -0.370     0.200
    84.822    -0.469     0.200
    85.079     0.243     0.200
    85.210     0.388     0.200
    85.053     3.070     0.200
    85.268    -0.203     0.200
    85.478     0.055     0.200
    85.522    -0.167     0.200
    85.736    -0.129     0.200
    86.176    -1.502     0.200
    86.287    -0.549     0.200
    86.336    -0.486     0.200
    86.365     0.071     0.200
    86.519     0.615     0.200
    86.941     0.554     0.200
    87.024     0.551     0.200
    88.774     0.023     0.200
    18.474    -1.219     0.200
    19.606    -2.594     0.200
    21.473    -2.755     0.200
    28.483    -0.997     0.200
    44.054     0.787     0.200
    44.048     1.434     0.200
    48.693     0.524     0.200
    48.716     0.344     0.200
    48.921     0.579     0.200
    49.201    -0.361     0.200
    51.202    -0.992     0.200
    60.767    -1.806     0.200
    62.501    -2.480     0.200
    63.056    -0.168     0.200
    64.015    -1.489     0.200
    66.062    -1.670     0.200
    69.960    -1.518     0.200
    69.966    -1.253     0.200
    71.447    -1.256     0.200
    18.476    -1.855     0.200
    19.576    -0.578     0.200
    20.401    -2.434     0.200
    20.748     0.321     0.200
    20.985    -2.728     0.200
    21.431    -3.111     0.200
    21.475    -2.979     0.200
    23.614    -1.916     0.200
    23.890     0.365     0.200
    24.126    -2.291     0.200
    24.810     0.377     0.200
    25.811     1.103     0.200
    27.981    -0.178     0.200
    28.448    -0.534     0.200
    29.924    -0.619     0.200
    30.881     0.937     0.200
    32.655     0.155     0.200
    32.781    -1.637     0.200
    33.309     0.049     0.200
    33.674     1.282     0.200
    37.294     0.932     0.200
    39.932    -0.168     0.200
    44.014     1.573     0.200
    44.071     0.617     0.200
    48.655     0.886     0.200
    48.678     0.706     0.200
    48.883     0.941     0.200
    49.214    -0.590     0.200
    52.245    -0.290     0.200
    53.458    -0.329     0.200
    59.765    -0.082     0.200
    60.765    -0.109     0.200
    62.354     1.390     0.200
    62.355    -0.119     0.200
    62.570    -1.051     0.200
    62.567    -0.030     0.200
    63.079    -0.428     0.200
    63.992    -1.350     0.200
    65.127    -1.652     0.200
    66.039    -1.229     0.200
    67.387     0.690     0.200
    68.483     0.811     0.200
    69.297     1.759     0.200
    69.693     2.319     0.200
    69.939    -1.592     0.200
    69.946    -1.336     0.200
    71.451    -0.381     0.200
    76.253     2.850     0.200
    77.277    -0.717     0.200
    77.769     0.041     0.200
    78.832     0.672     0.200
    80.288     2.270     0.200
    84.099    -0.950     0.200
    84.188    -0.704     0.200
    84.418     0.231     0.200
    84.440    -0.880     0.200
    84.476    -0.760     0.200
    85.236     0.026     0.200
    85.547    -0.124     0.200
    85.760     0.022     0.200
    87.478     2.427     0.200
    48.143    -0.106     0.200
    49.508    -0.579     0.200
    59.021     0.763     0.200
    69.793    -1.123     0.200
    20.053    -3.438     0.200
    43.662     0.341     0.200
    49.433    -1.091     0.200
    55.393    -1.073     0.200
    62.244    -0.868     0.200
    62.246    -0.677     0.200
    63.880    -1.523     0.200
    63.890     0.408     0.200
    69.860    -1.884     0.200
    69.864     0.993     0.200
    71.946     0.753     0.200
    18.461    -2.209     0.200
    18.461    -2.108     0.200
    20.394    -3.278     0.200
    20.749    -2.417     0.200
    21.413    -4.538     0.200
    21.784    -1.208     0.200
    23.605    -3.294     0.200
    23.883    -2.335     0.200
    24.109    -4.391     0.200
    24.109    -4.290     0.200
    24.802    -1.702     0.200
    27.920    -0.799     0.200
    27.976    -0.897     0.200
    28.433    -0.368     0.200
    30.331    -4.183     0.200
    30.873     0.036     0.200
    32.646    -0.129     0.200
    32.768    -1.992     0.200
    33.305    -1.275     0.200
    33.672     0.327     0.200
    37.292     0.483     0.200
    38.838    -1.031     0.200
    39.048    -4.490     0.200
    39.920     0.168     0.200
    40.396    -0.878     0.200
    40.470     0.208     0.200
    41.151    -1.489     0.200
    41.507     0.387     0.200
    41.596    -0.438     0.200
    42.344     0.562     0.200
    42.499    -0.400     0.200
    43.273     0.845     0.200
    43.741    -0.013     0.200
    44.060     0.325     0.200
    44.013     1.105     0.200
    44.982    -1.624     0.200
    45.071     0.968     0.200
    47.002     1.789     0.200
    47.266     0.435     0.200
    47.271     0.398     0.200
    47.781     1.444     0.200
    47.873    -2.274     0.200
    47.873    -1.774     0.200
    47.796     3.719     0.200
    48.137     0.893     0.200
    48.648     0.662     0.200
    48.671     0.583     0.200
    48.875     0.814     0.200
    49.009     0.493     0.200
    49.202    -0.879     0.200
    49.185    -0.351     0.200
    49.185     0.047     0.200
    49.661     0.027     0.200
    51.193    -1.239     0.200
    51.450     0.148     0.200
    51.597    -0.556     0.200
    52.228    -0.248     0.200
    53.026     1.062     0.200
    53.687     0.009     0.200
    53.801    -0.717     0.200
    54.125    -0.683     0.200
    54.700    -1.355     0.200
    54.700    -0.855     0.200
    54.881    -1.661     0.200
    55.069    -0.724     0.200
    55.532    -0.347     0.200
    55.737    -1.821     0.200
    55.737    -1.321     0.200
    58.540    -2.201     0.200
    58.695     0.022     0.200
    58.755    -0.098     0.200
    59.092    -1.428     0.200
    59.760     0.171     0.200
    60.742    -1.840     0.200
    60.728    -1.645     0.200
    60.728    -2.247     0.200
    60.754     0.175     0.200
    62.158    -1.691     0.200
    62.370     0.497     0.200
    62.371     0.581     0.200
    62.461    -1.610     0.200
    62.556    -0.747     0.200
    62.799     0.138     0.200
    63.014     0.007     0.200
    63.072    -1.775     0.200
    63.160     0.538     0.200
    63.591     0.196     0.200
    63.974    -1.620     0.200
    64.432    -2.324     0.200
    64.432    -1.824     0.200
    64.506     0.196     0.200
    64.773    -1.542     0.200
    65.198     0.700     0.200
    65.963     3.064     0.200
    66.021    -1.503     0.200
    66.981     1.268     0.200
    67.172     0.054     0.200
    67.379    -0.048     0.200
    68.234     0.873     0.200
    68.288    -0.965     0.200
    68.288    -0.465     0.200
    68.468    -0.087     0.200
    68.663    -0.304     0.200
    68.778     1.184     0.200
    68.891    -2.118     0.200
    69.458     1.270     0.200
    69.456     0.782     0.200
    69.491     1.668     0.200
    69.566     1.309     0.200
    69.851     1.557     0.200
    69.856     0.718     0.200
    69.921    -1.678     0.200
    70.080    -2.653     0.200
    70.213    -1.363     0.200
    70.284     1.496     0.200
    70.621     1.543     0.200
    70.849     1.466     0.200
    70.920     1.125     0.200
    70.975     1.796     0.200
    71.436    -1.584     0.200
    71.627     1.667     0.200
    71.816     1.728     0.200
    71.812     1.453     0.200
    72.088    -0.201     0.200
    72.981     0.492     0.200
    73.058     0.038     0.200
    73.137     0.671     0.200
    73.562     1.072     0.200
    73.713     1.186     0.200
    73.805     1.646     0.200
    74.146     0.958     0.200
    74.878    -0.585     0.200
    75.034     2.514     0.200
    75.056     1.391     0.200
    75.205     1.327     0.200
    75.544    -0.413     0.200
    75.544    -0.311     0.200
    75.594     0.301     0.200
    75.627    -1.885     0.200
    75.627    -1.588     0.200
    75.639     0.045     0.200
    75.639     0.545     0.200
    76.288    -0.650     0.200
    76.271     2.949     0.200
    76.393    -0.240     0.200
    76.516     2.062     0.200
    76.817     0.364     0.200
    76.885     0.984     0.200
    77.175     0.854     0.200
    77.259    -0.717     0.200
    77.259    -1.115     0.200
    77.264    -0.040     0.200
    77.726    -0.723     0.200
    77.751    -0.156     0.200
    77.917    -1.783     0.200
    77.961     0.474     0.200
    78.081    -1.190     0.200
    78.167    -0.164     0.200
    78.163     0.252     0.200
    78.213    -0.922     0.200
    78.307    -0.938     0.200
    78.484    -0.213     0.200
    78.683    -1.013     0.200
    78.814    -0.230     0.200
    78.819    -0.361     0.200
    78.823    -0.778     0.200
    79.070     0.164     0.200
    79.087    -0.123     0.200
    79.237     0.061     0.200
    79.352    -1.669     0.200
    79.382     1.167     0.200
    79.764     0.094     0.200
    80.028    -0.333     0.200
    80.160    -0.745     0.200
    80.268    -1.025     0.200
    80.282     1.298     0.200
    80.267     0.381     0.200
    80.270    -1.135     0.200
    80.480     0.034     0.200
    80.591    -0.558     0.200
    80.807     0.989     0.200
    80.870    -0.449     0.200
    80.909    -0.555     0.200
    80.941    -1.224     0.200
    81.037     0.059     0.200
    81.075    -0.731     0.200
    81.085     0.509     0.200
    81.132     1.262     0.200
    81.169    -1.137     0.200
    81.193    -1.362     0.200
    81.355    -0.321     0.200
    81.721    -0.556     0.200
    81.840    -0.480     0.200
    81.963     0.080     0.200
    82.055    -0.401     0.200
    82.090    -1.288     0.200
    82.117    -0.429     0.200
    82.315     0.033     0.200
    82.386    -0.835     0.200
    82.391    -0.759     0.200
    82.427     0.050     0.200
    82.586     1.124     0.200
    83.064    -2.055     0.200
    83.103    -0.350     0.200
    83.343    -0.793     0.200
    83.486     0.373     0.200
    83.664     0.360     0.200
    83.670    -0.674     0.200
    83.845     0.138     0.200
    83.860     0.961     0.200
    83.872    -0.600     0.200
    83.906    -0.876     0.200
    83.951    -0.700     0.200
    83.978    -0.039     0.200
    84.005     0.527     0.200
    84.014    -0.221     0.200
    84.080    -0.763     0.200
    84.148    -0.701     0.200
    84.170    -0.514     0.200
    84.352    -0.541     0.200
    84.400     0.318     0.200
    84.458    -0.574     0.200
    84.525    -0.212     0.200
    84.694    -0.865     0.200
    84.727    -0.125     0.200
    84.754    -1.464     0.200
    84.766    -0.821     0.200
    84.815     0.329     0.200
    84.809    -0.240     0.200
    84.829    -0.445     0.200
    84.920     0.304     0.200
    85.039    -0.791     0.200
    85.069    -2.545     0.200
    85.217     0.113     0.200
    85.275    -0.176     0.200
    85.295     0.327     0.200
    85.529    -0.042     0.200
    85.742     0.209     0.200
    86.100    -0.664     0.200
    86.141     0.133     0.200
    86.346    -0.273     0.200
    86.372     0.297     0.200
    86.473     0.004     0.200
    86.527     0.640     0.200
    86.699    -0.901     0.200
    86.948     0.583     0.200
    87.031     0.484     0.200
    88.265     0.181     0.200
    88.781    -0.343     0.200
    44.025     0.811     0.200
    47.989     0.691     0.200
    48.497     0.768     0.200
    48.523     0.268     0.200
    48.726     0.713     0.200
    48.854     0.328     0.200
    48.881    -0.283     0.200
    50.812    -0.953     0.200
    58.392     0.475     0.200
    62.786     1.121     0.200
    62.787    -0.188     0.200
    62.928    -0.123     0.200
    63.518    -1.428     0.200
    65.566    -1.608     0.200
    69.461    -1.908     0.200
    71.039    -2.366     0.200
    20.048    -2.763     0.200
    32.307    -0.184     0.200
    43.679     1.311     0.200
    44.272     0.256     0.200
    47.791     0.870     0.200
    48.302     0.727     0.200
    48.530     0.975     0.200
    49.385    -0.374     0.200
    51.314    -0.946     0.200
    60.605    -1.352     0.200
    62.321    -0.926     0.200
    62.301     0.107     0.200
    63.829    -1.230     0.200
    65.869    -1.397     0.200
    68.752    -1.031     0.200
    69.792    -1.464     0.200
    70.913     1.294     0.200
    71.536    -1.474     0.200
    73.402     1.121     0.200
    76.225     0.114     0.200
    81.572    -0.481     0.200
    83.731    -0.797     0.200
    83.827    -0.888     0.200
    83.938    -0.655     0.200
    84.029    -0.519     0.200
    84.230    -0.539     0.200
    84.245     0.086     0.200
    84.279    -0.590     0.200
    84.317    -0.680     0.200
    85.078     0.089     0.200
    85.393    -0.186     0.200
    85.612    -0.075     0.200
    18.473    -4.543     0.200
    18.473    -4.144     0.200
    20.410    -2.657     0.200
    20.994    -2.955     0.200
    21.433    -3.956     0.200
    22.272    -2.601     0.200
    23.899    -1.311     0.200
    24.131    -3.126     0.200
    24.819    -0.096     0.200
    25.820    -1.672     0.200
    26.593     0.848     0.200
    27.990     0.445     0.200
    28.455    -0.798     0.200
    30.890     0.156     0.200
    32.664    -0.128     0.200
    32.776    -1.696     0.200
    33.318    -0.633     0.200
    37.303     0.144     0.200
    38.861    -1.259     0.200
    39.070    -5.711     0.200
    39.940    -0.452     0.200
    42.359     0.200     0.200
    43.031    -1.749     0.200
    44.023     1.277     0.200
    44.997     0.013     0.200
    45.331     2.861     0.200
    47.287     0.019     0.200
    47.292    -0.018     0.200
    47.465    -0.860     0.200
    48.153     0.711     0.200
    48.664     0.385     0.200
    48.687     0.205     0.200
    48.892     0.436     0.200
    49.026     0.215     0.200
    49.206     0.234     0.200
    51.204    -0.870     0.200
    52.251    -0.968     0.200
    53.708    -0.398     0.200
    53.708     0.001     0.200
    54.143    -0.071     0.200
    54.720    -1.762     0.200
    54.720    -1.364     0.200
    54.896    -2.028     0.200
    55.090    -1.132     0.200
    55.726     0.701     0.200
    59.113    -1.833     0.200
    59.775    -0.192     0.200
    60.749    -2.153     0.200
    60.774    -0.220     0.200
    62.482    -1.424     0.200
    62.357     1.119     0.200
    62.358     0.509     0.200
    62.575     0.263     0.200
    62.576    -0.244     0.200
    63.028    -0.553     0.200
    63.590    -0.067     0.200
    63.936    -2.340     0.200
    63.995    -1.527     0.200
    64.795    -1.555     0.200
    65.211     1.349     0.200
    66.042    -1.714     0.200
    68.230     0.926     0.200
    68.667    -0.600     0.200
    69.011    -0.736     0.200
    69.165    -0.687     0.200
    69.478     0.875     0.200
    69.879     0.913     0.200
    69.942    -1.578     0.200
    69.948    -1.219     0.200
    71.624     1.312     0.200
    75.567    -0.016     0.200
    75.662     0.643     0.200
    75.662     1.143     0.200
    75.892     0.329     0.200
    76.104     1.520     0.200
    76.415    -0.138     0.200
    76.402     2.436     0.200
    76.840     0.362     0.200
    77.281    -0.910     0.200
    77.286    -0.640     0.200
    77.773    -0.255     0.200
    78.185     0.160     0.200
    78.704    -0.400     0.200
    78.836     0.374     0.200
    79.258     0.167     0.200
    80.290    -0.119     0.200
    80.598     0.531     0.200
    81.108     0.113     0.200
    81.375    -0.407     0.200
    81.743    -0.447     0.200
    82.077    -0.499     0.200
    82.407    -0.725     0.200
    82.412    -0.852     0.200
    83.365    -0.683     0.200
    83.882     1.172     0.200
    83.893    -0.488     0.200
    83.972    -0.187     0.200
    84.036     0.186     0.200
    84.102    -0.549     0.200
    84.191    -0.401     0.200
    84.373    -0.324     0.200
    84.444    -0.476     0.200
    84.479    -0.461     0.200
    84.748    -0.111     0.200
    84.851    -0.331     0.200
    85.239     0.227     0.200
    85.297    -0.062     0.200
    85.317     0.436     0.200
    85.550    -0.122     0.200
    85.763    -0.073     0.200
    86.320    -0.320     0.200
    86.368    -0.659     0.200
    86.548     0.653     0.200
    86.969     0.504     0.200
    14.328    10.890     0.200
    18.545    -2.178     0.200
    20.177    -2.515     0.200
    20.535    -1.696     0.200
    20.759    -2.613     0.200
    21.384    -2.756     0.200
    21.565    -2.390     0.200
    22.097    -3.673     0.200
    23.393    -3.317     0.200
    23.450     1.565     0.200
    23.664    -3.093     0.200
    23.999    -1.562     0.200
    24.423    -1.223     0.200
    24.590    -3.244     0.200
    25.708     1.802     0.200
    26.384     0.486     0.200
    27.762    -1.890     0.200
    27.754    -2.119     0.200
    28.265    -0.373     0.200
    29.747    -0.328     0.200
    30.336    -3.742     0.200
    31.081     1.688     0.200
    31.993     0.666     0.200
    32.897    -2.758     0.200
    33.083    -1.582     0.200
    33.451    -1.090     0.200
    38.154     1.623     0.200
    38.589     3.969     0.200
    38.686    -1.349     0.200
    38.982    -4.830     0.200
    39.731    -0.573     0.200
    39.935    -0.267     0.200
    40.252    -0.601     0.200
    40.635     0.538     0.200
    41.286    -0.022     0.200
    41.279    -0.964     0.200
    41.748    -0.002     0.200
    42.639     0.539     0.200
    42.683    -0.217     0.200
    42.806    -1.316     0.200
    42.859    -0.949     0.200
    43.055     1.872     0.200
    43.040     2.084     0.200
    43.793     0.320     0.200
    43.797     1.184     0.200
    43.911     0.174     0.200
    44.217     0.114     0.200
    44.761    -0.423     0.200
    45.106     2.232     0.200
    46.577     0.132     0.200
    47.084     0.071     0.200
    47.088     0.034     0.200
    47.261     0.286     0.200
    47.863    -1.883     0.200
    47.863    -1.383     0.200
    47.920     0.676     0.200
    48.431     0.336     0.200
    48.454     0.352     0.200
    48.637    -0.851     0.200
    48.658     0.483     0.200
    48.793     0.052     0.200
    49.004    -0.269     0.200
    49.342    -0.053     0.200
    49.470     0.773     0.200
    51.297    -0.932     0.200
    51.413    -0.302     0.200
    51.497     0.266     0.200
    51.478     0.605     0.200
    52.105     0.134     0.200
    52.822     0.520     0.200
    53.232     0.603     0.200
    53.113     3.177     0.200
    53.318    -0.533     0.200
    53.382     1.702     0.200
    53.338     2.424     0.200
    53.496    -0.337     0.200
    53.614    -0.497     0.200
    53.614    -0.802     0.200
    53.914    -0.395     0.200
    54.511    -0.743     0.200
    54.511    -0.243     0.200
    54.883    -0.435     0.200
    54.934    -1.308     0.200
    55.555    -0.579     0.200
    55.801    -0.650     0.200
    55.792     0.017     0.200
    58.482    -1.592     0.200
    58.844    -0.008     0.200
    58.904    -0.222     0.200
    59.076     0.087     0.200
    59.539     0.081     0.200
    60.554    -0.272     0.200
    60.676    -1.709     0.200
    60.762    -1.690     0.200
    61.225    -1.832     0.200
    62.116    -1.625     0.200
    62.049     1.620     0.200
    62.026     0.373     0.200
    62.219     0.477     0.200
    62.232     0.191     0.200
    62.373    -0.550     0.200
    62.380    -0.600     0.200
    62.398    -0.922     0.200
    62.298     0.049     0.200
    62.587    -0.086     0.200
    62.793    -0.555     0.200
    62.886    -0.475     0.200
    62.989     0.345     0.200
    63.027     1.592     0.200
    63.373     1.296     0.200
    63.811    -1.094     0.200
    63.908    -1.230     0.200
    64.026     0.993     0.200
    64.148    -1.201     0.200
    64.100     2.307     0.200
    64.262    -0.055     0.200
    64.352    -0.643     0.200
    64.670    -0.922     0.200
    64.677     0.338     0.200
    64.976     0.292     0.200
    65.054    -1.718     0.200
    65.380     1.171     0.200
    65.950    -1.509     0.200
    66.026     0.504     0.200
    66.166     2.406     0.200
    66.496    -0.006     0.200
    66.507    -0.076     0.200
    66.888    -0.002     0.200
    66.888     0.498     0.200
    67.024     0.128     0.200
    67.123     1.798     0.200
    67.183     1.622     0.200
    67.553     0.483     0.200
    67.546     2.928     0.200
    67.660     1.504     0.200
    67.894     1.132     0.200
    68.049     1.658     0.200
    68.146    -0.946     0.200
    68.236    -1.310     0.200
    68.312     0.008     0.200
    68.491    -0.908     0.200
    68.437     0.935     0.200
    68.572     0.388     0.200
    68.573     0.382     0.200
    68.586     0.595     0.200
    68.532     1.236     0.200
    68.675     0.744     0.200
    68.707     0.547     0.200
    68.829    -1.714     0.200
    68.897    -0.638     0.200
    68.897    -0.138     0.200
    68.899     0.347     0.200
    68.985    -0.182     0.200
    68.998     1.940     0.200
    69.182     0.893     0.200
    69.307     0.819     0.200
    69.703     0.379     0.200
    69.750     1.188     0.200
    69.761     1.418     0.200
    69.868     0.364     0.200
    69.866    -1.328     0.200
    69.822    -0.755     0.200
    70.030    -1.429     0.200
    70.054     1.616     0.200
    70.164    -1.453     0.200
    70.312    -0.362     0.200
    70.491     1.447     0.200
    70.584     1.581     0.200
    70.822     1.330     0.200
    71.125     1.296     0.200
    71.461     1.166     0.200
    71.415     1.740     0.200
    71.527    -1.437     0.200
    71.642     0.575     0.200
    71.923    -0.113     0.200
    71.970     1.607     0.200
    72.506     2.405     0.200
    72.782     1.765     0.200
    72.898     0.077     0.200
    73.185     0.376     0.200
    73.210     1.832     0.200
    73.324     0.059     0.200
    73.708    -1.696     0.200
    73.699     0.355     0.200
    73.835     0.060     0.200
    73.768     0.952     0.200
    73.896     0.198     0.200
    74.007     0.656     0.200
    73.920     1.062     0.200
    73.919     0.860     0.200
    73.957     1.142     0.200
    74.010     0.537     0.200
    74.113     0.934     0.200
    74.172     0.588     0.200
    74.252     0.121     0.200
    74.500    -0.321     0.200
    74.703     0.504     0.200
    74.767    -0.365     0.200
    74.701     0.811     0.200
    75.072    -0.624     0.200
    75.227     0.479     0.200
    75.336    -1.146     0.200
    75.241     1.401     0.200
    75.261     0.287     0.200
    75.454    -0.223     0.200
    75.392    -0.468     0.200
    75.527    -0.242     0.200
    75.527     0.258     0.200
    75.529    -1.255     0.200
    75.529    -0.958     0.200
    75.608     1.795     0.200
    75.778     0.325     0.200
    75.801     0.190     0.200
    75.990     1.117     0.200
    76.159     0.151     0.200
    76.159     0.651     0.200
    76.177     0.051     0.200
    76.311     0.289     0.200
    76.360     0.014     0.200
    76.378     0.912     0.200
    76.378    -0.088     0.200
    76.386     1.868     0.200
    76.316     0.259     0.200
    76.398     0.796     0.200
    76.681     0.697     0.200
    76.721     0.969     0.200
    76.860     0.687     0.200
    76.946    -0.296     0.200
    77.113    -0.238     0.200
    77.113     0.559     0.200
    77.185    -0.842     0.200
    77.187    -0.353     0.200
    77.318     0.613     0.200
    77.326     0.568     0.200
    77.647     0.779     0.200
    77.671     0.348     0.200
    77.723     1.754     0.200
    77.813    -0.148     0.200
    77.823    -0.203     0.200
    77.823     0.594     0.200
    77.770     2.091     0.200
    77.748     0.216     0.200
    77.869     0.339     0.200
    77.946     0.319     0.200
    78.074     0.404     0.200
    78.074     0.104     0.200
    78.084    -1.655     0.200
    78.110    -0.796     0.200
    78.110    -0.296     0.200
    78.108     0.216     0.200
    78.108     0.716     0.200
    78.179     0.319     0.200
    78.199    -3.286     0.200
    78.234    -0.480     0.200
    78.342    -0.077     0.200
    78.410    -0.251     0.200
    78.349     0.880     0.200
    78.625    -1.139     0.200
    78.649    -0.773     0.200
    78.666    -0.367     0.200
    78.706    -0.291     0.200
    78.734     0.463     0.200
    78.761    -0.594     0.200
    78.759    -0.478     0.200
    78.908     0.803     0.200
    78.992     0.244     0.200
    79.099    -0.943     0.200
    79.121     0.640     0.200
    79.162     0.115     0.200
    79.214     0.128     0.200
    79.249    -1.061     0.200
    79.263     0.865     0.200
    79.501    -0.332     0.200
    79.507    -0.364     0.200
    79.534    -0.713     0.200
    79.403     1.099     0.200
    79.563    -1.171     0.200
    79.575     0.166     0.200
    79.586     1.105     0.200
    79.651     0.752     0.200
    79.711    -0.472     0.200
    79.764     0.137     0.200
    79.958     1.884     0.200
    80.093     0.658     0.200
    80.098    -0.670     0.200
    80.105    -0.378     0.200
    80.145    -1.921     0.200
    80.151     0.048     0.200
    80.152     0.143     0.200
    80.176     0.409     0.200
    80.207    -0.753     0.200
    80.309    -0.447     0.200
    80.362    -0.591     0.200
    80.393    -0.256     0.200
    80.403     0.192     0.200
    80.453    -0.474     0.200
    80.492    -0.789     0.200
    80.518     0.372     0.200
    80.477     1.792     0.200
    80.573    -0.424     0.200
    80.575    -0.336     0.200
    80.583     0.519     0.200
    80.630    -0.384     0.200
    80.666    -0.517     0.200
    80.841    -1.157     0.200
    80.852    -1.114     0.200
    80.851    -0.809     0.200
    80.901     0.025     0.200
    80.921    -1.080     0.200
    80.923    -0.091     0.200
    80.968     1.270     0.200
    80.974     0.432     0.200
    80.983    -0.211     0.200
    81.051    -0.571     0.200
    81.065    -0.847     0.200
    81.110    -0.383     0.200
    81.109    -0.980     0.200
    81.122    -1.549     0.200
    81.140    -0.849     0.200
    81.437    -1.320     0.200
    81.439    -1.128     0.200
    81.572     0.065     0.200
    81.652    -0.702     0.200
    81.768    -0.772     0.200
    81.847    -0.577     0.200
    81.888    -0.198     0.200
    81.888    -0.097     0.200
    81.943    -0.692     0.200
    82.007    -1.827     0.200
    82.044    -0.120     0.200
    82.059    -0.101     0.200
    82.059     0.196     0.200
    82.088    -1.252     0.200
    82.180    -0.835     0.200
    82.206     0.131     0.200
    82.267    -0.892     0.200
    82.317    -1.199     0.200
    82.323    -0.583     0.200
    82.331    -1.223     0.200
    82.352    -0.632     0.200
    82.352    -0.233     0.200
    82.376    -0.539     0.200
    82.391     0.164     0.200
    82.425     0.988     0.200
    82.492     0.034     0.200
    82.514    -0.179     0.200
    82.716    -0.627     0.200
    82.812    -0.628     0.200
    82.838    -0.163     0.200
    83.026    -0.534     0.200
    83.266    -0.876     0.200
    83.261     0.449     0.200
    83.429     0.584     0.200
    83.590    -0.042     0.200
    83.590     0.060     0.200
    83.742    -0.774     0.200
    83.759    -0.899     0.200
    83.764    -1.929     0.200
    83.773     0.627     0.200
    83.808    -0.759     0.200
    83.826     0.957     0.200
    83.855    -0.794     0.200
    83.890     0.427     0.200
    83.898    -0.014     0.200
    83.901     0.167     0.200
    83.899    -0.722     0.200
    83.907    -0.662     0.200
    83.920     0.668     0.200
    83.933    -0.092     0.200
    84.016    -0.819     0.200
    84.046     0.630     0.200
    84.057    -0.724     0.200
    84.071    -0.793     0.200
    84.107    -0.475     0.200
    84.220     0.036     0.200
    84.301    -0.465     0.200
    84.320     0.339     0.200
    84.327     0.202     0.200
    84.358    -0.554     0.200
    84.383    -1.481     0.200
    84.395    -0.343     0.200
    84.428    -0.206     0.200
    84.437    -0.963     0.200
    84.561     0.017     0.200
    84.565     0.997     0.200
    84.604    -1.198     0.200
    84.670    -0.928     0.200
    84.675    -1.557     0.200
    84.676    -0.162     0.200
    84.735    -0.858     0.200
    84.767    -0.917     0.200
    84.806    -0.255     0.200
    84.880    -1.557     0.200
    84.929    -1.398     0.200
    84.795     1.637     0.200
    84.937    -1.874     0.200
    84.993    -2.154     0.200
    85.022    -0.798     0.200
    85.039    -1.950     0.200
    85.000     0.510     0.200
    85.100    -1.693     0.200
    85.115     0.031     0.200
    85.144    -0.311     0.200
    85.155     0.238     0.200
    85.165     0.587     0.200
    85.184    -2.766     0.200
    85.189    -0.537     0.200
    85.214    -0.057     0.200
    85.254    -1.069     0.200
    85.105     2.781     0.200
    85.358    -1.380     0.200
    85.468    -0.928     0.200
    85.469    -0.331     0.200
    85.488    -1.629     0.200
    85.547    -1.123     0.200
    85.476     0.330     0.200
    85.686     0.286     0.200
    85.617     0.527     0.200
    85.617     1.029     0.200
    85.769    -1.123     0.200
    85.794    -0.444     0.200
    85.816    -0.255     0.200
    86.011    -1.219     0.200
    86.024    -0.783     0.200
    86.087     0.700     0.200
    86.222    -0.463     0.200
    86.270    -0.496     0.200
    86.310     0.203     0.200
    86.463     0.655     0.200
    86.642    -0.322     0.200
    86.888     0.477     0.200
    86.969     0.376     0.200
    87.120    -0.255     0.200
    87.244    -0.257     0.200
    87.581     0.221     0.200
    87.551     0.764     0.200
    87.681    -0.558     0.200
    87.601     0.922     0.200
    87.735     1.385     0.200
    87.874     0.824     0.200
    87.877     0.607     0.200
    88.052     0.677     0.200
    88.214     0.909     0.200
    88.217     0.998     0.200
    88.235     0.911     0.200
    88.388     0.288     0.200
    88.429    -0.106     0.200
    88.718    -0.469     0.200
    89.331     1.855     0.200
    89.581    -0.316     0.200
    89.506     1.238     0.200
    90.553     0.150     0.200
    90.662    -0.354     0.200
    90.833     0.851     0.200
    91.074     0.525     0.200
    91.489     0.103     0.200
    92.313     0.195     0.200
    92.976     0.435     0.200
    93.426     0.065     0.200
    94.457     0.324     0.200
    95.347    -0.048     0.200
    99.139    -1.066     0.200
    43.827    -0.522     0.200
    58.838    -1.072     0.200
    62.220    -1.644     0.200
    62.287    -1.294     0.200
    70.197    -3.393     0.200
    18.493    -2.777     0.200
    20.349    -3.013     0.200
    20.698    -1.285     0.200
    20.932    -2.305     0.200
    21.421    -4.247     0.200
    23.562    -2.639     0.200
    23.837    -2.148     0.200
    24.097    -3.521     0.200
    24.759    -2.550     0.200
    25.759     1.378     0.200
    27.895    -2.814     0.200
    27.895    -2.314     0.200
    27.928    -1.104     0.200
    28.405    -0.657     0.200
    30.828     0.198     0.200
    32.605    -0.005     0.200
    32.808    -2.184     0.200
    33.256    -0.892     0.200
    33.622    -0.667     0.200
    38.815    -0.578     0.200
    39.886    -0.493     0.200
    40.517     1.390     0.200
    40.698     1.397     0.200
    41.640    -0.138     0.200
    42.995    -1.247     0.200
    43.582     3.323     0.200
    43.962     0.270     0.200
    44.105     0.422     0.200
    46.729    -0.626     0.200
    46.729    -0.126     0.200
    47.412     0.060     0.200
    48.092     0.974     0.200
    48.224    -1.026     0.200
    48.603     0.825     0.200
    48.626     0.743     0.200
    48.830     0.798     0.200
    48.965     0.352     0.200
    49.154    -1.354     0.200
    49.154    -1.053     0.200
    49.244    -1.048     0.200
    51.229    -1.049     0.200
    52.587    -0.150     0.200
    53.381     0.007     0.200
    57.204    -1.488     0.200
    59.096    -1.709     0.200
    59.713     0.044     0.200
    60.731    -1.613     0.200
    60.716     0.185     0.200
    62.341     0.237     0.200
    62.343     0.528     0.200
    62.966    -0.123     0.200
    63.026     0.179     0.200
    63.640     0.623     0.200
    63.904    -1.115     0.200
    64.332    -1.717     0.200
    64.763    -0.729     0.200
    65.594     0.285     0.200
    66.019    -2.146     0.200
    66.069     1.835     0.200
    66.069     2.335     0.200
    67.032     1.695     0.200
    67.426     0.696     0.200
    68.285     1.104     0.200
    68.444    -2.190     0.200
    68.708     0.064     0.200
    68.891    -1.576     0.200
    69.923    -1.443     0.200
    69.931    -1.590     0.200
    69.912     0.928     0.200
    69.901     1.591     0.200
    71.819     1.156     0.200
    72.582     0.607     0.200
    73.032     0.938     0.200
    73.187     0.527     0.200
    73.613     1.520     0.200
    73.856     1.095     0.200
    75.538    -0.231     0.200
    75.863     0.515     0.200
    76.075    -0.794     0.200
    77.257    -1.355     0.200
    77.723    -0.956     0.200
    77.747    -0.591     0.200
    77.954    -0.242     0.200
    77.954     0.360     0.200
    78.157     0.032     0.200
    78.304    -0.481     0.200
    78.690    -0.408     0.200
    78.810    -0.463     0.200
    79.234    -0.180     0.200
    80.333     0.774     0.200
    80.333     1.574     0.200
    81.025     0.274     0.200
    81.073     0.316     0.200
    81.720    -0.302     0.200
    82.043    -0.297     0.200
    82.385    -0.885     0.200
    82.390    -0.713     0.200
    83.872    -0.654     0.200
    83.909    -0.944     0.200
    83.954    -0.373     0.200
    84.080    -0.617     0.200
    84.170    -0.470     0.200
    84.355    -0.610     0.200
    84.389     0.221     0.200
    84.398     0.273     0.200
    84.422    -0.446     0.200
    84.458    -0.331     0.200
    84.730    -0.299     0.200
    84.830    -0.300     0.200
    85.218     0.257     0.200
    85.276    -0.233     0.200
    85.530    -0.299     0.200
    85.543    -0.861     0.200
    85.744     0.040     0.200
    86.295    -0.379     0.200
    86.343    -0.514     0.200
    86.372     0.139     0.200
    86.527     0.683     0.200
    86.949     0.623     0.200
    87.031     0.522     0.200
    20.851    -2.523     0.200
    24.357    -0.834     0.200
    26.337     1.218     0.200
    28.470     0.041     0.200
    31.336     0.803     0.200
    33.065     0.455     0.200
    40.261    -0.488     0.200
    44.541     1.771     0.200
    44.541     1.572     0.200
    48.598     0.762     0.200
    48.744    -0.076     0.200
    49.108     0.703     0.200
    49.133     0.132     0.200
    49.336     0.505     0.200
    49.466     0.252     0.200
    50.801    -0.684     0.200
    62.707     0.992     0.200
    63.509     1.682     0.200
    69.045     1.591     0.200
    69.867    -1.180     0.200
    69.876    -1.833     0.200
    43.927     0.415     0.200
    48.167     0.617     0.200
    48.677     0.289     0.200
    49.037    -0.273     0.200
    18.474    -2.234     0.200
    20.372    -3.426     0.200
    20.726    -1.744     0.200
    20.958    -3.447     0.200
    21.415    -4.647     0.200
    22.238    -3.416     0.200
    22.238    -2.619     0.200
    23.584    -2.316     0.200
    23.861    -2.547     0.200
    24.102    -4.741     0.200
    24.102    -4.445     0.200
    24.781    -2.928     0.200
    24.776     0.919     0.200
    26.565     1.022     0.200
    27.907    -1.101     0.200
    27.907    -0.702     0.200
    27.953    -1.712     0.200
    28.419    -0.057     0.200
    28.731     0.436     0.200
    29.896     0.149     0.200
    30.337    -3.651     0.200
    30.852    -0.191     0.200
    32.626     0.229     0.200
    32.786    -2.167     0.200
    33.282    -0.495     0.200
    33.648     0.316     0.200
    37.256     2.161     0.200
    37.268     0.759     0.200
    37.326     0.773     0.200
    37.605     0.911     0.200
    38.893     1.586     0.200
    39.047    -3.492     0.200
    39.903     0.180     0.200
    40.491     0.815     0.200
    41.169    -0.864     0.200
    41.615    -0.126     0.200
    42.131     0.478     0.200
    42.342    -0.879     0.200
    43.007    -0.936     0.200
    43.251     1.897     0.200
    43.593     2.440     0.200
    43.724    -0.806     0.200
    43.762    -0.290     0.200
    43.941     2.253     0.200
    43.989     1.069     0.200
    44.080    -0.264     0.200
    45.000    -0.698     0.200
    45.092     1.077     0.200
    45.300    -0.095     0.200
    45.299     1.435     0.200
    46.978     1.746     0.200
    47.082     0.250     0.200
    47.757     1.493     0.200
    48.234    -0.489     0.200
    48.626     0.176     0.200
    48.650     0.175     0.200
    48.854     0.406     0.200
    48.988    -0.018     0.200
    49.169     0.336     0.200
    49.643     0.725     0.200
    51.209    -1.086     0.200
    51.187     2.575     0.200
    53.003     0.392     0.200
    53.556     2.133     0.200
    53.670     0.198     0.200
    53.784    -0.736     0.200
    54.105    -0.074     0.200
    55.807    -0.760     0.200
    55.868     1.505     0.200
    58.539    -1.432     0.200
    59.092    -1.874     0.200
    59.737     0.180     0.200
    60.749    -1.732     0.200
    60.736     0.156     0.200
    61.263    -1.414     0.200
    62.159    -1.444     0.200
    62.381    -0.220     0.200
    62.381     0.280     0.200
    62.360     0.713     0.200
    62.539    -0.876     0.200
    63.613     0.605     0.200
    63.908    -0.333     0.200
    63.930     2.554     0.200
    64.331    -1.604     0.200
    64.429    -1.747     0.200
    64.767    -1.745     0.200
    65.108    -2.370     0.200
    65.175     0.403     0.200
    65.175     0.607     0.200
    65.216     1.020     0.200
    65.567     0.654     0.200
    66.018    -1.138     0.200
    66.086     1.730     0.200
    66.613     0.663     0.200
    66.946     1.364     0.200
    67.103    -0.955     0.200
    67.400     0.166     0.200
    68.185    -0.974     0.200
    68.257     0.639     0.200
    68.277    -0.345     0.200
    68.536     0.434     0.200
    68.889    -1.659     0.200
    68.984    -0.749     0.200
    69.130    -0.448     0.200
    69.588     1.224     0.200
    69.844     0.945     0.200
    69.920    -1.623     0.200
    69.928    -1.270     0.200
    70.591     1.590     0.200
    71.210     2.237     0.200
    71.798     1.089     0.200
    73.039     1.591     0.200
    73.160    -0.013     0.200
    73.509    -0.669     0.200
    74.439     1.465     0.200
    74.521     1.387     0.200
    75.078     1.091     0.200
    75.144     0.432     0.200
    75.473    -0.253     0.200
    75.540    -0.636     0.200
    75.632     0.632     0.200
    75.632     1.132     0.200
    75.865     1.303     0.200
    76.077     0.096     0.200
    76.077     0.799     0.200
    76.281    -0.063     0.200
    76.281     0.437     0.200
    76.389    -0.173     0.200
    77.256    -0.655     0.200
    77.261    -0.477     0.200
    77.723    -0.158     0.200
    77.747     0.003     0.200
    77.956     0.546     0.200
    77.956     0.750     0.200
    78.159     0.424     0.200
    78.159     0.822     0.200
    78.166     0.387     0.200
    78.304    -0.479     0.200
    78.350    -0.927     0.200
    78.481    -0.355     0.200
    78.505    -0.621     0.200
    78.685    -0.274     0.200
    78.730     1.279     0.200
    78.811     0.037     0.200
    78.818    -0.809     0.200
    79.067     0.133     0.200
    79.234     0.316     0.200
    79.613     0.025     0.200
    79.901     0.400     0.200
    80.158    -0.287     0.200
    80.230     0.125     0.200
    80.449    -0.850     0.200
    80.477     0.095     0.200
    80.572    -0.112     0.200
    80.572     0.584     0.200
    80.682    -0.597     0.200
    80.873    -0.112     0.200
    80.908    -0.725     0.200
    80.985     0.224     0.200
    80.991    -0.241     0.200
    81.030     0.845     0.200
    81.030     0.143     0.200
    81.051    -0.662     0.200
    81.046    -0.741     0.200
    81.078     0.590     0.200
    81.078    -0.486     0.200
    81.110    -0.080     0.200
    81.168    -0.587     0.200
    81.190    -1.103     0.200
    81.295    -0.788     0.200
    81.347    -0.231     0.200
    81.390    -0.243     0.200
    81.470     0.016     0.200
    81.520    -1.546     0.200
    81.537    -0.495     0.200
    81.570    -0.718     0.200
    81.708    -1.037     0.200
    81.719    -0.400     0.200
    81.749    -0.715     0.200
    81.838    -0.720     0.200
    81.916    -0.613     0.200
    81.999    -1.387     0.200
    82.022    -0.631     0.200
    82.048    -0.320     0.200
    82.061    -1.086     0.200
    82.085    -1.066     0.200
    82.114    -0.575     0.200
    82.134    -0.080     0.200
    82.332    -0.907     0.200
    82.384    -0.780     0.200
    82.389    -0.706     0.200
    82.425    -0.290     0.200
    82.542     0.567     0.200
    82.566     0.065     0.200
    82.688    -0.190     0.200
    82.783    -0.756     0.200
    82.857    -0.066     0.200
    82.890    -0.659     0.200
    82.902    -1.256     0.200
    83.060    -1.894     0.200
    83.100    -0.495     0.200
    83.100     1.505     0.200
    83.403     0.118     0.200
    83.483    -0.172     0.200
    83.496    -0.954     0.200
    83.661     0.018     0.200
    83.780     0.308     0.200
    83.832    -0.901     0.200
    83.843    -0.408     0.200
    83.856     0.830     0.200
    83.870    -0.652     0.200
    83.906    -0.731     0.200
    83.936     0.719     0.200
    83.951    -0.758     0.200
    83.974     0.025     0.200
    84.001     0.488     0.200
    84.010    -0.162     0.200
    84.079    -0.611     0.200
    84.151    -1.081     0.200
    84.168    -0.464     0.200
    84.291     0.156     0.200
    84.352    -0.397     0.200
    84.388     0.217     0.200
    84.398     0.272     0.200
    84.420    -0.445     0.200
    84.456    -0.321     0.200
    84.509    -1.572     0.200
    84.546    -1.134     0.200
    84.689    -0.893     0.200
    84.727    -0.184     0.200
    84.750    -1.507     0.200
    84.771    -2.167     0.200
    84.806    -0.286     0.200
    84.828    -0.396     0.200
    84.837     1.260     0.200
    84.878    -0.036     0.200
    84.956    -1.553     0.200
    85.004    -1.389     0.200
    85.033    -0.024     0.200
    85.085    -0.982     0.200
    85.112    -1.829     0.200
    85.177    -0.045     0.200
    85.216     0.263     0.200
    85.216    -0.217     0.200
    85.238    -2.356     0.200
    85.257    -2.452     0.200
    85.274    -0.128     0.200
    85.289     0.103     0.200
    85.332     0.081     0.200
    85.329    -1.060     0.200
    85.372    -0.217     0.200
    85.484    -0.172     0.200
    85.528    -0.088     0.200
    85.543    -0.764     0.200
    85.741     0.152     0.200
    85.858     0.175     0.200
    85.921     0.216     0.200
    86.055    -0.698     0.200
    86.097    -0.709     0.200
    86.295    -0.378     0.200
    86.343    -0.522     0.200
    86.370     0.149     0.200
    86.525     0.688     0.200
    86.693    -0.430     0.200
    86.947     0.231     0.200
    87.030     0.532     0.200
    87.966    -0.543     0.200
    88.328     0.237     0.200
    88.464     0.686     0.200
    88.547     0.194     0.200
    88.779     0.797     0.200
    88.826     0.576     0.200
    88.983     1.045     0.200
    93.032     0.238     0.200
    41.375    -0.147     0.200
    43.859    -0.384     0.200
    47.685     0.724     0.200
    63.526    -0.016     0.200
    65.479     0.415     0.200
    68.286    -0.035     0.200
    69.499     0.724     0.200
    71.809     0.568     0.200
    73.007     1.406     0.200
    73.082     0.369     0.200
    75.041     0.623     0.200
    20.367    -2.407     0.200
    43.982     0.907     0.200
    44.088     0.762     0.200
    47.089     0.316     0.200
    48.110     0.672     0.200
    48.620     0.244     0.200
    48.644     0.126     0.200
    48.848     0.435     0.200
    62.985     0.247     0.200
    64.332    -1.522     0.200
    66.020    -1.554     0.200
    69.922    -1.838     0.200
    69.930    -1.189     0.200
    71.800     2.095     0.200
    77.258    -1.066     0.200
    77.749     0.195     0.200
    78.688    -0.097     0.200
    78.812     0.324     0.200
    78.996    -0.484     0.200
    82.390    -0.818     0.200
    83.872    -0.663     0.200
    84.081    -0.818     0.200
    84.170    -0.678     0.200
    84.422    -0.549     0.200
    84.458    -0.434     0.200
    84.729    -0.400     0.200
    85.218     0.151     0.200
    85.530    -0.302     0.200
    85.743     0.140     0.200
    86.527     0.678     0.200
    87.032     0.420     0.200
    64.151    -1.580     0.200
    65.837    -1.329     0.200
    69.748    -1.334     0.200
    69.759    -1.502     0.200
    47.753     0.646     0.200
    48.490     0.957     0.200
    48.617     0.578     0.200
    62.812     0.911     0.200
    21.138    -0.550     0.200
    48.266     0.397     0.200
    48.290    -0.192     0.200
    48.494     0.239     0.200
    69.610    -1.148     0.200
    69.625    -1.638     0.200
    76.050     0.651     0.200
    83.551    -0.481     0.200
    83.758    -0.445     0.200
    83.849    -0.509     0.200
    84.099    -0.287     0.200
    84.897     0.178     0.200
    18.462    -2.179     0.200
    20.442    -2.260     0.200
    20.788    -1.991     0.200
    21.027    -2.762     0.200
    21.439    -4.581     0.200
    21.462    -3.227     0.200
    21.825    -2.609     0.200
    23.654    -2.465     0.200
    23.931    -2.194     0.200
    24.148    -3.679     0.200
    24.851     0.328     0.200
    25.852    -0.752     0.200
    26.623     1.292     0.200
    27.966    -2.241     0.200
    28.022    -0.940     0.200
    28.481     0.180     0.200
    28.675     0.757     0.200
    29.956     0.005     0.200
    30.475     2.021     0.200
    30.922     0.578     0.200
    32.695     0.507     0.200
    32.758    -2.142     0.200
    33.351    -0.613     0.200
    33.715     0.123     0.200
    34.777     1.431     0.200
    37.335     1.072     0.200
    37.359     0.868     0.200
    38.884    -0.959     0.200
    39.081    -4.606     0.200
    39.969     0.010     0.200
    40.628     2.420     0.200
    41.142    -1.065     0.200
    41.580    -0.324     0.200
    42.063    -0.342     0.200
    42.257    -3.652     0.200
    42.299    -0.221     0.200
    43.321     1.607     0.200
    43.550     0.662     0.200
    43.720    -1.648     0.200
    44.043     0.199     0.200
    44.055     1.116     0.200
    45.029    -0.852     0.200
    45.362     1.506     0.200
    47.042     2.120     0.200
    47.819     1.986     0.200
    48.185     0.455     0.200
    48.696     0.329     0.200
    48.719     0.349     0.200
    48.924     0.583     0.200
    49.058     0.358     0.200
    49.234    -0.586     0.200
    49.710     0.389     0.200
    51.246     2.204     0.200
    51.499    -0.088     0.200
    52.270    -0.628     0.200
    52.678    -0.546     0.200
    53.483    -1.565     0.200
    54.174     0.386     0.200
    56.082    -0.159     0.200
    57.295    -1.564     0.200
    59.807     0.063     0.200
    60.758    -1.431     0.200
    60.804     0.756     0.200
    62.187    -1.669     0.200
    62.366     0.936     0.200
    62.367     1.227     0.200
    62.603    -0.343     0.200
    62.608    -0.082     0.200
    63.061     0.613     0.200
    63.952    -0.269     0.200
    64.366    -1.677     0.200
    64.467    -0.642     0.200
    64.811    -1.084     0.200
    65.166    -0.488     0.200
    66.054    -1.510     0.200
    66.095     1.229     0.200
    67.356     0.301     0.200
    68.180    -0.486     0.200
    68.201     1.365     0.200
    68.592     0.246     0.200
    68.923    -1.513     0.200
    69.189    -0.663     0.200
    69.817    -0.737     0.200
    69.738     1.948     0.200
    69.952    -1.661     0.200
    69.957    -1.596     0.200
    70.589     1.903     0.200
    71.736     1.009     0.200
    71.860     0.769     0.200
    72.986     0.201     0.200
    73.053     2.190     0.200
    73.544    -0.425     0.200
    73.772     1.952     0.200
    73.731     1.978     0.200
    73.930    -0.585     0.200
    74.387     1.105     0.200
    74.468     1.517     0.200
    75.026     0.989     0.200
    75.098     0.156     0.200
    75.249     0.478     0.200
    75.514    -0.141     0.200
    75.581    -0.526     0.200
    75.665    -1.206     0.200
    75.679    -0.289     0.200
    75.679     0.211     0.200
    76.119     0.906     0.200
    76.313     1.107     0.200
    76.428    -0.144     0.200
    76.482     1.710     0.200
    76.403     2.896     0.200
    76.925     1.655     0.200
    77.293    -1.011     0.200
    77.298    -0.441     0.200
    77.330     2.785     0.200
    77.509     0.853     0.200
    77.761    -0.024     0.200
    77.786    -0.060     0.200
    77.998    -0.238     0.200
    78.198    -0.445     0.200
    78.200     0.045     0.200
    78.340    -0.432     0.200
    78.518    -0.411     0.200
    78.710    -0.268     0.200
    78.851    -0.541     0.200
    78.849    -0.030     0.200
    79.034    -0.442     0.200
    79.105     0.168     0.200
    79.271     0.366     0.200
    79.714     0.757     0.200
    79.957     0.040     0.200
    80.191    -0.822     0.200
    80.515     0.042     0.200
    80.612     0.521     0.200
    80.896     0.305     0.200
    80.941    -0.732     0.200
    80.977    -1.028     0.200
    81.043    -1.074     0.200
    81.064     1.011     0.200
    81.078     0.137     0.200
    81.088    -0.017     0.200
    81.112    -0.641     0.200
    81.125    -0.011     0.200
    81.125     0.386     0.200
    81.178     0.707     0.200
    81.200    -0.612     0.200
    81.245    -1.251     0.200
    81.261    -0.132     0.200
    81.266    -1.059     0.200
    81.324    -0.067     0.200
    81.371    -0.315     0.200
    81.493    -0.664     0.200
    81.561    -1.319     0.200
    81.578    -0.909     0.200
    81.687     0.217     0.200
    81.754    -0.539     0.200
    82.095    -0.225     0.200
    82.125    -1.086     0.200
    82.419    -0.919     0.200
    82.424    -0.844     0.200
    82.632     0.770     0.200
    83.378    -0.682     0.200
    83.554     0.612     0.200
    83.821     0.748     0.200
    83.896     0.884     0.200
    83.904    -0.677     0.200
    83.936    -0.839     0.200
    83.981    -0.871     0.200
    84.014     0.162     0.200
    84.041     0.828     0.200
    84.049     0.086     0.200
    84.113    -0.738     0.200
    84.185    -0.205     0.200
    84.191    -0.735     0.200
    84.202    -0.590     0.200
    84.303    -0.204     0.200
    84.382    -0.505     0.200
    84.425     0.179     0.200
    84.434     0.233     0.200
    84.454    -0.370     0.200
    84.451     0.376     0.200
    84.490    -0.348     0.200
    84.757    -0.193     0.200
    84.788    -1.153     0.200
    84.803    -0.628     0.200
    84.843     0.175     0.200
    84.959     0.392     0.200
    85.061     1.170     0.200
    85.249     0.240     0.200
    85.262    -0.025     0.200
    85.297     0.301     0.200
    85.307    -0.148     0.200
    85.307    -0.950     0.200
    85.334    -0.184     0.200
    85.561    -0.210     0.200
    85.581    -0.910     0.200
    85.772     0.040     0.200
    85.967     0.098     0.200
    86.332    -0.521     0.200
    86.381    -0.560     0.200
    86.404     0.027     0.200
    86.559     0.667     0.200
    86.739    -0.614     0.200
    86.980     0.513     0.200
    87.063     0.410     0.200
    87.579     0.873     0.200
    88.813    -0.016     0.200
    91.581     0.281     0.200
    20.745    -0.340     0.200
    41.633    -0.548     0.200
    44.124    -0.165     0.200
    45.415    -0.179     0.200
    47.356     0.668     0.200
    48.222     0.564     0.200
    50.987    -0.390     0.200
    69.202    -1.507     0.200
    73.385     0.467     0.200
    75.311     0.559     0.200
    75.353     1.309     0.200
    76.699     1.397     0.200
    76.780     1.300     0.200
    86.287     0.970     0.200
    13.513     9.587     0.200
    13.774     4.241     0.200
    14.502     7.322     0.200
    18.370    -2.255     0.200
    20.356    -0.396     0.200
    20.763    -1.780     0.200
    20.963    -2.429     0.200
    21.308    -4.828     0.200
    21.788    -1.248     0.200
    23.560    -2.243     0.200
    23.852    -1.606     0.200
    24.757    -2.146     0.200
    25.809    -1.188     0.200
    27.837    -1.898     0.200
    27.953    -0.736     0.200
    28.355    -0.509     0.200
    30.838     1.016     0.200
    32.597    -0.426     0.200
    33.284    -0.922     0.200
    33.669     0.738     0.200
    34.828     0.512     0.200
    37.285     1.235     0.200
    38.753    -0.616     0.200
    38.945    -3.323     0.200
    39.853    -0.275     0.200
    40.412     0.182     0.200
    42.033     1.021     0.200
    42.453    -0.499     0.200
    43.031     0.725     0.200
    43.278    -0.004     0.200
    43.685    -0.402     0.200
    43.997     0.084     0.200
    43.997     0.455     0.200
    44.020     1.771     0.200
    45.223     0.181     0.200
    47.005     0.187     0.200
    48.102     1.210     0.200
    48.612     1.288     0.200
    48.972     0.726     0.200
    49.595     0.577     0.200
    51.234     3.022     0.200
    52.134    -0.785     0.200
    53.347    -1.329     0.200
    54.079    -0.077     0.200
    58.391    -0.275     0.200
    58.391     0.327     0.200
    58.622     1.118     0.200
    59.734     0.440     0.200
    60.661    -1.494     0.200
    62.054    -1.990     0.200
    62.321    -0.277     0.200
    62.482     0.047     0.200
    62.463     1.079     0.200
    62.993     0.557     0.200
    63.795     1.309     0.200
    63.868     2.639     0.200
    64.229    -1.586     0.200
    64.674    -1.588     0.200
    65.005    -1.838     0.200
    65.149     1.088     0.200
    65.500     0.690     0.200
    65.918    -1.628     0.200
    65.934     3.369     0.200
    66.192     2.215     0.200
    66.578     2.168     0.200
    68.205     1.159     0.200
    68.458     0.597     0.200
    69.520     1.414     0.200
    69.530     2.225     0.200
    69.771     1.170     0.200
    69.817    -1.909     0.200
    69.823    -1.249     0.200
    69.823     1.752     0.200
    71.157     2.409     0.200
    71.194     2.256     0.200
    71.738     1.604     0.200
    71.961     2.486     0.200
    73.094     1.110     0.200
    73.778     1.917     0.200
    73.841     2.479     0.200
    74.377     1.658     0.200
    74.462     2.205     0.200
    75.017    -0.213     0.200
    75.072     0.855     0.200
    75.444    -0.590     0.200
    75.527    -0.468     0.200
    75.770     0.849     0.200
    75.982    -1.161     0.200
    76.291    -0.313     0.200
    77.157    -1.188     0.200
    77.162    -0.216     0.200
    77.389     0.213     0.200
    77.492     1.506     0.200
    77.624     0.199     0.200
    77.649    -0.238     0.200
    77.861     0.686     0.200
    78.063     0.766     0.200
    78.063     1.266     0.200
    78.062    -0.432     0.200
    78.204    -0.315     0.200
    78.381     0.006     0.200
    78.579    -0.480     0.200
    78.712     0.187     0.200
    78.968     0.182     0.200
    79.134     0.276     0.200
    79.584     0.733     0.200
    79.535     2.998     0.200
    79.825    -0.177     0.200
    80.056    -0.122     0.200
    80.165    -0.508     0.200
    80.245     2.140     0.200
    80.378     0.249     0.200
    80.412     0.664     0.200
    80.475     0.628     0.200
    80.840    -1.323     0.200
    80.905    -1.069     0.200
    80.941     0.338     0.200
    80.951    -0.114     0.200
    80.974    -1.036     0.200
    80.988     0.091     0.200
    80.976     0.254     0.200
    80.988    -0.111     0.200
    81.108    -1.248     0.200
    81.124    -0.030     0.200
    81.128    -1.254     0.200
    81.590    -0.298     0.200
    81.618    -0.663     0.200
    81.815    -0.532     0.200
    81.827    -0.741     0.200
    82.014    -0.524     0.200
    82.147    -0.718     0.200
    82.288    -0.853     0.200
    82.325    -0.150     0.200
    82.344    -0.571     0.200
    82.467     0.008     0.200
    82.504     0.720     0.200
    82.682    -0.407     0.200
    83.683     0.835     0.200
    83.759     0.849     0.200
    83.768    -0.700     0.200
    83.977    -0.763     0.200
    84.047    -0.020     0.200
    84.066    -0.514     0.200
    84.248    -0.538     0.200
    84.288     0.156     0.200
    84.298     0.211     0.200
    84.319    -0.497     0.200
    84.354    -0.474     0.200
    84.623    -0.230     0.200
    84.652    -0.775     0.200
    84.706     0.350     0.200
    84.726    -0.549     0.200
    84.699     0.657     0.200
    84.821     0.871     0.200
    85.114     0.209     0.200
    85.160     0.275     0.200
    85.172    -0.182     0.200
    85.293    -0.789     0.200
    85.334     0.010     0.200
    85.425    -0.247     0.200
    85.444    -0.838     0.200
    85.638     0.102     0.200
    85.645    -1.636     0.200
    85.998    -0.781     0.200
    86.195    -0.555     0.200
    86.244    -0.594     0.200
    86.268     0.087     0.200
    86.423     0.628     0.200
    86.602    -0.549     0.200
    86.844     0.468     0.200
    86.927     0.466     0.200
    87.543     0.676     0.200
    87.588     0.810     0.200
    88.677    -0.072     0.200
    88.770    -0.110     0.200
    62.317    -0.688     0.200
    47.812     1.233     0.200
    47.899     0.315     0.200
    47.905     0.870     0.200
    48.415     0.455     0.200
    48.440     0.448     0.200
    49.196     0.042     0.200
    49.236     0.800     0.200
    49.671     0.710     0.200
    49.942     0.751     0.200
    62.467     0.245     0.200
    62.468     0.537     0.200
    66.196     4.451     0.200
    69.704    -1.485     0.200
    69.715    -1.253     0.200
    71.361    -0.482     0.200
    14.566     9.482     0.200
    15.016     1.833     0.200
    20.417    -1.708     0.200
    20.761    -1.928     0.200
    21.000    -1.799     0.200
    21.438    -2.592     0.200
    21.474    -1.078     0.200
    22.279    -2.655     0.200
    23.629    -1.429     0.200
    23.905    -2.748     0.200
    24.138    -3.868     0.200
    24.138    -3.669     0.200
    24.826    -0.737     0.200
    27.949    -1.275     0.200
    27.996    -0.191     0.200
    30.896     0.618     0.200
    32.173     2.396     0.200
    32.671     1.035     0.200
    32.776    -1.880     0.200
    33.324     0.334     0.200
    33.688     0.973     0.200
    36.453     1.383     0.200
    40.472    -0.289     0.200
    40.650     0.388     0.200
    41.600    -0.746     0.200
    41.839     0.522     0.200
    42.280     0.412     0.200
    42.321     0.311     0.200
    43.295     1.239     0.200
    43.331    -0.606     0.200
    43.380     2.056     0.200
    43.742    -0.880     0.200
    44.028     0.856     0.200
    44.064     0.089     0.200
    45.003     1.484     0.200
    45.038     0.501     0.200
    45.280     0.038     0.200
    45.336     2.843     0.200
    47.061     0.296     0.200
    47.105     1.025     0.200
    47.612     0.604     0.200
    48.065     0.582     0.200
    48.150     0.770     0.200
    48.160     0.852     0.200
    48.274     0.399     0.200
    48.670     0.445     0.200
    48.694     0.445     0.200
    48.898     0.580     0.200
    49.032     0.173     0.200
    49.495     0.959     0.200
    49.688     0.783     0.200
    49.928     0.450     0.200
    50.201     0.623     0.200
    51.220     3.830     0.200
    52.257     0.299     0.200
    53.470    -0.239     0.200
    54.150     0.900     0.200
    57.988    -1.991     0.200
    57.988    -1.392     0.200
    60.792    -0.421     0.200
    62.355     1.152     0.200
    62.424     1.687     0.200
    62.424     2.187     0.200
    62.582     0.833     0.200
    62.832     1.514     0.200
    63.034     1.930     0.200
    63.094    -1.466     0.200
    63.175     1.366     0.200
    63.433     0.901     0.200
    63.902     1.402     0.200
    64.360    -1.898     0.200
    64.460    -0.752     0.200
    64.460    -0.252     0.200
    64.801    -1.174     0.200
    65.135    -2.144     0.200
    65.190     0.962     0.200
    65.542     0.865     0.200
    66.048    -1.227     0.200
    66.084     2.944     0.200
    66.601     1.788     0.200
    66.916     2.023     0.200
    68.226     0.540     0.200
    68.317     0.603     0.200
    68.576     0.985     0.200
    68.576     1.184     0.200
    68.600     0.836     0.200
    68.784     0.064     0.200
    69.843     0.454     0.200
    69.954    -1.628     0.200
    70.480     0.252     0.200
    71.179     2.361     0.200
    71.233     1.910     0.200
    71.762     1.604     0.200
    71.996     0.957     0.200
    73.011     1.125     0.200
    73.078     1.380     0.200
    73.760     1.398     0.200
    73.797     1.672     0.200
    73.849     0.136     0.200
    74.099     1.798     0.200
    74.226     1.687     0.200
    74.492     1.662     0.200
    75.051     1.238     0.200
    75.121     0.083     0.200
    75.505     0.556     0.200
    75.573     0.473     0.200
    75.898     0.314     0.200
    76.111    -0.993     0.200
    76.263     1.211     0.200
    76.421    -0.351     0.200
    76.401     1.981     0.200
    76.476     0.734     0.200
    76.487     1.542     0.200
    77.287    -1.124     0.200
    77.292    -0.852     0.200
    77.581     1.373     0.200
    77.779    -0.070     0.200
    78.192     1.142     0.200
    78.334    -0.345     0.200
    78.709    -1.107     0.200
    78.846    -0.163     0.200
    79.264     0.252     0.200
    80.187    -0.443     0.200
    80.277     1.570     0.200
    80.604    -0.585     0.200
    80.894    -0.030     0.200
    80.895    -0.038     0.200
    81.002    -0.803     0.200
    81.067    -0.149     0.200
    81.081     0.075     0.200
    81.118     0.180     0.200
    81.254    -0.042     0.200
    81.317    -0.175     0.200
    81.370    -0.056     0.200
    81.493     0.095     0.200
    81.748    -0.655     0.200
    82.289     0.011     0.200
    82.366     0.010     0.200
    82.418    -0.860     0.200
    83.075     1.632     0.200
    83.899    -0.696     0.200
    83.932    -0.966     0.200
    83.978    -0.896     0.200
    84.107    -0.857     0.200
    84.197    -0.609     0.200
    84.321     0.609     0.200
    84.379    -0.633     0.200
    84.419     0.066     0.200
    84.428     0.221     0.200
    84.449    -0.489     0.200
    84.485    -0.467     0.200
    84.753    -0.419     0.200
    84.740     0.545     0.200
    84.781    -2.462     0.200
    84.802    -0.485     0.200
    84.836    -1.038     0.200
    84.812     1.083     0.200
    84.856    -0.539     0.200
    84.987    -1.502     0.200
    85.035    -1.243     0.200
    85.244     0.020     0.200
    85.269    -2.143     0.200
    85.288    -2.279     0.200
    85.302    -0.168     0.200
    85.435     1.469     0.200
    85.556    -0.331     0.200
    85.574    -1.019     0.200
    85.768     0.017     0.200
    85.941     1.562     0.200
    86.128    -0.961     0.200
    86.326    -0.532     0.200
    86.354    -0.373     0.200
    86.374    -0.571     0.200
    86.399     0.008     0.200
    86.474    -0.150     0.200
    86.554     0.548     0.200
    86.975     0.393     0.200
    87.058     0.290     0.200
    87.636     0.407     0.200
    88.808    -0.134     0.200
    62.327     1.119     0.200
    69.770    -1.652     0.200
    69.785    -1.547     0.200
    47.994     0.478     0.200
    48.005     0.751     0.200
    48.516     0.915     0.200
    48.539     0.139     0.200
    48.744     0.410     0.200
    48.878     0.539     0.200
    49.342     1.476     0.200
    49.775     0.185     0.200
    64.315    -1.640     0.200
    66.001    -1.463     0.200
    69.923    -1.472     0.200
    41.081    -0.307     0.200
    63.948    -2.721     0.200
    75.959     1.200     0.200
    28.480    -0.971     0.200
    32.722    -2.074     0.200
    47.149     0.983     0.200
    47.656     1.122     0.200
    48.193     0.653     0.200
    48.202     0.923     0.200
    48.284    -1.133     0.200
    48.713     0.679     0.200
    49.074     0.233     0.200
    49.537     0.946     0.200
    49.970     0.576     0.200
    50.243     0.593     0.200
    51.155    -1.138     0.200
    55.708    -1.308     0.200
    59.643    -1.328     0.200
    62.401     0.786     0.200
    64.346    -1.860     0.200
    64.883    -1.360     0.200
    66.035    -1.496     0.200
    69.935    -1.264     0.200
    70.088    -1.301     0.200
    73.076     0.831     0.200
    79.016    -0.542     0.200
    79.016    -0.343     0.200
    85.883     1.704     0.200
    25.508    -1.559     0.200
    28.358    -0.644     0.200
    28.358    -0.042     0.200
    44.070     0.199     0.200
    47.016     1.045     0.200
    48.060     0.931     0.200
    48.069     1.176     0.200
    48.807     0.641     0.200
    48.941     0.580     0.200
    49.403     1.190     0.200
    49.836     0.841     0.200
    50.109     0.956     0.200
    51.181    -0.284     0.200
    55.667    -1.057     0.200
    59.581    -0.951     0.200
    62.395     0.886     0.200
    64.271    -1.416     0.200
    64.807    -1.109     0.200
    65.958    -1.251     0.200
    68.799    -0.594     0.200
    69.870    -0.911     0.200
    70.022    -0.844     0.200
    78.934    -0.232     0.200
    78.934    -0.131     0.200
    85.981     1.684     0.200
    51.190    -1.325     0.200
    62.520    -0.305     0.200
    62.520    -1.004     0.200
    64.200    -0.827     0.200
    69.296    -0.728     0.200
    73.587    -0.024     0.200
    62.518    -0.124     0.200
    73.586    -0.446     0.200
    86.480    -0.361     0.200
    59.428    -1.737     0.200
    64.614    -0.769     0.200
    69.858    -0.718     0.200
    20.369    -0.079     0.200
    20.951    -2.461     0.200
    21.374    -3.999     0.200
    24.064    -3.553     0.200
    24.064    -2.951     0.200
    25.532    -1.497     0.200
    27.944     1.412     0.200
    28.389    -0.541     0.200
    32.607     0.243     0.200
    37.266     1.132     0.200
    38.929    -0.357     0.200
    39.560     0.581     0.200
    39.872     0.788     0.200
    44.056    -0.187     0.200
    44.227     1.119     0.200
    44.452    -0.373     0.200
    47.048     1.088     0.200
    48.102     0.802     0.200
    48.200    -0.862     0.200
    48.612     0.594     0.200
    48.840     0.687     0.200
    48.973     0.247     0.200
    49.193    -0.878     0.200
    49.436     1.256     0.200
    49.869     0.725     0.200
    50.142     0.481     0.200
    50.685     0.814     0.200
    51.175    -0.471     0.200
    53.396    -1.426     0.200
    53.396    -0.926     0.200
    58.688    -0.503     0.200
    58.688    -0.703     0.200
    59.597    -0.384     0.200
    59.727     0.120     0.200
    62.395    -0.144     0.200
    62.515    -0.344     0.200
    64.290    -1.466     0.200
    64.505    -0.770     0.200
    64.827    -1.464     0.200
    65.549     0.778     0.200
    65.978    -1.301     0.200
    66.122    -0.025     0.200
    68.522    -0.099     0.200
    68.849    -1.631     0.200
    69.879    -0.593     0.200
    69.887    -1.039     0.200
    70.039    -1.974     0.200
    76.413     0.967     0.200
    77.216    -0.946     0.200
    77.708     0.311     0.200
    78.771    -0.063     0.200
    78.955    -0.376     0.200
    78.955    -0.473     0.200
    79.194     0.521     0.200
    81.679    -0.399     0.200
    82.348    -0.609     0.200
    83.300    -0.443     0.200
    83.865    -0.835     0.200
    83.910    -0.765     0.200
    83.970     0.229     0.200
    84.128    -0.570     0.200
    84.311    -0.502     0.200
    84.348     0.210     0.200
    84.357     0.265     0.200
    84.416    -0.229     0.200
    85.233    -0.038     0.200
    85.700     0.043     0.200
    85.957     1.369     0.200
    86.057    -0.722     0.200
    86.255    -0.394     0.200
    86.303    -0.534     0.200
    86.485     0.775     0.200
    86.906     0.618     0.200
    20.356     0.361     0.200
    25.523    -2.145     0.200
    38.921    -0.237     0.200
    39.549     0.835     0.200
    44.216     0.367     0.200
    44.458     0.134     0.200
    58.693    -0.292     0.200
    59.591    -0.903     0.200
    64.283    -1.678     0.200
    65.970    -1.319     0.200
    69.873    -0.820     0.200
    70.032    -1.698     0.200
    25.530    -1.186     0.200
    39.559    -0.124     0.200
    44.231     0.977     0.200
    44.447    -0.347     0.200
    48.096     0.889     0.200
    48.104     0.942     0.200
    48.615     1.253     0.200
    49.438     1.116     0.200
    50.144     0.520     0.200
    50.296     0.912     0.200
    50.732     0.786     0.200
    51.066     0.376     0.200
    51.171    -0.651     0.200
    51.307     0.292     0.200
    53.395    -0.934     0.200
    64.288    -0.771     0.200
    64.824    -1.469     0.200
    65.976    -1.908     0.200
    73.138     0.474     0.200
    85.953     1.267     0.200
    39.425    -0.540     0.200
    44.656    -0.023     0.200
    48.855    -0.204     0.200
    49.083     0.107     0.200
    49.209    -0.342     0.200
    49.662     0.522     0.200
    50.366     0.262     0.200
    50.507     0.307     0.200
    50.927    -0.042     0.200
    51.158    -0.288     0.200
    51.258    -0.386     0.200
    51.502    -0.126     0.200
    62.993    -0.652     0.200
    20.287    -1.792     0.200
    20.297    -2.011     0.200
    20.880    -2.195     0.200
    21.355    -4.196     0.200
    21.454    -3.359     0.200
    22.149     1.243     0.200
    24.020    -3.742     0.200
    24.693     0.329     0.200
    25.491    -1.014     0.200
    27.817    -0.738     0.200
    27.873    -1.034     0.200
    28.328    -0.788     0.200
    30.767     0.323     0.200
    32.537     0.773     0.200
    33.203    -0.841     0.200
    37.196     1.246     0.200
    38.898    -2.778     0.200
    39.505    -0.043     0.200
    39.807     0.752     0.200
    40.297    -0.511     0.200
    41.631    -0.377     0.200
    43.167     2.857     0.200
    43.620    -0.791     0.200
    43.921     1.297     0.200
    44.159     1.392     0.200
    44.495    -1.097     0.200
    46.977     0.898     0.200
    47.485     0.693     0.200
    47.936     1.096     0.200
    48.021     0.456     0.200
    48.030     0.629     0.200
    48.541     0.477     0.200
    48.769     0.870     0.200
    48.902     0.007     0.200
    49.230    -1.238     0.200
    49.365     0.853     0.200
    50.071     0.394     0.200
    50.222     1.054     0.200
    50.659     0.661     0.200
    50.874     0.642     0.200
    50.993     0.413     0.200
    51.200    -1.029     0.200
    51.234     0.567     0.200
    52.136    -0.205     0.200
    53.349    -0.653     0.200
    55.531     1.013     0.200
    58.729    -0.854     0.200
    59.574    -0.896     0.200
    59.656     0.542     0.200
    60.706    -1.337     0.200
    62.380     0.789     0.200
    62.381     0.183     0.200
    62.454    -0.908     0.200
    62.912     2.047     0.200
    64.259    -1.532     0.200
    64.687    -0.622     0.200
    64.795    -1.828     0.200
    64.915    -2.747     0.200
    65.253     0.986     0.200
    65.947    -1.666     0.200
    66.108     0.799     0.200
    66.109     1.891     0.200
    68.340     0.472     0.200
    68.449     0.591     0.200
    68.469    -0.335     0.200
    69.623     1.312     0.200
    69.853    -1.694     0.200
    69.862    -1.750     0.200
    70.014    -0.982     0.200
    73.081     1.464     0.200
    73.197     0.584     0.200
    73.197     0.383     0.200
    73.762     1.163     0.200
    74.515    -0.725     0.200
    74.565     1.661     0.200
    75.120     1.006     0.200
    75.175     0.690     0.200
    75.396    -0.097     0.200
    75.801     0.485     0.200
    76.314     0.568     0.200
    76.367     0.870     0.200
    76.470     1.401     0.200
    76.555     1.006     0.200
    77.183    -0.628     0.200
    77.187     0.453     0.200
    77.410    -0.196     0.200
    77.673     0.439     0.200
    78.231    -0.157     0.200
    78.624    -1.018     0.200
    78.736     0.062     0.200
    78.921    -0.948     0.200
    79.161     0.538     0.200
    80.008    -0.258     0.200
    80.348     1.811     0.200
    80.948     0.708     0.200
    80.975     0.060     0.200
    80.997     0.847     0.200
    81.012     0.066     0.200
    81.148     0.141     0.200
    81.211    -0.095     0.200
    81.648    -0.498     0.200
    81.966    -1.271     0.200
    82.065     0.311     0.200
    82.304    -0.240     0.200
    82.318    -0.812     0.200
    83.607    -0.476     0.200
    83.800    -0.665     0.200
    83.839    -0.864     0.200
    83.884    -0.394     0.200
    84.098    -0.484     0.200
    84.286    -0.435     0.200
    84.316     0.214     0.200
    84.325     0.265     0.200
    84.350    -0.460     0.200
    84.386    -0.444     0.200
    84.802     0.662     0.200
    84.896    -0.309     0.200
    85.021    -0.136     0.200
    85.138    -0.124     0.200
    85.205    -0.155     0.200
    85.373    -0.394     0.200
    85.622    -0.034     0.200
    85.673     0.013     0.200
    86.016     1.117     0.200
    86.455     0.561     0.200
    86.878     0.496     0.200
    89.122     0.617     0.200
    89.143     0.519     0.200
    93.126    -0.265     0.200
    20.456    -2.009     0.200
    20.467    -1.826     0.200
    21.400    -2.673     0.200
    24.114    -3.332     0.200
    25.577    -1.228     0.200
    32.702     0.389     0.200
    37.366     1.355     0.200
    39.627     0.586     0.200
    39.958     0.646     0.200
    40.416    -0.251     0.200
    44.326     1.187     0.200
    44.381    -0.646     0.200
    49.130    -0.540     0.200
    51.129    -0.969     0.200
    58.621    -0.486     0.200
    62.428     0.884     0.200
    64.321    -2.523     0.200
    64.858    -1.725     0.200
    66.155     0.807     0.200
    68.587    -0.357     0.200
    70.062    -1.372     0.200
    73.058     0.707     0.200
    74.976     0.821     0.200
    78.992    -0.840     0.200
    85.867     1.546     0.200
    19.946    -0.565     0.200
    44.507    -1.209     0.200
    64.432    -1.259     0.200
    69.670     0.772     0.200
    44.658    -0.676     0.200
    62.287    -0.999     0.200
    66.014    -0.733     0.200
    86.208     1.036     0.200
    43.955     0.707     0.200
    62.289    -1.048     0.200
    64.758    -0.746     0.200
    86.210     1.792     0.200
    15.534     1.331     0.200
    20.686    -1.814     0.200
    21.029    -2.512     0.200
    21.149     0.197     0.200
    24.019    -4.276     0.200
    25.461    -0.188     0.200
    28.321     0.030     0.200
    29.965     0.453     0.200
    31.172     0.506     0.200
    32.888     0.762     0.200
    40.064     0.163     0.200
    40.150    -0.649     0.200
    43.552    -0.524     0.200
    43.579     1.183     0.200
    43.971     0.137     0.200
    44.663     1.307     0.200
    47.392     1.142     0.200
    47.901     1.455     0.200
    48.434     0.769     0.200
    48.434     0.385     0.200
    48.942     1.046     0.200
    49.300     0.239     0.200
    49.756     0.882     0.200
    50.460     0.634     0.200
    50.605     0.710     0.200
    51.031     0.328     0.200
    51.363     0.162     0.200
    55.964    -0.250     0.200
    58.212     0.470     0.200
    58.212    -0.628     0.200
    59.398    -1.258     0.200
    62.792    -0.331     0.200
    62.794    -0.340     0.200
    64.143    -1.649     0.200
    64.684    -1.377     0.200
    65.837    -1.538     0.200
    66.520     0.286     0.200
    66.521     0.280     0.200
    68.540    -0.273     0.200
    68.540     1.946     0.200
    68.577     0.815     0.200
    68.896     1.933     0.200
    69.699    -1.233     0.200
    69.699    -1.233     0.200
    70.509     1.812     0.200
    72.655     1.404     0.200
    74.122     0.382     0.200
    75.927     0.944     0.200
    77.588     0.432     0.200
    78.651    -0.253     0.200
    85.475     1.508     0.200
    17.914    -1.524     0.200
    20.377    -1.721     0.200
    32.605     0.547     0.200
    39.853     0.223     0.200
    43.959     1.205     0.200
    44.265     0.588     0.200
    44.378    -0.616     0.200
    48.104     0.397     0.200
    48.111     0.745     0.200
    48.981     0.078     0.200
    49.115    -0.927     0.200
    49.442     0.839     0.200
    49.876     0.638     0.200
    50.148     0.421     0.200
    50.298     0.766     0.200
    50.732     0.417     0.200
    50.950     0.158     0.200
    51.065     0.150     0.200
    51.307     0.380     0.200
    58.612    -0.925     0.200
    59.525    -1.437     0.200
    62.478     0.045     0.200
    64.223    -1.680     0.200
    64.760    -1.586     0.200
    65.911    -1.630     0.200
    66.205     1.081     0.200
    69.815    -1.364     0.200
    69.815    -1.262     0.200
    73.078     0.283     0.200
    74.398    -0.043     0.200
    78.891    -0.393     0.200
    85.899     0.880     0.200
    15.550     2.339     0.200
    17.677     0.788     0.200
    17.913    -1.794     0.200
    20.391    -1.653     0.200
    24.019    -3.213     0.200
    25.483    -0.526     0.200
    25.893     0.019     0.200
    27.978     1.436     0.200
    28.371    -0.454     0.200
    32.619     0.562     0.200
    39.532    -0.167     0.200
    40.030    -0.598     0.200
    44.372    -0.215     0.200
    49.110     0.162     0.200
    50.312     0.389     0.200
    50.746     0.399     0.200
    50.964    -0.019     0.200
    51.080     0.051     0.200
    51.321     0.320     0.200
    53.356    -0.727     0.200
    58.607    -1.233     0.200
    59.532    -1.738     0.200
    62.478     0.401     0.200
    64.232    -1.583     0.200
    64.769    -1.087     0.200
    66.205     0.337     0.200
    69.823    -1.754     0.200
    69.823    -0.950     0.200
    73.069     1.091     0.200
    74.392    -0.949     0.200
    78.716     0.127     0.200
    78.901    -0.184     0.200
    84.068    -0.782     0.200
    84.300     0.037     0.200
    84.321    -0.565     0.200
    84.356    -0.541     0.200
    84.954     0.048     0.200
    85.889     1.796     0.200
    86.199    -0.632     0.200
    86.247    -0.777     0.200
    89.090     0.516     0.200
    32.559     0.844     0.200
    39.398     1.833     0.200
    44.244    -0.570     0.200
    48.086    -0.007     0.200
    48.088     0.758     0.200
    48.956     0.522     0.200
    49.414     1.280     0.200
    49.850     0.522     0.200
    50.119     0.580     0.200
    50.266     0.569     0.200
    50.695     0.946     0.200
    50.917     1.094     0.200
    51.028     0.164     0.200
    51.270     0.106     0.200
    59.355    -1.929     0.200
    62.649    -0.783     0.200
    64.059    -1.913     0.200
    64.597    -1.431     0.200
    65.749    -1.800     0.200
    69.647    -1.168     0.200
    69.647    -0.867     0.200
    85.808     0.579     0.200
    15.918     1.596     0.200
    25.271     0.144     0.200
    39.439     0.826     0.200
    43.906    -0.589     0.200
    44.611     1.178     0.200
    48.321     0.552     0.200
    49.184     0.249     0.200
    49.638     1.027     0.200
    50.076     0.582     0.200
    50.342     0.833     0.200
    50.484     0.343     0.200
    50.906     0.524     0.200
    51.237     0.477     0.200
    59.213    -1.171     0.200
    63.955    -1.312     0.200
    64.495    -1.449     0.200
    65.648    -1.527     0.200
    66.656     1.510     0.200
    69.513    -1.502     0.200
    69.513    -1.701     0.200
    15.563     1.561     0.200
    16.652     0.814     0.200
    17.940    -1.564     0.200
    20.370    -2.110     0.200
    20.381    -2.150     0.200
    20.974    -2.422     0.200
    21.326    -3.704     0.200
    21.380    -2.985     0.200
    21.795    -3.216     0.200
    23.575    -0.672     0.200
    23.865    -2.319     0.200
    24.031    -3.035     0.200
    25.817    -0.565     0.200
    25.893    -0.357     0.200
    27.965    -0.358     0.200
    28.198     0.062     0.200
    28.374    -0.599     0.200
    29.732    -3.043     0.200
    29.847     0.340     0.200
    30.852     0.067     0.200
    32.612     0.403     0.200
    33.677    -0.077     0.200
    37.294     0.293     0.200
    38.772    -0.954     0.200
    39.866    -0.265     0.200
    43.253     1.828     0.200
    43.979    -0.189     0.200
    44.259     0.751     0.200
    47.063     1.161     0.200
    47.571     0.854     0.200
    48.021     0.854     0.200
    48.108     0.507     0.200
    48.115     0.747     0.200
    48.625     0.685     0.200
    48.986     0.261     0.200
    49.137    -0.580     0.200
    49.132    -0.136     0.200
    49.447     1.097     0.200
    49.612     0.397     0.200
    49.881     0.600     0.200
    50.303     0.831     0.200
    50.738     0.395     0.200
    50.955     0.481     0.200
    51.072     0.369     0.200
    51.313     0.018     0.200
    52.153     0.108     0.200
    52.769     0.352     0.200
    53.041    -1.452     0.200
    53.366    -0.141     0.200
    53.732     2.178     0.200
    54.094    -0.659     0.200
    59.746     0.353     0.200
    60.713    -0.757     0.200
    62.452    -0.269     0.200
    62.500     0.208     0.200
    62.540    -1.056     0.200
    63.834    -0.625     0.200
    64.248    -1.442     0.200
    64.694    -1.047     0.200
    64.785    -1.042     0.200
    65.150     0.739     0.200
    65.501     0.623     0.200
    65.937    -1.389     0.200
    68.368    -3.993     0.200
    68.478     0.627     0.200
    68.503     0.468     0.200
    69.521     0.007     0.200
    69.818     0.932     0.200
    69.842    -1.215     0.200
    69.842    -0.817     0.200
    71.214     1.311     0.200
    72.249     1.123     0.200
    72.978     1.373     0.200
    73.053     1.417     0.200
    73.094     0.594     0.200
    73.509     1.551     0.200
    73.822     0.717     0.200
    75.396    -0.397     0.200
    75.802     0.880     0.200
    76.366     1.735     0.200
    76.658    -0.272     0.200
    76.738     0.878     0.200
    77.176    -1.485     0.200
    77.181    -0.310     0.200
    77.222     1.699     0.200
    77.290     1.443     0.200
    77.408    -0.183     0.200
    77.668     0.166     0.200
    78.731    -0.013     0.200
    78.916    -0.027     0.200
    79.153     0.177     0.200
    80.242     1.056     0.200
    81.637    -0.753     0.200
    82.294    -0.493     0.200
    83.787    -0.709     0.200
    83.820    -0.377     0.200
    83.866    -1.109     0.200
    84.085    -0.628     0.200
    84.267    -0.749     0.200
    84.307     0.145     0.200
    84.317    -0.104     0.200
    84.373    -0.589     0.200
    84.699     0.637     0.200
    84.745    -0.060     0.200
    84.999    -0.338     0.200
    85.129    -0.192     0.200
    85.352    -0.701     0.200
    85.612    -0.194     0.200
    85.656    -0.113     0.200
    85.912     0.888     0.200
    85.977    -0.102     0.200
    86.017    -0.499     0.200
    86.215    -0.672     0.200
    86.263    -0.813     0.200
    86.287    -0.130     0.200
    86.442     0.511     0.200
    86.578     0.044     0.200
    86.863     0.152     0.200
    87.791     0.184     0.200
    89.108     0.369     0.200
    93.110    -0.013     0.200
    14.511     8.872     0.200
    16.651     0.465     0.200
    20.366    -2.251     0.200
    20.377    -2.070     0.200
    20.776    -2.279     0.200
    20.974    -3.411     0.200
    21.302    -4.528     0.200
    21.357    -3.419     0.200
    23.569    -1.554     0.200
    24.847     1.029     0.200
    25.475    -1.303     0.200
    25.822    -2.541     0.200
    25.881    -0.894     0.200
    27.964    -0.985     0.200
    28.183    -0.329     0.200
    28.359    -0.196     0.200
    29.831    -0.050     0.200
    30.848    -0.030     0.200
    32.605     0.336     0.200
    33.295    -1.088     0.200
    33.681    -0.439     0.200
    37.297     0.545     0.200
    38.755    -0.532     0.200
    39.854    -0.286     0.200
    40.310    -0.760     0.200
    40.398    -0.019     0.200
    40.582     0.490     0.200
    41.517    -0.766     0.200
    43.671    -0.255     0.200
    43.961    -0.027     0.200
    44.264     0.899     0.200
    44.380    -0.529     0.200
    44.969     0.181     0.200
    47.568     0.788     0.200
    48.018     0.874     0.200
    48.104     0.563     0.200
    48.111     0.792     0.200
    48.621     0.547     0.200
    48.645     0.522     0.200
    48.849     0.620     0.200
    48.981     0.286     0.200
    49.118     0.859     0.200
    49.443     1.106     0.200
    49.601     1.080     0.200
    49.877     0.707     0.200
    50.148     0.711     0.200
    51.414    -2.485     0.200
    52.134     0.152     0.200
    52.589     0.482     0.200
    52.762     1.007     0.200
    52.949     1.024     0.200
    53.033    -1.894     0.200
    53.142    -0.494     0.200
    53.346    -0.676     0.200
    53.346    -0.796     0.200
    54.087    -0.711     0.200
    55.682    -0.979     0.200
    55.630     0.248     0.200
    56.026     0.312     0.200
    57.853    -1.207     0.200
    58.615     0.176     0.200
    58.615    -0.924     0.200
    59.528    -1.139     0.200
    59.744    -0.229     0.200
    60.623    -1.334     0.200
    61.151    -1.816     0.200
    62.326    -0.216     0.200
    62.487     0.206     0.200
    62.537    -2.123     0.200
    62.475    -0.215     0.200
    62.491    -0.120     0.200
    63.051    -0.542     0.200
    63.813    -0.573     0.200
    63.781     1.487     0.200
    63.855     2.695     0.200
    64.226    -1.378     0.200
    64.672    -0.995     0.200
    64.762    -1.281     0.200
    64.867    -2.973     0.200
    65.192     0.928     0.200
    65.486     0.549     0.200
    65.914    -1.126     0.200
    66.202     0.825     0.200
    66.203     3.419     0.200
    68.200    -0.724     0.200
    68.350     0.438     0.200
    68.460     0.346     0.200
    68.485    -0.505     0.200
    68.886     0.500     0.200
    69.506     0.964     0.200
    69.818    -1.054     0.200
    69.818    -1.054     0.200
    69.874     0.852     0.200
    70.103    -2.801     0.200
    70.933     0.644     0.200
    71.421    -0.997     0.200
    71.425     2.169     0.200
    71.726     1.100     0.200
    72.743     1.183     0.200
    73.042     1.277     0.200
    73.080     0.471     0.200
    73.080     0.500     0.200
    73.846     0.800     0.200
    74.290    -0.486     0.200
    74.400    -0.929     0.200
    75.374    -0.046     0.200
    76.288    -0.156     0.200
    76.353     1.636     0.200
    76.719     0.507     0.200
    76.938     1.587     0.200
    77.153    -0.131     0.200
    77.158    -0.360     0.200
    77.276     1.230     0.200
    77.386    -0.234     0.200
    77.646    -0.084     0.200
    78.060    -0.184     0.200
    78.058     1.125     0.200
    78.200    -0.061     0.200
    78.573    -0.565     0.200
    78.709    -0.064     0.200
    78.711    -0.477     0.200
    78.894    -0.278     0.200
    79.131     0.328     0.200
    79.459     0.140     0.200
    79.481    -0.280     0.200
    79.586     0.648     0.200
    79.671    -0.314     0.200
    79.905    -0.380     0.200
    80.000    -0.493     0.200
    80.019     0.804     0.200
    80.052    -0.881     0.200
    80.068    -0.158     0.200
    80.129     0.514     0.200
    80.160    -0.647     0.200
    80.269    -0.238     0.200
    80.375    -0.008     0.200
    80.415     0.777     0.200
    80.422    -0.565     0.200
    80.452    -0.424     0.200
    80.472     0.470     0.200
    80.561    -0.106     0.200
    80.588    -0.151     0.200
    80.711    -0.107     0.200
    80.726     0.613     0.200
    80.747     0.797     0.200
    80.865    -0.433     0.200
    80.924     0.217     0.200
    80.940     0.068     0.200
    80.946    -0.381     0.200
    80.948    -0.173     0.200
    80.985     0.133     0.200
    80.987     0.319     0.200
    81.018    -1.146     0.200
    81.061    -0.511     0.200
    81.089    -0.223     0.200
    81.184    -0.025     0.200
    81.128    -0.559     0.200
    81.214    -0.486     0.200
    81.234     0.010     0.200
    81.250    -0.179     0.200
    81.343     0.032     0.200
    81.357    -0.041     0.200
    81.547     0.355     0.200
    81.734    -0.633     0.200
    81.777    -0.657     0.200
    81.812     0.660     0.200
    81.814    -0.354     0.200
    81.857     0.021     0.200
    81.890     0.347     0.200
    81.957    -0.302     0.200
    81.985    -1.152     0.200
    82.032     0.002     0.200
    82.036     0.383     0.200
    82.060     0.758     0.200
    82.143    -0.477     0.200
    82.153    -0.232     0.200
    82.217    -0.606     0.200
    82.230     0.066     0.200
    82.322    -0.311     0.200
    82.341    -0.110     0.200
    82.356     0.210     0.200
    82.365     0.463     0.200
    82.464    -0.053     0.200
    82.515    -0.518     0.200
    82.515    -0.122     0.200
    82.570     0.493     0.200
    82.539    -0.834     0.200
    82.673     0.658     0.200
    82.679    -0.239     0.200
    82.788    -0.439     0.200
    82.997    -0.519     0.200
    83.143    -2.375     0.200
    83.274    -0.046     0.200
    83.450     0.345     0.200
    83.681     0.565     0.200
    83.733    -0.404     0.200
    83.739    -0.131     0.200
    83.767    -0.075     0.200
    83.842    -1.459     0.200
    83.909     0.001     0.200
    84.040     0.232     0.200
    84.243    -1.099     0.200
    84.591    -0.857     0.200
    84.721    -1.013     0.200
    84.685     0.251     0.200
    84.851    -0.665     0.200
    84.975    -0.789     0.200
    85.900     0.770     0.200
    85.900     1.309     0.200
    87.574     0.271     0.200
    88.097     0.097     0.200
    89.085     0.014     0.200
    93.087    -0.367     0.200
    16.615     0.857     0.200
    17.652     0.638     0.200
    17.954    -1.723     0.200
    20.344    -1.417     0.200
    20.936    -2.513     0.200
    21.321    -3.646     0.200
    21.394    -2.930     0.200
    24.012    -2.645     0.200
    24.735     0.766     0.200
    25.780     1.292     0.200
    27.829    -0.028     0.200
    27.927     1.596     0.200
    28.171     0.227     0.200
    28.700     1.320     0.200
    29.819    -0.593     0.200
    30.815    -0.386     0.200
    32.577     0.134     0.200
    33.639     1.169     0.200
    37.256     0.635     0.200
    38.567     2.791     0.200
    39.512    -1.231     0.200
    39.833    -0.274     0.200
    40.006    -1.205     0.200
    40.303    -0.860     0.200
    40.443    -0.743     0.200
    43.216     1.853     0.200
    44.006    -0.297     0.200
    44.222     0.673     0.200
    44.425    -0.500     0.200
    47.026     0.916     0.200
    47.534     1.608     0.200
    47.984     1.078     0.200
    48.070     0.279     0.200
    48.588     0.064     0.200
    48.816     0.448     0.200
    48.949     0.669     0.200
    49.101    -0.171     0.200
    49.161    -0.509     0.200
    49.410     0.792     0.200
    49.580     0.975     0.200
    49.844     0.346     0.200
    50.013     0.516     0.200
    50.267     0.535     0.200
    50.702     0.236     0.200
    50.919     0.085     0.200
    51.036     0.108     0.200
    51.277     0.881     0.200
    53.345    -0.956     0.200
    54.058    -1.667     0.200
    55.592    -0.154     0.200
    58.659    -0.605     0.200
    58.998    -1.359     0.200
    59.544    -1.151     0.200
    59.708     0.343     0.200
    60.498    -0.957     0.200
    62.309     1.716     0.200
    62.469     0.648     0.200
    62.503    -2.575     0.200
    63.817    -0.576     0.200
    64.237    -1.530     0.200
    64.676    -2.198     0.200
    64.773    -1.507     0.200
    65.181     0.929     0.200
    65.925    -1.475     0.200
    66.167     1.044     0.200
    66.324     1.342     0.200
    68.453     1.115     0.200
    69.310     0.500     0.200
    69.552     0.699     0.200
    69.833    -1.630     0.200
    69.833    -1.279     0.200
    69.849     1.216     0.200
    69.920     1.566     0.200
    70.889     2.101     0.200
    70.979     1.254     0.200
    73.087     1.135     0.200
    73.126     0.594     0.200
    74.445    -1.050     0.200
    75.380     0.030     0.200
    77.163    -0.573     0.200
    77.254     1.416     0.200
    77.322     1.985     0.200
    77.654     0.681     0.200
    78.210     0.596     0.200
    78.718    -0.199     0.200
    79.945    -0.330     0.200
    80.480     0.138     0.200
    80.989     0.522     0.200
    81.625    -0.747     0.200
    81.993    -1.182     0.200
    83.776    -0.815     0.200
    83.917     0.165     0.200
    84.074    -0.532     0.200
    84.304     0.103     0.200
    84.362    -0.391     0.200
    85.117     0.314     0.200
    85.180    -0.403     0.200
    85.946     0.541     0.200
    85.946     1.091     0.200
    18.145    -1.545     0.200
    20.903    -2.611     0.200
    21.093    -0.661     0.200
    21.105    -0.224     0.200
    21.233    -3.966     0.200
    24.249    -4.020     0.200
    26.624     0.847     0.200
    28.635     0.076     0.200
    28.734     1.995     0.200
    30.042    -1.990     0.200
    30.285     0.063     0.200
    33.284     0.536     0.200
    39.691     0.813     0.200
    39.857     2.392     0.200
    39.915    -1.340     0.200
    40.428    -1.734     0.200
    40.459    -0.695     0.200
    40.467    -0.261     0.200
    40.684    -0.851     0.200
    41.289    -0.030     0.200
    43.275     0.328     0.200
    43.693    -0.391     0.200
    45.068     1.084     0.200
    47.801     0.923     0.200
    48.844     0.396     0.200
    49.350     0.367     0.200
    49.707     0.153     0.200
    50.162     0.841     0.200
    50.599     0.457     0.200
    51.009     0.725     0.200
    51.433     0.392     0.200
    51.660     0.335     0.200
    51.764     0.298     0.200
    52.008     0.248     0.200
    52.417    -0.479     0.200
    53.628    -1.595     0.200
    56.107    -0.205     0.200
    57.880    -0.941     0.200
    57.951    -0.540     0.200
    59.500    -0.497     0.200
    60.367    -1.445     0.200
    60.451    -0.708     0.200
    60.504    -0.176     0.200
    61.096    -1.371     0.200
    64.290    -1.258     0.200
    64.375     0.164     0.200
    64.833    -1.326     0.200
    64.872    -0.356     0.200
    65.987    -1.563     0.200
    68.750     0.976     0.200
    68.820     0.843     0.200
    68.824    -1.279     0.200
    69.810    -0.977     0.200
    69.810    -1.051     0.200
    69.827    -1.225     0.200
    70.053     1.310     0.200
    70.847     1.902     0.200
    71.047    -0.559     0.200
    71.214     1.500     0.200
    71.885    -0.517     0.200
    71.935    -0.279     0.200
    72.060    -0.287     0.200
    72.060     1.936     0.200
    72.188     0.909     0.200
    72.250     0.978     0.200
    72.319     0.538     0.200
    72.469    -0.234     0.200
    72.969    -0.261     0.200
    72.969     0.758     0.200
    73.715    -0.735     0.200
    74.228     0.443     0.200
    74.317    -0.054     0.200
    76.437     1.239     0.200
    76.787     0.142     0.200
    77.054     0.249     0.200
    77.240    -0.603     0.200
    77.256    -0.293     0.200
    77.332    -0.692     0.200
    77.516    -0.250     0.200
    77.755    -0.178     0.200
    78.282     0.099     0.200
    78.818     0.047     0.200
    79.006    -1.405     0.200
    79.217    -0.034     0.200
    80.596    -0.185     0.200
    81.148    -1.626     0.200
    81.679    -0.539     0.200
    82.104    -1.268     0.200
    82.337    -0.486     0.200
    82.344    -0.826     0.200
    83.334    -1.051     0.200
    83.642    -0.332     0.200
    83.809    -0.686     0.200
    83.845    -0.369     0.200
    84.019    -0.256     0.200
    84.105    -0.598     0.200
    84.241    -0.587     0.200
    84.364    -0.505     0.200
    84.376     0.230     0.200
    84.394    -0.362     0.200
    84.763    -0.517     0.200
    84.835    -0.383     0.200
    84.953    -0.274     0.200
    85.035    -0.187     0.200
    85.115     0.636     0.200
    85.115     1.092     0.200
    85.185    -0.037     0.200
    85.205    -0.034     0.200
    85.540    -0.806     0.200
    85.648    -0.040     0.200
    85.658    -0.089     0.200
    86.285    -0.488     0.200
    86.302     0.032     0.200
    86.336    -0.636     0.200
    86.472    -0.565     0.200
    86.622     0.162     0.200
    86.873     0.235     0.200
    87.824     0.354     0.200
    88.715    -0.853     0.200
    89.119     0.448     0.200
    93.107    -0.516     0.200
    17.826    -2.016     0.200
    20.709    -0.921     0.200
    21.030    -2.540     0.200
    25.597    -1.987     0.200
    26.083    -0.820     0.200
    28.303    -0.530     0.200
    32.900     0.439     0.200
    39.631    -1.511     0.200
    40.076    -0.654     0.200
    43.249     0.939     0.200
    43.590     2.070     0.200
    43.967    -0.279     0.200
    48.720    -0.818     0.200
    50.233     0.655     0.200
    50.617     0.652     0.200
    51.043     0.591     0.200
    51.375     0.804     0.200
    51.618     0.733     0.200
    53.292     0.374     0.200
    53.392    -0.654     0.200
    57.759    -0.378     0.200
    58.209    -0.122     0.200
    59.405    -0.424     0.200
    64.151    -1.523     0.200
    64.672    -2.120     0.200
    64.692    -1.301     0.200
    64.839     0.537     0.200
    65.845    -1.610     0.200
    66.519     0.125     0.200
    67.725     0.160     0.200
    68.551     1.761     0.200
    68.835    -0.430     0.200
    69.373     0.462     0.200
    69.442     0.522     0.200
    69.706    -1.196     0.200
    69.706    -1.047     0.200
    70.411     1.061     0.200
    70.769     0.711     0.200
    72.532     0.730     0.200
    72.609     0.668     0.200
    72.649     0.325     0.200
    74.119     0.679     0.200
    74.632     1.450     0.200
    74.631    -0.112     0.200
    75.344     0.599     0.200
    75.920     1.355     0.200
    76.845     0.783     0.200
    77.596     0.564     0.200
    78.846    -0.058     0.200
    79.552    -1.545     0.200
    85.468     0.557     0.200
    85.468     0.452     0.200
    14.136     8.508     0.200
    16.250     3.393     0.200
    17.416     0.373     0.200
    19.984    -1.315     0.200
    19.995    -1.671     0.200
    20.356    -0.856     0.200
    20.566    -2.128     0.200
    21.339    -3.270     0.200
    23.099     1.434     0.200
    23.202     2.202     0.200
    23.470    -2.056     0.200
    23.885    -3.951     0.200
    24.441    -1.705     0.200
    25.402    -1.664     0.200
    25.594    -1.048     0.200
    27.560    -0.635     0.200
    27.609     0.432     0.200
    27.944    -0.362     0.200
    28.933    -0.467     0.200
    29.079    -0.760     0.200
    29.591     0.300     0.200
    30.333    -0.964     0.200
    32.248     1.370     0.200
    32.889     1.254     0.200
    33.262     0.297     0.200
    36.059     1.828     0.200
    36.880     0.127     0.200
    39.550     0.346     0.200
    40.109    -0.802     0.200
    40.763    -0.606     0.200
    40.957     2.392     0.200
    42.397    -0.005     0.200
    42.682     0.197     0.200
    42.776    -1.066     0.200
    42.861     2.140     0.200
    42.829    -0.749     0.200
    43.635    -0.915     0.200
    43.641    -1.099     0.200
    43.844     0.358     0.200
    43.844     0.858     0.200
    43.810    -0.617     0.200
    43.929    -0.444     0.200
    44.043    -0.399     0.200
    44.315     0.335     0.200
    44.567     0.418     0.200
    44.734    -0.663     0.200
    45.368     0.748     0.200
    45.710     0.110     0.200
    47.178     0.575     0.200
    47.632     0.904     0.200
    47.715     0.453     0.200
    47.727     0.886     0.200
    48.237     0.415     0.200
    48.261     0.439     0.200
    48.600     0.444     0.200
    49.064     1.304     0.200
    49.292     1.006     0.200
    49.413     1.286     0.200
    49.924     1.117     0.200
    50.363     0.558     0.200
    50.576     0.578     0.200
    50.697     0.380     0.200
    50.938     0.220     0.200
    51.047    -1.987     0.200
    51.078     1.478     0.200
    51.980     0.235     0.200
    52.410     0.341     0.200
    52.459    -0.326     0.200
    52.684    -1.993     0.200
    52.796     0.381     0.200
    53.193    -1.245     0.200
    53.724    -0.641     0.200
    55.682    -1.339     0.200
    55.770    -1.184     0.200
    58.410    -1.440     0.200
    58.987    -2.357     0.200
    58.956    -0.194     0.200
    59.534    -0.828     0.200
    60.748    -1.456     0.200
    62.028     0.294     0.200
    62.028    -0.284     0.200
    62.202    -0.073     0.200
    62.659    -1.130     0.200
    62.974     1.626     0.200
    62.984     1.186     0.200
    63.065     1.544     0.200
    63.385     0.661     0.200
    63.607     0.995     0.200
    63.702    -1.745     0.200
    63.980     1.823     0.200
    64.184    -2.112     0.200
    64.155     1.245     0.200
    64.560    -1.177     0.200
    64.518     0.907     0.200
    64.717    -1.713     0.200
    64.744     1.271     0.200
    64.788     1.329     0.200
    65.529     0.671     0.200
    65.535     0.502     0.200
    65.669     0.417     0.200
    65.867    -1.852     0.200
    65.877     0.113     0.200
    65.985     0.241     0.200
    65.986    -0.014     0.200
    66.563     1.445     0.200
    66.676     1.085     0.200
    68.264     0.327     0.200
    68.563     0.809     0.200
    68.746     0.238     0.200
    68.773    -0.037     0.200
    69.401     0.127     0.200
    69.653     0.511     0.200
    69.814    -0.890     0.200
    69.814    -0.918     0.200
    69.897     0.993     0.200
    70.222     0.201     0.200
    70.272     0.431     0.200
    70.324     0.027     0.200
    71.254     1.398     0.200
    71.343     1.412     0.200
    71.606     0.811     0.200
    71.816     1.661     0.200
    71.824     1.390     0.200
    71.818     1.455     0.200
    71.859     1.606     0.200
    72.136     0.846     0.200
    72.702     1.841     0.200
    72.953     1.324     0.200
    73.060     0.883     0.200
    73.141     0.676     0.200
    73.367     1.076     0.200
    73.452     0.996     0.200
    73.461     0.943     0.200
    73.473     0.352     0.200
    73.680     0.667     0.200
    73.802     0.549     0.200
    74.112     1.048     0.200
    74.163     0.873     0.200
    74.753    -0.758     0.200
    74.833     0.873     0.200
    74.838     1.240     0.200
    74.853     1.456     0.200
    75.289     0.120     0.200
    75.405     0.563     0.200
    75.441     0.038     0.200
    76.054     0.445     0.200
    76.136    -0.103     0.200
    76.219    -0.093     0.200
    76.264    -0.248     0.200
    76.596     0.272     0.200
    76.865    -0.148     0.200
    77.098     0.339     0.200
    77.099    -0.561     0.200
    77.309     0.158     0.200
    77.346     1.264     0.200
    77.580    -0.158     0.200
    77.662    -0.620     0.200
    77.670     0.971     0.200
    78.148    -0.418     0.200
    78.362    -1.208     0.200
    78.643     0.050     0.200
    78.712    -0.711     0.200
    78.826    -0.481     0.200
    79.076     0.371     0.200
    79.361     0.716     0.200
    79.376     0.331     0.200
    79.406     0.168     0.200
    79.400     1.204     0.200
    79.896     0.868     0.200
    80.023    -0.317     0.200
    80.023    -1.188     0.200
    80.186     0.842     0.200
    80.170    -0.224     0.200
    80.230    -0.355     0.200
    80.371    -0.153     0.200
    80.398     1.001     0.200
    80.499     0.761     0.200
    80.633     1.261     0.200
    80.803     0.430     0.200
    80.858     0.539     0.200
    80.882     0.208     0.200
    80.902    -0.501     0.200
    80.918     0.215     0.200
    80.941    -1.106     0.200
    80.955    -0.878     0.200
    81.057    -0.124     0.200
    81.119     0.247     0.200
    81.264     0.375     0.200
    81.292     0.017     0.200
    81.390    -0.295     0.200
    81.542    -0.400     0.200
    81.570     0.156     0.200
    81.576     0.823     0.200
    81.765    -0.537     0.200
    81.779    -0.648     0.200
    81.824     0.914     0.200
    81.826    -0.094     0.200
    81.914    -1.256     0.200
    82.098    -0.522     0.200
    82.178    -0.547     0.200
    82.227    -0.897     0.200
    82.269     0.779     0.200
    82.332     0.648     0.200
    82.633    -0.517     0.200
    83.178    -1.041     0.200
    83.394     0.042     0.200
    83.528    -0.447     0.200
    83.672    -0.984     0.200
    83.678    -0.616     0.200
    83.731    -0.686     0.200
    83.788    -0.879     0.200
    83.831    -0.799     0.200
    83.842    -0.154     0.200
    83.949     0.097     0.200
    84.029    -0.711     0.200
    84.133     0.101     0.200
    84.217     0.634     0.200
    84.232     0.155     0.200
    84.234    -0.554     0.200
    84.241     0.211     0.200
    84.279    -0.480     0.200
    84.317    -0.373     0.200
    84.350    -1.358     0.200
    84.380    -1.062     0.200
    84.500    -0.901     0.200
    84.565    -0.628     0.200
    84.585    -1.130     0.200
    84.611    -0.692     0.200
    84.690    -0.360     0.200
    84.703     0.474     0.200
    84.719    -0.067     0.200
    84.790    -1.413     0.200
    84.828    -0.656     0.200
    84.840    -1.394     0.200
    84.850    -0.362     0.200
    84.892    -0.576     0.200
    84.951    -2.046     0.200
    85.056    -1.095     0.200
    85.056    -0.096     0.200
    85.077     0.093     0.200
    85.075    -2.397     0.200
    85.095    -2.586     0.200
    85.138    -0.211     0.200
    85.077    -0.086     0.200
    85.164    -0.937     0.200
    85.228    -0.960     0.200
    85.269    -0.965     0.200
    85.322    -0.629     0.200
    85.328    -0.459     0.200
    85.379    -0.914     0.200
    85.458    -0.808     0.200
    85.509    -0.861     0.200
    85.706     0.059     0.200
    85.935    -0.975     0.200
    86.308     0.925     0.200
    86.308     0.936     0.200
    86.385     0.602     0.200
    86.477    -0.547     0.200
    86.510    -0.309     0.200
    86.813     0.411     0.200
    87.554    -0.222     0.200
    87.728     0.285     0.200
    87.712     0.098     0.200
    87.957     0.222     0.200
    88.119    -0.776     0.200
    88.641    -0.243     0.200
    89.057     0.705     0.200
    89.393     1.090     0.200
    89.809    -0.098     0.200
    89.944     0.194     0.200
    90.598    -0.746     0.200
    90.621    -4.617     0.200
    91.414     0.203     0.200
    91.514    -0.419     0.200
    93.066    -0.270     0.200
    93.359    -0.269     0.200
    93.530     0.342     0.200
    95.089    -0.350     0.200
    96.034    -0.269     0.200
    17.962    -1.762     0.200
    19.563    -0.443     0.200
    20.273    -2.007     0.200
    20.284    -2.016     0.200
    20.878    -2.428     0.200
    21.298    -2.833     0.200
    22.784     0.878     0.200
    23.479    -0.893     0.200
    23.970    -4.071     0.200
    25.565    -2.606     0.200
    25.806    -0.998     0.200
    27.868    -0.887     0.200
    29.766     0.470     0.200
    30.755     0.534     0.200
    32.517     0.550     0.200
    37.200     0.609     0.200
    38.843    -1.954     0.200
    39.462     0.190     0.200
    39.776    -0.897     0.200
    40.253    -2.054     0.200
    41.590    -0.627     0.200
    42.388     1.008     0.200
    43.156     1.539     0.200
    44.036     0.126     0.200
    44.167     0.637     0.200
    44.167     0.669     0.200
    44.455    -0.685     0.200
    47.475     0.908     0.200
    47.924     0.526     0.200
    48.011     0.258     0.200
    48.018     0.685     0.200
    48.528     0.615     0.200
    48.552     0.009     0.200
    48.756     0.687     0.200
    48.889     0.247     0.200
    49.186    -0.365     0.200
    49.351     0.822     0.200
    49.522     0.523     0.200
    49.784     0.397     0.200
    50.207     0.656     0.200
    50.859     0.524     0.200
    50.976    -0.009     0.200
    51.217     0.338     0.200
    51.324    -1.469     0.200
    52.087     0.739     0.200
    52.500    -0.821     0.200
    52.947    -3.113     0.200
    53.300    -1.213     0.200
    53.796     0.859     0.200
    56.939    -0.640     0.200
    58.686    -0.333     0.200
    58.971    -1.655     0.200
    59.517    -1.160     0.200
    59.649     0.668     0.200
    60.640    -1.110     0.200
    62.185     0.570     0.200
    62.413     0.943     0.200
    62.443    -2.257     0.200
    63.776    -2.987     0.200
    64.204    -1.692     0.200
    64.635    -1.313     0.200
    64.740    -1.395     0.200
    65.222     0.271     0.200
    65.571     0.409     0.200
    65.892    -1.543     0.200
    68.223     1.220     0.200
    68.404    -0.959     0.200
    68.428     0.096     0.200
    68.580     0.547     0.200
    69.592     0.780     0.200
    69.805    -1.432     0.200
    69.805    -0.854     0.200
    70.176     0.364     0.200
    70.325     2.996     0.200
    70.935     1.526     0.200
    73.133    -0.322     0.200
    75.343     0.073     0.200
    76.261    -0.261     0.200
    76.314     0.435     0.200
    76.639     0.598     0.200
    77.129    -0.453     0.200
    77.133    -0.272     0.200
    77.357     0.272     0.200
    77.619    -0.192     0.200
    78.682     0.325     0.200
    78.867    -0.336     0.200
    79.106    -0.296     0.200
    79.106    -0.296     0.200
    79.957    -0.345     0.200
    80.754    -0.295     0.200
    80.946     0.680     0.200
    81.229    -0.619     0.200
    81.353    -0.376     0.200
    81.593    -0.447     0.200
    83.745    -0.521     0.200
    83.783    -0.716     0.200
    83.828    -0.640     0.200
    84.043    -0.438     0.200
    84.229    -0.386     0.200
    84.261     0.250     0.200
    84.270     0.407     0.200
    84.295    -0.319     0.200
    84.331    -0.197     0.200
    84.839    -0.165     0.200
    84.923    -0.486     0.200
    85.149    -0.216     0.200
    85.317    -0.350     0.200
    85.567    -0.698     0.200
    85.617     0.155     0.200
    85.991     1.258     0.200
    86.245     0.153     0.200
    86.400     0.693     0.200
    86.822     0.627     0.200
    89.067     0.440     0.200
    93.070    -0.150     0.200
    14.971     4.588     0.200
    15.594     2.380     0.200
    16.171     2.268     0.200
    24.073    -2.912     0.200
    28.461     1.340     0.200
    32.831     0.806     0.200
    39.641     0.576     0.200
    40.040     0.412     0.200
    40.158    -1.566     0.200
    41.272    -0.279     0.200
    43.712     0.000     0.200
    44.131    -0.447     0.200
    44.543     1.265     0.200
    47.311     0.463     0.200
    48.272     0.091     0.200
    48.598     0.701     0.200
    48.867    -0.281     0.200
    48.883    -0.880     0.200
    53.427    -0.918     0.200
    56.973    -1.582     0.200
    57.843    -0.906     0.200
    58.373    -0.312     0.200
    59.499    -0.548     0.200
    62.275    -0.036     0.200
    62.643    -0.564     0.200
    64.229    -1.269     0.200
    64.768    -1.362     0.200
    65.921    -1.739     0.200
    66.369     0.087     0.200
    68.481    -0.987     0.200
    68.568     0.608     0.200
    69.236     1.161     0.200
    70.564     1.613     0.200
    72.689     1.453     0.200
    72.809     0.584     0.200
    78.915    -0.340     0.200
    79.709    -0.556     0.200
    85.622     0.789     0.200
    15.565     1.882     0.200
    17.935    -2.003     0.200
    18.652    -0.089     0.200
    19.637    -0.349     0.200
    20.378    -2.882     0.200
    21.325    -3.076     0.200
    22.699     0.146     0.200
    22.699     2.248     0.200
    23.872    -4.446     0.200
    24.033    -2.812     0.200
    27.973    -0.482     0.200
    28.203    -0.133     0.200
    28.379    -0.492     0.200
    28.677    -0.451     0.200
    29.851     0.348     0.200
    30.257    -2.844     0.200
    30.859     0.347     0.200
    32.619     0.389     0.200
    33.304    -0.684     0.200
    33.685    -0.004     0.200
    37.302     0.575     0.200
    39.872     0.040     0.200
    40.038    -1.139     0.200
    40.331    -1.165     0.200
    41.529    -0.290     0.200
    43.260     1.925     0.200
    43.972     0.034     0.200
    44.267     0.586     0.200
    44.267     0.891     0.200
    44.391    -0.247     0.200
    47.071     0.982     0.200
    47.579     0.136     0.200
    48.029     0.813     0.200
    48.115     0.529     0.200
    48.180    -0.074     0.200
    48.443     0.504     0.200
    48.633     0.446     0.200
    48.657     0.207     0.200
    48.860     0.504     0.200
    48.993     0.183     0.200
    49.131    -0.268     0.200
    49.300    -0.260     0.200
    49.455     1.059     0.200
    49.618     0.516     0.200
    49.888     0.668     0.200
    51.459     1.647     0.200
    52.156    -0.549     0.200
    53.369    -0.894     0.200
    54.101    -1.844     0.200
    57.043     0.157     0.200
    57.043     1.103     0.200
    58.627    -0.498     0.200
    59.551    -1.203     0.200
    59.754     0.171     0.200
    62.506    -0.455     0.200
    62.456    -0.227     0.200
    62.548     0.415     0.200
    62.548     0.798     0.200
    63.061    -0.258     0.200
    63.061     1.008     0.200
    64.249    -1.572     0.200
    64.696    -1.181     0.200
    64.786    -1.270     0.200
    65.493     0.478     0.200
    65.938    -1.315     0.200
    66.183     0.860     0.200
    68.481     0.278     0.200
    68.507    -0.179     0.200
    69.645     1.068     0.200
    69.810     0.531     0.200
    69.842    -1.336     0.200
    69.842    -1.040     0.200
    70.847     1.755     0.200
    70.936     1.391     0.200
    73.045     1.087     0.200
    73.825     0.977     0.200
    74.411    -0.439     0.200
    74.442    -0.554     0.200
    74.442     0.508     0.200
    74.533    -0.759     0.200
    74.953    -0.867     0.200
    74.955    -0.174     0.200
    75.397     0.179     0.200
    76.311     0.267     0.200
    76.358     1.495     0.200
    77.177    -0.506     0.200
    77.409     0.294     0.200
    77.669    -0.055     0.200
    78.224    -0.130     0.200
    78.732     0.364     0.200
    78.917    -0.126     0.200
    79.154     0.259     0.200
    79.154     0.259     0.200
    79.922    -1.037     0.200
    80.495     1.004     0.200
    80.963    -0.698     0.200
    81.008     0.361     0.200
    81.010     0.850     0.200
    81.144    -0.158     0.200
    81.207     0.108     0.200
    81.257    -0.054     0.200
    81.652    -0.142     0.200
    81.980    -0.066     0.200
    82.294    -1.314     0.200
    83.866    -1.527     0.200
    84.745    -0.776     0.200
    84.875    -0.928     0.200
    84.999    -1.051     0.200
    85.904     1.343     0.200
    88.697    -0.212     0.200
    93.110    -0.069     0.200
    15.118     6.747     0.200
    19.964     0.186     0.200
    22.950     2.655     0.200
    23.665    -3.276     0.200
    25.463     0.930     0.200
    39.130     0.581     0.200
    39.616    -0.929     0.200
    41.650    -0.473     0.200
    43.849    -0.209     0.200
    43.913     1.622     0.200
    44.526    -0.728     0.200
    46.652     1.402     0.200
    47.161     0.126     0.200
    47.607     0.959     0.200
    47.696     0.672     0.200
    47.700     0.841     0.200
    47.772    -0.223     0.200
    48.007     0.786     0.200
    48.209     0.597     0.200
    48.234    -0.093     0.200
    48.437     0.639     0.200
    48.569     0.629     0.200
    48.864     0.558     0.200
    49.028     0.698     0.200
    49.221    -0.701     0.200
    51.772     0.060     0.200
    52.985    -0.916     0.200
    57.167    -1.462     0.200
    57.580    -0.940     0.200
    58.738    -0.702     0.200
    59.277    -0.843     0.200
    62.520    -0.208     0.200
    63.937    -2.809     0.200
    64.336    -0.725     0.200
    64.472    -1.313     0.200
    66.247     0.441     0.200
    68.076     0.989     0.200
    68.806    -0.562     0.200
    69.477     1.180     0.200
    69.558    -1.133     0.200
    69.558    -0.781     0.200
    69.725     1.039     0.200
    70.309     0.380     0.200
    71.116     2.348     0.200
    73.305     1.048     0.200
    73.948     0.586     0.200
    75.055     0.256     0.200
    75.980    -0.443     0.200
    76.596     1.758     0.200
    76.855    -0.505     0.200
    76.857    -0.211     0.200
    77.030     1.486     0.200
    77.340    -0.226     0.200
    77.904    -0.075     0.200
    78.403     0.061     0.200
    78.587    -0.123     0.200
    78.833     0.295     0.200
    79.919    -0.999     0.200
    80.136    -0.596     0.200
    80.161     0.571     0.200
    80.816     0.052     0.200
    80.879     0.018     0.200
    81.325    -0.653     0.200
    81.328    -0.170     0.200
    83.283    -0.590     0.200
    83.482    -0.617     0.200
    83.577    -0.905     0.200
    83.781    -0.748     0.200
    83.980    -0.568     0.200
    83.989     0.091     0.200
    83.998     0.045     0.200
    84.031    -0.526     0.200
    84.068    -0.518     0.200
    84.594    -0.279     0.200
    84.649    -0.661     0.200
    84.721    -1.022     0.200
    85.298    -0.315     0.200
    85.363    -0.240     0.200
    85.892    -0.567     0.200
    85.939    -0.803     0.200
    85.985    -0.128     0.200
    86.163     1.738     0.200
    86.265     0.194     0.200
    86.562     0.430     0.200
    87.481     0.264     0.200
    88.807     0.375     0.200
    92.814    -0.412     0.200
    14.731     3.591     0.200
    19.248    -0.692     0.200
    19.907    -1.161     0.200
    19.917    -2.021     0.200
    20.497    -1.555     0.200
    25.507     0.221     0.200
    27.490    -1.029     0.200
    28.016    -1.722     0.200
    28.972    -1.225     0.200
    32.166     1.112     0.200
    39.223    -2.372     0.200
    39.464     1.503     0.200
    40.023    -2.140     0.200
    42.785     1.622     0.200
    43.548    -0.320     0.200
    43.787    -0.220     0.200
    44.322    -0.854     0.200
    47.102     1.179     0.200
    47.555     1.265     0.200
    47.640     0.711     0.200
    47.650     0.829     0.200
    47.871     0.217     0.200
    48.522    -0.196     0.200
    49.445     0.068     0.200
    54.106     0.743     0.200
    59.466     0.073     0.200
    62.289    -0.508     0.200
    66.017     0.789     0.200
    69.744    -1.675     0.200
    78.749    -0.037     0.200
    17.970    -1.316     0.200
    18.655    -0.842     0.200
    19.592    -0.275     0.200
    20.341    -1.709     0.200
    20.940    -2.674     0.200
    21.339    -3.262     0.200
    21.410    -2.314     0.200
    22.746     1.737     0.200
    23.548    -1.591     0.200
    24.030    -4.192     0.200
    24.744    -1.500     0.200
    24.796    -0.160     0.200
    25.781    -2.402     0.200
    25.876    -0.660     0.200
    27.844    -0.844     0.200
    27.932    -1.428     0.200
    28.186    -0.289     0.200
    28.359    -0.134     0.200
    28.715    -2.490     0.200
    29.834     0.091     0.200
    30.822    -0.330     0.200
    32.586    -0.329     0.200
    33.262    -0.730     0.200
    33.641    -0.224     0.200
    37.259     0.440     0.200
    37.259     1.088     0.200
    39.528    -0.886     0.200
    39.846     0.248     0.200
    40.453     0.029     0.200
    40.637     1.610     0.200
    41.572    -0.570     0.200
    42.362     0.742     0.200
    42.492    -0.967     0.200
    42.613    -0.323     0.200
    42.694     1.100     0.200
    42.762     0.547     0.200
    43.004     0.394     0.200
    43.223     1.627     0.200
    43.223     1.838     0.200
    43.624    -0.444     0.200
    43.726    -1.013     0.200
    44.016     0.052     0.200
    44.223     0.677     0.200
    44.223     0.900     0.200
    44.435    -0.650     0.200
    44.657     1.649     0.200
    44.938    -0.099     0.200
    45.300     1.028     0.200
    45.392     0.198     0.200
    45.520     0.734     0.200
    45.719     1.757     0.200
    45.814     1.322     0.200
    45.960     2.081     0.200
    46.156     1.660     0.200
    46.210     1.717     0.200
    46.329     1.585     0.200
    46.646     0.378     0.200
    46.824     0.749     0.200
    47.102     0.828     0.200
    47.286     1.642     0.200
    47.421     0.751     0.200
    47.431     0.033     0.200
    47.485     1.049     0.200
    47.778     1.193     0.200
    47.778     1.352     0.200
    47.805     1.785     0.200
    47.921     0.891     0.200
    48.095     0.186     0.200
    48.168    -0.177     0.200
    48.284     0.166     0.200
    48.446     0.359     0.200
    48.494    -0.009     0.200
    49.114    -0.638     0.200
    49.173    -0.390     0.200
    49.592     1.216     0.200
    52.150    -0.395     0.200
    52.570     0.195     0.200
    52.744     0.005     0.200
    52.933    -0.288     0.200
    53.170    -0.928     0.200
    53.362    -0.744     0.200
    53.770     1.697     0.200
    54.067    -0.163     0.200
    55.577     0.099     0.200
    55.647    -1.766     0.200
    55.725    -1.186     0.200
    55.993     0.688     0.200
    55.993     1.637     0.200
    57.006    -0.257     0.200
    57.006     1.251     0.200
    57.189    -0.079     0.200
    57.189     1.409     0.200
    57.218    -1.774     0.200
    57.885    -1.560     0.200
    58.056     0.809     0.200
    58.670    -0.394     0.200
    59.017    -1.544     0.200
    59.563    -1.022     0.200
    59.714    -0.551     0.200
    60.668    -1.676     0.200
    60.690     0.579     0.200
    61.187    -0.822     0.200
    62.424    -0.141     0.200
    62.487    -0.421     0.200
    62.510    -0.474     0.200
    63.023    -0.156     0.200
    63.023     1.152     0.200
    63.435     0.491     0.200
    63.835    -2.945     0.200
    63.833     0.565     0.200
    63.899     0.863     0.200
    64.694    -0.967     0.200
    64.792    -1.304     0.200
    65.188     0.454     0.200
    65.539    -0.683     0.200
    65.852    -0.660     0.200
    65.943    -1.245     0.200
    66.331     0.662     0.200
    66.695    -0.471     0.200
    66.750     0.357     0.200
    66.838    -1.263     0.200
    67.589    -0.418     0.200
    68.384     0.088     0.200
    68.470     0.363     0.200
    68.494    -1.090     0.200
    68.767    -1.303     0.200
    68.910    -2.680     0.200
    69.190     0.667     0.200
    69.589    -1.124     0.200
    69.630     1.072     0.200
    69.852    -0.992     0.200
    69.852    -1.015     0.200
    69.926     0.680     0.200
    70.105    -1.850     0.200
    70.144     0.516     0.200
    70.894     1.126     0.200
    71.107     0.901     0.200
    71.170    -1.418     0.200
    71.412     1.309     0.200
    71.455    -0.619     0.200
    72.029     1.225     0.200
    72.129     1.720     0.200
    72.288     0.791     0.200
    72.498    -1.182     0.200
    72.540     0.237     0.200
    72.586     0.976     0.200
    73.016     0.707     0.200
    73.091     0.643     0.200
    73.133     0.758     0.200
    73.208     0.707     0.200
    73.434    -1.014     0.200
    73.742     0.180     0.200
    73.764     1.090     0.200
    73.797     0.456     0.200
    73.821    -0.484     0.200
    73.814     0.797     0.200
    74.180    -2.679     0.200
    74.232    -0.181     0.200
    74.455    -0.554     0.200
    74.500     1.706     0.200
    74.560     0.815     0.200
    74.617     0.482     0.200
    75.112     0.009     0.200
    75.399    -0.020     0.200
    75.868    -0.628     0.200
    75.948    -0.615     0.200
    76.315    -0.036     0.200
    76.370     0.052     0.200
    76.427     0.729     0.200
    76.405     1.423     0.200
    76.526     0.959     0.200
    76.661    -0.636     0.200
    76.694     0.322     0.200
    76.839     0.704     0.200
    77.181    -0.521     0.200
    77.186    -0.245     0.200
    77.329     0.955     0.200
    77.412     0.391     0.200
    77.673    -0.066     0.200
    77.679     0.100     0.200
    77.850    -0.252     0.200
    78.011    -0.145     0.200
    78.085    -0.252     0.200
    78.229    -0.350     0.200
    78.263    -0.235     0.200
    78.486     0.230     0.200
    78.635    -1.219     0.200
    78.736     0.158     0.200
    78.771    -0.637     0.200
    78.843     0.483     0.200
    78.921    -0.257     0.200
    79.159     0.441     0.200
    79.251     0.542     0.200
    79.333    -0.506     0.200
    79.484     0.171     0.200
    79.592     0.788     0.200
    79.625     0.307     0.200
    79.685    -0.019     0.200
    79.701    -0.207     0.200
    79.712     0.380     0.200
    79.769     0.717     0.200
    79.815     0.010     0.200
    79.844    -0.178     0.200
    79.959    -0.677     0.200
    80.083    -0.731     0.200
    80.097    -0.348     0.200
    80.188    -0.037     0.200
    80.267     1.209     0.200
    80.299    -0.630     0.200
    80.355     0.967     0.200
    80.402     0.313     0.200
    80.420     0.821     0.200
    80.477    -0.289     0.200
    80.498     0.698     0.200
    80.618    -0.542     0.200
    80.661    -0.421     0.200
    80.796    -0.092     0.200
    80.863    -0.570     0.200
    80.960     0.633     0.200
    80.953    -0.232     0.200
    80.959     0.442     0.200
    80.955    -1.019     0.200
    80.975     0.053     0.200
    80.976    -0.351     0.200
    81.006     0.586     0.200
    81.012     0.160     0.200
    81.013    -0.848     0.200
    81.044    -1.102     0.200
    81.115    -1.172     0.200
    81.148     0.136     0.200
    81.211     0.199     0.200
    81.248    -0.797     0.200
    81.280     0.498     0.200
    81.271    -0.119     0.200
    81.343    -0.595     0.200
    81.372    -0.249     0.200
    81.394     0.029     0.200
    81.447    -0.852     0.200
    81.616    -0.442     0.200
    81.657     0.146     0.200
    81.763    -0.613     0.200
    81.800    -0.109     0.200
    81.843    -0.337     0.200
    81.852    -0.585     0.200
    81.976    -0.533     0.200
    82.012    -1.029     0.200
    82.041    -0.076     0.200
    82.064     0.807     0.200
    82.070     0.575     0.200
    82.101    -0.386     0.200
    82.149     0.252     0.200
    82.172    -0.561     0.200
    82.247    -0.755     0.200
    82.300    -0.832     0.200
    82.314    -0.698     0.200
    82.325    -0.258     0.200
    82.335     0.289     0.200
    82.350    -0.090     0.200
    82.370    -0.491     0.200
    82.384    -0.269     0.200
    82.413    -0.216     0.200
    82.492     0.171     0.200
    82.509     1.051     0.200
    82.510     0.776     0.200
    82.529    -0.423     0.200
    82.544     0.573     0.200
    82.543    -0.298     0.200
    82.544    -0.199     0.200
    82.574    -0.376     0.200
    82.708    -0.352     0.200
    82.740    -0.219     0.200
    82.808    -0.070     0.200
    83.010    -0.414     0.200
    83.117    -0.771     0.200
    83.155    -0.269     0.200
    83.265    -0.722     0.200
    83.350     0.463     0.200
    83.384    -0.043     0.200
    83.408     0.133     0.200
    83.479    -0.029     0.200
    83.462     0.596     0.200
    83.527    -0.379     0.200
    83.586     0.220     0.200
    83.603    -0.366     0.200
    83.606    -0.284     0.200
    83.689    -0.106     0.200
    83.706     0.697     0.200
    83.795    -0.550     0.200
    83.830    -0.730     0.200
    83.840     0.560     0.200
    83.875    -0.757     0.200
    83.900     1.048     0.200
    83.927    -0.976     0.200
    83.936     0.033     0.200
    83.946    -0.987     0.200
    84.064     0.300     0.200
    84.077    -0.584     0.200
    84.085    -0.324     0.200
    84.096    -0.603     0.200
    84.103     0.242     0.200
    84.167     1.325     0.200
    84.195    -0.085     0.200
    84.216     0.370     0.200
    84.313     0.114     0.200
    84.323     0.267     0.200
    84.345    -0.347     0.200
    84.381    -0.325     0.200
    84.424    -1.914     0.200
    84.434    -1.355     0.200
    84.471    -0.923     0.200
    84.567     0.484     0.200
    84.608     0.121     0.200
    84.697    -2.238     0.200
    84.731     0.128     0.200
    84.752    -0.401     0.200
    84.738    -0.097     0.200
    84.803    -0.224     0.200
    84.881    -1.317     0.200
    84.885    -0.166     0.200
    84.912     1.745     0.200
    84.929    -1.028     0.200
    84.976    -0.523     0.200
    85.010     0.011     0.200
    85.034     1.556     0.200
    85.037    -1.749     0.200
    85.103    -1.729     0.200
    85.102     0.049     0.200
    85.135    -0.020     0.200
    85.163    -2.289     0.200
    85.163    -1.326     0.200
    85.183    -2.385     0.200
    85.216     0.408     0.200
    85.255    -0.463     0.200
    85.358    -0.228     0.200
    85.363    -0.251     0.200
    85.380    -1.349     0.200
    85.380     0.360     0.200
    85.408     0.119     0.200
    85.410    -0.486     0.200
    85.468    -0.878     0.200
    85.512     0.687     0.200
    85.546    -0.663     0.200
    85.599    -0.925     0.200
    85.619     0.074     0.200
    85.665     0.041     0.200
    85.768    -0.665     0.200
    85.783     0.363     0.200
    85.787     0.041     0.200
    85.951     0.780     0.200
    85.951     0.479     0.200
    85.981    -0.817     0.200
    86.022    -0.822     0.200
    86.012    -0.211     0.200
    86.059    -0.003     0.200
    86.115    -0.078     0.200
    86.192     0.041     0.200
    86.355     0.343     0.200
    86.397    -0.164     0.200
    86.433     0.159     0.200
    86.585     0.216     0.200
    86.590    -0.012     0.200
    86.625    -0.185     0.200
    86.871     0.515     0.200
    87.241    -0.137     0.200
    87.628    -0.006     0.200
    87.798     0.356     0.200
    88.351     1.815     0.200
    88.472     0.263     0.200
    89.077     0.392     0.200
    89.116     0.735     0.200
    89.187     0.166     0.200
    89.190     0.989     0.200
    89.297    -0.384     0.200
    89.636     0.228     0.200
    89.950    -0.044     0.200
    90.142     0.887     0.200
    90.166    -0.359     0.200
    90.558    -0.586     0.200
    90.624    -0.506     0.200
    90.679    -1.010     0.200
    90.735    -0.280     0.200
    91.361     0.518     0.200
    91.545    -0.219     0.200
    91.852    -0.347     0.200
    91.980    -0.590     0.200
    92.283    -0.497     0.200
    92.292     0.005     0.200
    92.741    -0.405     0.200
    93.119    -0.604     0.200
    93.119    -0.015     0.200
    93.311    -0.533     0.200
    93.508    -0.441     0.200
    93.592     0.735     0.200
    94.010    -0.747     0.200
    94.441     0.917     0.200
    94.538     0.945     0.200
    95.486    -0.443     0.200
    95.492    -0.628     0.200
    95.807    -0.365     0.200
    96.216    -0.326     0.200
    20.283    -1.525     0.200
    25.808    -0.029     0.200
    28.121     0.311     0.200
    32.517     0.799     0.200
    37.196    -0.012     0.200
    39.777     0.044     0.200
    42.546     0.026     0.200
    43.154     2.733     0.200
    43.808    -0.514     0.200
    43.808    -0.655     0.200
    44.163     0.210     0.200
    44.462    -0.864     0.200
    47.729    -0.691     0.200
    47.729    -0.558     0.200
    48.017     0.815     0.200
    48.106     0.151     0.200
    48.527     0.691     0.200
    48.551    -0.196     0.200
    48.873    -0.347     0.200
    48.873     0.036     0.200
    48.888    -0.177     0.200
    49.194    -0.868     0.200
    49.349     0.998     0.200
    51.668    -0.582     0.200
    53.305    -0.829     0.200
    53.305    -0.688     0.200
    57.222    -1.509     0.200
    59.524    -1.552     0.200
    62.427    -0.080     0.200
    64.210    -1.874     0.200
    64.746    -1.223     0.200
    65.898    -1.316     0.200
    66.154     0.789     0.200
    69.812    -1.111     0.200
    69.812    -1.033     0.200
    70.941     1.031     0.200
    73.173     0.720     0.200
    77.135    -0.319     0.200
    78.688    -0.141     0.200
    85.997     1.117     0.200
    42.681    -0.015     0.200
    43.934    -0.936     0.200
    44.369    -0.464     0.200
    47.845    -1.006     0.200
    48.223    -1.211     0.200
    48.990    -1.183     0.200
    49.113    -0.584     0.200
    58.607    -0.873     0.200
    62.457    -1.156     0.200
    64.815    -1.766     0.200
    69.867    -1.562     0.200
    73.055     0.167     0.200
    76.325     1.629     0.200
    85.869     1.316     0.200
    17.897    -0.787     0.200
    41.291    -0.392     0.200
    42.859    -0.096     0.200
    44.088    -0.602     0.200
    44.147    -0.989     0.200
    47.976    -0.607     0.200
    48.908    -0.698     0.200
    58.393    -0.648     0.200
    62.593    -0.500     0.200
    64.850    -1.138     0.200
    66.319     0.263     0.200
    72.807     0.710     0.200
    85.611     0.931     0.200
    17.640    -0.318     0.200
    17.941    -2.398     0.200
    18.621    -0.928     0.200
    19.607    -0.151     0.200
    20.328    -1.720     0.200
    20.338    -1.744     0.200
    20.338    -2.166     0.200
    20.933    -2.650     0.200
    21.305    -4.365     0.200
    21.305    -3.349     0.200
    21.380    -2.656     0.200
    23.997    -3.332     0.200
    24.806    -0.655     0.200
    25.852    -0.184     0.200
    27.816    -0.228     0.200
    27.924    -0.887     0.200
    28.158    -0.181     0.200
    28.333    -0.132     0.200
    29.409    -1.434     0.200
    30.245    -0.971     0.200
    30.809     0.048     0.200
    32.569     0.689     0.200
    33.255    -0.691     0.200
    33.639    -0.236     0.200
    37.255     0.340     0.200
    39.499     0.400     0.200
    39.823     0.208     0.200
    40.290    -0.949     0.200
    41.552    -0.429     0.200
    42.588    -0.267     0.200
    42.692     1.684     0.200
    42.762     0.121     0.200
    43.006     1.145     0.200
    43.210     2.396     0.200
    43.210     1.325     0.200
    43.605     0.569     0.200
    43.845    -1.311     0.200
    43.997     0.188     0.200
    43.997     0.477     0.200
    44.222     0.785     0.200
    44.222     0.981     0.200
    44.416    -0.374     0.200
    44.929    -0.552     0.200
    47.761    -0.463     0.200
    48.072     0.634     0.200
    48.138    -1.077     0.200
    48.583     0.607     0.200
    48.607     0.320     0.200
    48.905     0.130     0.200
    48.943     0.343     0.200
    49.151    -0.862     0.200
    49.405     1.022     0.200
    51.710    -0.452     0.200
    52.118     0.013     0.200
    52.726     0.014     0.200
    53.331    -1.233     0.200
    54.051    -1.698     0.200
    55.610    -1.240     0.200
    57.851    -1.047     0.200
    58.649    -0.915     0.200
    58.649    -0.516     0.200
    58.983    -1.024     0.200
    59.528    -1.034     0.200
    59.704    -0.705     0.200
    60.482    -0.066     0.200
    60.635    -0.969     0.200
    62.453    -0.239     0.200
    63.012    -1.530     0.200
    63.886     0.697     0.200
    64.221    -1.500     0.200
    64.661    -1.473     0.200
    64.758    -1.204     0.200
    64.868    -2.681     0.200
    65.175     0.290     0.200
    65.909    -1.242     0.200
    66.180     0.614     0.200
    66.319     0.362     0.200
    67.559     0.054     0.200
    68.440     0.632     0.200
    69.818    -1.202     0.200
    69.818    -0.920     0.200
    70.885     1.591     0.200
    70.950     1.636     0.200
    71.242     1.717     0.200
    71.496     0.640     0.200
    71.683     0.820     0.200
    72.099     0.899     0.200
    73.083     0.969     0.200
    73.120     0.667     0.200
    73.829     1.210     0.200
    74.489     0.539     0.200
    74.584     0.161     0.200
    75.365     0.057     0.200
    75.926    -0.442     0.200
    76.281     0.135     0.200
    76.628     0.056     0.200
    76.660     0.398     0.200
    77.148    -0.749     0.200
    77.152    -0.369     0.200
    77.645    -0.121     0.200
    77.644    -0.538     0.200
    78.195    -0.877     0.200
    78.702    -0.071     0.200
    78.887    -0.388     0.200
    79.125     0.114     0.200
    79.125     0.114     0.200
    79.299    -0.438     0.200
    79.593    -0.535     0.200
    79.653     0.140     0.200
    80.156     0.421     0.200
    80.262    -0.149     0.200
    80.621    -0.774     0.200
    80.829    -0.582     0.200
    81.117    -0.623     0.200
    81.214    -0.728     0.200
    82.266    -0.969     0.200
    82.280    -0.734     0.200
    82.546     0.383     0.200
    83.569    -0.405     0.200
    83.761    -0.589     0.200
    83.796    -0.870     0.200
    84.054    -0.022     0.200
    84.280     0.171     0.200
    84.289     0.124     0.200
    84.311    -0.489     0.200
    84.347    -0.365     0.200
    84.718    -0.442     0.200
    84.851    -0.305     0.200
    84.942    -0.668     0.200
    85.101    -0.559     0.200
    85.328    -0.293     0.200
    85.434    -0.922     0.200
    85.585    -0.068     0.200
    85.942     1.384     0.200
    86.235    -0.584     0.200
    88.670     0.217     0.200
    89.082     0.586     0.200
    93.085    -0.138     0.200
    20.376     0.352     0.200
    20.387    -1.717     0.200
    21.811    -0.963     0.200
    25.888    -0.399     0.200
    28.189    -0.513     0.200
    28.365    -0.864     0.200
    29.462     0.107     0.200
    29.837     0.086     0.200
    30.858    -1.027     0.200
    32.615     0.845     0.200
    39.862    -1.065     0.200
    40.315    -1.017     0.200
    42.622    -0.035     0.200
    42.622    -0.205     0.200
    43.560     0.367     0.200
    43.875    -0.642     0.200
    43.875    -0.503     0.200
    43.952    -0.250     0.200
    44.275    -0.102     0.200
    44.371    -0.272     0.200
    47.579     0.793     0.200
    47.786    -0.527     0.200
    48.028     0.720     0.200
    48.114     0.448     0.200
    48.121     0.798     0.200
    48.164    -0.442     0.200
    48.631     0.674     0.200
    48.655     0.288     0.200
    48.859     0.527     0.200
    48.931    -0.365     0.200
    48.991     0.013     0.200
    49.109    -0.589     0.200
    49.452     0.994     0.200
    49.886     0.594     0.200
    51.745    -0.576     0.200
    53.351    -0.955     0.200
    57.157    -1.848     0.200
    58.606    -0.986     0.200
    58.606    -0.590     0.200
    58.982    -1.193     0.200
    59.528    -1.220     0.200
    62.481    -0.795     0.200
    64.227    -1.609     0.200
    64.764    -1.113     0.200
    65.915    -1.359     0.200
    66.208     0.315     0.200
    69.818    -1.181     0.200
    69.818    -1.101     0.200
    70.833     1.025     0.200
    73.070     0.584     0.200
    74.597    -0.284     0.200
    76.328    -0.011     0.200
    78.711     0.298     0.200
    78.896    -0.876     0.200
    83.765    -0.595     0.200
    83.843    -0.491     0.200
    84.063    -0.613     0.200
    84.077    -0.564     0.200
    84.243    -0.530     0.200
    84.286     0.153     0.200
    84.295     0.207     0.200
    84.316    -0.495     0.200
    84.351    -0.375     0.200
    84.722    -0.548     0.200
    84.949    -0.587     0.200
    85.168    -0.283     0.200
    85.890     0.411     0.200
    85.890     1.210     0.200
    86.242    -0.606     0.200
    86.420     0.622     0.200
    86.841     0.463     0.200
    17.614    -2.069     0.200
    17.614    -2.307     0.200
    17.841    -0.537     0.200
    20.710    -1.746     0.200
    20.710    -1.164     0.200
    21.185    -5.019     0.200
    21.185    -4.757     0.200
    22.203     2.134     0.200
    22.280     0.292     0.200
    22.280    -1.482     0.200
    24.052    -3.582     0.200
    26.096    -0.281     0.200
    26.220     0.058     0.200
    28.344    -0.080     0.200
    28.344     1.049     0.200
    28.538    -0.077     0.200
    29.838    -0.308     0.200
    29.993    -0.266     0.200
    31.185    -0.075     0.200
    32.905     0.651     0.200
    33.665     0.635     0.200
    34.076     0.474     0.200
    37.688     0.608     0.200
    39.649    -0.711     0.200
    40.088    -1.440     0.200
    41.977    -1.895     0.200
    42.811    -0.349     0.200
    42.811    -0.123     0.200
    43.271     0.236     0.200
    43.572     0.191     0.200
    44.022    -0.958     0.200
    43.991    -0.156     0.200
    44.664    -0.168     0.200
    44.664     0.519     0.200
    47.894    -0.870     0.200
    47.913     1.257     0.200
    48.355     0.750     0.200
    48.447     0.847     0.200
    48.447     0.548     0.200
    48.746    -0.945     0.200
    48.956     0.545     0.200
    48.981     0.150     0.200
    49.042    -0.535     0.200
    49.184     0.602     0.200
    49.313     0.218     0.200
    49.770     1.045     0.200
    49.840    -0.688     0.200
    50.207     0.440     0.200
    51.937    -0.522     0.200
    53.414    -1.007     0.200
    56.846    -1.456     0.200
    58.194    -0.564     0.200
    58.234    -0.478     0.200
    59.433    -0.745     0.200
    60.102    -0.067     0.200
    62.763    -0.695     0.200
    64.178    -1.033     0.200
    64.718    -0.877     0.200
    66.489     0.786     0.200
    68.344    -0.984     0.200
    68.570     0.044     0.200
    69.461     1.275     0.200
    69.734    -0.877     0.200
    69.734    -0.697     0.200
    70.428     0.731     0.200
    71.311     1.121     0.200
    72.330     1.943     0.200
    72.626     0.465     0.200
    72.669     0.762     0.200
    74.089    -0.463     0.200
    85.485     0.751     0.200
    20.351     0.590     0.200
    22.734     1.136     0.200
    25.868    -0.731     0.200
    25.868     0.179     0.200
    28.176     0.062     0.200
    28.350    -0.578     0.200
    28.697    -0.658     0.200
    29.418     0.356     0.200
    30.260    -1.800     0.200
    39.517    -0.822     0.200
    42.605    -0.408     0.200
    43.223     2.159     0.200
    43.863    -0.450     0.200
    43.863    -0.348     0.200
    44.229     0.822     0.200
    44.420    -0.552     0.200
    47.779    -0.494     0.200
    47.857    -0.206     0.200
    47.991     0.859     0.200
    48.078     0.494     0.200
    48.085     0.834     0.200
    48.156     0.015     0.200
    48.595     0.510     0.200
    48.619     0.025     0.200
    48.823     0.762     0.200
    48.923    -0.538     0.200
    48.923    -0.007     0.200
    49.157    -0.721     0.200
    49.851     0.522     0.200
    51.727    -0.283     0.200
    53.349    -0.582     0.200
    57.200    -1.451     0.200
    58.654    -0.211     0.200
    59.000    -1.651     0.200
    59.545    -0.374     0.200
    61.951    -1.562     0.200
    62.442     0.486     0.200
    64.239    -1.924     0.200
    64.679    -0.398     0.200
    64.776    -1.255     0.200
    69.835    -1.113     0.200
    69.835    -0.988     0.200
    70.361    -2.936     0.200
    70.883     0.413     0.200
    73.120     0.358     0.200
    74.440    -0.596     0.200
    77.165    -0.757     0.200
    78.720    -0.183     0.200
    78.905    -0.557     0.200
    79.941    -0.112     0.200
    81.628    -0.428     0.200
    82.284    -0.971     0.200
    83.778    -0.690     0.200
    84.076    -0.608     0.200
    84.260    -0.539     0.200
    84.297    -0.031     0.200
    84.306    -0.177     0.200
    84.329    -0.590     0.200
    84.364    -0.370     0.200
    84.736    -1.043     0.200
    84.868    -0.508     0.200
    84.960     0.131     0.200
    85.119    -0.066     0.200
    85.182    -0.479     0.200
    85.602    -0.171     0.200
    85.649    -0.100     0.200
    86.043    -0.152     0.200
    86.252    -0.684     0.200
    89.099     0.587     0.200
    89.120    -0.508     0.200
    18.072    -0.668     0.200
    18.072    -0.817     0.200
    20.928    -0.079     0.200
    22.373    -0.405     0.200
    24.105    -0.947     0.200
    33.131     1.114     0.200
    39.874     0.228     0.200
    40.320     0.492     0.200
    43.043    -0.171     0.200
    43.942     0.140     0.200
    44.838     1.540     0.200
    48.500    -0.007     0.200
    48.720    -0.203     0.200
    49.173     0.139     0.200
    49.198    -0.052     0.200
    49.265    -0.371     0.200
    49.401     0.296     0.200
    49.531     0.303     0.200
    49.989     0.923     0.200
    53.627    -0.777     0.200
    56.876    -1.271     0.200
    59.596    -0.883     0.200
    60.309     0.449     0.200
    62.081    -2.434     0.200
    62.710     0.021     0.200
    64.205     0.317     0.200
    64.358    -2.316     0.200
    64.900    -1.142     0.200
    64.898    -1.031     0.200
    66.436     0.310     0.200
    68.792     1.399     0.200
    69.900    -1.042     0.200
    69.900    -0.870     0.200
    70.303     1.366     0.200
    72.573     1.314     0.200
    79.060    -0.317     0.200
    83.710    -0.410     0.200
    83.884    -0.901     0.200
    83.884    -0.698     0.200
    83.932    -0.444     0.200
    84.181    -0.708     0.200
    84.330     0.036     0.200
    84.430     0.122     0.200
    84.437    -0.609     0.200
    84.440     0.075     0.200
    84.469    -0.473     0.200
    84.928    -0.081     0.200
    85.048    -0.283     0.200
    85.097    -0.631     0.200
    85.250    -0.089     0.200
    85.282    -0.156     0.200
    85.403    -0.555     0.200
    85.366     1.205     0.200
    85.598    -0.926     0.200
    85.725    -0.158     0.200
    85.732     0.014     0.200
    86.149    -0.853     0.200
    86.379     0.017     0.200
    86.395    -0.666     0.200
    86.539     0.536     0.200
    86.690     0.093     0.200
    86.951     0.318     0.200
    87.896     0.380     0.200
    89.197     0.543     0.200
    89.211     0.076     0.200
    18.082    -0.639     0.200
    18.082    -2.267     0.200
    20.952    -0.749     0.200
    20.952    -1.331     0.200
    26.341    -0.037     0.200
    26.427     0.788     0.200
    30.056    -0.079     0.200
    31.426     1.766     0.200
    33.152    -0.257     0.200
    37.903     0.586     0.200
    39.880     0.145     0.200
    43.055    -0.004     0.200
    43.490    -0.064     0.200
    43.909     0.024     0.200
    44.869     1.702     0.200
    48.121    -0.971     0.200
    48.211    -0.468     0.200
    48.505    -0.125     0.200
    48.505    -0.933     0.200
    48.596     0.976     0.200
    48.688    -0.233     0.200
    48.688    -1.483     0.200
    49.197     0.968     0.200
    49.222     0.377     0.200
    49.270    -0.089     0.200
    49.270    -0.667     0.200
    49.425     0.528     0.200
    49.555     0.639     0.200
    50.013     1.161     0.200
    50.449     0.763     0.200
    53.628    -1.461     0.200
    53.628    -1.262     0.200
    55.557    -1.535     0.200
    58.164    -0.913     0.200
    59.583    -0.963     0.200
    62.073    -1.860     0.200
    62.737    -0.160     0.200
    64.349    -1.934     0.200
    64.891    -1.090     0.200
    64.949     0.646     0.200
    64.949    -0.163     0.200
    66.170    -0.832     0.200
    66.463     0.560     0.200
    67.596     0.960     0.200
    68.733     0.946     0.200
    68.796     0.902     0.200
    69.268     0.890     0.200
    69.889    -1.148     0.200
    69.889    -0.875     0.200
    69.900    -1.021     0.200
    70.269     1.368     0.200
    72.467     0.464     0.200
    72.538     0.738     0.200
    75.558    -0.377     0.200
    75.798     1.655     0.200
    77.294    -0.602     0.200
    77.307    -0.577     0.200
    79.054    -0.701     0.200
    81.739    -0.355     0.200
    82.405    -0.442     0.200
    83.874    -0.424     0.200
    84.171    -0.234     0.200
    84.318    -0.079     0.200
    84.428    -0.235     0.200
    84.431    -0.152     0.200
    84.459    -0.196     0.200
    85.089     0.137     0.200
    85.241     0.279     0.200
    85.332     1.150     0.200
    85.717     0.216     0.200
    86.122     0.509     0.200
    86.168    -0.117     0.200
    86.369    -0.205     0.200
    86.388    -0.298     0.200
    86.681    -0.135     0.200
    87.887    -0.050     0.200
    89.187     0.024     0.200
    21.423    -3.513     0.200
    29.478    -1.031     0.200
    39.630    -0.438     0.200
    42.714     0.150     0.200
    44.279     1.180     0.200
    44.440    -0.507     0.200
    47.893    -0.884     0.200
    48.073     0.622     0.200
    48.270    -0.991     0.200
    48.678     0.465     0.200
    48.906     0.520     0.200
    49.037    -0.483     0.200
    49.040     0.195     0.200
    49.189    -1.363     0.200
    49.936     0.574     0.200
    53.463    -0.930     0.200
    57.256    -1.603     0.200
    59.650    -0.459     0.200
    64.885    -1.380     0.200
    69.941    -1.671     0.200
    70.863     1.378     0.200
    73.061     1.366     0.200
    85.924     0.666     0.200
    17.596    -0.082     0.200
    20.269    -1.628     0.200
    20.280    -1.876     0.200
    20.280    -1.688     0.200
    23.969    -3.140     0.200
    25.803    -0.201     0.200
    28.288    -0.597     0.200
    30.750     0.603     0.200
    37.194     0.683     0.200
    42.541    -0.262     0.200
    42.702     0.637     0.200
    42.947     0.653     0.200
    43.151     2.305     0.200
    44.041     0.251     0.200
    44.161     1.190     0.200
    44.460    -0.600     0.200
    47.724    -0.545     0.200
    47.801    -0.640     0.200
    47.920     0.739     0.200
    48.100    -0.856     0.200
    48.100    -0.235     0.200
    48.347     0.775     0.200
    48.524     0.386     0.200
    48.884     0.119     0.200
    48.868    -0.453     0.200
    48.868    -0.054     0.200
    48.891     0.531     0.200
    48.944     0.020     0.200
    49.191    -0.123     0.200
    49.346     0.791     0.200
    49.676     0.204     0.200
    49.780     0.694     0.200
    49.953     0.853     0.200
    52.859    -0.944     0.200
    53.299    -0.479     0.200
    53.593    -2.118     0.200
    53.994    -1.259     0.200
    54.170    -0.023     0.200
    54.170     1.837     0.200
    55.365    -1.473     0.200
    57.218    -1.374     0.200
    58.691    -0.542     0.200
    58.973    -1.238     0.200
    59.519    -1.094     0.200
    59.605    -1.649     0.200
    60.643    -1.602     0.200
    61.916    -2.301     0.200
    62.430    -0.743     0.200
    62.431    -0.365     0.200
    62.952    -1.615     0.200
    64.205    -1.571     0.200
    64.635    -0.982     0.200
    64.741    -1.172     0.200
    65.577    -0.476     0.200
    65.790    -1.058     0.200
    66.158     0.375     0.200
    66.159     0.272     0.200
    67.523     0.303     0.200
    68.432     0.669     0.200
    68.403     0.383     0.200
    69.561     0.399     0.200
    69.806    -1.310     0.200
    69.806    -1.013     0.200
    69.907     1.148     0.200
    70.307    -1.875     0.200
    70.941     1.643     0.200
    71.823     1.476     0.200
    73.139     1.362     0.200
    73.172     0.477     0.200
    74.480    -0.747     0.200
    75.343     0.002     0.200
    76.447     1.793     0.200
    76.639     0.827     0.200
    76.881     1.286     0.200
    77.129    -0.826     0.200
    78.682    -0.048     0.200
    79.107    -0.072     0.200
    79.107    -0.072     0.200
    81.593    -0.520     0.200
    83.746    -0.794     0.200
    84.044    -0.516     0.200
    84.262    -0.221     0.200
    84.271     0.034     0.200
    84.295    -0.592     0.200
    84.332    -0.478     0.200
    84.776     1.131     0.200
    85.618    -0.021     0.200
    85.997     1.253     0.200
    86.007    -0.548     0.200
    87.270     0.118     0.200
    89.088    -0.033     0.200
    15.561     2.493     0.200
    19.548     0.393     0.200
    20.312    -2.106     0.200
    20.323    -1.751     0.200
    20.323    -2.455     0.200
    20.737    -0.191     0.200
    21.349    -4.774     0.200
    21.349    -3.844     0.200
    21.435    -2.588     0.200
    22.781     0.856     0.200
    24.026    -3.481     0.200
    25.857    -0.915     0.200
    28.344    -0.618     0.200
    28.742    -0.961     0.200
    29.820    -0.009     0.200
    30.293    -3.488     0.200
    30.293    -0.230     0.200
    30.793     0.001     0.200
    37.225     0.297     0.200
    39.517     0.179     0.200
    40.309    -1.009     0.200
    41.605    -0.464     0.200
    42.474    -0.847     0.200
    42.596    -0.239     0.200
    42.728     0.300     0.200
    43.193     1.037     0.200
    43.592     1.924     0.200
    43.657    -0.699     0.200
    43.760    -0.925     0.200
    44.049    -0.544     0.200
    44.188     0.322     0.200
    44.188     0.842     0.200
    44.114    -0.561     0.200
    44.468    -0.741     0.200
    45.106    -0.098     0.200
    45.265     1.373     0.200
    45.426    -0.367     0.200
    46.162     1.300     0.200
    47.781    -0.922     0.200
    47.781    -1.172     0.200
    47.858    -1.016     0.200
    47.789    -0.829     0.200
    47.962     0.478     0.200
    48.157    -0.829     0.200
    48.401     0.375     0.200
    48.567     0.322     0.200
    48.591     0.741     0.200
    48.928     0.053     0.200
    48.925    -0.821     0.200
    48.945     0.352     0.200
    48.999    -0.016     0.200
    49.096    -0.430     0.200
    49.258    -0.471     0.200
    49.258    -0.240     0.200
    49.258    -0.611     0.200
    49.205    -0.562     0.200
    49.205    -1.140     0.200
    49.390     0.925     0.200
    49.414     1.268     0.200
    49.474     2.388     0.200
    49.730    -0.064     0.200
    49.824     0.328     0.200
    50.008     0.830     0.200
    51.319     3.491     0.200
    51.718    -0.821     0.200
    52.144    -0.083     0.200
    52.544     1.352     0.200
    52.719    -0.040     0.200
    52.909    -1.042     0.200
    53.356    -1.230     0.200
    53.541     2.512     0.200
    54.217    -0.218     0.200
    54.243     0.017     0.200
    54.829    -1.611     0.200
    55.412    -0.056     0.200
    55.551     1.145     0.200
    55.660    -2.015     0.200
    55.739    -2.201     0.200
    55.962     1.308     0.200
    56.977     1.440     0.200
    57.162    -0.716     0.200
    57.244    -2.097     0.200
    57.523     0.615     0.200
    58.662    -1.650     0.200
    58.702    -1.253     0.200
    59.024    -1.629     0.200
    59.570    -1.237     0.200
    59.570    -0.128     0.200
    59.683    -0.276     0.200
    60.667     0.499     0.200
    60.686    -1.627     0.200
    61.196    -1.260     0.200
    61.396    -0.496     0.200
    61.970    -2.001     0.200
    62.097    -0.154     0.200
    62.157     0.948     0.200
    62.389     0.325     0.200
    62.398     0.135     0.200
    62.399     0.982     0.200
    62.481    -3.216     0.200
    62.662     1.362     0.200
    62.993    -1.627     0.200
    63.077    -0.019     0.200
    63.833    -0.367     0.200
    63.843     1.242     0.200
    63.934     1.063     0.200
    64.259    -1.765     0.200
    64.364     0.510     0.200
    64.477     1.330     0.200
    64.691    -0.788     0.200
    64.795    -1.388     0.200
    64.911    -2.792     0.200
    65.223    -0.292     0.200
    65.278     0.937     0.200
    65.574    -0.205     0.200
    65.574     0.705     0.200
    65.847    -0.663     0.200
    66.127     1.637     0.200
    66.239     1.048     0.200
    66.366     0.831     0.200
    66.785     0.179     0.200
    67.580     0.703     0.200
    68.157    -0.194     0.200
    68.215    -0.335     0.200
    68.245     0.510     0.200
    68.460     1.384     0.200
    68.471    -0.334     0.200
    68.910    -1.616     0.200
    69.353     0.425     0.200
    69.618     0.310     0.200
    69.636    -1.073     0.200
    69.850    -1.027     0.200
    69.859    -1.273     0.200
    69.859    -1.171     0.200
    69.894     0.041     0.200
    69.962     0.248     0.200
    70.018     0.492     0.200
    70.112    -0.624     0.200
    70.179     0.212     0.200
    70.364     0.535     0.200
    70.321     0.686     0.200
    70.785     0.691     0.200
    70.929     1.351     0.200
    71.019     0.488     0.200
    71.170     0.037     0.200
    71.142     0.492     0.200
    71.447     0.976     0.200
    71.812     0.658     0.200
    72.323    -0.268     0.200
    72.491     0.419     0.200
    72.575    -0.543     0.200
    72.830    -0.055     0.200
    73.052     0.598     0.200
    73.127     0.224     0.200
    73.168     0.463     0.200
    73.332     0.166     0.200
    73.562     0.688     0.200
    73.635    -0.278     0.200
    73.777     0.634     0.200
    73.759     0.309     0.200
    73.848     0.256     0.200
    73.849    -0.320     0.200
    74.462     0.771     0.200
    74.548     1.099     0.200
    74.488    -0.760     0.200
    74.616     0.548     0.200
    74.616    -0.210     0.200
    74.535     1.279     0.200
    74.783    -0.596     0.200
    74.914    -0.399     0.200
    74.915    -1.127     0.200
    75.069     0.773     0.200
    75.046     0.647     0.200
    75.214     1.128     0.200
    75.166     0.008     0.200
    75.369     0.711     0.200
    75.369     0.461     0.200
    75.399     0.339     0.200
    75.697     0.936     0.200
    76.206     1.203     0.200
    76.316     0.413     0.200
    76.511     1.511     0.200
    76.561    -0.183     0.200
    76.695     0.671     0.200
    77.073     0.847     0.200
    77.024     0.571     0.200
    77.129     0.935     0.200
    77.129    -0.268     0.200
    77.184    -0.875     0.200
    77.188     0.200     0.200
    77.412     0.508     0.200
    77.364     0.459     0.200
    77.674    -0.114     0.200
    78.003     0.150     0.200
    78.232     0.592     0.200
    78.479     0.289     0.200
    78.738     0.407     0.200
    78.922    -0.140     0.200
    78.878     0.068     0.200
    79.108    -1.120     0.200
    79.161     0.285     0.200
    79.161     0.285     0.200
    79.246     0.125     0.200
    79.478     2.260     0.200
    79.624     1.781     0.200
    79.620     0.092     0.200
    79.681     0.761     0.200
    79.693     0.297     0.200
    79.987    -0.194     0.200
    80.144     0.159     0.200
    80.183     0.047     0.200
    80.303     1.186     0.200
    80.316     1.731     0.200
    80.316     0.923     0.200
    80.499     1.551     0.200
    80.654    -0.945     0.200
    80.780     0.571     0.200
    81.013     0.409     0.200
    81.045    -0.829     0.200
    81.113    -0.572     0.200
    81.150     0.281     0.200
    81.213     0.447     0.200
    81.261     0.979     0.200
    81.647    -0.351     0.200
    82.066     0.655     0.200
    82.083     0.604     0.200
    82.151     0.781     0.200
    82.251    -0.519     0.200
    82.530     2.725     0.200
    82.560     1.409     0.200
    83.268    -0.380     0.200
    83.186    -0.966     0.200
    83.500     0.156     0.200
    83.497     0.581     0.200
    83.606    -0.030     0.200
    83.799    -0.516     0.200
    83.837    -0.706     0.200
    83.882    -0.334     0.200
    84.077    -0.437     0.200
    84.097    -0.533     0.200
    84.283    -0.375     0.200
    84.316     0.356     0.200
    84.325     0.411     0.200
    84.349    -0.312     0.200
    84.385    -0.291     0.200
    84.566     1.056     0.200
    84.838     0.498     0.200
    84.773     0.026     0.200
    84.892    -0.344     0.200
    85.138     0.022     0.200
    85.203    -0.103     0.200
    85.622     0.016     0.200
    85.671    -0.029     0.200
    86.025    -0.679     0.200
    86.062    -0.363     0.200
    85.986     0.758     0.200
    86.046    -0.604     0.200
    86.271    -0.590     0.200
    86.454     0.610     0.200
    86.588     0.352     0.200
    87.275    -0.335     0.200
    87.398     0.045     0.200
    89.669    -0.227     0.200
    90.242     0.068     0.200
    93.124    -1.028     0.200
    95.385     0.011     0.200
    14.432     7.729     0.200
    17.819    -1.148     0.200
    19.683    -1.000     0.200
    20.291    -2.238     0.200
    20.302    -2.758     0.200
    20.763    -0.035     0.200
    20.922    -2.842     0.200
    21.170    -2.909     0.200
    21.170    -4.229     0.200
    21.258    -2.849     0.200
    21.774    -1.769     0.200
    22.679     0.196     0.200
    22.679    -1.423     0.200
    23.485     0.626     0.200
    25.790    -1.538     0.200
    25.768    -0.339     0.200
    27.906    -0.542     0.200
    28.239    -1.209     0.200
    28.572    -3.966     0.200
    29.409    -1.408     0.200
    29.709    -0.141     0.200
    30.109    -2.683     0.200
    30.109    -3.543     0.200
    30.775     1.048     0.200
    32.517     0.646     0.200
    33.240    -0.268     0.200
    33.646    -0.299     0.200
    35.597    -0.643     0.200
    37.258     0.626     0.200
    39.394    -0.807     0.200
    39.746    -0.632     0.200
    42.499    -0.251     0.200
    42.778     0.618     0.200
    43.033     1.655     0.200
    43.178     1.883     0.200
    43.178     1.163     0.200
    43.518    -0.854     0.200
    43.746    -0.479     0.200
    43.746    -0.329     0.200
    43.907     0.430     0.200
    43.995     0.818     0.200
    44.235     0.285     0.200
    44.326    -0.374     0.200
    44.967     1.043     0.200
    47.653    -0.682     0.200
    47.647    -0.608     0.200
    47.945     0.861     0.200
    48.031    -0.204     0.200
    48.312     0.690     0.200
    48.547     0.625     0.200
    48.572     0.334     0.200
    48.775     0.575     0.200
    48.848    -0.123     0.200
    48.856     0.536     0.200
    48.891     1.505     0.200
    48.906     0.272     0.200
    48.907     0.124     0.200
    49.168     0.175     0.200
    49.326     1.152     0.200
    49.365     1.065     0.200
    49.494     0.380     0.200
    49.639     0.257     0.200
    49.800     0.657     0.200
    49.919     0.907     0.200
    51.330     0.938     0.200
    51.361     1.400     0.200
    51.622    -0.648     0.200
    52.001     0.132     0.200
    52.501    -0.570     0.200
    52.855    -1.183     0.200
    53.214    -0.523     0.200
    54.002    -1.584     0.200
    54.646    -0.665     0.200
    55.727    -0.546     0.200
    55.970     0.620     0.200
    56.956    -0.195     0.200
    57.071    -1.397     0.200
    57.125    -0.029     0.200
    57.125     1.511     0.200
    58.296    -1.894     0.200
    58.514    -0.947     0.200
    58.554    -0.391     0.200
    58.848    -2.230     0.200
    59.394    -0.976     0.200
    59.682    -0.280     0.200
    60.501    -1.387     0.200
    61.403     0.295     0.200
    61.802    -1.986     0.200
    62.373     0.093     0.200
    62.465     0.368     0.200
    62.568    -0.837     0.200
    62.579    -0.999     0.200
    62.982    -0.479     0.200
    62.964     0.462     0.200
    63.577     0.207     0.200
    63.678    -1.358     0.200
    63.821     1.174     0.200
    64.090    -1.861     0.200
    64.538    -0.886     0.200
    64.538    -1.126     0.200
    64.627    -1.193     0.200
    65.380    -1.250     0.200
    65.457     0.350     0.200
    65.701    -1.826     0.200
    66.144    -0.213     0.200
    66.306     0.134     0.200
    66.663     0.300     0.200
    66.828    -0.842     0.200
    66.863    -1.055     0.200
    66.930     0.669     0.200
    67.449     0.034     0.200
    68.040    -0.189     0.200
    68.142     1.758     0.200
    68.331     0.299     0.200
    68.331     0.399     0.200
    68.328     0.408     0.200
    68.358    -0.670     0.200
    68.353     0.104     0.200
    68.513     0.364     0.200
    68.529    -0.140     0.200
    68.529    -0.380     0.200
    68.643    -0.685     0.200
    69.233     0.715     0.200
    69.499     0.953     0.200
    69.684    -1.086     0.200
    69.684    -1.011     0.200
    69.852     0.725     0.200
    69.903     1.227     0.200
    69.937    -1.639     0.200
    70.062     0.507     0.200
    70.221     0.260     0.200
    70.233    -0.450     0.200
    70.669     0.984     0.200
    70.835     1.457     0.200
    71.185     0.835     0.200
    71.657     1.941     0.200
    71.717     0.951     0.200
    71.926     0.510     0.200
    72.351    -0.430     0.200
    72.721     1.207     0.200
    72.946     1.040     0.200
    73.034     1.025     0.200
    73.053     0.660     0.200
    73.224     0.212     0.200
    73.455     0.896     0.200
    73.530     1.526     0.200
    73.589    -0.343     0.200
    73.744    -0.854     0.200
    73.960    -0.816     0.200
    73.976     1.593     0.200
    74.329     0.789     0.200
    74.345    -0.656     0.200
    74.425     0.981     0.200
    74.418     1.214     0.200
    74.432     1.169     0.200
    74.459    -0.825     0.200
    74.741     1.289     0.200
    74.937     0.852     0.200
    75.022    -0.370     0.200
    75.079     1.112     0.200
    75.238     0.087     0.200
    75.545     0.128     0.200
    75.574     1.395     0.200
    75.780     0.738     0.200
    75.794     0.009     0.200
    76.057    -0.501     0.200
    76.166     0.405     0.200
    76.209    -0.348     0.200
    76.333     1.237     0.200
    76.500    -0.898     0.200
    76.532     0.324     0.200
    76.615    -0.549     0.200
    76.910     0.854     0.200
    76.971     0.150     0.200
    76.973     0.341     0.200
    77.017    -0.712     0.200
    77.023    -0.241     0.200
    77.187     1.239     0.200
    77.510    -0.168     0.200
    77.514     0.112     0.200
    77.540     0.667     0.200
    77.699    -0.820     0.200
    77.712     0.405     0.200
    77.868    -0.269     0.200
    78.065    -0.349     0.200
    78.099     0.061     0.200
    78.341     0.544     0.200
    78.573     0.144     0.200
    78.641     0.224     0.200
    78.758    -0.271     0.200
    78.758    -0.308     0.200
    78.767     1.081     0.200
    78.829     0.338     0.200
    78.995     0.332     0.200
    78.995     0.332     0.200
    79.323     0.242     0.200
    79.478     1.010     0.200
    79.510     0.914     0.200
    79.536    -0.615     0.200
    79.609     0.400     0.200
    79.705    -0.146     0.200
    79.787     1.261     0.200
    79.815    -0.752     0.200
    79.932    -0.562     0.200
    79.983     0.045     0.200
    80.037    -0.626     0.200
    80.201     1.463     0.200
    80.212     1.302     0.200
    80.239     0.287     0.200
    80.317    -0.130     0.200
    80.336     0.163     0.200
    80.494    -0.493     0.200
    80.496    -0.593     0.200
    80.677     1.449     0.200
    80.789    -1.348     0.200
    80.812     0.117     0.200
    80.849     0.322     0.200
    80.951    -1.183     0.200
    80.985     0.099     0.200
    80.990    -0.850     0.200
    81.048     0.163     0.200
    81.173     0.469     0.200
    81.178    -0.326     0.200
    81.207    -0.382     0.200
    81.451    -0.671     0.200
    81.479    -0.518     0.200
    81.493     0.207     0.200
    81.679    -0.772     0.200
    81.687    -0.818     0.200
    81.850    -1.170     0.200
    81.986     0.264     0.200
    82.135    -0.968     0.200
    82.148    -0.736     0.200
    82.394     1.098     0.200
    82.420     0.805     0.200
    82.448    -0.114     0.200
    82.448     0.302     0.200
    82.468     1.127     0.200
    82.520     0.034     0.200
    83.081     0.739     0.200
    83.102    -0.740     0.200
    83.226     0.843     0.200
    83.315    -0.086     0.200
    83.340    -0.005     0.200
    83.395     1.233     0.200
    83.438    -0.419     0.200
    83.620     0.936     0.200
    83.629    -0.597     0.200
    83.631     0.010     0.200
    83.662    -0.869     0.200
    83.690     0.912     0.200
    83.708    -0.900     0.200
    83.773     0.046     0.200
    83.927    -0.517     0.200
    83.941    -0.682     0.200
    84.028    -0.234     0.200
    84.109    -0.643     0.200
    84.149     0.151     0.200
    84.158     0.205     0.200
    84.176    -1.206     0.200
    84.179    -0.401     0.200
    84.224     0.782     0.200
    84.215    -0.381     0.200
    84.586    -0.358     0.200
    84.657    -0.083     0.200
    84.717     0.083     0.200
    84.810     1.652     0.200
    84.812    -0.494     0.200
    84.842    -0.043     0.200
    84.935     1.471     0.200
    84.971     0.009     0.200
    85.032    -0.097     0.200
    85.194    -0.207     0.200
    85.305    -0.859     0.200
    85.454     0.001     0.200
    85.498     0.079     0.200
    85.819    -1.011     0.200
    85.859    -0.708     0.200
    85.888     0.558     0.200
    85.888     0.997     0.200
    85.895    -0.386     0.200
    85.914    -0.019     0.200
    86.105    -0.722     0.200
    86.129     0.060     0.200
    86.284     0.598     0.200
    86.420     0.331     0.200
    86.705     0.435     0.200
    87.140    -0.372     0.200
    87.632     0.354     0.200
    88.046    -0.459     0.200
    88.538    -0.133     0.200
    88.950     0.631     0.200
    88.970     0.437     0.200
    89.074    -0.433     0.200
    89.383     3.342     0.200
    92.952     0.027     0.200
    93.340    -0.980     0.200
    25.838    -1.200     0.200
    28.323    -0.512     0.200
    39.494    -0.818     0.200
    42.576    -0.160     0.200
    43.838    -0.708     0.200
    44.456    -0.732     0.200
    47.758    -0.891     0.200
    48.084    -0.312     0.200
    48.134    -0.870     0.200
    49.190    -0.815     0.200
    49.190    -0.921     0.200
    55.633    -1.527     0.200
    58.689    -0.754     0.200
    59.545    -0.493     0.200
    64.233    -1.695     0.200
    64.770    -1.393     0.200
    69.825    -1.032     0.200
    69.833    -1.040     0.200
    70.925     1.419     0.200
    76.434     0.844     0.200
    78.897    -0.329     0.200
    85.982     0.904     0.200
    20.568    -2.190     0.200
    20.579    -1.948     0.200
    21.462    -0.914     0.200
    21.501    -3.617     0.200
    23.781    -1.811     0.200
    24.248    -3.869     0.200
    26.119    -0.035     0.200
    28.601    -0.689     0.200
    28.740    -0.925     0.200
    32.822     0.885     0.200
    40.553    -1.861     0.200
    42.856    -0.276     0.200
    43.446     0.658     0.200
    43.970     0.755     0.200
    44.112    -0.365     0.200
    44.388    -0.048     0.200
    48.025    -0.393     0.200
    48.216     0.662     0.200
    48.402     0.024     0.200
    48.663     0.879     0.200
    48.821     0.508     0.200
    48.845     0.430     0.200
    49.049     0.662     0.200
    49.169    -0.288     0.200
    49.183     0.035     0.200
    49.207     0.552     0.200
    49.151    -0.491     0.200
    49.260     0.193     0.200
    49.520     0.235     0.200
    49.647     1.206     0.200
    49.991     0.197     0.200
    50.079     0.522     0.200
    51.978    -0.431     0.200
    53.587    -0.804     0.200
    53.701     1.131     0.200
    57.253    -1.419     0.200
    59.735    -2.482     0.200
    64.907    -1.912     0.200
    64.984    -0.955     0.200
    65.446     0.275     0.200
    66.074    -0.743     0.200
    68.703     0.829     0.200
    68.703     0.540     0.200
    70.029    -0.953     0.200
    75.604    -0.084     0.200
    77.155     1.690     0.200
    77.377    -0.209     0.200
    78.935     0.563     0.200
    79.120    -0.365     0.200
    79.988    -0.266     0.200
    84.455    -1.018     0.200
    84.508     0.112     0.200
    84.517    -0.036     0.200
    84.533    -0.712     0.200
    84.568    -0.490     0.200
    84.939    -0.754     0.200
    85.061    -0.769     0.200
    85.172    -0.019     0.200
    85.184    -0.386     0.200
    85.329    -0.306     0.200
    85.811    -0.299     0.200
    85.847    -0.182     0.200
    86.637     0.531     0.200
    87.057     0.291     0.200
    88.891     1.159     0.200
    89.302     0.435     0.200
    17.910    -1.127     0.200
    18.627    -0.201     0.200
    20.371    -1.804     0.200
    20.381    -2.462     0.200
    21.298    -3.087     0.200
    21.350    -0.853     0.200
    21.807     1.472     0.200
    22.687     0.830     0.200
    22.687     1.061     0.200
    24.009    -3.905     0.200
    24.769     0.667     0.200
    25.883    -0.669     0.200
    27.970     1.131     0.200
    28.360    -0.445     0.200
    28.653    -0.854     0.200
    29.457    -1.220     0.200
    29.832     0.202     0.200
    30.853     0.990     0.200
    32.609     0.363     0.200
    33.301    -0.676     0.200
    33.687    -0.034     0.200
    35.650    -0.780     0.200
    39.521     0.058     0.200
    39.856     0.747     0.200
    42.617    -0.197     0.200
    42.811     0.136     0.200
    43.055     0.057     0.200
    43.254     1.850     0.200
    43.561     0.029     0.200
    43.664    -0.185     0.200
    43.870    -0.706     0.200
    43.870    -0.296     0.200
    43.953     0.332     0.200
    44.018     0.169     0.200
    44.270     0.648     0.200
    44.373    -0.469     0.200
    44.975     0.187     0.200
    45.330     0.388     0.200
    47.693    -0.151     0.200
    47.781    -0.794     0.200
    48.108    -0.278     0.200
    48.116     0.601     0.200
    48.159    -0.300     0.200
    48.426     0.759     0.200
    48.626     0.376     0.200
    48.650     0.292     0.200
    48.854     0.429     0.200
    48.926    -0.044     0.200
    48.970     0.389     0.200
    48.986     0.314     0.200
    49.022     0.008     0.200
    49.110    -0.593     0.200
    49.283     0.096     0.200
    49.440     1.098     0.200
    49.447     1.294     0.200
    49.754    -0.020     0.200
    49.881     0.698     0.200
    50.033     0.976     0.200
    51.740    -0.374     0.200
    52.133    -0.300     0.200
    52.953    -0.360     0.200
    52.998    -2.691     0.200
    53.346    -1.690     0.200
    53.346    -0.850     0.200
    53.708     1.544     0.200
    53.708     1.326     0.200
    54.091    -1.200     0.200
    55.622    -0.059     0.200
    55.677    -1.167     0.200
    56.032     0.253     0.200
    56.032     1.542     0.200
    57.157    -2.017     0.200
    57.850    -0.149     0.200
    58.567    -0.878     0.200
    58.607    -0.441     0.200
    58.978    -1.711     0.200
    59.524    -0.952     0.200
    59.750     0.271     0.200
    60.617    -1.361     0.200
    61.465     0.564     0.200
    61.935    -2.466     0.200
    62.482    -0.341     0.200
    62.542     0.367     0.200
    62.542     1.320     0.200
    62.542    -2.622     0.200
    63.056    -0.369     0.200
    63.056     1.119     0.200
    63.056    -0.541     0.200
    63.812    -1.229     0.200
    63.839     0.731     0.200
    64.223    -2.027     0.200
    64.671    -0.754     0.200
    64.760    -1.180     0.200
    65.128     0.228     0.200
    65.479     0.070     0.200
    65.834    -0.378     0.200
    66.209     0.563     0.200
    66.721     0.635     0.200
    67.578    -0.288     0.200
    68.460     0.807     0.200
    68.460     0.686     0.200
    68.486     2.023     0.200
    68.578    -0.392     0.200
    68.639     0.462     0.200
    68.692     0.486     0.200
    69.257     0.713     0.200
    69.624     1.267     0.200
    69.815    -1.005     0.200
    69.815    -0.903     0.200
    69.802     0.545     0.200
    70.362    -1.254     0.200
    70.836     1.660     0.200
    71.418     2.510     0.200
    71.719     1.173     0.200
    72.484     0.049     0.200
    72.736     0.793     0.200
    72.957     1.000     0.200
    73.034     0.955     0.200
    73.072     0.500     0.200
    73.072     0.620     0.200
    73.754     1.126     0.200
    74.393    -0.458     0.200
    74.459     0.866     0.200
    74.592     0.183     0.200
    74.741     1.240     0.200
    74.954     0.815     0.200
    75.066     0.758     0.200
    75.051     0.027     0.200
    75.372    -0.310     0.200
    75.679     0.035     0.200
    75.701     1.628     0.200
    75.779     0.663     0.200
    75.926    -0.178     0.200
    76.346     1.633     0.200
    76.633    -0.065     0.200
    76.661    -0.239     0.200
    76.665     0.239     0.200
    76.780     0.991     0.200
    77.037     1.456     0.200
    77.104     0.158     0.200
    77.150    -0.593     0.200
    77.156    -0.123     0.200
    77.198    -0.060     0.200
    77.269     0.385     0.200
    77.643    -0.047     0.200
    77.646    -0.063     0.200
    77.998     0.122     0.200
    78.198    -0.521     0.200
    78.707    -0.127     0.200
    78.737    -0.672     0.200
    78.783     0.755     0.200
    78.891    -0.340     0.200
    78.891    -0.203     0.200
    78.963     0.169     0.200
    79.128     0.163     0.200
    79.128     0.163     0.200
    79.129     0.156     0.200
    79.231     1.200     0.200
    79.456     0.275     0.200
    79.478     0.155     0.200
    79.665     0.841     0.200
    79.668    -0.277     0.200
    79.898    -0.319     0.200
    80.049    -0.681     0.200
    80.116    -0.257     0.200
    80.169     0.618     0.200
    80.222     1.834     0.200
    80.275     0.550     0.200
    80.372     0.028     0.200
    80.450    -0.288     0.200
    80.470     0.203     0.200
    80.686     1.650     0.200
    80.835    -0.599     0.200
    80.946     0.064     0.200
    80.982     0.166     0.200
    80.986     0.947     0.200
    81.016    -0.912     0.200
    81.118     0.147     0.200
    81.124    -0.734     0.200
    81.120    -0.526     0.200
    81.181     0.209     0.200
    81.213    -0.958     0.200
    81.311    -0.578     0.200
    81.611    -0.565     0.200
    81.626    -0.142     0.200
    81.890    -1.572     0.200
    81.983    -0.897     0.200
    82.119     0.506     0.200
    82.268    -0.510     0.200
    82.281    -0.976     0.200
    82.291    -0.531     0.200
    83.091     1.124     0.200
    83.235    -0.508     0.200
    83.473    -0.033     0.200
    83.571    -0.553     0.200
    83.752     1.229     0.200
    83.754     0.882     0.200
    83.761    -0.827     0.200
    83.765     0.017     0.200
    83.793    -0.992     0.200
    83.823     1.118     0.200
    83.839    -1.021     0.200
    83.898    -0.466     0.200
    83.906    -0.044     0.200
    84.024    -0.274     0.200
    84.038     0.351     0.200
    84.059    -0.743     0.200
    84.067    -0.495     0.200
    84.072    -0.198     0.200
    84.160    -0.457     0.200
    84.185     0.218     0.200
    84.214    -1.243     0.200
    84.240    -0.560     0.200
    84.282     0.022     0.200
    84.291     0.077     0.200
    84.312    -0.627     0.200
    84.347    -0.603     0.200
    84.403    -1.438     0.200
    84.436     1.222     0.200
    84.442    -1.422     0.200
    84.578    -0.464     0.200
    84.666    -2.006     0.200
    84.700     0.003     0.200
    84.677     0.249     0.200
    84.718    -0.680     0.200
    84.772    -0.128     0.200
    84.848    -0.529     0.200
    84.851    -1.836     0.200
    84.899    -1.108     0.200
    84.945    -0.615     0.200
    84.972    -0.750     0.200
    84.988    -1.141     0.200
    85.007    -1.647     0.200
    85.104    -0.113     0.200
    85.133    -1.388     0.200
    85.152    -1.754     0.200
    85.152    -1.613     0.200
    85.164    -0.314     0.200
    85.225    -0.885     0.200
    85.325    -0.614     0.200
    85.350    -1.638     0.200
    85.438    -1.077     0.200
    85.586    -0.216     0.200
    85.630    -0.029     0.200
    85.893     0.643     0.200
    85.893     1.138     0.200
    85.952    -0.830     0.200
    85.992    -1.025     0.200
    86.028    -0.600     0.200
    86.238    -0.738     0.200
    86.261    -0.049     0.200
    86.416     0.591     0.200
    86.552     0.021     0.200
    86.837     0.330     0.200
    87.179     0.282     0.200
    87.765     0.158     0.200
    88.670    -0.321     0.200
    89.082     0.546     0.200
    89.101    -0.449     0.200
    91.942    -0.168     0.200
    92.703    -0.279     0.200
    93.083     0.004     0.200
    93.471    -0.720     0.200
    93.972    -0.726     0.200
    17.942    -1.634     0.200
    17.942    -2.056     0.200
    19.634    -0.424     0.200
    20.382    -2.092     0.200
    20.382    -1.991     0.200
    20.393    -2.570     0.200
    20.984    -3.390     0.200
    21.333    -2.946     0.200
    21.333    -3.610     0.200
    21.382    -2.561     0.200
    22.701     1.904     0.200
    22.701     1.131     0.200
    23.587     2.151     0.200
    24.841    -0.437     0.200
    25.827     0.076     0.200
    25.906    -0.842     0.200
    26.349     0.510     0.200
    26.625     0.465     0.200
    27.868    -1.166     0.200
    27.976    -1.025     0.200
    28.386    -0.675     0.200
    28.683    -0.625     0.200
    29.458    -1.602     0.200
    30.266    -4.240     0.200
    32.624     0.519     0.200
    33.687    -0.437     0.200
    39.878     1.058     0.200
    40.339    -1.260     0.200
    42.641     0.409     0.200
    43.264     1.054     0.200
    43.897    -0.431     0.200
    43.897    -0.783     0.200
    44.268     0.267     0.200
    44.268     1.697     0.200
    47.811    -0.661     0.200
    47.811    -0.942     0.200
    47.889    -0.370     0.200
    48.137    -0.186     0.200
    48.137    -0.201     0.200
    48.188    -0.965     0.200
    48.637     0.169     0.200
    48.661    -0.109     0.200
    48.864     0.523     0.200
    48.997     0.108     0.200
    49.136    -0.553     0.200
    49.136    -1.045     0.200
    49.625     0.924     0.200
    49.893     0.389     0.200
    51.764    -0.482     0.200
    53.377    -0.706     0.200
    53.377    -0.963     0.200
    53.728     0.872     0.200
    53.728     0.106     0.200
    55.636    -1.594     0.200
    55.651    -0.293     0.200
    55.605     1.036     0.200
    55.713    -1.662     0.200
    57.188    -1.904     0.200
    58.591    -0.323     0.200
    58.631    -0.640     0.200
    59.014    -1.489     0.200
    59.560    -0.857     0.200
    59.757     0.490     0.200
    60.513    -0.443     0.200
    60.513    -0.287     0.200
    60.652    -0.734     0.200
    61.183    -1.025     0.200
    61.471    -1.198     0.200
    61.970    -1.534     0.200
    62.132     0.303     0.200
    62.217     1.019     0.200
    62.217     0.628     0.200
    62.439    -0.069     0.200
    62.448    -0.028     0.200
    62.449     0.447     0.200
    63.845    -1.880     0.200
    64.258    -1.486     0.200
    64.704    -1.002     0.200
    64.704    -0.814     0.200
    64.794    -1.169     0.200
    64.899    -2.084     0.200
    65.145     1.042     0.200
    65.429    -0.897     0.200
    65.495     1.421     0.200
    66.158     1.868     0.200
    66.176     0.887     0.200
    66.176     1.090     0.200
    66.707     0.769     0.200
    67.608    -0.212     0.200
    68.079     0.259     0.200
    68.253     0.965     0.200
    68.489    -0.134     0.200
    68.489     0.124     0.200
    68.601    -0.816     0.200
    68.704     1.198     0.200
    68.731    -1.248     0.200
    69.274     1.434     0.200
    69.813     1.177     0.200
    69.850    -1.261     0.200
    69.850    -1.285     0.200
    69.882     1.190     0.200
    70.103    -1.273     0.200
    70.101     0.420     0.200
    70.848     1.287     0.200
    71.176    -1.441     0.200
    71.731     1.662     0.200
    72.514     0.039     0.200
    72.751     1.474     0.200
    73.089     0.257     0.200
    73.089     0.037     0.200
    73.436    -0.814     0.200
    73.768     0.737     0.200
    73.818     1.254     0.200
    73.818     0.403     0.200
    74.049    -0.098     0.200
    74.416    -0.184     0.200
    74.581     0.906     0.200
    74.626    -0.550     0.200
    74.753     1.909     0.200
    75.011     0.969     0.200
    75.069     0.390     0.200
    75.406    -0.145     0.200
    75.813     0.631     0.200
    75.900    -0.227     0.200
    76.165     0.320     0.200
    76.320    -0.355     0.200
    76.353     0.456     0.200
    76.360     1.761     0.200
    76.376     0.531     0.200
    76.668    -0.414     0.200
    76.699     0.205     0.200
    76.943     1.800     0.200
    77.138    -0.082     0.200
    77.138     0.238     0.200
    77.140     0.727     0.200
    77.185     0.067     0.200
    77.190     0.241     0.200
    77.190     0.038     0.200
    77.678     0.721     0.200
    77.681    -0.000     0.200
    78.092     1.118     0.200
    78.232    -0.660     0.200
    78.538     0.154     0.200
    78.741    -0.063     0.200
    78.772    -0.195     0.200
    78.926    -0.272     0.200
    78.926    -0.889     0.200
    78.997    -0.060     0.200
    79.163     0.035     0.200
    79.163     0.035     0.200
    79.341    -0.438     0.200
    79.661     1.308     0.200
    79.856    -0.405     0.200
    79.928    -0.406     0.200
    80.084    -0.385     0.200
    80.100     0.044     0.200
    80.150    -0.313     0.200
    80.223     2.220     0.200
    80.236     1.873     0.200
    80.301    -0.333     0.200
    80.407     0.199     0.200
    80.484    -0.114     0.200
    80.504     1.373     0.200
    80.561    -0.278     0.200
    80.620    -0.342     0.200
    80.664    -0.521     0.200
    80.699     1.843     0.200
    80.936    -0.706     0.200
    80.980     0.534     0.200
    81.006    -0.713     0.200
    81.014    -1.248     0.200
    81.017    -0.059     0.200
    81.018     1.330     0.200
    81.050    -1.198     0.200
    81.153    -0.281     0.200
    81.158    -0.910     0.200
    81.248    -0.992     0.200
    81.346    -0.406     0.200
    81.348    -1.237     0.200
    81.375    -0.163     0.200
    81.618    -0.144     0.200
    81.646    -0.697     0.200
    81.661     0.133     0.200
    81.846    -0.148     0.200
    81.855     0.009     0.200
    82.154     0.959     0.200
    82.175    -0.472     0.200
    82.249    -0.456     0.200
    82.303    -1.235     0.200
    82.316    -1.006     0.200
    82.253    -1.044     0.200
    82.326    -0.663     0.200
    82.373    -0.506     0.200
    82.536     1.415     0.200
    82.569     1.433     0.200
    82.615     1.426     0.200
    83.178     0.667     0.200
    83.375     1.641     0.200
    83.446     1.025     0.200
    83.507    -0.195     0.200
    83.599     0.333     0.200
    83.606    -0.677     0.200
    83.788     1.633     0.200
    83.796    -0.854     0.200
    83.829    -0.919     0.200
    83.846     0.893     0.200
    83.857     0.357     0.200
    83.874    -1.049     0.200
    83.933    -0.395     0.200
    83.941     0.182     0.200
    83.950    -0.824     0.200
    83.932     1.274     0.200
    83.981    -0.242     0.200
    84.058     0.094     0.200
    84.094    -0.871     0.200
    84.109    -0.095     0.200
    84.192    -0.715     0.200
    84.220     0.670     0.200
    84.248    -1.273     0.200
    84.275    -0.689     0.200
    84.317    -0.197     0.200
    84.326     0.053     0.200
    84.343    -0.535     0.200
    84.347    -0.747     0.200
    84.382    -0.629     0.200
    84.438    -0.763     0.200
    84.476    -1.151     0.200
    84.613    -0.046     0.200
    84.696    -0.672     0.200
    84.701    -1.486     0.200
    84.694     0.477     0.200
    84.730     0.186     0.200
    84.735     0.249     0.200
    84.753    -0.705     0.200
    84.806    -0.346     0.200
    84.852     1.154     0.200
    84.883    -0.154     0.200
    84.934    -1.189     0.200
    84.943     1.562     0.200
    84.970     0.155     0.200
    84.980    -0.841     0.200
    85.008    -0.277     0.200
    85.011     0.406     0.200
    85.022    -1.303     0.200
    85.066     2.219     0.200
    85.103    -0.054     0.200
    85.139    -0.331     0.200
    85.168    -2.102     0.200
    85.168    -0.960     0.200
    85.187    -1.853     0.200
    85.199    -0.440     0.200
    85.200    -1.122     0.200
    85.227     0.806     0.200
    85.259    -0.098     0.200
    85.322    -0.646     0.200
    85.360    -0.640     0.200
    85.362    -0.049     0.200
    85.384    -1.308     0.200
    85.410    -0.184     0.200
    85.414    -0.603     0.200
    85.473    -1.199     0.200
    85.492    -0.993     0.200
    85.550    -0.281     0.200
    85.603    -0.348     0.200
    85.621    -0.336     0.200
    85.665    -0.257     0.200
    85.772    -0.286     0.200
    85.906     1.425     0.200
    85.906     1.105     0.200
    85.970     0.218     0.200
    85.987    -1.044     0.200
    86.027    -1.139     0.200
    86.063    -0.519     0.200
    86.118     0.807     0.200
    86.273    -0.851     0.200
    86.296    -0.169     0.200
    86.436    -0.061     0.200
    86.451     0.367     0.200
    86.587    -0.097     0.200
    86.632    -0.465     0.200
    86.703    -0.391     0.200
    86.872     0.215     0.200
    87.585     0.506     0.200
    87.800     0.145     0.200
    88.705    -0.439     0.200
    89.117     0.432     0.200
    89.137     0.339     0.200
    89.495     0.230     0.200
    93.119     0.166     0.200
    26.176    -0.637     0.200
    28.228     0.030     0.200
    29.234    -3.055     0.200
    42.476    -0.417     0.200
    43.749    -0.846     0.200
    44.568    -0.770     0.200
    47.681    -0.678     0.200
    48.006     0.072     0.200
    49.292    -0.481     0.200
    58.796    -0.971     0.200
    58.988    -1.655     0.200
    59.535    -1.809     0.200
    62.358    -1.323     0.200
    64.207    -2.057     0.200
    64.742    -1.255     0.200
    66.085    -0.393     0.200
    69.819    -1.220     0.200
    69.819    -1.294     0.200
    71.060     0.957     0.200
    73.288     1.029     0.200
    86.115    -0.235     0.200
    20.357    -2.090     0.200
    20.796     1.391     0.200
    21.218    -0.952     0.200
    21.813    -0.202     0.200
    22.657     1.040     0.200
    23.168    -2.399     0.200
    26.274     0.133     0.200
    30.829     0.909     0.200
    33.688     0.870     0.200
    39.808     0.862     0.200
    40.531     2.979     0.200
    41.969     2.824     0.200
    42.256     0.920     0.200
    42.562    -1.018     0.200
    43.513     0.053     0.200
    43.619     0.182     0.200
    43.809    -0.611     0.200
    43.972    -0.903     0.200
    44.274     0.780     0.200
    44.322    -0.404     0.200
    45.286     0.907     0.200
    45.396     0.915     0.200
    47.643     1.162     0.200
    47.715    -1.157     0.200
    48.092     0.505     0.200
    48.601     0.082     0.200
    48.626     0.594     0.200
    48.829     0.534     0.200
    48.961     0.027     0.200
    49.054    -0.412     0.200
    49.421     1.217     0.200
    49.855     0.711     0.200
    53.275    -0.111     0.200
    53.664     1.987     0.200
    58.514     1.527     0.200
    58.554     0.402     0.200
    61.858    -1.123     0.200
    62.553    -0.772     0.200
    62.554    -0.747     0.200
    63.804     1.745     0.200
    65.092     1.385     0.200
    65.318    -1.047     0.200
    65.441     0.899     0.200
    68.394     1.724     0.200
    68.394     0.574     0.200
    69.218     0.966     0.200
    69.736    -0.792     0.200
    69.736    -0.567     0.200
    70.046    -0.028     0.200
    70.811     1.541     0.200
    70.900    -0.631     0.200
    71.693     0.735     0.200
    71.794     2.535     0.200
    72.116     0.651     0.200
    72.702     1.911     0.200
    72.926     1.064     0.200
    73.036     1.161     0.200
    73.928     0.650     0.200
    74.488    -0.204     0.200
    74.716     0.074     0.200
    74.964     0.672     0.200
    75.296    -0.447     0.200
    76.266     0.021     0.200
    76.313     1.653     0.200
    76.557    -0.717     0.200
    77.567    -0.291     0.200
    78.815     0.001     0.200
    79.831    -0.105     0.200
    81.534    -0.625     0.200
    83.683    -0.695     0.200
    84.233    -0.599     0.200
    84.251    -1.009     0.200
    84.269    -0.578     0.200
    84.868    -0.798     0.200
    85.361    -0.664     0.200
    85.865     0.984     0.200
    85.915    -0.911     0.200
    18.079    -2.872     0.200
    20.206    -1.804     0.200
    20.217    -2.164     0.200
    21.375    -3.099     0.200
    23.420    -2.710     0.200
    26.227     0.032     0.200
    27.786     0.082     0.200
    28.280    -0.120     0.200
    32.463     0.754     0.200
    37.104     0.350     0.200
    39.468    -0.158     0.200
    39.747     0.173     0.200
    40.263    -1.399     0.200
    42.528    -0.211     0.200
    43.084     2.135     0.200
    43.803    -0.463     0.200
    43.803     0.154     0.200
    43.803    -0.666     0.200
    44.161     0.980     0.200
    47.810    -0.478     0.200
    48.060    -0.168     0.200
    48.060    -0.269     0.200
    48.111    -0.442     0.200
    48.460     0.367     0.200
    48.483     0.289     0.200
    48.687     0.220     0.200
    48.879    -0.303     0.200
    48.879    -0.459     0.200
    49.311    -0.425     0.200
    49.311    -0.753     0.200
    49.718     0.651     0.200
    53.325    -0.783     0.200
    57.332    -1.747     0.200
    59.587    -1.550     0.200
    62.322    -0.486     0.200
    64.261    -2.262     0.200
    64.797    -1.308     0.200
    66.049     0.850     0.200
    69.872    -1.838     0.200
    69.872    -1.369     0.200
    70.924    -1.034     0.200
    73.289    -0.091     0.200
    74.329     0.027     0.200
    74.709     0.085     0.200
    74.841     0.020     0.200
    74.843    -0.908     0.200
    76.284    -0.042     0.200
    77.670     0.721     0.200
    78.733    -0.056     0.200
    78.917    -0.830     0.200
    82.080    -0.853     0.200
    84.288    -0.827     0.200
    86.110     1.054     0.200
    15.553     1.355     0.200
    17.934    -1.736     0.200
    17.934    -2.647     0.200
    19.631    -0.621     0.200
    20.364    -3.172     0.200
    20.375    -2.111     0.200
    20.969    -2.797     0.200
    21.317    -3.837     0.200
    21.317    -4.276     0.200
    21.791    -2.607     0.200
    23.568    -2.491     0.200
    24.021    -5.230     0.200
    24.765     0.001     0.200
    24.834    -2.891     0.200
    25.814    -1.113     0.200
    26.329    -0.345     0.200
    27.960    -1.687     0.200
    28.365    -0.494     0.200
    29.444    -1.773     0.200
    29.837     0.046     0.200
    30.845     0.448     0.200
    32.605     0.692     0.200
    33.290    -0.988     0.200
    33.673    -0.118     0.200
    37.290     0.760     0.200
    39.857     0.141     0.200
    40.318    -1.174     0.200
    40.413     0.241     0.200
    41.533    -0.660     0.200
    42.034     0.565     0.200
    42.322     0.411     0.200
    42.400    -0.781     0.200
    42.621    -0.270     0.200
    42.796    -1.338     0.200
    43.584    -0.820     0.200
    43.686    -0.939     0.200
    43.876    -0.940     0.200
    43.876    -0.339     0.200
    43.876    -0.480     0.200
    43.977    -0.146     0.200
    43.977     0.453     0.200
    44.017     1.126     0.200
    44.040     0.254     0.200
    44.256     1.028     0.200
    44.396    -0.351     0.200
    44.965    -0.528     0.200
    45.032     0.741     0.200
    45.353    -0.001     0.200
    45.462     0.355     0.200
    47.716    -0.391     0.200
    47.797     2.076     0.200
    47.868    -0.478     0.200
    48.117    -0.095     0.200
    48.109     0.766     0.200
    48.167    -0.204     0.200
    48.429     0.380     0.200
    48.619     0.241     0.200
    48.643     0.457     0.200
    48.847     0.593     0.200
    48.934     0.024     0.200
    48.934    -0.166     0.200
    48.965    -0.035     0.200
    48.973     0.480     0.200
    48.979     0.178     0.200
    49.025     0.067     0.200
    49.134    -1.195     0.200
    49.286     0.179     0.200
    49.286    -1.151     0.200
    49.442     0.634     0.200
    49.604     1.011     0.200
    49.757     0.170     0.200
    49.875     0.559     0.200
    50.035     0.958     0.200
    51.236     0.900     0.200
    51.365     1.018     0.200
    51.743    -0.586     0.200
    51.812     0.691     0.200
    53.357    -0.415     0.200
    53.357    -0.515     0.200
    53.357    -0.755     0.200
    53.685    -0.609     0.200
    53.731     1.107     0.200
    54.263    -0.654     0.200
    54.263     0.896     0.200
    54.289     0.091     0.200
    54.333     0.857     0.200
    54.918    -0.756     0.200
    54.918     1.844     0.200
    55.458    -0.596     0.200
    55.630    -0.198     0.200
    55.698    -1.590     0.200
    55.612     0.327     0.200
    57.181    -1.499     0.200
    58.083    -0.465     0.200
    58.631    -0.534     0.200
    58.997    -1.818     0.200
    59.542    -0.985     0.200
    59.740    -0.146     0.200
    60.496    -0.216     0.200
    60.594     0.289     0.200
    60.639    -1.391     0.200
    61.166    -0.482     0.200
    61.455     0.756     0.200
    62.222     0.333     0.200
    62.534    -0.780     0.200
    62.448    -0.524     0.200
    62.457    -0.436     0.200
    62.458    -0.260     0.200
    62.603     0.812     0.200
    63.003     0.594     0.200
    63.048    -1.465     0.200
    63.141     0.747     0.200
    63.594     1.715     0.200
    63.794     0.676     0.200
    63.860     0.684     0.200
    64.135     0.808     0.200
    64.340    -0.673     0.200
    64.684    -1.216     0.200
    64.776    -1.214     0.200
    64.827     0.067     0.200
    64.882    -2.644     0.200
    65.149     0.352     0.200
    65.284     0.850     0.200
    65.417    -0.019     0.200
    65.500     0.271     0.200
    66.046     0.173     0.200
    66.166     1.905     0.200
    66.166     0.983     0.200
    66.292     1.036     0.200
    66.733    -0.010     0.200
    66.950     0.785     0.200
    67.510     0.929     0.200
    68.171     0.795     0.200
    68.346     0.530     0.200
    68.397    -0.267     0.200
    68.601    -0.741     0.200
    68.728    -0.934     0.200
    68.712     0.901     0.200
    69.152    -0.893     0.200
    69.279     0.636     0.200
    69.426     1.295     0.200
    69.608    -1.007     0.200
    69.833    -0.986     0.200
    69.833    -1.037     0.200
    69.821     0.863     0.200
    69.888     0.815     0.200
    69.944     0.511     0.200
    70.105     0.503     0.200
    70.371    -0.183     0.200
    70.711     0.747     0.200
    70.937    -0.922     0.200
    70.945     0.836     0.200
    71.101     0.022     0.200
    71.068     0.986     0.200
    71.157    -1.156     0.200
    71.214     0.906     0.200
    71.374     1.293     0.200
    71.792     1.453     0.200
    71.738     0.983     0.200
    71.793     1.015     0.200
    71.851     1.664     0.200
    71.940    -0.184     0.200
    71.988     0.093     0.200
    71.945    -0.067     0.200
    71.960     0.505     0.200
    71.977     0.765     0.200
    71.990     0.994     0.200
    72.113     0.040     0.200
    72.374     0.922     0.200
    72.493    -0.067     0.200
    72.659     0.869     0.200
    72.756     0.759     0.200
    72.978     1.141     0.200
    73.054     1.061     0.200
    73.152     0.871     0.200
    73.094     0.575     0.200
    73.418    -1.135     0.200
    73.489     0.789     0.200
    73.561     1.242     0.200
    73.774     0.934     0.200
    73.829     0.854     0.200
    74.030    -0.221     0.200
    74.214    -0.390     0.200
    74.416    -0.840     0.200
    74.468     0.943     0.200
    74.446     1.310     0.200
    74.461     1.602     0.200
    74.560     1.162     0.200
    74.606     0.433     0.200
    74.973     0.944     0.200
    75.075     0.784     0.200
    75.017     0.902     0.200
    75.073    -0.100     0.200
    75.219     0.727     0.200
    75.318    -0.173     0.200
    75.386     0.039     0.200
    75.569     0.535     0.200
    75.693     0.486     0.200
    75.708     1.435     0.200
    75.919     0.603     0.200
    75.927     1.222     0.200
    75.943    -0.243     0.200
    76.146     0.505     0.200
    76.301     0.027     0.200
    76.303     0.435     0.200
    76.333     0.197     0.200
    76.357    -0.091     0.200
    76.366     1.148     0.200
    76.609     0.212     0.200
    76.648     0.091     0.200
    76.676     0.005     0.200
    76.680     0.184     0.200
    76.800     0.777     0.200
    76.950     1.673     0.200
    77.044     1.135     0.200
    77.118     0.118     0.200
    77.120     0.308     0.200
    77.166    -0.651     0.200
    77.171    -0.179     0.200
    77.214    -0.016     0.200
    77.290     1.498     0.200
    77.659    -0.101     0.200
    77.663     0.076     0.200
    77.688     0.837     0.200
    78.008     0.010     0.200
    78.072     0.604     0.200
    78.214    -0.480     0.200
    78.212    -0.262     0.200
    78.226    -1.337     0.200
    78.248    -0.368     0.200
    78.482     0.390     0.200
    78.490    -0.615     0.200
    78.511    -0.409     0.200
    78.614    -0.886     0.200
    78.543    -0.193     0.200
    78.722     0.020     0.200
    78.754    -0.536     0.200
    78.804     0.642     0.200
    78.907    -0.294     0.200
    78.907    -0.255     0.200
    78.978     0.116     0.200
    79.144     0.211     0.200
    79.144     0.211     0.200
    79.142    -0.397     0.200
    79.399     1.121     0.200
    79.471     0.228     0.200
    79.494     0.005     0.200
    79.511    -0.527     0.200
    79.497     1.318     0.200
    79.640     0.948     0.200
    79.723     0.361     0.200
    79.776     0.635     0.200
    79.835     0.064     0.200
    80.014    -0.510     0.200
    80.031    -1.144     0.200
    80.066    -0.745     0.200
    80.081    -0.276     0.200
    80.131    -0.082     0.200
    80.220    -0.522     0.200
    80.244    -0.831     0.200
    80.282    -0.257     0.200
    80.229     1.699     0.200
    80.242     1.957     0.200
    80.242     1.207     0.200
    80.357     1.143     0.200
    80.388    -0.023     0.200
    80.422     0.893     0.200
    80.436    -0.581     0.200
    80.465    -0.236     0.200
    80.485    -0.043     0.200
    80.602    -0.268     0.200
    80.623     0.219     0.200
    80.725     0.770     0.200
    80.773    -0.285     0.200
    80.706     1.115     0.200
    80.850    -0.684     0.200
    80.859     0.056     0.200
    80.879    -0.348     0.200
    80.960    -0.277     0.200
    80.961     0.013     0.200
    80.963     0.604     0.200
    80.986    -0.660     0.200
    80.996    -0.771     0.200
    80.998     0.220     0.200
    80.998     0.716     0.200
    81.031    -1.448     0.200
    81.102    -1.034     0.200
    81.134     0.096     0.200
    81.138    -0.739     0.200
    81.197     0.161     0.200
    81.227    -0.401     0.200
    81.230    -0.715     0.200
    81.249    -0.214     0.200
    81.264    -0.293     0.200
    81.289     0.482     0.200
    81.327    -0.428     0.200
    81.356    -0.184     0.200
    81.372    -0.167     0.200
    81.600    -0.371     0.200
    81.628    -0.316     0.200
    81.642     0.008     0.200
    81.790    -0.572     0.200
    81.819     0.679     0.200
    81.828    -0.368     0.200
    81.836    -0.616     0.200
    82.050     0.565     0.200
    82.067     0.878     0.200
    82.135     0.071     0.200
    82.156    -0.591     0.200
    82.231    -0.583     0.200
    82.284    -0.760     0.200
    82.297    -0.729     0.200
    82.308    -0.285     0.200
    82.354    -0.226     0.200
    82.412     0.471     0.200
    82.513     0.744     0.200
    82.516     1.060     0.200
    82.548     0.914     0.200
    82.577     0.612     0.200
    82.577     0.772     0.200
    82.594     1.132     0.200
    82.630     0.678     0.200
    82.692    -0.284     0.200
    82.759     1.035     0.200
    83.251    -0.784     0.200
    83.354     0.906     0.200
    83.417     0.627     0.200
    83.464    -0.218     0.200
    83.423     0.850     0.200
    83.587    -0.300     0.200
    83.693     0.637     0.200
    83.747    -0.526     0.200
    83.767     1.068     0.200
    83.769     0.881     0.200
    83.778    -0.577     0.200
    83.811    -0.746     0.200
    83.827     0.446     0.200
    83.838     0.836     0.200
    83.842    -0.634     0.200
    83.857    -0.876     0.200
    83.863    -0.748     0.200
    83.885    -0.769     0.200
    83.914    -0.318     0.200
    83.922    -0.298     0.200
    83.912     0.974     0.200
    83.931    -1.357     0.200
    83.962    -0.753     0.200
    84.052    -0.345     0.200
    84.057    -0.229     0.200
    84.064    -1.112     0.200
    84.076    -0.393     0.200
    84.082    -0.595     0.200
    84.090    -0.825     0.200
    84.173    -1.449     0.200
    84.177    -0.110     0.200
    84.173     1.088     0.200
    84.201     0.142     0.200
    84.229    -1.633     0.200
    84.258    -0.415     0.200
    84.298     0.277     0.200
    84.307     0.432     0.200
    84.324    -0.481     0.200
    84.328    -0.475     0.200
    84.345     0.812     0.200
    84.364    -0.254     0.200
    84.419    -1.164     0.200
    84.450    -0.422     0.200
    84.457    -1.736     0.200
    84.594    -1.088     0.200
    84.596    -0.777     0.200
    84.603    -1.073     0.200
    84.675    -0.983     0.200
    84.682    -2.098     0.200
    84.716    -0.219     0.200
    84.735    -0.327     0.200
    84.699    -0.023     0.200
    84.788    -0.151     0.200
    84.867    -1.609     0.200
    84.866    -0.183     0.200
    84.915    -0.979     0.200
    84.922     1.749     0.200
    84.950    -0.605     0.200
    84.961    -0.360     0.200
    84.990    -0.006     0.200
    85.003    -1.612     0.200
    85.023    -2.089     0.200
    85.085    -0.081     0.200
    85.099    -0.531     0.200
    85.106     1.632     0.200
    85.120     0.143     0.200
    85.149    -2.431     0.200
    85.149    -1.479     0.200
    85.168    -2.436     0.200
    85.168    -2.335     0.200
    85.181    -0.062     0.200
    85.207    -0.051     0.200
    85.240    -0.936     0.200
    85.303    -0.872     0.200
    85.343    -0.572     0.200
    85.343    -0.268     0.200
    85.365    -1.701     0.200
    85.391     0.089     0.200
    85.397    -0.356     0.200
    85.454    -1.021     0.200
    85.473    -0.719     0.200
    85.531    -0.606     0.200
    85.522     0.873     0.200
    85.584    -0.769     0.200
    85.603     0.139     0.200
    85.647     0.120     0.200
    85.753    -0.405     0.200
    85.766     0.531     0.200
    85.967    -0.866     0.200
    85.913     1.042     0.200
    85.913     1.103     0.200
    86.008    -0.765     0.200
    85.972    -0.229     0.200
    86.044     0.158     0.200
    86.177     0.001     0.200
    86.254    -0.376     0.200
    86.278     0.205     0.200
    86.339     0.303     0.200
    86.382    -0.106     0.200
    86.418     0.419     0.200
    86.433     0.643     0.200
    86.418    -0.102     0.200
    86.569     0.079     0.200
    86.575    -0.052     0.200
    86.610    -0.123     0.200
    86.612    -0.844     0.200
    86.854     0.686     0.200
    87.325     0.433     0.200
    87.781     0.418     0.200
    88.112     0.081     0.200
    88.335     0.046     0.200
    88.501     0.212     0.200
    88.680     0.170     0.200
    88.687    -0.862     0.200
    88.887     1.099     0.200
    88.922     0.832     0.200
    89.099     0.803     0.200
    89.112     0.023     0.200
    89.281    -0.232     0.200
    89.494     0.222     0.200
    89.597     0.439     0.200
    89.934     0.057     0.200
    90.125     0.693     0.200
    90.659    -0.430     0.200
    91.344     0.339     0.200
    91.455     0.175     0.200
    91.525    -0.439     0.200
    91.832    -0.521     0.200
    91.906    -1.230     0.200
    91.960    -0.913     0.200
    92.262    -0.339     0.200
    92.721    -0.625     0.200
    93.101    -0.238     0.200
    93.252     0.866     0.200
    93.291    -0.853     0.200
    93.489    -0.563     0.200
    93.575     0.518     0.200
    93.990    -0.770     0.200
    94.457    -0.709     0.200
    94.521     0.238     0.200
    94.671    -0.693     0.200
    95.680    -0.529     0.200
    95.788    -0.591     0.200
    96.479    -0.730     0.200
    15.570     1.810     0.200
    17.939    -0.953     0.200
    17.939    -2.421     0.200
    19.636    -1.532     0.200
    20.380    -2.511     0.200
    20.391    -2.114     0.200
    20.983    -2.720     0.200
    21.330    -4.341     0.200
    21.330    -4.740     0.200
    21.379    -1.572     0.200
    21.803     1.099     0.200
    22.700     1.589     0.200
    23.585     0.578     0.200
    24.038    -4.663     0.200
    24.782     0.264     0.200
    25.826    -0.507     0.200
    26.347    -0.171     0.200
    27.865    -0.029     0.200
    27.975    -0.803     0.200
    29.458    -0.945     0.200
    29.856     0.004     0.200
    30.262     0.113     0.200
    30.862     0.826     0.200
    31.302    -2.356     0.200
    32.622     0.760     0.200
    33.305    -0.199     0.200
    33.686    -0.512     0.200
    36.476     1.492     0.200
    37.303     0.761     0.200
    39.875     0.203     0.200
    41.531    -0.397     0.200
    42.318    -0.755     0.200
    42.639    -0.277     0.200
    42.808    -1.723     0.200
    43.050     0.820     0.200
    43.263     1.601     0.200
    43.582    -0.670     0.200
    43.894    -0.473     0.200
    43.974     0.085     0.200
    43.974    -0.548     0.200
    44.037    -1.344     0.200
    44.268     0.463     0.200
    44.268     0.986     0.200
    44.394    -0.931     0.200
    45.030    -2.791     0.200
    45.349    -0.202     0.200
    45.346     1.461     0.200
    45.458     0.086     0.200
    47.714    -0.925     0.200
    48.125     0.852     0.200
    48.185    -0.173     0.200
    48.447     0.708     0.200
    48.635     0.623     0.200
    48.659     0.438     0.200
    48.863     1.078     0.200
    48.983    -0.095     0.200
    48.991     0.491     0.200
    48.996     0.265     0.200
    49.043    -0.201     0.200
    49.134    -0.595     0.200
    49.134    -0.931     0.200
    49.304     0.421     0.200
    49.304    -0.689     0.200
    49.622     1.284     0.200
    49.775     0.129     0.200
    49.891     0.641     0.200
    50.054     0.510     0.200
    51.829     0.618     0.200
    52.161    -0.085     0.200
    53.204    -0.786     0.200
    53.374    -0.734     0.200
    54.104    -1.568     0.200
    54.280    -0.772     0.200
    54.280     0.728     0.200
    54.306    -0.668     0.200
    54.371    -0.127     0.200
    54.371     0.662     0.200
    54.935    -0.545     0.200
    54.935     0.979     0.200
    55.475    -0.849     0.200
    55.475     0.799     0.200
    57.045    -0.595     0.200
    57.185    -1.472     0.200
    58.590    -1.496     0.200
    58.630    -0.220     0.200
    59.011    -1.909     0.200
    59.556    -1.472     0.200
    59.714    -0.379     0.200
    59.756    -0.047     0.200
    60.609     0.617     0.200
    60.649    -1.155     0.200
    61.179    -2.405     0.200
    62.135     1.037     0.200
    62.442    -0.293     0.200
    62.452    -0.340     0.200
    62.550    -0.913     0.200
    62.779    -0.687     0.200
    63.064    -0.367     0.200
    63.390     1.110     0.200
    63.841    -1.703     0.200
    63.854     0.987     0.200
    64.254    -2.410     0.200
    64.356     0.027     0.200
    64.448     0.063     0.200
    64.701    -0.918     0.200
    64.701    -1.238     0.200
    64.791    -1.334     0.200
    64.840     0.473     0.200
    64.896    -2.687     0.200
    65.143    -0.364     0.200
    65.426    -0.205     0.200
    65.494     0.367     0.200
    65.541    -1.565     0.200
    66.179     0.730     0.200
    66.706     0.693     0.200
    66.732    -0.120     0.200
    66.941     1.009     0.200
    68.338     0.706     0.200
    68.392    -0.819     0.200
    68.486     0.350     0.200
    68.486     0.561     0.200
    68.599    -0.317     0.200
    68.703     0.995     0.200
    68.729    -1.270     0.200
    69.273     0.321     0.200
    69.813     1.217     0.200
    69.847    -1.071     0.200
    69.847    -1.095     0.200
    69.881     0.967     0.200
    70.100     0.597     0.200
    70.389    -0.193     0.200
    70.848     1.844     0.200
    70.953    -0.968     0.200
    70.933    -0.161     0.200
    71.062     0.443     0.200
    71.173    -1.250     0.200
    71.274     2.878     0.200
    71.366     1.826     0.200
    71.730     0.822     0.200
    71.787     1.004     0.200
    71.954     0.597     0.200
    72.367    -0.597     0.200
    72.511     0.628     0.200
    72.650     0.970     0.200
    72.971     0.970     0.200
    73.045     1.037     0.200
    73.088     0.661     0.200
    73.361    -0.005     0.200
    73.554     1.110     0.200
    73.751    -2.088     0.200
    73.768     0.158     0.200
    73.821     0.081     0.200
    73.821     0.433     0.200
    74.046    -0.514     0.200
    74.414    -0.281     0.200
    74.414    -0.703     0.200
    74.439     1.401     0.200
    74.446    -0.063     0.200
    74.454     1.244     0.200
    74.486     0.482     0.200
    74.492     0.595     0.200
    74.537    -0.549     0.200
    74.622     0.339     0.200
    74.753     1.344     0.200
    74.959    -0.471     0.200
    74.959    -0.143     0.200
    74.965     0.714     0.200
    75.010     0.750     0.200
    75.093     0.403     0.200
    75.084    -0.148     0.200
    75.237     0.976     0.200
    75.335    -0.266     0.200
    75.402    -0.155     0.200
    75.559     0.916     0.200
    75.726     1.087     0.200
    75.809     0.419     0.200
    75.948    -0.334     0.200
    75.958    -0.327     0.200
    76.219    -0.034     0.200
    76.317     0.137     0.200
    76.317     0.238     0.200
    76.350     0.150     0.200
    76.373     0.217     0.200
    76.359     1.887     0.200
    76.627     0.710     0.200
    76.664    -0.118     0.200
    76.692     0.118     0.200
    76.696     0.392     0.200
    76.793     0.913     0.200
    77.062     1.050     0.200
    77.135     0.128     0.200
    77.182    -0.534     0.200
    77.187    -0.165     0.200
    77.229     0.199     0.200
    77.284     1.128     0.200
    77.414     0.375     0.200
    77.674     0.112     0.200
    77.678    -0.110     0.200
    77.704     0.745     0.200
    78.026     0.014     0.200
    78.088    -0.585     0.200
    78.229    -0.362     0.200
    78.263     0.042     0.200
    78.500    -0.066     0.200
    78.627    -0.737     0.200
    78.652    -1.899     0.200
    78.738     0.031     0.200
    78.769    -1.202     0.200
    78.797     0.617     0.200
    78.922    -0.083     0.200
    78.922    -0.294     0.200
    78.994     0.128     0.200
    79.000    -0.704     0.200
    79.159     0.325     0.200
    79.159     0.325     0.200
    79.338    -0.249     0.200
    79.509     0.121     0.200
    79.488     0.884     0.200
    79.555    -0.906     0.200
    79.635     0.735     0.200
    79.694     0.414     0.200
    79.741     0.272     0.200
    79.795     0.762     0.200
    79.841    -0.038     0.200
    79.853    -0.038     0.200
    79.879    -0.468     0.200
    79.872    -0.151     0.200
    79.926    -1.088     0.200
    79.926    -1.776     0.200
    80.080    -0.484     0.200
    80.129    -0.335     0.200
    80.147    -0.038     0.200
    80.198     0.194     0.200
    80.222     1.536     0.200
    80.235     1.697     0.200
    80.235     1.392     0.200
    80.403     0.295     0.200
    80.481    -0.221     0.200
    80.501     0.367     0.200
    80.621    -0.482     0.200
    80.659    -0.550     0.200
    80.660    -0.878     0.200
    80.866    -0.539     0.200
    80.977    -0.073     0.200
    81.011    -0.855     0.200
    81.013     0.233     0.200
    81.015     0.824     0.200
    81.018    -0.168     0.200
    81.047    -0.813     0.200
    81.138    -1.657     0.200
    81.149     0.010     0.200
    81.154    -0.712     0.200
    81.212     0.073     0.200
    81.245    -0.599     0.200
    81.307     0.414     0.200
    81.329    -0.339     0.200
    81.342    -0.411     0.200
    81.643    -0.499     0.200
    81.657    -0.075     0.200
    81.938    -0.826     0.200
    81.960    -0.094     0.200
    82.082     0.648     0.200
    82.150     0.564     0.200
    82.299    -0.942     0.200
    82.323    -0.566     0.200
    82.524    -1.177     0.200
    82.534     1.008     0.200
    82.566     1.144     0.200
    82.613     1.215     0.200
    82.648     0.569     0.200
    82.842    -1.812     0.200
    82.848     1.062     0.200
    82.993     0.680     0.200
    83.049     0.569     0.200
    83.105     0.150     0.200
    83.266    -0.776     0.200
    83.372     0.891     0.200
    83.434    -0.714     0.200
    83.416     1.180     0.200
    83.435     0.887     0.200
    83.602    -0.283     0.200
    83.753    -0.070     0.200
    83.785     0.949     0.200
    83.793    -0.655     0.200
    83.825    -1.025     0.200
    83.854     1.189     0.200
    83.871    -0.655     0.200
    83.919    -0.165     0.200
    83.930     1.398     0.200
    84.069     0.268     0.200
    84.091    -0.570     0.200
    84.192    -0.288     0.200
    84.191     1.339     0.200
    84.272    -0.490     0.200
    84.313     0.096     0.200
    84.323     0.253     0.200
    84.340     0.422     0.200
    84.343    -0.453     0.200
    84.620    -0.528     0.200
    84.692    -0.285     0.200
    84.693     0.455     0.200
    84.731    -0.590     0.200
    84.750    -0.404     0.200
    84.848     0.721     0.200
    84.880    -0.157     0.200
    84.940     1.766     0.200
    84.976    -0.641     0.200
    85.004    -0.178     0.200
    85.135    -0.139     0.200
    85.124     1.582     0.200
    85.196    -0.138     0.200
    85.224     0.396     0.200
    85.256    -0.194     0.200
    85.357    -0.338     0.200
    85.469    -0.999     0.200
    85.618    -0.042     0.200
    85.662     0.045     0.200
    85.905     0.886     0.200
    85.969    -0.044     0.200
    85.983    -0.851     0.200
    86.023    -0.946     0.200
    86.059    -0.123     0.200
    86.269    -0.455     0.200
    86.448     0.669     0.200
    86.584     0.104     0.200
    86.629    -0.171     0.200
    86.869     0.408     0.200
    87.128    -1.870     0.200
    87.796     0.246     0.200
    88.528    -0.670     0.200
    88.702     0.162     0.200
    89.113     0.533     0.200
    89.133     0.635     0.200
    89.990     0.877     0.200
    90.174    -0.536     0.200
    90.760    -0.112     0.200
    91.974    -0.380     0.200
    92.735    -0.291     0.200
    93.115     0.166     0.200
    93.115    -0.342     0.200
    93.503    -0.329     0.200
    14.477     4.639     0.200
    14.993     5.030     0.200
    14.993     4.429     0.200
    17.957    -1.359     0.200
    17.957    -1.781     0.200
    19.596    -1.056     0.200
    20.331    -2.783     0.200
    20.342    -2.495     0.200
    20.933    -2.781     0.200
    21.323    -4.065     0.200
    21.323    -3.620     0.200
    21.397    -2.863     0.200
    22.744     0.173     0.200
    23.537    -1.887     0.200
    24.733    -0.297     0.200
    24.797     0.198     0.200
    25.776    -1.761     0.200
    25.861    -0.731     0.200
    25.861    -0.161     0.200
    26.305    -0.137     0.200
    26.580     0.281     0.200
    27.828    -0.905     0.200
    27.924    -2.262     0.200
    28.170    -0.044     0.200
    28.170    -0.309     0.200
    28.344    -0.396     0.200
    29.408    -1.141     0.200
    29.818     0.031     0.200
    30.262    -3.090     0.200
    30.262    -2.793     0.200
    30.812     0.355     0.200
    32.575     0.872     0.200
    33.255    -0.269     0.200
    33.636    -0.587     0.200
    33.974     0.771     0.200
    36.428     3.089     0.200
    37.253     0.380     0.200
    39.512    -0.676     0.200
    39.832     0.258     0.200
    40.303    -1.036     0.200
    42.357     0.809     0.200
    42.436    -0.613     0.200
    42.598    -0.129     0.200
    42.758    -1.527     0.200
    43.001     0.508     0.200
    43.213     2.798     0.200
    43.618    -0.170     0.200
    43.721     0.918     0.200
    43.833    -0.390     0.200
    43.857    -0.381     0.200
    43.857    -0.537     0.200
    44.009    -0.397     0.200
    44.074     0.301     0.200
    44.218     0.929     0.200
    44.429    -0.850     0.200
    44.930     1.058     0.200
    45.066     2.134     0.200
    45.297     1.644     0.200
    45.387    -0.432     0.200
    45.496     0.595     0.200
    46.047     0.931     0.200
    46.376    -0.351     0.200
    47.358    -0.017     0.200
    47.775    -0.449     0.200
    47.759     2.169     0.200
    47.749    -0.221     0.200
    48.076     0.827     0.200
    48.101    -0.267     0.200
    48.101    -0.126     0.200
    48.151    -0.109     0.200
    48.241     1.678     0.200
    48.405     0.615     0.200
    48.586     0.502     0.200
    48.610     0.419     0.200
    48.814     0.652     0.200
    48.942    -0.112     0.200
    48.949     0.459     0.200
    48.946     0.236     0.200
    48.982     1.507     0.200
    49.002     0.084     0.200
    49.099     0.066     0.200
    49.165    -0.785     0.200
    49.165    -0.527     0.200
    49.262     0.122     0.200
    49.262    -1.073     0.200
    49.262    -1.214     0.200
    49.329    -1.763     0.200
    49.419     0.694     0.200
    49.578     1.210     0.200
    49.734     0.164     0.200
    49.842     0.811     0.200
    50.012     0.851     0.200
    51.334     1.353     0.200
    52.545    -2.836     0.200
    52.732     0.488     0.200
    53.001    -1.497     0.200
    53.018     1.176     0.200
    53.345    -0.626     0.200
    53.578     2.066     0.200
    53.654    -2.539     0.200
    53.765     1.122     0.200
    54.056    -1.421     0.200
    54.232     0.023     0.200
    54.232     1.195     0.200
    54.391     0.412     0.200
    54.887     0.342     0.200
    54.887     2.146     0.200
    55.427     0.386     0.200
    55.427     1.293     0.200
    55.589     0.099     0.200
    56.996     0.113     0.200
    56.996     1.480     0.200
    57.178    -0.170     0.200
    57.178     1.659     0.200
    57.206    -1.540     0.200
    58.622    -0.631     0.200
    58.663    -0.902     0.200
    58.663    -0.300     0.200
    59.000    -1.638     0.200
    59.545    -0.906     0.200
    59.706     0.094     0.200
    60.499    -1.344     0.200
    60.560     1.253     0.200
    60.653    -1.281     0.200
    61.245    -0.895     0.200
    61.950    -2.743     0.200
    62.130     1.350     0.200
    62.130     0.498     0.200
    62.130     1.873     0.200
    62.196     0.413     0.200
    62.500     0.199     0.200
    62.500     1.097     0.200
    62.426    -0.361     0.200
    62.435    -0.492     0.200
    62.437    -0.618     0.200
    62.718     1.399     0.200
    63.014    -0.099     0.200
    63.014     1.354     0.200
    62.951     1.288     0.200
    63.039     0.370     0.200
    63.817    -0.545     0.200
    63.896     1.141     0.200
    64.337    -2.450     0.200
    64.337    -0.848     0.200
    64.426     4.227     0.200
    64.439     1.210     0.200
    64.534    -1.352     0.200
    64.486    -0.333     0.200
    64.676    -1.167     0.200
    64.676    -1.057     0.200
    64.774    -1.600     0.200
    64.790     0.072     0.200
    64.886    -2.418     0.200
    65.190     0.610     0.200
    65.320     0.125     0.200
    65.536     0.257     0.200
    66.164    -0.022     0.200
    66.164     0.223     0.200
    66.261     0.102     0.200
    66.203     1.609     0.200
    66.585    -1.067     0.200
    66.673     0.733     0.200
    66.673     1.647     0.200
    66.705    -0.003     0.200
    66.746     0.516     0.200
    66.821    -1.686     0.200
    67.015    -0.099     0.200
    66.987     0.721     0.200
    67.573    -0.228     0.200
    67.494     0.817     0.200
    67.547     0.233     0.200
    67.574     2.438     0.200
    68.119    -0.278     0.200
    68.453     0.454     0.200
    68.383     0.508     0.200
    68.433    -0.012     0.200
    68.630     0.748     0.200
    68.634    -0.422     0.200
    68.759    -0.684     0.200
    68.749     0.902     0.200
    69.314     0.507     0.200
    69.463     1.016     0.200
    69.614     0.494     0.200
    69.611    -0.741     0.200
    69.827    -1.772     0.200
    69.835    -1.005     0.200
    69.835    -1.325     0.200
    69.858     0.990     0.200
    69.980     0.316     0.200
    70.141     0.829     0.200
    70.305     0.888     0.200
    70.305     1.029     0.200
    70.357    -0.395     0.200
    70.284     0.017     0.200
    70.820    -0.714     0.200
    70.747     1.088     0.200
    70.929    -0.976     0.200
    70.893     0.914     0.200
    70.979     1.313     0.200
    70.982     1.176     0.200
    71.152    -1.127     0.200
    71.103     1.435     0.200
    71.226     1.771     0.200
    71.251     0.581     0.200
    71.316     1.362     0.200
    71.377    -0.983     0.200
    71.411     1.567     0.200
    71.625     1.507     0.200
    71.775     1.397     0.200
    71.777     1.447     0.200
    71.775     0.676     0.200
    71.829     1.067     0.200
    71.958     0.097     0.200
    71.887     1.465     0.200
    71.968     1.520     0.200
    71.979    -0.405     0.200
    71.996     0.747     0.200
    71.997     1.153     0.200
    72.013     1.809     0.200
    72.026     1.449     0.200
    72.177     1.123     0.200
    72.285     0.544     0.200
    72.481    -0.298     0.200
    72.514     0.434     0.200
    72.601     0.487     0.200
    72.587     1.883     0.200
    72.808    -0.213     0.200
    72.793     1.110     0.200
    72.959     0.665     0.200
    73.051     0.478     0.200
    73.134     0.629     0.200
    73.091     0.801     0.200
    73.130     0.259     0.200
    73.205     1.406     0.200
    73.341    -1.087     0.200
    73.416    -0.930     0.200
    73.525     0.956     0.200
    73.598     0.824     0.200
    73.724    -1.636     0.200
    73.756     0.680     0.200
    73.804    -1.202     0.200
    73.724     1.179     0.200
    73.885    -0.177     0.200
    73.811     1.257     0.200
    73.812     0.149     0.200
    73.812    -0.070     0.200
    74.027    -0.508     0.200
    74.005     0.926     0.200
    74.215    -0.701     0.200
    74.235     1.019     0.200
    74.405    -0.377     0.200
    74.496    -0.419     0.200
    74.497    -0.324     0.200
    74.449    -0.560     0.200
    74.483     1.475     0.200
    74.578    -0.034     0.200
    74.498     1.357     0.200
    74.600     0.165     0.200
    74.535     0.898     0.200
    74.786    -0.289     0.200
    74.798     0.863     0.200
    74.917    -0.185     0.200
    74.918    -0.859     0.200
    75.061     0.494     0.200
    75.010     0.397     0.200
    75.053     1.033     0.200
    75.201     0.867     0.200
    75.206     0.975     0.200
    75.131     1.297     0.200
    75.312     0.162     0.200
    75.674     0.556     0.200
    75.687     0.416     0.200
    75.692     1.081     0.200
    75.606     1.048     0.200
    75.788    -1.353     0.200
    75.787     0.340     0.200
    75.854    -0.540     0.200
    75.905     0.199     0.200
    75.943    -0.240     0.200
    76.023     0.414     0.200
    76.192     0.192     0.200
    76.288     0.347     0.200
    76.297    -0.160     0.200
    76.318     0.276     0.200
    76.352    -0.064     0.200
    76.402     1.736     0.200
    76.524    -0.050     0.200
    76.596     0.151     0.200
    76.672     0.126     0.200
    76.676     0.401     0.200
    76.676     0.300     0.200
    76.686     0.442     0.200
    76.688     0.577     0.200
    76.836     0.990     0.200
    77.028     1.197     0.200
    77.115     0.333     0.200
    77.164    -0.638     0.200
    77.169    -0.570     0.200
    77.112    -0.050     0.200
    77.211     0.101     0.200
    77.211    -0.203     0.200
    77.258     1.337     0.200
    77.326     1.332     0.200
    77.655    -0.383     0.200
    77.655    -0.086     0.200
    77.661    -0.120     0.200
    77.833    -0.074     0.200
    77.856     1.098     0.200
    77.865     1.045     0.200
    77.871     0.818     0.200
    77.939     0.838     0.200
    77.994     0.256     0.200
    77.994    -0.181     0.200
    78.067     0.626     0.200
    78.098     0.458     0.200
    78.061    -0.477     0.200
    78.212    -0.469     0.200
    78.245    -0.460     0.200
    78.245    -0.256     0.200
    78.469     0.061     0.200
    78.515     0.155     0.200
    78.515     0.335     0.200
    78.593    -0.171     0.200
    78.609    -1.858     0.200
    78.618    -0.494     0.200
    78.719     0.034     0.200
    78.719    -0.169     0.200
    78.728     0.023     0.200
    78.754    -0.535     0.200
    78.903    -0.377     0.200
    78.903    -0.564     0.200
    78.840     1.056     0.200
    78.931    -0.130     0.200
    78.955    -0.646     0.200
    79.133    -0.298     0.200
    79.141     0.117     0.200
    79.141     0.117     0.200
    79.233     0.217     0.200
    79.386    -0.655     0.200
    79.489     0.027     0.200
    79.526    -0.563     0.200
    79.516    -0.392     0.200
    79.607    -1.789     0.200
    79.608     0.181     0.200
    79.512     1.202     0.200
    79.621     0.123     0.200
    79.534     1.122     0.200
    79.668    -0.145     0.200
    79.698     0.347     0.200
    79.754     0.716     0.200
    79.800    -0.064     0.200
    79.948    -0.410     0.200
    80.012    -0.403     0.200
    80.023    -0.615     0.200
    80.066    -0.951     0.200
    80.080    -0.372     0.200
    80.089    -0.642     0.200
    80.089    -0.400     0.200
    80.171     0.137     0.200
    80.219    -0.619     0.200
    80.251    -2.435     0.200
    80.249    -0.674     0.200
    80.277    -0.433     0.200
    80.281    -0.354     0.200
    80.279     2.056     0.200
    80.279     0.877     0.200
    80.385    -0.012     0.200
    80.433    -0.476     0.200
    80.460    -0.016     0.200
    80.481     0.974     0.200
    80.496    -0.867     0.200
    80.601    -0.466     0.200
    80.734    -0.348     0.200
    80.735    -1.128     0.200
    80.735    -0.854     0.200
    80.779    -0.222     0.200
    80.742     1.863     0.200
    80.826    -0.294     0.200
    80.857    -0.038     0.200
    80.877    -0.347     0.200
    80.902    -0.137     0.200
    80.935    -0.478     0.200
    80.945     0.651     0.200
    80.958     0.528     0.200
    80.958    -0.576     0.200
    80.990    -0.645     0.200
    80.989     0.759     0.200
    80.996    -0.878     0.200
    81.021    -0.205     0.200
    81.027    -0.752     0.200
    81.082    -0.843     0.200
    81.098    -0.928     0.200
    81.113    -1.198     0.200
    81.130     0.407     0.200
    81.156    -1.160     0.200
    81.183    -1.140     0.200
    81.194     0.470     0.200
    81.215    -0.644     0.200
    81.231    -0.820     0.200
    81.233    -0.792     0.200
    81.177    -0.718     0.200
    81.265     0.496     0.200
    81.254    -0.249     0.200
    81.262    -0.289     0.200
    81.302    -0.431     0.200
    81.325    -0.422     0.200
    81.354    -0.178     0.200
    81.378    -0.098     0.200
    81.428    -0.813     0.200
    81.432    -1.026     0.200
    81.449    -0.727     0.200
    81.480    -0.985     0.200
    81.582    -0.762     0.200
    81.586    -1.284     0.200
    81.599    -0.672     0.200
    81.618    -0.758     0.200
    81.626    -0.514     0.200
    81.639     0.420     0.200
    81.659    -0.281     0.200
    81.735    -0.983     0.200
    81.788    -0.765     0.200
    81.826    -0.368     0.200
    81.835    -0.714     0.200
    81.863    -0.959     0.200
    81.911    -1.112     0.200
    81.920    -0.548     0.200
    81.927    -0.081     0.200
    81.933    -0.658     0.200
    81.994    -0.791     0.200
    82.029    -0.458     0.200
    82.063     0.065     0.200
    82.120    -0.925     0.200
    82.131     0.545     0.200
    82.155    -0.492     0.200
    82.230    -0.682     0.200
    82.283    -0.957     0.200
    82.296    -0.832     0.200
    82.308    -0.392     0.200
    82.352    -0.320     0.200
    82.493     0.905     0.200
    82.528     1.279     0.200
    82.574     0.883     0.200
    82.604     0.062     0.200
    82.691    -0.479     0.200
    82.739     1.151     0.200
    82.811     1.209     0.200
    82.814    -2.184     0.200
    83.035     0.610     0.200
    83.248    -0.885     0.200
    83.334     1.039     0.200
    83.407    -0.788     0.200
    83.422     0.511     0.200
    83.461     0.262     0.200
    83.483    -0.130     0.200
    83.460     1.119     0.200
    83.575    -0.320     0.200
    83.586    -0.502     0.200
    83.616    -0.557     0.200
    83.639     0.672     0.200
    83.668     1.372     0.200
    83.689     0.526     0.200
    83.740    -1.258     0.200
    83.744    -0.382     0.200
    83.764     0.883     0.200
    83.764     1.288     0.200
    83.774    -0.168     0.200
    83.813    -0.859     0.200
    83.823     0.584     0.200
    83.834     0.524     0.200
    83.858    -0.988     0.200
    83.882     0.148     0.200
    83.886     1.011     0.200
    83.910    -0.924     0.200
    83.920    -0.257     0.200
    83.918     0.385     0.200
    83.928    -1.166     0.200
    83.958    -0.724     0.200
    84.012    -0.320     0.200
    84.035    -1.113     0.200
    84.059    -0.575     0.200
    84.075    -0.595     0.200
    84.078    -0.883     0.200
    84.086    -1.374     0.200
    84.152     1.315     0.200
    84.169    -1.048     0.200
    84.177    -0.214     0.200
    84.187    -0.264     0.200
    84.199     0.468     0.200
    84.225    -1.925     0.200
    84.259    -0.630     0.200
    84.273    -0.791     0.200
    84.296     0.083     0.200
    84.299    -0.227     0.200
    84.305     0.240     0.200
    84.318     0.448     0.200
    84.323     0.813     0.200
    84.328    -0.476     0.200
    84.363    -0.462     0.200
    84.377     0.609     0.200
    84.387     0.433     0.200
    84.417    -1.699     0.200
    84.444     0.429     0.200
    84.454    -0.974     0.200
    84.590     0.300     0.200
    84.592    -0.475     0.200
    84.670    -0.436     0.200
    84.679    -0.312     0.200
    84.703    -0.088     0.200
    84.735    -0.429     0.200
    84.785    -0.245     0.200
    84.734     0.394     0.200
    84.864    -1.388     0.200
    84.868    -0.301     0.200
    84.897     1.692     0.200
    84.912    -1.333     0.200
    84.927     0.965     0.200
    84.942    -0.174     0.200
    84.959    -0.552     0.200
    84.974    -1.784     0.200
    84.992     1.177     0.200
    84.993    -0.130     0.200
    85.000    -1.619     0.200
    85.020    -1.422     0.200
    85.118    -0.052     0.200
    85.146    -1.448     0.200
    85.146    -2.200     0.200
    85.165    -2.296     0.200
    85.165    -1.999     0.200
    85.181    -0.165     0.200
    85.237    -0.320     0.200
    85.300    -0.666     0.200
    85.341    -0.460     0.200
    85.345    -0.391     0.200
    85.362    -2.085     0.200
    85.363     0.225     0.200
    85.392    -0.624     0.200
    85.451    -0.915     0.200
    85.470    -0.607     0.200
    85.497     0.791     0.200
    85.528    -0.497     0.200
    85.475    -1.354     0.200
    85.581    -0.657     0.200
    85.601    -0.061     0.200
    85.619     0.249     0.200
    85.648     0.011     0.200
    85.765     1.329     0.200
    85.770     0.104     0.200
    85.901    -0.241     0.200
    85.869    -0.327     0.200
    85.963    -0.253     0.200
    86.005    -0.958     0.200
    85.950     1.041     0.200
    85.950     0.268     0.200
    86.042    -0.037     0.200
    86.006    -0.434     0.200
    86.019     0.380     0.200
    86.097    -0.014     0.200
    86.175    -0.192     0.200
    86.251    -0.670     0.200
    86.278     0.097     0.200
    86.337     0.203     0.200
    86.415     0.226     0.200
    86.432     0.541     0.200
    86.452    -1.298     0.200
    86.567     0.177     0.200
    86.572    -0.042     0.200
    86.603    -0.148     0.200
    86.608     0.081     0.200
    86.854     0.480     0.200
    87.267    -0.627     0.200
    87.361     0.538     0.200
    87.623     0.437     0.200
    87.689    -0.659     0.200
    87.780     0.314     0.200
    87.799     0.102     0.200
    87.831     0.666     0.200
    87.886    -0.257     0.200
    88.145    -0.244     0.200
    88.233     0.371     0.200
    88.334     1.819     0.200
    88.501     0.508     0.200
    88.687    -0.165     0.200
    88.886     1.091     0.200
    89.060    -0.128     0.200
    89.099     0.594     0.200
    89.111     0.637     0.200
    89.112     0.054     0.200
    89.119     0.499     0.200
    89.169     0.343     0.200
    89.280     1.049     0.200
    89.525    -0.073     0.200
    89.629     0.667     0.200
    89.693    -1.110     0.200
    89.933     0.334     0.200
    90.125    -0.313     0.200
    90.148    -0.852     0.200
    90.540     0.284     0.200
    90.662    -0.711     0.200
    90.797    -0.275     0.200
    91.241     0.715     0.200
    91.336    -0.277     0.200
    91.343     0.438     0.200
    91.455     0.209     0.200
    91.528    -0.057     0.200
    91.835    -1.048     0.200
    91.963    -0.529     0.200
    92.266    -0.203     0.200
    92.724    -0.247     0.200
    93.101    -0.552     0.200
    93.101    -0.778     0.200
    93.294    -0.376     0.200
    93.491    -0.284     0.200
    93.575     0.479     0.200
    93.869    -0.319     0.200
    93.993    -0.886     0.200
    94.520     0.380     0.200
    94.672    -0.635     0.200
    94.867    -1.065     0.200
    95.129     0.049     0.200
    95.347    -0.891     0.200
    95.361    -0.753     0.200
    95.469    -0.168     0.200
    95.790    -0.107     0.200
    96.199    -0.170     0.200
    96.263    -1.250     0.200
    96.481    -0.451     0.200
    17.919    -1.211     0.200
    20.384    -1.741     0.200
    21.307    -2.278     0.200
    25.889    -0.253     0.200
    28.367    -0.678     0.200
    28.662    -0.895     0.200
    29.457    -0.463     0.200
    32.613     1.060     0.200
    43.877    -0.418     0.200
    47.789    -0.538     0.200
    61.945    -1.585     0.200
    64.232    -1.844     0.200
    69.824    -1.714     0.200
    76.350     1.629     0.200
    77.160    -0.497     0.200
    78.716    -0.029     0.200
    17.942    -1.618     0.200
    18.573    -0.147     0.200
    20.259    -1.726     0.200
    20.270    -2.745     0.200
    20.868    -2.299     0.200
    21.271    -3.032     0.200
    23.463    -0.200     0.200
    23.943    -3.386     0.200
    26.228     0.075     0.200
    27.857    -0.247     0.200
    28.094     0.748     0.200
    28.094    -0.051     0.200
    28.267    -0.395     0.200
    28.695    -2.901     0.200
    29.346    -1.665     0.200
    29.742     0.724     0.200
    30.741     0.600     0.200
    32.500     0.844     0.200
    33.578     0.645     0.200
    39.437     0.169     0.200
    39.755     0.026     0.200
    40.228    -0.593     0.200
    41.577    -0.388     0.200
    42.521    -0.278     0.200
    42.703     0.248     0.200
    43.142     1.795     0.200
    43.142     1.496     0.200
    43.781    -0.343     0.200
    43.781    -0.932     0.200
    43.923     0.715     0.200
    44.024    -0.089     0.200
    44.095     0.245     0.200
    44.162     1.006     0.200
    44.443    -0.540     0.200
    47.700    -1.138     0.200
    47.910     0.834     0.200
    48.026     0.042     0.200
    48.514     0.284     0.200
    48.538    -0.002     0.200
    48.742     0.334     0.200
    48.875     0.218     0.200
    49.171    -0.952     0.200
    49.171    -0.514     0.200
    49.501     0.833     0.200
    49.770     0.593     0.200
    52.061    -0.112     0.200
    52.932     0.046     0.200
    53.787     1.377     0.200
    58.673    -0.386     0.200
    59.490    -0.759     0.200
    59.637     0.405     0.200
    62.457     0.010     0.200
    64.177    -2.760     0.200
    64.608    -1.078     0.200
    64.713    -1.159     0.200
    65.403    -0.371     0.200
    65.565     0.823     0.200
    66.184     0.395     0.200
    67.499    -0.414     0.200
    68.379     0.763     0.200
    68.379    -0.218     0.200
    68.764    -1.137     0.200
    69.778    -1.007     0.200
    69.778    -1.007     0.200
    70.170    -0.006     0.200
    70.283     1.403     0.200
    70.694     0.684     0.200
    70.860    -1.012     0.200
    70.839     1.488     0.200
    70.933     1.425     0.200
    71.022     1.008     0.200
    71.223     1.831     0.200
    71.427     0.603     0.200
    71.614     0.788     0.200
    72.030     0.864     0.200
    72.145     0.807     0.200
    73.049     0.986     0.200
    73.160     1.064     0.200
    73.160     0.533     0.200
    74.463    -0.063     0.200
    74.533    -0.094     0.200
    74.570     1.882     0.200
    75.245    -0.201     0.200
    76.244     0.196     0.200
    76.436     1.037     0.200
    76.608     0.136     0.200
    76.612     0.216     0.200
    77.102    -0.539     0.200
    77.106    -0.361     0.200
    77.592    -0.478     0.200
    78.149    -0.475     0.200
    78.655     0.038     0.200
    78.839    -0.074     0.200
    78.872     1.117     0.200
    79.079     0.013     0.200
    79.079     0.013     0.200
    79.537     0.920     0.200
    79.598     0.589     0.200
    79.938    -0.578     0.200
    80.061    -0.074     0.200
    80.100    -0.128     0.200
    80.915    -0.421     0.200
    81.565    -0.638     0.200
    82.222    -0.483     0.200
    82.235    -0.855     0.200
    83.524    -0.128     0.200
    84.016    -0.836     0.200
    84.202     0.115     0.200
    84.234    -0.146     0.200
    84.243     0.008     0.200
    84.267    -0.616     0.200
    84.304    -0.499     0.200
    84.812    -0.062     0.200
    84.896     0.016     0.200
    84.937    -0.290     0.200
    85.056    -0.185     0.200
    85.122    -0.414     0.200
    85.387    -0.940     0.200
    85.540    -0.297     0.200
    85.590    -0.146     0.200
    85.988     1.061     0.200
    86.188    -0.802     0.200
    86.372     0.392     0.200
    86.506    -0.063     0.200
    88.627    -0.027     0.200
    89.039     0.534     0.200
    93.043    -0.819     0.200
    21.343    -2.006     0.200
    25.868    -0.531     0.200
    26.312    -0.019     0.200
    39.523    -0.721     0.200
    43.867    -0.813     0.200
    44.448    -0.304     0.200
    47.787    -0.692     0.200
    49.269    -1.081     0.200
    58.682     0.037     0.200
    59.565    -0.870     0.200
    61.968    -1.819     0.200
    62.415     0.373     0.200
    64.256    -1.781     0.200
    64.792    -1.480     0.200
    69.854    -1.031     0.200
    78.921    -0.382     0.200
    17.771    -1.865     0.200
    20.325    -0.229     0.200
    20.336    -0.349     0.200
    20.813     0.206     0.200
    21.142    -2.428     0.200
    21.210    -0.164     0.200
    21.822     2.299     0.200
    23.516    -2.890     0.200
    25.783     0.384     0.200
    25.783    -0.905     0.200
    26.227     0.155     0.200
    28.068    -0.122     0.200
    28.250    -0.138     0.200
    29.453    -1.020     0.200
    29.717     0.554     0.200
    32.545     0.755     0.200
    39.764     0.374     0.200
    43.214     1.356     0.200
    43.752     0.222     0.200
    43.752    -0.575     0.200
    43.752    -0.677     0.200
    43.853     1.221     0.200
    44.272    -0.189     0.200
    44.282    -0.516     0.200
    47.593     0.744     0.200
    47.654    -1.234     0.200
    47.979     1.046     0.200
    48.581     0.314     0.200
    48.606    -0.176     0.200
    48.809     0.462     0.200
    48.998    -0.380     0.200
    48.998    -0.896     0.200
    48.939    -0.232     0.200
    49.834     0.559     0.200
    57.022    -1.598     0.200
    58.500    -0.071     0.200
    59.369    -1.155     0.200
    61.784    -0.910     0.200
    62.614    -1.167     0.200
    62.625    -0.401     0.200
    64.070    -1.489     0.200
    64.527    -0.769     0.200
    64.608    -1.023     0.200
    66.352     0.403     0.200
    68.332     0.642     0.200
    68.332     0.900     0.200
    69.660    -0.997     0.200
    69.660    -1.090     0.200
    70.780    -0.989     0.200
    71.192    -1.430     0.200
    74.291    -1.101     0.200
    85.835     1.177     0.200
    16.599     0.849     0.200
    17.930    -2.546     0.200
    17.930    -1.226     0.200
    19.609    -0.472     0.200
    20.923    -2.738     0.200
    21.287    -2.963     0.200
    21.369    -2.733     0.200
    22.126     1.791     0.200
    22.737     0.779     0.200
    22.737     1.911     0.200
    23.518    -0.486     0.200
    25.772    -0.890     0.200
    26.278    -0.337     0.200
    28.315    -0.205     0.200
    28.678    -2.637     0.200
    29.400    -1.699     0.200
    29.788     0.328     0.200
    30.796     0.325     0.200
    32.554     0.379     0.200
    33.244     0.258     0.200
    33.631    -0.209     0.200
    37.246     0.765     0.200
    39.480    -0.616     0.200
    39.806     0.004     0.200
    40.271    -0.842     0.200
    41.547    -0.476     0.200
    42.570    -0.251     0.200
    43.001    -0.660     0.200
    43.198     1.853     0.200
    43.198     1.368     0.200
    43.827    -0.636     0.200
    43.976     0.792     0.200
    44.059     0.351     0.200
    44.411    -0.586     0.200
    47.820    -0.475     0.200
    48.069     0.011     0.200
    48.069    -0.223     0.200
    48.119    -0.355     0.200
    48.378     0.715     0.200
    48.569     0.557     0.200
    48.593     0.067     0.200
    48.797     0.503     0.200
    48.922     0.457     0.200
    48.930     0.192     0.200
    48.956     1.463     0.200
    48.974     0.076     0.200
    49.144    -0.652     0.200
    49.144    -1.136     0.200
    49.235     0.111     0.200
    49.553    -0.463     0.200
    49.825     0.666     0.200
    49.985     0.721     0.200
    51.692    -0.379     0.200
    52.099    -0.701     0.200
    53.312    -0.606     0.200
    55.582    -0.222     0.200
    57.179    -0.992     0.200
    58.644    -0.590     0.200
    58.964    -1.362     0.200
    59.510    -1.085     0.200
    59.510    -0.578     0.200
    60.464    -0.010     0.200
    62.466    -0.578     0.200
    64.203    -2.041     0.200
    64.472     0.199     0.200
    64.642    -1.011     0.200
    64.739    -1.222     0.200
    64.850    -2.602     0.200
    65.402    -0.372     0.200
    65.525     0.367     0.200
    66.550    -1.014     0.200
    67.540     0.305     0.200
    68.421     0.202     0.200
    68.421     0.483     0.200
    68.446    -1.477     0.200
    68.607    -0.046     0.200
    69.302     0.649     0.200
    69.583     1.677     0.200
    69.799    -1.053     0.200
    69.799    -1.171     0.200
    70.130     0.570     0.200
    70.894    -1.165     0.200
    71.615     1.493     0.200
    71.769     0.721     0.200
    73.119     0.602     0.200
    73.381    -1.590     0.200
    73.992    -0.490     0.200
    74.431    -1.052     0.200
    74.468    -0.423     0.200
    74.512     0.973     0.200
    74.759     0.345     0.200
    74.888    -0.314     0.200
    74.890     0.380     0.200
    75.044     0.097     0.200
    75.277    -1.310     0.200
    75.322    -0.867     0.200
    75.346    -0.005     0.200
    75.354     0.247     0.200
    75.509     0.759     0.200
    75.702     0.153     0.200
    75.752     0.570     0.200
    75.775    -0.658     0.200
    76.158    -0.239     0.200
    76.262     0.141     0.200
    76.262    -0.031     0.200
    76.285    -0.413     0.200
    76.286    -0.609     0.200
    76.317     0.361     0.200
    76.390    -0.451     0.200
    76.394     0.958     0.200
    76.609    -0.359     0.200
    76.624     1.124     0.200
    76.637     0.152     0.200
    76.641     0.326     0.200
    76.696    -0.586     0.200
    77.129    -0.714     0.200
    77.133    -0.411     0.200
    77.175    -0.076     0.200
    77.620    -0.164     0.200
    78.176    -0.445     0.200
    78.210    -0.132     0.200
    78.683    -0.147     0.200
    78.868    -0.598     0.200
    78.940    -0.053     0.200
    79.106    -0.057     0.200
    79.106    -0.057     0.200
    79.431     0.171     0.200
    79.634     0.368     0.200
    79.648    -0.109     0.200
    79.672     0.366     0.200
    79.726     0.634     0.200
    79.922    -0.644     0.200
    80.091    -0.104     0.200
    80.137     0.648     0.200
    80.243     0.375     0.200
    80.271     1.725     0.200
    80.350    -0.198     0.200
    80.810    -0.537     0.200
    80.876    -0.655     0.200
    80.923    -0.058     0.200
    80.946    -0.394     0.200
    80.959     0.248     0.200
    80.961    -0.862     0.200
    80.991    -1.026     0.200
    81.095     0.023     0.200
    81.158    -0.015     0.200
    81.195    -0.804     0.200
    81.290    -0.712     0.200
    81.591    -0.398     0.200
    81.604     0.035     0.200
    82.017     0.455     0.200
    82.028    -0.156     0.200
    82.096     0.448     0.200
    82.247    -0.945     0.200
    82.261    -0.717     0.200
    82.272    -0.379     0.200
    82.579     0.531     0.200
    82.781     0.889     0.200
    83.064    -0.587     0.200
    83.213    -0.851     0.200
    83.304     1.083     0.200
    83.426    -0.049     0.200
    83.452     1.236     0.200
    83.550    -0.493     0.200
    83.742    -0.670     0.200
    83.778    -0.850     0.200
    83.823    -0.885     0.200
    84.040    -0.587     0.200
    84.123     1.101     0.200
    84.142    -0.104     0.200
    84.224    -0.622     0.200
    84.261     0.090     0.200
    84.270     0.247     0.200
    84.292    -0.570     0.200
    84.328    -0.455     0.200
    84.700    -0.525     0.200
    84.833    -0.296     0.200
    84.871     1.574     0.200
    84.923    -0.547     0.200
    84.958    -0.023     0.200
    85.055     1.702     0.200
    85.083    -0.048     0.200
    85.146    -0.262     0.200
    85.310    -0.386     0.200
    85.415    -1.005     0.200
    85.566    -0.057     0.200
    85.613     0.014     0.200
    85.970    -0.955     0.200
    85.943     0.652     0.200
    86.006    -0.035     0.200
    86.216    -0.567     0.200
    86.242    -0.002     0.200
    86.397     0.543     0.200
    86.532     0.178     0.200
    86.819     0.379     0.200
    87.745     0.310     0.200
    88.651    -0.170     0.200
    89.063     0.690     0.200
    89.084     0.392     0.200
    93.066    -0.357     0.200
    17.917    -1.043     0.200
    19.658    -0.657     0.200
    21.314    -1.892     0.200
    21.314    -3.943     0.200
    21.357    -2.160     0.200
    22.189     1.972     0.200
    24.029    -4.280     0.200
    25.904     0.294     0.200
    25.904    -0.155     0.200
    26.347     0.197     0.200
    28.381    -0.317     0.200
    28.658    -2.478     0.200
    29.472    -0.010     0.200
    29.853    -0.768     0.200
    32.629     0.909     0.200
    33.318     0.199     0.200
    39.542    -0.119     0.200
    40.331    -1.650     0.200
    42.373    -0.482     0.200
    42.638    -0.335     0.200
    42.638    -0.366     0.200
    43.273     1.838     0.200
    43.559     1.033     0.200
    43.891    -0.231     0.200
    43.891    -0.508     0.200
    43.952     1.082     0.200
    44.371     0.082     0.200
    47.881    -0.148     0.200
    48.041     0.920     0.200
    48.129     0.137     0.200
    48.129     0.101     0.200
    48.135     0.898     0.200
    48.180    -0.049     0.200
    48.448     0.787     0.200
    48.645     0.576     0.200
    48.669     0.391     0.200
    48.872     0.926     0.200
    48.947     0.061     0.200
    49.005     0.514     0.200
    49.111    -0.096     0.200
    49.900     0.896     0.200
    53.366    -0.451     0.200
    55.643     0.041     0.200
    56.217    -0.339     0.200
    56.217    -0.335     0.200
    58.607    -0.182     0.200
    58.995    -1.771     0.200
    59.541    -1.112     0.200
    61.954    -0.830     0.200
    62.464     0.957     0.200
    62.474    -0.046     0.200
    64.241    -1.385     0.200
    64.691    -0.622     0.200
    64.778    -0.998     0.200
    66.201     0.977     0.200
    67.599    -0.054     0.200
    69.832    -0.843     0.200
    69.832    -0.792     0.200
    70.827     1.092     0.200
    70.943    -0.646     0.200
    73.066     1.177     0.200
    75.391     0.352     0.200
    75.400     0.900     0.200
    76.344     0.716     0.200
    76.344     0.425     0.200
    76.684     0.605     0.200
    77.169    -0.122     0.200
    77.662     0.424     0.200
    78.725     0.546     0.200
    78.910     0.196     0.200
    81.630    -0.781     0.200
    82.069     0.608     0.200
    83.589    -0.465     0.200
    83.779    -1.037     0.200
    83.856    -0.731     0.200
    84.077    -0.754     0.200
    84.257    -1.070     0.200
    84.310    -0.134     0.200
    84.330    -0.836     0.200
    84.365    -0.714     0.200
    84.964    -0.330     0.200
    84.989    -0.456     0.200
    85.122    -0.323     0.200
    85.342    -0.718     0.200
    85.457    -1.291     0.200
    85.605    -0.424     0.200
    86.257    -0.946     0.200
    86.279    -0.156     0.200
    86.434     0.184     0.200
    86.570    -0.185     0.200
    86.855     0.026     0.200
    87.783    -0.043     0.200
    88.688    -0.621     0.200
    89.099     0.344     0.200
    89.119     0.053     0.200
    17.963    -1.748     0.200
    20.286    -2.631     0.200
    20.297    -1.733     0.200
    20.691    -0.301     0.200
    20.890    -2.642     0.200
    21.305    -2.520     0.200
    21.305    -3.098     0.200
    21.402    -3.031     0.200
    21.714     0.722     0.200
    22.119     0.518     0.200
    22.776     1.068     0.200
    22.776    -0.111     0.200
    23.492    -1.048     0.200
    23.981    -3.407     0.200
    25.736    -1.254     0.200
    25.819    -1.219     0.200
    26.263     0.163     0.200
    27.789    -1.109     0.200
    27.881    -0.527     0.200
    28.130    -1.353     0.200
    28.303    -0.087     0.200
    28.713    -0.992     0.200
    29.366    -0.999     0.200
    29.779     0.026     0.200
    30.251    -4.750     0.200
    32.530     0.510     0.200
    33.212    -0.742     0.200
    33.595    -0.376     0.200
    36.392    -2.048     0.200
    37.212     0.592     0.200
    39.474    -0.326     0.200
    39.789     0.079     0.200
    40.265    -1.669     0.200
    42.464    -0.451     0.200
    42.557    -0.253     0.200
    43.169     1.721     0.200
    43.640    -1.106     0.200
    43.818    -0.601     0.200
    44.031    -0.097     0.200
    44.099    -1.437     0.200
    44.450    -0.455     0.200
    47.738    -0.644     0.200
    47.937     0.570     0.200
    48.031     0.650     0.200
    48.064    -0.116     0.200
    48.114    -0.154     0.200
    48.198     0.306     0.200
    48.363     0.702     0.200
    48.541     0.418     0.200
    48.565     0.234     0.200
    48.769     0.271     0.200
    48.881    -0.198     0.200
    48.902     0.152     0.200
    48.907     0.428     0.200
    48.940     1.189     0.200
    48.960     0.121     0.200
    49.220     0.113     0.200
    49.364     1.524     0.200
    49.692     0.083     0.200
    49.797     0.531     0.200
    52.589     0.249     0.200
    53.312    -1.216     0.200
    53.312    -0.794     0.200
    56.153    -0.209     0.200
    56.153    -0.216     0.200
    57.213    -1.744     0.200
    58.642    -2.174     0.200
    58.682    -0.445     0.200
    59.525    -0.618     0.200
    59.662     0.591     0.200
    60.001    -1.638     0.200
    60.645    -1.926     0.200
    61.924    -0.670     0.200
    62.138    -2.124     0.200
    62.424    -0.542     0.200
    62.433    -0.174     0.200
    62.434     0.029     0.200
    63.787    -1.643     0.200
    64.213    -2.142     0.200
    64.646    -2.163     0.200
    64.749    -1.164     0.200
    65.429    -0.417     0.200
    66.161     0.652     0.200
    68.416     0.212     0.200
    68.416     0.892     0.200
    68.440    -1.062     0.200
    68.655    -0.400     0.200
    68.775    -0.837     0.200
    69.575     1.706     0.200
    69.813    -1.164     0.200
    69.813    -0.984     0.200
    69.954    -0.083     0.200
    70.066    -1.839     0.200
    70.926    -0.001     0.200
    70.898    -0.851     0.200
    73.159     0.051     0.200
    73.159     0.753     0.200
    73.815    -1.282     0.200
    74.470    -0.438     0.200
    74.454    -0.696     0.200
    74.505     1.006     0.200
    74.570     0.654     0.200
    74.619    -0.370     0.200
    74.744    -0.361     0.200
    74.874    -0.648     0.200
    74.875    -0.335     0.200
    74.945    -0.151     0.200
    75.353     0.143     0.200
    76.270     0.516     0.200
    76.270     0.118     0.200
    76.282    -0.213     0.200
    76.282     0.348     0.200
    76.616    -0.189     0.200
    76.645     0.192     0.200
    76.649     0.172     0.200
    77.138    -0.876     0.200
    77.629     0.385     0.200
    78.086    -0.548     0.200
    78.186    -0.513     0.200
    78.219     0.006     0.200
    78.692     0.106     0.200
    78.692     0.301     0.200
    78.876    -0.273     0.200
    79.116     0.480     0.200
    79.116     0.480     0.200
    79.956    -0.311     0.200
    81.205    -0.946     0.200
    81.602    -0.463     0.200
    83.754    -0.634     0.200
    83.836    -0.454     0.200
    84.052    -0.551     0.200
    84.304    -0.431     0.200
    84.340    -0.410     0.200
    84.763    -1.149     0.200
    84.933    -0.397     0.200
    85.092     0.101     0.200
    85.576    -0.004     0.200
    85.626     0.047     0.200
    86.225    -0.709     0.200
    86.254     0.044     0.200
    86.408     0.584     0.200
    86.542     0.232     0.200
    86.831     0.519     0.200
    88.663     0.078     0.200
    89.075     0.039     0.200
    93.079    -0.213     0.200
    21.325    -4.819     0.200
    26.290     0.135     0.200
    28.331    -1.501     0.200
    39.501     0.260     0.200
    42.584    -0.066     0.200
    48.091    -0.052     0.200
    48.908    -0.399     0.200
    49.183    -1.173     0.200
    49.183    -1.298     0.200
    59.547    -1.064     0.200
    61.948    -1.853     0.200
    64.773    -1.193     0.200
    69.827    -0.812     0.200
    69.835    -1.232     0.200
    69.835    -0.955     0.200
    70.923    -1.370     0.200
    24.798     1.285     0.200
    26.308    -0.120     0.200
    42.602    -0.374     0.200
    47.778    -0.812     0.200
    48.155    -0.121     0.200
    48.922    -0.117     0.200
    49.165    -0.275     0.200
    53.349    -0.896     0.200
    61.953    -2.208     0.200
    64.241    -1.870     0.200
    64.778    -1.348     0.200
    69.838    -0.572     0.200
    69.838    -1.470     0.200
    70.932    -1.170     0.200
    17.827    -1.621     0.200
    19.738    -1.744     0.200
    20.411    -1.640     0.200
    20.422    -1.861     0.200
    21.239    -2.361     0.200
    21.239    -2.811     0.200
    21.268    -2.168     0.200
    21.874     0.161     0.200
    25.891    -0.354     0.200
    26.334    -0.342     0.200
    28.179    -0.685     0.200
    28.360    -0.692     0.200
    28.568    -1.347     0.200
    30.162    -3.167     0.200
    32.640     0.552     0.200
    34.750    -0.878     0.200
    39.509    -0.031     0.200
    39.869     0.405     0.200
    40.296    -0.928     0.200
    42.295    -0.012     0.200
    42.621    -0.556     0.200
    42.621    -0.232     0.200
    43.297     1.375     0.200
    43.297     1.574     0.200
    43.867     0.598     0.200
    46.720    -1.113     0.200
    47.766    -0.622     0.200
    48.064     0.776     0.200
    48.145    -0.448     0.200
    48.157     0.759     0.200
    48.667     0.441     0.200
    48.691     0.350     0.200
    48.895     0.592     0.200
    48.912    -0.338     0.200
    49.026     0.087     0.200
    49.291    -1.135     0.200
    49.921     0.678     0.200
    53.321    -0.587     0.200
    53.321    -0.927     0.200
    59.470    -1.814     0.200
    61.890    -1.871     0.200
    62.562    -0.634     0.200
    62.563    -0.713     0.200
    64.177    -2.527     0.200
    64.714    -1.637     0.200
    64.714    -1.036     0.200
    66.290     0.591     0.200
    68.444     1.081     0.200
    68.444     0.800     0.200
    69.762    -1.181     0.200
    69.762    -1.079     0.200
    70.758     1.714     0.200
    70.891    -1.095     0.200
    72.989     0.068     0.200
    75.334     0.119     0.200
    76.306    -0.077     0.200
    77.106    -0.237     0.200
    78.665     0.613     0.200
    78.850    -0.814     0.200
    83.742    -1.010     0.200
    83.787    -0.545     0.200
    84.188     0.018     0.200
    84.264    -0.572     0.200
    84.299    -0.546     0.200
    85.541    -0.174     0.200
    85.579    -0.064     0.200
    85.813     0.724     0.200
    86.212     0.005     0.200
    86.368     0.439     0.200
    87.718     0.300     0.200
    89.033     0.492     0.200
    17.933    -1.447     0.200
    17.933    -2.346     0.200
    18.643    -0.441     0.200
    19.632    -1.756     0.200
    20.366    -2.018     0.200
    20.377    -1.937     0.200
    20.768     0.440     0.200
    20.971    -2.744     0.200
    21.318    -3.168     0.200
    21.318    -4.070     0.200
    21.374    -2.670     0.200
    22.177    -1.132     0.200
    23.570     0.117     0.200
    24.023    -3.613     0.200
    25.816    -1.204     0.200
    25.887    -0.025     0.200
    25.887    -0.158     0.200
    26.331    -0.075     0.200
    27.849    -2.174     0.200
    27.962    -1.783     0.200
    28.191     0.220     0.200
    28.191    -0.026     0.200
    28.367    -0.286     0.200
    28.677    -0.946     0.200
    29.839     0.052     0.200
    30.252    -0.592     0.200
    30.848     0.451     0.200
    32.607     0.494     0.200
    33.293    -0.789     0.200
    36.468    -0.144     0.200
    37.292     0.758     0.200
    39.530     0.017     0.200
    39.859    -0.166     0.200
    40.320    -0.780     0.200
    40.616     1.237     0.200
    42.398    -0.637     0.200
    42.623    -0.428     0.200
    42.623    -0.428     0.200
    42.623    -0.229     0.200
    43.249     1.708     0.200
    43.277    -0.020     0.200
    43.583    -1.284     0.200
    43.685    -1.205     0.200
    43.975    -0.631     0.200
    43.975    -0.061     0.200
    44.020     1.226     0.200
    44.020     0.612     0.200
    44.967     0.158     0.200
    46.828    -0.920     0.200
    47.715    -0.681     0.200
    47.791    -0.586     0.200
    48.017     0.873     0.200
    48.111     0.747     0.200
    48.169     0.133     0.200
    48.169    -0.297     0.200
    48.267     0.294     0.200
    48.431     0.704     0.200
    48.621     0.623     0.200
    48.645     0.438     0.200
    48.849     0.676     0.200
    48.936    -0.092     0.200
    48.967    -0.064     0.200
    48.975     0.522     0.200
    48.981     0.359     0.200
    49.027    -0.022     0.200
    49.125    -1.238     0.200
    49.288     0.951     0.200
    49.288    -1.045     0.200
    49.444     1.036     0.200
    49.606     1.792     0.200
    49.877     0.640     0.200
    50.037     0.941     0.200
    50.167     1.107     0.200
    50.432     0.540     0.200
    53.189    -0.891     0.200
    53.358    -0.633     0.200
    53.729     1.317     0.200
    54.089    -2.276     0.200
    54.774    -1.248     0.200
    56.023     0.507     0.200
    57.031    -0.274     0.200
    57.073    -1.010     0.200
    57.180    -1.558     0.200
    57.211    -0.654     0.200
    57.476    -0.823     0.200
    58.630    -0.590     0.200
    58.997    -1.638     0.200
    59.543    -1.257     0.200
    59.742    -0.776     0.200
    60.640    -1.210     0.200
    61.953    -2.381     0.200
    62.266     1.255     0.200
    62.223     0.308     0.200
    62.381     1.463     0.200
    62.536    -1.682     0.200
    62.459    -0.681     0.200
    62.601     0.673     0.200
    62.657     0.030     0.200
    62.680     1.319     0.200
    62.782     0.871     0.200
    62.908     0.725     0.200
    62.978    -0.263     0.200
    63.050    -0.540     0.200
    63.282     0.937     0.200
    63.327     0.949     0.200
    63.760     0.846     0.200
    63.826    -2.024     0.200
    63.909     0.916     0.200
    63.928     0.980     0.200
    64.083     0.478     0.200
    64.240    -1.638     0.200
    64.234    -0.034     0.200
    64.295     1.101     0.200
    64.381     0.790     0.200
    64.401     1.180     0.200
    64.451    -0.213     0.200
    64.569     0.606     0.200
    64.685    -1.044     0.200
    64.696     1.218     0.200
    64.777    -1.242     0.200
    64.738     0.109     0.200
    64.758     0.716     0.200
    64.840     0.720     0.200
    64.829     0.507     0.200
    64.829     0.121     0.200
    64.852     0.829     0.200
    64.939     0.503     0.200
    64.942     0.249     0.200
    65.005     0.649     0.200
    65.152     0.423     0.200
    65.233     0.156     0.200
    65.335     0.601     0.200
    65.417    -0.060     0.200
    65.489     1.423     0.200
    65.498     0.485     0.200
    65.568     0.244     0.200
    65.664     0.058     0.200
    65.799     0.786     0.200
    65.802     0.980     0.200
    65.847    -0.662     0.200
    65.869     0.436     0.200
    65.878     0.574     0.200
    65.984     0.907     0.200
    66.059     1.204     0.200
    66.131     0.343     0.200
    66.164     0.872     0.200
    66.257     0.844     0.200
    66.184     0.174     0.200
    66.185     0.415     0.200
    66.186     0.159     0.200
    66.277     0.883     0.200
    66.341    -0.471     0.200
    66.336     0.571     0.200
    66.397    -1.179     0.200
    66.526    -0.023     0.200
    66.589    -1.616     0.200
    66.660     0.078     0.200
    66.664     0.741     0.200
    66.668     0.537     0.200
    66.716     0.635     0.200
    66.711     0.480     0.200
    66.791     0.390     0.200
    66.818     0.753     0.200
    66.842     1.424     0.200
    66.884     0.324     0.200
    67.000     0.216     0.200
    67.036     1.369     0.200
    67.105     0.200     0.200
    67.117    -2.049     0.200
    67.205     0.310     0.200
    67.215     0.161     0.200
    67.310     0.685     0.200
    67.368    -0.451     0.200
    67.392     0.469     0.200
    67.508    -0.627     0.200
    67.597     0.888     0.200
    67.639     0.505     0.200
    67.655    -0.234     0.200
    67.700     0.129     0.200
    67.746     0.192     0.200
    67.992     0.629     0.200
    68.009    -0.697     0.200
    68.027    -0.318     0.200
    68.076     0.480     0.200
    68.122    -0.070     0.200
    68.155     0.343     0.200
    68.202     0.433     0.200
    68.274     0.397     0.200
    68.312     0.691     0.200
    68.395    -0.322     0.200
    68.470     0.843     0.200
    68.495    -0.336     0.200
    68.490    -0.670     0.200
    68.489    -1.060     0.200
    68.494    -0.413     0.200
    68.537    -0.622     0.200
    68.582     0.375     0.200
    68.702     1.099     0.200
    68.710     1.047     0.200
    68.903     0.198     0.200
    69.031     0.198     0.200
    69.157     0.977     0.200
    69.424     1.232     0.200
    69.425     0.660     0.200
    69.500    -0.227     0.200
    69.500     0.433     0.200
    69.599     1.174     0.200
    69.833    -1.118     0.200
    69.833    -1.067     0.200
    69.803    -0.733     0.200
    69.819     0.679     0.200
    69.886    -0.503     0.200
    69.891     0.074     0.200
    69.942    -0.126     0.200
    70.094     1.859     0.200
    70.106     1.028     0.200
    70.247     0.972     0.200
    70.373    -0.919     0.200
    70.429    -0.314     0.200
    70.454    -0.531     0.200
    70.534     0.209     0.200
    70.608     0.834     0.200
    70.613     1.166     0.200
    70.800     0.646     0.200
    70.809     0.631     0.200
    70.854     1.602     0.200
    70.880     0.901     0.200
    70.938    -0.931     0.200
    70.946     1.240     0.200
    70.924     0.309     0.200
    70.987     1.597     0.200
    70.971    -1.010     0.200
    71.021     0.012     0.200
    71.030     0.643     0.200
    71.158    -0.790     0.200
    71.261    -1.582     0.200
    71.438     0.627     0.200
    71.533     0.406     0.200
    71.513     0.690     0.200
    71.522     0.755     0.200
    71.599     0.068     0.200
    71.588     1.567     0.200
    71.674     0.874     0.200
    71.721     0.550     0.200
    71.740     0.305     0.200
    71.723     0.520     0.200
    71.742     1.322     0.200
    71.959     0.560     0.200
    72.005     0.531     0.200
    72.136     0.751     0.200
    72.157     0.628     0.200
    72.226     1.008     0.200
    72.251     0.707     0.200
    72.251     0.901     0.200
    72.337     0.932     0.200
    72.495    -0.107     0.200
    72.501    -0.144     0.200
    72.501     0.497     0.200
    72.552     0.759     0.200
    72.657     0.631     0.200
    72.755     1.060     0.200
    72.862     1.484     0.200
    72.976     0.636     0.200
    72.986     1.326     0.200
    73.013     1.056     0.200
    73.092     0.654     0.200
    73.114     1.086     0.200
    73.345     0.662     0.200
    73.560     1.464     0.200
    73.775     0.841     0.200
    73.775     1.330     0.200
    73.893    -0.550     0.200
    73.829     0.550     0.200
    73.928     0.958     0.200
    74.031    -0.358     0.200
    74.234     1.308     0.200
    74.375     1.062     0.200
    74.415    -0.612     0.200
    74.415    -1.499     0.200
    74.430    -0.436     0.200
    74.430     1.417     0.200
    74.607     0.197     0.200
    74.607     0.056     0.200
    74.686    -0.400     0.200
    74.704     1.156     0.200
    74.941    -0.593     0.200
    74.943    -0.330     0.200
    74.985    -0.189     0.200
    74.972     1.516     0.200
    75.015     1.140     0.200
    75.092     1.523     0.200
    75.320     0.091     0.200
    75.388    -0.002     0.200
    75.396     0.249     0.200
    75.556     0.906     0.200
    75.586     1.024     0.200
    75.694    -0.052     0.200
    75.709     1.283     0.200
    75.794     0.473     0.200
    75.944    -0.380     0.200
    76.079     1.159     0.200
    76.081     1.248     0.200
    76.122     1.532     0.200
    76.203    -0.051     0.200
    76.212     1.177     0.200
    76.302     0.087     0.200
    76.302    -0.112     0.200
    76.271     0.503     0.200
    76.334     0.307     0.200
    76.358     0.469     0.200
    76.432    -0.248     0.200
    76.486     1.543     0.200
    76.650    -0.078     0.200
    76.650     0.122     0.200
    76.600     1.573     0.200
    76.669     0.615     0.200
    76.677     0.266     0.200
    76.681     0.443     0.200
    76.640     1.312     0.200
    76.701     0.990     0.200
    76.701     0.529     0.200
    76.739    -0.284     0.200
    76.738     1.474     0.200
    76.948     1.704     0.200
    76.974     0.964     0.200
    77.025     1.373     0.200
    77.120     0.380     0.200
    77.122     0.267     0.200
    77.167    -0.888     0.200
    77.167    -0.490     0.200
    77.172    -0.518     0.200
    77.125     1.924     0.200
    77.212    -1.136     0.200
    77.215     0.346     0.200
    77.353    -0.327     0.200
    77.400    -0.090     0.200
    77.448     1.158     0.200
    77.477     1.023     0.200
    77.660     0.158     0.200
    77.664    -0.262     0.200
    77.689     0.698     0.200
    77.682    -0.663     0.200
    77.765    -0.125     0.200
    78.074     0.762     0.200
    78.095    -0.758     0.200
    78.125    -0.523     0.200
    78.153    -0.679     0.200
    78.215    -0.319     0.200
    78.249     0.093     0.200
    78.391    -0.221     0.200
    78.577    -0.316     0.200
    78.645    -0.992     0.200
    78.720    -0.004     0.200
    78.723     0.180     0.200
    78.802     0.684     0.200
    78.908    -0.220     0.200
    78.979     0.175     0.200
    78.985    -0.756     0.200
    79.050    -1.109     0.200
    79.145    -0.032     0.200
    79.145    -0.032     0.200
    79.472     0.180     0.200
    79.679     0.364     0.200
    79.922    -0.876     0.200
    80.115    -0.081     0.200
    80.132    -0.093     0.200
    80.175    -0.396     0.200
    80.241     0.029     0.200
    80.389    -0.165     0.200
    80.425    -0.230     0.200
    80.466    -0.777     0.200
    80.486     1.076     0.200
    80.567    -0.422     0.200
    80.602    -0.367     0.200
    80.643    -0.469     0.200
    80.646    -0.043     0.200
    80.851    -0.810     0.200
    80.854    -0.943     0.200
    80.917    -0.620     0.200
    80.953    -0.210     0.200
    80.962     0.056     0.200
    80.988    -0.325     0.200
    80.999     0.171     0.200
    81.000     1.412     0.200
    81.135     0.092     0.200
    81.139    -0.722     0.200
    81.162    -1.132     0.200
    81.198     0.151     0.200
    81.231    -0.958     0.200
    81.328    -1.069     0.200
    81.555     0.849     0.200
    81.629    -0.459     0.200
    81.643     0.037     0.200
    81.788    -0.887     0.200
    81.969    -0.580     0.200
    82.285    -1.005     0.200
    82.298    -0.971     0.200
    82.309    -0.328     0.200
    83.588    -0.445     0.200
    83.779    -0.721     0.200
    83.812    -0.890     0.200
    83.857    -0.820     0.200
    84.077    -0.637     0.200
    84.178    -0.453     0.200
    84.258    -0.559     0.200
    84.299     0.035     0.200
    84.308     0.086     0.200
    84.325     0.502     0.200
    84.329    -0.617     0.200
    84.365    -0.399     0.200
    84.717     0.223     0.200
    84.736    -0.374     0.200
    84.867    -0.228     0.200
    84.962    -0.605     0.200
    84.991    -0.051     0.200
    85.121    -0.002     0.200
    85.182    -0.308     0.200
    85.344    -0.414     0.200
    85.398    -0.244     0.200
    85.455    -1.065     0.200
    85.604    -0.106     0.200
    85.648     0.072     0.200
    85.911     1.093     0.200
    86.009    -0.810     0.200
    86.045    -0.289     0.200
    86.255    -0.624     0.200
    86.279     0.059     0.200
    86.434     0.497     0.200
    86.570     0.234     0.200
    86.855     0.438     0.200
    87.200     0.122     0.200
    87.782     0.271     0.200
    88.688    -0.209     0.200
    89.061    -1.641     0.200
    89.100     0.657     0.200
    89.120    -0.038     0.200
    89.692    -1.611     0.200
    89.978    -0.854     0.200
    91.577    -0.910     0.200
    91.961    -0.361     0.200
    92.401    -0.593     0.200
    92.722    -0.472     0.200
    93.102    -0.185     0.200
    93.102    -0.537     0.200
    93.253    -1.222     0.200
    93.292    -0.601     0.200
    94.521    -1.742     0.200
    94.928    -0.810     0.200
    95.162    -3.082     0.200
    95.476    -1.772     0.200
    95.565    -2.622     0.200
    95.789    -0.640     0.200
    19.613     1.035     0.200
    42.196     0.307     0.200
    47.682    -0.038     0.200
    58.573     0.387     0.200
    62.680    -0.089     0.200
    66.407     0.429     0.200
    86.016     2.330     0.200
    17.624     0.241     0.200
    21.328    -3.246     0.200
    25.829    -0.368     0.200
    28.316    -0.468     0.200
    32.535     0.896     0.200
    33.209     1.207     0.200
    39.489    -0.516     0.200
    39.798     1.715     0.200
    42.568    -0.412     0.200
    42.568    -0.815     0.200
    43.831    -0.804     0.200
    47.938     0.764     0.200
    48.032     0.936     0.200
    48.129    -0.214     0.200
    48.542     0.206     0.200
    49.203    -0.254     0.200
    49.203    -0.804     0.200
    49.799     0.313     0.200
    58.702    -0.909     0.200
    59.547    -1.447     0.200
    61.945    -2.241     0.200
    62.410    -0.151     0.200
    64.770    -1.107     0.200
    66.137     0.817     0.200
    68.796    -0.615     0.200
    69.835    -1.732     0.200
    70.917    -1.431     0.200
    76.298     0.211     0.200
    17.764     0.122     0.200
    18.022    -1.096     0.200
    18.022    -0.979     0.200
    19.590    -0.651     0.200
    20.416    -1.921     0.200
    20.427    -2.077     0.200
    21.001    -2.736     0.200
    21.427    -3.099     0.200
    21.427    -4.107     0.200
    21.463    -2.492     0.200
    21.802     0.487     0.200
    23.628    -0.221     0.200
    24.129    -3.994     0.200
    25.108    -0.389     0.200
    25.828     1.265     0.200
    25.970    -0.590     0.200
    26.414    -0.119     0.200
    27.997    -0.510     0.200
    28.284    -0.398     0.200
    28.456    -0.705     0.200
    28.759    -2.586     0.200
    29.932    -0.084     0.200
    30.358    -1.552     0.200
    30.896    -1.192     0.200
    32.669     0.734     0.200
    33.325     0.803     0.200
    33.691    -0.172     0.200
    37.311     0.769     0.200
    39.614    -0.840     0.200
    39.614    -0.855     0.200
    39.628    -0.968     0.200
    39.939     0.248     0.200
    40.419    -0.523     0.200
    40.663    -2.247     0.200
    41.588     0.438     0.200
    42.437    -0.630     0.200
    42.709    -0.795     0.200
    42.709     0.033     0.200
    43.295     2.097     0.200
    43.295     1.573     0.200
    43.972    -0.451     0.200
    44.031     0.785     0.200
    44.031     0.918     0.200
    44.032     0.901     0.200
    45.340     1.168     0.200
    46.886    -0.646     0.200
    47.105     1.207     0.200
    47.612     0.765     0.200
    48.065     0.865     0.200
    48.514     0.341     0.200
    48.514     0.794     0.200
    48.670     0.302     0.200
    49.031    -0.063     0.200
    49.058     0.579     0.200
    49.091     1.397     0.200
    49.112     0.011     0.200
    49.199    -0.468     0.200
    49.199    -0.749     0.200
    49.684     1.054     0.200
    49.843    -0.059     0.200
    49.843     0.402     0.200
    49.927     0.613     0.200
    50.121     0.259     0.200
    52.250    -0.005     0.200
    53.462    -0.516     0.200
    53.462    -1.446     0.200
    54.242    -1.066     0.200
    55.524    -0.006     0.200
    56.056    -0.313     0.200
    57.081    -0.213     0.200
    57.213    -1.717     0.200
    57.269    -0.612     0.200
    57.265    -1.196     0.200
    58.691    -0.331     0.200
    59.653    -0.374     0.200
    59.781     0.201     0.200
    60.744    -1.274     0.200
    62.063    -2.378     0.200
    62.365    -1.098     0.200
    62.366    -0.778     0.200
    62.582    -0.601     0.200
    63.094    -0.892     0.200
    64.350    -2.217     0.200
    64.793    -0.908     0.200
    64.887    -1.138     0.200
    66.093     0.692     0.200
    68.569     0.019     0.200
    68.594    -1.616     0.200
    69.944    -1.261     0.200
    69.944    -1.566     0.200
    70.141     0.951     0.200
    70.874    -0.868     0.200
    71.045    -0.801     0.200
    73.127    -0.132     0.200
    73.127     0.828     0.200
    74.472    -0.718     0.200
    74.515    -1.326     0.200
    74.606    -0.776     0.200
    74.659     1.525     0.200
    74.715     0.619     0.200
    74.715     0.299     0.200
    74.895    -0.584     0.200
    75.025    -1.239     0.200
    75.026    -0.980     0.200
    75.027    -1.251     0.200
    75.428    -1.005     0.200
    75.428    -1.106     0.200
    75.496     0.000     0.200
    75.505     0.656     0.200
    75.916     0.513     0.200
    76.309    -0.325     0.200
    76.467     0.079     0.200
    76.759     0.135     0.200
    76.759     0.331     0.200
    76.787     0.274     0.200
    76.791     0.252     0.200
    76.802     0.788     0.200
    77.230    -0.115     0.200
    77.277    -0.778     0.200
    77.509     0.327     0.200
    77.770    -0.024     0.200
    77.872     0.010     0.200
    77.971    -0.141     0.200
    78.233    -0.197     0.200
    78.833     0.003     0.200
    79.017    -0.306     0.200
    79.255    -0.103     0.200
    79.255    -0.103     0.200
    80.005     0.352     0.200
    81.739    -0.321     0.200
    82.408    -0.625     0.200
    82.419    -0.284     0.200
    83.698    -0.288     0.200
    83.889    -0.560     0.200
    84.187    -0.481     0.200
    84.440    -0.354     0.200
    84.475    -0.338     0.200
    85.072    -0.339     0.200
    85.293    -0.042     0.200
    86.365    -0.543     0.200
    86.544     0.679     0.200
    89.210     0.754     0.200
    18.008    -1.634     0.200
    18.777    -0.745     0.200
    18.828    -0.804     0.200
    18.836    -1.388     0.200
    19.959    -0.386     0.200
    20.784    -1.763     0.200
    20.795    -2.054     0.200
    21.241    -2.882     0.200
    21.170     0.375     0.200
    21.398    -4.928     0.200
    21.398    -3.268     0.200
    21.394    -2.829     0.200
    22.207    -1.991     0.200
    22.850    -1.104     0.200
    24.254    -3.803     0.200
    24.282    -1.363     0.200
    25.177     0.796     0.200
    25.203     0.662     0.200
    25.500    -0.480     0.200
    25.747    -2.996     0.200
    26.247    -0.583     0.200
    26.247     0.456     0.200
    26.232    -1.555     0.200
    26.691    -0.092     0.200
    28.167    -0.505     0.200
    28.385     0.158     0.200
    28.516    -1.163     0.200
    28.516    -0.702     0.200
    28.516     0.723     0.200
    28.704    -0.276     0.200
    30.165     0.384     0.200
    30.268    -5.284     0.200
    31.266     1.670     0.200
    33.013     0.856     0.200
    33.311    -1.326     0.200
    33.716     0.034     0.200
    34.094    -1.240     0.200
    34.511    -0.070     0.200
    35.403    -0.980     0.200
    36.861     1.519     0.200
    37.712     1.004     0.200
    39.818    -0.982     0.200
    39.818    -0.974     0.200
    39.832    -1.037     0.200
    40.112    -0.165     0.200
    40.232     0.450     0.200
    40.302    -0.433     0.200
    40.613    -1.199     0.200
    41.255    -0.876     0.200
    42.062    -0.974     0.200
    42.062    -0.751     0.200
    42.526     2.048     0.200
    42.971    -0.267     0.200
    42.971    -0.157     0.200
    42.971    -0.286     0.200
    42.960    -0.746     0.200
    43.291    -1.004     0.200
    43.250     3.156     0.200
    43.376    -0.526     0.200
    43.445     1.321     0.200
    43.457     1.720     0.200
    43.669     1.720     0.200
    43.583     2.161     0.200
    43.692    -0.528     0.200
    43.732    -0.286     0.200
    44.197    -0.213     0.200
    44.197    -0.642     0.200
    44.319     1.687     0.200
    44.435     1.181     0.200
    44.435     0.994     0.200
    44.435     1.580     0.200
    44.673     1.017     0.200
    45.041    -0.156     0.200
    45.390     0.193     0.200
    45.716     0.020     0.200
    45.745     1.891     0.200
    46.547    -0.939     0.200
    47.595     0.935     0.200
    48.462    -0.166     0.200
    48.462    -0.569     0.200
    48.436     1.127     0.200
    48.529     0.911     0.200
    48.631     0.893     0.200
    48.791     0.707     0.200
    48.791     0.976     0.200
    48.677     1.465     0.200
    49.039     0.604     0.200
    49.064     0.515     0.200
    49.070     0.469     0.200
    49.267     0.760     0.200
    49.372     1.592     0.200
    49.384     0.403     0.200
    49.399     0.357     0.200
    49.484    -0.089     0.200
    49.647    -0.882     0.200
    49.647    -0.632     0.200
    49.647     0.497     0.200
    49.859     1.158     0.200
    49.982     0.628     0.200
    50.117     0.381     0.200
    50.294     0.867     0.200
    50.398     0.716     0.200
    50.398     1.298     0.200
    50.484     1.332     0.200
    50.501     1.578     0.200
    50.501     1.914     0.200
    50.854     0.332     0.200
    51.282     0.885     0.200
    51.473     2.424     0.200
    51.826     1.273     0.200
    51.858     1.037     0.200
    52.096    -0.534     0.200
    52.399    -0.380     0.200
    53.010     0.937     0.200
    53.047     1.561     0.200
    53.047     1.885     0.200
    53.167    -0.647     0.200
    53.219    -0.544     0.200
    53.438     0.969     0.200
    53.611    -1.605     0.200
    53.611    -1.257     0.200
    53.611    -1.105     0.200
    53.587    -0.734     0.200
    53.648     1.104     0.200
    53.850     1.943     0.200
    53.983     2.066     0.200
    54.036     1.464     0.200
    54.498    -0.730     0.200
    54.621    -0.193     0.200
    54.694    -1.790     0.200
    55.655    -2.325     0.200
    55.723    -1.676     0.200
    55.931    -0.388     0.200
    55.757     0.360     0.200
    56.447     1.013     0.200
    57.241    -0.740     0.200
    57.449    -0.224     0.200
    57.494    -1.024     0.200
    58.362    -0.661     0.200
    58.578    -2.355     0.200
    58.945    -2.202     0.200
    59.103    -2.495     0.200
    59.274     0.497     0.200
    59.647    -1.352     0.200
    60.165     0.197     0.200
    60.600    -0.440     0.200
    60.623    -2.426     0.200
    61.017    -1.015     0.200
    61.257    -2.284     0.200
    61.756     0.174     0.200
    61.843     0.368     0.200
    61.911     0.030     0.200
    61.911     0.534     0.200
    62.110    -2.566     0.200
    62.117     0.059     0.200
    62.242     0.001     0.200
    62.173     0.112     0.200
    62.173    -0.400     0.200
    62.312    -0.000     0.200
    62.432     0.207     0.200
    62.409     0.639     0.200
    62.549     0.486     0.200
    62.631    -0.226     0.200
    62.568    -0.527     0.200
    62.568    -0.379     0.200
    62.577    -0.190     0.200
    62.579    -0.164     0.200
    62.846    -0.072     0.200
    62.892     0.024     0.200
    62.956    -1.107     0.200
    62.939     0.528     0.200
    62.976     0.277     0.200
    63.007     0.517     0.200
    63.091     0.761     0.200
    63.291     0.609     0.200
    63.415     0.605     0.200
    63.471    -0.278     0.200
    63.550     0.531     0.200
    63.680     0.987     0.200
    63.596     0.510     0.200
    63.732     0.274     0.200
    63.886     0.354     0.200
    63.904     0.435     0.200
    63.927     0.320     0.200
    64.041    -1.263     0.200
    63.955     0.748     0.200
    64.027     1.052     0.200
    64.130     0.895     0.200
    64.150     1.213     0.200
    64.158     1.065     0.200
    64.220     0.129     0.200
    64.327     0.703     0.200
    64.392     0.484     0.200
    64.395     0.390     0.200
    64.502     0.539     0.200
    64.511     0.682     0.200
    64.580     0.329     0.200
    64.585     1.232     0.200
    64.653     0.796     0.200
    64.688     1.021     0.200
    64.720     0.765     0.200
    64.774     0.555     0.200
    64.806     0.509     0.200
    64.901    -2.270     0.200
    64.901    -1.180     0.200
    64.930    -1.401     0.200
    64.884     0.551     0.200
    64.982    -2.747     0.200
    64.931     0.426     0.200
    64.977     0.533     0.200
    64.976     0.379     0.200
    64.997     0.579     0.200
    65.003     0.559     0.200
    65.138     0.804     0.200
    65.133     0.503     0.200
    65.133     0.963     0.200
    65.153     0.614     0.200
    65.221     0.521     0.200
    65.250     0.280     0.200
    65.273     1.006     0.200
    65.322     0.668     0.200
    65.442     0.478     0.200
    65.461     0.940     0.200
    65.512     0.834     0.200
    65.543     0.950     0.200
    65.635     0.817     0.200
    65.706     0.719     0.200
    65.766     1.097     0.200
    65.794     0.384     0.200
    65.791     1.255     0.200
    65.865     1.102     0.200
    65.903     0.895     0.200
    65.903     1.213     0.200
    65.959     0.844     0.200
    65.979     0.516     0.200
    66.090    -0.954     0.200
    66.026     1.125     0.200
    66.193    -1.618     0.200
    66.194     0.575     0.200
    66.226     0.382     0.200
    66.247     1.087     0.200
    66.289     1.042     0.200
    66.298     1.738     0.200
    66.313     0.197     0.200
    66.308     1.024     0.200
    66.305     0.566     0.200
    66.417     0.812     0.200
    66.423     1.110     0.200
    66.469     1.119     0.200
    66.455     1.058     0.200
    66.508     0.947     0.200
    66.527     1.145     0.200
    66.578     0.635     0.200
    66.571     0.113     0.200
    66.571     0.848     0.200
    66.761    -0.945     0.200
    66.658     1.219     0.200
    66.736     0.510     0.200
    66.736     0.720     0.200
    66.801     0.425     0.200
    66.843     0.109     0.200
    66.844     1.455     0.200
    66.877     0.892     0.200
    66.940     0.866     0.200
    66.951     0.748     0.200
    66.958     0.667     0.200
    67.013     0.678     0.200
    67.012     1.283     0.200
    66.952    -0.188     0.200
    67.091     1.179     0.200
    67.103     0.504     0.200
    67.116     0.578     0.200
    67.140     0.411     0.200
    67.140     1.099     0.200
    67.262     0.878     0.200
    67.300     0.051     0.200
    67.291     0.639     0.200
    67.340     1.185     0.200
    67.352     0.053     0.200
    67.389     0.346     0.200
    67.454     0.882     0.200
    67.579     0.293     0.200
    67.617     1.147     0.200
    67.643     1.311     0.200
    67.645     1.028     0.200
    67.656     1.538     0.200
    67.694     0.752     0.200
    67.713     1.231     0.200
    67.763     1.166     0.200
    67.817     0.371     0.200
    67.805     0.720     0.200
    67.824     0.065     0.200
    67.850    -0.132     0.200
    67.856     0.699     0.200
    67.843     0.193     0.200
    67.731     0.667     0.200
    67.922     0.438     0.200
    67.936     0.337     0.200
    67.966    -0.011     0.200
    68.058    -0.069     0.200
    68.060     0.112     0.200
    68.117     0.628     0.200
    68.126     0.915     0.200
    68.126     1.486     0.200
    68.179    -0.049     0.200
    68.176     0.698     0.200
    68.242     0.459     0.200
    68.319    -0.675     0.200
    68.319    -0.324     0.200
    68.335     0.536     0.200
    68.366     0.293     0.200
    68.477     0.438     0.200
    68.526     0.886     0.200
    68.560     1.104     0.200
    68.618     0.848     0.200
    68.624     0.915     0.200
    68.666     0.466     0.200
    68.670     0.038     0.200
    68.758     1.292     0.200
    68.758     0.863     0.200
    68.758     0.195     0.200
    68.758     1.492     0.200
    68.759    -3.971     0.200
    68.693     0.516     0.200
    68.779     0.712     0.200
    68.826     0.893     0.200
    68.942     0.570     0.200
    69.095    -2.501     0.200
    68.991     0.544     0.200
    68.999     0.155     0.200
    69.049     0.787     0.200
    69.174     0.789     0.200
    69.111     0.774     0.200
    69.144     0.732     0.200
    69.174     0.109     0.200
    69.221     0.820     0.200
    69.291     1.037     0.200
    69.345     1.005     0.200
    69.394     0.701     0.200
    69.436     1.012     0.200
    69.439     0.608     0.200
    69.439     1.018     0.200
    69.478     1.058     0.200
    69.506     0.514     0.200
    69.534     1.109     0.200
    69.578     0.530     0.200
    69.598     0.129     0.200
    69.598     1.067     0.200
    69.650     1.344     0.200
    69.717     1.160     0.200
    69.765     0.424     0.200
    69.773     1.113     0.200
    69.824     1.313     0.200
    69.843     1.165     0.200
    69.948    -1.159     0.200
    69.948    -1.159     0.200
    69.900     0.705     0.200
    70.061     1.446     0.200
    70.089     1.566     0.200
    70.092     1.535     0.200
    70.235     1.682     0.200
    70.301     1.138     0.200
    70.433    -1.677     0.200
    70.368     0.238     0.200
    70.395     1.734     0.200
    70.435     0.799     0.200
    70.479     1.314     0.200
    70.479     1.316     0.200
    70.498     0.938     0.200
    70.544     1.319     0.200
    70.611     1.540     0.200
    70.725     1.006     0.200
    70.739     1.452     0.200
    70.849     1.392     0.200
    70.882     1.567     0.200
    70.899     1.391     0.200
    70.907     1.389     0.200
    70.937     2.047     0.200
    70.995     1.290     0.200
    70.994     1.064     0.200
    71.156    -1.014     0.200
    71.156    -1.194     0.200
    71.168    -1.407     0.200
    71.080     0.996     0.200
    71.200     0.185     0.200
    71.132     0.675     0.200
    71.145     1.628     0.200
    71.244     1.271     0.200
    71.342    -0.750     0.200
    71.253     1.558     0.200
    71.343     1.862     0.200
    71.308     2.084     0.200
    71.335     0.463     0.200
    71.350     1.039     0.200
    71.384     1.005     0.200
    71.448     0.923     0.200
    71.444     1.167     0.200
    71.552    -0.609     0.200
    71.458     1.311     0.200
    71.505     1.289     0.200
    71.584     1.281     0.200
    71.605     0.917     0.200
    71.632    -0.399     0.200
    71.631     1.330     0.200
    71.621     0.766     0.200
    71.643     1.105     0.200
    71.760     1.457     0.200
    71.819     1.069     0.200
    71.855     1.094     0.200
    71.841     0.691     0.200
    71.925     0.983     0.200
    71.860     1.196     0.200
    71.899     0.737     0.200
    71.986     1.165     0.200
    72.039    -0.067     0.200
    71.960     1.207     0.200
    71.973     0.789     0.200
    72.088     0.136     0.200
    71.997     0.825     0.200
    72.015     0.366     0.200
    72.179     0.511     0.200
    72.185     1.145     0.200
    72.402     0.665     0.200
    72.398     1.033     0.200
    72.482     1.147     0.200
    72.534     1.543     0.200
    72.617     0.731     0.200
    72.617     1.278     0.200
    72.608     1.402     0.200
    72.627     1.241     0.200
    72.676     0.154     0.200
    72.676     1.182     0.200
    72.715     0.543     0.200
    72.720     1.340     0.200
    72.748     0.452     0.200
    72.731     0.995     0.200
    72.778     1.006     0.200
    72.900     0.666     0.200
    72.785     1.431     0.200
    72.918     1.137     0.200
    72.968     1.152     0.200
    73.101     1.183     0.200
    73.115     0.932     0.200
    73.131     0.710     0.200
    73.201     0.741     0.200
    73.368     1.060     0.200
    73.394     0.498     0.200
    73.394     1.072     0.200
    73.415     0.761     0.200
    73.542     0.916     0.200
    73.713     1.236     0.200
    73.855     1.275     0.200
    73.969    -1.836     0.200
    73.898     0.958     0.200
    74.099     0.107     0.200
    73.993     0.859     0.200
    73.892     0.617     0.200
    73.892     0.719     0.200
    74.030     0.965     0.200
    74.053     1.997     0.200
    74.056     0.988     0.200
    74.096     1.352     0.200
    74.132    -1.247     0.200
    74.132    -0.809     0.200
    74.138     0.209     0.200
    74.178     1.245     0.200
    74.416     1.564     0.200
    74.443     1.076     0.200
    74.575    -0.164     0.200
    74.520     1.337     0.200
    74.594     1.343     0.200
    74.657     0.634     0.200
    74.786    -0.813     0.200
    74.810     0.180     0.200
    74.810     0.383     0.200
    74.707     0.505     0.200
    74.707     0.767     0.200
    74.744    -0.263     0.200
    74.759     0.143     0.200
    74.744     0.765     0.200
    74.862     0.674     0.200
    74.862     1.584     0.200
    74.775     0.755     0.200
    74.875    -0.724     0.200
    74.888     1.454     0.200
    74.968     1.177     0.200
    75.175     0.720     0.200
    75.200     0.997     0.200
    75.297    -0.362     0.200
    75.300    -0.101     0.200
    75.312     0.801     0.200
    75.333     0.741     0.200
    75.524    -0.125     0.200
    75.454     1.648     0.200
    75.578    -0.235     0.200
    75.595     0.371     0.200
    75.602    -1.124     0.200
    75.786     0.247     0.200
    75.702     1.180     0.200
    75.702     1.062     0.200
    75.834     0.702     0.200
    75.748     1.074     0.200
    75.875    -0.071     0.200
    75.895    -0.048     0.200
    75.831     0.848     0.200
    75.990     0.517     0.200
    75.992    -0.169     0.200
    75.895     1.727     0.200
    76.010    -0.899     0.200
    75.976     0.776     0.200
    76.086    -0.428     0.200
    76.094    -0.177     0.200
    76.103     0.449     0.200
    76.103     1.179     0.200
    76.221     1.048     0.200
    76.357    -0.367     0.200
    76.267     1.299     0.200
    76.434     0.384     0.200
    76.362     1.753     0.200
    76.477     0.031     0.200
    76.477    -0.250     0.200
    76.537    -1.096     0.200
    76.544     0.174     0.200
    76.592    -0.148     0.200
    76.632    -0.425     0.200
    76.645    -0.787     0.200
    76.578     1.359     0.200
    76.578     1.195     0.200
    76.625     0.977     0.200
    76.738    -0.722     0.200
    76.647     1.005     0.200
    76.834    -0.261     0.200
    76.834     0.438     0.200
    76.853     0.131     0.200
    76.750     1.393     0.200
    76.859     0.497     0.200
    76.897     0.741     0.200
    76.954     0.292     0.200
    77.020    -0.927     0.200
    76.943     1.083     0.200
    77.050     1.324     0.200
    77.166    -0.968     0.200
    77.070     0.715     0.200
    77.118     0.332     0.200
    77.118     1.008     0.200
    77.316    -0.067     0.200
    77.320    -0.399     0.200
    77.320     0.613     0.200
    77.329    -0.740     0.200
    77.329    -0.842     0.200
    77.340    -0.739     0.200
    77.340    -0.497     0.200
    77.386     0.145     0.200
    77.281     1.127     0.200
    77.390    -0.327     0.200
    77.429     0.903     0.200
    77.517    -0.392     0.200
    77.347     0.059     0.200
    77.583     0.443     0.200
    77.583     0.544     0.200
    77.623     1.421     0.200
    77.764    -0.346     0.200
    77.748    -0.929     0.200
    77.814    -0.244     0.200
    77.815    -0.443     0.200
    77.721     2.173     0.200
    77.833    -0.047     0.200
    77.986    -0.557     0.200
    78.014    -0.734     0.200
    78.028     0.672     0.200
    78.028     0.167     0.200
    78.051     0.840     0.200
    77.960     1.768     0.200
    78.020     1.521     0.200
    78.165     0.330     0.200
    78.105     1.415     0.200
    78.135     1.404     0.200
    78.258    -0.508     0.200
    78.275     0.040     0.200
    78.288    -0.370     0.200
    78.292    -0.694     0.200
    78.342    -0.111     0.200
    78.342    -0.271     0.200
    78.348    -0.401     0.200
    78.158     0.648     0.200
    78.374    -0.448     0.200
    78.395    -0.357     0.200
    78.413     0.041     0.200
    78.451     0.748     0.200
    78.570     1.722     0.200
    78.570     1.826     0.200
    78.701    -0.660     0.200
    78.633     1.765     0.200
    78.741    -0.465     0.200
    78.696    -0.615     0.200
    78.798    -0.877     0.200
    78.807    -1.488     0.200
    78.886    -0.159     0.200
    78.891    -0.819     0.200
    78.893     0.700     0.200
    78.896    -0.015     0.200
    78.749     0.229     0.200
    78.978     0.435     0.200
    78.916     1.850     0.200
    78.912     1.951     0.200
    78.966     0.840     0.200
    79.082    -0.536     0.200
    79.082    -0.371     0.200
    79.149     0.000     0.200
    79.188    -0.493     0.200
    79.190    -0.924     0.200
    79.220     0.045     0.200
    79.118     2.333     0.200
    79.307     0.040     0.200
    79.307     0.040     0.200
    79.308    -0.467     0.200
    79.343    -0.319     0.200
    79.464    -0.767     0.200
    79.368     1.290     0.200
    79.391     1.434     0.200
    79.465     1.481     0.200
    79.587    -0.268     0.200
    79.675    -0.068     0.200
    79.749    -0.861     0.200
    79.749    -0.662     0.200
    79.709     0.984     0.200
    79.913     1.121     0.200
    79.913     0.649     0.200
    79.803     1.499     0.200
    79.863     1.507     0.200
    79.880     1.020     0.200
    80.196    -1.216     0.200
    80.205     1.348     0.200
    80.314    -0.749     0.200
    80.321    -0.317     0.200
    80.224     1.360     0.200
    80.324    -0.292     0.200
    80.267     1.464     0.200
    80.341     1.146     0.200
    80.557    -0.014     0.200
    80.653    -0.332     0.200
    80.666     0.293     0.200
    80.704    -0.968     0.200
    80.752    -0.099     0.200
    80.686     1.395     0.200
    80.804    -0.533     0.200
    80.808    -1.003     0.200
    80.916    -0.700     0.200
    80.917    -0.327     0.200
    80.925    -0.748     0.200
    81.088    -0.260     0.200
    81.132    -0.782     0.200
    81.134     0.133     0.200
    81.171     0.151     0.200
    81.181    -0.732     0.200
    81.210    -0.914     0.200
    81.215    -0.918     0.200
    81.230     0.860     0.200
    81.305     0.083     0.200
    81.314    -0.065     0.200
    81.329    -0.525     0.200
    81.350    -1.285     0.200
    81.364    -0.911     0.200
    81.369     0.017     0.200
    81.484    -0.343     0.200
    81.484    -0.643     0.200
    81.675    -0.551     0.200
    81.681     0.016     0.200
    81.716     0.034     0.200
    81.780    -0.507     0.200
    81.787     0.649     0.200
    81.809    -0.169     0.200
    81.989    -1.503     0.200
    82.204    -1.448     0.200
    82.306     0.637     0.200
    82.437    -0.946     0.200
    82.447    -0.801     0.200
    82.451    -0.418     0.200
    82.607    -0.926     0.200
    82.648     0.385     0.200
    82.816     0.524     0.200
    83.419    -0.826     0.200
    83.741    -0.378     0.200
    83.912    -0.148     0.200
    83.920    -0.594     0.200
    83.930    -0.945     0.200
    83.952     1.346     0.200
    83.955     1.133     0.200
    83.974    -0.165     0.200
    83.978    -0.983     0.200
    84.007     0.866     0.200
    84.018     0.710     0.200
    84.076     0.217     0.200
    84.096    -0.188     0.200
    84.217    -0.604     0.200
    84.249     0.435     0.200
    84.251     0.424     0.200
    84.376    -0.608     0.200
    84.355    -0.049     0.200
    84.454    -1.100     0.200
    84.459     0.174     0.200
    84.468     0.229     0.200
    84.473    -0.495     0.200
    84.506    -0.462     0.200
    84.523    -0.871     0.200
    84.576    -0.806     0.200
    84.876     0.074     0.200
    84.878    -0.737     0.200
    84.977    -0.135     0.200
    85.038    -1.138     0.200
    85.099    -0.140     0.200
    85.124    -0.473     0.200
    85.139    -0.244     0.200
    85.279    -0.041     0.200
    85.320    -0.245     0.200
    85.368    -0.958     0.200
    85.411    -0.603     0.200
    85.453    -0.509     0.200
    85.512    -1.106     0.200
    85.623    -0.956     0.200
    85.565    -0.365     0.200
    85.631    -1.393     0.200
    85.542     0.849     0.200
    85.685    -1.160     0.200
    85.699    -1.632     0.200
    85.660    -0.239     0.200
    85.754    -1.104     0.200
    85.757    -0.018     0.200
    85.775    -0.004     0.200
    85.920    -1.526     0.200
    85.814     0.554     0.200
    86.148    -0.053     0.200
    86.175    -0.781     0.200
    86.205    -0.031     0.200
    86.262    -0.509     0.200
    86.417     0.127     0.200
    86.421    -0.593     0.200
    86.545    -0.200     0.200
    86.575     0.651     0.200
    86.722     0.234     0.200
    86.772    -0.012     0.200
    86.896    -1.204     0.200
    86.990     0.426     0.200
    86.966     0.146     0.200
    87.259    -0.003     0.200
    87.486    -0.149     0.200
    87.505    -0.851     0.200
    87.577    -0.393     0.200
    87.591    -0.823     0.200
    87.930     0.416     0.200
    87.937    -0.608     0.200
    88.296    -0.517     0.200
    88.490     0.820     0.200
    88.828    -1.022     0.200
    88.829    -0.198     0.200
    89.201     0.066     0.200
    89.236     0.661     0.200
    89.243    -0.145     0.200
    89.252    -0.614     0.200
    89.237    -0.035     0.200
    89.300    -0.600     0.200
    89.140     0.353     0.200
    89.330    -0.150     0.200
    89.431     0.387     0.200
    89.764    -0.269     0.200
    89.814    -0.905     0.200
    90.083    -0.078     0.200
    90.106    -0.657     0.200
    90.260    -1.344     0.200
    90.266    -0.475     0.200
    90.363    -0.311     0.200
    90.431    -1.421     0.200
    90.461    -0.606     0.200
    90.688    -0.747     0.200
    90.911     0.525     0.200
    91.044    -0.409     0.200
    91.489     0.138     0.200
    91.591     0.443     0.200
    91.782     0.486     0.200
    92.400    -0.287     0.200
    92.745    -0.236     0.200
    93.231    -0.038     0.200
    93.397     0.157     0.200
    93.599    -2.071     0.200
    93.716     0.691     0.200
    94.019     0.995     0.200
    94.660     0.007     0.200
    94.803    -1.167     0.200
    94.982    -0.576     0.200
    96.441    -1.159     0.200
    21.376    -2.734     0.200
    21.518    -1.548     0.200
    26.229    -0.764     0.200
    28.115     0.145     0.200
    28.282    -0.738     0.200
    32.464     1.144     0.200
    39.456    -1.434     0.200
    39.469    -1.522     0.200
    42.529    -0.066     0.200
    42.529    -0.416     0.200
    43.805    -0.537     0.200
    44.162    -0.319     0.200
    48.329     0.279     0.200
    49.312    -0.525     0.200
    52.114    -0.034     0.200
    53.326    -0.784     0.200
    57.333    -1.994     0.200
    58.812    -0.390     0.200
    59.042    -1.229     0.200
    59.589    -2.223     0.200
    61.972    -1.688     0.200
    62.321    -0.112     0.200
    64.263    -2.365     0.200
    64.674    -0.950     0.200
    64.798    -1.231     0.200
    66.048     0.468     0.200
    69.874    -1.237     0.200
    69.874    -1.188     0.200
    70.925    -1.253     0.200
    71.053     1.210     0.200
    73.289    -0.172     0.200
    21.310    -3.663     0.200
    21.310    -4.003     0.200
    24.008    -2.842     0.200
    25.794     1.135     0.200
    25.866    -0.229     0.200
    26.309    -0.127     0.200
    28.346    -0.366     0.200
    29.820     0.170     0.200
    32.584     0.637     0.200
    39.498    -0.830     0.200
    39.498    -0.861     0.200
    39.838     2.267     0.200
    40.302    -1.173     0.200
    42.177     1.238     0.200
    42.602    -0.053     0.200
    42.602    -0.003     0.200
    43.226     1.794     0.200
    43.597    -0.163     0.200
    43.858    -0.633     0.200
    43.858    -0.035     0.200
    43.938    -0.695     0.200
    44.236     0.943     0.200
    47.036     0.342     0.200
    47.544     0.694     0.200
    47.994     1.016     0.200
    48.080     0.247     0.200
    48.088     0.492     0.200
    48.151    -0.513     0.200
    48.410     0.441     0.200
    48.598     0.567     0.200
    48.622     0.484     0.200
    48.826     0.721     0.200
    48.958     0.104     0.200
    49.266    -0.090     0.200
    49.266     0.351     0.200
    49.420     0.882     0.200
    49.854     0.384     0.200
    50.016     1.069     0.200
    52.129    -0.095     0.200
    53.342    -0.922     0.200
    56.188    -0.045     0.200
    56.188    -0.025     0.200
    57.186    -1.574     0.200
    58.642    -0.802     0.200
    58.989    -1.397     0.200
    59.535    -2.266     0.200
    61.941    -1.620     0.200
    62.455    -0.457     0.200
    64.229    -1.582     0.200
    66.182     0.474     0.200
    68.452     1.212     0.200
    68.452    -0.276     0.200
    69.817    -1.229     0.200
    69.824    -1.373     0.200
    70.528    -0.577     0.200
    70.873     0.349     0.200
    70.923    -1.376     0.200
    71.358    -2.705     0.200
    73.109     0.861     0.200
    73.109    -0.402     0.200
    74.500    -1.186     0.200
    74.791    -0.882     0.200
    74.920    -1.103     0.200
    74.921    -0.835     0.200
    74.957    -0.296     0.200
    76.317     0.402     0.200
    76.382     1.723     0.200
    76.665     0.133     0.200
    76.669     0.513     0.200
    77.156    -0.326     0.200
    77.156    -0.428     0.200
    77.203     0.110     0.200
    77.387     0.278     0.200
    77.648     0.125     0.200
    78.581    -1.240     0.200
    78.711     0.046     0.200
    78.896    -0.365     0.200
    79.133     0.034     0.200
    79.133     0.034     0.200
    79.950     1.199     0.200
    81.221    -0.900     0.200
    81.618    -0.400     0.200
    82.038     0.390     0.200
    82.055     0.249     0.200
    82.274    -0.942     0.200
    82.287    -0.612     0.200
    82.298    -0.370     0.200
    83.577    -0.385     0.200
    83.768    -0.661     0.200
    83.803    -0.738     0.200
    83.848    -0.367     0.200
    84.066    -0.581     0.200
    84.249    -0.509     0.200
    84.288     0.198     0.200
    84.297     0.249     0.200
    84.319    -0.361     0.200
    84.314    -1.194     0.200
    84.354    -0.342     0.200
    84.726    -0.314     0.200
    84.858    -0.277     0.200
    84.950    -0.641     0.200
    85.109    -0.039     0.200
    85.172    -0.249     0.200
    85.335    -0.464     0.200
    85.592    -0.047     0.200
    85.638     0.027     0.200
    85.930     1.283     0.200
    86.243    -0.557     0.200
    86.423     0.655     0.200
    86.559     0.093     0.200
    87.771     0.430     0.200
    89.089     0.712     0.200
    18.579    -0.157     0.200
    20.336    -2.708     0.200
    20.347    -2.413     0.200
    20.940    -2.517     0.200
    21.317    -5.165     0.200
    21.317    -3.774     0.200
    21.389    -2.734     0.200
    21.762     1.369     0.200
    22.735     3.651     0.200
    23.541    -0.595     0.200
    24.011    -3.480     0.200
    24.738    -1.004     0.200
    25.784    -1.596     0.200
    25.863    -0.813     0.200
    25.863    -0.328     0.200
    26.307    -0.219     0.200
    27.829    -0.473     0.200
    27.931    -0.382     0.200
    28.171    -0.777     0.200
    28.171    -0.105     0.200
    28.345    -0.571     0.200
    28.695    -2.295     0.200
    28.695    -0.678     0.200
    29.819     0.359     0.200
    30.256    -2.604     0.200
    30.818     0.838     0.200
    32.579     0.568     0.200
    33.262    -0.389     0.200
    33.644     0.582     0.200
    34.760    -0.671     0.200
    37.261     0.552     0.200
    39.498    -0.681     0.200
    39.498    -0.462     0.200
    39.835     0.971     0.200
    40.302    -0.698     0.200
    42.426    -0.632     0.200
    42.600    -0.416     0.200
    42.600    -0.213     0.200
    43.219     1.487     0.200
    43.608    -0.126     0.200
    43.858    -0.464     0.200
    43.858     0.052     0.200
    43.858    -0.097     0.200
    43.937    -0.616     0.200
    43.988     0.523     0.200
    43.988     0.820     0.200
    44.000    -0.050     0.200
    44.226     0.805     0.200
    44.226     0.898     0.200
    44.936     0.742     0.200
    46.853    -0.826     0.200
    47.029     1.071     0.200
    47.537     0.623     0.200
    47.838     1.096     0.200
    47.987     0.946     0.200
    48.074     0.576     0.200
    48.081     0.824     0.200
    48.101    -0.132     0.200
    48.151    -0.358     0.200
    48.151     0.322     0.200
    48.407     0.396     0.200
    48.407     0.739     0.200
    48.591     0.592     0.200
    48.615     0.408     0.200
    48.621     0.261     0.200
    48.819     0.649     0.200
    48.944    -0.128     0.200
    48.951     0.459     0.200
    48.952     0.226     0.200
    48.985     1.381     0.200
    49.004     0.038     0.200
    49.156    -1.090     0.200
    49.156    -0.629     0.200
    49.264    -0.246     0.200
    49.264     0.004     0.200
    49.413     1.006     0.200
    49.581     3.728     0.200
    49.736     0.132     0.200
    49.847     0.708     0.200
    50.014     0.499     0.200
    50.014     0.866     0.200
    52.131    -0.237     0.200
    52.239     0.565     0.200
    52.633     1.203     0.200
    52.633     2.149     0.200
    52.999    -0.248     0.200
    53.344    -0.991     0.200
    53.756     0.955     0.200
    53.756     1.228     0.200
    55.702    -0.182     0.200
    56.068     2.606     0.200
    56.833    -1.384     0.200
    57.095    -0.780     0.200
    57.197    -1.878     0.200
    58.653    -0.798     0.200
    58.995    -1.472     0.200
    59.541    -1.037     0.200
    59.712     0.286     0.200
    60.646    -1.500     0.200
    61.946    -1.984     0.200
    62.434    -1.009     0.200
    62.445    -0.922     0.200
    63.815    -1.897     0.200
    64.234    -2.044     0.200
    64.674    -1.245     0.200
    64.684    -1.377     0.200
    64.797     1.282     0.200
    65.426     0.064     0.200
    65.526     0.191     0.200
    65.844    -1.193     0.200
    66.172     0.012     0.200
    66.582    -0.913     0.200
    66.737     1.074     0.200
    68.453     0.441     0.200
    68.453     0.980     0.200
    68.624    -0.184     0.200
    68.750    -0.956     0.200
    69.044    -3.691     0.200
    69.614     0.718     0.200
    69.614     1.289     0.200
    69.830    -1.336     0.200
    69.830    -1.336     0.200
    70.356     0.538     0.200
    70.884     0.928     0.200
    70.919     1.425     0.200
    70.927    -1.127     0.200
    70.927    -1.338     0.200
    70.938    -1.364     0.200
    70.960     1.568     0.200
    71.149    -0.429     0.200
    71.507     0.954     0.200
    71.573     0.757     0.200
    71.694     0.737     0.200
    71.770     2.222     0.200
    72.110     1.104     0.200
    72.225     1.113     0.200
    73.120     0.297     0.200
    73.882    -1.123     0.200
    74.407    -0.623     0.200
    74.439    -1.616     0.200
    74.498    -0.735     0.200
    74.543     0.867     0.200
    74.543     1.430     0.200
    74.597     0.344     0.200
    74.597     0.719     0.200
    74.788    -0.590     0.200
    74.918    -0.758     0.200
    74.919    -0.353     0.200
    74.960    -0.251     0.200
    74.974    -0.205     0.200
    75.309    -0.089     0.200
    75.378     0.116     0.200
    75.386     0.671     0.200
    75.528    -1.844     0.200
    75.541     1.152     0.200
    75.684    -0.233     0.200
    75.735    -0.250     0.200
    75.797    -0.176     0.200
    75.807     0.361     0.200
    75.939     0.017     0.200
    76.294     0.070     0.200
    76.294    -0.704     0.200
    76.318     0.264     0.200
    76.349    -0.414     0.200
    76.657     1.098     0.200
    76.669     0.175     0.200
    76.673     0.451     0.200
    76.728    -0.338     0.200
    77.110    -0.145     0.200
    77.112     0.286     0.200
    77.160    -0.485     0.200
    77.160    -0.587     0.200
    77.165    -0.410     0.200
    77.207     0.151     0.200
    77.227    -0.163     0.200
    77.345    -0.122     0.200
    77.391     0.052     0.200
    77.652    -0.037     0.200
    77.658    -0.263     0.200
    77.654    -0.213     0.200
    77.753     0.034     0.200
    77.853    -0.652     0.200
    78.065     0.478     0.200
    78.065     0.376     0.200
    78.088    -0.456     0.200
    78.208    -0.316     0.200
    78.208    -0.519     0.200
    78.224    -0.208     0.200
    78.242     0.099     0.200
    78.570    -0.413     0.200
    78.713     0.197     0.200
    78.715    -0.111     0.200
    78.831     1.091     0.200
    78.900    -0.523     0.200
    78.900    -0.523     0.200
    78.972    -0.017     0.200
    78.975    -0.574     0.200
    79.138    -0.027     0.200
    79.138    -0.027     0.200
    79.680    -0.476     0.200
    80.123     0.067     0.200
    80.124     0.143     0.200
    80.170    -0.155     0.200
    80.381    -0.056     0.200
    80.478     0.006     0.200
    80.562    -0.331     0.200
    80.639    -0.243     0.200
    80.842    -0.838     0.200
    80.908    -0.599     0.200
    80.934     0.492     0.200
    80.940    -0.447     0.200
    80.954     0.155     0.200
    80.978    -0.831     0.200
    80.987     0.980     0.200
    80.991     0.203     0.200
    80.992    -0.919     0.200
    81.127     0.167     0.200
    81.138     0.250     0.200
    81.153    -1.230     0.200
    81.321    -0.372     0.200
    81.538    -0.206     0.200
    81.542     0.891     0.200
    81.623    -0.463     0.200
    81.636     0.078     0.200
    81.831    -1.530     0.200
    82.279    -0.805     0.200
    82.292    -0.874     0.200
    82.304    -0.332     0.200
    82.518    -0.458     0.200
    83.582    -0.545     0.200
    83.774    -0.728     0.200
    83.808    -0.907     0.200
    83.854    -1.036     0.200
    84.071    -0.645     0.200
    84.255    -0.677     0.200
    84.292     0.039     0.200
    84.302     0.188     0.200
    84.324    -0.526     0.200
    84.359    -0.402     0.200
    84.731    -0.480     0.200
    84.864    -0.044     0.200
    84.955    -0.503     0.200
    84.988    -0.169     0.200
    85.114    -0.198     0.200
    85.177    -0.215     0.200
    85.341    -0.430     0.200
    85.447    -1.062     0.200
    85.597    -0.105     0.200
    85.644     0.063     0.200
    85.941     0.695     0.200
    86.248    -0.715     0.200
    86.274    -0.047     0.200
    86.428     0.592     0.200
    86.563     0.133     0.200
    86.850     0.429     0.200
    87.777     0.371     0.200
    89.095     0.551     0.200
    93.097    -0.806     0.200
    43.928     0.345     0.200
    44.007    -0.291     0.200
    58.616    -0.492     0.200
    62.452    -0.249     0.200
    64.814    -1.071     0.200
    66.178     0.051     0.200
    70.821     1.769     0.200
    73.066     0.664     0.200
    85.880     0.754     0.200
    14.640     2.807     0.200
    23.499     1.332     0.200
    25.829     0.240     0.200
    26.272     0.092     0.200
    32.538     0.975     0.200
    39.472    -0.725     0.200
    39.472    -0.265     0.200
    42.567    -0.195     0.200
    42.567    -0.020     0.200
    43.829    -0.521     0.200
    44.179     0.120     0.200
    48.075    -0.195     0.200
    48.373     0.322     0.200
    53.323    -0.681     0.200
    53.323    -0.810     0.200
    55.587    -0.259     0.200
    56.164    -0.846     0.200
    56.164    -0.850     0.200
    57.223    -1.658     0.200
    57.223    -1.433     0.200
    58.992    -1.593     0.200
    61.937    -2.465     0.200
    62.424    -0.073     0.200
    64.226    -2.333     0.200
    64.762    -1.132     0.200
    69.826    -1.155     0.200
    69.826    -1.231     0.200
    70.910    -1.146     0.200
    70.929     2.192     0.200
    76.294     0.109     0.200
    77.151    -0.672     0.200
    79.921     0.873     0.200
    84.283     0.046     0.200
    84.292     0.200     0.200
    84.352    -0.405     0.200
    85.105    -0.091     0.200
    85.985     1.187     0.200
    85.991    -0.993     0.200
    86.237    -0.605     0.200
    26.402    -0.045     0.200
    32.735     0.688     0.200
    39.535    -0.656     0.200
    42.423    -1.330     0.200
    42.682    -0.788     0.200
    42.682    -0.366     0.200
    43.911    -1.291     0.200
    48.131    -0.261     0.200
    48.181    -0.460     0.200
    48.501     0.472     0.200
    55.649    -1.032     0.200
    61.875    -3.403     0.200
    62.657    -0.560     0.200
    64.698    -1.265     0.200
    66.384     0.005     0.200
    69.733    -1.236     0.200
    69.733    -0.986     0.200
    70.624     0.241     0.200
    70.897    -0.509     0.200
    72.856     0.418     0.200
    85.679     0.955     0.200
    23.508     1.448     0.200
    26.285     0.468     0.200
    39.486    -0.569     0.200
    42.580    -0.426     0.200
    43.842     0.090     0.200
    43.842    -1.039     0.200
    43.921    -0.546     0.200
    44.462    -0.871     0.200
    48.089    -0.443     0.200
    59.552    -0.946     0.200
    62.413    -0.221     0.200
    64.777    -1.318     0.200
    69.840    -1.209     0.200
    85.986     0.887     0.200
    39.671    -0.068     0.200
    42.839    -0.199     0.200
    44.038    -0.155     0.200
    44.055    -0.652     0.200
    62.706     0.047     0.200
    64.769    -0.756     0.200
    66.433     0.565     0.200
    70.460     1.322     0.200
    85.519     1.552     0.200
    20.370     0.165     0.200
    21.298    -3.165     0.200
    21.298    -2.430     0.200
    23.572    -1.845     0.200
    25.882    -0.552     0.200
    26.326     0.144     0.200
    28.360    -0.465     0.200
    28.655    -0.688     0.200
    29.456    -0.341     0.200
    30.852     1.374     0.200
    32.608     0.649     0.200
    33.686     1.256     0.200
    36.483     2.496     0.200
    39.507    -0.909     0.200
    39.507    -0.495     0.200
    39.856     1.234     0.200
    42.617    -0.331     0.200
    42.617    -0.285     0.200
    43.869    -0.705     0.200
    43.869    -0.806     0.200
    43.955    -0.820     0.200
    44.019    -0.100     0.200
    44.269     0.095     0.200
    44.269     1.188     0.200
    44.374    -0.344     0.200
    47.064     0.636     0.200
    47.572     0.789     0.200
    48.108    -0.050     0.200
    48.108     0.348     0.200
    48.115     0.492     0.200
    48.159    -0.188     0.200
    48.426     0.260     0.200
    48.985     0.010     0.200
    49.112    -0.285     0.200
    49.112    -0.918     0.200
    49.446     0.991     0.200
    49.603     2.594     0.200
    49.880     0.590     0.200
    50.186     1.492     0.200
    51.590    -1.382     0.200
    51.739    -0.852     0.200
    52.133     0.187     0.200
    53.346    -1.191     0.200
    53.346    -0.761     0.200
    55.622    -0.268     0.200
    55.622    -0.604     0.200
    56.196    -0.271     0.200
    56.857    -1.103     0.200
    57.158    -1.743     0.200
    58.609    -0.527     0.200
    61.936    -1.680     0.200
    62.481     0.376     0.200
    64.223    -1.237     0.200
    64.760    -1.061     0.200
    67.607    -0.981     0.200
    68.459     0.008     0.200
    68.459    -1.015     0.200
    69.815    -1.314     0.200
    69.815    -1.064     0.200
    70.838     0.568     0.200
    70.924    -0.398     0.200
    74.957    -0.399     0.200
    74.971     0.091     0.200
    76.323    -0.149     0.200
    76.323     0.365     0.200
    77.151    -1.697     0.200
    78.707    -0.034     0.200
    78.892    -0.493     0.200
    81.612    -0.468     0.200
    82.020    -0.319     0.200
    82.268    -0.311     0.200
    83.762    -0.729     0.200
    83.839    -0.228     0.200
    84.240    -0.666     0.200
    84.282    -0.075     0.200
    84.292     0.277     0.200
    84.312    -0.529     0.200
    84.347    -0.404     0.200
    84.719     0.121     0.200
    85.630    -0.134     0.200
    85.894     1.205     0.200
    86.416     0.487     0.200
    86.837     0.327     0.200
    89.082     0.743     0.200
    21.252    -3.237     0.200
    26.263     0.299     0.200
    26.707     0.016     0.200
    28.508     0.795     0.200
    28.508    -0.658     0.200
    39.834    -0.337     0.200
    42.987    -0.665     0.200
    42.987    -0.040     0.200
    42.987    -0.165     0.200
    43.735    -1.293     0.200
    44.115    -0.839     0.200
    44.213    -0.432     0.200
    44.213    -0.870     0.200
    44.679     1.304     0.200
    47.491     0.546     0.200
    47.999     0.009     0.200
    48.478    -0.083     0.200
    48.541     1.039     0.200
    48.889    -0.834     0.200
    49.411    -0.024     0.200
    49.871     1.076     0.200
    50.305     0.684     0.200
    55.948    -0.992     0.200
    57.028    -1.778     0.200
    58.368    -0.443     0.200
    62.557    -0.652     0.200
    62.568     0.004     0.200
    64.918    -0.087     0.200
    64.947    -0.958     0.200
    66.294     0.881     0.200
    68.324     0.595     0.200
    68.324    -0.163     0.200
    69.964    -0.742     0.200
    70.477     2.052     0.200
    85.541     1.263     0.200
    21.307    -3.244     0.200
    21.359    -2.601     0.200
    24.017    -2.920     0.200
    25.888    -0.674     0.200
    26.332     0.178     0.200
    28.190    -1.169     0.200
    28.366    -0.037     0.200
    32.612     0.899     0.200
    34.417     0.003     0.200
    39.514    -1.044     0.200
    39.514    -0.843     0.200
    42.384     0.165     0.200
    42.623    -0.174     0.200
    42.623    -0.274     0.200
    43.876    -0.679     0.200
    43.876    -0.999     0.200
    43.956    -0.340     0.200
    44.269     1.428     0.200
    44.379    -0.854     0.200
    47.067     1.103     0.200
    47.575     0.255     0.200
    48.024     0.580     0.200
    48.111     0.711     0.200
    48.118     0.958     0.200
    48.166    -0.214     0.200
    48.166    -0.924     0.200
    48.432     0.438     0.200
    48.628     0.734     0.200
    48.988     0.172     0.200
    49.449     1.052     0.200
    49.883     0.553     0.200
    50.155     0.697     0.200
    51.745    -0.543     0.200
    52.141    -0.086     0.200
    53.354    -0.633     0.200
    53.354    -1.023     0.200
    55.607    -1.642     0.200
    55.629    -0.254     0.200
    56.203    -0.315     0.200
    57.166    -1.487     0.200
    57.166    -1.242     0.200
    58.614    -0.514     0.200
    60.627    -1.650     0.200
    61.944    -1.551     0.200
    62.473     0.039     0.200
    64.679    -1.729     0.200
    64.769    -1.137     0.200
    65.404    -0.428     0.200
    68.467     0.820     0.200
    68.467     0.020     0.200
    68.488     1.091     0.200
    69.818    -1.288     0.200
    69.824    -1.181     0.200
    69.824    -1.131     0.200
    70.840     1.804     0.200
    70.932    -1.241     0.200
    70.932    -1.440     0.200
    73.078     0.572     0.200
    74.214    -0.939     0.200
    74.965    -0.000     0.200
    74.979    -0.870     0.200
    75.381     0.023     0.200
    76.331     0.009     0.200
    77.159    -0.360     0.200
    77.652     0.286     0.200
    78.715     0.207     0.200
    78.900    -0.332     0.200
    82.029    -0.277     0.200
    82.562    -0.360     0.200
    83.770    -0.688     0.200
    84.249    -0.724     0.200
    84.291    -0.237     0.200
    84.300     0.116     0.200
    84.321    -0.587     0.200
    84.728    -0.540     0.200
    85.113    -0.272     0.200
    85.595    -0.576     0.200
    85.639     0.108     0.200
    85.897     1.253     0.200
    86.425     0.430     0.200
    89.091     0.488     0.200
    19.564     0.438     0.200
    20.268    -1.034     0.200
    21.290    -3.152     0.200
    21.290    -2.261     0.200
    21.396    -2.483     0.200
    21.700     0.064     0.200
    22.785    -0.206     0.200
    23.473    -1.021     0.200
    25.721     1.722     0.200
    25.798    -0.196     0.200
    25.798     0.509     0.200
    26.242    -0.125     0.200
    27.769     0.413     0.200
    27.863    -0.632     0.200
    28.110    -1.327     0.200
    28.110    -0.058     0.200
    28.110     0.429     0.200
    28.283    -0.366     0.200
    28.710    -0.359     0.200
    29.758     0.249     0.200
    30.749    -0.705     0.200
    32.511     0.719     0.200
    33.195    -0.154     0.200
    33.580     0.590     0.200
    36.381     2.183     0.200
    37.196     0.653     0.200
    39.440    -0.494     0.200
    39.769     1.075     0.200
    40.245    -1.372     0.200
    41.720     1.409     0.200
    41.982     1.268     0.200
    42.471    -0.356     0.200
    42.536    -0.437     0.200
    42.536    -0.238     0.200
    43.193    -1.749     0.200
    43.637     1.779     0.200
    43.750     0.369     0.200
    43.797    -0.511     0.200
    43.797    -0.171     0.200
    43.923     1.680     0.200
    43.925     0.162     0.200
    43.925     1.611     0.200
    43.925     1.162     0.200
    44.034    -0.307     0.200
    44.164     0.855     0.200
    44.453    -0.456     0.200
    45.064     1.688     0.200
    45.866     0.041     0.200
    45.866     1.941     0.200
    46.886    -0.633     0.200
    46.961     0.965     0.200
    47.469     1.113     0.200
    48.005     0.363     0.200
    48.043    -0.630     0.200
    48.012     0.807     0.200
    48.094    -0.122     0.200
    48.094    -0.372     0.200
    48.094     0.284     0.200
    48.342     0.565     0.200
    48.523     0.779     0.200
    48.547     0.495     0.200
    48.553     0.048     0.200
    48.750     0.629     0.200
    49.037    -0.062     0.200
    49.183    -0.751     0.200
    49.199    -0.104     0.200
    49.345     0.986     0.200
    49.515     3.190     0.200
    49.778     0.686     0.200
    50.050     1.126     0.200
    50.096     1.787     0.200
    51.658    -0.455     0.200
    52.087     2.258     0.200
    52.951     0.368     0.200
    53.292    -0.742     0.200
    53.292    -0.592     0.200
    55.555    -0.464     0.200
    55.555    -0.224     0.200
    55.668    -0.772     0.200
    55.684    -0.586     0.200
    55.978     1.494     0.200
    56.766    -1.098     0.200
    57.209    -1.417     0.200
    58.684    -0.710     0.200
    58.964    -2.490     0.200
    59.510    -0.741     0.200
    59.644    -0.585     0.200
    59.983    -2.315     0.200
    61.907    -2.458     0.200
    61.962     1.074     0.200
    62.119     1.525     0.200
    62.438    -2.008     0.200
    62.430    -0.388     0.200
    62.441    -0.098     0.200
    62.606     0.671     0.200
    62.727     0.461     0.200
    62.908    -0.039     0.200
    62.975     0.115     0.200
    64.196    -2.331     0.200
    64.627    -0.446     0.200
    64.731    -1.333     0.200
    64.732    -1.301     0.200
    65.420    -0.091     0.200
    65.571     0.834     0.200
    65.571     0.344     0.200
    65.794    -0.898     0.200
    65.884    -0.680     0.200
    66.168     0.402     0.200
    66.291     0.891     0.200
    66.597    -0.470     0.200
    66.802     0.653     0.200
    66.913     0.977     0.200
    67.067     0.837     0.200
    67.086     0.385     0.200
    67.193     1.553     0.200
    67.258     0.086     0.200
    67.287     0.260     0.200
    67.399     1.826     0.200
    67.438     0.194     0.200
    67.470     0.920     0.200
    67.532     1.257     0.200
    67.546     0.847     0.200
    67.668     0.639     0.200
    67.697     0.567     0.200
    67.712    -1.189     0.200
    67.945    -0.626     0.200
    68.114    -1.466     0.200
    68.133     0.953     0.200
    68.154     0.748     0.200
    68.154    -1.137     0.200
    68.227    -0.773     0.200
    68.262    -1.553     0.200
    68.396     0.307     0.200
    68.396     1.106     0.200
    68.396     1.426     0.200
    68.416    -0.620     0.200
    68.468     0.121     0.200
    68.493    -1.280     0.200
    68.544    -0.818     0.200
    68.657     0.178     0.200
    68.657    -0.142     0.200
    68.693    -1.713     0.200
    68.938    -1.462     0.200
    69.001    -3.255     0.200
    69.090    -1.734     0.200
    69.104     0.438     0.200
    69.258    -0.635     0.200
    69.290    -0.567     0.200
    69.309    -0.815     0.200
    69.315    -0.172     0.200
    69.349     0.941     0.200
    69.412    -0.947     0.200
    69.414     0.587     0.200
    69.482    -0.874     0.200
    69.545    -0.850     0.200
    69.557    -1.272     0.200
    69.569     0.840     0.200
    69.591     1.293     0.200
    69.797    -1.073     0.200
    69.797    -1.042     0.200
    69.903     0.679     0.200
    69.994    -1.477     0.200
    70.021    -1.156     0.200
    70.118    -0.160     0.200
    70.176     1.006     0.200
    70.261     2.286     0.200
    70.322    -1.410     0.200
    70.334    -1.418     0.200
    70.445    -1.919     0.200
    70.490    -0.991     0.200
    70.581    -1.421     0.200
    70.616    -0.657     0.200
    70.659    -1.146     0.200
    70.879    -0.874     0.200
    70.891    -1.247     0.200
    70.891    -1.017     0.200
    70.918    -0.940     0.200
    70.936     0.709     0.200
    70.964    -0.199     0.200
    70.986    -0.251     0.200
    71.009    -0.678     0.200
    71.036    -0.558     0.200
    71.086     1.020     0.200
    71.378    -1.373     0.200
    71.406    -1.486     0.200
    71.422    -1.609     0.200
    71.511     2.010     0.200
    71.631     0.263     0.200
    71.662     0.983     0.200
    71.704    -0.678     0.200
    71.728    -2.753     0.200
    71.755    -0.857     0.200
    71.742    -0.234     0.200
    71.816     1.574     0.200
    71.865     1.742     0.200
    71.924     1.059     0.200
    72.585     0.583     0.200
    72.585     0.335     0.200
    72.615    -0.091     0.200
    72.616    -0.166     0.200
    72.747    -0.619     0.200
    72.831     0.707     0.200
    72.854     0.017     0.200
    72.989     0.452     0.200
    72.988     0.744     0.200
    73.054     1.268     0.200
    73.069     1.533     0.200
    73.104     1.335     0.200
    73.166     1.038     0.200
    73.166     0.896     0.200
    73.166     0.598     0.200
    73.513     0.075     0.200
    73.673    -0.433     0.200
    73.669     1.088     0.200
    73.858     0.782     0.200
    73.825     1.079     0.200
    74.318     0.704     0.200
    74.373     0.611     0.200
    74.437    -0.040     0.200
    74.485     1.333     0.200
    74.485     0.634     0.200
    74.473    -0.227     0.200
    74.473    -1.320     0.200
    74.521    -0.813     0.200
    74.912     0.034     0.200
    74.901     0.228     0.200
    74.907     1.777     0.200
    75.078    -0.044     0.200
    75.092     0.524     0.200
    75.092     1.239     0.200
    75.149     0.464     0.200
    75.176    -0.131     0.200
    75.190     0.968     0.200
    75.211     0.542     0.200
    75.264     0.741     0.200
    75.304    -0.292     0.200
    75.335     0.032     0.200
    75.335    -0.427     0.200
    75.639     0.193     0.200
    75.612     0.565     0.200
    75.649     1.430     0.200
    75.682     0.536     0.200
    75.688     0.312     0.200
    75.705     1.047     0.200
    75.751     0.251     0.200
    75.779    -0.026     0.200
    75.866     1.436     0.200
    75.917     0.979     0.200
    75.952    -0.874     0.200
    76.125     1.121     0.200
    76.130    -0.008     0.200
    76.164     1.670     0.200
    76.252    -0.101     0.200
    76.262    -0.253     0.200
    76.262     0.095     0.200
    76.306     0.396     0.200
    76.362    -0.267     0.200
    76.412    -0.445     0.200
    76.544    -0.603     0.200
    76.598     0.944     0.200
    76.598     0.315     0.200
    76.590     0.383     0.200
    76.628     0.678     0.200
    76.631     0.757     0.200
    76.631    -0.032     0.200
    76.598    -0.291     0.200
    76.608    -1.407     0.200
    76.667    -0.047     0.200
    76.856     0.989     0.200
    76.877    -0.382     0.200
    76.947     0.043     0.200
    77.068     0.300     0.200
    77.029     0.657     0.200
    77.121    -0.896     0.200
    77.121    -0.097     0.200
    77.125     0.381     0.200
    77.166    -0.252     0.200
    77.169     0.235     0.200
    77.291     1.774     0.200
    77.362     1.753     0.200
    77.611     0.365     0.200
    77.620     0.316     0.200
    77.799     0.518     0.200
    78.084    -0.393     0.200
    78.112    -0.118     0.200
    78.169    -0.332     0.200
    78.553    -0.086     0.200
    78.600    -0.013     0.200
    78.673     0.887     0.200
    78.674    -0.218     0.200
    78.735    -0.149     0.200
    78.751     0.468     0.200
    78.858    -0.430     0.200
    79.008     0.153     0.200
    79.098     0.858     0.200
    79.068    -0.008     0.200
    79.492     1.255     0.200
    79.616     0.538     0.200
    79.642    -0.402     0.200
    79.660    -0.435     0.200
    79.953    -0.812     0.200
    80.062    -0.400     0.200
    80.080    -0.167     0.200
    80.112     1.055     0.200
    80.319     1.854     0.200
    80.600     0.336     0.200
    80.956    -0.961     0.200
    81.087    -0.917     0.200
    81.110    -1.169     0.200
    81.191    -1.008     0.200
    81.283     0.406     0.200
    81.584    -0.690     0.200
    81.995    -0.548     0.200
    82.008     0.380     0.200
    82.241    -0.535     0.200
    82.255    -1.007     0.200
    82.267    -0.472     0.200
    82.423     0.092     0.200
    82.478    -0.012     0.200
    82.528    -0.835     0.200
    83.544    -0.678     0.200
    83.501     1.721     0.200
    83.737    -0.968     0.200
    83.775    -1.062     0.200
    83.820    -1.192     0.200
    84.035    -0.886     0.200
    84.222    -0.835     0.200
    84.253    -0.195     0.200
    84.262    -0.040     0.200
    84.287    -0.766     0.200
    84.323    -0.648     0.200
    84.695    -0.724     0.200
    84.831    -0.711     0.200
    84.915    -0.733     0.200
    84.956    -0.439     0.200
    85.075    -0.434     0.200
    85.141    -0.362     0.200
    85.309    -0.700     0.200
    85.559    -0.345     0.200
    85.554    -0.806     0.200
    85.609    -0.194     0.200
    85.961    -0.936     0.200
    85.926    -0.588     0.200
    85.992     1.143     0.200
    86.207    -0.850     0.200
    86.392     0.345     0.200
    86.525    -0.110     0.200
    86.814     0.078     0.200
    87.264     0.536     0.200
    87.739     0.018     0.200
    88.646    -0.572     0.200
    89.059     0.389     0.200
    89.079    -1.007     0.200
    93.062    -0.750     0.200
    26.317    -0.050     0.200
    39.516    -0.342     0.200
    42.612    -0.265     0.200
    44.454    -0.283     0.200
    48.119    -0.539     0.200
    56.208    -0.757     0.200
    58.689    -0.353     0.200
    59.028    -1.656     0.200
    59.574    -1.283     0.200
    61.976    -1.845     0.200
    62.406    -0.647     0.200
    64.801    -1.077     0.200
    69.862    -1.582     0.200
    20.280    -1.738     0.200
    21.436    -4.184     0.200
    21.548    -3.987     0.200
    22.885     1.119     0.200
    22.885    -0.470     0.200
    23.486    -1.367     0.200
    24.658    -0.071     0.200
    24.955    -0.976     0.200
    25.669     0.875     0.200
    25.858    -0.340     0.200
    25.858    -0.641     0.200
    25.981    -1.468     0.200
    26.302    -0.249     0.200
    26.439    -1.525     0.200
    28.190    -0.062     0.200
    28.190    -0.262     0.200
    28.356    -0.844     0.200
    29.309    -0.975     0.200
    29.837     0.021     0.200
    30.748     0.780     0.200
    32.531     0.712     0.200
    33.170     1.131     0.200
    33.531     0.884     0.200
    34.414    -0.163     0.200
    36.300     1.035     0.200
    37.152     0.990     0.200
    39.530    -0.881     0.200
    39.530    -0.783     0.200
    39.820    -0.192     0.200
    40.339    -1.684     0.200
    41.716     0.276     0.200
    42.603    -0.420     0.200
    42.603    -0.318     0.200
    42.603    -0.522     0.200
    42.583    -0.858     0.200
    43.064     1.349     0.200
    43.146     2.085     0.200
    43.146     1.488     0.200
    43.130    -1.486     0.200
    43.754     0.687     0.200
    43.879     0.186     0.200
    43.871     0.851     0.200
    43.871     0.953     0.200
    43.958    -0.447     0.200
    43.981     0.670     0.200
    43.981     0.971     0.200
    44.109     1.000     0.200
    44.109     0.848     0.200
    44.583    -0.636     0.200
    45.404     0.641     0.200
    45.790    -1.503     0.200
    45.790     2.098     0.200
    47.477     1.899     0.200
    47.886    -0.769     0.200
    48.136    -0.301     0.200
    48.136    -0.200     0.200
    48.187     0.210     0.200
    48.187    -0.090     0.200
    48.187    -0.462     0.200
    48.235     0.844     0.200
    48.402     0.453     0.200
    48.402     0.676     0.200
    48.946     0.384     0.200
    49.001    -0.143     0.200
    49.259    -0.812     0.200
    49.259    -0.261     0.200
    49.321    -0.883     0.200
    49.536     1.126     0.200
    49.564     3.764     0.200
    49.732    -0.211     0.200
    49.732     0.191     0.200
    49.983     1.435     0.200
    49.983     1.583     0.200
    51.199     1.821     0.200
    51.723    -0.596     0.200
    51.723    -0.697     0.200
    52.187    -0.842     0.200
    53.066    -0.737     0.200
    53.400    -0.789     0.200
    53.400    -0.687     0.200
    55.580    -0.400     0.200
    55.645    -0.470     0.200
    55.645    -0.310     0.200
    55.751    -1.843     0.200
    55.751    -1.632     0.200
    55.823     1.346     0.200
    56.227    -1.226     0.200
    58.818    -0.744     0.200
    58.866    -2.078     0.200
    59.651    -1.302     0.200
    59.651    -1.510     0.200
    62.039    -0.913     0.200
    62.180     1.346     0.200
    62.287    -0.174     0.200
    62.409     0.513     0.200
    62.666     0.102     0.200
    62.973    -0.140     0.200
    63.039    -0.276     0.200
    64.746    -1.090     0.200
    64.864    -1.546     0.200
    64.865    -1.266     0.200
    64.993    -2.657     0.200
    65.574    -0.057     0.200
    65.682     0.347     0.200
    65.904    -0.781     0.200
    66.014     0.411     0.200
    66.340     1.227     0.200
    66.670    -1.380     0.200
    68.266     0.580     0.200
    68.491    -0.161     0.200
    68.491     1.038     0.200
    68.511     0.517     0.200
    68.915    -0.695     0.200
    69.126    -3.105     0.200
    69.362     0.847     0.200
    69.601     0.175     0.200
    69.686     0.133     0.200
    69.812     0.115     0.200
    69.937    -1.209     0.200
    69.937    -1.209     0.200
    70.135     0.031     0.200
    70.204     0.231     0.200
    70.235    -0.173     0.200
    70.454    -0.526     0.200
    70.603     1.188     0.200
    70.697    -0.385     0.200
    70.776    -0.027     0.200
    70.789     0.405     0.200
    70.866    -0.673     0.200
    70.944     0.228     0.200
    70.942     0.293     0.200
    70.997    -1.167     0.200
    71.009    -1.138     0.200
    71.029     1.271     0.200
    71.099     0.877     0.200
    71.125     0.755     0.200
    71.155     0.344     0.200
    71.420     0.777     0.200
    71.466    -0.467     0.200
    71.522     0.237     0.200
    71.536     0.260     0.200
    71.752     0.006     0.200
    72.512     1.527     0.200
    72.950     0.368     0.200
    73.010    -0.197     0.200
    73.036     0.721     0.200
    73.111     0.392     0.200
    73.156     0.770     0.200
    73.160    -0.210     0.200
    73.180     0.341     0.200
    73.275     0.426     0.200
    73.286     0.518     0.200
    73.355     0.432     0.200
    73.442     0.007     0.200
    73.474     0.618     0.200
    73.675     0.630     0.200
    73.894    -0.034     0.200
    73.948     0.822     0.200
    74.009    -0.489     0.200
    74.118    -0.358     0.200
    74.099     0.639     0.200
    74.157     0.828     0.200
    74.404    -0.667     0.200
    74.453     0.142     0.200
    74.496    -0.618     0.200
    74.575     1.630     0.200
    74.674    -0.141     0.200
    74.760     0.156     0.200
    74.783    -0.294     0.200
    74.883    -0.350     0.200
    74.871    -0.123     0.200
    74.915    -0.674     0.200
    74.915     0.067     0.200
    74.890     0.616     0.200
    74.918    -1.069     0.200
    75.030     0.016     0.200
    74.997     0.830     0.200
    75.043     0.129     0.200
    75.176    -0.235     0.200
    75.285     0.398     0.200
    75.299     0.023     0.200
    75.385    -0.836     0.200
    75.416    -0.812     0.200
    75.465     0.408     0.200
    75.761     0.016     0.200
    75.800    -0.112     0.200
    75.871    -0.317     0.200
    75.887     0.295     0.200
    76.255     0.605     0.200
    76.359    -0.067     0.200
    76.360     0.381     0.200
    76.381    -0.109     0.200
    76.368    -0.453     0.200
    76.432    -0.098     0.200
    76.500    -0.481     0.200
    76.722     0.359     0.200
    76.724    -0.749     0.200
    76.729     0.527     0.200
    76.729     1.227     0.200
    76.706     0.950     0.200
    76.756     0.273     0.200
    76.759     0.255     0.200
    76.985     1.200     0.200
    77.192     0.022     0.200
    77.171     0.196     0.200
    77.199     0.915     0.200
    77.252    -0.815     0.200
    77.657     0.758     0.200
    77.740    -0.037     0.200
    77.750     0.967     0.200
    77.830     1.184     0.200
    77.941    -1.504     0.200
    78.040     0.756     0.200
    78.186    -0.812     0.200
    78.334    -0.569     0.200
    78.316    -0.783     0.200
    78.627     0.377     0.200
    78.652    -0.135     0.200
    78.803    -0.110     0.200
    78.803    -0.250     0.200
    78.866     0.641     0.200
    78.858     0.458     0.200
    78.987    -0.517     0.200
    79.375    -0.561     0.200
    79.373    -0.081     0.200
    79.643     0.410     0.200
    79.730     0.339     0.200
    79.721    -0.094     0.200
    79.819    -0.148     0.200
    79.995     1.216     0.200
    80.024     0.789     0.200
    80.020     1.315     0.200
    80.102    -0.473     0.200
    80.186    -0.308     0.200
    80.205    -0.138     0.200
    80.206     0.042     0.200
    80.446     0.107     0.200
    80.452    -0.292     0.200
    80.539    -0.203     0.200
    80.809    -0.573     0.200
    80.816     0.752     0.200
    80.860     1.095     0.200
    80.986     0.050     0.200
    81.058    -0.482     0.200
    81.079     0.105     0.200
    81.216    -0.142     0.200
    81.227    -0.031     0.200
    81.237     0.872     0.200
    81.329     1.152     0.200
    81.338     0.056     0.200
    81.336     0.894     0.200
    81.373    -0.009     0.200
    81.627     0.023     0.200
    81.718    -0.479     0.200
    81.726    -0.021     0.200
    82.129    -0.241     0.200
    82.374    -0.918     0.200
    82.388    -0.792     0.200
    82.402    -0.262     0.200
    83.872    -0.646     0.200
    83.914    -0.861     0.200
    83.959    -0.788     0.200
    84.170    -0.565     0.200
    84.251     1.136     0.200
    84.361    -0.532     0.200
    84.385     0.149     0.200
    84.394     0.302     0.200
    84.359     0.942     0.200
    84.422    -0.436     0.200
    84.384     1.201     0.200
    84.458    -0.320     0.200
    84.465     0.953     0.200
    84.666     0.629     0.200
    84.690     0.986     0.200
    84.830     0.006     0.200
    84.904     0.442     0.200
    84.972    -0.204     0.200
    85.046    -0.578     0.200
    85.097    -0.033     0.200
    85.102     1.089     0.200
    85.143     0.960     0.200
    85.207     0.016     0.200
    85.277    -0.132     0.200
    85.250     0.297     0.200
    85.268     0.420     0.200
    85.309     1.530     0.200
    85.449    -0.390     0.200
    85.536    -0.823     0.200
    85.505     1.304     0.200
    85.536     0.943     0.200
    85.572     0.643     0.200
    85.692     0.007     0.200
    85.654     0.726     0.200
    85.747     0.030     0.200
    85.708     0.977     0.200
    86.045     0.458     0.200
    86.092    -0.871     0.200
    86.130    -0.061     0.200
    86.088     1.247     0.200
    86.125     0.356     0.200
    86.338    -0.581     0.200
    86.373     0.145     0.200
    86.527     0.592     0.200
    86.529     0.683     0.200
    86.539     0.655     0.200
    86.658     0.249     0.200
    86.864     0.652     0.200
    86.950     0.525     0.200
    87.212    -0.153     0.200
    87.873     0.391     0.200
    89.195     0.758     0.200
    93.200     0.074     0.200
    39.480    -0.083     0.200
    42.666    -0.468     0.200
    43.938    -0.127     0.200
    59.276    -1.022     0.200
    61.737    -1.096     0.200
    62.877     0.380     0.200
    64.557    -1.286     0.200
    85.484     1.447     0.200
    21.485    -1.926     0.200
    25.674     0.633     0.200
    38.935     0.162     0.200
    41.979     0.320     0.200
    43.271     0.045     0.200
    43.350    -0.390     0.200
    44.348    -0.896     0.200
    44.768    -0.246     0.200
    47.546     0.122     0.200
    49.442    -0.655     0.200
    55.639    -0.686     0.200
    59.250    -1.401     0.200
    61.577    -1.178     0.200
    62.390    -0.429     0.200
    63.875    -2.268     0.200
    64.407    -0.554     0.200
    69.523    -0.944     0.200
    70.471    -0.657     0.200
    71.409     0.722     0.200
    76.783    -1.179     0.200
    86.452     1.345     0.200
    15.583     2.503     0.200
    19.279    -1.421     0.200
    19.290    -1.142     0.200
    20.884    -1.585     0.200
    20.830    -0.005     0.200
    21.485    -1.461     0.200
    22.480    -2.096     0.200
    23.484    -0.403     0.200
    23.484    -0.883     0.200
    24.850     0.402     0.200
    24.850    -1.498     0.200
    24.830     0.179     0.200
    25.287    -1.197     0.200
    25.293    -0.829     0.200
    27.214     0.308     0.200
    27.367    -0.565     0.200
    29.763     0.309     0.200
    32.678     0.431     0.200
    33.433    -0.168     0.200
    35.596     2.016     0.200
    36.280     0.853     0.200
    38.581     0.169     0.200
    38.581    -0.451     0.200
    38.804     0.279     0.200
    39.051    -1.765     0.200
    39.400    -0.507     0.200
    40.113    -0.897     0.200
    40.892     1.224     0.200
    41.229    -0.712     0.200
    41.602    -0.579     0.200
    41.602    -0.517     0.200
    41.602    -0.397     0.200
    41.602    -0.317     0.200
    42.025     1.823     0.200
    42.166     1.173     0.200
    42.219     1.145     0.200
    42.659    -0.776     0.200
    42.731    -0.260     0.200
    42.748    -0.080     0.200
    42.794    -0.865     0.200
    42.908    -0.656     0.200
    42.929     0.208     0.200
    42.986    -0.517     0.200
    43.037    -0.006     0.200
    43.037     0.794     0.200
    43.084    -0.485     0.200
    43.084    -0.925     0.200
    43.084    -0.260     0.200
    43.279     0.892     0.200
    43.279     0.942     0.200
    43.293     0.269     0.200
    44.129    -0.998     0.200
    44.493    -0.512     0.200
    44.914    -0.810     0.200
    44.913    -0.668     0.200
    44.913    -0.718     0.200
    45.978     0.897     0.200
    46.487     0.894     0.200
    46.569    -0.393     0.200
    46.943    -0.677     0.200
    46.933     0.902     0.200
    47.021     0.508     0.200
    47.025     0.677     0.200
    47.196    -0.757     0.200
    47.196    -0.857     0.200
    47.248    -0.456     0.200
    47.248    -0.746     0.200
    47.339    -1.020     0.200
    47.393     0.742     0.200
    47.535     0.607     0.200
    47.560     0.515     0.200
    47.763     0.636     0.200
    47.895     0.717     0.200
    47.965     1.468     0.200
    47.994     0.444     0.200
    48.250    -0.633     0.200
    48.250     0.657     0.200
    48.250    -0.139     0.200
    48.355     1.060     0.200
    48.546     4.584     0.200
    48.724    -0.180     0.200
    48.998     0.710     0.200
    49.549    -0.702     0.200
    49.549    -1.402     0.200
    49.936     0.854     0.200
    50.721    -0.586     0.200
    50.721    -1.086     0.200
    51.303     0.236     0.200
    52.517    -0.810     0.200
    54.697    -0.495     0.200
    54.697    -0.985     0.200
    55.291    -0.196     0.200
    55.790    -0.684     0.200
    57.345    -1.146     0.200
    58.131    -2.474     0.200
    59.029    -1.200     0.200
    59.029    -1.230     0.200
    59.093    -0.976     0.200
    59.331    -1.918     0.200
    61.012     0.560     0.200
    61.172     0.973     0.200
    61.315    -0.995     0.200
    61.782     0.851     0.200
    62.009     0.268     0.200
    62.424    -0.657     0.200
    63.011     0.885     0.200
    63.063    -2.914     0.200
    63.618    -1.691     0.200
    63.860    -1.586     0.200
    63.920    -0.881     0.200
    64.148    -1.076     0.200
    64.148    -1.076     0.200
    64.663    -0.520     0.200
    64.870    -0.842     0.200
    65.034    -0.669     0.200
    65.051    -1.074     0.200
    65.122    -1.138     0.200
    65.294    -0.957     0.200
    65.336     0.277     0.200
    65.649     0.850     0.200
    66.013    -0.364     0.200
    66.189    -0.645     0.200
    66.146    -0.288     0.200
    66.152     0.061     0.200
    66.152     0.111     0.200
    66.332     0.955     0.200
    66.684    -0.295     0.200
    66.704    -0.020     0.200
    66.814     0.077     0.200
    67.447     0.685     0.200
    67.557     0.163     0.200
    67.566    -1.196     0.200
    67.574     0.252     0.200
    67.587    -0.127     0.200
    67.905     0.465     0.200
    68.191     0.153     0.200
    68.230     0.325     0.200
    68.477     0.382     0.200
    68.679     0.570     0.200
    68.679    -0.282     0.200
    68.740     0.495     0.200
    68.770    -0.376     0.200
    68.770    -0.510     0.200
    68.941     1.088     0.200
    69.101     0.491     0.200
    69.101    -1.439     0.200
    69.292    -1.194     0.200
    69.292    -0.874     0.200
    69.292    -0.894     0.200
    69.389    -0.985     0.200
    69.521     0.342     0.200
    69.923     0.533     0.200
    70.040     0.087     0.200
    70.166    -0.978     0.200
    70.166    -0.978     0.200
    70.144    -0.113     0.200
    70.178    -1.652     0.200
    70.208     0.145     0.200
    70.207     0.511     0.200
    70.258     0.108     0.200
    70.471    -0.044     0.200
    70.616    -0.386     0.200
    70.650     0.167     0.200
    70.691    -0.109     0.200
    70.723    -0.522     0.200
    70.790     0.013     0.200
    70.878     0.188     0.200
    71.027    -0.529     0.200
    71.142    -0.223     0.200
    71.159     0.037     0.200
    71.225     0.128     0.200
    71.360    -0.072     0.200
    71.583     0.155     0.200
    71.595    -0.012     0.200
    71.667     0.932     0.200
    71.683    -0.059     0.200
    71.855     0.469     0.200
    71.986    -0.069     0.200
    72.015     0.091     0.200
    72.148     0.546     0.200
    72.168     0.187     0.200
    72.168     0.266     0.200
    72.241     0.102     0.200
    72.293    -0.346     0.200
    72.440     0.522     0.200
    72.452    -0.348     0.200
    72.458     0.208     0.200
    72.468     0.567     0.200
    72.539     0.091     0.200
    72.540     0.053     0.200
    72.617     0.474     0.200
    72.695     0.876     0.200
    72.799    -0.106     0.200
    72.822     0.110     0.200
    72.849     0.807     0.200
    72.970     0.614     0.200
    73.045     0.378     0.200
    73.146     0.379     0.200
    73.121     0.776     0.200
    73.237     0.508     0.200
    73.344     0.182     0.200
    73.344     0.761     0.200
    73.342     0.185     0.200
    73.397    -1.049     0.200
    73.429     0.062     0.200
    73.437     0.482     0.200
    73.438     0.386     0.200
    73.468     1.086     0.200
    73.578     0.134     0.200
    73.624     1.563     0.200
    73.694     0.774     0.200
    73.725     0.577     0.200
    73.732    -0.169     0.200
    73.732     0.514     0.200
    73.741     0.038     0.200
    73.795    -0.352     0.200
    73.796     0.307     0.200
    73.796     0.307     0.200
    73.803     0.210     0.200
    73.809     0.993     0.200
    73.868     1.032     0.200
    73.868     0.632     0.200
    73.834     0.245     0.200
    73.840     0.132     0.200
    73.917     0.245     0.200
    73.894     0.096     0.200
    73.908    -1.490     0.200
    73.894     0.304     0.200
    73.912    -1.702     0.200
    73.979     1.513     0.200
    74.030     0.365     0.200
    74.074     0.925     0.200
    74.112     0.400     0.200
    74.118     0.763     0.200
    74.137     0.594     0.200
    74.148     0.963     0.200
    74.209    -1.220     0.200
    74.209     0.138     0.200
    74.176     0.189     0.200
    74.210     0.114     0.200
    74.228    -0.173     0.200
    74.268    -0.047     0.200
    74.272     0.035     0.200
    74.281     0.039     0.200
    74.326     0.456     0.200
    74.325     0.260     0.200
    74.313    -0.004     0.200
    74.368     2.426     0.200
    74.465     0.848     0.200
    74.550     0.458     0.200
    74.517     0.181     0.200
    74.521     0.223     0.200
    74.522    -0.011     0.200
    74.577    -0.501     0.200
    74.608     0.801     0.200
    74.666     0.585     0.200
    74.634     0.022     0.200
    74.675    -0.170     0.200
    74.706     0.024     0.200
    74.751     0.887     0.200
    74.767    -0.123     0.200
    74.800     1.005     0.200
    74.792    -0.133     0.200
    74.777     1.228     0.200
    74.777     0.990     0.200
    74.815     0.010     0.200
    74.878     0.095     0.200
    74.922    -0.071     0.200
    74.997     1.267     0.200
    74.974     0.168     0.200
    74.973     0.127     0.200
    75.010    -0.037     0.200
    75.055     0.930     0.200
    75.070     0.344     0.200
    75.109     0.504     0.200
    75.116     0.832     0.200
    75.154    -0.060     0.200
    75.186     0.536     0.200
    75.210     0.943     0.200
    75.232    -0.009     0.200
    75.222     0.606     0.200
    75.252     0.180     0.200
    75.434     0.100     0.200
    75.435     0.148     0.200
    75.438     0.260     0.200
    75.479     0.791     0.200
    75.486     0.202     0.200
    75.487     0.891     0.200
    75.521     0.243     0.200
    75.580    -0.206     0.200
    75.622    -0.024     0.200
    75.622     0.275     0.200
    75.606     0.127     0.200
    75.654     0.190     0.200
    75.654     0.935     0.200
    75.727    -0.226     0.200
    75.730     0.339     0.200
    75.775     0.383     0.200
    75.837    -2.043     0.200
    75.830     0.802     0.200
    75.841     0.280     0.200
    75.874     0.933     0.200
    75.973     0.865     0.200
    75.941    -0.139     0.200
    75.939     0.507     0.200
    75.996     0.837     0.200
    75.996     0.537     0.200
    75.967     0.606     0.200
    76.058     1.686     0.200
    76.013     0.802     0.200
    76.036    -0.374     0.200
    76.045    -0.416     0.200
    76.046    -0.323     0.200
    76.124     1.305     0.200
    76.269     0.617     0.200
    76.296     0.092     0.200
    76.327     0.755     0.200
    76.385     0.927     0.200
    76.389     1.083     0.200
    76.431    -0.546     0.200
    76.477     0.305     0.200
    76.511    -0.097     0.200
    76.511     0.212     0.200
    76.517    -0.624     0.200
    76.517    -0.024     0.200
    76.505    -0.259     0.200
    76.545     0.219     0.200
    76.525     0.771     0.200
    76.535     1.236     0.200
    76.596     0.031     0.200
    76.576     1.306     0.200
    76.703     0.527     0.200
    76.739     0.213     0.200
    76.782     0.505     0.200
    76.796     0.299     0.200
    76.847     0.911     0.200
    76.828     1.153     0.200
    76.906     0.564     0.200
    76.985    -0.266     0.200
    76.985     0.532     0.200
    77.040     0.428     0.200
    77.035     0.272     0.200
    77.044     0.969     0.200
    77.161     0.046     0.200
    77.124     0.390     0.200
    77.191     1.098     0.200
    77.220    -0.329     0.200
    77.216     1.227     0.200
    77.222    -0.292     0.200
    77.232     0.437     0.200
    77.357     0.345     0.200
    77.328     1.006     0.200
    77.350    -0.115     0.200
    77.359     0.370     0.200
    77.518     0.713     0.200
    77.570     0.257     0.200
    77.536     1.171     0.200
    77.614     0.725     0.200
    77.608     1.130     0.200
    77.641     0.969     0.200
    77.845     0.936     0.200
    77.875     0.689     0.200
    77.954     0.035     0.200
    77.950     0.778     0.200
    77.955     0.747     0.200
    78.015    -0.123     0.200
    77.993     0.812     0.200
    78.048    -0.009     0.200
    78.063     0.812     0.200
    78.088     0.658     0.200
    78.051     0.915     0.200
    78.073     0.342     0.200
    78.074     0.259     0.200
    78.175     1.081     0.200
    78.175     1.126     0.200
    78.230    -0.014     0.200
    78.232     1.091     0.200
    78.273     1.086     0.200
    78.448    -0.221     0.200
    78.494     0.721     0.200
    78.496    -1.286     0.200
    78.458     1.758     0.200
    78.537     0.209     0.200
    78.563     0.901     0.200
    78.792     1.041     0.200
    78.872     0.644     0.200
    78.842     0.964     0.200
    78.884     0.476     0.200
    78.932     1.209     0.200
    78.966     0.733     0.200
    78.973     1.299     0.200
    79.063     0.193     0.200
    79.029     1.255     0.200
    79.041     1.084     0.200
    79.242     1.399     0.200
    79.261     0.986     0.200
    79.271     0.949     0.200
    79.318     1.145     0.200
    79.364     1.076     0.200
    79.423    -0.200     0.200
    79.424     0.047     0.200
    79.393     0.621     0.200
    79.481     0.810     0.200
    79.528    -0.172     0.200
    79.577    -0.253     0.200
    79.725     0.488     0.200
    79.697     0.931     0.200
    79.718     0.493     0.200
    79.713     1.136     0.200
    79.740     1.182     0.200
    79.795     1.088     0.200
    79.752     1.223     0.200
    79.761     1.143     0.200
    79.901     0.610     0.200
    79.974    -0.034     0.200
    80.005     0.070     0.200
    80.051     1.491     0.200
    80.110    -0.797     0.200
    80.085     2.040     0.200
    80.141    -0.888     0.200
    80.110     1.453     0.200
    80.160     0.965     0.200
    80.172     0.385     0.200
    80.233    -1.150     0.200
    80.240     0.466     0.200
    80.288     0.281     0.200
    80.405    -1.089     0.200
    80.465    -0.061     0.200
    80.564     0.654     0.200
    80.583     1.611     0.200
    80.598     0.705     0.200
    80.593     1.195     0.200
    80.645    -0.975     0.200
    80.613     1.567     0.200
    80.628     1.477     0.200
    80.690     0.180     0.200
    80.690    -1.300     0.200
    80.876    -0.430     0.200
    80.983     0.476     0.200
    81.001    -0.680     0.200
    80.968     1.461     0.200
    80.996     0.367     0.200
    80.998     1.552     0.200
    81.001    -1.178     0.200
    81.022     1.510     0.200
    81.064     1.266     0.200
    81.107    -0.093     0.200
    81.103    -0.558     0.200
    81.111     1.472     0.200
    81.190     0.014     0.200
    81.371     0.798     0.200
    81.425    -0.533     0.200
    81.395     0.711     0.200
    81.407     1.371     0.200
    81.434     0.265     0.200
    81.431     1.079     0.200
    81.440     1.167     0.200
    81.455     0.603     0.200
    81.472     1.046     0.200
    81.468     1.366     0.200
    81.615    -0.234     0.200
    81.657    -1.157     0.200
    81.676    -1.158     0.200
    81.702    -0.598     0.200
    81.879     0.608     0.200
    81.887     0.202     0.200
    81.962    -0.765     0.200
    81.925    -0.203     0.200
    81.934     0.858     0.200
    81.955     0.533     0.200
    81.953     1.029     0.200
    81.960     1.064     0.200
    81.959     0.323     0.200
    81.982     0.457     0.200
    82.323     1.388     0.200
    82.340     1.343     0.200
    82.416     1.349     0.200
    82.663     1.159     0.200
    82.725    -0.595     0.200
    82.746     0.420     0.200
    82.785     1.000     0.200
    82.792     0.953     0.200
    82.825     0.841     0.200
    83.131     0.456     0.200
    83.174    -0.879     0.200
    83.197     0.607     0.200
    83.200     0.695     0.200
    83.260    -1.124     0.200
    83.300    -1.034     0.200
    83.453    -0.642     0.200
    83.473    -0.923     0.200
    83.599     0.276     0.200
    83.653    -0.147     0.200
    83.610     0.758     0.200
    83.662     0.008     0.200
    83.626     0.433     0.200
    83.638     0.766     0.200
    83.707    -0.924     0.200
    83.719    -0.786     0.200
    83.687     0.594     0.200
    83.760    -0.698     0.200
    83.793     0.507     0.200
    83.991     0.867     0.200
    84.028     0.168     0.200
    84.034     0.593     0.200
    84.062     0.583     0.200
    84.092     0.782     0.200
    84.309     0.005     0.200
    84.331    -0.606     0.200
    84.395     0.732     0.200
    84.463    -0.577     0.200
    84.432     1.031     0.200
    84.478     0.448     0.200
    84.478    -0.351     0.200
    84.486     0.740     0.200
    84.513     0.402     0.200
    84.585    -0.392     0.200
    84.832     0.681     0.200
    84.861     0.675     0.200
    84.914     0.268     0.200
    84.972    -0.339     0.200
    84.952     0.804     0.200
    85.061     0.635     0.200
    85.215     0.629     0.200
    85.278    -1.073     0.200
    85.265     1.323     0.200
    85.348    -1.223     0.200
    85.507     0.787     0.200
    85.593    -0.947     0.200
    85.597     0.573     0.200
    85.686     0.364     0.200
    85.733     0.239     0.200
    85.738     0.520     0.200
    85.828     0.290     0.200
    85.819     0.943     0.200
    85.823     0.531     0.200
    85.939    -0.064     0.200
    85.917     0.316     0.200
    86.044     0.687     0.200
    86.081     1.215     0.200
    86.084     0.766     0.200
    86.105     0.353     0.200
    86.135     0.553     0.200
    86.262     0.143     0.200
    86.243     0.636     0.200
    86.264     0.711     0.200
    86.272     0.562     0.200
    86.533     0.632     0.200
    86.597     0.707     0.200
    86.602     0.786     0.200
    86.681     0.547     0.200
    86.700     0.691     0.200
    86.700     0.691     0.200
    86.773     0.627     0.200
    86.776     0.826     0.200
    86.958     0.777     0.200
    87.027     0.361     0.200
    87.044     0.567     0.200
    87.088     0.662     0.200
    87.091     0.574     0.200
    87.163    -0.065     0.200
    87.417     0.560     0.200
    87.446     1.134     0.200
    87.461     0.852     0.200
    87.773     0.707     0.200
    87.975    -1.603     0.200
    88.085    -0.488     0.200
    88.068     0.972     0.200
    88.206     0.872     0.200
    88.276     0.738     0.200
    88.435     0.902     0.200
    88.505     0.325     0.200
    88.534    -1.509     0.200
    88.813     0.881     0.200
    89.296     0.912     0.200
    90.830    -1.579     0.200
    92.522    -0.570     0.200
    26.628     0.782     0.200
    39.732    -0.709     0.200
    42.902    -0.199     0.200
    56.904    -1.307     0.200
    62.697    -0.585     0.200
    64.816    -1.628     0.200
    69.829    -1.232     0.200
    25.862    -0.036     0.200
    25.862    -0.336     0.200
    26.305    -0.043     0.200
    28.344    -1.302     0.200
    34.397    -0.582     0.200
    39.499    -1.696     0.200
    39.499    -0.477     0.200
    42.599    -0.238     0.200
    42.599    -0.238     0.200
    43.858    -0.689     0.200
    43.858    -1.209     0.200
    43.937    -0.364     0.200
    44.219     0.720     0.200
    44.428    -0.158     0.200
    47.024     0.976     0.200
    47.532     1.129     0.200
    47.853    -0.655     0.200
    47.982     0.943     0.200
    48.076     0.820     0.200
    48.101    -0.176     0.200
    48.101    -0.575     0.200
    48.152    -0.163     0.200
    48.586     0.791     0.200
    48.610     0.408     0.200
    48.610     0.510     0.200
    48.616     0.464     0.200
    48.814     0.645     0.200
    48.947     0.229     0.200
    49.262    -0.385     0.200
    49.262     0.060     0.200
    49.409     0.902     0.200
    49.842     0.702     0.200
    51.721    -0.622     0.200
    52.133    -0.188     0.200
    53.346    -0.637     0.200
    55.614    -0.386     0.200
    55.614    -1.023     0.200
    56.190    -0.505     0.200
    57.206    -1.408     0.200
    59.546    -1.311     0.200
    62.437    -0.004     0.200
    64.238    -1.013     0.200
    64.775    -1.013     0.200
    65.434     0.515     0.200
    66.163     0.725     0.200
    68.474     0.117     0.200
    69.835    -1.011     0.200
    69.835    -1.011     0.200
    70.929    -0.584     0.200
    73.129     0.596     0.200
    76.319     0.215     0.200
    77.164    -0.949     0.200
    78.904    -0.386     0.200
    84.305     0.031     0.200
    84.364    -0.565     0.200
    85.601    -0.367     0.200
    85.950     0.698     0.200
    86.251    -0.777     0.200
    86.433     0.434     0.200
    89.099     0.390     0.200
    21.509    -1.166     0.200
    26.016     0.352     0.200
    39.257     0.315     0.200
    42.318    -0.312     0.200
    43.601     0.208     0.200
    43.680    -0.403     0.200
    43.885     0.629     0.200
    44.658    -0.653     0.200
    47.865    -0.159     0.200
    48.973     0.117     0.200
    58.878    -0.789     0.200
    61.823    -2.118     0.200
    62.342    -0.595     0.200
    64.651    -1.440     0.200
    69.743    -1.310     0.200
    69.743    -1.310     0.200
    70.753    -0.799     0.200
    71.194     0.786     0.200
    73.406    -0.820     0.200
    14.960     4.055     0.200
    19.629    -1.817     0.200
    20.351    -2.098     0.200
    20.362    -1.561     0.200
    20.758     0.203     0.200
    20.957    -2.542     0.200
    21.305    -3.377     0.200
    21.305    -4.096     0.200
    21.368    -2.852     0.200
    21.368    -2.469     0.200
    21.782    -2.482     0.200
    22.159     1.414     0.200
    22.712     1.619     0.200
    22.712     2.533     0.200
    23.554    -3.151     0.200
    24.829    -0.818     0.200
    25.127    -1.931     0.200
    25.379    -2.104     0.200
    25.804    -0.807     0.200
    25.870    -0.253     0.200
    25.870    -0.816     0.200
    26.048    -1.318     0.200
    26.155    -1.712     0.200
    26.313    -0.089     0.200
    26.612    -0.956     0.200
    26.730     1.122     0.200
    27.831    -0.629     0.200
    27.948    -0.869     0.200
    28.174    -0.680     0.200
    28.174    -0.180     0.200
    28.174     0.344     0.200
    28.349    -0.538     0.200
    29.434    -1.458     0.200
    29.822     0.300     0.200
    30.241    -3.002     0.200
    30.241    -3.775     0.200
    30.832     0.575     0.200
    32.591     0.728     0.200
    33.279    -0.375     0.200
    33.663     0.779     0.200
    34.401    -0.113     0.200
    35.673    -1.102     0.200
    36.459     0.829     0.200
    37.280     0.757     0.200
    38.714     2.053     0.200
    38.862     0.640     0.200
    39.500    -0.628     0.200
    39.500    -0.472     0.200
    39.842     0.376     0.200
    40.303    -1.539     0.200
    41.486    -1.236     0.200
    42.036     0.939     0.200
    42.165     0.741     0.200
    42.605    -0.287     0.200
    42.605    -0.389     0.200
    42.605    -0.287     0.200
    42.953    -1.181     0.200
    43.234     1.732     0.200
    43.711    -0.492     0.200
    43.703    -0.694     0.200
    43.860     0.194     0.200
    43.860    -0.509     0.200
    43.860    -0.118     0.200
    43.940    -0.239     0.200
    43.977    -0.239     0.200
    44.008     0.714     0.200
    44.008     0.832     0.200
    44.127     0.856     0.200
    44.246     1.003     0.200
    44.275     1.778     0.200
    44.284     1.010     0.200
    44.396    -0.622     0.200
    44.953    -0.023     0.200
    45.007     1.151     0.200
    45.785     0.889     0.200
    46.079     0.779     0.200
    46.079    -0.206     0.200
    46.788    -0.270     0.200
    47.045     1.226     0.200
    47.174    -0.187     0.200
    47.553     0.777     0.200
    48.002     0.996     0.200
    48.101    -0.270     0.200
    48.089     0.631     0.200
    48.096     0.773     0.200
    48.152    -0.956     0.200
    48.152    -0.261     0.200
    48.152     0.286     0.200
    48.250     1.584     0.200
    48.414     0.526     0.200
    48.414     0.698     0.200
    48.606     0.551     0.200
    48.630     0.467     0.200
    48.636     0.320     0.200
    48.834     0.701     0.200
    48.950    -0.129     0.200
    48.957     0.425     0.200
    48.966     0.389     0.200
    48.991     1.423     0.200
    49.010     0.030     0.200
    49.133    -0.837     0.200
    49.133    -0.712     0.200
    49.108     0.104     0.200
    49.270    -0.036     0.200
    49.270    -0.138     0.200
    49.270     0.143     0.200
    49.427     0.705     0.200
    49.427     1.164     0.200
    49.589     3.729     0.200
    49.742    -0.024     0.200
    49.742     0.210     0.200
    49.861     0.764     0.200
    50.020     0.723     0.200
    50.417     0.130     0.200
    51.431     0.550     0.200
    51.728    -0.767     0.200
    51.728    -0.666     0.200
    52.057    -1.297     0.200
    52.129     0.053     0.200
    52.575     0.259     0.200
    52.655     1.452     0.200
    52.655     1.265     0.200
    52.799    -0.381     0.200
    52.799     0.103     0.200
    52.845    -0.594     0.200
    52.936    -0.115     0.200
    52.995    -0.758     0.200
    53.049     0.649     0.200
    53.049     0.438     0.200
    53.342    -1.099     0.200
    53.342    -0.802     0.200
    53.732     1.290     0.200
    53.732     0.743     0.200
    53.796     0.875     0.200
    54.073    -0.445     0.200
    54.606    -0.396     0.200
    54.767    -1.479     0.200
    54.816    -0.736     0.200
    55.249    -1.096     0.200
    55.614    -0.379     0.200
    55.614    -0.239     0.200
    55.688    -0.210     0.200
    55.744     0.191     0.200
    55.744     0.598     0.200
    56.009    -0.183     0.200
    55.988     0.173     0.200
    56.189    -0.693     0.200
    56.313     1.288     0.200
    57.016    -0.902     0.200
    57.089    -3.276     0.200
    57.176    -1.471     0.200
    57.664     0.447     0.200
    57.667    -0.540     0.200
    58.254     1.251     0.200
    58.432    -1.495     0.200
    58.440     0.247     0.200
    58.630    -0.630     0.200
    58.984    -1.225     0.200
    59.530    -1.321     0.200
    59.530    -2.353     0.200
    59.728    -0.459     0.200
    59.728    -0.350     0.200
    60.020    -2.963     0.200
    60.483    -1.190     0.200
    60.630    -2.021     0.200
    61.938    -0.757     0.200
    62.033     0.681     0.200
    62.189     1.261     0.200
    62.154     0.309     0.200
    62.415     0.846     0.200
    62.479     0.819     0.200
    62.477     0.873     0.200
    62.454    -1.712     0.200
    62.465    -0.508     0.200
    62.521    -0.361     0.200
    62.798     0.764     0.200
    63.045     0.804     0.200
    63.810    -1.600     0.200
    64.226    -1.519     0.200
    64.222     0.686     0.200
    64.454    -0.816     0.200
    64.669    -1.121     0.200
    64.669    -1.816     0.200
    64.681    -2.892     0.200
    64.761    -1.286     0.200
    64.762    -1.295     0.200
    64.870    -2.641     0.200
    64.816     1.127     0.200
    64.816     0.479     0.200
    64.900     0.518     0.200
    64.945     0.694     0.200
    64.998     0.571     0.200
    65.409    -0.415     0.200
    65.409    -0.524     0.200
    65.503    -0.198     0.200
    65.503     0.036     0.200
    65.503     0.200     0.200
    65.647     0.771     0.200
    65.841    -1.502     0.200
    65.932    -2.188     0.200
    66.041     1.399     0.200
    66.138     0.640     0.200
    66.190    -0.099     0.200
    66.192     0.728     0.200
    66.574    -1.093     0.200
    66.655     0.984     0.200
    66.667     0.566     0.200
    66.714     0.129     0.200
    66.871     0.865     0.200
    66.992    -0.751     0.200
    67.126     0.989     0.200
    67.332    -0.654     0.200
    67.336     0.979     0.200
    67.572     0.377     0.200
    67.630     0.294     0.200
    67.826     0.650     0.200
    67.846     0.234     0.200
    68.065     0.237     0.200
    68.087    -0.168     0.200
    68.242     0.077     0.200
    68.342     0.777     0.200
    68.374     0.416     0.200
    68.400     0.003     0.200
    68.436     0.481     0.200
    68.441     3.234     0.200
    68.453     1.056     0.200
    68.453     0.455     0.200
    68.453     0.947     0.200
    68.453     0.603     0.200
    68.474     0.521     0.200
    68.478    -2.509     0.200
    68.515     0.678     0.200
    68.601    -0.274     0.200
    68.601    -0.469     0.200
    68.617    -0.356     0.200
    68.640     0.717     0.200
    68.648     0.612     0.200
    68.727    -0.853     0.200
    68.717     0.738     0.200
    68.767    -0.469     0.200
    68.835    -0.392     0.200
    68.884    -2.332     0.200
    68.861     1.104     0.200
    68.952    -0.907     0.200
    68.930     0.135     0.200
    69.038    -2.285     0.200
    69.245     0.251     0.200
    69.282     0.418     0.200
    69.296     0.365     0.200
    69.310     1.937     0.200
    69.343     0.583     0.200
    69.408    -0.073     0.200
    69.418     0.473     0.200
    69.504     0.310     0.200
    69.504     0.131     0.200
    69.487     0.619     0.200
    69.524     0.472     0.200
    69.569     0.483     0.200
    69.572     1.634     0.200
    69.616    -0.598     0.200
    69.630     0.114     0.200
    69.820    -1.312     0.200
    69.820    -1.187     0.200
    69.819    -0.183     0.200
    69.827     0.745     0.200
    69.855     0.590     0.200
    69.892     0.693     0.200
    69.947     0.171     0.200
    69.947     0.407     0.200
    70.053     0.385     0.200
    70.073    -1.597     0.200
    70.101     0.228     0.200
    70.108     0.520     0.200
    70.121     0.981     0.200
    70.271     0.331     0.200
    70.266     1.088     0.200
    70.331     0.017     0.200
    70.356    -0.289     0.200
    70.516     0.524     0.200
    70.594     0.503     0.200
    70.606     0.221     0.200
    70.629     0.839     0.200
    70.638     0.343     0.200
    70.705     0.601     0.200
    70.760     0.069     0.200
    70.784     0.467     0.200
    70.784     0.162     0.200
    70.861     0.917     0.200
    70.871     0.946     0.200
    70.874     0.397     0.200
    70.922    -1.130     0.200
    70.922    -1.232     0.200
    70.934    -1.118     0.200
    70.934    -1.109     0.200
    70.934    -1.289     0.200
    70.944     0.520     0.200
    70.961    -1.172     0.200
    70.930     1.641     0.200
    71.020     0.676     0.200
    71.032     0.670     0.200
    71.143    -1.170     0.200
    71.143    -1.272     0.200
    71.192     0.094     0.200
    71.348    -1.361     0.200
    71.341     0.417     0.200
    71.314     1.767     0.200
    71.356     0.692     0.200
    71.423    -0.861     0.200
    71.460     2.546     0.200
    71.460     2.366     0.200
    71.457    -0.771     0.200
    71.538     0.385     0.200
    71.517     0.620     0.200
    71.569     0.575     0.200
    71.583     0.302     0.200
    71.627     0.234     0.200
    71.704     0.705     0.200
    71.723     0.480     0.200
    71.723     0.176     0.200
    71.744     1.006     0.200
    71.762     0.735     0.200
    71.775     1.883     0.200
    71.776     1.998     0.200
    71.809    -0.067     0.200
    71.815     0.136     0.200
    71.874     0.585     0.200
    71.888     0.502     0.200
    71.931     0.097     0.200
    71.947    -0.077     0.200
    71.947     0.071     0.200
    71.976    -0.534     0.200
    72.033    -0.237     0.200
    72.010    -0.363     0.200
    72.015    -0.090     0.200
    72.126     0.976     0.200
    72.133     0.673     0.200
    72.161     0.210     0.200
    72.182     0.477     0.200
    72.235     0.663     0.200
    72.276     0.351     0.200
    72.316     0.424     0.200
    72.354     0.865     0.200
    72.345     1.451     0.200
    72.478    -0.476     0.200
    72.491     0.393     0.200
    72.547     0.996     0.200
    72.556     1.006     0.200
    72.665     0.287     0.200
    72.681     0.694     0.200
    72.789     0.174     0.200
    72.827     0.612     0.200
    72.870     1.112     0.200
    72.904    -0.110     0.200
    72.982     0.832     0.200
    72.982     0.668     0.200
    72.994     1.091     0.200
    73.035     0.901     0.200
    73.059     0.939     0.200
    73.097     0.404     0.200
    73.097     0.450     0.200
    73.156     0.064     0.200
    73.175     0.337     0.200
    73.224    -0.616     0.200
    73.260     0.169     0.200
    73.292    -0.019     0.200
    73.311     0.918     0.200
    73.379     0.423     0.200
    73.404    -1.859     0.200
    73.400     0.072     0.200
    73.415    -1.335     0.200
    73.472     0.021     0.200
    73.495     0.636     0.200
    73.566     1.067     0.200
    73.602     0.743     0.200
    73.629     0.058     0.200
    73.656     0.405     0.200
    73.711     0.372     0.200
    73.734     0.013     0.200
    73.729     0.938     0.200
    73.760     0.069     0.200
    73.762    -0.083     0.200
    73.782     0.517     0.200
    73.804     0.349     0.200
    73.809     0.949     0.200
    73.840     0.630     0.200
    73.877    -0.928     0.200
    73.871     1.235     0.200
    73.932     0.141     0.200
    73.837    -0.023     0.200
    73.837     0.891     0.200
    73.936     0.940     0.200
    73.971     0.482     0.200
    74.016    -0.741     0.200
    74.011     1.108     0.200
    74.090     0.144     0.200
    74.156     0.970     0.200
    74.180    -0.401     0.200
    74.190    -0.259     0.200
    74.212    -0.216     0.200
    74.306     0.128     0.200
    74.337     0.010     0.200
    74.369    -0.394     0.200
    74.371    -0.433     0.200
    74.382     0.777     0.200
    74.416    -0.614     0.200
    74.434     0.159     0.200
    74.453     1.071     0.200
    74.530     0.138     0.200
    74.548    -0.185     0.200
    74.548     0.175     0.200
    74.575     0.331     0.200
    74.592     0.212     0.200
    74.592    -0.225     0.200
    74.643     0.839     0.200
    74.686     0.277     0.200
    74.686    -0.336     0.200
    74.797     0.367     0.200
    74.809     0.055     0.200
    74.809     0.281     0.200
    74.832     0.258     0.200
    74.831     1.022     0.200
    74.863     1.215     0.200
    74.955    -0.178     0.200
    74.964     0.098     0.200
    74.969    -0.164     0.200
    75.011    -0.107     0.200
    75.021     0.733     0.200
    75.060     0.819     0.200
    75.075    -0.079     0.200
    75.106    -0.258     0.200
    75.100     0.577     0.200
    75.120     0.974     0.200
    75.127     0.199     0.200
    75.134     0.806     0.200
    75.170     0.171     0.200
    75.213     0.264     0.200
    75.288     0.426     0.200
    75.301     0.331     0.200
    75.304    -0.394     0.200
    75.351    -0.862     0.200
    75.372    -0.083     0.200
    75.381     0.071     0.200
    75.381    -0.030     0.200
    75.400     0.964     0.200
    75.481     0.193     0.200
    75.475     1.104     0.200
    75.523    -0.946     0.200
    75.538     0.266     0.200
    75.564     0.790     0.200
    75.586    -0.104     0.200
    75.595     0.488     0.200
    75.612     0.506     0.200
    75.620     0.045     0.200
    75.637     0.324     0.200
    75.678    -0.131     0.200
    75.695     0.174     0.200
    75.693     1.683     0.200
    75.708     0.598     0.200
    75.703     0.567     0.200
    75.717     0.869     0.200
    75.732     0.063     0.200
    75.779     0.491     0.200
    75.792     0.619     0.200
    75.792     0.220     0.200
    75.792     1.304     0.200
    75.804     0.151     0.200
    75.824     0.130     0.200
    75.857    -0.036     0.200
    75.894    -1.057     0.200
    75.919    -0.450     0.200
    75.917     0.120     0.200
    75.930    -0.268     0.200
    76.088     0.533     0.200
    76.101     0.657     0.200
    76.111     0.907     0.200
    76.113     0.565     0.200
    76.132     0.714     0.200
    76.140     0.226     0.200
    76.171     0.858     0.200
    76.185     0.288     0.200
    76.187     0.372     0.200
    76.287     0.000     0.200
    76.289     0.192     0.200
    76.317    -0.038     0.200
    76.317     0.180     0.200
    76.343    -0.214     0.200
    76.344     1.082     0.200
    76.379    -0.023     0.200
    76.405     0.330     0.200
    76.405     0.830     0.200
    76.435     0.864     0.200
    76.529     0.741     0.200
    76.540     1.175     0.200
    76.603     0.065     0.200
    76.616    -0.093     0.200
    76.634    -0.058     0.200
    76.634     0.341     0.200
    76.653     0.534     0.200
    76.662     0.082     0.200
    76.666     0.263     0.200
    76.684     0.355     0.200
    76.684     0.456     0.200
    76.703     0.056     0.200
    76.724     0.236     0.200
    76.725     0.345     0.200
    76.760    -0.111     0.200
    76.802    -0.006     0.200
    76.804     1.108     0.200
    76.808     0.637     0.200
    76.838     1.106     0.200
    76.901     1.135     0.200
    76.955     1.329     0.200
    76.988     0.700     0.200
    77.014    -0.070     0.200
    77.032     1.030     0.200
    77.104    -0.200     0.200
    77.104     0.597     0.200
    77.104     0.097     0.200
    77.153    -0.676     0.200
    77.153    -0.777     0.200
    77.158    -0.633     0.200
    77.158    -0.500     0.200
    77.197    -0.629     0.200
    77.183     1.065     0.200
    77.200     0.060     0.200
    77.247     0.001     0.200
    77.239     0.210     0.200
    77.293     1.138     0.200
    77.293     0.865     0.200
    77.321     0.782     0.200
    77.346     1.210     0.200
    77.358     0.026     0.200
    77.359    -0.628     0.200
    77.364     0.854     0.200
    77.384     0.527     0.200
    77.397     1.066     0.200
    77.454     0.200     0.200
    77.470     1.128     0.200
    77.484     0.942     0.200
    77.595     0.354     0.200
    77.620     0.211     0.200
    77.645     0.074     0.200
    77.649    -0.153     0.200
    77.647     0.929     0.200
    77.674     0.812     0.200
    77.661     1.240     0.200
    77.749    -0.301     0.200
    77.828    -0.150     0.200
    77.834     0.021     0.200
    77.844     0.686     0.200
    77.879     0.717     0.200
    77.887     0.751     0.200
    77.925     0.314     0.200
    77.951    -0.267     0.200
    77.993     0.227     0.200
    78.005     0.294     0.200
    78.062     1.320     0.200
    78.080    -0.444     0.200
    78.094     0.184     0.200
    78.094     0.083     0.200
    78.094     0.286     0.200
    78.110    -0.611     0.200
    78.139    -0.568     0.200
    78.138     0.640     0.200
    78.154     0.852     0.200
    78.217     0.452     0.200
    78.231     0.618     0.200
    78.234    -0.194     0.200
    78.282     0.735     0.200
    78.311     0.800     0.200
    78.346     0.459     0.200
    78.383     0.539     0.200
    78.397     0.273     0.200
    78.408     0.046     0.200
    78.450    -0.777     0.200
    78.467     0.325     0.200
    78.482     0.970     0.200
    78.489     0.849     0.200
    78.509     0.330     0.200
    78.602    -0.839     0.200
    78.630    -0.278     0.200
    78.667     0.632     0.200
    78.688     0.507     0.200
    78.681     0.660     0.200
    78.690     0.355     0.200
    78.696     0.445     0.200
    78.706     0.106     0.200
    78.708     0.092     0.200
    78.708    -0.009     0.200
    78.741    -0.688     0.200
    78.777     0.479     0.200
    78.808     0.858     0.200
    78.832    -0.484     0.200
    78.893    -0.421     0.200
    78.893    -0.366     0.200
    78.927     0.198     0.200
    78.969    -0.442     0.200
    78.969    -0.841     0.200
    79.007    -0.380     0.200
    79.009     0.966     0.200
    79.035    -0.701     0.200
    79.042     0.263     0.200
    79.043     0.436     0.200
    79.055     0.745     0.200
    79.100     0.094     0.200
    79.103     0.340     0.200
    79.130     0.086     0.200
    79.196     0.532     0.200
    79.202     0.035     0.200
    79.210    -0.419     0.200
    79.240    -0.497     0.200
    79.282     0.656     0.200
    79.303     1.010     0.200
    79.360     1.701     0.200
    79.355     0.385     0.200
    79.421     1.608     0.200
    79.439    -0.628     0.200
    79.457     0.140     0.200
    79.461     0.550     0.200
    79.479    -0.107     0.200
    79.486     0.092     0.200
    79.502     1.058     0.200
    79.522    -0.855     0.200
    79.527     0.204     0.200
    79.543     0.267     0.200
    79.554    -0.631     0.200
    79.559    -0.033     0.200
    79.595     0.349     0.200
    79.603     0.705     0.200
    79.624    -0.070     0.200
    79.663     0.485     0.200
    79.663     0.782     0.200
    79.651    -0.125     0.200
    79.671    -0.359     0.200
    79.839     1.505     0.200
    79.848     0.568     0.200
    79.839     0.028     0.200
    79.860    -0.028     0.200
    79.918    -0.802     0.200
    79.918    -0.326     0.200
    79.906     0.137     0.200
    79.967    -0.326     0.200
    79.972    -0.071     0.200
    80.020     0.038     0.200
    80.048    -1.218     0.200
    80.052    -0.802     0.200
    80.050     0.013     0.200
    80.107    -0.518     0.200
    80.117    -0.149     0.200
    80.117    -0.112     0.200
    80.161    -0.715     0.200
    80.166     0.467     0.200
    80.166     0.264     0.200
    80.247     1.486     0.200
    80.272     0.492     0.200
    80.275     0.180     0.200
    80.272     1.271     0.200
    80.280     0.151     0.200
    80.289     0.323     0.200
    80.338    -0.310     0.200
    80.362    -0.585     0.200
    80.374    -0.055     0.200
    80.374     1.619     0.200
    80.379     0.838     0.200
    80.437     0.216     0.200
    80.451    -0.341     0.200
    80.471     0.574     0.200
    80.553    -0.633     0.200
    80.594     1.360     0.200
    80.631    -0.434     0.200
    80.649    -0.732     0.200
    80.664     1.761     0.200
    80.665     0.981     0.200
    80.695     0.115     0.200
    80.718    -0.649     0.200
    80.711     1.408     0.200
    80.771    -0.292     0.200
    80.802    -0.892     0.200
    80.805    -0.190     0.200
    80.836    -0.323     0.200
    80.837     0.048     0.200
    80.889     0.098     0.200
    80.897    -0.150     0.200
    80.902    -0.746     0.200
    80.925     1.126     0.200
    80.925     1.001     0.200
    80.936     0.133     0.200
    80.946    -0.511     0.200
    80.947    -0.049     0.200
    80.972    -0.619     0.200
    80.983    -0.901     0.200
    80.984     0.132     0.200
    80.983     0.641     0.200
    80.986    -0.122     0.200
    81.014     0.126     0.200
    81.030    -0.764     0.200
    81.061    -0.906     0.200
    81.070     1.071     0.200
    81.108    -0.747     0.200
    81.120    -0.060     0.200
    81.130    -0.023     0.200
    81.128    -0.455     0.200
    81.147    -1.118     0.200
    81.146     0.974     0.200
    81.167     1.629     0.200
    81.167     1.387     0.200
    81.199    -0.755     0.200
    81.198     1.249     0.200
    81.200     1.310     0.200
    81.217    -0.849     0.200
    81.224    -0.286     0.200
    81.226    -0.602     0.200
    81.245     0.322     0.200
    81.255    -0.018     0.200
    81.261    -0.021     0.200
    81.297    -0.170     0.200
    81.313    -0.961     0.200
    81.313    -0.258     0.200
    81.313    -0.656     0.200
    81.379    -0.908     0.200
    81.416     1.802     0.200
    81.467    -0.375     0.200
    81.474    -1.106     0.200
    81.531    -0.026     0.200
    81.541    -0.811     0.200
    81.552    -0.580     0.200
    81.570    -1.543     0.200
    81.564     0.806     0.200
    81.572     1.216     0.200
    81.580     0.904     0.200
    81.614    -0.449     0.200
    81.611    -1.229     0.200
    81.628    -0.131     0.200
    81.623    -0.308     0.200
    81.646    -0.279     0.200
    81.653    -0.856     0.200
    81.663    -0.637     0.200
    81.677    -0.039     0.200
    81.716    -1.393     0.200
    81.722     0.342     0.200
    81.736    -0.881     0.200
    81.729    -0.335     0.200
    81.772    -0.576     0.200
    81.823    -0.946     0.200
    81.823    -0.548     0.200
    81.867    -0.777     0.200
    81.890    -1.372     0.200
    81.921    -0.359     0.200
    81.989    -1.020     0.200
    81.990    -0.321     0.200
    81.996     0.425     0.200
    82.007     0.632     0.200
    82.013    -1.516     0.200
    82.023    -0.302     0.200
    82.023    -0.495     0.200
    82.049     1.142     0.200
    82.099     1.361     0.200
    82.116    -0.583     0.200
    82.143    -0.624     0.200
    82.145    -0.634     0.200
    82.167    -0.010     0.200
    82.217    -0.616     0.200
    82.271    -0.995     0.200
    82.284    -0.759     0.200
    82.371    -0.315     0.200
    82.395    -0.637     0.200
    82.416    -0.356     0.200
    82.433    -0.169     0.200
    82.430     1.095     0.200
    82.445     0.699     0.200
    82.454    -0.234     0.200
    82.477    -0.368     0.200
    82.495     0.664     0.200
    82.511    -0.278     0.200
    82.531    -0.439     0.200
    82.531    -0.587     0.200
    82.556    -0.587     0.200
    82.552    -1.657     0.200
    82.626    -0.948     0.200
    82.637    -1.405     0.200
    82.678    -0.315     0.200
    82.757    -1.424     0.200
    82.771    -2.101     0.200
    82.791     0.249     0.200
    82.810    -1.599     0.200
    82.837     0.998     0.200
    82.877     1.063     0.200
    82.888    -0.503     0.200
    82.901     0.776     0.200
    82.916    -1.047     0.200
    82.926     0.839     0.200
    83.003     0.855     0.200
    83.060     0.647     0.200
    83.152    -1.262     0.200
    83.178    -1.706     0.200
    83.190     0.741     0.200
    83.197    -1.903     0.200
    83.224     0.862     0.200
    83.251    -2.183     0.200
    83.285     1.049     0.200
    83.306     0.708     0.200
    83.352     0.674     0.200
    83.389    -1.189     0.200
    83.402    -0.550     0.200
    83.479    -0.448     0.200
    83.506    -2.494     0.200
    83.519    -0.458     0.200
    83.574    -0.534     0.200
    83.586    -0.598     0.200
    83.635    -1.155     0.200
    83.633     0.976     0.200
    83.650    -1.325     0.200
    83.669     0.886     0.200
    83.708    -0.618     0.200
    83.725     0.088     0.200
    83.735     0.820     0.200
    83.765    -0.714     0.200
    83.774     0.357     0.200
    83.798    -0.886     0.200
    83.820    -0.497     0.200
    83.823     1.037     0.200
    83.844    -0.914     0.200
    83.942    -0.121     0.200
    83.944    -0.924     0.200
    83.984     0.068     0.200
    84.050    -1.067     0.200
    84.062    -0.630     0.200
    84.082     0.496     0.200
    84.081     0.908     0.200
    84.092    -0.078     0.200
    84.129     0.584     0.200
    84.151     0.652     0.200
    84.164    -0.248     0.200
    84.184     0.901     0.200
    84.209     0.561     0.200
    84.245    -0.555     0.200
    84.262    -2.141     0.200
    84.284     0.040     0.200
    84.294     0.197     0.200
    84.294     0.752     0.200
    84.315    -0.513     0.200
    84.328    -0.682     0.200
    84.350    -0.388     0.200
    84.427    -0.979     0.200
    84.472     0.481     0.200
    84.490     0.523     0.200
    84.517     0.827     0.200
    84.548     0.519     0.200
    84.559     1.045     0.200
    84.594    -0.025     0.200
    84.666    -0.033     0.200
    84.702    -0.162     0.200
    84.702     0.135     0.200
    84.722    -0.465     0.200
    84.733     0.642     0.200
    84.740    -1.056     0.200
    84.853    -0.225     0.200
    84.893     0.598     0.200
    84.929     0.979     0.200
    84.947    -0.495     0.200
    84.977    -0.045     0.200
    84.980     1.139     0.200
    84.971     0.759     0.200
    85.017     0.507     0.200
    85.076     1.195     0.200
    85.106     0.006     0.200
    85.138     1.042     0.200
    85.168    -0.201     0.200
    85.163    -1.457     0.200
    85.316     1.059     0.200
    85.330    -0.408     0.200
    85.330     0.391     0.200
    85.332     0.966     0.200
    85.336     0.337     0.200
    85.360     0.530     0.200
    85.360     0.536     0.200
    85.382    -1.205     0.200
    85.392     0.496     0.200
    85.395     0.371     0.200
    85.440    -0.954     0.200
    85.480     0.809     0.200
    85.482     1.001     0.200
    85.517    -0.739     0.200
    85.534     0.563     0.200
    85.589    -0.095     0.200
    85.634    -0.021     0.200
    85.753     1.290     0.200
    85.803     0.493     0.200
    85.835     0.767     0.200
    85.845     0.334     0.200
    85.854     0.208     0.200
    85.918     1.205     0.200
    85.950     0.554     0.200
    85.991    -0.108     0.200
    86.017     0.491     0.200
    86.195     0.764     0.200
    86.203     0.104     0.200
    86.240    -0.615     0.200
    86.265     0.068     0.200
    86.270     0.544     0.200
    86.278     0.604     0.200
    86.354     0.080     0.200
    86.363     0.171     0.200
    86.419     0.605     0.200
    86.555     0.143     0.200
    86.683     0.530     0.200
    86.687     0.692     0.200
    86.691     0.876     0.200
    86.717     0.595     0.200
    86.841     0.443     0.200
    87.037     0.579     0.200
    87.137     0.737     0.200
    87.158     1.051     0.200
    87.533     0.360     0.200
    87.680     0.762     0.200
    88.452     0.739     0.200
    88.541     0.648     0.200
    88.674     0.693     0.200
    88.871     0.789     0.200
    89.085     0.563     0.200
    89.105     0.368     0.200
    89.782     1.539     0.200
    90.539     1.789     0.200
    91.561    -0.353     0.200
    91.947    -0.256     0.200
    92.622    -0.277     0.200
    92.638    -0.446     0.200
    92.708    -0.371     0.200
    93.088    -0.144     0.200
    93.279    -0.805     0.200
    21.268    -2.676     0.200
    26.335     0.091     0.200
    39.496    -0.254     0.200
    42.621    -0.170     0.200
    44.286    -0.293     0.200
    47.109     0.890     0.200
    47.618     0.541     0.200
    48.153     0.508     0.200
    48.157     0.871     0.200
    53.321    -1.075     0.200
    59.470    -1.457     0.200
    62.563     0.214     0.200
    64.714    -1.324     0.200
    66.290     0.355     0.200
    68.465    -0.238     0.200
    69.762    -1.164     0.200
    69.762    -1.641     0.200
    70.757    -0.210     0.200
    76.306     0.021     0.200
    85.813     0.964     0.200
    21.412    -2.651     0.200
    23.512     0.488     0.200
    26.285    -0.452     0.200
    39.484    -0.223     0.200
    42.580    -0.010     0.200
    44.190     0.693     0.200
    48.137     0.100     0.200
    53.335    -0.500     0.200
    59.545    -1.859     0.200
    62.455    -1.027     0.200
    64.771    -1.210     0.200
    64.771    -1.335     0.200
    68.440    -0.422     0.200
    69.834    -1.250     0.200
    69.834    -0.977     0.200
    76.305    -0.658     0.200
    76.305    -0.158     0.200
    78.898    -0.060     0.200
    85.977     1.172     0.200
    17.961    -1.718     0.200
    18.625    -0.920     0.200
    19.583    -1.542     0.200
    20.310    -1.788     0.200
    20.321    -4.004     0.200
    20.710    -3.713     0.200
    20.912    -2.294     0.200
    21.315    -4.019     0.200
    21.315    -4.616     0.200
    21.400    -3.027     0.200
    21.400    -2.625     0.200
    21.735    -3.612     0.200
    22.139     1.285     0.200
    23.516    -3.074     0.200
    23.804    -2.509     0.200
    23.998    -3.979     0.200
    24.300    -3.133     0.200
    24.712    -1.389     0.200
    25.080    -1.165     0.200
    25.757    -2.466     0.200
    25.842    -0.532     0.200
    25.842    -0.298     0.200
    25.842    -0.403     0.200
    26.108    -3.026     0.200
    26.285    -0.099     0.200
    26.563     2.053     0.200
    26.564    -2.455     0.200
    26.682    -0.871     0.200
    27.810    -0.827     0.200
    27.904    -0.759     0.200
    28.152     0.001     0.200
    28.152    -0.569     0.200
    28.152     0.630     0.200
    28.152     0.403     0.200
    28.325    -1.511     0.200
    28.709    -3.420     0.200
    29.388    -2.095     0.200
    29.800     0.307     0.200
    30.791     0.954     0.200
    31.282    -0.551     0.200
    32.554     0.866     0.200
    32.934     0.567     0.200
    33.234    -0.276     0.200
    33.617    -0.102     0.200
    34.378     0.394     0.200
    34.743    -0.858     0.200
    36.411     0.845     0.200
    36.411    -2.366     0.200
    37.233     0.357     0.200
    38.322    -1.072     0.200
    38.814    -0.927     0.200
    39.481    -0.444     0.200
    39.812    -0.071     0.200
    40.285    -0.390     0.200
    42.082     0.085     0.200
    42.147     0.935     0.200
    42.210     0.264     0.200
    42.369     0.747     0.200
    42.450    -1.027     0.200
    42.450    -0.425     0.200
    42.579    -0.578     0.200
    42.579    -0.324     0.200
    42.606     0.653     0.200
    42.704    -0.852     0.200
    42.781    -0.322     0.200
    42.785     0.335     0.200
    43.044     0.249     0.200
    43.192     1.865     0.200
    43.192     1.365     0.200
    43.218    -0.108     0.200
    43.629    -1.055     0.200
    43.690    -0.446     0.200
    43.733    -1.287     0.200
    43.665     0.012     0.200
    43.757    -0.761     0.200
    43.839     0.362     0.200
    43.839    -0.138     0.200
    43.839    -0.580     0.200
    43.853     0.003     0.200
    43.918    -0.325     0.200
    43.946    -0.097     0.200
    43.961     1.302     0.200
    44.020    -0.591     0.200
    44.086    -0.724     0.200
    44.199     0.867     0.200
    44.199     1.074     0.200
    44.249     0.675     0.200
    44.247     1.397     0.200
    44.439    -1.040     0.200
    44.748     2.301     0.200
    44.976     0.540     0.200
    44.924     0.701     0.200
    44.969     0.540     0.200
    45.399    -0.998     0.200
    45.601    -1.267     0.200
    45.744     0.707     0.200
    45.987     0.511     0.200
    46.059     0.300     0.200
    46.046     0.530     0.200
    46.046    -0.669     0.200
    46.662     0.499     0.200
    46.749     0.516     0.200
    46.873    -1.238     0.200
    46.849    -1.854     0.200
    47.003     1.141     0.200
    47.133     0.128     0.200
    47.338     0.825     0.200
    47.511     0.890     0.200
    47.562     0.990     0.200
    47.700     1.120     0.200
    47.819    -0.603     0.200
    48.047     0.638     0.200
    48.084    -0.743     0.200
    48.084    -0.083     0.200
    48.054     0.982     0.200
    48.134    -0.132     0.200
    48.134    -0.535     0.200
    48.134     0.102     0.200
    48.221     1.585     0.200
    48.300     1.752     0.200
    48.386     0.728     0.200
    48.496    -0.921     0.200
    48.565     0.651     0.200
    48.589     0.569     0.200
    48.595     0.421     0.200
    48.793     0.805     0.200
    48.922    -0.029     0.200
    48.929     0.316     0.200
    48.925     0.384     0.200
    48.963     1.541     0.200
    48.982     0.120     0.200
    49.080    -0.996     0.200
    49.242    -0.069     0.200
    49.242    -0.436     0.200
    49.242     0.365     0.200
    49.242     0.083     0.200
    49.399     0.589     0.200
    49.387     1.260     0.200
    49.354     1.311     0.200
    49.558     3.956     0.200
    49.619     1.089     0.200
    49.714     0.131     0.200
    49.821     0.758     0.200
    49.785     4.635     0.200
    49.992     0.889     0.200
    50.117     2.386     0.200
    50.641    -0.440     0.200
    50.845     0.342     0.200
    51.044    -0.169     0.200
    51.042     2.459     0.200
    51.496    -0.053     0.200
    51.701    -0.784     0.200
    51.701    -0.385     0.200
    51.621     0.715     0.200
    51.621     0.406     0.200
    51.768    -0.979     0.200
    52.117    -0.179     0.200
    52.218     0.170     0.200
    52.607     2.411     0.200
    52.607    -0.640     0.200
    52.762    -0.013     0.200
    53.002    -1.067     0.200
    53.020     0.448     0.200
    53.330    -0.815     0.200
    53.330     0.068     0.200
    53.433     2.436     0.200
    53.563     2.405     0.200
    53.778     0.500     0.200
    54.035    -0.486     0.200
    54.129    -0.175     0.200
    54.129    -0.663     0.200
    54.568    -0.762     0.200
    54.793    -0.591     0.200
    54.809    -0.806     0.200
    54.935    -0.065     0.200
    55.173     1.468     0.200
    55.393     1.386     0.200
    55.596    -0.571     0.200
    55.596    -0.399     0.200
    55.622    -1.429     0.200
    55.622    -2.003     0.200
    55.703    -0.652     0.200
    55.703    -1.241     0.200
    55.802     0.448     0.200
    55.965    -0.393     0.200
    56.172    -1.042     0.200
    56.206     0.366     0.200
    56.580    -2.566     0.200
    56.810    -0.822     0.200
    57.210    -1.752     0.200
    57.395    -0.228     0.200
    57.520    -0.544     0.200
    57.857    -1.603     0.200
    58.237    -0.602     0.200
    58.436    -1.946     0.200
    58.766    -2.342     0.200
    59.283    -1.011     0.200
    59.536    -1.170     0.200
    59.537    -0.890     0.200
    59.634     0.165     0.200
    59.672    -1.039     0.200
    59.685    -0.987     0.200
    59.684    -1.196     0.200
    60.017    -1.367     0.200
    60.490    -1.360     0.200
    60.650    -1.688     0.200
    61.162    -1.931     0.200
    61.180     0.239     0.200
    62.005     0.588     0.200
    62.162     1.020     0.200
    62.208    -0.571     0.200
    62.320     2.154     0.200
    62.388     0.435     0.200
    62.449     1.101     0.200
    62.452    -0.533     0.200
    62.454    -0.067     0.200
    62.424    -0.443     0.200
    62.424    -0.244     0.200
    62.435    -0.717     0.200
    62.633    -1.738     0.200
    62.649     1.425     0.200
    62.691     1.040     0.200
    62.771     0.789     0.200
    62.834     0.390     0.200
    62.951     0.779     0.200
    63.018     0.856     0.200
    63.328    -0.810     0.200
    63.589    -1.210     0.200
    63.692     0.518     0.200
    63.803    -1.484     0.200
    63.846     0.640     0.200
    63.963     1.194     0.200
    64.071     0.802     0.200
    64.191     0.651     0.200
    64.197     0.160     0.200
    64.557    -1.117     0.200
    64.662    -0.978     0.200
    64.662    -1.306     0.200
    64.695     0.924     0.200
    64.763    -1.629     0.200
    64.763    -1.461     0.200
    64.770     1.097     0.200
    64.770     0.495     0.200
    64.770    -0.431     0.200
    64.812     1.573     0.200
    64.877    -2.372     0.200
    64.871     0.700     0.200
    64.961    -0.656     0.200
    64.968     0.638     0.200
    65.026    -0.937     0.200
    65.057     1.178     0.200
    65.100    -1.148     0.200
    65.194     0.792     0.200
    65.202     0.588     0.200
    65.335     1.079     0.200
    65.388     1.158     0.200
    65.432    -0.101     0.200
    65.432     0.200     0.200
    65.430     0.610     0.200
    65.506     0.641     0.200
    65.550    -0.859     0.200
    65.550     0.255     0.200
    65.695     0.686     0.200
    65.831    -0.767     0.200
    65.922    -0.850     0.200
    66.078     0.190     0.200
    66.100     0.726     0.200
    66.186     0.927     0.200
    66.244    -3.618     0.200
    66.219     0.941     0.200
    66.162    -0.242     0.200
    66.332     0.882     0.200
    66.573    -0.922     0.200
    66.629     1.061     0.200
    66.669     1.022     0.200
    66.715     0.986     0.200
    66.760    -0.983     0.200
    66.844     1.040     0.200
    66.870     0.357     0.200
    66.891     1.182     0.200
    67.012    -0.810     0.200
    67.003     0.341     0.200
    67.046     0.938     0.200
    67.290     1.045     0.200
    67.310     0.880     0.200
    67.379     1.136     0.200
    67.449     1.241     0.200
    67.563     0.571     0.200
    67.626     0.423     0.200
    67.676     0.847     0.200
    67.800     0.629     0.200
    67.816     0.197     0.200
    68.112     0.162     0.200
    68.133     0.021     0.200
    68.201     0.289     0.200
    68.213     0.315     0.200
    68.223     0.254     0.200
    68.326    -1.291     0.200
    68.417    -1.588     0.200
    68.422     1.200     0.200
    68.436     0.123     0.200
    68.436     1.224     0.200
    68.436     0.795     0.200
    68.436     0.494     0.200
    68.436    -0.116     0.200
    68.400     0.701     0.200
    68.456     0.222     0.200
    68.447     0.467     0.200
    68.490     0.683     0.200
    68.588    -0.392     0.200
    68.621     0.161     0.200
    68.657    -0.417     0.200
    68.644    -0.476     0.200
    68.763    -0.397     0.200
    68.832    -0.412     0.200
    68.843    -0.421     0.200
    68.880    -2.141     0.200
    68.901     0.124     0.200
    68.948    -0.367     0.200
    68.965     0.210     0.200
    69.034    -1.098     0.200
    69.218     0.405     0.200
    69.237     0.359     0.200
    69.234     1.182     0.200
    69.271     0.355     0.200
    69.321     0.504     0.200
    69.328     0.905     0.200
    69.460     0.557     0.200
    69.551     0.351     0.200
    69.551     0.808     0.200
    69.563    -0.085     0.200
    69.553     0.843     0.200
    69.550     0.086     0.200
    69.570     0.328     0.200
    69.596     0.829     0.200
    69.704     0.266     0.200
    69.797    -0.292     0.200
    69.817    -1.251     0.200
    69.787     0.394     0.200
    69.825    -1.280     0.200
    69.825    -1.295     0.200
    69.844    -0.379     0.200
    69.904     0.107     0.200
    69.875     0.414     0.200
    69.977    -1.562     0.200
    69.939     0.137     0.200
    70.032    -0.880     0.200
    69.994    -0.316     0.200
    70.155     0.472     0.200
    70.222     0.627     0.200
    70.304     0.008     0.200
    70.300     0.512     0.200
    70.340    -1.330     0.200
    70.374     0.852     0.200
    70.547    -0.692     0.200
    70.609     0.270     0.200
    70.751     0.136     0.200
    70.804    -0.754     0.200
    70.844     0.173     0.200
    70.865    -0.635     0.200
    70.915    -1.053     0.200
    70.895     1.744     0.200
    70.927    -1.700     0.200
    70.927    -1.040     0.200
    70.909     0.289     0.200
    71.004     0.184     0.200
    71.096    -0.635     0.200
    71.066     1.077     0.200
    71.140    -1.092     0.200
    71.279     1.119     0.200
    71.267     0.442     0.200
    71.330     1.688     0.200
    71.428    -0.310     0.200
    71.424     0.192     0.200
    71.428     1.679     0.200
    71.459     0.083     0.200
    71.483     0.921     0.200
    71.507     1.825     0.200
    71.507     1.485     0.200
    71.549     0.405     0.200
    71.640    -0.524     0.200
    71.647     1.491     0.200
    71.669     0.628     0.200
    71.690     0.462     0.200
    71.690     0.353     0.200
    71.721     0.553     0.200
    71.763     1.648     0.200
    71.782     0.127     0.200
    71.797    -0.188     0.200
    71.819     1.107     0.200
    71.843     0.536     0.200
    71.935    -0.422     0.200
    71.902     1.321     0.200
    71.949    -0.060     0.200
    71.986    -0.261     0.200
    71.982    -0.040     0.200
    71.992    -0.210     0.200
    72.040    -0.174     0.200
    72.010     0.814     0.200
    72.012     0.865     0.200
    72.040     0.652     0.200
    72.061     0.830     0.200
    72.111     0.399     0.200
    72.158     1.110     0.200
    72.178     0.266     0.200
    72.200     1.105     0.200
    72.203     1.123     0.200
    72.228     0.357     0.200
    72.228    -0.264     0.200
    72.243     0.588     0.200
    72.307     1.172     0.200
    72.393     0.775     0.200
    72.426     0.031     0.200
    72.465    -0.442     0.200
    72.501    -0.185     0.200
    72.497    -0.522     0.200
    72.557    -0.386     0.200
    72.557     0.462     0.200
    72.630    -0.620     0.200
    72.604     1.207     0.200
    72.624     0.411     0.200
    72.710     0.636     0.200
    72.713    -0.014     0.200
    72.808     1.487     0.200
    72.871     1.120     0.200
    72.884     1.034     0.200
    72.918     1.183     0.200
    73.039     0.133     0.200
    73.030    -0.488     0.200
    73.030     0.997     0.200
    73.042     1.167     0.200
    73.069     1.252     0.200
    73.107     0.953     0.200
    73.107     1.391     0.200
    73.144    -0.341     0.200
    73.208     0.040     0.200
    73.169     0.835     0.200
    73.175     0.777     0.200
    73.220     0.618     0.200
    73.337     0.203     0.200
    73.405    -1.103     0.200
    73.359     0.615     0.200
    73.423     0.274     0.200
    73.445     0.296     0.200
    73.517     0.252     0.200
    73.613     0.687     0.200
    73.688     1.230     0.200
    73.710    -0.289     0.200
    73.730    -0.012     0.200
    73.730     0.089     0.200
    73.752    -1.738     0.200
    73.756     0.223     0.200
    73.793    -0.378     0.200
    73.805     0.173     0.200
    73.806     0.140     0.200
    73.871    -1.235     0.200
    73.830     0.903     0.200
    73.849     0.326     0.200
    73.893    -0.489     0.200
    73.966     0.451     0.200
    73.976     0.120     0.200
    74.015    -0.377     0.200
    73.984     0.889     0.200
    74.034     1.434     0.200
    74.059     1.077     0.200
    74.135     0.120     0.200
    74.205    -0.578     0.200
    74.229    -0.055     0.200
    74.235     0.219     0.200
    74.266    -4.050     0.200
    74.256    -0.111     0.200
    74.280     0.003     0.200
    74.290     0.954     0.200
    74.326     0.290     0.200
    74.381    -0.255     0.200
    74.430     1.477     0.200
    74.459    -1.058     0.200
    74.453    -0.407     0.200
    74.586     0.003     0.200
    74.586     0.104     0.200
    74.550     0.163     0.200
    74.576     0.116     0.200
    74.593    -0.339     0.200
    74.620    -0.062     0.200
    74.673     0.143     0.200
    74.698     0.836     0.200
    74.691     0.789     0.200
    74.730     0.379     0.200
    74.856     0.249     0.200
    74.856    -0.364     0.200
    74.877    -0.134     0.200
    74.904    -0.861     0.200
    74.879     1.102     0.200
    74.962    -0.064     0.200
    74.988    -0.207     0.200
    75.008    -0.110     0.200
    75.068     0.720     0.200
    75.185     0.972     0.200
    75.182     0.766     0.200
    75.215    -0.090     0.200
    75.239     1.354     0.200
    75.276    -0.367     0.200
    75.341    -0.048     0.200
    75.368    -0.103     0.200
    75.376     0.155     0.200
    75.347    -0.185     0.200
    75.390     1.274     0.200
    75.405     0.039     0.200
    75.485     0.028     0.200
    75.517    -0.456     0.200
    75.528     0.379     0.200
    75.511    -0.047     0.200
    75.525    -0.193     0.200
    75.577     0.402     0.200
    75.568    -0.619     0.200
    75.631     1.165     0.200
    75.612     0.630     0.200
    75.657    -0.068     0.200
    75.623     1.127     0.200
    75.658    -0.397     0.200
    75.643     0.441     0.200
    75.659     0.602     0.200
    75.659     0.075     0.200
    75.721    -0.621     0.200
    75.721    -0.820     0.200
    75.740    -0.092     0.200
    75.774     0.377     0.200
    75.786     0.510     0.200
    75.758    -0.036     0.200
    75.794     0.563     0.200
    75.750     0.899     0.200
    75.781     0.307     0.200
    75.814     0.050     0.200
    75.919    -0.188     0.200
    75.932    -0.221     0.200
    75.902     0.199     0.200
    75.938    -0.371     0.200
    75.938    -1.848     0.200
    75.962     0.653     0.200
    75.961     0.103     0.200
    75.991     0.138     0.200
    76.003     0.698     0.200
    76.162     0.870     0.200
    76.178     0.081     0.200
    76.136     0.991     0.200
    76.159    -0.072     0.200
    76.185     0.334     0.200
    76.231     0.523     0.200
    76.278     0.308     0.200
    76.284    -0.387     0.200
    76.285    -0.230     0.200
    76.285    -0.129     0.200
    76.301     0.129     0.200
    76.267     1.139     0.200
    76.280     2.047     0.200
    76.300    -0.078     0.200
    76.329     1.021     0.200
    76.339    -0.437     0.200
    76.334     0.070     0.200
    76.372     1.379     0.200
    76.367     0.288     0.200
    76.391     1.182     0.200
    76.391     0.420     0.200
    76.418     1.440     0.200
    76.507    -1.065     0.200
    76.542     0.672     0.200
    76.604    -1.612     0.200
    76.588     1.028     0.200
    76.631    -0.189     0.200
    76.631     0.413     0.200
    76.644     0.540     0.200
    76.660    -0.149     0.200
    76.664    -0.072     0.200
    76.669     0.199     0.200
    76.669     0.699     0.200
    76.669     1.020     0.200
    76.648     0.301     0.200
    76.661     0.273     0.200
    76.700    -0.277     0.200
    76.683     0.062     0.200
    76.685     0.220     0.200
    76.717     0.232     0.200
    76.750    -2.269     0.200
    76.771     0.826     0.200
    76.810    -1.397     0.200
    76.822     0.534     0.200
    76.871     0.331     0.200
    76.852     0.799     0.200
    76.892     2.242     0.200
    76.941    -0.754     0.200
    76.997    -0.876     0.200
    77.003     0.924     0.200
    77.003     1.049     0.200
    77.034     0.694     0.200
    77.027     0.857     0.200
    77.092    -0.327     0.200
    77.059    -0.082     0.200
    77.099    -0.519     0.200
    77.099     0.782     0.200
    77.099     0.180     0.200
    77.102     0.066     0.200
    77.116    -1.044     0.200
    77.152    -0.718     0.200
    77.157    -0.644     0.200
    77.157    -0.441     0.200
    77.152    -0.462     0.200
    77.199    -0.420     0.200
    77.198    -0.175     0.200
    77.178    -0.009     0.200
    77.201    -2.215     0.200
    77.219     0.426     0.200
    77.212    -0.612     0.200
    77.233     0.058     0.200
    77.307    -0.297     0.200
    77.316    -0.633     0.200
    77.337    -0.201     0.200
    77.340     0.231     0.200
    77.340     0.974     0.200
    77.382    -0.360     0.200
    77.382     0.597     0.200
    77.385    -0.471     0.200
    77.403    -0.725     0.200
    77.431     1.323     0.200
    77.488     0.108     0.200
    77.485    -0.027     0.200
    77.514     0.867     0.200
    77.500    -0.555     0.200
    77.531     0.466     0.200
    77.531     0.845     0.200
    77.588     0.348     0.200
    77.567    -0.082     0.200
    77.591     0.988     0.200
    77.609    -0.069     0.200
    77.619    -0.426     0.200
    77.605    -0.538     0.200
    77.606    -0.607     0.200
    77.643    -0.160     0.200
    77.663     0.707     0.200
    77.679    -0.451     0.200
    77.655    -0.126     0.200
    77.657    -0.469     0.200
    77.741     0.093     0.200
    77.818    -0.534     0.200
    77.866     1.266     0.200
    77.922    -1.142     0.200
    77.924    -0.746     0.200
    77.954    -0.252     0.200
    77.967    -0.477     0.200
    77.970     0.311     0.200
    77.997     1.732     0.200
    77.977     0.585     0.200
    78.002     0.668     0.200
    78.038    -0.296     0.200
    78.034     0.027     0.200
    78.080    -0.345     0.200
    78.082    -1.306     0.200
    78.071    -0.142     0.200
    78.071    -0.849     0.200
    78.103    -0.565     0.200
    78.103    -0.116     0.200
    78.110    -0.349     0.200
    78.082    -0.240     0.200
    78.134    -0.333     0.200
    78.109    -0.046     0.200
    78.135    -0.529     0.200
    78.142    -0.482     0.200
    78.109     1.304     0.200
    78.109     1.722     0.200
    78.149     0.033     0.200
    78.170    -0.230     0.200
    78.200    -0.398     0.200
    78.215    -0.121     0.200
    78.185     0.750     0.200
    78.185     1.032     0.200
    78.233    -0.337     0.200
    78.258    -0.523     0.200
    78.252     0.182     0.200
    78.293    -4.156     0.200
    78.289     0.656     0.200
    78.274     0.371     0.200
    78.298    -0.235     0.200
    78.344    -0.384     0.200
    78.359     0.221     0.200
    78.363    -0.066     0.200
    78.368    -0.180     0.200
    78.392     0.082     0.200
    78.427    -0.351     0.200
    78.459    -0.154     0.200
    78.456     0.736     0.200
    78.429    -0.338     0.200
    78.443    -0.728     0.200
    78.561    -0.291     0.200
    78.584    -1.159     0.200
    78.537     0.205     0.200
    78.610    -0.813     0.200
    78.610    -1.915     0.200
    78.610    -0.614     0.200
    78.508     0.845     0.200
    78.684     0.377     0.200
    78.705     0.120     0.200
    78.706    -0.444     0.200
    78.706     0.056     0.200
    78.715    -0.958     0.200
    78.743    -0.936     0.200
    78.727     0.637     0.200
    78.736    -0.893     0.200
    78.733    -0.632     0.200
    78.735    -0.326     0.200
    78.737     0.340     0.200
    78.774     0.324     0.200
    78.817    -0.787     0.200
    78.821    -0.371     0.200
    78.821     0.849     0.200
    78.830    -1.611     0.200
    78.831    -0.437     0.200
    78.878    -0.496     0.200
    78.891    -0.257     0.200
    78.891    -0.554     0.200
    78.855     0.798     0.200
    78.855     0.524     0.200
    78.875     0.355     0.200
    78.872     0.661     0.200
    78.939    -0.831     0.200
    78.963     0.103     0.200
    78.976     0.349     0.200
    79.038    -0.704     0.200
    79.051    -0.221     0.200
    79.051    -0.753     0.200
    79.072     1.116     0.200
    79.084    -0.240     0.200
    79.130     0.140     0.200
    79.102     0.988     0.200
    79.148    -0.541     0.200
    79.145     0.343     0.200
    79.218     0.355     0.200
    79.209    -0.178     0.200
    79.237    -0.386     0.200
    79.248    -0.286     0.200
    79.271     0.468     0.200
    79.368     0.438     0.200
    79.378    -0.715     0.200
    79.438     0.458     0.200
    79.453    -0.089     0.200
    79.461    -0.236     0.200
    79.477     0.069     0.200
    79.511    -0.255     0.200
    79.511    -1.036     0.200
    79.511     0.464     0.200
    79.530     0.074     0.200
    79.519    -0.017     0.200
    79.556    -0.066     0.200
    79.535    -0.474     0.200
    79.593     0.417     0.200
    79.550     0.947     0.200
    79.603     0.423     0.200
    79.653     0.390     0.200
    79.590     0.136     0.200
    79.659     0.456     0.200
    79.645    -0.423     0.200
    79.673    -0.361     0.200
    79.670    -0.198     0.200
    79.684    -0.281     0.200
    79.801    -0.011     0.200
    79.878    -0.768     0.200
    79.895     0.683     0.200
    79.895     1.003     0.200
    79.931    -0.158     0.200
    79.906    -0.649     0.200
    79.952    -0.532     0.200
    79.953     0.257     0.200
    80.009    -0.237     0.200
    80.009    -0.436     0.200
    80.055    -1.038     0.200
    80.040    -0.005     0.200
    80.073    -2.863     0.200
    80.061     0.234     0.200
    80.089    -0.667     0.200
    80.089    -0.769     0.200
    80.095    -0.451     0.200
    80.067     0.158     0.200
    80.110    -0.630     0.200
    80.113    -0.387     0.200
    80.114    -0.065     0.200
    80.097     0.215     0.200
    80.094     0.425     0.200
    80.096     0.385     0.200
    80.145     0.285     0.200
    80.156     0.274     0.200
    80.164    -0.408     0.200
    80.211     0.077     0.200
    80.262     0.202     0.200
    80.270    -0.038     0.200
    80.281     0.607     0.200
    80.321     1.036     0.200
    80.294     0.029     0.200
    80.294    -0.350     0.200
    80.322     0.363     0.200
    80.322     0.174     0.200
    80.373     0.010     0.200
    80.384     0.440     0.200
    80.408    -0.029     0.200
    80.447    -0.588     0.200
    80.462    -1.070     0.200
    80.462    -0.281     0.200
    80.468     0.033     0.200
    80.443    -0.004     0.200
    80.479     0.465     0.200
    80.483    -0.153     0.200
    80.508     0.201     0.200
    80.517    -1.879     0.200
    80.556    -0.413     0.200
    80.579    -0.399     0.200
    80.615    -0.293     0.200
    80.615     0.008     0.200
    80.628    -0.830     0.200
    80.632    -0.232     0.200
    80.657    -0.576     0.200
    80.641     1.188     0.200
    80.693    -0.409     0.200
    80.715    -0.708     0.200
    80.749    -0.836     0.200
    80.742     0.235     0.200
    80.761    -0.030     0.200
    80.758     1.284     0.200
    80.805    -1.019     0.200
    80.830    -0.582     0.200
    80.801     0.134     0.200
    80.818     0.579     0.200
    80.858    -1.287     0.200
    80.881    -0.612     0.200
    80.851    -0.439     0.200
    80.887     0.256     0.200
    80.898    -1.151     0.200
    80.927    -0.475     0.200
    80.927    -0.655     0.200
    80.927     0.745     0.200
    80.946    -0.095     0.200
    80.968    -0.675     0.200
    80.974     1.130     0.200
    80.975     0.089     0.200
    80.982     0.078     0.200
    80.946     0.394     0.200
    81.006     0.223     0.200
    81.038    -0.718     0.200
    81.064    -0.437     0.200
    81.067    -1.316     0.200
    81.073    -0.824     0.200
    81.092    -0.036     0.200
    81.118    -0.193     0.200
    81.129    -0.142     0.200
    81.123    -0.217     0.200
    81.143    -0.767     0.200
    81.191    -0.260     0.200
    81.201    -0.413     0.200
    81.174    -0.199     0.200
    81.172     0.164     0.200
    81.216     1.309     0.200
    81.216    -0.492     0.200
    81.191    -0.259     0.200
    81.191    -0.040     0.200
    81.219     0.087     0.200
    81.258    -0.322     0.200
    81.214     1.001     0.200
    81.214    -0.632     0.200
    81.227     0.073     0.200
    81.287     0.184     0.200
    81.287    -0.367     0.200
    81.287    -0.066     0.200
    81.314    -0.811     0.200
    81.314     0.091     0.200
    81.314    -0.405     0.200
    81.292     0.319     0.200
    81.307    -0.384     0.200
    81.434    -0.044     0.200
    81.434     0.155     0.200
    81.453     0.053     0.200
    81.466    -0.915     0.200
    81.521    -1.003     0.200
    81.530    -0.363     0.200
    81.559    -0.582     0.200
    81.577    -0.043     0.200
    81.604    -0.942     0.200
    81.627    -0.155     0.200
    81.645    -0.460     0.200
    81.671    -0.295     0.200
    81.669    -0.304     0.200
    81.679     0.132     0.200
    81.692    -0.274     0.200
    81.710    -0.608     0.200
    81.769     0.715     0.200
    81.851     0.955     0.200
    81.896    -1.279     0.200
    81.896    -0.279     0.200
    81.904    -0.823     0.200
    81.904    -2.925     0.200
    81.913    -0.472     0.200
    81.918    -0.596     0.200
    81.918    -0.397     0.200
    81.944    -0.281     0.200
    81.981    -1.029     0.200
    82.015    -0.704     0.200
    82.041     0.321     0.200
    82.051    -0.396     0.200
    82.035    -0.434     0.200
    82.052     0.300     0.200
    82.092    -0.510     0.200
    82.092    -0.311     0.200
    82.104    -0.372     0.200
    82.104    -0.673     0.200
    82.133    -0.525     0.200
    82.133    -2.025     0.200
    82.128    -0.089     0.200
    82.199    -1.067     0.200
    82.205    -0.097     0.200
    82.326     0.166     0.200
    82.361    -0.215     0.200
    82.361    -0.715     0.200
    82.404    -4.940     0.200
    82.444    -3.648     0.200
    82.444    -0.750     0.200
    82.465    -0.258     0.200
    82.465    -0.758     0.200
    82.441    -0.258     0.200
    82.510    -0.431     0.200
    82.479     0.086     0.200
    82.501     0.391     0.200
    82.541    -1.654     0.200
    82.541    -1.454     0.200
    82.540     0.456     0.200
    82.540     0.206     0.200
    82.545    -0.097     0.200
    82.546    -0.192     0.200
    82.577    -0.201     0.200
    82.702    -1.990     0.200
    82.745    -1.214     0.200
    82.799    -1.493     0.200
    82.829    -1.149     0.200
    82.829    -1.250     0.200
    82.838     0.007     0.200
    82.873     0.125     0.200
    82.873    -0.074     0.200
    82.862    -0.419     0.200
    82.875     0.389     0.200
    82.905    -1.043     0.200
    82.905    -1.145     0.200
    82.942    -1.233     0.200
    82.944    -1.243     0.200
    82.956    -1.104     0.200
    83.009     0.111     0.200
    83.043     0.045     0.200
    83.043     0.244     0.200
    83.049    -0.075     0.200
    83.050     0.610     0.200
    83.106    -2.081     0.200
    83.141    -0.759     0.200
    83.141    -0.560     0.200
    83.163    -1.376     0.200
    83.167    -1.395     0.200
    83.167    -1.696     0.200
    83.173    -1.425     0.200
    83.239    -1.768     0.200
    83.239    -2.467     0.200
    83.238     1.131     0.200
    83.283    -0.189     0.200
    83.325    -0.039     0.200
    83.327    -0.218     0.200
    83.327    -0.116     0.200
    83.355    -0.191     0.200
    83.377     0.022     0.200
    83.377    -0.478     0.200
    83.378    -0.981     0.200
    83.378    -1.082     0.200
    83.384    -1.510     0.200
    83.384    -2.209     0.200
    83.392    -0.655     0.200
    83.392    -0.553     0.200
    83.362     0.623     0.200
    83.403    -0.608     0.200
    83.403    -0.808     0.200
    83.378     0.567     0.200
    83.468    -0.444     0.200
    83.468    -0.745     0.200
    83.494    -2.078     0.200
    83.494    -2.277     0.200
    83.510    -0.158     0.200
    83.510    -0.658     0.200
    83.512     0.727     0.200
    83.575    -0.492     0.200
    83.575    -0.793     0.200
    83.624    -1.242     0.200
    83.624    -1.043     0.200
    83.639    -1.319     0.200
    83.697    -0.116     0.200
    83.697    -1.015     0.200
    83.710     0.315     0.200
    83.727     0.310     0.200
    83.810    -0.193     0.200
    83.810    -0.693     0.200
    83.782     0.829     0.200
    83.808     0.088     0.200
    83.821     0.365     0.200
    83.827     0.397     0.200
    83.864     0.244     0.200
    83.911    -0.210     0.200
    83.931    -0.312     0.200
    83.931    -0.511     0.200
    83.929    -0.801     0.200
    83.973    -0.023     0.200
    83.973    -0.324     0.200
    84.038    -0.857     0.200
    84.038    -1.158     0.200
    84.049    -0.914     0.200
    84.077    -0.057     0.200
    84.077     0.142     0.200
    84.128     0.513     0.200
    84.128    -0.054     0.200
    84.144     0.082     0.200
    84.189    -0.125     0.200
    84.176     0.597     0.200
    84.222     0.707     0.200
    84.198     0.667     0.200
    84.207     0.823     0.200
    84.249    -1.428     0.200
    84.249    -1.530     0.200
    84.255     0.042     0.200
    84.255    -0.356     0.200
    84.229     0.880     0.200
    84.231     0.538     0.200
    84.272    -0.043     0.200
    84.272    -0.242     0.200
    84.257     0.443     0.200
    84.300    -0.945     0.200
    84.300    -1.187     0.200
    84.318    -0.675     0.200
    84.318    -0.276     0.200
    84.295     0.240     0.200
    84.415    -0.770     0.200
    84.415    -0.970     0.200
    84.501     0.073     0.200
    84.509     0.602     0.200
    84.537    -0.886     0.200
    84.547     0.067     0.200
    84.547    -0.132     0.200
    84.519     0.495     0.200
    84.537     0.408     0.200
    84.580     0.096     0.200
    84.580     0.397     0.200
    84.564     0.710     0.200
    84.595     1.028     0.200
    84.595     0.255     0.200
    84.598     0.756     0.200
    84.605     0.936     0.200
    84.656     0.515     0.200
    84.702    -1.016     0.200
    84.707    -0.242     0.200
    84.707    -1.043     0.200
    84.728    -1.348     0.200
    84.728    -1.547     0.200
    84.712     0.350     0.200
    84.749    -1.052     0.200
    84.918    -0.067     0.200
    84.914     0.556     0.200
    84.940     0.489     0.200
    85.007     1.024     0.200
    85.064     0.519     0.200
    85.097     0.247     0.200
    85.156    -1.471     0.200
    85.123     0.830     0.200
    85.140     0.803     0.200
    85.363     0.828     0.200
    85.382     0.605     0.200
    85.402     0.368     0.200
    85.407     0.667     0.200
    85.438     0.513     0.200
    85.442     0.142     0.200
    85.453     0.426     0.200
    85.455     0.395     0.200
    85.581     0.828     0.200
    85.747    -0.138     0.200
    85.794    -0.111     0.200
    85.804     0.297     0.200
    85.850     0.507     0.200
    85.861     0.786     0.200
    85.861     0.400     0.200
    85.891     0.474     0.200
    85.902     0.595     0.200
    85.966     0.325     0.200
    85.975    -0.047     0.200
    85.997    -0.175     0.200
    86.019    -0.975     0.200
    86.035     0.168     0.200
    86.064     0.382     0.200
    86.174     0.564     0.200
    86.185    -0.243     0.200
    86.222     0.039     0.200
    86.242     0.776     0.200
    86.250     0.745     0.200
    86.277     0.780     0.200
    86.318     0.471     0.200
    86.325    -0.004     0.200
    86.402     0.343     0.200
    86.410     0.068     0.200
    86.640    -0.629     0.200
    86.675     0.553     0.200
    86.724     0.214     0.200
    86.730     0.800     0.200
    86.734     0.582     0.200
    86.744     0.777     0.200
    86.738     0.519     0.200
    86.764     0.492     0.200
    86.895     0.548     0.200
    87.085     0.103     0.200
    87.164     0.545     0.200
    87.184     0.756     0.200
    87.205     0.576     0.200
    87.247    -0.461     0.200
    87.376     0.397     0.200
    87.428     0.336     0.200
    87.574     0.597     0.200
    87.580     0.132     0.200
    87.616     0.729     0.200
    87.616     0.694     0.200
    87.637    -0.254     0.200
    87.637     0.418     0.200
    87.727     0.663     0.200
    87.845     0.568     0.200
    87.896     0.203     0.200
    88.119     0.496     0.200
    88.180     0.218     0.200
    88.469     0.244     0.200
    88.499     0.768     0.200
    88.565    -0.137     0.200
    88.588     0.922     0.200
    88.718     0.201     0.200
    88.842     0.718     0.200
    88.918     0.814     0.200
    89.181    -0.544     0.200
    89.130     0.956     0.200
    89.486     0.418     0.200
    89.534    -0.517     0.200
    89.639     0.935     0.200
    89.684     0.857     0.200
    89.733     1.599     0.200
    89.736     0.762     0.200
    89.829     1.068     0.200
    90.026     0.306     0.200
    90.309     0.289     0.200
    90.473     0.351     0.200
    90.385     2.793     0.200
    90.587     1.319     0.200
    90.654     0.449     0.200
    90.679     0.587     0.200
    90.765    -0.712     0.200
    90.808     0.483     0.200
    91.253     0.780     0.200
    91.410     0.272     0.200
    91.556    -0.303     0.200
    91.953    -0.142     0.200
    92.221    -0.278     0.200
    92.394    -0.679     0.200
    92.628    -0.354     0.200
    92.644    -0.834     0.200
    92.714    -0.158     0.200
    92.904    -0.162     0.200
    93.091    -0.399     0.200
    93.285    -0.986     0.200
    93.329    -0.488     0.200
    93.482    -0.194     0.200
    93.482    -0.514     0.200
    93.983    -0.597     0.200
    94.342    -0.543     0.200
    94.911    -0.850     0.200
    95.403    -0.498     0.200
    95.780    -0.317     0.200
    95.889    -0.411     0.200
    96.055    -0.128     0.200
    96.055    -0.367     0.200
    96.197    -0.313     0.200
    96.316    -0.254     0.200
    21.559    -1.201     0.200
    25.807    -0.024     0.200
    39.076    -0.990     0.200
    42.115    -0.558     0.200
    44.791    -1.104     0.200
    49.480    -0.868     0.200
    62.306    -1.105     0.200
    64.542    -1.448     0.200
    66.034    -0.276     0.200
    68.064     0.767     0.200
    69.654    -1.635     0.200
    69.654    -1.109     0.200
    71.383     1.050     0.200
    73.575    -0.867     0.200
    86.431    -0.240     0.200
    17.667     2.176     0.200
    19.147    -0.674     0.200
    20.408    -0.677     0.200
    20.849    -0.106     0.200
    21.075    -1.143     0.200
    21.075    -0.448     0.200
    22.299     2.231     0.200
    22.797    -3.959     0.200
    24.538    -0.762     0.200
    24.982    -0.560     0.200
    27.021    -0.955     0.200
    29.495    -2.824     0.200
    32.690     2.219     0.200
    36.275     1.589     0.200
    38.195    -0.103     0.200
    38.196    -0.812     0.200
    38.196    -0.109     0.200
    38.515     0.811     0.200
    39.007    -0.719     0.200
    41.274    -0.804     0.200
    41.274    -0.175     0.200
    41.274    -0.175     0.200
    41.274    -0.535     0.200
    42.458    -0.789     0.200
    43.065     0.570     0.200
    43.272    -1.304     0.200
    43.289    -2.435     0.200
    43.309     0.695     0.200
    43.309     0.695     0.200
    43.324    -0.078     0.200
    44.199     0.237     0.200
    44.621    -2.243     0.200
    44.621    -1.038     0.200
    44.621    -1.038     0.200
    44.625    -1.476     0.200
    45.851     0.691     0.200
    46.363     0.568     0.200
    46.855    -0.596     0.200
    46.855    -0.057     0.200
    46.884     0.486     0.200
    46.892     0.317     0.200
    47.082     0.735     0.200
    47.391     0.120     0.200
    47.419     0.212     0.200
    47.424     0.565     0.200
    47.620     0.341     0.200
    47.746     0.070     0.200
    47.939    -0.026     0.200
    47.939     0.138     0.200
    48.198     0.567     0.200
    49.748     1.692     0.200
    50.881    -0.094     0.200
    51.967    -0.378     0.200
    52.094    -0.768     0.200
    52.094    -0.510     0.200
    55.522    -0.659     0.200
    56.258     0.485     0.200
    56.942    -1.694     0.200
    58.555    -1.680     0.200
    58.555    -1.681     0.200
    58.778    -0.346     0.200
    58.778    -0.346     0.200
    58.875    -2.062     0.200
    61.149    -0.391     0.200
    62.404    -0.010     0.200
    62.848    -0.783     0.200
    62.858    -0.679     0.200
    62.858    -0.679     0.200
    62.858    -0.250     0.200
    63.477    -1.459     0.200
    63.682    -1.516     0.200
    63.682    -1.516     0.200
    63.886    -1.360     0.200
    64.695    -1.357     0.200
    64.839    -0.997     0.200
    66.579    -0.088     0.200
    66.584     0.295     0.200
    66.585     0.286     0.200
    66.923     0.981     0.200
    67.134     0.010     0.200
    67.161     0.463     0.200
    67.161     0.737     0.200
    67.180     0.499     0.200
    67.178    -1.941     0.200
    67.576     0.741     0.200
    67.888     1.071     0.200
    67.994     0.862     0.200
    68.080     0.858     0.200
    68.277     0.951     0.200
    68.304     1.758     0.200
    68.515     1.436     0.200
    68.819    -1.758     0.200
    68.819    -0.712     0.200
    68.819    -0.712     0.200
    69.725    -0.889     0.200
    69.725    -0.866     0.200
    69.737    -0.541     0.200
    69.737    -0.377     0.200
    69.729     0.457     0.200
    69.988     0.836     0.200
    70.142    -0.187     0.200
    70.215     0.812     0.200
    70.568     0.863     0.200
    71.515     0.692     0.200
    71.515     0.700     0.200
    71.801    -0.149     0.200
    72.117     1.174     0.200
    72.278     1.132     0.200
    72.483     1.518     0.200
    72.933     2.946     0.200
    73.181     0.476     0.200
    73.287     1.280     0.200
    73.420    -0.338     0.200
    73.546     1.222     0.200
    73.582     0.239     0.200
    73.582     0.058     0.200
    73.582     0.058     0.200
    73.768    -0.013     0.200
    74.129     0.501     0.200
    74.125     1.664     0.200
    74.215     0.701     0.200
    74.222    -0.132     0.200
    74.222     0.017     0.200
    74.400     0.151     0.200
    74.619    -0.544     0.200
    75.033    -0.513     0.200
    75.163     0.209     0.200
    75.176     1.031     0.200
    75.199     0.704     0.200
    75.205     1.217     0.200
    75.433    -1.749     0.200
    75.494     0.603     0.200
    75.494    -0.756     0.200
    75.474     0.219     0.200
    75.538     0.554     0.200
    75.570     0.373     0.200
    75.948     0.810     0.200
    75.948     0.709     0.200
    76.054     0.002     0.200
    76.054     0.104     0.200
    76.085     0.430     0.200
    76.247     0.408     0.200
    76.526     0.825     0.200
    76.703     0.218     0.200
    77.095     2.275     0.200
    77.589    -0.653     0.200
    77.589    -0.052     0.200
    77.779     1.285     0.200
    78.032    -0.510     0.200
    78.510     0.217     0.200
    78.594     1.572     0.200
    78.645     0.260     0.200
    79.320    -0.159     0.200
    79.324     1.212     0.200
    80.817     0.576     0.200
    80.928    -0.429     0.200
    83.794     0.433     0.200
    86.532     0.188     0.200
    86.532    -0.238     0.200
    26.347    -0.715     0.200
    39.532    -0.509     0.200
    42.639    -0.131     0.200
    44.388    -0.776     0.200
    49.128    -1.259     0.200
    58.624    -1.431     0.200
    64.788    -1.398     0.200
    69.843    -1.266     0.200
    73.082     0.695     0.200
    78.919    -1.018     0.200
    85.900     0.925     0.200
    17.960    -1.553     0.200
    19.559     0.275     0.200
    20.262    -1.417     0.200
    20.273    -1.836     0.200
    20.867    -2.152     0.200
    21.290    -3.496     0.200
    21.290    -3.214     0.200
    21.398    -2.684     0.200
    21.398    -2.559     0.200
    21.694     0.079     0.200
    23.300     0.093     0.200
    23.467     1.467     0.200
    23.959    -4.224     0.200
    24.271     0.127     0.200
    24.751    -0.679     0.200
    25.794    -0.298     0.200
    26.231    -0.385     0.200
    26.237    -0.166     0.200
    27.857    -0.345     0.200
    28.105    -0.254     0.200
    28.105    -0.055     0.200
    28.105     0.385     0.200
    28.278    -0.791     0.200
    29.753     0.222     0.200
    30.239    -1.370     0.200
    30.239    -0.839     0.200
    30.743     0.680     0.200
    32.505     0.401     0.200
    33.188    -1.068     0.200
    33.574     2.175     0.200
    35.731    -0.036     0.200
    37.190     1.636     0.200
    38.773     1.151     0.200
    39.069    -1.892     0.200
    39.436    -0.612     0.200
    39.436    -0.632     0.200
    39.764     0.148     0.200
    39.795     1.884     0.200
    40.241    -0.211     0.200
    40.479     1.225     0.200
    40.687     0.821     0.200
    42.173    -0.442     0.200
    42.259     0.403     0.200
    42.392     0.924     0.200
    42.476    -0.718     0.200
    42.476    -1.118     0.200
    42.532     0.128     0.200
    42.532    -0.271     0.200
    42.532     0.108     0.200
    42.532     0.105     0.200
    42.733     0.094     0.200
    42.774     0.575     0.200
    42.803     0.849     0.200
    42.956    -0.683     0.200
    43.010    -0.509     0.200
    42.944     1.090     0.200
    43.064     1.003     0.200
    43.105     0.488     0.200
    43.109     1.355     0.200
    43.144     1.069     0.200
    43.187    -1.774     0.200
    43.229     1.284     0.200
    43.520    -0.204     0.200
    43.516     0.777     0.200
    43.648     0.713     0.200
    43.631     1.253     0.200
    43.710     0.416     0.200
    43.793    -0.349     0.200
    43.871    -0.128     0.200
    43.817     0.457     0.200
    43.964    -0.472     0.200
    43.919     0.738     0.200
    43.919     0.238     0.200
    44.038    -0.714     0.200
    44.038    -0.134     0.200
    44.074     0.478     0.200
    44.108     0.827     0.200
    44.158     0.880     0.200
    44.171     0.612     0.200
    44.335     0.909     0.200
    44.458    -1.176     0.200
    44.457    -0.815     0.200
    44.457    -0.494     0.200
    44.463    -1.209     0.200
    45.058     1.261     0.200
    45.132    -1.830     0.200
    45.292     0.992     0.200
    45.553    -1.162     0.200
    45.815    -0.370     0.200
    46.891    -0.652     0.200
    46.955     0.936     0.200
    47.023     0.369     0.200
    47.463     1.186     0.200
    47.542     1.576     0.200
    47.714    -0.958     0.200
    47.791    -0.852     0.200
    47.791    -0.532     0.200
    47.999     0.334     0.200
    48.039    -0.276     0.200
    48.006     0.678     0.200
    48.090    -0.265     0.200
    48.090    -0.066     0.200
    48.337     0.597     0.200
    48.450    -0.438     0.200
    48.517     0.450     0.200
    48.736    -1.695     0.200
    48.744     0.300     0.200
    48.857    -0.064     0.200
    48.881     0.283     0.200
    48.914     1.309     0.200
    48.935    -0.027     0.200
    49.187    -0.585     0.200
    49.194    -0.141     0.200
    49.194     0.109     0.200
    49.510     3.554     0.200
    49.510     2.955     0.200
    49.666    -0.016     0.200
    49.773     0.356     0.200
    49.944     0.496     0.200
    50.091     1.130     0.200
    50.593     0.053     0.200
    51.653    -0.596     0.200
    51.653    -0.096     0.200
    52.076    -0.240     0.200
    52.948    -0.387     0.200
    53.031     1.003     0.200
    53.289    -0.794     0.200
    53.289    -0.393     0.200
    53.289    -1.134     0.200
    55.551    -0.514     0.200
    55.551    -0.473     0.200
    55.662     0.090     0.200
    56.128    -0.842     0.200
    56.761    -0.640     0.200
    57.212    -1.601     0.200
    57.582     1.658     0.200
    58.092     0.037     0.200
    58.648    -1.589     0.200
    58.688    -0.813     0.200
    58.688    -1.518     0.200
    58.962    -0.963     0.200
    59.509    -0.654     0.200
    59.509    -1.833     0.200
    59.509    -0.713     0.200
    60.634    -2.039     0.200
    62.437     0.083     0.200
    62.438    -0.470     0.200
    64.327     0.102     0.200
    64.521     0.465     0.200
    64.516    -1.804     0.200
    64.624    -0.909     0.200
    64.729    -1.341     0.200
    64.730    -1.426     0.200
    65.060    -1.142     0.200
    65.421    -0.080     0.200
    65.790    -1.459     0.200
    65.881    -0.541     0.200
    66.251     1.482     0.200
    66.165     0.183     0.200
    66.539    -1.152     0.200
    66.750     1.361     0.200
    67.594     0.646     0.200
    67.702     0.493     0.200
    67.784     1.081     0.200
    68.290     0.286     0.200
    68.392    -0.053     0.200
    68.392     0.328     0.200
    68.413     0.422     0.200
    68.416    -2.300     0.200
    68.779    -0.665     0.200
    68.810     0.244     0.200
    69.551     1.363     0.200
    69.593    -0.848     0.200
    69.602    -0.903     0.200
    69.733    -0.612     0.200
    69.766    -1.090     0.200
    69.796    -1.249     0.200
    69.796    -1.298     0.200
    69.814     0.512     0.200
    69.891    -1.280     0.200
    69.928    -0.940     0.200
    69.948    -0.561     0.200
    70.049    -0.619     0.200
    70.181     0.891     0.200
    70.181     0.766     0.200
    70.876    -1.066     0.200
    70.888    -0.713     0.200
    70.942     0.982     0.200
    70.942     0.886     0.200
    71.375     0.133     0.200
    71.747     0.446     0.200
    72.426     1.164     0.200
    72.636     0.128     0.200
    72.746     0.844     0.200
    72.952     0.589     0.200
    73.059     0.792     0.200
    73.059     0.532     0.200
    73.075     1.058     0.200
    73.171     0.304     0.200
    73.171     0.463     0.200
    73.171     0.181     0.200
    73.393     1.002     0.200
    73.537     0.308     0.200
    73.779     0.639     0.200
    73.827     0.199     0.200
    73.864     0.863     0.200
    73.864     0.611     0.200
    73.996     0.379     0.200
    74.323     0.891     0.200
    74.400     0.147     0.200
    74.477    -0.806     0.200
    74.477    -0.976     0.200
    74.481     1.472     0.200
    74.549     0.276     0.200
    74.598     0.409     0.200
    74.750     0.189     0.200
    74.909    -0.085     0.200
    74.913     0.745     0.200
    74.923    -0.463     0.200
    74.923     0.016     0.200
    75.031    -0.185     0.200
    75.098     1.009     0.200
    75.145    -0.141     0.200
    75.217    -0.199     0.200
    75.261    -1.430     0.200
    75.301    -1.358     0.200
    75.332    -0.140     0.200
    75.339     0.321     0.200
    75.505    -0.164     0.200
    75.546    -0.871     0.200
    75.587    -1.042     0.200
    75.676    -1.063     0.200
    75.738     0.242     0.200
    76.138    -0.137     0.200
    76.170     0.751     0.200
    76.238    -0.101     0.200
    76.253    -0.054     0.200
    76.250    -0.173     0.200
    76.258     0.303     0.200
    76.258    -0.067     0.200
    76.293     0.187     0.200
    76.338    -1.177     0.200
    76.404    -1.151     0.200
    76.447     1.502     0.200
    76.596    -0.127     0.200
    76.605     0.822     0.200
    76.625     0.106     0.200
    76.629     0.086     0.200
    76.626     0.702     0.200
    76.672    -0.032     0.200
    76.655    -1.610     0.200
    76.678    -0.094     0.200
    76.829    -0.814     0.200
    76.827    -0.079     0.200
    76.853     0.921     0.200
    77.057     0.228     0.200
    77.119    -1.071     0.200
    77.164     0.175     0.200
    77.253    -0.628     0.200
    77.509    -0.339     0.200
    77.561     0.909     0.200
    77.574     0.084     0.200
    77.590    -0.899     0.200
    77.609     0.091     0.200
    77.702    -0.031     0.200
    78.065    -0.544     0.200
    78.088     0.089     0.200
    78.103    -0.564     0.200
    78.295     0.158     0.200
    78.361    -0.084     0.200
    78.379    -0.232     0.200
    78.458    -1.260     0.200
    78.584    -0.609     0.200
    78.657    -0.814     0.200
    78.672    -0.092     0.200
    78.738     0.376     0.200
    78.850    -0.876     0.200
    78.856    -0.554     0.200
    79.073    -0.919     0.200
    79.073    -0.649     0.200
    79.098     0.274     0.200
    79.164    -0.226     0.200
    79.169    -0.123     0.200
    79.325    -0.364     0.200
    79.613     0.668     0.200
    79.613     0.268     0.200
    79.761    -0.254     0.200
    79.955    -1.033     0.200
    80.079    -0.848     0.200
    80.077     0.140     0.200
    80.078     0.281     0.200
    80.132    -0.987     0.200
    80.324     1.029     0.200
    80.525    -0.665     0.200
    80.843    -0.633     0.200
    80.862    -0.508     0.200
    80.876    -0.169     0.200
    80.929    -0.665     0.200
    80.932    -0.628     0.200
    81.084    -0.086     0.200
    81.095     0.056     0.200
    81.108    -1.123     0.200
    81.198    -1.155     0.200
    81.206    -0.675     0.200
    81.216    -1.364     0.200
    81.232    -0.304     0.200
    81.593    -0.291     0.200
    81.606    -1.092     0.200
    81.652    -0.535     0.200
    81.694    -0.649     0.200
    81.730    -0.118     0.200
    82.006     0.534     0.200
    82.017     0.038     0.200
    82.060    -0.899     0.200
    82.151    -0.804     0.200
    82.465    -0.157     0.200
    82.601    -1.159     0.200
    82.759    -0.917     0.200
    83.158    -1.673     0.200
    83.269     0.254     0.200
    83.269     0.605     0.200
    83.322    -0.377     0.200
    83.342    -0.585     0.200
    83.708    -0.228     0.200
    83.832    -0.147     0.200
    84.035    -0.084     0.200
    84.103    -0.381     0.200
    84.168    -0.035     0.200
    84.258    -1.237     0.200
    84.429    -0.097     0.200
    84.489    -0.485     0.200
    84.504    -0.153     0.200
    84.524    -0.411     0.200
    84.900    -0.472     0.200
    84.972    -0.637     0.200
    84.974    -0.565     0.200
    85.235    -0.022     0.200
    85.324    -1.034     0.200
    85.364    -0.571     0.200
    85.410    -0.384     0.200
    85.772    -0.132     0.200
    85.798    -0.673     0.200
    85.808    -1.097     0.200
    85.819     0.378     0.200
    85.996     0.551     0.200
    85.997     0.947     0.200
    86.002    -0.291     0.200
    86.026    -0.180     0.200
    86.431     0.207     0.200
    86.763     0.684     0.200
    87.268     0.495     0.200
    88.336     0.192     0.200
    93.017    -0.261     0.200
    93.061    -0.333     0.200
    18.019     0.782     0.200
    18.019     0.981     0.200
    21.451    -1.449     0.200
    43.566     0.089     0.200
    43.645    -0.574     0.200
    44.610    -0.134     0.200
    47.827     0.387     0.200
    47.877     0.232     0.200
    49.316    -0.927     0.200
    55.335    -0.030     0.200
    62.400    -0.853     0.200
    64.598    -1.688     0.200
    66.127    -0.153     0.200
    68.202     0.488     0.200
    69.687    -1.359     0.200
    73.367    -0.629     0.200
    86.213     0.711     0.200
    21.360    -2.498     0.200
    26.336    -0.917     0.200
    28.194    -0.607     0.200
    39.519    -1.418     0.200
    42.627    -0.650     0.200
    43.881    -0.530     0.200
    44.272    -0.374     0.200
    44.378    -0.361     0.200
    48.122     0.811     0.200
    48.632     0.486     0.200
    48.860     0.539     0.200
    48.992     0.224     0.200
    49.117    -1.079     0.200
    49.888     0.706     0.200
    50.159     0.650     0.200
    51.750    -0.592     0.200
    53.358    -0.778     0.200
    55.633    -0.280     0.200
    57.166    -1.181     0.200
    58.614    -0.274     0.200
    62.472    -0.721     0.200
    62.502    -0.723     0.200
    64.772    -1.898     0.200
    65.405    -0.354     0.200
    66.199     0.148     0.200
    68.492     0.449     0.200
    69.827    -0.966     0.200
    70.838    -0.085     0.200
    70.936    -1.854     0.200
    76.335    -0.330     0.200
    78.719     0.372     0.200
    78.904    -0.392     0.200
    85.895     1.351     0.200
    17.613     1.242     0.200
    20.028    -1.658     0.200
    20.028    -0.598     0.200
    20.511    -0.305     0.200
    23.684    -2.665     0.200
    23.827    -3.777     0.200
    26.089    -0.745     0.200
    26.309    -0.668     0.200
    26.315    -0.413     0.200
    28.163     1.820     0.200
    33.501    -0.457     0.200
    33.940     0.925     0.200
    37.545     1.398     0.200
    39.406    -0.518     0.200
    39.406    -0.313     0.200
    39.866     2.026     0.200
    40.001    -0.965     0.200
    40.006     0.069     0.200
    41.757    -0.303     0.200
    41.785     0.624     0.200
    42.011    -0.845     0.200
    42.300     0.572     0.200
    42.585    -0.717     0.200
    42.585    -0.717     0.200
    42.585    -0.752     0.200
    42.590     0.393     0.200
    42.786    -0.347     0.200
    43.174     0.306     0.200
    43.236    -0.495     0.200
    43.397    -0.050     0.200
    43.490     0.859     0.200
    43.563    -0.135     0.200
    43.563    -1.035     0.200
    43.599    -0.406     0.200
    43.635    -0.315     0.200
    43.792     0.522     0.200
    43.792     0.122     0.200
    43.935    -0.180     0.200
    43.983    -0.339     0.200
    43.983    -0.757     0.200
    43.983    -0.287     0.200
    44.106     0.507     0.200
    44.295     0.889     0.200
    44.535    -0.082     0.200
    44.535     1.968     0.200
    45.341    -0.884     0.200
    46.416    -0.585     0.200
    48.046     0.608     0.200
    48.169     1.019     0.200
    48.714    -0.901     0.200
    48.768     1.107     0.200
    48.794     0.405     0.200
    48.800     0.360     0.200
    48.945     0.955     0.200
    49.620     3.390     0.200
    50.016     0.474     0.200
    50.283     1.154     0.200
    53.186    -0.524     0.200
    53.186    -1.034     0.200
    53.329     0.630     0.200
    55.518    -0.232     0.200
    56.098    -0.099     0.200
    56.761    -0.972     0.200
    58.213    -0.512     0.200
    59.237    -0.829     0.200
    59.237    -0.329     0.200
    59.798    -3.296     0.200
    62.461     0.169     0.200
    62.870    -0.660     0.200
    64.409    -1.742     0.200
    64.474    -0.963     0.200
    64.474    -0.463     0.200
    64.507    -0.984     0.200
    64.509    -1.418     0.200
    64.934    -1.668     0.200
    65.025     0.043     0.200
    65.605     0.737     0.200
    65.675    -0.868     0.200
    66.301     0.574     0.200
    66.337    -0.522     0.200
    66.590    -0.150     0.200
    66.597     0.313     0.200
    67.080     0.735     0.200
    67.238     1.046     0.200
    67.673     0.402     0.200
    67.696     0.809     0.200
    67.803     0.763     0.200
    68.340    -0.312     0.200
    68.340     0.897     0.200
    68.363     0.120     0.200
    68.807     0.413     0.200
    69.045     0.757     0.200
    69.106     0.628     0.200
    69.133     0.759     0.200
    69.351     0.676     0.200
    69.471     0.755     0.200
    69.509     0.871     0.200
    69.535    -1.739     0.200
    69.535    -1.465     0.200
    69.581     1.147     0.200
    69.717     0.737     0.200
    69.762     1.333     0.200
    69.883     0.018     0.200
    70.729    -1.683     0.200
    70.729    -0.858     0.200
    71.205     0.324     0.200
    71.328     0.646     0.200
    71.408     0.484     0.200
    71.468     1.165     0.200
    72.606    -0.355     0.200
    72.698     0.995     0.200
    72.709     0.390     0.200
    72.709     0.379     0.200
    72.709     0.379     0.200
    72.951    -1.003     0.200
    73.649     0.034     0.200
    74.224    -0.360     0.200
    74.643     0.876     0.200
    74.764     0.027     0.200
    74.778    -0.104     0.200
    75.152    -0.263     0.200
    75.152    -0.363     0.200
    75.168    -0.459     0.200
    75.864     0.040     0.200
    75.992     1.563     0.200
    76.163     1.069     0.200
    76.408     0.256     0.200
    76.471     0.302     0.200
    76.718     1.904     0.200
    76.889    -0.664     0.200
    76.906    -1.060     0.200
    77.297     1.463     0.200
    78.471    -0.187     0.200
    78.553     0.961     0.200
    78.658    -0.813     0.200
    78.664    -0.750     0.200
    79.487     0.248     0.200
    79.895    -0.128     0.200
    80.838     0.071     0.200
    80.881    -0.087     0.200
    81.292    -0.200     0.200
    81.385    -0.480     0.200
    81.803    -0.649     0.200
    84.313    -0.043     0.200
    85.549     0.613     0.200
    85.550     0.690     0.200
    86.978    -0.882     0.200
    92.814    -0.863     0.200
    21.252     1.166     0.200
    21.537    -2.022     0.200
    23.131     2.935     0.200
    24.435    -0.807     0.200
    24.990    -0.601     0.200
    25.507    -0.899     0.200
    25.769     0.080     0.200
    25.945     1.852     0.200
    27.852    -0.640     0.200
    30.398     1.853     0.200
    32.836    -0.796     0.200
    33.222     0.826     0.200
    33.900    -0.546     0.200
    36.040    -0.941     0.200
    36.837     0.151     0.200
    39.202    -0.464     0.200
    39.203    -0.110     0.200
    39.203    -0.469     0.200
    39.465     1.701     0.200
    42.255    -1.605     0.200
    42.255    -0.009     0.200
    42.255    -0.509     0.200
    43.250     0.097     0.200
    43.543    -0.749     0.200
    43.543     0.329     0.200
    43.808     0.810     0.200
    43.808     0.810     0.200
    43.808     1.622     0.200
    44.221    -1.484     0.200
    44.292     0.335     0.200
    44.712    -1.280     0.200
    44.712    -1.309     0.200
    44.712    -0.301     0.200
    47.864     0.795     0.200
    47.864     0.030     0.200
    49.208     3.339     0.200
    49.690     1.888     0.200
    52.245     0.413     0.200
    53.098    -0.478     0.200
    53.098    -0.368     0.200
    55.318    -0.809     0.200
    58.929    -1.427     0.200
    58.929    -1.419     0.200
    58.929    -0.614     0.200
    59.846    -2.657     0.200
    62.128     0.071     0.200
    62.318    -2.304     0.200
    64.625    -1.691     0.200
    64.625    -1.715     0.200
    65.491    -0.322     0.200
    65.491     0.061     0.200
    66.308     0.152     0.200
    66.368     1.432     0.200
    67.699     1.610     0.200
    67.768     2.202     0.200
    67.997     1.662     0.200
    69.723    -1.453     0.200
    70.477     1.218     0.200
    70.715    -1.684     0.200
    70.715    -1.731     0.200
    70.727    -0.601     0.200
    73.463     1.610     0.200
    73.471     0.002     0.200
    73.471    -0.242     0.200
    73.471    -0.242     0.200
    73.700    -1.445     0.200
    74.658     1.914     0.200
    80.637     1.453     0.200
    81.886     0.928     0.200
    86.316     0.664     0.200
    86.315     1.113     0.200
    86.316     0.695     0.200
    87.724     0.725     0.200
    88.943    -1.984     0.200
    15.327     3.455     0.200
    16.222     1.543     0.200
    19.250    -0.343     0.200
    19.250    -2.604     0.200
    19.956    -1.881     0.200
    19.966    -3.499     0.200
    20.538    -2.113     0.200
    21.326    -1.954     0.200
    21.326    -3.630     0.200
    21.326    -2.989     0.200
    21.354     0.265     0.200
    21.595    -1.843     0.200
    23.173    -0.218     0.200
    23.442    -0.440     0.200
    23.864    -2.725     0.200
    24.421    -0.733     0.200
    24.720     0.225     0.200
    24.974    -4.082     0.200
    25.376    -0.206     0.200
    26.004    -1.438     0.200
    26.010    -0.272     0.200
    26.194     0.681     0.200
    26.328    -2.536     0.200
    27.532    -0.372     0.200
    27.583    -0.522     0.200
    27.918     0.418     0.200
    28.077    -1.338     0.200
    29.009    -2.433     0.200
    30.324     0.512     0.200
    32.862    -0.009     0.200
    33.236     0.916     0.200
    36.037     0.999     0.200
    36.854     0.924     0.200
    38.434    -0.567     0.200
    39.271    -1.248     0.200
    39.522    -0.461     0.200
    40.773    -0.108     0.200
    40.993     0.279     0.200
    41.374     1.017     0.200
    42.241    -0.279     0.200
    42.317    -1.209     0.200
    42.317    -0.996     0.200
    42.493     0.051     0.200
    42.528    -0.281     0.200
    42.555    -0.177     0.200
    42.697     0.162     0.200
    42.793     0.432     0.200
    42.833     0.311     0.200
    43.069     0.221     0.200
    43.289    -0.702     0.200
    43.477     0.598     0.200
    43.547    -1.846     0.200
    43.578     0.785     0.200
    43.580     0.864     0.200
    43.580    -0.734     0.200
    43.609    -1.270     0.200
    43.699     1.305     0.200
    43.825    -0.665     0.200
    43.818     0.900     0.200
    43.832    -1.401     0.200
    43.943    -0.452     0.200
    44.006    -0.658     0.200
    43.995     1.425     0.200
    44.058    -0.176     0.200
    44.160    -0.486     0.200
    44.255    -0.650     0.200
    44.327    -0.536     0.200
    44.364    -0.531     0.200
    44.410    -0.198     0.200
    44.705    -0.516     0.200
    44.747    -1.289     0.200
    44.747    -0.588     0.200
    44.747    -1.466     0.200
    44.754    -1.255     0.200
    44.792    -1.852     0.200
    44.880    -1.051     0.200
    45.273     0.243     0.200
    45.580    -2.307     0.200
    45.725     0.503     0.200
    45.807    -0.323     0.200
    45.836    -0.099     0.200
    46.109    -0.537     0.200
    46.314     0.104     0.200
    46.375     0.073     0.200
    47.149     0.661     0.200
    47.179    -0.781     0.200
    47.202     2.354     0.200
    47.687     0.176     0.200
    47.882    -0.575     0.200
    47.933    -0.532     0.200
    47.933    -1.000     0.200
    47.965    -0.247     0.200
    48.069     0.158     0.200
    48.209     0.436     0.200
    48.232     0.358     0.200
    48.238     0.311     0.200
    48.436     0.577     0.200
    48.571     0.141     0.200
    48.805     0.838     0.200
    48.967     0.016     0.200
    48.967    -0.902     0.200
    49.264     2.722     0.200
    49.456     0.029     0.200
    49.456    -0.846     0.200
    49.467     0.469     0.200
    49.720     0.556     0.200
    49.741     0.682     0.200
    49.776     0.265     0.200
    50.903     1.991     0.200
    51.957    -0.707     0.200
    52.238    -0.058     0.200
    52.633    -0.502     0.200
    53.170    -0.640     0.200
    53.170    -1.195     0.200
    53.170    -1.355     0.200
    54.105    -1.501     0.200
    54.762     4.042     0.200
    55.327    -0.713     0.200
    55.387    -0.845     0.200
    55.974    -0.666     0.200
    56.507    -1.565     0.200
    57.424    -1.694     0.200
    57.424    -1.471     0.200
    58.694    -1.768     0.200
    58.973    -0.706     0.200
    58.967    -0.171     0.200
    59.520    -1.094     0.200
    59.921    -1.855     0.200
    62.005    -1.295     0.200
    62.190    -0.308     0.200
    62.220    -0.476     0.200
    62.247     0.160     0.200
    62.247    -1.379     0.200
    62.256    -1.960     0.200
    62.257    -1.109     0.200
    62.594    -1.340     0.200
    63.185    -0.586     0.200
    63.317    -0.210     0.200
    63.681    -1.380     0.200
    63.850    -0.281     0.200
    64.241    -0.979     0.200
    64.319    -0.494     0.200
    64.540    -0.860     0.200
    64.540    -0.016     0.200
    64.548     0.666     0.200
    64.575     0.857     0.200
    64.647     0.223     0.200
    64.699    -1.567     0.200
    64.700    -1.338     0.200
    64.825    -1.081     0.200
    64.957    -0.440     0.200
    65.349    -0.495     0.200
    65.410     2.643     0.200
    65.558     0.467     0.200
    65.558    -1.135     0.200
    65.555    -0.316     0.200
    65.635     0.647     0.200
    65.680    -0.028     0.200
    65.687     0.816     0.200
    65.795    -0.502     0.200
    65.864    -0.714     0.200
    65.895     0.088     0.200
    65.922     1.392     0.200
    65.985    -0.490     0.200
    66.056     0.076     0.200
    66.387     0.301     0.200
    66.467     4.109     0.200
    66.493    -0.248     0.200
    66.584     0.668     0.200
    66.698    -0.355     0.200
    67.035     0.282     0.200
    67.079    -0.376     0.200
    67.080     0.807     0.200
    67.099    -0.261     0.200
    67.221     0.764     0.200
    67.364     0.410     0.200
    67.370     1.372     0.200
    67.390     0.965     0.200
    67.514     0.387     0.200
    67.721     0.677     0.200
    67.791     0.908     0.200
    67.862     0.162     0.200
    67.925     0.566     0.200
    68.000     0.594     0.200
    67.992    -0.197     0.200
    68.019     0.210     0.200
    68.239    -0.109     0.200
    68.255    -1.005     0.200
    68.258     1.172     0.200
    68.455     0.042     0.200
    68.478    -0.467     0.200
    68.478     0.509     0.200
    68.583    -0.460     0.200
    68.624    -0.617     0.200
    68.654    -0.104     0.200
    68.777     0.932     0.200
    68.790    -0.190     0.200
    68.936    -1.059     0.200
    68.949     0.260     0.200
    69.319     1.032     0.200
    69.376    -0.089     0.200
    69.594    -1.100     0.200
    69.589     0.657     0.200
    69.604    -1.331     0.200
    69.670     0.337     0.200
    69.737    -0.694     0.200
    69.768    -0.579     0.200
    69.798    -0.898     0.200
    69.798    -1.398     0.200
    69.821    -0.112     0.200
    69.894    -0.986     0.200
    69.886    -0.528     0.200
    69.886    -0.215     0.200
    69.915     0.206     0.200
    69.932    -0.398     0.200
    70.073     0.636     0.200
    70.133     0.333     0.200
    70.243     0.472     0.200
    70.291     1.258     0.200
    70.291     1.000     0.200
    70.342     1.506     0.200
    70.356     0.630     0.200
    70.403    -0.662     0.200
    70.499    -0.393     0.200
    70.499     0.306     0.200
    70.536     0.754     0.200
    70.661     1.015     0.200
    70.704    -1.441     0.200
    70.789    -0.284     0.200
    70.789    -1.159     0.200
    70.801    -0.634     0.200
    70.801    -1.372     0.200
    70.831    -1.233     0.200
    70.976     1.095     0.200
    71.007     1.272     0.200
    71.107     0.738     0.200
    71.115    -0.998     0.200
    71.285    -0.240     0.200
    71.407     0.441     0.200
    71.445     0.740     0.200
    71.585     0.448     0.200
    71.767     1.641     0.200
    71.812     1.154     0.200
    71.852     0.461     0.200
    71.852     1.371     0.200
    71.987     1.553     0.200
    71.993    -0.135     0.200
    72.063     0.056     0.200
    72.190     0.334     0.200
    72.190    -0.147     0.200
    72.250     0.228     0.200
    72.298    -0.360     0.200
    72.318    -0.326     0.200
    72.318    -0.177     0.200
    72.357     0.907     0.200
    72.366     0.636     0.200
    72.375     0.661     0.200
    72.431     0.076     0.200
    72.561    -0.385     0.200
    72.561     0.178     0.200
    72.676     0.169     0.200
    72.760     0.516     0.200
    72.782    -0.480     0.200
    72.927    -0.295     0.200
    72.967     0.204     0.200
    72.967     0.958     0.200
    72.990    -0.179     0.200
    73.081     0.584     0.200
    73.160     0.284     0.200
    73.287     0.303     0.200
    73.386     0.120     0.200
    73.386     0.280     0.200
    73.409    -0.338     0.200
    73.473     0.015     0.200
    73.491    -0.240     0.200
    73.491     0.260     0.200
    73.491    -0.300     0.200
    73.491    -0.089     0.200
    73.539     0.578     0.200
    73.567    -0.294     0.200
    73.729    -0.020     0.200
    73.757     1.799     0.200
    73.894    -0.974     0.200
    73.970    -0.734     0.200
    74.112    -0.479     0.200
    74.139     0.055     0.200
    74.199     0.576     0.200
    74.199    -0.287     0.200
    74.355     0.006     0.200
    74.425     0.898     0.200
    74.475     0.995     0.200
    74.658     0.691     0.200
    74.765    -0.401     0.200
    74.799     0.347     0.200
    74.820    -0.946     0.200
    74.815    -0.579     0.200
    74.834    -0.076     0.200
    74.907    -0.429     0.200
    74.949    -0.698     0.200
    74.960    -0.704     0.200
    75.062     0.525     0.200
    75.158     0.014     0.200
    75.183     2.977     0.200
    75.199    -0.005     0.200
    75.244     0.177     0.200
    75.248     0.345     0.200
    75.270    -0.770     0.200
    75.269     1.214     0.200
    75.403    -2.360     0.200
    75.424    -0.276     0.200
    75.457    -0.441     0.200
    75.457     0.235     0.200
    75.518    -0.101     0.200
    75.518    -0.417     0.200
    75.525     0.149     0.200
    75.552     0.376     0.200
    75.670     1.180     0.200
    75.881    -0.370     0.200
    75.966    -1.133     0.200
    75.980     0.612     0.200
    76.010     0.096     0.200
    76.010    -0.349     0.200
    76.013     0.427     0.200
    76.038    -0.492     0.200
    76.112    -0.849     0.200
    76.112     0.541     0.200
    76.120     0.761     0.200
    76.131     0.423     0.200
    76.203     0.694     0.200
    76.249     0.006     0.200
    76.249    -0.639     0.200
    76.303     1.104     0.200
    76.363    -0.445     0.200
    76.371     0.431     0.200
    76.372     0.294     0.200
    76.387    -0.616     0.200
    76.507     1.446     0.200
    76.512    -2.470     0.200
    76.504     0.476     0.200
    76.538    -0.427     0.200
    76.577     0.551     0.200
    76.616    -0.699     0.200
    76.628    -1.002     0.200
    76.636     0.873     0.200
    76.636     0.607     0.200
    76.653    -0.057     0.200
    76.697    -1.099     0.200
    76.711    -0.137     0.200
    76.737     0.053     0.200
    76.737     0.166     0.200
    76.757     1.234     0.200
    76.912     0.158     0.200
    76.912     0.760     0.200
    76.990     0.220     0.200
    76.999     0.471     0.200
    77.007    -0.776     0.200
    77.081    -0.688     0.200
    77.081    -0.290     0.200
    77.117    -0.505     0.200
    77.136     0.162     0.200
    77.157    -0.854     0.200
    77.290     0.595     0.200
    77.366     0.909     0.200
    77.366     0.749     0.200
    77.378     0.760     0.200
    77.447     0.943     0.200
    77.465    -0.461     0.200
    77.501    -0.261     0.200
    77.521    -0.736     0.200
    77.549     0.926     0.200
    77.561     0.716     0.200
    77.688     0.211     0.200
    77.688     1.008     0.200
    77.763    -0.553     0.200
    77.810     0.477     0.200
    77.888     0.450     0.200
    77.888     0.774     0.200
    77.923    -0.791     0.200
    77.931    -0.612     0.200
    77.961    -0.868     0.200
    77.967    -1.464     0.200
    78.074     1.111     0.200
    78.218    -0.327     0.200
    78.239    -0.596     0.200
    78.258    -0.874     0.200
    78.276    -0.727     0.200
    78.347    -0.398     0.200
    78.374    -0.759     0.200
    78.374    -0.442     0.200
    78.405    -0.369     0.200
    78.463    -0.206     0.200
    78.463     1.119     0.200
    78.534     0.733     0.200
    78.595    -0.009     0.200
    78.604    -0.610     0.200
    78.624     0.219     0.200
    78.624    -0.183     0.200
    78.647    -0.756     0.200
    78.677     0.338     0.200
    78.692    -0.077     0.200
    78.750    -0.832     0.200
    78.769    -0.104     0.200
    79.036    -0.640     0.200
    79.050    -0.238     0.200
    79.053    -0.886     0.200
    79.062    -0.337     0.200
    79.144    -0.688     0.200
    79.184    -0.180     0.200
    79.206     0.403     0.200
    79.206     0.641     0.200
    79.215    -0.663     0.200
    79.375    -0.481     0.200
    79.375     0.019     0.200
    79.408    -0.478     0.200
    79.461    -0.149     0.200
    79.495    -0.371     0.200
    79.511     0.160     0.200
    79.524    -0.837     0.200
    79.643    -1.190     0.200
    79.782    -0.455     0.200
    79.863     0.709     0.200
    79.917     0.394     0.200
    79.958    -0.555     0.200
    80.014     0.202     0.200
    80.026     0.146     0.200
    80.041    -0.373     0.200
    80.048    -0.073     0.200
    80.175    -0.013     0.200
    80.175    -0.427     0.200
    80.246     0.537     0.200
    80.246    -0.280     0.200
    80.251     0.065     0.200
    80.315    -0.360     0.200
    80.393    -0.029     0.200
    80.393    -0.412     0.200
    80.415    -0.312     0.200
    80.419    -0.457     0.200
    80.557    -0.469     0.200
    80.617    -0.941     0.200
    80.618    -0.169     0.200
    80.639    -0.017     0.200
    80.641     0.804     0.200
    80.652     0.755     0.200
    80.738    -0.416     0.200
    80.745    -0.116     0.200
    80.799     0.407     0.200
    80.835     0.312     0.200
    81.045     0.169     0.200
    81.051     0.193     0.200
    81.089     0.206     0.200
    81.120    -0.122     0.200
    81.229    -0.344     0.200
    81.481    -1.056     0.200
    81.484     3.881     0.200
    81.505    -0.602     0.200
    81.531    -0.805     0.200
    81.531     0.016     0.200
    81.544    -0.826     0.200
    81.546    -0.548     0.200
    81.577     0.850     0.200
    81.577     1.120     0.200
    81.601    -0.775     0.200
    81.601    -0.628     0.200
    81.681    -0.736     0.200
    81.800    -0.812     0.200
    81.932    -0.264     0.200
    81.953    -0.585     0.200
    81.974     1.557     0.200
    81.982     0.066     0.200
    81.996     0.016     0.200
    82.042     0.367     0.200
    82.156    -0.672     0.200
    82.307    -0.468     0.200
    82.309    -0.768     0.200
    82.350    -0.617     0.200
    82.363    -0.138     0.200
    82.373     0.578     0.200
    82.400    -0.908     0.200
    82.433    -0.065     0.200
    82.461    -0.355     0.200
    82.651    -0.525     0.200
    82.689    -0.747     0.200
    82.759    -0.599     0.200
    82.765     0.302     0.200
    82.804    -0.541     0.200
    82.877     0.260     0.200
    82.881     0.532     0.200
    82.911    -0.096     0.200
    82.928     0.354     0.200
    83.159    -0.853     0.200
    83.191    -0.950     0.200
    83.199    -0.066     0.200
    83.205    -0.001     0.200
    83.237    -0.549     0.200
    83.286    -0.912     0.200
    83.295    -0.275     0.200
    83.401     0.459     0.200
    83.415    -1.680     0.200
    83.461     0.375     0.200
    83.473    -0.609     0.200
    83.513    -0.310     0.200
    83.551    -0.459     0.200
    83.599     0.354     0.200
    83.647    -0.382     0.200
    83.651    -0.156     0.200
    83.712    -0.079     0.200
    83.726    -0.424     0.200
    83.933    -0.319     0.200
    84.012    -0.264     0.200
    84.014    -0.716     0.200
    84.060    -0.457     0.200
    84.144     0.066     0.200
    84.203    -0.277     0.200
    84.404    -0.422     0.200
    84.403    -0.092     0.200
    84.407    -0.074     0.200
    84.479     0.182     0.200
    84.491    -0.268     0.200
    84.631    -0.516     0.200
    84.633     0.341     0.200
    84.792    -0.031     0.200
    84.834    -0.821     0.200
    84.845     0.082     0.200
    84.868    -0.430     0.200
    84.937     0.233     0.200
    85.060     0.694     0.200
    85.095     0.805     0.200
    85.095     0.648     0.200
    85.137     0.454     0.200
    85.233    -0.331     0.200
    85.283     0.441     0.200
    85.391     0.169     0.200
    85.435     0.101     0.200
    85.444    -0.326     0.200
    85.540     0.078     0.200
    85.631    -0.211     0.200
    85.633    -0.019     0.200
    85.664    -0.556     0.200
    85.668    -0.984     0.200
    85.730    -0.292     0.200
    85.739    -0.529     0.200
    85.776    -0.008     0.200
    85.794     0.122     0.200
    85.795     0.646     0.200
    85.871    -0.180     0.200
    85.993     0.349     0.200
    86.009    -0.912     0.200
    86.048    -1.448     0.200
    86.082     0.087     0.200
    86.087    -0.369     0.200
    86.104    -0.464     0.200
    86.128    -0.192     0.200
    86.132    -0.137     0.200
    86.145     0.145     0.200
    86.199     0.106     0.200
    86.213     0.134     0.200
    86.240    -0.745     0.200
    86.319    -0.319     0.200
    86.327     0.284     0.200
    86.328     0.546     0.200
    86.345    -0.346     0.200
    86.355    -0.280     0.200
    86.377    -0.002     0.200
    86.418     0.566     0.200
    86.430     1.051     0.200
    86.449     0.173     0.200
    86.477    -0.718     0.200
    86.516     0.660     0.200
    86.521     0.228     0.200
    86.558     0.013     0.200
    86.580    -0.791     0.200
    86.597     0.217     0.200
    86.627     0.253     0.200
    86.662     0.565     0.200
    86.784     0.364     0.200
    86.901     0.042     0.200
    86.912    -0.672     0.200
    87.015     0.280     0.200
    87.068    -0.437     0.200
    87.082     0.502     0.200
    87.082     0.768     0.200
    87.200     0.604     0.200
    87.234     0.644     0.200
    87.284     0.384     0.200
    87.357     0.177     0.200
    87.358     0.494     0.200
    87.363    -0.157     0.200
    87.491     0.115     0.200
    87.514     0.267     0.200
    87.557     1.165     0.200
    87.568     0.625     0.200
    87.707     0.311     0.200
    87.709     0.212     0.200
    87.722     0.115     0.200
    87.726     0.766     0.200
    87.731     1.453     0.200
    87.731     0.199     0.200
    87.754     0.151     0.200
    87.861     0.793     0.200
    87.893     0.870     0.200
    87.898     0.510     0.200
    87.904     0.151     0.200
    87.927     0.195     0.200
    87.959     0.079     0.200
    87.968     0.413     0.200
    87.974     0.764     0.200
    88.020     0.050     0.200
    88.035     0.113     0.200
    88.068     0.581     0.200
    88.184     0.415     0.200
    88.197     0.106     0.200
    88.343     0.055     0.200
    88.401     0.316     0.200
    88.396     0.755     0.200
    88.455     0.157     0.200
    88.473     0.585     0.200
    88.658     0.959     0.200
    88.750     0.332     0.200
    88.823     0.950     0.200
    88.855     1.351     0.200
    89.075     1.292     0.200
    89.819    -0.131     0.200
    89.889     0.325     0.200
    90.036     0.946     0.200
    90.330     0.153     0.200
    91.074     0.291     0.200
    21.400     0.626     0.200
    21.556    -1.807     0.200
    23.206     1.698     0.200
    26.030     0.302     0.200
    26.030     0.306     0.200
    30.470     0.126     0.200
    36.084     2.200     0.200
    39.281    -0.796     0.200
    39.281    -0.797     0.200
    39.545     0.462     0.200
    41.797     0.391     0.200
    42.335    -0.109     0.200
    42.335    -0.127     0.200
    42.335    -0.716     0.200
    42.335    -0.718     0.200
    42.335    -0.037     0.200
    43.022     0.071     0.200
    43.622    -0.756     0.200
    44.114     0.728     0.200
    44.281     0.457     0.200
    44.700    -1.287     0.200
    44.700    -1.562     0.200
    44.700    -1.015     0.200
    47.891    -0.590     0.200
    47.941    -0.171     0.200
    49.287     4.571     0.200
    49.411    -0.775     0.200
    53.173    -0.183     0.200
    55.397    -0.470     0.200
    55.983    -0.462     0.200
    62.283    -0.441     0.200
    62.293    -0.913     0.200
    62.294    -1.460     0.200
    62.294    -1.460     0.200
    64.537    -1.355     0.200
    64.690    -1.352     0.200
    64.690    -1.401     0.200
    64.690    -1.051     0.200
    65.526    -0.483     0.200
    65.847     0.449     0.200
    66.020    -0.695     0.200
    66.021    -0.704     0.200
    66.338     0.500     0.200
    67.971    -0.255     0.200
    68.242     0.974     0.200
    68.247     1.191     0.200
    68.247     0.941     0.200
    68.266    -0.229     0.200
    69.767    -0.938     0.200
    69.784    -1.156     0.200
    70.085     0.883     0.200
    70.631    -0.243     0.200
    70.787    -0.957     0.200
    70.787    -0.994     0.200
    73.443     0.300     0.200
    73.443     0.300     0.200
    79.720     0.359     0.200
    86.280     0.429     0.200
    86.280     0.429     0.200
    21.169    -1.026     0.200
    42.225    -0.100     0.200
    43.551    -0.344     0.200
    44.346    -0.049     0.200
    47.708    -0.397     0.200
    58.559    -0.288     0.200
    62.681    -0.413     0.200
    64.390    -0.687     0.200
    66.409     0.155     0.200
    69.451    -1.074     0.200
    17.594     0.637     0.200
    21.511    -3.155     0.200
    21.511    -2.174     0.200
    21.608     1.484     0.200
    23.426     1.123     0.200
    25.788    -0.375     0.200
    25.788    -0.266     0.200
    26.226     0.630     0.200
    26.232     0.087     0.200
    28.117     0.028     0.200
    30.692     2.116     0.200
    32.469     0.298     0.200
    33.122     0.493     0.200
    37.112     0.982     0.200
    39.457    -0.199     0.200
    39.457    -0.545     0.200
    39.457    -0.071     0.200
    39.751     1.833     0.200
    42.532    -0.269     0.200
    42.532    -0.314     0.200
    42.532    -0.109     0.200
    42.532    -0.211     0.200
    42.734    -0.285     0.200
    43.806    -0.322     0.200
    43.806    -0.672     0.200
    44.573     0.037     0.200
    44.573    -0.752     0.200
    47.408     0.194     0.200
    47.572     0.224     0.200
    47.861     0.886     0.200
    47.946     0.233     0.200
    47.956     0.854     0.200
    48.063    -0.386     0.200
    48.114     0.616     0.200
    48.466     0.220     0.200
    48.490     0.140     0.200
    48.496     0.293     0.200
    48.694     0.472     0.200
    48.828     0.742     0.200
    49.189    -0.122     0.200
    49.303    -0.990     0.200
    49.303    -0.600     0.200
    49.532     0.630     0.200
    53.326    -0.987     0.200
    55.572    -0.179     0.200
    55.692    -1.611     0.200
    56.153    -0.601     0.200
    57.326    -1.294     0.200
    58.804    -0.635     0.200
    59.585    -1.714     0.200
    62.328    -0.136     0.200
    62.406    -0.067     0.200
    64.795    -1.132     0.200
    64.796    -1.417     0.200
    64.796    -1.542     0.200
    65.525     0.154     0.200
    65.831    -0.236     0.200
    68.664     0.270     0.200
    68.896    -0.665     0.200
    69.808    -0.878     0.200
    69.859    -1.161     0.200
    69.871    -1.921     0.200
    69.871    -1.546     0.200
    70.924    -0.966     0.200
    71.045     1.600     0.200
    73.281     0.638     0.200
    74.957     0.085     0.200
    74.970     0.239     0.200
    76.286    -0.316     0.200
    76.428    -2.294     0.200
    77.182    -0.541     0.200
    78.638    -0.448     0.200
    78.916    -0.553     0.200
    15.553     2.464     0.200
    17.922    -1.501     0.200
    17.922    -1.751     0.200
    21.312    -3.391     0.200
    21.362    -2.414     0.200
    21.362    -0.839     0.200
    26.331    -1.001     0.200
    26.336     0.047     0.200
    26.336     0.047     0.200
    28.371    -2.090     0.200
    28.664    -0.293     0.200
    32.616     0.754     0.200
    38.592     1.053     0.200
    39.111    -1.238     0.200
    39.519    -0.240     0.200
    39.519    -0.726     0.200
    39.519    -0.245     0.200
    39.519    -1.023     0.200
    40.322    -0.351     0.200
    42.628    -0.734     0.200
    42.628    -0.523     0.200
    42.628     0.028     0.200
    42.628     0.028     0.200
    42.628    -0.672     0.200
    42.628    -0.738     0.200
    42.829    -0.906     0.200
    43.881    -0.429     0.200
    43.881    -0.777     0.200
    43.961    -0.288     0.200
    44.271    -0.121     0.200
    44.271     1.001     0.200
    44.380    -0.269     0.200
    44.380    -0.621     0.200
    45.653    -1.623     0.200
    45.998    -0.628     0.200
    48.121     0.922     0.200
    48.121    -0.474     0.200
    48.121     0.151     0.200
    48.171    -0.460     0.200
    48.171    -0.343     0.200
    48.631     0.697     0.200
    48.656     0.312     0.200
    48.662     0.267     0.200
    48.859     0.648     0.200
    48.992     0.333     0.200
    49.119    -0.612     0.200
    49.119    -1.089     0.200
    49.453     1.113     0.200
    49.887     0.514     0.200
    50.159     0.758     0.200
    50.691     0.042     0.200
    51.097    -0.308     0.200
    51.750    -1.028     0.200
    51.750    -0.790     0.200
    51.750    -0.970     0.200
    52.146    -0.331     0.200
    53.359    -0.978     0.200
    53.359    -1.189     0.200
    53.359    -0.779     0.200
    55.612    -1.727     0.200
    55.612    -1.556     0.200
    55.634    -0.380     0.200
    55.634    -0.458     0.200
    56.209    -0.685     0.200
    56.209    -0.485     0.200
    57.168    -1.860     0.200
    58.616    -0.630     0.200
    59.538    -1.617     0.200
    59.538    -1.621     0.200
    62.503    -0.072     0.200
    64.774    -1.033     0.200
    64.774    -1.029     0.200
    65.407    -0.219     0.200
    68.472     0.027     0.200
    68.493    -0.274     0.200
    69.823    -0.999     0.200
    69.829    -1.120     0.200
    69.829    -0.890     0.200
    69.829    -0.894     0.200
    70.839     1.585     0.200
    70.937    -1.030     0.200
    70.937    -1.280     0.200
    73.078     0.527     0.200
    74.970    -0.590     0.200
    74.984    -0.527     0.200
    76.336     0.123     0.200
    76.336    -0.417     0.200
    76.336     0.121     0.200
    77.164    -0.398     0.200
    78.583    -1.291     0.200
    78.720     0.571     0.200
    78.905    -0.068     0.200
    79.972     0.605     0.200
    85.897     1.299     0.200
    17.813    -1.646     0.200
    17.813    -1.266     0.200
    17.813    -1.367     0.200
    19.681    -1.061     0.200
    20.276    -1.665     0.200
    20.287    -2.176     0.200
    21.156    -2.889     0.200
    21.156    -4.649     0.200
    21.251    -2.491     0.200
    21.251    -2.767     0.200
    21.764    -3.049     0.200
    23.470    -1.120     0.200
    23.780     1.248     0.200
    25.155    -0.609     0.200
    25.780    -2.329     0.200
    26.189    -1.097     0.200
    26.195    -0.260     0.200
    26.187     0.371     0.200
    26.626     0.729     0.200
    26.641     0.456     0.200
    26.763     0.513     0.200
    27.699    -2.379     0.200
    27.893    -0.611     0.200
    28.043     0.209     0.200
    28.043    -0.247     0.200
    28.043    -0.567     0.200
    28.043    -0.047     0.200
    28.222    -0.742     0.200
    29.397    -1.422     0.200
    29.691     0.325     0.200
    30.098     0.335     0.200
    30.760     0.990     0.200
    32.501     0.698     0.200
    33.227    -1.141     0.200
    33.635    -0.491     0.200
    34.271    -0.005     0.200
    37.246     0.635     0.200
    38.442     1.058     0.200
    39.363    -0.515     0.200
    39.363    -0.537     0.200
    39.363    -1.336     0.200
    39.729     0.622     0.200
    40.164    -0.586     0.200
    40.563     0.760     0.200
    41.592     0.976     0.200
    41.795     1.120     0.200
    41.982     1.189     0.200
    42.058    -1.349     0.200
    42.038     1.633     0.200
    42.102     1.112     0.200
    42.130     0.665     0.200
    42.359    -0.574     0.200
    42.359    -1.115     0.200
    42.459     1.556     0.200
    42.483    -1.257     0.200
    42.482    -0.273     0.200
    42.482    -0.222     0.200
    42.594     0.242     0.200
    42.645    -0.024     0.200
    42.671     0.073     0.200
    42.683    -0.386     0.200
    42.836     2.022     0.200
    42.875    -0.677     0.200
    42.935     0.431     0.200
    42.984     1.187     0.200
    43.014     3.180     0.200
    43.024     1.045     0.200
    43.139    -1.142     0.200
    43.139    -0.584     0.200
    43.164     1.913     0.200
    43.164     0.852     0.200
    43.256     1.110     0.200
    43.519     0.112     0.200
    43.629    -0.413     0.200
    43.707    -0.081     0.200
    43.740    -0.041     0.200
    43.728    -0.427     0.200
    43.728    -0.267     0.200
    43.728    -0.058     0.200
    43.834    -0.234     0.200
    43.943    -0.471     0.200
    43.896     0.627     0.200
    43.982     0.236     0.200
    43.983     0.732     0.200
    43.985     0.845     0.200
    43.985     1.236     0.200
    44.064     1.479     0.200
    44.115     0.674     0.200
    44.280    -0.146     0.200
    44.224     1.051     0.200
    44.238    -0.018     0.200
    44.326    -0.864     0.200
    44.326    -0.714     0.200
    44.326    -1.626     0.200
    44.452     0.421     0.200
    44.406     1.152     0.200
    44.858     0.350     0.200
    44.896     0.450     0.200
    45.019    -0.784     0.200
    45.155    -1.922     0.200
    45.167     0.343     0.200
    45.296     0.685     0.200
    45.329    -0.841     0.200
    45.381     0.507     0.200
    45.408     0.805     0.200
    45.513    -0.635     0.200
    45.671    -0.744     0.200
    45.816     3.271     0.200
    45.885     0.722     0.200
    46.571     0.916     0.200
    46.759    -0.660     0.200
    46.777     1.416     0.200
    46.976     1.289     0.200
    47.485     0.834     0.200
    47.647     0.031     0.200
    47.930     0.986     0.200
    47.963    -0.569     0.200
    47.963     0.046     0.200
    48.013    -0.257     0.200
    48.013    -0.017     0.200
    48.013     0.163     0.200
    48.019     0.698     0.200
    48.023     0.872     0.200
    48.133     0.192     0.200
    48.295     0.684     0.200
    48.396     1.402     0.200
    48.532     0.651     0.200
    48.563     0.414     0.200
    48.760     0.800     0.200
    48.830    -0.419     0.200
    48.839     0.519     0.200
    48.874     1.399     0.200
    48.890     0.098     0.200
    48.891     0.399     0.200
    48.988    -0.647     0.200
    49.049    -0.524     0.200
    49.151     0.070     0.200
    49.350     1.191     0.200
    49.478     3.721     0.200
    49.622     0.171     0.200
    49.785     0.783     0.200
    50.055     0.837     0.200
    50.210     1.630     0.200
    50.572     1.189     0.200
    50.548     0.015     0.200
    50.959    -0.374     0.200
    51.242     2.003     0.200
    51.330     2.145     0.200
    51.564     0.592     0.200
    51.607     1.542     0.200
    51.605    -0.457     0.200
    51.605    -0.457     0.200
    51.984    -0.029     0.200
    52.669     0.561     0.200
    53.066     0.340     0.200
    53.197    -0.785     0.200
    53.197    -0.555     0.200
    53.509     1.686     0.200
    53.676     0.496     0.200
    53.986    -1.958     0.200
    54.217     0.455     0.200
    54.582     1.021     0.200
    55.462    -1.172     0.200
    55.462    -1.375     0.200
    55.477    -0.242     0.200
    55.477    -0.042     0.200
    55.543    -1.016     0.200
    55.543    -1.266     0.200
    55.543    -0.834     0.200
    55.759     0.305     0.200
    56.050    -0.290     0.200
    56.085     0.736     0.200
    56.122     1.085     0.200
    56.734    -0.781     0.200
    56.939    -1.552     0.200
    57.065    -1.455     0.200
    58.282    -3.878     0.200
    58.513    -0.151     0.200
    58.553    -0.524     0.200
    58.834    -2.388     0.200
    59.380    -1.190     0.200
    59.380    -1.610     0.200
    59.668    -0.173     0.200
    59.870    -2.962     0.200
    60.333    -0.840     0.200
    60.454    -1.151     0.200
    60.490    -1.499     0.200
    60.667    -1.104     0.200
    61.004    -0.967     0.200
    61.571     0.633     0.200
    62.159     0.922     0.200
    62.239     0.840     0.200
    62.292     1.287     0.200
    62.358    -0.765     0.200
    62.358     0.059     0.200
    62.479    -1.802     0.200
    62.576    -0.763     0.200
    62.576    -0.644     0.200
    62.585    -0.985     0.200
    62.586    -0.388     0.200
    62.750     0.575     0.200
    62.882     1.617     0.200
    63.170    -1.453     0.200
    63.415     0.950     0.200
    63.431    -1.744     0.200
    63.662    -0.636     0.200
    63.765     0.986     0.200
    63.806     0.201     0.200
    64.113     0.850     0.200
    64.176    -0.910     0.200
    64.212     0.469     0.200
    64.423    -1.428     0.200
    64.521    -1.265     0.200
    64.521    -1.066     0.200
    64.611    -1.905     0.200
    64.736     1.256     0.200
    64.720    -2.299     0.200
    64.803    -0.283     0.200
    64.914    -0.585     0.200
    64.963    -1.138     0.200
    65.120     0.125     0.200
    65.200     0.872     0.200
    65.252     0.835     0.200
    65.275     0.178     0.200
    65.309     1.888     0.200
    65.323     1.145     0.200
    65.361    -0.469     0.200
    65.429    -0.256     0.200
    65.458     1.105     0.200
    65.622    -0.395     0.200
    65.696    -0.975     0.200
    65.787    -1.061     0.200
    65.952     1.129     0.200
    65.984     1.694     0.200
    66.112     1.040     0.200
    66.150     1.576     0.200
    66.127    -1.646     0.200
    66.229     1.167     0.200
    66.264     0.391     0.200
    66.306    -0.549     0.200
    66.312     0.674     0.200
    66.313    -0.037     0.200
    66.424    -0.943     0.200
    66.602     0.106     0.200
    66.645     0.253     0.200
    66.646     1.693     0.200
    66.666     0.552     0.200
    66.655    -1.187     0.200
    66.786     1.069     0.200
    66.937     1.231     0.200
    66.987    -2.026     0.200
    67.287     1.329     0.200
    67.427     0.849     0.200
    67.432     0.355     0.200
    67.490     0.897     0.200
    67.559    -0.250     0.200
    67.676     1.487     0.200
    68.043    -0.256     0.200
    68.043     0.781     0.200
    68.080     0.579     0.200
    68.148     1.247     0.200
    68.135    -1.864     0.200
    68.191     0.673     0.200
    68.314     0.450     0.200
    68.314     0.319     0.200
    68.335     0.389     0.200
    68.341    -3.350     0.200
    68.530    -0.837     0.200
    68.510    -0.476     0.200
    68.504     0.452     0.200
    68.617    -0.451     0.200
    68.697     1.159     0.200
    68.685    -0.453     0.200
    68.733     0.706     0.200
    68.802    -0.381     0.200
    68.886     1.003     0.200
    68.888    -2.457     0.200
    69.154     0.817     0.200
    69.236     0.848     0.200
    69.454     0.283     0.200
    69.454     0.515     0.200
    69.446    -0.786     0.200
    69.435     1.696     0.200
    69.481     0.826     0.200
    69.480     1.610     0.200
    69.466    -0.883     0.200
    69.475    -0.968     0.200
    69.481     0.444     0.200
    69.481     1.742     0.200
    69.481     1.244     0.200
    69.606    -0.843     0.200
    69.639     1.740     0.200
    69.639    -0.945     0.200
    69.669    -1.383     0.200
    69.669    -1.108     0.200
    69.699     1.024     0.200
    69.811     1.204     0.200
    69.801    -0.874     0.200
    69.836    -1.136     0.200
    69.822    -1.170     0.200
    69.856     0.749     0.200
    69.856     1.330     0.200
    69.875    -0.259     0.200
    69.907     0.785     0.200
    69.923     1.641     0.200
    69.922    -1.387     0.200
    69.922    -1.206     0.200
    70.065     0.526     0.200
    70.065     0.708     0.200
    70.103     1.787     0.200
    70.227     0.609     0.200
    70.215    -1.231     0.200
    70.392    -0.972     0.200
    70.392    -1.312     0.200
    70.573     1.260     0.200
    70.583    -1.183     0.200
    70.672     1.353     0.200
    70.677     1.237     0.200
    70.677     0.119     0.200
    70.711     0.001     0.200
    70.774    -0.980     0.200
    70.774    -0.912     0.200
    70.786    -1.303     0.200
    70.786    -1.004     0.200
    70.815    -1.085     0.200
    70.851     1.450     0.200
    70.870     1.698     0.200
    70.974     0.978     0.200
    70.993    -1.239     0.200
    70.993    -1.918     0.200
    71.021     0.867     0.200
    71.029     1.644     0.200
    71.065    -0.390     0.200
    71.126     0.175     0.200
    71.241     2.858     0.200
    71.272    -1.850     0.200
    71.272    -1.120     0.200
    71.337     1.943     0.200
    71.378     2.266     0.200
    71.352    -0.032     0.200
    71.418     2.375     0.200
    71.418     2.742     0.200
    71.478     0.314     0.200
    71.552     1.775     0.200
    71.559     2.165     0.200
    71.630     0.730     0.200
    71.630     0.340     0.200
    71.618     0.208     0.200
    71.676     1.494     0.200
    71.713    -0.201     0.200
    71.756     1.534     0.200
    71.759     0.946     0.200
    71.760     0.786     0.200
    71.777    -0.417     0.200
    71.815     1.677     0.200
    71.826    -0.308     0.200
    71.889    -0.176     0.200
    71.889     0.185     0.200
    71.883    -0.171     0.200
    71.923     1.703     0.200
    71.940     1.628     0.200
    71.954     1.697     0.200
    72.000     0.579     0.200
    72.130     0.306     0.200
    72.130     1.054     0.200
    72.145     1.100     0.200
    72.214     0.702     0.200
    72.171     0.379     0.200
    72.243     0.849     0.200
    72.229     0.236     0.200
    72.327     0.943     0.200
    72.344    -0.286     0.200
    72.334    -0.816     0.200
    72.495    -0.132     0.200
    72.495     0.347     0.200
    72.533     0.643     0.200
    72.533     1.303     0.200
    72.615     0.786     0.200
    72.649     0.154     0.200
    72.725     1.102     0.200
    72.854     0.444     0.200
    72.951     0.679     0.200
    72.951     1.513     0.200
    72.976     0.722     0.200
    73.010     1.896     0.200
    73.040     0.820     0.200
    73.040     1.170     0.200
    73.057     0.213     0.200
    73.057     0.611     0.200
    73.057     0.319     0.200
    73.057     0.499     0.200
    73.107     0.645     0.200
    73.138     1.578     0.200
    73.253    -1.358     0.200
    73.298     0.970     0.200
    73.440     1.424     0.200
    73.534     1.429     0.200
    73.572    -0.232     0.200
    73.584     0.002     0.200
    73.640    -0.629     0.200
    73.706     1.038     0.200
    73.747     1.496     0.200
    73.728    -0.345     0.200
    73.767     0.946     0.200
    73.866    -0.540     0.200
    73.924     0.518     0.200
    73.991     1.376     0.200
    73.970     1.041     0.200
    74.149     1.139     0.200
    74.225     0.577     0.200
    74.345    -0.719     0.200
    74.367     1.143     0.200
    74.381     1.709     0.200
    74.438     1.670     0.200
    74.442     0.084     0.200
    74.472     1.521     0.200
    74.486     0.060     0.200
    74.486     0.511     0.200
    74.506    -0.142     0.200
    74.539    -0.265     0.200
    74.632     0.119     0.200
    74.748     2.271     0.200
    74.765    -0.215     0.200
    74.765     0.244     0.200
    74.797     1.540     0.200
    74.810     1.736     0.200
    74.815     0.843     0.200
    74.807     0.052     0.200
    74.821    -0.146     0.200
    74.821     0.002     0.200
    74.865     0.050     0.200
    74.904     0.121     0.200
    74.962     1.061     0.200
    74.959    -0.094     0.200
    74.989     1.283     0.200
    75.025    -0.099     0.200
    75.025     0.157     0.200
    75.065    -0.137     0.200
    75.074     0.541     0.200
    75.074     2.331     0.200
    75.087     0.657     0.200
    75.087     1.477     0.200
    75.091     1.469     0.200
    75.121     0.398     0.200
    75.153     0.512     0.200
    75.205    -0.110     0.200
    75.215     1.463     0.200
    75.222    -0.077     0.200
    75.374    -0.277     0.200
    75.391     0.027     0.200
    75.391    -0.075     0.200
    75.439     0.349     0.200
    75.545    -0.921     0.200
    75.548     0.447     0.200
    75.529     0.034     0.200
    75.575     0.002     0.200
    75.575     0.572     0.200
    75.584    -0.274     0.200
    75.608     0.183     0.200
    75.629     0.353     0.200
    75.643     0.183     0.200
    75.689     0.172     0.200
    75.678    -0.219     0.200
    75.826    -1.281     0.200
    75.826    -0.764     0.200
    75.941    -0.199     0.200
    75.941    -0.393     0.200
    75.953     0.713     0.200
    76.025     0.608     0.200
    76.040     0.323     0.200
    76.040    -0.097     0.200
    76.136    -0.017     0.200
    76.137     0.273     0.200
    76.200     1.471     0.200
    76.204    -0.255     0.200
    76.207    -1.020     0.200
    76.183     0.608     0.200
    76.176     0.217     0.200
    76.177     0.146     0.200
    76.247     1.227     0.200
    76.231     0.537     0.200
    76.275    -1.028     0.200
    76.302     1.498     0.200
    76.303    -0.800     0.200
    76.303     1.602     0.200
    76.349     1.116     0.200
    76.372     1.372     0.200
    76.403     1.545     0.200
    76.415     1.293     0.200
    76.450     1.460     0.200
    76.453     1.201     0.200
    76.481     1.562     0.200
    76.486     1.395     0.200
    76.502     1.416     0.200
    76.484     0.104     0.200
    76.513     1.530     0.200
    76.531     1.202     0.200
    76.505     0.584     0.200
    76.512     0.249     0.200
    76.516     0.526     0.200
    76.543     0.471     0.200
    76.543     0.610     0.200
    76.543     0.739     0.200
    76.552     0.019     0.200
    76.575    -0.009     0.200
    76.612     1.412     0.200
    76.626     1.343     0.200
    76.697    -0.894     0.200
    76.697    -0.648     0.200
    76.734    -1.048     0.200
    76.932    -0.430     0.200
    76.932     0.181     0.200
    76.943     1.249     0.200
    76.955     0.155     0.200
    76.955     0.354     0.200
    76.956     0.044     0.200
    77.002    -0.911     0.200
    77.002    -1.212     0.200
    77.007    -0.510     0.200
    77.049     0.323     0.200
    77.100    -1.054     0.200
    77.153     1.142     0.200
    77.253     1.270     0.200
    77.234     0.187     0.200
    77.234    -0.014     0.200
    77.301    -0.511     0.200
    77.383    -0.524     0.200
    77.453    -0.066     0.200
    77.453     1.426     0.200
    77.460     0.125     0.200
    77.490    -0.398     0.200
    77.494     0.234     0.200
    77.509    -0.050     0.200
    77.541    -0.691     0.200
    77.545    -1.041     0.200
    77.696     0.407     0.200
    77.795    -1.174     0.200
    77.839    -0.769     0.200
    77.855    -1.074     0.200
    77.855    -0.871     0.200
    77.921    -0.569     0.200
    77.956    -0.929     0.200
    77.956    -0.592     0.200
    77.962    -0.366     0.200
    78.000    -0.694     0.200
    78.027     0.147     0.200
    78.027     1.520     0.200
    78.099    -0.380     0.200
    78.155    -0.339     0.200
    78.184    -0.952     0.200
    78.228    -0.888     0.200
    78.251    -0.650     0.200
    78.259    -0.549     0.200
    78.328    -0.703     0.200
    78.336    -0.425     0.200
    78.336    -0.273     0.200
    78.475    -0.120     0.200
    78.538     0.451     0.200
    78.557     0.044     0.200
    78.557     0.155     0.200
    78.556    -0.245     0.200
    78.627     0.640     0.200
    78.659    -0.278     0.200
    78.644     0.937     0.200
    78.721    -0.873     0.200
    78.742    -0.321     0.200
    78.742    -0.347     0.200
    78.749    -0.438     0.200
    78.771     1.110     0.200
    78.790    -0.231     0.200
    78.947    -0.536     0.200
    78.947    -0.275     0.200
    78.988    -0.747     0.200
    78.988    -1.018     0.200
    78.979     0.329     0.200
    78.981     0.174     0.200
    79.036    -0.506     0.200
    79.108    -1.136     0.200
    79.082     0.369     0.200
    79.136     0.573     0.200
    79.152    -0.115     0.200
    79.152     1.087     0.200
    79.221    -0.812     0.200
    79.307     0.139     0.200
    79.329    -0.144     0.200
    79.361    -0.976     0.200
    79.377     0.439     0.200
    79.429    -0.672     0.200
    79.429     0.796     0.200
    79.450     0.262     0.200
    79.484     0.035     0.200
    79.484     1.539     0.200
    79.457     0.623     0.200
    79.535    -0.706     0.200
    79.535    -0.575     0.200
    79.538    -0.503     0.200
    79.516     0.406     0.200
    79.590    -0.754     0.200
    79.682     0.091     0.200
    79.724     0.156     0.200
    79.724     0.267     0.200
    79.804    -0.752     0.200
    79.810    -0.550     0.200
    79.811    -0.246     0.200
    79.811     0.828     0.200
    79.817     0.873     0.200
    79.859    -0.602     0.200
    79.859    -0.135     0.200
    79.868    -0.822     0.200
    79.932    -0.604     0.200
    79.962    -0.805     0.200
    79.949    -0.351     0.200
    79.956    -0.657     0.200
    79.988    -0.505     0.200
    79.993    -1.032     0.200
    80.010    -0.979     0.200
    80.010    -0.270     0.200
    80.020     0.279     0.200
    80.138    -0.744     0.200
    80.125     0.310     0.200
    80.134     0.061     0.200
    80.179    -0.584     0.200
    80.195    -0.557     0.200
    80.196    -1.178     0.200
    80.214    -0.428     0.200
    80.214     0.103     0.200
    80.216    -0.010     0.200
    80.217     0.786     0.200
    80.217     0.022     0.200
    80.217     0.936     0.200
    80.218    -0.074     0.200
    80.318    -0.825     0.200
    80.318    -0.358     0.200
    80.300    -0.795     0.200
    80.320     0.274     0.200
    80.375    -1.192     0.200
    80.402    -0.664     0.200
    80.402    -0.878     0.200
    80.443    -0.397     0.200
    80.481    -0.397     0.200
    80.479    -0.538     0.200
    80.568    -0.624     0.200
    80.625    -0.787     0.200
    80.625    -0.518     0.200
    80.629    -0.701     0.200
    80.633    -0.852     0.200
    80.651    -0.948     0.200
    80.673    -1.115     0.200
    80.694    -0.509     0.200
    80.706    -0.602     0.200
    80.706    -0.404     0.200
    80.686    -0.816     0.200
    80.740    -0.486     0.200
    80.751    -0.142     0.200
    80.774    -0.764     0.200
    80.774    -0.045     0.200
    80.802    -0.485     0.200
    80.795    -0.377     0.200
    80.790    -0.371     0.200
    80.797     0.402     0.200
    80.833     0.100     0.200
    80.836     0.323     0.200
    80.866     0.043     0.200
    80.910    -0.933     0.200
    80.919    -1.159     0.200
    80.980    -0.146     0.200
    81.045    -1.054     0.200
    81.060    -0.956     0.200
    81.078    -0.879     0.200
    81.051    -0.042     0.200
    81.057    -0.171     0.200
    81.066    -0.620     0.200
    81.060    -0.686     0.200
    81.098    -1.089     0.200
    81.078    -0.487     0.200
    81.116    -0.750     0.200
    81.143    -0.186     0.200
    81.176    -0.975     0.200
    81.178    -1.108     0.200
    81.178    -0.643     0.200
    81.162    -1.381     0.200
    81.162    -0.231     0.200
    81.380    -0.889     0.200
    81.380    -0.711     0.200
    81.388    -0.914     0.200
    81.380     0.094     0.200
    81.380    -0.882     0.200
    81.392    -0.006     0.200
    81.421    -1.255     0.200
    81.463    -0.820     0.200
    81.477    -0.155     0.200
    81.508    -1.163     0.200
    81.526    -0.519     0.200
    81.505    -0.343     0.200
    81.505    -0.443     0.200
    81.545    -0.868     0.200
    81.553    -0.736     0.200
    81.532    -0.286     0.200
    81.570    -0.678     0.200
    81.570    -0.438     0.200
    81.569    -0.780     0.200
    81.602    -0.931     0.200
    81.583    -0.355     0.200
    81.672    -0.885     0.200
    81.735    -0.502     0.200
    81.728    -0.420     0.200
    81.773    -0.745     0.200
    81.760    -0.309     0.200
    81.773    -0.553     0.200
    81.781    -0.568     0.200
    81.806    -0.298     0.200
    81.806    -0.029     0.200
    81.840    -1.111     0.200
    81.881    -1.094     0.200
    81.886    -1.172     0.200
    81.875    -0.791     0.200
    81.891     0.324     0.200
    81.902    -0.044     0.200
    81.925    -1.197     0.200
    81.940    -1.147     0.200
    81.946    -0.227     0.200
    81.946    -0.486     0.200
    81.946     0.036     0.200
    81.971    -0.563     0.200
    81.992    -0.405     0.200
    82.120    -0.374     0.200
    82.199    -0.917     0.200
    82.229    -0.720     0.200
    82.224    -0.220     0.200
    82.265    -0.876     0.200
    82.279    -1.214     0.200
    82.279    -0.356     0.200
    82.288    -0.751     0.200
    82.334    -0.704     0.200
    82.338    -0.263     0.200
    82.375    -0.168     0.200
    82.375     0.243     0.200
    82.360    -0.159     0.200
    82.419    -1.268     0.200
    82.479    -0.926     0.200
    82.479    -0.399     0.200
    82.488    -1.177     0.200
    82.488    -0.876     0.200
    82.528    -0.202     0.200
    82.609    -1.099     0.200
    82.652    -1.022     0.200
    82.665    -1.043     0.200
    82.709    -0.951     0.200
    82.735    -0.830     0.200
    82.765    -0.638     0.200
    82.810    -0.830     0.200
    82.866    -0.623     0.200
    82.966    -0.581     0.200
    82.966     1.145     0.200
    82.991    -0.875     0.200
    83.026    -0.582     0.200
    83.026     1.264     0.200
    83.049    -0.850     0.200
    83.086    -0.469     0.200
    83.086     0.025     0.200
    83.125    -0.440     0.200
    83.165     0.246     0.200
    83.165     0.940     0.200
    83.218    -0.216     0.200
    83.223    -0.198     0.200
    83.204    -0.153     0.200
    83.198    -0.774     0.200
    83.255    -0.867     0.200
    83.372    -0.470     0.200
    83.441    -0.720     0.200
    83.475    -0.966     0.200
    83.475    -0.497     0.200
    83.489    -0.722     0.200
    83.489    -0.369     0.200
    83.506    -0.603     0.200
    83.490    -1.473     0.200
    83.558    -0.934     0.200
    83.583    -0.344     0.200
    83.583     0.070     0.200
    83.590    -0.693     0.200
    83.648    -0.680     0.200
    83.674    -0.615     0.200
    83.721    -0.977     0.200
    83.735    -0.866     0.200
    83.805    -0.484     0.200
    83.877    -1.041     0.200
    83.977    -0.199     0.200
    83.950     0.178     0.200
    83.977    -0.859     0.200
    84.061    -0.533     0.200
    84.063    -0.381     0.200
    84.094    -0.555     0.200
    84.134     0.443     0.200
    84.182    -0.605     0.200
    84.246    -0.714     0.200
    84.256    -0.618     0.200
    84.305    -0.516     0.200
    84.282    -0.910     0.200
    84.364    -0.494     0.200
    84.364     0.098     0.200
    84.441    -0.520     0.200
    84.419    -0.099     0.200
    84.451     0.035     0.200
    84.526    -1.030     0.200
    84.553    -0.643     0.200
    84.527    -0.347     0.200
    84.551    -0.660     0.200
    84.577    -1.099     0.200
    84.595    -1.291     0.200
    84.660    -0.415     0.200
    84.660     0.351     0.200
    84.684    -1.013     0.200
    84.686    -0.739     0.200
    84.710    -0.296     0.200
    84.703    -0.031     0.200
    84.744    -0.540     0.200
    84.775    -0.264     0.200
    84.827    -0.757     0.200
    84.850    -0.484     0.200
    84.960    -0.873     0.200
    85.019    -0.328     0.200
    85.029    -0.586     0.200
    85.015    -1.167     0.200
    85.114    -0.439     0.200
    85.114    -0.222     0.200
    85.130    -0.457     0.200
    85.194     0.163     0.200
    85.201    -0.676     0.200
    85.201    -0.356     0.200
    85.206    -0.379     0.200
    85.218    -0.171     0.200
    85.221    -1.243     0.200
    85.233    -0.294     0.200
    85.239    -0.313     0.200
    85.234     0.307     0.200
    85.234    -0.033     0.200
    85.344     0.035     0.200
    85.344     0.631     0.200
    85.358    -0.532     0.200
    85.395    -0.069     0.200
    85.445    -0.943     0.200
    85.438    -0.809     0.200
    85.505    -0.889     0.200
    85.565    -0.799     0.200
    85.566    -0.103     0.200
    85.614    -0.602     0.200
    85.655    -0.366     0.200
    85.659    -0.253     0.200
    85.674    -0.536     0.200
    85.697    -0.564     0.200
    85.755    -0.584     0.200
    85.762    -0.883     0.200
    85.778    -0.451     0.200
    85.778     0.856     0.200
    85.839    -0.875     0.200
    85.839    -0.705     0.200
    85.893     0.885     0.200
    85.894     0.856     0.200
    85.915     0.029     0.200
    85.915     0.746     0.200
    85.917     0.047     0.200
    85.923    -0.662     0.200
    85.923     0.086     0.200
    85.929    -0.181     0.200
    85.949    -0.362     0.200
    85.993    -0.807     0.200
    85.998     0.037     0.200
    86.019    -0.759     0.200
    86.039    -0.846     0.200
    86.048    -0.725     0.200
    86.111    -1.632     0.200
    86.149    -0.452     0.200
    86.272    -0.512     0.200
    86.328    -0.473     0.200
    86.336    -0.527     0.200
    86.336     0.051     0.200
    86.357    -0.646     0.200
    86.357    -0.345     0.200
    86.360     0.888     0.200
    86.422     0.224     0.200
    86.440    -0.849     0.200
    86.472    -0.542     0.200
    86.481    -0.457     0.200
    86.493    -0.469     0.200
    86.500    -0.115     0.200
    86.669    -0.294     0.200
    86.774    -0.303     0.200
    86.806    -0.657     0.200
    86.806    -0.026     0.200
    86.826     0.177     0.200
    86.856    -0.847     0.200
    86.856    -0.883     0.200
    86.926    -0.797     0.200
    86.931    -0.935     0.200
    86.931    -0.337     0.200
    86.951    -0.841     0.200
    87.018    -1.028     0.200
    87.035    -1.064     0.200
    87.094    -0.344     0.200
    87.103    -1.009     0.200
    87.141    -0.785     0.200
    87.148    -0.460     0.200
    87.256    -0.979     0.200
    87.258    -0.989     0.200
    87.277    -0.854     0.200
    87.278    -0.718     0.200
    87.290    -0.747     0.200
    87.290     0.405     0.200
    87.294    -0.661     0.200
    87.296    -0.412     0.200
    87.296     0.027     0.200
    87.342    -0.865     0.200
    87.404    -0.567     0.200
    87.404    -0.377     0.200
    87.467    -0.183     0.200
    87.476    -0.681     0.200
    87.517    -0.660     0.200
    87.541    -0.169     0.200
    87.541     0.350     0.200
    87.590    -0.432     0.200
    87.604     0.281     0.200
    87.638    -0.379     0.200
    87.645    -0.439     0.200
    87.665    -0.964     0.200
    87.687     0.196     0.200
    87.713    -0.531     0.200
    87.717    -0.421     0.200
    87.740     0.734     0.200
    87.780    -0.808     0.200
    87.780     0.436     0.200
    87.856    -0.640     0.200
    87.888    -0.179     0.200
    87.964    -0.612     0.200
    87.968    -0.510     0.200
    87.990    -0.977     0.200
    87.990     0.066     0.200
    88.010    -0.161     0.200
    88.044    -1.361     0.200
    88.047    -0.047     0.200
    88.047     0.420     0.200
    88.066    -0.426     0.200
    88.091    -0.706     0.200
    88.120    -0.127     0.200
    88.301     0.163     0.200
    88.339    -0.091     0.200
    88.339     0.239     0.200
    88.462    -0.298     0.200
    88.486    -0.141     0.200
    88.535    -0.330     0.200
    88.624    -0.443     0.200
    88.642    -0.328     0.200
    88.648    -0.177     0.200
    88.705    -0.026     0.200
    88.716    -0.806     0.200
    88.727     0.110     0.200
    88.857    -0.122     0.200
    88.859    -0.033     0.200
    88.927    -0.589     0.200
    88.955     0.619     0.200
    89.008    -0.168     0.200
    89.036    -0.227     0.200
    89.075    -0.467     0.200
    89.075     0.273     0.200
    89.160    -0.241     0.200
    89.210    -0.451     0.200
    89.227    -0.377     0.200
    89.314    -0.355     0.200
    89.314     0.252     0.200
    89.332    -0.788     0.200
    89.355    -0.329     0.200
    89.359     0.242     0.200
    89.411    -0.546     0.200
    89.411     0.311     0.200
    89.397     1.492     0.200
    89.466    -0.333     0.200
    89.479    -0.095     0.200
    89.519    -0.313     0.200
    89.523    -0.255     0.200
    89.641    -0.249     0.200
    89.641    -0.456     0.200
    89.691    -0.330     0.200
    89.692    -0.632     0.200
    89.696    -0.640     0.200
    89.712    -0.718     0.200
    89.712     0.243     0.200
    89.720    -0.085     0.200
    89.861    -1.065     0.200
    89.861     0.327     0.200
    89.894    -1.087     0.200
    89.897    -0.322     0.200
    89.897    -1.061     0.200
    89.926     0.395     0.200
    90.078     0.686     0.200
    90.098    -0.732     0.200
    90.127    -0.948     0.200
    90.132    -0.369     0.200
    90.194    -0.236     0.200
    90.259    -0.366     0.200
    90.304    -0.856     0.200
    90.380    -0.474     0.200
    90.417    -0.777     0.200
    90.419    -1.273     0.200
    90.530     0.531     0.200
    90.588    -0.429     0.200
    90.629    -0.551     0.200
    90.653    -0.937     0.200
    90.653     0.528     0.200
    90.700    -0.436     0.200
    90.701     0.053     0.200
    90.817    -0.632     0.200
    90.859    -0.411     0.200
    90.886    -0.823     0.200
    90.923    -1.145     0.200
    90.923     0.452     0.200
    90.995    -0.705     0.200
    90.997    -0.317     0.200
    90.997     0.261     0.200
    91.102    -0.416     0.200
    91.143     0.481     0.200
    91.200    -0.949     0.200
    91.222    -0.746     0.200
    91.223    -1.163     0.200
    91.223     0.210     0.200
    91.300     0.037     0.200
    91.300     0.406     0.200
    91.330    -1.101     0.200
    91.401    -0.386     0.200
    91.412    -0.785     0.200
    91.456    -1.317     0.200
    91.602    -1.129     0.200
    91.709    -1.113     0.200
    91.797    -0.617     0.200
    91.890    -1.575     0.200
    91.979    -1.682     0.200
    92.064    -0.250     0.200
    92.133    -1.281     0.200
    92.192    -0.907     0.200
    92.237    -0.652     0.200
    92.330    -0.888     0.200
    92.330     0.272     0.200
    92.460    -0.856     0.200
    92.480    -1.627     0.200
    92.471    -0.532     0.200
    92.488    -0.408     0.200
    92.558    -0.531     0.200
    92.818    -1.160     0.200
    92.893    -0.325     0.200
    92.937    -0.429     0.200
    93.174    -0.742     0.200
    93.292    -1.203     0.200
    93.326    -0.370     0.200
    93.326    -0.941     0.200
    94.764    -0.672     0.200
    96.041    -0.498     0.200
    17.592     0.639     0.200
    17.921    -1.348     0.200
    19.603    -0.411     0.200
    19.603    -0.661     0.200
    20.288    -1.753     0.200
    20.299    -1.742     0.200
    20.712     0.267     0.200
    20.899    -2.553     0.200
    21.266    -3.089     0.200
    21.360    -2.420     0.200
    21.360    -2.894     0.200
    21.732    -1.476     0.200
    23.491    -0.599     0.200
    23.785    -2.588     0.200
    23.951    -2.901     0.200
    24.687     0.190     0.200
    25.092    -1.126     0.200
    25.752    -0.972     0.200
    26.013    -0.193     0.200
    26.121     0.012     0.200
    26.243    -0.876     0.200
    26.248     0.021     0.200
    26.248     0.021     0.200
    26.571     1.230     0.200
    27.768    -1.001     0.200
    27.889    -0.873     0.200
    28.723    -1.270     0.200
    29.379    -0.821     0.200
    29.759     0.225     0.200
    30.273    -1.142     0.200
    30.770     0.792     0.200
    31.241    -3.655     0.200
    31.962    -0.287     0.200
    32.527     0.459     0.200
    33.220     0.403     0.200
    33.610    -0.591     0.200
    34.337    -0.194     0.200
    36.416     0.864     0.200
    37.225     0.085     0.200
    38.506    -0.408     0.200
    39.424    -1.250     0.200
    39.437    -0.469     0.200
    39.438    -0.944     0.200
    39.438    -0.469     0.200
    39.438    -1.074     0.200
    39.777     0.284     0.200
    40.242    -0.463     0.200
    40.431     0.361     0.200
    40.643     0.881     0.200
    41.516    -1.056     0.200
    41.554     1.140     0.200
    41.753     1.512     0.200
    41.991     2.172     0.200
    42.061     1.732     0.200
    42.130    -1.899     0.200
    42.186     1.344     0.200
    42.215     0.349     0.200
    42.432    -0.305     0.200
    42.541    -0.930     0.200
    42.541    -0.246     0.200
    42.541    -0.396     0.200
    42.541     0.134     0.200
    42.541     0.133     0.200
    42.541    -0.246     0.200
    42.680     0.317     0.200
    42.730     0.129     0.200
    42.759    -0.308     0.200
    42.742    -0.211     0.200
    42.967    -0.289     0.200
    42.929     2.918     0.200
    43.020    -0.395     0.200
    42.983     0.921     0.200
    43.146     1.109     0.200
    43.172     2.246     0.200
    43.172     1.840     0.200
    43.233    -0.392     0.200
    43.233    -1.512     0.200
    43.240     1.352     0.200
    43.267     0.929     0.200
    43.605     0.253     0.200
    43.666    -0.363     0.200
    43.711    -0.340     0.200
    43.668     1.303     0.200
    43.789    -0.169     0.200
    43.828     0.041     0.200
    43.797    -0.324     0.200
    43.797     0.286     0.200
    43.797    -0.534     0.200
    43.921    -0.043     0.200
    43.877    -0.167     0.200
    43.856     0.392     0.200
    43.995     0.225     0.200
    43.954     0.709     0.200
    43.956     0.801     0.200
    43.956     1.111     0.200
    44.031    -0.183     0.200
    44.064     0.227     0.200
    44.030     1.501     0.200
    44.078     0.763     0.200
    44.195    -0.989     0.200
    44.195     1.331     0.200
    44.195    -0.993     0.200
    44.195     0.981     0.200
    44.365    -0.294     0.200
    44.414    -0.817     0.200
    44.414    -0.497     0.200
    44.414    -1.329     0.200
    44.419    -0.652     0.200
    44.373     1.056     0.200
    44.534     0.331     0.200
    45.099    -0.156     0.200
    45.239     2.290     0.200
    45.172    -2.097     0.200
    45.248     0.218     0.200
    45.377     0.247     0.200
    45.415    -1.259     0.200
    45.436     1.718     0.200
    45.565    -0.706     0.200
    45.758    -0.966     0.200
    45.783     3.974     0.200
    45.829     2.414     0.200
    45.966     0.746     0.200
    46.040     1.031     0.200
    46.084     0.163     0.200
    46.622     1.305     0.200
    46.710     0.882     0.200
    46.847    -0.911     0.200
    46.858     1.382     0.200
    47.031     0.397     0.200
    46.983     1.168     0.200
    47.491     1.216     0.200
    47.581     1.719     0.200
    47.735    -0.030     0.200
    47.940     0.942     0.200
    48.040    -0.429     0.200
    48.040     0.357     0.200
    48.027     0.570     0.200
    48.033     0.721     0.200
    48.090    -0.059     0.200
    48.090     0.151     0.200
    48.090    -0.219     0.200
    48.185     1.343     0.200
    48.319     1.575     0.200
    48.319     1.315     0.200
    48.349     0.620     0.200
    48.349     0.290     0.200
    48.455    -0.230     0.200
    48.543     0.594     0.200
    48.574     0.362     0.200
    48.771     0.444     0.200
    48.885    -0.058     0.200
    48.892     0.486     0.200
    48.904     0.331     0.200
    48.926     1.087     0.200
    49.043    -0.234     0.200
    49.144    -0.747     0.200
    49.205     0.044     0.200
    49.205     0.153     0.200
    49.205     0.394     0.200
    49.365     1.009     0.200
    49.524     3.895     0.200
    49.677     0.001     0.200
    49.955     0.869     0.200
    50.070     0.650     0.200
    50.135     2.419     0.200
    50.603    -0.278     0.200
    50.654     1.091     0.200
    51.008    -0.223     0.200
    51.348     2.474     0.200
    51.282     2.931     0.200
    51.313     1.897     0.200
    51.686     1.174     0.200
    51.663    -0.318     0.200
    51.663    -0.318     0.200
    52.071     0.047     0.200
    52.511     1.019     0.200
    52.519     2.143     0.200
    52.615     0.627     0.200
    52.615     0.917     0.200
    52.735    -0.056     0.200
    52.780    -0.322     0.200
    53.161     1.495     0.200
    53.192     0.886     0.200
    53.445     1.807     0.200
    53.756     1.492     0.200
    54.254     0.597     0.200
    54.653     1.017     0.200
    55.574    -1.434     0.200
    55.553    -0.573     0.200
    55.553    -0.154     0.200
    55.704    -0.449     0.200
    55.951     0.855     0.200
    55.977     0.177     0.200
    56.010     1.724     0.200
    56.128    -0.392     0.200
    56.276     1.265     0.200
    56.777    -0.882     0.200
    56.953    -0.092     0.200
    57.036    -1.136     0.200
    57.624     0.085     0.200
    58.387    -1.811     0.200
    58.645    -0.912     0.200
    58.941    -1.226     0.200
    59.487    -1.107     0.200
    59.487    -1.111     0.200
    59.487    -1.387     0.200
    59.690    -1.741     0.200
    59.668    -0.380     0.200
    59.968    -2.741     0.200
    60.441    -0.953     0.200
    60.603    -1.176     0.200
    61.113    -1.924     0.200
    61.212    -0.694     0.200
    61.644     1.002     0.200
    62.228    -0.097     0.200
    62.179     0.662     0.200
    62.227    -0.456     0.200
    62.227    -0.141     0.200
    62.306     0.612     0.200
    62.416    -0.930     0.200
    62.416     0.057     0.200
    62.459     0.096     0.200
    62.466     0.125     0.200
    62.475     0.383     0.200
    62.476    -0.825     0.200
    62.476    -0.820     0.200
    62.668     0.206     0.200
    62.819     0.272     0.200
    62.948     1.887     0.200
    63.046     0.841     0.200
    63.483     2.278     0.200
    63.511     0.948     0.200
    63.756    -2.472     0.200
    63.832     1.018     0.200
    64.155     0.401     0.200
    64.182     0.482     0.200
    64.283     0.816     0.200
    64.276     0.015     0.200
    64.387     0.961     0.200
    64.526     0.517     0.200
    64.511    -1.617     0.200
    64.570     0.742     0.200
    64.643     0.878     0.200
    64.615    -1.247     0.200
    64.684     0.949     0.200
    64.713    -1.215     0.200
    64.714    -1.314     0.200
    64.714    -1.319     0.200
    64.800     1.300     0.200
    64.762     0.466     0.200
    64.762     0.657     0.200
    64.980     0.625     0.200
    65.071     0.356     0.200
    65.182     0.585     0.200
    65.186     0.962     0.200
    65.269     0.222     0.200
    65.320     1.622     0.200
    65.387    -0.122     0.200
    65.387    -0.012     0.200
    65.420     0.374     0.200
    65.493     0.295     0.200
    65.527     0.409     0.200
    65.533     0.520     0.200
    65.533     0.074     0.200
    65.548     1.591     0.200
    65.684     0.690     0.200
    65.784    -1.070     0.200
    65.875    -0.453     0.200
    66.021     0.929     0.200
    66.047     1.333     0.200
    66.091     2.622     0.200
    66.167     0.366     0.200
    66.174     0.418     0.200
    66.209     1.362     0.200
    66.209     1.724     0.200
    66.196    -0.222     0.200
    66.257    -0.096     0.200
    66.202     0.231     0.200
    66.203     0.223     0.200
    66.296     1.065     0.200
    66.322     0.485     0.200
    66.524    -1.310     0.200
    66.660     1.393     0.200
    66.704     0.379     0.200
    66.707     1.622     0.200
    66.641     1.385     0.200
    66.741     0.617     0.200
    66.763    -0.821     0.200
    66.855     1.033     0.200
    66.994     1.720     0.200
    67.082     1.152     0.200
    67.062    -1.730     0.200
    67.361     1.356     0.200
    67.494     1.044     0.200
    67.511     0.226     0.200
    67.617     0.161     0.200
    67.741     1.482     0.200
    68.116     0.725     0.200
    68.116     0.280     0.200
    68.157     0.165     0.200
    68.211     1.290     0.200
    68.248     0.269     0.200
    68.283    -0.159     0.200
    68.392     0.469     0.200
    68.392     0.784     0.200
    68.392    -0.400     0.200
    68.412     0.546     0.200
    68.417    -1.755     0.200
    68.618    -0.451     0.200
    68.578     0.828     0.200
    68.755     0.855     0.200
    68.810    -0.106     0.200
    69.220     1.221     0.200
    69.310     1.527     0.200
    69.446     1.259     0.200
    69.506    -1.040     0.200
    69.538     2.158     0.200
    69.513    -0.985     0.200
    69.553     0.587     0.200
    69.510     0.763     0.200
    69.510     1.133     0.200
    69.539    -0.967     0.200
    69.546    -1.088     0.200
    69.549    -1.158     0.200
    69.553    -1.083     0.200
    69.554     1.465     0.200
    69.554     1.704     0.200
    69.554     2.364     0.200
    69.554     1.295     0.200
    69.573    -0.954     0.200
    69.575    -0.966     0.200
    69.582    -1.528     0.200
    69.599    -1.066     0.200
    69.605    -1.051     0.200
    69.616    -1.139     0.200
    69.634    -1.081     0.200
    69.651    -1.839     0.200
    69.658    -0.846     0.200
    69.697     1.930     0.200
    69.688    -0.866     0.200
    69.688    -0.835     0.200
    69.713    -0.936     0.200
    69.719    -0.926     0.200
    69.745    -0.966     0.200
    69.756    -0.978     0.200
    69.768    -1.262     0.200
    69.776    -1.374     0.200
    69.776    -0.904     0.200
    69.776    -1.212     0.200
    69.784    -1.076     0.200
    69.784    -0.974     0.200
    69.813    -1.031     0.200
    69.867     0.579     0.200
    69.871    -1.155     0.200
    69.924     1.307     0.200
    69.924     0.918     0.200
    69.896    -1.614     0.200
    69.906    -1.151     0.200
    69.908    -1.216     0.200
    69.928    -1.309     0.200
    69.928    -1.559     0.200
    69.931    -0.904     0.200
    69.932    -1.335     0.200
    69.943    -1.297     0.200
    69.978     1.266     0.200
    69.981     0.590     0.200
    69.970    -1.318     0.200
    69.978    -1.343     0.200
    69.983     0.423     0.200
    70.029    -1.376     0.200
    70.043    -0.912     0.200
    70.057    -1.099     0.200
    70.061    -1.073     0.200
    70.092    -1.641     0.200
    70.097    -1.672     0.200
    70.138     0.367     0.200
    70.160     1.452     0.200
    70.289     1.366     0.200
    70.295    -0.355     0.200
    70.632     0.944     0.200
    70.641    -1.552     0.200
    70.718     0.053     0.200
    70.719     0.966     0.200
    70.752    -0.107     0.200
    70.816    -0.874     0.200
    70.900     0.987     0.200
    70.900     0.918     0.200
    70.867    -0.960     0.200
    70.867    -0.935     0.200
    70.879    -1.273     0.200
    70.879    -1.408     0.200
    70.923     1.887     0.200
    70.926     1.819     0.200
    70.909    -0.738     0.200
    70.986     1.951     0.200
    70.988     1.250     0.200
    70.971     0.122     0.200
    71.048     1.429     0.200
    71.047    -0.883     0.200
    71.091    -1.493     0.200
    71.166    -0.122     0.200
    71.313     3.275     0.200
    71.389     1.767     0.200
    71.392    -0.069     0.200
    71.449     2.666     0.200
    71.490     3.519     0.200
    71.490     2.485     0.200
    71.517     0.239     0.200
    71.623     2.098     0.200
    71.630     2.096     0.200
    71.703     1.057     0.200
    71.703     0.580     0.200
    71.658     0.181     0.200
    71.747     1.598     0.200
    71.812     0.872     0.200
    71.815     0.799     0.200
    71.886     1.063     0.200
    71.885    -0.545     0.200
    71.934    -0.816     0.200
    71.970    -0.251     0.200
    71.994     1.868     0.200
    71.998     1.373     0.200
    71.991    -0.286     0.200
    72.024     1.394     0.200
    72.197     0.976     0.200
    72.208     1.059     0.200
    72.208     0.253     0.200
    72.211    -0.099     0.200
    72.299     0.731     0.200
    72.268     0.002     0.200
    72.384     0.976     0.200
    72.419     0.436     0.200
    72.544     0.276     0.200
    72.549     0.853     0.200
    72.549     0.405     0.200
    72.593     0.703     0.200
    72.668     0.338     0.200
    72.704     0.703     0.200
    72.793     1.138     0.200
    72.910     0.743     0.200
    73.016     0.935     0.200
    73.016     0.664     0.200
    73.033     0.993     0.200
    73.098     1.166     0.200
    73.098     0.526     0.200
    73.078    -0.969     0.200
    73.128     0.339     0.200
    73.128     0.208     0.200
    73.128     0.338     0.200
    73.128     0.238     0.200
    73.128    -0.122     0.200
    73.162    -0.128     0.200
    73.169     0.378     0.200
    73.206     1.707     0.200
    73.351     0.700     0.200
    73.356    -1.107     0.200
    73.426     0.681     0.200
    73.502     1.585     0.200
    73.526     1.935     0.200
    73.600     1.321     0.200
    73.682     0.040     0.200
    73.812     1.205     0.200
    73.822     0.928     0.200
    73.822     0.054     0.200
    73.823    -0.948     0.200
    73.858     0.327     0.200
    73.977     0.188     0.200
    73.967    -0.604     0.200
    74.038     0.403     0.200
    74.050     1.840     0.200
    74.124    -1.005     0.200
    74.281     0.493     0.200
    74.312    -0.198     0.200
    74.422     0.875     0.200
    74.434    -1.078     0.200
    74.442     1.846     0.200
    74.501     1.865     0.200
    74.537     1.706     0.200
    74.569     0.107     0.200
    74.538     0.070     0.200
    74.576     1.922     0.200
    74.684     0.480     0.200
    74.687     1.720     0.200
    74.811     1.980     0.200
    74.838     0.674     0.200
    74.838     0.291     0.200
    74.864     1.598     0.200
    74.871     0.606     0.200
    74.871     1.888     0.200
    74.900    -0.033     0.200
    74.914    -0.180     0.200
    74.914    -0.082     0.200
    74.954    -0.910     0.200
    74.996    -0.056     0.200
    75.055     0.726     0.200
    75.050    -0.366     0.200
    75.102     0.447     0.200
    75.102     0.146     0.200
    75.119     1.977     0.200
    75.127     0.571     0.200
    75.137     0.873     0.200
    75.141     1.043     0.200
    75.141     0.566     0.200
    75.144     1.036     0.200
    75.175     0.103     0.200
    75.294    -0.471     0.200
    75.297     1.686     0.200
    75.320    -0.108     0.200
    75.320    -0.218     0.200
    75.398     1.133     0.200
    75.469    -0.173     0.200
    75.481    -0.143     0.200
    75.530     0.580     0.200
    75.603     0.719     0.200
    75.633    -1.008     0.200
    75.636     0.506     0.200
    75.644     0.999     0.200
    75.644     0.026     0.200
    75.625    -0.164     0.200
    75.675    -0.147     0.200
    75.701     0.302     0.200
    75.743     0.650     0.200
    75.726     0.209     0.200
    75.738    -0.009     0.200
    75.738     0.091     0.200
    75.747    -0.360     0.200
    75.763     0.849     0.200
    75.767    -0.275     0.200
    75.829     1.241     0.200
    75.993     0.514     0.200
    76.045     0.342     0.200
    76.115     0.945     0.200
    76.131    -0.300     0.200
    76.131    -0.044     0.200
    76.266     1.655     0.200
    76.236     0.706     0.200
    76.256     0.091     0.200
    76.257     0.191     0.200
    76.257     0.089     0.200
    76.313     1.148     0.200
    76.281     0.605     0.200
    76.291    -0.253     0.200
    76.350     0.924     0.200
    76.324     0.057     0.200
    76.368     1.660     0.200
    76.374     1.595     0.200
    76.374     0.259     0.200
    76.404     1.466     0.200
    76.416     1.101     0.200
    76.438     1.053     0.200
    76.469     1.169     0.200
    76.482     1.117     0.200
    76.516     1.485     0.200
    76.519     1.546     0.200
    76.535     0.760     0.200
    76.552     1.749     0.200
    76.568     1.631     0.200
    76.575     1.682     0.200
    76.579    -0.085     0.200
    76.597     1.226     0.200
    76.583     0.196     0.200
    76.583    -0.364     0.200
    76.583    -0.204     0.200
    76.584     0.691     0.200
    76.597     0.917     0.200
    76.615     0.312     0.200
    76.624     0.461     0.200
    76.678     1.426     0.200
    76.652     0.007     0.200
    76.692     1.757     0.200
    76.653     0.420     0.200
    76.669    -0.791     0.200
    76.845     0.817     0.200
    76.992     1.809     0.200
    76.992     1.097     0.200
    77.012     1.009     0.200
    77.051     0.361     0.200
    77.051    -0.439     0.200
    77.051     1.101     0.200
    77.047    -1.020     0.200
    77.053    -0.454     0.200
    77.103    -0.734     0.200
    77.108    -0.709     0.200
    77.150     0.106     0.200
    77.251     0.939     0.200
    77.266     0.357     0.200
    77.324     1.001     0.200
    77.333    -0.020     0.200
    77.382    -0.419     0.200
    77.386     1.582     0.200
    77.518     0.788     0.200
    77.518     0.575     0.200
    77.560     0.413     0.200
    77.570     0.356     0.200
    77.595     0.020     0.200
    77.608    -0.154     0.200
    77.622     0.669     0.200
    77.699     1.208     0.200
    77.760     0.600     0.200
    77.771    -0.564     0.200
    77.783     0.170     0.200
    77.794     0.208     0.200
    77.809     0.125     0.200
    78.045    -0.561     0.200
    78.045    -0.998     0.200
    78.055    -0.440     0.200
    78.095     1.561     0.200
    78.095     0.994     0.200
    78.169     1.729     0.200
    78.169     0.318     0.200
    78.185    -0.356     0.200
    78.248    -0.706     0.200
    78.411     1.166     0.200
    78.411    -0.030     0.200
    78.530     0.699     0.200
    78.535    -0.845     0.200
    78.636     0.756     0.200
    78.648    -0.613     0.200
    78.658     0.036     0.200
    78.658    -0.104     0.200
    78.694    -0.741     0.200
    78.774     0.100     0.200
    78.840     1.107     0.200
    78.840     0.628     0.200
    78.842    -0.297     0.200
    78.842    -0.452     0.200
    78.849    -0.863     0.200
    78.913    -0.463     0.200
    79.029    -0.201     0.200
    79.029    -0.323     0.200
    79.076    -0.658     0.200
    79.076    -1.233     0.200
    79.082     0.109     0.200
    79.120    -0.271     0.200
    79.172     0.721     0.200
    79.224     0.434     0.200
    79.307    -0.757     0.200
    79.405     0.101     0.200
    79.448    -0.500     0.200
    79.428     0.035     0.200
    79.502    -0.237     0.200
    79.464     0.097     0.200
    79.541     1.499     0.200
    79.541     0.937     0.200
    79.509     0.285     0.200
    79.538     0.128     0.200
    79.546     0.484     0.200
    79.561     0.362     0.200
    79.621    -0.172     0.200
    79.621    -0.834     0.200
    79.623    -0.363     0.200
    79.606     0.257     0.200
    79.606     0.047     0.200
    79.606    -0.143     0.200
    79.678    -0.965     0.200
    79.758    -0.126     0.200
    79.774    -0.034     0.200
    79.819     2.052     0.200
    79.880     1.426     0.200
    79.880     0.459     0.200
    79.892    -0.683     0.200
    79.899    -0.256     0.200
    79.889     1.045     0.200
    79.950    -0.904     0.200
    79.962    -0.488     0.200
    80.017    -0.616     0.200
    80.006    -0.847     0.200
    80.041    -0.695     0.200
    80.073    -0.727     0.200
    80.080    -1.285     0.200
    80.061    -0.851     0.200
    80.065    -0.254     0.200
    80.065     0.002     0.200
    80.114    -0.001     0.200
    80.109     0.537     0.200
    80.226    -0.957     0.200
    80.215     0.466     0.200
    80.223    -0.077     0.200
    80.269     1.896     0.200
    80.269    -1.066     0.200
    80.280     1.082     0.200
    80.282     1.405     0.200
    80.282     1.729     0.200
    80.282     0.992     0.200
    80.282     0.813     0.200
    80.299     0.088     0.200
    80.299    -0.620     0.200
    80.402    -0.685     0.200
    80.399    -0.432     0.200
    80.420     0.115     0.200
    80.491    -1.264     0.200
    80.507    -0.899     0.200
    80.532    -0.435     0.200
    80.583    -0.015     0.200
    80.667    -0.708     0.200
    80.713    -0.599     0.200
    80.713    -0.850     0.200
    80.715    -0.918     0.200
    80.723    -0.892     0.200
    80.700    -0.733     0.200
    80.700     0.157     0.200
    80.746     1.103     0.200
    80.759    -1.163     0.200
    80.740    -0.847     0.200
    80.778    -0.779     0.200
    80.796    -0.292     0.200
    80.796    -0.779     0.200
    80.850    -0.782     0.200
    80.885    -0.755     0.200
    80.878     0.350     0.200
    80.880     0.089     0.200
    80.897     0.107     0.200
    80.920    -0.713     0.200
    80.927     0.455     0.200
    80.933     0.256     0.200
    81.015    -1.072     0.200
    81.019    -1.102     0.200
    81.070    -0.110     0.200
    81.109     2.161     0.200
    81.081    -0.110     0.200
    81.095    -1.276     0.200
    81.136    -0.733     0.200
    81.136    -0.985     0.200
    81.147    -1.011     0.200
    81.162    -0.942     0.200
    81.173     0.310     0.200
    81.173    -0.609     0.200
    81.188    -0.586     0.200
    81.198    -0.738     0.200
    81.167    -0.418     0.200
    81.261    -1.232     0.200
    81.264    -0.212     0.200
    81.264    -1.342     0.200
    81.240    -0.505     0.200
    81.265    -0.337     0.200
    81.358     0.169     0.200
    81.358    -0.997     0.200
    81.367    -1.239     0.200
    81.467    -0.658     0.200
    81.478    -0.859     0.200
    81.512    -1.328     0.200
    81.481    -0.428     0.200
    81.482    -0.078     0.200
    81.487    -0.695     0.200
    81.593    -1.505     0.200
    81.578    -0.064     0.200
    81.632    -1.258     0.200
    81.598    -0.396     0.200
    81.598    -0.466     0.200
    81.635    -1.077     0.200
    81.654    -0.855     0.200
    81.624    -0.433     0.200
    81.693    -1.068     0.200
    81.715    -0.216     0.200
    81.770    -0.864     0.200
    81.775    -0.639     0.200
    81.822    -0.910     0.200
    81.865    -0.994     0.200
    81.838    -1.540     0.200
    81.849    -0.810     0.200
    81.871    -0.067     0.200
    81.871    -0.337     0.200
    81.964    -0.839     0.200
    81.972    -0.798     0.200
    81.959    -1.916     0.200
    82.010    -1.219     0.200
    81.992     0.221     0.200
    82.028    -0.276     0.200
    82.028    -0.571     0.200
    82.029    -0.005     0.200
    82.029    -0.652     0.200
    82.003    -0.034     0.200
    82.052    -0.342     0.200
    82.291    -0.977     0.200
    82.316    -0.980     0.200
    82.350    -1.045     0.200
    82.367    -0.411     0.200
    82.367    -0.821     0.200
    82.377    -0.754     0.200
    82.418    -0.934     0.200
    82.421    -0.639     0.200
    82.456     1.053     0.200
    82.456    -0.345     0.200
    82.440    -0.510     0.200
    82.461    -0.101     0.200
    82.511    -1.162     0.200
    82.574    -1.592     0.200
    82.697    -1.005     0.200
    82.740    -0.984     0.200
    82.795    -1.047     0.200
    82.819    -0.632     0.200
    82.819    -1.205     0.200
    82.848    -0.647     0.200
    82.892    -0.889     0.200
    82.947    -0.598     0.200
    82.991    -0.901     0.200
    83.035     1.051     0.200
    83.035     0.332     0.200
    83.078    -1.327     0.200
    83.093     1.371     0.200
    83.093    -0.077     0.200
    83.116    -1.745     0.200
    83.135    -1.122     0.200
    83.169    -0.290     0.200
    83.169    -0.629     0.200
    83.209    -0.560     0.200
    83.226     0.108     0.200
    83.298    -0.580     0.200
    83.304    -0.511     0.200
    83.286    -0.595     0.200
    83.306    -0.306     0.200
    83.358    -1.051     0.200
    83.331    -0.422     0.200
    83.345    -0.697     0.200
    83.356    -1.254     0.200
    83.463     1.615     0.200
    83.463    -0.502     0.200
    83.561    -0.335     0.200
    83.561    -1.036     0.200
    83.529    -0.638     0.200
    83.577     0.165     0.200
    83.577    -1.152     0.200
    83.590    -0.546     0.200
    83.577    -1.389     0.200
    83.640    -0.612     0.200
    83.664     0.117     0.200
    83.664    -0.319     0.200
    83.650    -0.762     0.200
    83.800    -1.185     0.200
    83.822    -1.405     0.200
    83.894    -0.407     0.200
    83.962    -1.290     0.200
    83.926     0.630     0.200
    84.001     0.840     0.200
    84.060    -0.524     0.200
    84.065    -0.726     0.200
    84.032    -0.211     0.200
    84.066    -1.182     0.200
    84.142    -0.569     0.200
    84.176    -0.244     0.200
    84.256    -0.030     0.200
    84.255    -1.112     0.200
    84.255    -0.741     0.200
    84.255    -0.971     0.200
    84.332    -0.848     0.200
    84.341    -0.824     0.200
    84.385    -0.665     0.200
    84.369    -0.850     0.200
    84.369    -1.020     0.200
    84.446    -1.137     0.200
    84.446    -0.506     0.200
    84.481    -0.786     0.200
    84.525    -0.531     0.200
    84.501     0.012     0.200
    84.606    -1.170     0.200
    84.638    -0.833     0.200
    84.611    -0.440     0.200
    84.653    -0.443     0.200
    84.662    -0.996     0.200
    84.682    -1.398     0.200
    84.732     0.349     0.200
    84.732    -0.046     0.200
    84.772    -0.763     0.200
    84.793    -0.428     0.200
    84.828    -0.718     0.200
    84.857    -0.402     0.200
    84.894    -0.505     0.200
    84.894    -0.375     0.200
    84.930    -1.001     0.200
    85.039    -1.064     0.200
    85.104    -0.724     0.200
    85.116    -1.037     0.200
    85.108    -1.156     0.200
    85.197    -0.131     0.200
    85.197    -0.877     0.200
    85.216    -1.014     0.200
    85.280    -0.974     0.200
    85.280    -1.159     0.200
    85.288    -0.763     0.200
    85.311    -0.507     0.200
    85.320    -0.475     0.200
    85.320    -0.916     0.200
    85.326     0.074     0.200
    85.326    -0.316     0.200
    85.326    -0.026     0.200
    85.419     0.762     0.200
    85.419    -0.195     0.200
    85.445    -0.394     0.200
    85.483    -0.416     0.200
    85.495    -0.886     0.200
    85.530    -0.347     0.200
    85.591    -0.637     0.200
    85.649    -0.678     0.200
    85.713    -0.766     0.200
    85.740    -0.564     0.200
    85.742    -0.669     0.200
    85.754    -0.805     0.200
    85.776    -0.692     0.200
    85.838    -0.532     0.200
    85.841    -0.734     0.200
    85.846    -0.241     0.200
    85.852    -0.367     0.200
    85.935    -0.697     0.200
    85.954     0.711     0.200
    85.955     0.727     0.200
    85.955     0.732     0.200
    85.970    -0.272     0.200
    85.997     0.340     0.200
    85.997    -0.023     0.200
    86.010     0.385     0.200
    86.010    -0.741     0.200
    86.012    -0.148     0.200
    86.031    -0.657     0.200
    86.076     0.081     0.200
    86.078    -0.438     0.200
    86.099    -0.970     0.200
    86.105     0.268     0.200
    86.105    -1.054     0.200
    86.129    -0.720     0.200
    86.227    -0.672     0.200
    86.356    -0.508     0.200
    86.418    -0.521     0.200
    86.422     0.228     0.200
    86.422    -0.535     0.200
    86.439    -0.464     0.200
    86.440    -0.395     0.200
    86.442     0.929     0.200
    86.478     1.145     0.200
    86.527    -0.653     0.200
    86.552    -0.704     0.200
    86.560    -0.765     0.200
    86.570    -0.565     0.200
    86.586    -0.451     0.200
    86.540     1.938     0.200
    86.753    -0.334     0.200
    86.855    -0.614     0.200
    86.857    -0.489     0.200
    86.887    -0.345     0.200
    86.938    -0.552     0.200
    86.944    -0.570     0.200
    87.003    -0.186     0.200
    87.007    -0.164     0.200
    87.010    -0.012     0.200
    87.010    -0.301     0.200
    87.030    -0.860     0.200
    87.105    -0.095     0.200
    87.133    -0.831     0.200
    87.187    -0.406     0.200
    87.196    -0.107     0.200
    87.224    -0.113     0.200
    87.224     0.067     0.200
    87.229    -0.446     0.200
    87.240    -0.218     0.200
    87.346    -0.059     0.200
    87.347    -0.304     0.200
    87.357    -0.506     0.200
    87.357    -0.840     0.200
    87.362     0.431     0.200
    87.362     0.100     0.200
    87.368     0.656     0.200
    87.368    -0.190     0.200
    87.369     0.196     0.200
    87.406     0.161     0.200
    87.435    -0.112     0.200
    87.490    -0.254     0.200
    87.491    -0.633     0.200
    87.533     0.390     0.200
    87.550    -0.562     0.200
    87.558    -0.359     0.200
    87.602    -0.136     0.200
    87.618     0.377     0.200
    87.618    -0.076     0.200
    87.679    -0.303     0.200
    87.682     0.030     0.200
    87.718    -0.664     0.200
    87.733    -0.458     0.200
    87.746    -0.509     0.200
    87.795    -0.549     0.200
    87.800    -0.256     0.200
    87.822     1.217     0.200
    87.869    -0.130     0.200
    87.869    -0.397     0.200
    87.941    -0.565     0.200
    87.974    -0.590     0.200
    87.971     0.586     0.200
    87.981    -0.697     0.200
    88.041     0.365     0.200
    88.041     0.011     0.200
    88.057    -0.465     0.200
    88.076    -0.290     0.200
    88.083    -0.234     0.200
    88.083    -0.451     0.200
    88.098    -0.084     0.200
    88.132    -0.026     0.200
    88.132    -0.233     0.200
    88.146    -0.060     0.200
    88.177    -0.151     0.200
    88.274    -0.159     0.200
    88.384    -0.190     0.200
    88.431    -0.027     0.200
    88.533     0.333     0.200
    88.624    -0.179     0.200
    88.710    -0.580     0.200
    88.717     0.316     0.200
    88.737     0.314     0.200
    88.737    -0.278     0.200
    88.789     0.367     0.200
    88.789     0.071     0.200
    88.944    -0.144     0.200
    88.946    -0.074     0.200
    89.011    -0.118     0.200
    89.026     0.220     0.200
    89.085     0.016     0.200
    89.111     0.601     0.200
    89.154    -0.094     0.200
    89.158     0.154     0.200
    89.158     0.008     0.200
    89.214     0.429     0.200
    89.224     0.457     0.200
    89.248    -0.083     0.200
    89.292    -0.250     0.200
    89.308    -0.223     0.200
    89.372    -0.109     0.200
    89.400     0.071     0.200
    89.400    -0.664     0.200
    89.419    -0.241     0.200
    89.439    -0.282     0.200
    89.450     0.209     0.200
    89.455     0.532     0.200
    89.483     0.261     0.200
    89.487     0.058     0.200
    89.505    -0.078     0.200
    89.505    -0.183     0.200
    89.549    -0.079     0.200
    89.572     0.197     0.200
    89.572    -0.171     0.200
    89.611     0.121     0.200
    89.712    -0.680     0.200
    89.721    -0.475     0.200
    89.771     0.082     0.200
    89.778    -0.223     0.200
    89.781    -0.024     0.200
    89.799    -0.428     0.200
    89.800    -0.473     0.200
    89.944    -0.354     0.200
    89.986    -0.424     0.200
    89.993    -0.271     0.200
    90.021     0.019     0.200
    90.021     0.237     0.200
    90.177     0.075     0.200
    90.177     1.233     0.200
    90.211     0.100     0.200
    90.214    -0.323     0.200
    90.280    -0.124     0.200
    90.289     0.471     0.200
    90.343    -0.277     0.200
    90.387    -0.163     0.200
    90.461    -0.407     0.200
    90.497    -0.114     0.200
    90.507    -0.159     0.200
    90.584    -0.142     0.200
    90.675    -0.223     0.200
    90.713    -0.172     0.200
    90.740     0.036     0.200
    90.785    -0.376     0.200
    90.946     0.125     0.200
    91.009    -0.299     0.200
    91.015     0.437     0.200
    91.072     0.038     0.200
    91.185     0.107     0.200
    91.310    -0.042     0.200
    91.310    -0.242     0.200
    91.363     0.075     0.200
    91.386    -0.270     0.200
    91.435     0.066     0.200
    91.487    -0.284     0.200
    91.519    -0.307     0.200
    91.538    -0.659     0.200
    91.508    -0.784     0.200
    91.508     0.491     0.200
    91.685    -0.417     0.200
    91.796    -0.230     0.200
    91.904    -0.393     0.200
    91.937     0.953     0.200
    92.065    -0.039     0.200
    92.175    -0.584     0.200
    92.172    -0.331     0.200
    92.218    -0.110     0.200
    92.276    -0.439     0.200
    92.412    -0.192     0.200
    92.412    -0.326     0.200
    92.541    -0.392     0.200
    92.566     0.060     0.200
    92.578    -0.609     0.200
    92.595    -0.486     0.200
    92.665    -0.610     0.200
    92.746    -0.500     0.200
    92.761    -0.189     0.200
    92.900    -0.407     0.200
    92.998    -0.394     0.200
    93.033    -0.703     0.200
    93.042    -0.222     0.200
    93.042     0.503     0.200
    93.433    -0.246     0.200
    93.934    -0.552     0.200
    94.870    -0.545     0.200
    96.148     0.232     0.200
    17.947    -1.878     0.200
    17.947    -2.777     0.200
    19.615    -0.155     0.200
    20.352    -2.427     0.200
    20.363    -2.624     0.200
    20.751    -1.731     0.200
    20.956    -2.435     0.200
    21.387    -2.837     0.200
    21.387    -2.962     0.200
    21.777     0.766     0.200
    23.232     0.125     0.200
    23.558    -1.022     0.200
    23.847    -0.665     0.200
    24.022    -4.261     0.200
    24.335    -0.816     0.200
    24.754    -0.131     0.200
    24.818     0.855     0.200
    24.818     0.328     0.200
    25.116    -1.023     0.200
    25.612    -0.432     0.200
    25.799    -1.411     0.200
    25.879    -0.821     0.200
    25.879    -0.306     0.200
    25.879    -0.630     0.200
    25.963    -2.593     0.200
    26.037    -0.581     0.200
    26.144    -0.543     0.200
    26.316    -0.284     0.200
    26.322    -0.216     0.200
    26.601     0.264     0.200
    26.718    -0.764     0.200
    27.843    -0.882     0.200
    27.947    -1.205     0.200
    28.185     0.133     0.200
    28.185    -0.629     0.200
    28.360    -0.484     0.200
    28.403    -0.386     0.200
    28.694    -1.818     0.200
    28.643     0.693     0.200
    29.092    -0.664     0.200
    29.833    -0.149     0.200
    30.244    -1.079     0.200
    30.260    -0.508     0.200
    30.260    -2.910     0.200
    30.409    -1.523     0.200
    30.647    -2.069     0.200
    30.834     1.016     0.200
    31.100     2.650     0.200
    31.127     0.646     0.200
    31.823     3.014     0.200
    32.274     1.002     0.200
    32.595     0.743     0.200
    33.278    -0.712     0.200
    33.508    -2.293     0.200
    33.659    -0.230     0.200
    34.412     0.142     0.200
    34.895    -1.760     0.200
    34.895    -1.406     0.200
    34.998     1.596     0.200
    35.317    -0.943     0.200
    35.328     0.192     0.200
    35.386     2.633     0.200
    36.162     1.238     0.200
    36.286    -3.259     0.200
    36.490    -1.958     0.200
    36.451     0.249     0.200
    36.451    -1.681     0.200
    36.662    -0.956     0.200
    36.786     1.596     0.200
    37.276     0.738     0.200
    37.787     2.541     0.200
    38.265    -1.466     0.200
    38.224     0.428     0.200
    38.318    -1.765     0.200
    38.346     1.832     0.200
    38.462    -0.020     0.200
    38.580     1.047     0.200
    38.698     2.086     0.200
    38.798     2.626     0.200
    39.117    -1.866     0.200
    39.196    -0.674     0.200
    39.232     1.867     0.200
    39.404    -0.717     0.200
    39.512    -0.414     0.200
    39.512    -0.460     0.200
    39.512    -1.734     0.200
    39.850     0.355     0.200
    40.095     1.146     0.200
    40.316    -0.101     0.200
    40.633     0.922     0.200
    40.744     0.342     0.200
    41.247     1.435     0.200
    41.515    -1.076     0.200
    41.515    -0.163     0.200
    41.596     0.675     0.200
    41.714     1.635     0.200
    41.793     0.765     0.200
    42.050     1.961     0.200
    42.027     1.058     0.200
    42.112    -1.639     0.200
    42.180     1.233     0.200
    42.416    -0.636     0.200
    42.416    -0.488     0.200
    42.532     1.506     0.200
    42.615    -1.277     0.200
    42.615    -0.273     0.200
    42.615    -0.324     0.200
    42.757     1.086     0.200
    42.817    -0.286     0.200
    42.900     0.632     0.200
    42.969    -0.587     0.200
    42.944    -0.520     0.200
    42.935     2.695     0.200
    43.049     1.386     0.200
    43.023     0.673     0.200
    43.237    -0.732     0.200
    43.237    -1.502     0.200
    43.193     0.998     0.200
    43.235     2.163     0.200
    43.235     1.714     0.200
    43.235     1.862     0.200
    43.250     2.004     0.200
    43.466    -0.307     0.200
    43.600    -0.075     0.200
    43.661    -0.425     0.200
    43.702    -0.556     0.200
    43.686     0.633     0.200
    43.714     1.009     0.200
    43.781     0.035     0.200
    43.742     1.585     0.200
    43.825    -0.186     0.200
    43.872    -0.471     0.200
    43.872    -0.326     0.200
    43.872    -0.658     0.200
    43.917    -0.603     0.200
    43.897     0.240     0.200
    43.951    -0.369     0.200
    43.992    -0.150     0.200
    44.027    -0.705     0.200
    44.001     0.509     0.200
    44.003     0.912     0.200
    44.003     0.592     0.200
    44.073     0.927     0.200
    44.121     0.810     0.200
    44.121     0.549     0.200
    44.241     1.034     0.200
    44.241     1.034     0.200
    44.255     0.016     0.200
    44.266     0.587     0.200
    44.270     1.000     0.200
    44.359    -0.193     0.200
    44.411    -1.535     0.200
    44.411    -1.021     0.200
    44.411    -1.021     0.200
    44.340     0.899     0.200
    44.416    -0.209     0.200
    44.418     0.873     0.200
    44.526     0.169     0.200
    44.652     1.286     0.200
    44.652     1.009     0.200
    44.755     1.686     0.200
    44.952     0.291     0.200
    44.952    -0.080     0.200
    44.948     1.855     0.200
    44.989     1.225     0.200
    45.089     0.118     0.200
    45.233     1.069     0.200
    45.240     0.101     0.200
    45.210    -2.229     0.200
    45.368     0.174     0.200
    45.410    -1.090     0.200
    45.477     0.510     0.200
    45.475     1.177     0.200
    45.639    -1.016     0.200
    45.754    -0.801     0.200
    45.428    -0.231     0.200
    45.760     0.208     0.200
    45.770     0.253     0.200
    45.827     2.500     0.200
    45.872     1.348     0.200
    45.956     0.514     0.200
    46.030     1.366     0.200
    46.020    -0.257     0.200
    46.061     0.354     0.200
    46.061     0.713     0.200
    46.130    -0.022     0.200
    46.471     0.223     0.200
    46.700     0.789     0.200
    46.689     0.035     0.200
    46.845    -0.912     0.200
    46.783     1.601     0.200
    46.849     0.666     0.200
    46.874    -1.105     0.200
    46.874    -1.398     0.200
    46.941     1.868     0.200
    47.022     0.318     0.200
    47.046     1.151     0.200
    47.158    -0.122     0.200
    47.207     2.397     0.200
    47.349     0.390     0.200
    47.375     1.057     0.200
    47.375     0.584     0.200
    47.544    -0.752     0.200
    47.554     0.804     0.200
    47.582     1.581     0.200
    47.621     1.583     0.200
    47.731    -0.157     0.200
    47.719     0.720     0.200
    47.846     0.341     0.200
    48.003     1.123     0.200
    48.114    -0.332     0.200
    48.114    -0.289     0.200
    48.090     0.656     0.200
    48.097     0.899     0.200
    48.165    -0.030     0.200
    48.165    -0.323     0.200
    48.258     1.574     0.200
    48.333     0.791     0.200
    48.423     0.670     0.200
    48.423     0.393     0.200
    48.518    -0.242     0.200
    48.621    -0.752     0.200
    48.607     0.672     0.200
    48.637     0.742     0.200
    48.835     0.822     0.200
    48.959    -0.107     0.200
    48.966     0.510     0.200
    48.968     0.407     0.200
    49.000     1.373     0.200
    49.019     0.074     0.200
    49.149    -0.725     0.200
    49.117     0.469     0.200
    49.117     0.387     0.200
    49.279     0.248     0.200
    49.279     0.080     0.200
    49.430     1.183     0.200
    49.597     3.609     0.200
    49.643     0.857     0.200
    49.751     0.087     0.200
    49.810     0.186     0.200
    49.863     0.784     0.200
    49.988     0.841     0.200
    50.029     0.746     0.200
    50.135     0.724     0.200
    50.150     1.323     0.200
    50.417     0.266     0.200
    50.646     0.970     0.200
    50.677     0.031     0.200
    50.674     0.261     0.200
    50.814     1.088     0.200
    50.752     0.875     0.200
    50.948     1.197     0.200
    51.082    -0.206     0.200
    51.090     0.929     0.200
    51.179     2.065     0.200
    51.337     1.185     0.200
    51.316     1.640     0.200
    51.524     0.085     0.200
    51.626     3.112     0.200
    51.582     2.778     0.200
    51.674     0.948     0.200
    51.737    -0.434     0.200
    51.737    -0.703     0.200
    51.737    -0.434     0.200
    51.793     0.084     0.200
    52.143    -0.025     0.200
    52.476     0.242     0.200
    52.579     0.258     0.200
    52.577    -2.660     0.200
    52.804     0.040     0.200
    52.850    -0.083     0.200
    53.040     0.061     0.200
    53.096     3.119     0.200
    53.051     1.667     0.200
    53.360     3.035     0.200
    53.356    -0.845     0.200
    53.356    -0.673     0.200
    53.469     1.454     0.200
    53.746     1.709     0.200
    53.742     1.897     0.200
    53.742     3.292     0.200
    53.742     1.225     0.200
    53.784     1.692     0.200
    54.077     0.458     0.200
    54.152    -0.691     0.200
    54.152    -0.379     0.200
    54.437    -1.962     0.200
    54.635     0.655     0.200
    54.589    -0.663     0.200
    54.589    -0.206     0.200
    54.897     1.010     0.200
    55.058     1.745     0.200
    55.194     1.890     0.200
    55.194     0.168     0.200
    55.337     0.338     0.200
    55.626    -1.189     0.200
    55.626    -1.369     0.200
    55.626    -1.205     0.200
    55.627    -0.442     0.200
    55.627    -0.274     0.200
    55.707    -0.686     0.200
    55.707    -1.026     0.200
    55.735    -0.305     0.200
    55.764     0.977     0.200
    55.823    -2.049     0.200
    55.831     0.795     0.200
    55.895    -1.661     0.200
    55.948     3.764     0.200
    56.008     0.669     0.200
    56.203     3.813     0.200
    56.202    -0.756     0.200
    56.157    -0.331     0.200
    56.216     3.507     0.200
    56.241     3.508     0.200
    56.234     0.022     0.200
    56.302     1.232     0.200
    56.302     1.443     0.200
    56.368     0.166     0.200
    56.401    -0.371     0.200
    56.585    -0.279     0.200
    56.585    -0.529     0.200
    56.569     0.536     0.200
    56.613     0.823     0.200
    56.808     2.642     0.200
    56.812     0.209     0.200
    56.849    -0.830     0.200
    56.924    -2.280     0.200
    57.018    -0.406     0.200
    57.024    -1.588     0.200
    57.024    -1.380     0.200
    57.059    -0.766     0.200
    57.105    -1.659     0.200
    57.079     0.721     0.200
    57.194    -1.515     0.200
    57.194    -1.390     0.200
    57.151    -0.683     0.200
    57.231     1.354     0.200
    57.465     2.453     0.200
    57.426     0.280     0.200
    57.426     0.991     0.200
    57.596     0.783     0.200
    57.634     2.013     0.200
    57.655     0.069     0.200
    57.994     2.390     0.200
    58.089    -1.176     0.200
    58.143    -0.653     0.200
    58.143    -0.493     0.200
    58.276     1.022     0.200
    58.375     0.329     0.200
    58.450    -1.293     0.200
    58.428     0.262     0.200
    58.646    -0.711     0.200
    58.591     0.828     0.200
    58.761     1.943     0.200
    58.935    -1.562     0.200
    59.002    -1.365     0.200
    59.121    -1.350     0.200
    59.134     1.164     0.200
    59.134     2.223     0.200
    59.294    -1.733     0.200
    59.384     0.836     0.200
    59.406    -2.218     0.200
    59.548    -1.368     0.200
    59.548    -0.943     0.200
    59.721    -2.095     0.200
    59.728    -0.532     0.200
    59.728    -0.223     0.200
    60.502    -1.396     0.200
    61.172    -1.504     0.200
    61.267     1.036     0.200
    61.627     0.427     0.200
    61.833     0.565     0.200
    62.135     1.493     0.200
    62.135     1.250     0.200
    62.208    -0.147     0.200
    62.208     0.924     0.200
    62.284     1.447     0.200
    62.445    -0.409     0.200
    62.446    -0.539     0.200
    62.490    -1.004     0.200
    62.490    -0.012     0.200
    62.522    -0.446     0.200
    62.522    -0.317     0.200
    62.619     0.624     0.200
    62.624    -1.926     0.200
    62.647     0.520     0.200
    62.703     0.492     0.200
    62.752    -1.961     0.200
    62.799     0.443     0.200
    62.925     1.426     0.200
    62.930     0.729     0.200
    62.995     0.330     0.200
    63.018     0.334     0.200
    63.024     0.007     0.200
    63.064     3.009     0.200
    63.338    -1.351     0.200
    63.461     1.293     0.200
    63.489     0.564     0.200
    63.501     0.581     0.200
    63.598    -1.478     0.200
    63.657     0.514     0.200
    63.806     1.275     0.200
    63.810     0.867     0.200
    63.826    -3.179     0.200
    63.846     0.613     0.200
    64.129    -0.207     0.200
    64.161     0.722     0.200
    64.265    -0.137     0.200
    64.343    -1.268     0.200
    64.448     0.098     0.200
    64.503     0.368     0.200
    64.545    -0.654     0.200
    64.583    -1.533     0.200
    64.617     0.364     0.200
    64.658     0.666     0.200
    64.685    -1.688     0.200
    64.685    -1.301     0.200
    64.775     1.084     0.200
    64.778    -1.406     0.200
    64.780    -1.337     0.200
    64.813     0.510     0.200
    64.957     0.711     0.200
    64.971    -0.438     0.200
    65.022     3.079     0.200
    65.044     1.452     0.200
    65.157    -0.415     0.200
    65.168     0.488     0.200
    65.250     0.505     0.200
    65.300     0.651     0.200
    65.352     1.145     0.200
    65.369     1.313     0.200
    65.392    -0.139     0.200
    65.428    -0.015     0.200
    65.469     0.205     0.200
    65.506     0.547     0.200
    65.516     0.229     0.200
    65.516    -0.212     0.200
    65.516    -0.380     0.200
    65.521     1.410     0.200
    65.658     1.163     0.200
    65.856    -1.578     0.200
    65.911     2.560     0.200
    65.947    -1.162     0.200
    66.001     0.612     0.200
    66.023     1.475     0.200
    66.062     2.713     0.200
    66.141     0.495     0.200
    66.149     0.238     0.200
    66.181     0.514     0.200
    66.181     1.425     0.200
    66.231     0.448     0.200
    66.166     0.076     0.200
    66.171     0.520     0.200
    66.173     0.241     0.200
    66.275     0.659     0.200
    66.294     0.745     0.200
    66.275    -1.363     0.200
    66.591    -1.084     0.200
    66.632     0.330     0.200
    66.677     0.944     0.200
    66.682     1.388     0.200
    66.727     0.416     0.200
    66.696    -0.226     0.200
    66.719     0.170     0.200
    66.719    -0.208     0.200
    66.823    -1.471     0.200
    66.853     2.333     0.200
    66.965     1.207     0.200
    67.053     0.361     0.200
    67.136    -0.146     0.200
    67.345     1.174     0.200
    67.473     0.671     0.200
    67.526     0.951     0.200
    67.583     0.130     0.200
    67.588     0.499     0.200
    67.588    -0.400     0.200
    67.584     1.905     0.200
    67.584     2.225     0.200
    67.717     1.055     0.200
    68.099     0.204     0.200
    68.099    -0.311     0.200
    68.187     0.887     0.200
    68.213     2.415     0.200
    68.219     0.157     0.200
    68.232     0.456     0.200
    68.317    -1.272     0.200
    68.317    -1.483     0.200
    68.466     0.601     0.200
    68.466     0.472     0.200
    68.466     0.293     0.200
    68.487     0.239     0.200
    68.491    -1.364     0.200
    68.616    -0.406     0.200
    68.652     0.677     0.200
    68.727     0.892     0.200
    68.743    -0.614     0.200
    68.900    -0.513     0.200
    68.836     2.097     0.200
    68.884     0.485     0.200
    68.913     0.849     0.200
    69.054    -1.468     0.200
    69.199     0.740     0.200
    69.294     0.579     0.200
    69.352     1.472     0.200
    69.418     0.923     0.200
    69.510     1.246     0.200
    69.517     0.230     0.200
    69.536     0.685     0.200
    69.567    -0.988     0.200
    69.574    -1.797     0.200
    69.574    -1.033     0.200
    69.601    -0.992     0.200
    69.584     1.058     0.200
    69.584     1.336     0.200
    69.607    -1.135     0.200
    69.611    -0.982     0.200
    69.614    -0.942     0.200
    69.635    -0.950     0.200
    69.637    -0.942     0.200
    69.643    -1.035     0.200
    69.628     0.727     0.200
    69.628     1.278     0.200
    69.628     0.571     0.200
    69.661    -0.994     0.200
    69.669     1.609     0.200
    69.667    -1.147     0.200
    69.678    -1.047     0.200
    69.696    -1.109     0.200
    69.713    -1.034     0.200
    69.719    -0.821     0.200
    69.753     1.111     0.200
    69.750    -0.909     0.200
    69.750    -0.862     0.200
    69.774    -1.039     0.200
    69.781    -0.932     0.200
    69.735     1.271     0.200
    69.807    -1.143     0.200
    69.817    -0.975     0.200
    69.837     0.815     0.200
    69.831    -0.747     0.200
    69.838    -1.300     0.200
    69.838    -0.980     0.200
    69.838    -1.226     0.200
    69.846    -0.951     0.200
    69.846    -1.083     0.200
    69.875    -1.008     0.200
    69.903     0.816     0.200
    69.903     0.199     0.200
    69.932    -1.009     0.200
    69.943    -1.177     0.200
    69.952     1.234     0.200
    69.960     0.202     0.200
    69.957     2.285     0.200
    69.958    -1.470     0.200
    69.967    -1.295     0.200
    69.970    -1.091     0.200
    69.990    -1.537     0.200
    69.990    -1.697     0.200
    69.992    -1.698     0.200
    69.994    -1.562     0.200
    70.004    -1.523     0.200
    70.032    -1.424     0.200
    70.040    -1.668     0.200
    70.043     0.361     0.200
    70.091    -1.249     0.200
    70.105    -1.264     0.200
    70.121     0.663     0.200
    70.121    -0.064     0.200
    70.119    -1.255     0.200
    70.123    -1.376     0.200
    70.131     1.452     0.200
    70.153    -1.365     0.200
    70.159    -1.396     0.200
    70.202     1.259     0.200
    70.263     1.447     0.200
    70.319     1.354     0.200
    70.369    -0.354     0.200
    70.538    -0.739     0.200
    70.538    -1.282     0.200
    70.604     1.185     0.200
    70.613     1.224     0.200
    70.641     0.649     0.200
    70.622     1.315     0.200
    70.653     0.414     0.200
    70.705     2.681     0.200
    70.691     0.786     0.200
    70.727     1.178     0.200
    70.717     0.927     0.200
    70.754     1.304     0.200
    70.790     3.283     0.200
    70.790     0.195     0.200
    70.790     0.055     0.200
    70.789    -0.079     0.200
    70.832    -0.669     0.200
    70.824    -0.004     0.200
    70.871     1.110     0.200
    70.871     1.118     0.200
    70.896     1.299     0.200
    70.905     1.314     0.200
    70.883     0.909     0.200
    70.938    -1.010     0.200
    70.938    -1.010     0.200
    70.931     0.831     0.200
    70.957     1.693     0.200
    70.960     1.052     0.200
    70.935     1.343     0.200
    70.976     0.779     0.200
    71.032     0.864     0.200
    71.031    -0.837     0.200
    71.048     0.436     0.200
    71.036     1.497     0.200
    71.083     1.529     0.200
    71.107    -1.354     0.200
    71.159    -1.302     0.200
    71.159    -2.454     0.200
    71.151     1.895     0.200
    71.178    -1.140     0.200
    71.238     0.237     0.200
    71.252     1.597     0.200
    71.357     1.524     0.200
    71.319     1.963     0.200
    71.381     1.320     0.200
    71.464     2.707     0.200
    71.441    -0.681     0.200
    71.441    -0.841     0.200
    71.473     0.955     0.200
    71.473     1.580     0.200
    71.464     0.099     0.200
    71.464    -0.041     0.200
    71.523     0.759     0.200
    71.565    -0.800     0.200
    71.605     1.561     0.200
    71.613     1.606     0.200
    71.589     0.633     0.200
    71.589     0.250     0.200
    71.688     0.816     0.200
    71.688    -0.309     0.200
    71.728     1.311     0.200
    71.730     0.374     0.200
    71.730     0.144     0.200
    71.780     1.285     0.200
    71.785     1.424     0.200
    71.809     1.378     0.200
    71.789     1.857     0.200
    71.793     2.345     0.200
    71.821     0.165     0.200
    71.821    -0.245     0.200
    71.867     0.597     0.200
    71.881    -0.092     0.200
    71.885     0.117     0.200
    71.961     0.366     0.200
    71.961    -0.286     0.200
    71.975     1.297     0.200
    71.976     1.361     0.200
    71.992     1.777     0.200
    71.994    -0.683     0.200
    72.006     0.607     0.200
    72.022    -0.241     0.200
    72.019     0.978     0.200
    72.051    -0.448     0.200
    72.164     1.097     0.200
    72.126     1.191     0.200
    72.144    -0.073     0.200
    72.195     0.795     0.200
    72.195     0.256     0.200
    72.212    -3.779     0.200
    72.216     3.802     0.200
    72.264     1.032     0.200
    72.269     0.481     0.200
    72.241     1.075     0.200
    72.265     1.612     0.200
    72.283     0.428     0.200
    72.283     0.100     0.200
    72.355     0.777     0.200
    72.340     0.275     0.200
    72.390     2.764     0.200
    72.426    -0.864     0.200
    72.492    -0.147     0.200
    72.518     0.038     0.200
    72.518    -0.153     0.200
    72.513    -0.737     0.200
    72.532     1.630     0.200
    72.567     0.814     0.200
    72.567     1.087     0.200
    72.598     0.419     0.200
    72.598     1.512     0.200
    72.574     2.768     0.200
    72.565    -0.280     0.200
    72.636     0.644     0.200
    72.674     0.712     0.200
    72.660    -1.844     0.200
    72.692     0.958     0.200
    72.695     0.848     0.200
    72.772     1.004     0.200
    72.785     1.414     0.200
    72.792     1.496     0.200
    72.845     0.559     0.200
    72.880     0.171     0.200
    72.861     1.164     0.200
    72.904    -0.659     0.200
    72.894     1.591     0.200
    72.993     0.881     0.200
    72.993     0.201     0.200
    73.004     0.473     0.200
    73.019    -0.112     0.200
    73.030     1.234     0.200
    73.030     0.879     0.200
    73.023     1.311     0.200
    73.069     1.086     0.200
    73.069     0.801     0.200
    73.109     0.358     0.200
    73.109    -0.111     0.200
    73.109     0.396     0.200
    73.109     0.349     0.200
    73.109    -0.464     0.200
    73.131     0.624     0.200
    73.136     0.257     0.200
    73.149    -0.738     0.200
    73.185     1.475     0.200
    73.220    -0.655     0.200
    73.320     0.616     0.200
    73.392     0.510     0.200
    73.421    -1.239     0.200
    73.477     1.322     0.200
    73.504     1.294     0.200
    73.508     0.355     0.200
    73.577     1.335     0.200
    73.608     1.364     0.200
    73.655    -1.593     0.200
    73.702     1.133     0.200
    73.733     0.171     0.200
    73.734    -1.676     0.200
    73.750     0.102     0.200
    73.790     1.395     0.200
    73.792     0.857     0.200
    73.792     0.466     0.200
    73.796    -0.738     0.200
    73.808    -0.609     0.200
    73.796     0.030     0.200
    73.820     0.960     0.200
    73.882     0.376     0.200
    73.818     0.781     0.200
    73.818     0.902     0.200
    73.893    -0.305     0.200
    73.893    -1.605     0.200
    73.945     0.365     0.200
    73.949     0.490     0.200
    73.925     1.010     0.200
    73.935     0.547     0.200
    74.004     0.392     0.200
    74.022     1.414     0.200
    73.997     0.684     0.200
    74.064     1.000     0.200
    74.116     0.493     0.200
    74.192     1.588     0.200
    74.218    -0.702     0.200
    74.252     0.785     0.200
    74.251    -0.012     0.200
    74.296     0.744     0.200
    74.310     1.065     0.200
    74.392     0.684     0.200
    74.394     0.463     0.200
    74.384    -0.464     0.200
    74.416     1.585     0.200
    74.431    -0.915     0.200
    74.429    -0.033     0.200
    74.445     0.374     0.200
    74.477     1.527     0.200
    74.453    -0.664     0.200
    74.514     1.426     0.200
    74.550     1.309     0.200
    74.562    -0.653     0.200
    74.590    -0.556     0.200
    74.608     0.097     0.200
    74.652     0.424     0.200
    74.618    -0.222     0.200
    74.787     1.901     0.200
    74.822     0.448     0.200
    74.822    -0.255     0.200
    74.842     1.485     0.200
    74.841     0.550     0.200
    74.844     1.268     0.200
    74.864     0.736     0.200
    74.880     1.854     0.200
    74.906     1.616     0.200
    74.935     1.746     0.200
    74.971     0.010     0.200
    74.984    -0.887     0.200
    74.985     0.161     0.200
    74.986     1.463     0.200
    75.032     0.864     0.200
    75.026    -0.074     0.200
    75.056     0.760     0.200
    75.067     0.186     0.200
    75.088     0.042     0.200
    75.088    -0.138     0.200
    75.095     0.455     0.200
    75.075     0.178     0.200
    75.109     0.986     0.200
    75.109     0.532     0.200
    75.111     2.132     0.200
    75.112     0.968     0.200
    75.119     0.774     0.200
    75.121    -0.227     0.200
    75.144     0.073     0.200
    75.172     0.192     0.200
    75.172     1.352     0.200
    75.216     0.920     0.200
    75.304     1.523     0.200
    75.366    -0.236     0.200
    75.370     1.363     0.200
    75.389    -0.031     0.200
    75.389    -0.183     0.200
    75.405     0.396     0.200
    75.415     0.788     0.200
    75.449     0.196     0.200
    75.470     0.971     0.200
    75.467     0.990     0.200
    75.496    -0.221     0.200
    75.539     0.276     0.200
    75.553     0.196     0.200
    75.584     0.561     0.200
    75.604     1.062     0.200
    75.601     0.520     0.200
    75.624     0.791     0.200
    75.624     0.052     0.200
    75.629    -1.367     0.200
    75.661     1.376     0.200
    75.694     0.090     0.200
    75.694    -0.011     0.200
    75.687     0.228     0.200
    75.712     0.588     0.200
    75.724     0.622     0.200
    75.731     0.578     0.200
    75.747    -0.310     0.200
    75.772     0.849     0.200
    75.795     0.364     0.200
    75.808     0.540     0.200
    75.808     0.240     0.200
    75.819    -0.120     0.200
    75.834     0.891     0.200
    75.839    -0.235     0.200
    75.918     0.594     0.200
    75.961     0.719     0.200
    75.962     0.183     0.200
    75.992     0.073     0.200
    75.993     1.285     0.200
    76.036     1.539     0.200
    76.098     0.567     0.200
    76.116     0.688     0.200
    76.148     0.205     0.200
    76.148     0.984     0.200
    76.187     0.687     0.200
    76.202    -0.010     0.200
    76.229     1.337     0.200
    76.229     0.505     0.200
    76.244     1.391     0.200
    76.266     0.636     0.200
    76.291     1.033     0.200
    76.292    -0.675     0.200
    76.304    -0.125     0.200
    76.333     0.769     0.200
    76.346     1.183     0.200
    76.356    -1.446     0.200
    76.330     0.242     0.200
    76.330     0.102     0.200
    76.331     0.120     0.200
    76.356     1.075     0.200
    76.356     0.810     0.200
    76.349     0.662     0.200
    76.359    -0.190     0.200
    76.382     1.670     0.200
    76.393     1.015     0.200
    76.395     0.608     0.200
    76.416     1.007     0.200
    76.447     1.424     0.200
    76.449    -1.012     0.200
    76.433    -0.106     0.200
    76.433     0.691     0.200
    76.459     1.200     0.200
    76.493     1.019     0.200
    76.497     1.320     0.200
    76.504     1.410     0.200
    76.504     1.140     0.200
    76.481     0.396     0.200
    76.530     1.243     0.200
    76.545     0.956     0.200
    76.552     1.188     0.200
    76.557     1.268     0.200
    76.536     0.308     0.200
    76.575     0.818     0.200
    76.571    -0.740     0.200
    76.656     1.069     0.200
    76.651     0.361     0.200
    76.651     0.048     0.200
    76.648     0.177     0.200
    76.670     3.055     0.200
    76.654     0.744     0.200
    76.670     1.259     0.200
    76.668     0.362     0.200
    76.683     0.380     0.200
    76.698     0.396     0.200
    76.698     0.533     0.200
    76.700     0.781     0.200
    76.719     0.373     0.200
    76.727     0.883     0.200
    76.748    -1.206     0.200
    76.739    -0.040     0.200
    76.816     0.892     0.200
    76.839     0.697     0.200
    76.916     0.764     0.200
    76.966     1.708     0.200
    76.966     1.493     0.200
    76.992     0.691     0.200
    77.001    -1.109     0.200
    77.004    -0.981     0.200
    77.009     0.406     0.200
    77.100    -0.626     0.200
    77.120     0.421     0.200
    77.120     0.221     0.200
    77.122     0.107     0.200
    77.117     0.689     0.200
    77.144     0.486     0.200
    77.170    -0.709     0.200
    77.170    -0.557     0.200
    77.162     0.984     0.200
    77.174    -0.576     0.200
    77.181     0.879     0.200
    77.196     1.495     0.200
    77.196     0.757     0.200
    77.217    -0.121     0.200
    77.251     1.986     0.200
    77.305     0.894     0.200
    77.305     1.042     0.200
    77.324    -0.511     0.200
    77.319     1.105     0.200
    77.336     0.812     0.200
    77.372    -0.440     0.200
    77.376     0.634     0.200
    77.401     0.547     0.200
    77.401     0.246     0.200
    77.416    -0.804     0.200
    77.460     0.915     0.200
    77.461     0.912     0.200
    77.461     0.763     0.200
    77.495     1.144     0.200
    77.495     0.691     0.200
    77.430     1.195     0.200
    77.520     1.583     0.200
    77.538     0.282     0.200
    77.627     0.188     0.200
    77.637     0.030     0.200
    77.672     1.487     0.200
    77.662    -0.106     0.200
    77.660    -1.055     0.200
    77.676     0.015     0.200
    77.711     0.319     0.200
    77.730    -4.988     0.200
    77.829     0.361     0.200
    77.851     0.143     0.200
    77.863     0.378     0.200
    77.896     0.194     0.200
    77.932    -0.989     0.200
    77.923    -0.456     0.200
    77.962    -0.375     0.200
    77.979     1.233     0.200
    78.043    -0.656     0.200
    78.043    -1.285     0.200
    78.022     1.594     0.200
    78.050    -0.865     0.200
    78.074     1.427     0.200
    78.074     0.993     0.200
    78.062     0.370     0.200
    78.091    -0.668     0.200
    78.106     0.229     0.200
    78.126    -0.484     0.200
    78.150     0.502     0.200
    78.180     0.715     0.200
    78.215     1.696     0.200
    78.215     1.024     0.200
    78.242    -0.025     0.200
    78.251    -0.074     0.200
    78.263     2.455     0.200
    78.287     0.322     0.200
    78.287    -0.115     0.200
    78.298     0.062     0.200
    78.298    -0.067     0.200
    78.319    -0.449     0.200
    78.396     0.678     0.200
    78.396    -0.459     0.200
    78.468    -0.204     0.200
    78.499     0.847     0.200
    78.482     0.350     0.200
    78.504     0.927     0.200
    78.570     0.264     0.200
    78.594    -0.407     0.200
    78.529     0.813     0.200
    78.529     0.922     0.200
    78.620    -0.237     0.200
    78.620    -1.038     0.200
    78.704     0.627     0.200
    78.719    -0.353     0.200
    78.725     0.015     0.200
    78.755    -1.204     0.200
    78.758    -0.763     0.200
    78.793     0.610     0.200
    78.819     1.046     0.200
    78.819     0.601     0.200
    78.827    -0.473     0.200
    78.910    -0.327     0.200
    78.910    -0.373     0.200
    78.916    -0.964     0.200
    78.922    -0.166     0.200
    78.945    -0.694     0.200
    78.982    -0.595     0.200
    78.982    -1.095     0.200
    79.021    -0.415     0.200
    79.021    -0.646     0.200
    79.026     2.487     0.200
    79.026    -1.459     0.200
    79.074    -0.897     0.200
    79.074    -1.186     0.200
    79.113    -0.348     0.200
    79.110     1.005     0.200
    79.148    -0.196     0.200
    79.158    -0.184     0.200
    79.196     0.202     0.200
    79.258    -0.402     0.200
    79.264     0.464     0.200
    79.303    -1.397     0.200
    79.292    -0.489     0.200
    79.328     0.615     0.200
    79.387    -0.780     0.200
    79.369     0.241     0.200
    79.380     0.133     0.200
    79.384     0.499     0.200
    79.397    -0.582     0.200
    79.445    -0.876     0.200
    79.457    -0.768     0.200
    79.484     0.684     0.200
    79.484     0.079     0.200
    79.465     0.471     0.200
    79.473     0.155     0.200
    79.496     0.028     0.200
    79.506    -0.376     0.200
    79.512     0.952     0.200
    79.512     0.276     0.200
    79.520    -1.029     0.200
    79.527     0.531     0.200
    79.537     0.470     0.200
    79.557    -0.632     0.200
    79.578    -1.342     0.200
    79.578    -0.943     0.200
    79.616    -0.632     0.200
    79.616    -0.932     0.200
    79.617    -0.422     0.200
    79.601     0.532     0.200
    79.610     0.183     0.200
    79.618    -0.259     0.200
    79.636     1.029     0.200
    79.676    -1.032     0.200
    79.678     0.417     0.200
    79.678     0.214     0.200
    79.686     0.270     0.200
    79.832     0.478     0.200
    79.860     0.780     0.200
    79.860     0.432     0.200
    79.847     0.267     0.200
    79.847     0.162     0.200
    79.890    -0.870     0.200
    79.898    -0.281     0.200
    79.909    -0.707     0.200
    79.936    -0.206     0.200
    79.913     0.143     0.200
    79.950    -0.207     0.200
    79.950    -0.996     0.200
    79.963     1.071     0.200
    79.985    -0.418     0.200
    79.977    -0.607     0.200
    80.010    -1.327     0.200
    79.986     0.919     0.200
    80.029    -0.162     0.200
    80.029    -0.623     0.200
    80.032    -0.500     0.200
    80.068    -0.793     0.200
    80.076    -1.484     0.200
    80.070    -0.906     0.200
    80.081    -1.266     0.200
    80.124    -0.638     0.200
    80.120     0.525     0.200
    80.133    -0.196     0.200
    80.134     0.008     0.200
    80.178    -0.780     0.200
    80.181    -0.205     0.200
    80.224    -0.928     0.200
    80.245     1.492     0.200
    80.250    -0.725     0.200
    80.257     1.084     0.200
    80.258     2.178     0.200
    80.258     1.272     0.200
    80.258     1.381     0.200
    80.258     1.002     0.200
    80.259     0.572     0.200
    80.268    -0.994     0.200
    80.239     0.583     0.200
    80.277    -1.027     0.200
    80.280    -1.550     0.200
    80.293    -0.035     0.200
    80.293    -0.359     0.200
    80.295     0.182     0.200
    80.314    -0.723     0.200
    80.394    -0.230     0.200
    80.394    -0.723     0.200
    80.440    -0.293     0.200
    80.473    -0.973     0.200
    80.467    -0.181     0.200
    80.490    -0.741     0.200
    80.479    -0.004     0.200
    80.487     0.096     0.200
    80.508     1.220     0.200
    80.512    -0.781     0.200
    80.509     0.236     0.200
    80.544    -1.248     0.200
    80.571    -0.823     0.200
    80.604     0.820     0.200
    80.605     1.650     0.200
    80.604    -0.373     0.200
    80.644    -0.688     0.200
    80.648    -0.231     0.200
    80.710    -0.567     0.200
    80.710    -0.896     0.200
    80.711    -1.107     0.200
    80.723    -1.049     0.200
    80.721     1.289     0.200
    80.735    -0.509     0.200
    80.753    -1.034     0.200
    80.741     0.491     0.200
    80.771    -0.552     0.200
    80.770    -0.660     0.200
    80.794    -0.439     0.200
    80.794    -0.685     0.200
    80.809    -0.620     0.200
    80.819    -0.824     0.200
    80.828    -0.239     0.200
    80.852    -0.897     0.200
    80.877    -0.517     0.200
    80.904     0.122     0.200
    80.912    -0.017     0.200
    80.918    -0.801     0.200
    80.942    -1.528     0.200
    80.942    -0.106     0.200
    80.900     0.689     0.200
    80.900    -1.252     0.200
    80.964     0.106     0.200
    80.981    -0.397     0.200
    80.988    -0.685     0.200
    81.000     0.271     0.200
    80.999     0.522     0.200
    81.001    -0.187     0.200
    81.030     0.159     0.200
    81.047    -0.036     0.200
    81.079    -1.115     0.200
    81.086    -1.177     0.200
    81.136    -0.811     0.200
    81.136    -1.006     0.200
    81.144    -0.880     0.200
    81.123     0.863     0.200
    81.137     0.098     0.200
    81.128    -0.163     0.200
    81.155    -0.705     0.200
    81.140    -0.930     0.200
    81.158    -0.374     0.200
    81.158    -1.331     0.200
    81.147    -0.010     0.200
    81.139     1.876     0.200
    81.178    -1.479     0.200
    81.177     1.208     0.200
    81.163    -1.204     0.200
    81.186    -1.086     0.200
    81.190    -0.935     0.200
    81.215    -0.625     0.200
    81.220    -0.257     0.200
    81.224    -0.575     0.200
    81.255    -0.713     0.200
    81.259    -0.942     0.200
    81.259    -1.173     0.200
    81.239    -0.355     0.200
    81.267    -0.361     0.200
    81.280     1.728     0.200
    81.314     0.017     0.200
    81.312    -0.338     0.200
    81.330    -0.578     0.200
    81.360    -0.143     0.200
    81.360    -1.553     0.200
    81.436    -1.255     0.200
    81.465    -1.050     0.200
    81.465    -1.163     0.200
    81.452    -1.185     0.200
    81.476    -0.541     0.200
    81.476    -0.936     0.200
    81.460    -0.422     0.200
    81.489    -1.077     0.200
    81.512    -1.095     0.200
    81.544    -0.865     0.200
    81.548     0.121     0.200
    81.554     0.018     0.200
    81.557    -1.274     0.200
    81.570    -0.773     0.200
    81.588    -1.242     0.200
    81.588    -0.591     0.200
    81.600    -0.536     0.200
    81.626    -0.493     0.200
    81.628    -0.914     0.200
    81.627    -0.803     0.200
    81.627    -1.002     0.200
    81.647     1.107     0.200
    81.647    -1.073     0.200
    81.645    -0.020     0.200
    81.676     3.014     0.200
    81.668    -0.323     0.200
    81.668    -0.425     0.200
    81.668    -0.624     0.200
    81.668    -0.444     0.200
    81.694    -1.318     0.200
    81.674    -0.247     0.200
    81.695    -0.264     0.200
    81.703     0.293     0.200
    81.734    -0.909     0.200
    81.732    -0.762     0.200
    81.770    -0.186     0.200
    81.770    -0.971     0.200
    81.787     0.041     0.200
    81.819    -1.181     0.200
    81.804    -0.433     0.200
    81.840    -0.739     0.200
    81.867    -1.337     0.200
    81.858    -1.319     0.200
    81.892    -0.298     0.200
    81.907    -1.878     0.200
    81.921    -0.364     0.200
    81.921    -0.755     0.200
    81.936    -0.834     0.200
    81.957    -0.521     0.200
    81.943    -0.497     0.200
    81.968    -1.434     0.200
    81.968    -0.298     0.200
    82.004    -1.438     0.200
    82.019    -0.490     0.200
    82.022     0.422     0.200
    82.022    -0.297     0.200
    82.004    -1.191     0.200
    82.004    -1.089     0.200
    82.026    -0.845     0.200
    82.042    -0.325     0.200
    82.029    -1.828     0.200
    82.029    -1.617     0.200
    82.038    -0.665     0.200
    82.059     0.356     0.200
    82.069     0.304     0.200
    82.130    -0.850     0.200
    82.225    -0.844     0.200
    82.292    -1.239     0.200
    82.312    -0.900     0.200
    82.345    -1.071     0.200
    82.364    -0.471     0.200
    82.364    -0.780     0.200
    82.351    -0.300     0.200
    82.376    -0.033     0.200
    82.376    -1.162     0.200
    82.411    -0.663     0.200
    82.413    -0.526     0.200
    82.447     0.097     0.200
    82.447    -0.255     0.200
    82.480     2.375     0.200
    82.513    -0.823     0.200
    82.491    -0.635     0.200
    82.528    -0.202     0.200
    82.544    -0.711     0.200
    82.544    -1.019     0.200
    82.570    -1.144     0.200
    82.570    -0.882     0.200
    82.567    -1.827     0.200
    82.651    -0.664     0.200
    82.695    -0.723     0.200
    82.736    -0.821     0.200
    82.790    -1.055     0.200
    82.771    -1.191     0.200
    82.813    -0.756     0.200
    82.813    -1.022     0.200
    82.841    -0.505     0.200
    82.883    -0.371     0.200
    82.902    -0.526     0.200
    82.937     0.085     0.200
    82.988    -0.975     0.200
    83.015     0.759     0.200
    83.074    -0.995     0.200
    83.072     0.037     0.200
    83.125    -1.667     0.200
    83.129    -1.003     0.200
    83.161    -0.284     0.200
    83.161    -0.405     0.200
    83.202    -0.656     0.200
    83.201     0.890     0.200
    83.201     0.569     0.200
    83.193    -1.668     0.200
    83.288    -0.311     0.200
    83.295    -0.391     0.200
    83.307    -0.657     0.200
    83.359    -0.444     0.200
    83.359    -0.821     0.200
    83.372    -0.249     0.200
    83.402    -0.447     0.200
    83.404    -1.354     0.200
    83.417    -0.721     0.200
    83.439     1.113     0.200
    83.429    -1.181     0.200
    83.457    -1.327     0.200
    83.494    -0.817     0.200
    83.521    -2.853     0.200
    83.534    -0.626     0.200
    83.556    -0.636     0.200
    83.556    -1.113     0.200
    83.574    -0.826     0.200
    83.574    -1.060     0.200
    83.583    -0.280     0.200
    83.601    -0.966     0.200
    83.632    -0.453     0.200
    83.654    -0.018     0.200
    83.654    -0.119     0.200
    83.668    -0.890     0.200
    83.650    -1.514     0.200
    83.665    -1.294     0.200
    83.722    -0.686     0.200
    83.739    -0.071     0.200
    83.789    -0.833     0.200
    83.818    -1.175     0.200
    83.835    -0.663     0.200
    83.957    -1.189     0.200
    83.957    -0.184     0.200
    83.998    -0.195     0.200
    84.052    -0.338     0.200
    84.058     0.051     0.200
    84.058    -0.742     0.200
    84.068     0.089     0.200
    84.065    -1.532     0.200
    84.106     0.059     0.200
    84.131    -0.633     0.200
    84.135    -0.406     0.200
    84.138    -0.904     0.200
    84.182    -0.887     0.200
    84.247    -0.759     0.200
    84.248     0.438     0.200
    84.276    -2.406     0.200
    84.281    -0.830     0.200
    84.297    -1.213     0.200
    84.327    -0.424     0.200
    84.335    -0.682     0.200
    84.326    -0.236     0.200
    84.326    -0.357     0.200
    84.328    -0.878     0.200
    84.328    -1.670     0.200
    84.328    -1.249     0.200
    84.343    -0.645     0.200
    84.376    -0.185     0.200
    84.437    -0.049     0.200
    84.437    -0.210     0.200
    84.442    -0.893     0.200
    84.518    -0.371     0.200
    84.554    -1.107     0.200
    84.564    -1.563     0.200
    84.594    -1.156     0.200
    84.575     0.084     0.200
    84.608    -1.179     0.200
    84.633    -0.711     0.200
    84.608    -0.084     0.200
    84.684    -0.466     0.200
    84.714     0.233     0.200
    84.719    -0.081     0.200
    84.735    -1.319     0.200
    84.768    -0.727     0.200
    84.755    -1.321     0.200
    84.785    -0.034     0.200
    84.822    -0.702     0.200
    84.848    -0.429     0.200
    84.889     0.075     0.200
    84.889    -0.534     0.200
    84.920    -0.682     0.200
    85.027    -0.697     0.200
    85.098    -0.759     0.200
    85.112    -0.819     0.200
    85.098    -0.640     0.200
    85.190    -0.229     0.200
    85.190    -0.495     0.200
    85.179    -1.563     0.200
    85.211    -0.520     0.200
    85.269    -0.827     0.200
    85.279    -0.024     0.200
    85.298    -0.224     0.200
    85.310    -0.382     0.200
    85.310    -0.644     0.200
    85.405     0.298     0.200
    85.405    -0.198     0.200
    85.397    -0.334     0.200
    85.397    -0.174     0.200
    85.441    -0.418     0.200
    85.459    -1.191     0.200
    85.481     0.598     0.200
    85.481    -0.765     0.200
    85.494    -0.252     0.200
    85.523    -0.601     0.200
    85.585    -0.703     0.200
    85.641    -0.552     0.200
    85.723    -0.713     0.200
    85.731    -0.492     0.200
    85.739    -0.598     0.200
    85.743    -0.647     0.200
    85.764    -0.577     0.200
    85.826     0.788     0.200
    85.826     0.053     0.200
    85.837    -0.466     0.200
    85.837    -0.398     0.200
    85.853     0.415     0.200
    85.853    -0.296     0.200
    85.928     0.605     0.200
    85.929     0.804     0.200
    85.970    -0.480     0.200
    85.988     0.446     0.200
    85.988     0.298     0.200
    86.000     0.196     0.200
    86.005    -0.366     0.200
    86.006    -0.202     0.200
    86.006    -0.483     0.200
    85.950     1.377     0.200
    86.022    -0.374     0.200
    86.121     1.920     0.200
    86.063    -0.093     0.200
    86.072    -0.260     0.200
    86.088    -0.709     0.200
    86.103    -0.949     0.200
    86.119    -0.712     0.200
    86.215    -0.123     0.200
    86.349    -0.447     0.200
    86.417    -0.784     0.200
    86.417     0.127     0.200
    86.417    -0.377     0.200
    86.430    -0.387     0.200
    86.432    -0.900     0.200
    86.433     1.143     0.200
    86.448     1.003     0.200
    86.524    -1.053     0.200
    86.541    -0.601     0.200
    86.548    -0.302     0.200
    86.537    -1.507     0.200
    86.557    -0.531     0.200
    86.581    -0.489     0.200
    86.574     2.484     0.200
    86.612     2.032     0.200
    86.747    -0.354     0.200
    86.850    -0.541     0.200
    86.855    -1.002     0.200
    86.877    -0.123     0.200
    86.877    -0.588     0.200
    86.904     0.033     0.200
    86.930    -0.309     0.200
    86.942    -0.732     0.200
    86.989    -0.099     0.200
    86.989     0.132     0.200
    86.997    -0.459     0.200
    86.997    -0.756     0.200
    87.002    -0.256     0.200
    87.019    -0.806     0.200
    87.101    -0.577     0.200
    87.142    -0.692     0.200
    87.142    -0.825     0.200
    87.181    -0.347     0.200
    87.212    -0.671     0.200
    87.217     0.014     0.200
    87.217     0.095     0.200
    87.220    -0.172     0.200
    87.249     0.289     0.200
    87.268    -1.199     0.200
    87.340     0.679     0.200
    87.340     0.233     0.200
    87.345    -0.419     0.200
    87.346    -0.231     0.200
    87.345    -0.545     0.200
    87.347    -0.475     0.200
    87.355     0.359     0.200
    87.355    -0.430     0.200
    87.355     0.123     0.200
    87.397    -0.070     0.200
    87.438     0.079     0.200
    87.438    -0.277     0.200
    87.486    -0.600     0.200
    87.488    -0.809     0.200
    87.514     1.143     0.200
    87.514     0.377     0.200
    87.543    -0.330     0.200
    87.550    -0.456     0.200
    87.596    -0.364     0.200
    87.604     0.086     0.200
    87.672    -0.220     0.200
    87.678    -0.388     0.200
    87.707    -0.463     0.200
    87.730    -0.478     0.200
    87.736    -0.145     0.200
    87.782     0.404     0.200
    87.782    -0.519     0.200
    87.796    -0.431     0.200
    87.837    -0.456     0.200
    87.869     0.356     0.200
    87.869    -0.776     0.200
    87.934    -0.204     0.200
    87.897     2.659     0.200
    87.969    -0.232     0.200
    87.972    -0.171     0.200
    87.982     0.007     0.200
    88.028     0.648     0.200
    88.028     0.023     0.200
    88.047    -0.409     0.200
    88.055    -0.200     0.200
    88.065    -0.479     0.200
    88.086     0.044     0.200
    88.086    -0.460     0.200
    88.095    -0.266     0.200
    88.127     0.017     0.200
    88.127    -0.307     0.200
    88.136     0.293     0.200
    88.160    -0.073     0.200
    88.160    -0.542     0.200
    88.173     0.213     0.200
    88.174     0.049     0.200
    88.184    -0.163     0.200
    88.265    -0.168     0.200
    88.320    -0.180     0.200
    88.362    -0.333     0.200
    88.377     0.135     0.200
    88.388    -0.312     0.200
    88.416     0.592     0.200
    88.434     0.052     0.200
    88.434    -0.323     0.200
    88.470    -1.001     0.200
    88.535     0.376     0.200
    88.542     0.001     0.200
    88.569    -0.084     0.200
    88.585     0.136     0.200
    88.615    -0.370     0.200
    88.621    -0.152     0.200
    88.619     0.056     0.200
    88.693     0.503     0.200
    88.697    -0.089     0.200
    88.705    -0.081     0.200
    88.703    -0.025     0.200
    88.722    -0.572     0.200
    88.735    -0.039     0.200
    88.783     0.259     0.200
    88.783     0.036     0.200
    88.802    -0.595     0.200
    88.818    -0.157     0.200
    88.818    -0.415     0.200
    88.935     0.227     0.200
    88.939    -0.126     0.200
    88.943    -0.208     0.200
    88.984     0.100     0.200
    89.006     0.009     0.200
    89.008    -0.459     0.200
    89.011     0.278     0.200
    89.072     0.261     0.200
    89.095     0.298     0.200
    89.101     0.815     0.200
    89.127     0.261     0.200
    89.147     0.023     0.200
    89.151     0.133     0.200
    89.175    -0.183     0.200
    89.119     2.250     0.200
    89.190     0.084     0.200
    89.207    -0.504     0.200
    89.245    -0.053     0.200
    89.284    -0.262     0.200
    89.229     2.382     0.200
    89.298    -0.360     0.200
    89.361     0.036     0.200
    89.395     0.168     0.200
    89.395    -0.110     0.200
    89.415    -0.282     0.200
    89.433    -0.193     0.200
    89.437     0.589     0.200
    89.443     0.355     0.200
    89.462     0.203     0.200
    89.467     0.318     0.200
    89.472     0.707     0.200
    89.509     0.226     0.200
    89.509    -0.177     0.200
    89.541    -0.279     0.200
    89.505     3.390     0.200
    89.575     0.146     0.200
    89.610    -0.815     0.200
    89.612     0.569     0.200
    89.612     0.089     0.200
    89.704    -0.190     0.200
    89.644     3.271     0.200
    89.711    -0.263     0.200
    89.760    -0.556     0.200
    89.773    -0.062     0.200
    89.775     0.014     0.200
    89.790    -0.322     0.200
    89.796     0.189     0.200
    89.796    -0.733     0.200
    89.773     1.196     0.200
    89.844    -0.074     0.200
    89.923     0.212     0.200
    89.937    -0.098     0.200
    89.959     0.271     0.200
    89.970    -0.404     0.200
    89.978    -0.370     0.200
    89.982    -0.582     0.200
    90.004     0.003     0.200
    90.004    -1.286     0.200
    90.012     0.184     0.200
    90.027     0.233     0.200
    90.027    -0.032     0.200
    90.073    -0.998     0.200
    90.092     3.167     0.200
    90.166    -0.085     0.200
    90.166    -0.163     0.200
    90.187     0.653     0.200
    90.199    -0.223     0.200
    90.210    -0.603     0.200
    90.275    -0.015     0.200
    90.280     0.447     0.200
    90.285     0.110     0.200
    90.291    -0.870     0.200
    90.294     0.108     0.200
    90.333    -0.408     0.200
    90.337    -0.399     0.200
    90.380    -0.050     0.200
    90.375     3.011     0.200
    90.452    -0.667     0.200
    90.487    -0.008     0.200
    90.492     0.016     0.200
    90.504    -0.466     0.200
    90.543     0.420     0.200
    90.591    -0.266     0.200
    90.630     0.248     0.200
    90.655     0.612     0.200
    90.671    -0.381     0.200
    90.705    -0.359     0.200
    90.721     0.314     0.200
    90.736     0.112     0.200
    90.736    -0.528     0.200
    90.743     0.086     0.200
    90.765     0.457     0.200
    90.778    -0.014     0.200
    90.779    -0.144     0.200
    90.780    -0.341     0.200
    90.779    -1.148     0.200
    90.891     0.195     0.200
    90.891    -0.680     0.200
    90.942    -0.340     0.200
    90.958    -0.769     0.200
    90.991    -0.597     0.200
    91.003     0.222     0.200
    91.004    -0.485     0.200
    91.004    -0.110     0.200
    91.004     0.054     0.200
    91.016     2.693     0.200
    91.058    -0.252     0.200
    91.075     0.188     0.200
    91.075    -0.367     0.200
    91.145    -1.198     0.200
    91.177    -0.115     0.200
    91.210    -1.371     0.200
    91.223     0.268     0.200
    91.273    -0.666     0.200
    91.306     0.368     0.200
    91.306     0.110     0.200
    91.307    -0.314     0.200
    91.322     0.479     0.200
    91.358    -0.467     0.200
    91.381    -0.011     0.200
    91.397     0.272     0.200
    91.398     3.521     0.200
    91.425    -0.458     0.200
    91.466    -0.813     0.200
    91.487    -0.078     0.200
    91.506     0.601     0.200
    91.510     1.188     0.200
    91.528    -1.151     0.200
    91.533    -0.744     0.200
    91.577    -0.614     0.200
    91.577    -0.239     0.200
    91.610    -0.608     0.200
    91.676    -0.405     0.200
    91.716    -0.244     0.200
    91.754     0.128     0.200
    91.779     0.387     0.200
    91.787     1.590     0.200
    91.787    -1.383     0.200
    91.792    -1.297     0.200
    91.809    -1.361     0.200
    91.826    -1.421     0.200
    91.843    -0.924     0.200
    91.865     1.116     0.200
    91.965     0.552     0.200
    91.965    -0.335     0.200
    91.979     0.778     0.200
    92.009     0.668     0.200
    92.007     0.114     0.200
    92.061     0.009     0.200
    92.075     2.280     0.200
    92.075    -0.009     0.200
    92.087     0.421     0.200
    92.091    -0.610     0.200
    92.116    -0.396     0.200
    92.166    -0.478     0.200
    92.201     0.352     0.200
    92.212     0.015     0.200
    92.232    -0.568     0.200
    92.269    -0.026     0.200
    92.285     0.779     0.200
    92.311     0.958     0.200
    92.353    -0.273     0.200
    92.404    -0.339     0.200
    92.405    -0.567     0.200
    92.486    -1.262     0.200
    92.532    -0.865     0.200
    92.561    -0.429     0.200
    92.640    -0.352     0.200
    92.653     0.365     0.200
    92.656    -0.427     0.200
    92.701    -1.433     0.200
    92.733    -0.358     0.200
    92.726    -0.450     0.200
    92.755    -1.041     0.200
    92.883     0.327     0.200
    92.892    -0.111     0.200
    92.960    -0.507     0.200
    92.979     0.065     0.200
    93.001     0.299     0.200
    93.088     0.696     0.200
    93.093    -0.341     0.200
    93.105    -0.421     0.200
    93.105     0.001     0.200
    93.157     0.411     0.200
    93.168     0.438     0.200
    93.286    -0.466     0.200
    93.293    -0.226     0.200
    93.297    -0.579     0.200
    93.342    -0.021     0.200
    93.360     0.148     0.200
    93.373    -0.106     0.200
    93.373    -1.573     0.200
    93.452    -0.106     0.200
    93.467    -0.805     0.200
    93.494    -0.609     0.200
    93.494    -0.187     0.200
    93.578    -0.305     0.200
    93.606    -0.209     0.200
    93.719    -0.753     0.200
    93.832     0.129     0.200
    93.832    -0.279     0.200
    93.868    -0.850     0.200
    93.911     0.194     0.200
    94.003    -0.475     0.200
    93.995    -0.794     0.200
    94.104    -1.062     0.200
    94.159    -0.969     0.200
    94.191    -1.783     0.200
    94.232    -0.918     0.200
    94.238    -0.962     0.200
    94.343    -0.358     0.200
    94.354    -0.440     0.200
    94.462    -0.434     0.200
    94.519    -0.423     0.200
    94.715    -1.614     0.200
    94.744    -2.119     0.200
    94.787    -1.321     0.200
    94.924    -0.978     0.200
    94.923    -1.045     0.200
    94.932    -1.075     0.200
    94.932    -0.888     0.200
    95.002    -0.280     0.200
    95.102    -1.545     0.200
    95.110    -1.392     0.200
    95.150     0.061     0.200
    95.285    -0.237     0.200
    95.321    -0.753     0.200
    95.319    -0.451     0.200
    95.422    -0.193     0.200
    95.415    -0.693     0.200
    95.651    -1.431     0.200
    95.768    -1.395     0.200
    95.793     0.684     0.200
    95.848    -1.328     0.200
    96.067    -0.493     0.200
    96.209    -0.209     0.200
    96.329    -0.350     0.200
    96.484    -0.655     0.200
    96.687    -0.195     0.200
    26.321    -0.947     0.200
    39.511    -0.507     0.200
    42.614    -0.322     0.200
    43.871     0.017     0.200
    43.950    -0.619     0.200
    44.413    -0.618     0.200
    48.113    -0.422     0.200
    62.444    -0.338     0.200
    64.780    -1.652     0.200
    66.171     1.029     0.200
    21.405    -1.889     0.200
    26.250     0.258     0.200
    39.450    -0.595     0.200
    42.545     0.000     0.200
    43.807     0.248     0.200
    43.886    -0.362     0.200
    44.458    -0.315     0.200
    48.053    -0.056     0.200
    49.189    -0.291     0.200
    56.142    -1.467     0.200
    59.520    -0.188     0.200
    62.432    -0.677     0.200
    64.743    -1.075     0.200
    69.799    -0.818     0.200
    69.808    -1.477     0.200
    70.890    -1.199     0.200
    76.272    -0.376     0.200
    21.096    -1.794     0.200
    25.825    -0.432     0.200
    25.831    -0.139     0.200
    26.551     1.360     0.200
    28.450    -2.334     0.200
    30.458    -0.728     0.200
    32.171     0.988     0.200
    32.961    -0.830     0.200
    38.990    -0.489     0.200
    38.990    -0.782     0.200
    41.405    -0.768     0.200
    42.112     1.091     0.200
    42.123    -1.348     0.200
    42.115    -0.582     0.200
    42.114    -0.578     0.200
    42.114    -0.464     0.200
    42.316     0.161     0.200
    42.418    -0.941     0.200
    42.477     2.189     0.200
    42.660     0.663     0.200
    42.939    -0.173     0.200
    43.023     0.846     0.200
    43.356    -0.229     0.200
    43.520     0.392     0.200
    43.585    -0.603     0.200
    43.726     0.537     0.200
    43.729     1.171     0.200
    43.827     0.279     0.200
    43.935     0.195     0.200
    44.016     1.386     0.200
    44.286    -0.441     0.200
    44.317    -0.716     0.200
    44.316    -1.171     0.200
    44.316    -0.862     0.200
    44.326    -1.427     0.200
    44.470     0.859     0.200
    45.186     0.674     0.200
    45.392     0.127     0.200
    45.667    -0.852     0.200
    46.332     0.341     0.200
    46.746    -0.225     0.200
    46.970     0.183     0.200
    47.641    -0.819     0.200
    49.001    -0.742     0.200
    49.309     2.276     0.200
    51.238    -0.557     0.200
    51.238    -0.710     0.200
    52.539     1.238     0.200
    52.829    -1.197     0.200
    55.105    -0.311     0.200
    58.523    -0.908     0.200
    59.063    -0.382     0.200
    61.632     0.645     0.200
    62.750    -0.046     0.200
    62.759    -0.088     0.200
    62.760    -0.971     0.200
    62.772    -0.236     0.200
    63.848     0.604     0.200
    64.056    -0.595     0.200
    64.190    -0.277     0.200
    64.280    -0.011     0.200
    64.272    -1.797     0.200
    64.273    -1.908     0.200
    64.598    -1.845     0.200
    64.832     0.561     0.200
    65.054     0.139     0.200
    65.273     0.635     0.200
    65.331     0.640     0.200
    65.330    -2.298     0.200
    65.522     0.714     0.200
    65.535     0.443     0.200
    65.598     0.824     0.200
    66.026     0.999     0.200
    66.081     1.364     0.200
    66.156     1.537     0.200
    66.264     1.330     0.200
    66.481     0.335     0.200
    66.488    -0.201     0.200
    66.749     1.124     0.200
    66.956     1.307     0.200
    67.941     1.016     0.200
    67.941     0.235     0.200
    67.962    -0.321     0.200
    68.246     0.665     0.200
    68.313     0.101     0.200
    68.513    -0.309     0.200
    68.583    -0.895     0.200
    68.814     0.289     0.200
    69.144    -1.080     0.200
    69.153    -0.341     0.200
    69.291     0.941     0.200
    69.347    -1.931     0.200
    69.347    -1.681     0.200
    69.495     0.429     0.200
    69.542     0.749     0.200
    69.763     0.867     0.200
    69.938     0.363     0.200
    69.935     0.836     0.200
    69.974     0.925     0.200
    70.125     0.484     0.200
    70.224     1.057     0.200
    70.414    -1.342     0.200
    70.426    -1.658     0.200
    70.687     1.102     0.200
    70.959     1.016     0.200
    70.959     0.543     0.200
    71.072     1.518     0.200
    71.684     0.697     0.200
    71.743     1.308     0.200
    71.883     1.410     0.200
    72.013     0.868     0.200
    72.642     0.788     0.200
    73.042     0.505     0.200
    73.124     0.370     0.200
    73.124     0.271     0.200
    73.124    -0.409     0.200
    73.124     0.322     0.200
    73.158     0.749     0.200
    73.834     1.023     0.200
    74.087     0.316     0.200
    74.447    -0.421     0.200
    74.460    -0.519     0.200
    74.534     1.519     0.200
    74.708     0.743     0.200
    74.847     1.756     0.200
    76.134     0.079     0.200
    76.168     0.090     0.200
    76.332     0.953     0.200
    76.388     0.902     0.200
    76.424     1.155     0.200
    76.436     0.808     0.200
    76.456     0.634     0.200
    76.502     0.633     0.200
    76.536     0.631     0.200
    76.539     1.423     0.200
    76.572     0.537     0.200
    76.588     1.228     0.200
    76.597     1.229     0.200
    76.599     1.874     0.200
    76.617     0.482     0.200
    76.699     1.129     0.200
    76.858     0.785     0.200
    77.018     1.080     0.200
    77.542     0.795     0.200
    77.937    -0.894     0.200
    78.212    -0.206     0.200
    78.396    -0.494     0.200
    78.402    -0.590     0.200
    78.848     0.868     0.200
    81.546    -0.054     0.200
    82.863    -0.245     0.200
    83.802    -1.468     0.200
    85.538    -0.832     0.200
    85.935    -0.694     0.200
    85.999     0.336     0.200
    86.000     0.211     0.200
    86.829    -0.588     0.200
    86.915     0.199     0.200
    87.585    -0.208     0.200
    88.631    -0.227     0.200
    88.711     0.441     0.200
    89.088    -0.018     0.200
    89.302    -0.110     0.200
    89.365    -0.406     0.200
    89.437     0.147     0.200
    89.870    -0.178     0.200
    90.645     0.048     0.200
    92.608    -1.235     0.200
    26.340     0.062     0.200
    26.340     0.058     0.200
    30.245    -2.795     0.200
    39.522    -0.236     0.200
    39.522    -0.242     0.200
    42.631    -0.127     0.200
    42.631    -0.127     0.200
    43.884    -0.483     0.200
    43.964    -0.893     0.200
    62.470    -0.118     0.200
    62.470    -0.122     0.200
    64.776    -1.570     0.200
    64.776    -1.570     0.200
    77.166    -1.426     0.200
    18.073    -3.358     0.200
    21.512    -3.110     0.200
    23.517     1.090     0.200
    25.877     0.068     0.200
    25.877    -0.272     0.200
    26.315     0.333     0.200
    26.320    -0.559     0.200
    28.819    -0.116     0.200
    32.560     0.500     0.200
    38.592     0.805     0.200
    39.539    -0.335     0.200
    39.539    -0.406     0.200
    39.539    -0.933     0.200
    39.841     1.289     0.200
    42.537    -0.485     0.200
    42.620    -0.230     0.200
    42.620     0.030     0.200
    42.620    -0.474     0.200
    42.620     0.042     0.200
    42.821     0.028     0.200
    43.891     0.003     0.200
    43.891    -1.450     0.200
    43.970    -0.631     0.200
    44.151     1.020     0.200
    44.538    -0.524     0.200
    48.546     0.314     0.200
    51.074    -0.177     0.200
    51.740    -0.293     0.200
    51.740    -0.477     0.200
    52.189    -0.288     0.200
    53.402    -1.072     0.200
    53.402    -0.935     0.200
    55.654    -0.790     0.200
    58.774    -0.468     0.200
    59.636    -0.867     0.200
    62.030    -1.669     0.200
    62.494    -0.492     0.200
    64.856    -1.495     0.200
    64.856    -1.319     0.200
    68.498    -0.218     0.200
    68.518     0.307     0.200
    69.923    -1.430     0.200
    69.923    -1.481     0.200
    70.984     1.505     0.200
    70.995    -1.288     0.200
    70.995    -0.863     0.200
    71.493    -1.067     0.200
    73.230     0.535     0.200
    76.366     0.061     0.200
    77.243    -0.469     0.200
    86.043     1.350     0.200
    21.386    -2.272     0.200
    26.251     0.119     0.200
    39.447    -0.647     0.200
    42.545     0.097     0.200
    43.804     0.484     0.200
    43.884    -0.206     0.200
    44.179     0.166     0.200
    48.049     0.002     0.200
    56.138    -1.024     0.200
    62.450    -0.505     0.200
    64.732    -1.467     0.200
    69.788    -0.695     0.200
    69.796    -1.614     0.200
    26.415     0.013     0.200
    39.615    -1.489     0.200
    42.710    -0.587     0.200
    43.972     0.130     0.200
    44.052    -0.482     0.200
    44.449    -0.509     0.200
    48.218    -0.946     0.200
    56.306    -0.771     0.200
    58.690    -0.588     0.200
    62.367    -0.458     0.200
    64.887    -1.057     0.200
    69.944    -1.078     0.200
    71.046    -0.802     0.200
    85.933     1.055     0.200
    17.970    -2.806     0.200
    17.970    -2.150     0.200
    19.548    -0.504     0.200
    20.266    -1.257     0.200
    20.859    -2.327     0.200
    21.296    -3.423     0.200
    21.408    -2.828     0.200
    21.685     0.719     0.200
    23.461     0.375     0.200
    25.706     1.950     0.200
    26.234     0.012     0.200
    26.234     0.012     0.200
    26.234    -0.209     0.200
    27.763    -0.853     0.200
    27.849     2.480     0.200
    28.276    -1.022     0.200
    28.723    -3.393     0.200
    29.752     0.287     0.200
    30.246    -0.223     0.200
    30.246    -4.282     0.200
    30.736     0.795     0.200
    32.499     0.304     0.200
    33.180     0.357     0.200
    33.565    -0.089     0.200
    37.181     1.069     0.200
    38.764     0.690     0.200
    39.436    -0.401     0.200
    39.435    -0.466     0.200
    39.436    -0.471     0.200
    39.760     0.735     0.200
    39.760     0.994     0.200
    40.490    -0.270     0.200
    41.570    -0.795     0.200
    41.505     1.549     0.200
    42.241     1.096     0.200
    42.487    -0.755     0.200
    42.487    -0.951     0.200
    42.529    -0.493     0.200
    42.529    -0.243     0.200
    42.529    -0.243     0.200
    42.735     0.012     0.200
    42.785     0.143     0.200
    42.731    -1.029     0.200
    42.731    -0.099     0.200
    42.814    -0.122     0.200
    42.895     3.839     0.200
    43.287    -1.021     0.200
    43.287    -0.919     0.200
    43.397     1.152     0.200
    43.506     1.314     0.200
    43.660    -0.269     0.200
    43.721    -1.105     0.200
    43.792    -0.581     0.200
    43.792    -0.392     0.200
    43.807     1.098     0.200
    43.871    -0.342     0.200
    43.975     0.018     0.200
    43.907     1.192     0.200
    43.910     0.084     0.200
    44.045    -0.584     0.200
    44.049    -0.695     0.200
    44.085    -0.653     0.200
    44.119    -0.674     0.200
    44.209    -0.250     0.200
    44.148     0.966     0.200
    44.148     0.966     0.200
    44.148     1.367     0.200
    44.148     0.806     0.200
    44.469    -0.664     0.200
    44.469    -0.645     0.200
    44.469    -1.205     0.200
    44.474    -1.053     0.200
    44.474    -1.350     0.200
    44.589    -0.547     0.200
    44.976     0.066     0.200
    45.004     0.310     0.200
    45.192    -0.209     0.200
    45.470    -1.212     0.200
    45.813    -0.868     0.200
    45.827    -0.819     0.200
    46.765     0.463     0.200
    46.902    -0.838     0.200
    47.086     0.150     0.200
    47.578     0.308     0.200
    47.906     0.918     0.200
    48.000     0.693     0.200
    48.090    -0.404     0.200
    48.090    -0.013     0.200
    48.170     0.311     0.200
    48.276     0.454     0.200
    48.335     0.611     0.200
    48.412    -0.155     0.200
    48.412     0.316     0.200
    48.449    -1.567     0.200
    48.510     0.264     0.200
    48.534     0.080     0.200
    48.540     0.133     0.200
    48.738     0.614     0.200
    48.878     0.457     0.200
    48.871     0.196     0.200
    48.932     0.097     0.200
    49.198    -1.133     0.200
    49.198    -0.219     0.200
    49.191    -0.057     0.200
    49.191     0.172     0.200
    49.332     1.068     0.200
    49.429     1.339     0.200
    49.506     4.144     0.200
    49.663     0.068     0.200
    49.766     0.069     0.200
    49.941     0.850     0.200
    51.651    -0.165     0.200
    51.651    -0.565     0.200
    51.651    -0.165     0.200
    53.290    -0.540     0.200
    53.290    -0.780     0.200
    53.645    -0.244     0.200
    53.811    -0.657     0.200
    55.551    -0.946     0.200
    55.551    -0.876     0.200
    55.551    -0.226     0.200
    55.608    -1.411     0.200
    55.691    -0.682     0.200
    55.928     0.067     0.200
    55.968     1.098     0.200
    56.129    -1.277     0.200
    56.566    -0.859     0.200
    56.757    -1.186     0.200
    56.828    -1.099     0.200
    57.051    -2.327     0.200
    58.355     0.124     0.200
    58.699    -0.445     0.200
    58.699    -0.450     0.200
    59.143     0.205     0.200
    59.514    -1.125     0.200
    59.514    -1.129     0.200
    59.514    -1.266     0.200
    59.984    -3.535     0.200
    60.468    -1.330     0.200
    60.642    -1.626     0.200
    61.141    -0.819     0.200
    61.574     0.556     0.200
    62.404    -0.022     0.200
    62.404     0.052     0.200
    62.418     0.507     0.200
    62.429    -0.142     0.200
    62.429    -0.137     0.200
    62.722     0.537     0.200
    63.565     0.554     0.200
    63.768    -2.034     0.200
    64.236     1.155     0.200
    64.517    -1.645     0.200
    64.627    -0.658     0.200
    64.733    -1.251     0.200
    64.735    -1.311     0.200
    64.735    -1.311     0.200
    64.735    -1.510     0.200
    64.855    -2.203     0.200
    65.062    -2.486     0.200
    65.430    -0.169     0.200
    65.547     0.052     0.200
    65.587    -0.046     0.200
    65.587     0.665     0.200
    65.792    -1.602     0.200
    65.883    -1.184     0.200
    66.101     1.718     0.200
    66.221     0.105     0.200
    66.228     0.304     0.200
    66.154     0.172     0.200
    66.156     0.163     0.200
    66.156    -1.148     0.200
    66.375     0.695     0.200
    66.542    -0.908     0.200
    66.713     0.683     0.200
    66.758     0.341     0.200
    67.135     0.386     0.200
    67.416     1.139     0.200
    67.669     0.151     0.200
    68.134     0.541     0.200
    68.171    -0.030     0.200
    68.265     1.083     0.200
    68.392     0.317     0.200
    68.392     1.326     0.200
    68.413     0.040     0.200
    68.416    -1.630     0.200
    68.673     0.468     0.200
    68.808     1.046     0.200
    68.810     0.615     0.200
    69.365     0.968     0.200
    69.409    -0.695     0.200
    69.499     1.131     0.200
    69.585     0.044     0.200
    69.585     0.239     0.200
    69.591     1.442     0.200
    69.598    -0.740     0.200
    69.750     1.585     0.200
    69.771    -1.022     0.200
    69.825     1.104     0.200
    69.801    -1.410     0.200
    69.801    -1.111     0.200
    69.801    -1.111     0.200
    69.919     1.056     0.200
    69.934    -0.722     0.200
    70.034     1.445     0.200
    70.054    -0.701     0.200
    70.192     0.358     0.200
    70.192     0.514     0.200
    70.213     1.640     0.200
    70.436     0.208     0.200
    70.685     1.181     0.200
    70.694     1.376     0.200
    70.879    -1.036     0.200
    70.879    -0.686     0.200
    70.953     1.137     0.200
    70.953     1.141     0.200
    70.953     0.936     0.200
    70.978     1.590     0.200
    71.039     3.453     0.200
    71.041     1.449     0.200
    71.074     0.092     0.200
    71.138     1.214     0.200
    71.308     1.418     0.200
    71.545     2.960     0.200
    71.678     1.852     0.200
    71.758     0.557     0.200
    71.864     0.060     0.200
    71.881     1.260     0.200
    71.940     0.557     0.200
    72.025    -0.330     0.200
    72.079     1.529     0.200
    72.106    -0.075     0.200
    72.263    -0.513     0.200
    72.351    -0.095     0.200
    72.437     0.616     0.200
    72.478    -0.442     0.200
    72.602    -0.125     0.200
    72.602     0.263     0.200
    72.646     0.154     0.200
    72.646     1.177     0.200
    72.757     1.332     0.200
    72.847     1.417     0.200
    72.962     0.579     0.200
    73.070     0.406     0.200
    73.070     1.068     0.200
    73.086     0.694     0.200
    73.151     0.614     0.200
    73.151     0.194     0.200
    73.182     0.329     0.200
    73.182     0.687     0.200
    73.182    -0.012     0.200
    73.182     0.228     0.200
    73.404     0.634     0.200
    73.866     1.340     0.200
    73.875     0.503     0.200
    73.875     1.013     0.200
    74.029     0.595     0.200
    74.103     1.603     0.200
    74.334     0.710     0.200
    74.475     0.515     0.200
    74.488    -1.324     0.200
    74.660     1.366     0.200
    74.736    -0.465     0.200
    74.741     1.439     0.200
    74.865     2.141     0.200
    74.893    -0.304     0.200
    74.923     0.741     0.200
    74.924     1.672     0.200
    74.925    -0.327     0.200
    74.925    -0.506     0.200
    75.109     1.098     0.200
    75.172     1.761     0.200
    75.193     0.328     0.200
    75.227     0.200     0.200
    75.264    -0.275     0.200
    75.336     0.013     0.200
    75.491     0.124     0.200
    75.656     0.420     0.200
    75.698    -0.231     0.200
    75.795     0.137     0.200
    75.751     0.339     0.200
    75.773     0.614     0.200
    75.968    -0.264     0.200
    76.055     0.905     0.200
    76.180     0.413     0.200
    76.140     0.623     0.200
    76.254     0.478     0.200
    76.258     0.104     0.200
    76.258     0.103     0.200
    76.368     1.434     0.200
    76.422     1.416     0.200
    76.429    -0.053     0.200
    76.470     1.238     0.200
    76.492     1.179     0.200
    76.523     1.406     0.200
    76.523     1.356     0.200
    76.536     1.394     0.200
    76.570     1.282     0.200
    76.573     1.392     0.200
    76.587     0.624     0.200
    76.548     0.111     0.200
    76.622     1.308     0.200
    76.599     0.125     0.200
    76.599    -0.074     0.200
    76.651     1.362     0.200
    76.629     0.156     0.200
    76.632     0.337     0.200
    76.669    -0.267     0.200
    76.732     1.393     0.200
    76.892     1.264     0.200
    76.855     0.582     0.200
    77.046     0.479     0.200
    77.046     1.782     0.200
    77.069     0.884     0.200
    77.123    -0.722     0.200
    77.123    -1.042     0.200
    77.127    -0.621     0.200
    77.267     0.972     0.200
    77.378     0.678     0.200
    77.378     1.469     0.200
    77.350     0.509     0.200
    77.350    -0.190     0.200
    77.437    -0.273     0.200
    77.572     0.418     0.200
    77.612     0.042     0.200
    77.624    -0.224     0.200
    77.705    -0.071     0.200
    77.752     1.914     0.200
    77.810     0.344     0.200
    77.981     1.091     0.200
    78.099    -0.590     0.200
    78.099    -0.742     0.200
    78.149    -0.071     0.200
    78.465    -0.053     0.200
    78.660    -0.453     0.200
    78.676    -0.040     0.200
    78.676     0.070     0.200
    78.894     0.547     0.200
    78.894     0.301     0.200
    78.860    -0.481     0.200
    78.860    -0.477     0.200
    79.084    -0.032     0.200
    79.084    -0.528     0.200
    79.131    -0.344     0.200
    79.131    -0.544     0.200
    79.445    -0.229     0.200
    79.594     0.450     0.200
    79.675    -0.127     0.200
    79.758     0.068     0.200
    79.934     0.449     0.200
    79.966    -1.118     0.200
    79.966    -0.977     0.200
    80.081     0.003     0.200
    80.335     0.203     0.200
    80.335    -0.517     0.200
    80.338    -0.232     0.200
    80.415    -0.341     0.200
    80.437     0.526     0.200
    80.915    -0.167     0.200
    81.099    -0.111     0.200
    81.162    -1.047     0.200
    81.257     0.382     0.200
    81.285     0.479     0.200
    81.285    -0.011     0.200
    81.499    -0.677     0.200
    81.597     0.099     0.200
    81.609    -0.431     0.200
    81.670    -0.798     0.200
    81.796    -0.545     0.200
    81.909    -1.136     0.200
    81.951    -1.369     0.200
    82.010    -0.271     0.200
    82.084    -0.257     0.200
    82.084     0.421     0.200
    82.117    -1.312     0.200
    82.492    -0.920     0.200
    82.480    -0.275     0.200
    82.531    -1.059     0.200
    82.559    -0.925     0.200
    82.874    -0.374     0.200
    83.169    -1.546     0.200
    83.280     0.653     0.200
    83.280     0.172     0.200
    83.334    -0.158     0.200
    83.326    -0.543     0.200
    83.729    -0.840     0.200
    83.857    -1.211     0.200
    83.992    -0.968     0.200
    83.992    -1.341     0.200
    84.127    -0.457     0.200
    84.231    -1.428     0.200
    84.271    -0.669     0.200
    84.361    -0.985     0.200
    84.376    -1.240     0.200
    84.555    -0.745     0.200
    84.617    -0.878     0.200
    84.654    -0.101     0.200
    84.673    -0.158     0.200
    84.728    -1.117     0.200
    84.768    -0.771     0.200
    84.787     0.050     0.200
    84.787    -0.120     0.200
    84.856    -0.869     0.200
    84.949    -0.359     0.200
    84.967    -0.449     0.200
    85.300    -0.335     0.200
    85.329    -1.043     0.200
    85.329    -0.667     0.200
    85.371    -1.000     0.200
    85.384    -0.774     0.200
    85.474     0.129     0.200
    85.532    -0.648     0.200
    85.550    -0.469     0.200
    85.581    -0.286     0.200
    85.585    -0.445     0.200
    85.715    -0.285     0.200
    85.724    -0.670     0.200
    85.766    -0.575     0.200
    85.875    -1.184     0.200
    85.892    -0.532     0.200
    85.901     0.169     0.200
    85.922    -1.047     0.200
    85.989    -0.937     0.200
    86.007     0.462     0.200
    86.008    -0.089     0.200
    86.008     1.039     0.200
    86.008     1.043     0.200
    86.008     0.459     0.200
    86.024    -0.425     0.200
    86.027    -0.927     0.200
    86.052    -0.407     0.200
    86.052    -0.147     0.200
    86.146    -0.760     0.200
    86.159    -0.409     0.200
    86.191    -0.803     0.200
    86.230    -0.807     0.200
    86.340    -0.835     0.200
    86.382    -0.736     0.200
    86.393    -0.766     0.200
    86.472    -0.570     0.200
    86.503    -0.763     0.200
    86.615    -0.356     0.200
    86.625    -0.478     0.200
    86.646    -0.406     0.200
    86.850    -0.399     0.200
    86.988    -0.838     0.200
    87.065    -0.303     0.200
    87.279    -0.246     0.200
    87.279     0.196     0.200
    87.344    -0.178     0.200
    87.461     0.132     0.200
    87.528    -0.389     0.200
    87.546    -0.244     0.200
    87.640    -0.347     0.200
    87.673     0.149     0.200
    87.673    -0.128     0.200
    87.734    -0.156     0.200
    87.737    -0.266     0.200
    87.788    -0.366     0.200
    87.811    -0.084     0.200
    87.850    -0.445     0.200
    87.855    -0.344     0.200
    87.877    -0.419     0.200
    87.924    -0.337     0.200
    88.096    -0.147     0.200
    88.112    -0.111     0.200
    88.138    -0.331     0.200
    88.149    -0.286     0.200
    88.153    -0.092     0.200
    88.187     0.014     0.200
    88.198    -0.214     0.200
    88.291     0.106     0.200
    88.362    -0.109     0.200
    88.485     0.099     0.200
    88.485    -0.167     0.200
    88.486    -0.054     0.200
    88.486     0.109     0.200
    88.508     0.029     0.200
    88.508    -0.855     0.200
    88.525    -0.481     0.200
    88.584     0.010     0.200
    88.586    -0.193     0.200
    88.621    -0.288     0.200
    88.678    -0.202     0.200
    88.710    -0.239     0.200
    88.710    -0.725     0.200
    88.777    -0.491     0.200
    88.791    -0.002     0.200
    88.791     0.252     0.200
    88.844     0.223     0.200
    88.999     0.126     0.200
    89.001     0.110     0.200
    89.006     0.256     0.200
    89.023    -0.089     0.200
    89.049    -0.015     0.200
    89.162     0.098     0.200
    89.202    -0.131     0.200
    89.213    -0.017     0.200
    89.292    -0.430     0.200
    89.302     0.102     0.200
    89.399    -0.055     0.200
    89.429     0.166     0.200
    89.455     0.048     0.200
    89.459     0.276     0.200
    89.474    -0.180     0.200
    89.509    -0.184     0.200
    89.559     0.244     0.200
    89.559    -0.176     0.200
    89.578    -0.101     0.200
    89.626     0.093     0.200
    89.626    -0.170     0.200
    89.640    -0.367     0.200
    89.665     0.062     0.200
    89.665     0.908     0.200
    89.666    -0.156     0.200
    89.683     0.301     0.200
    89.802     0.164     0.200
    89.807    -0.176     0.200
    89.807     0.373     0.200
    89.832    -0.115     0.200
    89.854    -0.293     0.200
    89.855    -0.077     0.200
    89.855     0.720     0.200
    89.999    -0.055     0.200
    90.024     0.033     0.200
    90.046    -0.171     0.200
    90.075     0.009     0.200
    90.075     0.243     0.200
    90.144     0.020     0.200
    90.186     0.040     0.200
    90.335    -0.086     0.200
    90.350    -0.416     0.200
    90.362    -0.340     0.200
    90.412    -0.432     0.200
    90.454    -0.253     0.200
    90.462    -0.337     0.200
    90.637    -0.117     0.200
    90.730    -0.209     0.200
    90.742    -0.275     0.200
    90.758    -0.366     0.200
    90.768    -0.052     0.200
    90.779    -0.277     0.200
    90.840    -0.187     0.200
    90.859    -0.005     0.200
    90.918    -0.284     0.200
    91.000    -0.019     0.200
    91.028    -0.330     0.200
    91.064    -0.539     0.200
    91.136    -0.292     0.200
    91.365     0.019     0.200
    91.474     0.085     0.200
    92.378    -0.239     0.200
    92.467    -0.490     0.200
    92.467     0.151     0.200
    93.066    -0.455     0.200
    93.433    -0.112     0.200
    95.213     0.063     0.200
    17.954    -1.090     0.200
    19.594    -0.310     0.200
    20.333    -2.863     0.200
    21.315    -2.746     0.200
    21.394    -2.427     0.200
    21.394    -2.190     0.200
    21.748    -0.875     0.200
    23.527    -0.710     0.200
    24.311    -1.067     0.200
    25.851    -0.447     0.200
    26.295    -0.056     0.200
    26.295    -0.545     0.200
    26.576    -0.442     0.200
    27.916     1.600     0.200
    28.160     0.011     0.200
    28.160     0.729     0.200
    28.160     0.250     0.200
    30.256    -0.416     0.200
    30.803     0.217     0.200
    32.565     1.138     0.200
    33.247    -1.214     0.200
    37.246     1.220     0.200
    39.103    -0.462     0.200
    39.822     1.417     0.200
    41.533    -0.372     0.200
    42.438    -0.445     0.200
    42.588    -0.780     0.200
    42.588    -0.282     0.200
    42.588    -0.580     0.200
    42.588    -0.910     0.200
    42.694     0.529     0.200
    42.744     0.588     0.200
    42.790    -0.414     0.200
    43.034     0.844     0.200
    43.503     0.039     0.200
    43.801     0.237     0.200
    43.847    -0.533     0.200
    43.847    -1.033     0.200
    43.847    -0.893     0.200
    43.936     0.585     0.200
    43.971     1.671     0.200
    43.974    -0.048     0.200
    43.926    -0.343     0.200
    44.010     0.258     0.200
    44.046    -0.038     0.200
    44.065     0.313     0.200
    44.076     0.392     0.200
    44.212     0.097     0.200
    44.429    -0.423     0.200
    44.429    -0.693     0.200
    44.429    -0.893     0.200
    44.434    -1.043     0.200
    44.546     0.275     0.200
    44.921    -0.111     0.200
    44.938    -0.443     0.200
    45.112     3.077     0.200
    45.157     0.410     0.200
    45.611    -1.871     0.200
    45.798     3.854     0.200
    46.721     1.061     0.200
    46.863    -0.351     0.200
    46.895    -0.114     0.200
    47.015     1.215     0.200
    47.042    -0.007     0.200
    47.362     0.271     0.200
    47.523     0.766     0.200
    47.639    -0.533     0.200
    47.973     1.082     0.200
    48.059     0.616     0.200
    48.066     0.358     0.200
    48.091    -0.465     0.200
    48.141    -0.318     0.200
    48.141    -0.818     0.200
    48.141    -0.537     0.200
    48.336    -0.722     0.200
    48.395     0.227     0.200
    48.504    -0.615     0.200
    48.577     0.430     0.200
    48.601     0.646     0.200
    48.607     0.800     0.200
    48.804     0.582     0.200
    48.937     0.565     0.200
    48.992    -0.202     0.200
    49.165    -0.641     0.200
    49.252    -0.338     0.200
    49.252     0.132     0.200
    49.386     0.407     0.200
    49.399     0.939     0.200
    49.568     5.048     0.200
    49.723    -0.270     0.200
    49.833     0.640     0.200
    50.001     0.880     0.200
    51.710    -0.781     0.200
    51.710    -0.681     0.200
    52.123    -0.450     0.200
    53.335    -0.515     0.200
    53.335    -1.201     0.200
    53.335    -0.902     0.200
    54.295    -0.710     0.200
    55.603    -0.753     0.200
    55.603    -0.833     0.200
    55.621    -1.521     0.200
    55.621    -1.757     0.200
    56.179    -0.167     0.200
    58.663    -0.309     0.200
    59.537    -1.645     0.200
    60.647    -1.597     0.200
    61.636    -0.541     0.200
    62.430    -0.611     0.200
    62.440     0.469     0.200
    62.440    -0.622     0.200
    62.463    -0.108     0.200
    62.463    -1.343     0.200
    64.667    -0.464     0.200
    64.667    -1.364     0.200
    64.764    -1.228     0.200
    64.766    -1.481     0.200
    64.766    -1.606     0.200
    65.429     0.095     0.200
    65.429    -0.015     0.200
    65.836    -0.732     0.200
    65.927    -0.815     0.200
    66.047     1.292     0.200
    66.167     1.344     0.200
    66.167     0.443     0.200
    66.576    -0.670     0.200
    67.551     0.299     0.200
    68.443     1.650     0.200
    68.443     0.648     0.200
    68.463    -0.362     0.200
    68.753     0.299     0.200
    69.539     0.133     0.200
    69.776     0.905     0.200
    69.796    -1.068     0.200
    69.819    -1.289     0.200
    69.826    -1.716     0.200
    69.826    -1.616     0.200
    69.978     1.193     0.200
    69.959    -0.457     0.200
    70.079    -2.017     0.200
    70.630     0.872     0.200
    70.897     0.830     0.200
    70.919    -1.246     0.200
    70.919    -0.585     0.200
    73.018     0.051     0.200
    72.984     0.949     0.200
    73.133    -0.406     0.200
    73.133     0.686     0.200
    73.133    -0.135     0.200
    73.130    -0.512     0.200
    73.408    -0.446     0.200
    74.449     0.052     0.200
    74.590     0.051     0.200
    74.689     0.973     0.200
    74.966    -0.220     0.200
    74.966    -0.370     0.200
    75.136     0.161     0.200
    75.102     0.176     0.200
    75.302    -0.154     0.200
    75.347     0.593     0.200
    75.348     0.654     0.200
    75.790     0.355     0.200
    75.799     0.905     0.200
    75.815     0.472     0.200
    76.097     1.084     0.200
    76.167     0.911     0.200
    76.316     0.358     0.200
    76.277     1.402     0.200
    76.308    -0.039     0.200
    76.333     0.072     0.200
    76.599     0.356     0.200
    76.583     0.058     0.200
    76.635     0.364     0.200
    76.635    -0.037     0.200
    76.649     0.684     0.200
    76.667     0.481     0.200
    76.721     0.976     0.200
    77.106     0.714     0.200
    77.155    -0.063     0.200
    77.202     0.677     0.200
    77.303     1.009     0.200
    77.385     0.050     0.200
    77.612    -0.116     0.200
    77.646    -0.009     0.200
    77.660    -0.083     0.200
    77.746     0.139     0.200
    77.846     0.280     0.200
    78.101     0.341     0.200
    78.108     0.531     0.200
    78.710    -0.090     0.200
    78.710     0.211     0.200
    78.894    -0.577     0.200
    79.516    -0.696     0.200
    79.658     0.733     0.200
    80.117     0.690     0.200
    80.283     2.262     0.200
    80.451    -0.448     0.200
    80.472     1.439     0.200
    80.719    -0.548     0.200
    80.985     0.598     0.200
    81.132     0.582     0.200
    81.185     0.264     0.200
    81.392    -0.896     0.200
    81.533    -0.804     0.200
    81.650    -0.228     0.200
    81.650    -0.674     0.200
    81.985    -1.777     0.200
    82.805    -0.751     0.200
    82.879    -0.568     0.200
    85.954     0.788     0.200
    85.954     0.114     0.200
    93.093    -0.411     0.200
    26.290    -0.240     0.200
    26.290    -0.040     0.200
    39.492    -0.138     0.200
    39.492    -0.308     0.200
    39.492    -1.158     0.200
    42.585    -0.065     0.200
    42.585    -0.140     0.200
    42.585    -0.865     0.200
    42.585    -0.495     0.200
    42.787    -0.099     0.200
    43.848    -0.254     0.200
    43.848    -1.053     0.200
    51.707    -0.553     0.200
    51.707    -0.753     0.200
    53.346    -0.572     0.200
    53.346    -0.972     0.200
    55.607    -0.506     0.200
    57.242    -1.426     0.200
    59.562    -1.634     0.200
    62.403     0.733     0.200
    64.786    -1.303     0.200
    64.786    -1.121     0.200
    69.850    -0.960     0.200
    76.315     0.433     0.200
    80.321     0.988     0.200
    85.992     0.940     0.200
    17.673     0.330     0.200
    21.339    -1.101     0.200
    25.883     0.203     0.200
    26.326    -0.793     0.200
    26.326     0.598     0.200
    26.326    -0.343     0.200
    28.192    -0.715     0.200
    38.586     1.173     0.200
    39.520    -0.565     0.200
    39.520    -0.300     0.200
    39.520    -0.483     0.200
    42.620     0.114     0.200
    42.620     0.040     0.200
    42.620    -0.898     0.200
    43.879    -0.336     0.200
    43.879    -0.524     0.200
    44.232     0.689     0.200
    44.428    -0.625     0.200
    47.042     0.461     0.200
    48.086     0.364     0.200
    48.094     0.702     0.200
    48.173     0.496     0.200
    48.604     0.775     0.200
    49.166    -1.282     0.200
    49.166    -0.298     0.200
    49.427     0.982     0.200
    53.367    -0.566     0.200
    55.635    -0.285     0.200
    59.563    -0.608     0.200
    62.428     0.188     0.200
    62.495    -0.015     0.200
    64.794    -1.241     0.200
    64.794    -1.385     0.200
    66.155     0.781     0.200
    68.475     0.626     0.200
    69.853    -1.649     0.200
    70.885    -0.914     0.200
    70.949    -1.268     0.200
    85.942     1.103     0.200
    18.038     1.107     0.200
    21.161    -0.998     0.200
    21.161    -2.338     0.200
    21.329     1.593     0.200
    21.469    -2.202     0.200
    23.983     0.086     0.200
    25.784     0.245     0.200
    25.873     0.708     0.200
    25.873    -1.116     0.200
    26.235     0.602     0.200
    27.466     1.659     0.200
    28.824     0.858     0.200
    28.824    -2.622     0.200
    30.166    -1.974     0.200
    32.798    -0.183     0.200
    38.152     0.250     0.200
    39.116     0.420     0.200
    39.116     0.272     0.200
    39.116    -0.478     0.200
    41.766    -0.630     0.200
    42.175    -0.372     0.200
    42.175    -0.422     0.200
    42.175    -0.172     0.200
    42.463    -0.285     0.200
    42.749    -0.132     0.200
    42.749    -1.964     0.200
    42.946     0.379     0.200
    43.001     0.442     0.200
    43.018     1.441     0.200
    43.216     0.577     0.200
    43.459    -0.210     0.200
    43.458    -0.465     0.200
    43.458    -0.567     0.200
    43.750    -0.773     0.200
    43.789    -0.021     0.200
    43.874     0.091     0.200
    43.938    -0.222     0.200
    44.074    -0.113     0.200
    44.183     0.090     0.200
    44.254    -0.353     0.200
    44.292    -0.866     0.200
    44.341     0.011     0.200
    44.349    -0.059     0.200
    44.674    -0.654     0.200
    44.674    -0.904     0.200
    44.674    -0.654     0.200
    44.682    -1.324     0.200
    44.818    -0.855     0.200
    45.175    -0.400     0.200
    45.375    -0.043     0.200
    45.682    -1.007     0.200
    46.040    -1.964     0.200
    46.944     1.217     0.200
    47.104    -0.722     0.200
    47.153     0.453     0.200
    47.518     0.821     0.200
    47.604     0.352     0.200
    47.611     0.695     0.200
    47.814     0.388     0.200
    47.775     0.321     0.200
    47.775    -0.077     0.200
    48.121     0.947     0.200
    48.145     0.363     0.200
    48.151     0.316     0.200
    48.349     0.888     0.200
    48.482     0.569     0.200
    48.599     0.318     0.200
    48.830    -0.405     0.200
    48.944     1.321     0.200
    49.135     4.959     0.200
    49.368    -0.922     0.200
    49.368    -0.820     0.200
    49.377     0.107     0.200
    51.295    -0.790     0.200
    52.248     0.455     0.200
    53.006    -1.081     0.200
    53.278    -0.463     0.200
    54.237    -0.035     0.200
    55.278    -2.069     0.200
    55.231    -0.093     0.200
    55.231     0.016     0.200
    55.509    -0.787     0.200
    55.858    -0.131     0.200
    55.817    -0.217     0.200
    55.994    -0.214     0.200
    56.568    -1.107     0.200
    57.304    -1.193     0.200
    57.304    -1.693     0.200
    58.886    -0.644     0.200
    59.059    -0.018     0.200
    59.770    -2.071     0.200
    62.211    -0.215     0.200
    62.380    -0.255     0.200
    62.386    -0.509     0.200
    62.390    -0.555     0.200
    62.391    -0.798     0.200
    62.391    -0.684     0.200
    64.530    -1.833     0.200
    64.531    -1.464     0.200
    65.411     0.121     0.200
    65.411    -0.379     0.200
    65.515    -2.357     0.200
    66.117     0.014     0.200
    66.118    -0.042     0.200
    67.816    -2.012     0.200
    68.100     0.790     0.200
    68.873     0.064     0.200
    69.611    -0.873     0.200
    69.630    -1.222     0.200
    69.630    -1.222     0.200
    70.622    -1.083     0.200
    71.258    -0.970     0.200
    78.416    -0.327     0.200
    86.306     0.720     0.200
    26.231     0.032     0.200
    39.458    -0.292     0.200
    42.531    -0.594     0.200
    42.531    -0.371     0.200
    42.531    -0.554     0.200
    43.807    -0.887     0.200
    44.582    -0.670     0.200
    49.313    -0.862     0.200
    50.764     0.103     0.200
    51.652    -0.715     0.200
    55.573    -0.485     0.200
    59.591    -1.184     0.200
    62.319     0.266     0.200
    64.801    -1.318     0.200
    70.928    -1.272     0.200
    71.054     1.979     0.200
    76.288     0.184     0.200
    86.111     1.134     0.200
    26.307     0.019     0.200
    39.502    -0.726     0.200
    42.601    -0.367     0.200
    44.438    -0.179     0.200
    49.174    -0.342     0.200
    64.782    -1.487     0.200
    70.900     1.516     0.200
    85.957     1.221     0.200
    21.299    -4.171     0.200
    28.647    -3.794     0.200
    42.209    -0.214     0.200
    43.471     0.162     0.200
    43.550    -0.480     0.200
    47.720    -0.136     0.200
    55.810    -0.861     0.200
    66.282    -0.013     0.200
    86.125     1.865     0.200
    15.565     1.420     0.200
    21.319    -3.472     0.200
    21.365    -3.188     0.200
    21.365    -3.563     0.200
    24.031    -3.145     0.200
    25.835     0.766     0.200
    25.902    -0.443     0.200
    26.346    -0.739     0.200
    26.346    -0.528     0.200
    27.981     1.197     0.200
    28.204    -0.700     0.200
    28.204    -0.192     0.200
    28.204     0.207     0.200
    28.667    -0.709     0.200
    28.667    -1.404     0.200
    29.466    -1.045     0.200
    29.852     0.086     0.200
    30.394    -0.297     0.200
    32.625     0.386     0.200
    39.529    -0.604     0.200
    39.529    -0.338     0.200
    39.529    -0.830     0.200
    39.875    -0.138     0.200
    41.485    -0.095     0.200
    42.637     0.113     0.200
    42.637    -0.387     0.200
    42.637    -0.090     0.200
    42.637    -0.356     0.200
    42.839    -0.090     0.200
    42.839    -0.520     0.200
    43.891    -0.594     0.200
    43.891    -0.273     0.200
    43.961     0.843     0.200
    44.039    -0.250     0.200
    44.277     0.916     0.200
    44.380    -0.501     0.200
    44.380    -0.360     0.200
    44.380    -1.704     0.200
    47.078     0.714     0.200
    47.586     0.869     0.200
    48.122     0.427     0.200
    48.129     0.771     0.200
    48.180    -0.324     0.200
    48.180    -0.449     0.200
    48.639     0.644     0.200
    48.664     0.263     0.200
    48.669     0.217     0.200
    48.867     0.701     0.200
    49.000     0.186     0.200
    49.120    -0.887     0.200
    49.302     0.773     0.200
    49.302    -0.156     0.200
    49.461     0.860     0.200
    49.895     0.563     0.200
    51.759    -0.425     0.200
    51.759    -0.644     0.200
    51.759    -0.667     0.200
    52.155    -0.289     0.200
    53.368    -0.837     0.200
    53.368    -0.493     0.200
    53.368    -0.735     0.200
    55.643    -0.532     0.200
    55.643    -0.141     0.200
    55.643    -0.712     0.200
    56.218    -1.340     0.200
    56.875    -0.486     0.200
    57.171    -1.497     0.200
    58.616    -0.741     0.200
    59.546    -1.727     0.200
    60.042    -2.659     0.200
    60.042    -2.760     0.200
    62.466     0.138     0.200
    62.512    -0.543     0.200
    64.594    -1.677     0.200
    64.782    -1.148     0.200
    64.782    -0.914     0.200
    65.412     0.116     0.200
    65.412    -0.001     0.200
    65.867    -1.509     0.200
    66.193     0.993     0.200
    66.193    -0.664     0.200
    68.481     0.966     0.200
    68.481     0.529     0.200
    68.481     0.161     0.200
    68.502     0.181     0.200
    68.502     0.704     0.200
    68.900     1.329     0.200
    69.646    -0.382     0.200
    69.836    -1.258     0.200
    69.836    -1.054     0.200
    69.989     0.907     0.200
    70.669     0.676     0.200
    70.836     1.243     0.200
    70.946    -1.095     0.200
    70.946    -1.220     0.200
    73.034     1.355     0.200
    73.075     0.736     0.200
    73.075     0.111     0.200
    73.158    -1.255     0.200
    73.158    -1.357     0.200
    74.979    -0.043     0.200
    74.993    -0.044     0.200
    75.131    -0.344     0.200
    75.327     0.631     0.200
    75.394    -0.451     0.200
    75.815     0.330     0.200
    75.843     0.717     0.200
    76.308     0.935     0.200
    76.345    -0.618     0.200
    76.345     0.038     0.200
    76.602    -0.026     0.200
    76.656     0.000     0.200
    76.677     0.880     0.200
    76.724    -0.212     0.200
    77.773    -0.239     0.200
    78.729    -0.162     0.200
    78.799     1.150     0.200
    78.914    -1.129     0.200
    78.914    -0.410     0.200
    79.687     0.585     0.200
    79.872    -0.195     0.200
    80.139     0.450     0.200
    80.472     0.128     0.200
    80.968     0.083     0.200
    81.004     0.319     0.200
    81.140     0.432     0.200
    85.893     0.494     0.200
    85.893     1.296     0.200
    85.893     0.179     0.200
    21.129    -1.202     0.200
    42.257    -0.342     0.200
    44.292     0.074     0.200
    58.507     0.513     0.200
    62.719     0.029     0.200
    64.389    -1.226     0.200
    70.889     1.780     0.200
    73.072     0.623     0.200
    85.934     1.467     0.200
    17.590     1.533     0.200
    20.799     0.597     0.200
    20.799     0.995     0.200
    21.022    -1.101     0.200
    21.022    -1.305     0.200
    23.175     0.253     0.200
    25.391    -0.022     0.200
    25.835    -0.491     0.200
    29.769    -2.730     0.200
    37.067     0.894     0.200
    38.067     0.635     0.200
    38.976    -1.725     0.200
    38.976    -0.201     0.200
    41.329    -0.888     0.200
    42.114    -0.619     0.200
    42.114    -0.463     0.200
    42.114    -0.572     0.200
    42.315    -0.453     0.200
    43.347    -0.616     0.200
    43.347    -0.413     0.200
    43.426    -0.805     0.200
    43.829     0.600     0.200
    44.071     0.412     0.200
    44.071     1.263     0.200
    44.241    -0.446     0.200
    44.241    -0.845     0.200
    44.241    -0.626     0.200
    46.724     0.824     0.200
    47.225     1.044     0.200
    47.575    -0.714     0.200
    47.625    -0.667     0.200
    47.625    -0.565     0.200
    47.662     0.446     0.200
    47.752     0.748     0.200
    47.756     0.510     0.200
    48.488     1.159     0.200
    48.616     0.478     0.200
    48.924    -0.938     0.200
    49.070     0.991     0.200
    51.238    -0.831     0.200
    51.238    -0.730     0.200
    55.090    -0.426     0.200
    58.446    -0.563     0.200
    64.129    -1.829     0.200
    64.229    -1.441     0.200
    67.945     0.228     0.200
    67.945     1.157     0.200
    69.288    -1.394     0.200
    69.298    -1.177     0.200
    69.298    -0.583     0.200
    70.892     0.750     0.200
    73.052     0.155     0.200
    85.932    -0.122     0.200
    44.220    -0.831     0.200
    56.839    -1.218     0.200
    58.427     0.083     0.200
    17.663    -3.134     0.200
    17.663    -2.386     0.200
    17.663    -2.507     0.200
    20.038    -0.856     0.200
    21.109    -2.699     0.200
    21.255    -4.288     0.200
    21.255    -2.267     0.200
    22.225     1.252     0.200
    23.933     0.305     0.200
    25.559     0.091     0.200
    25.809    -0.458     0.200
    26.161    -0.706     0.200
    26.584    -0.495     0.200
    26.605     0.125     0.200
    28.375    -2.201     0.200
    28.414    -0.765     0.200
    28.822    -1.892     0.200
    29.797    -1.291     0.200
    30.246    -1.521     0.200
    31.231     2.329     0.200
    33.702    -1.272     0.200
    34.874    -0.722     0.200
    36.095     0.489     0.200
    36.222    -1.094     0.200
    39.126    -2.407     0.200
    39.708     0.213     0.200
    39.708    -0.992     0.200
    40.021     0.022     0.200
    40.151     1.560     0.200
    41.772     1.388     0.200
    41.986     0.198     0.200
    41.986    -1.925     0.200
    42.274     0.262     0.200
    42.321     0.125     0.200
    42.361     0.040     0.200
    42.477    -0.855     0.200
    42.531     0.836     0.200
    42.586    -0.363     0.200
    42.610    -0.960     0.200
    42.627    -0.669     0.200
    42.863    -0.584     0.200
    42.879    -0.105     0.200
    42.879    -0.359     0.200
    42.938     0.470     0.200
    43.086     0.382     0.200
    43.080     0.125     0.200
    43.256    -0.501     0.200
    43.289     0.159     0.200
    43.368    -0.212     0.200
    43.518    -0.437     0.200
    43.595     0.256     0.200
    43.630    -0.045     0.200
    43.629    -0.789     0.200
    43.644    -0.332     0.200
    43.953    -0.341     0.200
    44.014    -0.391     0.200
    44.014    -0.610     0.200
    44.017    -1.073     0.200
    44.114     0.516     0.200
    44.093    -0.390     0.200
    44.093    -1.371     0.200
    44.527    -0.217     0.200
    44.672    -0.402     0.200
    44.717     0.863     0.200
    44.687    -0.481     0.200
    45.060     0.668     0.200
    45.624     0.297     0.200
    46.218     0.517     0.200
    46.285     0.527     0.200
    46.434     0.303     0.200
    46.449    -0.478     0.200
    46.929     0.567     0.200
    47.105     0.316     0.200
    47.333    -0.076     0.200
    47.973     0.103     0.200
    48.349    -0.662     0.200
    48.349     0.338     0.200
    48.776    -0.511     0.200
    48.954    -0.110     0.200
    49.903     3.380     0.200
    51.778    -0.951     0.200
    52.004    -0.594     0.200
    52.004    -0.505     0.200
    53.330     0.392     0.200
    53.488     0.089     0.200
    55.510    -1.024     0.200
    55.510    -1.579     0.200
    56.183     0.786     0.200
    56.182     0.794     0.200
    56.248     0.299     0.200
    56.892    -1.292     0.200
    56.892    -1.432     0.200
    58.260    -0.474     0.200
    58.961    -0.614     0.200
    59.478     0.416     0.200
    59.505    -0.994     0.200
    60.089    -1.824     0.200
    62.712    -0.698     0.200
    64.770    -1.130     0.200
    64.792    -1.371     0.200
    65.222    -0.656     0.200
    65.222    -0.166     0.200
    65.736     1.217     0.200
    66.438    -0.184     0.200
    68.222     0.028     0.200
    68.375    -0.590     0.200
    69.605    -0.337     0.200
    69.612    -0.241     0.200
    69.741    -0.382     0.200
    69.776    -0.831     0.200
    69.807    -1.348     0.200
    69.807    -1.197     0.200
    69.937    -0.787     0.200
    70.425     1.122     0.200
    71.026    -1.424     0.200
    72.676     0.244     0.200
    73.249    -1.704     0.200
    74.035    -0.741     0.200
    75.061     0.249     0.200
    75.075    -0.217     0.200
    75.165     0.058     0.200
    75.224    -0.247     0.200
    75.885     0.117     0.200
    76.498     0.483     0.200
    76.699     0.292     0.200
    76.699    -0.130     0.200
    76.769     0.845     0.200
    77.192    -0.768     0.200
    77.192    -0.907     0.200
    77.650    -0.725     0.200
    77.693     0.081     0.200
    78.760    -0.222     0.200
    78.844     0.780     0.200
    78.946    -1.150     0.200
    79.624    -1.014     0.200
    79.624    -0.303     0.200
    80.186    -0.395     0.200
    80.998     0.092     0.200
    81.169     0.187     0.200
    84.116     0.468     0.200
    85.484     0.632     0.200
    85.484    -0.099     0.200
    85.484     0.824     0.200
    15.438     2.281     0.200
    17.942     1.505     0.200
    19.108    -0.755     0.200
    19.119    -1.081     0.200
    19.797     0.110     0.200
    19.797    -1.089     0.200
    20.666    -1.443     0.200
    20.745    -0.597     0.200
    22.295    -1.950     0.200
    22.622    -3.226     0.200
    22.992    -3.650     0.200
    23.491    -2.897     0.200
    24.031    -1.311     0.200
    24.057     0.555     0.200
    24.057     0.426     0.200
    24.360     0.459     0.200
    24.734     0.884     0.200
    25.066    -1.142     0.200
    25.291    -0.198     0.200
    25.418    -1.469     0.200
    25.761     1.353     0.200
    25.857    -0.503     0.200
    26.000    -1.450     0.200
    26.243     0.172     0.200
    26.643    -1.427     0.200
    26.757    -2.958     0.200
    26.757    -2.259     0.200
    27.132    -1.530     0.200
    28.310    -0.002     0.200
    28.786    -0.309     0.200
    28.786    -0.809     0.200
    29.554    -1.119     0.200
    29.594    -0.580     0.200
    29.765    -2.533     0.200
    29.765    -2.291     0.200
    29.765    -3.103     0.200
    29.945    -2.740     0.200
    30.454    -0.362     0.200
    32.574     0.053     0.200
    35.545    -0.944     0.200
    35.545    -1.745     0.200
    36.168     1.119     0.200
    37.354     0.313     0.200
    37.819     0.083     0.200
    38.263    -2.195     0.200
    38.263    -1.968     0.200
    38.339    -0.107     0.200
    38.339    -0.107     0.200
    38.339    -0.209     0.200
    38.584     0.736     0.200
    38.584    -0.163     0.200
    38.600    -1.545     0.200
    39.501    -0.375     0.200
    41.204    -2.015     0.200
    41.371    -1.123     0.200
    41.371    -0.724     0.200
    41.574    -0.942     0.200
    41.735    -1.093     0.200
    41.737    -1.473     0.200
    41.831    -1.106     0.200
    42.001     1.023     0.200
    42.001     0.523     0.200
    42.414    -2.561     0.200
    42.637    -1.313     0.200
    42.669    -0.719     0.200
    42.694     1.438     0.200
    42.747    -0.201     0.200
    42.941     0.101     0.200
    42.941    -0.626     0.200
    43.073     0.121     0.200
    43.152    -0.036     0.200
    43.184     1.158     0.200
    43.184     0.319     0.200
    43.184     0.959     0.200
    43.349    -1.364     0.200
    43.349    -0.888     0.200
    43.501    -0.293     0.200
    43.521     1.385     0.200
    43.521    -0.455     0.200
    43.573    -1.604     0.200
    43.573    -1.303     0.200
    43.619    -0.844     0.200
    43.653    -1.961     0.200
    43.755    -1.057     0.200
    43.755    -0.670     0.200
    43.755    -1.197     0.200
    43.947    -0.789     0.200
    44.086    -1.759     0.200
    44.123    -0.401     0.200
    44.156    -1.123     0.200
    44.251    -1.083     0.200
    44.380    -0.447     0.200
    44.167    -0.619     0.200
    44.443     0.183     0.200
    44.485    -0.714     0.200
    44.511     0.030     0.200
    44.463     2.922     0.200
    44.595    -0.354     0.200
    44.597    -0.969     0.200
    44.682     2.368     0.200
    44.760    -0.562     0.200
    44.872    -0.371     0.200
    44.862    -0.572     0.200
    44.840     1.708     0.200
    44.879    -1.378     0.200
    44.879    -0.991     0.200
    44.922     1.660     0.200
    44.922     0.762     0.200
    45.211    -0.252     0.200
    45.349     0.084     0.200
    45.712    -2.232     0.200
    45.736    -2.101     0.200
    45.857    -0.809     0.200
    45.890    -0.855     0.200
    46.092     0.160     0.200
    46.072     1.447     0.200
    46.072    -0.323     0.200
    46.119    -0.311     0.200
    46.209     0.560     0.200
    46.292    -0.874     0.200
    46.324    -0.135     0.200
    46.312     1.462     0.200
    46.523     0.943     0.200
    46.590    -2.056     0.200
    46.953    -0.357     0.200
    46.998     0.069     0.200
    47.004    -0.167     0.200
    47.004    -0.358     0.200
    47.166     0.396     0.200
    47.364     0.025     0.200
    47.379    -1.050     0.200
    47.606    -0.532     0.200
    47.594    -1.078     0.200
    47.614     0.482     0.200
    47.710     0.238     0.200
    47.722    -0.355     0.200
    47.767    -0.123     0.200
    48.023     0.507     0.200
    48.023    -0.216     0.200
    48.023    -0.091     0.200
    48.023    -0.826     0.200
    48.023    -1.181     0.200
    48.178     0.411     0.200
    48.179     0.502     0.200
    48.328     4.257     0.200
    48.496     0.034     0.200
    48.615     0.138     0.200
    48.746    -0.131     0.200
    48.884     0.278     0.200
    49.474    -0.169     0.200
    49.524     1.775     0.200
    50.037    -0.395     0.200
    50.491    -1.065     0.200
    50.491    -0.764     0.200
    50.627     1.908     0.200
    50.969     1.018     0.200
    51.058     0.162     0.200
    51.121    -0.804     0.200
    51.177     1.031     0.200
    51.225     0.511     0.200
    51.310    -0.011     0.200
    51.321     0.882     0.200
    51.388    -2.262     0.200
    51.435    -0.456     0.200
    51.532    -0.612     0.200
    51.576    -0.504     0.200
    51.787     1.702     0.200
    51.926     0.063     0.200
    52.030     0.582     0.200
    52.030     0.086     0.200
    52.030    -1.453     0.200
    52.197     1.645     0.200
    52.271    -0.707     0.200
    52.271    -0.508     0.200
    52.271    -1.016     0.200
    52.471    -1.172     0.200
    52.710     1.837     0.200
    52.811     0.095     0.200
    53.049    -0.878     0.200
    53.049     0.232     0.200
    53.429    -0.728     0.200
    53.792     0.262     0.200
    54.307     0.092     0.200
    54.454    -0.560     0.200
    54.645    -0.398     0.200
    55.048    -0.437     0.200
    55.048    -0.863     0.200
    55.065    -0.544     0.200
    55.173    -1.866     0.200
    55.173    -2.269     0.200
    55.173    -1.448     0.200
    55.320     4.775     0.200
    55.576    -0.300     0.200
    55.831    -1.071     0.200
    56.006    -0.474     0.200
    56.373     0.035     0.200
    57.056    -0.928     0.200
    57.056    -0.526     0.200
    57.067    -0.334     0.200
    57.090    -0.201     0.200
    57.216    -1.064     0.200
    57.418     0.403     0.200
    57.546     2.013     0.200
    57.634    -2.211     0.200
    57.723    -0.625     0.200
    57.752     0.659     0.200
    58.251    -1.144     0.200
    58.487     0.454     0.200
    58.516     0.139     0.200
    58.519    -0.562     0.200
    58.573    -1.076     0.200
    58.801    -0.571     0.200
    58.801    -0.923     0.200
    59.029    -0.135     0.200
    59.088    -0.970     0.200
    59.112     0.109     0.200
    59.155    -0.157     0.200
    59.580    -3.169     0.200
    59.837    -0.937     0.200
    60.014    -1.257     0.200
    60.047     0.370     0.200
    60.226    -1.508     0.200
    60.398    -0.331     0.200
    60.459    -2.520     0.200
    61.053    -0.289     0.200
    61.245    -1.098     0.200
    61.554    -1.341     0.200
    62.131    -0.023     0.200
    62.456     0.879     0.200
    62.543    -0.086     0.200
    62.621    -1.078     0.200
    62.570    -1.163     0.200
    62.578    -0.854     0.200
    62.579    -1.264     0.200
    62.580    -0.806     0.200
    62.580    -0.931     0.200
    62.818    -2.421     0.200
    62.818    -1.523     0.200
    62.894    -2.674     0.200
    62.914    -0.424     0.200
    63.018    -1.230     0.200
    63.022     0.074     0.200
    63.376     0.409     0.200
    63.427    -1.349     0.200
    63.503    -0.864     0.200
    63.508    -0.072     0.200
    63.676    -1.006     0.200
    63.676    -1.686     0.200
    63.757     0.758     0.200
    63.908    -1.158     0.200
    63.910    -1.148     0.200
    63.983    -0.231     0.200
    64.073    -1.025     0.200
    64.152    -2.520     0.200
    64.248    -0.209     0.200
    64.231     0.775     0.200
    64.254     0.678     0.200
    64.402    -0.250     0.200
    64.615    -0.550     0.200
    64.789    -1.208     0.200
    64.876    -0.978     0.200
    64.921     0.285     0.200
    65.094    -3.195     0.200
    65.115     0.567     0.200
    65.247     0.108     0.200
    65.321    -0.075     0.200
    65.452     0.524     0.200
    65.544    -1.684     0.200
    65.679    -0.842     0.200
    65.679    -1.084     0.200
    65.710     0.354     0.200
    65.827     0.260     0.200
    65.856     0.554     0.200
    65.964    -0.620     0.200
    65.942     0.516     0.200
    66.082    -1.409     0.200
    66.100    -0.425     0.200
    66.184    -0.136     0.200
    66.220    -0.390     0.200
    66.237     0.038     0.200
    66.307    -0.127     0.200
    66.440    -0.376     0.200
    66.449     0.533     0.200
    66.795    -0.316     0.200
    66.932    -0.043     0.200
    66.949     0.112     0.200
    67.000     2.577     0.200
    67.007    -0.515     0.200
    67.028     0.438     0.200
    67.119    -0.086     0.200
    67.313     0.828     0.200
    67.313     0.395     0.200
    67.313     0.063     0.200
    67.324    -1.304     0.200
    67.331     0.200     0.200
    67.331    -0.851     0.200
    67.355     0.119     0.200
    67.474    -0.254     0.200
    67.441    -0.369     0.200
    67.461     0.155     0.200
    67.470     1.286     0.200
    67.488     0.576     0.200
    67.559    -1.005     0.200
    67.735    -0.444     0.200
    67.908    -0.386     0.200
    67.934    -0.359     0.200
    67.954    -1.607     0.200
    68.022    -0.352     0.200
    67.998    -0.450     0.200
    68.099    -1.397     0.200
    68.198     0.282     0.200
    68.226    -1.031     0.200
    68.380     3.844     0.200
    68.380     0.313     0.200
    68.420     0.174     0.200
    68.764    -0.178     0.200
    68.827    -0.840     0.200
    68.855    -1.226     0.200
    68.864    -0.853     0.200
    68.868    -0.671     0.200
    68.960    -0.578     0.200
    69.004    -1.356     0.200
    69.026    -0.991     0.200
    69.037    -0.451     0.200
    69.061    -0.803     0.200
    69.061    -0.979     0.200
    69.045    -1.006     0.200
    69.059    -0.591     0.200
    69.196    -1.755     0.200
    69.208    -1.225     0.200
    69.208    -0.893     0.200
    69.227    -0.635     0.200
    69.254    -0.704     0.200
    69.311     0.105     0.200
    69.314    -1.353     0.200
    69.314    -1.224     0.200
    69.486     0.999     0.200
    69.516    -0.047     0.200
    69.516     0.355     0.200
    69.551    -0.599     0.200
    69.700     0.226     0.200
    69.712    -0.730     0.200
    69.903    -0.732     0.200
    69.921    -0.919     0.200
    69.933     0.359     0.200
    70.093    -0.503     0.200
    70.125    -0.111     0.200
    70.125     0.190     0.200
    70.191    -0.231     0.200
    70.189    -0.710     0.200
    70.218    -0.939     0.200
    70.218    -0.830     0.200
    70.308    -0.167     0.200
    70.370     0.019     0.200
    70.434    -0.661     0.200
    70.455    -0.334     0.200
    70.459     0.260     0.200
    70.622     0.832     0.200
    70.622    -0.113     0.200
    70.661    -0.948     0.200
    70.661    -0.538     0.200
    70.645    -1.081     0.200
    70.689    -0.615     0.200
    70.784     0.190     0.200
    71.209    -0.219     0.200
    71.256    -0.259     0.200
    71.355    -0.559     0.200
    71.401     1.234     0.200
    71.577     0.941     0.200
    71.674     0.540     0.200
    71.699     0.862     0.200
    71.756    -0.253     0.200
    71.734    -0.955     0.200
    72.113    -0.024     0.200
    72.126     0.894     0.200
    72.144     1.360     0.200
    72.287    -0.380     0.200
    72.335     0.422     0.200
    72.398     0.419     0.200
    72.414     0.968     0.200
    72.508     0.083     0.200
    72.508    -0.183     0.200
    72.552    -0.843     0.200
    72.684     0.072     0.200
    72.665     0.801     0.200
    72.803     0.245     0.200
    72.803    -0.134     0.200
    72.790     0.140     0.200
    72.902    -0.123     0.200
    72.892     0.552     0.200
    73.053     1.274     0.200
    73.122     0.180     0.200
    73.194     0.386     0.200
    73.371     0.668     0.200
    73.409    -0.720     0.200
    73.385    -0.977     0.200
    73.385     0.101     0.200
    73.436     0.852     0.200
    73.624     0.392     0.200
    73.732     0.648     0.200
    73.746     1.598     0.200
    73.746     0.254     0.200
    73.743     0.285     0.200
    73.794     0.158     0.200
    73.794    -0.495     0.200
    73.794     0.118     0.200
    73.845     0.064     0.200
    73.899     0.383     0.200
    73.911     0.171     0.200
    73.951    -0.262     0.200
    73.913     0.595     0.200
    73.964    -0.028     0.200
    73.993     1.012     0.200
    74.034     0.312     0.200
    74.081     0.477     0.200
    74.123     1.340     0.200
    74.123     0.789     0.200
    74.192     0.015     0.200
    74.238    -0.522     0.200
    74.262     0.329     0.200
    74.304     0.496     0.200
    74.304    -0.363     0.200
    74.392     0.040     0.200
    74.432    -0.039     0.200
    74.432     0.187     0.200
    74.506     1.142     0.200
    74.506     0.060     0.200
    74.549    -1.689     0.200
    74.555     0.873     0.200
    74.576    -0.260     0.200
    74.676     0.372     0.200
    74.648     0.449     0.200
    74.713     0.261     0.200
    74.772     0.062     0.200
    74.827     0.608     0.200
    74.827     0.799     0.200
    74.822     0.040     0.200
    74.847    -1.244     0.200
    74.899    -0.155     0.200
    75.049    -0.165     0.200
    75.079     1.529     0.200
    75.073    -0.370     0.200
    75.073     0.220     0.200
    75.103    -0.397     0.200
    75.103    -0.136     0.200
    75.093    -0.021     0.200
    75.134     1.412     0.200
    75.134     0.026     0.200
    75.098     0.442     0.200
    75.157     1.257     0.200
    75.190     0.151     0.200
    75.190     0.451     0.200
    75.210     0.195     0.200
    75.250     0.238     0.200
    75.264     0.305     0.200
    75.380     0.018     0.200
    75.380     0.307     0.200
    75.385     1.382     0.200
    75.564     1.057     0.200
    75.563     0.330     0.200
    75.628     1.204     0.200
    75.628     0.384     0.200
    75.707     0.503     0.200
    75.707     0.132     0.200
    75.698     0.487     0.200
    75.693     0.464     0.200
    75.754     0.362     0.200
    75.755     0.561     0.200
    75.879     1.337     0.200
    75.889     0.594     0.200
    75.983     0.801     0.200
    75.983    -0.964     0.200
    75.983    -0.855     0.200
    76.009     0.498     0.200
    76.141     1.330     0.200
    76.157     0.170     0.200
    76.270    -0.177     0.200
    76.278    -0.518     0.200
    76.304     0.331     0.200
    76.358    -0.278     0.200
    76.332    -0.328     0.200
    76.366     0.878     0.200
    76.373    -0.847     0.200
    76.456     0.111     0.200
    76.458    -0.172     0.200
    76.461     0.245     0.200
    76.461     0.643     0.200
    76.428     1.055     0.200
    76.487     0.315     0.200
    76.576     0.280     0.200
    76.735     0.093     0.200
    76.735     0.292     0.200
    76.735     0.787     0.200
    76.744     0.339     0.200
    76.779    -0.258     0.200
    76.763    -1.645     0.200
    76.802     0.112     0.200
    76.813    -0.298     0.200
    76.852     0.729     0.200
    76.839    -0.145     0.200
    76.844    -0.474     0.200
    76.908    -0.585     0.200
    76.942     0.363     0.200
    76.984     0.847     0.200
    77.031     0.774     0.200
    77.031    -0.128     0.200
    77.029     0.165     0.200
    77.112     0.265     0.200
    77.120     0.224     0.200
    77.084    -0.182     0.200
    77.190     0.038     0.200
    77.199     0.578     0.200
    77.201    -0.260     0.200
    77.233    -0.052     0.200
    77.222    -1.164     0.200
    77.258    -0.133     0.200
    77.292    -0.007     0.200
    77.293    -0.468     0.200
    77.330     0.042     0.200
    77.330    -0.161     0.200
    77.336     0.128     0.200
    77.342    -0.218     0.200
    77.370    -0.270     0.200
    77.682     0.100     0.200
    77.777    -0.331     0.200
    77.767     0.303     0.200
    77.807     0.377     0.200
    77.822     0.304     0.200
    77.846     0.701     0.200
    77.885    -0.518     0.200
    77.868     2.039     0.200
    77.923    -0.615     0.200
    77.923    -0.716     0.200
    77.988    -0.040     0.200
    77.988    -0.158     0.200
    77.991     0.154     0.200
    78.070     0.419     0.200
    78.212     0.130     0.200
    78.212    -0.198     0.200
    78.222     0.671     0.200
    78.247     0.634     0.200
    78.247     0.735     0.200
    78.245     0.113     0.200
    78.245     0.824     0.200
    78.452    -1.499     0.200
    78.463    -0.401     0.200
    78.522     0.256     0.200
    78.561    -0.031     0.200
    78.626     0.593     0.200
    78.626     0.140     0.200
    78.826    -0.149     0.200
    78.799     0.882     0.200
    78.842     0.037     0.200
    79.036    -0.139     0.200
    79.005    -0.035     0.200
    79.118    -0.262     0.200
    79.157    -0.429     0.200
    79.180    -0.013     0.200
    79.181     0.084     0.200
    79.230     0.023     0.200
    79.341    -0.025     0.200
    79.341     0.116     0.200
    79.368    -0.131     0.200
    79.359    -0.015     0.200
    79.395    -0.306     0.200
    79.511    -0.435     0.200
    79.517    -0.132     0.200
    79.538    -0.154     0.200
    79.553     0.260     0.200
    79.553     0.862     0.200
    79.559    -0.083     0.200
    79.531    -0.267     0.200
    79.555    -0.949     0.200
    79.766    -0.592     0.200
    79.794    -0.463     0.200
    79.802    -0.477     0.200
    79.851    -0.054     0.200
    79.894     0.713     0.200
    79.891     2.130     0.200
    79.955     1.153     0.200
    80.016    -0.608     0.200
    80.047     0.001     0.200
    80.082     0.252     0.200
    80.095     0.651     0.200
    80.095     0.921     0.200
    80.086    -0.668     0.200
    80.125    -0.286     0.200
    80.156    -0.879     0.200
    80.176    -1.062     0.200
    80.149     0.130     0.200
    80.149    -0.277     0.200
    80.224     0.148     0.200
    80.239     0.067     0.200
    80.251    -0.803     0.200
    80.251    -0.116     0.200
    80.285     0.112     0.200
    80.383     0.073     0.200
    80.348    -0.274     0.200
    80.452     0.302     0.200
    80.452    -0.425     0.200
    80.472    -1.315     0.200
    80.568     0.543     0.200
    80.568    -0.258     0.200
    80.636     0.064     0.200
    80.611    -0.535     0.200
    80.645    -0.524     0.200
    80.645    -0.845     0.200
    80.743    -0.142     0.200
    80.746     0.022     0.200
    80.763    -0.966     0.200
    80.922     0.525     0.200
    80.971     0.020     0.200
    81.016     0.980     0.200
    81.016     0.171     0.200
    81.072    -1.215     0.200
    81.147     0.055     0.200
    81.191    -1.453     0.200
    81.378    -0.138     0.200
    81.418    -0.158     0.200
    81.438    -0.660     0.200
    81.792    -0.565     0.200
    81.979     0.718     0.200
    82.201    -1.093     0.200
    82.397    -0.192     0.200
    82.547    -0.225     0.200
    82.668    -1.172     0.200
    82.679    -0.288     0.200
    82.679    -0.945     0.200
    82.753    -1.337     0.200
    82.824    -1.344     0.200
    82.847    -0.064     0.200
    83.027    -0.684     0.200
    83.039    -0.622     0.200
    83.138    -0.821     0.200
    83.138    -1.231     0.200
    83.154    -1.042     0.200
    83.223    -1.095     0.200
    83.353    -0.691     0.200
    83.371    -1.931     0.200
    83.407    -0.696     0.200
    83.414     0.122     0.200
    83.422     0.276     0.200
    83.430    -1.233     0.200
    83.621    -1.645     0.200
    83.652    -0.096     0.200
    83.721    -0.657     0.200
    83.772    -0.760     0.200
    83.769    -0.562     0.200
    83.828    -1.105     0.200
    83.802    -0.166     0.200
    83.802    -0.381     0.200
    83.884    -1.195     0.200
    83.988     0.043     0.200
    84.068    -0.215     0.200
    84.081    -1.041     0.200
    84.100    -0.086     0.200
    84.159    -0.676     0.200
    84.207    -0.444     0.200
    84.205    -0.648     0.200
    84.210    -1.115     0.200
    84.472     0.116     0.200
    84.485    -0.296     0.200
    84.596    -0.310     0.200
    84.631    -1.073     0.200
    84.803    -0.526     0.200
    84.838    -1.343     0.200
    84.943    -0.777     0.200
    84.956    -0.570     0.200
    84.995    -1.004     0.200
    85.087    -0.645     0.200
    85.145    -0.572     0.200
    85.281    -1.237     0.200
    85.374    -0.228     0.200
    85.389    -0.690     0.200
    85.389    -0.108     0.200
    85.417    -1.155     0.200
    85.431    -0.572     0.200
    85.507    -0.203     0.200
    85.516    -0.672     0.200
    85.565    -0.975     0.200
    85.616    -0.266     0.200
    85.629    -0.740     0.200
    85.650    -1.263     0.200
    85.901    -0.332     0.200
    85.942    -0.696     0.200
    86.015    -0.933     0.200
    86.028     0.175     0.200
    86.065    -2.743     0.200
    86.125    -0.952     0.200
    86.142    -1.205     0.200
    86.277    -1.112     0.200
    86.315    -0.703     0.200
    86.349    -1.216     0.200
    86.349    -0.939     0.200
    86.361    -0.012     0.200
    86.465     0.562     0.200
    86.528    -0.831     0.200
    86.528    -0.601     0.200
    86.536     0.875     0.200
    86.615    -0.047     0.200
    86.627    -0.345     0.200
    86.631    -0.617     0.200
    86.700    -0.591     0.200
    86.717    -0.684     0.200
    86.724     0.180     0.200
    86.724     0.190     0.200
    86.725     0.406     0.200
    86.745    -1.010     0.200
    86.772    -0.988     0.200
    86.810    -0.779     0.200
    86.825    -0.184     0.200
    86.878    -0.395     0.200
    86.923    -0.800     0.200
    86.942    -0.218     0.200
    86.980    -0.936     0.200
    87.005    -0.922     0.200
    87.130    -0.426     0.200
    87.250    -0.216     0.200
    87.273    -0.640     0.200
    87.377    -0.353     0.200
    87.385    -0.627     0.200
    87.394    -0.279     0.200
    87.396    -1.080     0.200
    87.473    -0.917     0.200
    87.539    -0.810     0.200
    87.556     0.465     0.200
    87.597     0.302     0.200
    87.597    -0.839     0.200
    87.626    -1.149     0.200
    87.627     0.100     0.200
    87.635    -0.516     0.200
    87.657    -0.831     0.200
    87.690    -0.653     0.200
    87.692    -0.622     0.200
    87.736    -1.274     0.200
    87.777    -1.653     0.200
    87.815    -1.582     0.200
    87.826    -0.988     0.200
    87.854    -0.921     0.200
    87.922    -1.112     0.200
    87.924     0.189     0.200
    87.928    -1.129     0.200
    88.012    -0.310     0.200
    88.010     0.122     0.200
    88.020    -0.223     0.200
    88.027    -0.287     0.200
    88.078    -0.122     0.200
    88.078     0.835     0.200
    88.099    -0.617     0.200
    88.120    -0.150     0.200
    88.167    -0.330     0.200
    88.167    -1.705     0.200
    88.176    -0.302     0.200
    88.210    -0.581     0.200
    88.206     0.222     0.200
    88.216     0.825     0.200
    88.216     0.434     0.200
    88.260     0.118     0.200
    88.257    -1.251     0.200
    88.274     0.324     0.200
    88.279    -0.946     0.200
    88.280     0.249     0.200
    88.295    -0.992     0.200
    88.348    -0.242     0.200
    88.372    -0.288     0.200
    88.371    -0.388     0.200
    88.432    -0.409     0.200
    88.432    -1.175     0.200
    88.445     0.113     0.200
    88.450     0.537     0.200
    88.453     0.562     0.200
    88.474     0.088     0.200
    88.483     0.523     0.200
    88.495    -0.018     0.200
    88.529     0.508     0.200
    88.601    -0.038     0.200
    88.608     0.184     0.200
    88.608    -1.727     0.200
    88.627     0.247     0.200
    88.632     0.882     0.200
    88.678    -0.279     0.200
    88.712    -0.211     0.200
    88.789     0.171     0.200
    88.791     0.267     0.200
    88.823     0.088     0.200
    88.830    -0.684     0.200
    88.885     0.454     0.200
    88.885    -1.190     0.200
    88.948     0.422     0.200
    88.960     0.444     0.200
    88.985     0.148     0.200
    88.991     0.962     0.200
    89.089     0.885     0.200
    89.089    -0.947     0.200
    89.105     0.568     0.200
    89.158     1.292     0.200
    89.315     0.052     0.200
    89.424    -0.342     0.200
    89.445     0.270     0.200
    89.484    -0.426     0.200
    89.489     0.903     0.200
    89.539    -0.929     0.200
    89.555    -0.612     0.200
    89.561     1.621     0.200
    89.629     1.288     0.200
    89.646     0.674     0.200
    89.655     0.897     0.200
    89.669    -0.362     0.200
    89.682    -0.093     0.200
    89.701    -0.619     0.200
    89.783     0.227     0.200
    89.838     0.605     0.200
    89.851    -0.301     0.200
    89.870     0.554     0.200
    89.877     0.237     0.200
    89.897    -1.754     0.200
    89.863    -0.624     0.200
    89.918    -0.057     0.200
    89.980     1.024     0.200
    90.028    -0.233     0.200
    90.065     1.289     0.200
    90.069    -0.198     0.200
    90.118     0.309     0.200
    90.190     0.780     0.200
    90.190    -0.759     0.200
    90.223    -0.241     0.200
    90.304    -0.408     0.200
    90.315     0.681     0.200
    90.323    -0.096     0.200
    90.336     0.951     0.200
    90.446    -0.846     0.200
    90.469     0.652     0.200
    90.489    -0.273     0.200
    90.586     0.136     0.200
    90.629     0.559     0.200
    90.722     0.595     0.200
    90.803     1.077     0.200
    90.810     1.391     0.200
    90.824     0.412     0.200
    90.958     0.906     0.200
    90.961     1.719     0.200
    91.062     0.614     0.200
    91.075    -0.107     0.200
    91.196    -0.523     0.200
    91.190    -0.421     0.200
    91.237     1.094     0.200
    91.261     0.219     0.200
    91.357     0.975     0.200
    91.478    -2.099     0.200
    91.559     0.697     0.200
    91.603     0.894     0.200
    91.667     0.642     0.200
    91.768    -1.283     0.200
    91.827     0.120     0.200
    91.858    -0.516     0.200
    91.889     0.295     0.200
    91.925    -0.827     0.200
    91.976     0.270     0.200
    92.200     0.292     0.200
    92.254     0.312     0.200
    92.288    -0.299     0.200
    92.406     0.598     0.200
    92.529    -0.287     0.200
    92.617    -0.707     0.200
    92.749     0.704     0.200
    92.851     0.655     0.200
    92.992     0.668     0.200
    93.008    -0.043     0.200
    93.295     0.678     0.200
    93.329     0.272     0.200
    93.391     1.116     0.200
    93.636     0.669     0.200
    93.768     1.102     0.200
    93.999    -0.825     0.200
    94.132     0.343     0.200
    94.266     1.056     0.200
    21.355    -2.036     0.200
    21.796    -2.504     0.200
    23.563     0.078     0.200
    25.874    -0.639     0.200
    26.318     0.033     0.200
    26.318    -1.007     0.200
    28.659     0.311     0.200
    30.842     0.593     0.200
    32.599     0.461     0.200
    33.291    -1.771     0.200
    33.677     1.170     0.200
    37.293     0.551     0.200
    38.573     0.665     0.200
    39.501    -0.514     0.200
    39.501    -0.559     0.200
    39.501    -0.184     0.200
    39.848     0.633     0.200
    42.609    -0.318     0.200
    42.609    -0.168     0.200
    42.609    -0.398     0.200
    42.811    -0.751     0.200
    43.862    -0.424     0.200
    44.022     0.701     0.200
    44.260     0.502     0.200
    44.260     0.694     0.200
    44.381    -0.169     0.200
    47.397    -0.635     0.200
    48.099     0.545     0.200
    48.152    -0.667     0.200
    48.152    -1.047     0.200
    48.616     0.869     0.200
    48.844     0.821     0.200
    49.117    -0.701     0.200
    49.336     2.035     0.200
    49.437     0.987     0.200
    49.595     4.085     0.200
    49.871     0.587     0.200
    50.142     0.431     0.200
    51.308     2.114     0.200
    51.732    -0.900     0.200
    51.732    -1.100     0.200
    53.340    -0.996     0.200
    53.340    -1.786     0.200
    55.615    -0.347     0.200
    56.870    -0.231     0.200
    57.085    -2.354     0.200
    59.523    -1.130     0.200
    60.016    -2.644     0.200
    62.484    -0.126     0.200
    62.484    -0.326     0.200
    62.478    -0.285     0.200
    64.666    -2.111     0.200
    64.757    -1.424     0.200
    64.757    -1.299     0.200
    66.205     0.394     0.200
    68.453     1.039     0.200
    68.453     0.029     0.200
    68.474     0.310     0.200
    68.474     0.609     0.200
    69.813    -1.279     0.200
    69.813    -1.154     0.200
    70.846     1.365     0.200
    70.919    -0.754     0.200
    70.919    -1.129     0.200
    70.919    -1.029     0.200
    70.919    -0.719     0.200
    73.082     0.466     0.200
    74.953    -0.035     0.200
    74.966    -0.374     0.200
    75.350    -0.267     0.200
    75.368     0.026     0.200
    76.317     0.067     0.200
    76.630    -0.052     0.200
    76.658     0.193     0.200
    76.662     0.171     0.200
    76.698     0.063     0.200
    77.148    -0.662     0.200
    77.640    -0.415     0.200
    77.655     0.103     0.200
    78.094    -0.433     0.200
    78.703     0.304     0.200
    78.703     0.004     0.200
    78.888    -0.235     0.200
    78.888    -0.660     0.200
    80.113     0.335     0.200
    80.446     0.138     0.200
    80.714    -0.561     0.200
    80.942     0.066     0.200
    80.979     0.149     0.200
    81.115    -0.197     0.200
    81.126    -0.357     0.200
    81.623     0.195     0.200
    81.650    -0.465     0.200
    85.903     1.188     0.200
    93.081    -0.210     0.200
    17.440     1.498     0.200
    20.891    -1.781     0.200
    20.891    -1.578     0.200
    24.290    -1.808     0.200
    26.443    -0.333     0.200
    26.887     0.130     0.200
    28.758     0.462     0.200
    31.604     2.320     0.200
    38.119     1.494     0.200
    39.073     0.094     0.200
    39.915    -0.382     0.200
    39.915    -0.186     0.200
    40.447     0.787     0.200
    40.791    -0.654     0.200
    41.303    -0.555     0.200
    43.144    -0.407     0.200
    43.144    -0.532     0.200
    43.144    -0.993     0.200
    43.255    -1.236     0.200
    43.344    -0.851     0.200
    43.603    -0.584     0.200
    43.673    -0.150     0.200
    43.673    -0.971     0.200
    44.321    -0.794     0.200
    44.321    -0.435     0.200
    45.093     1.313     0.200
    45.093     1.867     0.200
    46.124     0.591     0.200
    48.460     0.109     0.200
    48.460    -0.438     0.200
    53.639    -0.703     0.200
    56.025    -0.380     0.200
    57.476    -0.635     0.200
    59.501    -0.964     0.200
    62.925     0.406     0.200
    62.925    -0.297     0.200
    63.020    -0.627     0.200
    63.020    -1.416     0.200
    64.837    -0.735     0.200
    64.837    -0.900     0.200
    64.880    -1.342     0.200
    66.651     0.110     0.200
    67.976    -0.694     0.200
    68.833     1.028     0.200
    68.833     0.684     0.200
    68.857     0.930     0.200
    69.313     1.149     0.200
    69.611    -1.127     0.200
    69.617    -1.129     0.200
    69.744    -0.862     0.200
    69.782    -0.987     0.200
    69.812    -1.025     0.200
    69.812    -0.743     0.200
    69.941    -0.694     0.200
    70.029     1.193     0.200
    71.138    -0.732     0.200
    72.104    -0.013     0.200
    72.296     0.937     0.200
    72.296     0.484     0.200
    76.678     0.217     0.200
    77.245    -0.762     0.200
    77.760    -0.446     0.200
    78.823    -0.217     0.200
    79.012    -0.474     0.200
    79.012    -0.779     0.200
    82.151     0.278     0.200
    84.203    -0.919     0.200
    84.647    -0.526     0.200
    84.718    -1.092     0.200
    86.555    -0.280     0.200
    88.872    -0.224     0.200
    89.020    -0.189     0.200
    93.109     0.164     0.200
    16.390     2.009     0.200
    20.042    -1.867     0.200
    20.053    -1.796     0.200
    20.743    -2.366     0.200
    20.764     0.707     0.200
    20.764    -2.332     0.200
    20.965    -0.590     0.200
    21.679    -1.935     0.200
    23.210     0.215     0.200
    23.454    -1.876     0.200
    24.441    -1.690     0.200
    25.407    -1.790     0.200
    25.851    -0.478     0.200
    25.851    -1.228     0.200
    26.142    -2.380     0.200
    26.815    -0.522     0.200
    27.710    -1.731     0.200
    27.858    -1.157     0.200
    28.670    -1.591     0.200
    29.319     0.544     0.200
    30.531    -0.174     0.200
    32.226     0.608     0.200
    36.440     0.917     0.200
    37.118     0.751     0.200
    38.077     1.348     0.200
    38.755    -0.394     0.200
    38.978    -0.688     0.200
    38.978    -0.469     0.200
    38.978    -0.821     0.200
    39.397     0.974     0.200
    40.222    -0.386     0.200
    40.453     0.233     0.200
    41.266    -0.682     0.200
    42.008    -0.206     0.200
    41.973     0.558     0.200
    42.127    -0.035     0.200
    42.127     0.144     0.200
    42.283    -0.901     0.200
    42.328    -0.173     0.200
    42.452     0.040     0.200
    42.509    -0.023     0.200
    42.704    -0.548     0.200
    42.704    -1.071     0.200
    42.741    -0.794     0.200
    42.800    -0.353     0.200
    42.886     0.007     0.200
    42.940     0.357     0.200
    42.953    -0.689     0.200
    43.114     0.358     0.200
    43.257    -0.093     0.200
    43.352    -0.170     0.200
    43.352    -0.475     0.200
    43.381    -0.800     0.200
    43.446    -0.734     0.200
    43.588    -0.823     0.200
    43.590    -0.505     0.200
    43.688    -0.515     0.200
    43.753     0.066     0.200
    43.757    -0.431     0.200
    43.796    -0.960     0.200
    43.883    -0.145     0.200
    43.914     0.338     0.200
    44.043     0.278     0.200
    44.125     0.134     0.200
    44.125     1.118     0.200
    44.125     0.540     0.200
    44.148    -0.493     0.200
    44.177    -0.645     0.200
    44.177    -0.653     0.200
    44.187    -0.903     0.200
    44.187    -0.551     0.200
    44.717     1.684     0.200
    44.705    -0.826     0.200
    44.830    -0.130     0.200
    44.871    -0.663     0.200
    45.048    -0.181     0.200
    45.278     0.616     0.200
    45.528    -0.548     0.200
    45.553     0.111     0.200
    45.817     0.321     0.200
    46.266     0.097     0.200
    46.350     0.213     0.200
    46.464     1.172     0.200
    46.437     0.091     0.200
    46.607    -0.867     0.200
    46.660     0.105     0.200
    46.877     0.977     0.200
    46.995     1.876     0.200
    47.328     0.421     0.200
    47.574     0.165     0.200
    47.625     0.619     0.200
    47.625    -0.045     0.200
    47.701     1.225     0.200
    47.796     0.984     0.200
    48.097     0.010     0.200
    48.097    -0.482     0.200
    48.325     0.498     0.200
    48.527     0.545     0.200
    48.653    -0.326     0.200
    48.805     0.045     0.200
    49.171     0.609     0.200
    49.811     0.826     0.200
    50.297     0.328     0.200
    50.583    -0.379     0.200
    50.803     1.016     0.200
    50.803     0.914     0.200
    51.251    -0.547     0.200
    51.251    -1.047     0.200
    51.583     0.868     0.200
    51.830    -1.010     0.200
    51.995     0.985     0.200
    52.665     0.246     0.200
    52.796     0.126     0.200
    52.796    -0.038     0.200
    53.275    -0.131     0.200
    53.911     0.359     0.200
    54.232     0.054     0.200
    54.358    -1.421     0.200
    55.092    -0.351     0.200
    55.660    -1.272     0.200
    56.318     0.070     0.200
    56.415    -0.493     0.200
    56.531    -1.423     0.200
    56.797    -1.810     0.200
    57.299    -0.659     0.200
    57.675     0.335     0.200
    58.383    -0.371     0.200
    58.980    -1.376     0.200
    58.980    -1.704     0.200
    59.462    -2.958     0.200
    59.462    -2.856     0.200
    59.567    -0.085     0.200
    61.208    -0.354     0.200
    62.003     0.125     0.200
    62.003    -0.281     0.200
    62.584     0.168     0.200
    62.647     0.645     0.200
    62.709    -0.110     0.200
    62.691     0.676     0.200
    62.887     0.258     0.200
    62.888    -0.039     0.200
    62.888    -0.281     0.200
    63.399     1.165     0.200
    64.021    -1.155     0.200
    64.114    -1.459     0.200
    64.203    -1.498     0.200
    64.205    -1.507     0.200
    64.415     1.180     0.200
    64.475     1.079     0.200
    64.564     1.527     0.200
    64.558    -1.569     0.200
    64.598     1.010     0.200
    64.701    -0.118     0.200
    64.873     1.096     0.200
    64.935    -0.130     0.200
    64.935    -0.684     0.200
    64.994     0.856     0.200
    65.092     0.910     0.200
    65.273     0.739     0.200
    65.292     0.358     0.200
    65.387     0.370     0.200
    65.394     0.937     0.200
    65.384    -0.835     0.200
    65.402    -0.013     0.200
    65.596     1.380     0.200
    65.892     0.384     0.200
    65.950     0.723     0.200
    66.016    -1.403     0.200
    66.082     1.372     0.200
    66.088     1.092     0.200
    66.136     1.141     0.200
    66.252     1.479     0.200
    66.493     1.130     0.200
    66.615    -0.093     0.200
    66.577    -0.617     0.200
    66.592     1.351     0.200
    66.603    -0.072     0.200
    66.627     1.325     0.200
    67.021     1.330     0.200
    67.040    -0.053     0.200
    67.208     0.441     0.200
    67.375     0.222     0.200
    67.550     0.496     0.200
    67.923     0.366     0.200
    67.944     0.528     0.200
    67.944     0.832     0.200
    67.953     0.378     0.200
    67.968     0.290     0.200
    68.115    -0.136     0.200
    68.120     0.232     0.200
    68.186    -0.083     0.200
    68.277     0.053     0.200
    68.394    -0.406     0.200
    69.050     0.325     0.200
    69.065    -1.610     0.200
    69.105    -0.157     0.200
    69.155     0.167     0.200
    69.182    -0.806     0.200
    69.268    -1.424     0.200
    69.268    -1.252     0.200
    69.589    -0.644     0.200
    69.802     0.877     0.200
    69.811     0.125     0.200
    69.989     0.324     0.200
    69.989     0.629     0.200
    70.367    -1.160     0.200
    70.367    -0.684     0.200
    70.558     0.347     0.200
    70.831     1.114     0.200
    70.831     0.387     0.200
    70.890     0.412     0.200
    70.937     0.015     0.200
    71.039     0.087     0.200
    71.548     0.899     0.200
    71.548     0.360     0.200
    72.161     1.245     0.200
    72.243     0.682     0.200
    72.321     0.843     0.200
    72.513     0.655     0.200
    72.854     0.648     0.200
    72.910     0.309     0.200
    72.910     1.043     0.200
    72.972     0.813     0.200
    72.989     0.505     0.200
    72.989    -0.090     0.200
    72.989     0.441     0.200
    72.989     0.058     0.200
    73.030     0.749     0.200
    73.293    -0.198     0.200
    73.307     0.732     0.200
    73.769     0.898     0.200
    73.935     0.847     0.200
    73.980    -0.087     0.200
    74.035    -0.306     0.200
    74.193    -1.377     0.200
    74.370     0.819     0.200
    74.401    -0.346     0.200
    74.415     0.035     0.200
    74.415    -0.739     0.200
    74.815     0.767     0.200
    74.930    -0.702     0.200
    74.930     0.126     0.200
    74.986     0.227     0.200
    75.097    -0.968     0.200
    75.097     0.407     0.200
    75.126     0.659     0.200
    75.502     0.671     0.200
    75.517     0.527     0.200
    75.549     0.838     0.200
    75.548     0.597     0.200
    75.597     0.659     0.200
    75.783    -0.200     0.200
    75.783    -0.100     0.200
    75.783    -0.702     0.200
    75.954     0.298     0.200
    76.068     0.778     0.200
    76.076     0.262     0.200
    76.076    -0.426     0.200
    76.231     0.676     0.200
    76.348     0.365     0.200
    76.487     0.735     0.200
    76.548     0.848     0.200
    76.595    -0.617     0.200
    76.595    -0.812     0.200
    76.826     0.881     0.200
    76.826     0.279     0.200
    76.910     1.047     0.200
    76.910    -0.492     0.200
    77.086    -0.084     0.200
    77.101    -0.267     0.200
    77.186     0.457     0.200
    77.186     0.980     0.200
    77.186    -0.275     0.200
    77.186    -0.650     0.200
    77.410     0.975     0.200
    77.798    -0.662     0.200
    77.976     0.996     0.200
    78.035     0.678     0.200
    78.153     1.093     0.200
    78.150    -0.015     0.200
    78.150     0.587     0.200
    78.478     0.613     0.200
    78.572    -0.606     0.200
    78.714     0.760     0.200
    78.827    -0.365     0.200
    78.836    -1.231     0.200
    79.477     0.196     0.200
    79.477     1.039     0.200
    79.549    -0.623     0.200
    79.752     0.668     0.200
    79.752     0.231     0.200
    80.178     0.093     0.200
    80.178     0.976     0.200
    80.178     0.609     0.200
    80.271    -0.807     0.200
    80.561     0.213     0.200
    80.572    -0.056     0.200
    80.625     0.085     0.200
    80.648     0.662     0.200
    81.070     0.068     0.200
    81.122     1.376     0.200
    81.305    -1.640     0.200
    81.483    -0.181     0.200
    81.580    -1.326     0.200
    81.784    -1.198     0.200
    82.126    -0.949     0.200
    82.153    -1.063     0.200
    82.229    -1.096     0.200
    82.809    -2.147     0.200
    83.137     0.691     0.200
    83.636    -0.868     0.200
    83.910    -1.153     0.200
    84.263    -1.318     0.200
    84.372    -0.954     0.200
    84.403    -1.158     0.200
    84.506    -1.484     0.200
    84.589     0.093     0.200
    84.599    -0.570     0.200
    84.673    -0.490     0.200
    84.673    -0.693     0.200
    84.891    -0.613     0.200
    84.963    -0.922     0.200
    84.980    -0.748     0.200
    85.175    -1.176     0.200
    85.254     0.084     0.200
    85.323    -0.198     0.200
    85.356    -0.603     0.200
    85.531    -0.869     0.200
    85.568    -1.213     0.200
    85.586    -0.664     0.200
    85.655    -0.742     0.200
    85.778    -0.453     0.200
    85.786    -1.170     0.200
    85.797    -0.672     0.200
    85.846    -1.354     0.200
    85.869     0.071     0.200
    85.870     0.887     0.200
    85.870     0.067     0.200
    85.899    -0.372     0.200
    85.958    -0.679     0.200
    86.029    -1.107     0.200
    86.032    -0.827     0.200
    86.156    -1.096     0.200
    86.203    -1.022     0.200
    86.264    -0.854     0.200
    86.358    -0.505     0.200
    86.377    -0.410     0.200
    86.502    -0.858     0.200
    86.547    -0.799     0.200
    86.705    -1.245     0.200
    86.831    -0.054     0.200
    86.849    -0.955     0.200
    86.919    -0.651     0.200
    86.944    -0.613     0.200
    86.978    -0.900     0.200
    87.016    -0.550     0.200
    87.044    -0.885     0.200
    87.105    -1.265     0.200
    87.134    -0.656     0.200
    87.137    -0.318     0.200
    87.161    -0.277     0.200
    87.267    -0.916     0.200
    87.276    -0.837     0.200
    87.308    -0.427     0.200
    87.326    -0.900     0.200
    87.448     0.006     0.200
    87.489     0.395     0.200
    87.508    -0.971     0.200
    87.615    -0.521     0.200
    87.615    -0.701     0.200
    87.721    -0.922     0.200
    87.723    -0.625     0.200
    87.789    -0.940     0.200
    87.810    -0.242     0.200
    87.841    -0.703     0.200
    87.868    -0.158     0.200
    87.860    -0.978     0.200
    87.865    -1.020     0.200
    87.884    -0.929     0.200
    87.906    -0.128     0.200
    87.915    -0.741     0.200
    87.929    -0.599     0.200
    87.972    -0.386     0.200
    87.970    -0.650     0.200
    88.026    -0.480     0.200
    88.132    -0.606     0.200
    88.162    -0.168     0.200
    88.175    -0.199     0.200
    88.177    -0.139     0.200
    88.184    -0.118     0.200
    88.222    -0.074     0.200
    88.305    -0.169     0.200
    88.337    -0.160     0.200
    88.376    -0.360     0.200
    88.386    -0.505     0.200
    88.492    -0.251     0.200
    88.561    -0.048     0.200
    88.687     0.147     0.200
    88.695    -0.130     0.200
    88.702    -0.069     0.200
    88.830     0.074     0.200
    88.845    -0.183     0.200
    88.882    -0.154     0.200
    88.890    -0.191     0.200
    88.950    -0.353     0.200
    88.987    -0.569     0.200
    88.996    -0.092     0.200
    89.074    -0.158     0.200
    89.087    -0.052     0.200
    89.142     0.234     0.200
    89.226    -0.134     0.200
    89.243    -0.182     0.200
    89.292    -0.553     0.200
    89.298    -0.736     0.200
    89.298    -0.111     0.200
    89.332     0.125     0.200
    89.375     0.105     0.200
    89.468    -0.079     0.200
    89.483     0.381     0.200
    89.543     0.101     0.200
    89.654    -0.454     0.200
    89.731     0.048     0.200
    89.828    -0.092     0.200
    89.862    -0.011     0.200
    90.026    -0.034     0.200
    90.057    -0.286     0.200
    90.122    -0.530     0.200
    90.133    -0.104     0.200
    90.171    -0.381     0.200
    90.417    -0.261     0.200
    90.448    -0.131     0.200
    90.506    -0.068     0.200
    90.527    -0.518     0.200
    90.718    -0.343     0.200
    90.894    -0.098     0.200
    91.169    -0.171     0.200
    91.255    -0.196     0.200
    91.338    -0.359     0.200
    91.590    -0.687     0.200
    92.342     0.031     0.200
    92.412    -0.057     0.200
    92.638    -0.679     0.200
    92.704     0.197     0.200
    93.087    -0.562     0.200
    39.116     0.340     0.200
    42.219    -0.084     0.200
    44.425     0.158     0.200
    49.122    -0.217     0.200
    62.608     0.177     0.200
    14.765     3.443     0.200
    19.400    -0.441     0.200
    21.001    -1.132     0.200
    21.314    -0.681     0.200
    21.314    -1.007     0.200
    22.588     0.187     0.200
    24.903     0.174     0.200
    25.346     0.824     0.200
    25.346     0.143     0.200
    27.239    -0.055     0.200
    29.886     1.187     0.200
    32.381    -0.494     0.200
    37.623     0.822     0.200
    38.591    -1.705     0.200
    38.591     0.065     0.200
    38.591    -0.965     0.200
    38.868     1.643     0.200
    38.868     0.244     0.200
    41.647    -0.067     0.200
    41.647    -0.393     0.200
    41.647     0.232     0.200
    41.800    -1.542     0.200
    42.893    -0.623     0.200
    42.913     0.466     0.200
    42.930    -0.722     0.200
    42.930    -0.122     0.200
    43.068     0.222     0.200
    43.337    -1.027     0.200
    43.338    -0.496     0.200
    43.360    -1.134     0.200
    43.446     0.465     0.200
    43.446     0.184     0.200
    43.457    -0.548     0.200
    43.480    -0.399     0.200
    44.164    -0.155     0.200
    44.237     0.228     0.200
    44.302     0.737     0.200
    44.343    -0.429     0.200
    44.434    -0.184     0.200
    44.710    -0.121     0.200
    44.723     0.227     0.200
    44.723    -0.073     0.200
    44.723    -0.543     0.200
    44.736    -0.750     0.200
    44.905     0.721     0.200
    45.388    -0.050     0.200
    45.400     0.751     0.200
    45.624     0.300     0.200
    46.105     0.927     0.200
    46.225     0.750     0.200
    46.615     0.624     0.200
    46.842     0.105     0.200
    46.899    -0.114     0.200
    47.011     1.593     0.200
    47.148     0.558     0.200
    47.148     0.759     0.200
    47.149    -0.610     0.200
    47.219    -0.345     0.200
    47.253    -0.061     0.200
    47.243     0.286     0.200
    47.409    -0.025     0.200
    47.514     0.049     0.200
    47.657     0.100     0.200
    47.682     0.102     0.200
    47.688     0.356     0.200
    47.727     0.443     0.200
    47.885     0.231     0.200
    47.905     0.627     0.200
    48.014     0.328     0.200
    48.303    -0.703     0.200
    48.472     0.997     0.200
    48.908     0.446     0.200
    49.177     0.688     0.200
    49.361    -0.799     0.200
    49.361    -0.224     0.200
    49.744     1.217     0.200
    50.767    -0.484     0.200
    51.020     1.212     0.200
    52.308    -0.524     0.200
    52.754    -0.801     0.200
    54.144     0.764     0.200
    54.144     1.219     0.200
    54.707    -0.043     0.200
    56.075    -0.550     0.200
    57.172    -0.971     0.200
    57.172    -1.545     0.200
    58.904    -0.755     0.200
    58.939    -0.674     0.200
    62.407    -1.215     0.200
    62.585    -0.954     0.200
    62.586    -1.467     0.200
    62.586    -0.741     0.200
    63.729    -1.019     0.200
    64.078    -0.830     0.200
    64.080    -1.279     0.200
    64.080    -0.930     0.200
    64.344     0.240     0.200
    64.681     0.096     0.200
    65.011     0.685     0.200
    65.148    -0.306     0.200
    65.999     0.502     0.200
    66.025     0.451     0.200
    66.115     1.027     0.200
    66.313    -1.018     0.200
    66.514    -0.279     0.200
    66.588     0.957     0.200
    66.784     0.279     0.200
    67.260     0.902     0.200
    67.560     1.056     0.200
    67.815     0.345     0.200
    68.001    -0.524     0.200
    68.024    -0.490     0.200
    68.097    -0.718     0.200
    68.212    -0.497     0.200
    68.271    -1.210     0.200
    68.576    -0.062     0.200
    69.002    -1.039     0.200
    69.208    -1.352     0.200
    69.208    -1.216     0.200
    69.335    -0.212     0.200
    70.130    -1.310     0.200
    70.130    -0.535     0.200
    70.130    -1.636     0.200
    70.241     0.223     0.200
    70.426     0.202     0.200
    70.465     0.713     0.200
    70.599     0.196     0.200
    70.748     0.731     0.200
    71.206     0.513     0.200
    71.331     1.699     0.200
    71.481     0.550     0.200
    71.481     0.171     0.200
    73.157     0.123     0.200
    73.605     0.126     0.200
    73.605     0.155     0.200
    73.605    -0.345     0.200
    73.605    -1.026     0.200
    73.680     0.466     0.200
    74.160    -0.465     0.200
    74.174    -0.764     0.200
    74.625    -0.166     0.200
    74.625    -0.746     0.200
    74.732     0.010     0.200
    74.732    -1.266     0.200
    74.999     1.570     0.200
    75.040     1.353     0.200
    75.206     0.377     0.200
    75.341     0.471     0.200
    75.355     1.070     0.200
    75.525    -0.133     0.200
    75.576     0.472     0.200
    75.897     0.641     0.200
    75.940    -0.006     0.200
    76.454    -1.225     0.200
    76.649     0.468     0.200
    76.923     0.322     0.200
    76.927     0.003     0.200
    76.985    -0.067     0.200
    77.114     0.368     0.200
    77.990    -0.142     0.200
    78.172    -0.451     0.200
    78.331    -0.991     0.200
    78.714    -0.168     0.200
    79.337     0.315     0.200
    79.373     0.023     0.200
    79.398    -0.618     0.200
    79.740     0.726     0.200
    80.265     0.330     0.200
    80.342    -0.426     0.200
    80.405    -0.007     0.200
    80.419    -0.256     0.200
    80.812     1.079     0.200
    80.856    -0.381     0.200
    80.922    -0.353     0.200
    81.328     0.723     0.200
    83.446    -0.654     0.200
    83.584    -1.184     0.200
    86.512     0.638     0.200
    86.513     0.658     0.200
    86.513     0.726     0.200
    86.513    -0.615     0.200
    92.445    -0.365     0.200
    21.299    -1.531     0.200
    25.354     0.681     0.200
    38.595    -0.760     0.200
    41.654    -0.269     0.200
    42.875    -0.875     0.200
    43.463     2.211     0.200
    44.116     0.881     0.200
    44.705    -0.468     0.200
    44.705    -1.444     0.200
    46.083    -0.698     0.200
    46.120     0.076     0.200
    47.131    -1.249     0.200
    49.727     0.687     0.200
    54.126     0.533     0.200
    54.711    -0.343     0.200
    57.157    -1.328     0.200
    57.157    -0.934     0.200
    58.887    -0.948     0.200
    61.528    -0.468     0.200
    62.333     0.567     0.200
    62.420    -1.128     0.200
    62.596    -1.348     0.200
    62.598    -0.855     0.200
    62.599    -0.968     0.200
    64.076    -0.992     0.200
    66.327    -0.363     0.200
    67.582    -0.193     0.200
    69.202    -1.380     0.200
    69.202    -1.278     0.200
    70.129    -1.343     0.200
    73.587    -0.446     0.200
    74.102    -0.209     0.200
    78.169     0.106     0.200
    86.495    -0.317     0.200
    21.387    -2.449     0.200
    26.240     0.421     0.200
    28.106    -0.324     0.200
    39.436    -0.426     0.200
    39.436    -0.223     0.200
    42.533     0.004     0.200
    42.533     0.027     0.200
    42.533    -0.707     0.200
    42.735    -0.030     0.200
    44.167     1.140     0.200
    55.551    -0.246     0.200
    55.551    -0.348     0.200
    62.449    -0.188     0.200
    64.724    -1.131     0.200
    64.725    -1.250     0.200
    65.412     0.097     0.200
    69.781    -1.406     0.200
    21.410    -2.719     0.200
    26.282    -0.071     0.200
    39.480    -0.285     0.200
    42.576    -0.122     0.200
    43.781     2.660     0.200
    43.893     1.758     0.200
    43.946     1.334     0.200
    44.041     0.573     0.200
    44.202     0.089     0.200
    44.203    -0.415     0.200
    44.203    -0.718     0.200
    44.225    -0.546     0.200
    44.239    -0.154     0.200
    57.220    -1.781     0.200
    58.684    -0.922     0.200
    59.542    -0.555     0.200
    62.425    -0.515     0.200
    64.767    -1.386     0.200
    16.267     3.951     0.200
    17.976    -1.494     0.200
    17.976    -1.361     0.200
    19.407     0.249     0.200
    19.977    -1.453     0.200
    20.595    -1.837     0.200
    21.158    -0.800     0.200
    21.408    -2.074     0.200
    21.408    -1.777     0.200
    21.448     0.400     0.200
    23.180     0.191     0.200
    23.740    -1.727     0.200
    25.462     1.100     0.200
    25.516     0.216     0.200
    25.959    -0.001     0.200
    27.841     0.770     0.200
    27.841    -0.402     0.200
    29.489     1.165     0.200
    30.146     1.055     0.200
    30.460     0.482     0.200
    32.218     1.116     0.200
    32.915     0.022     0.200
    33.318     0.405     0.200
    36.154    -1.352     0.200
    38.398     0.017     0.200
    38.527     1.232     0.200
    38.893    -0.922     0.200
    38.893    -1.891     0.200
    39.124    -0.215     0.200
    39.182    -0.030     0.200
    39.182    -0.303     0.200
    39.182    -0.537     0.200
    39.482     2.094     0.200
    39.645    -0.896     0.200
    40.387    -0.295     0.200
    40.613     1.122     0.200
    40.613     0.185     0.200
    40.834     1.051     0.200
    41.245    -0.747     0.200
    41.399    -0.038     0.200
    42.258    -0.340     0.200
    42.258     0.058     0.200
    42.258    -0.168     0.200
    42.258    -0.387     0.200
    42.344    -1.472     0.200
    42.344    -0.519     0.200
    42.459    -0.277     0.200
    42.643    -0.746     0.200
    42.725    -0.710     0.200
    42.850    -0.580     0.200
    42.862     2.261     0.200
    42.923     0.218     0.200
    43.116    -0.432     0.200
    43.142     0.292     0.200
    43.142     0.057     0.200
    43.194    -0.026     0.200
    43.374    -0.956     0.200
    43.371    -0.992     0.200
    43.502    -0.803     0.200
    43.531     0.468     0.200
    43.610    -0.223     0.200
    43.668     1.061     0.200
    43.657    -0.476     0.200
    43.665    -0.411     0.200
    43.777    -0.268     0.200
    43.841    -0.523     0.200
    43.907     1.141     0.200
    43.907     0.047     0.200
    43.897    -0.402     0.200
    43.932    -0.205     0.200
    44.003    -1.189     0.200
    44.154    -0.379     0.200
    44.159     0.530     0.200
    44.159    -0.189     0.200
    44.240    -0.767     0.200
    44.248    -0.522     0.200
    44.317     0.562     0.200
    44.317    -0.610     0.200
    44.579    -0.727     0.200
    44.587    -1.189     0.200
    44.718     0.162     0.200
    44.970    -0.450     0.200
    45.104    -0.594     0.200
    45.081    -0.572     0.200
    45.218    -0.440     0.200
    45.063    -0.670     0.200
    45.400    -0.372     0.200
    45.415     1.235     0.200
    45.415    -0.211     0.200
    45.434    -0.004     0.200
    45.634    -0.187     0.200
    45.766    -0.635     0.200
    45.927    -0.886     0.200
    46.038     0.106     0.200
    46.038    -0.128     0.200
    46.106    -0.885     0.200
    46.153    -0.145     0.200
    46.452     0.179     0.200
    46.675    -0.469     0.200
    46.673     0.746     0.200
    46.749    -0.710     0.200
    46.823     0.153     0.200
    46.986    -0.721     0.200
    47.010    -0.580     0.200
    47.046     1.394     0.200
    47.012    -0.225     0.200
    47.103    -0.437     0.200
    47.181     0.884     0.200
    47.183    -1.108     0.200
    47.386    -0.638     0.200
    47.717     0.625     0.200
    47.710    -0.056     0.200
    47.723     0.985     0.200
    47.788    -0.640     0.200
    47.839    -0.415     0.200
    47.839    -0.111     0.200
    48.060     0.849     0.200
    48.233     0.945     0.200
    48.257     0.454     0.200
    48.263     0.314     0.200
    48.264    -0.978     0.200
    48.461     0.691     0.200
    48.593     0.370     0.200
    48.603     0.626     0.200
    48.658     0.136     0.200
    48.917     0.107     0.200
    48.917     0.271     0.200
    48.917    -0.706     0.200
    49.227     3.818     0.200
    49.281    -0.612     0.200
    49.389     0.195     0.200
    49.666     0.969     0.200
    51.379    -0.636     0.200
    51.844     0.292     0.200
    52.116    -0.336     0.200
    53.057    -0.878     0.200
    53.057    -0.777     0.200
    53.603    -0.519     0.200
    53.945     0.537     0.200
    53.950     0.685     0.200
    55.297    -0.174     0.200
    55.297    -0.252     0.200
    55.495    -0.940     0.200
    55.495    -0.799     0.200
    55.879    -0.551     0.200
    56.029     1.117     0.200
    56.110     0.300     0.200
    56.477    -0.609     0.200
    56.609    -0.550     0.200
    56.739     0.086     0.200
    56.847    -1.934     0.200
    57.238    -1.303     0.200
    57.372     0.773     0.200
    58.069     0.369     0.200
    58.795    -1.009     0.200
    58.795     0.014     0.200
    59.359    -0.965     0.200
    59.783    -2.510     0.200
    60.313    -0.531     0.200
    60.560    -1.618     0.200
    60.582    -1.269     0.200
    60.677    -0.276     0.200
    60.993    -1.093     0.200
    61.297     0.558     0.200
    61.825    -0.914     0.200
    62.132     0.043     0.200
    62.216     0.501     0.200
    62.216    -0.398     0.200
    62.434    -1.251     0.200
    62.443    -0.414     0.200
    62.445    -0.344     0.200
    62.448    -0.079     0.200
    62.532     0.525     0.200
    62.893     0.046     0.200
    63.039    -0.535     0.200
    63.234    -0.171     0.200
    63.423     0.257     0.200
    63.553    -0.672     0.200
    63.722    -0.561     0.200
    63.739    -0.284     0.200
    64.057    -0.190     0.200
    64.412    -2.204     0.200
    64.499    -0.315     0.200
    64.550    -1.094     0.200
    64.552    -1.173     0.200
    64.702    -2.163     0.200
    64.790     0.526     0.200
    64.922     0.434     0.200
    65.033     0.363     0.200
    65.209     0.069     0.200
    65.373    -0.050     0.200
    65.373     0.294     0.200
    65.419     0.325     0.200
    65.489     0.096     0.200
    65.563    -2.382     0.200
    65.616     0.522     0.200
    65.663     0.347     0.200
    65.726     0.766     0.200
    65.745     0.047     0.200
    65.745     0.547     0.200
    65.745     0.375     0.200
    65.748     0.527     0.200
    65.921     0.441     0.200
    66.170    -0.527     0.200
    66.172     0.355     0.200
    66.281     1.354     0.200
    66.350    -1.032     0.200
    66.350    -1.329     0.200
    66.408    -0.720     0.200
    66.410     0.668     0.200
    66.452     0.524     0.200
    66.567     0.590     0.200
    66.636     0.224     0.200
    66.905    -0.432     0.200
    66.944     1.765     0.200
    66.946     0.356     0.200
    67.265     0.347     0.200
    67.269    -1.636     0.200
    67.330     0.954     0.200
    67.862     0.265     0.200
    67.906    -0.294     0.200
    68.143     1.571     0.200
    68.143     0.118     0.200
    68.163     0.698     0.200
    68.163    -0.802     0.200
    68.294     0.479     0.200
    68.328    -0.066     0.200
    68.530    -0.014     0.200
    68.584    -1.189     0.200
    68.600    -0.241     0.200
    68.641    -0.226     0.200
    68.716    -0.063     0.200
    68.779    -0.043     0.200
    68.799    -0.519     0.200
    68.867    -0.436     0.200
    69.424    -0.751     0.200
    69.446     0.504     0.200
    69.510    -0.286     0.200
    69.578    -0.551     0.200
    69.640    -1.266     0.200
    69.640    -1.047     0.200
    69.730     0.140     0.200
    69.790    -1.607     0.200
    69.790    -0.294     0.200
    69.924    -0.846     0.200
    70.147    -0.135     0.200
    70.349    -0.276     0.200
    70.662    -0.870     0.200
    70.662    -0.472     0.200
    70.921    -0.539     0.200
    71.145     0.251     0.200
    71.145     0.805     0.200
    71.242    -0.088     0.200
    71.401    -1.095     0.200
    71.703     1.229     0.200
    71.703     1.331     0.200
    71.808     0.035     0.200
    71.861     0.181     0.200
    71.911     0.409     0.200
    72.157    -0.214     0.200
    72.307     0.252     0.200
    72.321     0.018     0.200
    72.454     0.383     0.200
    72.549     0.694     0.200
    72.631     0.908     0.200
    72.802     0.253     0.200
    72.833     0.309     0.200
    72.867    -1.069     0.200
    73.023    -0.695     0.200
    73.160     0.436     0.200
    73.246     1.104     0.200
    73.246     0.495     0.200
    73.281     0.574     0.200
    73.343     0.286     0.200
    73.344     0.336     0.200
    73.344     0.227     0.200
    73.343     0.072     0.200
    73.413     0.372     0.200
    73.446    -2.366     0.200
    73.484     0.411     0.200
    73.605     0.504     0.200
    73.687     0.198     0.200
    73.869    -0.119     0.200
    74.073     0.378     0.200
    74.171     0.186     0.200
    74.231     0.517     0.200
    74.226     2.468     0.200
    74.294     0.324     0.200
    74.296     0.542     0.200
    74.343    -0.210     0.200
    74.596    -0.303     0.200
    74.673     0.392     0.200
    74.708     0.051     0.200
    74.708    -0.050     0.200
    74.828     0.629     0.200
    74.838    -0.528     0.200
    74.915     0.482     0.200
    74.939     0.191     0.200
    75.046     0.615     0.200
    75.048    -0.117     0.200
    75.054    -0.619     0.200
    75.075    -0.905     0.200
    75.110     0.317     0.200
    75.121    -0.174     0.200
    75.133    -0.103     0.200
    75.267     0.102     0.200
    75.302    -0.034     0.200
    75.395     0.292     0.200
    75.395     0.425     0.200
    75.401     0.081     0.200
    75.427     0.075     0.200
    75.535     0.947     0.200
    75.834     0.806     0.200
    75.854     0.410     0.200
    75.865     0.161     0.200
    75.892     0.444     0.200
    75.917    -0.667     0.200
    75.995     0.763     0.200
    76.004     0.346     0.200
    76.013     0.147     0.200
    76.059     0.424     0.200
    76.059     0.635     0.200
    76.249     0.672     0.200
    76.353    -0.137     0.200
    76.376     0.516     0.200
    76.385     0.685     0.200
    76.399    -0.351     0.200
    76.399     0.000     0.200
    76.436    -0.107     0.200
    76.471    -0.201     0.200
    76.588    -0.199     0.200
    76.634     0.558     0.200
    76.787     0.099     0.200
    76.857     0.919     0.200
    76.864    -0.416     0.200
    76.864    -0.518     0.200
    76.906     0.901     0.200
    76.935    -0.419     0.200
    76.936     0.076     0.200
    76.936     0.404     0.200
    77.065     1.055     0.200
    77.151     0.168     0.200
    77.151     0.769     0.200
    77.232     1.172     0.200
    77.233     0.770     0.200
    77.419    -0.333     0.200
    77.425     0.234     0.200
    77.486    -0.358     0.200
    77.540     0.849     0.200
    77.608    -0.081     0.200
    77.608    -0.183     0.200
    77.747     0.563     0.200
    77.851     0.352     0.200
    78.204    -0.226     0.200
    78.319     1.229     0.200
    78.387     0.747     0.200
    78.418    -0.470     0.200
    78.478     0.495     0.200
    78.482    -0.128     0.200
    78.665    -0.708     0.200
    78.740     0.257     0.200
    78.912     0.710     0.200
    78.912     0.140     0.200
    78.914     1.000     0.200
    79.061     0.317     0.200
    79.213    -0.497     0.200
    79.390     0.375     0.200
    79.480     0.510     0.200
    79.788     0.327     0.200
    79.879     0.324     0.200
    79.962    -0.409     0.200
    80.101     0.717     0.200
    80.513     0.940     0.200
    80.721     0.215     0.200
    80.757     0.413     0.200
    80.895     0.240     0.200
    80.908     0.347     0.200
    80.958     0.102     0.200
    81.100    -0.794     0.200
    81.307     0.344     0.200
    81.405    -0.705     0.200
    81.407     0.173     0.200
    81.444     0.198     0.200
    81.733    -0.172     0.200
    82.061    -1.259     0.200
    82.555    -0.620     0.200
    82.754    -0.427     0.200
    83.256     0.699     0.200
    83.463     0.093     0.200
    83.658    -1.329     0.200
    83.861    -0.865     0.200
    84.068     0.275     0.200
    84.077     0.128     0.200
    84.111    -0.842     0.200
    84.149    -0.736     0.200
    84.675    -0.795     0.200
    84.831    -0.719     0.200
    84.930    -0.932     0.200
    84.946    -0.053     0.200
    84.969    -0.566     0.200
    85.028    -0.837     0.200
    85.378    -0.414     0.200
    85.392    -0.718     0.200
    85.403    -1.041     0.200
    85.622    -0.262     0.200
    85.740     0.015     0.200
    86.086    -0.380     0.200
    86.183     0.010     0.200
    86.183    -0.201     0.200
    86.194     1.025     0.200
    86.194     0.455     0.200
    86.217     0.237     0.200
    86.691    -0.704     0.200
    86.754    -0.443     0.200
    87.118    -0.037     0.200
    87.562    -0.692     0.200
    87.592    -0.252     0.200
    87.819    -0.353     0.200
    87.896     0.092     0.200
    87.903     0.161     0.200
    87.939    -0.145     0.200
    87.956     0.115     0.200
    87.991    -0.036     0.200
    88.025    -0.037     0.200
    88.154    -0.019     0.200
    88.217    -0.457     0.200
    88.226     0.163     0.200
    88.240     0.095     0.200
    88.247    -0.372     0.200
    88.303    -0.226     0.200
    88.310    -0.000     0.200
    88.346    -0.593     0.200
    88.446    -0.315     0.200
    88.556    -0.558     0.200
    88.576     0.050     0.200
    88.591    -0.021     0.200
    88.717    -0.276     0.200
    88.794    -0.186     0.200
    88.817     0.027     0.200
    88.877    -0.491     0.200
    88.888     0.429     0.200
    89.057    -0.264     0.200
    89.125     0.137     0.200
    89.223     0.189     0.200
    89.248     0.159     0.200
    89.270     0.129     0.200
    89.302     0.264     0.200
    89.339     0.381     0.200
    89.375     0.220     0.200
    89.661     0.037     0.200
    89.714     0.276     0.200
    89.784     0.193     0.200
    89.808     0.227     0.200
    89.888     0.152     0.200
    89.950     1.016     0.200
    90.107     0.106     0.200
    90.109     0.159     0.200
    90.153     0.026     0.200
    90.181    -0.324     0.200
    90.277    -0.515     0.200
    90.543     0.147     0.200
    90.847    -1.031     0.200
    90.955    -1.020     0.200
    90.998    -1.038     0.200
    91.181    -1.105     0.200
    91.204    -1.082     0.200
    92.895    -0.694     0.200
    17.933    -1.631     0.200
    19.626    -1.629     0.200
    20.351    -1.645     0.200
    20.957    -2.581     0.200
    21.309    -2.446     0.200
    21.309    -3.665     0.200
    21.309    -3.425     0.200
    21.373    -3.393     0.200
    21.373    -2.943     0.200
    21.781    -0.508     0.200
    23.555     0.301     0.200
    24.010    -4.055     0.200
    24.752    -0.608     0.200
    25.125    -0.335     0.200
    25.376    -1.597     0.200
    25.803    -2.443     0.200
    25.872    -0.267     0.200
    26.316    -0.766     0.200
    26.316    -0.385     0.200
    27.834    -0.398     0.200
    27.948    -0.608     0.200
    28.177    -1.179     0.200
    28.177     0.152     0.200
    28.177     0.445     0.200
    28.352    -0.508     0.200
    28.677    -1.501     0.200
    28.677    -1.031     0.200
    29.825    -0.170     0.200
    30.245    -3.186     0.200
    30.245    -3.356     0.200
    30.833     0.630     0.200
    32.592     0.577     0.200
    33.279    -0.814     0.200
    33.501    -0.373     0.200
    33.662     0.047     0.200
    36.457     0.504     0.200
    36.478    -0.179     0.200
    36.478    -0.701     0.200
    37.279     0.723     0.200
    38.253    -1.293     0.200
    38.253    -1.031     0.200
    38.573     0.824     0.200
    38.860     0.784     0.200
    39.503    -0.674     0.200
    39.503    -1.128     0.200
    39.503    -0.674     0.200
    39.844     0.717     0.200
    40.622     0.453     0.200
    41.125    -2.252     0.200
    41.125    -1.773     0.200
    41.601     1.110     0.200
    41.704    -1.152     0.200
    42.084     0.488     0.200
    42.103    -0.848     0.200
    42.103    -1.044     0.200
    42.169     0.658     0.200
    42.252     0.179     0.200
    42.522    -0.513     0.200
    42.608    -0.449     0.200
    42.608    -0.199     0.200
    42.608    -0.489     0.200
    42.608    -0.279     0.200
    42.664     0.006     0.200
    42.745    -0.146     0.200
    42.809    -0.182     0.200
    42.936    -0.603     0.200
    42.936    -0.703     0.200
    42.935    -0.533     0.200
    42.957    -0.884     0.200
    42.993     1.457     0.200
    43.003    -0.188     0.200
    43.029     0.345     0.200
    43.081    -0.618     0.200
    43.225    -1.318     0.200
    43.225    -1.072     0.200
    43.234     1.986     0.200
    43.234     1.851     0.200
    43.260     1.465     0.200
    43.326    -0.102     0.200
    43.455    -0.544     0.200
    43.476    -0.138     0.200
    43.531    -0.990     0.200
    43.589     0.033     0.200
    43.589    -0.623     0.200
    43.603     0.720     0.200
    43.691    -0.885     0.200
    43.714    -0.554     0.200
    43.770    -0.644     0.200
    43.808    -1.034     0.200
    43.837     0.838     0.200
    43.943    -0.408     0.200
    43.976    -0.079     0.200
    43.980    -0.411     0.200
    43.980    -0.145     0.200
    44.007     0.777     0.200
    44.033    -0.539     0.200
    44.045    -0.341     0.200
    44.078     1.267     0.200
    44.141     0.195     0.200
    44.141     0.053     0.200
    44.162    -0.844     0.200
    44.182     1.076     0.200
    44.221     0.767     0.200
    44.234    -0.724     0.200
    44.245     0.970     0.200
    44.245     1.121     0.200
    44.245     0.471     0.200
    44.259     1.262     0.200
    44.258     0.468     0.200
    44.259     1.214     0.200
    44.262     0.440     0.200
    44.281     1.183     0.200
    44.295     1.024     0.200
    44.303     2.111     0.200
    44.400    -1.425     0.200
    44.400    -1.132     0.200
    44.405    -0.734     0.200
    44.422     1.077     0.200
    44.760    -0.695     0.200
    44.909     0.055     0.200
    44.953    -0.566     0.200
    44.953     0.662     0.200
    45.018    -0.019     0.200
    45.145    -0.594     0.200
    45.216    -1.915     0.200
    45.222     0.696     0.200
    45.222    -0.031     0.200
    45.229     0.023     0.200
    45.244     0.328     0.200
    45.467    -0.309     0.200
    45.467     0.082     0.200
    45.422    -0.172     0.200
    45.742    -1.064     0.200
    45.742    -0.790     0.200
    45.753     0.353     0.200
    45.782     1.076     0.200
    45.832     1.983     0.200
    45.835     0.187     0.200
    45.876     1.630     0.200
    45.946     0.415     0.200
    45.946    -0.047     0.200
    46.013    -0.268     0.200
    46.075     0.006     0.200
    46.075     0.366     0.200
    46.123     0.069     0.200
    46.236    -0.280     0.200
    46.464     0.122     0.200
    46.566    -0.354     0.200
    46.566     0.121     0.200
    46.619     0.850     0.200
    46.619     0.448     0.200
    46.713     0.457     0.200
    46.784    -0.885     0.200
    46.789     1.935     0.200
    46.833    -0.811     0.200
    46.838     0.339     0.200
    46.847     0.493     0.200
    47.045     1.077     0.200
    47.104    -0.343     0.200
    47.343     0.301     0.200
    47.369    -0.063     0.200
    47.460     0.891     0.200
    47.505     0.343     0.200
    47.508     0.168     0.200
    47.537    -0.750     0.200
    47.553     0.728     0.200
    47.626     0.960     0.200
    47.717    -0.351     0.200
    47.720     0.251     0.200
    48.089     0.682     0.200
    48.096     0.827     0.200
    48.155    -0.126     0.200
    48.232     0.153     0.200
    48.252     1.626     0.200
    48.343     1.426     0.200
    48.346     0.014     0.200
    48.416     0.704     0.200
    48.416     0.264     0.200
    48.606     0.602     0.200
    48.630     0.417     0.200
    48.636     0.471     0.200
    48.834     0.654     0.200
    48.851    -0.175     0.200
    48.952    -0.052     0.200
    48.960     0.473     0.200
    48.967     0.339     0.200
    49.012     0.020     0.200
    49.137    -0.860     0.200
    49.273     0.030     0.200
    49.273    -0.098     0.200
    49.273    -0.539     0.200
    49.429     0.746     0.200
    49.591     3.374     0.200
    49.744     0.002     0.200
    49.999     0.680     0.200
    50.023     0.621     0.200
    50.160     1.561     0.200
    50.686    -0.108     0.200
    50.961     0.728     0.200
    51.279    -0.147     0.200
    51.355     2.054     0.200
    51.658    -0.091     0.200
    51.730    -0.627     0.200
    51.730    -0.727     0.200
    52.126    -0.976     0.200
    52.133    -0.220     0.200
    52.259     0.243     0.200
    52.469    -0.453     0.200
    52.622     2.156     0.200
    52.653     1.255     0.200
    52.653     1.925     0.200
    53.047     1.020     0.200
    53.062     0.815     0.200
    53.345    -0.669     0.200
    53.345    -0.869     0.200
    53.351     0.763     0.200
    53.478     1.859     0.200
    53.736     1.402     0.200
    54.165     0.644     0.200
    54.320     0.214     0.200
    54.450    -0.827     0.200
    54.602    -0.032     0.200
    54.784    -1.851     0.200
    55.129     0.763     0.200
    55.207     0.201     0.200
    55.253    -0.912     0.200
    55.436     1.251     0.200
    55.612    -1.980     0.200
    55.612    -1.480     0.200
    55.617    -0.348     0.200
    55.617    -0.458     0.200
    55.692    -1.184     0.200
    55.692    -0.894     0.200
    55.842     0.441     0.200
    55.875    -1.992     0.200
    55.984     1.192     0.200
    56.168    -0.687     0.200
    56.245     0.766     0.200
    56.310     0.902     0.200
    56.395     0.497     0.200
    56.571    -1.221     0.200
    56.652    -1.228     0.200
    56.820    -0.716     0.200
    56.844    -1.386     0.200
    56.844    -0.616     0.200
    56.876    -0.813     0.200
    57.036     0.059     0.200
    57.088     1.391     0.200
    57.093    -1.145     0.200
    57.436     0.532     0.200
    57.662    -0.252     0.200
    57.712    -1.914     0.200
    58.154    -0.497     0.200
    58.251     1.027     0.200
    58.308     0.726     0.200
    58.600     0.291     0.200
    58.616     0.284     0.200
    58.634    -1.246     0.200
    58.944    -0.497     0.200
    58.988    -1.101     0.200
    59.131    -1.385     0.200
    59.144    -0.178     0.200
    59.280    -1.136     0.200
    59.534    -1.658     0.200
    59.534    -1.894     0.200
    59.534    -1.159     0.200
    59.707    -1.977     0.200
    59.728    -0.503     0.200
    60.024    -3.134     0.200
    60.488    -1.161     0.200
    60.634    -1.598     0.200
    60.844    -0.416     0.200
    60.873    -0.423     0.200
    61.158    -1.209     0.200
    61.658     0.493     0.200
    62.199     0.559     0.200
    62.281    -0.579     0.200
    62.450    -0.329     0.200
    62.460    -0.849     0.200
    62.460    -0.299     0.200
    62.460    -1.139     0.200
    62.483    -0.375     0.200
    62.483    -0.110     0.200
    62.521    -3.407     0.200
    62.610    -1.897     0.200
    62.638     0.355     0.200
    62.790     0.338     0.200
    63.132    -1.623     0.200
    63.480     0.259     0.200
    63.493    -0.183     0.200
    63.584    -0.694     0.200
    63.648     0.340     0.200
    63.814    -2.566     0.200
    63.837     0.177     0.200
    63.889    -0.919     0.200
    64.151    -0.647     0.200
    64.310    -1.030     0.200
    64.404     0.186     0.200
    64.431    -1.827     0.200
    64.434    -0.835     0.200
    64.495     0.156     0.200
    64.499    -0.764     0.200
    64.572    -1.627     0.200
    64.650     1.007     0.200
    64.673    -1.488     0.200
    64.673    -1.258     0.200
    64.766    -1.593     0.200
    64.766    -1.294     0.200
    64.815    -0.213     0.200
    64.874    -2.203     0.200
    64.948     0.624     0.200
    65.113    -1.245     0.200
    65.149     0.661     0.200
    65.413     0.013     0.200
    65.413    -0.637     0.200
    65.506     0.242     0.200
    65.650     0.900     0.200
    65.845    -0.970     0.200
    65.868    -1.508     0.200
    65.936    -1.255     0.200
    66.014     1.714     0.200
    66.133     0.812     0.200
    66.141     1.464     0.200
    66.187     0.228     0.200
    66.187    -0.435     0.200
    66.287     1.289     0.200
    66.578    -0.616     0.200
    66.578    -0.966     0.200
    66.624     1.413     0.200
    66.670     1.161     0.200
    66.732     0.124     0.200
    66.809    -1.156     0.200
    66.997    -0.427     0.200
    66.997    -0.877     0.200
    67.011     0.084     0.200
    67.046     1.206     0.200
    67.127    -1.351     0.200
    67.335     0.610     0.200
    67.575     0.213     0.200
    67.580     0.256     0.200
    67.762    -1.382     0.200
    68.090     0.118     0.200
    68.222     0.153     0.200
    68.290    -2.950     0.200
    68.456     0.832     0.200
    68.456     0.560     0.200
    68.456     0.390     0.200
    68.456     0.229     0.200
    68.477    -0.389     0.200
    68.477     0.361     0.200
    68.481    -1.268     0.200
    68.605    -0.437     0.200
    68.731    -0.921     0.200
    68.771    -0.781     0.200
    68.788    -1.065     0.200
    68.836    -0.993     0.200
    68.839    -0.373     0.200
    68.888    -1.400     0.200
    68.888    -1.640     0.200
    68.875     0.784     0.200
    68.956    -0.539     0.200
    69.042    -0.893     0.200
    69.507     0.262     0.200
    69.560    -1.564     0.200
    69.572     0.715     0.200
    69.575     0.895     0.200
    69.600    -0.841     0.200
    69.619     1.233     0.200
    69.619     1.382     0.200
    69.619     0.782     0.200
    69.707    -0.179     0.200
    69.744    -0.430     0.200
    69.818    -1.288     0.200
    69.824    -1.279     0.200
    69.824    -1.204     0.200
    69.829     0.489     0.200
    69.894     0.295     0.200
    69.945     0.741     0.200
    69.977    -1.385     0.200
    70.029    -0.558     0.200
    70.111     0.060     0.200
    70.111     0.551     0.200
    70.152    -0.627     0.200
    70.359    -0.354     0.200
    70.524    -1.657     0.200
    70.524    -1.058     0.200
    70.785     0.318     0.200
    70.785     0.573     0.200
    70.819    -0.049     0.200
    70.854     1.358     0.200
    70.864    -0.687     0.200
    70.864     0.893     0.200
    70.899     0.843     0.200
    70.926    -1.000     0.200
    70.926    -1.120     0.200
    70.931     1.179     0.200
    70.935    -0.688     0.200
    70.972     1.354     0.200
    71.017    -0.743     0.200
    71.093    -0.642     0.200
    71.147    -1.178     0.200
    71.147    -0.778     0.200
    71.173     0.075     0.200
    71.226     0.512     0.200
    71.233     0.189     0.200
    71.315     0.341     0.200
    71.362     0.342     0.200
    71.427    -0.631     0.200
    71.459    -0.132     0.200
    71.459    -0.241     0.200
    71.459     0.120     0.200
    71.463     2.308     0.200
    71.518     0.489     0.200
    71.551    -0.348     0.200
    71.584     0.116     0.200
    71.584     1.091     0.200
    71.678     0.922     0.200
    71.706     0.487     0.200
    71.725    -0.004     0.200
    71.725     0.371     0.200
    71.730    -0.307     0.200
    71.816     0.101     0.200
    71.932    -0.381     0.200
    71.950    -0.194     0.200
    71.980    -0.432     0.200
    72.009    -0.016     0.200
    72.017    -0.044     0.200
    72.015     0.293     0.200
    72.038    -0.616     0.200
    72.121     0.674     0.200
    72.157     1.006     0.200
    72.185     0.533     0.200
    72.236     0.505     0.200
    72.261     0.726     0.200
    72.278     0.226     0.200
    72.335     0.088     0.200
    72.335     0.437     0.200
    72.347     1.298     0.200
    72.482    -1.143     0.200
    72.499    -0.426     0.200
    72.511     0.181     0.200
    72.559     0.749     0.200
    72.584    -0.607     0.200
    72.671     0.782     0.200
    72.872     1.096     0.200
    72.890    -0.748     0.200
    72.890    -0.898     0.200
    72.985     1.147     0.200
    72.996     0.944     0.200
    73.006    -0.260     0.200
    73.062     0.973     0.200
    73.100     0.142     0.200
    73.100    -0.008     0.200
    73.124     0.424     0.200
    73.206    -0.835     0.200
    73.211    -0.571     0.200
    73.313     0.857     0.200
    73.386     0.942     0.200
    73.408    -1.024     0.200
    73.408    -0.704     0.200
    73.492     1.017     0.200
    73.520    -0.718     0.200
    73.706     0.130     0.200
    73.723    -0.968     0.200
    73.723    -0.401     0.200
    73.725     0.621     0.200
    73.738     0.154     0.200
    73.781     0.748     0.200
    73.785     0.755     0.200
    73.795    -0.291     0.200
    73.811     0.912     0.200
    73.833    -0.187     0.200
    73.848    -0.592     0.200
    73.881    -0.494     0.200
    73.938     0.554     0.200
    74.020    -0.529     0.200
    74.020    -0.229     0.200
    74.030    -0.144     0.200
    74.106     0.608     0.200
    74.154    -0.886     0.200
    74.184    -0.164     0.200
    74.205    -0.884     0.200
    74.322     0.526     0.200
    74.385     0.900     0.200
    74.415    -1.426     0.200
    74.420    -0.807     0.200
    74.471     0.281     0.200
    74.506    -1.271     0.200
    74.552     0.257     0.200
    74.579     0.267     0.200
    74.596     0.279     0.200
    74.645     0.469     0.200
    74.690    -0.211     0.200
    74.778     1.811     0.200
    74.797    -0.976     0.200
    74.812     0.402     0.200
    74.820     0.917     0.200
    74.834     1.084     0.200
    74.928    -1.070     0.200
    74.959     0.008     0.200
    74.973     0.034     0.200
    74.973    -0.301     0.200
    75.014     0.189     0.200
    75.056     0.201     0.200
    75.074     1.165     0.200
    75.078     0.163     0.200
    75.078     0.016     0.200
    75.102     0.527     0.200
    75.105     0.659     0.200
    75.110    -0.294     0.200
    75.109     0.467     0.200
    75.137     0.465     0.200
    75.165     0.834     0.200
    75.193    -0.488     0.200
    75.308    -0.457     0.200
    75.355    -0.118     0.200
    75.376     0.001     0.200
    75.376    -0.149     0.200
    75.446     0.452     0.200
    75.459     1.569     0.200
    75.488     0.538     0.200
    75.527    -0.712     0.200
    75.541     0.263     0.200
    75.566     0.901     0.200
    75.570     0.385     0.200
    75.590     0.390     0.200
    75.597     0.831     0.200
    75.615     0.589     0.200
    75.682    -0.000     0.200
    75.705     0.566     0.200
    75.736    -0.354     0.200
    75.760     1.086     0.200
    75.783     0.496     0.200
    75.855    -0.066     0.200
    75.898    -1.039     0.200
    75.923    -0.129     0.200
    75.932     0.200     0.200
    75.934    -0.089     0.200
    75.954     0.497     0.200
    76.027     0.954     0.200
    76.069     0.040     0.200
    76.091     0.865     0.200
    76.105     0.614     0.200
    76.114     1.073     0.200
    76.159     0.809     0.200
    76.175     0.892     0.200
    76.191    -0.399     0.200
    76.191     0.300     0.200
    76.256     0.052     0.200
    76.256     0.283     0.200
    76.286     0.790     0.200
    76.291     0.057     0.200
    76.321     0.069     0.200
    76.337     0.676     0.200
    76.347     0.902     0.200
    76.373     1.242     0.200
    76.383     0.689     0.200
    76.451     0.873     0.200
    76.466     0.652     0.200
    76.497     1.048     0.200
    76.513    -0.226     0.200
    76.538     0.536     0.200
    76.537     0.686     0.200
    76.548     0.182     0.200
    76.585     0.171     0.200
    76.637    -0.681     0.200
    76.638     0.015     0.200
    76.647     0.812     0.200
    76.656     0.216     0.200
    76.666     0.316     0.200
    76.670     0.194     0.200
    76.707     0.187     0.200
    76.716     0.552     0.200
    76.727     0.312     0.200
    76.905     0.752     0.200
    76.948    -0.726     0.200
    76.956    -0.019     0.200
    76.958     1.277     0.200
    77.108     0.525     0.200
    77.108     0.132     0.200
    77.108    -0.387     0.200
    77.110     0.319     0.200
    77.157    -0.543     0.200
    77.157    -0.912     0.200
    77.162    -0.520     0.200
    77.162    -0.274     0.200
    77.202    -0.247     0.200
    77.204     0.093     0.200
    77.296     1.087     0.200
    77.307     1.017     0.200
    77.310    -0.203     0.200
    77.324     0.767     0.200
    77.328    -0.277     0.200
    77.342    -0.082     0.200
    77.363    -0.618     0.200
    77.362    -0.125     0.200
    77.388    -0.119     0.200
    77.388     0.326     0.200
    77.486     1.078     0.200
    77.541    -0.525     0.200
    77.614     0.100     0.200
    77.622    -0.414     0.200
    77.624     0.144     0.200
    77.649    -0.092     0.200
    77.653     0.079     0.200
    77.663     0.028     0.200
    77.667    -0.526     0.200
    77.678     0.848     0.200
    77.683    -0.333     0.200
    77.752    -0.108     0.200
    77.822     0.158     0.200
    77.850     0.788     0.200
    77.860     0.932     0.200
    77.860     0.832     0.200
    78.033    -0.203     0.200
    78.032    -0.730     0.200
    78.041    -0.125     0.200
    78.062     0.712     0.200
    78.065     1.376     0.200
    78.084    -0.263     0.200
    78.105     0.562     0.200
    78.114    -0.462     0.200
    78.114    -0.331     0.200
    78.138    -0.263     0.200
    78.143    -0.391     0.200
    78.141     0.834     0.200
    78.174    -0.161     0.200
    78.204    -0.227     0.200
    78.207     1.353     0.200
    78.220    -0.015     0.200
    78.238     0.039     0.200
    78.307    -0.741     0.200
    78.376    -0.195     0.200
    78.385    -0.039     0.200
    78.386     1.004     0.200
    78.386     0.312     0.200
    78.492     0.614     0.200
    78.523     0.704     0.200
    78.522    -0.045     0.200
    78.566    -0.123     0.200
    78.580    -1.122     0.200
    78.606    -0.989     0.200
    78.635    -0.050     0.200
    78.681    -0.104     0.200
    78.707    -0.110     0.200
    78.710     0.237     0.200
    78.712     0.028     0.200
    78.781     0.452     0.200
    78.812    -0.279     0.200
    78.858    -0.228     0.200
    78.897    -0.395     0.200
    78.897    -0.189     0.200
    78.897    -0.610     0.200
    78.897    -0.795     0.200
    78.968     0.319     0.200
    78.970    -0.449     0.200
    78.970    -0.886     0.200
    79.010    -0.436     0.200
    79.040    -0.521     0.200
    79.134     0.312     0.200
    79.136    -0.591     0.200
    79.280    -0.459     0.200
    79.461     0.247     0.200
    79.475     0.588     0.200
    79.483     0.091     0.200
    79.505     0.698     0.200
    79.565     1.468     0.200
    79.587    -1.202     0.200
    79.605    -0.903     0.200
    79.666     0.450     0.200
    79.675    -0.182     0.200
    79.713    -0.284     0.200
    79.841     0.034     0.200
    79.851     0.868     0.200
    79.870    -0.138     0.200
    79.968    -0.023     0.200
    79.970    -0.959     0.200
    80.020    -0.493     0.200
    80.019     0.162     0.200
    80.103    -0.359     0.200
    80.111    -0.693     0.200
    80.121     0.081     0.200
    80.145    -0.694     0.200
    80.151     0.498     0.200
    80.165    -0.674     0.200
    80.250     1.372     0.200
    80.250     1.082     0.200
    80.330    -0.473     0.200
    80.353    -0.595     0.200
    80.378     0.178     0.200
    80.385    -0.497     0.200
    80.454    -0.232     0.200
    80.467     0.004     0.200
    80.475     0.060     0.200
    80.499    -0.064     0.200
    80.500    -1.071     0.200
    80.500     1.490     0.200
    80.557    -0.759     0.200
    80.632    -0.677     0.200
    80.636    -0.201     0.200
    80.657    -0.844     0.200
    80.676    -0.616     0.200
    80.722    -0.547     0.200
    80.758    -0.749     0.200
    80.797    -0.498     0.200
    80.806    -0.678     0.200
    80.831    -0.801     0.200
    80.840    -0.678     0.200
    80.842    -0.858     0.200
    80.892     0.131     0.200
    80.929    -0.267     0.200
    80.951     0.107     0.200
    80.987     0.807     0.200
    80.988     0.253     0.200
    81.018    -0.036     0.200
    81.064     0.417     0.200
    81.066    -0.949     0.200
    81.074    -0.354     0.200
    81.124     0.109     0.200
    81.128    -0.761     0.200
    81.135     0.010     0.200
    81.148    -0.338     0.200
    81.169     1.610     0.200
    81.187     0.124     0.200
    81.209    -0.449     0.200
    81.212    -0.566     0.200
    81.218    -0.335     0.200
    81.248    -1.967     0.200
    81.317    -0.725     0.200
    81.440    -1.194     0.200
    81.532    -0.758     0.200
    81.535     0.120     0.200
    81.544    -0.855     0.200
    81.615    -0.796     0.200
    81.615    -0.696     0.200
    81.614    -1.017     0.200
    81.632    -0.001     0.200
    81.657    -0.633     0.200
    81.657    -0.516     0.200
    81.657    -0.416     0.200
    81.688    -0.620     0.200
    81.721    -0.753     0.200
    81.776    -0.783     0.200
    81.846    -1.312     0.200
    81.880    -0.191     0.200
    81.894    -1.357     0.200
    81.925    -0.625     0.200
    81.931    -0.762     0.200
    81.957    -0.014     0.200
    81.993    -0.982     0.200
    81.993    -1.082     0.200
    82.011     0.006     0.200
    82.017    -2.591     0.200
    82.026    -0.660     0.200
    82.057    -0.576     0.200
    82.100    -1.108     0.200
    82.217     0.262     0.200
    82.217    -0.357     0.200
    82.277    -1.181     0.200
    82.298    -1.200     0.200
    82.534    -0.511     0.200
    82.534    -0.365     0.200
    82.559    -0.829     0.200
    82.783    -0.954     0.200
    83.006     0.567     0.200
    83.063     0.257     0.200
    83.112    -1.665     0.200
    83.193     0.479     0.200
    83.193     0.785     0.200
    83.347    -0.104     0.200
    83.359    -0.338     0.200
    83.431     1.074     0.200
    83.782    -0.734     0.200
    84.042     0.160     0.200
    84.171    -0.491     0.200
    84.235    -0.182     0.200
    84.313     0.253     0.200
    84.313    -0.347     0.200
    84.318    -1.202     0.200
    84.318    -0.983     0.200
    84.431    -0.851     0.200
    84.705     0.177     0.200
    84.712    -0.759     0.200
    84.797    -1.281     0.200
    84.878    -0.336     0.200
    84.911    -0.625     0.200
    85.024    -0.865     0.200
    85.212    -1.009     0.200
    85.269    -1.041     0.200
    85.273    -0.799     0.200
    85.300    -1.033     0.200
    85.386    -0.205     0.200
    85.395    -0.300     0.200
    85.442    -1.004     0.200
    85.590    -0.029     0.200
    85.710    -0.372     0.200
    85.815    -0.885     0.200
    85.817    -0.077     0.200
    85.830    -0.781     0.200
    85.841    -0.292     0.200
    85.921     0.492     0.200
    85.921     0.337     0.200
    85.973    -0.759     0.200
    85.977    -0.462     0.200
    85.977     0.073     0.200
    85.995    -0.346     0.200
    86.122    -0.563     0.200
    86.178    -0.963     0.200
    86.423    -0.056     0.200
    86.522    -0.771     0.200
    86.538    -0.257     0.200
    86.544    -0.680     0.200
    86.568    -0.821     0.200
    86.592    -0.756     0.200
    86.741    -0.436     0.200
    86.826    -0.780     0.200
    86.837    -0.683     0.200
    86.867    -0.475     0.200
    86.979    -0.411     0.200
    87.005    -0.852     0.200
    87.013    -0.118     0.200
    87.129    -0.611     0.200
    87.136    -0.194     0.200
    87.248    -0.166     0.200
    87.321    -0.873     0.200
    87.332     0.095     0.200
    87.380    -1.162     0.200
    87.393    -1.002     0.200
    87.396     0.211     0.200
    87.408    -0.403     0.200
    87.440    -0.719     0.200
    87.464    -0.133     0.200
    87.482    -0.644     0.200
    87.483     0.082     0.200
    87.505     0.264     0.200
    87.554    -0.867     0.200
    87.594     0.261     0.200
    87.719    -0.424     0.200
    87.733    -0.465     0.200
    87.747    -0.119     0.200
    87.772    -0.306     0.200
    87.780    -0.275     0.200
    87.797    -0.311     0.200
    87.825    -0.757     0.200
    87.829    -0.703     0.200
    87.834    -0.296     0.200
    87.855    -0.883     0.200
    87.855    -0.317     0.200
    87.857    -0.136     0.200
    87.897    -0.330     0.200
    88.018     0.169     0.200
    88.041     0.238     0.200
    88.074     0.012     0.200
    88.094    -0.370     0.200
    88.116     0.181     0.200
    88.116    -0.074     0.200
    88.147    -0.189     0.200
    88.152    -0.223     0.200
    88.184    -0.468     0.200
    88.192    -0.186     0.200
    88.237    -0.611     0.200
    88.237     0.186     0.200
    88.238    -0.389     0.200
    88.305    -0.207     0.200
    88.307    -0.079     0.200
    88.307    -0.160     0.200
    88.424    -0.471     0.200
    88.422     0.069     0.200
    88.424    -0.312     0.200
    88.487    -0.292     0.200
    88.555    -0.061     0.200
    88.555     0.043     0.200
    88.648    -0.091     0.200
    88.678    -0.210     0.200
    88.680    -0.541     0.200
    88.683    -0.226     0.200
    88.710    -0.474     0.200
    88.723    -0.063     0.200
    88.735    -0.252     0.200
    88.739    -0.297     0.200
    88.775    -0.466     0.200
    88.806    -0.447     0.200
    88.819    -0.047     0.200
    88.885     0.465     0.200
    88.920     0.118     0.200
    88.960    -0.532     0.200
    88.989    -0.026     0.200
    89.100     0.193     0.200
    89.138    -0.034     0.200
    89.140    -0.039     0.200
    89.144    -0.127     0.200
    89.160     0.178     0.200
    89.260    -0.036     0.200
    89.282    -0.060     0.200
    89.300    -0.053     0.200
    89.369    -0.058     0.200
    89.437    -0.270     0.200
    89.516     0.188     0.200
    89.563    -0.470     0.200
    89.563     0.250     0.200
    89.580    -0.116     0.200
    89.594    -0.004     0.200
    89.600     0.073     0.200
    89.616     0.204     0.200
    89.633    -0.126     0.200
    89.635    -0.028     0.200
    89.687    -0.136     0.200
    89.700    -0.094     0.200
    89.746    -0.195     0.200
    89.746     0.042     0.200
    89.789     0.493     0.200
    89.835     0.219     0.200
    89.835     0.080     0.200
    89.960    -1.277     0.200
    89.961     0.158     0.200
    89.991     0.481     0.200
    89.991    -0.033     0.200
    90.015     0.308     0.200
    90.049    -0.678     0.200
    90.123     0.306     0.200
    90.291    -0.112     0.200
    90.300    -0.041     0.200
    90.347    -0.749     0.200
    90.353     0.009     0.200
    90.413    -0.052     0.200
    90.455    -0.172     0.200
    90.524    -0.353     0.200
    90.558    -0.141     0.200
    90.579    -0.114     0.200
    90.673    -0.790     0.200
    90.674     0.021     0.200
    90.677     0.205     0.200
    90.732     0.220     0.200
    90.732    -0.263     0.200
    90.793    -0.230     0.200
    90.834    -0.475     0.200
    90.853    -0.828     0.200
    90.930    -0.416     0.200
    90.966    -1.394     0.200
    91.040     0.029     0.200
    91.292     0.187     0.200
    91.475    -0.235     0.200
    91.491    -0.388     0.200
    91.565    -0.948     0.200
    91.952    -0.623     0.200
    92.071    -0.383     0.200
    92.232     0.113     0.200
    92.586    -0.016     0.200
    92.626    -0.438     0.200
    92.712    -0.436     0.200
    92.934    -0.597     0.200
    93.092    -0.611     0.200
    93.480    -1.574     0.200
    93.605    -0.145     0.200
    21.147    -2.176     0.200
    21.147    -1.247     0.200
    28.415    -0.934     0.200
    39.138    -3.551     0.200
    39.700     0.100     0.200
    42.863     0.102     0.200
    42.863    -0.953     0.200
    43.640     0.684     0.200
    44.059    -0.322     0.200
    44.082    -0.165     0.200
    44.162    -0.805     0.200
    48.820     0.039     0.200
    53.488    -1.631     0.200
    58.305     0.115     0.200
    62.675    -1.521     0.200
    64.804    -1.036     0.200
    68.638    -0.739     0.200
    71.030    -1.340     0.200
    81.357     0.186     0.200
    20.982    -1.858     0.200
    21.283    -2.043     0.200
    26.849     0.492     0.200
    26.849    -0.297     0.200
    39.047    -0.169     0.200
    39.902     0.168     0.200
    40.652     0.474     0.200
    40.899    -0.842     0.200
    41.272    -0.388     0.200
    41.721    -0.450     0.200
    41.874     0.055     0.200
    42.855    -0.092     0.200
    43.112     0.148     0.200
    43.112     0.296     0.200
    43.198     0.111     0.200
    43.307    -0.109     0.200
    43.312    -0.071     0.200
    43.397    -0.172     0.200
    43.782    -0.785     0.200
    43.782     0.465     0.200
    43.782    -0.097     0.200
    44.302     0.695     0.200
    44.382     0.021     0.200
    44.541     0.323     0.200
    44.757    -0.832     0.200
    44.995     1.312     0.200
    45.943    -0.058     0.200
    46.215     0.214     0.200
    46.233     1.203     0.200
    48.487    -0.249     0.200
    48.536    -1.193     0.200
    48.536    -0.388     0.200
    48.707    -0.302     0.200
    52.238     0.258     0.200
    52.238     0.102     0.200
    56.013    -0.309     0.200
    56.013    -0.934     0.200
    56.395     0.298     0.200
    59.634     0.326     0.200
    62.654    -1.395     0.200
    62.825    -1.396     0.200
    62.833    -0.239     0.200
    62.834    -0.303     0.200
    62.834    -1.529     0.200
    64.869    -1.686     0.200
    64.871    -1.039     0.200
    64.871    -1.461     0.200
    65.147     0.091     0.200
    65.299    -0.284     0.200
    66.560     0.663     0.200
    68.837     0.589     0.200
    69.052     1.014     0.200
    69.423     0.945     0.200
    69.825    -1.053     0.200
    69.856    -0.817     0.200
    69.856    -0.465     0.200
    70.137     1.220     0.200
    70.147     1.139     0.200
    70.205     0.501     0.200
    70.367     1.207     0.200
    71.153    -0.700     0.200
    72.406    -0.222     0.200
    72.406    -0.207     0.200
    72.406     0.660     0.200
    72.406    -0.496     0.200
    85.199     0.794     0.200
    26.347    -0.252     0.200
    39.532    -0.274     0.200
    41.491     0.720     0.200
    42.639    -0.014     0.200
    42.639    -0.791     0.200
    42.639    -0.514     0.200
    44.386     0.147     0.200
    45.729    -0.824     0.200
    48.133    -0.109     0.200
    49.127    -0.651     0.200
    55.646    -0.237     0.200
    64.787    -1.511     0.200
    65.419    -0.448     0.200
    26.326    -0.030     0.200
    26.326     0.626     0.200
    39.523    -0.972     0.200
    39.523    -0.722     0.200
    42.620    -0.354     0.200
    42.620    -0.745     0.200
    42.620    -0.557     0.200
    43.881     0.085     0.200
    43.881    -0.728     0.200
    43.960    -0.598     0.200
    44.443    -0.317     0.200
    48.126    -0.592     0.200
    49.182    -1.211     0.200
    49.182    -0.906     0.200
    53.372    -0.452     0.200
    58.678    -0.386     0.200
    59.574    -0.623     0.200
    60.899    -0.526     0.200
    62.412    -1.554     0.200
    62.413    -1.562     0.200
    64.802    -1.205     0.200
    69.445    -0.138     0.200
    69.855    -1.054     0.200
    69.863    -0.857     0.200
    70.956    -0.641     0.200
    73.139     0.494     0.200
    76.344     0.358     0.200
    78.931    -0.521     0.200
    85.956     0.862     0.200
    21.310    -2.884     0.200
    21.310    -1.899     0.200
    21.421    -2.842     0.200
    23.466    -1.213     0.200
    25.799    -0.441     0.200
    26.243     0.190     0.200
    26.243    -0.149     0.200
    27.851     0.620     0.200
    32.504     0.812     0.200
    37.081    -0.129     0.200
    37.373     0.590     0.200
    38.507     1.240     0.200
    39.447    -1.588     0.200
    39.447    -0.690     0.200
    39.447    -1.440     0.200
    39.768     1.421     0.200
    41.580     0.034     0.200
    42.538    -0.519     0.200
    42.538     0.059     0.200
    42.538    -0.508     0.200
    42.740    -0.854     0.200
    43.802    -0.314     0.200
    43.802    -0.814     0.200
    43.908     0.335     0.200
    44.146     0.978     0.200
    44.478    -0.624     0.200
    46.927     0.761     0.200
    46.946     0.756     0.200
    48.101     0.159     0.200
    48.284     0.545     0.200
    48.537     0.500     0.200
    49.200    -0.075     0.200
    49.200     0.085     0.200
    49.200    -0.275     0.200
    49.208    -0.919     0.200
    49.208    -0.564     0.200
    49.336     0.584     0.200
    49.770     0.485     0.200
    50.042     0.222     0.200
    50.970     0.695     0.200
    51.660    -0.335     0.200
    52.089    -0.232     0.200
    53.302    -0.584     0.200
    53.302    -0.764     0.200
    53.302    -0.885     0.200
    54.611    -0.132     0.200
    55.561    -0.332     0.200
    56.840    -0.794     0.200
    58.709    -1.174     0.200
    59.131     0.503     0.200
    60.232    -1.541     0.200
    60.656    -2.220     0.200
    62.236     0.135     0.200
    62.409     0.140     0.200
    62.416     0.638     0.200
    62.416     0.084     0.200
    64.639    -1.499     0.200
    64.639    -0.999     0.200
    64.747    -1.279     0.200
    64.748    -1.683     0.200
    64.748    -1.507     0.200
    65.444    -0.118     0.200
    66.143     0.716     0.200
    68.424     0.361     0.200
    69.815    -0.982     0.200
    70.891    -0.924     0.200
    70.958     1.405     0.200
    72.086     0.621     0.200
    74.924     0.138     0.200
    74.938    -0.464     0.200
    75.164     0.833     0.200
    76.269    -0.776     0.200
    76.270     0.375     0.200
    76.270    -0.375     0.200
    79.766    -0.249     0.200
    86.014     1.248     0.200
    21.433    -2.085     0.200
    26.242    -0.274     0.200
    39.449     0.008     0.200
    39.449    -0.348     0.200
    39.449     0.227     0.200
    41.926     0.144     0.200
    42.538    -0.060     0.200
    42.538    -0.138     0.200
    42.538    -0.283     0.200
    42.740     0.004     0.200
    43.803    -0.869     0.200
    44.138     0.653     0.200
    44.490    -0.412     0.200
    47.585    -0.092     0.200
    47.792     1.090     0.200
    48.283     0.712     0.200
    51.660    -0.875     0.200
    55.564    -0.383     0.200
    58.721     0.107     0.200
    59.119     0.587     0.200
    60.729     1.062     0.200
    62.225    -0.973     0.200
    62.398     0.001     0.200
    62.404    -0.219     0.200
    62.404     0.304     0.200
    64.755    -1.161     0.200
    64.755    -1.298     0.200
    21.279    -2.428     0.200
    26.356    -0.174     0.200
    39.519    -0.218     0.200
    42.643    -0.601     0.200
    42.643    -0.525     0.200
    44.288    -0.177     0.200
    48.548    -1.210     0.200
    49.028    -0.594     0.200
    55.633    -0.519     0.200
    56.204    -0.627     0.200
    58.524    -0.740     0.200
    59.490    -1.348     0.200
    62.551     0.208     0.200
    64.735    -1.532     0.200
    68.488    -0.217     0.200
    69.783    -1.164     0.200
    72.987     0.357     0.200
    76.329    -0.167     0.200
    84.322    -0.150     0.200
    21.404    -3.338     0.200
    21.693    -1.857     0.200
    23.469    -1.438     0.200
    25.797     0.084     0.200
    26.241    -0.885     0.200
    32.507     1.306     0.200
    37.089    -0.677     0.200
    37.377    -0.111     0.200
    39.441    -0.792     0.200
    39.441    -1.108     0.200
    39.441    -0.901     0.200
    39.767     1.659     0.200
    40.483     0.254     0.200
    41.563    -0.404     0.200
    42.479    -0.931     0.200
    42.536    -0.270     0.200
    42.737    -0.006     0.200
    43.798    -0.098     0.200
    44.157     0.528     0.200
    44.412    -0.585     0.200
    44.462    -1.459     0.200
    45.805    -1.450     0.200
    46.911     1.012     0.200
    46.929     0.812     0.200
    48.095    -0.048     0.200
    49.422     1.552     0.200
    51.657    -1.224     0.200
    51.657    -1.103     0.200
    51.657    -0.877     0.200
    53.294    -0.649     0.200
    53.294    -0.270     0.200
    53.294    -0.169     0.200
    55.556    -0.490     0.200
    55.556    -0.142     0.200
    62.433     0.272     0.200
    62.410    -0.130     0.200
    62.410     0.210     0.200
    64.736    -1.181     0.200
    66.160     0.708     0.200
    69.802    -0.697     0.200
    69.802    -1.111     0.200
    70.882    -0.832     0.200
    76.263     0.252     0.200
    77.125    -0.004     0.200
    86.000     0.196     0.200
    21.348    -3.252     0.200
    21.439    -3.943     0.200
    26.292    -0.086     0.200
    39.496    -1.719     0.200
    42.588    -0.632     0.200
    59.568    -0.946     0.200
    64.792    -1.449     0.200
    69.856    -0.982     0.200
    85.996    -0.594     0.200
    26.320    -0.633     0.200
    26.320    -0.413     0.200
    39.518    -0.683     0.200
    39.518    -0.316     0.200
    39.518    -0.953     0.200
    42.614     0.049     0.200
    42.614    -0.181     0.200
    42.614    -0.601     0.200
    43.640    -0.477     0.200
    43.876    -0.422     0.200
    49.189    -0.673     0.200
    55.633    -0.457     0.200
    62.489    -1.004     0.200
    62.489    -0.269     0