#!/bin/bash
gmt begin sapporo1.54_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times sapporo1.54'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   319.308
    25.500   323.846
    26.000   328.373
    26.500   332.888
    27.000   337.389
    27.500   341.873
    28.000   346.337
    28.500   350.788
    29.000   355.229
    29.500   359.662
    30.000   364.087
    30.500   368.504
    31.000   372.914
    31.500   377.316
    32.000   381.709
    32.500   386.092
    33.000   390.464
    33.500   394.823
    34.000   399.167
    34.500   403.496
    35.000   407.810
    35.500   412.109
    36.000   416.393
    36.500   420.662
    37.000   424.915
    37.500   429.152
    38.000   433.373
    38.500   437.579
    39.000   441.767
    39.500   445.938
    40.000   450.093
    40.500   454.230
    41.000   458.351
    41.500   462.454
    42.000   466.541
    42.500   470.610
    43.000   474.661
    43.500   478.695
    44.000   482.712
    44.500   486.710
    45.000   490.691
    45.500   494.654
    46.000   498.599
    46.500   502.526
    47.000   506.435
    47.500   510.325
    48.000   514.198
    48.500   518.053
    49.000   521.889
    49.500   525.707
    50.000   529.507
    50.500   533.289
    51.000   537.053
    51.500   540.798
    52.000   544.525
    52.500   548.235
    53.000   551.927
    53.500   555.601
    54.000   559.257
    54.500   562.894
    55.000   566.513
    55.500   570.114
    56.000   573.696
    56.500   577.260
    57.000   580.806
    57.500   584.333
    58.000   587.843
    58.500   591.334
    59.000   594.807
    59.500   598.262
    60.000   601.699
    60.500   605.117
    61.000   608.517
    61.500   611.898
    62.000   615.262
    62.500   618.607
    63.000   621.935
    63.500   625.244
    64.000   628.536
    64.500   631.810
    65.000   635.066
    65.500   638.304
    66.000   641.525
    66.500   644.727
    67.000   647.911
    67.500   651.077
    68.000   654.224
    68.500   657.354
    69.000   660.466
    69.500   663.559
    70.000   666.634
    70.500   669.691
    71.000   672.731
    71.500   675.752
    72.000   678.755
    72.500   681.739
    73.000   684.705
    73.500   687.653
    74.000   690.582
    74.500   693.492
    75.000   696.384
    75.500   699.257
    76.000   702.112
    76.500   704.949
    77.000   707.768
    77.500   710.569
    78.000   713.351
    78.500   716.116
    79.000   718.862
    79.500   721.590
    80.000   724.299
    80.500   726.990
    81.000   729.660
    81.500   732.312
    82.000   734.945
    82.500   737.559
    83.000   740.154
    83.500   742.730
    84.000   745.287
    84.500   747.823
    85.000   750.339
    85.500   752.835
    86.000   755.313
    86.500   757.774
    87.000   760.216
    87.500   762.633
    88.000   765.015
    88.500   767.379
    89.000   769.731
    89.500   772.075
    90.000   774.412
    90.500   776.741
    91.000   779.065
    91.500   781.383
    92.000   783.697
    92.500   786.007
    93.000   788.314
    93.500   790.617
    94.000   792.916
    94.500   795.211
    95.000   797.500
    95.500   799.783
    96.000   802.060
    96.500   804.331
    97.000   806.595
    97.500   808.852
    98.000   811.102
    98.500   813.345
    99.000   815.580
    99.500   817.807
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1116.653
   116.000  1117.615
   116.500  1118.578
   117.000  1119.540
   117.500  1120.502
   118.000  1121.464
   118.500  1122.425
   119.000  1123.387
   119.500  1124.348
   120.000  1125.310
   120.500  1126.271
   121.000  1127.231
   121.500  1128.192
   122.000  1129.152
   122.500  1130.112
   123.000  1131.072
   123.500  1132.031
   124.000  1132.989
   124.500  1133.947
   125.000  1134.905
   125.500  1135.862
   126.000  1136.819
   126.500  1137.774
   127.000  1138.729
   127.500  1139.684
   128.000  1140.637
   128.500  1141.590
   129.000  1142.542
   129.500  1143.493
   130.000  1144.443
   130.500  1145.391
   131.000  1146.339
   131.500  1147.285
   132.000  1148.230
   132.500  1149.174
   133.000  1150.116
   133.500  1151.056
   134.000  1151.995
   134.500  1152.932
   135.000  1153.867
   135.500  1154.800
   136.000  1155.731
   136.500  1156.660
   137.000  1157.586
   137.500  1158.510
   138.000  1159.431
   138.500  1160.349
   139.000  1161.265
   139.500  1162.177
   140.000  1163.086
   140.500  1163.992
   141.000  1164.895
   141.500  1165.793
   142.000  1166.687
   142.500  1167.577
   143.000  1168.463
   143.500  1169.344
   144.000  1170.220
   144.500  1171.091
   145.000  1171.956
   145.500  1172.815
   146.000  1173.669
   146.500  1174.516
   147.000  1175.356
   147.500  1176.190
   148.000  1177.017
   148.500  1177.836
   149.000  1178.647
   149.500  1179.449
   150.000  1180.241
   150.500  1181.024
   151.000  1181.797
   151.500  1182.560
   152.000  1183.312
   152.500  1184.055
   153.000  1184.788
   153.500  1185.510
   154.000  1186.222
   154.500  1186.923
   155.000  1187.613
   155.500  1188.291
   156.000  1188.958
   156.500  1189.613
   157.000  1190.256
   157.500  1190.886
   158.000  1191.505
   158.500  1192.111
   159.000  1192.705
   159.500  1193.285
   160.000  1193.853
   160.500  1194.408
   161.000  1194.950
   161.500  1195.479
   162.000  1195.994
   162.500  1196.497
   163.000  1196.986
   163.500  1197.462
   164.000  1197.923
   164.500  1198.371
   165.000  1198.805
   165.500  1199.225
   166.000  1199.632
   166.500  1200.024
   167.000  1200.403
   167.500  1200.768
   168.000  1201.119
   168.500  1201.455
   169.000  1201.778
   169.500  1202.086
   170.000  1202.380
   170.500  1202.660
   171.000  1202.926
   171.500  1203.178
   172.000  1203.415
   172.500  1203.638
   173.000  1203.847
   173.500  1204.041
   174.000  1204.221
   174.500  1204.386
   175.000  1204.538
   175.500  1204.675
   176.000  1204.797
   176.500  1204.905
   177.000  1204.999
   177.500  1205.078
   178.000  1205.143
   178.500  1205.194
   179.000  1205.230
   179.500  1205.252
   180.000  1205.259
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   987.557
     1.000   987.566
     1.500   987.580
     2.000   987.599
     2.500   987.625
     3.000   987.655
     3.500   987.692
     4.000   987.734
     4.500   987.781
     5.000   987.834
     5.500   987.893
     6.000   987.958
     6.500   988.027
     7.000   988.103
     7.500   988.184
     8.000   988.271
     8.500   988.363
     9.000   988.461
     9.500   988.564
    10.000   988.673
    10.500   988.787
    11.000   988.908
    11.500   989.033
    12.000   989.164
    12.500   989.301
    13.000   989.443
    13.500   989.591
    14.000   989.744
    14.500   989.903
    15.000   990.068
    15.500   990.237
    16.000   990.413
    16.500   990.594
    17.000   990.780
    17.500   990.972
    18.000   991.169
    18.500   991.372
    19.000   991.580
    19.500   991.794
    20.000   992.013
    20.500   992.237
    21.000   992.468
    21.500   992.703
    22.000   992.944
    22.500   993.190
    23.000   993.442
    23.500   993.699
    24.000   993.961
    24.500   994.229
    25.000   994.503
    25.500   994.781
    26.000   995.065
    26.500   995.354
    27.000   995.649
    27.500   995.949
    28.000   996.254
    28.500   996.565
    29.000   996.881
    29.500   997.202
    30.000   997.528
    30.500   997.860
    31.000   998.197
    31.500   998.539
    32.000   998.886
    32.500   999.239
    33.000   999.596
    33.500   999.959
    34.000  1000.327
    34.500  1000.701
    35.000  1001.079
    35.500  1001.462
    36.000  1001.851
    36.500  1002.245
    37.000  1002.644
    37.500  1003.048
    38.000  1003.457
    38.500  1003.871
    39.000  1004.290
    39.500  1004.714
    40.000  1005.143
    40.500  1005.578
    41.000  1006.017
    41.500  1006.461
    42.000  1006.910
    42.500  1007.364
    43.000  1007.823
    43.500  1008.287
    44.000  1008.755
    44.500  1009.229
    45.000  1009.708
    45.500  1010.191
    46.000  1010.679
    46.500  1011.172
    47.000  1011.670
    47.500  1012.173
    48.000  1012.680
    48.500  1013.192
    49.000  1013.709
    49.500  1014.231
    50.000  1014.757
    50.500  1015.288
    51.000  1015.823
    51.500  1016.364
    52.000  1016.909
    52.500  1017.458
    53.000  1018.012
    53.500  1018.571
    54.000  1019.134
    54.500  1019.702
    55.000  1020.274
    55.500  1020.851
    56.000  1021.433
    56.500  1022.019
    57.000  1022.609
    57.500  1023.204
    58.000  1023.803
    58.500  1024.406
    59.000  1025.014
    59.500  1025.626
    60.000  1026.243
    60.500  1026.864
    61.000  1027.489
    61.500  1028.119
    62.000  1028.753
    62.500  1029.391
    63.000  1030.033
    63.500  1030.679
    64.000  1031.330
    64.500  1031.985
    65.000  1032.644
    65.500  1033.307
    66.000  1033.974
    66.500  1034.645
    67.000  1035.321
    67.500  1036.000
    68.000  1036.683
    68.500  1037.371
    69.000  1038.062
    69.500  1038.757
    70.000  1039.457
    70.500  1040.160
    71.000  1040.867
    71.500  1041.578
    72.000  1042.293
    72.500  1043.011
    73.000  1043.734
    73.500  1044.460
    74.000  1045.190
    74.500  1045.924
    75.000  1046.661
    75.500  1047.402
    76.000  1048.147
    76.500  1048.896
    77.000  1049.648
    77.500  1050.403
    78.000  1051.163
    78.500  1051.926
    79.000  1052.692
    79.500  1053.462
    80.000  1054.235
    80.500  1055.012
    81.000  1055.793
    81.500  1056.577
    82.000  1057.364
    82.500  1058.155
    83.000  1058.949
    83.500  1059.746
    84.000  1060.547
    84.500  1061.350
    85.000  1062.158
    85.500  1062.968
    86.000  1063.782
    86.500  1064.599
    87.000  1065.419
    87.500  1066.242
    88.000  1067.069
    88.500  1067.898
    89.000  1068.731
    89.500  1069.566
    90.000  1070.405
    90.500  1071.247
    91.000  1072.091
    91.500  1072.939
    92.000  1073.790
    92.500  1074.643
    93.000  1075.500
    93.500  1076.359
    94.000  1077.221
    94.500  1078.086
    95.000  1078.954
    95.500  1079.824
    96.000  1080.698
    96.500  1081.574
    97.000  1082.453
    97.500  1083.334
    98.000  1084.218
    98.500  1085.105
    99.000  1085.995
    99.500  1086.886
   100.000  1087.781
   100.500  1088.678
   101.000  1089.578
   101.500  1090.480
   102.000  1091.384
   102.500  1092.291
   103.000  1093.201
   103.500  1094.113
   104.000  1095.027
   104.500  1095.943
   105.000  1096.862
   105.500  1097.783
   106.000  1098.707
   106.500  1099.633
   107.000  1100.561
   107.500  1101.491
   108.000  1102.423
   108.500  1103.358
   109.000  1104.294
   109.500  1105.233
   110.000  1106.174
   110.500  1107.117
   111.000  1108.062
   111.500  1109.009
   112.000  1109.958
   112.500  1110.908
   113.000  1111.861
   113.500  1112.816
   114.000  1113.773
   114.500  1114.731
   115.000  1115.691
   115.500  1116.654
   116.000  1117.618
   116.500  1118.583
   117.000  1119.551
   117.500  1120.520
   118.000  1121.491
   118.500  1122.464
   119.000  1123.438
   119.500  1124.414
   120.000  1125.391
   120.500  1126.370
   121.000  1127.351
   121.500  1128.333
   122.000  1129.316
   122.500  1130.302
   123.000  1131.288
   123.500  1132.276
   124.000  1133.266
   124.500  1134.256
   125.000  1135.249
   125.500  1136.242
   126.000  1137.237
   126.500  1138.233
   127.000  1139.230
   127.500  1140.229
   128.000  1141.229
   128.500  1142.230
   129.000  1143.232
   129.500  1144.236
   130.000  1145.240
   130.500  1146.246
   131.000  1147.253
   131.500  1148.261
   132.000  1149.270
   132.500  1150.279
   133.000  1151.290
   133.500  1152.302
   134.000  1153.315
   134.500  1154.329
   135.000  1155.343
   135.500  1156.359
   136.000  1157.375
   136.500  1158.392
   137.000  1159.410
   137.500  1160.429
   138.000  1161.448
   138.500  1162.469
   139.000  1163.490
   139.500  1164.511
   140.000  1165.534
   140.500  1166.557
   141.000  1167.580
   141.500  1168.605
   142.000  1169.630
   142.500  1170.655
   143.000  1171.681
   143.500  1172.708
   144.000  1173.734
   144.500  1174.762
   145.000  1175.790
   145.500  1176.818
   146.000  1177.847
   146.500  1178.876
   147.000  1179.906
   147.500  1180.936
   148.000  1181.966
   148.500  1182.996
   149.000  1184.027
   149.500  1185.058
   150.000  1186.089
   150.500  1187.121
   151.000  1188.153
   151.500  1189.185
   152.000  1190.217
   152.500  1191.249
   153.000  1192.281
   153.500  1193.314
   154.000  1194.346
   154.500  1195.379
   155.000  1196.411
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1171.368
   145.500  1173.203
   146.000  1175.090
   146.500  1177.012
   147.000  1178.961
   147.500  1180.933
   148.000  1182.924
   148.500  1184.932
   149.000  1186.956
   149.500  1188.994
   150.000  1191.044
   150.500  1193.105
   151.000  1195.177
   151.500  1197.258
   152.000  1199.348
   152.500  1201.446
   153.000  1203.552
   153.500  1205.666
   154.000  1207.786
   154.500  1209.913
   155.000  1212.046
   155.500  1214.184
   156.000  1216.328
   156.500  1218.476
   157.000  1220.629
   157.500  1222.787
   158.000  1224.949
   158.500  1227.115
   159.000  1229.285
   159.500  1231.459
   160.000  1233.636
   160.500  1235.816
   161.000  1237.999
   161.500  1240.185
   162.000  1242.373
   162.500  1244.565
   163.000  1246.758
   163.500  1248.954
   164.000  1251.152
   164.500  1253.352
   165.000  1255.554
   165.500  1257.757
   166.000  1259.963
   166.500  1262.170
   167.000  1264.378
   167.500  1266.588
   168.000  1268.799
   168.500  1271.012
   169.000  1273.225
   169.500  1275.440
   170.000  1277.656
   170.500  1279.872
   171.000  1282.090
   171.500  1284.308
   172.000  1286.527
   172.500  1288.746
   173.000  1290.966
   173.500  1293.187
   174.000  1295.408
   174.500  1297.629
   175.000  1299.851
   175.500  1302.073
   176.000  1304.296
   176.500  1306.518
   177.000  1308.741
   177.500  1310.964
   178.000  1313.187
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1171.351
   145.500  1172.963
   146.000  1174.502
   146.500  1175.985
   147.000  1177.419
   147.500  1178.808
   148.000  1180.156
   148.500  1181.464
   149.000  1182.738
   149.500  1183.984
   150.000  1185.205
   150.500  1186.403
   151.000  1187.581
   151.500  1188.740
   152.000  1189.880
   152.500  1191.004
   153.000  1192.111
   153.500  1193.204
   154.000  1194.284
   154.500  1195.351
   155.000  1196.405
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   504.433
     1.000   504.469
     1.500   504.529
     2.000   504.613
     2.500   504.721
     3.000   504.854
     3.500   505.010
     4.000   505.190
     4.500   505.394
     5.000   505.622
     5.500   505.874
     6.000   506.149
     6.500   506.449
     7.000   506.772
     7.500   507.118
     8.000   507.488
     8.500   507.882
     9.000   508.299
     9.500   508.739
    10.000   509.203
    10.500   509.689
    11.000   510.199
    11.500   510.732
    12.000   511.287
    12.500   511.866
    13.000   512.466
    13.500   513.090
    14.000   513.736
    14.500   514.404
    15.000   515.094
    15.500   515.807
    16.000   516.541
    16.500   517.297
    17.000   518.075
    17.500   518.874
    18.000   519.695
    18.500   520.537
    19.000   521.400
    19.500   522.284
    20.000   523.189
    20.500   524.114
    21.000   525.060
    21.500   526.026
    22.000   527.013
    22.500   528.019
    23.000   529.045
    23.500   530.091
    24.000   531.156
    24.500   532.241
    25.000   533.345
    25.500   534.468
    26.000   535.610
    26.500   536.770
    27.000   537.949
    27.500   539.146
    28.000   540.361
    28.500   541.594
    29.000   542.845
    29.500   544.113
    30.000   545.399
    30.500   546.702
    31.000   548.022
    31.500   549.359
    32.000   550.712
    32.500   552.082
    33.000   553.468
    33.500   554.870
    34.000   556.288
    34.500   557.722
    35.000   559.171
    35.500   560.635
    36.000   562.115
    36.500   563.610
    37.000   565.119
    37.500   566.643
    38.000   568.181
    38.500   569.734
    39.000   571.301
    39.500   572.881
    40.000   574.475
    40.500   576.082
    41.000   577.703
    41.500   579.337
    42.000   580.984
    42.500   582.643
    43.000   584.315
    43.500   586.000
    44.000   587.696
    44.500   589.405
    45.000   591.125
    45.500   592.857
    46.000   594.601
    46.500   596.355
    47.000   598.121
    47.500   599.898
    48.000   601.686
    48.500   603.484
    49.000   605.293
    49.500   607.112
    50.000   608.941
    50.500   610.780
    51.000   612.629
    51.500   614.487
    52.000   616.355
    52.500   618.232
    53.000   620.119
    53.500   622.014
    54.000   623.918
    54.500   625.831
    55.000   627.752
    55.500   629.682
    56.000   631.619
    56.500   633.565
    57.000   635.519
    57.500   637.480
    58.000   639.449
    58.500   641.426
    59.000   643.410
    59.500   645.401
    60.000   647.399
    60.500   649.404
    61.000   651.416
    61.500   653.434
    62.000   655.459
    62.500   657.490
    63.000   659.527
    63.500   661.570
    64.000   663.620
    64.500   665.675
    65.000   667.736
    65.500   669.802
    66.000   671.874
    66.500   673.951
    67.000   676.034
    67.500   678.121
    68.000   680.213
    68.500   682.311
    69.000   684.413
    69.500   686.519
    70.000   688.630
    70.500   690.746
    71.000   692.866
    71.500   694.990
    72.000   697.117
    72.500   699.249
    73.000   701.385
    73.500   703.525
    74.000   705.668
    74.500   707.815
    75.000   709.965
    75.500   712.118
    76.000   714.275
    76.500   716.435
    77.000   718.598
    77.500   720.764
    78.000   722.932
    78.500   725.104
    79.000   727.278
    79.500   729.455
    80.000   731.634
    80.500   733.816
    81.000   736.000
    81.500   738.187
    82.000   740.375
    82.500   742.566
    83.000   744.759
    83.500   746.953
    84.000   749.150
    84.500   751.348
    85.000   753.548
    85.500   755.750
    86.000   757.953
    86.500   760.158
    87.000   762.364
    87.500   764.572
    88.000   766.781
    88.500   768.991
    89.000   771.202
    89.500   773.414
    90.000   775.628
    90.500   777.842
    91.000   780.058
    91.500   782.274
    92.000   784.491
    92.500   786.709
    93.000   788.927
    93.500   791.146
    94.000   793.366
    94.500   795.586
    95.000   797.807
    95.500   800.028
    96.000   802.250
    96.500   804.472
    97.000   806.694
    97.500   808.916
    98.000   811.139
    98.500   813.361
    99.000   815.584
    99.500   817.807
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.000   410.141
    28.500   415.699
    29.000   421.256
    29.500   426.812
    30.000   432.368
    30.500   437.922
    31.000   443.475
    31.500   449.025
    32.000   454.573
    32.500   460.119
    33.000   465.661
    33.500   471.200
    34.000   476.735
    34.500   482.265
    35.000   487.791
    35.500   493.311
    36.000   498.825
    36.500   504.333
    37.000   509.834
    37.500   515.327
    38.000   520.813
    38.500   526.290
    39.000   531.757
    39.500   537.215
    40.000   542.662
    40.500   548.099
    41.000   553.524
    41.500   558.937
    42.000   564.338
    42.500   569.725
    43.000   575.099
    43.500   580.458
    44.000   585.803
    44.500   591.133
    45.000   596.447
    45.500   601.746
    46.000   607.028
    46.500   612.293
    47.000   617.368
    47.500   621.941
    48.000   626.509
    48.500   631.073
    49.000   635.633
    49.500   640.187
    50.000   644.736
    50.500   649.280
    51.000   653.818
    51.500   658.351
    52.000   662.879
    52.500   667.400
    53.000   671.916
    53.500   676.425
    54.000   680.927
    54.500   685.420
    55.000   689.904
    55.500   694.378
    56.000   698.841
    56.500   703.299
    57.000   707.750
    57.500   712.196
    58.000   716.637
    58.500   721.074
    59.000   725.507
    59.500   729.936
    60.000   734.361
    60.500   738.783
    61.000   743.200
    61.500   747.614
    62.000   752.024
    62.500   756.430
    63.000   760.832
    63.500   765.230
    64.000   769.623
    64.500   774.012
    65.000   778.396
    65.500   782.774
    66.000   787.146
    66.500   791.511
    67.000   795.870
    67.500   800.222
    68.000   804.566
    68.500   808.903
    69.000   813.232
    69.500   817.554
    70.000   821.868
    70.500   826.175
    71.000   830.474
    71.500   834.765
    72.000   839.049
    72.500   843.326
    73.000   847.595
    73.500   851.856
    74.000   856.109
    74.500   860.354
    75.000   864.591
    75.500   868.821
    76.000   873.042
    76.500   877.256
    77.000   881.461
    77.500   885.657
    78.000   889.846
    78.500   894.026
    79.000   898.197
    79.500   902.360
    80.000   906.515
    80.500   910.660
    81.000   914.798
    81.500   918.927
    82.000   923.047
    82.500   927.159
    83.000   931.262
    83.500   935.357
    84.000   939.443
    84.500   943.521
    85.000   947.590
    85.500   951.650
    86.000   955.701
    86.500   959.744
    87.000   963.778
    87.500   967.803
    88.000   971.819
    88.500   975.826
    89.000   979.824
    89.500   983.814
    90.000   987.794
    90.500   991.766
    91.000   995.728
    91.500   999.682
    92.000  1003.626
    92.500  1007.562
    93.000  1011.488
    93.500  1015.406
    94.000  1019.314
    94.500  1023.213
    95.000  1027.104
    95.500  1030.985
    96.000  1034.857
    96.500  1038.721
    97.000  1042.575
    97.500  1046.420
    98.000  1050.256
    98.500  1054.082
    99.000  1057.900
    99.500  1061.709
   100.000  1065.508
   100.500  1069.298
   101.000  1073.080
   101.500  1076.852
   102.000  1080.614
   102.500  1084.368
   103.000  1088.113
   103.500  1091.848
   104.000  1095.575
   104.500  1099.293
   105.000  1103.002
   105.500  1106.702
   106.000  1110.393
   106.500  1114.076
   107.000  1117.749
   107.500  1121.413
   108.000  1125.068
   108.500  1128.714
   109.000  1132.351
   109.500  1135.979
   110.000  1139.597
   110.500  1143.206
   111.000  1146.806
   111.500  1150.396
   112.000  1153.977
   112.500  1157.549
   113.000  1161.112
   113.500  1164.666
   114.000  1168.211
   114.500  1171.747
   115.000  1175.273
   115.500  1178.791
   116.000  1182.299
   116.500  1185.799
   117.000  1189.289
   117.500  1192.771
   118.000  1196.243
   118.500  1199.706
   119.000  1203.160
   119.500  1206.604
   120.000  1210.040
   120.500  1213.466
   121.000  1216.884
   121.500  1220.292
   122.000  1223.690
   122.500  1227.080
   123.000  1230.460
   123.500  1233.832
   124.000  1237.194
   124.500  1240.547
   125.000  1243.891
   125.500  1247.227
   126.000  1250.553
   126.500  1253.870
   127.000  1257.179
   127.500  1260.478
   128.000  1263.769
   128.500  1267.051
   129.000  1270.323
   129.500  1273.587
   130.000  1276.842
   130.500  1280.088
   131.000  1283.325
   131.500  1286.553
   132.000  1289.771
   132.500  1292.981
   133.000  1296.182
   133.500  1299.374
   134.000  1302.556
   134.500  1305.730
   135.000  1308.895
   135.500  1312.050
   136.000  1315.196
   136.500  1318.334
   137.000  1321.462
   137.500  1324.581
   138.000  1327.691
   138.500  1330.792
   139.000  1333.884
   139.500  1336.967
   140.000  1340.041
   140.500  1343.106
   141.000  1346.161
   141.500  1349.208
   142.000  1352.246
   142.500  1355.274
   143.000  1358.294
   143.500  1361.304
   144.000  1364.306
   144.500  1367.298
   145.000  1370.281
   145.500  1373.255
   146.000  1376.219
   146.500  1379.175
   147.000  1382.121
   147.500  1385.058
   148.000  1387.985
   148.500  1390.903
   149.000  1393.811
   149.500  1396.710
   150.000  1399.600
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   820.030
   100.500   822.253
   101.000   824.475
   101.500   826.698
   102.000   828.921
   102.500   831.144
   103.000   833.367
   103.500   835.590
   104.000   837.812
   104.500   840.035
   105.000   842.258
   105.500   844.481
   106.000   846.704
   106.500   848.927
   107.000   851.149
   107.500   853.372
   108.000   855.595
   108.500   857.818
   109.000   860.041
   109.500   862.264
   110.000   864.486
   110.500   866.709
   111.000   868.932
   111.500   871.155
   112.000   873.378
   112.500   875.601
   113.000   877.823
   113.500   880.046
   114.000   882.269
   114.500   884.492
   115.000   886.715
   115.500   888.938
   116.000   891.160
   116.500   893.383
   117.000   895.606
   117.500   897.829
   118.000   900.052
   118.500   902.275
   119.000   904.497
   119.500   906.720
   120.000   908.943
   120.500   911.166
   121.000   913.389
   121.500   915.612
   122.000   917.834
   122.500   920.057
   123.000   922.280
   123.500   924.503
   124.000   926.726
   124.500   928.949
   125.000   931.172
   125.500   933.394
   126.000   935.617
   126.500   937.840
   127.000   940.063
   127.500   942.286
   128.000   944.508
   128.500   946.731
   129.000   948.954
   129.500   951.177
   130.000   953.400
   130.500   955.623
   131.000   957.845
   131.500   960.068
   132.000   962.291
   132.500   964.514
   133.000   966.737
   133.500   968.960
   134.000   971.182
   134.500   973.405
   135.000   975.628
   135.500   977.851
   136.000   980.074
   136.500   982.297
   137.000   984.520
   137.500   986.742
   138.000   988.965
   138.500   991.188
   139.000   993.411
   139.500   995.634
   140.000   997.856
   140.500  1000.079
   141.000  1002.302
   141.500  1004.525
   142.000  1006.748
   142.500  1008.971
   143.000  1011.193
   143.500  1013.416
   144.000  1015.639
   144.500  1017.862
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.000   369.018
    14.500   379.258
    15.000   389.494
    15.500   399.724
    16.000   409.944
    16.500   420.152
    17.000   430.342
    17.500   440.511
    18.000   450.653
    18.500   460.763
    19.000   470.836
    19.500   480.865
    20.000   490.845
    20.500   500.770
    21.000   510.633
    21.500   520.432
    22.000   530.160
    22.500   539.499
    23.000   547.660
    23.500   555.787
    24.000   563.881
    24.500   571.939
    25.000   579.942
    25.500   587.864
    26.000   595.770
    26.500   603.666
    27.000   611.554
    27.500   619.435
    28.000   627.309
    28.500   635.176
    29.000   643.037
    29.500   650.891
    30.000   658.738
    30.500   666.575
    31.000   674.402
    31.500   682.218
    32.000   690.020
    32.500   697.807
    33.000   705.578
    33.500   713.332
    34.000   721.068
    34.500   728.785
    35.000   736.482
    35.500   744.161
    36.000   751.819
    36.500   759.458
    37.000   767.076
    37.500   774.673
    38.000   782.249
    38.500   789.803
    39.000   797.335
    39.500   804.844
    40.000   812.330
    40.500   819.793
    41.000   827.233
    41.500   834.649
    42.000   842.041
    42.500   849.409
    43.000   856.753
    43.500   864.071
    44.000   871.366
    44.500   878.635
    45.000   885.879
    45.500   893.097
    46.000   900.290
    46.500   907.458
    47.000   914.599
    47.500   921.713
    48.000   928.801
    48.500   935.862
    49.000   942.896
    49.500   949.903
    50.000   956.883
    50.500   963.836
    51.000   970.762
    51.500   977.660
    52.000   984.531
    52.500   991.374
    53.000   998.191
    53.500  1004.981
    54.000  1011.746
    54.500  1018.485
    55.000  1025.196
    55.500  1031.881
    56.000  1038.537
    56.500  1045.167
    57.000  1051.768
    57.500  1058.341
    58.000  1064.886
    58.500  1071.403
    59.000  1077.892
    59.500  1084.355
    60.000  1090.789
    60.500  1097.196
    61.000  1103.575
    61.500  1109.926
    62.000  1116.249
    62.500  1122.543
    63.000  1128.809
    63.500  1135.046
    64.000  1141.255
    64.500  1147.436
    65.000  1153.588
    65.500  1159.713
    66.000  1165.809
    66.500  1171.877
    67.000  1177.917
    67.500  1183.928
    68.000  1189.911
    68.500  1195.865
    69.000  1201.790
    69.500  1207.687
    70.000  1213.555
    70.500  1219.395
    71.000  1225.205
    71.500  1230.987
    72.000  1236.740
    72.500  1242.463
    73.000  1248.156
    73.500  1253.820
    74.000  1259.453
    74.500  1265.057
    75.000  1270.631
    75.500  1276.176
    76.000  1281.691
    76.500  1287.177
    77.000  1292.634
    77.500  1298.060
    78.000  1303.456
    78.500  1308.822
    79.000  1314.158
    79.500  1319.465
    80.000  1324.742
    80.500  1329.990
    81.000  1335.208
    81.500  1340.394
    82.000  1345.549
    82.500  1350.671
    83.000  1355.762
    83.500  1360.821
    84.000  1365.850
    84.500  1370.848
    85.000  1375.814
    85.500  1380.749
    86.000  1385.653
    86.500  1390.524
    87.000  1395.364
    87.500  1400.170
    88.000  1404.944
    88.500  1409.684
    89.000  1414.392
    89.500  1419.066
    90.000  1423.706
    90.500  1428.312
    91.000  1432.885
    91.500  1437.424
    92.000  1441.930
    92.500  1446.401
    93.000  1450.838
    93.500  1455.243
    94.000  1459.623
    94.500  1463.988
    95.000  1468.341
    95.500  1472.682
    96.000  1477.011
    96.500  1481.326
    97.000  1485.624
    97.500  1489.902
    98.000  1494.159
    98.500  1498.397
    99.000  1502.616
    99.500  1506.815
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   711.362
     1.000   711.409
     1.500   711.487
     2.000   711.596
     2.500   711.736
     3.000   711.907
     3.500   712.110
     4.000   712.343
     4.500   712.608
     5.000   712.903
     5.500   713.229
     6.000   713.586
     6.500   713.973
     7.000   714.391
     7.500   714.839
     8.000   715.318
     8.500   715.827
     9.000   716.366
     9.500   716.935
    10.000   717.533
    10.500   718.162
    11.000   718.820
    11.500   719.507
    12.000   720.224
    12.500   720.969
    13.000   721.744
    13.500   722.547
    14.000   723.379
    14.500   724.239
    15.000   725.126
    15.500   726.042
    16.000   726.986
    16.500   727.957
    17.000   728.955
    17.500   729.980
    18.000   731.032
    18.500   732.111
    19.000   733.216
    19.500   734.347
    20.000   735.503
    20.500   736.685
    21.000   737.893
    21.500   739.125
    22.000   740.382
    22.500   741.664
    23.000   742.969
    23.500   744.299
    24.000   745.652
    24.500   747.029
    25.000   748.428
    25.500   749.851
    26.000   751.295
    26.500   752.762
    27.000   754.251
    27.500   755.761
    28.000   757.292
    28.500   758.845
    29.000   760.417
    29.500   762.011
    30.000   763.624
    30.500   765.256
    31.000   766.908
    31.500   768.579
    32.000   770.269
    32.500   771.977
    33.000   773.702
    33.500   775.446
    34.000   777.207
    34.500   778.985
    35.000   780.779
    35.500   782.590
    36.000   784.417
    36.500   786.259
    37.000   788.117
    37.500   789.990
    38.000   791.877
    38.500   793.779
    39.000   795.695
    39.500   797.624
    40.000   799.567
    40.500   801.522
    41.000   803.491
    41.500   805.471
    42.000   807.464
    42.500   809.468
    43.000   811.484
    43.500   813.510
    44.000   815.547
    44.500   817.594
    45.000   819.652
    45.500   821.719
    46.000   823.795
    46.500   825.881
    47.000   827.975
    47.500   830.077
    48.000   832.188
    48.500   834.306
    49.000   836.432
    49.500   838.564
    50.000   840.704
    50.500   842.850
    51.000   845.002
    51.500   847.161
    52.000   849.324
    52.500   851.494
    53.000   853.668
    53.500   855.847
    54.000   858.030
    54.500   860.218
    55.000   862.410
    55.500   864.605
    56.000   866.804
    56.500   869.006
    57.000   871.211
    57.500   873.419
    58.000   875.629
    58.500   877.841
    59.000   880.055
    59.500   882.271
    60.000   884.489
    60.500   886.708
    61.000   888.928
    61.500   891.149
    62.000   893.371
    62.500   895.593
    63.000   897.815
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   923.416
     1.000   923.483
     1.500   923.594
     2.000   923.749
     2.500   923.949
     3.000   924.193
     3.500   924.481
     4.000   924.813
     4.500   925.189
     5.000   925.610
     5.500   926.074
     6.000   926.583
     6.500   927.135
     7.000   927.730
     7.500   928.370
     8.000   929.052
     8.500   929.779
     9.000   930.548
     9.500   931.360
    10.000   932.215
    10.500   933.113
    11.000   934.053
    11.500   935.036
    12.000   936.061
    12.500   937.128
    13.000   938.237
    13.500   939.387
    14.000   940.579
    14.500   941.812
    15.000   943.086
    15.500   944.401
    16.000   945.756
    16.500   947.152
    17.000   948.587
    17.500   950.063
    18.000   951.578
    18.500   953.132
    19.000   954.725
    19.500   956.357
    20.000   958.027
    20.500   959.736
    21.000   961.482
    21.500   963.266
    22.000   965.088
    22.500   966.946
    23.000   968.841
    23.500   970.773
    24.000   972.741
    24.500   974.744
    25.000   976.783
    25.500   978.858
    26.000   980.967
    26.500   983.111
    27.000   985.289
    27.500   987.501
    28.000   989.746
    28.500   992.025
    29.000   994.337
    29.500   996.681
    30.000   999.057
    30.500  1001.466
    31.000  1003.906
    31.500  1006.378
    32.000  1008.880
    32.500  1011.413
    33.000  1013.976
    33.500  1016.569
    34.000  1019.192
    34.500  1021.844
    35.000  1024.525
    35.500  1027.234
    36.000  1029.972
    36.500  1032.738
    37.000  1035.531
    37.500  1038.351
    38.000  1041.198
    38.500  1044.072
    39.000  1046.972
    39.500  1049.898
    40.000  1052.850
    40.500  1055.826
    41.000  1058.828
    41.500  1061.854
    42.000  1064.904
    42.500  1067.978
    43.000  1071.076
    43.500  1074.197
    44.000  1077.341
    44.500  1080.507
    45.000  1083.696
    45.500  1086.906
    46.000  1090.139
    46.500  1093.392
    47.000  1096.667
    47.500  1099.962
    48.000  1103.277
    48.500  1106.613
    49.000  1109.969
    49.500  1113.343
    50.000  1116.737
    50.500  1120.150
    51.000  1123.582
    51.500  1127.031
    52.000  1130.499
    52.500  1133.984
    53.000  1137.487
    53.500  1141.006
    54.000  1144.543
    54.500  1148.096
    55.000  1151.666
    55.500  1155.251
    56.000  1158.852
    56.500  1162.468
    57.000  1166.100
    57.500  1169.746
    58.000  1173.407
    58.500  1177.083
    59.000  1180.772
    59.500  1184.475
    60.000  1188.192
    60.500  1191.922
    61.000  1195.666
    61.500  1199.422
    62.000  1203.190
    62.500  1206.971
    63.000  1210.764
    63.500  1214.569
    64.000  1218.385
    64.500  1222.213
    65.000  1226.052
    65.500  1229.902
    66.000  1233.763
    66.500  1237.634
    67.000  1241.515
    67.500  1245.406
    68.000  1249.307
    68.500  1253.218
    69.000  1257.137
    69.500  1261.066
    70.000  1265.004
    70.500  1268.951
    71.000  1272.906
    71.500  1276.870
    72.000  1280.842
    72.500  1284.821
    73.000  1288.809
    73.500  1292.803
    74.000  1296.806
    74.500  1300.815
    75.000  1304.831
    75.500  1308.854
    76.000  1312.884
    76.500  1316.920
    77.000  1320.963
    77.500  1325.011
    78.000  1329.066
    78.500  1333.126
    79.000  1337.191
    79.500  1341.262
    80.000  1345.338
    80.500  1349.420
    81.000  1353.506
    81.500  1357.596
    82.000  1361.692
    82.500  1365.792
    83.000  1369.896
    83.500  1374.004
    84.000  1378.116
    84.500  1382.232
    85.000  1386.352
    85.500  1390.475
    86.000  1394.601
    86.500  1398.731
    87.000  1402.864
    87.500  1407.000
    88.000  1411.138
    88.500  1415.280
    89.000  1419.424
    89.500  1423.570
    90.000  1427.719
    90.500  1431.869
    91.000  1436.022
    91.500  1440.177
    92.000  1444.333
    92.500  1448.492
    93.000  1452.652
    93.500  1456.813
    94.000  1460.976
    94.500  1465.139
    95.000  1469.304
    95.500  1473.470
    96.000  1477.637
    96.500  1481.805
    97.000  1485.973
    97.500  1490.142
    98.000  1494.312
    98.500  1498.481
    99.000  1502.651
    99.500  1506.822
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    28.500   756.973
    29.000   767.212
    29.500   777.451
    30.000   787.688
    30.500   797.922
    31.000   808.154
    31.500   818.381
    32.000   828.604
    32.500   838.821
    33.000   849.032
    33.500   859.235
    34.000   869.429
    34.500   879.614
    35.000   889.787
    35.500   899.949
    36.000   910.096
    36.500   920.229
    37.000   930.346
    37.500   940.446
    38.000   950.007
    38.500   960.586
    39.000   970.624
    39.500   980.638
    40.000   990.626
    40.500  1000.589
    41.000  1010.523
    41.500  1020.429
    42.000  1030.303
    42.500  1040.146
    43.000  1049.955
    43.500  1059.730
    44.000  1069.469
    44.500  1079.171
    45.000  1088.836
    45.500  1097.383
    46.000  1105.545
    46.500  1113.690
    47.000  1121.819
    47.500  1129.930
    48.000  1138.026
    48.500  1146.105
    49.000  1154.165
    49.500  1162.203
    50.000  1170.211
    50.500  1178.169
    51.000  1186.091
    51.500  1194.003
    52.000  1201.909
    52.500  1209.810
    53.000  1217.706
    53.500  1225.598
    54.000  1233.486
    54.500  1241.371
    55.000  1249.252
    55.500  1257.129
    56.000  1265.004
    56.500  1272.875
    57.000  1280.742
    57.500  1288.607
    58.000  1296.468
    58.500  1304.325
    59.000  1312.180
    59.500  1320.030
    60.000  1327.877
    60.500  1335.719
    61.000  1343.557
    61.500  1351.390
    62.000  1359.218
    62.500  1367.039
    63.000  1374.855
    63.500  1382.664
    64.000  1390.467
    64.500  1398.262
    65.000  1406.050
    65.500  1413.829
    66.000  1421.601
    66.500  1429.364
    67.000  1437.118
    67.500  1444.864
    68.000  1452.600
    68.500  1460.327
    69.000  1468.044
    69.500  1475.752
    70.000  1483.451
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     0.147     8.617     0.150
     0.147    10.617     0.150
     0.147     9.516     0.150
     0.287     9.617     0.150
     0.287    20.617     0.150
     0.287    10.414     0.150
     0.287    10.414     0.150
     0.287    19.617     0.150
     0.287    17.617     0.150
     0.719    56.617     0.150
     0.719    74.617     0.150
     0.719    88.617     0.150
     0.719    23.617     0.150
     1.192    38.617     0.150
     1.192    39.617     0.150
     1.192    39.617     0.150
     1.600    23.617     0.150
     1.600    23.617     0.150
     1.600    23.617     0.150
     1.600    43.820     0.150
     1.600    24.414     0.150
     1.600   -34.680     0.150
     1.600    24.414     0.150
     1.600    28.516     0.150
     1.600    43.617     0.150
     1.623    25.820     0.150
     1.623    25.820     0.150
     1.623    62.219     0.150
     1.834    28.617     0.150
     1.834    54.617     0.150
     1.834    29.320     0.150
     1.834    56.617     0.150
     1.930    55.617     0.150
     1.930    93.617     0.150
     1.989    32.617     0.150
     2.069    34.719     0.150
     2.069    60.016     0.150
     2.079    63.617     0.150
     2.079    63.617     0.150
     2.079    64.617     0.150
     2.112    33.320     0.150
     2.240    56.617     0.150
     2.240    33.617     0.150
     2.240    88.617     0.150
     2.240    33.617     0.150
     2.240    56.617     0.150
     2.261    77.617     0.150
     2.261    97.617     0.150
     2.710    42.719     0.150
     2.710    42.719     0.150
     2.924    45.617     0.150
     2.924    45.617     0.150
     2.924    45.719     0.150
     2.924    45.719     0.150
     2.924    48.516     0.150
     2.924    45.617     0.150
     3.384    52.320     0.150
     3.384    70.320     0.150
     3.390    98.617     0.150
     3.396    71.117     0.150
     3.396    88.117     0.150
     3.396    71.117     0.150
     3.396    70.617     0.150
     4.032    61.219     0.150
     4.032    77.320     0.150
     4.032    61.219     0.150
     4.032    96.414     0.150
     4.149    74.516     0.150
     4.149    74.617     0.150
     4.301    64.320     0.150
     4.301    72.914     0.150
     4.301    64.320     0.150
     4.301    74.914     0.150
     4.494    67.219     0.150
     4.494    67.219     0.150
     4.494   115.617     0.150
     4.896   132.914     0.150
     4.896   132.617     0.150
     5.322   111.516     0.150
     5.322   174.320     0.150
     5.322   253.617     0.150
     5.322   111.617     0.150
     5.532   117.320     0.150
     5.532   120.516     0.150
     5.532   117.320     0.150
     5.532   117.617     0.150
     5.552    82.719     0.150
     5.552    82.617     0.150
     5.552   141.617     0.150
     5.626   104.516     0.150
     5.626    81.617     0.150
     6.178   157.617     0.150
     6.196    89.414     0.150
     6.196   110.219     0.150
     6.196    89.414     0.150
     6.196   124.820     0.150
     6.196   156.617     0.150
     6.346    90.320     0.150
     6.346    90.617     0.150
     6.606    97.016     0.150
     6.606   193.516     0.150
     6.738   108.320     0.150
     6.738   200.219     0.150
     6.738   108.617     0.150
     6.738   200.617     0.150
     6.808   107.414     0.150
     6.808   107.617     0.150
     6.831   200.617     0.150
     6.831    98.617     0.150
     6.831    98.617     0.150
     6.831   118.617     0.150
     6.831    98.617     0.150
     6.831   200.617     0.150
     6.831   221.617     0.150
     6.859   106.914     0.150
     6.859   187.914     0.150
     6.859   106.617     0.150
     6.859   187.617     0.150
     6.965   113.016     0.150
     6.965   112.617     0.150
     7.025   103.016     0.150
     7.025   152.617     0.150
     7.025   103.016     0.150
     7.165   101.617     0.150
     7.165   101.617     0.150
     7.184   112.820     0.150
     7.184   112.617     0.150
     7.288   106.016     0.150
     7.448   112.719     0.150
     7.448   215.516     0.150
     7.448   112.617     0.150
     7.448   215.617     0.150
     7.521   116.117     0.150
     7.521   193.219     0.150
     7.521   115.617     0.150
     7.725   239.320     0.150
     7.725   112.219     0.150
     7.725   239.617     0.150
     7.814   197.516     0.150
     7.814   197.617     0.150
     7.823   113.719     0.150
     7.823   113.719     0.150
     7.823   113.617     0.150
     7.867   129.320     0.150
     7.867   256.219     0.150
     7.867   129.617     0.150
     7.867   256.617     0.150
     7.998   198.117     0.150
     7.998   270.516     0.150
     8.120   135.516     0.150
     8.120   135.617     0.150
     8.429   247.016     0.150
     8.429   120.617     0.150
     8.429   246.617     0.150
     8.532   134.617     0.150
     8.532   252.617     0.150
     8.532   134.617     0.150
     8.532   252.617     0.150
     8.522   143.914     0.150
     8.522   236.117     0.150
     8.522   143.617     0.150
     8.522   235.617     0.150
     9.015   134.914     0.150
     9.015   253.516     0.150
     9.015   134.617     0.150
     9.015   253.617     0.150
     9.234   210.820     0.150
     9.234   132.719     0.150
     9.234   261.219     0.150
     9.234   210.617     0.150
     9.234   261.617     0.150
     9.446   136.617     0.150
     9.593   155.617     0.150
     9.593   274.617     0.150
     9.606   155.617     0.150
     9.606   274.617     0.150
     9.661   132.219     0.150
     9.661   132.617     0.150
     9.767   162.320     0.150
     9.767   162.320     0.150
     9.767   162.617     0.150
     9.798    92.617     0.150
    10.183   154.117     0.150
    10.183   198.414     0.150
    10.183   154.117     0.150
    10.183   234.414     0.150
    10.183   153.617     0.150
    10.183   282.617     0.150
    10.214   139.219     0.150
    10.214   169.016     0.150
    10.214   139.219     0.150
    10.214   264.219     0.150
    10.214   139.617     0.150
    10.214   264.617     0.150
    10.512   186.219     0.150
    10.512   310.820     0.150
    10.512   186.617     0.150
    10.512   310.617     0.150
    10.636   143.617     0.150
    11.498   186.016     0.150
    11.498   314.117     0.150
    11.498   185.617     0.150
    11.498   313.617     0.150
    12.780   365.516     0.150
    12.780   180.719     0.150
    12.780   428.820     0.150
    13.178   203.617     0.150
    13.254   182.617     0.150
    13.254   360.617     0.150
    13.254   182.617     0.150
    13.254   519.617     0.150
    13.254   182.617     0.150
    13.254   360.617     0.150
    15.008   383.617     0.150
    20.419    22.000     0.150
    21.430   277.617     0.150
    21.847    21.000     0.150
    30.346   424.617     0.150
    31.287   679.617     0.150
    31.305   372.617     0.150
    37.355   425.617     0.150
    37.355   775.617     0.150
    58.560   573.617     0.150
    58.560  1053.617     0.150
    60.781    25.000     0.150
    62.177   690.617     0.150
    62.177   613.617     0.150
    62.177   690.617     0.150
    62.177  1115.617     0.150
    64.454   626.617     0.150
    64.454  1137.617     0.150
    67.678   653.617     0.150
    68.911   656.617     0.150
    68.911    23.000     0.150
    70.989   683.617     0.150
    71.613    20.000     0.150
    73.674   705.617     0.150
    73.674    19.000     0.150
    73.674  1274.617     0.150
    75.567   711.617     0.150
    76.259   711.617     0.150
    77.280   728.617     0.150
    77.333   720.617     0.150
    77.772   710.617     0.150
    77.772  1298.617     0.150
    77.772  1326.617     0.150
    79.534    26.000     0.150
    80.759  1300.617     0.150
    80.963  1026.617     0.150
    81.424   756.617     0.150
    81.424  1329.617     0.150
    81.424   730.617     0.150
    81.424  1329.617     0.150
    85.027    14.000     0.150
    86.716   759.617     0.150
    90.645   798.617     0.150
   104.413   931.617     0.150
   104.413  1113.617     0.150
    10.636   143.617     0.150
     0.469    20.473     0.150
     0.469    12.473     0.150
     0.836    32.473     0.150
     0.836    14.473     0.150
     0.836    32.172     0.150
     0.764    27.572     0.150
     0.878    17.473     0.150
     0.878    30.773     0.150
     1.748    29.473     0.150
     1.595    65.473     0.150
     1.595    65.072     0.150
     1.884    28.473     0.150
     2.082    54.473     0.150
     2.082    31.473     0.150
     2.082    54.973     0.150
     2.204    33.473     0.150
     2.204    57.373     0.150
     2.372    57.473     0.150
     2.372    84.473     0.150
     2.372    57.473     0.150
     2.372    84.373     0.150
     2.424    37.473     0.150
     2.424    65.572     0.150
     2.532    38.473     0.150
     2.790    44.473     0.150
     2.790    44.172     0.150
     2.790    76.473     0.150
     2.793    80.473     0.150
     2.793    80.473     0.150
     3.034    45.473     0.150
     3.533    54.273     0.150
     3.533 -3184.527     0.150
     3.540    87.473     0.150
     3.335  -450.527     0.150
     3.335    50.473     0.150
     3.335    50.773     0.150
     3.335    54.273     0.150
     3.805   110.473     0.150
     3.805    58.373     0.150
     3.805 -3489.627     0.150
     3.880    60.473     0.150
     4.091   121.473     0.150
     4.353 -3488.127     0.150
     4.353    63.473     0.150
     4.748    67.473     0.150
     4.598 -3477.828     0.150
     4.598    69.473     0.150
     4.647 -3479.127     0.150
     4.647    68.072     0.150
     4.647 -3477.428     0.150
     4.878 -3471.227     0.150
     5.250    76.572     0.150
     5.250 -3460.627     0.150
     5.250    76.473     0.150
     5.761   157.473     0.150
     5.761 -3442.928     0.150
     5.826    83.473     0.150
     5.826 -3447.727     0.150
     5.897   156.473     0.150
     5.897    85.572     0.150
     5.897 -3443.828     0.150
     5.897    85.473     0.150
     6.102   -27.428     0.150
     6.102    62.273     0.150
     6.484 -3435.527     0.150
     6.484    92.473     0.150
     6.541    94.373     0.150
     6.541 -3433.328     0.150
     6.709 -3430.627     0.150
     6.786   172.473     0.150
     6.786    98.373     0.150
     6.786 -3427.027     0.150
     6.987   192.473     0.150
     6.987   100.572     0.150
     6.987 -3407.428     0.150
     6.987   100.473     0.150
     6.981 -3420.727     0.150
     6.981   100.473     0.150
     7.079   169.473     0.150
     7.079   101.473     0.150
     7.079 -3430.627     0.150
     7.165    49.973     0.150
     7.165 -3472.828     0.150
     7.302   106.572     0.150
     7.302 -3409.627     0.150
     7.302   106.473     0.150
     7.254   194.473     0.150
     7.254 -3405.527     0.150
     7.261   203.473     0.150
     7.261 -3396.127     0.150
     7.333   194.473     0.150
     7.333 -3405.627     0.150
     7.326   225.473     0.150
     7.351   104.373     0.150
     7.351 -3412.727     0.150
     7.629   200.473     0.150
     7.629   110.473     0.150
     7.629   200.873     0.150
     7.607   207.473     0.150
     7.607   111.572     0.150
     7.607   207.273     0.150
     7.612   110.572     0.150
     7.612   110.473     0.150
     7.612   195.373     0.150
     7.889   117.773     0.150
     7.889   117.473     0.150
     8.046   117.572     0.150
     8.046   207.572     0.150
     8.027   120.473     0.150
     8.027   272.473     0.150
     8.027   120.072     0.150
     8.027   272.273     0.150
     8.164   205.473     0.150
     8.164   117.473     0.150
     8.164   205.572     0.150
     8.164   115.473     0.150
     8.272   216.473     0.150
     8.272   120.473     0.150
     8.272   216.072     0.150
     8.320   117.473     0.150
     8.320   208.572     0.150
     8.489   121.473     0.150
     8.489   181.373     0.150
     8.489   344.172     0.150
     8.639   147.473     0.150
     8.639   251.473     0.150
     8.639   147.473     0.150
     8.639   251.572     0.150
     8.639   147.473     0.150
     8.639   268.672     0.150
     8.921   231.473     0.150
     8.651   154.473     0.150
     8.651   154.172     0.150
     8.889   231.473     0.150
     8.889   131.672     0.150
     8.889   131.473     0.150
     8.889   231.273     0.150
     8.958   127.473     0.150
     8.958   232.873     0.150
     9.029   131.873     0.150
     9.029   255.172     0.150
     9.000   245.473     0.150
     9.000   131.473     0.150
     9.000   245.473     0.150
     9.226   136.373     0.150
     9.226   237.572     0.150
     9.448   191.473     0.150
     9.448   139.672     0.150
     9.448   139.473     0.150
     9.448   191.672     0.150
     9.548   142.473     0.150
     9.548   182.473     0.150
     9.548   142.973     0.150
     9.548   142.473     0.150
     9.548   182.072     0.150
     9.692   135.473     0.150
     9.692   248.473     0.150
     9.692   135.373     0.150
     9.692   134.473     0.150
     9.692   248.072     0.150
     9.739   140.473     0.150
     9.739   140.172     0.150
     9.739   139.473     0.150
     9.739   239.572     0.150
     9.893   143.473     0.150
    10.043   266.473     0.150
    10.061   145.473     0.150
    10.061   266.473     0.150
    10.226   148.572     0.150
    10.231   138.473     0.150
    10.231   138.373     0.150
    10.231   260.373     0.150
    10.221   151.473     0.150
    10.221   270.473     0.150
    10.221   151.473     0.150
    10.221   270.473     0.150
    10.389   152.473     0.150
    10.389   305.473     0.150
    10.389   152.873     0.150
    10.389   305.273     0.150
    10.596   281.473     0.150
    10.596   154.572     0.150
    10.596   154.473     0.150
    10.596   281.773     0.150
    10.645   268.473     0.150
    10.645   152.572     0.150
    10.645   152.473     0.150
    10.645   268.873     0.150
    10.876   282.473     0.150
    10.876   153.473     0.150
    10.876   282.973     0.150
    10.924   161.473     0.150
    10.924   295.473     0.150
    10.924   161.273     0.150
    10.924   295.773     0.150
    10.933   158.473     0.150
    10.933   158.973     0.150
    10.933   158.473     0.150
    10.933   234.873     0.150
    10.933   158.973     0.150
    10.933   283.572     0.150
    11.028   159.473     0.150
    11.116   280.473     0.150
    11.261   297.473     0.150
    11.261   297.473     0.150
    11.859   307.473     0.150
    11.859   307.273     0.150
    11.871   310.473     0.150
    11.871   170.572     0.150
    11.871   170.473     0.150
    11.871   310.973     0.150
    11.974   311.473     0.150
    11.974   311.072     0.150
    12.003   170.473     0.150
    12.003   170.873     0.150
    12.179   305.473     0.150
    12.179   305.373     0.150
    12.179   171.873     0.150
    12.179   190.373     0.150
    12.179   171.873     0.150
    12.179   324.873     0.150
    12.881   344.473     0.150
    13.183   181.473     0.150
    13.183   181.473     0.150
    13.282   188.473     0.150
    13.282   339.473     0.150
    13.282   188.172     0.150
    13.282   339.273     0.150
    13.778   347.473     0.150
    13.778   194.473     0.150
    13.778   347.473     0.150
    14.055   344.473     0.150
    14.055   344.873     0.150
    14.118   195.473     0.150
    14.118   341.473     0.150
    14.118   195.873     0.150
    14.118   195.473     0.150
    14.118   341.672     0.150
    14.368   364.473     0.150
    14.368   202.473     0.150
    14.368   364.072     0.150
    14.431   203.473     0.150
    14.431   370.473     0.150
    14.583   197.473     0.150
    14.583   392.473     0.150
    14.673   202.473     0.150
    14.673   202.473     0.150
    15.133   419.473     0.150
    15.133   213.373     0.150
    15.133   419.172     0.150
    15.133   213.373     0.150
    16.004   222.572     0.150
    21.533   276.473     0.150
    25.273   591.473     0.150
    26.015   639.473     0.150
    26.439   339.473     0.150
    26.771   343.473     0.150
    26.842   340.473     0.150
    27.222   365.473     0.150
    27.222   722.473     0.150
    27.595   350.473     0.150
    27.675   635.473     0.150
    27.856   355.473     0.150
    28.040   647.473     0.150
    28.651   695.473     0.150
    30.359   359.473     0.150
    30.359   646.473     0.150
    30.359   877.473     0.150
    31.844   685.473     0.150
    31.854   677.473     0.150
    33.868   416.473     0.150
    33.868   736.473     0.150
    37.901   517.473     0.150
    37.901   779.473     0.150
    42.794   476.473     0.150
    42.794   517.473     0.150
    45.596   614.473     0.150
    46.854   497.473     0.150
    47.538   602.473     0.150
    47.939   506.473     0.150
    47.939   616.473     0.150
    47.967   514.473     0.150
    48.381   927.473     0.150
    49.706   527.473     0.150
    49.706   644.473     0.150
    49.994   534.473     0.150
    51.063   537.473     0.150
    51.063   985.473     0.150
    52.519   553.473     0.150
    52.519  1000.473     0.150
    53.219   683.473     0.150
    53.219   997.473     0.150
    53.930   559.473     0.150
    53.844   559.473     0.150
    54.718  1013.473     0.150
    58.733   801.473     0.150
    58.733  1175.473     0.150
    58.733  1452.473     0.150
    58.733   588.473     0.150
    58.733   801.473     0.150
    58.733  1068.473     0.150
    58.893  1069.473     0.150
    59.038   591.473     0.150
    59.038   729.473     0.150
    59.803   746.473     0.150
    59.803  1014.473     0.150
    60.439   717.473     0.150
    61.997   763.473     0.150
    62.311   612.473     0.150
    62.311  2367.473     0.150
    62.091   840.473     0.150
    62.745  2368.473     0.150
    63.815  1155.473     0.150
    65.290   851.473     0.150
    65.812   644.473     0.150
    65.812  1190.473     0.150
    66.654   648.473     0.150
    66.871  1187.473     0.150
    67.549  1192.473     0.150
    68.734   648.473     0.150
    69.094   909.473     0.150
    69.094  1411.473     0.150
    69.094  1479.473     0.150
    69.094  1656.473     0.150
    69.094   656.473     0.150
    69.094  1191.473     0.150
    69.094  1230.473     0.150
    68.893   662.473     0.150
    69.145  1195.473     0.150
    69.602   664.473     0.150
    69.153   666.473     0.150
    69.153  1197.473     0.150
    69.802  1193.473     0.150
    72.603   821.473     0.150
    72.663   680.473     0.150
    73.344  1220.473     0.150
    73.707   853.473     0.150
    73.707  1248.473     0.150
    75.377  1282.473     0.150
    75.341   725.473     0.150
    75.823  1274.473     0.150
    75.886   709.473     0.150
    75.886  1285.473     0.150
    76.368   705.473     0.150
    76.030    27.000     0.150
    76.030  1287.473     0.150
    77.219   712.473     0.150
    77.496   883.473     0.150
    77.496  1062.473     0.150
    77.496  1292.473     0.150
    77.496  1319.473     0.150
    77.496  1333.473     0.150
    77.496  1333.473     0.150
    77.496  1345.473     0.150
    77.496  1351.473     0.150
    77.496  1792.473     0.150
    77.496   707.473     0.150
    77.496  1292.473     0.150
    77.496  1333.473     0.150
    77.368   713.473     0.150
    77.978   856.473     0.150
    78.208   715.473     0.150
    78.208   875.473     0.150
    78.248   719.473     0.150
    78.278   704.473     0.150
    78.461   879.473     0.150
    78.613   723.473     0.150
    78.265   718.473     0.150
    78.265   907.473     0.150
    78.265  1311.473     0.150
    78.693   694.473     0.150
    78.693   874.473     0.150
    78.693  1282.473     0.150
    78.696   884.473     0.150
    78.733  1304.473     0.150
    78.945   721.473     0.150
    78.977  1325.473     0.150
    79.639   723.473     0.150
    79.639  1504.473     0.150
    79.666   723.473     0.150
    79.787   895.473     0.150
    79.973   735.473     0.150
    79.760  1931.473     0.150
    80.968  1332.473     0.150
    81.366   730.473     0.150
    81.421   732.473     0.150
    81.554  1643.473     0.150
    81.594   751.473     0.150
    81.594  1711.473     0.150
    81.594   729.473     0.150
    81.594   915.473     0.150
    81.594  1337.473     0.150
    81.626  1337.473     0.150
    81.797  1340.473     0.150
    82.077   735.473     0.150
    82.077    32.000     0.150
    82.146   731.473     0.150
    82.789  1055.473     0.150
    82.512   743.473     0.150
    82.512   766.473     0.150
    83.152   870.473     0.150
    83.269  1353.473     0.150
    83.375   742.473     0.150
    83.776   747.473     0.150
    83.776   789.473     0.150
    84.017  2291.473     0.150
    84.079   741.473     0.150
    84.308   742.473     0.150
    84.376   750.473     0.150
    84.376  1311.473     0.150
    84.401  1382.473     0.150
    84.401   927.473     0.150
    84.540  2267.473     0.150
    84.445   955.473     0.150
    84.855   778.473     0.150
    85.649   741.473     0.150
    85.599  1372.473     0.150
    85.648  1672.473     0.150
    87.190   969.473     0.150
    87.048   754.473     0.150
    86.972  1415.473     0.150
    87.723   975.473     0.150
    87.723  1384.473     0.150
    88.500  1467.473     0.150
    87.972   769.473     0.150
    90.303   778.473     0.150
    90.917  1405.473     0.150
    91.033   964.473     0.150
    91.033  1376.473     0.150
    91.897  1625.473     0.150
    92.420  1385.473     0.150
    93.332   782.473     0.150
    93.609  1392.473     0.150
    94.155   799.473     0.150
    99.044   820.473     0.150
    11.116   280.672     0.150
   107.116   857.473     0.150
   107.116  1129.473     0.150
   109.947   885.473     0.150
   109.947  1504.473     0.150
   111.232  1111.473     0.150
   112.159   891.473     0.150
   112.159  1171.473     0.150
   113.562  1099.473     0.150
   115.340   891.473     0.150
   115.772  1163.473     0.150
   115.774  1121.473     0.150
   116.124  1193.473     0.150
   116.264  1176.473     0.150
   120.153  1196.473     0.150
   120.816  1132.473     0.150
   120.677  1126.473     0.150
   121.407  1132.473     0.150
   121.861  1157.473     0.150
   121.944  1132.473     0.150
   122.422  1223.473     0.150
   122.841  1121.473     0.150
   125.259  1259.473     0.150
   129.517  1146.473     0.150
   129.517  1294.473     0.150
   132.087  1132.473     0.150
   132.087  1152.473     0.150
   132.435  1128.473     0.150
   142.404  1189.973     0.150
   142.404  1414.473     0.150
   142.404  2003.473     0.150
   142.454  1414.473     0.150
     0.734    16.355     0.150
     1.654    44.656     0.150
     3.422    95.656     0.150
     3.422    90.656     0.150
     4.171   117.656     0.150
     6.619   178.656     0.150
     6.837   104.656     0.150
     6.977   105.656     0.150
     7.462   190.656     0.150
     7.533   192.656     0.150
     7.824   117.656     0.150
     8.414   219.656     0.150
     8.551   233.656     0.150
     8.798   132.656     0.150
     9.035   135.656     0.150
    21.462   277.656     0.150
    52.302   543.656     0.150
    55.518   569.656     0.150
    65.165   632.457     0.150
    70.112   668.156     0.150
    72.223    25.000     0.150
    74.530    39.801     0.150
    77.321    23.199     0.150
     0.285     7.684     0.150
     0.285    12.983     0.150
     0.764    15.783     0.150
     1.221    20.283     0.150
     1.626    43.983     0.150
     3.390    88.983     0.150
     4.114    55.983     0.150
     4.114   102.983     0.150
     4.260    59.983     0.150
     6.155    89.983     0.150
     7.148   106.983     0.150
     8.367   219.983     0.150
     9.201   128.983     0.150
     9.201   241.983     0.150
    18.053   240.983     0.150
    18.053   436.983     0.150
    21.474   507.983     0.150
    24.168   304.983     0.150
    31.283    23.000     0.150
    31.283   460.983     0.150
    37.338     8.500     0.150
    37.338   801.983     0.150
    44.020     9.000     0.150
    45.003   487.684     0.150
    46.850   522.483     0.150
    51.239   534.983     0.150
    52.287   543.983     0.150
    57.310   578.983     0.150
    61.495   622.983     0.150
    62.220   614.384     0.150
    63.974  1142.983     0.150
    66.082   637.983     0.150
    66.082  1150.983     0.150
    66.082  1624.983     0.150
    69.766   670.384     0.150
    69.766    11.600     0.150
    69.881    10.600     0.150
    71.592   676.983     0.150
    72.145   675.583     0.150
    73.814   691.983     0.150
    75.605   637.983     0.150
    76.791   645.983     0.150
    77.321   712.983     0.150
    77.321   824.983     0.150
    77.288   713.983     0.150
    77.555   717.483     0.150
    78.127   710.983     0.150
    78.368    19.500     0.150
    78.368   752.983     0.150
    78.875   715.184     0.150
    81.230   726.983     0.150
    81.230    27.000     0.150
    81.230   990.983     0.150
    81.230  1402.983     0.150
    84.881   963.983     0.150
     0.122    11.820     0.150
     0.349    18.117     0.150
     1.665    44.117     0.150
     6.183    91.117     0.150
    54.905   561.117     0.150
    64.471   631.117     0.150
    68.177   652.516     0.150
    69.814   663.719     0.150
    72.216   688.117     0.150
    75.292   694.117     0.150
     1.617    44.195     0.150
     2.720    44.195     0.150
     4.908   126.195     0.150
     8.379   205.195     0.150
    12.288   175.695     0.150
    21.435   276.195     0.150
    21.435   507.195     0.150
    59.117   634.195     0.150
    62.040   627.992     0.150
    70.041   669.195     0.150
    70.073   689.195     0.150
    71.594   760.195     0.150
    71.594   906.195     0.150
    75.246   862.195     0.150
    78.337   749.195     0.150
    81.197   730.398     0.150
    82.387   675.195     0.150
    83.900   743.594     0.150
    84.198   745.297     0.150
    89.224   787.195     0.150
   146.591  1178.094     0.150
     1.239    20.090     0.150
     1.560    43.090     0.150
     4.606   128.090     0.150
     4.709   128.090     0.150
    21.423   277.090     0.150
    51.221   533.090     0.150
    70.185   669.090     0.150
    72.264   692.090     0.150
    73.840   698.090     0.150
    77.262   710.090     0.150
    78.310   711.590     0.150
    80.965  1184.090     0.150
   142.602  2481.090     0.150
     0.525    24.047     0.150
     0.661    11.445     0.150
     0.661    20.047     0.150
     1.754    47.047     0.150
    62.584   615.047     0.150
    77.648   708.547     0.150
     1.332    35.658     0.150
     1.978    29.358     0.150
     6.291    95.658     0.150
     6.424   169.658     0.150
     6.786   174.658     0.150
     7.131   192.658     0.150
     8.178   215.658     0.150
    10.819   279.658     0.150
    21.410   286.658     0.150
    57.498   580.658     0.150
    59.086   595.658     0.150
    60.677   604.958     0.150
    61.242   609.658     0.150
    62.125   614.858     0.150
    62.462   648.658     0.150
    64.238   631.658     0.150
    65.932  1600.658     0.150
    67.550   650.458     0.150
    67.524     8.300     0.150
    69.768   679.658     0.150
    71.755    10.000     0.150
    71.755    21.000     0.150
    75.415   699.658     0.150
    75.415    14.000     0.150
    75.736   701.658     0.150
    75.736   707.658     0.150
    77.162   710.658     0.150
    77.618   711.658     0.150
    77.642   712.158     0.150
    78.667   716.658     0.150
    78.705   717.158     0.150
    80.376   727.658     0.150
    83.426   743.658     0.150
    83.856   743.158     0.150
    83.902   744.258     0.150
    84.302   746.358     0.150
     0.099    11.790     0.150
     1.271    32.790     0.150
     1.299    36.790     0.150
     3.311    58.790     0.150
    10.985   159.690     0.150
    68.730   655.790     0.150
     0.167    10.703     0.150
     1.232    36.703     0.150
     1.471    25.703     0.150
     2.018    45.703     0.150
     3.345    55.703     0.150
     3.986   108.703     0.150
     4.671    73.902     0.150
     6.678   198.703     0.150
     7.336   110.004     0.150
     9.981   144.504     0.150
    42.714   472.703     0.150
    51.921   544.703     0.150
    60.515   610.703     0.150
    61.958   615.104     0.150
    65.781   645.703     0.150
    68.663   664.004     0.150
    78.064   714.703     0.150
    78.154   718.004     0.150
    78.496   714.703     0.150
    90.841   841.004     0.150
     1.599    44.146     0.150
     6.832   172.146     0.150
     7.026   182.146     0.150
     7.449   205.146     0.150
     7.726   116.846     0.150
     8.532   234.146     0.150
    12.304   189.146     0.150
    15.007   398.146     0.150
    18.008    50.000     0.150
    24.635   576.146     0.150
    32.182   686.146     0.150
    33.417   718.146     0.150
    37.355    23.000     0.150
    55.816   578.146     0.150
    58.398   584.146     0.150
    59.110   814.146     0.150
    61.278    11.000     0.150
    61.278   643.146     0.150
    62.040   630.146     0.150
    63.187  1130.146     0.150
    64.453  1144.146     0.150
    66.041   645.146     0.150
    66.041  1166.146     0.150
    68.729  1206.146     0.150
    71.549   677.246     0.150
    71.940   664.146     0.150
    73.003   680.446     0.150
    75.566   706.146     0.150
    75.566    19.800     0.150
    75.649   695.146     0.150
    75.662   692.146     0.150
    75.892    19.200     0.150
    75.892   894.146     0.150
    76.908   705.146     0.150
    77.279   711.146     0.150
    77.279    18.000     0.150
    78.186   713.146     0.150
    78.327    31.000     0.150
    78.327  1300.146     0.150
    78.621   713.146     0.150
    78.700   714.046     0.150
    81.108   727.346     0.150
    84.716   747.146     0.150
    84.746   739.146     0.150
    84.746    31.000     0.150
    84.746  1096.146     0.150
    86.139   749.146     0.150
    87.351   751.646     0.150
   111.681  1102.646     0.150
   121.277  1126.146     0.150
   132.006  1300.146     0.150
     0.124     7.188     0.150
     0.356    17.586     0.150
     0.356     9.086     0.150
     0.562    10.387     0.150
     0.562     9.586     0.150
     0.562    20.887     0.150
     1.086    18.586     0.150
     1.086    32.586     0.150
     1.530    41.586     0.150
     1.530    23.586     0.150
     1.530    41.586     0.150
     1.529    22.586     0.150
     1.529    37.586     0.150
     1.529    22.586     0.150
     1.529    37.586     0.150
     1.630    25.484     0.150
     1.945    30.984     0.150
     1.842    28.785     0.150
     1.842    50.586     0.150
     1.882    29.086     0.150
     2.213    34.387     0.150
     2.021    30.586     0.150
     2.021    55.586     0.150
     2.213    35.086     0.150
     2.367    35.984     0.150
     2.862    43.586     0.150
     3.064    47.086     0.150
     3.518    55.188     0.150
     3.518    98.785     0.150
     3.476    52.785     0.150
     4.182    61.785     0.150
     4.280    65.086     0.150
     4.605   126.586     0.150
     4.605    65.586     0.150
     4.449    65.785     0.150
     4.636    68.785     0.150
     5.043   142.586     0.150
     5.043    74.387     0.150
     5.043   142.586     0.150
     5.453    82.285     0.150
     5.748    84.586     0.150
     5.748   165.586     0.150
     5.699   151.586     0.150
     5.699    82.785     0.150
     5.699    82.586     0.150
     5.699   151.887     0.150
     5.684    81.984     0.150
     5.684   147.586     0.150
     6.343   167.586     0.150
     6.329   176.586     0.150
     6.329    90.984     0.150
     6.329   176.188     0.150
     6.476   165.586     0.150
     6.476    95.086     0.150
     6.476   165.484     0.150
     6.541    92.586     0.150
     6.541   168.586     0.150
     6.747   182.586     0.150
     6.871   185.586     0.150
     6.871   101.387     0.150
     6.871   185.387     0.150
     6.924   186.586     0.150
     6.924   102.586     0.150
     6.924   186.586     0.150
     6.866   188.586     0.150
     6.866   100.586     0.150
     6.866   188.586     0.150
     6.965   100.984     0.150
     6.999   101.586     0.150
     7.109   102.785     0.150
     7.174   191.586     0.150
     7.174   102.586     0.150
     7.174   191.984     0.150
     7.290   196.586     0.150
     7.290   106.586     0.150
     7.290   196.586     0.150
     7.319   200.586     0.150
     7.319   107.586     0.150
     7.319   200.484     0.150
     7.589   108.984     0.150
     7.589   108.984     0.150
     7.589   108.586     0.150
     7.589   215.387     0.150
     7.693   202.586     0.150
     7.693   112.086     0.150
     7.693   202.887     0.150
     7.665   209.586     0.150
     7.665   111.387     0.150
     7.665   110.586     0.150
     7.665   209.086     0.150
     7.712   113.984     0.150
     7.805   215.785     0.150
     7.876   215.586     0.150
     7.960   112.188     0.150
     7.960   112.188     0.150
     7.960   111.586     0.150
     7.960   166.688     0.150
     7.970   205.586     0.150
     7.970   112.285     0.150
     7.970   205.387     0.150
     8.004   115.387     0.150
     8.004   114.586     0.150
     8.004   221.984     0.150
     8.343   119.586     0.150
     8.343   213.586     0.150
     8.343   119.586     0.150
     8.147   114.984     0.150
     8.147   193.586     0.150
     8.290   111.688     0.150
     8.290   206.285     0.150
     8.263   213.586     0.150
     8.560   230.586     0.150
     8.560   123.285     0.150
     8.560   230.188     0.150
     8.665   229.586     0.150
     8.688   229.586     0.150
     8.688   125.586     0.150
     8.688   229.887     0.150
     8.665   127.484     0.150
     8.752   124.586     0.150
     8.752   237.586     0.150
     8.752   124.586     0.150
     8.752   237.586     0.150
     8.903   129.188     0.150
     9.253   128.188     0.150
     9.253   127.586     0.150
     9.360   247.586     0.150
     9.360   135.086     0.150
     9.360   247.086     0.150
     9.419   135.688     0.150
     9.574   137.188     0.150
     9.622   134.586     0.150
     9.720   244.586     0.150
     9.774   140.887     0.150
     9.795   141.688     0.150
     9.891   141.785     0.150
     9.891   269.586     0.150
     9.932   141.086     0.150
     9.932   272.586     0.150
    10.031   145.984     0.150
    10.031   145.984     0.150
    10.031   285.387     0.150
    10.269   146.586     0.150
    10.292   321.586     0.150
    10.461   151.188     0.150
    10.549   149.984     0.150
    10.646   287.586     0.150
    10.646   152.586     0.150
    10.646   287.387     0.150
    10.687   276.586     0.150
    10.687   153.188     0.150
    10.687   276.086     0.150
    10.755   281.586     0.150
    10.755   152.484     0.150
    10.755   281.984     0.150
    11.200   284.586     0.150
    11.438   297.586     0.150
    11.438   163.285     0.150
    11.438   297.785     0.150
    11.438   163.285     0.150
    11.541   162.586     0.150
    11.541   374.586     0.150
    11.603   290.586     0.150
    11.603   164.984     0.150
    11.603   290.688     0.150
    11.799   304.586     0.150
    11.799   167.688     0.150
    11.799   304.387     0.150
    12.387   173.586     0.150
    12.530   116.785     0.150
    12.530   116.586     0.150
    12.530   213.586     0.150
    12.545   176.586     0.150
    12.545   336.887     0.150
    12.763   177.984     0.150
    12.763   177.984     0.150
    12.763   177.586     0.150
    13.357   337.586     0.150
    13.357   187.887     0.150
    13.357   337.586     0.150
    13.719   343.984     0.150
    14.260   396.586     0.150
    14.260   200.586     0.150
    14.260   396.984     0.150
    14.756   204.586     0.150
    14.756   404.586     0.150
    14.878   204.586     0.150
    14.878   204.586     0.150
    14.906   376.984     0.150
    17.853   244.586     0.150
    20.060   124.188     0.150
    20.060   123.586     0.150
    20.060   229.984     0.150
    20.518   273.586     0.150
    20.518   273.586     0.150
    20.518   510.586     0.150
    21.284   504.586     0.150
    21.284   279.586     0.150
    24.019   306.586     0.150
    24.738   581.586     0.150
    26.825   639.586     0.150
    27.867   345.586     0.150
    27.867   625.586     0.150
    27.867   345.586     0.150
    27.867   625.586     0.150
    28.391   348.586     0.150
    28.754   621.586     0.150
    29.860   364.586     0.150
    30.193   361.586     0.150
    30.193   707.586     0.150
    32.620   384.586     0.150
    33.541   719.586     0.150
    38.438   767.586     0.150
    38.780   791.586     0.150
    44.093   871.586     0.150
    44.093  1050.586     0.150
    46.738   507.586     0.150
    46.738   507.586     0.150
    47.243   508.586     0.150
    47.243   909.586     0.150
    48.799   934.586     0.150
    49.156   944.586     0.150
    49.156   520.586     0.150
    49.156   522.586     0.150
    49.156   944.586     0.150
    49.662   511.484     0.150
    51.316   966.586     0.150
    51.572   977.586     0.150
    51.639  1307.586     0.150
    52.147   980.586     0.150
    52.147   545.586     0.150
    52.147   980.586     0.150
    52.147   545.586     0.150
    53.382   555.586     0.150
    53.382  1001.586     0.150
    53.097  1012.586     0.150
    53.778   558.586     0.150
    53.778  1004.586     0.150
    55.830   799.586     0.150
    55.830  1174.586     0.150
    56.264  1069.586     0.150
    58.423  1069.586     0.150
    58.423   590.586     0.150
    58.423  1069.586     0.150
    58.549   585.887     0.150
    58.969   680.586     0.150
    58.969   810.586     0.150
    58.969  1278.586     0.150
    58.969  1414.586     0.150
    59.324   615.586     0.150
    59.805  1082.586     0.150
    59.805  1478.586     0.150
    60.608   606.586     0.150
    60.608  2361.586     0.150
    61.135   610.586     0.150
    61.135     7.199     0.150
    62.035   614.285     0.150
    62.366  2356.586     0.150
    62.361   619.586     0.150
    62.422   616.586     0.150
    62.195  1118.586     0.150
    63.120   623.586     0.150
    63.136  1127.586     0.150
    63.464   625.586     0.150
    63.819   627.586     0.150
    63.819  1136.586     0.150
    64.326   631.586     0.150
    64.326  1140.586     0.150
    64.679  1412.586     0.150
    64.679   632.586     0.150
    65.256   639.785     0.150
    65.256  1188.586     0.150
    65.256  1210.586     0.150
    65.256  1430.586     0.150
    65.256  1610.586     0.150
    65.418    15.602     0.150
    65.909     2.602     0.150
    65.909   707.586     0.150
    65.909   874.586     0.150
    65.909   924.586     0.150
    65.909  1109.586     0.150
    65.909  1254.586     0.150
    65.909  1388.586     0.150
    65.909  1610.586     0.150
    65.909  2351.586     0.150
    67.022   666.586     0.150
    67.022  1259.586     0.150
    67.022  1464.586     0.150
    68.024   692.586     0.150
    68.024   705.586     0.150
    68.024  1465.586     0.150
    67.841   657.586     0.150
    68.644   658.586     0.150
    68.775   691.586     0.150
    68.775   657.984     0.150
    68.775  1195.586     0.150
    68.684   714.586     0.150
    68.684  1199.586     0.150
    68.684  1674.586     0.150
    69.089   664.586     0.150
    69.089   664.586     0.150
    69.395   664.586     0.150
    69.395  1207.586     0.150
    69.409   661.785     0.150
    69.643   663.188     0.150
    69.623  1220.586     0.150
    69.623  1686.586     0.150
    70.382   669.586     0.150
    70.382  1216.586     0.150
    70.382   669.586     0.150
    71.410     1.301     0.150
    72.498   682.586     0.150
    73.733   689.586     0.150
    73.733  1254.586     0.150
    73.733   689.586     0.150
    73.783  1271.586     0.150
    73.884   691.586     0.150
    74.954     1.000     0.150
    75.443   797.586     0.150
    75.530  1275.586     0.150
    76.170  1784.586     0.150
    76.796     1.000     0.150
    77.150   874.586     0.150
    77.150  1307.586     0.150
    77.150   709.586     0.150
    77.150   853.586     0.150
    77.150   874.586     0.150
    77.150  1291.586     0.150
    77.150  1307.586     0.150
    77.150  2332.586     0.150
    77.806   708.285     0.150
    77.861   716.586     0.150
    78.050   715.285     0.150
    78.052   709.387     0.150
    78.082    16.000     0.150
    78.129   709.984     0.150
    78.196  2335.586     0.150
    78.322   716.586     0.150
    78.326  1308.586     0.150
    78.583   718.586     0.150
    79.127   723.285     0.150
    79.258  1320.586     0.150
    79.465   895.586     0.150
    79.465  1671.586     0.150
    79.666   724.387     0.150
    80.372  1034.586     0.150
    80.372  1040.586     0.150
    80.516  1332.586     0.150
    80.627  1326.586     0.150
    80.976   744.586     0.150
    81.052   730.785     0.150
    81.240   734.586     0.150
    81.291   751.586     0.150
    81.291   763.586     0.150
    81.291  1670.586     0.150
    81.291  1996.586     0.150
    81.422   924.586     0.150
    82.421   727.586     0.150
    82.925   750.586     0.150
    83.661   754.586     0.150
    83.661  1257.586     0.150
    83.757   745.086     0.150
    83.786   744.984     0.150
    84.055   746.785     0.150
    84.315   750.586     0.150
    84.664     7.000     0.150
    84.965  1688.586     0.150
    84.965  1928.586     0.150
    85.307   737.785     0.150
    85.307   907.586     0.150
    85.307  1034.586     0.150
    85.307  1353.586     0.150
    85.307  1369.586     0.150
    85.307  1641.586     0.150
    86.335    27.602     0.150
    86.335   797.586     0.150
    86.335   853.586     0.150
    86.739   766.586     0.150
    86.623   755.586     0.150
    89.373   939.586     0.150
    89.431     7.398     0.150
    89.431   794.586     0.150
    91.087   977.586     0.150
    93.059  1138.586     0.150
    93.059  1422.586     0.150
    93.059  1533.586     0.150
    93.059  1570.586     0.150
    95.914  1476.586     0.150
    96.718   799.586     0.150
    99.087    23.000     0.150
    99.087   870.586     0.150
    99.087   883.586     0.150
    99.087   955.586     0.150
    99.087  1047.586     0.150
    99.087  1088.586     0.150
    99.087  1815.586     0.150
    99.184  1470.586     0.150
   100.020   827.586     0.150
   100.020   834.586     0.150
   100.020  1337.586     0.150
   100.020  1478.586     0.150
   101.141  1115.586     0.150
   101.141  1474.586     0.150
   109.374   875.984     0.150
   114.027  1158.586     0.150
   114.027  1184.586     0.150
   115.161  1395.586     0.150
   118.497   915.586     0.150
   119.618   927.586     0.150
   120.596  1230.586     0.150
   120.596  1382.586     0.150
   120.807  1211.586     0.150
   120.807  1822.586     0.150
   121.287   936.586     0.150
   121.287  1354.586     0.150
   122.639  1238.586     0.150
   123.773  1119.586     0.150
   124.921   948.188     0.150
   132.725  1136.484     0.150
   133.546  1153.285     0.150
   133.942  1143.586     0.150
   133.942  1154.586     0.150
   134.957  1147.586     0.150
   134.957  1288.586     0.150
   134.957  1386.586     0.150
   140.712  1160.887     0.150
   152.458  1177.586     0.150
     1.034    34.055     0.150
     1.612    43.055     0.150
     3.593   102.055     0.150
     6.994   197.055     0.150
    11.392   168.453     0.150
    62.477   617.055     0.150
    66.966   776.055     0.150
     0.234     6.242     0.150
     1.052    34.141     0.150
     1.577    42.141     0.150
     5.056   130.141     0.150
     8.391   220.141     0.150
    68.637   657.141     0.150
    68.804   657.039     0.150
    71.477     9.898     0.150
    71.477   678.340     0.150
     1.028    19.211     0.150
     1.565    41.812     0.150
     2.424    40.812     0.150
    57.073   579.812     0.150
    71.452    20.297     0.150
     1.516    28.305     0.150
     1.537    42.305     0.150
     3.604   103.305     0.150
    62.021   612.305     0.150
    77.751   704.905     0.150
   151.905  1193.405     0.150
     0.746    23.434     0.150
     1.679    45.434     0.150
    62.230   614.734     0.150
    62.351   618.434     0.150
    75.733   694.434     0.150
    77.487   708.934     0.150
     0.721    22.844     0.150
     1.593    42.844     0.150
     1.670    40.844     0.150
     2.702    77.344     0.150
     4.891   126.844     0.150
    60.746   616.844     0.150
    62.176   612.543     0.150
     0.746    23.816     0.150
     1.571    42.816     0.150
     2.167    52.816     0.150
     6.394    91.617     0.150
     6.677   172.816     0.150
     7.341   199.816     0.150
    62.480    21.000     0.150
    65.455   636.816     0.150
    68.210   662.617     0.150
    71.811   685.016     0.150
    72.106    10.000     0.150
    78.186   712.816     0.150
    78.204   709.816     0.150
    78.829   722.816     0.150
    79.253   717.418     0.150
    85.027    15.199     0.150
    85.548   751.816     0.150
    87.476    16.000     0.150
    89.224    15.699     0.150
   146.846  1168.816     0.150
     0.721    23.520     0.150
     1.634    44.520     0.150
     3.406    97.520     0.150
     3.445    90.520     0.150
     5.541    84.719     0.150
     5.541   150.520     0.150
     6.758   185.520     0.150
     6.850   180.520     0.150
     7.389   190.520     0.150
     8.551   225.520     0.150
    21.445   506.520     0.150
    38.311   852.520     0.150
    47.901   506.520     0.150
    54.189  1022.520     0.150
    60.766   653.520     0.150
    61.295    11.199     0.150
    62.194   613.719     0.150
    66.063   644.520     0.150
    68.931   657.020     0.150
    69.960   660.520     0.150
    69.801   676.121     0.150
    75.591    17.301     0.150
    76.536   725.520     0.150
    76.536   740.520     0.150
    77.308   872.121     0.150
    77.308   884.918     0.150
    78.206   712.418     0.150
    78.350   770.520     0.150
    78.841   715.520     0.150
    79.435   714.520     0.150
    81.209  1737.520     0.150
    83.612   820.020     0.150
    84.779    18.000     0.150
    84.804   765.520     0.150
    85.007   767.520     0.150
    85.007    10.000     0.150
    85.204  1960.520     0.150
    90.645   820.320     0.150
   132.002  1133.020     0.150
   132.002  1300.918     0.150
     0.718    21.225     0.150
     1.640    44.225     0.150
     1.971    34.225     0.150
     2.660    75.324     0.150
     4.629    67.725     0.150
     4.764   119.225     0.150
     6.195    96.225     0.150
     6.925   161.725     0.150
    49.255    18.500     0.150
    59.183   592.225     0.150
    66.117   645.225     0.150
    69.803   678.725     0.150
    72.641   683.225     0.150
    75.594    27.800     0.150
    75.920    25.000     0.150
    77.773   713.225     0.150
    78.207   713.125     0.150
    78.842   715.225     0.150
    80.652   715.524     0.150
    81.737   735.824     0.150
    85.006   767.524     0.150
    90.636    11.101     0.150
     0.738    12.547     0.150
     0.738    22.445     0.150
     1.669    44.445     0.150
     2.945    47.445     0.150
    21.470   505.445     0.150
    43.704   480.746     0.150
    63.105   623.445     0.150
    65.175   631.844     0.150
    78.379   711.445     0.150
    83.941   743.645     0.150
    84.150   744.645     0.150
    84.979   748.344     0.150
    87.016   760.047     0.150
    87.100   760.445     0.150
     0.416    16.238     0.150
     0.554    17.238     0.150
     1.585    42.238     0.150
     7.010   176.238     0.150
     8.406   101.938     0.150
    63.939   618.238     0.150
    69.822   662.840     0.150
    70.109    18.801     0.150
     0.730    23.484     0.150
     1.604    41.484     0.150
     1.681    43.484     0.150
     2.699    43.484     0.150
    21.440   506.484     0.150
    27.951    28.000     0.150
    32.778    28.500     0.150
    41.161   458.285     0.150
    49.215    17.500     0.150
    53.278   549.484     0.150
    53.442    24.000     0.150
    55.867   733.484     0.150
    56.939   572.484     0.150
    62.583   620.984     0.150
    65.544    13.000     0.150
    71.560   670.684     0.150
    73.721   705.484     0.150
    77.294   708.785     0.150
    78.196   711.484     0.150
    78.824   715.484     0.150
    78.824    19.000     0.150
    78.844   762.484     0.150
    82.416   735.484     0.150
    82.421   735.484     0.150
    84.110   750.086     0.150
    84.550   748.285     0.150
    85.305   750.684     0.150
   111.685  1100.484     0.150
     1.292    36.066     0.150
     4.727    68.766     0.150
     4.727   129.766     0.150
     4.832   131.867     0.150
     6.736   170.066     0.150
     6.870   100.266     0.150
    62.258   613.066     0.150
    64.161   629.066     0.150
    65.811   638.867     0.150
    67.657   664.465     0.150
    69.726   663.766     0.150
    70.024    13.102     0.150
    70.024    25.199     0.150
    71.423   679.066     0.150
    72.358    12.199     0.150
     0.849    27.711     0.150
     0.973    28.812     0.150
     4.564    64.910     0.150
     4.564   113.711     0.150
    42.989   473.711     0.150
     0.050     8.492     0.150
     1.348    40.492     0.150
     2.152    68.492     0.150
     2.756    79.492     0.150
     2.944    84.492     0.150
     3.282    94.492     0.150
     6.764    99.289     0.150
     6.906   191.195     0.150
     7.284   106.289     0.150
    41.780   466.492     0.150
    55.787   566.492     0.150
    69.819   666.195     0.150
    77.133   722.289     0.150
   131.992  1154.195     0.150
     0.115    12.859     0.150
     1.306    37.859     0.150
     1.612    27.660     0.150
     1.612    50.859     0.150
     2.471    43.859     0.150
     2.471    72.859     0.150
     3.015    85.660     0.150
     3.106    87.859     0.150
     4.786   131.859     0.150
     5.383   134.859     0.150
     6.482    99.160     0.150
     6.498    97.859     0.150
     6.714   175.258     0.150
     6.880   103.859     0.150
     6.922   104.160     0.150
     7.052   103.359     0.150
     7.224   105.160     0.150
     7.972   111.859     0.150
     7.972   209.859     0.150
     9.898   141.359     0.150
    21.345   286.859     0.150
    27.638   345.859     0.150
    42.797   472.961     0.150
    51.273   975.859     0.150
    55.750   575.859     0.150
    58.286   594.359     0.150
    58.997   599.359     0.150
    58.991   596.859     0.150
    62.030   626.859     0.150
    62.334     7.801     0.150
    68.428   659.359     0.150
    68.428   659.359     0.150
    69.842   685.660     0.150
    76.308   696.859     0.150
    77.738    19.000     0.150
    77.738   753.859     0.150
    77.738   780.859     0.150
    77.840  1207.859     0.150
   142.900  1162.859     0.150
     0.727    23.516     0.150
     1.588    41.414     0.150
     2.225    55.016     0.150
     4.766   117.016     0.150
    10.157   141.816     0.150
    19.575   255.516     0.150
    28.447   347.117     0.150
    54.898   560.516     0.150
    57.278   579.016     0.150
    60.746   611.215     0.150
    62.177   615.516     0.150
    64.790   633.016     0.150
    65.127   636.516     0.150
    67.697   651.016     0.150
    68.909   659.016     0.150
    69.472   668.016     0.150
    69.939   663.016     0.150
    69.877   665.016     0.150
    77.277   748.016     0.150
    78.811   716.016     0.150
    78.811   720.016     0.150
    81.187   730.414     0.150
    81.842   730.016     0.150
    82.664   747.016     0.150
    84.188   745.016     0.150
    84.371   746.215     0.150
    85.294   750.914     0.150
    85.445   752.016     0.150
    85.445   752.016     0.150
    86.316   755.816     0.150
    86.966   759.914     0.150
    87.049   760.215     0.150
     1.248    18.363     0.150
     1.248    33.062     0.150
     1.475    22.262     0.150
     1.420    22.262     0.150
     2.363    61.461     0.150
     5.473   151.363     0.150
     6.373   169.062     0.150
     6.628   178.164     0.150
     6.773   187.062     0.150
     7.078   184.562     0.150
     7.460   106.664     0.150
     7.713   104.961     0.150
     7.713   202.062     0.150
     7.916   204.164     0.150
     7.773   212.062     0.150
     7.766   212.562     0.150
     8.056   218.562     0.150
     8.458   119.863     0.150
     8.531   129.164     0.150
     8.531   230.363     0.150
     9.127   237.562     0.150
     9.474   137.062     0.150
     9.456   246.062     0.150
    11.246   288.863     0.150
    12.462   339.062     0.150
    12.590   177.062     0.150
    12.590   308.062     0.150
    13.324   184.461     0.150
    15.143   395.062     0.150
    18.433    13.000     0.150
    21.220   274.062     0.150
    21.220    17.699     0.150
    21.220   501.762     0.150
    21.220   274.762     0.150
    21.429    18.602     0.150
    26.518   339.062     0.150
    27.593    30.102     0.150
    28.100   620.062     0.150
    38.516   790.062     0.150
    38.516   820.062     0.150
    38.809    25.500     0.150
    38.809   790.062     0.150
    44.166     9.699     0.150
    44.654   496.062     0.150
    51.257    15.000     0.150
    51.257   971.062     0.150
    51.930    31.000     0.150
    53.074    19.500     0.150
    53.074    31.500     0.150
    53.143    31.500     0.150
    53.346    20.000     0.150
    53.346   998.062     0.150
    53.864   578.062     0.150
    55.189  1023.062     0.150
    58.879   593.461     0.150
    58.879    13.000     0.150
    60.506     9.402     0.150
    61.074   612.062     0.150
    62.225    14.199     0.150
    62.215   615.562     0.150
    62.215   615.562     0.150
    62.397    20.898     0.150
    62.826  1118.562     0.150
    63.635    21.000     0.150
    63.635   654.062     0.150
    64.020   630.262     0.150
    64.883    15.602     0.150
    65.776  1153.062     0.150
    66.163   810.062     0.150
    68.295   660.363     0.150
    68.656    14.801     0.150
    69.550   668.863     0.150
    69.708   664.164     0.150
    69.977   664.062     0.150
    76.001    21.000     0.150
    77.010    20.898     0.150
    77.496   709.863     0.150
    77.647    27.000     0.150
    77.647    35.000     0.150
    77.756   716.062     0.150
    77.936   712.062     0.150
    77.936    21.000     0.150
    78.059   712.062     0.150
    78.059   712.062     0.150
    78.528   706.363     0.150
    78.586   719.062     0.150
    79.072   710.062     0.150
    80.279   734.461     0.150
    80.403   775.062     0.150
    80.525   727.062     0.150
    80.475    16.000     0.150
    80.475   743.562     0.150
    80.475   743.562     0.150
    80.936   728.863     0.150
    84.144     7.500     0.150
    85.593    10.500     0.150
    85.593   772.961     0.150
    85.593   772.961     0.150
    86.078   754.863     0.150
    86.078    12.801     0.150
    86.078   790.863     0.150
    86.078  1697.762     0.150
    86.078  1713.262     0.150
    87.728   765.262     0.150
    87.722    13.000     0.150
    88.341   767.863     0.150
   128.740  1159.062     0.150
   130.913  1163.664     0.150
   134.281  1169.062     0.150
   142.522  1166.062     0.150
     0.736    22.688     0.150
     1.685    44.789     0.150
     6.871   180.988     0.150
     7.455   103.789     0.150
     1.664    45.234     0.150
     4.799    95.633     0.150
     6.411    92.336     0.150
    15.001   204.336     0.150
    15.001   204.336     0.150
    15.001   204.336     0.150
    15.001   204.336     0.150
    19.645   254.539     0.150
    21.479   271.039     0.150
    21.479    25.297     0.150
    21.479   505.336     0.150
    21.488    18.500     0.150
    21.488    25.898     0.150
    28.010   626.336     0.150
    28.524   349.438     0.150
    28.524   349.438     0.150
    32.775    26.000     0.150
    44.995   485.633     0.150
    47.356   507.336     0.150
    54.470  1029.539     0.150
    55.620  1041.633     0.150
    55.858   573.234     0.150
    60.793   603.133     0.150
    60.842  1113.336     0.150
    68.313   673.336     0.150
    69.994   663.836     0.150
    69.994   663.836     0.150
    72.154   679.336     0.150
    78.241   713.336     0.150
    80.559   737.336     0.150
    85.414   752.438     0.150
    85.414   752.438     0.150
     1.614    44.879     0.150
     2.245    64.078     0.150
     5.598   144.078     0.150
     6.801   179.078     0.150
    12.333   309.578     0.150
    12.333   309.578     0.150
    12.333   309.578     0.150
    13.168   179.879     0.150
    15.037   207.879     0.150
    15.037   207.879     0.150
    15.037   207.879     0.150
    27.960   618.078     0.150
    27.960   618.078     0.150
    28.472   634.477     0.150
    28.472   634.477     0.150
    29.949   380.078     0.150
    30.378   362.578     0.150
    37.281   421.777     0.150
    44.017  1142.078     0.150
    47.302   508.078     0.150
    47.302   508.078     0.150
    47.920   930.078     0.150
    47.920   930.078     0.150
    49.221   521.879     0.150
    51.452   555.578     0.150
    51.632   987.379     0.150
    53.448   990.578     0.150
    53.448   990.578     0.150
    53.448   990.578     0.150
    53.486   552.879     0.150
    54.150  1032.078     0.150
    55.465   571.078     0.150
    55.773  1043.578     0.150
    55.845   573.078     0.150
    58.587   589.277     0.150
    58.587   589.277     0.150
    62.321   671.680     0.150
    62.331   617.680     0.150
    62.509    11.801     0.150
    63.199   622.578     0.150
    63.960   645.078     0.150
    66.990   766.078     0.150
    69.562   656.477     0.150
    69.779    13.000     0.150
    69.968   663.578     0.150
    69.968   663.578     0.150
    69.975   665.578     0.150
    73.866   687.578     0.150
    73.866   687.578     0.150
    75.591    19.000     0.150
    75.685   702.078     0.150
    76.535    18.898     0.150
    76.535   736.078     0.150
    77.964    35.898     0.150
    77.964   777.078     0.150
    78.214   712.078     0.150
    78.214    24.000     0.150
    78.161   709.477     0.150
    79.390   738.078     0.150
    79.826   722.578     0.150
    80.295   758.078     0.150
    80.874   726.078     0.150
    82.100    20.398     0.150
    84.179   750.078     0.150
    84.999    14.000     0.150
    85.323   749.777     0.150
    85.455   751.680     0.150
    85.455   751.680     0.150
    86.345   754.680     0.150
     0.737    22.141     0.150
     0.740    27.840     0.150
     1.418    21.840     0.150
     1.418    43.340     0.150
     3.456    61.840     0.150
     4.139    65.840     0.150
     4.451   120.141     0.150
     4.596    70.840     0.150
     5.066    79.238     0.150
     5.066    87.340     0.150
     6.871   103.840     0.150
     9.896   142.441     0.150
    41.812   466.141     0.150
    60.070   604.840     0.150
    73.553   690.441     0.150
    80.483   725.840     0.150
    80.769   730.840     0.150
     1.244    16.250     0.150
     1.600    41.547     0.150
     2.651    75.250     0.150
     4.575    68.852     0.150
     4.575   120.250     0.150
     4.772    70.250     0.150
     6.591   169.352     0.150
     6.707   170.453     0.150
    13.064   179.250     0.150
    13.064   318.250     0.150
    13.154   190.852     0.150
    15.022   214.250     0.150
    15.022   214.250     0.150
    15.022   214.250     0.150
    15.022   214.250     0.150
    18.479   252.453     0.150
    20.755   498.250     0.150
    21.439   279.648     0.150
    21.478   280.352     0.150
    21.478   511.352     0.150
    27.947   343.547     0.150
    28.459   348.750     0.150
    28.459   348.750     0.150
    29.935   362.250     0.150
    30.356   362.250     0.150
    32.781   385.250     0.150
    32.781   695.250     0.150
    38.865   438.250     0.150
    38.865   796.250     0.150
    39.076     2.398     0.150
    39.076   436.852     0.150
    39.076     2.398     0.150
    47.899   510.250     0.150
    49.210   522.047     0.150
    51.622   540.648     0.150
    52.256   545.250     0.150
    53.469   553.953     0.150
    53.825   555.852     0.150
    54.145  1016.750     0.150
    59.119   602.547     0.150
    60.755   609.648     0.150
    62.421   617.148     0.150
    62.582   617.250     0.150
    64.460   629.250     0.150
    64.801   631.250     0.150
    66.048   645.250     0.150
    66.048   633.250     0.150
    69.948   663.648     0.150
    69.948   663.648     0.150
    75.655   698.250     0.150
    76.516   706.250     0.150
    76.516    19.500     0.150
    77.287   707.352     0.150
    77.292   707.453     0.150
    77.779   710.250     0.150
    78.282   714.547     0.150
    78.842   720.648     0.150
    78.842   716.648     0.150
    78.842     4.000     0.150
    79.380    24.500     0.150
    81.113   746.250     0.150
    90.729   781.250     0.150
   160.035  1241.453     0.150
     1.627    25.617     0.150
     1.627    44.320     0.150
     1.655    45.523     0.150
     1.702    42.320     0.150
     2.301    39.320     0.150
    21.458   508.320     0.150
    21.458   278.719     0.150
    21.458   300.320     0.150
    21.458   508.320     0.150
    21.464   280.117     0.150
    21.464   299.617     0.150
    26.648   329.320     0.150
    28.001     6.203     0.150
    28.001     5.406     0.150
    28.001   535.219     0.150
    28.516   348.922     0.150
    28.516   535.219     0.150
    29.991   362.719     0.150
    32.214   389.320     0.150
    38.918   795.320     0.150
    38.918   438.922     0.150
    38.918   795.320     0.150
    45.095   493.117     0.150
    46.847   484.117     0.150
    51.682   540.719     0.150
    52.301   545.320     0.150
    53.514   552.320     0.150
    64.031   626.922     0.150
    64.031   626.922     0.150
    66.079   639.320     0.150
    75.609   702.617     0.150
    75.609     4.695     0.150
    75.609   716.023     0.150
    77.319   707.023     0.150
    78.875   716.719     0.150
    80.231   727.117     0.150
    81.155   728.320     0.150
    81.224   730.617     0.150
     0.112     6.995     0.150
     0.898    18.995     0.150
     1.197    18.995     0.150
     1.197    36.995     0.150
     1.336    41.695     0.150
     1.984    64.995     0.150
     3.082    84.995     0.150
     3.359    55.995     0.150
     4.899    76.995     0.150
     6.229    92.294     0.150
     6.684   179.995     0.150
    18.619   469.995     0.150
    21.381   522.995     0.150
    43.638    11.900     0.150
    49.452   533.495     0.150
    52.033    23.900     0.150
    52.033   549.995     0.150
    52.033    23.900     0.150
    52.033   629.995     0.150
    62.101   620.495     0.150
    65.916   645.895     0.150
    68.937   661.995     0.150
    69.216   669.095     0.150
     1.606    25.742     0.150
     1.606    44.242     0.150
     1.630    45.141     0.150
     4.755    70.344     0.150
     4.755   119.242     0.150
     7.400   109.844     0.150
    19.605   259.242     0.150
    20.807   281.844     0.150
    21.045   270.641     0.150
    21.435   507.641     0.150
    21.435   279.539     0.150
    21.435   299.641     0.150
    21.435   310.445     0.150
    21.435   507.641     0.150
    21.435   556.242     0.150
    21.449   280.945     0.150
    21.449   297.445     0.150
    21.844   282.242     0.150
    28.491   348.641     0.150
    28.491   541.242     0.150
    29.965   361.242     0.150
    38.892   437.844     0.150
    38.892   797.242     0.150
    47.326   506.242     0.150
    52.275   544.641     0.150
    52.275    18.898     0.150
    57.311   572.844     0.150
    64.006   625.539     0.150
    64.814   631.039     0.150
    69.509   663.242     0.150
    75.583   704.641     0.150
    75.583   698.141     0.150
    75.583   704.641     0.150
    77.294   706.141     0.150
    77.294   706.141     0.150
     0.122    10.758     0.150
     1.378    40.359     0.150
     3.327    50.359     0.150
     4.922    74.359     0.150
     6.178    86.961     0.150
     6.645   175.359     0.150
     7.007   104.359     0.150
     9.845   147.359     0.150
    12.726   184.156     0.150
    15.338   376.359     0.150
    15.338   216.359     0.150
    15.338   376.359     0.150
    18.663   253.359     0.150
    20.373   511.359     0.150
    21.431   320.961     0.150
    21.431   517.961     0.150
    21.405   291.156     0.150
    21.405   526.359     0.150
    21.658    16.398     0.150
    21.658    16.000     0.150
    21.658   318.156     0.150
    29.682   361.359     0.150
    29.682   362.156     0.150
    30.405   367.359     0.150
    33.038    15.000     0.150
    33.038   391.359     0.150
    33.038    15.000     0.150
    33.038   486.359     0.150
    33.038   706.359     0.150
    39.000   442.359     0.150
    39.000   442.359     0.150
    39.869   812.258     0.150
    41.977   468.359     0.150
    44.111   484.961     0.150
    46.486   506.359     0.150
    46.997   507.359     0.150
    51.323    23.297     0.150
    51.323   541.359     0.150
    51.323    23.297     0.150
    52.076   547.359     0.150
    52.076    10.703     0.150
    53.289   555.359     0.150
    62.287   615.359     0.150
    62.417   620.359     0.150
    63.800   653.359     0.150
    63.800   629.359     0.150
    63.800    24.000     0.150
    63.925   629.062     0.150
    64.658   634.359     0.150
    65.964   641.359     0.150
    65.964   641.359     0.150
    69.254   664.961     0.150
    69.162   672.359     0.150
    77.195   714.461     0.150
    77.195   710.359     0.150
    77.195   722.359     0.150
    77.677   713.359     0.150
    80.955   730.562     0.150
    81.667   739.859     0.150
     0.161     9.650     0.150
     0.582    16.851     0.150
     1.149    19.650     0.150
     1.303    41.051     0.150
     1.591    44.851     0.150
     1.784    46.051     0.150
     1.875    47.851     0.150
     3.074    48.351     0.150
     3.074    89.150     0.150
     3.578    53.851     0.150
     4.827    73.251     0.150
     4.939   139.351     0.150
     4.939    74.851     0.150
     4.939   139.351     0.150
     5.333    84.851     0.150
     5.333   147.851     0.150
     6.023    94.851     0.150
     6.023   164.950     0.150
     6.331   175.150     0.150
     6.439   173.851     0.150
     6.521   166.851     0.150
     6.795   178.851     0.150
     7.057   194.851     0.150
     7.569   114.551     0.150
     7.562   113.851     0.150
     7.577   196.851     0.150
     7.815   210.851     0.150
     8.104   204.851     0.150
     8.327   126.851     0.150
     8.565   126.851     0.150
     8.892   233.851     0.150
     8.933   235.851     0.150
     9.271   137.851     0.150
     9.293   133.851     0.150
     9.293   245.251     0.150
     9.256   236.450     0.150
     9.283   249.851     0.150
     9.265   136.851     0.150
     9.265   235.351     0.150
     9.276   137.851     0.150
     9.276   239.851     0.150
     9.483   251.851     0.150
     9.551   139.851     0.150
     9.614   138.851     0.150
     9.802   264.851     0.150
     9.836   146.851     0.150
     9.962   265.650     0.150
    10.064   264.950     0.150
    10.198   259.851     0.150
    10.275   149.751     0.150
    10.275   272.450     0.150
    10.938   289.851     0.150
    11.072   282.950     0.150
    11.140   292.251     0.150
    11.311   164.851     0.150
    11.903   174.851     0.150
    12.044   173.851     0.150
    12.069   176.851     0.150
    12.264   181.150     0.150
    12.400   180.051     0.150
    12.400   319.851     0.150
    12.655   326.851     0.150
    12.657   331.851     0.150
    12.657   178.950     0.150
    12.657   331.851     0.150
    12.857   331.950     0.150
    12.879   186.851     0.150
    12.879   337.851     0.150
    13.098   189.851     0.150
    13.098   338.851     0.150
    13.139   193.150     0.150
    13.225   190.650     0.150
    13.225   339.851     0.150
    13.364   191.851     0.150
    13.762   198.450     0.150
    14.404   368.351     0.150
    14.681   374.351     0.150
    15.343   405.851     0.150
    18.633   253.851     0.150
    18.633   457.851     0.150
    19.335   260.851     0.150
    19.335   476.351     0.150
    19.981    11.000     0.150
    19.981    18.000     0.150
    20.336   283.851     0.150
    20.336    25.300     0.150
    20.336   511.851     0.150
    20.555   275.851     0.150
    21.370   282.051     0.150
    21.370   517.450     0.150
    21.628   285.650     0.150
    21.628   313.351     0.150
    21.628   520.450     0.150
    23.465    34.000     0.150
    23.635   313.551     0.150
    24.237   569.851     0.150
    25.114   613.650     0.150
    25.387    40.000     0.150
    25.523   332.950     0.150
    25.523   604.351     0.150
    26.193   599.851     0.150
    27.552   620.351     0.150
    27.624     1.000     0.150
    27.624     0.600     0.150
    27.624   384.551     0.150
    27.624   397.851     0.150
    27.624   624.851     0.150
    28.116   349.251     0.150
    28.116   412.851     0.150
    28.116   632.851     0.150
    28.505   359.950     0.150
    29.605   361.851     0.150
    29.605     3.399     0.150
    29.605   657.851     0.150
    30.351   658.851     0.150
    30.351   422.351     0.150
    30.351   438.351     0.150
    30.351   658.851     0.150
    30.351  1011.851     0.150
    30.458   368.851     0.150
    30.458    12.000     0.150
    30.458   446.851     0.150
    30.458   661.851     0.150
    30.458   680.851     0.150
    30.931   394.351     0.150
    32.880   702.851     0.150
    33.025   391.051     0.150
    33.025   467.851     0.150
    33.025   475.851     0.150
    33.025   560.351     0.150
    33.025  1025.851     0.150
    33.091   399.851     0.150
    33.248   392.351     0.150
    33.248   449.851     0.150
    33.910   398.351     0.150
    33.910   723.851     0.150
    36.866    11.000     0.150
    36.866   449.851     0.150
    36.866   762.851     0.150
    36.866   766.851     0.150
    36.866   791.851     0.150
    38.553   439.551     0.150
    38.553   792.851     0.150
    38.931   440.351     0.150
    38.931   947.851     0.150
    39.793   450.051     0.150
    39.793   815.051     0.150
    40.127   452.851     0.150
    40.127   818.150     0.150
    41.083   828.851     0.150
    41.083   995.851     0.150
    42.718   473.150     0.150
    42.718   853.650     0.150
    43.590   849.851     0.150
    43.590   849.851     0.150
    44.368   943.851     0.150
    44.559   872.251     0.150
    46.412   504.851     0.150
    46.412   593.851     0.150
    46.412   910.851     0.150
    46.921   907.351     0.150
    46.926   907.351     0.150
    46.920   653.851     0.150
    47.863   513.851     0.150
    47.863   927.851     0.150
    48.471   947.851     0.150
    48.471   520.851     0.150
    48.471   947.851     0.150
    48.843   942.851     0.150
    48.843   522.650     0.150
    48.843   942.851     0.150
    50.809   975.851     0.150
    51.248   979.251     0.150
    51.248   541.251     0.150
    51.248   979.251     0.150
    52.001   983.851     0.150
    52.001   546.851     0.150
    52.001   983.851     0.150
    52.631    10.600     0.150
    52.631   579.051     0.150
    52.858   559.851     0.150
    52.858   944.851     0.150
    52.823   557.851     0.150
    53.072   554.351     0.150
    53.072   999.351     0.150
    53.214     3.000     0.150
    53.214   999.851     0.150
    53.214   555.650     0.150
    53.214     3.000     0.150
    53.214   619.851     0.150
    53.214   681.851     0.150
    53.214   735.851     0.150
    53.214   999.851     0.150
    53.327   561.851     0.150
    53.447  1004.351     0.150
    53.447  1007.351     0.150
    53.331   566.751     0.150
    53.723  1009.851     0.150
    53.723  1341.851     0.150
    54.343   563.450     0.150
    54.343  1020.051     0.150
    54.717   566.351     0.150
    54.717  1022.551     0.150
    54.717  1147.551     0.150
    55.394   570.851     0.150
    55.394  1032.450     0.150
    55.394  1052.450     0.150
    55.526   583.351     0.150
    58.438  1071.851     0.150
    59.017   819.851     0.150
    58.949    24.500     0.150
    59.338   598.851     0.150
    59.338   650.851     0.150
    59.338   818.351     0.150
    60.957   606.851     0.150
    62.063   618.351     0.150
    62.063   763.851     0.150
    62.063   849.851     0.150
    62.063  1120.851     0.150
    62.063  1130.851     0.150
    62.063  1148.851     0.150
    62.085   619.551     0.150
    62.143   893.851     0.150
    62.224   653.851     0.150
    62.224  1122.051     0.150
    61.994    19.900     0.150
    61.994  1117.851     0.150
    62.349   621.251     0.150
    62.349   853.851     0.150
    62.837   623.351     0.150
    62.837  1131.851     0.150
    63.726   627.851     0.150
    63.726   861.851     0.150
    63.726  1139.851     0.150
    63.726  1159.851     0.150
    63.857   629.351     0.150
    63.951   658.851     0.150
    64.287   631.851     0.150
    64.287  1145.851     0.150
    64.584   633.851     0.150
    64.584  1151.851     0.150
    64.580   624.851     0.150
    64.772   635.851     0.150
    65.013   635.450     0.150
    65.013   638.950     0.150
    65.895    12.600     0.150
    65.895   877.851     0.150
    65.895  1405.851     0.150
    65.895   642.251     0.150
    66.071   646.450     0.150
    66.071  1169.851     0.150
    66.176  1173.851     0.150
    66.176   648.851     0.150
    66.176  1173.851     0.150
    66.749   650.851     0.150
    66.749  1184.851     0.150
    66.896   649.851     0.150
    66.896   899.851     0.150
    66.896  1180.851     0.150
    67.372  2360.851     0.150
    68.022   656.851     0.150
    68.022  1191.851     0.150
    67.812   659.650     0.150
    67.812  1205.851     0.150
    68.177   658.851     0.150
    68.177  1193.851     0.150
    68.441   659.450     0.150
    68.781     2.601     0.150
    68.821   661.851     0.150
    68.821   681.851     0.150
    68.821  1202.851     0.150
    68.846   662.650     0.150
    68.846     4.000     0.150
    68.846   693.450     0.150
    68.846  1205.450     0.150
    69.178   664.851     0.150
    69.178  1210.851     0.150
    69.190    32.900     0.150
    69.190  2210.851     0.150
    69.433   663.171     0.150
    69.568   666.851     0.150
    69.568  1213.851     0.150
    69.571   667.851     0.150
    69.571  1211.851     0.150
    69.669   664.831     0.150
    69.726  2349.851     0.150
    69.825   665.650     0.150
    69.801  1225.851     0.150
    69.801  1697.851     0.150
    70.133   667.440     0.150
    70.193   669.851     0.150
    70.193  1217.851     0.150
    71.477    10.801     0.150
    72.341   682.551     0.150
    72.341  1244.851     0.150
    72.341  1268.851     0.150
    73.279    40.000     0.150
    73.279   861.851     0.150
    73.279  1253.851     0.150
    73.612     3.000     0.150
    73.612   689.851     0.150
    73.612     3.000     0.150
    73.612   963.851     0.150
    73.612  1257.851     0.150
    73.612  1283.851     0.150
    73.785  1256.851     0.150
    73.802  1254.150     0.150
    73.802   692.150     0.150
    73.802   966.851     0.150
    73.802  1254.150     0.150
    73.650     3.000     0.150
    73.964   920.351     0.150
    73.964   984.851     0.150
    73.964  1282.851     0.150
    73.964  1324.351     0.150
    73.964  1595.851     0.150
    74.090   715.851     0.150
    74.090   877.851     0.150
    74.090  1325.851     0.150
    74.090  1798.851     0.150
    75.238   710.851     0.150
    75.039   715.851     0.150
    75.380   703.751     0.150
    75.380  1278.751     0.150
    75.433   704.851     0.150
    75.448  1280.851     0.150
    75.448   701.851     0.150
    75.448   877.851     0.150
    75.448   973.851     0.150
    75.448  1280.851     0.150
    75.624   705.851     0.150
    75.702   720.851     0.150
    75.702   741.351     0.150
    76.083   709.351     0.150
    76.245   708.851     0.150
    76.245  1288.851     0.150
    76.315   811.851     0.150
    76.315   848.851     0.150
    76.222   706.751     0.150
    77.125   710.150     0.150
    77.125     2.700     0.150
    77.125   884.851     0.150
    77.125  2370.851     0.150
    77.125   710.150     0.150
    77.125     2.601     0.150
    77.126   712.851     0.150
    77.126   734.851     0.150
    77.126   762.851     0.150
    77.126   782.851     0.150
    77.126   891.851     0.150
    77.126   904.851     0.150
    77.126  1289.851     0.150
    77.126  1335.851     0.150
    77.126  2320.851     0.150
    77.126  2344.851     0.150
    77.126   710.251     0.150
    77.126  1297.851     0.150
    77.491   694.851     0.150
    77.582     3.000     0.150
    77.582  1883.851     0.150
    77.606     3.000     0.150
    77.606   796.150     0.150
    77.606   869.851     0.150
    77.606   713.851     0.150
    77.606     3.000     0.150
    77.606  1303.851     0.150
    77.840   717.150     0.150
    78.063   715.351     0.150
    78.063     2.500     0.150
    77.947   727.351     0.150
    78.175     3.300     0.150
    78.175   858.851     0.150
    78.175  2344.851     0.150
    78.175     3.500     0.150
    78.265   749.851     0.150
    78.265   898.851     0.150
    78.270   720.851     0.150
    78.270     1.000     0.150
    78.270   748.851     0.150
    78.270  1318.851     0.150
    78.631     2.700     0.150
    78.631    12.700     0.150
    78.631   720.150     0.150
    78.631     2.700     0.150
    78.631   732.851     0.150
    78.653   724.851     0.150
    78.669   719.851     0.150
    78.669   727.751     0.150
    78.669  1315.851     0.150
    78.712     2.900     0.150
    78.712  1325.851     0.150
    78.741   713.150     0.150
    79.163     3.500     0.150
    79.319  3953.851     0.150
    79.467   912.851     0.150
    79.564     3.300     0.150
    79.564    13.300     0.150
    79.658   724.551     0.150
    80.051     2.800     0.150
    80.424   732.851     0.150
    80.424    12.699     0.150
    80.424   760.650     0.150
    80.473   730.251     0.150
    80.531   731.851     0.150
    80.531   933.251     0.150
    80.531  1113.851     0.150
    80.531  2345.051     0.150
    80.681   733.950     0.150
    80.780   907.551     0.150
    80.660   732.240     0.150
    80.918   926.851     0.150
    80.989   731.450     0.150
    81.038   731.751     0.150
    81.038   739.851     0.150
    81.365   915.851     0.150
    81.807   737.650     0.150
    81.807   923.851     0.150
    81.848  1346.351     0.150
    81.940   911.351     0.150
    82.188   735.450     0.150
    82.746   918.851     0.150
    82.774   931.051     0.150
    82.477    23.000     0.150
    82.477  1433.851     0.150
    82.477  2513.851     0.150
    83.351   744.150     0.150
    83.385  1339.851     0.150
    83.817   747.351     0.150
    84.307   750.051     0.150
    84.345   750.251     0.150
    84.525   928.351     0.150
    85.150   755.851     0.150
    85.644   757.450     0.150
    85.788  1383.851     0.150
    86.414   761.650     0.150
    86.841   763.551     0.150
    86.622   766.150     0.150
    87.513   778.351     0.150
    87.537    13.500     0.150
    87.652   933.851     0.150
    87.724    13.100     0.150
    87.986   967.851     0.150
    87.986  1401.851     0.150
    87.986  1997.851     0.150
    89.319  1003.851     0.150
    89.349    17.600     0.150
    90.107     3.500     0.150
    90.582   977.851     0.150
    91.467   792.450     0.150
    91.467  1000.450     0.150
    91.834   786.851     0.150
    92.933  1138.851     0.150
    92.933  1473.851     0.150
    93.110   793.751     0.150
    93.121  1534.851     0.150
    95.155  1103.551     0.150
    95.234  1445.351     0.150
    95.520  1149.851     0.150
    95.923  1013.851     0.150
    95.923  1487.851     0.150
    96.468  2781.851     0.150
    96.738  1171.851     0.150
    96.738  1499.851     0.150
    96.738  1651.851     0.150
    96.738  1918.851     0.150
   114.668  1175.851     0.150
   114.668  1300.851     0.150
   120.681   936.051     0.150
   120.681  1152.150     0.150
   120.681  1206.551     0.150
   120.681  1227.450     0.150
   120.681  1237.950     0.150
   120.681  1274.851     0.150
   120.623  1222.851     0.150
   120.623  2237.851     0.150
   121.802  1151.851     0.150
   122.534  1139.051     0.150
   123.279  1230.551     0.150
   129.715  1141.851     0.150
   133.429  1148.150     0.150
   134.450  1145.351     0.150
   134.450  1158.851     0.150
   135.021  1148.851     0.150
   135.096  1212.851     0.150
   135.423  1153.551     0.150
   135.464  1150.851     0.150
   141.219  1163.851     0.150
   141.219  1393.851     0.150
   141.219  2529.851     0.150
   141.219  2769.851     0.150
   142.317  1164.851     0.150
   142.317  1164.851     0.150
   147.048  1225.851     0.150
   147.048  1609.851     0.150
   147.048  2003.851     0.150
   147.048  2155.851     0.150
   147.048  2545.851     0.150
   147.048  2901.851     0.150
   147.048  3637.851     0.150
   151.561  1196.351     0.150
   159.331  1216.351     0.150
   159.331  1228.851     0.150
   160.219  1199.851     0.150
   160.327  1217.450     0.150
   160.327  1255.950     0.150
   160.327  1266.051     0.150
     0.090    10.374     0.150
     1.215    18.374     0.150
     1.309    38.374     0.150
     2.149    67.774     0.150
     3.927   107.374     0.150
     6.307    91.374     0.150
    30.322   389.374     0.150
    32.911   390.374     0.150
    32.911     5.000     0.150
    49.363   528.374     0.150
    62.313   617.374     0.150
    63.823   628.574     0.150
    65.863   641.574     0.150
    69.195   672.374     0.150
    77.779   725.374     0.150
    77.779   739.674     0.150
    84.022   748.174     0.150
     0.106    10.539     0.150
     0.474    11.939     0.150
     1.208    19.539     0.150
     1.208    34.539     0.150
     1.292    38.639     0.150
     1.492    40.539     0.150
     3.252    51.539     0.150
    10.982   159.039     0.150
    31.958   392.439     0.150
    37.193   420.039     0.150
    38.560   438.039     0.150
    62.292   619.539     0.150
    81.545   733.939     0.150
    84.289   746.739     0.150
    85.049   752.539     0.150
    85.365   753.539     0.150
    86.911  1046.539     0.150
   143.045  1159.539     0.150
   143.263  1160.539     0.150
   147.479  1223.739     0.150
     0.124    11.922     0.150
     0.546    22.021     0.150
     1.175    18.621     0.150
     1.175    33.021     0.150
     1.305    38.021     0.150
     1.863    54.021     0.150
     3.170    50.021     0.150
     3.532    53.322     0.150
     3.532    97.021     0.150
     4.794    75.021     0.150
     4.794    75.322     0.150
     7.964   120.021     0.150
    12.091   176.021     0.150
    18.594   254.021     0.150
    19.335   261.121     0.150
    21.349   281.021     0.150
    28.130   348.021     0.150
    42.729   461.021     0.150
    42.729   461.422     0.150
    62.068   616.221     0.150
    62.628   624.021     0.150
    63.845   627.822     0.150
    65.884   641.021     0.150
    69.186   672.021     0.150
    87.940   767.922     0.150
     0.078    11.629     0.150
     1.232    19.729     0.150
     1.232    34.729     0.150
     1.363    38.928     0.150
     4.824   129.729     0.150
     4.824   129.729     0.150
    18.612   254.729     0.150
    19.392   248.729     0.150
    19.392   249.129     0.150
    21.608   285.828     0.150
    28.190   350.729     0.150
    28.190   350.729     0.150
    32.986   389.729     0.150
    32.986    13.000     0.150
    63.895   628.328     0.150
    65.935   641.729     0.150
     0.074    10.043     0.150
     1.224    19.645     0.150
     1.327    38.645     0.150
     1.879    50.645     0.150
     2.966    77.543     0.150
     2.966    46.543     0.150
     2.966    77.543     0.150
     3.310    94.645     0.150
     3.469    52.645     0.150
     3.469    91.145     0.150
     4.157   106.645     0.150
     4.765    71.246     0.150
     4.831    73.645     0.150
     5.415    84.645     0.150
     5.415   148.645     0.150
     6.426   174.645     0.150
     6.557   176.645     0.150
     6.613   178.945     0.150
     6.904   172.543     0.150
     6.904    99.945     0.150
     7.145   191.043     0.150
     7.266   194.645     0.150
     7.667   188.645     0.150
     8.014   115.145     0.150
     8.677   119.746     0.150
     8.677   119.746     0.150
     8.660   126.645     0.150
     9.369   138.645     0.150
     9.369   249.645     0.150
    11.050   157.145     0.150
    11.217   164.645     0.150
    12.551   177.445     0.150
    15.238   210.645     0.150
    18.554   460.645     0.150
    18.554   253.645     0.150
    18.554   460.645     0.150
    20.068   486.645     0.150
    20.068   500.645     0.150
    20.444    24.199     0.150
    20.444   493.645     0.150
    21.338   280.445     0.150
    21.338   319.344     0.150
    21.338   516.344     0.150
    21.338   552.344     0.150
    21.549   285.645     0.150
    21.549   314.945     0.150
    21.549   518.945     0.150
    27.664   618.645     0.150
    27.664   640.645     0.150
    27.664   618.645     0.150
    27.664   640.645     0.150
    28.164   624.645     0.150
    28.164   349.344     0.150
    28.164   393.645     0.150
    28.164   410.145     0.150
    28.164   624.645     0.150
    28.164   735.645     0.150
    28.558   359.145     0.150
    29.648   362.746     0.150
    30.305   422.645     0.150
    30.305   437.645     0.150
    30.548   437.645     0.150
    30.548   652.645     0.150
    30.548   731.645     0.150
    32.328   385.844     0.150
    32.931    18.801     0.150
    32.931   390.043     0.150
    32.931     8.602     0.150
    32.931    18.801     0.150
    32.931   703.645     0.150
    32.931   723.645     0.150
    32.931   844.645     0.150
    33.196   401.645     0.150
    33.953   718.145     0.150
    33.953   400.645     0.150
    33.953   718.145     0.150
    36.969   518.645     0.150
    38.590   793.645     0.150
    38.919    11.000     0.150
    38.919   789.645     0.150
    38.919   440.645     0.150
    38.919    11.000     0.150
    38.919   540.645     0.150
    38.919   789.645     0.150
    39.836   449.844     0.150
    40.159   452.246     0.150
    40.159   818.445     0.150
    41.180   606.645     0.150
    42.760   474.344     0.150
    42.760   853.043     0.150
    46.471   507.645     0.150
    46.471   914.645     0.150
    46.471   508.145     0.150
    46.471   914.645     0.150
    46.979   507.645     0.150
    46.984  1185.645     0.150
    47.824   513.645     0.150
    47.824   923.645     0.150
    48.531   520.246     0.150
    48.531   943.145     0.150
    48.899    20.000     0.150
    48.899   522.645     0.150
    48.899    20.000     0.150
    48.899   946.645     0.150
    51.308   979.043     0.150
    52.020   547.645     0.150
    52.020   987.645     0.150
    53.128   554.145     0.150
    53.128   998.145     0.150
    53.233   556.246     0.150
    53.233    10.199     0.150
    53.233   749.645     0.150
    53.233  1003.145     0.150
    53.389  1006.945     0.150
    53.407   566.645     0.150
    53.805  1010.645     0.150
    54.405  1012.246     0.150
    54.405   762.543     0.150
    54.405  1012.246     0.150
    54.777   566.445     0.150
    54.777  1024.043     0.150
    54.948   552.645     0.150
    55.434   578.145     0.150
    55.451   571.145     0.150
    55.451  1032.645     0.150
    58.422    18.301     0.150
    58.422  1073.645     0.150
    58.422   592.645     0.150
    58.422    18.301     0.150
    58.422  1073.645     0.150
    62.116   619.645     0.150
    62.268  1129.645     0.150
    62.277   619.645     0.150
    62.887   623.645     0.150
    62.887     7.000     0.150
    62.887  1130.645     0.150
    63.734   628.645     0.150
    63.734  1140.645     0.150
    63.734  1158.645     0.150
    63.845   629.145     0.150
    63.843   654.645     0.150
    64.283    12.500     0.150
    64.283   632.145     0.150
    64.283    12.500     0.150
    64.283  1145.645     0.150
    64.592   634.145     0.150
    64.592  1149.645     0.150
    64.871   642.645     0.150
    65.885  1620.645     0.150
    65.885   642.645     0.150
    66.790   649.645     0.150
    66.930   649.645     0.150
    66.930  1180.645     0.150
    67.830   656.145     0.150
    68.215  1196.645     0.150
    68.215   658.645     0.150
    68.215  1196.645     0.150
    68.823   662.645     0.150
    68.823  1203.645     0.150
    68.887   662.246     0.150
    68.887  1204.645     0.150
    69.212   664.445     0.150
    69.212  1213.445     0.150
    69.606   667.645     0.150
    69.606  1214.645     0.150
    69.607  1202.645     0.150
    69.607   667.645     0.150
    69.607  1202.645     0.150
    70.221  1221.645     0.150
    70.221   671.645     0.150
    70.221  1221.645     0.150
    70.694  1212.645     0.150
    70.694   672.645     0.150
    70.694  1212.645     0.150
    72.363   683.645     0.150
    72.363  1243.645     0.150
    73.626   688.645     0.150
    73.807   691.645     0.150
    73.807   861.645     0.150
    73.807  1259.645     0.150
    74.981   695.945     0.150
    75.381   705.645     0.150
    75.453  1281.645     0.150
    75.453   702.145     0.150
    75.453  1281.645     0.150
    75.631   704.645     0.150
    76.095   707.645     0.150
    76.318     1.199     0.150
    76.318   798.645     0.150
    76.318   903.645     0.150
    76.274   723.645     0.150
    77.119   735.645     0.150
    77.119   875.645     0.150
    77.118   878.645     0.150
    77.118  1327.645     0.150
    77.119   710.746     0.150
    77.118   711.344     0.150
    77.118   716.445     0.150
    77.118  1297.645     0.150
    77.239   709.645     0.150
    77.602  1304.645     0.150
    77.602   713.844     0.150
    77.602   718.645     0.150
    77.602  1304.645     0.150
    77.748     4.000     0.150
    77.748   808.645     0.150
    77.748   719.645     0.150
    77.748   715.645     0.150
    77.748   724.645     0.150
    77.748    21.000     0.150
    77.795   713.145     0.150
    78.167  1314.645     0.150
    78.167  1314.645     0.150
    78.265   711.645     0.150
    78.631   723.645     0.150
    78.631   869.645     0.150
    78.665    14.301     0.150
    78.665   778.645     0.150
    78.665   736.645     0.150
    78.665   734.145     0.150
    78.698   745.645     0.150
    80.422     6.199     0.150
    81.796   916.645     0.150
    81.861  1338.344     0.150
    82.184   737.543     0.150
    84.861   749.645     0.150
    85.166   755.645     0.150
    90.571   775.645     0.150
   159.237  1197.246     0.150
     0.033     9.828     0.150
     1.263    19.230     0.150
     1.263    34.930     0.150
     1.369    38.629     0.150
     2.739    41.930     0.150
    58.889   598.031     0.150
     0.159    12.438     0.150
     0.564    20.836     0.150
     1.138    18.039     0.150
     1.138    32.836     0.150
     1.262    36.336     0.150
     1.556    26.836     0.150
     3.192    51.836     0.150
     3.884    60.836     0.150
     4.765    74.836     0.150
     4.765    74.836     0.150
     4.897    73.836     0.150
     4.897   131.633     0.150
    18.572   249.836     0.150
    19.292   264.039     0.150
    21.312   515.336     0.150
    21.567    14.102     0.150
    21.567    13.805     0.150
    32.968   389.633     0.150
    41.842   476.438     0.150
    60.583   604.836     0.150
    63.804   627.039     0.150
    73.445   687.836     0.150
    80.619   727.836     0.150
     0.078     9.684     0.150
     0.496    19.684     0.150
     1.218    18.785     0.150
     1.218    32.984     0.150
     1.328    20.785     0.150
     1.328    37.484     0.150
     3.258    54.984     0.150
     6.273    90.984     0.150
    12.566   184.984     0.150
    12.566   185.484     0.150
    18.567   252.984     0.150
    19.355   264.785     0.150
    21.563    15.000     0.150
    21.563    14.602     0.150
    28.163   347.984     0.150
    32.945   389.984     0.150
    32.945     7.000     0.150
    42.760   472.984     0.150
    62.343   620.984     0.150
    62.282   617.285     0.150
    63.852   628.984     0.150
    65.003   636.984     0.150
    65.892   643.184     0.150
    68.216   653.984     0.150
    68.774   659.285     0.150
    73.395   690.484     0.150
    73.395   713.984     0.150
    77.124   710.984     0.150
    85.695   763.285     0.150
    85.695     3.398     0.150
     0.240    11.332     0.150
     1.061    17.730     0.150
     1.171    35.133     0.150
     1.801    55.332     0.150
     6.748   187.934     0.150
    10.884   328.332     0.150
    30.975   358.832     0.150
    53.644   541.332     0.150
    60.500   602.332     0.150
    62.334   615.332     0.150
    62.335   616.230     0.150
    62.542   628.332     0.150
    72.914   684.332     0.150
    77.468   848.332     0.150
    78.490   726.332     0.150
    78.531   718.332     0.150
    83.919   748.934     0.150
    84.169   750.633     0.150
    84.207   751.633     0.150
    84.967   755.832     0.150
    86.275   762.934     0.150
     0.037    10.262     0.150
     1.261    20.062     0.150
     1.261    35.961     0.150
     1.371    39.660     0.150
     1.983    52.762     0.150
     8.050   121.961     0.150
     8.050   122.359     0.150
    21.378   516.859     0.150
    23.964   311.961     0.150
    28.207   397.262     0.150
    29.692   361.961     0.150
    40.203   815.762     0.150
    52.065   548.961     0.150
    52.065   548.961     0.150
    53.278   546.961     0.150
    53.278   546.961     0.150
    62.714   626.062     0.150
    63.888   628.859     0.150
    65.929   642.359     0.150
    69.257   668.961     0.150
    69.257   668.961     0.150
    78.709   720.160     0.150
     0.243    14.020     0.150
     1.065    17.619     0.150
     1.065    30.318     0.150
     1.237    37.020     0.150
     1.656    30.119     0.150
     6.186   161.520     0.150
    62.301   622.119     0.150
     0.192    11.578     0.150
     0.585    11.680     0.150
     1.105    18.379     0.150
     1.105    32.879     0.150
     3.097    50.680     0.150
     3.207    52.680     0.150
     6.577   169.680     0.150
     7.895   127.680     0.150
     7.895   128.480     0.150
     9.721   256.680     0.150
    10.885   158.980     0.150
    11.016   159.480     0.150
    12.611   183.281     0.150
    27.556   337.680     0.150
    27.556   338.379     0.150
    30.266   370.680     0.150
    30.266   370.680     0.150
    30.266   416.680     0.150
    32.209   385.379     0.150
    32.961   390.680     0.150
    32.961    10.000     0.150
    32.961   470.680     0.150
    38.483   438.578     0.150
    38.483   795.680     0.150
    38.846   439.680     0.150
    43.592    18.500     0.150
    46.356   504.680     0.150
    51.192   546.680     0.150
    51.192   546.680     0.150
    51.923   546.680     0.150
    51.923     6.500     0.150
    53.013   559.680     0.150
    53.013   560.281     0.150
    53.136   554.680     0.150
    53.136     6.500     0.150
    54.661   573.680     0.150
    63.645   628.680     0.150
    63.645     6.000     0.150
    63.772   628.680     0.150
    65.810   641.980     0.150
    68.739   661.680     0.150
    77.041   711.980     0.150
    78.585   720.578     0.150
    78.844   722.480     0.150
     0.118    10.422     0.150
     1.183    19.422     0.150
     1.183    35.227     0.150
     1.283    39.023     0.150
     2.977    47.023     0.150
     2.977    81.023     0.150
     3.487    52.820     0.150
     4.753    76.023     0.150
     4.753   130.023     0.150
     4.841    74.023     0.150
     4.841   131.023     0.150
     5.376    83.023     0.150
     6.053    90.125     0.150
     6.066   162.023     0.150
     6.876   105.625     0.150
     6.876   105.625     0.150
     7.974   116.422     0.150
    11.021   156.820     0.150
    12.140   177.023     0.150
    12.557   185.125     0.150
    12.689   188.523     0.150
    18.537   461.023     0.150
    18.537   253.023     0.150
    18.537   461.023     0.150
    19.309   261.227     0.150
    20.031    11.000     0.150
    21.303   517.422     0.150
    21.303   281.422     0.150
    21.303   309.922     0.150
    21.303   517.422     0.150
    21.303   523.727     0.150
    21.532     8.594     0.150
    21.532   286.227     0.150
    21.532     8.594     0.150
    21.532   320.523     0.150
    21.532   518.227     0.150
    27.620   618.023     0.150
    27.620   618.023     0.150
    27.620   690.023     0.150
    28.120   626.023     0.150
    28.120   348.422     0.150
    28.120   396.023     0.150
    28.120   626.023     0.150
    28.587   361.227     0.150
    28.587   666.023     0.150
    29.604   362.023     0.150
    30.274   365.023     0.150
    30.274   430.023     0.150
    30.274   434.523     0.150
    32.288   385.227     0.150
    32.923   386.023     0.150
    32.923    11.500     0.150
    32.923   386.023     0.150
    32.923     9.000     0.150
    32.923    11.500     0.150
    32.923   704.625     0.150
    32.923   721.023     0.150
    32.945   403.023     0.150
    33.172   394.023     0.150
    33.325   390.820     0.150
    33.909   399.320     0.150
    36.941   426.023     0.150
    38.546   438.922     0.150
    38.546   793.023     0.150
    38.880   438.625     0.150
    38.880   801.023     0.150
    39.582   816.023     0.150
    39.792   449.727     0.150
    40.115   452.422     0.150
    40.115   819.227     0.150
    41.147   485.023     0.150
    41.984   469.023     0.150
    41.984   501.523     0.150
    41.984   531.625     0.150
    42.716   854.320     0.150
    42.716   473.625     0.150
    42.716     5.398     0.150
    42.716   854.320     0.150
    42.716   871.625     0.150
    43.669    17.000     0.150
    46.428   505.023     0.150
    48.488   519.023     0.150
    48.488   944.023     0.150
    48.856    18.203     0.150
    48.856    17.406     0.150
    51.264   978.820     0.150
    51.976   547.023     0.150
    51.976   989.023     0.150
    53.190   555.727     0.150
    53.190    11.000     0.150
    53.190  1004.023     0.150
    53.347   997.727     0.150
    53.347   556.727     0.150
    53.347   997.727     0.150
    54.362   563.422     0.150
    54.362  1017.125     0.150
    54.734   566.227     0.150
    54.734  1024.922     0.150
    55.407  1033.625     0.150
    55.407  1033.625     0.150
    58.384   592.023     0.150
    58.384     9.797     0.150
    62.072   619.023     0.150
    62.843   624.422     0.150
    62.843     6.602     0.150
    62.843  1139.023     0.150
    63.691    15.000     0.150
    63.691   628.023     0.150
    63.691    15.000     0.150
    63.691   669.023     0.150
    64.242   632.023     0.150
    64.242  1148.023     0.150
    64.550    14.703     0.150
    64.550   633.320     0.150
    64.550    14.703     0.150
    64.550  1149.023     0.150
    65.846   637.227     0.150
    66.886   650.422     0.150
    68.171   658.023     0.150
    68.171  1194.023     0.150
    68.782   662.023     0.150
    68.782  1203.023     0.150
    68.843   662.625     0.150
    68.843     7.000     0.150
    68.843  1207.023     0.150
    68.843  1242.023     0.150
    69.097   682.023     0.150
    69.097   707.023     0.150
    69.563   668.023     0.150
    73.583   689.023     0.150
    73.765   694.023     0.150
    73.765  1263.023     0.150
    74.155   692.023     0.150
    74.937   694.023     0.150
    75.340   708.922     0.150
    75.662   710.023     0.150
    76.053   697.023     0.150
    77.078   728.023     0.150
    77.078   875.023     0.150
    77.079   710.922     0.150
    77.079   717.523     0.150
    77.078   710.625     0.150
    77.078   727.922     0.150
    77.561   730.727     0.150
    77.561   743.125     0.150
    77.561   758.523     0.150
    77.561   714.023     0.150
    77.561   730.727     0.150
    77.753   719.023     0.150
    78.127   717.023     0.150
    78.228   714.023     0.150
    78.590   800.023     0.150
    78.590   720.125     0.150
    78.590    10.898     0.150
    78.624     4.000     0.150
    78.624   764.922     0.150
    78.624   723.523     0.150
    81.356   735.727     0.150
    81.531   732.922     0.150
    81.757   735.023     0.150
    81.818   730.820     0.150
    82.149   742.227     0.150
    82.224   742.727     0.150
    83.760   747.820     0.150
    83.807   748.023     0.150
    84.017   728.023     0.150
    84.207   750.023     0.150
    84.581   752.227     0.150
    84.821   750.523     0.150
    85.055   752.320     0.150
    85.204   753.023     0.150
    86.210   760.023     0.150
    87.641   768.820     0.150
   111.333  1119.125     0.150
   123.248  1136.023     0.150
   123.248  1227.320     0.150
   142.419  1169.023     0.150
   147.502  1214.422     0.150
   147.502  1215.422     0.150
     1.093    17.367     0.150
     1.093    30.969     0.150
     1.228    35.672     0.150
     1.915    54.969     0.150
     3.183    49.969     0.150
     3.227    91.969     0.150
     4.766    73.969     0.150
     4.766    73.969     0.150
     4.931    74.367     0.150
     5.355    80.070     0.150
     6.714    98.969     0.150
     7.716   111.969     0.150
    18.582   251.969     0.150
    21.298   298.266     0.150
    21.298   298.266     0.150
    21.298   512.570     0.150
    21.344   520.969     0.150
    21.576   283.969     0.150
    21.576   300.469     0.150
    30.283   365.367     0.150
    30.283   419.969     0.150
    32.987   389.266     0.150
    32.987   452.969     0.150
    32.987   700.969     0.150
    38.856   444.969     0.150
    38.856   444.969     0.150
    42.648   472.969     0.150
    42.648     7.500     0.150
    42.648   473.867     0.150
    51.926   544.969     0.150
    53.139   552.969     0.150
    54.653   582.969     0.150
    54.653   583.766     0.150
    63.782   626.266     0.150
    65.820   639.969     0.150
    72.930   682.969     0.150
    73.478   675.969     0.150
     0.184    12.268     0.150
     1.124    18.168     0.150
     1.279    37.668     0.150
     2.545    66.668     0.150
     3.041    88.668     0.150
     3.324    50.668     0.150
     4.950    75.168     0.150
     4.950   135.468     0.150
    12.629   181.468     0.150
    18.628   253.668     0.150
    20.533   272.368     0.150
    21.353   286.668     0.150
    21.353   286.668     0.150
    21.353   511.868     0.150
    21.344   279.668     0.150
    21.622   285.768     0.150
    30.337   361.668     0.150
    32.223   383.968     0.150
    33.026   391.068     0.150
    33.026     9.600     0.150
    33.026   703.668     0.150
    41.898   467.668     0.150
    53.190   552.668     0.150
    53.299   555.768     0.150
    63.837   628.468     0.150
    68.761   657.668     0.150
    69.152   672.668     0.150
    69.152   672.968     0.150
    74.105   687.668     0.150
    75.358   704.668     0.150
    77.105   711.668     0.150
    77.585   713.468     0.150
    78.648   719.768     0.150
    78.692   723.168     0.150
    78.692     7.000     0.150
    79.082   722.668     0.150
    86.821   761.368     0.150
    86.901   761.868     0.150
    87.750   769.668     0.150
     0.170    11.158     0.150
     0.567    11.458     0.150
     1.127    18.758     0.150
     1.127    33.758     0.150
     1.246    38.158     0.150
     1.571    52.758     0.150
     3.275    53.758     0.150
     3.390    52.158     0.150
     4.893    74.758     0.150
     4.893   135.758     0.150
     6.728    99.758     0.150
     6.883   105.758     0.150
     6.883   105.857     0.150
     7.917   119.758     0.150
     7.917   119.758     0.150
     9.148   134.758     0.150
     9.743   258.758     0.150
    10.897   160.357     0.150
    12.605   181.758     0.150
    12.605   181.758     0.150
    12.605   323.357     0.150
    15.286   228.758     0.150
    15.286   228.758     0.150
    18.559   252.758     0.150
    19.973   484.758     0.150
    21.295   280.857     0.150
    21.295   314.958     0.150
    21.295   553.958     0.150
    21.554   285.758     0.150
    21.554   316.058     0.150
    23.846   305.758     0.150
    27.577   624.258     0.150
    28.074   347.758     0.150
    29.560   361.758     0.150
    30.275   370.758     0.150
    30.275   370.758     0.150
    30.275   430.758     0.150
    30.452   368.258     0.150
    32.231   385.558     0.150
    32.885   389.758     0.150
    32.958   717.758     0.150
    32.958   390.758     0.150
    32.958   480.758     0.150
    32.958   717.758     0.150
    33.265   391.357     0.150
    36.881   438.758     0.150
    38.504   439.158     0.150
    38.504   795.758     0.150
    38.861   438.758     0.150
    39.747   449.758     0.150
    40.075   452.258     0.150
    40.075   806.258     0.150
    41.924    17.000     0.150
    42.672   472.758     0.150
    48.806   522.758     0.150
    51.214   980.857     0.150
    51.942   547.758     0.150
    53.294   556.857     0.150
    55.357   574.758     0.150
    55.357   575.458     0.150
    59.338   601.758     0.150
    62.175   617.258     0.150
    62.796   634.758     0.150
    62.796  3596.000     0.150
    62.796   634.758     0.150
    62.796    -4.000     0.150
    63.663   629.758     0.150
    63.787   629.058     0.150
    64.220   632.758     0.150
    64.521   634.758     0.150
    65.826   641.758     0.150
    68.756   661.758     0.150
    69.127   665.958     0.150
    73.551   690.758     0.150
    73.551   694.758     0.150
    73.551     5.500     0.150
    74.900   693.258     0.150
    75.384   711.758     0.150
    75.384   712.258     0.150
    76.250   728.758     0.150
    76.250   778.758     0.150
    77.057   711.357     0.150
    77.057   709.758     0.150
    77.057   709.758     0.150
    77.515   715.758     0.150
    78.107   717.758     0.150
    78.565   739.758     0.150
    78.565   741.758     0.150
    78.565   720.658     0.150
    78.641   720.758     0.150
    81.501   730.258     0.150
    81.700   737.258     0.150
    85.933   757.158     0.150
    87.693   797.758     0.150
     0.267    12.893     0.150
     1.031    18.293     0.150
     1.031    31.492     0.150
     4.093    64.492     0.150
     4.771    72.691     0.150
     4.982    76.992     0.150
     5.601    84.492     0.150
     6.515   166.492     0.150
     6.671    94.293     0.150
     6.896   105.191     0.150
     6.896   105.191     0.150
     7.820   115.691     0.150
     9.071   133.492     0.150
    12.687   178.492     0.150
    15.364   217.492     0.150
    15.364   217.492     0.150
    18.599   253.492     0.150
    19.218   259.592     0.150
    21.282    15.699     0.150
    21.282   296.191     0.150
    21.282   314.191     0.150
    21.282   511.191     0.150
    21.282   547.592     0.150
    21.592    10.301     0.150
    21.592   285.492     0.150
    21.592    10.301     0.150
    21.592   316.992     0.150
    21.592   520.992     0.150
    23.795   306.592     0.150
    27.502   353.492     0.150
    27.502   354.191     0.150
    27.994   347.492     0.150
    27.994   394.492     0.150
    27.994   721.492     0.150
    29.483   361.492     0.150
    32.133   384.293     0.150
    33.018   390.992     0.150
    33.018     7.500     0.150
    33.018   454.492     0.150
    33.018   705.492     0.150
    33.162   390.893     0.150
    38.432   437.893     0.150
    38.432   792.492     0.150
    38.403   448.992     0.150
    38.829   439.191     0.150
    38.829   531.492     0.150
    38.829   984.492     0.150
    41.820   501.992     0.150
    43.508   471.592     0.150
    43.508    20.400     0.150
    46.290   503.492     0.150
    46.799   918.092     0.150
    46.804   918.092     0.150
    51.127   540.592     0.150
    51.127   976.592     0.150
    51.884     7.000     0.150
    51.884   546.293     0.150
    51.884     7.000     0.150
    53.097   554.691     0.150
    53.609  1007.492     0.150
    54.221  1014.393     0.150
    54.595   565.592     0.150
    54.595  1020.592     0.150
    58.339   591.492     0.150
    62.264  4168.492     0.150
    62.715  1126.492     0.150
    63.614   627.492     0.150
    63.755   628.492     0.150
    63.987   641.592     0.150
    64.181   631.492     0.150
    64.472   632.992     0.150
    65.791   641.492     0.150
    69.057   664.492     0.150
    73.497   689.492     0.150
    75.337   694.492     0.150
    75.337   694.492     0.150
    75.499   703.492     0.150
    76.204   718.492     0.150
    76.204   730.492     0.150
    76.204   749.492     0.150
    77.019   710.092     0.150
    77.021    19.400     0.150
    77.021   741.492     0.150
    77.021   710.092     0.150
    77.021   729.393     0.150
    77.500   714.092     0.150
    77.892   709.092     0.150
    78.071   716.492     0.150
    78.071   716.492     0.150
    78.522   785.492     0.150
    78.522   719.691     0.150
    78.522   727.492     0.150
    78.522    14.801     0.150
    78.563    15.199     0.150
    78.563   719.393     0.150
    78.563   734.393     0.150
    78.612   718.492     0.150
    79.979   728.092     0.150
    83.427   743.492     0.150
    83.611   743.492     0.150
     1.191    22.047     0.150
     1.614    24.746     0.150
     1.614    43.246     0.150
     1.657    44.246     0.150
     3.411    90.047     0.150
     4.806   128.547     0.150
     4.806    70.445     0.150
     4.806   128.547     0.150
    18.500   248.047     0.150
    19.642   264.348     0.150
    21.483   280.348     0.150
    32.788   386.047     0.150
    32.788    12.000     0.150
    64.051   625.648     0.150
    66.099   639.047     0.150
    84.427   747.246     0.150
    85.817   753.746     0.150
     0.166    10.035     0.150
     0.494    20.135     0.150
     1.167    19.234     0.150
     1.167    34.635     0.150
     1.790    28.635     0.150
     2.812    42.635     0.150
     3.484    53.635     0.150
     6.836   101.635     0.150
    28.080   349.635     0.150
    30.206    11.000     0.150
    30.206    10.500     0.150
    32.865   392.435     0.150
    44.214   487.436     0.150
    51.923    16.000     0.150
    51.923   547.635     0.150
    51.923    16.000     0.150
    62.381   624.635     0.150
    64.492   631.635     0.150
    64.492   632.436     0.150
    64.492   663.635     0.150
    65.783     4.000     0.150
    65.783   642.635     0.150
     0.154    11.406     0.150
     0.450    18.406     0.150
     1.207    19.406     0.150
     1.207    34.508     0.150
     1.258    37.406     0.150
     3.374    62.406     0.150
     7.865   115.406     0.150
     7.865   206.406     0.150
    40.604   473.605     0.150
    44.177   488.406     0.150
    65.791   636.406     0.150
     0.028    10.332     0.150
     1.279    20.532     0.150
     1.279    36.332     0.150
     1.393    40.932     0.150
     2.961    46.932     0.150
     2.961    82.032     0.150
     3.454    53.332     0.150
     3.454    53.332     0.150
     3.454    92.432     0.150
     4.813    71.932     0.150
     4.813   127.432     0.150
     4.828   131.932     0.150
     6.015   162.932     0.150
     6.256   163.932     0.150
     6.404   175.932     0.150
     6.577   171.932     0.150
     6.955   186.832     0.150
     6.955   103.832     0.150
     6.955   186.832     0.150
     8.726   231.932     0.150
     8.726   231.932     0.150
     9.898   257.932     0.150
    11.417   293.231     0.150
    11.417   164.832     0.150
    11.417   293.231     0.150
    12.160   174.932     0.150
    15.247   212.932     0.150
    18.591   456.932     0.150
    20.465   513.932     0.150
    21.398   320.632     0.150
    21.398   514.632     0.150
    21.398   524.932     0.150
    21.587   285.132     0.150
    21.587   520.632     0.150
    23.602     8.100     0.150
    24.533   664.932     0.150
    27.730   392.932     0.150
    27.730   623.932     0.150
    28.228   637.932     0.150
    28.228   349.532     0.150
    28.228   637.932     0.150
    28.506   365.332     0.150
    30.360   672.932     0.150
    30.360   672.932     0.150
    32.954   389.932     0.150
    32.954   704.432     0.150
    38.656   439.932     0.150
    38.656   792.932     0.150
    38.983   440.432     0.150
    38.983   570.932     0.150
    40.225   453.332     0.150
    40.225   815.932     0.150
    42.825   474.231     0.150
    42.825   853.332     0.150
    43.724   879.932     0.150
    51.369   979.132     0.150
    52.087   547.731     0.150
    52.087   988.932     0.150
    53.300  1004.932     0.150
    53.857  1011.332     0.150
    54.466   564.932     0.150
    54.466  1018.231     0.150
    54.838   566.932     0.150
    54.838  1025.932     0.150
    59.056  1083.932     0.150
    62.951   624.932     0.150
    62.951  1130.932     0.150
    63.800     6.000     0.150
    63.800   629.932     0.150
    63.800     6.000     0.150
    63.909   628.932     0.150
    64.348   632.932     0.150
    64.658  1163.932     0.150
    64.658   633.932     0.150
    64.658  1163.932     0.150
    65.950  1183.932     0.150
    65.950   641.932     0.150
    65.984   648.932     0.150
    68.281  1187.932     0.150
    68.281   656.932     0.150
    68.281  1187.932     0.150
    68.889   660.932     0.150
    68.952   662.132     0.150
    69.279   665.932     0.150
    69.279  1211.932     0.150
    70.288   670.932     0.150
    73.692   691.432     0.150
    73.692   703.932     0.150
    73.692  1260.932     0.150
    73.873   693.932     0.150
    75.367   702.932     0.150
    75.519   701.932     0.150
    75.790   701.932     0.150
    76.162   708.932     0.150
    76.307   704.932     0.150
    76.307   721.932     0.150
    76.365   708.932     0.150
    76.385  3374.000     0.150
    76.385  4088.932     0.150
    77.184   711.231     0.150
    77.184   726.132     0.150
    77.183   710.231     0.150
    77.183   726.032     0.150
    77.667   713.731     0.150
    77.814   736.932     0.150
    77.814   762.932     0.150
    77.814   713.932     0.150
    77.814   728.932     0.150
    78.232   716.932     0.150
    78.232   732.432     0.150
    78.612   708.932     0.150
    78.730    16.000     0.150
    78.730   749.132     0.150
    78.730   719.932     0.150
    78.730   735.932     0.150
    80.959   762.532     0.150
    82.002   735.432     0.150
    82.375   743.932     0.150
    84.017   735.432     0.150
    87.467   766.731     0.150
   111.440  1106.932     0.150
     0.037     9.934     0.150
     1.320    20.633     0.150
     1.320    36.533     0.150
     1.432    24.234     0.150
     1.432    41.133     0.150
     4.301    66.934     0.150
     5.388    76.934     0.150
     6.615   182.934     0.150
     6.752   176.834     0.150
     7.739   195.934     0.150
    58.897   597.234     0.150
     0.150    11.078     0.150
     0.437    18.176     0.150
     1.219    18.977     0.150
     1.219    33.676     0.150
     1.268    36.477     0.150
     1.734    46.777     0.150
     2.849    42.777     0.150
     3.528    53.176     0.150
     4.425    63.777     0.150
     6.858   179.977     0.150
     7.380   107.176     0.150
    43.743   486.477     0.150
    58.789   596.977     0.150
    62.712   633.379     0.150
     1.655    25.828     0.150
     1.655    44.625     0.150
     1.685    45.328     0.150
     7.886   206.328     0.150
    62.351   632.328     0.150
    62.352   634.328     0.150
     1.347    20.934     0.150
     1.347    36.832     0.150
     1.420    38.332     0.150
     1.930    56.133     0.150
     3.242    91.133     0.150
     3.509    93.133     0.150
     5.774    86.133     0.150
     6.098    87.133     0.150
     6.813    98.832     0.150
     6.813   162.832     0.150
    21.516    17.500     0.150
    21.516    17.102     0.150
    21.590   279.133     0.150
    27.775   336.234     0.150
    44.188   485.133     0.150
    49.314   524.133     0.150
    51.270   542.133     0.150
    60.664   605.133     0.150
    62.387   618.133     0.150
    69.865   656.734     0.150
     0.904    30.536     0.150
     1.075    17.536     0.150
     1.075    31.136     0.150
     1.214    36.236     0.150
     1.578    50.036     0.150
     1.609    29.236     0.150
     1.609    48.136     0.150
     1.929    55.536     0.150
     2.687    69.436     0.150
     3.598    54.036     0.150
     4.943    75.236     0.150
     6.695    97.936     0.150
     7.221   104.335     0.150
     7.220   107.136     0.150
    18.583   254.036     0.150
    19.246   262.436     0.150
    21.290   297.036     0.150
    21.290   297.236     0.150
    21.290   510.436     0.150
    42.631   476.036     0.150
    42.631    22.400     0.150
    42.631   476.036     0.150
    42.631    22.400     0.150
    63.771   626.835     0.150
    65.809   642.036     0.150
    69.090   663.036     0.150
    69.584   663.536     0.150
     1.344    20.980     0.150
     1.344    36.881     0.150
     1.429    38.580     0.150
     1.953    30.180     0.150
     1.982    50.279     0.150
     4.538   125.279     0.150
     4.753    71.381     0.150
     6.929    87.680     0.150
     6.929    87.680     0.150
     7.171   109.580     0.150
     8.134   115.580     0.150
     9.957   261.580     0.150
    19.446   259.580     0.150
    21.390   277.080     0.150
    21.390   277.080     0.150
    27.772     8.000     0.150
    27.772   342.580     0.150
    27.772     8.000     0.150
    28.275   622.580     0.150
    28.275   346.980     0.150
    28.275   622.580     0.150
    28.532   368.580     0.150
    29.757   361.180     0.150
    30.340   415.580     0.150
    30.340   441.580     0.150
    32.448   691.080     0.150
    32.895   386.580     0.150
    32.895    19.000     0.150
    32.895   698.580     0.150
    34.063   398.279     0.150
    34.063   721.279     0.150
    38.696   437.080     0.150
    38.696   788.580     0.150
    38.989   435.580     0.150
    38.989    10.000     0.150
    38.989     9.699     0.150
    38.989   574.580     0.150
    39.945   810.279     0.150
    40.262   450.279     0.150
    40.262   813.580     0.150
    41.296    11.000     0.150
    41.296    24.500     0.150
    41.744   463.080     0.150
    46.588   502.580     0.150
    48.669   518.680     0.150
    51.424   972.881     0.150
    51.424   538.881     0.150
    51.424   972.881     0.150
    52.115   544.580     0.150
    52.115   611.580     0.150
    57.100   624.580     0.150
    60.683   605.881     0.150
    62.122   615.381     0.150
    62.230   621.580     0.150
    62.230   621.779     0.150
    62.405   617.580     0.150
    63.820   628.580     0.150
    63.915   625.279     0.150
    63.915   625.279     0.150
    65.724   637.580     0.150
    65.958   638.580     0.150
    67.175   683.580     0.150
    68.237   655.580     0.150
    68.836   658.680     0.150
    71.527   675.580     0.150
    73.841   689.580     0.150
    74.775   695.080     0.150
    74.775   718.580     0.150
    75.462   699.080     0.150
    75.462   715.080     0.150
    75.536   701.080     0.150
    76.186   700.580     0.150
    76.319   704.080     0.150
    76.402   708.580     0.150
    77.075    13.000     0.150
    77.192   708.381     0.150
    77.192   771.580     0.150
    77.192   708.381     0.150
    77.194   709.580     0.150
    77.678   711.580     0.150
    77.678   712.381     0.150
    78.241   714.580     0.150
    78.655   717.580     0.150
    78.742   780.580     0.150
    78.742   716.680     0.150
    78.999   719.279     0.150
    79.170   720.680     0.150
    81.116   731.480     0.150
    81.444   730.980     0.150
    81.660   733.381     0.150
    82.330   736.680     0.150
    83.274   741.779     0.150
    83.815   744.381     0.150
    84.023   745.381     0.150
    84.113   745.980     0.150
    84.364   747.180     0.150
    84.401   747.580     0.150
    85.161   752.080     0.150
    85.476   753.080     0.150
    85.693   754.480     0.150
    86.031   755.381     0.150
    86.229   756.580     0.150
    86.277   756.779     0.150
    86.470   759.080     0.150
    86.894   761.080     0.150
    86.976   761.480     0.150
    87.545   777.580     0.150
     0.074     6.750     0.150
     0.390    16.449     0.150
     1.298    21.250     0.150
     1.298    38.449     0.150
     1.365    41.549     0.150
     1.389    23.850     0.150
     1.579    42.648     0.150
     1.707    48.449     0.150
     1.913    34.449     0.150
     2.087    67.350     0.150
     3.343    99.449     0.150
     4.723    75.250     0.150
     4.723    75.250     0.150
     4.723   137.949     0.150
     4.740    72.449     0.150
     6.702   170.449     0.150
     6.826   179.148     0.150
     6.867   104.949     0.150
     6.867   104.949     0.150
     7.322   111.449     0.150
     7.345   108.049     0.150
     9.904   265.449     0.150
    12.802   190.850     0.150
    18.494   251.449     0.150
    18.494   474.449     0.150
    21.323   316.350     0.150
    21.323   326.350     0.150
    21.323   516.350     0.150
    21.491    13.900     0.150
    21.491    13.201     0.150
    23.940   313.449     0.150
    23.940   313.949     0.150
    32.857   391.449     0.150
    33.066   397.648     0.150
    37.061   433.449     0.150
    38.632   790.449     0.150
    38.632   790.449     0.150
    41.268   457.449     0.150
    44.940   501.449     0.150
    48.404   520.850     0.150
    52.047    18.900     0.150
    52.047   548.449     0.150
    52.047    18.900     0.150
    55.527   568.449     0.150
    62.053   621.350     0.150
    62.775   628.449     0.150
    63.846   630.449     0.150
    65.888   643.549     0.150
    75.393   701.449     0.150
    77.123   712.449     0.150
    77.609   798.449     0.150
    77.609   718.148     0.150
    78.672   823.449     0.150
    78.672   721.350     0.150
    83.205   745.750     0.150
    83.746   750.350     0.150
    83.954   752.049     0.150
    84.045   752.648     0.150
    84.295   753.648     0.150
    84.332   753.449     0.150
    84.614   756.648     0.150
    85.092   757.750     0.150
    86.401   764.648     0.150
   143.190  1180.449     0.150
   146.949  2984.949     0.150
   151.914  1170.449     0.150
   152.135  1192.449     0.150
     0.617    22.758     0.150
     1.503    41.258     0.150
     1.507    23.859     0.150
     1.507    41.059     0.150
     1.844    28.457     0.150
     1.912    47.957     0.150
     2.656    40.859     0.150
     2.656    71.258     0.150
     3.146    47.758     0.150
     3.146    81.758     0.150
     4.523    68.059     0.150
     4.523   119.059     0.150
     4.651   107.059     0.150
     4.651    67.859     0.150
     4.651   107.059     0.150
     5.618   142.059     0.150
    12.257   169.758     0.150
    18.371   448.059     0.150
    21.314   503.559     0.150
    21.314   276.359     0.150
    21.314   297.559     0.150
    21.314   313.559     0.150
    21.314   503.559     0.150
    21.369   277.859     0.150
    21.369   508.859     0.150
    21.369   536.859     0.150
    21.796   526.059     0.150
    24.020   304.059     0.150
    28.365   622.059     0.150
    28.365   346.660     0.150
    28.365   622.059     0.150
    28.365   734.359     0.150
    29.838   359.758     0.150
    30.233   356.059     0.150
    30.233   356.559     0.150
    30.233   428.059     0.150
    32.607   697.957     0.150
    32.690    31.000     0.150
    32.690   383.059     0.150
    32.690    21.000     0.150
    32.690    31.000     0.150
    32.690   691.059     0.150
    38.763   435.457     0.150
    38.763   789.059     0.150
    38.952   545.059     0.150
    40.025   447.359     0.150
    40.025   799.359     0.150
    40.408   441.457     0.150
    51.538   984.359     0.150
    53.355   551.559     0.150
    53.350    20.000     0.150
    53.350    19.199     0.150
    54.089  1016.059     0.150
    54.786   559.559     0.150
    62.463   617.258     0.150
    63.878   623.660     0.150
    64.682   629.059     0.150
    65.925   636.957     0.150
    69.379   658.059     0.150
    69.379   658.059     0.150
    73.113   681.059     0.150
    73.113    29.000     0.150
    75.452   696.258     0.150
    75.452   702.758     0.150
    75.777    22.000     0.150
    76.299   700.059     0.150
    76.396   707.059     0.150
    76.396    34.000     0.150
    77.086   700.559     0.150
    77.164   704.859     0.150
    77.164    25.199     0.150
    77.169    27.898     0.150
    77.169    27.500     0.150
    78.211    28.000     0.150
    78.557   729.059     0.150
    80.997   726.258     0.150
    81.369   730.059     0.150
    85.383   790.758     0.150
    85.383   824.457     0.150
    85.583    15.602     0.150
   151.757  1176.059     0.150
     0.125    11.184     0.150
     1.174    18.383     0.150
     1.174    33.383     0.150
     1.279    37.785     0.150
    21.306    13.602     0.150
    43.658   488.383     0.150
    43.658   488.285     0.150
    60.583   608.184     0.150
    65.846   640.184     0.150
    73.401   689.484     0.150
    83.707   746.984     0.150
    86.309   754.184     0.150
     0.750    27.156     0.150
     1.730    27.352     0.150
     1.724    48.750     0.150
     1.848    30.055     0.150
     2.248    35.352     0.150
     2.734    41.656     0.150
     3.866   100.453     0.150
     4.115   109.453     0.150
     4.455    64.656     0.150
     5.768    83.453     0.150
     6.626    94.656     0.150
     6.626   169.453     0.150
     7.156   184.250     0.150
     7.714   195.156     0.150
     8.353   118.555     0.150
     8.600   123.453     0.150
    10.794   152.156     0.150
    11.237   153.656     0.150
    11.857   163.055     0.150
    12.879   179.852     0.150
    14.560   196.453     0.150
    18.077   241.453     0.150
    19.549   468.352     0.150
    21.078   274.555     0.150
    21.078   296.750     0.150
    21.078   499.750     0.150
    21.179     6.602     0.150
    21.179    25.500     0.150
    21.179   547.953     0.150
    21.346    25.602     0.150
    23.885   544.453     0.150
    24.210    12.000     0.150
    25.073   590.453     0.150
    26.215   373.453     0.150
    28.004   341.453     0.150
    28.004    27.000     0.150
    28.004   620.453     0.150
    28.004   721.453     0.150
    28.549   347.852     0.150
    28.549   628.453     0.150
    30.004   360.852     0.150
    30.062   362.453     0.150
    30.062   362.453     0.150
    30.062   548.953     0.150
    30.062   645.453     0.150
    31.708   378.453     0.150
    32.336    20.000     0.150
    32.336   379.453     0.150
    32.336    20.000     0.150
    32.336   467.453     0.150
    32.336   683.453     0.150
    32.336   721.453     0.150
    33.884   393.453     0.150
    34.071   468.453     0.150
    34.071   493.453     0.150
    34.310   397.250     0.150
    34.310   717.250     0.150
    35.208   413.055     0.150
    37.684   443.453     0.150
    37.684   794.453     0.150
    38.910   783.453     0.150
    38.910   824.453     0.150
    38.905   436.453     0.150
    38.905   787.453     0.150
    39.215   445.250     0.150
    40.189   805.453     0.150
    40.189   447.453     0.150
    40.189   805.453     0.150
    40.440   449.352     0.150
    40.440   810.852     0.150
    43.112   471.055     0.150
    43.112   848.250     0.150
    45.331   882.156     0.150
    47.428   912.453     0.150
    47.600   508.453     0.150
    47.600   917.453     0.150
    48.993   935.453     0.150
    48.993   518.453     0.150
    48.993   935.453     0.150
    49.339    25.000     0.150
    49.339   941.453     0.150
    49.848  1111.453     0.150
    51.762    32.703     0.150
    51.762   539.250     0.150
    51.762    32.703     0.150
    51.762   974.250     0.150
    52.216   541.453     0.150
    52.216   541.453     0.150
    52.216   617.055     0.150
    52.216   978.453     0.150
    52.894   552.453     0.150
    52.894  1000.953     0.150
    53.562   996.055     0.150
    53.876   555.055     0.150
    53.973   555.055     0.150
    53.973  1001.953     0.150
    54.398  1008.453     0.150
    54.879   561.656     0.150
    54.879  1015.156     0.150
    55.240   564.852     0.150
    55.240  1018.852     0.150
    55.893   568.453     0.150
    55.893    19.602     0.150
    55.893  1028.055     0.150
    56.277   574.250     0.150
    57.523   589.453     0.150
    58.310    23.000     0.150
    58.383   585.852     0.150
    58.383  1060.453     0.150
    58.383  1089.453     0.150
    60.101    35.500     0.150
    60.101  1093.453     0.150
    61.973   610.453     0.150
    62.314  1521.453     0.150
    62.357  1117.453     0.150
    62.693   615.750     0.150
    62.707  1113.453     0.150
    63.282   620.453     0.150
    63.282  1121.453     0.150
    63.833   622.352     0.150
    63.851   622.453     0.150
    63.851    19.000     0.150
    63.851  1128.453     0.150
    64.321   626.453     0.150
    64.321    19.000     0.150
    64.321  1133.453     0.150
    64.712   628.250     0.150
    64.712    20.203     0.150
    64.712   664.453     0.150
    64.712  1139.453     0.150
    64.712  1166.453     0.150
    64.712  1561.453     0.150
    64.945   642.750     0.150
    65.889  1181.453     0.150
    65.889  1597.453     0.150
    65.889   635.352     0.150
    66.415   621.453     0.150
    66.415  1168.453     0.150
    66.415   621.453     0.150
    66.415  1168.453     0.150
    67.224   658.656     0.150
    67.224   658.656     0.150
    67.224  1196.453     0.150
    68.325   653.453     0.150
    68.325  1185.453     0.150
    68.325  1213.453     0.150
    68.540   653.453     0.150
    68.540  1187.453     0.150
    68.903   656.453     0.150
    68.903  1191.453     0.150
    69.425   671.453     0.150
    69.758   658.453     0.150
    69.916  1208.453     0.150
    69.916   663.453     0.150
    69.916  1208.453     0.150
    69.925   661.453     0.150
    69.925  1207.453     0.150
    70.478   665.453     0.150
    70.478  1211.453     0.150
    70.525   667.453     0.150
    70.925   668.453     0.150
    70.925  1214.953     0.150
    73.783   685.453     0.150
    73.783  1237.453     0.150
    73.783  1279.453     0.150
    73.783  1308.453     0.150
    73.908   685.453     0.150
    73.908  1248.453     0.150
    74.740   678.453     0.150
    74.665   693.055     0.150
    74.837   690.453     0.150
    75.454   694.852     0.150
    75.454   703.453     0.150
    75.454    27.203     0.150
    75.454  1266.453     0.150
    75.554  1263.453     0.150
    75.554  1263.453     0.150
    75.785   696.250     0.150
    76.236   699.453     0.150
    77.129    36.000     0.150
    77.129   766.453     0.150
    77.135   748.453     0.150
    77.135   704.352     0.150
    77.135    21.102     0.150
    77.135  1284.453     0.150
    77.145   705.352     0.150
    77.145  1285.453     0.150
    77.797   711.453     0.150
    77.836   708.453     0.150
    77.836    30.000     0.150
    78.180   710.453     0.150
    78.294   714.453     0.150
    78.888   717.453     0.150
    79.828    17.797     0.150
    80.616   722.156     0.150
    80.847   723.453     0.150
    81.137   724.250     0.150
    83.735   740.055     0.150
    83.884   746.453     0.150
    85.204   753.953     0.150
    86.221   753.453     0.150
    86.287   754.453     0.150
   125.142  1132.453     0.150
     0.250    14.438     0.150
     0.833    29.641     0.150
     1.061    18.039     0.150
     1.061    31.738     0.150
     1.614    44.816     0.150
     1.585    25.117     0.150
     1.585    44.117     0.150
     2.679    41.516     0.150
     2.679    71.516     0.150
     3.146    47.816     0.150
     3.146    83.316     0.150
     3.410    56.316     0.150
     4.545    68.316     0.150
     4.545   120.316     0.150
     4.759    70.215     0.150
     6.617   171.316     0.150
     6.919    99.316     0.150
     7.441   103.117     0.150
     8.375   119.316     0.150
    12.290   170.215     0.150
    13.086   335.316     0.150
    14.994   207.316     0.150
    18.459   452.316     0.150
    19.594   269.316     0.150
    19.594   270.016     0.150
    20.437   516.316     0.150
    21.433   274.316     0.150
    21.433    24.102     0.150
    21.433   508.418     0.150
    21.433   275.215     0.150
    21.433    23.203     0.150
    21.433   309.617     0.150
    21.433   508.418     0.150
    21.433   528.418     0.150
    21.458    19.199     0.150
    21.458   279.816     0.150
    21.458    19.199     0.150
    21.458   511.016     0.150
    21.458   553.316     0.150
    27.960   343.316     0.150
    28.474   348.617     0.150
    28.474   630.316     0.150
    29.949   362.215     0.150
    30.346   362.316     0.150
    32.756   384.316     0.150
    32.756    20.000     0.150
    32.756   693.316     0.150
    38.877   438.516     0.150
    38.877   792.316     0.150
    39.075   436.715     0.150
    40.137   449.016     0.150
    40.137   799.418     0.150
    43.060   856.418     0.150
    43.060   472.715     0.150
    43.060    20.102     0.150
    43.060   856.418     0.150
    45.188   573.316     0.150
    47.039   510.418     0.150
    47.890   510.316     0.150
    48.865    19.199     0.150
    49.227    17.000     0.150
    52.263   544.617     0.150
    52.263    19.699     0.150
    52.263   618.215     0.150
    53.476   553.617     0.150
    54.743  1025.418     0.150
    55.886   573.316     0.150
    60.752   601.418     0.150
    63.946    28.000     0.150
    63.946   625.316     0.150
    63.946    28.000     0.150
    64.000   625.516     0.150
    64.805    24.500     0.150
    64.805   630.816     0.150
    64.805    24.500     0.150
    64.805   659.316     0.150
    66.048   638.918     0.150
    69.182   660.316     0.150
    70.261    13.000     0.150
    75.575   697.816     0.150
    76.113   688.316     0.150
    76.519   705.316     0.150
    76.519    38.000     0.150
    77.287   707.016     0.150
    77.287    22.301     0.150
    77.292   707.117     0.150
    77.292    23.699     0.150
    77.780   710.715     0.150
    78.843   716.816     0.150
    80.606    23.102     0.150
    81.376   729.117     0.150
    84.825   736.117     0.150
   111.697  1125.316     0.150
   132.008  1152.316     0.150
     0.070    10.672     0.150
     0.367    13.873     0.150
     1.550    42.373     0.150
     1.580    25.072     0.150
     1.580    44.072     0.150
     3.577    59.973     0.150
    58.549   595.072     0.150
    69.820   665.271     0.150
     1.531    43.371     0.150
     1.579    24.172     0.150
     1.579    44.070     0.150
    58.512   592.871     0.150
    62.323   618.871     0.150
     1.565    24.586     0.150
     1.565    43.484     0.150
     1.607    44.289     0.150
     2.713    70.688     0.150
     2.713    41.984     0.150
     2.713    70.688     0.150
     3.180    47.086     0.150
     3.180    82.688     0.150
     4.580    73.688     0.150
     4.580    73.688     0.150
     4.782    70.688     0.150
     5.529   145.086     0.150
     6.174    89.891     0.150
     6.412    91.789     0.150
     6.941   100.086     0.150
     6.941   173.688     0.150
     7.801   113.391     0.150
     8.355   117.688     0.150
     8.693   125.688     0.150
    12.325   172.688     0.150
    13.068   191.188     0.150
    13.068     6.500     0.150
    13.068   342.188     0.150
    14.564   359.688     0.150
    15.028   220.688     0.150
    15.028   220.688     0.150
    18.488   449.391     0.150
    18.488   449.391     0.150
    19.595   261.688     0.150
    20.753   270.688     0.150
    20.753   508.688     0.150
    20.753   514.688     0.150
    21.449   277.688     0.150
    21.449   508.188     0.150
    21.487   280.086     0.150
    21.487    20.102     0.150
    21.487   512.188     0.150
    24.824   576.688     0.150
    27.954   338.688     0.150
    27.954    19.000     0.150
    27.954   642.688     0.150
    27.954   338.688     0.150
    27.954    19.000     0.150
    27.954   620.688     0.150
    27.954   642.688     0.150
    28.466   634.688     0.150
    28.466   348.391     0.150
    28.466   634.688     0.150
    32.670   780.188     0.150
    32.789   385.688     0.150
    32.789    14.000     0.150
    32.789   465.688     0.150
    32.789   695.688     0.150
    38.873   782.688     0.150
    38.873   438.289     0.150
    38.873   782.688     0.150
    39.086    23.797     0.150
    39.086   793.688     0.150
    39.086   437.891     0.150
    39.086    23.797     0.150
    39.086   547.688     0.150
    39.086   793.688     0.150
    39.949   566.688     0.150
    40.130   449.086     0.150
    40.130   813.484     0.150
    40.431   450.984     0.150
    40.431   812.688     0.150
    42.360   463.688     0.150
    43.054    18.797     0.150
    43.054   855.391     0.150
    43.054   472.688     0.150
    43.054    18.797     0.150
    43.054    23.000     0.150
    43.054   855.391     0.150
    47.301   928.688     0.150
    48.853   941.688     0.150
    49.216   521.688     0.150
    51.218   530.688     0.150
    53.443   552.688     0.150
    53.443  1020.688     0.150
    53.477   553.688     0.150
    53.477    15.000     0.150
    53.716   555.586     0.150
    53.716  1012.688     0.150
    54.148  1020.484     0.150
    54.729  1007.188     0.150
    54.729  1007.188     0.150
    55.099   565.086     0.150
    58.773   592.688     0.150
    59.777    25.500     0.150
    62.195   612.688     0.150
    62.343   618.688     0.150
    63.951   626.688     0.150
    63.951    22.000     0.150
    64.011   625.391     0.150
    64.470   628.688     0.150
    64.470    24.000     0.150
    64.810    20.000     0.150
    64.810   630.688     0.150
    64.810    20.000     0.150
    64.810  1146.688     0.150
    66.058  1164.688     0.150
    66.058   633.289     0.150
    69.491   663.586     0.150
    69.964   661.289     0.150
    70.062   668.688     0.150
    73.563   696.688     0.150
    73.857   688.086     0.150
    74.018   690.688     0.150
    74.018  1312.688     0.150
    75.057   712.688     0.150
    75.582   697.789     0.150
    75.582   705.289     0.150
    75.582  1303.688     0.150
    75.664   697.688     0.150
    75.676   700.688     0.150
    75.907   698.688     0.150
    76.518   708.688     0.150
    77.296   707.484     0.150
    77.788   783.688     0.150
    77.788   710.688     0.150
    78.118   701.688     0.150
    78.344   713.188     0.150
    78.851    27.898     0.150
    79.063   711.688     0.150
    80.614    29.094     0.150
    81.246   726.688     0.150
    84.192   745.688     0.150
    85.447   761.391     0.150
    85.648   754.586     0.150
    87.107   748.289     0.150
   143.003  1158.688     0.150
   146.967  1184.484     0.150
   146.967  1220.891     0.150
     0.173    11.786     0.150
     0.922    33.286     0.150
     1.134    18.886     0.150
     1.134    32.986     0.150
     1.635    28.686     0.150
     3.189    58.686     0.150
    48.220   517.486     0.150
    48.243   517.086     0.150
    62.334   622.686     0.150
    65.879   637.686     0.150
    69.828   664.885     0.150
     0.270    14.984     0.150
     0.656    24.688     0.150
     1.026    15.887     0.150
     1.026    29.188     0.150
     1.162    33.586     0.150
     1.952    57.086     0.150
     8.356   125.484     0.150
    65.761   642.285     0.150
    69.932   670.887     0.150
    73.498   688.984     0.150
    80.680   728.586     0.150
     1.580    24.578     0.150
     1.580    43.477     0.150
     1.622    44.172     0.150
     3.412    64.875     0.150
     4.572    68.875     0.150
     6.902   171.375     0.150
     6.928   172.875     0.150
    18.489   247.875     0.150
    21.457   279.273     0.150
    21.457   508.672     0.150
    21.488    26.000     0.150
    38.887   437.477     0.150
    53.491   551.875     0.150
    53.491   551.875     0.150
    62.205   614.375     0.150
    64.022   625.672     0.150
    66.069   639.273     0.150
    69.505   652.773     0.150
    69.505   652.773     0.150
    77.307   706.875     0.150
    77.799   710.672     0.150
    81.573   731.875     0.150
    84.448   745.672     0.150
    86.574   756.672     0.150
     1.590    25.258     0.150
     1.590    44.160     0.150
     1.625    44.957     0.150
     3.153    47.059     0.150
     3.410    83.059     0.150
     4.555    68.559     0.150
     5.323   147.160     0.150
     6.604   103.059     0.150
     6.936    99.859     0.150
     7.020   175.660     0.150
    10.192   154.059     0.150
    10.192   276.559     0.150
    13.263   183.457     0.150
    13.617   187.559     0.150
    16.709   227.059     0.150
    20.441    23.000     0.150
    20.441   500.059     0.150
    20.441   530.059     0.150
    20.781    20.000     0.150
    20.781    30.000     0.150
    20.781   509.059     0.150
    21.023    23.898     0.150
    21.450   503.859     0.150
    21.450   278.359     0.150
    21.450    20.500     0.150
    21.450   313.059     0.150
    21.450   503.859     0.150
    24.850   566.059     0.150
    25.846    20.000     0.150
    27.972   384.258     0.150
    27.972   408.359     0.150
    27.972   625.059     0.150
    28.485   349.258     0.150
    28.485   631.059     0.150
    29.961   362.258     0.150
    30.363   362.059     0.150
    30.363   419.059     0.150
    30.363   441.059     0.150
    30.920   673.559     0.150
    32.770   385.258     0.150
    32.770   464.559     0.150
    36.471   766.059     0.150
    37.330   927.059     0.150
    38.890   438.059     0.150
    38.890   793.059     0.150
    39.092   437.059     0.150
    39.092   787.059     0.150
    40.148   449.059     0.150
    40.448   451.160     0.150
    41.551   451.059     0.150
    43.072   472.859     0.150
    43.072    15.598     0.150
    43.072   602.758     0.150
    43.319   856.660     0.150
    44.049   881.059     0.150
    44.550   490.059     0.150
    45.026   887.059     0.150
    45.059   486.059     0.150
    47.496   509.059     0.150
    48.875   503.059     0.150
    48.875   503.859     0.150
    49.237   959.059     0.150
    51.649   986.859     0.150
    52.278   545.059     0.150
    52.278   986.059     0.150
    53.051   558.059     0.150
    53.464   553.859     0.150
    53.464   998.859     0.150
    53.491   553.059     0.150
    53.491   615.059     0.150
    53.491  1002.059     0.150
    53.739   556.160     0.150
    53.739    20.297     0.150
    53.739  1017.059     0.150
    53.613   570.059     0.150
    54.174  1037.059     0.150
    54.752    18.000     0.150
    54.752  1010.359     0.150
    54.752   561.059     0.150
    54.752    18.000     0.150
    54.752  1010.359     0.150
    55.121   565.660     0.150
    55.789   570.457     0.150
    55.789  1053.059     0.150
    57.314   586.258     0.150
    58.582   588.957     0.150
    58.582  1067.059     0.150
    58.692   592.457     0.150
    58.752   586.059     0.150
    59.804    19.102     0.150
    59.804  1111.059     0.150
    62.448  1116.059     0.150
    62.448   617.059     0.150
    62.448  1116.059     0.150
    63.213  1131.059     0.150
    63.213   621.559     0.150
    63.213   848.059     0.150
    63.213  1131.059     0.150
    63.213  1149.059     0.150
    63.961   626.059     0.150
    63.961   771.059     0.150
    63.961  1137.059     0.150
    64.017   625.957     0.150
    64.477   629.059     0.150
    64.820   630.859     0.150
    66.064  1163.059     0.150
    66.064   639.160     0.150
    66.082   657.059     0.150
    67.224   649.059     0.150
    68.339   654.559     0.150
    68.519   656.059     0.150
    68.519  1212.059     0.150
    69.035   660.059     0.150
    69.194   660.258     0.150
    69.194    14.602     0.150
    69.194  1203.258     0.150
    69.507   663.957     0.150
    69.507  1209.059     0.150
    69.906   667.059     0.150
    69.906   667.059     0.150
    69.908   665.059     0.150
    69.908  1259.059     0.150
    69.793   677.359     0.150
    70.253   658.859     0.150
    70.502   655.059     0.150
    72.505   676.059     0.150
    73.663   691.059     0.150
    75.591   702.359     0.150
    75.591   697.859     0.150
    75.916   691.059     0.150
    77.303    19.801     0.150
    77.303   707.258     0.150
    77.303    19.602     0.150
    77.308   867.059     0.150
    77.796   710.859     0.150
    77.796    17.398     0.150
    77.899   710.059     0.150
    78.209   736.059     0.150
    78.351   713.059     0.150
    78.351    23.000     0.150
    78.351   713.059     0.150
    78.839   716.559     0.150
    78.859   716.758     0.150
    80.049   717.660     0.150
    80.622   725.059     0.150
    80.622    24.801     0.150
    80.622    29.102     0.150
    80.987   752.359     0.150
    81.255   758.957     0.150
    81.864   734.059     0.150
    84.740   746.059     0.150
    85.526   757.957     0.150
    87.092   765.059     0.150
    87.455   766.059     0.150
   120.636  1141.859     0.150
   124.839  1134.559     0.150
   142.561  1168.059     0.150
     1.629    25.266     0.150
     1.629    44.168     0.150
     1.653    44.465     0.150
    60.772   603.066     0.150
    84.218   743.867     0.150
    86.575   756.668     0.150
     1.549    23.328     0.150
     1.549    41.828     0.150
     1.593    42.922     0.150
     1.975    30.125     0.150
     3.401    63.625     0.150
    20.398   264.125     0.150
    69.958   660.625     0.150
     1.497    23.773     0.150
     1.497    41.473     0.150
     1.543    43.074     0.150
     1.949    56.473     0.150
     2.750    42.574     0.150
     2.750    75.074     0.150
     3.226    48.074     0.150
     3.393    86.074     0.150
     4.617    69.273     0.150
     4.617   123.074     0.150
     4.762    70.074     0.150
     4.762   121.375     0.150
     6.684   101.773     0.150
     6.785   170.074     0.150
     6.917    99.473     0.150
     6.917   174.074     0.150
     8.287   113.074     0.150
     8.287   113.074     0.150
     8.287   212.074     0.150
    11.076   284.074     0.150
    11.076   156.375     0.150
    11.076   284.074     0.150
    12.357   171.574     0.150
    18.485   453.375     0.150
    21.413    21.000     0.150
    21.413   507.875     0.150
    21.413   278.074     0.150
    21.413    21.000     0.150
    21.413    32.199     0.150
    21.413   320.074     0.150
    21.413   507.875     0.150
    21.413   563.574     0.150
    21.484   280.074     0.150
    21.484    21.500     0.150
    21.484   510.574     0.150
    24.090   306.074     0.150
    27.890   618.074     0.150
    27.890   342.074     0.150
    27.890    13.000     0.150
    27.890   618.074     0.150
    28.400   347.773     0.150
    28.400   633.074     0.150
    29.878   361.676     0.150
    30.339    26.000     0.150
    30.339   362.074     0.150
    30.339    26.000     0.150
    32.802   385.473     0.150
    32.802   695.074     0.150
    38.810   437.875     0.150
    38.810   790.074     0.150
    39.040   437.375     0.150
    40.065   448.574     0.150
    40.065   814.074     0.150
    40.370   450.074     0.150
    40.370   803.574     0.150
    42.989   856.273     0.150
    42.989   472.074     0.150
    42.989   856.273     0.150
    46.725   503.074     0.150
    51.560   980.074     0.150
    52.207   544.074     0.150
    52.207    21.000     0.150
    53.420   552.875     0.150
    54.080  1018.074     0.150
    54.080   557.773     0.150
    54.080  1018.074     0.150
    55.031  1026.574     0.150
    55.031  1026.574     0.150
    59.712   606.574     0.150
    59.712    12.301     0.150
    59.712    25.301     0.150
    60.753   603.574     0.150
    62.349   616.973     0.150
    62.966   620.375     0.150
    63.966   624.574     0.150
    63.966   624.574     0.150
    64.421   631.074     0.150
    64.756   630.875     0.150
    64.756    22.199     0.150
    66.012   638.676     0.150
    68.438   655.074     0.150
    68.975   658.074     0.150
    69.428   662.574     0.150
    69.470   662.074     0.150
    69.523   660.973     0.150
    73.191   685.176     0.150
    75.531   699.676     0.150
    75.612   697.074     0.150
    75.612    23.000     0.150
    76.564   695.676     0.150
    77.249   706.773     0.150
    77.253   706.875     0.150
    77.740   709.773     0.150
    78.150  -658.426     0.150
    78.297   713.074     0.150
    78.683   715.176     0.150
    78.803   717.074     0.150
    78.803   715.074     0.150
    79.227   718.574     0.150
    80.247   723.074     0.150
    80.469   725.473     0.150
    80.564   728.273     0.150
    80.564   726.273     0.150
    80.903   727.375     0.150
    81.641   731.375     0.150
    85.994   755.574     0.150
    90.710   768.176     0.150
   129.140  1176.574     0.150
     0.731    23.832     0.150
     1.589    25.033     0.150
     1.589    43.633     0.150
     1.623    45.133     0.150
     4.682   119.133     0.150
     6.605   177.232     0.150
     6.832   171.633     0.150
    47.649   520.033     0.150
    47.649   521.832     0.150
    58.691   594.332     0.150
    62.355   632.332     0.150
    62.355   674.633     0.150
    62.356   634.633     0.150
     1.550    23.996     0.150
     1.550    41.895     0.150
     1.588    42.594     0.150
     4.116   115.195     0.150
    21.431   320.797     0.150
    21.431   505.695     0.150
    44.071    14.000     0.150
    49.214    14.000     0.150
    53.700   552.094     0.150
    58.706   592.395     0.150
    59.765    12.000     0.150
    60.746   604.395     0.150
    62.479   617.195     0.150
    63.019   624.496     0.150
    63.598   639.195     0.150
    78.188   717.594     0.150
   120.648  1132.395     0.150
     0.248    13.785     0.150
     1.059    16.684     0.150
     1.059    30.984     0.150
     1.230    36.184     0.150
     1.978    58.383     0.150
     7.537   116.484     0.150
     8.303   124.984     0.150
     0.088    11.078     0.150
     0.521    19.875     0.150
     1.217    18.977     0.150
     1.217    33.977     0.150
     1.346    38.477     0.150
     6.581    94.477     0.150
    44.317   487.875     0.150
    55.393   613.977     0.150
    55.393  1258.777     0.150
    62.663   623.977     0.150
    62.663   673.977     0.150
    69.844   664.375     0.150
     1.541    24.422     0.150
     1.541    43.219     0.150
     1.573    43.820     0.150
     3.178    47.922     0.150
     4.572    67.922     0.150
     4.749    69.219     0.150
     4.749   117.422     0.150
     4.895   125.422     0.150
     6.907    99.422     0.150
     6.825   165.422     0.150
     7.917   194.422     0.150
     8.331   117.922     0.150
     8.660   124.023     0.150
    10.433   147.523     0.150
    11.067   155.422     0.150
    12.313   168.422     0.150
    12.313   169.125     0.150
    14.543   199.422     0.150
    14.543   348.422     0.150
    15.015   219.422     0.150
    15.015   219.422     0.150
    18.461   445.820     0.150
    18.461   445.820     0.150
    20.394   497.422     0.150
    21.413    23.297     0.150
    21.413   507.422     0.150
    21.413   278.125     0.150
    21.413    23.297     0.150
    21.413   310.422     0.150
    21.413   321.422     0.150
    21.413   507.422     0.150
    21.413   553.422     0.150
    23.883    37.000     0.150
    24.802   565.422     0.150
    27.920    27.500     0.150
    27.920   343.422     0.150
    27.920    27.500     0.150
    28.433   348.422     0.150
    28.433   633.422     0.150
    30.331    27.000     0.150
    30.331   361.422     0.150
    30.331    27.000     0.150
    32.768   385.023     0.150
    32.768    19.602     0.150
    32.768   463.422     0.150
    32.768   694.023     0.150
    38.838   437.922     0.150
    38.838   791.422     0.150
    39.048    17.203     0.150
    39.048   436.219     0.150
    39.048    17.203     0.150
    39.048   562.422     0.150
    40.396   451.023     0.150
    40.396   803.422     0.150
    51.597   980.422     0.150
    51.597   539.422     0.150
    51.597   980.422     0.150
    52.228   544.422     0.150
    52.228   659.422     0.150
    52.228   985.422     0.150
    52.228  1130.422     0.150
    53.687   555.422     0.150
    53.687  1025.422     0.150
    53.801   555.523     0.150
    54.700  1028.023     0.150
    55.069   564.719     0.150
    55.069  1030.422     0.150
    55.883   573.023     0.150
    58.540   587.820     0.150
    59.760    19.297     0.150
    60.742   606.320     0.150
    60.728   643.023     0.150
    62.051   617.422     0.150
    62.556   616.625     0.150
    62.556    20.594     0.150
    63.974   625.125     0.150
    64.773    18.000     0.150
    64.773  1142.422     0.150
    64.773   630.422     0.150
    64.773    18.000     0.150
    64.773  1142.422     0.150
    66.021   644.922     0.150
    66.021   638.523     0.150
    66.099   647.422     0.150
    66.099   647.719     0.150
    66.981     8.203     0.150
    67.172   647.422     0.150
    68.468   655.422     0.150
    69.456   662.422     0.150
    69.851   670.023     0.150
    69.851     5.594     0.150
    75.544    18.000     0.150
    75.544    18.195     0.150
    77.259   856.422     0.150
    77.264    20.898     0.150
    77.264  2356.422     0.150
    77.346   718.922     0.150
    77.536   709.523     0.150
    77.751   713.422     0.150
    77.751   710.219     0.150
    77.751   713.625     0.150
    78.163   712.820     0.150
    78.163    23.305     0.150
    78.307   712.422     0.150
    78.307   735.422     0.150
    78.307   712.422     0.150
    78.484   714.125     0.150
    78.814    24.500     0.150
    78.819    19.602     0.150
    78.819   715.820     0.150
    78.819    19.602     0.150
    80.160    19.703     0.150
    80.454   722.625     0.150
    82.893   732.922     0.150
    84.815    13.695     0.150
    85.047   759.422     0.150
    89.302   773.719     0.150
     0.512    10.049     0.150
     0.512    18.150     0.150
     1.254    35.449     0.150
     1.405    21.650     0.150
     1.405    38.250     0.150
     5.905   154.650     0.150
     7.274   190.750     0.150
    69.466   662.449     0.150
     0.499    22.057     0.150
     1.203    18.657     0.150
     1.203    33.257     0.150
     1.307    36.157     0.150
     5.400   142.757     0.150
     6.617   198.957     0.150
     9.817   143.457     0.150
    48.664   520.157     0.150
    58.893   597.457     0.150
    62.048   614.057     0.150
    69.808   658.357     0.150
    85.137   749.657     0.150
    86.385   756.157     0.150
    86.811   758.257     0.150
    86.892   758.457     0.150
   143.581  1166.957     0.150
     1.559    24.578     0.150
     1.559    43.375     0.150
     1.595    44.172     0.150
     2.233    57.672     0.150
     2.704    69.875     0.150
     4.571    68.875     0.150
     4.766    69.977     0.150
     6.821   171.375     0.150
     7.378   190.773     0.150
     7.524   191.578     0.150
     7.667   111.172     0.150
     8.350   119.375     0.150
     8.350   218.375     0.150
    13.062   194.375     0.150
    13.062   316.375     0.150
    14.560   367.375     0.150
    15.018   222.375     0.150
    15.018   222.375     0.150
    18.473   451.375     0.150
    20.410   461.375     0.150
    21.433    23.297     0.150
    21.433   507.375     0.150
    21.433   279.078     0.150
    21.433    23.297     0.150
    21.433   507.375     0.150
    21.433   548.375     0.150
    22.272   289.375     0.150
    22.272    22.000     0.150
    24.131   307.078     0.150
    24.819   564.875     0.150
    28.455   636.375     0.150
    28.455   348.375     0.150
    28.455   636.375     0.150
    32.776   385.578     0.150
    32.776    14.094     0.150
    32.776    19.398     0.150
    32.776   471.375     0.150
    36.449   425.375     0.150
    38.861   794.375     0.150
    38.861   438.078     0.150
    38.861   794.375     0.150
    39.070   435.375     0.150
    39.940   815.375     0.150
    44.023   907.375     0.150
    44.997   889.375     0.150
    47.465   507.375     0.150
    47.465   937.375     0.150
    47.788   511.375     0.150
    49.206   522.375     0.150
    49.206    20.703     0.150
    49.209   526.375     0.150
    52.251    17.297     0.150
    52.251   544.078     0.150
    52.251    17.297     0.150
    52.251   667.375     0.150
    53.433   544.375     0.150
    53.433   544.875     0.150
    53.464   558.375     0.150
    53.464   558.375     0.150
    53.464    21.000     0.150
    53.708  1001.375     0.150
    53.708  1001.375     0.150
    54.143  1567.375     0.150
    54.720  1033.273     0.150
    55.090   564.672     0.150
    62.482    18.703     0.150
    63.088   625.172     0.150
    63.936    24.000     0.150
    63.936   624.375     0.150
    63.936    24.000     0.150
    63.995   625.578     0.150
    64.795   630.773     0.150
    66.042   638.672     0.150
    66.086   655.375     0.150
    66.086   655.773     0.150
    66.977   651.375     0.150
    69.011   658.375     0.150
    69.011  1256.375     0.150
    69.165   659.375     0.150
    69.478   662.875     0.150
    69.846   660.172     0.150
    70.971   674.172     0.150
    76.311   699.375     0.150
    76.311   699.875     0.150
    77.281   706.977     0.150
    77.281    20.398     0.150
    77.773   710.375     0.150
    80.598   728.172     0.150
    80.598   726.578     0.150
    83.365   730.375     0.150
    87.052   758.477     0.150
    99.736   808.578     0.150
     1.333    21.195     0.150
     1.333    37.195     0.150
     1.419    23.391     0.150
     1.419    40.891     0.150
     2.017    58.797     0.150
     3.223    90.391     0.150
     3.350    92.094     0.150
     4.354   111.094     0.150
     4.780    71.094     0.150
     4.780   121.094     0.150
     4.759    72.297     0.150
     6.070   159.594     0.150
     6.612   176.094     0.150
     6.643   169.297     0.150
     7.684   118.094     0.150
     7.793   195.797     0.150
     7.881   117.695     0.150
     8.183   204.797     0.150
     8.464   120.594     0.150
     9.426   248.094     0.150
     9.721   139.797     0.150
     9.946   151.094     0.150
     9.946   156.094     0.150
     9.946   256.094     0.150
     9.946   271.094     0.150
    10.248   146.695     0.150
    12.229   173.992     0.150
    12.229   312.195     0.150
    12.449   317.797     0.150
    12.489   174.297     0.150
    12.838   189.094     0.150
    15.182   210.094     0.150
    18.545   251.094     0.150
    18.545   457.094     0.150
    20.177   483.094     0.150
    20.535    11.797     0.150
    20.535   496.094     0.150
    21.384   281.391     0.150
    21.384   315.094     0.150
    21.384   326.094     0.150
    21.384   513.094     0.150
    21.565    20.898     0.150
    21.565   511.094     0.150
    22.097   524.094     0.150
    22.097   288.094     0.150
    22.097   524.094     0.150
    23.393   547.094     0.150
    23.664    10.297     0.150
    23.664    19.297     0.150
    23.664    29.297     0.150
    23.664   549.094     0.150
    23.664   563.594     0.150
    23.999   309.391     0.150
    24.590    17.000     0.150
    24.590   574.094     0.150
    25.590   321.094     0.150
    27.762    13.000     0.150
    27.762   343.094     0.150
    27.762    13.000     0.150
    27.762   622.094     0.150
    28.265   349.094     0.150
    29.747   362.297     0.150
    30.336    27.000     0.150
    30.336   364.094     0.150
    30.336    27.000     0.150
    30.336   438.094     0.150
    30.336   660.094     0.150
    30.375   374.094     0.150
    30.656   368.594     0.150
    30.656   665.094     0.150
    31.060   377.594     0.150
    31.060   677.094     0.150
    31.081   686.094     0.150
    31.993   672.094     0.150
    32.437   385.594     0.150
    32.437   705.094     0.150
    32.897    26.297     0.150
    32.897   387.594     0.150
    32.897    17.500     0.150
    32.897    26.297     0.150
    32.897   462.094     0.150
    32.897   477.094     0.150
    32.897   548.094     0.150
    33.083   701.094     0.150
    37.070   425.594     0.150
    37.070    19.500     0.150
    37.070   517.094     0.150
    38.686   438.594     0.150
    38.686   792.094     0.150
    38.686  1045.094     0.150
    38.982   786.094     0.150
    38.982   437.594     0.150
    38.982    15.500     0.150
    38.982   537.094     0.150
    38.982   560.094     0.150
    38.982   786.094     0.150
    39.935   450.094     0.150
    39.935   804.094     0.150
    40.252   452.391     0.150
    40.252    17.602     0.150
    40.252   804.992     0.150
    40.252  1028.891     0.150
    41.286   836.094     0.150
    42.639     6.000     0.150
    42.639   552.094     0.150
    42.639   568.094     0.150
    42.639   611.094     0.150
    42.639   807.094     0.150
    42.859   473.391     0.150
    42.859   608.094     0.150
    42.859   852.094     0.150
    42.859  1089.094     0.150
    43.793   865.094     0.150
    46.577    27.000     0.150
    46.577   504.094     0.150
    46.577    27.000     0.150
    46.577   909.094     0.150
    47.084   921.094     0.150
    47.088   921.094     0.150
    47.261   509.594     0.150
    47.261   927.094     0.150
    47.552   515.391     0.150
    47.552   926.094     0.150
    47.544   492.594     0.150
    47.863   920.094     0.150
    47.863   920.094     0.150
    47.863   926.094     0.150
    48.637   519.094     0.150
    48.637   635.094     0.150
    49.004    30.805     0.150
    49.004   522.492     0.150
    49.004    30.805     0.150
    49.004   944.094     0.150
    51.413   540.695     0.150
    51.413   977.297     0.150
    51.413  1000.594     0.150
    51.497   549.891     0.150
    52.105   546.297     0.150
    52.105   984.094     0.150
    52.822   632.992     0.150
    53.232    28.000     0.150
    53.232   555.094     0.150
    53.232    28.000     0.150
    53.232  1001.094     0.150
    53.318    25.000     0.150
    53.318   554.594     0.150
    53.318    25.000     0.150
    53.318  1000.094     0.150
    53.496    21.000     0.150
    53.496   556.094     0.150
    53.496    21.000     0.150
    53.496  1005.094     0.150
    53.496  1037.094     0.150
    53.614   556.492     0.150
    53.614   745.094     0.150
    53.614  1000.094     0.150
    53.695   564.094     0.150
    54.511  1018.594     0.150
    54.883    19.000     0.150
    54.883   566.094     0.150
    54.883    19.000     0.150
    54.883  1022.094     0.150
    55.555  1027.094     0.150
    55.555   570.797     0.150
    55.555  1027.094     0.150
    58.482  1057.094     0.150
    58.482   590.492     0.150
    58.482    15.805     0.150
    58.482  1057.094     0.150
    59.539   680.891     0.150
    59.539   747.094     0.150
    59.539   777.594     0.150
    59.539   811.594     0.150
    59.539   903.094     0.150
    62.219   618.094     0.150
    62.219  1121.094     0.150
    62.342   621.594     0.150
    62.380   618.094     0.150
    62.380  1120.594     0.150
    62.989    19.000     0.150
    62.989  1122.094     0.150
    62.989   623.094     0.150
    62.989    19.000     0.150
    62.989   762.094     0.150
    62.989  1122.094     0.150
    62.989  1138.094     0.150
    63.811   653.094     0.150
    63.811   627.094     0.150
    63.811    16.000     0.150
    63.811   653.094     0.150
    63.811  1138.094     0.150
    63.811  1171.094     0.150
    63.908   627.594     0.150
    64.352  1148.094     0.150
    64.352   631.094     0.150
    64.352    18.000     0.150
    64.352  1148.094     0.150
    64.670   659.094     0.150
    64.670   632.891     0.150
    64.670    16.203     0.150
    64.670   659.094     0.150
    64.670  1148.094     0.150
    66.203   631.094     0.150
    66.203    31.000     0.150
    66.203   631.391     0.150
    66.203    30.703     0.150
    66.203  1183.594     0.150
    66.317   659.094     0.150
    66.317   659.094     0.150
    66.317  1181.094     0.150
    66.888  1177.094     0.150
    67.024  1180.094     0.150
    67.024   649.094     0.150
    67.024  1180.094     0.150
    68.146   655.094     0.150
    68.146  1193.094     0.150
    68.236   659.094     0.150
    68.236   655.297     0.150
    68.236    17.797     0.150
    68.312   657.094     0.150
    68.312  1193.094     0.150
    68.573  1215.891     0.150
    68.573  1229.492     0.150
    68.573  1241.891     0.150
    68.897  1197.094     0.150
    68.897  1197.094     0.150
    68.985   661.094     0.150
    68.985  1201.094     0.150
    69.307   664.094     0.150
    69.307  1207.094     0.150
    69.703   666.094     0.150
    69.703  1213.094     0.150
    69.641   652.094     0.150
    70.312   669.094     0.150
    70.312  1218.094     0.150
    73.708   688.094     0.150
    73.708  1256.094     0.150
    74.113  1257.094     0.150
    75.454   704.297     0.150
    75.454   699.695     0.150
    75.454    12.195     0.150
    75.527   764.094     0.150
    75.529    26.500     0.150
    75.529    26.203     0.150
    75.529  1297.094     0.150
    77.185   708.891     0.150
    77.185   719.797     0.150
    77.185  1293.594     0.150
    77.187   709.391     0.150
    77.187    16.703     0.150
    77.647    10.000     0.150
    77.671   712.797     0.150
    77.671    10.297     0.150
    77.869   713.891     0.150
    77.869    11.602     0.150
    78.074   753.695     0.150
    78.074   714.797     0.150
    78.074    11.398     0.150
    78.074   898.891     0.150
    78.146   714.094     0.150
    78.234  1325.094     0.150
    78.234   715.094     0.150
    78.234    11.500     0.150
    78.234    17.000     0.150
    78.234   715.094     0.150
    78.234    11.500     0.150
    78.342  1464.492     0.150
    78.342  1470.094     0.150
    78.342  1480.492     0.150
    78.734   718.797     0.150
    78.759   717.992     0.150
    78.759    12.102     0.150
    79.501    17.297     0.150
    79.512   722.094     0.150
    80.098   725.094     0.150
    80.129   722.094     0.150
    80.492    12.703     0.150
    80.492   727.094     0.150
    80.492   907.094     0.150
    80.700   720.094     0.150
    80.882   729.195     0.150
    81.206   732.094     0.150
    81.325   730.492     0.150
    81.890   732.094     0.150
    82.124   743.094     0.150
    83.697   744.391     0.150
    84.311   748.094     0.150
    84.602   749.594     0.150
    85.166   750.094     0.150
    85.318   751.297     0.150
    85.410   752.094     0.150
    85.421   752.492     0.150
    87.410   762.094     0.150
    95.177   805.891     0.150
    95.522   812.297     0.150
    95.529   812.094     0.150
    95.670   812.594     0.150
    96.015   794.797     0.150
   121.034  1128.391     0.150
   123.243  1126.094     0.150
   149.834  1188.094     0.150
     0.083    11.039     0.150
     1.378    21.039     0.150
     1.378    37.438     0.150
     1.464    37.836     0.150
     5.427   142.633     0.150
     6.306    90.438     0.150
     6.677   184.836     0.150
     6.809   100.336     0.150
    51.302   537.836     0.150
    60.710   613.836     0.150
    62.433   620.836     0.150
    63.944   626.938     0.150
    65.987   640.133     0.150
    69.900   664.734     0.150
    71.535   671.836     0.150
     1.500    23.383     0.150
     1.500    41.680     0.150
     1.548    43.180     0.150
     4.621    69.082     0.150
    13.003   181.082     0.150
    13.003   181.082     0.150
    18.493   443.281     0.150
    18.493   248.281     0.150
    18.493   443.281     0.150
    21.421   278.582     0.150
    21.421    18.699     0.150
    21.421   311.281     0.150
    21.421   508.281     0.150
    21.421   540.281     0.150
    22.227   281.281     0.150
    24.097   306.281     0.150
    27.895   722.281     0.150
    28.405   347.980     0.150
    28.405   631.281     0.150
    32.808   385.281     0.150
    32.808    13.000     0.150
    32.808   458.180     0.150
    39.048   439.281     0.150
    39.048    27.000     0.150
    39.048   439.281     0.150
    39.048    27.000     0.150
    42.995   471.980     0.150
    44.935   490.781     0.150
    45.118   492.082     0.150
    47.412   508.281     0.150
    48.224   513.480     0.150
    48.224   931.281     0.150
    49.154   631.281     0.150
    52.213   546.281     0.150
    52.213   546.281     0.150
    52.213    20.000     0.150
    53.381   553.281     0.150
    53.426   551.281     0.150
    53.426    18.000     0.150
    53.426   551.781     0.150
    53.426    17.500     0.150
    58.739   590.781     0.150
    62.341   630.281     0.150
    62.522   614.281     0.150
    63.904   625.281     0.150
    63.904    22.000     0.150
    64.332   627.480     0.150
    64.763   631.281     0.150
    64.763    23.000     0.150
    66.019   637.980     0.150
    68.444   653.281     0.150
    69.923   663.180     0.150
    75.538   697.680     0.150
    76.388   701.281     0.150
    77.257   706.281     0.150
    77.257    17.000     0.150
    77.257   706.281     0.150
    77.257    17.000     0.150
    77.261   705.980     0.150
    77.261   705.980     0.150
    78.304   712.980     0.150
    81.086   727.781     0.150
     0.602    21.898     0.150
     1.851    28.602     0.150
     1.885    49.500     0.150
     1.994    31.699     0.150
     1.994    54.699     0.150
     6.639    94.199     0.150
    21.309   281.699     0.150
    21.309    16.801     0.150
    21.309    25.801     0.150
    21.309   557.500     0.150
    58.224   585.898     0.150
     0.088    11.280     0.150
     0.351    14.780     0.150
     1.533    43.380     0.150
     1.561    25.181     0.150
     1.561    44.181     0.150
     2.369    67.980     0.150
     6.880    96.080     0.150
    48.701   519.780     0.150
    48.905   521.980     0.150
    58.559   593.280     0.150
     1.521    24.492     0.150
     1.521    42.695     0.150
     1.560    44.094     0.150
     2.205    57.195     0.150
     3.331    91.695     0.150
     4.594    68.195     0.150
     4.757    70.297     0.150
     6.722   169.594     0.150
     6.805   179.195     0.150
     8.311   119.195     0.150
     8.311   216.195     0.150
     9.417   140.094     0.150
    12.404   175.492     0.150
    13.023   181.992     0.150
    13.023   196.195     0.150
    18.474   248.695     0.150
    21.415    22.000     0.150
    21.415   278.195     0.150
    21.415    22.000     0.150
    21.415   308.195     0.150
    21.415   319.195     0.150
    21.415   508.195     0.150
    23.861   549.195     0.150
    24.776   322.094     0.150
    28.419   636.195     0.150
    28.419   348.797     0.150
    28.419   636.195     0.150
    29.896   362.094     0.150
    30.337   362.195     0.150
    30.337    22.000     0.150
    30.337   419.195     0.150
    32.786    28.000     0.150
    32.786   385.195     0.150
    32.786    28.000     0.150
    32.786   694.195     0.150
    32.786   724.195     0.150
    34.742   408.695     0.150
    37.268     9.500     0.150
    38.665   444.195     0.150
    39.047   437.398     0.150
    43.007   857.195     0.150
    43.007   472.492     0.150
    43.007    21.703     0.150
    43.007   857.195     0.150
    48.116   514.094     0.150
    48.234   934.195     0.150
    49.169   522.195     0.150
    49.169    16.000     0.150
    52.220   542.094     0.150
    52.220    23.102     0.150
    52.220   542.094     0.150
    52.220    23.102     0.150
    53.670   555.695     0.150
    53.670  1011.898     0.150
    58.715   590.297     0.150
    62.360   626.297     0.150
    63.908   626.195     0.150
    63.908    22.000     0.150
    63.972   627.695     0.150
    64.331   627.695     0.150
    64.429   628.195     0.150
    64.767   630.398     0.150
    64.767    19.797     0.150
    66.018   639.094     0.150
    68.536   656.594     0.150
    68.536   803.594     0.150
    68.816   659.195     0.150
    68.984   658.195     0.150
    69.130   659.398     0.150
    75.540   697.398     0.150
    77.256   707.094     0.150
    77.256   707.094     0.150
    77.256    21.805     0.150
    77.261   872.195     0.150
    77.261   707.297     0.150
    77.261    21.898     0.150
    77.747   769.195     0.150
    77.747   710.492     0.150
    77.747    21.906     0.150
    78.207   711.195     0.150
    78.304   713.094     0.150
    78.304   713.094     0.150
    78.811   716.398     0.150
    78.811    21.797     0.150
    78.995   715.992     0.150
    79.548   721.594     0.150
    79.655   720.398     0.150
    80.572    22.297     0.150
    80.572   725.797     0.150
    80.572    22.297     0.150
    81.360   729.234     0.150
    82.119   732.758     0.150
    82.126   733.492     0.150
    84.128   731.195     0.150
    84.250   752.195     0.150
    88.869   769.195     0.150
   111.649  1074.492     0.150
   123.356  1130.898     0.150
   123.728  1131.398     0.150
     0.522    21.070     0.150
     0.633    20.770     0.150
     0.672    23.270     0.150
     0.933    27.871     0.150
     1.135    18.070     0.150
     1.135    32.371     0.150
     3.741    57.172     0.150
    58.459   593.570     0.150
    69.236   660.973     0.150
    69.248   661.172     0.150
     0.289    16.781     0.150
     0.727    23.875     0.150
     1.516    23.977     0.150
     1.516    42.375     0.150
     1.558    43.180     0.150
     6.797   135.578     0.150
    48.982   519.461     0.150
    63.974   627.680     0.150
    76.436   706.578     0.150
    81.721   732.078     0.150
    84.390   746.281     0.150
    84.399   746.375     0.150
     0.129    13.229     0.150
     1.317    20.729     0.150
     1.317    36.428     0.150
     1.344    37.828     0.150
     1.325    41.229     0.150
     3.281    93.027     0.150
     3.351    93.428     0.150
     4.473   122.729     0.150
     5.541    79.129     0.150
     5.595    80.428     0.150
     6.914   103.527     0.150
    62.428   614.729     0.150
    63.794   627.527     0.150
     1.013    29.566     0.150
     1.187    18.566     0.150
     1.187    33.469     0.150
     3.853    59.566     0.150
    48.261   518.367     0.150
    48.288   518.969     0.150
     0.253    13.532     0.150
     1.167    35.432     0.150
     1.150    18.432     0.150
     1.150    33.732     0.150
     2.495    69.632     0.150
     3.243    90.832     0.150
     3.378    52.632     0.150
     3.388    54.132     0.150
     4.476    66.332     0.150
     5.459    80.832     0.150
    47.756   515.132     0.150
    58.750   598.532     0.150
    90.376   792.732     0.150
    90.376   878.732     0.150
     1.590    25.471     0.150
     1.590    44.171     0.150
     1.620    44.771     0.150
     3.377    92.570     0.150
     4.545    68.271     0.150
     4.763    69.971     0.150
     4.763   119.271     0.150
    10.190   144.971     0.150
    10.644   276.271     0.150
    11.359   160.771     0.150
    12.290   170.771     0.150
    12.290   311.570     0.150
    12.259   173.271     0.150
    13.092   199.771     0.150
    14.592   218.771     0.150
    18.462   248.771     0.150
    18.462   454.771     0.150
    21.439    21.100     0.150
    21.439   312.771     0.150
    21.439   507.771     0.150
    21.439   568.771     0.150
    21.439   278.671     0.150
    21.439    21.100     0.150
    21.439   312.771     0.150
    21.439   507.771     0.150
    21.439   546.771     0.150
    21.439   568.771     0.150
    21.439   957.771     0.150
    21.462   280.271     0.150
    21.462   512.771     0.150
    22.296   288.771     0.150
    22.296   288.771     0.150
    22.296   532.771     0.150
    24.148   306.870     0.150
    24.851   565.271     0.150
    27.966   342.771     0.150
    28.022     9.700     0.150
    28.022    17.200     0.150
    28.481   637.771     0.150
    28.481   349.771     0.150
    28.481   541.771     0.150
    28.481   637.771     0.150
    29.956   362.671     0.150
    30.351   364.771     0.150
    30.351   364.771     0.150
    30.351    21.000     0.150
    30.351   428.771     0.150
    30.351   445.771     0.150
    30.922    10.000     0.150
    32.758   385.171     0.150
    32.758   454.771     0.150
    32.758   694.271     0.150
    33.715    17.000     0.150
    33.715   734.771     0.150
    38.884   438.771     0.150
    38.884   795.771     0.150
    39.081    25.000     0.150
    39.081   436.771     0.150
    39.081    16.000     0.150
    39.081    25.000     0.150
    39.081   569.771     0.150
    40.450   448.980     0.150
    44.043   482.070     0.150
    44.043    13.500     0.150
    45.258   489.620     0.150
    47.039   504.030     0.150
    49.234   521.971     0.150
    49.234    12.800     0.150
    52.270   544.771     0.150
    52.270    22.100     0.150
    53.483   552.771     0.150
    53.483    13.000     0.150
    53.483    22.000     0.150
    57.262   581.070     0.150
    58.680   590.570     0.150
    58.594   584.471     0.150
    62.036   630.771     0.150
    62.444   614.771     0.150
    63.806   621.440     0.150
    63.952   626.771     0.150
    63.952    22.000     0.150
    64.007   628.070     0.150
    64.366   628.070     0.150
    64.467   629.771     0.150
    64.811   713.771     0.150
    65.139   634.171     0.150
    65.519   636.040     0.150
    66.054   639.171     0.150
    66.095   642.171     0.150
    66.095    15.699     0.150
    68.592   656.971     0.150
    68.592    16.700     0.150
    68.592  1194.671     0.150
    68.533   673.870     0.150
    68.786   660.471     0.150
    69.189   659.771     0.150
    69.837   665.971     0.150
    69.952   663.471     0.150
    70.589    11.380     0.150
    73.110   683.301     0.150
    73.736   688.221     0.150
    74.460   694.771     0.150
    75.665   697.771     0.150
    75.665    23.000     0.150
    76.482    13.040     0.150
    77.246   702.771     0.150
    77.246   703.271     0.150
    77.293   707.171     0.150
    77.293   726.771     0.150
    77.293   707.171     0.150
    77.293    19.600     0.150
    77.298   707.771     0.150
    77.298    22.600     0.150
    77.509   710.171     0.150
    77.509    15.100     0.150
    77.786   710.870     0.150
    77.786   720.370     0.150
    77.786    20.400     0.150
    78.340    19.300     0.150
    78.340   713.570     0.150
    78.340    19.300     0.150
    78.340   713.570     0.150
    78.340    19.300     0.150
    78.706   728.771     0.150
    78.710   715.771     0.150
    78.849   752.771     0.150
    78.849   716.771     0.150
    78.849    22.500     0.150
    79.034   753.570     0.150
    80.612    19.301     0.150
    80.612    22.900     0.150
    80.612   726.870     0.150
    80.612    19.301     0.150
    80.612    22.900     0.150
    81.039   727.771     0.150
    81.125    16.400     0.150
    81.125    19.601     0.150
    81.125   729.070     0.150
    81.125    16.400     0.150
    81.125    19.601     0.150
    81.261   729.671     0.150
    81.324   730.070     0.150
    88.849   771.271     0.150
   143.253  1167.070     0.150
     0.677    10.414     0.150
     0.677    20.312     0.150
     0.727    21.914     0.150
     0.793    11.914     0.150
     0.793    23.113     0.150
     0.864    29.414     0.150
     0.931    15.715     0.150
     2.086    63.113     0.150
     2.475    73.312     0.150
     3.128    46.516     0.150
     4.288   118.113     0.150
     5.655   151.812     0.150
     5.771    86.812     0.150
     5.924    88.016     0.150
     6.528    99.016     0.150
     7.510   114.812     0.150
     7.966   117.016     0.150
    10.048   150.516     0.150
    49.174   524.914     0.150
    58.711   592.914     0.150
    68.748   665.914     0.150
     0.615    22.742     0.150
     1.493    41.340     0.150
     1.497    23.941     0.150
     1.497    42.941     0.150
     1.839    28.539     0.150
     4.528    67.641     0.150
     4.528   120.641     0.150
     4.647    67.840     0.150
     4.647   119.641     0.150
     6.888   174.641     0.150
    10.079   144.742     0.150
    10.079    17.398     0.150
    10.227   136.340     0.150
    12.261   168.742     0.150
    12.681   177.742     0.150
    12.989   179.840     0.150
    12.989   195.641     0.150
    12.989   296.641     0.150
    14.502     5.898     0.150
    14.957   218.641     0.150
    14.957   218.641     0.150
    14.957   218.641     0.150
    18.370   444.641     0.150
    18.370   246.641     0.150
    18.370   444.641     0.150
    20.356   484.641     0.150
    20.763   278.641     0.150
    20.763   506.641     0.150
    21.308   295.641     0.150
    21.308   315.641     0.150
    21.308   503.641     0.150
    21.308   516.641     0.150
    21.308   275.941     0.150
    21.308    19.699     0.150
    21.308   315.641     0.150
    21.308   503.641     0.150
    21.308   516.641     0.150
    21.308   540.641     0.150
    21.308   955.641     0.150
    23.560     2.000     0.150
    23.560   555.641     0.150
    23.852     0.699     0.150
    23.852   566.641     0.150
    24.757   550.641     0.150
    27.837    17.301     0.150
    27.837   340.641     0.150
    27.837    17.301     0.150
    27.837    23.000     0.150
    27.953     5.301     0.150
    28.355   346.641     0.150
    28.355   628.641     0.150
    30.838   445.641     0.150
    30.838   678.641     0.150
    32.597   452.641     0.150
    32.597   691.641     0.150
    33.284   583.539     0.150
    33.669     8.000     0.150
    34.828   409.641     0.150
    37.285    35.500     0.150
    38.753   556.641     0.150
    38.753   436.641     0.150
    38.753   556.641     0.150
    38.753   787.641     0.150
    38.753   443.641     0.150
    38.945   435.539     0.150
    38.945   567.641     0.150
    39.853     5.500     0.150
    39.853     8.000     0.150
    39.853   564.141     0.150
    39.853   813.641     0.150
    39.853   826.641     0.150
    40.596   444.469     0.150
    41.530   457.469     0.150
    43.997   480.242     0.150
    43.997    15.000     0.150
    43.997    21.000     0.150
    45.223    26.020     0.150
    49.595   618.641     0.150
    49.595   641.641     0.150
    49.595   854.641     0.150
    49.595   886.641     0.150
    49.595  1050.641     0.150
    49.595  1132.641     0.150
    52.134   986.641     0.150
    52.134  1188.641     0.150
    52.134   542.141     0.150
    52.134   986.641     0.150
    52.134  1188.641     0.150
    53.347   562.641     0.150
    53.347   550.539     0.150
    53.347    12.102     0.150
    53.347   617.641     0.150
    53.347   997.641     0.150
    57.176   580.141     0.150
    58.628   588.742     0.150
    60.640   602.840     0.150
    62.153   605.641     0.150
    62.153    27.000     0.150
    62.321   614.441     0.150
    62.464   617.141     0.150
    64.674   628.641     0.150
    65.500    25.609     0.150
    66.192   642.242     0.150
    68.458    30.398     0.150
    68.458   654.941     0.150
    68.458    30.398     0.150
    69.520   668.340     0.150
    69.771   663.641     0.150
    69.817   660.840     0.150
    71.157   681.141     0.150
    73.726   688.391     0.150
    74.414   692.641     0.150
    75.376   694.641     0.150
    75.527   696.141     0.150
    75.527   706.641     0.150
    75.527    22.000     0.150
    76.192   698.641     0.150
    77.157    27.801     0.150
    77.157   704.641     0.150
    77.157    27.801     0.150
    77.157   704.641     0.150
    77.162    27.102     0.150
    77.162   705.641     0.150
    77.492   709.141     0.150
    77.492    16.301     0.150
    77.624    27.000     0.150
    77.649   708.340     0.150
    77.649    23.402     0.150
    78.062    28.098     0.150
    78.204   711.340     0.150
    78.204   738.941     0.150
    78.204   711.340     0.150
    78.579   713.242     0.150
    78.712   742.340     0.150
    78.712   714.641     0.150
    78.712    15.000     0.150
    78.712    23.500     0.150
    78.716   714.641     0.150
    78.716   714.641     0.150
    79.134    25.703     0.150
    80.056   721.641     0.150
    80.245   724.840     0.150
    80.245    15.902     0.150
    80.475   724.641     0.150
    80.988    13.500     0.150
    80.988   726.840     0.150
    80.988    13.500     0.150
    80.988    27.500     0.150
    81.108    18.699     0.150
    81.124   727.441     0.150
    83.802   741.441     0.150
    83.912   740.641     0.150
    85.385   749.441     0.150
    85.914   751.969     0.150
   123.264  1129.211     0.150
   123.637  1129.949     0.150
   133.835  1131.141     0.150
   135.427  1164.141     0.150
     0.731    13.037     0.150
     0.731    23.037     0.150
     0.852    26.037     0.150
     2.228    37.137     0.150
     5.375    79.438     0.150
    58.962   593.836     0.150
    62.430   632.836     0.150
     1.081    17.398     0.150
     1.081    31.199     0.150
     1.198    34.699     0.150
     6.583   218.699     0.150
     6.749   180.301     0.150
     9.669   139.699     0.150
     1.131    18.594     0.150
     1.131    32.594     0.150
     1.218    34.789     0.150
     0.156     6.441     0.150
     1.300    19.840     0.150
     1.300    36.238     0.150
     3.305    94.641     0.150
     3.616    54.141     0.150
     3.616   104.141     0.150
     6.450   174.141     0.150
     6.808   182.840     0.150
     7.852   205.539     0.150
     8.846   130.141     0.150
     9.016   132.641     0.150
     9.575   143.238     0.150
     9.771   134.340     0.150
    11.276   162.238     0.150
    12.328   178.738     0.150
    20.160   264.340     0.150
    57.194   581.340     0.150
    58.702   592.238     0.150
     1.509    24.594     0.150
     1.509    43.494     0.150
     1.566    24.895     0.150
     1.566    42.994     0.150
     1.566    24.895     0.150
     1.566    42.994     0.150
     1.602    43.395     0.150
     1.602    25.494     0.150
     1.602    43.395     0.150
     2.767    42.695     0.150
     3.310    49.895     0.150
     3.310    88.094     0.150
     4.769    70.395     0.150
     6.712   170.195     0.150
     6.724    96.195     0.150
     6.724   169.594     0.150
     6.822   167.395     0.150
     6.937   101.295     0.150
     7.594   112.494     0.150
     7.853   113.494     0.150
     8.356   120.395     0.150
     8.356   216.395     0.150
     8.686   125.494     0.150
     9.460   130.994     0.150
     9.937   140.895     0.150
    10.168   160.395     0.150
    12.313   173.895     0.150
    12.434   175.895     0.150
    12.653   178.594     0.150
    13.069   182.195     0.150
    13.069   200.395     0.150
    13.738   192.494     0.150
    14.566   202.395     0.150
    14.566     7.199     0.150
    14.566   232.395     0.150
    15.016   210.395     0.150
    16.686   229.395     0.150
    16.686    17.000     0.150
    20.417   270.395     0.150
    20.417    19.000     0.150
    20.761   494.395     0.150
    21.438    24.900     0.150
    21.438   280.494     0.150
    21.438    24.900     0.150
    21.438   512.395     0.150
    21.438   956.395     0.150
    21.474   301.594     0.150
    21.474   282.395     0.150
    21.474    19.199     0.150
    21.474   308.594     0.150
    21.474   513.395     0.150
    21.474   549.395     0.150
    22.279    22.500     0.150
    22.279   289.395     0.150
    22.279    22.500     0.150
    23.629    14.199     0.150
    23.905   560.395     0.150
    27.949    16.000     0.150
    27.949   343.395     0.150
    27.949    16.000     0.150
    27.949   624.395     0.150
    27.996   410.395     0.150
    28.462   350.395     0.150
    28.462   746.395     0.150
    28.462   350.395     0.150
    28.462   633.395     0.150
    28.462   746.395     0.150
    30.896   371.395     0.150
    31.281   376.594     0.150
    31.281   680.395     0.150
    32.671   387.395     0.150
    32.776   385.395     0.150
    32.776    19.000     0.150
    32.776   694.895     0.150
    33.324   700.395     0.150
    36.453   762.395     0.150
    37.309   425.395     0.150
    37.309   425.395     0.150
    37.309    11.000     0.150
    39.947   446.395     0.150
    39.947   446.395     0.150
    39.947   560.395     0.150
    39.947   567.395     0.150
    41.159   456.465     0.150
    42.497   467.725     0.150
    43.295   476.994     0.150
    43.295    23.000     0.150
    43.295   887.395     0.150
    44.064   481.994     0.150
    45.003   890.395     0.150
    48.274   927.395     0.150
    48.274   515.395     0.150
    48.274   927.395     0.150
    49.688   526.594     0.150
    52.257   617.195     0.150
    52.257   545.395     0.150
    52.257    21.000     0.150
    52.257   617.195     0.150
    52.257   983.395     0.150
    52.654   545.895     0.150
    53.470    26.100     0.150
    53.470   625.395     0.150
    53.470   553.795     0.150
    53.470    26.100     0.150
    53.470   625.395     0.150
    53.470  1002.895     0.150
    55.869   574.395     0.150
    58.571   592.695     0.150
    58.700   590.594     0.150
    59.781   599.895     0.150
    62.184   614.795     0.150
    62.356   618.594     0.150
    62.582  1110.395     0.150
    64.360   627.594     0.150
    64.801   647.395     0.150
    64.801   661.395     0.150
    64.801  1402.395     0.150
    64.801   631.195     0.150
    64.801    21.199     0.150
    64.801   661.395     0.150
    64.801  1402.395     0.150
    66.048   639.195     0.150
    66.973   649.504     0.150
    66.973  1449.504     0.150
    68.317   655.395     0.150
    68.576  1197.994     0.150
    68.576  1197.994     0.150
    68.600   685.395     0.150
    68.784  1308.764     0.150
    68.918   658.395     0.150
    69.483   677.584     0.150
    69.483  1217.584     0.150
    69.483  1268.584     0.150
    69.483  1455.584     0.150
    69.563   665.895     0.150
    69.960   656.174     0.150
    69.960  1222.174     0.150
    70.480   668.395     0.150
    70.480    22.000     0.150
    73.719   704.195     0.150
    73.849   688.395     0.150
    73.849  1243.395     0.150
    73.849  1300.395     0.150
    76.111    83.900     0.150
    77.287   706.795     0.150
    77.287    20.299     0.150
    77.287   706.795     0.150
    77.287    20.299     0.150
    77.292   707.094     0.150
    77.292    22.500     0.150
    77.779   743.594     0.150
    78.334   718.295     0.150
    78.334   713.395     0.150
    78.334   718.295     0.150
    78.334    22.199     0.150
    78.334   713.395     0.150
    78.334   718.295     0.150
    78.334    22.199     0.150
    78.842   717.795     0.150
    78.842    27.600     0.150
    78.842   751.395     0.150
    78.842   783.395     0.150
    79.027   718.895     0.150
    79.520   723.445     0.150
    80.261   724.994     0.150
    80.277   725.895     0.150
    80.604    23.301     0.150
    80.719   727.395     0.150
    80.969   728.594     0.150
    81.027   721.295     0.150
    81.196   729.695     0.150
    82.084   735.395     0.150
    82.118   731.795     0.150
    83.371   738.795     0.150
    83.813   742.594     0.150
    83.888   742.994     0.150
    84.042   742.795     0.150
    84.539   747.004     0.150
    86.728   755.395     0.150
     1.201    19.287     0.150
     1.201    34.588     0.150
     1.562    26.988     0.150
     5.722    85.889     0.150
     6.287    91.088     0.150
     1.418    22.750     0.150
     1.418    39.348     0.150
     3.522    54.551     0.150
     5.494    81.648     0.150
     6.707   191.449     0.150
    50.048   527.711     0.150
     0.346    14.633     0.150
     0.693    11.727     0.150
     0.693    20.430     0.150
     0.702    12.633     0.150
     0.702    21.930     0.150
     1.700    26.328     0.150
     1.700    47.531     0.150
     5.948   155.828     0.150
     7.471   110.930     0.150
     7.469   109.930     0.150
    65.640   638.133     0.150
    69.511   663.133     0.150
    75.959   700.938     0.150
     0.159     9.531     0.150
     0.159    16.031     0.150
     1.450    24.133     0.150
     1.450    42.432     0.150
     1.604    25.432     0.150
     1.604    44.633     0.150
     1.604    25.432     0.150
     1.604    44.633     0.150
     3.963   108.232     0.150
     5.184   135.133     0.150
     5.204   136.732     0.150
     6.241   156.232     0.150
     6.774    93.133     0.150
     6.774   166.332     0.150
     6.879    98.832     0.150
     6.879   179.832     0.150
     6.992    98.832     0.150
     7.574   183.332     0.150
     7.714   190.133     0.150
    28.480   348.332     0.150
    48.284   513.832     0.150
    58.644   590.432     0.150
    58.644   590.531     0.150
    66.035   638.732     0.150
    66.128   642.633     0.150
    79.016   718.133     0.150
    79.016   720.531     0.150
    79.016  1441.031     0.150
     0.973    31.477     0.150
     5.599    80.273     0.150
     5.889    87.477     0.150
     5.889    87.680     0.150
     6.941    98.875     0.150
     6.941   173.773     0.150
    58.701   590.375     0.150
    58.701   590.578     0.150
    62.395   618.578     0.150
    65.958   638.375     0.150
    66.122   644.875     0.150
    78.934   718.578     0.150
     0.874    29.213     0.150
     1.909    32.013     0.150
     0.314    14.038     0.150
     1.012    31.738     0.150
     1.391    43.138     0.150
     3.316    50.738     0.150
     1.451    22.828     0.150
     0.377    16.469     0.150
     0.566    13.562     0.150
     0.566    24.969     0.150
     0.936    17.562     0.150
     1.164    32.969     0.150
     2.022    55.766     0.150
     2.012    32.266     0.150
     2.012    56.969     0.150
     2.080    33.266     0.150
     2.080    57.867     0.150
     2.601    72.062     0.150
     2.664    70.867     0.150
     2.717    71.969     0.150
     0.168     4.465     0.150
     0.500    17.363     0.150
     0.593    21.363     0.150
     0.820    28.664     0.150
     1.021    18.363     0.150
     5.460    81.465     0.150
    58.919   596.863     0.150
    58.919   597.062     0.150
    66.247   644.863     0.150
     0.820    28.637     0.150
     1.029    35.938     0.150
     1.019    18.535     0.150
     1.905    57.535     0.150
     2.395    39.336     0.150
     4.062    63.938     0.150
     6.610   102.836     0.150
    58.919   596.836     0.150
    58.919   596.938     0.150
    68.957   662.238     0.150
     0.578     9.273     0.150
     0.578    16.977     0.150
     0.773    12.375     0.150
     0.773    22.875     0.150
     0.966    15.477     0.150
     0.966    26.477     0.150
     1.113    18.172     0.150
     1.113    32.570     0.150
     1.752    26.070     0.150
     1.752    47.070     0.150
     1.670    29.070     0.150
     1.928    53.773     0.150
     3.449    51.375     0.150
     4.620   122.875     0.150
     5.460   142.570     0.150
     5.508    80.672     0.150
     5.508   143.672     0.150
     5.779    83.977     0.150
     6.711   179.070     0.150
     6.982   103.875     0.150
     0.410     9.238     0.150
     1.313    40.539     0.150
     1.665    49.539     0.150
     1.880    31.938     0.150
     2.133    58.991     0.150
     0.092     1.705     0.150
     0.519    10.505     0.150
     0.992    34.805     0.150
     1.744    29.805     0.150
     1.847    32.205     0.150
     3.255    51.505     0.150
     6.632   105.305     0.150
    69.690   668.405     0.150
     0.390    14.344     0.150
     1.319    36.547     0.150
     0.814    28.297     0.150
     1.900    31.998     0.150
     2.908    45.697     0.150
     2.318    36.359     0.150
     0.817    27.172     0.150
     1.424    26.773     0.150
     1.803    30.773     0.150
     4.717    69.453     0.150
     4.717   126.953     0.150
     6.756    92.852     0.150
     6.990   101.551     0.150
     8.485   116.352     0.150
     9.299   131.652     0.150
    21.374   278.250     0.150
    28.389   347.852     0.150
    38.929   439.352     0.150
    38.929   568.152     0.150
    41.590   462.852     0.150
    44.056   481.453     0.150
    44.056    12.500     0.150
    48.008   514.281     0.150
    48.200   513.352     0.150
    65.549   637.750     0.150
    77.216   706.352     0.150
    83.830   743.051     0.150
    85.957   752.562     0.150
     0.983    32.309     0.150
     1.172    36.609     0.150
     1.808    29.508     0.150
    51.177   534.410     0.150
    64.819   630.512     0.150
    85.966   752.207     0.150
     0.691    12.249     0.150
     0.823    27.048     0.150
     1.045    33.249     0.150
     1.042    31.548     0.150
     1.203    37.048     0.150
     1.395    41.548     0.150
     1.649    27.648     0.150
     1.720    28.548     0.150
     1.720    50.349     0.150
     1.738    28.548     0.150
     2.003    32.349     0.150
     2.623    41.349     0.150
     0.704    14.719     0.150
     1.179    34.117     0.150
     2.026    56.117     0.150
     2.162    34.117     0.150
     2.272    36.523     0.150
     2.272    63.617     0.150
     2.768    43.320     0.150
     2.892    45.117     0.150
     3.556    90.719     0.150
     5.104   132.219     0.150
     5.957   147.422     0.150
     6.085    89.219     0.150
     0.312    15.648     0.150
     0.956    17.852     0.150
     1.099    31.250     0.150
     1.957    54.148     0.150
     1.954    32.449     0.150
     2.033    33.148     0.150
     2.547    40.750     0.150
     2.695    43.551     0.150
     2.792    44.949     0.150
     5.475   141.949     0.150
    48.976   522.141     0.150
    50.948   537.543     0.150
     0.548    11.742     0.150
     0.816    13.742     0.150
     0.816    23.344     0.150
     0.717    14.539     0.150
     0.801    23.938     0.150
     1.083    18.844     0.150
     1.083    34.539     0.150
     1.132    35.141     0.150
     1.464    44.039     0.150
     1.564    46.742     0.150
     2.432    67.938     0.150
     2.685    42.539     0.150
     2.865    45.141     0.150
     3.389    52.344     0.150
     4.531   120.844     0.150
     7.602   110.742     0.150
    25.241   319.242     0.150
    25.241    11.500     0.150
    58.073   602.844     0.150
    64.455   631.039     0.150
     0.968    18.475     0.150
     1.285    21.574     0.150
     1.471    24.773     0.150
     1.727    27.373     0.150
     2.313    36.475     0.150
     2.765    41.674     0.150
     4.717    69.475     0.150
     4.717   122.674     0.150
     6.593   103.373     0.150
     6.734    93.975     0.150
     6.786    97.674     0.150
     6.870   150.475     0.150
     6.870   207.674     0.150
     7.602   106.574     0.150
     8.630   228.572     0.150
    10.032   145.674     0.150
    10.032   145.674     0.150
    10.508   149.475     0.150
    11.027   170.674     0.150
    11.027   343.674     0.150
    12.365   181.373     0.150
    12.365   202.072     0.150
    12.555   316.873     0.150
    12.933   181.074     0.150
    14.435   199.475     0.150
    14.435   199.475     0.150
    15.160   205.873     0.150
    18.015   251.775     0.150
    18.015   251.775     0.150
    20.287    16.000     0.150
    20.287   268.674     0.150
    20.287   524.674     0.150
    20.297   725.674     0.150
    21.355   505.674     0.150
    21.355   277.775     0.150
    21.355   505.674     0.150
    21.454   279.674     0.150
    21.454   511.674     0.150
    23.778   310.072     0.150
    24.020   305.174     0.150
    25.491   321.275     0.150
    25.491   534.174     0.150
    27.817   342.475     0.150
    27.817    13.098     0.150
    28.328   346.975     0.150
    30.767    15.500     0.150
    30.767    26.000     0.150
    30.767   369.674     0.150
    30.767    15.500     0.150
    30.767   395.674     0.150
    30.767   446.674     0.150
    37.196    17.598     0.150
    37.196   426.275     0.150
    37.196    17.598     0.150
    38.898   436.572     0.150
    38.898   568.072     0.150
    40.297   450.475     0.150
    41.631   461.572     0.150
    43.620   477.275     0.150
    43.921  2334.975     0.150
    45.116   489.975     0.150
    47.108   503.674     0.150
    49.552   520.174     0.150
    53.349   552.174     0.150
    53.349    13.500     0.150
    60.706   603.475     0.150
    62.454  2415.674     0.150
    62.556   619.572     0.150
    64.687   630.674     0.150
    64.687    22.000     0.150
    64.915   632.436     0.150
    68.444   655.072     0.150
    68.449    18.199     0.150
    68.449   655.873     0.150
    68.449    18.199     0.150
    68.472   645.674     0.150
    68.472   645.674     0.150
    68.472   678.674     0.150
    77.183   706.373     0.150
    77.183   706.373     0.150
    77.187   707.475     0.150
    78.231   712.674     0.150
    78.736   715.674     0.150
    78.736    18.000     0.150
    79.161   718.475     0.150
    79.161    15.801     0.150
    80.348   726.174     0.150
    81.012    17.898     0.150
    81.148    16.098     0.150
    84.978   748.572     0.150
    86.270   753.674     0.150
     0.235    15.562     0.150
     1.002    29.965     0.150
     1.796    29.062     0.150
     0.390    15.934     0.150
     0.851    15.133     0.150
     1.396    24.035     0.150
     1.396    43.336     0.150
     1.726    28.133     0.150
     2.892    45.934     0.150
     3.254    50.234     0.150
     3.324    51.035     0.150
     3.763    57.633     0.150
     3.967    60.336     0.150
     1.014    32.016     0.150
     1.911    30.516     0.150
     1.911    53.016     0.150
     2.317    39.117     0.150
     4.706    69.715     0.150
     4.706   122.617     0.150
     5.227   134.816     0.150
     5.959    87.414     0.150
     7.062   102.715     0.150
     7.693   108.816     0.150
    12.723   326.914     0.150
    37.366   428.117     0.150
    39.958    12.898     0.150
    59.617   594.516     0.150
     1.060    18.575     0.150
     1.685    26.475     0.150
     1.690    28.275     0.150
     2.492    41.575     0.150
     2.884    47.375     0.150
     3.445    53.875     0.150
     3.649    57.175     0.150
     5.521    82.075     0.150
     6.040    89.375     0.150
    12.300   179.075     0.150
    58.718   593.075     0.150
     0.364    15.828     0.150
     0.981    28.422     0.150
     0.619    20.598     0.150
     1.476    42.395     0.150
     0.372    17.008     0.150
     1.095    33.508     0.150
     1.471    44.109     0.150
     1.676    25.508     0.150
     1.721    51.008     0.150
     1.772    51.508     0.150
     2.533    39.805     0.150
     3.772    57.305     0.150
     1.010    30.469     0.150
     0.993    32.012     0.150
     7.423   102.711     0.150
    12.353   178.512     0.150
    25.430   327.512     0.150
    64.761   631.711     0.150
     1.017    30.143     0.150
     1.874    53.143     0.150
     1.982    33.143     0.150
     1.982    56.742     0.150
     2.179    36.143     0.150
     2.179    61.941     0.150
     2.485    70.143     0.150
     1.358    40.172     0.150
     7.465   105.375     0.150
    25.426   326.375     0.150
    44.658   489.273     0.150
    73.382   688.773     0.150
     0.572    18.500     0.150
     1.405    22.000     0.150
     3.654    55.500     0.150
     0.642    12.516     0.150
     0.907    28.316     0.150
     4.090    65.418     0.150
     4.401    64.117     0.150
     4.401   113.316     0.150
     6.572   107.617     0.150
     6.572   164.117     0.150
     7.311   104.117     0.150
     7.311   188.117     0.150
     8.300   149.617     0.150
     8.300   208.117     0.150
     9.531   152.016     0.150
     9.909   238.418     0.150
    16.108    16.000     0.150
    20.686   273.117     0.150
    21.149   280.117     0.150
    21.149   504.117     0.150
    23.866   301.719     0.150
    28.511   362.117     0.150
    31.172   373.617     0.150
    40.150   449.316     0.150
    43.552   477.117     0.150
    51.256   536.016     0.150
    51.606   539.316     0.150
    62.794   618.719     0.150
    62.794    16.297     0.150
    64.143   626.316     0.150
    64.684    15.898     0.150
    65.837   637.418     0.150
    66.520    18.699     0.150
    68.577   657.117     0.150
    69.699   662.016     0.150
    72.655    16.102     0.150
    73.992   694.816     0.150
     0.918    27.820     0.150
     2.646    56.523     0.150
    12.724   182.723     0.150
    17.914     9.902     0.150
    39.853   447.922     0.150
    41.514   463.211     0.150
    44.026   479.121     0.150
     0.926    27.867     0.150
     1.833    57.070     0.150
     2.637    45.672     0.150
     2.637    64.766     0.150
     4.639    68.867     0.150
     4.639   123.172     0.150
     6.910    99.469     0.150
     6.910   176.469     0.150
    12.673   316.867     0.150
    12.734   173.867     0.150
    25.483   321.969     0.150
    25.483   532.266     0.150
    28.371   347.969     0.150
    38.871   442.266     0.150
    38.871   442.266     0.150
    39.532   444.766     0.150
    39.532   571.672     0.150
    40.030   448.469     0.150
    58.607   589.469     0.150
    58.607    14.602     0.150
    62.478   617.469     0.150
    62.478    14.898     0.150
    64.232   627.070     0.150
    68.470   646.867     0.150
    69.603  5289.469     0.150
    78.716   711.969     0.150
    83.770   742.766     0.150
    83.770   742.766     0.150
    84.300   745.367     0.150
    84.356   745.070     0.150
    84.954   748.672     0.150
    86.199   754.172     0.150
    86.247   754.266     0.150
    86.425   755.672     0.150
    87.774   761.070     0.150
    89.090   769.172     0.150
     0.240    12.924     0.150
     0.488     9.023     0.150
     0.752    22.824     0.150
     4.459    74.424     0.150
     4.459    79.225     0.150
     4.459    85.424     0.150
     4.459    92.324     0.150
     4.459   110.924     0.150
     7.039   176.424     0.150
    12.562   182.623     0.150
    25.322   325.424     0.150
    44.305   489.225     0.150
    66.376   647.623     0.150
     0.725    23.680     0.150
     7.376   111.180     0.150
    12.469   179.078     0.150
    13.003   187.180     0.150
     0.944    28.840     0.150
     2.662    46.641     0.150
     4.663    76.641     0.150
     4.663    83.641     0.150
     4.663    96.242     0.150
     4.663    69.641     0.150
     4.663   123.641     0.150
     8.298   118.641     0.150
     8.298   215.641     0.150
     8.574   224.340     0.150
    10.096   143.641     0.150
    10.096   143.641     0.150
    10.527   150.840     0.150
    13.005   182.242     0.150
    14.516   202.242     0.150
    14.516   202.242     0.150
    15.563   224.039     0.150
    15.563   225.941     0.150
    15.563   228.441     0.150
    15.563   231.539     0.150
    15.563   239.539     0.150
    17.681   241.141     0.150
    17.940   438.641     0.150
    17.940   243.641     0.150
    17.940   438.641     0.150
    20.370   269.641     0.150
    20.381   269.742     0.150
    21.326   299.641     0.150
    21.326   278.340     0.150
    21.326    21.301     0.150
    21.326   508.641     0.150
    22.184   286.641     0.150
    24.031   306.441     0.150
    28.374   348.039     0.150
    29.847   362.039     0.150
    30.852   370.641     0.150
    37.294    17.398     0.150
    37.294   426.641     0.150
    37.294    17.398     0.150
    38.772   437.840     0.150
    38.772   795.641     0.150
    42.401   469.441     0.150
    43.979   481.242     0.150
    49.132   511.641     0.150
    49.132   511.641     0.150
    52.153   544.641     0.150
    52.820   545.641     0.150
    52.958   544.641     0.150
    53.366   553.340     0.150
    57.876   579.340     0.150
    57.876   579.340     0.150
    58.390   583.641     0.150
    59.551   597.840     0.150
    63.054   617.641     0.150
    64.248   627.539     0.150
    64.694   630.840     0.150
    65.150   635.641     0.150
    65.501   637.742     0.150
    68.478   656.641     0.150
    68.478   679.141     0.150
    68.503   656.641     0.150
    68.503    11.000     0.150
    72.978   684.742     0.150
    73.053   685.242     0.150
    75.396   696.941     0.150
    75.396   702.840     0.150
    77.176   706.039     0.150
    77.181   707.242     0.150
    78.223   711.641     0.150
    78.223   711.641     0.150
    78.597   713.641     0.150
    78.731   716.141     0.150
    78.731   722.340     0.150
    79.153   718.641     0.150
    79.153   723.340     0.150
    82.307   735.242     0.150
    83.597   742.539     0.150
    84.970   749.539     0.150
    85.463   751.039     0.150
     0.921    28.826     0.150
     2.648    51.626     0.150
     2.648    57.426     0.150
     2.648    62.526     0.150
     4.515    90.726     0.150
     4.638    69.226     0.150
     4.638    89.226     0.150
     4.638    93.226     0.150
     4.638   102.226     0.150
     4.638    69.226     0.150
     4.638   119.726     0.150
     6.796   177.226     0.150
     8.291   220.226     0.150
     8.291   119.226     0.150
     8.291   220.226     0.150
     9.554   135.426     0.150
     9.554   241.226     0.150
    10.508   326.726     0.150
    10.508   149.026     0.150
    10.508   265.726     0.150
    12.248   182.326     0.150
    14.511   216.226     0.150
    14.511   357.226     0.150
    15.542    22.400     0.150
    17.665   240.526     0.150
    20.366    20.000     0.150
    20.366   485.226     0.150
    20.366   516.226     0.150
    20.366   269.226     0.150
    20.366    20.000     0.150
    20.366   485.226     0.150
    20.366   516.226     0.150
    20.377   269.526     0.150
    21.302   295.226     0.150
    21.302   277.026     0.150
    21.302    18.200     0.150
    21.302   506.226     0.150
    21.357   278.726     0.150
    25.475   321.026     0.150
    25.881   325.126     0.150
    28.183   346.326     0.150
    28.359   348.026     0.150
    28.359   540.026     0.150
    29.831   361.226     0.150
    30.848   370.226     0.150
    32.605    12.200     0.150
    37.297   426.626     0.150
    38.755   437.826     0.150
    38.755   791.226     0.150
    39.854    15.500     0.150
    39.854    22.500     0.150
    40.310   450.526     0.150
    40.310   803.226     0.150
    40.398   452.026     0.150
    40.582   454.026     0.150
    41.517   460.426     0.150
    43.671   478.426     0.150
    43.961   481.026     0.150
    44.969   835.226     0.150
    45.000   487.626     0.150
    49.601    20.100     0.150
    49.601    28.100     0.150
    51.414   588.226     0.150
    52.134   544.226     0.150
    52.134    22.000     0.150
    52.813   545.226     0.150
    53.033   933.226     0.150
    55.682   570.906     0.150
    57.853   584.126     0.150
    59.744   598.226     0.150
    62.475   616.726     0.150
    62.475   654.326     0.150
    63.813   625.226     0.150
    63.781   627.126     0.150
    63.855   628.726     0.150
    64.226   627.126     0.150
    64.672   668.232     0.150
    64.672   630.426     0.150
    64.672    20.800     0.150
    64.672   668.826     0.150
    64.867   631.996     0.150
    65.486   637.226     0.150
    65.914   638.326     0.150
    66.203   644.726     0.150
    68.460   655.926     0.150
    68.485   655.226     0.150
    68.485    25.000     0.150
    68.886   658.726     0.150
    70.933   671.426     0.150
    75.374   701.026     0.150
    75.374   696.926     0.150
    77.153   706.926     0.150
    77.153    23.500     0.150
    77.158   709.626     0.150
    77.158   706.726     0.150
    77.646    21.000     0.150
    77.646   709.726     0.150
    77.646    21.000     0.150
    78.200    20.400     0.150
    78.200   712.826     0.150
    78.200    20.400     0.150
    78.573   717.573     0.150
    78.709   715.626     0.150
    78.709   725.726     0.150
    79.131    30.600     0.150
    79.131   718.326     0.150
    79.131    22.700     0.150
    80.052  1230.456     0.150
    80.129   723.926     0.150
    80.375   724.726     0.150
    81.547   731.326     0.150
    81.614   730.226     0.150
    82.284   733.426     0.150
    83.797   741.126     0.150
    84.062   742.726     0.150
    84.163   743.726     0.150
    84.285   744.626     0.150
    84.294   744.826     0.150
    84.315   744.226     0.150
    84.350   744.526     0.150
    84.948   747.326     0.150
    85.167   748.726     0.150
    85.328   748.826     0.150
    85.633   751.326     0.150
    85.900  1068.526     0.150
    85.994   752.126     0.150
    86.192   753.426     0.150
    86.241   753.626     0.150
    87.768   762.026     0.150
   123.164  1129.526     0.150
     0.841    26.664     0.150
     0.936    29.367     0.150
     1.306    37.965     0.150
     4.667    69.465     0.150
     6.857   166.766     0.150
     8.262   220.766     0.150
     9.629   301.867     0.150
     9.629   303.566     0.150
    10.506   276.266     0.150
    10.982   165.766     0.150
    10.982   275.465     0.150
    11.267   177.965     0.150
    11.267   185.066     0.150
    11.267   282.266     0.150
    12.738   192.867     0.150
    12.970   332.766     0.150
    14.922   208.664     0.150
    14.922   221.766     0.150
    14.922   232.164     0.150
    14.989   217.766     0.150
    15.545   392.766     0.150
    15.553   216.965     0.150
    20.732   510.766     0.150
    21.394   311.766     0.150
    21.394   559.766     0.150
    23.539   299.266     0.150
    23.539    21.500     0.150
    25.780    16.699     0.150
    26.584   336.766     0.150
    27.829   387.566     0.150
    27.829   626.766     0.150
    27.927    12.203     0.150
    30.260   377.664     0.150
    30.815    14.000     0.150
    30.815    23.000     0.150
    30.815   456.766     0.150
    33.258   393.164     0.150
    39.833   836.766     0.150
    40.006   572.766     0.150
    40.628   459.164     0.150
    41.561   462.496     0.150
    44.933   486.766     0.150
    53.345   623.766     0.150
    64.884   632.285     0.150
    66.167   654.066     0.150
    68.453  1185.367     0.150
    68.478   651.766     0.150
    73.815   702.266     0.150
    75.380   760.664     0.150
    75.380  1285.367     0.150
    76.140   706.266     0.150
    77.167   695.766     0.150
    77.654    31.000     0.150
    78.210   713.766     0.150
    78.902   715.441     0.150
    80.777   729.766     0.150
    81.252   730.766     0.150
    83.763   758.566     0.150
    84.326   744.164     0.150
    84.957   747.266     0.150
    85.450   751.066     0.150
    86.250   753.867     0.150
    86.853   757.066     0.150
    89.097   767.566     0.150
     0.703    14.223     0.150
     0.937    15.723     0.150
     1.227    35.121     0.150
     7.599   192.121     0.150
    10.095   145.270     0.150
    10.831   157.121     0.150
    13.462   341.871     0.150
    24.267   314.723     0.150
    28.132   342.223     0.150
    31.581   375.621     0.150
    34.070   401.922     0.150
    38.094   435.922     0.150
    40.428    23.000     0.150
    40.428   570.621     0.150
    40.428   810.121     0.150
    40.844   456.512     0.150
    42.952   475.871     0.150
    44.287   484.320     0.150
    52.417    11.801     0.150
    57.951   604.320     0.150
    60.451   609.223     0.150
    61.096   611.500     0.150
    64.829   632.980     0.150
    64.829   633.652     0.150
    66.639   646.422     0.150
    69.511   664.262     0.150
    71.047   674.840     0.150
    71.885   679.742     0.150
    71.885    14.438     0.150
    78.282   714.121     0.150
    78.818   720.621     0.150
    79.382   718.020     0.150
    81.157   719.621     0.150
    83.795   743.223     0.150
    85.309   749.820     0.150
    86.089   755.223     0.150
     0.644    12.598     0.150
     0.918    28.996     0.150
     2.216    53.996     0.150
     8.304   208.797     0.150
     8.592   128.098     0.150
    10.337   144.098     0.150
    10.746   165.898     0.150
    11.821   189.496     0.150
    11.821   289.098     0.150
    21.156   268.297     0.150
    28.327   359.199     0.150
    64.672    29.000     0.150
    69.661   660.496     0.150
    70.501   665.238     0.150
    75.344  1287.297     0.150
    77.091   708.098     0.150
    78.659   713.098     0.150
     0.457    18.812     0.150
     0.635    19.512     0.150
     1.073    33.812     0.150
     7.935   120.711     0.150
     9.766   144.711     0.150
     9.766   257.512     0.150
    10.351   269.711     0.150
    12.652   182.211     0.150
    12.652   195.711     0.150
    12.652   325.711     0.150
    18.160   451.512     0.150
    21.380   289.711     0.150
    21.380   510.711     0.150
    26.216   328.711     0.150
    32.248    12.000     0.150
    36.880    17.199     0.150
    36.880   759.711     0.150
    40.109   575.410     0.150
    41.863   466.582     0.150
    44.567   592.711     0.150
    48.465   519.680     0.150
    51.345   544.109     0.150
    51.980   570.312     0.150
    52.841   549.711     0.150
    59.345   538.211     0.150
    62.202   738.711     0.150
    63.702  1129.812     0.150
    63.702  1173.312     0.150
    63.702  1383.512     0.150
    64.879   636.141     0.150
    64.879   637.312     0.150
    77.976   719.512     0.150
    78.148   716.012     0.150
    84.649   752.312     0.150
    91.113   778.812     0.150
    91.437   774.770     0.150
    94.304   790.371     0.150
    94.933   790.281     0.150
   143.160  1168.598     0.150
     0.911    28.469     0.150
     1.840    55.320     0.150
     6.812    90.469     0.150
     9.502   139.172     0.150
    10.004   163.766     0.150
    12.562   173.102     0.150
    12.562   321.477     0.150
    15.178   361.672     0.150
    16.092   218.367     0.150
    17.962   439.469     0.150
    51.324   622.766     0.150
    59.649    24.500     0.150
    72.831   684.875     0.150
    82.249   735.266     0.150
    87.747   761.367     0.150
   120.113  1119.266     0.150
     0.947    29.567     0.150
     4.530    88.967     0.150
     4.530   114.567     0.150
    10.598   275.067     0.150
    12.937   183.994     0.150
    12.937   331.117     0.150
    15.573   219.967     0.150
    15.594    18.000     0.150
    21.241   280.567     0.150
    40.040    10.000     0.150
    44.131    25.500     0.150
    48.355   515.267     0.150
    49.685   525.927     0.150
    69.797   664.494     0.150
     1.854    56.094     0.150
     4.521   114.000     0.150
     8.571   209.797     0.150
     9.537   229.648     0.150
     9.640   143.797     0.150
    10.978   169.797     0.150
    12.663   325.969     0.150
    15.188   365.648     0.150
    15.569   216.500     0.150
    40.408   465.500     0.150
    71.445   670.398     0.150
    74.533   693.453     0.150
    74.953   696.266     0.150
    74.955   695.617     0.150
    78.224   713.000     0.150
    81.638   730.000     0.150
    82.307   733.297     0.150
    83.597   739.500     0.150
    83.788   741.094     0.150
    83.820   740.898     0.150
    84.085   742.594     0.150
    84.187   743.594     0.150
    84.267   743.594     0.150
    84.308   744.500     0.150
    84.318   744.594     0.150
    84.374   744.195     0.150
    84.971   747.094     0.150
    85.130   748.500     0.150
    85.191   748.594     0.150
    85.352   749.297     0.150
    85.464   749.297     0.150
    85.613   750.797     0.150
    85.656   751.094     0.150
    86.018   752.398     0.150
    86.216   753.398     0.150
    86.287   754.297     0.150
    86.442   755.594     0.150
    86.863   757.500     0.150
    89.108   768.297     0.150
     1.099    35.609     0.150
     1.685    28.180     0.150
    12.306   317.859     0.150
    13.087   187.660     0.150
    18.318   252.410     0.150
    18.318   252.410     0.150
    21.076   284.910     0.150
    27.780   349.012     0.150
    27.950   349.312     0.150
    32.184   386.812     0.150
    49.463   527.211     0.150
    58.730   591.910     0.150
    68.076     5.102     0.150
    77.904   714.711     0.150
    78.403    18.602     0.150
    83.533   743.109     0.150
    84.812   750.109     0.150
    84.888   750.812     0.150
    85.138   751.312     0.150
    86.137   757.812     0.150
     0.961    31.484     0.150
     4.751    70.383     0.150
    10.267   273.383     0.150
    12.181   313.781     0.150
    12.897   183.234     0.150
    29.503   355.281     0.150
    39.691   446.086     0.150
    41.868   464.281     0.150
    48.160   512.383     0.150
    48.184   512.984     0.150
    48.388   514.383     0.150
    49.418   521.680     0.150
    53.109   548.383     0.150
    64.643   630.109     0.150
    65.793   639.680     0.150
    69.744   662.672     0.150
    74.759   699.461     0.150
    78.566   709.383     0.150
     0.955    28.496     0.150
     8.597   224.695     0.150
     9.500   230.496     0.150
    10.523   274.195     0.150
    11.284   153.695     0.150
    12.302   168.695     0.150
    12.302   311.195     0.150
    12.981   331.496     0.150
    21.339    18.500     0.150
    21.339   505.797     0.150
    21.339   519.496     0.150
    21.339   548.797     0.150
    23.548   594.695     0.150
    27.932    10.699     0.150
    30.822    18.500     0.150
    30.822    26.000     0.150
    32.586   690.496     0.150
    33.641   717.195     0.150
    37.259   761.996     0.150
    39.528   569.945     0.150
    39.846    15.500     0.150
    39.846    22.500     0.150
    39.846   569.695     0.150
    42.439   466.254     0.150
    44.998   479.695     0.150
    49.592    11.000     0.150
    52.150  1002.695     0.150
    52.795   544.695     0.150
    52.933   602.695     0.150
    60.516   604.305     0.150
    64.694   667.094     0.150
    66.151   634.297     0.150
    74.617   690.395     0.150
    76.159   698.395     0.150
    78.229   712.695     0.150
    78.736   720.695     0.150
    78.736    10.199     0.150
    78.736    28.598     0.150
    80.863  1312.355     0.150
    80.863  1321.305     0.150
    80.863  1324.855     0.150
    84.615   740.094     0.150
    93.508   887.695     0.150
   147.695  1215.695     0.150
   147.948  1214.996     0.150
   148.093  1214.695     0.150
     2.742    41.820     0.150
     2.742    73.320     0.150
     4.608   115.320     0.150
     4.668    69.617     0.150
     6.820    98.523     0.150
     6.820    98.258     0.150
     6.820    98.219     0.150
    10.005   163.320     0.150
    17.601   240.188     0.150
    17.601   240.219     0.150
    20.283   268.977     0.150
    20.283   269.023     0.150
    21.305   282.422     0.150
    37.196   425.023     0.150
    39.777    16.297     0.150
    42.546   469.523     0.150
    42.546   581.117     0.150
    43.154   477.117     0.150
    44.163   482.727     0.150
    44.163   482.719     0.150
    44.462   484.047     0.150
    44.462   484.023     0.150
    48.106   513.617     0.150
    49.194   521.031     0.150
    49.194   521.023     0.150
    57.222   579.320     0.150
    59.524   595.281     0.150
    59.524   595.320     0.150
    62.427   616.430     0.150
    62.427   616.422     0.150
    64.746   630.617     0.150
    69.812   662.789     0.150
    69.812   662.820     0.150
    70.941   671.750     0.150
    73.173   684.781     0.150
    76.448   701.133     0.150
    85.997   754.703     0.150
   147.688  1194.023     0.150
   147.688  1176.820     0.150
   147.688  1194.023     0.150
   147.943  1194.820     0.150
     6.913    99.945     0.150
     6.913    99.957     0.150
    42.681   471.156     0.150
    44.369   484.355     0.150
    47.845   511.055     0.150
    48.223   513.758     0.150
    48.990   519.758     0.150
    62.457   616.207     0.150
    62.457   616.258     0.150
    64.278   629.055     0.150
    64.815   631.125     0.150
    64.815   631.156     0.150
    69.867   663.277     0.150
    69.867   663.258     0.150
     1.031    31.086     0.150
     1.854    28.336     0.150
     2.375    34.289     0.150
     4.241    67.289     0.150
     7.137   190.789     0.150
     7.137   191.289     0.150
     7.137    99.789     0.150
     7.137    99.789     0.150
    12.975   176.742     0.150
    17.897   243.992     0.150
    41.291   459.289     0.150
    42.859   472.391     0.150
    43.559   476.992     0.150
    44.088   481.688     0.150
    44.147   481.812     0.150
    44.147    13.328     0.150
    44.147   481.789     0.150
    44.147    13.398     0.150
    48.908   517.789     0.150
    49.122   516.078     0.150
    49.122   516.086     0.150
    58.393   599.992     0.150
    58.393   588.781     0.150
    58.393    15.008     0.150
    58.393   588.789     0.150
    58.393    15.000     0.150
    62.593   617.547     0.150
    62.593   617.586     0.150
    64.850   631.766     0.150
    64.850    13.523     0.150
    64.850   631.789     0.150
    64.850    13.500     0.150
    69.876   665.336     0.150
    69.876   665.391     0.150
    72.807   683.062     0.150
    72.807   697.852     0.150
    85.611   753.062     0.150
     0.920    28.070     0.150
     1.840    46.117     0.150
     1.840    29.664     0.150
     1.840    46.164     0.150
     2.688    40.867     0.150
     2.688    71.070     0.150
     4.555    67.266     0.150
     4.555   121.867     0.150
     4.652    68.867     0.150
     4.652   120.867     0.150
     6.866    98.266     0.150
     6.866   191.977     0.150
     6.866    98.914     0.150
     6.866   191.977     0.150
     6.866    98.969     0.150
    10.053   152.469     0.150
    10.053   143.094     0.150
    12.962   200.570     0.150
    12.962   181.367     0.150
    12.962   200.570     0.150
    12.962   323.867     0.150
    14.473   201.469     0.150
    17.640   241.070     0.150
    17.941   242.570     0.150
    20.328   269.266     0.150
    20.338   269.367     0.150
    20.933   274.867     0.150
    21.380   558.766     0.150
    25.852   325.469     0.150
    27.816    16.594     0.150
    27.924   343.367     0.150
    28.158   346.164     0.150
    29.807   358.164     0.150
    30.809     8.500     0.150
    30.809   369.867     0.150
    30.809     8.500     0.150
    32.569    13.602     0.150
    32.569    19.500     0.150
    32.569   385.969     0.150
    32.569    13.602     0.150
    32.569    19.500     0.150
    32.569   455.570     0.150
    32.569   551.766     0.150
    32.569   697.164     0.150
    32.569   770.664     0.150
    32.569   775.367     0.150
    32.569   816.570     0.150
    32.569  1008.664     0.150
    33.255   390.570     0.150
    33.639   394.367     0.150
    37.255    23.695     0.150
    37.255   425.969     0.150
    37.255    23.695     0.150
    37.255   513.969     0.150
    39.499   444.891     0.150
    39.499   571.469     0.150
    39.499   444.891     0.150
    39.499   571.469     0.150
    39.499   444.867     0.150
    39.499   571.469     0.150
    39.823    15.500     0.150
    39.823   447.367     0.150
    39.823    15.500     0.150
    39.823   544.070     0.150
    39.823   572.367     0.150
    39.823   795.367     0.150
    39.823   802.367     0.150
    39.823   807.867     0.150
    39.823   833.164     0.150
    42.588   469.539     0.150
    42.588   581.414     0.150
    42.588   469.539     0.150
    42.588   581.414     0.150
    42.588   469.570     0.150
    42.588   581.469     0.150
    43.210   476.164     0.150
    43.605   478.664     0.150
    44.222   483.969     0.150
    44.222   588.164     0.150
    44.222   483.969     0.150
    44.222   588.164     0.150
    49.151   520.664     0.150
    52.118   566.766     0.150
    52.986   541.766     0.150
    55.610   568.102     0.150
    58.649   590.266     0.150
    58.649    14.703     0.150
    59.528   595.828     0.150
    59.528    16.250     0.150
    59.528   643.477     0.150
    59.528   595.867     0.150
    59.528    16.203     0.150
    59.528   643.469     0.150
    59.704   597.367     0.150
    60.482    10.406     0.150
    60.482   603.328     0.150
    60.482    10.406     0.150
    62.453   616.453     0.150
    62.453    16.273     0.150
    62.453   616.469     0.150
    62.453    16.297     0.150
    64.661   629.766     0.150
    64.661   663.469     0.150
    64.758   630.664     0.150
    64.758    16.125     0.150
    64.758   630.664     0.150
    64.868   629.906     0.150
    64.868    14.070     0.150
    65.820   636.266     0.150
    69.818   662.664     0.150
    69.818   662.945     0.150
    69.818   683.992     0.150
    69.818   662.969     0.150
    69.818   683.969     0.150
    70.885   671.969     0.150
    70.885    14.477     0.150
    73.005   681.914     0.150
    73.005   681.969     0.150
    73.120   684.414     0.150
    73.120   698.453     0.150
    73.120    20.656     0.150
    73.829   689.133     0.150
    73.829    14.969     0.150
    77.148   706.164     0.150
    77.248   708.039     0.150
    77.639   708.570     0.150
    78.195   711.867     0.150
    78.702   715.469     0.150
    80.979   728.570     0.150
    85.631   751.070     0.150
    85.942   754.695     0.150
    85.942    14.898     0.150
    85.989   753.469     0.150
    86.261   754.367     0.150
    86.837   757.570     0.150
    87.764   761.664     0.150
    93.085   786.828     0.150
   124.813  1132.570     0.150
   147.722  1193.867     0.150
   147.722  1176.070     0.150
   147.722  1193.867     0.150
   147.976  1193.969     0.150
   147.976  1176.664     0.150
   147.976  1193.969     0.150
   148.120  1195.070     0.150
   148.120  1195.070     0.150
   151.775  1188.664     0.150
   151.775  1197.852     0.150
   151.775  1188.664     0.150
     0.921    27.911     0.150
     2.638    40.312     0.150
     2.638    70.111     0.150
     4.504    67.911     0.150
     4.504   120.611     0.150
     4.635    68.111     0.150
     6.910    98.812     0.150
     6.910    99.161     0.150
     6.910   179.687     0.150
     6.910    99.211     0.150
     6.910   179.711     0.150
    17.672   241.053     0.150
    17.672   241.012     0.150
    20.387   270.062     0.150
    20.387   270.111     0.150
    24.014   300.911     0.150
    25.888   325.812     0.150
    28.189   344.312     0.150
    28.189   366.512     0.150
    42.622   470.286     0.150
    42.622   581.512     0.150
    43.560   478.211     0.150
    43.952   480.812     0.150
    44.371   484.111     0.150
    44.371    13.000     0.150
    44.371    19.600     0.150
    47.786   510.711     0.150
    48.164   513.711     0.150
    48.931   519.711     0.150
    53.351   552.211     0.150
    57.157   578.711     0.150
    59.528   595.850     0.150
    59.528   595.812     0.150
    62.481   616.295     0.150
    62.481    15.875     0.150
    62.481   616.312     0.150
    62.481    15.899     0.150
    64.867   623.592     0.150
    64.867   629.951     0.150
    68.465   653.812     0.150
    68.465  1185.411     0.150
    69.818   662.986     0.150
    69.818   663.012     0.150
    74.597   692.312     0.150
    76.343   701.921     0.150
    76.669   698.111     0.150
    76.669   706.111     0.150
    76.669   715.611     0.150
    76.669   749.111     0.150
    76.669   698.111     0.150
    76.669   715.611     0.150
    76.669   698.111     0.150
    76.669   715.611     0.150
    78.896   715.949     0.150
    78.896   715.911     0.150
    83.797   742.711     0.150
    85.890   753.711     0.150
    85.890   754.486     0.150
    85.890    14.650     0.150
    85.996   753.812     0.150
    89.085   769.812     0.150
   151.737  1186.635     0.150
   151.737  1186.611     0.150
     0.937    31.023     0.150
     2.236    35.023     0.150
     2.236    61.121     0.150
     4.103    61.223     0.150
     4.103   110.223     0.150
     4.435    66.223     0.150
     4.435   114.223     0.150
     7.291   103.824     0.150
     7.291   192.523     0.150
     7.291   192.223     0.150
     7.291   103.621     0.150
     7.291   185.746     0.150
     7.291   103.621     0.150
     7.291   185.723     0.150
    14.546   198.094     0.150
    17.841   242.246     0.150
    17.841   242.223     0.150
    20.710   272.922     0.150
    21.185   274.121     0.150
    21.185   503.223     0.150
    22.203    10.402     0.150
    22.203   521.223     0.150
    26.096   326.223     0.150
    31.185    13.000     0.150
    31.185    20.000     0.150
    37.688    12.199     0.150
    37.688    19.301     0.150
    40.088    15.301     0.150
    40.088    22.500     0.150
    40.088   543.324     0.150
    40.088   833.023     0.150
    40.428   445.324     0.150
    42.811   469.898     0.150
    42.811    15.375     0.150
    43.271   474.223     0.150
    43.572   476.523     0.150
    43.991   479.621     0.150
    43.991    17.402     0.150
    47.894   509.523     0.150
    48.277   511.742     0.150
    48.277   511.723     0.150
    49.042   518.723     0.150
    49.840    15.402     0.150
    49.840    22.203     0.150
    49.840   604.121     0.150
    49.840   640.023     0.150
    49.840   696.523     0.150
    49.840   947.621     0.150
    49.840   974.523     0.150
    53.414   550.922     0.150
    56.846   575.223     0.150
    58.234   585.918     0.150
    58.234    18.352     0.150
    58.234   585.922     0.150
    58.234    18.301     0.150
    58.889   587.523     0.150
    59.433   593.961     0.150
    59.433   593.922     0.150
    60.102   599.223     0.150
    62.763   616.531     0.150
    62.763    18.074     0.150
    62.763   616.523     0.150
    62.763    18.098     0.150
    64.718   629.199     0.150
    64.718    17.324     0.150
    64.718   629.223     0.150
    64.718    17.301     0.150
    68.570   654.621     0.150
    69.734   661.098     0.150
    69.734    16.801     0.150
    69.734   661.121     0.150
    69.734    16.801     0.150
    70.428   666.773     0.150
    70.428   686.047     0.150
    74.089   687.398     0.150
    85.485   750.172     0.150
    85.485    20.227     0.150
     0.937    28.268     0.150
     1.855    47.268     0.150
     4.554    68.768     0.150
     4.667   115.568     0.150
     9.517   230.119     0.150
    10.510   152.168     0.150
    44.420   484.168     0.150
    47.779   510.668     0.150
    48.156   513.969     0.150
    49.157   520.869     0.150
    49.157   520.869     0.150
    53.349   552.469     0.150
    64.776   630.844     0.150
    64.776   630.869     0.150
    68.458   654.268     0.150
    68.458    25.400     0.150
    68.458   905.768     0.150
    68.458  1186.969     0.150
    68.458  1453.668     0.150
    70.361   818.969     0.150
    70.361   919.668     0.150
    70.361  1218.168     0.150
    70.883   670.893     0.150
    74.440   690.994     0.150
    79.941   722.293     0.150
    82.297   734.668     0.150
    85.345   750.568     0.150
    86.006   753.869     0.150
    86.433   755.869     0.150
    86.855   757.668     0.150
     1.161    33.555     0.150
     4.557    64.250     0.150
    10.577   160.648     0.150
    10.577   167.648     0.150
    10.577   172.352     0.150
    10.577   280.648     0.150
    20.928   279.875     0.150
    21.546   284.852     0.150
    37.873   434.648     0.150
    48.720   519.094     0.150
    50.425   531.555     0.150
    53.627   555.359     0.150
    68.792   660.102     0.150
   145.388 10937.531     0.150
   145.402 10938.547     0.150
   145.404 10938.734     0.150
     1.167    34.465     0.150
     1.881    57.363     0.150
     4.538   115.965     0.150
     4.538    64.156     0.150
    33.152     9.500     0.150
    33.152    13.297     0.150
    48.688   520.566     0.150
    64.891   632.734     0.150
    77.294   708.266     0.150
    83.873   743.863     0.150
    85.591   752.965     0.150
    86.529   757.266     0.150
    86.941   759.266     0.150
   145.363 10932.707     0.150
   145.376 10933.730     0.150
   145.379 10933.777     0.150
   146.516  1154.566     0.150
     4.752    70.156     0.150
    15.101   362.035     0.150
    15.101   362.035     0.150
    49.189   521.254     0.150
    49.503   526.785     0.150
    53.463   553.707     0.150
    66.101   643.430     0.150
   145.897 10966.707     0.150
   145.910 10967.723     0.150
   145.913 10967.926     0.150
     1.843    55.395     0.150
     2.741    41.598     0.150
     2.741    73.098     0.150
     4.607    67.496     0.150
     4.607   121.996     0.150
     4.663    69.496     0.150
     4.663    69.496     0.150
     4.663   123.496     0.150
     5.369   113.496     0.150
     9.498   134.695     0.150
    10.459   150.496     0.150
    10.459   276.996     0.150
    12.556   182.457     0.150
    15.028   230.496     0.150
    15.505   219.895     0.150
    20.675   281.895     0.150
    20.675   319.395     0.150
    20.675   540.895     0.150
    21.299   274.695     0.150
    25.803   325.105     0.150
    30.248   367.297     0.150
    30.750    15.000     0.150
    30.750    20.500     0.150
    37.194    16.703     0.150
    37.194   425.895     0.150
    37.194    11.703     0.150
    37.194    16.703     0.150
    37.194   737.195     0.150
    37.194   850.098     0.150
    42.541   469.320     0.150
    42.541   469.316     0.150
    42.541   580.965     0.150
    48.347   516.227     0.150
    48.891   520.156     0.150
    48.944   520.055     0.150
    49.676   525.816     0.150
    49.953   528.574     0.150
    52.496   537.098     0.150
    53.299   552.188     0.150
    58.691   590.637     0.150
    58.691    14.910     0.150
    60.643   602.996     0.150
    62.438   627.496     0.150
    64.741   630.723     0.150
    64.741   630.715     0.150
    66.159    13.500     0.150
    68.403    31.000     0.150
    68.578   656.098     0.150
    70.307  1204.395     0.150
    77.129   706.098     0.150
    80.324   723.098     0.150
    89.067   768.297     0.150
   146.047 10961.602     0.150
   146.061 10962.617     0.150
   146.063 10962.812     0.150
   146.233 10975.465     0.150
   146.240 10976.020     0.150
   146.251 10976.828     0.150
   147.692  1194.297     0.150
     0.258    18.566     0.150
     0.963    28.766     0.150
     1.888    30.168     0.150
     2.735    41.367     0.150
     2.735    74.367     0.150
     3.333    48.969     0.150
     4.602    68.367     0.150
     4.602   121.367     0.150
     4.704    69.566     0.150
     4.704    69.566     0.150
     4.704   123.367     0.150
     4.704    69.527     0.150
     5.425    90.867     0.150
     6.858    99.367     0.150
     6.858   112.367     0.150
     7.155   103.566     0.150
     7.596   107.566     0.150
     8.246   116.867     0.150
     8.246   136.867     0.150
     8.246   211.867     0.150
     8.616   122.867     0.150
     8.616   135.867     0.150
    10.516   274.367     0.150
    10.516   146.867     0.150
    10.516   274.367     0.150
    11.016   167.367     0.150
    12.336   170.367     0.150
    13.239   184.469     0.150
    15.032   379.266     0.150
    15.032    19.000     0.150
    15.032   395.867     0.150
    15.561    14.801     0.150
    16.148    12.801     0.150
    19.557   263.566     0.150
    20.312    20.898     0.150
    20.312   483.766     0.150
    20.312   268.867     0.150
    20.312    12.898     0.150
    20.312    20.898     0.150
    20.312   483.766     0.150
    20.696   495.969     0.150
    21.349   505.469     0.150
    21.349   549.266     0.150
    21.435    21.199     0.150
    21.435   550.367     0.150
    22.781   298.117     0.150
    27.831   345.066     0.150
    30.793    14.801     0.150
    30.793    23.898     0.150
    30.793   447.969     0.150
    37.225    12.398     0.150
    37.225    19.301     0.150
    37.225   532.367     0.150
    37.225   762.066     0.150
    37.225   789.469     0.150
    37.225   949.867     0.150
    42.474   468.176     0.150
    42.596   853.969     0.150
    42.596   469.844     0.150
    42.596   582.191     0.150
    42.596   854.016     0.150
    42.596   469.836     0.150
    42.596   582.188     0.150
    42.596   807.969     0.150
    42.596   854.016     0.150
    42.969   467.867     0.150
    44.188   483.766     0.150
    47.726   509.867     0.150
    48.401   516.348     0.150
    48.938   521.086     0.150
    48.945   520.496     0.150
    49.258   522.297     0.150
    49.414   524.996     0.150
    49.730   526.066     0.150
    50.008   529.066     0.150
    52.144   982.867     0.150
    52.144  1002.867     0.150
    52.770   552.559     0.150
    53.356   551.957     0.150
    54.041   547.266     0.150
    54.217    14.281     0.150
    55.412    12.020     0.150
    56.977   589.188     0.150
    58.469   593.066     0.150
    58.469    12.000     0.150
    58.469   618.367     0.150
    58.469  1075.867     0.150
    59.683   597.867     0.150
    60.524   601.566     0.150
    63.833   761.867     0.150
    64.691  1139.668     0.150
    64.691  1391.266     0.150
    64.911     9.379     0.150
    66.126   642.777     0.150
    66.266   654.867     0.150
    68.460   657.027     0.150
    68.483   666.867     0.150
    68.483   674.867     0.150
    69.859   663.066     0.150
    70.364  1204.469     0.150
    70.364  1676.766     0.150
    71.462   829.738     0.150
    71.462  1227.809     0.150
    72.074   675.387     0.150
    73.437   689.168     0.150
    73.437   719.367     0.150
    73.901   685.766     0.150
    74.657   692.137     0.150
    75.146   694.578     0.150
    75.556   700.566     0.150
    75.556   700.605     0.150
    76.206   703.066     0.150
    76.206   703.039     0.150
    76.316   708.969     0.150
    76.316  1279.867     0.150
    76.511   705.098     0.150
    76.662   703.195     0.150
    77.184    16.398     0.150
    77.184   740.867     0.150
    77.184   706.469     0.150
    77.184   715.969     0.150
    77.188   707.566     0.150
    77.188  1291.867     0.150
    77.188  1607.867     0.150
    77.674   709.969     0.150
    78.232   713.766     0.150
    78.232   713.766     0.150
    78.232  1301.867     0.150
    78.265   714.168     0.150
    78.738    13.000     0.150
    78.738   716.367     0.150
    78.738    13.000     0.150
    78.738   716.367     0.150
    78.738    13.000     0.150
    79.484   721.168     0.150
    79.752   723.102     0.150
    80.290   721.867     0.150
    80.478   726.066     0.150
    80.977   729.066     0.150
    80.979   728.566     0.150
    81.018   728.367     0.150
    81.619   728.867     0.150
    81.659   732.668     0.150
    81.856   730.266     0.150
    82.304   735.266     0.150
    82.317   735.066     0.150
    82.492   737.996     0.150
    82.711   734.266     0.150
    83.336   743.141     0.150
    83.481   743.066     0.150
    83.879   745.070     0.150
    84.757   748.566     0.150
    85.370   751.668     0.150
    85.470   751.168     0.150
    85.986  1836.367     0.150
    86.300   754.668     0.150
    86.876   757.867     0.150
    87.802   761.969     0.150
    89.121   768.566     0.150
   123.280  1131.168     0.150
   123.398  1131.367     0.150
   123.652  1131.566     0.150
   142.596  1160.668     0.150
   146.050  1191.137     0.150
   146.050  1197.336     0.150
   146.006 10974.922     0.150
   146.020 10975.727     0.150
   146.022 10976.164     0.150
   146.191 10976.137     0.150
   146.199 10975.105     0.150
   146.210 10977.945     0.150
   156.958  1188.516     0.150
     0.786    25.891     0.150
     1.704    28.191     0.150
     2.628    40.391     0.150
     2.628    70.291     0.150
     4.492    66.991     0.150
     4.492   119.491     0.150
     4.519    66.691     0.150
     4.519   117.491     0.150
     4.519    63.531     0.150
     8.432   220.491     0.150
     8.432   121.291     0.150
     8.432   220.491     0.150
     9.644   234.191     0.150
     9.984   249.291     0.150
    10.376   146.491     0.150
    11.120   275.491     0.150
    12.903   177.191     0.150
    13.346   184.891     0.150
    14.432     4.600     0.150
    14.898   223.291     0.150
    15.321   371.891     0.150
    15.321   371.891     0.150
    17.819   237.371     0.150
    20.291   267.891     0.150
    20.291   476.391     0.150
    20.763   275.191     0.150
    20.763   281.791     0.150
    20.763   501.391     0.150
    20.763   512.291     0.150
    21.258    20.600     0.150
    21.258    35.000     0.150
    21.258   316.891     0.150
    21.774     7.300     0.150
    21.774     9.700     0.150
    23.485     9.600     0.150
    23.485    12.500     0.150
    23.485    34.400     0.150
    23.485   557.991     0.150
    28.572   345.471     0.150
    30.775    10.100     0.150
    30.775    14.200     0.150
    30.775   684.491     0.150
    30.775   369.991     0.150
    30.775    14.200     0.150
    30.775   431.491     0.150
    30.775   668.491     0.150
    30.775   770.791     0.150
    30.775   369.991     0.150
    30.775    10.100     0.150
    30.775    14.200     0.150
    30.775   431.491     0.150
    30.775   668.491     0.150
    30.775   684.491     0.150
    30.775   770.791     0.150
    32.517    10.400     0.150
    32.517    14.500     0.150
    32.517   469.991     0.150
    32.517   712.091     0.150
    33.646     9.100     0.150
    33.646    14.500     0.150
    37.258     7.300     0.150
    37.258    12.400     0.150
    37.258   425.691     0.150
    37.258   768.091     0.150
    37.258   919.091     0.150
    37.258   425.691     0.150
    37.258     7.300     0.150
    37.258    12.400     0.150
    37.258   768.091     0.150
    37.258   782.491     0.150
    37.258   919.091     0.150
    39.746     9.700     0.150
    39.746    13.700     0.150
    39.746   823.091     0.150
    40.182   450.491     0.150
    41.459   460.491     0.150
    48.031   512.101     0.150
    48.312   515.151     0.150
    48.848   518.451     0.150
    48.856   519.171     0.150
    48.891   520.411     0.150
    48.907   519.151     0.150
    49.168   521.201     0.150
    49.326   523.381     0.150
    49.494    10.900     0.150
    49.494    14.000     0.150
    49.494   694.491     0.150
    49.494   964.491     0.150
    49.494  1111.591     0.150
    49.639   524.871     0.150
    49.919   527.641     0.150
    53.214   550.691     0.150
    53.214   550.651     0.150
    55.727    17.300     0.150
    56.956   580.141     0.150
    58.554  2371.336     0.150
    58.554   589.091     0.150
    58.554    21.100     0.150
    58.554   589.081     0.150
    58.554    15.210     0.150
    58.554    21.100     0.150
    58.554  2371.341     0.150
    59.682   596.991     0.150
    60.501   601.491     0.150
    61.403   900.581     0.150
    62.326   610.791     0.150
    62.326   673.791     0.150
    62.579   615.871     0.150
    62.579    16.750     0.150
    62.579  2367.222     0.150
    63.678   651.891     0.150
    65.701  4267.892     0.150
    66.306   641.321     0.150
    66.306    20.970     0.150
    66.306  2356.741     0.150
    68.331   654.431     0.150
    68.358  1186.491     0.150
    69.499   662.151     0.150
    69.684   661.291     0.150
    70.233   817.391     0.150
    70.233   922.891     0.150
    70.233  1200.791     0.150
    70.233  1250.391     0.150
    70.233  1476.091     0.150
    70.233  1672.091     0.150
    70.924   662.901     0.150
    73.691   686.461     0.150
    74.955   692.301     0.150
    76.152   699.291     0.150
    76.152    26.800     0.150
    76.973   732.491     0.150
    77.017    27.500     0.150
    77.017   704.791     0.150
    77.017    27.500     0.150
    77.023   732.791     0.150
    78.065   710.991     0.150
    78.065   710.991     0.150
    79.099   716.491     0.150
    79.533   718.491     0.150
    79.700   719.191     0.150
    79.815   720.161     0.150
    80.142   721.991     0.150
   146.016 10959.364     0.150
   146.030 10960.382     0.150
   146.032 10960.571     0.150
   147.838  1176.791     0.150
   148.093  1176.991     0.150
     0.937    28.680     0.150
     1.863    30.277     0.150
     1.863    53.379     0.150
    25.838   324.578     0.150
    39.494   443.898     0.150
    39.494   443.879     0.150
    42.576   580.086     0.150
    42.576   469.879     0.150
    42.576   580.078     0.150
    44.456   484.480     0.150
    58.689   590.617     0.150
    59.545   596.801     0.150
    59.545   596.777     0.150
    64.770   630.879     0.150
    69.825   663.180     0.150
    69.833   663.277     0.150
    85.982   754.758     0.150
   146.017 10968.984     0.150
   146.030 10969.973     0.150
   146.033 10970.254     0.150
     0.220     7.633     0.150
     2.609    40.031     0.150
     2.609    69.133     0.150
     4.473    88.133     0.150
     4.473    68.836     0.150
     4.473   118.133     0.150
     4.798    83.133     0.150
     4.798    89.133     0.150
     4.798    70.734     0.150
     4.798   124.133     0.150
     6.897    98.781     0.150
     6.897   186.633     0.150
     6.897   187.133     0.150
     6.897   100.133     0.150
     6.897   187.133     0.150
    10.750   157.836     0.150
    14.937   338.930     0.150
    17.908   243.633     0.150
    20.579   272.633     0.150
    21.462    23.898     0.150
    21.462    37.398     0.150
    21.462   561.734     0.150
    21.501   280.836     0.150
    21.934   294.133     0.150
    26.119   329.031     0.150
    28.740   411.133     0.150
    41.533   463.430     0.150
    41.533   463.430     0.150
    43.446   477.430     0.150
    43.446   477.430     0.150
    44.388   485.430     0.150
    48.025   513.531     0.150
    49.151   522.133     0.150
    53.587   996.133     0.150
    57.253   580.734     0.150
    59.735   597.031     0.150
    64.907  1161.633     0.150
    64.984   633.633     0.150
    65.446   637.812     0.150
    70.029   665.430     0.150
    77.377   709.234     0.150
    77.377   709.234     0.150
    79.120   718.734     0.150
    83.983   744.734     0.150
    83.983   744.734     0.150
    84.517   747.430     0.150
    84.533   746.836     0.150
    84.568   747.234     0.150
    85.172   750.734     0.150
    85.329   751.234     0.150
    85.847   753.930     0.150
    86.637   758.531     0.150
    87.057   760.336     0.150
    89.302   771.133     0.150
   146.097  1186.430     0.150
     0.917    28.176     0.150
     1.827    45.977     0.150
     1.827    29.777     0.150
     1.827    45.977     0.150
     2.640    40.578     0.150
     2.640    70.477     0.150
     4.507   118.777     0.150
     4.633    98.977     0.150
     4.633    68.977     0.150
     4.633   121.977     0.150
     6.909    99.176     0.150
     6.909    98.977     0.150
     6.909   176.977     0.150
     9.560   232.625     0.150
    10.089   250.078     0.150
    10.507   151.977     0.150
    13.000   197.277     0.150
    13.333   316.125     0.150
    14.516   200.477     0.150
    17.667   239.578     0.150
    20.371   489.078     0.150
    20.381   269.375     0.150
    21.298   504.375     0.150
    21.298   545.277     0.150
    21.350   298.078     0.150
    21.807     9.199     0.150
    21.807    14.199     0.150
    21.807    25.398     0.150
    21.807   525.977     0.150
    22.687   297.277     0.150
    25.883   325.578     0.150
    30.853    18.000     0.150
    30.853    22.398     0.150
    32.609   702.777     0.150
    37.303   425.777     0.150
    39.521   444.996     0.150
    39.521   572.125     0.150
    39.856    12.301     0.150
    39.856    17.801     0.150
    41.509   461.578     0.150
    41.509   461.578     0.150
    42.617   470.176     0.150
    42.617   581.898     0.150
    43.254   477.348     0.150
    43.254   477.375     0.150
    43.561   478.078     0.150
    43.664   478.676     0.150
    43.953   481.477     0.150
    49.110   520.875     0.150
    52.133   567.875     0.150
    52.133  1004.977     0.150
    53.346   615.977     0.150
    55.677   568.977     0.150
    57.157   578.676     0.150
    57.157   707.875     0.150
    58.607   590.375     0.150
    58.607    13.453     0.150
    58.607    19.543     0.150
    59.524   596.195     0.150
    59.750   598.977     0.150
    60.617   603.277     0.150
    64.223   626.676     0.150
    64.671  1136.176     0.150
    65.479   636.977     0.150
    65.479    13.602     0.150
    68.460  1196.477     0.150
    68.460  1460.977     0.150
    68.486  1198.977     0.150
    68.578   656.176     0.150
    69.815   663.176     0.150
    69.815   663.277     0.150
    69.815    15.469     0.150
    69.815   663.277     0.150
    69.815    15.500     0.150
    70.362   828.477     0.150
    70.362   921.875     0.150
    70.362  1235.176     0.150
    70.362  1492.977     0.150
    70.362  1671.176     0.150
    75.209   695.418     0.150
    76.286   701.375     0.150
    76.342   700.977     0.150
    76.417   698.578     0.150
    77.150   706.676     0.150
    77.150   706.676     0.150
    77.156   707.176     0.150
    78.198   712.578     0.150
    78.198   712.578     0.150
    78.198   712.578     0.150
    78.891   716.578     0.150
    78.891   716.676     0.150
    78.963   717.477     0.150
    79.231   719.977     0.150
    79.668   720.875     0.150
    80.169   724.477     0.150
    80.372   724.977     0.150
    80.754   725.977     0.150
    80.979   727.676     0.150
    81.230   726.078     0.150
    81.311   729.375     0.150
    81.353   726.676     0.150
    85.133   748.047     0.150
   142.743  1166.777     0.150
   145.943 10960.613     0.150
   145.959 10961.797     0.150
   156.865  1218.578     0.150
     0.279    11.180     0.150
     1.862    55.258     0.150
     4.523    81.961     0.150
     4.523    67.258     0.150
     4.523   120.461     0.150
     4.668    88.461     0.150
     4.668    69.461     0.150
     4.668   122.461     0.150
     6.826   119.461     0.150
     6.826    99.461     0.150
     6.826   176.461     0.150
     8.579   133.359     0.150
    10.108   249.164     0.150
    10.539   273.961     0.150
    15.180   365.008     0.150
    15.181   365.008     0.150
    17.942   433.664     0.150
    18.661   247.562     0.150
    20.382   484.758     0.150
    20.382   269.859     0.150
    20.382   484.758     0.150
    20.777   280.062     0.150
    20.777   303.961     0.150
    20.777   503.164     0.150
    21.333   504.562     0.150
    21.333   521.664     0.150
    21.333   547.062     0.150
    21.804   289.961     0.150
    22.701   298.664     0.150
    23.587     5.898     0.150
    25.906   325.828     0.150
    27.976    10.898     0.150
    28.683   628.961     0.150
    28.683   350.820     0.150
    32.624    14.305     0.150
    32.624    20.102     0.150
    32.624   704.164     0.150
    33.687    13.398     0.150
    33.687    17.898     0.150
    33.687   732.359     0.150
    37.304   425.758     0.150
    37.304    13.500     0.150
    37.304    17.805     0.150
    37.304   774.961     0.150
    37.304   425.758     0.150
    37.304    13.500     0.150
    37.304    17.805     0.150
    37.304   774.961     0.150
    39.878    11.695     0.150
    39.878    15.594     0.150
    40.339   573.859     0.150
    42.641   471.164     0.150
    42.641   582.664     0.150
    42.641   852.758     0.150
    42.641   471.172     0.150
    42.641   582.609     0.150
    42.641   852.781     0.150
    43.516   472.961     0.150
    43.684   480.867     0.150
    43.976   483.062     0.150
    43.976   483.062     0.150
    44.268   485.562     0.150
    44.395   486.125     0.150
    44.395   486.164     0.150
    44.395    12.000     0.150
    44.395   586.562     0.150
    44.395   486.117     0.150
    44.395    12.047     0.150
    44.395   586.523     0.150
    45.459   498.984     0.150
    49.136   521.359     0.150
    49.136    14.000     0.150
    49.459   526.258     0.150
    49.625    10.000     0.150
    49.625    19.000     0.150
    49.625   603.062     0.150
    53.377    16.102     0.150
    53.377   740.062     0.150
    53.377  1029.961     0.150
    53.377  1332.859     0.150
    58.631   590.562     0.150
    58.631    14.797     0.150
    58.631   590.555     0.150
    58.631    14.844     0.150
    59.560   596.758     0.150
    59.757   599.461     0.150
    60.652   604.359     0.150
    62.132   615.359     0.150
    62.132   615.383     0.150
    62.449   617.664     0.150
    62.449    14.797     0.150
    63.845   646.664     0.150
    64.258   627.664     0.150
    64.794    17.227     0.150
    64.794   631.461     0.150
    64.794    17.297     0.150
    64.899   631.250     0.150
    66.158   643.359     0.150
    68.253   655.664     0.150
    68.253   655.680     0.150
    68.489   904.961     0.150
    69.585   669.328     0.150
    69.850   663.359     0.150
    69.850   663.359     0.150
    69.850   663.344     0.150
    70.392   673.461     0.150
    70.392   695.359     0.150
    70.392   828.062     0.150
    70.392  1221.859     0.150
    70.392  1238.961     0.150
    70.392  1490.859     0.150
    70.392  1669.961     0.150
    70.854   665.859     0.150
    73.436   685.359     0.150
    73.436   702.859     0.150
    74.626   715.961     0.150
    75.712   700.258     0.150
    76.320   725.859     0.150
    76.320   702.461     0.150
    76.320   707.859     0.150
    76.320    23.102     0.150
    77.140   873.164     0.150
    77.185   707.758     0.150
    77.185   717.461     0.150
    77.185    19.602     0.150
    77.185   707.758     0.150
    77.185   717.461     0.150
    77.185    19.602     0.150
    77.190   884.758     0.150
    78.232   712.859     0.150
    78.232   712.859     0.150
    78.538   715.359     0.150
    78.741   717.258     0.150
    78.741   716.258     0.150
    78.926   717.062     0.150
    78.926   716.461     0.150
    78.997   717.664     0.150
    79.490   721.359     0.150
    79.513   721.359     0.150
    79.743   722.875     0.150
    79.797   723.539     0.150
    79.928   722.391     0.150
    80.407   725.562     0.150
    81.216   730.664     0.150
    81.310   731.289     0.150
    81.346   729.961     0.150
    81.924   730.484     0.150
    82.253   734.062     0.150
    82.711   735.359     0.150
    83.270   738.234     0.150
    83.713   744.008     0.150
    83.788   744.539     0.150
    83.906   744.594     0.150
    84.101   744.742     0.150
    84.366   746.266     0.150
    84.616   738.094     0.150
    84.623   747.102     0.150
    84.886   748.031     0.150
    85.873  1413.461     0.150
    88.111   765.688     0.150
   120.101  1124.562     0.150
   120.101  1124.562     0.150
   123.196  1130.562     0.150
   124.827  1149.562     0.150
   124.827  1133.625     0.150
   124.827  1149.523     0.150
   124.827  1133.664     0.150
   124.827  1149.562     0.150
   142.754  1163.508     0.150
   142.754  1163.562     0.150
   145.934 10962.320     0.150
   145.948 10965.508     0.150
   145.950 10963.586     0.150
   147.726  1179.758     0.150
   147.726  1186.258     0.150
   147.726  1194.062     0.150
   147.726  1198.062     0.150
   147.726  1198.562     0.150
   147.726  1200.258     0.150
   147.726  1201.664     0.150
   147.726  1204.062     0.150
   147.726  1205.961     0.150
   147.978  1187.359     0.150
   147.978  1194.562     0.150
   147.978  1198.164     0.150
   147.978  1198.664     0.150
   147.978  1201.961     0.150
   147.978  1203.758     0.150
   147.978  1206.164     0.150
   148.124  1194.664     0.150
   148.124  1198.359     0.150
   148.124  1199.859     0.150
   148.124  1200.562     0.150
   148.124  1202.961     0.150
   148.124  1205.258     0.150
   148.124  1206.258     0.150
   151.765  1188.664     0.150
   151.765  1204.562     0.150
   151.765  1214.859     0.150
   154.829  1195.164     0.150
   154.829  1211.461     0.150
   156.878  1217.461     0.150
     1.888    59.611     0.150
    10.427   152.562     0.150
    43.047   482.262     0.150
    48.056   515.252     0.150
    58.796   594.701     0.150
    69.819   666.582     0.150
    76.564   704.793     0.150
    77.128   711.662     0.150
    86.115   758.082     0.150
   146.152 10966.686     0.150
   146.166 10969.240     0.150
   146.168 10967.584     0.150
     0.298    15.191     0.150
     0.749    25.292     0.150
     0.838    26.191     0.150
     2.607    39.592     0.150
     2.607    70.592     0.150
     4.473    65.592     0.150
     4.473   119.592     0.150
     4.555    67.191     0.150
     4.555   125.092     0.150
     6.959    98.592     0.150
    10.045   148.392     0.150
    10.045   151.592     0.150
    10.045   262.392     0.150
    12.199   300.892     0.150
    12.963   196.392     0.150
    20.796   277.492     0.150
    20.796   295.592     0.150
    20.796   501.992     0.150
    20.796   521.592     0.150
    21.813    11.000     0.150
    21.813    18.200     0.150
    21.813    26.000     0.150
    21.813   322.392     0.150
    22.657   297.092     0.150
    30.829    12.800     0.150
    30.829    18.000     0.150
    30.829   371.191     0.150
    30.829    12.601     0.150
    30.829    17.801     0.150
    30.829   432.691     0.150
    33.688    11.500     0.150
    33.688    18.500     0.150
    37.301   425.392     0.150
    37.301   425.392     0.150
    39.808    12.000     0.150
    39.808    17.500     0.150
    42.562   468.792     0.150
    43.903   482.392     0.150
    43.903   482.392     0.150
    44.274   484.392     0.150
    44.322   483.592     0.150
    48.043   513.754     0.150
    49.054   520.592     0.150
    49.054   520.521     0.150
    55.598   571.592     0.150
    57.089   577.352     0.150
    58.554   590.691     0.150
    59.445   597.941     0.150
    59.445   597.992     0.150
    61.858   611.792     0.150
    62.554   616.792     0.150
    64.682   631.892     0.150
    64.682   631.892     0.150
    65.441   637.392     0.150
    68.394   810.892     0.150
    68.666   655.611     0.150
    69.736   662.992     0.150
    69.736   663.012     0.150
    70.850   671.691     0.150
    70.850   671.691     0.150
    73.928   689.361     0.150
    74.411   694.072     0.150
    76.256   703.002     0.150
    76.256   702.992     0.150
    76.588   705.292     0.150
    76.588   705.292     0.150
    77.073   707.092     0.150
    77.073   707.092     0.150
    77.073    18.500     0.150
    77.073   707.092     0.150
    77.073    18.500     0.150
    78.630   713.802     0.150
    78.630   716.392     0.150
    78.630   716.392     0.150
    78.815   716.392     0.150
    79.051   719.892     0.150
    79.051   719.892     0.150
    79.831   721.812     0.150
    84.205   744.191     0.150
    84.214   744.292     0.150
    85.026   747.691     0.150
    85.086   748.292     0.150
    85.509   749.992     0.150
    86.161   752.992     0.150
    86.338   754.691     0.150
    89.003   766.691     0.150
   145.963 10964.082     0.150
   145.977 10963.529     0.150
   145.979 10972.457     0.150
   146.247  1170.092     0.150
   146.247  1172.492     0.150
   148.221  1181.492     0.150
   151.675  1190.242     0.150
   151.675  1190.292     0.150
   154.875  1211.292     0.150
     0.992    30.594     0.150
     2.858    57.992     0.150
     2.858    43.094     0.150
     2.858    75.195     0.150
     4.724    59.492     0.150
     4.724   119.492     0.150
     4.761    66.648     0.150
     6.701   177.594     0.150
    23.420    20.102     0.150
    23.420    33.195     0.150
    23.420   543.594     0.150
    28.280   633.891     0.150
    29.260   351.203     0.150
    39.468   444.391     0.150
    42.528   469.391     0.150
    42.528   469.430     0.150
    48.060   513.273     0.150
    48.822   520.289     0.150
    48.879   547.930     0.150
    49.311   522.594     0.150
    53.325   740.094     0.150
    53.325   987.789     0.150
    53.325   552.195     0.150
    59.041   591.094     0.150
    59.041   591.094     0.150
    59.587   596.094     0.150
    64.261   626.695     0.150
    64.797   631.195     0.150
    69.872   663.195     0.150
    69.872   663.164     0.150
    70.322   669.594     0.150
    70.322   918.695     0.150
    70.322  1673.891     0.150
    70.924   669.891     0.150
    76.284   702.391     0.150
    77.183   705.492     0.150
    78.917   716.195     0.150
   146.000  1167.289     0.150
   146.000  1170.492     0.150
   146.117 10964.414     0.150
   146.130 10965.695     0.150
   146.132 10965.688     0.150
     0.935    28.182     0.150
     1.329    41.481     0.150
     1.848    45.857     0.150
     1.848    29.081     0.150
     1.848    45.881     0.150
     2.661    40.781     0.150
     2.661    70.781     0.150
     3.399    49.781     0.150
     4.528    66.781     0.150
     4.528   119.281     0.150
     4.655    69.081     0.150
     4.655    69.081     0.150
     4.655   119.281     0.150
     8.291   210.281     0.150
     9.536   231.572     0.150
    10.088   146.781     0.150
    10.088   257.682     0.150
    12.262   398.281     0.150
    12.998   196.281     0.150
    14.510   366.981     0.150
    15.191   365.229     0.150
    15.191   365.229     0.150
    16.647   407.281     0.150
    21.317   502.781     0.150
    21.791    11.199     0.150
    21.791    16.899     0.150
    21.791    26.000     0.150
    23.568    11.200     0.150
    23.568    17.700     0.150
    23.568    33.800     0.150
    23.568   569.381     0.150
    30.845    12.300     0.150
    30.845    17.300     0.150
    30.845   665.480     0.150
    32.605    13.200     0.150
    32.605    20.700     0.150
    33.290   478.081     0.150
    33.290   711.682     0.150
    33.673    11.200     0.150
    33.673    19.301     0.150
    33.673   720.082     0.150
    37.290   507.381     0.150
    39.857   541.781     0.150
    42.621   469.981     0.150
    42.621   581.581     0.150
    44.256   484.381     0.150
    47.868   511.381     0.150
    49.604    12.500     0.150
    49.604    17.500     0.150
    49.604   970.281     0.150
    51.812   543.501     0.150
    53.357   624.481     0.150
    53.357   677.881     0.150
    53.357   996.082     0.150
    57.029   577.621     0.150
    57.209   572.281     0.150
    58.631   590.182     0.150
    58.631   590.222     0.150
    58.631    13.960     0.150
    58.997   591.481     0.150
    59.542   596.081     0.150
    59.740   598.281     0.150
    62.458   616.581     0.150
    62.458    15.900     0.150
    64.239   625.581     0.150
    64.239   625.581     0.150
    64.684   630.271     0.150
    64.776   630.881     0.150
    65.500   637.081     0.150
    65.500   637.171     0.150
    66.166   642.981     0.150
    68.899   653.281     0.150
    69.568   665.162     0.150
    69.833   663.082     0.150
    69.833   663.082     0.150
    70.371   919.082     0.150
    70.371  1209.082     0.150
    70.371  1235.381     0.150
    70.371  1664.781     0.150
    70.937   669.881     0.150
    71.157   670.980     0.150
    72.046   676.381     0.150
    73.829   688.932     0.150
    74.030   688.980     0.150
    74.029   692.480     0.150
    74.214   689.881     0.150
    74.606   692.980     0.150
    75.386   697.082     0.150
    75.793   698.480     0.150
    76.146   701.881     0.150
    76.301   702.381     0.150
    76.333   866.432     0.150
    77.118   707.012     0.150
    77.166   706.480     0.150
    77.166    23.000     0.150
    77.166   706.480     0.150
    77.166    23.000     0.150
    77.171   706.980     0.150
    77.659   709.781     0.150
    77.659   732.781     0.150
    78.214   712.480     0.150
    78.214   712.480     0.150
    78.214   712.480     0.150
    78.907   716.480     0.150
    78.907   716.480     0.150
    78.978   717.281     0.150
    78.978    22.600     0.150
    79.381   717.871     0.150
    79.677   708.281     0.150
    79.862   720.932     0.150
    80.388   724.781     0.150
    80.422   725.881     0.150
    80.938   723.521     0.150
    80.986   729.111     0.150
    81.249   727.182     0.150
    81.249   729.182     0.150
    81.327   729.381     0.150
    81.372   728.082     0.150
    81.372   729.881     0.150
    82.067   734.582     0.150
    82.513   736.781     0.150
    91.208   781.742     0.150
    93.101   786.842     0.150
   123.176  1130.182     0.150
   124.829  1133.045     0.150
   124.829  1133.082     0.150
   145.951 10948.137     0.150
   145.965 10949.148     0.150
   145.967 10949.744     0.150
   146.157  1169.281     0.150
   146.157  1172.182     0.150
   147.732  1179.281     0.150
   147.985  1179.682     0.150
   148.130  1180.480     0.150
   148.130  1180.480     0.150
   151.762  1213.371     0.150
   156.885  1187.881     0.150
   156.885  1219.281     0.150
     0.949    28.297     0.150
     1.859    43.891     0.150
     1.859    29.797     0.150
     1.859    43.891     0.150
     2.655    39.992     0.150
     2.655    70.594     0.150
     3.396    49.695     0.150
     4.522    65.094     0.150
     4.522    65.094     0.150
     4.522   117.594     0.150
     4.665    89.594     0.150
     4.665    68.992     0.150
     4.665   122.594     0.150
     6.823    95.594     0.150
     6.823    95.594     0.150
     6.823    95.594     0.150
     6.823   173.594     0.150
     8.576   119.594     0.150
     8.576   119.594     0.150
     8.576   222.594     0.150
    10.106   158.992     0.150
    10.983   148.594     0.150
    12.258   187.094     0.150
    12.258   173.492     0.150
    12.664   184.016     0.150
    13.015   190.297     0.150
    14.526   217.992     0.150
    15.183   365.344     0.150
    15.184   365.344     0.150
    15.570    22.398     0.150
    16.662    18.703     0.150
    20.380    18.000     0.150
    20.380   497.492     0.150
    21.330    20.203     0.150
    21.330   520.391     0.150
    21.379   505.094     0.150
    21.379   539.492     0.150
    21.803    11.797     0.150
    21.803    17.203     0.150
    21.803    26.602     0.150
    22.700   298.094     0.150
    23.585    12.500     0.150
    23.585    16.797     0.150
    23.585    34.398     0.150
    23.585   525.695     0.150
    23.585   557.695     0.150
    23.585   578.094     0.150
    23.585   736.094     0.150
    25.826   594.594     0.150
    30.862    12.898     0.150
    30.862   665.594     0.150
    31.302   667.797     0.150
    32.622    12.000     0.150
    33.686    12.695     0.150
    33.686   474.094     0.150
    33.686   708.695     0.150
    33.686   837.391     0.150
    36.476    18.797     0.150
    39.875    17.602     0.150
    42.030   456.594     0.150
    42.639   470.195     0.150
    42.639   581.492     0.150
    43.894   480.000     0.150
    44.268   484.594     0.150
    44.268   588.195     0.150
    44.394   483.594     0.150
    45.044   483.594     0.150
    49.134   520.992     0.150
    49.304   521.188     0.150
    49.622    11.297     0.150
    49.622    18.703     0.150
    49.622   697.094     0.150
    49.622  1105.594     0.150
    51.829   546.453     0.150
    52.161   623.594     0.150
    52.161  1001.594     0.150
    52.606   545.594     0.150
    53.374   582.391     0.150
    53.374   675.195     0.150
    53.374   550.836     0.150
    53.374    16.156     0.150
    53.374   572.906     0.150
    58.630   590.594     0.150
    58.630    13.703     0.150
    58.630   590.633     0.150
    58.630    13.648     0.150
    59.556   595.797     0.150
    59.756   598.594     0.150
    61.179   605.938     0.150
    62.452   616.594     0.150
    63.841  1389.492     0.150
    64.254   626.391     0.150
    64.791   630.992     0.150
    64.896   630.336     0.150
    65.541   658.594     0.150
    66.732    16.633     0.150
    66.732    16.789     0.150
    67.605   651.594     0.150
    68.392   664.281     0.150
    68.599   664.664     0.150
    68.915   655.594     0.150
    69.813    11.828     0.150
    69.847   663.195     0.150
    69.847   663.195     0.150
    69.847    16.102     0.150
    70.389   691.695     0.150
    70.389  1233.297     0.150
    70.389  1251.094     0.150
    70.389  1480.297     0.150
    70.389  1667.594     0.150
    70.851   667.992     0.150
    70.851    27.602     0.150
    70.953   670.094     0.150
    71.173   671.094     0.150
    71.846   674.586     0.150
    73.361   685.391     0.150
    73.718   687.344     0.150
    73.751  1305.594     0.150
    74.046   688.891     0.150
    74.622   693.094     0.150
    74.702   693.531     0.150
    75.402   697.094     0.150
    76.219   701.891     0.150
    76.350   702.797     0.150
    76.350   875.195     0.150
    76.359   731.438     0.150
    77.182   711.492     0.150
    77.182   706.797     0.150
    77.182    21.797     0.150
    77.182   706.797     0.150
    77.182    21.797     0.150
    77.187   707.195     0.150
    77.674   710.195     0.150
    78.229   712.797     0.150
    78.229   712.797     0.150
    78.229   712.797     0.150
    78.738   715.992     0.150
    78.922   716.891     0.150
    78.922   716.695     0.150
    78.994   717.492     0.150
    79.487   719.594     0.150
    79.853    17.852     0.150
    80.403   725.297     0.150
    81.262   727.797     0.150
    81.299   728.883     0.150
    81.342   729.594     0.150
    81.385   728.492     0.150
    85.876  1733.797     0.150
    86.293   754.391     0.150
   123.193  1129.766     0.150
   124.829  1133.195     0.150
   124.829  1148.391     0.150
   124.829  1147.836     0.150
   139.530  1154.195     0.150
   142.754  1165.297     0.150
   142.754  1165.273     0.150
   145.936 10953.945     0.150
   145.949 10963.820     0.150
   145.951 10958.695     0.150
   146.154  1179.195     0.150
   146.154  1185.992     0.150
   146.154  1189.492     0.150
   146.154  1192.891     0.150
   147.728  1190.391     0.150
   147.728  1196.391     0.150
   147.728  1202.492     0.150
   147.981  1197.797     0.150
   147.981  1202.594     0.150
   148.127  1191.391     0.150
   148.127  1199.297     0.150
   151.763  1182.594     0.150
   151.764  1203.961     0.150
   151.764  1217.570     0.150
   151.764  1231.484     0.150
   156.877  1219.195     0.150
     1.857    54.688     0.150
     2.697    40.594     0.150
     2.697    71.891     0.150
     3.372    49.188     0.150
     4.564    64.891     0.150
     4.564    64.891     0.150
     4.564    64.891     0.150
     4.564   119.188     0.150
     4.670    68.594     0.150
     4.670   121.891     0.150
     6.826    94.891     0.150
     6.826    94.891     0.150
     6.826   168.391     0.150
     6.853   180.594     0.150
     6.853    97.891     0.150
     6.853   180.891     0.150
     8.260   217.891     0.150
     8.260   118.891     0.150
     8.582   119.891     0.150
     8.582   222.891     0.150
     8.582   119.891     0.150
     9.511   231.242     0.150
    10.061   258.391     0.150
    10.506   145.094     0.150
    11.270   242.688     0.150
    12.297   168.492     0.150
    12.739   174.789     0.150
    12.968   315.188     0.150
    15.173   205.891     0.150
    15.173   363.039     0.150
    15.173   205.891     0.150
    15.173   363.039     0.150
    15.554   210.391     0.150
    16.132   219.891     0.150
    16.612   414.188     0.150
    18.637   250.688     0.150
    20.331    12.297     0.150
    20.331   268.391     0.150
    20.331    12.203     0.150
    20.331    17.797     0.150
    20.331   498.094     0.150
    21.397    24.703     0.150
    21.397   314.789     0.150
    21.754   282.391     0.150
    21.754    31.500     0.150
    22.744   297.094     0.150
    22.744   544.992     0.150
    23.537    14.297     0.150
    23.537    21.797     0.150
    23.537    32.797     0.150
    23.537   568.688     0.150
    25.776   578.891     0.150
    26.580    19.203     0.150
    27.828   387.094     0.150
    27.924    18.203     0.150
    27.924   627.391     0.150
    28.170   620.789     0.150
    30.812   370.391     0.150
    30.812     8.000     0.150
    30.812    12.797     0.150
    30.812   429.094     0.150
    30.812   667.891     0.150
    30.812   680.891     0.150
    32.575    19.000     0.150
    32.575   474.891     0.150
    32.575   726.188     0.150
    33.636   834.188     0.150
    33.974   398.492     0.150
    37.253    17.500     0.150
    37.253    25.703     0.150
    37.253   762.891     0.150
    37.253   942.891     0.150
    37.253   426.094     0.150
    37.253    17.500     0.150
    37.253    25.695     0.150
    37.253   762.789     0.150
    37.253   942.891     0.150
    39.512   569.117     0.150
    39.512   444.094     0.150
    39.512   569.109     0.150
    39.832    21.203     0.150
    40.303   471.188     0.150
    43.213    11.000     0.150
    43.213    17.500     0.150
    43.213   608.891     0.150
    43.213   847.891     0.150
    43.313   478.719     0.150
    44.009   481.094     0.150
    44.218   484.094     0.150
    44.429   483.992     0.150
    44.930   890.891     0.150
    46.376    18.000     0.150
    49.099   959.891     0.150
    49.165   521.094     0.150
    49.578     9.703     0.150
    49.578    19.703     0.150
    51.578   555.188     0.150
    52.133   541.891     0.150
    52.133   566.891     0.150
    52.732  1196.688     0.150
    53.178   555.789     0.150
    53.345   989.891     0.150
    53.345  1327.688     0.150
    54.056  1006.891     0.150
    58.818   601.688     0.150
    59.000   591.789     0.150
    59.545   596.289     0.150
    59.706  1110.891     0.150
    60.653   603.492     0.150
    61.170   605.633     0.150
    61.170   605.633     0.150
    61.245  1779.891     0.150
    61.950   610.789     0.150
    62.130    14.320     0.150
    62.196   615.531     0.150
    62.426   631.391     0.150
    63.043   612.922     0.150
    63.043   617.320     0.150
    63.817  1139.188     0.150
    64.238   624.891     0.150
    64.238   624.891     0.150
    64.337    24.398     0.150
    64.337   779.492     0.150
    64.774   630.594     0.150
    64.886   630.500     0.150
    66.164   921.789     0.150
    66.585   641.891     0.150
    67.015   646.492     0.150
    67.574   652.562     0.150
    67.587   657.234     0.150
    68.453   688.594     0.150
    68.453   656.109     0.150
    69.614   663.289     0.150
    69.611   662.078     0.150
    69.827   662.391     0.150
    69.835   663.188     0.150
    69.835   662.891     0.150
    69.835   662.859     0.150
    70.357   918.492     0.150
    70.929   669.891     0.150
    70.893   671.562     0.150
    71.152  1213.094     0.150
    71.152   671.094     0.150
    71.152    14.398     0.150
    71.152   692.188     0.150
    71.152    29.797     0.150
    71.152  1213.094     0.150
    71.152  1258.492     0.150
    71.377   672.594     0.150
    73.341    30.703     0.150
    73.341  1233.688     0.150
    73.416  1307.992     0.150
    73.416   684.789     0.150
    73.416  1307.992     0.150
    73.724  1240.891     0.150
    73.724  1294.891     0.150
    73.724  1312.891     0.150
    73.804   686.789     0.150
    73.804  1184.594     0.150
    73.761   689.367     0.150
    74.027    18.898     0.150
    74.027  1244.094     0.150
    74.027   688.789     0.150
    74.027    15.203     0.150
    74.027    18.898     0.150
    74.027   717.789     0.150
    74.027  1244.094     0.150
    74.215   689.688     0.150
    74.215  1260.492     0.150
    74.600   692.789     0.150
    74.600    15.602     0.150
    74.600    22.000     0.150
    74.600   721.289     0.150
    74.600  1281.594     0.150
    76.192   701.992     0.150
    76.297    18.906     0.150
    76.297   868.391     0.150
    76.297  1280.891     0.150
    76.297   702.188     0.150
    76.297    18.500     0.150
    76.297    29.406     0.150
    76.297   867.492     0.150
    76.297  1292.688     0.150
    76.318   702.789     0.150
    76.318   869.492     0.150
    76.352   702.594     0.150
    76.352   709.688     0.150
    76.352    22.094     0.150
    76.352  1282.094     0.150
    76.352   702.594     0.150
    76.676   727.289     0.150
    76.676   704.891     0.150
    76.676   727.289     0.150
    76.676  1286.391     0.150
    76.676  1680.289     0.150
    76.676  1873.289     0.150
    77.115   747.688     0.150
    77.115   764.094     0.150
    77.164   713.188     0.150
    77.164   706.594     0.150
    77.164   713.188     0.150
    77.164    22.094     0.150
    77.164   743.891     0.150
    77.164  1286.891     0.150
    77.164  1313.891     0.150
    77.164   706.594     0.150
    77.164   713.188     0.150
    77.164    22.094     0.150
    77.169   729.492     0.150
    77.169   706.688     0.150
    77.169   729.492     0.150
    77.169  1291.891     0.150
    77.169  1585.891     0.150
    77.211   729.789     0.150
    77.211  1300.289     0.150
    77.655   731.992     0.150
    77.655   709.594     0.150
    77.655   731.992     0.150
    77.655   751.094     0.150
    77.655  1295.688     0.150
    77.655  1696.391     0.150
    78.212   712.594     0.150
    78.212   712.594     0.150
    78.212    20.297     0.150
    78.212  1302.891     0.150
    78.212   712.594     0.150
    78.212    20.297     0.150
    78.212  1302.891     0.150
    78.245   735.391     0.150
    78.245  1305.789     0.150
    78.245   712.789     0.150
    78.245   735.391     0.150
    78.245  1305.789     0.150
    78.245  1693.992     0.150
    78.245  1886.094     0.150
    78.515   714.891     0.150
    78.515    15.797     0.150
    78.593   714.992     0.150
    78.719   715.891     0.150
    78.719   725.289     0.150
    78.719    21.602     0.150
    78.719  1308.094     0.150
    78.719  1711.594     0.150
    78.719  1913.188     0.150
    78.903   716.492     0.150
    78.903   716.289     0.150
    79.466   719.094     0.150
    80.066  1298.922     0.150
    80.066  1698.969     0.150
    80.385   724.891     0.150
    80.779   724.891     0.150
    80.779   726.789     0.150
    80.779     3.305     0.150
    81.254   729.289     0.150
    81.271   728.578     0.150
    81.325   729.492     0.150
    81.378   730.094     0.150
    81.996   732.828     0.150
    82.063   733.859     0.150
    85.079   691.062     0.150
    85.085   750.492     0.150
    85.188   765.891     0.150
    85.391   751.992     0.150
    85.475   749.859     0.150
    85.950   753.844     0.150
    85.950  1834.961     0.150
    89.730   772.297     0.150
   102.420   830.094     0.150
   102.420   830.172     0.150
   120.100  1122.289     0.150
   124.799  1132.688     0.150
   142.799  1164.891     0.150
   145.985 10970.773     0.150
   145.999 10971.547     0.150
   146.001 10969.578     0.150
   146.131  1173.891     0.150
   147.706  1185.789     0.150
   147.706  1181.391     0.150
   147.960  1181.188     0.150
   148.104  1182.594     0.150
   151.790  1206.062     0.150
   156.922  1188.789     0.150
   156.922  1188.812     0.150
     0.927    27.512     0.150
     2.645    41.211     0.150
     2.645    71.812     0.150
     4.512    66.312     0.150
     6.902    97.711     0.150
    17.919   243.613     0.150
    20.384   270.051     0.150
    21.307   279.434     0.150
    25.889   325.863     0.150
    28.662   350.082     0.150
    43.877   479.992     0.150
    47.789   510.664     0.150
    53.354   543.312     0.150
     0.884    28.316     0.150
     1.815    29.866     0.150
     1.815    49.417     0.150
     2.730    41.517     0.150
     2.730    71.517     0.150
     4.596    67.017     0.150
     4.596   119.017     0.150
     4.636    59.217     0.150
     6.839    99.017     0.150
     6.839   178.017     0.150
     9.521   230.814     0.150
     9.984   138.616     0.150
     9.984   247.316     0.150
     9.984   924.816     0.150
    12.892   202.217     0.150
    14.854   202.517     0.150
    17.575   239.696     0.150
    20.270   267.616     0.150
    21.271   298.017     0.150
    23.463    14.700     0.150
    23.463    36.100     0.150
    32.500    17.900     0.150
    32.500    25.200     0.150
    32.500   727.217     0.150
    32.500   766.116     0.150
    32.500  1003.816     0.150
    37.193   424.017     0.150
    39.437   444.066     0.150
    39.437   571.116     0.150
    39.755    27.400     0.150
    40.228    21.399     0.150
    41.577   461.167     0.150
    43.142   475.807     0.150
    44.162   483.517     0.150
    44.443   484.173     0.150
    47.700   509.257     0.150
    49.171   520.727     0.150
    49.185   520.217     0.150
    49.185   520.247     0.150
    58.944   589.417     0.150
    58.944   589.417     0.150
    61.888   608.417     0.150
    62.457   616.690     0.150
    64.177   625.316     0.150
    64.608   670.116     0.150
    64.713   630.417     0.150
    68.379   655.717     0.150
    69.778   662.616     0.150
    69.778   662.592     0.150
    70.170   665.977     0.150
    70.283  1250.616     0.150
    70.283  1670.116     0.150
    70.860   669.172     0.150
    73.049   684.307     0.150
    76.244   702.017     0.150
    77.102   706.116     0.150
    77.102   706.116     0.150
    77.106   706.316     0.150
    78.149   712.017     0.150
    78.839   716.255     0.150
    79.079   717.616     0.150
    79.079   717.616     0.150
    79.938   721.687     0.150
    81.565   730.316     0.150
    82.222   733.917     0.150
    83.524   741.017     0.150
    84.016   742.816     0.150
    84.234   744.616     0.150
    84.243   744.816     0.150
    84.304   744.616     0.150
    84.896   748.116     0.150
    85.122   748.816     0.150
    85.387   749.616     0.150
    85.540   751.017     0.150
    86.372   755.816     0.150
    89.039   768.717     0.150
   123.098  1129.042     0.150
   146.055 10962.860     0.150
   146.069 10966.237     0.150
   146.071 10964.050     0.150
   146.139  1178.717     0.150
   147.715  1180.116     0.150
   147.715  1181.316     0.150
   147.970  1181.316     0.150
   147.970  1182.717     0.150
   151.788  1188.297     0.150
     0.957    28.742     0.150
     1.878    30.340     0.150
     1.878    54.441     0.150
     2.714    37.242     0.150
    21.343   280.090     0.150
    25.868   325.582     0.150
    43.867   479.652     0.150
    47.787   510.621     0.150
    49.185   522.590     0.150
    49.269   521.602     0.150
    59.019   590.840     0.150
   145.988 10962.309     0.150
   146.002 10963.207     0.150
   146.004 10966.418     0.150
     2.574    64.844     0.150
     7.011    98.914     0.150
     7.011   100.047     0.150
     7.011   183.047     0.150
    17.555   237.750     0.150
    17.771   433.047     0.150
    20.325   270.344     0.150
    20.336   270.328     0.150
    20.813   276.047     0.150
    21.210   294.547     0.150
    21.822    20.602     0.150
    21.822    30.102     0.150
    21.822   518.047     0.150
    23.516    34.000     0.150
    23.867   301.047     0.150
    43.214   475.789     0.150
    44.282   485.547     0.150
    47.654   508.250     0.150
    48.581   516.945     0.150
    48.606   516.648     0.150
    48.998   519.398     0.150
    49.183   519.648     0.150
    57.022   577.266     0.150
    64.070   625.344     0.150
    68.332  1641.648     0.150
    69.660   661.344     0.150
    72.999   684.398     0.150
    76.999   706.844     0.150
    85.835   753.367     0.150
   145.980 10962.914     0.150
   145.993 10964.719     0.150
   145.995 10963.305     0.150
     0.902    28.117     0.150
     1.823    45.719     0.150
     1.823    29.922     0.150
     1.823    45.719     0.150
     2.688    53.719     0.150
     2.688    40.422     0.150
     2.688    70.922     0.150
     4.554    66.219     0.150
     4.554   118.422     0.150
     6.792   108.719     0.150
     6.871    98.617     0.150
     6.871   186.922     0.150
     6.871   190.219     0.150
     6.871    98.219     0.150
     6.871   190.219     0.150
     8.550   120.219     0.150
    10.037   148.320     0.150
    14.460   381.820     0.150
    17.622   239.516     0.150
    19.609   262.867     0.150
    21.287    19.203     0.150
    21.369   290.820     0.150
    21.369   557.617     0.150
    22.126   309.820     0.150
    22.737    13.625     0.150
    22.737   297.617     0.150
    23.518    12.000     0.150
    23.518    32.398     0.150
    26.278   329.336     0.150
    32.554    18.102     0.150
    32.554    25.102     0.150
    32.554   684.719     0.150
    39.806    15.000     0.150
    39.806    23.000     0.150
    39.806   540.219     0.150
    41.547   461.117     0.150
    42.570   469.641     0.150
    42.570   580.742     0.150
    42.755   469.219     0.150
    43.198    21.461     0.150
    43.198   476.320     0.150
    43.827   479.422     0.150
    43.827   585.117     0.150
    48.119   513.422     0.150
    48.119   600.719     0.150
    48.569   517.820     0.150
    48.593   517.516     0.150
    49.144   520.516     0.150
    49.235   520.938     0.150
    49.235   520.922     0.150
    49.553   637.516     0.150
    49.553   944.516     0.150
    49.553  1150.516     0.150
    53.312   552.320     0.150
    53.312   618.617     0.150
    58.644   590.320     0.150
    58.644    14.000     0.150
    58.964   591.820     0.150
    60.464   603.477     0.150
    61.135   609.828     0.150
    61.135   609.828     0.150
    64.203   626.422     0.150
    64.739   630.742     0.150
    64.850   630.086     0.150
    69.799   662.922     0.150
    69.799   662.922     0.150
    70.130   666.617     0.150
    70.787   656.922     0.150
    70.787    12.594     0.150
    70.787    34.195     0.150
    73.381   683.922     0.150
    73.992   688.617     0.150
    74.512   693.117     0.150
    74.512    15.398     0.150
    75.907   698.219     0.150
    76.390    17.594     0.150
    76.609   703.719     0.150
    77.129   706.320     0.150
    77.129   735.219     0.150
    77.129   750.219     0.150
    77.129   706.320     0.150
    77.133   706.617     0.150
    77.648   710.219     0.150
    78.176   712.422     0.150
    78.176   712.422     0.150
    78.940   717.016     0.150
    79.106   717.922     0.150
    79.648   720.820     0.150
    80.350   724.516     0.150
    80.923   727.719     0.150
    80.959   728.219     0.150
    80.961   727.117     0.150
    81.095   728.719     0.150
    81.158   729.016     0.150
    81.195   728.422     0.150
    81.219   728.422     0.150
    81.290   729.016     0.150
    81.342   727.516     0.150
    81.591   730.922     0.150
    82.247   733.820     0.150
    82.261   734.117     0.150
    83.550   741.016     0.150
    83.742   741.820     0.150
    83.778   741.820     0.150
    84.040   743.422     0.150
    84.224   744.320     0.150
    84.261   745.219     0.150
    84.270   745.422     0.150
    84.292   744.719     0.150
    84.328   745.016     0.150
    84.700   746.820     0.150
    84.833   747.719     0.150
    84.923   747.922     0.150
    84.958   748.617     0.150
    85.146   749.320     0.150
    85.310   750.016     0.150
    85.415   749.922     0.150
    85.566   751.617     0.150
    85.613   751.922     0.150
    85.970   752.719     0.150
    86.216   754.320     0.150
    86.242   755.016     0.150
    86.397   756.320     0.150
    86.819   758.219     0.150
    87.745   762.617     0.150
    88.651   766.422     0.150
    89.063   769.219     0.150
   123.133  1129.641     0.150
   146.000 10963.711     0.150
   146.013 10966.898     0.150
   146.016 10963.562     0.150
   146.156  1184.719     0.150
   146.156  1189.719     0.150
   146.156  1197.820     0.150
   147.732  1185.719     0.150
   147.732  1193.820     0.150
   147.732  1202.617     0.150
   147.732  1211.422     0.150
   147.732  1216.617     0.150
   147.732  1223.219     0.150
   147.986  1195.016     0.150
   147.986  1206.516     0.150
   147.986  1212.719     0.150
   147.986  1220.117     0.150
   148.130  1193.719     0.150
   148.130  1197.117     0.150
     0.935    28.410     0.150
     1.841    55.512     0.150
     2.634    40.711     0.150
     2.634    72.012     0.150
     4.645    70.109     0.150
     4.645   123.410     0.150
     6.910    97.750     0.150
     6.910    99.012     0.150
     6.910   179.609     0.150
     9.556   232.414     0.150
    10.964   150.711     0.150
    17.917   430.109     0.150
    20.795   281.309     0.150
    21.357   299.012     0.150
    21.820   292.711     0.150
    26.347   330.309     0.150
    39.542   444.711     0.150
    39.542   571.809     0.150
    39.542   444.699     0.150
    39.542   571.832     0.150
    42.638   469.910     0.150
    42.638   581.309     0.150
    43.273   477.172     0.150
    43.559   478.672     0.150
    43.952   481.859     0.150
    44.371   484.309     0.150
    44.371    13.301     0.150
    48.129   513.809     0.150
    48.129   601.012     0.150
    48.180   514.012     0.150
    48.180   601.109     0.150
    48.645   518.211     0.150
    48.669   518.211     0.150
    48.947   519.961     0.150
    48.947   603.301     0.150
    49.111   521.109     0.150
    53.366   743.109     0.150
    53.366   991.309     0.150
    53.366  1325.711     0.150
    53.366   552.609     0.150
    56.217   573.309     0.150
    58.607   590.309     0.150
    58.607    13.902     0.150
    59.541   595.809     0.150
    59.541   595.832     0.150
    61.954   612.512     0.150
    62.474   616.809     0.150
    62.474    14.602     0.150
    64.241   627.109     0.150
    64.691   659.109     0.150
    64.778   631.012     0.150
    66.201   642.211     0.150
    66.201    14.598     0.150
    69.832   663.211     0.150
    70.943   670.109     0.150
    76.344   702.809     0.150
    76.436   699.711     0.150
    77.169   706.910     0.150
    78.725    18.199     0.150
    78.910   716.910     0.150
    83.811   741.012     0.150
    84.301   744.711     0.150
    84.736   745.609     0.150
    85.182   748.809     0.150
    85.647   751.211     0.150
     0.177     8.758     0.150
     0.872    28.453     0.150
     0.918    29.055     0.150
     1.846    30.055     0.150
     2.728    42.156     0.150
     2.728    73.055     0.150
     4.594    65.656     0.150
     4.594    65.656     0.150
     4.594   119.656     0.150
     4.664    70.359     0.150
     4.664    70.359     0.150
     4.664   122.156     0.150
     6.832    97.656     0.150
     6.832    97.156     0.150
     6.832   177.156     0.150
    10.018   164.156     0.150
    10.018   272.055     0.150
    10.471   144.453     0.150
    10.471   274.156     0.150
    12.924   202.953     0.150
    14.433   198.453     0.150
    14.433   211.555     0.150
    14.433   217.156     0.150
    14.433    10.398     0.150
    17.611   240.555     0.150
    17.963   243.258     0.150
    18.610   248.656     0.150
    20.286    16.297     0.150
    20.286    26.695     0.150
    20.297   268.758     0.150
    20.691    16.203     0.150
    20.691    25.500     0.150
    21.305    18.602     0.150
    21.305   518.859     0.150
    21.402   313.359     0.150
    21.714    16.500     0.150
    21.714    28.305     0.150
    21.714   514.156     0.150
    22.119   308.758     0.150
    22.119   324.758     0.150
    22.776   298.055     0.150
    23.492    17.102     0.150
    23.492    26.500     0.150
    23.492    35.203     0.150
    23.492   577.453     0.150
    25.819   323.953     0.150
    26.263   329.359     0.150
    26.263   534.953     0.150
    28.713   350.055     0.150
    32.530    17.695     0.150
    32.530    27.000     0.150
    32.530   475.953     0.150
    32.530   727.156     0.150
    32.530   764.156     0.150
    32.530   772.953     0.150
    32.530  1003.453     0.150
    33.212    18.000     0.150
    33.212    27.102     0.150
    33.595    17.898     0.150
    33.595    27.000     0.150
    33.595   708.156     0.150
    37.212    18.000     0.150
    39.474   443.758     0.150
    39.474   571.055     0.150
    39.789    18.297     0.150
    39.789    27.398     0.150
    42.557   469.125     0.150
    42.557   581.398     0.150
    42.557   469.156     0.150
    42.557   581.359     0.150
    43.169   476.117     0.150
    43.169   476.156     0.150
    43.640   477.055     0.150
    43.818   478.953     0.150
    44.031   481.156     0.150
    44.031    14.102     0.150
    47.738   509.758     0.150
    48.114   513.156     0.150
    48.541   517.055     0.150
    48.565   517.055     0.150
    48.881   519.055     0.150
    49.970   527.406     0.150
    57.213   578.758     0.150
    59.662   598.156     0.150
    60.645   602.359     0.150
    60.645   602.359     0.150
    62.138   612.258     0.150
    62.424    11.867     0.150
    62.424   615.758     0.150
    62.424    16.898     0.150
    63.787   647.258     0.150
    63.787   655.258     0.150
    64.213   625.953     0.150
    64.646  1161.453     0.150
    64.646  1392.055     0.150
    67.536   647.656     0.150
    68.655   656.055     0.150
    68.775   656.359     0.150
    69.575   660.648     0.150
    69.813   662.453     0.150
    69.813   662.625     0.150
    71.080   670.062     0.150
    71.858   674.289     0.150
    71.858    13.117     0.150
    72.025   675.773     0.150
    72.823   680.086     0.150
    73.046   680.258     0.150
    73.046   680.258     0.150
    73.124   680.227     0.150
    73.124   680.258     0.150
    73.815   685.062     0.150
    74.505   692.656     0.150
    75.282   690.055     0.150
    75.360   693.555     0.150
    76.396   696.656     0.150
    76.616   703.555     0.150
    77.086   704.758     0.150
    77.086    18.102     0.150
    77.138   705.758     0.150
    77.138    16.695     0.150
    78.186   711.953     0.150
    79.116   718.055     0.150
    79.116   718.055     0.150
    79.956   721.828     0.150
    81.205   727.859     0.150
    81.602   730.453     0.150
    81.602   730.453     0.150
    83.754   741.453     0.150
    83.754   741.453     0.150
    84.052   743.055     0.150
    84.052   743.055     0.150
    84.238   744.859     0.150
    84.304   744.453     0.150
    84.304   744.453     0.150
    84.340   744.656     0.150
    84.340   744.656     0.150
    84.763    13.070     0.150
    84.763    18.648     0.150
    84.763   746.055     0.150
    84.763    18.703     0.150
    85.576   751.258     0.150
    85.576   751.258     0.150
    85.626   751.555     0.150
    85.626   751.555     0.150
    85.979   753.656     0.150
    86.225   753.758     0.150
    86.225   753.758     0.150
    86.408   755.953     0.150
    86.408   755.953     0.150
    86.831   757.953     0.150
    86.831   757.953     0.150
    88.663   766.258     0.150
    88.663   766.258     0.150
    88.768  6695.641     0.150
    88.866  6702.453     0.150
    88.876  6703.227     0.150
    89.075   768.156     0.150
    89.075   768.156     0.150
   147.697  1190.453     0.150
   147.697  1194.055     0.150
   147.697  1199.156     0.150
   147.697  1206.656     0.150
   147.952  1191.156     0.150
   147.952  1194.656     0.150
     0.282    15.098     0.150
     1.863    30.266     0.150
     1.863    53.766     0.150
    25.846   323.566     0.150
    25.846   323.598     0.150
    47.765   507.367     0.150
    47.765   507.406     0.150
    48.908   519.477     0.150
    49.183   520.625     0.150
    59.547   596.137     0.150
    61.948   611.668     0.150
    64.237   625.066     0.150
    64.237   625.066     0.150
    64.773   630.988     0.150
    69.835   663.238     0.150
     1.860    29.453     0.150
     6.853    98.250     0.150
    26.308   329.953     0.150
    42.602   469.852     0.150
    42.602   469.875     0.150
    47.778   510.422     0.150
    48.155   514.070     0.150
    48.922   519.977     0.150
    49.165   521.695     0.150
    64.241   626.953     0.150
    64.778   630.953     0.150
    64.778   630.977     0.150
    69.838   663.750     0.150
    69.838   662.852     0.150
     1.763    29.145     0.150
     4.425    63.445     0.150
     6.995    98.766     0.150
     9.645   233.594     0.150
    15.292   365.895     0.150
    15.292   365.895     0.150
    17.665   240.516     0.150
    20.411   270.246     0.150
    20.422   270.164     0.150
    23.979   302.047     0.150
    25.891   325.734     0.150
    39.509   444.547     0.150
    39.509   571.445     0.150
    39.509   444.516     0.150
    39.509   571.395     0.150
    39.869    18.500     0.150
    39.869    27.500     0.150
    42.621   469.844     0.150
    42.621   581.047     0.150
    42.621   469.867     0.150
    42.621   580.996     0.150
    43.297   477.117     0.150
    47.607   511.387     0.150
    47.766   510.234     0.150
    48.145   513.355     0.150
    48.912   519.324     0.150
    49.291   521.445     0.150
    62.553   620.746     0.150
    64.177   625.547     0.150
    69.762   662.344     0.150
    69.762   662.445     0.150
    83.713   742.246     0.150
    84.011   743.645     0.150
    84.188   744.547     0.150
    84.188   744.547     0.150
    84.238   743.746     0.150
    84.299   744.547     0.150
    84.299   744.547     0.150
    84.670   747.547     0.150
    86.368   755.844     0.150
    86.368   755.844     0.150
    87.718   762.246     0.150
    87.718   762.246     0.150
    89.033   768.645     0.150
    89.033   768.645     0.150
   114.368  1111.965     0.150
   147.841  1189.145     0.150
   147.841  1193.645     0.150
   148.093  1193.945     0.150
     0.936    27.988     0.150
     4.527    64.488     0.150
     4.527   115.488     0.150
     4.655   115.488     0.150
     6.887    98.590     0.150
     9.537   230.137     0.150
    15.191   362.387     0.150
    15.192   362.387     0.150
    17.673   239.316     0.150
    17.933   436.789     0.150
    20.366   269.688     0.150
    20.366   472.090     0.150
    20.377   269.930     0.150
    20.768    17.000     0.150
    20.768   276.488     0.150
    20.768    17.000     0.150
    20.768   505.090     0.150
    20.768   535.789     0.150
    22.177   307.988     0.150
    22.177   574.488     0.150
    23.570    14.000     0.150
    23.570    21.500     0.150
    23.570    33.500     0.150
    25.887   326.387     0.150
    26.331   330.289     0.150
    26.331   535.688     0.150
    26.331   330.270     0.150
    26.331   535.660     0.150
    28.191   417.789     0.150
    28.191   635.188     0.150
    28.191   347.078     0.150
    28.677   350.359     0.150
    30.848   370.988     0.150
    30.848     7.500     0.150
    30.848    10.602     0.150
    32.607    12.000     0.150
    32.607    17.500     0.150
    33.293    22.102     0.150
    36.468   756.188     0.150
    37.292    16.598     0.150
    37.292    24.699     0.150
    37.292   427.090     0.150
    37.292    16.598     0.150
    37.292    24.699     0.150
    37.292   516.289     0.150
    37.292   770.789     0.150
    37.292   799.188     0.150
    37.292   924.688     0.150
    37.292   427.090     0.150
    37.292    16.598     0.150
    37.292    24.699     0.150
    37.292   516.289     0.150
    37.292   770.789     0.150
    37.292   799.188     0.150
    37.292   924.688     0.150
    39.530   445.188     0.150
    39.859    15.301     0.150
    39.859    23.000     0.150
    39.859   570.090     0.150
    42.398   468.066     0.150
    42.398   580.910     0.150
    43.249   477.289     0.150
    43.249   477.309     0.150
    43.583   477.020     0.150
    43.685   477.930     0.150
    44.020   482.418     0.150
    47.791   510.840     0.150
    48.169   514.109     0.150
    48.936   520.227     0.150
    48.936   603.719     0.150
    49.125   541.488     0.150
    49.288   521.887     0.150
    49.288   521.930     0.150
    49.606     9.000     0.150
    49.759   527.547     0.150
    52.146   545.488     0.150
    53.358   997.090     0.150
    53.358   552.727     0.150
    57.868   582.688     0.150
    58.630   590.488     0.150
    59.543   596.188     0.150
    59.742   597.988     0.150
    60.640   603.688     0.150
    60.640   603.688     0.150
    61.953   611.387     0.150
    62.459   616.488     0.150
    64.240   627.289     0.150
    64.685   654.090     0.150
    64.685   630.789     0.150
    64.777   631.188     0.150
    65.498   637.559     0.150
    66.185   641.988     0.150
    66.948   644.289     0.150
    66.948   644.309     0.150
    66.948   645.871     0.150
    67.465   649.273     0.150
    68.470   656.789     0.150
    68.470   656.816     0.150
    69.833   663.387     0.150
    70.373  1255.289     0.150
    70.835   665.188     0.150
    70.938   670.188     0.150
    70.938   670.207     0.150
    72.657   682.109     0.150
    74.459   686.887     0.150
    74.985   694.918     0.150
    75.015   696.359     0.150
    75.396   697.688     0.150
    75.944   700.188     0.150
    76.203   702.000     0.150
    76.334   703.090     0.150
    76.334   872.988     0.150
    76.432   703.090     0.150
    76.486   705.184     0.150
    76.650   704.660     0.150
    76.669   705.270     0.150
    76.701   705.359     0.150
    77.120   707.578     0.150
    77.122   729.590     0.150
    77.122   707.488     0.150
    77.122   714.988     0.150
    77.122   729.590     0.150
    77.167   706.988     0.150
    77.172   707.027     0.150
    77.172   706.988     0.150
    77.400   708.699     0.150
    77.664   709.988     0.150
    78.074   713.289     0.150
    78.908   716.090     0.150
    78.908   716.090     0.150
    78.908   716.887     0.150
    78.979   717.688     0.150
    78.985   716.797     0.150
    79.145   718.387     0.150
    79.145   718.387     0.150
    79.679   721.637     0.150
    80.389   724.988     0.150
    80.486   726.789     0.150
    80.646   726.488     0.150
    80.646   726.469     0.150
    80.962   728.289     0.150
    80.997   726.688     0.150
    80.999   728.590     0.150
    81.135   729.188     0.150
    81.198   729.590     0.150
    81.231   728.688     0.150
    81.231   728.688     0.150
    81.328   729.090     0.150
    81.629   731.289     0.150
    81.629   731.289     0.150
    82.285   734.188     0.150
    82.285   734.188     0.150
    82.298   734.289     0.150
    82.298   734.289     0.150
    82.309   734.988     0.150
    83.779   742.188     0.150
    83.779   742.188     0.150
    83.812   742.188     0.150
    83.812   742.188     0.150
    83.857   742.488     0.150
    83.857   742.488     0.150
    84.077   743.789     0.150
    84.077   743.789     0.150
    84.258   744.789     0.150
    84.258   744.789     0.150
    84.299   745.590     0.150
    84.299   745.590     0.150
    84.308   745.688     0.150
    84.308   745.688     0.150
    84.325   746.199     0.150
    84.329   745.090     0.150
    84.329   745.090     0.150
    84.365   745.488     0.150
    84.365   745.488     0.150
    84.717   747.918     0.150
    84.736   747.387     0.150
    84.736   747.387     0.150
    84.867   748.188     0.150
    84.867   748.188     0.150
    84.962   748.289     0.150
    84.962   748.289     0.150
    85.121   749.688     0.150
    85.121   749.688     0.150
    85.182   749.688     0.150
    85.182   749.688     0.150
    85.344   750.387     0.150
    85.344   750.387     0.150
    85.455   750.289     0.150
    85.455   750.289     0.150
    85.604   751.988     0.150
    85.604   751.988     0.150
    85.648   752.387     0.150
    85.648   752.387     0.150
    85.911   754.688     0.150
    85.971   751.988     0.150
    85.971   751.977     0.150
    86.009   753.289     0.150
    86.009   753.289     0.150
    86.279   755.488     0.150
    86.279   755.488     0.150
    86.434   756.688     0.150
    86.434   756.688     0.150
    86.855   758.688     0.150
    86.855   758.688     0.150
    87.782   762.988     0.150
    87.782   762.988     0.150
    88.688   766.789     0.150
    88.688   766.789     0.150
    89.100   769.590     0.150
    89.100   769.590     0.150
    89.113   766.797     0.150
    89.935   771.309     0.150
    89.978   772.148     0.150
    91.345   778.109     0.150
    91.456   779.488     0.150
    91.456   779.527     0.150
    93.576   788.887     0.150
    93.576   788.867     0.150
    93.991   788.988     0.150
    95.162   793.910     0.150
    95.565   796.227     0.150
   114.408  1113.008     0.150
   114.408  1165.617     0.150
   120.114  1123.488     0.150
   120.114  1123.508     0.150
   124.830  1133.488     0.150
   146.158  1181.590     0.150
   147.733  1209.090     0.150
   147.733  1641.688     0.150
   147.733  1650.688     0.150
   147.733  1662.387     0.150
   147.985  1186.887     0.150
   147.985  1207.090     0.150
   147.985  1639.090     0.150
   147.985  1648.090     0.150
   147.985  1660.590     0.150
     0.582    22.609     0.150
     6.936    99.512     0.150
     6.936    99.480     0.150
    25.909   328.031     0.150
    42.196   467.211     0.150
    47.682   510.410     0.150
    64.373   629.219     0.150
    64.373   629.211     0.150
    73.151   685.859     0.150
    86.016   756.230     0.150
     0.282    10.125     0.150
     1.869    48.164     0.150
     1.869    30.414     0.150
     1.869    48.164     0.150
     6.812    98.293     0.150
     6.812    98.113     0.150
    12.566   181.812     0.150
    17.624   241.523     0.150
    21.328   278.684     0.150
    25.829   325.293     0.150
    26.273   327.965     0.150
    26.273   327.984     0.150
    39.489   444.062     0.150
    39.798    15.301     0.150
    39.798    22.500     0.150
    42.568   469.035     0.150
    42.568   581.273     0.150
    42.568   469.039     0.150
    42.568   581.277     0.150
    43.831   479.215     0.150
    48.129   513.691     0.150
    59.001   590.062     0.150
    59.547   595.762     0.150
    61.945   611.262     0.150
    62.410   616.453     0.150
    64.234   624.363     0.150
    64.234   624.363     0.150
    64.770   631.062     0.150
    69.835   662.438     0.150
    70.917   669.312     0.150
    76.298   702.527     0.150
     0.189     8.852     0.150
     1.956    31.508     0.150
     1.956    56.555     0.150
     9.454   229.258     0.150
    10.164   255.055     0.150
    12.666   326.227     0.150
    13.066   202.055     0.150
    15.093   360.305     0.150
    15.093   360.305     0.150
    17.764   243.453     0.150
    20.416   498.352     0.150
    20.427   270.555     0.150
    21.427   547.352     0.150
    23.628    14.203     0.150
    23.628    21.703     0.150
    23.628    34.500     0.150
    26.414   331.273     0.150
    26.414   535.336     0.150
    28.284   347.758     0.150
    28.456   396.555     0.150
    30.896    13.000     0.150
    30.896    20.000     0.150
    32.669    14.797     0.150
    32.669    23.000     0.150
    32.669   695.055     0.150
    32.669   812.055     0.150
    33.325    15.000     0.150
    33.325    22.203     0.150
    33.691    17.500     0.150
    33.691    23.797     0.150
    33.691   741.055     0.150
    37.311    14.000     0.150
    37.311    21.500     0.150
    39.939    15.000     0.150
    39.939    23.000     0.150
    39.939   836.055     0.150
    42.709   470.727     0.150
    42.709   582.062     0.150
    43.295   477.852     0.150
    43.972   481.258     0.150
    44.032   483.055     0.150
    48.267   513.562     0.150
    48.514   517.656     0.150
    49.199   521.852     0.150
    49.527   524.398     0.150
    49.684    10.000     0.150
    50.121   529.664     0.150
    53.462   616.258     0.150
    53.462   745.352     0.150
    57.265   580.656     0.150
    58.691   591.500     0.150
    59.781   599.555     0.150
    60.744   604.656     0.150
    62.063   612.453     0.150
    64.350   627.758     0.150
    64.887   632.352     0.150
    64.887    16.000     0.150
    64.887   632.328     0.150
    64.887    16.000     0.150
    68.569   656.953     0.150
    69.944   664.156     0.150
    69.944   663.852     0.150
    69.944    14.781     0.150
    70.141   667.555     0.150
    70.874   670.227     0.150
    71.475   672.742     0.150
    73.127    13.000     0.150
    74.472   691.727     0.150
    75.505   699.055     0.150
    75.802   699.352     0.150
    76.759   705.656     0.150
    76.787    18.102     0.150
    77.230   708.055     0.150
    77.277   707.656     0.150
    77.277    14.898     0.150
    77.277  1294.555     0.150
    77.277   707.656     0.150
    77.277  1294.555     0.150
    77.324   707.156     0.150
    77.798   711.156     0.150
    79.017   717.789     0.150
    79.017    14.328     0.150
    79.255   719.258     0.150
    79.255   719.258     0.150
    82.408   735.555     0.150
    83.889   743.258     0.150
    83.889   743.258     0.150
    84.187   744.852     0.150
    84.187   744.852     0.150
    84.409   745.953     0.150
    84.418   745.852     0.150
    84.440   746.258     0.150
    84.440   746.258     0.150
    84.475   746.453     0.150
    84.475   746.453     0.150
    86.544   757.758     0.150
    86.544   757.758     0.150
    89.210   770.555     0.150
    89.210   770.555     0.150
   146.077  1169.555     0.150
   146.077  1181.055     0.150
   146.077  1187.055     0.150
   146.077  1189.953     0.150
   146.077  1193.656     0.150
   146.077  1201.352     0.150
   146.077  1203.953     0.150
   146.077  1207.055     0.150
   146.077  1211.758     0.150
   146.077  1214.453     0.150
   146.077  1218.156     0.150
   146.077  1221.352     0.150
   146.077  1224.852     0.150
   147.650  1185.656     0.150
   147.650  1192.156     0.150
   147.650  1195.656     0.150
   147.650  1199.953     0.150
   147.650  1206.055     0.150
   147.650  1210.352     0.150
   147.650  1212.953     0.150
   147.650  1217.656     0.150
   147.650  1220.656     0.150
   147.650  1223.953     0.150
   147.650  1226.852     0.150
   147.650  1231.258     0.150
   147.650  1233.555     0.150
   147.901  1193.055     0.150
   147.901  1194.953     0.150
   147.901  1198.453     0.150
   147.901  1205.555     0.150
   147.901  1208.852     0.150
   147.901  1212.656     0.150
   147.901  1216.953     0.150
   147.901  1219.555     0.150
   147.901  1222.555     0.150
   147.901  1225.555     0.150
   147.901  1229.258     0.150
   147.901  1231.352     0.150
   148.048  1193.352     0.150
   148.048  1195.758     0.150
   148.048  1200.156     0.150
   148.048  1206.055     0.150
   148.048  1210.453     0.150
   148.048  1213.758     0.150
   148.048  1218.258     0.150
   148.048  1221.156     0.150
   148.048  1224.352     0.150
   148.048  1227.156     0.150
   148.048  1230.156     0.150
   148.048  1232.555     0.150
     1.130    33.383     0.150
     1.949    31.582     0.150
     2.014    32.582     0.150
     4.186    59.184     0.150
     4.186   106.484     0.150
     6.217    86.785     0.150
     7.177   102.383     0.150
     7.177   102.695     0.150
     7.545   108.785     0.150
     9.718   234.383     0.150
    10.476   150.023     0.150
    10.785   281.684     0.150
    11.942   162.285     0.150
    13.070   333.457     0.150
    13.399   194.684     0.150
    13.399   198.184     0.150
    14.656   199.465     0.150
    14.656   356.293     0.150
    14.656   199.582     0.150
    14.656   356.984     0.150
    14.927   367.684     0.150
    14.927   384.184     0.150
    15.272   365.184     0.150
    15.272   365.184     0.150
    17.072   420.684     0.150
    17.794   433.785     0.150
    18.008   244.582     0.150
    20.795   274.484     0.150
    21.170    16.199     0.150
    21.170   526.484     0.150
    21.398   297.953     0.150
    21.398   508.293     0.150
    21.398   297.383     0.150
    22.207     9.500     0.150
    22.207    18.000     0.150
    22.207    29.301     0.150
    22.850   297.383     0.150
    24.282    14.000     0.150
    24.282   358.684     0.150
    26.247   329.285     0.150
    26.232    21.801     0.150
    26.232   367.684     0.150
    26.691   333.762     0.150
    28.385   399.684     0.150
    28.385   414.984     0.150
    28.499   344.605     0.150
    28.499   345.285     0.150
    30.268   360.383     0.150
    31.266    10.500     0.150
    31.266    15.000     0.150
    33.013     9.801     0.150
    33.013    13.500     0.150
    33.013   721.984     0.150
    33.716     9.699     0.150
    34.094    17.699     0.150
    34.094    24.000     0.150
    36.861    13.199     0.150
    36.861   424.395     0.150
    37.712    10.801     0.150
    37.712    15.500     0.150
    37.712   540.184     0.150
    37.712   794.484     0.150
    37.712   927.684     0.150
    37.712   959.984     0.150
    39.038   442.582     0.150
    39.818   589.734     0.150
    40.232    15.000     0.150
    40.232    22.000     0.150
    40.232   839.684     0.150
    40.613   582.285     0.150
    42.971   600.715     0.150
    42.971   473.359     0.150
    42.971   600.707     0.150
    43.291   475.184     0.150
    43.291    14.898     0.150
    43.376   476.383     0.150
    43.669    11.199     0.150
    43.669   885.684     0.150
    43.669   480.992     0.150
    43.669    13.781     0.150
    43.669   480.984     0.150
    43.669    13.801     0.150
    43.583   480.801     0.150
    43.692   478.883     0.150
    43.692    15.699     0.150
    44.197   482.883     0.150
    44.435   486.383     0.150
    48.202   511.684     0.150
    48.462   619.492     0.150
    48.462   930.883     0.150
    48.462   516.383     0.150
    48.462   930.883     0.150
    48.791   520.184     0.150
    49.335   524.535     0.150
    49.484    19.000     0.150
    49.806   526.594     0.150
    49.806   625.844     0.150
    49.982    15.301     0.150
    49.982    22.301     0.150
    49.982   701.184     0.150
    49.982   833.684     0.150
    49.982   952.184     0.150
    49.982  1162.484     0.150
    50.117   528.672     0.150
    50.117   626.195     0.150
    50.398   627.504     0.150
    51.282   539.285     0.150
    52.399  1000.484     0.150
    53.611   617.785     0.150
    53.611   740.484     0.150
    53.648   556.883     0.150
    53.648   556.844     0.150
    55.723   569.184     0.150
    58.362   588.883     0.150
    58.362    15.602     0.150
    58.362   588.879     0.150
    58.362    15.648     0.150
    59.103   592.184     0.150
    59.647   597.082     0.150
    60.165   602.184     0.150
    60.600   604.512     0.150
    60.623   602.684     0.150
    62.173   615.684     0.150
    62.173   615.184     0.150
    62.173    15.102     0.150
    62.568    19.141     0.150
    62.568   617.883     0.150
    62.568    19.102     0.150
    64.041   771.082     0.150
    64.930   632.383     0.150
    64.930   632.359     0.150
    64.982   631.344     0.150
    65.612   635.695     0.150
    65.791   640.582     0.150
    65.791    15.402     0.150
    65.791   640.516     0.150
    66.090     8.398     0.150
    66.305   643.133     0.150
    66.571   644.484     0.150
    66.571    15.500     0.150
    67.805   652.883     0.150
    67.805    15.500     0.150
    68.319   655.082     0.150
    68.319    16.203     0.150
    68.758  1199.383     0.150
    69.439   662.883     0.150
    69.439    16.102     0.150
    69.765   664.785     0.150
    69.765    16.297     0.150
    69.948   664.234     0.150
    70.433   666.785     0.150
    70.479   670.008     0.150
    70.479    15.449     0.150
    71.104   682.484     0.150
    71.156   671.734     0.150
    71.168   671.484     0.150
    71.168    16.000     0.150
    71.200   673.254     0.150
    71.605   676.383     0.150
    71.605    15.500     0.150
    72.039   678.043     0.150
    72.152   677.824     0.150
    72.152   677.824     0.150
    72.127   679.902     0.150
    72.617   682.285     0.150
    72.617    16.297     0.150
    72.676   682.082     0.150
    72.676    17.000     0.150
    73.394   686.684     0.150
    73.394   702.383     0.150
    74.657   694.184     0.150
    74.657   709.484     0.150
    74.707   694.285     0.150
    74.707    15.699     0.150
    74.744   693.785     0.150
    74.744    16.398     0.150
    74.862   695.383     0.150
    74.862    15.602     0.150
    75.524   706.785     0.150
    75.524   698.383     0.150
    75.524   706.684     0.150
    75.595   699.285     0.150
    75.595    14.797     0.150
    75.560   699.688     0.150
    75.786   700.285     0.150
    75.992   700.984     0.150
    76.103   702.285     0.150
    76.103    16.098     0.150
    76.434   704.082     0.150
    76.632   704.383     0.150
    76.632    16.602     0.150
    76.834   705.684     0.150
    76.834    15.801     0.150
    76.897   706.984     0.150
    76.954   706.883     0.150
    76.943   707.684     0.150
    76.943    15.102     0.150
    77.316   708.582     0.150
    77.316    15.703     0.150
    77.320   708.285     0.150
    77.320    16.398     0.150
    77.320   709.383     0.150
    77.329   711.684     0.150
    77.329   707.984     0.150
    77.329    15.699     0.150
    77.329   707.984     0.150
    77.329    15.699     0.150
    77.340   708.082     0.150
    77.340    16.402     0.150
    77.340   708.043     0.150
    77.340    16.402     0.150
    77.814   711.184     0.150
    77.921   712.285     0.150
    77.986   711.785     0.150
    78.247   712.672     0.150
    78.374   714.082     0.150
    78.374    15.902     0.150
    78.374   713.984     0.150
    78.896   717.383     0.150
    78.749   716.785     0.150
    79.082   717.883     0.150
    79.149   718.785     0.150
    79.188   718.484     0.150
    79.118   720.984     0.150
    79.118    15.598     0.150
    79.307   719.684     0.150
    79.307    15.000     0.150
    79.307   719.684     0.150
    79.307    15.000     0.150
    79.308   719.184     0.150
    79.308   725.184     0.150
    79.308    15.801     0.150
    79.749    15.574     0.150
    79.880   723.785     0.150
    79.880    15.797     0.150
    80.204   739.199     0.150
    80.235   722.984     0.150
    80.430   723.383     0.150
    80.557   726.383     0.150
    80.666   727.285     0.150
    80.748   725.684     0.150
    80.850   728.684     0.150
    80.808   726.785     0.150
    80.808    15.898     0.150
    81.112   728.285     0.150
    81.134   729.582     0.150
    81.171   729.785     0.150
    81.190   727.863     0.150
    81.305   730.484     0.150
    81.369   730.785     0.150
    81.484   730.684     0.150
    81.516   730.484     0.150
    81.681   732.383     0.150
    81.780   732.383     0.150
    81.780   732.383     0.150
    81.985   732.883     0.150
    82.437   735.383     0.150
    82.437   735.383     0.150
    82.447   735.582     0.150
    82.447   735.582     0.150
    82.451   735.984     0.150
    82.847   736.984     0.150
    83.419   740.582     0.150
    83.741   742.684     0.150
    83.741   742.684     0.150
    83.912   743.785     0.150
    83.920   743.383     0.150
    83.920   743.383     0.150
    83.930   743.082     0.150
    83.930   743.082     0.150
    83.978   743.285     0.150
    83.978   743.285     0.150
    84.076   744.984     0.150
    84.217   744.883     0.150
    84.217   744.883     0.150
    84.245   746.285     0.150
    84.251   746.082     0.150
    84.376   745.684     0.150
    84.376   745.684     0.150
    84.355   746.184     0.150
    84.355    16.199     0.150
    84.459   746.883     0.150
    84.459   746.883     0.150
    84.468   746.984     0.150
    84.468   746.984     0.150
    84.473   746.285     0.150
    84.473   746.285     0.150
    84.506   746.484     0.150
    84.506   746.484     0.150
    84.523   746.184     0.150
    84.523    17.301     0.150
    84.876   748.883     0.150
    84.876   748.883     0.150
    84.878   748.082     0.150
    84.977   749.184     0.150
    84.977   749.184     0.150
    85.099   749.785     0.150
    85.099   749.785     0.150
    85.124   749.582     0.150
    85.124   749.582     0.150
    84.944   748.113     0.150
    84.944   748.082     0.150
    85.279   750.785     0.150
    85.279   750.785     0.150
    85.320   750.785     0.150
    85.320   750.785     0.150
    85.453   751.184     0.150
    85.453   751.184     0.150
    85.473   750.383     0.150
    85.563   750.582     0.150
    85.623   751.582     0.150
    85.623   751.582     0.150
    85.565   751.883     0.150
    85.565    16.402     0.150
    85.542   752.984     0.150
    85.542    16.348     0.150
    85.660   752.484     0.150
    85.660    16.098     0.150
    85.757   753.184     0.150
    85.757   753.184     0.150
    85.775   753.285     0.150
    85.775   753.285     0.150
    86.148   755.082     0.150
    86.148   755.082     0.150
    86.175   754.484     0.150
    86.175   754.484     0.150
    86.205   755.383     0.150
    86.341   754.883     0.150
    86.417   756.582     0.150
    86.417   756.582     0.150
    86.421   755.883     0.150
    86.421   755.883     0.150
    86.499   755.684     0.150
    86.575   757.883     0.150
    86.575   757.883     0.150
    86.738   757.184     0.150
    86.990   759.684     0.150
    86.990   759.684     0.150
    86.966   759.285     0.150
    86.966    16.199     0.150
    87.259   760.582     0.150
    87.259    16.500     0.150
    87.930   764.184     0.150
    87.930   764.184     0.150
    88.828   766.984     0.150
    88.828   766.984     0.150
    88.829   767.785     0.150
    88.829    15.199     0.150
    89.236   770.582     0.150
    89.236   770.582     0.150
    89.300   769.582     0.150
    89.764   772.082     0.150
    89.764    16.602     0.150
    90.106   773.383     0.150
    91.196   779.984     0.150
    91.196   779.984     0.150
    91.196    15.598     0.150
    91.591   781.383     0.150
    91.632   779.684     0.150
    91.632   779.684     0.150
    92.400   784.383     0.150
    93.231   788.496     0.150
    93.716   791.383     0.150
   123.401  1131.359     0.150
   125.069  1149.383     0.150
   125.069  1133.723     0.150
   125.069  1149.371     0.150
   129.040  1137.105     0.150
   129.040  1137.082     0.150
   129.040  1137.109     0.150
   129.040  1143.457     0.150
   132.091  1146.820     0.150
   142.384  1163.672     0.150
   142.384  1166.883     0.150
   142.884  1160.484     0.150
   145.528 10952.105     0.150
   145.541 10956.113     0.150
   145.544 10953.262     0.150
   146.339  1181.785     0.150
   146.339  1185.785     0.150
   146.339  1191.984     0.150
   147.908  1190.582     0.150
   147.908  1196.383     0.150
   148.151  1190.582     0.150
   148.151  1196.184     0.150
   148.306  1188.484     0.150
   148.306  1192.785     0.150
   148.306  1197.883     0.150
   151.545  1188.844     0.150
   154.436  1194.984     0.150
   154.436  1210.684     0.150
   154.436  1194.957     0.150
   154.436  1210.660     0.150
   156.515  1218.059     0.150
     0.993    30.695     0.150
     1.285    36.195     0.150
     4.724   128.395     0.150
     6.701    98.824     0.150
     6.701   178.895     0.150
     6.701    97.994     0.150
     8.354   110.494     0.150
    26.229   328.494     0.150
    30.686   372.094     0.150
    34.726   401.594     0.150
    39.456   442.875     0.150
    42.529   579.875     0.150
    42.529   469.195     0.150
    42.529   579.895     0.150
    48.329   515.695     0.150
    49.312   522.395     0.150
    49.659   524.754     0.150
    57.333   579.764     0.150
    59.042   592.494     0.150
    59.589   595.295     0.150
    61.972   611.994     0.150
    62.321   615.895     0.150
    64.263   626.494     0.150
    64.798   631.094     0.150
    64.798   631.115     0.150
    69.874   663.295     0.150
    70.925   669.594     0.150
   123.161  1129.994     0.150
     1.843    46.348     0.150
     1.843    28.996     0.150
     1.843    46.348     0.150
     4.544    63.746     0.150
     6.874    98.547     0.150
     6.874   172.746     0.150
     6.874    98.633     0.150
     9.531   231.145     0.150
    25.866   325.645     0.150
    26.309   329.785     0.150
    30.199  2262.230     0.150
    30.210  2263.172     0.150
    30.217  2264.395     0.150
    31.076  2326.031     0.150
    31.080  2326.441     0.150
    31.093  2327.539     0.150
    39.498   443.746     0.150
    39.498   570.445     0.150
    39.498   443.695     0.150
    39.498   570.473     0.150
    39.838     9.801     0.150
    39.838    13.801     0.150
    42.602   470.020     0.150
    42.602   580.945     0.150
    43.226   476.848     0.150
    43.597   477.945     0.150
    43.858   480.121     0.150
    44.236   484.145     0.150
    48.151   513.445     0.150
    48.410   516.348     0.150
    53.342   552.047     0.150
    56.188   573.520     0.150
    57.186   579.145     0.150
    57.186   579.098     0.150
    58.642    14.512     0.150
    58.642   590.047     0.150
    58.642    14.500     0.150
    58.642   590.043     0.150
    58.642    14.500     0.150
    58.989   591.848     0.150
    58.989   591.848     0.150
    59.535   594.695     0.150
    61.941   611.746     0.150
    62.455    16.098     0.150
    62.455   616.355     0.150
    62.455    16.074     0.150
    64.229   626.945     0.150
    64.229   626.945     0.150
    64.671   628.848     0.150
    64.766   629.746     0.150
    66.182    16.203     0.150
    66.182   641.598     0.150
    66.182    16.250     0.150
    68.452   684.645     0.150
    69.817   662.727     0.150
    69.824   662.621     0.150
    70.528   667.742     0.150
    70.873    15.730     0.150
    70.873   670.770     0.150
    70.873    15.727     0.150
    70.923   669.297     0.150
    71.358   670.645     0.150
    76.317   701.047     0.150
    77.156   706.746     0.150
    77.387   708.625     0.150
    78.237   714.047     0.150
    78.581   713.746     0.150
    78.896   716.359     0.150
    79.133   718.047     0.150
    79.133   718.047     0.150
    81.618   730.945     0.150
    81.618   730.945     0.150
    82.274   733.848     0.150
    82.274   733.848     0.150
    83.768   741.848     0.150
    83.768   741.848     0.150
    84.066   743.445     0.150
    84.066   743.445     0.150
    84.297   745.445     0.150
    84.297   745.445     0.150
    84.354   745.145     0.150
    84.354   745.145     0.150
    85.109   749.246     0.150
    85.109   749.246     0.150
    85.172   749.348     0.150
    85.172   749.348     0.150
    85.592   751.645     0.150
    85.592   751.645     0.150
    85.930    14.801     0.150
    85.930   754.645     0.150
    85.930    14.750     0.150
    85.997   753.547     0.150
    86.243   754.348     0.150
    86.243   754.348     0.150
    86.423   756.445     0.150
    86.423   756.445     0.150
    89.089   769.246     0.150
    89.089   769.246     0.150
   145.972 10965.105     0.150
   145.986 10962.902     0.150
   145.988 10965.105     0.150
   146.151  1187.445     0.150
   147.726  1194.145     0.150
   147.979  1195.145     0.150
     0.290    10.023     0.150
     0.933    28.625     0.150
     1.851    55.023     0.150
     1.851    30.172     0.150
     1.851    54.977     0.150
     4.555    64.625     0.150
     6.819   178.625     0.150
     6.862    98.023     0.150
     6.862    98.266     0.150
     6.862   177.711     0.150
     8.358   120.523     0.150
    10.064   246.125     0.150
    10.505   144.625     0.150
    12.622   324.422     0.150
    12.622   177.227     0.150
    12.622   324.406     0.150
    12.972   321.922     0.150
    14.602   202.625     0.150
    14.602   202.602     0.150
    17.652   240.422     0.150
    18.634   252.523     0.150
    20.347   268.922     0.150
    21.317   299.328     0.150
    22.735   300.523     0.150
    23.541    14.195     0.150
    23.541    22.398     0.150
    23.541    33.195     0.150
    23.541   575.227     0.150
    25.784    15.297     0.150
    25.863   325.125     0.150
    25.863   325.609     0.150
    25.863   325.625     0.150
    26.307   329.742     0.150
    27.931    14.797     0.150
    28.171   345.828     0.150
    28.171   346.539     0.150
    28.345   534.328     0.150
    28.695   400.727     0.150
    30.198  2258.336     0.150
    30.209  2256.164     0.150
    30.216  2261.000     0.150
    30.818    14.703     0.150
    30.818    22.102     0.150
    31.075  2322.102     0.150
    31.078  2323.758     0.150
    31.092  2326.898     0.150
    32.579    14.797     0.150
    32.579    22.102     0.150
    33.262    14.898     0.150
    33.262    22.000     0.150
    33.262   827.125     0.150
    33.644    17.500     0.150
    33.644    25.203     0.150
    37.261    15.805     0.150
    37.261    23.703     0.150
    39.498   570.234     0.150
    39.498   444.227     0.150
    39.498   571.328     0.150
    39.498   793.227     0.150
    39.498   444.203     0.150
    39.498   571.352     0.150
    39.498   793.203     0.150
    39.835    15.305     0.150
    39.835    22.500     0.150
    40.302   817.625     0.150
    42.426   468.125     0.150
    42.426   468.102     0.150
    42.600   469.875     0.150
    42.926   478.023     0.150
    43.219   476.617     0.150
    43.219   476.625     0.150
    43.858   480.297     0.150
    43.858   480.180     0.150
    43.988   481.828     0.150
    43.988   482.141     0.150
    44.000   481.328     0.150
    48.101   513.516     0.150
    48.101   600.711     0.150
    48.151   513.727     0.150
    48.151   514.367     0.150
    49.156   521.078     0.150
    49.264   522.422     0.150
    49.264   522.641     0.150
    49.264   522.641     0.150
    49.581    15.195     0.150
    49.581    21.898     0.150
    49.581   979.625     0.150
    49.736   525.695     0.150
    53.344   552.125     0.150
    53.344   618.023     0.150
    56.833   576.922     0.150
    57.197   578.922     0.150
    58.653   590.219     0.150
    58.995   591.922     0.150
    58.995   591.922     0.150
    59.541   596.078     0.150
    59.712   598.625     0.150
    60.646   603.227     0.150
    60.646   603.227     0.150
    61.946   611.523     0.150
    62.434   615.727     0.150
    62.445   615.938     0.150
    63.815   646.328     0.150
    64.234   626.625     0.150
    64.234   626.625     0.150
    64.674   630.227     0.150
    65.526   637.227     0.150
    66.172   641.172     0.150
    68.453   656.023     0.150
    68.453   656.617     0.150
    68.624   656.523     0.150
    69.830   662.828     0.150
    70.356    12.805     0.150
    70.356   827.023     0.150
    70.356  1217.328     0.150
    70.927   669.750     0.150
    70.938   669.523     0.150
    73.005   682.297     0.150
    73.005   682.328     0.150
    74.543   693.125     0.150
    74.543   856.422     0.150
    74.597   692.922     0.150
    74.974   694.625     0.150
    75.309   705.422     0.150
    75.309   696.625     0.150
    75.309   705.422     0.150
    75.386   704.328     0.150
    75.386   697.828     0.150
    75.386   704.328     0.150
    75.386   697.828     0.150
    75.386   704.227     0.150
    75.541   699.227     0.150
    75.684   702.625     0.150
    75.684   698.625     0.150
    75.735   698.922     0.150
    75.939   700.328     0.150
    76.318   702.727     0.150
    76.318   873.680     0.150
    76.657   705.523     0.150
    76.673    19.305     0.150
    76.728   704.422     0.150
    77.110   706.828     0.150
    77.112   707.227     0.150
    77.160   706.727     0.150
    77.160    21.898     0.150
    77.160   706.727     0.150
    77.160    21.898     0.150
    77.165   728.727     0.150
    77.165   706.922     0.150
    77.165   706.797     0.150
    77.165   728.695     0.150
    77.391   708.523     0.150
    77.658   709.727     0.150
    77.753   710.523     0.150
    78.208   712.727     0.150
    78.715    22.797     0.150
    78.900   716.328     0.150
    78.900   716.359     0.150
    78.972   717.227     0.150
    78.975   716.727     0.150
    79.138    22.398     0.150
    79.138    22.398     0.150
    79.138   718.125     0.150
    79.138    22.398     0.150
    79.138   718.125     0.150
    79.138    22.398     0.150
    79.680   720.625     0.150
    80.381   724.828     0.150
    81.321   729.523     0.150
    81.623   731.023     0.150
    81.623   731.023     0.150
    81.831   731.023     0.150
    82.279   734.125     0.150
    82.279   734.125     0.150
    82.292   734.125     0.150
    82.292   734.125     0.150
    82.304   734.727     0.150
    83.774   741.922     0.150
    83.774   741.922     0.150
    83.808   741.922     0.150
    84.071   743.523     0.150
    84.071   743.523     0.150
    84.255   744.422     0.150
    84.255   744.422     0.150
    84.292   745.328     0.150
    84.292   745.328     0.150
    84.324   744.922     0.150
    84.324   744.922     0.150
    84.359   745.227     0.150
    84.359   745.227     0.150
    84.864   748.125     0.150
    84.864   748.125     0.150
    84.988   748.625     0.150
    84.988   748.625     0.150
    85.114   749.227     0.150
    85.114   749.227     0.150
    85.177   749.523     0.150
    85.177   749.523     0.150
    85.341   750.125     0.150
    85.341   750.125     0.150
    85.447   750.023     0.150
    85.447   750.023     0.150
    85.597   751.727     0.150
    85.597   751.727     0.150
    85.644   752.125     0.150
    85.644   752.125     0.150
    85.941   754.250     0.150
    86.248   754.328     0.150
    86.248   754.328     0.150
    86.274   755.125     0.150
    86.274   755.125     0.150
    86.428   756.523     0.150
    86.428   756.523     0.150
    86.850   758.422     0.150
    86.850   758.422     0.150
    89.095   769.227     0.150
    89.095   769.227     0.150
   114.394  1112.539     0.150
   114.394  1166.453     0.150
   120.107  1754.875     0.150
   123.165  1129.375     0.150
   123.165  1226.477     0.150
   145.980 10962.227     0.150
   145.993 10962.227     0.150
   145.995 10966.781     0.150
   147.968  1172.625     0.150
   151.781  1187.781     0.150
   154.874  1208.953     0.150
     0.971    27.484     0.150
     1.873    30.734     0.150
     1.873    53.781     0.150
     6.903    98.812     0.150
     6.903    99.145     0.150
     9.537   230.332     0.150
    30.133  2259.672     0.150
    30.144  2260.426     0.150
    30.151  2261.004     0.150
    31.011  2321.820     0.150
    31.015  2322.020     0.150
    31.028  2323.074     0.150
    39.566   443.281     0.150
    39.566   443.320     0.150
    42.674   469.535     0.150
    43.928   481.184     0.150
    64.814   631.379     0.150
    73.066   684.312     0.150
    85.880   753.984     0.150
     1.858    30.172     0.150
     1.858    53.372     0.150
     6.825    97.972     0.150
    25.829   325.722     0.150
    26.272   329.672     0.150
    30.223  2261.077     0.150
    30.234  2261.604     0.150
    30.241  2262.413     0.150
    31.098  2337.303     0.150
    31.102  2325.514     0.150
    31.115  2327.075     0.150
    39.472   444.072     0.150
    39.472   570.872     0.150
    42.567   469.772     0.150
    42.567   581.272     0.150
    43.829   479.472     0.150
    43.908   479.422     0.150
    44.179   482.872     0.150
    48.075   513.172     0.150
    48.075   600.372     0.150
    48.373   516.012     0.150
    56.164   572.572     0.150
    58.992   591.672     0.150
    61.937   610.872     0.150
    64.226   626.172     0.150
    64.762   630.872     0.150
    69.826   662.772     0.150
    70.910   669.472     0.150
    70.910   669.492     0.150
    70.929   672.942     0.150
    76.294   702.372     0.150
    84.352   745.072     0.150
    84.352   745.072     0.150
    85.985   754.872     0.150
    86.237   754.272     0.150
    86.237   754.272     0.150
    88.768  6608.130     0.150
   146.024 10968.919     0.150
   146.038 10970.665     0.150
   146.040 10967.664     0.150
     0.865    27.008     0.150
     1.717    28.312     0.150
     1.717    49.711     0.150
     4.291    61.711     0.150
     7.122   101.391     0.150
     9.752   234.586     0.150
    25.958   322.812     0.150
    25.958   322.758     0.150
    26.402   330.609     0.150
    30.177  2258.852     0.150
    30.188  2264.070     0.150
    30.195  2260.531     0.150
    31.061  2325.172     0.150
    31.065  2329.977     0.150
    31.079  2328.312     0.150
    32.735     4.398     0.150
    32.735     7.898     0.150
    39.535   444.109     0.150
    42.682   470.211     0.150
    43.911   479.211     0.150
    48.131   513.414     0.150
    48.131   600.211     0.150
    48.181   513.594     0.150
    48.501   517.023     0.150
    61.875   609.414     0.150
    62.657   617.508     0.150
    62.657   617.484     0.150
    64.159   618.508     0.150
    64.159   618.508     0.150
    64.698   630.211     0.150
    64.698   630.211     0.150
    69.733   662.414     0.150
    70.897   669.914     0.150
    85.679   753.008     0.150
     1.871    30.344     0.150
     1.871    51.844     0.150
    23.508    11.602     0.150
    23.508    17.199     0.150
    23.508    32.801     0.150
    23.508   534.141     0.150
    23.508   767.242     0.150
    30.209  2257.273     0.150
    30.220  2259.691     0.150
    30.227  2270.930     0.150
    31.084  2320.344     0.150
    31.088  2322.082     0.150
    31.101  2323.691     0.150
    43.842   480.543     0.150
     0.570    11.320     0.150
     0.570    11.371     0.150
     1.765    54.469     0.150
     4.493    64.969     0.150
     7.245   104.172     0.150
     7.245   104.770     0.150
    14.215   195.672     0.150
    30.050  2252.988     0.150
    30.061  2258.547     0.150
    30.068  2258.965     0.150
    30.938  2324.301     0.150
    30.942  2317.551     0.150
    30.956  2325.957     0.150
    39.671   446.770     0.150
    39.671    13.402     0.150
    42.839   472.570     0.150
    44.038   482.270     0.150
    44.038    14.602     0.150
    44.055   481.871     0.150
    62.706   619.371     0.150
    64.769   632.172     0.150
    66.433   644.270     0.150
    70.460    13.598     0.150
    85.519   753.770     0.150
     0.314    10.258     0.150
     0.314    17.758     0.150
     1.828    44.562     0.150
     1.828    29.758     0.150
     1.828    44.562     0.150
     6.907    98.664     0.150
     6.907    99.453     0.150
     6.907   179.852     0.150
     6.907    99.461     0.150
     6.907   179.859     0.150
     9.559   231.109     0.150
    10.088   711.758     0.150
    12.664   178.062     0.150
    13.000   202.758     0.150
    14.556   199.320     0.150
    14.556   199.359     0.150
    20.370   496.961     0.150
    23.572    14.102     0.150
    23.572    21.203     0.150
    23.572    36.703     0.150
    25.882   325.562     0.150
    26.326   330.258     0.150
    26.326   330.258     0.150
    30.192  2255.242     0.150
    30.203  2257.805     0.150
    30.210  2256.602     0.150
    30.852    17.602     0.150
    30.852    26.805     0.150
    31.070  2324.945     0.150
    31.074  2319.141     0.150
    31.087  2327.188     0.150
    32.608    17.797     0.150
    32.608    26.398     0.150
    33.300   393.461     0.150
    33.300    15.000     0.150
    33.300    22.297     0.150
    33.300   835.461     0.150
    36.483   754.258     0.150
    39.507   444.234     0.150
    39.507   571.484     0.150
    39.507   444.258     0.150
    39.507   571.461     0.150
    40.310   447.258     0.150
    42.617   469.859     0.150
    42.617   469.992     0.150
    42.617   581.492     0.150
    42.617   469.961     0.150
    42.617   581.461     0.150
    43.955   480.258     0.150
    44.019   481.461     0.150
    44.269   484.758     0.150
    44.269   484.758     0.150
    44.374   484.062     0.150
    44.374   484.062     0.150
    48.159   513.961     0.150
    48.159   600.164     0.150
    48.426   516.461     0.150
    48.853   519.062     0.150
    49.112   521.164     0.150
    49.603    15.500     0.150
    49.603    22.602     0.150
    49.754   525.367     0.150
    49.754   525.359     0.150
    51.590   538.758     0.150
    51.739   540.359     0.150
    53.346   615.461     0.150
    53.346  1212.461     0.150
    56.857   577.359     0.150
    57.158   578.859     0.150
    58.609   590.188     0.150
    58.609   590.164     0.150
    61.936   611.758     0.150
    62.481    14.602     0.150
    62.481   617.461     0.150
    62.481    14.602     0.150
    62.481   617.461     0.150
    62.481    14.602     0.150
    64.223   627.359     0.150
    64.671   627.758     0.150
    64.760   631.039     0.150
    64.760   631.062     0.150
    66.208   643.812     0.150
    66.208    13.195     0.150
    66.208   643.812     0.150
    66.208    13.195     0.150
    66.208   643.859     0.150
    66.208    13.203     0.150
    69.815   663.008     0.150
    69.815   663.062     0.150
    70.838   670.891     0.150
    70.924   670.430     0.150
    70.924   670.461     0.150
    76.323   702.859     0.150
    76.323   702.859     0.150
    78.707   715.758     0.150
    78.892   716.312     0.150
    78.892   716.359     0.150
    82.281   734.859     0.150
    84.059   744.258     0.150
    85.104   748.664     0.150
    85.894    14.203     0.150
    85.894   754.508     0.150
    85.894    14.203     0.150
    85.894   754.562     0.150
    85.894    14.195     0.150
    88.775  6691.883     0.150
   114.395  1112.312     0.150
   145.944 10960.062     0.150
   145.958 10962.922     0.150
   145.960 10962.398     0.150
     0.509    11.555     0.150
     4.658    67.555     0.150
     7.174   102.539     0.150
    13.077   183.305     0.150
    29.882  2248.898     0.150
    29.893  2254.172     0.150
    29.900  2250.250     0.150
    30.769  2321.211     0.150
    30.773  2317.945     0.150
    30.786  2324.680     0.150
    33.026   392.102     0.150
    33.026     7.797     0.150
    42.987   473.312     0.150
    42.987   583.484     0.150
    43.735   478.680     0.150
    47.491   510.203     0.150
    47.999   513.602     0.150
    48.478   517.195     0.150
    48.535   516.703     0.150
    48.535   516.703     0.150
    48.541   518.805     0.150
    48.806   519.203     0.150
    48.806   519.219     0.150
    48.889   519.641     0.150
    49.411   524.398     0.150
    49.662   523.805     0.150
    49.662   523.789     0.150
    49.871   529.000     0.150
    50.305   531.898     0.150
    52.111   537.602     0.150
    52.111   537.555     0.150
    57.028   592.305     0.150
    57.028   578.555     0.150
    57.028   592.305     0.150
    62.557   617.648     0.150
    64.918   659.203     0.150
   145.517 10971.469     0.150
   145.531 10973.281     0.150
   145.533 10974.055     0.150
     0.305    10.286     0.150
     0.305    17.616     0.150
     0.926    27.346     0.150
     1.836    45.996     0.150
     1.836    29.896     0.150
     1.836    45.996     0.150
     4.642    65.746     0.150
     4.642   116.656     0.150
     6.902    99.266     0.150
     6.902    99.546     0.150
     8.365   112.446     0.150
    14.562   202.646     0.150
    14.562   202.596     0.150
    26.332   330.346     0.150
    30.185  2257.755     0.150
    30.195  2255.996     0.150
    30.202  2254.528     0.150
    30.854   386.146     0.150
    30.854     4.700     0.150
    30.854     7.200     0.150
    31.062  2322.623     0.150
    31.066  2321.897     0.150
    31.079  2326.767     0.150
    32.612     4.600     0.150
    39.514   443.946     0.150
    39.514   570.946     0.150
    39.514   443.946     0.150
    39.514   570.976     0.150
    42.384   468.546     0.150
    42.623   470.105     0.150
    42.623   470.046     0.150
    42.623   581.646     0.150
    42.623   470.046     0.150
    42.623   581.625     0.150
    44.269   484.996     0.150
    44.269    19.000     0.150
    44.379   483.596     0.150
    47.067   506.746     0.150
    47.575   509.846     0.150
    48.024   513.646     0.150
    48.111   514.446     0.150
    48.432   516.686     0.150
    48.628   518.446     0.150
    48.628   518.446     0.150
    49.449   525.046     0.150
    49.883   527.846     0.150
    50.155   530.046     0.150
    51.745   540.726     0.150
    55.607   567.886     0.150
    56.203   573.446     0.150
    56.203   573.476     0.150
    58.614   590.246     0.150
    58.614    13.950     0.150
    61.944   611.946     0.150
    62.473   617.076     0.150
    62.473    14.900     0.150
    64.232   622.246     0.150
    64.232   622.246     0.150
    64.679   777.846     0.150
    64.769   631.016     0.150
    66.200   643.390     0.150
    66.200   643.386     0.150
    68.488   656.946     0.150
    68.488   656.946     0.150
    69.818   662.806     0.150
    69.824   662.996     0.150
    70.840   672.136     0.150
    70.932   669.646     0.150
    73.078   684.296     0.150
    74.214  1266.846     0.150
    75.313   694.246     0.150
    75.313   694.246     0.150
    75.381   697.146     0.150
    75.687   695.946     0.150
    75.687   695.946     0.150
    76.331   702.546     0.150
    77.115   705.046     0.150
    77.115   705.046     0.150
    77.159   706.846     0.150
    77.652   710.246     0.150
    78.715   716.046     0.150
    78.900   716.526     0.150
    82.029   733.346     0.150
    82.562   736.046     0.150
    83.770   741.946     0.150
    84.068   744.446     0.150
    84.068   744.446     0.150
    84.068   744.446     0.150
    84.249   744.346     0.150
    84.249   744.346     0.150
    84.291   745.046     0.150
    84.291   745.046     0.150
    84.300   745.446     0.150
    84.300   745.446     0.150
    84.321   744.846     0.150
    84.321   744.846     0.150
    84.356   744.646     0.150
    84.356   744.646     0.150
    84.356   744.646     0.150
    84.728   746.946     0.150
    84.728   746.946     0.150
    85.113   749.146     0.150
    85.113   749.146     0.150
    85.447   750.846     0.150
    85.447   750.846     0.150
    85.447   750.846     0.150
    85.595   751.246     0.150
    85.595   751.246     0.150
    85.639   752.146     0.150
    85.639   752.146     0.150
    85.897   754.576     0.150
    85.897    15.670     0.150
    86.425   756.346     0.150
    86.425   756.346     0.150
    89.091   769.146     0.150
    89.091   769.146     0.150
   114.403  1112.776     0.150
   145.942 10964.676     0.150
   145.955 10957.080     0.150
   145.957 10955.416     0.150
   151.746  1188.456     0.150
     1.833    46.189     0.150
     1.833    30.105     0.150
     1.833    53.230     0.150
     6.829    98.209     0.150
     6.829    98.629     0.150
     8.235   213.154     0.150
     9.507   229.730     0.150
     9.997   138.279     0.150
     9.997   247.680     0.150
     9.997   512.080     0.150
     9.997   931.580     0.150
    10.452   274.180     0.150
    12.329   175.680     0.150
    12.329   314.180     0.150
    12.558   320.730     0.150
    12.558   320.730     0.150
    12.904   177.779     0.150
    12.904   194.680     0.150
    12.904   315.480     0.150
    13.237   184.529     0.150
    14.414   214.379     0.150
    14.638   202.350     0.150
    14.638   202.355     0.150
    15.184   364.730     0.150
    15.184   208.654     0.150
    15.184   364.730     0.150
    15.184   364.730     0.150
    19.564   263.205     0.150
    20.268   494.379     0.150
    21.290   296.480     0.150
    21.290   532.879     0.150
    21.290   548.580     0.150
    23.473    17.199     0.150
    23.473    32.799     0.150
    23.473   567.680     0.150
    25.798   321.580     0.150
    26.242   329.141     0.150
    27.863     9.600     0.150
    28.710    16.398     0.150
    28.710   407.580     0.150
    30.255  2259.674     0.150
    30.265  2255.738     0.150
    30.272  2262.881     0.150
    30.749    10.500     0.150
    30.749    14.699     0.150
    30.749   428.480     0.150
    30.749   693.779     0.150
    31.130  2324.428     0.150
    31.134  2326.021     0.150
    31.147  2327.141     0.150
    32.511    11.699     0.150
    32.511    17.199     0.150
    32.511   716.279     0.150
    33.195    13.000     0.150
    33.195    18.900     0.150
    33.195   727.180     0.150
    33.580    12.000     0.150
    33.580    19.701     0.150
    35.727   413.299     0.150
    37.196    12.201     0.150
    37.196    19.102     0.150
    37.196   769.480     0.150
    39.440   443.561     0.150
    39.440   570.680     0.150
    39.440   443.555     0.150
    39.440   570.680     0.150
    40.245   469.080     0.150
    42.471   468.629     0.150
    42.536   469.180     0.150
    42.536   841.879     0.150
    42.536   469.299     0.150
    42.536   581.080     0.150
    42.536   841.910     0.150
    42.536   469.230     0.150
    42.536   581.080     0.150
    42.536   841.904     0.150
    43.750   479.629     0.150
    43.797   479.109     0.150
    43.923   479.779     0.150
    43.925   480.891     0.150
    43.925   479.279     0.150
    44.034   481.230     0.150
    44.164   483.480     0.150
    44.453   484.480     0.150
    48.342   516.020     0.150
    49.183   933.180     0.150
    49.183   521.105     0.150
    49.183   933.180     0.150
    49.199   521.859     0.150
    49.515    12.400     0.150
    49.515    17.299     0.150
    49.671   524.680     0.150
    49.671   524.650     0.150
    49.671   606.980     0.150
    50.096   527.379     0.150
    51.658   540.070     0.150
    53.292  1001.779     0.150
    55.668   569.080     0.150
    56.766   576.580     0.150
    57.209   579.330     0.150
    58.684   590.424     0.150
    58.964   590.580     0.150
    59.510   596.105     0.150
    59.644   597.180     0.150
    59.644   597.180     0.150
    61.907   610.680     0.150
    62.441   616.605     0.150
    63.768   619.080     0.150
    64.196   625.980     0.150
    64.627   769.680     0.150
    64.732   630.504     0.150
    65.420   636.170     0.150
    65.571   638.129     0.150
    66.166   642.820     0.150
    66.168   641.480     0.150
    68.133    13.270     0.150
    68.416   654.650     0.150
    68.416   654.654     0.150
    69.797   662.779     0.150
    69.797   662.805     0.150
    69.903   665.160     0.150
    69.962   663.918     0.150
    70.176   667.170     0.150
    70.176   664.852     0.150
    70.765   660.680     0.150
    70.823   669.361     0.150
    70.879   669.580     0.150
    70.879   669.580     0.150
    70.891   669.240     0.150
    70.936   671.504     0.150
    71.511   676.250     0.150
    72.585   681.250     0.150
    72.946   684.799     0.150
    73.098   681.953     0.150
    73.166   684.730     0.150
    73.673   686.680     0.150
    73.858   688.959     0.150
    73.825   689.080     0.150
    74.485   693.160     0.150
    75.092   695.859     0.150
    75.264   713.680     0.150
    75.264   697.080     0.150
    75.304   696.279     0.150
    75.335   696.779     0.150
    75.639   698.680     0.150
    75.902   700.480     0.150
    75.902   700.480     0.150
    76.125   702.379     0.150
    76.262   702.129     0.150
    76.306   702.680     0.150
    76.598   704.879     0.150
    76.628   704.779     0.150
    76.631   704.879     0.150
    76.667   704.279     0.150
    77.068   729.080     0.150
    77.068   706.879     0.150
    77.068   729.080     0.150
    77.050   708.209     0.150
    77.121   722.680     0.150
    77.121   705.980     0.150
    77.121   728.680     0.150
    77.166   706.879     0.150
    77.362   709.939     0.150
    77.362   707.826     0.150
    77.611   709.980     0.150
    77.611   715.379     0.150
    77.620   709.980     0.150
    77.799   711.180     0.150
    78.169   712.379     0.150
    78.674   733.180     0.150
    78.674   714.561     0.150
    78.674   715.279     0.150
    78.674   722.080     0.150
    78.858   716.879     0.150
    78.858   716.879     0.150
    78.858   716.080     0.150
    78.931   717.779     0.150
    78.931   717.779     0.150
    79.098   718.680     0.150
    79.616   721.180     0.150
    79.642   720.379     0.150
    79.953   721.654     0.150
    80.956   726.879     0.150
    80.956   726.879     0.150
    81.191   728.080     0.150
    81.191   728.080     0.150
    81.283   729.980     0.150
    81.584   730.480     0.150
    81.584   730.480     0.150
    81.995   732.779     0.150
    82.241   734.080     0.150
    82.241   734.080     0.150
    82.255   733.680     0.150
    82.255   733.680     0.150
    82.267   734.279     0.150
    82.528   735.279     0.150
    83.324   740.699     0.150
    83.544   740.680     0.150
    83.544   740.680     0.150
    83.737   741.379     0.150
    83.737    23.102     0.150
    83.775   741.480     0.150
    83.775    22.799     0.150
    83.775   741.480     0.150
    83.775    22.799     0.150
    83.820   741.580     0.150
    83.820   741.580     0.150
    84.035   742.980     0.150
    84.035    23.100     0.150
    84.035   742.980     0.150
    84.035    23.100     0.150
    84.222   743.980     0.150
    84.222   743.980     0.150
    84.253   744.779     0.150
    84.253   744.779     0.150
    84.262   744.980     0.150
    84.262   744.980     0.150
    84.287   744.379     0.150
    84.287    23.000     0.150
    84.287   744.379     0.150
    84.287    23.000     0.150
    84.323   744.680     0.150
    84.323    23.000     0.150
    84.323   744.680     0.150
    84.323    23.000     0.150
    84.695   746.480     0.150
    84.695   746.480     0.150
    84.831   747.180     0.150
    84.831   747.180     0.150
    84.915   747.580     0.150
    84.915   747.580     0.150
    84.956   748.080     0.150
    84.956    23.199     0.150
    84.956   748.080     0.150
    84.956    23.199     0.150
    85.075   748.680     0.150
    85.075   748.680     0.150
    85.141   749.080     0.150
    85.141    22.900     0.150
    85.141   749.080     0.150
    85.141    22.900     0.150
    85.309   749.580     0.150
    85.309   749.580     0.150
    85.407   750.379     0.150
    85.407   750.379     0.150
    85.407   750.379     0.150
    85.559   751.180     0.150
    85.559   751.180     0.150
    85.609   751.580     0.150
    85.609   751.580     0.150
    85.961   752.580     0.150
    85.961   752.580     0.150
    85.992   754.805     0.150
    86.207   753.879     0.150
    86.207    23.000     0.150
    86.207   753.879     0.150
    86.207    23.000     0.150
    86.237   753.779     0.150
    86.237   753.779     0.150
    86.237   753.779     0.150
    86.392   755.980     0.150
    86.392    23.000     0.150
    86.392   755.980     0.150
    86.392    23.000     0.150
    86.525   756.180     0.150
    86.814   757.779     0.150
    86.814    23.100     0.150
    86.814   757.779     0.150
    86.814    23.100     0.150
    87.739   762.180     0.150
    87.739   762.180     0.150
    88.646   765.879     0.150
    88.646   765.879     0.150
    89.059   768.779     0.150
    89.059   768.779     0.150
    89.079   767.480     0.150
    89.079   767.480     0.150
    93.062   786.230     0.150
   114.344  1111.629     0.150
   114.344  1165.779     0.150
   142.842  1165.504     0.150
   151.801  1189.150     0.150
   151.801  1196.410     0.150
    30.179  2256.547     0.150
    30.189  2257.418     0.150
    30.196  2261.500     0.150
    31.054  2322.648     0.150
    31.058  2327.609     0.150
    31.071  2327.852     0.150
    39.516   444.488     0.150
    42.612   469.957     0.150
    48.119   513.223     0.150
    56.208   573.039     0.150
    59.028   591.965     0.150
    61.976   611.863     0.150
    64.264   625.262     0.150
    64.264   625.262     0.150
   145.987 10964.277     0.150
   146.000 10973.262     0.150
   146.002 10966.102     0.150
     1.313    38.039     0.150
     1.985    55.906     0.150
     1.985    31.613     0.150
     1.985    55.914     0.150
     6.699    96.559     0.150
     6.699    96.555     0.150
    12.447   163.938     0.150
    12.507   174.988     0.150
    12.507   174.988     0.150
    12.933   191.836     0.150
    14.765   203.387     0.150
    14.765   203.387     0.150
    20.280   268.996     0.150
    21.436   296.637     0.150
    21.436   507.438     0.150
    21.436   964.738     0.150
    21.642   295.039     0.150
    23.486    14.602     0.150
    23.486    21.402     0.150
    25.858   325.727     0.150
    26.302   329.797     0.150
    26.302   535.246     0.150
    26.302   329.793     0.150
    26.302   535.250     0.150
    26.555   336.418     0.150
    30.159  2256.023     0.150
    30.169  2256.645     0.150
    30.177  2253.266     0.150
    30.748    15.898     0.150
    30.748    25.699     0.150
    31.030  2320.547     0.150
    31.034  2321.711     0.150
    31.048  2327.352     0.150
    32.531    15.000     0.150
    32.531    25.000     0.150
    33.531    17.801     0.150
    33.531    27.000     0.150
    33.531   739.836     0.150
    34.800   405.438     0.150
    37.152    16.402     0.150
    37.152    26.000     0.150
    39.530   444.336     0.150
    39.530   571.668     0.150
    39.530   594.238     0.150
    39.530   444.340     0.150
    39.530   571.664     0.150
    39.530   594.238     0.150
    39.820    18.301     0.150
    39.820    27.402     0.150
    41.455   465.336     0.150
    42.603   469.867     0.150
    42.603   581.836     0.150
    42.603   469.867     0.150
    42.603   581.836     0.150
    42.583   581.867     0.150
    42.583   469.336     0.150
    42.583   581.863     0.150
    43.146   476.258     0.150
    43.879   480.836     0.150
    43.871   481.398     0.150
    43.871   481.438     0.150
    44.109   483.387     0.150
    44.109   483.387     0.150
    44.583   485.586     0.150
    44.583   485.586     0.150
    45.404   493.406     0.150
    48.136   513.926     0.150
    48.136   601.129     0.150
    48.136   513.926     0.150
    48.136   601.125     0.150
    48.235   515.789     0.150
    48.402   516.656     0.150
    48.946   520.738     0.150
    49.001   520.727     0.150
    49.259   521.930     0.150
    49.321   522.336     0.150
    49.564    27.402     0.150
    49.732   526.137     0.150
    51.723   540.668     0.150
    55.580   569.086     0.150
    55.580   569.086     0.150
    55.751   569.137     0.150
    56.227   572.969     0.150
    56.227   572.961     0.150
    58.818   591.641     0.150
    59.651   596.789     0.150
    59.651   596.789     0.150
    62.039   613.438     0.150
    62.287   615.816     0.150
    62.287   615.812     0.150
    62.789   619.438     0.150
    64.865   631.766     0.150
    64.865   631.762     0.150
    65.574   637.539     0.150
    65.574   637.488     0.150
    65.682   638.637     0.150
    65.682   638.629     0.150
    66.014   640.816     0.150
    66.014   640.816     0.150
    66.340   643.727     0.150
    66.340   643.730     0.150
    68.511   656.758     0.150
    68.511   656.762     0.150
    68.915   658.027     0.150
    69.937   663.836     0.150
    69.937   663.859     0.150
    69.937   663.863     0.150
    70.997   670.328     0.150
    70.997   670.328     0.150
    71.009   670.418     0.150
    71.029   672.965     0.150
    73.275   685.539     0.150
    73.947   688.336     0.150
    74.575   694.336     0.150
    74.674   693.148     0.150
    74.674   693.137     0.150
    75.043   695.539     0.150
    75.385   696.539     0.150
    75.465   698.238     0.150
    75.761   699.539     0.150
    75.794   721.738     0.150
    75.887   700.539     0.150
    76.360   703.309     0.150
    76.432   703.238     0.150
    76.722   705.336     0.150
    76.724   704.188     0.150
    76.729   705.559     0.150
    76.756   705.438     0.150
    76.759   726.637     0.150
    76.759   705.438     0.150
    77.192   707.637     0.150
    77.252   707.137     0.150
    77.252    21.500     0.150
    77.296   706.836     0.150
    77.296   706.836     0.150
    77.740   731.137     0.150
    77.740   710.637     0.150
    78.803   731.637     0.150
    78.803   716.438     0.150
    78.987   717.039     0.150
    79.643   721.547     0.150
    79.643   721.551     0.150
    79.730   721.938     0.150
    80.102   723.137     0.150
    81.718   731.738     0.150
    81.718   731.738     0.150
    82.129   734.137     0.150
    82.374   734.738     0.150
    82.374   734.738     0.150
    82.388   734.938     0.150
    82.388   734.938     0.150
    82.402   735.539     0.150
    83.872   742.738     0.150
    83.914   742.738     0.150
    83.914   742.738     0.150
    83.959   743.039     0.150
    83.959   743.039     0.150
    84.170   744.336     0.150
    84.170   744.336     0.150
    84.361   745.336     0.150
    84.361   745.336     0.150
    84.385   746.137     0.150
    84.385   746.137     0.150
    84.394   746.336     0.150
    84.394   746.336     0.150
    84.422   745.738     0.150
    84.422   745.738     0.150
    84.458   746.039     0.150
    84.458   746.039     0.150
    84.830   748.238     0.150
    84.830   748.238     0.150
    84.972   748.738     0.150
    84.972   748.738     0.150
    85.046   748.738     0.150
    85.046   748.738     0.150
    85.097   749.539     0.150
    85.097   749.539     0.150
    85.207   750.137     0.150
    85.207   750.137     0.150
    85.277   750.336     0.150
    85.277   750.336     0.150
    85.449   750.938     0.150
    85.449   750.938     0.150
    85.536   750.938     0.150
    85.536   750.938     0.150
    85.692   752.539     0.150
    85.692   752.539     0.150
    85.747   752.836     0.150
    85.747   752.836     0.150
    86.045   754.738     0.150
    86.045   754.738     0.150
    86.092   753.637     0.150
    86.092   753.637     0.150
    86.130   754.637     0.150
    86.088   755.738     0.150
    86.338   755.137     0.150
    86.338   755.137     0.150
    86.373   756.039     0.150
    86.373   756.039     0.150
    86.527   757.238     0.150
    86.527   757.238     0.150
    86.658   757.539     0.150
    86.950   759.238     0.150
    86.950   759.238     0.150
    87.873   763.539     0.150
    87.873   763.539     0.150
    89.195   770.137     0.150
    89.195   770.137     0.150
    93.200   788.039     0.150
   102.376   830.109     0.150
   102.376   830.113     0.150
   114.454  1113.039     0.150
   123.233  1130.188     0.150
   123.233  1130.188     0.150
   123.703  1130.836     0.150
   131.883  1145.859     0.150
   145.976  1171.879     0.150
   145.976  1171.875     0.150
   146.056 10961.266     0.150
   146.070 10972.727     0.150
   146.072 10966.445     0.150
   146.751  1176.297     0.150
   151.946  1188.996     0.150
   151.946  1188.996     0.150
   157.061  1219.789     0.150
   157.061  1219.789     0.150
     0.780    24.406     0.150
     1.554    25.832     0.150
    26.399   330.007     0.150
    26.399   329.997     0.150
    30.248  2265.126     0.150
    30.259  2265.896     0.150
    30.266  2262.929     0.150
    31.138  2330.975     0.150
    31.142  2331.192     0.150
    31.156  2332.235     0.150
    39.480   445.557     0.150
    42.666   471.356     0.150
    43.938   481.957     0.150
    59.276   595.557     0.150
    61.737   612.307     0.150
    62.877   621.432     0.150
    64.557   630.781     0.150
    85.484   754.057     0.150
    85.484    12.575     0.150
     0.819    15.707     0.150
     1.340    39.707     0.150
     1.802    29.258     0.150
     3.198    48.309     0.150
     3.198    87.508     0.150
     4.629    68.605     0.150
     4.629    74.707     0.150
     5.047    76.207     0.150
     5.047   133.309     0.150
    11.997   170.777     0.150
    11.997   304.801     0.150
    14.979   207.980     0.150
    21.485   282.207     0.150
    25.674   325.488     0.150
    30.745  2333.352     0.150
    30.756  2333.543     0.150
    30.763  2335.402     0.150
    31.610  2410.227     0.150
    31.613  2395.875     0.150
    31.627  2410.652     0.150
    34.217   401.309     0.150
    38.935   440.824     0.150
    38.935   569.207     0.150
    41.979   466.094     0.150
    43.271   476.309     0.150
    47.546   510.199     0.150
    55.639   569.809     0.150
    59.250   594.527     0.150
    61.577   610.605     0.150
    62.390   616.832     0.150
    63.875   624.809     0.150
    64.407   629.957     0.150
    66.117   640.008     0.150
    66.117   639.957     0.150
    69.523   662.605     0.150
    70.471   668.230     0.150
    76.783   704.707     0.150
    78.505   716.105     0.150
    78.505   716.090     0.150
    86.452   758.184     0.150
     0.445    14.436     0.150
     0.840    17.436     0.150
     0.992    18.336     0.150
     1.155    21.636     0.150
     1.155    37.036     0.150
     1.196    21.436     0.150
     1.196    37.036     0.150
     1.255    38.836     0.150
     1.203    37.036     0.150
     1.823    62.396     0.150
     1.823    31.686     0.150
     3.477    57.836     0.150
     3.477    99.336     0.150
     5.304   145.436     0.150
     6.452    98.836     0.150
     6.452    98.523     0.150
     9.021   138.336     0.150
     9.021   254.736     0.150
     9.021   516.036     0.150
     9.021   728.236     0.150
    11.672   301.036     0.150
    11.672   170.786     0.150
    11.672   301.011     0.150
    11.672   170.786     0.150
    13.423   200.936     0.150
    13.423   351.836     0.150
    15.149   213.161     0.150
    15.557   234.136     0.150
    15.583   395.236     0.150
    16.683   233.266     0.150
    22.480     8.200     0.150
    22.480    28.100     0.150
    22.480   537.836     0.150
    23.484   308.761     0.150
    25.293   324.876     0.150
    26.900   322.036     0.150
    27.214   617.336     0.150
    29.763     5.900     0.150
    29.763    10.600     0.150
    31.094  2333.996     0.150
    31.105  2334.725     0.150
    31.112  2336.457     0.150
    31.518   379.036     0.150
    31.518   684.036     0.150
    31.953  2406.211     0.150
    31.957  2406.387     0.150
    31.970  2407.459     0.150
    32.237   390.236     0.150
    32.237     4.400     0.150
    32.237     7.000     0.150
    32.237   813.836     0.150
    38.581   441.611     0.150
    38.581   574.011     0.150
    38.804     4.600     0.150
    38.804     7.000     0.150
    41.602   466.806     0.150
    41.602   583.986     0.150
    41.602   466.761     0.150
    42.166   472.936     0.150
    42.908   477.146     0.150
    43.037   478.816     0.150
    43.037   479.636     0.150
    43.279   481.686     0.150
    44.129   486.646     0.150
    44.493   490.046     0.150
    44.913   493.186     0.150
    46.943   509.186     0.150
    47.196   511.023     0.150
    47.196   603.023     0.150
    47.393   513.436     0.150
    47.393   513.456     0.150
    47.965   519.306     0.150
    47.994   518.576     0.150
    48.250   519.396     0.150
    48.546     3.400     0.150
    48.546     6.200     0.150
    48.546   613.636     0.150
    48.724   523.616     0.150
    48.724   523.536     0.150
    48.724   608.986     0.150
    48.789   525.436     0.150
    48.998   526.506     0.150
    49.549   529.361     0.150
    50.721   537.846     0.150
    51.303   991.136     0.150
    51.303  1128.036     0.150
    52.104   546.936     0.150
    52.222   546.636     0.150
    55.275   569.706     0.150
    55.275   569.736     0.150
    55.275   569.711     0.150
    55.291   572.436     0.150
    55.790   575.556     0.150
    57.345   586.166     0.150
    57.345   586.161     0.150
    58.480   592.436     0.150
    58.480   592.436     0.150
    59.029   597.861     0.150
    59.093   598.581     0.150
    61.315   613.736     0.150
    62.424   621.536     0.150
    63.618   628.436     0.150
    64.148   632.486     0.150
    64.148   632.488     0.150
    65.051   638.476     0.150
    65.294   640.136     0.150
    66.152   646.686     0.150
    67.557  1456.136     0.150
    67.574   655.966     0.150
    67.574   655.961     0.150
    68.941   665.286     0.150
    69.292   665.236     0.150
    69.292   665.561     0.150
    69.472   663.136     0.150
    69.957   665.136     0.150
    69.957    10.400     0.150
    69.957  1209.936     0.150
    70.166   670.861     0.150
    70.166   670.856     0.150
    70.178   670.186     0.150
    70.650   674.976     0.150
    70.790   675.586     0.150
    71.637   683.136     0.150
    71.667   680.776     0.150
    72.493   683.956     0.150
    72.556   684.846     0.150
    73.732   693.036     0.150
    74.465   698.356     0.150
    74.577   697.636     0.150
    74.666   699.136     0.150
    74.675   697.286     0.150
    74.675   698.536     0.150
    74.922   700.061     0.150
    75.070   701.336     0.150
    75.435   874.036     0.150
    75.435   703.186     0.150
    75.435   873.986     0.150
    75.654   709.436     0.150
    75.654   704.536     0.150
    75.716   703.436     0.150
    75.716   703.466     0.150
    75.950   704.236     0.150
    75.950   707.136     0.150
    75.950   704.256     0.150
    75.939   704.236     0.150
    75.939   704.256     0.150
    75.996   705.336     0.150
    75.996   705.326     0.150
    75.996   711.836     0.150
    75.996   706.836     0.150
    76.385   707.136     0.150
    76.385   707.086     0.150
    76.511   713.686     0.150
    76.511   709.136     0.150
    76.511   713.736     0.150
    76.517   714.036     0.150
    76.517   708.636     0.150
    76.545   709.636     0.150
    76.545     3.100     0.150
    76.794   711.586     0.150
    76.978   713.236     0.150
    76.978   713.236     0.150
    76.985   717.036     0.150
    76.985   711.636     0.150
    77.040   712.636     0.150
    77.161   718.236     0.150
    77.161   712.936     0.150
    77.570   715.436     0.150
    77.993   715.436     0.150
    77.993   715.426     0.150
    78.048   723.536     0.150
    78.048   717.836     0.150
    78.048   716.396     0.150
    78.230   719.136     0.150
    78.230   719.136     0.150
    78.230   718.861     0.150
    78.310   719.936     0.150
    78.310   719.936     0.150
    78.494   721.036     0.150
    78.494     4.600     0.150
    78.496   719.036     0.150
    78.505   722.736     0.150
    78.805   720.946     0.150
    79.063   723.636     0.150
    79.527   724.736     0.150
    79.589   724.716     0.150
    79.725   727.536     0.150
    80.110   728.336     0.150
    80.314   728.336     0.150
    80.314   728.306     0.150
    80.486   729.406     0.150
    80.690   732.436     0.150
    80.998   733.316     0.150
    81.001   732.686     0.150
    81.473   734.836     0.150
    81.864   736.326     0.150
    82.061   736.436     0.150
    82.957   743.236     0.150
    83.453   746.128     0.150
    83.965   748.496     0.150
    84.789   753.136     0.150
    85.076   753.636     0.150
    85.393   754.336     0.150
    85.393   754.286     0.150
    85.681   757.636     0.150
    86.200  6468.836     0.150
    86.700   760.936     0.150
    86.700   763.706     0.150
    86.700   763.711     0.150
    87.773   766.286     0.150
    91.145  6841.836     0.150
    92.478   788.886     0.150
    92.522   789.861     0.150
   101.363   830.411     0.150
   122.386  1134.326     0.150
   124.448  1138.674     0.150
   132.167  1151.384     0.150
   145.929  1176.826     0.150
   147.028 11084.993     0.150
   147.042 11085.992     0.150
   147.044 11085.938     0.150
   152.041  1194.266     0.150
   155.936  1220.486     0.150
   155.936  1220.486     0.150
     0.328    31.680     0.150
     1.035    30.883     0.150
     1.808    54.484     0.150
     1.808    29.359     0.150
     1.808    54.508     0.150
     4.520    78.281     0.150
     7.266   104.164     0.150
    13.093   188.906     0.150
    26.628   334.094     0.150
    29.991  2256.188     0.150
    30.002  2256.242     0.150
    30.009  2253.977     0.150
    30.880  2320.203     0.150
    30.884  2323.008     0.150
    30.898  2321.750     0.150
    39.732   446.406     0.150
    42.902   472.844     0.150
    48.323   514.680     0.150
    48.323   514.672     0.150
    56.904   577.961     0.150
    62.697   618.445     0.150
    64.816   631.406     0.150
    69.829   663.492     0.150
   145.540 10928.219     0.150
   145.554 10928.914     0.150
   145.556 10929.734     0.150
     0.284     9.957     0.150
     0.284    18.234     0.150
     1.858    29.910     0.150
     6.853    99.105     0.150
     6.853    99.109     0.150
    12.614   176.883     0.150
    14.611   205.336     0.150
    14.611   205.340     0.150
    26.305   329.914     0.150
    26.305   329.914     0.150
    30.197  2254.855     0.150
    30.208  2255.023     0.150
    30.215  2256.777     0.150
    31.074  2325.859     0.150
    31.077  2326.172     0.150
    31.091  2327.160     0.150
    39.499   444.137     0.150
    39.499   571.785     0.150
    39.499   444.137     0.150
    39.499   571.785     0.150
    42.599   468.613     0.150
    42.599   469.887     0.150
    42.599   581.285     0.150
    42.599   469.887     0.150
    42.599   581.289     0.150
    44.219   483.844     0.150
    44.219   483.844     0.150
    44.428   484.727     0.150
    44.428   484.719     0.150
    47.024   506.285     0.150
    47.532   510.387     0.150
    48.101   513.125     0.150
    48.101   600.496     0.150
    48.101   513.121     0.150
    48.101   600.496     0.150
    48.152   511.445     0.150
    48.406   515.484     0.150
    48.406   515.445     0.150
    48.586   518.184     0.150
    48.586   518.184     0.150
    48.610   518.086     0.150
    49.262   518.285     0.150
    49.409   524.586     0.150
    49.842   527.684     0.150
    51.721   540.445     0.150
    53.346   550.965     0.150
    57.206   579.457     0.150
    57.206   579.461     0.150
    59.546   595.914     0.150
    59.546   595.910     0.150
    62.437   616.805     0.150
    62.437   616.809     0.150
    64.238   627.684     0.150
    64.775   631.184     0.150
    65.434   636.984     0.150
    66.163   641.855     0.150
    66.163   641.852     0.150
    68.474   655.836     0.150
    68.474   655.836     0.150
    69.835   663.156     0.150
    69.835   663.152     0.150
    70.929   670.266     0.150
    70.929   670.262     0.150
    73.129   684.625     0.150
    74.962   692.375     0.150
    76.319   702.637     0.150
    76.319   702.637     0.150
    78.904   716.484     0.150
    84.296   744.586     0.150
    84.364   745.086     0.150
    84.364   745.086     0.150
    85.950   754.277     0.150
    86.433   756.387     0.150
    86.433   756.387     0.150
    89.099   769.086     0.150
    89.099   769.086     0.150
   145.985 10960.488     0.150
   145.998 10960.762     0.150
   146.001 10965.566     0.150
     1.217    37.141     0.150
     1.870    30.484     0.150
     1.870    53.961     0.150
     2.985    45.734     0.150
     4.848    73.641     0.150
     4.848   129.438     0.150
     6.631    97.562     0.150
    12.279   176.789     0.150
    14.851   206.984     0.150
    21.509   284.266     0.150
    26.016   329.555     0.150
    30.428  2264.180     0.150
    30.438  2266.641     0.150
    30.446  2271.500     0.150
    31.296  2327.719     0.150
    31.300  2333.141     0.150
    31.314  2333.719     0.150
    39.257   444.938     0.150
    42.318   469.516     0.150
    43.885   483.172     0.150
    44.658   487.984     0.150
    47.865   513.750     0.150
    48.973   522.531     0.150
    58.878   593.930     0.150
    61.823   612.734     0.150
    62.342   617.734     0.150
    64.651   632.086     0.150
    70.753   671.266     0.150
    86.246   755.734     0.150
    86.246   755.766     0.150
   146.324 10972.320     0.150
   146.338 10975.055     0.150
   146.340 10972.984     0.150
     0.154     8.695     0.150
     0.154    14.992     0.150
     0.304    10.391     0.150
     0.304    10.391     0.150
     0.922    27.992     0.150
     1.153    19.891     0.150
     1.153    34.695     0.150
     1.837    29.852     0.150
     1.837    51.516     0.150
     1.837    29.922     0.150
     1.837    51.516     0.150
     2.665    40.789     0.150
     2.665    71.492     0.150
     2.665    40.789     0.150
     2.665    71.492     0.150
     2.895    42.391     0.150
     3.157    46.992     0.150
     3.157    82.594     0.150
     3.403    49.594     0.150
     4.532    68.195     0.150
     4.532    68.195     0.150
     4.532   119.492     0.150
     4.646    68.992     0.150
     4.646   119.992     0.150
     4.646    68.992     0.150
     4.646   119.992     0.150
     6.551    94.992     0.150
     6.885    98.594     0.150
     6.885    98.539     0.150
     6.885    98.594     0.150
     6.885    98.391     0.150
     6.885   177.094     0.150
     6.885    98.969     0.150
     6.885   179.516     0.150
     6.885    98.969     0.150
     6.885   179.516     0.150
     8.277   211.094     0.150
     8.277   118.289     0.150
     8.312   216.969     0.150
     8.354   212.594     0.150
    10.073   143.844     0.150
    10.503   144.789     0.150
    12.264   165.992     0.150
    12.641   322.555     0.150
    12.641   322.562     0.150
    12.983   198.492     0.150
    14.579   199.891     0.150
    14.579   199.891     0.150
    14.960   375.891     0.150
    20.351    19.305     0.150
    20.351   495.094     0.150
    21.305    22.000     0.150
    21.305   520.195     0.150
    21.305   953.195     0.150
    21.368   279.867     0.150
    21.368   511.266     0.150
    21.782   525.992     0.150
    22.159   308.492     0.150
    23.554    15.000     0.150
    23.554    36.805     0.150
    23.554   554.992     0.150
    23.554   570.891     0.150
    25.804   595.492     0.150
    26.313   329.914     0.150
    26.313   535.156     0.150
    26.611   327.594     0.150
    27.831   364.195     0.150
    27.948   621.391     0.150
    28.174   346.023     0.150
    28.349   535.891     0.150
    30.198  2261.164     0.150
    30.209  2264.828     0.150
    30.216  2263.984     0.150
    30.832    13.000     0.150
    30.832    22.805     0.150
    30.832   674.992     0.150
    31.075  2322.133     0.150
    31.079  2322.438     0.150
    31.093  2332.852     0.150
    32.591    15.000     0.150
    32.591    22.000     0.150
    33.279    22.203     0.150
    33.663    13.805     0.150
    33.663    20.500     0.150
    36.459   424.773     0.150
    39.500   444.164     0.150
    39.500   571.273     0.150
    39.500   793.625     0.150
    39.500   444.164     0.150
    39.500   571.266     0.150
    39.500   793.617     0.150
    39.842    12.000     0.150
    39.842    20.898     0.150
    42.605   469.922     0.150
    42.605   581.523     0.150
    42.605   469.914     0.150
    42.605   581.516     0.150
    43.234   476.953     0.150
    43.860   479.695     0.150
    44.008   482.172     0.150
    44.246   484.391     0.150
    44.246   588.141     0.150
    44.246   814.289     0.150
    44.396   483.961     0.150
    44.396   812.891     0.150
    48.152   513.836     0.150
    48.152   600.594     0.150
    48.414   516.594     0.150
    49.108   536.992     0.150
    49.270   522.859     0.150
    49.270   522.422     0.150
    49.589  1157.094     0.150
    49.742   526.141     0.150
    51.728   540.516     0.150
    53.342  1224.391     0.150
    53.342   552.305     0.150
    55.744   571.102     0.150
    57.176   579.219     0.150
    58.432   643.391     0.150
    58.630   590.234     0.150
    58.984   592.094     0.150
    59.530   595.766     0.150
    60.630   602.594     0.150
    61.153   610.695     0.150
    61.938   612.695     0.150
    62.154   615.211     0.150
    62.454   615.289     0.150
    62.454   615.242     0.150
    62.454    16.930     0.150
    62.465   616.469     0.150
    62.465  2366.117     0.150
    64.226   627.094     0.150
    64.454   629.242     0.150
    64.669   630.469     0.150
    64.762   630.820     0.150
    64.816   633.031     0.150
    65.409   635.891     0.150
    66.192   642.078     0.150
    66.192  2358.508     0.150
    66.992   645.695     0.150
    67.000   646.766     0.150
    68.453   656.070     0.150
    68.474   656.312     0.150
    68.474   656.312     0.150
    68.601   656.086     0.150
    68.727   656.500     0.150
    68.884   655.992     0.150
    69.820   662.789     0.150
    69.820   662.914     0.150
    69.827   664.852     0.150
    70.108   666.414     0.150
    70.356   926.195     0.150
    70.356  1210.391     0.150
    70.356  1678.195     0.150
    70.861   671.367     0.150
    70.922   669.789     0.150
    70.922   669.789     0.150
    70.922   669.609     0.150
    71.348   672.039     0.150
    71.423   673.031     0.150
    71.744   676.781     0.150
    72.982   684.000     0.150
    73.097   684.289     0.150
    73.404   683.789     0.150
    73.734   687.594     0.150
    73.729   688.453     0.150
    74.016   688.492     0.150
    74.416   690.945     0.150
    74.592   692.789     0.150
    74.592   692.695     0.150
    75.021   695.812     0.150
    75.075   695.289     0.150
    75.304   696.289     0.150
    75.304   696.195     0.150
    75.381   697.195     0.150
    75.678   698.289     0.150
    75.678   698.289     0.150
    76.287   725.289     0.150
    76.287   702.195     0.150
    76.317   868.492     0.150
    76.317   702.641     0.150
    76.317   868.492     0.150
    76.343   724.695     0.150
    76.343   702.391     0.150
    76.634   704.211     0.150
    76.662   727.891     0.150
    76.662   704.492     0.150
    76.666   727.789     0.150
    76.666   704.695     0.150
    76.684   704.852     0.150
    76.703   725.492     0.150
    76.703   704.695     0.150
    76.703    20.797     0.150
    77.104   706.664     0.150
    77.153   706.492     0.150
    77.153    22.398     0.150
    77.153  1382.992     0.150
    77.153  1642.992     0.150
    77.158   706.594     0.150
    77.200   730.992     0.150
    77.200   707.492     0.150
    77.306   706.594     0.150
    77.293   709.062     0.150
    77.484   710.008     0.150
    77.645   714.094     0.150
    77.645   732.992     0.150
    77.645   709.992     0.150
    77.674   710.891     0.150
    77.834   734.094     0.150
    77.834   710.992     0.150
    78.234   735.391     0.150
    78.234   712.992     0.150
    78.507   707.492     0.150
    78.708   738.789     0.150
    78.708   715.891     0.150
    78.708   724.992     0.150
    78.893   716.445     0.150
    78.893   885.617     0.150
    79.007   717.086     0.150
    79.369   718.164     0.150
    79.502   721.234     0.150
    80.809   726.500     0.150
    80.983   727.195     0.150
    80.983   727.195     0.150
    81.208   728.195     0.150
    81.217   728.492     0.150
    81.217   728.492     0.150
    81.313   729.219     0.150
    81.614   730.992     0.150
    81.614   730.992     0.150
    81.823   731.609     0.150
    81.823    17.039     0.150
    82.023   733.289     0.150
    82.271   733.891     0.150
    82.271   733.891     0.150
    82.284   734.195     0.150
    82.284   734.195     0.150
    82.556   735.789     0.150
    83.574   741.094     0.150
    83.574   741.094     0.150
    83.765   741.891     0.150
    83.798   741.891     0.150
    83.798   741.891     0.150
    83.844   742.094     0.150
    83.844   742.094     0.150
    84.062   743.492     0.150
    84.062   743.492     0.150
    84.164   744.391     0.150
    84.245   744.492     0.150
    84.245   744.492     0.150
    84.284   745.289     0.150
    84.284   745.289     0.150
    84.294   745.492     0.150
    84.294   745.492     0.150
    84.315   744.891     0.150
    84.315   744.891     0.150
    84.350   745.195     0.150
    84.350   745.195     0.150
    84.702   747.164     0.150
    84.702   747.484     0.150
    84.722   746.992     0.150
    84.722   746.992     0.150
    84.853   747.891     0.150
    84.853   747.891     0.150
    84.947   748.094     0.150
    84.947   748.094     0.150
    84.977   748.695     0.150
    84.977   748.695     0.150
    85.106   749.391     0.150
    85.106   749.391     0.150
    85.168   749.492     0.150
    85.168   749.492     0.150
    85.180  6381.391     0.150
    85.330   750.094     0.150
    85.330   750.094     0.150
    85.378   752.094     0.150
    85.440   750.094     0.150
    85.440   750.094     0.150
    85.570   752.289     0.150
    85.589   751.695     0.150
    85.589   751.695     0.150
    85.634   751.992     0.150
    85.634   751.992     0.150
    85.918   754.617     0.150
    86.030   755.594     0.150
    86.030   755.594     0.150
    86.240   754.391     0.150
    86.240   754.391     0.150
    86.265   755.195     0.150
    86.265   755.195     0.150
    86.419   756.492     0.150
    86.419   756.492     0.150
    86.555   756.695     0.150
    86.841   758.391     0.150
    86.841   758.391     0.150
    88.674   767.391     0.150
    88.674   767.391     0.150
    89.085   769.195     0.150
    89.085   769.195     0.150
    89.105   769.094     0.150
    89.105   769.094     0.150
    90.172  6760.094     0.150
    91.561   779.820     0.150
    93.088   787.070     0.150
   114.392  1161.594     0.150
   114.392  1112.641     0.150
   114.392  1161.594     0.150
   120.123  1122.945     0.150
   123.161  1129.922     0.150
   124.831  1132.789     0.150
   142.642  1181.594     0.150
   142.768  1166.742     0.150
   143.656  1168.812     0.150
   145.964 10971.469     0.150
   145.977 10972.344     0.150
   145.980 10973.008     0.150
   151.759  1188.500     0.150
   151.759  1197.219     0.150
   154.861  1186.844     0.150
   154.861  1195.297     0.150
   154.861  1208.867     0.150
   156.890  1219.570     0.150
     1.763    29.059     0.150
     1.763    51.059     0.150
     4.560   124.758     0.150
     6.996   185.766     0.150
     6.996   100.156     0.150
     6.996   185.758     0.150
    21.268   278.457     0.150
    26.335   330.059     0.150
    30.208  2252.383     0.150
    30.219  2257.078     0.150
    30.226  2253.898     0.150
    31.089  2331.141     0.150
    31.093  2334.969     0.150
    31.106  2329.883     0.150
    39.496   444.156     0.150
    39.496   570.656     0.150
    42.621   469.957     0.150
    42.621   581.059     0.150
    44.286   483.258     0.150
    48.064   513.258     0.150
    49.026   519.656     0.150
    49.921   527.156     0.150
    59.470   594.957     0.150
    62.563   617.656     0.150
    64.714   630.258     0.150
    68.465   655.258     0.150
    69.762   661.859     0.150
    85.813   753.656     0.150
    85.813    16.902     0.150
     0.938    28.938     0.150
     6.830    98.438     0.150
    12.586   174.938     0.150
    21.412   280.133     0.150
    26.285   329.336     0.150
    28.154   348.836     0.150
    30.211  2256.070     0.150
    30.222  2260.031     0.150
    30.229  2260.570     0.150
    31.087  2324.336     0.150
    31.090  2323.555     0.150
    31.104  2327.047     0.150
    39.484   444.336     0.150
    42.580   473.133     0.150
    44.190   483.633     0.150
    44.452   481.633     0.150
    44.452   481.633     0.150
    59.545   595.336     0.150
    69.834   663.234     0.150
    70.921   668.023     0.150
    70.921   671.039     0.150
    85.977   754.938     0.150
     0.200    16.289     0.150
     0.929    28.887     0.150
     1.147    19.188     0.150
     1.423    22.688     0.150
     1.852    54.137     0.150
     4.668    68.949     0.150
     6.842    98.387     0.150
     8.346   119.789     0.150
     9.506   230.090     0.150
    10.041   934.289     0.150
    10.041   246.828     0.150
    10.481   149.262     0.150
    11.268   288.688     0.150
    11.771   166.785     0.150
    11.901   169.676     0.150
    11.973   169.582     0.150
    11.998   170.207     0.150
    12.050   170.836     0.150
    12.192   172.555     0.150
    12.204   173.426     0.150
    12.310   164.988     0.150
    12.494   176.379     0.150
    12.594   324.090     0.150
    12.594   177.488     0.150
    12.594   324.090     0.150
    12.579   178.426     0.150
    12.594   324.090     0.150
    12.594   177.488     0.150
    12.594   324.090     0.150
    12.594   511.188     0.150
    12.947   194.289     0.150
    14.456   366.590     0.150
    14.623   200.387     0.150
    15.005   210.387     0.150
    15.005   382.488     0.150
    15.174   205.477     0.150
    17.633   238.898     0.150
    20.310   496.090     0.150
    20.321   267.309     0.150
    21.315   297.488     0.150
    21.315   505.988     0.150
    21.315   277.988     0.150
    21.315   508.039     0.150
    21.735    12.500     0.150
    21.735    16.203     0.150
    21.735   525.988     0.150
    22.139   310.688     0.150
    23.516    18.598     0.150
    23.516   562.387     0.150
    24.300   308.918     0.150
    25.757   585.887     0.150
    26.285   329.887     0.150
    26.285   535.289     0.150
    27.810   364.188     0.150
    27.904     8.598     0.150
    27.904   628.789     0.150
    27.904   700.988     0.150
    28.152   363.488     0.150
    28.152   399.387     0.150
    28.152   346.797     0.150
    28.152   539.910     0.150
    28.709   411.688     0.150
    30.215  2259.875     0.150
    30.225  2257.004     0.150
    30.233  2261.223     0.150
    30.791     8.898     0.150
    30.791    12.500     0.150
    30.791   683.090     0.150
    31.090  2326.406     0.150
    31.094  2323.738     0.150
    31.108  2329.094     0.150
    31.237   369.789     0.150
    31.237   669.289     0.150
    33.234    12.199     0.150
    33.617    11.699     0.150
    33.617    15.500     0.150
    33.617   731.789     0.150
    36.411     8.801     0.150
    36.411    12.500     0.150
    37.233   759.789     0.150
    39.481   444.387     0.150
    39.481   571.488     0.150
    39.481   794.387     0.150
    39.812    10.000     0.150
    39.812    14.000     0.150
    39.812   824.488     0.150
    41.491   465.988     0.150
    42.977   475.566     0.150
    43.192   476.598     0.150
    43.497   475.020     0.150
    43.629   477.727     0.150
    43.629   585.207     0.150
    43.690   478.828     0.150
    43.733   478.316     0.150
    43.839   585.879     0.150
    44.086   481.699     0.150
    48.084   513.789     0.150
    48.084   601.090     0.150
    48.134   514.270     0.150
    48.386   516.918     0.150
    48.386   516.887     0.150
    49.080   532.488     0.150
    49.174   519.887     0.150
    49.174   519.859     0.150
    49.242   523.059     0.150
    49.558     9.797     0.150
    49.558  1115.590     0.150
    49.714   524.988     0.150
    49.714   524.977     0.150
    50.117   528.859     0.150
    51.701   540.910     0.150
    52.117   665.590     0.150
    53.330   552.590     0.150
    53.330   552.547     0.150
    54.568   560.938     0.150
    55.622   567.988     0.150
    55.703   569.328     0.150
    56.172   572.887     0.150
    56.580  1043.699     0.150
    56.810   577.559     0.150
    57.210   579.508     0.150
    57.857   584.090     0.150
    58.436   634.488     0.150
    58.436  1308.488     0.150
    58.672   589.574     0.150
    58.672   589.590     0.150
    59.536   596.289     0.150
    59.685    25.000     0.150
    59.685  1080.488     0.150
    60.650   603.387     0.150
    61.162  1103.648     0.150
    63.803   639.590     0.150
    63.803   646.789     0.150
    63.846   627.047     0.150
    64.662   864.688     0.150
    64.662   630.816     0.150
    65.432   636.727     0.150
    65.550   636.660     0.150
    66.244   791.887     0.150
    66.244   879.887     0.150
    66.244  1162.488     0.150
    66.219   642.816     0.150
    67.012   646.090     0.150
    67.003   647.160     0.150
    68.223   654.828     0.150
    68.417   654.090     0.150
    68.422   656.887     0.150
    68.436  1453.688     0.150
    68.456   656.188     0.150
    68.621   657.090     0.150
    68.843   657.887     0.150
    68.880   656.488     0.150
    68.880   904.488     0.150
    68.880  1192.488     0.150
    68.880  1646.488     0.150
    69.553   663.590     0.150
    69.550   661.660     0.150
    69.817   663.188     0.150
    69.825   663.188     0.150
    69.825   663.188     0.150
    69.875   665.227     0.150
    70.300   667.859     0.150
    70.547   668.188     0.150
    70.804  1221.387     0.150
    71.140   671.387     0.150
    71.267   673.688     0.150
    71.428  1229.559     0.150
    71.721   674.359     0.150
    72.012   678.559     0.150
    72.465  1296.488     0.150
    72.557   680.539     0.150
    72.604   679.719     0.150
    72.713   681.840     0.150
    73.030   683.328     0.150
    73.107   685.160     0.150
    73.405   684.887     0.150
    73.577   686.289     0.150
    73.710  1252.488     0.150
    73.710   687.488     0.150
    73.710   704.488     0.150
    73.710  1252.488     0.150
    73.710  1312.488     0.150
    73.793   687.887     0.150
    73.773   696.250     0.150
    73.826   685.340     0.150
    73.830   689.324     0.150
    73.830   689.367     0.150
    74.015   689.188     0.150
    74.087   688.359     0.150
    74.205   690.090     0.150
    74.433   693.129     0.150
    74.459   691.090     0.150
    74.561   690.418     0.150
    75.068   696.398     0.150
    75.368   697.289     0.150
    75.376   697.590     0.150
    75.517   719.789     0.150
    75.517   981.590     0.150
    75.517  1270.789     0.150
    75.517  1758.188     0.150
    75.721   698.758     0.150
    75.774   700.090     0.150
    76.301   865.914     0.150
    76.329   703.789     0.150
    76.339   709.590     0.150
    76.339   721.090     0.150
    76.339   702.488     0.150
    76.339  1282.289     0.150
    76.320   702.680     0.150
    76.385   703.203     0.150
    76.631   704.398     0.150
    76.660   724.789     0.150
    76.660   704.590     0.150
    76.660  1284.188     0.150
    76.664   711.090     0.150
    76.664   723.887     0.150
    76.664   704.688     0.150
    76.664  1284.887     0.150
    76.669   705.027     0.150
    76.700   725.090     0.150
    76.700   704.688     0.150
    77.099   706.680     0.150
    77.102   707.289     0.150
    77.152    22.398     0.150
    77.152   706.793     0.150
    77.152   706.789     0.150
    77.152    22.398     0.150
    77.152   902.488     0.150
    77.152  1289.488     0.150
    77.152  1666.488     0.150
    77.152   706.840     0.150
    77.157   871.527     0.150
    77.157   706.887     0.150
    77.157  1292.488     0.150
    77.150   701.438     0.150
    77.198   727.988     0.150
    77.198   707.590     0.150
    77.340   708.816     0.150
    77.382   708.387     0.150
    77.609   729.988     0.150
    77.609   709.988     0.150
    77.609  1294.988     0.150
    77.619   709.688     0.150
    77.643   730.188     0.150
    77.643  1292.887     0.150
    77.643   710.090     0.150
    77.643  1292.887     0.150
    77.867   702.809     0.150
    77.978   713.137     0.150
    78.216   713.137     0.150
    78.233   732.887     0.150
    78.233   739.188     0.150
    78.233   713.188     0.150
    78.339   714.418     0.150
    78.584   714.289     0.150
    78.610   713.707     0.150
    78.508   715.910     0.150
    78.706  1303.289     0.150
    78.706   715.719     0.150
    78.854   717.391     0.150
    78.891   716.840     0.150
    78.891   716.848     0.150
    78.891   882.488     0.150
    79.131   714.887     0.150
    79.131   714.867     0.150
    79.143   718.879     0.150
    79.368   714.859     0.150
    79.368   720.199     0.150
    79.511   720.988     0.150
    79.511   719.488     0.150
    79.511   719.488     0.150
    79.584   723.988     0.150
    79.584   723.988     0.150
    79.550   721.719     0.150
    79.603   721.488     0.150
    79.645   720.840     0.150
    79.801   720.977     0.150
    80.089   722.988     0.150
    80.089   722.887     0.150
    80.211   724.387     0.150
    80.270   726.988     0.150
    80.270   726.988     0.150
    80.270   724.590     0.150
    80.579   728.988     0.150
    80.579   728.988     0.150
    80.579   725.887     0.150
    80.579   725.887     0.150
    80.615   726.488     0.150
    80.615   726.188     0.150
    80.615   726.188     0.150
    80.693   726.488     0.150
    80.783   726.980     0.150
    80.858   726.488     0.150
    80.858   720.590     0.150
    80.858   720.590     0.150
    80.887   728.188     0.150
    80.887   728.188     0.150
    80.927   727.648     0.150
    80.927   727.449     0.150
    80.975   728.488     0.150
    80.975   728.488     0.150
    80.975   728.488     0.150
    80.975   728.488     0.150
    81.092   728.988     0.150
    81.213   730.289     0.150
    81.213   730.488     0.150
    81.213   730.488     0.150
    81.213   730.289     0.150
    81.213   730.289     0.150
    81.216   730.988     0.150
    81.216   729.188     0.150
    81.191   729.289     0.150
    81.256   732.488     0.150
    81.256   732.488     0.150
    81.287   729.988     0.150
    81.287   729.688     0.150
    81.287   729.688     0.150
    81.314   729.410     0.150
    81.434   730.988     0.150
    81.434   730.789     0.150
    81.434   730.789     0.150
    81.453   730.988     0.150
    81.670   732.090     0.150
    81.671   731.789     0.150
    81.671   731.789     0.150
    81.851   729.688     0.150
    81.851   733.988     0.150
    81.851   729.688     0.150
    81.851   729.688     0.150
    81.896   732.988     0.150
    81.896   731.988     0.150
    81.896   731.988     0.150
    81.904   732.488     0.150
    81.904   730.387     0.150
    81.918   732.988     0.150
    81.918   732.789     0.150
    81.918   732.789     0.150
    82.051   733.688     0.150
    82.092   733.988     0.150
    82.092   733.789     0.150
    82.092   733.789     0.150
    82.104   733.988     0.150
    82.104   733.688     0.150
    82.117   740.387     0.150
    82.133   733.988     0.150
    82.133   732.488     0.150
    82.199   733.789     0.150
    82.205   734.770     0.150
    82.326   735.688     0.150
    82.326   735.688     0.150
    82.361   735.488     0.150
    82.404   730.988     0.150
    82.444   732.488     0.150
    82.465   735.988     0.150
    82.541   734.988     0.150
    82.702   735.488     0.150
    82.745   736.488     0.150
    82.745   736.488     0.150
    82.745   736.488     0.150
    82.799   736.488     0.150
    82.799   736.488     0.150
    82.799   736.488     0.150
    82.799   736.488     0.150
    82.829   736.988     0.150
    82.829   736.887     0.150
    82.873   738.488     0.150
    82.873   738.289     0.150
    82.893   744.488     0.150
    82.893   744.488     0.150
    82.905   737.488     0.150
    82.905   737.387     0.150
    82.942   737.488     0.150
    82.944   737.488     0.150
    83.043   739.488     0.150
    83.043   739.289     0.150
    83.043   739.289     0.150
    83.106   737.488     0.150
    83.141   738.988     0.150
    83.141   739.188     0.150
    83.163   738.488     0.150
    83.167   738.488     0.150
    83.167   738.188     0.150
    83.173   738.488     0.150
    83.239   738.488     0.150
    83.239   737.789     0.150
    83.238   739.277     0.150
    83.283   740.289     0.150
    83.327   740.488     0.150
    83.327   740.590     0.150
    83.377   740.988     0.150
    83.378   739.988     0.150
    83.378   739.887     0.150
    83.384   739.488     0.150
    83.392   741.008     0.150
    83.392   740.488     0.150
    83.392   740.387     0.150
    83.392   740.387     0.150
    83.403   740.488     0.150
    83.468   740.988     0.150
    83.494   739.488     0.150
    83.494   739.289     0.150
    83.510   741.488     0.150
    83.510   740.988     0.150
    83.575   741.488     0.150
    83.575   741.188     0.150
    83.624   740.988     0.150
    83.624   741.188     0.150
    83.639   740.988     0.150
    83.639   740.988     0.150
    83.639   740.988     0.150
    83.697   742.488     0.150
    83.710   742.988     0.150
    83.810   742.988     0.150
    83.810   742.488     0.150
    83.931   743.488     0.150
    83.929   742.988     0.150
    83.973   743.988     0.150
    83.973   743.688     0.150
    84.038   743.488     0.150
    84.038   743.188     0.150
    84.077   744.488     0.150
    84.077   744.688     0.150
    84.189   744.988     0.150
    84.222   745.988     0.150
    84.249   743.988     0.150
    84.249   743.887     0.150
    84.255   745.488     0.150
    84.272   745.488     0.150
    84.300   744.488     0.150
    84.318   745.488     0.150
    84.318   745.090     0.150
    84.318   745.090     0.150
    84.415   745.488     0.150
    84.415   745.289     0.150
    84.537   745.988     0.150
    84.547   746.988     0.150
    84.547   746.789     0.150
    84.580   747.488     0.150
    84.580   747.188     0.150
    84.580   747.188     0.150
    84.656   747.988     0.150
    84.702   746.637     0.150
    84.707   747.488     0.150
    84.707   746.688     0.150
    84.728   746.488     0.150
    84.728   746.289     0.150
    84.749   746.859     0.150
    85.268   748.688     0.150
    85.268   748.680     0.150
    85.208  6370.688     0.150
    85.374   748.797     0.150
    86.019   753.316     0.150
    85.951  6425.488     0.150
    86.001  6428.387     0.150
    86.079  6434.488     0.150
    86.298  6458.289     0.150
    87.165   756.707     0.150
    87.149  6514.988     0.150
    87.376   761.383     0.150
    87.376   761.238     0.150
    87.637   761.840     0.150
    88.342   767.688     0.150
    88.342   767.688     0.150
    89.181   768.930     0.150
    90.026   773.648     0.150
    90.195  6740.590     0.150
    90.385    14.879     0.150
    91.410   780.059     0.150
    93.329   788.168     0.150
    96.055   800.988     0.150
    99.597  1918.688     0.150
   102.399   830.387     0.150
   102.399  1083.688     0.150
   102.399   830.418     0.150
   102.399  1083.660     0.150
   114.381  1160.543     0.150
   120.750  1125.566     0.150
   123.153  1129.988     0.150
   124.791  1132.289     0.150
   126.298  1137.238     0.150
   128.558  1142.090     0.150
   128.558  1262.188     0.150
   133.750  1150.707     0.150
   133.750  1354.727     0.150
   142.815  1164.039     0.150
   142.815  1164.090     0.150
   146.126  1171.520     0.150
   146.947  1176.258     0.150
   151.797  1188.887     0.150
   156.937  1188.188     0.150
     1.885    30.535     0.150
     1.885    53.234     0.150
     4.721    74.834     0.150
     6.511    95.734     0.150
    14.993   209.635     0.150
    21.559   283.834     0.150
    25.807   326.135     0.150
    30.604  2264.912     0.150
    30.615  2265.754     0.150
    30.622  2267.254     0.150
    31.468  2336.391     0.150
    31.472  2335.375     0.150
    31.485  2337.898     0.150
    39.076   440.934     0.150
    39.076   570.434     0.150
    42.115   466.434     0.150
    44.791   487.434     0.150
    49.480   524.234     0.150
    62.306   615.734     0.150
    64.542   630.135     0.150
    66.034   640.934     0.150
    68.064   654.834     0.150
    69.654   662.834     0.150
     0.048     2.336     0.150
     0.048     5.438     0.150
     0.835    14.031     0.150
     0.877    14.438     0.150
     0.852    26.234     0.150
     0.882    15.438     0.150
     1.484    24.734     0.150
     1.484    24.734     0.150
     1.484    44.234     0.150
     1.535    28.633     0.150
     1.535    28.984     0.150
     5.183    82.531     0.150
     5.183   144.336     0.150
     6.206   102.133     0.150
     6.813   103.492     0.150
     6.813   103.531     0.150
     6.813   185.133     0.150
     6.813   103.531     0.150
     8.279   125.547     0.150
     8.758   718.836     0.150
     8.758   927.531     0.150
    11.714   171.133     0.150
    11.690   172.227     0.150
    11.714   171.086     0.150
    11.714   171.133     0.150
    11.714   171.086     0.150
    12.704   183.633     0.150
    12.817   187.086     0.150
    16.330   234.531     0.150
    16.330   234.531     0.150
    19.147   261.797     0.150
    20.408    15.250     0.150
    20.408   531.234     0.150
    24.538   318.102     0.150
    24.982   322.273     0.150
    24.982   322.234     0.150
    29.495   360.547     0.150
    29.769   369.477     0.150
    29.769   763.188     0.150
    32.355  2423.805     0.150
    32.359  2419.844     0.150
    32.372  2420.898     0.150
    32.690    17.797     0.150
    32.690    29.203     0.150
    32.690   702.734     0.150
    32.690   736.234     0.150
    36.275    13.102     0.150
    36.275   511.531     0.150
    36.275   907.531     0.150
    38.196   438.734     0.150
    38.196   572.836     0.150
    38.515    14.297     0.150
    38.515    21.695     0.150
    38.515   789.031     0.150
    40.743   463.734     0.150
    42.392   474.031     0.150
    42.674   478.375     0.150
    42.792   484.531     0.150
    43.062   481.836     0.150
    43.065   481.836     0.150
    43.065   479.656     0.150
    44.412   497.234     0.150
    44.621   490.531     0.150
    45.693   502.367     0.150
    46.348   508.492     0.150
    47.043   511.555     0.150
    47.082   511.703     0.150
    48.263   527.531     0.150
    48.263    18.305     0.150
    48.263    27.305     0.150
    48.263   612.938     0.150
    48.263   837.836     0.150
    48.263   973.531     0.150
    48.263  1106.633     0.150
    48.637   522.734     0.150
    49.218   525.133     0.150
    49.218   525.133     0.150
    49.218   525.133     0.150
    52.094   614.633     0.150
    55.522   573.625     0.150
    56.585   581.062     0.150
    56.942   582.734     0.150
    58.555   594.133     0.150
    61.321   610.734     0.150
    62.404   622.031     0.150
    63.682   629.031     0.150
    64.789   640.031     0.150
    64.789   640.047     0.150
    64.839   637.133     0.150
    64.839   637.172     0.150
    65.459   642.938     0.150
    66.585   649.734     0.150
    67.180   653.734     0.150
    68.819   662.836     0.150
    68.916   665.586     0.150
    69.725   668.234     0.150
    69.725   668.203     0.150
    69.766   670.883     0.150
    69.901   672.836     0.150
    70.568   675.086     0.150
    71.801   681.633     0.150
    73.240   689.234     0.150
    73.240   689.234     0.150
    73.420   691.031     0.150
    73.546   693.305     0.150
    73.769   694.633     0.150
    73.769   694.531     0.150
    74.129   696.031     0.150
    74.215   696.734     0.150
    74.222   695.938     0.150
    74.495   704.133     0.150
    74.495   704.133     0.150
    74.400   697.234     0.150
    74.619   697.836     0.150
    75.033   700.266     0.150
    75.033   703.633     0.150
    75.163   701.734     0.150
    75.176   702.633     0.150
    75.199   702.438     0.150
    75.494   704.031     0.150
    75.474   703.547     0.150
    75.531   705.438     0.150
    75.531   705.438     0.150
    75.538   714.938     0.150
    75.538   704.234     0.150
    75.538   714.938     0.150
    75.570   704.234     0.150
    75.935   708.133     0.150
    75.935   708.133     0.150
    75.935   707.828     0.150
    76.049   708.281     0.150
    76.049   708.234     0.150
    76.054   706.656     0.150
    76.085   707.234     0.150
    76.247   708.133     0.150
    76.489   709.938     0.150
    76.489   709.938     0.150
    76.526   728.633     0.150
    76.526   710.133     0.150
    76.526   728.633     0.150
    76.703   710.531     0.150
    76.915   713.234     0.150
    76.915   713.234     0.150
    76.920   714.203     0.150
    77.589   714.633     0.150
    77.577   718.953     0.150
    77.633   716.805     0.150
    77.770   717.406     0.150
    77.770   717.438     0.150
    77.779   717.594     0.150
    78.645   721.438     0.150
    78.645   721.414     0.150
    80.005   731.836     0.150
    80.817   733.531     0.150
    80.817   733.508     0.150
    86.532   762.031     0.150
    86.532   761.984     0.150
    86.532   762.031     0.150
   146.314  1178.336     0.150
   151.659  1192.438     0.150
     0.945    28.246     0.150
     1.855    60.172     0.150
     2.650    71.344     0.150
     4.517    68.547     0.150
     4.659    69.445     0.150
     4.659   120.344     0.150
     6.894   100.145     0.150
    26.347   329.945     0.150
    39.532   444.844     0.150
    42.639   470.746     0.150
    49.128   520.746     0.150
    59.552   598.043     0.150
    59.552   598.047     0.150
    64.788   631.344     0.150
    69.843   663.445     0.150
    69.843   663.445     0.150
    78.919   716.445     0.150
    78.919   716.445     0.150
     1.834    51.508     0.150
     6.806    94.408     0.150
     8.190   208.809     0.150
     8.567   127.008     0.150
    12.552   176.758     0.150
    12.552   318.908     0.150
    13.423   183.117     0.150
    20.262    18.801     0.150
    20.273   268.729     0.150
    21.290   278.008     0.150
    21.290   297.908     0.150
    23.300   302.668     0.150
    23.467    20.400     0.150
    23.467   543.908     0.150
    24.271   311.617     0.150
    25.794   325.027     0.150
    30.258  2254.898     0.150
    30.269  2255.734     0.150
    30.276  2256.121     0.150
    30.743    11.701     0.150
    30.743    17.301     0.150
    31.133  2320.391     0.150
    31.137  2322.338     0.150
    31.151  2332.824     0.150
    32.505    14.299     0.150
    32.505    20.699     0.150
    33.188    13.799     0.150
    33.188    20.500     0.150
    33.574    14.400     0.150
    39.764    15.500     0.150
    39.764    23.801     0.150
    39.795   449.047     0.150
    40.241   475.508     0.150
    40.479   453.998     0.150
    42.476   468.408     0.150
    42.532   469.748     0.150
    42.532   581.008     0.150
    42.733   471.258     0.150
    43.144   475.578     0.150
    43.648   479.338     0.150
    43.710   479.498     0.150
    43.793   479.408     0.150
    43.793   479.447     0.150
    43.919   481.047     0.150
    44.108   483.068     0.150
    44.040   491.508     0.150
    48.090   513.357     0.150
    48.337   515.408     0.150
    48.337   516.008     0.150
    48.857   519.377     0.150
    49.187   521.428     0.150
    49.194   522.008     0.150
    49.194   521.979     0.150
    49.510    22.900     0.150
    49.666   525.008     0.150
    49.666   524.979     0.150
    51.653   540.479     0.150
    53.031   551.777     0.150
    55.662   570.018     0.150
    56.761   577.078     0.150
    57.212   579.408     0.150
    57.212   579.428     0.150
    58.962   592.178     0.150
    60.634   602.607     0.150
    64.521   631.037     0.150
    64.624  1164.408     0.150
    65.421   636.309     0.150
    65.421   636.338     0.150
    66.251   643.168     0.150
    67.512   647.408     0.150
    68.290   654.928     0.150
    68.779   657.047     0.150
    70.181   667.158     0.150
    70.761   665.107     0.150
    72.746   682.648     0.150
    73.059   684.377     0.150
    73.171   684.607     0.150
    73.864   689.238     0.150
    74.481   693.408     0.150
    74.549   692.707     0.150
    74.549   692.707     0.150
    74.923   694.508     0.150
    75.098   696.479     0.150
    75.261   695.008     0.150
    75.301   695.309     0.150
    75.332   696.707     0.150
    75.332   696.678     0.150
    75.339   697.207     0.150
    75.738   699.408     0.150
    76.138   701.309     0.150
    76.250   702.008     0.150
    76.293   702.508     0.150
    76.596   703.947     0.150
    76.605   704.908     0.150
    76.625   704.309     0.150
    76.629   704.309     0.150
    76.626   704.877     0.150
    76.678   704.408     0.150
    77.119   705.908     0.150
    77.119   705.938     0.150
    77.164   707.408     0.150
    77.346   707.426     0.150
    77.574   709.607     0.150
    77.609   709.809     0.150
    77.702   710.207     0.150
    77.993   711.461     0.150
    78.065   711.707     0.150
    78.584   714.518     0.150
    78.672   715.508     0.150
    78.672   715.408     0.150
    79.098   718.168     0.150
    79.325   718.768     0.150
    79.613   721.408     0.150
    82.759   736.488     0.150
    85.235   749.998     0.150
    85.978   753.918     0.150
   118.395  1121.678     0.150
   126.251  1136.508     0.150
   146.121  1172.107     0.150
   146.121  1172.098     0.150
     0.510    10.031     0.150
     0.510    18.422     0.150
     4.650    76.191     0.150
     6.680    97.762     0.150
    12.296   178.590     0.150
    12.296   178.539     0.150
    18.019   249.320     0.150
    30.467  2270.195     0.150
    30.478  2271.223     0.150
    30.485  2265.660     0.150
    31.337  2316.777     0.150
    31.341  2326.797     0.150
    31.354  2328.977     0.150
    43.566   481.461     0.150
    47.877   515.719     0.150
    58.829   593.785     0.150
    69.687   658.891     0.150
     0.303    10.371     0.150
     0.303    17.490     0.150
     6.903    99.020     0.150
    12.667   174.131     0.150
    12.668   174.131     0.150
    12.668   174.131     0.150
    43.881   479.961     0.150
    44.272   483.230     0.150
    48.662   519.031     0.150
    51.750   540.760     0.150
    53.358   552.461     0.150
    58.614    14.301     0.150
    62.472    14.951     0.150
    65.405   635.910     0.150
    66.199    15.193     0.150
    69.827   663.230     0.150
    78.719   716.230     0.150
    85.895    14.324     0.150
     0.088     4.895     0.150
     0.434    17.995     0.150
     0.588    19.395     0.150
     0.690    12.795     0.150
     0.687    13.595     0.150
     0.708    24.195     0.150
     1.059    18.695     0.150
     1.514    50.020     0.150
     4.150    64.695     0.150
     4.150   113.795     0.150
     6.443   162.895     0.150
     7.300   106.595     0.150
     8.183   221.595     0.150
     8.183   205.395     0.150
    11.865   159.795     0.150
    11.865   294.694     0.150
    12.928   184.194     0.150
    13.688   193.335     0.150
    16.844   415.895     0.150
    20.511    12.100     0.150
    20.995   292.194     0.150
    20.995   531.594     0.150
    20.995   282.895     0.150
    21.188   288.395     0.150
    23.684   554.895     0.150
    26.089   604.495     0.150
    28.310   364.694     0.150
    30.318  2256.159     0.150
    30.329  2266.175     0.150
    30.336  2261.389     0.150
    30.999   380.194     0.150
    30.999     7.800     0.150
    30.999    11.000     0.150
    31.207  2327.355     0.150
    31.211  2327.129     0.150
    31.225  2329.830     0.150
    32.702   393.595     0.150
    32.702     9.600     0.150
    32.702    13.500     0.150
    32.702   724.094     0.150
    36.799   422.595     0.150
    37.545     8.700     0.150
    37.545    13.000     0.150
    39.866     8.400     0.150
    39.866    12.600     0.150
    40.006   453.264     0.150
    42.011   468.895     0.150
    42.585   473.694     0.150
    42.585   473.694     0.150
    42.585   473.694     0.150
    42.786   475.685     0.150
    43.174   479.495     0.150
    43.174   479.454     0.150
    43.236   479.194     0.150
    43.563   482.194     0.150
    43.635   482.574     0.150
    43.792   484.735     0.150
    43.873   485.120     0.150
    44.106   487.194     0.150
    44.295   489.125     0.150
    48.046   518.795     0.150
    48.046   518.795     0.150
    48.260   520.495     0.150
    48.263   516.295     0.150
    48.996   524.594     0.150
    49.124   527.795     0.150
    49.269   528.094     0.150
    49.269   528.094     0.150
    49.620    13.200     0.150
    51.710   546.194     0.150
    51.710   546.185     0.150
    51.974   552.295     0.150
    52.813   558.194     0.150
    53.186   618.895     0.150
    53.186  1218.094     0.150
    56.098   577.594     0.150
    62.860   621.895     0.150
    62.860   621.885     0.150
    65.025   638.584     0.150
    67.080   652.495     0.150
    67.803   657.135     0.150
    68.340   659.395     0.150
    69.471   667.454     0.150
    69.717   669.015     0.150
    69.883   669.284     0.150
    72.606   685.395     0.150
    72.606   685.414     0.150
    72.698   687.265     0.150
    72.951   686.794     0.150
    74.643   698.564     0.150
    74.778   698.395     0.150
    75.152   700.354     0.150
    75.168   700.294     0.150
    75.182   707.594     0.150
    75.182   707.694     0.150
    75.360   709.495     0.150
    75.360   709.495     0.150
    75.918   707.794     0.150
    76.195   708.294     0.150
    76.408   708.094     0.150
    76.408   708.164     0.150
    76.434   709.294     0.150
    76.434   709.294     0.150
    76.471   708.495     0.150
    76.889   709.895     0.150
    76.906   709.594     0.150
    76.906   731.294     0.150
    77.060   710.294     0.150
    77.915   712.294     0.150
    77.915   712.294     0.150
    78.471   719.194     0.150
    78.471   719.194     0.150
    78.471   719.194     0.150
    78.513   725.495     0.150
    79.234   721.862     0.150
    79.250   720.359     0.150
    79.487   725.194     0.150
    79.487   724.115     0.150
    80.227   732.093     0.150
    80.890   731.877     0.150
    84.313   750.324     0.150
   102.542   830.495     0.150
   114.223  1115.995     0.150
   146.579  1176.674     0.150
     0.542    10.156     0.150
     0.542    14.867     0.150
     0.552    11.320     0.150
     4.723    77.117     0.150
     4.723   134.320     0.150
     6.851    99.516     0.150
     6.851   189.617     0.150
     7.919   119.766     0.150
     8.144   222.617     0.150
    11.327   161.117     0.150
    12.202   177.016     0.150
    12.202   176.977     0.150
    12.620   165.719     0.150
    14.908   206.016     0.150
    19.277   260.734     0.150
    19.918   273.117     0.150
    19.918   498.617     0.150
    23.131   344.016     0.150
    25.950   333.945     0.150
    25.950   333.945     0.150
    25.950   333.914     0.150
    27.852   349.023     0.150
    28.885   353.820     0.150
    28.885   406.219     0.150
    30.480  2368.570     0.150
    30.490  2369.398     0.150
    30.498  2369.703     0.150
    30.398    13.797     0.150
    30.398    20.500     0.150
    30.398   436.320     0.150
    31.346  2431.250     0.150
    31.350  2430.289     0.150
    31.364  2433.734     0.150
    36.040   759.219     0.150
    37.936   430.906     0.150
    39.465    14.203     0.150
    39.771   446.078     0.150
    42.255   473.438     0.150
    42.255   472.930     0.150
    42.522   477.477     0.150
    43.021   473.695     0.150
    43.910   493.016     0.150
    43.910     0.039     0.150
    49.208    15.398     0.150
    49.208   983.117     0.150
    53.098  1228.617     0.150
    57.254   591.227     0.150
    62.318   620.148     0.150
    62.318   625.320     0.150
    64.465   637.320     0.150
    64.625   636.000     0.150
    65.491   643.016     0.150
    65.873   647.516     0.150
    65.873   647.484     0.150
    69.723   668.180     0.150
    69.723   668.180     0.150
    70.477   675.891     0.150
    70.555   676.617     0.150
    70.715   677.820     0.150
    70.715   674.461     0.150
    73.463   694.234     0.150
    74.746   701.766     0.150
    76.042   708.547     0.150
    76.042   708.555     0.150
    76.042   712.219     0.150
    76.502   712.914     0.150
    76.502   712.914     0.150
    77.005   716.820     0.150
    78.549   729.219     0.150
    86.316   762.844     0.150
   145.947  1176.445     0.150
     0.196     8.473     0.150
     0.997    17.871     0.150
     1.048    19.672     0.150
     1.949    35.449     0.150
     4.789    59.973     0.150
     6.920   106.074     0.150
     8.218   115.773     0.150
     9.737   137.574     0.150
    11.060   293.973     0.150
    11.394   162.371     0.150
    11.394   299.074     0.150
    12.214   177.371     0.150
    12.214   177.371     0.150
    12.624   187.371     0.150
    12.907   186.246     0.150
    12.907   185.242     0.150
    14.108   205.074     0.150
    15.327   395.473     0.150
    18.538   257.574     0.150
    19.956   495.473     0.150
    19.966   268.703     0.150
    21.326     7.801     0.150
    21.326   506.172     0.150
    21.354   527.773     0.150
    21.595   287.973     0.150
    23.442   555.172     0.150
    26.194   602.973     0.150
    26.206   331.254     0.150
    27.532     4.301     0.150
    27.532   541.273     0.150
    27.532   624.773     0.150
    27.918   346.574     0.150
    27.918   628.473     0.150
    27.918   348.414     0.150
    28.938   362.172     0.150
    28.938   417.773     0.150
    30.434   370.473     0.150
    30.434     3.102     0.150
    30.434   667.473     0.150
    30.862   371.172     0.150
    32.862     2.398     0.150
    32.862     4.699     0.150
    36.854     2.602     0.150
    36.854     3.699     0.150
    39.271   449.422     0.150
    39.522     4.301     0.150
    39.522     8.500     0.150
    40.085   457.973     0.150
    40.085   825.074     0.150
    40.777   459.074     0.150
    40.777   459.062     0.150
    41.612   477.074     0.150
    42.317   472.152     0.150
    42.317   472.172     0.150
    42.317   472.211     0.150
    42.519   474.074     0.150
    42.519   474.094     0.150
    42.793   478.043     0.150
    42.833   474.871     0.150
    42.833   474.871     0.150
    43.176   488.273     0.150
    43.291   486.074     0.150
    43.580   483.273     0.150
    43.609   482.551     0.150
    43.818   594.371     0.150
    43.943   486.504     0.150
    44.006   486.781     0.150
    44.058   487.652     0.150
    44.327   489.434     0.150
    44.410   490.434     0.150
    44.747   492.773     0.150
    44.880   493.363     0.150
    45.056   504.371     0.150
    45.321   498.773     0.150
    45.580   497.621     0.150
    46.642   507.973     0.150
    47.603   515.672     0.150
    47.698   515.973     0.150
    48.110   519.273     0.150
    48.805   533.973     0.150
    48.967   524.754     0.150
    49.456   529.223     0.150
    50.368   535.574     0.150
    50.999   540.684     0.150
    51.436   547.371     0.150
    51.436   543.473     0.150
    51.436   543.473     0.150
    53.074   555.844     0.150
    53.170   672.973     0.150
    54.316   567.762     0.150
    55.327   572.961     0.150
    55.387   572.863     0.150
    56.507   580.613     0.150
    57.424   587.121     0.150
    58.394   602.074     0.150
    58.973   598.734     0.150
    60.742   616.672     0.150
    60.742   616.672     0.150
    62.674   622.184     0.150
    63.681   865.273     0.150
    64.043   633.027     0.150
    64.540   644.074     0.150
    64.575   638.113     0.150
    64.700   637.672     0.150
    64.825   637.723     0.150
    65.057   639.559     0.150
    65.558   642.422     0.150
    65.895   644.547     0.150
    65.895   645.871     0.150
    66.029   641.871     0.150
    66.584   650.852     0.150
    67.370   656.562     0.150
    67.862   658.492     0.150
    68.234   661.699     0.150
    68.564   660.711     0.150
    68.583   662.414     0.150
    68.624   662.422     0.150
    68.667   660.883     0.150
    68.738   661.461     0.150
    68.777   664.973     0.150
    68.854   662.324     0.150
    68.949   665.324     0.150
    69.798   669.473     0.150
    69.798   668.973     0.150
    70.243   673.562     0.150
    70.499   674.922     0.150
    70.626   676.871     0.150
    70.661   676.672     0.150
    70.704   674.441     0.150
    70.789   675.254     0.150
    72.063   685.922     0.150
    72.366   686.582     0.150
    72.388   685.074     0.150
    72.990   689.473     0.150
    73.081   690.762     0.150
    73.386   692.293     0.150
    73.473   692.574     0.150
    73.473   692.551     0.150
    73.568   696.973     0.150
    73.568   696.973     0.150
    73.684   696.547     0.150
    74.112   695.742     0.150
    74.199   696.504     0.150
    74.475   699.371     0.150
    74.765   701.543     0.150
    74.834   700.371     0.150
    75.193   704.773     0.150
    75.193   704.773     0.150
    75.199   704.484     0.150
    75.270   702.172     0.150
    75.270   702.094     0.150
    75.269   704.172     0.150
    75.388   706.273     0.150
    75.388   706.273     0.150
    75.403   706.574     0.150
    75.424   703.594     0.150
    75.437   706.871     0.150
    75.437   706.871     0.150
    75.457   704.273     0.150
    75.518   703.922     0.150
    75.563   706.273     0.150
    75.563   706.172     0.150
    75.569   709.473     0.150
    75.569   709.473     0.150
    75.663   707.973     0.150
    75.663   707.973     0.150
    75.670   706.473     0.150
    76.019   709.773     0.150
    76.019   709.773     0.150
    76.038   706.824     0.150
    76.112   709.074     0.150
    76.200   709.824     0.150
    76.200   709.773     0.150
    76.226   711.473     0.150
    76.226   711.473     0.150
    76.244   709.773     0.150
    76.244   709.773     0.150
    76.303   709.973     0.150
    76.507   711.473     0.150
    76.538   712.773     0.150
    76.538   709.773     0.150
    76.575   711.473     0.150
    76.575   711.473     0.150
    76.577   710.973     0.150
    76.593   713.371     0.150
    76.593   713.371     0.150
    76.912   713.043     0.150
    76.990   715.172     0.150
    76.990   712.984     0.150
    76.999   713.273     0.150
    77.080   720.352     0.150
    77.080   720.371     0.150
    77.081  1296.973     0.150
    77.081   712.613     0.150
    77.118   714.672     0.150
    77.118   714.672     0.150
    77.290   717.574     0.150
    77.290   715.074     0.150
    77.525   724.273     0.150
    77.561   716.672     0.150
    77.561   724.371     0.150
    77.688   717.633     0.150
    77.730   717.410     0.150
    77.979   718.973     0.150
    77.979   718.973     0.150
    78.624   721.672     0.150
    78.679   723.797     0.150
    78.807   720.973     0.150
    78.807   720.992     0.150
    78.807   724.922     0.150
    78.807   724.973     0.150
    78.814   724.773     0.150
    79.059   727.172     0.150
    79.059   727.133     0.150
    79.357   729.316     0.150
    79.387   728.246     0.150
    79.511   726.895     0.150
    79.917   729.273     0.150
    79.917   729.273     0.150
    79.963   729.383     0.150
    80.017   730.281     0.150
    80.351   733.488     0.150
    80.623   734.281     0.150
    80.652   731.273     0.150
    80.652   733.652     0.150
    80.864   737.660     0.150
    80.900   735.902     0.150
    80.980   736.281     0.150
    81.038   737.938     0.150
    81.051   736.832     0.150
    81.097   735.348     0.150
    81.125   732.465     0.150
    81.450   739.590     0.150
    81.516   738.574     0.150
    81.531   737.594     0.150
    81.551   739.695     0.150
    81.961   738.484     0.150
    83.133   745.680     0.150
    83.401   747.863     0.150
    83.599   748.781     0.150
    83.714   750.574     0.150
    84.215   754.074     0.150
    84.224   752.371     0.150
    84.300   752.973     0.150
    84.491   753.133     0.150
    84.631   753.031     0.150
    84.681   754.383     0.150
    84.957   755.383     0.150
    85.095   756.543     0.150
    85.121   759.473     0.150
    85.203   756.828     0.150
    85.233   756.324     0.150
    86.697   764.199     0.150
    86.786   764.559     0.150
    86.796   767.172     0.150
    86.924   765.195     0.150
    87.381   767.508     0.150
    87.731   769.051     0.150
    87.974   770.773     0.150
    87.974   770.723     0.150
    88.148   771.211     0.150
    89.502   775.973     0.150
    89.502   775.973     0.150
    93.005   791.691     0.150
    93.050   794.773     0.150
   145.894  1178.453     0.150
   147.474  1186.508     0.150
     0.462    18.410     0.150
     0.462     9.990     0.150
     0.462    18.359     0.150
     1.057    33.609     0.150
     1.917    61.209     0.150
     4.757    76.109     0.150
     4.757   132.609     0.150
     6.890    99.910     0.150
     6.890   191.010     0.150
     8.215   224.109     0.150
    30.402  2266.494     0.150
    30.413  2276.121     0.150
    30.420  2267.160     0.150
    30.470     5.500     0.150
    30.470     8.801     0.150
    31.270  2330.514     0.150
    31.273  2322.043     0.150
    31.287  2332.975     0.150
    36.084   765.609     0.150
    39.545     5.801     0.150
    39.545     9.500     0.150
    42.335   473.049     0.150
    42.537   476.010     0.150
    42.537   476.049     0.150
    43.622   482.830     0.150
    44.658   492.580     0.150
    47.132   512.760     0.150
    47.941   517.559     0.150
    49.287     9.000     0.150
    49.287   968.609     0.150
    49.411   528.199     0.150
    54.359   563.969     0.150
    62.208   621.631     0.150
    64.537   773.209     0.150
    64.690   635.760     0.150
    65.526   642.129     0.150
    65.847   645.090     0.150
    68.266   659.809     0.150
    69.784   667.309     0.150
    69.784   667.309     0.150
    70.787   674.648     0.150
    86.280   761.410     0.150
    30.592  2264.918     0.150
    30.602  2266.223     0.150
    30.610  2266.172     0.150
    31.469  2338.574     0.150
    31.473  2338.031     0.150
    31.486  2338.352     0.150
     0.272     9.793     0.150
     1.930    56.117     0.150
     6.708   101.393     0.150
     6.709   100.393     0.150
     6.709   178.693     0.150
     9.973   133.693     0.150
     9.973   148.293     0.150
     9.973   250.594     0.150
     9.973   704.193     0.150
    12.470   179.947     0.150
    12.470   179.943     0.150
    12.470   179.992     0.150
    23.426    14.201     0.150
    23.426    21.701     0.150
    23.426   574.094     0.150
    30.232  2256.623     0.150
    30.243  2261.611     0.150
    30.250  2262.766     0.150
    30.692    11.799     0.150
    30.692    17.898     0.150
    31.104  2330.328     0.150
    31.107  2324.562     0.150
    31.121  2317.633     0.150
    32.469    11.400     0.150
    32.469    17.000     0.150
    39.457   570.543     0.150
    39.457   444.293     0.150
    39.457   570.594     0.150
    42.532   469.293     0.150
    42.532   580.873     0.150
    42.532   469.492     0.150
    42.532   580.893     0.150
    42.734   470.893     0.150
    44.073   480.844     0.150
    44.154   480.793     0.150
    48.114   514.393     0.150
    49.303   522.293     0.150
    49.724   525.893     0.150
    53.326   613.393     0.150
    57.326   580.492     0.150
    59.585   595.793     0.150
    65.525   637.193     0.150
    66.600   641.793     0.150
    68.664   657.193     0.150
    68.896   657.693     0.150
    70.924   671.293     0.150
    76.428   700.693     0.150
    77.182   706.793     0.150
     0.301    10.277     0.150
     0.301    10.336     0.150
     2.569    40.336     0.150
     2.569    71.137     0.150
     2.645    41.137     0.150
     4.646    69.438     0.150
     5.449    82.938     0.150
     6.901    98.676     0.150
     8.558   113.836     0.150
     9.550   231.613     0.150
    10.520   149.938     0.150
    12.666   177.738     0.150
    13.329   183.059     0.150
    17.922   243.137     0.150
    21.312   278.336     0.150
    21.362   281.438     0.150
    25.893   323.477     0.150
    25.893   324.336     0.150
    28.664   350.738     0.150
    30.179  2265.273     0.150
    30.190  2370.246     0.150
    30.197  2268.500     0.150
    31.057  2331.375     0.150
    31.061  2322.617     0.150
    31.074  2332.684     0.150
    32.616     6.500     0.150
    39.519   571.688     0.150
    39.519   443.836     0.150
    39.519   571.238     0.150
    42.628   581.328     0.150
    42.628   470.336     0.150
    42.829   471.137     0.150
    43.881   480.035     0.150
    48.121   513.938     0.150
    48.121   600.836     0.150
    48.171   513.738     0.150
    48.437   516.238     0.150
    49.119   520.438     0.150
    51.750   540.336     0.150
    53.359    15.898     0.150
    57.168   578.738     0.150
    58.616   590.137     0.150
    58.616   590.137     0.150
    64.774   631.137     0.150
    65.407   636.035     0.150
    68.472   655.836     0.150
    68.586   657.438     0.150
    69.823   663.137     0.150
    70.840   670.668     0.150
    70.937   669.637     0.150
    77.164   706.836     0.150
    78.720   716.438     0.150
     0.270    17.805     0.150
     1.692    49.174     0.150
     1.969    56.104     0.150
     2.602    41.004     0.150
     2.633    41.004     0.150
     3.001    43.703     0.150
     3.509    51.004     0.150
     4.497    67.404     0.150
     4.509    67.404     0.150
     4.509   117.104     0.150
     6.121    85.305     0.150
     6.957    99.203     0.150
     9.650   233.379     0.150
     9.650   233.174     0.150
     9.967   159.004     0.150
     9.967   138.424     0.150
    10.359   147.004     0.150
    11.110   157.404     0.150
    11.110   288.404     0.150
    12.213   177.305     0.150
    12.617   323.104     0.150
    12.617   325.654     0.150
    12.617   323.104     0.150
    12.617   176.805     0.150
    12.617   323.104     0.150
    12.887   189.504     0.150
    12.887     9.301     0.150
    13.483   187.904     0.150
    14.900   219.904     0.150
    15.330   207.895     0.150
    15.330   369.344     0.150
    15.330   207.879     0.150
    15.390   378.004     0.150
    17.528   238.004     0.150
    17.813   241.904     0.150
    19.681   262.443     0.150
    20.287   267.904     0.150
    21.156   543.203     0.150
    21.764    19.400     0.150
    23.470    12.699     0.150
    23.470    25.000     0.150
    23.470   552.305     0.150
    23.470   568.904     0.150
    23.780   344.004     0.150
    23.780   557.404     0.150
    23.859   301.104     0.150
    25.780   583.305     0.150
    26.626   609.404     0.150
    27.699   722.805     0.150
    27.893    14.600     0.150
    27.893    22.000     0.150
    28.043   345.020     0.150
    30.098   363.305     0.150
    30.338  2260.627     0.150
    30.349  2262.707     0.150
    30.356  2261.986     0.150
    30.760    14.699     0.150
    30.760    22.299     0.150
    30.760   434.805     0.150
    31.217  2332.225     0.150
    31.221  2327.539     0.150
    31.234  2330.607     0.150
    32.501    12.500     0.150
    32.501    17.500     0.150
    32.501   697.604     0.150
    33.227    14.100     0.150
    33.227    21.100     0.150
    33.635    16.801     0.150
    33.635   552.004     0.150
    34.271   399.504     0.150
    34.620   400.904     0.150
    37.246    16.201     0.150
    39.363   569.873     0.150
    39.363   792.533     0.150
    39.729    17.400     0.150
    39.729    21.900     0.150
    42.359   466.805     0.150
    42.683   469.604     0.150
    43.139   858.523     0.150
    43.164   475.725     0.150
    43.164   474.703     0.150
    43.519   476.904     0.150
    43.629   477.203     0.150
    43.728   478.004     0.150
    43.982   480.703     0.150
    43.985   481.305     0.150
    44.452   484.604     0.150
    45.155   487.904     0.150
    45.477   494.504     0.150
    46.571   501.904     0.150
    48.013   511.904     0.150
    49.049   519.604     0.150
    49.151   520.924     0.150
    49.151   520.904     0.150
    49.478    15.701     0.150
    49.902   526.693     0.150
    51.360   540.904     0.150
    51.564   539.703     0.150
    51.605   539.004     0.150
    51.605   539.004     0.150
    53.197   550.504     0.150
    53.197    19.600     0.150
    53.197  1207.904     0.150
    54.217   559.104     0.150
    55.543   567.004     0.150
    55.759   570.104     0.150
    56.734   575.904     0.150
    57.065   577.604     0.150
    58.553   589.004     0.150
    58.834   589.004     0.150
    59.380   593.604     0.150
    59.870   595.703     0.150
    62.576    16.709     0.150
    62.945   619.854     0.150
    63.765   625.703     0.150
    64.176   626.504     0.150
    64.521   628.404     0.150
    64.521   767.104     0.150
    64.521  1130.904     0.150
    64.622   629.211     0.150
    65.252    16.471     0.150
    65.275   634.703     0.150
    65.275   634.703     0.150
    65.309    15.480     0.150
    65.458    15.570     0.150
    66.150    15.570     0.150
    66.127    20.000     0.150
    66.127  1158.404     0.150
    66.229    16.051     0.150
    66.666    15.352     0.150
    66.937   646.404     0.150
    66.987    19.600     0.150
    67.427    15.369     0.150
    67.427   649.203     0.150
    67.427    15.301     0.150
    68.043    15.000     0.150
    68.148    15.350     0.150
    68.191    15.701     0.150
    68.191   653.805     0.150
    68.191    15.699     0.150
    68.314  1184.004     0.150
    68.530   654.404     0.150
    68.504   655.504     0.150
    68.886    16.740     0.150
    69.454    15.568     0.150
    69.435   662.504     0.150
    69.481   662.305     0.150
    69.669   660.904     0.150
    69.811   664.404     0.150
    69.907    15.531     0.150
    70.065    15.471     0.150
    70.065   665.404     0.150
    70.065    15.500     0.150
    70.227    15.500     0.150
    70.215    28.000     0.150
    70.215   930.305     0.150
    70.215  1214.004     0.150
    70.392   665.703     0.150
    70.672    15.740     0.150
    70.774   668.004     0.150
    70.786   668.072     0.150
    70.786   667.805     0.150
    70.993   669.104     0.150
    71.310   669.514     0.150
    71.337    15.750     0.150
    71.478   674.973     0.150
    71.618   675.703     0.150
    71.889    15.490     0.150
    71.940    16.150     0.150
    72.130    15.641     0.150
    72.214    16.320     0.150
    72.171   679.002     0.150
    72.334   676.004     0.150
    72.495   679.703     0.150
    72.495   695.604     0.150
    72.649   680.404     0.150
    72.649   696.904     0.150
    72.951   683.604     0.150
    72.951   699.004     0.150
    73.040   683.805     0.150
    73.489   686.361     0.150
    73.572   685.504     0.150
    73.572   712.004     0.150
    73.584   685.805     0.150
    73.767   687.793     0.150
    73.767   687.805     0.150
    73.866   686.904     0.150
    73.970   689.104     0.150
    73.970   689.104     0.150
    74.345   689.504     0.150
    74.345   689.504     0.150
    74.438   692.504     0.150
    74.442   690.904     0.150
    74.486    15.480     0.150
    74.821   692.904     0.150
    75.025    16.109     0.150
    75.025   694.305     0.150
    75.025    16.100     0.150
    75.087    15.000     0.150
    75.087   696.004     0.150
    75.087    15.000     0.150
    75.091    15.900     0.150
    75.205   695.104     0.150
    75.222   695.254     0.150
    75.222   695.305     0.150
    75.374   711.404     0.150
    75.374   716.904     0.150
    75.374   972.703     0.150
    75.374  1332.703     0.150
    75.439   696.805     0.150
    75.529   697.104     0.150
    75.629   698.004     0.150
    75.643   697.904     0.150
    76.040   699.904     0.150
    76.071   699.865     0.150
    76.136   700.504     0.150
    76.183   701.404     0.150
    76.231   701.604     0.150
    76.481   704.004     0.150
    76.484   702.594     0.150
    76.484   702.604     0.150
    76.484   702.504     0.150
    76.505   703.203     0.150
    76.512   702.904     0.150
    76.516   703.203     0.150
    76.543   703.404     0.150
    76.552   702.904     0.150
    76.575   702.904     0.150
    76.955   705.395     0.150
    76.956   705.203     0.150
    77.002    18.500     0.150
    77.002    24.500     0.150
    77.002   862.604     0.150
    77.002   998.004     0.150
    77.002  1340.004     0.150
    77.002  1592.004     0.150
    77.002  1832.004     0.150
    77.002   704.504     0.150
    77.002    18.500     0.150
    77.002    27.400     0.150
    77.002  1285.004     0.150
    77.007   731.953     0.150
    77.007   704.904     0.150
    77.007   731.904     0.150
    77.049   706.004     0.150
    77.253   706.508     0.150
    77.253   708.104     0.150
    77.460   708.104     0.150
    77.494   708.404     0.150
    77.696   709.703     0.150
    77.956    15.830     0.150
    78.538   714.504     0.150
    78.557   714.203     0.150
    78.644   715.504     0.150
    78.721   714.023     0.150
    78.742   714.805     0.150
    78.771   714.633     0.150
    78.790   715.123     0.150
    78.947    15.670     0.150
    78.981   716.604     0.150
    79.377   719.004     0.150
    79.429    15.781     0.150
    79.450   719.203     0.150
    79.484    16.320     0.150
    79.484   720.604     0.150
    79.516   719.693     0.150
    79.516   719.604     0.150
    79.516   719.504     0.150
    79.516   719.703     0.150
    79.724   720.604     0.150
    80.134   722.703     0.150
    80.402    15.699     0.150
    80.443   723.904     0.150
    80.443   723.904     0.150
    80.481   724.104     0.150
    80.691   724.023     0.150
    80.751   725.805     0.150
    80.751   725.805     0.150
    80.774   726.004     0.150
    80.832   724.703     0.150
    81.045   727.074     0.150
    81.098   726.635     0.150
    81.098   726.604     0.150
    81.078   727.203     0.150
    81.380    16.730     0.150
    81.463   728.504     0.150
    81.505   729.584     0.150
    81.505   729.604     0.150
    81.532   729.805     0.150
    81.532   729.805     0.150
    81.672   729.904     0.150
    81.760   730.904     0.150
    81.781   730.805     0.150
    81.902   732.004     0.150
    81.946    15.410     0.150
    82.133   731.703     0.150
    82.279    16.199     0.150
    82.375    16.170     0.150
    82.479    15.650     0.150
    82.488    14.990     0.150
    82.488   734.203     0.150
    82.665   735.004     0.150
    82.735   735.623     0.150
    83.086    15.979     0.150
    83.372   739.203     0.150
    83.441   739.305     0.150
    83.489    15.869     0.150
    83.490   738.805     0.150
    83.674   740.604     0.150
    83.950   742.805     0.150
    84.143   743.104     0.150
    84.182   743.203     0.150
    84.182   743.203     0.150
    84.200   742.703     0.150
    84.282   743.404     0.150
    84.419   744.904     0.150
    84.451   745.203     0.150
    84.551   745.004     0.150
    84.577   744.703     0.150
    84.595   744.604     0.150
    84.660   746.604     0.150
    85.180   747.604     0.150
    85.239   748.904     0.150
    85.289   747.604     0.150
    85.299  6347.104     0.150
    85.839    16.260     0.150
    85.843   750.404     0.150
    85.915    16.160     0.150
    85.915   753.203     0.150
    85.915    16.201     0.150
    86.049  6403.504     0.150
    86.114   752.805     0.150
    86.176  6412.604     0.150
    86.268   754.004     0.150
    86.336    16.121     0.150
    86.360    16.449     0.150
    86.360   755.604     0.150
    86.360    16.400     0.150
    86.366  6428.703     0.150
    86.690   755.904     0.150
    86.826    16.320     0.150
    87.296   759.305     0.150
    87.541    15.850     0.150
    87.541   760.805     0.150
    87.541    15.799     0.150
    87.617   760.305     0.150
    87.687    16.250     0.150
    87.717   761.404     0.150
    87.740    16.359     0.150
    87.780    15.889     0.150
    88.047   763.203     0.150
    89.075   767.904     0.150
    89.641    16.439     0.150
    89.641   769.805     0.150
    89.641    16.500     0.150
    89.712    16.150     0.150
    89.861    16.170     0.150
    89.897    16.500     0.150
    89.926   770.518     0.150
    89.926    16.381     0.150
    90.078   773.004     0.150
    90.301  6721.004     0.150
    90.487   773.107     0.150
    90.653    16.070     0.150
    91.143    16.381     0.150
    91.397   777.221     0.150
    93.174   785.904     0.150
   114.246  1109.766     0.150
   118.403  1120.104     0.150
   139.484  1160.404     0.150
   142.748  1162.404     0.150
   146.266  1170.904     0.150
   149.755  1183.203     0.150
   151.662  1187.004     0.150
   151.971  1187.404     0.150
     0.341    16.658     0.150
     0.341    10.358     0.150
     1.418    22.958     0.150
     1.805    47.183     0.150
     1.805    44.848     0.150
     6.775   183.058     0.150
     6.868    98.558     0.150
     6.868   175.358     0.150
     9.570   247.158     0.150
     9.544   231.283     0.150
     9.544   236.608     0.150
    10.008   262.458     0.150
    10.933   284.658     0.150
    12.589   321.408     0.150
    12.589   321.408     0.150
    12.589   176.958     0.150
    12.918   192.158     0.150
    14.433   367.058     0.150
    15.218   206.488     0.150
    15.484   388.658     0.150
    16.575   408.458     0.150
    17.592   241.558     0.150
    17.921   243.408     0.150
    20.288    18.800     0.150
    20.288   497.458     0.150
    20.299   269.058     0.150
    20.712   498.158     0.150
    21.266   298.358     0.150
    21.266   532.958     0.150
    23.491    14.200     0.150
    23.785   559.558     0.150
    24.687   563.958     0.150
    27.889    11.900     0.150
    27.889    17.400     0.150
    27.889   650.258     0.150
    28.723   350.258     0.150
    30.259  2262.994     0.150
    30.270  2262.718     0.150
    30.277  2258.717     0.150
    30.770    14.800     0.150
    30.770    23.000     0.150
    30.770   694.158     0.150
    31.135  2326.542     0.150
    31.139  2326.728     0.150
    31.153  2321.476     0.150
    31.241   670.258     0.150
    32.527    14.400     0.150
    32.527    22.000     0.150
    33.220    13.600     0.150
    33.220    20.100     0.150
    33.610    15.700     0.150
    37.225    16.000     0.150
    37.225    23.100     0.150
    39.777    13.200     0.150
    39.777    20.200     0.150
    41.732   465.308     0.150
    42.432   468.458     0.150
    42.541   469.358     0.150
    42.742   471.058     0.150
    42.955   476.638     0.150
    43.172   477.058     0.150
    43.342   474.078     0.150
    43.666   478.358     0.150
    43.711   478.758     0.150
    43.797   480.078     0.150
    43.995   481.558     0.150
    43.956   482.178     0.150
    43.956   481.858     0.150
    44.078   482.858     0.150
    44.195   484.308     0.150
    44.534   486.058     0.150
    44.781   489.738     0.150
    44.949   489.678     0.150
    44.893   485.458     0.150
    45.239   493.558     0.150
    45.488   496.048     0.150
    46.622   503.458     0.150
    47.031   505.758     0.150
    48.090   513.728     0.150
    49.043   541.658     0.150
    49.144   520.958     0.150
    49.205   522.528     0.150
    49.205   522.256     0.150
    49.524    14.800     0.150
    49.799   527.958     0.150
    50.135   531.658     0.150
    50.357   532.098     0.150
    51.663   540.358     0.150
    51.663   540.358     0.150
    54.254   560.358     0.150
    55.704   569.758     0.150
    56.777   576.958     0.150
    56.997   579.988     0.150
    58.941   591.758     0.150
    59.487   595.458     0.150
    59.968   597.358     0.150
    60.603   603.258     0.150
    62.227    16.990     0.150
    62.466   618.858     0.150
    63.756   646.858     0.150
    63.832   627.058     0.150
    64.615   629.858     0.150
    64.714   630.458     0.150
    64.762   632.758     0.150
    65.387   636.158     0.150
    65.533   637.658     0.150
    66.201   645.558     0.150
    66.201   793.058     0.150
    66.201  1178.758     0.150
    66.202    12.090     0.150
    66.203   641.658     0.150
    66.994   648.158     0.150
    67.062    23.400     0.150
    67.494   650.658     0.150
    67.511  1217.158     0.150
    68.248   654.658     0.150
    68.283   654.458     0.150
    68.392   656.042     0.150
    68.392   655.796     0.150
    68.618   656.258     0.150
    68.986   662.658     0.150
    69.554   664.828     0.150
    69.554   663.919     0.150
    69.776   662.458     0.150
    69.776   662.658     0.150
    69.867   664.958     0.150
    70.138   666.458     0.150
    70.138   666.337     0.150
    70.879   668.158     0.150
    71.091   670.358     0.150
    71.379   671.458     0.150
    71.392   673.536     0.150
    71.970   677.828     0.150
    71.998   678.658     0.150
    72.208    11.960     0.150
    72.549   681.458     0.150
    72.593   681.596     0.150
    72.704   682.258     0.150
    73.016   684.258     0.150
    73.098   685.058     0.150
    73.356   684.258     0.150
    73.682   687.358     0.150
    73.823  1312.158     0.150
    73.858   688.628     0.150
    73.858   688.658     0.150
    73.967   688.358     0.150
    74.434   690.678     0.150
    74.434   690.658     0.150
    74.501   693.958     0.150
    74.538   692.358     0.150
    75.102   695.958     0.150
    75.320   696.658     0.150
    75.469   715.858     0.150
    75.625   698.358     0.150
    75.726   699.258     0.150
    76.131   701.338     0.150
    76.131   701.358     0.150
    76.236   702.658     0.150
    76.257   703.758     0.150
    76.257   703.758     0.150
    76.281   702.858     0.150
    76.291  1276.358     0.150
    76.291   702.058     0.150
    76.291  1276.358     0.150
    76.583   703.558     0.150
    76.615   704.458     0.150
    76.615   708.258     0.150
    76.624   704.648     0.150
    76.624   705.928     0.150
    76.624   705.928     0.150
    76.624   704.658     0.150
    76.652   704.358     0.150
    76.838   703.667     0.150
    77.071   708.308     0.150
    77.053   706.158     0.150
    77.103   706.158     0.150
    77.103   726.658     0.150
    77.103  1344.658     0.150
    77.103  1656.658     0.150
    77.103  1878.658     0.150
    77.103   706.158     0.150
    77.103    22.500     0.150
    77.103  1287.658     0.150
    77.108   728.828     0.150
    77.108   706.158     0.150
    77.108   728.858     0.150
    77.108  1289.658     0.150
    77.150   707.258     0.150
    77.150   716.458     0.150
    77.324   709.158     0.150
    77.324   709.047     0.150
    77.333   708.158     0.150
    77.560   709.858     0.150
    77.560   731.058     0.150
    77.560  1293.058     0.150
    77.570   709.858     0.150
    77.595   709.658     0.150
    77.595   730.558     0.150
    77.595  1296.958     0.150
    77.622   710.458     0.150
    77.794   710.958     0.150
    77.809   710.958     0.150
    78.185   712.558     0.150
    78.658   715.558     0.150
    78.658  1308.258     0.150
    78.725   715.744     0.150
    78.842   716.258     0.150
    79.082   717.958     0.150
    79.464   720.058     0.150
    79.464    15.600     0.150
    79.606   720.858     0.150
    79.606   720.758     0.150
    79.774   721.656     0.150
    79.774   721.558     0.150
    80.006  1356.290     0.150
    80.583   725.958     0.150
    81.367   728.858     0.150
    81.608   730.309     0.150
    81.598   730.858     0.150
    81.775   731.658     0.150
    81.849   731.858     0.150
    81.849   731.858     0.150
    81.871   732.758     0.150
    81.897   729.608     0.150
    83.674   740.771     0.150
    84.144   743.323     0.150
    84.256   745.058     0.150
    84.653   746.658     0.150
    84.732   747.858     0.150
    84.772   748.278     0.150
    85.245  6369.458     0.150
    85.997   754.158     0.150
    85.989  6423.858     0.150
    86.039  6427.458     0.150
    86.117  6433.658     0.150
    86.329  6455.257     0.150
    86.341  6449.958     0.150
    86.422    17.500     0.150
    86.442   756.958     0.150
    86.887   757.734     0.150
    87.132   758.458     0.150
    87.362   760.958     0.150
    87.618   762.058     0.150
    87.795   762.908     0.150
    88.132   764.158     0.150
    88.146   764.238     0.150
    88.431   765.476     0.150
    89.158   769.158     0.150
    89.158    14.700     0.150
    89.721   772.498     0.150
    89.721   772.458     0.150
    89.721    17.100     0.150
    90.177   774.958     0.150
    90.177    14.300     0.150
    90.235  6740.558     0.150
    91.386   779.088     0.150
    91.386    18.340     0.150
    92.879   785.646     0.150
   114.334  1110.733     0.150
   126.280  1137.058     0.150
   128.543  1139.658     0.150
   132.070  1146.428     0.150
   139.562  1161.658     0.150
   146.162  1170.858     0.150
     1.855    56.559     0.150
     1.855    56.562     0.150
     2.878    42.031     0.150
     3.385    49.332     0.150
     3.841    51.734     0.150
     4.665    68.633     0.150
     6.870   181.934     0.150
     6.870   182.680     0.150
     7.302  2573.133     0.150
     8.326  2543.133     0.150
     9.523   229.734     0.150
    10.080   140.133     0.150
    10.080   147.133     0.150
    10.080   154.633     0.150
    10.080   262.633     0.150
    10.981   282.133     0.150
    12.278   310.934     0.150
    12.637   324.461     0.150
    12.637   324.461     0.150
    12.637   177.633     0.150
    12.637   324.434     0.150
    12.988   197.133     0.150
    13.509   188.332     0.150
    14.593   199.152     0.150
    14.593   199.207     0.150
    15.180   211.758     0.150
    15.180   363.859     0.150
    16.634   236.434     0.150
    16.634     6.699     0.150
    20.352   498.934     0.150
    20.363   269.031     0.150
    20.751   498.633     0.150
    21.777    10.500     0.150
    21.777    17.500     0.150
    21.777   527.633     0.150
    22.172   288.133     0.150
    22.172   303.332     0.150
    22.172   326.734     0.150
    23.232   302.332     0.150
    23.558    12.000     0.150
    23.558   545.633     0.150
    23.558   566.633     0.150
    23.847    12.301     0.150
    23.847    20.000     0.150
    23.847   553.633     0.150
    24.335   311.434     0.150
    26.322   752.852     0.150
    26.602   337.133     0.150
    26.602    11.500     0.150
    27.843   630.031     0.150
    27.947    11.801     0.150
    27.947    17.301     0.150
    28.185   347.152     0.150
    28.185   370.531     0.150
    28.694   349.633     0.150
    28.643   351.734     0.150
    29.430   354.062     0.150
    30.185  2259.566     0.150
    30.196  2260.406     0.150
    30.203  2259.977     0.150
    30.834    13.000     0.150
    30.834    19.699     0.150
    30.834   674.934     0.150
    30.834   696.633     0.150
    31.062  2324.492     0.150
    31.066  2327.324     0.150
    31.079  2322.715     0.150
    31.277   369.633     0.150
    31.277   671.133     0.150
    32.595    11.301     0.150
    32.595    17.000     0.150
    32.595   717.633     0.150
    32.595  1011.434     0.150
    33.278    12.000     0.150
    33.278    17.500     0.150
    33.659    14.699     0.150
    33.659    19.199     0.150
    36.490   417.531     0.150
    36.451    16.699     0.150
    36.576   413.703     0.150
    37.276     9.000     0.150
    37.276    12.500     0.150
    37.276   511.633     0.150
    37.396   432.145     0.150
    39.512   797.066     0.150
    39.512   571.582     0.150
    39.512   797.074     0.150
    39.512   443.234     0.150
    39.512   571.633     0.150
    39.512   797.031     0.150
    39.850    11.500     0.150
    39.850    18.500     0.150
    40.744   822.273     0.150
    42.416   847.926     0.150
    42.416   808.723     0.150
    42.416   847.922     0.150
    42.416   468.332     0.150
    42.416   847.934     0.150
    42.615   470.234     0.150
    42.615  2225.484     0.150
    42.615  2367.332     0.150
    42.615   470.184     0.150
    42.615   853.781     0.150
    42.615   470.133     0.150
    42.615   853.832     0.150
    42.675   472.812     0.150
    42.725   474.133     0.150
    42.817   471.832     0.150
    42.944   853.883     0.150
    43.014   477.102     0.150
    43.235    14.000     0.150
    43.235   863.133     0.150
    43.235   477.234     0.150
    43.600   478.332     0.150
    43.661   478.434     0.150
    43.702   478.633     0.150
    43.686   479.793     0.150
    43.872   870.305     0.150
    43.992   481.434     0.150
    44.003   482.535     0.150
    44.241   484.660     0.150
    44.241   818.453     0.150
    44.241  2404.383     0.150
    44.411  2387.883     0.150
    44.526   486.031     0.150
    44.652   488.133     0.150
    44.771   488.574     0.150
    44.952   889.633     0.150
    44.952   489.531     0.150
    45.233   492.531     0.150
    45.767   497.902     0.150
    47.022   505.832     0.150
    47.375   914.934     0.150
    48.114   931.199     0.150
    48.165   514.273     0.150
    49.149   521.242     0.150
    49.117   539.133     0.150
    49.117   600.133     0.150
    49.117   945.133     0.150
    49.117   972.133     0.150
    49.279   522.902     0.150
    49.279   522.949     0.150
    49.279   522.887     0.150
    49.279   522.934     0.150
    49.382   523.332     0.150
    49.597    13.000     0.150
    51.582   543.031     0.150
    51.737   541.031     0.150
    52.143   669.734     0.150
    52.143   732.734     0.150
    52.143  1132.434     0.150
    52.143  1203.133     0.150
    52.143  1298.133     0.150
    53.096   554.633     0.150
    53.356    18.000     0.150
    53.742   557.434     0.150
    55.427   568.934     0.150
    55.626   568.633     0.150
    55.707   569.734     0.150
    55.735   570.332     0.150
    56.216   577.633     0.150
    56.849   577.734     0.150
    57.059   579.672     0.150
    57.194   579.633     0.150
    57.655   584.242     0.150
    57.652   582.633     0.150
    58.450   728.133     0.150
    58.450   808.133     0.150
    58.450  1077.133     0.150
    58.450  1175.133     0.150
    58.450  1439.133     0.150
    58.395   588.133     0.150
    59.002   592.332     0.150
    59.548  2395.984     0.150
    59.548   596.422     0.150
    62.135   616.234     0.150
    62.446   616.531     0.150
    62.446  1118.934     0.150
    62.624   616.332     0.150
    63.561   626.633     0.150
    63.561   626.633     0.150
    63.810   626.934     0.150
    63.826   644.031     0.150
    63.826  1138.633     0.150
    63.826  1172.531     0.150
    64.685    13.801     0.150
    64.685    20.500     0.150
    64.685   667.234     0.150
    64.685  1183.332     0.150
    64.685  1567.531     0.150
    64.780   631.133     0.150
    64.813   633.207     0.150
    64.813   633.152     0.150
    64.813   633.133     0.150
    65.428   634.523     0.150
    65.428   636.633     0.150
    65.556   635.133     0.150
    66.965   647.734     0.150
    67.136   675.531     0.150
    67.136  1180.734     0.150
    67.473   650.434     0.150
    67.585   648.332     0.150
    67.584  1185.434     0.150
    67.584   652.723     0.150
    68.219   654.531     0.150
    68.317   653.531     0.150
    68.466   656.480     0.150
    68.616   656.434     0.150
    68.743   657.031     0.150
    68.900    19.000     0.150
    68.900   658.133     0.150
    68.900  1199.133     0.150
    69.517   662.602     0.150
    69.628   664.332     0.150
    69.837   665.234     0.150
    69.838   663.133     0.150
    69.838  2350.359     0.150
    70.369   926.234     0.150
    70.369  1679.234     0.150
    70.538   665.934     0.150
    70.832  1223.234     0.150
    70.878   669.395     0.150
    71.159  1225.152     0.150
    71.159   671.234     0.150
    71.159  1225.133     0.150
    71.441   673.531     0.150
    71.464   674.348     0.150
    71.945   675.914     0.150
    71.976   678.734     0.150
    72.511   680.516     0.150
    72.492  1243.133     0.150
    72.518   680.633     0.150
    72.674   682.234     0.150
    72.993   684.332     0.150
    73.069   685.031     0.150
    73.109  2344.633     0.150
    73.109  2344.633     0.150
    73.273   686.273     0.150
    73.392   688.254     0.150
    73.421   684.734     0.150
    73.702   688.734     0.150
    73.734   709.133     0.150
    73.734  1017.133     0.150
    73.734   686.133     0.150
    73.734   709.133     0.150
    73.734   853.133     0.150
    73.734  1254.133     0.150
    73.734  1283.133     0.150
    73.750   688.031     0.150
    73.750  1257.832     0.150
    73.792   689.031     0.150
    73.808   687.633     0.150
    73.818   689.133     0.150
    73.883   688.672     0.150
    73.893   851.434     0.150
    73.893   958.434     0.150
    73.893  1726.332     0.150
    74.033   688.102     0.150
    74.033   688.133     0.150
    74.033  1260.832     0.150
    74.218   689.934     0.150
    74.477   693.633     0.150
    74.562   695.055     0.150
    74.608   693.031     0.150
    74.608  1268.633     0.150
    75.088   695.734     0.150
    75.109   696.734     0.150
    75.370   698.582     0.150
    75.389   697.332     0.150
    75.389  1275.734     0.150
    75.573   698.367     0.150
    75.694  4881.133     0.150
    75.747   699.062     0.150
    75.747   699.031     0.150
    75.795  1282.031     0.150
    75.795   700.031     0.150
    75.795  1282.031     0.150
    76.202   702.031     0.150
    76.304  1286.473     0.150
    76.304   702.434     0.150
    76.304  1286.434     0.150
    76.331   878.434     0.150
    76.331  2323.984     0.150
    76.349   703.531     0.150
    76.359   702.734     0.150
    76.359  1282.531     0.150
    76.433   703.234     0.150
    76.504   705.133     0.150
    76.651   704.633     0.150
    76.651   704.633     0.150
    76.670   707.734     0.150
    76.683   705.133     0.150
    76.683   880.031     0.150
    76.683  1286.734     0.150
    76.698   705.375     0.150
    76.719   705.332     0.150
    76.719   709.133     0.150
    77.120   707.523     0.150
    77.122   707.332     0.150
    77.170   711.133     0.150
    77.170  1597.133     0.150
    77.170  1861.133     0.150
    77.170  1927.133     0.150
    77.170   706.934     0.150
    77.170    17.199     0.150
    77.170  1290.133     0.150
    77.174  1282.133     0.150
    77.174  1582.133     0.150
    77.174   706.934     0.150
    77.174   719.734     0.150
    77.174  1282.133     0.150
    77.217   707.633     0.150
    77.217   711.434     0.150
    77.262   710.734     0.150
    77.305   709.133     0.150
    77.430   710.133     0.150
    77.627   710.234     0.150
    77.627  1296.934     0.150
    77.637   710.133     0.150
    77.637   714.531     0.150
    77.637  1295.633     0.150
    77.662   710.133     0.150
    77.662   714.031     0.150
    77.662  1296.031     0.150
    77.843   710.031     0.150
    77.851   711.434     0.150
    77.851   715.434     0.150
    77.863   711.734     0.150
    77.863  4867.531     0.150
    78.251   713.434     0.150
    78.553   723.434     0.150
    78.529   715.832     0.150
    78.620   715.332     0.150
    78.725   716.145     0.150
    78.725   716.133     0.150
    78.725   719.734     0.150
    78.725   732.133     0.150
    78.725   896.434     0.150
    78.725  1309.332     0.150
    78.910   716.832     0.150
    78.910  2323.082     0.150
    78.910   716.734     0.150
    79.148   718.234     0.150
    79.397   716.332     0.150
    79.397   719.234     0.150
    79.512   721.332     0.150
    79.537   721.031     0.150
    79.636   722.133     0.150
    79.678   721.723     0.150
    79.847   722.531     0.150
    80.258  1847.055     0.150
    80.648   726.332     0.150
    80.873   722.234     0.150
    80.942   728.031     0.150
    80.999   728.863     0.150
    81.158   728.934     0.150
    81.224   729.031     0.150
    81.341   721.742     0.150
    81.436   729.434     0.150
    81.668   731.531     0.150
    81.695   730.902     0.150
    81.840   732.133     0.150
    81.892   732.734     0.150
    81.943   732.832     0.150
    81.943   732.934     0.150
    82.570   735.531     0.150
    83.015   739.715     0.150
    83.072   742.031     0.150
    83.307   742.781     0.150
    83.333   743.734     0.150
    83.359   742.832     0.150
    84.326   745.434     0.150
    84.442   745.332     0.150
    84.714   747.934     0.150
    84.714   747.793     0.150
    84.719   747.633     0.150
    84.768   747.805     0.150
    85.171  6375.734     0.150
    85.269   749.570     0.150
    85.397   750.734     0.150
    85.853   753.734     0.150
    85.929  2324.184     0.150
    85.915  6431.332     0.150
    86.000   754.234     0.150
    85.965  6433.934     0.150
    86.043  6440.531     0.150
    86.258  6460.531     0.150
    86.267  6442.234     0.150
    86.433   757.332     0.150
    87.249   760.434     0.150
    87.340   761.332     0.150
    87.604   761.934     0.150
    87.604   761.934     0.150
    88.127   764.332     0.150
    88.708  6698.055     0.150
    88.815  6698.090     0.150
    89.151   769.332     0.150
    89.151   769.285     0.150
    89.575   771.215     0.150
    89.711   770.023     0.150
    89.711   770.031     0.150
    89.937   772.668     0.150
    90.004   773.133     0.150
    90.187   774.633     0.150
    90.161  6747.434     0.150
    90.591   776.223     0.150
    90.591   776.234     0.150
    91.381   779.531     0.150
    91.487   782.254     0.150
    91.487   782.234     0.150
    92.640  1025.133     0.150
    92.656  1002.031     0.150
    92.876   786.898     0.150
    93.404   785.934     0.150
    93.404   785.934     0.150
    93.404   786.250     0.150
    94.354  1434.133     0.150
    95.415  1036.633     0.150
    95.793  1040.234     0.150
    96.067   800.531     0.150
    96.067  1033.531     0.150
    96.067  1433.332     0.150
    96.092   791.883     0.150
    96.209  1047.531     0.150
    96.329  1045.332     0.150
    96.687  1038.504     0.150
    96.687    14.121     0.150
    96.687   803.633     0.150
    96.687  1038.434     0.150
    96.687  1436.934     0.150
   102.440  1087.156     0.150
   102.440   830.812     0.150
   102.440  1087.152     0.150
   114.406  1626.156     0.150
   115.886  1121.875     0.150
   118.486  1122.152     0.150
   119.259  1119.523     0.150
   120.463  1128.824     0.150
   120.750  1125.234     0.150
   121.471  1128.074     0.150
   123.037  1135.473     0.150
   123.176  1231.906     0.150
   123.550  1131.934     0.150
   128.780  1141.852     0.150
   132.029  1147.121     0.150
   142.625  1163.934     0.150
   146.144  1172.398     0.150
   149.728  1186.172     0.150
   150.308  1187.211     0.150
   151.580  1191.922     0.150
   155.396  1193.562     0.150
   156.900  1191.434     0.150
     0.941    28.008     0.150
    30.186  2251.336     0.150
    30.196  2260.750     0.150
    30.204  2258.328     0.150
    31.062  2320.625     0.150
    31.066  2320.836     0.150
    31.080  2326.469     0.150
     1.844    57.712     0.150
     9.498   229.812     0.150
    30.245  2258.667     0.150
    30.255  2259.388     0.150
    30.263  2258.162     0.150
    31.120  2325.784     0.150
    31.124  2324.673     0.150
    31.137  2322.865     0.150
    78.869   717.388     0.150
     0.193    11.723     0.150
     0.652    11.621     0.150
     0.652    20.223     0.150
     0.951    16.621     0.150
     1.445    42.992     0.150
     4.927    61.922     0.150
     6.989   102.023     0.150
     6.989   177.223     0.150
    12.408   317.051     0.150
    12.408   181.633     0.150
    12.408   179.754     0.150
    12.408   317.051     0.150
    12.408   179.723     0.150
    12.408   317.023     0.150
    13.264   191.398     0.150
    13.264   194.152     0.150
    14.524   205.523     0.150
    14.527   205.152     0.150
    19.982   271.121     0.150
    21.096   279.824     0.150
    25.387   326.223     0.150
    25.831   328.121     0.150
    30.458     8.398     0.150
    30.458    11.898     0.150
    30.710  2269.578     0.150
    30.721  2268.379     0.150
    30.728  2270.770     0.150
    31.588  2335.113     0.150
    31.592  2334.551     0.150
    31.605  2336.387     0.150
    32.171     9.602     0.150
    32.171    13.402     0.150
    32.171   553.023     0.150
    42.114   468.422     0.150
    42.114   468.434     0.150
    42.114   582.832     0.150
    43.093   477.422     0.150
    43.356   478.824     0.150
    43.585   480.324     0.150
    43.650   483.293     0.150
    43.650   483.324     0.150
    44.470   488.824     0.150
    46.970   507.922     0.150
    49.001   522.723     0.150
    51.238   539.824     0.150
    51.238   539.723     0.150
    52.829    18.598     0.150
    52.829  1219.023     0.150
    56.930   581.574     0.150
    56.930   581.621     0.150
    63.848   629.723     0.150
    64.162   627.523     0.150
    65.054   637.223     0.150
    65.522   638.891     0.150
    68.313   657.922     0.150
    68.583   658.621     0.150
    69.938   668.223     0.150
    70.687   673.621     0.150
    72.013   681.324     0.150
    73.042   687.121     0.150
    73.158   688.023     0.150
    74.087   693.023     0.150
    74.534   696.922     0.150
    75.805   701.633     0.150
    76.134   704.621     0.150
    76.168   704.824     0.150
    76.168   711.422     0.150
    76.603   706.121     0.150
    76.603   706.121     0.150
    76.660   705.723     0.150
    76.660    21.102     0.150
    76.660   705.723     0.150
    76.660    21.102     0.150
    76.885   708.020     0.150
    78.212   716.023     0.150
    78.212    22.598     0.150
    78.212   716.023     0.150
    78.212   738.621     0.150
    78.396   714.996     0.150
    79.445   722.098     0.150
    85.935   756.023     0.150
    87.585   764.523     0.150
    89.088   771.824     0.150
   124.979  1136.023     0.150
   146.382  1176.422     0.150
   149.982  1183.824     0.150
     0.300     9.559     0.150
     0.933    27.762     0.150
     6.902    99.160     0.150
    43.884   480.359     0.150
    48.123   512.355     0.150
    64.776   630.961     0.150
     2.185    35.297     0.150
     5.455    82.793     0.150
     6.743    97.195     0.150
     9.395   226.969     0.150
    12.548   180.164     0.150
    12.548   179.242     0.150
    12.548   179.293     0.150
    14.720   199.902     0.150
    15.614   229.895     0.150
    18.073   243.094     0.150
    30.366   367.594     0.150
    30.781   372.594     0.150
    30.781    16.500     0.150
    30.781    26.000     0.150
    32.560    17.500     0.150
    32.560   729.293     0.150
    32.560   822.293     0.150
    42.620   470.195     0.150
    42.620   470.195     0.150
    42.821   471.895     0.150
    48.195   516.793     0.150
    51.740   540.895     0.150
    51.740   540.695     0.150
    64.731   628.195     0.150
    73.701   690.195     0.150
    12.574   181.945     0.150
    26.251   329.328     0.150
    30.249  2258.078     0.150
    30.260  2262.375     0.150
    30.267  2260.211     0.150
    31.125  2327.039     0.150
    31.128  2321.469     0.150
    31.142  2328.812     0.150
    39.447   568.859     0.150
     2.312    62.029     0.150
     2.667    42.029     0.150
     2.693    42.029     0.150
     2.693    72.029     0.150
    30.081  2255.734     0.150
    30.091  2256.441     0.150
    30.098  2257.090     0.150
    30.957  2327.482     0.150
    30.960  2319.209     0.150
    30.974  2327.305     0.150
    44.449   485.029     0.150
     0.909    28.367     0.150
     1.426    41.967     0.150
     8.185   112.467     0.150
     9.493   228.492     0.150
     9.988   159.066     0.150
    12.893   192.467     0.150
    13.425   184.066     0.150
    15.497   211.066     0.150
    17.970   242.506     0.150
    19.548   262.086     0.150
    21.296   506.367     0.150
    21.408   279.967     0.150
    23.461   556.166     0.150
    27.849    16.701     0.150
    30.258  2259.117     0.150
    30.269  2259.680     0.150
    30.276  2259.867     0.150
    30.736    14.600     0.150
    30.736    20.801     0.150
    31.133  2321.947     0.150
    31.137  2325.402     0.150
    31.150  2325.137     0.150
    39.760    21.400     0.150
    42.487   468.355     0.150
    42.529   468.947     0.150
    51.651   538.766     0.150
    53.290  1219.066     0.150
    56.828   577.066     0.150
    57.222   578.492     0.150
    57.222   578.496     0.150
    58.470   600.566     0.150
    58.470   600.666     0.150
    59.262   595.346     0.150
    59.984   596.566     0.150
    60.642   602.967     0.150
    62.404   616.416     0.150
    63.768   644.266     0.150
    64.627  1153.367     0.150
    65.430   636.166     0.150
    65.430   636.256     0.150
    68.392   653.666     0.150
    68.392  1181.666     0.150
    69.801   662.467     0.150
    70.879   670.387     0.150
    72.249   678.309     0.150
    75.264   696.066     0.150
    75.336   696.787     0.150
    75.336   696.787     0.150
    75.336   696.697     0.150
    75.882   701.717     0.150
    76.254   702.416     0.150
    76.254   702.416     0.150
    76.258   702.057     0.150
    76.599   704.006     0.150
    76.629   704.266     0.150
    76.632   727.266     0.150
    76.632   704.467     0.150
    76.669   727.266     0.150
    76.669   704.066     0.150
    77.069   707.467     0.150
    77.123   706.166     0.150
    77.123    15.900     0.150
    77.123   742.066     0.150
    77.127   706.266     0.150
    77.612   732.467     0.150
    77.612   709.666     0.150
    77.810   711.066     0.150
    78.465   714.236     0.150
    78.676   715.467     0.150
    78.741   715.654     0.150
    78.860   716.037     0.150
    78.860   716.066     0.150
    79.421   716.223     0.150
    79.615   719.666     0.150
    79.615   719.787     0.150
    80.951   727.402     0.150
    81.088   729.557     0.150
    85.259  6366.666     0.150
    86.000  6422.967     0.150
    86.050  6425.766     0.150
    86.129  6432.166     0.150
    86.352  6448.766     0.150
    86.615   756.436     0.150
    87.199  6512.367     0.150
    87.924   762.736     0.150
    88.525   765.307     0.150
    88.844   767.506     0.150
    89.023   768.047     0.150
    90.243  6740.266     0.150
     2.252    33.459     0.150
     2.252    59.459     0.150
     2.624    70.459     0.150
     2.672    73.459     0.150
     4.664    86.459     0.150
     4.664   123.459     0.150
     5.413   141.159     0.150
     6.820    93.359     0.150
     8.289   116.519     0.150
     8.577   224.759     0.150
    12.607   324.732     0.150
    12.607   178.459     0.150
    12.607   177.259     0.150
    15.536   225.459     0.150
    17.641   239.979     0.150
    17.954   244.359     0.150
    20.333   268.529     0.150
    21.315   561.759     0.150
    24.311   311.029     0.150
    25.770   327.759     0.150
    25.851   325.699     0.150
    28.160   347.459     0.150
    30.208  2253.493     0.150
    30.219  2260.575     0.150
    30.226  2257.628     0.150
    30.803    15.600     0.150
    30.803    23.300     0.150
    31.084  2326.963     0.150
    31.088  2325.669     0.150
    31.101  2322.098     0.150
    32.565    13.399     0.150
    32.565    21.100     0.150
    38.331   442.703     0.150
    39.822    16.900     0.150
    42.790   471.569     0.150
    42.959   479.659     0.150
    43.868   482.259     0.150
    43.974   481.469     0.150
    44.429   484.229     0.150
    44.546   486.399     0.150
    44.921   488.969     0.150
    46.267   500.999     0.150
    46.477   502.209     0.150
    46.912   509.759     0.150
    47.372   507.309     0.150
    47.639   509.819     0.150
    48.336   515.039     0.150
    48.395   516.389     0.150
    48.939   520.369     0.150
    49.165   521.399     0.150
    49.252   522.459     0.150
    49.252   522.929     0.150
    49.568    14.200     0.150
    49.568    21.300     0.150
    51.710   540.569     0.150
    51.710   540.679     0.150
    53.335   552.369     0.150
    54.295   559.679     0.150
    56.179   570.359     0.150
    56.869   576.609     0.150
    60.647   603.459     0.150
    64.667   770.659     0.150
    65.105   631.159     0.150
    65.429   636.859     0.150
    66.167   641.999     0.150
    68.443   654.359     0.150
    69.559   657.989     0.150
    70.630   670.289     0.150
    70.919   670.559     0.150
    70.986   670.909     0.150
    73.018   683.729     0.150
    73.095   683.259     0.150
    73.095   683.239     0.150
    73.130   683.829     0.150
    73.408   685.559     0.150
    74.590   692.949     0.150
    74.966   694.888     0.150
    75.110   694.759     0.150
    75.110   694.799     0.150
    75.142   694.039     0.150
    75.302   696.859     0.150
    75.347   697.847     0.150
    75.647   697.349     0.150
    75.799   700.781     0.150
    76.167   702.870     0.150
    76.308   700.859     0.150
    76.308   700.829     0.150
    76.308   701.359     0.150
    76.333   702.959     0.150
    76.635   704.923     0.150
    76.635   703.139     0.150
    76.649   705.402     0.150
    76.667   705.259     0.150
    76.676   706.459     0.150
    76.676   706.497     0.150
    76.721   706.051     0.150
    77.106   707.959     0.150
    77.155   707.459     0.150
    77.202   708.459     0.150
    77.385   707.259     0.150
    77.385   707.254     0.150
    77.612   709.959     0.150
    77.646   710.259     0.150
    77.746   710.954     0.150
    77.846   711.659     0.150
    78.108   713.335     0.150
    78.777   713.764     0.150
    78.843   714.899     0.150
    78.894   715.259     0.150
    78.894   715.299     0.150
    79.480   719.087     0.150
    79.516   719.869     0.150
    79.658   722.093     0.150
    80.949   727.636     0.150
    81.121   728.395     0.150
    81.630   730.353     0.150
    81.985   731.989     0.150
    82.513   735.279     0.150
    82.805   737.249     0.150
    83.139   738.929     0.150
    85.954   754.079     0.150
     1.880    32.948     0.150
     1.881    32.948     0.150
    30.202  2259.987     0.150
    30.212  2261.060     0.150
    30.220  2261.686     0.150
    31.077  2320.280     0.150
    31.080  2326.027     0.150
    31.094  2324.373     0.150
    39.492   443.418     0.150
    42.585   469.898     0.150
    42.787   471.578     0.150
    43.848   479.889     0.150
    51.707   540.398     0.150
    51.707   540.238     0.150
    55.934   569.089     0.150
    70.933   668.688     0.150
     0.955    28.711     0.150
     1.871    46.230     0.150
     1.872    46.238     0.150
     4.683    58.910     0.150
    28.192   346.211     0.150
    30.176  2258.191     0.150
    30.187  2259.020     0.150
    30.194  2259.543     0.150
    31.052  2321.105     0.150
    31.056  2326.410     0.150
    31.070  2322.316     0.150
    39.520   569.637     0.150
    42.620   470.492     0.150
    44.428   486.711     0.150
    49.861   528.613     0.150
    53.367   622.211     0.150
    55.635   569.492     0.150
    59.563   597.672     0.150
    68.495   654.688     0.150
    85.942   752.113     0.150
     0.621    12.652     0.150
     0.648    22.414     0.150
     0.755    25.016     0.150
     4.645    69.613     0.150
     7.849   114.695     0.150
     7.848   114.324     0.150
     8.553   127.516     0.150
     8.553   217.215     0.150
    10.164   146.414     0.150
    12.166   176.125     0.150
    12.181   176.312     0.150
    12.181   312.414     0.150
    12.181   176.305     0.150
    12.181   312.395     0.150
    14.874   206.223     0.150
    14.874   206.355     0.150
    15.184   205.516     0.150
    15.248   225.312     0.150
    19.305   270.754     0.150
    23.073   307.016     0.150
    23.983   310.633     0.150
    25.429   325.715     0.150
    25.873   328.395     0.150
    28.824   355.016     0.150
    30.568  2268.523     0.150
    30.579  2261.426     0.150
    30.586  2268.840     0.150
    31.436  2336.418     0.150
    31.440  2332.316     0.150
    31.453  2337.137     0.150
    32.113   387.914     0.150
    32.113    12.102     0.150
    32.113    17.301     0.150
    39.116   573.008     0.150
    39.116   443.535     0.150
    42.175   468.086     0.150
    42.749   473.043     0.150
    43.458   478.395     0.150
    43.874   482.344     0.150
    43.938   482.543     0.150
    44.254   484.926     0.150
    44.818   488.914     0.150
    45.513   490.914     0.150
    45.513   490.914     0.150
    47.147   504.535     0.150
    47.775   513.293     0.150
    47.775   601.305     0.150
    48.830   519.414     0.150
    48.830   519.434     0.150
    49.135   977.016     0.150
    49.368   524.344     0.150
    51.295   539.023     0.150
    57.257   581.883     0.150
    57.304   582.305     0.150
    57.304   635.562     0.150
    59.353   594.984     0.150
    62.074   615.125     0.150
    62.049   614.480     0.150
    62.380   618.145     0.150
    65.411   638.402     0.150
    73.451   686.652     0.150
    78.416   715.875     0.150
     0.271     9.771     0.150
     0.996    30.581     0.150
     2.782    72.381     0.150
     8.207   116.001     0.150
    12.463   180.230     0.150
    30.231  2257.851     0.150
    30.241  2258.002     0.150
    30.249  2259.200     0.150
    31.102  2323.230     0.150
    31.106  2321.499     0.150
    31.119  2324.585     0.150
    42.531   469.121     0.150
    43.807   479.110     0.150
    51.652   539.980     0.150
     2.253    33.748     0.150
     2.253    59.748     0.150
     2.327    36.248     0.150
     2.327    64.049     0.150
     2.629    40.748     0.150
     2.629    70.449     0.150
     2.705    41.949     0.150
     2.705    73.148     0.150
     3.195    47.049     0.150
     3.195    82.348     0.150
    26.307   330.100     0.150
    30.193  2260.627     0.150
    30.204  2260.441     0.150
    30.211  2262.184     0.150
    31.069  2327.383     0.150
    31.073  2328.602     0.150
    31.087  2321.281     0.150
     0.559    10.781     0.150
     2.483    37.082     0.150
     2.501    38.883     0.150
     2.501    68.182     0.150
     2.789    43.182     0.150
     2.789    75.781     0.150
     2.866    44.281     0.150
     2.866    77.682     0.150
     3.412    50.182     0.150
     4.492    68.982     0.150
     6.810    99.043     0.150
     7.889   111.682     0.150
    30.576  2271.977     0.150
    30.587  2265.488     0.150
    30.594  2272.602     0.150
    31.449  2324.293     0.150
    31.453  2332.109     0.150
    31.467  2333.234     0.150
    43.471   479.982     0.150
    58.699   595.398     0.150
     1.846    29.828     0.150
     1.846    55.250     0.150
     2.264    35.547     0.150
     2.643    40.547     0.150
     3.131    46.547     0.150
     4.510   119.547     0.150
     9.635   138.945     0.150
     9.635   249.750     0.150
    10.529   151.148     0.150
    14.562   201.750     0.150
    15.562   216.844     0.150
    21.319   299.750     0.150
    21.319   531.945     0.150
    25.902   325.844     0.150
    25.902   325.844     0.150
    26.346   329.750     0.150
    27.981    15.102     0.150
    27.981    21.695     0.150
    28.204   346.164     0.150
    28.667   408.250     0.150
    28.667   641.844     0.150
    30.170  2255.188     0.150
    30.181  2255.984     0.150
    30.188  2256.523     0.150
    31.048  2325.570     0.150
    31.052  2318.594     0.150
    31.065  2321.844     0.150
    39.875   447.648     0.150
    43.891   479.945     0.150
    44.039   481.445     0.150
    46.845   501.719     0.150
    48.180   513.945     0.150
    49.302   523.648     0.150
    49.622   532.945     0.150
    49.622    13.898     0.150
    49.622   648.148     0.150
    49.622   957.648     0.150
    51.759   540.773     0.150
    51.759   540.750     0.150
    52.155   544.047     0.150
    56.875   578.047     0.150
    57.111   575.250     0.150
    62.512   616.820     0.150
    65.412   636.445     0.150
    66.193   640.648     0.150
    68.481   656.344     0.150
    68.502   656.648     0.150
    70.845   667.047     0.150
    73.034   684.844     0.150
    74.878   693.703     0.150
    74.993   694.836     0.150
    74.993   694.844     0.150
    75.327   697.445     0.150
    75.394   696.750     0.150
    76.345   702.648     0.150
    76.656   704.344     0.150
    76.677   705.344     0.150
    76.724   704.547     0.150
    77.128   705.445     0.150
    77.128   705.445     0.150
    77.173   705.547     0.150
    77.173   705.547     0.150
    77.173    18.000     0.150
    77.773   710.344     0.150
    78.729   715.750     0.150
    78.914   716.547     0.150
    79.501   721.391     0.150
    79.687   721.648     0.150
    79.872   721.945     0.150
    81.151   729.836     0.150
    85.893   753.445     0.150
   151.749  1180.945     0.150
     0.663    14.637     0.150
     0.663    25.637     0.150
    30.572  2267.742     0.150
    30.583  2275.230     0.150
    30.590  2273.805     0.150
    31.451  2336.215     0.150
    31.455  2334.516     0.150
    31.468  2333.816     0.150
     0.468    10.469     0.150
     0.822    16.773     0.150
     2.337    36.875     0.150
     2.612    40.969     0.150
     2.612    72.070     0.150
     2.689    42.672     0.150
     2.689    74.773     0.150
     4.215    63.969     0.150
     4.528    69.172     0.150
     4.923    75.375     0.150
     4.923    76.672     0.150
     7.050   106.875     0.150
     7.065   103.875     0.150
     7.065   102.719     0.150
     7.877   116.672     0.150
     7.877   116.273     0.150
     7.877   116.289     0.150
     7.889   117.172     0.150
     8.127   120.773     0.150
     8.127   209.672     0.150
     9.967   143.969     0.150
    13.374   193.875     0.150
    14.998   205.969     0.150
    20.799   279.070     0.150
    25.391   323.875     0.150
    25.835   329.672     0.150
    25.835   327.375     0.150
    30.728  2275.562     0.150
    30.739  2267.805     0.150
    30.746  2277.477     0.150
    31.608  2336.570     0.150
    31.612  2337.508     0.150
    31.626  2344.195     0.150
    38.067    22.797     0.150
    39.378   451.469     0.150
    39.378     5.500     0.150
    42.114   467.969     0.150
    42.315   469.781     0.150
    43.347   477.969     0.150
    43.829   483.102     0.150
    44.241   484.875     0.150
    48.286   518.672     0.150
    49.129   529.969     0.150
    49.129    23.203     0.150
    49.129   645.969     0.150
    49.129   945.969     0.150
    51.238   539.133     0.150
    51.238   539.180     0.150
    51.238   539.219     0.150
    52.804   547.172     0.150
    55.661   572.898     0.150
    64.129   628.773     0.150
    67.924   652.875     0.150
    67.924   652.875     0.150
    67.945   656.273     0.150
    69.298   663.273     0.150
    85.783   747.969     0.150
    85.932   756.172     0.150
     0.823    16.113     0.150
     0.817    14.715     0.150
     2.324    38.414     0.150
     2.336    35.113     0.150
     4.204    65.312     0.150
     7.085   107.035     0.150
    30.721  2269.145     0.150
    30.732  2272.707     0.150
    30.739  2276.793     0.150
    31.602  2341.301     0.150
    31.606  2335.254     0.150
    31.619  2333.270     0.150
    42.126   469.680     0.150
    64.229   631.453     0.150
     7.270   191.803     0.150
     8.397   209.451     0.150
     9.840   236.152     0.150
    13.082   327.451     0.150
    15.409   368.227     0.150
    30.016  2253.643     0.150
    30.027  2255.623     0.150
    30.034  2257.045     0.150
    30.905  2319.730     0.150
    30.909  2318.568     0.150
    30.922  2319.023     0.150
    31.231    16.900     0.150
    31.231    23.900     0.150
    34.102   399.553     0.150
    39.708   816.252     0.150
    40.151    28.699     0.150
    44.563   482.672     0.150
    44.583   484.076     0.150
    48.776   516.213     0.150
    49.903    18.801     0.150
    49.903    28.400     0.150
    68.643   652.553     0.150
    68.666   653.303     0.150
    75.659   701.125     0.150
    77.192   707.553     0.150
    78.760   712.752     0.150
    80.531   722.146     0.150
    81.177   726.172     0.150
    81.580   730.943     0.150
     0.310     9.371     0.150
     0.376    10.471     0.150
     0.663    13.471     0.150
     0.722    16.570     0.150
     0.722    29.471     0.150
     0.806    18.971     0.150
     0.916    29.070     0.150
     1.009    30.670     0.150
     1.009    30.471     0.150
     1.029    21.170     0.150
     1.047    21.871     0.150
     1.150    20.670     0.150
     1.426    49.930     0.150
     1.507    26.770     0.150
     1.529    26.670     0.150
     1.735    31.270     0.150
     1.735    47.969     0.150
     1.736    31.260     0.150
     1.736    47.922     0.150
     3.257    51.570     0.150
     3.257    91.570     0.150
     3.257    52.371     0.150
     3.257    91.871     0.150
     3.470    56.770     0.150
     3.470    98.570     0.150
     3.470    57.172     0.150
     3.470   100.570     0.150
     3.545    58.172     0.150
     3.545   100.871     0.150
     4.239   111.172     0.150
     4.239    56.570     0.150
     4.446    70.172     0.150
     4.446   123.871     0.150
     4.466    69.672     0.150
     5.349   151.469     0.150
     5.664    86.770     0.150
     6.019    90.969     0.150
     6.028    90.371     0.150
     6.361    96.969     0.150
     6.409   101.570     0.150
     6.546    99.469     0.150
     6.704   101.770     0.150
     7.044   102.969     0.150
     7.052  2486.570     0.150
     7.445   114.172     0.150
     8.127   123.371     0.150
     8.298   221.270     0.150
     8.262   124.969     0.150
     8.848   128.871     0.150
     9.436   136.770     0.150
     9.563   137.996     0.150
    10.789   301.070     0.150
    10.993   164.570     0.150
    10.993   291.070     0.150
    11.580   300.969     0.150
    11.580   168.570     0.150
    11.714   170.770     0.150
    11.714   303.172     0.150
    12.424   181.570     0.150
    12.424   181.531     0.150
    12.503   182.469     0.150
    12.599   183.371     0.150
    12.599   183.250     0.150
    12.915   185.570     0.150
    12.957   340.969     0.150
    13.245   191.070     0.150
    13.715   197.570     0.150
    14.568   375.070     0.150
    15.120   216.094     0.150
    15.120   216.070     0.150
    15.534   217.969     0.150
    16.446   232.262     0.150
    17.942   249.570     0.150
    19.108   482.770     0.150
    19.119   261.949     0.150
    19.789   268.969     0.150
    20.666   278.469     0.150
    20.666   511.871     0.150
    20.666   969.871     0.150
    20.666   278.449     0.150
    20.987   308.070     0.150
    22.295    27.801     0.150
    22.295   535.871     0.150
    22.622   588.770     0.150
    23.491   553.570     0.150
    24.031   313.742     0.150
    24.623   318.469     0.150
    24.623   318.230     0.150
    24.623   318.469     0.150
    24.623   318.000     0.150
    24.734   588.570     0.150
    25.066   323.371     0.150
    25.761   605.871     0.150
    26.757    13.801     0.150
    26.757   337.590     0.150
    28.786   357.672     0.150
    29.554   363.660     0.150
    29.594     4.801     0.150
    29.594   663.969     0.150
    31.095   375.672     0.150
    31.325   379.469     0.150
    31.325     4.000     0.150
    31.325     7.203     0.150
    31.325   797.172     0.150
    31.337  2368.539     0.150
    31.348  2369.320     0.150
    31.355  2369.883     0.150
    32.097   390.371     0.150
    32.097   703.672     0.150
    32.097   814.070     0.150
    32.197  2433.957     0.150
    32.201  2432.121     0.150
    32.215  2432.227     0.150
    32.574     4.203     0.150
    32.574   827.871     0.150
    36.168     5.000     0.150
    36.168     7.500     0.150
    36.168   507.969     0.150
    38.263   805.121     0.150
    38.584     4.102     0.150
    38.584     9.199     0.150
    38.584   442.871     0.150
    39.501   450.270     0.150
    39.501   809.270     0.150
    40.943   459.070     0.150
    40.943   459.051     0.150
    41.371   465.039     0.150
    41.371   465.371     0.150
    41.371   465.371     0.150
    41.574   466.371     0.150
    41.735   841.859     0.150
    41.735   468.070     0.150
    41.735   841.770     0.150
    42.001   472.340     0.150
    42.001   471.910     0.150
    42.460   473.301     0.150
    42.669   474.867     0.150
    42.669   476.070     0.150
    42.669   476.012     0.150
    42.747   476.371     0.150
    42.793   474.141     0.150
    42.941   478.340     0.150
    43.079   481.266     0.150
    43.079   481.270     0.150
    43.079   480.840     0.150
    43.184   481.871     0.150
    43.288   484.109     0.150
    43.510   481.109     0.150
    43.755   484.332     0.150
    44.086   486.422     0.150
    44.156   487.648     0.150
    44.251   488.449     0.150
    44.274   486.281     0.150
    44.317   486.930     0.150
    44.324   487.531     0.150
    44.167   878.039     0.150
    44.167   488.172     0.150
    44.443   491.262     0.150
    44.511   491.570     0.150
    44.760   492.969     0.150
    44.872   494.070     0.150
    44.864   492.230     0.150
    44.864   492.180     0.150
    44.864   492.172     0.150
    45.009   498.371     0.150
    45.211   496.871     0.150
    45.656   498.270     0.150
    45.736   499.301     0.150
    45.814   501.969     0.150
    45.857   501.469     0.150
    46.092   504.270     0.150
    46.119   907.051     0.150
    46.119   504.070     0.150
    46.119   504.070     0.150
    46.209   505.570     0.150
    46.292   504.871     0.150
    46.523   508.469     0.150
    46.527   515.672     0.150
    46.527   921.750     0.150
    46.590   512.871     0.150
    46.588   509.672     0.150
    46.764   509.672     0.150
    46.856   510.070     0.150
    46.857   509.871     0.150
    46.953   509.570     0.150
    46.953   510.570     0.150
    47.004   511.172     0.150
    47.379   513.172     0.150
    47.390   513.969     0.150
    47.396   513.969     0.150
    47.593   515.672     0.150
    47.606   515.469     0.150
    47.614   521.070     0.150
    47.741   517.859     0.150
    47.737   520.570     0.150
    48.023   517.617     0.150
    48.023   519.172     0.150
    48.328     7.301     0.150
    48.328   613.969     0.150
    48.328   947.469     0.150
    48.746   524.629     0.150
    49.474   530.270     0.150
    49.498   538.570     0.150
    50.037   534.270     0.150
    50.491   537.359     0.150
    50.969   542.672     0.150
    51.225   544.172     0.150
    51.321   545.250     0.150
    51.435   544.770     0.150
    51.785   559.070     0.150
    52.271   742.172     0.150
    52.271  1139.969     0.150
    53.049   557.449     0.150
    54.180   570.570     0.150
    54.196   566.672     0.150
    54.422   576.172     0.150
    54.941   577.871     0.150
    55.494   575.469     0.150
    55.494   575.469     0.150
    55.512   584.969     0.150
    55.576   575.340     0.150
    55.576   573.371     0.150
    55.576   573.410     0.150
    56.006   578.281     0.150
    56.311   590.871     0.150
    56.796   587.172     0.150
    58.251   593.512     0.150
    58.520   594.570     0.150
    58.801   597.871     0.150
    58.801   597.609     0.150
    59.029  2377.320     0.150
    59.029   599.871     0.150
    59.088   599.469     0.150
    59.088   599.469     0.150
    59.088   599.469     0.150
    59.088  1085.871     0.150
    59.088  1085.871     0.150
    60.226   606.770     0.150
    62.433   622.371     0.150
    62.433   622.371     0.150
    62.401   621.199     0.150
    62.543   623.859     0.150
    62.570   623.000     0.150
    62.818   758.371     0.150
    63.031   626.770     0.150
    63.676   630.469     0.150
    63.676   645.172     0.150
    63.910   631.871     0.150
    65.094   874.371     0.150
    65.094  1155.969     0.150
    65.115   641.469     0.150
    65.115   639.199     0.150
    65.964   677.070     0.150
    66.184   647.605     0.150
    66.184   647.672     0.150
    66.307   648.469     0.150
    67.000   655.570     0.150
    67.000   651.859     0.150
    67.313   655.070     0.150
    67.313   655.832     0.150
    67.331   654.270     0.150
    67.474   655.742     0.150
    67.542   655.840     0.150
    67.934   658.570     0.150
    67.934  1198.570     0.150
    68.099   820.570     0.150
    68.099   900.570     0.150
    68.099  1436.570     0.150
    68.099  1672.570     0.150
    68.111   661.570     0.150
    68.111   661.570     0.150
    68.198   660.879     0.150
    68.322   659.551     0.150
    68.408   660.270     0.150
    68.408   660.250     0.150
    68.842   665.391     0.150
    68.960   664.762     0.150
    69.026   664.770     0.150
    69.037   665.410     0.150
    69.061   665.172     0.150
    69.061   664.969     0.150
    69.045   664.871     0.150
    69.059   665.359     0.150
    69.208   669.469     0.150
    69.227   918.969     0.150
    69.227  1472.969     0.150
    69.227  1665.270     0.150
    69.712    11.102     0.150
    69.712   921.871     0.150
    69.757   670.141     0.150
    69.921   669.270     0.150
    69.921   669.270     0.150
    70.189   672.129     0.150
    70.247   675.539     0.150
    70.314   673.180     0.150
    70.314   672.914     0.150
    70.455   673.789     0.150
    70.459   673.203     0.150
    70.661   674.859     0.150
    70.689   675.379     0.150
    70.784   675.570     0.150
    70.784   675.520     0.150
    70.838   677.398     0.150
    70.850   679.539     0.150
    70.965   680.539     0.150
    71.256   679.262     0.150
    72.113   684.469     0.150
    72.118   686.539     0.150
    72.126   685.570     0.150
    72.270   686.879     0.150
    72.446   688.648     0.150
    72.552   686.371     0.150
    72.684   688.070     0.150
    72.684  1253.570     0.150
    73.275   689.141     0.150
    73.409   691.570     0.150
    73.385   691.141     0.150
    73.566   690.949     0.150
    73.624   693.969     0.150
    73.964   695.469     0.150
    74.123   697.281     0.150
    74.549   709.070     0.150
    74.555   699.770     0.150
    74.713   700.172     0.150
    74.811   701.836     0.150
    74.868   702.621     0.150
    74.868   702.672     0.150
    75.190   700.672     0.150
    75.190   700.691     0.150
    75.190   873.172     0.150
    75.190   703.070     0.150
    75.247   703.172     0.150
    75.247   703.172     0.150
    75.265   702.793     0.150
    75.385   705.172     0.150
    75.412   707.969     0.150
    75.412  1280.770     0.150
    75.412   707.969     0.150
    75.412  1280.770     0.150
    75.454   707.172     0.150
    75.454   707.172     0.150
    75.478   703.223     0.150
    75.533   703.676     0.150
    75.635   708.871     0.150
    75.635  1277.469     0.150
    75.707   706.070     0.150
    75.698   704.656     0.150
    75.698   706.059     0.150
    75.754   706.270     0.150
    75.754  1285.969     0.150
    75.755   706.469     0.150
    75.755  1283.672     0.150
    75.796   703.609     0.150
    75.889   707.281     0.150
    75.983   707.969     0.150
    75.986   705.492     0.150
    76.141   706.070     0.150
    76.141   706.082     0.150
    76.157   708.371     0.150
    76.270  1586.570     0.150
    76.270   708.672     0.150
    76.270  1291.570     0.150
    76.270  1586.570     0.150
    76.270   708.613     0.150
    76.278   712.070     0.150
    76.278   864.570     0.150
    76.278  1294.570     0.150
    76.278  1608.570     0.150
    76.278  1806.570     0.150
    76.278   708.371     0.150
    76.278  1294.570     0.150
    76.278   708.453     0.150
    76.304   709.371     0.150
    76.461   711.047     0.150
    76.707   712.070     0.150
    76.707   712.070     0.150
    76.707  1291.969     0.150
    76.721   715.070     0.150
    76.721  1292.469     0.150
    76.721   715.070     0.150
    76.721  1292.469     0.150
    76.735   712.270     0.150
    76.744   711.871     0.150
    76.744  1293.270     0.150
    76.908   711.871     0.150
    77.120   713.871     0.150
    77.353   718.371     0.150
    77.353  1298.070     0.150
    77.353   714.172     0.150
    77.767   717.602     0.150
    77.807  1303.570     0.150
    77.807   717.871     0.150
    77.807   721.270     0.150
    77.807  1303.570     0.150
    77.807   716.082     0.150
    77.885   717.371     0.150
    77.911   716.070     0.150
    77.911   716.082     0.150
    77.880   718.102     0.150
    77.988   717.371     0.150
    77.988   718.371     0.150
    77.991   718.645     0.150
    77.991   718.660     0.150
    78.070   719.305     0.150
    78.077   716.621     0.150
    78.222   720.469     0.150
    78.452   719.590     0.150
    78.463   718.730     0.150
    79.240   724.875     0.150
    79.273   723.641     0.150
    79.368   726.000     0.150
    79.555   725.180     0.150
    79.998   729.422     0.150
    79.984   730.094     0.150
    80.170   730.871     0.150
    80.452   729.422     0.150
    80.866   734.770     0.150
    81.016   735.980     0.150
    81.072   734.109     0.150
    81.191   734.469     0.150
    82.361   745.871     0.150
    82.486   740.500     0.150
    82.937   745.070     0.150
    83.524   747.070     0.150
    83.828   748.520     0.150
    84.416   751.672     0.150
    84.416   751.648     0.150
    84.581   754.371     0.150
    84.733   755.570     0.150
    85.389   756.879     0.150
    85.445   758.570     0.150
    85.591   758.469     0.150
    85.950   758.648     0.150
    86.193   759.398     0.150
    86.243   759.949     0.150
    86.427  6463.070     0.150
    86.528   762.352     0.150
    86.725  1843.645     0.150
    86.725   764.570     0.150
    86.925   766.172     0.150
    87.157  6519.172     0.150
    87.205   764.695     0.150
    87.286  6527.770     0.150
    87.782   767.836     0.150
    88.078   770.539     0.150
    88.270   773.070     0.150
    88.601   771.469     0.150
    88.601   771.469     0.150
    89.122   775.715     0.150
    89.159   774.898     0.150
    89.281   774.680     0.150
    89.323   776.066     0.150
    89.669   776.371     0.150
    89.669   776.398     0.150
    89.918   777.340     0.150
    90.269   781.820     0.150
    90.633   784.430     0.150
    91.381  6835.070     0.150
    91.870   791.371     0.150
    92.288  1015.645     0.150
    92.726   795.270     0.150
   120.525  1131.270     0.150
   122.141  1134.469     0.150
   122.707  1130.859     0.150
   124.531  1138.469     0.150
   142.401  1166.371     0.150
   143.593  1176.070     0.150
   146.043  1178.371     0.150
   147.188 11103.383     0.150
   147.202 11099.336     0.150
   147.204 11104.680     0.150
   151.930  1198.281     0.150
   151.930  1192.898     0.150
   156.123  1196.770     0.150
   157.663  1231.746     0.150
   157.663  1196.500     0.150
     0.313    17.191     0.150
     0.915    27.990     0.150
     1.827    44.191     0.150
     1.826    44.191     0.150
     2.573    40.291     0.150
     2.650    42.191     0.150
     2.650    72.490     0.150
     4.516    68.591     0.150
     5.430    74.391     0.150
     6.901   175.191     0.150
     8.318   213.016     0.150
     9.611   247.990     0.150
    10.080   138.651     0.150
    10.502   148.191     0.150
    12.722   174.891     0.150
    25.874   325.490     0.150
    28.659   351.391     0.150
    30.231   365.791     0.150
    30.231   365.791     0.150
    30.198  2253.493     0.150
    30.209  2263.320     0.150
    30.216  2257.769     0.150
    30.842    11.400     0.150
    30.842    15.600     0.150
    31.076  2323.065     0.150
    31.079  2325.835     0.150
    31.093  2326.461     0.150
    32.599    10.500     0.150
    32.599    14.500     0.150
    37.293     6.700     0.150
    39.501   444.211     0.150
    39.848    14.000     0.150
    42.609   470.031     0.150
    42.811   471.151     0.150
    43.862   479.990     0.150
    43.862   479.901     0.150
    44.381   485.301     0.150
    44.381   485.301     0.150
    48.152   513.490     0.150
    48.640   518.990     0.150
    51.732   540.391     0.150
    51.732   540.191     0.150
    53.340   552.191     0.150
    60.016   597.891     0.150
    64.666   629.490     0.150
    68.453   656.791     0.150
    68.474   656.490     0.150
    75.368   697.151     0.150
    76.658   704.691     0.150
    76.698   704.791     0.150
    77.148   706.591     0.150
    77.640   709.591     0.150
   145.953 10957.590     0.150
   145.967 10959.366     0.150
   145.969 10959.962     0.150
     0.339     9.398     0.150
     0.960    16.297     0.150
     0.961    16.711     0.150
     0.961    30.547     0.150
     1.086    17.102     0.150
     1.245    35.102     0.150
     1.312    20.797     0.150
     1.374    21.797     0.150
     1.374    38.195     0.150
     1.479    24.000     0.150
     1.800    28.398     0.150
     1.800    49.797     0.150
     1.849    55.750     0.150
     1.874    30.195     0.150
     1.874    52.898     0.150
     3.735    57.195     0.150
     4.418    65.000     0.150
     4.418   114.398     0.150
     7.620   191.000     0.150
    10.843   153.695     0.150
    12.834   177.500     0.150
    16.326   221.102     0.150
    24.290   557.695     0.150
    26.443   331.398     0.150
    26.887   335.898     0.150
    29.838  2239.172     0.150
    29.849  2245.586     0.150
    29.856  2242.508     0.150
    30.738  2308.180     0.150
    30.742  2308.625     0.150
    30.756  2311.555     0.150
    31.604     9.500     0.150
    31.604    19.797     0.150
    38.119    11.500     0.150
    43.143   473.898     0.150
    43.143   473.859     0.150
    43.144   474.602     0.150
    43.344   475.891     0.150
    44.321   483.797     0.150
    48.460   516.555     0.150
    53.639   555.195     0.150
    53.639  1226.898     0.150
    57.476   582.766     0.150
    64.880   632.195     0.150
    68.727   657.016     0.150
    68.833   659.695     0.150
    69.313   662.797     0.150
    77.245   707.602     0.150
    77.760   710.797     0.150
    78.823   718.000     0.150
   145.177 10908.016     0.150
   145.191 10889.867     0.150
   145.193 10897.352     0.150
     0.380     9.094     0.150
     0.380    16.195     0.150
     0.511    10.797     0.150
     0.531    11.391     0.150
     0.531    19.594     0.150
     0.850    15.375     0.150
     0.850    28.211     0.150
     0.855    16.594     0.150
     0.945    17.695     0.150
     1.085    20.094     0.150
     2.279    36.695     0.150
     2.279    64.195     0.150
     2.285    38.492     0.150
     2.306    35.594     0.150
     2.306    35.594     0.150
     2.306    61.797     0.150
     2.554    72.391     0.150
     2.554    40.891     0.150
     2.554    72.391     0.150
     2.630    42.695     0.150
     4.165    63.391     0.150
     4.165   109.992     0.150
     4.933    69.891     0.150
     6.305    93.992     0.150
     7.128   103.477     0.150
     7.128   187.492     0.150
     7.903   112.961     0.150
     8.078   205.695     0.150
     9.061   132.797     0.150
     9.061   238.492     0.150
    12.123   174.594     0.150
    12.519   177.188     0.150
    14.385   203.594     0.150
    14.983   206.797     0.150
    15.662   378.922     0.150
    17.162   238.227     0.150
    20.053   268.391     0.150
    20.764    15.102     0.150
    20.764   505.992     0.150
    23.454   304.594     0.150
    24.441   313.781     0.150
    25.407   326.695     0.150
    27.670   346.094     0.150
    27.670   346.094     0.150
    27.710   343.391     0.150
    27.710   343.375     0.150
    28.670   351.961     0.150
    29.319   359.891     0.150
    29.726   365.094     0.150
    29.726   365.094     0.150
    30.531    10.906     0.150
    30.531    16.203     0.150
    30.731  2272.156     0.150
    30.742  2276.805     0.150
    30.749  2273.625     0.150
    31.613  2340.297     0.150
    31.617  2343.023     0.150
    31.630  2343.320     0.150
    32.226    12.898     0.150
    32.226    17.203     0.150
    33.520   393.594     0.150
    36.440   765.797     0.150
    37.118   426.195     0.150
    37.118   426.172     0.150
    39.397    13.406     0.150
    39.397    19.406     0.150
    39.397   447.297     0.150
    39.397   447.273     0.150
    40.222   452.891     0.150
    42.127   468.867     0.150
    42.127   467.703     0.150
    42.283   469.281     0.150
    42.328   470.352     0.150
    42.940   475.891     0.150
    42.940   475.891     0.150
    43.352   478.695     0.150
    43.381   478.266     0.150
    43.432   478.445     0.150
    43.446   478.891     0.150
    43.883   482.992     0.150
    44.705   488.875     0.150
    44.963   493.344     0.150
    44.963   493.297     0.150
    45.278   494.797     0.150
    45.553   496.492     0.150
    45.659   497.938     0.150
    45.659   497.891     0.150
    46.003   500.891     0.150
    46.003   500.797     0.150
    46.634   505.945     0.150
    46.634   505.891     0.150
    46.877   507.797     0.150
    46.995   509.594     0.150
    47.066   508.617     0.150
    47.066   508.594     0.150
    47.203   510.336     0.150
    47.203   510.297     0.150
    47.265   511.594     0.150
    47.265   511.594     0.150
    47.625   513.297     0.150
    47.701   514.492     0.150
    47.796   514.992     0.150
    48.325   518.594     0.150
    48.527   520.195     0.150
    48.653   520.297     0.150
    48.805   523.086     0.150
    48.805   524.391     0.150
    49.811   530.297     0.150
    51.251   539.773     0.150
    51.251   539.281     0.150
    51.583   543.695     0.150
    51.995   546.797     0.150
    52.796   552.094     0.150
    52.796  1001.297     0.150
    52.796   551.922     0.150
    53.911   560.438     0.150
    56.415   577.555     0.150
    56.797   578.953     0.150
    57.299   583.664     0.150
    62.003   617.516     0.150
    62.647   621.703     0.150
    64.114   629.297     0.150
    64.114   670.195     0.150
    64.935   635.992     0.150
    66.615   648.641     0.150
    67.375   651.992     0.150
    67.923   655.594     0.150
    67.923   655.641     0.150
    67.944   656.195     0.150
    67.968   655.820     0.150
    68.115   656.320     0.150
    68.102   656.594     0.150
    68.120   656.672     0.150
    68.186   656.836     0.150
    68.209   657.141     0.150
    69.050   662.570     0.150
    69.407   664.070     0.150
    69.811   667.070     0.150
    69.989   668.352     0.150
    70.367   669.297     0.150
    70.367   669.312     0.150
    70.367   669.641     0.150
    70.558   671.938     0.150
    72.910   685.961     0.150
    74.035   691.977     0.150
    74.415   694.594     0.150
    74.814   695.797     0.150
    74.814   695.742     0.150
    74.930   696.820     0.150
    74.986   698.094     0.150
    75.635   697.281     0.150
    75.635   697.297     0.150
    75.783   702.203     0.150
    75.783   701.672     0.150
    75.986   704.797     0.150
    76.023   704.891     0.150
    76.076   706.797     0.150
    76.076   718.492     0.150
    76.076   704.297     0.150
    76.100   700.547     0.150
    76.100   700.594     0.150
    76.108   705.594     0.150
    76.108   705.594     0.150
    76.144   703.492     0.150
    76.144    16.602     0.150
    76.144   703.492     0.150
    76.548   707.594     0.150
    76.595   708.797     0.150
    76.595    22.406     0.150
    76.595   706.211     0.150
    76.599   708.227     0.150
    76.599   724.211     0.150
    76.745   709.797     0.150
    76.826   709.195     0.150
    77.086   709.695     0.150
    77.101   723.797     0.150
    77.186   710.766     0.150
    77.555   709.359     0.150
    77.555   709.391     0.150
    77.642   714.500     0.150
    77.658   714.719     0.150
    78.150   714.406     0.150
    78.334   718.750     0.150
    78.334   717.570     0.150
    78.334   717.594     0.150
    78.334   715.117     0.150
    78.572   717.391     0.150
    78.572   719.500     0.150
    79.477   723.203     0.150
    80.389   728.711     0.150
    85.797   755.273     0.150
    85.797   755.227     0.150
    85.870   756.336     0.150
   146.244 10978.836     0.150
   146.258 10987.805     0.150
   146.260 10976.914     0.150
   151.432  1190.594     0.150
     2.430    36.135     0.150
     2.430    63.035     0.150
     2.444    67.035     0.150
     2.731    74.035     0.150
    30.579  2268.594     0.150
    30.590  2268.334     0.150
    30.597  2270.090     0.150
    31.454  2336.137     0.150
    31.458  2334.936     0.150
    31.471  2333.812     0.150
    44.425   486.035     0.150
    64.430   631.086     0.150
     0.371     9.400     0.150
     1.150    20.180     0.150
     1.150    36.550     0.150
     1.160    21.210     0.150
     2.954    46.910     0.150
     2.954    46.910     0.150
     2.954    81.310     0.150
     2.985    44.510     0.150
     3.223    51.110     0.150
     3.223    89.910     0.150
     3.299    53.010     0.150
     3.299    53.310     0.150
     3.299    91.610     0.150
     4.427    70.610     0.150
     4.427   122.310     0.150
     4.427    70.610     0.150
     4.427   122.310     0.150
     4.496    73.710     0.150
     4.496    73.710     0.150
     5.120    79.810     0.150
     5.120    80.410     0.150
     6.637    99.440     0.150
     7.306   103.810     0.150
     7.333   107.910     0.150
     7.333   109.535     0.150
     7.333   110.510     0.150
     7.333   110.540     0.150
     7.777   115.870     0.150
     9.658   133.810     0.150
    10.157   149.580     0.150
    11.005   160.810     0.150
    11.840   172.410     0.150
    12.055   175.210     0.150
    14.765   216.710     0.150
    14.827   211.510     0.150
    14.958   210.720     0.150
    20.778   289.610     0.150
    24.903   320.510     0.150
    25.346   324.530     0.150
    27.042   352.110     0.150
    27.042     8.699     0.150
    27.239   341.410     0.150
    31.090  2376.155     0.150
    31.100  2377.435     0.150
    31.108  2378.303     0.150
    31.955  2439.506     0.150
    31.958  2439.506     0.150
    31.972  2439.470     0.150
    38.591   580.935     0.150
    38.868   442.860     0.150
    41.647   465.640     0.150
    41.647   591.335     0.150
    42.893   475.220     0.150
    42.930   475.410     0.150
    44.905   492.680     0.150
    47.253   510.410     0.150
    47.253   510.410     0.150
    48.303   517.910     0.150
    49.361   526.540     0.150
    50.767   536.930     0.150
    51.285   549.710     0.150
    52.498   559.410     0.150
    52.498  1014.410     0.150
    53.712   560.940     0.150
    57.172   582.570     0.150
    59.278   605.010     0.150
    59.278   605.010     0.150
    62.586   620.570     0.150
    63.882   637.610     0.150
    64.080   630.350     0.150
    64.291   638.110     0.150
    64.344   633.220     0.150
    65.148   637.890     0.150
    65.999   644.180     0.150
    66.313   644.010     0.150
    66.313   644.710     0.150
    66.784   648.970     0.150
    67.560   655.910     0.150
    68.001   655.890     0.150
    70.130   669.140     0.150
    70.130   667.970     0.150
    70.465   672.400     0.150
    70.599   672.680     0.150
    71.206   676.670     0.150
    73.680   691.370     0.150
    74.625   695.720     0.150
    74.732   695.820     0.150
    75.040   700.170     0.150
    75.525   701.550     0.150
    75.576   702.430     0.150
    75.940   704.010     0.150
    76.454   705.710     0.150
    76.927   709.610     0.150
    77.990   715.410     0.150
    78.036   712.364     0.150
    78.172   714.979     0.150
    78.431   727.488     0.150
    79.983   727.981     0.150
    80.230   725.714     0.150
    80.467   727.924     0.150
    80.817   728.217     0.150
    86.147  6461.610     0.150
    86.882  6517.210     0.150
    88.083  6606.910     0.150
   146.107  1176.050     0.150
     0.372     9.227     0.150
     0.372    16.086     0.150
     0.440     9.508     0.150
     0.960    17.906     0.150
    15.347   216.309     0.150
    21.299     8.348     0.150
    25.354     9.398     0.150
    31.087  2339.750     0.150
    31.097  2334.082     0.150
    31.104  2334.840     0.150
    31.952  2401.988     0.150
    31.955  2406.023     0.150
    31.969  2402.711     0.150
    49.344   523.383     0.150
    59.210   600.180     0.150
   146.884 10990.781     0.150
   146.897 10993.688     0.150
   146.900 10992.918     0.150
     0.328    10.797     0.150
     1.240    21.789     0.150
     1.824    29.898     0.150
     2.353    64.492     0.150
     4.595    68.195     0.150
     6.837    97.883     0.150
     6.837    98.492     0.150
    10.446   149.195     0.150
    10.446   149.195     0.150
    12.562   176.594     0.150
    28.106   345.492     0.150
    28.106   345.492     0.150
    30.259  2256.773     0.150
    30.270  2260.602     0.150
    30.277  2258.117     0.150
    31.135  2320.406     0.150
    31.138  2324.492     0.150
    31.152  2324.047     0.150
    42.533   469.297     0.150
    42.533   469.297     0.150
    42.735   470.914     0.150
    44.566   482.492     0.150
    44.566   482.445     0.150
    65.412   636.086     0.150
    66.176   642.773     0.150
   146.046 10968.273     0.150
   146.060 10967.180     0.150
   146.062 10973.000     0.150
     0.934    28.621     0.150
    30.215  2256.453     0.150
    30.225  2256.719     0.150
    30.233  2259.203     0.150
    31.090  2321.969     0.150
    31.094  2322.301     0.150
    31.107  2322.559     0.150
    44.126   490.422     0.150
     0.539    21.516     0.150
     1.257    37.812     0.150
     1.289    36.312     0.150
     1.763    28.711     0.150
     2.530    37.414     0.150
     2.564    39.211     0.150
     2.564    70.617     0.150
     2.855    43.211     0.150
     2.855    77.617     0.150
     4.603    68.914     0.150
     4.603   121.516     0.150
     4.791    71.312     0.150
     5.095   136.414     0.150
     5.095    73.812     0.150
     5.095   128.617     0.150
     6.714    97.383     0.150
     7.945   113.883     0.150
     9.423   240.812     0.150
     9.423   134.312     0.150
     9.478   230.266     0.150
     9.707   156.914     0.150
    10.215   143.812     0.150
    12.300   173.414     0.150
    12.300   173.156     0.150
    14.775   205.336     0.150
    14.775   203.883     0.150
    15.166   377.414     0.150
    15.224   366.164     0.150
    16.267    22.297     0.150
    17.976   244.070     0.150
    21.158   279.211     0.150
    23.740   304.812     0.150
    25.516   322.875     0.150
    25.516   322.914     0.150
    25.959   326.664     0.150
    27.841   347.211     0.150
    27.841   345.273     0.150
    28.009   346.617     0.150
    29.370   361.141     0.150
    30.146   365.070     0.150
    30.146   365.117     0.150
    30.460    14.602     0.150
    30.460    22.203     0.150
    30.506  2272.156     0.150
    30.517  2265.609     0.150
    30.524  2266.328     0.150
    32.218    15.203     0.150
    32.218    21.898     0.150
    32.218   549.812     0.150
    33.318    17.602     0.150
    36.930   425.312     0.150
    36.930    14.102     0.150
    36.930    20.203     0.150
    38.398   435.812     0.150
    38.568   438.875     0.150
    39.482    12.797     0.150
    39.482    19.898     0.150
    40.387   451.617     0.150
    40.613   454.945     0.150
    42.459   468.656     0.150
    43.531   477.961     0.150
    43.531   478.016     0.150
    43.668   479.758     0.150
    43.746   475.961     0.150
    43.841   479.531     0.150
    44.159   483.133     0.150
    44.587   484.812     0.150
    44.718   487.164     0.150
    44.970   489.875     0.150
    45.063   489.117     0.150
    45.400   492.016     0.150
    45.415   493.836     0.150
    45.766   494.617     0.150
    46.106   497.117     0.150
    46.749   502.312     0.150
    46.986   504.117     0.150
    47.012   504.812     0.150
    47.012   504.812     0.150
    47.103   505.312     0.150
    47.183   505.312     0.150
    47.386   507.312     0.150
    47.839   511.117     0.150
    48.264   513.812     0.150
    48.917   519.953     0.150
    48.917   519.117     0.150
    49.227    15.797     0.150
    51.379   537.781     0.150
    52.116   543.516     0.150
    53.057   999.211     0.150
    53.057   549.922     0.150
    53.950   558.133     0.150
    56.477   575.023     0.150
    57.372   582.711     0.150
    58.549   586.516     0.150
    59.783   596.211     0.150
    60.560   602.414     0.150
    60.560   602.414     0.150
    62.132   614.688     0.150
    62.216   614.805     0.150
    62.445   616.414     0.150
    63.553   642.516     0.150
    63.553   623.414     0.150
    64.057   627.211     0.150
    64.412   627.516     0.150
    65.373   635.914     0.150
    65.373   635.977     0.150
    65.745   638.938     0.150
    66.172   639.508     0.150
    68.143   655.070     0.150
    68.143   653.711     0.150
    68.163   652.914     0.150
    68.163   666.211     0.150
    68.445   651.812     0.150
    68.641   656.477     0.150
    68.641   656.477     0.150
    68.641   908.523     0.150
    68.641  1466.477     0.150
    68.641  1654.992     0.150
    68.779   657.523     0.150
    68.799   657.164     0.150
    68.799   657.164     0.150
    68.799   811.633     0.150
    68.799   915.664     0.150
    68.799  1447.297     0.150
    68.799  1652.305     0.150
    69.640   661.617     0.150
    69.859   662.312     0.150
    70.674   666.414     0.150
    70.757   668.586     0.150
    72.867   681.312     0.150
    74.708   693.211     0.150
    75.054   711.211     0.150
    75.054   694.516     0.150
    75.054   711.211     0.150
    75.075   694.312     0.150
    75.267   696.414     0.150
    75.316   695.711     0.150
    75.316   695.711     0.150
    75.395   697.414     0.150
    75.535   698.914     0.150
    75.917   699.414     0.150
    76.315   701.312     0.150
    76.399   702.414     0.150
    76.436   720.016     0.150
    76.436   702.914     0.150
    76.471   719.711     0.150
    76.471   703.016     0.150
    76.864   715.617     0.150
    76.935   705.414     0.150
    76.935    18.000     0.150
    77.151   706.023     0.150
    77.419   708.211     0.150
    77.425   709.211     0.150
    77.486   708.516     0.150
    77.608   724.016     0.150
    77.851   711.312     0.150
    78.482   731.312     0.150
    78.482   714.312     0.150
    78.541   714.617     0.150
    78.914   717.812     0.150
    79.390   719.812     0.150
    79.480   720.383     0.150
    80.214   724.555     0.150
    80.630   724.844     0.150
    81.022   731.117     0.150
    81.100   727.820     0.150
    83.563   741.312     0.150
    84.729   748.312     0.150
    84.891   749.211     0.150
    84.946   748.469     0.150
    85.953   753.930     0.150
    86.019   752.516     0.150
    86.065   756.016     0.150
    86.183   754.656     0.150
    86.271  6439.312     0.150
    86.643   758.117     0.150
    87.472  6522.711     0.150
    89.508   769.617     0.150
    90.508  6745.016     0.150
   114.113  1167.367     0.150
   146.335 10970.258     0.150
   146.349 10975.578     0.150
   146.351 10971.992     0.150
   150.073  1184.656     0.150
     0.299    10.549     0.150
     0.299    18.438     0.150
     1.316    23.158     0.150
     1.840    29.848     0.150
     1.841    47.198     0.150
     2.218    33.148     0.150
     2.218    58.448     0.150
     2.290    36.049     0.150
     2.290    63.549     0.150
     2.592    40.648     0.150
     2.592    70.148     0.150
     2.668    72.049     0.150
     4.651   122.549     0.150
     5.641    82.178     0.150
     6.807    98.848     0.150
     6.882    98.569     0.150
     7.071   176.749     0.150
     7.664   108.148     0.150
     8.327   119.049     0.150
     8.562   222.448     0.150
     8.562   123.648     0.150
     8.562   216.448     0.150
     9.537   231.073     0.150
     9.621   249.549     0.150
     9.621   138.749     0.150
    10.075   149.549     0.150
    10.075   265.348     0.150
    10.506   148.749     0.150
    12.268   164.448     0.150
    12.268   300.448     0.150
    12.640   324.348     0.150
    12.640   176.418     0.150
    12.985   319.948     0.150
    15.195   363.398     0.150
    15.543   392.249     0.150
    17.659   239.969     0.150
    17.933   240.242     0.150
    17.933   243.368     0.150
    21.309   952.249     0.150
    21.781    11.000     0.150
    21.781    18.500     0.150
    25.872   325.828     0.150
    25.872   325.749     0.150
    27.948    14.200     0.150
    27.948    20.900     0.150
    28.177   631.249     0.150
    28.177   346.769     0.150
    28.177   346.848     0.150
    28.677   400.148     0.150
    28.677   631.549     0.150
    28.677   349.648     0.150
    29.825   361.148     0.150
    30.195  2252.965     0.150
    30.206  2264.784     0.150
    30.213  2255.322     0.150
    30.833    13.000     0.150
    30.833    22.900     0.150
    31.072  2319.184     0.150
    31.076  2320.052     0.150
    31.089  2327.111     0.150
    32.592    14.600     0.150
    32.592    22.100     0.150
    33.279    13.400     0.150
    33.279    21.000     0.150
    36.478   419.059     0.150
    37.279   761.948     0.150
    37.279   918.848     0.150
    39.844    20.500     0.150
    42.169   467.209     0.150
    42.608   469.948     0.150
    42.809   471.608     0.150
    43.476   477.099     0.150
    43.589   478.098     0.150
    43.980   480.918     0.150
    44.007   482.289     0.150
    44.245   587.848     0.150
    44.245   483.868     0.150
    44.245   587.819     0.150
    44.405   483.917     0.150
    44.909   488.774     0.150
    44.953   488.438     0.150
    45.222   491.858     0.150
    45.422   492.549     0.150
    45.753   495.648     0.150
    46.013   497.049     0.150
    46.123   498.249     0.150
    46.464   501.049     0.150
    47.104   505.549     0.150
    47.343   508.049     0.150
    47.369   507.848     0.150
    47.369   507.848     0.150
    47.460   509.549     0.150
    47.537   508.549     0.150
    47.717   510.249     0.150
    48.155   514.009     0.150
    48.155   513.948     0.150
    48.851   519.249     0.150
    49.137   520.708     0.150
    49.273   522.549     0.150
    51.279   537.648     0.150
    51.658   540.509     0.150
    51.730   540.408     0.150
    52.133   543.948     0.150
    52.469   546.148     0.150
    53.345  1213.749     0.150
    53.345   552.448     0.150
    54.320   560.479     0.150
    55.692   568.989     0.150
    55.692   569.178     0.150
    55.875   569.448     0.150
    55.875   569.509     0.150
    56.844   576.989     0.150
    58.437   584.348     0.150
    58.988   592.269     0.150
    60.024   597.348     0.150
    60.634   603.049     0.150
    60.634   603.049     0.150
    62.610   616.049     0.150
    62.610   616.138     0.150
    64.673   630.049     0.150
    64.815   632.259     0.150
    65.413   636.348     0.150
    65.413   636.388     0.150
    66.266   644.448     0.150
    66.266  1171.448     0.150
    66.997   646.049     0.150
    66.997   646.128     0.150
    67.011    13.900     0.150
    67.127    25.000     0.150
    67.491   645.678     0.150
    67.575  1189.049     0.150
    68.456   656.306     0.150
    68.456   656.049     0.150
    68.477   656.148     0.150
    68.605   656.188     0.150
    68.731   656.428     0.150
    68.888   656.708     0.150
    68.888   656.708     0.150
    68.888   909.239     0.150
    68.888  1224.588     0.150
    68.888  1660.448     0.150
    69.042   658.408     0.150
    69.042   658.408     0.150
    69.042   687.569     0.150
    69.042   799.259     0.150
    69.042   917.059     0.150
    69.042  1489.229     0.150
    69.042  1685.059     0.150
    69.824   662.848     0.150
    69.824   662.948     0.150
    69.829   664.688     0.150
    70.111   665.948     0.150
    70.359   930.948     0.150
    70.524   667.319     0.150
    70.524   666.819     0.150
    71.427   673.239     0.150
    71.427   673.208     0.150
    72.017   677.438     0.150
    72.559   681.489     0.150
    73.408   684.648     0.150
    73.408   684.729     0.150
    73.706   687.638     0.150
    73.723   686.549     0.150
    73.795   687.648     0.150
    73.795   687.658     0.150
    74.154   689.148     0.150
    74.154   689.208     0.150
    74.205   689.448     0.150
    74.205   689.469     0.150
    74.928   693.229     0.150
    75.078   695.519     0.150
    75.102   696.039     0.150
    75.102   696.103     0.150
    75.308   696.249     0.150
    75.376   696.918     0.150
    75.527   705.648     0.150
    75.527   719.648     0.150
    75.682   698.848     0.150
    75.736   698.800     0.150
    75.822   699.138     0.150
    76.321   701.441     0.150
    76.321   702.608     0.150
    76.337   703.249     0.150
    76.638   704.249     0.150
    76.638   704.249     0.150
    76.638   704.229     0.150
    76.666   704.749     0.150
    76.670   704.648     0.150
    76.707   704.848     0.150
    77.108   707.039     0.150
    77.110   707.249     0.150
    77.157  1351.948     0.150
    77.157  1669.948     0.150
    77.157   706.648     0.150
    77.157    22.200     0.150
    77.157   706.645     0.150
    77.204   707.549     0.150
    77.388   708.749     0.150
    77.614   709.848     0.150
    77.624   709.948     0.150
    77.649   709.848     0.150
    77.678   710.948     0.150
    77.850   711.848     0.150
    78.062   712.948     0.150
    78.238   713.249     0.150
    78.606   714.279     0.150
    78.712   715.848     0.150
    78.712   725.648     0.150
    79.136   717.578     0.150
    79.280   718.549     0.150
    79.505   720.809     0.150
    79.505   720.854     0.150
    79.841   722.049     0.150
    79.841   722.019     0.150
    80.250   725.231     0.150
    80.499   725.469     0.150
    81.128   728.049     0.150
    81.212   728.749     0.150
    81.317   729.168     0.150
    81.317   729.261     0.150
    81.657   731.069     0.150
    81.880   732.549     0.150
    81.931   732.368     0.150
    82.217   734.289     0.150
    84.313   745.658     0.150
    84.705   747.569     0.150
    84.705   747.519     0.150
    85.921   753.948     0.150
    85.922  6424.349     0.150
    85.977   753.229     0.150
    86.263  6455.349     0.150
    86.423   755.848     0.150
    87.594   761.799     0.150
    87.594   761.793     0.150
    88.116   764.279     0.150
    89.140   768.809     0.150
    89.140   768.864     0.150
    89.991   773.358     0.150
    90.169  6740.349     0.150
    92.642   784.049     0.150
    93.092   786.638     0.150
   118.484  1121.029     0.150
   120.119  1121.948     0.150
   120.119  1121.969     0.150
   120.452  1127.888     0.150
   123.165  1129.698     0.150
   133.711  1152.938     0.150
   145.964 10956.864     0.150
   145.977 10959.775     0.150
   145.980 10955.190     0.150
   146.157  1171.719     0.150
   146.901  1175.608     0.150
   149.725  1183.948     0.150
   151.763  1188.618     0.150
   152.107  1184.519     0.150
   156.892  1186.348     0.150
     1.820    48.711     0.150
     2.214    60.711     0.150
     4.157   106.711     0.150
     4.527   118.812     0.150
    21.147   278.414     0.150
    28.415   347.508     0.150
    30.020  2256.766     0.150
    30.031  2258.672     0.150
    30.038  2258.828     0.150
    30.908  2319.688     0.150
    30.912  2325.430     0.150
    30.925  2325.570     0.150
    38.812   436.812     0.150
    42.863   470.914     0.150
    44.059   482.109     0.150
    44.082   481.508     0.150
    53.488   552.109     0.150
    64.804   632.414     0.150
    68.638   655.609     0.150
    70.471   666.531     0.150
    71.030   669.711     0.150
   142.931  1147.812     0.150
   145.591 10946.734     0.150
   145.605 10954.766     0.150
   145.607 10954.844     0.150
     0.366    10.328     0.150
     0.608    22.727     0.150
     0.851    30.672     0.150
     0.989    16.922     0.150
     1.213    35.328     0.150
     1.248    35.125     0.150
     1.910    30.125     0.150
     1.922    28.875     0.150
     6.655   109.625     0.150
     7.492   106.523     0.150
     7.511   106.617     0.150
     8.353   211.227     0.150
     8.922   127.055     0.150
     8.922   130.406     0.150
    10.839   155.625     0.150
    13.954   193.836     0.150
    21.283   285.023     0.150
    21.283   285.023     0.150
    26.405   332.828     0.150
    26.405   332.828     0.150
    29.841  2251.906     0.150
    29.852  2243.125     0.150
    29.859  2244.656     0.150
    30.738  2311.719     0.150
    30.742  2314.211     0.150
    30.755  2320.047     0.150
    41.721   462.703     0.150
    42.652   471.812     0.150
    43.112   474.586     0.150
    43.112   475.047     0.150
    43.312   476.031     0.150
    43.782   480.922     0.150
    44.302   484.727     0.150
    44.757   486.867     0.150
    44.995   487.125     0.150
    45.118   491.547     0.150
    46.219   497.125     0.150
    46.515   500.195     0.150
    48.566   518.375     0.150
    48.566   518.422     0.150
    52.238   545.727     0.150
    52.238   545.672     0.150
    52.238   545.406     0.150
    56.013   571.031     0.150
    56.742   577.023     0.150
    56.742   576.992     0.150
    65.147   634.898     0.150
    68.835   657.383     0.150
    69.423   662.852     0.150
    69.655   661.484     0.150
    69.856   664.125     0.150
    71.153   673.023     0.150
    73.803   685.727     0.150
    75.204   694.578     0.150
    79.040   718.750     0.150
     0.288    10.324     0.150
     1.853    30.125     0.150
     1.854    59.582     0.150
     2.270    32.535     0.150
     2.270    56.934     0.150
     2.270    32.535     0.150
     2.270    57.934     0.150
     2.648    37.934     0.150
     2.648    66.234     0.150
     2.648    38.434     0.150
     2.648    68.234     0.150
     3.136    46.234     0.150
     3.136    81.234     0.150
    30.167  2257.184     0.150
    30.178  2263.082     0.150
    30.185  2259.141     0.150
    31.044  2324.496     0.150
    31.048  2319.922     0.150
    31.062  2324.824     0.150
    42.639   470.492     0.150
    42.639   470.035     0.150
    42.639   470.074     0.150
    48.133   513.934     0.150
    65.419   636.043     0.150
     0.256    10.250     0.150
     0.256    17.344     0.150
     1.885    60.242     0.150
     2.250    59.641     0.150
     2.327    36.445     0.150
     2.327    63.242     0.150
     2.706    42.242     0.150
     2.706    72.742     0.150
     3.192    46.141     0.150
     4.696    67.047     0.150
    26.326   330.766     0.150
    30.172  2257.055     0.150
    30.183  2257.984     0.150
    30.190  2258.391     0.150
    31.048  2325.859     0.150
    31.052  2322.180     0.150
    31.066  2323.305     0.150
    39.523   444.164     0.150
    42.620   469.984     0.150
    42.620   469.742     0.150
    42.620   469.750     0.150
    43.881   480.547     0.150
    49.182   521.031     0.150
    53.372   552.945     0.150
    58.678   590.844     0.150
     1.244    36.676     0.150
     2.382    37.613     0.150
     2.382    66.113     0.150
     2.479    40.816     0.150
     3.256    48.613     0.150
     3.256    85.016     0.150
     4.677    70.113     0.150
     4.677   121.113     0.150
     7.965   110.504     0.150
     8.590   217.715     0.150
    12.353   312.914     0.150
    25.799   324.914     0.150
    26.243   329.246     0.150
    27.851     7.402     0.150
    28.286   341.016     0.150
    28.735   355.113     0.150
    30.247  2250.996     0.150
    30.258  2256.285     0.150
    30.265  2256.727     0.150
    31.122  2321.469     0.150
    31.125  2325.543     0.150
    31.139  2326.426     0.150
    32.504     3.699     0.150
    32.504     6.301     0.150
    37.373     5.402     0.150
    37.373    12.500     0.150
    37.373   543.613     0.150
    41.958   466.953     0.150
    42.296   469.324     0.150
    42.538   469.074     0.150
    42.740   470.426     0.150
    43.802   479.516     0.150
    43.908   481.043     0.150
    45.162   492.355     0.150
    45.203   492.203     0.150
    48.003   512.914     0.150
    48.101   513.816     0.150
    48.284   515.594     0.150
    51.660   540.293     0.150
    54.611   562.234     0.150
    55.899   568.746     0.150
    64.748   630.535     0.150
    65.444   635.035     0.150
    65.444   636.414     0.150
    66.143   639.113     0.150
    66.143   639.105     0.150
    68.403   653.516     0.150
    68.424   655.816     0.150
    74.938   694.125     0.150
    75.164   696.754     0.150
    76.270   701.836     0.150
    79.766   721.316     0.150
   146.058 10969.387     0.150
   146.072 10971.387     0.150
   146.074 10971.824     0.150
     0.298    10.422     0.150
     0.298    17.512     0.150
     2.325    61.570     0.150
     2.770    42.672     0.150
     4.636    65.871     0.150
     4.687    70.031     0.150
     4.687    69.973     0.150
     4.687   121.172     0.150
     6.792    97.660     0.150
    12.533   177.871     0.150
    26.242   328.910     0.150
    30.244  2262.367     0.150
    30.255  2264.129     0.150
    30.262  2260.910     0.150
    31.118  2327.879     0.150
    31.122  2322.324     0.150
    31.136  2326.312     0.150
    39.449   444.391     0.150
    42.538   469.449     0.150
    42.740   471.180     0.150
    43.803   478.891     0.150
    43.803   478.871     0.150
    44.490   484.871     0.150
    46.958   506.633     0.150
    47.585   509.480     0.150
    48.283   515.621     0.150
    51.660   539.660     0.150
    62.404   616.812     0.150
   146.064 10963.059     0.150
   146.078 10966.254     0.150
   146.080 10972.926     0.150
     2.109    56.383     0.150
     4.422    68.883     0.150
     4.422   118.983     0.150
    30.186  2255.128     0.150
    30.196  2261.047     0.150
    30.203  2253.745     0.150
    31.066  2330.319     0.150
    31.070  2327.380     0.150
    31.083  2328.890     0.150
    43.886   478.483     0.150
    43.886   478.483     0.150
    44.288   483.483     0.150
    48.456   515.783     0.150
     0.316    10.953     0.150
     0.316    18.852     0.150
     3.243    48.551     0.150
     6.821    98.453     0.150
     9.498   230.676     0.150
     9.995   139.312     0.150
    10.593   146.660     0.150
    12.552   173.301     0.150
    12.552   173.352     0.150
    12.552   175.250     0.150
    14.647   202.652     0.150
    14.647   199.027     0.150
    14.647   202.750     0.150
    15.177   364.051     0.150
    30.253  2258.078     0.150
    30.264  2256.734     0.150
    30.271  2257.531     0.150
    31.128  2320.586     0.150
    31.132  2322.094     0.150
    31.146  2323.016     0.150
    32.507    23.500     0.150
    39.441   442.852     0.150
    40.483   452.652     0.150
    42.479   467.852     0.150
    42.536   468.953     0.150
    42.536   467.473     0.150
    42.536   467.453     0.150
    42.536   467.453     0.150
    42.737   470.852     0.150
    43.146   473.172     0.150
    43.146   473.152     0.150
    43.146   473.152     0.150
    43.798   479.250     0.150
    43.798   479.250     0.150
    51.657   538.953     0.150
    51.657   539.352     0.150
    53.294    16.801     0.150
     0.193    14.953     0.150
     2.291    35.008     0.150
     2.291    61.008     0.150
     3.233    48.109     0.150
     3.233    83.406     0.150
     4.611   118.711     0.150
    30.197  2254.531     0.150
    30.208  2257.570     0.150
    30.215  2256.547     0.150
    31.072  2320.992     0.150
    31.076  2321.695     0.150
    31.089  2321.961     0.150
    70.939   668.750     0.150
   146.017 10968.992     0.150
   146.030 10965.141     0.150
   146.032 10971.844     0.150
     0.256    10.119     0.150
     2.259    34.119     0.150
     2.259    59.919     0.150
     2.715    42.219     0.150
     6.830    94.749     0.150
     6.830    98.519     0.150
    24.298   314.389     0.150
    24.298   314.419     0.150
    26.320   329.719     0.150
    30.177  2259.113     0.150
    30.188  2255.693     0.150
    30.195  2256.215     0.150
    31.052  2319.850     0.150
    31.056  2321.380     0.150
    31.070  2325.843     0.150
    42.614   470.419     0.150
    43.640   478.119     0.150
    43.876   480.119     0.150
    43.876   480.119     0.150
    49.189   521.419     0.150
    64.801   631.419     0.150
   145.983 10951.586     0.150
   145.997 10948.922     0.150
   145.999 10949.455     0.150
     1.297    41.031     0.150
     2.255    33.781     0.150
     2.704    41.781     0.150
     2.704    72.781     0.150
     4.571    68.086     0.150
     4.670   122.688     0.150
     8.252   118.688     0.150
     8.291   118.383     0.150
     8.291   118.383     0.150
     8.582   124.281     0.150
     8.582   218.586     0.150
     9.508   231.312     0.150
     9.627   250.984     0.150
     9.627   139.188     0.150
    10.053   160.484     0.150
    10.500   148.883     0.150
    11.774   178.688     0.150
    11.774   185.281     0.150
    11.774   299.781     0.150
    12.605   322.781     0.150
    12.605   176.484     0.150
    12.960   191.688     0.150
    12.960   338.188     0.150
    13.477   186.883     0.150
    14.617   202.086     0.150
    15.172   211.461     0.150
    15.541   375.984     0.150
    15.541   213.781     0.150
    17.644   239.688     0.150
    19.726    11.500     0.150
    19.726    18.102     0.150
    19.726   484.586     0.150
    19.726   494.281     0.150
    20.333   268.383     0.150
    21.320   506.406     0.150
    21.320   277.781     0.150
    21.320   296.688     0.150
    21.320   533.586     0.150
    21.320   546.188     0.150
    21.746    10.703     0.150
    21.746    18.500     0.150
    22.243   523.484     0.150
    23.528    20.805     0.150
    23.528   557.484     0.150
    24.308   310.883     0.150
    25.070    14.195     0.150
    25.070   351.281     0.150
    25.070   565.188     0.150
    25.768   593.781     0.150
    27.821   342.883     0.150
    27.915    14.000     0.150
    27.915    20.898     0.150
    27.915   629.383     0.150
    29.811   361.383     0.150
    30.204  2259.469     0.150
    30.215  2259.562     0.150
    30.222  2260.758     0.150
    30.428   362.664     0.150
    30.803    15.102     0.150
    30.803    23.703     0.150
    30.803   673.484     0.150
    30.803   688.086     0.150
    31.080  2320.273     0.150
    31.084  2334.180     0.150
    31.097  2328.922     0.150
    32.566    10.305     0.150
    33.628    12.000     0.150
    37.145    14.000     0.150
    37.145    24.797     0.150
    37.245    14.695     0.150
    39.824    19.703     0.150
    40.719   454.766     0.150
    42.442   467.781     0.150
    42.792   471.281     0.150
    42.792   468.938     0.150
    42.922   471.938     0.150
    43.204   475.781     0.150
    43.204   477.383     0.150
    43.204   475.688     0.150
    43.204    14.078     0.150
    43.204    20.891     0.150
    43.567   479.484     0.150
    43.623   478.383     0.150
    43.685   478.281     0.150
    43.850   479.984     0.150
    43.850   478.633     0.150
    44.368   486.203     0.150
    44.417   484.812     0.150
    44.551   485.883     0.150
    44.551   485.984     0.150
    44.972   488.273     0.150
    44.921   490.945     0.150
    45.257   491.984     0.150
    45.402   491.383     0.150
    45.402   889.781     0.150
    45.402   491.438     0.150
    45.402   889.883     0.150
    45.735   495.383     0.150
    45.994   496.594     0.150
    46.104   497.562     0.150
    46.384   499.391     0.150
    46.445   500.797     0.150
    47.142   507.742     0.150
    47.086   505.125     0.150
    47.324   507.203     0.150
    47.375   506.953     0.150
    47.350   508.227     0.150
    47.350   508.188     0.150
    47.441   509.164     0.150
    47.519   508.266     0.150
    47.704   510.227     0.150
    48.145   514.305     0.150
    48.145   513.883     0.150
    48.339   516.281     0.150
    48.597   516.602     0.150
    48.731   518.586     0.150
    48.833   518.953     0.150
    49.169   520.992     0.150
    49.254   522.484     0.150
    49.254   522.914     0.150
    49.254   520.875     0.150
    49.254    18.969     0.150
    49.390   525.242     0.150
    49.618   526.008     0.150
    50.124   530.688     0.150
    50.423   531.555     0.150
    51.261   536.914     0.150
    51.652   539.188     0.150
    51.625   540.883     0.150
    51.713   541.203     0.150
    51.713   540.781     0.150
    52.127   544.281     0.150
    52.451   546.625     0.150
    52.870   548.883     0.150
    52.970   550.383     0.150
    53.340   552.484     0.150
    53.340   550.875     0.150
    54.297   559.984     0.150
    54.667   562.484     0.150
    54.794   560.938     0.150
    54.794    17.609     0.150
    54.769   561.656     0.150
    55.707   566.023     0.150
    55.894   567.016     0.150
    56.274   573.844     0.150
    56.822   578.188     0.150
    57.209   579.828     0.150
    57.864   584.383     0.150
    60.025   728.688     0.150
    62.491   612.484     0.150
    64.333   628.484     0.150
    64.671   630.484     0.150
    64.671  1185.281     0.150
    64.671  1404.984     0.150
    64.781   631.883     0.150
    65.542   637.281     0.150
    66.162   640.984     0.150
    67.812   651.688     0.150
    68.327   652.781     0.150
    68.350   654.281     0.150
    68.447   655.883     0.150
    68.467   656.086     0.150
    68.639   656.188     0.150
    68.888  1223.188     0.150
    68.888   658.273     0.150
    68.888   658.273     0.150
    68.888   658.273     0.150
    68.888  1200.156     0.150
    68.888  1223.195     0.150
    68.888  1626.391     0.150
    68.853   658.484     0.150
    69.043   650.242     0.150
    69.607   664.516     0.150
    69.607   664.555     0.150
    69.607   663.023     0.150
    69.832   659.188     0.150
    69.832   662.984     0.150
    69.931   664.125     0.150
    70.547   664.695     0.150
    70.814   668.484     0.150
    71.436   674.328     0.150
    72.004   677.781     0.150
    72.312   679.664     0.150
    72.595   680.750     0.150
    73.021   683.586     0.150
    73.880   708.688     0.150
    74.590   692.766     0.150
    74.816   694.484     0.150
    75.010   694.383     0.150
    75.331   696.180     0.150
    75.351   696.586     0.150
    75.377   695.195     0.150
    75.377   695.188     0.150
    75.526   715.484     0.150
    75.538   698.883     0.150
    75.586   697.688     0.150
    75.803   699.688     0.150
    76.171   702.188     0.150
    76.231   702.352     0.150
    76.312   702.781     0.150
    76.348   702.281     0.150
    76.381   703.188     0.150
    76.639   704.688     0.150
    76.653   704.883     0.150
    76.668   704.383     0.150
    76.672   704.586     0.150
    76.679   704.984     0.150
    76.708   704.586     0.150
    76.725   704.188     0.150
    77.107   707.281     0.150
    77.160   706.586     0.150
    77.164   707.281     0.150
    77.164   729.484     0.150
    77.206   707.484     0.150
    77.359   707.164     0.150
    77.617   709.883     0.150
    77.651   709.984     0.150
    77.750   710.484     0.150
    77.840   711.086     0.150
    78.112   711.781     0.150
    78.714   735.984     0.150
    78.714   715.781     0.150
    78.714    20.203     0.150
    79.045   717.445     0.150
    79.139   718.383     0.150
    79.662   721.688     0.150
    79.821   721.688     0.150
    80.286   725.586     0.150
    81.129   728.234     0.150
    81.321   729.188     0.150
    81.990   732.188     0.150
    82.292   733.586     0.150
    83.810   741.586     0.150
    84.292   744.281     0.150
    84.301   744.484     0.150
    84.360   744.688     0.150
    84.738   745.688     0.150
    85.178   749.086     0.150
    86.012   753.484     0.150
    86.067  6435.188     0.150
    86.274   754.883     0.150
    87.630   761.281     0.150
    88.807   766.422     0.150
   145.994 10970.812     0.150
   146.008 10969.188     0.150
   146.010 10967.922     0.150
   146.128  1171.484     0.150
     1.343    23.184     0.150
     2.186    32.812     0.150
     2.639    40.711     0.150
     2.639    71.012     0.150
     4.646    68.414     0.150
     6.804    99.613     0.150
     8.557   123.312     0.150
     8.557   215.812     0.150
     9.553   230.711     0.150
     9.630   138.914     0.150
    25.899   326.414     0.150
    26.343   330.352     0.150
    26.343   330.312     0.150
    30.175  2254.078     0.150
    30.185  2256.129     0.150
    30.192  2255.410     0.150
    31.052  2323.406     0.150
    31.056  2319.223     0.150
    31.070  2322.125     0.150
    39.525   444.914     0.150
    42.634   470.414     0.150
    42.835   471.211     0.150
    43.887   480.613     0.150
    48.176   513.613     0.150
    49.894   527.211     0.150
    62.472   616.812     0.150
    64.688   630.613     0.150
    68.477   656.812     0.150
    68.498   656.414     0.150
    69.825   662.812     0.150
    75.389   694.914     0.150
    77.123   705.613     0.150
    77.167   702.812     0.150
    78.584   714.812     0.150
    78.723   716.211     0.150
   145.931 10950.625     0.150
   145.944 10951.574     0.150
   145.946 10951.922     0.150
     0.290    10.453     0.150
     0.290    18.352     0.150
     1.859    30.250     0.150
     2.733    42.453     0.150
     4.599    72.852     0.150
     4.677    69.750     0.150
     4.677   122.055     0.150
     6.823    98.352     0.150
     6.823   171.938     0.150
    25.829   324.750     0.150
    25.829   324.750     0.150
    26.273   328.852     0.150
    30.222  2258.414     0.150
    30.233  2261.695     0.150
    30.240  2262.219     0.150
    31.097  2323.023     0.150
    31.101  2324.109     0.150
    31.114  2326.844     0.150
    42.568   469.352     0.150
    42.769   471.352     0.150
    43.829   479.555     0.150
    43.829   479.555     0.150
    47.350   508.648     0.150
    48.126   512.250     0.150
    49.230   521.852     0.150
    49.230   521.852     0.150
    50.075   529.953     0.150
    51.689   540.055     0.150
    53.324   551.953     0.150
    54.642   562.148     0.150
    55.588   568.891     0.150
    62.422   616.852     0.150
    64.763   630.453     0.150
    66.149   643.219     0.150
    76.294   700.992     0.150
    76.294   700.953     0.150
    79.071   714.602     0.150
   146.025 10969.195     0.150
   146.038 10963.070     0.150
   146.041 10967.703     0.150
     0.201     9.051     0.150
     0.201    15.543     0.150
     0.402    10.262     0.150
     0.923    27.660     0.150
     1.139    19.293     0.150
     1.845    29.750     0.150
     1.846    45.602     0.150
     2.257    33.551     0.150
     2.704    41.453     0.150
     2.704    73.750     0.150
     4.571    67.953     0.150
     4.660    69.551     0.150
     4.660   122.453     0.150
     5.405   146.551     0.150
     5.405    77.852     0.150
     8.242   116.750     0.150
     8.573   123.953     0.150
     9.615   249.852     0.150
     9.615   138.453     0.150
    10.488   148.250     0.150
    12.302   301.852     0.150
    12.600   315.953     0.150
    12.601   176.250     0.150
    16.596   404.352     0.150
    17.632   240.953     0.150
    17.952   242.750     0.150
    19.716   474.352     0.150
    20.314    12.000     0.150
    20.314    20.199     0.150
    20.325   268.750     0.150
    21.309   512.352     0.150
    21.309   537.652     0.150
    24.308   308.953     0.150
    25.842   325.250     0.150
    29.799   360.750     0.150
    30.216  2256.156     0.150
    30.227  2260.090     0.150
    30.234  2262.684     0.150
    31.092  2328.418     0.150
    31.096  2320.723     0.150
    31.110  2323.336     0.150
    32.557    21.500     0.150
    32.933   390.117     0.150
    39.480   443.750     0.150
    40.708   454.551     0.150
    42.231   467.441     0.150
    42.579   469.453     0.150
    42.696   468.121     0.150
    42.777   471.809     0.150
    42.781   471.152     0.150
    42.781   471.133     0.150
    43.114   473.641     0.150
    43.621   478.051     0.150
    43.725   480.383     0.150
    43.725   480.352     0.150
    43.838   479.352     0.150
    43.838   479.410     0.150
    43.967   480.352     0.150
    44.012   481.051     0.150
    44.549   485.535     0.150
    44.549   485.551     0.150
    44.914   488.352     0.150
    45.255   491.551     0.150
    45.391   491.750     0.150
    45.983   496.453     0.150
    46.093   497.750     0.150
    46.269   501.730     0.150
    46.373   499.852     0.150
    46.434   500.453     0.150
    46.652   500.320     0.150
    46.865   501.723     0.150
    46.992   505.223     0.150
    47.075   504.953     0.150
    47.313   507.551     0.150
    47.508   508.051     0.150
    47.692   509.953     0.150
    47.708   508.750     0.150
    48.133   513.453     0.150
    48.133   513.453     0.150
    48.133   513.531     0.150
    48.585   517.891     0.150
    48.585   517.852     0.150
    49.165   520.801     0.150
    49.165   520.852     0.150
    49.243   522.152     0.150
    49.243   522.273     0.150
    49.560    13.500     0.150
    49.825   526.551     0.150
    51.250   536.953     0.150
    51.701   540.051     0.150
    51.701   540.250     0.150
    52.115   543.652     0.150
    53.327   552.051     0.150
    53.327   616.250     0.150
    53.327  1001.953     0.150
    53.327   552.152     0.150
    53.327   552.152     0.150
    54.287   559.551     0.150
    54.577   560.152     0.150
    54.656   562.152     0.150
    55.401   568.250     0.150
    55.697   562.883     0.150
    55.884   567.871     0.150
    56.811   577.051     0.150
    57.202   579.152     0.150
    60.013   598.051     0.150
    60.643   601.352     0.150
    62.432   616.102     0.150
    62.443   615.633     0.150
    62.443   615.652     0.150
    64.659   630.152     0.150
    64.759   629.801     0.150
    65.542   636.750     0.150
    66.170   641.352     0.150
    68.435   656.453     0.150
    68.455   655.750     0.150
    68.759   656.551     0.150
    68.760   654.430     0.150
    68.841   658.652     0.150
    68.876   657.121     0.150
    68.876   657.121     0.150
    68.876   909.613     0.150
    68.876  1507.883     0.150
    68.876  1671.180     0.150
    68.876   657.051     0.150
    68.876    16.402     0.150
    68.876   680.453     0.150
    68.876   809.352     0.150
    68.876   909.551     0.150
    68.876  1196.652     0.150
    68.876  1224.953     0.150
    69.820   662.750     0.150
    69.820   661.676     0.150
    70.338   819.152     0.150
    70.338   920.652     0.150
    70.338  1488.453     0.150
    71.426   673.641     0.150
    73.868   684.750     0.150
    74.559   689.320     0.150
    74.675   709.844     0.150
    74.958   694.551     0.150
    75.060   695.652     0.150
    75.113   695.352     0.150
    75.526   697.852     0.150
    75.791   697.996     0.150
    75.791   697.953     0.150
    76.159   702.051     0.150
    76.299   702.250     0.150
    76.325   702.750     0.150
    76.538   707.250     0.150
    76.538   707.250     0.150
    76.627   704.051     0.150
    76.641   704.551     0.150
    76.656   704.652     0.150
    76.660   704.652     0.150
    76.667   704.750     0.150
    76.696   704.652     0.150
    77.098   706.852     0.150
    77.148   705.852     0.150
    77.378   708.551     0.150
    77.523   710.043     0.150
    77.605   709.750     0.150
    77.639   709.652     0.150
    77.738   710.051     0.150
    78.100   711.953     0.150
    78.693   714.145     0.150
    78.887   890.949     0.150
    78.887   716.152     0.150
    79.450   717.965     0.150
    79.650   721.953     0.150
    79.811   721.598     0.150
    80.478   725.250     0.150
    81.183   730.312     0.150
    81.915   732.551     0.150
    85.207  6346.250     0.150
    85.958   754.250     0.150
    85.950  6411.953     0.150
    86.010   753.551     0.150
    90.195  6727.652     0.150
   146.610  1173.773     0.150
   146.940  1176.953     0.150
   146.940  1176.953     0.150
   149.765  1183.352     0.150
   168.000  1266.652     0.150
     4.616   118.316     0.150
    30.285  2262.629     0.150
    30.296  2261.531     0.150
    30.303  2263.977     0.150
    31.160  2327.543     0.150
    31.164  2324.637     0.150
    31.177  2328.309     0.150
    42.504   469.576     0.150
    65.408   634.516     0.150
    66.176   638.986     0.150
    70.851   670.266     0.150
   146.077 10971.613     0.150
   146.091 10972.559     0.150
   146.093 10972.906     0.150
     0.277    10.027     0.150
     1.863    45.000     0.150
     2.124    34.727     0.150
     2.233    33.625     0.150
     2.233    59.125     0.150
     3.175    47.125     0.150
     3.175    83.125     0.150
     4.553   116.926     0.150
     4.673    70.125     0.150
     4.673   122.125     0.150
     6.830    99.625     0.150
     8.317   117.027     0.150
     8.585   224.324     0.150
     9.514   229.777     0.150
     9.640   249.324     0.150
    10.079   159.926     0.150
    10.079   251.926     0.150
    10.520   148.527     0.150
    10.989   152.227     0.150
    10.989   273.125     0.150
    11.272   281.625     0.150
    11.799   184.426     0.150
    11.799   300.426     0.150
    12.287   301.227     0.150
    12.630   321.547     0.150
    12.630   177.426     0.150
    12.630   177.125     0.150
    12.986   200.727     0.150
    13.430   195.727     0.150
    13.430   348.227     0.150
    13.502   188.227     0.150
    14.495   365.926     0.150
    14.603   200.727     0.150
    14.984   209.227     0.150
    15.172   206.125     0.150
    15.172   364.902     0.150
    15.172   205.246     0.150
    15.559   388.426     0.150
    17.668   240.027     0.150
    17.956   244.527     0.150
    19.606   473.852     0.150
    19.752   494.926     0.150
    20.348    14.500     0.150
    20.348    23.301     0.150
    20.348   488.227     0.150
    20.348   504.426     0.150
    20.359   268.824     0.150
    20.950   495.926     0.150
    21.330   506.195     0.150
    21.330   278.227     0.150
    21.770    16.500     0.150
    21.770    20.301     0.150
    22.173   307.625     0.150
    22.173   324.727     0.150
    22.269    19.000     0.150
    22.269    25.500     0.150
    22.269   524.426     0.150
    23.554    15.301     0.150
    23.554   555.926     0.150
    23.554   571.926     0.150
    24.751    13.000     0.150
    24.751    21.801     0.150
    24.810   315.828     0.150
    25.095    13.199     0.150
    25.095   573.426     0.150
    25.792    16.199     0.150
    25.792    21.699     0.150
    25.878   325.027     0.150
    26.028   330.426     0.150
    26.322   329.027     0.150
    27.941    14.801     0.150
    27.941    21.500     0.150
    30.183  2257.273     0.150
    30.194  2258.609     0.150
    30.201  2259.148     0.150
    30.267   361.426     0.150
    30.830    15.000     0.150
    30.830    23.000     0.150
    30.830   688.426     0.150
    31.059  2310.328     0.150
    31.063  2327.684     0.150
    31.077  2321.984     0.150
    31.784   678.227     0.150
    32.592    11.000     0.150
    32.592    24.301     0.150
    33.652    16.000     0.150
    33.652   709.227     0.150
    36.442    20.699     0.150
    36.499   417.625     0.150
    37.170    16.000     0.150
    37.270    16.500     0.150
    37.270   763.727     0.150
    37.462   764.227     0.150
    39.849    18.500     0.150
    40.383    15.301     0.150
    40.383    23.000     0.150
    40.744   455.125     0.150
    40.744   820.926     0.150
    41.194   458.586     0.150
    41.505   462.027     0.150
    42.122   468.227     0.150
    42.425   468.195     0.150
    42.425   468.227     0.150
    42.615   470.027     0.150
    42.817   471.426     0.150
    43.173   474.590     0.150
    43.609   477.727     0.150
    43.670   477.426     0.150
    43.711   477.926     0.150
    43.873   479.809     0.150
    43.873   480.027     0.150
    43.873   480.086     0.150
    44.001   481.125     0.150
    43.996   481.027     0.150
    44.536   485.426     0.150
    44.734   485.148     0.150
    44.947   488.426     0.150
    45.243   490.527     0.150
    45.487   493.027     0.150
    45.427   492.527     0.150
    45.760   495.527     0.150
    46.019   497.125     0.150
    46.129   498.227     0.150
    46.409   500.426     0.150
    46.470   500.824     0.150
    46.864   503.324     0.150
    47.349   508.027     0.150
    47.349   917.027     0.150
    47.375   508.426     0.150
    47.466   509.527     0.150
    47.727   510.227     0.150
    48.166   514.027     0.150
    48.166   514.027     0.150
    48.166   514.125     0.150
    48.166   514.016     0.150
    48.422   517.438     0.150
    48.621   516.926     0.150
    48.857   519.125     0.150
    49.158   521.125     0.150
    49.279   522.773     0.150
    49.279   522.773     0.150
    49.279   522.824     0.150
    49.279   522.785     0.150
    49.596    14.699     0.150
    49.596    21.500     0.150
    50.797   536.527     0.150
    51.286   537.426     0.150
    51.636   540.527     0.150
    51.636   541.348     0.150
    51.737   540.426     0.150
    51.737   540.395     0.150
    51.737   540.426     0.150
    52.149   544.742     0.150
    52.147   988.125     0.150
    52.476   546.727     0.150
    52.895   548.926     0.150
    53.359   616.125     0.150
    53.359   741.727     0.150
    53.359  1334.527     0.150
    53.359   552.625     0.150
    53.359    16.012     0.150
    53.756   557.605     0.150
    54.692   562.426     0.150
    55.714   566.605     0.150
    55.898   567.824     0.150
    55.885   570.727     0.150
    56.848   577.125     0.150
    56.848   578.371     0.150
    57.204   579.426     0.150
    57.646   584.125     0.150
    57.877   582.824     0.150
    58.134   588.227     0.150
    59.008   592.324     0.150
    59.008   592.375     0.150
    59.554   595.926     0.150
    62.127   613.727     0.150
    62.426   617.027     0.150
    62.490   617.016     0.150
    62.490   617.027     0.150
    62.633   615.336     0.150
    63.830   646.426     0.150
    63.830   624.727     0.150
    64.348   628.824     0.150
    64.477   629.926     0.150
    64.689   866.625     0.150
    64.689   630.727     0.150
    64.785   630.824     0.150
    64.965   632.695     0.150
    65.525   636.527     0.150
    65.793  1182.234     0.150
    66.190   640.727     0.150
    66.157   642.625     0.150
    66.164   640.527     0.150
    66.277    24.801     0.150
    66.277  1419.625     0.150
    66.710   643.246     0.150
    67.019   645.824     0.150
    67.021    18.703     0.150
    67.578  1182.824     0.150
    67.578  1445.727     0.150
    68.195   654.727     0.150
    68.326   653.324     0.150
    68.468   906.324     0.150
    68.468   656.652     0.150
    68.468   656.426     0.150
    68.468   656.414     0.150
    68.489   656.125     0.150
    68.626   656.324     0.150
    68.905   657.875     0.150
    68.905   657.875     0.150
    68.905    18.582     0.150
    68.905   910.945     0.150
    68.905  1661.977     0.150
    68.905   657.824     0.150
    68.905    18.602     0.150
    68.905   810.426     0.150
    68.905   910.926     0.150
    68.905  1196.926     0.150
    68.905  1228.625     0.150
    68.905  1463.824     0.150
    68.875   658.324     0.150
    69.629   663.930     0.150
    69.844   663.027     0.150
    69.845   664.227     0.150
    70.130   665.727     0.150
    70.371   923.625     0.150
    70.371  1481.027     0.150
    70.547   667.227     0.150
    70.547   667.156     0.150
    70.789   670.465     0.150
    70.834    18.301     0.150
    70.834  1220.625     0.150
    70.823   670.418     0.150
    70.900   671.355     0.150
    70.974   672.121     0.150
    71.164   670.926     0.150
    71.164   671.395     0.150
    71.176   672.551     0.150
    71.239   672.125     0.150
    71.230   672.809     0.150
    71.462   674.531     0.150
    71.521   674.977     0.150
    71.587   675.504     0.150
    71.587   675.504     0.150
    71.728   676.285     0.150
    71.763   676.426     0.150
    71.820   677.395     0.150
    71.820   676.668     0.150
    71.970   676.785     0.150
    71.985   676.625     0.150
    72.058   675.926     0.150
    72.123   679.012     0.150
    72.239   679.621     0.150
    72.281   679.605     0.150
    72.673   682.051     0.150
    73.002   683.527     0.150
    73.078   683.625     0.150
    73.118   683.004     0.150
    73.153   683.625     0.150
    73.738  1263.426     0.150
    73.738   686.426     0.150
    73.738    22.000     0.150
    73.797   686.426     0.150
    73.797    27.000     0.150
    73.797  1265.426     0.150
    73.797  1276.426     0.150
    73.797   686.426     0.150
    73.797   707.426     0.150
    73.797    27.000     0.150
    73.797  1276.426     0.150
    73.797  1323.426     0.150
    73.797  2488.426     0.150
    73.814   686.297     0.150
    73.810   685.051     0.150
    74.441   690.625     0.150
    74.471   692.195     0.150
    75.041   695.027     0.150
    75.097   695.125     0.150
    75.102   695.527     0.150
    75.324   697.125     0.150
    75.393   696.926     0.150
    75.401   697.324     0.150
    75.556   698.625     0.150
    75.605   698.926     0.150
    75.750   698.125     0.150
    75.812   699.176     0.150
    76.206   701.324     0.150
    76.333   702.227     0.150
    76.333   702.727     0.150
    76.354   726.426     0.150
    76.354   703.926     0.150
    76.354   726.426     0.150
    76.364   702.824     0.150
    76.364   723.324     0.150
    76.399   703.727     0.150
    76.566   703.426     0.150
    76.566   725.926     0.150
    76.603   704.324     0.150
    76.603   724.824     0.150
    76.655   703.727     0.150
    76.672   705.027     0.150
    76.684   704.125     0.150
    76.684   704.125     0.150
    76.684   721.227     0.150
    76.688   704.426     0.150
    76.688   725.625     0.150
    76.700   704.527     0.150
    76.700   705.676     0.150
    76.724   704.727     0.150
    76.743   705.125     0.150
    76.792   704.426     0.150
    76.958   705.652     0.150
    77.124   706.727     0.150
    77.127   729.227     0.150
    77.127   707.227     0.150
    77.127   729.227     0.150
    77.175   706.527     0.150
    77.175  1356.426     0.150
    77.175  1602.426     0.150
    77.175  1674.426     0.150
    77.175   706.527     0.150
    77.175    20.297     0.150
    77.180    14.410     0.150
    77.180   707.027     0.150
    77.180   721.527     0.150
    77.180   729.625     0.150
    77.222   708.027     0.150
    77.382   708.902     0.150
    77.406   708.926     0.150
    77.406   730.727     0.150
    77.406   708.926     0.150
    77.667   709.926     0.150
    77.667   732.926     0.150
    77.681   731.727     0.150
    77.695   732.926     0.150
    77.867   733.926     0.150
    77.867   712.125     0.150
    77.867   733.926     0.150
    77.877   734.324     0.150
    77.877   712.324     0.150
    77.877   734.324     0.150
    78.627   715.125     0.150
    78.699   715.426     0.150
    78.699   737.426     0.150
    78.730   716.027     0.150
    78.914   715.867     0.150
    78.914   716.227     0.150
    79.030   717.109     0.150
    79.152   717.457     0.150
    79.152   717.426     0.150
    79.154   717.324     0.150
    79.296   719.312     0.150
    79.399   718.727     0.150
    79.540   719.527     0.150
    79.613   720.246     0.150
    79.681   721.426     0.150
    79.681   721.527     0.150
    79.847   721.426     0.150
    79.847   722.355     0.150
    80.164   723.914     0.150
    80.654   725.727     0.150
    80.692   725.324     0.150
    80.730   725.895     0.150
    81.228   729.324     0.150
    81.336   729.527     0.150
    81.470   724.227     0.150
    81.631   730.625     0.150
    81.846   731.727     0.150
    81.882   732.125     0.150
    81.946   732.324     0.150
    82.006   732.426     0.150
    82.008   731.824     0.150
    82.232   735.027     0.150
    82.354   734.727     0.150
    83.210   741.062     0.150
    83.788   742.926     0.150
    84.085   744.324     0.150
    84.307   744.527     0.150
    84.724   747.324     0.150
    85.171  6346.926     0.150
    85.847   753.785     0.150
    85.847   753.785     0.150
    85.937   753.727     0.150
    85.915   754.527     0.150
    85.915  6419.426     0.150
    85.997   752.824     0.150
    85.997   752.273     0.150
    86.043  6436.625     0.150
    86.260  6446.227     0.150
    87.113  6503.027     0.150
    87.613   761.324     0.150
    88.442   766.016     0.150
    88.468   766.082     0.150
    88.963   768.453     0.150
    89.160   768.426     0.150
    89.182   769.426     0.150
    89.657   771.688     0.150
    89.768   771.617     0.150
    89.783   772.070     0.150
    89.810   772.223     0.150
    90.160  6737.125     0.150
   124.805  1132.125     0.150
   139.560  1160.227     0.150
   142.786  1164.902     0.150
   145.968 10967.363     0.150
   145.981 10970.855     0.150
   145.984 10969.043     0.150
     0.173     5.801     0.150
     0.651    13.031     0.150
     0.651    23.730     0.150
     1.118    19.562     0.150
     1.232    22.141     0.150
     1.232    21.840     0.150
     1.231    22.340     0.150
     1.231    21.801     0.150
     1.428    24.891     0.150
     1.428    24.941     0.150
     1.485    25.141     0.150
     1.900    31.301     0.150
     2.600    41.031     0.150
     2.888    43.641     0.150
     2.888    76.641     0.150
     2.888    43.641     0.150
     2.888    76.641     0.150
     3.166    88.242     0.150
     3.779    56.840     0.150
     4.210    63.641     0.150
     4.415    64.641     0.150
     4.969   133.941     0.150
     6.290    92.539     0.150
     7.319   106.840     0.150
     7.319   106.742     0.150
     7.328  2397.641     0.150
     8.808   126.742     0.150
     8.808   227.742     0.150
     9.077   138.441     0.150
     9.077   248.441     0.150
    10.396   261.039     0.150
    10.790   157.539     0.150
    10.782   158.340     0.150
    10.782   165.941     0.150
    10.782   171.941     0.150
    10.782   284.340     0.150
    11.958   171.469     0.150
    11.958   171.441     0.150
    12.009   175.340     0.150
    12.009   309.941     0.150
    12.427   330.141     0.150
    12.549   179.441     0.150
    12.758   189.039     0.150
    12.882   192.141     0.150
    12.962   191.242     0.150
    12.962   186.742     0.150
    13.573   196.039     0.150
    14.463   203.062     0.150
    14.767   206.840     0.150
    15.177   213.742     0.150
    15.793   228.039     0.150
    17.680   244.539     0.150
    18.768   462.141     0.150
    19.401   268.242     0.150
    19.441    12.500     0.150
    19.452   263.742     0.150
    20.152   270.742     0.150
    20.586   274.758     0.150
    21.123     8.699     0.150
    21.153   286.641     0.150
    21.416   512.941     0.150
    23.806   313.441     0.150
    23.806    11.699     0.150
    23.806    16.898     0.150
    23.806   347.742     0.150
    23.806   582.141     0.150
    24.856   318.242     0.150
    25.110    12.602     0.150
    25.110   580.141     0.150
    25.300   321.789     0.150
    25.787   336.340     0.150
    26.366   341.539     0.150
    27.114     9.199     0.150
    27.334   337.141     0.150
    27.539   346.641     0.150
    27.539   627.941     0.150
    35.758   413.969     0.150
    36.407    11.902     0.150
    36.540    12.000     0.150
    38.834    11.500     0.150
    39.609    10.898     0.150
    39.609   974.340     0.150
    39.718   450.141     0.150
    39.750   448.867     0.150
    40.594   457.039     0.150
    41.469   464.008     0.150
    41.589   464.840     0.150
    41.791   466.441     0.150
    41.921   466.742     0.150
    42.361   471.707     0.150
    42.339   471.242     0.150
    42.426   471.062     0.150
    42.850   474.742     0.150
    42.850   474.930     0.150
    43.327   479.191     0.150
    43.317   478.641     0.150
    43.606   481.102     0.150
    43.810   482.441     0.150
    44.245   486.840     0.150
    44.524   486.551     0.150
    44.713   490.539     0.150
    44.407   487.441     0.150
    45.012   492.527     0.150
    45.015   492.289     0.150
    44.999   492.141     0.150
    45.108   493.242     0.150
    45.388   495.242     0.150
    45.449   496.141     0.150
    45.882   498.547     0.150
    46.087   500.742     0.150
    46.327   503.242     0.150
    46.353   503.941     0.150
    46.353   503.941     0.150
    46.444   504.441     0.150
    46.520   503.840     0.150
    46.651   504.879     0.150
    46.704   505.641     0.150
    47.154   510.680     0.150
    47.154   509.242     0.150
    47.342   511.441     0.150
    47.595   512.242     0.150
    47.834   514.840     0.150
    48.416   518.031     0.150
    50.146   532.953     0.150
    50.261   532.941     0.150
    50.712   535.840     0.150
    50.712   535.840     0.150
    51.451   542.539     0.150
    51.875   545.340     0.150
    52.098   545.402     0.150
    52.376    14.301     0.150
    52.376  1200.840     0.150
    53.329   555.641     0.150
    55.337   569.539     0.150
    56.955   581.742     0.150
    57.617   588.039     0.150
    58.758   594.340     0.150
    59.126   595.242     0.150
    59.126     9.098     0.150
    59.126   641.141     0.150
    59.356   599.781     0.150
    62.792   621.242     0.150
    62.884  1142.941     0.150
    63.742   627.840     0.150
    63.914   629.141     0.150
    64.172   631.941     0.150
    64.583   633.941     0.150
    64.668   634.039     0.150
    64.936   636.242     0.150
    65.337   637.531     0.150
    65.358   639.641     0.150
    65.707   641.660     0.150
    65.819   642.141     0.150
    66.580   656.840     0.150
    66.624   648.941     0.150
    67.458   653.141     0.150
    67.458   655.301     0.150
    67.828   655.141     0.150
    67.861   655.141     0.150
    67.981   655.801     0.150
    67.981   655.801     0.150
    67.981    14.148     0.150
    67.981   675.891     0.150
    67.981   905.840     0.150
    67.981  1231.141     0.150
    67.981  1452.199     0.150
    67.981  1648.750     0.150
    67.981   655.742     0.150
    67.981    14.199     0.150
    67.981   675.840     0.150
    67.981   806.742     0.150
    67.981   905.840     0.150
    67.981  1190.441     0.150
    67.981  1231.141     0.150
    67.981  1452.141     0.150
    68.399   658.230     0.150
    68.402  1454.941     0.150
    68.586   659.840     0.150
    68.569   660.441     0.150
    68.609   660.441     0.150
    68.682   658.500     0.150
    68.682   658.539     0.150
    68.710   659.941     0.150
    68.710   659.859     0.150
    68.723   659.141     0.150
    68.825   659.191     0.150
    69.030   661.742     0.150
    69.030   659.340     0.150
    69.276   664.359     0.150
    69.380   664.871     0.150
    69.366   914.641     0.150
    69.366  1662.039     0.150
    69.641   670.645     0.150
    69.837   666.941     0.150
    69.991   667.941     0.150
    70.310   669.539     0.150
    70.419   671.742     0.150
    70.591   669.852     0.150
    70.678   672.441     0.150
    71.045   675.242     0.150
    72.157   680.863     0.150
    72.200   682.742     0.150
    72.336   681.840     0.150
    72.771   684.641     0.150
    72.774   685.641     0.150
    74.036   692.840     0.150
    74.389   695.742     0.150
    74.397   694.441     0.150
    74.472   695.242     0.150
    74.591   695.941     0.150
    74.640   698.023     0.150
    74.640   697.941     0.150
    74.711   693.941     0.150
    74.782   702.082     0.150
    74.782   702.039     0.150
    74.824   695.488     0.150
    74.859   697.109     0.150
    74.873   698.441     0.150
    74.858   685.180     0.150
    75.222   700.539     0.150
    75.241   700.539     0.150
    75.339   699.641     0.150
    75.406   701.039     0.150
    75.431   702.840     0.150
    75.431   702.941     0.150
    75.604   701.941     0.150
    75.702   702.340     0.150
    75.710   702.840     0.150
    75.744   702.340     0.150
    75.782   703.039     0.150
    75.784   702.539     0.150
    75.817   702.941     0.150
    75.959   703.133     0.150
    76.193   704.242     0.150
    76.203   705.340     0.150
    76.290   706.039     0.150
    76.290   721.441     0.150
    76.292   704.641     0.150
    76.292    16.000     0.150
    76.292   727.641     0.150
    76.292  1309.641     0.150
    76.292  1573.641     0.150
    76.292   704.641     0.150
    76.292    16.000     0.150
    76.473   705.840     0.150
    76.733   708.441     0.150
    76.769   709.039     0.150
    76.949   710.242     0.150
    76.952   710.742     0.150
    77.183   710.949     0.150
    77.161   711.941     0.150
    77.181   710.340     0.150
    77.307   710.496     0.150
    77.625   714.141     0.150
    77.770   712.898     0.150
    77.832   713.641     0.150
    78.129   714.441     0.150
    78.557   717.742     0.150
    78.714   718.941     0.150
    78.828   718.879     0.150
    78.829   719.539     0.150
    78.981   719.609     0.150
    79.040   719.422     0.150
    79.032   719.465     0.150
    79.718   722.316     0.150
    79.829   725.816     0.150
    79.971   725.441     0.150
    80.461   727.941     0.150
    80.644   730.441     0.150
    81.170   731.570     0.150
    83.401   743.742     0.150
    85.023   751.340     0.150
    85.957   755.531     0.150
    86.178   756.352     0.150
    86.178   756.340     0.150
    86.194  6363.539     0.150
    86.295   758.848     0.150
    86.774   760.352     0.150
    87.822   763.922     0.150
    88.494   766.730     0.150
    88.494   769.168     0.150
    88.825   769.430     0.150
   145.978  1176.652     0.150
   146.323  1175.840     0.150
   149.164  1182.539     0.150
     0.286    14.029     0.150
     0.567    12.068     0.150
     0.567    21.029     0.150
     0.667    22.738     0.150
    31.213  2381.492     0.150
    31.223  2378.660     0.150
    31.230  2383.160     0.150
    32.083  2444.133     0.150
    32.086  2443.410     0.150
    32.100  2444.445     0.150
     2.283    60.506     0.150
     3.225    47.906     0.150
     4.671    70.006     0.150
     6.828    92.875     0.150
    14.638   192.406     0.150
    28.310   340.105     0.150
    59.739   601.006     0.150
    73.161   679.451     0.150
     0.726    14.058     0.150
     0.727    14.348     0.150
     1.044    32.747     0.150
     1.638    25.348     0.150
     2.107    33.048     0.150
     2.107    58.147     0.150
     2.580    38.348     0.150
     4.432    65.348     0.150
     4.432    65.348     0.150
     4.432   114.348     0.150
     5.738    83.747     0.150
     5.738   151.647     0.150
     7.404   104.848     0.150
     8.320   210.048     0.150
     8.320   216.947     0.150
     8.745   125.747     0.150
     9.618   138.048     0.150
     9.956   240.048     0.150
    10.486   278.848     0.150
    10.486   504.147     0.150
    10.486   932.447     0.150
    10.688   152.947     0.150
    10.688   268.147     0.150
    10.991   274.647     0.150
    10.991   155.848     0.150
    11.721   162.947     0.150
    11.721   295.048     0.150
    12.172   181.747     0.150
    12.172   184.147     0.150
    12.172     8.101     0.150
    12.172   309.947     0.150
    13.211   183.947     0.150
    13.628   206.247     0.150
    13.628   338.747     0.150
    14.057   193.747     0.150
    14.079   195.647     0.150
    14.430   198.048     0.150
    14.430   351.548     0.150
    15.504   207.747     0.150
    15.504   365.822     0.150
    15.644   383.147     0.150
    17.557   238.048     0.150
    20.185   494.247     0.150
    20.185   524.848     0.150
    20.851    18.000     0.150
    20.851   509.747     0.150
    20.863   274.947     0.150
    21.209    26.500     0.150
    21.209   552.647     0.150
    21.209   948.848     0.150
    21.503   278.747     0.150
    22.356    13.100     0.150
    22.356    19.899     0.150
    22.651   292.747     0.150
    22.802   542.247     0.150
    24.031     9.200     0.150
    24.031   562.147     0.150
    24.031   588.147     0.150
    24.133   307.848     0.150
    24.363   570.048     0.150
    25.226    14.200     0.150
    25.226    21.700     0.150
    25.226   583.048     0.150
    25.647    13.500     0.150
    25.647    21.900     0.150
    26.225   329.247     0.150
    26.225   329.247     0.150
    26.669   333.447     0.150
    27.188   341.747     0.150
    28.108   343.548     0.150
    28.659   350.647     0.150
    29.992  2263.032     0.150
    30.003  2262.483     0.150
    30.010  2249.450     0.150
    30.058   359.447     0.150
    30.109   363.447     0.150
    30.885  2325.868     0.150
    30.889  2318.940     0.150
    30.903  2327.275     0.150
    31.338    12.601     0.150
    31.338    18.301     0.150
    33.081   390.356     0.150
    33.052    12.300     0.150
    37.037   773.048     0.150
    37.843    18.200     0.150
    39.887   446.247     0.150
    40.221    13.100     0.150
    40.221    22.200     0.150
    41.062   456.747     0.150
    41.849   462.548     0.150
    42.936   471.947     0.150
    43.136   474.147     0.150
    43.215   474.848     0.150
    43.215   474.848     0.150
    43.463   476.743     0.150
    43.463   478.747     0.150
    43.744   480.647     0.150
    44.135   481.747     0.150
    44.135   481.747     0.150
    44.135   481.747     0.150
    44.579   485.548     0.150
    45.486   492.147     0.150
    45.908   495.558     0.150
    45.783   494.447     0.150
    46.090   496.947     0.150
    46.372   498.447     0.150
    46.478   500.348     0.150
    46.760   502.147     0.150
    46.822   502.848     0.150
    47.053   506.147     0.150
    47.449   507.548     0.150
    47.695   510.147     0.150
    47.763   511.147     0.150
    47.880   510.548     0.150
    47.983   511.088     0.150
    47.983   511.048     0.150
    48.379   514.848     0.150
    48.713   518.548     0.150
    48.937   518.548     0.150
    49.117   522.857     0.150
    49.117   522.848     0.150
    49.193   520.947     0.150
    49.622   525.447     0.150
    49.622   525.447     0.150
    49.975   532.848     0.150
    49.975    16.399     0.150
    49.975   963.247     0.150
    51.615   539.348     0.150
    52.062   542.548     0.150
    52.062   542.548     0.150
    52.289   544.348     0.150
    52.808   548.348     0.150
    53.501   614.647     0.150
    53.501   552.917     0.150
    55.055   569.747     0.150
    55.154   566.518     0.150
    55.448   625.836     0.150
    55.514   567.678     0.150
    57.243   580.747     0.150
    57.397   584.548     0.150
    58.407   600.247     0.150
    60.078    21.300     0.150
    60.078   595.348     0.150
    60.078    21.300     0.150
    60.405   599.647     0.150
    62.285   611.978     0.150
    62.395   615.048     0.150
    62.804   618.577     0.150
    63.238   621.928     0.150
    63.917   625.348     0.150
    63.908   638.447     0.150
    64.769   630.247     0.150
    64.769  1174.647     0.150
    64.947   632.348     0.150
    65.135   633.147     0.150
    65.135   632.647     0.150
    65.598   637.048     0.150
    65.681   635.447     0.150
    65.985   635.447     0.150
    66.510    19.300     0.150
    66.510  1193.647     0.150
    67.606   649.848     0.150
    68.090   651.947     0.150
    68.671   656.348     0.150
    68.671   657.957     0.150
    68.694   657.048     0.150
    68.952   658.037     0.150
    68.952   658.037     0.150
    68.952    14.011     0.150
    68.952    20.040     0.150
    68.952   913.287     0.150
    68.952  1471.258     0.150
    68.952  1669.518     0.150
    68.952   657.947     0.150
    68.952    20.101     0.150
    68.952   810.647     0.150
    68.952   913.247     0.150
    68.952  1200.848     0.150
    68.952  1219.647     0.150
    68.952  1226.147     0.150
    68.952  1471.247     0.150
    69.770   662.147     0.150
    69.813   662.067     0.150
    69.813   662.048     0.150
    70.201   665.048     0.150
    70.178   664.428     0.150
    70.563   928.147     0.150
    70.563  1494.548     0.150
    71.025   670.147     0.150
    71.400   673.348     0.150
    72.433   678.567     0.150
    73.252   683.348     0.150
    74.523   691.548     0.150
    74.528   691.147     0.150
    75.075   694.747     0.150
    75.386   697.147     0.150
    75.433   696.897     0.150
    75.433   696.947     0.150
    75.454   696.747     0.150
    75.489   696.947     0.150
    75.664   698.848     0.150
    75.712   698.947     0.150
    75.756   698.647     0.150
    76.311   702.147     0.150
    76.397   702.747     0.150
    76.483   704.147     0.150
    76.584   703.447     0.150
    76.686   703.947     0.150
    76.686   703.848     0.150
    76.701   704.647     0.150
    76.707   704.447     0.150
    76.748    19.100     0.150
    76.748   704.147     0.150
    76.748   723.247     0.150
    76.773   705.147     0.150
    76.884   705.447     0.150
    77.171   705.947     0.150
    77.171   717.647     0.150
    77.171    17.500     0.150
    77.173   707.048     0.150
    77.183   707.147     0.150
    77.183   725.447     0.150
    77.183   707.200     0.150
    77.180   706.848     0.150
    77.231   707.048     0.150
    77.426   709.147     0.150
    77.434   708.447     0.150
    77.646   709.447     0.150
    77.654   709.848     0.150
    77.679   709.247     0.150
    77.679   727.247     0.150
    77.857   709.947     0.150
    77.905   711.548     0.150
    78.214   712.269     0.150
    78.210   711.947     0.150
    78.255   712.848     0.150
    78.513   712.147     0.150
    78.513   712.147     0.150
    78.717   715.348     0.150
    78.717   733.647     0.150
    78.742   715.548     0.150
    78.742   733.647     0.150
    78.927   716.048     0.150
    79.149   717.548     0.150
    79.513   720.451     0.150
    79.679   720.548     0.150
    79.679   721.593     0.150
    79.791   721.747     0.150
    80.563   724.747     0.150
    80.643   725.647     0.150
    80.787    12.271     0.150
    81.183   727.867     0.150
    81.322   728.848     0.150
    81.826   730.647     0.150
    82.034   731.147     0.150
    82.034   731.147     0.150
    82.463   734.548     0.150
    83.368   740.537     0.150
    84.049   742.348     0.150
    84.719   746.348     0.150
    85.269   748.808     0.150
    85.269   748.848     0.150
    85.438   750.247     0.150
    85.601   750.747     0.150
    85.886   752.048     0.150
    86.408   755.247     0.150
    86.763   756.548     0.150
    87.354   758.548     0.150
    87.591   760.447     0.150
    89.527   770.447     0.150
    90.102   772.447     0.150
    91.890   779.348     0.150
    93.058   786.122     0.150
   114.531  1161.604     0.150
   138.992  1157.947     0.150
   142.193  1164.747     0.150
   142.193  1160.697     0.150
   144.842  1168.117     0.150
   145.061  1169.129     0.150
   145.447 10938.741     0.150
   145.460 10939.548     0.150
   145.462 10940.042     0.150
   146.321  1173.447     0.150
   149.160  1179.747     0.150
     0.937    28.086     0.150
     2.644    41.887     0.150
     2.644    72.986     0.150
     4.511    67.787     0.150
    30.173  2253.328     0.150
    30.184  2259.600     0.150
    30.191  2260.186     0.150
    31.051  2324.812     0.150
    31.054  2322.693     0.150
    31.068  2324.941     0.150
    43.888   480.387     0.150
    43.967   480.371     0.150
    44.381   486.438     0.150
    62.466   616.869     0.150
     0.088     6.674     0.150
    30.591  2270.778     0.150
    30.602  2269.716     0.150
    30.609  2270.362     0.150
    31.464  2333.112     0.150
    31.468  2334.817     0.150
    31.481  2336.153     0.150
    69.529   663.783     0.150
   146.346 10975.737     0.150
   146.360 10978.015     0.150
   146.362 10977.071     0.150
     0.537    12.719     0.150
     1.249    23.469     0.150
     1.821    48.820     0.150
     1.823    29.820     0.150
     2.764    41.320     0.150
     2.764    72.422     0.150
     4.550    67.922     0.150
     7.214   103.125     0.150
     7.214   103.406     0.150
    23.917    16.703     0.150
    29.998  2252.422     0.150
    30.009  2256.734     0.150
    30.016  2251.852     0.150
    30.885  2316.102     0.150
    30.889  2327.000     0.150
    30.903  2322.234     0.150
    31.210    16.602     0.150
    42.039   465.125     0.150
    42.883   471.922     0.150
    43.084   473.719     0.150
    43.312   474.523     0.150
    43.699   478.820     0.150
    44.103   482.523     0.150
    44.170   481.719     0.150
    44.649   487.391     0.150
    48.833   518.523     0.150
    51.144   536.922     0.150
    54.985   564.125     0.150
    56.948   577.125     0.150
   145.581 10941.508     0.150
   145.594 10951.914     0.150
   145.596 10945.531     0.150
     0.206    16.684     0.150
     0.276    10.633     0.150
     0.276    18.031     0.150
     0.276    10.742     0.150
     0.870    17.223     0.150
     5.414   136.832     0.150
     5.414    77.434     0.150
     6.839    99.633     0.150
     6.839   178.934     0.150
     6.829    97.832     0.150
     8.284   118.230     0.150
     8.284   118.332     0.150
     8.597   224.633     0.150
     9.490   229.281     0.150
     9.635   138.730     0.150
     9.635   249.230     0.150
    10.046   159.133     0.150
    10.046   258.332     0.150
    10.046   922.332     0.150
    10.997   272.832     0.150
    10.997   152.434     0.150
    11.164   151.832     0.150
    11.285   280.633     0.150
    11.285   166.031     0.150
    11.285   292.633     0.150
    11.769   185.332     0.150
    11.769   300.832     0.150
    12.322   177.230     0.150
    12.322   320.531     0.150
    12.590   320.281     0.150
    12.590   176.434     0.150
    13.410   203.934     0.150
    15.018   206.031     0.150
    15.018   365.031     0.150
    15.157   202.309     0.150
    15.157   357.855     0.150
    15.546   381.332     0.150
    17.642   239.934     0.150
    17.977   244.230     0.150
    17.977   244.293     0.150
    19.718    22.000     0.150
    20.322   268.730     0.150
    21.331   298.031     0.150
    21.331   536.133     0.150
    21.331   278.191     0.150
    22.150   307.434     0.150
    22.150   323.230     0.150
    22.150   581.633     0.150
    22.230   530.133     0.150
    23.518   555.730     0.150
    24.715    14.402     0.150
    24.715    21.402     0.150
    24.715   592.730     0.150
    24.715   627.332     0.150
    25.752    14.102     0.150
    25.849   325.031     0.150
    26.293   328.934     0.150
    27.902    15.199     0.150
    28.334   347.031     0.150
    28.741   351.332     0.150
    30.203  2259.926     0.150
    30.214  2256.324     0.150
    30.221  2256.844     0.150
    30.792    23.000     0.150
    31.079  2325.926     0.150
    31.083  2325.340     0.150
    31.096  2327.738     0.150
    32.557    20.699     0.150
    32.557    29.699     0.150
    32.557   701.434     0.150
    37.130   770.633     0.150
    37.229    18.602     0.150
    37.426   564.832     0.150
    39.062   439.809     0.150
    39.819    11.500     0.150
    40.343    14.898     0.150
    40.716   454.230     0.150
    41.921   461.492     0.150
    42.252   465.648     0.150
    42.461   468.434     0.150
    42.789   471.434     0.150
    42.789   471.172     0.150
    43.704   478.230     0.150
    43.849   479.133     0.150
    43.849   479.133     0.150
    43.849   479.492     0.150
    43.956   481.133     0.150
    45.398   491.832     0.150
    45.731   494.633     0.150
    45.989   496.434     0.150
    46.100   497.531     0.150
    46.380   499.633     0.150
    47.346   507.531     0.150
    47.436   507.531     0.150
    47.515   508.031     0.150
    48.145   513.633     0.150
    48.145   513.633     0.150
    48.393   515.332     0.150
    48.593   516.332     0.150
    48.829   518.531     0.150
    49.250   521.832     0.150
    49.250   521.832     0.150
    49.428   523.320     0.150
    49.565    21.203     0.150
    51.709   539.844     0.150
    51.709   539.832     0.150
    52.187   545.332     0.150
    52.447   545.934     0.150
    52.655   547.254     0.150
    52.655   547.230     0.150
    52.865   547.434     0.150
    53.342   552.133     0.150
    53.342   552.133     0.150
    53.342  1220.531     0.150
    53.342   552.121     0.150
    53.342   552.293     0.150
    55.720   569.391     0.150
    56.816   576.633     0.150
    59.006   592.332     0.150
    59.006   592.184     0.150
    60.625   600.172     0.150
    62.408   616.730     0.150
    62.418   616.531     0.150
    63.817   653.531     0.150
    64.339   629.832     0.150
    64.676   629.934     0.150
    64.676  1179.730     0.150
    65.449   635.934     0.150
    68.468   655.031     0.150
    68.846   659.703     0.150
    68.894   908.434     0.150
    68.894  1223.934     0.150
    69.119   655.133     0.150
    69.606   661.031     0.150
    69.841   662.531     0.150
    70.351   925.230     0.150
    70.940   669.832     0.150
    70.940   669.762     0.150
    71.154   671.332     0.150
    71.204   673.012     0.150
    71.752   674.133     0.150
    73.139   683.531     0.150
    73.723   686.832     0.150
    73.781   687.953     0.150
    73.781   686.832     0.150
    74.473   690.832     0.150
    74.583   693.133     0.150
    75.111   695.961     0.150
    75.312   697.031     0.150
    75.354   697.332     0.150
    75.542   698.730     0.150
    75.590   698.832     0.150
    75.687   698.730     0.150
    75.734   696.934     0.150
    75.807   700.449     0.150
    75.806   699.332     0.150
    76.175   702.031     0.150
    76.343   703.332     0.150
    76.385   703.730     0.150
    76.556   704.031     0.150
    76.594   703.934     0.150
    76.646   704.230     0.150
    76.646   704.133     0.150
    76.657   705.332     0.150
    76.657   703.531     0.150
    76.675   705.031     0.150
    76.675   705.031     0.150
    76.678   704.730     0.150
    76.681   705.891     0.150
    76.681   705.934     0.150
    76.715   704.832     0.150
    76.730   705.230     0.150
    77.113   707.832     0.150
    77.116   706.531     0.150
    77.171   706.934     0.150
    77.213   708.230     0.150
    77.213   708.230     0.150
    77.396   708.230     0.150
    77.658   709.934     0.150
    77.754   709.934     0.150
    77.857   711.633     0.150
    78.117   712.434     0.150
    78.626   715.230     0.150
    78.690   715.832     0.150
    78.721   715.730     0.150
    79.146   717.633     0.150
    79.284   717.676     0.150
    79.659   721.270     0.150
    79.816   722.031     0.150
    79.868   721.293     0.150
    81.329   729.434     0.150
    85.387   749.133     0.150
    86.031   753.730     0.150
    88.170   763.664     0.150
    88.170   763.531     0.150
    88.755  6692.621     0.150
    89.194   769.531     0.150
    92.660   785.133     0.150
    93.999   791.434     0.150
    95.418   797.934     0.150
   142.825  1164.559     0.150
   146.006 10967.551     0.150
   146.020 10964.004     0.150
   146.022 10969.035     0.150
   146.110  1173.031     0.150
   147.685  1178.113     0.150
   153.092  1185.703     0.150
     0.320    12.516     0.150
     0.473    16.617     0.150
     0.721    20.418     0.150
     0.672    20.316     0.150
     0.706    21.117     0.150
     0.842    25.918     0.150
     1.046    30.328     0.150
     1.119    24.266     0.150
     1.120    20.996     0.150
     1.120    20.969     0.150
     1.506    25.168     0.150
     1.506    25.219     0.150
     1.714    29.605     0.150
     2.045    30.945     0.150
     3.756   107.266     0.150
     4.306    65.516     0.150
     4.522    66.969     0.150
     4.699    71.926     0.150
     4.973    74.766     0.150
     4.973   139.969     0.150
     5.431    80.668     0.150
     5.547    82.539     0.150
     5.715    86.238     0.150
     6.174    92.348     0.150
     6.393    95.766     0.150
     6.393   172.766     0.150
     7.477  2230.867     0.150
     7.477  2640.867     0.150
     7.405   106.168     0.150
     7.405   105.668     0.150
     7.413  2210.867     0.150
     8.057   112.688     0.150
     8.157   119.309     0.150
     8.194   119.867     0.150
     8.194   209.168     0.150
     8.194   119.867     0.150
     8.194   215.969     0.150
     8.269   117.027     0.150
     8.269   120.066     0.150
     8.269   120.426     0.150
     8.214   116.969     0.150
     8.310   119.508     0.150
     8.522   122.117     0.150
     8.522   120.969     0.150
     8.522   126.668     0.150
     8.522   130.219     0.150
     8.824   129.316     0.150
     8.976   130.836     0.150
     8.929   134.469     0.150
     8.929   242.266     0.150
     9.067   132.469     0.150
     9.164   133.566     0.150
     9.164   237.367     0.150
     9.164   129.848     0.150
     9.164   130.867     0.150
     9.241   131.566     0.150
     9.394   135.445     0.150
     9.476   137.816     0.150
     9.533   135.539     0.150
     9.703   134.617     0.150
     9.703   243.418     0.150
     9.705   136.117     0.150
     9.705   140.168     0.150
     9.705   135.117     0.150
     9.705   142.918     0.150
     9.651   138.117     0.150
     9.651   246.043     0.150
     9.651   938.164     0.150
     9.828   142.727     0.150
     9.868   141.887     0.150
    10.505   151.266     0.150
    10.505   156.066     0.150
    10.581   154.129     0.150
    10.931   158.797     0.150
    10.877   156.367     0.150
    10.877   280.367     0.150
    10.891   157.566     0.150
    10.891   273.969     0.150
    10.891   160.469     0.150
    10.891   288.070     0.150
    10.961   153.105     0.150
    10.961   155.469     0.150
    10.961   159.566     0.150
    10.961   163.918     0.150
    11.976   172.617     0.150
    11.976   722.344     0.150
    11.959   169.277     0.150
    11.976   169.387     0.150
    11.976   169.367     0.150
    12.089   173.266     0.150
    12.089   180.367     0.150
    12.089   307.969     0.150
    12.578   177.367     0.150
    12.578   177.066     0.150
    12.542   178.566     0.150
    12.542   185.766     0.150
    12.542   321.070     0.150
    12.542   334.469     0.150
    12.746   179.566     0.150
    12.746   187.469     0.150
    12.823   180.008     0.150
    12.823   179.266     0.150
    12.823   186.891     0.150
    12.823   186.891     0.150
    12.823   186.891     0.150
    12.823   333.914     0.150
    12.823   333.914     0.150
    12.823   333.914     0.150
    12.823   179.969     0.150
    12.823   183.688     0.150
    12.823   188.578     0.150
    12.894   181.578     0.150
    12.894   180.969     0.150
    12.894   181.066     0.150
    12.894   186.727     0.150
    12.933   181.809     0.150
    12.933   182.168     0.150
    12.933   182.617     0.150
    12.933   327.445     0.150
    12.933   186.566     0.150
    13.414   190.367     0.150
    13.792   194.828     0.150
    14.672   205.457     0.150
    14.739   205.867     0.150
    14.739   208.566     0.150
    14.739   365.969     0.150
    14.808   205.469     0.150
    14.808   205.766     0.150
    14.808   206.559     0.150
    14.808   205.668     0.150
    14.808   370.891     0.150
    14.808   516.883     0.150
    14.808   727.133     0.150
    15.215   211.695     0.150
    15.215   216.266     0.150
    15.215   212.266     0.150
    15.215   212.266     0.150
    15.215   372.164     0.150
    15.215   212.969     0.150
    15.215   210.188     0.150
    15.215   214.727     0.150
    15.556   213.086     0.150
    15.556   219.266     0.150
    15.556   208.316     0.150
    15.556   376.039     0.150
    15.556   213.469     0.150
    15.840   224.367     0.150
    15.840   399.367     0.150
    16.747   230.008     0.150
    16.747   232.566     0.150
    16.747   229.969     0.150
    17.766   244.137     0.150
    17.766   246.469     0.150
    17.766   243.387     0.150
    17.766   442.836     0.150
    17.766   244.168     0.150
    17.766   244.168     0.150
    17.766   244.969     0.150
    17.766   244.836     0.150
    17.766   245.879     0.150
    18.234   248.828     0.150
    18.850   256.168     0.150
    18.850   264.070     0.150
    18.850   271.367     0.150
    18.850   466.664     0.150
    18.850   478.570     0.150
    18.990   257.867     0.150
    18.990   260.469     0.150
    18.990   263.320     0.150
    18.990   269.414     0.150
    19.358   261.906     0.150
    19.358   262.867     0.150
    19.358   262.766     0.150
    19.358   480.195     0.150
    19.358   736.539     0.150
    19.358   262.617     0.150
    19.514   263.969     0.150
    20.704   276.789     0.150
    20.704   276.312     0.150
    20.704   505.664     0.150
    20.704   525.359     0.150
    20.704   965.562     0.150
    20.704  2318.312     0.150
    20.704   280.070     0.150
    20.704   297.070     0.150
    20.704   305.867     0.150
    20.704   510.070     0.150
    20.704   530.070     0.150
    20.704   530.164     0.150
    20.704   965.070     0.150
    20.704   277.086     0.150
    20.704   278.328     0.150
    21.185   280.820     0.150
    21.185   514.594     0.150
    21.185   967.219     0.150
    21.185  2316.094     0.150
    21.185   281.266     0.150
    21.264   288.867     0.150
    21.264   307.266     0.150
    21.264   321.664     0.150
    21.264   531.469     0.150
    22.500   298.164     0.150
    22.682   298.266     0.150
    22.682    15.102     0.150
    22.682   539.570     0.150
    22.682   553.070     0.150
    22.682   580.664     0.150
    23.021   304.766     0.150
    23.186   305.469     0.150
    23.877   309.266     0.150
    23.877    10.203     0.150
    23.877    14.305     0.150
    23.877   344.867     0.150
    23.877   561.367     0.150
    23.877   616.164     0.150
    23.975   309.344     0.150
    23.975   312.164     0.150
    23.975   309.367     0.150
    23.975   309.664     0.150
    24.333   314.766     0.150
    24.333     9.305     0.150
    24.333    13.500     0.150
    24.333   542.664     0.150
    24.333   575.469     0.150
    24.333   589.266     0.150
    24.333   980.070     0.150
    24.408   313.820     0.150
    24.408   314.766     0.150
    24.408   317.719     0.150
    24.408   317.719     0.150
    24.408   317.719     0.150
    24.408   579.742     0.150
    24.408   579.742     0.150
    24.408   579.742     0.150
    24.710   316.367     0.150
    24.977   316.727     0.150
    24.977   318.570     0.150
    24.954   319.195     0.150
    24.954   322.109     0.150
    24.954   322.109     0.150
    24.954   590.109     0.150
    24.954   590.109     0.150
    24.954   319.164     0.150
    24.954   319.164     0.150
    24.954   318.688     0.150
    25.398   323.109     0.150
    25.398   536.828     0.150
    25.398   589.117     0.150
    25.398   751.289     0.150
    25.398   979.977     0.150
    25.639   327.867     0.150
    25.762   326.266     0.150
    26.127   330.469     0.150
    26.127   605.867     0.150
    26.205   330.070     0.150
    26.341   333.570     0.150
    26.607   334.789     0.150
    26.655   335.078     0.150
    26.930   337.664     0.150
    26.930   354.969     0.150
    27.160   340.266     0.150
    27.160   619.266     0.150
    27.439   346.969     0.150
    27.439   545.766     0.150
    28.586   351.820     0.150
    28.586   345.266     0.150
    28.586   416.266     0.150
    28.586   642.164     0.150
    28.586   722.766     0.150
    28.712   352.164     0.150
    28.890   354.820     0.150
    28.917   356.266     0.150
    29.103   360.164     0.150
    29.180   358.219     0.150
    29.180   361.969     0.150
    29.180   358.266     0.150
    29.180   360.875     0.150
    29.573   360.648     0.150
    29.732   364.164     0.150
    29.747   364.117     0.150
    29.747   364.164     0.150
    29.747   366.188     0.150
    29.990   364.469     0.150
    29.990    12.000     0.150
    29.990   427.969     0.150
    29.990   556.070     0.150
    29.990   662.969     0.150
    30.789   373.867     0.150
    30.828   373.227     0.150
    30.828   374.266     0.150
    31.077  2347.000     0.150
    31.088  2350.797     0.150
    31.095  2345.617     0.150
    31.116   375.164     0.150
    31.297   376.984     0.150
    31.297   380.867     0.150
    31.297   382.414     0.150
    31.297   382.805     0.150
    31.306   376.867     0.150
    31.706   379.664     0.150
    31.706   560.266     0.150
    31.706   777.469     0.150
    31.706  1014.969     0.150
    31.947  2411.383     0.150
    31.950  2411.000     0.150
    31.964  2411.414     0.150
    33.254   397.664     0.150
    33.254   397.102     0.150
    33.254   716.930     0.150
    33.593   400.078     0.150
    33.593   721.031     0.150
    33.593   721.031     0.150
    33.768   401.359     0.150
    33.768   721.812     0.150
    33.768   402.141     0.150
    33.967   404.164     0.150
    33.967   402.445     0.150
    33.967   726.062     0.150
    35.330   415.664     0.150
    35.330   413.836     0.150
    35.330   744.297     0.150
    35.589   412.719     0.150
    35.657   419.602     0.150
    35.657   754.625     0.150
    35.790   415.164     0.150
    35.790   421.070     0.150
    35.790   420.969     0.150
    35.790   422.477     0.150
    35.813   419.203     0.150
    35.813   752.242     0.150
    35.813   419.836     0.150
    35.923   417.867     0.150
    35.923   753.164     0.150
    35.923   417.766     0.150
    35.923   417.859     0.150
    35.923   569.328     0.150
    35.923   792.477     0.150
    36.437   425.070     0.150
    36.437   762.414     0.150
    36.443   423.664     0.150
    36.443    15.305     0.150
    36.443   508.969     0.150
    36.443   567.070     0.150
    36.443   758.164     0.150
    36.443   798.969     0.150
    36.443  1038.469     0.150
    36.570   425.977     0.150
    36.570   766.703     0.150
    36.570   421.805     0.150
    36.570   571.438     0.150
    36.589   422.164     0.150
    36.589    10.805     0.150
    36.589   506.766     0.150
    36.589   568.367     0.150
    36.589   763.164     0.150
    36.647   423.414     0.150
    36.647   426.414     0.150
    36.647   765.922     0.150
    36.647   423.469     0.150
    37.071   430.070     0.150
    37.071   428.758     0.150
    37.071   771.641     0.150
    37.070   431.000     0.150
    37.070   777.047     0.150
    37.170   430.742     0.150
    37.170   772.359     0.150
    37.175   427.094     0.150
    37.175   432.078     0.150
    37.175   771.180     0.150
    37.287   431.922     0.150
    37.287   777.555     0.150
    37.454   434.914     0.150
    37.454   783.359     0.150
    37.507   433.484     0.150
    37.507   774.414     0.150
    37.660   431.570     0.150
    37.773   436.555     0.150
    37.773   786.148     0.150
    37.785   435.031     0.150
    37.785   782.320     0.150
    37.883   438.094     0.150
    37.883   787.734     0.150
    37.993   437.797     0.150
    37.993   786.398     0.150
    38.048   439.508     0.150
    38.048   788.867     0.150
    38.053   438.539     0.150
    38.053   787.352     0.150
    38.067   435.258     0.150
    38.067   440.125     0.150
    38.067   790.531     0.150
    38.091   440.242     0.150
    38.091   787.539     0.150
    38.194   439.227     0.150
    38.194   787.211     0.150
    38.214   436.211     0.150
    38.214   437.164     0.150
    38.303   444.867     0.150
    38.335   439.664     0.150
    38.335   789.914     0.150
    38.338   436.773     0.150
    38.338   439.953     0.150
    38.338   789.438     0.150
    38.395   441.547     0.150
    38.395   794.602     0.150
    38.520   438.047     0.150
    38.520   441.867     0.150
    38.520   448.125     0.150
    38.548   442.000     0.150
    38.548   793.984     0.150
    38.567   439.078     0.150
    38.567   443.711     0.150
    38.567   797.273     0.150
    38.577   443.953     0.150
    38.577   794.617     0.150
    38.609   439.008     0.150
    38.609   438.719     0.150
    38.609   439.242     0.150
    38.609   571.789     0.150
    38.609   796.242     0.150
    38.609  2247.164     0.150
    38.665   440.469     0.150
    38.665   443.922     0.150
    38.665   793.453     0.150
    38.685   444.797     0.150
    38.685   799.781     0.150
    38.712   440.211     0.150
    38.712   444.164     0.150
    38.712   441.398     0.150
    38.712   794.969     0.150
    38.773   445.195     0.150
    38.773   796.070     0.150
    38.832   446.070     0.150
    38.832   801.164     0.150
    38.928   442.867     0.150
    38.928   801.469     0.150
    39.007   446.922     0.150
    39.007   804.383     0.150
    39.018   442.617     0.150
    39.018   447.797     0.150
    39.018   801.062     0.150
    39.026   446.266     0.150
    39.026   798.305     0.150
    39.076   447.352     0.150
    39.076   800.516     0.150
    39.085   446.289     0.150
    39.085   797.422     0.150
    39.143   447.500     0.150
    39.143   805.320     0.150
    39.246   449.742     0.150
    39.246   808.078     0.150
    39.276   447.469     0.150
    39.276   447.609     0.150
    39.276   804.031     0.150
    39.260   444.648     0.150
    39.260   449.742     0.150
    39.260   808.398     0.150
    39.260   808.398     0.150
    39.321   448.789     0.150
    39.321   806.391     0.150
    39.342   451.031     0.150
    39.342   811.086     0.150
    39.467   449.820     0.150
    39.467   804.492     0.150
    39.573   452.578     0.150
    39.573   813.312     0.150
    39.585   447.820     0.150
    39.585   453.141     0.150
    39.585   811.781     0.150
    39.640   451.781     0.150
    39.640   811.266     0.150
    39.646   448.266     0.150
    39.646   547.164     0.150
    39.692   448.008     0.150
    39.692   452.992     0.150
    39.692   812.438     0.150
    39.704   453.422     0.150
    39.704   813.711     0.150
    39.745   452.391     0.150
    39.745   807.547     0.150
    39.773   448.484     0.150
    39.773   452.039     0.150
    39.773   812.164     0.150
    39.783   454.609     0.150
    39.783   816.586     0.150
    39.783   816.586     0.150
    39.820   449.625     0.150
    39.820   811.977     0.150
    39.820   449.570     0.150
    39.820   811.969     0.150
    39.981   451.094     0.150
    39.981   456.047     0.150
    39.981   820.531     0.150
    40.091   454.555     0.150
    40.091   815.984     0.150
    40.108   456.242     0.150
    40.108   821.641     0.150
    40.108   821.641     0.150
    40.123   457.492     0.150
    40.123   822.906     0.150
    40.172   455.883     0.150
    40.172   815.422     0.150
    40.202   457.469     0.150
    40.202   822.609     0.150
    40.240   453.484     0.150
    40.296   457.031     0.150
    40.296   820.062     0.150
    40.300   457.250     0.150
    40.300   819.930     0.150
    40.324   458.086     0.150
    40.324   821.516     0.150
    40.329   459.328     0.150
    40.329   823.844     0.150
    40.329   823.844     0.150
    40.369   457.789     0.150
    40.369   819.828     0.150
    40.499   460.344     0.150
    40.499   827.898     0.150
    40.519   459.242     0.150
    40.519   821.289     0.150
    40.571   460.734     0.150
    40.571   828.945     0.150
    40.571   828.945     0.150
    40.752   460.391     0.150
    40.752   830.156     0.150
    40.753   457.039     0.150
    40.754   462.398     0.150
    40.754   830.648     0.150
    40.756   462.664     0.150
    40.756   832.914     0.150
    40.756   832.914     0.150
    40.741   460.102     0.150
    40.741   824.789     0.150
    40.748   460.336     0.150
    40.748   823.906     0.150
    40.820   462.086     0.150
    40.820   826.617     0.150
    40.820   826.617     0.150
    40.850   461.773     0.150
    40.850   825.328     0.150
    40.887   458.344     0.150
    40.887   462.070     0.150
    40.914   461.977     0.150
    40.914   829.172     0.150
    40.939   462.883     0.150
    40.939   833.188     0.150
    41.148   465.219     0.150
    41.148   838.391     0.150
    41.148   838.391     0.150
    41.142   463.281     0.150
    41.142   827.992     0.150
    41.175   465.914     0.150
    41.175   837.617     0.150
    41.171   464.484     0.150
    41.171   832.000     0.150
    41.189   465.664     0.150
    41.189   836.281     0.150
    41.189   836.281     0.150
    41.326   466.453     0.150
    41.326   838.141     0.150
    41.359   466.461     0.150
    41.359   838.180     0.150
    41.389   462.070     0.150
    41.389   466.367     0.150
    41.389   466.664     0.150
    41.389   838.336     0.150
    41.419   467.953     0.150
    41.419   839.797     0.150
    41.419   839.797     0.150
    41.438   468.047     0.150
    41.438   842.766     0.150
    41.438   842.766     0.150
    41.456   466.500     0.150
    41.456   835.023     0.150
    41.468   468.016     0.150
    41.468   839.383     0.150
    41.468   839.383     0.150
    41.487   463.508     0.150
    41.487   464.164     0.150
    41.487   464.180     0.150
    41.515   468.539     0.150
    41.515   839.867     0.150
    41.515   839.867     0.150
    41.565   469.617     0.150
    41.565   843.367     0.150
    41.565   843.367     0.150
    41.565   467.055     0.150
    41.565   836.773     0.150
    41.594   465.609     0.150
    41.618   467.094     0.150
    41.618   836.727     0.150
    41.632   469.844     0.150
    41.632   842.219     0.150
    41.632   842.219     0.150
    41.652   463.258     0.150
    41.686   468.742     0.150
    41.686   838.562     0.150
    41.691   464.734     0.150
    41.691   464.766     0.150
    41.691   464.438     0.150
    41.691   464.992     0.150
    41.691   581.891     0.150
    41.691   808.164     0.150
    41.691   464.469     0.150
    41.764   469.602     0.150
    41.764   839.953     0.150
    41.743   470.797     0.150
    41.780   469.062     0.150
    41.780   841.969     0.150
    41.780   841.969     0.150
    41.799   469.555     0.150
    41.799   842.289     0.150
    41.893   466.375     0.150
    41.893   466.367     0.150
    41.893   466.656     0.150
    41.893   809.156     0.150
    42.015   473.258     0.150
    42.015   847.883     0.150
    42.015   847.883     0.150
    42.034   471.844     0.150
    42.034   847.922     0.150
    42.034   847.922     0.150
    42.037   472.188     0.150
    42.037   846.531     0.150
    42.037   846.531     0.150
    42.071   471.867     0.150
    42.071   471.875     0.150
    42.071   849.641     0.150
    42.050   470.859     0.150
    42.050   843.523     0.150
    42.028   467.367     0.150
    42.028   844.391     0.150
    42.028   467.367     0.150
    42.028   844.367     0.150
    42.163   472.320     0.150
    42.163   852.586     0.150
    42.193   470.867     0.150
    42.193   470.734     0.150
    42.193   475.773     0.150
    42.187   472.461     0.150
    42.187   845.844     0.150
    42.282   474.953     0.150
    42.282   852.992     0.150
    42.317   470.148     0.150
    42.313   474.070     0.150
    42.313   848.070     0.150
    42.389   475.969     0.150
    42.389   856.117     0.150
    42.421   475.125     0.150
    42.421   854.633     0.150
    42.421   854.633     0.150
    42.398   473.164     0.150
    42.398   472.719     0.150
    42.453   474.469     0.150
    42.453   475.320     0.150
    42.453   854.789     0.150
    42.439   471.430     0.150
    42.471   474.742     0.150
    42.471   850.359     0.150
    42.511   476.531     0.150
    42.511   856.805     0.150
    42.512   477.469     0.150
    42.512   856.805     0.150
    42.565   476.016     0.150
    42.565   853.234     0.150
    42.624   476.961     0.150
    42.624   855.023     0.150
    42.624   855.023     0.150
    42.721   476.906     0.150
    42.721   854.625     0.150
    42.750   481.227     0.150
    42.750   476.070     0.150
    42.750   480.836     0.150
    42.743   472.727     0.150
    42.743   813.133     0.150
    42.743   855.133     0.150
    42.743  1071.109     0.150
    42.743   477.102     0.150
    42.743   855.992     0.150
    42.743   475.570     0.150
    42.743   473.141     0.150
    42.743   477.758     0.150
    42.763   478.375     0.150
    42.763   856.625     0.150
    42.857   479.125     0.150
    42.857   858.711     0.150
    42.916   474.797     0.150
    42.916   479.391     0.150
    42.916   860.141     0.150
    42.914   478.953     0.150
    42.914   856.547     0.150
    42.963   479.070     0.150
    42.963   859.062     0.150
    42.971   478.914     0.150
    42.971   859.062     0.150
    43.010   476.969     0.150
    43.010   481.836     0.150
    43.010   482.727     0.150
    42.958   474.945     0.150
    42.958   476.461     0.150
    42.958   476.461     0.150
    42.958   863.570     0.150
    42.958   863.570     0.150
    42.958   475.766     0.150
    42.958   475.766     0.150
    42.958   585.164     0.150
    42.958   475.156     0.150
    43.068   479.594     0.150
    43.068   865.641     0.150
    43.076   480.008     0.150
    43.076   860.688     0.150
    43.037   475.789     0.150
    43.037   585.148     0.150
    43.037   813.594     0.150
    43.037   860.242     0.150
    43.037  2329.039     0.150
    43.081   475.367     0.150
    43.155   480.297     0.150
    43.155   862.977     0.150
    43.186   476.914     0.150
    43.187   476.875     0.150
    43.187   481.305     0.150
    43.187   863.844     0.150
    43.294   481.422     0.150
    43.294   861.312     0.150
    43.312   482.438     0.150
    43.312   864.234     0.150
    43.311   481.891     0.150
    43.311   861.398     0.150
    43.380   483.195     0.150
    43.380   867.492     0.150
    43.380   867.492     0.150
    43.451   482.750     0.150
    43.451   867.547     0.150
    43.493   484.070     0.150
    43.493   868.539     0.150
    43.493   868.539     0.150
    43.581   481.016     0.150
    43.581   588.445     0.150
    43.581   813.867     0.150
    43.581   868.742     0.150
    43.581  1077.141     0.150
    43.581  2390.016     0.150
    43.585   484.133     0.150
    43.585   866.727     0.150
    43.633   484.461     0.150
    43.633   866.656     0.150
    43.656   485.758     0.150
    43.656   870.977     0.150
    43.732   481.898     0.150
    43.732   482.367     0.150
    43.732   482.039     0.150
    43.715   485.344     0.150
    43.715   868.695     0.150
    43.718   485.477     0.150
    43.718   871.125     0.150
    43.788   486.000     0.150
    43.788   869.484     0.150
    43.804   485.750     0.150
    43.804   870.562     0.150
    43.939   484.266     0.150
    43.939   487.023     0.150
    43.939   874.156     0.150
    43.964   487.758     0.150
    43.964   871.562     0.150
    43.995   487.547     0.150
    43.995   872.672     0.150
    44.056   488.312     0.150
    44.056   874.945     0.150
    44.064   488.711     0.150
    44.064   878.383     0.150
    44.064   878.383     0.150
    44.153   484.797     0.150
    44.153   485.367     0.150
    44.153   489.383     0.150
    44.153   878.109     0.150
    44.153   484.766     0.150
    44.153   484.766     0.150
    44.153   484.570     0.150
    44.168   490.031     0.150
    44.168   879.125     0.150
    44.157   484.859     0.150
    44.157   488.477     0.150
    44.284   490.438     0.150
    44.284   881.195     0.150
    44.287   490.695     0.150
    44.287   881.180     0.150
    44.308   491.258     0.150
    44.308   880.422     0.150
    44.425   491.102     0.150
    44.425   879.750     0.150
    44.458   491.273     0.150
    44.458   882.453     0.150
    44.455   490.578     0.150
    44.455   878.000     0.150
    44.560   492.188     0.150
    44.560   883.203     0.150
    44.574   492.570     0.150
    44.574   885.070     0.150
    44.574   486.867     0.150
    44.574   487.516     0.150
    44.574  2384.266     0.150
    44.587   492.188     0.150
    44.587   881.148     0.150
    44.707   493.734     0.150
    44.707   887.172     0.150
    44.755   494.734     0.150
    44.755   888.641     0.150
    44.820   495.250     0.150
    44.820   886.922     0.150
    44.504   487.578     0.150
    44.504   487.570     0.150
    44.865   495.328     0.150
    44.865   886.883     0.150
    44.835   490.344     0.150
    44.835   490.266     0.150
    44.944   495.117     0.150
    44.944   888.234     0.150
    45.020   495.852     0.150
    45.020   890.867     0.150
    45.025   496.195     0.150
    45.025   894.273     0.150
    45.025   894.273     0.150
    45.098   494.164     0.150
    45.098   493.586     0.150
    45.065   492.156     0.150
    45.065   496.344     0.150
    45.065   893.336     0.150
    45.096   492.195     0.150
    45.096   492.164     0.150
    45.173   496.773     0.150
    45.173   889.609     0.150
    45.173   889.609     0.150
    45.240   496.586     0.150
    45.240   891.117     0.150
    45.240   891.117     0.150
    45.241   492.398     0.150
    45.250   498.922     0.150
    45.250   896.805     0.150
    45.205   493.414     0.150
    45.205   493.367     0.150
    45.378   498.555     0.150
    45.378   893.320     0.150
    45.382   499.195     0.150
    45.382   897.242     0.150
    45.435   499.383     0.150
    45.435   895.508     0.150
    45.474   499.391     0.150
    45.474   900.242     0.150
    45.534   496.367     0.150
    45.486   495.547     0.150
    45.486   495.469     0.150
    45.505   495.469     0.150
    45.594   500.109     0.150
    45.594   895.070     0.150
    45.547   496.195     0.150
    45.547   496.164     0.150
    45.553   497.570     0.150
    45.600   500.547     0.150
    45.600   900.641     0.150
    45.615   503.227     0.150
    45.659   501.641     0.150
    45.659   899.898     0.150
    45.659   899.898     0.150
    45.665   500.867     0.150
    45.671   501.891     0.150
    45.671   901.172     0.150
    45.765   499.266     0.150
    45.732   498.664     0.150
    45.732   502.227     0.150
    45.732   903.469     0.150
    45.772   503.961     0.150
    45.772    12.844     0.150
    45.931   503.055     0.150
    45.931   901.430     0.150
    46.028   502.852     0.150
    46.028   903.758     0.150
    46.028   903.758     0.150
    46.075   505.242     0.150
    46.075   908.711     0.150
    46.075   502.836     0.150
    46.075   906.695     0.150
    46.075   906.695     0.150
    46.235   501.391     0.150
    46.235   502.469     0.150
    46.235   501.938     0.150
    46.199   506.062     0.150
    46.199   912.953     0.150
    46.186   500.820     0.150
    46.186   500.766     0.150
    46.283   505.664     0.150
    46.283   908.062     0.150
    46.331   502.969     0.150
    46.379   507.680     0.150
    46.379   909.344     0.150
    46.379   909.344     0.150
    46.380   507.094     0.150
    46.380   908.734     0.150
    46.452   507.617     0.150
    46.452   912.711     0.150
    46.425   502.570     0.150
    46.425   908.195     0.150
    46.425   502.469     0.150
    46.425   908.164     0.150
    46.511   508.781     0.150
    46.511   917.133     0.150
    46.451   503.195     0.150
    46.451   503.164     0.150
    46.451   503.164     0.150
    46.535   505.367     0.150
    46.542   503.695     0.150
    46.542   503.664     0.150
    46.593   509.367     0.150
    46.593   914.938     0.150
    46.659   509.680     0.150
    46.659   915.867     0.150
    46.659   915.867     0.150
    46.661   509.000     0.150
    46.661   916.062     0.150
    46.661   916.062     0.150
    46.620   504.297     0.150
    46.620   911.258     0.150
    46.620   504.266     0.150
    46.620   911.164     0.150
    46.750   510.320     0.150
    46.750   915.906     0.150
    46.750   915.906     0.150
    46.805   509.141     0.150
    46.805   505.969     0.150
    46.805   505.391     0.150
    46.833   507.578     0.150
    46.833   507.070     0.150
    46.833   504.641     0.150
    46.861   511.094     0.150
    46.861   919.688     0.150
    46.968   512.438     0.150
    46.968   922.203     0.150
    46.980   511.805     0.150
    46.980   917.750     0.150
    47.000   511.414     0.150
    47.000   918.805     0.150
    47.000   506.898     0.150
    47.022   513.023     0.150
    47.022   923.234     0.150
    47.012   512.336     0.150
    47.012   919.688     0.150
    47.051   512.797     0.150
    47.051   922.055     0.150
    47.154   512.594     0.150
    47.154   917.992     0.150
    47.178   514.062     0.150
    47.178   926.312     0.150
    47.178   926.312     0.150
    47.216   509.266     0.150
    47.216   601.289     0.150
    47.216   831.320     0.150
    47.216   920.164     0.150
    47.216  2320.594     0.150
    47.216  2381.695     0.150
    47.216  2776.070     0.150
    47.267   509.195     0.150
    47.267   513.047     0.150
    47.267   513.047     0.150
    47.267   513.047     0.150
    47.267   924.055     0.150
    47.267   924.055     0.150
    47.267   924.055     0.150
    47.267   509.164     0.150
    47.267   509.164     0.150
    47.267   509.656     0.150
    47.267   836.109     0.150
    47.267   509.484     0.150
    47.334   510.938     0.150
    47.378   515.406     0.150
    47.378   923.820     0.150
    47.440   516.836     0.150
    47.440    12.250     0.150
    47.498   512.109     0.150
    47.612   516.719     0.150
    47.612   926.430     0.150
    47.655   518.234     0.150
    47.655   931.883     0.150
    47.732   514.664     0.150
    47.697   512.438     0.150
    47.697   926.320     0.150
    47.697   512.367     0.150
    47.697   926.266     0.150
    47.751   518.484     0.150
    47.751   930.945     0.150
    47.848   518.883     0.150
    47.848   931.586     0.150
    47.854   519.070     0.150
    47.854   931.695     0.150
    47.899   519.000     0.150
    47.899   929.602     0.150
    47.963   519.969     0.150
    47.963   936.211     0.150
    47.933   514.688     0.150
    47.933   930.141     0.150
    47.933   514.664     0.150
    47.933   930.070     0.150
    48.055   515.984     0.150
    48.055   516.969     0.150
    48.055   516.641     0.150
    48.063   520.305     0.150
    48.063   932.875     0.150
    48.035   515.641     0.150
    48.042   516.289     0.150
    48.095   516.188     0.150
    48.241   523.273     0.150
    48.241   521.367     0.150
    48.241   522.734     0.150
    48.308   522.273     0.150
    48.308   938.586     0.150
    48.344   522.594     0.150
    48.344   940.875     0.150
    48.355   518.305     0.150
    48.355   517.367     0.150
    48.355   517.805     0.150
    48.355   521.922     0.150
    48.355   521.922     0.150
    48.355   521.922     0.150
    48.355   946.906     0.150
    48.355   946.906     0.150
    48.355   946.906     0.150
    48.355   517.367     0.150
    48.355   517.367     0.150
    48.355   518.273     0.150
    48.355   839.875     0.150
    48.355   518.188     0.150
    48.410   523.508     0.150
    48.410   942.383     0.150
    48.472   523.492     0.150
    48.472   938.070     0.150
    48.591   522.766     0.150
    48.526   523.539     0.150
    48.526   940.016     0.150
    48.606   521.305     0.150
    48.606   526.266     0.150
    48.606   526.805     0.150
    48.548   524.344     0.150
    48.548   939.070     0.150
    48.512   521.188     0.150
    48.677   525.281     0.150
    48.677   942.109     0.150
    48.702   526.188     0.150
    48.702   947.156     0.150
    48.676   524.164     0.150
    48.676    15.102     0.150
    48.676   646.070     0.150
    48.676   951.164     0.150
    48.754   526.406     0.150
    48.754   945.812     0.150
    48.826   521.938     0.150
    48.884   527.297     0.150
    48.884   945.078     0.150
    48.914   527.516     0.150
    48.914   948.531     0.150
    49.030   526.969     0.150
    49.030   527.797     0.150
    49.030   950.531     0.150
    49.069   528.461     0.150
    49.069   951.344     0.150
    49.064   529.023     0.150
    49.105   524.844     0.150
    49.158   529.656     0.150
    49.158   948.711     0.150
    49.234   527.570     0.150
    49.227   526.664     0.150
    49.227   530.438     0.150
    49.227   531.328     0.150
    49.216   523.516     0.150
    49.216   945.914     0.150
    49.216  1113.117     0.150
    49.216   528.867     0.150
    49.216   945.734     0.150
    49.216   527.648     0.150
    49.242   529.812     0.150
    49.242   954.211     0.150
    49.285   529.664     0.150
    49.285   950.117     0.150
    49.352   529.320     0.150
    49.352   950.055     0.150
    49.411   531.312     0.150
    49.411   956.836     0.150
    49.551   531.797     0.150
    49.551   953.852     0.150
    49.600   532.938     0.150
    49.600   957.875     0.150
    49.603   528.469     0.150
    49.744   531.000     0.150
    49.816   530.664     0.150
    49.849   530.664     0.150
    49.849   530.539     0.150
    49.846   535.016     0.150
    49.846   960.500     0.150
    50.066   536.758     0.150
    50.066   965.828     0.150
    50.191   537.438     0.150
    50.191   968.211     0.150
    50.271   538.180     0.150
    50.271   970.500     0.150
    50.266   534.070     0.150
    50.564   540.070     0.150
    50.564   973.406     0.150
    50.525   534.984     0.150
    50.592   540.688     0.150
    50.592   972.234     0.150
    50.557   536.344     0.150
    50.813   535.695     0.150
    50.813   535.664     0.150
    50.813   536.250     0.150
    50.870   542.734     0.150
    50.870   978.219     0.150
    50.894   541.648     0.150
    50.894   972.594     0.150
    50.910   538.734     0.150
    51.045   542.875     0.150
    51.045   977.250     0.150
    51.062   541.969     0.150
    51.062   543.328     0.150
    51.062   981.406     0.150
    51.062   543.508     0.150
    51.137   543.203     0.150
    51.137   980.562     0.150
    51.137   980.562     0.150
    51.224   544.531     0.150
    51.224   981.688     0.150
    51.352   547.625     0.150
    51.352   539.766     0.150
    51.352   541.570     0.150
    51.352   547.039     0.150
    51.280   540.469     0.150
    51.280   655.766     0.150
    51.280   980.867     0.150
    51.280  1293.570     0.150
    51.291   541.500     0.150
    51.291   541.469     0.150
    51.531   546.680     0.150
    51.531   986.500     0.150
    51.575   542.148     0.150
    51.575   543.070     0.150
    51.575   981.859     0.150
    51.575   546.367     0.150
    51.575   546.367     0.150
    51.575   546.367     0.150
    51.575   984.352     0.150
    51.575   984.352     0.150
    51.575   984.352     0.150
    51.575   542.164     0.150
    51.691   549.297     0.150
    51.722   542.695     0.150
    51.788   548.805     0.150
    51.788   990.016     0.150
    51.875   549.547     0.150
    51.875   992.430     0.150
    51.875   992.430     0.150
    51.919   548.164     0.150
    51.919   549.922     0.150
    51.919   993.445     0.150
    51.941   548.469     0.150
    51.910   545.164     0.150
    51.986   550.586     0.150
    51.986   994.609     0.150
    51.950   545.445     0.150
    51.950   991.141     0.150
    52.057   552.523     0.150
    52.057   549.570     0.150
    52.057   548.969     0.150
    52.057   989.289     0.150
    52.057   548.867     0.150
    52.057   551.234     0.150
    52.144   551.711     0.150
    52.144   994.531     0.150
    52.144   994.531     0.150
    52.157   548.164     0.150
    52.157   547.734     0.150
    52.164   550.312     0.150
    52.164   989.227     0.150
    52.181   552.438     0.150
    52.367   549.867     0.150
    52.367   555.438     0.150
    52.276   547.875     0.150
    52.302   553.008     0.150
    52.379   553.586     0.150
    52.493   548.555     0.150
    52.493   548.836     0.150
    52.565   550.367     0.150
    52.565   549.891     0.150
    52.588   551.266     0.150
    52.588   553.438     0.150
    52.588   555.125     0.150
    52.588   555.359     0.150
    52.588   558.570     0.150
    52.711   555.719     0.150
    52.711  1004.398     0.150
    52.717   551.711     0.150
    52.748   558.219     0.150
    53.094   558.445     0.150
    53.161   559.781     0.150
    53.161  1009.789     0.150
    53.214   559.555     0.150
    53.214  1011.562     0.150
    53.195   554.859     0.150
    53.255   555.875     0.150
    53.364   556.961     0.150
    53.410   561.617     0.150
    53.410  1015.742     0.150
    53.410  1015.742     0.150
    53.428   565.398     0.150
    53.457   557.469     0.150
    53.414   555.578     0.150
    53.414   560.938     0.150
    53.414   555.570     0.150
    53.414   556.695     0.150
    53.541   561.102     0.150
    53.541  1012.352     0.150
    53.533   557.391     0.150
    53.672   561.570     0.150
    53.672   561.977     0.150
    53.672  1019.352     0.150
    53.672   564.148     0.150
    53.675   562.258     0.150
    53.675  1019.055     0.150
    53.680   562.469     0.150
    53.680  1019.891     0.150
    53.879   564.555     0.150
    53.879  1018.172     0.150
    53.956   565.664     0.150
    53.956   561.766     0.150
    53.867   562.867     0.150
    53.871   558.758     0.150
    53.871   558.961     0.150
    54.026   568.047     0.150
    53.993  1012.945     0.150
    53.993   565.172     0.150
    53.993  1020.266     0.150
    54.026   561.430     0.150
    54.040   559.516     0.150
    54.040     8.508     0.150
    54.153   561.570     0.150
    54.153   561.188     0.150
    54.413   569.656     0.150
    54.413   566.367     0.150
    54.413   569.484     0.150
    54.497   568.844     0.150
    54.497  1027.828     0.150
    54.513   568.984     0.150
    54.513  1029.211     0.150
    54.513  1029.211     0.150
    54.522   565.766     0.150
    54.522   570.836     0.150
    54.522   571.828     0.150
    54.546   563.719     0.150
    54.635   568.766     0.150
    54.635   566.570     0.150
    54.635   564.539     0.150
    54.729   485.414     0.150
    54.675   567.875     0.150
    54.725   564.828     0.150
    54.725   565.266     0.150
    54.863   570.891     0.150
    54.863  1030.859     0.150
    54.942   568.148     0.150
    55.070   573.008     0.150
    55.070  1035.305     0.150
    55.073   569.234     0.150
    55.073  1029.336     0.150
    55.073   568.914     0.150
    55.073  1028.242     0.150
    55.073   568.570     0.150
    55.149   568.844     0.150
    55.250   569.766     0.150
    55.172   570.336     0.150
    55.172   572.297     0.150
    55.172   574.039     0.150
    55.172   574.375     0.150
    55.447   578.430     0.150
    55.415   575.602     0.150
    55.415  1038.969     0.150
    55.404   570.336     0.150
    55.445   573.977     0.150
    55.445   570.617     0.150
    55.445   575.117     0.150
    55.663   580.305     0.150
    55.774   573.469     0.150
    55.781   573.164     0.150
    55.781   573.164     0.150
    55.870   580.523     0.150
    55.870   578.984     0.150
    55.870   576.367     0.150
    55.931   573.438     0.150
    55.931   576.859     0.150
    55.931   576.859     0.150
    55.931  1045.977     0.150
    55.931  1045.977     0.150
    55.931   573.469     0.150
    56.010   578.742     0.150
    56.010  1046.352     0.150
    56.021   577.070     0.150
    56.021  1036.297     0.150
    56.021   581.375     0.150
    56.021   581.320     0.150
    56.068   580.508     0.150
    56.068  1049.562     0.150
    56.140   575.766     0.150
    56.057   574.469     0.150
    56.167   576.336     0.150
    56.229   575.594     0.150
    56.372   577.758     0.150
    56.372   578.469     0.150
    56.320   577.414     0.150
    56.462   580.266     0.150
    56.462   585.430     0.150
    56.517   585.656     0.150
    56.441   580.797     0.150
    56.808   584.766     0.150
    56.808   586.586     0.150
    56.808   586.875     0.150
    56.879   581.766     0.150
    56.879   579.984     0.150
    57.040  1053.414     0.150
    57.040  1167.789     0.150
    57.040   581.367     0.150
    57.167   584.164     0.150
    57.167   582.938     0.150
    57.125   585.898     0.150
    57.125  1054.109     0.150
    57.125  1435.859     0.150
    57.207   584.469     0.150
    57.207   583.984     0.150
    57.159   581.070     0.150
    57.159   581.070     0.150
    57.159   584.570     0.150
    57.159     8.000     0.150
    57.159   587.625     0.150
    57.461   586.734     0.150
    57.461  1061.297     0.150
    57.738   589.266     0.150
    57.738   634.867     0.150
    57.738  1060.867     0.150
    57.738  1081.867     0.150
    57.738  1172.867     0.150
    57.738  1295.867     0.150
    57.807  1064.000     0.150
    57.807   587.914     0.150
    57.933   593.227     0.150
    57.933   589.766     0.150
    58.060   592.570     0.150
    58.060    14.297     0.150
    58.060  1073.164     0.150
    58.330   589.055     0.150
    58.330   589.070     0.150
    58.330   590.445     0.150
    58.330   590.539     0.150
    58.640   592.609     0.150
    58.757   595.164     0.150
    58.757   593.891     0.150
    58.757   880.391     0.150
    58.757  1076.148     0.150
    58.757  1180.344     0.150
    58.757  2368.695     0.150
    58.876   596.570     0.150
    58.877   598.461     0.150
    58.877   593.906     0.150
    58.877   593.891     0.150
    58.877  1077.844     0.150
    58.877  2367.375     0.150
    58.877   593.867     0.150
    58.921   595.438     0.150
    58.921   600.156     0.150
    58.921   645.109     0.150
    58.921   882.117     0.150
    58.921  1080.438     0.150
    58.921  1183.414     0.150
    58.921  1313.594     0.150
    59.451   603.906     0.150
    59.451   597.664     0.150
    59.451   601.969     0.150
    59.833   603.367     0.150
    59.833  1091.617     0.150
    59.869   605.438     0.150
    60.017   602.367     0.150
    60.187   608.508     0.150
    60.187   606.570     0.150
    60.187   603.219     0.150
    60.187   607.109     0.150
    60.204   603.117     0.150
    60.397   605.047     0.150
    60.553   607.367     0.150
    60.503   609.336     0.150
    60.522   608.297     0.150
    60.522  1101.367     0.150
    60.522  1501.039     0.150
    60.742   607.984     0.150
    61.246   617.508     0.150
    61.246   615.766     0.150
    61.684   619.070     0.150
    61.731   614.164     0.150
    61.797   617.367     0.150
    62.157   620.469     0.150
    62.201   617.523     0.150
    62.207   618.055     0.150
    62.320   619.867     0.150
    62.320   623.000     0.150
    62.320   623.766     0.150
    62.339   619.867     0.150
    62.412   621.070     0.150
    62.457   624.180     0.150
    62.457   621.766     0.150
    62.584   619.578     0.150
    62.584   621.469     0.150
    62.584   619.570     0.150
    62.584   620.391     0.150
    62.697   619.664     0.150
    62.697   619.664     0.150
    62.707   619.109     0.150
    62.707   620.320     0.150
    62.707  1128.016     0.150
    62.707  2361.344     0.150
    62.707  2838.891     0.150
    62.707   619.070     0.150
    62.680   623.680     0.150
    62.680   625.914     0.150
    62.687   622.469     0.150
    62.687  1130.195     0.150
    62.687  1541.414     0.150
    62.962   622.766     0.150
    62.932   623.711     0.150
    62.955   626.523     0.150
    62.955  1131.516     0.150
    62.955  1558.750     0.150
    63.004   623.070     0.150
    63.004   658.969     0.150
    63.004   765.469     0.150
    63.004   851.664     0.150
    63.004  1133.867     0.150
    63.004  1203.766     0.150
    63.004  1378.867     0.150
    63.087   623.141     0.150
    63.438   630.227     0.150
    63.438   632.180     0.150
    63.572   628.070     0.150
    63.629   632.180     0.150
    63.723   629.867     0.150
    63.723   767.570     0.150
    63.723   869.469     0.150
    63.723  1138.969     0.150
    63.862   627.789     0.150
    63.862   630.344     0.150
    63.862   628.266     0.150
    63.862   628.266     0.150
    63.862   665.070     0.150
    63.862   769.664     0.150
    63.862  1147.266     0.150
    63.862   628.469     0.150
    64.036   628.570     0.150
    64.036   628.789     0.150
    64.036  1140.367     0.150
    64.036  2360.156     0.150
    64.036  2843.492     0.150
    64.098   630.180     0.150
    64.098   634.414     0.150
    64.098   634.414     0.150
    64.098  1150.805     0.150
    64.098  1150.805     0.150
    64.098   630.164     0.150
    64.098   631.078     0.150
    64.098   636.625     0.150
    64.092   633.078     0.150
    64.144   635.297     0.150
    64.144   636.867     0.150
    64.225   631.250     0.150
    64.225  1146.555     0.150
    64.225  1577.609     0.150
    64.279   629.664     0.150
    64.279   771.367     0.150
    64.279  1149.469     0.150
    64.316   632.945     0.150
    64.316  1148.891     0.150
    64.316  1589.539     0.150
    64.412   633.688     0.150
    64.471   634.961     0.150
    64.471  1151.438     0.150
    64.471  1586.266     0.150
    64.548   633.117     0.150
    64.599   633.789     0.150
    64.599   633.766     0.150
    64.599   639.477     0.150
    64.632   640.844     0.150
    64.662   641.414     0.150
    64.705   639.070     0.150
    64.705   780.867     0.150
    64.705   880.867     0.150
    64.705  1156.070     0.150
    64.746   640.977     0.150
    64.934   641.914     0.150
    65.003   636.766     0.150
    65.003   870.367     0.150
    65.003  1158.969     0.150
    65.040   642.156     0.150
    65.040   640.164     0.150
    65.040   640.211     0.150
    65.092   635.969     0.150
    65.092   782.766     0.150
    65.092   877.969     0.150
    65.092  1158.969     0.150
    65.438   640.250     0.150
    65.479   642.805     0.150
    65.571   644.195     0.150
    65.848   641.039     0.150
    65.848  1165.258     0.150
    65.848  2353.312     0.150
    65.823   640.867     0.150
    65.828   644.086     0.150
    65.943   643.766     0.150
    66.208   650.930     0.150
    66.208   649.164     0.150
    66.213   646.266     0.150
    66.157   646.297     0.150
    66.157  1170.664     0.150
    66.157  1630.180     0.150
    66.234   647.367     0.150
    66.234   672.367     0.150
    66.428   646.570     0.150
    66.435   644.836     0.150
    66.435   645.320     0.150
    66.435  1173.172     0.150
    66.435  2354.617     0.150
    66.491   649.570     0.150
    66.539   649.570     0.150
    66.539   654.164     0.150
    66.635   646.352     0.150
    66.635  1176.242     0.150
    66.635  2361.078     0.150
    66.739   650.570     0.150
    66.750   647.109     0.150
    66.750   647.164     0.150
    66.750   652.305     0.150
    66.750   652.305     0.150
    66.750  1179.805     0.150
    66.750  1179.805     0.150
    66.750   647.180     0.150
    66.695   652.469     0.150
    66.695  1182.070     0.150
    66.747   651.008     0.150
    66.781   652.375     0.150
    66.781  1184.211     0.150
    67.110   648.508     0.150
    67.110   651.266     0.150
    67.319   655.164     0.150
    67.319   657.023     0.150
    67.216   650.867     0.150
    67.334   652.570     0.150
    67.529   660.320     0.150
    67.529   656.469     0.150
    67.572   653.016     0.150
    67.572   653.422     0.150
    67.572   654.328     0.150
    67.572   654.328     0.150
    67.572  1191.414     0.150
    67.572  1191.414     0.150
    67.572   654.430     0.150
    67.572   653.266     0.150
    67.572   802.164     0.150
    67.572  1188.266     0.150
    67.572  1449.070     0.150
    67.572   654.070     0.150
    67.572   653.945     0.150
    67.591   652.914     0.150
    67.591  1188.094     0.150
    67.591  2355.141     0.150
    67.635   652.273     0.150
    67.635  1186.328     0.150
    67.635  1663.086     0.150
    67.710   652.570     0.150
    67.710     9.898     0.150
    67.710   798.969     0.150
    67.710  1189.570     0.150
    67.723   653.969     0.150
    67.891   656.891     0.150
    68.065   658.430     0.150
    68.101   656.664     0.150
    68.101   682.367     0.150
    68.101   806.969     0.150
    68.101   905.570     0.150
    68.101  1194.766     0.150
    68.101  1253.070     0.150
    68.101  1458.664     0.150
    68.090   658.688     0.150
    68.236   663.078     0.150
    68.236   659.070     0.150
    68.267   660.570     0.150
    68.282   664.914     0.150
    68.282   663.969     0.150
    68.282   806.867     0.150
    68.282  1191.469     0.150
    68.282  1457.469     0.150
    68.282   660.469     0.150
    68.180   659.461     0.150
    68.249   657.570     0.150
    68.249  1200.164     0.150
    68.408   663.266     0.150
    68.507   664.070     0.150
    68.466   665.062     0.150
    68.466   665.062     0.150
    68.466   667.508     0.150
    68.551   659.266     0.150
    68.539   662.891     0.150
    68.539   662.266     0.150
    68.697   667.578     0.150
    68.697   664.664     0.150
    68.652   664.070     0.150
    68.763   659.773     0.150
    68.763   659.766     0.150
    68.763   659.875     0.150
    68.719   661.648     0.150
    68.719   664.234     0.150
    68.719  1203.797     0.150
    68.719   661.070     0.150
    68.719   667.227     0.150
    68.801   665.719     0.150
    68.801  1208.984     0.150
    68.954   663.469     0.150
    68.913   661.461     0.150
    68.913  1204.773     0.150
    68.913  1674.484     0.150
    68.943   660.977     0.150
    68.978   663.805     0.150
    69.100   665.969     0.150
    69.112   664.664     0.150
    69.126   661.641     0.150
    69.126  2351.562     0.150
    69.150   661.570     0.150
    69.150  2349.867     0.150
    69.150   661.570     0.150
    69.150   661.812     0.150
    69.150  2350.094     0.150
    69.299   662.906     0.150
    69.299  1208.945     0.150
    69.299  1677.836     0.150
    69.322   667.211     0.150
    69.383   666.977     0.150
    69.383  1210.297     0.150
    69.383  1682.570     0.150
    69.381   664.266     0.150
    69.397   666.625     0.150
    69.480   664.070     0.150
    69.480    13.500     0.150
    69.480   918.469     0.150
    69.480  1210.164     0.150
    69.480  1226.367     0.150
    69.753   669.086     0.150
    69.850   669.367     0.150
    69.858   672.273     0.150
    69.858   673.578     0.150
    69.874   671.484     0.150
    69.874     0.266     0.150
    69.883   672.188     0.150
    69.883  1218.875     0.150
    69.908   671.047     0.150
    69.908   671.680     0.150
    69.908   671.680     0.150
    69.908  1217.516     0.150
    69.908  1217.516     0.150
    69.953   665.766     0.150
    69.953     9.805     0.150
    69.953   827.367     0.150
    69.953  1212.070     0.150
    69.953  1483.867     0.150
    70.085   670.266     0.150
    70.001   673.305     0.150
    70.001  1220.844     0.150
    70.031   672.609     0.150
    70.031  1221.000     0.150
    70.095   667.664     0.150
    70.111   667.188     0.150
    70.111   667.695     0.150
    70.111  2352.617     0.150
    70.111   667.164     0.150
    70.111   667.266     0.150
    70.111   667.969     0.150
    70.114   667.969     0.150
    70.123   668.070     0.150
    70.123   667.414     0.150
    70.123   667.836     0.150
    70.123   670.836     0.150
    70.123   667.469     0.150
    70.123   667.469     0.150
    70.185   668.680     0.150
    70.185  1221.188     0.150
    70.185  1685.734     0.150
    70.227   668.750     0.150
    70.227   668.766     0.150
    70.227   673.594     0.150
    70.227   674.023     0.150
    70.263   671.508     0.150
    70.263   673.039     0.150
    70.263  1221.266     0.150
    70.366   671.969     0.150
    70.272   669.328     0.150
    70.272  1221.336     0.150
    70.316   674.555     0.150
    70.316  1220.578     0.150
    70.323   671.844     0.150
    70.482   675.367     0.150
    70.376   664.641     0.150
    70.374   668.680     0.150
    70.374  1222.023     0.150
    70.374   673.273     0.150
    70.412   675.602     0.150
    70.412  1223.305     0.150
    70.443   670.477     0.150
    70.553   677.320     0.150
    70.549   670.523     0.150
    70.549   672.758     0.150
    70.549   675.547     0.150
    70.549  1227.078     0.150
    70.553   670.766     0.150
    70.571   675.797     0.150
    70.571   676.609     0.150
    70.571  1231.562     0.150
    70.613   675.938     0.150
    70.613  1230.258     0.150
    70.675   672.445     0.150
    70.675   675.906     0.150
    70.675  1228.914     0.150
    70.751   671.297     0.150
    70.751   674.305     0.150
    70.751   936.047     0.150
    70.751  1227.719     0.150
    70.751  1693.094     0.150
    70.751   671.266     0.150
    70.751   671.711     0.150
    70.804   677.672     0.150
    70.804  1228.992     0.150
    70.816   673.133     0.150
    70.816   676.602     0.150
    70.816  1228.109     0.150
    70.822   672.242     0.150
    70.822   677.180     0.150
    70.822  1229.836     0.150
    70.906   674.656     0.150
    70.906   677.641     0.150
    70.906  1231.969     0.150
    70.908   673.969     0.150
    70.908  1226.367     0.150
    70.908  1712.344     0.150
    70.938   673.164     0.150
    70.990   678.570     0.150
    71.107   676.633     0.150
    71.107   679.047     0.150
    71.107  1233.195     0.150
    71.109   674.570     0.150
    71.179   675.070     0.150
    71.296   677.867     0.150
    71.218   679.297     0.150
    71.218  1233.961     0.150
    71.242   674.969     0.150
    71.333   675.984     0.150
    71.333   676.719     0.150
    71.333  2349.242     0.150
    71.333  2875.492     0.150
    71.283   675.875     0.150
    71.283  1232.820     0.150
    71.330   680.117     0.150
    71.330  1236.273     0.150
    71.330   675.906     0.150
    71.330  1235.117     0.150
    71.330  1719.398     0.150
    71.330   674.664     0.150
    71.368   678.555     0.150
    71.368   681.477     0.150
    71.368  1238.922     0.150
    71.378   676.297     0.150
    71.378  1234.070     0.150
    71.378  1709.555     0.150
    71.427   679.422     0.150
    71.427   681.492     0.150
    71.427  1235.961     0.150
    71.642   678.289     0.150
    71.642  2343.945     0.150
    71.623   677.969     0.150
    71.623  1236.570     0.150
    71.623  1511.867     0.150
    71.650   680.211     0.150
    71.650   681.242     0.150
    71.650  1239.477     0.150
    71.773   683.477     0.150
    71.773  1241.125     0.150
    71.837   678.945     0.150
    71.973   680.766     0.150
    72.035   683.508     0.150
    72.035   686.117     0.150
    72.102   683.844     0.150
    72.102   686.719     0.150
    72.104   680.859     0.150
    72.104   680.867     0.150
    72.104   687.625     0.150
    72.256   686.258     0.150
    72.256   684.969     0.150
    72.211   680.625     0.150
    72.312   684.727     0.150
    72.312   684.664     0.150
    72.312   681.164     0.150
    72.348   682.086     0.150
    72.348  1244.797     0.150
    72.348  1752.406     0.150
    72.443   682.766     0.150
    72.450   682.766     0.150
    72.477   686.695     0.150
    72.534   682.898     0.150
    72.534  1246.250     0.150
    72.678   686.336     0.150
    72.678   688.375     0.150
    72.693   687.438     0.150
    72.693  1249.516     0.150
    72.702   686.109     0.150
    72.754   688.797     0.150
    72.754  1251.867     0.150
    72.853   687.164     0.150
    72.970   686.766     0.150
    72.890   688.359     0.150
    72.890   684.867     0.150
    72.890   847.867     0.150
    72.890  1248.867     0.150
    72.894   684.766     0.150
    72.894   684.664     0.150
    72.914   688.625     0.150
    72.914  1253.781     0.150
    72.930   690.055     0.150
    72.930   689.914     0.150
    72.937   689.750     0.150
    72.937  1249.688     0.150
    73.009   690.414     0.150
    73.009  1257.359     0.150
    72.948   688.250     0.150
    72.948   684.867     0.150
    72.948   847.867     0.150
    72.948  1247.867     0.150
    72.962   685.898     0.150
    72.962   851.016     0.150
    72.962  1252.164     0.150
    73.015   689.891     0.150
    73.080   690.727     0.150
    73.080   690.336     0.150
    73.080   689.266     0.150
    73.080   686.969     0.150
    73.165   688.320     0.150
    73.287   694.727     0.150
    73.287   689.469     0.150
    73.230   689.047     0.150
    73.230   687.867     0.150
    73.268   690.969     0.150
    73.268   690.188     0.150
    73.268   691.664     0.150
    73.334   689.266     0.150
    73.357   691.570     0.150
    73.357   691.570     0.150
    73.455   688.969     0.150
    73.455  1257.469     0.150
    73.455  2342.914     0.150
    73.511   692.750     0.150
    73.645   693.570     0.150
    73.645  1254.016     0.150
    73.645   689.469     0.150
    73.682   688.969     0.150
    73.689   692.484     0.150
    73.689   690.414     0.150
    73.689     6.672     0.150
    73.689   696.156     0.150
    73.703   692.000     0.150
    73.703   693.023     0.150
    73.703  1262.352     0.150
    73.708   693.352     0.150
    73.708   691.664     0.150
    73.708   693.523     0.150
    73.715   689.164     0.150
    73.753   691.727     0.150
    73.882   693.469     0.150
    73.799   690.828     0.150
    73.799  1263.391     0.150
    73.799   691.266     0.150
    73.939   692.766     0.150
    73.863   694.836     0.150
    73.863  1263.750     0.150
    73.868   693.445     0.150
    73.988   694.883     0.150
    73.988   694.867     0.150
    74.068   694.469     0.150
    74.198   700.469     0.150
    74.198   695.070     0.150
    74.198   692.492     0.150
    74.198  1265.609     0.150
    74.211   695.070     0.150
    74.142   695.961     0.150
    74.156   692.516     0.150
    74.156   694.438     0.150
    74.156   694.367     0.150
    74.173   696.078     0.150
    74.173   696.070     0.150
    74.188   696.625     0.150
    74.188  1262.680     0.150
    74.231   695.703     0.150
    74.241   696.516     0.150
    74.302   699.633     0.150
    74.302   700.477     0.150
    74.271   694.070     0.150
    74.280   697.359     0.150
    74.280  1268.078     0.150
    74.335   695.680     0.150
    74.337   692.570     0.150
    74.387   697.336     0.150
    74.402   697.438     0.150
    74.435   696.648     0.150
    74.436   696.148     0.150
    74.436   697.625     0.150
    74.440   696.633     0.150
    74.453   697.984     0.150
    74.453  1269.656     0.150
    74.448   697.570     0.150
    74.457   697.500     0.150
    74.503   697.008     0.150
    74.509   694.766     0.150
    74.509   701.969     0.150
    74.532   698.188     0.150
    74.583   694.016     0.150
    74.583  1269.344     0.150
    74.595   695.234     0.150
    74.595   870.156     0.150
    74.595  1266.094     0.150
    74.595   695.164     0.150
    74.604   698.859     0.150
    74.623   695.664     0.150
    74.626   697.516     0.150
    74.685   696.664     0.150
    74.802   698.570     0.150
    74.706   696.570     0.150
    74.710   698.281     0.150
    74.710   698.266     0.150
    74.759   698.398     0.150
    74.759   698.367     0.150
    74.764   696.766     0.150
    74.784   698.078     0.150
    74.864   703.258     0.150
    74.867   697.367     0.150
    74.902   700.625     0.150
    74.902   700.570     0.150
    74.916   698.961     0.150
    74.941   700.625     0.150
    74.943   700.266     0.150
    74.967   699.633     0.150
    74.967   699.570     0.150
    74.978   700.492     0.150
    74.995   698.094     0.150
    74.995  1273.273     0.150
    74.995   698.367     0.150
    74.996   700.555     0.150
    75.013   700.875     0.150
    75.052   699.820     0.150
    75.071   700.719     0.150
    75.087   701.031     0.150
    75.280   710.125     0.150
    75.183   701.445     0.150
    75.183   698.953     0.150
    75.183     6.578     0.150
    75.183   704.258     0.150
    75.278   699.664     0.150
    75.322   706.055     0.150
    75.219   699.188     0.150
    75.219     6.531     0.150
    75.322   700.664     0.150
    75.238   702.461     0.150
    75.264   708.141     0.150
    75.275   701.664     0.150
    75.278   701.594     0.150
    75.279   701.000     0.150
    75.374   698.750     0.150
    75.374   698.766     0.150
    75.319   702.047     0.150
    75.319   701.969     0.150
    75.341   703.219     0.150
    75.341   703.164     0.150
    75.361   703.672     0.150
    75.361   704.297     0.150
    75.361  1279.461     0.150
    75.457   702.070     0.150
    75.360   701.945     0.150
    75.360   701.867     0.150
    75.361   700.070     0.150
    75.361  1277.867     0.150
    75.361   700.070     0.150
    75.361  1277.867     0.150
    75.442   702.742     0.150
    75.442  1280.102     0.150
    75.442   699.539     0.150
    75.442   700.414     0.150
    75.442   870.617     0.150
    75.442  2339.516     0.150
    75.442   699.570     0.150
    75.453   701.766     0.150
    75.459   701.766     0.150
    75.529   700.656     0.150
    75.529   875.773     0.150
    75.529  1280.617     0.150
    75.529   700.969     0.150
    75.609   701.000     0.150
    75.609   700.914     0.150
    75.540   703.688     0.150
    75.616   705.188     0.150
    75.616  1285.391     0.150
    75.549   704.234     0.150
    75.551   701.969     0.150
    75.551   709.266     0.150
    75.568   704.656     0.150
    75.568   704.570     0.150
    75.571   701.266     0.150
    75.571  1284.266     0.150
    75.571   701.266     0.150
    75.571  1284.266     0.150
    75.562   708.570     0.150
    75.627   702.367     0.150
    75.627   709.070     0.150
    75.627   704.664     0.150
    75.627   704.570     0.150
    75.627   707.727     0.150
    75.756   713.180     0.150
    75.747   703.766     0.150
    75.654   701.797     0.150
    75.654     6.719     0.150
    75.798   704.070     0.150
    75.695   704.727     0.150
    75.741   704.203     0.150
    75.785   702.367     0.150
    75.785  1284.664     0.150
    75.785   702.367     0.150
    75.785  1284.664     0.150
    75.802   705.336     0.150
    75.802   706.578     0.150
    75.812   702.453     0.150
    75.812     6.539     0.150
    75.812   708.211     0.150
    75.812   702.164     0.150
    75.812   705.953     0.150
    75.812  1287.047     0.150
    75.812   705.250     0.150
    75.812   702.164     0.150
    75.812   702.766     0.150
    75.816   705.602     0.150
    75.823   702.766     0.150
    75.823  1285.367     0.150
    75.823   702.766     0.150
    75.823   709.664     0.150
    75.823  1285.367     0.150
    75.836   705.023     0.150
    75.836   709.094     0.150
    75.864   704.125     0.150
    75.865   702.664     0.150
    75.865   708.664     0.150
    75.865  1287.266     0.150
    75.865   705.523     0.150
    75.865   705.469     0.150
    75.962   708.727     0.150
    75.962   703.469     0.150
    75.993   711.258     0.150
    75.993   705.766     0.150
    75.904   702.969     0.150
    75.904  1286.070     0.150
    75.904   702.969     0.150
    75.904  1286.070     0.150
    75.905   703.469     0.150
    75.905  1288.266     0.150
    75.905   703.469     0.150
    75.905   709.664     0.150
    75.905  1288.266     0.150
    75.905   703.367     0.150
    75.916   704.930     0.150
    75.916   704.867     0.150
    75.916   706.930     0.150
    75.937   706.406     0.150
    75.978   706.070     0.150
    75.978   706.070     0.150
    76.082   706.719     0.150
    76.050   708.523     0.150
    76.050  1288.844     0.150
    76.039   706.969     0.150
    76.039   706.867     0.150
    76.056   708.344     0.150
    76.056  1287.016     0.150
    76.068   703.766     0.150
    76.079   706.297     0.150
    76.110   706.461     0.150
    76.136   708.367     0.150
    76.136   710.016     0.150
    76.219   704.227     0.150
    76.219     6.633     0.150
    76.224   708.125     0.150
    76.314   708.805     0.150
    76.314   708.766     0.150
    76.322   714.266     0.150
    76.324   705.570     0.150
    76.324   713.070     0.150
    76.324  1287.766     0.150
    76.305   712.969     0.150
    76.359   710.891     0.150
    76.503   708.266     0.150
    76.411   705.695     0.150
    76.411   714.344     0.150
    76.411   705.664     0.150
    76.411   714.266     0.150
    76.411  1293.867     0.150
    76.411   705.695     0.150
    76.411   712.344     0.150
    76.413   704.867     0.150
    76.413    16.000     0.150
    76.413  1289.867     0.150
    76.413  1308.867     0.150
    76.413  1316.867     0.150
    76.413   705.523     0.150
    76.413   712.086     0.150
    76.413   705.570     0.150
    76.428   709.211     0.150
    76.448   706.570     0.150
    76.448  1291.766     0.150
    76.448   706.570     0.150
    76.448   713.469     0.150
    76.448  1291.766     0.150
    76.544   706.969     0.150
    76.479   706.156     0.150
    76.479   712.750     0.150
    76.490   709.344     0.150
    76.611   714.156     0.150
    76.611   709.164     0.150
    76.508   709.352     0.150
    76.508   709.266     0.150
    76.528   707.469     0.150
    76.528   713.469     0.150
    76.528  1295.766     0.150
    76.533   706.438     0.150
    76.533   713.148     0.150
    76.531   709.562     0.150
    76.531   710.023     0.150
    76.616   711.969     0.150
    76.616  1295.164     0.150
    76.617   707.070     0.150
    76.617   713.070     0.150
    76.617   878.266     0.150
    76.617  1294.969     0.150
    76.617   708.133     0.150
    76.617   708.070     0.150
    76.625   709.484     0.150
    76.625   713.266     0.150
    76.694   711.648     0.150
    76.694  1296.305     0.150
    76.704   707.625     0.150
    76.707   710.859     0.150
    76.725   712.008     0.150
    76.725  1293.875     0.150
    76.839   710.070     0.150
    76.768   712.914     0.150
    76.768  1295.305     0.150
    76.788   710.359     0.150
    76.818   708.164     0.150
    76.818  1296.867     0.150
    76.867   711.867     0.150
    76.867  1297.867     0.150
    76.867   711.867     0.150
    76.867  1297.867     0.150
    76.890   708.867     0.150
    76.890  1295.469     0.150
    76.890   708.867     0.150
    76.890   715.969     0.150
    76.890  1295.469     0.150
    76.891   708.469     0.150
    76.891   714.367     0.150
    76.891  1299.164     0.150
    76.926   709.055     0.150
    76.926   715.633     0.150
    76.934   711.508     0.150
    76.934   711.469     0.150
    76.944   708.711     0.150
    76.944   715.289     0.150
    76.964   712.492     0.150
    76.991   716.766     0.150
    76.985   714.867     0.150
    77.024   714.188     0.150
    77.155   711.969     0.150
    77.071   710.070     0.150
    77.071  1299.070     0.150
    77.071   710.070     0.150
    77.071  1299.070     0.150
    77.073   711.070     0.150
    77.073   715.969     0.150
    77.073   716.289     0.150
    77.184   710.266     0.150
    77.170   712.156     0.150
    77.293   713.664     0.150
    77.251   718.367     0.150
    77.268   714.219     0.150
    77.301   713.320     0.150
    77.301   713.266     0.150
    77.314   711.023     0.150
    77.314   717.523     0.150
    77.338   711.070     0.150
    77.338   717.703     0.150
    77.484   714.664     0.150
    77.394   711.336     0.150
    77.394   718.008     0.150
    77.432   711.281     0.150
    77.432   717.930     0.150
    77.464   711.758     0.150
    77.464   718.375     0.150
    77.464  1315.484     0.150
    77.467   711.766     0.150
    77.467  1304.367     0.150
    77.477   716.398     0.150
    77.477  1303.531     0.150
    77.325   718.570     0.150
    77.487   715.164     0.150
    77.601   716.148     0.150
    77.621   717.648     0.150
    77.635   715.047     0.150
    77.695   716.359     0.150
    77.698   716.188     0.150
    77.900   721.070     0.150
    77.900   715.766     0.150
    77.922   721.023     0.150
    77.922   718.164     0.150
    77.819   713.969     0.150
    77.819   720.375     0.150
    77.833   713.906     0.150
    77.855   719.305     0.150
    77.969   714.969     0.150
    77.890   717.289     0.150
    77.899   723.164     0.150
    77.903   713.906     0.150
    77.903   721.500     0.150
    77.903   717.727     0.150
    77.918   714.469     0.150
    77.918  1306.070     0.150
    77.918   714.469     0.150
    77.918  1306.070     0.150
    77.948   713.992     0.150
    77.948  2338.820     0.150
    78.062   716.969     0.150
    77.954   714.469     0.150
    77.954  1311.867     0.150
    77.954   714.469     0.150
    77.954   721.070     0.150
    77.954  1311.867     0.150
    77.954   714.664     0.150
    78.048   716.766     0.150
    77.961   714.922     0.150
    77.961   721.469     0.150
    77.974   713.859     0.150
    77.974   714.375     0.150
    77.974   713.867     0.150
    77.974   717.195     0.150
    77.974   717.227     0.150
    78.002   722.164     0.150
    78.003   718.148     0.150
    78.005   715.195     0.150
    78.005   722.891     0.150
    78.005  1311.461     0.150
    78.005  1842.930     0.150
    78.007   715.414     0.150
    78.007   723.102     0.150
    78.007  1312.062     0.150
    78.086   724.469     0.150
    78.100   715.000     0.150
    78.100   718.734     0.150
    78.136   715.547     0.150
    78.136   722.086     0.150
    78.136   714.336     0.150
    78.136   715.445     0.150
    78.136  1308.812     0.150
    78.136  1853.391     0.150
    78.136  2333.266     0.150
    78.136   714.367     0.150
    78.137   715.500     0.150
    78.137   722.000     0.150
    78.173   717.875     0.150
    78.173   715.070     0.150
    78.288   721.578     0.150
    78.326   716.250     0.150
    78.326   722.820     0.150
    78.452   719.266     0.150
    78.452   722.266     0.150
    78.452  1317.672     0.150
    78.390   717.438     0.150
    78.390   723.930     0.150
    78.390  1316.562     0.150
    78.392   716.211     0.150
    78.392   716.164     0.150
    78.405   716.617     0.150
    78.395   724.766     0.150
    78.473   716.867     0.150
    78.440   724.969     0.150
    78.586   717.320     0.150
    78.586   718.766     0.150
    78.586   723.578     0.150
    78.586  1318.297     0.150
    78.586   717.367     0.150
    78.510   722.461     0.150
    78.645   723.625     0.150
    78.645  1320.156     0.150
    78.608   718.367     0.150
    78.681   724.180     0.150
    78.683   718.477     0.150
    78.683   726.188     0.150
    78.683  1316.305     0.150
    78.683  1845.984     0.150
    78.715   717.656     0.150
    78.715   725.969     0.150
    78.715  1318.125     0.150
    78.715  1859.109     0.150
    78.715   722.180     0.150
    78.749   718.719     0.150
    78.763   721.609     0.150
    78.764   721.359     0.150
    78.833   727.570     0.150
    78.964   720.969     0.150
    78.878   720.461     0.150
    78.878   723.516     0.150
    78.893   726.797     0.150
    78.987   725.016     0.150
    78.987  1322.484     0.150
    78.924   719.078     0.150
    78.924   720.516     0.150
    78.924   724.938     0.150
    78.924  1319.664     0.150
    78.924   719.070     0.150
    78.931   723.320     0.150
    78.949   719.898     0.150
    78.949   726.570     0.150
    79.079   722.570     0.150
    79.034   724.508     0.150
    79.053   721.266     0.150
    79.053  1319.188     0.150
    79.053  1851.695     0.150
    79.070   719.867     0.150
    79.093   720.852     0.150
    79.093   727.633     0.150
    79.093  1320.180     0.150
    79.153   721.188     0.150
    79.153   727.836     0.150
    79.200   721.766     0.150
    79.200   727.211     0.150
    79.267   721.445     0.150
    79.267   727.180     0.150
    79.271   727.305     0.150
    79.276   722.555     0.150
    79.276   727.258     0.150
    79.321   722.117     0.150
    79.342   725.016     0.150
    79.342  1323.719     0.150
    79.342  1859.484     0.150
    79.342  2337.180     0.150
    79.343   721.945     0.150
    79.343   729.227     0.150
    79.343  1324.289     0.150
    79.343  1857.352     0.150
    79.330   729.867     0.150
    79.403   722.391     0.150
    79.433   722.250     0.150
    79.439   730.664     0.150
    79.454   721.945     0.150
    79.634   725.266     0.150
    79.622   723.148     0.150
    79.622   729.289     0.150
    79.626   723.961     0.150
    79.626   730.633     0.150
    79.655   723.664     0.150
    79.673   724.109     0.150
    79.677   723.805     0.150
    79.677   731.305     0.150
    79.677  1327.391     0.150
    79.677  1859.109     0.150
    79.677   723.469     0.150
    79.690   724.148     0.150
    79.690   731.711     0.150
    79.690  1328.352     0.150
    79.691   724.070     0.150
    79.706   724.062     0.150
    79.706   731.922     0.150
    79.706  1327.375     0.150
    79.728   731.219     0.150
    79.729   724.250     0.150
    79.753   729.016     0.150
    79.878   727.070     0.150
    79.802   723.789     0.150
    79.802  1325.914     0.150
    79.802  2339.820     0.150
    79.802   729.664     0.150
    79.803   727.711     0.150
    79.944   731.680     0.150
    79.944   726.969     0.150
    79.847   723.867     0.150
    79.850   723.836     0.150
    79.861   724.969     0.150
    79.863   728.664     0.150
    79.872   729.367     0.150
    79.901   727.367     0.150
    79.901   730.461     0.150
    79.897   725.039     0.150
    79.897   731.711     0.150
    79.897   729.555     0.150
    79.980   726.234     0.150
    79.980   726.266     0.150
    79.951   724.844     0.150
    79.950   724.961     0.150
    79.950   732.352     0.150
    79.950  1328.453     0.150
    79.959   730.266     0.150
    80.035   726.805     0.150
    80.060   725.688     0.150
    80.060   729.578     0.150
    80.060   921.406     0.150
    80.060  1036.430     0.150
    80.060  1329.273     0.150
    80.181   729.070     0.150
    80.101   725.688     0.150
    80.103   732.023     0.150
    80.111   728.250     0.150
    80.111   733.039     0.150
    80.126   725.641     0.150
    80.246   733.930     0.150
    80.246   728.266     0.150
    80.224   731.398     0.150
    80.224  1335.344     0.150
    80.160   731.023     0.150
    80.170   726.695     0.150
    80.170   729.555     0.150
    80.190   726.516     0.150
    80.191   725.867     0.150
    80.193   726.648     0.150
    80.193   734.391     0.150
    80.193  1332.297     0.150
    80.236   732.680     0.150
    80.212   732.719     0.150
    80.212   727.391     0.150
    80.212   734.211     0.150
    80.212   730.766     0.150
    80.229   726.750     0.150
    80.229   734.719     0.150
    80.229  1331.688     0.150
    80.237   727.219     0.150
    80.237   728.477     0.150
    80.262   733.078     0.150
    80.381   730.469     0.150
    80.308   726.219     0.150
    80.308   733.953     0.150
    80.308  1330.711     0.150
    80.417   729.867     0.150
    80.326   727.484     0.150
    80.348   726.570     0.150
    80.360   726.898     0.150
    80.368   727.523     0.150
    80.368   735.281     0.150
    80.368  1334.797     0.150
    80.382   727.477     0.150
    80.382   735.383     0.150
    80.382  1334.758     0.150
    80.399   730.766     0.150
    80.535   730.469     0.150
    80.430   727.906     0.150
    80.542   731.664     0.150
    80.456   733.266     0.150
    80.469   728.180     0.150
    80.469   735.766     0.150
    80.469   733.930     0.150
    80.494   732.523     0.150
    80.507   732.523     0.150
    80.521   733.875     0.150
    80.582   727.695     0.150
    80.582   727.664     0.150
    80.582   728.672     0.150
    80.582   736.430     0.150
    80.663   729.758     0.150
    80.663   730.086     0.150
    80.663  2340.258     0.150
    80.631   729.969     0.150
    80.631   733.289     0.150
    80.631   732.406     0.150
    80.674   727.969     0.150
    80.780   728.680     0.150
    80.780   737.492     0.150
    80.780  1339.109     0.150
    80.802   729.367     0.150
    80.838   729.469     0.150
    80.838   733.406     0.150
    80.883   730.141     0.150
    80.883  1340.336     0.150
    80.900   730.328     0.150
    80.925   732.180     0.150
    81.021   736.102     0.150
    81.021  1347.453     0.150
    80.998   734.516     0.150
    81.005   731.547     0.150
    81.005   737.195     0.150
    81.016   733.008     0.150
    81.037   731.375     0.150
    81.061   729.266     0.150
    81.126   732.078     0.150
    81.144   735.961     0.150
    81.208   735.969     0.150
    81.391   738.484     0.150
    81.529   736.570     0.150
    81.529   737.508     0.150
    81.618   739.352     0.150
    81.618  1351.875     0.150
    81.769   740.141     0.150
    82.017   742.055     0.150
    82.227   742.859     0.150
    82.250   743.828     0.150
    82.463   743.617     0.150
    82.551   744.867     0.150
    82.590   739.227     0.150
    82.671   739.617     0.150
    82.690   744.977     0.150
    82.719   741.266     0.150
    82.719   745.211     0.150
    82.719   745.906     0.150
    82.848   745.688     0.150
    82.856   746.156     0.150
    82.920   746.867     0.150
    83.180   749.805     0.150
    83.158   749.516     0.150
    83.234   742.430     0.150
    83.288   747.766     0.150
    83.467   746.766     0.150
    83.420   746.266     0.150
    83.420   749.211     0.150
    83.449   746.914     0.150
    83.693   750.359     0.150
    83.886   749.070     0.150
    83.809   751.211     0.150
    84.114   751.320     0.150
    84.220   752.695     0.150
    84.344   750.680     0.150
    84.344  1372.141     0.150
    84.317   754.828     0.150
    84.353   752.578     0.150
    84.542   753.320     0.150
    84.564   752.352     0.150
    84.564   749.766     0.150
    84.840   754.070     0.150
    84.874   758.430     0.150
    84.874   752.969     0.150
    84.807   755.594     0.150
    84.945   755.609     0.150
    85.189   757.891     0.150
    85.348   763.578     0.150
    85.348   754.969     0.150
    85.356   759.695     0.150
    85.512  2328.844     0.150
    85.512   757.219     0.150
    86.046   757.914     0.150
    86.095   762.969     0.150
    86.095   950.969     0.150
    86.095  1383.367     0.150
    86.095  1729.164     0.150
    86.173   766.719     0.150
    86.220   757.008     0.150
    86.220   756.969     0.150
    86.364   757.656     0.150
    86.364   758.891     0.150
    86.364  1381.070     0.150
    86.364  1833.367     0.150
    86.364  2321.117     0.150
    86.364   757.664     0.150
    86.442   763.367     0.150
    86.442   957.070     0.150
    86.442  1391.867     0.150
    86.442  1732.969     0.150
    86.456   761.367     0.150
    86.666   760.273     0.150
    86.666   766.078     0.150
    86.629   761.867     0.150
    86.823   765.711     0.150
    86.838   758.469     0.150
    86.838   764.766     0.150
    86.838   961.070     0.150
    86.838   965.070     0.150
    86.838  1392.664     0.150
    86.838  1395.867     0.150
    86.838  1736.164     0.150
    86.838  1739.867     0.150
    86.838  6455.766     0.150
    86.846   768.766     0.150
    86.888   763.867     0.150
    86.888   963.570     0.150
    86.888  1391.766     0.150
    86.888  1737.367     0.150
    86.888  6460.164     0.150
    87.093   766.070     0.150
    87.093  1401.391     0.150
    87.169   762.469     0.150
    87.169   964.367     0.150
    87.169  1394.664     0.150
    87.169  1746.070     0.150
    87.169  6480.164     0.150
    87.169   765.164     0.150
    87.169   769.227     0.150
    87.191   765.164     0.150
    87.191  1395.367     0.150
    87.191  1742.266     0.150
    87.191  6488.266     0.150
    87.292   772.789     0.150
    87.292   765.766     0.150
    87.603   772.336     0.150
    87.497   769.906     0.150
    87.564   769.930     0.150
    87.593   769.484     0.150
    87.593   770.195     0.150
    87.596   769.578     0.150
    87.854   769.977     0.150
    87.854  1408.125     0.150
    87.883   769.828     0.150
    87.883  1409.539     0.150
    88.308   767.344     0.150
    88.308   767.367     0.150
    88.308   771.578     0.150
    88.261   772.844     0.150
    88.301   772.180     0.150
    88.577   769.406     0.150
    88.687   777.875     0.150
    88.678   774.047     0.150
    88.678  1416.953     0.150
    88.726   774.055     0.150
    88.726  1418.312     0.150
    88.847   774.492     0.150
    88.847  1418.344     0.150
    88.858   773.914     0.150
    88.863   775.055     0.150
    88.863  1409.945     0.150
    88.863   777.367     0.150
    88.863   776.469     0.150
    89.207   776.086     0.150
    89.361   782.008     0.150
    89.400   777.234     0.150
    89.366   776.555     0.150
    89.595   779.219     0.150
    89.595  1426.914     0.150
    89.656   775.969     0.150
    89.656   775.969     0.150
    89.581   773.375     0.150
    89.702   778.922     0.150
    89.702  1425.211     0.150
    89.887   780.367     0.150
    90.021   776.875     0.150
    89.994   775.914     0.150
    89.994   775.969     0.150
    89.966   780.984     0.150
    89.994   781.828     0.150
    90.136   780.477     0.150
    90.082   783.977     0.150
    90.293   777.609     0.150
    90.324   783.125     0.150
    90.539   782.766     0.150
    90.539   783.273     0.150
    90.539  1410.648     0.150
    90.539   783.773     0.150
    90.721   787.828     0.150
    90.615   784.906     0.150
    90.872   783.203     0.150
    90.765   779.016     0.150
    90.765   783.953     0.150
    90.765  1411.000     0.150
    90.835   785.547     0.150
    90.902   783.688     0.150
    91.024   788.148     0.150
    91.024   781.875     0.150
    91.079   778.766     0.150
    91.079   788.367     0.150
    91.079   999.070     0.150
    91.079  1430.367     0.150
    91.079  1434.969     0.150
    91.079  1797.969     0.150
    91.079  1800.164     0.150
    91.079  6775.266     0.150
    91.042   787.914     0.150
    91.161   782.867     0.150
    91.179   790.148     0.150
    91.131   785.188     0.150
    91.131  1439.305     0.150
    91.156   785.102     0.150
    91.156   786.719     0.150
    91.158   786.664     0.150
    91.283   786.969     0.150
    91.283  1000.570     0.150
    91.427   790.398     0.150
    91.476   788.227     0.150
    91.562   788.164     0.150
    91.562  1006.664     0.150
    91.562  1419.266     0.150
    91.562  1441.969     0.150
    91.562  1812.164     0.150
    91.732   788.164     0.150
    91.732  1008.969     0.150
    91.885   790.984     0.150
    91.957   789.570     0.150
    91.957  1008.367     0.150
    91.957  1419.570     0.150
    91.957  1444.867     0.150
    91.957  1830.164     0.150
    92.078   794.562     0.150
    91.980   788.164     0.150
    91.980  1008.469     0.150
    92.049   790.469     0.150
    92.049  1011.367     0.150
    92.393   785.969     0.150
    92.393   786.492     0.150
    92.393  1819.773     0.150
    92.393  2308.992     0.150
    92.408   793.617     0.150
    92.523   793.477     0.150
    92.619   791.664     0.150
    92.619  1013.469     0.150
    92.633   786.805     0.150
    92.633   786.766     0.150
    92.633   793.680     0.150
    92.812   793.969     0.150
    92.812  1016.766     0.150
    92.812  1424.070     0.150
    92.812  1455.070     0.150
    92.812  1830.766     0.150
    92.812   794.305     0.150
    93.135   795.320     0.150
    93.135   797.656     0.150
    93.236   795.070     0.150
    93.236  1021.570     0.150
    93.279   796.320     0.150
    93.311   795.469     0.150
    93.311  1015.164     0.150
    93.404   796.664     0.150
    93.404  1020.766     0.150
    93.459   798.164     0.150
    93.483   798.977     0.150
    93.596   798.086     0.150
    93.638   798.617     0.150
    93.638   800.406     0.150
    93.638   800.875     0.150
    93.667   797.367     0.150
    93.667  1018.070     0.150
    93.667  1432.266     0.150
    93.667  1460.867     0.150
    93.667  1853.070     0.150
    93.962   799.930     0.150
    93.988   799.070     0.150
    93.988  1025.164     0.150
    94.241   799.469     0.150
    94.241  1025.070     0.150
    94.244   799.367     0.150
    94.244  1025.664     0.150
    94.244   802.109     0.150
    94.626   783.617     0.150
    94.678   802.164     0.150
    94.678  1030.570     0.150
    94.678   804.211     0.150
    94.721   801.867     0.150
    94.721  1028.469     0.150
    95.104   803.766     0.150
    95.104  1034.570     0.150
    95.194   805.609     0.150
    95.217   804.766     0.150
    95.217  1035.164     0.150
    95.380   805.367     0.150
    95.380  1032.367     0.150
    95.380   807.430     0.150
    95.380  1038.094     0.150
    95.380  1870.734     0.150
    95.520   805.766     0.150
    95.520  1036.070     0.150
    95.520   807.250     0.150
    95.616   808.258     0.150
    95.637   806.469     0.150
    95.637  1037.867     0.150
    95.637  1439.766     0.150
    95.637  1478.570     0.150
    95.637  1868.570     0.150
    95.800   807.766     0.150
    95.800  1040.766     0.150
    95.849   806.164     0.150
    95.849  1037.867     0.150
    96.001   807.969     0.150
    96.001  1037.969     0.150
    96.001   810.227     0.150
    96.001  1042.969     0.150
    96.001  1444.477     0.150
    96.214   805.367     0.150
    96.214  1041.766     0.150
    96.291   809.109     0.150
    98.328   820.469     0.150
    98.328  1039.969     0.150
    98.384   819.008     0.150
    98.445   837.664     0.150
    98.445  1069.164     0.150
    98.721   822.266     0.150
    98.734  1065.766     0.150
    99.062   823.969     0.150
    99.062  1063.969     0.150
    99.087   818.766     0.150
    99.087  1063.969     0.150
    99.336   824.070     0.150
    99.792   826.055     0.150
    99.792   825.961     0.150
    99.792   827.188     0.150
    99.792   826.070     0.150
    99.810   827.367     0.150
    99.826  1072.570     0.150
   100.482   823.766     0.150
   100.482   825.766     0.150
   100.482  1071.867     0.150
   100.482  1514.367     0.150
   100.482  1927.164     0.150
   101.549   831.961     0.150
   101.549   829.242     0.150
   101.549  1081.844     0.150
   101.549   832.969     0.150
   101.549   833.164     0.150
   101.549  1473.094     0.150
   101.549   834.688     0.150
   101.549   834.430     0.150
   101.795   834.078     0.150
   101.795   834.734     0.150
   101.795   835.625     0.150
   102.460  1480.469     0.150
   102.460  1537.570     0.150
   102.460  1966.969     0.150
   103.461   845.117     0.150
   105.776  1109.445     0.150
   105.890   852.906     0.150
   105.890   854.875     0.150
   113.553   885.336     0.150
   113.553  1113.695     0.150
   113.553  1169.516     0.150
   113.553  1766.320     0.150
   117.458  1122.508     0.150
   117.458  1122.508     0.150
   117.563  1127.867     0.150
   117.563  1127.867     0.150
   117.619  1121.461     0.150
   117.619  1121.469     0.150
   120.372  1125.266     0.150
   120.372  1125.266     0.150
   120.633  1127.914     0.150
   120.633  1220.414     0.150
   120.633  1340.391     0.150
   120.683  1128.625     0.150
   120.765  1128.336     0.150
   120.765  1128.336     0.150
   121.225  1128.297     0.150
   121.225  1128.266     0.150
   121.455  1130.039     0.150
   121.455  1141.523     0.150
   121.905  1130.719     0.150
   121.905  1134.625     0.150
   122.378  1133.867     0.150
   122.341  1129.891     0.150
   122.341  1229.992     0.150
   122.341  1732.594     0.150
   122.400  1132.305     0.150
   122.400  1124.523     0.150
   123.412  1132.008     0.150
   123.969  1137.555     0.150
   124.778  1133.758     0.150
   124.778  1716.102     0.150
   125.521  1137.070     0.150
   125.521  1350.867     0.150
   125.521  1135.961     0.150
   125.521  1135.961     0.150
   126.456  1138.648     0.150
   126.456  1142.898     0.150
   126.574  1140.438     0.150
   126.574  1137.594     0.150
   127.809  1141.719     0.150
   127.809  1136.359     0.150
   127.809  1136.359     0.150
   127.892  1143.250     0.150
   127.892  1273.406     0.150
   127.892  1141.398     0.150
   127.892  1140.484     0.150
   127.892  1150.359     0.150
   127.892  1150.359     0.150
   130.330  1146.094     0.150
   130.330  1287.914     0.150
   130.626  1149.609     0.150
   130.626  1285.148     0.150
   130.626  1346.547     0.150
   130.748  1149.727     0.150
   132.347  1152.969     0.150
   132.421  1139.047     0.150
   132.421  1140.211     0.150
   132.421  1150.734     0.150
   132.421  1301.008     0.150
   132.421  1359.508     0.150
   133.049  1150.609     0.150
   133.049  1306.234     0.150
   133.049  1362.383     0.150
   134.568  1153.844     0.150
   134.568  1156.234     0.150
   134.568  1365.008     0.150
   134.568  1153.867     0.150
   136.025  1152.789     0.150
   136.025  1158.828     0.150
   138.755  1150.938     0.150
   138.755  1157.500     0.150
   139.811  1162.430     0.150
   139.811  1162.469     0.150
   141.355  1169.875     0.150
   141.702  1170.438     0.150
   142.175  1169.320     0.150
   142.635  1163.266     0.150
   142.635  1360.664     0.150
   142.635  2786.266     0.150
   142.987  1171.570     0.150
   143.231  1168.289     0.150
   143.231  1171.938     0.150
   143.245  1171.414     0.150
   143.245  1386.539     0.150
   143.245  1173.438     0.150
   144.696  1171.141     0.150
   144.710  1173.438     0.150
   145.283  1175.117     0.150
   145.631  1174.938     0.150
   146.244  1174.219     0.150
   146.244  1175.953     0.150
   146.244  1175.062     0.150
   146.892  1177.664     0.150
   146.892  1386.805     0.150
   147.307  1179.805     0.150
   147.379  1179.430     0.150
   147.472  1178.617     0.150
   147.472  1179.016     0.150
   147.472  1179.984     0.150
   148.108  1180.867     0.150
   148.135  1181.680     0.150
   148.231  1181.750     0.150
   148.426  1182.047     0.150
   149.252  1183.367     0.150
   149.322  1183.180     0.150
   150.634  1185.797     0.150
   151.107  1186.148     0.150
   151.630  1186.898     0.150
   151.723  1189.680     0.150
   151.946  1186.711     0.150
   152.663  1188.398     0.150
   152.739  1188.398     0.150
   153.066  1189.516     0.150
   153.342  1191.344     0.150
   153.342  1188.016     0.150
   153.425  1188.961     0.150
   153.941  1190.461     0.150
   154.897  1191.961     0.150
   155.052  1191.211     0.150
   155.271  1196.250     0.150
   155.175  1192.711     0.150
   155.223  1193.914     0.150
   155.345  1194.727     0.150
   155.737  1189.766     0.150
   155.737  1193.945     0.150
   155.776  1192.797     0.150
   156.929  1195.219     0.150
   157.313  1190.844     0.150
   157.313  1440.914     0.150
   157.313  1190.867     0.150
   157.313  1196.500     0.150
   157.650  1195.859     0.150
   157.881  1197.461     0.150
   157.911  1196.500     0.150
   158.297  1196.820     0.150
   158.470  1196.820     0.150
   158.671  1197.773     0.150
   158.981  1198.734     0.150
   159.015  1198.094     0.150
   159.159  1197.461     0.150
   159.427  1197.461     0.150
   159.629  1200.016     0.150
   159.705  1199.469     0.150
   160.028  1198.930     0.150
   160.220  1198.070     0.150
   160.587  1198.766     0.150
   160.787  1199.414     0.150
   161.213  1199.414     0.150
   161.562  1201.344     0.150
   162.625  1202.211     0.150
   163.136  1202.430     0.150
   163.272  1201.570     0.150
   163.527  1203.289     0.150
     0.353     7.953     0.150
     1.100    19.602     0.150
     3.194    49.898     0.150
     3.194    89.203     0.150
     3.789    56.102     0.150
     5.016   129.000     0.150
     6.725   101.297     0.150
     7.406   111.750     0.150
    11.943   169.602     0.150
    12.792   179.602     0.150
    12.858   180.703     0.150
    14.859   210.273     0.150
    31.054  2379.430     0.150
    31.064  2380.672     0.150
    31.072  2380.836     0.150
    31.921  2438.633     0.150
    31.925  2439.211     0.150
    31.939  2444.906     0.150
    41.703   466.102     0.150
    41.905   467.898     0.150
    42.976   476.898     0.150
    43.307   479.000     0.150
    44.336   488.367     0.150
    44.807   491.797     0.150
    46.743   506.156     0.150
    47.275   511.820     0.150
    47.290   510.602     0.150
    47.290   510.602     0.150
    47.448   511.898     0.150
    48.364   519.203     0.150
    48.364   519.203     0.150
    50.824   537.000     0.150
    53.776   559.398     0.150
    53.878   559.078     0.150
    56.318   577.281     0.150
    62.530   621.602     0.150
    65.095   637.398     0.150
    66.619   649.867     0.150
    67.898   656.898     0.150
    69.916   666.820     0.150
    70.145   668.703     0.150
    70.157   668.797     0.150
    70.157   668.812     0.150
    71.101   676.398     0.150
    71.688   680.000     0.150
    73.576   690.602     0.150
    75.862   704.000     0.150
    75.944   704.602     0.150
    76.893   709.703     0.150
    76.929   709.398     0.150
    77.993   715.297     0.150
     0.428    10.359     0.150
     0.816    24.891     0.150
     0.905    17.617     0.150
     0.905    30.320     0.150
     0.994    17.547     0.150
     1.092    31.789     0.150
     1.092    18.961     0.150
     1.192    22.586     0.150
     1.192    39.227     0.150
     1.658    26.211     0.150
     1.658    26.016     0.150
     1.658    26.258     0.150
     3.272    91.859     0.150
     4.454    66.461     0.150
     5.099    76.758     0.150
     6.628   100.117     0.150
     7.388   108.156     0.150
     7.770   116.758     0.150
     8.370   124.062     0.150
    10.814   159.562     0.150
    11.872   173.406     0.150
    12.060   175.859     0.150
    12.618   185.359     0.150
    12.794   186.859     0.150
    12.794   184.242     0.150
    14.953   211.461     0.150
    14.953   207.961     0.150
    15.359   214.961     0.150
    15.415   209.438     0.150
    15.415   370.133     0.150
    17.917   247.258     0.150
    18.825    10.398     0.150
    18.825    20.203     0.150
    19.460   265.586     0.150
    20.824   279.758     0.150
    23.836   309.359     0.150
    23.835    12.203     0.150
    23.835    21.500     0.150
    23.835   566.258     0.150
    28.738   353.461     0.150
    31.032  2335.219     0.150
    31.042  2335.711     0.150
    31.049  2354.523     0.150
    31.897  2407.250     0.150
    31.900  2405.938     0.150
    31.914  2406.398     0.150
    37.319   431.180     0.150
    37.319   430.688     0.150
    38.193   438.180     0.150
    39.411   443.359     0.150
    39.560     8.703     0.150
    39.560    12.305     0.150
    41.001   460.297     0.150
    41.294   462.805     0.150
    41.704   466.062     0.150
    42.429   468.555     0.150
    42.883   474.797     0.150
    42.989   476.961     0.150
    43.237   479.062     0.150
    44.604   490.047     0.150
    44.722   490.156     0.150
    45.214   491.695     0.150
    45.321   495.828     0.150
    46.079   501.406     0.150
    47.311   510.758     0.150
    50.825   537.062     0.150
    52.555   550.258     0.150
    57.841   588.359     0.150
    62.549   620.461     0.150
    63.938   629.656     0.150
    65.182   637.656     0.150
    65.182   634.750     0.150
    65.532   638.977     0.150
    67.637   654.961     0.150
    68.184   904.758     0.150
    68.184  1252.062     0.150
    69.053   661.227     0.150
    69.257   662.656     0.150
    69.257   663.062     0.150
    69.495   664.406     0.150
    69.488   664.680     0.150
    69.944   667.797     0.150
    70.186   668.758     0.150
    70.198   668.859     0.150
    70.291   669.422     0.150
    71.488   676.758     0.150
    72.344   681.789     0.150
    72.383   682.461     0.150
    73.723   690.062     0.150
    74.230   693.758     0.150
    74.680   695.359     0.150
    74.780   698.562     0.150
    74.828   699.906     0.150
    74.828   699.859     0.150
    75.048   696.336     0.150
    75.517   700.438     0.150
    75.517   700.461     0.150
    75.951   704.164     0.150
    75.951   704.156     0.150
    75.994   703.656     0.150
    75.992   703.758     0.150
    76.507   706.156     0.150
    76.507   716.156     0.150
    76.539   707.758     0.150
    76.944   709.258     0.150
    76.944   709.258     0.150
    76.981   710.156     0.150
    77.007   710.258     0.150
    77.376   711.758     0.150
    78.007   716.258     0.150
    78.044   715.961     0.150
    78.434   718.461     0.150
    80.459   729.867     0.150
    80.871   730.383     0.150
    80.975   731.094     0.150
    88.005   765.844     0.150
    88.828   770.203     0.150
    88.997   770.805     0.150
   146.091  1174.469     0.150
   150.522  1189.359     0.150
     0.804    14.969     0.150
     0.942    18.023     0.150
     2.127    31.047     0.150
     6.891   102.789     0.150
    41.627   463.352     0.150
    42.393   471.258     0.150
    42.705   472.594     0.150
    42.882   475.492     0.150
    47.133   507.742     0.150
    67.486   651.320     0.150
    70.008   670.023     0.150
    75.351   698.898     0.150
    76.808   707.188     0.150
    77.896   709.594     0.150
    78.574   715.305     0.150
     0.087     5.844     0.150
     1.126    20.164     0.150
     2.029    31.000     0.150
    31.086  2272.062     0.150
    31.096  2274.500     0.150
    31.104  2275.984     0.150
    31.955  2335.477     0.150
    31.959  2336.344     0.150
    31.973  2335.961     0.150
    41.687   464.023     0.150
    41.687   464.375     0.150
    41.745   462.797     0.150
    41.889   465.555     0.150
    47.209   508.078     0.150
    71.317   673.688     0.150
    77.932   712.461     0.150
     0.481    11.078     0.150
     0.727    14.422     0.150
     1.029    31.812     0.150
     1.463    44.758     0.150
     1.463    22.859     0.150
     6.824   102.383     0.150
    31.087  2339.188     0.150
    31.098  2342.484     0.150
    31.105  2342.102     0.150
    31.957  2402.719     0.150
    31.961  2403.289     0.150
    31.975  2403.195     0.150
    41.691   463.352     0.150
    43.612   477.008     0.150
    43.896   479.000     0.150
    44.531   489.531     0.150
    45.888   495.719     0.150
    48.711   517.648     0.150
    56.997   581.523     0.150
    69.091   662.172     0.150
    76.743   705.562     0.150
   144.667  1169.258     0.150
   145.941  1172.773     0.150
     7.378   111.344     0.150
    11.960   179.188     0.150
    31.106  2377.750     0.150
    31.116  2378.359     0.150
    31.124  2379.094     0.150
    31.975  2442.781     0.150
    31.978  2440.109     0.150
    31.992  2444.086     0.150
     0.674    21.820     0.150
     1.117    20.297     0.150
     1.117    19.859     0.150
     3.156    88.461     0.150
     3.756    55.859     0.150
     3.756    98.156     0.150
     4.309    65.758     0.150
     4.525    67.758     0.150
     4.974    77.555     0.150
     8.197   120.055     0.150
     8.267   122.914     0.150
     9.166   129.055     0.150
     9.654   142.859     0.150
    11.976   170.656     0.150
    12.580   179.961     0.150
    12.932   185.758     0.150
    12.932   184.305     0.150
    14.809   204.555     0.150
    15.216   215.758     0.150
    15.553   210.156     0.150
    15.553   368.961     0.150
    17.768   245.656     0.150
    17.768   249.961     0.150
    19.515   264.961     0.150
    20.193   271.758     0.150
    21.266   287.156     0.150
    21.468   294.055     0.150
    23.879   307.258     0.150
    24.956   320.859     0.150
    27.161     9.000     0.150
    28.588   356.758     0.150
    29.991    10.805     0.150
    31.075  2380.305     0.150
    31.085  2379.773     0.150
    31.093  2381.578     0.150
    31.708   382.656     0.150
    31.944  2440.258     0.150
    31.948  2440.352     0.150
    31.961  2444.242     0.150
    37.662   434.461     0.150
    38.686   441.203     0.150
    40.174   452.633     0.150
    41.654   462.930     0.150
    41.693   465.555     0.150
    42.722   474.102     0.150
    42.961   476.055     0.150
    43.339   480.055     0.150
    45.243   492.641     0.150
    45.720   499.352     0.150
    46.803   507.859     0.150
    47.270   510.961     0.150
    47.835   513.758     0.150
    48.357   520.359     0.150
    50.566   534.758     0.150
    50.815   536.258     0.150
    50.872   537.602     0.150
    52.496   550.461     0.150
    52.496   550.461     0.150
    52.496  1202.859     0.150
    55.778   575.758     0.150
    56.060   576.758     0.150
    63.865   629.758     0.150
    65.043   636.961     0.150
    66.697   652.258     0.150
    67.575   654.758     0.150
    67.575   654.016     0.150
    69.483   921.055     0.150
    69.483  1668.156     0.150
    70.114   668.461     0.150
    70.126   667.859     0.150
    72.315   680.648     0.150
    72.315   680.656     0.150
    72.897   684.961     0.150
    73.148   686.180     0.150
    74.159   693.656     0.150
    74.512   695.602     0.150
    74.585   693.656     0.150
    74.598   695.258     0.150
    74.713   697.258     0.150
    74.762   699.617     0.150
    74.762   699.656     0.150
    75.363   701.359     0.150
    75.376   700.461     0.150
    75.445   699.664     0.150
    75.532   701.227     0.150
    75.868   703.859     0.150
    75.908   702.820     0.150
    76.082   707.266     0.150
    76.231   705.148     0.150
    76.416   706.055     0.150
    76.431   710.438     0.150
    76.620   708.758     0.150
    76.821   707.914     0.150
    76.929   710.055     0.150
    76.937   708.594     0.150
    76.937   708.555     0.150
    77.921   715.359     0.150
    77.957   715.359     0.150
    77.957   724.555     0.150
    78.008   717.016     0.150
    78.010   717.031     0.150
    78.139   715.758     0.150
    78.300   717.898     0.150
    78.718   720.172     0.150
    78.926   720.156     0.150
    78.926   720.164     0.150
    79.096   722.383     0.150
    80.072   725.617     0.150
    80.196   728.172     0.150
    80.232   728.664     0.150
    80.225   729.406     0.150
    80.371   729.219     0.150
    80.385   729.562     0.150
    80.433   729.641     0.150
    80.783   731.359     0.150
    80.886   731.836     0.150
    82.344   736.969     0.150
    85.906   756.430     0.150
    86.222   757.047     0.150
    86.222   757.055     0.150
    86.365   759.055     0.150
   146.788 10986.789     0.150
   146.802 10986.352     0.150
   146.804 10986.766     0.150
     0.029     5.695     0.150
    31.054  2379.109     0.150
    31.065  2377.812     0.150
    31.072  2378.477     0.150
    31.922  2439.766     0.150
    31.926  2436.656     0.150
    31.939  2440.750     0.150
    44.608   487.062     0.150
    64.070   628.086     0.150
    69.161   659.906     0.150
    69.186   660.844     0.150
     0.018     5.805     0.150
     0.692    23.438     0.150
     0.741    24.555     0.150
     1.086    18.336     0.150
     1.587    26.633     0.150
     3.206    52.039     0.150
     3.206    90.633     0.150
     3.798    55.836     0.150
     4.387    66.039     0.150
     4.387   115.234     0.150
     5.029   128.336     0.150
     6.702    94.938     0.150
     7.413   108.234     0.150
    12.645   178.133     0.150
    15.285   211.133     0.150
    15.476   216.617     0.150
    20.777   278.336     0.150
    20.777   278.336     0.150
    22.675    10.102     0.150
    24.974   320.633     0.150
    28.667   354.133     0.150
    31.037  2339.172     0.150
    31.048  2340.062     0.150
    31.055  2343.789     0.150
    31.905  2405.828     0.150
    31.908  2407.938     0.150
    31.922  2410.914     0.150
    38.647   441.297     0.150
    38.943   445.836     0.150
    41.715   465.438     0.150
    42.991   476.133     0.150
    43.298   478.539     0.150
    47.142   507.156     0.150
    47.306   510.133     0.150
    50.836   536.938     0.150
    52.541   550.734     0.150
    52.541   550.734     0.150
    52.541   997.539     0.150
    52.541  1213.133     0.150
    63.916   629.438     0.150
    67.612   651.234     0.150
    68.159   654.828     0.150
    68.159   654.828     0.150
    68.159    21.461     0.150
    68.159   810.148     0.150
    68.159   904.328     0.150
    68.159  1462.734     0.150
    68.159  1654.656     0.150
    68.159   654.734     0.150
    68.159   676.234     0.150
    68.159   810.133     0.150
    68.159   904.234     0.150
    68.159  1193.633     0.150
    68.159  1462.734     0.150
    76.475   705.633     0.150
     0.834    29.555     0.150
     1.039    29.273     0.150
     1.118    20.125     0.150
     3.147    88.422     0.150
     4.298    66.320     0.150
     4.298   113.125     0.150
     4.525    67.523     0.150
     7.410   105.922     0.150
     8.187   116.625     0.150
    11.986   169.727     0.150
    12.543   171.023     0.150
    12.943   184.250     0.150
    14.798   207.625     0.150
    19.521   264.125     0.150
    21.265   297.922     0.150
    22.688     9.703     0.150
    24.958   320.727     0.150
    25.401   324.523     0.150
    28.577   357.125     0.150
    29.997   360.422     0.150
    29.997    15.305     0.150
    31.712     9.500     0.150
    36.595   430.320     0.150
    38.932     8.602     0.150
    39.133   442.297     0.150
    41.694   465.820     0.150
    41.694   465.422     0.150
    41.694   465.422     0.150
    42.405   472.125     0.150
    42.733   475.844     0.150
    42.960   476.320     0.150
    45.011   493.203     0.150
    46.481   504.625     0.150
    47.268   510.820     0.150
    47.443   511.922     0.150
    48.196   517.422     0.150
    48.358   518.820     0.150
    48.358   518.820     0.150
    50.816   536.727     0.150
    51.976   546.023     0.150
    52.493   549.922     0.150
    52.493  1211.820     0.150
    53.419   556.820     0.150
    53.773   558.922     0.150
    55.936   574.125     0.150
    56.148   575.023     0.150
    57.031   582.297     0.150
    57.031   582.320     0.150
    63.861   628.727     0.150
    63.861   638.320     0.150
    64.033   629.523     0.150
    65.033   636.820     0.150
    67.573   653.922     0.150
    68.100   905.422     0.150
    71.048   674.625     0.150
    72.348   683.320     0.150
    73.384   688.047     0.150
    73.384   688.023     0.150
    73.798   690.922     0.150
    74.593   695.523     0.150
    75.443   700.227     0.150
    75.863   702.727     0.150
    76.411   705.523     0.150
    77.951   714.094     0.150
    77.951   714.523     0.150
    78.636   717.477     0.150
    78.681   719.938     0.150
    79.091   720.570     0.150
    80.227   728.281     0.150
    80.653   729.625     0.150
    80.778   729.430     0.150
    81.095   731.227     0.150
     0.704    21.070     0.150
     0.687    22.508     0.150
     6.760   101.711     0.150
    31.059  2379.047     0.150
    31.070  2379.766     0.150
    31.077  2377.664     0.150
    31.928  2440.789     0.150
    31.931  2441.375     0.150
    31.945  2442.055     0.150
    38.627   570.219     0.150
    47.018   506.602     0.150
    47.628   511.828     0.150
    54.742   566.102     0.150
    69.174   661.000     0.150
     0.070     6.164     0.150
     0.663    21.383     0.150
     0.700    21.203     0.150
     0.844    16.797     0.150
     0.844    27.320     0.150
     1.099    18.789     0.150
     1.099    33.391     0.150
     1.099    20.289     0.150
     1.454    23.828     0.150
     1.506    25.492     0.150
     1.722    29.297     0.150
     1.791    52.219     0.150
     2.010    31.719     0.150
     2.554    40.180     0.150
     2.618    74.172     0.150
     2.636    42.680     0.150
     3.141    87.391     0.150
     3.739    55.492     0.150
     3.739    96.891     0.150
     4.310    65.391     0.150
     4.543    66.992     0.150
     5.436    80.922     0.150
     5.547    82.641     0.150
     5.719    85.680     0.150
     6.400   172.391     0.150
     6.784    99.891     0.150
     6.784   100.750     0.150
     7.427   106.789     0.150
     7.435  2575.391     0.150
     7.651   111.078     0.150
     8.200   215.992     0.150
     8.200   119.688     0.150
     8.200   215.992     0.150
     8.524   124.094     0.150
     8.832   129.594     0.150
     8.943   128.188     0.150
     8.983   131.938     0.150
     9.186   245.688     0.150
     9.186   252.188     0.150
     9.186   133.047     0.150
     9.245   131.969     0.150
     9.670   241.414     0.150
     9.670   137.594     0.150
     9.700   241.062     0.150
    10.317   150.914     0.150
    10.513   150.789     0.150
    10.896   273.289     0.150
    11.993   308.742     0.150
    11.993   169.492     0.150
    12.110   173.992     0.150
    12.110   181.391     0.150
    12.110   308.688     0.150
    12.841   182.594     0.150
    12.841   180.750     0.150
    12.841   180.594     0.150
    12.841   183.344     0.150
    12.910   183.188     0.150
    12.943   184.289     0.150
    12.943   185.891     0.150
    12.943   186.664     0.150
    13.424   193.289     0.150
    13.659   194.992     0.150
    13.659   194.891     0.150
    14.757   207.594     0.150
    14.800   205.312     0.150
    15.206   372.891     0.150
    15.206   212.594     0.150
    15.206   372.891     0.150
    15.549   206.789     0.150
    15.549   372.016     0.150
    15.860   401.688     0.150
    16.768   231.492     0.150
    17.767   244.188     0.150
    17.767   244.188     0.150
    18.871    15.703     0.150
    18.871   463.188     0.150
    19.366   265.688     0.150
    19.535   262.992     0.150
    20.211   270.492     0.150
    20.716   506.391     0.150
    21.284   297.789     0.150
    21.284   312.188     0.150
    21.284   520.594     0.150
    23.898    15.898     0.150
    23.985   307.891     0.150
    24.352    11.703     0.150
    24.352    18.203     0.150
    24.352   576.188     0.150
    24.419   315.055     0.150
    24.419   315.055     0.150
    24.975   319.961     0.150
    24.975   319.789     0.150
    24.975   319.992     0.150
    25.650   324.688     0.150
    26.951   352.891     0.150
    27.180    13.398     0.150
    27.572   341.992     0.150
    27.572   617.391     0.150
    28.585   352.492     0.150
    28.585   363.289     0.150
    30.011    10.805     0.150
    30.841   374.430     0.150
    31.728   379.789     0.150
    35.937     8.000     0.150
    35.937    12.000     0.150
    36.588   421.289     0.150
    36.610     9.602     0.150
    38.059   434.898     0.150
    38.949     9.805     0.150
    39.841   448.992     0.150
    39.841   811.789     0.150
    40.115   452.188     0.150
    41.139   461.164     0.150
    41.914   466.594     0.150
    41.914   581.289     0.150
    42.419   471.117     0.150
    42.419   471.117     0.150
    42.419   851.203     0.150
    42.419   471.992     0.150
    42.419   472.852     0.150
    42.711   474.219     0.150
    42.733   474.570     0.150
    42.733   472.492     0.150
    42.757   486.289     0.150
    42.979   475.211     0.150
    42.979   475.398     0.150
    43.059   476.312     0.150
    43.356   478.891     0.150
    43.734   482.797     0.150
    43.931   482.391     0.150
    44.147   484.492     0.150
    44.147   484.500     0.150
    44.147   484.594     0.150
    44.147   484.570     0.150
    44.176   484.391     0.150
    44.747   489.289     0.150
    44.525   487.188     0.150
    44.525   880.891     0.150
    44.857   489.891     0.150
    45.117   491.891     0.150
    45.226   492.789     0.150
    45.226   891.188     0.150
    45.466   495.219     0.150
    45.507   494.891     0.150
    45.568   495.492     0.150
    45.740   498.141     0.150
    45.793   498.391     0.150
    46.207   500.594     0.150
    46.233   502.492     0.150
    46.233   502.492     0.150
    46.446   502.391     0.150
    46.499   503.891     0.150
    46.499   598.492     0.150
    46.472   502.891     0.150
    46.472   502.891     0.150
    46.563   503.391     0.150
    46.641   503.891     0.150
    46.807   506.688     0.150
    46.994   506.742     0.150
    47.287   509.219     0.150
    47.287   920.758     0.150
    47.287   508.891     0.150
    47.287   509.609     0.150
    47.461   511.391     0.150
    47.718   511.992     0.150
    47.854   514.188     0.150
    47.954   513.992     0.150
    48.064   517.891     0.150
    48.214   516.992     0.150
    48.214   603.891     0.150
    48.376   517.992     0.150
    48.376   517.992     0.150
    48.376   937.281     0.150
    48.376   937.281     0.150
    48.376   518.188     0.150
    48.376   518.188     0.150
    48.697    15.297     0.150
    49.212   523.938     0.150
    49.859   530.594     0.150
    50.280   534.594     0.150
    50.834   536.492     0.150
    51.312   541.094     0.150
    51.579   543.672     0.150
    51.579   542.594     0.150
    51.579   543.688     0.150
    51.591   542.289     0.150
    51.993   544.992     0.150
    52.170   548.094     0.150
    52.512   548.891     0.150
    52.512   549.062     0.150
    52.512   549.047     0.150
    53.436   556.289     0.150
    53.791   558.289     0.150
    53.892   559.000     0.150
    54.156   561.594     0.150
    54.399   561.492     0.150
    54.549   563.188     0.150
    54.745   565.641     0.150
    55.263   569.492     0.150
    55.182   567.992     0.150
    55.262   569.500     0.150
    55.453   569.891     0.150
    55.953   574.016     0.150
    55.953  1037.547     0.150
    55.953   573.492     0.150
    56.138   575.992     0.150
    56.365   578.188     0.150
    57.174   581.992     0.150
    57.180   583.648     0.150
    57.752   642.391     0.150
    58.343   590.391     0.150
    60.195   601.391     0.150
    60.546     8.711     0.150
    62.324   617.242     0.150
    62.576   620.094     0.150
    62.704   620.391     0.150
    62.870   623.234     0.150
    62.956   622.594     0.150
    63.588   625.789     0.150
    63.880   627.891     0.150
    63.880   627.891     0.150
    63.880   627.969     0.150
    64.116   630.609     0.150
    64.116   630.492     0.150
    64.298   628.094     0.150
    64.587   633.992     0.150
    65.047   636.094     0.150
    65.454   637.773     0.150
    66.752   647.602     0.150
    66.802   647.336     0.150
    67.592   653.125     0.150
    67.592   653.383     0.150
    67.592   653.391     0.150
    67.729   650.992     0.150
    68.118   905.188     0.150
    68.679   661.094     0.150
    68.740   660.789     0.150
    68.740   660.789     0.150
    68.757   659.391     0.150
    68.947   661.789     0.150
    68.995   660.711     0.150
    69.164   661.289     0.150
    69.434   664.891     0.150
    69.500   917.992     0.150
    69.895   667.383     0.150
    70.052   667.539     0.150
    70.129   667.742     0.150
    70.129   667.789     0.150
    70.141   667.391     0.150
    70.141   667.289     0.150
    70.141   667.688     0.150
    70.232   668.188     0.150
    70.232   668.273     0.150
    70.391   668.992     0.150
    70.439   669.789     0.150
    70.570   671.297     0.150
    70.681   672.391     0.150
    70.765   671.492     0.150
    70.765   671.750     0.150
    71.239   675.445     0.150
    71.448   676.562     0.150
    71.631   678.289     0.150
    72.114   680.688     0.150
    72.330   681.289     0.150
    72.966   686.594     0.150
    72.967   684.391     0.150
    73.375   687.789     0.150
    73.382   688.391     0.150
    73.375   687.898     0.150
    73.705   689.883     0.150
    73.816   690.789     0.150
    74.006   692.789     0.150
    74.191   693.188     0.150
    74.612   695.289     0.150
    74.728   696.391     0.150
    74.728   696.320     0.150
    74.777   696.891     0.150
    74.864   697.523     0.150
    74.919   698.094     0.150
    74.985   697.789     0.150
    75.338   700.492     0.150
    75.359   700.391     0.150
    75.379   699.922     0.150
    75.379   699.891     0.150
    75.462   700.188     0.150
    75.568  1964.789     0.150
    75.585   701.594     0.150
    75.587   701.391     0.150
    75.801   702.594     0.150
    75.820   702.703     0.150
    75.832   702.523     0.150
    75.832   702.891     0.150
    75.832   703.000     0.150
    75.840   702.789     0.150
    75.881   702.789     0.150
    75.881   702.688     0.150
    75.920   703.289     0.150
    75.922   703.688     0.150
    75.922   703.500     0.150
    75.934   703.289     0.150
    76.331   705.789     0.150
    76.331   705.781     0.150
    76.341  1968.688     0.150
    76.427   711.047     0.150
    76.427   705.492     0.150
    76.427   871.891     0.150
    76.427   705.453     0.150
    76.429   869.391     0.150
    76.429   704.992     0.150
    76.429   716.289     0.150
    76.429  1286.391     0.150
    76.429   704.992     0.150
    76.446   705.898     0.150
    76.464   706.289     0.150
    76.464   706.250     0.150
    76.526   706.891     0.150
    76.546   706.891     0.150
    76.633   707.688     0.150
    76.633   707.383     0.150
    76.871   708.594     0.150
    76.871   708.641     0.150
    76.883   709.289     0.150
    76.907   708.594     0.150
    76.907   708.688     0.150
    76.952   708.594     0.150
    77.088   709.789     0.150
    77.088   709.750     0.150
    77.299   711.492     0.150
    77.319   710.289     0.150
    77.319   710.453     0.150
    77.354   711.133     0.150
    77.891   714.391     0.150
    77.934   714.492     0.150
    77.970   714.688     0.150
    77.970   714.594     0.150
    77.987   713.891     0.150
    77.987   714.297     0.150
    78.190   715.102     0.150
    78.408   716.594     0.150
    78.530   717.094     0.150
    78.588   718.594     0.150
    78.588   718.695     0.150
    78.588   717.992     0.150
    78.694   718.188     0.150
    78.700   718.703     0.150
    78.731   718.852     0.150
    78.946   719.898     0.150
    78.946   719.828     0.150
    79.640   723.094     0.150
    79.694   723.750     0.150
    79.913   724.492     0.150
    79.936   725.188     0.150
    79.967   725.391     0.150
    80.149   724.164     0.150
    80.149   724.398     0.150
    80.217   725.891     0.150
    80.227   726.094     0.150
    80.227   726.828     0.150
    80.245   727.102     0.150
    47.513   726.320     0.150
    80.416   727.891     0.150
    80.510   727.570     0.150
    80.651   729.289     0.150
    80.899   730.398     0.150
    81.113   730.594     0.150
    81.409   732.594     0.150
    81.525   732.992     0.150
    84.557   748.688     0.150
    85.041   750.688     0.150
    85.966   755.891     0.150
    86.074  6352.289     0.150
    86.210   756.992     0.150
    86.213   756.789     0.150
    87.580   764.203     0.150
    87.884   765.289     0.150
    88.276   765.570     0.150
    88.302   766.891     0.150
    88.884   772.141     0.150
    89.359   772.188     0.150
    89.991   775.188     0.150
    91.059  6788.992     0.150
    91.551   782.188     0.150
   101.571   829.219     0.150
   117.640  1122.492     0.150
   121.217  1127.688     0.150
   125.541  1137.594     0.150
   138.757  1150.320     0.150
   143.218  1167.703     0.150
   144.702  1172.078     0.150
   146.883  1177.648     0.150
   147.457  1179.188     0.150
   147.851  1178.273     0.150
   152.673  1191.992     0.150
   153.287  1206.188     0.150
   153.287  4785.188     0.150
   161.193  1239.391     0.150
     0.739    23.133     0.150
     1.387    24.484     0.150
    41.710   463.562     0.150
    54.756   565.023     0.150
    56.063   574.148     0.150
    69.007   660.133     0.150
    73.849   689.883     0.150
     1.192    18.281     0.150
     1.192    18.258     0.150
     4.906   125.859     0.150
     4.906    77.961     0.150
     4.906   134.562     0.150
     7.379   106.359     0.150
    12.024   174.156     0.150
    13.020   188.781     0.150
    41.640   464.562     0.150
    41.640   464.562     0.150
    42.895   476.156     0.150
    42.895   476.156     0.150
    42.974   476.133     0.150
    54.956   565.172     0.150
    58.767   593.758     0.150
    58.767   593.859     0.150
    66.555   647.359     0.150
    70.020   666.562     0.150
    75.767   702.359     0.150
     0.731    22.945     0.150
     1.399    41.055     0.150
     0.700    23.594     0.150
    11.962   188.859     0.150
    38.631   438.039     0.150
    41.707   464.203     0.150
    41.707   464.055     0.150
    54.746   565.633     0.150
    69.159   661.445     0.150
    69.183   661.711     0.150
     0.697    23.281     0.150
    25.390   321.969     0.150
    46.213   500.297     0.150
    54.722   565.562     0.150
    59.304   596.305     0.150
     1.197    21.141     0.150
     1.390    23.820     0.150
     4.183    63.523     0.150
     4.183   111.422     0.150
     4.908    74.922     0.150
     7.373   105.820     0.150
     9.562   133.820     0.150
    14.640   212.523     0.150
    19.512   263.820     0.150
    20.586   276.625     0.150
    28.469   352.227     0.150
    41.635   464.625     0.150
    42.890   475.227     0.150
    47.189   511.023     0.150
    52.404   549.023     0.150
    62.829   621.570     0.150
    63.765   628.227     0.150
    67.513   653.023     0.150
    67.513   653.023     0.150
    68.000   902.727     0.150
    69.399   917.820     0.150
    69.399  1213.320     0.150
    69.399  1471.320     0.150
    70.026   667.625     0.150
    74.060   692.625     0.150
    75.761   703.023     0.150
    75.819   702.820     0.150
    76.306    17.102     0.150
    76.306   704.922     0.150
    76.967   709.523     0.150
    77.204   710.422     0.150
    77.813   715.625     0.150
    77.813   715.625     0.150
    77.848   714.422     0.150
    77.905   714.773     0.150
     0.013     5.680     0.150
     0.742    23.750     0.150
     1.093    30.703     0.150
    54.755   565.547     0.150
    31.092  2378.665     0.150
    31.103  2379.497     0.150
    31.110  2380.127     0.150
    31.962  2442.385     0.150
    31.965  2446.577     0.150
    31.979  2445.287     0.150
    41.677   464.265     0.150
    54.710   565.499     0.150
     0.505    17.908     0.150
     0.681    21.917     0.150
     0.753    22.897     0.150
     1.152    19.928     0.150
    31.110  2377.850     0.150
    31.121  2380.160     0.150
    31.128  2380.704     0.150
    31.979  2409.659     0.150
    31.983  2408.500     0.150
    31.996  2412.648     0.150
    41.658   462.790     0.150
    43.004   473.035     0.150
    44.576   486.218     0.150
    47.184   505.604     0.150
    64.007   627.418     0.150
    86.376   757.773     0.150
     0.747    24.219     0.150
     1.093    31.999     0.150
     6.699   101.574     0.150
     7.405   186.509     0.150
    31.044  2378.398     0.150
    31.054  2379.136     0.150
    31.062  2379.451     0.150
    31.911  2436.567     0.150
    31.914  2441.382     0.150
    31.928  2438.181     0.150
    44.652   487.809     0.150
    69.215   661.390     0.150
    73.526   686.944     0.150
     1.089    19.076     0.150
     3.812    56.275     0.150
     4.400   120.275     0.150
     4.400    67.775     0.150
     5.044   136.676     0.150
     6.687    99.275     0.150
     9.700   138.676     0.150
    11.920   170.736     0.150
    11.920   170.775     0.150
    12.082   173.676     0.150
    14.798   207.377     0.150
    23.862    11.701     0.150
    23.862    16.900     0.150
    24.969   319.676     0.150
    25.412   325.477     0.150
    28.680   416.377     0.150
    31.038  2334.447     0.150
    31.049  2335.947     0.150
    31.056  2336.637     0.150
    31.905  2397.668     0.150
    31.909  2403.275     0.150
    31.922  2401.045     0.150
    37.684   431.477     0.150
    41.912   466.977     0.150
    47.305   511.275     0.150
    47.453   512.076     0.150
    49.308   525.676     0.150
    49.947   531.076     0.150
    50.831   537.275     0.150
    50.831   537.275     0.150
    53.780   559.176     0.150
    63.919   630.275     0.150
    63.919   862.775     0.150
    67.611   653.576     0.150
    67.630   651.926     0.150
    67.630   654.775     0.150
    75.612   702.977     0.150
    76.480   706.275     0.150
    78.018   714.576     0.150
   144.601  1170.598     0.150
   146.149  1175.893     0.150
     9.806   139.715     0.150
    19.507   265.615     0.150
    31.150  2381.920     0.150
    31.161  2382.336     0.150
    31.168  2367.553     0.150
    32.021  2446.713     0.150
    32.025  2435.777     0.150
    32.039  2448.195     0.150
    54.968   567.973     0.150
     1.134    31.863     0.150
     1.134    19.645     0.150
     1.134    31.844     0.150
     3.161    50.344     0.150
     3.161    88.045     0.150
     3.763    56.045     0.150
     4.977    74.045     0.150
     6.784   100.545     0.150
    13.627   193.645     0.150
    14.807   207.145     0.150
    21.178   282.045     0.150
    24.940   319.443     0.150
    25.384   324.744     0.150
    31.092  2379.088     0.150
    31.103  2379.607     0.150
    31.110  2380.174     0.150
    31.961  2442.482     0.150
    31.965  2444.006     0.150
    31.978  2445.527     0.150
    37.646   431.045     0.150
    41.677   465.645     0.150
    42.944   476.344     0.150
    42.944   476.344     0.150
    47.253   510.244     0.150
    47.754   512.984     0.150
    48.341   517.145     0.150
    48.341   517.145     0.150
    50.799   536.844     0.150
    63.848   766.344     0.150
    64.022   629.744     0.150
    65.030   638.045     0.150
    65.030   638.045     0.150
    69.106   663.145     0.150
    69.137   664.744     0.150
    70.097   670.744     0.150
    70.449   670.844     0.150
     0.196     7.840     0.150
     0.490    10.129     0.150
     0.490    16.430     0.150
     0.428    11.672     0.150
     0.554    12.172     0.150
     0.554    20.871     0.150
     0.732    23.832     0.150
     0.667    14.879     0.150
     0.667    26.469     0.150
     0.832    24.840     0.150
     0.938    18.391     0.150
     0.938    31.570     0.150
     1.068    20.379     0.150
     1.067    20.859     0.150
     1.224    22.121     0.150
     1.224    38.730     0.150
     2.102    35.832     0.150
    20.682   283.129     0.150
    21.104   281.430     0.150
    33.656   395.457     0.150
    33.842   395.746     0.150
    39.585   444.438     0.150
    39.641   445.680     0.150
    40.639   457.113     0.150
    40.643   456.574     0.150
    40.744   457.629     0.150
    41.355   460.832     0.150
    41.517   464.871     0.150
    41.926   467.699     0.150
    42.082   468.891     0.150
    42.206   470.469     0.150
    42.365   471.973     0.150
    42.457   472.723     0.150
    43.188   478.727     0.150
    43.598   478.883     0.150
    43.743   479.840     0.150
    43.743   479.832     0.150
    44.042   484.531     0.150
    44.446   486.797     0.150
    44.462   488.031     0.150
    44.599   490.016     0.150
    45.134   495.340     0.150
    45.274   494.789     0.150
    45.492   494.191     0.150
    47.268   507.340     0.150
    47.507   508.938     0.150
    48.364   519.438     0.150
    48.418   516.461     0.150
    48.798   519.551     0.150
    49.443   524.777     0.150
    49.485   525.117     0.150
    50.448   532.906     0.150
    50.755   535.695     0.150
    64.041   629.680     0.150
    66.505   648.020     0.150
    69.122   662.227     0.150
    69.143   662.230     0.150
    69.143   662.555     0.150
    70.932   673.531     0.150
    78.380   715.750     0.150
    78.862   717.883     0.150
    80.539   729.430     0.150
    86.240   759.832     0.150
    87.748   763.715     0.150
    88.570   766.398     0.150
    88.739   770.660     0.150
    89.472   771.258     0.150
    89.604   771.410     0.150
     6.707    93.609     0.150
    31.049  2352.336     0.150
    31.060  2366.570     0.150
    31.067  2367.508     0.150
    31.917  2442.648     0.150
    31.920  2442.258     0.150
    31.934  2443.641     0.150
    41.703   464.141     0.150
    44.644   487.469     0.150
    47.243   508.156     0.150
    62.634   618.898     0.150
    66.362   643.805     0.150
     7.382   112.602     0.150
    11.982   174.477     0.150
    31.115  2278.570     0.150
    31.125  2279.930     0.150
    31.133  2279.750     0.150
    31.985  2350.172     0.150
    31.988  2350.633     0.150
    32.002  2348.586     0.150
    38.573   440.695     0.150
    44.544   484.938     0.150
   146.282  1173.703     0.150
     0.920    17.992     0.150
     1.089    18.523     0.150
     3.205    46.023     0.150
     4.552    73.227     0.150
     5.028    78.328     0.150
     6.705    98.023     0.150
     7.410   104.062     0.150
     9.624   130.578     0.150
     9.624   240.125     0.150
     9.696   143.328     0.150
    11.934   294.133     0.150
    19.500   264.922     0.150
    21.263   284.625     0.150
    21.263   284.625     0.150
    24.971   320.625     0.150
    28.663   354.328     0.150
    28.663   414.922     0.150
    31.041  2339.391     0.150
    31.051  2340.297     0.150
    31.059  2340.805     0.150
    31.908  2409.008     0.150
    31.912  2409.805     0.150
    31.925  2410.312     0.150
    41.712   465.422     0.150
    42.987   475.422     0.150
    47.303   510.922     0.150
    48.372   519.625     0.150
    53.784   557.688     0.150
    53.784   557.727     0.150
    63.913   629.625     0.150
    63.913   860.422     0.150
    67.628   653.125     0.150
    67.628   653.125     0.150
    68.182   654.758     0.150
    69.189   662.125     0.150
    73.835   688.195     0.150
    73.852   691.422     0.150
    74.562   695.328     0.150
    74.650   694.977     0.150
    74.650   695.023     0.150
    75.605   702.727     0.150
    76.471   705.727     0.150
     0.379     8.164     0.150
     0.757    24.078     0.150
     1.087    18.609     0.150
     1.158    35.836     0.150
     3.220    82.008     0.150
     4.401    63.430     0.150
     4.401    63.211     0.150
     4.401   110.109     0.150
     5.044   128.211     0.150
     5.044   135.906     0.150
     6.686    97.305     0.150
     7.407   105.609     0.150
    24.971   320.109     0.150
    28.682   352.609     0.150
    28.682   413.906     0.150
    29.967   360.711     0.150
    29.967     8.695     0.150
    31.036  2377.328     0.150
    31.047  2378.141     0.150
    31.054  2378.703     0.150
    31.903  2442.156     0.150
    31.907  2443.641     0.150
    31.920  2444.609     0.150
    39.355   447.445     0.150
    39.838   450.180     0.150
    41.658   465.711     0.150
    41.712   465.109     0.150
    41.914   465.531     0.150
    41.914   465.508     0.150
    42.127   470.445     0.150
    42.825   474.109     0.150
    43.285   477.406     0.150
    43.945   483.711     0.150
    45.107   493.156     0.150
    46.565   506.336     0.150
    47.309   511.188     0.150
    47.307   509.711     0.150
    48.371   518.906     0.150
    50.833   535.805     0.150
    50.833   536.406     0.150
    51.482   537.805     0.150
    53.782   558.305     0.150
    62.612   620.008     0.150
    63.921   628.805     0.150
    63.921   861.609     0.150
    64.051   629.305     0.150
    65.134   637.406     0.150
    66.339   645.211     0.150
    67.613   652.805     0.150
    67.632   653.211     0.150
    74.570   695.305     0.150
    74.570   695.211     0.150
    74.659   695.406     0.150
    75.929   703.406     0.150
    76.482   705.109     0.150
    78.020   714.906     0.150
    78.491   717.609     0.150
    78.780   718.047     0.150
    85.168   748.984     0.150
     1.093    32.816     0.150
     1.146    20.707     0.150
     3.144    87.407     0.150
     3.748    55.707     0.150
     4.269    65.007     0.150
     4.498    64.807     0.150
     4.957   134.307     0.150
     6.812   102.367     0.150
     8.157   214.707     0.150
     9.149   127.707     0.150
     9.149   247.106     0.150
     9.621   137.606     0.150
     9.738   139.682     0.150
     9.738   242.082     0.150
    11.986   169.807     0.150
    12.077   174.207     0.150
    12.764   186.407     0.150
    13.631   195.707     0.150
    17.731   244.826     0.150
    19.509   264.807     0.150
    20.194   270.606     0.150
    20.667   283.106     0.150
    20.667   300.707     0.150
    20.667   529.907     0.150
    20.667   535.308     0.150
    21.466   511.907     0.150
    24.934   320.106     0.150
    25.378   323.927     0.150
    29.985     9.199     0.150
    29.985    17.800     0.150
    31.105  2379.595     0.150
    31.116  2380.491     0.150
    31.123  2381.058     0.150
    31.975  2443.591     0.150
    31.979  2444.093     0.150
    31.992  2442.835     0.150
    40.142   451.336     0.150
    41.872   466.606     0.150
    43.013   811.981     0.150
    43.162   477.241     0.150
    43.347   479.507     0.150
    43.590   482.007     0.150
    43.555   479.870     0.150
    43.830   482.007     0.150
    43.913   483.106     0.150
    44.125   485.106     0.150
    44.125   485.116     0.150
    44.546   488.407     0.150
    45.347   493.694     0.150
    46.972   507.157     0.150
    47.240   510.007     0.150
    47.240   510.007     0.150
    48.335   518.507     0.150
    48.335   518.616     0.150
    48.443   518.044     0.150
    50.792   536.808     0.150
    53.751   558.606     0.150
    56.025   576.706     0.150
    62.744   621.407     0.150
    63.830   628.007     0.150
    64.000   629.606     0.150
    64.580   634.507     0.150
    64.683   634.606     0.150
    69.452  1481.407     0.150
    69.452  1654.808     0.150
    70.091   668.308     0.150
    74.124   691.917     0.150
    74.236   694.007     0.150
    75.350   700.106     0.150
    75.350   700.017     0.150
    76.290   705.808     0.150
    76.378   705.606     0.150
    77.919   714.007     0.150
    78.906   720.106     0.150
    80.643   729.507     0.150
    81.270   734.007     0.150
    81.475   733.907     0.150
    86.194   757.808     0.150
    92.358   788.729     0.150
     1.144    20.453     0.150
     1.144    19.754     0.150
     2.072    34.055     0.150
     2.072    34.004     0.150
     3.114    47.953     0.150
     3.114    86.855     0.150
     3.720    97.055     0.150
     4.243    64.555     0.150
     4.503    65.652     0.150
     4.927   135.453     0.150
     4.958    73.055     0.150
     6.842   101.254     0.150
     7.405   106.652     0.150
     8.132   122.652     0.150
     8.132   219.855     0.150
     8.226   117.855     0.150
     9.163   137.652     0.150
     9.619   137.855     0.150
    12.093   174.152     0.150
    12.795   186.555     0.150
    12.987   187.055     0.150
    12.987   184.828     0.150
    13.652   201.152     0.150
    15.617   214.652     0.150
    19.530   263.953     0.150
    20.220   271.055     0.150
    20.650   523.055     0.150
    24.944   319.855     0.150
    25.388   324.055     0.150
    28.523   351.855     0.150
    28.523    15.199     0.150
    28.523    22.098     0.150
    35.968   421.555     0.150
    39.675    21.801     0.150
    39.807   449.555     0.150
    41.880   466.855     0.150
    41.880   466.844     0.150
    42.009   467.254     0.150
    42.399   474.754     0.150
    43.375   479.254     0.150
    44.496   487.555     0.150
    44.824   490.355     0.150
    45.196   493.355     0.150
    45.538   495.953     0.150
    46.176   500.652     0.150
    46.415   502.953     0.150
    46.470   503.355     0.150
    46.532   504.055     0.150
    46.609   504.254     0.150
    46.941   507.855     0.150
    47.242   510.055     0.150
    47.242   510.016     0.150
    47.431   511.953     0.150
    47.684   512.453     0.150
    47.922   514.652     0.150
    48.345   518.254     0.150
    48.670    13.602     0.150
    50.350   533.254     0.150
    50.801   536.453     0.150
    50.801   536.555     0.150
    51.278   541.652     0.150
    53.415   555.652     0.150
    53.762   558.453     0.150
    56.433   576.855     0.150
    56.976   581.055     0.150
    58.827   593.855     0.150
    62.770   621.480     0.150
    63.824   628.355     0.150
    63.824    21.297     0.150
    63.824   859.953     0.150
    64.979   636.254     0.150
    67.546   653.254     0.150
    67.546   653.254     0.150
    68.061   899.855     0.150
    68.703   659.152     0.150
    70.074   667.754     0.150
    70.086   668.355     0.150
    70.394   669.953     0.150
    71.008   673.453     0.150
    72.276   681.055     0.150
    73.483   688.754     0.150
    73.731   690.875     0.150
    73.760   690.555     0.150
    74.119   692.652     0.150
    74.246   693.266     0.150
    74.554   694.754     0.150
    74.675   695.254     0.150
    74.723   695.152     0.150
    74.723   695.055     0.150
    75.243   698.551     0.150
    75.306   698.832     0.150
    75.306   698.754     0.150
    75.793   702.152     0.150
    75.823   702.164     0.150
    75.823   702.254     0.150
    75.878   702.453     0.150
    75.878   701.965     0.150
    76.274   704.754     0.150
    76.283   703.254     0.150
    76.283   703.254     0.150
    76.367   700.766     0.150
    76.367   700.754     0.150
    76.368    11.398     0.150
    76.368   699.754     0.150
    76.392   704.758     0.150
    76.575   707.000     0.150
    76.575   706.332     0.150
    76.750   707.074     0.150
    76.897   707.836     0.150
    76.897   707.754     0.150
    76.927   708.398     0.150
    77.263   709.371     0.150
    77.263   709.355     0.150
    77.423   713.152     0.150
    77.853   712.758     0.150
    77.910   714.652     0.150
    77.910   714.652     0.150
    78.133   713.859     0.150
    78.917   719.555     0.150
    81.472   733.254     0.150
     1.999    34.117     0.150
    86.375   757.844     0.150
     1.146    20.438     0.150
     2.023    33.938     0.150
     3.162    50.641     0.150
     3.162    88.641     0.150
     4.287    65.438     0.150
     4.977   127.539     0.150
     6.778   104.238     0.150
     7.383   105.141     0.150
    17.750   245.539     0.150
    17.750   245.539     0.150
    21.169   287.539     0.150
    21.169   287.539     0.150
    22.662     8.098     0.150
    28.572   357.438     0.150
    28.572   356.539     0.150
    28.572   411.938     0.150
    29.183   347.039     0.150
    29.183   356.438     0.150
    31.104  2378.387     0.150
    31.115  2379.180     0.150
    31.122  2379.996     0.150
    31.973  2442.750     0.150
    31.977  2443.070     0.150
    31.991  2443.984     0.150
    42.741   474.039     0.150
    42.932   475.539     0.150
    43.011   811.246     0.150
    50.788   537.039     0.150
    62.725   621.039     0.150
    66.453   646.340     0.150
    67.546   659.641     0.150
    69.100   660.816     0.150
    69.124   660.867     0.150
    70.446   671.539     0.150
    73.394   689.539     0.150
    77.949   723.938     0.150
    14.770   208.836     0.150
    31.090  2381.148     0.150
    31.101  2380.000     0.150
    31.108  2382.570     0.150
    31.960  2445.016     0.150
    31.964  2445.133     0.150
    31.978  2444.367     0.150
     0.717    13.156     0.150
     0.697    13.266     0.150
    31.072  2341.687     0.150
    31.082  2336.641     0.150
    31.090  2339.293     0.150
    31.941  2397.707     0.150
    31.944  2401.207     0.150
    31.958  2400.148     0.150
    41.667   462.576     0.150
    43.980   481.727     0.150
    45.946   497.836     0.150
    50.815   537.596     0.150
     0.209     7.336     0.150
     0.179     8.266     0.150
     0.179    14.027     0.150
     0.499    10.199     0.150
     0.499    16.598     0.150
     0.442    12.086     0.150
     0.524    12.516     0.150
     0.524    21.008     0.150
     0.722    13.906     0.150
     0.722    23.707     0.150
     0.677    15.266     0.150
     0.677    27.066     0.150
     0.738    16.086     0.150
     0.854    14.707     0.150
     0.854    24.969     0.150
     0.928    18.789     0.150
     0.928    32.398     0.150
     1.076    20.578     0.150
     1.076    21.219     0.150
     1.077    21.105     0.150
     1.077    20.578     0.150
     1.077    21.777     0.150
     1.196    34.469     0.150
     1.193    22.406     0.150
     1.193    38.188     0.150
     1.389    25.254     0.150
     1.389    44.051     0.150
     1.390    25.148     0.150
     3.004    49.078     0.150
     3.004    85.676     0.150
     3.004    49.078     0.150
     3.004    86.277     0.150
     3.608    55.879     0.150
     3.608    96.676     0.150
     3.608    55.977     0.150
     4.207    64.777     0.150
     4.821    75.777     0.150
     4.821   136.078     0.150
     6.913   102.078     0.150
     6.913   102.836     0.150
     7.507   105.777     0.150
     8.104   118.578     0.150
     8.903   127.777     0.150
     9.264   138.777     0.150
     9.264   244.676     0.150
     9.264   257.379     0.150
     9.264   139.676     0.150
     9.810   244.176     0.150
    12.126   170.176     0.150
    12.198   175.176     0.150
    13.045   187.879     0.150
    13.045   189.137     0.150
    13.083   187.676     0.150
    13.083   187.203     0.150
    13.762   194.676     0.150
    14.662   207.652     0.150
    15.067   213.777     0.150
    15.639   209.352     0.150
    15.639   374.676     0.150
    15.977   402.977     0.150
    16.814   233.477     0.150
    17.652   246.477     0.150
    18.956     9.102     0.150
    18.956    14.801     0.150
    18.956   460.879     0.150
    19.641   264.578     0.150
    20.333   487.676     0.150
    20.660   275.598     0.150
    20.660   504.379     0.150
    20.660   544.477     0.150
    21.318   287.879     0.150
    21.318   298.879     0.150
    21.318   313.379     0.150
    21.602    14.402     0.150
    21.602   306.176     0.150
    22.800    10.801     0.150
    22.800    15.801     0.150
    23.996    11.500     0.150
    23.996    17.000     0.150
    25.036   320.676     0.150
    27.298    11.500     0.150
    27.298    17.500     0.150
    27.705   344.176     0.150
    28.465   363.977     0.150
    28.465   729.777     0.150
    30.118     9.801     0.150
    36.505   423.078     0.150
    36.715   426.477     0.150
    37.728   431.977     0.150
    39.789    10.801     0.150
    39.789   825.676     0.150
    40.180   452.215     0.150
    41.767   465.047     0.150
    42.090   467.879     0.150
    42.303   472.176     0.150
    42.593   470.902     0.150
    42.593   473.578     0.150
    42.796   475.277     0.150
    43.018   475.676     0.150
    43.097   475.977     0.150
    43.297   476.660     0.150
    43.487   480.176     0.150
    43.513   478.840     0.150
    43.848   480.805     0.150
    44.011   485.676     0.150
    44.432   488.527     0.150
    44.589   488.277     0.150
    44.914   490.879     0.150
    44.874   489.988     0.150
    44.924   490.621     0.150
    45.180   492.879     0.150
    45.288   493.977     0.150
    45.328   493.676     0.150
    45.569   496.078     0.150
    45.631   496.578     0.150
    45.585   500.078     0.150
    46.267   501.477     0.150
    46.507   503.578     0.150
    46.533   503.777     0.150
    46.625   504.176     0.150
    46.699   504.676     0.150
    46.931   507.676     0.150
    47.033   507.137     0.150
    47.263   508.379     0.150
    47.314   510.676     0.150
    47.580   512.078     0.150
    47.772   512.977     0.150
    47.818   513.562     0.150
    48.013   514.879     0.150
    48.124   516.578     0.150
    48.333   516.852     0.150
    48.437   518.977     0.150
    48.437   519.277     0.150
    48.437   519.188     0.150
    48.388   516.688     0.150
    48.558   518.781     0.150
    48.611   519.500     0.150
    48.767     9.301     0.150
    48.768   520.695     0.150
    48.927   521.555     0.150
    49.080   522.172     0.150
    49.215   523.230     0.150
    49.412   524.766     0.150
    49.455   525.422     0.150
    49.919   529.203     0.150
    50.046   530.355     0.150
    50.440   533.777     0.150
    50.417   532.980     0.150
    50.724   535.707     0.150
    50.890   536.977     0.150
    51.367   542.176     0.150
    51.727   542.586     0.150
    52.032   544.113     0.150
    53.517   557.078     0.150
    53.958   559.418     0.150
    56.027   573.977     0.150
    56.250   577.777     0.150
    58.299   590.879     0.150
    62.658   621.977     0.150
    62.809   622.277     0.150
    63.567   627.676     0.150
    63.874   629.176     0.150
    63.874   639.277     0.150
    63.874  1143.277     0.150
    64.023   629.879     0.150
    64.447   635.277     0.150
    64.956   636.477     0.150
    64.956   635.277     0.150
    65.422  1156.578     0.150
    66.166   882.477     0.150
    66.536   647.477     0.150
    67.617   654.238     0.150
    67.617   653.879     0.150
    68.106   906.379     0.150
    68.622   660.176     0.150
    69.123   662.277     0.150
    69.391   664.707     0.150
    69.522   919.379     0.150
    70.125   668.402     0.150
    70.137   668.777     0.150
    70.421   670.816     0.150
    71.004   673.402     0.150
    72.330   682.176     0.150
    72.330   682.078     0.150
    72.969   685.777     0.150
    74.197   693.777     0.150
    74.517   695.676     0.150
    74.442   695.477     0.150
    74.730   697.277     0.150
    74.779   697.078     0.150
    74.991   698.176     0.150
    75.000   699.578     0.150
    75.173   699.738     0.150
    75.226   700.078     0.150
    75.362   701.078     0.150
    75.380   701.176     0.150
    75.380   701.277     0.150
    75.582   702.777     0.150
    75.782   703.277     0.150
    75.820   703.578     0.150
    75.848   703.578     0.150
    75.865   703.676     0.150
    75.900   703.977     0.150
    75.903   704.379     0.150
    76.320   706.676     0.150
    76.328   706.277     0.150
    76.404   706.379     0.150
    76.404   982.277     0.150
    76.404   705.578     0.150
    76.404    10.500     0.150
    76.616   708.879     0.150
    76.850   709.078     0.150
    76.886   709.477     0.150
    76.949   709.379     0.150
    77.077   711.277     0.150
    77.915   714.477     0.150
    77.949   715.379     0.150
    77.949   724.078     0.150
    78.383   716.977     0.150
    78.711   719.477     0.150
    79.828   726.078     0.150
    80.073   725.793     0.150
    80.571   728.777     0.150
    81.409   734.176     0.150
    86.014  6363.777     0.150
    86.075   757.879     0.150
    86.212  1835.676     0.150
    86.764  6462.879     0.150
    88.165   767.977     0.150
    89.221   772.977     0.150
    91.014  6789.379     0.150
    91.255   782.578     0.150
    91.702   784.477     0.150
    91.950   786.176     0.150
    92.589   788.777     0.150
    94.696   798.578     0.150
   138.884  1152.648     0.150
   143.078  1168.527     0.150
   147.320  1180.176     0.150
   147.952  1386.164     0.150
    31.081  2375.945     0.150
    31.091  2375.852     0.150
    31.099  2380.844     0.150
    31.950  2444.641     0.150
    31.953  2442.961     0.150
    31.967  2438.688     0.150
    41.687   580.281     0.150
     7.407   112.703     0.150
    25.414   326.070     0.150
    31.036  2376.453     0.150
    31.047  2377.727     0.150
    31.054  2377.578     0.150
    31.903  2414.734     0.150
    31.907  2442.695     0.150
    31.920  2415.906     0.150
    41.712   466.672     0.150
    66.340   643.812     0.150
    69.226   661.953     0.150
     0.654    21.656     0.150
     1.127    20.641     0.150
     1.127    20.648     0.150
     1.127    21.039     0.150
     4.285    65.141     0.150
     4.916    72.336     0.150
     4.957   134.641     0.150
     5.451    81.734     0.150
     6.801    96.539     0.150
     7.405   106.734     0.150
    11.989   172.438     0.150
    12.090   174.938     0.150
    12.560   185.039     0.150
    12.951   186.234     0.150
    15.576   209.891     0.150
    17.744   245.039     0.150
    17.744   245.039     0.150
    19.520   263.938     0.150
    24.951   321.336     0.150
    27.434   352.539     0.150
    28.565   358.438     0.150
    28.565   407.539     0.150
    28.565   417.234     0.150
    31.086  2380.078     0.150
    31.097  2380.867     0.150
    31.104  2382.062     0.150
    31.709     8.305     0.150
    31.956  2441.375     0.150
    31.960  2441.078     0.150
    31.973  2446.297     0.150
    37.149   427.188     0.150
    38.227   433.477     0.150
    38.602   437.305     0.150
    40.720   456.922     0.150
    41.687   465.234     0.150
    41.889   465.914     0.150
    41.889   465.938     0.150
    42.568   470.359     0.150
    42.725   473.125     0.150
    42.725   473.141     0.150
    42.952   476.234     0.150
    43.351   479.141     0.150
    45.045   492.297     0.150
    47.259   512.938     0.150
    47.495   511.641     0.150
    48.352   519.641     0.150
    48.734   519.336     0.150
    49.048   523.023     0.150
    49.195   523.219     0.150
    49.580   527.305     0.150
    49.827   530.664     0.150
    50.545   534.719     0.150
    50.809   536.438     0.150
    57.019   582.328     0.150
    58.737   599.336     0.150
    62.728   621.438     0.150
    63.361   555.281     0.150
    63.850   631.039     0.150
    63.850   631.039     0.150
    66.456   644.797     0.150
    67.714   656.938     0.150
    67.833   654.281     0.150
    67.833   654.234     0.150
    70.099   669.539     0.150
    73.376   687.484     0.150
    73.516   689.539     0.150
    74.496   697.641     0.150
    74.496   697.641     0.150
    75.851   701.656     0.150
    75.851   701.641     0.150
    76.310   706.734     0.150
    76.398   708.438     0.150
    77.939   718.836     0.150
     0.114     3.346     0.150
     0.641    12.786     0.150
     0.641    23.326     0.150
     0.785    29.646     0.150
     1.056    18.706     0.150
     1.056    32.926     0.150
     3.176    50.886     0.150
     3.783    58.586     0.150
     3.783   100.186     0.150
     4.265    65.586     0.150
     4.265   112.286     0.150
     4.458    68.786     0.150
     4.986   139.386     0.150
     5.447    86.586     0.150
    11.951   174.586     0.150
    12.476   184.286     0.150
    12.933   187.485     0.150
    14.801   206.186     0.150
    24.893   323.086     0.150
    24.893   323.086     0.150
    37.596   438.686     0.150
    40.506   455.936     0.150
    41.629   466.686     0.150
    41.629   469.386     0.150
    41.629   469.386     0.150
    42.894   477.386     0.150
    43.555   481.735     0.150
    43.555   485.469     0.150
    43.555   488.286     0.150
    48.294   524.186     0.150
    48.294   524.186     0.150
    49.873   531.216     0.150
    49.873   531.186     0.150
    53.709   560.286     0.150
    54.659   568.256     0.150
    54.659   566.456     0.150
    63.972   631.936     0.150
    63.972   636.086     0.150
    67.507   658.386     0.150
    67.507   658.386     0.150
    67.526   658.686     0.150
    67.526   658.686     0.150
    76.349   713.686     0.150
     0.941    32.680     0.150
     1.379    22.070     0.150
     3.092    49.379     0.150
     3.092    87.980     0.150
     4.175    59.469     0.150
     4.896   132.180     0.150
     4.896    75.082     0.150
     4.896   132.180     0.150
     7.380   111.582     0.150
     9.563   138.980     0.150
    14.702   204.582     0.150
    17.637   241.781     0.150
    20.581   278.379     0.150
    24.363   319.379     0.150
    38.458   436.820     0.150
    38.889   445.680     0.150
    41.640   465.480     0.150
    41.841   466.781     0.150
    42.893   474.680     0.150
    43.391   479.980     0.150
    43.748   481.281     0.150
    44.956   491.500     0.150
    49.098   524.379     0.150
    49.890   530.480     0.150
    50.083   530.250     0.150
    50.763   536.480     0.150
    52.512    17.102     0.150
    52.512  1212.781     0.150
    62.714   621.480     0.150
    62.828   621.879     0.150
    64.603   633.180     0.150
    67.495   652.879     0.150
    67.515   653.781     0.150
    68.668   660.770     0.150
    68.668   660.781     0.150
    75.336   698.980     0.150
    75.336   698.980     0.150
    75.363   699.582     0.150
    75.532   699.141     0.150
    75.532   699.180     0.150
    76.155   704.332     0.150
    78.712   719.680     0.150
     0.681    22.086     0.150
     0.719    22.516     0.150
     1.117    19.844     0.150
     2.000    32.414     0.150
     3.163    53.516     0.150
     3.163    90.215     0.150
     3.762    55.812     0.150
     4.315    65.715     0.150
     4.524    66.914     0.150
     4.886    72.516     0.150
     4.981    77.613     0.150
     4.981    77.613     0.150
     4.981   134.613     0.150
     6.771    98.715     0.150
     7.404   106.113     0.150
     8.203   207.715     0.150
     8.203   219.113     0.150
     9.655   138.414     0.150
    11.970   174.613     0.150
    14.744   203.812     0.150
    14.817   207.113     0.150
    14.817   206.613     0.150
    17.775   245.914     0.150
    20.711   280.812     0.150
    20.711   549.215     0.150
    21.194   285.016     0.150
    22.679     7.199     0.150
    22.679   332.613     0.150
    24.954   320.414     0.150
    25.398   323.414     0.150
    28.595   354.715     0.150
    31.075  2381.730     0.150
    31.085  2379.316     0.150
    31.093  2383.168     0.150
    31.704    10.602     0.150
    31.944  2442.008     0.150
    31.947  2444.293     0.150
    31.961  2445.477     0.150
    38.387   440.113     0.150
    38.612   439.812     0.150
    41.692   465.613     0.150
    41.692   465.445     0.150
    41.894   467.516     0.150
    42.960   475.914     0.150
    42.960   475.875     0.150
    47.009   506.074     0.150
    47.270   512.016     0.150
    47.270   512.016     0.150
    49.225   524.312     0.150
    50.814   537.016     0.150
    50.814   537.215     0.150
    53.769   559.113     0.150
    53.769   559.055     0.150
    55.806   560.613     0.150
    62.698   621.715     0.150
    63.867   630.914     0.150
    63.867   630.914     0.150
    63.867   775.812     0.150
    63.867  1176.113     0.150
    67.594   653.414     0.150
    70.116   668.414     0.150
    70.128   668.125     0.150
    72.899   685.215     0.150
    74.892   698.113     0.150
    75.435   701.414     0.150
    75.870   703.016     0.150
    76.329   706.613     0.150
    77.075   711.312     0.150
    86.372   758.414     0.150
   146.234  1175.906     0.150
     3.207    50.043     0.150
     3.207    89.945     0.150
     4.380    65.945     0.150
     4.546    67.844     0.150
     5.029   128.746     0.150
     6.707   100.246     0.150
     6.707   101.203     0.150
     7.406   110.570     0.150
     7.406   106.543     0.150
     7.849   117.883     0.150
     9.690   149.145     0.150
    11.932   174.195     0.150
    12.577   184.246     0.150
    14.876   210.570     0.150
    14.876   209.246     0.150
    20.768   280.344     0.150
    20.768   512.344     0.150
    20.768   539.645     0.150
    21.260   281.945     0.150
    21.291   294.145     0.150
    21.291   311.746     0.150
    22.670     9.102     0.150
    28.661   353.043     0.150
    28.661   647.746     0.150
    31.046  2378.641     0.150
    31.057  2379.535     0.150
    31.064  2380.098     0.150
    31.914  2442.938     0.150
    31.917  2443.168     0.150
    31.931  2443.770     0.150
    38.638   442.203     0.150
    38.638   441.344     0.150
    41.707   473.844     0.150
    42.982   484.543     0.150
    42.982   484.543     0.150
    43.538   492.246     0.150
    43.658   479.113     0.150
    44.644   487.805     0.150
    47.246   510.918     0.150
    47.297   519.043     0.150
    47.297   519.043     0.150
    53.971   557.043     0.150
    60.055   611.445     0.150
    62.633   629.746     0.150
    63.907   632.543     0.150
    63.907   668.746     0.150
    63.907   778.246     0.150
    64.088   629.043     0.150
    64.090   635.844     0.150
    67.603   662.746     0.150
    70.156   678.145     0.150
    75.475   711.344     0.150
     0.480    16.719     0.150
     0.805    26.234     0.150
     4.270    80.789     0.150
    31.086  2380.766     0.150
    31.097  2378.828     0.150
    31.104  2382.391     0.150
    31.957  2441.055     0.150
    31.960  2444.258     0.150
    31.974  2447.344     0.150
    41.691   464.617     0.150
    44.537   490.602     0.150
    18.998   257.139     0.150
    25.384   324.059     0.150
    31.093  2380.318     0.150
    31.104  2381.098     0.150
    31.111  2381.668     0.150
    31.962  2442.225     0.150
    31.966  2442.480     0.150
    31.980  2443.514     0.150
    47.201   508.141     0.150
    62.330   618.299     0.150
    62.720   620.938     0.150
     0.725    25.344     0.150
     1.123    19.898     0.150
     3.176    51.297     0.150
     3.176    90.594     0.150
     4.323    61.367     0.150
     4.877    75.898     0.150
     4.877    72.898     0.150
     4.994   136.094     0.150
     6.760    99.695     0.150
     6.760   102.258     0.150
     8.211   217.797     0.150
     9.684   242.570     0.150
     9.652   137.797     0.150
    11.957   169.000     0.150
    12.077   175.195     0.150
    13.624   195.094     0.150
    14.829   208.297     0.150
    16.742   231.500     0.150
    17.785   246.195     0.150
    19.500   264.500     0.150
    20.175   271.398     0.150
    20.715   279.297     0.150
    20.715    12.000     0.150
    20.715   508.398     0.150
    22.668    10.398     0.150
    22.668   324.594     0.150
    24.947   320.695     0.150
    24.947   320.609     0.150
    27.433   351.898     0.150
    31.079  2376.156     0.150
    31.090  2382.719     0.150
    31.097  2378.398     0.150
    31.948  2442.938     0.150
    31.951  2443.031     0.150
    31.965  2443.523     0.150
    35.834   414.664     0.150
    38.588   438.820     0.150
    38.607   440.297     0.150
    39.106   443.742     0.150
    40.841   456.297     0.150
    40.871   457.312     0.150
    40.935   460.016     0.150
    41.211   461.812     0.150
    41.820   464.312     0.150
    41.887   467.797     0.150
    42.334   469.242     0.150
    42.407   470.562     0.150
    42.765   474.695     0.150
    42.954   475.797     0.150
    43.209   479.102     0.150
    43.319   480.195     0.150
    43.514   480.750     0.150
    43.878   483.695     0.150
    44.017   485.273     0.150
    45.042   493.359     0.150
    45.086   492.008     0.150
    45.092   493.055     0.150
    45.456   497.094     0.150
    45.615   495.680     0.150
    45.952   498.828     0.150
    46.469   505.195     0.150
    46.533   503.641     0.150
    46.772   507.734     0.150
    46.966   507.125     0.150
    47.265   510.500     0.150
    47.265   510.500     0.150
    48.347   519.000     0.150
    48.775   521.242     0.150
    49.090   523.141     0.150
    49.237   525.094     0.150
    50.293   534.523     0.150
    50.807   537.594     0.150
    50.892   537.781     0.150
    52.803   552.438     0.150
    55.922   574.898     0.150
    56.089   578.758     0.150
    58.778   593.797     0.150
    58.778   597.000     0.150
    63.865   629.398     0.150
    63.865   643.594     0.150
    64.730   636.195     0.150
    65.004   630.695     0.150
    65.870   642.398     0.150
    66.417   647.398     0.150
    67.570   654.391     0.150
    67.570   654.500     0.150
    67.590   654.297     0.150
    67.873   656.094     0.150
    68.105   906.094     0.150
    68.784   659.773     0.150
    68.784   659.797     0.150
    69.889   668.266     0.150
    70.114   668.898     0.150
    70.126   668.797     0.150
    70.126   668.859     0.150
    72.314   682.797     0.150
    73.415   690.195     0.150
    73.553   690.594     0.150
    73.800   692.070     0.150
    74.159   693.922     0.150
    74.159   693.898     0.150
    74.513   696.195     0.150
    74.600   696.094     0.150
    74.628   696.367     0.150
    74.761   696.695     0.150
    74.912   699.195     0.150
    74.891   698.195     0.150
    75.448   701.797     0.150
    75.550   701.797     0.150
    75.630   701.195     0.150
    75.828   703.898     0.150
    75.831   704.094     0.150
    75.869   704.000     0.150
    75.910   704.500     0.150
    75.910     9.594     0.150
    75.919   704.297     0.150
    76.318   707.000     0.150
    76.328   706.695     0.150
    76.419  1337.297     0.150
    76.419   706.195     0.150
    76.419    11.602     0.150
    76.419   706.125     0.150
    76.621   708.250     0.150
    76.621   708.195     0.150
    76.908   709.906     0.150
    76.896   710.195     0.150
    76.936   710.398     0.150
    77.075   712.000     0.150
    77.076   711.195     0.150
    77.076     6.898     0.150
    77.304   711.797     0.150
    77.472   712.398     0.150
    77.907   714.195     0.150
    77.959   715.695     0.150
    78.398   719.000     0.150
    78.916   719.859     0.150
    78.916   719.898     0.150
    79.619   724.094     0.150
    80.387   728.234     0.150
    80.436   729.820     0.150
    81.228   732.398     0.150
    86.103  6378.297     0.150
    91.084  6763.500     0.150
   146.224  1176.391     0.150
     0.601    20.162     0.150
     1.195    39.592     0.150
     3.111    49.652     0.150
     3.111    87.152     0.150
     3.724    54.952     0.150
     4.193    60.082     0.150
     4.917   135.652     0.150
     8.080   204.552     0.150
     9.565   136.852     0.150
    20.208   271.152     0.150
    24.347     9.200     0.150
    24.347    14.500     0.150
    24.903   319.252     0.150
    29.985   355.652     0.150
    29.985    13.000     0.150
    31.155  2381.236     0.150
    31.165  2382.047     0.150
    31.173  2378.916     0.150
    32.026  2447.278     0.150
    32.030  2444.112     0.150
    32.044  2448.460     0.150
    40.731   455.252     0.150
    42.890   474.352     0.150
    43.700   481.452     0.150
    43.769   482.152     0.150
    44.671   489.452     0.150
    47.191   509.352     0.150
    49.119   524.552     0.150
    49.884   529.952     0.150
    50.757   536.552     0.150
    53.722   558.252     0.150
    63.769   628.752     0.150
    68.004   653.962     0.150
    68.004   653.962     0.150
    68.004   902.512     0.150
    68.004  1440.142     0.150
    68.004   653.952     0.150
    68.004   679.652     0.150
    68.004   804.052     0.150
    68.004   902.452     0.150
    68.004  1191.652     0.150
    70.995   673.852     0.150
    72.221   677.763     0.150
    72.221   677.752     0.150
    74.064   691.626     0.150
    74.191   691.241     0.150
    76.842   703.671     0.150
    76.842   703.652     0.150
    78.061   714.292     0.150
     0.733    24.111     0.150
     3.198    50.801     0.150
     3.790    55.701     0.150
     4.381    65.000     0.150
     6.709    96.602     0.150
     7.417   108.701     0.150
    20.171   270.900     0.150
    21.260   283.701     0.150
    24.977   320.000     0.150
    24.977   320.000     0.150
    38.648   440.900     0.150
    38.947   448.602     0.150
    38.947     7.000     0.150
    38.947   539.102     0.150
    41.920   466.900     0.150
    42.993   474.900     0.150
    43.548   484.400     0.150
    44.640   489.900     0.150
    47.308   511.102     0.150
    47.462   511.500     0.150
    49.956   530.000     0.150
    50.839   536.701     0.150
    50.839   536.102     0.150
    53.790   559.201     0.150
    64.097   629.301     0.150
    76.949   708.301     0.150
    78.013   715.801     0.150
    86.416   757.500     0.150
    92.458   785.176     0.150
     0.109     9.426     0.150
     0.333     8.926     0.150
     0.333    14.996     0.150
     0.699    13.008     0.150
     0.699    22.258     0.150
     0.659    13.855     0.150
     0.659    23.828     0.150
     0.766    27.238     0.150
     0.805    16.617     0.150
     1.073    19.777     0.150
     1.165    21.316     0.150
     1.165    21.277     0.150
     1.471    46.930     0.150
     1.471    26.316     0.150
     2.044    32.918     0.150
     3.158    51.117     0.150
     3.158    90.117     0.150
     3.158    95.316     0.150
     3.763    57.215     0.150
     3.763   100.617     0.150
     4.264   116.516     0.150
     4.264    66.418     0.150
     4.935    73.367     0.150
     4.969   137.016     0.150
     6.810   101.316     0.150
     7.370   106.918     0.150
     7.370   106.215     0.150
     8.151   133.516     0.150
     8.878   128.117     0.150
     9.129   136.617     0.150
     9.129   231.715     0.150
     9.602   137.715     0.150
    10.982   158.938     0.150
    11.971   169.316     0.150
    12.057   173.215     0.150
    12.753   184.617     0.150
    12.947   185.617     0.150
    12.947   184.008     0.150
    15.601   219.418     0.150
    16.704   232.816     0.150
    20.177   271.918     0.150
    20.654   278.117     0.150
    20.654   507.117     0.150
    21.218   288.117     0.150
    21.218   301.016     0.150
    21.218   308.117     0.150
    21.218   323.816     0.150
    21.447   290.617     0.150
    23.849    11.301     0.150
    23.849    16.898     0.150
    23.849   565.617     0.150
    25.358   324.277     0.150
    25.358   324.418     0.150
    28.551   356.016     0.150
    28.551   355.715     0.150
    28.551   411.617     0.150
    29.966   373.117     0.150
    29.966    10.699     0.150
    31.994  2408.012     0.150
    31.998  2409.770     0.150
    32.012  2406.590     0.150
    38.668   444.277     0.150
    40.343   455.438     0.150
    41.851   467.617     0.150
    42.013   470.035     0.150
    42.913   475.316     0.150
    42.913   475.926     0.150
    43.332   479.617     0.150
    43.428   478.645     0.150
    44.130   487.816     0.150
    44.267   487.418     0.150
    46.728   504.855     0.150
    46.842   505.746     0.150
    46.977   508.875     0.150
    47.822   513.453     0.150
    47.943   514.859     0.150
    48.314   518.516     0.150
    48.314   519.328     0.150
    48.447   518.488     0.150
    48.754   523.035     0.150
    49.045   522.965     0.150
    49.188   523.004     0.150
    49.526   525.828     0.150
    49.575   526.602     0.150
    49.579   526.371     0.150
    50.047   529.809     0.150
    50.170   531.367     0.150
    50.546   533.695     0.150
    50.772   537.746     0.150
    50.772   537.715     0.150
    50.850   536.195     0.150
    51.044   540.117     0.150
    51.932   545.738     0.150
    53.730   559.617     0.150
    58.827   595.316     0.150
    63.812   630.316     0.150
    63.812   630.316     0.150
    63.812   775.215     0.150
    63.812  1172.516     0.150
    63.984   630.242     0.150
    65.324   877.016     0.150
    67.525   654.117     0.150
    68.051   904.516     0.150
    71.050   676.016     0.150
    74.459   696.016     0.150
    74.544   695.418     0.150
    74.836   700.516     0.150
    74.836   700.516     0.150
    75.395   701.316     0.150
    75.416   701.516     0.150
    75.734   706.715     0.150
    75.734   706.715     0.150
    75.854   704.316     0.150
    76.362   705.715     0.150
    77.867   717.516     0.150
    77.867   717.516     0.150
    77.903   714.918     0.150
    77.924   716.316     0.150
    77.954   715.258     0.150
    77.956   715.180     0.150
    80.178   727.262     0.150
    80.317   727.059     0.150
    80.331   726.922     0.150
    80.729   729.129     0.150
    80.832   729.617     0.150
    86.136  6470.113     0.150
    91.123  6831.918     0.150
    92.342   789.125     0.150
     2.155    32.273     0.150
     3.763    55.477     0.150
     4.335    64.875     0.150
     4.335   113.773     0.150
     4.987   128.273     0.150
     4.987   135.773     0.150
    14.766   198.875     0.150
    20.734   277.977     0.150
    21.213   281.375     0.150
    22.688     8.805     0.150
    22.688    14.203     0.150
    37.678   434.070     0.150
    42.879   471.180     0.150
    42.978   475.273     0.150
    48.371   518.672     0.150
    49.949   531.672     0.150
    69.179   660.875     0.150
    80.610   730.875     0.150
     0.940    28.547     0.150
    30.213  2254.469     0.150
    30.224  2255.562     0.150
    30.231  2261.250     0.150
    31.089  2319.867     0.150
    31.092  2321.531     0.150
    31.106  2325.766     0.150
    42.431   466.414     0.150
    64.771   630.844     0.150
     1.086    18.758     0.150
     1.550    25.855     0.150
     4.994   134.555     0.150
     7.424   111.031     0.150
     7.424   106.555     0.150
    11.966   170.457     0.150
    12.580   180.555     0.150
    12.724   184.555     0.150
    15.508   208.383     0.150
    20.191   270.457     0.150
    21.230   283.855     0.150
    24.980   318.355     0.150
    24.980   318.355     0.150
    31.042  2379.980     0.150
    31.052  2376.891     0.150
    31.059  2377.352     0.150
    31.910  2445.199     0.150
    31.914  2445.539     0.150
    31.927  2446.488     0.150
    41.719   464.758     0.150
    41.921   466.758     0.150
    42.990   476.055     0.150
    43.571   478.906     0.150
    44.609   486.555     0.150
    50.841   535.656     0.150
    67.608   654.258     0.150
    67.627   652.855     0.150
    76.133   702.258     0.150
     3.118    87.586     0.150
     4.927   134.887     0.150
     9.592   143.387     0.150
    12.519   185.988     0.150
    12.993   185.688     0.150
    15.151   205.289     0.150
    20.209   271.188     0.150
    41.655   465.188     0.150
    41.856   466.887     0.150
    42.913   475.289     0.150
    44.221   486.387     0.150
    48.322   520.086     0.150
    48.322   519.988     0.150
    52.541  1213.289     0.150
    53.739   558.188     0.150
    67.539   653.586     0.150
    70.046   666.086     0.150
    71.007   674.387     0.150
     0.366    17.881     0.150
     0.312     8.381     0.150
     0.312    15.541     0.150
     0.743    23.232     0.150
     0.711    25.932     0.150
     0.983    31.951     0.150
     0.931    18.352     0.150
     0.931    32.842     0.150
     3.149    87.402     0.150
     4.400   120.801     0.150
     4.400    66.701     0.150
     4.807    71.701     0.150
     4.631    67.801     0.150
     4.978    76.301     0.150
     4.978   135.201     0.150
     5.379    80.502     0.150
     6.495    99.902     0.150
     6.495   173.102     0.150
     6.495   108.801     0.150
     8.293   123.902     0.150
     8.293   125.902     0.150
     8.293   220.201     0.150
     9.253   137.902     0.150
     9.253   144.402     0.150
     9.253   145.602     0.150
     9.253   149.102     0.150
     9.617   137.902     0.150
    10.612   157.402     0.150
    10.972   160.902     0.150
    10.990   167.201     0.150
    11.998   169.102     0.150
    12.738   183.701     0.150
    12.907   183.801     0.150
    14.847   208.801     0.150
    15.251   222.002     0.150
    15.251   383.402     0.150
    15.890   216.902     0.150
    15.890   391.902     0.150
    16.853   234.002     0.150
    17.849   249.301     0.150
    19.567     9.000     0.150
    19.567    13.301     0.150
    19.567   477.102     0.150
    19.578   263.902     0.150
    19.578   263.881     0.150
    20.820   280.361     0.150
    21.374   288.402     0.150
    21.374   299.201     0.150
    21.374   310.201     0.150
    21.520   290.402     0.150
    21.520    10.000     0.150
    21.520   556.402     0.150
    23.950     7.699     0.150
    23.950    10.699     0.150
    23.950   568.102     0.150
    25.156   329.902     0.150
    25.052   321.201     0.150
    25.052   321.111     0.150
    25.496   324.902     0.150
    26.185   334.701     0.150
    27.209   349.902     0.150
    27.209     5.500     0.150
    27.543   352.002     0.150
    28.663   346.902     0.150
    30.964  2379.074     0.150
    30.975  2379.332     0.150
    30.982  2381.418     0.150
    31.833  2444.531     0.150
    31.836  2444.910     0.150
    31.850  2445.945     0.150
    31.783     9.801     0.150
    31.783   552.602     0.150
    33.001   395.402     0.150
    33.816   399.531     0.150
    37.217   426.039     0.150
    37.221   426.123     0.150
    37.915   431.734     0.150
    38.086   434.328     0.150
    38.500   438.902     0.150
    38.610   438.391     0.150
    38.718   439.145     0.150
    39.022    12.301     0.150
    39.922   450.002     0.150
    41.853   466.770     0.150
    41.995   467.062     0.150
    41.995   467.102     0.150
    42.478   473.801     0.150
    43.066   476.002     0.150
    43.066   475.961     0.150
    43.066   476.211     0.150
    43.363   479.402     0.150
    43.604   480.084     0.150
    43.978   486.402     0.150
    44.207   485.662     0.150
    44.201   487.701     0.150
    44.601   488.252     0.150
    44.601   488.201     0.150
    44.936   490.902     0.150
    45.193   492.801     0.150
    45.303   493.641     0.150
    45.303   493.602     0.150
    45.644   496.402     0.150
    45.768   501.102     0.150
    46.285   501.701     0.150
    46.523   503.301     0.150
    46.734   507.102     0.150
    46.549   504.102     0.150
    46.640   504.301     0.150
    46.719   504.701     0.150
    47.537   512.502     0.150
    47.537   512.582     0.150
    47.799   512.631     0.150
    47.799   512.602     0.150
    48.033   515.102     0.150
    48.453   519.291     0.150
    48.453   519.402     0.150
    48.801   521.270     0.150
    48.891   523.682     0.150
    49.275   525.301     0.150
    49.275   525.352     0.150
    49.641   527.719     0.150
    50.462   533.602     0.150
    50.512   535.182     0.150
    50.601   534.471     0.150
    50.914   537.201     0.150
    50.910   537.244     0.150
    51.183   540.162     0.150
    51.392   542.201     0.150
    52.068   545.801     0.150
    53.865   559.211     0.150
    55.551   567.791     0.150
    56.054   575.674     0.150
    56.022   575.322     0.150
    56.268   578.002     0.150
    57.122   583.402     0.150
    57.122   583.402     0.150
    58.974   597.732     0.150
    59.243   597.271     0.150
    60.294   602.352     0.150
    62.604   620.301     0.150
    62.862   623.002     0.150
    63.123   628.801     0.150
    63.981   629.602     0.150
    63.981   636.002     0.150
    64.747   634.902     0.150
    65.143   638.102     0.150
    65.143   638.041     0.150
    65.558   638.031     0.150
    65.875   643.672     0.150
    65.947   642.861     0.150
    66.645   647.502     0.150
    67.685   654.002     0.150
    67.685   654.711     0.150
    67.704   653.102     0.150
    67.704   654.201     0.150
    68.221   657.592     0.150
    68.221   657.592     0.150
    68.221   678.611     0.150
    68.221   901.023     0.150
    68.221  1221.910     0.150
    68.221  1492.133     0.150
    68.221  1708.613     0.150
    68.221   657.502     0.150
    68.221    14.199     0.150
    68.221   810.301     0.150
    68.221   901.000     0.150
    68.221  1195.402     0.150
    68.221  1221.902     0.150
    68.618   661.572     0.150
    68.813   661.402     0.150
    69.183   662.502     0.150
    69.237   662.072     0.150
    69.268   660.201     0.150
    69.417   667.201     0.150
    70.230   669.301     0.150
    72.430   682.602     0.150
    72.561   683.701     0.150
    72.816   684.342     0.150
    73.411   690.201     0.150
    74.275   694.301     0.150
    74.400   694.912     0.150
    74.456   694.902     0.150
    74.633   695.201     0.150
    74.628   696.502     0.150
    74.715   696.861     0.150
    74.828   696.701     0.150
    74.877   698.301     0.150
    74.951   698.602     0.150
    75.006   698.402     0.150
    75.084   699.201     0.150
    75.114   700.602     0.150
    75.114   700.652     0.150
    75.407   700.502     0.150
    75.445   701.502     0.150
    75.477   700.691     0.150
    75.556   700.801     0.150
    75.612   701.002     0.150
    75.649   702.402     0.150
    75.649   702.441     0.150
    75.671   703.402     0.150
    75.690   702.861     0.150
    75.947   704.902     0.150
    75.947   704.512     0.150
    75.984   704.902     0.150
    76.023   705.102     0.150
    76.023   705.102     0.150
    76.025   705.002     0.150
    76.025   704.902     0.150
    76.433   707.602     0.150
    76.443   707.102     0.150
    76.531   717.881     0.150
    76.531   706.801     0.150
    76.531   717.801     0.150
    76.533    12.600     0.150
    76.533   706.201     0.150
    76.533   716.902     0.150
    76.647   709.492     0.150
    76.736   709.455     0.150
    76.736   709.402     0.150
    76.736   707.641     0.150
    76.906   707.932     0.150
    76.974   710.102     0.150
    76.974   710.152     0.150
    77.010   709.441     0.150
    77.010   710.301     0.150
    77.010   708.451     0.150
    77.052   710.502     0.150
    77.083   710.979     0.150
    77.190   710.801     0.150
    77.190   709.822     0.150
    77.192   711.902     0.150
    77.420   712.201     0.150
    77.583   713.062     0.150
    77.677   714.721     0.150
    77.897   716.801     0.150
    78.037   715.502     0.150
    78.073   716.301     0.150
    78.292   717.158     0.150
    78.292   716.752     0.150
    78.333   717.141     0.150
    78.416   718.191     0.150
    78.511   718.301     0.150
    78.595   719.242     0.150
    78.834   719.012     0.150
    79.020   719.732     0.150
    79.826   725.801     0.150
    79.826   725.863     0.150
    79.988   726.703     0.150
    80.349   728.762     0.150
    80.680   731.000     0.150
    80.701   729.402     0.150
    81.664   736.801     0.150
    81.681   733.902     0.150
    83.667   745.000     0.150
    83.759   745.000     0.150
    84.581   749.500     0.150
    85.078   753.473     0.150
    85.064   752.102     0.150
    85.827   756.402     0.150
    86.260   758.203     0.150
    87.167   763.742     0.150
    87.925   766.152     0.150
    88.355   769.312     0.150
    89.408   773.102     0.150
   127.860  1142.602     0.150
   132.319  1135.969     0.150
   143.242  1168.125     0.150
   146.167  1174.500     0.150
     0.242    12.715     0.150
     0.544    11.516     0.150
     0.713    15.135     0.150
     0.713    26.525     0.150
     0.745    14.476     0.150
     0.745    26.115     0.150
     0.810    24.735     0.150
     0.995    17.896     0.150
     0.995    31.165     0.150
     1.145    20.865     0.150
     1.187    21.465     0.150
     3.046    48.565     0.150
     3.046    83.365     0.150
     4.180   112.065     0.150
     4.855   133.065     0.150
     5.024    78.865     0.150
     5.566    85.315     0.150
     7.438   106.865     0.150
     7.448   106.865     0.150
     8.073   126.565     0.150
     8.073   220.766     0.150
     8.272   118.766     0.150
     8.846   127.065     0.150
    12.081   170.865     0.150
    12.131   174.465     0.150
    13.062   185.155     0.150
    14.675   207.565     0.150
    14.675   205.865     0.150
    17.635   243.865     0.150
    17.635   243.865     0.150
    18.888     7.900     0.150
    18.888    14.900     0.150
    19.567     9.000     0.150
    19.578   264.965     0.150
    20.278   271.465     0.150
    20.609    12.900     0.150
    20.609   534.565     0.150
    23.931    11.900     0.150
    23.931    18.601     0.150
    24.966   320.065     0.150
    25.410   533.127     0.150
    30.055   364.266     0.150
    30.055    14.600     0.150
    31.754     8.900     0.150
    36.665   422.065     0.150
    38.590   569.967     0.150
    38.554   441.955     0.150
    39.610   447.394     0.150
    39.824   449.465     0.150
    41.696   579.090     0.150
    41.696   806.016     0.150
    41.897   466.865     0.150
    42.020   467.365     0.150
    42.178   467.552     0.150
    42.614   472.465     0.150
    42.947   475.165     0.150
    42.947   474.965     0.150
    43.027   583.927     0.150
    43.027   475.266     0.150
    43.314   476.985     0.150
    43.440   479.965     0.150
    43.806   481.766     0.150
    44.019   484.266     0.150
    44.154   485.565     0.150
    44.235   485.465     0.150
    44.519   487.766     0.150
    44.843   490.665     0.150
    44.888   489.837     0.150
    45.110   492.465     0.150
    45.218   493.465     0.150
    45.243   492.604     0.150
    45.499   495.766     0.150
    45.738   497.545     0.150
    46.196   501.065     0.150
    46.437   503.065     0.150
    46.463   503.665     0.150
    46.463   503.665     0.150
    46.554   504.165     0.150
    46.629   504.465     0.150
    46.801   505.965     0.150
    47.194   598.247     0.150
    47.510   511.065     0.150
    47.701   512.665     0.150
    47.942   514.665     0.150
    48.366   518.165     0.150
    48.366   518.165     0.150
    48.697     9.300     0.150
    50.369   533.266     0.150
    50.819   536.365     0.150
    51.241   540.965     0.150
    51.296   541.766     0.150
    52.561   730.766     0.150
    52.561  1203.766     0.150
    53.448   556.065     0.150
    53.786   558.785     0.150
    55.038   565.575     0.150
    55.332   567.686     0.150
    55.958   573.465     0.150
    60.075   603.105     0.150
    62.951   622.165     0.150
    62.951   630.266     0.150
    62.999   623.075     0.150
    63.809   627.865     0.150
    63.809   627.865     0.150
    63.809   862.865     0.150
    63.809  1131.665     0.150
    64.475   633.965     0.150
    64.661   632.865     0.150
    64.922   634.965     0.150
    65.352   779.365     0.150
    65.352   875.165     0.150
    65.719   641.266     0.150
    67.547   654.065     0.150
    67.547   654.065     0.150
    67.547   654.375     0.150
    67.567   653.665     0.150
    68.042   904.865     0.150
    68.042  1196.465     0.150
    68.479   660.266     0.150
    68.628   659.165     0.150
    68.628   659.085     0.150
    69.067   661.465     0.150
    69.067   658.065     0.150
    70.059   667.865     0.150
    70.669   671.965     0.150
    70.669   671.885     0.150
    72.264   681.465     0.150
    72.606   682.915     0.150
    72.903   685.165     0.150
    73.268   688.266     0.150
    73.309   686.266     0.150
    73.742   690.766     0.150
    73.942   692.965     0.150
    74.105   693.065     0.150
    74.130   693.065     0.150
    74.453   695.065     0.150
    74.580   694.605     0.150
    74.664   695.965     0.150
    74.664   696.065     0.150
    74.712   696.766     0.150
    74.830   697.365     0.150
    74.849   698.165     0.150
    74.892   696.854     0.150
    74.936   698.465     0.150
    75.243   699.365     0.150
    75.295   700.766     0.150
    75.314   700.565     0.150
    75.464   700.266     0.150
    75.487   699.740     0.150
    75.516   701.665     0.150
    75.720   702.465     0.150
    75.783   702.465     0.150
    75.781   703.365     0.150
    75.802   703.065     0.150
    75.838   703.165     0.150
    75.841   703.565     0.150
    75.841   703.565     0.150
    76.256   705.865     0.150
    76.264   705.766     0.150
    76.343   708.075     0.150
    76.343   705.465     0.150
    76.344   705.165     0.150
    76.381   706.165     0.150
    76.554   707.665     0.150
    76.789   708.465     0.150
    76.824   708.665     0.150
    76.883   708.766     0.150
    77.007   709.565     0.150
    77.009   710.266     0.150
    77.014   710.565     0.150
    77.249   710.766     0.150
    77.853   713.965     0.150
    77.859   713.865     0.150
    78.322   716.465     0.150
    78.325   715.503     0.150
    79.859   725.365     0.150
    80.440   726.565     0.150
    80.511   728.065     0.150
    81.343   733.365     0.150
    84.386   748.266     0.150
    84.923   750.865     0.150
    85.633   755.266     0.150
    86.087   756.665     0.150
   125.592  1138.766     0.150
   139.679  1160.085     0.150
   139.679  1160.065     0.150
   143.108  1166.795     0.150
   143.108  1168.221     0.150
   143.108  1166.766     0.150
   146.377  1175.565     0.150
     0.403    18.266     0.150
     0.338     8.016     0.150
     0.338    13.883     0.150
     0.651    24.195     0.150
     0.463    10.156     0.150
     0.463    17.695     0.150
     1.047    19.344     0.150
     1.490    25.133     0.150
     1.588    26.930     0.150
     1.930    31.633     0.150
     3.178    90.133     0.150
     3.766    56.531     0.150
     4.395    67.031     0.150
     5.004   137.430     0.150
     6.486    91.031     0.150
     7.453   108.734     0.150
     8.244   116.031     0.150
     8.286   127.336     0.150
     9.214   137.734     0.150
     9.214   142.531     0.150
     9.214   252.836     0.150
     9.735   137.734     0.150
     9.735   139.336     0.150
    10.600   159.234     0.150
    10.934   285.133     0.150
    12.130   177.336     0.150
    12.130   313.531     0.150
    12.817   181.430     0.150
    12.886   186.781     0.150
    15.269   388.336     0.150
    19.529   266.930     0.150
    19.540   266.633     0.150
    19.540   266.633     0.150
    20.800   279.430     0.150
    20.800    10.000     0.150
    20.800   536.930     0.150
    20.800   547.133     0.150
    21.338   290.930     0.150
    21.338   323.734     0.150
    21.338   535.336     0.150
    21.483   289.836     0.150
    22.715   303.531     0.150
    22.715     7.305     0.150
    23.911     4.102     0.150
    23.911     6.898     0.150
    25.014   326.688     0.150
    25.014   321.930     0.150
    25.014   321.930     0.150
    27.506   344.836     0.150
    28.666   355.531     0.150
    28.712   357.039     0.150
    28.987   358.734     0.150
    28.987   358.734     0.150
    30.015     6.203     0.150
    30.015   670.633     0.150
    30.999  2336.188     0.150
    31.010  2339.328     0.150
    31.017  2336.188     0.150
    31.867  2396.750     0.150
    31.871  2396.750     0.150
    31.884  2396.750     0.150
    31.744   383.430     0.150
    31.744     8.102     0.150
    31.744   709.234     0.150
    36.445   427.336     0.150
    36.568   426.836     0.150
    36.568   773.133     0.150
    37.233   431.070     0.150
    38.104   435.289     0.150
    38.117   436.578     0.150
    38.685   442.422     0.150
    38.685   441.430     0.150
    39.063   444.914     0.150
    38.984     8.797     0.150
    38.984   798.734     0.150
    39.155   446.586     0.150
    39.704   450.625     0.150
    39.815   451.141     0.150
    39.884   451.734     0.150
    40.241   455.625     0.150
    40.813   459.289     0.150
    41.755   466.836     0.150
    41.957   468.633     0.150
    41.957   470.070     0.150
    42.256   472.180     0.150
    43.042   478.289     0.150
    43.030   476.836     0.150
    43.109   476.836     0.150
    43.369   480.961     0.150
    43.380   481.453     0.150
    43.330   480.836     0.150
    43.556   482.703     0.150
    43.572   483.133     0.150
    43.770   482.820     0.150
    43.916   485.312     0.150
    43.916   485.336     0.150
    43.995   485.031     0.150
    44.215   486.633     0.150
    44.171   487.336     0.150
    44.525   492.055     0.150
    44.636   487.680     0.150
    44.636   489.930     0.150
    44.812   492.336     0.150
    44.562   489.430     0.150
    45.154   494.133     0.150
    45.265   495.133     0.150
    45.448   498.023     0.150
    45.545   497.133     0.150
    45.606   497.836     0.150
    45.830   500.336     0.150
    45.992   498.984     0.150
    46.247   503.133     0.150
    46.511   505.234     0.150
    46.511   505.234     0.150
    46.602   505.531     0.150
    46.748   507.773     0.150
    46.681   506.133     0.150
    46.810   508.812     0.150
    46.917   508.164     0.150
    46.886   507.734     0.150
    47.050   510.406     0.150
    47.891   517.672     0.150
    47.891   517.633     0.150
    47.995   516.531     0.150
    48.415   521.375     0.150
    48.415   522.469     0.150
    48.415   522.469     0.150
    48.415   521.430     0.150
    48.816   521.938     0.150
    48.730     5.000     0.150
    48.730    12.695     0.150
    48.730  1164.930     0.150
    48.853   525.555     0.150
    49.286   524.805     0.150
    49.353   528.523     0.150
    49.658   529.008     0.150
    50.424   535.234     0.150
    50.619   535.281     0.150
    50.927   537.391     0.150
    50.876   537.633     0.150
    50.970   541.141     0.150
    51.354   543.633     0.150
    51.364   545.234     0.150
    51.505   545.773     0.150
    51.505   545.734     0.150
    51.589   541.891     0.150
    51.613   544.234     0.150
    51.886   544.219     0.150
    51.929   544.664     0.150
    51.822   545.930     0.150
    53.461   559.797     0.150
    53.461   558.836     0.150
    54.928   566.641     0.150
    55.076   570.664     0.150
    55.169   567.078     0.150
    55.169   567.133     0.150
    55.540   569.656     0.150
    55.983   575.953     0.150
    55.983   575.633     0.150
    56.145   577.930     0.150
    57.123   589.336     0.150
    57.832   595.430     0.150
    57.832   647.133     0.150
    58.823   593.328     0.150
    58.823   596.531     0.150
    58.973   598.336     0.150
    58.973   598.336     0.150
    59.540   601.891     0.150
    60.024   606.531     0.150
    60.024   606.570     0.150
    60.101   605.633     0.150
    60.215   608.234     0.150
    60.215   606.812     0.150
    61.299   613.742     0.150
    62.489   621.430     0.150
    62.410   620.609     0.150
    62.618   620.125     0.150
    62.775   625.914     0.150
    63.092   631.031     0.150
    63.092   665.633     0.150
    63.807   634.734     0.150
    63.950   632.680     0.150
    63.950   635.109     0.150
    63.950   632.133     0.150
    63.950   768.336     0.150
    63.950  1148.430     0.150
    64.097   633.133     0.150
    64.129   634.164     0.150
    64.365   637.836     0.150
    64.638   636.234     0.150
    64.790   642.930     0.150
    65.088   641.734     0.150
    65.134   639.734     0.150
    65.134   639.734     0.150
    65.177   644.734     0.150
    65.444  1160.031     0.150
    65.896   641.703     0.150
    65.896   643.234     0.150
    66.670   645.398     0.150
    66.670   649.531     0.150
    66.840   649.906     0.150
    67.650   655.906     0.150
    67.650   654.633     0.150
    67.669   656.734     0.150
    67.983   657.641     0.150
    68.192   905.633     0.150
    68.608   661.836     0.150
    68.724   661.930     0.150
    68.827   661.430     0.150
    68.859   661.633     0.150
    69.040   663.406     0.150
    69.070   664.516     0.150
    69.245   662.625     0.150
    69.379   666.320     0.150
    69.498   668.023     0.150
    69.489   666.234     0.150
    69.559   816.234     0.150
    69.559   919.430     0.150
    69.958   670.000     0.150
    69.958   670.000     0.150
    70.044   669.727     0.150
    70.075   671.062     0.150
    70.114   669.773     0.150
    70.199   673.594     0.150
    70.199   668.398     0.150
    70.199   671.836     0.150
    70.199   672.766     0.150
    70.211   673.039     0.150
    70.211   673.031     0.150
    70.318   676.234     0.150
    70.490   673.531     0.150
    70.457   673.008     0.150
    70.466   673.383     0.150
    70.466   673.430     0.150
    70.731   673.836     0.150
    70.598   673.391     0.150
    70.660   674.102     0.150
    70.724   674.484     0.150
    70.849   674.719     0.150
    70.865   674.875     0.150
    70.870   675.516     0.150
    71.082   678.477     0.150
    71.157   676.789     0.150
    71.263   677.664     0.150
    71.475   678.328     0.150
    71.705   686.031     0.150
    71.834   682.531     0.150
    71.816   680.805     0.150
    72.254   684.336     0.150
    72.401   681.164     0.150
    72.401   681.133     0.150
    72.306   685.820     0.150
    72.399   685.719     0.150
    72.399   685.734     0.150
    72.740   685.430     0.150
    72.772   682.891     0.150
    72.772    14.672     0.150
    73.042   689.031     0.150
    73.020   693.914     0.150
    72.966   686.109     0.150
    73.034   691.000     0.150
    73.034   691.031     0.150
    73.361   690.305     0.150
    73.501   688.773     0.150
    73.605   701.773     0.150
    73.955   700.477     0.150
    74.105   692.133     0.150
    74.153   700.117     0.150
    74.244   693.930     0.150
    74.244   694.273     0.150
    74.332   695.547     0.150
    74.506   697.516     0.150
    74.647   697.914     0.150
    74.647   697.930     0.150
    74.589   699.984     0.150
    74.599   698.930     0.150
    74.599   699.289     0.150
    74.683   705.336     0.150
    74.797   706.203     0.150
    74.797   706.234     0.150
    74.845   704.219     0.150
    74.845   704.234     0.150
    74.921   699.531     0.150
    75.035   709.734     0.150
    75.064   701.766     0.150
    75.426   701.430     0.150
    75.366   707.062     0.150
    75.441   704.383     0.150
    75.447   709.305     0.150
    75.447   702.633     0.150
    75.639   704.531     0.150
    75.522   700.953     0.150
    75.522   702.234     0.150
    75.642   710.633     0.150
    75.656   703.633     0.150
    75.774   709.516     0.150
    75.892   706.836     0.150
    75.904   707.156     0.150
    75.915   704.133     0.150
    75.916   704.633     0.150
    75.916   704.641     0.150
    75.956   703.430     0.150
    75.956   704.734     0.150
    75.956   704.820     0.150
    75.995   705.234     0.150
    75.997   704.234     0.150
    75.997   704.234     0.150
    76.004   705.133     0.150
    76.144   706.695     0.150
    76.100   704.586     0.150
    76.100   704.586     0.150
    76.159   710.133     0.150
    76.227   713.922     0.150
    76.308   709.125     0.150
    76.404   708.312     0.150
    76.404   707.734     0.150
    76.404   707.695     0.150
    76.414   705.633     0.150
    76.503   715.984     0.150
    76.503   707.133     0.150
    76.503   715.930     0.150
    76.506   708.195     0.150
    76.506  1296.133     0.150
    76.506   706.234     0.150
    76.506  1296.133     0.150
    76.540   708.836     0.150
    76.540   708.836     0.150
    76.619   708.430     0.150
    76.619   708.523     0.150
    76.814   709.672     0.150
    76.708   707.930     0.150
    76.708   708.930     0.150
    76.708   708.820     0.150
    77.028   711.930     0.150
    76.911   712.141     0.150
    76.982   712.336     0.150
    76.982   712.336     0.150
    76.982   709.531     0.150
    76.988   710.430     0.150
    77.021   710.633     0.150
    77.288   716.164     0.150
    77.353   717.305     0.150
    77.389   712.336     0.150
    77.389   712.344     0.150
    78.009   715.633     0.150
    78.096     9.086     0.150
    78.228   719.180     0.150
    78.262   715.812     0.150
    78.485   721.492     0.150
    78.485   721.531     0.150
    78.546   721.531     0.150
    78.789   722.625     0.150
    78.919   726.234     0.150
    78.981   721.477     0.150
    78.981   721.430     0.150
    78.981   721.492     0.150
    79.185     9.453     0.150
    79.481   726.133     0.150
    79.525   727.930     0.150
    79.549     4.367     0.150
    79.716   723.023     0.150
    79.767   728.266     0.150
    79.782     9.586     0.150
    79.798   728.727     0.150
    79.798   728.289     0.150
    79.944   731.906     0.150
    79.991   730.852     0.150
    79.991   725.555     0.150
    80.045   732.406     0.150
    80.042   725.438     0.150
    80.160   729.461     0.150
    80.195   725.930     0.150
    80.195   725.336     0.150
    80.220   726.781     0.150
    80.285   730.523     0.150
    80.285     7.758     0.150
    47.600   728.891     0.150
    80.454   733.961     0.150
    80.460     9.258     0.150
    80.474     9.289     0.150
    80.522     9.156     0.150
    80.926   733.195     0.150
    80.975   731.047     0.150
    80.975    10.297     0.150
    81.206   735.641     0.150
    81.212   735.164     0.150
    81.393   734.633     0.150
    81.655   740.133     0.150
    81.868   739.484     0.150
    83.147   745.336     0.150
    84.635   752.273     0.150
    84.954   756.031     0.150
    85.039   755.633     0.150
    85.802   759.930     0.150
    86.277   759.336     0.150
    86.232   762.031     0.150
    86.401   760.430     0.150
    89.424   774.836     0.150
    91.378   792.734     0.150
    91.828   795.133     0.150
    92.052   795.633     0.150
    92.075   795.734     0.150
    92.145   796.430     0.150
    92.488   787.000     0.150
    92.714   798.836     0.150
    92.728   790.430     0.150
    92.907   799.734     0.150
    92.907   792.555     0.150
    93.093   793.750     0.150
    93.406   801.031     0.150
    94.336   804.930     0.150
    95.616   812.734     0.150
   122.428  1131.180     0.150
   125.541  1139.734     0.150
   139.866  1167.523     0.150
   139.866  1167.531     0.150
   143.267  1169.703     0.150
   143.267  1169.734     0.150
   146.164  1175.797     0.150
     1.507    25.715     0.150
     4.519    67.015     0.150
     4.977    78.114     0.150
     4.977   134.914     0.150
     7.401   106.515     0.150
     8.194   207.314     0.150
     8.194   118.914     0.150
    20.703   279.814     0.150
    20.703   509.314     0.150
    20.703   534.015     0.150
    24.950   321.015     0.150
    25.394   323.614     0.150
    41.688   465.515     0.150
    42.746   473.414     0.150
    42.955   475.715     0.150
    46.473   505.114     0.150
    47.436   511.614     0.150
    48.351   518.914     0.150
    49.930   530.414     0.150
    50.809   536.614     0.150
    57.041   579.765     0.150
    65.040   636.614     0.150
    66.107   885.314     0.150
    67.569   654.314     0.150
    67.588   653.814     0.150
    67.854   655.314     0.150
    68.099   903.114     0.150
    68.099  1450.914     0.150
    69.148   662.715     0.150
    70.451   671.114     0.150
    71.060   674.814     0.150
    73.797   691.314     0.150
    74.507   697.914     0.150
    74.507   697.914     0.150
    75.429   700.715     0.150
    75.549   702.314     0.150
    76.321   705.715     0.150
    77.068   710.515     0.150
    78.134   714.244     0.150
    78.134   715.614     0.150
    78.585   718.814     0.150
    79.050   720.314     0.150
    31.018  2378.504     0.150
    31.029  2379.043     0.150
    31.036  2381.074     0.150
    31.885  2442.387     0.150
    31.889  2443.504     0.150
    31.902  2444.461     0.150
    41.734   464.770     0.150
    43.010   476.371     0.150
     1.096    19.180     0.150
     1.096    19.738     0.150
     1.265    38.297     0.150
     1.565    26.680     0.150
     3.787    56.180     0.150
     4.365    66.477     0.150
     4.365   118.477     0.150
     4.545   117.078     0.150
     4.545   125.879     0.150
     6.723    94.250     0.150
     7.409   109.078     0.150
     8.253   119.477     0.150
     9.643   240.227     0.150
     9.686   137.977     0.150
    11.944   175.191     0.150
    14.860   205.379     0.150
    14.860   207.879     0.150
    17.825   245.879     0.150
    20.757   507.477     0.150
    24.967   320.477     0.150
    25.411     7.910     0.150
    27.458   342.477     0.150
    28.645   354.379     0.150
    28.645   411.680     0.150
    31.049  2376.555     0.150
    31.060  2380.816     0.150
    31.067  2380.316     0.150
    31.917  2446.832     0.150
    31.921  2447.703     0.150
    31.934  2444.012     0.150
    37.679   431.277     0.150
    41.707   465.578     0.150
    41.707   465.398     0.150
    41.909   467.578     0.150
    41.909   467.590     0.150
    42.981   475.680     0.150
    42.981   475.988     0.150
    43.308   479.777     0.150
    44.628   489.379     0.150
    44.808   490.977     0.150
    48.368   518.578     0.150
    49.273   524.777     0.150
    49.946   531.680     0.150
    50.829   536.578     0.150
    52.634   550.680     0.150
    52.634   665.578     0.150
    53.780   559.477     0.150
    56.095   574.477     0.150
    63.901   629.180     0.150
    63.901   860.680     0.150
    67.600   651.379     0.150
    67.619   653.680     0.150
    67.898   656.879     0.150
    68.142   656.520     0.150
    68.142   656.520     0.150
    68.142   905.688     0.150
    68.142  1450.207     0.150
    68.142   656.477     0.150
    68.142   682.578     0.150
    68.142   807.078     0.150
    68.142   905.680     0.150
    68.142  1194.879     0.150
    68.142  1450.180     0.150
    70.149   668.680     0.150
    70.498   671.977     0.150
    71.101   676.477     0.150
    73.611   689.758     0.150
    73.839   691.578     0.150
    73.839   691.598     0.150
    74.637   696.270     0.150
    74.637   696.277     0.150
    75.036   699.809     0.150
    75.473   701.180     0.150
    76.458   706.277     0.150
    78.935   719.297     0.150
    78.935   719.277     0.150
    80.412   729.195     0.150
    80.425   729.355     0.150
    86.273   758.578     0.150
   146.803 10990.992     0.150
   146.817 10991.902     0.150
   146.819 10992.285     0.150
     3.201    88.957     0.150
     4.371    66.656     0.150
     4.371    66.438     0.150
     4.543    66.758     0.150
     6.716   101.156     0.150
     6.716   101.016     0.150
     7.405   104.559     0.150
     7.858   110.406     0.150
     8.205   122.066     0.150
     9.685   138.156     0.150
    11.937   173.590     0.150
    12.876   184.355     0.150
    14.868   207.355     0.150
    16.765   230.758     0.150
    17.832   246.156     0.150
    17.832   246.137     0.150
    19.497   262.758     0.150
    20.760    12.102     0.150
    20.760   507.059     0.150
    24.964   320.559     0.150
    25.407   324.656     0.150
    28.652   354.258     0.150
    28.652   401.559     0.150
    28.652   538.758     0.150
    31.051  2378.449     0.150
    31.061  2379.691     0.150
    31.069  2379.785     0.150
    31.918  2440.512     0.150
    31.922  2443.223     0.150
    31.935  2443.824     0.150
    38.634   570.426     0.150
    41.704   465.656     0.150
    41.704   465.516     0.150
    41.906   467.355     0.150
    42.800   474.355     0.150
    42.978   476.156     0.150
    42.978   476.168     0.150
    44.347   487.457     0.150
    44.636   487.406     0.150
    44.636   487.457     0.150
    46.815   507.836     0.150
    48.364   520.156     0.150
    48.803   522.598     0.150
    49.280   524.758     0.150
    49.280   524.785     0.150
    49.942   531.355     0.150
    50.825   536.457     0.150
    51.095   539.719     0.150
    52.633  1217.957     0.150
    52.818   552.957     0.150
    53.777   559.527     0.150
    63.901   629.059     0.150
    67.599   651.355     0.150
    67.618   652.855     0.150
    69.201   663.457     0.150
    73.840   691.547     0.150
    74.194   693.559     0.150
    74.550   695.957     0.150
    74.637   696.695     0.150
    75.593   703.059     0.150
    75.866   703.988     0.150
    75.908   702.758     0.150
    75.982   704.035     0.150
    76.365   706.258     0.150
    76.459   706.156     0.150
    76.570   708.176     0.150
    76.660   706.855     0.150
    76.934   709.629     0.150
    77.340   711.707     0.150
    77.998   713.355     0.150
    78.002   714.457     0.150
    78.438   717.648     0.150
    86.417   758.258     0.150
   146.178  1175.355     0.150
     0.415    13.740     0.150
     0.640    22.350     0.150
     0.811    15.460     0.150
     0.811    27.260     0.150
     0.919    17.730     0.150
     1.074    38.030     0.150
     1.204    21.260     0.150
     1.863    32.550     0.150
     2.899    49.350     0.150
     3.254    52.450     0.150
     3.254    91.750     0.150
     3.841    57.350     0.150
     4.450    74.450     0.150
     5.292    80.700     0.150
     7.377   108.750     0.150
     7.408   106.950     0.150
     8.186   119.750     0.150
     8.337   127.850     0.150
     8.337   227.350     0.150
     8.377   117.760     0.150
     9.170   137.450     0.150
     9.728   245.035     0.150
    11.891   174.350     0.150
    11.891   298.900     0.150
    12.080   176.050     0.150
    12.610   182.350     0.150
    12.704   179.750     0.150
    14.831   218.850     0.150
    14.940   210.650     0.150
    15.345   377.050     0.150
    15.345   216.850     0.150
    19.469   473.450     0.150
    20.131   271.650     0.150
    20.829   282.250     0.150
    20.829   301.450     0.150
    20.829   513.350     0.150
    21.418   290.550     0.150
    22.659   536.550     0.150
    23.855    11.800     0.150
    23.855    17.100     0.150
    24.978   322.950     0.150
    27.477   352.350     0.150
    28.731   351.650     0.150
    28.961   363.650     0.150
    30.832   375.280     0.150
    31.016  2335.424     0.150
    31.027  2336.206     0.150
    31.034  2336.415     0.150
    31.691   384.150     0.150
    31.882  2398.801     0.150
    31.885  2399.004     0.150
    31.899  2399.074     0.150
    39.829   450.954     0.150
    40.438   455.848     0.150
    40.955   459.920     0.150
    41.722   465.950     0.150
    41.722   466.770     0.150
    41.924   468.550     0.150
    41.924   468.660     0.150
    42.868   476.250     0.150
    43.005   478.350     0.150
    43.005   478.350     0.150
    43.256   479.650     0.150
    43.859   483.230     0.150
    43.991   485.850     0.150
    44.888   492.950     0.150
    45.733   501.100     0.150
    46.522   506.690     0.150
    46.495   506.050     0.150
    46.793   507.811     0.150
    47.522   513.350     0.150
    47.852   516.250     0.150
    48.837   524.222     0.150
    50.843   537.450     0.150
    50.843   539.450     0.150
    50.843   539.450     0.150
    51.003   539.101     0.150
    51.109   542.110     0.150
    51.356   547.150     0.150
    52.047   547.850     0.150
    51.992   547.950     0.150
    52.307   549.652     0.150
    52.676   553.510     0.150
    52.676   553.250     0.150
    52.830   551.860     0.150
    53.788   560.950     0.150
    53.788   561.590     0.150
    54.240   564.950     0.150
    56.143   578.250     0.150
    58.896   596.750     0.150
    60.091   605.950     0.150
    62.174   619.800     0.150
    63.799   635.750     0.150
    64.141   634.050     0.150
    64.361   639.850     0.150
    64.785   643.850     0.150
    65.082   644.350     0.150
    65.170   644.450     0.150
    65.924   645.950     0.150
    66.758   657.150     0.150
    67.633   655.250     0.150
    67.652   655.750     0.150
    67.972   656.750     0.150
    68.196   657.140     0.150
    68.196   657.140     0.150
    68.196   818.170     0.150
    68.196   927.180     0.150
    68.196  1557.580     0.150
    68.196   657.050     0.150
    68.196   681.450     0.150
    68.196   818.150     0.150
    68.196  1195.050     0.150
    68.901   662.350     0.150
    70.210   670.350     0.150
    70.553   674.960     0.150
    71.407   682.340     0.150
    72.478   684.850     0.150
    73.891   693.150     0.150
    74.057   693.950     0.150
    74.365   696.810     0.150
    74.601   695.450     0.150
    74.601   695.450     0.150
    74.601   702.550     0.150
    74.686   704.250     0.150
    74.691   696.650     0.150
    74.707   696.950     0.150
    75.008   699.630     0.150
    75.008   699.650     0.150
    75.089   698.550     0.150
    75.422   700.650     0.150
    75.643   703.650     0.150
    75.629   701.750     0.150
    75.646   710.450     0.150
    75.878   703.350     0.150
    75.962   705.450     0.150
    76.004   710.350     0.150
    76.004   710.350     0.150
    76.004   703.850     0.150
    76.163   704.910     0.150
    76.293   707.260     0.150
    76.406   707.550     0.150
    76.418   706.150     0.150
    76.418   706.150     0.150
    76.418   716.050     0.150
    76.516    10.100     0.150
    76.516   707.950     0.150
    76.516    10.000     0.150
    76.714   707.450     0.150
    77.166   716.550     0.150
    77.997   715.150     0.150
    78.054   717.050     0.150
    78.054   725.450     0.150
    78.054   715.450     0.150
    78.942   722.910     0.150
    78.942   722.950     0.150
    80.781   732.650     0.150
   146.098  1175.650     0.150
     1.212    21.574     0.150
     1.212    21.965     0.150
     3.094    49.746     0.150
     3.094    86.746     0.150
     4.896   133.746     0.150
     7.368   107.445     0.150
    14.621   212.445     0.150
    17.625   240.547     0.150
    31.171  2380.020     0.150
    31.182  2382.164     0.150
    31.189  2381.773     0.150
    32.044  2443.637     0.150
    32.047  2444.500     0.150
    32.061  2445.641     0.150
    38.521   441.047     0.150
    41.625   466.047     0.150
    41.625   466.047     0.150
    42.877   474.547     0.150
    43.741   481.645     0.150
    44.034   482.844     0.150
    44.948   491.547     0.150
    47.175   508.246     0.150
    47.175   508.246     0.150
    47.381   511.645     0.150
    52.495   548.145     0.150
    67.479   647.344     0.150
    67.499   653.246     0.150
    67.981   653.344     0.150
    67.981   901.746     0.150
    74.474   695.047     0.150
    75.333   701.246     0.150
    75.346   701.445     0.150
    75.431   702.047     0.150
    76.204   706.047     0.150
     0.287    13.477     0.150
     1.766    28.496     0.150
     2.719    41.996     0.150
     2.719    73.098     0.150
     3.230    47.598     0.150
     4.590    68.996     0.150
     5.303    78.297     0.150
     6.864    98.195     0.150
     6.740   102.398     0.150
     6.740   179.695     0.150
     8.503   215.797     0.150
     8.503   225.797     0.150
     9.520   138.098     0.150
    12.549   320.398     0.150
    12.549   173.457     0.150
    12.549   173.496     0.150
    14.607   201.598     0.150
    15.246   205.098     0.150
    16.525   226.297     0.150
    16.525   405.898     0.150
    20.234   488.695     0.150
    20.245   269.598     0.150
    21.221   282.195     0.150
    21.221    14.301     0.150
    21.221   517.398     0.150
    21.221   545.797     0.150
    21.341   286.797     0.150
    21.693    10.898     0.150
    21.693    16.199     0.150
    23.435    11.398     0.150
    24.997   322.695     0.150
    25.744   325.008     0.150
    25.744   326.297     0.150
    26.188   329.137     0.150
    26.188   539.023     0.150
    26.188   329.098     0.150
    28.659   353.898     0.150
    30.319  2259.328     0.150
    30.330  2260.258     0.150
    30.337  2260.785     0.150
    30.717    11.699     0.150
    31.195  2323.984     0.150
    31.199  2326.945     0.150
    31.212  2330.207     0.150
    37.342   765.598     0.150
    41.299   459.676     0.150
    41.508   461.176     0.150
    41.897   464.469     0.150
    42.682   473.098     0.150
    43.037   473.496     0.150
    43.737   481.195     0.150
    43.916   483.297     0.150
    44.844   489.898     0.150
    46.507   503.117     0.150
    46.985   505.875     0.150
    48.030   515.695     0.150
    48.030   515.605     0.150
    48.230   517.098     0.150
    48.925   521.398     0.150
    49.145   523.898     0.150
    49.145   523.898     0.150
    49.143   521.969     0.150
    49.143   521.996     0.150
    51.602   542.598     0.150
    52.012   545.898     0.150
    52.762   550.098     0.150
    54.195   561.598     0.150
    54.559   563.695     0.150
    55.534   571.152     0.150
    56.717   578.898     0.150
    64.558   632.598     0.150
    64.558  1401.996     0.150
    65.357   638.598     0.150
    65.426   636.996     0.150
    68.332   657.695     0.150
    68.332   657.297     0.150
    68.352   657.695     0.150
    68.777   656.598     0.150
    68.777   910.195     0.150
    70.154   668.195     0.150
    70.657   670.797     0.150
    70.810   671.695     0.150
    70.822   671.695     0.150
    70.822   671.695     0.150
    70.822   671.656     0.150
    72.221   679.707     0.150
    73.473   687.238     0.150
    73.957   691.426     0.150
    74.483   694.496     0.150
    75.076   696.258     0.150
    75.076   696.297     0.150
    75.195   698.797     0.150
    75.265   697.508     0.150
    75.265   697.496     0.150
    75.265   697.797     0.150
    75.265   698.637     0.150
    76.197   703.695     0.150
    76.528   705.258     0.150
    76.528   705.297     0.150
    77.051   706.797     0.150
    77.051   706.797     0.150
    77.051   717.797     0.150
    77.051   708.125     0.150
    77.541   712.098     0.150
    78.676   717.250     0.150
    79.714   723.695     0.150
    80.345   728.734     0.150
    80.375   725.797     0.150
    80.375   725.797     0.150
    80.718   727.047     0.150
    81.079   732.402     0.150
    82.986   741.117     0.150
   146.077 10970.102     0.150
   146.091 10970.359     0.150
   146.093 10970.711     0.150
     0.273    10.203     0.150
     0.273    18.102     0.150
     0.949    28.547     0.150
     3.221    83.203     0.150
    10.503   150.508     0.150
    25.847   325.805     0.150
    26.290   329.805     0.150
    30.204  2258.125     0.150
    30.214  2259.031     0.150
    30.221  2258.391     0.150
    31.079  2322.773     0.150
    31.083  2323.164     0.150
    31.096  2324.445     0.150
    42.585   470.602     0.150
    43.848   480.203     0.150
    48.332   515.008     0.150
    49.196   521.508     0.150
    51.707   540.703     0.150
    54.659   562.203     0.150
    64.781   631.008     0.150
    69.570   659.438     0.150
    74.982   693.781     0.150
     0.289     7.672     0.150
     0.289    13.414     0.150
     0.626    21.395     0.150
     0.729    22.734     0.150
     0.741    23.453     0.150
     0.795    16.754     0.150
     1.095    32.695     0.150
     2.750    45.543     0.150
     2.823    43.242     0.150
     2.823    76.445     0.150
     3.117    89.344     0.150
     4.260   116.742     0.150
     4.932    77.543     0.150
     4.932   135.543     0.150
     6.829   101.445     0.150
     6.829   101.344     0.150
     7.415   105.242     0.150
     7.415   105.445     0.150
     7.971   117.242     0.150
     7.978   118.242     0.150
     9.173   138.145     0.150
     9.173   146.742     0.150
     9.173   245.145     0.150
     9.173   266.445     0.150
    11.009   159.445     0.150
    12.012   169.145     0.150
    12.102   173.844     0.150
    12.979   186.820     0.150
    12.979   187.445     0.150
    14.760   207.445     0.150
    14.760   209.793     0.150
    17.718   243.844     0.150
    18.861     8.398     0.150
    18.861    15.500     0.150
    19.524    12.000     0.150
    19.535   264.844     0.150
    20.222   271.742     0.150
    20.222    19.000     0.150
    20.222   498.445     0.150
    20.668     8.699     0.150
    20.668   507.145     0.150
    20.668   533.145     0.150
    22.699   533.945     0.150
    23.894    11.801     0.150
    23.894    17.699     0.150
    24.956   320.543     0.150
    24.956   320.543     0.150
    25.400   324.945     0.150
    25.400   324.945     0.150
    27.187   353.242     0.150
    27.187     8.902     0.150
    30.012   362.645     0.150
    30.012     9.000     0.150
    30.012    13.500     0.150
    30.012   541.844     0.150
    30.012   667.145     0.150
    31.721     9.801     0.150
    37.121   425.656     0.150
    38.352   437.742     0.150
    38.600   440.543     0.150
    38.933    10.000     0.150
    38.933  1044.844     0.150
    39.819   450.242     0.150
    40.591   457.543     0.150
    40.801   458.504     0.150
    41.691   465.844     0.150
    41.691   465.945     0.150
    41.892   467.945     0.150
    41.892   467.984     0.150
    42.023   468.543     0.150
    42.952   476.043     0.150
    42.952   476.043     0.150
    42.952   475.992     0.150
    43.031   475.945     0.150
    43.374   479.543     0.150
    44.183   486.242     0.150
    44.507   488.645     0.150
    44.836   491.445     0.150
    44.973   490.449     0.150
    45.098   493.242     0.150
    45.208   494.445     0.150
    45.549   497.145     0.150
    46.332   503.000     0.150
    46.427   503.945     0.150
    46.453   504.242     0.150
    46.544   504.844     0.150
    46.952   508.164     0.150
    47.257   510.742     0.150
    47.257   510.754     0.150
    47.442   512.742     0.150
    47.696   513.445     0.150
    47.916   514.484     0.150
    47.934   515.742     0.150
    48.044   517.684     0.150
    48.357   519.242     0.150
    48.357   519.504     0.150
    48.423   517.945     0.150
    49.552   527.613     0.150
    50.362   534.145     0.150
    50.813   537.445     0.150
    50.822   536.672     0.150
    51.291   542.645     0.150
    51.552   543.043     0.150
    51.760   544.445     0.150
    52.584   551.145     0.150
    55.297   570.543     0.150
    56.992   582.363     0.150
    62.626   621.844     0.150
    63.706   624.242     0.150
    64.008   630.043     0.150
    64.149   632.445     0.150
    64.997   637.742     0.150
    65.797   640.344     0.150
    66.481   647.543     0.150
    67.561   652.445     0.150
    67.581   653.742     0.150
    67.806   656.145     0.150
    68.078   657.152     0.150
    68.078   657.152     0.150
    68.078   906.016     0.150
    68.078  1655.504     0.150
    68.078   657.145     0.150
    68.078   807.344     0.150
    68.078   905.945     0.150
    68.078  1195.344     0.150
    68.078  1459.043     0.150
    70.102   668.742     0.150
    72.305   683.645     0.150
    73.623   688.543     0.150
    75.327   700.445     0.150
    75.430   701.445     0.150
    75.880   704.445     0.150
    75.880   704.355     0.150
    76.386   706.543     0.150
    77.914   714.344     0.150
    77.928   715.344     0.150
    78.635   721.043     0.150
    78.928   720.742     0.150
    79.068   722.383     0.150
    80.618   731.645     0.150
    86.321   760.344     0.150
   151.675  1191.344     0.150
    31.956  2444.711     0.150
    31.959  2442.180     0.150
    31.973  2443.336     0.150
    62.706   621.352     0.150
     0.284    18.289     0.150
     0.284     9.820     0.150
     0.285    18.289     0.150
     0.285     9.891     0.150
     0.942    28.633     0.150
     0.928    18.688     0.150
     1.331    23.398     0.150
     1.855    49.039     0.150
     2.667    71.492     0.150
     4.534    68.594     0.150
     4.534   120.391     0.150
     4.764    68.344     0.150
     5.447    78.391     0.150
     6.821    99.391     0.150
     8.291   119.992     0.150
     8.328   119.391     0.150
     8.575   123.688     0.150
     9.092   130.594     0.150
     9.637   139.289     0.150
     9.637   248.891     0.150
    10.090   162.891     0.150
    10.090   250.891     0.150
    10.980   151.789     0.150
    10.980   279.992     0.150
    11.261   167.492     0.150
    12.269   170.789     0.150
    12.648   317.836     0.150
    12.998   192.391     0.150
    13.434   198.891     0.150
    13.520   188.594     0.150
    13.528   190.188     0.150
    13.528   190.070     0.150
    15.183   210.523     0.150
    17.675   240.688     0.150
    17.942   242.812     0.150
    17.942   243.492     0.150
    19.122   257.680     0.150
    20.374   269.688     0.150
    20.762   505.688     0.150
    21.324   298.789     0.150
    21.324   529.188     0.150
    21.324   538.391     0.150
    21.324   551.789     0.150
    21.324   278.000     0.150
    22.179   307.688     0.150
    22.179   326.094     0.150
    22.179   567.391     0.150
    22.285    11.797     0.150
    23.568    13.500     0.150
    23.568    22.500     0.150
    24.765    14.203     0.150
    24.765    21.000     0.150
    24.765   576.891     0.150
    25.112    11.703     0.150
    25.112    17.203     0.150
    25.810    15.203     0.150
    25.887   325.594     0.150
    25.887   325.648     0.150
    27.958    10.500     0.150
    30.178  2257.328     0.150
    30.189  2258.125     0.150
    30.196  2258.867     0.150
    30.845    17.500     0.150
    31.055  2323.477     0.150
    31.059  2323.906     0.150
    31.073  2325.070     0.150
    32.606     9.500     0.150
    32.606    14.703     0.150
    32.606   703.188     0.150
    36.461   424.391     0.150
    37.287    18.000     0.150
    38.867    12.250     0.150
    39.519   444.391     0.150
    39.859     9.000     0.150
    39.859   811.891     0.150
    40.400    15.000     0.150
    40.752   821.391     0.150
    42.103   465.336     0.150
    42.406   467.688     0.150
    42.624   470.094     0.150
    42.825   472.094     0.150
    42.825   472.031     0.150
    43.230   474.438     0.150
    43.246   477.047     0.150
    43.246   476.969     0.150
    43.246   477.094     0.150
    43.693   478.492     0.150
    43.880   479.992     0.150
    43.880   479.992     0.150
    43.880   480.297     0.150
    43.984   480.992     0.150
    43.984   481.188     0.150
    44.014   481.688     0.150
    44.518   485.391     0.150
    44.963   488.688     0.150
    44.963   489.039     0.150
    45.640   495.047     0.150
    45.437   492.594     0.150
    45.769   495.188     0.150
    46.029   497.188     0.150
    46.138   498.289     0.150
    46.419   500.492     0.150
    46.480   500.891     0.150
    46.705   503.492     0.150
    46.837   503.414     0.150
    46.777   503.391     0.150
    47.120   505.789     0.150
    47.358   507.789     0.150
    47.410   508.789     0.150
    47.475   508.391     0.150
    47.676   510.688     0.150
    47.733   510.594     0.150
    48.171   514.148     0.150
    48.171   514.094     0.150
    48.171   514.094     0.150
    48.171   514.242     0.150
    48.629   517.094     0.150
    48.766   518.688     0.150
    48.866   519.391     0.150
    49.142   520.875     0.150
    49.142   520.891     0.150
    49.126   521.789     0.150
    49.342   522.453     0.150
    49.288   522.805     0.150
    49.288   522.492     0.150
    49.288   522.828     0.150
    49.288   523.000     0.150
    49.390   523.953     0.150
    49.606    17.000     0.150
    49.606  1164.391     0.150
    50.867   535.289     0.150
    51.294   537.594     0.150
    51.653   541.289     0.150
    51.653   541.344     0.150
    51.746   540.992     0.150
    52.223   545.992     0.150
    52.485   546.492     0.150
    52.502   546.992     0.150
    52.905   549.492     0.150
    53.468   553.531     0.150
    53.468    17.805     0.150
    53.468   676.992     0.150
    53.468   553.602     0.150
    53.744   555.898     0.150
    54.334   560.688     0.150
    54.334   561.102     0.150
    54.702   562.789     0.150
    54.702   562.852     0.150
    54.804   563.430     0.150
    55.437   568.992     0.150
    55.888   569.742     0.150
    56.312   576.289     0.150
    56.859   577.422     0.150
    56.859   577.492     0.150
    57.189   579.688     0.150
    57.874   584.391     0.150
    62.137   614.891     0.150
    62.618   618.688     0.150
    63.831   646.492     0.150
    64.442   628.641     0.150
    64.690   630.789     0.150
    64.690   630.789     0.150
    64.690   630.648     0.150
    64.690   630.188     0.150
    64.690   630.852     0.150
    64.824   632.992     0.150
    64.824   633.211     0.150
    64.824   633.297     0.150
    65.425   636.492     0.150
    65.506   637.289     0.150
    66.171   642.391     0.150
    66.282   656.594     0.150
    66.282    25.102     0.150
    66.282   792.688     0.150
    66.282   884.688     0.150
    66.282  1161.992     0.150
    66.595   640.391     0.150
    66.595   640.367     0.150
    66.726   644.742     0.150
    67.010   645.688     0.150
    67.464   649.992     0.150
    68.467   656.797     0.150
    68.473   656.117     0.150
    68.473   656.188     0.150
    68.473   656.188     0.150
    68.473   656.094     0.150
    68.493   656.094     0.150
    68.608   656.188     0.150
    68.905   657.648     0.150
    68.905   657.648     0.150
    68.905    18.148     0.150
    68.905   807.641     0.150
    68.905   909.828     0.150
    68.905  1666.578     0.150
    68.905   657.594     0.150
    68.905    18.195     0.150
    68.905   909.789     0.150
    68.905  1197.891     0.150
    68.905  1226.891     0.150
    68.905  1462.891     0.150
    69.635   663.891     0.150
    69.635   664.453     0.150
    69.761   663.133     0.150
    69.826   665.492     0.150
    69.840   663.094     0.150
    69.840  2344.938     0.150
    70.112   666.289     0.150
    70.326   668.094     0.150
    70.376    25.602     0.150
    70.535   667.492     0.150
    70.535   667.508     0.150
    70.633   669.109     0.150
    70.838   667.789     0.150
    70.942   669.688     0.150
    70.954   669.688     0.150
    70.954   670.297     0.150
    71.163   670.992     0.150
    71.163   671.391     0.150
    71.443   672.789     0.150
    71.473   674.117     0.150
    72.032   677.664     0.150
    72.424   675.562     0.150
    72.498  1233.391     0.150
    72.597   681.492     0.150
    72.575   680.547     0.150
    73.059   684.492     0.150
    73.154   683.688     0.150
    73.222   683.617     0.150
    73.754   687.984     0.150
    73.798   687.492     0.150
    73.821   688.688     0.150
    74.037   689.188     0.150
    74.423   690.789     0.150
    74.465   691.891     0.150
    74.612   692.992     0.150
    74.612   692.938     0.150
    74.837   694.289     0.150
    74.990   694.891     0.150
    75.079   695.492     0.150
    75.098   695.891     0.150
    75.098   696.453     0.150
    75.127   695.648     0.150
    75.164   695.188     0.150
    75.393   697.344     0.150
    75.393   697.391     0.150
    75.393   697.414     0.150
    75.475   698.789     0.150
    75.558   698.391     0.150
    75.558   698.508     0.150
    75.728   699.492     0.150
    75.728   699.602     0.150
    75.752   699.391     0.150
    75.799   700.188     0.150
    75.824   699.789     0.150
    76.175   701.891     0.150
    76.207   702.289     0.150
    76.207   701.688     0.150
    76.207   700.117     0.150
    76.337   868.148     0.150
    76.337   702.992     0.150
    76.667   704.992     0.150
    76.655   704.492     0.150
    76.673   704.789     0.150
    76.682   704.852     0.150
    76.686   705.203     0.150
    76.704   705.102     0.150
    76.704   704.992     0.150
    76.723   705.133     0.150
    76.744   704.891     0.150
    76.823   705.594     0.150
    76.921   706.953     0.150
    77.124   707.188     0.150
    77.173   706.688     0.150
    77.173   706.688     0.150
    77.173  1295.391     0.150
    77.173  1643.391     0.150
    77.173  1835.391     0.150
    77.173   706.852     0.150
    77.178   715.141     0.150
    77.178   706.891     0.150
    77.178   715.094     0.150
    77.178   706.906     0.150
    77.296   708.789     0.150
    77.341   708.492     0.150
    77.341   708.500     0.150
    77.405   709.133     0.150
    77.584   709.648     0.150
    77.855   709.594     0.150
    77.855   709.797     0.150
    78.220   712.953     0.150
    78.254   713.297     0.150
    78.535   716.688     0.150
    78.535   715.289     0.150
    78.535   715.391     0.150
    78.621   714.992     0.150
    78.761   714.398     0.150
    78.987   716.789     0.150
    79.056   717.484     0.150
    79.152   718.391     0.150
    79.297   715.188     0.150
    79.502   720.789     0.150
    79.477   719.250     0.150
    79.500   720.352     0.150
    79.519   720.688     0.150
    79.543   720.094     0.150
    79.616   721.312     0.150
    79.644   721.391     0.150
    79.857   721.992     0.150
    79.857   722.500     0.150
    80.248   724.789     0.150
    80.471   724.992     0.150
    80.515   725.289     0.150
    80.652   725.688     0.150
    80.922   727.047     0.150
    80.945   727.531     0.150
    80.945   727.594     0.150
    80.911   727.688     0.150
    81.003   726.391     0.150
    81.004   728.047     0.150
    47.896   727.680     0.150
    81.149   728.391     0.150
    81.144   728.188     0.150
    81.237   727.688     0.150
    81.268   729.094     0.150
    81.334   729.492     0.150
    81.334   729.547     0.150
    81.631   730.891     0.150
    81.673   731.289     0.150
    81.843   732.094     0.150
    81.927   732.492     0.150
    82.004   732.492     0.150
    82.562   735.188     0.150
    84.252   742.719     0.150
    84.305   744.594     0.150
    84.314   744.688     0.150
    84.705   747.594     0.150
    84.705   747.648     0.150
    85.127   748.594     0.150
    85.350   749.289     0.150
    85.906  1377.891     0.150
    85.979   753.891     0.150
    85.979   753.930     0.150
    86.425   755.789     0.150
    86.542   755.703     0.150
    87.595   761.492     0.150
    88.119   764.188     0.150
    89.142   769.188     0.150
    89.997   772.891     0.150
    90.181   773.891     0.150
    93.108  1006.266     0.150
    93.345   788.094     0.150
    93.496   788.922     0.150
    93.496   788.883     0.150
   102.689   828.148     0.150
   118.497  1121.688     0.150
   126.352  1136.891     0.150
   145.953 10967.508     0.150
   145.966 10962.344     0.150
   145.968 10969.625     0.150
   149.717  1183.391     0.150
   151.912  1187.992     0.150
     0.616    20.660     0.150
     0.997    31.551     0.150
     1.159    20.320     0.150
     1.433    24.910     0.150
     2.026    30.680     0.150
     2.135    32.211     0.150
     2.408    37.461     0.150
     2.613    41.301     0.150
     2.828    74.410     0.150
     4.231    63.812     0.150
     4.231   110.609     0.150
     4.489   121.910     0.150
     4.489    65.609     0.150
     4.768    73.160     0.150
     4.927    70.312     0.150
     4.969    73.402     0.150
     5.619    84.031     0.150
     6.319    93.711     0.150
     6.319   163.711     0.150
     6.848   102.949     0.150
     6.850   102.590     0.150
     6.850   100.711     0.150
     7.394   193.645     0.150
     7.402  2869.711     0.150
     7.551  2729.711     0.150
     8.120   212.312     0.150
     8.120   118.910     0.150
     8.217   118.109     0.150
     8.864   127.109     0.150
     9.152   137.512     0.150
     9.152   246.211     0.150
     9.604   251.035     0.150
     9.604   136.812     0.150
    10.432   150.711     0.150
    10.432   259.711     0.150
    10.817   283.609     0.150
    10.817   272.812     0.150
    12.011   303.418     0.150
    11.993   172.992     0.150
    12.011   172.941     0.150
    12.011   172.910     0.150
    12.083   183.012     0.150
    12.521   176.312     0.150
    12.499   184.211     0.150
    12.499   326.711     0.150
    12.855   184.730     0.150
    12.855   185.395     0.150
    12.855   332.250     0.150
    12.855   184.711     0.150
    12.932   185.012     0.150
    12.990   184.410     0.150
    12.990   183.887     0.150
    12.990   185.812     0.150
    12.990   184.910     0.150
    13.643   194.609     0.150
    13.643   338.812     0.150
    14.685   361.711     0.150
    14.746   373.387     0.150
    14.752  5319.711     0.150
    15.154   368.711     0.150
    15.154   209.012     0.150
    15.630   207.188     0.150
    15.630   372.035     0.150
    15.857   222.109     0.150
    15.857   399.211     0.150
    16.717   231.711     0.150
    17.692   437.480     0.150
    17.692   244.109     0.150
    17.692   244.270     0.150
    18.842    11.598     0.150
    18.842    16.500     0.150
    18.842   470.812     0.150
    20.214   270.812     0.150
    20.636   496.504     0.150
    20.636   275.012     0.150
    20.636    11.898     0.150
    20.636   504.012     0.150
    20.636   275.070     0.150
    21.175     9.000     0.150
    21.175   505.012     0.150
    21.227   279.711     0.150
    21.227   295.109     0.150
    21.227   311.312     0.150
    21.227   320.312     0.150
    21.227   521.910     0.150
    21.482     9.000     0.150
    22.682    15.398     0.150
    23.032     9.500     0.150
    23.878    10.602     0.150
    23.878    17.102     0.150
    23.878   617.711     0.150
    24.031   308.160     0.150
    24.031   308.211     0.150
    24.353    11.398     0.150
    24.353    15.000     0.150
    24.353   348.109     0.150
    24.764   317.723     0.150
    24.931   318.609     0.150
    24.931   318.973     0.150
    25.164    10.398     0.150
    25.164    17.699     0.150
    25.164   579.512     0.150
    25.375   322.770     0.150
    25.375   322.430     0.150
    26.176     8.602     0.150
    27.178    11.402     0.150
    27.178   391.512     0.150
    27.178   612.812     0.150
    27.178   636.812     0.150
    27.591   342.609     0.150
    27.591   619.109     0.150
    29.133   356.410     0.150
    29.998    11.203     0.150
    29.998    19.703     0.150
    29.998   657.711     0.150
    30.784   367.012     0.150
    31.118  2379.535     0.150
    31.129  2382.852     0.150
    31.136  2379.535     0.150
    31.703   380.211     0.150
    31.703     9.801     0.150
    31.989  2445.953     0.150
    31.993  2445.949     0.150
    32.007  2448.336     0.150
    32.519    12.699     0.150
    33.004    20.000     0.150
    33.004   716.609     0.150
    33.703   395.711     0.150
    35.968   418.480     0.150
    35.968    10.039     0.150
    36.467    10.500     0.150
    36.589     7.699     0.150
    36.589    10.301     0.150
    36.589   769.312     0.150
    36.598   422.012     0.150
    36.598    11.000     0.150
    36.598   758.109     0.150
    36.598   422.141     0.150
    38.909     9.598     0.150
    38.909     9.281     0.150
    39.670     9.801     0.150
    39.793   449.832     0.150
    40.576   456.410     0.150
    40.576   456.211     0.150
    41.867   467.012     0.150
    41.867   466.949     0.150
    42.407   472.941     0.150
    42.663   473.734     0.150
    42.686   471.312     0.150
    42.924   475.109     0.150
    43.003   475.312     0.150
    43.371   479.812     0.150
    43.614   857.961     0.150
    44.088   484.711     0.150
    44.088   484.312     0.150
    44.088   484.750     0.150
    44.225   486.043     0.150
    44.173   485.723     0.150
    44.173   485.711     0.150
    44.509   487.410     0.150
    44.483   487.941     0.150
    44.811   490.699     0.150
    44.991   496.910     0.150
    45.183   493.633     0.150
    45.183   890.980     0.150
    45.525   496.199     0.150
    45.671   498.012     0.150
    46.308   503.332     0.150
    46.402   503.090     0.150
    46.428   503.789     0.150
    46.520   504.230     0.150
    46.779   506.070     0.150
    46.876   506.812     0.150
    46.903   505.609     0.150
    47.177   910.660     0.150
    47.227   919.133     0.150
    47.227   509.609     0.150
    47.670   512.770     0.150
    47.909   514.973     0.150
    48.116   517.512     0.150
    48.332   937.598     0.150
    48.332   518.562     0.150
    48.332   518.211     0.150
    48.332   518.512     0.150
    48.332   518.441     0.150
    48.658    16.500     0.150
    48.658   965.312     0.150
    49.148   523.930     0.150
    50.337   533.641     0.150
    50.787   535.711     0.150
    50.787   536.910     0.150
    51.265   541.859     0.150
    51.527   542.480     0.150
    51.644   543.410     0.150
    51.734   544.031     0.150
    53.404   557.312     0.150
    53.952   562.211     0.150
    54.022   559.832     0.150
    54.224   562.410     0.150
    54.606  1743.910     0.150
    54.707   567.211     0.150
    54.886   577.711     0.150
    55.003  1800.383     0.150
    55.372   568.402     0.150
    55.917   573.711     0.150
    55.917   573.750     0.150
    55.922   573.312     0.150
    56.301   586.512     0.150
    56.446   579.129     0.150
    57.096   582.770     0.150
    57.127   594.109     0.150
    57.675  1050.711     0.150
    58.145   590.211     0.150
    58.216   590.211     0.150
    58.264   589.812     0.150
    58.690  2364.562     0.150
    58.690  2815.062     0.150
    59.021   606.012     0.150
    59.399   599.449     0.150
    62.245   617.461     0.150
    62.392   619.812     0.150
    62.888  1124.082     0.150
    62.951   618.812     0.150
    63.513   626.910     0.150
    63.809   627.812     0.150
    63.809   636.109     0.150
    63.809   649.012     0.150
    63.809  1130.410     0.150
    63.809  1555.711     0.150
    63.809   628.312     0.150
    63.809   627.812     0.150
    63.809   628.320     0.150
    64.548   635.410     0.150
    64.551  1584.789     0.150
    64.966   636.512     0.150
    64.962   636.652     0.150
    65.332  1418.312     0.150
    65.379   637.781     0.150
    65.764   639.609     0.150
    66.467   644.812     0.150
    66.467   644.801     0.150
    66.821   648.223     0.150
    67.531   651.512     0.150
    67.531   653.410     0.150
    67.531   653.723     0.150
    67.551   653.211     0.150
    68.046   656.250     0.150
    68.046   656.250     0.150
    68.046   811.262     0.150
    68.046   945.223     0.150
    68.046   656.211     0.150
    68.046   683.109     0.150
    68.046   811.211     0.150
    68.046  1192.211     0.150
    68.046  1456.812     0.150
    68.346  1189.410     0.150
    68.697   659.012     0.150
    68.683   661.012     0.150
    68.683   661.512     0.150
    68.683   661.570     0.150
    68.921   661.301     0.150
    69.027   662.410     0.150
    69.085   661.812     0.150
    69.338   663.852     0.150
    69.438    15.902     0.150
    69.438   917.512     0.150
    69.920   668.609     0.150
    70.023   670.777     0.150
    70.070   668.109     0.150
    70.070   667.703     0.150
    70.070   668.012     0.150
    70.070   667.691     0.150
    70.070   668.070     0.150
    70.153   668.211     0.150
    70.536   671.109     0.150
    70.687   671.789     0.150
    70.687  1224.262     0.150
    70.687   671.871     0.150
    70.803   673.680     0.150
    71.354   678.730     0.150
    71.576   687.812     0.150
    71.636   679.820     0.150
    72.146   679.871     0.150
    72.261   681.312     0.150
    72.261   681.312     0.150
    72.327   682.410     0.150
    72.840   683.711     0.150
    72.840   701.711     0.150
    72.898  1243.711     0.150
    72.898   684.711     0.150
    72.898   702.711     0.150
    72.898  1243.711     0.150
    73.744   691.340     0.150
    74.104   693.109     0.150
    74.124   693.012     0.150
    74.455   694.910     0.150
    74.466   694.609     0.150
    74.539   695.762     0.150
    74.660   696.512     0.150
    74.660   696.512     0.150
    74.708   695.219     0.150
    74.708   695.211     0.150
    74.843   696.312     0.150
    74.843   697.133     0.150
    74.849   697.711     0.150
    74.849   697.820     0.150
    74.891   697.145     0.150
    74.918   697.109     0.150
    74.939   698.512     0.150
    74.939   698.562     0.150
    74.945   697.574     0.150
    75.123   698.797     0.150
    75.315   699.312     0.150
    75.291   700.512     0.150
    75.310   700.109     0.150
    75.310   700.242     0.150
    75.471   701.141     0.150
    75.496   702.012     0.150
    75.514   701.410     0.150
    75.514   701.371     0.150
    75.515   701.812     0.150
    75.572   701.711     0.150
    75.593   701.723     0.150
    75.727   702.312     0.150
    75.765   702.711     0.150
    75.769   701.992     0.150
    75.769   702.012     0.150
    75.769   703.223     0.150
    75.778   702.609     0.150
    75.808   702.895     0.150
    75.808   702.812     0.150
    75.845   703.312     0.150
    75.847   703.512     0.150
    75.847   703.609     0.150
    75.845   703.320     0.150
    75.847   703.672     0.150
    75.863   702.312     0.150
    75.881   703.410     0.150
    75.988   704.512     0.150
    76.043   703.555     0.150
    76.259   704.812     0.150
    76.268   705.711     0.150
    76.352   715.789     0.150
    76.352  2741.289     0.150
    76.352   705.672     0.150
    76.353    17.199     0.150
    76.353  1290.711     0.150
    76.353   705.312     0.150
    76.353   985.711     0.150
    76.353  1290.711     0.150
    76.353  1609.711     0.150
    76.353  1783.711     0.150
    76.353  1933.711     0.150
    76.353   705.453     0.150
    76.353   705.520     0.150
    76.390   706.512     0.150
    76.390   706.520     0.150
    76.559   707.512     0.150
    76.559   707.621     0.150
    76.759  1287.910     0.150
    76.759   708.320     0.150
    76.796   708.609     0.150
    76.808   709.109     0.150
    76.832  1289.012     0.150
    76.832   708.609     0.150
    76.832  1289.012     0.150
    76.865   708.961     0.150
    76.882   708.211     0.150
    76.911   708.328     0.150
    77.014   710.012     0.150
    77.014   710.312     0.150
    77.017   711.410     0.150
    77.229   710.910     0.150
    77.248   710.512     0.150
    77.253   711.070     0.150
    77.432   712.211     0.150
    77.470   712.680     0.150
    77.847   714.539     0.150
    77.860  1296.812     0.150
    77.860   714.312     0.150
    77.860  1296.812     0.150
    77.895   714.871     0.150
    77.908   713.312     0.150
    78.078   715.402     0.150
    78.078  2323.234     0.150
    78.118   715.250     0.150
    78.332   717.312     0.150
    78.332   717.371     0.150
    78.658   719.410     0.150
    78.658   719.012     0.150
    78.904   719.711     0.150
    79.152   722.410     0.150
    79.272   719.812     0.150
    79.331   722.859     0.150
    79.394   724.012     0.150
    79.837   725.250     0.150
    79.932   725.410     0.150
    80.171   727.320     0.150
    80.410   728.172     0.150
    80.521   728.211     0.150
    80.564   726.699     0.150
    80.823   730.570     0.150
    80.950   730.039     0.150
    81.224   729.211     0.150
    81.340   733.332     0.150
    81.665   728.910     0.150
    81.705   735.223     0.150
    81.974   736.531     0.150
    81.974   736.852     0.150
    82.812   739.910     0.150
    83.367   743.633     0.150
    83.367   743.602     0.150
    84.512   749.270     0.150
    85.421   754.410     0.150
    85.652   754.570     0.150
    86.158   757.012     0.150
    86.865   756.312     0.150
    86.865   955.410     0.150
    87.504   764.473     0.150
    88.244   767.410     0.150
    89.303   771.211     0.150
    89.303   771.211     0.150
    91.497   780.891     0.150
    91.892   785.883     0.150
    91.915   785.262     0.150
    92.553   788.949     0.150
    92.570   787.410     0.150
    94.176   797.770     0.150
    94.657   798.082     0.150
   117.621  1121.973     0.150
   117.621  1122.012     0.150
   122.290  1130.711     0.150
   127.889  1142.039     0.150
   132.495  1293.430     0.150
   134.523  1155.211     0.150
   138.825  1151.789     0.150
   143.180  1167.535     0.150
   144.768  1171.934     0.150
   146.316  1176.254     0.150
   146.778 11092.590     0.150
   146.791 11097.602     0.150
   146.793 11093.883     0.150
   147.905  1180.738     0.150
   148.181  1180.711     0.150
   148.304  1181.840     0.150
     1.178    20.551     0.150
     2.842    42.652     0.150
     2.842    74.453     0.150
     3.127    50.453     0.150
     3.127    88.250     0.150
     4.223    61.242     0.150
     4.223    63.250     0.150
     4.470    66.652     0.150
     4.935    78.750     0.150
     4.935   134.953     0.150
     4.977    73.953     0.150
     7.375   104.152     0.150
    14.749   208.551     0.150
    14.749   207.852     0.150
    17.686   243.750     0.150
    17.686   243.750     0.150
    20.621   277.750     0.150
    29.662   364.152     0.150
    41.645   464.383     0.150
    41.645   466.750     0.150
    41.645   580.824     0.150
    41.645   465.652     0.150
    42.904   477.652     0.150
    42.904   477.652     0.150
    49.146   523.551     0.150
    49.893   531.453     0.150
    52.534   548.820     0.150
    52.534   548.852     0.150
    54.667   564.711     0.150
    54.989   565.891     0.150
    56.961   580.492     0.150
    56.961   580.453     0.150
    59.405   598.652     0.150
    62.790   622.051     0.150
    63.957   630.051     0.150
    64.956   636.852     0.150
    66.517   646.551     0.150
    70.040   668.750     0.150
    70.052   668.352     0.150
    75.406   697.523     0.150
    76.336   706.352     0.150
    77.866   714.352     0.150
    31.139  2380.492     0.150
    31.149  2381.387     0.150
    31.157  2381.289     0.150
    32.009  2441.988     0.150
    32.013  2443.133     0.150
    32.026  2446.195     0.150
    42.981   474.469     0.150
    44.527   486.184     0.150
     0.653    13.023     0.150
     0.653    22.934     0.150
     2.839    42.344     0.150
     2.839    74.547     0.150
     3.128    50.246     0.150
     3.128    88.246     0.150
    21.122   280.445     0.150
    31.119  2381.562     0.150
    31.130  2380.258     0.150
    31.137  2382.238     0.150
    31.990  2446.367     0.150
    31.993  2447.438     0.150
    32.007  2444.590     0.150
    41.662   464.434     0.150
    41.662   464.445     0.150
    41.662   464.445     0.150
    42.922   475.547     0.150
    43.001   475.547     0.150
     0.257     9.949     0.150
     0.257    17.648     0.150
     2.711    41.648     0.150
     2.711    73.051     0.150
     4.697    70.148     0.150
     6.834    94.840     0.150
     6.834    94.852     0.150
    21.422   277.949     0.150
    30.176  2263.879     0.150
    30.187  2259.043     0.150
    30.194  2256.898     0.150
    31.052  2336.617     0.150
    31.055  2335.590     0.150
    31.069  2335.406     0.150
    37.002   425.719     0.150
    39.019   442.789     0.150
    39.060   442.262     0.150
    39.519   445.148     0.150
    42.616   470.352     0.150
    42.616   470.551     0.150
    42.616   470.551     0.150
    43.274   476.430     0.150
    43.276   477.430     0.150
    43.877   480.648     0.150
    44.448   485.148     0.150
    45.177   492.191     0.150
    48.363   515.949     0.150
    49.304   524.141     0.150
    51.738   541.148     0.150
    51.738   540.750     0.150
    62.411   617.051     0.150
    64.801   631.250     0.150
    66.138   643.199     0.150
     2.193    32.922     0.150
     2.193    58.422     0.150
     2.647    72.324     0.150
     3.135    47.422     0.150
     3.135    82.324     0.150
     4.514   119.324     0.150
    30.170  2254.027     0.150
    30.180  2262.027     0.150
    30.187  2261.012     0.150
    31.047  2323.402     0.150
    31.051  2322.293     0.150
    31.064  2323.812     0.150
    43.891   480.723     0.150
    64.784   629.449     0.150
    76.346   700.371     0.150
     0.560    12.527     0.150
     1.428    45.883     0.150
     1.628    25.656     0.150
     2.349    72.758     0.150
     4.529   118.656     0.150
    21.063   285.957     0.150
    21.063   285.957     0.150
    30.671  2275.660     0.150
    30.681  2265.234     0.150
    30.688  2269.727     0.150
    31.550  2338.840     0.150
    31.554  2332.273     0.150
    31.567  2340.551     0.150
    39.033   445.902     0.150
    43.402   481.656     0.150
    64.289   633.957     0.150
     1.204    20.695     0.150
     1.204    39.098     0.150
     2.776    77.395     0.150
     2.776    43.695     0.150
     2.776    77.395     0.150
     2.833    74.195     0.150
     3.111    84.098     0.150
     3.724    55.195     0.150
     3.724    97.195     0.150
     4.184    64.598     0.150
     4.915   135.297     0.150
     6.888    99.297     0.150
     7.365   106.297     0.150
    38.527   439.496     0.150
    42.882   475.297     0.150
    42.882   475.297     0.150
    45.836   496.977     0.150
    46.526   503.105     0.150
    47.382   511.098     0.150
    48.296   517.695     0.150
    48.296   517.695     0.150
    62.829   620.797     0.150
    63.923   628.996     0.150
    68.682   659.297     0.150
    73.865   690.598     0.150
     0.265    10.104     0.150
     0.957    28.774     0.150
     1.876    45.954     0.150
     2.246    33.604     0.150
     2.246    59.604     0.150
     2.701    72.904     0.150
     3.188    47.804     0.150
     4.567   117.104     0.150
     6.845    99.704     0.150
     8.599   124.004     0.150
     8.599   217.304     0.150
    12.619   177.704     0.150
    21.411   280.904     0.150
    28.716   349.604     0.150
    30.179  2258.646     0.150
    30.190  2255.824     0.150
    30.197  2260.124     0.150
    31.055  2322.242     0.150
    31.059  2323.337     0.150
    31.072  2322.273     0.150
    39.517   568.871     0.150
    42.616   579.705     0.150
    42.817   471.404     0.150
    43.875   480.204     0.150
    48.170   514.804     0.150
    48.363   515.604     0.150
    51.737   540.504     0.150
    51.737   541.104     0.150
    53.471   553.204     0.150
    53.471   612.804     0.150
    56.846   577.204     0.150
    57.219   579.404     0.150
    59.019   592.304     0.150
    64.696   631.204     0.150
    68.472   655.404     0.150
    76.337   702.704     0.150
    77.184   705.804     0.150
    79.967   720.829     0.150
    83.912   741.094     0.150
   145.975 10959.131     0.150
   145.988 10958.309     0.150
   145.991 10960.850     0.150
   146.119  1171.804     0.150
     0.270     9.930     0.150
     0.270    18.031     0.150
     0.952    28.441     0.150
     2.248    59.430     0.150
     6.845    97.230     0.150
    26.316   330.332     0.150
    30.184  2259.453     0.150
    30.195  2258.977     0.150
    30.202  2260.891     0.150
    31.060  2319.434     0.150
    31.064  2324.969     0.150
    31.077  2325.969     0.150
    41.540   456.109     0.150
    42.610   470.332     0.150
    43.806   475.070     0.150
    46.935   499.812     0.150
    48.358   516.230     0.150
    51.732   540.633     0.150
    57.217   577.520     0.150
    57.217   577.531     0.150
    64.789   631.230     0.150
    66.150   637.973     0.150
     0.306    10.362     0.150
     0.307    10.372     0.150
     0.921    27.712     0.150
     1.832    29.922     0.150
     1.833    44.122     0.150
     2.275    35.072     0.150
     2.653    40.472     0.150
     2.653    71.872     0.150
     3.145    47.172     0.150
     3.145    83.372     0.150
     4.520    66.771     0.150
     4.785    68.922     0.150
     5.656    82.422     0.150
     6.897    99.182     0.150
     8.321   118.672     0.150
     8.553   123.271     0.150
     8.553   215.472     0.150
    17.920   245.271     0.150
    25.878   326.072     0.150
    26.322   328.622     0.150
    26.322   328.672     0.150
    30.193  2256.143     0.150
    30.204  2256.658     0.150
    30.211  2257.484     0.150
    30.844    23.700     0.150
    31.071  2319.199     0.150
    31.074  2319.400     0.150
    31.088  2320.512     0.150
    39.505   444.771     0.150
    39.505   571.072     0.150
    42.391   468.172     0.150
    42.815   471.771     0.150
    43.867   479.771     0.150
    43.867   480.082     0.150
    44.500   486.672     0.150
    45.727   495.191     0.150
    46.088   493.492     0.150
    48.157   513.872     0.150
    48.137   511.202     0.150
    48.364   516.072     0.150
    48.364   516.012     0.150
    49.279   523.172     0.150
    50.858   535.271     0.150
    51.736   540.872     0.150
    53.452   553.216     0.150
    53.452   553.271     0.150
    56.875   576.572     0.150
    64.039   625.462     0.150
    64.672   628.771     0.150
    65.403   635.771     0.150
    65.403   634.472     0.150
    65.403   635.722     0.150
    68.453   655.507     0.150
    68.479   655.872     0.150
    75.374   696.252     0.150
    75.374   696.271     0.150
    75.383   696.672     0.150
    76.322   702.072     0.150
    76.322   702.271     0.150
    76.335   702.972     0.150
    76.636   704.271     0.150
    76.663   704.122     0.150
    77.153   706.572     0.150
    77.153   706.622     0.150
    77.848   710.172     0.150
    77.848   710.072     0.150
    78.709   715.672     0.150
    79.111   715.712     0.150
    80.119   722.662     0.150
    84.068   745.422     0.150
    88.688  6690.361     0.150
   145.952 10969.602     0.150
   145.966 10970.600     0.150
   145.968 10970.949     0.150
     1.581    53.129     0.150
     1.581    27.068     0.150
     3.186    51.469     0.150
     3.186    51.469     0.150
     3.186    89.170     0.150
     3.777    58.369     0.150
     3.777    58.369     0.150
     4.575    73.469     0.150
     6.698   104.170     0.150
     6.711   101.068     0.150
     6.711    97.068     0.150
     8.202   114.379     0.150
    10.915   160.670     0.150
    11.955   174.869     0.150
    11.955   181.568     0.150
    14.865   209.068     0.150
    21.263   289.969     0.150
    22.699   306.670     0.150
    25.439   330.729     0.150
    25.439   334.369     0.150
    31.019  2382.467     0.150
    31.029  2384.145     0.150
    31.037  2384.322     0.150
    31.886  2445.215     0.150
    31.890  2445.469     0.150
    31.903  2446.521     0.150
    36.432   430.170     0.150
    38.666   443.520     0.150
    38.666   450.770     0.150
    38.965   453.170     0.150
    41.736   475.270     0.150
    41.736   467.119     0.150
    41.736   469.295     0.150
    41.736   476.770     0.150
    42.467   470.699     0.150
    43.011   485.270     0.150
    43.089   477.994     0.150
    43.916   483.969     0.150
    47.274   512.170     0.150
    47.325   520.170     0.150
    47.480   514.199     0.150
    47.480   514.170     0.150
    48.712   534.170     0.150
    49.974   532.770     0.150
    50.857   537.670     0.150
    54.781   568.279     0.150
    54.781   567.920     0.150
    64.111   630.973     0.150
    64.111   637.670     0.150
    67.631   663.770     0.150
    67.650   656.943     0.150
    69.204   666.094     0.150
    69.228   672.270     0.150
    69.228   667.020     0.150
    69.918   668.049     0.150
    70.180   671.717     0.150
   146.169  1175.469     0.150
   157.358  1195.219     0.150
     0.195     6.240     0.150
     0.289     7.899     0.150
     0.289    13.460     0.150
     0.396     8.569     0.150
     0.460     9.819     0.150
     0.838    14.270     0.150
     2.223    35.760     0.150
     2.223    61.960     0.150
     2.599    41.160     0.150
     3.104    84.160     0.150
     4.464    67.160     0.150
     8.463   124.960     0.150
     9.634   236.035     0.150
    10.051   141.760     0.150
    12.969   186.560     0.150
    13.356   192.560     0.150
    25.836   329.260     0.150
    30.256  2270.606     0.150
    30.266  2258.746     0.150
    30.273  2257.982     0.150
    31.135  2321.293     0.150
    31.139  2322.111     0.150
    31.152  2327.743     0.150
    32.582     2.700     0.150
    42.567   473.460     0.150
    43.813   483.160     0.150
    48.097   517.660     0.150
    48.097   517.660     0.150
    49.236   526.060     0.150
    50.817   538.660     0.150
    51.690   544.460     0.150
    51.690   544.060     0.150
    53.384  1219.359     0.150
    54.654   566.359     0.150
    65.313   639.960     0.150
    68.397   660.260     0.150
    68.418   659.359     0.150
    69.735   670.260     0.150
    69.735   665.769     0.150
    70.038   670.060     0.150
    72.794   686.750     0.150
    77.073   710.760     0.150
    78.488   718.258     0.150
    78.488   718.260     0.150
   145.956 10957.328     0.150
   145.969 10957.266     0.150
   145.971 10967.641     0.150
     0.959    28.611     0.150
     1.878    61.041     0.150
     2.247    33.492     0.150
     2.247    59.691     0.150
     2.324    36.393     0.150
     6.843    98.191     0.150
    12.618   174.441     0.150
    30.178  2257.703     0.150
    30.188  2258.648     0.150
    30.196  2259.172     0.150
    31.054  2320.645     0.150
    31.057  2321.768     0.150
    31.071  2325.588     0.150
    42.413   468.492     0.150
    42.616   469.691     0.150
    42.616   468.969     0.150
    42.616   470.092     0.150
    42.616   470.092     0.150
    43.876   479.393     0.150
    43.876   479.393     0.150
    53.473   553.191     0.150
    54.692   562.691     0.150
    76.338   701.668     0.150
    85.953   754.592     0.150
   145.976 10965.791     0.150
   145.989 10968.146     0.150
   145.991 10968.131     0.150
     0.546    13.492     0.150
     0.546    13.543     0.150
     1.144    32.742     0.150
     1.902    30.143     0.150
     1.902    52.643     0.150
     2.286    36.143     0.150
     4.633    69.242     0.150
     4.633   118.941     0.150
     7.212   103.043     0.150
    29.882  2250.848     0.150
    29.893  2259.051     0.150
    29.900  2251.639     0.150
    30.770  2320.178     0.150
    30.774  2324.898     0.150
    30.787  2323.158     0.150
    44.218   484.342     0.150
    44.298   586.115     0.150
    62.600   618.643     0.150
   145.491 10944.586     0.150
   145.505 10945.633     0.150
   145.507 10946.230     0.150
     0.916    28.438     0.150
     2.285    34.141     0.150
     2.285    59.938     0.150
     2.352    36.742     0.150
     2.352    64.336     0.150
    30.237  2260.148     0.150
    30.248  2255.977     0.150
    30.255  2261.508     0.150
    31.113  2323.445     0.150
    31.116  2325.453     0.150
    31.130  2326.188     0.150
    43.815   480.141     0.150
     0.317    10.690     0.150
     0.317    18.290     0.150
     0.906    27.980     0.150
     1.834    46.590     0.150
     2.285    60.690     0.150
     2.285    34.390     0.150
     4.594    74.990     0.150
     4.653   120.790     0.150
    21.393   514.613     0.150
    25.807   325.690     0.150
    26.251   330.090     0.150
    30.247  2256.089     0.150
    30.258  2261.174     0.150
    30.265  2259.572     0.150
    31.123  2325.325     0.150
    31.127  2325.503     0.150
    31.140  2325.981     0.150
    39.448   443.390     0.150
    42.545   467.890     0.150
    43.805   479.890     0.150
    47.328   507.690     0.150
    48.292   514.790     0.150
    51.667   540.190     0.150
    54.621   561.690     0.150
    64.736   630.365     0.150
    64.736   630.390     0.150
    71.404   676.290     0.150
    84.384   744.030     0.150
   132.038  1143.311     0.150
   146.038 10959.424     0.150
   146.051 10961.836     0.150
   146.053 10956.887     0.150
     0.287    10.316     0.150
     1.852    46.066     0.150
     1.853    46.066     0.150
     2.230    33.516     0.150
     2.303    36.016     0.150
     2.303    63.516     0.150
     3.172    54.016     0.150
     3.172    89.715     0.150
     4.663    69.613     0.150
     5.432    79.316     0.150
     5.627    81.375     0.150
     8.575   117.016     0.150
     9.522   230.840     0.150
     9.630   138.516     0.150
    21.320   519.715     0.150
    21.320   279.113     0.150
    21.320   512.414     0.150
    25.793   327.516     0.150
    25.872   326.316     0.150
    27.940   347.113     0.150
    30.191  2260.020     0.150
    30.202  2261.059     0.150
    30.209  2260.621     0.150
    30.827    17.301     0.150
    31.068  2326.359     0.150
    31.072  2324.242     0.150
    31.085  2325.121     0.150
    37.458    14.199     0.150
    39.113   440.016     0.150
    39.506   571.391     0.150
    42.608   469.914     0.150
    42.810   471.316     0.150
    43.866   479.914     0.150
    47.370   506.996     0.150
    47.394   508.914     0.150
    48.357   515.613     0.150
    49.151   520.914     0.150
    49.272   522.816     0.150
    49.272   522.816     0.150
    51.731   540.215     0.150
    54.686   561.375     0.150
    57.195   579.215     0.150
    59.544   596.414     0.150
    65.426   635.316     0.150
    67.058   644.414     0.150
    70.932   668.414     0.150
    70.944   669.516     0.150
    74.979   694.215     0.150
    76.325   701.414     0.150
    76.636   696.207     0.150
    76.646   704.113     0.150
    77.165   706.316     0.150
    78.720   715.113     0.150
    79.143   716.453     0.150
    79.143   716.414     0.150
    79.144   716.414     0.150
    79.144   716.414     0.150
   145.970 10960.457     0.150
   145.984 10961.504     0.150
   145.986 10961.691     0.150
     0.317     9.695     0.150
     1.211    21.602     0.150
     1.211    37.203     0.150
     1.211    21.508     0.150
     2.806    46.008     0.150
     2.843    44.406     0.150
     2.843    78.703     0.150
     2.895    43.102     0.150
     2.895    75.406     0.150
     4.242    64.805     0.150
     4.432    66.203     0.150
     4.985   135.602     0.150
     6.819   101.906     0.150
     8.125   214.805     0.150
     8.125   206.805     0.150
     9.763   141.258     0.150
    10.795   159.203     0.150
    12.449   179.906     0.150
    16.728   233.453     0.150
    17.711   243.906     0.150
    17.711   245.422     0.150
    19.442    10.102     0.150
    19.442    16.898     0.150
    19.453   264.906     0.150
    19.453   264.867     0.150
    20.617   505.602     0.150
    20.617   276.906     0.150
    21.414   290.102     0.150
    27.110    11.898     0.150
    35.909    16.500     0.150
    38.517   570.109     0.150
    41.806   467.008     0.150
    42.868   475.508     0.150
    42.868   475.203     0.150
    42.947   583.695     0.150
    43.307   480.008     0.150
    43.307   480.016     0.150
    49.850   530.906     0.150
    50.727   536.906     0.150
    52.506   550.805     0.150
    52.506  1205.703     0.150
    53.686   559.008     0.150
    53.686   559.008     0.150
    55.963   576.102     0.150
    59.153    15.000     0.150
    63.768   629.805     0.150
    63.768    19.000     0.150
    63.768   659.602     0.150
    63.768  1152.805     0.150
    63.768   629.805     0.150
    64.192   631.805     0.150
    65.841   642.305     0.150
    67.479   652.805     0.150
    68.007    19.906     0.150
    68.007   906.203     0.150
    68.007  1218.703     0.150
    68.736   660.203     0.150
    72.218   681.508     0.150
    74.062   693.203     0.150
    74.421   695.102     0.150
    74.499   696.008     0.150
    74.616   697.008     0.150
    74.901   696.406     0.150
    75.691   703.102     0.150
    75.730   703.008     0.150
    75.771   702.906     0.150
    75.810   702.812     0.150
    75.812   703.602     0.150
    75.845   703.305     0.150
    76.320   705.703     0.150
    76.320    14.102     0.150
    76.979   710.703     0.150
    77.860   714.703     0.150
    77.913   715.266     0.150
    77.913   715.266     0.150
    78.657   718.844     0.150
    78.999   719.281     0.150
    78.999   719.289     0.150
    79.597   724.641     0.150
    79.613   724.422     0.150
    79.613   724.406     0.150
    80.100   726.344     0.150
    80.100   726.344     0.150
    80.100   726.305     0.150
    86.202   758.102     0.150
     1.494    40.074     0.150
     1.494    25.398     0.150
     2.156    32.199     0.150
     2.788    44.898     0.150
     2.813    43.000     0.150
     2.813    76.199     0.150
     2.855    41.898     0.150
     2.855    73.598     0.150
     3.153    47.598     0.150
     4.292    64.098     0.150
     4.969    77.098     0.150
     4.969   134.598     0.150
     4.969   127.500     0.150
    11.978   170.898     0.150
    14.800   207.000     0.150
    25.388   324.957     0.150
    41.681   464.398     0.150
    41.681   464.398     0.150
    41.883   466.398     0.150
    42.947   474.797     0.150
    42.947   474.797     0.150
    47.430   510.699     0.150
    49.206   523.398     0.150
    49.924   530.598     0.150
    50.803   536.500     0.150
    57.027   580.500     0.150
    75.430   699.898     0.150
     0.956    28.390     0.150
     1.863    45.960     0.150
     3.131    57.830     0.150
     3.131    92.430     0.150
    35.130   401.640     0.150
    42.386   462.690     0.150
    42.506   464.720     0.150
    64.799   629.830     0.150
     0.480    23.336     0.150
     0.480    11.646     0.150
     0.480    23.307     0.150
     0.956    28.096     0.150
     1.783    28.336     0.150
     1.913    29.236     0.150
     1.913    51.436     0.150
     4.241    64.336     0.150
     4.241   114.436     0.150
    30.078  2257.936     0.150
    30.089  2259.896     0.150
    30.096  2260.242     0.150
    30.964  2323.248     0.150
    30.967  2328.953     0.150
    30.981  2330.779     0.150
    42.788   470.396     0.150
    42.788   471.176     0.150
    42.788   471.137     0.150
    44.014   481.525     0.150
    44.014   481.537     0.150
    44.094   480.977     0.150
    62.628   617.256     0.150
    62.639   615.566     0.150
    64.777   631.436     0.150
    72.687   680.537     0.150
    72.687   680.506     0.150
    72.719   679.486     0.150
    77.182   703.727     0.150
     0.596    24.062     0.150
     0.596    12.125     0.150
     0.596    24.016     0.150
     1.734    27.867     0.150
     1.734    48.562     0.150
     1.924    31.062     0.150
     2.239    34.766     0.150
     2.239    60.867     0.150
     2.678    59.367     0.150
     2.678    87.266     0.150
     4.617    68.461     0.150
     6.755    96.766     0.150
     7.258   103.258     0.150
    14.205   197.625     0.150
    14.205   198.688     0.150
    14.575   198.664     0.150
    29.864  2257.117     0.150
    29.875  2256.523     0.150
    29.882  2257.055     0.150
    30.753  2319.281     0.150
    30.757  2321.508     0.150
    30.770  2320.383     0.150
    44.243   483.891     0.150
    44.243   483.867     0.150
    55.972   571.703     0.150
    62.631   618.211     0.150
     2.300    35.676     0.150
     3.241    66.777     0.150
     4.610    69.379     0.150
    30.243  2261.285     0.150
    30.253  2261.035     0.150
    30.260  2262.633     0.150
    31.117  2324.426     0.150
    31.121  2323.492     0.150
    31.135  2323.574     0.150
    43.808   479.879     0.150
   146.046 10965.312     0.150
   146.061 10963.160     0.150
     0.269     9.812     0.150
     1.939    31.555     0.150
     2.407    36.254     0.150
     2.407    63.953     0.150
     2.860    75.754     0.150
     3.350    68.152     0.150
     4.726    70.953     0.150
     4.726   121.754     0.150
     4.767    70.852     0.150
     4.767    70.164     0.150
    10.489   149.055     0.150
    12.462   173.613     0.150
    12.462   173.652     0.150
    15.550   217.254     0.150
    21.381   515.055     0.150
    21.522   281.453     0.150
    21.522   281.453     0.150
    30.229  2257.223     0.150
    30.240  2263.578     0.150
    30.247  2262.824     0.150
    31.100  2321.242     0.150
    31.104  2312.809     0.150
    31.118  2327.973     0.150
    32.482     9.699     0.150
    37.331     3.703     0.150
    37.331     7.102     0.150
    40.545   454.422     0.150
    42.734   470.512     0.150
    42.734   470.652     0.150
    43.808   479.512     0.150
    51.653   539.375     0.150
    65.536   636.652     0.150
    70.303   668.223     0.150
    73.253   686.062     0.150
    86.112   754.902     0.150
   146.115 10911.426     0.150
   146.130 10906.809     0.150
     1.029    19.602     0.150
     1.030    17.872     0.150
     1.030    17.901     0.150
     1.030    31.102     0.150
     1.030    19.211     0.150
     1.153    19.292     0.150
     1.305    21.102     0.150
     1.305    37.401     0.150
     1.280    37.771     0.150
     1.807    29.202     0.150
     1.807    50.801     0.150
     1.849    29.801     0.150
     2.249    55.501     0.150
     2.249    81.401     0.150
     3.022    44.932     0.150
     3.022    77.912     0.150
     3.667    95.602     0.150
     8.248   119.001     0.150
     8.248   208.702     0.150
     9.021   128.001     0.150
     9.053   127.301     0.150
     9.217   130.211     0.150
     9.687   138.702     0.150
    10.168   140.861     0.150
    10.170   245.901     0.150
    11.427   156.901     0.150
    11.427   280.801     0.150
    13.552   186.591     0.150
    13.552   186.602     0.150
    13.779   189.702     0.150
    13.779   189.702     0.150
    14.147   352.602     0.150
    14.147   196.901     0.150
    14.148   194.301     0.150
    14.438   199.901     0.150
    15.629   214.301     0.150
    17.500    14.900     0.150
    18.189   246.401     0.150
    20.477    13.200     0.150
    20.477    20.300     0.150
    21.222   278.801     0.150
    21.222   513.301     0.150
    21.182   284.702     0.150
    21.182   278.401     0.150
    21.213   297.801     0.150
    21.213   518.001     0.150
    22.329   290.401     0.150
    24.340    17.900     0.150
    24.340   345.801     0.150
    24.689   316.801     0.150
    24.689   572.801     0.150
    25.602    14.200     0.150
    25.602    21.800     0.150
    26.921   335.401     0.150
    27.779   342.102     0.150
    28.887   352.602     0.150
    29.826  2241.167     0.150
    29.837  2245.058     0.150
    29.843  2244.239     0.150
    30.326   367.401     0.150
    30.326   367.401     0.150
    30.727  2309.123     0.150
    30.732  2308.723     0.150
    30.745  2309.688     0.150
    31.658    10.200     0.150
    32.713   396.001     0.150
    33.367   392.401     0.150
    35.691   411.602     0.150
    38.162   434.901     0.150
    39.100   440.501     0.150
    39.160   440.602     0.150
    39.934   572.662     0.150
    41.283    16.600     0.150
    41.300   459.341     0.150
    42.784   471.301     0.150
    42.841   471.501     0.150
    43.174   474.352     0.150
    43.428   476.082     0.150
    43.691   478.901     0.150
    44.067   482.202     0.150
    44.067   482.202     0.150
    44.344   483.001     0.150
    44.344   483.671     0.150
    44.919   489.001     0.150
    44.919   489.711     0.150
    46.244   498.602     0.150
    46.037   497.492     0.150
    46.333   499.881     0.150
    46.667   503.312     0.150
    46.729   503.001     0.150
    47.075   505.771     0.150
    47.945   512.452     0.150
    47.969   512.901     0.150
    48.022   513.501     0.150
    48.064   513.312     0.150
    48.125   513.892     0.150
    48.397   515.301     0.150
    49.871   526.301     0.150
    49.871   527.131     0.150
    50.690    18.900     0.150
    51.460   539.501     0.150
    51.857   542.122     0.150
    52.301   544.702     0.150
    52.301   544.602     0.150
    52.411   546.401     0.150
    52.436   545.501     0.150
    52.776   550.162     0.150
    53.051   551.021     0.150
    53.254   552.481     0.150
    53.563   556.312     0.150
    53.754   554.901     0.150
    53.754    17.600     0.150
    55.024   565.301     0.150
    56.590   575.102     0.150
    57.515   582.001     0.150
    57.867   585.001     0.150
    58.447   633.501     0.150
    58.940   591.702     0.150
    58.940   591.662     0.150
    59.211   593.001     0.150
    59.483   595.102     0.150
    60.166    17.500     0.150
    62.487   616.901     0.150
    62.917   620.102     0.150
    64.020   775.702     0.150
    64.020   858.602     0.150
    64.020  1175.501     0.150
    64.020   626.202     0.150
    64.638   630.901     0.150
    64.881   643.401     0.150
    64.881   631.602     0.150
    65.025   633.202     0.150
    65.271   636.301     0.150
    66.681   642.301     0.150
    66.696   643.702     0.150
    66.703   886.202     0.150
    67.284   648.501     0.150
    67.818   651.501     0.150
    67.845   650.602     0.150
    68.848   658.301     0.150
    68.848   658.903     0.150
    68.848   658.301     0.150
    68.966   657.704     0.150
    69.046   912.202     0.150
    69.046   658.551     0.150
    69.046   658.551     0.150
    69.046   658.551     0.150
    69.046    16.370     0.150
    69.046   682.872     0.150
    69.046   811.531     0.150
    69.046   912.292     0.150
    69.046  1199.771     0.150
    69.046  1228.021     0.150
    69.046  1568.171     0.150
    69.046  1742.751     0.150
    69.245   660.801     0.150
    69.795   662.001     0.150
    69.815   663.001     0.150
    70.049   665.341     0.150
    70.062   664.301     0.150
    70.062   664.222     0.150
    70.329   667.801     0.150
    70.734   829.901     0.150
    70.734   934.001     0.150
    70.734  1673.901     0.150
    70.734   669.102     0.150
    71.151   671.001     0.150
    71.278   671.401     0.150
    72.145   678.062     0.150
    73.174   683.881     0.150
    73.374   684.729     0.150
    75.190   695.931     0.150
    75.487   698.001     0.150
    75.623   698.423     0.150
    76.402   702.901     0.150
    76.437   704.055     0.150
    76.483   703.501     0.150
    76.491   704.702     0.150
    76.597   704.911     0.150
    76.661   704.401     0.150
    76.697   704.702     0.150
    76.770   704.901     0.150
    76.770   704.992     0.150
    76.778   705.001     0.150
    76.786   705.202     0.150
    76.829   705.102     0.150
    76.933   706.229     0.150
    77.051   706.702     0.150
    77.236   706.901     0.150
    77.236   706.602     0.150
    77.266   708.001     0.150
    77.278   707.301     0.150
    77.303   707.901     0.150
    77.752    13.202     0.150
    78.206   714.702     0.150
    78.322   713.301     0.150
    78.322   713.257     0.150
    78.599   715.702     0.150
    78.795   716.102     0.150
    79.066    12.799     0.150
    79.600   720.329     0.150
    80.091   722.411     0.150
    80.467   725.202     0.150
    80.704   726.001     0.150
    81.054   727.042     0.150
    81.092   728.200     0.150
    81.288   728.365     0.150
    81.382   729.901     0.150
    81.755   731.401     0.150
    81.882   732.602     0.150
    82.103   732.501     0.150
    83.834   742.501     0.150
    84.782   746.801     0.150
    86.741   757.102     0.150
    87.310   759.702     0.150
    88.748   767.131     0.150
    90.566   775.301     0.150
    91.746   780.222     0.150
   145.270  1170.492     0.150
   148.812  1178.211     0.150
   151.077  1185.901     0.150
   154.082  1192.051     0.150
   154.082  1192.281     0.150
   154.082  1192.301     0.150
   155.995  1197.077     0.150
     0.434    10.652     0.150
     0.494    19.523     0.150
     1.898    30.422     0.150
     2.547    38.953     0.150
     2.547    68.254     0.150
     3.486    80.754     0.150
     5.210    76.453     0.150
     8.031   116.055     0.150
    10.345   148.953     0.150
    12.303   174.555     0.150
    13.237   189.754     0.150
    14.852   205.055     0.150
    18.095   245.852     0.150
    20.084   269.852     0.150
    21.529   283.352     0.150
    23.538   303.254     0.150
    26.059   329.254     0.150
    30.286   366.055     0.150
    30.383  2265.051     0.150
    30.394  2265.953     0.150
    30.401  2266.488     0.150
    31.252  2327.980     0.150
    31.255  2325.770     0.150
    31.269  2328.812     0.150
    35.928   413.395     0.150
    42.564   470.555     0.150
    42.564   470.582     0.150
    43.645   478.852     0.150
    43.645   478.914     0.150
    44.618   485.703     0.150
    45.166   490.562     0.150
    45.375   491.645     0.150
    45.372   493.254     0.150
    47.129   507.852     0.150
    49.016   521.852     0.150
    49.016   521.852     0.150
    49.016   521.773     0.150
    49.375   523.152     0.150
    51.482   539.953     0.150
    57.355   581.555     0.150
    57.355   581.484     0.150
    59.501   596.555     0.150
    62.319   615.953     0.150
    64.547   630.453     0.150
    68.266   657.152     0.150
    68.963   657.613     0.150
    68.963   657.652     0.150
    70.809   670.953     0.150
    70.809   670.352     0.150
    74.680   695.852     0.150
    77.001   707.652     0.150
    77.115   706.523     0.150
    78.622   715.531     0.150
    79.575   721.852     0.150
    80.861   728.422     0.150
    81.894   732.852     0.150
    83.309   739.574     0.150
    86.236   757.254     0.150
     0.402    11.545     0.150
     0.402    19.965     0.150
     0.422    11.764     0.150
     0.584    14.033     0.150
     1.751    28.324     0.150
     8.404   119.145     0.150
     8.404   121.045     0.150
     8.445   212.744     0.150
     9.196   129.943     0.150
     9.692   232.443     0.150
    10.513   148.045     0.150
    14.406   197.244     0.150
    17.785   242.443     0.150
    20.528   272.344     0.150
    21.232   298.244     0.150
    21.232   519.045     0.150
    22.411   296.545     0.150
    24.523   313.045     0.150
    25.248   313.844     0.150
    25.939   326.145     0.150
    30.145   356.523     0.150
    30.177  2258.580     0.150
    30.188  2260.600     0.150
    30.195  2264.170     0.150
    31.059  2321.174     0.150
    31.063  2334.787     0.150
    31.077  2335.885     0.150
    36.304   416.744     0.150
    42.666   470.344     0.150
    42.868   471.443     0.150
    43.413   475.844     0.150
    43.903   479.744     0.150
    44.225   482.404     0.150
    48.966   519.244     0.150
    49.339   522.717     0.150
    49.339   522.645     0.150
    51.790   540.744     0.150
    52.134   543.645     0.150
    53.453   552.635     0.150
    54.413   560.244     0.150
    56.928   577.443     0.150
    57.028   577.244     0.150
    57.802   585.145     0.150
    63.796   624.443     0.150
    64.656   864.545     0.150
    64.656   630.744     0.150
    65.290   634.863     0.150
    76.048   640.074     0.150
    65.997   640.145     0.150
    66.540   641.545     0.150
    66.540   641.568     0.150
    68.477   656.145     0.150
    68.498   655.645     0.150
    68.561   655.055     0.150
    68.861   911.045     0.150
    68.861   657.184     0.150
    68.861    15.441     0.150
    68.861   809.334     0.150
    68.861   911.125     0.150
    68.861  1226.104     0.150
    68.861  1466.193     0.150
    68.861  1661.186     0.150
    70.279   664.844     0.150
    77.114   706.145     0.150
    77.114    24.600     0.150
    80.777   724.434     0.150
    69.710   767.965     0.150
     0.208     7.086     0.150
     0.208    11.078     0.150
     1.690    27.285     0.150
     1.979    32.438     0.150
     1.979    52.336     0.150
     4.531    68.438     0.150
     4.531    65.258     0.150
     5.039    64.938     0.150
     6.767    97.035     0.150
     6.767    96.906     0.150
     7.906   112.586     0.150
     8.441   214.438     0.150
     8.679   125.035     0.150
    11.043   161.188     0.150
    12.306   173.246     0.150
    13.048   189.238     0.150
    13.201   185.477     0.150
    14.552   217.336     0.150
    14.729   205.695     0.150
    14.729   206.207     0.150
    15.297   209.188     0.150
    16.256    16.699     0.150
    17.909   250.035     0.150
    19.967   269.266     0.150
    20.588    12.500     0.150
    21.082    11.500     0.150
    21.082   281.258     0.150
    21.082   285.406     0.150
    21.892   292.938     0.150
    21.892   533.535     0.150
    23.153   546.938     0.150
    25.468   327.238     0.150
    25.468   327.238     0.150
    25.912   329.215     0.150
    30.056   366.137     0.150
    30.568  2268.793     0.150
    30.578  2276.770     0.150
    30.586  2270.129     0.150
    30.602   370.445     0.150
    31.440  2338.383     0.150
    31.443  2341.602     0.150
    31.457  2339.602     0.150
    32.203   390.035     0.150
    32.203    12.000     0.150
    42.903   441.207     0.150
    38.819   444.336     0.150
    39.122   444.238     0.150
    39.438   444.438     0.150
    39.438    20.301     0.150
    42.207   473.637     0.150
    42.207   473.637     0.150
    42.409   472.707     0.150
    42.409   473.480     0.150
   110.564   477.777     0.150
    43.474   480.535     0.150
    43.674   483.168     0.150
    64.153   483.738     0.150
    43.793   483.336     0.150
    64.810   486.809     0.150
    75.381   501.246     0.150
    88.963   507.527     0.150
    47.698   513.836     0.150
    47.702   514.637     0.150
    47.728   513.711     0.150
    80.750   518.527     0.150
    80.750   526.758     0.150
    48.869   525.637     0.150
    48.869   525.637     0.150
    49.632   532.738     0.150
    49.632     7.699     0.150
    50.447   535.457     0.150
    51.329   540.535     0.150
    51.329   541.965     0.150
    13.411   550.418     0.150
    13.411   551.758     0.150
    52.485   554.855     0.150
    53.098   554.445     0.150
    53.913   560.336     0.150
    55.477   572.809     0.150
    56.436   579.648     0.150
    56.541   581.035     0.150
    57.173   583.336     0.150
    62.514   620.938     0.150
    64.342  1156.137     0.150
    64.621   634.938     0.150
    77.911   637.086     0.150
    65.708   642.438     0.150
    65.884   645.738     0.150
    66.242   645.988     0.150
    67.685   655.047     0.150
    68.102   657.035     0.150
    68.571   660.309     0.150
    68.571   660.309     0.150
    68.571   678.227     0.150
    68.571   912.875     0.150
    68.571  1222.418     0.150
    68.571  1472.246     0.150
    68.571  1665.438     0.150
    68.571   660.238     0.150
    68.571    12.598     0.150
    68.571   678.137     0.150
    68.571   812.438     0.150
    68.571   912.836     0.150
    68.571  1201.938     0.150
    68.571  1222.336     0.150
    68.571  1472.238     0.150
    68.729   661.098     0.150
    68.811   661.016     0.150
    69.438   665.480     0.150
    69.835   663.836     0.150
    70.311   670.918     0.150
    70.446   671.277     0.150
    70.605   671.938     0.150
    79.318   684.867     0.150
    73.316   689.078     0.150
   141.502   694.758     0.150
   140.254   694.785     0.150
    75.261   700.277     0.150
    75.829   703.559     0.150
    75.825   709.336     0.150
    75.825   722.438     0.150
    75.849   703.746     0.150
    75.950   703.777     0.150
    76.020   706.137     0.150
    76.328   706.637     0.150
    76.328   706.625     0.150
    76.364   707.336     0.150
    76.793   708.238     0.150
    76.793   708.238     0.150
    76.862  2230.137     0.150
    76.862  2350.137     0.150
    77.346   713.836     0.150
    77.346   713.836     0.150
    77.536   714.637     0.150
    78.593   718.836     0.150
    79.924   724.535     0.150
    80.791   729.535     0.150
    81.540   735.137     0.150
    83.178   742.887     0.150
    84.077   748.117     0.150
    47.767   749.035     0.150
    86.165   759.215     0.150
   146.142  1174.836     0.150
   146.142  1174.797     0.150
     0.522    22.039     0.150
     2.808    44.020     0.150
     2.808    76.520     0.150
     8.121   116.920     0.150
     9.861   143.020     0.150
    12.335   174.020     0.150
    31.718  2402.506     0.150
    31.722  2402.812     0.150
    31.735  2404.051     0.150
    41.985   467.920     0.150
    41.985   470.020     0.150
    41.985   470.020     0.150
    43.225   476.420     0.150
    43.225   476.520     0.150
    43.941   484.119     0.150
    44.316   480.829     0.150
    47.460   507.514     0.150
    67.811   654.819     0.150
    69.236   659.020     0.150
     0.698    26.426     0.150
     0.909    28.105     0.150
     0.912    18.625     0.150
     1.313    23.203     0.150
     1.821    45.074     0.150
     1.821    45.125     0.150
     1.820    45.074     0.150
     2.202    58.727     0.150
     6.903    99.227     0.150
     9.084   129.727     0.150
     9.559   229.852     0.150
    10.496   150.426     0.150
    12.247   177.324     0.150
    12.653   316.227     0.150
    12.653   177.125     0.150
    14.942   373.523     0.150
    14.942   364.125     0.150
    17.910   243.406     0.150
    17.910   243.324     0.150
    20.410   498.523     0.150
    21.291   278.855     0.150
    21.291   297.727     0.150
    21.291   528.227     0.150
    21.291   535.824     0.150
    21.291   548.426     0.150
    21.291   278.426     0.150
    22.282   295.824     0.150
    25.869   326.324     0.150
    25.869   326.426     0.150
    26.313   330.477     0.150
    26.313   330.523     0.150
    61.378   335.426     0.150
    28.171   347.426     0.150
    28.171   347.426     0.150
    30.210   364.324     0.150
    30.204  2263.566     0.150
    30.215  2254.301     0.150
    30.222  2254.875     0.150
    30.428   370.727     0.150
    30.839    19.098     0.150
    31.082  2320.383     0.150
    31.085  2321.633     0.150
    31.099  2321.188     0.150
    37.291    19.520     0.150
    38.231   435.023     0.150
    42.701   440.074     0.150
    42.701   440.785     0.150
    42.701   440.926     0.150
    41.550   463.324     0.150
    42.386   468.125     0.150
    42.604   581.824     0.150
    42.604   470.445     0.150
    42.935   473.523     0.150
    66.333   475.227     0.150
    43.567   477.426     0.150
    43.629   477.426     0.150
   122.580   478.895     0.150
    43.857   479.926     0.150
    43.857   479.895     0.150
    43.857   479.824     0.150
    43.857   479.426     0.150
    43.959   481.176     0.150
    44.020   482.324     0.150
    44.020   482.184     0.150
    44.020   482.227     0.150
    44.020   482.316     0.150
    44.140   482.426     0.150
    44.258   481.887     0.150
    44.378   483.625     0.150
    44.791   491.023     0.150
    45.749   494.715     0.150
    75.699   496.797     0.150
    46.011   496.555     0.150
    46.120   497.547     0.150
    46.462   500.137     0.150
    47.340   506.934     0.150
    47.392   508.426     0.150
    47.366   507.484     0.150
    47.457   508.145     0.150
    47.534   508.594     0.150
    48.096   600.926     0.150
    80.494   516.305     0.150
    80.494   517.336     0.150
    80.494   515.926     0.150
    51.726   540.727     0.150
    52.204   545.523     0.150
    52.465   545.863     0.150
    53.441    19.699     0.150
    54.749   562.316     0.150
    56.843   577.426     0.150
    57.158   579.324     0.150
    58.612   590.523     0.150
    58.612    12.730     0.150
    58.971   592.125     0.150
    58.971   592.145     0.150
    59.517   596.305     0.150
    60.592   603.816     0.150
    62.472   619.727     0.150
    62.472   614.824     0.150
    63.801   654.023     0.150
    63.801   856.523     0.150
    64.436   629.926     0.150
    64.660   777.625     0.150
    64.660   866.625     0.150
    64.721   632.004     0.150
    64.754   632.355     0.150
    64.827   632.625     0.150
    65.392   636.285     0.150
    65.392   636.605     0.150
    65.486   637.125     0.150
    66.563   642.523     0.150
    66.976   642.914     0.150
    67.004    22.699     0.150
    68.214   653.125     0.150
    68.356   653.625     0.150
    68.447   656.125     0.150
    68.447   656.125     0.150
    68.468   656.023     0.150
    68.572    17.102     0.150
    68.709   656.594     0.150
    68.874   658.355     0.150
    68.874   658.355     0.150
    68.874   912.645     0.150
    68.874  1231.977     0.150
    68.874  1662.863     0.150
    68.874   658.324     0.150
    68.874    19.102     0.150
    68.874   809.426     0.150
    68.874   912.625     0.150
    68.874  1197.824     0.150
    68.874  1231.926     0.150
    68.874  1465.727     0.150
    69.117  1204.324     0.150
    56.540   661.555     0.150
    69.612   661.324     0.150
    69.807   660.125     0.150
    69.807   662.426     0.150
    70.350   662.727     0.150
    70.350   921.727     0.150
    70.350  1207.324     0.150
    70.350  1481.625     0.150
    70.502   667.727     0.150
    70.811   668.426     0.150
    70.785   673.480     0.150
    70.819   670.445     0.150
    70.913   670.246     0.150
    70.925   670.195     0.150
    70.925   670.227     0.150
    71.173   673.301     0.150
    71.459   674.395     0.150
    71.584   675.723     0.150
    71.725   676.238     0.150
    72.278   679.504     0.150
    72.943   683.625     0.150
    73.125   683.523     0.150
    71.267   684.023     0.150
    73.296   684.227     0.150
    73.854   685.125     0.150
   139.958   689.055     0.150
    74.960   694.426     0.150
    75.058   695.324     0.150
    75.058   694.023     0.150
    75.085   695.645     0.150
    75.294   697.133     0.150
    75.343   696.926     0.150
    75.529   698.523     0.150
    75.578   698.824     0.150
    75.769   699.023     0.150
    76.163   701.227     0.150
    76.163   701.227     0.150
    76.178   702.227     0.150
    76.276   700.824     0.150
    76.276   701.227     0.150
    76.323   703.387     0.150
    76.311   868.559     0.150
    76.332   702.727     0.150
    76.533   704.023     0.150
    76.571   703.926     0.150
    76.624   704.625     0.150
    76.644   704.625     0.150
    76.644   703.727     0.150
    76.651   704.625     0.150
    76.655   704.824     0.150
    76.655   703.625     0.150
    76.678   705.125     0.150
    76.678   705.066     0.150
    76.678   704.227     0.150
    76.692   704.625     0.150
    76.714   704.625     0.150
    77.094   707.227     0.150
    77.096   707.801     0.150
    77.141   706.605     0.150
    77.141   706.625     0.150
    77.141  2204.625     0.150
    77.189   707.926     0.150
    77.374   708.824     0.150
    77.467   708.625     0.150
    77.634   710.324     0.150
    77.663   710.848     0.150
    77.824   711.023     0.150
    77.836   711.426     0.150
    77.846   712.195     0.150
    78.101   712.426     0.150
    78.569   714.523     0.150
    78.678   715.023     0.150
    78.678   715.023     0.150
    78.697   714.926     0.150
    79.120   717.227     0.150
    79.487   719.727     0.150
    79.839   722.156     0.150
    80.913   723.184     0.150
    81.302   729.605     0.150
    85.956   753.523     0.150
    88.095   763.324     0.150
    89.119   768.625     0.150
   132.065  1147.195     0.150
     0.239     9.969     0.150
     0.239    17.070     0.150
     1.904    46.938     0.150
     4.592    68.773     0.150
     4.592   117.172     0.150
     6.818    97.867     0.150
    12.605   175.070     0.150
    14.645   202.070     0.150
    24.288   309.773     0.150
    26.329   329.969     0.150
    30.164  2255.820     0.150
    30.175  2256.062     0.150
    30.182  2259.906     0.150
    31.039  2320.711     0.150
    31.043  2325.805     0.150
    31.056  2326.914     0.150
    42.826   471.469     0.150
    43.887   478.773     0.150
    64.569   481.180     0.150
    47.405   508.867     0.150
    48.168   514.367     0.150
    49.203   519.750     0.150
    49.286   522.070     0.150
    50.864   535.078     0.150
    53.489   553.672     0.150
    54.839   562.672     0.150
    57.249   579.570     0.150
    64.818   631.367     0.150
    70.968   668.938     0.150
    70.968   668.539     0.150
    76.353   701.180     0.150
     0.115    12.551     0.150
     0.515    11.512     0.150
     0.813    25.562     0.150
     1.765    46.312     0.150
     1.764    46.312     0.150
     1.954    30.910     0.150
     4.603   121.812     0.150
     6.740   101.211     0.150
     6.734    98.211     0.150
     7.983   113.812     0.150
     8.515   123.512     0.150
    12.337   310.945     0.150
    12.337   175.211     0.150
    13.204   187.770     0.150
    13.227   189.570     0.150
    14.542   202.859     0.150
    14.542   202.812     0.150
    14.751   203.910     0.150
    15.224   213.312     0.150
    16.307   409.211     0.150
    17.353   239.750     0.150
    17.967   245.312     0.150
    19.417    13.199     0.150
    19.433   262.359     0.150
    20.070    10.000     0.150
    20.070    16.598     0.150
    20.070   484.211     0.150
    20.028   267.410     0.150
    21.170   276.109     0.150
    21.400   282.012     0.150
    23.463   303.500     0.150
    24.889   314.410     0.150
    25.500    12.500     0.150
    25.500    16.402     0.150
    25.552   324.609     0.150
    25.552   325.012     0.150
    25.996   752.730     0.150
    61.620   335.051     0.150
    61.620   333.949     0.150
    61.620   334.512     0.150
    30.153   363.070     0.150
    30.475  2258.371     0.150
    30.486  2258.617     0.150
    30.493  2263.820     0.150
    30.499     7.898     0.150
    31.347  2332.625     0.150
    31.350  2327.383     0.150
    31.364  2326.688     0.150
    32.273   384.512     0.150
    36.633   421.410     0.150
    42.918   439.723     0.150
    42.918   439.711     0.150
    38.912   441.789     0.150
   121.486   441.871     0.150
    39.214   572.211     0.150
    39.214   798.172     0.150
    39.214   443.781     0.150
    39.520    12.098     0.150
    40.073    13.000     0.150
   116.067   459.039     0.150
    42.293   582.461     0.150
    42.293   809.430     0.150
    42.293   469.012     0.150
    42.495   470.820     0.150
    42.495   470.711     0.150
    42.615   471.312     0.150
    42.615   471.512     0.150
    43.564   479.211     0.150
    43.564   586.512     0.150
    43.564   863.312     0.150
    43.564   479.281     0.150
    43.564   479.410     0.150
    43.754   480.711     0.150
    64.235   481.812     0.150
    43.944   483.660     0.150
    43.944   817.012     0.150
    44.137   481.512     0.150
    44.137   483.711     0.150
    44.556   588.312     0.150
    44.556   486.910     0.150
    44.625   488.223     0.150
    44.625   488.211     0.150
    44.694   487.609     0.150
    45.436   494.992     0.150
    45.692   496.691     0.150
    45.803   497.820     0.150
    46.143   500.422     0.150
    46.690   499.910     0.150
    46.690   504.711     0.150
    47.022   507.582     0.150
    47.071   508.812     0.150
    47.049   507.871     0.150
    47.139   507.812     0.150
    47.219   508.230     0.150
    47.338   509.512     0.150
    47.763   514.109     0.150
    47.854   513.512     0.150
    48.953   522.043     0.150
    48.953   522.301     0.150
    48.953   522.012     0.150
    48.953   524.711     0.150
    48.953   522.410     0.150
    48.953   522.312     0.150
    48.953   522.270     0.150
    49.094   524.812     0.150
    51.415   540.109     0.150
    51.893   545.652     0.150
    52.152   546.141     0.150
    52.360   547.871     0.150
    52.396   542.312     0.150
    13.406   549.672     0.150
    13.406   549.910     0.150
    52.568   549.180     0.150
    52.794   552.012     0.150
    63.218   553.012     0.150
    53.192   553.141     0.150
    53.192   553.012     0.150
    53.988   559.812     0.150
    54.752   564.211     0.150
    54.752   563.973     0.150
    56.515   577.109     0.150
    57.229   581.410     0.150
    58.257   637.012     0.150
    58.257   714.012     0.150
    58.774   592.930     0.150
    59.374   596.609     0.150
    59.399   596.102     0.150
    62.156   617.121     0.150
    62.213   617.109     0.150
    62.439   617.820     0.150
    62.652   617.012     0.150
    64.027   629.012     0.150
    64.314   633.609     0.150
    64.437    22.602     0.150
    64.571   631.301     0.150
    64.571   631.211     0.150
    78.004   634.762     0.150
    65.373   637.691     0.150
    65.717   640.609     0.150
    66.170   640.012     0.150
    66.177   643.211     0.150
    66.923   647.160     0.150
    66.923   647.211     0.150
   109.141   648.672     0.150
    67.722   652.383     0.150
    68.175   656.723     0.150
    68.175   656.211     0.150
    68.194   656.410     0.150
    68.194   656.312     0.150
    68.535   647.512     0.150
    68.665   658.750     0.150
    68.665   658.750     0.150
    68.665    20.090     0.150
    68.665   911.242     0.150
    68.665  1662.090     0.150
    68.665   658.711     0.150
    68.665    14.199     0.150
    68.665    20.102     0.150
    68.665   811.312     0.150
    68.665   911.211     0.150
    68.665  1199.410     0.150
    68.665  1223.812     0.150
    68.665  1466.312     0.150
    68.757   658.711     0.150
    68.849   658.992     0.150
    82.807   660.520     0.150
    69.656   663.211     0.150
    70.081   923.012     0.150
    70.321   669.211     0.150
    70.514   668.910     0.150
    70.687   670.289     0.150
    70.699   670.430     0.150
    70.699   670.109     0.150
    70.699   670.312     0.150
    71.128   674.250     0.150
    71.128   674.109     0.150
    71.258   673.312     0.150
    71.570   675.352     0.150
    42.512   683.391     0.150
    72.893   683.512     0.150
    72.987   684.551     0.150
    73.216   686.012     0.150
    74.574   693.609     0.150
    74.733   695.512     0.150
    75.078   697.512     0.150
    75.078   697.512     0.150
    75.103   697.410     0.150
    75.156   697.812     0.150
    75.275   698.211     0.150
    75.275   698.473     0.150
    75.498   697.273     0.150
    75.821   697.262     0.150
    76.114   704.566     0.150
    76.337   704.109     0.150
    76.411   705.711     0.150
    76.411   703.512     0.150
    76.412   705.410     0.150
    76.422   705.512     0.150
    76.458   704.641     0.150
    76.458   705.312     0.150
    76.493   704.609     0.150
    76.493   704.609     0.150
    76.881   708.250     0.150
    76.881    11.441     0.150
    76.887   708.191     0.150
    76.956   706.910     0.150
    76.956   706.910     0.150
    76.956   719.109     0.150
    76.956  1294.211     0.150
    76.956  1780.211     0.150
    76.956  1930.211     0.150
    77.035   708.449     0.150
    77.173   709.852     0.150
    77.173   709.812     0.150
    77.364   708.609     0.150
    77.458   711.914     0.150
    77.512   710.219     0.150
    77.512   710.211     0.150
    77.631   712.949     0.150
    77.637   712.461     0.150
    77.877   712.211     0.150
    78.004   713.812     0.150
    78.458   716.312     0.150
    78.503   716.211     0.150
    78.853   718.312     0.150
    78.934   717.359     0.150
    78.934   717.410     0.150
    79.518   722.312     0.150
    79.518   722.699     0.150
    79.647   721.875     0.150
    79.814   722.820     0.150
    80.507   727.535     0.150
    80.625   728.180     0.150
    80.660   727.250     0.150
    81.120   730.012     0.150
    81.248   729.312     0.150
    81.438   732.410     0.150
    82.091   735.711     0.150
    82.888   738.570     0.150
    84.087   743.711     0.150
    84.505   748.699     0.150
    85.068   748.340     0.150
   146.484   751.590     0.150
    86.158   756.109     0.150
    86.162   757.512     0.150
    87.792   764.410     0.150
    69.532   771.770     0.150
    91.533   781.512     0.150
   120.188  1124.660     0.150
   146.091  1173.570     0.150
   146.295 10974.188     0.150
   146.311 10977.023     0.150
   155.196  1188.340     0.150
     1.825    31.156     0.150
     4.603   118.195     0.150
     4.647    71.336     0.150
     6.831    98.523     0.150
     8.227   109.273     0.150
    30.264  2258.875     0.150
    30.275  2257.062     0.150
    30.282  2257.586     0.150
    31.139  2321.273     0.150
    31.143  2329.961     0.150
    31.156  2324.250     0.150
    39.431   441.883     0.150
    39.431   570.047     0.150
    42.527   469.352     0.150
    42.527   580.758     0.150
    43.788   477.352     0.150
    64.475   481.352     0.150
    48.034   600.047     0.150
    49.338   524.797     0.150
    50.043   529.797     0.150
    55.546   567.305     0.150
    58.682   592.211     0.150
    58.682   592.219     0.150
    64.723   630.492     0.150
    66.173   639.648     0.150
    70.870   669.695     0.150
   143.658  1163.484     0.150
   145.076  1166.766     0.150
     0.297    10.008     0.150
     0.924    28.836     0.150
     1.846    46.078     0.150
     2.701    42.102     0.150
     4.660    70.008     0.150
     4.660   123.102     0.150
     4.660    70.008     0.150
     6.853    98.305     0.150
     8.284   118.203     0.150
     8.572   215.906     0.150
     9.516   230.352     0.150
    10.046   161.102     0.150
    10.046   259.305     0.150
    10.046   272.305     0.150
    10.490   149.602     0.150
    11.260   156.906     0.150
    11.766   301.805     0.150
    12.604   176.805     0.150
    13.399   198.305     0.150
    13.476   187.281     0.150
    13.476   192.508     0.150
    14.463   355.805     0.150
    14.612   199.508     0.150
    14.994   217.305     0.150
    14.994   210.203     0.150
    15.182   212.406     0.150
    15.530   380.203     0.150
    17.635   238.773     0.150
    17.951   243.312     0.150
    17.951   243.805     0.150
    19.719   493.305     0.150
    20.370    12.703     0.150
    20.370    20.703     0.150
    20.370   486.805     0.150
    20.328   269.102     0.150
    20.721   505.805     0.150
    21.309   278.508     0.150
    21.309    18.398     0.150
    21.309   519.602     0.150
    21.309   953.305     0.150
    21.309   278.602     0.150
    22.141   335.508     0.150
    22.141   585.102     0.150
    22.239   531.102     0.150
    25.067    12.000     0.150
    25.067   580.602     0.150
    25.845   325.414     0.150
    25.845   325.406     0.150
    61.431   338.203     0.150
    28.154   346.766     0.150
    30.214  2255.617     0.150
    30.225  2256.570     0.150
    30.232  2257.094     0.150
    30.799    23.500     0.150
    31.090  2333.805     0.150
    31.094  2332.922     0.150
    31.107  2335.766     0.150
    36.422   754.805     0.150
    36.507   419.406     0.150
    37.223    15.703     0.150
    37.243    15.445     0.150
    37.243    22.984     0.150
    42.753   438.844     0.150
    42.753   440.414     0.150
    42.753   440.102     0.150
    39.097   439.672     0.150
    39.097   439.703     0.150
    39.482   444.133     0.150
    39.816    13.297     0.150
    68.284   465.133     0.150
    42.438   468.102     0.150
    42.582   581.477     0.150
    42.784   471.703     0.150
    33.704   472.211     0.150
    66.385   473.852     0.150
    66.385   476.211     0.150
    66.385   475.906     0.150
    43.679   478.508     0.150
    43.841   479.766     0.150
    43.841   479.805     0.150
    43.841   479.727     0.150
    44.009   481.883     0.150
    43.971   481.305     0.150
    64.632   482.008     0.150
    64.531   482.344     0.150
    44.546   486.008     0.150
   156.489   488.773     0.150
    45.605   493.688     0.150
    45.617   495.102     0.150
    45.727   495.273     0.150
    45.986   497.281     0.150
    46.096   498.195     0.150
    46.437   500.867     0.150
    46.335   508.203     0.150
    46.662   502.508     0.150
    46.760   503.406     0.150
    47.139   512.203     0.150
    47.316   507.797     0.150
    47.367   508.203     0.150
    47.342   508.273     0.150
    47.433   508.906     0.150
    47.633   510.008     0.150
   122.747   512.406     0.150
   122.747   512.906     0.150
    48.118   513.602     0.150
    80.546   515.898     0.150
    80.546   516.703     0.150
    48.331   515.703     0.150
    48.572   517.406     0.150
    48.572   516.508     0.150
    49.163   521.203     0.150
    49.163   521.602     0.150
    49.365   523.367     0.150
    49.246   522.602     0.150
    49.246   522.508     0.150
    49.246   522.602     0.150
    49.246   522.305     0.150
    49.246   522.648     0.150
    49.828   526.102     0.150
    50.010    15.500     0.150
    50.775   535.703     0.150
    50.824   534.406     0.150
    50.934   533.508     0.150
    51.631   541.102     0.150
    51.704   540.508     0.150
    51.704   540.602     0.150
    52.459   546.406     0.150
    13.597   548.695     0.150
    13.597   549.305     0.150
    52.650   548.172     0.150
    52.862   548.602     0.150
    53.436    19.195     0.150
    53.436   669.906     0.150
    53.436   553.328     0.150
    54.290   560.305     0.150
    54.579   560.203     0.150
    54.784   562.703     0.150
    55.270   576.305     0.150
    55.697   569.672     0.150
    55.707   570.508     0.150
    55.707   570.492     0.150
    55.948   572.406     0.150
     9.145   575.703     0.150
    56.574   574.703     0.150
    56.815   577.008     0.150
    57.200   579.406     0.150
    57.633   582.703     0.150
    58.144   594.703     0.150
    58.986   592.008     0.150
    59.165   594.914     0.150
    59.693   596.625     0.150
    62.141   615.305     0.150
    62.200   616.008     0.150
    63.802   640.406     0.150
    63.802   647.102     0.150
    64.322   629.703     0.150
    64.488   630.508     0.150
    64.661   630.406     0.150
    64.661    19.000     0.150
    64.661    26.102     0.150
    64.661  1400.602     0.150
    64.760   630.883     0.150
    64.779   632.406     0.150
    65.424   636.422     0.150
    65.539   637.508     0.150
    66.164   646.508     0.150
    66.169   647.102     0.150
    66.171   641.648     0.150
    66.245   885.508     0.150
    66.245  1159.203     0.150
    67.004   645.406     0.150
    68.073   652.016     0.150
    68.437   655.508     0.150
    68.437   656.508     0.150
    68.542   657.008     0.150
    68.564    18.797     0.150
    68.633   656.906     0.150
    68.878   658.305     0.150
    68.878   658.305     0.150
    68.878    18.406     0.150
    68.878   684.922     0.150
    68.878   911.344     0.150
    68.878  1661.781     0.150
    68.878   658.305     0.150
    68.878    18.398     0.150
    68.878   684.906     0.150
    68.878   810.602     0.150
    68.878   911.305     0.150
    68.878  1197.305     0.150
    68.878  1228.805     0.150
    68.878  1465.102     0.150
    69.108    18.500     0.150
    56.579   662.516     0.150
    69.598   663.312     0.150
    84.367   663.906     0.150
    70.144   666.508     0.150
    70.340   832.406     0.150
    70.340   929.906     0.150
    70.340  1670.508     0.150
    70.538   667.703     0.150
    70.588   669.203     0.150
    70.804    19.805     0.150
    70.913   670.203     0.150
    71.256   673.406     0.150
    71.424   672.906     0.150
    71.429   673.812     0.150
    73.096   684.602     0.150
    73.728   687.703     0.150
    73.821   688.906     0.150
    74.011   692.203     0.150
    74.062   689.031     0.150
    74.584   692.805     0.150
    75.110   695.602     0.150
    75.296   713.305     0.150
    75.296   696.766     0.150
    75.296   713.320     0.150
    75.366   697.102     0.150
    75.772   700.008     0.150
    76.177   701.602     0.150
    76.282   702.406     0.150
    76.302   701.906     0.150
    76.327   726.703     0.150
    76.327   703.445     0.150
    76.327   726.703     0.150
    76.337   701.703     0.150
    76.337   701.703     0.150
    76.539   703.906     0.150
    76.577   704.008     0.150
    76.657   704.508     0.150
    76.661   704.703     0.150
    76.669   704.602     0.150
    77.097   706.836     0.150
    77.100   729.305     0.150
    77.100   707.117     0.150
    77.100   729.305     0.150
    77.149   706.703     0.150
    77.149   706.703     0.150
    77.149    16.602     0.150
    77.149  1576.305     0.150
    77.149  1786.305     0.150
    77.149  1906.305     0.150
    77.196   707.602     0.150
    77.329   708.203     0.150
    77.616   710.203     0.150
    77.640   709.406     0.150
    77.668   710.820     0.150
    77.829   710.805     0.150
    77.829   710.805     0.150
    77.840   734.008     0.150
    77.840   711.867     0.150
    77.840   733.961     0.150
    77.850   734.305     0.150
    77.850   712.000     0.150
    77.850   734.305     0.150
    78.230   712.906     0.150
    78.519   715.008     0.150
    78.605   714.781     0.150
    78.605   714.938     0.150
    78.673   715.406     0.150
    78.704   716.008     0.150
    83.808   717.016     0.150
    79.128   718.008     0.150
    79.522   720.703     0.150
    79.806   721.703     0.150
    79.814   721.805     0.150
    80.283   724.406     0.150
    80.628   726.008     0.150
    80.746   724.805     0.150
    81.023   730.102     0.150
    81.310   729.805     0.150
    81.852   732.281     0.150
    81.895   732.008     0.150
    82.203   734.125     0.150
    84.303   745.102     0.150
    84.699   747.203     0.150
    85.265   749.906     0.150
    86.008   753.703     0.150
    87.365   760.805     0.150
    87.626   761.406     0.150
    88.146   764.008     0.150
    93.325   787.328     0.150
   102.405   830.305     0.150
   120.111  1123.602     0.150
   120.111  1123.602     0.150
   126.306  1136.617     0.150
   132.033  1146.305     0.150
   142.804  1166.406     0.150
   146.136  1171.703     0.150
   151.786  1187.602     0.150
     0.304    13.477     0.150
     0.425    10.285     0.150
     0.667    23.367     0.150
     0.704    13.605     0.150
     0.827    15.629     0.150
     0.827    20.348     0.150
     1.241    37.586     0.150
     1.820    29.906     0.150
     2.543    69.008     0.150
     2.911    46.207     0.150
     4.948    80.508     0.150
     6.802    99.957     0.150
     6.802   100.008     0.150
     6.803   100.176     0.150
     7.828   114.008     0.150
     7.956   116.336     0.150
     9.604   242.758     0.150
    10.053   148.406     0.150
    11.063   161.086     0.150
    13.091   187.707     0.150
    14.706   203.008     0.150
    14.706   202.367     0.150
    17.848   246.707     0.150
    19.906   266.605     0.150
    20.542    13.699     0.150
    20.992   295.207     0.150
    20.992   515.207     0.150
    20.992   525.008     0.150
    20.992   552.105     0.150
    20.992   284.309     0.150
    21.278   286.309     0.150
    21.278   286.309     0.150
    25.383   327.008     0.150
    25.383   327.008     0.150
    25.827   332.008     0.150
    29.986   365.105     0.150
    30.662  2273.816     0.150
    30.673  2267.668     0.150
    30.680  2274.512     0.150
    39.029   445.109     0.150
    39.356    12.000     0.150
    42.120   471.105     0.150
    42.120   472.508     0.150
    42.322   473.398     0.150
    42.322   473.406     0.150
    43.643   483.406     0.150
    43.768   482.207     0.150
    43.883   482.660     0.150
    43.883   482.547     0.150
    44.501   488.258     0.150
   156.556   493.508     0.150
    44.987   496.797     0.150
    46.597   509.508     0.150
    46.982   506.738     0.150
    48.120   520.867     0.150
    48.176   520.406     0.150
    48.379   521.406     0.150
    48.509   521.809     0.150
    48.784   523.406     0.150
    48.968   524.605     0.150
    49.673   531.207     0.150
    51.242   541.508     0.150
    13.419   553.758     0.150
    53.002   617.105     0.150
    53.002   999.406     0.150
    53.002  1213.605     0.150
    53.802   562.738     0.150
    55.423   574.855     0.150
    56.357   581.355     0.150
    56.357   578.605     0.150
    56.853   584.848     0.150
    58.709   593.184     0.150
    58.709   593.195     0.150
    59.249   600.578     0.150
    64.383   631.637     0.150
    64.383   633.605     0.150
    66.170   646.656     0.150
    66.308   644.418     0.150
    67.100   655.219     0.150
    67.988   657.207     0.150
    68.008   659.105     0.150
    68.008   659.105     0.150
    68.139   660.906     0.150
    68.698   660.605     0.150
    69.472   669.207     0.150
    70.741   676.387     0.150
    74.517   695.105     0.150
    83.992   708.207     0.150
    76.147   706.598     0.150
    76.232   708.695     0.150
    76.265   708.777     0.150
    76.642   713.059     0.150
    76.690   712.496     0.150
    76.766   709.707     0.150
    76.766   709.707     0.150
    76.766    13.000     0.150
    78.276   720.816     0.150
    78.744   722.879     0.150
    78.855   724.445     0.150
    78.924   724.918     0.150
    79.352   726.957     0.150
    80.458   730.809     0.150
    83.394   746.957     0.150
    86.166   757.719     0.150
    87.763   767.758     0.150
   146.408 10972.426     0.150
   146.424 10970.895     0.150
     0.190    15.023     0.150
     0.279     8.533     0.150
     2.732    42.463     0.150
     2.732    74.463     0.150
     4.599    69.062     0.150
     4.685    70.764     0.150
     4.685   124.264     0.150
     6.821    98.264     0.150
    10.496   148.562     0.150
    12.579   174.264     0.150
    25.840   325.963     0.150
    26.283   328.863     0.150
    30.211  2253.316     0.150
    30.221  2259.395     0.150
    30.229  2261.850     0.150
    31.086  2320.699     0.150
    31.090  2321.961     0.150
    31.103  2325.627     0.150
    38.546   435.664     0.150
    42.578   469.824     0.150
    42.780   471.264     0.150
    43.841   479.562     0.150
    57.230   578.584     0.150
    57.230   578.562     0.150
    59.550   595.643     0.150
    59.550   595.664     0.150
    60.863   607.363     0.150
    64.774   630.934     0.150
    68.440   656.562     0.150
    85.985   753.562     0.150
   146.017 10970.094     0.150
   146.033 10967.059     0.150
     0.307    10.533     0.150
     0.307    10.572     0.150
     0.307    17.771     0.150
     0.388    18.293     0.150
     0.892    28.152     0.150
     0.918    28.602     0.150
     1.849    46.848     0.150
     2.066    32.912     0.150
     2.304    34.572     0.150
     2.748    42.271     0.150
     4.614   119.072     0.150
     4.670    69.873     0.150
     4.670    66.672     0.150
     6.822    99.973     0.150
     6.814   175.213     0.150
     8.237   116.672     0.150
     8.582   222.771     0.150
     8.582   124.172     0.150
     9.490   229.947     0.150
    10.461   148.572     0.150
    11.722   291.172     0.150
    12.343   178.072     0.150
    12.551   320.033     0.150
    12.551   175.271     0.150
    13.368   203.373     0.150
    13.368   338.473     0.150
    13.423   187.402     0.150
    13.433   186.873     0.150
    15.035   217.172     0.150
    15.035   378.771     0.150
    15.168   363.047     0.150
    15.168   208.492     0.150
    15.508   386.973     0.150
    17.597   239.611     0.150
    17.597   239.572     0.150
    17.974   243.842     0.150
    19.550   261.572     0.150
    20.319    12.699     0.150
    20.319   485.473     0.150
    20.277   268.572     0.150
    21.305   278.893     0.150
    21.305   278.973     0.150
    21.305   298.771     0.150
    21.305   534.672     0.150
    21.305   545.271     0.150
    22.106   307.373     0.150
    22.106   324.271     0.150
    25.803   324.873     0.150
    25.803   324.973     0.150
    26.247   534.152     0.150
    61.477   332.492     0.150
    27.859    20.000     0.150
    28.117   346.172     0.150
    28.117   345.771     0.150
    28.289   347.873     0.150
    28.726   348.572     0.150
    30.246  2253.365     0.150
    30.257  2251.096     0.150
    30.264  2259.455     0.150
    30.747    15.102     0.150
    31.121  2326.361     0.150
    31.124  2320.654     0.150
    31.138  2327.869     0.150
    36.546   418.672     0.150
    42.797   439.633     0.150
    42.797   438.393     0.150
    39.448   570.963     0.150
    40.302    14.600     0.150
    40.670   454.512     0.150
    42.484   468.393     0.150
    42.484   468.373     0.150
    42.542   468.873     0.150
    42.542   581.271     0.150
    42.743   470.973     0.150
   110.411   472.752     0.150
    43.529   475.652     0.150
    43.804   478.771     0.150
    43.918   480.271     0.150
    44.048   481.473     0.150
    45.351   491.922     0.150
    45.686   495.053     0.150
    45.943   496.463     0.150
    46.054   496.172     0.150
    46.054   496.262     0.150
    46.394   500.502     0.150
    47.273   507.422     0.150
    47.390   508.633     0.150
    47.704   510.873     0.150
    48.052   600.352     0.150
    48.548   516.432     0.150
    48.783   519.473     0.150
    48.783   519.521     0.150
    49.204   522.172     0.150
    49.204   522.172     0.150
    49.777   526.271     0.150
    49.965    21.602     0.150
    51.663   539.672     0.150
    52.141   545.373     0.150
    52.401   546.352     0.150
    52.609   547.703     0.150
    53.408   552.672     0.150
    54.243   558.873     0.150
    55.646   562.223     0.150
    55.563   567.873     0.150
    55.617   568.271     0.150
    55.699   569.252     0.150
    55.699   568.912     0.150
    56.769   577.172     0.150
    57.225   579.771     0.150
    58.359   589.682     0.150
    58.699   590.572     0.150
    58.978   592.082     0.150
    58.978   592.062     0.150
    58.978   592.072     0.150
    59.524   595.852     0.150
    59.524   595.873     0.150
    62.424   616.572     0.150
    62.424   616.572     0.150
    64.638    18.500     0.150
    64.638    25.301     0.150
    64.638   630.373     0.150
    64.745   630.742     0.150
    64.745   630.771     0.150
    65.504   632.973     0.150
    66.553   642.572     0.150
    66.954    20.801     0.150
    68.405   655.973     0.150
    68.405   655.973     0.150
    68.425   655.473     0.150
    68.672   656.271     0.150
    68.858   910.232     0.150
    68.858  1662.650     0.150
    68.858   657.873     0.150
    68.858    16.799     0.150
    68.858   810.971     0.150
    68.858   910.174     0.150
    68.858  1198.271     0.150
    68.858  1226.471     0.150
    68.858  1465.471     0.150
    69.781   663.762     0.150
    69.811   662.572     0.150
    70.774  1222.271     0.150
    70.890   669.602     0.150
    70.890   669.572     0.150
    79.602   679.123     0.150
    75.154   695.271     0.150
    75.275   696.082     0.150
    75.347   696.752     0.150
    75.347   696.771     0.150
    75.752   699.572     0.150
    75.752   699.572     0.150
    76.271   701.182     0.150
    76.307   703.107     0.150
    84.404   703.082     0.150
    76.559   703.572     0.150
    76.610   704.072     0.150
    76.644   704.672     0.150
    77.080   707.418     0.150
    77.134   706.072     0.150
    77.134    16.500     0.150
    77.134  1572.572     0.150
    77.134  1758.572     0.150
    77.361   708.572     0.150
    77.623   709.873     0.150
    77.635   709.873     0.150
    77.649   710.492     0.150
    77.821   712.059     0.150
    78.655   715.072     0.150
    78.655   715.072     0.150
    78.687   716.072     0.150
    78.753   715.121     0.150
    78.757   715.898     0.150
    79.432   718.480     0.150
    79.456   719.021     0.150
    79.833   721.389     0.150
    80.331   723.973     0.150
    80.331   724.072     0.150
    80.448   725.293     0.150
    80.814   725.672     0.150
    86.003  1831.873     0.150
    86.003   753.873     0.150
    86.050   753.072     0.150
    88.186   763.473     0.150
    89.212   768.873     0.150
   124.767  1131.373     0.150
   142.854  1164.799     0.150
   146.051 10971.705     0.150
   146.066 10973.006     0.150
   146.108  1171.771     0.150
     0.925    28.254     0.150
     1.834    43.156     0.150
     2.642    72.031     0.150
     4.640   122.332     0.150
     6.906    98.934     0.150
     8.333   116.062     0.150
     8.551   223.234     0.150
    10.515   148.633     0.150
    12.610   184.332     0.150
    14.558   200.832     0.150
    14.558   199.734     0.150
    17.916   239.172     0.150
    17.916   239.133     0.150
    21.305   278.281     0.150
    21.305   298.434     0.150
    21.305   528.133     0.150
    25.830    13.199     0.150
    25.889   323.922     0.150
    26.326   332.031     0.150
    26.333   750.102     0.150
    30.184  2255.355     0.150
    30.195  2258.930     0.150
    30.202  2256.812     0.150
    30.857   366.934     0.150
    30.857     6.699     0.150
    31.062  2319.066     0.150
    31.066  2318.855     0.150
    31.080  2320.273     0.150
    37.486    15.000     0.150
    42.696   440.254     0.150
    42.696   438.004     0.150
    39.515   571.082     0.150
    39.515   444.434     0.150
    42.624   581.234     0.150
    42.825   470.711     0.150
    42.825   470.734     0.150
    43.877   480.133     0.150
    44.034   482.234     0.150
    64.577   482.953     0.150
    44.376   586.102     0.150
    44.376   484.133     0.150
    44.376   586.133     0.150
    45.650   493.832     0.150
    45.718   495.633     0.150
    47.069   507.832     0.150
    48.990   519.734     0.150
    49.452   523.234     0.150
    49.886   525.633     0.150
    50.157   527.234     0.150
    50.869   534.914     0.150
    51.746   540.434     0.150
    53.460  1214.234     0.150
    55.758   562.352     0.150
    57.162   579.109     0.150
    57.162   579.133     0.150
    59.532   595.734     0.150
    62.476   616.961     0.150
    65.401   635.652     0.150
    66.203   642.281     0.150
    68.488   657.234     0.150
    82.590   656.602     0.150
    70.931   670.102     0.150
    70.931   670.133     0.150
    66.043   680.812     0.150
    77.158   706.133     0.150
    78.899   716.434     0.150
    85.894   754.031     0.150
   132.056  1147.121     0.150
     8.260   120.344     0.150
    26.269   328.762     0.150
    30.225  2257.945     0.150
    30.236  2263.344     0.150
    30.243  2256.773     0.150
    31.100  2324.852     0.150
    31.104  2323.664     0.150
    31.118  2326.809     0.150
    42.564   580.812     0.150
    43.905   479.211     0.150
    44.174   481.602     0.150
    45.187   488.320     0.150
    48.073   513.023     0.150
    48.073   600.391     0.150
    62.421   616.102     0.150
    66.148   642.211     0.150
    69.826   661.770     0.150
    70.909   669.242     0.150
    78.888   715.621     0.150
    85.990   751.148     0.150
    85.990   751.141     0.150
   146.029 10961.031     0.150
   146.045 10962.551     0.150
     0.208     8.984     0.150
     0.208    15.984     0.150
     1.306    23.930     0.150
     8.707   226.281     0.150
    12.511   175.883     0.150
    13.082   176.914     0.150
    13.386   188.383     0.150
    17.659   239.789     0.150
    17.659   240.680     0.150
    18.096   244.586     0.150
    20.323    12.797     0.150
    20.323    19.203     0.150
    20.323   493.484     0.150
    20.280   267.961     0.150
    20.280   268.383     0.150
    21.423   508.477     0.150
    21.423   278.984     0.150
    21.423   298.984     0.150
    21.423   533.383     0.150
    21.647    15.102     0.150
    22.178   284.781     0.150
    22.178   310.086     0.150
    22.178   319.680     0.150
    22.178   326.984     0.150
    22.178   573.680     0.150
    22.177   291.383     0.150
    24.180   308.680     0.150
    24.666   307.250     0.150
    24.964   312.680     0.150
    25.214   314.109     0.150
    25.853   325.383     0.150
    25.884   320.633     0.150
    25.990   321.016     0.150
    26.296   535.523     0.150
    61.561   333.656     0.150
    28.183   346.883     0.150
    30.167  2252.219     0.150
    30.178  2256.734     0.150
    30.185  2253.594     0.150
    30.377   362.391     0.150
    30.377   362.383     0.150
    30.748    20.797     0.150
    31.039  2324.086     0.150
    31.043  2323.812     0.150
    31.056  2322.898     0.150
    36.650   420.180     0.150
    37.136    16.203     0.150
    37.393    13.102     0.150
    42.890   440.000     0.150
    39.522   571.586     0.150
    68.385   464.203     0.150
    42.573   469.086     0.150
    42.597   468.883     0.150
    42.799   470.141     0.150
    42.799   470.180     0.150
    43.872   480.102     0.150
    43.872   480.680     0.150
    43.872   480.141     0.150
    43.872   480.102     0.150
    64.532   482.242     0.150
    44.114   471.539     0.150
    44.113   483.531     0.150
    44.571   485.453     0.150
    44.851   486.883     0.150
    45.610   492.672     0.150
    45.399   492.391     0.150
    45.991   497.102     0.150
    46.605   501.773     0.150
    46.613   494.195     0.150
    46.666   503.680     0.150
    83.913   503.984     0.150
    83.913   596.672     0.150
    47.005   500.906     0.150
    47.323   508.086     0.150
    47.368   508.883     0.150
    47.440   509.133     0.150
    47.564   500.422     0.150
    47.637    10.617     0.150
    47.637   509.984     0.150
   122.880   511.234     0.150
    47.753   511.375     0.150
    48.128   600.930     0.150
    48.522   517.883     0.150
    49.254   522.703     0.150
    49.254   522.680     0.150
    49.254   522.641     0.150
    49.254   522.742     0.150
    49.309   520.062     0.150
    49.309   520.484     0.150
    49.309   520.484     0.150
    50.830   535.102     0.150
    51.312   538.500     0.150
    51.718   540.586     0.150
    51.984   542.500     0.150
    52.196   545.844     0.150
    13.467   547.055     0.150
    52.662   548.203     0.150
    53.497   553.586     0.150
    53.497   615.281     0.150
    53.497   553.484     0.150
    54.273   560.586     0.150
    55.576   563.211     0.150
    55.186   559.516     0.150
    56.497   570.195     0.150
    56.806   577.281     0.150
    56.806   577.680     0.150
    57.953   584.484     0.150
    59.297   594.641     0.150
    59.388   596.703     0.150
    60.774   603.984     0.150
    60.774   603.984     0.150
    60.774   604.039     0.150
    61.211   607.953     0.150
    62.008   613.984     0.150
    62.453   615.586     0.150
    63.072   620.320     0.150
    64.005   625.992     0.150
    64.693   631.984     0.150
    64.735   630.984     0.150
    65.519   633.625     0.150
    66.028   640.180     0.150
    67.135   646.586     0.150
    67.575   647.664     0.150
    68.483   654.633     0.150
    68.483   656.406     0.150
    68.777   657.586     0.150
    68.777   655.383     0.150
    68.959   658.570     0.150
    68.959   658.570     0.150
    68.959   912.195     0.150
    68.959  1663.781     0.150
    68.959   658.484     0.150
    68.959    17.195     0.150
    68.959   810.781     0.150
    68.959   912.180     0.150
    68.959  1199.680     0.150
    68.959  1228.781     0.150
    68.959  1466.180     0.150
    69.633   661.164     0.150
    69.822   662.070     0.150
    69.925   662.883     0.150
    69.925   662.883     0.150
    69.985   662.859     0.150
    70.077   666.352     0.150
    70.286   665.914     0.150
    70.780   670.188     0.150
    70.987   670.422     0.150
    70.999   670.477     0.150
    70.999   670.430     0.150
    70.999   670.586     0.150
    71.222   670.883     0.150
    71.528   672.781     0.150
    71.886   675.414     0.150
    71.975   677.469     0.150
    72.236   679.469     0.150
    72.719   680.680     0.150
    72.874   681.227     0.150
    73.266   685.602     0.150
    73.684   688.961     0.150
    74.104   688.500     0.150
    74.302   689.086     0.150
    74.570   692.562     0.150
    74.654   692.133     0.150
    74.663   691.664     0.150
    74.663   691.586     0.150
    75.033   695.281     0.150
    75.247   696.680     0.150
    75.375   697.055     0.150
    75.449   695.750     0.150
    75.449   697.086     0.150
    75.454   698.766     0.150
    75.596   695.484     0.150
    75.774   699.781     0.150
    75.861   699.203     0.150
    76.228   700.883     0.150
    76.278   701.664     0.150
    76.351   703.086     0.150
    76.370   702.484     0.150
    76.408   703.891     0.150
    76.444   702.484     0.150
    76.626   704.586     0.150
    76.664   705.781     0.150
    76.664   705.781     0.150
    76.720   703.836     0.150
    76.720   705.453     0.150
    76.745   705.180     0.150
    76.748   705.484     0.150
    76.783   705.484     0.150
    76.961   705.672     0.150
    77.241   706.883     0.150
    77.241    16.000     0.150
    77.244   707.086     0.150
    77.284   708.086     0.150
    77.308   706.062     0.150
    77.464   709.281     0.150
    77.464   708.281     0.150
    77.729   709.984     0.150
    77.742   709.203     0.150
    77.739   709.320     0.150
    77.768   709.195     0.150
    77.915   699.484     0.150
    77.923   713.281     0.150
    78.176   711.281     0.150
    78.289   711.703     0.150
    78.289   711.680     0.150
    78.649   713.242     0.150
    78.654   714.656     0.150
    78.760   717.180     0.150
    78.760   717.180     0.150
    78.761   714.672     0.150
    78.765   714.984     0.150
    78.765   715.039     0.150
    78.792   716.586     0.150
    78.792   714.977     0.150
    78.855   716.039     0.150
    78.976   715.484     0.150
    78.976   715.562     0.150
    79.049   715.930     0.150
    79.049   715.883     0.150
    79.372   717.531     0.150
    79.528   718.742     0.150
    79.560   719.406     0.150
    79.606   718.852     0.150
    79.603   718.164     0.150
    79.646   719.305     0.150
    79.681   718.781     0.150
    79.681   718.852     0.150
    79.745   719.953     0.150
    79.842   720.336     0.150
    79.844   720.531     0.150
    80.411   726.781     0.150
    80.632   727.680     0.150
    80.721   726.781     0.150
    81.054   726.922     0.150
    81.343   727.445     0.150
    81.404   728.836     0.150
    81.404   728.781     0.150
    81.539   728.891     0.150
    81.714   730.453     0.150
    81.716   729.922     0.150
    81.755   731.125     0.150
    81.823   729.703     0.150
    81.823   729.680     0.150
    81.915   730.977     0.150
    81.915   730.883     0.150
    82.127   732.992     0.150
    82.264   733.125     0.150
    82.393   733.133     0.150
    82.393   733.086     0.150
    82.571   734.883     0.150
    82.590   733.953     0.150
    82.603   735.211     0.150
    83.175   737.781     0.150
    83.860   742.680     0.150
    84.476   745.703     0.150
    85.375   749.680     0.150
    85.397   750.586     0.150
    86.080   755.781     0.150
    86.147   754.883     0.150
   142.927  1167.383     0.150
   145.989  1170.195     0.150
   151.933  1189.555     0.150
     2.292    58.996     0.150
     6.830    98.598     0.150
    14.637   205.699     0.150
    26.244   327.270     0.150
    30.253  2259.137     0.150
    30.263  2257.875     0.150
    30.270  2258.508     0.150
    30.751   367.598     0.150
    31.128  2319.211     0.150
    31.132  2325.004     0.150
    31.145  2320.406     0.150
    32.528    23.699     0.150
    39.442   443.758     0.150
    42.539   469.227     0.150
    42.740   470.297     0.150
    44.452   485.496     0.150
    58.683   591.996     0.150
    74.928   694.297     0.150
    75.265   700.906     0.150
   146.045 10961.754     0.150
   146.061 10960.926     0.150
     0.322    10.703     0.150
     0.322    10.766     0.150
     0.321    19.676     0.150
     0.899    27.312     0.150
     0.920    28.465     0.150
     1.822    29.273     0.150
     2.113    33.234     0.150
     2.258    61.664     0.150
     3.199    49.965     0.150
     3.199    86.863     0.150
     4.639    68.914     0.150
     4.639    68.605     0.150
     4.639    68.555     0.150
     6.861    98.094     0.150
     6.861    97.965     0.150
     8.022   113.945     0.150
     8.262   117.766     0.150
     8.382   118.555     0.150
     8.551   221.766     0.150
     9.531   130.723     0.150
     9.531   230.738     0.150
    11.239   287.766     0.150
    12.594   175.965     0.150
    13.373   196.664     0.150
    13.373   340.766     0.150
    13.465   192.320     0.150
    13.465   187.934     0.150
    13.477   189.465     0.150
    14.988   374.062     0.150
    17.610   240.465     0.150
    17.935   242.395     0.150
    17.935   243.562     0.150
    20.352    13.102     0.150
    20.352    21.000     0.150
    20.352   485.664     0.150
    20.311   269.363     0.150
    20.715   505.164     0.150
    21.285   277.863     0.150
    21.285    23.102     0.150
    21.285   546.164     0.150
    21.374   279.562     0.150
    22.115   307.562     0.150
    22.115   321.562     0.150
    22.115   331.266     0.150
    23.259   301.363     0.150
    23.503    12.398     0.150
    24.312   311.562     0.150
    24.770    14.902     0.150
    24.792   316.855     0.150
    24.792   322.328     0.150
    25.821   325.512     0.150
    26.265   329.176     0.150
    26.265   329.164     0.150
    61.430   337.547     0.150
    27.898    16.301     0.150
    28.129   346.562     0.150
    28.724   350.363     0.150
    30.240  2258.207     0.150
    30.251  2261.078     0.150
    30.258  2261.617     0.150
    30.781    24.102     0.150
    30.781   427.562     0.150
    31.116  2328.836     0.150
    31.120  2324.684     0.150
    31.134  2323.223     0.150
    37.411    15.801     0.150
    37.411    23.301     0.150
    42.749   439.855     0.150
    42.749   439.883     0.150
    39.071   439.145     0.150
    39.456   571.266     0.150
    39.793    14.699     0.150
    40.342    16.898     0.150
    40.342    24.098     0.150
    40.686   454.625     0.150
    42.436   467.973     0.150
    42.436   467.965     0.150
    42.436   468.004     0.150
    42.558   469.266     0.150
    42.615   471.949     0.150
    42.760   470.965     0.150
    42.760   471.164     0.150
    42.888   471.773     0.150
    43.612   476.863     0.150
    43.673   477.664     0.150
    43.688   479.336     0.150
    43.815   479.203     0.150
    43.815   479.125     0.150
    43.815   479.164     0.150
    43.815   479.312     0.150
    43.895   861.703     0.150
    43.961   481.863     0.150
    44.002   481.109     0.150
    44.002   480.965     0.150
    44.002   480.953     0.150
    64.508   483.273     0.150
    64.508   483.035     0.150
    44.200   484.215     0.150
    44.421   483.965     0.150
    44.540   484.164     0.150
    44.673   487.578     0.150
    45.582   493.359     0.150
    45.371   493.965     0.150
    45.625   494.234     0.150
    45.963   496.562     0.150
    46.072   497.625     0.150
    46.414   500.426     0.150
    46.681   502.918     0.150
    46.772   502.762     0.150
    46.772   501.965     0.150
    47.021   506.445     0.150
    47.021   506.363     0.150
    47.292   507.453     0.150
    47.343   508.562     0.150
    47.318   507.902     0.150
    47.409   508.395     0.150
    47.610   508.664     0.150
    47.610   508.664     0.150
    47.669   509.895     0.150
    47.722   510.785     0.150
    48.045   514.363     0.150
    48.564   516.465     0.150
    48.555   517.363     0.150
    48.783   520.465     0.150
    48.962   519.723     0.150
    49.153   520.465     0.150
    49.153   520.465     0.150
    49.222   522.184     0.150
    49.222   522.184     0.150
    49.222   522.148     0.150
    49.222   522.293     0.150
    49.222   522.363     0.150
    49.222   522.195     0.150
    50.771   535.934     0.150
    51.680   539.766     0.150
    51.641   540.883     0.150
    51.641   540.465     0.150
    51.610   539.902     0.150
    52.626   547.793     0.150
    53.409   552.652     0.150
    53.444   553.844     0.150
    53.783   559.055     0.150
    54.151   558.836     0.150
    54.268   560.383     0.150
    54.268   559.664     0.150
    54.591   561.695     0.150
    55.693   562.945     0.150
    55.693   562.543     0.150
    54.765   561.652     0.150
    54.765   561.664     0.150
    54.765   561.965     0.150
    54.765   561.676     0.150
    55.406   569.234     0.150
    55.592   567.863     0.150
    55.592   567.863     0.150
    55.674   569.422     0.150
    55.674   569.395     0.150
    55.674   569.363     0.150
    55.704   570.242     0.150
    56.002   574.941     0.150
    56.002   574.992     0.150
    56.256   574.266     0.150
    56.551   575.766     0.150
    56.792   577.086     0.150
    56.792   576.664     0.150
    56.837   578.363     0.150
    57.411   583.020     0.150
    58.588   590.766     0.150
    58.653  2358.840     0.150
    58.653   590.113     0.150
    58.961   591.824     0.150
    58.961   592.363     0.150
    59.180   594.473     0.150
    59.180   593.266     0.150
    59.507   595.164     0.150
    60.580   602.766     0.150
    60.620   602.598     0.150
    60.620   602.465     0.150
    60.792   604.363     0.150
    61.077   606.164     0.150
    62.162   613.766     0.150
    62.328   614.562     0.150
    62.433   616.664     0.150
    62.451   616.246     0.150
    62.451   615.465     0.150
    62.451   616.203     0.150
    62.451   615.562     0.150
    62.461   615.863     0.150
    62.606   615.863     0.150
    64.204   630.184     0.150
    64.204   627.062     0.150
    64.634   630.164     0.150
    64.634  1171.266     0.150
    64.634  1391.664     0.150
    64.734   630.543     0.150
    66.544   642.562     0.150
    66.720   644.602     0.150
    66.720   643.273     0.150
    66.982   644.965     0.150
    67.497   650.062     0.150
    67.933   652.594     0.150
    67.933   652.664     0.150
    68.213    13.781     0.150
    68.213   654.965     0.150
    68.213    13.801     0.150
    68.298   653.465     0.150
    68.411    14.840     0.150
    68.411   656.395     0.150
    68.411   656.434     0.150
    68.411   656.363     0.150
    68.626   656.062     0.150
    68.626   655.766     0.150
    68.626   656.035     0.150
    68.746   655.844     0.150
    68.851   911.164     0.150
    68.851  1663.742     0.150
    68.851  1466.203     0.150
    68.851  1198.383     0.150
    68.851   911.184     0.150
    68.851   810.652     0.150
    68.851   658.055     0.150
    68.851   658.055     0.150
    68.851   658.055     0.150
    82.643   658.391     0.150
    82.643   658.109     0.150
    69.533   657.145     0.150
    69.709   661.016     0.150
    69.795   661.664     0.150
    69.795   661.664     0.150
    70.142   666.766     0.150
    70.314   922.766     0.150
    70.314  1478.863     0.150
    70.519   666.164     0.150
    70.768   669.719     0.150
    70.887   669.062     0.150
    70.887   669.363     0.150
    70.899   668.293     0.150
    70.899   668.266     0.150
    70.899   669.516     0.150
    71.111   671.062     0.150
    71.398   670.742     0.150
    71.407    14.898     0.150
    71.407   673.742     0.150
    71.407   673.758     0.150
    71.407   673.828     0.150
    71.407   673.703     0.150
    71.533   674.926     0.150
    71.673   675.430     0.150
    71.965   676.840     0.150
    72.226   679.094     0.150
    72.403   678.676     0.150
    72.568   680.664     0.150
    73.098   683.273     0.150
    73.019   684.266     0.150
   111.482   685.965     0.150
    73.533   687.418     0.150
    73.702   679.555     0.150
    73.702   679.562     0.150
    73.763   686.863     0.150
   140.014   690.215     0.150
    74.934   694.180     0.150
    74.973   694.984     0.150
    75.016   695.586     0.150
    75.106   695.633     0.150
    75.106   694.312     0.150
    75.106   694.363     0.150
    75.140   694.984     0.150
    75.314   696.590     0.150
    75.347   697.719     0.150
    75.549   698.195     0.150
    75.746   700.164     0.150
    75.902   699.863     0.150
    75.902   699.820     0.150
    75.920   699.254     0.150
    76.134   702.211     0.150
    76.256   702.266     0.150
    76.300   703.266     0.150
    84.408   702.824     0.150
    76.602   704.062     0.150
    76.616   704.621     0.150
    76.631   703.664     0.150
    76.631   703.664     0.150
    76.635   704.562     0.150
    76.643   703.465     0.150
    76.643   703.465     0.150
    76.689   704.363     0.150
    77.062    14.812     0.150
    77.070   702.652     0.150
    77.123   706.234     0.150
    77.123   706.266     0.150
    77.123    22.398     0.150
    77.128   705.766     0.150
    77.128   705.668     0.150
    77.353    15.000     0.150
    77.353   707.031     0.150
    77.353   707.465     0.150
    77.353   707.531     0.150
    77.327   709.266     0.150
    77.459   708.363     0.150
    77.614   709.363     0.150
    77.627   709.766     0.150
    77.641   711.562     0.150
    77.641   711.551     0.150
    77.713   709.750     0.150
    77.779   710.164     0.150
    77.814   711.695     0.150
    77.823   712.164     0.150
    78.009   711.227     0.150
    78.075   711.863     0.150
    78.075   706.004     0.150
    78.112   712.105     0.150
    78.324   713.176     0.150
    78.580   713.863     0.150
    78.580   713.914     0.150
    78.580   714.344     0.150
    78.531   711.113     0.150
    78.531   711.164     0.150
    78.646   716.562     0.150
    78.646   716.562     0.150
    78.677   715.363     0.150
    78.677    17.402     0.150
    78.862   716.215     0.150
    78.862   716.492     0.150
    78.934   717.016     0.150
    79.100   718.074     0.150
    79.102   717.164     0.150
    79.425   716.949     0.150
    79.448   719.820     0.150
    79.542   721.277     0.150
    79.542   720.266     0.150
    79.542   721.254     0.150
    79.643   720.164     0.150
    79.543   721.465     0.150
    79.790   721.945     0.150
    79.790   721.805     0.150
    79.790   721.062     0.150
    79.928   721.562     0.150
    80.134   723.016     0.150
    80.267   722.594     0.150
    80.344   723.445     0.150
    80.284   725.664     0.150
    80.284   725.285     0.150
    80.602   725.887     0.150
    80.897   728.965     0.150
    80.917   726.328     0.150
    81.035   726.195     0.150
    81.228   729.766     0.150
    81.284   727.562     0.150
    81.284   727.562     0.150
    81.794   731.363     0.150
    82.127   733.965     0.150
    82.299   734.863     0.150
    83.038   739.164     0.150
    83.059   737.152     0.150
    84.196   743.410     0.150
    84.196   743.980     0.150
    84.673   747.660     0.150
    84.736   747.781     0.150
    84.736   747.766     0.150
    85.236   749.094     0.150
    84.954   748.766     0.150
    84.932   749.664     0.150
    85.239   748.766     0.150
    85.239   748.766     0.150
    85.280   749.766     0.150
    85.608   751.863     0.150
    85.956  1831.090     0.150
    86.003   752.863     0.150
    88.139   763.562     0.150
    88.139   763.926     0.150
    89.164   769.176     0.150
    89.164   767.086     0.150
    89.164   767.062     0.150
    89.514   770.730     0.150
    90.004   771.664     0.150
    93.299   788.523     0.150
   120.132  1123.914     0.150
   123.125  1129.414     0.150
   124.812  1131.863     0.150
   142.806  1164.641     0.150
   142.806  1164.062     0.150
   142.806  1164.562     0.150
   149.416  1179.395     0.150
   149.772  1184.766     0.150
   154.912  1194.312     0.150
   156.927  1188.664     0.150
     0.272     9.879     0.150
     0.993    30.648     0.150
     2.403    62.750     0.150
     2.578    40.348     0.150
     4.761    71.148     0.150
     4.761    71.168     0.150
     4.761    71.750     0.150
     8.208   117.348     0.150
     8.674   225.648     0.150
     9.385   130.398     0.150
    12.409   180.750     0.150
    12.426   180.449     0.150
    13.344   183.918     0.150
    14.763   205.348     0.150
    17.594   240.699     0.150
    20.221   268.148     0.150
    23.547   302.871     0.150
    61.584   330.598     0.150
    30.231  2334.941     0.150
    30.242  2339.996     0.150
    30.249  2337.781     0.150
    31.103  2396.836     0.150
    31.107  2396.266     0.150
    31.120  2397.965     0.150
    32.483    14.301     0.150
    42.905   440.180     0.150
    39.751    16.000     0.150
    40.840   455.398     0.150
    41.457   462.008     0.150
    42.058   466.668     0.150
    42.531   469.371     0.150
    42.531   469.250     0.150
    42.733   471.051     0.150
    43.831   481.051     0.150
    43.807   479.449     0.150
    45.922   496.648     0.150
    47.011   506.430     0.150
    47.859   511.551     0.150
    48.487   514.551     0.150
    51.652   539.348     0.150
    55.546   562.270     0.150
    56.874   578.648     0.150
    59.042   592.051     0.150
    59.544   596.621     0.150
    60.656   602.551     0.150
    60.656   602.551     0.150
    60.737   605.148     0.150
    60.737   603.449     0.150
    60.864   604.551     0.150
    62.313   614.848     0.150
    62.400   614.750     0.150
    64.798   631.219     0.150
    66.602   643.051     0.150
    68.783   657.449     0.150
    70.926   668.148     0.150
    70.938   669.980     0.150
    70.938   669.949     0.150
    75.794   699.848     0.150
    76.287   701.301     0.150
    76.312   702.949     0.150
    84.424   704.891     0.150
    76.655   703.078     0.150
    76.655   703.051     0.150
    77.185   706.848     0.150
    77.406   708.648     0.150
    77.505   709.410     0.150
    77.681   710.250     0.150
    77.687   710.051     0.150
    78.077   711.945     0.150
    80.172   725.070     0.150
    82.506   734.449     0.150
    83.806   742.250     0.150
    85.682   752.551     0.150
    86.107   755.551     0.150
   146.001  1171.898     0.150
   146.001  1171.949     0.150
     0.456    12.818     0.150
     0.456    23.838     0.150
     0.456    12.797     0.150
     0.456    23.797     0.150
     1.688    44.572     0.150
     2.222    60.598     0.150
     6.956    99.197     0.150
     6.956   176.260     0.150
     9.651   131.697     0.150
     9.651   232.898     0.150
     9.958   162.398     0.150
     9.958   245.598     0.150
    11.669   290.898     0.150
    12.610   175.197     0.150
    13.265   335.998     0.150
    13.476   186.918     0.150
    14.517   199.697     0.150
    14.902   217.797     0.150
    14.902   378.398     0.150
    20.320    17.000     0.150
    20.320    23.600     0.150
    20.278   267.398     0.150
    20.748    14.500     0.150
    20.748    19.400     0.150
    20.748   531.598     0.150
    21.151   529.098     0.150
    21.758   523.498     0.150
    22.205   520.197     0.150
    23.200   298.797     0.150
    23.461   299.197     0.150
    23.461   543.197     0.150
    23.771   556.398     0.150
    25.773   320.598     0.150
    25.773   591.998     0.150
    27.885    15.299     0.150
    28.175   630.898     0.150
    30.347  2261.771     0.150
    30.358  2259.631     0.150
    30.365  2261.434     0.150
    30.752    17.400     0.150
    31.225  2328.861     0.150
    31.229  2327.395     0.150
    31.243  2330.137     0.150
    32.507    16.100     0.150
    32.507   697.398     0.150
    32.507  1007.197     0.150
    36.459   753.498     0.150
    37.369   772.098     0.150
    42.671   439.707     0.150
    42.671   438.479     0.150
    39.354   569.967     0.150
    39.354   442.098     0.150
    39.720    21.801     0.150
    39.720   446.059     0.150
    39.720    14.449     0.150
    40.341    16.799     0.150
    40.341    26.500     0.150
    40.341   820.898     0.150
    42.363   466.797     0.150
    42.675   469.398     0.150
    42.793   471.098     0.150
    42.793   471.107     0.150
    43.521   476.797     0.150
    43.719   477.898     0.150
    43.719   478.283     0.150
    43.719   477.979     0.150
    43.978   481.537     0.150
    44.328   482.828     0.150
    44.803   487.098     0.150
    44.888   488.158     0.150
    44.888   488.098     0.150
    45.504   491.697     0.150
    45.294   490.787     0.150
    45.620   493.488     0.150
    45.885   495.387     0.150
    45.994   496.527     0.150
    46.336   499.248     0.150
    47.213   506.309     0.150
    47.239   506.547     0.150
    47.330   507.387     0.150
    47.533   508.797     0.150
    47.954   599.178     0.150
    48.011   512.697     0.150
    48.478   515.107     0.150
    48.524   515.197     0.150
    48.524   515.197     0.150
    48.554   516.498     0.150
    48.752   518.197     0.150
    48.830   518.428     0.150
    49.051   519.998     0.150
    49.142   520.797     0.150
    49.342   523.297     0.150
    49.777   524.098     0.150
    49.917    27.801     0.150
    50.047   528.197     0.150
    51.596   538.697     0.150
    52.361   544.658     0.150
    52.543   546.568     0.150
    53.295    18.400     0.150
    53.295   612.398     0.150
    53.295   551.297     0.150
    54.208   558.498     0.150
    54.208   559.443     0.150
    54.635   559.898     0.150
    54.635   561.658     0.150
    55.743   560.498     0.150
    56.415   574.197     0.150
    56.415   574.168     0.150
    56.725   575.297     0.150
    57.696   582.297     0.150
    58.828   590.098     0.150
    58.828   590.197     0.150
    59.374   594.348     0.150
    59.374   593.947     0.150
    59.374   593.998     0.150
    59.660   595.877     0.150
    60.486   601.098     0.150
    62.332   615.189     0.150
    62.588   616.598     0.150
    88.305   620.088     0.150
    64.399   629.098     0.150
    64.605   629.047     0.150
    65.102   633.568     0.150
    68.326   654.498     0.150
    68.428   650.398     0.150
    68.531   654.998     0.150
    68.531   654.887     0.150
    68.727   656.467     0.150
    68.727   656.467     0.150
    68.727    18.080     0.150
    68.727    26.111     0.150
    68.727   908.848     0.150
    68.727  1658.588     0.150
    68.727   656.398     0.150
    68.727    18.100     0.150
    68.727    26.100     0.150
    68.727   808.197     0.150
    68.727   908.797     0.150
    68.727  1194.398     0.150
    68.727  1226.498     0.150
    68.727  1461.297     0.150
    69.663   660.598     0.150
    70.390   665.498     0.150
    70.390   665.578     0.150
    70.766   667.998     0.150
    70.778   667.398     0.150
    70.778   667.957     0.150
    70.847   669.809     0.150
    71.343   671.713     0.150
    73.061   683.248     0.150
   111.563   684.797     0.150
    73.973   687.598     0.150
    74.435   691.008     0.150
    75.028   693.398     0.150
    75.147   692.098     0.150
    75.147   692.119     0.150
    75.215   695.518     0.150
    75.224   696.529     0.150
    75.383   695.697     0.150
    75.622   699.168     0.150
    76.129   700.758     0.150
    76.176   701.512     0.150
    76.477   702.398     0.150
    76.508   701.498     0.150
    76.508   701.498     0.150
    76.545   702.998     0.150
    76.995    18.900     0.150
    76.995   704.697     0.150
    76.995    18.900     0.150
    76.995    26.900     0.150
    77.502   707.398     0.150
    77.689   709.959     0.150
    78.198    27.426     0.150
    78.391    27.477     0.150
    78.421   712.598     0.150
    78.520   704.898     0.150
    78.550   713.898     0.150
    78.620    27.219     0.150
    78.625    27.357     0.150
    78.644   713.342     0.150
    78.644   714.598     0.150
    79.300    27.557     0.150
    79.960    27.576     0.150
    80.292    27.623     0.150
    80.313    27.201     0.150
    80.789    27.660     0.150
    80.962    27.467     0.150
    80.973    27.561     0.150
    81.094   728.998     0.150
    81.373    27.582     0.150
    83.607   740.697     0.150
    85.477   751.297     0.150
    85.918   751.898     0.150
    88.049   762.197     0.150
    89.078   767.998     0.150
    89.078   767.998     0.150
    89.078   767.988     0.150
   146.039 10971.170     0.150
   146.054 10972.521     0.150
   151.979  1186.758     0.150
     0.181     6.340     0.150
     0.581    12.508     0.150
     0.581    20.707     0.150
     1.220    38.457     0.150
     1.723    29.090     0.150
     2.524    39.410     0.150
     2.524    39.207     0.150
     6.742    98.309     0.150
     8.254   120.309     0.150
     8.474   222.910     0.150
     9.514   137.109     0.150
    12.262   177.410     0.150
    12.302   315.910     0.150
    12.302   171.609     0.150
    14.751   206.008     0.150
    14.751   206.109     0.150
    15.142   204.008     0.150
    19.975   267.008     0.150
    21.116   284.109     0.150
    21.116   280.707     0.150
    21.116   532.410     0.150
    24.110   316.539     0.150
    30.541  2270.723     0.150
    30.552  2267.348     0.150
    30.559  2270.312     0.150
    37.072     6.801     0.150
    37.072    12.602     0.150
    42.923   439.879     0.150
    42.923   438.309     0.150
    42.229   469.418     0.150
    42.229   469.410     0.150
    42.431   470.848     0.150
    42.431   470.809     0.150
    42.623   473.410     0.150
    64.172   482.238     0.150
    43.910   482.930     0.150
    43.910   487.008     0.150
   156.610   492.867     0.150
    46.247   500.859     0.150
    46.627   504.027     0.150
    46.991   506.297     0.150
    47.617   515.410     0.150
    47.710   516.207     0.150
    47.973   513.578     0.150
    47.973   513.609     0.150
    48.448   521.410     0.150
    48.580   522.609     0.150
    49.040   526.809     0.150
    50.467   534.668     0.150
    51.350   540.219     0.150
    51.350   540.207     0.150
    53.127   552.840     0.150
    53.127   553.910     0.150
    53.127   618.008     0.150
    55.455   562.688     0.150
    55.956   574.367     0.150
    57.203   583.109     0.150
    59.161   597.188     0.150
    59.317   597.809     0.150
    62.483   619.109     0.150
    64.373   863.008     0.150
    64.373  1165.109     0.150
    64.511   633.207     0.150
    65.332   638.770     0.150
    66.210   644.609     0.150
    67.357   651.660     0.150
    68.129   657.207     0.150
    68.134   655.238     0.150
    70.329   670.160     0.150
    70.329   670.207     0.150
    70.623   671.207     0.150
    70.635   670.559     0.150
    70.635   672.008     0.150
    70.635   670.609     0.150
    73.324   688.508     0.150
   111.315   687.508     0.150
    75.015   698.270     0.150
    75.093   698.270     0.150
    75.093   698.309     0.150
    75.096   700.949     0.150
    75.903   705.859     0.150
    75.978   703.039     0.150
    75.978   703.008     0.150
    76.051   706.312     0.150
    76.396   705.887     0.150
    76.396   705.910     0.150
    76.729   708.207     0.150
    76.894   708.008     0.150
    76.894  2770.309     0.150
    77.568   714.676     0.150
    77.813   713.199     0.150
    77.813   713.207     0.150
    78.376   716.410     0.150
    78.625   717.738     0.150
    78.625   717.707     0.150
    79.189   720.879     0.150
    80.589   728.090     0.150
    81.367   734.301     0.150
    81.395   735.047     0.150
    81.778   735.258     0.150
    82.826   739.707     0.150
    83.099   742.059     0.150
    85.006   752.770     0.150
    88.870   769.938     0.150
    89.239   771.758     0.150
   143.036  1172.309     0.150
     0.309    10.297     0.150
     0.309    10.227     0.150
     0.309    10.398     0.150
     0.919    27.125     0.150
     0.918    28.281     0.150
     1.474    40.125     0.150
     1.831    45.703     0.150
     1.830    45.703     0.150
     1.830    54.508     0.150
     2.151    33.828     0.150
     2.385    64.023     0.150
     3.152    52.227     0.150
     3.152    87.422     0.150
     6.892   177.414     0.150
     8.313   208.844     0.150
     8.313   119.125     0.150
     9.547   230.727     0.150
    10.501   261.070     0.150
    10.501   268.828     0.150
    10.957   281.828     0.150
    12.258   301.523     0.150
    12.646   177.023     0.150
    13.412   184.523     0.150
    13.517   188.688     0.150
    13.517   188.719     0.150
    13.527   189.648     0.150
    14.498   368.125     0.150
    14.954   205.422     0.150
    15.205   206.000     0.150
    15.205   362.523     0.150
    17.922   242.812     0.150
    19.135   257.695     0.150
    19.135   256.484     0.150
    19.750   249.922     0.150
    19.750   257.125     0.150
    19.750    19.000     0.150
    19.750   468.125     0.150
    19.750   504.227     0.150
    20.406    21.898     0.150
    20.406   497.422     0.150
    20.364   269.727     0.150
    21.300   506.242     0.150
    21.300   277.922     0.150
    21.300   296.328     0.150
    21.300   520.023     0.150
    21.300   531.227     0.150
    22.277   533.422     0.150
    23.216   300.195     0.150
    25.808    20.102     0.150
    25.870   325.625     0.150
    28.173   346.672     0.150
    28.204   346.023     0.150
    28.679   350.523     0.150
    30.200  2252.312     0.150
    30.211  2256.688     0.150
    30.218  2256.961     0.150
    30.835    23.305     0.150
    30.835   661.422     0.150
    31.077  2325.305     0.150
    31.081  2322.859     0.150
    31.095  2326.094     0.150
    39.096   439.625     0.150
    39.096   439.523     0.150
    39.843    20.719     0.150
    39.843   447.922     0.150
    39.843    11.305     0.150
    40.395    23.797     0.150
   115.838   456.125     0.150
    68.280   465.766     0.150
    42.397   467.969     0.150
    42.397   467.922     0.150
    42.397   467.875     0.150
    42.605   581.523     0.150
    42.605   469.828     0.150
    42.807   472.023     0.150
    42.807   471.547     0.150
    42.932   472.578     0.150
    43.859   479.852     0.150
    43.859   479.828     0.150
    43.859   479.992     0.150
    43.859   479.977     0.150
    43.939   479.828     0.150
    43.971   481.219     0.150
    43.971   481.234     0.150
    64.591   481.328     0.150
    44.012   482.281     0.150
    44.012   482.328     0.150
    44.251   588.273     0.150
    44.251   484.422     0.150
    44.295   484.797     0.150
    44.390   586.398     0.150
    44.506   484.328     0.150
    44.677   485.562     0.150
    44.677   485.523     0.150
    45.630   493.797     0.150
    45.750   495.148     0.150
    46.011   497.055     0.150
    46.121   498.156     0.150
    46.688   502.922     0.150
    47.069   506.227     0.150
    47.340   507.992     0.150
    47.366   508.164     0.150
    47.658   510.328     0.150
    47.713   510.383     0.150
   122.705   512.945     0.150
    48.100   600.625     0.150
    48.133   513.766     0.150
    48.355   516.125     0.150
    48.355   602.023     0.150
    80.504   515.273     0.150
    48.610   516.828     0.150
    48.608   518.328     0.150
    49.126   521.125     0.150
    49.270   522.609     0.150
    49.270   522.328     0.150
    49.270   522.727     0.150
    49.270   522.695     0.150
    49.864   528.523     0.150
    50.849   535.172     0.150
    51.668   541.523     0.150
    51.727   540.422     0.150
    52.000   543.305     0.150
    52.205   545.836     0.150
    52.674   547.422     0.150
    52.674   547.438     0.150
    13.639   549.531     0.150
    13.639   548.945     0.150
    52.887   549.156     0.150
    52.887   549.227     0.150
    53.446   553.227     0.150
    53.446   553.297     0.150
    53.446   553.188     0.150
    54.320   560.906     0.150
    54.320   560.625     0.150
    54.613   562.312     0.150
    54.761   561.922     0.150
    55.739   563.266     0.150
    55.739   563.242     0.150
    55.739   563.219     0.150
    54.971   564.422     0.150
    55.682   569.227     0.150
    55.682   568.328     0.150
    56.561   576.523     0.150
    56.843   577.469     0.150
    56.843   577.422     0.150
    57.170   579.227     0.150
    57.849   584.164     0.150
    57.849   584.227     0.150
    57.849   584.273     0.150
    58.428  1294.828     0.150
    58.979   592.203     0.150
    58.979   591.922     0.150
    58.979   592.234     0.150
    59.525   595.875     0.150
    59.525   595.922     0.150
    60.600   603.125     0.150
    60.814   604.727     0.150
    62.160   615.328     0.150
    62.233   614.562     0.150
    62.480   616.875     0.150
    62.471   617.023     0.150
    63.543   621.523     0.150
    64.323   628.047     0.150
    64.666   630.375     0.150
    64.666    18.406     0.150
    64.666  1137.625     0.150
    64.820   633.016     0.150
    65.497   637.625     0.150
    75.951   641.492     0.150
    66.198   642.273     0.150
    66.261    17.203     0.150
    66.261    24.102     0.150
    66.261   881.523     0.150
    66.571   642.922     0.150
    66.743   645.000     0.150
    68.024   651.922     0.150
    68.170   654.922     0.150
    68.451   656.234     0.150
    68.451   656.289     0.150
    68.451   655.922     0.150
    68.451   656.125     0.150
    68.451   656