#!/bin/bash
gmt begin sapporo1.54_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-41/41/-41/41
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation sapporo1.54'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     9.320     9.320
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.609    11.867
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.609    11.867 1
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -18.019    24.801
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -18.019    24.801 2
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.807     9.856
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.807     9.856 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.613    10.676
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.613    10.676 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.551    10.895
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.551    10.895 5
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.030     8.378
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.030     8.378 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.248     3.201
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.922    10.734
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.922    10.734 8
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.594     9.311
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.594     9.311 9
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.553     4.938
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.233     3.731
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.233     3.731 11
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.115     3.290
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.656    15.717
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -14.656    15.717 13
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.245    13.599
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.245    13.599 14
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.841     5.742
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.841     5.742 15
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.551     7.175
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.551     7.175 16
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.876     3.845
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.477     6.707
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.477     6.707 18
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.672     7.154
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.672     7.154 19
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.361     8.319
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.395     9.608
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.395     9.608 21
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.123    10.205
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.123    10.205 22
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.098    13.400
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.098    13.400 23
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.658     9.265
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.658     9.265 24
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.202     7.391
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.202     7.391 25
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.984     6.017
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.984     6.017 26
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.279    11.544
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -13.279    11.544 27
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.782    -3.604
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.774     2.526
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.835    10.426
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -13.835    10.426 30
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.341    16.519
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.341    16.519 31
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.952     8.348
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.952     8.348 32
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.136     8.143
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.136     8.143 33
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.129     7.370
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.809     2.889
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.317     7.318
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.511     6.567
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.523     6.184
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.523     6.184 38
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.633     6.516
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.369     9.432
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.369     9.432 40
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.327    13.988
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.327    13.988 41
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.474     5.627
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.550     2.219
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.155     7.409
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.155     7.409 44
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.600     5.322
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.600     5.322 45
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.298    10.910
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.298    10.910 46
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.406     9.915
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.406     9.915 47
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.168     5.805
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.668     7.011
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.668     7.011 49
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.405    -1.445
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.981    -0.348
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.025     6.557
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.025     6.557 52
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.119     3.446
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.823     7.849
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.823     7.849 54
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.165     7.657
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.082     5.872
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.082     5.872 56
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.443     4.649
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.443     4.649 57
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.040     5.717
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.270    10.034
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.270    10.034 59
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.033     7.491
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.033     7.491 60
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.406     6.406
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.931     2.752
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.533     8.732
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -14.533     8.732 63
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.032    -0.175
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.032    -0.175 64
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.068     5.118
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.818     7.060
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.818     7.060 66
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.363     2.388
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.494    13.067
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.494    13.067 68
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.924     3.177
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.179    13.670
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.179    13.670 70
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.422     5.593
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.343    15.746
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.343    15.746 72
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.836     3.935
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.868     9.921
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.868     9.921 74
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.555     4.036
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.912     5.854
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.576    12.469
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.576    12.469 77
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.913     3.283
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.161     6.009
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.161     6.009 79
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.293     7.436
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.978     8.182
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.269     5.260
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.169     8.854
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.169     8.854 83
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.364     8.824
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.662     5.225
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.661     9.806
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.661     9.806 86
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.622     7.196
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.222     6.443
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.337     5.249
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.303     6.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.870     6.995
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.611     8.937
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.611     8.937 92
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.280     6.064
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.300     6.375
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.309     6.495
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.614     5.871
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.800     1.306
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.711     5.790
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.556     2.422
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.828     4.251
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.231     4.447
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.001     3.001
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.872    10.222
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.872    10.222 103
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.762     5.419
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.193     5.166
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.315     9.627
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.315     9.627 106
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.132     3.946
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.305     5.233
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.159     1.003
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.187     2.701
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.435     2.902
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.362     0.741
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.064     1.846
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.644     3.092
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.647     1.349
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.394    -2.376
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.411    -5.416
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.276     0.831
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.978    -4.586
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.777     6.631
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.979    -0.489
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.264     1.560
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.205    -9.554
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.205    -9.554 123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.395    -5.205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.412    -0.022
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.996     1.616
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.753     1.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.063    -4.374
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.547     4.075
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.026    -4.773
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.907    -3.984
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.765    -1.865
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.067    -0.207
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.409    -4.093
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.461     2.549
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.263     3.765
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.697    -1.494
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.285    -5.473
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.945     2.582
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.267     6.570
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.118    -3.820
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.058    -1.298
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.024     1.078
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.782     7.422
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.771    -1.651
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.812    -4.605
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.194     0.268
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.477    -0.932
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.032     5.951
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.277    -1.654
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.401    -0.532
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.589     1.431
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.103     2.955
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.513    -1.963
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.503    -2.590
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.250    -2.863
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.925     3.026
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.760     4.760
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.830    -1.561
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.534     2.512
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.428    -3.924
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.758     4.184
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.649     4.409
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.961     0.673
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.207     3.945
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.246     3.595
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.653     0.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.988    -0.570
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.932    -0.703
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.777    -1.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.414    -1.568
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.254     2.904
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.279     4.286
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.613     0.990
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.374     6.877
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.374     6.877 175
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.392     8.789
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.657    -0.919
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.012    -1.025
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.585    -6.209
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.758    -0.135
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.453    -4.312
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.561     1.955
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.022     4.088
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.794     3.708
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.534     4.352
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.144    -2.284
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.284    -1.704
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.560    -3.437
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.103     6.772
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.954     4.908
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.254     3.908
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.172     0.314
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.370     5.297
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.993     0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.004     4.298
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.428     1.081
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.693    -2.820
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.414    -1.266
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.219    -2.087
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.732     1.268
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.465    -2.836
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.840     7.400
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.719    -2.212
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     5.808
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.488    -1.957
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.344    11.445
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.344    11.445 206
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.609     3.613
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.666     6.338
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.395     0.658
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.181    -0.384
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.048     0.920
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.116    -1.107
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.727    -2.992
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.875    -0.972
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.655     7.488
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.085     4.351
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.790     7.128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.351     7.237
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.591    -1.199
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.670     5.474
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.381    -1.339
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.078    -1.484
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.648     7.276
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.830    -6.666
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.288     1.244
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.641    -0.260
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.104     5.986
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.582    -1.234
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.432    -0.493
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.315     6.723
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.546    -0.411
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.152    10.959
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.152    10.959 232
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.071    -2.023
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.091     5.611
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.303    -6.702
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.162     0.698
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.612    -0.462
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.597     2.040
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.597     2.040 238
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.485     3.065
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.101    -0.497
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.322    -3.683
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.672     1.953
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.138    -2.635
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.380     2.552
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.221     2.172
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.794     3.678
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.134    -0.761
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.338   -13.258
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.338   -13.258 248
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.323    -2.323
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.410     0.256
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.763    -2.662
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.045    -0.529
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.491    -3.494
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.622    -1.514
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.192     3.394
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.539    -7.256
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.518    -6.087
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.176     5.032
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.026    -2.982
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.939    -3.499
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.826    -4.035
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.355    -3.530
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.713    -2.401
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.749     0.289
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.754    -1.223
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.336    -2.250
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.698     0.922
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.463     2.735
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.572     0.630
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.217    -3.103
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.560    -5.333
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.550    -8.790
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.761    -3.295
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.250     2.351
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.052    -0.355
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.580    -0.363
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.452    -1.956
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.197     0.105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.596    -4.856
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.493    -2.055
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.663    -6.066
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.663    -6.066 281
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.196    -4.060
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.226    -4.307
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.634    -0.734
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.322    -3.067
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.238    -5.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.140    -1.887
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.863    -1.640
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.091     2.085
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.057    -0.862
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.894    -0.152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.186     1.177
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.748    -6.491
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.538     3.399
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.872    -0.230
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.693    -3.824
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.616    -7.187
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.328    -3.074
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.328    -3.074 298
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.679    -0.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.528    -3.893
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.138    -2.108
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.064     2.137
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.763    -5.290
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.189     0.405
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.565     0.662
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.325    -1.524
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.425    -1.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.611    -3.139
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.364    -3.213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.936    -1.760
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.864    -1.884
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.492    -4.492
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.705    -3.076
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.974    -1.717
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.061    -0.160
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.586    -2.237
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.179    -7.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.169    -1.517
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.907    -3.228
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.199    -1.047
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.377    -4.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.841    -3.001
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.085    -1.123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.646    -2.740
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.305    -3.292
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.870    -4.298
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.157    -1.212
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.506    -3.917
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.194     3.054
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.208    -5.944
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.053    -7.489
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.565    -8.080
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.337    -0.709
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.121    -6.159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.971    -2.082
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.391    -0.537
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.111    -6.347
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.796    -0.544
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.150    -1.605
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.623    -4.198
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.291    -0.127
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.958    -0.103
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.393    -5.030
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.308    -2.461
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.595     3.706
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.248    -2.171
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.826    -2.879
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.879    -6.304
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.731    -1.731
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.967    -3.880
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.767    -3.417
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.545     1.678
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.107    -2.602
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.866    -2.967
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.943    -1.839
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.875    -0.100
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.484    -7.633
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.434    -3.537
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.696   -16.132
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.696   -16.132 359
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.359    -2.352
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.635    -6.021
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.635    -6.021 361
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.502    -3.571
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.689    -4.349
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.731    -3.167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.490    -3.992
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.480     5.569
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.111    -1.588
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.592    -8.188
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.339     0.292
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.379    -5.427
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.957     1.680
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.020     2.921
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.287     2.054
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.307     0.724
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.702    -3.575
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.880     1.186
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.098    -1.957
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.419    -1.190
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.145    -7.348
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.904    -5.708
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.973     0.920
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.559    -0.954
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.244     2.793
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.333    -5.334
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.635    -3.671
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.776    -2.390
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.466     3.717
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.159    -3.566
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.104     1.983
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.931     2.864
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.034    -4.145
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.831    -3.623
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.969     4.875
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.300    -0.782
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.379    -0.237
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.980    -3.049
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.057    -0.820
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.598     1.389
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.524    -0.370
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.597     1.687
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.820    -3.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.825    -2.288
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.599     8.564
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.596     1.833
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.287     0.546
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.838     1.629
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.588     1.989
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.089     0.566
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.972    -3.709
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.949     2.921
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.125     3.090
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.319     1.658
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.301     1.551
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.618    -0.113
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.944     6.036
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.456    -3.245
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.407     1.916
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.128     0.384
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.122     3.506
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.309     4.414
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.597    -3.542
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.424    11.631
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.424    11.631 422
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.693     6.927
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.693     6.927 423
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.075    11.766
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.075    11.766 424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.739    -0.165
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.313    -1.156
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.753     2.094
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.569     0.249
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.987     8.606
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -26.302    30.257
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -26.302    30.257 430
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -0.830     1.527     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -39.000    39.000 Author: all ( 430 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -39.000   -39.000 Average =   1.7 km at 331.5 deg; median =    4.7 km
EOF
gmt end
