#!/bin/bash
gmt begin sapporo1.54_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-17/23/0/72
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya50f10+lCounts -BWeSn+t'Focal Depth Mislocation sapporo1.54' << EOF
     0.400
    -9.000
     3.300
    -3.200
     3.700
     1.100
     8.600
    -0.600
    -3.200
     1.800
    -4.500
     4.900
    -8.900
    -4.100
     0.400
     5.200
     2.400
     2.400
     2.700
    -2.100
    -1.600
    -2.200
     1.900
    -0.300
     2.400
    -4.200
    -1.100
     4.700
     7.300
    -3.800
    -5.900
     0.700
     1.800
    -1.100
     7.000
    -3.200
    -2.600
    -2.000
    -0.100
     3.700
    -1.900
     2.700
     6.300
     0.500
     0.900
     0.300
     0.100
     1.300
     2.100
     9.300
     1.900
     0.700
    -0.800
     1.400
     1.000
     3.600
    -3.300
    10.100
    -0.900
    -2.600
     0.400
     4.600
     1.300
     4.000
     5.700
     0.400
     1.500
    -2.700
     3.800
    -0.200
     2.600
    -0.800
    -8.100
    -2.700
     2.300
    -0.500
    -0.100
     3.900
    -0.300
     0.900
    -0.600
     0.900
     4.600
    -3.400
     1.700
    -4.300
     1.200
     0.900
     0.600
     0.100
     0.400
     0.100
     8.400
    11.700
    -1.200
     6.000
     4.100
    -2.800
    -1.500
    -2.300
     1.400
    -4.900
   -11.900
    -3.500
     0.100
    -5.800
    -6.000
     4.200
     3.000
     2.800
    -1.400
     0.100
     0.300
     1.700
     1.800
    -0.100
     5.000
    -0.000
     8.000
     2.000
     3.000
     0.800
     5.000
    11.000
     7.000
    -7.500
     6.000
    -0.000
    -0.000
     5.000
    -2.900
    -0.500
     6.000
     6.000
     1.000
     1.000
    -1.100
    -0.100
    -0.600
    -5.000
    -5.000
    -3.700
     1.900
    -4.000
    -0.000
    -3.000
     1.000
    -1.500
    -3.000
    -4.300
     5.000
    -0.000
    -5.800
    -3.600
    -4.000
     0.100
    -8.100
    -3.300
     1.400
     3.700
     2.700
     8.700
    -3.400
     3.200
    -2.300
     6.300
     5.700
    -2.900
     4.900
     0.100
    -3.500
    -3.000
    -3.200
    -6.300
    -0.900
    -3.300
    -0.900
    -0.700
     3.100
    -2.700
    -5.900
    -1.700
     8.800
    -7.500
    -4.800
     2.700
    -1.900
     4.800
    -4.100
    -4.100
    -0.600
    -1.000
    -3.900
    -0.200
    -2.200
    -1.500
    -2.400
     4.200
     1.400
     0.600
     0.400
    -6.400
    -4.400
    -2.400
    -2.400
     0.800
     1.000
    -2.700
    -2.000
    -3.100
    -0.500
    -1.600
    -7.000
    -2.100
    -0.100
     3.400
    -6.700
    -5.900
     0.600
    -2.000
    -2.700
     2.500
     3.700
     1.100
    -0.000
     4.600
    -2.100
     3.600
     2.200
   -10.500
     2.900
    10.000
    -0.400
    -3.500
     1.800
    -2.700
     6.400
     4.400
     6.000
    -2.600
     0.300
     1.500
     0.200
    -2.700
    -2.700
    -5.500
    -1.400
     0.400
    13.800
     0.300
    -3.100
     1.900
    -0.400
    -1.300
    -2.300
     5.500
    -0.600
    -1.000
     6.600
    -0.200
    -1.900
    -1.500
    -3.400
    -1.900
     1.500
    -2.300
    -1.500
     6.100
    -1.800
    -0.400
    13.500
    -0.500
     0.500
    -2.600
     1.400
    -1.600
    -0.200
    -4.400
    -0.600
     2.200
     0.900
     0.100
    -1.200
    -0.000
    -1.900
     2.600
     1.000
     0.300
    -3.700
     2.200
     1.800
    -1.700
     1.100
     0.400
     1.300
     6.100
     1.200
    -5.600
    -3.600
    -0.100
    -1.400
    -2.200
     4.600
    -0.300
    10.900
     0.200
     2.400
     3.300
     4.400
    -2.800
     3.400
     6.200
     7.400
     2.100
     4.300
     5.600
     2.000
     2.000
     5.200
     5.800
     2.200
     1.000
     0.800
     2.000
     3.100
     2.100
     0.300
     1.800
     1.000
     2.700
     5.500
     9.700
     9.400
     9.000
    -0.000
     7.300
     7.000
     1.200
     4.500
     4.300
     5.100
     1.400
     2.500
     8.600
     2.200
     2.600
     8.600
    -1.000
     1.600
     5.400
     5.200
     0.900
     6.300
     3.500
     5.600
     1.700
     7.800
     4.000
     6.400
     8.600
    -7.000
    11.400
     6.400
     2.400
     8.600
     0.400
     3.300
    13.200
     2.000
    11.200
     2.900
    -1.200
     1.500
     3.800
     3.600
     2.600
     0.200
    -0.100
    -8.600
     1.400
     0.700
     3.900
    -1.800
    -0.900
     7.300
    -0.900
     3.800
    -0.100
    -1.300
    -0.000
     7.200
     3.500
     2.000
     2.400
     0.400
    -1.000
     0.500
    -4.100
     5.500
    -0.000
     5.000
     0.100
    -6.600
     1.200
    -0.400
     0.100
     1.900
     1.000
    -0.700
    -1.600
    -1.200
     2.300
    -2.600
    -0.300
    -0.300
    -1.000
    -4.300
     4.600
    -3.400
     6.200
    18.000
    14.700
     6.900
     5.500
     5.100
     5.400
     2.000
     2.000
    -8.800
    -2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     0.500    63.780 Median =   0.5 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  0.5  0.
  0.5  62.5
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -16.000    68.220 Author: all ( 430 samples)
EOF
gmt end
