#!/bin/bash
gmt begin sapporo1.54_dcal pdf,ps
proj=-JM16.0c+
reg=-R138.9/146.8/40.2/44.8
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration sapporo1.54'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
   143.320    42.292
   143.164    42.201
>
   143.320    42.292
   143.164    42.201
>
   143.320    42.292
   143.164    42.201
>
   143.320    42.292
   143.164    42.201
>
   143.320    42.292
   143.164    42.201
>
   143.320    42.292
   143.164    42.201
>
   142.782    42.158
   143.164    42.201
>
   142.782    42.158
   143.164    42.201
>
   142.782    42.158
   143.164    42.201
>
   142.782    42.158
   143.164    42.201
>
   142.782    42.158
   143.164    42.201
>
   143.217    42.920
   143.164    42.201
>
   143.217    42.920
   143.164    42.201
>
   143.217    42.920
   143.164    42.201
>
   143.320    42.292
   143.953    42.283
>
   143.320    42.292
   143.953    42.283
>
   143.320    42.292
   143.953    42.283
>
   143.217    42.920
   143.953    42.283
>
   143.217    42.920
   143.953    42.283
>
   144.392    42.975
   143.953    42.283
>
   144.392    42.975
   143.953    42.283
>
   144.392    42.975
   143.953    42.283
>
   144.392    42.975
   143.953    42.283
>
   142.782    42.158
   143.953    42.283
>
   142.782    42.158
   143.953    42.283
>
   142.782    42.158
   143.953    42.283
>
   143.320    42.292
   143.237    42.185
>
   143.320    42.292
   143.237    42.185
>
   142.782    42.158
   143.237    42.185
>
   142.782    42.158
   143.237    42.185
>
   143.217    42.920
   143.237    42.185
>
   143.320    42.292
   143.166    42.156
>
   143.320    42.292
   143.166    42.156
>
   143.217    42.920
   143.166    42.156
>
   143.320    42.292
   143.252    42.181
>
   142.782    42.158
   143.252    42.181
>
   143.217    42.920
   143.252    42.181
>
   143.217    42.920
   143.252    42.181
>
   143.320    42.292
   143.194    42.203
>
   143.320    42.292
   143.194    42.203
>
   142.782    42.158
   143.194    42.203
>
   142.782    42.158
   143.194    42.203
>
   143.217    42.920
   143.194    42.203
>
   143.217    42.920
   143.194    42.203
>
   142.782    42.158
   143.092    42.192
>
   142.782    42.158
   143.092    42.192
>
   143.320    42.292
   143.092    42.192
>
   143.320    42.292
   143.092    42.192
>
   143.217    42.920
   143.092    42.192
>
   143.217    42.920
   143.092    42.192
>
   143.320    42.292
   143.469    42.284
>
   143.320    42.292
   143.469    42.284
>
   142.967    42.239
   143.469    42.284
>
   142.782    42.158
   143.469    42.284
>
   144.392    42.975
   143.469    42.284
>
   144.392    42.975
   143.469    42.284
>
   142.782    42.158
   142.565    42.084
>
   142.782    42.158
   142.565    42.084
>
   142.967    42.239
   142.565    42.084
>
   143.320    42.292
   142.565    42.084
>
   143.320    42.292
   142.565    42.084
>
   143.217    42.920
   142.565    42.084
>
   143.217    42.920
   142.565    42.084
>
   142.782    42.158
   142.691    42.230
>
   142.967    42.239
   142.691    42.230
>
   143.320    42.292
   142.691    42.230
>
   143.320    42.292
   142.691    42.230
>
   143.217    42.920
   142.691    42.230
>
   143.217    42.920
   142.691    42.230
>
   142.782    42.158
   142.633    42.283
>
   142.967    42.239
   142.633    42.283
>
   142.967    42.239
   142.633    42.283
>
   143.320    42.292
   142.633    42.283
>
   143.320    42.292
   142.633    42.283
>
   143.217    42.920
   142.633    42.283
>
   143.217    42.920
   142.633    42.283
>
   143.320    42.292
   143.164    42.202
>
   143.320    42.292
   143.164    42.202
>
   142.967    42.239
   143.164    42.202
>
   142.782    42.158
   143.164    42.202
>
   142.782    42.158
   143.164    42.202
>
   143.217    42.920
   143.164    42.202
>
   143.217    42.920
   143.164    42.202
>
   142.967    42.239
   143.180    42.358
>
   143.320    42.292
   143.180    42.358
>
   143.320    42.292
   143.180    42.358
>
   142.782    42.158
   143.180    42.358
>
   142.782    42.158
   143.180    42.358
>
   143.217    42.920
   143.180    42.358
>
   143.217    42.920
   143.180    42.358
>
   143.320    42.292
   143.289    42.336
>
   143.320    42.292
   143.289    42.336
>
   142.967    42.239
   143.289    42.336
>
   142.782    42.158
   143.289    42.336
>
   142.782    42.158
   143.289    42.336
>
   143.217    42.920
   143.289    42.336
>
   143.217    42.920
   143.289    42.336
>
   143.320    42.292
   143.245    42.350
>
   143.320    42.292
   143.245    42.350
>
   143.217    42.920
   143.245    42.350
>
   143.217    42.920
   143.245    42.350
>
   143.320    42.292
   143.251    42.384
>
   143.320    42.292
   143.251    42.384
>
   142.967    42.239
   143.251    42.384
>
   142.782    42.158
   143.251    42.384
>
   142.782    42.158
   143.251    42.384
>
   143.217    42.920
   143.251    42.384
>
   143.217    42.920
   143.251    42.384
>
   143.320    42.292
   143.206    42.380
>
   143.320    42.292
   143.206    42.380
>
   142.967    42.239
   143.206    42.380
>
   142.782    42.158
   143.206    42.380
>
   142.782    42.158
   143.206    42.380
>
   143.217    42.920
   143.206    42.380
>
   143.217    42.920
   143.206    42.380
>
   143.320    42.292
   143.267    42.174
>
   143.320    42.292
   143.267    42.174
>
   142.967    42.239
   143.267    42.174
>
   142.782    42.158
   143.267    42.174
>
   142.782    42.158
   143.267    42.174
>
   143.217    42.920
   143.267    42.174
>
   142.967    42.239
   143.152    42.199
>
   143.320    42.292
   143.152    42.199
>
   143.320    42.292
   143.152    42.199
>
   142.782    42.158
   143.152    42.199
>
   142.782    42.158
   143.152    42.199
>
   143.217    42.920
   143.152    42.199
>
   142.967    42.239
   143.096    42.178
>
   143.320    42.292
   143.096    42.178
>
   143.320    42.292
   143.096    42.178
>
   142.782    42.158
   143.096    42.178
>
   142.782    42.158
   143.096    42.178
>
   143.217    42.920
   143.096    42.178
>
   143.320    42.292
   143.215    42.198
>
   143.320    42.292
   143.215    42.198
>
   142.967    42.239
   143.215    42.198
>
   142.782    42.158
   143.215    42.198
>
   142.782    42.158
   143.215    42.198
>
   143.217    42.920
   143.215    42.198
>
   143.320    42.292
   143.229    42.201
>
   143.320    42.292
   143.229    42.201
>
   142.967    42.239
   143.229    42.201
>
   142.782    42.158
   143.229    42.201
>
   142.782    42.158
   143.229    42.201
>
   143.217    42.920
   143.229    42.201
>
   143.320    42.292
   143.258    42.181
>
   143.320    42.292
   143.258    42.181
>
   142.967    42.239
   143.258    42.181
>
   142.782    42.158
   143.258    42.181
>
   142.782    42.158
   143.258    42.181
>
   143.320    42.292
   143.268    42.366
>
   143.320    42.292
   143.268    42.366
>
   142.967    42.239
   143.268    42.366
>
   142.782    42.158
   143.268    42.366
>
   143.217    42.920
   143.268    42.366
>
   142.967    42.239
   143.161    42.190
>
   143.320    42.292
   143.161    42.190
>
   143.320    42.292
   143.161    42.190
>
   142.782    42.158
   143.161    42.190
>
   142.782    42.158
   143.161    42.190
>
   143.217    42.920
   143.161    42.190
>
   142.782    42.158
   142.750    42.297
>
   142.782    42.158
   142.750    42.297
>
   142.967    42.239
   142.750    42.297
>
   142.967    42.239
   142.750    42.297
>
   143.320    42.292
   142.750    42.297
>
   143.320    42.292
   142.750    42.297
>
   143.217    42.920
   142.750    42.297
>
   143.217    42.920
   142.750    42.297
>
   144.392    42.975
   144.228    42.511
>
   144.392    42.975
   144.228    42.511
>
   143.320    42.292
   144.228    42.511
>
   143.320    42.292
   144.228    42.511
>
   143.217    42.920
   144.228    42.511
>
   142.967    42.239
   144.228    42.511
>
   142.782    42.158
   142.729    42.188
>
   143.320    42.292
   142.729    42.188
>
   143.320    42.292
   142.729    42.188
>
   143.217    42.920
   142.729    42.188
>
   143.217    42.920
   142.729    42.188
>
   142.782    42.158
   142.628    42.167
>
   142.967    42.239
   142.628    42.167
>
   143.320    42.292
   142.628    42.167
>
   143.320    42.292
   142.628    42.167
>
   143.217    42.920
   142.628    42.167
>
   143.217    42.920
   142.628    42.167
>
   142.967    42.239
   143.139    42.194
>
   142.782    42.158
   143.139    42.194
>
   142.782    42.158
   143.139    42.194
>
   143.320    42.292
   143.139    42.194
>
   143.320    42.292
   143.139    42.194
>
   143.217    42.920
   143.139    42.194
>
   142.782    42.158
   142.689    42.312
>
   142.782    42.158
   142.689    42.312
>
   143.320    42.292
   142.689    42.312
>
   143.320    42.292
   142.689    42.312
>
   143.217    42.920
   142.689    42.312
>
   143.217    42.920
   142.689    42.312
>
   143.320    42.292
   143.287    42.185
>
   143.320    42.292
   143.287    42.185
>
   142.782    42.158
   143.287    42.185
>
   142.782    42.158
   143.287    42.185
>
   143.217    42.920
   143.287    42.185
>
   143.320    42.292
   143.237    42.166
>
   143.320    42.292
   143.237    42.166
>
   142.782    42.158
   143.237    42.166
>
   142.782    42.158
   143.237    42.166
>
   143.217    42.920
   143.237    42.166
>
   143.217    42.920
   143.237    42.166
>
   143.320    42.292
   143.157    42.168
>
   143.320    42.292
   143.157    42.168
>
   142.967    42.239
   143.157    42.168
>
   142.782    42.158
   143.157    42.168
>
   142.782    42.158
   143.157    42.168
>
   143.217    42.920
   143.157    42.168
>
   143.217    42.920
   143.157    42.168
>
   141.332    43.058
   141.928    42.541
>
   141.332    43.058
   141.928    42.541
>
   140.982    42.310
   141.928    42.541
>
   142.782    42.158
   141.928    42.541
>
   142.967    42.239
   143.153    42.189
>
   143.320    42.292
   143.153    42.189
>
   143.320    42.292
   143.153    42.189
>
   142.782    42.158
   143.153    42.189
>
   142.782    42.158
   143.153    42.189
>
   143.217    42.920
   143.153    42.189
>
   143.217    42.920
   143.153    42.189
>
   143.287    42.383
   143.243    42.190
>
   142.782    42.158
   143.243    42.190
>
   142.782    42.158
   143.243    42.190
>
   143.217    42.920
   143.243    42.190
>
   143.217    42.920
   143.243    42.190
>
   142.782    42.158
   142.637    42.131
>
   143.287    42.383
   142.637    42.131
>
   143.217    42.920
   142.637    42.131
>
   143.287    42.383
   143.218    42.209
>
   143.287    42.383
   143.218    42.209
>
   142.782    42.158
   143.218    42.209
>
   142.782    42.158
   143.218    42.209
>
   143.217    42.920
   143.218    42.209
>
   143.217    42.920
   143.218    42.209
>
   142.782    42.158
   142.652    42.083
>
   143.287    42.383
   142.652    42.083
>
   143.217    42.920
   142.652    42.083
>
   143.217    42.920
   142.652    42.083
>
   142.782    42.158
   142.569    42.128
>
   143.287    42.383
   142.569    42.128
>
   143.217    42.920
   142.569    42.128
>
   143.217    42.920
   142.569    42.128
>
   142.782    42.158
   142.686    42.212
>
   143.287    42.383
   142.686    42.212
>
   143.287    42.383
   142.686    42.212
>
   143.217    42.920
   142.686    42.212
>
   143.217    42.920
   142.686    42.212
>
   142.782    42.158
   142.682    42.233
>
   143.217    42.920
   142.682    42.233
>
   143.217    42.920
   142.682    42.233
>
   142.782    42.158
   142.616    42.160
>
   143.287    42.383
   142.616    42.160
>
   143.217    42.920
   142.616    42.160
>
   143.217    42.920
   142.616    42.160
>
   142.782    42.158
   142.685    42.129
>
   143.287    42.383
   142.685    42.129
>
   143.287    42.383
   142.685    42.129
>
   143.217    42.920
   142.685    42.129
>
   143.217    42.920
   142.685    42.129
>
   142.782    42.158
   142.691    42.188
>
   143.287    42.383
   142.691    42.188
>
   143.217    42.920
   142.691    42.188
>
   143.217    42.920
   142.691    42.188
>
   142.782    42.158
   142.739    42.165
>
   143.287    42.383
   142.739    42.165
>
   143.287    42.383
   142.739    42.165
>
   143.217    42.920
   142.739    42.165
>
   143.217    42.920
   142.739    42.165
>
   142.782    42.158
   142.573    42.189
>
   143.287    42.383
   142.573    42.189
>
   143.217    42.920
   142.573    42.189
>
   143.217    42.920
   142.573    42.189
>
   142.782    42.158
   142.680    42.177
>
   143.287    42.383
   142.680    42.177
>
   143.217    42.920
   142.680    42.177
>
   143.217    42.920
   142.680    42.177
>
   142.782    42.158
   142.485    42.251
>
   143.287    42.383
   142.485    42.251
>
   143.287    42.383
   142.485    42.251
>
   143.217    42.920
   142.485    42.251
>
   143.217    42.920
   142.485    42.251
>
   142.782    42.158
   142.733    42.156
>
   143.287    42.383
   142.733    42.156
>
   143.287    42.383
   142.733    42.156
>
   143.217    42.920
   142.733    42.156
>
   143.217    42.920
   142.733    42.156
>
   142.782    42.158
   142.456    42.139
>
   143.287    42.383
   142.456    42.139
>
   143.287    42.383
   142.456    42.139
>
   143.217    42.920
   142.456    42.139
>
   143.217    42.920
   142.456    42.139
>
   142.782    42.158
   142.534    42.211
>
   143.287    42.383
   142.534    42.211
>
   143.217    42.920
   142.534    42.211
>
   143.217    42.920
   142.534    42.211
>
   142.782    42.158
   142.643    42.214
>
   143.287    42.383
   142.643    42.214
>
   143.217    42.920
   142.643    42.214
>
   143.217    42.920
   142.643    42.214
>
   142.782    42.158
   142.511    42.190
>
   142.782    42.158
   142.511    42.190
>
   143.287    42.383
   142.511    42.190
>
   143.287    42.383
   142.511    42.190
>
   143.217    42.920
   142.511    42.190
>
   143.217    42.920
   142.511    42.190
>
   142.782    42.158
   142.537    42.138
>
   143.287    42.383
   142.537    42.138
>
   143.287    42.383
   142.537    42.138
>
   143.217    42.920
   142.537    42.138
>
   143.217    42.920
   142.537    42.138
>
   142.782    42.158
   142.563    42.204
>
   143.287    42.383
   142.563    42.204
>
   143.217    42.920
   142.563    42.204
>
   143.217    42.920
   142.563    42.204
>
   142.782    42.158
   142.425    42.187
>
   143.287    42.383
   142.425    42.187
>
   143.287    42.383
   142.425    42.187
>
   143.217    42.920
   142.425    42.187
>
   143.217    42.920
   142.425    42.187
>
   143.287    42.383
   143.219    42.158
>
   143.287    42.383
   143.219    42.158
>
   142.782    42.158
   143.219    42.158
>
   142.782    42.158
   143.219    42.158
>
   143.217    42.920
   143.219    42.158
>
   143.217    42.920
   143.219    42.158
>
   142.782    42.158
   142.635    42.282
>
   143.287    42.383
   142.635    42.282
>
   143.217    42.920
   142.635    42.282
>
   143.217    42.920
   142.635    42.282
>
   142.782    42.158
   142.693    42.297
>
   143.287    42.383
   142.693    42.297
>
   143.217    42.920
   142.693    42.297
>
   143.217    42.920
   142.693    42.297
>
   142.782    42.158
   142.753    42.140
>
   143.287    42.383
   142.753    42.140
>
   143.217    42.920
   142.753    42.140
>
   143.217    42.920
   142.753    42.140
>
   142.782    42.158
   142.806    42.125
>
   143.217    42.920
   142.806    42.125
>
   143.217    42.920
   142.806    42.125
>
   142.782    42.158
   142.709    42.298
>
   143.287    42.383
   142.709    42.298
>
   143.217    42.920
   142.709    42.298
>
   143.217    42.920
   142.709    42.298
>
   142.782    42.158
   143.278    42.174
>
   142.782    42.158
   143.278    42.174
>
   143.217    42.920
   143.278    42.174
>
   143.217    42.920
   143.278    42.174
>
   142.782    42.158
   142.862    42.195
>
   142.782    42.158
   142.862    42.195
>
   143.287    42.383
   142.862    42.195
>
   143.287    42.383
   142.862    42.195
>
   143.217    42.920
   142.862    42.195
>
   143.217    42.920
   142.862    42.195
>
   142.782    42.158
   142.488    42.193
>
   142.782    42.158
   142.488    42.193
>
   143.287    42.383
   142.488    42.193
>
   143.217    42.920
   142.488    42.193
>
   142.782    42.158
   142.851    42.171
>
   142.782    42.158
   142.851    42.171
>
   143.287    42.383
   142.851    42.171
>
   143.217    42.920
   142.851    42.171
>
   143.217    42.920
   142.851    42.171
>
   142.782    42.158
   142.804    42.230
>
   143.287    42.383
   142.804    42.230
>
   143.217    42.920
   142.804    42.230
>
   143.217    42.920
   142.804    42.230
>
   143.287    42.383
   143.101    42.309
>
   142.782    42.158
   143.101    42.309
>
   142.782    42.158
   143.101    42.309
>
   143.217    42.920
   143.101    42.309
>
   142.782    42.158
   142.629    42.208
>
   143.287    42.383
   142.629    42.208
>
   143.287    42.383
   142.629    42.208
>
   143.217    42.920
   142.629    42.208
>
   143.217    42.920
   142.629    42.208
>
   143.217    42.920
   143.566    42.536
>
   143.217    42.920
   143.566    42.536
>
   143.287    42.383
   143.566    42.536
>
   142.782    42.158
   143.566    42.536
>
   142.782    42.158
   143.566    42.536
>
   144.392    42.975
   143.566    42.536
>
   142.782    42.158
   142.490    42.282
>
   143.287    42.383
   142.490    42.282
>
   143.287    42.383
   142.490    42.282
>
   143.217    42.920
   142.490    42.282
>
   143.287    42.383
   143.189    42.204
>
   142.782    42.158
   143.189    42.204
>
   142.782    42.158
   143.189    42.204
>
   143.217    42.920
   143.189    42.204
>
   143.217    42.920
   143.189    42.204
>
   143.287    42.383
   143.204    42.351
>
   142.782    42.158
   143.204    42.351
>
   143.217    42.920
   143.204    42.351
>
   143.217    42.920
   143.204    42.351
>
   143.287    42.383
   143.205    42.394
>
   143.287    42.383
   143.205    42.394
>
   142.782    42.158
   143.205    42.394
>
   142.782    42.158
   143.205    42.394
>
   143.217    42.920
   143.205    42.394
>
   143.217    42.920
   143.205    42.394
>
   143.287    42.383
   143.156    42.180
>
   142.782    42.158
   143.156    42.180
>
   142.782    42.158
   143.156    42.180
>
   143.217    42.920
   143.156    42.180
>
   143.217    42.920
   143.156    42.180
>
   142.782    42.158
   142.552    42.139
>
   143.287    42.383
   142.552    42.139
>
   143.287    42.383
   142.552    42.139
>
   143.217    42.920
   142.552    42.139
>
   142.782    42.158
   142.430    42.224
>
   143.287    42.383
   142.430    42.224
>
   143.217    42.920
   142.430    42.224
>
   143.217    42.920
   142.430    42.224
>
   143.287    42.383
   143.177    42.176
>
   143.287    42.383
   143.177    42.176
>
   142.782    42.158
   143.177    42.176
>
   142.782    42.158
   143.177    42.176
>
   143.217    42.920
   143.177    42.176
>
   143.217    42.920
   143.177    42.176
>
   143.320    42.292
   143.192    42.187
>
   143.287    42.383
   143.192    42.187
>
   142.782    42.158
   143.192    42.187
>
   142.782    42.158
   143.192    42.187
>
   143.217    42.920
   143.192    42.187
>
   143.217    42.920
   143.192    42.187
>
   143.287    42.383
   143.249    42.201
>
   143.287    42.383
   143.249    42.201
>
   142.782    42.158
   143.249    42.201
>
   142.782    42.158
   143.249    42.201
>
   143.217    42.920
   143.249    42.201
>
   143.217    42.920
   143.249    42.201
>
   143.287    42.383
   143.135    42.180
>
   143.287    42.383
   143.135    42.180
>
   142.782    42.158
   143.135    42.180
>
   142.782    42.158
   143.135    42.180
>
   143.217    42.920
   143.135    42.180
>
   143.217    42.920
   143.135    42.180
>
   143.287    42.383
   143.067    42.196
>
   142.782    42.158
   143.067    42.196
>
   142.782    42.158
   143.067    42.196
>
   143.217    42.920
   143.067    42.196
>
   143.217    42.920
   143.067    42.196
>
   143.287    42.383
   143.191    42.189
>
   143.287    42.383
   143.191    42.189
>
   142.782    42.158
   143.191    42.189
>
   142.782    42.158
   143.191    42.189
>
   143.217    42.920
   143.191    42.189
>
   143.287    42.383
   143.140    42.195
>
   143.287    42.383
   143.140    42.195
>
   142.782    42.158
   143.140    42.195
>
   142.782    42.158
   143.140    42.195
>
   143.217    42.920
   143.140    42.195
>
   143.217    42.920
   143.140    42.195
>
   142.782    42.158
   142.449    42.145
>
   143.287    42.383
   142.449    42.145
>
   143.287    42.383
   142.449    42.145
>
   143.217    42.920
   142.449    42.145
>
   143.217    42.920
   142.449    42.145
>
   142.782    42.158
   142.667    42.140
>
   143.287    42.383
   142.667    42.140
>
   143.217    42.920
   142.667    42.140
>
   143.217    42.920
   142.667    42.140
>
   143.287    42.383
   143.131    42.212
>
   142.782    42.158
   143.131    42.212
>
   142.782    42.158
   143.131    42.212
>
   143.217    42.920
   143.131    42.212
>
   143.217    42.920
   143.131    42.212
>
   143.217    42.920
   142.948    42.656
>
   143.217    42.920
   142.948    42.656
>
   143.287    42.383
   142.948    42.656
>
   143.287    42.383
   142.948    42.656
>
   142.782    42.158
   142.664    42.196
>
   142.782    42.158
   142.664    42.196
>
   143.287    42.383
   142.664    42.196
>
   143.217    42.920
   142.664    42.196
>
   143.217    42.920
   142.664    42.196
>
   143.287    42.383
   143.152    42.196
>
   142.782    42.158
   143.152    42.196
>
   142.782    42.158
   143.152    42.196
>
   143.217    42.920
   143.152    42.196
>
   143.217    42.920
   143.152    42.196
>
   142.782    42.158
   142.837    42.173
>
   142.782    42.158
   142.837    42.173
>
   143.287    42.383
   142.837    42.173
>
   143.217    42.920
   142.837    42.173
>
   143.217    42.920
   142.837    42.173
>
   142.782    42.158
   142.894    42.154
>
   143.287    42.383
   142.894    42.154
>
   143.287    42.383
   142.894    42.154
>
   143.217    42.920
   142.894    42.154
>
   143.217    42.920
   142.894    42.154
>
   142.782    42.158
   143.069    42.189
>
   142.782    42.158
   143.069    42.189
>
   143.287    42.383
   143.069    42.189
>
   143.217    42.920
   143.069    42.189
>
   143.217    42.920
   143.069    42.189
>
   143.287    42.383
   143.766    42.473
>
   143.287    42.383
   143.766    42.473
>
   143.217    42.920
   143.766    42.473
>
   144.392    42.975
   143.766    42.473
>
   144.392    42.975
   143.766    42.473
>
   142.782    42.158
   143.766    42.473
>
   142.782    42.158
   143.766    42.473
>
   144.795    43.100
   143.766    42.473
>
   144.795    43.100
   143.766    42.473
>
   143.287    42.383
   143.177    42.351
>
   142.782    42.158
   143.177    42.351
>
   142.705    42.225
   143.177    42.351
>
   142.705    42.225
   143.177    42.351
>
   143.217    42.920
   143.177    42.351
>
   143.217    42.920
   143.177    42.351
>
   143.287    42.383
   143.101    42.203
>
   142.782    42.158
   143.101    42.203
>
   142.782    42.158
   143.101    42.203
>
   142.705    42.225
   143.101    42.203
>
   142.705    42.225
   143.101    42.203
>
   143.217    42.920
   143.101    42.203
>
   143.217    42.920
   143.101    42.203
>
   143.217    42.920
   142.539    42.766
>
   142.705    42.225
   142.539    42.766
>
   142.705    42.225
   142.539    42.766
>
   142.782    42.158
   142.539    42.766
>
   143.287    42.383
   142.539    42.766
>
   141.332    43.058
   142.539    42.766
>
   142.782    42.158
   143.094    42.198
>
   142.782    42.158
   143.094    42.198
>
   143.287    42.383
   143.094    42.198
>
   143.287    42.383
   143.094    42.198
>
   142.705    42.225
   143.094    42.198
>
   143.217    42.920
   143.094    42.198
>
   142.705    42.225
   142.843    42.304
>
   142.782    42.158
   142.843    42.304
>
   142.782    42.158
   142.843    42.304
>
   143.287    42.383
   142.843    42.304
>
   143.287    42.383
   142.843    42.304
>
   143.217    42.920
   142.843    42.304
>
   143.217    42.920
   142.843    42.304
>
   143.217    42.920
   142.630    42.717
>
   143.217    42.920
   142.630    42.717
>
   142.705    42.225
   142.630    42.717
>
   142.705    42.225
   142.630    42.717
>
   142.782    42.158
   142.630    42.717
>
   142.782    42.158
   142.630    42.717
>
   143.287    42.383
   142.630    42.717
>
   143.287    42.383
   142.630    42.717
>
   142.705    42.225
   142.623    42.383
>
   142.705    42.225
   142.623    42.383
>
   142.782    42.158
   142.623    42.383
>
   143.287    42.383
   142.623    42.383
>
   143.287    42.383
   142.623    42.383
>
   143.217    42.920
   142.623    42.383
>
   143.217    42.920
   142.623    42.383
>
   143.287    42.383
   143.195    42.200
>
   142.782    42.158
   143.195    42.200
>
   142.782    42.158
   143.195    42.200
>
   142.705    42.225
   143.195    42.200
>
   142.705    42.225
   143.195    42.200
>
   143.217    42.920
   143.195    42.200
>
   143.217    42.920
   143.195    42.200
>
   142.705    42.225
   142.091    42.675
>
   142.705    42.225
   142.091    42.675
>
   142.782    42.158
   142.091    42.675
>
   143.217    42.920
   142.091    42.675
>
   143.287    42.383
   142.091    42.675
>
   143.287    42.383
   143.087    42.312
>
   142.705    42.225
   143.087    42.312
>
   142.705    42.225
   143.087    42.312
>
   142.782    42.158
   143.087    42.312
>
   142.782    42.158
   143.087    42.312
>
   143.217    42.920
   143.087    42.312
>
   142.705    42.225
   142.058    42.395
>
   142.705    42.225
   142.058    42.395
>
   142.782    42.158
   142.058    42.395
>
   142.782    42.158
   142.058    42.395
>
   141.332    43.058
   142.058    42.395
>
   143.287    42.383
   142.058    42.395
>
   143.287    42.383
   142.058    42.395
>
   142.705    42.225
   142.507    42.230
>
   142.705    42.225
   142.507    42.230
>
   142.782    42.158
   142.507    42.230
>
   142.782    42.158
   142.507    42.230
>
   143.287    42.383
   142.507    42.230
>
   143.287    42.383
   142.507    42.230
>
   143.217    42.920
   142.507    42.230
>
   143.217    42.920
   142.507    42.230
>
   142.667    42.243
   142.583    42.261
>
   142.667    42.243
   142.583    42.261
>
   142.782    42.158
   142.583    42.261
>
   142.782    42.158
   142.583    42.261
>
   143.287    42.383
   142.583    42.261
>
   143.287    42.383
   142.583    42.261
>
   143.217    42.920
   142.583    42.261
>
   143.217    42.920
   142.583    42.261
>
   142.782    42.158
   142.824    42.347
>
   142.782    42.158
   142.824    42.347
>
   143.287    42.383
   142.824    42.347
>
   143.287    42.383
   142.824    42.347
>
   143.217    42.920
   142.824    42.347
>
   143.217    42.920
   142.824    42.347
>
   143.287    42.383
   143.160    42.193
>
   142.782    42.158
   143.160    42.193
>
   142.782    42.158
   143.160    42.193
>
   142.667    42.243
   143.160    42.193
>
   143.217    42.920
   143.160    42.193
>
   143.217    42.920
   143.160    42.193
>
   142.667    42.243
   142.669    42.222
>
   142.667    42.243
   142.669    42.222
>
   142.782    42.158
   142.669    42.222
>
   142.782    42.158
   142.669    42.222
>
   143.287    42.383
   142.669    42.222
>
   143.287    42.383
   142.669    42.222
>
   143.217    42.920
   142.669    42.222
>
   143.217    42.920
   142.669    42.222
>
   142.782    42.158
   142.951    42.161
>
   142.782    42.158
   142.951    42.161
>
   142.667    42.243
   142.951    42.161
>
   142.667    42.243
   142.951    42.161
>
   143.287    42.383
   142.951    42.161
>
   143.287    42.383
   142.951    42.161
>
   143.217    42.920
   142.951    42.161
>
   143.217    42.920
   142.951    42.161
>
   143.217    42.920
   143.337    42.728
>
   143.217    42.920
   143.337    42.728
>
   143.287    42.383
   143.337    42.728
>
   144.392    42.975
   143.337    42.728
>
   144.392    42.975
   143.337    42.728
>
   143.287    42.383
   143.220    42.232
>
   143.287    42.383
   143.220    42.232
>
   142.782    42.158
   143.220    42.232
>
   142.782    42.158
   143.220    42.232
>
   142.667    42.243
   143.220    42.232
>
   142.667    42.243
   143.220    42.232
>
   143.217    42.920
   143.220    42.232
>
   143.217    42.920
   143.220    42.232
>
   143.157    42.016
   143.040    42.247
>
   143.157    42.016
   143.040    42.247
>
   142.782    42.158
   143.040    42.247
>
   142.782    42.158
   143.040    42.247
>
   142.667    42.243
   143.040    42.247
>
   142.667    42.243
   143.040    42.247
>
   143.362    42.614
   143.040    42.247
>
   143.217    42.920
   143.040    42.247
>
   143.217    42.920
   143.040    42.247
>
   142.134    42.590
   143.040    42.247
>
   143.835    42.903
   143.040    42.247
>
   142.594    43.164
   143.040    42.247
>
   142.667    42.243
   142.581    42.289
>
   142.667    42.243
   142.581    42.289
>
   143.157    42.016
   142.581    42.289
>
   143.157    42.016
   142.581    42.289
>
   142.134    42.590
   142.581    42.289
>
   142.134    42.590
   142.581    42.289
>
   143.362    42.614
   142.581    42.289
>
   143.362    42.614
   142.581    42.289
>
   142.594    43.164
   142.581    42.289
>
   142.594    43.164
   142.528    42.853
>
   142.134    42.590
   142.528    42.853
>
   142.134    42.590
   142.528    42.853
>
   142.667    42.243
   142.528    42.853
>
   142.667    42.243
   142.528    42.853
>
   143.362    42.614
   142.528    42.853
>
   143.362    42.614
   142.528    42.853
>
   142.223    43.505
   142.528    42.853
>
   141.450    42.840
   142.528    42.853
>
   141.450    42.840
   142.528    42.853
>
   143.835    42.903
   142.528    42.853
>
   143.835    42.903
   142.528    42.853
>
   143.157    42.016
   142.528    42.853
>
   142.847    43.812
   142.528    42.853
>
   142.667    42.243
   142.784    42.641
>
   142.667    42.243
   142.784    42.641
>
   143.362    42.614
   142.784    42.641
>
   143.362    42.614
   142.784    42.641
>
   142.134    42.590
   142.784    42.641
>
   142.134    42.590
   142.784    42.641
>
   142.594    43.164
   142.784    42.641
>
   143.157    42.016
   142.784    42.641
>
   143.835    42.903
   142.784    42.641
>
   143.835    42.903
   142.784    42.641
>
   143.770    43.297
   142.784    42.641
>
   143.770    43.297
   142.784    42.641
>
   142.223    43.505
   142.784    42.641
>
   142.223    43.505
   142.784    42.641
>
   143.362    42.614
   143.752    42.370
>
   143.835    42.903
   143.752    42.370
>
   143.835    42.903
   143.752    42.370
>
   142.667    42.243
   143.752    42.370
>
   142.667    42.243
   143.752    42.370
>
   143.770    43.297
   143.752    42.370
>
   143.770    43.297
   143.752    42.370
>
   144.697    42.996
   143.752    42.370
>
   142.134    42.590
   141.944    42.497
>
   141.450    42.840
   141.944    42.497
>
   142.667    42.243
   141.944    42.497
>
   141.038    42.469
   141.944    42.497
>
   141.038    42.469
   141.944    42.497
>
   142.594    43.164
   141.944    42.497
>
   141.033    41.888
   141.944    42.497
>
   141.033    41.888
   141.944    42.497
>
   142.134    42.590
   141.947    42.495
>
   141.450    42.840
   141.947    42.495
>
   141.450    42.840
   141.947    42.495
>
   142.667    42.243
   141.947    42.495
>
   141.038    42.469
   141.947    42.495
>
   141.038    42.469
   141.947    42.495
>
   142.594    43.164
   141.947    42.495
>
   141.033    41.888
   141.947    42.495
>
   141.033    41.888
   141.947    42.495
>
   142.134    42.590
   142.334    42.766
>
   142.134    42.590
   142.334    42.766
>
   142.594    43.164
   142.334    42.766
>
   142.594    43.164
   142.334    42.766
>
   141.450    42.840
   142.334    42.766
>
   141.450    42.840
   142.334    42.766
>
   142.223    43.505
   142.334    42.766
>
   142.223    43.505
   142.334    42.766
>
   142.667    42.243
   142.693    42.237
>
   142.667    42.243
   142.693    42.237
>
   143.157    42.016
   142.693    42.237
>
   142.134    42.590
   142.693    42.237
>
   143.362    42.614
   142.693    42.237
>
   143.362    42.614
   142.693    42.237
>
   142.594    43.164
   142.693    42.237
>
   142.594    43.164
   142.693    42.237
>
   143.362    42.614
   143.105    42.470
>
   143.362    42.614
   143.105    42.470
>
   142.667    42.243
   143.105    42.470
>
   142.667    42.243
   143.105    42.470
>
   143.157    42.016
   143.105    42.470
>
   143.157    42.016
   143.105    42.470
>
   143.835    42.903
   143.105    42.470
>
   143.835    42.903
   143.105    42.470
>
   142.134    42.590
   143.105    42.470
>
   142.594    43.164
   143.105    42.470
>
   143.770    43.297
   143.105    42.470
>
   143.770    43.297
   143.105    42.470
>
   142.134    42.590
   142.548    42.269
>
   143.362    42.614
   142.548    42.269
>
   143.362    42.614
   142.548    42.269
>
   142.594    43.164
   142.548    42.269
>
   141.450    42.840
   142.548    42.269
>
   143.157    42.016
   143.189    42.286
>
   143.157    42.016
   143.189    42.286
>
   143.362    42.614
   143.189    42.286
>
   143.362    42.614
   143.189    42.286
>
   142.667    42.243
   143.189    42.286
>
   143.835    42.903
   143.189    42.286
>
   143.835    42.903
   143.189    42.286
>
   142.134    42.590
   143.189    42.286
>
   142.594    43.164
   143.189    42.286
>
   142.667    42.243
   142.582    42.349
>
   142.667    42.243
   142.582    42.349
>
   143.157    42.016
   142.582    42.349
>
   143.362    42.614
   142.582    42.349
>
   143.362    42.614
   142.582    42.349
>
   142.594    43.164
   142.582    42.349
>
   141.450    42.840
   142.582    42.349
>
   141.450    42.840
   142.582    42.349
>
   143.157    42.016
   143.151    42.283
>
   143.157    42.016
   143.151    42.283
>
   143.362    42.614
   143.151    42.283
>
   143.362    42.614
   143.151    42.283
>
   142.667    42.243
   143.151    42.283
>
   142.667    42.243
   143.151    42.283
>
   142.134    42.590
   143.151    42.283
>
   143.835    42.903
   143.151    42.283
>
   143.835    42.903
   143.151    42.283
>
   142.594    43.164
   143.151    42.283
>
   142.667    42.243
   142.385    42.403
>
   142.667    42.243
   142.385    42.403
>
   142.134    42.590
   142.385    42.403
>
   142.134    42.590
   142.385    42.403
>
   143.157    42.016
   142.385    42.403
>
   143.157    42.016
   142.385    42.403
>
   143.362    42.614
   142.385    42.403
>
   143.362    42.614
   142.385    42.403
>
   142.594    43.164
   142.385    42.403
>
   141.450    42.840
   142.385    42.403
>
   141.038    42.469
   142.385    42.403
>
   141.038    42.469
   142.385    42.403
>
   143.157    42.016
   143.084    42.242
>
   143.157    42.016
   143.084    42.242
>
   142.667    42.243
   143.084    42.242
>
   142.667    42.243
   143.084    42.242
>
   143.362    42.614
   143.084    42.242
>
   143.835    42.903
   143.084    42.242
>
   143.157    42.016
   143.067    42.244
>
   143.157    42.016
   143.067    42.244
>
   142.667    42.243
   143.067    42.244
>
   142.667    42.243
   143.067    42.244
>
   143.362    42.614
   143.067    42.244
>
   143.362    42.614
   143.067    42.244
>
   142.134    42.590
   143.067    42.244
>
   143.835    42.903
   143.067    42.244
>
   143.835    42.903
   143.067    42.244
>
   142.594    43.164
   143.067    42.244
>
   142.134    42.590
   142.447    42.472
>
   142.134    42.590
   142.447    42.472
>
   142.667    42.243
   142.447    42.472
>
   142.667    42.243
   142.447    42.472
>
   143.362    42.614
   142.447    42.472
>
   143.157    42.016
   142.447    42.472
>
   143.157    42.016
   142.447    42.472
>
   142.594    43.164
   142.447    42.472
>
   142.594    43.164
   142.447    42.472
>
   141.450    42.840
   142.447    42.472
>
   142.667    42.243
   142.733    42.387
>
   142.667    42.243
   142.733    42.387
>
   143.157    42.016
   142.733    42.387
>
   143.157    42.016
   142.733    42.387
>
   142.134    42.590
   142.733    42.387
>
   142.134    42.590
   142.733    42.387
>
   143.362    42.614
   142.733    42.387
>
   143.362    42.614
   142.733    42.387
>
   142.594    43.164
   142.733    42.387
>
   143.835    42.903
   142.733    42.387
>
   143.835    42.903
   142.733    42.387
>
   143.835    42.903
   143.960    42.547
>
   143.835    42.903
   143.960    42.547
>
   143.362    42.614
   143.960    42.547
>
   143.362    42.614
   143.960    42.547
>
   144.697    42.996
   143.960    42.547
>
   143.770    43.297
   143.960    42.547
>
   143.770    43.297
   143.960    42.547
>
   143.157    42.016
   143.960    42.547
>
   143.157    42.016
   143.960    42.547
>
   143.362    42.614
   143.677    42.406
>
   143.835    42.903
   143.677    42.406
>
   143.835    42.903
   143.677    42.406
>
   143.157    42.016
   143.677    42.406
>
   143.157    42.016
   143.677    42.406
>
   142.667    42.243
   143.677    42.406
>
   142.667    42.243
   143.677    42.406
>
   143.770    43.297
   143.677    42.406
>
   143.770    43.297
   143.677    42.406
>
   144.697    42.996
   143.677    42.406
>
   143.157    42.016
   143.088    42.246
>
   143.157    42.016
   143.088    42.246
>
   142.667    42.243
   143.088    42.246
>
   142.667    42.243
   143.088    42.246
>
   143.362    42.614
   143.088    42.246
>
   143.835    42.903
   143.088    42.246
>
   142.594    43.164
   143.088    42.246
>
   143.362    42.614
   143.439    42.805
>
   143.362    42.614
   143.439    42.805
>
   143.835    42.903
   143.439    42.805
>
   142.667    42.243
   143.439    42.805
>
   142.667    42.243
   142.988    42.239
>
   143.157    42.016
   142.988    42.239
>
   143.157    42.016
   142.988    42.239
>
   143.362    42.614
   142.988    42.239
>
   143.835    42.903
   142.988    42.239
>
   143.362    42.614
   143.462    42.391
>
   143.157    42.016
   143.462    42.391
>
   143.157    42.016
   143.462    42.391
>
   143.835    42.903
   143.462    42.391
>
   143.835    42.903
   143.462    42.391
>
   142.667    42.243
   143.462    42.391
>
   142.667    42.243
   143.462    42.391
>
   143.770    43.297
   143.462    42.391
>
   143.770    43.297
   143.462    42.391
>
   142.594    43.164
   142.635    42.775
>
   142.667    42.243
   142.635    42.775
>
   142.667    42.243
   142.635    42.775
>
   143.362    42.614
   142.635    42.775
>
   143.362    42.614
   142.635    42.775
>
   142.223    43.505
   142.635    42.775
>
   141.450    42.840
   142.635    42.775
>
   141.450    42.840
   142.635    42.775
>
   143.835    42.903
   142.635    42.775
>
   143.835    42.903
   142.635    42.775
>
   143.770    43.297
   142.635    42.775
>
   143.770    43.297
   142.635    42.775
>
   143.157    42.016
   143.217    42.259
>
   143.157    42.016
   143.217    42.259
>
   143.362    42.614
   143.217    42.259
>
   142.667    42.243
   143.217    42.259
>
   142.667    42.243
   143.217    42.259
>
   143.835    42.903
   143.217    42.259
>
   142.667    42.243
   142.525    42.467
>
   142.667    42.243
   142.525    42.467
>
   143.362    42.614
   142.525    42.467
>
   143.362    42.614
   142.525    42.467
>
   143.157    42.016
   142.525    42.467
>
   142.594    43.164
   142.525    42.467
>
   142.594    43.164
   142.525    42.467
>
   141.450    42.840
   142.525    42.467
>
   141.450    42.840
   142.525    42.467
>
   143.157    42.016
   143.156    42.273
>
   143.157    42.016
   143.156    42.273
>
   143.362    42.614
   143.156    42.273
>
   143.362    42.614
   143.156    42.273
>
   142.667    42.243
   143.156    42.273
>
   143.835    42.903
   143.156    42.273
>
   143.835    42.903
   143.156    42.273
>
   142.594    43.164
   143.156    42.273
>
   143.362    42.614
   143.262    42.785
>
   143.362    42.614
   143.262    42.785
>
   143.835    42.903
   143.262    42.785
>
   143.835    42.903
   143.262    42.785
>
   142.594    43.164
   143.262    42.785
>
   143.770    43.297
   143.262    42.785
>
   143.770    43.297
   143.262    42.785
>
   142.667    42.243
   143.262    42.785
>
   142.667    42.243
   143.262    42.785
>
   143.157    42.016
   143.262    42.785
>
   142.594    43.164
   142.430    42.811
>
   142.667    42.243
   142.430    42.811
>
   142.667    42.243
   142.430    42.811
>
   143.362    42.614
   142.430    42.811
>
   143.362    42.614
   142.430    42.811
>
   141.450    42.840
   142.430    42.811
>
   141.450    42.840
   142.430    42.811
>
   142.223    43.505
   142.430    42.811
>
   142.223    43.505
   142.430    42.811
>
   143.157    42.016
   142.430    42.811
>
   143.157    42.016
   142.430    42.811
>
   142.667    42.243
   142.892    42.178
>
   142.667    42.243
   142.892    42.178
>
   143.157    42.016
   142.892    42.178
>
   143.157    42.016
   142.892    42.178
>
   143.362    42.614
   142.892    42.178
>
   143.362    42.614
   142.892    42.178
>
   142.667    42.243
   142.730    42.175
>
   142.667    42.243
   142.730    42.175
>
   143.157    42.016
   142.730    42.175
>
   143.157    42.016
   142.730    42.175
>
   143.362    42.614
   142.730    42.175
>
   143.362    42.614
   142.730    42.175
>
   142.594    43.164
   142.730    42.175
>
   143.362    42.614
   143.587    42.456
>
   143.362    42.614
   143.587    42.456
>
   143.835    42.903
   143.587    42.456
>
   143.835    42.903
   143.587    42.456
>
   143.157    42.016
   143.587    42.456
>
   142.667    42.243
   143.587    42.456
>
   142.667    42.243
   143.587    42.456
>
   143.770    43.297
   143.587    42.456
>
   143.770    43.297
   143.587    42.456
>
   144.697    42.996
   143.587    42.456
>
   144.697    42.996
   143.587    42.456
>
   142.667    42.243
   142.726    42.177
>
   142.667    42.243
   142.726    42.177
>
   143.157    42.016
   142.726    42.177
>
   143.362    42.614
   142.726    42.177
>
   143.362    42.614
   142.726    42.177
>
   143.362    42.614
   142.855    42.625
>
   143.362    42.614
   142.855    42.625
>
   142.667    42.243
   142.855    42.625
>
   142.667    42.243
   142.855    42.625
>
   142.594    43.164
   142.855    42.625
>
   143.157    42.016
   142.855    42.625
>
   143.157    42.016
   142.855    42.625
>
   143.835    42.903
   142.855    42.625
>
   143.835    42.903
   142.855    42.625
>
   143.770    43.297
   142.855    42.625
>
   143.770    43.297
   142.855    42.625
>
   142.223    43.505
   142.855    42.625
>
   143.362    42.614
   143.548    42.589
>
   143.362    42.614
   143.548    42.589
>
   143.835    42.903
   143.548    42.589
>
   143.835    42.903
   143.548    42.589
>
   143.770    43.297
   143.548    42.589
>
   143.770    43.297
   143.548    42.589
>
   142.667    42.243
   143.548    42.589
>
   142.667    42.243
   143.548    42.589
>
   142.364    42.778
   143.548    42.589
>
   142.364    42.778
   143.548    42.589
>
   142.594    43.164
   143.548    42.589
>
   144.697    42.996
   143.548    42.589
>
   144.697    42.996
   143.548    42.589
>
   143.362    42.614
   143.100    42.325
>
   143.362    42.614
   143.100    42.325
>
   143.157    42.016
   143.100    42.325
>
   143.157    42.016
   143.100    42.325
>
   142.667    42.243
   143.100    42.325
>
   142.667    42.243
   143.100    42.325
>
   142.364    42.778
   143.100    42.325
>
   142.364    42.778
   143.100    42.325
>
   143.835    42.903
   143.100    42.325
>
   143.835    42.903
   143.100    42.325
>
   142.594    43.164
   143.100    42.325
>
   143.157    42.016
   143.119    42.322
>
   143.157    42.016
   143.119    42.322
>
   143.362    42.614
   143.119    42.322
>
   143.362    42.614
   143.119    42.322
>
   142.667    42.243
   143.119    42.322
>
   142.667    42.243
   143.119    42.322
>
   142.364    42.778
   143.119    42.322
>
   142.364    42.778
   143.119    42.322
>
   143.835    42.903
   143.119    42.322
>
   143.835    42.903
   143.119    42.322
>
   142.594    43.164
   143.119    42.322
>
   143.362    42.614
   143.077    42.500
>
   142.667    42.243
   143.077    42.500
>
   142.667    42.243
   143.077    42.500
>
   142.364    42.778
   143.077    42.500
>
   142.364    42.778
   143.077    42.500
>
   143.835    42.903
   143.077    42.500
>
   143.835    42.903
   143.077    42.500
>
   142.594    43.164
   143.077    42.500
>
   143.770    43.297
   143.077    42.500
>
   143.770    43.297
   143.077    42.500
>
   143.362    42.614
   143.401    42.745
>
   143.362    42.614
   143.401    42.745
>
   143.835    42.903
   143.401    42.745
>
   143.835    42.903
   143.401    42.745
>
   143.770    43.297
   143.401    42.745
>
   143.770    43.297
   143.401    42.745
>
   142.667    42.243
   143.401    42.745
>
   142.667    42.243
   143.401    42.745
>
   143.157    42.016
   143.401    42.745
>
   142.594    43.164
   143.401    42.745
>
   144.697    42.996
   143.401    42.745
>
   144.697    42.996
   143.401    42.745
>
   143.157    42.016
   143.104    42.297
>
   143.157    42.016
   143.104    42.297
>
   143.362    42.614
   143.104    42.297
>
   143.362    42.614
   143.104    42.297
>
   142.667    42.243
   143.104    42.297
>
   143.835    42.903
   143.104    42.297
>
   143.835    42.903
   143.104    42.297
>
   142.594    43.164
   143.104    42.297
>
   142.667    42.243
   143.100    42.322
>
   143.362    42.614
   143.100    42.322
>
   143.362    42.614
   143.100    42.322
>
   143.157    42.016
   143.100    42.322
>
   143.157    42.016
   143.100    42.322
>
   142.364    42.778
   143.100    42.322
>
   142.364    42.778
   143.100    42.322
>
   143.835    42.903
   143.100    42.322
>
   143.835    42.903
   143.100    42.322
>
   142.594    43.164
   143.100    42.322
>
   143.157    42.016
   143.054    42.291
>
   143.157    42.016
   143.054    42.291
>
   142.667    42.243
   143.054    42.291
>
   143.362    42.614
   143.054    42.291
>
   143.362    42.614
   143.054    42.291
>
   142.364    42.778
   143.054    42.291
>
   142.364    42.778
   143.054    42.291
>
   143.835    42.903
   143.054    42.291
>
   142.594    43.164
   143.054    42.291
>
   143.835    42.903
   144.103    42.638
>
   143.835    42.903
   144.103    42.638
>
   143.362    42.614
   144.103    42.638
>
   143.362    42.614
   144.103    42.638
>
   144.697    42.996
   144.103    42.638
>
   144.697    42.996
   144.103    42.638
>
   143.770    43.297
   144.103    42.638
>
   143.362    42.614
   143.564    42.586
>
   143.362    42.614
   143.564    42.586
>
   143.835    42.903
   143.564    42.586
>
   143.835    42.903
   143.564    42.586
>
   142.667    42.243
   143.564    42.586
>
   142.667    42.243
   143.564    42.586
>
   143.770    43.297
   143.564    42.586
>
   143.770    43.297
   143.564    42.586
>
   142.364    42.778
   143.564    42.586
>
   144.697    42.996
   143.564    42.586
>
   144.697    42.996
   143.564    42.586
>
   142.594    43.164
   143.564    42.586
>
   142.667    42.243
   142.576    42.163
>
   143.157    42.016
   142.576    42.163
>
   142.364    42.778
   142.576    42.163
>
   143.362    42.614
   142.576    42.163
>
   143.362    42.614
   142.576    42.163
>
   142.667    42.243
   142.974    42.296
>
   142.667    42.243
   142.974    42.296
>
   143.157    42.016
   142.974    42.296
>
   143.362    42.614
   142.974    42.296
>
   143.362    42.614
   142.974    42.296
>
   142.364    42.778
   142.974    42.296
>
   142.364    42.778
   142.974    42.296
>
   142.594    43.164
   142.974    42.296
>
   143.835    42.903
   142.974    42.296
>
   143.835    42.903
   142.974    42.296
>
   143.362    42.614
   143.439    42.449
>
   143.362    42.614
   143.439    42.449
>
   143.157    42.016
   143.439    42.449
>
   143.157    42.016
   143.439    42.449
>
   143.835    42.903
   143.439    42.449
>
   143.835    42.903
   143.439    42.449
>
   142.667    42.243
   143.439    42.449
>
   142.667    42.243
   143.439    42.449
>
   142.364    42.778
   143.439    42.449
>
   142.364    42.778
   143.439    42.449
>
   143.770    43.297
   143.439    42.449
>
   143.770    43.297
   143.439    42.449
>
   142.594    43.164
   143.439    42.449
>
   143.157    42.016
   143.115    42.300
>
   143.157    42.016
   143.115    42.300
>
   143.362    42.614
   143.115    42.300
>
   143.362    42.614
   143.115    42.300
>
   142.667    42.243
   143.115    42.300
>
   142.364    42.778
   143.115    42.300
>
   142.364    42.778
   143.115    42.300
>
   143.835    42.903
   143.115    42.300
>
   143.835    42.903
   143.115    42.300
>
   142.594    43.164
   143.115    42.300
>
   142.667    42.243
   142.549    42.432
>
   142.364    42.778
   142.549    42.432
>
   142.364    42.778
   142.549    42.432
>
   143.362    42.614
   142.549    42.432
>
   143.362    42.614
   142.549    42.432
>
   143.157    42.016
   142.549    42.432
>
   142.594    43.164
   142.549    42.432
>
   142.594    43.164
   142.549    42.432
>
   141.450    42.840
   142.549    42.432
>
   141.450    42.840
   142.549    42.432
>
   142.667    42.243
   142.474    42.207
>
   142.667    42.243
   142.474    42.207
>
   143.157    42.016
   142.474    42.207
>
   143.157    42.016
   142.474    42.207
>
   142.364    42.778
   142.474    42.207
>
   142.364    42.778
   142.474    42.207
>
   143.362    42.614
   142.474    42.207
>
   143.362    42.614
   142.474    42.207
>
   142.594    43.164
   142.474    42.207
>
   141.450    42.840
   142.474    42.207
>
   141.450    42.840
   142.474    42.207
>
   142.753    42.280
   143.063    42.273
>
   142.753    42.280
   143.063    42.273
>
   143.157    42.016
   143.063    42.273
>
   143.157    42.016
   143.063    42.273
>
   143.157    42.015
   143.063    42.273
>
   143.362    42.614
   143.063    42.273
>
   143.362    42.614
   143.063    42.273
>
   142.364    42.778
   143.063    42.273
>
   142.364    42.778
   143.063    42.273
>
   143.835    42.903
   143.063    42.273
>
   143.835    42.903
   143.063    42.273
>
   142.594    43.164
   143.063    42.273
>
   142.753    42.280
   142.971    42.288
>
   142.753    42.280
   142.971    42.288
>
   143.157    42.016
   142.971    42.288
>
   143.157    42.016
   142.971    42.288
>
   143.362    42.614
   142.971    42.288
>
   143.362    42.614
   142.971    42.288
>
   142.364    42.778
   142.971    42.288
>
   142.364    42.778
   142.971    42.288
>
   143.835    42.903
   142.971    42.288
>
   143.835    42.903
   142.971    42.288
>
   142.594    43.164
   142.971    42.288
>
   143.157    42.016
   143.181    42.293
>
   143.157    42.016
   143.181    42.293
>
   142.753    42.280
   143.181    42.293
>
   142.753    42.280
   143.181    42.293
>
   143.362    42.614
   143.181    42.293
>
   143.362    42.614
   143.181    42.293
>
   143.835    42.903
   143.181    42.293
>
   143.835    42.903
   143.181    42.293
>
   142.364    42.778
   143.181    42.293
>
   142.594    43.164
   143.181    42.293
>
   143.362    42.614
   143.518    42.388
>
   143.362    42.614
   143.518    42.388
>
   143.157    42.016
   143.518    42.388
>
   142.753    42.280
   143.518    42.388
>
   142.753    42.280
   143.518    42.388
>
   143.835    42.903
   143.518    42.388
>
   143.835    42.903
   143.518    42.388
>
   142.364    42.778
   143.518    42.388
>
   142.364    42.778
   143.518    42.388
>
   143.770    43.297
   143.518    42.388
>
   143.770    43.297
   143.518    42.388
>
   142.753    42.280
   143.047    42.306
>
   142.753    42.280
   143.047    42.306
>
   143.157    42.016
   143.047    42.306
>
   143.362    42.614
   143.047    42.306
>
   143.362    42.614
   143.047    42.306
>
   142.364    42.778
   143.047    42.306
>
   142.364    42.778
   143.047    42.306
>
   143.835    42.903
   143.047    42.306
>
   143.835    42.903
   143.047    42.306
>
   142.594    43.164
   143.047    42.306
>
   142.753    42.280
   143.114    42.325
>
   142.753    42.280
   143.114    42.325
>
   143.362    42.614
   143.114    42.325
>
   143.362    42.614
   143.114    42.325
>
   143.157    42.016
   143.114    42.325
>
   143.157    42.016
   143.114    42.325
>
   142.364    42.778
   143.114    42.325
>
   142.364    42.778
   143.114    42.325
>
   143.835    42.903
   143.114    42.325
>
   143.835    42.903
   143.114    42.325
>
   142.594    43.164
   143.114    42.325
>
   143.362    42.614
   143.564    42.556
>
   143.362    42.614
   143.564    42.556
>
   143.835    42.903
   143.564    42.556
>
   143.835    42.903
   143.564    42.556
>
   143.157    42.016
   143.564    42.556
>
   142.753    42.280
   143.564    42.556
>
   142.753    42.280
   143.564    42.556
>
   143.770    43.297
   143.564    42.556
>
   143.770    43.297
   143.564    42.556
>
   142.364    42.778
   143.564    42.556
>
   142.594    43.164
   143.564    42.556
>
   144.697    42.996
   143.564    42.556
>
   144.697    42.996
   143.564    42.556
>
   142.753    42.280
   143.064    42.292
>
   142.753    42.280
   143.064    42.292
>
   143.157    42.016
   143.064    42.292
>
   143.157    42.016
   143.064    42.292
>
   143.362    42.614
   143.064    42.292
>
   143.362    42.614
   143.064    42.292
>
   142.364    42.778
   143.064    42.292
>
   143.835    42.903
   143.064    42.292
>
   142.594    43.164
   143.064    42.292
>
   143.362    42.614
   143.853    42.464
>
   143.362    42.614
   143.853    42.464
>
   143.835    42.903
   143.853    42.464
>
   143.835    42.903
   143.853    42.464
>
   143.157    42.016
   143.853    42.464
>
   143.770    43.297
   143.853    42.464
>
   143.770    43.297
   143.853    42.464
>
   144.697    42.996
   143.853    42.464
>
   144.697    42.996
   143.853    42.464
>
   142.753    42.280
   143.853    42.464
>
   142.753    42.280
   143.853    42.464
>
   143.362    42.614
   143.887    42.487
>
   143.362    42.614
   143.887    42.487
>
   143.835    42.903
   143.887    42.487
>
   143.835    42.903
   143.887    42.487
>
   143.157    42.016
   143.887    42.487
>
   143.157    42.016
   143.887    42.487
>
   144.697    42.996
   143.887    42.487
>
   144.697    42.996
   143.887    42.487
>
   143.770    43.297
   143.887    42.487
>
   143.770    43.297
   143.887    42.487
>
   142.753    42.280
   143.887    42.487
>
   142.753    42.280
   143.887    42.487
>
   143.157    42.016
   143.172    42.211
>
   143.157    42.016
   143.172    42.211
>
   142.753    42.280
   143.172    42.211
>
   142.753    42.280
   143.172    42.211
>
   143.362    42.614
   143.172    42.211
>
   143.362    42.614
   143.172    42.211
>
   142.364    42.778
   143.172    42.211
>
   142.364    42.778
   143.172    42.211
>
   143.835    42.903
   143.172    42.211
>
   143.835    42.903
   143.172    42.211
>
   142.753    42.280
   142.967    42.293
>
   142.753    42.280
   142.967    42.293
>
   143.157    42.016
   142.967    42.293
>
   143.157    42.016
   142.967    42.293
>
   143.362    42.614
   142.967    42.293
>
   143.362    42.614
   142.967    42.293
>
   142.364    42.778
   142.967    42.293
>
   142.364    42.778
   142.967    42.293
>
   143.835    42.903
   142.967    42.293
>
   143.835    42.903
   142.967    42.293
>
   142.594    43.164
   142.967    42.293
>
   142.753    42.280
   143.023    42.254
>
   142.753    42.280
   143.023    42.254
>
   143.157    42.016
   143.023    42.254
>
   143.362    42.614
   143.023    42.254
>
   143.362    42.614
   143.023    42.254
>
   142.364    42.778
   143.023    42.254
>
   142.364    42.778
   143.023    42.254
>
   143.835    42.903
   143.023    42.254
>
   142.594    43.164
   143.023    42.254
>
   142.753    42.280
   143.005    42.438
>
   142.753    42.280
   143.005    42.438
>
   143.362    42.614
   143.005    42.438
>
   143.362    42.614
   143.005    42.438
>
   143.157    42.016
   143.005    42.438
>
   142.364    42.778
   143.005    42.438
>
   142.364    42.778
   143.005    42.438
>
   143.835    42.903
   143.005    42.438
>
   143.835    42.903
   143.005    42.438
>
   142.594    43.164
   143.005    42.438
>
   142.753    42.280
   143.008    42.277
>
   142.753    42.280
   143.008    42.277
>
   143.157    42.016
   143.008    42.277
>
   143.157    42.016
   143.008    42.277
>
   143.362    42.614
   143.008    42.277
>
   143.362    42.614
   143.008    42.277
>
   142.364    42.778
   143.008    42.277
>
   143.835    42.903
   143.008    42.277
>
   142.594    43.164
   143.008    42.277
>
   142.753    42.280
   143.362    42.175
>
   142.753    42.280
   143.362    42.175
>
   143.362    42.614
   143.362    42.175
>
   143.362    42.614
   143.362    42.175
>
   143.835    42.903
   143.362    42.175
>
   142.364    42.778
   143.362    42.175
>
   142.753    42.280
   143.107    42.327
>
   142.753    42.280
   143.107    42.327
>
   143.362    42.614
   143.107    42.327
>
   143.362    42.614
   143.107    42.327
>
   143.157    42.016
   143.107    42.327
>
   143.157    42.016
   143.107    42.327
>
   142.364    42.778
   143.107    42.327
>
   143.835    42.903
   143.107    42.327
>
   142.594    43.164
   143.107    42.327
>
   142.753    42.280
   143.119    42.293
>
   142.753    42.280
   143.119    42.293
>
   143.157    42.016
   143.119    42.293
>
   143.362    42.614
   143.119    42.293
>
   143.362    42.614
   143.119    42.293
>
   142.364    42.778
   143.119    42.293
>
   143.835    42.903
   143.119    42.293
>
   143.835    42.903
   143.119    42.293
>
   142.594    43.164
   143.119    42.293
>
   142.753    42.280
   142.827    42.235
>
   142.753    42.280
   142.827    42.235
>
   143.157    42.016
   142.827    42.235
>
   143.362    42.614
   142.827    42.235
>
   143.362    42.614
   142.827    42.235
>
   142.364    42.778
   142.827    42.235
>
   142.364    42.778
   142.827    42.235
>
   142.594    43.164
   142.827    42.235
>
   142.753    42.280
   143.077    42.404
>
   142.753    42.280
   143.077    42.404
>
   143.362    42.614
   143.077    42.404
>
   143.157    42.016
   143.077    42.404
>
   143.157    42.016
   143.077    42.404
>
   142.364    42.778
   143.077    42.404
>
   142.364    42.778
   143.077    42.404
>
   143.835    42.903
   143.077    42.404
>
   142.594    43.164
   143.077    42.404
>
   142.753    42.280
   142.876    42.193
>
   142.753    42.280
   142.876    42.193
>
   143.157    42.016
   142.876    42.193
>
   143.157    42.016
   142.876    42.193
>
   143.362    42.614
   142.876    42.193
>
   143.362    42.614
   142.876    42.193
>
   142.364    42.778
   142.876    42.193
>
   142.364    42.778
   142.876    42.193
>
   142.594    43.164
   142.876    42.193
>
   142.753    42.280
   143.096    42.305
>
   142.753    42.280
   143.096    42.305
>
   143.362    42.614
   143.096    42.305
>
   143.362    42.614
   143.096    42.305
>
   143.157    42.016
   143.096    42.305
>
   143.157    42.016
   143.096    42.305
>
   142.364    42.778
   143.096    42.305
>
   142.364    42.778
   143.096    42.305
>
   143.835    42.903
   143.096    42.305
>
   143.835    42.903
   143.096    42.305
>
   142.594    43.164
   143.096    42.305
>
   142.753    42.280
   143.118    42.296
>
   142.753    42.280
   143.118    42.296
>
   143.157    42.016
   143.118    42.296
>
   143.157    42.016
   143.118    42.296
>
   143.157    42.015
   143.118    42.296
>
   143.157    42.015
   143.118    42.296
>
   143.157    42.015
   143.118    42.296
>
   143.362    42.614
   143.118    42.296
>
   143.362    42.614
   143.118    42.296
>
   142.364    42.778
   143.118    42.296
>
   143.835    42.903
   143.118    42.296
>
   143.835    42.903
   143.118    42.296
>
   142.594    43.164
   143.118    42.296
>
   142.753    42.280
   143.051    42.288
>
   142.753    42.280
   143.051    42.288
>
   143.157    42.016
   143.051    42.288
>
   143.157    42.016
   143.051    42.288
>
   143.362    42.614
   143.051    42.288
>
   143.362    42.614
   143.051    42.288
>
   142.364    42.778
   143.051    42.288
>
   143.835    42.903
   143.051    42.288
>
   142.594    43.164
   143.051    42.288
>
   142.753    42.280
   143.110    42.318
>
   142.753    42.280
   143.110    42.318
>
   143.157    42.016
   143.110    42.318
>
   143.157    42.016
   143.110    42.318
>
   143.362    42.614
   143.110    42.318
>
   143.362    42.614
   143.110    42.318
>
   142.364    42.778
   143.110    42.318
>
   142.364    42.778
   143.110    42.318
>
   143.835    42.903
   143.110    42.318
>
   143.835    42.903
   143.110    42.318
>
   142.594    43.164
   143.110    42.318
>
   142.753    42.280
   142.956    42.320
>
   142.753    42.280
   142.956    42.320
>
   143.157    42.016
   142.956    42.320
>
   143.362    42.614
   142.956    42.320
>
   143.362    42.614
   142.956    42.320
>
   142.364    42.778
   142.956    42.320
>
   142.364    42.778
   142.956    42.320
>
   142.594    43.164
   142.956    42.320
>
   143.835    42.903
   142.956    42.320
>
   143.835    42.903
   142.956    42.320
>
   143.157    42.016
   143.047    42.266
>
   143.157    42.016
   143.047    42.266
>
   143.157    42.015
   143.047    42.266
>
   142.753    42.280
   143.047    42.266
>
   142.753    42.280
   143.047    42.266
>
   143.362    42.614
   143.047    42.266
>
   143.362    42.614
   143.047    42.266
>
   142.364    42.778
   143.047    42.266
>
   142.364    42.778
   143.047    42.266
>
   143.835    42.903
   143.047    42.266
>
   143.835    42.903
   143.047    42.266
>
   142.594    43.164
   143.047    42.266
>
   143.362    42.614
   143.053    42.479
>
   143.362    42.614
   143.053    42.479
>
   142.753    42.280
   143.053    42.479
>
   142.753    42.280
   143.053    42.479
>
   143.157    42.016
   143.053    42.479
>
   143.157    42.015
   143.053    42.479
>
   142.364    42.778
   143.053    42.479
>
   143.835    42.903
   143.053    42.479
>
   143.835    42.903
   143.053    42.479
>
   142.594    43.164
   143.053    42.479
>
   143.770    43.297
   143.053    42.479
>
   143.770    43.297
   143.053    42.479
>
   142.753    42.280
   143.030    42.320
>
   143.157    42.016
   143.030    42.320
>
   143.362    42.614
   143.030    42.320
>
   143.362    42.614
   143.030    42.320
>
   142.364    42.778
   143.030    42.320
>
   143.835    42.903
   143.030    42.320
>
   142.594    43.164
   143.030    42.320
>
   143.157    42.016
   143.131    42.316
>
   143.157    42.016
   143.131    42.316
>
   142.753    42.280
   143.131    42.316
>
   142.753    42.280
   143.131    42.316
>
   143.362    42.614
   143.131    42.316
>
   143.362    42.614
   143.131    42.316
>
   143.835    42.903
   143.131    42.316
>
   142.364    42.778
   143.131    42.316
>
   142.364    42.778
   143.131    42.316
>
   142.594    43.164
   143.131    42.316
>
   143.157    42.016
   142.991    42.293
>
   143.157    42.015
   142.991    42.293
>
   143.157    42.015
   142.991    42.293
>
   143.362    42.614
   142.991    42.293
>
   143.362    42.614
   142.991    42.293
>
   142.364    42.778
   142.991    42.293
>
   142.364    42.778
   142.991    42.293
>
   143.835    42.903
   142.991    42.293
>
   142.594    43.164
   142.991    42.293
>
   142.753    42.280
   143.022    42.278
>
   142.753    42.280
   143.022    42.278
>
   143.157    42.016
   143.022    42.278
>
   143.157    42.016
   143.022    42.278
>
   143.157    42.015
   143.022    42.278
>
   143.362    42.614
   143.022    42.278
>
   143.362    42.614
   143.022    42.278
>
   142.364    42.778
   143.022    42.278
>
   143.835    42.903
   143.022    42.278
>
   143.835    42.903
   143.022    42.278
>
   142.594    43.164
   143.022    42.278
>
   142.753    42.280
   143.054    42.286
>
   142.753    42.280
   143.054    42.286
>
   143.157    42.016
   143.054    42.286
>
   143.157    42.015
   143.054    42.286
>
   143.157    42.015
   143.054    42.286
>
   143.362    42.614
   143.054    42.286
>
   143.362    42.614
   143.054    42.286
>
   142.364    42.778
   143.054    42.286
>
   142.364    42.778
   143.054    42.286
>
   143.835    42.903
   143.054    42.286
>
   143.835    42.903
   143.054    42.286
>
   142.594    43.164
   143.054    42.286
>
   143.362    42.614
   143.166    42.403
>
   143.362    42.614
   143.166    42.403
>
   142.753    42.280
   143.166    42.403
>
   142.753    42.280
   143.166    42.403
>
   143.157    42.016
   143.166    42.403
>
   143.157    42.016
   143.166    42.403
>
   143.157    42.015
   143.166    42.403
>
   143.157    42.015
   143.166    42.403
>
   143.835    42.903
   143.166    42.403
>
   143.835    42.903
   143.166    42.403
>
   142.594    43.164
   143.166    42.403
>
   143.770    43.297
   143.166    42.403
>
   143.770    43.297
   143.166    42.403
>
   142.753    42.280
   143.099    42.305
>
   142.753    42.280
   143.099    42.305
>
   143.362    42.614
   143.099    42.305
>
   143.362    42.614
   143.099    42.305
>
   143.157    42.016
   143.099    42.305
>
   143.157    42.015
   143.099    42.305
>
   143.157    42.015
   143.099    42.305
>
   142.364    42.778
   143.099    42.305
>
   142.364    42.778
   143.099    42.305
>
   143.835    42.903
   143.099    42.305
>
   143.835    42.903
   143.099    42.305
>
   142.594    43.164
   143.099    42.305
>
   142.753    42.280
   142.644    42.582
>
   142.753    42.280
   142.644    42.582
>
   142.364    42.778
   142.644    42.582
>
   142.364    42.778
   142.644    42.582
>
   143.362    42.614
   142.644    42.582
>
   143.362    42.614
   142.644    42.582
>
   142.594    43.164
   142.644    42.582
>
   143.157    42.016
   142.644    42.582
>
   143.157    42.015
   142.644    42.582
>
   143.157    42.015
   142.644    42.582
>
   141.450    42.840
   142.644    42.582
>
   141.450    42.840
   142.644    42.582
>
   143.835    42.903
   142.644    42.582
>
   143.835    42.903
   142.644    42.582
>
   142.223    43.505
   142.644    42.582
>
   142.223    43.505
   142.644    42.582
>
   142.753    42.280
   142.991    42.269
>
   142.753    42.280
   142.991    42.269
>
   143.157    42.016
   142.991    42.269
>
   143.157    42.015
   142.991    42.269
>
   143.362    42.614
   142.991    42.269
>
   143.362    42.614
   142.991    42.269
>
   142.364    42.778
   142.991    42.269
>
   143.835    42.903
   142.991    42.269
>
   142.594    43.164
   142.991    42.269
>
   143.157    42.016
   143.160    42.204
>
   143.157    42.016
   143.160    42.204
>
   143.157    42.015
   143.160    42.204
>
   143.157    42.015
   143.160    42.204
>
   142.753    42.280
   143.160    42.204
>
   142.753    42.280
   143.160    42.204
>
   143.362    42.614
   143.160    42.204
>
   143.362    42.614
   143.160    42.204
>
   142.364    42.778
   143.160    42.204
>
   142.364    42.778
   143.160    42.204
>
   143.835    42.903
   143.160    42.204
>
   143.835    42.903
   143.160    42.204
>
   143.362    42.614
   143.666    42.355
>
   143.362    42.614
   143.666    42.355
>
   143.835    42.903
   143.666    42.355
>
   143.835    42.903
   143.666    42.355
>
   143.157    42.016
   143.666    42.355
>
   143.157    42.015
   143.666    42.355
>
   143.157    42.015
   143.666    42.355
>
   143.157    42.015
   143.666    42.355
>
   142.753    42.280
   143.666    42.355
>
   142.753    42.280
   143.666    42.355
>
   143.770    43.297
   143.666    42.355
>
   143.770    43.297
   143.666    42.355
>
   144.697    42.996
   143.666    42.355
>
   144.697    42.996
   143.666    42.355
>
   142.753    42.280
   142.877    42.192
>
   142.753    42.280
   142.877    42.192
>
   143.157    42.015
   142.877    42.192
>
   143.157    42.015
   142.877    42.192
>
   143.157    42.016
   142.877    42.192
>
   143.362    42.614
   142.877    42.192
>
   143.362    42.614
   142.877    42.192
>
   142.364    42.778
   142.877    42.192
>
   142.594    43.164
   142.877    42.192
>
   142.753    42.280
   143.068    42.305
>
   142.753    42.280
   143.068    42.305
>
   143.362    42.614
   143.068    42.305
>
   143.362    42.614
   143.068    42.305
>
   143.157    42.016
   143.068    42.305
>
   143.157    42.015
   143.068    42.305
>
   143.157    42.015
   143.068    42.305
>
   142.364    42.778
   143.068    42.305
>
   142.364    42.778
   143.068    42.305
>
   143.835    42.903
   143.068    42.305
>
   142.594    43.164
   143.068    42.305
>
   142.753    42.280
   143.058    42.295
>
   143.157    42.015
   143.058    42.295
>
   143.157    42.015
   143.058    42.295
>
   143.157    42.016
   143.058    42.295
>
   143.362    42.614
   143.058    42.295
>
   143.362    42.614
   143.058    42.295
>
   142.364    42.778
   143.058    42.295
>
   143.835    42.903
   143.058    42.295
>
   143.835    42.903
   143.058    42.295
>
   142.594    43.164
   143.058    42.295
>
   143.157    42.016
   143.167    42.289
>
   143.157    42.015
   143.167    42.289
>
   142.753    42.280
   143.167    42.289
>
   142.753    42.280
   143.167    42.289
>
   143.362    42.614
   143.167    42.289
>
   143.362    42.614
   143.167    42.289
>
   142.364    42.778
   143.167    42.289
>
   142.364    42.778
   143.167    42.289
>
   143.835    42.903
   143.167    42.289
>
   143.835    42.903
   143.167    42.289
>
   142.594    43.164
   143.167    42.289
>
   142.753    42.280
   142.998    42.281
>
   143.157    42.016
   142.998    42.281
>
   143.157    42.016
   142.998    42.281
>
   143.157    42.015
   142.998    42.281
>
   143.157    42.015
   142.998    42.281
>
   143.362    42.614
   142.998    42.281
>
   143.362    42.614
   142.998    42.281
>
   142.364    42.778
   142.998    42.281
>
   142.364    42.778
   142.998    42.281
>
   143.835    42.903
   142.998    42.281
>
   142.594    43.164
   142.998    42.281
>
   143.362    42.614
   143.314    42.480
>
   143.362    42.614
   143.314    42.480
>
   142.753    42.280
   143.314    42.480
>
   142.753    42.280
   143.314    42.480
>
   143.157    42.016
   143.314    42.480
>
   143.157    42.015
   143.314    42.480
>
   143.835    42.903
   143.314    42.480
>
   143.835    42.903
   143.314    42.480
>
   142.364    42.778
   143.314    42.480
>
   142.364    42.778
   143.314    42.480
>
   142.594    43.164
   143.314    42.480
>
   143.770    43.297
   143.314    42.480
>
   143.770    43.297
   143.314    42.480
>
   142.753    42.280
   143.009    42.269
>
   142.753    42.280
   143.009    42.269
>
   143.157    42.016
   143.009    42.269
>
   143.157    42.015
   143.009    42.269
>
   143.362    42.614
   143.009    42.269
>
   143.362    42.614
   143.009    42.269
>
   142.364    42.778
   143.009    42.269
>
   143.835    42.903
   143.009    42.269
>
   142.594    43.164
   143.009    42.269
>
   143.362    42.614
   143.565    42.498
>
   143.362    42.614
   143.565    42.498
>
   143.835    42.903
   143.565    42.498
>
   143.835    42.903
   143.565    42.498
>
   143.157    42.016
   143.565    42.498
>
   142.753    42.280
   143.565    42.498
>
   142.753    42.280
   143.565    42.498
>
   143.770    43.297
   143.565    42.498
>
   143.770    43.297
   143.565    42.498
>
   142.364    42.778
   143.565    42.498
>
   142.364    42.778
   143.565    42.498
>
   144.697    42.996
   143.565    42.498
>
   144.697    42.996
   143.565    42.498
>
   142.594    43.164
   143.565    42.498
>
   143.362    42.614
   143.105    42.326
>
   143.362    42.614
   143.105    42.326
>
   142.753    42.280
   143.105    42.326
>
   142.753    42.280
   143.105    42.326
>
   143.157    42.016
   143.105    42.326
>
   143.157    42.016
   143.105    42.326
>
   143.157    42.015
   143.105    42.326
>
   143.157    42.015
   143.105    42.326
>
   142.364    42.778
   143.105    42.326
>
   142.364    42.778
   143.105    42.326
>
   143.835    42.903
   143.105    42.326
>
   143.835    42.903
   143.105    42.326
>
   142.594    43.164
   143.105    42.326
>
   143.362    42.614
   143.681    42.342
>
   143.362    42.614
   143.681    42.342
>
   143.157    42.015
   143.681    42.342
>
   143.157    42.015
   143.681    42.342
>
   143.157    42.016
   143.681    42.342
>
   143.835    42.903
   143.681    42.342
>
   143.835    42.903
   143.681    42.342
>
   142.753    42.280
   143.681    42.342
>
   143.770    43.297
   143.681    42.342
>
   143.770    43.297
   143.681    42.342
>
   144.697    42.996
   143.681    42.342
>
   142.753    42.280
   143.109    42.318
>
   143.362    42.614
   143.109    42.318
>
   143.157    42.015
   143.109    42.318
>
   143.157    42.015
   143.109    42.318
>
   143.157    42.016
   143.109    42.318
>
   142.364    42.778
   143.109    42.318
>
   143.835    42.903
   143.109    42.318
>
   143.835    42.903
   143.109    42.318
>
   142.594    43.164
   143.109    42.318
>
   142.753    42.280
   142.966    42.302
>
   142.753    42.280
   142.966    42.302
>
   143.157    42.016
   142.966    42.302
>
   143.157    42.015
   142.966    42.302
>
   143.157    42.015
   142.966    42.302
>
   143.157    42.015
   142.966    42.302
>
   143.362    42.614
   142.966    42.302
>
   143.362    42.614
   142.966    42.302
>
   142.364    42.778
   142.966    42.302
>
   142.364    42.778
   142.966    42.302
>
   142.594    43.164
   142.966    42.302
>
   143.835    42.903
   142.966    42.302
>
   143.835    42.903
   142.966    42.302
>
   142.753    42.280
   143.050    42.258
>
   142.753    42.280
   143.050    42.258
>
   143.157    42.016
   143.050    42.258
>
   143.157    42.016
   143.050    42.258
>
   143.362    42.614
   143.050    42.258
>
   143.362    42.614
   143.050    42.258
>
   142.364    42.778
   143.050    42.258
>
   142.364    42.778
   143.050    42.258
>
   143.835    42.903
   143.050    42.258
>
   143.835    42.903
   143.050    42.258
>
   142.594    43.164
   143.050    42.258
>
   142.753    42.280
   142.958    42.148
>
   142.753    42.280
   142.958    42.148
>
   143.157    42.016
   142.958    42.148
>
   143.157    42.016
   142.958    42.148
>
   143.362    42.614
   142.958    42.148
>
   143.362    42.614
   142.958    42.148
>
   142.364    42.778
   142.958    42.148
>
   142.364    42.778
   142.958    42.148
>
   143.835    42.903
   142.958    42.148
>
   143.835    42.903
   142.958    42.148
>
   143.362    42.614
   143.435    42.687
>
   143.362    42.614
   143.435    42.687
>
   143.835    42.903
   143.435    42.687
>
   143.835    42.903
   143.435    42.687
>
   142.753    42.280
   143.435    42.687
>
   142.753    42.280
   143.435    42.687
>
   143.770    43.297
   143.435    42.687
>
   143.770    43.297
   143.435    42.687
>
   142.364    42.778
   143.435    42.687
>
   142.594    43.164
   143.435    42.687
>
   144.697    42.996
   143.435    42.687
>
   144.697    42.996
   143.435    42.687
>
   142.753    42.280
   142.148    42.344
>
   142.753    42.280
   142.148    42.344
>
   142.364    42.778
   142.148    42.344
>
   142.364    42.778
   142.148    42.344
>
   141.450    42.840
   142.148    42.344
>
   141.450    42.840
   142.148    42.344
>
   143.157    42.015
   142.148    42.344
>
   143.157    42.016
   142.148    42.344
>
   141.038    42.469
   142.148    42.344
>
   141.038    42.469
   142.148    42.344
>
   142.594    43.164
   142.148    42.344
>
   143.362    42.614
   142.148    42.344
>
   143.362    42.614
   142.148    42.344
>
   141.033    41.888
   142.148    42.344
>
   141.033    41.888
   142.148    42.344
>
   141.038    42.469
   141.638    42.432
>
   142.364    42.778
   141.638    42.432
>
   141.033    41.888
   141.638    42.432
>
   141.033    41.888
   141.638    42.432
>
   140.370    42.117
   141.638    42.432
>
   143.362    42.614
   143.647    42.478
>
   143.362    42.614
   143.647    42.478
>
   143.284    42.292
   143.647    42.478
>
   143.835    42.903
   143.647    42.478
>
   143.835    42.903
   143.647    42.478
>
   143.157    42.016
   143.647    42.478
>
   142.753    42.280
   143.647    42.478
>
   142.753    42.280
   143.647    42.478
>
   143.770    43.297
   143.647    42.478
>
   143.770    43.297
   143.647    42.478
>
   144.697    42.996
   143.647    42.478
>
   144.697    42.996
   143.647    42.478
>
   142.364    42.778
   143.647    42.478
>
   142.364    42.778
   143.647    42.478
>
   142.753    42.280
   143.051    42.288
>
   142.753    42.280
   143.051    42.288
>
   143.157    42.016
   143.051    42.288
>
   143.157    42.015
   143.051    42.288
>
   143.157    42.015
   143.051    42.288
>
   143.362    42.614
   143.051    42.288
>
   143.362    42.614
   143.051    42.288
>
   142.364    42.778
   143.051    42.288
>
   143.835    42.903
   143.051    42.288
>
   143.835    42.903
   143.051    42.288
>
   142.594    43.164
   143.051    42.288
>
   142.753    42.280
   142.595    42.246
>
   142.753    42.280
   142.595    42.246
>
   143.157    42.016
   142.595    42.246
>
   143.284    42.292
   142.595    42.246
>
   143.284    42.292
   142.595    42.246
>
   142.364    42.778
   142.595    42.246
>
   142.364    42.778
   142.595    42.246
>
   143.362    42.614
   142.595    42.246
>
   143.362    42.614
   142.595    42.246
>
   142.594    43.164
   142.595    42.246
>
   143.284    42.292
   143.079    42.313
>
   143.284    42.292
   143.079    42.313
>
   142.753    42.280
   143.079    42.313
>
   142.753    42.280
   143.079    42.313
>
   143.362    42.614
   143.079    42.313
>
   143.362    42.614
   143.079    42.313
>
   143.157    42.015
   143.079    42.313
>
   143.157    42.015
   143.079    42.313
>
   143.157    42.015
   143.079    42.313
>
   143.157    42.016
   143.079    42.313
>
   143.157    42.016
   143.079    42.313
>
   142.364    42.778
   143.079    42.313
>
   142.364    42.778
   143.079    42.313
>
   143.835    42.903
   143.079    42.313
>
   143.835    42.903
   143.079    42.313
>
   142.594    43.164
   143.079    42.313
>
   143.362    42.614
   143.166    42.403
>
   142.753    42.280
   143.166    42.403
>
   142.753    42.280
   143.166    42.403
>
   143.157    42.016
   143.166    42.403
>
   143.835    42.903
   143.166    42.403
>
   143.835    42.903
   143.166    42.403
>
   142.364    42.778
   143.166    42.403
>
   142.594    43.164
   143.166    42.403
>
   143.770    43.297
   143.166    42.403
>
   143.770    43.297
   143.166    42.403
>
   142.753    42.280
   143.015    42.278
>
   142.753    42.280
   143.015    42.278
>
   143.157    42.016
   143.015    42.278
>
   143.157    42.016
   143.015    42.278
>
   143.157    42.015
   143.015    42.278
>
   143.157    42.015
   143.015    42.278
>
   143.362    42.614
   143.015    42.278
>
   143.362    42.614
   143.015    42.278
>
   142.364    42.778
   143.015    42.278
>
   142.364    42.778
   143.015    42.278
>
   143.835    42.903
   143.015    42.278
>
   143.835    42.903
   143.015    42.278
>
   142.594    43.164
   143.015    42.278
>
   142.753    42.280
   143.022    42.290
>
   143.157    42.016
   143.022    42.290
>
   143.157    42.015
   143.022    42.290
>
   143.157    42.015
   143.022    42.290
>
   143.362    42.614
   143.022    42.290
>
   143.362    42.614
   143.022    42.290
>
   142.364    42.778
   143.022    42.290
>
   143.835    42.903
   143.022    42.290
>
   143.835    42.903
   143.022    42.290
>
   142.594    43.164
   143.022    42.290
>
   142.753    42.280
   142.285    42.245
>
   142.753    42.280
   142.285    42.245
>
   142.364    42.778
   142.285    42.245
>
   142.364    42.778
   142.285    42.245
>
   143.157    42.016
   142.285    42.245
>
   141.450    42.840
   142.285    42.245
>
   143.362    42.614
   142.285    42.245
>
   143.362    42.614
   142.285    42.245
>
   142.594    43.164
   142.285    42.245
>
   141.038    42.469
   142.285    42.245
>
   141.038    42.469
   142.285    42.245
>
   141.033    41.888
   142.285    42.245
>
   141.033    41.888
   142.285    42.245
>
   141.038    42.469
   141.451    42.889
>
   142.364    42.778
   141.451    42.889
>
   142.364    42.778
   141.451    42.889
>
   140.476    43.353
   141.451    42.889
>
   143.284    42.292
   143.121    42.301
>
   143.157    42.016
   143.121    42.301
>
   143.157    42.016
   143.121    42.301
>
   142.753    42.280
   143.121    42.301
>
   142.753    42.280
   143.121    42.301
>
   143.362    42.614
   143.121    42.301
>
   143.362    42.614
   143.121    42.301
>
   142.364    42.778
   143.121    42.301
>
   143.835    42.903
   143.121    42.301
>
   143.835    42.903
   143.121    42.301
>
   142.594    43.164
   143.121    42.301
>
   142.753    42.280
   142.958    42.301
>
   142.753    42.280
   142.958    42.301
>
   143.157    42.016
   142.958    42.301
>
   143.157    42.015
   142.958    42.301
>
   143.157    42.015
   142.958    42.301
>
   143.157    42.015
   142.958    42.301
>
   143.362    42.614
   142.958    42.301
>
   143.362    42.614
   142.958    42.301
>
   142.364    42.778
   142.958    42.301
>
   142.364    42.778
   142.958    42.301
>
   143.835    42.903
   142.958    42.301
>
   142.594    43.164
   142.958    42.301
>
   142.753    42.280
   142.592    42.305
>
   142.753    42.280
   142.592    42.305
>
   143.157    42.015
   142.592    42.305
>
   143.157    42.015
   142.592    42.305
>
   143.157    42.016
   142.592    42.305
>
   142.364    42.778
   142.592    42.305
>
   143.362    42.614
   142.592    42.305
>
   143.362    42.614
   142.592    42.305
>
   142.594    43.164
   142.592    42.305
>
   141.450    42.840
   142.592    42.305
>
   141.450    42.840
   142.592    42.305
>
   142.753    42.280
   143.114    42.316
>
   142.753    42.280
   143.114    42.316
>
   143.157    42.016
   143.114    42.316
>
   143.157    42.015
   143.114    42.316
>
   143.157    42.015
   143.114    42.316
>
   143.362    42.614
   143.114    42.316
>
   143.362    42.614
   143.114    42.316
>
   142.364    42.778
   143.114    42.316
>
   142.364    42.778
   143.114    42.316
>
   143.835    42.903
   143.114    42.316
>
   143.835    42.903
   143.114    42.316
>
   142.594    43.164
   143.114    42.316
>
   143.362    42.614
   143.316    42.695
>
   143.284    42.292
   143.316    42.695
>
   143.284    42.292
   143.316    42.695
>
   143.835    42.903
   143.316    42.695
>
   142.753    42.280
   143.316    42.695
>
   143.157    42.016
   143.316    42.695
>
   143.157    42.015
   143.316    42.695
>
   143.157    42.015
   143.316    42.695
>
   143.157    42.015
   143.316    42.695
>
   142.364    42.778
   143.316    42.695
>
   143.770    43.297
   143.316    42.695
>
   142.594    43.164
   143.316    42.695
>
   143.129    43.466
   143.316    42.695
>
   142.753    42.280
   142.491    42.234
>
   142.753    42.280
   142.491    42.234
>
   143.157    42.015
   142.491    42.234
>
   143.157    42.016
   142.491    42.234
>
   143.362    42.614
   142.491    42.234
>
   142.594    43.164
   142.491    42.234
>
   141.450    42.840
   142.491    42.234
>
   142.753    42.280
   142.537    42.167
>
   143.157    42.015
   142.537    42.167
>
   143.157    42.015
   142.537    42.167
>
   143.157    42.016
   142.537    42.167
>
   142.364    42.778
   142.537    42.167
>
   143.362    42.614
   142.537    42.167
>
   143.362    42.614
   142.537    42.167
>
   142.753    42.280
   142.586    42.198
>
   142.753    42.280
   142.586    42.198
>
   143.157    42.015
   142.586    42.198
>
   143.157    42.016
   142.586    42.198
>
   142.364    42.778
   142.586    42.198
>
   143.362    42.614
   142.586    42.198
>
   142.594    43.164
   142.586    42.198
>
   142.753    42.280
   142.687    42.579
>
   142.753    42.280
   142.687    42.579
>
   142.364    42.778
   142.687    42.579
>
   142.364    42.778
   142.687    42.579
>
   143.362    42.614
   142.687    42.579
>
   143.362    42.614
   142.687    42.579
>
   142.594    43.164
   142.687    42.579
>
   143.157    42.016
   142.687    42.579
>
   143.835    42.903
   142.687    42.579
>
   143.835    42.903
   142.687    42.579
>
   141.450    42.840
   142.687    42.579
>
   141.450    42.840
   142.687    42.579
>
   142.223    43.505
   142.687    42.579
>
   142.753    42.280
   142.885    42.198
>
   142.753    42.280
   142.885    42.198
>
   143.157    42.016
   142.885    42.198
>
   143.157    42.015
   142.885    42.198
>
   143.362    42.614
   142.885    42.198
>
   143.362    42.614
   142.885    42.198
>
   142.364    42.778
   142.885    42.198
>
   143.835    42.903
   142.885    42.198
>
   142.594    43.164
   142.885    42.198
>
   142.753    42.280
   143.114    42.314
>
   142.753    42.280
   143.114    42.314
>
   143.157    42.016
   143.114    42.314
>
   143.157    42.015
   143.114    42.314
>
   143.362    42.614
   143.114    42.314
>
   143.362    42.614
   143.114    42.314
>
   142.364    42.778
   143.114    42.314
>
   143.835    42.903
   143.114    42.314
>
   143.835    42.903
   143.114    42.314
>
   142.594    43.164
   143.114    42.314
>
   143.284    42.292
   142.986    42.447
>
   142.753    42.280
   142.986    42.447
>
   142.753    42.280
   142.986    42.447
>
   143.299    42.291
   142.986    42.447
>
   143.299    42.291
   142.986    42.447
>
   143.362    42.614
   142.986    42.447
>
   143.362    42.614
   142.986    42.447
>
   142.467    42.410
   142.986    42.447
>
   142.467    42.410
   142.986    42.447
>
   143.157    42.016
   142.986    42.447
>
   143.157    42.015
   142.986    42.447
>
   143.157    42.015
   142.986    42.447
>
   143.157    42.015
   142.986    42.447
>
   142.364    42.778
   142.986    42.447
>
   142.364    42.778
   142.986    42.447
>
   143.835    42.903
   142.986    42.447
>
   143.835    42.903
   142.986    42.447
>
   142.594    43.164
   142.986    42.447
>
   143.299    42.291
   142.996    42.335
>
   142.753    42.280
   142.996    42.335
>
   142.753    42.280
   142.996    42.335
>
   143.157    42.016
   142.996    42.335
>
   143.157    42.015
   142.996    42.335
>
   143.362    42.614
   142.996    42.335
>
   143.362    42.614
   142.996    42.335
>
   142.467    42.410
   142.996    42.335
>
   142.364    42.778
   142.996    42.335
>
   143.835    42.903
   142.996    42.335
>
   142.594    43.164
   142.996    42.335
>
   143.299    42.291
   143.080    42.294
>
   143.299    42.291
   143.080    42.294
>
   142.753    42.280
   143.080    42.294
>
   143.157    42.016
   143.080    42.294
>
   143.157    42.015
   143.080    42.294
>
   143.157    42.015
   143.080    42.294
>
   143.362    42.614
   143.080    42.294
>
   143.362    42.614
   143.080    42.294
>
   142.467    42.410
   143.080    42.294
>
   142.364    42.778
   143.080    42.294
>
   143.835    42.903
   143.080    42.294
>
   142.594    43.164
   143.080    42.294
>
   143.299    42.291
   143.077    42.293
>
   143.299    42.291
   143.077    42.293
>
   142.753    42.280
   143.077    42.293
>
   142.753    42.280
   143.077    42.293
>
   143.157    42.016
   143.077    42.293
>
   143.157    42.016
   143.077    42.293
>
   143.362    42.614
   143.077    42.293
>
   143.362    42.614
   143.077    42.293
>
   142.467    42.410
   143.077    42.293
>
   142.467    42.410
   143.077    42.293
>
   142.364    42.778
   143.077    42.293
>
   142.364    42.778
   143.077    42.293
>
   143.835    42.903
   143.077    42.293
>
   143.835    42.903
   143.077    42.293
>
   142.594    43.164
   143.077    42.293
>
   143.157    42.016
   142.972    42.293
>
   142.753    42.280
   142.972    42.293
>
   142.753    42.280
   142.972    42.293
>
   143.299    42.291
   142.972    42.293
>
   143.299    42.291
   142.972    42.293
>
   142.467    42.410
   142.972    42.293
>
   143.362    42.614
   142.972    42.293
>
   143.362    42.614
   142.972    42.293
>
   142.364    42.778
   142.972    42.293
>
   142.364    42.778
   142.972    42.293
>
   143.835    42.903
   142.972    42.293
>
   143.835    42.903
   142.972    42.293
>
   142.594    43.164
   142.972    42.293
>
   142.364    42.778
   142.582    42.671
>
   142.467    42.410
   142.582    42.671
>
   142.753    42.280
   142.582    42.671
>
   142.594    43.164
   142.582    42.671
>
   143.362    42.614
   142.582    42.671
>
   143.362    42.614
   142.582    42.671
>
   143.157    42.016
   142.582    42.671
>
   141.450    42.840
   142.582    42.671
>
   141.450    42.840
   142.582    42.671
>
   142.223    43.505
   142.582    42.671
>
   143.299    42.291
   143.118    42.314
>
   143.299    42.291
   143.118    42.314
>
   142.753    42.280
   143.118    42.314
>
   143.157    42.015
   143.118    42.314
>
   143.157    42.016
   143.118    42.314
>
   143.362    42.614
   143.118    42.314
>
   142.467    42.410
   143.118    42.314
>
   142.364    42.778
   143.118    42.314
>
   143.835    42.903
   143.118    42.314
>
   143.835    42.903
   143.118    42.314
>
   142.594    43.164
   143.118    42.314
>
   141.921    42.623
   143.118    42.314
>
   143.362    42.614
   143.760    42.448
>
   143.362    42.614
   143.760    42.448
>
   143.299    42.291
   143.760    42.448
>
   143.299    42.291
   143.760    42.448
>
   143.835    42.903
   143.760    42.448
>
   143.835    42.903
   143.760    42.448
>
   143.157    42.016
   143.760    42.448
>
   142.753    42.280
   143.760    42.448
>
   142.753    42.280
   143.760    42.448
>
   143.770    43.297
   143.760    42.448
>
   143.770    43.297
   143.760    42.448
>
   144.697    42.996
   143.760    42.448
>
   144.697    42.996
   143.760    42.448
>
   142.467    42.410
   143.760    42.448
>
   143.157    42.016
   143.005    42.178
>
   143.157    42.015
   143.005    42.178
>
   143.157    42.015
   143.005    42.178
>
   143.157    42.015
   143.005    42.178
>
   143.299    42.291
   143.005    42.178
>
   143.299    42.291
   143.005    42.178
>
   142.753    42.280
   143.005    42.178
>
   142.753    42.280
   143.005    42.178
>
   143.362    42.614
   143.005    42.178
>
   143.362    42.614
   143.005    42.178
>
   142.467    42.410
   143.005    42.178
>
   142.364    42.778
   143.005    42.178
>
   142.364    42.778
   143.005    42.178
>
   143.835    42.903
   143.005    42.178
>
   141.921    42.623
   143.005    42.178
>
   142.753    42.280
   142.984    42.310
>
   143.299    42.291
   142.984    42.310
>
   143.299    42.291
   142.984    42.310
>
   143.157    42.016
   142.984    42.310
>
   142.467    42.410
   142.984    42.310
>
   143.362    42.614
   142.984    42.310
>
   143.362    42.614
   142.984    42.310
>
   142.364    42.778
   142.984    42.310
>
   142.364    42.778
   142.984    42.310
>
   141.921    42.623
   142.984    42.310
>
   143.835    42.903
   142.984    42.310
>
   142.594    43.164
   142.984    42.310
>
   143.299    42.291
   143.162    42.204
>
   143.299    42.291
   143.162    42.204
>
   143.157    42.016
   143.162    42.204
>
   142.753    42.280
   143.162    42.204
>
   142.753    42.280
   143.162    42.204
>
   143.362    42.614
   143.162    42.204
>
   143.362    42.614
   143.162    42.204
>
   142.467    42.410
   143.162    42.204
>
   142.364    42.778
   143.162    42.204
>
   143.835    42.903
   143.162    42.204
>
   142.753    42.280
   142.948    42.292
>
   142.753    42.280
   142.948    42.292
>
   143.299    42.291
   142.948    42.292
>
   143.299    42.291
   142.948    42.292
>
   143.157    42.016
   142.948    42.292
>
   143.157    42.015
   142.948    42.292
>
   143.157    42.015
   142.948    42.292
>
   143.157    42.015
   142.948    42.292
>
   143.362    42.614
   142.948    42.292
>
   143.362    42.614
   142.948    42.292
>
   142.467    42.410
   142.948    42.292
>
   142.467    42.410
   142.948    42.292
>
   142.364    42.778
   142.948    42.292
>
   143.835    42.903
   142.948    42.292
>
   141.921    42.623
   142.948    42.292
>
   142.594    43.164
   142.948    42.292
>
   143.299    42.291
   143.039    42.293
>
   143.157    42.015
   143.039    42.293
>
   143.157    42.015
   143.039    42.293
>
   143.157    42.016
   143.039    42.293
>
   142.753    42.280
   143.039    42.293
>
   143.362    42.614
   143.039    42.293
>
   143.362    42.614
   143.039    42.293
>
   142.467    42.410
   143.039    42.293
>
   142.364    42.778
   143.039    42.293
>
   143.835    42.903
   143.039    42.293
>
   142.594    43.164
   143.039    42.293
>
   143.157    42.016
   143.010    42.259
>
   143.157    42.015
   143.010    42.259
>
   143.157    42.015
   143.010    42.259
>
   142.753    42.280
   143.010    42.259
>
   142.753    42.280
   143.010    42.259
>
   143.299    42.291
   143.010    42.259
>
   143.299    42.291
   143.010    42.259
>
   142.467    42.410
   143.010    42.259
>
   143.362    42.614
   143.010    42.259
>
   143.362    42.614
   143.010    42.259
>
   142.364    42.778
   143.010    42.259
>
   142.364    42.778
   143.010    42.259
>
   143.835    42.903
   143.010    42.259
>
   143.835    42.903
   143.010    42.259
>
   141.921    42.623
   143.010    42.259
>
   142.594    43.164
   143.010    42.259
>
   143.299    42.291
   143.075    42.276
>
   143.299    42.291
   143.075    42.276
>
   142.753    42.280
   143.075    42.276
>
   142.753    42.280
   143.075    42.276
>
   143.157    42.016
   143.075    42.276
>
   143.157    42.015
   143.075    42.276
>
   143.157    42.015
   143.075    42.276
>
   143.362    42.614
   143.075    42.276
>
   143.362    42.614
   143.075    42.276
>
   142.467    42.410
   143.075    42.276
>
   142.467    42.410
   143.075    42.276
>
   142.364    42.778
   143.075    42.276
>
   142.364    42.778
   143.075    42.276
>
   143.835    42.903
   143.075    42.276
>
   143.835    42.903
   143.075    42.276
>
   141.921    42.623
   143.075    42.276
>
   141.921    42.623
   143.075    42.276
>
   142.594    43.164
   143.075    42.276
>
   142.467    42.410
   142.426    42.314
>
   142.467    42.410
   142.426    42.314
>
   142.753    42.280
   142.426    42.314
>
   142.753    42.280
   142.426    42.314
>
   142.364    42.778
   142.426    42.314
>
   141.921    42.623
   142.426    42.314
>
   143.157    42.016
   142.426    42.314
>
   143.157    42.015
   142.426    42.314
>
   143.299    42.291
   142.426    42.314
>
   143.362    42.614
   142.426    42.314
>
   142.594    43.164
   142.426    42.314
>
   141.450    42.840
   142.426    42.314
>
   142.753    42.280
   142.879    42.190
>
   142.753    42.280
   142.879    42.190
>
   143.157    42.016
   142.879    42.190
>
   143.157    42.015
   142.879    42.190
>
   143.299    42.291
   142.879    42.190
>
   143.299    42.291
   142.879    42.190
>
   142.467    42.410
   142.879    42.190
>
   142.467    42.410
   142.879    42.190
>
   143.362    42.614
   142.879    42.190
>
   143.362    42.614
   142.879    42.190
>
   142.364    42.778
   142.879    42.190
>
   141.921    42.623
   142.879    42.190
>
   142.594    43.164
   142.879    42.190
>
   143.299    42.291
   143.047    42.279
>
   143.299    42.291
   143.047    42.279
>
   143.157    42.016
   143.047    42.279
>
   142.753    42.280
   143.047    42.279
>
   142.753    42.280
   143.047    42.279
>
   143.362    42.614
   143.047    42.279
>
   143.362    42.614
   143.047    42.279
>
   142.467    42.410
   143.047    42.279
>
   142.364    42.778
   143.047    42.279
>
   143.835    42.903
   143.047    42.279
>
   143.835    42.903
   143.047    42.279
>
   141.921    42.623
   143.047    42.279
>
   142.594    43.164
   143.047    42.279
>
   142.467    42.410
   142.581    42.463
>
   142.753    42.280
   142.581    42.463
>
   142.364    42.778
   142.581    42.463
>
   142.364    42.778
   142.581    42.463
>
   141.921    42.623
   142.581    42.463
>
   143.299    42.291
   142.581    42.463
>
   143.157    42.016
   142.581    42.463
>
   143.157    42.015
   142.581    42.463
>
   143.362    42.614
   142.581    42.463
>
   143.362    42.614
   142.581    42.463
>
   142.594    43.164
   142.581    42.463
>
   141.450    42.840
   142.581    42.463
>
   141.450    42.840
   142.581    42.463
>
   143.299    42.291
   143.124    42.309
>
   143.299    42.291
   143.124    42.309
>
   143.157    42.016
   143.124    42.309
>
   143.157    42.016
   143.124    42.309
>
   143.157    42.015
   143.124    42.309
>
   143.157    42.015
   143.124    42.309
>
   143.157    42.015
   143.124    42.309
>
   142.753    42.280
   143.124    42.309
>
   142.753    42.280
   143.124    42.309
>
   143.362    42.614
   143.124    42.309
>
   143.362    42.614
   143.124    42.309
>
   142.467    42.410
   143.124    42.309
>
   142.364    42.778
   143.124    42.309
>
   143.835    42.903
   143.124    42.309
>
   143.835    42.903
   143.124    42.309
>
   142.594    43.164
   143.124    42.309
>
   141.921    42.623
   143.124    42.309
>
   142.467    42.410
   142.756    42.609
>
   142.753    42.280
   142.756    42.609
>
   142.364    42.778
   142.756    42.609
>
   142.364    42.778
   142.756    42.609
>
   143.362    42.614
   142.756    42.609
>
   143.362    42.614
   142.756    42.609
>
   143.299    42.291
   142.756    42.609
>
   142.594    43.164
   142.756    42.609
>
   141.921    42.623
   142.756    42.609
>
   141.921    42.623
   142.756    42.609
>
   143.835    42.903
   142.756    42.609
>
   143.835    42.903
   142.756    42.609
>
   142.223    43.505
   142.756    42.609
>
   141.450    42.840
   142.756    42.609
>
   141.450    42.840
   142.756    42.609
>
   142.364    42.778
   142.629    42.739
>
   142.467    42.410
   142.629    42.739
>
   142.594    43.164
   142.629    42.739
>
   143.362    42.614
   142.629    42.739
>
   143.362    42.614
   142.629    42.739
>
   141.921    42.623
   142.629    42.739
>
   143.299    42.291
   142.629    42.739
>
   143.299    42.291
   142.629    42.739
>
   143.157    42.015
   142.629    42.739
>
   143.157    42.015
   142.629    42.739
>
   142.223    43.505
   142.629    42.739
>
   143.835    42.903
   142.629    42.739
>
   141.450    42.840
   142.629    42.739
>
   142.364    42.778
   142.655    42.750
>
   142.364    42.778
   142.655    42.750
>
   142.467    42.410
   142.655    42.750
>
   142.594    43.164
   142.655    42.750
>
   142.753    42.280
   142.655    42.750
>
   143.362    42.614
   142.655    42.750
>
   143.362    42.614
   142.655    42.750
>
   141.921    42.623
   142.655    42.750
>
   143.299    42.291
   142.655    42.750
>
   143.299    42.291
   142.655    42.750
>
   143.835    42.903
   142.655    42.750
>
   141.450    42.840
   142.655    42.750
>
   141.450    42.840
   142.655    42.750
>
   143.770    43.297
   142.655    42.750
>
   143.770    43.297
   142.655    42.750
>
   143.362    42.614
   143.624    42.496
>
   143.362    42.614
   143.624    42.496
>
   143.299    42.291
   143.624    42.496
>
   143.299    42.291
   143.624    42.496
>
   143.284    42.292
   143.624    42.496
>
   143.835    42.903
   143.624    42.496
>
   143.835    42.903
   143.624    42.496
>
   143.157    42.015
   143.624    42.496
>
   143.157    42.015
   143.624    42.496
>
   143.157    42.015
   143.624    42.496
>
   143.157    42.016
   143.624    42.496
>
   142.753    42.280
   143.624    42.496
>
   142.753    42.280
   143.624    42.496
>
   143.770    43.297
   143.624    42.496
>
   143.770    43.297
   143.624    42.496
>
   144.697    42.996
   143.624    42.496
>
   144.697    42.996
   143.624    42.496
>
   142.364    42.778
   143.624    42.496
>
   141.450    42.840
   141.411    42.612
>
   141.038    42.469
   141.411    42.612
>
   141.417    43.275
   141.411    42.612
>
   141.033    41.888
   141.411    42.612
>
   141.033    41.888
   141.411    42.612
>
   140.370    42.117
   141.411    42.612
>
   143.299    42.291
   143.093    42.325
>
   143.299    42.291
   143.093    42.325
>
   142.753    42.280
   143.093    42.325
>
   142.753    42.280
   143.093    42.325
>
   143.157    42.015
   143.093    42.325
>
   143.157    42.016
   143.093    42.325
>
   143.362    42.614
   143.093    42.325
>
   143.362    42.614
   143.093    42.325
>
   142.467    42.410
   143.093    42.325
>
   142.364    42.778
   143.093    42.325
>
   143.835    42.903
   143.093    42.325
>
   143.835    42.903
   143.093    42.325
>
   141.921    42.623
   143.093    42.325
>
   142.594    43.164
   143.093    42.325
>
   144.697    42.996
   144.135    42.646
>
   144.697    42.996
   144.135    42.646
>
   143.362    42.614
   144.135    42.646
>
   143.362    42.614
   144.135    42.646
>
   143.299    42.291
   144.135    42.646
>
   143.299    42.291
   144.135    42.646
>
   143.770    43.297
   144.135    42.646
>
   143.770    43.297
   144.135    42.646
>
   145.161    43.083
   144.135    42.646
>
   145.161    43.083
   144.135    42.646
>
   143.157    42.015
   144.135    42.646
>
   143.157    42.015
   144.135    42.646
>
   142.364    42.778
   142.682    42.789
>
   142.364    42.778
   142.682    42.789
>
   142.467    42.410
   142.682    42.789
>
   141.921    42.623
   142.682    42.789
>
   143.299    42.291
   142.682    42.789
>
   143.299    42.291
   142.682    42.789
>
   143.157    42.015
   142.682    42.789
>
   143.157    42.015
   142.682    42.789
>
   142.223    43.505
   142.682    42.789
>
   141.450    42.840
   142.682    42.789
>
   142.467    42.410
   142.631    42.512
>
   142.753    42.280
   142.631    42.512
>
   142.364    42.778
   142.631    42.512
>
   143.299    42.291
   142.631    42.512
>
   143.362    42.614
   142.631    42.512
>
   143.362    42.614
   142.631    42.512
>
   143.157    42.016
   142.631    42.512
>
   141.921    42.623
   142.631    42.512
>
   142.594    43.164
   142.631    42.512
>
   141.450    42.840
   142.631    42.512
>
   143.835    42.903
   142.631    42.512
>
   141.921    42.623
   141.806    42.578
>
   141.921    42.623
   141.806    42.578
>
   141.450    42.840
   141.806    42.578
>
   141.450    42.840
   141.806    42.578
>
   142.364    42.778
   141.806    42.578
>
   142.467    42.410
   141.806    42.578
>
   141.038    42.469
   141.806    42.578
>
   141.038    42.469
   141.806    42.578
>
   142.753    42.280
   141.806    42.578
>
   141.417    43.275
   141.806    42.578
>
   142.594    43.164
   141.806    42.578
>
   141.033    41.888
   141.806    42.578
>
   141.033    41.888
   141.806    42.578
>
   142.223    43.505
   141.806    42.578
>
   141.921    42.623
   141.824    42.590
>
   141.921    42.623
   141.824    42.590
>
   141.450    42.840
   141.824    42.590
>
   141.450    42.840
   141.824    42.590
>
   142.364    42.778
   141.824    42.590
>
   142.467    42.410
   141.824    42.590
>
   141.038    42.469
   141.824    42.590
>
   141.038    42.469
   141.824    42.590
>
   141.417    43.275
   141.824    42.590
>
   142.753    42.280
   141.824    42.590
>
   142.753    42.280
   141.824    42.590
>
   142.594    43.164
   141.824    42.590
>
   142.594    43.164
   141.824    42.590
>
   141.033    41.888
   141.824    42.590
>
   141.033    41.888
   141.824    42.590
>
   142.753    42.280
   142.968    42.311
>
   142.753    42.280
   142.968    42.311
>
   143.284    42.292
   142.968    42.311
>
   143.284    42.292
   142.968    42.311
>
   143.299    42.291
   142.968    42.311
>
   143.299    42.291
   142.968    42.311
>
   143.157    42.016
   142.968    42.311
>
   143.157    42.015
   142.968    42.311
>
   143.157    42.015
   142.968    42.311
>
   143.157    42.015
   142.968    42.311
>
   143.362    42.614
   142.968    42.311
>
   143.362    42.614
   142.968    42.311
>
   142.467    42.410
   142.968    42.311
>
   142.467    42.410
   142.968    42.311
>
   142.364    42.778
   142.968    42.311
>
   142.364    42.778
   142.968    42.311
>
   143.835    42.903
   142.968    42.311
>
   143.835    42.903
   142.968    42.311
>
   141.921    42.623
   142.968    42.311
>
   142.594    43.164
   142.968    42.311
>
   143.299    42.291
   143.012    42.281
>
   143.299    42.291
   143.012    42.281
>
   142.753    42.280
   143.012    42.281
>
   142.753    42.280
   143.012    42.281
>
   143.157    42.016
   143.012    42.281
>
   143.362    42.614
   143.012    42.281
>
   143.362    42.614
   143.012    42.281
>
   142.467    42.410
   143.012    42.281
>
   142.364    42.778
   143.012    42.281
>
   143.835    42.903
   143.012    42.281
>
   143.835    42.903
   143.012    42.281
>
   141.921    42.623
   143.012    42.281
>
   142.594    43.164
   143.012    42.281
>
   142.467    42.410
   142.577    42.352
>
   142.753    42.280
   142.577    42.352
>
   142.753    42.280
   142.577    42.352
>
   142.364    42.778
   142.577    42.352
>
   142.364    42.778
   142.577    42.352
>
   143.157    42.015
   142.577    42.352
>
   143.157    42.015
   142.577    42.352
>
   143.157    42.016
   142.577    42.352
>
   143.299    42.291
   142.577    42.352
>
   141.921    42.623
   142.577    42.352
>
   143.362    42.614
   142.577    42.352
>
   143.362    42.614
   142.577    42.352
>
   142.594    43.164
   142.577    42.352
>
   141.450    42.840
   142.577    42.352
>
   141.450    42.840
   142.577    42.352
>
   141.450    42.840
   142.577    42.352
>
   143.299    42.291
   143.079    42.309
>
   142.753    42.280
   143.079    42.309
>
   142.753    42.280
   143.079    42.309
>
   143.157    42.016
   143.079    42.309
>
   143.157    42.015
   143.079    42.309
>
   143.157    42.015
   143.079    42.309
>
   143.362    42.614
   143.079    42.309
>
   143.362    42.614
   143.079    42.309
>
   142.467    42.410
   143.079    42.309
>
   142.364    42.778
   143.079    42.309
>
   143.835    42.903
   143.079    42.309
>
   143.835    42.903
   143.079    42.309
>
   141.921    42.623
   143.079    42.309
>
   142.594    43.164
   143.079    42.309
>
   143.299    42.291
   143.579    42.464
>
   143.299    42.291
   143.579    42.464
>
   143.362    42.614
   143.579    42.464
>
   143.362    42.614
   143.579    42.464
>
   143.157    42.016
   143.579    42.464
>
   143.157    42.015
   143.579    42.464
>
   143.835    42.903
   143.579    42.464
>
   143.835    42.903
   143.579    42.464
>
   142.753    42.280
   143.579    42.464
>
   142.753    42.280
   143.579    42.464
>
   142.467    42.410
   143.579    42.464
>
   143.770    43.297
   143.579    42.464
>
   143.770    43.297
   143.579    42.464
>
   142.364    42.778
   143.579    42.464
>
   142.364    42.778
   143.579    42.464
>
   144.697    42.996
   143.579    42.464
>
   144.697    42.996
   143.579    42.464
>
   143.835    42.903
   144.031    42.567
>
   143.362    42.614
   144.031    42.567
>
   143.362    42.614
   144.031    42.567
>
   143.299    42.291
   144.031    42.567
>
   144.697    42.996
   144.031    42.567
>
   144.697    42.996
   144.031    42.567
>
   143.770    43.297
   144.031    42.567
>
   143.770    43.297
   144.031    42.567
>
   143.157    42.016
   144.031    42.567
>
   143.157    42.015
   144.031    42.567
>
   143.157    42.015
   144.031    42.567
>
   145.161    43.083
   144.031    42.567
>
   145.161    43.083
   144.031    42.567
>
   143.299    42.291
   143.122    42.302
>
   143.299    42.291
   143.122    42.302
>
   143.157    42.016
   143.122    42.302
>
   143.157    42.015
   143.122    42.302
>
   142.753    42.280
   143.122    42.302
>
   142.753    42.280
   143.122    42.302
>
   143.362    42.614
   143.122    42.302
>
   143.362    42.614
   143.122    42.302
>
   142.467    42.410
   143.122    42.302
>
   143.835    42.903
   143.122    42.302
>
   142.364    42.778
   143.122    42.302
>
   143.299    42.291
   143.066    42.262
>
   143.299    42.291
   143.066    42.262
>
   143.157    42.016
   143.066    42.262
>
   143.157    42.015
   143.066    42.262
>
   143.157    42.015
   143.066    42.262
>
   142.753    42.280
   143.066    42.262
>
   142.753    42.280
   143.066    42.262
>
   143.362    42.614
   143.066    42.262
>
   143.362    42.614
   143.066    42.262
>
   142.467    42.410
   143.066    42.262
>
   142.364    42.778
   143.066    42.262
>
   143.835    42.903
   143.066    42.262
>
   143.835    42.903
   143.066    42.262
>
   141.921    42.623
   143.066    42.262
>
   142.594    43.164
   143.066    42.262
>
   142.753    42.280
   142.952    42.279
>
   143.299    42.291
   142.952    42.279
>
   143.299    42.291
   142.952    42.279
>
   143.157    42.016
   142.952    42.279
>
   143.157    42.015
   142.952    42.279
>
   143.157    42.015
   142.952    42.279
>
   143.157    42.015
   142.952    42.279
>
   142.467    42.410
   142.952    42.279
>
   143.362    42.614
   142.952    42.279
>
   143.362    42.614
   142.952    42.279
>
   142.364    42.778
   142.952    42.279
>
   141.921    42.623
   142.952    42.279
>
   143.835    42.903
   142.952    42.279
>
   142.594    43.164
   142.952    42.279
>
   142.753    42.280
   142.945    42.268
>
   142.753    42.280
   142.945    42.268
>
   143.299    42.291
   142.945    42.268
>
   143.299    42.291
   142.945    42.268
>
   143.157    42.015
   142.945    42.268
>
   143.157    42.015
   142.945    42.268
>
   143.157    42.016
   142.945    42.268
>
   142.467    42.410
   142.945    42.268
>
   143.362    42.614
   142.945    42.268
>
   143.362    42.614
   142.945    42.268
>
   142.364    42.778
   142.945    42.268
>
   141.921    42.623
   142.945    42.268
>
   143.835    42.903
   142.945    42.268
>
   143.835    42.903
   142.945    42.268
>
   142.594    43.164
   142.945    42.268
>
   143.299    42.291
   143.189    42.387
>
   143.299    42.291
   143.189    42.387
>
   143.362    42.614
   143.189    42.387
>
   143.362    42.614
   143.189    42.387
>
   142.753    42.280
   143.189    42.387
>
   142.753    42.280
   143.189    42.387
>
   143.157    42.016
   143.189    42.387
>
   142.467    42.410
   143.189    42.387
>
   143.835    42.903
   143.189    42.387
>
   141.921    42.623
   143.189    42.387
>
   142.753    42.280
   142.960    42.295
>
   142.753    42.280
   142.960    42.295
>
   143.299    42.291
   142.960    42.295
>
   143.299    42.291
   142.960    42.295
>
   143.157    42.015
   142.960    42.295
>
   143.157    42.015
   142.960    42.295
>
   143.157    42.016
   142.960    42.295
>
   143.157    42.016
   142.960    42.295
>
   142.467    42.410
   142.960    42.295
>
   142.467    42.410
   142.960    42.295
>
   143.362    42.614
   142.960    42.295
>
   143.362    42.614
   142.960    42.295
>
   142.364    42.778
   142.960    42.295
>
   141.921    42.623
   142.960    42.295
>
   141.921    42.623
   142.960    42.295
>
   143.835    42.903
   142.960    42.295
>
   142.594    43.164
   142.960    42.295
>
   143.299    42.291
   143.009    42.252
>
   143.299    42.291
   143.009    42.252
>
   142.753    42.280
   143.009    42.252
>
   143.157    42.016
   143.009    42.252
>
   143.157    42.016
   143.009    42.252
>
   143.362    42.614
   143.009    42.252
>
   143.362    42.614
   143.009    42.252
>
   142.467    42.410
   143.009    42.252
>
   142.467    42.410
   143.009    42.252
>
   142.364    42.778
   143.009    42.252
>
   143.835    42.903
   143.009    42.252
>
   143.835    42.903
   143.009    42.252
>
   141.921    42.623
   143.009    42.252
>
   142.594    43.164
   143.009    42.252
>
   143.299    42.291
   143.054    42.259
>
   143.299    42.291
   143.054    42.259
>
   143.157    42.016
   143.054    42.259
>
   143.157    42.015
   143.054    42.259
>
   142.753    42.280
   143.054    42.259
>
   142.753    42.280
   143.054    42.259
>
   143.362    42.614
   143.054    42.259
>
   143.362    42.614
   143.054    42.259
>
   142.467    42.410
   143.054    42.259
>
   142.467    42.410
   143.054    42.259
>
   143.835    42.903
   143.054    42.259
>
   143.835    42.903
   143.054    42.259
>
   141.921    42.623
   143.054    42.259
>
   142.594    43.164
   143.054    42.259
>
   143.299    42.291
   143.039    42.288
>
   143.299    42.291
   143.039    42.288
>
   142.753    42.280
   143.039    42.288
>
   143.157    42.016
   143.039    42.288
>
   143.157    42.015
   143.039    42.288
>
   143.157    42.015
   143.039    42.288
>
   143.157    42.015
   143.039    42.288
>
   143.157    42.015
   143.039    42.288
>
   143.362    42.614
   143.039    42.288
>
   143.362    42.614
   143.039    42.288
>
   142.467    42.410
   143.039    42.288
>
   142.364    42.778
   143.039    42.288
>
   143.835    42.903
   143.039    42.288
>
   143.835    42.903
   143.039    42.288
>
   141.921    42.623
   143.039    42.288
>
   142.594    43.164
   143.039    42.288
>
   143.299    42.291
   143.124    42.315
>
   143.157    42.015
   143.124    42.315
>
   143.157    42.015
   143.124    42.315
>
   143.157    42.016
   143.124    42.315
>
   142.753    42.280
   143.124    42.315
>
   142.753    42.280
   143.124    42.315
>
   143.362    42.614
   143.124    42.315
>
   143.362    42.614
   143.124    42.315
>
   142.467    42.410
   143.124    42.315
>
   142.364    42.778
   143.124    42.315
>
   143.835    42.903
   143.124    42.315
>
   142.594    43.164
   143.124    42.315
>
   141.921    42.623
   143.124    42.315
>
   143.299    42.291
   142.998    42.279
>
   143.299    42.291
   142.998    42.279
>
   142.753    42.280
   142.998    42.279
>
   142.753    42.280
   142.998    42.279
>
   143.157    42.016
   142.998    42.279
>
   143.157    42.016
   142.998    42.279
>
   143.157    42.015
   142.998    42.279
>
   143.157    42.015
   142.998    42.279
>
   143.362    42.614
   142.998    42.279
>
   143.362    42.614
   142.998    42.279
>
   142.467    42.410
   142.998    42.279
>
   142.467    42.410
   142.998    42.279
>
   142.364    42.778
   142.998    42.279
>
   142.364    42.778
   142.998    42.279
>
   143.835    42.903
   142.998    42.279
>
   143.835    42.903
   142.998    42.279
>
   141.921    42.623
   142.998    42.279
>
   142.594    43.164
   142.998    42.279
>
   142.753    42.280
   143.028    42.297
>
   142.753    42.280
   143.028    42.297
>
   143.157    42.015
   143.028    42.297
>
   143.157    42.015
   143.028    42.297
>
   143.157    42.016
   143.028    42.297
>
   143.362    42.614
   143.028    42.297
>
   142.467    42.410
   143.028    42.297
>
   142.467    42.410
   143.028    42.297
>
   142.364    42.778
   143.028    42.297
>
   142.364    42.778
   143.028    42.297
>
   143.835    42.903
   143.028    42.297
>
   143.835    42.903
   143.028    42.297
>
   141.921    42.623
   143.028    42.297
>
   142.594    43.164
   143.028    42.297
>
   142.753    42.280
   142.926    42.315
>
   142.753    42.280
   142.926    42.315
>
   143.299    42.291
   142.926    42.315
>
   143.299    42.291
   142.926    42.315
>
   143.157    42.016
   142.926    42.315
>
   143.157    42.016
   142.926    42.315
>
   142.467    42.410
   142.926    42.315
>
   142.467    42.410
   142.926    42.315
>
   143.362    42.614
   142.926    42.315
>
   143.362    42.614
   142.926    42.315
>
   142.364    42.778
   142.926    42.315
>
   142.364    42.778
   142.926    42.315
>
   141.921    42.623
   142.926    42.315
>
   143.835    42.903
   142.926    42.315
>
   142.594    43.164
   142.926    42.315
>
   143.299    42.291
   143.074    42.286
>
   143.299    42.291
   143.074    42.286
>
   142.753    42.280
   143.074    42.286
>
   142.753    42.280
   143.074    42.286
>
   143.157    42.015
   143.074    42.286
>
   143.157    42.015
   143.074    42.286
>
   143.157    42.016
   143.074    42.286
>
   143.157    42.016
   143.074    42.286
>
   143.157    42.016
   143.074    42.286
>
   143.362    42.614
   143.074    42.286
>
   143.362    42.614
   143.074    42.286
>
   142.467    42.410
   143.074    42.286
>
   142.467    42.410
   143.074    42.286
>
   142.364    42.778
   143.074    42.286
>
   142.364    42.778
   143.074    42.286
>
   143.835    42.903
   143.074    42.286
>
   143.835    42.903
   143.074    42.286
>
   141.921    42.623
   143.074    42.286
>
   142.594    43.164
   143.074    42.286
>
   141.450    42.840
   141.865    42.791
>
   141.450    42.840
   141.865    42.791
>
   142.364    42.778
   141.865    42.791
>
   142.364    42.778
   141.865    42.791
>
   142.467    42.410
   141.865    42.791
>
   141.417    43.275
   141.865    42.791
>
   141.417    43.275
   141.865    42.791
>
   141.038    42.469
   141.865    42.791
>
   141.038    42.469
   141.865    42.791
>
   142.223    43.505
   141.865    42.791
>
   142.223    43.505
   141.865    42.791
>
   142.753    42.280
   141.865    42.791
>
   141.725    43.743
   141.865    42.791
>
   141.921    42.623
   141.834    42.797
>
   141.921    42.623
   141.834    42.797
>
   141.450    42.840
   141.834    42.797
>
   142.364    42.778
   141.834    42.797
>
   142.364    42.778
   141.834    42.797
>
   142.467    42.410
   141.834    42.797
>
   142.467    42.410
   141.834    42.797
>
   142.594    43.164
   141.834    42.797
>
   141.038    42.469
   141.834    42.797
>
   141.038    42.469
   141.834    42.797
>
   142.223    43.505
   141.834    42.797
>
   142.753    42.280
   141.834    42.797
>
   141.725    43.743
   141.834    42.797
>
   142.753    42.280
   142.996    42.285
>
   142.753    42.280
   142.996    42.285
>
   143.299    42.291
   142.996    42.285
>
   143.299    42.291
   142.996    42.285
>
   143.157    42.016
   142.996    42.285
>
   143.157    42.016
   142.996    42.285
>
   143.157    42.015
   142.996    42.285
>
   142.467    42.410
   142.996    42.285
>
   143.362    42.614
   142.996    42.285
>
   143.362    42.614
   142.996    42.285
>
   142.364    42.778
   142.996    42.285
>
   142.364    42.778
   142.996    42.285
>
   143.835    42.903
   142.996    42.285
>
   141.921    42.623
   142.996    42.285
>
   142.594    43.164
   142.996    42.285
>
   143.835    42.903
   143.772    42.581
>
   143.835    42.903
   143.772    42.581
>
   143.362    42.614
   143.772    42.581
>
   143.362    42.614
   143.772    42.581
>
   143.299    42.291
   143.772    42.581
>
   143.299    42.291
   143.772    42.581
>
   143.770    43.297
   143.772    42.581
>
   143.770    43.297
   143.772    42.581
>
   143.157    42.016
   143.772    42.581
>
   143.157    42.015
   143.772    42.581
>
   143.157    42.015
   143.772    42.581
>
   144.842    43.017
   143.772    42.581
>
   144.842    43.017
   143.772    42.581
>
   142.753    42.280
   143.772    42.581
>
   142.753    42.280
   143.772    42.581
>
   143.299    42.291
   143.120    42.310
>
   143.299    42.291
   143.120    42.310
>
   142.753    42.280
   143.120    42.310
>
   142.753    42.280
   143.120    42.310
>
   143.157    42.016
   143.120    42.310
>
   143.157    42.016
   143.120    42.310
>
   143.362    42.614
   143.120    42.310
>
   143.362    42.614
   143.120    42.310
>
   142.467    42.410
   143.120    42.310
>
   142.364    42.778
   143.120    42.310
>
   143.835    42.903
   143.120    42.310
>
   143.835    42.903
   143.120    42.310
>
   141.921    42.623
   143.120    42.310
>
   142.594    43.164
   143.120    42.310
>
   142.753    42.280
   142.558    42.466
>
   142.753    42.280
   142.558    42.466
>
   142.364    42.778
   142.558    42.466
>
   142.364    42.778
   142.558    42.466
>
   141.921    42.623
   142.558    42.466
>
   143.157    42.016
   142.558    42.466
>
   143.362    42.614
   142.558    42.466
>
   143.362    42.614
   142.558    42.466
>
   142.594    43.164
   142.558    42.466
>
   141.450    42.840
   142.558    42.466
>
   141.450    42.840
   142.558    42.466
>
   143.362    42.614
   143.593    42.443
>
   143.362    42.614
   143.593    42.443
>
   143.299    42.291
   143.593    42.443
>
   143.299    42.291
   143.593    42.443
>
   143.835    42.903
   143.593    42.443
>
   143.835    42.903
   143.593    42.443
>
   143.157    42.016
   143.593    42.443
>
   143.157    42.015
   143.593    42.443
>
   142.753    42.280
   143.593    42.443
>
   142.753    42.280
   143.593    42.443
>
   142.467    42.410
   143.593    42.443
>
   143.770    43.297
   143.593    42.443
>
   144.697    42.996
   143.593    42.443
>
   144.697    42.996
   143.593    42.443
>
   142.364    42.778
   143.593    42.443
>
   143.299    42.291
   143.023    42.273
>
   142.753    42.280
   143.023    42.273
>
   142.753    42.280
   143.023    42.273
>
   143.157    42.016
   143.023    42.273
>
   143.157    42.016
   143.023    42.273
>
   143.157    42.015
   143.023    42.273
>
   143.157    42.015
   143.023    42.273
>
   143.362    42.614
   143.023    42.273
>
   143.362    42.614
   143.023    42.273
>
   142.467    42.410
   143.023    42.273
>
   142.467    42.410
   143.023    42.273
>
   142.364    42.778
   143.023    42.273
>
   142.364    42.778
   143.023    42.273
>
   143.835    42.903
   143.023    42.273
>
   141.921    42.623
   143.023    42.273
>
   142.594    43.164
   143.023    42.273
>
   141.921    42.623
   141.948    42.686
>
   141.921    42.623
   141.948    42.686
>
   142.364    42.778
   141.948    42.686
>
   142.467    42.410
   141.948    42.686
>
   141.450    42.840
   141.948    42.686
>
   141.450    42.840
   141.948    42.686
>
   142.753    42.280
   141.948    42.686
>
   142.594    43.164
   141.948    42.686
>
   141.038    42.469
   141.948    42.686
>
   141.038    42.469
   141.948    42.686
>
   141.417    43.275
   141.948    42.686
>
   142.223    43.505
   141.948    42.686
>
   141.921    42.623
   141.928    42.631
>
   141.921    42.623
   141.928    42.631
>
   142.364    42.778
   141.928    42.631
>
   141.450    42.840
   141.928    42.631
>
   141.450    42.840
   141.928    42.631
>
   142.467    42.410
   141.928    42.631
>
   141.038    42.469
   141.928    42.631
>
   141.038    42.469
   141.928    42.631
>
   142.753    42.280
   141.928    42.631
>
   142.594    43.164
   141.928    42.631
>
   141.417    43.275
   141.928    42.631
>
   141.417    43.275
   141.928    42.631
>
   142.223    43.505
   141.928    42.631
>
   142.223    43.505
   141.928    42.631
>
   141.033    41.888
   141.928    42.631
>
   141.033    41.888
   141.928    42.631
>
   141.921    42.623
   141.870    42.545
>
   141.921    42.623
   141.870    42.545
>
   142.364    42.778
   141.870    42.545
>
   142.364    42.778
   141.870    42.545
>
   142.467    42.410
   141.870    42.545
>
   142.467    42.410
   141.870    42.545
>
   141.450    42.840
   141.870    42.545
>
   142.753    42.280
   141.870    42.545
>
   142.753    42.280
   141.870    42.545
>
   141.038    42.469
   141.870    42.545
>
   141.038    42.469
   141.870    42.545
>
   142.594    43.164
   141.870    42.545
>
   141.417    43.275
   141.870    42.545
>
   141.417    43.275
   141.870    42.545
>
   142.223    43.505
   141.870    42.545
>
   141.921    42.623
   141.938    42.813
>
   141.921    42.623
   141.938    42.813
>
   142.364    42.778
   141.938    42.813
>
   142.364    42.778
   141.938    42.813
>
   141.450    42.840
   141.938    42.813
>
   141.450    42.840
   141.938    42.813
>
   142.467    42.410
   141.938    42.813
>
   142.594    43.164
   141.938    42.813
>
   142.594    43.164
   141.938    42.813
>
   141.417    43.275
   141.938    42.813
>
   141.417    43.275
   141.938    42.813
>
   142.223    43.505
   141.938    42.813
>
   142.223    43.505
   141.938    42.813
>
   141.038    42.469
   141.938    42.813
>
   141.038    42.469
   141.938    42.813
>
   142.753    42.280
   141.938    42.813
>
   141.725    43.743
   141.938    42.813
>
   141.921    42.623
   141.955    42.706
>
   142.364    42.778
   141.955    42.706
>
   142.364    42.778
   141.955    42.706
>
   141.450    42.840
   141.955    42.706
>
   141.450    42.840
   141.955    42.706
>
   142.467    42.410
   141.955    42.706
>
   142.467    42.410
   141.955    42.706
>
   142.594    43.164
   141.955    42.706
>
   141.417    43.275
   141.955    42.706
>
   141.417    43.275
   141.955    42.706
>
   142.753    42.280
   141.955    42.706
>
   141.038    42.469
   141.955    42.706
>
   141.038    42.469
   141.955    42.706
>
   142.223    43.505
   141.955    42.706
>
   142.223    43.505
   141.955    42.706
>
   141.921    42.623
   141.975    42.725
>
   141.921    42.623
   141.975    42.725
>
   142.364    42.778
   141.975    42.725
>
   142.364    42.778
   141.975    42.725
>
   141.450    42.840
   141.975    42.725
>
   141.450    42.840
   141.975    42.725
>
   142.594    43.164
   141.975    42.725
>
   141.417    43.275
   141.975    42.725
>
   141.417    43.275
   141.975    42.725
>
   141.038    42.469
   141.975    42.725
>
   141.038    42.469
   141.975    42.725
>
   142.223    43.505
   141.975    42.725
>
   141.921    42.623
   141.916    42.702
>
   141.921    42.623
   141.916    42.702
>
   142.364    42.778
   141.916    42.702
>
   142.364    42.778
   141.916    42.702
>
   141.450    42.840
   141.916    42.702
>
   141.450    42.840
   141.916    42.702
>
   142.467    42.410
   141.916    42.702
>
   142.467    42.410
   141.916    42.702
>
   142.594    43.164
   141.916    42.702
>
   141.038    42.469
   141.916    42.702
>
   141.038    42.469
   141.916    42.702
>
   141.417    43.275
   141.916    42.702
>
   141.417    43.275
   141.916    42.702
>
   142.753    42.280
   141.916    42.702
>
   142.753    42.280
   141.916    42.702
>
   142.223    43.505
   141.916    42.702
>
   142.223    43.505
   141.916    42.702
>
   141.921    42.623
   141.949    42.683
>
   141.921    42.623
   141.949    42.683
>
   142.364    42.778
   141.949    42.683
>
   142.364    42.778
   141.949    42.683
>
   141.450    42.840
   141.949    42.683
>
   141.450    42.840
   141.949    42.683
>
   142.467    42.410
   141.949    42.683
>
   142.594    43.164
   141.949    42.683
>
   141.038    42.469
   141.949    42.683
>
   141.038    42.469
   141.949    42.683
>
   142.753    42.280
   141.949    42.683
>
   141.417    43.275
   141.949    42.683
>
   141.417    43.275
   141.949    42.683
>
   142.223    43.505
   141.949    42.683
>
   141.921    42.623
   141.944    42.646
>
   142.364    42.778
   141.944    42.646
>
   142.364    42.778
   141.944    42.646
>
   142.467    42.410
   141.944    42.646
>
   141.450    42.840
   141.944    42.646
>
   141.450    42.840
   141.944    42.646
>
   142.753    42.280
   141.944    42.646
>
   142.753    42.280
   141.944    42.646
>
   142.594    43.164
   141.944    42.646
>
   141.038    42.469
   141.944    42.646
>
   141.417    43.275
   141.944    42.646
>
   141.417    43.275
   141.944    42.646
>
   142.223    43.505
   141.944    42.646
>
   142.223    43.505
   141.944    42.646
>
   141.921    42.623
   141.928    42.606
>
   142.364    42.778
   141.928    42.606
>
   142.364    42.778
   141.928    42.606
>
   142.467    42.410
   141.928    42.606
>
   141.450    42.840
   141.928    42.606
>
   141.450    42.840
   141.928    42.606
>
   142.753    42.280
   141.928    42.606
>
   141.038    42.469
   141.928    42.606
>
   141.038    42.469
   141.928    42.606
>
   142.594    43.164
   141.928    42.606
>
   141.417    43.275
   141.928    42.606
>
   141.417    43.275
   141.928    42.606
>
   142.223    43.505
   141.928    42.606
>
   142.223    43.505
   141.928    42.606
>
   141.033    41.888
   141.928    42.606
>
   141.033    41.888
   141.928    42.606
>
   141.921    42.623
   141.958    42.693
>
   141.921    42.623
   141.958    42.693
>
   142.364    42.778
   141.958    42.693
>
   142.364    42.778
   141.958    42.693
>
   141.450    42.840
   141.958    42.693
>
   141.450    42.840
   141.958    42.693
>
   142.467    42.410
   141.958    42.693
>
   142.594    43.164
   141.958    42.693
>
   142.594    43.164
   141.958    42.693
>
   142.753    42.280
   141.958    42.693
>
   142.753    42.280
   141.958    42.693
>
   141.038    42.469
   141.958    42.693
>
   141.038    42.469
   141.958    42.693
>
   141.417    43.275
   141.958    42.693
>
   141.417    43.275
   141.958    42.693
>
   142.223    43.505
   141.958    42.693
>
   141.921    42.623
   141.953    42.662
>
   141.921    42.623
   141.953    42.662
>
   142.364    42.778
   141.953    42.662
>
   142.364    42.778
   141.953    42.662
>
   142.467    42.410
   141.953    42.662
>
   142.467    42.410
   141.953    42.662
>
   141.450    42.840
   141.953    42.662
>
   141.450    42.840
   141.953    42.662
>
   142.753    42.280
   141.953    42.662
>
   142.594    43.164
   141.953    42.662
>
   141.038    42.469
   141.953    42.662
>
   141.038    42.469
   141.953    42.662
>
   141.417    43.275
   141.953    42.662
>
   141.417    43.275
   141.953    42.662
>
   142.223    43.505
   141.953    42.662
>
   142.223    43.505
   141.953    42.662
>
   141.921    42.623
   141.976    42.680
>
   142.364    42.778
   141.976    42.680
>
   142.364    42.778
   141.976    42.680
>
   141.450    42.840
   141.976    42.680
>
   141.450    42.840
   141.976    42.680
>
   142.467    42.410
   141.976    42.680
>
   142.594    43.164
   141.976    42.680
>
   142.753    42.280
   141.976    42.680
>
   141.417    43.275
   141.976    42.680
>
   141.417    43.275
   141.976    42.680
>
   141.038    42.469
   141.976    42.680
>
   141.038    42.469
   141.976    42.680
>
   141.921    42.623
   141.924    42.611
>
   141.921    42.623
   141.924    42.611
>
   142.364    42.778
   141.924    42.611
>
   142.364    42.778
   141.924    42.611
>
   141.450    42.840
   141.924    42.611
>
   141.450    42.840
   141.924    42.611
>
   142.753    42.280
   141.924    42.611
>
   141.038    42.469
   141.924    42.611
>
   141.038    42.469
   141.924    42.611
>
   142.594    43.164
   141.924    42.611
>
   141.417    43.275
   141.924    42.611
>
   141.417    43.275
   141.924    42.611
>
   142.223    43.505
   141.924    42.611
>
   141.033    41.888
   141.924    42.611
>
   141.033    41.888
   141.924    42.611
>
   141.921    42.623
   141.954    42.807
>
   141.921    42.623
   141.954    42.807
>
   142.364    42.778
   141.954    42.807
>
   142.364    42.778
   141.954    42.807
>
   141.450    42.840
   141.954    42.807
>
   141.450    42.840
   141.954    42.807
>
   142.594    43.164
   141.954    42.807
>
   141.417    43.275
   141.954    42.807
>
   141.417    43.275
   141.954    42.807
>
   141.038    42.469
   141.954    42.807
>
   141.038    42.469
   141.954    42.807
>
   142.223    43.505
   141.954    42.807
>
   142.223    43.505
   141.954    42.807
>
   141.725    43.743
   141.954    42.807
>
   141.725    43.743
   141.954    42.807
>
   141.921    42.623
   141.932    42.618
>
   141.921    42.623
   141.932    42.618
>
   142.364    42.778
   141.932    42.618
>
   142.364    42.778
   141.932    42.618
>
   142.467    42.410
   141.932    42.618
>
   142.467    42.410
   141.932    42.618
>
   141.450    42.840
   141.932    42.618
>
   141.450    42.840
   141.932    42.618
>
   142.753    42.280
   141.932    42.618
>
   142.753    42.280
   141.932    42.618
>
   141.038    42.469
   141.932    42.618
>
   141.038    42.469
   141.932    42.618
>
   142.594    43.164
   141.932    42.618
>
   141.417    43.275
   141.932    42.618
>
   141.417    43.275
   141.932    42.618
>
   142.223    43.505
   141.932    42.618
>
   142.223    43.505
   141.932    42.618
>
   141.033    41.888
   141.932    42.618
>
   141.033    41.888
   141.932    42.618
>
   141.921    42.623
   141.946    42.650
>
   141.921    42.623
   141.946    42.650
>
   142.364    42.778
   141.946    42.650
>
   142.364    42.778
   141.946    42.650
>
   142.467    42.410
   141.946    42.650
>
   142.467    42.410
   141.946    42.650
>
   141.450    42.840
   141.946    42.650
>
   141.450    42.840
   141.946    42.650
>
   142.753    42.280
   141.946    42.650
>
   142.753    42.280
   141.946    42.650
>
   142.594    43.164
   141.946    42.650
>
   141.038    42.469
   141.946    42.650
>
   141.038    42.469
   141.946    42.650
>
   141.417    43.275
   141.946    42.650
>
   141.417    43.275
   141.946    42.650
>
   142.223    43.505
   141.946    42.650
>
   142.223    43.505
   141.946    42.650
>
   141.921    42.623
   141.925    42.668
>
   141.921    42.623
   141.925    42.668
>
   142.364    42.778
   141.925    42.668
>
   142.364    42.778
   141.925    42.668
>
   141.450    42.840
   141.925    42.668
>
   141.450    42.840
   141.925    42.668
>
   142.467    42.410
   141.925    42.668
>
   142.467    42.410
   141.925    42.668
>
   142.594    43.164
   141.925    42.668
>
   142.753    42.280
   141.925    42.668
>
   142.753    42.280
   141.925    42.668
>
   141.038    42.469
   141.925    42.668
>
   141.038    42.469
   141.925    42.668
>
   141.417    43.275
   141.925    42.668
>
   141.417    43.275
   141.925    42.668
>
   142.223    43.505
   141.925    42.668
>
   141.921    42.623
   141.947    42.810
>
   142.364    42.778
   141.947    42.810
>
   142.364    42.778
   141.947    42.810
>
   141.450    42.840
   141.947    42.810
>
   141.450    42.840
   141.947    42.810
>
   142.467    42.410
   141.947    42.810
>
   142.594    43.164
   141.947    42.810
>
   141.417    43.275
   141.947    42.810
>
   141.417    43.275
   141.947    42.810
>
   141.038    42.469
   141.947    42.810
>
   141.038    42.469
   141.947    42.810
>
   142.223    43.505
   141.947    42.810
>
   142.223    43.505
   141.947    42.810
>
   142.753    42.280
   141.947    42.810
>
   141.725    43.743
   141.947    42.810
>
   141.725    43.743
   141.947    42.810
>
   141.921    42.623
   141.921    42.610
>
   142.364    42.778
   141.921    42.610
>
   142.364    42.778
   141.921    42.610
>
   142.467    42.410
   141.921    42.610
>
   142.467    42.410
   141.921    42.610
>
   141.450    42.840
   141.921    42.610
>
   141.450    42.840
   141.921    42.610
>
   142.753    42.280
   141.921    42.610
>
   142.753    42.280
   141.921    42.610
>
   141.038    42.469
   141.921    42.610
>
   141.038    42.469
   141.921    42.610
>
   142.594    43.164
   141.921    42.610
>
   141.417    43.275
   141.921    42.610
>
   141.417    43.275
   141.921    42.610
>
   142.223    43.505
   141.921    42.610
>
   142.223    43.505
   141.921    42.610
>
   141.033    41.888
   141.921    42.610
>
   141.033    41.888
   141.921    42.610
>
   141.921    42.623
   141.935    42.698
>
   141.921    42.623
   141.935    42.698
>
   142.364    42.778
   141.935    42.698
>
   142.364    42.778
   141.935    42.698
>
   141.450    42.840
   141.935    42.698
>
   141.450    42.840
   141.935    42.698
>
   142.467    42.410
   141.935    42.698
>
   142.467    42.410
   141.935    42.698
>
   142.594    43.164
   141.935    42.698
>
   142.594    43.164
   141.935    42.698
>
   142.753    42.280
   141.935    42.698
>
   141.417    43.275
   141.935    42.698
>
   141.417    43.275
   141.935    42.698
>
   141.038    42.469
   141.935    42.698
>
   141.038    42.469
   141.935    42.698
>
   142.223    43.505
   141.935    42.698
>
   142.223    43.505
   141.935    42.698
>
   141.921    42.623
   141.910    42.703
>
   141.921    42.623
   141.910    42.703
>
   142.364    42.778
   141.910    42.703
>
   142.364    42.778
   141.910    42.703
>
   141.450    42.840
   141.910    42.703
>
   141.450    42.840
   141.910    42.703
>
   142.467    42.410
   141.910    42.703
>
   142.594    43.164
   141.910    42.703
>
   141.038    42.469
   141.910    42.703
>
   141.038    42.469
   141.910    42.703
>
   141.417    43.275
   141.910    42.703
>
   141.417    43.275
   141.910    42.703
>
   142.753    42.280
   141.910    42.703
>
   142.223    43.505
   141.910    42.703
>
   142.223    43.505
   141.910    42.703
>
   141.921    42.623
   141.917    42.606
>
   141.921    42.623
   141.917    42.606
>
   142.364    42.778
   141.917    42.606
>
   142.364    42.778
   141.917    42.606
>
   142.467    42.410
   141.917    42.606
>
   142.467    42.410
   141.917    42.606
>
   141.450    42.840
   141.917    42.606
>
   142.753    42.280
   141.917    42.606
>
   142.753    42.280
   141.917    42.606
>
   141.038    42.469
   141.917    42.606
>
   141.038    42.469
   141.917    42.606
>
   142.594    43.164
   141.917    42.606
>
   141.417    43.275
   141.917    42.606
>
   141.417    43.275
   141.917    42.606
>
   142.223    43.505
   141.917    42.606
>
   142.223    43.505
   141.917    42.606
>
   141.033    41.888
   141.917    42.606
>
   141.033    41.888
   141.917    42.606
>
   141.921    42.623
   141.914    42.595
>
   141.921    42.623
   141.914    42.595
>
   142.364    42.778
   141.914    42.595
>
   142.364    42.778
   141.914    42.595
>
   142.467    42.410
   141.914    42.595
>
   142.467    42.410
   141.914    42.595
>
   141.450    42.840
   141.914    42.595
>
   141.450    42.840
   141.914    42.595
>
   142.753    42.280
   141.914    42.595
>
   142.753    42.280
   141.914    42.595
>
   141.038    42.469
   141.914    42.595
>
   141.038    42.469
   141.914    42.595
>
   142.594    43.164
   141.914    42.595
>
   141.417    43.275
   141.914    42.595
>
   141.417    43.275
   141.914    42.595
>
   141.033    41.888
   141.914    42.595
>
   141.033    41.888
   141.914    42.595
>
   142.223    43.505
   141.914    42.595
>
   142.223    43.505
   141.914    42.595
>
   141.921    42.623
   141.940    42.793
>
   141.921    42.623
   141.940    42.793
>
   142.364    42.778
   141.940    42.793
>
   142.364    42.778
   141.940    42.793
>
   141.450    42.840
   141.940    42.793
>
   141.450    42.840
   141.940    42.793
>
   142.467    42.410
   141.940    42.793
>
   142.467    42.410
   141.940    42.793
>
   142.594    43.164
   141.940    42.793
>
   141.417    43.275
   141.940    42.793
>
   141.417    43.275
   141.940    42.793
>
   142.223    43.505
   141.940    42.793
>
   142.223    43.505
   141.940    42.793
>
   141.038    42.469
   141.940    42.793
>
   141.038    42.469
   141.940    42.793
>
   142.753    42.280
   141.940    42.793
>
   142.753    42.280
   141.940    42.793
>
   141.725    43.743
   141.940    42.793
>
   141.725    43.743
   141.940    42.793
>
   141.921    42.623
   141.934    42.696
>
   141.921    42.623
   141.934    42.696
>
   142.364    42.778
   141.934    42.696
>
   142.364    42.778
   141.934    42.696
>
   142.467    42.410
   141.934    42.696
>
   142.467    42.410
   141.934    42.696
>
   141.450    42.840
   141.934    42.696
>
   141.450    42.840
   141.934    42.696
>
   142.594    43.164
   141.934    42.696
>
   142.753    42.280
   141.934    42.696
>
   141.038    42.469
   141.934    42.696
>
   141.038    42.469
   141.934    42.696
>
   141.417    43.275
   141.934    42.696
>
   141.417    43.275
   141.934    42.696
>
   142.223    43.505
   141.934    42.696
>
   142.223    43.505
   141.934    42.696
>
   141.921    42.623
   142.102    42.743
>
   141.921    42.623
   142.102    42.743
>
   142.364    42.778
   142.102    42.743
>
   141.417    43.275
   142.102    42.743
>
   142.223    43.505
   142.102    42.743
>
   142.223    43.505
   142.102    42.743
>
   141.038    42.469
   142.102    42.743
>
   141.921    42.623
   141.918    42.615
>
   141.921    42.623
   141.918    42.615
>
   142.364    42.778
   141.918    42.615
>
   142.364    42.778
   141.918    42.615
>
   142.467    42.410
   141.918    42.615
>
   142.467    42.410
   141.918    42.615
>
   141.450    42.840
   141.918    42.615
>
   141.450    42.840
   141.918    42.615
>
   141.038    42.469
   141.918    42.615
>
   141.038    42.469
   141.918    42.615
>
   142.753    42.280
   141.918    42.615
>
   142.753    42.280
   141.918    42.615
>
   142.594    43.164
   141.918    42.615
>
   142.594    43.164
   141.918    42.615
>
   141.417    43.275
   141.918    42.615
>
   141.417    43.275
   141.918    42.615
>
   141.033    41.888
   141.918    42.615
>
   141.033    41.888
   141.918    42.615
>
   142.223    43.505
   141.918    42.615
>
   142.223    43.505
   141.918    42.615
>
   141.921    42.623
   141.932    42.731
>
   141.921    42.623
   141.932    42.731
>
   142.364    42.778
   141.932    42.731
>
   142.364    42.778
   141.932    42.731
>
   141.450    42.840
   141.932    42.731
>
   141.450    42.840
   141.932    42.731
>
   142.467    42.410
   141.932    42.731
>
   142.594    43.164
   141.932    42.731
>
   141.038    42.469
   141.932    42.731
>
   141.038    42.469
   141.932    42.731
>
   142.753    42.280
   141.932    42.731
>
   142.753    42.280
   141.932    42.731
>
   141.417    43.275
   141.932    42.731
>
   141.417    43.275
   141.932    42.731
>
   142.223    43.505
   141.932    42.731
>
   142.223    43.505
   141.932    42.731
>
   141.921    42.623
   141.927    42.610
>
   141.921    42.623
   141.927    42.610
>
   142.364    42.778
   141.927    42.610
>
   142.364    42.778
   141.927    42.610
>
   142.467    42.410
   141.927    42.610
>
   142.467    42.410
   141.927    42.610
>
   141.450    42.840
   141.927    42.610
>
   141.450    42.840
   141.927    42.610
>
   141.038    42.469
   141.927    42.610
>
   141.038    42.469
   141.927    42.610
>
   142.753    42.280
   141.927    42.610
>
   142.753    42.280
   141.927    42.610
>
   142.594    43.164
   141.927    42.610
>
   142.594    43.164
   141.927    42.610
>
   141.417    43.275
   141.927    42.610
>
   141.417    43.275
   141.927    42.610
>
   141.033    41.888
   141.927    42.610
>
   141.033    41.888
   141.927    42.610
>
   142.223    43.505
   141.927    42.610
>
   142.364    42.778
   141.916    42.593
>
   142.467    42.410
   141.916    42.593
>
   142.467    42.410
   141.916    42.593
>
   141.450    42.840
   141.916    42.593
>
   141.450    42.840
   141.916    42.593
>
   141.038    42.469
   141.916    42.593
>
   141.038    42.469
   141.916    42.593
>
   142.594    43.164
   141.916    42.593
>
   141.417    43.275
   141.916    42.593
>
   141.417    43.275
   141.916    42.593
>
   142.223    43.505
   141.916    42.593
>
   142.223    43.505
   141.916    42.593
>
   141.033    41.888
   141.916    42.593
>
   141.033    41.888
   141.916    42.593
>
   141.921    42.623
   141.941    42.724
>
   141.921    42.623
   141.941    42.724
>
   142.364    42.778
   141.941    42.724
>
   142.364    42.778
   141.941    42.724
>
   141.450    42.840
   141.941    42.724
>
   141.450    42.840
   141.941    42.724
>
   142.467    42.410
   141.941    42.724
>
   142.467    42.410
   141.941    42.724
>
   141.038    42.469
   141.941    42.724
>
   141.038    42.469
   141.941    42.724
>
   142.594    43.164
   141.941    42.724
>
   142.594    43.164
   141.941    42.724
>
   141.417    43.275
   141.941    42.724
>
   141.417    43.275
   141.941    42.724
>
   142.223    43.505
   141.941    42.724
>
   142.223    43.505
   141.941    42.724
>
   141.921    42.623
   141.970    42.747
>
   141.921    42.623
   141.970    42.747
>
   142.364    42.778
   141.970    42.747
>
   142.364    42.778
   141.970    42.747
>
   141.450    42.840
   141.970    42.747
>
   141.450    42.840
   141.970    42.747
>
   142.467    42.410
   141.970    42.747
>
   142.467    42.410
   141.970    42.747
>
   142.594    43.164
   141.970    42.747
>
   141.417    43.275
   141.970    42.747
>
   141.417    43.275
   141.970    42.747
>
   142.753    42.280
   141.970    42.747
>
   142.753    42.280
   141.970    42.747
>
   141.038    42.469
   141.970    42.747
>
   141.038    42.469
   141.970    42.747
>
   142.223    43.505
   141.970    42.747
>
   142.223    43.505
   141.970    42.747
>
   141.921    42.623
   141.938    42.679
>
   141.921    42.623
   141.938    42.679
>
   142.364    42.778
   141.938    42.679
>
   142.364    42.778
   141.938    42.679
>
   141.450    42.840
   141.938    42.679
>
   141.450    42.840
   141.938    42.679
>
   142.467    42.410
   141.938    42.679
>
   142.467    42.410
   141.938    42.679
>
   142.594    43.164
   141.938    42.679
>
   142.753    42.280
   141.938    42.679
>
   142.753    42.280
   141.938    42.679
>
   141.038    42.469
   141.938    42.679
>
   141.038    42.469
   141.938    42.679
>
   141.417    43.275
   141.938    42.679
>
   141.417    43.275
   141.938    42.679
>
   142.223    43.505
   141.938    42.679
>
   142.223    43.505
   141.938    42.679
>
   141.921    42.623
   141.925    42.707
>
   141.921    42.623
   141.925    42.707
>
   142.364    42.778
   141.925    42.707
>
   142.364    42.778
   141.925    42.707
>
   141.450    42.840
   141.925    42.707
>
   141.450    42.840
   141.925    42.707
>
   142.467    42.410
   141.925    42.707
>
   142.467    42.410
   141.925    42.707
>
   141.038    42.469
   141.925    42.707
>
   141.038    42.469
   141.925    42.707
>
   142.594    43.164
   141.925    42.707
>
   142.753    42.280
   141.925    42.707
>
   142.753    42.280
   141.925    42.707
>
   141.417    43.275
   141.925    42.707
>
   141.417    43.275
   141.925    42.707
>
   142.223    43.505
   141.925    42.707
>
   142.223    43.505
   141.925    42.707
>
   141.921    42.623
   141.972    42.786
>
   141.921    42.623
   141.972    42.786
>
   142.364    42.778
   141.972    42.786
>
   142.364    42.778
   141.972    42.786
>
   141.450    42.840
   141.972    42.786
>
   141.450    42.840
   141.972    42.786
>
   142.467    42.410
   141.972    42.786
>
   142.467    42.410
   141.972    42.786
>
   142.594    43.164
   141.972    42.786
>
   142.594    43.164
   141.972    42.786
>
   141.417    43.275
   141.972    42.786
>
   141.417    43.275
   141.972    42.786
>
   142.223    43.505
   141.972    42.786
>
   142.223    43.505
   141.972    42.786
>
   142.753    42.280
   141.972    42.786
>
   142.753    42.280
   141.972    42.786
>
   141.038    42.469
   141.972    42.786
>
   141.038    42.469
   141.972    42.786
>
   141.725    43.743
   141.972    42.786
>
   141.725    43.743
   141.972    42.786
>
   141.921    42.623
   141.968    42.724
>
   141.921    42.623
   141.968    42.724
>
   142.364    42.778
   141.968    42.724
>
   142.364    42.778
   141.968    42.724
>
   141.450    42.840
   141.968    42.724
>
   141.450    42.840
   141.968    42.724
>
   142.467    42.410
   141.968    42.724
>
   142.467    42.410
   141.968    42.724
>
   142.594    43.164
   141.968    42.724
>
   142.753    42.280
   141.968    42.724
>
   142.753    42.280
   141.968    42.724
>
   141.417    43.275
   141.968    42.724
>
   141.417    43.275
   141.968    42.724
>
   141.038    42.469
   141.968    42.724
>
   141.038    42.469
   141.968    42.724
>
   142.223    43.505
   141.968    42.724
>
   142.223    43.505
   141.968    42.724
>
   141.921    42.623
   141.941    42.671
>
   141.921    42.623
   141.941    42.671
>
   142.364    42.778
   141.941    42.671
>
   142.364    42.778
   141.941    42.671
>
   142.467    42.410
   141.941    42.671
>
   141.450    42.840
   141.941    42.671
>
   141.450    42.840
   141.941    42.671
>
   142.753    42.280
   141.941    42.671
>
   142.594    43.164
   141.941    42.671
>
   141.038    42.469
   141.941    42.671
>
   141.038    42.469
   141.941    42.671
>
   141.417    43.275
   141.941    42.671
>
   141.417    43.275
   141.941    42.671
>
   142.223    43.505
   141.941    42.671
>
   142.223    43.505
   141.941    42.671
>
   141.921    42.623
   142.121    42.770
>
   142.223    43.505
   142.121    42.770
>
   141.921    42.623
   141.939    42.684
>
   141.921    42.623
   141.939    42.684
>
   142.364    42.778
   141.939    42.684
>
   142.364    42.778
   141.939    42.684
>
   141.450    42.840
   141.939    42.684
>
   141.450    42.840
   141.939    42.684
>
   142.467    42.410
   141.939    42.684
>
   142.467    42.410
   141.939    42.684
>
   142.594    43.164
   141.939    42.684
>
   142.753    42.280
   141.939    42.684
>
   141.417    43.275
   141.939    42.684
>
   141.417    43.275
   141.939    42.684
>
   141.038    42.469
   141.939    42.684
>
   141.038    42.469
   141.939    42.684
>
   142.223    43.505
   141.939    42.684
>
   142.223    43.505
   141.939    42.684
>
   141.921    42.623
   141.916    42.594
>
   141.921    42.623
   141.916    42.594
>
   142.364    42.778
   141.916    42.594
>
   142.364    42.778
   141.916    42.594
>
   142.467    42.410
   141.916    42.594
>
   141.450    42.840
   141.916    42.594
>
   141.450    42.840
   141.916    42.594
>
   142.753    42.280
   141.916    42.594
>
   141.038    42.469
   141.916    42.594
>
   141.038    42.469
   141.916    42.594
>
   142.594    43.164
   141.916    42.594
>
   142.594    43.164
   141.916    42.594
>
   141.417    43.275
   141.916    42.594
>
   141.417    43.275
   141.916    42.594
>
   141.033    41.888
   141.916    42.594
>
   141.033    41.888
   141.916    42.594
>
   142.223    43.505
   141.916    42.594
>
   142.223    43.505
   141.916    42.594
>
   141.921    42.623
   141.956    42.707
>
   141.921    42.623
   141.956    42.707
>
   142.364    42.778
   141.956    42.707
>
   142.364    42.778
   141.956    42.707
>
   141.450    42.840
   141.956    42.707
>
   141.450    42.840
   141.956    42.707
>
   142.467    42.410
   141.956    42.707
>
   142.467    42.410
   141.956    42.707
>
   142.594    43.164
   141.956    42.707
>
   142.753    42.280
   141.956    42.707
>
   142.753    42.280
   141.956    42.707
>
   141.417    43.275
   141.956    42.707
>
   141.417    43.275
   141.956    42.707
>
   141.038    42.469
   141.956    42.707
>
   141.038    42.469
   141.956    42.707
>
   142.223    43.505
   141.956    42.707
>
   142.223    43.505
   141.956    42.707
>
   141.921    42.623
   141.886    42.734
>
   142.364    42.778
   141.886    42.734
>
   141.450    42.840
   141.886    42.734
>
   141.450    42.840
   141.886    42.734
>
   142.467    42.410
   141.886    42.734
>
   142.594    43.164
   141.886    42.734
>
   141.038    42.469
   141.886    42.734
>
   141.038    42.469
   141.886    42.734
>
   142.223    43.505
   141.886    42.734
>
   142.753    42.280
   141.886    42.734
>
   141.921    42.623
   141.959    42.817
>
   141.921    42.623
   141.959    42.817
>
   142.364    42.778
   141.959    42.817
>
   142.364    42.778
   141.959    42.817
>
   141.450    42.840
   141.959    42.817
>
   141.450    42.840
   141.959    42.817
>
   142.467    42.410
   141.959    42.817
>
   142.467    42.410
   141.959    42.817
>
   142.594    43.164
   141.959    42.817
>
   142.594    43.164
   141.959    42.817
>
   141.417    43.275
   141.959    42.817
>
   141.417    43.275
   141.959    42.817
>
   142.223    43.505
   141.959    42.817
>
   142.753    42.280
   141.959    42.817
>
   141.038    42.469
   141.959    42.817
>
   141.038    42.469
   141.959    42.817
>
   141.725    43.743
   141.959    42.817
>
   141.921    42.623
   141.943    42.678
>
   141.921    42.623
   141.943    42.678
>
   142.364    42.778
   141.943    42.678
>
   142.364    42.778
   141.943    42.678
>
   141.450    42.840
   141.943    42.678
>
   141.450    42.840
   141.943    42.678
>
   142.467    42.410
   141.943    42.678
>
   142.467    42.410
   141.943    42.678
>
   142.594    43.164
   141.943    42.678
>
   142.753    42.280
   141.943    42.678
>
   141.038    42.469
   141.943    42.678
>
   141.038    42.469
   141.943    42.678
>
   141.417    43.275
   141.943    42.678
>
   141.417    43.275
   141.943    42.678
>
   142.223    43.505
   141.943    42.678
>
   142.223    43.505
   141.943    42.678
>
   141.921    42.623
   141.921    42.614
>
   141.921    42.623
   141.921    42.614
>
   142.364    42.778
   141.921    42.614
>
   142.364    42.778
   141.921    42.614
>
   142.467    42.410
   141.921    42.614
>
   141.450    42.840
   141.921    42.614
>
   141.450    42.840
   141.921    42.614
>
   142.753    42.280
   141.921    42.614
>
   141.038    42.469
   141.921    42.614
>
   141.038    42.469
   141.921    42.614
>
   142.594    43.164
   141.921    42.614
>
   141.417    43.275
   141.921    42.614
>
   141.417    43.275
   141.921    42.614
>
   142.223    43.505
   141.921    42.614
>
   142.223    43.505
   141.921    42.614
>
   141.033    41.888
   141.921    42.614
>
   141.033    41.888
   141.921    42.614
>
   141.921    42.623
   141.971    42.720
>
   141.921    42.623
   141.971    42.720
>
   142.364    42.778
   141.971    42.720
>
   142.364    42.778
   141.971    42.720
>
   141.450    42.840
   141.971    42.720
>
   141.450    42.840
   141.971    42.720
>
   142.467    42.410
   141.971    42.720
>
   142.594    43.164
   141.971    42.720
>
   142.753    42.280
   141.971    42.720
>
   142.753    42.280
   141.971    42.720
>
   141.417    43.275
   141.971    42.720
>
   141.417    43.275
   141.971    42.720
>
   141.038    42.469
   141.971    42.720
>
   141.038    42.469
   141.971    42.720
>
   142.223    43.505
   141.971    42.720
>
   141.921    42.623
   141.936    42.700
>
   141.921    42.623
   141.936    42.700
>
   142.364    42.778
   141.936    42.700
>
   142.364    42.778
   141.936    42.700
>
   141.450    42.840
   141.936    42.700
>
   141.450    42.840
   141.936    42.700
>
   142.467    42.410
   141.936    42.700
>
   142.467    42.410
   141.936    42.700
>
   142.594    43.164
   141.936    42.700
>
   141.038    42.469
   141.936    42.700
>
   141.038    42.469
   141.936    42.700
>
   142.753    42.280
   141.936    42.700
>
   141.417    43.275
   141.936    42.700
>
   141.417    43.275
   141.936    42.700
>
   142.223    43.505
   141.936    42.700
>
   142.223    43.505
   141.936    42.700
>
   141.921    42.623
   141.928    42.671
>
   141.921    42.623
   141.928    42.671
>
   142.364    42.778
   141.928    42.671
>
   142.364    42.778
   141.928    42.671
>
   141.450    42.840
   141.928    42.671
>
   141.450    42.840
   141.928    42.671
>
   142.467    42.410
   141.928    42.671
>
   142.467    42.410
   141.928    42.671
>
   142.753    42.280
   141.928    42.671
>
   142.594    43.164
   141.928    42.671
>
   141.038    42.469
   141.928    42.671
>
   141.038    42.469
   141.928    42.671
>
   141.417    43.275
   141.928    42.671
>
   141.417    43.275
   141.928    42.671
>
   142.223    43.505
   141.928    42.671
>
   141.921    42.623
   141.941    42.801
>
   141.921    42.623
   141.941    42.801
>
   142.364    42.778
   141.941    42.801
>
   142.364    42.778
   141.941    42.801
>
   141.450    42.840
   141.941    42.801
>
   141.450    42.840
   141.941    42.801
>
   142.467    42.410
   141.941    42.801
>
   142.467    42.410
   141.941    42.801
>
   141.417    43.275
   141.941    42.801
>
   141.417    43.275
   141.941    42.801
>
   142.594    43.164
   141.941    42.801
>
   142.223    43.505
   141.941    42.801
>
   142.223    43.505
   141.941    42.801
>
   141.038    42.469
   141.941    42.801
>
   141.038    42.469
   141.941    42.801
>
   142.753    42.280
   141.941    42.801
>
   142.753    42.280
   141.941    42.801
>
   141.725    43.743
   141.941    42.801
>
   141.725    43.743
   141.941    42.801
>
   141.921    42.623
   141.937    42.611
>
   141.921    42.623
   141.937    42.611
>
   142.364    42.778
   141.937    42.611
>
   142.364    42.778
   141.937    42.611
>
   142.467    42.410
   141.937    42.611
>
   141.450    42.840
   141.937    42.611
>
   141.450    42.840
   141.937    42.611
>
   142.753    42.280
   141.937    42.611
>
   141.038    42.469
   141.937    42.611
>
   141.038    42.469
   141.937    42.611
>
   142.594    43.164
   141.937    42.611
>
   141.417    43.275
   141.937    42.611
>
   141.417    43.275
   141.937    42.611
>
   142.223    43.505
   141.937    42.611
>
   141.033    41.888
   141.937    42.611
>
   141.033    41.888
   141.937    42.611
>
   141.921    42.623
   141.916    42.731
>
   141.450    42.840
   141.916    42.731
>
   141.450    42.840
   141.916    42.731
>
   142.467    42.410
   141.916    42.731
>
   142.467    42.410
   141.916    42.731
>
   141.417    43.275
   141.916    42.731
>
   141.417    43.275
   141.916    42.731
>
   142.753    42.280
   141.916    42.731
>
   142.223    43.505
   141.916    42.731
>
   141.921    42.623
   141.953    42.656
>
   141.921    42.623
   141.953    42.656
>
   142.364    42.778
   141.953    42.656
>
   142.364    42.778
   141.953    42.656
>
   142.467    42.410
   141.953    42.656
>
   142.467    42.410
   141.953    42.656
>
   141.450    42.840
   141.953    42.656
>
   141.450    42.840
   141.953    42.656
>
   142.753    42.280
   141.953    42.656
>
   142.594    43.164
   141.953    42.656
>
   142.594    43.164
   141.953    42.656
>
   141.038    42.469
   141.953    42.656
>
   141.038    42.469
   141.953    42.656
>
   141.417    43.275
   141.953    42.656
>
   141.417    43.275
   141.953    42.656
>
   142.223    43.505
   141.953    42.656
>
   142.223    43.505
   141.953    42.656
>
   143.299    42.291
   143.006    42.274
>
   143.299    42.291
   143.006    42.274
>
   142.753    42.280
   143.006    42.274
>
   142.753    42.280
   143.006    42.274
>
   143.157    42.016
   143.006    42.274
>
   143.157    42.016
   143.006    42.274
>
   143.157    42.015
   143.006    42.274
>
   143.157    42.015
   143.006    42.274
>
   143.362    42.614
   143.006    42.274
>
   143.362    42.614
   143.006    42.274
>
   142.467    42.410
   143.006    42.274
>
   142.467    42.410
   143.006    42.274
>
   142.364    42.778
   143.006    42.274
>
   142.364    42.778
   143.006    42.274
>
   143.835    42.903
   143.006    42.274
>
   143.835    42.903
   143.006    42.274
>
   141.921    42.623
   143.006    42.274
>
   142.594    43.164
   143.006    42.274
>
   141.921    42.623
   141.957    42.638
>
   141.921    42.623
   141.957    42.638
>
   142.364    42.778
   141.957    42.638
>
   142.364    42.778
   141.957    42.638
>
   142.467    42.410
   141.957    42.638
>
   141.450    42.840
   141.957    42.638
>
   141.450    42.840
   141.957    42.638
>
   142.753    42.280
   141.957    42.638
>
   141.038    42.469
   141.957    42.638
>
   141.038    42.469
   141.957    42.638
>
   142.594    43.164
   141.957    42.638
>
   141.417    43.275
   141.957    42.638
>
   141.417    43.275
   141.957    42.638
>
   142.223    43.505
   141.957    42.638
>
   142.223    43.505
   141.957    42.638
>
   141.921    42.623
   141.950    42.771
>
   142.364    42.778
   141.950    42.771
>
   142.364    42.778
   141.950    42.771
>
   141.450    42.840
   141.950    42.771
>
   141.450    42.840
   141.950    42.771
>
   142.467    42.410
   141.950    42.771
>
   142.594    43.164
   141.950    42.771
>
   141.417    43.275
   141.950    42.771
>
   141.038    42.469
   141.950    42.771
>
   141.038    42.469
   141.950    42.771
>
   142.753    42.280
   141.950    42.771
>
   142.753    42.280
   141.950    42.771
>
   142.223    43.505
   141.950    42.771
>
   141.725    43.743
   141.950    42.771
>
   141.921    42.623
   142.032    42.584
>
   141.921    42.623
   142.032    42.584
>
   142.467    42.410
   142.032    42.584
>
   142.753    42.280
   142.032    42.584
>
   141.450    42.840
   142.032    42.584
>
   141.450    42.840
   142.032    42.584
>
   141.038    42.469
   142.032    42.584
>
   142.594    43.164
   142.032    42.584
>
   141.417    43.275
   142.032    42.584
>
   141.417    43.275
   142.032    42.584
>
   143.362    42.614
   142.032    42.584
>
   141.921    42.623
   142.037    42.805
>
   141.921    42.623
   142.037    42.805
>
   142.364    42.778
   142.037    42.805
>
   141.450    42.840
   142.037    42.805
>
   142.467    42.410
   142.037    42.805
>
   142.467    42.410
   142.037    42.805
>
   141.417    43.275
   142.037    42.805
>
   141.417    43.275
   142.037    42.805
>
   141.038    42.469
   142.037    42.805
>
   141.725    43.743
   142.037    42.805
>
   141.921    42.623
   141.981    42.593
>
   141.921    42.623
   141.981    42.593
>
   142.467    42.410
   141.981    42.593
>
   142.753    42.280
   141.981    42.593
>
   142.594    43.164
   141.981    42.593
>
   142.594    43.164
   141.981    42.593
>
   141.038    42.469
   141.981    42.593
>
   141.038    42.469
   141.981    42.593
>
   141.417    43.275
   141.981    42.593
>
   141.417    43.275
   141.981    42.593
>
   142.223    43.505
   141.981    42.593
>
   141.033    41.888
   141.981    42.593
>
   141.033    41.888
   141.981    42.593
>
   141.921    42.623
   141.943    42.687
>
   141.921    42.623
   141.943    42.687
>
   142.364    42.778
   141.943    42.687
>
   141.450    42.840
   141.943    42.687
>
   141.450    42.840
   141.943    42.687
>
   142.467    42.410
   141.943    42.687
>
   142.467    42.410
   141.943    42.687
>
   142.594    43.164
   141.943    42.687
>
   141.038    42.469
   141.943    42.687
>
   141.038    42.469
   141.943    42.687
>
   142.753    42.280
   141.943    42.687
>
   141.417    43.275
   141.943    42.687
>
   141.417    43.275
   141.943    42.687
>
   142.223    43.505
   141.943    42.687
>
   142.223    43.505
   141.943    42.687
>
   141.921    42.623
   141.948    42.593
>
   141.921    42.623
   141.948    42.593
>
   142.364    42.778
   141.948    42.593
>
   142.364    42.778
   141.948    42.593
>
   142.467    42.410
   141.948    42.593
>
   142.467    42.410
   141.948    42.593
>
   141.450    42.840
   141.948    42.593
>
   141.450    42.840
   141.948    42.593
>
   142.753    42.280
   141.948    42.593
>
   142.753    42.280
   141.948    42.593
>
   141.038    42.469
   141.948    42.593
>
   141.038    42.469
   141.948    42.593
>
   142.594    43.164
   141.948    42.593
>
   141.417    43.275
   141.948    42.593
>
   141.417    43.275
   141.948    42.593
>
   141.033    41.888
   141.948    42.593
>
   141.033    41.888
   141.948    42.593
>
   142.223    43.505
   141.948    42.593
>
   142.223    43.505
   141.948    42.593
>
   141.921    42.623
   141.932    42.628
>
   141.921    42.623
   141.932    42.628
>
   142.364    42.778
   141.932    42.628
>
   142.364    42.778
   141.932    42.628
>
   141.450    42.840
   141.932    42.628
>
   141.450    42.840
   141.932    42.628
>
   142.467    42.410
   141.932    42.628
>
   142.467    42.410
   141.932    42.628
>
   141.038    42.469
   141.932    42.628
>
   141.038    42.469
   141.932    42.628
>
   142.753    42.280
   141.932    42.628
>
   142.753    42.280
   141.932    42.628
>
   142.594    43.164
   141.932    42.628
>
   142.594    43.164
   141.932    42.628
>
   141.417    43.275
   141.932    42.628
>
   141.417    43.275
   141.932    42.628
>
   142.223    43.505
   141.932    42.628
>
   142.223    43.505
   141.932    42.628
>
   141.033    41.888
   141.932    42.628
>
   141.033    41.888
   141.932    42.628
>
   141.921    42.623
   141.924    42.623
>
   141.921    42.623
   141.924    42.623
>
   142.364    42.778
   141.924    42.623
>
   142.364    42.778
   141.924    42.623
>
   141.450    42.840
   141.924    42.623
>
   141.450    42.840
   141.924    42.623
>
   142.467    42.410
   141.924    42.623
>
   141.038    42.469
   141.924    42.623
>
   141.038    42.469
   141.924    42.623
>
   142.753    42.280
   141.924    42.623
>
   142.753    42.280
   141.924    42.623
>
   142.594    43.164
   141.924    42.623
>
   141.417    43.275
   141.924    42.623
>
   141.417    43.275
   141.924    42.623
>
   142.223    43.505
   141.924    42.623
>
   142.223    43.505
   141.924    42.623
>
   141.033    41.888
   141.924    42.623
>
   141.033    41.888
   141.924    42.623
>
   141.921    42.623
   141.898    42.545
>
   141.921    42.623
   141.898    42.545
>
   142.364    42.778
   141.898    42.545
>
   142.467    42.410
   141.898    42.545
>
   141.450    42.840
   141.898    42.545
>
   141.450    42.840
   141.898    42.545
>
   141.038    42.469
   141.898    42.545
>
   142.753    42.280
   141.898    42.545
>
   142.753    42.280
   141.898    42.545
>
   142.594    43.164
   141.898    42.545
>
   142.223    43.505
   141.898    42.545
>
   141.921    42.623
   141.947    42.833
>
   141.921    42.623
   141.947    42.833
>
   142.364    42.778
   141.947    42.833
>
   142.364    42.778
   141.947    42.833
>
   141.450    42.840
   141.947    42.833
>
   141.450    42.840
   141.947    42.833
>
   142.467    42.410
   141.947    42.833
>
   142.594    43.164
   141.947    42.833
>
   141.417    43.275
   141.947    42.833
>
   141.417    43.275
   141.947    42.833
>
   142.223    43.505
   141.947    42.833
>
   142.223    43.505
   141.947    42.833
>
   141.038    42.469
   141.947    42.833
>
   142.753    42.280
   141.947    42.833
>
   141.725    43.743
   141.947    42.833
>
   142.753    42.280
   142.925    42.365
>
   142.753    42.280
   142.925    42.365
>
   143.299    42.291
   142.925    42.365
>
   143.157    42.016
   142.925    42.365
>
   143.157    42.015
   142.925    42.365
>
   143.157    42.015
   142.925    42.365
>
   143.157    42.015
   142.925    42.365
>
   143.157    42.015
   142.925    42.365
>
   143.157    42.015
   142.925    42.365
>
   142.467    42.410
   142.925    42.365
>
   143.362    42.614
   142.925    42.365
>
   143.362    42.614
   142.925    42.365
>
   142.364    42.778
   142.925    42.365
>
   141.921    42.623
   142.925    42.365
>
   143.835    42.903
   142.925    42.365
>
   143.835    42.903
   142.925    42.365
>
   142.594    43.164
   142.925    42.365
>
   143.299    42.291
   143.016    42.267
>
   143.299    42.291
   143.016    42.267
>
   142.753    42.280
   143.016    42.267
>
   142.753    42.280
   143.016    42.267
>
   143.157    42.016
   143.016    42.267
>
   143.157    42.016
   143.016    42.267
>
   143.157    42.015
   143.016    42.267
>
   143.157    42.015
   143.016    42.267
>
   143.362    42.614
   143.016    42.267
>
   143.362    42.614
   143.016    42.267
>
   142.467    42.410
   143.016    42.267
>
   142.467    42.410
   143.016    42.267
>
   142.364    42.778
   143.016    42.267
>
   142.364    42.778
   143.016    42.267
>
   143.835    42.903
   143.016    42.267
>
   143.835    42.903
   143.016    42.267
>
   141.921    42.623
   143.016    42.267
>
   142.594    43.164
   143.016    42.267
>
   141.921    42.623
   141.977    42.730
>
   141.921    42.623
   141.977    42.730
>
   141.450    42.840
   141.977    42.730
>
   141.450    42.840
   141.977    42.730
>
   142.467    42.410
   141.977    42.730
>
   142.467    42.410
   141.977    42.730
>
   142.594    43.164
   141.977    42.730
>
   142.753    42.280
   141.977    42.730
>
   141.417    43.275
   141.977    42.730
>
   141.417    43.275
   141.977    42.730
>
   141.038    42.469
   141.977    42.730
>
   142.223    43.505
   141.977    42.730
>
   141.921    42.623
   141.932    42.687
>
   141.921    42.623
   141.932    42.687
>
   142.364    42.778
   141.932    42.687
>
   142.364    42.778
   141.932    42.687
>
   141.450    42.840
   141.932    42.687
>
   141.450    42.840
   141.932    42.687
>
   142.467    42.410
   141.932    42.687
>
   142.467    42.410
   141.932    42.687
>
   142.594    43.164
   141.932    42.687
>
   141.417    43.275
   141.932    42.687
>
   141.417    43.275
   141.932    42.687
>
   142.753    42.280
   141.932    42.687
>
   141.038    42.469
   141.932    42.687
>
   141.038    42.469
   141.932    42.687
>
   142.223    43.505
   141.932    42.687
>
   142.223    43.505
   141.932    42.687
>
   143.299    42.291
   143.095    42.296
>
   143.299    42.291
   143.095    42.296
>
   142.753    42.280
   143.095    42.296
>
   142.753    42.280
   143.095    42.296
>
   143.157    42.016
   143.095    42.296
>
   143.157    42.016
   143.095    42.296
>
   143.157    42.015
   143.095    42.296
>
   143.157    42.015
   143.095    42.296
>
   143.157    42.015
   143.095    42.296
>
   143.157    42.015
   143.095    42.296
>
   143.362    42.614
   143.095    42.296
>
   143.362    42.614
   143.095    42.296
>
   142.467    42.410
   143.095    42.296
>
   142.467    42.410
   143.095    42.296
>
   142.364    42.778
   143.095    42.296
>
   142.364    42.778
   143.095    42.296
>
   143.835    42.903
   143.095    42.296
>
   143.835    42.903
   143.095    42.296
>
   142.594    43.164
   143.095    42.296
>
   141.921    42.623
   141.959    42.760
>
   142.364    42.778
   141.959    42.760
>
   142.364    42.778
   141.959    42.760
>
   141.450    42.840
   141.959    42.760
>
   141.450    42.840
   141.959    42.760
>
   142.467    42.410
   141.959    42.760
>
   142.467    42.410
   141.959    42.760
>
   142.594    43.164
   141.959    42.760
>
   141.417    43.275
   141.959    42.760
>
   141.417    43.275
   141.959    42.760
>
   142.223    43.505
   141.959    42.760
>
   142.753    42.280
   141.959    42.760
>
   142.753    42.280
   141.959    42.760
>
   141.038    42.469
   141.959    42.760
>
   141.038    42.469
   141.959    42.760
>
   141.725    43.743
   141.959    42.760
>
   141.921    42.623
   141.936    42.771
>
   141.921    42.623
   141.936    42.771
>
   142.364    42.778
   141.936    42.771
>
   142.364    42.778
   141.936    42.771
>
   141.450    42.840
   141.936    42.771
>
   141.450    42.840
   141.936    42.771
>
   142.467    42.410
   141.936    42.771
>
   142.594    43.164
   141.936    42.771
>
   141.417    43.275
   141.936    42.771
>
   141.417    43.275
   141.936    42.771
>
   141.038    42.469
   141.936    42.771
>
   141.038    42.469
   141.936    42.771
>
   142.223    43.505
   141.936    42.771
>
   142.753    42.280
   141.936    42.771
>
   142.753    42.280
   141.936    42.771
>
   141.725    43.743
   141.936    42.771
>
   141.921    42.623
   141.920    42.758
>
   141.921    42.623
   141.920    42.758
>
   142.364    42.778
   141.920    42.758
>
   142.364    42.778
   141.920    42.758
>
   141.450    42.840
   141.920    42.758
>
   141.450    42.840
   141.920    42.758
>
   142.467    42.410
   141.920    42.758
>
   142.467    42.410
   141.920    42.758
>
   142.594    43.164
   141.920    42.758
>
   141.417    43.275
   141.920    42.758
>
   141.417    43.275
   141.920    42.758
>
   141.038    42.469
   141.920    42.758
>
   141.038    42.469
   141.920    42.758
>
   142.753    42.280
   141.920    42.758
>
   142.223    43.505
   141.920    42.758
>
   142.223    43.505
   141.920    42.758
>
   141.725    43.743
   141.920    42.758
>
   141.725    43.743
   141.920    42.758
>
   141.921    42.623
   141.948    42.751
>
   141.921    42.623
   141.948    42.751
>
   142.364    42.778
   141.948    42.751
>
   142.364    42.778
   141.948    42.751
>
   141.450    42.840
   141.948    42.751
>
   141.450    42.840
   141.948    42.751
>
   142.467    42.410
   141.948    42.751
>
   142.467    42.410
   141.948    42.751
>
   142.594    43.164
   141.948    42.751
>
   142.753    42.280
   141.948    42.751
>
   142.753    42.280
   141.948    42.751
>
   142.223    43.505
   141.948    42.751
>
   141.038    42.469
   141.948    42.751
>
   141.038    42.469
   141.948    42.751
>
   143.299    42.291
   143.058    42.261
>
   143.299    42.291
   143.058    42.261
>
   143.157    42.016
   143.058    42.261
>
   143.157    42.015
   143.058    42.261
>
   143.157    42.015
   143.058    42.261
>
   142.753    42.280
   143.058    42.261
>
   142.753    42.280
   143.058    42.261
>
   143.362    42.614
   143.058    42.261
>
   143.362    42.614
   143.058    42.261
>
   142.467    42.410
   143.058    42.261
>
   142.364    42.778
   143.058    42.261
>
   143.835    42.903
   143.058    42.261
>
   143.835    42.903
   143.058    42.261
>
   141.921    42.623
   143.058    42.261
>
   142.594    43.164
   143.058    42.261
>
   143.299    42.291
   143.121    42.305
>
   143.299    42.291
   143.121    42.305
>
   143.157    42.016
   143.121    42.305
>
   143.157    42.016
   143.121    42.305
>
   142.753    42.280
   143.121    42.305
>
   142.753    42.280
   143.121    42.305
>
   143.362    42.614
   143.121    42.305
>
   143.362    42.614
   143.121    42.305
>
   142.467    42.410
   143.121    42.305
>
   142.467    42.410
   143.121    42.305
>
   142.364    42.778
   143.121    42.305
>
   142.364    42.778
   143.121    42.305
>
   143.835    42.903
   143.121    42.305
>
   143.835    42.903
   143.121    42.305
>
   142.594    43.164
   143.121    42.305
>
   141.921    42.623
   143.121    42.305
>
   142.467    42.410
   142.674    42.689
>
   142.467    42.410
   142.674    42.689
>
   142.364    42.778
   142.674    42.689
>
   142.364    42.778
   142.674    42.689
>
   142.753    42.280
   142.674    42.689
>
   142.753    42.280
   142.674    42.689
>
   143.362    42.614
   142.674    42.689
>
   143.362    42.614
   142.674    42.689
>
   142.594    43.164
   142.674    42.689
>
   142.594    43.164
   142.674    42.689
>
   143.157    42.016
   142.674    42.689
>
   143.835    42.903
   142.674    42.689
>
   143.835    42.903
   142.674    42.689
>
   142.223    43.505
   142.674    42.689
>
   141.450    42.840
   142.674    42.689
>
   141.450    42.840
   142.674    42.689
>
   141.921    42.623
   141.936    42.810
>
   141.921    42.623
   141.936    42.810
>
   142.364    42.778
   141.936    42.810
>
   142.364    42.778
   141.936    42.810
>
   141.450    42.840
   141.936    42.810
>
   141.450    42.840
   141.936    42.810
>
   142.467    42.410
   141.936    42.810
>
   142.594    43.164
   141.936    42.810
>
   141.417    43.275
   141.936    42.810
>
   141.417    43.275
   141.936    42.810
>
   141.038    42.469
   141.936    42.810
>
   141.038    42.469
   141.936    42.810
>
   142.753    42.280
   141.936    42.810
>
   142.753    42.280
   141.936    42.810
>
   142.223    43.505
   141.936    42.810
>
   141.725    43.743
   141.936    42.810
>
   141.725    43.743
   141.936    42.810
>
   143.299    42.291
   143.065    42.271
>
   143.299    42.291
   143.065    42.271
>
   142.753    42.280
   143.065    42.271
>
   142.753    42.280
   143.065    42.271
>
   143.157    42.015
   143.065    42.271
>
   143.157    42.015
   143.065    42.271
>
   143.157    42.016
   143.065    42.271
>
   143.157    42.016
   143.065    42.271
>
   143.362    42.614
   143.065    42.271
>
   143.362    42.614
   143.065    42.271
>
   142.467    42.410
   143.065    42.271
>
   142.467    42.410
   143.065    42.271
>
   142.364    42.778
   143.065    42.271
>
   142.364    42.778
   143.065    42.271
>
   143.835    42.903
   143.065    42.271
>
   143.835    42.903
   143.065    42.271
>
   141.921    42.623
   143.065    42.271
>
   141.921    42.623
   143.065    42.271
>
   142.594    43.164
   143.065    42.271
>
   143.299    42.291
   143.059    42.275
>
   143.299    42.291
   143.059    42.275
>
   143.157    42.015
   143.059    42.275
>
   143.157    42.015
   143.059    42.275
>
   143.157    42.016
   143.059    42.275
>
   143.157    42.016
   143.059    42.275
>
   142.753    42.280
   143.059    42.275
>
   142.753    42.280
   143.059    42.275
>
   143.362    42.614
   143.059    42.275
>
   143.362    42.614
   143.059    42.275
>
   142.467    42.410
   143.059    42.275
>
   142.467    42.410
   143.059    42.275
>
   142.364    42.778
   143.059    42.275
>
   142.364    42.778
   143.059    42.275
>
   143.835    42.903
   143.059    42.275
>
   143.835    42.903
   143.059    42.275
>
   142.594    43.164
   143.059    42.275
>
   143.299    42.291
   143.095    42.319
>
   143.299    42.291
   143.095    42.319
>
   142.753    42.280
   143.095    42.319
>
   142.753    42.280
   143.095    42.319
>
   143.157    42.016
   143.095    42.319
>
   143.157    42.016
   143.095    42.319
>
   143.157    42.015
   143.095    42.319
>
   143.157    42.015
   143.095    42.319
>
   143.157    42.015
   143.095    42.319
>
   143.362    42.614
   143.095    42.319
>
   143.362    42.614
   143.095    42.319
>
   142.467    42.410
   143.095    42.319
>
   142.364    42.778
   143.095    42.319
>
   143.835    42.903
   143.095    42.319
>
   142.594    43.164
   143.095    42.319
>
   141.921    42.623
   143.095    42.319
>
   141.921    42.623
   141.960    42.605
>
   141.921    42.623
   141.960    42.605
>
   142.364    42.778
   141.960    42.605
>
   142.364    42.778
   141.960    42.605
>
   142.467    42.410
   141.960    42.605
>
   142.467    42.410
   141.960    42.605
>
   141.450    42.840
   141.960    42.605
>
   141.450    42.840
   141.960    42.605
>
   142.753    42.280
   141.960    42.605
>
   142.753    42.280
   141.960    42.605
>
   141.038    42.469
   141.960    42.605
>
   141.038    42.469
   141.960    42.605
>
   142.594    43.164
   141.960    42.605
>
   141.417    43.275
   141.960    42.605
>
   141.417    43.275
   141.960    42.605
>
   142.223    43.505
   141.960    42.605
>
   142.223    43.505
   141.960    42.605
>
   141.033    41.888
   141.960    42.605
>
   141.033    41.888
   141.960    42.605
>
   143.299    42.291
   143.088    42.408
>
   142.753    42.280
   143.088    42.408
>
   142.753    42.280
   143.088    42.408
>
   143.157    42.016
   143.088    42.408
>
   143.157    42.015
   143.088    42.408
>
   143.157    42.015
   143.088    42.408
>
   143.157    42.015
   143.088    42.408
>
   143.157    42.015
   143.088    42.408
>
   142.467    42.410
   143.088    42.408
>
   142.364    42.778
   143.088    42.408
>
   143.835    42.903
   143.088    42.408
>
   143.835    42.903
   143.088    42.408
>
   143.299    42.291
   143.064    42.269
>
   143.299    42.291
   143.064    42.269
>
   143.157    42.016
   143.064    42.269
>
   143.157    42.016
   143.064    42.269
>
   142.753    42.280
   143.064    42.269
>
   142.753    42.280
   143.064    42.269
>
   143.362    42.614
   143.064    42.269
>
   143.362    42.614
   143.064    42.269
>
   142.467    42.410
   143.064    42.269
>
   142.467    42.410
   143.064    42.269
>
   142.364    42.778
   143.064    42.269
>
   142.364    42.778
   143.064    42.269
>
   143.835    42.903
   143.064    42.269
>
   143.835    42.903
   143.064    42.269
>
   141.921    42.623
   143.064    42.269
>
   142.594    43.164
   143.064    42.269
>
   143.299    42.291
   143.715    42.371
>
   143.299    42.291
   143.715    42.371
>
   143.362    42.614
   143.715    42.371
>
   143.362    42.614
   143.715    42.371
>
   143.835    42.903
   143.715    42.371
>
   143.835    42.903
   143.715    42.371
>
   143.157    42.016
   143.715    42.371
>
   142.753    42.280
   143.715    42.371
>
   142.753    42.280
   143.715    42.371
>
   142.467    42.410
   143.715    42.371
>
   142.467    42.410
   143.715    42.371
>
   143.770    43.297
   143.715    42.371
>
   143.770    43.297
   143.715    42.371
>
   144.697    42.996
   143.715    42.371
>
   144.697    42.996
   143.715    42.371
>
   142.753    42.280
   142.987    42.294
>
   142.753    42.280
   142.987    42.294
>
   143.299    42.291
   142.987    42.294
>
   143.299    42.291
   142.987    42.294
>
   143.157    42.016
   142.987    42.294
>
   143.157    42.016
   142.987    42.294
>
   142.467    42.410
   142.987    42.294
>
   143.362    42.614
   142.987    42.294
>
   143.362    42.614
   142.987    42.294
>
   142.364    42.778
   142.987    42.294
>
   142.364    42.778
   142.987    42.294
>
   141.921    42.623
   142.987    42.294
>
   143.835    42.903
   142.987    42.294
>
   142.594    43.164
   142.987    42.294
>
   142.753    42.280
   142.980    42.303
>
   143.299    42.291
   142.980    42.303
>
   143.299    42.291
   142.980    42.303
>
   143.157    42.015
   142.980    42.303
>
   143.157    42.015
   142.980    42.303
>
   143.157    42.016
   142.980    42.303
>
   143.157    42.016
   142.980    42.303
>
   142.467    42.410
   142.980    42.303
>
   143.362    42.614
   142.980    42.303
>
   142.364    42.778
   142.980    42.303
>
   142.364    42.778
   142.980    42.303
>
   141.921    42.623
   142.980    42.303
>
   143.835    42.903
   142.980    42.303
>
   142.594    43.164
   142.980    42.303
>
   143.299    42.291
   143.071    42.295
>
   143.299    42.291
   143.071    42.295
>
   142.753    42.280
   143.071    42.295
>
   142.753    42.280
   143.071    42.295
>
   143.157    42.016
   143.071    42.295
>
   143.157    42.016
   143.071    42.295
>
   143.157    42.015
   143.071    42.295
>
   143.157    42.015
   143.071    42.295
>
   143.362    42.614
   143.071    42.295
>
   143.362    42.614
   143.071    42.295
>
   142.467    42.410
   143.071    42.295
>
   142.364    42.778
   143.071    42.295
>
   142.364    42.778
   143.071    42.295
>
   143.835    42.903
   143.071    42.295
>
   143.835    42.903
   143.071    42.295
>
   141.921    42.623
   143.071    42.295
>
   142.594    43.164
   143.071    42.295
>
   141.921    42.623
   141.866    42.759
>
   141.921    42.623
   141.866    42.759
>
   141.450    42.840
   141.866    42.759
>
   141.450    42.840
   141.866    42.759
>
   142.364    42.778
   141.866    42.759
>
   142.364    42.778
   141.866    42.759
>
   142.467    42.410
   141.866    42.759
>
   141.417    43.275
   141.866    42.759
>
   141.417    43.275
   141.866    42.759
>
   141.038    42.469
   141.866    42.759
>
   141.038    42.469
   141.866    42.759
>
   142.594    43.164
   141.866    42.759
>
   142.753    42.280
   141.866    42.759
>
   142.223    43.505
   141.866    42.759
>
   142.223    43.505
   141.866    42.759
>
   141.725    43.743
   141.866    42.759
>
   141.725    43.743
   141.866    42.759
>
   141.921    42.623
   141.942    42.701
>
   141.921    42.623
   141.942    42.701
>
   142.364    42.778
   141.942    42.701
>
   142.364    42.778
   141.942    42.701
>
   141.450    42.840
   141.942    42.701
>
   141.450    42.840
   141.942    42.701
>
   142.467    42.410
   141.942    42.701
>
   142.467    42.410
   141.942    42.701
>
   142.594    43.164
   141.942    42.701
>
   142.753    42.280
   141.942    42.701
>
   141.038    42.469
   141.942    42.701
>
   141.038    42.469
   141.942    42.701
>
   141.417    43.275
   141.942    42.701
>
   141.417    43.275
   141.942    42.701
>
   142.223    43.505
   141.942    42.701
>
   142.223    43.505
   141.942    42.701
>
   143.299    42.291
   143.136    42.294
>
   143.299    42.291
   143.136    42.294
>
   142.753    42.280
   143.136    42.294
>
   143.362    42.614
   143.136    42.294
>
   143.362    42.614
   143.136    42.294
>
   143.157    42.016
   143.136    42.294
>
   143.157    42.016
   143.136    42.294
>
   142.467    42.410
   143.136    42.294
>
   142.467    42.410
   143.136    42.294
>
   142.364    42.778
   143.136    42.294
>
   143.835    42.903
   143.136    42.294
>
   143.835    42.903
   143.136    42.294
>
   142.594    43.164
   143.136    42.294
>
   141.921    42.623
   143.136    42.294
>
   143.299    42.291
   143.449    42.444
>
   143.299    42.291
   143.449    42.444
>
   143.362    42.614
   143.449    42.444
>
   143.362    42.614
   143.449    42.444
>
   143.157    42.016
   143.449    42.444
>
   143.157    42.015
   143.449    42.444
>
   142.753    42.280
   143.449    42.444
>
   143.835    42.903
   143.449    42.444
>
   143.835    42.903
   143.449    42.444
>
   142.467    42.410
   143.449    42.444
>
   142.364    42.778
   143.449    42.444
>
   143.770    43.297
   143.449    42.444
>
   143.770    43.297
   143.449    42.444
>
   142.594    43.164
   143.449    42.444
>
   143.299    42.291
   143.777    42.394
>
   143.299    42.291
   143.777    42.394
>
   143.362    42.614
   143.777    42.394
>
   143.362    42.614
   143.777    42.394
>
   143.835    42.903
   143.777    42.394
>
   143.835    42.903
   143.777    42.394
>
   143.157    42.016
   143.777    42.394
>
   143.157    42.015
   143.777    42.394
>
   142.753    42.280
   143.777    42.394
>
   144.697    42.996
   143.777    42.394
>
   143.770    43.297
   143.777    42.394
>
   143.770    43.297
   143.777    42.394
>
   142.467    42.410
   143.777    42.394
>
   142.753    42.280
   142.969    42.287
>
   142.753    42.280
   142.969    42.287
>
   143.299    42.291
   142.969    42.287
>
   143.299    42.291
   142.969    42.287
>
   143.157    42.016
   142.969    42.287
>
   142.467    42.410
   142.969    42.287
>
   143.362    42.614
   142.969    42.287
>
   143.362    42.614
   142.969    42.287
>
   142.364    42.778
   142.969    42.287
>
   141.921    42.623
   142.969    42.287
>
   143.835    42.903
   142.969    42.287
>
   143.835    42.903
   142.969    42.287
>
   142.594    43.164
   142.969    42.287
>
   142.753    42.280
   142.879    42.187
>
   142.753    42.280
   142.879    42.187
>
   143.157    42.015
   142.879    42.187
>
   143.157    42.015
   142.879    42.187
>
   143.157    42.015
   142.879    42.187
>
   143.157    42.016
   142.879    42.187
>
   143.299    42.291
   142.879    42.187
>
   142.467    42.410
   142.879    42.187
>
   142.467    42.410
   142.879    42.187
>
   143.362    42.614
   142.879    42.187
>
   143.362    42.614
   142.879    42.187
>
   142.364    42.778
   142.879    42.187
>
   142.364    42.778
   142.879    42.187
>
   141.921    42.623
   142.879    42.187
>
   142.594    43.164
   142.879    42.187
>
   143.835    42.903
   144.211    42.687
>
   143.835    42.903
   144.211    42.687
>
   144.697    42.996
   144.211    42.687
>
   144.697    42.996
   144.211    42.687
>
   144.842    43.017
   144.211    42.687
>
   144.842    43.017
   144.211    42.687
>
   143.362    42.614
   144.211    42.687
>
   143.362    42.614
   144.211    42.687
>
   143.770    43.297
   144.211    42.687
>
   143.770    43.297
   144.211    42.687
>
   145.161    43.083
   144.211    42.687
>
   145.161    43.083
   144.211    42.687
>
   144.719    43.585
   144.211    42.687
>
   144.719    43.585
   144.211    42.687
>
   142.753    42.280
   142.642    42.217
>
   142.753    42.280
   142.642    42.217
>
   142.467    42.410
   142.642    42.217
>
   143.157    42.015
   142.642    42.217
>
   143.157    42.015
   142.642    42.217
>
   143.157    42.015
   142.642    42.217
>
   143.157    42.016
   142.642    42.217
>
   143.299    42.291
   142.642    42.217
>
   142.364    42.778
   142.642    42.217
>
   142.364    42.778
   142.642    42.217
>
   143.362    42.614
   142.642    42.217
>
   141.921    42.623
   142.642    42.217
>
   142.594    43.164
   142.642    42.217
>
   143.299    42.291
   143.255    42.431
>
   143.299    42.291
   143.255    42.431
>
   143.362    42.614
   143.255    42.431
>
   143.362    42.614
   143.255    42.431
>
   143.157    42.015
   143.255    42.431
>
   143.157    42.015
   143.255    42.431
>
   143.157    42.016
   143.255    42.431
>
   143.835    42.903
   143.255    42.431
>
   143.835    42.903
   143.255    42.431
>
   142.364    42.778
   143.255    42.431
>
   142.594    43.164
   143.255    42.431
>
   143.770    43.297
   143.255    42.431
>
   143.770    43.297
   143.255    42.431
>
   142.467    42.410
   142.552    42.425
>
   142.364    42.778
   142.552    42.425
>
   142.364    42.778
   142.552    42.425
>
   141.921    42.623
   142.552    42.425
>
   143.157    42.016
   142.552    42.425
>
   143.157    42.015
   142.552    42.425
>
   143.157    42.015
   142.552    42.425
>
   143.157    42.015
   142.552    42.425
>
   143.157    42.015
   142.552    42.425
>
   143.157    42.015
   142.552    42.425
>
   143.157    42.015
   142.552    42.425
>
   143.362    42.614
   142.552    42.425
>
   142.594    43.164
   142.552    42.425
>
   142.594    43.164
   142.552    42.425
>
   141.450    42.840
   142.552    42.425
>
   142.364    42.778
   142.437    42.747
>
   142.364    42.778
   142.437    42.747
>
   142.467    42.410
   142.437    42.747
>
   142.467    42.410
   142.437    42.747
>
   141.921    42.623
   142.437    42.747
>
   142.594    43.164
   142.437    42.747
>
   142.753    42.280
   142.437    42.747
>
   143.362    42.614
   142.437    42.747
>
   143.362    42.614
   142.437    42.747
>
   141.450    42.840
   142.437    42.747
>
   141.450    42.840
   142.437    42.747
>
   142.223    43.505
   142.437    42.747
>
   143.157    42.016
   142.437    42.747
>
   143.157    42.015
   142.437    42.747
>
   141.417    43.275
   142.437    42.747
>
   141.417    43.275
   142.437    42.747
>
   143.299    42.291
   143.088    42.330
>
   143.299    42.291
   143.088    42.330
>
   142.753    42.280
   143.088    42.330
>
   142.753    42.280
   143.088    42.330
>
   143.362    42.614
   143.088    42.330
>
   143.362    42.614
   143.088    42.330
>
   143.157    42.016
   143.088    42.330
>
   143.157    42.016
   143.088    42.330
>
   143.157    42.015
   143.088    42.330
>
   143.157    42.015
   143.088    42.330
>
   143.157    42.015
   143.088    42.330
>
   143.157    42.015
   143.088    42.330
>
   142.467    42.410
   143.088    42.330
>
   142.467    42.410
   143.088    42.330
>
   142.364    42.778
   143.088    42.330
>
   143.835    42.903
   143.088    42.330
>
   143.835    42.903
   143.088    42.330
>
   142.594    43.164
   143.088    42.330
>
   143.299    42.291
   143.057    42.242
>
   143.299    42.291
   143.057    42.242
>
   142.753    42.280
   143.057    42.242
>
   143.157    42.016
   143.057    42.242
>
   143.157    42.015
   143.057    42.242
>
   143.157    42.015
   143.057    42.242
>
   143.362    42.614
   143.057    42.242
>
   142.467    42.410
   143.057    42.242
>
   142.364    42.778
   143.057    42.242
>
   143.835    42.903
   143.057    42.242
>
   141.921    42.623
   143.057    42.242
>
   142.594    43.164
   143.057    42.242
>
   142.753    42.280
   142.631    42.351
>
   142.467    42.410
   142.631    42.351
>
   142.467    42.410
   142.631    42.351
>
   142.364    42.778
   142.631    42.351
>
   142.364    42.778
   142.631    42.351
>
   143.157    42.015
   142.631    42.351
>
   143.157    42.015
   142.631    42.351
>
   143.157    42.015
   142.631    42.351
>
   143.157    42.016
   142.631    42.351
>
   143.362    42.614
   142.631    42.351
>
   141.921    42.623
   142.631    42.351
>
   142.594    43.164
   142.631    42.351
>
   141.450    42.840
   142.631    42.351
>
   141.450    42.840
   142.631    42.351
>
   142.753    42.280
   142.957    42.309
>
   142.753    42.280
   142.957    42.309
>
   143.299    42.291
   142.957    42.309
>
   143.299    42.291
   142.957    42.309
>
   143.157    42.015
   142.957    42.309
>
   143.157    42.015
   142.957    42.309
>
   143.157    42.016
   142.957    42.309
>
   143.157    42.016
   142.957    42.309
>
   143.362    42.614
   142.957    42.309
>
   143.362    42.614
   142.957    42.309
>
   142.467    42.410
   142.957    42.309
>
   142.364    42.778
   142.957    42.309
>
   142.364    42.778
   142.957    42.309
>
   143.835    42.903
   142.957    42.309
>
   143.835    42.903
   142.957    42.309
>
   141.921    42.623
   142.957    42.309
>
   142.594    43.164
   142.957    42.309
>
   143.299    42.291
   143.033    42.298
>
   143.299    42.291
   143.033    42.298
>
   142.753    42.280
   143.033    42.298
>
   142.753    42.280
   143.033    42.298
>
   143.157    42.016
   143.033    42.298
>
   143.157    42.015
   143.033    42.298
>
   143.157    42.015
   143.033    42.298
>
   143.157    42.015
   143.033    42.298
>
   143.362    42.614
   143.033    42.298
>
   143.362    42.614
   143.033    42.298
>
   142.467    42.410
   143.033    42.298
>
   142.467    42.410
   143.033    42.298
>
   142.364    42.778
   143.033    42.298
>
   142.364    42.778
   143.033    42.298
>
   143.835    42.903
   143.033    42.298
>
   143.835    42.903
   143.033    42.298
>
   141.921    42.623
   143.033    42.298
>
   142.594    43.164
   143.033    42.298
>
   142.467    42.410
   142.473    42.502
>
   142.467    42.410
   142.473    42.502
>
   142.753    42.280
   142.473    42.502
>
   142.364    42.778
   142.473    42.502
>
   143.362    42.614
   142.473    42.502
>
   143.362    42.614
   142.473    42.502
>
   143.157    42.016
   142.473    42.502
>
   142.594    43.164
   142.473    42.502
>
   143.157    42.015
   142.473    42.502
>
   143.157    42.015
   142.473    42.502
>
   143.157    42.015
   142.473    42.502
>
   141.450    42.840
   142.473    42.502
>
   143.299    42.291
   143.008    42.272
>
   143.299    42.291
   143.008    42.272
>
   142.753    42.280
   143.008    42.272
>
   143.157    42.016
   143.008    42.272
>
   143.157    42.015
   143.008    42.272
>
   143.362    42.614
   143.008    42.272
>
   142.467    42.410
   143.008    42.272
>
   142.364    42.778
   143.008    42.272
>
   142.364    42.778
   143.008    42.272
>
   143.835    42.903
   143.008    42.272
>
   143.835    42.903
   143.008    42.272
>
   141.921    42.623
   143.008    42.272
>
   142.594    43.164
   143.008    42.272
>
   142.753    42.280
   142.963    42.286
>
   142.753    42.280
   142.963    42.286
>
   143.299    42.291
   142.963    42.286
>
   143.299    42.291
   142.963    42.286
>
   143.157    42.016
   142.963    42.286
>
   143.157    42.016
   142.963    42.286
>
   143.157    42.015
   142.963    42.286
>
   143.157    42.015
   142.963    42.286
>
   142.467    42.410
   142.963    42.286
>
   143.362    42.614
   142.963    42.286
>
   143.362    42.614
   142.963    42.286
>
   142.364    42.778
   142.963    42.286
>
   142.364    42.778
   142.963    42.286
>
   141.921    42.623
   142.963    42.286
>
   141.921    42.623
   142.963    42.286
>
   143.835    42.903
   142.963    42.286
>
   142.594    43.164
   142.963    42.286
>
   143.299    42.291
   143.112    42.321
>
   143.299    42.291
   143.112    42.321
>
   142.753    42.280
   143.112    42.321
>
   143.362    42.614
   143.112    42.321
>
   143.362    42.614
   143.112    42.321
>
   143.157    42.016
   143.112    42.321
>
   143.157    42.016
   143.112    42.321
>
   143.157    42.015
   143.112    42.321
>
   143.157    42.015
   143.112    42.321
>
   142.467    42.410
   143.112    42.321
>
   142.467    42.410
   143.112    42.321
>
   142.364    42.778
   143.112    42.321
>
   142.364    42.778
   143.112    42.321
>
   143.835    42.903
   143.112    42.321
>
   143.835    42.903
   143.112    42.321
>
   142.594    43.164
   143.112    42.321
>
   141.921    42.623
   143.112    42.321
>
   143.299    42.291
   142.992    42.280
>
   143.299    42.291
   142.992    42.280
>
   142.753    42.280
   142.992    42.280
>
   143.157    42.015
   142.992    42.280
>
   143.157    42.016
   142.992    42.280
>
   143.157    42.016
   142.992    42.280
>
   143.362    42.614
   142.992    42.280
>
   143.362    42.614
   142.992    42.280
>
   142.467    42.410
   142.992    42.280
>
   142.467    42.410
   142.992    42.280
>
   142.364    42.778
   142.992    42.280
>
   142.364    42.778
   142.992    42.280
>
   143.835    42.903
   142.992    42.280
>
   143.835    42.903
   142.992    42.280
>
   141.921    42.623
   142.992    42.280
>
   142.594    43.164
   142.992    42.280
>
   142.753    42.280
   142.959    42.161
>
   143.157    42.015
   142.959    42.161
>
   143.157    42.015
   142.959    42.161
>
   143.157    42.016
   142.959    42.161
>
   143.299    42.291
   142.959    42.161
>
   143.299    42.291
   142.959    42.161
>
   142.467    42.410
   142.959    42.161
>
   143.362    42.614
   142.959    42.161
>
   143.362    42.614
   142.959    42.161
>
   142.364    42.778
   142.959    42.161
>
   142.364    42.778
   142.959    42.161
>
   141.921    42.623
   142.959    42.161
>
   143.835    42.903
   142.959    42.161
>
   143.835    42.903
   142.959    42.161
>
   142.753    42.280
   142.969    42.302
>
   143.299    42.291
   142.969    42.302
>
   143.299    42.291
   142.969    42.302
>
   143.157    42.016
   142.969    42.302
>
   143.157    42.015
   142.969    42.302
>
   143.157    42.015
   142.969    42.302
>
   143.157    42.015
   142.969    42.302
>
   142.467    42.410
   142.969    42.302
>
   142.467    42.410
   142.969    42.302
>
   143.362    42.614
   142.969    42.302
>
   143.362    42.614
   142.969    42.302
>
   142.364    42.778
   142.969    42.302
>
   141.921    42.623
   142.969    42.302
>
   143.835    42.903
   142.969    42.302
>
   143.835    42.903
   142.969    42.302
>
   142.594    43.164
   142.969    42.302
>
   143.037    43.238
   142.969    42.302
>
   143.037    43.238
   142.969    42.302
>
   142.753    42.280
   143.010    42.318
>
   143.299    42.291
   143.010    42.318
>
   143.299    42.291
   143.010    42.318
>
   142.467    42.410
   143.010    42.318
>
   142.467    42.410
   143.010    42.318
>
   143.157    42.015
   143.010    42.318
>
   143.157    42.015
   143.010    42.318
>
   143.157    42.015
   143.010    42.318
>
   143.157    42.016
   143.010    42.318
>
   143.362    42.614
   143.010    42.318
>
   143.362    42.614
   143.010    42.318
>
   142.364    42.778
   143.010    42.318
>
   142.364    42.778
   143.010    42.318
>
   141.921    42.623
   143.010    42.318
>
   142.594    43.164
   143.010    42.318
>
   143.835    42.903
   143.010    42.318
>
   143.835    42.903
   143.010    42.318
>
   143.037    43.238
   143.010    42.318
>
   142.753    42.280
   142.882    42.193
>
   143.157    42.015
   142.882    42.193
>
   143.157    42.015
   142.882    42.193
>
   143.157    42.016
   142.882    42.193
>
   143.299    42.291
   142.882    42.193
>
   143.299    42.291
   142.882    42.193
>
   142.467    42.410
   142.882    42.193
>
   142.467    42.410
   142.882    42.193
>
   143.362    42.614
   142.882    42.193
>
   143.362    42.614
   142.882    42.193
>
   142.364    42.778
   142.882    42.193
>
   142.364    42.778
   142.882    42.193
>
   141.921    42.623
   142.882    42.193
>
   143.835    42.903
   142.882    42.193
>
   143.835    42.903
   142.882    42.193
>
   142.594    43.164
   142.882    42.193
>
   142.753    42.280
   142.974    42.451
>
   143.299    42.291
   142.974    42.451
>
   143.299    42.291
   142.974    42.451
>
   143.362    42.614
   142.974    42.451
>
   143.362    42.614
   142.974    42.451
>
   142.467    42.410
   142.974    42.451
>
   142.467    42.410
   142.974    42.451
>
   143.157    42.016
   142.974    42.451
>
   143.157    42.015
   142.974    42.451
>
   142.364    42.778
   142.974    42.451
>
   142.364    42.778
   142.974    42.451
>
   142.594    43.164
   142.974    42.451
>
   143.835    42.903
   142.974    42.451
>
   143.835    42.903
   142.974    42.451
>
   143.037    43.238
   142.974    42.451
>
   143.037    43.238
   142.974    42.451
>
   141.921    42.623
   142.974    42.451
>
   142.467    42.410
   142.562    42.392
>
   142.467    42.410
   142.562    42.392
>
   142.364    42.778
   142.562    42.392
>
   142.364    42.778
   142.562    42.392
>
   141.921    42.623
   142.562    42.392
>
   143.157    42.015
   142.562    42.392
>
   143.157    42.015
   142.562    42.392
>
   143.157    42.015
   142.562    42.392
>
   143.157    42.016
   142.562    42.392
>
   143.362    42.614
   142.562    42.392
>
   143.362    42.614
   142.562    42.392
>
   142.594    43.164
   142.562    42.392
>
   142.594    43.164
   142.562    42.392
>
   143.037    43.238
   142.562    42.392
>
   143.037    43.238
   142.562    42.392
>
   141.450    42.840
   142.562    42.392
>
   141.450    42.840
   142.562    42.392
>
   143.299    42.291
   143.082    42.319
>
   143.299    42.291
   143.082    42.319
>
   142.753    42.280
   143.082    42.319
>
   143.362    42.614
   143.082    42.319
>
   143.362    42.614
   143.082    42.319
>
   143.157    42.016
   143.082    42.319
>
   143.157    42.015
   143.082    42.319
>
   143.157    42.015
   143.082    42.319
>
   142.467    42.410
   143.082    42.319
>
   142.467    42.410
   143.082    42.319
>
   142.364    42.778
   143.082    42.319
>
   142.364    42.778
   143.082    42.319
>
   143.835    42.903
   143.082    42.319
>
   143.835    42.903
   143.082    42.319
>
   143.037    43.238
   143.082    42.319
>
   142.594    43.164
   143.082    42.319
>
   141.921    42.623
   143.082    42.319
>
   142.364    42.778
   142.471    42.805
>
   142.364    42.778
   142.471    42.805
>
   142.594    43.164
   142.471    42.805
>
   142.467    42.410
   142.471    42.805
>
   141.921    42.623
   142.471    42.805
>
   143.037    43.238
   142.471    42.805
>
   143.362    42.614
   142.471    42.805
>
   143.362    42.614
   142.471    42.805
>
   141.450    42.840
   142.471    42.805
>
   141.450    42.840
   142.471    42.805
>
   141.417    43.275
   142.471    42.805
>
   142.467    42.410
   142.394    42.696
>
   142.467    42.410
   142.394    42.696
>
   142.753    42.280
   142.394    42.696
>
   141.450    42.840
   142.394    42.696
>
   141.450    42.840
   142.394    42.696
>
   143.362    42.614
   142.394    42.696
>
   143.362    42.614
   142.394    42.696
>
   141.417    43.275
   142.394    42.696
>
   141.417    43.275
   142.394    42.696
>
   143.157    42.016
   142.394    42.696
>
   143.157    42.015
   142.394    42.696
>
   143.157    42.015
   143.071    42.280
>
   143.157    42.015
   143.071    42.280
>
   143.157    42.015
   144.066    42.459
>
   143.157    42.015
   144.066    42.459
>
   143.157    42.015
   144.066    42.459
>
   143.157    42.015
   144.066    42.459
>
   143.157    42.015
   142.642    42.360
>
   143.157    42.015
   142.642    42.360
>
   143.157    42.015
   143.093    42.328
>
   143.157    42.015
   143.093    42.328
>
   143.157    42.015
   143.063    42.278
>
   143.157    42.015
   143.063    42.278
>
   143.157    42.015
   143.063    42.278
>
   143.157    42.015
   143.063    42.278
>
   143.157    42.016
   143.010    42.298
>
   143.157    42.015
   143.010    42.298
>
   143.157    42.015
   143.010    42.298
>
   143.157    42.015
   143.010    42.298
>
   143.157    42.015
   143.010    42.298
>
   143.157    42.015
   143.226    42.730
>
   143.157    42.015
   143.226    42.730
>
   143.157    42.015
   143.088    42.308
>
   143.157    42.015
   143.088    42.308
>
   143.157    42.015
   143.088    42.308
>
   143.157    42.015
   143.088    42.308
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
   143.320    42.292     0.300
   142.782    42.158     0.300
   143.217    42.920     0.300
   144.392    42.975     0.300
   142.967    42.239     0.300
   141.332    43.058     0.300
   140.982    42.310     0.300
   143.287    42.383     0.300
   144.795    43.100     0.300
   142.705    42.225     0.300
   142.667    42.243     0.300
   143.157    42.016     0.300
   143.362    42.614     0.300
   142.134    42.590     0.300
   143.835    42.903     0.300
   142.594    43.164     0.300
   142.223    43.505     0.300
   141.450    42.840     0.300
   142.847    43.812     0.300
   143.770    43.297     0.300
   144.697    42.996     0.300
   141.038    42.469     0.300
   141.033    41.888     0.300
   142.364    42.778     0.300
   142.753    42.280     0.300
   143.157    42.015     0.300
   140.370    42.117     0.300
   143.284    42.292     0.300
   140.476    43.353     0.300
   143.129    43.466     0.300
   143.299    42.291     0.300
   142.467    42.410     0.300
   141.921    42.623     0.300
   141.417    43.275     0.300
   145.161    43.083     0.300
   141.725    43.743     0.300
   144.842    43.017     0.300
   144.719    43.585     0.300
   143.037    43.238     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
   143.164    42.201     0.200
>
   143.953    42.283     0.200
>
   143.237    42.185     0.200
>
   143.166    42.156     0.200
>
   143.252    42.181     0.200
>
   143.194    42.203     0.200
>
   143.092    42.192     0.200
>
   143.469    42.284     0.200
>
   142.565    42.084     0.200
>
   142.691    42.230     0.200
>
   142.633    42.283     0.200
>
   143.164    42.202     0.200
>
   143.180    42.358     0.200
>
   143.289    42.336     0.200
>
   143.245    42.350     0.200
>
   143.251    42.384     0.200
>
   143.206    42.380     0.200
>
   143.267    42.174     0.200
>
   143.152    42.199     0.200
>
   143.096    42.178     0.200
>
   143.215    42.198     0.200
>
   143.229    42.201     0.200
>
   143.258    42.181     0.200
>
   143.268    42.366     0.200
>
   143.161    42.190     0.200
>
   142.750    42.297     0.200
>
   144.228    42.511     0.200
>
   142.729    42.188     0.200
>
   142.628    42.167     0.200
>
   143.139    42.194     0.200
>
   142.689    42.312     0.200
>
   143.287    42.185     0.200
>
   143.237    42.166     0.200
>
   143.157    42.168     0.200
>
   141.928    42.541     0.200
>
   143.153    42.189     0.200
>
   143.243    42.190     0.200
>
   142.637    42.131     0.200
>
   143.218    42.209     0.200
>
   142.652    42.083     0.200
>
   142.569    42.128     0.200
>
   142.686    42.212     0.200
>
   142.682    42.233     0.200
>
   142.616    42.160     0.200
>
   142.685    42.129     0.200
>
   142.691    42.188     0.200
>
   142.739    42.165     0.200
>
   142.573    42.189     0.200
>
   142.680    42.177     0.200
>
   142.485    42.251     0.200
>
   142.733    42.156     0.200
>
   142.456    42.139     0.200
>
   142.534    42.211     0.200
>
   142.643    42.214     0.200
>
   142.511    42.190     0.200
>
   142.537    42.138     0.200
>
   142.563    42.204     0.200
>
   142.425    42.187     0.200
>
   143.219    42.158     0.200
>
   142.635    42.282     0.200
>
   142.693    42.297     0.200
>
   142.753    42.140     0.200
>
   142.806    42.125     0.200
>
   142.709    42.298     0.200
>
   143.278    42.174     0.200
>
   142.862    42.195     0.200
>
   142.488    42.193     0.200
>
   142.851    42.171     0.200
>
   142.804    42.230     0.200
>
   143.101    42.309     0.200
>
   142.629    42.208     0.200
>
   143.566    42.536     0.200
>
   142.490    42.282     0.200
>
   143.189    42.204     0.200
>
   143.204    42.351     0.200
>
   143.205    42.394     0.200
>
   143.156    42.180     0.200
>
   142.552    42.139     0.200
>
   142.430    42.224     0.200
>
   143.177    42.176     0.200
>
   143.192    42.187     0.200
>
   143.249    42.201     0.200
>
   143.135    42.180     0.200
>
   143.067    42.196     0.200
>
   143.191    42.189     0.200
>
   143.140    42.195     0.200
>
   142.449    42.145     0.200
>
   142.667    42.140     0.200
>
   143.131    42.212     0.200
>
   142.948    42.656     0.200
>
   142.664    42.196     0.200
>
   143.152    42.196     0.200
>
   142.837    42.173     0.200
>
   142.894    42.154     0.200
>
   143.069    42.189     0.200
>
   143.766    42.473     0.200
>
   143.177    42.351     0.200
>
   143.101    42.203     0.200
>
   142.539    42.766     0.200
>
   143.094    42.198     0.200
>
   142.843    42.304     0.200
>
   142.630    42.717     0.200
>
   142.623    42.383     0.200
>
   143.195    42.200     0.200
>
   142.091    42.675     0.200
>
   143.087    42.312     0.200
>
   142.058    42.395     0.200
>
   142.507    42.230     0.200
>
   142.583    42.261     0.200
>
   142.824    42.347     0.200
>
   143.160    42.193     0.200
>
   142.669    42.222     0.200
>
   142.951    42.161     0.200
>
   143.337    42.728     0.200
>
   143.220    42.232     0.200
>
   143.040    42.247     0.200
>
   142.581    42.289     0.200
>
   142.528    42.853     0.200
>
   142.784    42.641     0.200
>
   143.752    42.370     0.200
>
   141.944    42.497     0.200
>
   141.947    42.495     0.200
>
   142.334    42.766     0.200
>
   142.693    42.237     0.200
>
   143.105    42.470     0.200
>
   142.548    42.269     0.200
>
   143.189    42.286     0.200
>
   142.582    42.349     0.200
>
   143.151    42.283     0.200
>
   142.385    42.403     0.200
>
   143.084    42.242     0.200
>
   143.067    42.244     0.200
>
   142.447    42.472     0.200
>
   142.733    42.387     0.200
>
   143.960    42.547     0.200
>
   143.677    42.406     0.200
>
   143.088    42.246     0.200
>
   143.439    42.805     0.200
>
   142.988    42.239     0.200
>
   143.462    42.391     0.200
>
   142.635    42.775     0.200
>
   143.217    42.259     0.200
>
   142.525    42.467     0.200
>
   143.156    42.273     0.200
>
   143.262    42.785     0.200
>
   142.430    42.811     0.200
>
   142.892    42.178     0.200
>
   142.730    42.175     0.200
>
   143.587    42.456     0.200
>
   142.726    42.177     0.200
>
   142.855    42.625     0.200
>
   143.548    42.589     0.200
>
   143.100    42.325     0.200
>
   143.119    42.322     0.200
>
   143.077    42.500     0.200
>
   143.401    42.745     0.200
>
   143.104    42.297     0.200
>
   143.100    42.322     0.200
>
   143.054    42.291     0.200
>
   144.103    42.638     0.200
>
   143.564    42.586     0.200
>
   142.576    42.163     0.200
>
   142.974    42.296     0.200
>
   143.439    42.449     0.200
>
   143.115    42.300     0.200
>
   142.549    42.432     0.200
>
   142.474    42.207     0.200
>
   143.063    42.273     0.200
>
   142.971    42.288     0.200
>
   143.181    42.293     0.200
>
   143.518    42.388     0.200
>
   143.047    42.306     0.200
>
   143.114    42.325     0.200
>
   143.564    42.556     0.200
>
   143.064    42.292     0.200
>
   143.853    42.464     0.200
>
   143.887    42.487     0.200
>
   143.172    42.211     0.200
>
   142.967    42.293     0.200
>
   143.023    42.254     0.200
>
   143.005    42.438     0.200
>
   143.008    42.277     0.200
>
   143.362    42.175     0.200
>
   143.107    42.327     0.200
>
   143.119    42.293     0.200
>
   142.827    42.235     0.200
>
   143.077    42.404     0.200
>
   142.876    42.193     0.200
>
   143.096    42.305     0.200
>
   143.118    42.296     0.200
>
   143.051    42.288     0.200
>
   143.110    42.318     0.200
>
   142.956    42.320     0.200
>
   143.047    42.266     0.200
>
   143.053    42.479     0.200
>
   143.030    42.320     0.200
>
   143.131    42.316     0.200
>
   142.991    42.293     0.200
>
   143.022    42.278     0.200
>
   143.054    42.286     0.200
>
   143.166    42.403     0.200
>
   143.099    42.305     0.200
>
   142.644    42.582     0.200
>
   142.991    42.269     0.200
>
   143.160    42.204     0.200
>
   143.666    42.355     0.200
>
   142.877    42.192     0.200
>
   143.068    42.305     0.200
>
   143.058    42.295     0.200
>
   143.167    42.289     0.200
>
   142.998    42.281     0.200
>
   143.314    42.480     0.200
>
   143.009    42.269     0.200
>
   143.565    42.498     0.200
>
   143.105    42.326     0.200
>
   143.681    42.342     0.200
>
   143.109    42.318     0.200
>
   142.966    42.302     0.200
>
   143.050    42.258     0.200
>
   142.958    42.148     0.200
>
   143.435    42.687     0.200
>
   142.148    42.344     0.200
>
   141.638    42.432     0.200
>
   143.647    42.478     0.200
>
   143.051    42.288     0.200
>
   142.595    42.246     0.200
>
   143.079    42.313     0.200
>
   143.166    42.403     0.200
>
   143.015    42.278     0.200
>
   143.022    42.290     0.200
>
   142.285    42.245     0.200
>
   141.451    42.889     0.200
>
   143.121    42.301     0.200
>
   142.958    42.301     0.200
>
   142.592    42.305     0.200
>
   143.114    42.316     0.200
>
   143.316    42.695     0.200
>
   142.491    42.234     0.200
>
   142.537    42.167     0.200
>
   142.586    42.198     0.200
>
   142.687    42.579     0.200
>
   142.885    42.198     0.200
>
   143.114    42.314     0.200
>
   142.986    42.447     0.200
>
   142.996    42.335     0.200
>
   143.080    42.294     0.200
>
   143.077    42.293     0.200
>
   142.972    42.293     0.200
>
   142.582    42.671     0.200
>
   143.118    42.314     0.200
>
   143.760    42.448     0.200
>
   143.005    42.178     0.200
>
   142.984    42.310     0.200
>
   143.162    42.204     0.200
>
   142.948    42.292     0.200
>
   143.039    42.293     0.200
>
   143.010    42.259     0.200
>
   143.075    42.276     0.200
>
   142.426    42.314     0.200
>
   142.879    42.190     0.200
>
   143.047    42.279     0.200
>
   142.581    42.463     0.200
>
   143.124    42.309     0.200
>
   142.756    42.609     0.200
>
   142.629    42.739     0.200
>
   142.655    42.750     0.200
>
   143.624    42.496     0.200
>
   141.411    42.612     0.200
>
   143.093    42.325     0.200
>
   144.135    42.646     0.200
>
   142.682    42.789     0.200
>
   142.631    42.512     0.200
>
   141.806    42.578     0.200
>
   141.824    42.590     0.200
>
   142.968    42.311     0.200
>
   143.012    42.281     0.200
>
   142.577    42.352     0.200
>
   143.079    42.309     0.200
>
   143.579    42.464     0.200
>
   144.031    42.567     0.200
>
   143.122    42.302     0.200
>
   143.066    42.262     0.200
>
   142.952    42.279     0.200
>
   142.945    42.268     0.200
>
   143.189    42.387     0.200
>
   142.960    42.295     0.200
>
   143.009    42.252     0.200
>
   143.054    42.259     0.200
>
   143.039    42.288     0.200
>
   143.124    42.315     0.200
>
   142.998    42.279     0.200
>
   143.028    42.297     0.200
>
   142.926    42.315     0.200
>
   143.074    42.286     0.200
>
   141.865    42.791     0.200
>
   141.834    42.797     0.200
>
   142.996    42.285     0.200
>
   143.772    42.581     0.200
>
   143.120    42.310     0.200
>
   142.558    42.466     0.200
>
   143.593    42.443     0.200
>
   143.023    42.273     0.200
>
   141.948    42.686     0.200
>
   141.928    42.631     0.200
>
   141.870    42.545     0.200
>
   141.938    42.813     0.200
>
   141.955    42.706     0.200
>
   141.975    42.725     0.200
>
   141.916    42.702     0.200
>
   141.949    42.683     0.200
>
   141.944    42.646     0.200
>
   141.928    42.606     0.200
>
   141.958    42.693     0.200
>
   141.953    42.662     0.200
>
   141.976    42.680     0.200
>
   141.924    42.611     0.200
>
   141.954    42.807     0.200
>
   141.932    42.618     0.200
>
   141.946    42.650     0.200
>
   141.925    42.668     0.200
>
   141.947    42.810     0.200
>
   141.921    42.610     0.200
>
   141.935    42.698     0.200
>
   141.910    42.703     0.200
>
   141.917    42.606     0.200
>
   141.914    42.595     0.200
>
   141.940    42.793     0.200
>
   141.934    42.696     0.200
>
   142.102    42.743     0.200
>
   141.918    42.615     0.200
>
   141.932    42.731     0.200
>
   141.927    42.610     0.200
>
   141.916    42.593     0.200
>
   141.941    42.724     0.200
>
   141.970    42.747     0.200
>
   141.938    42.679     0.200
>
   141.925    42.707     0.200
>
   141.972    42.786     0.200
>
   141.968    42.724     0.200
>
   141.941    42.671     0.200
>
   142.121    42.770     0.200
>
   141.939    42.684     0.200
>
   141.916    42.594     0.200
>
   141.956    42.707     0.200
>
   141.886    42.734     0.200
>
   141.959    42.817     0.200
>
   141.943    42.678     0.200
>
   141.921    42.614     0.200
>
   141.971    42.720     0.200
>
   141.936    42.700     0.200
>
   141.928    42.671     0.200
>
   141.941    42.801     0.200
>
   141.937    42.611     0.200
>
   141.916    42.731     0.200
>
   141.953    42.656     0.200
>
   143.006    42.274     0.200
>
   141.957    42.638     0.200
>
   141.950    42.771     0.200
>
   142.032    42.584     0.200
>
   142.037    42.805     0.200
>
   141.981    42.593     0.200
>
   141.943    42.687     0.200
>
   141.948    42.593     0.200
>
   141.932    42.628     0.200
>
   141.924    42.623     0.200
>
   141.898    42.545     0.200
>
   141.947    42.833     0.200
>
   142.925    42.365     0.200
>
   143.016    42.267     0.200
>
   141.977    42.730     0.200
>
   141.932    42.687     0.200
>
   143.095    42.296     0.200
>
   141.959    42.760     0.200
>
   141.936    42.771     0.200
>
   141.920    42.758     0.200
>
   141.948    42.751     0.200
>
   143.058    42.261     0.200
>
   143.121    42.305     0.200
>
   142.674    42.689     0.200
>
   141.936    42.810     0.200
>
   143.065    42.271     0.200
>
   143.059    42.275     0.200
>
   143.095    42.319     0.200
>
   141.960    42.605     0.200
>
   143.088    42.408     0.200
>
   143.064    42.269     0.200
>
   143.715    42.371     0.200
>
   142.987    42.294     0.200
>
   142.980    42.303     0.200
>
   143.071    42.295     0.200
>
   141.866    42.759     0.200
>
   141.942    42.701     0.200
>
   143.136    42.294     0.200
>
   143.449    42.444     0.200
>
   143.777    42.394     0.200
>
   142.969    42.287     0.200
>
   142.879    42.187     0.200
>
   144.211    42.687     0.200
>
   142.642    42.217     0.200
>
   143.255    42.431     0.200
>
   142.552    42.425     0.200
>
   142.437    42.747     0.200
>
   143.088    42.330     0.200
>
   143.057    42.242     0.200
>
   142.631    42.351     0.200
>
   142.957    42.309     0.200
>
   143.033    42.298     0.200
>
   142.473    42.502     0.200
>
   143.008    42.272     0.200
>
   142.963    42.286     0.200
>
   143.112    42.321     0.200
>
   142.992    42.280     0.200
>
   142.959    42.161     0.200
>
   142.969    42.302     0.200
>
   143.010    42.318     0.200
>
   142.882    42.193     0.200
>
   142.974    42.451     0.200
>
   142.562    42.392     0.200
>
   143.082    42.319     0.200
>
   142.471    42.805     0.200
>
   142.394    42.696     0.200
>
   143.071    42.280     0.200
>
   144.066    42.459     0.200
>
   142.642    42.360     0.200
>
   143.093    42.328     0.200
>
   143.063    42.278     0.200
>
   143.010    42.298     0.200
>
   143.226    42.730     0.200
>
   143.088    42.308     0.200
>
   142.905    42.099     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
   142.796    42.395     0.000   222.000   222.000
   142.796    42.395     0.000   444.000   444.000
EOF
gmt end
