#!/bin/bash
gmt begin sapporo1.54_base pdf,ps
proj=-JM16.0c+
reg=-R141.3/144.3/42.0/43.0
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map sapporo1.54'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Cross-section locations
gmt plot $proj $reg -S=0.1 -Wthicker,blue << EOF
   142.796    42.395   120.000 100.4k
EOF
gmt plot $proj $reg -S=0.1 -Wthicker,blue << EOF
   142.796    42.395   120.000 -128.1k
EOF
gmt plot $proj $reg -S=0.1 -Wthin,blue << EOF
   142.796    42.395   210.000 2.5k
EOF
gmt plot $proj $reg -S=0.1 -Wthin,blue << EOF
   142.796    42.395   210.000 -2.5k
EOF

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
   143.164    42.201 1
   143.953    42.283 2
   143.237    42.185 3
   143.166    42.156 4
   143.252    42.181 5
   143.194    42.203 6
   143.092    42.192 7
   143.469    42.284 8
   142.565    42.084 9
   142.691    42.230 10
   142.633    42.283 11
   143.164    42.202 12
   143.180    42.358 13
   143.289    42.336 14
   143.245    42.350 15
   143.251    42.384 16
   143.206    42.380 17
   143.267    42.174 18
   143.152    42.199 19
   143.096    42.178 20
   143.215    42.198 21
   143.229    42.201 22
   143.258    42.181 23
   143.268    42.366 24
   143.161    42.190 25
   142.750    42.297 26
   144.228    42.511 27
   142.729    42.188 28
   142.628    42.167 29
   143.139    42.194 30
   142.689    42.312 31
   143.287    42.185 32
   143.237    42.166 33
   143.157    42.168 34
   141.928    42.541 35
   143.153    42.189 36
   143.243    42.190 37
   142.637    42.131 38
   143.218    42.209 39
   142.652    42.083 40
   142.569    42.128 41
   142.686    42.212 42
   142.682    42.233 43
   142.616    42.160 44
   142.685    42.129 45
   142.691    42.188 46
   142.739    42.165 47
   142.573    42.189 48
   142.680    42.177 49
   142.485    42.251 50
   142.733    42.156 51
   142.456    42.139 52
   142.534    42.211 53
   142.643    42.214 54
   142.511    42.190 55
   142.537    42.138 56
   142.563    42.204 57
   142.425    42.187 58
   143.219    42.158 59
   142.635    42.282 60
   142.693    42.297 61
   142.753    42.140 62
   142.806    42.125 63
   142.709    42.298 64
   143.278    42.174 65
   142.862    42.195 66
   142.488    42.193 67
   142.851    42.171 68
   142.804    42.230 69
   143.101    42.309 70
   142.629    42.208 71
   143.566    42.536 72
   142.490    42.282 73
   143.189    42.204 74
   143.204    42.351 75
   143.205    42.394 76
   143.156    42.180 77
   142.552    42.139 78
   142.430    42.224 79
   143.177    42.176 80
   143.192    42.187 81
   143.249    42.201 82
   143.135    42.180 83
   143.067    42.196 84
   143.191    42.189 85
   143.140    42.195 86
   142.449    42.145 87
   142.667    42.140 88
   143.131    42.212 89
   142.948    42.656 90
   142.664    42.196 91
   143.152    42.196 92
   142.837    42.173 93
   142.894    42.154 94
   143.069    42.189 95
   143.766    42.473 96
   143.177    42.351 97
   143.101    42.203 98
   142.539    42.766 99
   143.094    42.198 100
   142.843    42.304 101
   142.630    42.717 102
   142.623    42.383 103
   143.195    42.200 104
   142.091    42.675 105
   143.087    42.312 106
   142.058    42.395 107
   142.507    42.230 108
   142.583    42.261 109
   142.824    42.347 110
   143.160    42.193 111
   142.669    42.222 112
   142.951    42.161 113
   143.337    42.728 114
   143.220    42.232 115
   143.040    42.247 116
   142.581    42.289 117
   142.528    42.853 118
   142.784    42.641 119
   143.752    42.370 120
   141.944    42.497 121
   141.947    42.495 122
   142.334    42.766 123
   142.693    42.237 124
   143.105    42.470 125
   142.548    42.269 126
   143.189    42.286 127
   142.582    42.349 128
   143.151    42.283 129
   142.385    42.403 130
   143.084    42.242 131
   143.067    42.244 132
   142.447    42.472 133
   142.733    42.387 134
   143.960    42.547 135
   143.677    42.406 136
   143.088    42.246 137
   143.439    42.805 138
   142.988    42.239 139
   143.462    42.391 140
   142.635    42.775 141
   143.217    42.259 142
   142.525    42.467 143
   143.156    42.273 144
   143.262    42.785 145
   142.430    42.811 146
   142.892    42.178 147
   142.730    42.175 148
   143.587    42.456 149
   142.726    42.177 150
   142.855    42.625 151
   143.548    42.589 152
   143.100    42.325 153
   143.119    42.322 154
   143.077    42.500 155
   143.401    42.745 156
   143.104    42.297 157
   143.100    42.322 158
   143.054    42.291 159
   144.103    42.638 160
   143.564    42.586 161
   142.576    42.163 162
   142.974    42.296 163
   143.439    42.449 164
   143.115    42.300 165
   142.549    42.432 166
   142.474    42.207 167
   143.063    42.273 168
   142.971    42.288 169
   143.181    42.293 170
   143.518    42.388 171
   143.047    42.306 172
   143.114    42.325 173
   143.564    42.556 174
   143.064    42.292 175
   143.853    42.464 176
   143.887    42.487 177
   143.172    42.211 178
   142.967    42.293 179
   143.023    42.254 180
   143.005    42.438 181
   143.008    42.277 182
   143.362    42.175 183
   143.107    42.327 184
   143.119    42.293 185
   142.827    42.235 186
   143.077    42.404 187
   142.876    42.193 188
   143.096    42.305 189
   143.118    42.296 190
   143.051    42.288 191
   143.110    42.318 192
   142.956    42.320 193
   143.047    42.266 194
   143.053    42.479 195
   143.030    42.320 196
   143.131    42.316 197
   142.991    42.293 198
   143.022    42.278 199
   143.054    42.286 200
   143.166    42.403 201
   143.099    42.305 202
   142.644    42.582 203
   142.991    42.269 204
   143.160    42.204 205
   143.666    42.355 206
   142.877    42.192 207
   143.068    42.305 208
   143.058    42.295 209
   143.167    42.289 210
   142.998    42.281 211
   143.314    42.480 212
   143.009    42.269 213
   143.565    42.498 214
   143.105    42.326 215
   143.681    42.342 216
   143.109    42.318 217
   142.966    42.302 218
   143.050    42.258 219
   142.958    42.148 220
   143.435    42.687 221
   142.148    42.344 222
   141.638    42.432 223
   143.647    42.478 224
   143.051    42.288 225
   142.595    42.246 226
   143.079    42.313 227
   143.166    42.403 228
   143.015    42.278 229
   143.022    42.290 230
   142.285    42.245 231
   141.451    42.889 232
   143.121    42.301 233
   142.958    42.301 234
   142.592    42.305 235
   143.114    42.316 236
   143.316    42.695 237
   142.491    42.234 238
   142.537    42.167 239
   142.586    42.198 240
   142.687    42.579 241
   142.885    42.198 242
   143.114    42.314 243
   142.986    42.447 244
   142.996    42.335 245
   143.080    42.294 246
   143.077    42.293 247
   142.972    42.293 248
   142.582    42.671 249
   143.118    42.314 250
   143.760    42.448 251
   143.005    42.178 252
   142.984    42.310 253
   143.162    42.204 254
   142.948    42.292 255
   143.039    42.293 256
   143.010    42.259 257
   143.075    42.276 258
   142.426    42.314 259
   142.879    42.190 260
   143.047    42.279 261
   142.581    42.463 262
   143.124    42.309 263
   142.756    42.609 264
   142.629    42.739 265
   142.655    42.750 266
   143.624    42.496 267
   141.411    42.612 268
   143.093    42.325 269
   144.135    42.646 270
   142.682    42.789 271
   142.631    42.512 272
   141.806    42.578 273
   141.824    42.590 274
   142.968    42.311 275
   143.012    42.281 276
   142.577    42.352 277
   143.079    42.309 278
   143.579    42.464 279
   144.031    42.567 280
   143.122    42.302 281
   143.066    42.262 282
   142.952    42.279 283
   142.945    42.268 284
   143.189    42.387 285
   142.960    42.295 286
   143.009    42.252 287
   143.054    42.259 288
   143.039    42.288 289
   143.124    42.315 290
   142.998    42.279 291
   143.028    42.297 292
   142.926    42.315 293
   143.074    42.286 294
   141.865    42.791 295
   141.834    42.797 296
   142.996    42.285 297
   143.772    42.581 298
   143.120    42.310 299
   142.558    42.466 300
   143.593    42.443 301
   143.023    42.273 302
   141.948    42.686 303
   141.928    42.631 304
   141.870    42.545 305
   141.938    42.813 306
   141.955    42.706 307
   141.975    42.725 308
   141.916    42.702 309
   141.949    42.683 310
   141.944    42.646 311
   141.928    42.606 312
   141.958    42.693 313
   141.953    42.662 314
   141.976    42.680 315
   141.924    42.611 316
   141.954    42.807 317
   141.932    42.618 318
   141.946    42.650 319
   141.925    42.668 320
   141.947    42.810 321
   141.921    42.610 322
   141.935    42.698 323
   141.910    42.703 324
   141.917    42.606 325
   141.914    42.595 326
   141.940    42.793 327
   141.934    42.696 328
   142.102    42.743 329
   141.918    42.615 330
   141.932    42.731 331
   141.927    42.610 332
   141.916    42.593 333
   141.941    42.724 334
   141.970    42.747 335
   141.938    42.679 336
   141.925    42.707 337
   141.972    42.786 338
   141.968    42.724 339
   141.941    42.671 340
   142.121    42.770 341
   141.939    42.684 342
   141.916    42.594 343
   141.956    42.707 344
   141.886    42.734 345
   141.959    42.817 346
   141.943    42.678 347
   141.921    42.614 348
   141.971    42.720 349
   141.936    42.700 350
   141.928    42.671 351
   141.941    42.801 352
   141.937    42.611 353
   141.916    42.731 354
   141.953    42.656 355
   143.006    42.274 356
   141.957    42.638 357
   141.950    42.771 358
   142.032    42.584 359
   142.037    42.805 360
   141.981    42.593 361
   141.943    42.687 362
   141.948    42.593 363
   141.932    42.628 364
   141.924    42.623 365
   141.898    42.545 366
   141.947    42.833 367
   142.925    42.365 368
   143.016    42.267 369
   141.977    42.730 370
   141.932    42.687 371
   143.095    42.296 372
   141.959    42.760 373
   141.936    42.771 374
   141.920    42.758 375
   141.948    42.751 376
   143.058    42.261 377
   143.121    42.305 378
   142.674    42.689 379
   141.936    42.810 380
   143.065    42.271 381
   143.059    42.275 382
   143.095    42.319 383
   141.960    42.605 384
   143.088    42.408 385
   143.064    42.269 386
   143.715    42.371 387
   142.987    42.294 388
   142.980    42.303 389
   143.071    42.295 390
   141.866    42.759 391
   141.942    42.701 392
   143.136    42.294 393
   143.449    42.444 394
   143.777    42.394 395
   142.969    42.287 396
   142.879    42.187 397
   144.211    42.687 398
   142.642    42.217 399
   143.255    42.431 400
   142.552    42.425 401
   142.437    42.747 402
   143.088    42.330 403
   143.057    42.242 404
   142.631    42.351 405
   142.957    42.309 406
   143.033    42.298 407
   142.473    42.502 408
   143.008    42.272 409
   142.963    42.286 410
   143.112    42.321 411
   142.992    42.280 412
   142.959    42.161 413
   142.969    42.302 414
   143.010    42.318 415
   142.882    42.193 416
   142.974    42.451 417
   142.562    42.392 418
   143.082    42.319 419
   142.471    42.805 420
   142.394    42.696 421
   143.071    42.280 422
   144.066    42.459 423
   142.642    42.360 424
   143.093    42.328 425
   143.063    42.278 426
   143.010    42.298 427
   143.226    42.730 428
   143.088    42.308 429
   142.905    42.099 430
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
   143.048    42.309
   143.164    42.201
>
   143.734    42.506
   143.953    42.283
>
   143.180    42.274
   143.237    42.185
>
   143.050    42.252
   143.166    42.156
>
   143.185    42.279
   143.252    42.181
>
   143.109    42.279
   143.194    42.203
>
   143.041    42.221
   143.092    42.192
>
   143.325    42.381
   143.469    42.284
>
   142.498    42.168
   142.565    42.084
>
   142.612    42.275
   142.691    42.230
>
   142.521    42.317
   142.633    42.283
>
   143.162    42.232
   143.164    42.202
>
   143.001    42.499
   143.180    42.358
>
   143.140    42.459
   143.289    42.336
>
   143.137    42.401
   143.245    42.350
>
   143.147    42.449
   143.251    42.384
>
   143.184    42.415
   143.206    42.380
>
   143.189    42.235
   143.267    42.174
>
   143.059    42.263
   143.152    42.199
>
   143.056    42.253
   143.096    42.178
>
   143.186    42.284
   143.215    42.198
>
   143.178    42.292
   143.229    42.201
>
   143.136    42.302
   143.258    42.181
>
   143.139    42.451
   143.268    42.366
>
   143.087    42.257
   143.161    42.190
>
   142.652    42.351
   142.750    42.297
>
   144.068    42.616
   144.228    42.511
>
   142.671    42.155
   142.729    42.188
>
   142.534    42.190
   142.628    42.167
>
   142.972    42.289
   143.139    42.194
>
   142.614    42.461
   142.689    42.312
>
   143.179    42.260
   143.287    42.185
>
   143.162    42.240
   143.237    42.166
>
   143.155    42.235
   143.157    42.168
>
   141.869    42.567
   141.928    42.541
>
   143.090    42.256
   143.153    42.189
>
   143.176    42.249
   143.243    42.190
>
   142.521    42.186
   142.637    42.131
>
   143.186    42.268
   143.218    42.209
>
   142.564    42.168
   142.652    42.083
>
   142.432    42.254
   142.569    42.128
>
   142.607    42.262
   142.686    42.212
>
   142.627    42.254
   142.682    42.233
>
   142.529    42.226
   142.616    42.160
>
   142.569    42.178
   142.685    42.129
>
   142.554    42.287
   142.691    42.188
>
   142.601    42.255
   142.739    42.165
>
   142.486    42.242
   142.573    42.189
>
   142.538    42.239
   142.680    42.177
>
   142.456    42.238
   142.485    42.251
>
   142.672    42.152
   142.733    42.156
>
   142.346    42.198
   142.456    42.139
>
   142.436    42.241
   142.534    42.211
>
   142.560    42.285
   142.643    42.214
>
   142.449    42.259
   142.511    42.190
>
   142.438    42.191
   142.537    42.138
>
   142.437    42.247
   142.563    42.204
>
   142.389    42.239
   142.425    42.187
>
   143.144    42.249
   143.219    42.158
>
   142.537    42.349
   142.635    42.282
>
   142.615    42.354
   142.693    42.297
>
   142.706    42.165
   142.753    42.140
>
   142.629    42.203
   142.806    42.125
>
   142.588    42.296
   142.709    42.298
>
   143.253    42.220
   143.278    42.174
>
   142.779    42.259
   142.862    42.195
>
   142.423    42.215
   142.488    42.193
>
   142.738    42.289
   142.851    42.171
>
   142.756    42.259
   142.804    42.230
>
   143.050    42.432
   143.101    42.309
>
   142.539    42.259
   142.629    42.208
>
   143.477    42.678
   143.566    42.536
>
   142.500    42.317
   142.490    42.282
>
   143.199    42.294
   143.189    42.204
>
   143.136    42.387
   143.204    42.351
>
   143.146    42.446
   143.205    42.394
>
   143.112    42.292
   143.156    42.180
>
   142.504    42.168
   142.552    42.139
>
   142.344    42.279
   142.430    42.224
>
   143.124    42.242
   143.177    42.176
>
   143.157    42.261
   143.192    42.187
>
   143.173    42.249
   143.249    42.201
>
   143.048    42.259
   143.135    42.180
>
   143.038    42.276
   143.067    42.196
>
   143.159    42.236
   143.191    42.189
>
   143.047    42.283
   143.140    42.195
>
   142.380    42.209
   142.449    42.145
>
   142.591    42.197
   142.667    42.140
>
   143.159    42.259
   143.131    42.212
>
   142.920    42.710
   142.948    42.656
>
   142.593    42.258
   142.664    42.196
>
   143.108    42.276
   143.152    42.196
>
   142.760    42.228
   142.837    42.173
>
   142.842    42.212
   142.894    42.154
>
   143.029    42.247
   143.069    42.189
>
   143.735    42.526
   143.766    42.473
>
   143.143    42.363
   143.177    42.351
>
   143.092    42.255
   143.101    42.203
>
   142.484    42.788
   142.539    42.766
>
   143.047    42.236
   143.094    42.198
>
   142.803    42.344
   142.843    42.304
>
   142.593    42.744
   142.630    42.717
>
   142.504    42.475
   142.623    42.383
>
   143.204    42.249
   143.195    42.200
>
   142.064    42.722
   142.091    42.675
>
   143.046    42.398
   143.087    42.312
>
   142.044    42.430
   142.058    42.395
>
   142.491    42.278
   142.507    42.230
>
   142.520    42.270
   142.583    42.261
>
   142.797    42.371
   142.824    42.347
>
   143.131    42.219
   143.160    42.193
>
   142.673    42.229
   142.669    42.222
>
   142.950    42.178
   142.951    42.161
>
   143.318    42.756
   143.337    42.728
>
   143.252    42.244
   143.220    42.232
>
   143.081    42.225
   143.040    42.247
>
   142.610    42.240
   142.581    42.289
>
   142.580    42.860
   142.528    42.853
>
   142.820    42.600
   142.784    42.641
>
   143.730    42.430
   143.752    42.370
>
   141.992    42.492
   141.944    42.497
>
   141.962    42.509
   141.947    42.495
>
   142.410    42.680
   142.334    42.766
>
   142.710    42.190
   142.693    42.237
>
   143.100    42.470
   143.105    42.470
>
   142.572    42.284
   142.548    42.269
>
   143.180    42.300
   143.189    42.286
>
   142.620    42.310
   142.582    42.349
>
   143.120    42.320
   143.151    42.283
>
   142.410    42.360
   142.385    42.403
>
   143.156    42.207
   143.084    42.242
>
   143.101    42.227
   143.067    42.244
>
   142.460    42.470
   142.447    42.472
>
   142.750    42.350
   142.733    42.387
>
   143.930    42.570
   143.960    42.547
>
   143.680    42.440
   143.677    42.406
>
   143.132    42.233
   143.088    42.246
>
   143.504    42.756
   143.439    42.805
>
   143.011    42.263
   142.988    42.239
>
   143.410    42.450
   143.462    42.391
>
   142.610    42.740
   142.635    42.775
>
   143.254    42.248
   143.217    42.259
>
   142.574    42.477
   142.525    42.467
>
   143.110    42.340
   143.156    42.273
>
   143.240    42.770
   143.262    42.785
>
   142.440    42.770
   142.430    42.811
>
   142.890    42.180
   142.892    42.178
>
   142.772    42.166
   142.730    42.175
>
   143.550    42.510
   143.587    42.456
>
   142.754    42.162
   142.726    42.177
>
   142.860    42.620
   142.855    42.625
>
   143.528    42.602
   143.548    42.589
>
   143.098    42.351
   143.100    42.325
>
   143.150    42.304
   143.119    42.322
>
   143.083    42.477
   143.077    42.500
>
   143.398    42.719
   143.401    42.745
>
   143.115    42.324
   143.104    42.297
>
   143.043    42.365
   143.100    42.322
>
   143.044    42.277
   143.054    42.291
>
   144.097    42.661
   144.103    42.638
>
   143.581    42.550
   143.564    42.586
>
   142.506    42.200
   142.576    42.163
>
   142.941    42.336
   142.974    42.296
>
   143.427    42.456
   143.439    42.449
>
   143.112    42.336
   143.115    42.300
>
   142.576    42.464
   142.549    42.432
>
   142.482    42.210
   142.474    42.207
>
   143.039    42.268
   143.063    42.273
>
   142.995    42.282
   142.971    42.288
>
   143.214    42.284
   143.181    42.293
>
   143.489    42.374
   143.518    42.388
>
   143.050    42.332
   143.047    42.306
>
   143.086    42.364
   143.114    42.325
>
   143.496    42.564
   143.564    42.556
>
   142.975    42.354
   143.064    42.292
>
   143.837    42.543
   143.853    42.464
>
   143.867    42.479
   143.887    42.487
>
   143.196    42.201
   143.172    42.211
>
   143.011    42.237
   142.967    42.293
>
   142.930    42.253
   143.023    42.254
>
   142.999    42.399
   143.005    42.438
>
   143.015    42.294
   143.008    42.277
>
   143.265    42.211
   143.362    42.175
>
   143.072    42.361
   143.107    42.327
>
   143.113    42.332
   143.119    42.293
>
   142.789    42.215
   142.827    42.235
>
   143.093    42.389
   143.077    42.404
>
   142.919    42.162
   142.876    42.193
>
   143.034    42.365
   143.096    42.305
>
   143.106    42.340
   143.118    42.296
>
   142.975    42.323
   143.051    42.288
>
   143.096    42.321
   143.110    42.318
>
   142.951    42.368
   142.956    42.320
>
   143.108    42.266
   143.047    42.266
>
   143.078    42.517
   143.053    42.479
>
   143.001    42.330
   143.030    42.320
>
   143.188    42.291
   143.131    42.316
>
   143.045    42.282
   142.991    42.293
>
   143.020    42.260
   143.022    42.278
>
   143.063    42.297
   143.054    42.286
>
   143.195    42.377
   143.166    42.403
>
   143.064    42.371
   143.099    42.305
>
   142.653    42.562
   142.644    42.582
>
   142.992    42.321
   142.991    42.269
>
   143.166    42.186
   143.160    42.204
>
   143.589    42.458
   143.666    42.355
>
   142.897    42.224
   142.877    42.192
>
   143.076    42.362
   143.068    42.305
>
   143.054    42.301
   143.058    42.295
>
   143.181    42.286
   143.167    42.289
>
   142.999    42.290
   142.998    42.281
>
   143.312    42.470
   143.314    42.480
>
   143.030    42.242
   143.009    42.269
>
   143.575    42.489
   143.565    42.498
>
   143.113    42.394
   143.105    42.326
>
   143.668    42.382
   143.681    42.342
>
   143.063    42.382
   143.109    42.318
>
   142.937    42.367
   142.966    42.302
>
   143.069    42.247
   143.050    42.258
>
   142.926    42.197
   142.958    42.148
>
   143.382    42.675
   143.435    42.687
>
   142.161    42.331
   142.148    42.344
>
   141.605    42.498
   141.638    42.432
>
   143.682    42.418
   143.647    42.478
>
   143.036    42.299
   143.051    42.288
>
   142.615    42.244
   142.595    42.246
>
   143.081    42.367
   143.079    42.313
>
   143.209    42.391
   143.166    42.403
>
   143.033    42.274
   143.015    42.278
>
   142.994    42.350
   143.022    42.290
>
   142.292    42.241
   142.285    42.245
>
   141.437    42.987
   141.451    42.889
>
   143.120    42.283
   143.121    42.301
>
   142.971    42.352
   142.958    42.301
>
   142.576    42.245
   142.592    42.305
>
   143.129    42.322
   143.114    42.316
>
   143.297    42.691
   143.316    42.695
>
   142.607    42.252
   142.491    42.234
>
   142.531    42.194
   142.537    42.167
>
   142.672    42.194
   142.586    42.198
>
   142.691    42.546
   142.687    42.579
>
   142.930    42.215
   142.885    42.198
>
   143.112    42.291
   143.114    42.314
>
   143.014    42.470
   142.986    42.447
>
   143.035    42.354
   142.996    42.335
>
   143.102    42.327
   143.080    42.294
>
   143.076    42.286
   143.077    42.293
>
   143.002    42.173
   142.972    42.293
>
   142.610    42.650
   142.582    42.671
>
   143.113    42.316
   143.118    42.314
>
   143.750    42.424
   143.760    42.448
>
   143.078    42.173
   143.005    42.178
>
   142.979    42.278
   142.984    42.310
>
   143.130    42.191
   143.162    42.204
>
   142.999    42.323
   142.948    42.292
>
   143.082    42.228
   143.039    42.293
>
   143.027    42.204
   143.010    42.259
>
   143.077    42.321
   143.075    42.276
>
   142.511    42.288
   142.426    42.314
>
   142.902    42.158
   142.879    42.190
>
   143.081    42.242
   143.047    42.279
>
   142.597    42.431
   142.581    42.463
>
   143.181    42.288
   143.124    42.309
>
   142.790    42.612
   142.756    42.609
>
   142.699    42.729
   142.629    42.739
>
   142.695    42.730
   142.655    42.750
>
   143.669    42.504
   143.624    42.496
>
   141.381    42.636
   141.411    42.612
>
   143.049    42.331
   143.093    42.325
>
   144.133    42.618
   144.135    42.646
>
   142.689    42.741
   142.682    42.789
>
   142.649    42.432
   142.631    42.512
>
   141.797    42.549
   141.806    42.578
>
   141.840    42.611
   141.824    42.590
>
   143.017    42.308
   142.968    42.311
>
   143.044    42.278
   143.012    42.281
>
   142.583    42.334
   142.577    42.352
>
   143.077    42.310
   143.079    42.309
>
   143.587    42.421
   143.579    42.464
>
   144.049    42.549
   144.031    42.567
>
   143.227    42.248
   143.122    42.302
>
   143.129    42.226
   143.066    42.262
>
   142.955    42.240
   142.952    42.279
>
   143.001    42.262
   142.945    42.268
>
   143.193    42.360
   143.189    42.387
>
   143.012    42.246
   142.960    42.295
>
   143.048    42.235
   143.009    42.252
>
   143.101    42.244
   143.054    42.259
>
   143.088    42.306
   143.039    42.288
>
   143.173    42.307
   143.124    42.315
>
   143.033    42.278
   142.998    42.279
>
   143.026    42.308
   143.028    42.297
>
   142.972    42.257
   142.926    42.315
>
   143.081    42.316
   143.074    42.286
>
   141.888    42.789
   141.865    42.791
>
   141.880    42.763
   141.834    42.797
>
   143.027    42.220
   142.996    42.285
>
   143.922    42.554
   143.772    42.581
>
   143.112    42.305
   143.120    42.310
>
   142.589    42.431
   142.558    42.466
>
   143.644    42.424
   143.593    42.443
>
   143.048    42.292
   143.023    42.273
>
   142.006    42.639
   141.948    42.686
>
   141.926    42.635
   141.928    42.631
>
   141.962    42.551
   141.870    42.545
>
   141.954    42.799
   141.938    42.813
>
   141.973    42.695
   141.955    42.706
>
   142.019    42.697
   141.975    42.725
>
   141.932    42.673
   141.916    42.702
>
   141.938    42.667
   141.949    42.683
>
   141.991    42.629
   141.944    42.646
>
   141.983    42.566
   141.928    42.606
>
   141.979    42.666
   141.958    42.693
>
   141.989    42.646
   141.953    42.662
>
   141.976    42.678
   141.976    42.680
>
   141.980    42.591
   141.924    42.611
>
   142.004    42.742
   141.954    42.807
>
   141.983    42.604
   141.932    42.618
>
   141.982    42.621
   141.946    42.650
>
   141.976    42.659
   141.925    42.668
>
   141.964    42.772
   141.947    42.810
>
   141.967    42.583
   141.921    42.610
>
   141.972    42.688
   141.935    42.698
>
   141.942    42.679
   141.910    42.703
>
   141.945    42.576
   141.917    42.606
>
   141.961    42.556
   141.914    42.595
>
   141.979    42.782
   141.940    42.793
>
   141.988    42.661
   141.934    42.696
>
   142.014    42.770
   142.102    42.743
>
   141.920    42.562
   141.918    42.615
>
   141.945    42.664
   141.932    42.731
>
   141.921    42.537
   141.927    42.610
>
   141.956    42.587
   141.916    42.593
>
   141.916    42.668
   141.941    42.724
>
   141.982    42.729
   141.970    42.747
>
   141.980    42.674
   141.938    42.679
>
   141.926    42.650
   141.925    42.707
>
   142.007    42.781
   141.972    42.786
>
   142.006    42.709
   141.968    42.724
>
   141.973    42.633
   141.941    42.671
>
   142.032    42.769
   142.121    42.770
>
   141.975    42.683
   141.939    42.684
>
   141.957    42.548
   141.916    42.594
>
   141.972    42.685
   141.956    42.707
>
   141.917    42.767
   141.886    42.734
>
   141.987    42.798
   141.959    42.817
>
   141.953    42.652
   141.943    42.678
>
   141.993    42.557
   141.921    42.614
>
   141.992    42.705
   141.971    42.720
>
   141.948    42.665
   141.936    42.700
>
   141.961    42.640
   141.928    42.671
>
   141.934    42.816
   141.941    42.801
>
   141.962    42.588
   141.937    42.611
>
   141.881    42.705
   141.916    42.731
>
   141.989    42.639
   141.953    42.656
>
   143.041    42.273
   143.006    42.274
>
   141.975    42.570
   141.957    42.638
>
   141.956    42.739
   141.950    42.771
>
   142.052    42.439
   142.032    42.584
>
   141.996    42.784
   142.037    42.805
>
   142.098    42.539
   141.981    42.593
>
   141.949    42.654
   141.943    42.687
>
   141.957    42.554
   141.948    42.593
>
   141.923    42.599
   141.932    42.628
>
   141.930    42.587
   141.924    42.623
>
   141.940    42.595
   141.898    42.545
>
   141.946    42.818
   141.947    42.833
>
   142.944    42.292
   142.925    42.365
>
   143.056    42.270
   143.016    42.267
>
   141.982    42.681
   141.977    42.730
>
   141.981    42.702
   141.932    42.687
>
   143.144    42.323
   143.095    42.296
>
   141.999    42.778
   141.959    42.760
>
   141.952    42.777
   141.936    42.771
>
   141.965    42.725
   141.920    42.758
>
   141.995    42.762
   141.948    42.751
>
   143.083    42.243
   143.058    42.261
>
   143.138    42.295
   143.121    42.305
>
   142.737    42.624
   142.674    42.689
>
   141.947    42.759
   141.936    42.810
>
   143.089    42.280
   143.065    42.271
>
   143.102    42.266
   143.059    42.275
>
   143.079    42.344
   143.095    42.319
>
   142.000    42.557
   141.960    42.605
>
   143.107    42.375
   143.088    42.408
>
   143.073    42.247
   143.064    42.269
>
   143.673    42.404
   143.715    42.371
>
   143.001    42.262
   142.987    42.294
>
   142.978    42.321
   142.980    42.303
>
   143.082    42.321
   143.071    42.295
>
   141.879    42.722
   141.866    42.759
>
   141.977    42.668
   141.942    42.701
>
   143.159    42.338
   143.136    42.294
>
   143.445    42.437
   143.449    42.444
>
   143.782    42.392
   143.777    42.394
>
   142.993    42.259
   142.969    42.287
>
   142.880    42.180
   142.879    42.187
>
   144.230    42.699
   144.211    42.687
>
   142.684    42.214
   142.642    42.217
>
   143.287    42.446
   143.255    42.431
>
   142.574    42.394
   142.552    42.425
>
   142.472    42.726
   142.437    42.747
>
   143.082    42.407
   143.088    42.330
>
   143.064    42.258
   143.057    42.242
>
   142.646    42.356
   142.631    42.351
>
   143.004    42.323
   142.957    42.309
>
   143.077    42.315
   143.033    42.298
>
   142.571    42.507
   142.473    42.502
>
   143.033    42.238
   143.008    42.272
>
   142.974    42.312
   142.963    42.286
>
   143.099    42.348
   143.112    42.321
>
   143.044    42.294
   142.992    42.280
>
   142.974    42.175
   142.959    42.161
>
   142.989    42.301
   142.969    42.302
>
   142.926    42.373
   143.010    42.318
>
   142.887    42.164
   142.882    42.193
>
   142.969    42.468
   142.974    42.451
>
   142.600    42.396
   142.562    42.392
>
   143.084    42.351
   143.082    42.319
>
   142.467    42.845
   142.471    42.805
>
   142.301    42.664
   142.394    42.696
>
   143.004    42.384
   143.071    42.280
>
   143.973    42.522
   144.066    42.459
>
   142.668    42.465
   142.642    42.360
>
   143.035    42.327
   143.093    42.328
>
   143.115    42.268
   143.063    42.278
>
   142.940    42.317
   143.010    42.298
>
   143.245    42.732
   143.226    42.730
>
   143.064    42.386
   143.088    42.308
>
   142.587    42.372
   142.905    42.099
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
   143.162    42.202
   143.164    42.201
>
   143.949    42.285
   143.953    42.283
>
   143.234    42.187
   143.237    42.185
>
   143.167    42.156
   143.166    42.156
>
   143.248    42.182
   143.252    42.181
>
   143.190    42.204
   143.194    42.203
>
   143.089    42.194
   143.092    42.192
>
   143.465    42.286
   143.469    42.284
>
   142.564    42.086
   142.565    42.084
>
   142.687    42.233
   142.691    42.230
>
   142.631    42.285
   142.633    42.283
>
   143.163    42.204
   143.164    42.202
>
   143.176    42.360
   143.180    42.358
>
   143.282    42.339
   143.289    42.336
>
   143.239    42.352
   143.245    42.350
>
   143.244    42.387
   143.251    42.384
>
   143.203    42.382
   143.206    42.380
>
   143.263    42.176
   143.267    42.174
>
   143.150    42.202
   143.152    42.199
>
   143.095    42.179
   143.096    42.178
>
   143.213    42.199
   143.215    42.198
>
   143.226    42.203
   143.229    42.201
>
   143.255    42.183
   143.258    42.181
>
   143.265    42.369
   143.268    42.366
>
   143.157    42.192
   143.161    42.190
>
   142.747    42.299
   142.750    42.297
>
   144.226    42.513
   144.228    42.511
>
   142.724    42.190
   142.729    42.188
>
   142.627    42.169
   142.628    42.167
>
   143.135    42.196
   143.139    42.194
>
   142.687    42.313
   142.689    42.312
>
   143.285    42.187
   143.287    42.185
>
   143.234    42.168
   143.237    42.166
>
   143.154    42.169
   143.157    42.168
>
   141.925    42.544
   141.928    42.541
>
   143.152    42.191
   143.153    42.189
>
   143.241    42.192
   143.243    42.190
>
   142.631    42.132
   142.637    42.131
>
   143.216    42.210
   143.218    42.209
>
   142.650    42.084
   142.652    42.083
>
   142.567    42.129
   142.569    42.128
>
   142.684    42.212
   142.686    42.212
>
   142.678    42.235
   142.682    42.233
>
   142.615    42.161
   142.616    42.160
>
   142.682    42.131
   142.685    42.129
>
   142.690    42.189
   142.691    42.188
>
   142.730    42.168
   142.739    42.165
>
   142.573    42.191
   142.573    42.189
>
   142.678    42.178
   142.680    42.177
>
   142.482    42.253
   142.485    42.251
>
   142.731    42.156
   142.733    42.156
>
   142.452    42.141
   142.456    42.139
>
   142.536    42.210
   142.534    42.211
>
   142.638    42.216
   142.643    42.214
>
   142.509    42.191
   142.511    42.190
>
   142.535    42.140
   142.537    42.138
>
   142.565    42.203
   142.563    42.204
>
   142.423    42.189
   142.425    42.187
>
   143.219    42.159
   143.219    42.158
>
   142.636    42.281
   142.635    42.282
>
   142.689    42.299
   142.693    42.297
>
   142.751    42.141
   142.753    42.140
>
   142.800    42.127
   142.806    42.125
>
   142.707    42.299
   142.709    42.298
>
   143.276    42.176
   143.278    42.174
>
   142.860    42.196
   142.862    42.195
>
   142.486    42.194
   142.488    42.193
>
   142.849    42.172
   142.851    42.171
>
   142.801    42.232
   142.804    42.230
>
   143.098    42.310
   143.101    42.309
>
   142.627    42.210
   142.629    42.208
>
   143.564    42.538
   143.566    42.536
>
   142.485    42.284
   142.490    42.282
>
   143.187    42.205
   143.189    42.204
>
   143.199    42.353
   143.204    42.351
>
   143.204    42.395
   143.205    42.394
>
   143.153    42.182
   143.156    42.180
>
   142.538    42.150
   142.552    42.139
>
   142.432    42.223
   142.430    42.224
>
   143.174    42.177
   143.177    42.176
>
   143.190    42.188
   143.192    42.187
>
   143.246    42.203
   143.249    42.201
>
   143.134    42.182
   143.135    42.180
>
   143.065    42.198
   143.067    42.196
>
   143.189    42.190
   143.191    42.189
>
   143.138    42.196
   143.140    42.195
>
   142.450    42.144
   142.449    42.145
>
   142.665    42.141
   142.667    42.140
>
   143.128    42.213
   143.131    42.212
>
   142.947    42.656
   142.948    42.656
>
   142.662    42.196
   142.664    42.196
>
   143.149    42.197
   143.152    42.196
>
   142.834    42.174
   142.837    42.173
>
   142.890    42.157
   142.894    42.154
>
   143.067    42.190
   143.069    42.189
>
   143.763    42.474
   143.766    42.473
>
   143.174    42.353
   143.177    42.351
>
   143.099    42.204
   143.101    42.203
>
   142.539    42.766
   142.539    42.766
>
   143.091    42.199
   143.094    42.198
>
   142.840    42.305
   142.843    42.304
>
   142.629    42.718
   142.630    42.717
>
   142.622    42.384
   142.623    42.383
>
   143.193    42.201
   143.195    42.200
>
   142.088    42.677
   142.091    42.675
>
   143.084    42.313
   143.087    42.312
>
   142.057    42.395
   142.058    42.395
>
   142.506    42.231
   142.507    42.230
>
   142.581    42.262
   142.583    42.261
>
   142.823    42.347
   142.824    42.347
>
   143.158    42.194
   143.160    42.193
>
   142.667    42.223
   142.669    42.222
>
   142.949    42.163
   142.951    42.161
>
   143.336    42.729
   143.337    42.728
>
   143.216    42.233
   143.220    42.232
>
   143.040    42.247
   143.040    42.247
>
   142.581    42.288
   142.581    42.289
>
   142.527    42.853
   142.528    42.853
>
   142.783    42.642
   142.784    42.641
>
   143.751    42.371
   143.752    42.370
>
   141.942    42.496
   141.944    42.497
>
   141.943    42.498
   141.947    42.495
>
   142.334    42.766
   142.334    42.766
>
   142.693    42.237
   142.693    42.237
>
   143.103    42.471
   143.105    42.470
>
   142.547    42.270
   142.548    42.269
>
   143.188    42.287
   143.189    42.286
>
   142.582    42.349
   142.582    42.349
>
   143.150    42.283
   143.151    42.283
>
   142.384    42.403
   142.385    42.403
>
   143.083    42.242
   143.084    42.242
>
   143.066    42.244
   143.067    42.244
>
   142.446    42.474
   142.447    42.472
>
   142.732    42.386
   142.733    42.387
>
   143.959    42.547
   143.960    42.547
>
   143.676    42.407
   143.677    42.406
>
   143.087    42.247
   143.088    42.246
>
   143.439    42.805
   143.439    42.805
>
   142.987    42.239
   142.988    42.239
>
   143.461    42.392
   143.462    42.391
>
   142.636    42.774
   142.635    42.775
>
   143.216    42.259
   143.217    42.259
>
   142.524    42.467
   142.525    42.467
>
   143.156    42.274
   143.156    42.273
>
   143.261    42.785
   143.262    42.785
>
   142.429    42.811
   142.430    42.811
>
   142.891    42.178
   142.892    42.178
>
   142.730    42.175
   142.730    42.175
>
   143.586    42.457
   143.587    42.456
>
   142.725    42.176
   142.726    42.177
>
   142.855    42.625
   142.855    42.625
>
   143.547    42.589
   143.548    42.589
>
   143.099    42.325
   143.100    42.325
>
   143.118    42.322
   143.119    42.322
>
   143.076    42.500
   143.077    42.500
>
   143.400    42.745
   143.401    42.745
>
   143.104    42.297
   143.104    42.297
>
   143.099    42.322
   143.100    42.322
>
   143.053    42.291
   143.054    42.291
>
   144.103    42.638
   144.103    42.638
>
   143.563    42.586
   143.564    42.586
>
   142.575    42.162
   142.576    42.163
>
   142.973    42.296
   142.974    42.296
>
   143.439    42.450
   143.439    42.449
>
   143.114    42.301
   143.115    42.300
>
   142.547    42.432
   142.549    42.432
>
   142.473    42.206
   142.474    42.207
>
   143.063    42.273
   143.063    42.273
>
   142.971    42.288
   142.971    42.288
>
   143.180    42.293
   143.181    42.293
>
   143.518    42.389
   143.518    42.388
>
   143.046    42.306
   143.047    42.306
>
   143.113    42.326
   143.114    42.325
>
   143.563    42.556
   143.564    42.556
>
   143.063    42.292
   143.064    42.292
>
   143.853    42.463
   143.853    42.464
>
   143.887    42.487
   143.887    42.487
>
   143.171    42.211
   143.172    42.211
>
   142.967    42.293
   142.967    42.293
>
   143.022    42.254
   143.023    42.254
>
   143.004    42.437
   143.005    42.438
>
   143.008    42.277
   143.008    42.277
>
   143.362    42.174
   143.362    42.175
>
   143.106    42.328
   143.107    42.327
>
   143.118    42.293
   143.119    42.293
>
   142.827    42.235
   142.827    42.235
>
   143.076    42.404
   143.077    42.404
>
   142.876    42.193
   142.876    42.193
>
   143.095    42.305
   143.096    42.305
>
   143.117    42.296
   143.118    42.296
>
   143.050    42.288
   143.051    42.288
>
   143.110    42.318
   143.110    42.318
>
   142.954    42.320
   142.956    42.320
>
   143.047    42.266
   143.047    42.266
>
   143.052    42.478
   143.053    42.479
>
   143.029    42.321
   143.030    42.320
>
   143.131    42.317
   143.131    42.316
>
   142.991    42.293
   142.991    42.293
>
   143.022    42.278
   143.022    42.278
>
   143.054    42.286
   143.054    42.286
>
   143.165    42.403
   143.166    42.403
>
   143.098    42.305
   143.099    42.305
>
   142.645    42.581
   142.644    42.582
>
   142.990    42.269
   142.991    42.269
>
   143.159    42.204
   143.160    42.204
>
   143.666    42.356
   143.666    42.355
>
   142.877    42.192
   142.877    42.192
>
   143.067    42.305
   143.068    42.305
>
   143.057    42.296
   143.058    42.295
>
   143.166    42.289
   143.167    42.289
>
   142.998    42.281
   142.998    42.281
>
   143.313    42.480
   143.314    42.480
>
   143.008    42.269
   143.009    42.269
>
   143.565    42.498
   143.565    42.498
>
   143.105    42.326
   143.105    42.326
>
   143.681    42.342
   143.681    42.342
>
   143.108    42.318
   143.109    42.318
>
   142.965    42.303
   142.966    42.302
>
   143.049    42.257
   143.050    42.258
>
   142.957    42.148
   142.958    42.148
>
   143.435    42.687
   143.435    42.687
>
   142.148    42.345
   142.148    42.344
>
   141.638    42.434
   141.638    42.432
>
   143.648    42.478
   143.647    42.478
>
   143.050    42.288
   143.051    42.288
>
   142.595    42.245
   142.595    42.246
>
   143.078    42.313
   143.079    42.313
>
   143.165    42.403
   143.166    42.403
>
   143.015    42.278
   143.015    42.278
>
   143.022    42.290
   143.022    42.290
>
   142.284    42.244
   142.285    42.245
>
   141.452    42.888
   141.451    42.889
>
   143.120    42.301
   143.121    42.301
>
   142.957    42.301
   142.958    42.301
>
   142.592    42.305
   142.592    42.305
>
   143.113    42.317
   143.114    42.316
>
   143.316    42.695
   143.316    42.695
>
   142.491    42.234
   142.491    42.234
>
   142.536    42.167
   142.537    42.167
>
   142.585    42.199
   142.586    42.198
>
   142.686    42.579
   142.687    42.579
>
   142.885    42.198
   142.885    42.198
>
   143.113    42.315
   143.114    42.314
>
   142.985    42.447
   142.986    42.447
>
   142.995    42.335
   142.996    42.335
>
   143.080    42.294
   143.080    42.294
>
   143.077    42.293
   143.077    42.293
>
   142.972    42.292
   142.972    42.293
>
   142.581    42.671
   142.582    42.671
>
   143.117    42.314
   143.118    42.314
>
   143.760    42.448
   143.760    42.448
>
   143.004    42.178
   143.005    42.178
>
   142.984    42.309
   142.984    42.310
>
   143.161    42.204
   143.162    42.204
>
   142.947    42.293
   142.948    42.292
>
   143.038    42.294
   143.039    42.293
>
   143.009    42.259
   143.010    42.259
>
   143.075    42.276
   143.075    42.276
>
   142.425    42.315
   142.426    42.314
>
   142.877    42.190
   142.879    42.190
>
   143.046    42.279
   143.047    42.279
>
   142.580    42.463
   142.581    42.463
>
   143.123    42.309
   143.124    42.309
>
   142.757    42.609
   142.756    42.609
>
   142.628    42.739
   142.629    42.739
>
   142.654    42.750
   142.655    42.750
>
   143.624    42.496
   143.624    42.496
>
   141.410    42.612
   141.411    42.612
>
   143.091    42.326
   143.093    42.325
>
   144.135    42.646
   144.135    42.646
>
   142.682    42.788
   142.682    42.789
>
   142.630    42.511
   142.631    42.512
>
   141.805    42.578
   141.806    42.578
>
   141.824    42.590
   141.824    42.590
>
   142.967    42.311
   142.968    42.311
>
   143.011    42.281
   143.012    42.281
>
   142.577    42.352
   142.577    42.352
>
   143.078    42.308
   143.079    42.309
>
   143.579    42.464
   143.579    42.464
>
   144.031    42.567
   144.031    42.567
>
   143.121    42.302
   143.122    42.302
>
   143.065    42.262
   143.066    42.262
>
   142.952    42.279
   142.952    42.279
>
   142.944    42.268
   142.945    42.268
>
   143.187    42.388
   143.189    42.387
>
   142.960    42.295
   142.960    42.295
>
   143.008    42.252
   143.009    42.252
>
   143.053    42.259
   143.054    42.259
>
   143.037    42.288
   143.039    42.288
>
   143.123    42.316
   143.124    42.315
>
   142.997    42.280
   142.998    42.279
>
   143.027    42.297
   143.028    42.297
>
   142.925    42.315
   142.926    42.315
>
   143.073    42.286
   143.074    42.286
>
   141.865    42.791
   141.865    42.791
>
   141.835    42.796
   141.834    42.797
>
   142.995    42.285
   142.996    42.285
>
   143.771    42.581
   143.772    42.581
>
   143.119    42.310
   143.120    42.310
>
   142.557    42.466
   142.558    42.466
>
   143.593    42.443
   143.593    42.443
>
   143.022    42.273
   143.023    42.273
>
   141.947    42.686
   141.948    42.686
>
   141.927    42.631
   141.928    42.631
>
   141.870    42.544
   141.870    42.545
>
   141.938    42.813
   141.938    42.813
>
   141.955    42.705
   141.955    42.706
>
   141.977    42.725
   141.975    42.725
>
   141.916    42.702
   141.916    42.702
>
   141.949    42.683
   141.949    42.683
>
   141.944    42.646
   141.944    42.646
>
   141.929    42.605
   141.928    42.606
>
   141.957    42.693
   141.958    42.693
>
   141.953    42.662
   141.953    42.662
>
   141.975    42.680
   141.976    42.680
>
   141.924    42.611
   141.924    42.611
>
   141.954    42.806
   141.954    42.807
>
   141.931    42.617
   141.932    42.618
>
   141.947    42.649
   141.946    42.650
>
   141.926    42.668
   141.925    42.668
>
   141.947    42.810
   141.947    42.810
>
   141.921    42.609
   141.921    42.610
>
   141.935    42.698
   141.935    42.698
>
   141.910    42.703
   141.910    42.703
>
   141.917    42.605
   141.917    42.606
>
   141.914    42.595
   141.914    42.595
>
   141.940    42.793
   141.940    42.793
>
   141.933    42.696
   141.934    42.696
>
   142.071    42.770
   142.102    42.743
>
   141.918    42.615
   141.918    42.615
>
   141.932    42.730
   141.932    42.731
>
   141.928    42.610
   141.927    42.610
>
   141.916    42.593
   141.916    42.593
>
   141.941    42.724
   141.941    42.724
>
   141.970    42.747
   141.970    42.747
>
   141.938    42.678
   141.938    42.679
>
   141.925    42.707
   141.925    42.707
>
   141.972    42.786
   141.972    42.786
>
   141.967    42.723
   141.968    42.724
>
   141.941    42.671
   141.941    42.671
>
   142.120    42.770
   142.121    42.770
>
   141.939    42.683
   141.939    42.684
>
   141.916    42.593
   141.916    42.594
>
   141.956    42.707
   141.956    42.707
>
   141.886    42.733
   141.886    42.734
>
   141.961    42.818
   141.959    42.817
>
   141.943    42.678
   141.943    42.678
>
   141.922    42.614
   141.921    42.614
>
   141.970    42.719
   141.971    42.720
>
   141.936    42.700
   141.936    42.700
>
   141.928    42.671
   141.928    42.671
>
   141.941    42.801
   141.941    42.801
>
   141.928    42.610
   141.937    42.611
>
   141.915    42.734
   141.916    42.731
>
   141.953    42.656
   141.953    42.656
>
   143.005    42.274
   143.006    42.274
>
   141.957    42.638
   141.957    42.638
>
   141.950    42.770
   141.950    42.771
>
   142.031    42.583
   142.032    42.584
>
   142.037    42.804
   142.037    42.805
>
   141.979    42.594
   141.981    42.593
>
   141.942    42.686
   141.943    42.687
>
   141.948    42.593
   141.948    42.593
>
   141.932    42.628
   141.932    42.628
>
   141.923    42.622
   141.924    42.623
>
   141.897    42.544
   141.898    42.545
>
   141.947    42.832
   141.947    42.833
>
   142.924    42.365
   142.925    42.365
>
   143.015    42.267
   143.016    42.267
>
   141.977    42.730
   141.977    42.730
>
   141.933    42.686
   141.932    42.687
>
   143.094    42.297
   143.095    42.296
>
   141.959    42.760
   141.959    42.760
>
   141.936    42.771
   141.936    42.771
>
   141.920    42.757
   141.920    42.758
>
   141.947    42.751
   141.948    42.751
>
   143.057    42.261
   143.058    42.261
>
   143.120    42.305
   143.121    42.305
>
   142.673    42.689
   142.674    42.689
>
   141.935    42.810
   141.936    42.810
>
   143.064    42.272
   143.065    42.271
>
   143.058    42.275
   143.059    42.275
>
   143.093    42.319
   143.095    42.319
>
   141.959    42.604
   141.960    42.605
>
   143.087    42.409
   143.088    42.408
>
   143.063    42.269
   143.064    42.269
>
   143.715    42.371
   143.715    42.371
>
   142.986    42.294
   142.987    42.294
>
   142.980    42.303
   142.980    42.303
>
   143.070    42.295
   143.071    42.295
>
   141.866    42.759
   141.866    42.759
>
   141.942    42.701
   141.942    42.701
>
   143.135    42.294
   143.136    42.294
>
   143.447    42.444
   143.449    42.444
>
   143.777    42.394
   143.777    42.394
>
   142.969    42.287
   142.969    42.287
>
   142.878    42.188
   142.879    42.187
>
   144.210    42.687
   144.211    42.687
>
   142.641    42.217
   142.642    42.217
>
   143.254    42.431
   143.255    42.431
>
   142.552    42.425
   142.552    42.425
>
   142.437    42.746
   142.437    42.747
>
   143.088    42.330
   143.088    42.330
>
   143.056    42.242
   143.057    42.242
>
   142.630    42.351
   142.631    42.351
>
   142.956    42.309
   142.957    42.309
>
   143.032    42.298
   143.033    42.298
>
   142.472    42.502
   142.473    42.502
>
   143.008    42.272
   143.008    42.272
>
   142.961    42.287
   142.963    42.286
>
   143.111    42.321
   143.112    42.321
>
   142.991    42.280
   142.992    42.280
>
   142.958    42.162
   142.959    42.161
>
   142.969    42.302
   142.969    42.302
>
   143.009    42.318
   143.010    42.318
>
   142.881    42.193
   142.882    42.193
>
   142.974    42.451
   142.974    42.451
>
   142.561    42.393
   142.562    42.392
>
   143.081    42.319
   143.082    42.319
>
   142.471    42.804
   142.471    42.805
>
   142.393    42.695
   142.394    42.696
>
   143.071    42.280
   143.071    42.280
>
   144.066    42.459
   144.066    42.459
>
   142.642    42.360
   142.642    42.360
>
   143.092    42.328
   143.093    42.328
>
   143.062    42.279
   143.063    42.278
>
   143.009    42.298
   143.010    42.298
>
   143.226    42.730
   143.226    42.730
>
   143.087    42.308
   143.088    42.308
>
   142.903    42.101
   142.905    42.099
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
   143.164    42.201    26.765     1.917     3.561
   143.953    42.283    34.282     1.739     3.336
   143.237    42.185    28.324     2.267     4.679
   143.166    42.156    31.549     2.776     5.117
   143.252    42.181    55.822     4.520     6.759
   143.194    42.203    44.905     2.435     3.712
   143.092    42.192    63.829     3.600     5.691
   143.469    42.284    36.713     5.130    10.146
   142.565    42.084    35.504     2.704     4.435
   142.691    42.230    43.794     4.008     6.170
   142.633    42.283    23.546     1.839     3.577
   143.164    42.202    31.806     1.890     3.375
   143.180    42.358    29.738     1.561     2.672
   143.289    42.336    43.237     4.405     8.643
   143.245    42.350    32.926     3.391     5.708
   143.251    42.384    43.477     3.411     6.245
   143.206    42.380    38.655     3.856     7.524
   143.267    42.174    41.421     3.616     6.085
   143.152    42.199    37.397     2.623     4.602
   143.096    42.178    34.872     2.133     3.599
   143.215    42.198    27.862     1.850     3.020
   143.229    42.201    37.752     2.136     3.318
   143.258    42.181    46.519     2.663     4.384
   143.268    42.366    51.848     3.343     5.572
   143.161    42.190    47.712     2.279     3.413
   142.750    42.297    60.843     3.929     5.092
   144.228    42.511    47.814     3.823     7.335
   142.729    42.188    45.482     3.167     4.437
   142.628    42.167    45.795     2.965     3.884
   143.139    42.194    27.211     2.841     4.477
   142.689    42.312    23.708     1.751     3.335
   143.287    42.185    24.119     2.687     4.349
   143.237    42.166    27.432     2.212     4.016
   143.157    42.168    22.762     1.577     3.094
   141.928    42.541    19.540     2.055     3.283
   143.153    42.189    27.179     1.633     3.324
   143.243    42.190    26.297     2.233     4.877
   142.637    42.131    19.529     2.875     6.478
   143.218    42.209    25.093     2.539     5.222
   142.652    42.083    32.549     2.225     3.653
   142.569    42.128    30.127     1.376     2.146
   142.686    42.212    32.131     3.398     5.656
   142.682    42.233    34.600     2.549     4.825
   142.616    42.160    29.092     2.433     4.450
   142.685    42.129    46.329     3.851     6.771
   142.691    42.188    31.890     1.520     2.126
   142.739    42.165    40.624     3.051     6.752
   142.573    42.189    33.202     2.962     5.090
   142.680    42.177    28.038     2.325     5.125
   142.485    42.251    23.957     2.986     4.965
   142.733    42.156    25.974     1.871     4.406
   142.456    42.139    41.186     3.401     5.765
   142.534    42.211    27.315     2.464     3.379
   142.643    42.214    35.112     1.485     2.574
   142.511    42.190    35.037     2.757     4.321
   142.537    42.138    32.521     1.763     3.499
   142.563    42.204    35.827     1.643     3.465
   142.425    42.187    49.186     1.949     2.572
   143.219    42.158    34.690     4.183     8.475
   142.635    42.282    28.285     3.437     4.085
   142.693    42.297    22.314     2.947     7.132
   142.753    42.140    31.539     1.577     3.057
   142.806    42.125    25.953     3.927     9.142
   142.709    42.298    20.215     2.910     5.715
   143.278    42.174    24.291     2.553     6.281
   142.862    42.195    30.891     2.993     5.514
   142.488    42.193    29.257     3.090     5.312
   142.851    42.171    35.316     1.741     3.367
   142.804    42.230    29.625     1.958     4.306
   143.101    42.309    27.671     1.683     3.355
   142.629    42.208    31.527     2.372     4.475
   143.566    42.536    31.718     1.856     2.778
   142.490    42.282    31.877     2.735     3.820
   143.189    42.204    33.484     1.308     2.384
   143.204    42.351    30.250     3.151     6.561
   143.205    42.394    36.349     3.210     5.760
   143.156    42.180    26.054     1.714     3.513
   142.552    42.139    33.690     3.845     5.423
   142.430    42.224    30.274     3.052     5.192
   143.177    42.176    23.479     2.013     4.440
   143.192    42.187    30.228     1.161     2.217
   143.249    42.201    25.110     2.159     5.009
   143.135    42.180    28.198     2.713     5.718
   143.067    42.196    30.586     1.478     2.882
   143.191    42.189    26.945     1.798     3.929
   143.140    42.195    24.582     1.873     4.058
   142.449    42.145    32.327     3.123     5.665
   142.667    42.140    30.985     3.168     6.642
   143.131    42.212    29.885     1.354     2.361
   142.948    42.656    29.482     2.514     3.316
   142.664    42.196    23.794     2.419     4.361
   143.152    42.196    29.398     1.851     3.584
   142.837    42.173    29.721     1.285     2.040
   142.894    42.154    33.037     2.825     6.339
   143.069    42.189    28.613     1.610     2.972
   143.766    42.473    29.585     3.237     5.653
   143.177    42.351    37.013     2.438     3.856
   143.101    42.203    29.025     1.146     2.507
   142.539    42.766    41.998     2.877     3.940
   143.094    42.198    37.198     1.971     3.704
   142.843    42.304    31.310     2.793     4.587
   142.630    42.717    55.403     3.052     3.318
   142.623    42.383    18.144     3.654     4.653
   143.195    42.200    26.597     1.153     2.549
   142.091    42.675    47.421     3.672     4.673
   143.087    42.312    27.524     1.503     2.905
   142.058    42.395    65.402     2.823     4.084
   142.507    42.230    55.540     2.542     4.029
   142.583    42.261    52.456     2.532     4.108
   142.824    42.347    22.622     2.212     3.753
   143.160    42.193    35.420     1.312     2.666
   142.669    42.222    36.563     2.155     4.187
   142.951    42.161    42.076     2.474     4.724
   143.337    42.728    26.278     2.190     4.331
   143.220    42.232    31.024     1.672     3.583
   143.040    42.247    33.595     1.500     2.671
   142.581    42.289    59.060     1.369     2.148
   142.528    42.853    58.607     1.866     2.634
   142.784    42.641    58.249     1.817     3.039
   143.752    42.370    37.999     2.176     4.174
   141.944    42.497    58.620     1.293     2.006
   141.947    42.495    56.902     1.587     2.169
   142.334    42.766    33.359     1.436     2.889
   142.693    42.237    57.028     1.533     3.035
   143.105    42.470    48.447     1.541     2.641
   142.548    42.269    60.479     1.645     2.860
   143.189    42.286    44.010     1.333     2.627
   142.582    42.349    60.845     2.059     3.085
   143.151    42.283    50.915     1.643     3.163
   142.385    42.403   -47.493     1.825     2.046
   143.084    42.242    25.103     1.068     1.880
   143.067    42.244    46.567     1.463     2.440
   142.447    42.472   -36.153     2.005     2.083
   142.733    42.387    61.227     1.749     3.005
   143.960    42.547    25.216     1.918     3.557
   143.677    42.406    27.911     1.591     3.255
   143.088    42.246    40.851     1.359     2.332
   143.439    42.805     6.786     1.864     3.539
   142.988    42.239    25.950     1.298     2.703
   143.462    42.391    44.628     2.636     5.070
   142.635    42.775    67.598     2.433     4.260
   143.217    42.259    36.895     1.326     2.195
   142.525    42.467    21.221     1.913     2.187
   143.156    42.273    48.103     1.527     2.844
   143.262    42.785    54.614     1.471     2.257
   142.430    42.811    44.117     1.991     2.389
   142.892    42.178    56.833     1.169     1.891
   142.730    42.175    53.505     1.440     2.214
   143.587    42.456    36.307     2.544     4.714
   142.726    42.177    43.514     1.325     2.099
   142.855    42.625    56.161     1.852     2.744
   143.548    42.589    55.358     2.341     4.331
   143.100    42.325    58.572     1.836     3.614
   143.119    42.322    62.714     2.347     4.417
   143.077    42.500    65.620     2.324     5.824
   143.401    42.745    52.869     2.244     3.667
   143.104    42.297    60.923     1.987     4.073
   143.100    42.322    63.368     1.713     3.139
   143.054    42.291    59.965     2.229     4.445
   144.103    42.638    64.252     2.442     3.734
   143.564    42.586    62.432     2.469     4.177
   142.576    42.163    71.327     1.430     2.782
   142.974    42.296    63.525     1.800     4.111
   143.439    42.449    54.529     2.648     4.365
   143.115    42.300    59.914     1.923     3.781
   142.549    42.432    74.737     1.883     2.548
   142.474    42.207    66.035     2.283     4.400
   143.063    42.273    64.894     1.450     2.343
   142.971    42.288    69.362     2.111     3.809
   143.181    42.293    61.400     2.941     5.308
   143.518    42.388    54.742     2.640     4.989
   143.047    42.306    62.827     1.764     3.333
   143.114    42.325    61.241     1.696     3.434
   143.564    42.556    52.775     2.402     4.839
   143.064    42.292    63.461     2.118     3.804
   143.853    42.464    53.004     2.368     4.104
   143.887    42.487    49.516     2.755     4.772
   143.172    42.211    54.506     2.173     4.478
   142.967    42.293    68.078     1.783     3.191
   143.023    42.254    45.327     1.504     2.545
   143.005    42.438    56.466     1.294     2.125
   143.008    42.277    68.874     1.988     3.274
   143.362    42.175    59.792     2.419     5.755
   143.107    42.327    66.864     1.631     3.105
   143.119    42.293    53.453     1.784     3.110
   142.827    42.235    73.126     4.396     8.198
   143.077    42.404    63.800     2.672     4.875
   142.876    42.193    64.713     2.240     4.223
   143.096    42.305    52.410     1.066     1.819
   143.118    42.296    51.161     1.247     2.051
   143.051    42.288    54.420     1.217     1.793
   143.110    42.318    62.462     2.254     3.983
   142.956    42.320    66.843     2.093     4.179
   143.047    42.266    56.450     2.706     4.008
   143.053    42.479    60.433     2.464     4.063
   143.030    42.320    66.655     1.707     3.324
   143.131    42.316    61.147     2.811     5.590
   142.991    42.293    65.346     2.037     3.654
   143.022    42.278    53.501     3.212     4.969
   143.054    42.286    65.579     2.360     4.020
   143.166    42.403    54.569     1.945     3.272
   143.099    42.305    74.933     1.217     2.328
   142.644    42.582    75.664     3.109     3.791
   142.991    42.269    58.186     2.712     4.809
   143.160    42.204    56.712     1.894     3.713
   143.666    42.355    57.558     1.090     1.690
   142.877    42.192    69.793     2.369     4.429
   143.068    42.305    64.377     2.014     3.757
   143.058    42.295    62.138     1.580     3.004
   143.167    42.289    60.591     2.476     4.249
   142.998    42.281    66.568     2.023     3.087
   143.314    42.480    53.839     2.898     5.366
   143.009    42.269    60.890     2.831     4.298
   143.565    42.498    53.289     2.673     5.602
   143.105    42.326    56.646     2.035     3.658
   143.681    42.342    46.012     2.866     5.487
   143.109    42.318    62.024     1.960     3.751
   142.966    42.302    72.454     1.760     3.302
   143.050    42.258    66.204     2.205     3.690
   142.958    42.148    73.890     1.498     2.499
   143.435    42.687    52.681     2.050     4.080
   142.148    42.344    84.550     2.164     3.577
   141.638    42.432    65.627     1.338     2.447
   143.647    42.478    47.885     2.714     5.930
   143.051    42.288    55.159     2.247     4.091
   142.595    42.246    81.788     2.183     3.765
   143.079    42.313    58.657     0.763     1.164
   143.166    42.403    57.491     1.929     3.920
   143.015    42.278    61.280     2.808     3.916
   143.022    42.290    66.533     1.011     1.580
   142.285    42.245    75.953     2.286     4.440
   141.451    42.889    84.945     2.970     4.558
   143.121    42.301    58.843     2.093     3.175
   142.958    42.301    71.979     1.279     2.362
   142.592    42.305   -82.134     3.679     6.093
   143.114    42.316    62.613     2.304     4.299
   143.316    42.695    76.215     2.514     2.978
   142.491    42.234    77.615     3.752     6.427
   142.537    42.167    73.244     1.771     3.420
   142.586    42.198    63.376     3.264     4.255
   142.687    42.579    77.256     2.821     3.662
   142.885    42.198    65.314     2.234     4.482
   143.114    42.314    63.035     1.592     3.460
   142.986    42.447    74.771     0.908     1.584
   142.996    42.335    76.921     0.950     1.845
   143.080    42.294    66.575     0.751     1.187
   143.077    42.293    70.038     2.070     3.373
   142.972    42.293    72.735     2.277     3.974
   142.582    42.671   -89.170     2.059     2.633
   143.118    42.314    68.026     2.002     3.380
   143.760    42.448    58.003     1.789     4.344
   143.005    42.178    74.156     2.422     4.479
   142.984    42.310    75.442     2.783     4.243
   143.162    42.204    68.305     2.901     6.165
   142.948    42.292    78.431     1.159     2.264
   143.039    42.293    64.340     2.135     3.883
   143.010    42.259    72.080     2.172     3.714
   143.075    42.276    69.717     1.944     3.494
   142.426    42.314    80.260     1.564     2.730
   142.879    42.190    74.751     1.994     4.126
   143.047    42.279    70.629     1.789     3.291
   142.581    42.463   -78.520     2.175     3.559
   143.124    42.309    64.538     1.642     3.008
   142.756    42.609    89.304     2.384     3.538
   142.629    42.739   -77.455     1.894     2.860
   142.655    42.750   -88.625     2.435     2.814
   143.624    42.496    56.203     1.732     3.067
   141.411    42.612    46.076     1.322     1.863
   143.093    42.325    64.064     1.986     3.635
   144.135    42.646    59.904     1.919     4.017
   142.682    42.789   -88.983     1.688     2.268
   142.631    42.512    89.544     2.612     3.645
   141.806    42.578    79.203     1.757     2.485
   141.824    42.590    68.194     1.900     2.916
   142.968    42.311    73.594     1.577     2.458
   143.012    42.281    72.110     1.523     2.716
   142.577    42.352    80.399     1.344     2.367
   143.079    42.309    57.782     0.814     1.276
   143.579    42.464    59.378     2.085     5.164
   144.031    42.567    58.749     2.108     3.723
   143.122    42.302    68.535     1.985     3.665
   143.066    42.262    73.841     1.909     3.585
   142.952    42.279    74.275     1.978     3.226
   142.945    42.268    70.658     1.661     2.630
   143.189    42.387    65.976     1.956     3.472
   142.960    42.295    76.908     1.971     3.351
   143.009    42.252    72.817     2.822     4.904
   143.054    42.259    73.477     1.883     3.532
   143.039    42.288    64.194     1.162     1.966
   143.124    42.315    63.612     1.731     3.384
   142.998    42.279    72.029     1.590     2.889
   143.028    42.297    67.550     1.066     1.911
   142.926    42.315    79.426     1.880     2.878
   143.074    42.286    63.218     0.993     1.512
   141.865    42.791    77.291     1.122     1.522
   141.834    42.797    82.934     2.210     2.756
   142.996    42.285    76.013     1.981     3.276
   143.772    42.581    62.474     1.010     1.770
   143.120    42.310    66.674     2.371     4.028
   142.558    42.466   -83.367     2.699     4.333
   143.593    42.443    59.959     1.482     3.264
   143.023    42.273    73.364     1.368     2.390
   141.948    42.686    40.387     1.359     1.775
   141.928    42.631    25.064     1.481     1.602
   141.870    42.545   -88.860     1.602     2.013
   141.938    42.813    46.840     1.642     1.899
   141.955    42.706   -69.495     2.518     3.243
   141.975    42.725    80.321     2.646     2.890
   141.916    42.702   -63.640     1.521     1.955
   141.949    42.683    70.639     1.413     1.785
   141.944    42.646   -79.174     1.886     2.752
   141.928    42.606    82.714     1.810     2.471
   141.958    42.693   -81.895     1.425     1.816
   141.953    42.662    46.973     1.931     2.051
   141.976    42.680    65.618     0.818     0.989
   141.924    42.611    86.545     1.511     2.000
   141.954    42.807    34.532     2.110     2.450
   141.932    42.618   -78.115     1.627     1.976
   141.946    42.650   -57.977     2.418     3.584
   141.925    42.668   -79.144     2.185     2.974
   141.947    42.810   -62.165     1.695     1.914
   141.921    42.610   -78.234     2.068     2.834
   141.935    42.698   -41.012     1.610     1.818
   141.910    42.703   -59.130     2.102     2.465
   141.917    42.606    60.537     1.732     2.152
   141.914    42.595    74.888     1.520     1.720
   141.940    42.793   -23.270     1.567     1.702
   141.934    42.696   -26.757     1.651     1.744
   142.102    42.743    50.452     2.936     5.524
   141.918    42.615    78.426     1.671     1.839
   141.932    42.731   -65.138     1.812     2.240
   141.927    42.610   -72.401     1.839     2.181
   141.916    42.593    73.587     1.731     2.373
   141.941    42.724    83.453     1.172     1.354
   141.970    42.747   -51.099     1.336     1.421
   141.938    42.679   -66.991     1.818     2.405
   141.925    42.707   -60.541     1.581     1.855
   141.972    42.786   -28.245     1.339     1.580
   141.968    42.724   -65.800     1.768     2.234
   141.941    42.671   -66.506     1.549     1.933
   142.121    42.770    43.320     1.862     2.459
   141.939    42.684   -50.914     1.498     1.527
   141.916    42.594    55.147     1.882     2.366
   141.956    42.707    76.191     1.344     1.524
   141.886    42.734    69.370     2.504     2.707
   141.959    42.817   -73.084     1.555     1.794
   141.943    42.678   -69.543     1.491     1.798
   141.921    42.614    80.907     1.741     1.850
   141.971    42.720   -66.296     1.599     2.135
   141.936    42.700   -60.598     1.617     1.946
   141.928    42.671    80.245     1.279     1.826
   141.941    42.801   -50.337     1.345     1.526
   141.937    42.611    89.332     2.094     2.770
   141.916    42.731    73.468     1.981     2.377
   141.953    42.656   -63.756     1.734     2.153
   143.006    42.274    68.597     2.523     3.573
   141.957    42.638   -68.213     2.086     2.654
   141.950    42.771   -70.012     1.519     1.824
   142.032    42.584    80.318     1.710     2.041
   142.037    42.805    87.443     1.539     2.138
   141.981    42.593    70.791     1.349     1.986
   141.943    42.687   -65.267     1.616     2.055
   141.948    42.593   -75.552     1.662     1.983
   141.932    42.628    68.737     1.291     1.489
   141.924    42.623    62.474     1.381     1.615
   141.898    42.545    59.213     1.447     1.795
   141.947    42.833   -49.006     1.872     2.110
   142.925    42.365    70.857     1.862     2.553
   143.016    42.267    71.412     1.788     2.805
   141.977    42.730   -86.715     1.561     1.949
   141.932    42.687     9.965     1.742     1.787
   143.095    42.296    61.719     0.826     1.271
   141.959    42.760    46.671     0.806     0.956
   141.936    42.771    68.383     1.717     1.944
   141.920    42.758   -65.005     1.442     1.691
   141.948    42.751    44.097     1.870     2.232
   143.058    42.261    71.111     2.052     3.715
   143.121    42.305    70.888     1.828     3.413
   142.674    42.689   -69.768     1.818     2.607
   141.936    42.810   -65.056     1.698     1.968
   143.065    42.271    68.130     2.096     3.599
   143.059    42.275    71.323     1.879     3.248
   143.095    42.319    65.092     1.670     2.910
   141.960    42.605    76.551     1.811     1.963
   143.088    42.408    64.897     1.677     2.895
   143.064    42.269    64.488     2.353     3.756
   143.715    42.371    58.797     1.805     3.580
   142.987    42.294    76.067     2.034     3.376
   142.980    42.303    76.943     2.008     2.940
   143.071    42.295    65.393     1.535     2.492
   141.866    42.759   -85.740     1.572     1.951
   141.942    42.701   -74.729     1.933     2.440
   143.136    42.294    70.003     2.693     4.813
   143.449    42.444    50.431     2.429     4.660
   143.777    42.394    50.346     2.017     3.796
   142.969    42.287    75.782     2.042     3.626
   142.879    42.187    73.214     2.046     3.559
   144.211    42.687    52.728     1.324     1.835
   142.642    42.217    78.338     1.865     2.911
   143.255    42.431    65.406     1.818     2.964
   142.552    42.425   -81.148     1.996     2.327
   142.437    42.747   -81.869     2.481     3.080
   143.088    42.330    61.930     1.383     2.183
   143.057    42.242    70.979     2.460     4.499
   142.631    42.351    70.824     1.340     1.972
   142.957    42.309    74.096     2.108     3.659
   143.033    42.298    55.572     1.095     1.702
   142.473    42.502   -87.261     2.143     3.050
   143.008    42.272    73.099     2.040     3.482
   142.963    42.286    64.211     1.243     1.974
   143.112    42.321    65.771     1.737     3.030
   142.992    42.280    77.532     2.314     3.876
   142.959    42.161    57.980     1.405     2.355
   142.969    42.302    72.718     1.980     2.861
   143.010    42.318    47.581     1.064     1.393
   142.882    42.193    64.449     1.874     2.991
   142.974    42.451    61.269     1.263     1.892
   142.562    42.392    72.654     1.923     2.331
   143.082    42.319    56.055     0.915     1.352
   142.471    42.805    80.857     1.849     2.924
   142.394    42.696   -76.943     1.788     2.402
   143.071    42.280     0.509     5.899     9.026
   144.066    42.459    66.131     2.355     3.600
   142.642    42.360   -16.778     6.482     8.121
   143.093    42.328    52.224     2.679     4.081
   143.063    42.278    48.726     1.293     1.809
   143.010    42.298    54.462     1.821     2.296
   143.226    42.730    58.014     4.006     5.410
   143.088    42.308    37.411     1.279     1.566
   142.905    42.099   -48.466     0.168     7.027
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
   143.180    42.358     0.200
   142.569    42.128     0.200
   141.948    42.686     0.200
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
   141.382    42.037    71.886     2.354     2.677
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
   141.405    42.037   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
   141.382    42.037     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
   141.382    42.037     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
   141.382    41.992   5 km
EOF
gmt end
