#!/bin/bash
gmt begin salton5.43_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases salton5.43'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     1.500    -1.351
     2.000    -1.344
     2.500    -1.337
     3.000    -1.330
     3.500    -1.323
     4.000    -1.316
     4.500    -1.309
     5.000    -1.301
     5.500    -1.294
     6.000    -1.287
     6.500    -1.280
     7.000    -1.273
     7.500    -1.266
     8.000    -1.259
     8.500    -1.252
     9.000    -1.245
     9.500    -1.238
    10.000    -1.231
    10.500    -1.224
    11.000    -1.217
    11.500    -1.210
    12.000    -1.203
    12.500    -1.196
    13.000    -1.189
    13.500    -1.182
    14.000    -1.175
    14.500    -1.168
    15.000    -1.160
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     1.811 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000     0.856
     1.500    -2.564
     2.000    -5.984
     2.500    -9.405
     3.000   -12.825
     3.500   -16.245
     4.000   -19.667
     4.500   -23.093
     5.000   -26.518
     5.500   -29.947
     6.000   -33.377
     6.500   -36.811
     7.000   -40.246
     7.500   -43.685
     8.000   -47.127
     8.500   -50.572
     9.000   -54.021
     9.500   -57.474
    10.000   -60.931
    10.500   -64.392
    11.000   -67.858
    11.500   -71.329
    12.000   -74.805
    12.500   -78.456
    13.000   -82.172
    13.500   -85.902
    14.000   -89.632
    14.500   -93.364
    15.000   -97.099
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -79.172 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     1.368
     1.000    -0.616
     1.500    -2.601
     2.000    -4.585
     2.500    -6.570
     3.000    -8.556
     3.500   -10.545
     4.000   -12.534
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -15.534 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.841    -4.812     0.200
     3.920    -0.508     0.200
     4.156     0.969     0.200
     4.266    -0.859     0.200
     4.411    -0.428     0.200
     4.445     1.784     0.200
     4.873     2.489     0.200
     5.035     3.511     0.200
     5.550    -2.818     0.200
     5.725     2.278     0.200
     6.761     1.330     0.200
     6.802    -1.558     0.200
     6.967     0.674     0.200
     6.997     0.312     0.200
     7.587    -0.571     0.200
     8.044    -3.528     0.200
     8.101    -7.210     0.200
     8.643     2.029     0.200
     9.228    -2.555     0.200
    11.448    -4.295     0.200
     1.745    -1.390     0.200
     1.768    -1.361     0.200
     1.790    -0.653     0.200
     1.805    -0.183     0.200
     1.807    -1.063     0.200
     1.900    -2.175     0.200
     2.015    -0.665     0.200
     2.027     0.117     0.200
     2.066    -0.629     0.200
     2.098    -1.747     0.200
     2.148    -1.901     0.200
     2.164    -0.601     0.200
     2.214    -1.824     0.200
     2.387    -2.175     0.200
     2.425    -0.540     0.200
     2.547    -1.684     0.200
     2.586    -2.188     0.200
     2.814    -3.299     0.200
     2.853    -2.791     0.200
     2.963    -3.110     0.200
     3.074    -2.778     0.200
     3.972    -0.448     0.200
     4.278    -0.517     0.200
     4.342    -1.223     0.200
     4.511    -1.588     0.200
     4.809     0.962     0.200
     4.857     1.389     0.200
     6.601     1.560     0.200
     6.745     0.825     0.200
     6.872     1.611     0.200
     6.911    -4.174     0.200
     6.950    -1.451     0.200
     7.113    -2.161     0.200
     7.483     2.751     0.200
     7.959     1.551     0.200
     8.002    -4.001     0.200
     8.129    -3.069     0.200
     8.350     5.909     0.200
     9.124     0.760     0.200
     1.700    -0.605     0.200
     1.727     0.311     0.200
     1.741    -0.713     0.200
     1.961    -2.161     0.200
     1.922    -0.063     0.200
     1.994    -1.730     0.200
     1.993    -1.919     0.200
     2.041    -1.014     0.200
     1.960    -1.145     0.200
     1.999    -1.213     0.200
     2.209    -1.508     0.200
     2.268     0.831     0.200
     2.320    -0.844     0.200
     2.396    -1.183     0.200
     2.384    -1.055     0.200
     2.681    -2.204     0.200
     2.673    -2.304     0.200
     2.715    -0.752     0.200
     2.696    -1.815     0.200
     2.768    -1.032     0.200
     2.793    -1.014     0.200
     2.785    -1.006     0.200
     3.050    -2.321     0.200
     3.232    -2.359     0.200
     3.830    -2.807     0.200
     4.520    -1.888     0.200
     4.561    -0.863     0.200
     4.700     1.123     0.200
     4.947     0.111     0.200
     5.609     1.769     0.200
     6.043    -2.236     0.200
     7.420     1.898     0.200
     7.646    -0.759     0.200
     7.646    -0.569     0.200
     7.756    -1.232     0.200
     7.892    -0.912     0.200
     1.637    -1.041     0.200
     1.757    -0.911     0.200
     1.875    -0.082     0.200
     1.917    -1.087     0.200
     1.976     0.911     0.200
     2.018    -1.210     0.200
     2.035    -0.509     0.200
     2.214    -1.422     0.200
     2.271    -0.990     0.200
     2.268    -1.055     0.200
     2.583    -2.057     0.200
     2.635    -1.467     0.200
     2.695    -2.325     0.200
     2.704    -2.177     0.200
     2.769    -1.660     0.200
     5.195     0.127     0.200
    11.671    -1.384     0.200
     1.614    -1.859     0.200
     1.641    -0.553     0.200
     1.761    -0.739     0.200
     1.974     0.167     0.200
     1.920    -1.150     0.200
     2.015    -1.633     0.200
     2.217    -1.679     0.200
     2.217    -1.507     0.200
     2.274    -1.800     0.200
     2.586    -2.277     0.200
     2.692    -1.894     0.200
     2.771    -1.651     0.200
     2.771    -3.065     0.200
     4.811    -2.951     0.200
     4.981    -2.548     0.200
     6.131    -1.804     0.200
     7.342    -4.440     0.200
     7.508    -1.491     0.200
     1.623    -0.850     0.200
     1.662    -0.957     0.200
     1.795    -0.726     0.200
     1.899    -1.379     0.200
     2.084    -0.876     0.200
     2.079    -1.291     0.200
     2.250    -1.828     0.200
     2.295    -1.509     0.200
     2.402    -2.227     0.200
     2.439    -0.727     0.200
     2.530    -1.449     0.200
     2.530    -1.078     0.200
     2.600    -0.375     0.200
     2.936    -2.842     0.200
     5.052     0.307     0.200
     8.739    -3.271     0.200
    10.887     2.471     0.200
     1.629    -0.609     0.200
     1.664    -1.916     0.200
     1.800    -0.301     0.200
     1.899    -1.210     0.200
     2.087    -0.727     0.200
     2.085    -1.163     0.200
     2.147    -1.909     0.200
     2.257    -1.549     0.200
     2.295    -1.287     0.200
     2.408    -2.333     0.200
     2.445    -1.109     0.200
     2.532    -1.594     0.200
     2.604    -0.817     0.200
     2.942    -2.808     0.200
     1.756    -1.847     0.200
     1.718    -1.300     0.200
     1.781    -3.012     0.200
     1.812    -3.194     0.200
     1.827    -2.659     0.200
     1.832    -0.986     0.200
     1.860    -0.770     0.200
     2.110    -1.303     0.200
     2.121    -2.432     0.200
     2.160    -1.337     0.200
     2.156    -0.213     0.200
     2.232    -1.655     0.200
     2.349    -2.334     0.200
     2.370    -3.547     0.200
     2.342    -2.496     0.200
     2.372    -3.698     0.200
     2.423    -1.829     0.200
     3.240    -0.097     0.200
     4.226    -0.133     0.200
     5.456    -0.477     0.200
     5.910     0.530     0.200
     6.025    -2.917     0.200
     7.084     1.591     0.200
     7.243     0.290     0.200
     7.358    -1.688     0.200
     7.512     1.129     0.200
     7.555     0.771     0.200
     7.643    -1.781     0.200
     7.652    -1.975     0.200
     7.872    -5.449     0.200
     7.935    -0.244     0.200
    11.070    -1.709     0.200
     1.670    -1.400     0.200
     1.739    -0.615     0.200
     1.758    -2.589     0.200
     1.787    -2.879     0.200
     1.853     0.385     0.200
     2.139    -0.370     0.200
     2.171    -1.880     0.200
     2.186     0.927     0.200
     2.215    -0.722     0.200
     2.239    -2.171     0.200
     2.343    -3.438     0.200
     2.373    -2.660     0.200
     2.367    -3.328     0.200
     2.360    -2.797     0.200
     2.447    -1.986     0.200
     4.237    -1.371     0.200
     4.290     1.018     0.200
     4.668     0.618     0.200
     4.859     1.375     0.200
     5.528     2.490     0.200
     5.933     1.368     0.200
     5.955     1.175     0.200
     7.096    -2.390     0.200
     7.173    -0.066     0.200
     7.528     0.428     0.200
     7.571    -0.821     0.200
     7.642    -2.350     0.200
     1.693    -0.129     0.200
     1.873    -1.069     0.200
     2.082    -1.434     0.200
     2.145    -1.772     0.200
     1.623    -0.752     0.200
     1.678    -3.115     0.200
     1.784    -3.143     0.200
     1.861     0.191     0.200
     1.977    -2.067     0.200
     1.977    -2.432     0.200
     1.997    -0.664     0.200
     2.066    -2.427     0.200
     2.116     0.111     0.200
     2.912    -0.973     0.200
     3.998    -1.122     0.200
     4.103     2.571     0.200
     4.501    -0.646     0.200
     4.562     2.252     0.200
     4.823    -1.930     0.200
     4.932    -2.121     0.200
     4.959    -1.926     0.200
     5.409    -0.264     0.200
     6.454    -1.350     0.200
     6.496    -0.002     0.200
     7.027    -0.150     0.200
     7.122    -3.351     0.200
     7.268    -2.971     0.200
    12.202    -0.830     0.200
     1.646    -1.433     0.200
     1.879    -1.090     0.200
     1.872    -0.609     0.200
     1.881    -1.479     0.200
     1.922    -1.317     0.200
     2.069    -1.531     0.200
     2.287    -2.057     0.200
     2.324    -1.441     0.200
     2.319    -2.043     0.200
     3.184    -0.896     0.200
     3.640    -1.496     0.200
     4.837    -1.092     0.200
     5.117     2.819     0.200
     5.165    -1.327     0.200
     5.345    -1.269     0.200
     5.380    -2.163     0.200
     6.004    -2.836     0.200
     6.039    -3.177     0.200
     7.787    -3.139     0.200
     8.159    -4.732     0.200
     1.652    -1.350     0.200
     1.773    -2.542     0.200
     1.883    -1.008     0.200
     1.878    -1.849     0.200
     1.928    -3.453     0.200
    11.465    -2.515     0.200
     1.671    -2.551     0.200
     1.811    -1.073     0.200
     1.930    -1.232     0.200
     1.977    -1.198     0.200
     2.026    -1.223     0.200
     2.100    -2.421     0.200
     2.270    -1.344     0.200
     2.270    -1.101     0.200
     2.328    -1.066     0.200
     2.642    -2.428     0.200
     2.829    -1.863     0.200
     2.829    -1.652     0.200
     3.271     0.485     0.200
     3.362    -0.717     0.200
     4.674     1.250     0.200
     4.990    -2.662     0.200
     5.252     0.729     0.200
     5.656    -3.043     0.200
     6.133    -2.185     0.200
     7.053    -1.669     0.200
     7.234    -2.964     0.200
     7.397    -2.227     0.200
     7.875    -0.886     0.200
     7.939    -4.899     0.200
     7.988     0.210     0.200
     8.398    -3.298     0.200
     8.398    -1.858     0.200
     8.854     1.255     0.200
     9.392    -2.900     0.200
     9.558    -5.797     0.200
    10.801     1.690     0.200
     1.775    -3.115     0.200
     1.913    -0.554     0.200
     2.056    -0.822     0.200
     2.199    -0.919     0.200
     2.274    -0.743     0.200
     2.768    -0.763     0.200
     2.768    -1.818     0.200
     5.207     0.653     0.200
     7.378    -0.753     0.200
    10.808     5.261     0.200
    11.695    -3.855     0.200
    14.835     1.555     0.200
     1.661    -1.363     0.200
     1.866    -1.587     0.200
     1.919    -2.385     0.200
     1.968    -0.960     0.200
     1.998    -1.198     0.200
     2.085    -3.089     0.200
     2.159    -3.024     0.200
     2.232    -2.406     0.200
     2.386    -1.794     0.200
     7.592    -6.085     0.200
     7.681    -2.025     0.200
     8.113    -3.706     0.200
     1.699     0.051     0.200
     1.937    -0.634     0.200
     1.912     0.673     0.200
     1.986    -1.206     0.200
     2.235    -0.002     0.200
     2.272    -0.857     0.200
     2.361    -0.529     0.200
     2.497     0.314     0.200
     2.650    -0.901     0.200
     2.723    -2.115     0.200
     2.788    -0.390     0.200
     4.349    -1.739     0.200
     4.445    -1.641     0.200
     4.407    -1.918     0.200
     5.651    -1.615     0.200
     6.461    -4.966     0.200
     6.698    -0.239     0.200
     6.841    -2.875     0.200
     7.398    -1.054     0.200
     7.418     2.245     0.200
     7.426    -0.592     0.200
     1.624    -1.527     0.200
     1.731    -1.537     0.200
     2.607    -2.450     0.200
     2.728    -2.211     0.200
     5.820     1.357     0.200
     7.694    -2.170     0.200
     7.800    -3.541     0.200
    10.803     3.975     0.200
    10.838    -1.901     0.200
     1.878    -1.053     0.200
     1.897    -0.112     0.200
     2.118    -1.983     0.200
     2.170    -1.787     0.200
     2.231    -0.953     0.200
     2.315    -1.868     0.200
     2.402    -1.793     0.200
     3.897    -1.518     0.200
     4.851    -1.607     0.200
     5.241    -4.330     0.200
     5.383    -4.324     0.200
     7.844     0.458     0.200
     1.662    -1.048     0.200
     1.853    -1.307     0.200
     1.805    -0.903     0.200
     1.869    -1.497     0.200
     1.894    -1.664     0.200
     1.945    -2.743     0.200
     2.093    -1.732     0.200
     2.332    -1.854     0.200
     3.931    -1.550     0.200
     5.505    -0.685     0.200
     5.864    -2.190     0.200
     1.801    -1.712     0.200
     1.884    -2.792     0.200
     1.885    -2.035     0.200
     1.848    -0.842     0.200
     2.450    -2.752     0.200
     5.755     2.856     0.200
     1.621    -1.701     0.200
     1.621    -0.591     0.200
     1.622    -0.616     0.200
     1.731    -0.863     0.200
     1.714    -1.955     0.200
     1.785    -1.392     0.200
     1.832    -0.955     0.200
     1.850    -1.258     0.200
     1.850    -1.109     0.200
     1.936    -1.781     0.200
     1.938    -1.935     0.200
     1.935    -1.319     0.200
     2.041    -0.909     0.200
     2.181    -2.151     0.200
     3.612    -3.333     0.200
     4.884    -1.331     0.200
     8.091    -3.583     0.200
     1.620    -0.466     0.200
     1.620     0.224     0.200
     1.623     0.568     0.200
     1.641     0.863     0.200
     1.713    -1.291     0.200
     1.713    -0.621     0.200
     1.739    -0.715     0.200
     1.781    -0.718     0.200
     1.836    -0.990     0.200
     1.850    -0.984     0.200
     1.850    -1.281     0.200
     1.924    -1.496     0.200
     1.930    -1.421     0.200
     1.931    -1.721     0.200
     1.935    -0.436     0.200
     2.173    -2.413     0.200
     2.258    -1.812     0.200
     2.428    -2.234     0.200
     5.639     3.379     0.200
     7.475     2.875     0.200
     7.496    -0.022     0.200
     1.626     0.198     0.200
     1.664    -1.136     0.200
     1.640    -0.311     0.200
     1.680    -0.775     0.200
     1.703    -0.813     0.200
     1.851    -0.565     0.200
     2.036    -0.933     0.200
     2.036    -0.644     0.200
     2.061     0.375     0.200
     2.076    -1.179     0.200
     4.822    -1.183     0.200
     5.708    -3.216     0.200
     1.748    -1.708     0.200
     1.903     1.939     0.200
     2.186    -0.869     0.200
     2.405    -1.928     0.200
     2.602    -1.695     0.200
     2.728    -2.261     0.200
     5.827     0.794     0.200
     1.741    -1.498     0.200
     2.325    -1.297     0.200
     2.384    -1.433     0.200
     2.418    -2.128     0.200
     2.560    -1.608     0.200
     2.614    -2.126     0.200
     2.738    -1.688     0.200
     7.803    -1.932     0.200
     1.738    -1.357     0.200
     2.417    -2.623     0.200
     2.734    -2.156     0.200
     7.802    -2.775     0.200
    10.375    -1.217     0.200
     2.414    -0.636     0.200
     2.502    -1.232     0.200
     2.609    -0.923     0.200
     2.733    -1.610     0.200
     7.806    -2.090     0.200
    10.839    -1.965     0.200
     1.755    -1.278     0.200
     1.768    -0.194     0.200
     2.381    -1.775     0.200
     2.594    -0.927     0.200
     2.733    -2.412     0.200
     3.018    -2.982     0.200
     7.857    -2.440     0.200
    10.865    -5.012     0.200
     1.628    -1.559     0.200
     1.739    -2.367     0.200
     7.512     4.422     0.200
     7.805    -3.079     0.200
    10.839    -2.787     0.200
     2.118    -1.030     0.200
     2.179    -1.700     0.200
     2.386    -2.074     0.200
     2.394    -0.983     0.200
     2.464    -1.971     0.200
     2.611    -1.545     0.200
     2.728    -2.164     0.200
     3.337    -4.443     0.200
     7.787    -1.247     0.200
     8.070     1.843     0.200
     1.800    -2.661     0.200
     2.397    -2.152     0.200
     3.679     1.909     0.200
     7.849    -1.395     0.200
     8.108     3.895     0.200
    10.850    -4.786     0.200
     1.743     0.330     0.200
     2.390    -1.036     0.200
     2.410    -0.695     0.200
     2.737    -1.860     0.200
     3.005    -1.934     0.200
     7.789    -1.765     0.200
     2.131    -1.755     0.200
     2.623    -1.729     0.200
     2.742    -1.584     0.200
     3.645    -0.815     0.200
     5.828    -1.942     0.200
     7.472    -1.777     0.200
     7.783    -2.383     0.200
     1.760    -1.691     0.200
     2.403    -2.771     0.200
     2.572    -3.872     0.200
     7.823    -2.036     0.200
     1.761    -1.247     0.200
     2.362    -2.163     0.200
     2.724    -1.960     0.200
     7.828    -5.320     0.200
     8.211    -1.890     0.200
    10.856    -2.432     0.200
    10.830     3.260     0.200
     1.650    -1.517     0.200
     1.845    -1.407     0.200
     1.934    -1.233     0.200
     2.098    -3.661     0.200
     2.082    -1.577     0.200
     2.246    -2.298     0.200
     2.312    -1.872     0.200
     2.320    -2.424     0.200
     2.433    -1.826     0.200
     2.555    -2.144     0.200
     2.700    -2.556     0.200
     1.968    -0.719     0.200
     2.016     0.347     0.200
     2.070    -2.043     0.200
     2.313    -2.078     0.200
     2.366    -1.777     0.200
     2.482    -0.828     0.200
     2.553    -2.317     0.200
     2.665    -0.051     0.200
     4.655    -1.470     0.200
     4.896     0.032     0.200
     6.868    -2.156     0.200
     7.959    -3.496     0.200
     1.706    -0.512     0.200
     1.849    -1.101     0.200
     1.858    -3.185     0.200
     1.941    -1.788     0.200
     1.973    -0.758     0.200
     2.057    -0.626     0.200
     2.228    -2.294     0.200
     2.344    -2.008     0.200
     2.372    -2.033     0.200
     2.447    -1.687     0.200
     3.233    -3.573     0.200
     5.671     0.017     0.200
     5.858    -0.142     0.200
     7.282    -2.874     0.200
     1.731    -0.792     0.200
     1.875    -0.839     0.200
     1.982    -1.002     0.200
     1.981    -0.530     0.200
     2.184    -1.063     0.200
     2.399    -0.725     0.200
     2.588    -2.418     0.200
     2.589    -2.779     0.200
     2.546    -2.227     0.200
     5.141     1.697     0.200
     5.141     1.696     0.200
     1.622    -1.731     0.200
     2.371    -2.556     0.200
     2.507    -1.432     0.200
     2.593    -1.471     0.200
     1.676    -2.437     0.200
     1.749    -0.503     0.200
     5.540     1.074     0.200
     7.458    -1.092     0.200
     7.876    -5.587     0.200
     2.548    -1.010     0.200
     5.611    -0.978     0.200
     1.630    -0.608     0.200
     1.851    -1.497     0.200
     1.974    -0.698     0.200
     2.023    -1.367     0.200
     2.038    -1.419     0.200
     2.099    -1.970     0.200
     2.430    -2.238     0.200
     2.686    -2.804     0.200
     1.653    -1.740     0.200
     1.849    -0.684     0.200
     2.017    -0.990     0.200
     2.182    -1.478     0.200
     2.213    -0.780     0.200
     2.224    -1.048     0.200
     1.654    -0.742     0.200
     7.545    -3.716     0.200
     7.798    -3.690     0.200
     1.611    -2.385     0.200
     1.878    -0.787     0.200
     1.937    -0.700     0.200
     1.973    -0.133     0.200
     2.057    -1.202     0.200
     2.435    -1.129     0.200
     2.600    -1.463     0.200
     2.649    -1.925     0.200
     4.849    -0.166     0.200
     6.829    -1.661     0.200
     7.974    -4.436     0.200
     1.883    -0.583     0.200
     1.938    -0.218     0.200
     1.985    -0.132     0.200
     2.065    -0.330     0.200
     2.445    -0.842     0.200
     2.630    -0.413     0.200
     2.656    -0.792     0.200
     4.860    -1.447     0.200
     6.842    -2.157     0.200
     6.984     0.332     0.200
     7.978    -3.941     0.200
     1.696    -1.060     0.200
     1.696    -1.619     0.200
     2.325    -2.411     0.200
     2.589    -2.473     0.200
     5.677     0.656     0.200
     7.572    -1.596     0.200
     7.836    -1.737     0.200
     1.658     0.072     0.200
     2.211    -1.211     0.200
     2.159    -0.585     0.200
     5.083     0.880     0.200
     6.961    -1.077     0.200
     7.757    -5.379     0.200
     1.671    -0.518     0.200
     4.596     1.713     0.200
     6.894    -2.715     0.200
     8.679    -6.138     0.200
    12.180    -0.253     0.200
     1.645    -1.848     0.200
     1.764    -2.221     0.200
     2.033    -0.028     0.200
     2.102    -0.827     0.200
     9.647    -1.165     0.200
    10.751    -1.818     0.200
    10.769     0.821     0.200
    11.664    -2.989     0.200
    14.814    -0.932     0.200
    26.938    -7.531     0.200
     1.788    -1.813     0.200
     2.411    -3.397     0.200
     2.624    -2.747     0.200
     2.760    -2.457     0.200
     5.873    -1.120     0.200
     1.804    -1.661     0.200
     2.193    -1.682     0.200
     2.450    -3.297     0.200
     2.674    -2.854     0.200
     5.928     0.125     0.200
     7.804    -3.121     0.200
     7.818    -6.246     0.200
    10.793    -3.072     0.200
     1.617     0.039     0.200
     1.910    -1.829     0.200
     2.242    -1.501     0.200
     2.262    -1.631     0.200
     2.499    -1.830     0.200
     2.664    -1.673     0.200
     2.973    -1.819     0.200
     7.988    -4.478     0.200
     1.725    -3.029     0.200
     1.881     0.306     0.200
     2.127     0.113     0.200
     2.176    -1.968     0.200
     2.176    -0.628     0.200
     2.245    -2.234     0.200
     2.361    -1.836     0.200
     2.444    -1.968     0.200
     5.518    -1.220     0.200
     7.432    -2.238     0.200
     7.864    -5.423     0.200
    10.064    -3.894     0.200
    10.620     2.274     0.200
    11.053    -4.827     0.200
     2.449    -1.585     0.200
     1.886     1.320     0.200
     5.520    -1.847     0.200
     7.428    -0.058     0.200
     7.849    -5.320     0.200
    11.040     0.242     0.200
     1.852    -1.278     0.200
     2.174    -1.711     0.200
     2.243    -2.080     0.200
     2.361    -2.000     0.200
     2.378    -3.232     0.200
     2.446    -2.207     0.200
     5.524     0.130     0.200
     7.869    -5.010     0.200
     1.731    -1.393     0.200
     1.852    -0.942     0.200
     2.174    -2.222     0.200
     2.243    -2.490     0.200
     2.446    -2.363     0.200
     5.523     3.042     0.200
     7.438    -4.484     0.200
     7.868    -6.707     0.200
     1.638    -1.258     0.200
     2.378    -1.865     0.200
     7.775    -0.543     0.200
     2.433    -2.675     0.200
     5.875     3.781     0.200
     7.750     0.779     0.200
     7.809    -5.407     0.200
    10.815    -3.129     0.200
     1.706     0.150     0.200
     1.796     0.017     0.200
     2.152    -0.719     0.200
     2.401    -1.277     0.200
     2.430    -1.683     0.200
     2.539    -2.200     0.200
     2.638    -2.663     0.200
     2.770    -1.891     0.200
     7.748    -3.954     0.200
     7.810    -6.123     0.200
    10.817    -2.389     0.200
    10.851     0.167     0.200
     1.668    -0.747     0.200
     1.908    -1.779     0.200
     1.928    -1.206     0.200
     2.153    -1.831     0.200
     2.145    -0.244     0.200
     2.295    -1.686     0.200
     5.488    -0.320     0.200
     1.618    -0.252     0.200
     1.707    -0.954     0.200
     2.696    -3.355     0.200
     5.674     0.525     0.200
     7.575    -0.928     0.200
     1.611    -0.832     0.200
     1.635    -3.079     0.200
     1.762    -0.805     0.200
     1.766    -0.517     0.200
     1.890    -1.091     0.200
     2.128    -1.858     0.200
     2.156    -0.546     0.200
     2.233    -0.953     0.200
     2.263    -1.334     0.200
     2.320    -1.694     0.200
     2.362    -2.193     0.200
     2.520    -2.142     0.200
     2.978    -3.392     0.200
     2.992    -3.211     0.200
     5.465    -0.655     0.200
     7.639    -2.903     0.200
     8.511    -5.598     0.200
     9.884    -0.405     0.200
     1.693    -0.691     0.200
     1.819    -0.346     0.200
     1.849    -0.740     0.200
     1.997    -0.781     0.200
     2.021    -1.343     0.200
     2.132    -1.527     0.200
     2.148    -1.393     0.200
     2.203    -0.961     0.200
     2.407    -0.921     0.200
     2.515    -1.978     0.200
     2.680    -1.608     0.200
     2.700    -1.331     0.200
     1.646    -0.928     0.200
     1.652    -2.289     0.200
     1.680    -0.714     0.200
     1.700    -0.841     0.200
     1.818    -2.639     0.200
     1.852    -0.497     0.200
     1.916    -0.374     0.200
     1.976     0.233     0.200
     2.104    -1.265     0.200
     2.338    -0.557     0.200
     2.393    -0.900     0.200
     2.580    -0.675     0.200
     4.777    -0.261     0.200
     6.868    -4.568     0.200
     8.217    -5.790     0.200
     1.697    -1.302     0.200
     1.770    -1.800     0.200
     1.900    -1.927     0.200
     1.958    -1.214     0.200
     1.953    -0.552     0.200
     2.014    -1.112     0.200
     2.047    -1.219     0.200
     2.065    -0.351     0.200
     7.390    -2.089     0.200
     8.303    -3.334     0.200
     9.756    -1.972     0.200
     1.862    -1.138     0.200
     1.939    -1.839     0.200
     2.017    -0.911     0.200
     2.083    -1.547     0.200
     2.333    -2.210     0.200
     2.499    -1.969     0.200
     2.796    -1.811     0.200
     5.696    -1.069     0.200
     7.691    -3.537     0.200
     1.643    -0.620     0.200
     1.653    -1.374     0.200
     1.678    -0.719     0.200
     1.699    -0.792     0.200
     1.820    -1.698     0.200
     1.850    -1.184     0.200
     1.912    -0.394     0.200
     1.971    -0.215     0.200
     2.333    -0.658     0.200
     2.391    -1.069     0.200
     4.772    -2.217     0.200
     8.216    -5.621     0.200
     1.651    -0.464     0.200
     1.716    -2.133     0.200
     2.011    -1.023     0.200
     2.290    -1.905     0.200
     2.313    -1.050     0.200
     2.336    -2.034     0.200
     2.506    -1.838     0.200
     2.619    -1.701     0.200
     2.664    -2.960     0.200
     5.713     1.392     0.200
     7.608    -3.074     0.200
     7.839    -1.401     0.200
    10.928    -2.574     0.200
     1.630    -0.070     0.200
     1.731    -1.552     0.200
     1.825    -1.458     0.200
     1.941    -1.357     0.200
     2.097    -2.484     0.200
     2.464     0.318     0.200
     2.988     0.495     0.200
     3.133    -0.948     0.200
     3.501    -2.772     0.200
     3.543    -0.639     0.200
     3.752    -0.044     0.200
     5.089    -0.238     0.200
     7.369    -2.268     0.200
     9.470    -2.874     0.200
    11.978    -3.853     0.200
     5.714    -2.046     0.200
     7.731    -2.730     0.200
    11.174    -1.169     0.200
     1.848    -0.541     0.200
     7.807    -4.162     0.200
     7.835     0.124     0.200
    10.763     0.172     0.200
     4.787    -2.431     0.200
     6.770    -5.028     0.200
     7.979    -4.989     0.200
     9.346    -4.287     0.200
    14.280    -3.982     0.200
     7.906    -2.628     0.200
    11.125    -0.729     0.200
     5.445     0.827     0.200
     7.377    -2.213     0.200
     7.900    -4.665     0.200
     4.988     2.050     0.200
     7.268    -4.491     0.200
     8.697    -4.933     0.200
     8.453    -2.943     0.200
     7.547    -2.736     0.200
     7.812    -3.989     0.200
    10.936    -2.122     0.200
     8.167    -5.480     0.200
    11.197    -4.493     0.200
     7.488    -1.622     0.200
     7.862    -5.069     0.200
    11.019    -4.730     0.200
     5.580     0.664     0.200
     5.556    -0.600     0.200
     7.462    -0.744     0.200
     1.646    -1.491     0.200
     4.725    -1.093     0.200
     5.801     1.196     0.200
     7.688    -1.677     0.200
     7.829    -3.535     0.200
    10.872    -0.080     0.200
     7.676    -1.894     0.200
     7.825    -2.385     0.200
    10.802     1.626     0.200
    10.872     0.869     0.200
     5.791    -1.169     0.200
     7.679    -4.907     0.200
     7.831    -3.355     0.200
    10.334    -0.893     0.200
    10.804    -0.277     0.200
    22.525    -0.878     0.200
     5.781    -1.109     0.200
     7.671    -2.661     0.200
    10.798     0.458     0.200
    10.885    -1.577     0.200
     5.802     1.076     0.200
    10.870    -0.225     0.200
    15.245     0.948     0.200
     7.669     0.383     0.200
     7.827    -1.559     0.200
    10.881    -2.635     0.200
     7.668    -1.936     0.200
     7.813    -2.798     0.200
     5.787     0.087     0.200
     7.669    -4.717     0.200
     7.813    -6.593     0.200
    10.788     2.782     0.200
     7.672    -5.594     0.200
     7.815    -3.728     0.200
    10.792    -1.172     0.200
    10.867    -4.009     0.200
     5.821    -2.826     0.200
     7.709    -2.760     0.200
     7.833    -3.634     0.200
    10.864    -1.163     0.200
     5.662     0.559     0.200
     7.534    -3.865     0.200
     7.778    -3.508     0.200
     5.675    -1.898     0.200
     7.558    -2.673     0.200
     7.806    -3.767     0.200
    10.923    -4.570     0.200
     5.119     1.441     0.200
     7.439    -2.654     0.200
     8.828    -3.152     0.200
     9.471    -3.172     0.200
     7.796    -3.471     0.200
     5.671     1.102     0.200
     7.552    -0.404     0.200
     7.799    -1.835     0.200
     7.840    -0.877     0.200
     5.698    -2.441     0.200
     7.586    -5.038     0.200
     7.820    -2.362     0.200
    10.245    -2.296     0.200
    10.726    -0.086     0.200
    10.921    -0.398     0.200
    15.140    -0.624     0.200
    22.456    -3.644     0.200
    29.368    -0.974     0.200
     1.689    -1.293     0.200
     5.695     1.959     0.200
     7.819    -1.503     0.200
    10.922    -0.760     0.200
     5.696     0.770     0.200
     7.585    -1.228     0.200
     7.823    -3.318     0.200
     7.832    -5.821     0.200
    10.954    -1.601     0.200
     5.677    -0.331     0.200
     7.571    -0.643     0.200
     7.832    -4.692     0.200
    10.942    -5.026     0.200
     5.634    -0.554     0.200
     5.632    -2.243     0.200
     7.528    -3.353     0.200
     7.831    -2.761     0.200
    10.683     3.619     0.200
    10.966    -0.988     0.200
     5.633    -0.641     0.200
     7.532    -0.480     0.200
    10.689     4.565     0.200
    10.972    -0.383     0.200
     7.533    -1.335     0.200
    10.691     3.761     0.200
     5.670    -0.909     0.200
     7.674    -0.976     0.200
     5.703    -2.067     0.200
     7.600    -1.237     0.200
     7.843    -1.288     0.200
    10.936    -0.534     0.200
     7.311    -3.591     0.200
     8.402    -4.470     0.200
    10.734    -0.503     0.200
     5.200    -2.701     0.200
     7.510    -4.103     0.200
     8.819    -3.606     0.200
     9.551    -3.511     0.200
    10.769    -1.308     0.200
     1.714     0.415     0.200
     5.243    -0.192     0.200
    11.617    -2.311     0.200
     1.653    -2.663     0.200
     1.679    -2.853     0.200
     1.717    -1.518     0.200
     1.858    -0.779     0.200
     5.152     0.804     0.200
     7.462    -4.060     0.200
     8.809    -2.381     0.200
     1.695    -2.381     0.200
     5.659     1.081     0.200
     7.534    -1.182     0.200
     7.782    -4.375     0.200
    10.215    -2.157     0.200
    10.668     2.693     0.200
    10.912    -0.535     0.200
     5.654     0.140     0.200
     7.528    -2.164     0.200
     7.781    -3.872     0.200
    10.663     2.538     0.200
    10.914    -3.154     0.200
     5.679     2.402     0.200
     7.550    -1.374     0.200
     7.777    -1.358     0.200
    10.898     0.288     0.200
     5.714    -1.936     0.200
     7.608    -3.431     0.200
     7.835    -3.163     0.200
    10.748     0.747     0.200
    10.924    -2.827     0.200
     7.793    -1.865     0.200
     7.817    -2.108     0.200
    10.798    -2.138     0.200
     5.915     0.861     0.200
    10.797    -3.627     0.200
     7.822    -6.592     0.200
    10.801    -0.362     0.200
    10.894     2.377     0.200
    10.800    -1.931     0.200
     7.817    -6.238     0.200
     1.703    -0.230     0.200
     7.813    -4.407     0.200
    10.794     0.394     0.200
     2.149    -2.972     0.200
     5.703    -1.900     0.200
     7.724    -4.325     0.200
     8.153    -5.778     0.200
    11.186    -3.046     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.878    -0.334     0.200
     0.883     0.388     0.200
     0.890     1.044     0.200
     0.947     0.403     0.200
     1.059    -1.549     0.200
     1.114     0.290     0.200
     1.128     1.436     0.200
     1.200    -0.783     0.200
     1.384     0.134     0.200
     1.418    -0.276     0.200
     0.928     0.212     0.200
     0.964     0.603     0.200
     1.020     0.132     0.200
     1.209    -0.115     0.200
     1.233    -0.781     0.200
     1.248    -0.826     0.200
     1.261    -0.162     0.200
     1.406    -0.825     0.200
     1.509     0.683     0.200
     1.513    -1.990     0.200
     1.513     0.340     0.200
     4.430   -21.287     0.200
     0.887     0.469     0.200
     0.945     0.191     0.200
     1.039    -0.428     0.200
     1.065     0.648     0.200
     1.293    -0.552     0.200
     1.327    -0.269     0.200
     1.351     0.551     0.200
     1.435    -0.903     0.200
     1.478    -0.731     0.200
     0.865     0.196     0.200
     0.902     0.709     0.200
     1.304     0.021     0.200
     1.275    -0.399     0.200
     1.386     0.539     0.200
     1.492    -0.587     0.200
     1.496     0.250     0.200
     2.109    -8.165     0.200
     2.225    -9.091     0.200
     2.357    -9.112     0.200
     2.358    -9.790     0.200
     2.921   -12.431     0.200
     3.079   -14.500     0.200
     0.861     0.367     0.200
     0.904     0.691     0.200
     1.491    -0.496     0.200
     1.497    -0.008     0.200
     1.816    -5.546     0.200
     2.106    -7.957     0.200
     2.221    -8.962     0.200
     2.354    -9.751     0.200
     3.076   -14.352     0.200
     3.133   -14.303     0.200
     3.472   -17.006     0.200
     3.598   -18.366     0.200
     3.625   -18.024     0.200
     3.655   -18.309     0.200
     4.206   -22.745     0.200
     0.876    -0.121     0.200
     0.987    -0.569     0.200
     1.052    -0.926     0.200
     1.210    -0.158     0.200
     1.188    -0.636     0.200
     1.225     0.251     0.200
     1.299     0.242     0.200
     1.285    -0.561     0.200
     1.373     0.356     0.200
     1.433    -1.369     0.200
     1.394    -1.191     0.200
     0.883    -0.255     0.200
     0.987    -0.816     0.200
     1.058     0.046     0.200
     1.054    -0.094     0.200
     1.206    -0.182     0.200
     1.194    -0.725     0.200
     1.294     0.155     0.200
     1.283    -2.069     0.200
     1.377    -0.172     0.200
     1.431    -0.902     0.200
     1.400    -0.703     0.200
     1.497    -2.507     0.200
     0.821     0.467     0.200
     0.821     0.119     0.200
     0.980    -0.475     0.200
     0.971     0.450     0.200
     1.008     0.278     0.200
     1.108    -0.481     0.200
     1.218    -1.290     0.200
     1.270    -1.147     0.200
     1.239    -0.572     0.200
     1.401    -2.500     0.200
     1.403    -2.552     0.200
     1.350     0.337     0.200
     1.457    -0.353     0.200
     1.812    -7.964     0.200
     4.226   -18.274     0.200
     4.644   -24.880     0.200
     4.834   -24.745     0.200
     7.189   -40.655     0.200
     8.762   -50.663     0.200
     9.654   -57.107     0.200
     9.965   -60.406     0.200
     0.993     0.211     0.200
     0.994     0.671     0.200
     1.115    -0.731     0.200
     1.213    -0.860     0.200
     1.250    -0.771     0.200
     1.252     0.580     0.200
     1.374    -1.808     0.200
     1.375     0.408     0.200
     1.486     0.235     0.200
     1.742    -5.954     0.200
     3.341   -13.123     0.200
     8.895   -52.950     0.200
     0.946     0.242     0.200
     0.946     2.371     0.200
     1.093    -0.051     0.200
     1.261     0.113     0.200
     1.376    -0.633     0.200
     1.421    -1.136     0.200
     1.515    -0.652     0.200
     0.985    -0.140     0.200
     0.975     1.120     0.200
     1.089    -1.096     0.200
     1.066     0.357     0.200
     1.154    -1.031     0.200
     1.169     0.344     0.200
     1.204     0.742     0.200
     1.264    -1.233     0.200
     1.304    -1.539     0.200
     1.268     0.077     0.200
     1.324    -1.471     0.200
     1.332     0.206     0.200
     1.367    -0.936     0.200
     1.478    -1.324     0.200
     1.488    -1.662     0.200
     0.923     0.578     0.200
     1.048    -0.411     0.200
     1.121    -1.040     0.200
     1.121     2.460     0.200
     1.286    -0.194     0.200
     1.347    -0.078     0.200
     0.929     0.151     0.200
     1.056    -0.495     0.200
     1.053    -0.869     0.200
     1.115    -0.668     0.200
     1.282    -0.016     0.200
     1.354    -0.153     0.200
     1.473    -0.246     0.200
     3.644   -15.709     0.200
     4.750   -23.003     0.200
     5.169   -25.258     0.200
     5.893   -32.079     0.200
     6.010   -32.048     0.200
     6.045   -31.479     0.200
     7.236   -39.424     0.200
     0.846     0.097     0.200
     0.962     0.897     0.200
     1.305    -0.421     0.200
     1.333     0.102     0.200
     1.422    -1.085     0.200
     2.829   -11.462     0.200
     7.418   -43.633     0.200
     2.525    -9.462     0.200
     4.932   -26.287     0.200
     5.604   -31.227     0.200
     7.106   -41.546     0.200
     7.099   -40.073     0.200
     7.858   -46.100     0.200
    11.695   -74.605     0.200
     0.944     2.506     0.200
     1.095    -0.094     0.200
     1.220    -0.957     0.200
     1.232    -0.347     0.200
     1.232     1.121     0.200
     1.363    -0.803     0.200
     2.692   -11.077     0.200
     0.928     0.918     0.200
     0.995     1.415     0.200
     1.093     0.428     0.200
     1.227    -0.908     0.200
     1.318    -1.210     0.200
     1.344     1.128     0.200
     1.358     0.448     0.200
     1.455    -0.570     0.200
     1.549     0.607     0.200
     1.562    -1.132     0.200
     1.559    -0.424     0.200
     0.940     0.420     0.200
     0.940     0.303     0.200
     0.998    -0.216     0.200
     1.023    -0.250     0.200
     1.114    -1.459     0.200
     1.123    -0.255     0.200
     1.154    -1.240     0.200
     1.168    -0.322     0.200
     1.303    -1.757     0.200
     0.888    -0.389     0.200
     0.862    -0.329     0.200
     1.038    -1.257     0.200
     1.156    -0.283     0.200
     1.137    -2.365     0.200
     1.219    -0.627     0.200
     1.169     0.106     0.200
     1.190    -0.305     0.200
     1.024    -0.220     0.200
     1.349    -0.058     0.200
     2.086    -7.912     0.200
     2.087    -8.204     0.200
     0.980    -0.530     0.200
     0.980     0.017     0.200
     1.020     0.153     0.200
     1.127    -0.730     0.200
     1.127    -0.136     0.200
     1.128    -1.018     0.200
     1.182    -0.624     0.200
     1.266    -1.588     0.200
     1.311    -2.289     0.200
     0.893     1.142     0.200
     0.983     0.538     0.200
     0.983     2.671     0.200
     1.014     2.266     0.200
     1.077     0.231     0.200
     1.249    -1.016     0.200
     1.249    -0.227     0.200
     1.249    -0.865     0.200
     1.249    -0.642     0.200
     1.232    -0.115     0.200
     1.275    -0.343     0.200
     1.371    -1.262     0.200
     1.364    -0.938     0.200
     1.304    -0.182     0.200
     1.391    -0.899     0.200
     1.495     0.793     0.200
     1.539     0.365     0.200
     1.023     2.905     0.200
     1.065     1.059     0.200
     1.108     0.848     0.200
     1.195     2.009     0.200
     1.236     0.165     0.200
     1.236     0.495     0.200
     1.236     0.137     0.200
     1.236     0.218     0.200
     1.305     0.051     0.200
     1.305     0.383     0.200
     1.366     0.843     0.200
     1.366     2.603     0.200
     1.367     2.335     0.200
     1.367    -0.604     0.200
     1.390    -0.160     0.200
     1.456    -0.044     0.200
     1.508     1.057     0.200
     1.508     1.687     0.200
     1.550    -0.302     0.200
     1.550     1.524     0.200
     1.576    -0.223     0.200
     2.627    -7.707     0.200
     5.639   -30.131     0.200
     6.814   -37.211     0.200
     7.142   -40.511     0.200
    11.375   -67.472     0.200
    12.378   -76.535     0.200
     1.025     0.309     0.200
     1.031     0.391     0.200
     1.046     0.019     0.200
     1.255     0.040     0.200
     1.348    -0.468     0.200
     1.348     0.564     0.200
     1.384    -0.956     0.200
     1.384     0.064     0.200
     1.394    -0.116     0.200
     6.028   -31.574     0.200
     0.938     0.313     0.200
     0.938    -0.210     0.200
     0.975     0.178     0.200
     0.983    -0.100     0.200
     1.031    -0.247     0.200
     1.140    -0.231     0.200
     1.140    -0.794     0.200
     1.159    -0.249     0.200
     1.159    -1.749     0.200
     1.183    -1.398     0.200
     1.183     1.180     0.200
     1.290    -0.579     0.200
     1.468    -3.104     0.200
     2.493   -10.385     0.200
     3.641   -19.213     0.200
     0.942     1.033     0.200
     0.946     0.528     0.200
     0.949     0.677     0.200
     0.949     0.294     0.200
     0.986    -0.164     0.200
     0.994    -0.047     0.200
     1.037     0.071     0.200
     1.131     0.477     0.200
     1.131    -0.414     0.200
     1.168     0.090     0.200
     1.195    -1.625     0.200
     1.302    -0.971     0.200
     1.302    -1.714     0.200
     0.938     0.907     0.200
     0.946     0.957     0.200
     0.946     0.262     0.200
     0.984     0.190     0.200
     0.995    -0.416     0.200
     1.032    -0.114     0.200
     1.109    -1.229     0.200
     1.129    -0.687     0.200
     1.171    -0.671     0.200
     1.171    -0.897     0.200
     1.302    -1.045     0.200
     1.981    -7.757     0.200
     0.937     0.401     0.200
     0.944     0.498     0.200
     0.981     0.539     0.200
     1.105    -0.593     0.200
     1.167    -0.279     0.200
     0.949     0.966     0.200
     0.952     0.905     0.200
     0.983     0.308     0.200
     1.145    -0.456     0.200
     1.145    -0.127     0.200
     1.155    -1.020     0.200
     1.155    -0.520     0.200
     1.294    -1.130     0.200
     1.294    -0.036     0.200
     0.941     0.313     0.200
     0.968     0.694     0.200
     1.047    -0.815     0.200
     1.108    -0.612     0.200
     1.191    -0.264     0.200
     1.233    -0.329     0.200
     1.254    -0.300     0.200
     1.456    -0.473     0.200
     0.935     0.971     0.200
     0.942     0.529     0.200
     0.992    -0.172     0.200
     1.029     0.374     0.200
     1.107    -1.059     0.200
     1.130    -0.422     0.200
     1.169    -0.221     0.200
     1.169    -1.002     0.200
     1.193    -1.062     0.200
     1.299    -0.808     0.200
     2.461    -9.533     0.200
     0.934    -0.108     0.200
     0.942     0.319     0.200
     0.984     0.447     0.200
     1.017     0.321     0.200
     1.108     0.543     0.200
     1.108    -0.067     0.200
     1.191     0.226     0.200
     1.191    -0.649     0.200
     1.314    -1.768     0.200
     1.480    -0.613     0.200
     0.950    -0.516     0.200
     0.957    -0.086     0.200
     0.984     0.230     0.200
     1.189    -1.466     0.200
     1.189    -0.763     0.200
     1.266    -0.572     0.200
     1.472     0.255     0.200
     1.559    -5.381     0.200
     4.324   -20.540     0.200
     0.942     0.201     0.200
     0.950     1.205     0.200
     0.950     0.181     0.200
     1.008    -0.186     0.200
     1.008     0.689     0.200
     0.989     0.322     0.200
     1.028     0.123     0.200
     1.122    -1.149     0.200
     1.184     0.228     0.200
     1.184    -0.663     0.200
     1.115     0.070     0.200
     1.208    -1.308     0.200
     1.620    -4.359     0.200
     0.948    -0.119     0.200
     0.952     0.623     0.200
     0.955     0.362     0.200
     0.955     0.186     0.200
     0.996     0.373     0.200
     1.014    -0.139     0.200
     1.032     0.353     0.200
     1.127    -0.611     0.200
     1.111    -0.806     0.200
     1.189    -0.205     0.200
     1.320    -1.240     0.200
     1.320    -1.244     0.200
     2.550   -12.153     0.200
     6.555   -41.008     0.200
     7.850   -50.603     0.200
     0.942    -0.093     0.200
     0.974    -0.198     0.200
     0.976    -0.007     0.200
     1.040    -0.415     0.200
     1.087    -1.143     0.200
     1.148     0.339     0.200
     1.148    -0.044     0.200
     1.151    -0.772     0.200
     1.196    -0.883     0.200
     1.284    -1.425     0.200
     0.926     0.545     0.200
     0.930    -0.044     0.200
     0.933     0.136     0.200
     0.933     0.764     0.200
     0.970     0.218     0.200
     0.970     0.098     0.200
     0.968     0.448     0.200
     1.033     0.156     0.200
     1.084    -0.098     0.200
     1.153    -0.505     0.200
     1.153    -0.231     0.200
     1.146    -0.160     0.200
     1.146     0.249     0.200
     1.170    -0.700     0.200
     1.277    -1.283     0.200
     3.494   -15.773     0.200
     3.552   -18.383     0.200
     3.642   -18.605     0.200
     3.730   -19.059     0.200
     3.955   -22.644     0.200
     0.933    -0.074     0.200
     1.015    -0.502     0.200
     1.127     1.319     0.200
     1.255    -1.169     0.200
     1.337    -0.888     0.200
     2.697   -10.328     0.200
     0.975     1.035     0.200
     1.240     0.396     0.200
     1.240     0.052     0.200
     1.291     1.435     0.200
     1.280     1.331     0.200
     1.331    -0.111     0.200
     1.360    -0.758     0.200
     1.417    -0.040     0.200
     1.441     0.125     0.200
     1.542     0.903     0.200
     1.555     0.913     0.200
     1.023    -0.094     0.200
     0.993     0.429     0.200
     1.379    -0.050     0.200
     1.481    -1.155     0.200
     2.190    -7.738     0.200
     3.088   -16.256     0.200
     3.088   -15.443     0.200
     0.859     0.280     0.200
     0.834     0.753     0.200
     0.915    -0.300     0.200
     0.968     0.354     0.200
     1.093    -1.517     0.200
     1.211    -1.297     0.200
     1.224    -0.866     0.200
     1.274     0.178     0.200
     1.315     0.326     0.200
     0.854     0.241     0.200
     0.897     0.130     0.200
     0.852     1.107     0.200
     1.196    -0.927     0.200
     1.240    -0.041     0.200
     1.275    -0.073     0.200
     1.330    -0.259     0.200
     0.825     0.996     0.200
     0.851     1.088     0.200
     0.964     1.301     0.200
     1.008     0.083     0.200
     1.039    -0.461     0.200
     1.312    -1.031     0.200
     0.987     1.725     0.200
     1.499     1.398     0.200
     1.004     1.084     0.200
     1.031     0.053     0.200
     1.064     0.294     0.200
     1.263    -1.204     0.200
     1.263    -0.376     0.200
     1.278    -1.047     0.200
     0.839     0.227     0.200
     1.009     0.275     0.200
     1.062    -0.837     0.200
     1.312    -1.268     0.200
     1.377    -1.022     0.200
     1.474     0.108     0.200
     2.627   -10.224     0.200
     0.842    -0.033     0.200
     0.807     0.314     0.200
     0.844    -0.443     0.200
     0.830     2.901     0.200
     0.918    -0.677     0.200
     0.936    -0.419     0.200
     0.967    -0.084     0.200
     1.024    -0.492     0.200
     1.024    -0.822     0.200
     0.985     0.362     0.200
     1.013    -0.243     0.200
     1.029    -0.163     0.200
     1.066    -1.299     0.200
     1.063    -0.470     0.200
     1.069     0.732     0.200
     1.094     0.111     0.200
     1.094    -0.070     0.200
     1.151    -1.483     0.200
     1.124    -0.311     0.200
     1.156     0.185     0.200
     1.201    -0.184     0.200
     1.207     0.052     0.200
     1.271    -1.624     0.200
     1.259    -0.034     0.200
     1.285    -1.103     0.200
     1.285    -1.499     0.200
     1.310    -0.595     0.200
     1.361    -0.285     0.200
     1.470    -0.533     0.200
     0.868     1.957     0.200
     1.025     0.563     0.200
     1.130    -0.183     0.200
     1.205    -0.451     0.200
     1.217     0.761     0.200
     1.288    -1.656     0.200
     1.383    -0.771     0.200
     1.025     0.682     0.200
     1.025     0.803     0.200
     1.078     0.280     0.200
     1.088     0.174     0.200
     1.191    -0.289     0.200
     1.196    -0.418     0.200
     1.202    -0.022     0.200
     1.234     0.628     0.200
     1.336     0.401     0.200
     1.375    -0.893     0.200
     1.384     0.136     0.200
     1.435    -0.094     0.200
     1.076     0.388     0.200
     1.076     0.689     0.200
     1.117     0.215     0.200
     1.181     0.216     0.200
     1.192     0.108     0.200
     1.192    -0.305     0.200
     1.231    -0.047     0.200
     1.242     0.746     0.200
     1.249    -0.036     0.200
     1.257    -0.523     0.200
     1.273     0.221     0.200
     1.330     0.861     0.200
     1.364    -0.330     0.200
     1.385     0.432     0.200
     1.444     0.184     0.200
     1.518     0.569     0.200
     0.807     1.127     0.200
     0.807     0.475     0.200
     0.834     0.665     0.200
     0.881     0.502     0.200
     0.984    -0.150     0.200
     0.999     0.004     0.200
     0.990     1.014     0.200
     0.990     0.336     0.200
     1.094    -0.548     0.200
     1.077     1.380     0.200
     1.077    -0.338     0.200
     1.111     0.814     0.200
     1.165    -0.448     0.200
     1.209    -0.162     0.200
     1.250    -1.872     0.200
     1.250    -1.818     0.200
     1.059    -1.155     0.200
     1.002     0.226     0.200
     1.051    -0.560     0.200
     1.233    -0.548     0.200
     1.454    -3.378     0.200
     0.749     0.044     0.200
     0.910     1.102     0.200
     0.979     0.243     0.200
     1.089    -1.366     0.200
     1.189    -0.775     0.200
     1.225    -0.362     0.200
     1.242    -0.943     0.200
     1.285    -0.584     0.200
     1.310    -1.055     0.200
     1.384    -1.194     0.200
     6.894   -39.039     0.200
     0.842     0.197     0.200
     0.842     0.341     0.200
     0.832     1.250     0.200
     0.807     1.079     0.200
     0.846     1.714     0.200
     0.883    -0.297     0.200
     0.858     0.282     0.200
     0.853     0.520     0.200
     0.852     0.300     0.200
     0.895     1.879     0.200
     0.895     2.340     0.200
     0.902    -0.343     0.200
     0.905     0.796     0.200
     1.026    -0.992     0.200
     1.281    -1.084     0.200
     1.298     0.688     0.200
     1.385     0.650     0.200
     1.489    -0.532     0.200
    21.661  -147.373     0.200
     0.954    -0.656     0.200
     0.963    -0.621     0.200
     0.968    -0.002     0.200
     1.078    -0.704     0.200
     1.233    -0.917     0.200
     1.282    -1.470     0.200
     0.930    -0.611     0.200
     1.022    -0.868     0.200
     1.132    -0.966     0.200
     1.190    -1.758     0.200
     1.310    -2.386     0.200
     2.509   -11.612     0.200
     0.805     0.415     0.200
     0.808     0.432     0.200
     0.808     2.272     0.200
     0.856     0.054     0.200
     0.863     0.342     0.200
     0.868     0.679     0.200
     0.871     0.341     0.200
     0.871     0.447     0.200
     0.879     0.844     0.200
     0.907     0.320     0.200
     0.916     0.187     0.200
     0.921     0.661     0.200
     1.011    -0.069     0.200
     1.037     0.795     0.200
     1.057    -0.240     0.200
     1.116    -0.240     0.200
     1.125    -0.363     0.200
     1.125    -0.059     0.200
     1.164    -0.004     0.200
     1.241     0.077     0.200
     1.305     0.285     0.200
     1.355     0.321     0.200
     0.844     1.419     0.200
     0.863     1.172     0.200
     0.877     0.860     0.200
     0.945     1.602     0.200
     0.934     1.906     0.200
     1.007    -0.331     0.200
     0.978     1.367     0.200
     1.059    -0.196     0.200
     1.225    -1.161     0.200
     1.255     0.057     0.200
     1.371     0.230     0.200
     1.473     0.536     0.200
     0.850     1.688     0.200
     0.866     0.987     0.200
     0.879     1.267     0.200
     0.940     1.370     0.200
     0.946     1.436     0.200
     0.985     0.545     0.200
     1.036     0.015     0.200
     1.057     0.387     0.200
     1.117     1.278     0.200
     1.161     0.033     0.200
     1.210    -0.021     0.200
     1.221    -0.023     0.200
     1.222     0.043     0.200
     1.257     1.963     0.200
     1.376     1.818     0.200
     0.851     1.354     0.200
     0.875     0.490     0.200
     0.889     1.067     0.200
     0.940     1.316     0.200
     0.950     1.141     0.200
     0.959     1.253     0.200
     0.968     1.393     0.200
     1.054    -0.462     0.200
     1.074     0.084     0.200
     1.074     0.684     0.200
     1.088    -0.251     0.200
     1.179    -0.121     0.200
     1.268     0.558     0.200
     1.379     0.812     0.200
     0.847     0.755     0.200
     0.863     0.595     0.200
     0.876     0.709     0.200
     0.942     0.881     0.200
     1.000    -0.544     0.200
     1.034    -0.720     0.200
     1.054    -0.317     0.200
     1.062     0.603     0.200
     1.109    -0.958     0.200
     1.219    -1.447     0.200
     1.257    -1.616     0.200
     1.374    -0.411     0.200
     0.847     1.095     0.200
     0.863     0.640     0.200
     0.876     0.859     0.200
     0.937     0.863     0.200
     0.943     0.680     0.200
     0.943     0.360     0.200
     0.985    -0.166     0.200
     1.001    -0.437     0.200
     1.035     0.194     0.200
     1.055    -0.240     0.200
     1.062     0.665     0.200
     1.108    -0.649     0.200
     1.115    -0.702     0.200
     1.115     0.862     0.200
     1.160    -1.072     0.200
     1.219    -1.317     0.200
     1.220    -1.466     0.200
     1.220    -1.192     0.200
     1.373    -2.278     0.200
     1.662    -4.837     0.200
     0.843     0.385     0.200
     0.843     0.701     0.200
     0.879     0.872     0.200
     0.890     0.883     0.200
     0.903     0.823     0.200
     0.932     1.374     0.200
     0.951     1.408     0.200
     0.953     1.134     0.200
     1.033     0.657     0.200
     1.033     1.364     0.200
     1.310    -1.402     0.200
     0.889     1.152     0.200
     0.940     0.896     0.200
     0.977     0.149     0.200
     0.987     0.747     0.200
     0.981    -0.235     0.200
     0.981    -0.032     0.200
     1.031     0.041     0.200
     1.050     0.732     0.200
     1.079    -0.469     0.200
     1.088    -0.854     0.200
     1.154     0.475     0.200
     1.192    -1.531     0.200
     1.192    -1.336     0.200
     1.219     1.343     0.200
     1.306    -0.769     0.200
     0.892     1.190     0.200
     0.938     0.945     0.200
     0.952     0.142     0.200
     0.976     0.060     0.200
     0.985    -0.287     0.200
     0.985     0.643     0.200
     0.979    -0.077     0.200
     1.032     0.037     0.200
     1.011    -0.123     0.200
     1.048     0.350     0.200
     1.068     0.844     0.200
     1.086    -0.897     0.200
     1.077    -0.636     0.200
     1.154     0.297     0.200
     1.191    -1.394     0.200
     1.191    -1.495     0.200
     1.191     0.012     0.200
     1.215    -1.299     0.200
     1.215    -0.908     0.200
     1.215    -0.143     0.200
     1.219     0.545     0.200
     1.271    -2.108     0.200
     1.304    -0.710     0.200
     1.501     0.670     0.200
     0.866     0.916     0.200
     0.870     0.338     0.200
     0.899     0.507     0.200
     0.906     0.035     0.200
     1.036     0.070     0.200
     1.022     0.349     0.200
     1.064    -0.445     0.200
     1.119    -0.051     0.200
     1.181    -0.418     0.200
     1.248     0.040     0.200
     0.880     0.881     0.200
     0.900     1.641     0.200
     0.972     0.363     0.200
     0.980     1.061     0.200
     0.981     0.523     0.200
     0.988     0.359     0.200
     0.992     0.675     0.200
     1.081     0.113     0.200
     1.084    -0.595     0.200
     1.082     0.599     0.200
     1.084     2.055     0.200
     1.122     0.407     0.200
     1.179    -0.529     0.200
     1.197    -1.073     0.200
     1.216    -0.116     0.200
     1.232     0.926     0.200
     1.237    -0.400     0.200
     1.237    -1.220     0.200
     1.292    -0.405     0.200
     1.350     0.699     0.200
     0.781     0.700     0.200
     0.803     0.586     0.200
     0.817     2.252     0.200
     0.843     0.582     0.200
     0.855     0.183     0.200
     0.855    -0.287     0.200
     0.868     0.503     0.200
     0.914     0.310     0.200
     0.925    -0.458     0.200
     0.928    -0.382     0.200
     1.076     0.162     0.200
     1.161     0.127     0.200
     1.235    -0.682     0.200
     1.321    -1.083     0.200
     1.304     0.001     0.200
     1.444    -1.202     0.200
     1.457    -1.156     0.200
     0.780     0.364     0.200
     0.809    -0.029     0.200
     0.829     0.219     0.200
     0.829    -0.359     0.200
     0.837     0.590     0.200
     0.837     0.715     0.200
     0.900    -0.039     0.200
     0.908    -0.399     0.200
     0.908    -0.196     0.200
     0.962     1.130     0.200
     1.010    -0.415     0.200
     1.094    -0.508     0.200
     1.185    -0.934     0.200
     1.207    -0.501     0.200
     1.317    -0.031     0.200
     1.340     0.537     0.200
     1.434     0.413     0.200
     1.469    -0.486     0.200
     3.819   -17.663     0.200
     0.842     1.428     0.200
     0.904     1.337     0.200
     0.908     0.572     0.200
     1.008     0.135     0.200
     1.028    -0.096     0.200
     1.023    -0.143     0.200
     1.103     1.156     0.200
     1.152     0.470     0.200
     1.218    -0.901     0.200
     1.270    -0.711     0.200
     1.435     0.380     0.200
     0.754     0.252     0.200
     0.754     0.035     0.200
     0.754     0.339     0.200
     0.788     2.674     0.200
     0.789     1.919     0.200
     0.778     0.529     0.200
     0.777     1.173     0.200
     0.805     0.326     0.200
     0.807     1.952     0.200
     0.859    -0.453     0.200
     0.877    -0.391     0.200
     0.876    -0.013     0.200
     1.013     0.593     0.200
     1.229    -0.679     0.200
     1.414    -0.688     0.200
     0.844     0.935     0.200
     0.941     0.704     0.200
     0.968     0.525     0.200
     1.003     0.232     0.200
     1.190     0.446     0.200
     1.276    -0.830     0.200
     1.457     0.380     0.200
     2.854   -13.119     0.200
     0.841     1.532     0.200
     0.908     1.285     0.200
     0.903     0.418     0.200
     0.903     1.012     0.200
     0.942     0.358     0.200
     1.007     0.215     0.200
     1.019    -0.083     0.200
     1.033     0.041     0.200
     1.099     0.942     0.200
     1.151     0.268     0.200
     1.222    -1.078     0.200
     1.430     0.458     0.200
     0.802     0.309     0.200
     0.800     0.765     0.200
     0.831     0.658     0.200
     0.834     0.743     0.200
     0.843     0.490     0.200
     0.880     0.487     0.200
     0.918     0.235     0.200
     0.913     1.394     0.200
     0.929     0.828     0.200
     1.030    -0.193     0.200
     1.036    -0.764     0.200
     1.107    -0.094     0.200
     1.250    -1.495     0.200
     1.379     0.246     0.200
     2.441    -9.058     0.200
     0.978     0.683     0.200
     1.012     0.465     0.200
     1.020     0.431     0.200
     1.029     0.628     0.200
     1.073     1.923     0.200
     1.165    -0.217     0.200
     1.165    -0.341     0.200
     1.326     0.710     0.200
     1.325     0.099     0.200
     1.406     0.847     0.200
     1.415     0.748     0.200
     1.520    -1.075     0.200
     1.561    -0.368     0.200
     2.265    -6.880     0.200
     3.711   -16.270     0.200
     4.459   -19.538     0.200
     4.947   -23.210     0.200
     0.803     0.864     0.200
     0.829     0.408     0.200
     0.835     1.486     0.200
     0.894    -0.129     0.200
     0.863     0.354     0.200
     0.908     0.079     0.200
     0.890     0.744     0.200
     0.992     0.235     0.200
     1.039     0.205     0.200
     1.039     2.287     0.200
     1.052     0.522     0.200
     0.787     2.321     0.200
     0.814     0.345     0.200
     0.830     0.786     0.200
     0.837     0.676     0.200
     0.850     0.927     0.200
     0.902     0.094     0.200
     0.902     2.775     0.200
     0.922     0.527     0.200
     0.961     0.001     0.200
     0.972     0.009     0.200
     0.972    -0.157     0.200
     0.991    -0.038     0.200
     0.993    -0.259     0.200
     1.036    -0.689     0.200
     1.060    -0.907     0.200
     1.077    -0.998     0.200
     1.123    -0.222     0.200
     1.126    -0.064     0.200
     1.192     0.476     0.200
     1.207    -1.426     0.200
     1.221    -1.475     0.200
     1.332    -0.487     0.200
     1.348    -0.793     0.200
     1.365    -1.511     0.200
     1.409    -0.983     0.200
     1.409    -1.117     0.200
     1.456    -2.759     0.200
     0.848     0.454     0.200
     0.867     0.388     0.200
     0.878     0.482     0.200
     0.895     1.267     0.200
     0.931     0.330     0.200
     0.929     0.216     0.200
     4.787   -24.380     0.200
     0.862     1.861     0.200
     0.989     0.842     0.200
     0.810     0.785     0.200
     0.856     1.216     0.200
     0.872     0.418     0.200
     0.863     1.953     0.200
     0.891     0.575     0.200
     0.957     0.541     0.200
     1.005    -0.040     0.200
     0.993     0.190     0.200
     1.028    -0.441     0.200
     1.051     0.085     0.200
     0.861     1.917     0.200
     0.890     1.238     0.200
     0.899     1.402     0.200
     0.898     0.508     0.200
     0.896     0.705     0.200
     0.902     2.347     0.200
     0.810     1.172     0.200
     0.851     0.584     0.200
     0.867     1.071     0.200
     0.867     1.260     0.200
     0.916     1.165     0.200
     0.717     0.003     0.200
     0.726     0.636     0.200
     0.752     0.198     0.200
     0.768     0.444     0.200
     0.782     0.384     0.200
     0.785    -0.304     0.200
     0.810    -0.051     0.200
     0.852    -0.271     0.200
     0.846    -0.422     0.200
     0.875    -0.833     0.200
     0.895    -0.590     0.200
     0.899    -1.033     0.200
     0.974    -0.974     0.200
     0.971    -0.685     0.200
     1.014    -0.368     0.200
     1.018    -0.380     0.200
     1.006    -0.805     0.200
     1.027    -0.776     0.200
     1.023     0.049     0.200
     1.039    -0.565     0.200
     1.040    -0.747     0.200
     1.071     1.037     0.200
     1.072    -0.908     0.200
     0.831     1.703     0.200
     0.967     1.270     0.200
     0.983     1.108     0.200
     0.987     1.254     0.200
     1.011     0.699     0.200
     0.899     1.555     0.200
     0.904     0.971     0.200
     0.911     1.951     0.200
     0.987     0.401     0.200
     0.840     1.378     0.200
     0.845     0.566     0.200
     0.905     1.135     0.200
     0.914     0.397     0.200
     1.075     0.034     0.200
     1.288    -1.029     0.200
     0.827     1.550     0.200
     0.833     1.212     0.200
     0.884     1.282     0.200
     0.899     1.120     0.200
     0.973     0.524     0.200
     0.974     1.261     0.200
     0.993     1.073     0.200
     0.965     1.552     0.200
     0.975     0.710     0.200
     1.071     0.133     0.200
     1.075     0.582     0.200
     1.094     0.935     0.200
     1.285    -1.079     0.200
     1.388     0.791     0.200
     1.394    -0.027     0.200
     1.490    -0.463     0.200
     1.534    -0.915     0.200
     0.834     0.917     0.200
     0.907     0.398     0.200
     0.910     0.282     0.200
     0.947     0.353     0.200
     0.970     0.125     0.200
     0.970    -0.182     0.200
     0.994     0.269     0.200
     1.079    -0.341     0.200
     1.124    -0.715     0.200
     0.938     1.130     0.200
     0.985     1.209     0.200
     0.907     1.395     0.200
     0.946     0.617     0.200
     0.946     0.390     0.200
     0.976     0.003     0.200
     0.981     0.409     0.200
     0.993     0.354     0.200
     0.999    -0.091     0.200
     1.084    -0.496     0.200
     1.204    -0.885     0.200
     0.821     0.805     0.200
     0.834     1.092     0.200
     0.887     0.304     0.200
     0.907    -0.155     0.200
     0.971    -0.506     0.200
     1.000     0.342     0.200
     1.001    -0.690     0.200
     1.084    -0.637     0.200
     1.124    -1.279     0.200
     1.142    -0.067     0.200
     1.157    -0.596     0.200
     1.167    -0.487     0.200
     0.827     1.823     0.200
     0.881     1.363     0.200
     0.877     1.112     0.200
     0.897     1.118     0.200
     0.901     0.352     0.200
     0.901     1.238     0.200
     0.938     1.219     0.200
     1.087    -0.471     0.200
     1.119    -0.484     0.200
     1.157    -0.055     0.200
    10.063   -60.121     0.200
     0.836     0.513     0.200
     0.889     0.222     0.200
     0.892     0.885     0.200
     0.931     0.062     0.200
     0.931     0.282     0.200
     0.969    -0.525     0.200
     0.986     0.031     0.200
     1.094    -0.797     0.200
     1.116    -1.412     0.200
     0.890     0.250     0.200
     0.912     0.316     0.200
     0.912     0.117     0.200
     0.830     0.401     0.200
     0.834     0.497     0.200
     0.881     0.785     0.200
     0.892     0.249     0.200
     0.895     0.387     0.200
     0.885     0.160     0.200
     0.935     0.492     0.200
     0.975     0.544     0.200
     0.977     0.290     0.200
     1.052    -0.920     0.200
     1.084    -0.118     0.200
     1.098     0.467     0.200
     1.122    -0.755     0.200
     1.317    -0.214     0.200
     0.845     0.919     0.200
     0.900     0.483     0.200
     0.907     0.488     0.200
     0.948     0.397     0.200
     0.907    -0.074     0.200
     0.843     0.668     0.200
     0.878     0.428     0.200
     0.905     0.698     0.200
     0.908     0.643     0.200
     0.908     0.417     0.200
     1.097    -0.185     0.200
     1.135    -0.776     0.200
     1.126    -0.960     0.200
     1.144    -0.601     0.200
     0.832     1.086     0.200
     0.832     0.851     0.200
     0.851     0.688     0.200
     0.865     1.465     0.200
     0.819     0.463     0.200
     0.884     0.630     0.200
     0.894     1.293     0.200
     0.894     0.918     0.200
     0.922     1.202     0.200
     0.941     1.709     0.200
     0.944     0.866     0.200
     0.932     1.533     0.200
     1.003     0.316     0.200
     1.024     1.874     0.200
     1.046    -0.516     0.200
     1.231    -1.500     0.200
     0.825     0.745     0.200
     0.824     0.790     0.200
     0.824     0.618     0.200
     0.880     1.139     0.200
     0.878     0.795     0.200
     0.910     1.401     0.200
     1.005     0.316     0.200
     1.054     1.425     0.200
     1.202    -1.657     0.200
     0.842     0.783     0.200
     0.788     1.388     0.200
     0.800     1.227     0.200
     0.827    -0.169     0.200
     0.855    -0.810     0.200
     0.895    -0.405     0.200
     0.912    -0.504     0.200
     0.912     0.034     0.200
     0.924    -0.686     0.200
     0.923     0.351     0.200
     0.936    -0.969     0.200
     0.940     0.495     0.200
     0.955     1.164     0.200
     1.172    -2.349     0.200
     1.155    -1.037     0.200
     1.145    -0.617     0.200
     0.824     0.995     0.200
     0.826     1.312     0.200
     0.835     0.944     0.200
     0.869     0.881     0.200
     0.885     1.458     0.200
     0.885     1.368     0.200
     0.907     0.971     0.200
     0.914     1.651     0.200
     0.920     0.582     0.200
     0.933     0.492     0.200
     1.009     0.281     0.200
     0.849     0.866     0.200
     0.825     1.015     0.200
     0.852     0.664     0.200
     0.866     0.432     0.200
     0.884     1.078     0.200
     0.883     0.871     0.200
     0.875     1.643     0.200
     0.912     1.248     0.200
     0.919     0.545     0.200
     0.933     0.749     0.200
     0.932     1.382     0.200
     0.940     0.434     0.200
     0.975     0.079     0.200
     1.014    -0.120     0.200
     1.004     0.393     0.200
     1.072    -0.754     0.200
     1.134    -0.723     0.200
     0.821     0.573     0.200
     0.823     0.987     0.200
     0.838     0.389     0.200
     0.845     0.550     0.200
     0.860     0.686     0.200
     0.871     1.241     0.200
     0.890     1.320     0.200
     0.896     1.412     0.200
     0.903     1.345     0.200
     0.903     1.488     0.200
     0.920     1.078     0.200
     0.923     1.485     0.200
     0.940     0.389     0.200
     0.936     0.637     0.200
     0.987     0.161     0.200
     1.003     0.743     0.200
     1.026     0.137     0.200
     1.031     0.369     0.200
     1.034    -0.410     0.200
     1.093    -0.614     0.200
     1.152    -1.042     0.200
     1.181     0.455     0.200
     1.196     0.765     0.200
     1.201     0.013     0.200
     1.234    -1.559     0.200
     1.276    -1.163     0.200
     1.324    -1.594     0.200
     0.739     1.663     0.200
     0.763     1.242     0.200
     0.795    -0.212     0.200
     0.773     0.344     0.200
     0.806     0.937     0.200
     0.799    -0.212     0.200
     0.824    -0.143     0.200
     0.799     1.929     0.200
     0.813     1.037     0.200
     0.831     0.551     0.200
     0.833     0.503     0.200
     0.873    -0.410     0.200
     0.880    -0.318     0.200
     0.884     0.760     0.200
     0.884     0.040     0.200
     0.897     0.518     0.200
     0.909     1.008     0.200
     0.902     0.194     0.200
     0.924    -0.008     0.200
     0.951     1.421     0.200
     0.959    -0.502     0.200
     0.995    -1.078     0.200
     1.007    -1.234     0.200
     0.821     0.555     0.200
     0.825     0.928     0.200
     0.829     0.682     0.200
     0.831     1.348     0.200
     0.831     0.434     0.200
     0.855     0.504     0.200
     0.882     0.375     0.200
     0.883     1.030     0.200
     0.883     0.910     0.200
     0.894     0.706     0.200
     0.903     0.904     0.200
     0.899     0.283     0.200
     0.906     1.028     0.200
     0.914     1.239     0.200
     0.912     1.408     0.200
     0.934     0.848     0.200
     0.960     0.357     0.200
     1.009    -0.088     0.200
     1.048    -0.117     0.200
     1.064    -0.375     0.200
     1.064     0.145     0.200
     1.079     0.894     0.200
     1.113    -0.670     0.200
     1.099     0.194     0.200
     1.173    -0.260     0.200
     1.170     0.458     0.200
     1.180    -0.426     0.200
     1.188     0.219     0.200
     1.203    -1.313     0.200
     1.210    -0.549     0.200
     1.223    -0.130     0.200
     1.225    -0.135     0.200
     1.295    -1.692     0.200
     1.304    -0.792     0.200
     1.361    -1.087     0.200
     1.467    -2.753     0.200
     0.803     1.193     0.200
     0.812     0.266     0.200
     0.818     0.439     0.200
     0.822     0.589     0.200
     0.810     1.180     0.200
     0.828     0.717     0.200
     0.830     0.693     0.200
     0.852     0.336     0.200
     0.854     0.543     0.200
     0.878     0.199     0.200
     0.912     1.350     0.200
     0.894     0.505     0.200
     0.912     1.138     0.200
     0.900     0.587     0.200
     0.906     0.775     0.200
     0.930     0.461     0.200
     0.932     1.272     0.200
     0.943     0.442     0.200
     1.005    -0.616     0.200
     1.012     0.330     0.200
     1.012    -0.055     0.200
     1.051    -0.820     0.200
     1.049     0.101     0.200
     0.797     0.762     0.200
     0.831     0.334     0.200
     0.849     0.410     0.200
     0.863     0.027     0.200
     0.852     1.260     0.200
     0.885     0.175     0.200
     0.865     0.825     0.200
     0.879     0.780     0.200
     0.886     0.538     0.200
     0.898     0.834     0.200
     0.898     0.818     0.200
     0.908     0.843     0.200
     0.926     0.371     0.200
     0.940     0.320     0.200
     0.953    -0.095     0.200
     0.976     0.180     0.200
     0.979     0.302     0.200
     0.978     0.198     0.200
     0.977     1.815     0.200
     0.988     0.841     0.200
     1.043    -0.722     0.200
     1.027     0.021     0.200
     1.042    -0.902     0.200
     1.083     1.503     0.200
     1.070    -0.369     0.200
     1.096    -1.096     0.200
     1.145    -1.428     0.200
     1.150    -0.143     0.200
     1.172    -1.461     0.200
     1.171    -0.306     0.200
     1.187    -1.222     0.200
     1.184    -0.285     0.200
     1.219    -1.586     0.200
     1.238    -1.151     0.200
     1.277    -2.033     0.200
     1.277    -1.515     0.200
     1.278    -2.026     0.200
     1.309    -1.664     0.200
     1.320    -2.136     0.200
     1.373    -0.730     0.200
     7.832   -45.796     0.200
    10.954   -68.774     0.200
     0.813     1.341     0.200
     0.807     0.670     0.200
     0.880     0.391     0.200
     0.898     0.473     0.200
     0.906     0.593     0.200
     0.921     0.052     0.200
     0.908    -0.191     0.200
     0.928     0.844     0.200
     0.985    -0.478     0.200
     1.104    -0.793     0.200
     0.800     0.839     0.200
     0.808     0.268     0.200
     0.808     0.306     0.200
     0.815     0.646     0.200
     0.834     0.481     0.200
     0.862     1.062     0.200
     0.862     0.878     0.200
     0.874     0.682     0.200
     0.885     1.438     0.200
     0.893     1.399     0.200
     0.881     0.276     0.200
     0.913     0.744     0.200
     1.097    -1.389     0.200
     1.074     0.583     0.200
     1.107     0.123     0.200
     1.179     1.180     0.200
     1.204    -1.317     0.200
     1.236    -1.700     0.200
     0.826     0.848     0.200
     0.838     0.632     0.200
     0.866     1.631     0.200
     0.872     1.527     0.200
     0.887     1.673     0.200
     0.885     2.105     0.200
     0.967     1.119     0.200
     0.963     0.703     0.200
     0.960     0.942     0.200
     0.999    -0.238     0.200
     1.020    -0.050     0.200
     1.012     0.963     0.200
     1.012     0.786     0.200
     1.043    -0.192     0.200
     0.824     0.927     0.200
     0.826     0.958     0.200
     0.831     1.025     0.200
     0.836     0.820     0.200
     0.846     1.775     0.200
     0.865     1.661     0.200
     0.884     1.646     0.200
     0.892     0.970     0.200
     0.919     0.072     0.200
     0.938     0.180     0.200
     0.961     1.440     0.200
     0.958     1.062     0.200
     0.961    -0.045     0.200
     0.966     1.400     0.200
     0.973     0.203     0.200
     0.998     0.529     0.200
     1.000    -0.357     0.200
     0.999     0.824     0.200
     1.011     0.572     0.200
     1.011     0.369     0.200
     1.015     0.982     0.200
     1.044    -0.608     0.200
     1.050     0.217     0.200
     0.859     1.781     0.200
     0.886     0.658     0.200
     1.012    -0.048     0.200
     1.006     0.977     0.200
     1.006     0.574     0.200
     1.035    -0.029     0.200
     1.040    -0.390     0.200
     1.048     0.045     0.200
     1.167    -0.898     0.200
     1.216    -0.741     0.200
     1.266    -0.179     0.200
     1.344    -0.212     0.200
     0.828     0.612     0.200
     0.831     0.790     0.200
     0.844     1.562     0.200
     0.856     0.480     0.200
     0.859     1.354     0.200
     0.879     1.597     0.200
     0.887     0.327     0.200
     0.929     0.225     0.200
     0.961     0.789     0.200
     0.991    -0.109     0.200
     0.992     0.730     0.200
     1.006     0.407     0.200
     1.006     0.664     0.200
     1.025     0.371     0.200
     1.034    -0.147     0.200
     1.039    -0.055     0.200
     1.070     0.710     0.200
     1.085    -0.310     0.200
     1.131    -0.331     0.200
     1.215    -0.404     0.200
     1.266    -0.335     0.200
     0.818     1.033     0.200
     0.814     2.290     0.200
     0.833     0.659     0.200
     0.839     0.453     0.200
     0.858     0.304     0.200
     0.864     0.798     0.200
     0.887     0.809     0.200
     0.893     0.185     0.200
     0.893     0.808     0.200
     0.904     0.249     0.200
     0.918     0.609     0.200
     0.795     0.750     0.200
     0.799     0.406     0.200
     0.797     2.013     0.200
     0.811     1.356     0.200
     0.822     0.684     0.200
     0.824     0.746     0.200
     0.824     0.496     0.200
     0.836     0.443     0.200
     0.846     0.164     0.200
     0.911     0.079     0.200
     0.905     0.771     0.200
     0.908     0.318     0.200
     0.920     0.649     0.200
     1.003     0.034     0.200
     1.005     0.410     0.200
     1.015    -0.429     0.200
     1.124    -0.565     0.200
     0.750     0.458     0.200
     0.752     0.487     0.200
     0.743     0.598     0.200
     0.758     0.471     0.200
     0.794    -0.140     0.200
     0.782     0.259     0.200
     0.823     0.123     0.200
     0.762     0.685     0.200
     0.833    -0.243     0.200
     0.839    -0.189     0.200
     0.780     1.365     0.200
     0.830    -0.326     0.200
     0.854     0.070     0.200
     0.834     0.288     0.200
     0.830    -0.192     0.200
     0.878    -0.393     0.200
     0.878    -0.263     0.200
     0.873     1.727     0.200
     0.807     1.740     0.200
     0.888    -0.693     0.200
     0.917    -0.913     0.200
     0.916    -0.614     0.200
     0.922    -0.894     0.200
     0.922    -0.764     0.200
     0.932     0.165     0.200
     0.943    -0.419     0.200
     0.943    -0.149     0.200
     0.897    -0.137     0.200
     0.903     0.286     0.200
     0.896     1.246     0.200
     0.904     0.469     0.200
     0.925    -0.491     0.200
     1.182    -1.227     0.200
     0.784     1.068     0.200
     0.779     0.934     0.200
     0.789     0.081     0.200
     0.797     0.732     0.200
     0.816     0.268     0.200
     0.819     0.709     0.200
     0.819     1.049     0.200
     0.831    -0.289     0.200
     0.820    -0.063     0.200
     0.841     0.648     0.200
     0.822     0.486     0.200
     0.837     0.659     0.200
     0.852     0.327     0.200
     0.840     0.299     0.200
     0.855     0.547     0.200
     0.854     0.859     0.200
     0.882     0.784     0.200
     0.871    -0.129     0.200
     0.873     1.397     0.200
     0.885     1.617     0.200
     0.895     0.000     0.200
     0.918     1.069     0.200
     0.912     0.012     0.200
     0.921     1.733     0.200
     0.981     0.025     0.200
     1.011     0.174     0.200
     0.808     1.562     0.200
     0.823     2.353     0.200
     0.830     0.547     0.200
     0.829     0.765     0.200
     0.858     0.930     0.200
     0.862     0.229     0.200
     0.879    -0.022     0.200
     0.891     0.293     0.200
     0.890     0.127     0.200
     0.918     0.144     0.200
     0.926    -0.039     0.200
     0.930     0.128     0.200
     0.972     0.573     0.200
     0.981    -0.548     0.200
     0.981    -0.228     0.200
     0.985    -0.284     0.200
     0.999    -0.774     0.200
     1.018    -0.356     0.200
     1.044     0.052     0.200
     1.061    -0.083     0.200
     1.088    -0.741     0.200
     1.088    -0.194     0.200
     1.114    -0.959     0.200
     1.139    -0.646     0.200
     1.174     0.519     0.200
     1.169    -0.981     0.200
     1.211    -1.499     0.200
     1.211    -1.491     0.200
     1.228    -1.662     0.200
     1.228    -1.459     0.200
     1.383    -2.231     0.200
     1.446    -0.459     0.200
     0.814     0.695     0.200
     0.825     1.170     0.200
     0.815     0.951     0.200
     0.848     2.169     0.200
     0.842     1.185     0.200
     0.837     1.371     0.200
     0.869     1.667     0.200
     0.866     0.378     0.200
     0.878     0.138     0.200
     0.860     1.213     0.200
     0.871     0.509     0.200
     0.848     1.603     0.200
     0.887     0.649     0.200
     0.890     0.699     0.200
     0.906     1.482     0.200
     0.997    -0.531     0.200
     1.048     0.365     0.200
     1.110    -1.130     0.200
     1.113     0.143     0.200
     1.117    -0.233     0.200
     1.290     0.758     0.200
     1.361    -2.382     0.200
     1.514    -2.102     0.200
     0.774     0.630     0.200
     0.774     0.823     0.200
     0.788     0.686     0.200
     0.790     0.732     0.200
     0.824     0.891     0.200
     0.813     0.842     0.200
     0.810     0.673     0.200
     0.827     1.328     0.200
     0.821     1.274     0.200
     0.819     0.362     0.200
     0.828    -0.088     0.200
     0.821     0.581     0.200
     0.820     0.450     0.200
     0.846     1.465     0.200
     0.831     1.276     0.200
     0.855     0.017     0.200
     0.865     1.767     0.200
     0.859     0.236     0.200
     0.873    -0.464     0.200
     0.885     0.879     0.200
     0.877     0.684     0.200
     0.869     0.613     0.200
     0.903     2.108     0.200
     0.894     0.064     0.200
     0.887     0.140     0.200
     0.894     0.211     0.200
     0.913     0.887     0.200
     0.942     0.181     0.200
     0.977    -1.053     0.200
     0.960     1.281     0.200
     1.011    -1.156     0.200
     1.058     1.771     0.200
     1.096    -0.779     0.200
     1.412    -0.426     0.200
     1.453    -0.830     0.200
     5.152   -23.646     0.200
     0.827     1.777     0.200
     0.827     1.015     0.200
     0.858     0.845     0.200
     0.857     0.863     0.200
     0.889     1.475     0.200
     0.889     1.631     0.200
     0.913     0.380     0.200
     0.990     0.809     0.200
     1.042    -0.309     0.200
     1.058    -0.327     0.200
     1.079     0.627     0.200
     1.092    -0.289     0.200
     1.092    -0.032     0.200
     1.154     0.135     0.200
     1.183     0.713     0.200
     1.222    -1.419     0.200
     1.214     0.347     0.200
     1.368    -1.586     0.200
     0.824     0.994     0.200
     0.824     1.017     0.200
     0.860     0.673     0.200
     0.854     0.912     0.200
     0.861     1.259     0.200
     0.887     1.539     0.200
     0.885     1.694     0.200
     0.934     0.418     0.200
     0.940     1.520     0.200
     1.044    -0.136     0.200
     1.094     0.131     0.200
     1.156     0.203     0.200
     1.223    -1.427     0.200
     1.217     0.186     0.200
     0.842     0.834     0.200
     0.844     0.780     0.200
     0.844     0.763     0.200
     0.863     0.450     0.200
     0.889     0.283     0.200
     0.889     0.383     0.200
     0.883     1.325     0.200
     0.886     1.337     0.200
     0.904     1.208     0.200
     0.905     1.269     0.200
     0.917     0.134     0.200
     0.929     0.623     0.200
     1.042    -0.784     0.200
     1.038    -0.568     0.200
     1.097    -0.913     0.200
     0.807     0.755     0.200
     0.805     0.421     0.200
     0.824     1.495     0.200
     0.837     0.324     0.200
     0.847     0.087     0.200
     0.847     0.367     0.200
     0.861     0.052     0.200
     0.884     0.670     0.200
     0.899     1.482     0.200
     0.916     0.925     0.200
     0.910     0.513     0.200
     0.918     0.983     0.200
     0.926     0.367     0.200
     1.204    -1.712     0.200
     1.204    -0.022     0.200
     1.204     0.858     0.200
    10.924   -66.630     0.200
     0.778     0.342     0.200
     0.789     0.621     0.200
     0.787     0.806     0.200
     0.800     0.030     0.200
     0.790     0.816     0.200
     0.832     0.564     0.200
     0.853    -0.378     0.200
     0.899    -0.543     0.200
     0.898     0.081     0.200
     0.905    -0.528     0.200
     0.894     0.411     0.200
     0.885     0.137     0.200
     0.909    -0.598     0.200
     0.905    -0.410     0.200
     0.977    -0.684     0.200
     1.199    -2.049     0.200
     1.248    -1.203     0.200
     1.300    -2.448     0.200
     1.319    -0.928     0.200
     1.422    -1.894     0.200
     0.825     0.528     0.200
     0.831     0.632     0.200
     0.848     0.531     0.200
     0.861     1.184     0.200
     0.979    -0.445     0.200
     1.013    -0.297     0.200
     0.800     1.150     0.200
     0.834     0.869     0.200
     0.822     1.691     0.200
     0.844     0.221     0.200
     0.921     1.667     0.200
     0.908    -0.163     0.200
     0.935     1.061     0.200
     0.982    -0.123     0.200
     1.044    -0.424     0.200
     1.087    -0.250     0.200
     1.093    -1.076     0.200
     1.132    -0.431     0.200
     1.175    -1.025     0.200
     1.175     0.577     0.200
     1.192    -1.534     0.200
     1.212    -1.310     0.200
     0.827     0.792     0.200
     0.953     0.317     0.200
     1.013     0.263     0.200
     1.124    -0.049     0.200
     1.167    -1.127     0.200
     1.185    -0.195     0.200
     1.265     0.300     0.200
     0.887     0.939     0.200
     0.974    -0.066     0.200
     1.014    -0.080     0.200
     1.070     3.131     0.200
     1.125    -0.121     0.200
     0.828     0.419     0.200
     0.839     1.809     0.200
     0.833     0.591     0.200
     0.853     0.839     0.200
     0.856     0.443     0.200
     0.893     0.877     0.200
     0.914     1.897     0.200
     0.940     0.872     0.200
     0.964    -0.191     0.200
     0.980    -0.221     0.200
     1.018    -0.316     0.200
     1.172    -1.061     0.200
     1.182    -0.400     0.200
     0.822     0.837     0.200
     0.836     0.711     0.200
     0.845     0.252     0.200
     0.850     0.440     0.200
     0.942    -0.237     0.200
     0.938     0.925     0.200
     1.016    -0.146     0.200
     1.176     0.363     0.200
     1.258     0.883     0.200
     0.824     0.201     0.200
     0.850     0.055     0.200
     0.851    -0.079     0.200
     0.878    -0.323     0.200
     0.885     0.332     0.200
     0.889    -0.463     0.200
     0.904     0.571     0.200
     0.905    -0.515     0.200
     0.915    -0.285     0.200
     0.908    -0.248     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.285     1.242     0.200
     0.343     1.062     0.200
     0.517     0.713     0.200
     0.806    -0.481     0.200
     0.218     1.014     0.200
     0.331     1.112     0.200
     0.711     0.783     0.200
     0.866     0.223     0.200
     0.982    -0.806     0.200
     1.591    -0.476     0.200
     1.577    -0.618     0.200
     0.277     0.579     0.200
     0.374     1.149     0.200
     0.454     0.867     0.200
     0.509     0.774     0.200
     0.598     0.676     0.200
     0.743     0.642     0.200
     0.670    -0.274     0.200
     1.039    -1.070     0.200
     1.374    -2.979     0.200
     1.521    -0.602     0.200
     1.992    -4.700     0.200
     2.091    -5.198     0.200
     0.167     0.830     0.200
     0.551     0.269     0.200
     0.635     0.624     0.200
     0.674     0.420     0.200
     0.743     0.397     0.200
     0.783    -0.185     0.200
     0.775     0.071     0.200
     0.838     0.283     0.200
     1.422    -3.788     0.200
     1.422    -3.376     0.200
     1.542    -0.405     0.200
     1.811    -3.950     0.200
     0.167     1.004     0.200
     0.167     0.864     0.200
     0.551     0.682     0.200
     0.673     0.465     0.200
     0.740     0.705     0.200
     0.639     0.951     0.200
     0.783    -0.157     0.200
     0.837     0.495     0.200
     0.778    -0.021     0.200
     1.418    -3.433     0.200
     1.418    -3.284     0.200
     1.545    -0.959     0.200
     1.974    -3.911     0.200
     0.292     0.894     0.200
     0.356     0.435     0.200
     0.356     0.774     0.200
     0.645     0.131     0.200
     0.714     0.138     0.200
     0.837    -0.258     0.200
     0.759     0.893     0.200
     1.503    -2.691     0.200
     1.574    -0.709     0.200
     1.929    -5.146     0.200
     2.545    -9.092     0.200
     6.908   -19.575     0.200
     0.289     1.255     0.200
     0.362     0.321     0.200
     0.639     0.400     0.200
     0.712     0.155     0.200
     0.763     0.550     0.200
     0.833    -0.446     0.200
     1.580    -0.686     0.200
     0.382     0.569     0.200
     0.411     1.278     0.200
     0.658     0.881     0.200
     0.711     0.455     0.200
     0.727     0.416     0.200
     0.704     1.332     0.200
     0.772     0.240     0.200
     1.576    -0.233     0.200
     1.941    -4.043     0.200
     2.197    -5.985     0.200
     4.302   -17.481     0.200
     0.432     1.119     0.200
     0.703     0.760     0.200
     0.698     1.086     0.200
     0.677     0.711     0.200
     0.677     1.464     0.200
     0.747     0.927     0.200
     0.806     1.149     0.200
     0.806    -0.026     0.200
     0.734     1.026     0.200
     1.371    -4.068     0.200
     0.369     0.108     0.200
     0.613     0.517     0.200
     0.648     0.268     0.200
     0.661     0.453     0.200
     0.707     0.349     0.200
     0.707     0.735     0.200
     0.726     0.561     0.200
     0.841    -0.077     0.200
     0.921    -0.223     0.200
     1.586    -0.852     0.200
     1.788    -3.280     0.200
     0.291     1.082     0.200
     0.433     0.931     0.200
     0.666     1.132     0.200
     0.114     1.530     0.200
     0.475     0.103     0.200
     0.408     0.908     0.200
     0.419     1.096     0.200
     0.458     1.451     0.200
     0.487     0.832     0.200
     0.503     0.841     0.200
     0.621     0.142     0.200
     0.726     0.729     0.200
     1.542    -1.114     0.200
     4.754   -16.065     0.200
     0.111     1.495     0.200
     0.406     1.030     0.200
     0.452     0.617     0.200
     0.421     0.703     0.200
     0.472     0.021     0.200
     0.490     0.700     0.200
     0.544     0.243     0.200
     0.627    -0.433     0.200
     0.636     0.352     0.200
     0.636     0.383     0.200
     1.008    -1.382     0.200
     1.544    -1.148     0.200
     0.219     0.993     0.200
     0.685     0.286     0.200
     0.682     0.814     0.200
     0.698     0.682     0.200
     0.744    -0.418     0.200
     0.766    -0.201     0.200
     0.780     0.133     0.200
     1.098    -1.537     0.200
     1.522    -0.457     0.200
     1.553     0.407     0.200
     1.833    -3.945     0.200
     3.271   -12.015     0.200
     0.167     1.215     0.200
     0.192     1.047     0.200
     0.532     0.492     0.200
     0.611     1.177     0.200
     0.755     0.131     0.200
     0.753    -0.127     0.200
     0.780     0.282     0.200
     0.831     0.107     0.200
     0.890    -0.307     0.200
     0.901    -0.169     0.200
     5.207   -20.449     0.200
     5.207   -20.449     0.200
     0.272     0.778     0.200
     0.449     0.398     0.200
     0.460     1.415     0.200
     0.507     0.846     0.200
     0.563     0.941     0.200
     0.563     2.214     0.200
     0.593     0.396     0.200
     0.669     0.681     0.200
     0.745    -0.259     0.200
     0.903    -0.575     0.200
     0.944    -0.673     0.200
     0.971    -0.651     0.200
     0.987    -0.777     0.200
     0.987    -1.246     0.200
     1.545    -0.905     0.200
     3.228    -9.914     0.200
     3.374   -10.587     0.200
     3.783   -11.671     0.200
     0.372     1.179     0.200
     0.376     0.663     0.200
     0.480     1.559     0.200
     0.735     0.461     0.200
     0.890     0.806     0.200
     1.250    -2.367     0.200
     1.589     0.448     0.200
     2.361    -6.021     0.200
     3.049    -5.487     0.200
     0.219     0.583     0.200
     0.583     0.667     0.200
     0.583     0.854     0.200
     0.620     0.080     0.200
     0.620     0.678     0.200
     0.659    -0.099     0.200
     0.704     1.460     0.200
     0.735     0.568     0.200
     0.319     1.232     0.200
     0.330     0.351     0.200
     0.554     0.942     0.200
     0.755    -0.125     0.200
     0.850    -0.890     0.200
     1.354    -1.843     0.200
     1.357    -0.532     0.200
     1.448    -1.102     0.200
     1.475    -0.996     0.200
     1.510    -0.978     0.200
     0.148     1.485     0.200
     0.437     0.314     0.200
     0.451     0.706     0.200
     0.446     0.897     0.200
     0.613    -0.028     0.200
     0.676     0.687     0.200
     0.754     0.894     0.200
     1.250    -3.014     0.200
     1.877    -3.600     0.200
     0.212     1.415     0.200
     0.551     0.368     0.200
     0.551     0.563     0.200
     0.556     0.864     0.200
     0.554     1.355     0.200
     0.617    -0.247     0.200
     0.737     0.451     0.200
     0.723     0.669     0.200
     1.073    -1.174     0.200
     1.517    -1.859     0.200
     0.196     0.823     0.200
     0.350     0.468     0.200
     0.619     0.857     0.200
     0.788     2.616     0.200
     0.753     0.802     0.200
     0.821     1.175     0.200
     0.893     0.649     0.200
     0.956    -0.151     0.200
     0.902    -0.088     0.200
     0.986     0.027     0.200
     1.022     0.078     0.200
     1.203    -1.436     0.200
     1.588    -0.050     0.200
     0.208     0.721     0.200
     0.338     1.228     0.200
     0.618     1.433     0.200
     0.686     1.301     0.200
     0.761     1.395     0.200
     0.777     3.212     0.200
     0.822     1.484     0.200
     0.895     0.585     0.200
     0.901     0.801     0.200
     0.901     0.964     0.200
     0.944     0.430     0.200
     0.973     0.970     0.200
     0.995     0.391     0.200
     1.020     0.393     0.200
     1.053     0.794     0.200
     1.165     0.022     0.200
     1.190    -0.775     0.200
     1.366    -0.929     0.200
     2.260    -5.246     0.200
     2.273    -4.405     0.200
     5.408   -20.402     0.200
     5.610   -11.971     0.200
     0.294     0.436     0.200
     0.543     0.914     0.200
     0.636     0.613     0.200
     0.673     0.731     0.200
     0.714     0.723     0.200
     0.721     0.397     0.200
     0.721     0.303     0.200
     0.721     0.432     0.200
     0.711     0.797     0.200
     0.763     0.075     0.200
     0.870     0.092     0.200
     1.594    -0.873     0.200
     1.590    -1.007     0.200
     1.590    -0.035     0.200
     2.902    -5.083     0.200
     0.202     1.039     0.200
     0.202     1.312     0.200
     0.249     2.530     0.200
     0.584     0.603     0.200
     0.584     0.502     0.200
     0.634     0.631     0.200
     0.633     0.680     0.200
     0.633    -0.570     0.200
     0.652    -0.654     0.200
     0.721     0.728     0.200
     1.097    -1.639     0.200
     1.979    -5.387     0.200
     0.213     0.825     0.200
     0.242     2.878     0.200
     0.592     0.559     0.200
     0.634     1.176     0.200
     0.621     0.429     0.200
     0.646     0.324     0.200
     0.733     0.657     0.200
     1.535    -1.540     0.200
     0.215     0.723     0.200
     0.215     1.395     0.200
     0.247     2.941     0.200
     0.595     0.615     0.200
     0.608     0.781     0.200
     0.621     0.149     0.200
     0.629     1.001     0.200
     0.650    -0.046     0.200
     0.733     0.931     0.200
     0.591     0.857     0.200
     0.729     1.031     0.200
     1.980    -3.706     0.200
     1.981    -4.262     0.200
     8.006   -27.073     0.200
     0.233     2.606     0.200
     0.579     0.628     0.200
     0.591     0.945     0.200
     0.636     1.451     0.200
     0.628     0.048     0.200
     0.724     0.413     0.200
     1.094    -1.392     0.200
     1.539    -1.696     0.200
     2.336    -6.534     0.200
     2.508    -7.456     0.200
     0.158     1.496     0.200
     0.231     2.934     0.200
     0.215     2.788     0.200
     0.246     2.449     0.200
     0.533     0.924     0.200
     0.626    -0.071     0.200
     0.668     0.005     0.200
     0.681     0.931     0.200
     0.683     1.057     0.200
     1.585    -1.306     0.200
     0.212     1.234     0.200
     0.212     1.039     0.200
     0.594     0.240     0.200
     0.624     0.620     0.200
     0.628     1.502     0.200
     0.653    -0.174     0.200
     0.698    -0.184     0.200
     0.731     1.084     0.200
     1.299    -2.652     0.200
     2.490    -5.090     0.200
     2.484    -4.850     0.200
     3.325   -12.984     0.200
     0.233     0.099     0.200
     0.610    -0.534     0.200
     0.608     1.032     0.200
     0.616     0.804     0.200
     0.616     0.359     0.200
     0.629     1.183     0.200
     0.666     0.145     0.200
     0.709     0.324     0.200
     0.748     1.015     0.200
     2.306    -5.951     0.200
     2.467    -7.243     0.200
     6.857   -27.205     0.200
     0.168     1.410     0.200
     0.536     0.955     0.200
     0.611     0.446     0.200
     0.657    -0.098     0.200
     0.657    -0.637     0.200
     0.694     0.487     0.200
     2.375    -4.798     0.200
     2.463    -5.360     0.200
     2.554    -5.204     0.200
     3.540   -10.453     0.200
     3.756   -14.512     0.200
     0.228     1.571     0.200
     0.228     0.384     0.200
     0.250     2.788     0.200
     0.609     0.896     0.200
     0.621     1.628     0.200
     0.655    -0.191     0.200
     0.610     0.816     0.200
     0.610     0.089     0.200
     0.619     0.978     0.200
     0.746     0.813     0.200
     1.989    -4.987     0.200
     0.247     2.758     0.200
     0.613     0.677     0.200
     0.613    -0.250     0.200
     0.620     1.135     0.200
     0.625     0.999     0.200
     0.603    -0.455     0.200
     0.651    -0.170     0.200
     0.752     0.364     0.200
     0.694     0.637     0.200
     1.520    -2.823     0.200
     0.194     1.642     0.200
     0.285     2.150     0.200
     0.573     1.094     0.200
     0.573     0.578     0.200
     0.586     1.161     0.200
     0.643    -0.370     0.200
     0.638     0.586     0.200
     0.646     1.000     0.200
     0.714     0.660     0.200
     1.968    -5.742     0.200
     0.189     1.247     0.200
     0.571     0.956     0.200
     0.571     0.725     0.200
     0.584     1.067     0.200
     0.645    -1.017     0.200
     0.645    -0.378     0.200
     0.650     0.125     0.200
     0.642     1.173     0.200
     0.708     1.173     0.200
     1.558    -2.272     0.200
     1.973    -3.690     0.200
     2.511    -8.515     0.200
     0.153     1.595     0.200
     0.153     1.373     0.200
     0.409     0.332     0.200
     0.444     0.164     0.200
     0.449     0.582     0.200
     0.459     0.374     0.200
     0.529     0.266     0.200
     0.602    -0.045     0.200
     0.594     0.158     0.200
     0.656    -0.109     0.200
     0.672    -0.017     0.200
     0.761     0.131     0.200
     0.761    -0.210     0.200
     1.501    -1.240     0.200
     1.790    -4.182     0.200
     1.796    -4.461     0.200
     1.871    -4.590     0.200
     2.099    -4.653     0.200
     0.469     0.814     0.200
     0.471     0.711     0.200
     0.515     0.914     0.200
     0.761     0.746     0.200
     0.847     1.292     0.200
     1.035     0.281     0.200
     1.056     0.031     0.200
     1.291    -1.057     0.200
     0.178     1.197     0.200
     0.178     1.533     0.200
     0.384     0.059     0.200
     0.384     0.489     0.200
     0.366     0.734     0.200
     0.420     2.656     0.200
     0.475     0.470     0.200
     0.475     0.923     0.200
     0.635    -0.066     0.200
     0.637     0.133     0.200
     0.725     0.158     0.200
     0.725     0.471     0.200
     0.766     0.581     0.200
     0.766     1.956     0.200
     0.936    -0.890     0.200
     1.198    -1.908     0.200
     1.929    -3.982     0.200
     1.994    -3.618     0.200
     2.142    -4.563     0.200
     2.757    -9.299     0.200
     5.267   -15.617     0.200
     0.091     1.249     0.200
     0.091     1.657     0.200
     0.096     1.664     0.200
     0.612     0.676     0.200
     0.623     0.237     0.200
     0.799    -0.406     0.200
     0.822    -0.895     0.200
     0.851    -0.853     0.200
     1.469    -3.070     0.200
     1.432    -0.647     0.200
     1.571    -1.631     0.200
     1.821    -4.659     0.200
     0.111     1.224     0.200
     0.607     0.139     0.200
     0.623     1.032     0.200
     0.630     0.300     0.200
     0.782     0.339     0.200
     0.815    -0.107     0.200
     1.439    -3.692     0.200
     1.634    -4.100     0.200
     1.825    -3.784     0.200
     0.323     0.619     0.200
     0.451     0.473     0.200
     0.663    -0.802     0.200
     0.714     0.301     0.200
     0.769     0.888     0.200
     0.442     0.662     0.200
     0.703     0.446     0.200
     0.692     2.055     0.200
     0.684     3.473     0.200
     0.747     3.333     0.200
     1.003     0.445     0.200
     0.323     0.460     0.200
     0.443     0.951     0.200
     0.709    -0.029     0.200
     0.708     0.671     0.200
     0.734     1.529     0.200
     0.742     0.987     0.200
     0.778     1.251     0.200
     0.868    -0.622     0.200
     0.815     1.281     0.200
     1.639    -3.402     0.200
     4.195   -14.780     0.200
     0.265     0.979     0.200
     0.460     0.546     0.200
     0.641     0.398     0.200
     0.711    -0.324     0.200
     0.739     0.288     0.200
     0.717     0.804     0.200
     0.757    -0.445     0.200
     0.724     0.502     0.200
     0.947    -0.846     0.200
     1.552    -0.555     0.200
     1.600    -0.264     0.200
     1.847    -4.427     0.200
     0.096     2.225     0.200
     0.127     1.823     0.200
     0.196     1.504     0.200
     0.268     1.485     0.200
     0.268     1.613     0.200
     0.292     0.429     0.200
     0.254     1.915     0.200
     0.315     0.748     0.200
     0.317     1.556     0.200
     0.331     1.059     0.200
     0.331     1.229     0.200
     0.363     0.881     0.200
     0.378     1.073     0.200
     0.399     0.785     0.200
     0.409     0.592     0.200
     0.376     1.039     0.200
     0.400     1.292     0.200
     0.390     1.529     0.200
     0.399     1.880     0.200
     0.443     0.394     0.200
     0.460     1.034     0.200
     0.478    -0.238     0.200
     0.481    -0.576     0.200
     0.461     1.013     0.200
     0.499     0.552     0.200
     0.529    -0.525     0.200
     0.520     0.926     0.200
     0.562     0.168     0.200
     0.611     1.356     0.200
     0.665     0.307     0.200
     0.680    -0.040     0.200
     0.714    -0.373     0.200
     0.716    -0.463     0.200
     0.708     0.420     0.200
     0.776    -0.323     0.200
     0.742     0.792     0.200
     0.804    -0.692     0.200
     0.918    -0.901     0.200
     1.502    -1.997     0.200
     1.569    -0.688     0.200
     1.954    -6.351     0.200
     0.291     1.208     0.200
     0.481     0.525     0.200
     0.481     1.518     0.200
     0.549     1.142     0.200
     0.579     0.774     0.200
     0.676     0.039     0.200
     0.682     1.044     0.200
     0.705     1.498     0.200
     0.741     0.832     0.200
     0.821     1.488     0.200
     0.821     0.785     0.200
     1.040    -0.752     0.200
     1.589     0.169     0.200
     0.074     0.649     0.200
     0.279     1.742     0.200
     0.287     1.278     0.200
     0.327     0.621     0.200
     0.397     0.883     0.200
     0.404     0.402     0.200
     0.451     0.840     0.200
     0.454     1.714     0.200
     0.477     0.500     0.200
     0.479     0.435     0.200
     0.555     0.893     0.200
     0.555     1.160     0.200
     0.596     0.705     0.200
     0.615     0.828     0.200
     0.618     1.108     0.200
     0.646     0.562     0.200
     0.652     1.597     0.200
     0.688     0.612     0.200
     0.693     0.708     0.200
     0.736     0.539     0.200
     0.770     0.434     0.200
     0.770     0.681     0.200
     0.761     1.010     0.200
     0.782     0.897     0.200
     0.808     0.793     0.200
     0.840     0.528     0.200
     0.862     0.348     0.200
     0.894     0.799     0.200
     0.899     0.202     0.200
     0.902     0.565     0.200
     0.929     0.798     0.200
     0.940     0.291     0.200
     1.004    -0.117     0.200
     1.004     0.353     0.200
     0.267     1.951     0.200
     0.277     1.444     0.200
     0.312     1.306     0.200
     0.331     1.124     0.200
     0.391     0.832     0.200
     0.395     0.819     0.200
     0.453     1.599     0.200
     0.459     0.960     0.200
     0.468     0.847     0.200
     0.469     0.920     0.200
     0.551     1.450     0.200
     0.589     0.791     0.200
     0.606     0.998     0.200
     0.610     1.207     0.200
     0.636     0.811     0.200
     0.636     0.968     0.200
     0.640     2.234     0.200
     0.679     0.967     0.200
     0.685     0.767     0.200
     0.725     1.037     0.200
     0.749     1.675     0.200
     0.775     0.625     0.200
     0.775     0.781     0.200
     0.776     0.736     0.200
     0.787     1.614     0.200
     0.811     1.320     0.200
     0.821     2.592     0.200
     0.835     0.512     0.200
     0.856     0.362     0.200
     0.883     1.051     0.200
     0.893     0.307     0.200
     0.893     0.782     0.200
     0.938     0.648     0.200
     0.992    -0.056     0.200
     1.019     0.227     0.200
     0.254     0.810     0.200
     0.516     1.119     0.200
     0.641     0.480     0.200
     0.701     0.651     0.200
     0.703     0.430     0.200
     0.703    -0.150     0.200
     0.773     0.799     0.200
     0.311     1.406     0.200
     0.265     0.518     0.200
     0.629     0.554     0.200
     0.615    -0.047     0.200
     0.792     0.558     0.200
     0.836    -0.052     0.200
     1.172    -2.020     0.200
     0.296     1.636     0.200
     0.351     0.639     0.200
     0.356     1.052     0.200
     0.442     0.726     0.200
     0.509     0.264     0.200
     0.687     0.424     0.200
     1.468    -0.878     0.200
     0.137     2.008     0.200
     0.137     1.877     0.200
     0.178     1.320     0.200
     0.174     2.105     0.200
     0.166     1.574     0.200
     0.167     1.623     0.200
     0.188     1.654     0.200
     0.195     2.126     0.200
     0.296     1.078     0.200
     0.269     1.188     0.200
     0.300     1.349     0.200
     0.300     1.240     0.200
     0.292     0.935     0.200
     0.357     1.104     0.200
     0.421     1.440     0.200
     0.437     1.393     0.200
     0.464     0.739     0.200
     0.496     1.070     0.200
     0.511     0.569     0.200
     0.502     1.214     0.200
     0.522     0.538     0.200
     0.551     0.536     0.200
     0.551     0.772     0.200
     0.533     0.710     0.200
     0.535     0.368     0.200
     0.607    -0.044     0.200
     0.618     2.298     0.200
     0.644     0.054     0.200
     0.644    -0.116     0.200
     0.625     0.846     0.200
     0.642     0.359     0.200
     0.642     0.599     0.200
     0.650     0.835     0.200
     0.670     0.602     0.200
     0.670     1.252     0.200
     0.727     0.404     0.200
     0.716     0.826     0.200
     0.715    -0.013     0.200
     0.738     0.237     0.200
     0.785     0.003     0.200
     0.781    -0.219     0.200
     0.781    -0.225     0.200
     0.819    -0.564     0.200
     0.841    -0.200     0.200
     0.883    -0.428     0.200
     0.927    -0.914     0.200
     1.498     0.504     0.200
     1.563    -0.640     0.200
     0.061     3.434     0.200
     0.175     2.424     0.200
     0.207     2.994     0.200
     0.184     1.459     0.200
     0.203     1.508     0.200
     0.250     2.319     0.200
     0.364     2.076     0.200
     0.435     0.556     0.200
     0.550     0.211     0.200
     0.640    -0.114     0.200
     0.685     0.851     0.200
     0.710     0.597     0.200
     0.710     0.737     0.200
     0.151     3.026     0.200
     0.171     2.533     0.200
     0.212     1.451     0.200
     0.230     2.135     0.200
     0.234     1.957     0.200
     0.295     1.254     0.200
     0.317     0.816     0.200
     0.357     1.764     0.200
     0.364     2.051     0.200
     0.423     0.488     0.200
     0.551     0.945     0.200
     0.549     0.393     0.200
     0.549     0.542     0.200
     0.554     0.571     0.200
     0.568     2.812     0.200
     0.618    -0.111     0.200
     0.618     0.874     0.200
     0.736     0.393     0.200
     0.728     0.554     0.200
     0.113     2.080     0.200
     0.164     2.727     0.200
     0.178     2.028     0.200
     0.181     1.651     0.200
     0.185     2.494     0.200
     0.201     1.925     0.200
     0.310     1.022     0.200
     0.312     2.873     0.200
     0.335     1.117     0.200
     0.335     1.067     0.200
     0.369     2.033     0.200
     0.419     1.157     0.200
     0.419     0.970     0.200
     0.426     2.573     0.200
     0.439     1.539     0.200
     0.469     2.822     0.200
     0.552     1.229     0.200
     0.552     0.964     0.200
     0.553     2.259     0.200
     0.625     1.467     0.200
     0.667     1.994     0.200
     0.667     0.822     0.200
     0.667     0.731     0.200
     0.696     1.616     0.200
     0.706     2.224     0.200
     0.719    -0.575     0.200
     0.723     1.387     0.200
     0.744     0.864     0.200
     0.744     0.559     0.200
     0.757     0.665     0.200
     0.798    -0.134     0.200
     0.798     0.389     0.200
     2.334    -6.063     0.200
     0.299     2.261     0.200
     0.361     0.775     0.200
     0.367     0.505     0.200
     0.367     0.399     0.200
     0.432     2.306     0.200
     0.385     1.717     0.200
     0.406     1.819     0.200
     0.458     2.164     0.200
     0.406     2.356     0.200
     0.417     1.274     0.200
     0.417     0.821     0.200
     0.451     1.805     0.200
     0.511     2.290     0.200
     0.549     1.985     0.200
     0.558     3.285     0.200
     0.573     2.018     0.200
     0.658     0.871     0.200
     0.678     0.492     0.200
     0.679     2.005     0.200
     0.635     0.655     0.200
     0.674     1.178     0.200
     0.677     1.002     0.200
     0.719     0.788     0.200
     0.712     0.689     0.200
     0.712     0.518     0.200
     0.729     0.071     0.200
     0.762     1.259     0.200
     0.724     1.466     0.200
     0.724     1.657     0.200
     0.759     1.062     0.200
     0.749     0.742     0.200
     0.749     1.215     0.200
     0.773     0.652     0.200
     0.803    -0.923     0.200
     0.803     0.010     0.200
     0.773     1.432     0.200
     0.792     1.750     0.200
     0.801     1.249     0.200
     1.596     0.547     0.200
     1.656    -3.760     0.200
     0.292     2.522     0.200
     0.360     0.442     0.200
     0.392     1.679     0.200
     0.413     1.857     0.200
     0.423     0.743     0.200
     0.412     2.532     0.200
     0.450     2.326     0.200
     0.458     1.292     0.200
     0.449     1.472     0.200
     0.505     2.492     0.200
     0.541     1.586     0.200
     0.551     2.923     0.200
     0.651     0.642     0.200
     0.639     0.603     0.200
     0.674     1.915     0.200
     0.671     0.573     0.200
     0.673     2.206     0.200
     0.677     1.136     0.200
     0.680     1.087     0.200
     0.707     0.784     0.200
     0.707     0.503     0.200
     0.722     0.485     0.200
     0.722     0.916     0.200
     0.731     1.419     0.200
     0.731     1.286     0.200
     0.755     1.238     0.200
     0.757     1.648     0.200
     0.751     2.069     0.200
     0.751     1.199     0.200
     0.772     1.012     0.200
     0.801     0.647     0.200
     0.776     2.123     0.200
     1.660    -3.384     0.200
     0.214     2.360     0.200
     0.227     2.066     0.200
     0.373    -0.314     0.200
     0.386     1.615     0.200
     0.400     1.647     0.200
     0.406     1.195     0.200
     0.406     0.919     0.200
     0.411     2.212     0.200
     0.465     1.986     0.200
     0.474     0.870     0.200
     0.552     1.980     0.200
     0.555     3.096     0.200
     0.588     0.693     0.200
     0.645     0.594     0.200
     0.662     1.042     0.200
     0.685     0.823     0.200
     0.681     1.034     0.200
     0.685     0.976     0.200
     0.688     0.855     0.200
     0.688     1.067     0.200
     0.708    -0.231     0.200
     0.725     1.243     0.200
     0.725     1.098     0.200
     0.725     1.210     0.200
     0.738     0.151     0.200
     0.738     0.692     0.200
     0.762     1.538     0.200
     0.771     1.330     0.200
     0.773     1.704     0.200
     0.787     0.827     0.200
     0.791    -0.197     0.200
     0.791     0.805     0.200
     0.786     1.454     0.200
     0.805     1.723     0.200
     0.814     1.128     0.200
     1.597     0.973     0.200
     0.198     2.594     0.200
     0.208     1.400     0.200
     0.294     2.299     0.200
     0.391     1.188     0.200
     0.410     1.795     0.200
     0.425     0.787     0.200
     0.425     0.675     0.200
     0.426     3.051     0.200
     0.450     2.109     0.200
     0.446     1.979     0.200
     0.457     1.064     0.200
     0.507     2.304     0.200
     0.542     2.029     0.200
     0.553     3.080     0.200
     0.570     0.800     0.200
     0.636     0.257     0.200
     0.651     0.365     0.200
     0.677     1.880     0.200
     0.671     0.343     0.200
     0.674     0.944     0.200
     0.677     1.013     0.200
     0.677     0.578     0.200
     0.677     0.759     0.200
     0.705     0.642     0.200
     0.721     0.337     0.200
     0.730     0.989     0.200
     0.748     0.853     0.200
     0.748     0.973     0.200
     0.754     0.895     0.200
     0.753     1.004     0.200
     0.769     0.874     0.200
     0.773     1.605     0.200
     0.791     1.499     0.200
     0.804    -0.501     0.200
     0.804    -0.395     0.200
     0.800     1.113     0.200
     0.199     2.634     0.200
     0.209     1.494     0.200
     0.295     2.751     0.200
     0.390     1.181     0.200
     0.412     0.964     0.200
     0.409     1.791     0.200
     0.424     0.567     0.200
     0.424     0.687     0.200
     0.452     2.182     0.200
     0.446     2.148     0.200
     0.459     1.144     0.200
     0.543     1.762     0.200
     0.554     3.263     0.200
     0.570     1.215     0.200
     0.636     0.407     0.200
     0.672     0.294     0.200
     0.677     1.357     0.200
     0.674     1.290     0.200
     0.677     1.375     0.200
     0.677     0.664     0.200
     0.677     0.835     0.200
     0.677     1.026     0.200
     0.706     0.649     0.200
     0.706     0.913     0.200
     0.722     0.448     0.200
     0.729     0.972     0.200
     0.729     0.682     0.200
     0.748     1.240     0.200
     0.748     1.500     0.200
     0.755     1.146     0.200
     0.754     1.101     0.200
     0.773     1.626     0.200
     0.791     1.390     0.200
     0.804    -0.749     0.200
     0.804    -0.022     0.200
     0.800     1.259     0.200
     0.151     2.390     0.200
     0.303     0.764     0.200
     0.303     0.135     0.200
     0.307     1.206     0.200
     0.350     1.925     0.200
     0.347     2.405     0.200
     0.358     2.230     0.200
     0.401     2.852     0.200
     0.441     1.494     0.200
     0.446     2.177     0.200
     0.477     1.079     0.200
     0.507     1.796     0.200
     0.519     1.135     0.200
     0.551     0.638     0.200
     0.542     1.175     0.200
     0.556     0.369     0.200
     0.560     1.838     0.200
     0.569     2.397     0.200
     0.574     1.843     0.200
     0.610     0.558     0.200
     0.652    -0.222     0.200
     0.676     1.451     0.200
     0.695     1.054     0.200
     0.695     0.429     0.200
     0.701     1.221     0.200
     0.762     0.963     0.200
     0.762     0.662     0.200
     0.805     0.029     0.200
     0.058     2.758     0.200
     0.158     2.545     0.200
     0.197     2.316     0.200
     0.201     3.184     0.200
     0.208     1.137     0.200
     0.208     1.457     0.200
     0.260     2.820     0.200
     0.364     2.435     0.200
     0.363     0.683     0.200
     0.360     1.230     0.200
     0.384     1.815     0.200
     0.456     0.574     0.200
     0.465     1.759     0.200
     0.487     0.673     0.200
     0.572     0.909     0.200
     0.581     1.044     0.200
     0.617    -0.323     0.200
     0.617     0.130     0.200
     0.617    -0.026     0.200
     0.621     1.816     0.200
     0.675     1.536     0.200
     0.675     0.958     0.200
     0.734     0.328     0.200
     0.734     0.578     0.200
     0.740     0.740     0.200
     0.761     1.223     0.200
     0.776     0.836     0.200
     0.056     3.193     0.200
     0.161     2.577     0.200
     0.196     2.436     0.200
     0.206     1.157     0.200
     0.206     1.329     0.200
     0.257     3.118     0.200
     0.359     1.394     0.200
     0.366     2.215     0.200
     0.386     2.602     0.200
     0.387     2.154     0.200
     0.456     0.510     0.200
     0.463     2.104     0.200
     0.489     0.711     0.200
     0.542     1.703     0.200
     0.572     0.353     0.200
     0.572     0.626     0.200
     0.581     0.503     0.200
     0.606     1.583     0.200
     0.606     1.865     0.200
     0.618     0.066     0.200
     0.618     0.167     0.200
     0.619     1.774     0.200
     0.673     1.366     0.200
     0.732     0.689     0.200
     0.732     0.845     0.200
     0.732     0.986     0.200
     0.724     1.414     0.200
     0.738     1.114     0.200
     0.759     1.874     0.200
     0.773     0.850     0.200
     0.979    -0.929     0.200
     0.179     1.557     0.200
     0.293     2.021     0.200
     0.309     0.976     0.200
     0.345     0.746     0.200
     0.364     1.283     0.200
     0.365     0.843     0.200
     0.365     0.710     0.200
     0.412     2.668     0.200
     0.412     1.406     0.200
     0.471     0.515     0.200
     0.471     0.414     0.200
     0.477     2.049     0.200
     0.456     1.011     0.200
     0.488     0.553     0.200
     0.503     0.767     0.200
     0.487    -0.210     0.200
     0.498     0.466     0.200
     0.534     2.976     0.200
     0.501     0.514     0.200
     0.553     1.986     0.200
     0.526     0.767     0.200
     0.526     0.877     0.200
     0.576     0.854     0.200
     0.596     0.497     0.200
     0.562     1.356     0.200
     0.605     0.024     0.200
     0.572     0.682     0.200
     0.583     1.228     0.200
     0.641     1.737     0.200
     0.644     0.873     0.200
     0.644     1.162     0.200
     0.658     0.570     0.200
     0.672     0.513     0.200
     0.689     1.026     0.200
     0.756    -0.290     0.200
     0.769    -0.570     0.200
     0.755     0.943     0.200
     0.756     0.733     0.200
     0.795     1.391     0.200
     0.822    -0.669     0.200
     0.818     0.128     0.200
     0.882    -0.333     0.200
     0.853     0.060     0.200
     0.906    -0.539     0.200
     0.955    -0.630     0.200
     1.043    -1.335     0.200
     1.043    -1.206     0.200
     1.569    -0.201     0.200
     0.144     0.897     0.200
     0.244    -0.225     0.200
     0.244     1.314     0.200
     0.245     1.126     0.200
     0.276     2.572     0.200
     0.316     2.565     0.200
     0.358     2.385     0.200
     0.374     0.717     0.200
     0.492     2.943     0.200
     0.515     0.947     0.200
     0.523     0.852     0.200
     0.523     0.742     0.200
     0.545     2.448     0.200
     0.547     1.957     0.200
     0.544     1.591     0.200
     0.557     0.972     0.200
     0.562     2.753     0.200
     0.560     1.935     0.200
     0.632     0.824     0.200
     0.636     0.835     0.200
     0.657     1.717     0.200
     0.689     0.885     0.200
     0.713     1.316     0.200
     0.715     0.236     0.200
     0.765     0.673     0.200
     0.784     0.713     0.200
     0.796     1.356     0.200
     0.799     0.613     0.200
     0.849    -0.293     0.200
     0.880    -0.279     0.200
     0.121     2.204     0.200
     0.125     1.101     0.200
     0.142     2.010     0.200
     0.197     1.300     0.200
     0.197     1.110     0.200
     0.269     1.080     0.200
     0.269     0.760     0.200
     0.269     1.890     0.200
     0.269     2.010     0.200
     0.351     1.038     0.200
     0.367     0.956     0.200
     0.372     1.582     0.200
     0.403     0.762     0.200
     0.403     1.042     0.200
     0.414     0.829     0.200
     0.408     1.314     0.200
     0.427     1.435     0.200
     0.453     0.446     0.200
     0.454     0.639     0.200
     0.459     0.949     0.200
     0.501     0.161     0.200
     0.501    -0.178     0.200
     0.501     0.651     0.200
     0.510     0.383     0.200
     0.498    -0.047     0.200
     0.557     1.724     0.200
     0.569     0.264     0.200
     0.569     0.554     0.200
     0.590     0.760     0.200
     0.596    -0.114     0.200
     0.596     0.097     0.200
     0.586     0.309     0.200
     0.595    -0.069     0.200
     0.585     0.366     0.200
     0.585     0.438     0.200
     0.600     0.124     0.200
     0.613     0.396     0.200
     0.613     0.696     0.200
     0.624     0.317     0.200
     0.650     1.891     0.200
     0.650     1.721     0.200
     0.647     0.900     0.200
     0.643     0.154     0.200
     0.663    -0.164     0.200
     0.663     0.176     0.200
     0.663     0.366     0.200
     0.663     0.440     0.200
     0.659     0.325     0.200
     0.694    -0.386     0.200
     0.694    -0.143     0.200
     0.705     1.236     0.200
     0.701     0.066     0.200
     0.739    -0.032     0.200
     0.747     1.204     0.200
     0.741     0.356     0.200
     0.741     0.525     0.200
     1.459    -7.306     0.200
     1.498    -0.899     0.200
     2.550    -9.135     0.200
     0.074     2.795     0.200
     0.100     3.115     0.200
     0.125     1.726     0.200
     0.126     1.701     0.200
     0.121     2.859     0.200
     0.128     2.249     0.200
     0.240     0.618     0.200
     0.199     1.890     0.200
     0.219     1.611     0.200
     0.315     1.056     0.200
     0.372     1.196     0.200
     0.419     0.607     0.200
     0.391     1.224     0.200
     0.443     1.104     0.200
     0.453     1.045     0.200
     0.455     0.682     0.200
     0.461     0.696     0.200
     0.566     0.657     0.200
     0.606     0.079     0.200
     0.583     0.688     0.200
     0.579     0.560     0.200
     0.577     1.396     0.200
     0.663    -0.108     0.200
     0.663    -0.040     0.200
     0.669     0.744     0.200
     0.761     0.072     0.200
     0.782    -0.470     0.200
     0.782    -0.705     0.200
     0.812    -0.768     0.200
     0.812    -0.362     0.200
     0.812    -0.591     0.200
     0.823    -0.706     0.200
     0.838    -0.819     0.200
     0.881    -0.663     0.200
     1.501     1.098     0.200
     1.592    -0.870     0.200
     1.780    -4.459     0.200
     0.072     2.320     0.200
     0.159     1.465     0.200
     0.211     1.979     0.200
     0.275     0.681     0.200
     0.283     1.230     0.200
     0.283     1.115     0.200
     0.327     0.654     0.200
     0.327     0.508     0.200
     0.384     1.064     0.200
     0.383     0.726     0.200
     0.375     0.818     0.200
     0.448     1.084     0.200
     0.434     1.274     0.200
     0.438     0.744     0.200
     0.483     0.757     0.200
     0.493     0.565     0.200
     0.513     0.811     0.200
     0.610     0.270     0.200
     0.549     0.538     0.200
     0.603     0.159     0.200
     0.601     0.921     0.200
     0.654     0.546     0.200
     0.630     0.365     0.200
     0.698     1.423     0.200
     0.670     0.066     0.200
     0.663     1.331     0.200
     0.669     1.355     0.200
     0.727     0.916     0.200
     0.744     1.580     0.200
     0.721     0.605     0.200
     0.696     1.028     0.200
     0.772     0.236     0.200
     0.772     0.850     0.200
     0.767     0.554     0.200
     0.769     0.950     0.200
     0.792     0.096     0.200
     0.867    -0.263     0.200
     0.835     0.053     0.200
     0.876     0.031     0.200
     0.957    -0.541     0.200
     1.067    -1.280     0.200
     1.548     0.251     0.200
     0.156     1.472     0.200
     0.256     1.183     0.200
     0.259     1.217     0.200
     0.266     0.983     0.200
     0.284     1.984     0.200
     0.274     1.372     0.200
     0.308     1.658     0.200
     0.324     1.207     0.200
     0.329     1.761     0.200
     0.348     0.996     0.200
     0.370     1.425     0.200
     0.397     0.796     0.200
     0.406     0.896     0.200
     0.419     0.655     0.200
     0.458     1.061     0.200
     0.477     1.994     0.200
     0.483     2.465     0.200
     0.473     1.040     0.200
     0.507     0.599     0.200
     0.573     1.093     0.200
     0.557     1.300     0.200
     0.610     0.509     0.200
     0.610     0.711     0.200
     0.592     1.337     0.200
     0.637     0.515     0.200
     0.599     0.425     0.200
     0.659     2.283     0.200
     0.648     0.124     0.200
     0.659     0.448     0.200
     0.665    -0.193     0.200
     0.658     0.334     0.200
     0.677    -0.140     0.200
     0.669     0.234     0.200
     0.696     1.610     0.200
     0.682     0.673     0.200
     0.774    -0.314     0.200
     0.814    -0.406     0.200
     0.841    -0.558     0.200
     0.841    -0.632     0.200
     0.847    -0.569     0.200
     1.436    -2.275     0.200
     1.489    -0.542     0.200
     1.591    -0.135     0.200
     0.157     0.222     0.200
     0.225     2.012     0.200
     0.347     2.587     0.200
     0.411     0.447     0.200
     0.458     2.592     0.200
     0.436     0.676     0.200
     0.436     0.575     0.200
     0.478     3.308     0.200
     0.447     1.093     0.200
     0.460     0.996     0.200
     0.473     0.937     0.200
     0.590     2.020     0.200
     0.596     2.237     0.200
     0.691     0.944     0.200
     0.705     1.831     0.200
     0.715     0.258     0.200
     0.715     0.418     0.200
     0.697     0.272     0.200
     0.708     0.571     0.200
     0.731     0.378     0.200
     0.843     0.030     0.200
     0.853     0.476     0.200
     0.871     0.609     0.200
     0.925    -0.320     0.200
     0.912    -0.252     0.200
     0.956    -0.288     0.200
     2.112    -5.391     0.200
     0.154     1.522     0.200
     0.211     1.839     0.200
     0.282     1.061     0.200
     0.282     1.210     0.200
     0.332     0.698     0.200
     0.332     0.534     0.200
     0.370     0.888     0.200
     0.387     0.513     0.200
     0.387     1.220     0.200
     0.439     1.252     0.200
     0.443     0.955     0.200
     0.450     0.965     0.200
     0.487     0.340     0.200
     0.497     0.486     0.200
     0.518     0.620     0.200
     0.545     1.406     0.200
     0.552     0.719     0.200
     0.611     0.427     0.200
     0.598     1.099     0.200
     0.605     0.398     0.200
     0.633     0.397     0.200
     0.659     0.314     0.200
     0.663     1.658     0.200
     0.668     0.687     0.200
     0.673     0.326     0.200
     0.696     0.622     0.200
     0.702     1.231     0.200
     0.725     0.552     0.200
     0.732     1.043     0.200
     0.747     1.908     0.200
     0.768     0.960     0.200
     0.772     0.575     0.200
     0.774     1.454     0.200
     0.774     0.634     0.200
     0.794    -0.025     0.200
     0.794     0.233     0.200
     0.835     0.124     0.200
     0.876     0.045     0.200
     1.071    -1.011     0.200
     1.538    -1.500     0.200
     1.543    -0.027     0.200
     0.055     1.541     0.200
     0.105     2.199     0.200
     0.149     3.083     0.200
     0.225    -0.177     0.200
     0.286     2.421     0.200
     0.319     2.388     0.200
     0.323     2.195     0.200
     0.364     1.422     0.200
     0.376     2.212     0.200
     0.483     0.683     0.200
     0.506     2.484     0.200
     0.514     1.775     0.200
     0.534     0.758     0.200
     0.549     0.568     0.200
     0.549     0.443     0.200
     0.583     0.164     0.200
     0.578     1.319     0.200
     0.579     1.086     0.200
     0.617     0.875     0.200
     0.639     1.324     0.200
     0.662     0.524     0.200
     0.678     1.310     0.200
     0.691    -0.356     0.200
     0.694     0.924     0.200
     0.765     0.314     0.200
     0.199     0.231     0.200
     0.224     1.263     0.200
     0.227     0.833     0.200
     0.231     1.129     0.200
     0.276     0.771     0.200
     0.313     1.040     0.200
     0.330     1.199     0.200
     0.402     0.378     0.200
     0.417    -0.287     0.200
     0.437     0.918     0.200
     0.460     1.676     0.200
     0.465     1.546     0.200
     0.481     1.051     0.200
     0.501     0.820     0.200
     0.508     0.885     0.200
     0.527     1.337     0.200
     0.558     1.381     0.200
     0.580     0.784     0.200
     0.585     0.321     0.200
     0.608     1.544     0.200
     0.626     1.112     0.200
     0.648     1.272     0.200
     0.673     0.384     0.200
     0.677     0.924     0.200
     0.670     1.341     0.200
     0.689     0.908     0.200
     0.700     0.150     0.200
     0.726     0.395     0.200
     0.733     1.003     0.200
     0.733     1.291     0.200
     0.723     1.434     0.200
     0.730     1.026     0.200
     0.735     1.256     0.200
     0.801     0.259     0.200
     0.791     0.993     0.200
     0.805     0.887     0.200
     0.808     0.952     0.200
     0.827     0.201     0.200
     0.865     0.241     0.200
     0.866     0.411     0.200
     0.872     0.043     0.200
     1.122    -0.406     0.200
     2.571    -6.345     0.200
     3.005    -9.745     0.200
     3.531   -12.352     0.200
     0.136     1.580     0.200
     0.154     0.926     0.200
     0.176     0.759     0.200
     0.176     0.966     0.200
     0.280     1.840     0.200
     0.280     1.641     0.200
     0.257     1.935     0.200
     0.278     2.086     0.200
     0.340     2.389     0.200
     0.340     2.186     0.200
     0.387     1.037     0.200
     0.387     1.267     0.200
     0.385     0.728     0.200
     0.385     0.615     0.200
     0.378     0.724     0.200
     0.378     0.625     0.200
     0.342     2.549     0.200
     0.357     2.873     0.200
     0.380     2.848     0.200
     0.425     1.859     0.200
     0.435     0.718     0.200
     0.405     1.565     0.200
     0.515     0.759     0.200
     0.505     3.241     0.200
     0.546     2.539     0.200
     0.580     0.910     0.200
     0.593     1.350     0.200
     0.601     2.426     0.200
     0.669     0.032     0.200
     0.638     2.252     0.200
     0.631     1.109     0.200
     0.690     0.160     0.200
     0.661     0.680     0.200
     0.697     0.632     0.200
     0.697     0.324     0.200
     0.732    -0.121     0.200
     0.732    -0.223     0.200
     0.705     0.207     0.200
     0.704     0.080     0.200
     0.708     0.123     0.200
     0.708     0.306     0.200
     0.736     0.452     0.200
     0.743     1.652     0.200
     0.781     0.117     0.200
     0.745     0.696     0.200
     0.764     1.688     0.200
     0.745     0.893     0.200
     0.801     0.102     0.200
     0.774     0.633     0.200
     0.852    -0.540     0.200
     0.894    -0.418     0.200
     0.112     2.903     0.200
     0.148     2.984     0.200
     0.180     2.637     0.200
     0.224     2.506     0.200
     0.227     3.385     0.200
     0.230     2.611     0.200
     0.257     2.700     0.200
     0.275     1.587     0.200
     0.274     2.636     0.200
     0.274     2.517     0.200
     0.301     1.014     0.200
     0.333     2.959     0.200
     0.338     1.937     0.200
     0.376     0.924     0.200
     0.386     0.485     0.200
     0.420     0.594     0.200
     0.465     0.442     0.200
     0.479     1.864     0.200
     0.497     2.466     0.200
     0.513     1.975     0.200
     0.513     1.446     0.200
     0.544     2.099     0.200
     0.554     0.432     0.200
     0.604    -0.213     0.200
     0.661     2.370     0.200
     0.681     1.758     0.200
     0.703     2.397     0.200
     0.703     1.884     0.200
     0.757     0.824     0.200
     0.757     0.644     0.200
     0.757     0.769     0.200
     1.519    -3.110     0.200
     2.115    -6.165     0.200
     0.348     1.208     0.200
     0.393     1.002     0.200
     0.445     0.707     0.200
     0.442     1.565     0.200
     0.510     0.284     0.200
     0.511     0.361     0.200
     0.512     0.079     0.200
     0.600     0.799     0.200
     0.612     0.293     0.200
     0.643     0.651     0.200
     0.677     0.185     0.200
     0.682     2.079     0.200
     0.713     1.185     0.200
     0.714     0.263     0.200
     0.718     0.575     0.200
     0.785     0.230     0.200
     0.788     0.159     0.200
     0.817     1.136     0.200
     0.843    -0.063     0.200
     0.869     0.092     0.200
     0.908    -0.079     0.200
     0.143     0.421     0.200
     0.247     2.578     0.200
     0.306     0.732     0.200
     0.317     1.002     0.200
     0.329     1.903     0.200
     0.370     1.180     0.200
     0.374     2.592     0.200
     0.408     0.925     0.200
     0.412     0.877     0.200
     0.414     1.678     0.200
     0.436     0.600     0.200
     0.504     2.379     0.200
     0.523     0.832     0.200
     0.557     0.918     0.200
     0.588     2.264     0.200
     0.598     1.202     0.200
     0.607     1.590     0.200
     0.601     0.959     0.200
     0.655     0.968     0.200
     0.681     1.033     0.200
     0.681     0.701     0.200
     0.702     0.819     0.200
     0.716     0.449     0.200
     0.722     0.614     0.200
     0.720     1.432     0.200
     0.723     1.104     0.200
     0.726     0.876     0.200
     0.740     2.397     0.200
     0.733     1.229     0.200
     0.757     0.803     0.200
     0.765     1.641     0.200
     0.790     1.565     0.200
     0.788     0.350     0.200
     0.794     1.610     0.200
     0.806     0.767     0.200
     0.876    -0.406     0.200
     0.137     0.509     0.200
     0.315     1.252     0.200
     0.329     1.735     0.200
     0.365     1.105     0.200
     0.375     2.477     0.200
     0.421     0.139     0.200
     0.406     1.141     0.200
     0.421     1.456     0.200
     0.432     0.301     0.200
     0.506     2.354     0.200
     0.519     2.055     0.200
     0.529     0.835     0.200
     0.588     2.356     0.200
     0.610     1.987     0.200
     0.601     0.771     0.200
     0.653     0.976     0.200
     0.685     1.395     0.200
     0.685     0.594     0.200
     0.719    -0.085     0.200
     0.706     0.781     0.200
     0.726     0.223     0.200
     0.729     0.423     0.200
     0.724     1.108     0.200
     0.732     0.653     0.200
     0.742     1.811     0.200
     0.738     0.772     0.200
     0.762     0.428     0.200
     0.775     1.692     0.200
     0.766     1.437     0.200
     0.792     1.356     0.200
     0.799     1.143     0.200
     0.162     0.996     0.200
     0.134     1.161     0.200
     0.162     0.429     0.200
     0.209     0.829     0.200
     0.165     1.376     0.200
     0.177     1.460     0.200
     0.195     1.055     0.200
     0.314     0.179     0.200
     0.406     1.093     0.200
     0.366     1.167     0.200
     0.463     0.486     0.200
     0.418     0.922     0.200
     0.418     0.901     0.200
     0.531     0.652     0.200
     0.460     1.107     0.200
     0.501     1.255     0.200
     0.583     0.522     0.200
     0.522     1.204     0.200
     0.572     0.816     0.200
     0.574     1.149     0.200
     0.683     0.139     0.200
     0.614     0.520     0.200
     0.632     1.460     0.200
     0.648     1.664     0.200
     0.708     0.651     0.200
     0.677     0.684     0.200
     0.689     0.539     0.200
     0.767     0.628     0.200
     0.776     0.352     0.200
     0.726     0.633     0.200
     0.743     0.736     0.200
     0.808     0.244     0.200
     0.830     0.372     0.200
     0.770     0.489     0.200
     0.820    -0.481     0.200
     0.903    -0.282     0.200
     0.225     1.139     0.200
     0.324     1.501     0.200
     0.365     1.746     0.200
     0.397     1.003     0.200
     0.413     1.212     0.200
     0.446     0.828     0.200
     0.449     1.118     0.200
     0.459     1.077     0.200
     0.458     0.611     0.200
     0.465     1.106     0.200
     0.486     1.632     0.200
     0.565     0.697     0.200
     0.583     0.901     0.200
     0.583     1.350     0.200
     0.588     0.490     0.200
     0.608     0.664     0.200
     0.600     0.835     0.200
     0.665     2.085     0.200
     0.675     0.614     0.200
     0.688     0.345     0.200
     0.685     2.472     0.200
     0.697     1.202     0.200
     0.760     0.715     0.200
     0.734     0.438     0.200
     0.740     1.017     0.200
     0.779     0.114     0.200
     0.781     0.389     0.200
     0.787     0.696     0.200
     0.799     1.340     0.200
     0.809     0.149     0.200
     0.806     0.666     0.200
     0.818     0.063     0.200
     0.814    -0.224     0.200
     0.834    -0.127     0.200
     0.834     0.119     0.200
     0.843     0.554     0.200
     0.863     0.498     0.200
     0.879    -0.200     0.200
     0.947     0.029     0.200
     0.212     1.072     0.200
     0.284     1.152     0.200
     0.294     2.377     0.200
     0.310     2.347     0.200
     0.279     0.420     0.200
     0.348     2.404     0.200
     0.366     2.307     0.200
     0.414     3.518     0.200
     0.438     1.588     0.200
     0.521     1.658     0.200
     0.488     1.128     0.200
     0.532     2.974     0.200
     0.545     0.843     0.200
     0.526     1.667     0.200
     0.517     1.403     0.200
     0.538     1.934     0.200
     0.554     2.630     0.200
     0.552     2.005     0.200
     0.593     0.525     0.200
     0.579     2.587     0.200
     0.592     0.715     0.200
     0.662     1.064     0.200
     0.671     0.741     0.200
     0.696     1.190     0.200
     0.690     0.439     0.200
     0.706     1.398     0.200
     0.773     0.472     0.200
     0.802     0.993     0.200
     0.817     0.283     0.200
     0.810    -0.029     0.200
     0.818     0.218     0.200
     0.261     1.175     0.200
     0.256     1.540     0.200
     0.357     1.901     0.200
     0.382     0.182     0.200
     0.365     2.461     0.200
     0.384     0.659     0.200
     0.378     2.776     0.200
     0.402     2.607     0.200
     0.424     1.724     0.200
     0.415     0.173     0.200
     0.415     1.276     0.200
     0.447     0.586     0.200
     0.492     0.778     0.200
     0.492     0.247     0.200
     0.526     2.897     0.200
     0.558     0.682     0.200
     0.565     2.365     0.200
     0.620     2.110     0.200
     0.651    -0.499     0.200
     0.629     0.694     0.200
     0.659     1.996     0.200
     0.675    -0.408     0.200
     0.662     0.321     0.200
     0.679     0.095     0.200
     0.686    -0.209     0.200
     0.691    -0.193     0.200
     0.693    -0.231     0.200
     0.693    -0.496     0.200
     0.747    -0.363     0.200
     0.778    -0.507     0.200
     0.999    -2.219     0.200
     0.102     1.851     0.200
     0.153     1.259     0.200
     0.179     2.236     0.200
     0.248     1.576     0.200
     0.448     1.216     0.200
     0.456     2.174     0.200
     0.712     0.935     0.200
     0.715     0.658     0.200
     0.780     1.289     0.200
     0.104     1.797     0.200
     0.106     0.166     0.200
     0.113     2.572     0.200
     0.172     2.029     0.200
     0.162     1.372     0.200
     0.163     2.827     0.200
     0.240     2.399     0.200
     0.230     1.990     0.200
     0.394     1.200     0.200
     0.423     1.644     0.200
     0.457     1.730     0.200
     0.444     1.705     0.200
     0.459     1.515     0.200
     0.457     2.431     0.200
     0.463     2.706     0.200
     0.492     2.098     0.200
     0.610     2.746     0.200
     0.590     1.707     0.200
     0.630     2.111     0.200
     0.628     0.941     0.200
     0.641     2.177     0.200
     0.678     1.062     0.200
     0.687     0.986     0.200
     0.681     0.881     0.200
     0.717     1.483     0.200
     0.716     1.317     0.200
     0.719     1.271     0.200
     0.719     0.849     0.200
     0.770     0.472     0.200
     0.761     0.655     0.200
     0.783     1.802     0.200
     0.782     1.716     0.200
     0.784     0.868     0.200
     0.809     1.485     0.200
     0.829     2.344     0.200
     0.833     1.297     0.200
     0.090     2.124     0.200
     0.102     0.050     0.200
     0.154     0.994     0.200
     0.174     2.558     0.200
     0.243     2.290     0.200
     0.318     0.810     0.200
     0.321     0.741     0.200
     0.371     1.533     0.200
     0.405     2.122     0.200
     0.408     1.654     0.200
     0.433     1.289     0.200
     0.445     1.686     0.200
     0.448     0.984     0.200
     0.454     1.236     0.200
     0.470     2.036     0.200
     0.468     1.657     0.200
     0.496     1.781     0.200
     0.496     3.460     0.200
     0.605     0.790     0.200
     0.603     1.456     0.200
     0.609     3.007     0.200
     0.621     1.832     0.200
     0.635     0.442     0.200
     0.637     2.719     0.200
     0.668     0.979     0.200
     0.696     0.542     0.200
     0.726     1.548     0.200
     0.726     0.767     0.200
     0.729     0.599     0.200
     0.774     1.159     0.200
     0.790     0.669     0.200
     0.784     1.694     0.200
     0.794     0.772     0.200
     0.798     0.777     0.200
     0.821     1.435     0.200
     0.093     2.268     0.200
     0.089     2.862     0.200
     0.135     0.826     0.200
     0.188     1.938     0.200
     0.190     2.349     0.200
     0.260     2.659     0.200
     0.338     0.776     0.200
     0.408     1.701     0.200
     0.427     2.197     0.200
     0.430     1.621     0.200
     0.450     1.058     0.200
     0.445     1.958     0.200
     0.469     1.851     0.200
     0.519     3.325     0.200
     0.516     0.805     0.200
     0.598     1.536     0.200
     0.628     0.927     0.200
     0.640     1.483     0.200
     0.655     0.354     0.200
     0.682     1.027     0.200
     0.673     0.615     0.200
     0.713     0.447     0.200
     0.711     1.031     0.200
     0.714     0.222     0.200
     0.714     0.870     0.200
     0.769    -0.929     0.200
     0.761     1.799     0.200
     0.775     1.184     0.200
     0.782     1.162     0.200
     0.795     1.066     0.200
     0.808     1.541     0.200
     1.009    -0.541     0.200
     0.140     2.011     0.200
     0.302     0.111     0.200
     0.339     0.700     0.200
     0.340     0.540     0.200
     0.346     0.356     0.200
     0.356     0.889     0.200
     0.352     1.367     0.200
     0.347     0.668     0.200
     0.424     0.904     0.200
     0.431     0.971     0.200
     0.457     1.094     0.200
     0.470     0.702     0.200
     0.459     1.620     0.200
     0.481     0.877     0.200
     0.481     0.748     0.200
     0.475     1.733     0.200
     0.504     0.964     0.200
     0.501     1.358     0.200
     0.526     1.664     0.200
     0.526     1.496     0.200
     0.549     1.193     0.200
     0.581     0.852     0.200
     0.592     1.343     0.200
     0.623     0.892     0.200
     0.687     0.294     0.200
     0.680     0.057     0.200
     0.704     0.900     0.200
     0.693     1.461     0.200
     0.741     0.854     0.200
     0.756     1.367     0.200
     0.774     0.873     0.200
     0.762     0.500     0.200
     0.766     2.077     0.200
     0.814     1.911     0.200
     0.821     2.003     0.200
     0.803     0.349     0.200
     0.844     0.535     0.200
     0.849     0.360     0.200
     0.880     0.217     0.200
     0.880     0.850     0.200
     0.898     0.266     0.200
     0.958     0.290     0.200
     1.047    -0.514     0.200
     1.583     0.004     0.200
     0.122     2.154     0.200
     0.206     1.434     0.200
     0.316     0.499     0.200
     0.307     1.908     0.200
     0.323     2.610     0.200
     0.333     2.609     0.200
     0.355     1.305     0.200
     0.345     1.356     0.200
     0.410     0.945     0.200
     0.480     0.552     0.200
     0.493     1.527     0.200
     0.533     0.542     0.200
     0.606     1.328     0.200
     0.581     1.567     0.200
     0.597     1.723     0.200
     0.619     0.720     0.200
     0.660     1.804     0.200
     0.667     1.097     0.200
     0.686     1.403     0.200
     0.716     0.538     0.200
     0.817     1.723     0.200
     0.881     0.020     0.200
     0.910     0.118     0.200
     0.031     1.409     0.200
     0.163     2.095     0.200
     0.197     0.493     0.200
     0.208     1.407     0.200
     0.312     0.274     0.200
     0.321     1.972     0.200
     0.342     1.615     0.200
     0.421     0.576     0.200
     0.488     0.290     0.200
     0.603     1.271     0.200
     0.608     1.430     0.200
     0.647     1.322     0.200
     0.654     1.350     0.200
     0.674     1.514     0.200
     0.709     0.837     0.200
     0.882     0.627     0.200
     0.897     0.730     0.200
     0.900     0.497     0.200
     0.973     0.416     0.200
     0.971    -0.357     0.200
     0.157     2.267     0.200
     0.212     1.131     0.200
     0.220     2.594     0.200
     0.238     2.335     0.200
     0.309     0.697     0.200
     0.418     0.909     0.200
     0.446     1.899     0.200
     0.494     1.846     0.200
     0.532     0.053     0.200
     0.604     1.502     0.200
     0.611     1.247     0.200
     0.607     1.466     0.200
     0.652     1.448     0.200
     0.660     1.647     0.200
     0.683     0.866     0.200
     0.716     0.592     0.200
     0.878    -0.136     0.200
     0.907    -1.027     0.200
     0.907    -0.120     0.200
     0.975    -0.555     0.200
     0.024     2.211     0.200
     0.195     1.177     0.200
     0.193     2.923     0.200
     0.208     1.239     0.200
     0.223     2.558     0.200
     0.311     1.983     0.200
     0.314     0.607     0.200
     0.318     2.992     0.200
     0.329     2.593     0.200
     0.347     1.533     0.200
     0.350     1.249     0.200
     0.447     1.826     0.200
     0.484     0.776     0.200
     0.492     1.747     0.200
     0.584     1.283     0.200
     0.608     1.555     0.200
     0.615     0.667     0.200
     0.662     0.987     0.200
     0.714    -0.116     0.200
     0.878    -0.385     0.200
     0.113     2.487     0.200
     0.160     2.297     0.200
     0.206     1.570     0.200
     0.219     2.452     0.200
     0.286     3.180     0.200
     0.313     2.438     0.200
     0.323     2.438     0.200
     0.345     1.898     0.200
     0.485     1.113     0.200
     0.453     1.753     0.200
     0.614     1.798     0.200
     0.611     1.088     0.200
     0.687     0.925     0.200
     0.708    -0.231     0.200
     0.103     2.074     0.200
     0.170     2.362     0.200
     0.207     1.418     0.200
     0.211     2.324     0.200
     0.303     2.691     0.200
     0.295     2.865     0.200
     0.314     2.760     0.200
     0.321     1.862     0.200
     0.336     1.086     0.200
     0.425     0.963     0.200
     0.490     0.492     0.200
     0.587     1.093     0.200
     0.604     1.283     0.200
     0.604     0.727     0.200
     0.647     1.057     0.200
     0.642     1.173     0.200
     0.702     0.242     0.200
     0.697     0.478     0.200
     0.863    -0.258     0.200
     0.892    -0.499     0.200
     0.019     2.662     0.200
     0.149     2.331     0.200
     0.207     1.500     0.200
     0.223     2.434     0.200
     0.231     2.294     0.200
     0.228     2.636     0.200
     0.274     2.999     0.200
     0.307     2.371     0.200
     0.315     0.441     0.200
     0.324     2.352     0.200
     0.347     1.460     0.200
     0.334     2.604     0.200
     0.355     1.294     0.200
     0.397     1.821     0.200
     0.410     1.061     0.200
     0.443     1.670     0.200
     0.481     1.037     0.200
     0.495     1.573     0.200
     0.531     0.368     0.200
     0.582     0.814     0.200
     0.598     1.520     0.200
     0.603     1.302     0.200
     0.619     0.212     0.200
     0.660     1.471     0.200
     0.676     0.825     0.200
     0.668     0.888     0.200
     0.688     1.345     0.200
     0.718     0.704     0.200
     0.909    -0.523     0.200
     5.802   -24.100     0.200
     0.037     2.306     0.200
     0.102     2.995     0.200
     0.170     2.432     0.200
     0.186     2.989     0.200
     0.202     1.307     0.200
     0.213     1.289     0.200
     0.239     1.679     0.200
     0.251     2.371     0.200
     0.295     2.999     0.200
     0.313     1.831     0.200
     0.324     2.407     0.200
     0.307     0.776     0.200
     0.335     0.721     0.200
     0.352     1.439     0.200
     0.428     0.892     0.200
     0.456     1.650     0.200
     0.486     1.910     0.200
     0.495     1.046     0.200
     0.539     0.489     0.200
     0.592     0.706     0.200
     0.609     1.253     0.200
     0.600     1.210     0.200
     0.618     1.383     0.200
     0.647     1.504     0.200
     0.667     1.514     0.200
     0.707     0.578     0.200
     0.697     0.891     0.200
     0.866    -0.149     0.200
     0.167     2.535     0.200
     0.213     1.325     0.200
     0.225     1.022     0.200
     0.245     2.235     0.200
     0.242     2.450     0.200
     0.288     3.017     0.200
     0.295     0.434     0.200
     0.309     2.806     0.200
     0.318     2.490     0.200
     0.329     1.884     0.200
     0.336     1.218     0.200
     0.365     1.500     0.200
     0.393     2.267     0.200
     0.432     0.804     0.200
     0.443     1.832     0.200
     0.500     1.677     0.200
     0.503     0.787     0.200
     0.525     0.651     0.200
     0.570     1.904     0.200
     0.603     0.767     0.200
     0.598     1.414     0.200
     0.619     1.174     0.200
     0.606     1.604     0.200
     0.652     1.371     0.200
     0.167     2.374     0.200
     0.224     1.278     0.200
     0.243     2.366     0.200
     0.244     2.583     0.200
     0.288     2.826     0.200
     0.296     0.527     0.200
     0.308     2.652     0.200
     0.318     3.015     0.200
     0.336     1.405     0.200
     0.364     1.404     0.200
     0.393     2.215     0.200
     0.430     2.367     0.200
     0.431     0.866     0.200
     0.444     1.829     0.200
     0.502     0.476     0.200
     0.499     1.496     0.200
     0.525     0.561     0.200
     0.602     0.638     0.200
     0.606     1.313     0.200
     0.618     0.884     0.200
     0.720     1.232     0.200
     0.027     2.673     0.200
     0.164     2.433     0.200
     0.210     1.300     0.200
     0.222     1.029     0.200
     0.240     2.105     0.200
     0.200     3.326     0.200
     0.212     2.522     0.200
     0.285     2.673     0.200
     0.325     1.755     0.200
     0.299     0.551     0.200
     0.362     1.245     0.200
     0.340     1.016     0.200
     0.428     1.339     0.200
     0.394     2.041     0.200
     0.443     1.844     0.200
     0.499     0.572     0.200
     0.526     0.604     0.200
     0.599     0.565     0.200
     0.605     1.394     0.200
     0.615     1.125     0.200
     0.602     0.619     0.200
     0.644     1.195     0.200
     0.655     1.005     0.200
     0.677     1.862     0.200
     0.721     0.433     0.200
     0.021     2.798     0.200
     0.130     2.229     0.200
     0.185     1.294     0.200
     0.199     1.161     0.200
     0.205     2.609     0.200
     0.215     1.974     0.200
     0.249     2.744     0.200
     0.327     0.625     0.200
     0.338     0.957     0.200
     0.343     2.105     0.200
     0.353     2.422     0.200
     0.375     1.364     0.200
     0.435     1.843     0.200
     0.465     0.470     0.200
     0.501     1.307     0.200
     0.571     1.857     0.200
     0.569     0.654     0.200
     0.639     0.904     0.200
     0.657     1.397     0.200
     0.680     1.052     0.200
     0.687     0.843     0.200
     0.725     0.433     0.200
     0.897    -0.252     0.200
     0.925    -0.564     0.200
     0.203     0.704     0.200
     0.245     0.395     0.200
     0.338     2.606     0.200
     0.313     0.829     0.200
     0.301     2.639     0.200
     0.368     2.195     0.200
     0.364     2.325     0.200
     0.414     2.841     0.200
     0.445     1.237     0.200
     0.467     1.133     0.200
     0.507     1.466     0.200
     0.528     1.531     0.200
     0.561     2.005     0.200
     0.520     1.959     0.200
     0.566     0.444     0.200
     0.618     0.201     0.200
     0.694     1.436     0.200
     0.660     0.927     0.200
     0.701     0.717     0.200
     0.793     0.556     0.200
     0.067     2.026     0.200
     0.143     2.233     0.200
     0.224     1.161     0.200
     0.281     2.328     0.200
     0.273     0.220     0.200
     0.277     0.979     0.200
     0.280     1.082     0.200
     0.339     2.237     0.200
     0.400     2.950     0.200
     0.412     1.296     0.200
     0.496     0.665     0.200
     0.523     1.652     0.200
     0.535     0.633     0.200
     0.529     1.285     0.200
     0.540     1.733     0.200
     0.587     0.414     0.200
     0.567     1.986     0.200
     0.607     1.245     0.200
     0.679     0.271     0.200
     0.691     0.982     0.200
     0.099     1.602     0.200
     0.231     0.351     0.200
     0.236     0.726     0.200
     0.269     0.562     0.200
     0.273     1.803     0.200
     0.302     0.287     0.200
     0.293     0.381     0.200
     0.313     0.642     0.200
     0.336     1.120     0.200
     0.341     0.160     0.200
     0.352     1.786     0.200
     0.419     0.957     0.200
     0.429     0.885     0.200
     0.449     1.012     0.200
     0.454     0.550     0.200
     0.457     0.041     0.200
     0.472     0.851     0.200
     0.458     1.536     0.200
     0.502     1.356     0.200
     0.503     0.584     0.200
     0.539     0.420     0.200
     0.534     0.576     0.200
     0.603     0.805     0.200
     0.626     1.348     0.200
     0.627     0.442     0.200
     0.636     0.803     0.200
     0.652     1.209     0.200
     0.681     0.474     0.200
     0.671     0.709     0.200
     0.696     1.401     0.200
     0.673     0.651     0.200
     0.690     0.429     0.200
     0.683     0.811     0.200
     0.697     1.280     0.200
     0.735     0.769     0.200
     0.739     0.879     0.200
     0.738     1.512     0.200
     0.773     0.073     0.200
     0.775     0.651     0.200
     0.801     0.299     0.200
     0.791     0.668     0.200
     0.809     0.125     0.200
     0.823     0.249     0.200
     0.837     0.750     0.200
     0.839     1.133     0.200
     0.895    -0.112     0.200
     5.119   -19.985     0.200
     0.229     1.284     0.200
     0.233     1.368     0.200
     0.440     1.781     0.200
     0.437     0.739     0.200
     0.453     1.114     0.200
     0.495    -0.663     0.200
     0.498    -0.248     0.200
     0.506     0.632     0.200
     0.541    -0.588     0.200
     0.499     1.778     0.200
     0.566     1.937     0.200
     0.586     0.817     0.200
     0.639    -0.154     0.200
     0.648    -0.563     0.200
     0.654    -0.278     0.200
     0.659    -0.040     0.200
     0.656    -0.347     0.200
     0.667     1.410     0.200
     0.704    -0.311     0.200
     0.711     0.478     0.200
     0.733    -0.286     0.200
     0.760    -0.378     0.200
     0.839    -0.887     0.200
     1.276    -3.270     0.200
     0.011     1.077     0.200
     0.071     2.195     0.200
     0.095     2.023     0.200
     0.151     1.945     0.200
     0.194     2.175     0.200
     0.191     3.242     0.200
     0.203     2.621     0.200
     0.215     1.292     0.200
     0.262     0.385     0.200
     0.289     2.109     0.200
     0.293     0.673     0.200
     0.350     2.493     0.200
     0.366     2.057     0.200
     0.425     1.438     0.200
     0.468     1.069     0.200
     0.520     1.251     0.200
     0.574     0.366     0.200
     0.535     1.450     0.200
     0.545     0.970     0.200
     0.568     1.278     0.200
     0.599     0.665     0.200
     0.605     1.771     0.200
     0.672     0.966     0.200
     0.611     0.799     0.200
     0.626     1.276     0.200
     0.644     0.903     0.200
     0.680     0.775     0.200
     0.681     1.676     0.200
     0.705     1.905     0.200
     0.703     1.540     0.200
     0.725     2.051     0.200
     0.760     1.523     0.200
     0.808     1.391     0.200
     0.794     2.393     0.200
     0.813     1.849     0.200
     0.826    -0.071     0.200
     0.893     0.020     0.200
     0.112     2.121     0.200
     0.099     2.080     0.200
     0.204     1.862     0.200
     0.286     2.280     0.200
     0.289     1.013     0.200
     0.367     2.086     0.200
     0.421     1.287     0.200
     0.488     1.229     0.200
     0.522     1.386     0.200
     0.542     0.999     0.200
     0.542     2.901     0.200
     0.536     1.794     0.200
     0.564     1.518     0.200
     0.595     0.436     0.200
     0.576     0.240     0.200
     0.609     1.981     0.200
     0.646     2.110     0.200
     0.676     0.471     0.200
     0.643     1.010     0.200
     0.674     0.003     0.200
     0.699     1.430     0.200
     0.699     1.180     0.200
     0.725     1.959     0.200
     0.759     1.712     0.200
     0.775     0.529     0.200
     0.782     2.679     0.200
     0.788     0.203     0.200
     0.794     1.299     0.200
     0.811     1.299     0.200
     0.825     0.234     0.200
     0.895    -0.191     0.200
     0.063     1.882     0.200
     0.150     2.389     0.200
     0.232    -0.161     0.200
     0.222     1.990     0.200
     0.251     2.399     0.200
     0.260     1.510     0.200
     0.297     2.380     0.200
     0.332     2.415     0.200
     0.332     2.008     0.200
     0.369     1.984     0.200
     0.388     2.036     0.200
     0.391     2.946     0.200
     0.434     2.445     0.200
     0.495     0.870     0.200
     0.508     1.584     0.200
     0.512     2.070     0.200
     0.523     2.227     0.200
     0.543     0.354     0.200
     0.537     2.506     0.200
     0.579     1.686     0.200
     0.566     1.549     0.200
     0.566     1.961     0.200
     0.586     1.930     0.200
     0.591     0.695     0.200
     0.623     1.428     0.200
     0.628     1.670     0.200
     0.647     0.974     0.200
     0.655    -0.814     0.200
     0.660     1.272     0.200
     0.638     1.920     0.200
     0.664     1.837     0.200
     0.647     1.513     0.200
     0.689     1.619     0.200
     0.697     0.353     0.200
     0.752     1.173     0.200
     0.775     0.586     0.200
     0.759     2.238     0.200
     0.777     0.302     0.200
     0.791     1.135     0.200
     0.797     1.367     0.200
     0.790    -0.449     0.200
     0.804     1.038     0.200
     0.795     2.166     0.200
     0.786     0.341     0.200
     0.809     1.098     0.200
     0.823    -0.064     0.200
     0.853     0.222     0.200
     0.974    -0.598     0.200
     0.029     1.904     0.200
     0.051     2.369     0.200
     0.098     2.488     0.200
     0.135     2.771     0.200
     0.220     3.086     0.200
     0.255     2.877     0.200
     0.310     2.015     0.200
     0.286     0.729     0.200
     0.330     2.412     0.200
     0.322     2.111     0.200
     0.325     2.089     0.200
     0.388     1.307     0.200
     0.483     2.196     0.200
     0.531     0.391     0.200
     0.525     1.972     0.200
     0.540     2.390     0.200
     0.559     0.373     0.200
     0.599     1.170     0.200
     0.576     0.566     0.200
     0.587     1.104     0.200
     0.642    -0.069     0.200
     0.631     1.708     0.200
     0.664     0.776     0.200
     0.680     0.810     0.200
     0.679     0.968     0.200
     0.681     0.208     0.200
     0.026     2.097     0.200
     0.053     2.065     0.200
     0.100     1.968     0.200
     0.122     2.380     0.200
     0.167     2.781     0.200
     0.226     2.705     0.200
     0.258     1.016     0.200
     0.285     0.408     0.200
     0.324     2.463     0.200
     0.324     1.828     0.200
     0.333     2.250     0.200
     0.402     2.991     0.200
     0.452     2.082     0.200
     0.480     1.779     0.200
     0.510     0.658     0.200
     0.521     1.891     0.200
     0.525     1.712     0.200
     0.534     1.663     0.200
     0.521     0.863     0.200
     0.544     2.533     0.200
     0.562     0.478     0.200
     0.553     1.671     0.200
     0.560     1.014     0.200
     0.584     1.787     0.200
     0.577     0.585     0.200
     0.600     1.226     0.200
     0.607     1.257     0.200
     0.645     0.911     0.200
     0.634     1.735     0.200
     0.653     0.949     0.200
     0.670     0.657     0.200
     0.681     1.159     0.200
     0.683     1.693     0.200
     0.667     0.998     0.200
     0.681     1.390     0.200
     0.681     0.364     0.200
     0.762     1.197     0.200
     0.782     0.695     0.200
     0.774    -0.010     0.200
     0.797     0.554     0.200
     0.797    -0.096     0.200
     0.797     2.028     0.200
     0.806     1.258     0.200
     0.810     1.169     0.200
     0.831     0.169     0.200
     0.874    -0.145     0.200
     0.996    -0.924     0.200
     0.030     2.184     0.200
     0.054     2.285     0.200
     0.101     2.414     0.200
     0.121     2.467     0.200
     0.135     2.543     0.200
     0.217     2.535     0.200
     0.254     1.010     0.200
     0.227     2.720     0.200
     0.257     2.351     0.200
     0.250     1.495     0.200
     0.311     2.167     0.200
     0.289     0.286     0.200
     0.325     1.708     0.200
     0.333     2.033     0.200
     0.379     2.969     0.200
     0.387     1.264     0.200
     0.386     1.734     0.200
     0.507     0.759     0.200
     0.480     1.954     0.200
     0.516     1.634     0.200
     0.530     1.137     0.200
     0.522     1.712     0.200
     0.542     2.510     0.200
     0.559     0.445     0.200
     0.524     0.910     0.200
     0.555     1.635     0.200
     0.561     1.448     0.200
     0.579     0.278     0.200
     0.596     1.268     0.200
     0.584     1.521     0.200
     0.605     1.007     0.200
     0.641     0.513     0.200
     0.639     1.572     0.200
     0.652     0.718     0.200
     0.664     0.913     0.200
     0.677     1.197     0.200
     0.683     1.252     0.200
     0.684     0.223     0.200
     0.740     0.740     0.200
     0.760     1.457     0.200
     0.781    -0.336     0.200
     0.793     0.221     0.200
     0.776    -0.024     0.200
     0.796     2.016     0.200
     0.036     1.125     0.200
     0.291     2.060     0.200
     0.299     0.033     0.200
     0.343     2.211     0.200
     0.363     1.834     0.200
     0.430     2.407     0.200
     0.439     2.374     0.200
     0.501     1.491     0.200
     0.495     0.995     0.200
     0.541     0.541     0.200
     0.542     1.397     0.200
     0.519     1.785     0.200
     0.518     0.665     0.200
     0.553     1.927     0.200
     0.542     1.806     0.200
     0.585     0.463     0.200
     0.584     2.273     0.200
     0.574     0.873     0.200
     0.592     1.249     0.200
     0.611     1.302     0.200
     0.610     0.271     0.200
     0.613     0.692     0.200
     0.643     0.866     0.200
     0.659     0.677     0.200
     0.666     1.044     0.200
     0.669     1.481     0.200
     0.674     2.072     0.200
     0.684     1.168     0.200
     0.709     0.412     0.200
     0.721     0.868     0.200
     0.725     1.298     0.200
     0.738     1.433     0.200
     0.755     2.195     0.200
     0.776     1.226     0.200
     0.769     1.519     0.200
     0.793     0.785     0.200
     0.791     0.555     0.200
     0.793     0.669     0.200
     0.793     0.564     0.200
     0.809     0.089     0.200
     1.550    -1.545     0.200
     0.039     1.950     0.200
     0.054     2.197     0.200
     0.102     1.996     0.200
     0.115     2.455     0.200
     0.144     2.374     0.200
     0.223     2.510     0.200
     0.240     0.091     0.200
     0.245     1.025     0.200
     0.250     2.548     0.200
     0.296     0.256     0.200
     0.302     2.235     0.200
     0.321     2.167     0.200
     0.324     1.867     0.200
     0.328     2.338     0.200
     0.378     1.320     0.200
     0.374     2.857     0.200
     0.393     2.944     0.200
     0.444     1.629     0.200
     0.485     2.115     0.200
     0.499     0.337     0.200
     0.519     1.743     0.200
     0.533     0.815     0.200
     0.516     1.783     0.200
     0.522     1.102     0.200
     0.536     2.557     0.200
     0.563     1.960     0.200
     0.567     1.178     0.200
     0.550     0.321     0.200
     0.589     1.532     0.200
     0.581     0.430     0.200
     0.590     0.926     0.200
     0.637     1.520     0.200
     0.632     0.548     0.200
     0.632     1.408     0.200
     0.653     0.604     0.200
     0.671     1.059     0.200
     0.655     1.200     0.200
     0.682     1.350     0.200
     0.687    -0.042     0.200
     0.748     0.999     0.200
     0.760     1.061     0.200
     0.775    -0.804     0.200
     0.797    -0.399     0.200
     0.830    -0.161     0.200
     0.140     2.522     0.200
     0.198     3.050     0.200
     0.257     0.867     0.200
     0.303     2.387     0.200
     0.275     2.377     0.200
     0.345     1.812     0.200
     0.387     1.216     0.200
     0.399     2.942     0.200
     0.417     2.991     0.200
     0.507     1.634     0.200
     0.521     1.813     0.200
     0.520     0.748     0.200
     0.514     0.562     0.200
     0.542     1.296     0.200
     0.540     1.254     0.200
     0.566    -0.033     0.200
     0.622     1.504     0.200
     0.597     0.510     0.200
     0.651    -0.277     0.200
     0.644     0.585     0.200
     0.668     0.640     0.200
     0.655     1.687     0.200
     0.669     1.300     0.200
     0.740     1.589     0.200
     0.700    -0.925     0.200
     0.775    -0.316     0.200
     0.776     2.164     0.200
     0.744     0.917     0.200
     0.789     1.533     0.200
     0.810    -0.966     0.200
     0.810     0.073     0.200
     0.795     0.095     0.200
     0.987    -1.076     0.200
     0.050     1.412     0.200
     0.111     2.261     0.200
     0.099     2.389     0.200
     0.163     2.790     0.200
     0.157     2.498     0.200
     0.183     2.522     0.200
     0.155     2.765     0.200
     0.165     2.777     0.200
     0.287     1.120     0.200
     0.318     1.887     0.200
     0.302     0.463     0.200
     0.324     2.168     0.200
     0.362     2.321     0.200
     0.395     2.528     0.200
     0.412     1.754     0.200
     0.427     0.743     0.200
     0.496     1.964     0.200
     0.499     2.080     0.200
     0.523     1.783     0.200
     0.554     2.107     0.200
     0.561     0.674     0.200
     0.569     2.461     0.200
     0.595     0.897     0.200
     0.601     0.895     0.200
     0.596     1.258     0.200
     0.622     0.887     0.200
     0.635     1.606     0.200
     0.672     0.817     0.200
     0.671     2.182     0.200
     0.692     2.586     0.200
     0.699     1.486     0.200
     0.712     2.416     0.200
     0.718     1.092     0.200
     0.741     0.726     0.200
     0.750     0.758     0.200
     0.778     1.261     0.200
     0.806     0.747     0.200
     0.824     0.762     0.200
     0.865     0.306     0.200
     0.051     0.446     0.200
     0.098     2.015     0.200
     0.113     2.197     0.200
     0.154     2.652     0.200
     0.185     2.731     0.200
     0.192     1.103     0.200
     0.280     2.328     0.200
     0.301     0.265     0.200
     0.320     2.134     0.200
     0.363     2.358     0.200
     0.396     2.250     0.200
     0.413     1.623     0.200
     0.427     1.876     0.200
     0.443     3.013     0.200
     0.461     3.477     0.200
     0.477     1.034     0.200
     0.496     1.473     0.200
     0.497     1.493     0.200
     0.521     1.647     0.200
     0.555     1.367     0.200
     0.562     0.430     0.200
     0.560     1.476     0.200
     0.570     1.807     0.200
     0.596     1.124     0.200
     0.595     1.821     0.200
     0.602     1.452     0.200
     0.602     0.805     0.200
     0.606     2.623     0.200
     0.623     0.335     0.200
     0.635     1.071     0.200
     0.664     1.367     0.200
     0.672     1.924     0.200
     0.673     1.242     0.200
     0.693     2.387     0.200
     0.711     1.959     0.200
     0.700     1.399     0.200
     0.719     0.297     0.200
     0.736     2.964     0.200
     0.740     1.078     0.200
     0.732     2.405     0.200
     0.738     1.429     0.200
     0.766     1.218     0.200
     0.775     1.419     0.200
     0.777     1.233     0.200
     0.795     1.382     0.200
     0.805     0.610     0.200
     0.810     0.545     0.200
     0.823    -0.239     0.200
     0.865     0.097     0.200
     0.055     0.920     0.200
     0.115     2.062     0.200
     0.106     1.722     0.200
     0.161     1.806     0.200
     0.155     2.917     0.200
     0.184     2.406     0.200
     0.165     2.608     0.200
     0.282     1.814     0.200
     0.273     2.564     0.200
     0.309     0.324     0.200
     0.322     1.722     0.200
     0.359     2.409     0.200
     0.384     1.878     0.200
     0.405     1.807     0.200
     0.443     3.158     0.200
     0.458     3.563     0.200
     0.483     1.400     0.200
     0.501     1.846     0.200
     0.520     2.239     0.200
     0.547     1.725     0.200
     0.558     0.778     0.200
     0.574     2.204     0.200
     0.596     0.833     0.200
     0.592     1.994     0.200
     0.595     1.972     0.200
     0.628     0.635     0.200
     0.628     1.384     0.200
     0.666     1.186     0.200
     0.696     1.942     0.200
     0.693     1.403     0.200
     0.706     1.139     0.200
     0.742     1.656     0.200
     0.773     1.473     0.200
     0.787     1.333     0.200
     0.800     0.600     0.200
     0.816     1.248     0.200
     0.857     0.430     0.200
     0.114     2.154     0.200
     0.183     2.579     0.200
     0.273     2.165     0.200
     0.281     0.975     0.200
     0.281     0.810     0.200
     0.317     2.506     0.200
     0.310     0.269     0.200
     0.323     1.832     0.200
     0.357     2.302     0.200
     0.404     1.421     0.200
     0.396     2.303     0.200
     0.417     2.272     0.200
     0.484     1.103     0.200
     0.499     2.226     0.200
     0.521     1.959     0.200
     0.546     1.238     0.200
     0.557     0.692     0.200
     0.586     0.642     0.200
     0.574     1.968     0.200
     0.595     0.577     0.200
     0.595     1.343     0.200
     0.592     0.666     0.200
     0.604     1.855     0.200
     0.627     0.460     0.200
     0.628     0.608     0.200
     0.655     1.129     0.200
     0.662     1.737     0.200
     0.665     0.611     0.200
     0.696     2.292     0.200
     0.706     1.191     0.200
     0.692     1.358     0.200
     0.737     0.680     0.200
     0.742     1.492     0.200
     0.747     0.977     0.200
     0.759     1.781     0.200
     0.771     0.686     0.200
     0.773    -0.440     0.200
     0.773     0.517     0.200
     0.800     0.966     0.200
     0.800     0.282     0.200
     0.815     0.694     0.200
     0.866     0.060     0.200
     1.534    -0.618     0.200
     0.190     1.114     0.200
     0.203     1.720     0.200
     0.299     2.096     0.200
     0.306     1.750     0.200
     0.321     2.852     0.200
     0.322     2.857     0.200
     0.346     1.503     0.200
     0.362     2.613     0.200
     0.378     2.503     0.200
     0.379     2.982     0.200
     0.392     1.494     0.200
     0.414     1.458     0.200
     0.408     1.930     0.200
     0.422     1.283     0.200
     0.427     0.530     0.200
     0.430     0.412     0.200
     0.447     2.645     0.200
     0.444     0.792     0.200
     0.471     0.833     0.200
     0.484     1.782     0.200
     0.551     2.272     0.200
     0.541     0.716     0.200
     0.577     1.863     0.200
     0.580     2.471     0.200
     0.591     1.211     0.200
     0.589     0.849     0.200
     0.603     0.856     0.200
     0.622     2.628     0.200
     0.649     3.133     0.200
     0.667    -0.252     0.200
     0.675     0.475     0.200
     0.677    -0.006     0.200
     0.677     0.127     0.200
     0.680     0.498     0.200
     0.680     0.333     0.200
     0.715     0.147     0.200
     0.718    -0.110     0.200
     0.721     0.563     0.200
     0.727     1.689     0.200
     0.743     0.221     0.200
     0.743     0.672     0.200
     0.765    -0.102     0.200
     0.776     0.265     0.200
     0.804     0.794     0.200
     0.812     0.369     0.200
     0.828    -0.085     0.200
     0.884    -0.340     0.200
     0.893    -0.027     0.200
     0.893    -0.531     0.200
     0.916    -0.180     0.200
     0.050     2.070     0.200
     0.063     2.416     0.200
     0.110     2.550     0.200
     0.116     2.392     0.200
     0.154     2.288     0.200
     0.225     3.019     0.200
     0.232     1.189     0.200
     0.235     2.532     0.200
     0.248     2.467     0.200
     0.264     1.635     0.200
     0.309     0.348     0.200
     0.330     2.284     0.200
     0.331     1.798     0.200
     0.365     1.415     0.200
     0.374     2.983     0.200
     0.390     1.396     0.200
     0.491     0.764     0.200
     0.483     2.032     0.200
     0.496     1.681     0.200
     0.509     1.180     0.200
     0.516     2.724     0.200
     0.507     1.759     0.200
     0.534     2.365     0.200
     0.539     0.685     0.200
     0.542     1.089     0.200
     0.569     1.735     0.200
     0.569     1.197     0.200
     0.576     0.614     0.200
     0.591     0.404     0.200
     0.588     1.585     0.200
     0.594     1.150     0.200
     0.620     0.584     0.200
     0.623     1.649     0.200
     0.637     1.730     0.200
     0.628     1.462     0.200
     0.648     0.695     0.200
     0.654     0.807     0.200
     0.658     1.361     0.200
     0.643     0.948     0.200
     0.662     1.304     0.200
     0.688     1.247     0.200
     0.698    -0.134     0.200
     0.753     0.985     0.200
     0.762     1.036     0.200
     0.771     0.302     0.200
     0.786     0.026     0.200
     0.792     0.215     0.200
     0.163     1.971     0.200
     0.102     2.250     0.200
     0.170     1.721     0.200
     0.167     1.241     0.200
     0.128     2.037     0.200
     0.128     2.045     0.200
     0.155     2.649     0.200
     0.174     2.358     0.200
     0.206     1.077     0.200
     0.203     1.664     0.200
     0.256     1.534     0.200
     0.265     1.358     0.200
     0.330     1.027     0.200
     0.330     1.087     0.200
     0.332     1.159     0.200
     0.297     1.601     0.200
     0.283     2.631     0.200
     0.319     1.015     0.200
     0.371     1.364     0.200
     0.405     1.087     0.200
     0.332     1.914     0.200
     0.402     1.055     0.200
     0.345     1.128     0.200
     0.351     2.623     0.200
     0.365     1.129     0.200
     0.421     0.642     0.200
     0.340     1.895     0.200
     0.388     1.589     0.200
     0.364     1.623     0.200
     0.436     1.378     0.200
     0.425     2.058     0.200
     0.418     1.518     0.200
     0.490     0.296     0.200
     0.455     1.025     0.200
     0.498     0.315     0.200
     0.535     0.196     0.200
     0.457     1.433     0.200
     0.541     0.881     0.200
     0.464     1.574     0.200
     0.515     1.149     0.200
     0.539     0.132     0.200
     0.512     0.611     0.200
     0.514     1.308     0.200
     0.496     1.263     0.200
     0.513     1.158     0.200
     0.596    -0.153     0.200
     0.542     2.862     0.200
     0.579     1.357     0.200
     0.606     0.226     0.200
     0.637    -0.430     0.200
     0.611     1.938     0.200
     0.612     1.893     0.200
     0.578     1.510     0.200
     0.638     1.975     0.200
     0.663     0.131     0.200
     0.636     0.980     0.200
     0.679    -0.387     0.200
     0.670    -0.183     0.200
     0.623     1.007     0.200
     0.644     0.378     0.200
     0.627     1.264     0.200
     0.637     0.150     0.200
     0.681     0.314     0.200
     0.726    -0.338     0.200
     0.733    -0.183     0.200
     0.747    -0.394     0.200
     0.761    -0.510     0.200
     0.748    -0.246     0.200
     0.763    -0.571     0.200
     0.780    -0.673     0.200
     0.736     0.547     0.200
     0.726     1.158     0.200
     0.732     0.571     0.200
     0.820    -0.620     0.200
     0.813    -0.644     0.200
     0.823    -0.907     0.200
     0.823    -0.637     0.200
     0.854    -0.840     0.200
     0.854    -1.200     0.200
     0.963    -1.290     0.200
     1.192    -2.905     0.200
     0.140     1.981     0.200
     0.133     2.150     0.200
     0.171     1.945     0.200
     0.197     1.334     0.200
     0.192     2.209     0.200
     0.221     1.855     0.200
     0.258     1.054     0.200
     0.245     2.475     0.200
     0.269     1.008     0.200
     0.263     1.690     0.200
     0.277     1.640     0.200
     0.300     1.285     0.200
     0.296     0.766     0.200
     0.331     1.090     0.200
     0.317     1.431     0.200
     0.344     0.737     0.200
     0.346     1.231     0.200
     0.375     0.612     0.200
     0.372     0.800     0.200
     0.385     0.894     0.200
     0.389     0.473     0.200
     0.389     0.768     0.200
     0.386     1.144     0.200
     0.405     0.548     0.200
     0.406     0.640     0.200
     0.400     1.002     0.200
     0.410     0.723     0.200
     0.396     1.543     0.200
     0.396     1.105     0.200
     0.427     0.366     0.200
     0.438     0.796     0.200
     0.434     0.708     0.200
     0.451     0.748     0.200
     0.440     0.703     0.200
     0.463     0.954     0.200
     0.454     0.069     0.200
     0.469     0.411     0.200
     0.477     0.376     0.200
     0.465     0.896     0.200
     0.482     0.895     0.200
     0.475     1.200     0.200
     0.499     0.297     0.200
     0.511     0.415     0.200
     0.503     0.580     0.200
     0.523     0.720     0.200
     0.527     1.236     0.200
     0.571    -0.020     0.200
     0.577     0.136     0.200
     0.555     2.310     0.200
     0.562     0.635     0.200
     0.571     0.089     0.200
     0.581     0.926     0.200
     0.575     2.074     0.200
     0.576     0.970     0.200
     0.586     0.850     0.200
     0.605     0.118     0.200
     0.613     0.110     0.200
     0.625     0.031     0.200
     0.620     0.587     0.200
     0.645     1.485     0.200
     0.640     0.305     0.200
     0.657     0.684     0.200
     0.652     0.117     0.200
     0.657     0.599     0.200
     0.646     0.465     0.200
     0.643     2.254     0.200
     0.650     1.086     0.200
     0.665     1.035     0.200
     0.684     0.597     0.200
     0.692    -0.128     0.200
     0.709     1.009     0.200
     0.705     0.756     0.200
     0.710     1.130     0.200
     0.705     1.604     0.200
     0.706     1.072     0.200
     0.716    -0.236     0.200
     0.731     0.534     0.200
     0.733     0.354     0.200
     0.738     0.659     0.200
     0.732    -0.187     0.200
     0.732     0.357     0.200
     0.743    -0.306     0.200
     0.750     0.638     0.200
     0.742     1.247     0.200
     0.768     1.911     0.200
     0.753    -0.190     0.200
     0.755     0.258     0.200
     0.787    -0.653     0.200
     0.815    -0.605     0.200
     0.094     2.613     0.200
     0.126     3.505     0.200
     0.126     2.333     0.200
     0.133     2.461     0.200
     0.174     2.523     0.200
     0.175     3.852     0.200
     0.235     0.426     0.200
     0.235     0.551     0.200
     0.261     1.753     0.200
     0.266     2.522     0.200
     0.273     0.462     0.200
     0.297     2.576     0.200
     0.316     1.766     0.200
     0.322     0.717     0.200
     0.341     2.390     0.200
     0.359     2.760     0.200
     0.378     1.265     0.200
     0.388     0.640     0.200
     0.435     0.739     0.200
     0.435     0.840     0.200
     0.435     0.285     0.200
     0.461     0.809     0.200
     0.457     1.858     0.200
     0.474     2.510     0.200
     0.479     1.692     0.200
     0.487     1.584     0.200
     0.528     2.322     0.200
     0.536     1.039     0.200
     0.534     0.669     0.200
     0.567     0.660     0.200
     0.565     0.161     0.200
     0.567     0.160     0.200
     0.567     2.465     0.200
     0.582     1.109     0.200
     0.598     0.532     0.200
     0.590     2.165     0.200
     0.625     0.419     0.200
     0.658     1.248     0.200
     0.678     2.408     0.200
     0.671     0.092     0.200
     0.671     1.959     0.200
     0.722     0.770     0.200
     0.722     2.559     0.200
     0.723     2.271     0.200
     0.733     0.738     0.200
     0.749     0.866     0.200
     0.790     0.952     0.200
     0.785     1.211     0.200
     0.811     0.040     0.200
     0.827    -0.480     0.200
     1.543     0.282     0.200
     1.541    -2.623     0.200
     0.086     1.039     0.200
     0.139     0.564     0.200
     0.142     1.784     0.200
     0.188     1.630     0.200
     0.187     1.539     0.200
     0.209     0.817     0.200
     0.209     0.889     0.200
     0.209     1.079     0.200
     0.225     0.431     0.200
     0.248     0.809     0.200
     0.248     1.129     0.200
     0.226     2.037     0.200
     0.260     0.443     0.200
     0.241     0.523     0.200
     0.249     0.968     0.200
     0.290     0.958     0.200
     0.290     1.228     0.200
     0.285     1.145     0.200
     0.320     1.074     0.200
     0.330     1.043     0.200
     0.320     1.669     0.200
     0.342     1.555     0.200
     0.363     1.167     0.200
     0.347     1.435     0.200
     0.344     1.104     0.200
     0.353     1.684     0.200
     0.366     2.412     0.200
     0.385     1.725     0.200
     0.411     1.747     0.200
     0.427     0.859     0.200
     0.398     0.972     0.200
     0.399     0.953     0.200
     0.411     1.657     0.200
     0.418     1.386     0.200
     0.430     1.527     0.200
     0.426     0.960     0.200
     0.432     0.997     0.200
     0.451     0.720     0.200
     0.433     0.896     0.200
     0.457     1.296     0.200
     0.471     0.439     0.200
     0.520     0.780     0.200
     0.516     1.087     0.200
     0.525     1.933     0.200
     0.532     1.196     0.200
     0.543     0.687     0.200
     0.567     1.930     0.200
     0.537     1.173     0.200
     0.566     1.568     0.200
     0.547     1.530     0.200
     0.557     1.528     0.200
     0.560     0.964     0.200
     0.569     1.227     0.200
     0.582     1.110     0.200
     0.607     0.303     0.200
     0.596     1.523     0.200
     0.635     0.904     0.200
     0.634     0.109     0.200
     0.634     0.832     0.200
     0.641     0.164     0.200
     0.617     2.924     0.200
     0.622     1.668     0.200
     0.664     0.556     0.200
     0.666     0.527     0.200
     0.643     0.659     0.200
     0.652     0.578     0.200
     0.657     0.532     0.200
     0.664     0.470     0.200
     0.685     0.549     0.200
     0.685     0.548     0.200
     0.660     1.036     0.200
     0.661     1.646     0.200
     0.699     1.319     0.200
     0.682     0.753     0.200
     0.703     1.578     0.200
     0.699     0.270     0.200
     0.688     0.531     0.200
     0.707     0.499     0.200
     0.717     0.228     0.200
     0.733     0.949     0.200
     0.703     1.859     0.200
     0.708     0.791     0.200
     0.711     1.711     0.200
     0.747     2.472     0.200
     0.740     0.071     0.200
     0.736     0.406     0.200
     0.747     0.321     0.200
     0.759    -0.234     0.200
     0.759    -0.043     0.200
     0.761    -0.104     0.200
     0.765     0.220     0.200
     0.753     0.612     0.200
     0.782     2.014     0.200
     0.794     1.755     0.200
     0.795     0.152     0.200
     0.773     0.691     0.200
     0.790     0.012     0.200
     0.780     1.059     0.200
     0.788     0.567     0.200
     0.787     0.691     0.200
     0.788     1.098     0.200
     0.808    -0.134     0.200
     0.808    -0.185     0.200
     0.807     0.866     0.200
     0.832     0.049     0.200
     0.853    -0.562     0.200
     0.853    -0.292     0.200
     0.857    -0.350     0.200
     0.874    -0.203     0.200
     0.875     0.119     0.200
     0.911    -0.319     0.200
     1.353    -3.880     0.200
     0.173     1.878     0.200
     0.158     1.535     0.200
     0.205     1.648     0.200
     0.215     2.489     0.200
     0.243     1.312     0.200
     0.232     1.197     0.200
     0.241     1.090     0.200
     0.246     1.214     0.200
     0.269     1.124     0.200
     0.316     1.311     0.200
     0.298     0.846     0.200
     0.296     1.050     0.200
     0.329     1.569     0.200
     0.299     1.285     0.200
     0.340     1.524     0.200
     0.342     1.569     0.200
     0.341     0.633     0.200
     0.324     0.831     0.200
     0.346     0.974     0.200
     0.374     1.296     0.200
     0.385     1.352     0.200
     0.391     0.811     0.200
     0.366     0.390     0.200
     0.371     0.591     0.200
     0.397     0.914     0.200
     0.427     0.744     0.200
     0.394     0.973     0.200
     0.429     1.399     0.200
     0.432     1.313     0.200
     0.418     2.569     0.200
     0.447     0.879     0.200
     0.442     0.978     0.200
     0.439     0.265     0.200
     0.434     0.732     0.200
     0.444     0.241     0.200
     0.444     0.319     0.200
     0.468     0.691     0.200
     0.502     0.281     0.200
     0.495     0.924     0.200
     0.509     0.779     0.200
     0.511     0.626     0.200
     0.517     0.310     0.200
     0.512     0.173     0.200
     0.528     0.785     0.200
     0.526     0.359     0.200
     0.542     0.306     0.200
     0.551     0.432     0.200
     0.521    -0.015     0.200
     0.552     2.386     0.200
     0.542     2.022     0.200
     0.532     1.298     0.200
     0.565     0.924     0.200
     0.531     0.172     0.200
     0.534     0.913     0.200
     0.558     1.556     0.200
     0.540     0.377     0.200
     0.583     1.399     0.200
     0.598     0.334     0.200
     0.592     0.872     0.200
     0.594     0.551     0.200
     0.611     0.562     0.200
     0.633     2.209     0.200
     0.641     1.081     0.200
     0.628     0.801     0.200
     0.667     0.281     0.200
     0.650     1.427     0.200
     0.652     1.397     0.200
     0.662     0.593     0.200
     0.694     1.093     0.200
     0.676     0.744     0.200
     0.673     0.132     0.200
     0.673     0.174     0.200
     0.685     1.789     0.200
     0.673     0.249     0.200
     0.699    -0.366     0.200
     0.707     1.191     0.200
     0.711    -0.003     0.200
     0.682     1.108     0.200
     0.702     1.044     0.200
     0.688     0.750     0.200
     0.685     0.969     0.200
     0.695     0.338     0.200
     0.731     0.472     0.200
     0.711    -0.059     0.200
     0.727     1.356     0.200
     0.721     0.345     0.200
     0.710     0.795     0.200
     0.739    -0.440     0.200
     0.750     0.386     0.200
     0.759     1.055     0.200
     0.751     1.915     0.200
     0.773     0.891     0.200
     0.770     0.576     0.200
     0.791    -0.441     0.200
     0.779    -0.090     0.200
     0.831    -0.760     0.200
     0.861    -0.654     0.200
     0.885    -0.761     0.200
     2.125    -4.273     0.200
     2.213    -4.524     0.200
     2.943    -9.489     0.200
     0.029     1.140     0.200
     0.028     1.357     0.200
     0.083     2.297     0.200
     0.078     2.035     0.200
     0.119     2.316     0.200
     0.164     2.677     0.200
     0.166     2.634     0.200
     0.187     2.947     0.200
     0.206     2.911     0.200
     0.195     2.606     0.200
     0.202     1.179     0.200
     0.302     2.598     0.200
     0.307     0.617     0.200
     0.311     1.202     0.200
     0.360     2.132     0.200
     0.416     2.762     0.200
     0.467     1.266     0.200
     0.524     1.891     0.200
     0.549     2.359     0.200
     0.562     0.855     0.200
     0.558     2.541     0.200
     0.575     1.924     0.200
     0.570     0.456     0.200
     0.586     1.207     0.200
     0.641     1.512     0.200
     0.643     1.243     0.200
     0.651     1.750     0.200
     0.656     1.986     0.200
     0.665     0.268     0.200
     0.698     0.644     0.200
     0.692     1.805     0.200
     0.715     1.843     0.200
     0.722     1.018     0.200
     0.762     1.718     0.200
     0.772     1.052     0.200
     0.777     2.656     0.200
     0.788     0.372     0.200
     0.820     1.771     0.200
     0.825     0.464     0.200
     0.033     1.099     0.200
     0.088     2.222     0.200
     0.073     2.236     0.200
     0.124     2.316     0.200
     0.172     2.642     0.200
     0.170     2.570     0.200
     0.191     3.260     0.200
     0.208     2.817     0.200
     0.196     1.426     0.200
     0.307     2.553     0.200
     0.312    -0.322     0.200
     0.315     0.998     0.200
     0.341     1.940     0.200
     0.373     2.273     0.200
     0.442     2.819     0.200
     0.446     1.950     0.200
     0.462     1.624     0.200
     0.496     1.718     0.200
     0.500     1.538     0.200
     0.521     1.785     0.200
     0.527     1.828     0.200
     0.549     2.056     0.200
     0.567     0.506     0.200
     0.579     1.893     0.200
     0.573     0.643     0.200
     0.589     1.572     0.200
     0.589     2.344     0.200
     0.596     2.379     0.200
     0.643     1.764     0.200
     0.640     1.428     0.200
     0.654     1.938     0.200
     0.656     1.477     0.200
     0.667     1.114     0.200
     0.702     0.694     0.200
     0.696     1.957     0.200
     0.716     1.812     0.200
     0.721     1.749     0.200
     0.726     1.220     0.200
     0.760     1.746     0.200
     0.775     0.268     0.200
     0.785     0.497     0.200
     0.784     2.006     0.200
     0.819     1.801     0.200
     0.914     0.113     0.200
     0.025     1.812     0.200
     0.064     2.286     0.200
     0.100     1.379     0.200
     0.094     1.887     0.200
     0.147     2.776     0.200
     0.147     2.735     0.200
     0.209     3.266     0.200
     0.207     2.694     0.200
     0.215     2.869     0.200
     0.220     1.035     0.200
     0.299     1.125     0.200
     0.299     1.445     0.200
     0.318     2.246     0.200
     0.347     2.359     0.200
     0.476     2.559     0.200
     0.505     2.061     0.200
     0.482     1.081     0.200
     0.547     1.054     0.200
     0.523     1.272     0.200
     0.555     0.449     0.200
     0.559     0.630     0.200
     0.559     2.860     0.200
     0.545     1.851     0.200
     0.606     0.820     0.200
     0.632     2.319     0.200
     0.646     0.701     0.200
     0.644     1.445     0.200
     0.652     1.061     0.200
     0.652     0.441     0.200
     0.668     1.823     0.200
     0.674     1.154     0.200
     0.661     1.384     0.200
     0.691     0.743     0.200
     0.713     1.068     0.200
     0.701     1.246     0.200
     0.712     1.500     0.200
     0.723     1.635     0.200
     0.755     0.150     0.200
     0.779     1.722     0.200
     0.796     2.474     0.200
     0.806     0.238     0.200
     0.052     2.297     0.200
     0.051     2.801     0.200
     0.094     2.591     0.200
     0.104     2.564     0.200
     0.104     2.564     0.200
     0.098     2.683     0.200
     0.157     2.688     0.200
     0.228     0.430     0.200
     0.228     0.160     0.200
     0.233     1.143     0.200
     0.237     2.526     0.200
     0.237     2.526     0.200
     0.246     2.333     0.200
     0.288     2.364     0.200
     0.272     1.525     0.200
     0.326     2.262     0.200
     0.317     2.350     0.200
     0.318     1.418     0.200
     0.367     1.293     0.200
     0.364     2.736     0.200
     0.362     3.246     0.200
     0.362     2.926     0.200
     0.484     0.662     0.200
     0.497     1.861     0.200
     0.511     1.153     0.200
     0.496     2.064     0.200
     0.518     1.482     0.200
     0.514     1.908     0.200
     0.510     2.065     0.200
     0.536     0.631     0.200
     0.523     2.598     0.200
     0.523     1.877     0.200
     0.547     1.222     0.200
     0.584     0.058     0.200
     0.579     1.527     0.200
     0.577     2.074     0.200
     0.593     0.334     0.200
     0.593     1.464     0.200
     0.607     1.419     0.200
     0.579     0.434     0.200
     0.600     1.591     0.200
     0.620     0.542     0.200
     0.642     1.162     0.200
     0.642     2.082     0.200
     0.635     2.079     0.200
     0.624     1.492     0.200
     0.666     1.756     0.200
     0.666     0.924     0.200
     0.672     1.417     0.200
     0.675     1.246     0.200
     0.696     1.523     0.200
     0.687     0.470     0.200
     0.766     0.933     0.200
     0.775     0.432     0.200
     0.764     0.365     0.200
     0.758     1.085     0.200
     0.774    -0.189     0.200
     0.858    -0.015     0.200
     0.977    -0.689     0.200
     0.988    -0.792     0.200
     1.040    -1.260     0.200
     1.034    -1.107     0.200
     1.391    -3.686     0.200
     0.005     3.656     0.200
     0.065     2.371     0.200
     0.135     1.356     0.200
     0.179     1.666     0.200
     0.198     1.002     0.200
     0.218     0.807     0.200
     0.241     1.005     0.200
     0.267     0.824     0.200
     0.279     1.229     0.200
     0.275     0.729     0.200
     0.286     0.736     0.200
     0.282     1.839     0.200
     0.309     1.218     0.200
     0.331     1.066     0.200
     0.334     0.596     0.200
     0.336     1.590     0.200
     0.336     1.030     0.200
     0.342     2.361     0.200
     0.375     0.787     0.200
     0.355     2.076     0.200
     0.401     0.984     0.200
     0.404     0.917     0.200
     0.386     1.547     0.200
     0.390     1.343     0.200
     0.411     0.645     0.200
     0.404     1.533     0.200
     0.430     0.653     0.200
     0.438     1.016     0.200
     0.441     0.665     0.200
     0.444     0.845     0.200
     0.434     1.228     0.200
     0.465     0.814     0.200
     0.453     1.315     0.200
     0.486     0.243     0.200
     0.483     0.273     0.200
     0.476     2.209     0.200
     0.477     0.753     0.200
     0.483     1.761     0.200
     0.499     0.333     0.200
     0.510     0.472     0.200
     0.519     1.016     0.200
     0.533     0.010     0.200
     0.556     0.940     0.200
     0.574    -0.074     0.200
     0.560     0.420     0.200
     0.568     0.979     0.200
     0.578     0.912     0.200
     0.607     0.495     0.200
     0.600     0.653     0.200
     0.612     0.018     0.200
     0.606     0.664     0.200
     0.598     0.617     0.200
     0.611     1.164     0.200
     0.609     1.224     0.200
     0.620     0.537     0.200
     0.616     1.752     0.200
     0.647    -0.144     0.200
     0.645     0.598     0.200
     0.656    -0.190     0.200
     0.652     0.112     0.200
     0.660     0.035     0.200
     0.656     1.954     0.200
     0.654     0.398     0.200
     0.673     0.120     0.200
     0.675     0.719     0.200
     0.682     0.066     0.200
     0.690     1.860     0.200
     0.706     2.404     0.200
     0.716     0.227     0.200
     0.704     0.359     0.200
     0.725    -0.319     0.200
     0.729    -0.337     0.200
     0.732    -0.202     0.200
     0.741    -0.402     0.200
     0.738    -0.114     0.200
     0.728     0.644     0.200
     0.734     0.131     0.200
     0.751    -0.488     0.200
     0.762    -0.437     0.200
     0.768    -0.570     0.200
     0.768     0.084     0.200
     0.787    -0.341     0.200
     0.800    -0.544     0.200
     0.802    -0.474     0.200
     0.826    -0.669     0.200
     0.835    -0.516     0.200
     0.846    -0.377     0.200
     0.854    -0.572     0.200
     0.921    -1.073     0.200
     1.280    -3.947     0.200
     0.040     2.504     0.200
     0.124     2.499     0.200
     0.174     2.468     0.200
     0.195     2.330     0.200
     0.185     2.882     0.200
     0.193     3.180     0.200
     0.209     1.706     0.200
     0.242     1.672     0.200
     0.249     0.707     0.200
     0.287     3.136     0.200
     0.337     2.529     0.200
     0.322     2.515     0.200
     0.326     0.906     0.200
     0.356     1.430     0.200
     0.368     1.706     0.200
     0.448     2.557     0.200
     0.428     0.456     0.200
     0.439     1.803     0.200
     0.484     0.712     0.200
     0.483     1.183     0.200
     0.497     2.443     0.200
     0.553     0.979     0.200
     0.560     2.439     0.200
     0.603     1.887     0.200
     0.618    -0.166     0.200
     0.617     2.696     0.200
     0.641     1.950     0.200
     0.652     0.176     0.200
     0.701     1.688     0.200
     0.709     2.406     0.200
     0.723     1.090     0.200
     0.752     2.199     0.200
     0.782     0.336     0.200
     0.801     1.195     0.200
     0.841     0.065     0.200
     0.835    -0.383     0.200
     0.906    -0.085     0.200
     0.124     2.511     0.200
     0.098     3.480     0.200
     0.163     3.001     0.200
     0.178     2.447     0.200
     0.154     3.824     0.200
     0.189     2.884     0.200
     0.196     2.579     0.200
     0.192     2.249     0.200
     0.179     3.937     0.200
     0.212     0.820     0.200
     0.240     2.555     0.200
     0.246     0.717     0.200
     0.288     2.289     0.200
     0.324     2.559     0.200
     0.330     0.891     0.200
     0.359     1.471     0.200
     0.367     2.134     0.200
     0.407     1.090     0.200
     0.432     0.269     0.200
     0.442     1.907     0.200
     0.446     3.237     0.200
     0.481     0.648     0.200
     0.486     1.303     0.200
     0.516     1.897     0.200
     0.497     2.330     0.200
     0.562     1.797     0.200
     0.556     0.446     0.200
     0.602     1.485     0.200
     0.615    -0.143     0.200
     0.635     1.307     0.200
     0.650    -0.037     0.200
     0.642     1.964     0.200
     0.709     2.267     0.200
     0.700     1.845     0.200
     0.726     1.477     0.200
     0.714     1.198     0.200
     0.751     1.824     0.200
     0.753     2.324     0.200
     0.748     0.250     0.200
     0.763    -0.164     0.200
     0.786     0.376     0.200
     0.780     1.086     0.200
     0.798     0.211     0.200
     0.837    -0.258     0.200
     0.982    -1.076     0.200
     1.067    -1.445     0.200
     0.035     1.993     0.200
     0.104     3.317     0.200
     0.125     2.689     0.200
     0.169     2.580     0.200
     0.162     3.733     0.200
     0.206     1.121     0.200
     0.199     2.186     0.200
     0.245     2.443     0.200
     0.287     2.684     0.200
     0.320     1.071     0.200
     0.352     1.435     0.200
     0.342     2.498     0.200
     0.371     2.274     0.200
     0.399     1.211     0.200
     0.423     0.233     0.200
     0.434     1.901     0.200
     0.452     2.161     0.200
     0.451     2.885     0.200
     0.478     1.308     0.200
     0.469     1.345     0.200
     0.488     0.837     0.200
     0.498     2.373     0.200
     0.519     2.189     0.200
     0.547     1.224     0.200
     0.559     2.170     0.200
     0.606     1.842     0.200
     0.629     0.596     0.200
     0.623    -0.305     0.200
     0.623     0.265     0.200
     0.640     1.895     0.200
     0.655     0.108     0.200
     0.698     1.963     0.200
     0.720     1.363     0.200
     0.739     0.663     0.200
     0.721     1.192     0.200
     0.755     1.181     0.200
     0.762     0.960     0.200
     0.784     1.868     0.200
     0.773     0.878     0.200
     0.795     0.792     0.200
     0.785     0.619     0.200
     0.804     0.588     0.200
     0.832    -0.288     0.200
     0.836     0.393     0.200
     0.831     0.534     0.200
     0.849     0.413     0.200
     0.887     0.085     0.200
     0.902     0.121     0.200
     0.936    -0.649     0.200
     0.975    -0.426     0.200
     0.988    -0.397     0.200
     1.013    -0.608     0.200
     1.070    -1.154     0.200
     0.034     2.058     0.200
     0.105     3.291     0.200
     0.124     2.452     0.200
     0.168     2.527     0.200
     0.163     3.270     0.200
     0.179     2.501     0.200
     0.187     2.775     0.200
     0.186     3.782     0.200
     0.206     0.573     0.200
     0.199     2.182     0.200
     0.246     1.980     0.200
     0.288     2.163     0.200
     0.317     2.379     0.200
     0.351     1.471     0.200
     0.343     2.699     0.200
     0.371     2.030     0.200
     0.398     1.081     0.200
     0.422     0.412     0.200
     0.433     1.939     0.200
     0.452     2.681     0.200
     0.451     2.435     0.200
     0.478     1.380     0.200
     0.470     1.195     0.200
     0.498     2.694     0.200
     0.488     0.631     0.200
     0.547     0.601     0.200
     0.559     2.454     0.200
     0.607     2.186     0.200
     0.640     1.889     0.200
     0.623    -0.429     0.200
     0.655    -0.176     0.200
     0.699     1.292     0.200
     0.720     0.361     0.200
     0.707     2.449     0.200
     0.723     0.994     0.200
     0.746     1.644     0.200
     0.750     1.955     0.200
     0.785     1.679     0.200
     0.786     0.306     0.200
     0.796    -0.652     0.200
     0.805     1.534     0.200
     0.827     0.640     0.200
     0.836     0.257     0.200
     0.902    -0.167     0.200
     1.014    -0.755     0.200
     1.167    -1.605     0.200
     0.106     3.162     0.200
     0.120     2.635     0.200
     0.162     3.577     0.200
     0.156     2.873     0.200
     0.187     3.618     0.200
     0.173     2.551     0.200
     0.181     3.071     0.200
     0.194     2.270     0.200
     0.188     2.992     0.200
     0.211     1.586     0.200
     0.247     2.394     0.200
     0.292     2.115     0.200
     0.316     2.626     0.200
     0.343     2.483     0.200
     0.322     0.946     0.200
     0.357     1.360     0.200
     0.366     2.208     0.200
     0.426     0.662     0.200
     0.454     2.567     0.200
     0.438     1.989     0.200
     0.446     2.631     0.200
     0.471     1.627     0.200
     0.482     0.666     0.200
     0.483     1.391     0.200
     0.502     2.391     0.200
     0.514     1.948     0.200
     0.551     0.979     0.200
     0.564     2.030     0.200
     0.555     1.351     0.200
     0.609     1.687     0.200
     0.618     0.088     0.200
     0.635     1.163     0.200
     0.645     1.825     0.200
     0.650     0.059     0.200
     0.722     0.732     0.200
     0.703     2.442     0.200
     0.725     1.007     0.200
     0.744     0.675     0.200
     0.744     2.036     0.200
     0.760     1.341     0.200
     0.747     2.357     0.200
     0.767    -0.225     0.200
     0.774     0.827     0.200
     0.787     0.198     0.200
     0.801     0.676     0.200
     0.829    -0.245     0.200
     0.841     0.075     0.200
     0.907    -0.382     0.200
     0.042     2.499     0.200
     0.101     3.317     0.200
     0.122     2.492     0.200
     0.178     2.454     0.200
     0.187     3.039     0.200
     0.181     3.702     0.200
     0.191     2.200     0.200
     0.194     2.587     0.200
     0.242     2.375     0.200
     0.249     0.813     0.200
     0.290     3.080     0.200
     0.321     2.548     0.200
     0.337     2.574     0.200
     0.365     2.125     0.200
     0.360     1.384     0.200
     0.432     0.525     0.200
     0.443     1.809     0.200
     0.449     3.034     0.200
     0.479     0.449     0.200
     0.487     1.294     0.200
     0.500     2.303     0.200
     0.559     1.490     0.200
     0.557     0.723     0.200
     0.564     2.020     0.200
     0.605     1.810     0.200
     0.614     0.040     0.200
     0.637     0.945     0.200
     0.648     0.355     0.200
     0.645     1.692     0.200
     0.698     1.364     0.200
     0.715     0.969     0.200
     0.749     1.850     0.200
     0.751     2.133     0.200
     0.749     0.604     0.200
     0.782     0.812     0.200
     0.800     0.672     0.200
     0.803     1.229     0.200
     0.835    -0.370     0.200
     0.835     0.143     0.200
     0.910    -0.234     0.200
     1.015    -0.791     0.200
     0.146     1.712     0.200
     0.189     1.134     0.200
     0.187     1.770     0.200
     0.249     1.785     0.200
     0.252     1.185     0.200
     0.267     1.288     0.200
     0.283     1.975     0.200
     0.291     2.263     0.200
     0.352     2.763     0.200
     0.355     1.761     0.200
     0.349     1.755     0.200
     0.370     1.143     0.200
     0.392     2.974     0.200
     0.388     0.646     0.200
     0.401     2.848     0.200
     0.403     1.502     0.200
     0.390     0.877     0.200
     0.415     2.811     0.200
     0.420     0.560     0.200
     0.432     1.553     0.200
     0.426     0.521     0.200
     0.441     3.144     0.200
     0.445     1.301     0.200
     0.446     0.706     0.200
     0.467     1.415     0.200
     0.479     0.429     0.200
     0.490     0.424     0.200
     0.503     0.405     0.200
     0.525     1.774     0.200
     0.541     0.350     0.200
     0.562     0.251     0.200
     0.577     1.721     0.200
     0.568     0.386     0.200
     0.575     0.022     0.200
     0.606     1.201     0.200
     0.607     0.382     0.200
     0.615     2.416     0.200
     0.654     0.755     0.200
     0.646     0.225     0.200
     0.664    -0.038     0.200
     0.668     1.040     0.200
     0.685     0.326     0.200
     0.688     0.083     0.200
     0.692    -0.198     0.200
     0.695    -0.241     0.200
     0.695     0.053     0.200
     0.695     0.092     0.200
     0.688    -0.013     0.200
     0.713    -0.211     0.200
     0.724    -0.444     0.200
     0.730     0.563     0.200
     0.741     0.414     0.200
     0.757     0.862     0.200
     0.751     1.014     0.200
     0.773    -0.089     0.200
     0.777    -0.378     0.200
     0.791    -0.144     0.200
     0.845    -0.650     0.200
     0.863    -1.115     0.200
     0.289     1.740     0.200
     0.307     0.629     0.200
     0.335     1.578     0.200
     0.326     0.836     0.200
EOF
gmt end
