#!/bin/bash
gmt begin salton5.43_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional salton5.43'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.556
    15.000    42.277
    15.500    41.996
    16.000    41.712
    16.500    41.422
    17.000    41.126
    17.500    40.822
    18.000    40.507
    18.500    40.179
    19.000    39.838
    19.500    39.479
    20.000    39.102
    20.500    38.703
    21.000    38.281
    21.500    37.833
    22.000    37.357
    22.500    36.851
    23.000    36.313
    23.500    35.743
    24.000    34.524
    24.500    33.252
    25.000    31.970
    25.500    30.678
    26.000    29.375
    26.500    28.061
    27.000    26.734
    27.500    25.391
    28.000    24.028
    28.500    22.649
    29.000    21.259
    29.500    19.860
    30.000    18.454
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    21.028 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     7.117
     1.500     8.374
     2.000     9.630
     2.500    10.886
     3.000    12.143
     3.500    13.399
     4.000    14.654
     4.500    15.907
     5.000    17.160
     5.500    18.412
     6.000    19.662
     6.500    20.911
     7.000    22.159
     7.500    23.404
     8.000    24.648
     8.500    25.890
     9.000    27.130
     9.500    28.367
    10.000    29.602
    10.500    30.835
    11.000    32.065
    11.500    32.954
    12.000    33.738
    12.500    34.509
    13.000    35.266
    13.500    36.003
    14.000    36.718
    14.500    37.410
    15.000    38.070
    15.500    38.645
    16.000    39.164
    16.500    39.630
    17.000    40.041
    17.500    39.682
    18.000    40.029
    18.500    40.318
    19.000    40.549
    19.500    40.721
    20.000    40.835
    20.500    40.891
    21.000    40.886
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    32.266 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    14.007
     2.500    17.584
     3.000    21.161
     3.500    24.738
     4.000    28.315
     4.500    31.892
     5.000    35.469
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    31.315 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     4.087
     1.000     6.290
     1.500     8.494
     2.000    10.697
     2.500    12.900
     3.000    15.101
     3.500    17.302
     4.000    19.502
     4.500    21.701
     5.000    23.898
     5.500    26.094
     6.000    28.289
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    21.898 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    20.886
     1.500    27.481
     2.000    34.076
     2.500    40.670
     3.000    47.265
     3.500    53.860
     4.000    60.453
     4.500    67.042
     5.000    73.632
     5.500    80.218
     6.000    86.803
     6.500    93.384
     7.000    99.964
     7.500   106.540
     8.000   113.113
     8.500   119.683
     9.000   126.249
     9.500   132.811
    10.000   139.369
    10.500   145.923
    11.000   152.472
    11.500   159.016
    12.000   165.555
    12.500   171.919
    13.000   178.218
    13.500   184.503
    14.000   190.788
    14.500   197.071
    15.000   203.351
    15.500   209.623
    16.000   215.891
    16.500   222.150
    17.000   228.403
    17.500   234.449
    18.000   240.721
    18.500   246.980
    19.000   253.226
    19.500   259.458
    20.000   265.677
    20.500   271.882
    21.000   278.071
    21.500   284.246
    22.000   290.404
    22.500   296.547
    23.000   302.674
    23.500   308.783
    24.000   314.876
    24.500   320.951
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    58.453 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    11.383
     1.000    19.414
     1.500    27.444
     2.000    35.475
     2.500    43.505
     3.000    51.534
     3.500    59.560
     4.000    67.586
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    57.560 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     1.500    28.694
     2.000    38.716
     2.500    48.738
     3.000    58.760
     3.500    68.782
     4.000    78.804
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    60.760 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    18.568    48.158     0.150
     8.759   844.266     0.150
     0.981   506.607     0.150
     0.998   506.344     0.150
     1.025   506.298     0.150
     1.088   506.759     0.150
    28.584   212.165     0.150
    14.438   217.057     0.150
    15.503   225.819     0.150
    16.054   228.864     0.150
    16.203   231.009     0.150
    17.169   240.720     0.150
    18.995   256.758     0.150
    22.587   287.903     0.150
    23.691   296.851     0.150
    24.086   301.546     0.150
    24.396   301.207     0.150
    24.603   304.547     0.150
    15.245   216.172     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    14.343    39.760     0.200
    14.551    42.258     0.200
    22.153    39.322     0.200
    22.618    40.029     0.200
    14.959    43.611     0.200
    15.363    42.003     0.200
    18.184    41.843     0.200
    21.128    39.901     0.200
    22.370    38.667     0.200
    23.490    38.281     0.200
    26.893    30.810     0.200
    29.195    22.896     0.200
    14.989    44.106     0.200
    22.428    36.999     0.200
    28.581    22.211     0.200
    15.270    40.812     0.200
    15.270    40.417     0.200
    29.543    23.557     0.200
    14.428    44.465     0.200
    14.864    40.455     0.200
    14.864    39.906     0.200
    15.109    44.423     0.200
    15.452    41.744     0.200
    15.761    41.168     0.200
    16.028    40.051     0.200
    18.408    39.543     0.200
    21.431    38.797     0.200
    21.511    39.383     0.200
    21.672    39.296     0.200
    22.412    39.188     0.200
    23.609    38.612     0.200
    23.623    35.160     0.200
    24.842    32.493     0.200
    26.924    26.847     0.200
    29.140    20.693     0.200
    16.080    42.364     0.200
    16.592    45.078     0.200
    17.637    42.673     0.200
    18.601    41.792     0.200
    19.037    41.107     0.200
    19.919    40.214     0.200
    20.550    41.130     0.200
    21.452    39.437     0.200
    21.566    39.516     0.200
    21.705    40.480     0.200
    21.832    39.396     0.200
    21.852    40.617     0.200
    21.898    40.044     0.200
    22.109    42.332     0.200
    22.472    39.029     0.200
    22.565    39.010     0.200
    22.632    39.060     0.200
    22.808    38.199     0.200
    23.506    37.377     0.200
    23.621    36.111     0.200
    23.621    36.213     0.200
    23.803    37.461     0.200
    24.414    34.286     0.200
    24.441    35.186     0.200
    24.645    34.977     0.200
    24.764    34.977     0.200
    24.908    33.857     0.200
    24.957    36.025     0.200
    25.262    32.959     0.200
    25.343    33.064     0.200
    25.463    33.461     0.200
    26.391    29.976     0.200
    26.626    29.924     0.200
    26.626    30.306     0.200
    26.981    27.949     0.200
    26.981    28.270     0.200
    27.101    28.143     0.200
    27.508    26.856     0.200
    27.560    27.037     0.200
    28.017    27.562     0.200
    29.115    21.496     0.200
    29.115    21.746     0.200
    29.190    22.329     0.200
    29.566    21.734     0.200
    29.917    24.142     0.200
    16.463    45.333     0.200
    15.253    41.474     0.200
    17.681    40.836     0.200
    14.535    44.156     0.200
    15.265    43.234     0.200
    15.262    40.623     0.200
    15.606    40.952     0.200
    27.219    28.509     0.200
    14.733    40.382     0.200
    15.264    41.019     0.200
    15.412    39.852     0.200
    15.609    40.116     0.200
    15.993    39.926     0.200
    16.062    42.041     0.200
    17.223    41.002     0.200
    17.636    40.559     0.200
    18.051    40.621     0.200
    18.193    40.670     0.200
    18.172    43.590     0.200
    18.252    40.530     0.200
    18.343    41.706     0.200
    18.415    38.294     0.200
    18.462    39.122     0.200
    18.567    38.819     0.200
    18.594    39.913     0.200
    18.599    39.499     0.200
    18.611    39.791     0.200
    18.705    39.802     0.200
    18.717    40.242     0.200
    18.720    40.432     0.200
    18.753    39.659     0.200
    18.846    39.868     0.200
    18.915    39.963     0.200
    18.958    40.216     0.200
    18.965    39.897     0.200
    19.034    40.216     0.200
    19.036    40.008     0.200
    19.054    38.793     0.200
    19.065    39.215     0.200
    19.080    39.861     0.200
    19.094    38.505     0.200
    19.125    38.527     0.200
    19.137    39.492     0.200
    19.173    38.700     0.200
    19.199    39.538     0.200
    19.212    39.405     0.200
    19.222    39.405     0.200
    19.301    39.947     0.200
    19.356    39.581     0.200
    19.426    39.205     0.200
    19.470    38.585     0.200
    19.487    39.193     0.200
    19.507    38.483     0.200
    19.553    40.059     0.200
    19.629    38.764     0.200
    19.717    39.500     0.200
    19.736    39.492     0.200
    19.762    39.674     0.200
    19.777    39.605     0.200
    19.782    39.570     0.200
    19.791    39.809     0.200
    19.801    39.434     0.200
    19.819    38.326     0.200
    19.861    40.133     0.200
    19.864    39.926     0.200
    19.887    40.219     0.200
    19.892    39.583     0.200
    19.952    39.848     0.200
    20.013    39.834     0.200
    20.061    38.165     0.200
    20.070    38.903     0.200
    20.129    37.007     0.200
    20.267    38.092     0.200
    20.270    37.627     0.200
    20.297    38.381     0.200
    20.317    37.951     0.200
    20.323    38.209     0.200
    20.353    37.866     0.200
    20.353    37.584     0.200
    20.365    37.723     0.200
    20.369    38.538     0.200
    20.398    39.326     0.200
    20.398    37.865     0.200
    20.400    39.296     0.200
    20.412    38.758     0.200
    20.421    38.515     0.200
    20.459    37.290     0.200
    20.533    37.916     0.200
    20.567    37.348     0.200
    20.568    37.612     0.200
    20.667    39.043     0.200
    20.691    38.264     0.200
    20.717    38.043     0.200
    20.721    37.587     0.200
    20.777    38.210     0.200
    20.789    38.040     0.200
    20.799    38.262     0.200
    20.816    38.057     0.200
    20.856    39.483     0.200
    20.937    38.327     0.200
    20.939    38.036     0.200
    20.980    37.731     0.200
    20.985    38.091     0.200
    20.989    38.358     0.200
    20.994    37.145     0.200
    21.014    36.208     0.200
    21.032    39.476     0.200
    21.039    38.831     0.200
    21.059    43.360     0.200
    21.059    37.415     0.200
    21.067    37.882     0.200
    21.107    36.884     0.200
    21.126    38.535     0.200
    21.158    38.612     0.200
    21.161    38.301     0.200
    21.161    39.246     0.200
    21.174    38.975     0.200
    21.175    37.622     0.200
    21.197    39.161     0.200
    21.196    40.343     0.200
    21.251    37.696     0.200
    21.271    37.239     0.200
    21.318    37.995     0.200
    21.328    37.560     0.200
    21.344    38.337     0.200
    21.371    38.353     0.200
    21.419    36.925     0.200
    21.452    38.557     0.200
    21.465    37.788     0.200
    21.505    37.338     0.200
    21.523    37.503     0.200
    21.543    37.073     0.200
    21.552    38.198     0.200
    21.570    37.491     0.200
    21.629    37.478     0.200
    21.632    37.036     0.200
    21.640    37.918     0.200
    21.645    36.534     0.200
    21.658    37.396     0.200
    21.675    37.608     0.200
    21.711    37.831     0.200
    21.713    37.058     0.200
    21.719    37.221     0.200
    21.771    37.410     0.200
    21.782    37.820     0.200
    21.790    37.585     0.200
    21.796    37.332     0.200
    21.801    37.562     0.200
    21.910    37.894     0.200
    21.930    35.794     0.200
    21.934    36.769     0.200
    21.949    37.895     0.200
    21.954    37.377     0.200
    21.961    38.124     0.200
    22.009    37.535     0.200
    22.062    37.570     0.200
    22.106    37.276     0.200
    22.114    36.755     0.200
    22.117    37.263     0.200
    22.134    36.254     0.200
    22.143    37.612     0.200
    22.171    35.563     0.200
    22.195    36.223     0.200
    22.195    36.903     0.200
    22.224    36.471     0.200
    22.236    36.318     0.200
    22.264    36.647     0.200
    22.283    36.710     0.200
    22.286    36.658     0.200
    22.289    39.226     0.200
    22.289    36.734     0.200
    22.289    36.875     0.200
    22.341    35.763     0.200
    22.347    39.019     0.200
    22.347    36.066     0.200
    22.377    34.661     0.200
    22.437    36.492     0.200
    22.457    36.600     0.200
    22.459    35.892     0.200
    22.462    35.912     0.200
    22.499    36.486     0.200
    22.528    37.025     0.200
    22.597    36.086     0.200
    22.616    36.731     0.200
    22.682    36.656     0.200
    22.724    35.641     0.200
    22.731    35.952     0.200
    22.745    35.767     0.200
    22.782    37.022     0.200
    22.782    36.084     0.200
    22.788    36.288     0.200
    22.789    34.935     0.200
    22.829    35.933     0.200
    22.838    35.373     0.200
    22.864    36.401     0.200
    22.902    35.789     0.200
    22.917    35.767     0.200
    22.937    35.773     0.200
    22.978    32.974     0.200
    23.014    32.956     0.200
    23.056    37.285     0.200
    23.060    32.566     0.200
    23.119    32.038     0.200
    23.148    32.786     0.200
    23.170    37.373     0.200
    23.202    32.823     0.200
    23.233    31.374     0.200
    23.274    33.645     0.200
    23.292    32.896     0.200
    23.343    32.605     0.200
    23.369    34.123     0.200
    23.415    32.555     0.200
    23.420    32.160     0.200
    23.424    32.676     0.200
    23.454    34.452     0.200
    23.486    33.529     0.200
    23.505    33.126     0.200
    23.574    31.787     0.200
    23.607    33.251     0.200
    23.612    32.075     0.200
    23.675    35.924     0.200
    23.680    32.282     0.200
    23.719    35.538     0.200
    23.716    34.184     0.200
    23.731    35.818     0.200
    23.734    32.922     0.200
    23.779    35.855     0.200
    23.808    35.283     0.200
    23.844    32.881     0.200
    23.909    34.043     0.200
    23.927    32.994     0.200
    23.927    33.189     0.200
    23.949    33.822     0.200
    23.950    33.255     0.200
    23.989    32.527     0.200
    24.048    35.192     0.200
    24.058    35.917     0.200
    24.070    34.664     0.200
    24.122    35.789     0.200
    24.153    35.403     0.200
    24.163    34.797     0.200
    24.179    35.094     0.200
    24.249    35.526     0.200
    24.263    34.700     0.200
    24.301    34.793     0.200
    24.313    34.493     0.200
    24.321    33.703     0.200
    24.327    32.870     0.200
    24.328    33.025     0.200
    24.388    33.167     0.200
    24.424    33.485     0.200
    24.461    34.036     0.200
    24.483    35.051     0.200
    24.585    33.205     0.200
    24.587    34.088     0.200
    24.590    33.363     0.200
    24.637    31.316     0.200
    24.643    31.896     0.200
    24.671    31.485     0.200
    24.703    33.395     0.200
    24.789    32.783     0.200
    24.792    33.518     0.200
    24.803    34.262     0.200
    24.822    33.904     0.200
    24.867    34.344     0.200
    24.869    34.078     0.200
    24.882    34.557     0.200
    24.980    34.492     0.200
    25.071    33.843     0.200
    25.075    32.794     0.200
    25.102    32.370     0.200
    25.242    32.511     0.200
    25.247    33.101     0.200
    25.363    31.396     0.200
    25.395    32.475     0.200
    25.394    33.250     0.200
    25.400    31.758     0.200
    25.404    32.465     0.200
    25.422    32.648     0.200
    25.423    33.917     0.200
    25.427    32.632     0.200
    25.444    32.357     0.200
    25.524    30.548     0.200
    25.555    31.784     0.200
    25.587    31.004     0.200
    25.624    31.378     0.200
    25.776    31.475     0.200
    25.781    32.124     0.200
    25.850    30.772     0.200
    25.849    30.758     0.200
    25.879    30.950     0.200
    25.979    30.440     0.200
    25.980    29.414     0.200
    26.050    29.232     0.200
    26.095    30.878     0.200
    26.138    30.330     0.200
    26.146    30.297     0.200
    26.148    29.652     0.200
    26.254    29.699     0.200
    26.312    28.869     0.200
    26.326    30.496     0.200
    26.337    28.151     0.200
    26.411    29.328     0.200
    26.416    29.524     0.200
    26.435    27.210     0.200
    26.460    26.341     0.200
    26.521    27.489     0.200
    26.618    26.945     0.200
    26.651    27.626     0.200
    26.775    28.368     0.200
    26.807    27.979     0.200
    26.825    28.181     0.200
    26.898    28.255     0.200
    26.904    28.728     0.200
    26.942    28.412     0.200
    27.196    27.458     0.200
    27.220    28.517     0.200
    27.257    27.266     0.200
    27.276    27.776     0.200
    27.350    26.665     0.200
    27.389    25.987     0.200
    27.623    27.311     0.200
    27.670    26.442     0.200
    28.949    23.105     0.200
    28.996    23.942     0.200
    29.345    20.904     0.200
    29.388    21.118     0.200
    29.488    22.416     0.200
    29.632    21.214     0.200
    15.304    44.598     0.200
    27.249    30.493     0.200
    14.505    40.847     0.200
    14.730    42.585     0.200
    14.728    41.183     0.200
    14.816    44.954     0.200
    14.893    41.128     0.200
    14.958    42.250     0.200
    15.261    39.862     0.200
    15.369    40.431     0.200
    16.059    41.548     0.200
    16.179    44.649     0.200
    16.245    43.580     0.200
    16.472    40.440     0.200
    16.561    42.621     0.200
    16.686    44.945     0.200
    17.112    43.011     0.200
    17.633    41.784     0.200
    17.633    40.244     0.200
    17.705    45.288     0.200
    17.870    40.151     0.200
    18.167    44.910     0.200
    18.169    43.681     0.200
    18.260    41.402     0.200
    18.338    40.589     0.200
    18.342    41.851     0.200
    18.488    38.743     0.200
    18.517    38.886     0.200
    18.567    38.875     0.200
    18.610    38.286     0.200
    18.703    39.791     0.200
    18.715    39.469     0.200
    18.843    38.863     0.200
    19.053    38.536     0.200
    19.064    39.092     0.200
    19.091    39.352     0.200
    19.172    39.101     0.200
    19.210    39.613     0.200
    19.425    39.531     0.200
    19.551    39.696     0.200
    19.761    39.517     0.200
    19.776    39.685     0.200
    19.788    39.310     0.200
    19.788    39.639     0.200
    19.799    39.664     0.200
    19.850    39.486     0.200
    19.860    39.058     0.200
    20.058    39.506     0.200
    20.067    38.719     0.200
    20.266    39.506     0.200
    20.296    38.710     0.200
    20.352    38.669     0.200
    20.363    39.299     0.200
    20.396    38.844     0.200
    20.412    39.215     0.200
    20.457    39.170     0.200
    20.566    38.110     0.200
    20.815    38.462     0.200
    20.854    37.788     0.200
    20.938    37.231     0.200
    20.977    37.763     0.200
    20.983    39.047     0.200
    20.989    38.534     0.200
    20.994    39.137     0.200
    21.010    38.938     0.200
    21.011    38.143     0.200
    21.031    41.658     0.200
    21.038    37.888     0.200
    21.064    39.110     0.200
    21.066    38.829     0.200
    21.106    36.525     0.200
    21.126    36.504     0.200
    21.157    36.279     0.200
    21.159    38.620     0.200
    21.171    38.159     0.200
    21.174    37.017     0.200
    21.197    37.213     0.200
    21.193    40.370     0.200
    21.193    39.768     0.200
    21.249    37.674     0.200
    21.255    40.412     0.200
    21.269    37.296     0.200
    21.316    40.008     0.200
    21.316    36.922     0.200
    21.325    36.298     0.200
    21.343    36.860     0.200
    21.368    39.898     0.200
    21.368    37.086     0.200
    21.418    36.415     0.200
    21.450    38.857     0.200
    21.462    38.285     0.200
    21.503    37.605     0.200
    21.522    38.011     0.200
    21.536    37.085     0.200
    21.542    36.683     0.200
    21.550    37.979     0.200
    21.623    38.298     0.200
    21.627    38.164     0.200
    21.632    38.523     0.200
    21.638    37.336     0.200
    21.644    37.138     0.200
    21.657    38.076     0.200
    21.674    37.888     0.200
    21.708    38.462     0.200
    21.712    37.390     0.200
    21.719    38.380     0.200
    21.769    38.083     0.200
    21.781    38.809     0.200
    21.781    38.129     0.200
    21.789    36.820     0.200
    21.794    38.472     0.200
    21.800    36.800     0.200
    21.907    36.169     0.200
    21.928    36.889     0.200
    21.933    36.110     0.200
    21.946    38.104     0.200
    21.952    36.523     0.200
    21.959    40.016     0.200
    22.007    37.326     0.200
    22.060    37.619     0.200
    22.105    37.064     0.200
    22.113    37.086     0.200
    22.114    38.010     0.200
    22.134    37.432     0.200
    22.141    36.753     0.200
    22.192    37.788     0.200
    22.222    36.446     0.200
    22.234    36.782     0.200
    22.263    37.661     0.200
    22.262    37.830     0.200
    22.265    37.283     0.200
    22.281    37.544     0.200
    22.285    37.154     0.200
    22.288    38.108     0.200
    22.288    37.327     0.200
    22.289    37.439     0.200
    22.302    37.254     0.200
    22.341    36.480     0.200
    22.345    38.465     0.200
    22.345    37.817     0.200
    22.375    36.794     0.200
    22.435    37.599     0.200
    22.455    37.427     0.200
    22.458    36.888     0.200
    22.461    37.109     0.200
    22.497    37.183     0.200
    22.525    37.528     0.200
    22.525    37.919     0.200
    22.596    35.990     0.200
    22.614    36.579     0.200
    22.680    34.965     0.200
    22.722    37.071     0.200
    22.730    36.945     0.200
    22.736    36.965     0.200
    22.744    37.356     0.200
    22.779    38.052     0.200
    22.779    37.521     0.200
    22.786    36.626     0.200
    22.788    37.285     0.200
    22.826    37.702     0.200
    22.826    35.530     0.200
    22.836    37.106     0.200
    22.851    38.315     0.200
    22.861    37.032     0.200
    22.900    37.191     0.200
    22.906    36.430     0.200
    22.916    36.964     0.200
    22.928    38.215     0.200
    22.936    36.404     0.200
    22.976    35.772     0.200
    23.013    36.474     0.200
    23.017    40.625     0.200
    23.017    36.469     0.200
    23.053    37.485     0.200
    23.053    35.797     0.200
    23.056    35.963     0.200
    23.059    36.235     0.200
    23.100    36.137     0.200
    23.118    35.604     0.200
    23.146    35.585     0.200
    23.168    37.150     0.200
    23.168    35.729     0.200
    23.200    35.579     0.200
    23.232    34.536     0.200
    23.273    34.112     0.200
    23.290    36.058     0.200
    23.294    35.818     0.200
    23.341    34.053     0.200
    23.367    33.668     0.200
    23.383    37.181     0.200
    23.383    34.626     0.200
    23.413    35.693     0.200
    23.419    34.881     0.200
    23.422    36.898     0.200
    23.422    34.280     0.200
    23.439    41.797     0.200
    23.439    36.758     0.200
    23.452    35.796     0.200
    23.453    36.718     0.200
    23.471    34.741     0.200
    23.484    37.609     0.200
    23.484    35.288     0.200
    23.504    36.104     0.200
    23.533    35.717     0.200
    23.573    35.294     0.200
    23.606    36.354     0.200
    23.610    35.327     0.200
    23.654    34.624     0.200
    23.673    34.173     0.200
    23.679    34.098     0.200
    23.697    35.536     0.200
    23.718    34.972     0.200
    23.712    35.292     0.200
    23.728    35.348     0.200
    23.733    34.340     0.200
    23.778    34.595     0.200
    23.806    33.597     0.200
    23.843    34.435     0.200
    23.883    37.666     0.200
    23.883    34.658     0.200
    23.907    37.338     0.200
    23.907    35.064     0.200
    23.926    35.731     0.200
    23.946    36.077     0.200
    23.946    35.101     0.200
    23.948    35.039     0.200
    23.968    34.744     0.200
    23.988    34.832     0.200
    24.047    35.630     0.200
    24.056    34.081     0.200
    24.068    34.224     0.200
    24.120    32.995     0.200
    24.152    33.862     0.200
    24.162    34.947     0.200
    24.177    33.399     0.200
    24.195    37.527     0.200
    24.203    33.921     0.200
    24.204    35.248     0.200
    24.204    32.920     0.200
    24.248    35.483     0.200
    24.261    32.847     0.200
    24.293    33.475     0.200
    24.299    34.459     0.200
    24.299    34.029     0.200
    24.312    34.364     0.200
    24.320    34.154     0.200
    24.327    33.945     0.200
    24.324    33.587     0.200
    24.386    32.053     0.200
    24.423    34.294     0.200
    24.460    33.523     0.200
    24.484    35.001     0.200
    24.585    34.265     0.200
    24.589    34.026     0.200
    24.635    36.026     0.200
    24.635    33.026     0.200
    24.641    32.969     0.200
    24.669    30.821     0.200
    24.670    31.787     0.200
    24.703    30.565     0.200
    24.701    31.633     0.200
    24.751    32.880     0.200
    24.787    31.850     0.200
    24.791    31.451     0.200
    24.802    31.053     0.200
    24.820    30.441     0.200
    24.836    32.490     0.200
    24.865    35.556     0.200
    24.865    32.751     0.200
    24.868    31.809     0.200
    24.881    31.398     0.200
    24.977    31.888     0.200
    25.069    30.933     0.200
    25.074    30.905     0.200
    25.100    29.516     0.200
    25.185    31.748     0.200
    25.240    30.063     0.200
    25.246    30.827     0.200
    25.361    31.308     0.200
    25.394    31.781     0.200
    25.394    31.203     0.200
    25.400    31.720     0.200
    25.403    29.109     0.200
    25.421    32.437     0.200
    25.422    33.124     0.200
    25.426    32.234     0.200
    25.442    30.141     0.200
    25.547    30.017     0.200
    25.554    31.329     0.200
    25.585    30.191     0.200
    25.623    30.992     0.200
    25.774    31.704     0.200
    25.778    30.519     0.200
    25.848    30.009     0.200
    25.848    31.499     0.200
    25.860    30.772     0.200
    25.878    30.311     0.200
    25.918    29.470     0.200
    25.977    30.062     0.200
    26.049    28.922     0.200
    26.136    28.495     0.200
    26.144    30.218     0.200
    26.146    28.671     0.200
    26.253    29.500     0.200
    26.325    28.823     0.200
    26.336    29.882     0.200
    26.434    29.025     0.200
    26.458    27.075     0.200
    26.474    28.186     0.200
    26.519    28.814     0.200
    26.622    27.444     0.200
    26.642    28.193     0.200
    26.649    28.084     0.200
    26.661    29.215     0.200
    26.722    27.266     0.200
    26.773    27.422     0.200
    26.823    26.105     0.200
    26.858    28.264     0.200
    26.896    28.548     0.200
    26.902    27.768     0.200
    26.940    27.887     0.200
    27.013    27.913     0.200
    27.105    28.534     0.200
    27.217    29.146     0.200
    27.217    29.256     0.200
    27.255    25.133     0.200
    27.388    26.272     0.200
    27.621    25.651     0.200
    28.657    26.413     0.200
    28.947    20.270     0.200
    28.997    23.167     0.200
    29.284    27.133     0.200
    29.343    20.683     0.200
    29.485    21.126     0.200
    29.520    22.999     0.200
    29.630    24.704     0.200
    15.243    40.623     0.200
    22.502    37.946     0.200
    27.203    28.356     0.200
    29.466    21.120     0.200
    29.466    21.120     0.200
    15.316    43.057     0.200
    27.263    29.424     0.200
    14.956    40.973     0.200
    15.255    42.040     0.200
    15.565    43.210     0.200
    15.595    42.071     0.200
    15.664    41.791     0.200
    16.051    41.991     0.200
    16.684    44.781     0.200
    18.235    39.927     0.200
    18.245    41.384     0.200
    18.245    40.579     0.200
    18.282    39.920     0.200
    18.275    40.163     0.200
    18.327    41.037     0.200
    18.322    40.155     0.200
    18.445    39.898     0.200
    18.552    39.651     0.200
    18.576    39.495     0.200
    18.582    39.425     0.200
    18.687    40.170     0.200
    18.703    41.992     0.200
    18.703    40.516     0.200
    18.699    40.292     0.200
    18.737    41.406     0.200
    18.737    37.961     0.200
    18.828    39.068     0.200
    18.897    42.036     0.200
    18.897    39.778     0.200
    18.948    40.810     0.200
    18.948    39.567     0.200
    18.948    38.984     0.200
    19.017    39.395     0.200
    19.038    40.231     0.200
    19.049    39.852     0.200
    19.062    40.114     0.200
    19.078    41.527     0.200
    19.078    40.676     0.200
    19.110    40.188     0.200
    19.157    39.957     0.200
    19.181    40.480     0.200
    19.195    39.688     0.200
    19.277    39.890     0.200
    19.338    40.055     0.200
    19.453    39.337     0.200
    19.470    40.408     0.200
    19.490    38.412     0.200
    19.535    39.501     0.200
    19.612    38.818     0.200
    19.630    39.179     0.200
    19.700    38.423     0.200
    19.721    38.431     0.200
    19.747    39.234     0.200
    19.761    39.320     0.200
    19.785    39.104     0.200
    19.784    40.509     0.200
    19.835    40.420     0.200
    19.870    40.161     0.200
    19.875    39.803     0.200
    19.934    38.944     0.200
    19.975    41.326     0.200
    19.975    39.639     0.200
    20.003    39.498     0.200
    19.996    40.281     0.200
    19.996    39.844     0.200
    20.030    40.347     0.200
    20.043    40.591     0.200
    20.052    40.704     0.200
    20.112    39.601     0.200
    20.250    39.195     0.200
    20.253    39.653     0.200
    20.305    39.310     0.200
    20.336    40.113     0.200
    20.354    39.948     0.200
    20.347    39.859     0.200
    20.380    41.434     0.200
    20.380    39.582     0.200
    20.382    38.933     0.200
    20.404    39.893     0.200
    20.404    39.729     0.200
    20.441    41.411     0.200
    20.441    40.029     0.200
    20.516    40.057     0.200
    20.552    41.115     0.200
    20.552    39.412     0.200
    20.649    38.687     0.200
    20.704    38.577     0.200
    20.699    39.461     0.200
    20.760    39.186     0.200
    20.772    39.721     0.200
    20.781    39.173     0.200
    20.838    39.081     0.200
    20.920    39.869     0.200
    20.979    38.135     0.200
    20.962    38.126     0.200
    20.967    38.205     0.200
    20.994    39.271     0.200
    20.996    38.899     0.200
    21.015    40.568     0.200
    21.044    39.457     0.200
    21.050    38.807     0.200
    21.048    39.013     0.200
    21.092    38.767     0.200
    21.143    39.585     0.200
    21.143    38.765     0.200
    21.156    38.151     0.200
    21.191    40.032     0.200
    21.233    37.458     0.200
    21.254    38.213     0.200
    21.300    39.934     0.200
    21.300    38.856     0.200
    21.310    37.979     0.200
    21.353    40.294     0.200
    21.353    38.747     0.200
    21.434    36.634     0.200
    21.447    37.714     0.200
    21.488    37.366     0.200
    21.527    38.215     0.200
    21.534    37.522     0.200
    21.608    36.636     0.200
    21.612    38.153     0.200
    21.696    38.231     0.200
    21.693    38.436     0.200
    21.753    37.148     0.200
    21.766    39.706     0.200
    21.766    37.471     0.200
    21.778    38.039     0.200
    21.893    36.912     0.200
    21.912    37.259     0.200
    21.936    37.183     0.200
    21.931    37.516     0.200
    21.944    38.848     0.200
    21.991    38.227     0.200
    22.044    37.051     0.200
    22.097    37.535     0.200
    22.099    37.439     0.200
    22.126    37.303     0.200
    22.177    39.079     0.200
    22.177    37.478     0.200
    22.206    36.919     0.200
    22.219    36.638     0.200
    22.270    36.330     0.200
    22.272    38.362     0.200
    22.272    36.690     0.200
    22.266    38.752     0.200
    22.330    38.398     0.200
    22.330    37.101     0.200
    22.420    36.480     0.200
    22.442    36.520     0.200
    22.439    36.970     0.200
    22.445    37.299     0.200
    22.482    36.795     0.200
    22.511    37.930     0.200
    22.511    38.376     0.200
    22.665    36.559     0.200
    22.706    36.247     0.200
    22.728    36.047     0.200
    22.764    38.024     0.200
    22.764    37.196     0.200
    22.770    36.918     0.200
    22.811    37.907     0.200
    22.811    36.524     0.200
    22.820    36.164     0.200
    22.846    36.811     0.200
    23.002    38.603     0.200
    23.002    35.728     0.200
    23.041    36.693     0.200
    23.038    37.109     0.200
    23.038    36.961     0.200
    23.084    36.311     0.200
    23.152    36.947     0.200
    23.152    35.533     0.200
    23.184    36.029     0.200
    23.257    35.246     0.200
    23.279    35.260     0.200
    23.275    35.087     0.200
    23.326    35.486     0.200
    23.367    37.232     0.200
    23.367    34.825     0.200
    23.407    37.103     0.200
    23.407    34.111     0.200
    23.468    38.089     0.200
    23.468    35.471     0.200
    23.518    34.971     0.200
    23.590    36.707     0.200
    23.590    35.184     0.200
    23.594    35.275     0.200
    23.682    34.184     0.200
    23.702    34.562     0.200
    23.718    35.792     0.200
    23.701    35.080     0.200
    23.713    35.384     0.200
    23.868    34.432     0.200
    23.932    34.611     0.200
    23.931    36.435     0.200
    23.931    35.209     0.200
    23.952    34.873     0.200
    24.052    35.058     0.200
    24.179    35.812     0.200
    24.189    35.185     0.200
    24.246    33.476     0.200
    24.297    34.924     0.200
    24.407    32.204     0.200
    24.444    32.822     0.200
    24.573    32.854     0.200
    24.569    33.081     0.200
    24.568    33.021     0.200
    24.619    35.007     0.200
    24.619    31.757     0.200
    24.654    31.784     0.200
    24.685    33.282     0.200
    24.685    32.173     0.200
    24.850    34.418     0.200
    24.850    31.222     0.200
    24.962    32.011     0.200
    25.054    32.367     0.200
    25.224    30.211     0.200
    25.345    31.249     0.200
    25.379    31.596     0.200
    25.385    32.338     0.200
    25.407    32.184     0.200
    26.128    28.293     0.200
    26.320    28.956     0.200
    26.418    28.036     0.200
    26.545    26.638     0.200
    26.601    26.626     0.200
    26.633    26.182     0.200
    26.881    25.708     0.200
    26.924    26.352     0.200
    26.997    28.245     0.200
    27.214    28.418     0.200
    27.214    29.348     0.200
    29.477    22.038     0.200
    14.236    39.641     0.200
    15.568    42.455     0.200
    18.168    43.480     0.200
    15.270    42.185     0.200
    14.742    39.898     0.200
    18.450    39.723     0.200
    18.525    39.943     0.200
    18.680    39.021     0.200
    18.802    38.697     0.200
    18.802    39.705     0.200
    19.000    39.431     0.200
    19.000    39.774     0.200
    19.138    39.440     0.200
    19.138    40.061     0.200
    19.374    37.507     0.200
    19.454    38.919     0.200
    19.559    39.249     0.200
    19.615    38.808     0.200
    19.615    39.522     0.200
    19.760    38.577     0.200
    20.023    38.679     0.200
    20.060    39.169     0.200
    20.312    37.872     0.200
    20.458    38.741     0.200
    20.503    37.117     0.200
    20.806    38.073     0.200
    20.851    36.821     0.200
    20.863    37.403     0.200
    20.935    39.454     0.200
    20.935    37.739     0.200
    20.994    37.714     0.200
    20.994    38.991     0.200
    21.039    38.034     0.200
    21.099    37.027     0.200
    21.100    37.843     0.200
    21.221    36.698     0.200
    21.269    36.445     0.200
    21.269    37.320     0.200
    21.270    36.680     0.200
    21.308    36.806     0.200
    21.347    37.429     0.200
    21.366    38.174     0.200
    21.366    37.760     0.200
    21.431    36.492     0.200
    21.477    37.748     0.200
    21.519    37.865     0.200
    21.574    37.457     0.200
    21.575    38.082     0.200
    21.639    36.648     0.200
    21.628    37.469     0.200
    21.642    37.152     0.200
    21.667    37.383     0.200
    21.749    37.789     0.200
    21.804    37.031     0.200
    21.804    37.184     0.200
    21.874    35.572     0.200
    21.963    39.146     0.200
    21.985    38.585     0.200
    22.167    37.537     0.200
    22.198    37.231     0.200
    22.225    37.892     0.200
    22.220    36.417     0.200
    22.240    36.282     0.200
    22.356    35.321     0.200
    22.412    34.384     0.200
    22.433    36.984     0.200
    22.433    36.094     0.200
    22.442    36.081     0.200
    22.441    37.033     0.200
    22.483    36.479     0.200
    22.526    36.397     0.200
    22.563    36.681     0.200
    22.567    36.880     0.200
    22.566    36.064     0.200
    22.566    36.654     0.200
    22.594    36.668     0.200
    22.650    35.620     0.200
    22.712    34.641     0.200
    22.751    35.648     0.200
    22.751    35.926     0.200
    22.752    35.444     0.200
    22.861    35.845     0.200
    22.853    36.370     0.200
    22.902    35.819     0.200
    22.988    34.655     0.200
    23.018    35.213     0.200
    23.107    34.673     0.200
    23.113    33.747     0.200
    23.119    33.402     0.200
    23.153    35.086     0.200
    23.159    33.988     0.200
    23.168    36.220     0.200
    23.281    36.502     0.200
    23.341    34.941     0.200
    23.401    33.183     0.200
    23.419    35.208     0.200
    23.463    36.551     0.200
    23.465    35.434     0.200
    23.535    35.419     0.200
    23.553    37.090     0.200
    23.526    33.305     0.200
    23.526    34.227     0.200
    23.614    32.531     0.200
    23.614    34.062     0.200
    23.633    32.935     0.200
    23.656    31.204     0.200
    23.652    33.160     0.200
    23.708    33.343     0.200
    23.769    34.820     0.200
    23.794    34.478     0.200
    23.820    32.582     0.200
    23.820    34.426     0.200
    23.860    33.407     0.200
    23.885    32.427     0.200
    24.048    34.509     0.200
    24.065    34.489     0.200
    24.185    32.795     0.200
    24.216    32.265     0.200
    24.343    31.731     0.200
    24.382    30.940     0.200
    24.381    31.160     0.200
    24.409    33.593     0.200
    24.457    30.966     0.200
    24.509    30.670     0.200
    24.611    32.873     0.200
    24.649    32.058     0.200
    24.660    32.253     0.200
    24.720    31.429     0.200
    24.752    33.834     0.200
    24.769    33.793     0.200
    24.856    33.613     0.200
    24.957    32.180     0.200
    24.966    31.933     0.200
    24.975    32.147     0.200
    25.019    32.232     0.200
    25.011    30.732     0.200
    25.079    32.321     0.200
    25.201    29.039     0.200
    25.378    33.184     0.200
    25.441    28.182     0.200
    25.467    28.605     0.200
    25.501    27.803     0.200
    25.529    30.251     0.200
    25.576    31.009     0.200
    25.727    26.537     0.200
    25.860    28.228     0.200
    26.001    28.988     0.200
    26.080    31.760     0.200
    26.101    27.418     0.200
    26.205    27.343     0.200
    26.307    27.049     0.200
    26.391    27.725     0.200
    26.457    28.695     0.200
    26.465    27.756     0.200
    26.579    26.100     0.200
    26.645    27.965     0.200
    26.680    27.699     0.200
    26.715    26.407     0.200
    26.722    24.386     0.200
    26.841    24.705     0.200
    26.950    27.163     0.200
    26.976    26.842     0.200
    27.016    25.665     0.200
    27.481    25.949     0.200
    27.716    23.725     0.200
    27.716    24.393     0.200
    27.848    25.616     0.200
    28.016    22.234     0.200
    28.711    19.840     0.200
    28.991    21.989     0.200
    29.021    22.306     0.200
    29.166    21.252     0.200
    29.326    19.891     0.200
    29.517    18.907     0.200
    29.816    19.037     0.200
    29.816    19.186     0.200
    29.161    20.564     0.200
    14.210    45.481     0.200
    27.048    27.380     0.200
    21.138    38.921     0.200
    27.112    26.497     0.200
    15.100    40.668     0.200
    22.415    38.033     0.200
    15.124    43.476     0.200
    14.285    39.720     0.200
    14.285    41.884     0.200
    15.242    41.488     0.200
    19.414    39.198     0.200
    19.462    37.547     0.200
    19.524    38.092     0.200
    19.697    38.006     0.200
    19.959    37.380     0.200
    20.770    37.118     0.200
    21.259    36.411     0.200
    21.259    38.239     0.200
    22.418    37.843     0.200
    22.418    36.484     0.200
    22.685    36.416     0.200
    26.012    30.703     0.200
    28.584    21.938     0.200
    14.814    40.266     0.200
    15.022    40.492     0.200
    16.400    41.684     0.200
    16.656    40.576     0.200
    17.884    41.321     0.200
    17.884    41.770     0.200
    17.988    41.021     0.200
    18.557    40.541     0.200
    18.800    40.280     0.200
    19.185    40.351     0.200
    19.272    40.252     0.200
    19.610    40.403     0.200
    19.610    39.546     0.200
    19.788    40.356     0.200
    20.021    39.526     0.200
    20.058    39.776     0.200
    20.058    39.196     0.200
    20.164    38.591     0.200
    20.507    40.162     0.200
    20.932    37.798     0.200
    20.943    38.553     0.200
    21.410    39.174     0.200
    21.410    38.377     0.200
    21.485    39.319     0.200
    21.522    38.258     0.200
    21.661    38.535     0.200
    21.811    38.544     0.200
    22.383    35.278     0.200
    22.429    37.904     0.200
    22.587    34.846     0.200
    22.614    38.899     0.200
    22.614    36.004     0.200
    22.621    37.218     0.200
    22.763    36.011     0.200
    23.623    34.460     0.200
    23.689    35.169     0.200
    23.691    32.976     0.200
    23.838    34.840     0.200
    24.086    33.347     0.200
    24.396    33.674     0.200
    24.603    33.543     0.200
    24.603    32.931     0.200
    24.748    33.242     0.200
    24.917    32.860     0.200
    24.903    32.291     0.200
    25.236    31.549     0.200
    25.324    32.843     0.200
    25.367    32.366     0.200
    25.456    31.755     0.200
    25.517    29.970     0.200
    25.726    29.823     0.200
    25.859    29.512     0.200
    25.858    29.674     0.200
    26.140    29.469     0.200
    26.348    28.896     0.200
    26.458    27.759     0.200
    26.478    27.302     0.200
    26.615    30.148     0.200
    26.615    29.778     0.200
    26.913    26.665     0.200
    26.938    28.555     0.200
    27.013    25.705     0.200
    27.219    25.106     0.200
    27.466    25.561     0.200
    27.515    25.961     0.200
    27.743    23.365     0.200
    28.140    23.353     0.200
    28.855    23.252     0.200
    28.869    21.678     0.200
    28.879    21.871     0.200
    28.993    21.137     0.200
    29.091    22.628     0.200
    29.115    20.639     0.200
    29.179    22.656     0.200
    29.343    19.814     0.200
    29.522    18.589     0.200
    29.765    18.368     0.200
    29.905    19.742     0.200
    29.906    18.528     0.200
    27.240    29.030     0.200
    17.275    41.108     0.200
    14.984    41.858     0.200
    14.974    40.727     0.200
    20.372    37.170     0.200
    22.007    35.031     0.200
    15.308    41.137     0.200
    29.379    18.720     0.200
    22.170    38.378     0.200
    14.779    40.940     0.200
    15.477    41.954     0.200
    15.709    42.084     0.200
    16.354    42.265     0.200
    16.475    43.242     0.200
    17.398    41.650     0.200
    17.660    42.218     0.200
    17.725    42.819     0.200
    17.725    42.187     0.200
    18.787    41.530     0.200
    18.983    39.514     0.200
    19.305    40.983     0.200
    19.997    39.096     0.200
    20.449    40.906     0.200
    21.296    40.605     0.200
    21.595    40.388     0.200
    21.595    40.940     0.200
    21.821    39.425     0.200
    21.889    39.665     0.200
    22.738    39.604     0.200
    22.780    37.679     0.200
    23.037    39.025     0.200
    23.259    37.694     0.200
    23.606    35.765     0.200
    23.678    37.604     0.200
    24.600    34.085     0.200
    29.074    23.868     0.200
    20.777    38.732     0.200
    22.956    36.318     0.200
    26.627    27.461     0.200
    28.535    22.615     0.200
    16.271    43.569     0.200
    19.038    42.645     0.200
    21.409    41.199     0.200
    22.608    37.013     0.200
    22.608    40.138     0.200
    23.661    41.054     0.200
    24.251    37.789     0.200
    24.842    36.481     0.200
    25.309    35.069     0.200
    25.376    34.640     0.200
    25.397    34.366     0.200
    26.357    32.417     0.200
    26.558    31.664     0.200
    27.110    30.090     0.200
    27.566    29.037     0.200
    27.598    28.364     0.200
    27.636    27.717     0.200
    28.486    24.777     0.200
    28.798    24.252     0.200
    28.820    24.514     0.200
    29.048    22.120     0.200
    29.061    24.784     0.200
    29.119    24.224     0.200
    29.706    22.246     0.200
    29.836    21.857     0.200
    18.352    38.351     0.200
    18.445    37.336     0.200
    18.548    37.493     0.200
    19.073    37.719     0.200
    19.142    37.000     0.200
    19.978    37.449     0.200
    20.279    36.654     0.200
    21.064    38.000     0.200
    21.064    37.601     0.200
    21.384    37.070     0.200
    21.502    35.695     0.200
    22.744    36.854     0.200
    22.744    36.081     0.200
    23.849    33.980     0.200
    24.833    32.244     0.200
    25.430    30.901     0.200
    25.961    29.397     0.200
    25.977    29.592     0.200
    27.235    25.716     0.200
    27.440    25.182     0.200
    27.533    25.288     0.200
    27.629    24.768     0.200
    28.134    23.091     0.200
    28.178    22.373     0.200
    28.196    22.816     0.200
    28.458    22.262     0.200
    29.057    20.728     0.200
    29.362    19.306     0.200
    29.397    18.959     0.200
    29.500    20.265     0.200
    29.500    19.476     0.200
    29.599    18.667     0.200
    29.700    18.650     0.200
    15.190    43.077     0.200
    15.334    43.125     0.200
    17.353    42.268     0.200
    21.068    38.581     0.200
    21.166    38.798     0.200
    21.236    37.743     0.200
    22.337    37.046     0.200
    23.009    35.749     0.200
    23.656    34.607     0.200
    23.921    34.541     0.200
    25.996    29.090     0.200
    28.705    21.285     0.200
    26.442    31.160     0.200
    15.237    42.448     0.200
    18.271    42.336     0.200
    18.372    43.155     0.200
    18.801    40.308     0.200
    19.805    39.405     0.200
    20.221    39.024     0.200
    20.420    38.315     0.200
    21.158    39.520     0.200
    21.265    38.427     0.200
    21.265    40.417     0.200
    21.755    37.864     0.200
    21.953    37.638     0.200
    22.525    38.643     0.200
    22.525    37.253     0.200
    29.462    20.743     0.200
    15.245    41.622     0.200
    16.583    40.577     0.200
    18.367    40.816     0.200
    27.470    25.209     0.200
    15.224    42.432     0.200
    25.027    30.709     0.200
    26.051    28.353     0.200
    27.482    25.123     0.200
    28.017    23.630     0.200
    28.200    22.131     0.200
    15.229    41.113     0.200
    15.091    44.175     0.200
    22.882    39.813     0.200
    14.199    40.729     0.200
    15.140    42.642     0.200
    15.482    39.744     0.200
    15.482    43.756     0.200
    18.221    41.285     0.200
    18.804    35.531     0.200
    19.552    35.065     0.200
    19.630    35.549     0.200
    20.129    35.223     0.200
    20.342    36.395     0.200
    20.401    35.144     0.200
    20.423    34.714     0.200
    21.065    39.097     0.200
    21.201    34.968     0.200
    21.201    39.132     0.200
    21.201    38.710     0.200
    21.591    34.256     0.200
    21.829    33.909     0.200
    21.967    34.316     0.200
    22.170    33.207     0.200
    22.279    39.031     0.200
    22.303    33.806     0.200
    22.456    37.984     0.200
    22.456    37.562     0.200
    22.456    37.359     0.200
    22.671    34.165     0.200
    22.884    33.767     0.200
    22.930    33.629     0.200
    23.157    33.143     0.200
    23.464    33.821     0.200
    23.619    32.627     0.200
    23.619    32.890     0.200
    23.619    35.711     0.200
    23.619    36.492     0.200
    24.741    30.404     0.200
    25.031    29.171     0.200
    25.069    29.072     0.200
    25.122    28.278     0.200
    26.172    25.092     0.200
    28.177    19.527     0.200
    28.405    18.594     0.200
    28.606    17.929     0.200
    28.685    18.559     0.200
    29.039    15.028     0.200
    29.368    21.477     0.200
    29.368    22.200     0.200
    29.437    16.501     0.200
    29.610    15.529     0.200
    15.137    42.145     0.200
    15.397    42.408     0.200
    15.611    41.725     0.200
    15.671    41.683     0.200
    15.812    42.642     0.200
    15.080    44.961     0.200
    27.575    28.501     0.200
    29.309    21.614     0.200
    15.196    42.183     0.200
    14.775    41.679     0.200
    22.581    37.240     0.200
    29.052    21.353     0.200
    19.849    36.318     0.200
    21.348    35.457     0.200
    23.891    30.996     0.200
    29.207    24.017     0.200
    18.656    39.670     0.200
    18.964    39.458     0.200
    19.414    39.244     0.200
    19.993    38.928     0.200
    20.118    38.838     0.200
    20.905    38.420     0.200
    21.414    37.678     0.200
    21.651    36.971     0.200
    22.129    36.952     0.200
    22.436    36.526     0.200
    22.622    37.441     0.200
    22.622    36.496     0.200
    23.365    34.854     0.200
    23.608    34.761     0.200
    24.739    31.730     0.200
    29.119    21.098     0.200
    29.127    21.897     0.200
    29.127    21.385     0.200
    21.705    37.223     0.200
    22.881    35.017     0.200
    22.889    36.450     0.200
    23.781    35.141     0.200
    29.159    21.539     0.200
    29.159    21.094     0.200
    15.090    41.927     0.200
    18.771    38.877     0.200
    18.859    39.515     0.200
    18.940    38.884     0.200
    20.075    37.844     0.200
    20.304    38.319     0.200
    20.359    37.938     0.200
    21.145    39.027     0.200
    22.399    38.287     0.200
    23.562    35.371     0.200
    29.316    21.361     0.200
    15.085    42.287     0.200
    18.335    40.943     0.200
    20.357    39.743     0.200
    21.141    38.890     0.200
    22.395    38.858     0.200
    23.557    36.385     0.200
    29.310    22.469     0.200
    15.108    42.362     0.200
    15.723    44.502     0.200
    17.068    43.355     0.200
    29.333    23.914     0.200
    29.389    20.394     0.200
    16.911    40.172     0.200
    18.432    38.842     0.200
    18.535    38.675     0.200
    18.699    38.265     0.200
    19.836    38.528     0.200
    20.271    39.803     0.200
    21.371    36.464     0.200
    21.490    36.946     0.200
    21.558    36.673     0.200
    22.077    36.109     0.200
    22.270    36.747     0.200
    22.496    36.874     0.200
    23.264    34.896     0.200
    15.175    42.364     0.200
    15.236    43.639     0.200
    15.705    42.018     0.200
    16.568    40.996     0.200
    17.275    41.837     0.200
    17.704    42.179     0.200
    19.417    40.900     0.200
    20.111    40.615     0.200
    20.794    40.390     0.200
    20.911    39.750     0.200
    21.552    40.404     0.200
    22.523    38.426     0.200
    22.739    36.355     0.200
    23.286    37.233     0.200
    24.670    33.830     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.947     6.625     0.200
     1.114     7.251     0.200
     1.128     7.245     0.200
     1.200     7.108     0.200
     1.384     7.707     0.200
     1.418     7.871     0.200
     1.592     8.176     0.200
     1.690     8.558     0.200
     1.715     8.820     0.200
     1.869     7.971     0.200
     1.862     8.563     0.200
     1.955     8.981     0.200
     1.969     8.802     0.200
     1.984     8.785     0.200
     2.051     9.250     0.200
     2.177    10.280     0.200
     2.180     9.834     0.200
     2.202     9.481     0.200
     2.238    10.238     0.200
     2.269     9.687     0.200
     2.374    10.452     0.200
     2.522    10.382     0.200
     2.560    10.048     0.200
     2.633     9.549     0.200
     2.607    10.555     0.200
     2.679    10.334     0.200
     2.701    11.344     0.200
     2.741    10.785     0.200
     2.771    10.457     0.200
     2.841    11.368     0.200
     2.881    11.575     0.200
     3.175    12.302     0.200
     3.270    11.707     0.200
     3.377    11.174     0.200
     3.611    12.776     0.200
     3.840    11.831     0.200
     3.816    13.311     0.200
     3.920    14.081     0.200
     4.104    14.457     0.200
     4.141    14.937     0.200
     4.156    14.986     0.200
     4.266    16.242     0.200
     4.296    14.404     0.200
     4.393    14.839     0.200
     4.411    16.349     0.200
     4.445    16.070     0.200
     4.466    16.149     0.200
     4.587    14.759     0.200
     4.582    15.335     0.200
     4.873    16.395     0.200
     5.035    17.378     0.200
     5.345    17.415     0.200
     5.402    18.122     0.200
     5.550    17.956     0.200
     5.550    18.269     0.200
     5.725    17.604     0.200
     5.816    19.316     0.200
     6.802    20.117     0.200
     6.967    19.793     0.200
     6.993    21.162     0.200
     7.042    19.614     0.200
     7.090    20.299     0.200
     7.587    23.324     0.200
     8.044    22.941     0.200
     8.931    24.168     0.200
     9.228    24.305     0.200
     9.482    23.753     0.200
     9.911    27.341     0.200
    10.377    28.557     0.200
    10.377    31.885     0.200
    11.448    29.808     0.200
    11.448    30.063     0.200
    12.535    35.029     0.200
     0.990     6.934     0.200
     1.209     7.123     0.200
     1.198     8.001     0.200
     1.233     7.658     0.200
     1.248     7.694     0.200
     1.261     8.150     0.200
     1.509     9.022     0.200
     1.513     8.652     0.200
     1.591     8.274     0.200
     1.577    10.217     0.200
     1.581     8.819     0.200
     1.745     8.619     0.200
     1.768     8.687     0.200
     1.790     9.131     0.200
     1.904     8.931     0.200
     1.980     8.838     0.200
     2.066     9.852     0.200
     2.098     9.586     0.200
     2.164    10.298     0.200
     2.277    10.047     0.200
     2.319     8.897     0.200
     2.425    10.314     0.200
     2.504    10.819     0.200
     2.547    10.978     0.200
     2.636    10.821     0.200
     2.664    10.462     0.200
     2.694    11.134     0.200
     2.768    10.506     0.200
     2.814    11.355     0.200
     2.853    11.164     0.200
     2.906    11.784     0.200
     2.900    11.849     0.200
     3.074    12.158     0.200
     3.074    13.236     0.200
     3.078    12.008     0.200
     3.102    12.233     0.200
     3.152    12.363     0.200
     3.222    11.896     0.200
     3.261    13.186     0.200
     3.348    12.197     0.200
     3.429    12.040     0.200
     3.460    14.186     0.200
     3.506    14.227     0.200
     3.530    12.348     0.200
     3.552    14.055     0.200
     3.630    14.179     0.200
     3.662    14.319     0.200
     3.747    15.176     0.200
     3.846    14.446     0.200
     3.934    14.020     0.200
     3.935    15.187     0.200
     3.993    13.014     0.200
     3.990    14.365     0.200
     3.972    15.871     0.200
     4.023    13.144     0.200
     4.051    15.058     0.200
     4.058    15.761     0.200
     4.080    15.437     0.200
     4.100    15.177     0.200
     4.121    14.004     0.200
     4.167    15.069     0.200
     4.225    14.922     0.200
     4.240    15.230     0.200
     4.278    16.734     0.200
     4.279    16.375     0.200
     4.308    14.727     0.200
     4.308    16.612     0.200
     4.342    16.225     0.200
     4.406    13.858     0.200
     4.430    16.226     0.200
     4.418    16.100     0.200
     4.469    14.681     0.200
     4.499    16.259     0.200
     4.501    14.664     0.200
     4.511    16.613     0.200
     4.655    15.328     0.200
     4.696    16.313     0.200
     4.745    17.298     0.200
     4.762    14.667     0.200
     4.809    14.402     0.200
     4.820    15.189     0.200
     4.829    16.458     0.200
     4.857    20.432     0.200
     4.919    18.330     0.200
     4.939    17.520     0.200
     4.995    15.344     0.200
     5.050    15.513     0.200
     5.139    16.509     0.200
     5.216    16.367     0.200
     5.227    17.689     0.200
     5.367    16.304     0.200
     5.364    19.329     0.200
     5.480    16.834     0.200
     5.664    19.720     0.200
     5.775    17.203     0.200
     5.744    19.536     0.200
     5.782    20.382     0.200
     5.883    18.223     0.200
     6.349    18.831     0.200
     6.493    20.807     0.200
     6.601    21.223     0.200
     6.745    23.246     0.200
     6.749    20.598     0.200
     6.872    21.464     0.200
     6.917    24.657     0.200
     6.911    23.550     0.200
     6.950    22.487     0.200
     7.113    23.738     0.200
     7.339    22.663     0.200
     7.510    23.839     0.200
     7.538    25.489     0.200
     7.633    24.602     0.200
     7.959    23.912     0.200
     8.002    22.388     0.200
     8.129    24.816     0.200
     8.350    23.846     0.200
     8.553    29.317     0.200
     9.124    26.410     0.200
     9.367    25.614     0.200
     9.516    29.418     0.200
     9.780    27.871     0.200
    10.080    29.246     0.200
    10.301    30.601     0.200
    10.664    34.156     0.200
    10.819    33.084     0.200
    11.605    31.264     0.200
    14.883    39.723     0.200
    20.956    40.045     0.200
     0.887     6.256     0.200
     1.327     8.486     0.200
     1.351     8.108     0.200
     1.478     9.566     0.200
     1.521     9.551     0.200
     1.700     8.412     0.200
     1.727     8.490     0.200
     1.741     8.931     0.200
     1.961     8.231     0.200
     1.994     8.693     0.200
     2.268    10.268     0.200
     2.320    10.018     0.200
     2.384    10.325     0.200
     2.624    10.116     0.200
     2.681    10.777     0.200
     2.768    11.400     0.200
     2.793    11.019     0.200
     2.967    11.376     0.200
     2.979    10.376     0.200
     3.226    11.527     0.200
     3.165    12.128     0.200
     3.227    13.201     0.200
     3.238    13.295     0.200
     3.252    11.913     0.200
     3.232    12.436     0.200
     3.306    12.738     0.200
     3.467    12.873     0.200
     3.508    13.939     0.200
     3.710    12.710     0.200
     3.719    14.019     0.200
     3.830    14.256     0.200
     3.830    14.485     0.200
     3.906    13.793     0.200
     4.063    14.275     0.200
     4.062    14.939     0.200
     4.403    14.153     0.200
     4.513    14.458     0.200
     4.520    14.366     0.200
     4.561    16.594     0.200
     5.040    17.759     0.200
     6.043    18.627     0.200
     6.243    23.400     0.200
     7.420    22.716     0.200
     7.756    24.279     0.200
     7.892    22.539     0.200
    10.915    33.478     0.200
    11.259    31.821     0.200
     0.838     6.007     0.200
     1.304     7.387     0.200
     1.275     8.210     0.200
     1.386     8.298     0.200
     1.492     8.236     0.200
     1.496     9.121     0.200
     1.542     9.666     0.200
     1.556     9.165     0.200
     1.643     7.853     0.200
     1.611     9.806     0.200
     1.637     8.657     0.200
     1.820     8.595     0.200
     1.757     9.429     0.200
     1.811     9.492     0.200
     1.875     9.934     0.200
     1.917    10.010     0.200
     2.018     9.739     0.200
     2.035     9.817     0.200
     2.109     9.304     0.200
     2.225     9.212     0.200
     2.214    10.229     0.200
     2.214    11.114     0.200
     2.271    10.348     0.200
     2.271    10.533     0.200
     2.268    10.454     0.200
     2.357     8.904     0.200
     2.358     9.203     0.200
     2.465    10.452     0.200
     2.454    10.870     0.200
     2.534    11.232     0.200
     2.574    11.064     0.200
     2.574    11.483     0.200
     2.583    11.445     0.200
     2.635    11.077     0.200
     2.695    11.286     0.200
     2.742    11.732     0.200
     2.769    11.136     0.200
     2.769    11.790     0.200
     2.921    10.659     0.200
     2.939    10.624     0.200
     2.970    11.751     0.200
     3.079    10.942     0.200
     3.136    12.141     0.200
     3.100    12.395     0.200
     3.133    12.683     0.200
     3.235    13.244     0.200
     3.303    12.797     0.200
     3.272    12.980     0.200
     3.414    12.094     0.200
     3.372    12.942     0.200
     3.476    12.469     0.200
     3.470    13.462     0.200
     3.526    13.519     0.200
     3.628    12.593     0.200
     3.602    13.349     0.200
     3.659    13.402     0.200
     3.621    12.936     0.200
     3.659    12.989     0.200
     3.876    14.443     0.200
     4.006    14.766     0.200
     4.090    13.513     0.200
     4.133    15.169     0.200
     4.176    14.261     0.200
     4.210    13.320     0.200
     4.253    15.263     0.200
     4.282    15.007     0.200
     4.357    16.158     0.200
     4.399    15.635     0.200
     4.453    15.908     0.200
     4.471    17.033     0.200
     4.536    16.178     0.200
     4.544    16.138     0.200
     4.639    16.408     0.200
     4.693    14.926     0.200
     4.680    17.507     0.200
     4.680    17.162     0.200
     4.813    17.381     0.200
     4.883    15.146     0.200
     4.906    14.785     0.200
     4.836    17.791     0.200
     4.882    17.363     0.200
     4.945    17.433     0.200
     4.983    17.236     0.200
     5.043    17.405     0.200
     5.072    17.487     0.200
     5.100    17.713     0.200
     5.144    18.285     0.200
     5.155    18.191     0.200
     5.140    18.326     0.200
     5.195    18.555     0.200
     5.262    17.454     0.200
     5.370    17.120     0.200
     5.391    16.534     0.200
     5.508    16.727     0.200
     5.514    17.164     0.200
     5.584    16.648     0.200
     5.597    17.264     0.200
     5.821    17.684     0.200
     6.020    18.532     0.200
     6.026    19.390     0.200
     6.042    18.550     0.200
     6.038    19.003     0.200
     6.100    19.888     0.200
     6.133    19.941     0.200
     6.702    19.437     0.200
     7.343    21.864     0.200
     7.411    21.140     0.200
     9.508    25.787     0.200
     9.552    27.027     0.200
    10.773    33.996     0.200
    11.671    31.809     0.200
     0.861     6.010     0.200
     0.837     6.163     0.200
     1.491     8.409     0.200
     1.640     7.929     0.200
     1.545     9.277     0.200
     1.559     9.271     0.200
     1.614     9.836     0.200
     1.641     8.781     0.200
     1.761    10.991     0.200
     1.815     9.704     0.200
     1.974     9.987     0.200
     2.015     9.834     0.200
     2.035     9.786     0.200
     2.221     9.369     0.200
     2.217    10.437     0.200
     2.354     9.360     0.200
     2.354     9.462     0.200
     2.270    10.546     0.200
     2.274    10.349     0.200
     2.462    10.507     0.200
     2.454    10.907     0.200
     2.533    11.233     0.200
     2.633    11.162     0.200
     2.578    11.122     0.200
     2.692    11.284     0.200
     2.744    11.646     0.200
     2.708    11.406     0.200
     2.771    11.621     0.200
     2.771    11.973     0.200
     2.917    11.235     0.200
     2.935    11.009     0.200
     2.970    12.259     0.200
     3.076    11.239     0.200
     3.133    12.421     0.200
     3.099    12.962     0.200
     3.149    12.751     0.200
     3.136    13.329     0.200
     3.300    13.198     0.200
     3.371    13.172     0.200
     3.410    12.561     0.200
     3.472    12.781     0.200
     3.523    13.294     0.200
     3.625    12.803     0.200
     3.601    13.777     0.200
     3.655    13.544     0.200
     3.622    14.380     0.200
     3.873    14.688     0.200
     4.004    14.982     0.200
     4.131    15.083     0.200
     4.172    14.399     0.200
     4.206    13.603     0.200
     4.251    15.769     0.200
     4.279    15.065     0.200
     4.396    15.624     0.200
     4.356    16.177     0.200
     4.471    16.340     0.200
     4.533    16.192     0.200
     4.542    16.428     0.200
     4.638    16.540     0.200
     4.677    16.516     0.200
     4.677    17.298     0.200
     4.690    15.055     0.200
     4.781    16.226     0.200
     4.811    16.583     0.200
     4.902    15.395     0.200
     4.880    17.157     0.200
     5.007    16.249     0.200
     4.981    16.762     0.200
     5.152    17.603     0.200
     5.139    18.184     0.200
     5.367    17.119     0.200
     5.504    16.800     0.200
     5.596    17.716     0.200
     5.586    19.349     0.200
     5.818    17.716     0.200
     6.016    18.746     0.200
     6.023    19.051     0.200
     6.039    18.583     0.200
     6.099    19.674     0.200
     6.131    22.433     0.200
     7.342    22.721     0.200
     7.508    20.643     0.200
     1.059     7.156     0.200
     1.373     8.884     0.200
     1.433     8.059     0.200
     1.394     8.497     0.200
     1.503     8.229     0.200
     1.574     7.944     0.200
     1.623     8.680     0.200
     1.662     9.627     0.200
     1.766     8.039     0.200
     1.766     8.371     0.200
     1.795     9.742     0.200
     1.899     9.787     0.200
     1.899    10.275     0.200
     1.929     8.861     0.200
     1.969     8.530     0.200
     2.084    10.438     0.200
     2.079    10.126     0.200
     2.140    10.304     0.200
     2.250     9.570     0.200
     2.295    11.155     0.200
     2.359     9.930     0.200
     2.402     9.950     0.200
     2.439    11.148     0.200
     2.545    10.676     0.200
     2.530    11.418     0.200
     2.600    11.492     0.200
     2.701    10.222     0.200
     2.703     9.957     0.200
     2.807    12.093     0.200
     2.936    11.704     0.200
     2.964    12.415     0.200
     2.957    12.388     0.200
     3.095    13.199     0.200
     3.156    12.541     0.200
     3.247    11.790     0.200
     3.281    11.380     0.200
     3.425    11.810     0.200
     3.509    14.110     0.200
     3.749    12.270     0.200
     3.804    13.077     0.200
     3.944    12.842     0.200
     4.084    16.121     0.200
     4.436    14.080     0.200
     4.507    14.863     0.200
     4.505    15.884     0.200
     4.551    14.099     0.200
     4.599    15.463     0.200
     4.692    16.104     0.200
     4.796    14.858     0.200
     4.756    16.637     0.200
     4.967    16.422     0.200
     4.946    17.308     0.200
     4.946    17.819     0.200
     4.959    17.540     0.200
     4.959    17.688     0.200
     5.028    15.213     0.200
     5.052    18.563     0.200
     5.106    16.940     0.200
     5.104    17.863     0.200
     5.228    15.747     0.200
     5.251    15.911     0.200
     5.226    18.626     0.200
     5.330    17.486     0.200
     5.351    16.632     0.200
     5.351    18.426     0.200
     5.386    17.246     0.200
     5.403    18.535     0.200
     5.437    18.601     0.200
     5.593    18.913     0.200
     5.705    17.623     0.200
     5.833    18.609     0.200
     5.853    17.574     0.200
     5.945    18.293     0.200
     5.952    19.948     0.200
     6.011    20.188     0.200
     6.061    20.205     0.200
     6.116    19.348     0.200
     6.126    19.862     0.200
     6.163    18.428     0.200
     6.194    20.491     0.200
     6.238    23.252     0.200
     6.278    22.009     0.200
     6.360    19.187     0.200
     6.358    19.877     0.200
     6.362    19.541     0.200
     6.386    18.989     0.200
     6.393    20.589     0.200
     6.435    21.018     0.200
     6.581    19.366     0.200
     6.767    21.673     0.200
     6.800    21.482     0.200
     6.908    22.048     0.200
     6.937    20.541     0.200
     6.921    22.583     0.200
     6.983    22.337     0.200
     6.996    22.532     0.200
     7.024    21.435     0.200
     7.086    21.582     0.200
     7.108    21.673     0.200
     7.207    20.460     0.200
     7.372    22.209     0.200
     7.426    24.823     0.200
     7.462    22.814     0.200
     7.583    23.809     0.200
     7.601    23.231     0.200
     7.582    25.634     0.200
     7.672    22.865     0.200
     7.688    22.155     0.200
     7.691    22.345     0.200
     7.733    23.198     0.200
     7.771    24.623     0.200
     8.090    24.610     0.200
     8.156    24.906     0.200
     8.168    24.325     0.200
     8.260    23.416     0.200
     8.286    23.458     0.200
     8.325    25.545     0.200
     8.543    24.283     0.200
     8.739    24.426     0.200
     8.739    25.453     0.200
     8.897    24.961     0.200
     9.017    25.213     0.200
     9.116    26.631     0.200
     9.531    26.294     0.200
     9.616    26.047     0.200
     9.781    28.660     0.200
    10.887    31.742     0.200
    12.014    31.911     0.200
     1.058     7.253     0.200
     1.206     7.581     0.200
     1.224     7.713     0.200
     1.294     7.371     0.200
     1.283     7.695     0.200
     1.377     8.738     0.200
     1.431     8.431     0.200
     1.400     8.559     0.200
     1.580     8.007     0.200
     1.629     8.680     0.200
     1.664     9.692     0.200
     1.769     8.074     0.200
     1.769     7.792     0.200
     1.800     9.704     0.200
     1.899     9.508     0.200
     1.899     9.837     0.200
     1.926     9.168     0.200
     1.975     8.577     0.200
     2.087    10.308     0.200
     2.085    10.089     0.200
     2.147    10.245     0.200
     2.295    10.739     0.200
     2.356    10.052     0.200
     2.445    10.938     0.200
     2.532    11.331     0.200
     2.532    11.226     0.200
     2.604    11.541     0.200
     2.705    11.196     0.200
     2.707    10.087     0.200
     2.805    12.124     0.200
     2.942    11.721     0.200
     3.098    12.819     0.200
     3.155    12.783     0.200
     3.252    11.993     0.200
     3.285    11.689     0.200
     3.428    11.850     0.200
     3.809    13.183     0.200
     3.978    13.684     0.200
     4.512    14.963     0.200
     4.511    15.793     0.200
     4.605    15.448     0.200
     4.762    16.630     0.200
     4.951    17.551     0.200
     4.953    17.683     0.200
     4.965    17.274     0.200
     4.965    17.118     0.200
     5.111    17.517     0.200
     5.232    18.415     0.200
     5.443    18.637     0.200
     5.600    18.987     0.200
     5.839    18.735     0.200
     5.958    20.067     0.200
     6.018    20.414     0.200
     6.068    20.218     0.200
     6.122    20.479     0.200
     6.200    20.369     0.200
     6.365    19.276     0.200
     6.363    19.946     0.200
     6.399    20.560     0.200
     6.441    21.112     0.200
     6.773    21.695     0.200
     6.806    21.681     0.200
     7.091    21.280     0.200
     7.677    22.996     0.200
     1.218     6.837     0.200
     1.270     7.442     0.200
     1.239     6.910     0.200
     1.401     7.304     0.200
     1.403     7.153     0.200
     1.350     7.662     0.200
     1.457     7.701     0.200
     1.576     7.772     0.200
     1.656     7.728     0.200
     1.756     6.936     0.200
     1.718     8.170     0.200
     1.781     9.208     0.200
     1.812     6.634     0.200
     1.827     9.999     0.200
     1.832     8.926     0.200
     1.860     8.928     0.200
     1.941     9.508     0.200
     2.110     9.228     0.200
     2.121     9.457     0.200
     2.160     9.076     0.200
     2.156     9.457     0.200
     2.156     9.121     0.200
     2.197    10.995     0.200
     2.232     9.067     0.200
     2.348     8.764     0.200
     2.349    10.554     0.200
     2.370     9.428     0.200
     2.423     9.637     0.200
     2.785    11.261     0.200
     2.785    10.374     0.200
     2.872    10.726     0.200
     3.079    11.355     0.200
     3.121    11.343     0.200
     3.240    11.870     0.200
     3.240    11.448     0.200
     3.312    12.307     0.200
     3.495    11.500     0.200
     3.714    13.437     0.200
     3.746    13.103     0.200
     3.723    13.586     0.200
     3.894    14.064     0.200
     4.035    14.009     0.200
     4.202    15.004     0.200
     4.226    16.402     0.200
     4.226    14.340     0.200
     4.302    12.777     0.200
     4.630    18.217     0.200
     4.644    16.674     0.200
     4.834    18.136     0.200
     5.456    20.231     0.200
     5.498    18.144     0.200
     5.809    16.839     0.200
     5.931    19.637     0.200
     6.003    17.691     0.200
     6.034    17.419     0.200
     6.025    18.785     0.200
     6.149    18.021     0.200
     6.179    18.079     0.200
     6.257    17.867     0.200
     6.268    18.192     0.200
     6.426    18.939     0.200
     6.743    19.421     0.200
     6.768    19.668     0.200
     6.849    19.771     0.200
     6.995    19.906     0.200
     7.084    20.898     0.200
     7.152    20.677     0.200
     7.189    24.117     0.200
     7.243    23.433     0.200
     7.249    19.971     0.200
     7.352    21.118     0.200
     7.357    21.117     0.200
     7.358    22.738     0.200
     7.416    24.158     0.200
     7.450    22.731     0.200
     7.512    20.777     0.200
     7.555    22.375     0.200
     7.643    22.202     0.200
     7.652    22.423     0.200
     7.872    23.461     0.200
     7.872    22.555     0.200
     7.935    24.722     0.200
     8.035    24.041     0.200
     8.109    22.559     0.200
     8.670    23.104     0.200
     8.762    23.129     0.200
     8.884    23.824     0.200
     8.905    23.887     0.200
     8.905    23.594     0.200
     9.180    25.334     0.200
     9.286    25.420     0.200
     9.325    25.024     0.200
     9.654    26.896     0.200
     9.965    27.977     0.200
    10.049    26.365     0.200
    10.074    29.487     0.200
    10.109    27.820     0.200
    10.274    28.686     0.200
    10.397    28.411     0.200
    10.591    30.943     0.200
    10.610    33.187     0.200
    10.730    29.247     0.200
    10.810    28.749     0.200
    10.821    33.995     0.200
    10.857    28.690     0.200
    11.070    29.789     0.200
    11.203    34.183     0.200
    11.439    34.615     0.200
    11.767    29.987     0.200
    11.967    31.616     0.200
    12.034    31.897     0.200
    13.558    34.377     0.200
    13.705    34.547     0.200
    13.843    35.299     0.200
    14.006    35.633     0.200
    14.230    36.541     0.200
    14.448    35.585     0.200
    14.529    36.628     0.200
    14.959    35.474     0.200
    15.363    36.726     0.200
    15.778    38.914     0.200
    18.439    40.880     0.200
     1.213     7.175     0.200
     1.250     7.693     0.200
     1.252     7.318     0.200
     1.375     7.774     0.200
     1.742     7.325     0.200
     1.758     9.663     0.200
     1.787     7.504     0.200
     1.911    10.501     0.200
     1.852     8.978     0.200
     2.139    10.836     0.200
     2.186    11.793     0.200
     2.257    10.091     0.200
     2.215    10.845     0.200
     2.343     9.208     0.200
     2.373     9.380     0.200
     2.367    11.090     0.200
     2.447     9.894     0.200
     2.811     9.643     0.200
     3.108    11.601     0.200
     3.265    13.773     0.200
     3.341    13.879     0.200
     3.490    13.655     0.200
     3.750    13.487     0.200
     4.237    15.765     0.200
     4.290    15.299     0.200
     4.668    17.948     0.200
     4.859    19.103     0.200
     5.933    19.705     0.200
     5.955    21.237     0.200
     7.096    21.977     0.200
     7.173    25.424     0.200
     7.528    22.345     0.200
     7.571    21.770     0.200
     7.642    21.798     0.200
     7.874    22.637     0.200
     8.895    25.032     0.200
     9.196    27.824     0.200
     9.646    27.125     0.200
    10.634    33.275     0.200
    11.056    30.733     0.200
     1.376     8.730     0.200
     1.413     7.986     0.200
     1.421     9.151     0.200
     1.515     9.643     0.200
     1.586     6.463     0.200
     1.619     9.617     0.200
     1.679     8.306     0.200
     1.666     9.452     0.200
     1.725    10.119     0.200
     2.077    10.677     0.200
     2.138    10.793     0.200
     2.342    12.766     0.200
     2.341    11.435     0.200
     2.942    13.535     0.200
     4.764    17.945     0.200
     4.979    16.243     0.200
     5.153    18.374     0.200
    14.729    38.114     0.200
     0.905     6.643     0.200
     0.985     6.530     0.200
     0.975     7.033     0.200
     1.089     6.663     0.200
     1.066     7.445     0.200
     1.154     7.567     0.200
     1.169     8.197     0.200
     1.204     8.375     0.200
     1.264     7.230     0.200
     1.304     7.841     0.200
     1.268     8.991     0.200
     1.324     7.871     0.200
     1.332     8.919     0.200
     1.367     8.230     0.200
     1.478     8.193     0.200
     1.488     7.650     0.200
     1.630     9.706     0.200
     1.623     9.991     0.200
     1.678     9.153     0.200
     1.678     9.364     0.200
     1.784     9.469     0.200
     1.861     9.120     0.200
     1.977     8.699     0.200
     1.977     8.515     0.200
     1.951    10.620     0.200
     2.009     8.807     0.200
     1.997    10.272     0.200
     2.116    10.685     0.200
     2.253    10.374     0.200
     2.359    11.614     0.200
     2.558    12.310     0.200
     2.576    11.905     0.200
     2.749    11.081     0.200
     2.912    12.645     0.200
     3.022    13.291     0.200
     3.040    13.636     0.200
     3.257    11.931     0.200
     3.998    13.414     0.200
     4.103    16.166     0.200
     4.516    16.163     0.200
     4.501    16.357     0.200
     4.501    16.598     0.200
     4.566    15.458     0.200
     4.562    17.186     0.200
     4.598    16.999     0.200
     4.588    17.631     0.200
     4.629    16.017     0.200
     4.744    17.095     0.200
     4.823    16.809     0.200
     4.823    17.218     0.200
     4.932    17.594     0.200
     4.959    19.061     0.200
     5.409    15.953     0.200
     5.802    18.943     0.200
     5.912    19.966     0.200
     6.041    20.127     0.200
     6.055    21.296     0.200
     6.373    19.835     0.200
     6.454    20.495     0.200
     6.496    22.451     0.200
     7.025    22.511     0.200
     7.027    21.196     0.200
     7.122    21.658     0.200
     7.268    21.230     0.200
     7.586    20.554     0.200
     7.601    24.190     0.200
     7.788    22.903     0.200
     7.841    23.218     0.200
     7.938    24.603     0.200
     8.119    23.435     0.200
     8.339    25.073     0.200
     8.448    26.087     0.200
     8.454    24.192     0.200
     8.546    25.971     0.200
     8.699    26.112     0.200
     8.699    26.506     0.200
     9.658    27.998     0.200
     9.680    28.013     0.200
     9.775    30.429     0.200
     9.971    27.233     0.200
    10.509    31.354     0.200
    12.202    33.487     0.200
    14.281    39.266     0.200
     1.121     7.816     0.200
     1.349     8.592     0.200
     1.542     7.977     0.200
     1.479     8.984     0.200
     1.646    10.277     0.200
     1.713     7.986     0.200
     1.768     9.185     0.200
     1.879     9.090     0.200
     1.872    10.811     0.200
     1.922    10.714     0.200
     2.196     8.931     0.200
     2.266     9.836     0.200
     2.331    11.452     0.200
     2.889    10.608     0.200
     3.175    10.710     0.200
     3.184    14.096     0.200
     3.640    14.066     0.200
     4.754    14.629     0.200
     4.837    17.076     0.200
     5.117    16.219     0.200
     5.165    18.192     0.200
     5.345    19.536     0.200
     5.380    19.316     0.200
     5.648    16.510     0.200
     5.894    19.209     0.200
     6.004    20.083     0.200
     6.039    20.105     0.200
     7.240    21.173     0.200
     7.694    23.221     0.200
     7.787    23.569     0.200
     8.111    24.798     0.200
     8.159    25.470     0.200
     8.455    24.457     0.200
    11.134    34.572     0.200
     1.282     8.165     0.200
     1.343     8.501     0.200
     1.354     8.893     0.200
     1.473     9.223     0.200
     1.544     7.886     0.200
     1.652     9.697     0.200
     1.773     8.881     0.200
     1.773     9.145     0.200
     1.878    10.620     0.200
     1.928    10.036     0.200
     2.082    11.876     0.200
     2.075    11.485     0.200
     2.192     8.992     0.200
     2.337    10.701     0.200
     2.886    10.469     0.200
     3.170    10.676     0.200
     3.190    12.880     0.200
     3.644    14.082     0.200
     4.750    14.556     0.200
     4.837    16.962     0.200
     5.169    17.482     0.200
     5.654    20.435     0.200
     5.893    18.017     0.200
     6.010    19.019     0.200
     6.045    18.970     0.200
     7.236    21.251     0.200
     7.460    23.220     0.200
     7.695    23.465     0.200
     7.721    23.374     0.200
     7.793    23.649     0.200
     8.112    24.119     0.200
     8.161    24.144     0.200
     8.453    22.716     0.200
     9.376    25.348     0.200
    11.465    31.473     0.200
    14.825    38.803     0.200
     0.962     7.073     0.200
     1.098     7.089     0.200
     1.305     7.321     0.200
     1.333     8.564     0.200
     1.422     9.882     0.200
     1.433     8.373     0.200
     1.522     8.277     0.200
     1.553     9.024     0.200
     1.599     8.755     0.200
     1.620     7.719     0.200
     1.671     8.339     0.200
     1.811    10.279     0.200
     1.833     9.500     0.200
     1.930     9.842     0.200
     1.977     9.948     0.200
     2.026     9.284     0.200
     2.077     9.822     0.200
     2.100     9.278     0.200
     2.270    10.732     0.200
     2.319    10.041     0.200
     2.328    10.663     0.200
     2.478    12.725     0.200
     2.502    11.152     0.200
     2.642    11.263     0.200
     2.749    10.865     0.200
     2.800    11.599     0.200
     2.829    11.604     0.200
     2.829    12.021     0.200
     3.034    12.566     0.200
     3.087    12.155     0.200
     3.187    13.857     0.200
     3.271    13.222     0.200
     3.285    13.507     0.200
     3.362    11.092     0.200
     3.362    11.387     0.200
     4.674    17.262     0.200
     4.716    16.668     0.200
     4.838    17.485     0.200
     4.862    14.501     0.200
     4.990    17.134     0.200
     5.252    18.906     0.200
     5.644    18.478     0.200
     5.656    18.224     0.200
     5.794    18.790     0.200
     6.133    20.491     0.200
     6.156    20.454     0.200
     7.053    20.884     0.200
     7.234    22.259     0.200
     7.306    20.828     0.200
     7.376    23.291     0.200
     7.397    23.504     0.200
     7.397    22.844     0.200
     7.418    22.311     0.200
     7.428    25.244     0.200
     7.509    23.653     0.200
     7.642    21.640     0.200
     7.875    24.386     0.200
     7.939    24.811     0.200
     7.988    23.700     0.200
     8.191    23.271     0.200
     8.182    24.034     0.200
     8.216    24.719     0.200
     8.398    24.417     0.200
     8.398    23.818     0.200
     8.680    28.123     0.200
     8.854    24.935     0.200
     9.057    28.621     0.200
     9.392    29.034     0.200
     9.558    28.275     0.200
     9.703    31.643     0.200
     9.893    29.262     0.200
    10.016    30.830     0.200
    10.248    30.062     0.200
    10.273    29.713     0.200
    10.778    32.449     0.200
    10.801    32.551     0.200
    10.801    33.179     0.200
    10.865    30.265     0.200
    11.168    34.163     0.200
    11.247    33.593     0.200
    11.323    34.189     0.200
    11.384    31.463     0.200
    11.624    30.949     0.200
    12.084    32.578     0.200
    12.780    35.500     0.200
    13.422    33.807     0.200
    14.218    35.900     0.200
    14.406    35.379     0.200
    14.405    35.693     0.200
    14.494    37.357     0.200
    14.567    37.743     0.200
    14.683    36.290     0.200
    15.078    37.360     0.200
    15.383    39.313     0.200
    15.518    39.402     0.200
    15.784    36.491     0.200
    17.155    38.721     0.200
    17.853    39.695     0.200
    18.977    40.761     0.200
    19.940    42.048     0.200
     1.265     7.959     0.200
     1.265     8.123     0.200
     1.269     8.170     0.200
     1.298     8.335     0.200
     1.330     8.354     0.200
     1.343     8.249     0.200
     1.406     9.340     0.200
     1.410     8.061     0.200
     1.410     8.498     0.200
     1.440     8.518     0.200
     1.491     8.969     0.200
     1.508     8.404     0.200
     1.529     8.114     0.200
     1.529     8.966     0.200
     1.526     8.461     0.200
     1.525     8.915     0.200
     1.525     8.745     0.200
     1.561     8.225     0.200
     1.526     8.045     0.200
     1.526     8.756     0.200
     1.593     9.749     0.200
     1.604     9.172     0.200
     1.605     7.940     0.200
     1.625     9.212     0.200
     1.609     9.283     0.200
     1.679     9.113     0.200
     1.683     9.335     0.200
     1.740     8.649     0.200
     1.740     9.493     0.200
     1.747     9.360     0.200
     1.775     9.011     0.200
     1.769    10.922     0.200
     1.766     9.490     0.200
     1.892     9.393     0.200
     1.913     9.532     0.200
     1.913     9.907     0.200
     1.926     9.956     0.200
     1.953     7.477     0.200
     2.012     9.764     0.200
     2.056     9.567     0.200
     2.064     9.511     0.200
     2.064    10.183     0.200
     2.126    10.492     0.200
     2.134    10.506     0.200
     2.136    10.476     0.200
     2.199     9.304     0.200
     2.199    10.366     0.200
     2.217    10.645     0.200
     2.247     9.508     0.200
     2.274    10.451     0.200
     2.323    10.909     0.200
     2.456    11.165     0.200
     2.478    10.643     0.200
     2.489    11.680     0.200
     2.525    10.656     0.200
     2.555    11.562     0.200
     2.574    11.178     0.200
     2.574    11.561     0.200
     2.631    12.147     0.200
     2.655    11.589     0.200
     2.672    11.993     0.200
     2.678    10.441     0.200
     2.694    11.674     0.200
     2.754    11.396     0.200
     2.768    12.075     0.200
     2.768    11.348     0.200
     2.779    11.981     0.200
     2.793    12.153     0.200
     2.834    12.407     0.200
     2.861    11.677     0.200
     2.869    12.415     0.200
     2.988    12.111     0.200
     3.053    11.821     0.200
     3.115    12.463     0.200
     3.107    13.037     0.200
     3.178    13.231     0.200
     3.221    12.728     0.200
     3.230    13.149     0.200
     3.266    12.770     0.200
     3.280    13.038     0.200
     3.349    13.660     0.200
     3.434    11.132     0.200
     3.455    13.207     0.200
     3.514    14.122     0.200
     3.524    13.746     0.200
     3.524    13.582     0.200
     3.636    13.753     0.200
     3.657    13.578     0.200
     3.790    16.323     0.200
     3.892    14.960     0.200
     3.892    14.608     0.200
     4.270    15.899     0.200
     4.273    16.307     0.200
     4.680    16.454     0.200
     4.680    16.953     0.200
     4.719    16.313     0.200
     4.848    16.803     0.200
     4.897    17.573     0.200
     4.932    14.415     0.200
     4.932    14.540     0.200
     4.971    16.709     0.200
     5.017    18.122     0.200
     5.111    18.209     0.200
     5.207    18.003     0.200
     5.207    18.050     0.200
     5.470    19.167     0.200
     5.585    18.602     0.200
     5.604    20.580     0.200
     5.733    19.618     0.200
     5.847    18.755     0.200
     5.861    20.191     0.200
     6.145    21.097     0.200
     6.146    20.186     0.200
     6.169    20.284     0.200
     6.367    22.768     0.200
     6.369    21.158     0.200
     6.578    21.825     0.200
     6.765    22.471     0.200
     6.890    22.620     0.200
     6.955    22.715     0.200
     7.007    24.239     0.200
     7.020    22.451     0.200
     7.106    24.273     0.200
     7.099    21.580     0.200
     7.213    25.821     0.200
     7.249    23.963     0.200
     7.376    22.595     0.200
     7.378    22.778     0.200
     7.378    22.880     0.200
     7.423    24.226     0.200
     7.448    24.156     0.200
     7.550    23.666     0.200
     7.598    26.188     0.200
     7.650    25.717     0.200
     7.812    24.315     0.200
     7.828    24.504     0.200
     7.840    23.125     0.200
     7.858    22.112     0.200
     7.906    24.711     0.200
     7.943    25.059     0.200
     7.961    22.996     0.200
     7.973    24.761     0.200
     7.983    24.136     0.200
     8.080    25.559     0.200
     8.140    25.682     0.200
     8.187    26.877     0.200
     8.223    26.910     0.200
     8.252    23.822     0.200
     8.243    25.971     0.200
     8.249    25.941     0.200
     8.265    25.978     0.200
     8.376    26.241     0.200
     8.456    24.592     0.200
     8.456    24.490     0.200
     8.456    24.271     0.200
     8.449    26.485     0.200
     8.458    28.316     0.200
     8.492    27.214     0.200
     8.504    26.825     0.200
     8.592    26.891     0.200
     8.759    27.266     0.200
     8.849    26.511     0.200
     8.871    27.575     0.200
     8.913    28.201     0.200
     8.931    27.683     0.200
     8.944    27.192     0.200
     8.950    27.688     0.200
     8.977    24.486     0.200
     9.058    27.961     0.200
     9.111    28.161     0.200
     9.138    28.083     0.200
     9.169    28.253     0.200
     9.259    28.509     0.200
     9.415    28.506     0.200
     9.484    28.994     0.200
     9.591    28.176     0.200
     9.647    30.999     0.200
     9.912    32.557     0.200
     9.937    28.758     0.200
     9.991    30.770     0.200
    10.255    30.350     0.200
    10.486    34.549     0.200
    10.551    30.695     0.200
    10.704    32.212     0.200
    10.753    31.458     0.200
    10.807    31.839     0.200
    10.808    32.298     0.200
    10.808    32.298     0.200
    10.812    31.801     0.200
    10.864    32.820     0.200
    10.948    33.081     0.200
    10.985    33.628     0.200
    11.059    33.542     0.200
    11.168    33.095     0.200
    11.241    33.209     0.200
    11.361    32.413     0.200
    11.246    33.577     0.200
    11.321    34.400     0.200
    11.446    30.789     0.200
    11.562    35.300     0.200
    11.694    30.404     0.200
    11.695    31.395     0.200
    11.695    31.340     0.200
    11.734    36.358     0.200
    11.781    35.427     0.200
    11.882    36.066     0.200
    12.004    36.074     0.200
    12.021    35.491     0.200
    12.048    37.176     0.200
    12.079    37.460     0.200
    12.102    33.796     0.200
    12.361    34.067     0.200
    12.507    36.739     0.200
    12.548    38.009     0.200
    12.722    38.104     0.200
    12.768    37.814     0.200
    13.137    38.868     0.200
    13.161    39.194     0.200
    13.171    39.571     0.200
    13.199    38.090     0.200
    13.222    39.041     0.200
    13.420    38.945     0.200
    13.532    38.400     0.200
    13.701    38.705     0.200
    13.741    40.131     0.200
    13.744    38.852     0.200
    13.914    39.397     0.200
    13.991    39.881     0.200
    14.166    36.178     0.200
    14.174    39.586     0.200
    14.178    39.860     0.200
    14.198    39.891     0.200
    14.368    40.946     0.200
    14.407    39.239     0.200
    14.424    37.149     0.200
    14.426    39.742     0.200
    14.475    38.753     0.200
    14.472    40.450     0.200
    14.548    41.192     0.200
    14.662    40.564     0.200
    14.743    36.620     0.200
    14.835    39.651     0.200
    14.835    40.104     0.200
    15.030    40.630     0.200
    15.073    40.324     0.200
    15.577    39.643     0.200
    15.741    41.435     0.200
    15.809    40.643     0.200
    15.840    39.563     0.200
    16.094    39.922     0.200
    17.000    40.923     0.200
    17.213    41.216     0.200
    17.921    41.934     0.200
    19.226    43.247     0.200
    20.041    42.260     0.200
    20.238    42.201     0.200
     1.220     6.999     0.200
     1.232     7.892     0.200
     1.341     9.353     0.200
     1.545     9.056     0.200
     1.585     9.055     0.200
     1.642     8.082     0.200
     1.661     9.698     0.200
     1.866    11.329     0.200
     2.019    12.157     0.200
     2.159    10.469     0.200
     2.237    10.012     0.200
     2.692    10.322     0.200
     2.946    10.295     0.200
     3.374    12.592     0.200
     3.405    12.989     0.200
     3.783    14.326     0.200
     4.473    14.245     0.200
     4.487    17.681     0.200
     4.643    16.572     0.200
     4.878    17.370     0.200
     5.002    17.371     0.200
     5.545    18.271     0.200
     5.580    18.358     0.200
     5.580    18.357     0.200
     6.018    18.354     0.200
     6.173    20.109     0.200
     7.469    20.711     0.200
     7.706    25.359     0.200
     7.818    22.667     0.200
     8.102    22.135     0.200
     9.488    24.707     0.200
    10.847    30.367     0.200
    10.847    30.374     0.200
    11.219    30.599     0.200
     0.890     6.755     0.200
     0.844     6.412     0.200
     1.026     7.414     0.200
     1.026     7.168     0.200
     0.995     7.682     0.200
     1.093     7.541     0.200
     1.093     7.361     0.200
     1.051     7.127     0.200
     1.094     7.472     0.200
     1.094     7.801     0.200
     1.026     7.239     0.200
     1.057     8.691     0.200
     1.186     8.086     0.200
     1.227     7.940     0.200
     1.227     7.959     0.200
     1.251     8.467     0.200
     1.318     8.325     0.200
     1.269     8.610     0.200
     1.356     8.041     0.200
     1.344     9.176     0.200
     1.344     9.075     0.200
     1.407     8.786     0.200
     1.358     9.110     0.200
     1.392     9.229     0.200
     1.416     9.228     0.200
     1.455     9.458     0.200
     1.507     9.209     0.200
     1.507     9.409     0.200
     1.617     8.423     0.200
     1.644     8.573     0.200
     1.644     8.804     0.200
     1.562     9.346     0.200
     1.559     9.256     0.200
     1.559     9.607     0.200
     1.589     9.645     0.200
     1.699     8.990     0.200
     1.659     9.858     0.200
     1.667     9.875     0.200
     1.668     9.814     0.200
     1.672     9.834     0.200
     1.709    10.003     0.200
     1.743     9.520     0.200
     1.740    10.084     0.200
     1.824    10.278     0.200
     1.849    10.368     0.200
     1.912    10.320     0.200
     1.892    10.448     0.200
     1.986    10.686     0.200
     1.986    10.921     0.200
     2.024    10.216     0.200
     2.054    10.898     0.200
     2.162    11.006     0.200
     2.179    10.558     0.200
     2.192    11.042     0.200
     2.204    11.075     0.200
     2.235    11.124     0.200
     2.272    11.004     0.200
     2.272    11.379     0.200
     2.361    11.029     0.200
     2.450    12.000     0.200
     2.470    11.663     0.200
     2.650    11.499     0.200
     2.723    12.664     0.200
     2.849    12.284     0.200
     2.958    13.332     0.200
     2.958    13.551     0.200
     2.925    12.810     0.200
     2.980    13.080     0.200
     3.094    13.702     0.200
     3.211    12.920     0.200
     3.515    13.359     0.200
     3.666    13.135     0.200
     3.666    12.885     0.200
     4.227    15.746     0.200
     4.349    16.658     0.200
     4.445    17.347     0.200
     4.407    15.235     0.200
     4.455    17.119     0.200
     5.114    19.884     0.200
     5.148    17.499     0.200
     5.651    19.541     0.200
     6.461    21.001     0.200
     6.766    20.845     0.200
     6.724    19.214     0.200
     6.812    20.234     0.200
     6.906    20.443     0.200
     6.988    19.963     0.200
     7.216    21.029     0.200
     7.227    21.131     0.200
     7.398    21.518     0.200
     7.418    22.460     0.200
     7.515    20.917     0.200
     7.601    20.789     0.200
     7.723    23.069     0.200
     7.861    25.683     0.200
     8.304    23.400     0.200
     8.528    27.187     0.200
     0.940     6.082     0.200
     0.940     6.207     0.200
     0.998     6.342     0.200
     1.023     6.332     0.200
     1.114     6.668     0.200
     1.176     7.295     0.200
     1.168     7.005     0.200
     1.198     7.016     0.200
     1.303     7.287     0.200
     1.474     7.375     0.200
     1.625     8.649     0.200
     1.633     9.099     0.200
     1.636     9.038     0.200
     1.731     8.166     0.200
     1.741     8.329     0.200
     1.895     8.671     0.200
     1.894     8.851     0.200
     1.991     9.291     0.200
     1.992    10.328     0.200
     2.116     9.342     0.200
     2.391    11.663     0.200
     2.407     9.881     0.200
     2.415     9.539     0.200
     2.506     9.681     0.200
     2.566     8.956     0.200
     3.403    11.876     0.200
     3.473    13.178     0.200
     3.554    12.529     0.200
     3.939    13.811     0.200
     4.097    13.201     0.200
     4.260    14.573     0.200
     4.260    15.018     0.200
     5.297    17.563     0.200
     5.820    18.656     0.200
     6.094    19.535     0.200
     6.114    20.629     0.200
     6.572    18.687     0.200
     6.572    19.296     0.200
     7.303    20.041     0.200
     7.475    20.318     0.200
     7.495    22.056     0.200
     7.605    21.840     0.200
     7.694    24.572     0.200
     7.800    23.995     0.200
     9.001    23.284     0.200
     9.123    26.946     0.200
    10.327    30.540     0.200
    10.360    27.506     0.200
    10.803    30.306     0.200
    10.803    32.109     0.200
    10.838    28.838     0.200
    10.949    33.187     0.200
    11.248    30.255     0.200
    11.337    30.791     0.200
    13.012    37.096     0.200
     0.888     5.947     0.200
     0.862     5.251     0.200
     1.038     6.232     0.200
     1.137     6.784     0.200
     1.219     6.726     0.200
     1.169     7.751     0.200
     1.215     6.919     0.200
     1.190     7.229     0.200
     1.212     6.910     0.200
     1.354     6.902     0.200
     1.357     7.497     0.200
     1.448     7.582     0.200
     1.475     7.141     0.200
     1.510     8.472     0.200
     1.607     8.086     0.200
     1.587     8.466     0.200
     1.805     7.589     0.200
     1.806     9.064     0.200
     1.806     9.389     0.200
     1.896     8.186     0.200
     1.878     8.776     0.200
     1.897     9.307     0.200
     1.928     7.861     0.200
     2.118     8.681     0.200
     2.170     9.882     0.200
     2.231     9.726     0.200
     2.294     9.362     0.200
     2.315     9.405     0.200
     2.346     9.279     0.200
     2.369    10.582     0.200
     2.369     9.957     0.200
     2.402    10.641     0.200
     2.497    10.567     0.200
     2.634    10.919     0.200
     2.730    11.678     0.200
     2.805    10.828     0.200
     2.907    12.558     0.200
     3.060    12.834     0.200
     3.108    12.261     0.200
     3.197    11.616     0.200
     3.256    12.819     0.200
     3.266    12.925     0.200
     3.306    13.334     0.200
     3.524    13.956     0.200
     3.897    14.728     0.200
     4.236    15.028     0.200
     4.369    15.177     0.200
     4.411    15.270     0.200
     4.533    14.826     0.200
     4.608    15.933     0.200
     4.830    17.340     0.200
     4.851    16.740     0.200
     4.856    19.642     0.200
     5.241    18.474     0.200
     5.272    14.666     0.200
     5.770    18.430     0.200
     6.096    17.748     0.200
    11.784    30.883     0.200
     1.024     6.922     0.200
     1.116     7.596     0.200
     1.310     8.449     0.200
     1.369     8.621     0.200
     1.505     7.989     0.200
     1.491     9.018     0.200
     1.670     8.164     0.200
     1.853     9.216     0.200
     1.805     9.854     0.200
     2.156     9.186     0.200
     2.323    10.952     0.200
     2.567    13.263     0.200
     2.704    12.002     0.200
     2.900    12.204     0.200
     2.917    11.343     0.200
     3.931    16.985     0.200
     4.297    15.429     0.200
     4.715    15.949     0.200
     4.721    16.768     0.200
     4.754    17.135     0.200
     4.795    17.024     0.200
     4.919    17.662     0.200
     5.513    18.028     0.200
     5.505    20.117     0.200
     5.615    20.564     0.200
     5.646    19.624     0.200
     5.864    19.618     0.200
     6.045    22.862     0.200
     6.042    21.275     0.200
     6.438    24.357     0.200
     7.979    24.811     0.200
     8.003    24.743     0.200
     8.119    25.967     0.200
     8.220    24.772     0.200
     9.743    29.693     0.200
    10.587    31.631     0.200
    10.572    28.868     0.200
     0.980     7.132     0.200
     1.073     7.076     0.200
     1.127     7.013     0.200
     1.127     6.873     0.200
     1.128     6.856     0.200
     1.190     6.901     0.200
     1.182     8.289     0.200
     1.517     7.831     0.200
     1.532     7.554     0.200
     1.884     8.780     0.200
     1.885     8.747     0.200
     1.848     8.136     0.200
     2.448    10.770     0.200
     2.511     8.738     0.200
     2.524    12.446     0.200
     2.563    10.518     0.200
     2.582    12.385     0.200
     3.643    15.786     0.200
     3.730    14.248     0.200
     3.737    14.769     0.200
     4.067    12.778     0.200
     4.067    13.122     0.200
     4.312    16.164     0.200
     4.398    16.305     0.200
     4.486    15.887     0.200
     4.928    17.076     0.200
     4.941    17.327     0.200
     5.067    18.028     0.200
     5.222    20.157     0.200
     5.263    18.244     0.200
     5.295    17.741     0.200
     5.403    18.540     0.200
     5.755    18.939     0.200
     5.787    19.979     0.200
     5.924    21.040     0.200
     6.204    22.022     0.200
     6.554    18.542     0.200
     6.945    23.769     0.200
     7.254    22.693     0.200
     7.593    23.066     0.200
     7.617    24.141     0.200
     8.692    23.206     0.200
    10.423    30.450     0.200
     0.893     6.432     0.200
     0.893     6.565     0.200
     0.983     8.311     0.200
     1.150     9.208     0.200
     1.304     9.231     0.200
     1.324     8.945     0.200
     1.331    10.697     0.200
     1.391    10.150     0.200
     1.523    10.007     0.200
     1.539    10.882     0.200
     1.539     9.968     0.200
     1.588     9.424     0.200
     1.621    10.192     0.200
     1.714    10.405     0.200
     1.832     9.663     0.200
     1.850    11.903     0.200
     1.935    12.706     0.200
     2.276     9.380     0.200
     2.249    11.816     0.200
     2.455    11.442     0.200
     2.623    10.943     0.200
     2.625    11.479     0.200
     2.625    11.327     0.200
     2.688    12.039     0.200
     2.767    12.634     0.200
     3.087    13.691     0.200
     3.392    12.929     0.200
     3.951    14.694     0.200
     3.946    15.475     0.200
     4.076    15.955     0.200
     4.166    16.206     0.200
     4.275    16.585     0.200
     4.331    17.389     0.200
     4.455    16.384     0.200
     4.479    17.026     0.200
     4.508    15.679     0.200
     4.766    15.379     0.200
     4.884    17.953     0.200
     4.884    19.539     0.200
     5.344    18.526     0.200
     5.451    18.876     0.200
     5.416    18.919     0.200
     5.612    19.009     0.200
     5.691    18.037     0.200
     5.779    19.076     0.200
     7.141    21.629     0.200
     7.315    21.718     0.200
     7.411    22.413     0.200
    11.562    30.372     0.200
     1.335    10.970     0.200
     1.390     9.247     0.200
     1.456     9.980     0.200
     1.508     9.679     0.200
     1.519    10.152     0.200
     1.526    10.318     0.200
     1.550     9.462     0.200
     1.602     9.189     0.200
     1.620    10.961     0.200
     1.623    11.319     0.200
     1.713    11.320     0.200
     1.836     9.527     0.200
     2.260    11.309     0.200
     2.258    11.637     0.200
     2.273    10.891     0.200
     2.627    12.120     0.200
     2.631    12.463     0.200
     2.698    13.542     0.200
     2.781    13.999     0.200
     3.100    14.249     0.200
     3.957    15.283     0.200
     3.959    15.868     0.200
     4.088    16.656     0.200
     4.179    16.933     0.200
     4.345    18.218     0.200
     4.398    17.083     0.200
     4.503    18.602     0.200
     4.769    20.489     0.200
     4.856    19.811     0.200
     4.895    19.658     0.200
     5.143    21.300     0.200
     5.194    18.923     0.200
     5.288    21.802     0.200
     5.428    20.588     0.200
     6.889    22.862     0.200
     7.340    26.564     0.200
    11.287    33.588     0.200
    11.550    35.116     0.200
    14.616    40.290     0.200
     0.853     6.659     0.200
     0.870     6.022     0.200
     1.025     7.065     0.200
     1.031     7.349     0.200
     1.031     7.638     0.200
     1.046     7.302     0.200
     1.348     7.683     0.200
     1.384     8.820     0.200
     1.590     8.643     0.200
     1.637     8.049     0.200
     1.640     9.021     0.200
     1.675     9.241     0.200
     1.676     9.100     0.200
     2.004    10.582     0.200
     2.061    10.438     0.200
     2.314    10.914     0.200
     2.606    11.381     0.200
     2.747    12.368     0.200
     2.786    12.983     0.200
     2.911    11.182     0.200
     3.107    13.571     0.200
     3.342    14.332     0.200
     3.624    14.422     0.200
     3.977    16.356     0.200
     4.280    15.274     0.200
     4.507    16.302     0.200
     4.594    16.933     0.200
     4.708    16.804     0.200
     4.719    17.036     0.200
     4.822    19.044     0.200
     5.294    17.451     0.200
     5.325    19.409     0.200
     5.508    18.145     0.200
     5.835    18.870     0.200
     5.880    18.760     0.200
    12.142    33.754     0.200
    14.694    36.276     0.200
    15.024    38.175     0.200
     0.975     6.158     0.200
     0.983     6.182     0.200
     1.031     6.304     0.200
     1.097     6.490     0.200
     1.159     7.191     0.200
     1.159     6.832     0.200
     1.183     6.825     0.200
     1.183     6.747     0.200
     1.290     7.040     0.200
     1.468     7.246     0.200
     1.548     7.097     0.200
     1.753     8.046     0.200
     1.910     8.552     0.200
     2.405     9.104     0.200
     2.418     9.161     0.200
     2.572     8.597     0.200
     3.641    13.779     0.200
     3.717    13.787     0.200
     4.107    12.415     0.200
     4.107    12.775     0.200
     4.277    16.158     0.200
     4.277    13.822     0.200
     4.340    16.350     0.200
     4.863    17.249     0.200
     4.922    17.060     0.200
     5.827    21.801     0.200
     6.584    19.113     0.200
     7.565    24.726     0.200
     8.728    22.384     0.200
    10.819    32.536     0.200
    10.846    28.373     0.200
     1.168     7.103     0.200
     1.302     7.190     0.200
     1.302     7.284     0.200
     1.480     7.534     0.200
     1.535     7.447     0.200
     1.755     8.025     0.200
     1.909     8.593     0.200
     1.907     8.641     0.200
     2.421     9.796     0.200
     2.492     9.845     0.200
     2.493    12.339     0.200
     2.560     8.996     0.200
     2.738    10.323     0.200
     3.329    12.940     0.200
     3.415    11.689     0.200
     3.487    13.335     0.200
     3.648    12.856     0.200
     3.706    14.183     0.200
     4.095    12.652     0.200
     4.268    16.845     0.200
     4.334    16.232     0.200
     4.408    15.897     0.200
     4.720    20.104     0.200
     4.860    17.483     0.200
     4.988    17.594     0.200
     5.149    18.779     0.200
     5.668    18.461     0.200
     5.833    22.018     0.200
     6.127    21.654     0.200
     6.356    19.288     0.200
     6.571    18.791     0.200
     6.649    21.557     0.200
     7.258    22.517     0.200
    10.816    31.265     0.200
    10.834    29.178     0.200
     0.984     6.051     0.200
     0.995     6.224     0.200
     1.032     6.300     0.200
     1.109     6.562     0.200
     1.171     7.253     0.200
     1.177     6.885     0.200
     1.195     6.879     0.200
     1.302     7.056     0.200
     1.478     7.356     0.200
     1.738     7.930     0.200
     1.751     7.884     0.200
     1.902     8.665     0.200
     1.904     8.373     0.200
     1.981     9.158     0.200
     2.121     9.966     0.200
     2.417     9.444     0.200
     2.487     9.819     0.200
     2.506     9.604     0.200
     2.563     9.110     0.200
     2.734    10.363     0.200
     3.066    11.910     0.200
     3.113    11.450     0.200
     3.328    11.754     0.200
     3.411    11.709     0.200
     3.644    12.774     0.200
     4.096    12.937     0.200
     4.096    13.210     0.200
     4.265    16.328     0.200
     4.321    15.099     0.200
     5.828    18.852     0.200
     6.100    19.857     0.200
     6.353    18.874     0.200
     6.572    18.668     0.200
     7.484    22.697     0.200
     7.802    23.823     0.200
     8.716    24.544     0.200
     8.716    21.974     0.200
    10.812    33.532     0.200
    10.836    29.510     0.200
    13.021    35.493     0.200
    14.050    36.428     0.200
    15.394    39.110     0.200
    16.060    39.314     0.200
     0.937     7.038     0.200
     1.105     6.531     0.200
     1.179     6.939     0.200
     1.167     7.378     0.200
     1.167     7.182     0.200
     1.191     7.097     0.200
     1.475     7.403     0.200
     1.668     7.960     0.200
     1.742     8.136     0.200
     1.752     8.123     0.200
     1.906     8.652     0.200
     1.905     8.422     0.200
     1.980     9.231     0.200
     1.981     8.933     0.200
     2.119     9.271     0.200
     2.127     9.948     0.200
     2.190     9.311     0.200
     2.379     9.356     0.200
     2.418     9.468     0.200
     2.487     9.927     0.200
     2.502     9.842     0.200
     2.565     9.111     0.200
     2.609     9.923     0.200
     2.733    10.810     0.200
     2.922    11.022     0.200
     3.005    11.569     0.200
     3.064    13.131     0.200
     3.064    11.686     0.200
     3.110    10.958     0.200
     3.325    12.537     0.200
     3.325    11.248     0.200
     3.411    11.577     0.200
     3.420    12.418     0.200
     3.530    12.212     0.200
     3.560    12.843     0.200
     3.591    13.339     0.200
     3.644    12.790     0.200
     3.729    13.277     0.200
     3.950    16.493     0.200
     3.950    14.009     0.200
     3.981    13.937     0.200
     3.984    13.855     0.200
     4.037    13.706     0.200
     4.099    14.179     0.200
     4.099    13.640     0.200
     4.223    14.275     0.200
     4.269    13.969     0.200
     4.319    15.889     0.200
     4.570    15.992     0.200
     4.858    18.177     0.200
     4.987    19.052     0.200
     5.148    21.090     0.200
     5.271    17.169     0.200
     5.308    18.651     0.200
     5.308    17.190     0.200
     5.310    18.224     0.200
     5.364    19.667     0.200
     5.414    19.443     0.200
     5.580    17.000     0.200
     5.630    17.959     0.200
     5.666    20.085     0.200
     5.829    22.395     0.200
     5.829    19.653     0.200
     6.079    22.696     0.200
     6.348    20.970     0.200
     6.352    21.531     0.200
     6.575    19.712     0.200
     6.976    24.256     0.200
     7.138    25.300     0.200
     7.138    21.315     0.200
     7.157    24.779     0.200
     7.261    22.072     0.200
     7.291    26.659     0.200
     7.295    22.849     0.200
     7.314    24.275     0.200
     7.462    27.088     0.200
     7.486    22.861     0.200
     7.508    24.766     0.200
     7.510    24.644     0.200
     7.505    24.553     0.200
     7.545    26.045     0.200
     7.545    22.263     0.200
     7.556    26.594     0.200
     7.558    26.381     0.200
     7.560    23.116     0.200
     7.591    26.500     0.200
     7.625    26.330     0.200
     7.644    25.783     0.200
     7.657    26.836     0.200
     7.767    22.702     0.200
     7.804    23.030     0.200
     7.806    22.792     0.200
     7.806    25.167     0.200
     7.806    26.198     0.200
     7.806    22.105     0.200
     7.807    23.255     0.200
     7.841    27.311     0.200
     8.006    27.669     0.200
     8.237    28.518     0.200
     8.247    28.682     0.200
     8.547    27.789     0.200
     8.547    24.344     0.200
     8.630    27.811     0.200
     8.720    24.434     0.200
     8.720    24.207     0.200
     8.730    28.509     0.200
     8.808    26.128     0.200
     9.012    28.452     0.200
     9.135    29.208     0.200
     9.217    28.433     0.200
     9.217    25.222     0.200
     9.192    27.553     0.200
     9.271    29.682     0.200
     9.470    26.989     0.200
     9.470    26.466     0.200
     9.489    28.490     0.200
     9.620    25.722     0.200
     9.696    26.127     0.200
     9.765    26.383     0.200
    10.020    26.501     0.200
    10.023    30.345     0.200
    10.056    29.021     0.200
    10.164    26.884     0.200
    10.191    33.091     0.200
    10.308    28.254     0.200
    10.339    31.840     0.200
    10.371    32.056     0.200
    10.374    33.743     0.200
    10.483    31.502     0.200
    10.555    33.241     0.200
    10.624    33.396     0.200
    10.609    29.468     0.200
    10.728    30.588     0.200
    10.728    27.073     0.200
    10.750    28.734     0.200
    10.815    30.411     0.200
    10.815    32.636     0.200
    10.815    31.683     0.200
    10.815    31.816     0.200
    10.838    29.188     0.200
    10.839    28.936     0.200
    10.961    33.854     0.200
    11.054    32.999     0.200
    11.080    33.755     0.200
    11.113    30.348     0.200
    11.163    29.281     0.200
    11.198    33.598     0.200
    11.259    33.954     0.200
    11.349    31.693     0.200
    11.415    30.105     0.200
    11.570    31.584     0.200
    11.673    34.991     0.200
    11.682    29.358     0.200
    11.682    32.639     0.200
    11.883    35.173     0.200
    11.965    33.231     0.200
    11.965    33.512     0.200
    11.996    33.138     0.200
    12.006    31.289     0.200
    12.054    32.335     0.200
    12.160    36.675     0.200
    12.153    33.272     0.200
    12.188    36.888     0.200
    12.268    32.669     0.200
    12.300    37.077     0.200
    12.721    38.684     0.200
    12.759    30.957     0.200
    12.803    38.323     0.200
    12.806    34.198     0.200
    12.913    37.195     0.200
    12.980    32.954     0.200
    12.999    38.938     0.200
    13.024    36.545     0.200
    13.279    38.475     0.200
    13.387    35.727     0.200
    13.404    36.065     0.200
    13.404    34.683     0.200
    13.542    35.339     0.200
    13.615    34.978     0.200
    13.657    34.847     0.200
    13.657    33.964     0.200
    13.687    38.163     0.200
    13.839    39.240     0.200
    14.054    36.788     0.200
    14.054    34.725     0.200
    14.062    36.086     0.200
    14.233    37.038     0.200
    14.267    35.444     0.200
    14.267    36.249     0.200
    14.532    37.737     0.200
    14.686    36.262     0.200
    15.157    38.465     0.200
    15.264    39.652     0.200
    15.264    36.394     0.200
    15.321    35.639     0.200
    15.321    37.709     0.200
    15.397    38.792     0.200
    15.397    37.260     0.200
    15.440    39.227     0.200
    15.440    36.547     0.200
    15.571    39.589     0.200
    15.609    38.444     0.200
    15.668    37.625     0.200
    16.182    38.755     0.200
    16.474    39.871     0.200
    16.474    38.270     0.200
    16.562    38.591     0.200
    16.565    39.879     0.200
    17.112    38.768     0.200
    17.636    39.411     0.200
    17.706    39.688     0.200
    17.706    38.868     0.200
    17.872    40.267     0.200
    17.901    40.544     0.200
    18.168    40.498     0.200
    18.263    39.810     0.200
    18.263    39.998     0.200
    18.293    40.348     0.200
    18.298    40.147     0.200
    18.340    38.921     0.200
    18.343    39.191     0.200
    18.489    40.930     0.200
    18.519    41.408     0.200
    18.720    42.049     0.200
    18.753    42.566     0.200
    18.915    42.315     0.200
    18.964    41.701     0.200
    18.964    40.560     0.200
    19.029    40.808     0.200
    19.435    40.713     0.200
    19.553    43.450     0.200
    19.629    41.959     0.200
    19.648    40.511     0.200
    19.802    41.406     0.200
    19.852    40.105     0.200
    19.951    41.181     0.200
    19.993    40.838     0.200
    20.019    41.470     0.200
    20.048    40.476     0.200
    20.421    40.413     0.200
     0.949     6.517     0.200
     0.952     6.472     0.200
     0.983     6.864     0.200
     1.094     6.735     0.200
     1.155     7.235     0.200
     1.155     7.594     0.200
     1.185     7.124     0.200
     1.294     7.610     0.200
     2.508    11.182     0.200
     3.071    11.689     0.200
     3.324    14.105     0.200
     3.500    15.095     0.200
     4.099    13.334     0.200
     5.003    16.968     0.200
     5.324    16.134     0.200
     5.365    18.888     0.200
     5.377    17.043     0.200
     5.427    17.922     0.200
     5.578    15.935     0.200
     7.076    23.800     0.200
     7.195    22.485     0.200
     7.267    20.778     0.200
     7.724    24.169     0.200
     8.721    22.681     0.200
    10.572    27.323     0.200
    10.733    27.820     0.200
    10.831    28.811     0.200
     0.938     6.197     0.200
     0.968     5.986     0.200
     1.047     6.416     0.200
     1.060     6.364     0.200
     1.108     6.893     0.200
     1.142     6.726     0.200
     1.233     7.082     0.200
     1.254     7.108     0.200
     1.456     7.434     0.200
     1.585     9.350     0.200
     1.939     8.947     0.200
     1.961     8.829     0.200
     2.586     9.202     0.200
     3.664    14.613     0.200
     3.763    14.404     0.200
     4.133    13.128     0.200
     4.327    15.696     0.200
     4.966    16.807     0.200
     5.326    18.474     0.200
     5.854    20.578     0.200
     7.857    24.015     0.200
    10.865    28.649     0.200
    10.870    33.611     0.200
     0.935     7.401     0.200
     1.107     6.866     0.200
     1.176     6.954     0.200
     1.169     7.522     0.200
     1.193     7.169     0.200
     1.299     7.201     0.200
     1.474     7.632     0.200
     1.617     6.551     0.200
     1.616     8.878     0.200
     1.625     7.400     0.200
     1.628     9.208     0.200
     1.666     8.462     0.200
     1.739     8.159     0.200
     1.749     8.396     0.200
     1.902     8.885     0.200
     1.902     8.644     0.200
     1.983     9.248     0.200
     2.117     9.523     0.200
     2.126     9.887     0.200
     2.187     9.520     0.200
     2.378     9.558     0.200
     2.392    10.211     0.200
     2.415     9.889     0.200
     2.413     9.444     0.200
     2.461    10.488     0.200
     2.490    10.399     0.200
     2.484    10.007     0.200
     2.566     8.842     0.200
     2.608    10.234     0.200
     2.731    10.841     0.200
     2.918    10.933     0.200
     3.003    10.980     0.200
     3.063    11.749     0.200
     3.063    11.554     0.200
     3.110    10.952     0.200
     3.325    12.183     0.200
     3.325    11.597     0.200
     3.408    11.859     0.200
     3.418    12.414     0.200
     3.481    13.075     0.200
     3.557    12.541     0.200
     3.557    12.330     0.200
     3.641    12.862     0.200
     3.707    13.548     0.200
     3.728    12.928     0.200
     3.946    14.460     0.200
     3.946    14.304     0.200
     3.978    13.436     0.200
     3.983    14.135     0.200
     4.035    14.082     0.200
     4.099    12.443     0.200
     4.220    14.723     0.200
     4.267    15.113     0.200
     4.267    14.761     0.200
     4.331    15.272     0.200
     4.317    14.492     0.200
     4.404    15.445     0.200
     4.567    14.328     0.200
     4.714    16.345     0.200
     4.912    16.859     0.200
     4.984    17.261     0.200
     5.145    18.203     0.200
     5.269    18.245     0.200
     5.269    16.674     0.200
     5.305    17.479     0.200
     5.305    17.260     0.200
     5.307    18.669     0.200
     5.356    18.711     0.200
     5.361    20.518     0.200
     5.580    16.541     0.200
     5.632    15.717     0.200
     5.663    18.733     0.200
     5.708    20.039     0.200
     5.783    18.794     0.200
     5.826    18.195     0.200
     5.826    19.296     0.200
     6.076    20.245     0.200
     6.123    20.498     0.200
     6.299    23.823     0.200
     6.345    20.294     0.200
     6.349    19.793     0.200
     6.575    19.379     0.200
     6.642    24.656     0.200
     6.867    24.849     0.200
     7.136    23.757     0.200
     7.136    22.944     0.200
     7.156    23.433     0.200
     7.176    24.468     0.200
     7.260    21.240     0.200
     7.289    25.300     0.200
     7.311    23.482     0.200
     7.458    25.602     0.200
     7.483    26.095     0.200
     7.483    23.727     0.200
     7.505    24.337     0.200
     7.507    24.089     0.200
     7.512    24.458     0.200
     7.512    24.629     0.200
     7.502    23.379     0.200
     7.517    24.600     0.200
     7.524    23.635     0.200
     7.531    24.374     0.200
     7.544    21.596     0.200
     7.542    24.014     0.200
     7.552    24.459     0.200
     7.553    24.094     0.200
     7.559    23.746     0.200
     7.556    24.006     0.200
     7.569    24.565     0.200
     7.588    24.679     0.200
     7.592    24.618     0.200
     7.622    24.431     0.200
     7.642    24.251     0.200
     7.654    26.139     0.200
     7.688    24.351     0.200
     7.767    22.522     0.200
     7.777    24.435     0.200
     7.803    22.624     0.200
     7.805    21.347     0.200
     7.805    23.886     0.200
     7.805    23.316     0.200
     7.805    23.365     0.200
     7.858    25.371     0.200
     8.135    26.277     0.200
     8.217    25.651     0.200
     8.234    27.024     0.200
     8.244    27.368     0.200
     8.545    26.120     0.200
     8.545    24.925     0.200
     8.627    27.506     0.200
     8.720    23.591     0.200
     8.726    28.383     0.200
     8.806    25.650     0.200
     8.806    25.212     0.200
     9.009    26.616     0.200
     9.132    28.558     0.200
     9.189    26.619     0.200
     9.214    27.584     0.200
     9.214    26.756     0.200
     9.268    28.181     0.200
     9.468    27.264     0.200
     9.468    26.381     0.200
     9.489    27.360     0.200
     9.762    28.178     0.200
    10.018    27.305     0.200
    10.026    29.783     0.200
    10.053    26.928     0.200
    10.162    27.304     0.200
    10.305    26.134     0.200
    10.335    31.597     0.200
    10.368    32.181     0.200
    10.372    32.695     0.200
    10.481    31.750     0.200
    10.516    32.084     0.200
    10.627    31.068     0.200
    10.552    32.710     0.200
    10.552    28.507     0.200
    10.606    30.523     0.200
    10.727    32.747     0.200
    10.727    30.646     0.200
    10.747    30.970     0.200
    10.811    31.683     0.200
    10.811    30.550     0.200
    10.811    31.642     0.200
    10.811    30.439     0.200
    10.811    31.080     0.200
    10.838    28.478     0.200
    10.839    28.672     0.200
    10.898    31.908     0.200
    10.957    32.736     0.200
    10.987    28.587     0.200
    11.051    32.194     0.200
    11.076    33.739     0.200
    11.160    30.314     0.200
    11.170    33.479     0.200
    11.196    35.129     0.200
    11.256    33.242     0.200
    11.345    34.168     0.200
    11.412    31.559     0.200
    11.435    34.317     0.200
    11.535    36.990     0.200
    11.568    31.263     0.200
    11.669    35.287     0.200
    11.681    30.684     0.200
    11.962    34.328     0.200
    11.962    31.961     0.200
    11.966    37.080     0.200
    11.993    37.106     0.200
    11.993    32.238     0.200
    12.003    34.056     0.200
    12.052    32.743     0.200
    12.157    36.963     0.200
    12.150    32.119     0.200
    12.184    36.802     0.200
    12.211    36.788     0.200
    12.265    33.247     0.200
    12.297    36.319     0.200
    12.518    37.829     0.200
    12.718    38.390     0.200
    12.756    32.928     0.200
    12.800    38.554     0.200
    12.804    34.503     0.200
    12.910    37.843     0.200
    12.910    37.702     0.200
    12.977    36.660     0.200
    12.996    38.304     0.200
    13.020    36.661     0.200
    13.020    36.138     0.200
    13.385    35.084     0.200
    13.403    33.674     0.200
    13.527    38.770     0.200
    13.539    36.357     0.200
    13.608    39.610     0.200
    13.612    37.654     0.200
    13.657    37.035     0.200
    13.657    34.770     0.200
    13.684    39.481     0.200
    13.704    39.203     0.200
    13.836    39.200     0.200
    13.836    36.950     0.200
    13.901    40.261     0.200
    13.957    39.815     0.200
    14.053    36.777     0.200
    14.053    35.886     0.200
    14.061    34.929     0.200
    14.230    37.165     0.200
    14.239    39.319     0.200
    14.264    36.205     0.200
    14.264    36.658     0.200
    14.529    35.694     0.200
    14.686    38.969     0.200
    14.686    35.914     0.200
    15.154    38.187     0.200
    15.321    38.066     0.200
    15.321    37.011     0.200
    15.394    38.258     0.200
    15.394    37.852     0.200
    15.409    39.326     0.200
    15.440    38.479     0.200
    15.440    36.839     0.200
    15.568    37.272     0.200
    15.606    37.733     0.200
    15.606    39.475     0.200
    15.666    36.644     0.200
    15.990    39.134     0.200
    16.179    38.485     0.200
    16.472    39.432     0.200
    16.561    39.793     0.200
    16.562    38.641     0.200
    17.220    39.643     0.200
    17.705    39.452     0.200
    17.900    39.767     0.200
    18.049    39.001     0.200
    18.167    38.824     0.200
    18.191    39.530     0.200
    18.250    39.079     0.200
    18.260    38.691     0.200
    18.291    39.908     0.200
    18.297    39.896     0.200
    18.342    39.172     0.200
    18.414    40.067     0.200
    18.460    40.607     0.200
    18.592    40.983     0.200
    18.597    40.157     0.200
    18.719    42.466     0.200
    18.719    41.067     0.200
    18.752    42.399     0.200
    18.752    41.259     0.200
    18.913    42.102     0.200
    18.913    41.719     0.200
    18.957    41.634     0.200
    18.957    40.860     0.200
    18.963    41.684     0.200
    18.963    40.864     0.200
    18.964    41.983     0.200
    19.027    40.200     0.200
    19.032    41.102     0.200
    19.035    41.006     0.200
    19.064    42.685     0.200
    19.078    41.251     0.200
    19.091    43.586     0.200
    19.125    40.753     0.200
    19.137    40.567     0.200
    19.197    40.120     0.200
    19.221    40.284     0.200
    19.301    40.270     0.200
    19.354    41.224     0.200
    19.433    40.807     0.200
    19.469    40.692     0.200
    19.485    40.820     0.200
    19.505    40.958     0.200
    19.628    41.509     0.200
    19.628    41.033     0.200
    19.645    40.246     0.200
    19.715    41.055     0.200
    19.736    40.482     0.200
    19.782    39.896     0.200
    19.800    39.757     0.200
    19.818    41.189     0.200
    19.863    39.996     0.200
    19.885    40.439     0.200
    19.891    39.978     0.200
    19.949    39.902     0.200
    19.951    39.922     0.200
    19.991    42.940     0.200
    19.991    40.573     0.200
    20.012    43.028     0.200
    20.012    40.145     0.200
    20.018    39.686     0.200
    20.046    40.001     0.200
    20.128    39.858     0.200
    20.268    40.446     0.200
    20.317    40.034     0.200
    20.321    40.603     0.200
    20.351    41.932     0.200
    20.351    40.143     0.200
    20.369    40.149     0.200
    20.396    40.969     0.200
    20.398    39.500     0.200
    20.420    41.086     0.200
    20.420    40.250     0.200
    20.457    41.404     0.200
    20.532    40.436     0.200
    20.567    39.609     0.200
    20.665    39.442     0.200
    20.690    40.067     0.200
    20.715    39.435     0.200
    20.719    40.128     0.200
    20.776    40.214     0.200
    20.787    39.865     0.200
    20.797    39.859     0.200
    20.935    40.687     0.200
     1.128     6.748     0.200
     1.154     6.849     0.200
     1.191     7.272     0.200
     1.191     6.983     0.200
     1.210     7.290     0.200
     1.314     7.216     0.200
     1.480     7.695     0.200
     1.731     8.168     0.200
     1.889     8.336     0.200
     2.398     9.687     0.200
     2.424     9.636     0.200
     2.467    11.192     0.200
     2.473     9.797     0.200
     2.728    10.427     0.200
     3.398    11.894     0.200
     3.461    13.174     0.200
     3.930    14.521     0.200
     5.249    18.472     0.200
     5.642    18.927     0.200
     5.813    18.393     0.200
     5.813    18.401     0.200
     6.100    20.318     0.200
     6.332    21.311     0.200
     7.153    22.219     0.200
     7.266    24.355     0.200
     7.482    22.291     0.200
     7.494    25.634     0.200
     7.502    19.753     0.200
     7.509    24.829     0.200
     7.531    25.430     0.200
     7.533    24.712     0.200
     7.546    24.480     0.200
     7.599    25.151     0.200
     7.619    24.633     0.200
     7.665    22.196     0.200
     7.754    25.882     0.200
     7.787    22.295     0.200
     7.787    21.366     0.200
     8.605    26.751     0.200
     8.704    28.917     0.200
     8.988    27.372     0.200
    10.313    32.588     0.200
    10.349    31.708     0.200
    10.789    32.611     0.200
    10.789    30.008     0.200
    10.789    30.008     0.200
    10.831    30.566     0.200
    10.831    30.557     0.200
    10.935    34.977     0.200
    11.029    32.996     0.200
    11.945    35.008     0.200
     1.112     6.953     0.200
     1.152     6.594     0.200
     1.266     6.884     0.200
     1.472     7.326     0.200
     1.561     6.725     0.200
     1.559     6.754     0.200
     1.928     8.957     0.200
     1.946    10.308     0.200
     2.375    11.642     0.200
     2.570     8.737     0.200
     2.525    12.005     0.200
     2.525    11.888     0.200
     2.554    12.286     0.200
     2.750    12.597     0.200
     3.069    12.579     0.200
     3.302    11.734     0.200
     3.446    13.633     0.200
     3.581    14.462     0.200
     3.581    14.087     0.200
     3.679    14.178     0.200
     3.756    13.854     0.200
     3.999    16.564     0.200
     3.999    16.119     0.200
     4.119    12.595     0.200
     4.119    12.376     0.200
     4.264    16.482     0.200
     4.324    15.690     0.200
     4.393    16.167     0.200
     4.468    15.553     0.200
     4.958    16.050     0.200
     5.047    17.933     0.200
     5.209    20.625     0.200
     5.319    18.763     0.200
     5.319    17.787     0.200
     5.593    15.817     0.200
     5.772    22.248     0.200
     5.868    19.431     0.200
     6.378    20.559     0.200
     6.601    18.812     0.200
     7.193    21.500     0.200
     7.300    21.118     0.200
     7.583    21.883     0.200
     7.573    27.242     0.200
     7.614    26.206     0.200
     7.617    26.656     0.200
     7.653    26.778     0.200
     7.683    27.082     0.200
     7.846    23.215     0.200
     7.849    23.391     0.200
     7.849    23.346     0.200
     8.742    23.703     0.200
     8.742    23.398     0.200
    10.850    28.637     0.200
    10.849    28.974     0.200
    10.850    28.637     0.200
    10.875    34.923     0.200
     0.942     6.319     0.200
     0.950     6.380     0.200
     1.008     6.219     0.200
     0.989     6.195     0.200
     1.028     6.331     0.200
     1.122     6.551     0.200
     1.184     7.139     0.200
     1.165     6.759     0.200
     1.314     7.247     0.200
     1.485     7.659     0.200
     1.527     6.848     0.200
     1.620     5.939     0.200
     1.670     8.496     0.200
     1.724     8.057     0.200
     1.743     8.093     0.200
     1.900     8.337     0.200
     1.890     8.690     0.200
     1.989     9.104     0.200
     2.125     9.012     0.200
     2.134    10.420     0.200
     2.189     9.085     0.200
     2.310     9.205     0.200
     2.390     9.526     0.200
     2.401    11.516     0.200
     2.426     9.904     0.200
     2.410     9.636     0.200
     2.517    10.062     0.200
     2.484     9.739     0.200
     2.477    10.941     0.200
     2.737    10.470     0.200
     3.005    11.052     0.200
     3.071    11.315     0.200
     3.120    11.952     0.200
     3.338    11.314     0.200
     3.425    11.905     0.200
     3.409    11.800     0.200
     3.473    13.038     0.200
     3.541    12.295     0.200
     3.562    13.365     0.200
     3.562    12.194     0.200
     3.641    13.257     0.200
     3.692    13.349     0.200
     3.738    12.543     0.200
     3.942    14.259     0.200
     3.979    12.991     0.200
     4.086    12.446     0.200
     4.218    14.328     0.200
     4.251    15.387     0.200
     4.251    14.731     0.200
     4.317    15.632     0.200
     4.392    15.424     0.200
     4.844    16.967     0.200
     4.896    16.073     0.200
     4.972    17.643     0.200
     5.132    18.466     0.200
     5.253    17.757     0.200
     5.253    17.147     0.200
     5.298    17.660     0.200
     5.298    17.254     0.200
     5.341    20.567     0.200
     5.363    20.349     0.200
     5.413    21.411     0.200
     5.569    18.124     0.200
     5.653    18.842     0.200
     5.696    19.883     0.200
     5.824    19.240     0.200
     5.824    18.513     0.200
     6.103    22.599     0.200
     6.111    20.682     0.200
     6.352    20.009     0.200
     6.343    20.366     0.200
     6.561    19.283     0.200
     6.642    23.517     0.200
     7.120    23.874     0.200
     7.120    20.671     0.200
     7.141    23.019     0.200
     7.163    26.110     0.200
     7.245    21.653     0.200
     7.274    25.684     0.200
     7.298    23.358     0.200
     7.447    25.666     0.200
     7.472    21.890     0.200
     7.490    24.369     0.200
     7.492    24.387     0.200
     7.498    24.532     0.200
     7.497    24.295     0.200
     7.497    24.629     0.200
     7.504    24.956     0.200
     7.510    23.783     0.200
     7.529    22.281     0.200
     7.517    24.124     0.200
     7.544    25.213     0.200
     7.527    24.334     0.200
     7.537    24.429     0.200
     7.539    24.345     0.200
     7.541    24.356     0.200
     7.554    25.090     0.200
     7.573    24.533     0.200
     7.578    24.641     0.200
     7.607    24.792     0.200
     7.627    24.058     0.200
     7.642    26.099     0.200
     7.673    24.435     0.200
     7.762    24.576     0.200
     7.787    21.634     0.200
     7.789    23.607     0.200
     7.789    21.825     0.200
     7.835    27.157     0.200
     7.844    25.597     0.200
     8.125    26.214     0.200
     8.222    26.971     0.200
     8.232    27.154     0.200
     8.529    25.927     0.200
     8.529    23.184     0.200
     8.616    27.449     0.200
     8.707    23.715     0.200
     8.707    23.114     0.200
     8.715    28.049     0.200
     8.808    24.862     0.200
     8.999    26.975     0.200
     9.121    28.447     0.200
     9.192    25.092     0.200
     9.200    28.170     0.200
     9.200    24.874     0.200
     9.266    30.233     0.200
     9.253    28.074     0.200
     9.452    26.876     0.200
     9.452    24.611     0.200
     9.475    27.101     0.200
     9.764    25.426     0.200
    10.002    28.301     0.200
    10.290    26.759     0.200
    10.324    31.133     0.200
    10.373    30.061     0.200
    10.373    30.913     0.200
    10.466    31.036     0.200
    10.547    32.369     0.200
    10.554    33.071     0.200
    10.712    31.751     0.200
    10.712    27.150     0.200
    10.827    28.316     0.200
    10.828    29.455     0.200
    10.799    31.902     0.200
    10.799    28.777     0.200
    10.799    31.831     0.200
    10.799    31.284     0.200
    10.799    31.471     0.200
    10.884    31.787     0.200
    10.946    33.420     0.200
    10.972    33.319     0.200
    10.972    29.546     0.200
    11.040    31.985     0.200
    11.065    34.039     0.200
    11.159    29.382     0.200
    11.160    33.698     0.200
    11.196    34.290     0.200
    11.245    33.418     0.200
    11.335    33.999     0.200
    11.424    34.770     0.200
    11.518    33.616     0.200
    11.533    33.221     0.200
    11.569    29.816     0.200
    11.666    31.480     0.200
    11.659    34.507     0.200
    11.874    35.211     0.200
    11.949    34.886     0.200
    12.036    34.027     0.200
    12.147    35.859     0.200
    12.174    34.133     0.200
    12.201    36.180     0.200
    12.286    36.645     0.200
    12.514    37.673     0.200
    12.797    36.756     0.200
    12.900    38.074     0.200
    12.987    38.591     0.200
    13.009    36.934     0.200
    13.388    34.178     0.200
    13.603    39.332     0.200
    13.644    33.206     0.200
    13.680    38.995     0.200
    13.828    38.989     0.200
    13.897    39.108     0.200
    13.948    39.613     0.200
    14.038    36.002     0.200
    14.038    34.158     0.200
    14.250    34.726     0.200
    14.674    35.913     0.200
    14.725    40.043     0.200
    14.815    40.060     0.200
    15.255    41.110     0.200
    15.255    37.571     0.200
    15.306    37.967     0.200
    15.306    35.006     0.200
    15.382    39.354     0.200
    15.382    38.339     0.200
    15.426    38.546     0.200
    15.426    36.936     0.200
    15.595    39.438     0.200
    16.457    41.436     0.200
    16.457    38.343     0.200
    16.545    41.013     0.200
    16.545    37.568     0.200
    17.098    40.028     0.200
    17.621    42.045     0.200
    17.621    39.514     0.200
    17.691    39.401     0.200
    17.854    39.177     0.200
    17.885    39.046     0.200
    18.033    38.903     0.200
    18.068    41.852     0.200
    18.175    39.158     0.200
    18.327    39.271     0.200
    18.699    43.605     0.200
    19.409    42.085     0.200
    19.535    42.204     0.200
    20.336    41.746     0.200
     1.127     6.467     0.200
     1.111     6.389     0.200
     1.165     6.784     0.200
     1.189     7.158     0.200
     1.214     6.903     0.200
     1.320     7.064     0.200
     1.320     7.066     0.200
     1.491     7.357     0.200
     1.520     6.842     0.200
     1.675     8.422     0.200
     1.744     8.243     0.200
     1.721     8.223     0.200
     1.903     8.430     0.200
     1.889     8.846     0.200
     1.988     8.851     0.200
     2.131     9.359     0.200
     2.194     9.215     0.200
     2.305     9.336     0.200
     2.396     9.621     0.200
     2.407    10.343     0.200
     2.412     9.783     0.200
     2.433     9.243     0.200
     2.476    10.273     0.200
     2.488     9.798     0.200
     2.474    10.277     0.200
     2.523     9.591     0.200
     2.623     9.868     0.200
     2.550     8.736     0.200
     2.742    10.508     0.200
     2.917    10.833     0.200
     3.010    10.875     0.200
     3.077    12.297     0.200
     3.077    11.539     0.200
     3.127    11.135     0.200
     3.345    13.235     0.200
     3.345    11.171     0.200
     3.413    11.848     0.200
     3.431    11.794     0.200
     3.473    12.958     0.200
     3.548    12.245     0.200
     3.567    12.274     0.200
     3.567    12.153     0.200
     3.588    12.040     0.200
     3.645    12.591     0.200
     3.744    11.742     0.200
     3.686    12.864     0.200
     3.944    14.206     0.200
     3.984    13.283     0.200
     3.998    13.026     0.200
     4.046    13.257     0.200
     4.080    12.560     0.200
     4.080    12.359     0.200
     4.222    14.460     0.200
     4.247    15.340     0.200
     4.247    14.840     0.200
     4.332    14.825     0.200
     4.314    15.239     0.200
     4.391    15.444     0.200
     4.572    15.494     0.200
     4.727    16.647     0.200
     4.842    16.949     0.200
     4.890    15.960     0.200
     4.970    17.266     0.200
     5.130    18.073     0.200
     5.248    17.648     0.200
     5.312    16.067     0.200
     5.299    17.292     0.200
     5.299    17.120     0.200
     5.368    17.090     0.200
     5.367    21.477     0.200
     5.417    19.222     0.200
     5.653    18.604     0.200
     5.694    19.985     0.200
     5.785    18.390     0.200
     5.828    18.868     0.200
     5.828    18.342     0.200
     6.079    19.477     0.200
     6.109    19.346     0.200
     6.101    21.126     0.200
     6.109    19.901     0.200
     6.304    21.689     0.200
     6.346    20.039     0.200
     6.357    19.461     0.200
     6.872    23.055     0.200
     7.066    23.650     0.200
     7.071    20.625     0.200
     7.116    23.418     0.200
     7.116    22.195     0.200
     7.161    25.541     0.200
     7.295    23.443     0.200
     7.446    26.621     0.200
     7.472    25.534     0.200
     7.500    23.274     0.200
     7.487    23.300     0.200
     7.488    24.202     0.200
     7.502    24.868     0.200
     7.493    24.605     0.200
     7.494    24.340     0.200
     7.506    23.433     0.200
     7.513    23.953     0.200
     7.524    23.808     0.200
     7.533    24.029     0.200
     7.535    24.029     0.200
     7.538    23.947     0.200
     7.550    24.482     0.200
     7.570    24.133     0.200
     7.574    24.101     0.200
     7.604    24.325     0.200
     7.623    24.101     0.200
     7.641    26.105     0.200
     7.670    24.142     0.200
     7.759    24.144     0.200
     7.839    26.607     0.200
     7.850    27.388     0.200
     7.783    23.718     0.200
     7.842    25.224     0.200
     8.085    23.694     0.200
     8.125    26.657     0.200
     8.227    24.105     0.200
     8.221    26.823     0.200
     8.230    27.161     0.200
     8.512    23.997     0.200
     8.616    28.147     0.200
     8.714    28.233     0.200
     8.999    27.406     0.200
     9.120    28.405     0.200
     9.197    26.195     0.200
    10.323    31.557     0.200
    10.362    27.990     0.200
    10.378    33.021     0.200
    10.378    30.312     0.200
    10.551    30.345     0.200
    10.545    29.964     0.200
    10.556    33.899     0.200
    10.821    29.527     0.200
    10.946    33.426     0.200
    11.039    32.065     0.200
    11.064    33.548     0.200
    11.159    33.347     0.200
    11.201    34.107     0.200
    11.334    32.046     0.200
    11.537    35.180     0.200
    11.876    35.759     0.200
    11.981    34.659     0.200
    12.516    36.634     0.200
    12.721    36.170     0.200
    13.683    38.676     0.200
    13.703    39.543     0.200
     0.974     6.266     0.200
     0.976     6.140     0.200
     1.040     6.303     0.200
     1.087     6.492     0.200
     1.148     7.142     0.200
     1.196     6.845     0.200
     1.284     7.118     0.200
     1.468     7.362     0.200
     1.551     7.276     0.200
     1.764     8.162     0.200
     1.912     8.357     0.200
     1.968     8.707     0.200
     2.572     9.098     0.200
     3.726    14.655     0.200
     4.110    13.332     0.200
     4.110    12.934     0.200
     4.287    16.138     0.200
     4.930    16.876     0.200
     5.835    17.808     0.200
     6.588    18.936     0.200
     7.277    22.218     0.200
     7.823    26.550     0.200
    10.832    34.567     0.200
     0.926     8.439     0.200
     0.970     6.259     0.200
     0.968     6.127     0.200
     1.033     6.426     0.200
     1.084     6.667     0.200
     1.146     7.407     0.200
     1.170     6.928     0.200
     1.193     6.875     0.200
     1.277     7.155     0.200
     1.460     7.518     0.200
     1.558     7.312     0.200
     1.761     8.253     0.200
     1.759     8.461     0.200
     1.905     8.821     0.200
     1.921     8.871     0.200
     1.973     9.305     0.200
     2.107     9.675     0.200
     2.349    10.602     0.200
     2.395     9.217     0.200
     2.423     9.981     0.200
     2.486    10.670     0.200
     2.486    10.370     0.200
     2.511    10.993     0.200
     2.580     8.899     0.200
     2.580     9.165     0.200
     2.595    10.763     0.200
     2.724    11.003     0.200
     3.051    11.494     0.200
     3.494    13.693     0.200
     3.552    13.532     0.200
     3.642    13.706     0.200
     3.730    14.580     0.200
     3.955    14.994     0.200
     4.118    12.649     0.200
     4.290    16.103     0.200
     4.352    16.427     0.200
     4.423    16.168     0.200
     4.873    17.729     0.200
     4.935    16.805     0.200
     5.002    17.911     0.200
     5.165    19.167     0.200
     5.315    19.062     0.200
     5.346    19.273     0.200
     5.597    16.694     0.200
     5.678    19.295     0.200
     5.728    20.842     0.200
     5.828    21.328     0.200
     5.828    21.328     0.200
     6.346    20.487     0.200
     6.595    18.802     0.200
     6.643    20.075     0.200
     7.159    19.712     0.200
     7.283    22.596     0.200
     7.331    24.496     0.200
     7.499    23.106     0.200
     7.529    23.808     0.200
     7.510    21.377     0.200
     7.534    25.729     0.200
     7.553    26.266     0.200
     7.564    21.360     0.200
     7.575    25.207     0.200
     7.577    25.126     0.200
     7.591    25.841     0.200
     7.610    25.400     0.200
     7.614    25.807     0.200
     7.644    25.584     0.200
     7.710    25.259     0.200
     7.828    23.791     0.200
     7.828    24.706     0.200
     7.878    27.251     0.200
     8.251    24.905     0.200
     8.739    24.399     0.200
     8.739    23.819     0.200
     9.149    26.588     0.200
    10.352    33.263     0.200
    10.749    28.166     0.200
    10.855    28.658     0.200
    10.855    29.160     0.200
    10.856    29.159     0.200
    10.830    29.421     0.200
    10.830    28.399     0.200
    10.830    32.431     0.200
    10.830    31.109     0.200
    12.313    32.994     0.200
    12.539    33.149     0.200
    15.412    37.500     0.200
     0.766     5.373     0.200
     1.127     7.344     0.200
     1.319     7.820     0.200
     1.337     8.237     0.200
     1.378     8.005     0.200
     1.501     7.431     0.200
     1.671     7.439     0.200
     1.671     7.549     0.200
     1.650    10.041     0.200
     1.790     9.005     0.200
     1.805     8.633     0.200
     1.796     8.922     0.200
     1.845     8.628     0.200
     1.881     8.110     0.200
     1.871     9.404     0.200
     2.164     8.771     0.200
     2.246     9.634     0.200
     2.287    10.527     0.200
     2.312    10.313     0.200
     2.312    10.136     0.200
     2.320    10.259     0.200
     2.433     9.837     0.200
     2.536    11.114     0.200
     2.555    11.598     0.200
     2.697    11.535     0.200
     2.697    11.191     0.200
     2.873    11.805     0.200
     2.897    11.317     0.200
     2.919    10.974     0.200
     2.935    11.703     0.200
     2.959    12.424     0.200
     3.150    10.629     0.200
     3.181    12.308     0.200
     3.182    12.235     0.200
     3.415    11.871     0.200
     3.450    14.222     0.200
     3.607    15.151     0.200
     3.921    14.487     0.200
     3.921    14.625     0.200
     4.227    16.261     0.200
     4.299    14.847     0.200
     4.723    15.057     0.200
     4.723    14.908     0.200
     4.716    16.238     0.200
     4.751    16.498     0.200
     4.794    16.713     0.200
     4.794    16.476     0.200
     4.880    19.137     0.200
     4.914    17.040     0.200
     5.275    18.377     0.200
     5.351    18.072     0.200
     5.500    19.476     0.200
     5.515    18.058     0.200
     5.603    21.935     0.200
     5.852    18.807     0.200
     5.856    19.573     0.200
     6.040    20.970     0.200
     6.959    20.785     0.200
     7.206    20.630     0.200
     7.651    25.019     0.200
     7.651    23.527     0.200
     7.918    22.731     0.200
     7.968    27.403     0.200
     7.975    25.398     0.200
     7.974    25.720     0.200
     7.977    26.885     0.200
     7.984    25.387     0.200
     8.010    27.704     0.200
     8.016    25.712     0.200
     8.029    26.835     0.200
     8.042    28.032     0.200
     8.056    25.547     0.200
     8.084    25.535     0.200
     8.117    26.005     0.200
     8.134    26.135     0.200
     8.215    28.619     0.200
     8.230    28.178     0.200
     8.415    24.322     0.200
     9.347    25.208     0.200
     9.741    29.293     0.200
    11.096    35.423     0.200
     1.360     8.437     0.200
     1.395     9.325     0.200
     1.417     9.837     0.200
     1.542     9.110     0.200
     1.555     9.360     0.200
     1.555     9.235     0.200
     1.738    11.009     0.200
     1.833    11.792     0.200
     2.124    10.283     0.200
     2.182    11.273     0.200
     2.366    13.055     0.200
     2.482    11.415     0.200
     2.698    12.582     0.200
     2.694    11.698     0.200
     2.694    11.472     0.200
     2.714    13.060     0.200
     3.057    13.749     0.200
     3.057    12.952     0.200
     3.059    12.983     0.200
     3.194    13.070     0.200
     3.306    12.662     0.200
     3.292    13.718     0.200
     3.304    13.636     0.200
     3.819    14.444     0.200
     3.843    14.193     0.200
     3.956    15.300     0.200
     4.058    16.167     0.200
     4.144    16.427     0.200
     4.236    16.640     0.200
     4.442    16.287     0.200
     4.461    17.240     0.200
     4.493    17.221     0.200
     4.647    18.522     0.200
     4.854    17.969     0.200
     4.896    19.681     0.200
     4.896    17.884     0.200
     4.948    18.268     0.200
     5.147    17.804     0.200
     5.171    17.130     0.200
     5.318    18.807     0.200
     5.376    19.242     0.200
     5.419    19.241     0.200
     5.452    19.211     0.200
     5.553    20.343     0.200
     5.714    19.897     0.200
     5.941    20.068     0.200
     6.909    22.367     0.200
     7.189    23.191     0.200
     7.191    22.477     0.200
     7.195    22.515     0.200
     7.202    23.249     0.200
     7.203    23.403     0.200
     7.209    23.268     0.200
     7.210    22.817     0.200
     7.220    22.979     0.200
     7.235    23.013     0.200
     7.246    23.188     0.200
     7.256    23.350     0.200
     7.257    23.519     0.200
    10.201    30.981     0.200
    11.453    31.799     0.200
     1.023     6.845     0.200
     1.314     7.990     0.200
     1.379     9.495     0.200
     1.368     8.361     0.200
     1.481     7.861     0.200
     1.479     8.742     0.200
     1.629     8.047     0.200
     1.706    10.551     0.200
     1.849     9.090     0.200
     1.852    10.076     0.200
     1.858     9.701     0.200
     1.929    10.131     0.200
     2.058    11.876     0.200
     2.104     9.396     0.200
     2.190     9.585     0.200
     2.282    12.237     0.200
     2.344    10.864     0.200
     2.344    10.161     0.200
     2.447    10.571     0.200
     2.598    11.395     0.200
     2.615    12.902     0.200
     2.757    12.337     0.200
     2.757    11.806     0.200
     2.873    12.245     0.200
     3.088    10.709     0.200
     3.088    10.974     0.200
     3.233    14.995     0.200
     3.233    12.933     0.200
     3.942    16.088     0.200
     3.942    15.549     0.200
     4.253    15.497     0.200
     4.286    16.676     0.200
     4.662    15.935     0.200
     4.662    15.255     0.200
     4.704    16.966     0.200
     4.727    17.206     0.200
     4.757    17.060     0.200
     4.757    16.084     0.200
     5.120    18.940     0.200
     5.267    18.655     0.200
     5.367    18.277     0.200
     5.484    18.411     0.200
     5.671    19.480     0.200
     5.807    19.323     0.200
     5.858    19.516     0.200
     6.051    20.468     0.200
     6.127    19.204     0.200
     6.422    20.748     0.200
     7.147    21.088     0.200
     7.201    22.797     0.200
     7.617    25.588     0.200
     7.696    23.668     0.200
     7.724    24.015     0.200
     7.937    24.607     0.200
     7.941    24.763     0.200
     7.946    24.024     0.200
     7.950    23.369     0.200
     7.958    24.196     0.200
     7.971    24.375     0.200
     7.974    24.526     0.200
     7.983    24.855     0.200
     7.989    25.305     0.200
     8.001    24.287     0.200
     8.016    24.322     0.200
     8.028    27.260     0.200
     8.056    26.711     0.200
     8.088    25.209     0.200
     8.109    24.207     0.200
     8.365    22.929     0.200
    11.089    34.111     0.200
     0.968     6.747     0.200
     1.113     6.344     0.200
     1.211     7.298     0.200
     1.224     7.549     0.200
     1.274     7.041     0.200
     1.315     7.929     0.200
     1.452     6.677     0.200
     1.469     6.591     0.200
     1.432     7.924     0.200
     1.425     8.475     0.200
     1.499     9.079     0.200
     1.535     8.137     0.200
     1.571     9.339     0.200
     1.640     7.299     0.200
     1.640     7.479     0.200
     1.630     7.863     0.200
     1.717     8.561     0.200
     1.782     8.981     0.200
     1.857     6.636     0.200
     1.821     9.051     0.200
     1.803     9.404     0.200
     1.858     9.243     0.200
     1.922     9.813     0.200
     1.978     8.775     0.200
     1.967     9.395     0.200
     2.089     8.909     0.200
     2.168    10.363     0.200
     2.168    10.101     0.200
     2.200    10.338     0.200
     2.241     9.386     0.200
     2.387     8.422     0.200
     2.383    10.449     0.200
     2.530    11.010     0.200
     2.570     9.664     0.200
     2.570    10.324     0.200
     2.659    10.670     0.200
     2.680    10.423     0.200
     2.671    11.327     0.200
     2.706    11.529     0.200
     2.849    11.542     0.200
     2.918    10.554     0.200
     2.905    13.949     0.200
     2.962    11.817     0.200
     3.091    12.453     0.200
     3.170    12.750     0.200
     3.166    12.455     0.200
     3.203    13.001     0.200
     3.453    11.170     0.200
     3.423    13.053     0.200
     3.430    13.623     0.200
     3.549    14.076     0.200
     3.813    14.800     0.200
     3.821    12.877     0.200
     4.274    14.335     0.200
     4.373    15.310     0.200
     4.495    15.622     0.200
     4.536    15.113     0.200
     4.593    16.160     0.200
     4.579    17.020     0.200
     4.656    15.831     0.200
     4.656    16.136     0.200
     4.625    17.822     0.200
     4.756    16.474     0.200
     4.876    17.135     0.200
     4.930    13.995     0.200
     4.930    14.468     0.200
     4.916    16.622     0.200
     5.124    18.855     0.200
     5.124    18.034     0.200
     5.183    17.726     0.200
     5.366    18.411     0.200
     5.437    18.261     0.200
     5.507    17.529     0.200
     5.519    18.599     0.200
     5.528    20.244     0.200
     5.678    19.088     0.200
     5.702    19.291     0.200
     5.797    18.451     0.200
     5.899    20.166     0.200
     6.036    19.884     0.200
     6.078    20.370     0.200
     6.109    20.971     0.200
     6.274    20.883     0.200
     6.312    20.027     0.200
     6.440    18.103     0.200
     6.607    21.918     0.200
     6.883    22.193     0.200
     6.929    19.670     0.200
     6.959    21.504     0.200
     7.066    23.008     0.200
     7.173    20.126     0.200
     7.159    20.892     0.200
     7.259    21.954     0.200
     7.281    21.406     0.200
     7.281    22.793     0.200
     7.282    22.797     0.200
     7.282    22.972     0.200
     7.359    20.935     0.200
     7.330    22.549     0.200
     7.361    22.986     0.200
     7.351    21.675     0.200
     7.481    23.158     0.200
     7.481    22.955     0.200
     7.524    20.348     0.200
     7.558    23.069     0.200
     7.727    23.463     0.200
     7.729    23.884     0.200
     7.733    22.582     0.200
     7.741    23.557     0.200
     7.747    23.855     0.200
     7.748    23.805     0.200
     7.758    23.240     0.200
     7.773    23.675     0.200
     7.803    22.460     0.200
     7.784    23.520     0.200
     7.794    23.776     0.200
     7.796    24.017     0.200
     7.829    23.795     0.200
     7.828    23.853     0.200
     7.849    23.893     0.200
     7.885    24.023     0.200
     7.889    24.429     0.200
     7.898    24.051     0.200
     7.887    23.081     0.200
     7.927    22.291     0.200
     8.019    24.060     0.200
     7.999    24.928     0.200
     8.071    24.168     0.200
     8.093    23.893     0.200
     8.129    24.836     0.200
     8.213    22.880     0.200
     8.216    22.716     0.200
     8.413    23.780     0.200
     8.413    23.593     0.200
     8.413    24.437     0.200
     8.409    23.445     0.200
     8.402    23.236     0.200
     8.753    24.031     0.200
     8.854    23.316     0.200
     8.909    24.088     0.200
     8.909    26.604     0.200
     8.904    22.612     0.200
     9.066    23.970     0.200
     9.283    27.880     0.200
     9.331    25.890     0.200
     9.331    27.332     0.200
     9.457    24.452     0.200
     9.527    25.158     0.200
     9.514    23.714     0.200
     9.576    27.095     0.200
     9.832    27.157     0.200
     9.873    28.260     0.200
     9.873    26.854     0.200
     9.999    26.478     0.200
    10.153    26.800     0.200
    10.159    28.030     0.200
    10.159    27.257     0.200
    10.267    27.560     0.200
    10.303    26.295     0.200
    10.443    27.699     0.200
    10.492    29.570     0.200
    10.492    27.667     0.200
    10.562    27.464     0.200
    10.633    27.220     0.200
    10.667    26.878     0.200
    10.714    28.009     0.200
    10.715    26.707     0.200
    10.715    30.773     0.200
    10.736    27.668     0.200
    10.769    28.233     0.200
    10.771    26.850     0.200
    10.812    28.004     0.200
    10.853    29.695     0.200
    11.159    29.117     0.200
    11.260    27.675     0.200
    11.266    28.641     0.200
    11.414    30.079     0.200
    11.414    28.426     0.200
    11.450    28.675     0.200
    11.496    29.321     0.200
    11.700    30.945     0.200
    11.701    30.752     0.200
    11.925    30.573     0.200
    12.014    31.742     0.200
    12.018    29.793     0.200
    12.322    33.972     0.200
    12.322    30.069     0.200
    12.292    30.169     0.200
    12.801    34.722     0.200
    12.854    35.139     0.200
    12.933    34.418     0.200
    13.436    34.223     0.200
    13.675    34.411     0.200
    13.675    32.861     0.200
    13.830    34.976     0.200
    14.091    33.812     0.200
    14.141    34.767     0.200
    14.141    35.049     0.200
    14.284    34.203     0.200
    14.337    35.403     0.200
    14.464    35.326     0.200
    14.464    36.548     0.200
    14.460    37.218     0.200
    14.508    35.698     0.200
    14.508    36.370     0.200
    14.705    35.658     0.200
    14.705    36.201     0.200
    14.742    37.109     0.200
    14.742    38.644     0.200
    14.773    35.078     0.200
    14.871    36.628     0.200
    14.983    36.834     0.200
    15.328    38.196     0.200
    15.349    37.836     0.200
    15.349    38.156     0.200
    15.538    37.115     0.200
    15.646    36.993     0.200
    15.890    38.144     0.200
    15.998    37.805     0.200
    16.071    37.382     0.200
    16.226    37.840     0.200
    16.522    38.235     0.200
    16.940    39.247     0.200
    16.940    39.086     0.200
    17.168    38.475     0.200
    17.168    39.448     0.200
    17.411    39.648     0.200
    17.518    38.359     0.200
    17.543    40.295     0.200
    17.543    39.744     0.200
    17.538    37.636     0.200
    17.908    38.012     0.200
    18.525    40.943     0.200
    19.760    39.929     0.200
     0.815     5.737     0.200
     0.854     5.998     0.200
     0.897     6.337     0.200
     1.330     8.993     0.200
     1.439     7.172     0.200
     1.439     7.281     0.200
     1.443     8.304     0.200
     1.514     9.602     0.200
     1.585     9.464     0.200
     1.634     7.898     0.200
     1.638     8.940     0.200
     1.825     9.736     0.200
     1.820     9.791     0.200
     1.982     9.226     0.200
     1.981     9.872     0.200
     2.088     9.449     0.200
     2.218    11.201     0.200
     2.399    11.047     0.200
     2.588    11.263     0.200
     2.589    11.256     0.200
     2.662    11.049     0.200
     2.689    11.822     0.200
     2.724    10.364     0.200
     2.724    11.489     0.200
     2.923    13.542     0.200
     3.106    12.495     0.200
     3.183    13.469     0.200
     3.221    13.209     0.200
     3.438    12.905     0.200
     3.445    14.137     0.200
     3.445    14.020     0.200
     4.270    14.687     0.200
     4.381    15.744     0.200
     4.499    16.032     0.200
     4.600    16.633     0.200
     4.597    16.251     0.200
     4.656    16.947     0.200
     4.656    17.150     0.200
     4.765    17.935     0.200
     4.918    15.119     0.200
     4.890    16.476     0.200
     4.925    16.312     0.200
     5.110    18.670     0.200
     5.141    18.367     0.200
     5.141    19.085     0.200
     5.190    18.360     0.200
     5.383    17.286     0.200
     5.448    18.653     0.200
     5.502    17.303     0.200
     5.537    15.913     0.200
     5.710    18.292     0.200
     5.696    17.888     0.200
     5.917    19.043     0.200
     6.046    18.784     0.200
     6.087    19.362     0.200
     6.127    22.081     0.200
     7.349    21.116     0.200
     7.483    20.998     0.200
     8.207    23.883     0.200
     9.516    25.593     0.200
    10.725    33.218     0.200
    11.688    31.487     0.200
     1.312     7.376     0.200
     1.394     7.697     0.200
     1.599     9.294     0.200
     1.563     8.017     0.200
     1.744     8.685     0.200
     2.276    11.464     0.200
     2.287    12.874     0.200
     2.308    12.479     0.200
     2.350    11.884     0.200
     3.299    14.134     0.200
     3.408    14.695     0.200
     3.468    14.580     0.200
     3.657    13.872     0.200
     4.150    14.404     0.200
     4.175    15.350     0.200
     4.198    15.548     0.200
     4.246    15.139     0.200
     4.417    16.087     0.200
     4.822    16.982     0.200
     4.997    19.039     0.200
     5.120    17.023     0.200
     5.212    17.590     0.200
     5.488    18.920     0.200
     5.966    20.261     0.200
     7.040    21.458     0.200
     7.167    22.526     0.200
     7.311    23.125     0.200
     7.387    22.258     0.200
     7.392    22.100     0.200
     7.392    22.111     0.200
     7.395    22.264     0.200
     7.404    22.268     0.200
     7.411    23.244     0.200
     7.423    22.337     0.200
     7.433    22.667     0.200
     7.432    22.046     0.200
     7.436    22.668     0.200
     7.451    22.381     0.200
     7.473    22.269     0.200
     7.471    22.597     0.200
     7.494    22.469     0.200
     7.505    22.340     0.200
     7.529    22.844     0.200
     7.518    22.747     0.200
     7.565    22.321     0.200
     7.657    22.505     0.200
     7.676    22.285     0.200
     7.772    22.246     0.200
     9.155    25.706     0.200
    13.929    35.750     0.200
    14.036    35.383     0.200
     1.256     8.123     0.200
     1.385     9.740     0.200
     1.499     9.929     0.200
     1.736     8.412     0.200
     1.749     9.408     0.200
     1.865    11.639     0.200
     1.860    10.243     0.200
     2.146    12.193     0.200
     2.198    13.058     0.200
     2.375    11.479     0.200
     2.376    12.189     0.200
     2.812    15.358     0.200
     3.250    15.512     0.200
     3.276    15.289     0.200
     3.353    16.447     0.200
     3.753    15.392     0.200
     3.681    15.543     0.200
     4.285    15.156     0.200
     4.242    14.549     0.200
     4.229    16.225     0.200
     4.245    15.814     0.200
     4.679    17.039     0.200
     4.817    17.555     0.200
     4.973    17.150     0.200
     5.302    19.042     0.200
     5.458    20.293     0.200
     5.560    20.689     0.200
     5.540    20.222     0.200
     5.540    20.226     0.200
     5.789    16.845     0.200
     5.948    20.084     0.200
    10.645    32.277     0.200
    11.050    28.604     0.200
     1.004     7.053     0.200
     1.031     6.425     0.200
     1.263     7.416     0.200
     1.263     7.541     0.200
     1.278     7.252     0.200
     1.541     8.073     0.200
     1.644     7.470     0.200
     1.687     8.026     0.200
     1.886    10.484     0.200
     1.954     9.246     0.200
     2.193     9.653     0.200
     2.194    10.066     0.200
     2.240    11.804     0.200
     2.271     9.742     0.200
     2.309     9.716     0.200
     2.315    11.227     0.200
     2.358    10.751     0.200
     2.452    10.024     0.200
     2.710    10.012     0.200
     2.906    13.906     0.200
     3.197    11.743     0.200
     3.254    12.920     0.200
     3.282    13.607     0.200
     3.364    12.044     0.200
     3.430    14.180     0.200
     3.688    13.410     0.200
     3.734    15.270     0.200
     3.734    14.075     0.200
     4.195    14.114     0.200
     4.195    14.575     0.200
     4.197    15.594     0.200
     4.197    16.047     0.200
     4.208    15.271     0.200
     4.245    15.615     0.200
     4.420    16.272     0.200
     4.686    16.873     0.200
     4.820    17.805     0.200
     4.905    16.597     0.200
     5.000    16.932     0.200
     5.098    16.808     0.200
     5.153    17.721     0.200
     5.204    18.727     0.200
     5.241    18.115     0.200
     5.478    18.847     0.200
     5.556    18.228     0.200
     5.697    17.011     0.200
     5.951    18.937     0.200
     5.965    18.279     0.200
     6.130    19.561     0.200
     6.646    18.756     0.200
     6.656    21.141     0.200
     7.060    22.609     0.200
     7.170    22.985     0.200
     7.171    21.333     0.200
     7.186    22.473     0.200
     7.282    21.861     0.200
     7.369    22.922     0.200
     7.401    23.877     0.200
     7.407    21.229     0.200
     7.406    23.250     0.200
     7.424    23.359     0.200
     7.436    21.608     0.200
     7.445    24.285     0.200
     7.447    21.945     0.200
     7.465    23.917     0.200
     7.484    23.110     0.200
     7.488    24.959     0.200
     7.545    22.426     0.200
     7.567    22.819     0.200
     7.578    24.813     0.200
     7.670    22.864     0.200
     7.690    22.688     0.200
     7.806    26.274     0.200
     7.949    27.208     0.200
     8.077    23.509     0.200
     8.804    23.236     0.200
    10.160    27.771     0.200
    10.649    29.008     0.200
    10.649    33.461     0.200
    10.958    30.037     0.200
    10.958    30.029     0.200
     1.009     7.313     0.200
     1.062     6.962     0.200
     1.312     7.238     0.200
     1.377     7.944     0.200
     1.474     8.014     0.200
     1.552     8.095     0.200
     1.609     7.615     0.200
     1.609     7.451     0.200
     1.630     9.121     0.200
     1.638     9.597     0.200
     1.695     8.557     0.200
     1.704     9.583     0.200
     1.847     8.897     0.200
     1.974     9.537     0.200
     2.279     8.446     0.200
     2.311    12.031     0.200
     2.543    10.698     0.200
     2.627    10.878     0.200
     2.627    11.001     0.200
     2.710    11.001     0.200
     2.847    11.475     0.200
     2.884    11.136     0.200
     2.876    14.032     0.200
     3.081    14.821     0.200
     3.325    10.520     0.200
     3.304    13.337     0.200
     3.567    13.387     0.200
     3.590    13.264     0.200
     4.674    16.322     0.200
     4.680    16.649     0.200
     4.832    14.201     0.200
     4.832    14.080     0.200
     5.018    16.992     0.200
     5.269    18.827     0.200
     5.267    18.377     0.200
     5.480    17.716     0.200
     6.975    24.806     0.200
     7.280    20.314     0.200
     7.280    21.472     0.200
     7.513    25.437     0.200
     7.884    22.777     0.200
     8.170    23.633     0.200
     8.938    28.687     0.200
     9.440    25.715     0.200
    11.590    32.663     0.200
    13.453    39.454     0.200
     0.742     5.526     0.200
     0.757     6.036     0.200
     0.783     6.778     0.200
     0.842     5.893     0.200
     0.834     5.645     0.200
     0.807     5.958     0.200
     0.844     5.831     0.200
     0.820     5.869     0.200
     0.830     7.088     0.200
     0.833     6.271     0.200
     0.879     6.047     0.200
     0.918     5.734     0.200
     0.918     5.861     0.200
     0.918     5.742     0.200
     0.967     6.662     0.200
     0.975     7.159     0.200
     1.024     6.933     0.200
     0.985     6.715     0.200
     1.002     7.118     0.200
     1.013     6.688     0.200
     1.029     6.871     0.200
     1.066     6.225     0.200
     1.090     7.156     0.200
     1.063     7.108     0.200
     1.069     7.778     0.200
     1.094     7.583     0.200
     1.151     6.993     0.200
     1.124     7.794     0.200
     1.156     7.970     0.200
     1.184     7.515     0.200
     1.207     8.031     0.200
     1.271     7.603     0.200
     1.258     7.779     0.200
     1.259     7.856     0.200
     1.291     7.490     0.200
     1.361     8.783     0.200
     1.418     9.789     0.200
     1.470     8.330     0.200
     1.502     9.128     0.200
     1.502     9.333     0.200
     1.544     8.663     0.200
     1.569     7.874     0.200
     1.653     9.662     0.200
     1.653     9.846     0.200
     1.768     9.813     0.200
     1.849     9.591     0.200
     1.949    10.110     0.200
     1.954     8.327     0.200
     1.954     8.607     0.200
     1.994     9.405     0.200
     2.017    10.071     0.200
     2.182     9.374     0.200
     2.171    10.547     0.200
     2.193     9.835     0.200
     2.224    10.614     0.200
     2.224    10.751     0.200
     2.287    10.987     0.200
     2.779    12.391     0.200
     2.869    11.734     0.200
     2.886    10.427     0.200
     3.036    12.386     0.200
     3.082    12.448     0.200
     3.195    13.485     0.200
     3.195    12.772     0.200
     3.201    14.027     0.200
     3.473    10.591     0.200
     3.305    13.227     0.200
     3.925    14.003     0.200
     3.965    12.897     0.200
     3.965    13.197     0.200
     4.425    15.144     0.200
     4.606    15.831     0.200
     4.640    15.527     0.200
     4.653    15.509     0.200
     4.672    15.674     0.200
     4.675    15.760     0.200
     4.715    16.006     0.200
     4.738    16.116     0.200
     4.761    15.839     0.200
     4.930    17.317     0.200
     4.930    15.978     0.200
     4.973    16.560     0.200
     5.044    16.658     0.200
     5.261    16.805     0.200
     5.314    17.212     0.200
     5.415    15.851     0.200
     5.482    17.589     0.200
     5.680    17.784     0.200
     6.130    18.098     0.200
     6.130    18.663     0.200
     7.817    22.014     0.200
     9.994    26.144     0.200
     1.040     6.832     0.200
     1.041     6.792     0.200
     1.057     6.817     0.200
     1.088     6.640     0.200
     1.094     7.174     0.200
     1.141     6.820     0.200
     1.200     7.151     0.200
     1.205     7.098     0.200
     1.245     7.718     0.200
     1.261     7.502     0.200
     1.264     7.219     0.200
     1.270     7.336     0.200
     1.354     7.555     0.200
     1.505     8.876     0.200
     1.524     8.162     0.200
     1.524     8.722     0.200
     1.571     8.904     0.200
     1.584     8.256     0.200
     1.589     8.055     0.200
     1.589     9.353     0.200
     1.610     8.224     0.200
     1.654     8.299     0.200
     1.739     8.296     0.200
     1.776     8.687     0.200
     1.998     9.197     0.200
     2.008    10.035     0.200
     2.034     9.296     0.200
     2.144    10.525     0.200
     2.282    11.215     0.200
     2.324     9.645     0.200
     2.354     9.566     0.200
     2.355    12.976     0.200
     2.382    11.020     0.200
     2.444     9.101     0.200
     2.470    10.179     0.200
     2.596    10.316     0.200
     2.669     9.822     0.200
     2.669    10.247     0.200
     2.852    10.985     0.200
     2.949    11.082     0.200
     3.250    11.735     0.200
     3.277    13.236     0.200
     3.327    13.348     0.200
     3.414    11.920     0.200
     3.684    14.701     0.200
     3.784    15.422     0.200
     4.058    13.411     0.200
     4.164    14.797     0.200
     4.205    15.895     0.200
     4.230    16.353     0.200
     4.230    16.053     0.200
     4.278    14.999     0.200
     4.450    16.484     0.200
     4.590    17.832     0.200
     4.722    17.068     0.200
     4.854    17.903     0.200
     4.898    16.780     0.200
     5.029    19.624     0.200
     5.146    15.633     0.200
     5.146    18.079     0.200
     5.229    19.657     0.200
     5.239    18.328     0.200
     5.256    18.845     0.200
     5.518    17.582     0.200
     5.587    21.169     0.200
     5.664    18.347     0.200
     5.977    21.603     0.200
     5.986    17.801     0.200
     5.997    21.501     0.200
     6.621    18.868     0.200
     6.621    20.253     0.200
     7.268    21.818     0.200
     7.468    24.707     0.200
     7.503    25.144     0.200
     7.537    24.960     0.200
     7.545    22.371     0.200
     7.798    24.245     0.200
     7.798    24.893     0.200
     8.776    25.308     0.200
    10.683    31.801     0.200
    10.819    30.121     0.200
    10.922    29.634     0.200
     1.234     9.798     0.200
     1.327     8.440     0.200
     1.336     8.083     0.200
     1.359     8.232     0.200
     1.375     8.449     0.200
     1.384     8.925     0.200
     1.384     9.307     0.200
     1.416     8.546     0.200
     1.435     8.520     0.200
     1.443     9.734     0.200
     1.478     8.832     0.200
     1.483     9.363     0.200
     1.503     8.880     0.200
     1.575     9.288     0.200
     1.611     8.602     0.200
     1.629    10.474     0.200
     1.707    10.874     0.200
     1.804    10.872     0.200
     1.878     9.635     0.200
     1.896    11.655     0.200
     1.923     9.917     0.200
     1.973     9.950     0.200
     2.057    10.088     0.200
     2.057     9.983     0.200
     2.120    10.433     0.200
     2.126    11.676     0.200
     2.331    12.185     0.200
     2.435    11.056     0.200
     2.649    12.725     0.200
     2.665    12.069     0.200
     2.919    13.523     0.200
     3.015    13.209     0.200
     3.245    13.733     0.200
     3.349    12.235     0.200
     3.558    14.618     0.200
     3.823    15.040     0.200
     3.906    15.422     0.200
     4.041    15.587     0.200
     4.149    15.918     0.200
     4.212    15.895     0.200
     4.245    15.893     0.200
     4.395    16.308     0.200
     4.422    16.247     0.200
     4.690    14.701     0.200
     4.752    16.780     0.200
     4.808    17.101     0.200
     4.849    17.385     0.200
     4.849    17.132     0.200
     4.917    17.310     0.200
     5.100    17.649     0.200
     5.152    17.816     0.200
     5.239    16.950     0.200
     5.373    18.140     0.200
     5.894    19.345     0.200
     6.829    22.085     0.200
     6.829    21.245     0.200
     6.976    23.153     0.200
     7.049    21.295     0.200
     7.049    21.600     0.200
     7.183    21.309     0.200
     7.203    21.901     0.200
     7.304    22.237     0.200
     7.974    24.118     0.200
     7.974    23.503     0.200
     9.235    25.908     0.200
    10.176    31.117     0.200
    11.490    31.701     0.200
    11.490    30.881     0.200
     1.242     8.427     0.200
     1.347     8.417     0.200
     1.364     8.760     0.200
     1.371     9.725     0.200
     1.385     9.523     0.200
     1.385     9.168     0.200
     1.405     8.583     0.200
     1.431     9.941     0.200
     1.444     8.570     0.200
     1.483    10.026     0.200
     1.515     8.964     0.200
     1.518     9.025     0.200
     1.580    10.030     0.200
     1.610     9.329     0.200
     1.669    10.605     0.200
     1.688     9.657     0.200
     1.703    11.117     0.200
     1.707    11.267     0.200
     1.804    10.941     0.200
     1.911     9.982     0.200
     1.940    10.679     0.200
     1.985    10.160     0.200
     2.065    10.296     0.200
     2.128    10.212     0.200
     2.445    11.202     0.200
     2.630    11.743     0.200
     2.656    11.714     0.200
     2.677    12.122     0.200
     3.027    13.327     0.200
     3.256    13.870     0.200
     3.343    12.265     0.200
     3.570    14.681     0.200
     3.834    15.090     0.200
     4.051    15.849     0.200
     4.224    16.239     0.200
     4.434    16.442     0.200
     4.434    16.200     0.200
     4.455    17.990     0.200
     4.641    16.857     0.200
     4.688    14.890     0.200
     4.762    17.605     0.200
     4.818    17.592     0.200
     4.860    17.870     0.200
     4.860    17.085     0.200
     4.929    17.745     0.200
     5.077    18.416     0.200
     5.110    18.183     0.200
     5.384    18.988     0.200
     6.842    22.228     0.200
     7.049    21.858     0.200
     7.978    23.545     0.200
    10.188    31.263     0.200
    11.487    31.347     0.200
     0.881     5.816     0.200
     1.077     6.549     0.200
     1.165     6.634     0.200
     1.250     6.904     0.200
     1.250     6.944     0.200
     1.269     7.258     0.200
     1.348     8.652     0.200
     1.452     7.410     0.200
     1.549     8.471     0.200
     1.559     7.634     0.200
     1.565     7.663     0.200
     1.565     8.522     0.200
     1.635     6.494     0.200
     1.857     9.335     0.200
     1.984     8.942     0.200
     1.994     9.327     0.200
     2.120     9.466     0.200
     2.158     9.714     0.200
     2.403     9.784     0.200
     2.265    10.486     0.200
     2.337    11.395     0.200
     2.343    10.718     0.200
     2.423    11.850     0.200
     2.589    10.013     0.200
     2.686     8.959     0.200
     2.934    11.792     0.200
     3.246    12.762     0.200
     3.258    11.231     0.200
     3.357    12.704     0.200
     3.412    11.825     0.200
     3.412    11.363     0.200
     3.724    13.900     0.200
     3.806    13.481     0.200
     3.806    13.638     0.200
     4.191    13.056     0.200
     4.191    12.406     0.200
     4.247    15.472     0.200
     4.260    15.350     0.200
     4.272    15.888     0.200
     4.316    15.318     0.200
     4.489    16.001     0.200
     4.579    16.344     0.200
     4.759    16.862     0.200
     4.892    17.280     0.200
     4.937    16.278     0.200
     5.219    17.714     0.200
     5.280    17.982     0.200
     5.552    18.312     0.200
     5.685    16.363     0.200
     5.677    20.508     0.200
     5.677    18.593     0.200
     5.927    20.409     0.200
     5.919    17.895     0.200
     6.149    20.367     0.200
     6.198    19.782     0.200
     6.492    21.212     0.200
     6.652    19.636     0.200
     6.652    18.761     0.200
     6.717    21.046     0.200
     6.911    22.023     0.200
     6.916    22.353     0.200
     7.186    22.610     0.200
     7.199    21.889     0.200
     7.377    23.068     0.200
     7.562    23.145     0.200
     7.572    23.804     0.200
     7.836    22.798     0.200
     7.836    22.529     0.200
    10.721    32.856     0.200
    10.721    28.697     0.200
    10.946    29.216     0.200
    10.946    28.703     0.200
    14.602    36.527     0.200
     0.792     5.736     0.200
     0.902     6.569     0.200
     1.059     6.614     0.200
     1.097     7.471     0.200
     1.002     6.892     0.200
     1.051     6.651     0.200
     1.211     7.543     0.200
     1.233     7.454     0.200
     1.158     7.300     0.200
     1.348     7.790     0.200
     1.348     7.438     0.200
     1.756     8.773     0.200
     1.932     7.622     0.200
     2.014     8.979     0.200
     2.275     9.769     0.200
     2.738    11.333     0.200
     2.758    11.889     0.200
     2.936    11.692     0.200
     2.936    11.380     0.200
     3.059    10.638     0.200
     3.059    10.942     0.200
     3.188    12.937     0.200
     3.188    12.390     0.200
     3.617    13.072     0.200
     3.659    14.077     0.200
     3.810    14.340     0.200
     3.863    14.515     0.200
     3.988    14.311     0.200
     4.008    15.065     0.200
     4.226    15.420     0.200
     4.372    15.864     0.200
     4.407    13.166     0.200
     4.559    15.951     0.200
     4.595    17.481     0.200
     4.817    15.770     0.200
     4.852    16.430     0.200
     4.993    16.962     0.200
     5.038    16.726     0.200
     5.083    16.661     0.200
     5.083    18.122     0.200
     5.134    18.582     0.200
     5.131    17.402     0.200
     5.336    19.420     0.200
     5.594    19.249     0.200
     5.951    18.182     0.200
     6.780    19.826     0.200
     6.780    19.545     0.200
     6.774    20.174     0.200
     6.961    22.666     0.200
     6.961    21.189     0.200
     7.105    21.036     0.200
     7.379    22.840     0.200
     7.573    23.502     0.200
     8.963    23.888     0.200
    10.195    32.950     0.200
    11.204    29.887     0.200
    11.204    29.979     0.200
    11.204    28.956     0.200
     0.910     6.535     0.200
     0.979     6.611     0.200
     0.996     6.471     0.200
     1.089     6.178     0.200
     1.089     6.280     0.200
     1.088     6.671     0.200
     1.189     7.115     0.200
     1.225     7.486     0.200
     1.297     7.368     0.200
     1.285     7.917     0.200
     1.310     7.249     0.200
     1.334     7.845     0.200
     1.372     6.576     0.200
     1.384     7.242     0.200
     1.415     7.488     0.200
     1.459     8.091     0.200
     1.470     7.465     0.200
     1.468     6.999     0.200
     1.524     8.318     0.200
     1.644     8.484     0.200
     1.644     8.703     0.200
     1.642     8.905     0.200
     1.693     8.466     0.200
     1.671     8.271     0.200
     1.804     7.619     0.200
     1.956     8.539     0.200
     1.970     9.261     0.200
     1.994     9.353     0.200
     1.995     9.318     0.200
     2.043     8.435     0.200
     2.048     8.711     0.200
     2.102     9.796     0.200
     2.132     9.475     0.200
     2.132     9.690     0.200
     2.142     9.728     0.200
     2.222     9.738     0.200
     2.306     9.142     0.200
     2.306     9.291     0.200
     2.495    10.127     0.200
     2.579    10.545     0.200
     2.593    10.893     0.200
     2.651    11.396     0.200
     2.732    11.152     0.200
     2.905    11.678     0.200
     3.022    12.191     0.200
     3.047    12.530     0.200
     3.108    11.428     0.200
     3.236    11.204     0.200
     3.270    11.271     0.200
     3.267    13.093     0.200
     3.572     9.807     0.200
     3.747    14.209     0.200
     3.908    13.170     0.200
     3.978    12.784     0.200
     3.978    12.937     0.200
     4.020    15.574     0.200
     4.108    14.909     0.200
     4.257    14.758     0.200
     4.469    16.841     0.200
     4.501    15.287     0.200
     4.500    14.966     0.200
     4.500    15.505     0.200
     4.508    15.369     0.200
     4.545    15.007     0.200
     4.571    16.364     0.200
     4.588    15.808     0.200
     4.596    16.524     0.200
     4.596    16.661     0.200
     4.648    15.211     0.200
     4.765    16.167     0.200
     4.804    15.746     0.200
     4.804    16.363     0.200
     4.833    17.156     0.200
     4.947    16.546     0.200
     5.166    17.518     0.200
     5.179    17.207     0.200
     5.352    19.124     0.200
     5.431    16.445     0.200
     5.579    18.864     0.200
     5.782    18.448     0.200
     6.022    18.968     0.200
     6.688    20.863     0.200
     6.894    21.716     0.200
     7.021    20.954     0.200
     7.767    21.785     0.200
     8.679    26.475     0.200
     8.679    23.959     0.200
     9.009    26.621     0.200
     9.950    25.524     0.200
     9.950    25.993     0.200
    10.502    31.074     0.200
    10.502    31.756     0.200
    10.502    29.377     0.200
    12.180    32.065     0.200
    15.071    34.461     0.200
     1.142     7.511     0.200
     1.142     7.202     0.200
     1.281     7.910     0.200
     1.298     7.196     0.200
     1.416     6.752     0.200
     1.385     8.209     0.200
     1.415     7.136     0.200
     1.415     6.936     0.200
     1.415     6.796     0.200
     1.463     7.353     0.200
     1.475     6.846     0.200
     1.489     8.143     0.200
     1.498     8.956     0.200
     1.563     7.682     0.200
     1.582     9.013     0.200
     1.582     8.904     0.200
     1.563     8.177     0.200
     1.622     6.815     0.200
     1.622     6.966     0.200
     1.617     9.753     0.200
     1.636     7.725     0.200
     1.645     7.901     0.200
     1.766     7.807     0.200
     1.788     7.512     0.200
     1.764     8.730     0.200
     1.819     8.995     0.200
     1.830     7.424     0.200
     1.876     9.961     0.200
     1.876     9.600     0.200
     1.922     9.355     0.200
     2.012     8.889     0.200
     2.033     9.465     0.200
     2.118    10.391     0.200
     2.102     9.059     0.200
     2.142    10.521     0.200
     2.220    10.211     0.200
     2.294     8.679     0.200
     2.271    10.422     0.200
     2.350     9.009     0.200
     2.453    10.595     0.200
     2.533    10.500     0.200
     2.538    10.415     0.200
     2.581    10.358     0.200
     2.589    11.108     0.200
     2.689    10.453     0.200
     2.712    10.180     0.200
     2.933     8.344     0.200
     2.933     7.815     0.200
     2.741    11.406     0.200
     2.744    11.419     0.200
     2.773    11.613     0.200
     2.773    11.358     0.200
     2.874    12.552     0.200
     2.890    11.483     0.200
     2.914    10.833     0.200
     3.035    11.980     0.200
     3.139    12.164     0.200
     3.230    12.082     0.200
     3.232    12.955     0.200
     3.275    12.625     0.200
     3.407    10.903     0.200
     3.407    11.099     0.200
     3.476    13.031     0.200
     3.500    14.197     0.200
     3.500    13.840     0.200
     3.622    13.953     0.200
     3.622    14.250     0.200
     3.748    14.058     0.200
     3.877    14.311     0.200
     3.885    14.636     0.200
     4.115    15.213     0.200
     4.230    15.326     0.200
     4.275    14.385     0.200
     4.421    15.237     0.200
     4.523    15.944     0.200
     4.530    15.850     0.200
     4.575    13.639     0.200
     4.608    16.730     0.200
     4.651    16.793     0.200
     4.674    16.813     0.200
     4.674    16.100     0.200
     4.697    17.455     0.200
     4.809    16.049     0.200
     4.898    14.850     0.200
     4.898    15.084     0.200
     4.895    16.856     0.200
     4.944    16.387     0.200
     4.944    16.784     0.200
     4.967    16.945     0.200
     5.078    17.829     0.200
     5.123    16.560     0.200
     5.166    17.590     0.200
     5.197    18.957     0.200
     5.197    17.076     0.200
     5.228    17.608     0.200
     5.268    17.632     0.200
     5.411    18.649     0.200
     5.439    18.284     0.200
     5.506    17.494     0.200
     5.497    18.350     0.200
     5.588    18.304     0.200
     5.750    20.254     0.200
     5.752    18.902     0.200
     5.803    18.405     0.200
     5.803    18.549     0.200
     5.972    20.376     0.200
     6.089    20.120     0.200
     7.336    21.337     0.200
     7.340    22.459     0.200
     7.351    23.392     0.200
     7.505    22.532     0.200
     7.700    22.221     0.200
     7.767    22.508     0.200
     7.960    22.942     0.200
     7.960    23.388     0.200
     8.103    23.774     0.200
     8.206    23.165     0.200
     8.413    24.917     0.200
     8.413    24.318     0.200
     8.413    24.798     0.200
     8.931    26.417     0.200
     9.372    27.344     0.200
     9.500    24.846     0.200
     9.546    26.997     0.200
     9.647    31.846     0.200
     9.892    28.222     0.200
     9.892    28.394     0.200
     9.904    30.293     0.200
    10.227    30.909     0.200
    10.329    30.047     0.200
    10.506    29.595     0.200
    10.659    31.350     0.200
    10.751    28.329     0.200
    10.739    29.688     0.200
    10.767    30.211     0.200
    10.769    31.907     0.200
    10.769    33.183     0.200
    11.015    30.419     0.200
    11.197    32.554     0.200
    11.337    32.932     0.200
    11.405    31.356     0.200
    11.568    33.172     0.200
    11.663    31.095     0.200
    11.664    31.289     0.200
    11.664    30.947     0.200
    11.848    34.855     0.200
    12.060    32.521     0.200
    12.060    32.253     0.200
    12.104    32.703     0.200
    12.318    32.774     0.200
    12.462    34.141     0.200
    12.690    37.111     0.200
    12.873    37.115     0.200
    12.912    36.732     0.200
    13.505    38.601     0.200
    13.704    35.808     0.200
    14.126    36.295     0.200
    14.382    36.046     0.200
    14.382    35.733     0.200
    14.438    35.586     0.200
    14.525    34.434     0.200
    14.701    37.080     0.200
    14.814    38.540     0.200
    14.944    38.559     0.200
    15.351    38.164     0.200
    15.503    36.405     0.200
    16.054    39.001     0.200
    16.203    37.816     0.200
    16.547    39.777     0.200
    16.798    39.468     0.200
    16.955    40.171     0.200
    17.169    39.409     0.200
    17.430    40.426     0.200
    17.449    39.891     0.200
    17.513    40.405     0.200
    17.599    40.667     0.200
    17.778    40.342     0.200
    18.139    40.486     0.200
    18.434    40.788     0.200
    18.995    41.654     0.200
    19.561    40.655     0.200
    19.750    41.562     0.200
    20.543    42.738     0.200
     1.067     6.411     0.200
     1.064     6.243     0.200
     1.078     6.282     0.200
     1.126     7.000     0.200
     1.176     7.147     0.200
     1.168     6.725     0.200
     1.192     7.026     0.200
     1.233     6.855     0.200
     1.282     7.069     0.200
     1.323     7.853     0.200
     1.434     8.136     0.200
     1.434     8.261     0.200
     1.486     7.295     0.200
     1.544     6.908     0.200
     1.567     6.601     0.200
     1.682     7.904     0.200
     1.804     8.160     0.200
     1.928     8.817     0.200
     2.206     7.595     0.200
     2.360    10.509     0.200
     2.477    11.090     0.200
     2.555     8.952     0.200
     2.555     8.733     0.200
     2.543    10.499     0.200
     2.530    10.611     0.200
     2.964    11.756     0.200
     3.164    12.089     0.200
     3.318    11.743     0.200
     3.324    13.470     0.200
     3.452    11.845     0.200
     3.537    13.041     0.200
     3.719    11.941     0.200
     3.741    14.238     0.200
     3.736    12.259     0.200
     4.000    14.666     0.200
     4.103    13.436     0.200
     4.103    12.686     0.200
     4.310    15.679     0.200
     4.382    15.897     0.200
     4.441    16.737     0.200
     4.460    15.672     0.200
     4.570    15.041     0.200
     4.911    17.005     0.200
     4.942    16.351     0.200
     5.200    17.454     0.200
     5.304    17.082     0.200
     5.360    16.722     0.200
     5.720    17.546     0.200
     5.873    19.801     0.200
     5.873    19.168     0.200
     6.585    18.821     0.200
     7.567    22.189     0.200
     8.726    23.507     0.200
    10.834    27.526     0.200
    10.835    28.837     0.200
    10.835    27.383     0.200
    10.867    32.852     0.200
     0.930     5.869     0.200
     0.963     6.784     0.200
     0.979     6.305     0.200
     0.979     6.094     0.200
     1.022     6.127     0.200
     1.132     6.615     0.200
     1.190     6.735     0.200
     1.185     7.369     0.200
     1.208     7.113     0.200
     1.270     7.168     0.200
     1.310     7.156     0.200
     1.337     7.958     0.200
     1.534     7.420     0.200
     1.729     7.990     0.200
     1.804     8.391     0.200
     1.852     8.525     0.200
     1.989     8.538     0.200
     2.193     9.032     0.200
     2.450     9.256     0.200
     2.509     8.705     0.200
     3.377    12.774     0.200
     3.508    12.007     0.200
     3.581    14.085     0.200
     3.787    15.111     0.200
     4.051    15.076     0.200
     4.067    13.452     0.200
     4.067    12.776     0.200
     4.315    15.368     0.200
     4.315    14.704     0.200
     4.323    15.427     0.200
     4.485    16.238     0.200
     5.225    18.892     0.200
     5.297    18.559     0.200
     5.297    16.548     0.200
     5.791    19.939     0.200
     5.928    20.686     0.200
     6.554    19.160     0.200
     6.554    18.520     0.200
     7.818    22.765     0.200
    10.793    28.575     0.200
    10.898    32.523     0.200
     0.775     5.825     0.200
     0.863     6.029     0.200
     0.868     5.844     0.200
     0.871     6.209     0.200
     0.871     5.869     0.200
     0.879     6.034     0.200
     0.907     6.149     0.200
     0.921     6.277     0.200
     0.922     6.335     0.200
     0.942     6.475     0.200
     0.990     6.824     0.200
     1.012     6.515     0.200
     1.011     6.725     0.200
     1.037     6.945     0.200
     1.057     6.634     0.200
     1.057     6.790     0.200
     1.091     7.473     0.200
     1.116     6.720     0.200
     1.125     7.126     0.200
     1.125     6.826     0.200
     1.168     7.006     0.200
     1.186     7.178     0.200
     1.208     6.991     0.200
     1.223     7.026     0.200
     1.241     7.195     0.200
     1.246     7.128     0.200
     1.248     7.056     0.200
     1.276     7.113     0.200
     1.323     8.514     0.200
     1.355     7.403     0.200
     1.549     7.870     0.200
     1.582     8.023     0.200
     1.594     8.603     0.200
     1.643     8.790     0.200
     1.697     7.376     0.200
     1.824     8.459     0.200
     1.882     9.690     0.200
     1.907     9.420     0.200
     1.910     8.702     0.200
     1.925     8.829     0.200
     2.029     9.372     0.200
     2.034     9.717     0.200
     2.044     9.177     0.200
     2.244     7.582     0.200
     2.128    10.159     0.200
     2.167     9.600     0.200
     2.334     9.379     0.200
     2.352    11.249     0.200
     2.419    10.244     0.200
     2.475     9.799     0.200
     2.491    10.206     0.200
     2.491    10.042     0.200
     2.648    12.039     0.200
     2.664    10.644     0.200
     2.694     9.077     0.200
     2.694     9.468     0.200
     2.876    11.044     0.200
     2.973    11.104     0.200
     3.134    11.349     0.200
     3.164    11.057     0.200
     3.164    11.921     0.200
     3.305    11.697     0.200
     3.337    12.463     0.200
     3.403    12.284     0.200
     3.505    12.356     0.200
     3.575    12.845     0.200
     3.616    13.383     0.200
     3.874    14.065     0.200
     3.892    13.662     0.200
     4.001    14.350     0.200
     4.001    14.608     0.200
     4.236    14.713     0.200
     4.236    15.010     0.200
     4.256    13.288     0.200
     4.256    13.143     0.200
     4.447    14.094     0.200
     4.447    14.895     0.200
     4.478    14.276     0.200
     4.494    16.168     0.200
     4.534    15.386     0.200
     4.624    15.622     0.200
     5.096    16.503     0.200
     5.270    16.326     0.200
     5.382    17.030     0.200
     5.454    17.195     0.200
     5.454    17.898     0.200
     5.724    16.388     0.200
     5.796    18.149     0.200
     5.836    18.976     0.200
     5.836    18.660     0.200
     6.084    18.635     0.200
     6.140    18.106     0.200
     6.310    19.767     0.200
     6.366    19.915     0.200
     6.639    19.941     0.200
     6.741    18.821     0.200
     6.741    19.590     0.200
     7.338    21.863     0.200
     7.617    21.301     0.200
     7.666    22.134     0.200
     7.724    21.911     0.200
     7.740    21.824     0.200
     7.784    21.385     0.200
     7.965    23.078     0.200
     7.988    22.575     0.200
     7.988    22.989     0.200
     9.655    26.296     0.200
    10.950    29.267     0.200
    10.979    29.314     0.200
    10.979    29.324     0.200
    10.980    29.539     0.200
    12.119    29.740     0.200
     0.773     5.673     0.200
     0.773     5.865     0.200
     0.792     6.147     0.200
     0.801     6.141     0.200
     0.844     6.008     0.200
     0.863     6.307     0.200
     0.877     6.399     0.200
     0.945     6.573     0.200
     0.934     6.418     0.200
     0.941     6.984     0.200
     0.978     6.823     0.200
     0.978     6.503     0.200
     1.059     6.572     0.200
     1.062     6.754     0.200
     1.103     7.169     0.200
     1.121     6.902     0.200
     1.147     7.561     0.200
     1.119     6.818     0.200
     1.133     6.837     0.200
     1.133     6.918     0.200
     1.165     6.944     0.200
     1.225     7.050     0.200
     1.225     7.159     0.200
     1.206     8.408     0.200
     1.264     7.513     0.200
     1.262     7.299     0.200
     1.255     7.182     0.200
     1.367     8.302     0.200
     1.357    10.793     0.200
     1.371     9.641     0.200
     1.371     8.082     0.200
     1.378     8.453     0.200
     1.387     8.439     0.200
     1.473     7.991     0.200
     1.637     9.089     0.200
     1.596     8.108     0.200
     1.656     8.300     0.200
     1.674     9.481     0.200
     1.739     9.402     0.200
     1.725     8.749     0.200
     1.896     9.484     0.200
     2.127     9.489     0.200
     2.176     9.480     0.200
     2.216    11.123     0.200
     2.245     9.765     0.200
     2.561     9.407     0.200
     2.362    10.841     0.200
     2.353    11.075     0.200
     2.382    10.046     0.200
     2.444    10.162     0.200
     2.519    10.119     0.200
     2.596     8.912     0.200
     2.637    11.212     0.200
     2.698    10.871     0.200
     2.811     9.673     0.200
     2.809    10.882     0.200
     2.937    11.119     0.200
     2.971    11.838     0.200
     3.100    11.454     0.200
     3.141    11.329     0.200
     3.175    12.195     0.200
     3.175    11.863     0.200
     3.223    11.823     0.200
     3.261    11.867     0.200
     3.261    12.059     0.200
     3.458    12.338     0.200
     3.552    13.905     0.200
     3.656    13.468     0.200
     3.656    14.202     0.200
     3.914    14.058     0.200
     4.126    15.015     0.200
     4.173    14.881     0.200
     4.206    14.776     0.200
     4.224    16.637     0.200
     4.220    14.915     0.200
     4.215    14.539     0.200
     4.285    14.560     0.200
     4.401    15.767     0.200
     4.654    15.794     0.200
     4.791    15.819     0.200
     4.907    15.805     0.200
     4.961    15.506     0.200
     5.030    16.335     0.200
     5.030    17.917     0.200
     5.079    16.827     0.200
     5.287    17.714     0.200
     5.287    18.445     0.200
     5.420    18.662     0.200
     5.432    18.421     0.200
     5.518    17.713     0.200
     5.792    17.578     0.200
     5.790    18.840     0.200
     5.922    17.578     0.200
     6.040    19.059     0.200
     6.559    21.065     0.200
     6.729    20.022     0.200
     6.729    20.127     0.200
     7.164    21.834     0.200
     7.158    20.616     0.200
     7.208    21.457     0.200
     7.416    22.112     0.200
     7.432    24.180     0.200
     7.534    22.395     0.200
     7.633    22.405     0.200
     7.864    23.689     0.200
    10.620    32.910     0.200
    11.052    29.580     0.200
    11.052    29.598     0.200
    11.053    28.086     0.200
    11.053    29.590     0.200
     0.772     5.624     0.200
     0.776     5.976     0.200
     0.795     5.987     0.200
     0.803     6.002     0.200
     0.850     5.743     0.200
     0.866     6.120     0.200
     0.879     6.334     0.200
     0.940     6.217     0.200
     0.946     6.417     0.200
     0.946     6.587     0.200
     0.985     6.581     0.200
     0.985     6.458     0.200
     1.003     6.239     0.200
     1.036     6.720     0.200
     1.057     6.448     0.200
     1.065     6.614     0.200
     1.106     6.957     0.200
     1.116     6.736     0.200
     1.121     6.649     0.200
     1.135     6.844     0.200
     1.136     6.886     0.200
     1.161     7.047     0.200
     1.221     7.547     0.200
     1.210     7.663     0.200
     1.222     7.219     0.200
     1.222     7.019     0.200
     1.259     7.382     0.200
     1.257     7.509     0.200
     1.257     7.359     0.200
     1.262     7.228     0.200
     1.328     7.559     0.200
     1.362     8.283     0.200
     1.364     8.071     0.200
     1.361     8.224     0.200
     1.376     8.347     0.200
     1.384     8.628     0.200
     1.392     8.019     0.200
     1.456     7.627     0.200
     1.480     8.095     0.200
     1.603     8.296     0.200
     1.630     9.235     0.200
     1.678     9.177     0.200
     1.736     7.430     0.200
     1.731     8.813     0.200
     1.726     8.854     0.200
     1.855     9.033     0.200
     1.867     9.707     0.200
     2.101    10.213     0.200
     2.135     9.460     0.200
     2.172    10.328     0.200
     2.183     9.292     0.200
     2.219    11.847     0.200
     2.364    10.480     0.200
     2.358    11.060     0.200
     2.553     9.222     0.200
     2.449    10.525     0.200
     2.526    11.348     0.200
     2.591     9.242     0.200
     2.643    11.312     0.200
     2.808    10.257     0.200
     2.817    11.023     0.200
     2.979    12.943     0.200
     3.107    11.760     0.200
     3.146    12.357     0.200
     3.231    13.177     0.200
     3.266    12.516     0.200
     3.266    12.356     0.200
     3.462    13.885     0.200
     3.559    14.739     0.200
     3.663    14.683     0.200
     3.663    14.253     0.200
     3.677    13.711     0.200
     3.737    14.669     0.200
     3.921    15.886     0.200
     4.058    14.891     0.200
     4.134    15.572     0.200
     4.180    15.490     0.200
     4.228    16.374     0.200
     4.226    15.301     0.200
     4.222    14.969     0.200
     4.284    14.922     0.200
     4.284    15.366     0.200
     4.333    16.525     0.200
     4.408    16.196     0.200
     4.451    15.414     0.200
     4.591    15.960     0.200
     4.660    17.205     0.200
     4.798    17.933     0.200
     4.914    16.731     0.200
     4.963    16.687     0.200
     5.038    17.760     0.200
     5.290    18.618     0.200
     5.525    17.743     0.200
     5.797    18.186     0.200
     5.821    19.055     0.200
     5.998    19.217     0.200
     6.673    20.671     0.200
     6.728    20.321     0.200
     6.765    20.695     0.200
     7.034    21.161     0.200
     7.049    21.400     0.200
     7.349    20.922     0.200
    10.626    31.493     0.200
    11.050    31.567     0.200
    15.020    34.480     0.200
    15.029    39.355     0.200
    15.211    36.674     0.200
     1.054     6.739     0.200
     1.074     6.942     0.200
     1.088     6.908     0.200
     1.114     7.223     0.200
     1.134     6.963     0.200
     1.131     6.959     0.200
     1.146     7.417     0.200
     1.145     6.984     0.200
     1.239     7.237     0.200
     1.268     7.545     0.200
     1.319     7.580     0.200
     1.351     9.447     0.200
     1.380     8.471     0.200
     1.379     8.136     0.200
     1.379     8.026     0.200
     1.459     8.143     0.200
     1.469     7.937     0.200
     1.597     7.996     0.200
     1.647     9.620     0.200
     1.642     8.755     0.200
     1.683     9.337     0.200
     1.714     8.792     0.200
     1.726     9.426     0.200
     1.733     9.398     0.200
     1.862     9.144     0.200
     1.874     9.482     0.200
     1.908    10.168     0.200
     2.125     9.821     0.200
     2.175    10.700     0.200
     2.178    10.503     0.200
     2.179     9.549     0.200
     2.179     9.695     0.200
     2.228    11.203     0.200
     2.341    10.941     0.200
     2.559     9.733     0.200
     2.453    10.171     0.200
     2.512    12.284     0.200
     2.588     9.048     0.200
     2.621    10.219     0.200
     2.645    10.752     0.200
     2.704    10.537     0.200
     2.800    10.250     0.200
     3.103    11.470     0.200
     3.151    11.596     0.200
     3.268    11.642     0.200
     3.268    11.895     0.200
     3.469    14.088     0.200
     3.551    14.318     0.200
     3.654    13.729     0.200
     3.745    14.102     0.200
     3.915    14.098     0.200
     4.065    14.275     0.200
     4.121    15.467     0.200
     4.174    14.651     0.200
     4.194    15.396     0.200
     4.210    15.599     0.200
     4.210    16.153     0.200
     4.210    15.058     0.200
     4.217    14.634     0.200
     4.272    13.704     0.200
     4.272    15.043     0.200
     4.391    16.099     0.200
     4.447    15.152     0.200
     4.584    15.781     0.200
     4.645    16.766     0.200
     4.782    16.907     0.200
     4.907    16.832     0.200
     4.946    16.959     0.200
     4.973    17.225     0.200
     5.027    17.238     0.200
     5.027    18.005     0.200
     5.058    17.590     0.200
     5.089    17.793     0.200
     5.273    17.695     0.200
     5.273    18.176     0.200
     5.423    18.021     0.200
     5.424    18.345     0.200
     5.520    18.061     0.200
     5.525    18.382     0.200
     5.636    19.209     0.200
     5.779    18.876     0.200
     5.784    17.719     0.200
     5.826    19.090     0.200
     6.042    19.184     0.200
     6.052    19.070     0.200
     6.671    20.173     0.200
     6.715    19.723     0.200
     6.715    20.063     0.200
     6.761    20.673     0.200
     6.911    20.982     0.200
     7.048    20.834     0.200
     7.150    19.653     0.200
     7.207    21.678     0.200
     7.428    22.701     0.200
     7.476    21.410     0.200
     7.520    22.014     0.200
     7.530    22.163     0.200
     7.618    22.225     0.200
     7.778    22.414     0.200
     7.849    24.848     0.200
     8.019    22.697     0.200
    10.610    32.107     0.200
    11.040    28.918     0.200
    11.040    31.438     0.200
    14.459    37.207     0.200
    14.974    36.673     0.200
    15.012    37.031     0.200
     0.773     5.821     0.200
     0.791     5.962     0.200
     0.800     6.037     0.200
     0.944     6.605     0.200
     0.986     6.652     0.200
     1.054     6.470     0.200
     1.062     6.568     0.200
     1.109     6.939     0.200
     1.114     6.720     0.200
     1.118     6.615     0.200
     1.132     6.650     0.200
     1.133     6.671     0.200
     1.219     6.973     0.200
     1.219     7.001     0.200
     1.257     7.330     0.200
     1.258     7.072     0.200
     1.325     7.413     0.200
     1.358     8.146     0.200
     1.360     7.819     0.200
     1.374     8.157     0.200
     1.374     7.905     0.200
     1.382     8.353     0.200
     1.389     8.091     0.200
     1.446     7.649     0.200
     1.453     7.382     0.200
     1.480     7.453     0.200
     1.602     7.646     0.200
     1.629     8.797     0.200
     1.675     9.118     0.200
     1.723     8.876     0.200
     1.740     7.647     0.200
     1.852     8.849     0.200
     1.896    10.011     0.200
     2.098     9.855     0.200
     2.169    10.140     0.200
     2.182    10.928     0.200
     2.216    10.481     0.200
     2.216    10.961     0.200
     2.360    10.734     0.200
     2.367    10.749     0.200
     2.446     9.839     0.200
     2.527    12.427     0.200
     2.594     8.626     0.200
     2.640    10.900     0.200
     2.811     9.616     0.200
     2.815    11.986     0.200
     2.977    12.433     0.200
     3.105    11.336     0.200
     3.143    11.456     0.200
     3.231    13.662     0.200
     3.264    13.012     0.200
     3.459    15.387     0.200
     3.662    14.638     0.200
     3.919    15.929     0.200
     4.134    15.267     0.200
     4.179    15.773     0.200
     4.213    15.947     0.200
     4.221    14.503     0.200
     4.228    15.362     0.200
     4.230    16.059     0.200
     4.287    14.318     0.200
     4.287    12.974     0.200
     4.409    16.075     0.200
     4.450    16.671     0.200
     4.589    16.211     0.200
     4.661    16.139     0.200
     4.966    16.437     0.200
     4.991    19.249     0.200
     5.081    16.545     0.200
     5.293    17.678     0.200
     5.439    18.070     0.200
     5.444    16.737     0.200
     5.482    19.314     0.200
     5.524    17.845     0.200
     5.524    18.854     0.200
     5.543    19.721     0.200
     5.774    19.233     0.200
     5.793    17.157     0.200
     5.798    17.189     0.200
     5.819    18.745     0.200
     5.926    19.287     0.200
     6.046    19.058     0.200
     6.050    19.596     0.200
     6.339    19.732     0.200
     6.712    20.612     0.200
     6.732    20.197     0.200
     6.732    19.325     0.200
     6.763    19.514     0.200
     7.168    22.892     0.200
     7.352    21.340     0.200
     7.359    20.163     0.200
     7.440    23.869     0.200
     7.869    22.953     0.200
     7.910    21.458     0.200
    10.627    33.166     0.200
    11.054    29.540     0.200
     0.863     6.207     0.200
     0.876     6.350     0.200
     0.956     6.497     0.200
     0.943     6.681     0.200
     0.985     6.623     0.200
     1.001     6.592     0.200
     1.035     6.568     0.200
     1.108     7.220     0.200
     1.115     6.959     0.200
     1.115     7.060     0.200
     1.118     6.816     0.200
     1.132     6.870     0.200
     1.220     7.333     0.200
     1.258     7.606     0.200
     1.259     7.417     0.200
     1.307     7.557     0.200
     1.363     9.058     0.200
     1.381     8.681     0.200
     1.388     8.126     0.200
     1.479     8.000     0.200
     1.479     9.068     0.200
     1.630     9.563     0.200
     1.852     8.916     0.200
     2.811    10.245     0.200
     2.811     9.620     0.200
     3.918    15.892     0.200
     4.132    16.163     0.200
     4.178    14.915     0.200
     4.212    15.571     0.200
     4.220    14.615     0.200
     4.226    16.367     0.200
     4.229    16.212     0.200
     4.287    14.041     0.200
     4.443    15.502     0.200
     4.449    15.222     0.200
     4.660    17.985     0.200
     4.798    18.801     0.200
     4.965    16.576     0.200
     5.080    18.320     0.200
     5.523    18.139     0.200
     5.796    17.404     0.200
     6.338    19.563     0.200
     6.563    21.688     0.200
     6.732    20.602     0.200
     7.089    22.255     0.200
     7.168    24.400     0.200
     7.351    20.658     0.200
     7.868    23.192     0.200
    10.626    31.537     0.200
    11.054    28.739     0.200
     1.033     7.033     0.200
     1.045     6.510     0.200
     1.050     8.012     0.200
     1.059     6.724     0.200
     1.409     8.542     0.200
     1.543     8.096     0.200
     1.586     9.192     0.200
     1.601     9.692     0.200
     2.019     9.398     0.200
     2.049     8.984     0.200
     2.408    10.251     0.200
     3.263    11.413     0.200
     3.327    14.810     0.200
     3.625    15.674     0.200
     4.140    14.780     0.200
     4.270    15.058     0.200
     4.372    14.901     0.200
     4.440    15.671     0.200
     4.604    15.924     0.200
     5.148    19.431     0.200
     5.515    19.735     0.200
     5.675    18.878     0.200
     5.989    21.351     0.200
     6.597    19.457     0.200
     7.058    22.870     0.200
     7.428    24.800     0.200
     7.775    25.568     0.200
    10.675    31.706     0.200
     0.981     6.219     0.200
     0.981     6.524     0.200
     1.013     6.197     0.200
     1.031     6.373     0.200
     1.050     6.773     0.200
     1.059     6.452     0.200
     1.071     6.745     0.200
     1.146     7.169     0.200
     1.155     6.849     0.200
     1.164     6.964     0.200
     1.192     6.992     0.200
     1.192     6.797     0.200
     1.216     7.299     0.200
     1.216     7.049     0.200
     1.219     6.995     0.200
     1.306     7.186     0.200
     1.306     7.311     0.200
     1.306     7.428     0.200
     1.341     7.379     0.200
     1.348     7.900     0.200
     1.411     7.867     0.200
     1.504     7.749     0.200
     1.522     6.946     0.200
     1.567     8.293     0.200
     1.700     8.152     0.200
     1.798     8.114     0.200
     1.942     9.278     0.200
     1.942     8.747     0.200
     1.951     8.584     0.200
     2.274     8.204     0.200
     2.336    10.288     0.200
     2.464     9.890     0.200
     2.493    11.231     0.200
     2.525    10.363     0.200
     2.537     9.027     0.200
     2.537     8.926     0.200
     2.533    10.266     0.200
     2.797    11.099     0.200
     3.165    11.686     0.200
     3.231    11.963     0.200
     3.323    11.781     0.200
     3.456    11.860     0.200
     3.528    12.930     0.200
     3.752    13.209     0.200
     3.996    13.328     0.200
     4.081    13.058     0.200
     4.287    14.592     0.200
     4.287    14.225     0.200
     4.363    15.422     0.200
     4.432    15.414     0.200
     4.444    15.352     0.200
     4.606    16.399     0.200
     4.801    15.479     0.200
     4.897    17.162     0.200
     4.918    16.187     0.200
     5.024    17.627     0.200
     5.182    17.840     0.200
     5.353    16.428     0.200
     5.464    16.678     0.200
     5.459    18.252     0.200
     5.557    16.421     0.200
     5.746    17.933     0.200
     5.777    19.338     0.200
     5.875    18.646     0.200
     6.084    18.341     0.200
     6.562    19.080     0.200
     7.157    22.571     0.200
     7.259    20.689     0.200
     7.621    23.669     0.200
     7.750    25.909     0.200
     7.809    22.772     0.200
     7.821    23.186     0.200
     7.893    22.978     0.200
     8.704    23.431     0.200
    10.815    28.548     0.200
    10.851    34.670     0.200
     0.976     6.230     0.200
     0.979     6.506     0.200
     1.032     6.465     0.200
     1.011     6.305     0.200
     1.048     6.567     0.200
     1.057     6.505     0.200
     1.068     6.642     0.200
     1.077     6.475     0.200
     1.144     7.167     0.200
     1.153     6.939     0.200
     1.162     7.019     0.200
     1.191     6.956     0.200
     1.190     6.836     0.200
     1.215     7.276     0.200
     1.215     7.175     0.200
     1.219     7.038     0.200
     1.346     7.977     0.200
     1.339     7.673     0.200
     1.383     7.606     0.200
     1.408     7.685     0.200
     1.501     8.169     0.200
     1.501     7.676     0.200
     1.524     7.194     0.200
     1.698     8.110     0.200
     1.796     8.313     0.200
     1.942     9.137     0.200
     1.942     9.035     0.200
     1.949     8.773     0.200
     2.208     7.914     0.200
     2.277     8.230     0.200
     2.337    10.220     0.200
     2.463     9.786     0.200
     2.539     9.147     0.200
     2.525    10.405     0.200
     2.531     9.707     0.200
     2.796    11.292     0.200
     2.972    11.562     0.200
     3.230    12.267     0.200
     3.321    11.250     0.200
     3.454    12.106     0.200
     3.527    13.391     0.200
     3.598    11.976     0.200
     3.749    13.097     0.200
     3.898    13.770     0.200
     3.994    13.950     0.200
     3.994    14.318     0.200
     4.084    12.767     0.200
     4.084    12.994     0.200
     4.288    14.772     0.200
     4.288    14.890     0.200
     4.363    15.618     0.200
     4.430    15.383     0.200
     4.443    15.796     0.200
     4.606    16.459     0.200
     4.799    15.309     0.200
     4.896    17.226     0.200
     4.919    17.055     0.200
     4.935    16.193     0.200
     5.023    16.353     0.200
     5.182    17.829     0.200
     5.351    17.150     0.200
     5.466    16.638     0.200
     5.456    17.639     0.200
     5.559    16.254     0.200
     5.746    19.048     0.200
     5.775    19.083     0.200
     5.830    18.581     0.200
     5.872    18.593     0.200
     6.082    18.598     0.200
     6.161    20.604     0.200
     6.393    20.734     0.200
     6.564    19.189     0.200
     7.158    22.713     0.200
     7.346    22.841     0.200
     7.437    21.287     0.200
     7.499    21.941     0.200
     7.553    21.788     0.200
     7.560    24.068     0.200
     7.748    26.724     0.200
     7.810    23.959     0.200
     8.706    23.687     0.200
    10.817    28.849     0.200
    10.851    32.982     0.200
     1.027     6.706     0.200
     1.022     6.782     0.200
     1.064     7.074     0.200
     1.029     7.574     0.200
     1.078     7.363     0.200
     1.119     7.686     0.200
     1.130     7.406     0.200
     1.181     7.067     0.200
     1.240     7.149     0.200
     1.220     7.368     0.200
     1.248     8.815     0.200
     1.569     8.113     0.200
     1.598     8.402     0.200
     1.668     8.517     0.200
     1.862     9.459     0.200
     1.976     8.589     0.200
     2.145     9.983     0.200
     2.188     9.469     0.200
     2.506    11.236     0.200
     2.576    10.891     0.200
     2.666    12.217     0.200
     2.760     9.752     0.200
     2.796    11.115     0.200
     2.912    11.032     0.200
     2.978    11.154     0.200
     3.020    10.952     0.200
     3.135    11.888     0.200
     3.263    11.943     0.200
     3.334    12.782     0.200
     3.699    13.882     0.200
     3.895    14.536     0.200
     4.232    15.543     0.200
     4.396    16.311     0.200
     4.405    16.100     0.200
     4.405    16.032     0.200
     4.431    16.041     0.200
     4.481    16.920     0.200
     4.531    15.724     0.200
     4.577    14.704     0.200
     4.823    16.769     0.200
     4.968    16.714     0.200
     4.980    15.603     0.200
     5.028    16.286     0.200
     5.107    17.482     0.200
     5.184    15.435     0.200
     5.232    16.292     0.200
     5.279    16.045     0.200
     5.379    17.364     0.200
     5.451    18.196     0.200
     5.488    20.241     0.200
     5.488    18.827     0.200
     5.556    16.797     0.200
     5.652    19.298     0.200
     5.727    17.974     0.200
     5.866    17.325     0.200
     5.908    18.004     0.200
     5.924    17.369     0.200
     5.941    17.961     0.200
     6.026    18.179     0.200
     6.098    17.802     0.200
     6.101    19.214     0.200
     6.123    18.787     0.200
     6.283    18.597     0.200
     6.591    19.321     0.200
     6.761    20.278     0.200
     6.988    19.739     0.200
     7.335    21.084     0.200
     7.362    21.211     0.200
     7.406    20.386     0.200
     7.514    20.012     0.200
     7.654    22.369     0.200
     7.708    21.192     0.200
     7.721    21.689     0.200
     7.900    21.101     0.200
     7.934    21.711     0.200
     8.135    22.461     0.200
    10.792    33.428     0.200
     0.880     6.070     0.200
     0.972     6.228     0.200
     0.981     6.345     0.200
     0.988     6.973     0.200
     0.992     9.536     0.200
     1.018     6.699     0.200
     1.081     6.678     0.200
     1.084     6.736     0.200
     1.082     6.972     0.200
     1.084     6.635     0.200
     1.122     6.835     0.200
     1.153     7.039     0.200
     1.172     6.838     0.200
     1.179     6.854     0.200
     1.192     7.305     0.200
     1.197     7.230     0.200
     1.237     7.309     0.200
     1.237     7.207     0.200
     1.309     7.353     0.200
     1.350     7.934     0.200
     1.490     9.228     0.200
     1.514     9.450     0.200
     1.526     8.350     0.200
     1.540     8.539     0.200
     1.548     7.758     0.200
     1.646     9.044     0.200
     1.769     9.167     0.200
     2.405     8.415     0.200
     2.327    11.066     0.200
     2.332    11.220     0.200
     2.432    11.591     0.200
     2.582    10.056     0.200
     2.645    12.960     0.200
     2.696     9.576     0.200
     2.696     9.857     0.200
     2.965    12.941     0.200
     3.070    11.489     0.200
     3.126    13.967     0.200
     3.361    13.077     0.200
     3.405    13.666     0.200
     3.579    13.660     0.200
     3.736    14.198     0.200
     3.807    14.790     0.200
     4.264    15.675     0.200
     4.281    15.781     0.200
     4.324    14.651     0.200
     4.497    16.672     0.200
     4.600    15.651     0.200
     5.211    17.308     0.200
     5.292    17.884     0.200
     5.576    18.823     0.200
     5.674    20.490     0.200
     6.664    19.745     0.200
    10.728    32.835     0.200
     0.747     5.405     0.200
     0.741     5.255     0.200
     0.767     5.313     0.200
     0.803     5.690     0.200
     0.817     5.610     0.200
     0.843     5.892     0.200
     0.855     5.593     0.200
     0.868     6.471     0.200
     0.940     5.962     0.200
     0.928     5.950     0.200
     0.966     6.093     0.200
     1.020     7.053     0.200
     1.020     7.343     0.200
     1.076     7.303     0.200
     1.117     7.229     0.200
     1.161     8.147     0.200
     1.238     7.719     0.200
     1.294     7.820     0.200
     1.293     8.250     0.200
     1.304     8.466     0.200
     1.347     8.646     0.200
     1.426     8.698     0.200
     1.457     8.608     0.200
     1.498     7.593     0.200
     1.611     8.419     0.200
     1.635     8.371     0.200
     1.673     8.705     0.200
     1.743     8.023     0.200
     1.742     9.738     0.200
     1.762     8.593     0.200
     1.858    10.247     0.200
     2.128    10.385     0.200
     2.156    10.076     0.200
     2.233     9.715     0.200
     2.263     9.473     0.200
     2.318     9.188     0.200
     2.320    10.115     0.200
     2.361    11.021     0.200
     2.362    10.308     0.200
     2.520    10.695     0.200
     2.550    10.531     0.200
     2.550    10.138     0.200
     2.760    10.817     0.200
     2.819    11.347     0.200
     2.899    11.639     0.200
     2.897    11.365     0.200
     3.015     9.945     0.200
     3.009    11.522     0.200
     2.992    12.210     0.200
     2.992    12.002     0.200
     3.010    11.874     0.200
     3.012    11.834     0.200
     3.026    11.926     0.200
     3.262    12.366     0.200
     3.260    12.867     0.200
     3.325    10.552     0.200
     3.325    10.890     0.200
     3.317    12.619     0.200
     3.432    13.176     0.200
     3.514    13.119     0.200
     3.528    13.514     0.200
     3.629    13.332     0.200
     3.788    13.999     0.200
     3.788    14.293     0.200
     3.898    14.768     0.200
     3.898    14.881     0.200
     4.182    15.397     0.200
     4.384    14.950     0.200
     4.518    16.663     0.200
     4.593    16.100     0.200
     4.686    14.785     0.200
     4.749    16.236     0.200
     4.840    16.259     0.200
     4.840    16.667     0.200
     4.878    14.626     0.200
     4.878    15.028     0.200
     4.859    16.715     0.200
     4.942    16.669     0.200
     4.944    16.730     0.200
     5.072    16.487     0.200
     5.066    16.145     0.200
     5.226    17.299     0.200
     5.232    17.836     0.200
     5.232    17.333     0.200
     5.436    17.940     0.200
     5.436    17.713     0.200
     5.465    18.456     0.200
     5.607    17.657     0.200
     6.022    19.043     0.200
     6.085    18.297     0.200
     6.355    18.086     0.200
     7.285    22.035     0.200
     7.348    21.326     0.200
     7.639    22.006     0.200
     8.511    22.928     0.200
    11.037    29.038     0.200
    11.037    30.476     0.200
    11.037    32.006     0.200
    11.612    29.590     0.200
    11.612    30.869     0.200
     0.761     5.348     0.200
     0.759     5.055     0.200
     0.733     5.683     0.200
     0.782     5.176     0.200
     0.782     5.192     0.200
     0.777     5.193     0.200
     0.823     5.322     0.200
     0.809     5.611     0.200
     0.866     5.524     0.200
     0.829     5.890     0.200
     0.837     6.224     0.200
     0.881     5.700     0.200
     0.857     6.377     0.200
     0.900     5.744     0.200
     0.920     5.620     0.200
     0.912     5.688     0.200
     0.927     5.816     0.200
     0.962     7.648     0.200
     0.985     6.135     0.200
     0.978     6.763     0.200
     1.010     6.953     0.200
     1.082     6.874     0.200
     1.086     7.281     0.200
     1.094     7.472     0.200
     1.185     7.334     0.200
     1.164     7.587     0.200
     1.207     7.839     0.200
     1.207     7.683     0.200
     1.231     8.014     0.200
     1.317     7.135     0.200
     1.340     8.000     0.200
     1.469     8.025     0.200
     1.546     9.081     0.200
     1.592     8.326     0.200
     1.680     7.776     0.200
     1.780     9.147     0.200
     1.819     9.542     0.200
     1.849     9.443     0.200
     2.021     9.380     0.200
     2.069    10.378     0.200
     2.148    10.218     0.200
     2.416    10.286     0.200
     2.482    10.571     0.200
     2.701    10.972     0.200
     2.680    11.621     0.200
     2.688    11.312     0.200
     2.802    12.680     0.200
     2.958    10.761     0.200
     3.203    12.367     0.200
     3.292    11.796     0.200
     4.537    16.367     0.200
     4.699    14.664     0.200
     4.902    16.629     0.200
     5.134    15.387     0.200
    14.762    34.890     0.200
     0.772     5.883     0.200
     0.867     6.289     0.200
     0.835     5.763     0.200
     0.842     6.300     0.200
     0.904     6.294     0.200
     0.876     5.944     0.200
     0.908     6.432     0.200
     0.957     6.497     0.200
     1.028     7.196     0.200
     1.023     7.070     0.200
     1.103     7.784     0.200
     1.152     7.674     0.200
     1.218     7.846     0.200
     1.218     7.708     0.200
     1.270     7.865     0.200
     1.279     7.390     0.200
     1.330     7.988     0.200
     1.368     7.932     0.200
     1.435     8.641     0.200
     1.522     7.672     0.200
     1.522     7.540     0.200
     1.548     8.619     0.200
     1.627     8.936     0.200
     1.646     8.297     0.200
     1.680     8.898     0.200
     1.852     8.770     0.200
     1.861     9.849     0.200
     1.936     9.666     0.200
     1.916     9.641     0.200
     1.976     9.728     0.200
     2.065     9.893     0.200
     2.089     9.958     0.200
     2.173    10.480     0.200
     2.279    10.522     0.200
     2.333    10.289     0.200
     2.338    10.646     0.200
     2.430     9.529     0.200
     2.393    10.492     0.200
     2.480    10.960     0.200
     2.510    11.400     0.200
     2.580    10.989     0.200
     2.751    12.255     0.200
     2.748    12.956     0.200
     2.896    12.552     0.200
     2.970    12.460     0.200
     3.042    12.023     0.200
     3.309    10.898     0.200
     3.185    13.154     0.200
     3.185    13.620     0.200
     3.458    14.027     0.200
     3.544    12.003     0.200
     3.544    12.193     0.200
     3.493    13.229     0.200
     3.870    15.005     0.200
     3.980    14.977     0.200
     4.210    15.854     0.200
     4.228    14.507     0.200
     4.378    14.727     0.200
     4.460    15.810     0.200
     4.777    17.274     0.200
     4.918    14.565     0.200
     6.863    20.042     0.200
     6.868    22.156     0.200
     7.288    21.489     0.200
     7.812    23.495     0.200
     7.812    23.298     0.200
     8.217    24.413     0.200
     8.217    23.677     0.200
     9.473    25.798     0.200
    10.304    31.449     0.200
    11.715    31.050     0.200
    14.344    37.199     0.200
     0.754     5.157     0.200
     0.778     5.451     0.200
     0.778     5.339     0.200
     0.807     6.077     0.200
     0.814     5.319     0.200
     0.841     5.297     0.200
     0.847     5.395     0.200
     0.877     5.721     0.200
     0.876     5.841     0.200
     0.904     6.240     0.200
     0.928     6.041     0.200
     0.943     6.033     0.200
     0.977     6.078     0.200
     0.977     6.887     0.200
     1.013     7.020     0.200
     1.013     6.885     0.200
     1.036     7.006     0.200
     1.083     6.832     0.200
     1.080     6.870     0.200
     1.229     6.713     0.200
     1.412     7.177     0.200
     1.414     7.767     0.200
     1.436     7.745     0.200
     1.489     7.640     0.200
     1.525     7.079     0.200
     1.591     8.359     0.200
     1.697     7.920     0.200
     1.754     9.031     0.200
     1.770     8.174     0.200
     1.958     8.511     0.200
     1.953     8.898     0.200
     1.953     9.058     0.200
     2.014     8.514     0.200
     2.040     8.977     0.200
     2.047     9.205     0.200
     2.065     9.174     0.200
     2.215     8.355     0.200
     2.262    10.585     0.200
     2.378    10.046     0.200
     2.504     9.973     0.200
     2.612    10.301     0.200
     2.620    10.847     0.200
     2.628    10.374     0.200
     2.825     7.636     0.200
     2.704     9.910     0.200
     2.704    10.038     0.200
     2.720    10.663     0.200
     2.806    10.439     0.200
     2.837    10.994     0.200
     2.892    11.265     0.200
     2.990    11.349     0.200
     3.014     9.952     0.200
     3.010    12.016     0.200
     3.105    11.574     0.200
     3.246    12.425     0.200
     3.270    10.975     0.200
     3.270    10.830     0.200
     3.276    12.048     0.200
     3.355    12.812     0.200
     3.377    12.139     0.200
     3.406    13.302     0.200
     3.980    14.590     0.200
     4.168    14.197     0.200
     4.199    14.661     0.200
     4.269    15.947     0.200
     4.395    14.840     0.200
     4.391    14.771     0.200
     4.475    15.571     0.200
     4.589    16.134     0.200
     4.604    16.031     0.200
     4.655    15.626     0.200
     4.735    15.619     0.200
     4.764    14.879     0.200
     4.764    14.276     0.200
     4.793    16.252     0.200
     4.802    14.759     0.200
     4.947    16.300     0.200
     4.983    16.573     0.200
     4.983    14.973     0.200
     5.171    15.882     0.200
     5.193    17.162     0.200
     5.286    17.465     0.200
     5.286    16.820     0.200
     5.397    17.144     0.200
     5.399    17.174     0.200
     5.502    18.717     0.200
     5.529    18.281     0.200
     5.702    16.519     0.200
     5.762    17.962     0.200
     5.819    18.439     0.200
     6.072    19.347     0.200
     6.407    19.344     0.200
     6.711    19.954     0.200
     7.207    20.518     0.200
     7.207    20.273     0.200
     7.390    21.595     0.200
     7.390    22.451     0.200
     7.429    21.996     0.200
     7.429    21.657     0.200
     7.710    22.219     0.200
     7.718    21.754     0.200
     7.734    22.776     0.200
     7.865    23.307     0.200
     7.994    22.373     0.200
     8.303    23.041     0.200
     9.369    23.704     0.200
     9.485    26.298     0.200
    10.759    30.863     0.200
    11.528    28.209     0.200
    15.107    37.510     0.200
    15.368    37.418     0.200
    15.929    39.070     0.200
    19.631    39.750     0.200
     0.871     6.730     0.200
     0.941     6.496     0.200
     0.941     6.359     0.200
     1.362     9.192     0.200
     1.340     9.092     0.200
     1.668    10.321     0.200
     1.735     8.601     0.200
     1.797     8.854     0.200
     2.112    10.135     0.200
     2.391     9.928     0.200
     2.201    10.957     0.200
     2.352    11.915     0.200
     2.649    12.204     0.200
     2.713    13.894     0.200
     2.806    12.537     0.200
     2.854    11.141     0.200
     2.854    10.206     0.200
     3.001    11.686     0.200
     3.178    12.252     0.200
     3.257    12.636     0.200
     3.449    13.162     0.200
     3.496    13.518     0.200
     3.768    14.695     0.200
     3.977    14.900     0.200
     4.101    15.297     0.200
     4.402    15.787     0.200
     4.395    15.424     0.200
     4.501    16.086     0.200
     4.516    15.575     0.200
     5.696    21.400     0.200
     7.691    25.232     0.200
    10.915    32.458     0.200
     0.772     5.717     0.200
     0.774     5.918     0.200
     0.835     5.813     0.200
     0.959     6.664     0.200
     1.007     6.846     0.200
     1.019     7.108     0.200
     1.033     7.218     0.200
     1.151     7.744     0.200
     1.222     7.506     0.200
     1.222     7.607     0.200
     1.275     7.615     0.200
     1.284     7.284     0.200
     1.373     8.432     0.200
     1.430     8.757     0.200
     1.430     8.288     0.200
     1.509     7.647     0.200
     1.525     7.606     0.200
     1.525     7.340     0.200
     1.543     7.731     0.200
     1.632     8.915     0.200
     1.643     8.132     0.200
     1.653     8.500     0.200
     1.678     8.943     0.200
     1.820     8.796     0.200
     1.850     8.829     0.200
     2.070    10.496     0.200
     2.083     9.948     0.200
     2.168    10.228     0.200
     2.274    10.473     0.200
     2.333    10.849     0.200
     2.391    10.745     0.200
     2.432     9.003     0.200
     2.506    10.744     0.200
     2.746    12.193     0.200
     2.746    12.183     0.200
     2.872    12.175     0.200
     2.892    11.975     0.200
     3.041    12.126     0.200
     3.180    13.440     0.200
     3.547    11.977     0.200
     3.626    14.287     0.200
     3.690    14.348     0.200
     4.141    15.149     0.200
     4.376    15.816     0.200
     4.376    15.957     0.200
     4.455    16.294     0.200
     4.772    16.616     0.200
     4.772    17.022     0.200
     4.796    15.206     0.200
     4.919    14.457     0.200
     5.568    18.982     0.200
     6.863    22.047     0.200
     7.289    21.495     0.200
     8.216    23.418     0.200
     9.473    25.798     0.200
    10.299    28.019     0.200
    11.319    29.352     0.200
    11.716    31.030     0.200
     1.200     7.086     0.200
     1.250     7.019     0.200
     1.337     8.389     0.200
     1.379     7.628     0.200
     1.523     8.842     0.200
     1.578     7.830     0.200
     1.651     7.831     0.200
     1.790     8.132     0.200
     2.664     9.160     0.200
     3.294    11.491     0.200
     3.392    13.704     0.200
     3.612    13.953     0.200
     4.178    14.151     0.200
     4.178    13.128     0.200
     4.262    16.081     0.200
     4.366    15.301     0.200
     4.517    16.375     0.200
     4.790    16.824     0.200
     4.942    17.081     0.200
     5.713    20.392     0.200
     6.643    19.006     0.200
     7.608    23.547     0.200
     7.839    24.946     0.200
    10.928    28.619     0.200
     1.024     7.306     0.200
     1.073     8.904     0.200
     1.406    10.026     0.200
     1.415     9.457     0.200
     1.435     8.565     0.200
     1.473     9.519     0.200
     1.520     9.646     0.200
     1.561     9.015     0.200
     1.606    10.052     0.200
     1.630     9.459     0.200
     1.660     8.650     0.200
     1.704    11.108     0.200
     1.731     8.781     0.200
     1.825    10.873     0.200
     1.882    10.981     0.200
     1.941    11.163     0.200
     1.942    11.338     0.200
     2.097    11.028     0.200
     2.122    11.804     0.200
     2.245    10.454     0.200
     2.265    11.030     0.200
     2.337    12.326     0.200
     2.386    11.018     0.200
     2.394    11.073     0.200
     2.464    12.277     0.200
     2.571    12.513     0.200
     2.571    12.829     0.200
     2.583    12.318     0.200
     2.636    12.878     0.200
     2.711    12.889     0.200
     2.779    12.366     0.200
     2.847    13.434     0.200
     3.128    10.669     0.200
     2.988    13.594     0.200
     3.005    13.844     0.200
     3.133    14.517     0.200
     3.197    13.988     0.200
     3.317    14.430     0.200
     3.323    14.057     0.200
     3.501    15.235     0.200
     3.531    15.090     0.200
     3.543    15.633     0.200
     3.711    13.114     0.200
     3.752    16.318     0.200
     3.835    16.101     0.200
     3.999    16.608     0.200
     4.186    16.831     0.200
     4.243    17.326     0.200
     4.256    17.578     0.200
     4.260    16.157     0.200
     4.459    18.670     0.200
     4.494    18.586     0.200
     4.537    19.003     0.200
     4.579    16.340     0.200
     4.592    16.953     0.200
     4.604    18.016     0.200
     4.639    17.581     0.200
     4.753    17.431     0.200
     4.823    17.832     0.200
     4.947    18.265     0.200
     4.956    18.140     0.200
     4.958    19.509     0.200
     4.970    18.511     0.200
     5.009    16.924     0.200
     5.064    19.211     0.200
     5.089    19.581     0.200
     5.122    18.574     0.200
     5.217    16.388     0.200
     5.217    16.509     0.200
     5.324    19.847     0.200
     5.392    19.346     0.200
     5.447    20.881     0.200
     5.597    19.835     0.200
     5.661    20.761     0.200
     5.787    20.862     0.200
     5.812    19.296     0.200
     5.836    21.390     0.200
     5.873    19.271     0.200
     5.920    20.809     0.200
     6.034    22.781     0.200
     6.098    21.877     0.200
     6.098    21.506     0.200
     6.094    23.057     0.200
     6.236    21.573     0.200
     6.262    21.660     0.200
     6.286    21.533     0.200
     6.358    22.856     0.200
     6.407    20.891     0.200
     6.551    23.285     0.200
     6.662    22.037     0.200
     6.717    21.022     0.200
     6.773    21.892     0.200
     6.953    22.309     0.200
     7.138    21.746     0.200
     7.183    21.892     0.200
     7.370    24.769     0.200
     7.369    24.071     0.200
     7.369    24.615     0.200
     7.442    24.275     0.200
     7.442    22.937     0.200
     7.467    22.608     0.200
     7.512    24.352     0.200
     7.587    25.477     0.200
     7.657    22.926     0.200
     7.657    22.818     0.200
     7.740    24.507     0.200
     7.762    24.806     0.200
     7.762    25.465     0.200
     8.033    25.031     0.200
     8.111    26.001     0.200
     8.219    22.870     0.200
     8.270    25.885     0.200
     8.314    23.972     0.200
     8.562    26.587     0.200
     8.718    26.331     0.200
     8.718    26.595     0.200
     8.701    26.708     0.200
     8.894    26.854     0.200
     9.056    27.503     0.200
     9.131    28.691     0.200
     9.191    28.561     0.200
     9.191    27.488     0.200
     9.211    28.551     0.200
     9.311    28.561     0.200
     9.470    30.168     0.200
     9.470    31.477     0.200
     9.570    27.855     0.200
     9.570    28.487     0.200
     9.570    27.970     0.200
     9.777    29.079     0.200
     9.821    27.393     0.200
     9.803    30.656     0.200
     9.958    29.836     0.200
    10.036    29.462     0.200
    10.160    27.203     0.200
    10.160    28.514     0.200
    10.250    29.659     0.200
    10.250    31.252     0.200
    10.316    31.406     0.200
    10.395    30.594     0.200
    10.386    31.143     0.200
    10.787    31.784     0.200
    10.787    30.121     0.200
    10.899    32.933     0.200
    10.899    31.846     0.200
    10.899    31.566     0.200
    10.899    33.496     0.200
    10.909    31.825     0.200
    10.999    32.098     0.200
    11.197    31.430     0.200
    11.407    32.388     0.200
    11.407    31.570     0.200
    11.626    31.141     0.200
    11.620    34.977     0.200
    11.719    34.199     0.200
    11.719    31.722     0.200
    11.756    34.707     0.200
    11.978    33.111     0.200
    12.095    32.892     0.200
    12.211    33.544     0.200
    12.235    33.658     0.200
    12.382    34.153     0.200
    12.403    35.108     0.200
    12.627    34.634     0.200
    13.003    36.102     0.200
    13.016    37.631     0.200
    13.069    37.081     0.200
    13.205    36.418     0.200
    13.321    35.058     0.200
    13.345    37.448     0.200
    13.522    38.573     0.200
    13.522    36.840     0.200
    13.917    36.157     0.200
    14.075    36.141     0.200
    14.415    37.983     0.200
    14.445    38.092     0.200
    14.561    36.570     0.200
    14.561    37.489     0.200
    14.759    38.065     0.200
    14.759    37.767     0.200
    14.779    37.300     0.200
    14.779    39.179     0.200
    14.789    38.239     0.200
    14.990    35.410     0.200
    15.011    38.049     0.200
    15.226    37.525     0.200
    15.476    38.854     0.200
    15.476    40.067     0.200
    15.483    39.168     0.200
    15.528    37.629     0.200
    15.985    37.645     0.200
    16.141    40.452     0.200
    16.334    38.688     0.200
    16.374    40.880     0.200
    16.374    40.683     0.200
    16.524    41.064     0.200
    16.526    38.296     0.200
    16.656    40.573     0.200
    16.760    37.468     0.200
    16.798    40.363     0.200
    17.233    39.183     0.200
    17.472    39.248     0.200
    17.954    40.861     0.200
    18.205    40.093     0.200
    18.787    42.029     0.200
    20.453    41.184     0.200
    20.788    41.188     0.200
     1.052     6.599     0.200
     1.082     6.514     0.200
     1.887     7.913     0.200
     2.656    11.024     0.200
     2.709    11.153     0.200
     3.341    11.935     0.200
     3.541    13.223     0.200
     4.446    13.523     0.200
     4.560    16.358     0.200
     4.562    16.410     0.200
     5.249    17.388     0.200
     5.714    20.312     0.200
     6.113    19.016     0.200
     6.927    20.026     0.200
     7.731    25.452     0.200
     8.146    24.100     0.200
    10.970    32.129     0.200
    11.174    30.950     0.200
     0.757     5.350     0.200
     0.757     5.283     0.200
     0.814     5.302     0.200
     0.902     5.821     0.200
     0.922     5.860     0.200
     0.961     5.984     0.200
     0.961     6.207     0.200
     0.972     6.075     0.200
     0.972     6.569     0.200
     0.991     6.038     0.200
     0.993     6.153     0.200
     1.077     6.471     0.200
     1.083     6.214     0.200
     1.095     6.592     0.200
     1.113     6.344     0.200
     1.123     6.435     0.200
     1.127     6.429     0.200
     1.126     6.940     0.200
     1.197     6.573     0.200
     1.207     6.865     0.200
     1.212     6.799     0.200
     1.216     6.572     0.200
     1.221     7.196     0.200
     1.295     6.898     0.200
     1.332     7.066     0.200
     1.348     7.644     0.200
     1.348     8.036     0.200
     1.412     7.016     0.200
     1.409     8.299     0.200
     1.454     7.129     0.200
     1.456     7.242     0.200
     1.458     7.034     0.200
     1.481     7.096     0.200
     1.519     7.993     0.200
     1.519     7.824     0.200
     1.739     8.277     0.200
     1.762     7.574     0.200
     1.848     8.636     0.200
     2.115     8.251     0.200
     2.347     9.835     0.200
     2.582    10.423     0.200
     2.623    10.044     0.200
     2.875    11.010     0.200
     3.057    12.161     0.200
     3.413    11.591     0.200
     3.611    12.627     0.200
     3.684    13.059     0.200
     3.823    14.068     0.200
     4.041    12.505     0.200
     4.041    12.304     0.200
     4.085    13.896     0.200
     4.317    14.467     0.200
     4.414    15.622     0.200
     4.515    14.711     0.200
     4.891    15.996     0.200
     5.242    16.811     0.200
     5.439    16.864     0.200
     5.432    16.387     0.200
     5.507    16.565     0.200
     5.965    20.675     0.200
     6.164    17.846     0.200
     6.227    19.606     0.200
     7.005    20.879     0.200
     7.188    20.097     0.200
     7.601    21.644     0.200
     7.807    20.834     0.200
     7.807    24.378     0.200
     7.835    25.055     0.200
    10.762    28.701     0.200
    10.763    28.357     0.200
    10.918    32.025     0.200
     1.030     6.432     0.200
     1.031     6.933     0.200
     1.030     7.152     0.200
     1.061     7.153     0.200
     1.158     7.866     0.200
     1.163     8.174     0.200
     1.197     7.511     0.200
     1.241     7.350     0.200
     1.274     8.497     0.200
     1.357     7.886     0.200
     1.446     7.923     0.200
     1.496     8.105     0.200
     1.543     8.121     0.200
     1.682     8.983     0.200
     1.702     9.229     0.200
     1.753     8.871     0.200
     1.781     8.685     0.200
     1.985     9.297     0.200
     1.990     9.143     0.200
     2.001     9.186     0.200
     2.953    11.758     0.200
     2.953    12.132     0.200
     4.787    16.177     0.200
     5.349    17.460     0.200
     5.832    18.668     0.200
     6.297    19.484     0.200
     6.770    20.953     0.200
     7.324    21.820     0.200
     7.979    23.159     0.200
     9.346    30.063     0.200
    10.130    29.947     0.200
    11.525    30.013     0.200
    14.280    36.501     0.200
    14.619    35.313     0.200
    15.869    37.344     0.200
    17.142    38.690     0.200
    18.582    40.568     0.200
     1.353     9.260     0.200
     1.659    10.391     0.200
     1.967    10.793     0.200
     2.064    11.287     0.200
     2.349    11.154     0.200
     2.403    11.561     0.200
     2.516    12.378     0.200
     3.178    13.419     0.200
     3.594    14.677     0.200
     3.777    14.113     0.200
     4.353    15.774     0.200
     4.386    16.261     0.200
     5.446    18.135     0.200
     6.791    20.850     0.200
     7.381    22.345     0.200
     7.906    25.054     0.200
    10.595    33.980     0.200
    11.125    32.402     0.200
     1.360     8.004     0.200
     1.365     7.570     0.200
     1.971     9.561     0.200
     2.067    10.755     0.200
     2.122    12.261     0.200
     2.145    12.820     0.200
     2.343    11.033     0.200
     2.398    11.539     0.200
     2.517    11.410     0.200
     4.370    15.213     0.200
     5.002    16.372     0.200
     5.445    16.875     0.200
     5.743    19.326     0.200
     7.377    23.596     0.200
    10.590    33.020     0.200
    11.121    28.638     0.200
     0.808     5.868     0.200
     0.830     5.894     0.200
     0.903     6.228     0.200
     1.079     7.288     0.200
     1.154     7.395     0.200
     1.267     8.453     0.200
     1.272     8.288     0.200
     1.519     8.696     0.200
     1.604     8.979     0.200
     1.727     8.280     0.200
     1.759     8.641     0.200
     1.722     9.850     0.200
     1.740    10.657     0.200
     1.880    10.335     0.200
     1.934     9.362     0.200
     1.994    11.023     0.200
     2.025    10.790     0.200
     2.187    10.635     0.200
     2.178    10.151     0.200
     2.322    10.590     0.200
     2.363    11.356     0.200
     2.384    11.687     0.200
     2.483    11.837     0.200
     2.608    12.195     0.200
     2.695    10.822     0.200
     2.697    11.895     0.200
     2.873    12.204     0.200
     2.885    12.781     0.200
     2.924    13.468     0.200
     3.214     9.975     0.200
     3.036    13.724     0.200
     3.210    12.433     0.200
     3.214    13.566     0.200
     3.229    13.263     0.200
     3.399    14.388     0.200
     3.485    12.263     0.200
     3.441    14.616     0.200
     3.654    14.096     0.200
     3.753    12.940     0.200
     3.861    14.498     0.200
     3.898    15.767     0.200
     4.192    14.726     0.200
     4.367    15.430     0.200
     4.513    16.602     0.200
     4.557    16.267     0.200
     4.569    16.221     0.200
     4.689    17.085     0.200
     4.871    17.592     0.200
     4.859    18.457     0.200
     4.904    17.472     0.200
     4.940    16.342     0.200
     4.988    19.244     0.200
     4.988    17.544     0.200
     5.040    16.896     0.200
     5.338    19.175     0.200
     5.433    17.590     0.200
     7.268    24.039     0.200
    10.811    33.299     0.200
    12.009    33.341     0.200
     1.078     7.279     0.200
     1.180     7.741     0.200
     1.473     7.016     0.200
     1.476     7.090     0.200
     1.482     8.419     0.200
     1.480     8.014     0.200
     1.554     8.641     0.200
     1.551     8.146     0.200
     1.678     7.744     0.200
     1.825     9.356     0.200
     1.987     9.990     0.200
     2.142     9.910     0.200
     2.153    10.483     0.200
     2.150    10.200     0.200
     2.412     9.401     0.200
     2.488    10.654     0.200
     2.488    10.890     0.200
     2.618    11.124     0.200
     2.694    11.333     0.200
     2.702    10.834     0.200
     2.707    11.352     0.200
     2.998     8.828     0.200
     2.956    10.920     0.200
     3.216    10.543     0.200
     3.207    12.903     0.200
     3.472    11.645     0.200
     4.958    17.311     0.200
     5.140    18.111     0.200
     7.313    22.426     0.200
     7.525    24.575     0.200
     8.453    23.818     0.200
     8.453    25.024     0.200
     8.453    25.214     0.200
     9.002    29.381     0.200
    10.191    32.159     0.200
    10.755    30.613     0.200
    11.423    35.617     0.200
    11.726    32.139     0.200
    14.379    37.461     0.200
    14.743    38.013     0.200
    14.768    37.098     0.200
    14.768    41.228     0.200
     0.802     5.754     0.200
     0.817     5.606     0.200
     0.867     5.962     0.200
     0.896     6.198     0.200
     0.916     6.310     0.200
     1.375     8.209     0.200
     1.569     7.870     0.200
     1.579     8.807     0.200
     1.798     8.298     0.200
     2.270    10.742     0.200
     2.290    12.219     0.200
     2.343    12.087     0.200
     2.454     8.586     0.200
     2.681     9.354     0.200
     2.950    11.639     0.200
     3.081    11.538     0.200
     3.109    11.740     0.200
     3.406    11.731     0.200
     3.698    12.517     0.200
     3.784    15.094     0.200
     4.178    14.921     0.200
     4.286    16.136     0.200
     5.661    19.004     0.200
     6.636    19.470     0.200
     7.547    24.390     0.200
     7.812    25.018     0.200
    10.691    34.453     0.200
    10.936    29.451     0.200
     1.014     6.430     0.200
     1.006     6.093     0.200
     1.027     6.221     0.200
     1.023     6.411     0.200
     1.039     6.147     0.200
     1.040     6.179     0.200
     1.071     6.998     0.200
     1.072     6.176     0.200
     1.142     6.684     0.200
     1.276     7.378     0.200
     1.343     6.784     0.200
     1.443     7.075     0.200
     1.640     8.952     0.200
     1.693     8.396     0.200
     1.829     8.891     0.200
     1.909     7.609     0.200
     2.364     9.280     0.200
     2.484     9.529     0.200
     2.611     8.584     0.200
     2.608    10.191     0.200
     2.676    10.862     0.200
     2.722    10.674     0.200
     2.733    10.773     0.200
     2.756    11.815     0.200
     2.811     9.322     0.200
     2.862    11.871     0.200
     2.910     9.619     0.200
     3.017    11.438     0.200
     3.199    11.241     0.200
     3.261    11.810     0.200
     3.326    11.672     0.200
     3.543    12.931     0.200
     3.785    13.684     0.200
     3.793    13.912     0.200
     3.808    13.519     0.200
     3.920    13.788     0.200
     4.058    14.139     0.200
     4.386    14.863     0.200
     4.469    13.543     0.200
     4.575    15.774     0.200
     4.577    15.686     0.200
     4.621    15.079     0.200
     4.767    16.140     0.200
     5.010    16.569     0.200
     5.614    17.996     0.200
     5.705    18.158     0.200
     5.705    18.439     0.200
     5.771    18.343     0.200
     6.138    18.720     0.200
     7.616    21.642     0.200
     7.731    21.847     0.200
     7.731    21.237     0.200
     7.809    21.852     0.200
     8.044    23.748     0.200
     8.167    23.850     0.200
     8.167    22.936     0.200
     9.092    24.404     0.200
    10.205    32.784     0.200
    10.190    30.142     0.200
    10.978    31.501     0.200
    10.978    32.189     0.200
    11.196    28.330     0.200
    11.197    29.993     0.200
    13.656    33.303     0.200
    13.778    33.987     0.200
    14.684    34.767     0.200
    14.764    35.800     0.200
    15.247    38.227     0.200
    15.247    36.227     0.200
    15.414    34.510     0.200
    15.562    37.085     0.200
    15.660    36.232     0.200
    15.696    36.816     0.200
    16.046    36.584     0.200
    16.449    37.677     0.200
    16.578    36.720     0.200
    16.924    37.347     0.200
    17.617    37.609     0.200
     0.983     6.403     0.200
     0.987     6.755     0.200
     1.011     7.021     0.200
     1.064     6.555     0.200
     1.107     7.272     0.200
     1.159     7.299     0.200
     1.239     7.366     0.200
     1.269     7.423     0.200
     1.355     8.313     0.200
     1.484     7.774     0.200
     1.604     9.148     0.200
     1.708     9.420     0.200
     1.891     9.576     0.200
     2.177    10.115     0.200
     2.227     9.748     0.200
     2.359    11.702     0.200
     2.378    10.680     0.200
     2.638    10.822     0.200
     2.747    10.690     0.200
     3.022    11.685     0.200
     3.308    12.362     0.200
     3.705    13.584     0.200
     3.738    14.101     0.200
     4.230    15.085     0.200
     4.258    14.398     0.200
     4.690    16.039     0.200
    10.655    31.916     0.200
     0.967     7.095     0.200
     2.181    11.612     0.200
     2.869    14.080     0.200
     7.862    22.997     0.200
    10.663    30.206     0.200
    11.019    30.883     0.200
    15.034    39.945     0.200
    18.756    43.825     0.200
     1.362     7.656     0.200
     1.403    10.751     0.200
     1.606     8.891     0.200
     2.266    13.168     0.200
     2.538     8.795     0.200
     2.884    14.077     0.200
    10.655    31.958     0.200
    11.007    30.271     0.200
     0.795     5.843     0.200
     0.827     6.266     0.200
     0.899     6.097     0.200
     0.981     6.623     0.200
     0.993     6.737     0.200
     1.092     6.752     0.200
     1.257     7.478     0.200
     1.370     8.188     0.200
     1.382     9.452     0.200
     1.487     7.937     0.200
     2.077    11.481     0.200
     2.176     9.493     0.200
     2.215     9.410     0.200
     2.347     9.796     0.200
     2.360     9.671     0.200
     2.557     8.835     0.200
     2.628    10.314     0.200
     2.634    10.302     0.200
     2.657    10.752     0.200
     2.738    10.897     0.200
     5.556    19.883     0.200
    10.636    32.039     0.200
     1.388     9.145     0.200
     1.394     9.619     0.200
     1.490     9.857     0.200
     1.534     9.422     0.200
     1.687     9.978     0.200
     1.757    10.258     0.200
     1.787     9.844     0.200
     1.765    10.140     0.200
     1.851    10.288     0.200
     1.949    10.331     0.200
     2.027    11.392     0.200
     2.046    10.582     0.200
     2.102    10.373     0.200
     2.241    10.895     0.200
     2.282    11.231     0.200
     2.379    10.913     0.200
     2.394    11.227     0.200
     2.409    11.519     0.200
     2.539    12.211     0.200
     2.605    12.321     0.200
     2.831    12.049     0.200
     2.836    12.558     0.200
     2.842    12.944     0.200
     2.897    12.618     0.200
     2.995    12.555     0.200
     3.138    13.601     0.200
     3.414    14.617     0.200
     3.435    14.586     0.200
     3.623    15.183     0.200
     3.726    15.427     0.200
     3.934    14.912     0.200
     4.001    14.765     0.200
     4.146    15.351     0.200
     4.169    16.180     0.200
     4.182    15.466     0.200
     4.251    16.599     0.200
     4.267    17.255     0.200
     4.365    16.792     0.200
     4.432    15.953     0.200
     4.468    14.655     0.200
     4.607    17.214     0.200
     4.615    17.495     0.200
     4.690    17.296     0.200
     4.725    17.331     0.200
     4.725    17.135     0.200
     4.825    18.073     0.200
     4.914    18.063     0.200
     4.971    18.214     0.200
     4.995    16.097     0.200
     5.019    17.837     0.200
     5.162    18.296     0.200
     5.196    18.974     0.200
     5.270    18.795     0.200
     5.382    18.949     0.200
     5.440    18.702     0.200
     5.518    19.594     0.200
     5.631    19.462     0.200
     5.736    20.167     0.200
     6.081    20.431     0.200
     6.220    20.637     0.200
     6.699    21.468     0.200
     6.847    21.321     0.200
     7.220    22.072     0.200
     7.363    22.013     0.200
     7.432    22.402     0.200
     7.444    20.172     0.200
     7.480    20.636     0.200
    10.312    32.741     0.200
    11.792    33.291     0.200
     0.887     6.628     0.200
     0.970     6.948     0.200
     0.970     6.807     0.200
     1.003     6.807     0.200
     1.079     7.076     0.200
     1.155     7.307     0.200
     1.333     8.615     0.200
     2.495    11.525     0.200
     3.251    12.650     0.200
     3.729    14.331     0.200
     4.131    13.697     0.200
     4.196    14.980     0.200
     4.373    14.923     0.200
     4.454    16.161     0.200
     4.852    16.185     0.200
     4.935    17.147     0.200
     4.997    17.556     0.200
     5.290    17.546     0.200
     5.508    16.843     0.200
     5.801    17.311     0.200
     6.288    19.506     0.200
     6.606    19.710     0.200
     7.829    26.014     0.200
     8.751    24.350     0.200
    10.810    33.154     0.200
    10.872    28.999     0.200
     1.335     9.016     0.200
     1.577     9.217     0.200
     2.075    11.590     0.200
     2.346    10.913     0.200
     2.350    11.320     0.200
     2.886    12.454     0.200
     3.079    14.434     0.200
     3.817    15.855     0.200
    10.801    36.173     0.200
     0.900     7.234     0.200
     1.339     8.028     0.200
     1.485     8.700     0.200
     1.638     8.605     0.200
     2.082    10.675     0.200
     3.028    10.641     0.200
     3.085    11.996     0.200
     3.245    12.353     0.200
     3.376    12.548     0.200
     3.945    13.298     0.200
     4.130    13.174     0.200
     4.190    15.521     0.200
     4.275    15.699     0.200
     4.365    15.092     0.200
     4.844    15.623     0.200
     4.930    17.112     0.200
     4.994    17.155     0.200
     4.974    17.568     0.200
     5.140    18.774     0.200
     5.284    18.385     0.200
     5.378    17.376     0.200
     5.506    16.510     0.200
     5.613    16.907     0.200
     5.648    17.800     0.200
     5.688    17.913     0.200
     6.267    20.798     0.200
     6.315    19.966     0.200
     6.316    19.914     0.200
     6.537    19.952     0.200
     6.603    20.105     0.200
     7.681    23.283     0.200
     7.681    23.798     0.200
     7.824    23.627     0.200
     7.825    25.171     0.200
     7.825    23.632     0.200
     8.749    24.536     0.200
     8.922    23.423     0.200
     9.303    26.235     0.200
     9.517    26.971     0.200
    10.083    27.559     0.200
    10.256    27.494     0.200
    10.534    28.979     0.200
    10.802    31.428     0.200
    10.802    29.584     0.200
    10.871    28.356     0.200
    10.872    29.112     0.200
    10.872    28.878     0.200
    11.044    29.802     0.200
    11.911    31.469     0.200
    15.348    37.377     0.200
    17.223    38.884     0.200
     1.111     6.616     0.200
     1.124     6.714     0.200
     1.142     7.872     0.200
     1.157     7.181     0.200
     1.167     7.464     0.200
     1.335     7.572     0.200
     1.481     8.474     0.200
     1.572     7.924     0.200
     2.348     8.964     0.200
     2.864    10.667     0.200
     3.087    10.302     0.200
     3.946    13.004     0.200
     4.000    14.458     0.200
     4.132    12.890     0.200
     4.191    14.336     0.200
     4.400    15.202     0.200
     4.450    14.877     0.200
     4.583    16.598     0.200
     4.934    15.897     0.200
     4.978    16.640     0.200
     5.144    15.946     0.200
     6.284    19.321     0.200
     6.606    19.324     0.200
     7.272    21.031     0.200
     7.784    21.858     0.200
    10.873    27.374     0.200
    10.873    27.591     0.200
     1.119     6.585     0.200
     1.157     6.730     0.200
     1.165     6.735     0.200
     1.332     8.100     0.200
     1.482     8.227     0.200
     1.578     6.886     0.200
     1.588     8.350     0.200
     1.630     7.680     0.200
     1.667     8.526     0.200
     1.745     8.915     0.200
     2.076     9.796     0.200
     2.350    10.473     0.200
     2.354     7.980     0.200
     2.349    11.040     0.200
     2.419    10.869     0.200
     2.423    10.654     0.200
     2.449    10.279     0.200
     2.490    10.676     0.200
     2.834    11.071     0.200
     2.858    11.200     0.200
     2.889    10.946     0.200
     2.964    11.782     0.200
     3.021    12.103     0.200
     3.081    11.546     0.200
     3.205    11.427     0.200
     3.242    12.049     0.200
     3.371    12.262     0.200
     3.730    12.995     0.200
     3.820    14.772     0.200
     3.918    14.589     0.200
     4.137    12.646     0.200
     4.137    13.236     0.200
     4.281    15.291     0.200
     4.398    15.494     0.200
     4.846    16.676     0.200
     5.314    16.957     0.200
     5.674    16.526     0.200
     5.791    19.502     0.200
     5.791    18.057     0.200
     6.418    20.060     0.200
     7.149    24.679     0.200
     7.276    21.122     0.200
     7.468    21.622     0.200
     7.470    24.948     0.200
     7.679    23.588     0.200
     7.679    22.298     0.200
     7.804    21.350     0.200
     7.831    24.933     0.200
     7.831    22.994     0.200
     8.757    24.044     0.200
     9.121    29.636     0.200
    10.063    31.791     0.200
    10.334    30.091     0.200
    10.558    28.306     0.200
    10.804    32.221     0.200
    10.879    28.997     0.200
    10.879    28.797     0.200
    13.694    34.864     0.200
    14.082    37.869     0.200
    14.080    36.477     0.200
    14.107    36.499     0.200
    14.265    35.854     0.200
    14.343    36.474     0.200
    14.709    37.038     0.200
    14.860    36.881     0.200
    15.151    37.129     0.200
    15.235    39.737     0.200
    15.235    37.698     0.200
    15.387    37.528     0.200
    15.411    37.910     0.200
    15.592    38.222     0.200
    17.148    38.367     0.200
    17.667    37.816     0.200
    18.271    40.096     0.200
     0.825     6.003     0.200
     0.969     6.123     0.200
     0.971     6.625     0.200
     0.986     6.159     0.200
     0.986     6.262     0.200
     1.094     6.501     0.200
     1.116     6.705     0.200
     1.159     6.920     0.200
     1.140     7.873     0.200
     1.197     7.306     0.200
     1.333     7.779     0.200
     1.486     8.373     0.200
     1.580     9.540     0.200
     1.624     7.929     0.200
     1.675     9.201     0.200
     2.068    10.572     0.200
     2.343    11.673     0.200
     2.348    11.334     0.200
     2.439    11.083     0.200
     2.485    11.679     0.200
     2.826    10.542     0.200
     2.954    11.582     0.200
     3.072    12.269     0.200
     3.195    12.109     0.200
     3.232    12.851     0.200
     3.362    12.146     0.200
     3.508    13.365     0.200
     3.730    14.109     0.200
     3.909    14.319     0.200
     3.931    13.439     0.200
     3.985    14.643     0.200
     4.142    13.602     0.200
     4.176    15.422     0.200
     4.278    16.441     0.200
     4.329    15.613     0.200
     4.356    14.955     0.200
     4.391    15.642     0.200
     4.435    15.017     0.200
     4.559    16.022     0.200
     4.839    16.259     0.200
     4.937    17.010     0.200
     4.979    16.091     0.200
     5.518    17.279     0.200
     5.682    16.998     0.200
     5.781    22.144     0.200
     5.781    19.411     0.200
     6.279    20.607     0.200
     6.522    19.182     0.200
     6.615    19.558     0.200
     7.102    22.350     0.200
     7.278    21.730     0.200
     7.292    20.657     0.200
     7.671    25.161     0.200
     7.671    21.661     0.200
     7.832    25.420     0.200
     7.832    22.306     0.200
     9.315    25.690     0.200
     9.482    25.320     0.200
     9.926    26.180     0.200
    10.268    26.659     0.200
    10.546    27.664     0.200
    10.798    31.839     0.200
    10.885    30.376     0.200
     1.156     7.095     0.200
     1.143     7.659     0.200
     1.171     7.177     0.200
     1.335     8.028     0.200
     1.478     8.263     0.200
     1.569     7.205     0.200
     1.640     7.622     0.200
     1.658     8.257     0.200
     2.087     9.185     0.200
     2.432    13.175     0.200
     2.494    11.422     0.200
     2.846    10.686     0.200
     2.975    13.444     0.200
     3.093    11.415     0.200
     3.252    14.051     0.200
     3.383    11.447     0.200
     3.528    12.861     0.200
     3.727    14.949     0.200
     4.129    13.724     0.200
     4.281    14.972     0.200
     4.337    16.469     0.200
     4.403    15.910     0.200
     5.506    16.962     0.200
     5.802    21.221     0.200
     5.802    17.985     0.200
     6.603    19.447     0.200
     7.689    25.505     0.200
     7.689    22.221     0.200
     7.696    24.732     0.200
     7.827    25.731     0.200
     7.827    23.802     0.200
     8.749    24.397     0.200
    10.810    33.054     0.200
    10.870    28.107     0.200
    10.870    27.908     0.200
    15.228    35.059     0.200
    15.245    36.143     0.200
    16.243    37.600     0.200
     0.977     7.169     0.200
     1.317     8.934     0.200
     1.338     7.814     0.200
     1.393     7.680     0.200
     1.428    10.125     0.200
     1.491     8.337     0.200
     1.507     8.117     0.200
     1.678     8.263     0.200
     1.713     8.848     0.200
     2.071     9.436     0.200
     2.360     8.241     0.200
     2.412    12.945     0.200
     2.956    11.018     0.200
     3.072    12.942     0.200
     4.137    12.861     0.200
     4.982    17.146     0.200
     5.132    19.476     0.200
     5.781    20.998     0.200
     6.302    21.113     0.200
     6.609    19.251     0.200
     7.096    20.437     0.200
     7.272    21.427     0.200
     7.286    22.164     0.200
     7.465    22.387     0.200
     7.669    24.759     0.200
     7.669    22.469     0.200
     7.827    24.083     0.200
     8.756    24.296     0.200
    10.072    30.109     0.200
    10.794    32.410     0.200
    10.881    29.150     0.200
    15.233    36.367     0.200
    15.353    37.651     0.200
    15.377    38.276     0.200
    15.373    36.967     0.200
    15.832    37.367     0.200
     1.101     6.746     0.200
     1.123     7.899     0.200
     1.149     6.794     0.200
     1.176     7.504     0.200
     1.500     7.843     0.200
     1.563     9.043     0.200
     1.576     8.885     0.200
     1.679     8.717     0.200
     2.083    10.920     0.200
     2.329    12.254     0.200
     2.348     8.441     0.200
     3.236    11.517     0.200
     4.123    13.606     0.200
     5.634    18.807     0.200
     5.690    20.718     0.200
     5.787    19.657     0.200
     6.265    20.894     0.200
     6.595    19.765     0.200
    10.788    32.547     0.200
    10.867    28.261     0.200
     0.844     5.707     0.200
     0.895     5.856     0.200
     0.899     6.370     0.200
     0.907     6.013     0.200
     0.987     6.287     0.200
     1.002     6.336     0.200
     1.124     7.122     0.200
     1.135     6.640     0.200
     1.175     6.996     0.200
     1.351     8.159     0.200
     1.499     8.650     0.200
     1.564     7.259     0.200
     1.641     7.745     0.200
     1.679     8.622     0.200
     2.082     9.679     0.200
     2.349     8.108     0.200
     2.358    10.287     0.200
     2.446     9.850     0.200
     2.473    11.014     0.200
     5.787    19.778     0.200
     7.813    23.411     0.200
    10.788    31.850     0.200
    10.867    31.215     0.200
     1.003     6.283     0.200
     1.135     6.885     0.200
     1.172     7.124     0.200
     1.154     6.710     0.200
     1.349     8.473     0.200
     1.564     7.066     0.200
     1.580     8.411     0.200
     1.642     7.715     0.200
     2.290     8.360     0.200
     2.084    10.392     0.200
     2.347     9.141     0.200
     2.332    10.268     0.200
     2.360    10.019     0.200
     2.429     9.358     0.200
     2.449    11.259     0.200
     2.476    11.492     0.200
     2.860    11.154     0.200
     2.967    11.089     0.200
     3.030    12.334     0.200
     5.790    19.561     0.200
     7.815    22.655     0.200
    10.792    32.150     0.200
    10.867    29.802     0.200
     0.837     5.813     0.200
     1.155     6.930     0.200
     1.190     6.826     0.200
     1.327     8.012     0.200
     1.463     8.331     0.200
     1.566     7.197     0.200
     1.648     7.664     0.200
     1.638     8.542     0.200
     2.258     8.654     0.200
     2.099     9.963     0.200
     2.330     8.233     0.200
     2.354     9.394     0.200
     2.371    10.835     0.200
     2.439    10.050     0.200
     2.452    10.640     0.200
     2.479    10.205     0.200
     2.511    10.669     0.200
     2.859    11.400     0.200
     2.888    11.091     0.200
     2.919    10.957     0.200
     2.992    12.997     0.200
     3.112    12.529     0.200
     3.234    11.657     0.200
     3.272    11.824     0.200
     3.401    12.754     0.200
     3.489    13.052     0.200
     3.735    13.545     0.200
     3.969    14.468     0.200
     4.126    12.761     0.200
     4.293    14.766     0.200
     4.352    15.394     0.200
     4.422    14.651     0.200
     4.871    15.564     0.200
     4.940    16.907     0.200
     5.000    17.662     0.200
     5.821    20.982     0.200
    10.828    32.040     0.200
    10.864    28.907     0.200
     0.865     6.018     0.200
     0.941     6.448     0.200
     1.016     6.560     0.200
     1.024     6.802     0.200
     1.048     6.557     0.200
     1.150     6.702     0.200
     1.264     7.394     0.200
     1.398     7.720     0.200
     1.410     7.978     0.200
     1.443     7.365     0.200
     1.608     8.855     0.200
     1.595     7.347     0.200
     1.812     8.600     0.200
     2.278    10.990     0.200
     2.293     9.589     0.200
     2.422     8.637     0.200
     2.364    10.555     0.200
     2.437     8.594     0.200
     2.754    11.645     0.200
     2.855    10.984     0.200
     3.315    12.336     0.200
     7.534    25.396     0.200
     7.778    21.385     0.200
    10.667    32.342     0.200
    10.908    28.557     0.200
    15.091    35.628     0.200
    15.448    35.403     0.200
     1.014     6.263     0.200
     1.005     6.320     0.200
     1.007     6.358     0.200
     1.029     6.378     0.200
     1.054     6.767     0.200
     1.054     7.221     0.200
     1.080     7.188     0.200
     1.123     6.602     0.200
     1.202     6.900     0.200
     1.231     7.312     0.200
     1.239     7.129     0.200
     1.378     8.436     0.200
     1.469     8.496     0.200
     1.575     8.720     0.200
     1.581     7.853     0.200
     1.612     8.215     0.200
     1.603     8.283     0.200
     1.787     7.958     0.200
     2.001     9.528     0.200
     2.407     7.361     0.200
     2.283    10.519     0.200
     2.302    11.985     0.200
     2.334    12.173     0.200
     2.356    11.245     0.200
     2.750    11.853     0.200
     2.951    12.053     0.200
     7.806    24.923     0.200
    10.698    32.011     0.200
    10.923    28.683     0.200
     1.156     7.608     0.200
     1.222     8.681     0.200
     1.273     7.586     0.200
     1.273     8.464     0.200
     1.565     9.813     0.200
     1.675     8.795     0.200
     1.818     8.521     0.200
     1.801    10.510     0.200
     1.882    10.086     0.200
     2.053     9.560     0.200
     2.129    11.491     0.200
     2.143    10.988     0.200
     2.363    11.278     0.200
     2.450    11.941     0.200
     2.537    12.086     0.200
     2.670    11.924     0.200
     2.771    12.619     0.200
     2.989    13.324     0.200
     3.043    13.407     0.200
     3.071    11.939     0.200
     3.377    14.453     0.200
     3.413    14.534     0.200
     3.569    14.827     0.200
     3.801    14.880     0.200
     3.886    14.452     0.200
     4.221    15.837     0.200
     4.271    16.791     0.200
     4.380    15.435     0.200
     4.652    17.039     0.200
     4.689    16.995     0.200
     4.697    17.582     0.200
     4.865    17.612     0.200
     4.930    18.286     0.200
     5.060    18.869     0.200
     5.056    18.276     0.200
     5.119    19.732     0.200
     5.520    19.990     0.200
     5.688    20.385     0.200
     5.922    19.549     0.200
     6.772    21.668     0.200
     7.439    24.657     0.200
     8.114    25.339     0.200
     8.339    24.856     0.200
     8.340    24.173     0.200
     8.533    24.329     0.200
     8.828    25.621     0.200
     8.828    25.851     0.200
     9.471    28.244     0.200
    10.996    34.635     0.200
    12.059    32.270     0.200
     1.291     6.971     0.200
     1.384     7.295     0.200
     1.449     7.798     0.200
     1.532     8.282     0.200
     1.597     8.010     0.200
     1.600     7.796     0.200
     1.691     9.463     0.200
     1.773     8.527     0.200
     1.722     9.935     0.200
     1.848     9.720     0.200
     1.940     9.370     0.200
     2.015    10.389     0.200
     2.052     8.750     0.200
     2.117     9.118     0.200
     2.119     9.994     0.200
     2.135    10.102     0.200
     2.217     9.990     0.200
     2.243    10.224     0.200
     2.319    10.843     0.200
     2.386    10.053     0.200
     2.412    10.268     0.200
     2.403    11.256     0.200
     2.485    10.325     0.200
     2.464    10.332     0.200
     2.480    10.978     0.200
     2.620    10.607     0.200
     2.793    10.899     0.200
     2.783    10.846     0.200
     2.832    10.395     0.200
     3.051     7.283     0.200
     3.023    10.348     0.200
     3.062    11.336     0.200
     3.172    11.176     0.200
     3.172    13.048     0.200
     3.198    12.582     0.200
     3.330    12.721     0.200
     3.423    12.259     0.200
     3.682    12.621     0.200
     3.682    13.441     0.200
     3.779    13.153     0.200
     3.860    14.259     0.200
     3.856    13.590     0.200
     3.963    13.867     0.200
     4.111    14.415     0.200
     4.289    15.033     0.200
     4.416    15.142     0.200
     4.439    15.063     0.200
     4.538    14.032     0.200
     4.632    15.976     0.200
     4.700    14.573     0.200
     4.678    14.636     0.200
     4.922    13.811     0.200
     5.051    13.433     0.200
     5.514    15.555     0.200
     5.549    15.644     0.200
     5.591    15.536     0.200
     5.566    15.329     0.200
     5.850    15.621     0.200
     5.892    16.217     0.200
     6.079    15.851     0.200
     6.078    17.515     0.200
     6.303    16.347     0.200
     6.387    17.110     0.200
     6.541    17.356     0.200
     6.683    16.817     0.200
     6.859    17.623     0.200
     6.880    17.903     0.200
     6.936    19.453     0.200
     6.996    18.783     0.200
     6.970    20.461     0.200
     6.984    19.996     0.200
     7.047    19.138     0.200
     7.031    18.911     0.200
     7.192    18.246     0.200
     7.204    18.440     0.200
     7.210    18.268     0.200
     7.224    18.068     0.200
     7.258    18.488     0.200
     7.263    17.849     0.200
     7.294    18.631     0.200
     7.359    20.017     0.200
     7.390    20.246     0.200
     7.433    19.449     0.200
     7.453    20.094     0.200
     7.486    20.283     0.200
     7.483    20.329     0.200
     7.533    20.374     0.200
     7.892    20.450     0.200
     7.892    19.973     0.200
     7.892    20.215     0.200
    10.940    28.562     0.200
    11.333    29.319     0.200
    11.334    30.028     0.200
     1.043     7.250     0.200
     1.212     7.072     0.200
     1.207     7.793     0.200
     1.244     7.486     0.200
     1.587     8.803     0.200
     1.797     8.713     0.200
     2.301     9.842     0.200
     2.287     9.954     0.200
     2.384    10.119     0.200
     2.438     8.315     0.200
     2.664     9.346     0.200
     2.746    10.554     0.200
     2.857    10.572     0.200
     5.670    18.889     0.200
     7.549    24.354     0.200
    10.686    32.078     0.200
    10.918    31.272     0.200
     1.046     6.663     0.200
     1.072     7.706     0.200
     1.447     3.644     0.200
     1.583     8.670     0.200
     1.560     9.577     0.200
     1.584     7.517     0.200
     1.608     8.880     0.200
     1.794     7.468     0.200
     2.002    10.251     0.200
     2.295    11.360     0.200
     2.563    10.166     0.200
     3.048    13.060     0.200
    10.919    31.945     0.200
     0.775     5.669     0.200
     0.791     5.625     0.200
     0.797     5.805     0.200
     0.804     6.134     0.200
     0.795     5.991     0.200
     0.809     5.846     0.200
     0.821     5.727     0.200
     0.838     5.854     0.200
     0.845     6.063     0.200
     0.871     5.957     0.200
     0.872     5.957     0.200
     0.890     6.111     0.200
     0.903     6.197     0.200
     0.903     6.440     0.200
     0.987     6.833     0.200
     1.121     7.833     0.200
     1.201     7.538     0.200
     1.227     7.334     0.200
     1.245     7.265     0.200
     1.254     7.385     0.200
     1.339     7.828     0.200
     1.406     8.307     0.200
     1.432     8.046     0.200
     1.531     8.216     0.200
     1.569     8.230     0.200
     1.575     8.176     0.200
     1.593     9.531     0.200
     1.649     8.325     0.200
     1.667     8.246     0.200
     1.748     8.615     0.200
     1.815     8.429     0.200
     2.000     9.052     0.200
     2.379     8.751     0.200
     2.279    10.866     0.200
     2.350    10.843     0.200
     2.339    11.958     0.200
     2.342    11.729     0.200
     2.367    12.311     0.200
     2.349    11.540     0.200
     2.441    11.873     0.200
     2.754    10.590     0.200
     2.768    11.635     0.200
     2.799    13.159     0.200
     2.875    12.148     0.200
     2.948    11.883     0.200
     2.991    13.309     0.200
     3.115    11.059     0.200
     3.151    12.105     0.200
     3.281    12.513     0.200
     3.311    11.665     0.200
     3.380    13.704     0.200
     3.431    12.399     0.200
     3.465    14.029     0.200
     3.730    14.413     0.200
     3.830    14.601     0.200
     3.850    14.268     0.200
     3.881    15.498     0.200
     3.902    14.837     0.200
     4.073    15.484     0.200
     4.095    14.743     0.200
     4.163    13.541     0.200
     4.184    14.168     0.200
     4.259    15.900     0.200
     4.284    15.084     0.200
     4.337    14.841     0.200
     4.353    15.234     0.200
     4.439    15.891     0.200
     4.494    15.847     0.200
     4.509    15.725     0.200
     4.675    15.798     0.200
     4.888    16.993     0.200
     4.910    16.158     0.200
     4.913    17.330     0.200
     4.942    17.062     0.200
     5.186    16.131     0.200
     5.202    16.424     0.200
     5.235    16.320     0.200
     5.284    16.451     0.200
     5.319    17.071     0.200
     5.575    17.651     0.200
     5.601    17.330     0.200
     5.602    18.543     0.200
     5.615    18.652     0.200
     5.676    18.064     0.200
     5.700    19.853     0.200
     6.221    19.026     0.200
     6.471    18.144     0.200
     6.515    19.256     0.200
     6.810    19.193     0.200
     7.296    20.501     0.200
     7.493    20.704     0.200
     7.596    24.214     0.200
     7.617    22.175     0.200
     7.802    21.645     0.200
     7.840    22.863     0.200
     8.800    23.186     0.200
     9.171    25.209     0.200
     9.236    24.710     0.200
    10.244    29.039     0.200
     1.083     6.214     0.200
     1.101     6.837     0.200
     1.411     3.248     0.200
     1.199     6.668     0.200
     1.359     7.670     0.200
     1.498     8.602     0.200
     1.548     8.286     0.200
     1.553     8.107     0.200
     1.583     7.843     0.200
     1.589     8.293     0.200
     1.612     8.589     0.200
     1.712     8.847     0.200
     1.759     8.330     0.200
     1.995     9.446     0.200
     2.010     8.642     0.200
     2.050     9.899     0.200
     2.382     7.136     0.200
     2.290     8.600     0.200
     2.319     9.763     0.200
     2.316     8.745     0.200
     2.329     9.161     0.200
     2.329     8.938     0.200
     2.362     9.230     0.200
     2.426     9.156     0.200
     2.423     9.943     0.200
     2.762    11.262     0.200
     2.770    11.195     0.200
     2.878     9.191     0.200
     2.942    10.556     0.200
     2.959    10.694     0.200
     2.959     9.373     0.200
     2.984    10.054     0.200
     2.988     9.757     0.200
     2.980     9.013     0.200
     2.996     9.566     0.200
     3.116    10.360     0.200
     3.147    10.891     0.200
     3.281    10.680     0.200
     3.323     9.766     0.200
     3.369    11.763     0.200
     3.437    12.321     0.200
     3.461    11.536     0.200
     3.705    12.967     0.200
     3.725    11.859     0.200
     3.824    13.106     0.200
     3.852    11.959     0.200
     3.896    12.366     0.200
     3.896    13.866     0.200
     4.065    11.805     0.200
     4.092    11.999     0.200
     4.092    16.580     0.200
     4.176    11.579     0.200
     4.168    13.383     0.200
     4.186    16.774     0.200
     4.239    14.418     0.200
     4.270    15.996     0.200
     4.273    14.022     0.200
     4.320    14.460     0.200
     4.350    14.410     0.200
     4.440    13.317     0.200
     4.492    15.211     0.200
     4.539    15.145     0.200
     4.686    14.966     0.200
     4.765    15.261     0.200
     4.875    16.075     0.200
     4.919    13.496     0.200
     4.897    15.650     0.200
     4.968    15.640     0.200
     5.082    14.118     0.200
     5.183    15.729     0.200
     5.199    14.998     0.200
     5.244    15.115     0.200
     5.562    16.635     0.200
     5.656    16.828     0.200
     5.698    18.804     0.200
     6.218    17.981     0.200
     6.219    18.266     0.200
     6.456    18.690     0.200
     6.468    16.461     0.200
     6.508    21.856     0.200
     6.515    16.109     0.200
     6.631    18.575     0.200
     6.705    17.454     0.200
     6.871    18.237     0.200
     7.105    23.851     0.200
     7.212    20.236     0.200
     7.220    21.252     0.200
     7.240    21.734     0.200
     7.288    21.551     0.200
     7.336    21.514     0.200
     7.368    22.605     0.200
     7.385    23.541     0.200
     7.564    23.649     0.200
     7.586    23.692     0.200
     7.820    24.806     0.200
     7.820    25.063     0.200
     7.820    22.583     0.200
     7.844    24.714     0.200
     7.997    24.664     0.200
     8.783    23.726     0.200
     8.783    24.332     0.200
     8.783    23.832     0.200
     9.038    28.753     0.200
     9.544    25.961     0.200
    10.153    31.914     0.200
    10.245    29.869     0.200
    10.575    26.862     0.200
    10.622    29.406     0.200
    10.726    31.808     0.200
    10.726    32.558     0.200
    10.919    29.501     0.200
    10.919    29.204     0.200
    10.921    29.384     0.200
    10.921    30.148     0.200
    10.921    29.074     0.200
    14.049    34.077     0.200
    14.347    37.342     0.200
    14.430    35.457     0.200
    14.552    32.310     0.200
    14.591    34.227     0.200
    14.700    33.498     0.200
    14.875    32.511     0.200
    15.025    33.977     0.200
    15.140    38.286     0.200
    15.180    33.666     0.200
    15.223    33.521     0.200
    15.309    34.198     0.200
    15.382    33.469     0.200
    15.444    33.263     0.200
    15.498    33.828     0.200
    15.497    34.141     0.200
    15.525    34.248     0.200
    15.590    34.198     0.200
    15.599    34.692     0.200
    15.663    35.177     0.200
    15.794    34.192     0.200
    15.800    33.728     0.200
    16.001    34.371     0.200
    16.578    34.418     0.200
    17.306    34.267     0.200
    17.592    34.911     0.200
    17.600    35.794     0.200
    17.699    35.031     0.200
    18.099    35.460     0.200
    18.201    35.113     0.200
    18.370    42.347     0.200
    20.401    40.816     0.200
    20.401    42.843     0.200
     1.009     7.089     0.200
     1.099     7.722     0.200
     1.123     6.673     0.200
     1.180     7.647     0.200
     1.210     7.868     0.200
     1.223     8.042     0.200
     1.225     7.116     0.200
     1.225     7.093     0.200
     1.361     8.543     0.200
     1.359     9.099     0.200
     1.412     8.224     0.200
     1.433     7.859     0.200
     1.438     8.364     0.200
     1.494     8.683     0.200
     1.551     8.809     0.200
     1.554     8.511     0.200
     1.582     8.413     0.200
     1.586     8.887     0.200
     1.612     8.520     0.200
     1.655     8.564     0.200
     1.710     9.603     0.200
     1.736     8.581     0.200
     2.008     9.495     0.200
     2.289    10.289     0.200
     2.314    10.531     0.200
     2.325    10.824     0.200
     2.327    10.358     0.200
     2.361    10.566     0.200
     2.361    10.730     0.200
     2.420    11.643     0.200
     2.428     9.467     0.200
     2.760    11.962     0.200
     2.767    12.268     0.200
     2.790    12.453     0.200
     2.875    12.477     0.200
     2.957    11.830     0.200
     2.976    11.906     0.200
     3.076    11.874     0.200
     3.113    12.590     0.200
     3.144    13.446     0.200
     3.278    13.068     0.200
     3.322    13.734     0.200
     3.365    14.149     0.200
     3.434    14.292     0.200
     3.458    14.743     0.200
     3.702    14.745     0.200
     3.708    14.926     0.200
     3.721    13.994     0.200
     3.820    16.272     0.200
     3.859    16.204     0.200
     3.892    15.001     0.200
     3.897    14.364     0.200
     4.062    15.991     0.200
     4.089    14.115     0.200
     4.175    16.152     0.200
     4.169    14.726     0.200
     4.237    15.300     0.200
     4.269    14.732     0.200
     4.267    14.905     0.200
     4.317    15.042     0.200
     4.347    17.367     0.200
     4.437    16.130     0.200
     4.488    15.183     0.200
     4.481    16.476     0.200
     4.488    15.917     0.200
     4.536    15.913     0.200
     4.684    15.671     0.200
     4.761    15.981     0.200
     4.872    16.882     0.200
     4.893    16.893     0.200
     4.918    16.432     0.200
     4.921    16.463     0.200
     5.079    17.185     0.200
     5.180    17.276     0.200
     5.195    16.526     0.200
     5.242    16.462     0.200
     5.282    18.382     0.200
     5.437    16.474     0.200
     5.558    18.028     0.200
     5.598    19.043     0.200
     5.608    16.700     0.200
     5.597    18.617     0.200
     5.653    17.085     0.200
     5.662    16.636     0.200
     6.025    18.205     0.200
     6.170    18.922     0.200
     6.215    18.473     0.200
     6.223    19.022     0.200
     6.453    19.751     0.200
     6.464    19.406     0.200
     6.512    18.462     0.200
     6.631    18.923     0.200
     6.637    19.721     0.200
     6.737    20.089     0.200
     6.790    18.082     0.200
     7.103    20.215     0.200
     7.237    20.294     0.200
     7.287    20.300     0.200
     7.382    20.355     0.200
     7.471    19.553     0.200
     7.458    19.173     0.200
     7.583    25.703     0.200
     7.583    21.438     0.200
     7.743    22.018     0.200
     7.782    22.063     0.200
     7.819    24.695     0.200
     7.819    21.796     0.200
     7.820    21.276     0.200
     7.820    21.542     0.200
     8.030    21.504     0.200
     8.783    23.455     0.200
     9.149    25.617     0.200
    10.156    30.101     0.200
    10.243    29.572     0.200
    10.576    27.985     0.200
    10.722    28.318     0.200
    10.722    27.027     0.200
    10.722    33.496     0.200
    10.922    28.185     0.200
     0.900     5.941     0.200
     0.906     5.874     0.200
     0.932     6.207     0.200
     0.948     6.082     0.200
     0.943     6.005     0.200
     1.012     6.163     0.200
     1.109     6.518     0.200
     1.103     7.501     0.200
     1.206     7.111     0.200
     1.357     8.109     0.200
     1.548     8.740     0.200
     1.615     6.695     0.200
     1.760     8.665     0.200
     2.007     9.114     0.200
     2.287    10.231     0.200
     2.331    11.450     0.200
     2.328    11.757     0.200
     2.359    10.512     0.200
     2.429     8.243     0.200
     2.424    10.638     0.200
     2.664     9.309     0.200
     2.759    10.294     0.200
     2.767    11.621     0.200
     3.114    10.946     0.200
     3.145    11.219     0.200
     5.696    19.713     0.200
     7.585    24.681     0.200
     7.823    24.027     0.200
    10.726    34.029     0.200
    10.925    29.136     0.200
     0.755     5.635     0.200
     0.776     5.781     0.200
     0.802     5.539     0.200
     0.797     5.680     0.200
     0.793     5.414     0.200
     0.791     5.479     0.200
     0.809     5.787     0.200
     0.819     5.689     0.200
     0.819     5.593     0.200
     0.831     5.761     0.200
     0.849     5.892     0.200
     0.863     5.701     0.200
     0.885     5.757     0.200
     0.858     5.715     0.200
     0.865     5.905     0.200
     0.879     6.158     0.200
     0.886     5.863     0.200
     0.898     6.159     0.200
     0.898     6.151     0.200
     0.908     6.030     0.200
     0.926     6.220     0.200
     0.940     6.117     0.200
     0.994     6.075     0.200
     0.976     6.097     0.200
     0.979     6.321     0.200
     1.012     6.247     0.200
     0.977     7.048     0.200
     0.988     6.485     0.200
     1.011     6.478     0.200
     1.011     6.393     0.200
     1.023     6.689     0.200
     1.043     6.310     0.200
     1.027     6.352     0.200
     1.026     6.374     0.200
     1.056     7.172     0.200
     1.083     6.473     0.200
     1.070     6.360     0.200
     1.096     6.467     0.200
     1.106     6.597     0.200
     1.083     6.479     0.200
     1.100     7.787     0.200
     1.150     6.950     0.200
     1.171     7.161     0.200
     1.184     7.129     0.200
     1.184     6.858     0.200
     1.218     7.237     0.200
     1.216     6.980     0.200
     1.258     8.202     0.200
     1.279     7.435     0.200
     1.358     7.849     0.200
     1.347     8.801     0.200
     1.368     7.470     0.200
     1.373     7.865     0.200
     1.406     7.548     0.200
     1.398     7.789     0.200
     1.550     7.766     0.200
     1.568     8.866     0.200
     1.553     7.793     0.200
     1.621     8.007     0.200
     1.643     8.843     0.200
     1.668     8.501     0.200
     1.704     8.640     0.200
     1.796     8.577     0.200
     1.970     9.429     0.200
     2.253    10.436     0.200
     2.325    10.234     0.200
     2.468     8.581     0.200
     2.698     9.405     0.200
     2.721    11.032     0.200
     2.725    12.648     0.200
     2.921    12.080     0.200
     3.072    11.064     0.200
     3.105    12.075     0.200
     3.237    11.661     0.200
     3.393    12.134     0.200
     3.683    15.976     0.200
     3.717    14.272     0.200
     3.807    13.282     0.200
     3.874    13.920     0.200
     3.914    13.779     0.200
     4.049    14.522     0.200
     4.197    13.559     0.200
     4.197    13.440     0.200
     4.307    14.951     0.200
     4.447    14.586     0.200
     4.647    14.737     0.200
     4.738    15.820     0.200
     4.879    15.924     0.200
     4.871    16.564     0.200
     4.932    16.105     0.200
     5.317    16.339     0.200
     5.654    17.036     0.200
     6.181    18.875     0.200
     6.471    19.382     0.200
     6.655    19.574     0.200
     7.293    21.683     0.200
     7.830    22.201     0.200
     7.832    21.521     0.200
    10.954    29.243     0.200
     0.760     5.495     0.200
     0.800     5.762     0.200
     0.813     5.602     0.200
     0.906     5.965     0.200
     0.908     6.054     0.200
     0.931     6.275     0.200
     1.197     7.255     0.200
     1.349     8.659     0.200
     1.539     8.617     0.200
     1.578     8.088     0.200
     1.593     8.250     0.200
     1.618     8.637     0.200
     1.712     8.609     0.200
     1.752     8.862     0.200
     2.007     9.339     0.200
     2.378     9.007     0.200
     2.287    10.676     0.200
     2.338    10.262     0.200
     2.360    10.725     0.200
     2.358    10.592     0.200
     2.376    10.869     0.200
     2.433    10.826     0.200
     2.665     9.863     0.200
     2.761    10.458     0.200
     2.771    10.251     0.200
     2.799    10.783     0.200
     2.989    11.046     0.200
     3.089    12.601     0.200
     3.118    11.546     0.200
     3.147    11.200     0.200
     3.151    11.508     0.200
     3.283    12.238     0.200
     3.319    11.340     0.200
     3.436    11.843     0.200
     3.465    11.667     0.200
     3.719    13.981     0.200
     3.730    12.940     0.200
     3.829    13.309     0.200
     3.853    13.147     0.200
     3.871    13.783     0.200
     3.901    13.560     0.200
     3.906    14.049     0.200
     3.916    13.041     0.200
     4.071    13.485     0.200
     4.174    14.018     0.200
     4.249    14.340     0.200
     4.280    14.944     0.200
     4.280    15.688     0.200
     4.330    15.509     0.200
     4.501    16.078     0.200
     4.548    14.704     0.200
     4.774    16.005     0.200
     4.883    16.870     0.200
     4.931    17.306     0.200
     5.187    15.773     0.200
     5.287    16.458     0.200
     5.570    17.244     0.200
     6.638    19.811     0.200
    10.927    28.356     0.200
     0.792     5.485     0.200
     0.808     5.565     0.200
     0.810     5.441     0.200
     0.815     5.686     0.200
     0.881     5.961     0.200
     0.911     6.000     0.200
     0.913     6.132     0.200
     0.943     6.177     0.200
     0.992     6.297     0.200
     1.000     6.882     0.200
     1.010     6.553     0.200
     1.025     6.335     0.200
     1.091     6.852     0.200
     1.107     7.921     0.200
     1.424     4.051     0.200
     1.562     7.439     0.200
     1.552     8.228     0.200
     1.569     8.850     0.200
     1.632     8.282     0.200
     1.689     9.675     0.200
     1.774     8.345     0.200
     1.987     8.612     0.200
     2.056     9.345     0.200
     2.236    10.068     0.200
     2.403     8.337     0.200
     2.268    10.334     0.200
     2.293    10.965     0.200
     2.313    10.483     0.200
     2.340    10.414     0.200
     2.339    10.323     0.200
     2.420    10.877     0.200
     2.739    10.852     0.200
     2.775    11.902     0.200
     2.936    11.149     0.200
     2.965    11.366     0.200
     2.966    11.800     0.200
     3.094    10.571     0.200
     3.082    12.529     0.200
     3.127    11.174     0.200
     3.259    11.737     0.200
     3.301    11.198     0.200
     3.720    13.283     0.200
     3.805    14.227     0.200
     3.829    12.912     0.200
     3.877    12.883     0.200
     3.893    13.665     0.200
     3.866    12.902     0.200
     3.912    13.430     0.200
     4.047    14.510     0.200
     4.071    13.120     0.200
     4.188    12.228     0.200
     4.329    15.507     0.200
     4.313    14.937     0.200
     4.468    14.549     0.200
     4.486    16.117     0.200
     4.756    15.972     0.200
     4.934    16.481     0.200
     5.162    16.531     0.200
     5.178    17.262     0.200
     5.221    17.306     0.200
     5.315    16.455     0.200
     5.550    18.629     0.200
     5.677    19.918     0.200
     5.774    17.324     0.200
     6.020    19.397     0.200
     6.150    19.454     0.200
     6.197    19.684     0.200
     6.217    20.632     0.200
     6.718    19.595     0.200
     7.109    22.229     0.200
     7.236    21.456     0.200
     7.291    20.299     0.200
     7.375    20.782     0.200
     7.483    21.039     0.200
     7.493    20.612     0.200
     7.571    24.195     0.200
     7.571    20.781     0.200
     7.599    20.152     0.200
     7.727    22.942     0.200
     7.746    23.027     0.200
     7.780    22.112     0.200
     7.832    23.987     0.200
     7.832    23.034     0.200
     8.022    22.614     0.200
     8.802    22.777     0.200
     9.028    24.623     0.200
     9.235    25.512     0.200
    10.718    33.492     0.200
    10.942    27.873     0.200
    10.942    28.473     0.200
    13.421    34.782     0.200
    15.123    34.924     0.200
    15.274    38.198     0.200
    15.420    38.028     0.200
     0.795     5.769     0.200
     0.824     6.011     0.200
     0.826     5.927     0.200
     0.865     6.054     0.200
     1.464     4.635     0.200
     1.229     7.607     0.200
     1.363     8.889     0.200
     1.815     9.012     0.200
     2.163     9.671     0.200
     2.239    11.710     0.200
     2.272    12.644     0.200
     2.335    10.214     0.200
     2.393    11.348     0.200
     2.712    10.037     0.200
     2.704    11.547     0.200
     2.731    12.048     0.200
     2.815    13.648     0.200
     5.634    20.491     0.200
     7.529    24.270     0.200
     7.831    25.677     0.200
    10.684    34.727     0.200
    10.965    31.486     0.200
     0.846     6.010     0.200
     0.884     6.382     0.200
     0.886     6.179     0.200
     0.892     6.110     0.200
     0.919     6.395     0.200
     0.938     6.428     0.200
     0.961     6.344     0.200
     0.966     6.973     0.200
     0.998     6.440     0.200
     0.999     6.687     0.200
     1.011     6.414     0.200
     1.011     6.465     0.200
     1.015     6.889     0.200
     1.038     7.086     0.200
     1.050     6.502     0.200
     1.061     6.868     0.200
     1.094     6.685     0.200
     1.093     7.523     0.200
     1.113     6.808     0.200
     1.161     7.160     0.200
     1.165     6.954     0.200
     1.465     4.185     0.200
     1.230     7.352     0.200
     1.364     8.428     0.200
     1.442    10.200     0.200
     1.649     9.323     0.200
     1.817     9.031     0.200
     2.238    10.897     0.200
     2.252    10.425     0.200
     2.311    11.250     0.200
     2.335    11.438     0.200
     2.392    12.172     0.200
     2.703    11.490     0.200
     2.704    11.347     0.200
     2.713    10.177     0.200
     2.813    11.492     0.200
     3.051    12.012     0.200
     5.632    19.419     0.200
     7.528    24.733     0.200
     7.831    24.963     0.200
    10.683    31.088     0.200
    10.966    30.288     0.200
    15.079    39.970     0.200
     0.958     7.441     0.200
     0.967     7.245     0.200
     1.045     7.452     0.200
     1.086     6.824     0.200
     1.102     7.967     0.200
     1.104     6.998     0.200
     1.154     8.064     0.200
     1.167     7.317     0.200
     1.163     7.529     0.200
     1.216     7.509     0.200
     1.222     7.827     0.200
     1.266     7.426     0.200
     1.307     7.510     0.200
     1.355     8.659     0.200
     1.351     8.116     0.200
     1.392     7.776     0.200
     1.576     9.656     0.200
     1.813     9.410     0.200
     2.441    12.382     0.200
     2.812    10.353     0.200
     5.633    21.422     0.200
     7.532    24.759     0.200
     7.839    24.367     0.200
    10.689    33.478     0.200
    10.972    29.678     0.200
     1.153     7.841     0.200
     1.166     7.642     0.200
     1.163     7.347     0.200
     1.215     7.056     0.200
     1.221     7.615     0.200
     1.459     4.384     0.200
     1.258     7.619     0.200
     1.354     8.036     0.200
     1.352     8.266     0.200
     1.377     8.024     0.200
     1.449     9.986     0.200
     1.532     7.823     0.200
     1.534     7.839     0.200
     1.526     9.758     0.200
     1.575     8.815     0.200
     1.602     8.096     0.200
     1.647     9.670     0.200
     1.811     8.719     0.200
     2.233    10.694     0.200
     2.400    10.686     0.200
     2.704    11.625     0.200
     2.900    11.751     0.200
     3.073    12.682     0.200
     3.216    12.115     0.200
     3.318    12.994     0.200
     3.786    13.649     0.200
     3.836    15.358     0.200
     3.926    14.449     0.200
     4.237    15.552     0.200
     4.250    15.407     0.200
     4.287    15.033     0.200
     4.287    15.189     0.200
     4.462    15.884     0.200
     4.498    15.416     0.200
     4.728    17.497     0.200
     4.828    17.508     0.200
     4.862    15.923     0.200
     4.940    16.590     0.200
     5.634    22.509     0.200
     7.101    21.341     0.200
     7.533    26.725     0.200
     7.550    22.546     0.200
    10.691    33.782     0.200
     1.075     7.749     0.200
     1.079     7.202     0.200
     1.080     7.053     0.200
     1.081     7.371     0.200
     1.117     7.145     0.200
     1.176     7.303     0.200
     1.261     7.498     0.200
     1.274     7.539     0.200
     1.268     8.008     0.200
     1.301     8.603     0.200
     1.344     8.361     0.200
     1.352     8.165     0.200
     1.392     9.514     0.200
     1.609     8.293     0.200
     1.609     9.204     0.200
     1.629     8.545     0.200
     1.688     9.497     0.200
     1.829     9.527     0.200
     1.871     8.150     0.200
     2.090    10.230     0.200
     2.153    11.087     0.200
     2.419     9.279     0.200
     2.424    11.833     0.200
     2.603    10.449     0.200
     2.615    10.909     0.200
     2.652    11.774     0.200
     2.685    11.349     0.200
     2.827    11.274     0.200
     2.886    10.327     0.200
     3.006    12.261     0.200
     3.048    11.587     0.200
     3.155    11.536     0.200
     3.229    11.820     0.200
     3.312    12.395     0.200
     3.343    13.298     0.200
     3.462    13.292     0.200
     3.482    13.118     0.200
     3.747    14.075     0.200
     3.776    14.184     0.200
     3.781    14.215     0.200
     3.869    13.890     0.200
     3.933    14.527     0.200
     3.954    13.028     0.200
     3.996    13.879     0.200
     4.076    13.560     0.200
     4.120    14.101     0.200
     4.132    14.166     0.200
     4.184    13.636     0.200
     4.345    15.025     0.200
     4.383    15.320     0.200
     4.382    14.783     0.200
     4.484    15.879     0.200
     4.505    16.077     0.200
     4.509    16.447     0.200
     4.513    15.805     0.200
     4.560    15.231     0.200
     4.700    15.544     0.200
     4.742    17.353     0.200
     4.796    16.520     0.200
     4.942    17.722     0.200
     5.082    16.556     0.200
     5.091    17.155     0.200
     5.163    17.719     0.200
     5.187    17.222     0.200
     5.209    16.645     0.200
     5.210    19.077     0.200
     5.562    18.651     0.200
     5.585    17.623     0.200
     5.633    18.266     0.200
     5.670    20.053     0.200
     5.707    18.254     0.200
     5.808    17.500     0.200
     6.207    19.632     0.200
     6.302    20.033     0.200
     6.451    20.034     0.200
     6.460    19.546     0.200
     6.905    20.285     0.200
     7.372    22.573     0.200
     7.674    25.119     0.200
     7.674    22.720     0.200
     7.713    23.706     0.200
     7.794    23.450     0.200
     8.108    26.507     0.200
     8.108    24.179     0.200
     9.495    26.307     0.200
     9.603    26.813     0.200
    10.910    32.337     0.200
    11.167    31.363     0.200
     0.753     5.344     0.200
     0.771     5.395     0.200
     0.799     5.572     0.200
     0.801     5.674     0.200
     0.811     5.643     0.200
     0.817     5.580     0.200
     0.836     5.669     0.200
     0.851     5.714     0.200
     0.857     5.751     0.200
     0.871     5.924     0.200
     0.890     6.042     0.200
     0.898     5.760     0.200
     0.904     6.162     0.200
     0.905     6.037     0.200
     0.908     6.018     0.200
     0.920     6.108     0.200
     0.923     6.223     0.200
     0.933     6.104     0.200
     0.937     6.096     0.200
     0.971     6.273     0.200
     0.984     6.957     0.200
     1.003     6.295     0.200
     1.005     6.291     0.200
     1.023     6.388     0.200
     1.102     6.933     0.200
     1.124     7.136     0.200
     1.184     6.951     0.200
     1.182     6.722     0.200
     1.224     7.131     0.200
     1.336     8.042     0.200
     1.384     9.321     0.200
     1.513     7.884     0.200
     1.527     8.361     0.200
     1.596     8.152     0.200
     1.628     7.029     0.200
     1.709     8.500     0.200
     1.745     8.337     0.200
     2.001     8.731     0.200
     2.279     9.759     0.200
     2.433     8.198     0.200
     2.673     9.001     0.200
     2.755    10.405     0.200
     2.795    10.567     0.200
     3.117    11.150     0.200
     3.154    10.590     0.200
     3.283    11.864     0.200
     3.384    12.001     0.200
     3.727    13.202     0.200
     3.733    13.037     0.200
     3.834    13.270     0.200
     3.919    13.053     0.200
     4.185    13.357     0.200
     4.262    14.311     0.200
     4.288    15.053     0.200
     4.557    15.618     0.200
     5.703    18.509     0.200
     7.600    24.563     0.200
     7.843    23.148     0.200
    10.745    30.282     0.200
    10.936    28.404     0.200
     0.750     5.367     0.200
     0.726     5.256     0.200
     0.758     5.189     0.200
     0.782     5.145     0.200
     0.762     5.430     0.200
     0.833     5.725     0.200
     0.811     5.184     0.200
     0.780     5.793     0.200
     0.850     5.297     0.200
     0.834     5.554     0.200
     0.830     5.522     0.200
     0.859     5.487     0.200
     0.807     5.784     0.200
     0.932     6.585     0.200
     0.881     5.856     0.200
     0.871     6.444     0.200
     0.897     5.913     0.200
     0.903     6.144     0.200
     0.963     5.835     0.200
     0.896     6.385     0.200
     0.904     6.503     0.200
     0.925     5.956     0.200
     1.097     6.846     0.200
     1.061     7.453     0.200
     1.182     7.159     0.200
     1.258     7.520     0.200
     1.275     6.926     0.200
     1.424     6.621     0.200
     1.434     7.234     0.200
     1.452     7.576     0.200
     1.598     7.505     0.200
     1.627     7.445     0.200
     1.985     8.985     0.200
     2.029     9.419     0.200
     2.160     9.317     0.200
     2.122     9.461     0.200
     2.201     9.670     0.200
     2.237    10.330     0.200
     2.359     8.423     0.200
     2.360     8.823     0.200
     2.432    11.203     0.200
     2.512    10.628     0.200
     2.663    10.568     0.200
     2.966     8.290     0.200
     2.905    10.359     0.200
     3.169    10.220     0.200
     3.202    12.204     0.200
     3.195    12.356     0.200
     3.416    12.947     0.200
     3.461    12.957     0.200
     4.500    15.115     0.200
     4.544    14.529     0.200
     4.774    16.416     0.200
     4.905    14.269     0.200
     4.932    16.506     0.200
     5.160    18.217     0.200
     5.496    17.482     0.200
     5.582    17.886     0.200
     5.714    17.985     0.200
     5.952    18.252     0.200
     6.648    19.712     0.200
     7.243    21.038     0.200
     7.338    20.128     0.200
     7.311    21.729     0.200
     7.740    21.750     0.200
     7.733    21.869     0.200
     8.402    23.314     0.200
     8.402    22.924     0.200
     8.403    22.789     0.200
     8.909    25.744     0.200
     9.504    23.718     0.200
    10.246    27.007     0.200
    10.734    29.716     0.200
    11.315    29.815     0.200
    11.673    30.745     0.200
    11.674    30.876     0.200
    11.674    30.046     0.200
     0.892     6.244     0.200
     0.885     6.443     0.200
     0.895     6.123     0.200
     0.918     6.620     0.200
     0.912     6.453     0.200
     0.921     6.831     0.200
     0.981     6.831     0.200
     1.048     6.641     0.200
     1.086     7.184     0.200
     1.112     7.618     0.200
     1.264     7.176     0.200
     1.293     8.191     0.200
     1.340     7.924     0.200
     1.482     9.035     0.200
     1.641     7.730     0.200
     1.695    10.738     0.200
     1.778     8.336     0.200
     1.957    10.187     0.200
     2.042     8.983     0.200
     2.068    10.734     0.200
     2.169    11.341     0.200
     2.208    11.005     0.200
     2.308    10.617     0.200
     2.530    11.497     0.200
     2.606    11.711     0.200
     3.064    12.274     0.200
     3.117    12.834     0.200
     5.200    19.372     0.200
     5.200    17.727     0.200
     5.899    19.162     0.200
     5.913    18.897     0.200
     6.515    18.487     0.200
     6.687    21.562     0.200
     6.805    22.362     0.200
     7.080    22.089     0.200
     7.105    21.294     0.200
     7.510    24.246     0.200
     7.721    22.610     0.200
     7.922    24.993     0.200
     8.127    26.735     0.200
     8.322    23.087     0.200
     8.323    24.037     0.200
     8.819    28.938     0.200
     9.551    30.309     0.200
     9.879    27.386     0.200
    11.049    33.151     0.200
    16.218    35.839     0.200
    16.491    36.868     0.200
    18.266    38.093     0.200
     0.985     6.173     0.200
     1.042     6.264     0.200
     1.061     7.320     0.200
     1.071     6.373     0.200
     1.071     6.428     0.200
     1.085     6.600     0.200
     1.088     6.540     0.200
     1.102     6.635     0.200
     1.109     6.634     0.200
     1.115     6.657     0.200
     1.139     7.025     0.200
     1.163     7.391     0.200
     1.169     7.091     0.200
     1.204     6.959     0.200
     1.211     6.904     0.200
     1.211     6.857     0.200
     1.223     6.982     0.200
     1.228     7.144     0.200
     1.271     7.166     0.200
     1.436     7.260     0.200
     1.442     7.313     0.200
     1.446     7.283     0.200
     1.453     7.423     0.200
     1.458     7.302     0.200
     1.466     7.353     0.200
     1.485     7.080     0.200
     1.482     7.257     0.200
     1.543     7.644     0.200
     1.541     8.362     0.200
     1.570     7.939     0.200
     1.637     8.030     0.200
     1.752     7.805     0.200
     1.820     8.767     0.200
     2.138     7.806     0.200
     1.988     9.740     0.200
     2.213     8.001     0.200
     2.215     8.678     0.200
     2.336     9.960     0.200
     2.486     8.972     0.200
     2.561     9.938     0.200
     2.601    10.205     0.200
     2.979     9.989     0.200
     3.011    10.169     0.200
     3.031    10.636     0.200
     3.116     9.877     0.200
     3.160    11.222     0.200
     3.156    10.905     0.200
     3.239    10.950     0.200
     3.358    11.250     0.200
     3.371    11.960     0.200
     3.390    12.997     0.200
     3.586    13.008     0.200
     3.705    12.718     0.200
     3.810    12.595     0.200
     3.922    13.507     0.200
     3.977    13.126     0.200
     4.044    12.308     0.200
     4.061    14.131     0.200
     4.093    14.896     0.200
     4.142    14.058     0.200
     4.302    14.901     0.200
     4.337    14.856     0.200
     4.354    14.015     0.200
     4.394    15.576     0.200
     4.683    15.263     0.200
     4.729    14.448     0.200
     5.069    15.441     0.200
     5.128    15.862     0.200
     5.243    16.326     0.200
     5.325    16.344     0.200
     5.455    16.932     0.200
     5.824    16.450     0.200
     5.943    16.930     0.200
     6.200    16.770     0.200
     6.462    17.874     0.200
     7.172    19.443     0.200
     7.224    19.659     0.200
     7.383    19.115     0.200
     7.557    19.625     0.200
     7.604    19.594     0.200
     7.604    20.858     0.200
     7.689    19.788     0.200
     7.728    19.814     0.200
     7.799    25.091     0.200
     7.799    20.614     0.200
     7.811    21.460     0.200
     7.831    20.805     0.200
     7.931    20.112     0.200
     8.669    22.795     0.200
    10.769    28.479     0.200
     0.984     7.385     0.200
     1.007     7.415     0.200
     0.998     7.615     0.200
     1.002     7.411     0.200
     1.048     7.259     0.200
     1.113     7.379     0.200
     1.117     6.791     0.200
     1.145     8.307     0.200
     1.288     7.827     0.200
     1.290     8.750     0.200
     1.333     9.203     0.200
     1.514     8.218     0.200
     1.493     8.872     0.200
     1.550     9.825     0.200
     1.607     8.207     0.200
     1.714     8.016     0.200
     1.763    10.405     0.200
     1.919    10.112     0.200
     2.009     9.824     0.200
     2.077    10.658     0.200
     2.107    11.410     0.200
     2.188    10.726     0.200
     2.205    11.384     0.200
     2.304     9.092     0.200
     2.321    10.713     0.200
     2.444    11.999     0.200
     2.489    11.610     0.200
     2.580    12.152     0.200
     2.596    11.963     0.200
     2.684    11.605     0.200
     2.781    12.682     0.200
     2.884    11.482     0.200
     3.096    10.702     0.200
     3.125    10.591     0.200
     3.256    14.209     0.200
     3.283    14.650     0.200
     3.324    14.624     0.200
     3.358    11.846     0.200
     3.420    13.910     0.200
     3.474    14.236     0.200
     3.479    14.017     0.200
     3.666    15.220     0.200
     3.908    15.505     0.200
     3.996    15.785     0.200
     4.029    15.522     0.200
     4.249    15.243     0.200
     4.246    15.402     0.200
     4.306    16.078     0.200
     4.305    15.628     0.200
     4.430    16.502     0.200
     4.514    15.093     0.200
     4.549    16.538     0.200
     4.575    17.563     0.200
     4.644    17.168     0.200
     4.658    17.380     0.200
     4.746    17.685     0.200
     4.757    15.651     0.200
     4.778    18.209     0.200
     4.790    17.623     0.200
     4.822    17.782     0.200
     4.854    15.310     0.200
     4.854    15.200     0.200
     5.212    19.000     0.200
     5.238    19.629     0.200
     5.243    19.025     0.200
     5.243    19.177     0.200
     5.479    18.246     0.200
     5.517    19.234     0.200
     5.780    19.563     0.200
     5.796    20.401     0.200
     5.921    19.030     0.200
     6.060    18.929     0.200
     6.205    19.146     0.200
     6.357    19.210     0.200
     6.451    21.159     0.200
     7.296    21.277     0.200
     7.293    21.579     0.200
     7.383    23.979     0.200
     7.788    25.002     0.200
     8.385    24.480     0.200
     8.385    24.910     0.200
     8.385    25.135     0.200
     9.459    25.351     0.200
    10.785    30.808     0.200
    11.264    29.100     0.200
    11.617    31.112     0.200
    11.617    30.147     0.200
    14.852    39.758     0.200
    15.175    37.075     0.200
    15.180    37.331     0.200
    16.017    38.534     0.200
    16.060    38.187     0.200
    16.096    38.048     0.200
    16.151    37.872     0.200
    16.152    38.592     0.200
    16.164    39.132     0.200
    16.234    37.629     0.200
    16.638    38.883     0.200
    16.868    38.397     0.200
    16.937    38.716     0.200
    17.045    38.626     0.200
    17.460    39.071     0.200
    18.304    39.331     0.200
     1.046     6.944     0.200
     1.058     8.174     0.200
     1.064     7.502     0.200
     1.096     6.815     0.200
     1.439     8.676     0.200
     1.653     9.269     0.200
     1.679     9.504     0.200
     1.705     9.860     0.200
     1.787     8.418     0.200
     1.909    10.209     0.200
     1.932     9.617     0.200
     2.033     8.949     0.200
     2.125    10.968     0.200
     2.253    10.435     0.200
     2.266    10.959     0.200
     2.310    11.373     0.200
     2.353     9.957     0.200
     2.375    10.902     0.200
     2.559    11.573     0.200
     2.581    12.040     0.200
     2.641    11.731     0.200
     2.720    10.927     0.200
     2.796    12.420     0.200
     2.943    13.650     0.200
     3.026    13.267     0.200
     5.152    18.797     0.200
     7.462    24.034     0.200
     8.809    25.188     0.200
    11.007    31.262     0.200
    12.026    31.701     0.200
    14.860    38.727     0.200
     1.052     6.894     0.200
     1.086     6.766     0.200
     1.183     7.254     0.200
     1.198     7.171     0.200
     1.209     7.071     0.200
     1.215     7.823     0.200
     1.209     7.177     0.200
     1.222     8.089     0.200
     1.467     4.381     0.200
     1.262     7.674     0.200
     1.259     7.808     0.200
     1.267     8.097     0.200
     1.273     7.306     0.200
     1.267     7.305     0.200
     1.307     7.686     0.200
     1.406     8.437     0.200
     1.407     7.831     0.200
     1.426     8.052     0.200
     1.430    10.186     0.200
     1.443     9.259     0.200
     1.508     7.954     0.200
     1.511     8.518     0.200
     1.533     8.662     0.200
     1.595     8.878     0.200
     1.592     8.351     0.200
     1.593     8.210     0.200
     1.600     9.160     0.200
     1.660     8.385     0.200
     1.667     9.714     0.200
     1.677     8.795     0.200
     1.690     9.134     0.200
     1.740     9.637     0.200
     1.746     9.132     0.200
     1.772     9.132     0.200
     1.813     8.702     0.200
     1.875     9.830     0.200
     1.980     9.419     0.200
     2.004     9.762     0.200
     2.287    11.750     0.200
     2.320    10.058     0.200
     2.363    11.769     0.200
     2.366    11.236     0.200
     2.370    10.405     0.200
     2.441     8.825     0.200
     2.661    10.208     0.200
     2.750    11.086     0.200
     2.776    10.792     0.200
     2.851    11.052     0.200
     3.026    11.742     0.200
     3.085    11.420     0.200
     3.104    11.880     0.200
     3.131    11.644     0.200
     3.325    13.314     0.200
     3.609    13.897     0.200
     3.668    14.056     0.200
     3.722    13.907     0.200
     3.712    14.883     0.200
     3.729    14.354     0.200
     3.830    14.669     0.200
     3.865    13.271     0.200
     4.053    14.682     0.200
     4.097    14.680     0.200
     4.153    13.384     0.200
     4.153    13.535     0.200
     4.189    15.337     0.200
     4.188    17.011     0.200
     4.262    15.333     0.200
     4.434    16.603     0.200
     4.466    14.870     0.200
     4.482    16.254     0.200
     4.683    16.018     0.200
     4.707    17.854     0.200
     4.839    17.675     0.200
     4.882    17.201     0.200
     4.910    15.803     0.200
     5.234    15.327     0.200
     5.268    16.068     0.200
     5.432    17.455     0.200
     5.514    17.036     0.200
     5.542    18.556     0.200
     5.571    20.218     0.200
     5.659    18.924     0.200
     6.200    19.254     0.200
     6.414    21.965     0.200
     6.608    20.317     0.200
     7.053    21.585     0.200
     7.253    21.753     0.200
     7.534    23.992     0.200
     7.782    23.717     0.200
     8.764    23.065     0.200
    10.215    31.339     0.200
    10.561    28.087     0.200
    10.668    32.443     0.200
    10.912    30.063     0.200
    14.141    35.425     0.200
    14.180    36.913     0.200
    14.315    35.595     0.200
    14.414    35.635     0.200
    14.476    35.518     0.200
    14.511    35.479     0.200
    14.516    35.825     0.200
    14.732    36.879     0.200
    14.834    33.941     0.200
    14.912    36.068     0.200
    14.988    36.367     0.200
    15.090    37.263     0.200
    15.343    37.182     0.200
    15.458    37.019     0.200
    15.494    37.592     0.200
    17.074    38.483     0.200
    17.152    38.326     0.200
    17.253    39.418     0.200
    18.168    39.998     0.200
    18.168    39.649     0.200
    18.336    40.290     0.200
    18.336    39.511     0.200
     1.126     7.174     0.200
     1.179     7.157     0.200
     1.194     7.283     0.200
     1.206     7.176     0.200
     1.205     7.161     0.200
     1.213     7.513     0.200
     1.223     7.857     0.200
     1.473     4.515     0.200
     1.258     7.844     0.200
     1.269     8.417     0.200
     1.303     7.597     0.200
     1.301     7.834     0.200
     1.355     7.998     0.200
     1.408     8.336     0.200
     1.404     7.827     0.200
     1.422     7.982     0.200
     1.425    10.315     0.200
     1.437     8.457     0.200
     1.506     8.134     0.200
     1.507     8.223     0.200
     1.541     8.446     0.200
     1.590     8.310     0.200
     1.590     8.461     0.200
     1.601     7.964     0.200
     1.686     9.090     0.200
     1.756     9.188     0.200
     1.818     8.536     0.200
     1.975     9.378     0.200
     2.001     9.674     0.200
     2.429     7.175     0.200
     2.271    10.277     0.200
     2.285    10.243     0.200
     2.360    12.206     0.200
     2.367    10.073     0.200
     2.362    10.821     0.200
     2.445     8.555     0.200
     2.664     9.982     0.200
     2.734    11.218     0.200
     2.746    10.984     0.200
     2.772    10.709     0.200
     2.943    13.729     0.200
     3.023    13.393     0.200
     3.081    12.283     0.200
     3.099    11.879     0.200
     3.127    12.126     0.200
     3.309    13.465     0.200
     3.322    13.970     0.200
     3.646    14.702     0.200
     3.666    14.011     0.200
     3.720    14.223     0.200
     3.708    14.161     0.200
     3.724    15.924     0.200
     3.770    16.254     0.200
     3.827    14.487     0.200
     3.865    14.392     0.200
     3.896    13.610     0.200
     4.047    14.528     0.200
     4.093    13.762     0.200
     4.154    13.024     0.200
     4.154    13.803     0.200
     4.186    15.896     0.200
     4.213    15.804     0.200
     4.258    15.884     0.200
     4.461    15.138     0.200
     4.477    16.457     0.200
     4.702    16.467     0.200
     4.834    17.426     0.200
     4.907    16.720     0.200
     5.268    17.186     0.200
     5.500    17.669     0.200
     5.515    17.671     0.200
     5.538    18.430     0.200
     5.567    20.536     0.200
     5.653    18.266     0.200
     5.654    19.195     0.200
     6.609    19.586     0.200
     6.731    20.532     0.200
     7.050    21.874     0.200
     7.323    21.792     0.200
     7.528    23.251     0.200
     7.781    22.993     0.200
     8.765    24.430     0.200
     8.975    25.508     0.200
    10.178    27.702     0.200
    10.381    27.962     0.200
    10.663    31.994     0.200
    10.914    29.336     0.200
    14.137    35.151     0.200
    14.557    36.428     0.200
    15.085    36.873     0.200
    15.085    37.363     0.200
    15.168    37.431     0.200
    15.344    37.123     0.200
    15.351    37.123     0.200
    15.457    37.767     0.200
    15.477    37.621     0.200
    15.559    37.601     0.200
    15.737    38.562     0.200
     0.796     6.219     0.200
     0.808     5.633     0.200
     0.835     7.047     0.200
     0.844     5.748     0.200
     0.844     5.869     0.200
     0.863     5.800     0.200
     0.889     5.929     0.200
     0.889     5.970     0.200
     0.883     6.314     0.200
     0.904     6.224     0.200
     0.917     6.034     0.200
     0.908     6.193     0.200
     1.037     7.216     0.200
     1.152     6.820     0.200
     1.453     4.140     0.200
     1.227     7.206     0.200
     1.228     7.163     0.200
     1.257     7.398     0.200
     1.566     8.232     0.200
     1.796     8.579     0.200
     2.021     9.447     0.200
     2.060    10.017     0.200
     2.283    10.787     0.200
     2.294    11.017     0.200
     2.374    10.979     0.200
     2.389    10.567     0.200
     2.613    11.032     0.200
     2.645     9.357     0.200
     2.768    11.721     0.200
     2.795    10.764     0.200
     3.331    13.406     0.200
     3.655    15.079     0.200
     3.858    14.243     0.200
     4.140    13.031     0.200
     4.190    14.936     0.200
     5.260    17.275     0.200
     5.679    18.772     0.200
     5.679    18.659     0.200
     6.598    19.550     0.200
     7.236    22.295     0.200
     7.550    26.587     0.200
     7.777    24.116     0.200
     7.777    23.516     0.200
    10.548    28.568     0.200
    10.679    33.083     0.200
    10.898    29.094     0.200
    14.579    35.932     0.200
     0.847     5.649     0.200
     0.977     6.198     0.200
     1.204     6.919     0.200
     1.606     7.841     0.200
     1.718     8.071     0.200
     1.712    10.108     0.200
     1.841     9.329     0.200
     2.014     9.047     0.200
     2.044     8.822     0.200
     2.350    10.024     0.200
     2.391    10.419     0.200
     2.661     9.129     0.200
     2.768    10.991     0.200
     2.812    10.826     0.200
     2.890    10.986     0.200
     3.155    11.554     0.200
     3.390    13.131     0.200
     3.726    13.615     0.200
     3.900    14.903     0.200
     3.910    13.146     0.200
     4.174    13.560     0.200
     4.292    15.809     0.200
     4.937    16.808     0.200
     5.714    18.071     0.200
     7.289    22.139     0.200
     7.608    23.070     0.200
     7.835    23.115     0.200
    10.580    28.306     0.200
    10.748    30.737     0.200
    10.748    31.723     0.200
    10.923    28.741     0.200
    10.924    28.511     0.200
    10.924    31.921     0.200
    15.160    39.754     0.200
    15.160    38.037     0.200
     1.300     8.722     0.200
     1.319     7.349     0.200
     1.422     8.577     0.200
     1.482     8.560     0.200
     1.537     7.112     0.200
     1.759     9.556     0.200
     1.779     8.710     0.200
     1.824     9.157     0.200
     1.816     7.246     0.200
     1.835     9.083     0.200
     1.978     9.081     0.200
     2.030     8.912     0.200
     2.194     9.891     0.200
     2.202     8.961     0.200
     2.215     8.491     0.200
     2.284     9.296     0.200
     2.323    10.216     0.200
     2.362    10.968     0.200
     2.394    12.265     0.200
     2.516    12.078     0.200
     2.597    12.598     0.200
     2.718    11.770     0.200
     2.906    12.521     0.200
     3.113    13.034     0.200
     3.126    13.370     0.200
     3.270    12.610     0.200
     3.367    13.910     0.200
     3.394    13.756     0.200
     3.428    12.534     0.200
     3.423    13.089     0.200
     3.527    12.872     0.200
     3.570    14.085     0.200
     3.574    12.861     0.200
     3.925    14.137     0.200
     3.986    14.014     0.200
     3.988    13.682     0.200
     4.001    13.844     0.200
     4.087    14.434     0.200
     4.180    15.057     0.200
     4.292    15.458     0.200
     4.335    15.491     0.200
     4.395    15.265     0.200
     4.626    15.966     0.200
     4.664    16.239     0.200
     4.756    13.669     0.200
     4.766    13.947     0.200
     4.836    17.384     0.200
     4.922    17.087     0.200
     5.036    16.848     0.200
     5.190    17.119     0.200
     5.265    16.996     0.200
     5.305    17.605     0.200
     5.317    18.441     0.200
     5.631    18.114     0.200
     5.718    19.574     0.200
     5.893    18.994     0.200
     6.128    18.717     0.200
     6.120    17.920     0.200
     6.201    18.864     0.200
     6.579    21.019     0.200
     7.089    20.590     0.200
     7.206    21.899     0.200
     7.367    21.779     0.200
     7.393    22.892     0.200
     7.512    22.824     0.200
     7.632    22.269     0.200
     7.731    22.188     0.200
     7.753    22.347     0.200
     7.767    21.547     0.200
     7.787    22.414     0.200
     7.794    22.552     0.200
     7.897    22.868     0.200
     7.884    24.165     0.200
     7.926    23.429     0.200
     8.060    23.701     0.200
     8.314    23.717     0.200
     8.871    26.308     0.200
     9.372    25.243     0.200
     9.983    26.979     0.200
    10.026    27.077     0.200
    10.354    27.138     0.200
    10.787    27.591     0.200
     1.427     7.818     0.200
     1.512     7.204     0.200
     1.700     7.717     0.200
     1.722     8.225     0.200
     1.797     8.896     0.200
     1.808     9.253     0.200
     1.980     9.190     0.200
     2.243    10.889     0.200
     2.516     9.513     0.200
     2.537    13.193     0.200
     2.559    10.677     0.200
     2.574    13.063     0.200
     3.165    12.302     0.200
     3.570    14.536     0.200
     3.730    14.918     0.200
     3.811    14.930     0.200
     3.951    15.018     0.200
     4.071    13.150     0.200
     4.394    16.656     0.200
     4.481    16.133     0.200
     4.642    16.675     0.200
     4.719    16.230     0.200
     4.832    17.165     0.200
     4.928    16.946     0.200
     5.264    17.065     0.200
     5.458    16.774     0.200
     5.916    18.222     0.200
     6.557    19.360     0.200
     7.793    24.024     0.200
     7.817    22.837     0.200
     8.695    23.221     0.200
    10.798    28.449     0.200
    10.889    32.505     0.200
     1.262     9.655     0.200
     1.256     7.061     0.200
     1.427     7.388     0.200
     1.436     7.286     0.200
     1.446    10.740     0.200
     1.454     7.243     0.200
     1.510     6.972     0.200
     1.527     9.690     0.200
     1.528     8.682     0.200
     1.561     9.502     0.200
     1.543     7.667     0.200
     1.657     9.345     0.200
     1.703    10.213     0.200
     1.691    11.723     0.200
     1.700     8.170     0.200
     1.723     7.963     0.200
     1.792     8.728     0.200
     1.793     8.601     0.200
     1.806     8.746     0.200
     1.815    12.930     0.200
     1.919     6.670     0.200
     1.918     9.860     0.200
     1.976     9.053     0.200
     2.184     9.540     0.200
     2.244     8.130     0.200
     2.241     9.326     0.200
     2.377    13.977     0.200
     2.515     8.788     0.200
     2.519    10.910     0.200
     2.524     9.800     0.200
     2.534    10.086     0.200
     2.555    10.604     0.200
     2.573    11.383     0.200
     2.572    11.009     0.200
     2.573    10.755     0.200
     2.948    12.038     0.200
     2.982    12.242     0.200
     3.000    11.514     0.200
     3.009    12.324     0.200
     3.086    11.837     0.200
     3.125    11.932     0.200
     3.161    11.975     0.200
     3.341    12.946     0.200
     3.476    13.574     0.200
     3.567    13.326     0.200
     3.636    13.560     0.200
     3.726    13.212     0.200
     3.807    13.596     0.200
     3.869    13.768     0.200
     3.914    14.329     0.200
     3.947    13.635     0.200
     3.941    13.553     0.200
     3.990    13.772     0.200
     4.069    12.557     0.200
     4.063    12.857     0.200
     4.111    13.216     0.200
     4.274    13.645     0.200
     4.390    15.521     0.200
     4.471    15.210     0.200
     4.477    15.590     0.200
     4.542    14.456     0.200
     4.567    16.181     0.200
     4.638    15.948     0.200
     4.693    15.488     0.200
     4.697    17.008     0.200
     4.715    16.001     0.200
     4.828    17.030     0.200
     4.828    16.609     0.200
     4.849    16.399     0.200
     4.925    16.375     0.200
     5.058    17.248     0.200
     5.097    16.334     0.200
     5.159    16.257     0.200
     5.213    18.070     0.200
     5.261    16.470     0.200
     5.291    17.164     0.200
     5.298    16.527     0.200
     5.416    17.847     0.200
     5.424    18.647     0.200
     5.455    16.633     0.200
     5.481    18.305     0.200
     5.540    16.555     0.200
     5.633    18.408     0.200
     5.745    18.926     0.200
     5.770    18.728     0.200
     5.778    20.483     0.200
     5.794    21.346     0.200
     5.817    19.987     0.200
     5.873    20.690     0.200
     5.915    22.696     0.200
     5.915    20.896     0.200
     6.027    20.689     0.200
     6.034    20.006     0.200
     6.341    20.641     0.200
     6.431    21.578     0.200
     6.435    20.603     0.200
     6.554    18.950     0.200
     6.645    20.409     0.200
     6.649    20.444     0.200
     6.801    20.515     0.200
     6.937    22.666     0.200
     6.985    21.286     0.200
     7.068    21.740     0.200
     7.142    22.046     0.200
     7.243    21.057     0.200
     7.246    22.990     0.200
     7.301    22.194     0.200
     7.340    25.194     0.200
     7.376    22.666     0.200
     7.435    22.761     0.200
     7.535    23.279     0.200
     7.563    24.529     0.200
     7.585    23.943     0.200
     7.589    25.262     0.200
     7.594    24.272     0.200
     7.603    25.469     0.200
     7.620    24.212     0.200
     7.645    23.915     0.200
     7.665    23.360     0.200
     7.673    22.909     0.200
     7.690    24.473     0.200
     7.790    23.613     0.200
     7.814    23.285     0.200
     7.814    24.019     0.200
     7.924    25.067     0.200
     8.342    25.737     0.200
     8.619    26.098     0.200
     8.715    25.909     0.200
    10.797    28.506     0.200
    10.885    33.000     0.200
    11.767    30.598     0.200
     1.700    10.841     0.200
     1.811    11.898     0.200
     1.921    11.767     0.200
     3.002    13.762     0.200
     3.735    14.920     0.200
     3.817    15.286     0.200
     3.923    15.439     0.200
     3.957    16.163     0.200
     4.400    16.402     0.200
     4.648    17.324     0.200
     4.724    17.841     0.200
     4.838    17.632     0.200
     5.268    17.065     0.200
    10.801    28.059     0.200
    10.894    33.085     0.200
     1.515     8.008     0.200
     1.701    10.818     0.200
     1.721     9.905     0.200
     1.804    10.586     0.200
     1.922    11.279     0.200
     2.244     8.285     0.200
     2.436    12.209     0.200
     2.518    10.192     0.200
     2.517    10.013     0.200
     2.578    10.940     0.200
    10.800    30.250     0.200
    10.895    30.917     0.200
     1.433     7.827     0.200
     1.509     7.330     0.200
     1.552     9.158     0.200
     1.705    11.809     0.200
     1.695    10.246     0.200
     1.726     8.199     0.200
     1.813    11.043     0.200
     1.984     9.306     0.200
     2.137     8.950     0.200
     2.239     8.358     0.200
     2.376     9.409     0.200
     2.512     9.064     0.200
     3.921    14.790     0.200
     3.953    14.068     0.200
     5.786    19.782     0.200
     7.817    23.336     0.200
    10.795    31.827     0.200
     1.430     7.841     0.200
     1.508     7.295     0.200
     1.524     9.322     0.200
     1.703    11.029     0.200
     1.794    10.630     0.200
     2.512     9.047     0.200
     2.673    14.527     0.200
     2.940    13.041     0.200
    10.794    29.083     0.200
    10.886    29.591     0.200
     1.332     7.472     0.200
     1.343     8.092     0.200
     1.365     7.814     0.200
     1.429     7.121     0.200
     1.455     6.589     0.200
     1.653     8.866     0.200
     1.690     8.432     0.200
     1.834     9.078     0.200
     1.898     7.984     0.200
     2.004     8.823     0.200
     2.079     8.857     0.200
     2.108     8.960     0.200
     2.149    11.366     0.200
     2.251     9.657     0.200
     2.362     9.593     0.200
     2.475    13.342     0.200
     2.612    10.239     0.200
     2.732    10.508     0.200
     2.901     9.720     0.200
     4.458    13.472     0.200
     4.562    15.930     0.200
     5.703    19.906     0.200
     8.153    24.008     0.200
    10.190    30.696     0.200
    10.967    32.831     0.200
    11.186    29.990     0.200
    14.924    36.905     0.200
    15.241    37.947     0.200
    15.516    38.078     0.200
    15.988    37.516     0.200
    16.797    39.851     0.200
    15.698    37.542     0.200
     1.379     8.076     0.200
     1.407     7.956     0.200
     1.447     8.970     0.200
     1.491     9.476     0.200
     1.547     8.866     0.200
     1.578     9.183     0.200
     1.658    10.020     0.200
     1.730     9.247     0.200
     2.010     9.233     0.200
     1.994    10.663     0.200
     2.007    10.438     0.200
     2.233    10.643     0.200
     2.231    11.283     0.200
     2.308     9.443     0.200
     2.317    10.933     0.200
     2.408    11.469     0.200
     2.643    11.684     0.200
     2.726    12.809     0.200
     2.875    11.373     0.200
    15.276    40.179     0.200
    15.311    38.747     0.200
    15.402    39.174     0.200
    15.774    39.014     0.200
    15.955    38.933     0.200
    16.256    38.747     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     4.156    28.966     0.200
     4.266    31.372     0.200
     4.445    30.410     0.200
     4.873    34.626     0.200
     5.346    37.157     0.200
     5.550    37.735     0.200
     5.725    41.284     0.200
     6.761    50.086     0.200
     6.802    49.138     0.200
     6.967    50.063     0.200
     6.997    49.327     0.200
     7.042    50.034     0.200
     7.090    48.950     0.200
     7.587    55.913     0.200
     8.044    58.000     0.200
     9.911    68.890     0.200
     2.148    12.837     0.200
     3.074    22.406     0.200
     3.747    26.378     0.200
     3.972    27.160     0.200
     4.278    29.164     0.200
     4.308    29.172     0.200
     4.342    29.725     0.200
     4.511    31.013     0.200
     4.809    34.251     0.200
     5.167    35.735     0.200
     5.664    40.841     0.200
     6.745    47.636     0.200
     6.872    49.495     0.200
     6.917    51.966     0.200
     7.113    48.758     0.200
     7.339    54.352     0.200
     7.483    55.503     0.200
     7.510    52.230     0.200
     7.633    56.432     0.200
     7.959    55.092     0.200
     8.002    57.978     0.200
     8.129    54.998     0.200
     8.350    59.215     0.200
     3.232    21.775     0.200
     4.700    31.316     0.200
     5.040    33.619     0.200
     6.243    43.190     0.200
     7.534    54.308     0.200
     7.646    55.159     0.200
     7.646    54.935     0.200
     7.756    54.458     0.200
     7.892    54.678     0.200
     8.180    57.271     0.200
     2.769    19.391     0.200
     4.983    34.526     0.200
     5.195    35.406     0.200
     6.678    47.270     0.200
     2.217    14.156     0.200
     2.771    18.114     0.200
     4.811    33.240     0.200
     4.902    35.544     0.200
     4.981    34.230     0.200
     5.586    39.193     0.200
     6.131    41.605     0.200
     7.508    50.323     0.200
     5.052    34.212     0.200
     2.147    14.276     0.200
     2.257    14.493     0.200
     2.342    13.939     0.200
     7.555    52.184     0.200
     7.652    55.239     0.200
     7.935    58.589     0.200
     3.341    25.708     0.200
     4.237    31.204     0.200
     4.290    31.339     0.200
     4.668    33.898     0.200
     4.859    34.363     0.200
     5.528    38.692     0.200
     5.933    44.166     0.200
     5.955    44.268     0.200
     7.874    55.087     0.200
     3.998    27.964     0.200
     4.562    32.856     0.200
     4.598    31.300     0.200
     4.588    31.291     0.200
     4.744    32.225     0.200
     4.959    36.052     0.200
     5.912    39.796     0.200
     6.041    40.796     0.200
     6.055    43.265     0.200
     6.496    44.211     0.200
     7.025    49.801     0.200
     7.027    49.327     0.200
     7.122    50.638     0.200
     7.268    49.549     0.200
     2.087    13.045     0.200
     2.088    13.369     0.200
     2.324    13.788     0.200
     3.184    21.955     0.200
     3.640    25.295     0.200
     4.837    36.336     0.200
     5.117    34.200     0.200
     5.165    39.862     0.200
     5.345    37.757     0.200
     5.380    37.356     0.200
     5.894    41.720     0.200
     6.004    44.114     0.200
     6.039    39.815     0.200
     6.449    47.798     0.200
     8.159    57.220     0.200
     3.190    24.263     0.200
     4.750    35.115     0.200
     4.837    36.294     0.200
     5.169    37.900     0.200
     6.010    45.308     0.200
     7.793    53.625     0.200
     2.829    18.891     0.200
     3.271    22.891     0.200
     3.362    21.817     0.200
     5.252    36.505     0.200
     5.644    37.868     0.200
     5.656    40.814     0.200
     6.133    42.061     0.200
     6.156    42.014     0.200
     7.234    49.639     0.200
     7.378    52.075     0.200
     2.085    12.920     0.200
     8.113    53.553     0.200
     2.723    18.946     0.200
     3.049    20.076     0.200
     3.666    24.573     0.200
     4.349    32.767     0.200
     4.445    30.218     0.200
     4.407    30.056     0.200
     5.035    35.679     0.200
     5.651    37.580     0.200
     7.227    49.483     0.200
     5.241    39.110     0.200
     7.227    52.766     0.200
     2.093    13.129     0.200
     2.332    14.609     0.200
     2.917    19.257     0.200
     5.361    37.013     0.200
     5.615    39.908     0.200
     5.646    39.233     0.200
     6.042    41.423     0.200
     7.703    54.984     0.200
     2.350    15.062     0.200
     4.432    29.911     0.200
     2.276    15.353     0.200
     2.257    14.786     0.200
     7.300    55.106     0.200
     6.946    51.959     0.200
     7.326    54.851     0.200
     7.340    54.913     0.200
     7.475    56.762     0.200
     2.004    12.739     0.200
     2.036    13.441     0.200
     2.076    13.822     0.200
     2.150    14.523     0.200
     2.485    17.875     0.200
     2.499    16.306     0.200
     3.950    28.922     0.200
     3.977    29.505     0.200
     4.312    31.198     0.200
     5.279    37.152     0.200
     5.827    41.652     0.200
     2.325    14.656     0.200
     2.398    14.599     0.200
     2.467    15.549     0.200
     3.069    21.128     0.200
     5.833    42.120     0.200
     2.382    14.267     0.200
     2.417    14.701     0.200
     2.921    20.408     0.200
     3.006    21.913     0.200
     3.066    19.543     0.200
     3.422    24.647     0.200
     3.533    25.802     0.200
     3.561    26.002     0.200
     3.590    26.276     0.200
     3.731    27.418     0.200
     3.948    28.757     0.200
     3.981    29.542     0.200
     3.987    29.664     0.200
     4.039    30.792     0.200
     4.222    31.061     0.200
     4.265    30.374     0.200
     4.570    34.248     0.200
     5.267    36.615     0.200
     5.306    38.430     0.200
     5.310    39.354     0.200
     7.802    53.902     0.200
     7.806    53.065     0.200
     5.030    37.810     0.200
     2.382    14.257     0.200
     5.854    42.328     0.200
     7.857    54.944     0.200
     3.533    22.087     0.200
     7.060    53.909     0.200
     7.512    56.402     0.200
     7.805    54.222     0.200
     2.306    14.753     0.200
     3.337    21.496     0.200
     5.813    41.596     0.200
     5.813    41.596     0.200
     7.340    50.128     0.200
     7.787    54.069     0.200
     7.787    53.248     0.200
     2.397    15.135     0.200
     2.463    15.277     0.200
     3.679    26.858     0.200
     4.324    31.768     0.200
     5.827    44.942     0.200
     5.868    44.650     0.200
     6.682    51.502     0.200
     6.905    55.259     0.200
     7.105    54.235     0.200
     7.376    55.403     0.200
     7.718    58.060     0.200
     7.849    55.516     0.200
     8.108    59.532     0.200
     8.307    60.391     0.200
     2.390    15.135     0.200
     2.470    15.630     0.200
     2.484    16.903     0.200
     2.556    15.874     0.200
     2.617    16.463     0.200
     5.824    40.716     0.200
     7.789    54.333     0.200
     3.645    25.991     0.200
     4.080    28.232     0.200
     6.109    42.686     0.200
     6.357    43.252     0.200
     7.116    50.818     0.200
     7.472    53.896     0.200
     7.500    56.155     0.200
     2.362    14.275     0.200
     2.380    14.390     0.200
     2.925    20.773     0.200
     3.051    22.505     0.200
     7.828    53.641     0.200
     2.070    13.241     0.200
     4.144    29.006     0.200
     4.442    31.849     0.200
     4.461    32.022     0.200
     4.493    31.658     0.200
     4.896    33.431     0.200
     5.147    36.578     0.200
     5.171    36.380     0.200
     5.318    37.604     0.200
     5.376    40.305     0.200
     5.553    41.687     0.200
     5.941    44.528     0.200
     7.210    51.552     0.200
     7.220    53.705     0.200
     7.235    52.974     0.200
     7.256    49.873     0.200
     2.057    13.719     0.200
     2.058    13.462     0.200
     2.142    13.624     0.200
     2.372    14.888     0.200
     3.015    18.727     0.200
     3.219    21.703     0.200
     3.498    24.142     0.200
     5.484    39.348     0.200
     5.671    38.019     0.200
     5.858    43.047     0.200
     6.127    46.728     0.200
     7.617    53.713     0.200
     7.696    54.872     0.200
     7.775    54.492     0.200
     7.937    59.193     0.200
     7.941    58.903     0.200
     7.946    57.250     0.200
     7.950    57.416     0.200
     7.958    56.977     0.200
     7.983    58.386     0.200
     7.989    59.602     0.200
     8.001    59.021     0.200
     8.016    58.001     0.200
     8.028    58.331     0.200
     8.056    59.586     0.200
     8.088    57.091     0.200
     8.109    58.496     0.200
     2.184    13.733     0.200
     2.546    18.167     0.200
     2.979    21.145     0.200
     3.566    25.218     0.200
     5.546    37.674     0.200
     2.664    17.887     0.200
     2.733    19.505     0.200
     3.405    25.704     0.200
     2.241    15.073     0.200
     2.457    17.127     0.200
     2.647    19.948     0.200
     2.328    14.812     0.200
     2.460    15.513     0.200
     2.548    16.154     0.200
     2.704    19.637     0.200
     2.800    20.738     0.200
     3.373    25.001     0.200
     3.416    25.178     0.200
     3.770    27.700     0.200
     3.834    28.301     0.200
     5.098    37.050     0.200
     5.241    36.576     0.200
     7.303    52.657     0.200
     2.023    12.619     0.200
     2.114    14.221     0.200
     2.311    13.958     0.200
     2.430    14.784     0.200
     2.686    16.372     0.200
     2.755    19.692     0.200
     3.291    24.370     0.200
     3.425    25.619     0.200
     3.450    25.602     0.200
     3.632    26.676     0.200
     3.784    27.363     0.200
     3.822    27.753     0.200
     3.875    28.287     0.200
     4.164    30.123     0.200
     4.205    30.077     0.200
     4.400    31.882     0.200
     2.331    14.590     0.200
     2.649    19.382     0.200
     4.849    33.217     0.200
     6.829    47.335     0.200
     7.974    53.343     0.200
     2.052    13.000     0.200
     2.333    14.727     0.200
     2.333    15.075     0.200
     2.604    17.713     0.200
     2.656    18.000     0.200
     4.434    31.114     0.200
     4.860    33.437     0.200
     6.842    48.428     0.200
     2.020    13.026     0.200
     2.325    14.182     0.200
     2.483    15.380     0.200
     2.075    12.912     0.200
     2.211    13.625     0.200
     2.271    13.601     0.200
     5.083    34.482     0.200
     4.596    31.298     0.200
     6.894    47.263     0.200
     8.679    57.150     0.200
     5.197    35.330     0.200
     8.413    55.792     0.200
     2.519    15.592     0.200
     2.674    17.281     0.200
     2.815    18.234     0.200
     3.019    20.094     0.200
     2.242    13.647     0.200
     2.262    13.686     0.200
     2.499    15.381     0.200
     3.604    26.131     0.200
     3.961    28.648     0.200
     5.293    37.441     0.200
     2.176    14.784     0.200
     2.805    17.375     0.200
     2.246    14.125     0.200
     2.364    14.558     0.200
     2.382    14.079     0.200
     2.630    18.823     0.200
     2.704    19.692     0.200
     2.808    20.568     0.200
     2.260    13.825     0.200
     2.373    14.573     0.200
     2.397    14.583     0.200
     2.816    20.523     0.200
     3.285    24.194     0.200
     3.510    25.254     0.200
     2.243    13.880     0.200
     2.243    13.843     0.200
     3.173    22.745     0.200
     3.370    23.626     0.200
     3.630    26.111     0.200
     2.281    14.292     0.200
     2.763    19.589     0.200
     3.433    25.052     0.200
     3.434    25.176     0.200
     3.790    27.749     0.200
     4.068    29.675     0.200
     4.140    29.737     0.200
     2.433    14.823     0.200
     2.533    17.649     0.200
     2.968    20.354     0.200
     3.601    25.627     0.200
     3.996    28.648     0.200
     4.025    29.431     0.200
     4.353    31.701     0.200
     5.353    39.920     0.200
     2.401    14.964     0.200
     2.430    15.067     0.200
     2.531    18.855     0.200
     2.638    16.934     0.200
     2.770    17.335     0.200
     3.454    26.944     0.200
     4.014    30.739     0.200
     4.023    30.779     0.200
     5.351    39.798     0.200
    10.851    72.717     0.200
     2.153    13.232     0.200
     2.474    15.554     0.200
     2.776    20.532     0.200
     3.273    24.009     0.200
     3.405    25.236     0.200
     3.414    25.029     0.200
     3.807    27.814     0.200
     2.978    21.389     0.200
     5.929    41.769     0.200
     2.186    13.573     0.200
     2.104    13.638     0.200
     2.562    16.746     0.200
     3.746    25.904     0.200
     2.356    13.881     0.200
     2.083    12.965     0.200
     2.499    16.920     0.200
     2.796    18.698     0.200
     2.848    19.702     0.200
     3.170    22.712     0.200
     3.441    24.566     0.200
     3.485    24.794     0.200
     2.102    13.434     0.200
     2.575    19.508     0.200
     2.710    18.060     0.200
     2.561    16.391     0.200
     2.728    17.501     0.200
     2.739    18.474     0.200
     7.812    53.342     0.200
     7.479    51.156     0.200
     2.537    17.411     0.200
     2.889    21.317     0.200
     2.227    14.721     0.200
     2.680    18.450     0.200
     2.857    19.462     0.200
     3.321    21.196     0.200
     3.610    25.437     0.200
     4.227    31.566     0.200
     4.244    29.919     0.200
     4.320    29.568     0.200
     7.848    51.916     0.200
     2.628    16.783     0.200
     7.462    52.384     0.200
     5.801    40.631     0.200
     7.688    56.615     0.200
     7.829    55.061     0.200
    10.810    76.459     0.200
     7.681    52.431     0.200
     7.825    55.241     0.200
    10.802    72.779     0.200
     7.679    55.488     0.200
     5.781    39.911     0.200
     7.671    54.336     0.200
     7.832    55.596     0.200
    10.798    77.520     0.200
     2.361    13.976     0.200
     5.802    40.295     0.200
     7.689    55.605     0.200
     7.827    56.156     0.200
    10.810    74.255     0.200
     5.781    39.998     0.200
     7.669    55.259     0.200
     7.827    52.908     0.200
     2.359    14.981     0.200
     5.787    40.707     0.200
     7.668    53.035     0.200
     7.813    54.966     0.200
     2.428    14.968     0.200
     7.672    53.511     0.200
     7.815    52.960     0.200
     5.821    39.482     0.200
     7.709    55.241     0.200
     7.833    56.667     0.200
     3.292    23.652     0.200
     3.489    24.801     0.200
     3.556    25.561     0.200
     3.741    26.892     0.200
     3.777    27.916     0.200
     5.662    39.262     0.200
     5.766    38.363     0.200
     6.142    41.935     0.200
     6.179    41.750     0.200
    10.667    77.334     0.200
     2.749    20.611     0.200
     2.768    19.122     0.200
     3.096    23.643     0.200
     5.675    39.557     0.200
     7.558    53.246     0.200
     7.806    54.470     0.200
     7.439    53.056     0.200
     8.828    60.146     0.200
     2.761    18.064     0.200
     2.751    17.335     0.200
     2.954    19.654     0.200
     2.966    26.092     0.200
     3.304    23.564     0.200
     3.501    25.466     0.200
     3.520    26.616     0.200
     3.523    25.513     0.200
     3.540    25.814     0.200
     3.546    25.244     0.200
     3.551    25.645     0.200
     3.569    25.817     0.200
     3.692    26.610     0.200
     3.754    26.612     0.200
     3.765    27.517     0.200
     4.235    31.140     0.200
     5.670    38.288     0.200
     2.286    14.773     0.200
     2.305    13.740     0.200
     2.751    18.274     0.200
     2.763    18.373     0.200
     2.858    18.506     0.200
     2.960    19.467     0.200
     5.671    39.066     0.200
     5.700    39.095     0.200
     7.596    56.015     0.200
     7.840    55.238     0.200
     7.586    53.345     0.200
     5.695    40.346     0.200
     7.583    53.828     0.200
     7.819    55.242     0.200
     7.585    55.007     0.200
     7.823    53.327     0.200
     5.701    39.334     0.200
     5.677    39.699     0.200
     7.571    53.727     0.200
     7.832    54.690     0.200
     2.093    13.090     0.200
     5.634    38.643     0.200
     7.529    52.820     0.200
     7.831    54.382     0.200
     5.632    39.069     0.200
     2.250    13.626     0.200
     2.343    14.234     0.200
     2.333    14.148     0.200
     5.633    39.491     0.200
     7.532    54.156     0.200
     7.839    54.559     0.200
     5.634    38.316     0.200
     7.533    54.278     0.200
     7.840    55.860     0.200
     5.670    38.335     0.200
     7.674    53.814     0.200
     8.108    58.953     0.200
     2.803    19.012     0.200
     2.877    20.225     0.200
     5.703    39.466     0.200
     2.905    17.770     0.200
     7.311    50.051     0.200
    10.734    73.950     0.200
     5.200    35.833     0.200
     7.510    52.520     0.200
     5.243    35.552     0.200
     7.383    52.382     0.200
     7.534    52.992     0.200
     7.782    52.393     0.200
    10.668    75.743     0.200
     5.654    38.096     0.200
     7.528    53.327     0.200
     7.781    53.350     0.200
     2.768    18.111     0.200
     5.679    39.682     0.200
     5.714    38.590     0.200
     7.608    52.855     0.200
     7.835    53.248     0.200
     5.916    40.621     0.200
     7.793    56.801     0.200
     7.817    53.489     0.200
     7.797    55.006     0.200
     7.822    53.918     0.200
    10.894    75.890     0.200
     7.798    53.908     0.200
     7.822    52.687     0.200
     2.577    17.031     0.200
     7.817    51.679     0.200
     7.813    52.453     0.200
     5.703    37.957     0.200
     7.724    54.702     0.200
     8.153    58.508     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.285     2.849     0.200
     0.343     2.644     0.200
     0.343     2.967     0.200
     0.517     3.753     0.200
     0.806     4.767     0.200
     0.878     5.843     0.200
     0.883     6.103     0.200
     0.890     6.506     0.200
     1.059     5.935     0.200
     1.288     6.701     0.200
     5.346    27.838     0.200
     5.725    28.104     0.200
     6.967    33.273     0.200
     0.218     1.922     0.200
     0.331     2.577     0.200
     0.663     5.053     0.200
     0.711     5.310     0.200
     0.866     6.231     0.200
     0.928     6.587     0.200
     0.982     6.026     0.200
     0.964     6.998     0.200
     1.020     7.111     0.200
     1.412     7.244     0.200
     1.406     7.477     0.200
     1.581    11.352     0.200
     1.745    10.606     0.200
     1.805    12.778     0.200
     1.807    11.289     0.200
     1.904    13.133     0.200
     1.900    11.296     0.200
     1.980    13.399     0.200
     2.387    14.130     0.200
     2.425    14.047     0.200
     0.239     2.243     0.200
     0.277     2.286     0.200
     0.386     3.479     0.200
     0.458     3.571     0.200
     0.374     3.418     0.200
     0.454     3.567     0.200
     0.479     3.633     0.200
     0.509     3.956     0.200
     0.543     4.045     0.200
     0.598     4.642     0.200
     0.598     4.471     0.200
     0.692     5.138     0.200
     0.743     5.381     0.200
     0.670     4.895     0.200
     0.670     4.776     0.200
     0.694     5.136     0.200
     0.904     6.353     0.200
     0.945     6.581     0.200
     1.039     5.945     0.200
     1.065     7.067     0.200
     1.293     7.272     0.200
     1.374     6.550     0.200
     1.435     7.291     0.200
     1.999    12.490     0.200
     4.947    26.123     0.200
     0.167     1.699     0.200
     0.551     4.138     0.200
     0.635     4.773     0.200
     0.674     4.864     0.200
     0.743     5.084     0.200
     0.783     5.336     0.200
     0.775     5.277     0.200
     0.865     5.867     0.200
     0.902     6.594     0.200
     1.422     7.124     0.200
     1.976    12.406     0.200
     0.167     1.851     0.200
     0.167     1.491     0.200
     0.551     4.046     0.200
     0.673     5.009     0.200
     0.740     5.283     0.200
     0.639     4.794     0.200
     0.783     5.240     0.200
     0.778     5.494     0.200
     0.904     6.629     0.200
     1.418     7.192     0.200
     1.418     6.926     0.200
     1.497    10.270     0.200
     0.292     2.749     0.200
     0.356     2.850     0.200
     0.645     4.272     0.200
     0.714     5.282     0.200
     0.837     5.433     0.200
     0.759     5.375     0.200
     0.876     5.990     0.200
     0.987     6.411     0.200
     1.052     6.210     0.200
     1.210     7.124     0.200
     1.188     6.690     0.200
     1.225     7.870     0.200
     1.299     7.176     0.200
     1.285     7.655     0.200
     0.289     2.969     0.200
     0.362     2.855     0.200
     0.639     4.616     0.200
     0.712     5.336     0.200
     0.763     5.595     0.200
     0.833     5.001     0.200
     0.883     6.042     0.200
     0.987     6.322     0.200
     1.054     6.278     0.200
     1.194     6.727     0.200
     1.497     8.456     0.200
     0.120     1.653     0.200
     0.382     2.940     0.200
     0.393     3.503     0.200
     0.411     3.192     0.200
     0.475     3.556     0.200
     0.532     3.895     0.200
     0.675     4.250     0.200
     0.658     4.849     0.200
     0.711     5.206     0.200
     0.727     4.939     0.200
     0.738     4.522     0.200
     0.704     5.490     0.200
     0.772     5.001     0.200
     0.821     5.057     0.200
     0.821     4.588     0.200
     0.980     5.549     0.200
     0.971     6.471     0.200
     1.008     6.257     0.200
     1.108     6.439     0.200
     1.812     9.173     0.200
     4.355    21.901     0.200
     0.353     3.174     0.200
     0.446     3.815     0.200
     0.432     3.573     0.200
     0.420     3.103     0.200
     0.450     3.765     0.200
     0.504     4.142     0.200
     0.645     4.498     0.200
     0.664     4.278     0.200
     0.719     4.634     0.200
     0.703     5.175     0.200
     0.698     5.524     0.200
     0.677     5.033     0.200
     0.747     5.251     0.200
     0.806     5.103     0.200
     0.806     4.634     0.200
     0.734     5.723     0.200
     0.951     6.155     0.200
     0.993     6.529     0.200
     0.994     6.373     0.200
     1.115     6.481     0.200
     1.374     7.430     0.200
     1.787     9.655     0.200
     1.853    11.149     0.200
     5.528    26.141     0.200
     0.286     2.458     0.200
     0.349     3.017     0.200
     0.350     2.728     0.200
     0.369     2.357     0.200
     0.371     3.343     0.200
     0.486     3.873     0.200
     0.489     3.911     0.200
     0.531     4.031     0.200
     0.594     4.140     0.200
     0.594     4.410     0.200
     0.613     4.532     0.200
     0.648     4.894     0.200
     0.661     4.912     0.200
     0.707     5.081     0.200
     0.726     5.406     0.200
     0.841     5.894     0.200
     0.921     6.352     0.200
     0.946     6.535     0.200
     1.093     7.720     0.200
     1.366     6.974     0.200
     1.366     7.228     0.200
     1.586    10.033     0.200
     1.873    11.581     0.200
     0.291     2.253     0.200
     0.433     3.344     0.200
     0.666     5.250     0.200
     0.769     4.757     0.200
     0.114     1.815     0.200
     0.114     1.606     0.200
     0.348     2.702     0.200
     0.475     3.356     0.200
     0.408     3.379     0.200
     0.419     3.345     0.200
     0.507     3.648     0.200
     0.487     3.910     0.200
     0.503     4.032     0.200
     0.621     4.256     0.200
     0.621     4.459     0.200
     0.633     4.517     0.200
     0.726     5.243     0.200
     0.923     6.531     0.200
     1.006     6.128     0.200
     1.048     6.808     0.200
     1.062     6.260     0.200
     1.121     7.236     0.200
     1.291     6.757     0.200
     1.286     8.289     0.200
     1.347     8.966     0.200
     1.881    11.934     0.200
     1.949    13.396     0.200
     0.110     1.825     0.200
     0.111     1.479     0.200
     0.343     2.716     0.200
     0.406     3.387     0.200
     0.421     3.336     0.200
     0.472     3.287     0.200
     0.500     3.672     0.200
     0.490     3.884     0.200
     0.549     4.449     0.200
     0.506     4.013     0.200
     0.544     4.181     0.200
     0.627     4.303     0.200
     0.627     4.198     0.200
     0.636     4.266     0.200
     0.721     5.280     0.200
     0.929     6.494     0.200
     1.008     6.150     0.200
     1.056     6.758     0.200
     1.053     6.783     0.200
     1.115     7.260     0.200
     1.288     6.747     0.200
     1.875    12.010     0.200
     1.955    13.206     0.200
     0.219     1.860     0.200
     0.219     1.693     0.200
     0.501     3.480     0.200
     0.685     4.636     0.200
     0.682     5.036     0.200
     0.698     5.007     0.200
     0.744     4.822     0.200
     0.766     4.981     0.200
     0.780     5.482     0.200
     0.846     5.669     0.200
     1.376     6.847     0.200
     2.829    16.071     0.200
     0.167     1.994     0.200
     0.162     2.172     0.200
     0.183     2.274     0.200
     0.192     1.789     0.200
     0.192     1.531     0.200
     0.247     2.610     0.200
     0.314     3.316     0.200
     0.485     3.963     0.200
     0.482     3.675     0.200
     0.493     4.015     0.200
     0.532     3.772     0.200
     0.511     4.095     0.200
     0.517     4.014     0.200
     0.554     4.356     0.200
     0.560     3.964     0.200
     0.564     4.405     0.200
     0.549     4.296     0.200
     0.606     4.612     0.200
     0.580     4.459     0.200
     0.611     4.476     0.200
     0.693     4.958     0.200
     0.737     5.269     0.200
     0.737     5.230     0.200
     0.718     4.577     0.200
     0.711     5.026     0.200
     0.755     4.997     0.200
     0.755     5.208     0.200
     0.753     4.874     0.200
     0.753     5.343     0.200
     0.771     5.476     0.200
     0.780     5.157     0.200
     0.777     5.378     0.200
     0.831     5.770     0.200
     0.859     6.421     0.200
     0.847     5.928     0.200
     0.890     6.002     0.200
     0.901     5.772     0.200
     0.922     6.175     0.200
     0.909     6.614     0.200
     0.909     6.231     0.200
     0.928     6.241     0.200
     0.973     6.727     0.200
     0.991     6.571     0.200
     1.145     7.297     0.200
     1.142     7.519     0.200
     1.343     7.186     0.200
     1.683    10.976     0.200
     0.152     2.270     0.200
     0.272     2.050     0.200
     0.272     2.370     0.200
     0.276     2.539     0.200
     0.339     2.751     0.200
     0.383     3.171     0.200
     0.394     3.670     0.200
     0.386     3.610     0.200
     0.449     3.476     0.200
     0.460     4.074     0.200
     0.507     3.822     0.200
     0.517     3.865     0.200
     0.563     4.120     0.200
     0.593     4.343     0.200
     0.593     4.155     0.200
     0.669     4.971     0.200
     0.745     5.126     0.200
     0.836     5.902     0.200
     0.903     5.974     0.200
     0.944     5.429     0.200
     0.971     6.394     0.200
     0.987     5.917     0.200
     1.095     6.579     0.200
     1.363     7.179     0.200
     1.686    11.508     0.200
     3.228    18.140     0.200
     0.122     1.842     0.200
     0.350     3.091     0.200
     0.372     3.334     0.200
     0.372     3.170     0.200
     0.376     3.029     0.200
     0.376     2.748     0.200
     0.432     3.803     0.200
     0.448     3.626     0.200
     0.504     3.889     0.200
     0.457     3.671     0.200
     0.487     3.903     0.200
     0.509     3.980     0.200
     0.480     4.122     0.200
     0.542     4.350     0.200
     0.554     4.580     0.200
     0.578     4.548     0.200
     0.728     5.446     0.200
     0.621     4.800     0.200
     0.730     5.486     0.200
     0.719     5.188     0.200
     0.722     5.565     0.200
     0.735     5.419     0.200
     0.772     5.802     0.200
     0.892     5.717     0.200
     0.844     6.271     0.200
     1.013     6.811     0.200
     0.928     6.788     0.200
     1.098     7.012     0.200
     1.070     7.219     0.200
     1.037     7.342     0.200
     1.059     7.448     0.200
     1.172     6.954     0.200
     1.172     7.743     0.200
     1.169     7.644     0.200
     1.095     7.907     0.200
     1.144     7.586     0.200
     1.250     7.965     0.200
     1.364     8.635     0.200
     1.404     9.112     0.200
     1.575     9.287     0.200
     1.549     9.438     0.200
     1.617     9.458     0.200
     1.562     9.521     0.200
     1.589    10.434     0.200
     1.937    12.466     0.200
     0.105     2.049     0.200
     0.219     2.198     0.200
     0.234     2.758     0.200
     0.255     2.725     0.200
     0.292     2.499     0.200
     0.314     2.980     0.200
     0.372     3.226     0.200
     0.413     3.096     0.200
     0.412     3.215     0.200
     0.494     3.625     0.200
     0.574     4.034     0.200
     0.583     4.514     0.200
     0.614     4.166     0.200
     0.620     4.360     0.200
     0.620     4.032     0.200
     0.620     4.961     0.200
     0.659     4.307     0.200
     0.704     4.921     0.200
     0.735     5.475     0.200
     0.998     6.030     0.200
     1.123     6.374     0.200
     1.154     6.384     0.200
     1.624     9.926     0.200
     2.460    14.396     0.200
     5.820    29.688     0.200
     0.319     2.576     0.200
     0.330     2.309     0.200
     0.330     2.645     0.200
     0.554     3.936     0.200
     0.755     4.821     0.200
     0.850     5.134     0.200
     1.154     6.304     0.200
     2.739    16.018     0.200
     0.148     1.920     0.200
     0.273     2.107     0.200
     0.397     3.288     0.200
     0.437     3.357     0.200
     0.488     3.712     0.200
     0.446     3.776     0.200
     0.550     4.546     0.200
     0.462     3.736     0.200
     0.541     4.190     0.200
     0.613     4.108     0.200
     0.595     4.508     0.200
     0.676     4.986     0.200
     0.754     5.638     0.200
     0.966     6.230     0.200
     0.945     6.663     0.200
     1.250     6.869     0.200
     1.349     9.183     0.200
     1.662    10.421     0.200
     1.869    11.642     0.200
     1.894    11.822     0.200
     1.946    13.319     0.200
     1.945    11.588     0.200
     3.194    16.249     0.200
     0.118     1.780     0.200
     0.154     2.179     0.200
     0.173     2.468     0.200
     0.213     2.635     0.200
     0.212     2.266     0.200
     0.233     2.528     0.200
     0.207     2.718     0.200
     0.364     2.982     0.200
     0.473     3.646     0.200
     0.512     3.767     0.200
     0.551     4.230     0.200
     0.554     3.991     0.200
     0.603     5.171     0.200
     0.603     4.640     0.200
     0.578     4.845     0.200
     0.617     4.041     0.200
     0.737     5.082     0.200
     0.723     5.284     0.200
     0.776     5.353     0.200
     0.789     5.413     0.200
     0.809     5.764     0.200
     0.980     6.047     0.200
     1.017     5.863     0.200
     1.020     5.725     0.200
     1.046     6.115     0.200
     1.085     6.414     0.200
     1.191     6.622     0.200
     1.266     6.949     0.200
     0.196     1.711     0.200
     0.297     2.715     0.200
     0.265     2.061     0.200
     0.349     2.568     0.200
     0.350     2.588     0.200
     0.457     3.637     0.200
     0.359     3.676     0.200
     0.475     3.918     0.200
     0.489     3.792     0.200
     0.517     3.873     0.200
     0.619     4.927     0.200
     0.564     4.180     0.200
     0.626     4.679     0.200
     0.688     5.925     0.200
     0.720     5.159     0.200
     0.788     6.518     0.200
     0.739     5.357     0.200
     0.773     5.697     0.200
     0.753     5.446     0.200
     0.753     6.743     0.200
     0.956     6.039     0.200
     0.956     6.559     0.200
     0.902     6.221     0.200
     0.957     6.631     0.200
     0.979     6.381     0.200
     0.986     7.021     0.200
     0.983     7.003     0.200
     1.014     6.961     0.200
     1.022     7.358     0.200
     1.077     7.434     0.200
     1.203     7.299     0.200
     1.249     7.839     0.200
     1.249     8.031     0.200
     1.249     7.984     0.200
     1.232     8.922     0.200
     1.371     7.888     0.200
     1.364     7.809     0.200
     1.495    10.397     0.200
     1.565    11.141     0.200
     1.588    11.021     0.200
     1.850    12.824     0.200
     0.208     1.858     0.200
     0.292     3.107     0.200
     0.337     2.550     0.200
     0.338     3.077     0.200
     0.338     2.501     0.200
     0.359     3.622     0.200
     0.456     3.971     0.200
     0.466     4.369     0.200
     0.475     4.179     0.200
     0.478     4.282     0.200
     0.505     4.345     0.200
     0.554     4.617     0.200
     0.611     5.430     0.200
     0.618     5.258     0.200
     0.619     5.097     0.200
     0.686     5.534     0.200
     0.714     5.575     0.200
     0.732     5.666     0.200
     0.757     5.592     0.200
     0.757     7.246     0.200
     0.761     6.196     0.200
     0.822     6.888     0.200
     0.895     6.615     0.200
     0.943     7.053     0.200
     0.944     6.525     0.200
     0.944     6.959     0.200
     0.966     7.024     0.200
     0.973     7.566     0.200
     0.995     7.092     0.200
     1.020     7.712     0.200
     1.028     7.023     0.200
     1.065     7.876     0.200
     1.108     7.957     0.200
     1.190     7.732     0.200
     1.236     8.392     0.200
     1.236     8.528     0.200
     1.236     8.406     0.200
     1.241     9.008     0.200
     1.298     9.833     0.200
     1.305     9.211     0.200
     1.324     9.559     0.200
     1.366     8.158     0.200
     1.366     8.268     0.200
     1.367     8.020     0.200
     1.550    11.181     0.200
     1.576    11.273     0.200
     1.602    11.569     0.200
     1.739    12.159     0.200
     1.850    13.116     0.200
     1.935    12.847     0.200
     0.293     2.295     0.200
     0.294     2.025     0.200
     0.294     2.318     0.200
     0.376     3.631     0.200
     0.426     3.410     0.200
     0.440     3.531     0.200
     0.500     4.264     0.200
     0.535     4.944     0.200
     0.543     4.180     0.200
     0.546     4.208     0.200
     0.570     4.547     0.200
     0.560     4.319     0.200
     0.636     4.798     0.200
     0.636     4.989     0.200
     0.673     4.920     0.200
     0.673     5.069     0.200
     0.714     5.139     0.200
     0.714     5.436     0.200
     0.721     5.135     0.200
     0.721     5.185     0.200
     0.711     5.359     0.200
     0.732     5.287     0.200
     0.768     5.161     0.200
     0.765     5.721     0.200
     0.763     5.279     0.200
     0.910     6.106     0.200
     1.048     6.408     0.200
     1.296     7.805     0.200
     1.358     7.150     0.200
     1.358     6.990     0.200
     1.348     9.957     0.200
     1.394     9.361     0.200
     1.508     9.674     0.200
     1.508    10.912     0.200
     1.530    11.463     0.200
     1.594     9.587     0.200
     1.590    11.103     0.200
     1.619     9.561     0.200
     1.626    11.224     0.200
     1.664    10.260     0.200
     1.640    10.367     0.200
     1.646    10.289     0.200
     1.680    10.633     0.200
     1.703    10.169     0.200
     1.705    10.862     0.200
     1.821     9.923     0.200
     1.851    11.974     0.200
     1.851    12.658     0.200
     1.879    12.191     0.200
     1.886    12.860     0.200
     1.966    12.485     0.200
     2.173    11.988     0.200
     2.891    14.538     0.200
     0.202     2.274     0.200
     0.217     2.665     0.200
     0.249     2.601     0.200
     0.477     3.592     0.200
     0.584     4.449     0.200
     0.597     4.669     0.200
     0.634     4.413     0.200
     0.633     4.140     0.200
     0.652     2.952     0.200
     0.721     5.282     0.200
     0.938     5.889     0.200
     1.140     6.157     0.200
     1.748    11.523     0.200
     0.213     2.199     0.200
     0.213     2.066     0.200
     0.242     2.627     0.200
     0.294     3.131     0.200
     0.301     2.937     0.200
     0.367     3.154     0.200
     0.400     3.070     0.200
     0.406     3.075     0.200
     0.483     3.619     0.200
     0.592     4.392     0.200
     0.605     4.888     0.200
     0.634     4.862     0.200
     0.621     4.015     0.200
     0.646     3.432     0.200
     0.733     5.095     0.200
     0.942     6.433     0.200
     0.946     6.343     0.200
     0.949     6.290     0.200
     0.949     5.736     0.200
     0.986     6.006     0.200
     0.994     6.208     0.200
     0.994     6.513     0.200
     1.037     6.005     0.200
     1.131     6.194     0.200
     1.181     6.537     0.200
     1.195     6.692     0.200
     0.215     2.228     0.200
     0.227     2.691     0.200
     0.247     2.677     0.200
     0.298     3.142     0.200
     0.305     2.984     0.200
     0.404     3.067     0.200
     0.487     3.649     0.200
     0.595     4.416     0.200
     0.608     4.728     0.200
     0.621     4.138     0.200
     0.629     5.025     0.200
     0.650     3.285     0.200
     0.695     4.777     0.200
     0.733     5.394     0.200
     0.938     6.759     0.200
     0.943     6.036     0.200
     0.946     5.796     0.200
     0.946     5.898     0.200
     1.129     6.289     0.200
     1.171     6.480     0.200
     1.302     6.994     0.200
     0.211     2.127     0.200
     0.246     2.671     0.200
     0.223     2.639     0.200
     0.296     3.072     0.200
     0.302     2.881     0.200
     0.411     3.151     0.200
     0.401     3.007     0.200
     0.483     3.536     0.200
     0.624     4.314     0.200
     0.631     5.013     0.200
     0.591     4.508     0.200
     0.604     4.827     0.200
     0.650     3.642     0.200
     0.729     5.331     0.200
     0.944     5.926     0.200
     0.981     6.172     0.200
     0.991     6.451     0.200
     1.032     6.241     0.200
     1.133     6.461     0.200
     1.298     6.968     0.200
     3.560    17.867     0.200
     6.832    54.941     0.200
     0.209     2.464     0.200
     0.233     2.492     0.200
     0.202     1.764     0.200
     0.279     2.950     0.200
     0.286     3.040     0.200
     0.356     3.181     0.200
     0.385     2.907     0.200
     0.469     3.312     0.200
     0.579     4.175     0.200
     0.591     4.458     0.200
     0.636     5.293     0.200
     0.628     3.891     0.200
     0.724     5.417     0.200
     1.539    10.215     0.200
     0.165     2.305     0.200
     0.158     1.905     0.200
     0.231     2.660     0.200
     0.215     2.809     0.200
     0.245     2.833     0.200
     0.246     2.597     0.200
     0.311     2.961     0.200
     0.348     2.773     0.200
     0.434     3.221     0.200
     0.424     3.299     0.200
     0.533     4.059     0.200
     0.545     4.305     0.200
     0.626     3.288     0.200
     0.668     4.174     0.200
     0.678     4.615     0.200
     0.681     4.890     0.200
     0.683     5.175     0.200
     0.941     5.678     0.200
     1.191     6.558     0.200
     0.212     2.185     0.200
     0.226     2.597     0.200
     0.249     2.575     0.200
     0.305     2.852     0.200
     0.486     3.666     0.200
     0.594     4.652     0.200
     0.624     3.961     0.200
     0.607     4.891     0.200
     0.628     4.787     0.200
     0.653     3.451     0.200
     0.698     4.854     0.200
     0.698     4.643     0.200
     0.731     5.311     0.200
     0.942     5.946     0.200
     0.980     6.288     0.200
     0.992     6.512     0.200
     1.029     6.572     0.200
     1.130     6.326     0.200
     1.625     8.853     0.200
     0.233     2.339     0.200
     0.249     2.812     0.200
     0.261     2.668     0.200
     0.321     3.296     0.200
     0.386     3.228     0.200
     0.408     3.126     0.200
     0.426     3.219     0.200
     0.509     3.757     0.200
     0.610     4.146     0.200
     0.608     4.916     0.200
     0.616     4.570     0.200
     0.629     4.804     0.200
     0.666     3.704     0.200
     0.709     4.743     0.200
     0.709     4.172     0.200
     0.748     5.464     0.200
     0.934     6.360     0.200
     0.942     6.015     0.200
     0.984     6.241     0.200
     1.012     6.427     0.200
     1.017     6.258     0.200
     1.108     6.242     0.200
     2.464    14.161     0.200
     4.714    22.931     0.200
     5.402    25.821     0.200
     6.631    29.347     0.200
     0.163     2.311     0.200
     0.215     2.717     0.200
     0.168     1.782     0.200
     0.237     2.860     0.200
     0.241     2.565     0.200
     0.341     2.783     0.200
     0.320     2.757     0.200
     0.419     3.161     0.200
     0.424     3.323     0.200
     0.536     4.186     0.200
     0.546     4.318     0.200
     0.611     3.347     0.200
     0.662     4.728     0.200
     0.657     4.040     0.200
     0.694     5.061     0.200
     0.689     4.505     0.200
     0.947     6.028     0.200
     0.950     7.707     0.200
     0.954     5.928     0.200
     0.957     5.587     0.200
     0.984     5.811     0.200
     1.053     6.309     0.200
     1.189     6.330     0.200
     1.189     6.072     0.200
     1.239     6.383     0.200
     1.266     6.845     0.200
     3.104    17.624     0.200
     0.240     2.801     0.200
     0.228     2.322     0.200
     0.250     2.690     0.200
     0.310     3.238     0.200
     0.382     3.293     0.200
     0.402     3.061     0.200
     0.500     3.735     0.200
     0.609     4.497     0.200
     0.621     4.880     0.200
     0.655     3.094     0.200
     0.610     3.987     0.200
     0.619     4.781     0.200
     0.698     4.682     0.200
     0.698     4.432     0.200
     0.950     5.919     0.200
     1.115     6.239     0.200
     1.208     6.903     0.200
     1.314     7.458     0.200
     3.338    15.322     0.200
     0.234     2.375     0.200
     0.243     2.795     0.200
     0.247     2.691     0.200
     0.311     3.238     0.200
     0.320     3.048     0.200
     0.503     3.699     0.200
     0.613     4.537     0.200
     0.620     4.667     0.200
     0.625     4.693     0.200
     0.603     4.042     0.200
     0.651     3.128     0.200
     0.752     5.298     0.200
     0.694     4.431     0.200
     0.948     6.455     0.200
     0.952     5.838     0.200
     0.955     6.010     0.200
     0.996     6.184     0.200
     1.014     6.280     0.200
     1.014     6.069     0.200
     1.032     6.360     0.200
     0.194     2.093     0.200
     0.205     2.580     0.200
     0.241     2.704     0.200
     0.285     2.797     0.200
     0.308     2.460     0.200
     0.347     3.037     0.200
     0.418     3.169     0.200
     0.465     3.478     0.200
     0.573     4.289     0.200
     0.586     4.616     0.200
     0.643     3.348     0.200
     0.638     4.241     0.200
     0.646     4.941     0.200
     0.714     5.409     0.200
     0.942     5.757     0.200
     1.151     6.384     0.200
     2.345    13.327     0.200
     0.189     2.073     0.200
     0.205     2.415     0.200
     0.249     2.598     0.200
     0.314     2.434     0.200
     0.343     3.029     0.200
     0.465     3.399     0.200
     0.571     4.271     0.200
     0.584     4.803     0.200
     0.645     4.198     0.200
     0.642     5.036     0.200
     0.708     5.381     0.200
     0.930     5.878     0.200
     0.933     5.821     0.200
     1.153     6.498     0.200
     1.277     7.084     0.200
     2.448    13.757     0.200
     0.153     1.947     0.200
     0.409     2.987     0.200
     0.444     3.085     0.200
     0.463     4.405     0.200
     0.449     3.449     0.200
     0.459     3.392     0.200
     0.500     3.469     0.200
     0.528     4.153     0.200
     0.529     4.088     0.200
     0.560     4.307     0.200
     0.602     4.147     0.200
     0.602     4.292     0.200
     0.594     4.164     0.200
     0.656     4.457     0.200
     0.672     4.593     0.200
     0.672     4.631     0.200
     0.761     5.288     0.200
     0.761     5.108     0.200
     0.933     6.449     0.200
     0.964     5.716     0.200
     1.015     6.328     0.200
     1.047     5.858     0.200
     1.255     6.160     0.200
     1.255     6.305     0.200
     1.650    10.508     0.200
     1.882    11.145     0.200
     1.934    11.098     0.200
     1.934    11.241     0.200
     2.098    12.303     0.200
     2.099    12.317     0.200
     2.082    11.751     0.200
     2.700    15.453     0.200
     5.634    25.074     0.200
     0.469     3.759     0.200
     0.471     3.728     0.200
     0.515     4.156     0.200
     0.761     5.490     0.200
     0.847     6.713     0.200
     0.959     6.163     0.200
     0.935     6.841     0.200
     0.975     7.235     0.200
     1.035     7.525     0.200
     1.056     7.243     0.200
     1.241     7.371     0.200
     1.240     7.681     0.200
     1.291     7.585     0.200
     1.280     8.568     0.200
     1.360     8.133     0.200
     1.920    13.145     0.200
     1.968    12.886     0.200
     4.655    22.325     0.200
     0.178     2.138     0.200
     0.262     2.089     0.200
     0.384     2.836     0.200
     0.366     2.950     0.200
     0.420     4.302     0.200
     0.445     3.279     0.200
     0.498     4.053     0.200
     0.475     3.797     0.200
     0.510     3.997     0.200
     0.557     4.708     0.200
     0.563     4.222     0.200
     0.635     4.637     0.200
     0.637     4.576     0.200
     0.637     4.738     0.200
     0.666     4.864     0.200
     0.725     5.260     0.200
     0.725     5.182     0.200
     0.766     5.628     0.200
     0.936     6.032     0.200
     0.986     6.795     0.200
     0.993     6.970     0.200
     1.198     6.680     0.200
     1.829    12.621     0.200
     1.941    11.747     0.200
     1.973    13.563     0.200
     1.994    12.224     0.200
     5.639    25.736     0.200
     0.091     1.418     0.200
     0.091     1.563     0.200
     0.095     1.576     0.200
     0.096     1.584     0.200
     0.624     4.220     0.200
     0.612     4.275     0.200
     0.623     4.421     0.200
     0.699     4.323     0.200
     0.799     4.960     0.200
     0.822     5.243     0.200
     0.822     5.227     0.200
     0.851     5.067     0.200
     0.851     5.239     0.200
     0.859     5.567     0.200
     0.874     5.211     0.200
     0.834     6.043     0.200
     0.911     5.608     0.200
     0.915     5.883     0.200
     1.093     6.419     0.200
     1.232     6.509     0.200
     1.857     9.038     0.200
     0.111     1.105     0.200
     0.111     1.410     0.200
     0.607     4.540     0.200
     0.623     4.787     0.200
     0.630     4.655     0.200
     0.782     5.396     0.200
     0.815     5.495     0.200
     0.837     5.374     0.200
     0.852     6.434     0.200
     1.240     8.141     0.200
     1.275     7.568     0.200
     1.442    10.432     0.200
     1.546    10.088     0.200
     1.731    11.086     0.200
     1.875    11.946     0.200
     0.187     1.844     0.200
     0.218     2.963     0.200
     0.323     2.646     0.200
     0.318     3.371     0.200
     0.451     3.461     0.200
     0.458     3.708     0.200
     0.514     4.420     0.200
     0.663     3.858     0.200
     0.633     4.408     0.200
     0.714     5.000     0.200
     0.769     5.413     0.200
     0.825     5.347     0.200
     0.825     5.685     0.200
     0.851     5.989     0.200
     1.008     6.630     0.200
     1.039     7.456     0.200
     1.039     6.067     0.200
     1.055     6.091     0.200
     1.898    12.511     0.200
     0.341     2.189     0.200
     0.442     3.301     0.200
     0.703     4.901     0.200
     0.692     5.900     0.200
     0.684     6.263     0.200
     0.747     6.488     0.200
     0.987     6.817     0.200
     1.003     6.740     0.200
     1.119     6.455     0.200
     1.119     6.228     0.200
     1.211     8.007     0.200
     1.211     7.897     0.200
     1.619    12.875     0.200
     0.323     2.758     0.200
     0.463     4.047     0.200
     0.447     3.778     0.200
     0.485     4.085     0.200
     0.443     3.628     0.200
     0.495     4.423     0.200
     0.575     4.282     0.200
     0.593     4.148     0.200
     0.636     4.576     0.200
     0.709     4.464     0.200
     0.709     4.682     0.200
     0.708     5.133     0.200
     0.734     5.806     0.200
     0.742     5.446     0.200
     0.778     5.405     0.200
     0.778     5.600     0.200
     0.868     3.726     0.200
     0.815     6.114     0.200
     1.031     6.198     0.200
     1.064     6.226     0.200
     1.069     6.450     0.200
     1.203     6.933     0.200
     1.278     7.119     0.200
     1.348     7.250     0.200
     1.639    10.209     0.200
     0.265     2.505     0.200
     0.265     2.343     0.200
     0.460     3.673     0.200
     0.641     4.433     0.200
     0.711     4.753     0.200
     0.739     5.333     0.200
     0.717     5.134     0.200
     0.757     4.936     0.200
     0.724     5.429     0.200
     0.839     5.680     0.200
     0.947     5.957     0.200
     1.345     6.577     0.200
     1.345     6.448     0.200
     1.851    11.381     0.200
     2.353    13.528     0.200
     2.431    13.549     0.200
     0.096     2.073     0.200
     0.127     2.034     0.200
     0.118     2.268     0.200
     0.196     2.349     0.200
     0.268     2.518     0.200
     0.268     2.838     0.200
     0.292     2.325     0.200
     0.254     2.909     0.200
     0.315     2.719     0.200
     0.309     3.057     0.200
     0.317     3.116     0.200
     0.331     3.295     0.200
     0.331     3.095     0.200
     0.363     3.140     0.200
     0.378     3.138     0.200
     0.399     3.245     0.200
     0.409     3.360     0.200
     0.372     3.519     0.200
     0.376     3.236     0.200
     0.400     3.633     0.200
     0.390     3.840     0.200
     0.399     3.900     0.200
     0.443     3.515     0.200
     0.460     3.757     0.200
     0.478     3.053     0.200
     0.478     3.323     0.200
     0.481     3.295     0.200
     0.453     3.937     0.200
     0.461     3.610     0.200
     0.461     3.814     0.200
     0.499     3.771     0.200
     0.485     4.000     0.200
     0.529     3.565     0.200
     0.520     4.102     0.200
     0.562     4.194     0.200
     0.558     4.323     0.200
     0.583     4.721     0.200
     0.588     4.659     0.200
     0.611     4.956     0.200
     0.665     4.916     0.200
     0.680     4.571     0.200
     0.714     5.169     0.200
     0.716     4.847     0.200
     0.708     5.048     0.200
     0.715     5.347     0.200
     0.776     4.810     0.200
     0.804     5.043     0.200
     0.156     1.733     0.200
     0.190     2.568     0.200
     0.210     1.976     0.200
     0.291     2.419     0.200
     0.294     2.668     0.200
     0.323     3.282     0.200
     0.354     3.264     0.200
     0.362     3.102     0.200
     0.411     3.789     0.200
     0.426     3.405     0.200
     0.443     3.884     0.200
     0.481     3.810     0.200
     0.515     4.178     0.200
     0.527     3.997     0.200
     0.530     4.380     0.200
     0.536     4.409     0.200
     0.549     3.943     0.200
     0.558     4.596     0.200
     0.579     3.966     0.200
     0.577     4.939     0.200
     0.601     4.214     0.200
     0.676     4.446     0.200
     0.677     5.045     0.200
     0.682     4.831     0.200
     0.682     4.933     0.200
     0.696     4.821     0.200
     0.705     5.359     0.200
     0.741     5.347     0.200
     0.783     5.290     0.200
     0.815     5.377     0.200
     0.818     5.748     0.200
     0.821     5.760     0.200
     0.868     6.110     0.200
     0.866     6.070     0.200
     0.880     6.194     0.200
     0.909     6.415     0.200
     0.928     6.768     0.200
     0.930     6.369     0.200
     0.981     6.468     0.200
     0.996     5.915     0.200
     0.998     6.194     0.200
     1.010     6.742     0.200
     1.025     6.327     0.200
     1.069     6.530     0.200
     1.102     5.849     0.200
     1.130     6.753     0.200
     1.217     7.012     0.200
     1.288     7.290     0.200
     1.288     7.296     0.200
     1.383     7.530     0.200
     2.418    12.705     0.200
     0.074     0.911     0.200
     0.174     1.438     0.200
     0.279     2.753     0.200
     0.287     2.786     0.200
     0.313     2.697     0.200
     0.397     3.326     0.200
     0.404     3.154     0.200
     0.451     3.636     0.200
     0.454     3.923     0.200
     0.477     3.576     0.200
     0.479     3.341     0.200
     0.479     3.625     0.200
     0.555     4.561     0.200
     0.596     4.400     0.200
     0.622     4.962     0.200
     0.615     4.713     0.200
     0.618     4.770     0.200
     0.646     4.881     0.200
     0.652     5.160     0.200
     0.688     5.231     0.200
     0.693     5.181     0.200
     0.736     5.600     0.200
     0.770     5.518     0.200
     0.761     5.767     0.200
     0.782     5.773     0.200
     0.789     5.954     0.200
     0.808     6.071     0.200
     0.832     6.515     0.200
     0.840     5.995     0.200
     0.862     6.208     0.200
     0.869     6.655     0.200
     0.886     6.416     0.200
     0.904     6.293     0.200
     0.894     6.543     0.200
     0.899     6.371     0.200
     0.903     6.519     0.200
     0.903     6.408     0.200
     0.902     6.590     0.200
     0.929     6.494     0.200
     0.940     6.663     0.200
     1.004     6.583     0.200
     1.004     7.058     0.200
     1.025     7.121     0.200
     1.044     6.830     0.200
     1.046     6.972     0.200
     1.054     7.929     0.200
     1.078     7.317     0.200
     1.088     7.587     0.200
     1.106     7.401     0.200
     1.118     7.584     0.200
     1.160     8.151     0.200
     1.191     7.886     0.200
     1.196     7.904     0.200
     1.209     7.998     0.200
     1.202     7.872     0.200
     1.245     8.790     0.200
     1.268     7.836     0.200
     1.266     8.226     0.200
     1.274     8.611     0.200
     1.280     7.675     0.200
     1.284     7.375     0.200
     1.315     9.516     0.200
     1.937    12.253     0.200
     0.085     0.600     0.200
     0.186     1.495     0.200
     0.267     2.718     0.200
     0.277     2.695     0.200
     0.331     2.803     0.200
     0.391     3.213     0.200
     0.395     3.194     0.200
     0.453     4.119     0.200
     0.459     3.839     0.200
     0.468     3.625     0.200
     0.468     3.152     0.200
     0.469     3.967     0.200
     0.469     3.631     0.200
     0.469     3.452     0.200
     0.551     4.514     0.200
     0.589     4.549     0.200
     0.606     4.755     0.200
     0.610     5.027     0.200
     0.613     4.897     0.200
     0.636     4.890     0.200
     0.640     5.437     0.200
     0.679     5.253     0.200
     0.685     5.220     0.200
     0.725     5.523     0.200
     0.749     5.847     0.200
     0.775     5.558     0.200
     0.776     5.821     0.200
     0.787     6.215     0.200
     0.811     6.313     0.200
     0.821     6.694     0.200
     0.835     6.161     0.200
     0.856     6.330     0.200
     0.872     6.756     0.200
     0.883     6.607     0.200
     0.897     6.509     0.200
     0.893     6.627     0.200
     0.893     6.711     0.200
     0.902     6.758     0.200
     0.916     6.400     0.200
     0.916     6.243     0.200
     0.941     6.774     0.200
     0.938     6.844     0.200
     0.992     6.712     0.200
     0.992     6.580     0.200
     1.019     7.318     0.200
     1.032     6.886     0.200
     1.034     7.013     0.200
     1.054     7.792     0.200
     1.076     7.528     0.200
     1.076     7.649     0.200
     1.076     7.458     0.200
     1.104     7.583     0.200
     1.117     7.853     0.200
     1.162     8.364     0.200
     1.181     8.102     0.200
     1.192     8.132     0.200
     1.221     8.105     0.200
     1.231     8.046     0.200
     1.242     8.739     0.200
     1.249     8.895     0.200
     1.250     9.016     0.200
     1.257     8.157     0.200
     1.268     8.050     0.200
     1.268     7.719     0.200
     1.294     7.648     0.200
     1.315     8.830     0.200
     1.319     9.724     0.200
     1.330     7.976     0.200
     1.610    11.579     0.200
     1.616    10.803     0.200
     1.938    12.631     0.200
     0.252     2.132     0.200
     0.236     2.149     0.200
     0.384     3.131     0.200
     0.518     3.591     0.200
     0.504     4.130     0.200
     0.564     3.911     0.200
     0.561     4.835     0.200
     0.516     4.032     0.200
     0.516     3.834     0.200
     0.568     4.401     0.200
     0.542     4.223     0.200
     0.542     4.338     0.200
     0.563     4.372     0.200
     0.600     3.953     0.200
     0.641     4.519     0.200
     0.641     4.322     0.200
     0.665     4.984     0.200
     0.648     4.728     0.200
     0.701     5.103     0.200
     0.705     4.561     0.200
     0.703     4.489     0.200
     0.802     4.662     0.200
     0.773     5.005     0.200
     0.804     5.483     0.200
     0.807     5.525     0.200
     0.807     5.340     0.200
     0.834     5.611     0.200
     0.859     5.864     0.200
     0.890     6.100     0.200
     0.881     5.946     0.200
     0.908     6.059     0.200
     0.910     6.200     0.200
     0.984     6.281     0.200
     0.999     6.392     0.200
     0.990     6.231     0.200
     0.990     6.119     0.200
     0.997     6.051     0.200
     1.029     6.437     0.200
     1.094     6.447     0.200
     1.090     6.413     0.200
     1.077     7.464     0.200
     1.115     5.331     0.200
     1.111     7.948     0.200
     1.182     6.629     0.200
     1.232     6.707     0.200
     1.243     6.727     0.200
     1.252     6.757     0.200
     1.321     7.099     0.200
     1.360     7.042     0.200
     1.615    11.331     0.200
     1.696    11.434     0.200
     2.274    12.855     0.200
     0.108     1.494     0.200
     0.311     2.743     0.200
     0.265     2.256     0.200
     0.265     1.943     0.200
     0.387     3.166     0.200
     0.629     4.610     0.200
     0.668     5.366     0.200
     0.615     3.943     0.200
     0.828     5.440     0.200
     0.836     5.474     0.200
     1.048     6.366     0.200
     1.008     5.945     0.200
     1.172     6.596     0.200
     1.352     7.498     0.200
     1.415     7.754     0.200
     1.454     7.825     0.200
     1.454     7.708     0.200
     1.407     8.252     0.200
     1.660     8.734     0.200
     0.296     2.957     0.200
     0.351     2.749     0.200
     0.356     3.164     0.200
     0.442     3.086     0.200
     0.509     3.319     0.200
     0.509     3.523     0.200
     0.517     3.359     0.200
     0.687     4.915     0.200
     0.749     5.153     0.200
     1.242     6.585     0.200
     0.137     2.201     0.200
     0.161     1.594     0.200
     0.174     2.427     0.200
     0.166     2.077     0.200
     0.167     2.220     0.200
     0.167     1.964     0.200
     0.167     2.107     0.200
     0.188     2.479     0.200
     0.195     2.563     0.200
     0.296     2.716     0.200
     0.269     2.793     0.200
     0.300     2.659     0.200
     0.292     2.655     0.200
     0.357     3.278     0.200
     0.421     3.482     0.200
     0.437     3.692     0.200
     0.464     3.754     0.200
     0.496     4.025     0.200
     0.511     3.932     0.200
     0.502     4.137     0.200
     0.522     3.948     0.200
     0.551     4.040     0.200
     0.533     4.085     0.200
     0.535     4.102     0.200
     0.607     4.196     0.200
     0.618     5.000     0.200
     0.644     4.354     0.200
     0.625     4.775     0.200
     0.642     4.708     0.200
     0.642     4.606     0.200
     0.650     5.098     0.200
     0.686     4.963     0.200
     0.679     4.607     0.200
     0.670     4.975     0.200
     0.727     5.236     0.200
     0.716     4.769     0.200
     0.715     4.823     0.200
     0.738     4.755     0.200
     0.739     5.160     0.200
     0.785     5.276     0.200
     0.785     5.155     0.200
     0.781     5.254     0.200
     0.781     5.183     0.200
     0.819     5.284     0.200
     0.842     5.759     0.200
     0.832     5.355     0.200
     0.807     6.075     0.200
     0.841     5.725     0.200
     0.845     5.757     0.200
     0.883     5.926     0.200
     0.883     5.605     0.200
     0.858     6.077     0.200
     0.858     5.503     0.200
     0.909     5.465     0.200
     0.910     5.440     0.200
     0.927     5.815     0.200
     0.902     6.017     0.200
     0.905     6.675     0.200
     0.946     6.212     0.200
     0.954     6.908     0.200
     1.026     6.334     0.200
     1.062     6.936     0.200
     1.062     6.817     0.200
     1.406     6.582     0.200
     0.061     1.890     0.200
     0.175     2.417     0.200
     0.207     2.650     0.200
     0.184     2.148     0.200
     0.203     2.266     0.200
     0.250     2.640     0.200
     0.364     3.478     0.200
     0.364     3.595     0.200
     0.404     3.167     0.200
     0.435     3.338     0.200
     0.435     3.109     0.200
     0.555     4.384     0.200
     0.557     3.974     0.200
     0.550     4.227     0.200
     0.559     4.283     0.200
     0.606     3.923     0.200
     0.602     4.654     0.200
     0.640     4.237     0.200
     0.655     4.575     0.200
     0.685     5.148     0.200
     0.710     5.231     0.200
     0.858     5.704     0.200
     0.904     5.449     0.200
     0.920     5.988     0.200
     0.972     5.083     0.200
     0.973     5.853     0.200
     0.954     6.060     0.200
     0.954     6.232     0.200
     0.963     6.062     0.200
     0.968     5.793     0.200
     1.282     6.866     0.200
     1.740    10.455     0.200
     1.788    10.397     0.200
     1.950    11.359     0.200
     2.140    12.205     0.200
     2.384    13.674     0.200
     2.411    13.588     0.200
     2.469    13.902     0.200
     3.999    21.889     0.200
     5.304    30.106     0.200
     0.112     2.574     0.200
     0.151     2.281     0.200
     0.212     1.979     0.200
     0.212     2.510     0.200
     0.230     2.592     0.200
     0.234     2.654     0.200
     0.273     2.955     0.200
     0.295     2.692     0.200
     0.310     3.004     0.200
     0.357     2.843     0.200
     0.364     2.706     0.200
     0.423     3.335     0.200
     0.423     3.274     0.200
     0.501     4.224     0.200
     0.551     3.915     0.200
     0.551     3.774     0.200
     0.549     3.795     0.200
     0.549     4.369     0.200
     0.554     4.067     0.200
     0.554     3.739     0.200
     0.568     4.870     0.200
     0.617     2.603     0.200
     0.618     4.360     0.200
     0.618     3.789     0.200
     0.648     4.853     0.200
     0.741     5.067     0.200
     0.736     4.781     0.200
     0.728     5.072     0.200
     0.852     5.372     0.200
     0.924     5.111     0.200
     1.015     8.415     0.200
     1.022     5.889     0.200
     1.022     6.021     0.200
     1.092     6.280     0.200
     1.310     6.980     0.200
     1.418     8.573     0.200
     1.755    10.242     0.200
     2.152    10.534     0.200
     2.428    14.100     0.200
     2.522    13.702     0.200
     2.526    13.676     0.200
     2.586    14.055     0.200
     3.218    15.815     0.200
     4.049    21.932     0.200
     0.028     1.778     0.200
     0.164     2.354     0.200
     0.178     1.997     0.200
     0.181     1.914     0.200
     0.185     2.191     0.200
     0.310     2.334     0.200
     0.312     3.281     0.200
     0.317     2.513     0.200
     0.335     2.636     0.200
     0.369     3.357     0.200
     0.386     3.583     0.200
     0.419     3.340     0.200
     0.426     3.917     0.200
     0.439     3.805     0.200
     0.457     3.361     0.200
     0.462     3.828     0.200
     0.469     3.901     0.200
     0.552     4.409     0.200
     0.553     4.210     0.200
     0.625     4.619     0.200
     0.667     4.491     0.200
     0.667     4.365     0.200
     0.696     4.979     0.200
     0.706     5.309     0.200
     0.719     5.128     0.200
     0.715     5.717     0.200
     0.723     5.138     0.200
     0.744     5.243     0.200
     0.757     5.330     0.200
     0.798     5.047     0.200
     0.798     5.153     0.200
     0.805     5.459     0.200
     0.808     5.541     0.200
     0.856     5.615     0.200
     0.871     5.748     0.200
     0.916     6.186     0.200
     0.997     6.627     0.200
     1.037     7.097     0.200
     1.108     5.799     0.200
     1.170     7.905     0.200
     1.305     7.168     0.200
     1.305     7.000     0.200
     1.309     8.293     0.200
     1.355     7.285     0.200
     1.617    10.069     0.200
     0.299     3.062     0.200
     0.361     3.018     0.200
     0.367     2.854     0.200
     0.432     3.877     0.200
     0.385     3.421     0.200
     0.406     3.281     0.200
     0.458     4.020     0.200
     0.406     3.765     0.200
     0.417     3.209     0.200
     0.465     3.534     0.200
     0.451     3.941     0.200
     0.511     4.173     0.200
     0.549     4.366     0.200
     0.558     4.684     0.200
     0.573     4.431     0.200
     0.658     4.517     0.200
     0.678     4.684     0.200
     0.679     4.794     0.200
     0.635     4.481     0.200
     0.670     4.976     0.200
     0.674     4.967     0.200
     0.677     4.936     0.200
     0.719     4.641     0.200
     0.712     5.413     0.200
     0.729     5.004     0.200
     0.762     5.757     0.200
     0.724     5.631     0.200
     0.724     5.792     0.200
     0.759     5.686     0.200
     0.749     5.719     0.200
     0.803     5.036     0.200
     0.803     5.208     0.200
     0.848     5.501     0.200
     0.960     5.008     0.200
     1.007     6.295     0.200
     1.041     6.399     0.200
     1.225     6.847     0.200
     1.313     7.124     0.200
     1.656    11.194     0.200
     7.432    35.958     0.200
     0.199     2.462     0.200
     0.212     2.520     0.200
     0.292     2.873     0.200
     0.354     2.874     0.200
     0.360     2.951     0.200
     0.392     3.209     0.200
     0.425     3.714     0.200
     0.413     3.097     0.200
     0.423     3.021     0.200
     0.412     3.601     0.200
     0.450     3.930     0.200
     0.458     3.603     0.200
     0.449     3.963     0.200
     0.505     3.921     0.200
     0.541     4.276     0.200
     0.551     4.454     0.200
     0.573     4.405     0.200
     0.651     4.297     0.200
     0.639     4.284     0.200
     0.674     4.705     0.200
     0.671     4.549     0.200
     0.673     5.594     0.200
     0.677     4.800     0.200
     0.680     4.761     0.200
     0.711     5.062     0.200
     0.715     4.754     0.200
     0.707     5.295     0.200
     0.722     4.953     0.200
     0.731     5.481     0.200
     0.755     5.581     0.200
     0.757     5.703     0.200
     0.751     5.635     0.200
     0.801     5.217     0.200
     0.843     5.394     0.200
     0.953     5.271     0.200
     1.140     8.059     0.200
     1.306     7.193     0.200
     1.480     9.875     0.200
     1.603     9.911     0.200
     3.175    18.574     0.200
     0.214     2.445     0.200
     0.227     2.547     0.200
     0.296     3.011     0.200
     0.368     2.929     0.200
     0.373     2.964     0.200
     0.373     2.850     0.200
     0.386     3.315     0.200
     0.400     3.250     0.200
     0.406     3.155     0.200
     0.406     3.304     0.200
     0.411     3.637     0.200
     0.431     4.083     0.200
     0.461     3.928     0.200
     0.465     4.038     0.200
     0.474     3.583     0.200
     0.552     4.653     0.200
     0.555     4.536     0.200
     0.588     4.719     0.200
     0.645     4.809     0.200
     0.662     4.687     0.200
     0.671     4.913     0.200
     0.685     4.490     0.200
     0.681     4.659     0.200
     0.685     5.115     0.200
     0.688     5.116     0.200
     0.708     4.958     0.200
     0.717     5.223     0.200
     0.725     5.463     0.200
     0.725     5.528     0.200
     0.725     5.745     0.200
     0.738     5.092     0.200
     0.738     5.305     0.200
     0.762     5.685     0.200
     0.771     5.886     0.200
     0.773     6.014     0.200
     0.787     5.749     0.200
     0.791     5.281     0.200
     0.786     5.816     0.200
     0.805     6.059     0.200
     0.814     6.117     0.200
     0.840     5.488     0.200
     0.851     5.955     0.200
     0.875     6.191     0.200
     0.889     6.470     0.200
     0.940     6.371     0.200
     0.958     6.851     0.200
     0.950     6.825     0.200
     0.959     6.665     0.200
     0.968     6.771     0.200
     1.021     6.366     0.200
     1.074     6.579     0.200
     1.597    11.238     0.200
     0.198     2.458     0.200
     0.208     2.625     0.200
     0.294     2.907     0.200
     0.353     2.864     0.200
     0.360     2.939     0.200
     0.391     3.370     0.200
     0.414     3.280     0.200
     0.410     3.701     0.200
     0.425     3.139     0.200
     0.426     3.672     0.200
     0.450     3.991     0.200
     0.446     4.017     0.200
     0.457     3.592     0.200
     0.507     3.924     0.200
     0.542     4.297     0.200
     0.553     4.529     0.200
     0.570     4.560     0.200
     0.636     4.506     0.200
     0.651     4.299     0.200
     0.677     4.759     0.200
     0.671     4.470     0.200
     0.670     5.285     0.200
     0.674     4.863     0.200
     0.677     4.854     0.200
     0.705     5.232     0.200
     0.713     4.820     0.200
     0.719     4.543     0.200
     0.721     4.982     0.200
     0.730     5.583     0.200
     0.748     5.691     0.200
     0.754     5.338     0.200
     0.753     5.725     0.200
     0.769     5.659     0.200
     0.804     5.104     0.200
     0.804     4.999     0.200
     0.846     5.377     0.200
     0.847     5.779     0.200
     0.863     6.164     0.200
     0.876     6.189     0.200
     0.938     6.210     0.200
     0.942     6.433     0.200
     0.955     4.768     0.200
     0.986     6.229     0.200
     1.000     6.064     0.200
     1.034     6.201     0.200
     1.109     6.409     0.200
     1.159     6.656     0.200
     1.219     6.841     0.200
     1.254     6.999     0.200
     1.306     7.031     0.200
     1.365     9.152     0.200
     0.209     2.670     0.200
     0.295     2.898     0.200
     0.355     2.980     0.200
     0.361     2.924     0.200
     0.427     3.791     0.200
     0.424     3.092     0.200
     0.452     4.008     0.200
     0.508     3.985     0.200
     0.543     4.324     0.200
     0.636     4.410     0.200
     0.652     4.345     0.200
     0.672     4.516     0.200
     0.674     4.956     0.200
     0.677     4.937     0.200
     0.706     5.440     0.200
     0.719     4.752     0.200
     0.722     5.038     0.200
     0.729     5.595     0.200
     0.755     5.634     0.200
     0.755     5.774     0.200
     0.804     5.426     0.200
     0.804     5.053     0.200
     1.143     8.423     0.200
     1.254     7.120     0.200
     1.601    11.036     0.200
     1.731    10.257     0.200
     1.740    10.418     0.200
     2.216    12.703     0.200
     0.151     1.802     0.200
     0.303     2.532     0.200
     0.307     2.676     0.200
     0.350     3.067     0.200
     0.347     3.376     0.200
     0.358     3.480     0.200
     0.401     3.726     0.200
     0.441     3.588     0.200
     0.446     3.827     0.200
     0.477     3.701     0.200
     0.507     3.924     0.200
     0.519     4.093     0.200
     0.551     3.961     0.200
     0.542     4.289     0.200
     0.556     3.730     0.200
     0.560     4.472     0.200
     0.569     4.504     0.200
     0.574     4.484     0.200
     0.610     4.346     0.200
     0.652     4.536     0.200
     0.652     4.696     0.200
     0.676     4.716     0.200
     0.695     5.106     0.200
     0.701     4.956     0.200
     0.717     5.617     0.200
     0.762     5.269     0.200
     0.762     5.515     0.200
     0.805     4.713     0.200
     0.843     5.745     0.200
     0.843     5.640     0.200
     0.879     5.743     0.200
     1.099     6.380     0.200
     1.220     6.765     0.200
     1.310     7.184     0.200
     1.407     7.358     0.200
     1.454    10.442     0.200
     1.592    11.462     0.200
     1.592    11.236     0.200
     1.638    11.496     0.200
     2.378    13.453     0.200
     0.058     1.527     0.200
     0.158     2.020     0.200
     0.197     2.433     0.200
     0.201     2.616     0.200
     0.208     2.095     0.200
     0.227     2.333     0.200
     0.260     3.096     0.200
     0.269     2.663     0.200
     0.364     3.626     0.200
     0.363     2.757     0.200
     0.360     3.031     0.200
     0.384     3.467     0.200
     0.384     3.283     0.200
     0.456     3.345     0.200
     0.456     3.395     0.200
     0.465     3.755     0.200
     0.487     3.499     0.200
     0.539     4.048     0.200
     0.572     4.273     0.200
     0.581     4.370     0.200
     0.604     4.502     0.200
     0.604     4.088     0.200
     0.617     4.311     0.200
     0.621     4.759     0.200
     0.675     5.158     0.200
     0.725     5.231     0.200
     0.734     5.305     0.200
     0.740     4.990     0.200
     0.761     5.516     0.200
     0.776     5.144     0.200
     0.791     4.758     0.200
     0.878     4.860     0.200
     0.880     5.751     0.200
     0.889     5.778     0.200
     0.889     5.559     0.200
     0.940     6.043     0.200
     0.954     5.598     0.200
     0.977     5.977     0.200
     0.978     6.240     0.200
     0.987     6.014     0.200
     0.981     5.922     0.200
     0.981     6.024     0.200
     1.079     6.349     0.200
     1.088     6.382     0.200
     1.154     6.474     0.200
     1.190     6.618     0.200
     1.219     6.855     0.200
     1.415     7.454     0.200
     1.454     8.806     0.200
     0.056     1.506     0.200
     0.161     1.953     0.200
     0.196     2.390     0.200
     0.203     2.495     0.200
     0.203     2.667     0.200
     0.206     2.051     0.200
     0.206     2.207     0.200
     0.269     2.629     0.200
     0.269     2.785     0.200
     0.257     3.149     0.200
     0.364     2.686     0.200
     0.359     2.962     0.200
     0.366     3.626     0.200
     0.366     3.774     0.200
     0.386     3.957     0.200
     0.387     3.169     0.200
     0.456     3.370     0.200
     0.455     3.428     0.200
     0.463     4.128     0.200
     0.489     3.429     0.200
     0.545     4.379     0.200
     0.542     4.113     0.200
     0.542     4.222     0.200
     0.572     4.250     0.200
     0.581     4.399     0.200
     0.581     4.508     0.200
     0.606     4.195     0.200
     0.619     5.481     0.200
     0.618     4.345     0.200
     0.619     4.880     0.200
     0.673     5.150     0.200
     0.732     5.279     0.200
     0.724     5.204     0.200
     0.738     5.039     0.200
     0.759     5.035     0.200
     0.773     5.235     0.200
     0.794     4.918     0.200
     0.877     5.932     0.200
     0.892     5.600     0.200
     0.938     6.132     0.200
     0.952     5.823     0.200
     0.976     6.693     0.200
     0.985     6.101     0.200
     0.985     6.210     0.200
     0.979     5.842     0.200
     0.979     6.092     0.200
     1.086     6.466     0.200
     1.154     6.563     0.200
     1.188     6.647     0.200
     1.284     7.016     0.200
     1.304     7.075     0.200
     1.389     7.491     0.200
     1.412     7.447     0.200
     1.454     8.549     0.200
     1.654    11.166     0.200
     1.796    12.477     0.200
     2.493    13.722     0.200
     7.748    38.693     0.200
     0.179     1.921     0.200
     0.293     2.987     0.200
     0.309     2.548     0.200
     0.345     2.875     0.200
     0.364     3.034     0.200
     0.365     3.004     0.200
     0.412     3.595     0.200
     0.412     3.509     0.200
     0.471     3.617     0.200
     0.477     4.243     0.200
     0.456     3.600     0.200
     0.488     3.901     0.200
     0.503     3.933     0.200
     0.487     3.427     0.200
     0.498     3.750     0.200
     0.501     3.708     0.200
     0.553     4.570     0.200
     0.526     4.164     0.200
     0.576     4.406     0.200
     0.596     4.289     0.200
     0.562     4.428     0.200
     0.605     4.036     0.200
     0.572     4.605     0.200
     0.583     4.666     0.200
     0.641     5.434     0.200
     0.644     4.969     0.200
     0.658     5.134     0.200
     0.672     4.957     0.200
     0.689     5.234     0.200
     0.756     5.271     0.200
     0.769     5.018     0.200
     0.755     5.489     0.200
     0.756     5.568     0.200
     0.795     5.315     0.200
     0.788     5.490     0.200
     0.822     5.533     0.200
     0.818     5.998     0.200
     0.866     5.519     0.200
     0.882     5.876     0.200
     0.853     6.144     0.200
     0.858     6.080     0.200
     0.870     6.249     0.200
     0.906     6.000     0.200
     0.899     6.329     0.200
     0.906     6.349     0.200
     0.940     5.774     0.200
     0.955     6.474     0.200
     0.976     6.525     0.200
     0.994     6.561     0.200
     1.036     5.619     0.200
     1.043     6.172     0.200
     1.371     7.040     0.200
     1.806    12.673     0.200
     1.933    11.792     0.200
     1.987    12.027     0.200
     2.006    10.868     0.200
     2.602    13.814     0.200
     2.633    13.326     0.200
     0.137     2.319     0.200
     0.144     1.679     0.200
     0.208     2.484     0.200
     0.244     2.148     0.200
     0.245     2.228     0.200
     0.276     2.896     0.200
     0.291     3.156     0.200
     0.316     3.129     0.200
     0.358     3.223     0.200
     0.374     3.147     0.200
     0.402     3.851     0.200
     0.406     3.556     0.200
     0.492     4.345     0.200
     0.515     3.746     0.200
     0.523     3.908     0.200
     0.541     4.224     0.200
     0.547     3.913     0.200
     0.544     4.294     0.200
     0.560     4.460     0.200
     0.611     4.026     0.200
     0.632     4.611     0.200
     0.657     5.381     0.200
     0.689     5.223     0.200
     0.713     4.826     0.200
     0.715     4.040     0.200
     0.715     4.548     0.200
     0.765     5.107     0.200
     0.765     4.599     0.200
     0.784     5.914     0.200
     0.799     5.364     0.200
     0.799     5.653     0.200
     0.804     5.001     0.200
     0.822     5.848     0.200
     0.972     5.517     0.200
     1.222     6.907     0.200
     1.232     6.978     0.200
     1.237     6.879     0.200
     1.242     6.955     0.200
     1.336     7.199     0.200
     1.618    11.639     0.200
     1.707    11.544     0.200
     0.121     2.206     0.200
     0.125     1.600     0.200
     0.142     2.214     0.200
     0.197     2.047     0.200
     0.269     2.414     0.200
     0.351     3.110     0.200
     0.367     3.275     0.200
     0.403     3.308     0.200
     0.454     3.466     0.200
     0.459     3.831     0.200
     0.501     3.642     0.200
     0.510     3.922     0.200
     0.498     3.576     0.200
     0.535     4.218     0.200
     0.557     4.744     0.200
     0.569     4.081     0.200
     0.590     4.406     0.200
     0.596     4.332     0.200
     0.586     4.188     0.200
     0.595     3.998     0.200
     0.585     4.215     0.200
     0.585     4.320     0.200
     0.600     4.110     0.200
     0.613     4.494     0.200
     0.624     4.431     0.200
     0.647     4.917     0.200
     0.643     4.873     0.200
     0.663     4.534     0.200
     0.659     4.866     0.200
     0.739     4.755     0.200
     0.996     5.924     0.200
     1.238     6.579     0.200
     1.396     6.826     0.200
     1.456     9.358     0.200
     1.766    11.431     0.200
     1.890    11.385     0.200
     2.073    11.289     0.200
     0.074     2.155     0.200
     0.100     2.243     0.200
     0.125     1.562     0.200
     0.125     1.953     0.200
     0.126     1.910     0.200
     0.121     2.338     0.200
     0.128     2.304     0.200
     0.190     1.583     0.200
     0.240     2.175     0.200
     0.199     2.509     0.200
     0.219     2.334     0.200
     0.315     2.822     0.200
     0.372     3.108     0.200
     0.391     3.447     0.200
     0.566     4.256     0.200
     0.606     4.412     0.200
     0.579     4.316     0.200
     0.577     4.827     0.200
     0.663     4.766     0.200
     0.689     4.619     0.200
     0.812     4.919     0.200
     0.812     5.146     0.200
     0.908     5.894     0.200
     0.896     6.816     0.200
     0.980     5.653     0.200
     1.434    10.209     0.200
     1.501     9.277     0.200
     1.627     9.032     0.200
     1.693    10.402     0.200
     1.997    12.479     0.200
     0.159     1.893     0.200
     0.211     2.433     0.200
     0.275     2.231     0.200
     0.283     2.587     0.200
     0.327     2.570     0.200
     0.327     2.700     0.200
     0.327     2.388     0.200
     0.327     2.662     0.200
     0.384     3.214     0.200
     0.383     3.122     0.200
     0.375     3.059     0.200
     0.448     3.667     0.200
     0.610     4.571     0.200
     0.549     4.243     0.200
     0.603     4.537     0.200
     0.601     4.490     0.200
     0.698     5.331     0.200
     0.663     4.955     0.200
     0.727     5.526     0.200
     0.744     5.626     0.200
     0.696     5.105     0.200
     0.767     5.681     0.200
     0.769     5.498     0.200
     0.792     5.591     0.200
     1.008     6.880     0.200
     1.067     6.168     0.200
     1.509    10.506     0.200
     1.533     9.135     0.200
     1.565     9.713     0.200
     1.652    10.104     0.200
     1.725    10.151     0.200
     1.700    10.580     0.200
     1.818    10.715     0.200
     0.156     1.924     0.200
     0.256     2.327     0.200
     0.259     2.058     0.200
     0.259     2.350     0.200
     0.266     2.357     0.200
     0.284     2.913     0.200
     0.274     2.597     0.200
     0.308     2.821     0.200
     0.324     2.957     0.200
     0.329     3.034     0.200
     0.348     2.907     0.200
     0.370     3.353     0.200
     0.397     3.280     0.200
     0.406     3.369     0.200
     0.419     3.179     0.200
     0.458     3.688     0.200
     0.477     4.141     0.200
     0.483     4.431     0.200
     0.473     3.785     0.200
     0.507     3.883     0.200
     0.573     4.315     0.200
     0.557     4.328     0.200
     0.589     4.180     0.200
     0.610     4.213     0.200
     0.592     4.514     0.200
     0.637     4.595     0.200
     0.599     4.393     0.200
     0.659     4.806     0.200
     0.648     4.629     0.200
     0.659     4.888     0.200
     0.665     4.358     0.200
     0.658     4.667     0.200
     0.677     4.543     0.200
     0.669     4.679     0.200
     0.696     4.838     0.200
     0.682     4.967     0.200
     0.720     4.796     0.200
     0.754     5.124     0.200
     0.774     5.267     0.200
     0.788     5.265     0.200
     0.777     5.765     0.200
     0.805     4.800     0.200
     0.841     5.228     0.200
     0.859     5.747     0.200
     0.882     4.976     0.200
     0.923     5.561     0.200
     1.042     5.793     0.200
     1.281     5.684     0.200
     1.279     6.371     0.200
     1.495     8.775     0.200
     1.548     8.685     0.200
     1.900    11.595     0.200
     7.390    36.911     0.200
     8.303    42.101     0.200
     0.106     1.466     0.200
     0.157     1.127     0.200
     0.175     1.615     0.200
     0.225     2.384     0.200
     0.292     2.953     0.200
     0.299     3.172     0.200
     0.304     3.040     0.200
     0.347     3.070     0.200
     0.347     3.461     0.200
     0.342     2.976     0.200
     0.411     2.951     0.200
     0.436     3.229     0.200
     0.478     4.653     0.200
     0.447     3.646     0.200
     0.460     3.760     0.200
     0.473     4.105     0.200
     0.535     4.611     0.200
     0.590     4.877     0.200
     0.596     4.732     0.200
     0.618     4.659     0.200
     0.617     5.165     0.200
     0.705     5.124     0.200
     0.715     5.129     0.200
     0.697     5.040     0.200
     0.701     5.232     0.200
     0.708     5.245     0.200
     0.708     5.544     0.200
     0.708     5.018     0.200
     0.731     5.121     0.200
     0.752     5.272     0.200
     0.775     6.083     0.200
     0.829     5.422     0.200
     0.925     5.834     0.200
     0.966     6.620     0.200
     0.968     6.701     0.200
     0.978     6.680     0.200
     1.003     6.744     0.200
     1.003     6.724     0.200
     1.052     7.179     0.200
     1.078     7.220     0.200
     1.079     7.036     0.200
     1.095     7.996     0.200
     1.190     7.182     0.200
     1.276     7.213     0.200
     1.457     7.950     0.200
     7.691    38.607     0.200
     0.154     2.007     0.200
     0.211     2.516     0.200
     0.280     2.371     0.200
     0.282     2.665     0.200
     0.292     2.549     0.200
     0.332     2.614     0.200
     0.332     2.794     0.200
     0.335     2.687     0.200
     0.370     3.088     0.200
     0.387     3.119     0.200
     0.387     3.263     0.200
     0.450     3.705     0.200
     0.487     3.909     0.200
     0.545     4.393     0.200
     0.552     4.295     0.200
     0.611     4.611     0.200
     0.598     4.570     0.200
     0.605     4.572     0.200
     0.663     4.970     0.200
     0.668     4.841     0.200
     0.702     5.500     0.200
     0.725     5.493     0.200
     0.732     5.602     0.200
     0.747     5.663     0.200
     0.768     5.496     0.200
     0.794     5.644     0.200
     0.816     6.180     0.200
     0.841     5.731     0.200
     0.903     6.490     0.200
     0.942     6.713     0.200
     1.071     6.252     0.200
     1.099     8.008     0.200
     1.538     9.017     0.200
     1.564     9.026     0.200
     1.699    10.481     0.200
     1.912    12.394     0.200
     2.856    16.631     0.200
     2.967    15.885     0.200
     0.055     0.525     0.200
     0.105     1.273     0.200
     0.149     2.408     0.200
     0.225     2.065     0.200
     0.229     2.184     0.200
     0.286     2.994     0.200
     0.319     2.957     0.200
     0.323     3.266     0.200
     0.364     3.640     0.200
     0.364     3.044     0.200
     0.376     3.362     0.200
     0.514     4.318     0.200
     0.524     4.540     0.200
     0.534     3.583     0.200
     0.549     4.035     0.200
     0.583     3.886     0.200
     0.578     4.430     0.200
     0.579     4.309     0.200
     0.599     4.475     0.200
     0.617     4.481     0.200
     0.639     4.931     0.200
     0.662     4.911     0.200
     0.691     4.361     0.200
     0.691     4.462     0.200
     0.694     5.227     0.200
     0.765     4.607     0.200
     0.802     5.119     0.200
     0.800     5.776     0.200
     0.834     5.479     0.200
     0.834     5.682     0.200
     0.843     5.848     0.200
     0.918     5.993     0.200
     0.929     6.225     0.200
     0.933     6.355     0.200
     0.973     6.163     0.200
     0.984     6.151     0.200
     1.036     6.269     0.200
     1.107     6.601     0.200
     1.124     7.030     0.200
     1.150     6.730     0.200
     1.183     7.136     0.200
     1.379     7.206     0.200
     1.716    11.245     0.200
     0.193     1.431     0.200
     0.199     1.588     0.200
     0.224     2.472     0.200
     0.227     2.232     0.200
     0.231     2.422     0.200
     0.276     2.536     0.200
     0.313     3.019     0.200
     0.340     2.490     0.200
     0.340     2.313     0.200
     0.343     2.463     0.200
     0.330     3.424     0.200
     0.330     3.169     0.200
     0.402     3.280     0.200
     0.417     2.881     0.200
     0.437     3.705     0.200
     0.460     4.218     0.200
     0.465     4.337     0.200
     0.481     4.083     0.200
     0.501     4.008     0.200
     0.508     4.058     0.200
     0.527     4.538     0.200
     0.558     4.579     0.200
     0.580     4.532     0.200
     0.585     4.392     0.200
     0.608     5.208     0.200
     0.626     4.991     0.200
     0.626     4.991     0.200
     0.648     5.026     0.200
     0.673     5.330     0.200
     0.677     5.269     0.200
     0.670     5.488     0.200
     0.689     5.246     0.200
     0.700     5.138     0.200
     0.726     5.651     0.200
     0.733     5.856     0.200
     0.733     5.746     0.200
     0.723     5.971     0.200
     0.741     5.428     0.200
     0.730     5.738     0.200
     0.735     5.965     0.200
     0.739     5.984     0.200
     0.801     5.800     0.200
     0.791     6.195     0.200
     0.805     6.062     0.200
     0.808     6.207     0.200
     0.827     6.016     0.200
     0.865     6.121     0.200
     0.866     6.252     0.200
     0.872     6.290     0.200
     0.872     6.135     0.200
     0.881     6.799     0.200
     0.916     7.149     0.200
     0.908     6.280     0.200
     0.921     6.308     0.200
     0.911     6.316     0.200
     0.928     6.885     0.200
     0.910     7.417     0.200
     0.921     6.767     0.200
     0.933     7.014     0.200
     0.978     7.000     0.200
     1.012     6.970     0.200
     1.020     7.350     0.200
     1.029     7.085     0.200
     1.165     7.760     0.200
     1.165     7.574     0.200
     1.244     8.229     0.200
     1.326     8.619     0.200
     1.325     8.995     0.200
     0.136     1.694     0.200
     0.154     1.596     0.200
     0.176     1.730     0.200
     0.280     2.692     0.200
     0.257     2.658     0.200
     0.278     2.795     0.200
     0.340     3.222     0.200
     0.387     3.216     0.200
     0.385     3.050     0.200
     0.378     2.645     0.200
     0.378     2.950     0.200
     0.342     3.518     0.200
     0.357     3.712     0.200
     0.380     3.930     0.200
     0.425     4.096     0.200
     0.435     3.383     0.200
     0.457     3.654     0.200
     0.479     3.456     0.200
     0.505     4.642     0.200
     0.546     4.638     0.200
     0.580     4.589     0.200
     0.563     4.660     0.200
     0.601     4.873     0.200
     0.669     4.657     0.200
     0.614     4.340     0.200
     0.638     4.941     0.200
     0.643     4.960     0.200
     0.631     4.711     0.200
     0.690     4.757     0.200
     0.661     4.681     0.200
     0.697     5.284     0.200
     0.732     4.994     0.200
     0.708     4.991     0.200
     0.736     5.659     0.200
     0.781     5.309     0.200
     0.745     5.138     0.200
     0.745     4.926     0.200
     0.803     5.977     0.200
     0.774     5.416     0.200
     0.852     5.611     0.200
     0.835     4.870     0.200
     0.894     5.919     0.200
     0.863     5.870     0.200
     0.908     6.228     0.200
     0.890     5.391     0.200
     0.948     6.176     0.200
     0.992     6.716     0.200
     1.016     6.840     0.200
     1.015     6.654     0.200
     1.033     7.211     0.200
     0.976     5.708     0.200
     1.039     6.322     0.200
     1.222     7.791     0.200
     2.162    11.668     0.200
     5.714    28.336     0.200
     7.731    37.975     0.200
     0.148     2.186     0.200
     0.180     2.389     0.200
     0.224     2.559     0.200
     0.227     2.842     0.200
     0.230     2.578     0.200
     0.238     2.604     0.200
     0.257     2.731     0.200
     0.275     2.387     0.200
     0.274     3.051     0.200
     0.274     2.931     0.200
     0.293     2.532     0.200
     0.293     3.022     0.200
     0.301     2.490     0.200
     0.333     3.606     0.200
     0.338     2.904     0.200
     0.364     2.693     0.200
     0.376     3.268     0.200
     0.386     2.828     0.200
     0.420     3.036     0.200
     0.420     3.200     0.200
     0.465     3.126     0.200
     0.486     4.010     0.200
     0.479     3.724     0.200
     0.497     3.982     0.200
     0.512     3.605     0.200
     0.513     3.827     0.200
     0.513     3.950     0.200
     0.544     4.514     0.200
     0.553     4.212     0.200
     0.554     4.074     0.200
     0.561     4.451     0.200
     0.604     3.857     0.200
     0.661     4.632     0.200
     0.681     4.870     0.200
     0.703     5.362     0.200
     0.787     4.510     0.200
     0.830     5.057     0.200
     0.837     5.200     0.200
     0.850     5.302     0.200
     1.036     5.642     0.200
     1.056     5.848     0.200
     1.060     5.781     0.200
     1.060     5.942     0.200
     1.060     5.666     0.200
     1.192     5.955     0.200
     1.277     6.639     0.200
     1.282     6.784     0.200
     2.115    10.682     0.200
     0.112     1.570     0.200
     0.348     3.165     0.200
     0.393     3.239     0.200
     0.445     3.559     0.200
     0.440     3.172     0.200
     0.442     3.798     0.200
     0.510     3.663     0.200
     0.511     3.576     0.200
     0.511     3.717     0.200
     0.512     3.736     0.200
     0.612     4.380     0.200
     0.643     4.744     0.200
     0.677     4.922     0.200
     0.682     5.424     0.200
     0.692     5.391     0.200
     0.713     5.456     0.200
     0.769     5.400     0.200
     0.785     5.474     0.200
     0.788     5.601     0.200
     0.848     5.973     0.200
     0.878     6.106     0.200
     1.293     6.752     0.200
     1.388     7.354     0.200
     1.413     7.205     0.200
     0.247     2.864     0.200
     0.306     2.986     0.200
     0.317     2.904     0.200
     0.329     3.155     0.200
     0.370     3.023     0.200
     0.374     3.741     0.200
     0.408     3.243     0.200
     0.412     3.222     0.200
     0.418     3.278     0.200
     0.414     3.730     0.200
     0.436     3.206     0.200
     0.496     3.950     0.200
     0.504     4.423     0.200
     0.516     4.414     0.200
     0.523     4.086     0.200
     0.557     4.026     0.200
     0.588     4.777     0.200
     0.607     4.750     0.200
     0.601     4.260     0.200
     0.601     4.428     0.200
     0.633     5.367     0.200
     0.655     5.123     0.200
     0.716     4.831     0.200
     0.722     4.767     0.200
     0.720     5.343     0.200
     0.726     5.646     0.200
     0.759     5.168     0.200
     0.757     5.172     0.200
     0.775     5.727     0.200
     0.790     5.394     0.200
     0.788     5.681     0.200
     0.796     5.190     0.200
     0.794     6.062     0.200
     0.876     6.118     0.200
     0.928     5.702     0.200
     0.963     6.575     0.200
     0.989     6.567     0.200
     0.999     6.699     0.200
     1.022     6.533     0.200
     1.033     7.253     0.200
     1.136     7.425     0.200
     1.274     7.491     0.200
     1.318     8.823     0.200
     0.181     2.194     0.200
     0.306     2.989     0.200
     0.315     2.863     0.200
     0.365     3.001     0.200
     0.375     3.587     0.200
     0.412     3.129     0.200
     0.421     3.202     0.200
     0.406     3.235     0.200
     0.421     3.572     0.200
     0.432     3.185     0.200
     0.501     3.796     0.200
     0.506     4.300     0.200
     0.519     4.181     0.200
     0.529     4.102     0.200
     0.560     3.948     0.200
     0.588     4.597     0.200
     0.605     4.336     0.200
     0.605     4.222     0.200
     0.633     5.160     0.200
     0.653     5.089     0.200
     0.685     5.135     0.200
     0.719     4.729     0.200
     0.726     4.761     0.200
     0.724     5.476     0.200
     0.732     5.461     0.200
     0.742     5.311     0.200
     0.757     5.127     0.200
     0.762     5.015     0.200
     0.775     5.472     0.200
     0.792     5.403     0.200
     0.799     5.864     0.200
     0.793     5.136     0.200
     0.792     5.602     0.200
     0.856     5.996     0.200
     0.872     5.929     0.200
     0.863     6.355     0.200
     0.926     5.680     0.200
     0.957     6.694     0.200
     1.005     6.659     0.200
     0.993     6.493     0.200
     1.034     7.259     0.200
     1.028     6.537     0.200
     1.130     6.816     0.200
     1.280     7.572     0.200
     1.313     9.210     0.200
     5.445    27.593     0.200
     0.162     1.878     0.200
     0.169     1.785     0.200
     0.185     1.907     0.200
     0.134     1.814     0.200
     0.162     1.476     0.200
     0.209     2.071     0.200
     0.165     2.072     0.200
     0.195     2.122     0.200
     0.314     2.490     0.200
     0.406     3.768     0.200
     0.387     2.766     0.200
     0.366     3.483     0.200
     0.463     3.849     0.200
     0.501     4.191     0.200
     0.583     4.460     0.200
     0.617     5.131     0.200
     0.572     4.407     0.200
     0.574     4.702     0.200
     0.632     5.281     0.200
     0.648     5.438     0.200
     0.722     5.205     0.200
     0.677     5.190     0.200
     0.767     6.045     0.200
     0.776     5.459     0.200
     0.726     5.372     0.200
     0.820     5.654     0.200
     0.954     6.700     0.200
     1.207     8.314     0.200
     1.708     9.811     0.200
     1.735    10.195     0.200
     0.126     1.790     0.200
     0.193     1.643     0.200
     0.225     2.260     0.200
     0.324     3.373     0.200
     0.458     3.670     0.200
     0.465     3.971     0.200
     0.486     4.197     0.200
     0.565     4.375     0.200
     0.583     4.660     0.200
     0.608     4.643     0.200
     0.664     5.407     0.200
     0.675     5.153     0.200
     0.697     5.271     0.200
     0.760     5.525     0.200
     0.753     5.512     0.200
     0.779     5.518     0.200
     0.781     5.410     0.200
     0.787     5.790     0.200
     0.799     6.018     0.200
     0.809     5.646     0.200
     0.818     5.631     0.200
     0.814     5.603     0.200
     0.843     6.167     0.200
     0.861     6.508     0.200
     0.863     6.272     0.200
     0.878     6.067     0.200
     0.890     6.677     0.200
     0.902     6.423     0.200
     0.899     5.922     0.200
     0.908     6.187     0.200
     0.898     5.931     0.200
     0.902     6.713     0.200
     0.921     6.315     0.200
     0.973     6.080     0.200
     0.984     6.745     0.200
     0.989     6.320     0.200
     1.016     6.858     0.200
     1.066     6.237     0.200
     1.318     7.271     0.200
     0.081     1.110     0.200
     0.157     1.876     0.200
     0.212     1.997     0.200
     0.284     2.596     0.200
     0.294     2.910     0.200
     0.310     3.316     0.200
     0.279     1.907     0.200
     0.366     3.077     0.200
     0.414     3.320     0.200
     0.414     3.738     0.200
     0.438     3.722     0.200
     0.521     4.217     0.200
     0.488     4.006     0.200
     0.532     4.479     0.200
     0.545     3.963     0.200
     0.526     4.191     0.200
     0.517     4.212     0.200
     0.538     3.993     0.200
     0.554     4.349     0.200
     0.552     4.334     0.200
     0.593     4.256     0.200
     0.579     4.756     0.200
     0.592     4.084     0.200
     0.662     4.949     0.200
     0.671     4.656     0.200
     0.696     5.321     0.200
     0.690     4.607     0.200
     0.706     4.853     0.200
     0.773     5.189     0.200
     0.810     5.489     0.200
     0.810     5.379     0.200
     0.818     5.042     0.200
     0.851     5.628     0.200
     1.011     6.197     0.200
     1.047     7.447     0.200
     1.081     6.615     0.200
     1.115     6.624     0.200
     1.082     7.417     0.200
     1.211     6.914     0.200
     1.232     7.435     0.200
     1.459    10.060     0.200
     0.365     3.337     0.200
     0.378     3.508     0.200
     0.402     3.764     0.200
     0.424     3.682     0.200
     0.447     3.061     0.200
     0.492     3.495     0.200
     0.492     3.238     0.200
     0.513     4.106     0.200
     0.526     4.375     0.200
     0.558     3.950     0.200
     0.565     4.420     0.200
     0.620     4.636     0.200
     0.651     3.853     0.200
     0.629     4.391     0.200
     0.634     4.117     0.200
     0.659     4.730     0.200
     0.675     4.354     0.200
     0.662     4.439     0.200
     0.679     4.730     0.200
     0.686     5.380     0.200
     0.691     4.594     0.200
     0.693     4.572     0.200
     0.693     4.455     0.200
     0.717     5.035     0.200
     0.726     5.187     0.200
     0.752     4.760     0.200
     0.747     5.201     0.200
     0.768     4.728     0.200
     0.778     4.933     0.200
     0.782     5.479     0.200
     0.785     5.092     0.200
     0.810     5.571     0.200
     0.852     4.548     0.200
     0.846     5.475     0.200
     0.875     5.366     0.200
     0.875     4.935     0.200
     0.895     5.753     0.200
     0.899     5.557     0.200
     0.913     5.162     0.200
     0.974     6.007     0.200
     0.971     5.914     0.200
     0.999     5.249     0.200
     1.018     6.559     0.200
     2.142    12.148     0.200
     7.731    36.495     0.200
     0.092     1.731     0.200
     0.102     1.194     0.200
     0.114     1.635     0.200
     0.104     1.770     0.200
     0.153     1.460     0.200
     0.179     1.661     0.200
     0.229     2.383     0.200
     0.248     2.551     0.200
     0.324     2.489     0.200
     0.381     3.461     0.200
     0.435     3.798     0.200
     0.448     3.549     0.200
     0.507     4.724     0.200
     0.590     4.532     0.200
     0.637     4.185     0.200
     0.676     5.219     0.200
     0.682     4.462     0.200
     0.712     5.224     0.200
     0.715     5.084     0.200
     0.772     5.008     0.200
     0.775     5.782     0.200
     0.780     5.942     0.200
     0.803     5.344     0.200
     0.826     6.103     0.200
     0.831     6.186     0.200
     0.909     5.261     0.200
     0.993     6.128     0.200
     0.104     0.936     0.200
     0.106     0.239     0.200
     0.113     1.453     0.200
     0.172     1.330     0.200
     0.162     1.237     0.200
     0.163     2.486     0.200
     0.240     2.124     0.200
     0.315     2.928     0.200
     0.373     3.080     0.200
     0.401     3.431     0.200
     0.394     3.438     0.200
     0.423     3.236     0.200
     0.457     3.360     0.200
     0.444     3.619     0.200
     0.459     3.450     0.200
     0.457     3.740     0.200
     0.463     3.712     0.200
     0.512     3.848     0.200
     0.602     4.340     0.200
     0.610     5.117     0.200
     0.590     4.857     0.200
     0.630     4.793     0.200
     0.628     4.549     0.200
     0.687     4.898     0.200
     0.681     5.123     0.200
     0.717     5.754     0.200
     0.712     7.191     0.200
     0.716     5.645     0.200
     0.719     5.474     0.200
     0.719     5.755     0.200
     0.719     5.587     0.200
     0.770     4.741     0.200
     0.761     5.673     0.200
     0.798     5.818     0.200
     0.783     6.181     0.200
     0.782     5.704     0.200
     0.784     5.675     0.200
     0.809     5.946     0.200
     0.829     6.510     0.200
     0.833     6.412     0.200
     0.899     6.455     0.200
     0.911     6.486     0.200
     0.967     6.966     0.200
     0.987     6.947     0.200
     1.020     7.141     0.200
     0.090     1.167     0.200
     0.102     0.623     0.200
     0.101     1.707     0.200
     0.112     1.660     0.200
     0.154     1.506     0.200
     0.174     2.334     0.200
     0.237     2.590     0.200
     0.243     2.790     0.200
     0.318     2.735     0.200
     0.321     2.631     0.200
     0.371     3.406     0.200
     0.405     3.790     0.200
     0.408     3.617     0.200
     0.433     3.523     0.200
     0.449     3.735     0.200
     0.445     3.823     0.200
     0.448     3.575     0.200
     0.454     3.756     0.200
     0.470     4.049     0.200
     0.468     4.043     0.200
     0.496     4.182     0.200
     0.496     4.373     0.200
     0.525     4.136     0.200
     0.605     4.330     0.200
     0.603     4.694     0.200
     0.609     5.011     0.200
     0.621     4.663     0.200
     0.635     4.531     0.200
     0.637     4.926     0.200
     0.668     4.620     0.200
     0.690     4.766     0.200
     0.726     5.833     0.200
     0.722     5.050     0.200
     0.729     5.309     0.200
     0.758     5.023     0.200
     0.774     5.731     0.200
     0.790     5.164     0.200
     0.798     5.728     0.200
     0.821     6.103     0.200
     0.840     6.199     0.200
     0.899     5.114     0.200
     0.914     6.381     0.200
     0.923     6.281     0.200
     0.996     6.301     0.200
     1.011     7.116     0.200
     1.030     6.306     0.200
     1.075     6.310     0.200
     1.092     6.869     0.200
     1.098     7.635     0.200
     1.111     6.775     0.200
     1.167     6.927     0.200
     1.165     6.942     0.200
     1.178     6.792     0.200
     1.243     7.315     0.200
     1.299     7.355     0.200
     1.657    11.904     0.200
     0.093     1.120     0.200
     0.078     1.660     0.200
     0.089     1.778     0.200
     0.124     2.629     0.200
     0.135     1.481     0.200
     0.188     1.704     0.200
     0.190     2.256     0.200
     0.236     2.774     0.200
     0.260     2.484     0.200
     0.338     2.941     0.200
     0.342     2.625     0.200
     0.395     3.488     0.200
     0.408     3.648     0.200
     0.427     3.912     0.200
     0.430     3.342     0.200
     0.450     3.432     0.200
     0.472     3.765     0.200
     0.445     4.114     0.200
     0.469     3.995     0.200
     0.519     4.429     0.200
     0.519     4.339     0.200
     0.516     4.202     0.200
     0.598     4.368     0.200
     0.640     4.630     0.200
     0.660     5.123     0.200
     0.655     4.538     0.200
     0.682     4.571     0.200
     0.673     4.809     0.200
     0.713     4.995     0.200
     0.714     5.247     0.200
     0.714     5.091     0.200
     0.769     4.990     0.200
     0.761     5.893     0.200
     0.775     5.800     0.200
     0.809     5.369     0.200
     0.782     5.491     0.200
     0.922     5.132     0.200
     1.009     5.909     0.200
     1.075     6.482     0.200
     1.287     7.172     0.200
     2.661    15.161     0.200
     0.140     2.092     0.200
     0.302     2.313     0.200
     0.339     2.679     0.200
     0.340     2.691     0.200
     0.346     2.730     0.200
     0.356     3.003     0.200
     0.344     3.290     0.200
     0.352     3.088     0.200
     0.347     2.750     0.200
     0.424     3.510     0.200
     0.431     3.603     0.200
     0.457     3.678     0.200
     0.470     3.835     0.200
     0.459     3.979     0.200
     0.481     3.861     0.200
     0.475     4.191     0.200
     0.504     4.055     0.200
     0.501     4.219     0.200
     0.524     4.156     0.200
     0.526     4.395     0.200
     0.526     4.381     0.200
     0.549     4.462     0.200
     0.581     4.618     0.200
     0.588     5.047     0.200
     0.592     4.852     0.200
     0.623     4.858     0.200
     0.687     5.057     0.200
     0.680     5.069     0.200
     0.704     5.548     0.200
     0.741     5.604     0.200
     0.756     5.830     0.200
     0.774     5.947     0.200
     0.762     5.817     0.200
     0.801     6.214     0.200
     0.814     6.381     0.200
     0.803     5.926     0.200
     0.844     5.869     0.200
     0.849     6.363     0.200
     0.880     6.540     0.200
     0.880     6.373     0.200
     0.898     6.458     0.200
     0.975     7.132     0.200
     1.047     7.022     0.200
     1.048     7.126     0.200
     1.039     7.216     0.200
     1.038     8.045     0.200
     1.043     7.931     0.200
     1.071     7.404     0.200
     1.075     7.665     0.200
     1.094     7.731     0.200
     1.122     7.202     0.200
     1.124     6.901     0.200
     1.124     8.075     0.200
     1.164     7.436     0.200
     1.145     8.311     0.200
     1.169     8.414     0.200
     1.285     8.466     0.200
     1.293     9.189     0.200
     1.320     8.163     0.200
     1.322     9.047     0.200
     0.122     2.088     0.200
     0.206     2.092     0.200
     0.276     3.014     0.200
     0.316     2.404     0.200
     0.307     2.943     0.200
     0.323     3.009     0.200
     0.333     3.411     0.200
     0.355     2.916     0.200
     0.345     3.055     0.200
     0.395     3.661     0.200
     0.410     3.170     0.200
     0.445     3.462     0.200
     0.480     3.521     0.200
     0.533     3.645     0.200
     0.606     4.527     0.200
     0.581     4.316     0.200
     0.597     4.531     0.200
     0.619     4.533     0.200
     0.660     5.139     0.200
     0.677     4.751     0.200
     0.686     4.843     0.200
     0.716     4.921     0.200
     0.817     5.050     0.200
     0.881     5.553     0.200
     0.907     6.286     0.200
     0.910     5.265     0.200
     0.910     6.179     0.200
     0.947     5.982     0.200
     0.982     6.793     0.200
     0.994     7.295     0.200
     1.006     6.538     0.200
     1.144     7.738     0.200
     1.172     7.835     0.200
     0.031     0.261     0.200
     0.163     1.716     0.200
     0.197     2.124     0.200
     0.208     2.012     0.200
     0.216     2.594     0.200
     0.317     2.863     0.200
     0.312     2.635     0.200
     0.348     3.248     0.200
     0.342     3.028     0.200
     0.385     3.664     0.200
     0.453     3.338     0.200
     0.488     3.386     0.200
     0.538     3.696     0.200
     0.587     4.622     0.200
     0.614     4.673     0.200
     0.608     4.600     0.200
     0.647     5.101     0.200
     0.654     4.929     0.200
     0.690     4.216     0.200
     0.674     4.938     0.200
     0.709     5.148     0.200
     0.897     6.340     0.200
     0.900     5.561     0.200
     0.900     6.193     0.200
     0.971     6.906     0.200
     0.993     6.636     0.200
     1.080     7.345     0.200
     1.090     7.161     0.200
     1.121     7.863     0.200
     1.140     7.959     0.200
     1.161     8.112     0.200
     0.024     0.682     0.200
     0.157     1.814     0.200
     0.199     1.893     0.200
     0.212     2.118     0.200
     0.230     2.635     0.200
     0.238     2.461     0.200
     0.281     3.045     0.200
     0.315     3.013     0.200
     0.309     2.302     0.200
     0.351     3.079     0.200
     0.347     2.807     0.200
     0.392     3.586     0.200
     0.418     3.217     0.200
     0.446     3.547     0.200
     0.494     4.104     0.200
     0.488     3.524     0.200
     0.532     3.710     0.200
     0.604     4.678     0.200
     0.611     4.658     0.200
     0.607     4.376     0.200
     0.652     5.000     0.200
     0.660     4.982     0.200
     0.681     5.055     0.200
     0.683     4.501     0.200
     0.716     4.660     0.200
     0.821     5.458     0.200
     0.878     5.410     0.200
     0.889     5.698     0.200
     0.904     5.957     0.200
     0.907     5.842     0.200
     0.975     6.166     0.200
     0.976     6.541     0.200
     1.001     6.412     0.200
     0.999     6.479     0.200
     1.078     7.003     0.200
     1.084     6.709     0.200
     1.097     6.677     0.200
     1.087     6.388     0.200
     1.127     7.289     0.200
     1.161     7.250     0.200
     1.138     7.810     0.200
     1.164     7.953     0.200
     1.204     7.285     0.200
     1.206     7.470     0.200
     1.741    11.817     0.200
     0.024     0.718     0.200
     0.195     1.948     0.200
     0.193     2.688     0.200
     0.208     2.015     0.200
     0.226     2.626     0.200
     0.223     2.307     0.200
     0.280     3.170     0.200
     0.311     2.964     0.200
     0.314     2.278     0.200
     0.329     3.393     0.200
     0.347     2.992     0.200
     0.414     3.181     0.200
     0.392     3.452     0.200
     0.484     3.509     0.200
     0.492     4.011     0.200
     0.534     3.628     0.200
     0.608     4.350     0.200
     0.615     4.547     0.200
     0.682     4.497     0.200
     0.714     4.923     0.200
     0.821     5.040     0.200
     0.878     5.669     0.200
     0.907     6.002     0.200
     0.971     6.218     0.200
     1.000     6.242     0.200
     1.001     6.324     0.200
     1.084     6.719     0.200
     0.030     2.832     0.200
     0.113     2.063     0.200
     0.160     1.897     0.200
     0.188     2.797     0.200
     0.206     2.118     0.200
     0.219     2.417     0.200
     0.286     3.059     0.200
     0.345     3.016     0.200
     0.313     3.189     0.200
     0.323     3.178     0.200
     0.345     2.876     0.200
     0.385     3.539     0.200
     0.417     3.186     0.200
     0.485     3.557     0.200
     0.600     4.685     0.200
     0.611     4.673     0.200
     0.687     4.244     0.200
     0.708     4.819     0.200
     0.827     5.337     0.200
     0.872     5.356     0.200
     0.877     5.068     0.200
     0.893     7.462     0.200
     0.901     5.597     0.200
     0.901     5.737     0.200
     0.969     6.141     0.200
     0.970     6.457     0.200
     0.994     6.278     0.200
     0.996     6.268     0.200
     1.087     6.455     0.200
     1.143     6.491     0.200
     0.170     2.080     0.200
     0.207     2.114     0.200
     0.211     2.348     0.200
     0.234     2.764     0.200
     0.303     3.082     0.200
     0.295     3.133     0.200
     0.314     3.101     0.200
     0.321     3.087     0.200
     0.313     2.240     0.200
     0.347     3.284     0.200
     0.336     2.794     0.200
     0.378     3.505     0.200
     0.425     3.269     0.200
     0.460     3.481     0.200
     0.490     3.616     0.200
     0.544     3.640     0.200
     0.604     4.547     0.200
     0.622     4.295     0.200
     0.667     4.880     0.200
     0.702     4.892     0.200
     0.697     4.147     0.200
     0.836     5.286     0.200
     0.863     5.389     0.200
     0.892     6.110     0.200
     0.892     5.586     0.200
     0.019     1.060     0.200
     0.149     1.913     0.200
     0.207     2.285     0.200
     0.223     2.637     0.200
     0.231     2.417     0.200
     0.228     2.491     0.200
     0.274     2.955     0.200
     0.307     2.993     0.200
     0.315     2.424     0.200
     0.324     3.218     0.200
     0.347     2.755     0.200
     0.334     3.287     0.200
     0.355     3.010     0.200
     0.397     3.617     0.200
     0.410     3.162     0.200
     0.443     3.439     0.200
     0.481     3.583     0.200
     0.495     4.075     0.200
     0.531     3.621     0.200
     0.582     4.313     0.200
     0.598     4.622     0.200
     0.603     4.286     0.200
     0.619     4.782     0.200
     0.660     5.143     0.200
     0.676     4.267     0.200
     0.668     4.834     0.200
     0.688     4.941     0.200
     0.718     4.957     0.200
     0.836     5.238     0.200
     0.890     5.853     0.200
     0.883     5.310     0.200
     0.904     5.425     0.200
     0.909     5.441     0.200
     0.912     5.158     0.200
     0.912     5.974     0.200
     0.972     6.406     0.200
     1.007     6.247     0.200
     1.080     6.488     0.200
     1.597    11.100     0.200
     0.037     0.953     0.200
     0.102     1.947     0.200
     0.170     2.114     0.200
     0.186     2.738     0.200
     0.202     2.028     0.200
     0.213     2.089     0.200
     0.239     2.738     0.200
     0.251     2.555     0.200
     0.295     3.132     0.200
     0.303     3.035     0.200
     0.313     3.075     0.200
     0.324     3.115     0.200
     0.307     2.327     0.200
     0.335     2.826     0.200
     0.352     3.069     0.200
     0.381     3.568     0.200
     0.428     3.292     0.200
     0.456     3.568     0.200
     0.486     4.045     0.200
     0.495     3.673     0.200
     0.539     3.729     0.200
     0.592     4.369     0.200
     0.609     4.770     0.200
     0.600     4.635     0.200
     0.618     4.377     0.200
     0.647     4.741     0.200
     0.667     4.843     0.200
     0.707     4.940     0.200
     0.697     4.399     0.200
     0.830     5.692     0.200
     0.834     5.070     0.200
     0.866     5.380     0.200
     0.881     5.977     0.200
     0.888     5.540     0.200
     0.892     5.739     0.200
     0.895     5.871     0.200
     0.895     5.683     0.200
     0.885     4.955     0.200
     0.935     6.050     0.200
     0.970     6.254     0.200
     0.975     6.077     0.200
     0.982     6.259     0.200
     0.990     6.379     0.200
     0.986     6.275     0.200
     1.054     6.265     0.200
     1.068     6.403     0.200
     1.084     6.573     0.200
     1.089     6.726     0.200
     1.098     6.592     0.200
     1.098     6.372     0.200
     1.122     6.542     0.200
     1.135     8.520     0.200
     1.165     7.067     0.200
     1.154     7.975     0.200
     1.193     6.749     0.200
     1.203     7.390     0.200
     1.261     6.952     0.200
     1.308     6.913     0.200
     1.316     7.034     0.200
     1.363     7.228     0.200
     1.737    11.674     0.200
     0.030     2.210     0.200
     0.167     1.928     0.200
     0.213     2.128     0.200
     0.225     2.171     0.200
     0.245     2.791     0.200
     0.288     2.908     0.200
     0.295     2.163     0.200
     0.309     3.036     0.200
     0.318     3.092     0.200
     0.329     3.116     0.200
     0.336     2.743     0.200
     0.365     3.109     0.200
     0.393     3.691     0.200
     0.432     3.279     0.200
     0.443     3.497     0.200
     0.500     4.136     0.200
     0.503     3.749     0.200
     0.525     3.664     0.200
     0.570     4.588     0.200
     0.603     4.437     0.200
     0.598     4.522     0.200
     0.606     4.328     0.200
     0.641     4.860     0.200
     0.652     4.795     0.200
     0.675     4.744     0.200
     0.691     4.838     0.200
     0.721     4.953     0.200
     0.845     5.688     0.200
     0.877     5.630     0.200
     0.896     5.895     0.200
     0.904     5.870     0.200
     0.907     5.907     0.200
     0.988     6.158     0.200
     0.991     6.083     0.200
     1.003     6.518     0.200
     1.136     6.628     0.200
     0.167     2.011     0.200
     0.224     2.233     0.200
     0.243     2.527     0.200
     0.244     2.797     0.200
     0.288     3.067     0.200
     0.296     2.276     0.200
     0.308     3.111     0.200
     0.318     3.135     0.200
     0.336     2.792     0.200
     0.364     3.101     0.200
     0.393     3.649     0.200
     0.431     3.318     0.200
     0.444     3.495     0.200
     0.502     3.689     0.200
     0.499     4.135     0.200
     0.525     3.669     0.200
     0.602     4.487     0.200
     0.598     4.522     0.200
     0.606     4.335     0.200
     0.618     4.676     0.200
     0.675     5.019     0.200
     0.691     4.310     0.200
     0.720     4.971     0.200
     0.825     4.967     0.200
     0.876     5.544     0.200
     0.907     5.747     0.200
     0.991     6.037     0.200
     1.101     6.383     0.200
     1.150     6.422     0.200
     1.727    11.611     0.200
     0.027     1.041     0.200
     0.164     2.037     0.200
     0.210     2.121     0.200
     0.222     2.278     0.200
     0.240     2.536     0.200
     0.241     2.723     0.200
     0.200     2.862     0.200
     0.212     2.445     0.200
     0.285     3.009     0.200
     0.325     3.130     0.200
     0.299     2.365     0.200
     0.362     3.123     0.200
     0.340     2.883     0.200
     0.428     3.277     0.200
     0.394     3.488     0.200
     0.443     3.507     0.200
     0.499     3.562     0.200
     0.499     4.127     0.200
     0.526     3.679     0.200
     0.599     4.598     0.200
     0.569     4.551     0.200
     0.605     4.331     0.200
     0.615     4.887     0.200
     0.602     4.719     0.200
     0.688     4.586     0.200
     0.644     4.995     0.200
     0.655     4.867     0.200
     0.677     4.790     0.200
     0.721     4.839     0.200
     0.843     5.610     0.200
     0.895     5.768     0.200
     0.878     5.416     0.200
     0.905     5.804     0.200
     0.908     5.712     0.200
     0.908     5.603     0.200
     0.985     5.941     0.200
     0.994     6.038     0.200
     1.097     6.330     0.200
     1.496     8.730     0.200
     1.675     9.503     0.200
     0.021     1.376     0.200
     0.130     1.813     0.200
     0.185     2.076     0.200
     0.199     2.125     0.200
     0.206     2.906     0.200
     0.205     2.573     0.200
     0.215     2.400     0.200
     0.249     2.786     0.200
     0.257     2.957     0.200
     0.327     2.618     0.200
     0.338     3.050     0.200
     0.353     3.556     0.200
     0.375     3.095     0.200
     0.390     3.053     0.200
     0.409     3.766     0.200
     0.435     3.450     0.200
     0.465     3.485     0.200
     0.501     4.216     0.200
     0.528     3.639     0.200
     0.571     4.598     0.200
     0.569     4.239     0.200
     0.639     4.958     0.200
     0.657     4.516     0.200
     0.680     5.147     0.200
     0.687     5.000     0.200
     0.725     4.855     0.200
     0.800     5.569     0.200
     0.894     5.876     0.200
     0.897     5.398     0.200
     0.922     6.159     0.200
     0.925     5.755     0.200
     0.925     5.646     0.200
     0.965     6.181     0.200
     1.016     6.335     0.200
     1.026     6.371     0.200
     1.060     6.418     0.200
     1.126     6.850     0.200
     1.144     6.968     0.200
     1.617    10.114     0.200
     0.050     1.149     0.200
     0.081     3.896     0.200
     0.203     1.776     0.200
     0.245     1.702     0.200
     0.338     3.329     0.200
     0.309     2.626     0.200
     0.313     2.637     0.200
     0.301     3.030     0.200
     0.368     3.570     0.200
     0.364     3.210     0.200
     0.414     3.878     0.200
     0.467     3.667     0.200
     0.488     4.026     0.200
     0.528     4.232     0.200
     0.561     4.526     0.200
     0.520     4.155     0.200
     0.562     3.925     0.200
     0.618     4.349     0.200
     0.694     4.898     0.200
     0.660     4.458     0.200
     0.724     5.445     0.200
     0.793     5.188     0.200
     0.832     5.481     0.200
     0.819     4.764     0.200
     0.932     5.787     0.200
     1.046     6.265     0.200
     1.231     6.921     0.200
     1.580    10.697     0.200
     1.634    10.109     0.200
     0.017     1.512     0.200
     0.067     0.995     0.200
     0.143     1.857     0.200
     0.224     2.023     0.200
     0.281     2.927     0.200
     0.273     1.874     0.200
     0.277     2.513     0.200
     0.280     2.552     0.200
     0.352     3.108     0.200
     0.400     3.717     0.200
     0.412     3.488     0.200
     0.464     3.950     0.200
     0.496     3.784     0.200
     0.523     4.002     0.200
     0.535     3.869     0.200
     0.529     4.243     0.200
     0.587     4.207     0.200
     0.567     4.542     0.200
     0.679     4.581     0.200
     0.673     4.755     0.200
     0.691     5.309     0.200
     0.804     4.796     0.200
     0.824     5.107     0.200
     0.824     5.631     0.200
     0.878     6.140     0.200
     0.929     6.470     0.200
     1.080     7.906     0.200
     0.231     2.074     0.200
     0.236     2.351     0.200
     0.269     2.501     0.200
     0.273     3.112     0.200
     0.306     2.550     0.200
     0.293     2.657     0.200
     0.313     2.784     0.200
     0.336     3.156     0.200
     0.341     2.796     0.200
     0.352     3.697     0.200
     0.419     3.296     0.200
     0.429     3.706     0.200
     0.449     3.887     0.200
     0.454     3.569     0.200
     0.456     3.549     0.200
     0.457     3.576     0.200
     0.472     3.719     0.200
     0.458     3.786     0.200
     0.502     4.535     0.200
     0.503     4.010     0.200
     0.539     4.308     0.200
     0.534     4.215     0.200
     0.603     4.869     0.200
     0.626     5.268     0.200
     0.627     5.175     0.200
     0.636     4.967     0.200
     0.652     5.266     0.200
     0.681     5.075     0.200
     0.671     5.482     0.200
     0.673     5.076     0.200
     0.690     5.310     0.200
     0.683     5.392     0.200
     0.697     5.421     0.200
     0.735     5.811     0.200
     0.773     5.074     0.200
     0.775     5.831     0.200
     0.801     6.028     0.200
     0.791     6.179     0.200
     0.809     5.604     0.200
     0.820     6.495     0.200
     0.823     5.728     0.200
     0.831     6.807     0.200
     0.842     6.479     0.200
     0.839     6.500     0.200
     0.895     6.173     0.200
     0.910     6.612     0.200
     0.933     7.040     0.200
     0.984     6.808     0.200
     0.979     7.376     0.200
     1.008     6.861     0.200
     0.229     2.431     0.200
     0.233     2.576     0.200
     0.391     3.533     0.200
     0.440     3.580     0.200
     0.437     3.223     0.200
     0.450     3.599     0.200
     0.453     3.681     0.200
     0.495     3.180     0.200
     0.498     3.227     0.200
     0.506     3.639     0.200
     0.541     3.519     0.200
     0.499     4.227     0.200
     0.566     4.540     0.200
     0.586     4.597     0.200
     0.639     4.332     0.200
     0.652     4.715     0.200
     0.648     4.293     0.200
     0.654     4.363     0.200
     0.659     4.387     0.200
     0.656     4.371     0.200
     0.672     4.233     0.200
     0.651     4.262     0.200
     0.667     4.937     0.200
     0.704     4.776     0.200
     0.711     5.289     0.200
     0.733     4.896     0.200
     0.760     5.145     0.200
     0.788     5.565     0.200
     0.729     5.891     0.200
     0.800     5.745     0.200
     0.827     5.206     0.200
     0.839     5.068     0.200
     0.855     5.535     0.200
     0.859     5.759     0.200
     0.895     5.320     0.200
     0.912     5.914     0.200
     0.912     6.160     0.200
     0.912     6.331     0.200
     0.923     5.701     0.200
     0.936     6.111     0.200
     0.916     6.408     0.200
     0.940     6.076     0.200
     0.968     6.255     0.200
     0.955     7.249     0.200
     0.955     7.767     0.200
     1.097     6.988     0.200
     1.019     8.007     0.200
     1.143     6.286     0.200
     1.123     6.514     0.200
     1.172     6.614     0.200
     1.192     6.649     0.200
     1.155     6.851     0.200
     1.145     7.541     0.200
     1.247     8.148     0.200
     1.276     6.728     0.200
     1.277     7.852     0.200
     1.281     7.201     0.200
     0.011     0.205     0.200
     0.011     1.025     0.200
     0.071     0.923     0.200
     0.095     1.241     0.200
     0.112     1.302     0.200
     0.151     1.891     0.200
     0.194     2.313     0.200
     0.203     2.391     0.200
     0.215     1.927     0.200
     0.262     1.840     0.200
     0.288     3.028     0.200
     0.289     2.499     0.200
     0.293     2.589     0.200
     0.328     3.416     0.200
     0.425     3.455     0.200
     0.485     3.772     0.200
     0.468     4.037     0.200
     0.520     4.098     0.200
     0.574     4.033     0.200
     0.535     4.304     0.200
     0.545     3.947     0.200
     0.568     4.341     0.200
     0.599     4.116     0.200
     0.647     5.042     0.200
     0.605     4.931     0.200
     0.672     4.310     0.200
     0.611     4.642     0.200
     0.626     4.796     0.200
     0.690     4.925     0.200
     0.644     4.359     0.200
     0.706     5.142     0.200
     0.680     4.882     0.200
     0.681     4.827     0.200
     0.705     5.414     0.200
     0.703     5.361     0.200
     0.774     5.006     0.200
     0.725     4.936     0.200
     0.760     5.633     0.200
     0.808     4.752     0.200
     0.794     5.539     0.200
     0.789     5.213     0.200
     0.813     5.930     0.200
     0.826     5.626     0.200
     0.835     5.910     0.200
     0.854     5.966     0.200
     0.873     6.060     0.200
     0.869     5.999     0.200
     0.885     6.118     0.200
     0.885     6.079     0.200
     0.893     6.113     0.200
     0.898     5.887     0.200
     0.907     6.299     0.200
     0.914     5.934     0.200
     0.933     6.428     0.200
     0.935     6.292     0.200
     1.009     6.180     0.200
     1.068     7.022     0.200
     1.068     8.073     0.200
     1.026     6.048     0.200
     1.133     6.602     0.200
     1.451     4.014     0.200
     1.323     9.725     0.200
     1.390     7.538     0.200
     1.606     9.065     0.200
     0.007     1.224     0.200
     0.069     3.082     0.200
     0.112     1.238     0.200
     0.099     1.238     0.200
     0.195     2.161     0.200
     0.204     2.455     0.200
     0.285     2.323     0.200
     0.286     2.893     0.200
     0.289     2.324     0.200
     0.346     3.285     0.200
     0.326     3.458     0.200
     0.355     3.198     0.200
     0.403     3.581     0.200
     0.367     3.455     0.200
     0.421     3.288     0.200
     0.432     4.086     0.200
     0.488     3.223     0.200
     0.522     4.084     0.200
     0.542     3.725     0.200
     0.542     4.603     0.200
     0.536     4.342     0.200
     0.523     4.077     0.200
     0.537     4.385     0.200
     0.576     3.995     0.200
     0.565     4.391     0.200
     0.622     4.777     0.200
     0.609     4.856     0.200
     0.603     5.871     0.200
     0.647     4.860     0.200
     0.646     5.136     0.200
     0.643     4.393     0.200
     0.678     4.423     0.200
     0.674     4.424     0.200
     0.691     4.941     0.200
     0.699     5.346     0.200
     0.710     5.178     0.200
     0.775     4.928     0.200
     0.806     4.703     0.200
     0.788     5.287     0.200
     0.794     5.531     0.200
     0.811     5.765     0.200
     0.825     5.008     0.200
     0.852     5.817     0.200
     0.875     6.017     0.200
     0.932     6.031     0.200
     0.961     6.155     0.200
     1.212     6.799     0.200
     0.047     2.775     0.200
     0.048     0.768     0.200
     0.063     0.780     0.200
     0.110     3.157     0.200
     0.118     1.385     0.200
     0.150     1.661     0.200
     0.232     1.970     0.200
     0.222     2.623     0.200
     0.251     2.592     0.200
     0.260     2.263     0.200
     0.297     2.903     0.200
     0.332     3.078     0.200
     0.332     2.912     0.200
     0.369     2.949     0.200
     0.376     3.786     0.200
     0.388     3.579     0.200
     0.391     4.023     0.200
     0.434     3.765     0.200
     0.500     4.105     0.200
     0.495     3.516     0.200
     0.508     4.196     0.200
     0.512     3.876     0.200
     0.523     4.025     0.200
     0.537     4.701     0.200
     0.538     3.978     0.200
     0.579     4.645     0.200
     0.566     4.410     0.200
     0.566     4.470     0.200
     0.594     4.443     0.200
     0.586     4.484     0.200
     0.591     4.068     0.200
     0.617     5.894     0.200
     0.623     4.365     0.200
     0.628     4.902     0.200
     0.621     5.225     0.200
     0.647     4.499     0.200
     0.655     4.668     0.200
     0.660     5.287     0.200
     0.638     4.835     0.200
     0.664     5.304     0.200
     0.647     5.102     0.200
     0.689     4.764     0.200
     0.697     4.252     0.200
     0.752     5.491     0.200
     0.759     5.615     0.200
     0.777     4.200     0.200
     0.790     5.056     0.200
     0.786     4.896     0.200
     0.823     5.022     0.200
     0.823     5.651     0.200
     0.853     5.764     0.200
     0.860     5.772     0.200
     0.896     6.069     0.200
     0.905     6.043     0.200
     0.920     6.158     0.200
     0.923     5.676     0.200
     0.913     5.575     0.200
     0.934     6.174     0.200
     0.936     6.128     0.200
     0.974     6.090     0.200
     1.003     6.356     0.200
     1.026     6.476     0.200
     1.018     6.320     0.200
     1.031     6.918     0.200
     1.037     6.570     0.200
     1.055     6.486     0.200
     1.086     7.010     0.200
     1.098     7.248     0.200
     1.112     6.880     0.200
     1.130     6.731     0.200
     1.153     6.703     0.200
     1.159     6.097     0.200
     1.183     5.964     0.200
     1.196     6.757     0.200
     1.222     6.908     0.200
     1.223     5.955     0.200
     1.263     6.870     0.200
     1.276     7.092     0.200
     1.287     6.636     0.200
     1.311     7.145     0.200
     1.324     7.196     0.200
     1.482    10.815     0.200
     1.509     9.708     0.200
     1.708    10.161     0.200
     1.711    11.448     0.200
     0.029     0.922     0.200
     0.051     0.857     0.200
     0.033     0.969     0.200
     0.098     1.259     0.200
     0.135     1.582     0.200
     0.220     2.625     0.200
     0.251     2.168     0.200
     0.286     2.146     0.200
     0.330     3.084     0.200
     0.322     2.731     0.200
     0.377     3.508     0.200
     0.399     3.754     0.200
     0.452     3.386     0.200
     0.506     3.209     0.200
     0.483     4.199     0.200
     0.519     3.945     0.200
     0.531     3.876     0.200
     0.525     3.755     0.200
     0.540     4.281     0.200
     0.524     3.618     0.200
     0.556     4.272     0.200
     0.563     4.263     0.200
     0.599     4.119     0.200
     0.576     3.843     0.200
     0.608     4.223     0.200
     0.642     4.139     0.200
     0.642     4.287     0.200
     0.631     4.250     0.200
     0.620     5.036     0.200
     0.624     4.985     0.200
     0.664     4.653     0.200
     0.655     4.298     0.200
     0.671     4.181     0.200
     0.680     4.986     0.200
     0.739     5.587     0.200
     0.778     4.743     0.200
     0.795     5.184     0.200
     0.806     5.298     0.200
     0.815     5.283     0.200
     0.799     4.656     0.200
     0.824     5.313     0.200
     0.799     5.599     0.200
     0.825     5.093     0.200
     0.813     5.173     0.200
     0.833     5.096     0.200
     0.833     5.428     0.200
     0.831     5.434     0.200
     0.833     4.909     0.200
     0.855     5.460     0.200
     0.873     5.342     0.200
     0.880     5.468     0.200
     0.884     5.694     0.200
     0.884     5.756     0.200
     0.904     5.878     0.200
     0.909     5.901     0.200
     0.897     5.725     0.200
     0.915     5.858     0.200
     0.909     5.976     0.200
     0.902     5.879     0.200
     0.924     5.617     0.200
     0.935     5.467     0.200
     0.951     6.034     0.200
     0.959     6.105     0.200
     0.946     5.784     0.200
     0.965     6.460     0.200
     0.995     6.319     0.200
     0.995     5.933     0.200
     1.007     6.077     0.200
     1.015     6.249     0.200
     1.022     6.158     0.200
     1.052     5.848     0.200
     1.112     5.981     0.200
     2.362    13.761     0.200
     0.026     1.001     0.200
     0.030     2.429     0.200
     0.053     0.886     0.200
     0.100     1.285     0.200
     0.122     1.630     0.200
     0.167     2.439     0.200
     0.258     2.245     0.200
     0.285     2.126     0.200
     0.314     3.109     0.200
     0.324     3.200     0.200
     0.324     2.861     0.200
     0.333     3.072     0.200
     0.391     3.168     0.200
     0.380     3.705     0.200
     0.385     3.620     0.200
     0.402     4.040     0.200
     0.452     3.859     0.200
     0.510     3.644     0.200
     0.521     4.328     0.200
     0.525     4.251     0.200
     0.515     3.916     0.200
     0.534     4.088     0.200
     0.521     4.093     0.200
     0.544     4.437     0.200
     0.562     3.870     0.200
     0.553     4.463     0.200
     0.560     4.410     0.200
     0.584     4.616     0.200
     0.577     3.978     0.200
     0.600     4.590     0.200
     0.607     4.505     0.200
     0.618     5.923     0.200
     0.621     5.025     0.200
     0.642     4.962     0.200
     0.645     4.600     0.200
     0.634     4.340     0.200
     0.653     4.581     0.200
     0.670     4.771     0.200
     0.681     5.265     0.200
     0.683     5.331     0.200
     0.667     5.086     0.200
     0.681     4.719     0.200
     0.681     4.498     0.200
     0.736     5.570     0.200
     0.762     5.501     0.200
     0.782     4.393     0.200
     0.774     4.817     0.200
     0.797     6.042     0.200
     0.797     5.297     0.200
     0.797     5.977     0.200
     0.806     5.645     0.200
     0.816     5.729     0.200
     0.810     5.603     0.200
     0.821     5.617     0.200
     0.831     5.512     0.200
     0.829     5.630     0.200
     0.831     5.652     0.200
     0.855     5.733     0.200
     0.855     5.722     0.200
     0.874     5.761     0.200
     0.882     6.196     0.200
     0.883     5.934     0.200
     0.883     5.965     0.200
     0.894     5.807     0.200
     0.903     6.026     0.200
     0.899     5.941     0.200
     0.906     6.403     0.200
     0.914     6.217     0.200
     0.922     5.940     0.200
     0.932     6.173     0.200
     0.934     6.237     0.200
     0.945     6.108     0.200
     0.951     6.148     0.200
     0.996     6.027     0.200
     1.014     6.361     0.200
     1.020     6.227     0.200
     1.043     6.408     0.200
     1.048     6.497     0.200
     1.046     6.411     0.200
     1.055     6.108     0.200
     1.052     6.560     0.200
     1.064     6.436     0.200
     1.064     6.476     0.200
     1.079     7.399     0.200
     1.108     7.103     0.200
     1.113     6.429     0.200
     1.112     6.572     0.200
     1.125     6.767     0.200
     1.198     6.713     0.200
     1.206     6.744     0.200
     1.213     5.964     0.200
     1.256     6.967     0.200
     1.266     6.848     0.200
     1.274     6.879     0.200
     1.295     7.010     0.200
     1.304     6.938     0.200
     1.326     7.072     0.200
     1.342     7.180     0.200
     0.030     1.107     0.200
     0.054     1.104     0.200
     0.101     1.438     0.200
     0.121     1.760     0.200
     0.135     1.681     0.200
     0.249     2.285     0.200
     0.217     2.577     0.200
     0.254     2.322     0.200
     0.227     2.511     0.200
     0.257     2.755     0.200
     0.250     2.278     0.200
     0.311     3.204     0.200
     0.289     2.091     0.200
     0.325     2.779     0.200
     0.333     2.989     0.200
     0.322     3.211     0.200
     0.379     3.676     0.200
     0.387     3.249     0.200
     0.400     3.972     0.200
     0.386     3.520     0.200
     0.449     3.856     0.200
     0.507     3.665     0.200
     0.480     4.146     0.200
     0.516     3.880     0.200
     0.530     4.195     0.200
     0.522     4.236     0.200
     0.542     4.303     0.200
     0.559     4.043     0.200
     0.524     4.127     0.200
     0.555     4.404     0.200
     0.561     4.315     0.200
     0.579     3.972     0.200
     0.596     4.583     0.200
     0.584     4.464     0.200
     0.605     4.487     0.200
     0.641     4.642     0.200
     0.618     5.144     0.200
     0.634     4.780     0.200
     0.621     4.803     0.200
     0.639     4.980     0.200
     0.668     4.761     0.200
     0.664     5.177     0.200
     0.677     4.990     0.200
     0.680     5.088     0.200
     0.684     4.491     0.200
     0.740     5.531     0.200
     0.781     4.661     0.200
     0.793     5.437     0.200
     0.776     4.753     0.200
     0.796     5.068     0.200
     0.818     5.539     0.200
     0.796     5.788     0.200
     0.822     5.585     0.200
     0.810     5.481     0.200
     0.830     5.509     0.200
     0.852     5.670     0.200
     0.870     5.695     0.200
     0.878     5.822     0.200
     0.894     5.660     0.200
     0.968     5.596     0.200
     0.993     6.049     0.200
     1.135     9.749     0.200
     1.195     6.721     0.200
     2.862    15.198     0.200
     0.029     1.157     0.200
     0.036     0.564     0.200
     0.093     4.027     0.200
     0.139     3.566     0.200
     0.271     2.273     0.200
     0.298     3.019     0.200
     0.291     2.957     0.200
     0.299     2.112     0.200
     0.343     3.369     0.200
     0.344     3.198     0.200
     0.363     3.054     0.200
     0.375     3.211     0.200
     0.400     3.226     0.200
     0.421     3.809     0.200
     0.430     3.928     0.200
     0.439     4.259     0.200
     0.439     3.822     0.200
     0.501     4.251     0.200
     0.495     3.766     0.200
     0.536     4.520     0.200
     0.541     3.804     0.200
     0.542     4.152     0.200
     0.519     4.040     0.200
     0.518     4.163     0.200
     0.553     4.066     0.200
     0.542     4.242     0.200
     0.585     4.110     0.200
     0.584     3.932     0.200
     0.574     4.292     0.200
     0.592     4.518     0.200
     0.577     4.993     0.200
     0.580     4.666     0.200
     0.611     4.647     0.200
     0.610     4.106     0.200
     0.613     4.209     0.200
     0.643     4.811     0.200
     0.659     4.673     0.200
     0.666     5.174     0.200
     0.669     5.139     0.200
     0.674     4.574     0.200
     0.684     5.256     0.200
     0.709     4.716     0.200
     0.721     4.923     0.200
     0.725     5.198     0.200
     0.738     5.395     0.200
     0.757     5.233     0.200
     0.769     5.283     0.200
     0.809     4.872     0.200
     0.852     5.538     0.200
     0.953     5.282     0.200
     0.978     5.954     0.200
     1.042     6.167     0.200
     1.145     6.554     0.200
     1.172     6.614     0.200
     1.222     6.825     0.200
     1.233     6.536     0.200
     1.320     7.090     0.200
     1.351     7.221     0.200
     1.475     9.298     0.200
     1.546    10.570     0.200
     2.208    12.746     0.200
     0.039     1.063     0.200
     0.054     1.035     0.200
     0.102     1.370     0.200
     0.115     1.666     0.200
     0.144     1.700     0.200
     0.223     2.563     0.200
     0.258     2.280     0.200
     0.240     2.191     0.200
     0.245     2.278     0.200
     0.250     2.703     0.200
     0.296     2.125     0.200
     0.302     3.147     0.200
     0.321     3.244     0.200
     0.324     2.851     0.200
     0.328     2.984     0.200
     0.378     3.143     0.200
     0.393     3.952     0.200
     0.444     3.849     0.200
     0.499     3.626     0.200
     0.509     4.198     0.200
     0.519     4.211     0.200
     0.533     4.126     0.200
     0.516     3.908     0.200
     0.522     4.097     0.200
     0.563     4.435     0.200
     0.567     4.290     0.200
     0.550     3.840     0.200
     0.589     4.534     0.200
     0.581     3.992     0.200
     0.590     4.524     0.200
     0.603     4.474     0.200
     0.621     5.458     0.200
     0.625     4.973     0.200
     0.637     4.956     0.200
     0.632     4.528     0.200
     0.632     4.758     0.200
     0.665     4.757     0.200
     0.671     5.105     0.200
     0.655     5.033     0.200
     0.682     4.652     0.200
     0.687     4.493     0.200
     0.748     5.500     0.200
     0.777     4.784     0.200
     0.775     4.571     0.200
     0.797     5.164     0.200
     0.785     5.647     0.200
     0.812     5.523     0.200
     0.814     5.622     0.200
     0.830     5.533     0.200
     0.848     5.709     0.200
     0.864     5.704     0.200
     0.870     5.730     0.200
     0.898     5.720     0.200
     0.908     5.903     0.200
     0.985     6.061     0.200
     1.104     6.524     0.200
     1.111     6.209     0.200
     1.193     6.875     0.200
     1.227     7.322     0.200
     1.505     8.670     0.200
     0.028     1.837     0.200
     0.031     2.448     0.200
     0.074     3.690     0.200
     0.140     1.957     0.200
     0.198     2.517     0.200
     0.235     2.088     0.200
     0.255     2.147     0.200
     0.257     2.154     0.200
     0.303     3.193     0.200
     0.275     2.885     0.200
     0.322     3.285     0.200
     0.366     3.350     0.200
     0.345     3.002     0.200
     0.353     3.211     0.200
     0.387     3.113     0.200
     0.399     3.822     0.200
     0.435     3.723     0.200
     0.460     4.154     0.200
     0.507     4.165     0.200
     0.521     4.428     0.200
     0.530     4.076     0.200
     0.520     3.618     0.200
     0.514     4.034     0.200
     0.542     4.191     0.200
     0.540     4.384     0.200
     0.564     4.330     0.200
     0.536     3.916     0.200
     0.566     3.875     0.200
     0.597     4.914     0.200
     0.622     4.797     0.200
     0.597     3.998     0.200
     0.651     4.728     0.200
     0.668     5.130     0.200
     0.668     5.050     0.200
     0.655     4.507     0.200
     0.703     4.735     0.200
     0.700     4.557     0.200
     0.775     5.047     0.200
     0.810     5.136     0.200
     0.800     4.580     0.200
     0.795     4.808     0.200
     0.987     5.789     0.200
     1.038     6.411     0.200
     1.097     6.358     0.200
     1.169     7.079     0.200
     1.179     6.267     0.200
     1.204     6.816     0.200
     1.213     7.687     0.200
     1.382     7.203     0.200
     1.484     9.262     0.200
     1.693    11.529     0.200
     0.042     1.302     0.200
     0.050     0.458     0.200
     0.111     1.203     0.200
     0.099     1.210     0.200
     0.163     2.223     0.200
     0.157     1.655     0.200
     0.183     2.168     0.200
     0.155     2.003     0.200
     0.165     2.126     0.200
     0.194     1.502     0.200
     0.287     2.459     0.200
     0.287     2.472     0.200
     0.280     2.905     0.200
     0.302     1.854     0.200
     0.324     3.181     0.200
     0.362     3.383     0.200
     0.412     3.400     0.200
     0.427     3.699     0.200
     0.441     3.993     0.200
     0.419     4.312     0.200
     0.496     4.003     0.200
     0.478     3.615     0.200
     0.499     4.091     0.200
     0.499     3.906     0.200
     0.523     4.213     0.200
     0.554     4.204     0.200
     0.561     3.962     0.200
     0.563     4.251     0.200
     0.569     4.192     0.200
     0.561     4.629     0.200
     0.595     4.892     0.200
     0.601     4.241     0.200
     0.622     4.265     0.200
     0.635     4.680     0.200
     0.672     4.790     0.200
     0.664     5.216     0.200
     0.671     5.143     0.200
     0.699     5.350     0.200
     0.712     5.119     0.200
     0.718     4.781     0.200
     0.733     5.425     0.200
     0.741     5.174     0.200
     0.750     5.555     0.200
     0.778     5.401     0.200
     0.776     5.477     0.200
     0.778     5.072     0.200
     0.822     4.908     0.200
     0.843     4.939     0.200
     0.832     5.441     0.200
     0.838     5.966     0.200
     0.872     5.836     0.200
     0.887     6.075     0.200
     0.885     6.404     0.200
     0.893     6.082     0.200
     0.919     6.285     0.200
     0.967     6.339     0.200
     0.963     6.401     0.200
     0.960     6.085     0.200
     0.999     6.241     0.200
     0.999     6.633     0.200
     1.020     6.505     0.200
     1.015     6.558     0.200
     1.043     6.560     0.200
     1.048     6.738     0.200
     1.040     7.190     0.200
     1.051     6.627     0.200
     1.063     7.081     0.200
     1.094     6.958     0.200
     1.094     7.864     0.200
     1.151     6.794     0.200
     1.161     7.297     0.200
     1.167     6.950     0.200
     1.263     6.651     0.200
     1.525    10.643     0.200
     1.673    11.766     0.200
     0.043    -0.003     0.200
     0.051     0.163     0.200
     0.098     1.072     0.200
     0.113     1.227     0.200
     0.154     1.979     0.200
     0.158     1.691     0.200
     0.185     2.108     0.200
     0.192     1.660     0.200
     0.280     2.789     0.200
     0.289     2.451     0.200
     0.301     2.034     0.200
     0.320     3.161     0.200
     0.323     3.126     0.200
     0.363     3.493     0.200
     0.396     3.441     0.200
     0.413     3.343     0.200
     0.418     3.866     0.200
     0.427     3.695     0.200
     0.443     4.003     0.200
     0.461     4.403     0.200
     0.477     3.620     0.200
     0.496     4.072     0.200
     0.497     4.078     0.200
     0.497     3.953     0.200
     0.521     4.280     0.200
     0.555     4.288     0.200
     0.557     5.435     0.200
     0.563     4.296     0.200
     0.562     3.972     0.200
     0.560     4.992     0.200
     0.570     4.248     0.200
     0.596     4.613     0.200
     0.602     4.822     0.200
     0.602     4.221     0.200
     0.606     5.334     0.200
     0.623     4.326     0.200
     0.635     4.721     0.200
     0.664     5.212     0.200
     0.672     5.184     0.200
     0.673     4.773     0.200
     0.693     4.783     0.200
     0.700     5.342     0.200
     0.719     4.774     0.200
     0.736     5.677     0.200
     0.740     5.014     0.200
     0.732     5.353     0.200
     0.738     4.857     0.200
     0.748     5.550     0.200
     0.766     5.673     0.200
     0.770     4.245     0.200
     0.777     5.330     0.200
     0.775     5.436     0.200
     0.805     5.580     0.200
     0.810     5.684     0.200
     0.813     5.775     0.200
     0.824     5.841     0.200
     0.826     5.766     0.200
     0.823     5.057     0.200
     0.831     5.706     0.200
     0.836     6.033     0.200
     0.844     5.200     0.200
     0.865     5.857     0.200
     0.894     5.880     0.200
     0.958     6.108     0.200
     0.961     6.073     0.200
     0.973     6.125     0.200
     1.000     6.210     0.200
     1.264     6.259     0.200
     1.524    10.869     0.200
     1.671    11.755     0.200
     0.184     2.006     0.200
     0.165     1.985     0.200
     0.282     2.259     0.200
     0.282     2.332     0.200
     0.273     2.747     0.200
     0.309     1.904     0.200
     0.318     3.078     0.200
     0.322     3.119     0.200
     0.405     3.305     0.200
     0.419     3.523     0.200
     0.443     3.948     0.200
     0.458     4.275     0.200
     0.483     3.741     0.200
     0.488     3.886     0.200
     0.520     4.142     0.200
     0.547     4.171     0.200
     0.558     3.895     0.200
     0.574     4.495     0.200
     0.555     5.265     0.200
     0.556     4.262     0.200
     0.558     4.767     0.200
     0.596     4.287     0.200
     0.587     4.665     0.200
     0.595     4.505     0.200
     0.628     4.243     0.200
     0.628     4.599     0.200
     0.656     5.060     0.200
     0.666     4.981     0.200
     0.663     4.918     0.200
     0.696     5.163     0.200
     0.725     4.758     0.200
     0.693     5.786     0.200
     0.706     5.131     0.200
     0.742     5.027     0.200
     0.740     5.576     0.200
     0.736     5.283     0.200
     0.746     5.753     0.200
     0.765     5.648     0.200
     0.773     5.308     0.200
     0.773     5.427     0.200
     0.805     5.662     0.200
     0.844     5.789     0.200
     0.830     5.969     0.200
     0.837     5.944     0.200
     0.843     6.005     0.200
     0.859     6.115     0.200
     0.879     6.319     0.200
     0.930     6.565     0.200
     0.956     6.126     0.200
     0.961     6.296     0.200
     0.992     6.621     0.200
     0.992     6.472     0.200
     0.992     6.440     0.200
     1.012     6.720     0.200
     1.008     6.825     0.200
     1.025     7.275     0.200
     1.035     6.295     0.200
     1.048     6.942     0.200
     1.062     6.708     0.200
     1.070     6.624     0.200
     1.203     6.728     0.200
     1.269     6.414     0.200
     1.264     7.307     0.200
     1.349     7.406     0.200
     1.447    10.196     0.200
     1.525    10.504     0.200
     1.660    10.016     0.200
     1.646    10.411     0.200
     2.510    14.363     0.200
     0.047     0.887     0.200
     0.055     1.776     0.200
     0.114     1.335     0.200
     0.155     1.958     0.200
     0.166     1.968     0.200
     0.183     2.150     0.200
     0.198     1.671     0.200
     0.273     2.874     0.200
     0.281     2.421     0.200
     0.281     2.399     0.200
     0.317     3.084     0.200
     0.310     2.031     0.200
     0.323     3.145     0.200
     0.357     3.340     0.200
     0.404     3.345     0.200
     0.396     3.401     0.200
     0.419     3.705     0.200
     0.417     3.941     0.200
     0.442     4.022     0.200
     0.457     4.282     0.200
     0.488     4.095     0.200
     0.484     3.681     0.200
     0.499     4.015     0.200
     0.502     3.939     0.200
     0.521     4.217     0.200
     0.546     4.260     0.200
     0.557     3.943     0.200
     0.556     4.217     0.200
     0.555     5.191     0.200
     0.558     4.705     0.200
     0.586     4.561     0.200
     0.574     4.273     0.200
     0.595     4.671     0.200
     0.592     4.032     0.200
     0.627     4.578     0.200
     0.628     4.285     0.200
     0.655     5.023     0.200
     0.662     5.141     0.200
     0.665     4.801     0.200
     0.696     5.163     0.200
     0.706     5.156     0.200
     0.692     5.465     0.200
     0.726     4.900     0.200
     0.734     5.804     0.200
     0.737     4.783     0.200
     0.742     5.125     0.200
     0.747     5.711     0.200
     0.741     5.389     0.200
     0.759     5.573     0.200
     0.773     5.630     0.200
     0.771     5.534     0.200
     0.773     5.333     0.200
     0.786     5.636     0.200
     0.800     5.508     0.200
     0.804     5.721     0.200
     0.800     5.579     0.200
     0.815     5.739     0.200
     0.818     5.668     0.200
     0.828     5.043     0.200
     0.831     5.583     0.200
     0.843     4.464     0.200
     0.838     6.247     0.200
     0.844     6.362     0.200
     0.856     5.763     0.200
     0.859     6.169     0.200
     0.866     5.920     0.200
     0.885     5.917     0.200
     0.880     6.150     0.200
     0.879     5.833     0.200
     0.887     6.044     0.200
     0.911     6.096     0.200
     0.929     6.297     0.200
     0.961     6.290     0.200
     0.957     6.074     0.200
     0.991     6.578     0.200
     0.992     6.467     0.200
     0.992     6.354     0.200
     1.007     6.522     0.200
     1.006     6.364     0.200
     1.006     6.418     0.200
     1.025     6.687     0.200
     1.034     6.209     0.200
     1.039     6.456     0.200
     1.049     6.448     0.200
     1.046     6.953     0.200
     1.070     6.548     0.200
     1.063     6.571     0.200
     1.085     6.436     0.200
     1.103     6.715     0.200
     1.103     7.418     0.200
     1.131     6.398     0.200
     1.129     6.909     0.200
     1.151     6.684     0.200
     1.203     6.752     0.200
     1.214     6.839     0.200
     1.219     6.855     0.200
     1.263     6.897     0.200
     1.266     6.998     0.200
     1.269     6.181     0.200
     1.280     6.847     0.200
     1.307     7.161     0.200
     1.333     7.169     0.200
     1.681    11.684     0.200
     0.190     1.778     0.200
     0.299     2.830     0.200
     0.306     2.909     0.200
     0.307     2.649     0.200
     0.321     3.360     0.200
     0.322     3.456     0.200
     0.333     3.100     0.200
     0.346     3.106     0.200
     0.362     3.654     0.200
     0.378     3.370     0.200
     0.422     3.111     0.200
     0.422     3.408     0.200
     0.427     3.161     0.200
     0.430     3.199     0.200
     0.447     4.287     0.200
     0.471     3.573     0.200
     0.535     4.191     0.200
     0.544     3.882     0.200
     0.551     4.571     0.200
     0.580     4.983     0.200
     0.586     4.307     0.200
     0.589     4.529     0.200
     0.667     4.542     0.200
     0.677     4.798     0.200
     0.715     5.018     0.200
     0.718     4.840     0.200
     0.721     5.379     0.200
     0.736     5.342     0.200
     0.743     5.560     0.200
     0.744     5.212     0.200
     0.818     5.647     0.200
     0.812     6.024     0.200
     0.828     5.694     0.200
     0.839     6.015     0.200
     0.858     5.707     0.200
     0.884     5.979     0.200
     0.893     6.436     0.200
     0.921     6.235     0.200
     0.918     6.573     0.200
     0.952     5.932     0.200
     0.950     6.564     0.200
     0.966     6.560     0.200
     0.976     6.505     0.200
     0.999     7.095     0.200
     1.006     6.528     0.200
     1.024     6.906     0.200
     1.048     6.926     0.200
     1.100     7.314     0.200
     1.352     7.376     0.200
     1.376     7.171     0.200
     0.050     0.951     0.200
     0.052     0.934     0.200
     0.063     0.994     0.200
     0.110     1.344     0.200
     0.116     1.689     0.200
     0.154     1.726     0.200
     0.228     1.873     0.200
     0.225     2.667     0.200
     0.232     1.955     0.200
     0.235     2.665     0.200
     0.248     2.676     0.200
     0.264     2.370     0.200
     0.293     3.083     0.200
     0.309     2.082     0.200
     0.330     3.123     0.200
     0.331     2.915     0.200
     0.365     3.087     0.200
     0.374     3.815     0.200
     0.390     3.406     0.200
     0.433     3.730     0.200
     0.491     3.579     0.200
     0.483     4.248     0.200
     0.496     4.226     0.200
     0.509     4.022     0.200
     0.516     4.276     0.200
     0.507     4.088     0.200
     0.534     4.664     0.200
     0.539     3.800     0.200
     0.542     4.212     0.200
     0.569     4.506     0.200
     0.569     4.366     0.200
     0.576     4.553     0.200
     0.591     4.059     0.200
     0.588     4.503     0.200
     0.594     4.494     0.200
     0.620     4.466     0.200
     0.623     4.963     0.200
     0.637     4.435     0.200
     0.628     4.952     0.200
     0.654     4.786     0.200
     0.658     5.013     0.200
     0.643     5.017     0.200
     0.662     5.154     0.200
     0.688     4.661     0.200
     0.698     4.497     0.200
     0.762     5.726     0.200
     0.774     4.438     0.200
     0.786     4.845     0.200
     0.792     5.231     0.200
     0.797     5.828     0.200
     0.824     5.403     0.200
     0.911     5.345     0.200
     0.913     5.741     0.200
     1.015     6.069     0.200
     1.047     6.157     0.200
     1.091     6.385     0.200
     1.223     5.915     0.200
     1.714    11.524     0.200
     0.170     2.070     0.200
     0.167     1.931     0.200
     0.128     2.132     0.200
     0.128     1.806     0.200
     0.155     2.374     0.200
     0.216     2.172     0.200
     0.174     2.481     0.200
     0.203     2.373     0.200
     0.265     2.638     0.200
     0.330     2.900     0.200
     0.330     2.910     0.200
     0.332     2.902     0.200
     0.297     2.954     0.200
     0.283     3.060     0.200
     0.318     2.783     0.200
     0.371     3.260     0.200
     0.405     3.326     0.200
     0.332     3.259     0.200
     0.402     3.226     0.200
     0.345     3.054     0.200
     0.351     3.655     0.200
     0.388     3.506     0.200
     0.436     3.719     0.200
     0.490     3.579     0.200
     0.498     3.584     0.200
     0.535     3.919     0.200
     0.457     3.785     0.200
     0.541     4.051     0.200
     0.464     3.911     0.200
     0.515     4.223     0.200
     0.539     3.757     0.200
     0.514     3.976     0.200
     0.496     3.998     0.200
     0.513     4.332     0.200
     0.596     4.127     0.200
     0.542     4.704     0.200
     0.579     4.605     0.200
     0.637     4.092     0.200
     0.611     4.727     0.200
     0.612     4.710     0.200
     0.578     4.611     0.200
     0.638     4.929     0.200
     0.663     4.634     0.200
     0.679     4.419     0.200
     0.670     4.498     0.200
     0.644     4.707     0.200
     0.637     4.426     0.200
     0.681     4.471     0.200
     0.717     4.834     0.200
     0.726     4.855     0.200
     0.742     4.688     0.200
     0.698     5.344     0.200
     0.761     4.972     0.200
     0.748     4.827     0.200
     0.763     4.729     0.200
     0.752     4.887     0.200
     0.743     5.337     0.200
     0.780     4.971     0.200
     0.760     4.908     0.200
     0.794     5.469     0.200
     0.820     5.266     0.200
     0.813     5.256     0.200
     0.823     5.297     0.200
     0.839     5.662     0.200
     0.830     5.610     0.200
     0.854     5.239     0.200
     0.850     5.287     0.200
     0.878     5.628     0.200
     0.888     5.777     0.200
     0.907     5.738     0.200
     0.917     5.736     0.200
     0.916     5.872     0.200
     0.922     5.782     0.200
     0.943     5.441     0.200
     0.963     6.045     0.200
     1.182     7.399     0.200
     0.105     2.460     0.200
     0.140     2.367     0.200
     0.133     2.351     0.200
     0.171     2.301     0.200
     0.197     2.260     0.200
     0.192     2.681     0.200
     0.221     2.771     0.200
     0.245     3.104     0.200
     0.269     2.692     0.200
     0.263     2.892     0.200
     0.277     2.921     0.200
     0.293     2.744     0.200
     0.296     2.610     0.200
     0.306     2.797     0.200
     0.329     3.074     0.200
     0.331     3.084     0.200
     0.317     3.204     0.200
     0.343     3.006     0.200
     0.344     3.088     0.200
     0.340     3.233     0.200
     0.372     3.121     0.200
     0.385     3.341     0.200
     0.389     3.323     0.200
     0.389     3.396     0.200
     0.386     3.415     0.200
     0.405     3.398     0.200
     0.400     3.350     0.200
     0.396     3.743     0.200
     0.396     3.422     0.200
     0.410     3.989     0.200
     0.438     3.699     0.200
     0.434     3.544     0.200
     0.440     3.539     0.200
     0.463     4.008     0.200
     0.454     3.395     0.200
     0.469     3.806     0.200
     0.470     2.900     0.200
     0.469     3.692     0.200
     0.477     3.602     0.200
     0.465     3.780     0.200
     0.482     4.050     0.200
     0.475     3.922     0.200
     0.499     3.594     0.200
     0.511     4.047     0.200
     0.503     3.801     0.200
     0.523     3.937     0.200
     0.527     4.282     0.200
     0.577     4.712     0.200
     0.555     4.900     0.200
     0.562     4.245     0.200
     0.581     4.641     0.200
     0.575     5.100     0.200
     0.576     4.631     0.200
     0.586     4.369     0.200
     0.613     4.387     0.200
     0.620     4.540     0.200
     0.640     4.682     0.200
     0.657     5.123     0.200
     0.652     4.472     0.200
     0.646     4.777     0.200
     0.643     5.063     0.200
     0.650     5.050     0.200
     0.661     4.887     0.200
     0.665     4.954     0.200
     0.684     4.976     0.200
     0.692     4.510     0.200
     0.709     5.507     0.200
     0.705     5.417     0.200
     0.705     5.701     0.200
     0.706     5.447     0.200
     0.716     5.095     0.200
     0.715     5.049     0.200
     0.731     5.431     0.200
     0.743     4.833     0.200
     0.746     5.805     0.200
     0.742     5.540     0.200
     0.755     5.305     0.200
     0.776     5.547     0.200
     0.787     4.983     0.200
     0.789     5.689     0.200
     0.797     5.647     0.200
     0.815     5.151     0.200
     0.816     5.910     0.200
     0.819     6.015     0.200
     0.819     5.959     0.200
     0.831     5.493     0.200
     0.820     5.631     0.200
     0.822     5.953     0.200
     0.837     5.723     0.200
     0.842     5.916     0.200
     0.851     5.940     0.200
     0.855     6.089     0.200
     0.854     6.246     0.200
     0.871     5.896     0.200
     0.873     6.232     0.200
     0.094     1.549     0.200
     0.126     2.428     0.200
     0.126     2.350     0.200
     0.133     2.075     0.200
     0.133     2.044     0.200
     0.174     2.280     0.200
     0.175     2.844     0.200
     0.181     2.385     0.200
     0.188     2.554     0.200
     0.204     3.033     0.200
     0.235     2.531     0.200
     0.235     2.328     0.200
     0.261     2.910     0.200
     0.273     3.264     0.200
     0.297     3.202     0.200
     0.297     2.587     0.200
     0.316     3.394     0.200
     0.318     3.753     0.200
     0.322     2.657     0.200
     0.359     3.316     0.200
     0.378     3.439     0.200
     0.388     2.984     0.200
     0.420     3.725     0.200
     0.435     3.089     0.200
     0.461     3.451     0.200
     0.454     4.204     0.200
     0.457     4.349     0.200
     0.479     4.366     0.200
     0.487     3.993     0.200
     0.487     3.845     0.200
     0.488     3.968     0.200
     0.502     4.154     0.200
     0.528     4.712     0.200
     0.536     4.216     0.200
     0.534     3.723     0.200
     0.567     4.206     0.200
     0.565     4.214     0.200
     0.565     4.332     0.200
     0.582     4.709     0.200
     0.598     4.164     0.200
     0.590     4.891     0.200
     0.625     4.163     0.200
     0.631     4.924     0.200
     0.658     4.851     0.200
     0.678     4.792     0.200
     0.678     5.229     0.200
     0.671     4.977     0.200
     0.722     5.377     0.200
     0.723     5.136     0.200
     0.724     5.350     0.200
     0.733     5.542     0.200
     0.749     5.447     0.200
     0.761     5.632     0.200
     0.790     5.527     0.200
     0.785     5.646     0.200
     0.793     5.117     0.200
     0.808     5.330     0.200
     0.823     6.353     0.200
     0.830     5.212     0.200
     0.827     4.951     0.200
     0.829     5.376     0.200
     0.858     5.899     0.200
     0.862     6.138     0.200
     0.879     5.325     0.200
     0.891     6.065     0.200
     0.890     5.933     0.200
     0.918     5.970     0.200
     0.926     5.968     0.200
     0.930     5.897     0.200
     0.972     6.083     0.200
     0.981     5.946     0.200
     0.985     6.228     0.200
     0.999     5.987     0.200
     1.018     5.825     0.200
     1.039     5.708     0.200
     1.044     5.952     0.200
     1.044     6.094     0.200
     1.114     6.412     0.200
     1.147     6.541     0.200
     1.152     6.564     0.200
     1.174     7.286     0.200
     1.238     6.776     0.200
     1.298     7.040     0.200
     1.349     7.002     0.200
     1.383     7.247     0.200
     1.400     7.201     0.200
     1.687     9.531     0.200
     1.715     9.070     0.200
     1.832     9.671     0.200
     1.915    12.486     0.200
     1.946    10.346     0.200
     0.086     1.114     0.200
     0.139     1.361     0.200
     0.142     1.931     0.200
     0.188     2.226     0.200
     0.187     2.253     0.200
     0.202     1.206     0.200
     0.209     1.905     0.200
     0.209     1.720     0.200
     0.225     1.832     0.200
     0.248     2.222     0.200
     0.226     2.565     0.200
     0.260     2.232     0.200
     0.241     2.039     0.200
     0.247     2.732     0.200
     0.249     2.309     0.200
     0.290     2.795     0.200
     0.290     2.713     0.200
     0.285     2.677     0.200
     0.320     2.561     0.200
     0.330     2.869     0.200
     0.320     3.141     0.200
     0.342     3.288     0.200
     0.363     3.104     0.200
     0.347     3.412     0.200
     0.344     2.992     0.200
     0.353     3.299     0.200
     0.366     3.533     0.200
     0.385     3.475     0.200
     0.411     3.837     0.200
     0.427     3.432     0.200
     0.397     4.295     0.200
     0.398     3.222     0.200
     0.399     3.281     0.200
     0.434     3.553     0.200
     0.411     3.604     0.200
     0.426     3.616     0.200
     0.418     3.600     0.200
     0.430     4.093     0.200
     0.426     3.518     0.200
     0.432     3.735     0.200
     0.451     3.614     0.200
     0.433     3.369     0.200
     0.457     3.834     0.200
     0.471     3.717     0.200
     0.520     3.995     0.200
     0.533     3.926     0.200
     0.516     4.283     0.200
     0.525     4.698     0.200
     0.532     4.283     0.200
     0.543     4.260     0.200
     0.567     4.911     0.200
     0.537     4.368     0.200
     0.566     4.644     0.200
     0.552     4.363     0.200
     0.547     4.509     0.200
     0.557     4.919     0.200
     0.560     4.505     0.200
     0.569     4.599     0.200
     0.582     4.645     0.200
     0.607     4.375     0.200
     0.596     4.816     0.200
     0.635     4.644     0.200
     0.634     4.623     0.200
     0.641     4.551     0.200
     0.617     5.463     0.200
     0.622     5.302     0.200
     0.626     5.105     0.200
     0.666     5.011     0.200
     0.643     4.973     0.200
     0.652     4.997     0.200
     0.657     4.882     0.200
     0.664     4.950     0.200
     0.685     5.026     0.200
     0.685     5.033     0.200
     0.660     5.066     0.200
     0.661     5.172     0.200
     0.692     5.286     0.200
     0.699     5.321     0.200
     0.682     4.964     0.200
     0.703     5.436     0.200
     0.699     5.022     0.200
     0.688     5.403     0.200
     0.707     5.170     0.200
     0.717     5.155     0.200
     0.733     5.678     0.200
     0.703     5.644     0.200
     0.708     5.536     0.200
     0.711     5.647     0.200
     0.747     5.700     0.200
     0.740     5.121     0.200
     0.755     5.434     0.200
     0.747     5.383     0.200
     0.759     5.363     0.200
     0.761     5.239     0.200
     0.765     5.450     0.200
     0.753     5.470     0.200
     0.782     5.780     0.200
     0.782     5.761     0.200
     0.794     5.739     0.200
     0.795     5.718     0.200
     0.773     5.492     0.200
     0.795     5.716     0.200
     0.790     5.547     0.200
     0.780     5.773     0.200
     0.788     5.751     0.200
     0.788     5.923     0.200
     0.808     5.487     0.200
     0.808     5.495     0.200
     0.807     6.065     0.200
     0.815     5.797     0.200
     0.832     5.963     0.200
     0.814     6.059     0.200
     0.815     6.209     0.200
     0.853     5.763     0.200
     0.842     6.300     0.200
     0.857     5.782     0.200
     0.837     6.295     0.200
     0.869     6.199     0.200
     0.866     6.080     0.200
     0.874     4.809     0.200
     0.875     6.002     0.200
     0.878     6.066     0.200
     0.871     6.292     0.200
     0.882     6.408     0.200
     0.887     6.556     0.200
     0.890     6.418     0.200
     0.911     6.227     0.200
     0.928     6.499     0.200
     0.940     6.643     0.200
     0.961     6.794     0.200
     0.954     8.199     0.200
     0.955     7.180     0.200
     0.962     7.339     0.200
     0.997     6.503     0.200
     0.972     7.078     0.200
     1.003     6.525     0.200
     1.110     6.369     0.200
     1.353     6.812     0.200
     1.361     7.121     0.200
     1.369     7.207     0.200
     1.369     7.355     0.200
     1.667    10.477     0.200
     0.173     2.409     0.200
     0.156     2.714     0.200
     0.158     2.175     0.200
     0.215     3.072     0.200
     0.220     2.672     0.200
     0.232     2.437     0.200
     0.241     2.511     0.200
     0.316     3.012     0.200
     0.286     2.561     0.200
     0.286     2.600     0.200
     0.296     2.844     0.200
     0.329     3.267     0.200
     0.340     3.386     0.200
     0.342     3.326     0.200
     0.341     2.775     0.200
     0.324     2.977     0.200
     0.346     3.130     0.200
     0.374     3.479     0.200
     0.385     3.529     0.200
     0.391     3.159     0.200
     0.371     3.185     0.200
     0.397     3.423     0.200
     0.427     3.540     0.200
     0.394     3.406     0.200
     0.395     3.438     0.200
     0.429     4.084     0.200
     0.432     3.884     0.200
     0.447     3.524     0.200
     0.442     3.872     0.200
     0.439     3.484     0.200
     0.444     3.334     0.200
     0.444     3.493     0.200
     0.454     3.901     0.200
     0.468     3.858     0.200
     0.495     3.963     0.200
     0.509     3.932     0.200
     0.511     4.152     0.200
     0.517     3.739     0.200
     0.512     3.849     0.200
     0.528     4.182     0.200
     0.542     3.797     0.200
     0.551     3.976     0.200
     0.552     4.957     0.200
     0.542     4.976     0.200
     0.565     4.405     0.200
     0.534     4.382     0.200
     0.558     4.673     0.200
     0.540     4.027     0.200
     0.583     4.873     0.200
     0.598     4.639     0.200
     0.592     4.664     0.200
     0.594     4.535     0.200
     0.611     4.671     0.200
     0.633     5.512     0.200
     0.641     4.983     0.200
     0.667     4.617     0.200
     0.652     5.256     0.200
     0.662     5.097     0.200
     0.694     5.236     0.200
     0.673     4.816     0.200
     0.685     5.697     0.200
     0.673     5.094     0.200
     0.699     4.643     0.200
     0.707     5.250     0.200
     0.711     3.448     0.200
     0.682     5.284     0.200
     0.688     5.094     0.200
     0.685     5.171     0.200
     0.731     5.151     0.200
     0.727     5.684     0.200
     0.739     4.755     0.200
     0.750     5.481     0.200
     0.781     5.024     0.200
     0.773     5.604     0.200
     0.770     5.679     0.200
     0.791     5.030     0.200
     0.774     5.939     0.200
     0.774     5.921     0.200
     0.779     5.418     0.200
     0.788     5.623     0.200
     0.824     5.682     0.200
     0.813     5.711     0.200
     0.810     5.998     0.200
     0.827     5.984     0.200
     0.821     6.453     0.200
     0.831     5.120     0.200
     0.819     5.977     0.200
     0.828     5.827     0.200
     0.861     5.309     0.200
     0.855     6.083     0.200
     0.865     5.815     0.200
     0.867     6.340     0.200
     0.873     5.633     0.200
     0.885     5.953     0.200
     0.877     6.471     0.200
     0.903     6.800     0.200
     0.894     6.248     0.200
     0.894     6.281     0.200
     0.942     6.651     0.200
     0.977     5.968     0.200
     1.011     6.600     0.200
     1.838    10.552     0.200
     0.029     0.303     0.200
     0.028     0.362     0.200
     0.083     1.083     0.200
     0.078     1.026     0.200
     0.119     1.394     0.200
     0.164     1.918     0.200
     0.166     1.585     0.200
     0.187     2.220     0.200
     0.206     2.587     0.200
     0.195     2.346     0.200
     0.202     1.741     0.200
     0.302     3.054     0.200
     0.307     2.501     0.200
     0.311     2.614     0.200
     0.319     3.023     0.200
     0.333     3.326     0.200
     0.367     3.496     0.200
     0.366     3.155     0.200
     0.360     3.464     0.200
     0.416     3.739     0.200
     0.436     4.103     0.200
     0.443     3.482     0.200
     0.450     4.369     0.200
     0.456     4.270     0.200
     0.480     3.920     0.200
     0.467     3.540     0.200
     0.499     4.303     0.200
     0.506     3.897     0.200
     0.524     4.277     0.200
     0.526     4.341     0.200
     0.549     4.283     0.200
     0.562     4.119     0.200
     0.558     4.579     0.200
     0.575     4.765     0.200
     0.570     3.981     0.200
     0.586     4.430     0.200
     0.584     4.692     0.200
     0.600     4.954     0.200
     0.641     4.754     0.200
     0.651     4.595     0.200
     0.656     5.327     0.200
     0.665     5.016     0.200
     0.689     4.875     0.200
     0.698     4.986     0.200
     0.692     5.034     0.200
     0.715     5.390     0.200
     0.719     5.323     0.200
     0.722     5.523     0.200
     0.762     5.759     0.200
     0.772     4.961     0.200
     0.777     6.054     0.200
     0.788     5.424     0.200
     0.789     5.442     0.200
     0.819     4.748     0.200
     0.820     5.917     0.200
     0.827     5.730     0.200
     0.825     5.565     0.200
     0.827     5.725     0.200
     0.858     5.937     0.200
     0.858     6.074     0.200
     0.857     5.879     0.200
     0.863     5.985     0.200
     0.866     6.018     0.200
     0.879     6.077     0.200
     0.889     6.221     0.200
     0.889     6.027     0.200
     0.913     5.863     0.200
     0.917     6.352     0.200
     0.931     5.918     0.200
     0.923     6.037     0.200
     0.935     5.672     0.200
     0.937     6.736     0.200
     0.943     6.143     0.200
     0.973     6.252     0.200
     0.999     5.523     0.200
     0.992     6.815     0.200
     1.000     6.039     0.200
     1.008     6.374     0.200
     1.019     6.514     0.200
     1.042     6.354     0.200
     1.025     7.117     0.200
     1.050     6.522     0.200
     1.052     6.989     0.200
     1.056     6.644     0.200
     1.062     6.448     0.200
     1.061     6.490     0.200
     1.069     6.693     0.200
     1.079     7.059     0.200
     1.092     6.532     0.200
     1.092     6.559     0.200
     1.088     6.412     0.200
     1.145     6.811     0.200
     1.195     6.600     0.200
     1.214     6.190     0.200
     1.261     7.167     0.200
     1.276     7.199     0.200
     1.305     9.934     0.200
     1.326     7.278     0.200
     1.325     7.293     0.200
     1.340     7.353     0.200
     1.368     7.319     0.200
     1.393     7.527     0.200
     1.786    11.380     0.200
     0.031     0.234     0.200
     0.033     0.194     0.200
     0.088     0.985     0.200
     0.073     1.133     0.200
     0.124     1.274     0.200
     0.172     1.909     0.200
     0.170     1.970     0.200
     0.183     2.198     0.200
     0.191     2.277     0.200
     0.196     1.770     0.200
     0.307     3.047     0.200
     0.312     2.537     0.200
     0.315     2.723     0.200
     0.319     2.957     0.200
     0.332     3.290     0.200
     0.341     3.066     0.200
     0.356     3.362     0.200
     0.373     3.584     0.200
     0.371     3.132     0.200
     0.421     3.805     0.200
     0.442     4.187     0.200
     0.446     3.507     0.200
     0.455     4.414     0.200
     0.452     4.298     0.200
     0.480     4.004     0.200
     0.462     3.647     0.200
     0.496     4.287     0.200
     0.500     3.976     0.200
     0.521     4.306     0.200
     0.527     4.108     0.200
     0.549     4.385     0.200
     0.553     4.449     0.200
     0.567     3.964     0.200
     0.579     4.763     0.200
     0.573     3.936     0.200
     0.589     4.405     0.200
     0.589     4.667     0.200
     0.596     5.121     0.200
     0.643     4.699     0.200
     0.640     4.449     0.200
     0.654     5.250     0.200
     0.656     4.960     0.200
     0.667     4.903     0.200
     0.688     4.812     0.200
     0.702     4.945     0.200
     0.696     4.905     0.200
     0.716     5.518     0.200
     0.721     5.223     0.200
     0.726     5.380     0.200
     0.760     5.446     0.200
     0.773     6.130     0.200
     0.775     5.023     0.200
     0.785     5.280     0.200
     0.784     5.319     0.200
     0.819     5.878     0.200
     0.824     5.800     0.200
     0.824     5.611     0.200
     0.822     5.676     0.200
     0.824     5.072     0.200
     0.824     5.856     0.200
     0.860     5.871     0.200
     0.854     5.827     0.200
     0.863     5.452     0.200
     0.858     6.491     0.200
     0.861     5.720     0.200
     0.879     5.968     0.200
     0.887     6.182     0.200
     0.885     6.070     0.200
     0.914     5.933     0.200
     0.915     6.396     0.200
     0.920     6.094     0.200
     0.934     6.482     0.200
     0.940     6.323     0.200
     0.940     5.495     0.200
     0.972     6.315     0.200
     0.986     6.670     0.200
     0.995     6.065     0.200
     1.004     6.461     0.200
     1.017     6.567     0.200
     1.020     7.359     0.200
     1.044     6.423     0.200
     1.048     6.587     0.200
     1.050     6.899     0.200
     1.054     6.792     0.200
     1.059     6.507     0.200
     1.058     6.572     0.200
     1.049     7.278     0.200
     1.068     6.793     0.200
     1.093     6.551     0.200
     1.094     6.584     0.200
     1.083     6.481     0.200
     1.146     6.830     0.200
     1.156     6.827     0.200
     1.200     6.582     0.200
     1.217     6.201     0.200
     1.265     7.259     0.200
     1.259     7.230     0.200
     1.271     7.138     0.200
     1.263     7.217     0.200
     1.274     7.084     0.200
     1.327     7.152     0.200
     1.324     7.168     0.200
     1.339     7.235     0.200
     1.368     7.388     0.200
     1.391     7.526     0.200
     1.634    11.417     0.200
     0.025     0.623     0.200
     0.030     2.017     0.200
     0.064     0.893     0.200
     0.100     1.151     0.200
     0.094     1.191     0.200
     0.147     1.932     0.200
     0.147     1.822     0.200
     0.209     2.763     0.200
     0.207     2.407     0.200
     0.215     2.464     0.200
     0.220     1.890     0.200
     0.284     2.961     0.200
     0.284     2.961     0.200
     0.299     2.647     0.200
     0.299     2.647     0.200
     0.318     2.847     0.200
     0.328     2.851     0.200
     0.354     3.508     0.200
     0.347     3.373     0.200
     0.397     3.691     0.200
     0.380     3.473     0.200
     0.420     4.154     0.200
     0.438     3.228     0.200
     0.438     3.567     0.200
     0.488     4.129     0.200
     0.476     4.541     0.200
     0.505     3.959     0.200
     0.482     3.430     0.200
     0.516     4.206     0.200
     0.547     3.929     0.200
     0.523     4.205     0.200
     0.565     4.479     0.200
     0.568     4.717     0.200
     0.555     3.890     0.200
     0.559     4.538     0.200
     0.545     4.068     0.200
     0.577     4.537     0.200
     0.606     4.354     0.200
     0.632     4.498     0.200
     0.646     4.059     0.200
     0.646     4.210     0.200
     0.652     4.347     0.200
     0.652     3.946     0.200
     0.668     5.162     0.200
     0.674     4.840     0.200
     0.661     4.452     0.200
     0.691     4.948     0.200
     0.713     5.352     0.200
     0.701     4.989     0.200
     0.712     4.997     0.200
     0.723     5.323     0.200
     0.722     5.376     0.200
     0.755     4.928     0.200
     0.842     5.653     0.200
     0.886     5.726     0.200
     0.916     5.378     0.200
     0.929     5.952     0.200
     0.985     5.241     0.200
     1.042     6.220     0.200
     1.042     6.351     0.200
     1.038     6.116     0.200
     1.053     7.631     0.200
     1.097     6.471     0.200
     1.179     6.546     0.200
     1.197     6.117     0.200
     1.459     9.030     0.200
     1.642    11.426     0.200
     0.052     1.309     0.200
     0.051     1.147     0.200
     0.055     1.151     0.200
     0.094     1.475     0.200
     0.104     1.498     0.200
     0.104     1.488     0.200
     0.098     1.388     0.200
     0.157     1.870     0.200
     0.228     2.009     0.200
     0.228     2.021     0.200
     0.233     2.129     0.200
     0.237     2.458     0.200
     0.237     2.458     0.200
     0.236     2.699     0.200
     0.286     2.816     0.200
     0.288     3.086     0.200
     0.272     2.226     0.200
     0.326     3.133     0.200
     0.317     3.044     0.200
     0.318     2.817     0.200
     0.367     3.141     0.200
     0.364     3.751     0.200
     0.362     3.520     0.200
     0.362     3.531     0.200
     0.379     3.916     0.200
     0.443     3.894     0.200
     0.484     3.525     0.200
     0.497     4.291     0.200
     0.511     4.046     0.200
     0.518     4.208     0.200
     0.514     4.084     0.200
     0.510     3.870     0.200
     0.536     3.790     0.200
     0.523     4.190     0.200
     0.547     4.105     0.200
     0.584     4.496     0.200
     0.579     4.474     0.200
     0.577     4.572     0.200
     0.593     3.884     0.200
     0.607     4.455     0.200
     0.579     4.021     0.200
     0.620     4.471     0.200
     0.640     4.960     0.200
     0.642     4.993     0.200
     0.635     4.964     0.200
     0.624     4.366     0.200
     0.666     5.019     0.200
     0.666     4.637     0.200
     0.672     5.068     0.200
     0.675     4.563     0.200
     0.696     4.610     0.200
     0.687     4.546     0.200
     0.775     5.337     0.200
     0.763     4.508     0.200
     0.764     4.446     0.200
     0.758     5.723     0.200
     0.807     5.606     0.200
     0.774     4.777     0.200
     0.814     5.190     0.200
     0.814     4.728     0.200
     0.837     5.429     0.200
     0.837     5.454     0.200
     0.847     5.678     0.200
     0.858     5.709     0.200
     0.861     5.742     0.200
     0.899     5.150     0.200
     0.910     5.778     0.200
     0.919     5.998     0.200
     0.952     4.988     0.200
     0.988     6.001     0.200
     1.040     6.077     0.200
     1.034     6.167     0.200
     1.100     6.527     0.200
     1.120     6.221     0.200
     1.105     6.669     0.200
     1.120     7.314     0.200
     1.186     7.064     0.200
     1.194     6.762     0.200
     1.210     5.793     0.200
     1.391     6.279     0.200
     0.005     2.144     0.200
     0.065     1.982     0.200
     0.135     1.818     0.200
     0.179     2.163     0.200
     0.198     2.132     0.200
     0.218     2.058     0.200
     0.241     2.327     0.200
     0.279     2.645     0.200
     0.275     2.314     0.200
     0.286     2.426     0.200
     0.309     2.834     0.200
     0.336     3.124     0.200
     0.336     2.890     0.200
     0.342     3.370     0.200
     0.375     3.166     0.200
     0.355     3.492     0.200
     0.401     3.402     0.200
     0.404     3.334     0.200
     0.386     3.467     0.200
     0.390     3.331     0.200
     0.411     3.234     0.200
     0.404     3.637     0.200
     0.430     3.351     0.200
     0.438     3.769     0.200
     0.441     3.680     0.200
     0.444     3.601     0.200
     0.434     3.689     0.200
     0.465     3.818     0.200
     0.453     3.791     0.200
     0.486     3.610     0.200
     0.483     3.577     0.200
     0.476     4.367     0.200
     0.477     3.674     0.200
     0.480     4.106     0.200
     0.483     4.104     0.200
     0.499     3.666     0.200
     0.510     3.890     0.200
     0.519     4.166     0.200
     0.533     3.869     0.200
     0.556     4.253     0.200
     0.574     4.187     0.200
     0.560     4.061     0.200
     0.568     4.421     0.200
     0.577     4.124     0.200
     0.578     4.438     0.200
     0.607     4.538     0.200
     0.612     4.276     0.200
     0.606     4.482     0.200
     0.598     4.156     0.200
     0.602     4.366     0.200
     0.611     4.700     0.200
     0.609     4.550     0.200
     0.620     4.652     0.200
     0.616     4.484     0.200
     0.647     4.336     0.200
     0.645     4.839     0.200
     0.656     4.540     0.200
     0.652     4.662     0.200
     0.660     4.712     0.200
     0.663     4.954     0.200
     0.656     4.798     0.200
     0.654     4.608     0.200
     0.673     4.806     0.200
     0.675     5.057     0.200
     0.682     4.946     0.200
     0.690     4.841     0.200
     0.706     5.611     0.200
     0.716     5.143     0.200
     0.704     5.104     0.200
     0.704     4.886     0.200
     0.725     4.832     0.200
     0.729     4.885     0.200
     0.732     4.910     0.200
     0.741     4.876     0.200
     0.738     5.155     0.200
     0.728     5.267     0.200
     0.734     5.091     0.200
     0.751     5.034     0.200
     0.762     5.069     0.200
     0.768     5.081     0.200
     0.778     5.432     0.200
     0.768     5.050     0.200
     0.789     5.845     0.200
     0.787     5.767     0.200
     0.787     4.793     0.200
     0.800     5.211     0.200
     0.800     5.595     0.200
     0.790     5.621     0.200
     0.826     5.320     0.200
     0.835     5.957     0.200
     0.846     5.719     0.200
     0.832     5.540     0.200
     0.832     5.862     0.200
     0.853     5.446     0.200
     0.854     5.665     0.200
     0.867     4.931     0.200
     0.899     5.691     0.200
     0.898     6.173     0.200
     0.894     6.390     0.200
     0.885     6.147     0.200
     0.909     5.751     0.200
     0.913     6.329     0.200
     0.921     5.939     0.200
     0.926     6.673     0.200
     0.924     6.391     0.200
     0.923     6.598     0.200
     0.950     6.444     0.200
     0.977     6.207     0.200
     0.981     6.471     0.200
     1.051     7.031     0.200
     1.066     7.608     0.200
     1.097     7.050     0.200
     1.199     6.661     0.200
     1.248     6.722     0.200
     1.280     6.235     0.200
     0.059     1.555     0.200
     0.100     2.045     0.200
     0.118     1.584     0.200
     0.124     1.762     0.200
     0.157     2.517     0.200
     0.181     2.782     0.200
     0.162     2.271     0.200
     0.174     2.391     0.200
     0.195     2.168     0.200
     0.185     2.439     0.200
     0.193     2.608     0.200
     0.242     2.956     0.200
     0.249     2.916     0.200
     0.337     3.249     0.200
     0.322     3.283     0.200
     0.326     2.634     0.200
     0.356     3.165     0.200
     0.368     3.075     0.200
     0.404     2.975     0.200
     0.448     4.010     0.200
     0.428     3.266     0.200
     0.439     4.035     0.200
     0.465     3.557     0.200
     0.451     3.736     0.200
     0.484     3.351     0.200
     0.483     3.910     0.200
     0.497     4.333     0.200
     0.517     3.959     0.200
     0.560     4.777     0.200
     0.553     4.297     0.200
     0.560     4.229     0.200
     0.603     4.763     0.200
     0.618     4.221     0.200
     0.617     4.537     0.200
     0.641     4.864     0.200
     0.652     4.024     0.200
     0.701     5.406     0.200
     0.717     5.152     0.200
     0.709     5.169     0.200
     0.723     5.146     0.200
     0.744     5.598     0.200
     0.758     5.487     0.200
     0.768     5.458     0.200
     0.762     4.978     0.200
     0.750     5.368     0.200
     0.752     5.025     0.200
     0.782     5.233     0.200
     0.785     5.314     0.200
     0.801     5.656     0.200
     0.825     6.113     0.200
     0.831     5.832     0.200
     0.848     5.258     0.200
     0.841     5.740     0.200
     0.835     4.943     0.200
     0.861     5.628     0.200
     0.890     5.878     0.200
     0.906     5.888     0.200
     0.956     6.234     0.200
     0.940     5.873     0.200
     0.979     6.017     0.200
     1.013     5.758     0.200
     1.013     5.818     0.200
     1.068     5.603     0.200
     1.121     6.777     0.200
     1.128     7.475     0.200
     1.170     6.872     0.200
     1.179     8.316     0.200
     1.259     7.407     0.200
     1.320     7.196     0.200
     1.013     6.278     0.200
     0.120     1.655     0.200
     0.124     1.797     0.200
     0.098     2.203     0.200
     0.163     2.290     0.200
     0.178     2.501     0.200
     0.154     2.592     0.200
     0.189     2.480     0.200
     0.192     2.243     0.200
     0.179     2.905     0.200
     0.240     2.841     0.200
     0.246     2.883     0.200
     0.324     3.341     0.200
     0.330     2.720     0.200
     0.335     3.249     0.200
     0.359     3.252     0.200
     0.367     3.221     0.200
     0.407     3.080     0.200
     0.432     3.324     0.200
     0.442     4.154     0.200
     0.450     3.677     0.200
     0.436     3.990     0.200
     0.446     4.013     0.200
     0.463     3.695     0.200
     0.481     3.464     0.200
     0.486     4.051     0.200
     0.516     3.977     0.200
     0.497     4.597     0.200
     0.562     4.232     0.200
     0.556     4.317     0.200
     0.562     4.833     0.200
     0.602     4.764     0.200
     0.615     4.247     0.200
     0.635     4.757     0.200
     0.650     4.161     0.200
     0.642     4.831     0.200
     0.709     4.966     0.200
     0.695     5.368     0.200
     0.726     5.271     0.200
     0.714     5.431     0.200
     0.763     5.074     0.200
     0.766     5.442     0.200
     0.786     5.207     0.200
     0.780     5.157     0.200
     0.798     5.229     0.200
     0.800     5.384     0.200
     0.837     5.098     0.200
     0.834     5.733     0.200
     0.822     6.270     0.200
     0.844     5.794     0.200
     0.832     6.204     0.200
     0.848     5.295     0.200
     0.892     5.937     0.200
     0.908     5.901     0.200
     0.944     5.964     0.200
     0.935     5.973     0.200
     0.957     6.188     0.200
     0.982     6.125     0.200
     0.988     5.772     0.200
     1.013     5.817     0.200
     1.044     6.364     0.200
     1.040     6.368     0.200
     1.041     6.340     0.200
     1.067     5.599     0.200
     1.057     6.460     0.200
     1.087     6.595     0.200
     1.079     6.592     0.200
     1.093     6.437     0.200
     1.099     6.713     0.200
     1.132     7.175     0.200
     1.110     7.341     0.200
     1.121     6.463     0.200
     1.119     6.490     0.200
     1.172     6.536     0.200
     1.173     6.714     0.200
     1.175     6.921     0.200
     1.175     6.501     0.200
     1.192     6.899     0.200
     1.194     6.889     0.200
     1.212     7.189     0.200
     1.207     6.752     0.200
     1.227     6.938     0.200
     1.240     6.777     0.200
     1.240     6.840     0.200
     1.321     7.083     0.200
     1.324     8.643     0.200
     1.343     7.549     0.200
     1.359     7.206     0.200
     1.370     7.146     0.200
     1.409     7.208     0.200
     1.412     7.372     0.200
     0.065     1.430     0.200
     0.104     2.041     0.200
     0.125     1.663     0.200
     0.160     2.173     0.200
     0.169     2.309     0.200
     0.180     2.302     0.200
     0.188     2.319     0.200
     0.162     2.519     0.200
     0.185     2.833     0.200
     0.206     2.178     0.200
     0.245     2.989     0.200
     0.252     2.809     0.200
     0.320     2.519     0.200
     0.318     3.402     0.200
     0.352     3.125     0.200
     0.342     3.255     0.200
     0.371     3.137     0.200
     0.399     2.778     0.200
     0.423     3.380     0.200
     0.434     3.978     0.200
     0.441     3.888     0.200
     0.452     3.800     0.200
     0.478     3.981     0.200
     0.469     3.642     0.200
     0.488     3.410     0.200
     0.498     4.341     0.200
     0.519     3.951     0.200
     0.547     4.184     0.200
     0.557     4.573     0.200
     0.559     4.745     0.200
     0.629     4.697     0.200
     0.623     4.201     0.200
     0.640     5.098     0.200
     0.655     4.110     0.200
     0.708     5.215     0.200
     0.720     5.342     0.200
     0.739     5.520     0.200
     0.721     5.323     0.200
     0.747     5.341     0.200
     0.751     5.538     0.200
     0.762     5.039     0.200
     0.784     5.552     0.200
     0.773     5.500     0.200
     0.795     5.079     0.200
     0.785     5.500     0.200
     0.804     5.481     0.200
     0.827     5.924     0.200
     0.832     5.051     0.200
     0.836     5.969     0.200
     0.835     5.907     0.200
     0.831     6.378     0.200
     0.887     6.193     0.200
     0.902     5.991     0.200
     0.936     5.902     0.200
     0.935     6.058     0.200
     0.953     6.296     0.200
     0.975     6.283     0.200
     0.988     5.683     0.200
     1.013     5.919     0.200
     1.013     5.983     0.200
     1.070     5.974     0.200
     1.123     7.082     0.200
     1.124     6.379     0.200
     1.167     7.337     0.200
     1.185     8.023     0.200
     1.265     8.538     0.200
     1.318     8.003     0.200
     1.429     7.939     0.200
     0.066     1.443     0.200
     0.105     2.029     0.200
     0.114     1.453     0.200
     0.124     1.654     0.200
     0.168     2.354     0.200
     0.163     2.483     0.200
     0.179     2.353     0.200
     0.187     2.315     0.200
     0.186     2.829     0.200
     0.199     2.315     0.200
     0.246     2.883     0.200
     0.253     2.859     0.200
     0.319     2.546     0.200
     0.317     3.750     0.200
     0.351     3.134     0.200
     0.343     3.399     0.200
     0.371     3.179     0.200
     0.398     2.924     0.200
     0.422     2.997     0.200
     0.433     4.007     0.200
     0.442     3.877     0.200
     0.452     3.843     0.200
     0.451     3.658     0.200
     0.478     3.930     0.200
     0.470     3.645     0.200
     0.498     4.426     0.200
     0.488     3.401     0.200
     0.519     3.940     0.200
     0.547     4.175     0.200
     0.559     4.818     0.200
     0.629     4.736     0.200
     0.640     4.999     0.200
     0.623     4.378     0.200
     0.655     4.127     0.200
     0.720     5.311     0.200
     0.707     5.458     0.200
     0.739     5.798     0.200
     0.723     5.420     0.200
     0.746     5.328     0.200
     0.762     5.040     0.200
     0.785     5.420     0.200
     0.774     5.644     0.200
     0.786     5.589     0.200
     0.796     5.246     0.200
     0.805     5.603     0.200
     0.827     5.918     0.200
     0.836     5.848     0.200
     0.831     5.048     0.200
     0.836     6.193     0.200
     0.832     6.314     0.200
     0.850     5.262     0.200
     0.887     6.487     0.200
     0.902     6.108     0.200
     0.936     5.932     0.200
     0.934     5.977     0.200
     0.974     6.114     0.200
     1.014     5.880     0.200
     1.014     6.147     0.200
     1.122     7.120     0.200
     1.125     6.914     0.200
     1.167     6.922     0.200
     1.186     7.882     0.200
     1.266     7.713     0.200
     1.318     7.921     0.200
     1.429     8.570     0.200
     2.565    15.206     0.200
     0.063     1.502     0.200
     0.106     1.945     0.200
     0.120     1.767     0.200
     0.162     2.501     0.200
     0.156     2.179     0.200
     0.187     2.753     0.200
     0.173     2.282     0.200
     0.181     2.392     0.200
     0.194     2.285     0.200
     0.188     2.402     0.200
     0.247     2.973     0.200
     0.292     3.357     0.200
     0.316     3.407     0.200
     0.343     3.233     0.200
     0.322     2.522     0.200
     0.357     3.078     0.200
     0.366     3.210     0.200
     0.399     2.941     0.200
     0.443     4.029     0.200
     0.426     3.026     0.200
     0.454     3.902     0.200
     0.438     4.159     0.200
     0.446     3.838     0.200
     0.471     3.552     0.200
     0.482     3.419     0.200
     0.483     3.805     0.200
     0.502     4.279     0.200
     0.514     4.062     0.200
     0.551     4.447     0.200
     0.564     4.799     0.200
     0.555     4.341     0.200
     0.609     4.620     0.200
     0.618     4.317     0.200
     0.635     4.765     0.200
     0.645     4.824     0.200
     0.650     4.160     0.200
     0.722     5.304     0.200
     0.703     5.337     0.200
     0.725     5.160     0.200
     0.744     5.558     0.200
     0.744     5.457     0.200
     0.760     5.571     0.200
     0.747     5.699     0.200
     0.767     4.753     0.200
     0.774     5.375     0.200
     0.787     5.484     0.200
     0.789     5.334     0.200
     0.801     5.102     0.200
     0.807     5.459     0.200
     0.828     6.226     0.200
     0.839     6.013     0.200
     0.833     5.659     0.200
     0.829     4.727     0.200
     0.841     5.772     0.200
     0.893     5.815     0.200
     0.907     5.817     0.200
     0.940     5.837     0.200
     0.935     5.888     0.200
     0.964     6.521     0.200
     1.018     6.106     0.200
     1.018     5.944     0.200
     1.065     5.757     0.200
     1.126     6.801     0.200
     1.172     6.975     0.200
     1.182     6.868     0.200
     1.264     7.209     0.200
     1.323     7.260     0.200
     1.018     6.155     0.200
     0.101     2.099     0.200
     0.118     1.634     0.200
     0.122     1.766     0.200
     0.160     2.275     0.200
     0.156     2.511     0.200
     0.178     2.449     0.200
     0.187     2.458     0.200
     0.181     2.826     0.200
     0.191     2.234     0.200
     0.194     2.461     0.200
     0.242     2.933     0.200
     0.249     2.799     0.200
     0.290     3.503     0.200
     0.321     3.331     0.200
     0.329     2.674     0.200
     0.337     3.270     0.200
     0.365     3.152     0.200
     0.360     3.166     0.200
     0.405     3.072     0.200
     0.432     3.326     0.200
     0.447     3.629     0.200
     0.443     4.104     0.200
     0.449     3.904     0.200
     0.465     3.601     0.200
     0.479     3.428     0.200
     0.487     3.961     0.200
     0.500     4.346     0.200
     0.514     3.927     0.200
     0.559     4.247     0.200
     0.557     4.293     0.200
     0.564     4.801     0.200
     0.605     4.647     0.200
     0.614     4.060     0.200
     0.637     4.865     0.200
     0.648     4.106     0.200
     0.645     4.936     0.200
     0.706     5.510     0.200
     0.698     5.180     0.200
     0.715     5.291     0.200
     0.727     5.199     0.200
     0.749     5.444     0.200
     0.751     5.701     0.200
     0.749     5.506     0.200
     0.765     5.004     0.200
     0.768     5.356     0.200
     0.782     5.142     0.200
     0.800     5.271     0.200
     0.803     5.344     0.200
     0.822     6.187     0.200
     0.835     4.823     0.200
     0.836     5.685     0.200
     0.835     5.941     0.200
     0.858     5.418     0.200
     0.850     5.247     0.200
     0.894     5.839     0.200
     0.910     5.842     0.200
     0.942     5.861     0.200
     0.938     5.867     0.200
     0.984     6.108     0.200
     1.016     6.055     0.200
     1.015     6.001     0.200
     1.064     5.502     0.200
     1.121     6.702     0.200
     1.132     7.676     0.200
     1.176     8.147     0.200
     1.174     6.569     0.200
     1.258     8.253     0.200
     1.323     7.173     0.200
     1.015     5.580     0.200
     0.146     1.859     0.200
     0.189     1.941     0.200
     0.187     2.063     0.200
     0.249     2.566     0.200
     0.252     2.537     0.200
     0.267     2.540     0.200
     0.283     2.941     0.200
     0.291     3.021     0.200
     0.352     3.202     0.200
     0.352     3.651     0.200
     0.355     3.297     0.200
     0.349     3.028     0.200
     0.365     3.852     0.200
     0.370     3.182     0.200
     0.392     3.439     0.200
     0.388     3.114     0.200
     0.401     3.995     0.200
     0.403     3.464     0.200
     0.390     3.156     0.200
     0.415     4.014     0.200
     0.420     3.111     0.200
     0.432     3.719     0.200
     0.426     3.253     0.200
     0.441     4.339     0.200
     0.445     3.661     0.200
     0.467     4.158     0.200
     0.479     3.470     0.200
     0.487     3.724     0.200
     0.541     4.002     0.200
     0.562     4.084     0.200
     0.568     4.386     0.200
     0.615     4.979     0.200
     0.622     5.297     0.200
     0.654     4.600     0.200
     0.646     4.713     0.200
     0.664     4.619     0.200
     0.668     5.038     0.200
     0.688     4.756     0.200
     0.695     4.871     0.200
     0.695     4.646     0.200
     0.688     4.774     0.200
     0.713     4.886     0.200
     0.741     4.986     0.200
     0.757     5.095     0.200
     0.773     5.266     0.200
     0.777     5.237     0.200
     0.791     5.425     0.200
     0.815     5.808     0.200
     0.824     5.872     0.200
     0.846     4.998     0.200
     0.840     5.538     0.200
     0.850     5.775     0.200
     0.863     5.234     0.200
     0.878     5.769     0.200
     0.885     6.178     0.200
     0.889     5.800     0.200
     0.903     5.514     0.200
     0.904     5.714     0.200
     0.915     5.888     0.200
     0.908     6.245     0.200
     0.935     6.537     0.200
     0.967     6.133     0.200
     0.969     6.136     0.200
     1.040     5.614     0.200
     1.067     6.776     0.200
     1.066     7.353     0.200
     1.079     5.669     0.200
     1.141     7.113     0.200
     0.114     1.340     0.200
     0.023     1.238     0.200
     0.146     1.705     0.200
     0.263     2.452     0.200
     0.289     2.670     0.200
     0.307     2.323     0.200
     0.330     2.802     0.200
     0.335     2.962     0.200
     0.249     2.473     0.200
     0.247     2.474     0.200
     0.377     2.728     0.200
     0.489     3.645     0.200
     0.646     5.252     0.200
     0.665     4.803     0.200
     0.745     5.679     0.200
     0.793     5.813     0.200
     0.779     5.960     0.200
     0.883     6.408     0.200
     0.830     6.355     0.200
     0.888     6.570     0.200
     0.906     6.365     0.200
     0.860     6.597     0.200
     0.982     7.487     0.200
     1.108     7.333     0.200
     1.076     7.239     0.200
     1.121     7.722     0.200
     1.290     7.779     0.200
     1.238     8.687     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.878    17.249     0.200
     0.883    18.076     0.200
     0.890    18.873     0.200
     0.947    19.372     0.200
     1.059    19.664     0.200
     1.114    22.603     0.200
     1.128    24.020     0.200
     1.200    23.260     0.200
     1.384    27.860     0.200
     1.418    28.130     0.200
     0.928    18.796     0.200
     0.964    19.919     0.200
     1.020    20.558     0.200
     1.209    24.108     0.200
     1.233    23.908     0.200
     1.248    24.164     0.200
     1.261    25.088     0.200
     1.406    27.343     0.200
     1.509    30.913     0.200
     1.513    28.311     0.200
     1.513    30.641     0.200
     4.430    67.439     0.200
     0.887    18.232     0.200
     0.945    19.121     0.200
     1.039    20.384     0.200
     1.065    21.986     0.200
     1.293    25.336     0.200
     1.327    26.306     0.200
     1.351    27.617     0.200
     1.435    27.841     0.200
     1.478    28.866     0.200
     0.865    17.518     0.200
     0.902    18.783     0.200
     1.304    26.147     0.200
     1.275    25.147     0.200
     1.386    28.292     0.200
     1.492    29.298     0.200
     1.496    30.212     0.200
     2.109    34.083     0.200
     2.225    35.467     0.200
     2.357    38.104     0.200
     2.358    37.440     0.200
     2.921    46.075     0.200
     3.079    47.178     0.200
     0.861    17.620     0.200
     0.904    18.800     0.200
     1.491    29.362     0.200
     1.497    29.981     0.200
     1.816    30.835     0.200
     2.106    34.227     0.200
     2.221    35.526     0.200
     2.354    37.407     0.200
     3.076    47.255     0.200
     3.133    48.453     0.200
     3.472    52.547     0.200
     3.598    53.700     0.200
     3.625    54.576     0.200
     3.655    54.911     0.200
     4.206    61.502     0.200
     0.876    17.435     0.200
     0.987    19.196     0.200
     1.052    20.155     0.200
     1.210    24.081     0.200
     1.188    23.167     0.200
     1.225    24.792     0.200
     1.299    26.269     0.200
     1.285    25.174     0.200
     1.373    27.856     0.200
     1.433    27.325     0.200
     1.394    26.732     0.200
     0.883    17.433     0.200
     0.987    18.959     0.200
     1.058    21.233     0.200
     1.054    21.017     0.200
     1.206    23.983     0.200
     1.194    23.184     0.200
     1.294    26.082     0.200
     1.283    23.637     0.200
     1.377    27.418     0.200
     1.431    27.763     0.200
     1.400    27.341     0.200
     1.497    27.471     0.200
     0.821    16.909     0.200
     0.821    16.561     0.200
     0.980    19.158     0.200
     0.971    19.889     0.200
     1.008    20.460     0.200
     1.108    21.716     0.200
     1.218    23.106     0.200
     1.270    24.282     0.200
     1.239    24.242     0.200
     1.401    25.566     0.200
     1.403    25.552     0.200
     1.350    27.380     0.200
     1.457    28.830     0.200
     1.812    28.326     0.200
     4.226    66.371     0.200
     4.644    68.135     0.200
     4.834    72.077     0.200
     7.189   103.347     0.200
     8.762   124.848     0.200
     9.654   136.263     0.200
     9.965   139.188     0.200
     0.993    20.102     0.200
     0.994    20.573     0.200
     1.115    21.595     0.200
     1.213    23.445     0.200
     1.250    24.263     0.200
     1.252    25.650     0.200
     1.374    25.720     0.200
     1.375    27.952     0.200
     1.486    30.005     0.200
     1.742    28.929     0.200
     3.341    53.799     0.200
     8.895   125.221     0.200
     0.946    19.183     0.200
     0.946    21.312     0.200
     1.093    21.849     0.200
     1.261    25.373     0.200
     1.376    26.930     0.200
     1.421    27.327     0.200
     1.515    29.702     0.200
     0.985    19.597     0.200
     0.975    20.643     0.200
     1.089    20.723     0.200
     1.066    21.715     0.200
     1.154    22.091     0.200
     1.169    23.761     0.200
     1.204    24.852     0.200
     1.264    24.076     0.200
     1.304    24.581     0.200
     1.268    25.476     0.200
     1.324    25.040     0.200
     1.332    26.879     0.200
     1.367    26.440     0.200
     1.478    28.285     0.200
     1.488    28.145     0.200
     0.923    19.058     0.200
     1.048    20.589     0.200
     1.121    21.416     0.200
     1.121    24.916     0.200
     1.286    25.569     0.200
     1.347    26.911     0.200
     0.929    18.752     0.200
     1.056    20.657     0.200
     1.053    20.220     0.200
     1.115    21.662     0.200
     1.282    25.653     0.200
     1.354    26.963     0.200
     1.473    29.254     0.200
     3.644    57.285     0.200
     4.750    72.146     0.200
     5.169    78.271     0.200
     5.893    85.958     0.200
     6.010    88.340     0.200
     6.045    89.610     0.200
     7.236   105.520     0.200
     0.846    17.041     0.200
     0.962    20.160     0.200
     1.305    25.709     0.200
     1.333    26.803     0.200
     1.422    27.392     0.200
     2.829    45.201     0.200
     7.418   104.941     0.200
     2.525    41.117     0.200
     4.932    72.509     0.200
     5.604    81.017     0.200
     7.106   100.780     0.200
     7.099   102.127     0.200
     7.858   111.292     0.200
    11.695   159.645     0.200
     0.944    21.414     0.200
     1.095    21.829     0.200
     1.220    23.476     0.200
     1.232    24.322     0.200
     1.232    25.791     0.200
     1.363    26.499     0.200
     2.692    42.838     0.200
     0.928    19.511     0.200
     0.995    21.350     0.200
     1.093    22.315     0.200
     1.227    23.674     0.200
     1.318    25.197     0.200
     1.344    28.040     0.200
     1.358    27.653     0.200
     1.455    28.580     0.200
     1.549    31.629     0.200
     1.562    30.162     0.200
     1.559    30.802     0.200
     0.940    19.254     0.200
     0.940    19.136     0.200
     0.998    19.780     0.200
     1.023    20.246     0.200
     1.114    20.847     0.200
     1.123    22.233     0.200
     1.154    21.876     0.200
     1.168    23.068     0.200
     1.303    24.341     0.200
     0.888    17.388     0.200
     0.862    16.947     0.200
     1.038    19.525     0.200
     1.156    22.875     0.200
     1.137    20.405     0.200
     1.219    23.785     0.200
     1.169    23.517     0.200
     1.190    23.533     0.200
     1.024    20.282     0.200
     1.349    26.956     0.200
     2.086    33.863     0.200
     2.087    33.598     0.200
     0.980    19.101     0.200
     0.980    19.648     0.200
     1.020    20.577     0.200
     1.127    21.842     0.200
     1.127    22.435     0.200
     1.128    21.583     0.200
     1.182    23.055     0.200
     1.266    23.762     0.200
     1.311    23.963     0.200
     0.893    19.026     0.200
     0.983    20.218     0.200
     0.983    22.351     0.200
     1.014    22.574     0.200
     1.077    21.813     0.200
     1.249    24.007     0.200
     1.249    24.796     0.200
     1.249    24.144     0.200
     1.249    24.367     0.200
     1.232    24.558     0.200
     1.275    25.190     0.200
     1.371    26.197     0.200
     1.364    26.383     0.200
     1.304    25.938     0.200
     1.391    26.970     0.200
     1.495    30.745     0.200
     1.539    31.187     0.200
     1.023    23.400     0.200
     1.065    22.386     0.200
     1.108    23.047     0.200
     1.195    25.939     0.200
     1.236    24.912     0.200
     1.236    25.242     0.200
     1.236    24.895     0.200
     1.236    24.976     0.200
     1.305    26.184     0.200
     1.305    26.516     0.200
     1.366    28.208     0.200
     1.366    29.968     0.200
     1.367    29.711     0.200
     1.367    26.772     0.200
     1.390    27.687     0.200
     1.456    29.120     0.200
     1.508    31.269     0.200
     1.508    31.899     0.200
     1.550    30.746     0.200
     1.550    32.572     0.200
     1.576    31.336     0.200
     2.627    44.919     0.200
     5.639    82.828     0.200
     6.814    99.272     0.200
     7.142   102.550     0.200
    11.375   160.366     0.200
    12.378   171.405     0.200
     1.025    20.834     0.200
     1.031    21.045     0.200
     1.046    20.974     0.200
     1.255    25.178     0.200
     1.348    26.539     0.200
     1.348    27.570     0.200
     1.384    26.769     0.200
     1.384    27.788     0.200
     1.394    27.799     0.200
     6.028    89.161     0.200
     0.938    19.108     0.200
     0.938    18.585     0.200
     0.975    19.698     0.200
     0.983    19.580     0.200
     1.031    20.398     0.200
     1.140    22.603     0.200
     1.140    22.040     0.200
     1.159    22.969     0.200
     1.159    21.469     0.200
     1.183    22.294     0.200
     1.183    24.880     0.200
     1.290    25.251     0.200
     1.468    26.296     0.200
     2.493    39.558     0.200
     3.641    53.716     0.200
     0.942    19.894     0.200
     0.946    19.476     0.200
     0.949    19.689     0.200
     0.949    19.306     0.200
     0.986    19.591     0.200
     0.994    19.857     0.200
     1.037    20.833     0.200
     1.131    23.140     0.200
     1.131    22.249     0.200
     1.168    23.486     0.200
     1.195    22.302     0.200
     1.302    25.104     0.200
     1.302    24.362     0.200
     0.938    19.704     0.200
     0.946    19.905     0.200
     0.946    19.210     0.200
     0.984    19.895     0.200
     0.995    19.513     0.200
     1.032    20.558     0.200
     1.109    20.977     0.200
     1.129    21.921     0.200
     1.171    22.777     0.200
     1.171    22.550     0.200
     1.302    25.033     0.200
     1.981    31.931     0.200
     0.937    19.163     0.200
     0.944    19.411     0.200
     0.981    20.196     0.200
     1.105    21.531     0.200
     1.167    23.089     0.200
     0.949    19.978     0.200
     0.952    19.980     0.200
     0.983    19.997     0.200
     1.145    22.481     0.200
     1.145    22.809     0.200
     1.155    22.110     0.200
     1.155    22.610     0.200
     1.294    24.790     0.200
     1.294    25.883     0.200
     0.941    19.155     0.200
     0.968    20.080     0.200
     1.047    20.166     0.200
     1.108    21.589     0.200
     1.191    23.597     0.200
     1.233    24.363     0.200
     1.254    24.819     0.200
     1.456    28.684     0.200
     0.935    19.698     0.200
     0.942    19.407     0.200
     0.992    19.707     0.200
     1.029    20.994     0.200
     1.107    21.108     0.200
     1.130    22.216     0.200
     1.169    23.194     0.200
     1.169    22.413     0.200
     1.193    22.825     0.200
     1.299    25.209     0.200
     2.461    39.753     0.200
     0.934    18.610     0.200
     0.942    19.187     0.200
     0.984    20.147     0.200
     1.017    20.688     0.200
     1.108    22.735     0.200
     1.108    22.125     0.200
     1.191    24.084     0.200
     1.191    23.209     0.200
     1.314    24.559     0.200
     1.480    29.023     0.200
     0.950    18.504     0.200
     0.957    19.087     0.200
     0.984    19.944     0.200
     1.189    22.346     0.200
     1.189    23.049     0.200
     1.266    24.782     0.200
     1.472    29.732     0.200
     1.559    25.856     0.200
     4.324    66.065     0.200
     0.942    19.069     0.200
     0.950    20.224     0.200
     0.950    19.200     0.200
     1.008    20.008     0.200
     1.008    20.883     0.200
     0.989    20.141     0.200
     1.028    20.714     0.200
     1.122    21.332     0.200
     1.184    23.951     0.200
     1.184    23.061     0.200
     1.115    22.403     0.200
     1.208    22.888     0.200
     1.620    28.088     0.200
     0.948    18.869     0.200
     0.952    19.697     0.200
     0.955    19.500     0.200
     0.955    19.324     0.200
     0.996    20.318     0.200
     1.014    20.168     0.200
     1.032    21.015     0.200
     1.127    21.967     0.200
     1.111    21.442     0.200
     1.189    23.607     0.200
     1.320    25.201     0.200
     1.320    25.197     0.200
     2.550    38.916     0.200
     6.555    90.280     0.200
     7.850   106.638     0.200
     0.942    18.768     0.200
     0.974    19.312     0.200
     0.976    19.538     0.200
     1.040    20.412     0.200
     1.087    20.621     0.200
     1.148    23.341     0.200
     1.148    22.958     0.200
     1.151    22.283     0.200
     1.196    23.064     0.200
     1.284    24.286     0.200
     0.926    19.089     0.200
     0.930    18.588     0.200
     0.933    18.831     0.200
     0.933    19.459     0.200
     0.970    19.638     0.200
     0.970    19.518     0.200
     0.968    19.828     0.200
     1.033    20.844     0.200
     1.084    21.607     0.200
     1.153    22.588     0.200
     1.153    22.862     0.200
     1.146    22.798     0.200
     1.146    23.207     0.200
     1.170    22.738     0.200
     1.277    24.305     0.200
     3.494    54.203     0.200
     3.552    52.762     0.200
     3.642    54.336     0.200
     3.730    55.660     0.200
     3.955    56.564     0.200
     0.933    18.622     0.200
     1.015    19.831     0.200
     1.127    23.884     0.200
     1.255    23.979     0.200
     1.337    25.887     0.200
     2.697    43.698     0.200
     0.975    20.571     0.200
     1.240    25.228     0.200
     1.240    24.884     0.200
     1.291    27.303     0.200
     1.280    26.974     0.200
     1.331    26.557     0.200
     1.360    26.476     0.200
     1.417    28.345     0.200
     1.441    28.993     0.200
     1.542    31.797     0.200
     1.555    32.063     0.200
     1.023    20.392     0.200
     0.993    20.313     0.200
     1.379    27.581     0.200
     1.481    28.502     0.200
     2.190    36.124     0.200
     3.088    45.591     0.200
     3.088    46.404     0.200
     0.859    17.489     0.200
     0.834    17.453     0.200
     0.915    18.024     0.200
     0.968    19.747     0.200
     1.093    20.379     0.200
     1.211    22.951     0.200
     1.224    23.655     0.200
     1.274    25.705     0.200
     1.315    26.663     0.200
     0.854    17.341     0.200
     0.897    18.095     0.200
     0.852    18.169     0.200
     1.196    23.028     0.200
     1.240    24.805     0.200
     1.275    25.475     0.200
     1.330    26.384     0.200
     0.825    17.511     0.200
     0.851    18.125     0.200
     0.964    20.603     0.200
     1.008    20.276     0.200
     1.039    20.345     0.200
     1.312    25.253     0.200
     0.987    21.496     0.200
     1.499    31.422     0.200
     1.004    21.201     0.200
     1.031    20.698     0.200
     1.064    21.601     0.200
     1.263    24.096     0.200
     1.263    24.924     0.200
     1.278    24.549     0.200
     0.839    17.032     0.200
     1.009    20.485     0.200
     1.062    20.431     0.200
     1.312    25.007     0.200
     1.377    26.559     0.200
     1.474    29.628     0.200
     2.627    42.386     0.200
     0.842    16.834     0.200
     0.807    16.488     0.200
     0.844    16.457     0.200
     0.830    19.519     0.200
     0.918    17.705     0.200
     0.936    18.322     0.200
     0.967    19.292     0.200
     1.024    20.013     0.200
     1.024    19.684     0.200
     0.985    20.094     0.200
     1.013    20.049     0.200
     1.029    20.451     0.200
     1.066    20.045     0.200
     1.063    20.818     0.200
     1.069    22.149     0.200
     1.094    22.031     0.200
     1.094    21.850     0.200
     1.151    21.564     0.200
     1.124    22.203     0.200
     1.156    23.341     0.200
     1.201    23.880     0.200
     1.207    24.227     0.200
     1.271    23.843     0.200
     1.259    25.186     0.200
     1.285    24.627     0.200
     1.285    24.230     0.200
     1.310    25.644     0.200
     1.361    26.979     0.200
     1.470    28.909     0.200
     0.868    19.334     0.200
     1.025    21.097     0.200
     1.130    22.453     0.200
     1.205    23.688     0.200
     1.217    25.133     0.200
     1.288    24.134     0.200
     1.383    26.937     0.200
     1.025    21.205     0.200
     1.025    21.327     0.200
     1.078    21.867     0.200
     1.088    21.963     0.200
     1.191    23.566     0.200
     1.196    23.544     0.200
     1.202    24.062     0.200
     1.234    25.338     0.200
     1.336    27.161     0.200
     1.375    26.638     0.200
     1.384    27.867     0.200
     1.435    28.657     0.200
     1.076    21.950     0.200
     1.076    22.236     0.200
     1.117    22.592     0.200
     1.181    23.863     0.200
     1.192    23.981     0.200
     1.192    23.565     0.200
     1.231    24.608     0.200
     1.242    25.618     0.200
     1.249    24.985     0.200
     1.257    24.665     0.200
     1.273    25.711     0.200
     1.330    27.492     0.200
     1.364    26.994     0.200
     1.385    28.183     0.200
     1.444    29.109     0.200
     1.518    30.978     0.200
     0.807    17.301     0.200
     0.807    16.648     0.200
     0.834    17.361     0.200
     0.881    18.151     0.200
     0.984    19.550     0.200
     0.999    20.012     0.200
     0.990    20.851     0.200
     0.990    20.159     0.200
     1.094    21.356     0.200
     1.077    22.945     0.200
     1.077    21.226     0.200
     1.111    23.058     0.200
     1.165    22.884     0.200
     1.209    24.058     0.200
     1.250    23.160     0.200
     1.250    23.214     0.200
     1.059    20.051     0.200
     1.002    20.298     0.200
     1.051    20.487     0.200
     1.233    24.149     0.200
     1.454    25.739     0.200
     0.749    15.040     0.200
     0.910    19.332     0.200
     0.979    19.845     0.200
     1.089    20.440     0.200
     1.189    23.037     0.200
     1.225    24.174     0.200
     1.242    23.940     0.200
     1.285    25.163     0.200
     1.310    25.175     0.200
     1.384    26.535     0.200
     6.894    99.040     0.200
     0.842    17.060     0.200
     0.842    17.204     0.200
     0.832    17.915     0.200
     0.807    17.245     0.200
     0.846    18.667     0.200
     0.883    17.396     0.200
     0.858    17.458     0.200
     0.853    17.615     0.200
     0.852    17.357     0.200
     0.895    19.814     0.200
     0.895    20.275     0.200
     0.902    17.726     0.200
     0.905    18.929     0.200
     1.026    19.555     0.200
     1.281    24.576     0.200
     1.298    26.686     0.200
     1.385    28.387     0.200
     1.489    29.283     0.200
    21.661   286.496     0.200
     0.954    18.443     0.200
     0.963    18.663     0.200
     0.968    19.394     0.200
     1.078    20.883     0.200
     1.233    23.777     0.200
     1.282    24.210     0.200
     0.930    18.010     0.200
     1.022    19.611     0.200
     1.132    21.713     0.200
     1.190    22.075     0.200
     1.310    23.863     0.200
     2.509    38.650     0.200
     0.805    16.537     0.200
     0.808    16.620     0.200
     0.808    18.459     0.200
     0.856    17.194     0.200
     0.863    17.631     0.200
     0.868    18.063     0.200
     0.871    17.783     0.200
     0.871    17.889     0.200
     0.879    18.452     0.200
     0.907    18.481     0.200
     0.916    18.526     0.200
     0.921    19.105     0.200
     1.011    20.182     0.200
     1.037    21.573     0.200
     1.057    20.938     0.200
     1.116    22.111     0.200
     1.125    22.162     0.200
     1.125    22.466     0.200
     1.164    23.308     0.200
     1.241    24.925     0.200
     1.305    26.433     0.200
     1.355    27.453     0.200
     0.844    18.328     0.200
     0.863    18.459     0.200
     0.877    18.418     0.200
     0.945    20.530     0.200
     0.934    20.618     0.200
     1.007    19.846     0.200
     0.978    20.960     0.200
     1.059    21.014     0.200
     1.225    23.366     0.200
     1.255    25.202     0.200
     1.371    27.692     0.200
     1.473    30.038     0.200
     0.850    18.713     0.200
     0.866    18.341     0.200
     0.879    18.874     0.200
     0.940    20.207     0.200
     0.946    20.377     0.200
     0.985    20.266     0.200
     1.036    20.769     0.200
     1.057    21.557     0.200
     1.117    23.661     0.200
     1.161    23.297     0.200
     1.210    24.213     0.200
     1.221    24.427     0.200
     1.222    24.523     0.200
     1.257    27.147     0.200
     1.376    29.388     0.200
     0.851    18.405     0.200
     0.875    18.011     0.200
     0.889    18.880     0.200
     0.940    20.141     0.200
     0.950    20.165     0.200
     0.959    20.466     0.200
     0.968    20.783     0.200
     1.054    20.649     0.200
     1.074    21.590     0.200
     1.074    22.201     0.200
     1.088    21.548     0.200
     1.179    23.498     0.200
     1.268    25.966     0.200
     1.379    28.433     0.200
     0.847    17.728     0.200
     0.863    17.885     0.200
     0.876    18.249     0.200
     0.942    19.753     0.200
     1.000    19.494     0.200
     1.034    19.991     0.200
     1.054    20.790     0.200
     1.062    21.868     0.200
     1.109    21.249     0.200
     1.219    22.971     0.200
     1.257    23.560     0.200
     1.374    27.104     0.200
     0.847    18.056     0.200
     0.863    17.927     0.200
     0.876    18.399     0.200
     0.937    19.639     0.200
     0.943    19.559     0.200
     0.943    19.252     0.200
     0.985    19.558     0.200
     1.001    19.622     0.200
     1.035    20.929     0.200
     1.055    20.882     0.200
     1.062    21.930     0.200
     1.108    21.541     0.200
     1.115    21.629     0.200
     1.115    23.190     0.200
     1.160    22.156     0.200
     1.219    23.102     0.200
     1.220    22.968     0.200
     1.220    23.242     0.200
     1.373    25.227     0.200
     1.662    28.449     0.200
     0.843    17.269     0.200
     0.843    17.585     0.200
     0.879    18.477     0.200
     0.890    18.701     0.200
     0.903    18.913     0.200
     0.932    20.039     0.200
     0.951    20.461     0.200
     0.953    20.230     0.200
     1.033    21.355     0.200
     1.033    22.057     0.200
     1.310    24.845     0.200
     0.889    18.965     0.200
     0.940    19.730     0.200
     0.977    19.727     0.200
     0.987    20.514     0.200
     0.981    19.422     0.200
     0.981    19.625     0.200
     1.031    20.694     0.200
     1.050    21.773     0.200
     1.079    21.138     0.200
     1.088    20.937     0.200
     1.154    23.583     0.200
     1.192    22.351     0.200
     1.192    22.547     0.200
     1.219    25.769     0.200
     1.306    25.381     0.200
     0.892    19.053     0.200
     0.938    19.733     0.200
     0.952    19.206     0.200
     0.976    19.615     0.200
     0.985    19.452     0.200
     0.985    20.382     0.200
     0.979    19.530     0.200
     1.032    20.707     0.200
     1.011    20.125     0.200
     1.048    21.341     0.200
     1.068    22.243     0.200
     1.086    20.857     0.200
     1.077    20.928     0.200
     1.154    23.414     0.200
     1.191    22.456     0.200
     1.191    22.354     0.200
     1.191    23.862     0.200
     1.215    23.034     0.200
     1.215    23.425     0.200
     1.215    24.190     0.200
     1.219    24.952     0.200
     1.271    23.343     0.200
     1.304    25.403     0.200
     1.501    30.739     0.200
     0.866    18.261     0.200
     0.870    17.757     0.200
     0.899    18.508     0.200
     0.906    18.189     0.200
     1.036    20.830     0.200
     1.022    20.817     0.200
     1.064    20.863     0.200
     1.119    22.365     0.200
     1.181    23.247     0.200
     1.248    25.030     0.200
     0.880    18.500     0.200
     0.900    19.674     0.200
     0.972    19.830     0.200
     0.980    20.699     0.200
     0.981    20.165     0.200
     0.988    20.144     0.200
     0.992    20.537     0.200
     1.081    21.772     0.200
     1.084    21.111     0.200
     1.082    22.276     0.200
     1.084    23.760     0.200
     1.122    22.882     0.200
     1.179    23.080     0.200
     1.197    22.910     0.200
     1.216    24.235     0.200
     1.232    25.610     0.200
     1.237    24.387     0.200
     1.237    23.567     0.200
     1.292    25.471     0.200
     1.350    27.738     0.200
     0.781    16.343     0.200
     0.803    16.680     0.200
     0.817    18.620     0.200
     0.843    17.462     0.200
     0.855    17.303     0.200
     0.855    16.833     0.200
     0.868    17.881     0.200
     0.914    18.613     0.200
     0.925    18.077     0.200
     0.928    18.200     0.200
     1.076    21.724     0.200
     1.161    23.379     0.200
     1.235    24.055     0.200
     1.321    25.366     0.200
     1.304    26.126     0.200
     1.444    27.730     0.200
     1.457    28.020     0.200
     0.780    15.995     0.200
     0.809    16.166     0.200
     0.829    16.820     0.200
     0.829    16.242     0.200
     0.837    17.357     0.200
     0.837    17.482     0.200
     0.900    17.979     0.200
     0.908    17.792     0.200
     0.908    17.995     0.200
     0.962    20.398     0.200
     1.010    19.820     0.200
     1.094    21.410     0.200
     1.185    22.803     0.200
     1.207    23.683     0.200
     1.317    26.354     0.200
     1.340    27.368     0.200
     1.434    29.139     0.200
     1.469    28.931     0.200
     3.819    58.826     0.200
     0.842    18.290     0.200
     0.904    19.445     0.200
     0.908    18.752     0.200
     1.008    20.328     0.200
     1.028    20.496     0.200
     1.023    20.355     0.200
     1.103    23.258     0.200
     1.152    23.538     0.200
     1.218    23.486     0.200
     1.270    24.725     0.200
     1.435    29.118     0.200
     0.754    15.364     0.200
     0.754    15.147     0.200
     0.754    15.447     0.200
     0.788    18.454     0.200
     0.789    17.722     0.200
     0.778    16.110     0.200
     0.777    16.746     0.200
     0.805    16.440     0.200
     0.807    18.107     0.200
     0.859    16.747     0.200
     0.877    17.181     0.200
     0.876    17.541     0.200
     1.013    20.877     0.200
     1.229    23.936     0.200
     1.414    27.629     0.200
     0.844    17.848     0.200
     0.941    19.542     0.200
     0.968    19.921     0.200
     1.003    20.328     0.200
     1.190    24.273     0.200
     1.276    24.720     0.200
     1.457    29.571     0.200
     2.854    44.055     0.200
     0.841    18.379     0.200
     0.908    19.478     0.200
     0.903    18.498     0.200
     0.903    19.091     0.200
     0.942    19.221     0.200
     1.007    20.378     0.200
     1.019    20.327     0.200
     1.033    20.733     0.200
     1.099    22.961     0.200
     1.151    23.315     0.200
     1.222    23.397     0.200
     1.430    29.101     0.200
     0.802    16.369     0.200
     0.800    16.799     0.200
     0.831    17.297     0.200
     0.834    17.447     0.200
     0.843    17.379     0.200
     0.880    18.118     0.200
     0.918    18.618     0.200
     0.913    19.681     0.200
     0.929    19.429     0.200
     1.030    20.440     0.200
     1.036    19.988     0.200
     1.107    22.086     0.200
     1.250    23.534     0.200
     1.379    27.878     0.200
     2.441    39.839     0.200
     0.978    20.270     0.200
     1.012    20.736     0.200
     1.020    20.856     0.200
     1.029    21.234     0.200
     1.073    23.424     0.200
     1.165    23.110     0.200
     1.165    22.988     0.200
     1.326    27.271     0.200
     1.325    26.645     0.200
     1.406    29.013     0.200
     1.415    29.088     0.200
     1.520    29.362     0.200
     1.561    30.905     0.200
     2.265    38.485     0.200
     3.711    58.053     0.200
     4.459    69.772     0.200
     4.947    75.869     0.200
     0.803    16.954     0.200
     0.829    17.003     0.200
     0.835    18.202     0.200
     0.894    17.778     0.200
     0.863    17.640     0.200
     0.908    18.259     0.200
     0.890    18.578     0.200
     0.992    20.099     0.200
     1.039    21.021     0.200
     1.039    23.103     0.200
     1.052    21.599     0.200
     0.787    18.090     0.200
     0.814    16.642     0.200
     0.830    17.417     0.200
     0.837    17.440     0.200
     0.850    17.962     0.200
     0.902    18.160     0.200
     0.902    20.841     0.200
     0.922    18.990     0.200
     0.961    19.246     0.200
     0.972    19.476     0.200
     0.972    19.310     0.200
     0.991    19.818     0.200
     0.993    19.623     0.200
     1.036    20.052     0.200
     1.060    20.316     0.200
     1.077    20.570     0.200
     1.123    22.266     0.200
     1.126    22.494     0.200
     1.192    24.355     0.200
     1.207    22.745     0.200
     1.221    22.986     0.200
     1.332    26.186     0.200
     1.348    26.210     0.200
     1.365    25.828     0.200
     1.409    27.249     0.200
     1.409    27.114     0.200
     1.456    26.412     0.200
     0.848    17.442     0.200
     0.867    17.746     0.200
     0.878    18.060     0.200
     0.895    19.188     0.200
     0.931    18.969     0.200
     0.929    18.826     0.200
     4.787    71.506     0.200
     0.862    19.122     0.200
     0.989    20.653     0.200
     0.810    17.014     0.200
     0.856    18.367     0.200
     0.872    17.890     0.200
     0.863    19.245     0.200
     0.891    18.427     0.200
     0.957    19.706     0.200
     1.005    20.096     0.200
     0.993    20.075     0.200
     1.028    20.146     0.200
     1.051    21.142     0.200
     0.861    19.168     0.200
     0.890    19.057     0.200
     0.899    19.402     0.200
     0.898    18.491     0.200
     0.896    18.652     0.200
     0.902    20.413     0.200
     0.810    17.389     0.200
     0.851    17.628     0.200
     0.867    18.433     0.200
     0.867    18.622     0.200
     0.916    19.509     0.200
     0.717    14.371     0.200
     0.726    15.172     0.200
     0.752    15.252     0.200
     0.768    15.822     0.200
     0.782    16.042     0.200
     0.785    15.428     0.200
     0.810    16.173     0.200
     0.852    16.798     0.200
     0.846    16.530     0.200
     0.875    16.694     0.200
     0.895    17.346     0.200
     0.899    16.971     0.200
     0.974    18.538     0.200
     0.971    18.758     0.200
     1.014    19.946     0.200
     1.018    20.020     0.200
     1.006    19.351     0.200
     1.027    19.791     0.200
     1.023    20.544     0.200
     1.039    20.249     0.200
     1.040    20.078     0.200
     1.071    22.482     0.200
     1.072    20.566     0.200
     0.831    18.339     0.200
     0.967    20.630     0.200
     0.983    20.805     0.200
     0.987    21.017     0.200
     1.011    20.951     0.200
     0.899    19.553     0.200
     0.904    19.074     0.200
     0.911    20.205     0.200
     0.987    20.177     0.200
     0.840    18.199     0.200
     0.845    17.483     0.200
     0.905    19.260     0.200
     0.914    18.709     0.200
     1.075    21.560     0.200
     1.288    24.770     0.200
     0.827    18.110     0.200
     0.833    17.906     0.200
     0.884    18.993     0.200
     0.899    19.136     0.200
     0.973    20.008     0.200
     0.974    20.772     0.200
     0.993    20.955     0.200
     0.965    20.880     0.200
     0.975    20.241     0.200
     1.071    21.584     0.200
     1.075    22.114     0.200
     1.094    22.852     0.200
     1.285    24.657     0.200
     1.388    28.587     0.200
     1.394    27.900     0.200
     1.490    29.376     0.200
     1.534    29.805     0.200
     0.834    17.620     0.200
     0.907    18.559     0.200
     0.910    18.507     0.200
     0.947    19.318     0.200
     0.970    19.550     0.200
     0.970    19.244     0.200
     0.994    20.170     0.200
     1.079    21.279     0.200
     1.124    21.793     0.200
     0.938    19.925     0.200
     0.985    20.946     0.200
     0.907    19.568     0.200
     0.946    19.558     0.200
     0.946    19.332     0.200
     0.976    19.549     0.200
     0.981    20.054     0.200
     0.993    20.236     0.200
     0.999    19.924     0.200
     1.084    21.217     0.200
     1.204    23.231     0.200
     0.821    17.243     0.200
     0.834    17.788     0.200
     0.887    18.061     0.200
     0.907    18.010     0.200
     0.971    18.952     0.200
     1.000    20.375     0.200
     1.001    19.363     0.200
     1.084    21.071     0.200
     1.124    21.230     0.200
     1.142    22.801     0.200
     1.157    22.587     0.200
     1.167    22.894     0.200
     0.827    18.387     0.200
     0.881    19.013     0.200
     0.877    18.668     0.200
     0.897    19.094     0.200
     0.901    18.391     0.200
     0.901    19.277     0.200
     0.938    20.016     0.200
     1.087    21.295     0.200
     1.119    21.935     0.200
     1.157    23.110     0.200
    10.063   141.441     0.200
     0.836    17.256     0.200
     0.889    18.033     0.200
     0.892    18.760     0.200
     0.931    18.713     0.200
     0.931    18.933     0.200
     0.969    18.883     0.200
     0.986    19.789     0.200
     1.094    21.121     0.200
     1.116    20.944     0.200
     0.890    18.073     0.200
     0.912    18.583     0.200
     0.912    18.384     0.200
     0.830    17.032     0.200
     0.834    17.200     0.200
     0.881    18.437     0.200
     0.892    18.119     0.200
     0.895    18.321     0.200
     0.885    17.884     0.200
     0.935    19.220     0.200
     0.975    20.067     0.200
     0.977    19.860     0.200
     1.052    20.154     0.200
     1.084    21.592     0.200
     1.098    22.452     0.200
     1.122    21.712     0.200
     1.317    26.163     0.200
     0.845    17.840     0.200
     0.900    18.502     0.200
     0.907    18.657     0.200
     0.948    19.386     0.200
     0.907    18.087     0.200
     0.843    17.563     0.200
     0.878    18.018     0.200
     0.905    18.828     0.200
     0.908    18.837     0.200
     0.908    18.611     0.200
     1.097    21.790     0.200
     1.135    21.948     0.200
     1.126    21.584     0.200
     1.144    22.304     0.200
     0.832    17.746     0.200
     0.832    17.512     0.200
     0.851    17.733     0.200
     0.865    18.799     0.200
     0.819    16.865     0.200
     0.884    18.329     0.200
     0.894    19.190     0.200
     0.894    18.815     0.200
     0.922    19.665     0.200
     0.941    20.557     0.200
     0.944    19.773     0.200
     0.932    20.202     0.200
     1.003    20.405     0.200
     1.024    22.380     0.200
     1.046    20.429     0.200
     1.231    23.148     0.200
     0.825    17.266     0.200
     0.824    17.287     0.200
     0.824    17.115     0.200
     0.880    18.758     0.200
     0.878    18.390     0.200
     0.910    19.620     0.200
     1.005    20.445     0.200
     1.054    22.541     0.200
     1.202    22.423     0.200
     0.842    17.648     0.200
     0.788    17.166     0.200
     0.800    17.260     0.200
     0.827    16.401     0.200
     0.855    16.308     0.200
     0.895    17.523     0.200
     0.912    17.753     0.200
     0.912    18.292     0.200
     0.924    17.830     0.200
     0.923    18.833     0.200
     0.936    17.775     0.200
     0.940    19.326     0.200
     0.955    20.283     0.200
     1.172    21.122     0.200
     1.155    22.094     0.200
     1.145    22.322     0.200
     0.824    17.503     0.200
     0.826    17.864     0.200
     0.835    17.660     0.200
     0.869    18.288     0.200
     0.885    19.177     0.200
     0.885    19.099     0.200
     0.907    19.131     0.200
     0.914    19.956     0.200
     0.920    19.017     0.200
     0.933    19.186     0.200
     1.009    20.501     0.200
     0.849    17.873     0.200
     0.825    17.548     0.200
     0.852    17.739     0.200
     0.866    17.782     0.200
     0.884    18.775     0.200
     0.883    18.556     0.200
     0.875    19.166     0.200
     0.912    19.524     0.200
     0.919    18.954     0.200
     0.933    19.434     0.200
     0.932    20.047     0.200
     0.940    19.264     0.200
     0.975    19.602     0.200
     1.014    20.180     0.200
     1.004    20.512     0.200
     1.072    20.722     0.200
     1.134    21.982     0.200
     0.821    17.020     0.200
     0.823    17.475     0.200
     0.838    17.166     0.200
     0.845    17.485     0.200
     0.860    17.913     0.200
     0.871    18.687     0.200
     0.890    19.150     0.200
     0.896    19.350     0.200
     0.903    19.439     0.200
     0.903    19.580     0.200
     0.920    19.498     0.200
     0.923    19.977     0.200
     0.940    19.225     0.200
     0.936    19.385     0.200
     0.987    19.931     0.200
     1.003    20.829     0.200
     1.026    20.687     0.200
     1.031    21.019     0.200
     1.034    20.308     0.200
     1.093    21.277     0.200
     1.152    22.028     0.200
     1.181    24.109     0.200
     1.196    24.714     0.200
     1.201    24.065     0.200
     1.234    23.165     0.200
     1.276    24.392     0.200
     1.324    24.927     0.200
     0.739    16.458     0.200
     0.763    16.530     0.200
     0.795    15.704     0.200
     0.773    15.827     0.200
     0.806    17.087     0.200
     0.799    15.785     0.200
     0.824    16.356     0.200
     0.799    17.938     0.200
     0.813    17.314     0.200
     0.831    17.192     0.200
     0.833    17.186     0.200
     0.873    17.072     0.200
     0.880    17.308     0.200
     0.884    18.463     0.200
     0.884    17.756     0.200
     0.897    18.475     0.200
     0.909    19.206     0.200
     0.902    18.262     0.200
     0.924    18.496     0.200
     0.951    20.464     0.200
     0.959    18.707     0.200
     0.995    18.843     0.200
     1.007    18.936     0.200
     0.821    17.008     0.200
     0.825    17.461     0.200
     0.829    17.287     0.200
     0.831    17.996     0.200
     0.831    17.082     0.200
     0.855    17.636     0.200
     0.882    18.047     0.200
     0.883    18.723     0.200
     0.883    18.590     0.200
     0.894    18.604     0.200
     0.903    18.987     0.200
     0.899    18.285     0.200
     0.906    19.176     0.200
     0.914    19.545     0.200
     0.912    19.667     0.200
     0.934    19.549     0.200
     0.960    19.576     0.200
     1.009    20.128     0.200
     1.048    20.872     0.200
     1.064    20.936     0.200
     1.064    21.453     0.200
     1.079    22.509     0.200
     1.113    21.617     0.200
     1.099    22.206     0.200
     1.173    23.229     0.200
     1.170    23.898     0.200
     1.180    23.217     0.200
     1.188    24.022     0.200
     1.203    22.777     0.200
     1.210    23.680     0.200
     1.223    24.363     0.200
     1.225    24.405     0.200
     1.295    24.252     0.200
     1.304    25.328     0.200
     1.361    26.168     0.200
     1.467    26.640     0.200
     0.803    17.280     0.200
     0.812    16.540     0.200
     0.818    16.819     0.200
     0.822    17.045     0.200
     0.810    17.401     0.200
     0.828    17.294     0.200
     0.830    17.313     0.200
     0.852    17.400     0.200
     0.854    17.640     0.200
     0.878    17.792     0.200
     0.912    19.612     0.200
     0.894    18.410     0.200
     0.912    19.408     0.200
     0.900    18.611     0.200
     0.906    18.914     0.200
     0.930    19.082     0.200
     0.932    19.937     0.200
     0.943    19.335     0.200
     1.005    19.520     0.200
     1.012    20.601     0.200
     1.012    20.213     0.200
     1.051    20.241     0.200
     1.049    21.117     0.200
     0.797    16.729     0.200
     0.831    16.982     0.200
     0.849    17.421     0.200
     0.863    17.312     0.200
     0.852    18.327     0.200
     0.885    17.897     0.200
     0.865    18.155     0.200
     0.879    18.379     0.200
     0.886    18.282     0.200
     0.898    18.828     0.200
     0.898    18.809     0.200
     0.908    19.021     0.200
     0.926    18.910     0.200
     0.940    19.158     0.200
     0.953    18.991     0.200
     0.976    19.738     0.200
     0.979    19.921     0.200
     0.978    19.794     0.200
     0.977    21.388     0.200
     0.988    20.625     0.200
     1.043    20.170     0.200
     1.027    20.583     0.200
     1.042    19.977     0.200
     1.083    23.194     0.200
     1.070    21.071     0.200
     1.096    20.848     0.200
     1.145    21.515     0.200
     1.150    22.892     0.200
     1.172    22.014     0.200
     1.171    23.141     0.200
     1.187    22.545     0.200
     1.184    23.439     0.200
     1.219    22.821     0.200
     1.238    23.651     0.200
     1.277    23.553     0.200
     1.277    24.060     0.200
     1.278    23.576     0.200
     1.309    24.562     0.200
     1.320    24.299     0.200
     1.373    26.763     0.200
     7.832   111.072     0.200
    10.954   150.638     0.200
     0.813    17.633     0.200
     0.807    16.842     0.200
     0.880    18.022     0.200
     0.898    18.470     0.200
     0.906    18.735     0.200
     0.921    18.491     0.200
     0.908    18.004     0.200
     0.928    19.441     0.200
     0.985    19.250     0.200
     1.104    21.315     0.200
     0.800    16.861     0.200
     0.808    16.448     0.200
     0.808    16.482     0.200
     0.815    16.967     0.200
     0.834    17.188     0.200
     0.862    18.325     0.200
     0.862    18.154     0.200
     0.874    18.185     0.200
     0.885    19.164     0.200
     0.893    19.283     0.200
     0.881    17.922     0.200
     0.913    19.022     0.200
     1.097    20.592     0.200
     1.074    22.093     0.200
     1.107    22.289     0.200
     1.179    24.791     0.200
     1.204    22.800     0.200
     1.236    23.054     0.200
     0.826    17.387     0.200
     0.838    17.416     0.200
     0.866    18.971     0.200
     0.872    18.996     0.200
     0.887    19.435     0.200
     0.885    19.835     0.200
     0.967    20.488     0.200
     0.963    19.981     0.200
     0.960    20.165     0.200
     0.999    19.781     0.200
     1.020    20.374     0.200
     1.012    21.228     0.200
     1.012    21.055     0.200
     1.043    20.701     0.200
     0.824    17.441     0.200
     0.826    17.497     0.200
     0.831    17.667     0.200
     0.836    17.572     0.200
     0.846    18.719     0.200
     0.865    18.987     0.200
     0.884    19.360     0.200
     0.892    18.840     0.200
     0.919    18.485     0.200
     0.938    18.967     0.200
     0.961    20.694     0.200
     0.958    20.259     0.200
     0.961    19.212     0.200
     0.966    20.743     0.200
     0.973    19.696     0.200
     0.998    20.510     0.200
     1.000    19.679     0.200
     0.999    20.828     0.200
     1.011    20.824     0.200
     1.011    20.616     0.200
     1.015    21.309     0.200
     1.044    20.294     0.200
     1.050    21.242     0.200
     0.859    18.996     0.200
     0.886    18.400     0.200
     1.012    20.230     0.200
     1.006    21.132     0.200
     1.006    20.724     0.200
     1.035    20.705     0.200
     1.040    20.440     0.200
     1.048    21.042     0.200
     1.167    22.477     0.200
     1.216    23.608     0.200
     1.266    25.186     0.200
     1.344    26.709     0.200
     0.828    17.203     0.200
     0.831    17.433     0.200
     0.844    18.463     0.200
     0.856    17.622     0.200
     0.859    18.570     0.200
     0.879    19.202     0.200
     0.887    18.102     0.200
     0.929    18.836     0.200
     0.961    20.030     0.200
     0.991    19.736     0.200
     0.992    20.608     0.200
     1.006    20.566     0.200
     1.006    20.818     0.200
     1.025    20.905     0.200
     1.034    20.570     0.200
     1.039    20.755     0.200
     1.070    22.149     0.200
     1.085    21.426     0.200
     1.131    22.328     0.200
     1.215    23.925     0.200
     1.266    25.018     0.200
     0.818    17.421     0.200
     0.814    18.589     0.200
     0.833    17.347     0.200
     0.839    17.257     0.200
     0.858    17.488     0.200
     0.864    18.104     0.200
     0.887    18.582     0.200
     0.893    18.076     0.200
     0.893    18.686     0.200
     0.904    18.357     0.200
     0.918    19.002     0.200
     0.795    16.672     0.200
     0.799    16.400     0.200
     0.797    17.977     0.200
     0.811    17.604     0.200
     0.822    17.147     0.200
     0.824    17.251     0.200
     0.824    17.001     0.200
     0.836    17.196     0.200
     0.846    17.108     0.200
     0.911    18.333     0.200
     0.905    18.897     0.200
     0.908    18.498     0.200
     0.920    19.069     0.200
     1.003    20.124     0.200
     1.005    20.541     0.200
     1.015    19.909     0.200
     1.124    21.956     0.200
     0.750    15.476     0.200
     0.752    15.557     0.200
     0.743    15.478     0.200
     0.758    15.658     0.200
     0.794    15.768     0.200
     0.782    15.915     0.200
     0.823    16.617     0.200
     0.762    15.940     0.200
     0.833    16.444     0.200
     0.839    16.622     0.200
     0.780    16.992     0.200
     0.830    16.300     0.200
     0.854    17.179     0.200
     0.834    16.994     0.200
     0.830    16.432     0.200
     0.878    17.198     0.200
     0.878    17.328     0.200
     0.873    19.211     0.200
     0.807    17.914     0.200
     0.888    17.088     0.200
     0.917    17.455     0.200
     0.916    17.742     0.200
     0.922    17.582     0.200
     0.922    17.712     0.200
     0.932    18.825     0.200
     0.943    18.471     0.200
     0.943    18.741     0.200
     0.897    17.823     0.200
     0.903    18.364     0.200
     0.896    19.185     0.200
     0.904    18.583     0.200
     0.925    18.046     0.200
     1.182    22.438     0.200
     0.784    16.775     0.200
     0.779    16.535     0.200
     0.789    15.888     0.200
     0.797    16.690     0.200
     0.816    16.621     0.200
     0.819    17.124     0.200
     0.819    17.451     0.200
     0.831    16.364     0.200
     0.820    16.353     0.200
     0.841    17.499     0.200
     0.822    16.953     0.200
     0.837    17.434     0.200
     0.852    17.393     0.200
     0.840    17.118     0.200
     0.855    17.671     0.200
     0.854    17.957     0.200
     0.882    18.447     0.200
     0.871    17.314     0.200
     0.873    18.893     0.200
     0.885    19.334     0.200
     0.895    17.924     0.200
     0.918    19.448     0.200
     0.912    18.281     0.200
     0.921    20.179     0.200
     0.981    19.671     0.200
     1.011    20.420     0.200
     0.808    17.744     0.200
     0.823    18.845     0.200
     0.830    17.173     0.200
     0.829    17.376     0.200
     0.858    18.118     0.200
     0.862    17.505     0.200
     0.879    17.575     0.200
     0.891    18.136     0.200
     0.890    17.956     0.200
     0.918    18.525     0.200
     0.926    18.507     0.200
     0.930    18.756     0.200
     0.972    20.036     0.200
     0.981    19.095     0.200
     0.981    19.415     0.200
     0.985    19.439     0.200
     0.999    19.229     0.200
     1.018    20.044     0.200
     1.044    20.960     0.200
     1.061    21.171     0.200
     1.088    21.048     0.200
     1.088    21.595     0.200
     1.114    21.357     0.200
     1.139    22.174     0.200
     1.174    24.044     0.200
     1.169    22.435     0.200
     1.211    22.748     0.200
     1.211    22.756     0.200
     1.228    22.925     0.200
     1.228    23.128     0.200
     1.383    25.465     0.200
     1.446    28.512     0.200
     0.814    17.008     0.200
     0.825    17.689     0.200
     0.815    17.280     0.200
     0.848    19.155     0.200
     0.842    18.042     0.200
     0.837    18.135     0.200
     0.869    19.078     0.200
     0.866    17.720     0.200
     0.878    17.726     0.200
     0.860    18.430     0.200
     0.871    17.963     0.200
     0.848    18.588     0.200
     0.887    18.408     0.200
     0.890    18.520     0.200
     0.906    19.622     0.200
     0.997    19.444     0.200
     1.048    21.361     0.200
     1.110    21.107     0.200
     1.113    22.430     0.200
     1.117    22.150     0.200
     1.290    26.590     0.200
     1.361    24.879     0.200
     1.514    28.230     0.200
     0.774    16.139     0.200
     0.774    16.330     0.200
     0.788    16.463     0.200
     0.790    16.562     0.200
     0.824    17.392     0.200
     0.813    17.121     0.200
     0.810    16.888     0.200
     0.827    17.894     0.200
     0.821    17.722     0.200
     0.819    16.767     0.200
     0.828    16.507     0.200
     0.821    17.025     0.200
     0.820    16.882     0.200
     0.846    18.418     0.200
     0.831    17.925     0.200
     0.855    17.133     0.200
     0.865    19.085     0.200
     0.859    17.448     0.200
     0.873    17.013     0.200
     0.885    18.613     0.200
     0.877    18.251     0.200
     0.869    18.029     0.200
     0.903    20.190     0.200
     0.894    17.978     0.200
     0.887    17.899     0.200
     0.894    18.120     0.200
     0.913    19.185     0.200
     0.942    19.051     0.200
     0.977    18.508     0.200
     0.960    20.505     0.200
     1.011    19.090     0.200
     1.058    22.954     0.200
     1.096    21.174     0.200
     1.412    27.850     0.200
     1.453    28.271     0.200
     5.152    79.547     0.200
     0.827    18.350     0.200
     0.827    17.589     0.200
     0.858    18.039     0.200
     0.857    18.020     0.200
     0.889    19.282     0.200
     0.889    19.447     0.200
     0.913    18.664     0.200
     0.990    20.635     0.200
     1.042    20.565     0.200
     1.058    20.868     0.200
     1.079    22.248     0.200
     1.092    21.583     0.200
     1.092    21.848     0.200
     1.154    23.250     0.200
     1.183    24.403     0.200
     1.222    23.050     0.200
     1.214    24.661     0.200
     1.368    25.819     0.200
     0.824    17.506     0.200
     0.824    17.531     0.200
     0.860    17.891     0.200
     0.854    18.017     0.200
     0.861    18.511     0.200
     0.887    19.303     0.200
     0.885    19.429     0.200
     0.934    19.130     0.200
     0.940    20.345     0.200
     1.044    20.784     0.200
     1.094    22.045     0.200
     1.156    23.366     0.200
     1.223    23.076     0.200
     1.217    24.560     0.200
     0.842    17.704     0.200
     0.844    17.693     0.200
     0.844    17.678     0.200
     0.863    17.739     0.200
     0.889    18.089     0.200
     0.889    18.188     0.200
     0.883    19.003     0.200
     0.886    19.078     0.200
     0.904    19.314     0.200
     0.905    19.387     0.200
     0.917    18.495     0.200
     0.929    19.231     0.200
     1.042    20.092     0.200
     1.038    20.227     0.200
     1.097    21.061     0.200
     0.807    16.926     0.200
     0.805    16.538     0.200
     0.824    17.994     0.200
     0.837    17.088     0.200
     0.847    17.059     0.200
     0.847    17.338     0.200
     0.861    17.293     0.200
     0.884    18.385     0.200
     0.899    19.480     0.200
     0.916    19.281     0.200
     0.910    18.739     0.200
     0.918    19.366     0.200
     0.926    18.918     0.200
     1.204    22.399     0.200
     1.204    24.089     0.200
     1.204    24.970     0.200
    10.924   152.181     0.200
     0.778    15.932     0.200
     0.789    16.415     0.200
     0.787    16.560     0.200
     0.800    16.045     0.200
     0.790    16.633     0.200
     0.832    17.221     0.200
     0.853    16.704     0.200
     0.899    17.473     0.200
     0.898    18.060     0.200
     0.905    17.604     0.200
     0.894    18.327     0.200
     0.885    17.866     0.200
     0.909    17.603     0.200
     0.905    17.721     0.200
     0.977    18.879     0.200
     1.199    21.958     0.200
     1.248    23.792     0.200
     1.300    23.601     0.200
     1.319    25.486     0.200
     1.422    26.596     0.200
     0.825    17.062     0.200
     0.831    17.285     0.200
     0.848    17.520     0.200
     0.861    18.429     0.200
     0.979    19.170     0.200
     1.013    19.989     0.200
     0.800    17.173     0.200
     0.834    17.580     0.200
     0.822    18.149     0.200
     0.844    17.134     0.200
     0.921    20.112     0.200
     0.908    18.030     0.200
     0.935    19.793     0.200
     0.982    19.555     0.200
     1.044    20.486     0.200
     1.087    21.517     0.200
     1.093    20.808     0.200
     1.132    22.245     0.200
     1.175    22.520     0.200
     1.175    24.122     0.200
     1.192    22.340     0.200
     1.212    22.958     0.200
     0.827    17.362     0.200
     0.953    19.413     0.200
     1.013    20.553     0.200
     1.124    22.457     0.200
     1.167    22.243     0.200
     1.185    23.539     0.200
     1.265    25.632     0.200
     0.887    18.714     0.200
     0.974    19.450     0.200
     1.014    20.225     0.200
     1.070    24.556     0.200
     1.125    22.406     0.200
     0.828    17.007     0.200
     0.839    18.615     0.200
     0.833    17.268     0.200
     0.853    17.932     0.200
     0.856    17.599     0.200
     0.893    18.760     0.200
     0.914    20.212     0.200
     0.940    19.696     0.200
     0.964    19.122     0.200
     0.980    19.403     0.200
     1.018    20.069     0.200
     1.172    22.421     0.200
     1.182    23.266     0.200
     0.822    17.304     0.200
     0.836    17.450     0.200
     0.845    17.182     0.200
     0.850    17.474     0.200
     0.942    18.627     0.200
     0.938    19.711     0.200
     1.016    20.195     0.200
     1.176    23.912     0.200
     1.258    26.074     0.200
     0.824    16.712     0.200
     0.850    17.076     0.200
     0.851    16.957     0.200
     0.878    17.257     0.200
     0.885    18.069     0.200
     0.889    17.339     0.200
     0.904    18.675     0.200
     0.905    17.604     0.200
     0.915    18.036     0.200
     0.908    17.937     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.841    52.087     0.200
     3.920    78.011     0.200
     4.156    84.216     0.200
     4.266    84.592     0.200
     4.411    87.929     0.200
     4.445    90.809     0.200
     4.873   100.086     0.200
     5.035   104.364     0.200
     5.550   108.355     0.200
     5.725   116.955     0.200
     6.761   136.756     0.200
     6.802   134.688     0.200
     6.967   140.223     0.200
     6.997   140.457     0.200
     7.587   151.404     0.200
     8.044   157.601     0.200
     8.101   155.051     0.200
     8.643   175.139     0.200
     9.228   182.286     0.200
    11.448   225.013     0.200
     1.745    33.561     0.200
     1.768    34.054     0.200
     1.790    35.206     0.200
     1.805    35.973     0.200
     1.807    35.132     0.200
     1.900    35.884     0.200
     2.015    39.701     0.200
     2.027    40.719     0.200
     2.066    40.760     0.200
     2.098    40.270     0.200
     2.148    41.130     0.200
     2.164    42.734     0.200
     2.214    42.515     0.200
     2.387    45.646     0.200
     2.425    48.031     0.200
     2.547    49.332     0.200
     2.586    49.609     0.200
     2.814    53.066     0.200
     2.853    54.355     0.200
     2.963    56.246     0.200
     3.074    58.787     0.200
     3.972    79.111     0.200
     4.278    85.164     0.200
     4.342    85.744     0.200
     4.511    88.763     0.200
     4.809    97.290     0.200
     4.857    98.682     0.200
     6.601   133.774     0.200
     6.745   135.935     0.200
     6.872   139.264     0.200
     6.911   134.259     0.200
     6.950   137.758     0.200
     7.113   140.308     0.200
     7.483   152.643     0.200
     7.959   160.973     0.200
     8.002   156.286     0.200
     8.129   159.758     0.200
     8.350   173.167     0.200
     9.124   183.510     0.200
     1.700    33.455     0.200
     1.727    34.899     0.200
     1.741    34.165     0.200
     1.961    37.115     0.200
     1.922    38.425     0.200
     1.994    38.207     0.200
     1.993    38.007     0.200
     2.041    39.857     0.200
     1.960    38.108     0.200
     1.999    38.830     0.200
     2.209    42.742     0.200
     2.268    46.268     0.200
     2.320    45.622     0.200
     2.396    46.803     0.200
     2.384    46.700     0.200
     2.681    51.490     0.200
     2.673    51.235     0.200
     2.715    53.624     0.200
     2.696    52.179     0.200
     2.768    54.417     0.200
     2.793    54.925     0.200
     2.785    54.782     0.200
     3.050    58.780     0.200
     3.232    62.374     0.200
     3.830    73.906     0.200
     4.520    88.656     0.200
     4.561    90.493     0.200
     4.700    95.256     0.200
     4.947    99.192     0.200
     5.609   114.114     0.200
     6.043   118.807     0.200
     7.420   150.526     0.200
     7.646   152.385     0.200
     7.646   152.574     0.200
     7.756   154.119     0.200
     7.892   157.169     0.200
     1.637    31.752     0.200
     1.757    34.291     0.200
     1.875    37.479     0.200
     1.917    37.317     0.200
     1.976    40.486     0.200
     2.018    39.206     0.200
     2.035    40.257     0.200
     2.214    42.927     0.200
     2.271    44.491     0.200
     2.268    44.380     0.200
     2.583    49.691     0.200
     2.635    51.307     0.200
     2.695    51.656     0.200
     2.704    51.992     0.200
     2.769    53.799     0.200
     5.195   104.185     0.200
    11.671   232.384     0.200
     1.614    30.469     0.200
     1.641    32.313     0.200
     1.761    34.530     0.200
     1.974    39.706     0.200
     1.920    37.306     0.200
     2.015    38.732     0.200
     2.217    42.734     0.200
     2.217    42.906     0.200
     2.274    43.755     0.200
     2.586    49.528     0.200
     2.692    52.034     0.200
     2.771    53.856     0.200
     2.771    52.442     0.200
     4.811    93.412     0.200
     4.981    97.223     0.200
     6.131   121.004     0.200
     7.342   142.627     0.200
     7.508   148.901     0.200
     1.623    31.653     0.200
     1.662    32.342     0.200
     1.795    35.223     0.200
     1.899    36.666     0.200
     2.084    40.860     0.200
     2.079    40.349     0.200
     2.250    43.242     0.200
     2.295    44.460     0.200
     2.402    45.884     0.200
     2.439    48.137     0.200
     2.530    49.230     0.200
     2.530    49.602     0.200
     2.600    51.699     0.200
     2.936    55.962     0.200
     5.052   101.505     0.200
     8.739   171.778     0.200
    10.887   220.531     0.200
     1.629    32.028     0.200
     1.664    31.411     0.200
     1.800    35.747     0.200
     1.899    36.817     0.200
     2.087    41.070     0.200
     2.085    40.601     0.200
     2.147    41.096     0.200
     2.257    43.653     0.200
     2.295    44.685     0.200
     2.408    45.899     0.200
     2.445    47.868     0.200
     2.532    49.121     0.200
     2.604    51.334     0.200
     2.942    56.127     0.200
     1.756    33.327     0.200
     1.718    33.104     0.200
     1.781    32.669     0.200
     1.812    33.095     0.200
     1.827    33.929     0.200
     1.832    35.708     0.200
     1.860    36.483     0.200
     2.110    40.954     0.200
     2.121    40.047     0.200
     2.160    41.924     0.200
     2.156    42.972     0.200
     2.232    43.043     0.200
     2.349    44.706     0.200
     2.370    43.932     0.200
     2.342    44.420     0.200
     2.372    43.804     0.200
     2.423    46.711     0.200
     3.240    64.792     0.200
     4.226    84.512     0.200
     5.456   108.813     0.200
     5.910   118.909     0.200
     6.025   117.765     0.200
     7.084   143.480     0.200
     7.243   145.363     0.200
     7.358   145.691     0.200
     7.512   151.586     0.200
     7.555   152.106     0.200
     7.643   151.312     0.200
     7.652   151.290     0.200
     7.872   152.235     0.200
     7.935   158.702     0.200
    11.070   220.031     0.200
     1.670    32.042     0.200
     1.739    34.226     0.200
     1.758    32.623     0.200
     1.787    32.914     0.200
     1.853    37.509     0.200
     2.139    42.476     0.200
     2.171    41.614     0.200
     2.186    44.704     0.200
     2.215    43.635     0.200
     2.239    42.678     0.200
     2.343    43.486     0.200
     2.373    44.870     0.200
     2.367    44.089     0.200
     2.360    44.471     0.200
     2.447    47.031     0.200
     4.237    83.494     0.200
     4.290    86.939     0.200
     4.668    94.128     0.200
     4.859    98.703     0.200
     5.528   113.216     0.200
     5.933   120.215     0.200
     5.955   120.447     0.200
     7.096   139.746     0.200
     7.173   143.603     0.200
     7.528   151.216     0.200
     7.571   150.820     0.200
     7.642   150.718     0.200
     1.693    33.787     0.200
     1.873    36.444     0.200
     2.082    40.277     0.200
     2.145    41.198     0.200
     1.623    31.752     0.200
     1.678    30.504     0.200
     1.784    32.596     0.200
     1.861    37.469     0.200
     1.977    37.529     0.200
     1.977    37.164     0.200
     1.997    39.333     0.200
     2.066    38.947     0.200
     2.116    42.495     0.200
     2.912    57.355     0.200
     3.998    78.954     0.200
     4.103    84.756     0.200
     4.501    89.517     0.200
     4.562    93.636     0.200
     4.823    94.668     0.200
     4.932    96.664     0.200
     4.959    97.412     0.200
     5.409   108.083     0.200
     6.454   127.915     0.200
     6.496   130.111     0.200
     7.027   140.596     0.200
     7.122   139.298     0.200
     7.268   142.610     0.200
    12.202   243.567     0.200
     1.646    31.538     0.200
     1.879    36.537     0.200
     1.872    36.891     0.200
     1.881    36.204     0.200
     1.922    37.174     0.200
     2.069    39.917     0.200
     2.287    43.754     0.200
     2.324    45.109     0.200
     2.319    44.416     0.200
     3.184    62.875     0.200
     3.640    71.405     0.200
     4.837    95.786     0.200
     5.117   105.320     0.200
     5.165   102.132     0.200
     5.345   105.786     0.200
     5.380   105.597     0.200
     6.004   117.423     0.200
     6.039   117.785     0.200
     7.787   152.845     0.200
     8.159   158.700     0.200
     1.652    31.748     0.200
     1.773    32.965     0.200
     1.883    36.706     0.200
     1.878    35.772     0.200
     1.928    35.157     0.200
    11.465   227.122     0.200
     1.671    30.923     0.200
     1.811    35.200     0.200
     1.930    37.416     0.200
     1.977    38.402     0.200
     2.026    39.354     0.200
     2.100    39.636     0.200
     2.270    44.115     0.200
     2.270    44.358     0.200
     2.328    45.560     0.200
     2.642    50.486     0.200
     2.829    54.799     0.200
     2.829    55.010     0.200
     3.271    66.002     0.200
     3.362    66.627     0.200
     4.674    94.863     0.200
     4.990    97.283     0.200
     5.252   105.931     0.200
     5.656   110.254     0.200
     6.133   120.661     0.200
     7.053   139.604     0.200
     7.234   141.940     0.200
     7.397   145.929     0.200
     7.875   156.845     0.200
     7.939   154.111     0.200
     7.988   160.200     0.200
     8.398   164.917     0.200
     8.398   166.358     0.200
     8.854   178.605     0.200
     9.392   185.214     0.200
     9.558   185.645     0.200
    10.801   218.029     0.200
     1.775    32.441     0.200
     1.913    37.767     0.200
     2.056    40.364     0.200
     2.199    43.132     0.200
     2.274    44.811     0.200
     2.768    54.676     0.200
     2.768    53.622     0.200
     5.207   104.956     0.200
     7.378   147.020     0.200
    10.808   221.735     0.200
    11.695   230.395     0.200
    14.835   298.697     0.200
     1.661    31.901     0.200
     1.866    35.782     0.200
     1.919    36.051     0.200
     1.968    38.457     0.200
     1.998    38.828     0.200
     2.085    38.670     0.200
     2.159    40.219     0.200
     2.232    42.303     0.200
     2.386    45.994     0.200
     7.592   145.986     0.200
     7.681   151.834     0.200
     8.113   158.803     0.200
     1.699    34.088     0.200
     1.937    38.157     0.200
     1.912    38.969     0.200
     1.986    38.581     0.200
     2.235    44.773     0.200
     2.272    44.653     0.200
     2.361    46.763     0.200
     2.497    50.321     0.200
     2.650    52.175     0.200
     2.723    52.426     0.200
     2.788    55.455     0.200
     4.349    85.377     0.200
     4.445    87.397     0.200
     4.407    86.353     0.200
     5.651   111.568     0.200
     6.461   124.450     0.200
     6.698   133.919     0.200
     6.841   134.143     0.200
     7.398   147.127     0.200
     7.418   150.820     0.200
     7.426   148.151     0.200
     1.624    30.996     0.200
     1.731    33.135     0.200
     2.607    49.760     0.200
     2.728    52.430     0.200
     5.820   117.922     0.200
     7.694   151.939     0.200
     7.800   152.683     0.200
    10.803   220.359     0.200
    10.838   215.190     0.200
     1.878    36.561     0.200
     1.897    37.885     0.200
     2.118    40.435     0.200
     2.170    41.687     0.200
     2.231    43.741     0.200
     2.315    44.503     0.200
     2.402    46.317     0.200
     3.897    76.548     0.200
     4.851    95.560     0.200
     5.241   100.642     0.200
     5.383   103.500     0.200
     7.844   157.571     0.200
     1.662    32.249     0.200
     1.853    35.802     0.200
     1.805    35.244     0.200
     1.869    35.939     0.200
     1.894    36.267     0.200
     1.945    36.221     0.200
     2.093    40.191     0.200
     2.332    44.851     0.200
     3.931    77.188     0.200
     5.505   109.578     0.200
     5.864   115.259     0.200
     1.801    34.354     0.200
     1.884    34.944     0.200
     1.885    35.716     0.200
     1.848    36.175     0.200
     2.450    46.312     0.200
     5.755   118.118     0.200
     1.621    30.762     0.200
     1.621    31.871     0.200
     1.622    31.882     0.200
     1.731    33.818     0.200
     1.714    32.374     0.200
     1.785    34.368     0.200
     1.832    35.734     0.200
     1.850    35.805     0.200
     1.850    35.953     0.200
     1.936    37.007     0.200
     1.938    36.873     0.200
     1.935    37.436     0.200
     2.041    39.981     0.200
     2.181    41.540     0.200
     3.612    69.021     0.200
     4.884    96.488     0.200
     8.091   158.473     0.200
     1.620    31.991     0.200
     1.620    32.681     0.200
     1.623    33.079     0.200
     1.641    33.737     0.200
     1.713    33.021     0.200
     1.713    33.690     0.200
     1.739    34.107     0.200
     1.781    34.953     0.200
     1.836    35.791     0.200
     1.850    36.069     0.200
     1.850    35.773     0.200
     1.924    37.045     0.200
     1.930    37.238     0.200
     1.931    36.959     0.200
     1.935    38.327     0.200
     2.173    41.109     0.200
     2.258    43.422     0.200
     2.428    46.402     0.200
     5.639   116.338     0.200
     7.475   152.592     0.200
     7.496   150.116     0.200
     1.626    32.767     0.200
     1.664    32.202     0.200
     1.640    32.535     0.200
     1.680    32.883     0.200
     1.703    33.298     0.200
     1.851    36.502     0.200
     2.036    39.851     0.200
     2.036    40.140     0.200
     2.061    41.661     0.200
     2.076    40.408     0.200
     4.822    95.395     0.200
     5.708   111.120     0.200
     1.748    33.312     0.200
     1.903    40.054     0.200
     2.186    42.926     0.200
     2.405    46.253     0.200
     2.602    50.421     0.200
     2.728    52.372     0.200
     5.827   117.500     0.200
     1.741    33.377     0.200
     2.325    45.273     0.200
     2.384    46.309     0.200
     2.418    46.305     0.200
     2.560    49.675     0.200
     2.614    50.225     0.200
     2.738    53.151     0.200
     7.803   154.366     0.200
     1.738    33.453     0.200
     2.417    45.787     0.200
     2.734    52.613     0.200
     7.802   153.503     0.200
    10.375   206.590     0.200
     2.414    47.708     0.200
     2.502    48.881     0.200
     2.609    51.330     0.200
     2.733    53.130     0.200
     7.806   154.269     0.200
    10.839   215.131     0.200
     1.755    33.882     0.200
     1.768    35.224     0.200
     2.381    45.922     0.200
     2.594    51.037     0.200
     2.733    52.337     0.200
     3.018    57.463     0.200
     7.857   154.944     0.200
    10.865   212.617     0.200
     1.628    31.044     0.200
     1.739    32.464     0.200
     7.512   154.879     0.200
     7.805   153.253     0.200
    10.839   214.320     0.200
     2.118    41.393     0.200
     2.179    41.946     0.200
     2.386    45.713     0.200
     2.394    46.973     0.200
     2.464    47.380     0.200
     2.611    50.745     0.200
     2.728    52.482     0.200
     3.337    62.395     0.200
     7.787   154.717     0.200
     8.070   163.481     0.200
     1.800    33.398     0.200
     2.397    45.862     0.200
     3.679    75.608     0.200
     7.849   155.813     0.200
     8.108   166.305     0.200
    10.850   212.543     0.200
     1.743    35.234     0.200
     2.390    46.830     0.200
     2.410    47.573     0.200
     2.737    52.954     0.200
     3.005    58.263     0.200
     7.789   154.255     0.200
     2.131    40.933     0.200
     2.623    50.810     0.200
     2.742    53.344     0.200
     3.645    72.200     0.200
     5.828   114.793     0.200
     7.472   147.884     0.200
     7.783   153.519     0.200
     1.760    33.562     0.200
     2.403    45.353     0.200
     2.572    47.652     0.200
     7.823   154.651     0.200
     1.761    34.022     0.200
     2.362    45.149     0.200
     2.724    52.594     0.200
     7.828   151.466     0.200
     8.211   162.566     0.200
    10.856   215.004     0.200
    10.830   220.181     0.200
     1.650    31.542     0.200
     1.845    35.539     0.200
     1.934    37.515     0.200
     2.098    38.353     0.200
     2.082    40.122     0.200
     2.246    42.693     0.200
     2.312    44.434     0.200
     2.320    44.040     0.200
     2.433    46.902     0.200
     2.555    49.042     0.200
     2.700    51.534     0.200
     1.968    38.698     0.200
     2.016    40.730     0.200
     2.070    39.420     0.200
     2.313    44.250     0.200
     2.366    45.610     0.200
     2.482    48.892     0.200
     2.553    48.827     0.200
     2.665    53.324     0.200
     4.655    91.770     0.200
     4.896    98.103     0.200
     6.868   135.417     0.200
     7.959   155.913     0.200
     1.706    33.661     0.200
     1.849    35.941     0.200
     1.858    34.029     0.200
     1.941    37.090     0.200
     1.973    38.758     0.200
     2.057    40.579     0.200
     2.228    42.330     0.200
     2.344    44.942     0.200
     2.372    45.481     0.200
     2.447    47.336     0.200
     3.233    61.175     0.200
     5.671   113.613     0.200
     5.858   117.188     0.200
     7.282   142.984     0.200
     1.731    33.883     0.200
     1.875    36.719     0.200
     1.982    38.703     0.200
     1.981    39.153     0.200
     2.184    42.679     0.200
     2.399    47.320     0.200
     2.588    49.412     0.200
     2.589    49.077     0.200
     2.546    48.776     0.200
     5.141   104.679     0.200
     5.141   104.679     0.200
     1.622    30.764     0.200
     2.371    44.930     0.200
     2.507    48.782     0.200
     2.593    50.476     0.200
     1.676    31.135     0.200
     1.749    34.537     0.200
     5.540   112.050     0.200
     7.458   148.298     0.200
     7.876   152.167     0.200
     2.548    50.029     0.200
     5.611   111.420     0.200
     1.630    32.036     0.200
     1.851    35.575     0.200
     1.974    38.849     0.200
     2.023    39.158     0.200
     2.038    39.411     0.200
     2.099    40.064     0.200
     2.430    46.435     0.200
     2.686    51.001     0.200
     1.653    31.360     0.200
     1.849    36.342     0.200
     2.017    39.405     0.200
     2.182    42.232     0.200
     2.213    43.540     0.200
     2.224    43.491     0.200
     1.654    32.388     0.200
     7.545   147.402     0.200
     7.798   152.495     0.200
     1.611    29.886     0.200
     1.878    36.836     0.200
     1.937    38.103     0.200
     1.973    39.382     0.200
     2.057    39.999     0.200
     2.435    47.643     0.200
     2.600    50.607     0.200
     2.649    51.145     0.200
     4.849    96.967     0.200
     6.829   135.132     0.200
     7.974   155.291     0.200
     1.883    37.132     0.200
     1.938    38.592     0.200
     1.985    39.620     0.200
     2.065    41.031     0.200
     2.445    48.124     0.200
     2.630    52.270     0.200
     2.656    52.410     0.200
     4.860    95.898     0.200
     6.842   134.881     0.200
     6.984   140.220     0.200
     7.978   155.865     0.200
     1.696    32.915     0.200
     1.696    32.355     0.200
     2.325    44.151     0.200
     2.589    49.389     0.200
     5.677   114.358     0.200
     7.572   150.078     0.200
     7.836   155.224     0.200
     1.658    33.273     0.200
     2.211    43.078     0.200
     2.159    42.667     0.200
     5.083   102.700     0.200
     6.961   138.361     0.200
     7.757   150.002     0.200
     1.671    32.955     0.200
     4.596    93.778     0.200
     6.894   135.364     0.200
     8.679   167.701     0.200
    12.180   243.721     0.200
     1.645    31.094     0.200
     1.764    33.110     0.200
     2.033    40.701     0.200
     2.102    41.284     0.200
     9.647   192.057     0.200
    10.751   213.528     0.200
    10.769   216.532     0.200
    11.664   230.639     0.200
    14.814   295.790     0.200
    26.938   532.031     0.200
     1.788    34.006     0.200
     2.411    44.900     0.200
     2.624    49.809     0.200
     2.760    52.833     0.200
     5.873   116.512     0.200
     1.804    34.469     0.200
     2.193    42.239     0.200
     2.450    45.783     0.200
     2.674    50.703     0.200
     5.928   118.858     0.200
     7.804   153.190     0.200
     7.818   150.340     0.200
    10.793   213.102     0.200
     1.617    32.424     0.200
     1.910    36.429     0.200
     2.242    43.416     0.200
     2.262    43.667     0.200
     2.499    48.229     0.200
     2.664    51.691     0.200
     2.973    57.721     0.200
     7.988   155.524     0.200
     1.725    31.515     0.200
     1.881    37.980     0.200
     2.127    42.719     0.200
     2.176    41.613     0.200
     2.176    42.965     0.200
     2.245    42.742     0.200
     2.361    45.452     0.200
     2.444    46.986     0.200
     5.518   109.315     0.200
     7.432   146.629     0.200
     7.864   152.091     0.200
    10.064   197.697     0.200
    10.620   214.984     0.200
    11.053   216.563     0.200
     2.449    47.470     0.200
     1.886    39.096     0.200
     5.520   108.729     0.200
     7.428   148.726     0.200
     7.849   151.899     0.200
    11.040   221.380     0.200
     1.852    35.825     0.200
     2.174    41.834     0.200
     2.243    42.839     0.200
     2.361    45.288     0.200
     2.378    44.404     0.200
     2.446    46.791     0.200
     5.524   110.774     0.200
     7.869   152.603     0.200
     1.731    33.281     0.200
     1.852    36.155     0.200
     2.174    41.327     0.200
     2.243    42.436     0.200
     2.446    46.625     0.200
     5.523   113.666     0.200
     7.438   144.505     0.200
     7.868   150.892     0.200
     1.638    31.554     0.200
     2.378    45.775     0.200
     7.775   155.193     0.200
     2.433    46.049     0.200
     5.875   121.450     0.200
     7.750   156.011     0.200
     7.809   150.999     0.200
    10.815   213.493     0.200
     1.706    34.329     0.200
     1.796    35.993     0.200
     2.152    42.386     0.200
     2.401    46.816     0.200
     2.430    46.997     0.200
     2.539    48.663     0.200
     2.638    50.176     0.200
     2.770    53.585     0.200
     7.748   151.247     0.200
     7.810   150.311     0.200
    10.817   214.279     0.200
    10.851   217.506     0.200
     1.668    32.653     0.200
     1.908    36.430     0.200
     1.928    37.416     0.200
     2.153    41.290     0.200
     2.145    42.721     0.200
     2.295    44.291     0.200
     5.488   109.596     0.200
     1.618    32.147     0.200
     1.707    33.231     0.200
     2.696    50.647     0.200
     5.674   114.185     0.200
     7.575   150.806     0.200
     1.611    31.434     0.200
     1.635    29.672     0.200
     1.762    34.497     0.200
     1.766    34.858     0.200
     1.890    36.763     0.200
     2.128    40.766     0.200
     2.156    42.640     0.200
     2.233    43.777     0.200
     2.263    43.997     0.200
     2.320    44.782     0.200
     2.362    45.126     0.200
     2.520    48.331     0.200
     2.978    56.255     0.200
     2.992    56.720     0.200
     5.465   108.806     0.200
     7.639   150.105     0.200
     8.511   164.878     0.200
     9.884   197.568     0.200
     1.693    33.215     0.200
     1.819    36.081     0.200
     1.849    36.287     0.200
     1.997    39.214     0.200
     2.021    39.130     0.200
     2.132    41.170     0.200
     2.148    41.624     0.200
     2.203    43.156     0.200
     2.407    47.292     0.200
     2.515    48.399     0.200
     2.680    52.075     0.200
     2.700    52.759     0.200
     1.646    32.037     0.200
     1.652    30.801     0.200
     1.680    32.945     0.200
     1.700    33.212     0.200
     1.818    33.775     0.200
     1.852    36.592     0.200
     1.916    38.007     0.200
     1.976    39.807     0.200
     2.104    40.874     0.200
     2.338    46.266     0.200
     2.393    47.039     0.200
     2.580    50.993     0.200
     4.777    95.414     0.200
     6.868   132.988     0.200
     8.217   158.796     0.200
     1.697    32.682     0.200
     1.770    33.658     0.200
     1.900    36.140     0.200
     1.958    38.005     0.200
     1.953    38.565     0.200
     2.014    39.220     0.200
     2.047    39.779     0.200
     2.065    41.004     0.200
     7.390   145.936     0.200
     8.303   162.976     0.200
     9.756   193.436     0.200
     1.862    36.149     0.200
     1.939    37.002     0.200
     2.017    39.491     0.200
     2.083    40.179     0.200
     2.333    44.516     0.200
     2.499    48.092     0.200
     2.796    54.186     0.200
     5.696   113.014     0.200
     7.691   150.507     0.200
     1.643    32.288     0.200
     1.653    31.734     0.200
     1.678    32.888     0.200
     1.699    33.246     0.200
     1.820    34.749     0.200
     1.850    35.876     0.200
     1.912    37.910     0.200
     1.971    39.259     0.200
     2.333    46.076     0.200
     2.391    46.823     0.200
     4.772    93.366     0.200
     8.216   158.942     0.200
     1.651    32.612     0.200
     1.716    32.229     0.200
     2.011    39.248     0.200
     2.290    43.963     0.200
     2.313    45.270     0.200
     2.336    44.760     0.200
     2.506    48.362     0.200
     2.619    50.757     0.200
     2.664    50.402     0.200
     5.713   115.822     0.200
     7.608   149.320     0.200
     7.839   155.618     0.200
    10.928   216.314     0.200
     1.630    32.582     0.200
     1.731    33.119     0.200
     1.825    35.098     0.200
     1.941    37.515     0.200
     2.097    39.525     0.200
     2.464    49.679     0.200
     2.988    60.341     0.200
     3.133    61.810     0.200
     3.501    67.355     0.200
     3.543    70.324     0.200
     3.752    75.118     0.200
     5.089   101.689     0.200
     7.369   145.341     0.200
     9.470   186.807     0.200
    11.978   236.061     0.200
     5.714   112.414     0.200
     7.731   152.127     0.200
    11.174   222.649     0.200
     1.848    36.466     0.200
     7.807   152.203     0.200
     7.835   157.055     0.200
    10.763   215.756     0.200
     4.787    93.455     0.200
     6.770   130.578     0.200
     7.979   154.835     0.200
     9.346   182.911     0.200
    14.280   282.052     0.200
     7.906   155.734     0.200
    11.125   222.098     0.200
     5.445   109.890     0.200
     7.377   145.545     0.200
     7.900   153.580     0.200
     4.988   101.966     0.200
     7.268   141.089     0.200
     8.697   169.277     0.200
     8.453   166.368     0.200
     7.547   148.439     0.200
     7.812   152.492     0.200
    10.936   216.916     0.200
     8.167   158.100     0.200
    11.197   219.774     0.200
     7.488   148.364     0.200
     7.862   152.399     0.200
    11.019   215.984     0.200
     5.580   112.424     0.200
     5.556   110.695     0.200
     7.462   148.712     0.200
     1.646    31.474     0.200
     4.725    93.557     0.200
     5.801   117.389     0.200
     7.688   152.318     0.200
     7.829   153.287     0.200
    10.872   217.686     0.200
     7.676   151.863     0.200
     7.825   154.343     0.200
    10.802   217.998     0.200
    10.872   218.628     0.200
     5.791   114.823     0.200
     7.679   148.913     0.200
     7.831   153.508     0.200
    10.334   206.091     0.200
    10.804   216.134     0.200
    22.525   450.293     0.200
     5.781   114.694     0.200
     7.671   150.986     0.200
    10.798   216.739     0.200
    10.885   216.451     0.200
     5.802   117.295     0.200
    10.870   217.495     0.200
    15.245   306.297     0.200
     7.669   153.984     0.200
     7.827   155.208     0.200
    10.881   215.302     0.200
     7.668   151.660     0.200
     7.813   153.692     0.200
     5.787   116.001     0.200
     7.669   148.883     0.200
     7.813   149.911     0.200
    10.788   218.873     0.200
     7.672   148.082     0.200
     7.815   152.812     0.200
    10.792   214.994     0.200
    10.867   213.653     0.200
     5.821   113.771     0.200
     7.709   151.648     0.200
     7.833   153.261     0.200
    10.864   216.438     0.200
     5.662   113.965     0.200
     7.534   147.045     0.200
     7.778   152.275     0.200
     5.675   111.768     0.200
     7.558   148.723     0.200
     7.806   152.595     0.200
    10.923   214.222     0.200
     5.119   103.980     0.200
     7.439   146.356     0.200
     8.828   173.672     0.200
     9.471   186.535     0.200
     7.796   152.674     0.200
     5.671   114.698     0.200
     7.552   150.866     0.200
     7.799   154.382     0.200
     7.840   156.164     0.200
     5.698   111.691     0.200
     7.586   146.919     0.200
     7.820   154.282     0.200
    10.245   202.920     0.200
    10.726   214.749     0.200
    10.921   218.359     0.200
    15.140   302.634     0.200
    22.456   446.159     0.200
    29.368   587.270     0.200
     1.689    32.529     0.200
     5.695   116.026     0.200
     7.819   155.117     0.200
    10.922   218.014     0.200
     5.696   114.857     0.200
     7.585   150.706     0.200
     7.823   153.377     0.200
     7.832   151.046     0.200
    10.954   217.811     0.200
     5.677   113.371     0.200
     7.571   151.000     0.200
     7.832   152.190     0.200
    10.942   214.153     0.200
     5.634   112.289     0.200
     5.632   110.569     0.200
     7.528   147.428     0.200
     7.831   154.096     0.200
    10.683   217.599     0.200
    10.966   218.655     0.200
     5.633   112.182     0.200
     7.532   150.380     0.200
    10.689   218.676     0.200
    10.972   219.385     0.200
     7.533   149.550     0.200
    10.691   217.897     0.200
     5.670   112.655     0.200
     7.674   152.744     0.200
     5.703   112.157     0.200
     7.600   150.989     0.200
     7.843   155.800     0.200
    10.936   218.521     0.200
     7.311   142.858     0.200
     8.402   163.824     0.200
    10.734   214.498     0.200
     5.200   101.446     0.200
     7.510   146.320     0.200
     8.819   173.039     0.200
     9.551   187.802     0.200
    10.769   214.400     0.200
     1.714    34.754     0.200
     5.243   104.826     0.200
    11.617   230.386     0.200
     1.653    30.439     0.200
     1.679    30.774     0.200
     1.717    32.870     0.200
     1.858    36.440     0.200
     5.152   103.997     0.200
     7.462   145.410     0.200
     8.809   174.063     0.200
     1.695    31.567     0.200
     5.659   114.440     0.200
     7.534   149.717     0.200
     7.782   151.492     0.200
    10.215   202.441     0.200
    10.668   216.368     0.200
    10.912   218.040     0.200
     5.654   113.397     0.200
     7.528   148.628     0.200
     7.781   151.975     0.200
    10.663   216.119     0.200
    10.914   215.461     0.200
     5.679   116.153     0.200
     7.550   149.863     0.200
     7.777   154.415     0.200
    10.898   218.575     0.200
     5.714   112.514     0.200
     7.608   148.947     0.200
     7.835   153.771     0.200
    10.748   216.036     0.200
    10.924   215.984     0.200
     7.793   154.223     0.200
     7.817   154.462     0.200
    10.798   214.152     0.200
     5.915   119.329     0.200
    10.797   212.631     0.200
     7.822   150.074     0.200
    10.801   215.973     0.200
    10.894   220.585     0.200
    10.800   214.398     0.200
     7.817   150.328     0.200
     1.703    33.873     0.200
     7.813   152.078     0.200
    10.794   216.607     0.200
     2.149    40.066     0.200
     5.703   112.332     0.200
     7.724   150.378     0.200
     8.153   157.531     0.200
    11.186   221.017     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.285     6.956     0.200
     0.343     7.934     0.200
     0.517    11.077     0.200
     0.806    15.660     0.200
     0.218     5.377     0.200
     0.331     7.751     0.200
     0.711    15.025     0.200
     0.866    17.574     0.200
     0.982    18.860     0.200
     1.591    31.396     0.200
     1.577    30.977     0.200
     0.277     6.128     0.200
     0.374     8.645     0.200
     0.454     9.957     0.200
     0.509    10.976     0.200
     0.598    12.654     0.200
     0.743    15.520     0.200
     0.670    13.156     0.200
     1.039    19.742     0.200
     1.374    24.549     0.200
     1.521    29.862     0.200
     1.992    35.201     0.200
     2.091    36.683     0.200
     0.167     4.178     0.200
     0.551    11.315     0.200
     0.635    13.349     0.200
     0.674    13.930     0.200
     0.743    15.282     0.200
     0.783    15.496     0.200
     0.775    15.602     0.200
     0.838    17.076     0.200
     1.422    24.689     0.200
     1.422    25.101     0.200
     1.542    30.485     0.200
     1.811    32.332     0.200
     0.167     4.358     0.200
     0.167     4.218     0.200
     0.551    11.718     0.200
     0.673    13.939     0.200
     0.740    15.533     0.200
     0.639    13.747     0.200
     0.783    15.536     0.200
     0.837    17.257     0.200
     0.778    15.557     0.200
     1.418    24.973     0.200
     1.418    25.122     0.200
     1.545    29.996     0.200
     1.974    35.628     0.200
     0.292     6.742     0.200
     0.356     7.565     0.200
     0.356     7.904     0.200
     0.645    13.046     0.200
     0.714    14.438     0.200
     0.837    16.504     0.200
     0.759    16.086     0.200
     1.503    27.409     0.200
     1.574    30.811     0.200
     1.929    33.490     0.200
     2.545    41.883     0.200
     6.908   118.798     0.200
     0.289     7.047     0.200
     0.362     7.570     0.200
     0.639    13.194     0.200
     0.712    14.422     0.200
     0.763    15.834     0.200
     0.833    16.240     0.200
     1.580    30.960     0.200
     0.382     8.221     0.200
     0.411     9.516     0.200
     0.658    14.060     0.200
     0.711    14.698     0.200
     0.727    14.982     0.200
     0.704    15.435     0.200
     0.772    15.712     0.200
     1.576    31.342     0.200
     1.941    34.829     0.200
     2.197    38.026     0.200
     4.302    68.679     0.200
     0.432     9.773     0.200
     0.703    14.836     0.200
     0.698    15.073     0.200
     0.677    14.263     0.200
     0.677    15.017     0.200
     0.747    15.890     0.200
     0.806    17.293     0.200
     0.806    16.117     0.200
     0.734    15.732     0.200
     1.371    23.397     0.200
     0.369     7.494     0.200
     0.613    12.805     0.200
     0.648    13.242     0.200
     0.661    13.685     0.200
     0.707    14.503     0.200
     0.707    14.890     0.200
     0.726    15.097     0.200
     0.841    16.773     0.200
     0.921    18.235     0.200
     1.586    30.924     0.200
     1.788    32.530     0.200
     0.291     6.913     0.200
     0.433     9.611     0.200
     0.666    14.472     0.200
     0.114     3.815     0.200
     0.475     9.626     0.200
     0.408     9.079     0.200
     0.419     9.496     0.200
     0.458    10.631     0.200
     0.487    10.580     0.200
     0.503    10.912     0.200
     0.621    12.575     0.200
     0.726    15.262     0.200
     1.542    29.771     0.200
     4.754    79.159     0.200
     0.111     3.710     0.200
     0.406     9.156     0.200
     0.452     9.668     0.200
     0.421     9.137     0.200
     0.472     9.471     0.200
     0.490    10.513     0.200
     0.544    11.142     0.200
     0.627    12.120     0.200
     0.636    13.083     0.200
     0.636    13.114     0.200
     1.008    18.802     0.200
     1.544    29.781     0.200
     0.219     5.389     0.200
     0.685    14.004     0.200
     0.682    14.469     0.200
     0.698    14.668     0.200
     0.744    14.483     0.200
     0.766    15.148     0.200
     0.780    15.766     0.200
     1.098    20.459     0.200
     1.522    30.037     0.200
     1.553    31.521     0.200
     1.833    32.772     0.200
     3.271    53.502     0.200
     0.167     4.564     0.200
     0.192     4.882     0.200
     0.532    11.155     0.200
     0.611    13.406     0.200
     0.755    15.247     0.200
     0.753    14.960     0.200
     0.780    15.915     0.200
     0.831    16.754     0.200
     0.890    17.510     0.200
     0.901    17.882     0.200
     5.207    83.855     0.200
     5.207    83.855     0.200
     0.272     6.230     0.200
     0.449     9.383     0.200
     0.460    10.621     0.200
     0.507    10.994     0.200
     0.563    12.213     0.200
     0.563    13.487     0.200
     0.593    12.265     0.200
     0.669    14.073     0.200
     0.745    14.665     0.200
     0.903    17.505     0.200
     0.944    18.234     0.200
     0.971    18.800     0.200
     0.987    18.995     0.200
     0.987    18.527     0.200
     1.545    30.041     0.200
     3.228    54.733     0.200
     3.374    56.998     0.200
     3.783    64.107     0.200
     0.372     8.631     0.200
     0.376     8.189     0.200
     0.480    11.165     0.200
     0.735    15.176     0.200
     0.890    18.638     0.200
     1.250    22.668     0.200
     1.589    32.266     0.200
     2.361    41.271     0.200
     3.049    55.576     0.200
     0.219     4.963     0.200
     0.583    12.349     0.200
     0.583    12.537     0.200
     0.620    12.509     0.200
     0.620    13.094     0.200
     0.659    13.104     0.200
     0.704    15.554     0.200
     0.735    15.295     0.200
     0.319     7.631     0.200
     0.330     6.954     0.200
     0.554    12.041     0.200
     0.755    14.993     0.200
     0.850    16.145     0.200
     1.354    25.277     0.200
     1.357    26.646     0.200
     1.448    27.895     0.200
     1.475    28.544     0.200
     1.510    29.268     0.200
     0.148     4.451     0.200
     0.437     9.060     0.200
     0.451     9.743     0.200
     0.446     9.823     0.200
     0.613    12.257     0.200
     0.676    14.228     0.200
     0.754    15.997     0.200
     1.250    22.018     0.200
     1.877    33.995     0.200
     0.212     5.665     0.200
     0.551    11.410     0.200
     0.551    11.605     0.200
     0.556    12.002     0.200
     0.554    12.460     0.200
     0.617    12.112     0.200
     0.737    15.207     0.200
     0.723    15.159     0.200
     1.073    20.326     0.200
     1.517    28.534     0.200
     0.196     4.746     0.200
     0.350     7.483     0.200
     0.619    13.259     0.200
     0.788    18.401     0.200
     0.753    15.880     0.200
     0.821    17.624     0.200
     0.893    18.533     0.200
     0.956    18.996     0.200
     0.902    17.983     0.200
     0.986    19.783     0.200
     1.022    20.549     0.200
     1.203    22.658     0.200
     1.588    31.760     0.200
     0.208     4.891     0.200
     0.338     8.008     0.200
     0.618    13.821     0.200
     0.686    15.044     0.200
     0.761    16.646     0.200
     0.777    18.774     0.200
     0.822    17.948     0.200
     0.895    18.514     0.200
     0.901    18.845     0.200
     0.901    19.008     0.200
     0.944    19.348     0.200
     0.973    20.449     0.200
     0.995    20.324     0.200
     1.020    20.833     0.200
     1.053    21.877     0.200
     1.165    23.362     0.200
     1.190    23.054     0.200
     1.366    26.436     0.200
     2.260    40.019     0.200
     2.273    41.131     0.200
     5.408    87.914     0.200
     5.610   100.394     0.200
     0.294     6.333     0.200
     0.543    11.782     0.200
     0.636    13.356     0.200
     0.673    14.209     0.200
     0.714    15.033     0.200
     0.721    14.842     0.200
     0.721    14.748     0.200
     0.721    14.877     0.200
     0.711    15.031     0.200
     0.763    15.365     0.200
     0.870    17.519     0.200
     1.594    31.059     0.200
     1.590    30.850     0.200
     1.590    31.822     0.200
     2.902    53.034     0.200
     0.202     5.094     0.200
     0.202     5.368     0.200
     0.249     7.519     0.200
     0.584    12.297     0.200
     0.584    12.195     0.200
     0.634    13.331     0.200
     0.633    13.359     0.200
     0.633    12.109     0.200
     0.652    12.402     0.200
     0.721    15.169     0.200
     1.097    20.330     0.200
     1.979    34.253     0.200
     0.213     5.097     0.200
     0.242     7.729     0.200
     0.592    12.424     0.200
     0.634    13.870     0.200
     0.621    12.859     0.200
     0.646    13.260     0.200
     0.733    15.338     0.200
     1.535    29.205     0.200
     0.215     5.025     0.200
     0.215     5.697     0.200
     0.247     7.880     0.200
     0.595    12.533     0.200
     0.608    12.954     0.200
     0.621    12.584     0.200
     0.629    13.603     0.200
     0.650    12.981     0.200
     0.733    15.621     0.200
     0.591    12.696     0.200
     0.729    15.643     0.200
     1.980    35.950     0.200
     1.981    35.410     0.200
     8.006   133.278     0.200
     0.233     7.273     0.200
     0.579    12.222     0.200
     0.591    12.778     0.200
     0.636    14.183     0.200
     0.628    12.625     0.200
     0.724    14.917     0.200
     1.094    20.517     0.200
     1.539    29.137     0.200
     2.336    40.265     0.200
     2.508    42.784     0.200
     0.158     4.663     0.200
     0.231     7.567     0.200
     0.215     7.098     0.200
     0.246     7.378     0.200
     0.533    11.590     0.200
     0.626    12.468     0.200
     0.668    13.384     0.200
     0.681    14.569     0.200
     0.683    14.729     0.200
     1.585    30.436     0.200
     0.212     5.489     0.200
     0.212     5.294     0.200
     0.594    12.128     0.200
     0.624    13.117     0.200
     0.628    14.084     0.200
     0.653    12.904     0.200
     0.698    13.799     0.200
     0.731    15.717     0.200
     1.299    23.365     0.200
     2.490    44.790     0.200
     2.484    44.913     0.200
     3.325    53.613     0.200
     0.233     4.760     0.200
     0.610    11.685     0.200
     0.608    13.205     0.200
     0.616    13.141     0.200
     0.616    12.695     0.200
     0.629    13.789     0.200
     0.666    13.485     0.200
     0.709    14.524     0.200
     0.748    15.987     0.200
     2.306    40.238     0.200
     2.467    42.176     0.200
     6.857   110.142     0.200
     0.168     4.774     0.200
     0.536    11.686     0.200
     0.611    12.683     0.200
     0.657    13.055     0.200
     0.657    12.516     0.200
     0.694    14.381     0.200
     2.375    42.775     0.200
     2.463    43.980     0.200
     2.554    45.943     0.200
     3.540    60.458     0.200
     3.756    60.722     0.200
     0.228     6.142     0.200
     0.228     4.954     0.200
     0.250     7.799     0.200
     0.609    13.091     0.200
     0.621    14.076     0.200
     0.655    12.922     0.200
     0.610    13.026     0.200
     0.610    12.300     0.200
     0.619    13.382     0.200
     0.746    15.750     0.200
     1.989    34.861     0.200
     0.247     7.700     0.200
     0.613    12.957     0.200
     0.613    12.029     0.200
     0.620    13.548     0.200
     0.625    13.523     0.200
     0.603    11.626     0.200
     0.651    12.878     0.200
     0.752    15.425     0.200
     0.694    14.540     0.200
     1.520    27.623     0.200
     0.194     5.519     0.200
     0.285     7.855     0.200
     0.573    12.566     0.200
     0.573    12.050     0.200
     0.586    12.889     0.200
     0.643    12.508     0.200
     0.638    13.374     0.200
     0.646    13.941     0.200
     0.714    14.963     0.200
     1.968    33.675     0.200
     0.189     5.040     0.200
     0.571    12.391     0.200
     0.571    12.160     0.200
     0.584    12.773     0.200
     0.645    11.899     0.200
     0.645    12.537     0.200
     0.650    13.147     0.200
     0.642    14.038     0.200
     0.708    15.364     0.200
     1.558    28.933     0.200
     1.973    35.835     0.200
     2.511    41.774     0.200
     0.153     4.657     0.200
     0.153     4.435     0.200
     0.409     8.527     0.200
     0.444     9.065     0.200
     0.449     9.579     0.200
     0.459     9.572     0.200
     0.529    10.869     0.200
     0.602    12.011     0.200
     0.594    12.065     0.200
     0.656    13.028     0.200
     0.672    13.439     0.200
     0.761    15.378     0.200
     0.761    15.038     0.200
     1.501    28.817     0.200
     1.790    31.665     0.200
     1.796    31.519     0.200
     1.871    32.882     0.200
     2.099    37.387     0.200
     0.469    10.212     0.200
     0.471    10.149     0.200
     0.515    11.226     0.200
     0.761    15.982     0.200
     0.847    18.252     0.200
     1.035    21.009     0.200
     1.056    21.189     0.200
     1.291    24.811     0.200
     0.178     4.755     0.200
     0.178     5.091     0.200
     0.384     7.742     0.200
     0.384     8.172     0.200
     0.366     8.075     0.200
     0.420    11.068     0.200
     0.475     9.977     0.200
     0.475    10.430     0.200
     0.635    12.652     0.200
     0.637    12.889     0.200
     0.725    14.690     0.200
     0.725    15.002     0.200
     0.766    15.917     0.200
     0.766    17.292     0.200
     0.936    17.868     0.200
     1.198    22.094     0.200
     1.929    34.654     0.200
     1.994    36.318     0.200
     2.142    38.335     0.200
     2.757    45.931     0.200
     5.267    89.874     0.200
     0.091     3.066     0.200
     0.091     3.473     0.200
     0.096     3.584     0.200
     0.612    12.935     0.200
     0.623    12.710     0.200
     0.799    15.605     0.200
     0.822    15.563     0.200
     0.851    16.188     0.200
     1.469    26.361     0.200
     1.432    28.045     0.200
     1.571    29.827     0.200
     1.821    31.821     0.200
     0.111     3.457     0.200
     0.607    12.298     0.200
     0.623    13.506     0.200
     0.630    12.920     0.200
     0.782    16.005     0.200
     0.815    16.221     0.200
     1.439    25.125     0.200
     1.634    28.632     0.200
     1.825    32.767     0.200
     0.323     7.098     0.200
     0.451     9.503     0.200
     0.663    12.485     0.200
     0.714    14.608     0.200
     0.769    16.295     0.200
     0.442     9.512     0.200
     0.703    14.534     0.200
     0.692    15.924     0.200
     0.684    17.174     0.200
     0.747    18.292     0.200
     1.003    20.541     0.200
     0.323     6.922     0.200
     0.443     9.823     0.200
     0.709    14.167     0.200
     0.708    14.844     0.200
     0.734    16.236     0.200
     0.742    15.844     0.200
     0.778    16.835     0.200
     0.868    16.757     0.200
     0.815    17.606     0.200
     1.639    29.428     0.200
     4.195    69.247     0.200
     0.265     6.280     0.200
     0.460     9.763     0.200
     0.641    13.235     0.200
     0.711    13.923     0.200
     0.739    15.097     0.200
     0.717    15.156     0.200
     0.757    14.723     0.200
     0.724    15.011     0.200
     0.947    18.127     0.200
     1.552    30.526     0.200
     1.600    31.784     0.200
     1.847    32.559     0.200
     0.096     4.143     0.200
     0.127     4.374     0.200
     0.196     5.438     0.200
     0.268     6.861     0.200
     0.268     6.989     0.200
     0.292     6.275     0.200
     0.254     6.999     0.200
     0.315     7.049     0.200
     0.317     7.897     0.200
     0.331     7.694     0.200
     0.331     7.864     0.200
     0.363     8.160     0.200
     0.378     8.648     0.200
     0.399     8.775     0.200
     0.409     8.780     0.200
     0.376     8.566     0.200
     0.400     9.303     0.200
     0.390     9.340     0.200
     0.399     9.880     0.200
     0.443     9.276     0.200
     0.460    10.257     0.200
     0.478     9.334     0.200
     0.481     9.064     0.200
     0.461    10.242     0.200
     0.499    10.541     0.200
     0.529    10.075     0.200
     0.520    11.342     0.200
     0.562    11.423     0.200
     0.611    13.586     0.200
     0.665    13.635     0.200
     0.680    13.571     0.200
     0.714    13.928     0.200
     0.716    13.876     0.200
     0.708    14.608     0.200
     0.776    15.210     0.200
     0.742    15.646     0.200
     0.804    15.403     0.200
     0.918    17.481     0.200
     1.502    28.087     0.200
     1.569    30.737     0.200
     1.954    32.789     0.200
     0.291     7.038     0.200
     0.481    10.164     0.200
     0.481    11.156     0.200
     0.549    12.142     0.200
     0.579    12.367     0.200
     0.676    13.579     0.200
     0.682    14.702     0.200
     0.705    15.628     0.200
     0.741    15.677     0.200
     0.821    17.934     0.200
     0.821    17.231     0.200
     1.040    20.070     0.200
     1.589    31.996     0.200
     0.074     2.122     0.200
     0.279     7.323     0.200
     0.287     7.025     0.200
     0.327     7.169     0.200
     0.397     8.826     0.200
     0.404     8.504     0.200
     0.451     9.865     0.200
     0.454    10.813     0.200
     0.477    10.056     0.200
     0.479    10.026     0.200
     0.555    12.010     0.200
     0.555    12.277     0.200
     0.596    12.640     0.200
     0.615    13.153     0.200
     0.618    13.490     0.200
     0.646    13.491     0.200
     0.652    14.650     0.200
     0.688    14.401     0.200
     0.693    14.581     0.200
     0.736    15.290     0.200
     0.770    15.847     0.200
     0.770    16.094     0.200
     0.761    16.247     0.200
     0.782    16.553     0.200
     0.808    16.976     0.200
     0.840    17.345     0.200
     0.862    17.608     0.200
     0.894    18.703     0.200
     0.899    18.211     0.200
     0.902    18.630     0.200
     0.929    19.413     0.200
     0.940    19.123     0.200
     1.004    19.983     0.200
     1.004    20.453     0.200
     0.267     7.296     0.200
     0.277     6.996     0.200
     0.312     7.557     0.200
     0.331     7.744     0.200
     0.391     8.674     0.200
     0.395     8.726     0.200
     0.453    10.666     0.200
     0.459    10.160     0.200
     0.468    10.214     0.200
     0.469    10.323     0.200
     0.551    12.483     0.200
     0.589    12.588     0.200
     0.606    13.145     0.200
     0.610    13.417     0.200
     0.636    13.550     0.200
     0.636    13.707     0.200
     0.640    15.047     0.200
     0.679    14.573     0.200
     0.685    14.482     0.200
     0.725    15.554     0.200
     0.749    16.667     0.200
     0.775    16.147     0.200
     0.775    16.304     0.200
     0.776    16.282     0.200
     0.787    17.383     0.200
     0.811    17.571     0.200
     0.821    19.026     0.200
     0.835    17.231     0.200
     0.856    17.509     0.200
     0.883    18.736     0.200
     0.893    18.198     0.200
     0.893    18.664     0.200
     0.938    19.434     0.200
     0.992    19.814     0.200
     1.019    20.639     0.200
     0.254     5.889     0.200
     0.516    11.462     0.200
     0.641    13.317     0.200
     0.701    14.683     0.200
     0.703    14.520     0.200
     0.703    13.939     0.200
     0.773    16.286     0.200
     0.311     7.626     0.200
     0.265     5.818     0.200
     0.629    13.157     0.200
     0.615    12.279     0.200
     0.792    16.431     0.200
     0.836    16.700     0.200
     1.172    21.456     0.200
     0.296     7.555     0.200
     0.351     7.667     0.200
     0.356     8.192     0.200
     0.442     9.570     0.200
     0.509    10.456     0.200
     0.687    14.180     0.200
     1.468    28.523     0.200
     0.137     4.761     0.200
     0.137     4.630     0.200
     0.178     4.881     0.200
     0.174     5.587     0.200
     0.166     4.897     0.200
     0.167     4.970     0.200
     0.188     5.421     0.200
     0.195     6.024     0.200
     0.296     6.997     0.200
     0.269     6.582     0.200
     0.300     7.348     0.200
     0.300     7.239     0.200
     0.292     6.786     0.200
     0.357     8.256     0.200
     0.421     9.872     0.200
     0.437    10.151     0.200
     0.464    10.025     0.200
     0.496    11.006     0.200
     0.511    10.802     0.200
     0.502    11.268     0.200
     0.522    10.987     0.200
     0.551    11.579     0.200
     0.551    11.816     0.200
     0.533    11.386     0.200
     0.535    11.082     0.200
     0.607    12.106     0.200
     0.618    14.680     0.200
     0.644    12.963     0.200
     0.644    12.793     0.200
     0.625    13.375     0.200
     0.642    13.227     0.200
     0.642    13.467     0.200
     0.650    13.858     0.200
     0.670    14.024     0.200
     0.670    14.674     0.200
     0.727    14.957     0.200
     0.716    15.169     0.200
     0.715    14.303     0.200
     0.738    15.015     0.200
     0.785    15.725     0.200
     0.781    15.420     0.200
     0.781    15.414     0.200
     0.819    15.844     0.200
     0.841    16.655     0.200
     0.883    17.265     0.200
     0.927    17.655     0.200
     1.498    30.506     0.200
     1.563    30.667     0.200
     0.061     4.656     0.200
     0.175     5.933     0.200
     0.207     7.134     0.200
     0.184     5.148     0.200
     0.203     5.571     0.200
     0.250     7.335     0.200
     0.364     9.368     0.200
     0.435     9.268     0.200
     0.550    11.219     0.200
     0.640    12.714     0.200
     0.685    14.570     0.200
     0.710    14.817     0.200
     0.710    14.957     0.200
     0.151     6.043     0.200
     0.171     5.963     0.200
     0.212     5.705     0.200
     0.230     6.744     0.200
     0.234     6.634     0.200
     0.295     7.173     0.200
     0.317     7.169     0.200
     0.357     8.913     0.200
     0.364     9.335     0.200
     0.423     8.957     0.200
     0.551    11.973     0.200
     0.549    11.392     0.200
     0.549    11.541     0.200
     0.554    11.660     0.200
     0.568    14.191     0.200
     0.618    12.266     0.200
     0.618    13.250     0.200
     0.736    15.144     0.200
     0.728    15.127     0.200
     0.113     4.337     0.200
     0.164     6.022     0.200
     0.178     5.587     0.200
     0.181     5.285     0.200
     0.185     6.203     0.200
     0.201     5.949     0.200
     0.310     7.233     0.200
     0.312     9.121     0.200
     0.335     7.823     0.200
     0.335     7.773     0.200
     0.369     9.419     0.200
     0.419     9.551     0.200
     0.419     9.364     0.200
     0.426    11.096     0.200
     0.439    10.336     0.200
     0.469    12.210     0.200
     0.552    12.288     0.200
     0.552    12.022     0.200
     0.553    13.331     0.200
     0.625    13.982     0.200
     0.667    15.351     0.200
     0.667    14.179     0.200
     0.667    14.096     0.200
     0.696    15.557     0.200
     0.706    16.356     0.200
     0.719    13.835     0.200
     0.723    15.860     0.200
     0.744    15.774     0.200
     0.744    15.469     0.200
     0.757    15.822     0.200
     0.798    15.856     0.200
     0.798    16.379     0.200
     2.334    40.688     0.200
     0.299     8.249     0.200
     0.361     8.006     0.200
     0.367     7.862     0.200
     0.367     7.756     0.200
     0.432    10.959     0.200
     0.385     9.421     0.200
     0.406     9.953     0.200
     0.458    11.329     0.200
     0.406    10.483     0.200
     0.417     9.631     0.200
     0.417     9.178     0.200
     0.451    10.831     0.200
     0.511    12.533     0.200
     0.549    12.975     0.200
     0.558    14.454     0.200
     0.573    13.501     0.200
     0.658    14.056     0.200
     0.678    14.082     0.200
     0.679    15.606     0.200
     0.635    13.372     0.200
     0.674    14.670     0.200
     0.677    14.561     0.200
     0.719    15.188     0.200
     0.712    14.945     0.200
     0.712    14.773     0.200
     0.729    14.672     0.200
     0.762    16.519     0.200
     0.724    15.963     0.200
     0.724    16.155     0.200
     0.759    16.257     0.200
     0.749    15.746     0.200
     0.749    16.219     0.200
     0.773    16.130     0.200
     0.803    15.165     0.200
     0.803    16.099     0.200
     0.773    16.923     0.200
     0.792    17.616     0.200
     0.801    17.293     0.200
     1.596    32.518     0.200
     1.656    29.409     0.200
     0.292     8.373     0.200
     0.360     7.651     0.200
     0.392     9.528     0.200
     0.413    10.138     0.200
     0.423     9.223     0.200
     0.412    10.790     0.200
     0.450    11.340     0.200
     0.458    10.472     0.200
     0.449    10.463     0.200
     0.505    12.602     0.200
     0.541    12.426     0.200
     0.551    13.954     0.200
     0.651    13.677     0.200
     0.639    13.403     0.200
     0.674    15.416     0.200
     0.671    14.018     0.200
     0.673    15.693     0.200
     0.677    14.699     0.200
     0.680    14.718     0.200
     0.707    14.955     0.200
     0.707    14.674     0.200
     0.722    14.953     0.200
     0.722    15.384     0.200
     0.731    16.061     0.200
     0.731    15.928     0.200
     0.755    16.361     0.200
     0.757    16.803     0.200
     0.751    17.115     0.200
     0.751    16.245     0.200
     0.772    16.473     0.200
     0.801    16.685     0.200
     0.776    17.666     0.200
     1.660    29.873     0.200
     0.214     6.656     0.200
     0.227     6.617     0.200
     0.373     7.160     0.200
     0.386     9.345     0.200
     0.400     9.660     0.200
     0.406     9.336     0.200
     0.406     9.060     0.200
     0.411    10.437     0.200
     0.465    11.307     0.200
     0.474    10.373     0.200
     0.552    13.043     0.200
     0.555    14.206     0.200
     0.588    12.469     0.200
     0.645    13.519     0.200
     0.662    14.296     0.200
     0.685    14.551     0.200
     0.681    14.679     0.200
     0.685    14.695     0.200
     0.688    14.642     0.200
     0.688    14.853     0.200
     0.708    13.948     0.200
     0.725    15.773     0.200
     0.725    15.628     0.200
     0.725    15.732     0.200
     0.738    14.941     0.200
     0.738    15.482     0.200
     0.762    16.804     0.200
     0.771    16.766     0.200
     0.773    17.194     0.200
     0.787    16.600     0.200
     0.791    15.641     0.200
     0.791    16.643     0.200
     0.786    17.197     0.200
     0.805    17.839     0.200
     0.814    17.437     0.200
     1.597    32.968     0.200
     0.198     6.558     0.200
     0.208     5.575     0.200
     0.294     8.187     0.200
     0.391     9.010     0.200
     0.410    10.011     0.200
     0.425     9.299     0.200
     0.425     9.187     0.200
     0.426    11.592     0.200
     0.450    11.131     0.200
     0.446    10.907     0.200
     0.457    10.222     0.200
     0.507    12.454     0.200
     0.542    12.877     0.200
     0.553    14.149     0.200
     0.570    12.210     0.200
     0.636    12.996     0.200
     0.651    13.408     0.200
     0.677    15.438     0.200
     0.671    13.780     0.200
     0.674    14.443     0.200
     0.677    14.579     0.200
     0.677    14.144     0.200
     0.677    14.325     0.200
     0.705    14.761     0.200
     0.721    14.782     0.200
     0.730    15.603     0.200
     0.748    15.831     0.200
     0.748    15.951     0.200
     0.754    15.998     0.200
     0.753    16.095     0.200
     0.769    16.269     0.200
     0.773    17.081     0.200
     0.791    17.352     0.200
     0.804    15.604     0.200
     0.804    15.710     0.200
     0.800    17.127     0.200
     0.199     6.624     0.200
     0.209     5.680     0.200
     0.295     8.657     0.200
     0.390     8.983     0.200
     0.412     9.225     0.200
     0.409     9.991     0.200
     0.424     9.054     0.200
     0.424     9.174     0.200
     0.452    11.228     0.200
     0.446    11.090     0.200
     0.459    10.328     0.200
     0.543    12.634     0.200
     0.554    14.349     0.200
     0.570    12.635     0.200
     0.636    13.140     0.200
     0.672    13.756     0.200
     0.677    14.924     0.200
     0.674    14.786     0.200
     0.677    14.937     0.200
     0.677    14.227     0.200
     0.677    14.397     0.200
     0.677    14.589     0.200
     0.706    14.790     0.200
     0.706    15.054     0.200
     0.722    14.918     0.200
     0.729    15.566     0.200
     0.729    15.276     0.200
     0.748    16.221     0.200
     0.748    16.480     0.200
     0.755    16.274     0.200
     0.754    16.207     0.200
     0.773    17.102     0.200
     0.791    17.242     0.200
     0.804    15.356     0.200
     0.804    16.083     0.200
     0.800    17.277     0.200
     0.151     5.412     0.200
     0.303     6.825     0.200
     0.303     6.196     0.200
     0.307     7.360     0.200
     0.350     8.938     0.200
     0.347     9.349     0.200
     0.358     9.410     0.200
     0.401    10.878     0.200
     0.441    10.326     0.200
     0.446    11.116     0.200
     0.477    10.643     0.200
     0.507    11.956     0.200
     0.519    11.535     0.200
     0.551    11.680     0.200
     0.542    12.031     0.200
     0.556    11.500     0.200
     0.560    13.050     0.200
     0.569    13.793     0.200
     0.574    13.343     0.200
     0.610    12.776     0.200
     0.652    12.837     0.200
     0.676    14.993     0.200
     0.695    14.973     0.200
     0.695    14.348     0.200
     0.701    15.256     0.200
     0.762    16.230     0.200
     0.762    15.929     0.200
     0.805    16.163     0.200
     0.058     3.918     0.200
     0.158     5.716     0.200
     0.197     6.253     0.200
     0.201     7.209     0.200
     0.208     5.306     0.200
     0.208     5.626     0.200
     0.260     8.018     0.200
     0.364     9.728     0.200
     0.363     7.952     0.200
     0.360     8.445     0.200
     0.384     9.509     0.200
     0.456     9.704     0.200
     0.465    11.083     0.200
     0.487    10.437     0.200
     0.572    12.374     0.200
     0.581    12.691     0.200
     0.617    12.030     0.200
     0.617    12.483     0.200
     0.617    12.327     0.200
     0.621    14.259     0.200
     0.675    15.049     0.200
     0.675    14.471     0.200
     0.734    15.024     0.200
     0.734    15.274     0.200
     0.740    15.561     0.200
     0.761    16.469     0.200
     0.776    16.371     0.200
     0.056     4.310     0.200
     0.161     5.796     0.200
     0.196     6.366     0.200
     0.206     5.293     0.200
     0.206     5.465     0.200
     0.257     8.266     0.200
     0.359     8.579     0.200
     0.366     9.548     0.200
     0.386    10.332     0.200
     0.387     9.896     0.200
     0.456     9.636     0.200
     0.463    11.378     0.200
     0.489    10.515     0.200
     0.542    12.558     0.200
     0.572    11.804     0.200
     0.572    12.078     0.200
     0.581    12.141     0.200
     0.606    13.719     0.200
     0.606    14.000     0.200
     0.618    12.454     0.200
     0.618    12.556     0.200
     0.619    14.169     0.200
     0.673    14.853     0.200
     0.732    15.349     0.200
     0.732    15.505     0.200
     0.732    15.646     0.200
     0.724    15.907     0.200
     0.738    15.891     0.200
     0.759    17.074     0.200
     0.773    16.336     0.200
     0.979    18.678     0.200
     0.179     5.152     0.200
     0.293     7.889     0.200
     0.309     7.169     0.200
     0.345     7.664     0.200
     0.364     8.566     0.200
     0.365     8.157     0.200
     0.365     8.024     0.200
     0.412    10.927     0.200
     0.412     9.658     0.200
     0.471     9.956     0.200
     0.471     9.855     0.200
     0.477    11.602     0.200
     0.456    10.139     0.200
     0.488    10.331     0.200
     0.503    10.851     0.200
     0.487     9.536     0.200
     0.498    10.449     0.200
     0.534    13.681     0.200
     0.501    10.556     0.200
     0.553    13.070     0.200
     0.526    11.293     0.200
     0.526    11.403     0.200
     0.576    12.386     0.200
     0.596    12.425     0.200
     0.562    12.616     0.200
     0.605    12.145     0.200
     0.572    12.148     0.200
     0.583    12.897     0.200
     0.641    14.582     0.200
     0.644    13.778     0.200
     0.644    14.067     0.200
     0.658    13.755     0.200
     0.672    13.969     0.200
     0.689    14.832     0.200
     0.756    14.861     0.200
     0.769    14.839     0.200
     0.755    16.060     0.200
     0.756    15.869     0.200
     0.795    17.323     0.200
     0.822    15.795     0.200
     0.818    16.517     0.200
     0.882    17.333     0.200
     0.853    17.144     0.200
     0.906    17.617     0.200
     0.955    18.502     0.200
     1.043    19.563     0.200
     1.043    19.692     0.200
     1.569    31.230     0.200
     0.144     3.781     0.200
     0.244     4.656     0.200
     0.244     6.195     0.200
     0.245     6.032     0.200
     0.276     8.100     0.200
     0.316     8.887     0.200
     0.358     9.551     0.200
     0.374     8.202     0.200
     0.492    12.798     0.200
     0.515    11.253     0.200
     0.523    11.322     0.200
     0.523    11.212     0.200
     0.545    13.356     0.200
     0.547    12.913     0.200
     0.544    12.497     0.200
     0.557    12.121     0.200
     0.562    14.016     0.200
     0.560    13.147     0.200
     0.632    13.478     0.200
     0.636    13.581     0.200
     0.657    14.874     0.200
     0.689    14.676     0.200
     0.713    15.600     0.200
     0.715    14.555     0.200
     0.765    16.005     0.200
     0.784    16.414     0.200
     0.796    17.293     0.200
     0.799    16.614     0.200
     0.849    16.710     0.200
     0.880    17.357     0.200
     0.121     4.626     0.200
     0.125     3.600     0.200
     0.142     4.864     0.200
     0.197     5.247     0.200
     0.197     5.057     0.200
     0.269     6.474     0.200
     0.269     6.154     0.200
     0.269     7.284     0.200
     0.269     7.404     0.200
     0.351     8.070     0.200
     0.367     8.305     0.200
     0.372     9.028     0.200
     0.403     8.828     0.200
     0.403     9.108     0.200
     0.414     9.130     0.200
     0.408     9.492     0.200
     0.427     9.979     0.200
     0.453     9.526     0.200
     0.454     9.736     0.200
     0.459    10.141     0.200
     0.501    10.192     0.200
     0.501     9.852     0.200
     0.501    10.682     0.200
     0.510    10.602     0.200
     0.498     9.926     0.200
     0.557    12.884     0.200
     0.569    11.671     0.200
     0.569    11.961     0.200
     0.590    12.586     0.200
     0.596    11.822     0.200
     0.596    12.033     0.200
     0.586    12.048     0.200
     0.595    11.858     0.200
     0.585    12.093     0.200
     0.585    12.164     0.200
     0.600    12.150     0.200
     0.613    12.674     0.200
     0.613    12.974     0.200
     0.624    12.821     0.200
     0.650    14.911     0.200
     0.650    14.741     0.200
     0.647    13.857     0.200
     0.643    13.033     0.200
     0.663    13.124     0.200
     0.663    13.464     0.200
     0.663    13.654     0.200
     0.663    13.720     0.200
     0.659    13.526     0.200
     0.694    13.510     0.200
     0.694    13.764     0.200
     0.705    15.365     0.200
     0.701    14.106     0.200
     0.739    14.765     0.200
     0.747    16.175     0.200
     0.741    15.192     0.200
     0.741    15.362     0.200
     1.459    21.926     0.200
     1.498    29.112     0.200
     2.550    41.937     0.200
     0.074     4.272     0.200
     0.100     5.125     0.200
     0.125     4.234     0.200
     0.126     4.215     0.200
     0.121     5.283     0.200
     0.128     4.811     0.200
     0.240     5.425     0.200
     0.199     5.884     0.200
     0.219     5.998     0.200
     0.315     7.369     0.200
     0.372     8.640     0.200
     0.419     8.991     0.200
     0.391     9.064     0.200
     0.443     9.983     0.200
     0.453    10.124     0.200
     0.455     9.798     0.200
     0.461     9.937     0.200
     0.566    11.990     0.200
     0.606    12.217     0.200
     0.583    12.357     0.200
     0.579    12.152     0.200
     0.577    12.944     0.200
     0.663    13.180     0.200
     0.663    13.235     0.200
     0.669    14.150     0.200
     0.761    15.325     0.200
     0.782    15.184     0.200
     0.782    14.950     0.200
     0.812    15.489     0.200
     0.812    15.895     0.200
     0.812    15.678     0.200
     0.823    15.783     0.200
     0.838    15.969     0.200
     0.881    16.989     0.200
     1.501    31.168     0.200
     1.592    31.021     0.200
     1.780    31.186     0.200
     0.072     3.770     0.200
     0.159     4.643     0.200
     0.211     6.203     0.200
     0.275     6.181     0.200
     0.283     6.907     0.200
     0.283     6.792     0.200
     0.327     7.200     0.200
     0.327     7.052     0.200
     0.384     8.754     0.200
     0.383     8.402     0.200
     0.375     8.329     0.200
     0.448    10.057     0.200
     0.434     9.975     0.200
     0.438     9.521     0.200
     0.483    10.423     0.200
     0.493    10.434     0.200
     0.513    11.093     0.200
     0.610    12.480     0.200
     0.549    11.543     0.200
     0.603    12.237     0.200
     0.601    12.960     0.200
     0.654    13.650     0.200
     0.630    12.989     0.200
     0.698    15.401     0.200
     0.670    13.492     0.200
     0.663    14.615     0.200
     0.669    14.750     0.200
     0.727    15.486     0.200
     0.744    16.476     0.200
     0.721    15.043     0.200
     0.696    14.964     0.200
     0.772    15.703     0.200
     0.772    16.316     0.200
     0.767    15.921     0.200
     0.769    16.358     0.200
     0.792    15.961     0.200
     0.867    17.099     0.200
     0.835    16.773     0.200
     0.876    17.574     0.200
     0.957    18.627     0.200
     1.067    20.082     0.200
     1.548    31.264     0.200
     0.156     4.604     0.200
     0.256     6.317     0.200
     0.259     6.402     0.200
     0.266     6.307     0.200
     0.284     7.674     0.200
     0.274     6.867     0.200
     0.308     7.832     0.200
     0.324     7.697     0.200
     0.329     8.344     0.200
     0.348     7.967     0.200
     0.370     8.833     0.200
     0.397     8.740     0.200
     0.406     9.030     0.200
     0.419     9.048     0.200
     0.458    10.228     0.200
     0.477    11.551     0.200
     0.483    12.141     0.200
     0.473    10.504     0.200
     0.507    10.753     0.200
     0.573    12.565     0.200
     0.557    12.458     0.200
     0.610    12.722     0.200
     0.610    12.925     0.200
     0.592    13.204     0.200
     0.637    13.275     0.200
     0.599    12.433     0.200
     0.659    15.486     0.200
     0.648    13.099     0.200
     0.659    13.648     0.200
     0.665    13.128     0.200
     0.658    13.518     0.200
     0.677    13.413     0.200
     0.669    13.639     0.200
     0.696    15.548     0.200
     0.682    14.337     0.200
     0.774    15.187     0.200
     0.814    15.899     0.200
     0.841    16.281     0.200
     0.841    16.208     0.200
     0.847    16.395     0.200
     1.436    26.497     0.200
     1.489    29.284     0.200
     1.591    31.733     0.200
     0.157     3.372     0.200
     0.225     6.524     0.200
     0.347     9.541     0.200
     0.411     8.671     0.200
     0.458    11.767     0.200
     0.436     9.400     0.200
     0.436     9.299     0.200
     0.478    12.883     0.200
     0.447    10.049     0.200
     0.460    10.200     0.200
     0.473    10.405     0.200
     0.590    13.837     0.200
     0.596    14.182     0.200
     0.691    14.793     0.200
     0.705    15.954     0.200
     0.715    14.578     0.200
     0.715    14.739     0.200
     0.697    14.230     0.200
     0.708    14.745     0.200
     0.731    15.021     0.200
     0.843    16.921     0.200
     0.853    17.559     0.200
     0.871    18.050     0.200
     0.925    18.214     0.200
     0.912    18.012     0.200
     0.956    18.858     0.200
     2.112    36.904     0.200
     0.154     4.608     0.200
     0.211     6.063     0.200
     0.282     6.704     0.200
     0.282     6.853     0.200
     0.332     7.341     0.200
     0.332     7.177     0.200
     0.370     8.299     0.200
     0.387     8.260     0.200
     0.387     8.974     0.200
     0.439    10.037     0.200
     0.443     9.820     0.200
     0.450     9.986     0.200
     0.487    10.097     0.200
     0.497    10.432     0.200
     0.518    10.990     0.200
     0.545    12.330     0.200
     0.552    11.771     0.200
     0.611    12.666     0.200
     0.598    13.086     0.200
     0.605    12.517     0.200
     0.633    13.070     0.200
     0.659    13.518     0.200
     0.663    14.931     0.200
     0.668    14.060     0.200
     0.673    13.804     0.200
     0.696    14.569     0.200
     0.702    15.297     0.200
     0.725    15.072     0.200
     0.732    15.711     0.200
     0.747    16.874     0.200
     0.768    16.347     0.200
     0.772    16.038     0.200
     0.774    16.949     0.200
     0.774    16.129     0.200
     0.794    15.886     0.200
     0.794    16.144     0.200
     0.835    16.844     0.200
     0.876    17.585     0.200
     1.071    20.440     0.200
     1.538    29.298     0.200
     1.543    30.887     0.200
     0.055     2.650     0.200
     0.105     4.305     0.200
     0.149     6.072     0.200
     0.225     4.323     0.200
     0.286     8.158     0.200
     0.319     8.777     0.200
     0.323     8.657     0.200
     0.364     8.708     0.200
     0.376     9.744     0.200
     0.483    10.361     0.200
     0.506    12.614     0.200
     0.514    12.076     0.200
     0.534    11.450     0.200
     0.549    11.558     0.200
     0.549    11.433     0.200
     0.583    11.839     0.200
     0.578    12.891     0.200
     0.579    12.677     0.200
     0.617    13.231     0.200
     0.639    14.127     0.200
     0.662    13.778     0.200
     0.678    14.887     0.200
     0.691    13.494     0.200
     0.694    14.828     0.200
     0.765    15.646     0.200
     0.199     4.218     0.200
     0.224     5.742     0.200
     0.227     5.381     0.200
     0.231     5.762     0.200
     0.276     6.306     0.200
     0.313     7.309     0.200
     0.330     7.802     0.200
     0.402     8.430     0.200
     0.417     8.071     0.200
     0.437     9.665     0.200
     0.460    10.898     0.200
     0.465    10.857     0.200
     0.481    10.693     0.200
     0.501    10.849     0.200
     0.508    11.068     0.200
     0.527    11.898     0.200
     0.558    12.559     0.200
     0.580    12.402     0.200
     0.585    12.042     0.200
     0.608    13.718     0.200
     0.626    13.642     0.200
     0.648    14.256     0.200
     0.673    13.860     0.200
     0.677    14.488     0.200
     0.670    14.768     0.200
     0.689    14.716     0.200
     0.700    14.178     0.200
     0.726    14.932     0.200
     0.733    15.686     0.200
     0.733    15.976     0.200
     0.723    15.921     0.200
     0.730    15.638     0.200
     0.735    15.975     0.200
     0.801    16.309     0.200
     0.791    16.845     0.200
     0.805    17.002     0.200
     0.808    17.127     0.200
     0.827    16.756     0.200
     0.865    17.561     0.200
     0.866    17.762     0.200
     0.872    17.500     0.200
     1.122    22.061     0.200
     2.571    45.159     0.200
     3.005    50.453     0.200
     3.531    58.382     0.200
     0.136     4.304     0.200
     0.154     4.006     0.200
     0.176     4.293     0.200
     0.176     4.500     0.200
     0.280     7.450     0.200
     0.280     7.251     0.200
     0.257     7.088     0.200
     0.278     7.654     0.200
     0.340     9.202     0.200
     0.340     8.999     0.200
     0.387     8.786     0.200
     0.387     9.016     0.200
     0.385     8.433     0.200
     0.385     8.320     0.200
     0.378     8.286     0.200
     0.378     8.193     0.200
     0.342     9.404     0.200
     0.357    10.025     0.200
     0.380    10.450     0.200
     0.425    10.377     0.200
     0.435     9.434     0.200
     0.405     9.674     0.200
     0.515    11.066     0.200
     0.505    13.349     0.200
     0.546    13.478     0.200
     0.580    12.530     0.200
     0.593    13.235     0.200
     0.601    14.471     0.200
     0.669    13.426     0.200
     0.638    15.038     0.200
     0.631    13.754     0.200
     0.690    13.980     0.200
     0.661    13.912     0.200
     0.697    14.600     0.200
     0.697    14.292     0.200
     0.732    14.545     0.200
     0.732    14.443     0.200
     0.705    14.330     0.200
     0.704    14.177     0.200
     0.708    14.299     0.200
     0.708    14.483     0.200
     0.736    15.198     0.200
     0.743    16.538     0.200
     0.781    15.758     0.200
     0.745    15.611     0.200
     0.764    16.993     0.200
     0.745    15.817     0.200
     0.801    16.143     0.200
     0.774    16.138     0.200
     0.852    16.521     0.200
     0.894    17.489     0.200
     0.112     5.155     0.200
     0.148     5.955     0.200
     0.180     6.239     0.200
     0.224     6.999     0.200
     0.227     7.942     0.200
     0.230     7.208     0.200
     0.257     7.841     0.200
     0.275     7.097     0.200
     0.274     8.122     0.200
     0.274     8.002     0.200
     0.301     7.050     0.200
     0.333     9.637     0.200
     0.338     8.704     0.200
     0.376     8.458     0.200
     0.386     8.208     0.200
     0.420     9.006     0.200
     0.465     9.746     0.200
     0.479    11.464     0.200
     0.497    12.412     0.200
     0.513    12.257     0.200
     0.513    11.727     0.200
     0.544    13.003     0.200
     0.554    11.525     0.200
     0.604    11.887     0.200
     0.661    15.612     0.200
     0.681    15.399     0.200
     0.703    16.481     0.200
     0.703    15.968     0.200
     0.757    15.991     0.200
     0.757    15.810     0.200
     0.757    15.932     0.200
     1.519    27.310     0.200
     2.115    36.204     0.200
     0.348     8.185     0.200
     0.393     8.879     0.200
     0.445     9.629     0.200
     0.442    10.427     0.200
     0.510    10.491     0.200
     0.511    10.596     0.200
     0.512    10.334     0.200
     0.600    12.823     0.200
     0.612    12.547     0.200
     0.643    13.533     0.200
     0.677    13.754     0.200
     0.682    15.733     0.200
     0.713    15.475     0.200
     0.714    14.566     0.200
     0.718    14.947     0.200
     0.785    15.963     0.200
     0.788    15.949     0.200
     0.817    17.491     0.200
     0.843    16.822     0.200
     0.869    17.499     0.200
     0.908    18.112     0.200
     0.143     3.287     0.200
     0.247     7.532     0.200
     0.306     6.864     0.200
     0.317     7.361     0.200
     0.329     8.503     0.200
     0.370     8.589     0.200
     0.374    10.089     0.200
     0.408     9.103     0.200
     0.412     9.125     0.200
     0.414     9.980     0.200
     0.436     9.338     0.200
     0.504    12.481     0.200
     0.523    11.305     0.200
     0.557    12.077     0.200
     0.588    14.038     0.200
     0.598    13.179     0.200
     0.607    13.738     0.200
     0.601    13.003     0.200
     0.655    14.092     0.200
     0.681    14.666     0.200
     0.681    14.334     0.200
     0.702    14.884     0.200
     0.716    14.792     0.200
     0.722    15.067     0.200
     0.720    15.862     0.200
     0.723    15.588     0.200
     0.726    15.416     0.200
     0.740    17.227     0.200
     0.733    15.918     0.200
     0.757    15.969     0.200
     0.765    16.963     0.200
     0.790    17.394     0.200
     0.788    16.138     0.200
     0.794    17.515     0.200
     0.806    16.913     0.200
     0.876    17.138     0.200
     0.137     3.258     0.200
     0.315     7.562     0.200
     0.329     8.322     0.200
     0.365     8.411     0.200
     0.375     9.985     0.200
     0.421     8.581     0.200
     0.406     9.266     0.200
     0.421     9.881     0.200
     0.432     8.962     0.200
     0.506    12.480     0.200
     0.519    12.451     0.200
     0.529    11.422     0.200
     0.588    14.136     0.200
     0.610    14.196     0.200
     0.601    12.812     0.200
     0.653    14.058     0.200
     0.685    15.115     0.200
     0.685    14.315     0.200
     0.719    14.319     0.200
     0.706    14.926     0.200
     0.726    14.761     0.200
     0.729    15.029     0.200
     0.724    15.617     0.200
     0.732    15.309     0.200
     0.742    16.671     0.200
     0.738    15.550     0.200
     0.762    15.695     0.200
     0.775    17.222     0.200
     0.766    16.775     0.200
     0.792    17.211     0.200
     0.799    17.145     0.200
     0.162     4.239     0.200
     0.134     3.844     0.200
     0.162     3.676     0.200
     0.209     5.011     0.200
     0.165     4.682     0.200
     0.177     5.010     0.200
     0.195     4.962     0.200
     0.314     6.465     0.200
     0.406     9.228     0.200
     0.366     8.503     0.200
     0.463     9.769     0.200
     0.418     9.285     0.200
     0.418     9.265     0.200
     0.531    11.290     0.200
     0.460    10.320     0.200
     0.501    11.291     0.200
     0.583    12.190     0.200
     0.522    11.651     0.200
     0.572    12.266     0.200
     0.574    12.642     0.200
     0.683    13.818     0.200
     0.614    12.827     0.200
     0.632    14.121     0.200
     0.648    14.638     0.200
     0.708    14.828     0.200
     0.677    14.240     0.200
     0.689    14.338     0.200
     0.767    15.995     0.200
     0.776    15.899     0.200
     0.726    15.182     0.200
     0.743    15.611     0.200
     0.808    16.429     0.200
     0.830    16.994     0.200
     0.770    15.918     0.200
     0.820    15.934     0.200
     0.903    17.808     0.200
     0.225     5.650     0.200
     0.324     7.983     0.200
     0.365     9.064     0.200
     0.397     8.949     0.200
     0.413     9.494     0.200
     0.446     9.769     0.200
     0.449    10.116     0.200
     0.459    10.278     0.200
     0.458     9.790     0.200
     0.465    10.421     0.200
     0.486    11.367     0.200
     0.565    12.015     0.200
     0.583    12.570     0.200
     0.583    13.020     0.200
     0.588    12.261     0.200
     0.608    12.843     0.200
     0.600    12.862     0.200
     0.665    15.401     0.200
     0.675    14.133     0.200
     0.688    14.135     0.200
     0.685    16.200     0.200
     0.697    15.170     0.200
     0.760    15.945     0.200
     0.734    15.148     0.200
     0.740    15.829     0.200
     0.779    15.718     0.200
     0.781    16.040     0.200
     0.787    16.450     0.200
     0.799    17.338     0.200
     0.809    16.356     0.200
     0.806    16.806     0.200
     0.818    16.451     0.200
     0.814    16.073     0.200
     0.834    16.583     0.200
     0.834    16.832     0.200
     0.843    17.447     0.200
     0.863    17.792     0.200
     0.879    17.397     0.200
     0.947    18.997     0.200
     0.212     5.315     0.200
     0.284     6.836     0.200
     0.294     8.260     0.200
     0.310     8.546     0.200
     0.279     6.017     0.200
     0.348     9.369     0.200
     0.366     9.637     0.200
     0.414    11.808     0.200
     0.438    10.351     0.200
     0.521    12.096     0.200
     0.488    10.897     0.200
     0.532    13.630     0.200
     0.545    11.752     0.200
     0.526    12.201     0.200
     0.517    11.763     0.200
     0.538    12.704     0.200
     0.554    13.718     0.200
     0.552    13.064     0.200
     0.593    12.406     0.200
     0.579    14.176     0.200
     0.592    12.565     0.200
     0.662    14.330     0.200
     0.671    14.185     0.200
     0.696    15.122     0.200
     0.690    14.258     0.200
     0.706    15.532     0.200
     0.773    15.951     0.200
     0.802    17.064     0.200
     0.817    16.645     0.200
     0.810    16.188     0.200
     0.818    16.603     0.200
     0.261     6.401     0.200
     0.256     6.668     0.200
     0.357     9.047     0.200
     0.382     7.827     0.200
     0.365     9.767     0.200
     0.384     8.348     0.200
     0.378    10.352     0.200
     0.402    10.655     0.200
     0.424    10.221     0.200
     0.415     8.490     0.200
     0.415     9.597     0.200
     0.447     9.546     0.200
     0.492    10.628     0.200
     0.492    10.097     0.200
     0.526    13.437     0.200
     0.558    11.857     0.200
     0.565    13.686     0.200
     0.620    14.534     0.200
     0.651    12.532     0.200
     0.629    13.297     0.200
     0.659    15.198     0.200
     0.675    13.104     0.200
     0.662    13.580     0.200
     0.679    13.699     0.200
     0.686    13.528     0.200
     0.691    13.657     0.200
     0.693    13.658     0.200
     0.693    13.392     0.200
     0.747    14.592     0.200
     0.778    15.082     0.200
     0.999    17.788     0.200
     0.102     3.885     0.200
     0.153     4.331     0.200
     0.179     5.821     0.200
     0.248     6.551     0.200
     0.448    10.197     0.200
     0.456    11.303     0.200
     0.712    15.193     0.200
     0.715    14.982     0.200
     0.780    16.903     0.200
     0.104     3.878     0.200
     0.106     2.297     0.200
     0.113     4.832     0.200
     0.172     5.479     0.200
     0.162     4.620     0.200
     0.163     6.096     0.200
     0.240     7.214     0.200
     0.230     6.590     0.200
     0.394     9.098     0.200
     0.423    10.115     0.200
     0.457    10.880     0.200
     0.444    10.599     0.200
     0.459    10.712     0.200
     0.457    11.580     0.200
     0.463    11.990     0.200
     0.492    11.956     0.200
     0.610    14.968     0.200
     0.590    13.517     0.200
     0.630    14.722     0.200
     0.628    13.522     0.200
     0.641    15.011     0.200
     0.678    14.652     0.200
     0.687    14.738     0.200
     0.681    14.521     0.200
     0.717    15.844     0.200
     0.716    15.657     0.200
     0.719    15.677     0.200
     0.719    15.255     0.200
     0.770    15.901     0.200
     0.761    15.892     0.200
     0.783    17.489     0.200
     0.782    17.376     0.200
     0.784    16.578     0.200
     0.809    17.696     0.200
     0.829    18.940     0.200
     0.833    17.975     0.200
     0.090     3.929     0.200
     0.102     2.084     0.200
     0.154     4.088     0.200
     0.174     6.033     0.200
     0.243     7.149     0.200
     0.318     7.172     0.200
     0.321     7.174     0.200
     0.371     8.968     0.200
     0.405    10.227     0.200
     0.408     9.828     0.200
     0.433     9.952     0.200
     0.445    10.604     0.200
     0.448     9.954     0.200
     0.454    10.338     0.200
     0.470    11.459     0.200
     0.468    11.023     0.200
     0.496    11.713     0.200
     0.496    13.393     0.200
     0.605    12.908     0.200
     0.603    13.534     0.200
     0.609    15.210     0.200
     0.621    14.272     0.200
     0.635    13.160     0.200
     0.637    15.477     0.200
     0.668    14.350     0.200
     0.696    14.481     0.200
     0.726    16.083     0.200
     0.726    15.309     0.200
     0.729    15.207     0.200
     0.774    16.673     0.200
     0.790    16.485     0.200
     0.784    17.405     0.200
     0.794    16.668     0.200
     0.798    16.759     0.200
     0.821    17.872     0.200
     0.093     4.128     0.200
     0.089     4.637     0.200
     0.135     3.527     0.200
     0.188     5.704     0.200
     0.190     6.147     0.200
     0.260     7.875     0.200
     0.338     7.542     0.200
     0.408     9.882     0.200
     0.427    10.756     0.200
     0.430    10.233     0.200
     0.450    10.065     0.200
     0.445    10.880     0.200
     0.469    11.245     0.200
     0.519    13.718     0.200
     0.516    11.132     0.200
     0.598    13.509     0.200
     0.628    13.502     0.200
     0.640    14.294     0.200
     0.655    13.483     0.200
     0.682    14.689     0.200
     0.673    14.098     0.200
     0.713    14.737     0.200
     0.711    15.263     0.200
     0.714    14.521     0.200
     0.714    15.169     0.200
     0.769    14.482     0.200
     0.761    17.041     0.200
     0.775    16.706     0.200
     0.782    16.827     0.200
     0.795    16.984     0.200
     0.808    17.721     0.200
     1.009    19.675     0.200
     0.140     4.811     0.200
     0.302     6.165     0.200
     0.339     7.499     0.200
     0.340     7.352     0.200
     0.346     7.296     0.200
     0.356     8.011     0.200
     0.352     8.409     0.200
     0.347     7.621     0.200
     0.424     9.389     0.200
     0.431     9.603     0.200
     0.457    10.248     0.200
     0.470    10.117     0.200
     0.459    10.807     0.200
     0.481    10.509     0.200
     0.481    10.380     0.200
     0.475    11.242     0.200
     0.504    11.067     0.200
     0.501    11.387     0.200
     0.526    12.196     0.200
     0.526    12.038     0.200
     0.549    12.193     0.200
     0.581    12.497     0.200
     0.592    13.203     0.200
     0.623    13.378     0.200
     0.687    14.049     0.200
     0.680    13.670     0.200
     0.704    14.997     0.200
     0.693    15.337     0.200
     0.741    15.694     0.200
     0.756    16.509     0.200
     0.774    16.377     0.200
     0.762    15.766     0.200
     0.766    17.422     0.200
     0.814    18.220     0.200
     0.821    18.444     0.200
     0.803    16.426     0.200
     0.844    17.447     0.200
     0.849    17.370     0.200
     0.880    17.849     0.200
     0.880    18.474     0.200
     0.898    18.259     0.200
     0.958    19.480     0.200
     1.047    20.460     0.200
     1.583    31.708     0.200
     0.122     4.604     0.200
     0.206     5.553     0.200
     0.316     6.833     0.200
     0.307     8.053     0.200
     0.323     9.071     0.200
     0.333     9.278     0.200
     0.355     8.408     0.200
     0.345     8.274     0.200
     0.410     9.154     0.200
     0.480    10.170     0.200
     0.493    11.402     0.200
     0.533    11.223     0.200
     0.606    13.457     0.200
     0.581    13.199     0.200
     0.597    13.671     0.200
     0.619    13.119     0.200
     0.660    15.014     0.200
     0.667    14.448     0.200
     0.686    15.148     0.200
     0.716    14.874     0.200
     0.817    18.089     0.200
     0.881    17.670     0.200
     0.910    18.343     0.200
     0.031     2.034     0.200
     0.163     5.357     0.200
     0.197     4.437     0.200
     0.208     5.583     0.200
     0.312     6.518     0.200
     0.321     8.392     0.200
     0.342     8.473     0.200
     0.421     9.004     0.200
     0.488    10.073     0.200
     0.603    13.357     0.200
     0.608    13.608     0.200
     0.647    14.289     0.200
     0.654    14.452     0.200
     0.674    15.016     0.200
     0.709    15.038     0.200
     0.882    18.298     0.200
     0.897    18.692     0.200
     0.900    18.522     0.200
     0.973    19.904     0.200
     0.971    19.101     0.200
     0.157     5.416     0.200
     0.212     5.368     0.200
     0.220     7.007     0.200
     0.238     7.094     0.200
     0.309     6.896     0.200
     0.418     9.279     0.200
     0.446    10.829     0.200
     0.494    11.737     0.200
     0.532    10.702     0.200
     0.604    13.600     0.200
     0.611    13.486     0.200
     0.607    13.626     0.200
     0.652    14.508     0.200
     0.660    14.872     0.200
     0.683    14.555     0.200
     0.716    14.933     0.200
     0.878    17.449     0.200
     0.907    17.146     0.200
     0.907    18.053     0.200
     0.975    18.979     0.200
     0.024     2.695     0.200
     0.195     5.088     0.200
     0.193     6.797     0.200
     0.208     5.397     0.200
     0.223     7.033     0.200
     0.311     8.214     0.200
     0.314     6.888     0.200
     0.318     9.365     0.200
     0.329     9.174     0.200
     0.347     8.492     0.200
     0.350     8.259     0.200
     0.447    10.782     0.200
     0.484    10.470     0.200
     0.492    11.597     0.200
     0.584    12.976     0.200
     0.608    13.733     0.200
     0.615    12.976     0.200
     0.662    14.249     0.200
     0.714    14.189     0.200
     0.878    17.200     0.200
     0.113     4.743     0.200
     0.160     5.507     0.200
     0.206     5.688     0.200
     0.219     6.847     0.200
     0.286     8.909     0.200
     0.313     8.699     0.200
     0.323     8.908     0.200
     0.345     8.816     0.200
     0.485    10.827     0.200
     0.453    10.829     0.200
     0.614    14.100     0.200
     0.611    13.333     0.200
     0.687    14.695     0.200
     0.708    13.959     0.200
     0.103     4.144     0.200
     0.170     5.760     0.200
     0.207     5.564     0.200
     0.211     6.549     0.200
     0.303     8.763     0.200
     0.295     8.783     0.200
     0.314     9.041     0.200
     0.321     8.287     0.200
     0.336     7.824     0.200
     0.425     9.479     0.200
     0.490    10.316     0.200
     0.587    12.850     0.200
     0.604    13.388     0.200
     0.604    12.817     0.200
     0.647    14.018     0.200
     0.642    14.023     0.200
     0.702    14.312     0.200
     0.697    14.437     0.200
     0.863    17.028     0.200
     0.892    17.376     0.200
     0.019     3.050     0.200
     0.149     5.323     0.200
     0.207     5.655     0.200
     0.223     6.896     0.200
     0.231     6.927     0.200
     0.228     7.211     0.200
     0.274     8.495     0.200
     0.307     8.522     0.200
     0.315     6.744     0.200
     0.324     8.838     0.200
     0.347     8.415     0.200
     0.334     9.297     0.200
     0.355     8.410     0.200
     0.397     9.767     0.200
     0.410     9.272     0.200
     0.443    10.539     0.200
     0.481    10.673     0.200
     0.495    11.496     0.200
     0.531    11.001     0.200
     0.582    12.474     0.200
     0.598    13.492     0.200
     0.603    13.386     0.200
     0.619    12.612     0.200
     0.660    14.693     0.200
     0.676    14.367     0.200
     0.668    14.264     0.200
     0.688    15.121     0.200
     0.718    15.087     0.200
     0.909    17.681     0.200
     5.802    92.119     0.200
     0.037     3.043     0.200
     0.102     5.046     0.200
     0.170     5.844     0.200
     0.186     6.718     0.200
     0.202     5.347     0.200
     0.213     5.549     0.200
     0.239     6.457     0.200
     0.251     7.395     0.200
     0.295     8.902     0.200
     0.313     8.106     0.200
     0.324     8.905     0.200
     0.307     6.927     0.200
     0.335     7.425     0.200
     0.352     8.498     0.200
     0.428     9.473     0.200
     0.456    10.788     0.200
     0.486    11.635     0.200
     0.495    10.963     0.200
     0.539    11.289     0.200
     0.592    12.570     0.200
     0.609    13.459     0.200
     0.600    13.235     0.200
     0.618    13.767     0.200
     0.647    14.462     0.200
     0.667    14.882     0.200
     0.707    14.740     0.200
     0.697    14.849     0.200
     0.866    17.189     0.200
     0.167     5.885     0.200
     0.213     5.597     0.200
     0.225     5.530     0.200
     0.245     7.139     0.200
     0.242     7.307     0.200
     0.288     8.787     0.200
     0.295     6.350     0.200
     0.309     8.986     0.200
     0.318     8.869     0.200
     0.329     8.476     0.200
     0.336     7.954     0.200
     0.365     8.808     0.200
     0.393    10.140     0.200
     0.432     9.451     0.200
     0.443    10.708     0.200
     0.500    11.687     0.200
     0.503    10.859     0.200
     0.525    11.164     0.200
     0.570    13.319     0.200
     0.603    12.836     0.200
     0.598    13.385     0.200
     0.619    13.568     0.200
     0.606    13.739     0.200
     0.652    14.435     0.200
     0.167     5.722     0.200
     0.224     5.772     0.200
     0.243     7.227     0.200
     0.244     7.477     0.200
     0.288     8.598     0.200
     0.296     6.456     0.200
     0.308     8.830     0.200
     0.318     9.393     0.200
     0.336     8.144     0.200
     0.364     8.699     0.200
     0.393    10.079     0.200
     0.430    10.974     0.200
     0.431     9.506     0.200
     0.444    10.714     0.200
     0.502    10.537     0.200
     0.499    11.495     0.200
     0.525    11.087     0.200
     0.602    12.694     0.200
     0.606    13.456     0.200
     0.618    13.266     0.200
     0.720    15.663     0.200
     0.027     3.206     0.200
     0.164     5.709     0.200
     0.210     5.504     0.200
     0.222     5.473     0.200
     0.240     6.911     0.200
     0.200     7.331     0.200
     0.212     6.773     0.200
     0.285     8.384     0.200
     0.325     8.263     0.200
     0.299     6.536     0.200
     0.362     8.490     0.200
     0.340     7.828     0.200
     0.428     9.902     0.200
     0.394     9.933     0.200
     0.443    10.710     0.200
     0.499    10.562     0.200
     0.526    11.132     0.200
     0.599    12.559     0.200
     0.605    13.511     0.200
     0.615    13.442     0.200
     0.602    12.673     0.200
     0.644    14.104     0.200
     0.655    14.133     0.200
     0.677    15.431     0.200
     0.721    14.870     0.200
     0.021     3.212     0.200
     0.130     4.829     0.200
     0.185     4.998     0.200
     0.199     5.156     0.200
     0.205     6.721     0.200
     0.215     6.290     0.200
     0.249     7.724     0.200
     0.327     7.180     0.200
     0.338     7.737     0.200
     0.343     8.974     0.200
     0.353     9.501     0.200
     0.375     8.884     0.200
     0.435    10.551     0.200
     0.465     9.774     0.200
     0.501    11.341     0.200
     0.571    13.301     0.200
     0.569    12.044     0.200
     0.639    13.701     0.200
     0.657    14.563     0.200
     0.680    14.678     0.200
     0.687    14.601     0.200
     0.725    14.949     0.200
     0.897    17.718     0.200
     0.925    17.958     0.200
     0.203     4.776     0.200
     0.245     5.304     0.200
     0.338     9.376     0.200
     0.313     7.098     0.200
     0.301     8.663     0.200
     0.368     9.570     0.200
     0.364     9.608     0.200
     0.414    11.136     0.200
     0.445    10.156     0.200
     0.467    10.488     0.200
     0.507    11.612     0.200
     0.528    12.115     0.200
     0.561    13.237     0.200
     0.520    12.366     0.200
     0.566    11.779     0.200
     0.618    12.583     0.200
     0.694    15.328     0.200
     0.660    14.153     0.200
     0.701    14.752     0.200
     0.793    16.431     0.200
     0.067     3.362     0.200
     0.143     5.107     0.200
     0.224     5.640     0.200
     0.281     7.951     0.200
     0.273     5.679     0.200
     0.277     6.521     0.200
     0.280     6.692     0.200
     0.339     9.028     0.200
     0.400    10.959     0.200
     0.412     9.550     0.200
     0.496    10.597     0.200
     0.523    12.135     0.200
     0.535    11.345     0.200
     0.529    11.876     0.200
     0.540    12.550     0.200
     0.587    12.168     0.200
     0.567    13.339     0.200
     0.607    13.397     0.200
     0.679    13.862     0.200
     0.691    14.825     0.200
     0.099     3.587     0.200
     0.231     4.984     0.200
     0.236     5.451     0.200
     0.269     5.941     0.200
     0.273     7.262     0.200
     0.302     6.332     0.200
     0.293     6.247     0.200
     0.313     6.905     0.200
     0.336     7.845     0.200
     0.341     6.986     0.200
     0.352     8.836     0.200
     0.419     9.346     0.200
     0.429     9.478     0.200
     0.449     9.998     0.200
     0.454     9.645     0.200
     0.457     9.186     0.200
     0.472    10.300     0.200
     0.458    10.716     0.200
     0.502    11.413     0.200
     0.503    10.668     0.200
     0.539    11.209     0.200
     0.534    11.266     0.200
     0.603    12.879     0.200
     0.626    13.887     0.200
     0.627    13.005     0.200
     0.636    13.535     0.200
     0.652    14.266     0.200
     0.681    14.116     0.200
     0.671    14.152     0.200
     0.696    15.349     0.200
     0.673    14.137     0.200
     0.690    14.251     0.200
     0.683    14.492     0.200
     0.697    15.240     0.200
     0.735    15.501     0.200
     0.739    15.673     0.200
     0.738    16.299     0.200
     0.773    15.555     0.200
     0.775    16.171     0.200
     0.801    16.339     0.200
     0.791    16.519     0.200
     0.809    16.325     0.200
     0.823    16.737     0.200
     0.837    17.515     0.200
     0.839    17.941     0.200
     0.895    17.824     0.200
     5.119    82.555     0.200
     0.229     5.868     0.200
     0.233     6.037     0.200
     0.440    10.588     0.200
     0.437     9.488     0.200
     0.453    10.189     0.200
     0.495     9.258     0.200
     0.498     9.727     0.200
     0.506    10.772     0.200
     0.541    10.254     0.200
     0.499    11.766     0.200
     0.566    13.266     0.200
     0.586    12.558     0.200
     0.639    12.645     0.200
     0.648    12.410     0.200
     0.654    12.816     0.200
     0.659    13.160     0.200
     0.656    12.801     0.200
     0.667    14.765     0.200
     0.704    13.791     0.200
     0.711    14.719     0.200
     0.733    14.388     0.200
     0.760    14.848     0.200
     0.839    15.919     0.200
     1.276    22.299     0.200
     0.011     1.288     0.200
     0.071     3.614     0.200
     0.095     3.929     0.200
     0.151     4.962     0.200
     0.194     6.063     0.200
     0.191     7.070     0.200
     0.203     6.684     0.200
     0.215     5.607     0.200
     0.262     5.633     0.200
     0.289     7.897     0.200
     0.293     6.542     0.200
     0.350     9.505     0.200
     0.366     9.388     0.200
     0.425     9.943     0.200
     0.468    10.447     0.200
     0.520    11.669     0.200
     0.574    11.861     0.200
     0.535    12.172     0.200
     0.545    11.889     0.200
     0.568    12.654     0.200
     0.599    12.655     0.200
     0.605    13.884     0.200
     0.672    14.419     0.200
     0.611    13.032     0.200
     0.626    13.816     0.200
     0.644    13.796     0.200
     0.680    14.401     0.200
     0.681    15.308     0.200
     0.705    16.024     0.200
     0.703    15.630     0.200
     0.725    16.576     0.200
     0.760    16.742     0.200
     0.808    17.572     0.200
     0.794    18.289     0.200
     0.813    18.133     0.200
     0.826    16.481     0.200
     0.893    17.902     0.200
     0.112     4.355     0.200
     0.099     4.058     0.200
     0.204     5.948     0.200
     0.286     8.002     0.200
     0.289     6.800     0.200
     0.367     9.431     0.200
     0.421     9.710     0.200
     0.488    11.012     0.200
     0.522    11.849     0.200
     0.542    11.850     0.200
     0.542    13.759     0.200
     0.536    12.538     0.200
     0.564    12.811     0.200
     0.595    12.349     0.200
     0.576    11.768     0.200
     0.609    14.176     0.200
     0.646    15.058     0.200
     0.676    14.015     0.200
     0.643    13.893     0.200
     0.674    13.502     0.200
     0.699    15.439     0.200
     0.699    15.189     0.200
     0.725    16.473     0.200
     0.759    16.906     0.200
     0.775    16.060     0.200
     0.782    18.338     0.200
     0.788    15.990     0.200
     0.794    17.203     0.200
     0.811    17.538     0.200
     0.825    16.766     0.200
     0.895    17.730     0.200
     0.063     3.139     0.200
     0.150     5.392     0.200
     0.232     4.489     0.200
     0.222     6.432     0.200
     0.251     7.424     0.200
     0.260     6.724     0.200
     0.297     8.333     0.200
     0.332     9.059     0.200
     0.332     8.650     0.200
     0.369     9.367     0.200
     0.388     9.798     0.200
     0.391    10.785     0.200
     0.434    11.136     0.200
     0.495    10.778     0.200
     0.508    11.767     0.200
     0.512    12.326     0.200
     0.523    12.704     0.200
     0.543    11.225     0.200
     0.537    13.263     0.200
     0.579    13.278     0.200
     0.566    12.879     0.200
     0.566    13.290     0.200
     0.586    13.664     0.200
     0.591    12.525     0.200
     0.623    13.916     0.200
     0.628    14.249     0.200
     0.647    13.936     0.200
     0.655    12.301     0.200
     0.660    14.490     0.200
     0.638    14.702     0.200
     0.664    15.133     0.200
     0.647    14.465     0.200
     0.689    15.413     0.200
     0.697    14.322     0.200
     0.752    16.241     0.200
     0.775    16.106     0.200
     0.759    17.435     0.200
     0.777    15.856     0.200
     0.791    16.984     0.200
     0.797    17.324     0.200
     0.790    15.385     0.200
     0.804    17.134     0.200
     0.795    18.092     0.200
     0.786    16.087     0.200
     0.809    17.307     0.200
     0.823    16.424     0.200
     0.853    17.307     0.200
     0.974    18.918     0.200
     0.029     2.493     0.200
     0.051     3.385     0.200
     0.098     4.458     0.200
     0.135     5.473     0.200
     0.220     7.484     0.200
     0.255     7.982     0.200
     0.310     8.233     0.200
     0.286     6.466     0.200
     0.330     9.026     0.200
     0.322     8.559     0.200
     0.325     8.608     0.200
     0.388     9.078     0.200
     0.483    11.871     0.200
     0.531    11.036     0.200
     0.525    12.497     0.200
     0.540    13.211     0.200
     0.559    11.565     0.200
     0.599    13.162     0.200
     0.576    12.105     0.200
     0.587    12.858     0.200
     0.642    12.787     0.200
     0.631    14.352     0.200
     0.664    14.083     0.200
     0.680    14.424     0.200
     0.679    14.578     0.200
     0.681    13.844     0.200
     0.026     2.618     0.200
     0.053     3.120     0.200
     0.100     3.973     0.200
     0.122     4.825     0.200
     0.167     6.118     0.200
     0.226     7.235     0.200
     0.258     6.174     0.200
     0.285     6.118     0.200
     0.324     8.958     0.200
     0.324     8.314     0.200
     0.333     8.924     0.200
     0.402    11.048     0.200
     0.452    11.133     0.200
     0.480    11.397     0.200
     0.510    10.870     0.200
     0.521    12.336     0.200
     0.525    12.236     0.200
     0.534    12.361     0.200
     0.521    11.296     0.200
     0.544    13.421     0.200
     0.562    11.737     0.200
     0.553    12.744     0.200
     0.560    12.231     0.200
     0.584    13.483     0.200
     0.577    12.142     0.200
     0.600    13.247     0.200
     0.607    13.411     0.200
     0.645    13.827     0.200
     0.634    14.426     0.200
     0.653    14.018     0.200
     0.670    14.083     0.200
     0.681    14.797     0.200
     0.683    15.378     0.200
     0.667    14.367     0.200
     0.681    15.040     0.200
     0.681    14.005     0.200
     0.762    16.454     0.200
     0.782    16.354     0.200
     0.774    15.497     0.200
     0.797    16.519     0.200
     0.797    15.860     0.200
     0.797    17.984     0.200
     0.806    17.395     0.200
     0.810    17.392     0.200
     0.831    16.816     0.200
     0.874    17.362     0.200
     0.996    19.035     0.200
     0.030     2.777     0.200
     0.054     3.364     0.200
     0.101     4.447     0.200
     0.121     4.890     0.200
     0.135     5.240     0.200
     0.217     6.887     0.200
     0.254     6.091     0.200
     0.227     7.270     0.200
     0.257     7.495     0.200
     0.250     6.498     0.200
     0.311     8.394     0.200
     0.289     6.072     0.200
     0.325     8.218     0.200
     0.333     8.699     0.200
     0.379    10.566     0.200
     0.387     9.009     0.200
     0.386     9.460     0.200
     0.507    10.915     0.200
     0.480    11.576     0.200
     0.516    11.970     0.200
     0.530    11.756     0.200
     0.522    12.175     0.200
     0.542    13.373     0.200
     0.559    11.634     0.200
     0.524    11.406     0.200
     0.555    12.754     0.200
     0.561    12.685     0.200
     0.579    11.881     0.200
     0.596    13.213     0.200
     0.584    13.224     0.200
     0.605    13.117     0.200
     0.641    13.352     0.200
     0.639    14.380     0.200
     0.652    13.768     0.200
     0.664    14.207     0.200
     0.677    14.760     0.200
     0.683    14.925     0.200
     0.684    13.921     0.200
     0.740    15.571     0.200
     0.760    16.682     0.200
     0.781    15.301     0.200
     0.793    16.107     0.200
     0.776    15.524     0.200
     0.796    17.968     0.200
     0.036     1.843     0.200
     0.291     7.887     0.200
     0.299     6.022     0.200
     0.343     9.080     0.200
     0.363     9.105     0.200
     0.430    11.029     0.200
     0.439    11.168     0.200
     0.501    11.532     0.200
     0.495    10.907     0.200
     0.541    11.384     0.200
     0.542    12.262     0.200
     0.519    12.190     0.200
     0.518    11.044     0.200
     0.553    13.006     0.200
     0.542    12.672     0.200
     0.585    12.171     0.200
     0.584    13.962     0.200
     0.574    12.372     0.200
     0.592    13.098     0.200
     0.611    13.547     0.200
     0.610    12.485     0.200
     0.613    12.968     0.200
     0.643    13.741     0.200
     0.659    13.874     0.200
     0.666    14.375     0.200
     0.669    14.889     0.200
     0.674    15.574     0.200
     0.684    14.875     0.200
     0.709    14.617     0.200
     0.721    15.301     0.200
     0.725    15.826     0.200
     0.738    16.206     0.200
     0.755    17.326     0.200
     0.776    16.761     0.200
     0.769    16.913     0.200
     0.793    16.674     0.200
     0.791    16.401     0.200
     0.793    16.559     0.200
     0.793    16.453     0.200
     0.809    16.292     0.200
     1.550    29.497     0.200
     0.039     2.723     0.200
     0.054     3.276     0.200
     0.102     4.030     0.200
     0.115     4.768     0.200
     0.144     5.249     0.200
     0.223     6.974     0.200
     0.240     4.902     0.200
     0.245     5.928     0.200
     0.250     7.563     0.200
     0.296     6.176     0.200
     0.302     8.288     0.200
     0.321     8.605     0.200
     0.324     8.361     0.200
     0.328     8.913     0.200
     0.378     8.893     0.200
     0.374    10.349     0.200
     0.393    10.811     0.200
     0.444    10.529     0.200
     0.485    11.820     0.200
     0.499    10.325     0.200
     0.519    12.131     0.200
     0.533    11.487     0.200
     0.516    12.109     0.200
     0.522    11.548     0.200
     0.536    13.297     0.200
     0.563    13.235     0.200
     0.567    12.530     0.200
     0.550    11.330     0.200
     0.589    13.325     0.200
     0.581    12.072     0.200
     0.590    12.735     0.200
     0.637    14.286     0.200
     0.632    13.208     0.200
     0.632    14.069     0.200
     0.653    13.690     0.200
     0.671    14.496     0.200
     0.655    14.314     0.200
     0.682    15.001     0.200
     0.687    13.724     0.200
     0.748    15.990     0.200
     0.760    16.284     0.200
     0.775    14.719     0.200
     0.797    15.564     0.200
     0.830    16.473     0.200
     0.140     5.332     0.200
     0.198     7.017     0.200
     0.257     6.021     0.200
     0.303     8.466     0.200
     0.275     7.885     0.200
     0.345     8.728     0.200
     0.387     8.973     0.200
     0.399    10.931     0.200
     0.417    11.334     0.200
     0.507    11.797     0.200
     0.521    12.248     0.200
     0.520    11.165     0.200
     0.514    10.855     0.200
     0.542    12.152     0.200
     0.540    12.072     0.200
     0.566    11.312     0.200
     0.622    13.961     0.200
     0.597    12.474     0.200
     0.651    12.767     0.200
     0.644    13.489     0.200
     0.668    14.013     0.200
     0.655    14.803     0.200
     0.669    14.691     0.200
     0.740    16.421     0.200
     0.700    13.096     0.200
     0.775    15.211     0.200
     0.776    17.704     0.200
     0.744    15.823     0.200
     0.789    17.343     0.200
     0.810    15.253     0.200
     0.810    16.292     0.200
     0.795    16.019     0.200
     0.987    18.703     0.200
     0.050     2.418     0.200
     0.111     4.493     0.200
     0.099     4.370     0.200
     0.163     6.053     0.200
     0.157     5.636     0.200
     0.183     6.188     0.200
     0.155     5.873     0.200
     0.165     6.086     0.200
     0.287     6.878     0.200
     0.318     8.260     0.200
     0.302     6.504     0.200
     0.324     8.661     0.200
     0.362     9.564     0.200
     0.395    10.430     0.200
     0.412     9.999     0.200
     0.427     9.299     0.200
     0.496    11.904     0.200
     0.499    12.066     0.200
     0.523    12.253     0.200
     0.554    13.194     0.200
     0.561    11.903     0.200
     0.569    13.862     0.200
     0.595    12.812     0.200
     0.601    12.932     0.200
     0.596    13.204     0.200
     0.622    13.345     0.200
     0.635    14.330     0.200
     0.672    14.280     0.200
     0.671    15.623     0.200
     0.692    16.447     0.200
     0.699    15.480     0.200
     0.712    16.669     0.200
     0.718    15.481     0.200
     0.741    15.573     0.200
     0.750    15.775     0.200
     0.778    16.850     0.200
     0.806    16.883     0.200
     0.824    17.261     0.200
     0.865    17.624     0.200
     0.051     1.474     0.200
     0.098     3.973     0.200
     0.113     4.455     0.200
     0.154     5.729     0.200
     0.185     6.428     0.200
     0.192     4.951     0.200
     0.280     7.930     0.200
     0.301     6.304     0.200
     0.320     8.539     0.200
     0.363     9.634     0.200
     0.396    10.181     0.200
     0.413     9.894     0.200
     0.427    10.435     0.200
     0.443    11.884     0.200
     0.461    12.712     0.200
     0.477    10.581     0.200
     0.496    11.412     0.200
     0.497    11.457     0.200
     0.521    12.088     0.200
     0.555    12.479     0.200
     0.562    11.691     0.200
     0.560    12.683     0.200
     0.570    13.228     0.200
     0.596    13.052     0.200
     0.595    13.746     0.200
     0.602    13.501     0.200
     0.602    12.872     0.200
     0.606    14.754     0.200
     0.623    12.806     0.200
     0.635    13.792     0.200
     0.664    14.671     0.200
     0.672    15.375     0.200
     0.673    14.732     0.200
     0.693    16.273     0.200
     0.711    16.197     0.200
     0.700    15.422     0.200
     0.719    14.694     0.200
     0.736    17.699     0.200
     0.740    15.904     0.200
     0.732    17.062     0.200
     0.738    16.216     0.200
     0.766    16.562     0.200
     0.775    16.946     0.200
     0.777    16.805     0.200
     0.795    17.305     0.200
     0.805    16.731     0.200
     0.810    16.764     0.200
     0.823    16.247     0.200
     0.865    17.426     0.200
     0.055     2.029     0.200
     0.115     4.364     0.200
     0.106     3.842     0.200
     0.161     5.029     0.200
     0.155     6.031     0.200
     0.184     6.096     0.200
     0.165     5.905     0.200
     0.282     7.470     0.200
     0.273     8.036     0.200
     0.309     6.523     0.200
     0.322     8.169     0.200
     0.359     9.591     0.200
     0.384     9.578     0.200
     0.405     9.926     0.200
     0.443    12.028     0.200
     0.458    12.746     0.200
     0.483    11.071     0.200
     0.501    11.879     0.200
     0.520    12.663     0.200
     0.547    12.681     0.200
     0.558    11.954     0.200
     0.574    13.705     0.200
     0.596    12.777     0.200
     0.592    13.843     0.200
     0.595    13.885     0.200
     0.628    13.221     0.200
     0.628    13.959     0.200
     0.666    14.530     0.200
     0.696    15.883     0.200
     0.693    15.286     0.200
     0.706    15.272     0.200
     0.742    16.517     0.200
     0.773    16.951     0.200
     0.787    17.093     0.200
     0.800    16.615     0.200
     0.816    17.593     0.200
     0.857    17.589     0.200
     0.114     4.445     0.200
     0.183     6.251     0.200
     0.273     7.634     0.200
     0.281     6.601     0.200
     0.281     6.440     0.200
     0.317     8.865     0.200
     0.310     6.481     0.200
     0.323     8.295     0.200
     0.357     9.459     0.200
     0.404     9.515     0.200
     0.396    10.231     0.200
     0.417    10.630     0.200
     0.484    10.800     0.200
     0.499    12.224     0.200
     0.521    12.398     0.200
     0.546    12.170     0.200
     0.557    11.843     0.200
     0.586    12.381     0.200
     0.574    13.463     0.200
     0.595    12.495     0.200
     0.595    13.251     0.200
     0.592    12.522     0.200
     0.604    13.946     0.200
     0.627    13.027     0.200
     0.628    13.196     0.200
     0.655    14.254     0.200
     0.662    15.002     0.200
     0.665    13.930     0.200
     0.696    16.223     0.200
     0.706    15.325     0.200
     0.692    15.215     0.200
     0.737    15.434     0.200
     0.742    16.346     0.200
     0.747    15.941     0.200
     0.759    16.983     0.200
     0.771    16.124     0.200
     0.773    15.042     0.200
     0.773    15.999     0.200
     0.800    16.999     0.200
     0.800    16.298     0.200
     0.815    17.018     0.200
     0.866    17.411     0.200
     1.534    30.108     0.200
     0.190     4.927     0.200
     0.203     5.787     0.200
     0.299     8.088     0.200
     0.306     7.886     0.200
     0.321     9.274     0.200
     0.322     9.315     0.200
     0.346     8.427     0.200
     0.362     9.857     0.200
     0.378    10.073     0.200
     0.379    10.581     0.200
     0.392     9.351     0.200
     0.414     9.753     0.200
     0.408    10.094     0.200
     0.422     9.728     0.200
     0.427     9.091     0.200
     0.430     9.027     0.200
     0.447    11.607     0.200
     0.444     9.690     0.200
     0.471    10.269     0.200
     0.484    11.477     0.200
     0.551    13.306     0.200
     0.541    11.558     0.200
     0.577    13.412     0.200
     0.580    14.085     0.200
     0.591    13.048     0.200
     0.589    12.639     0.200
     0.603    12.928     0.200
     0.622    15.081     0.200
     0.649    16.135     0.200
     0.667    13.112     0.200
     0.675    13.997     0.200
     0.677    13.548     0.200
     0.677    13.681     0.200
     0.680    14.109     0.200
     0.680    13.959     0.200
     0.715    14.478     0.200
     0.718    14.270     0.200
     0.721    15.012     0.200
     0.727    16.246     0.200
     0.743    15.108     0.200
     0.743    15.560     0.200
     0.765    15.226     0.200
     0.776    15.800     0.200
     0.804    16.898     0.200
     0.812    16.633     0.200
     0.828    16.491     0.200
     0.884    17.370     0.200
     0.893    17.850     0.200
     0.893    17.363     0.200
     0.916    18.174     0.200
     0.050     3.080     0.200
     0.063     3.681     0.200
     0.110     4.755     0.200
     0.116     4.709     0.200
     0.154     5.367     0.200
     0.225     7.519     0.200
     0.232     5.846     0.200
     0.235     7.243     0.200
     0.248     7.434     0.200
     0.264     6.920     0.200
     0.309     6.535     0.200
     0.330     8.885     0.200
     0.331     8.427     0.200
     0.365     8.728     0.200
     0.374    10.475     0.200
     0.390     9.207     0.200
     0.491    10.598     0.200
     0.483    11.717     0.200
     0.496    11.624     0.200
     0.509    11.366     0.200
     0.516    13.065     0.200
     0.507    11.920     0.200
     0.534    13.066     0.200
     0.539    11.480     0.200
     0.542    11.950     0.200
     0.569    13.135     0.200
     0.569    12.584     0.200
     0.576    12.155     0.200
     0.591    12.243     0.200
     0.588    13.366     0.200
     0.594    13.053     0.200
     0.620    12.998     0.200
     0.623    14.123     0.200
     0.637    14.486     0.200
     0.628    14.034     0.200
     0.648    13.683     0.200
     0.654    13.907     0.200
     0.658    14.533     0.200
     0.643    13.825     0.200
     0.662    14.564     0.200
     0.688    15.024     0.200
     0.698    13.857     0.200
     0.753    16.063     0.200
     0.762    16.297     0.200
     0.771    15.755     0.200
     0.786    15.774     0.200
     0.792    16.071     0.200
     0.163     5.235     0.200
     0.102     4.289     0.200
     0.170     5.131     0.200
     0.167     4.581     0.200
     0.128     4.602     0.200
     0.128     4.605     0.200
     0.155     5.744     0.200
     0.174     5.851     0.200
     0.206     5.203     0.200
     0.203     5.723     0.200
     0.256     6.661     0.200
     0.265     6.659     0.200
     0.330     7.630     0.200
     0.330     7.690     0.200
     0.332     7.812     0.200
     0.297     7.544     0.200
     0.283     8.290     0.200
     0.319     7.404     0.200
     0.371     8.790     0.200
     0.405     9.207     0.200
     0.332     8.569     0.200
     0.402     9.106     0.200
     0.345     8.033     0.200
     0.351     9.646     0.200
     0.365     8.445     0.200
     0.421     9.074     0.200
     0.340     8.708     0.200
     0.388     9.366     0.200
     0.364     8.923     0.200
     0.436    10.110     0.200
     0.425    10.562     0.200
     0.418     9.889     0.200
     0.490    10.109     0.200
     0.455    10.144     0.200
     0.498    10.294     0.200
     0.535    10.919     0.200
     0.457    10.585     0.200
     0.541    11.721     0.200
     0.464    10.871     0.200
     0.515    11.473     0.200
     0.539    10.927     0.200
     0.512    10.870     0.200
     0.514    11.607     0.200
     0.496    11.199     0.200
     0.513    11.431     0.200
     0.596    11.776     0.200
     0.542    13.714     0.200
     0.579    12.964     0.200
     0.606    12.358     0.200
     0.637    12.331     0.200
     0.611    14.176     0.200
     0.612    14.141     0.200
     0.578    13.090     0.200
     0.638    14.759     0.200
     0.663    13.404     0.200
     0.636    13.716     0.200
     0.679    13.220     0.200
     0.670    13.237     0.200
     0.623    13.492     0.200
     0.644    13.268     0.200
     0.627    13.821     0.200
     0.637    12.905     0.200
     0.681    13.952     0.200
     0.726    14.204     0.200
     0.733    14.501     0.200
     0.747    14.575     0.200
     0.761    14.741     0.200
     0.748    14.737     0.200
     0.763    14.719     0.200
     0.780    14.940     0.200
     0.736    15.294     0.200
     0.726    15.696     0.200
     0.732    15.234     0.200
     0.820    15.807     0.200
     0.813    15.646     0.200
     0.823    15.587     0.200
     0.823    15.857     0.200
     0.854    16.269     0.200
     0.854    15.909     0.200
     0.963    18.005     0.200
     1.192    20.968     0.200
     0.140     4.777     0.200
     0.133     4.819     0.200
     0.171     5.371     0.200
     0.197     5.279     0.200
     0.192     6.048     0.200
     0.221     6.291     0.200
     0.258     6.230     0.200
     0.245     7.385     0.200
     0.269     6.391     0.200
     0.263     6.950     0.200
     0.277     7.179     0.200
     0.300     7.288     0.200
     0.296     6.699     0.200
     0.331     7.717     0.200
     0.317     7.786     0.200
     0.344     7.631     0.200
     0.346     8.154     0.200
     0.375     8.121     0.200
     0.372     8.242     0.200
     0.385     8.610     0.200
     0.389     8.272     0.200
     0.389     8.564     0.200
     0.386     8.872     0.200
     0.405     8.660     0.200
     0.406     8.776     0.200
     0.400     9.010     0.200
     0.410     8.927     0.200
     0.396     9.481     0.200
     0.396     9.043     0.200
     0.427     8.916     0.200
     0.438     9.566     0.200
     0.434     9.395     0.200
     0.451     9.775     0.200
     0.440     9.520     0.200
     0.463    10.219     0.200
     0.454     9.165     0.200
     0.469     9.810     0.200
     0.477     9.930     0.200
     0.465    10.210     0.200
     0.482    10.550     0.200
     0.475    10.715     0.200
     0.499    10.293     0.200
     0.511    10.645     0.200
     0.503    10.649     0.200
     0.523    11.187     0.200
     0.527    11.801     0.200
     0.571    11.416     0.200
     0.577    11.692     0.200
     0.555    13.423     0.200
     0.562    11.901     0.200
     0.571    11.517     0.200
     0.581    12.571     0.200
     0.575    13.588     0.200
     0.576    12.498     0.200
     0.586    12.587     0.200
     0.605    12.236     0.200
     0.613    12.379     0.200
     0.625    12.545     0.200
     0.620    13.009     0.200
     0.645    14.408     0.200
     0.640    13.120     0.200
     0.657    13.834     0.200
     0.652    13.171     0.200
     0.657    13.766     0.200
     0.646    13.406     0.200
     0.643    15.133     0.200
     0.650    14.108     0.200
     0.665    14.356     0.200
     0.684    14.296     0.200
     0.692    13.733     0.200
     0.709    15.218     0.200
     0.705    14.885     0.200
     0.710    15.344     0.200
     0.705    15.720     0.200
     0.706    15.216     0.200
     0.716    14.095     0.200
     0.731    15.169     0.200
     0.733    15.046     0.200
     0.738    15.449     0.200
     0.732    14.481     0.200
     0.732    15.022     0.200
     0.743    14.583     0.200
     0.750    15.656     0.200
     0.742    16.103     0.200
     0.768    17.295     0.200
     0.753    14.885     0.200
     0.755    15.383     0.200
     0.787    15.112     0.200
     0.815    15.710     0.200
     0.094     4.486     0.200
     0.126     6.029     0.200
     0.126     4.857     0.200
     0.133     5.122     0.200
     0.174     5.999     0.200
     0.175     7.352     0.200
     0.235     5.133     0.200
     0.235     5.258     0.200
     0.261     6.989     0.200
     0.266     7.854     0.200
     0.273     5.936     0.200
     0.297     8.531     0.200
     0.316     8.089     0.200
     0.322     7.165     0.200
     0.341     9.212     0.200
     0.359     9.941     0.200
     0.378     8.838     0.200
     0.388     8.405     0.200
     0.435     9.449     0.200
     0.435     9.550     0.200
     0.435     8.996     0.200
     0.461    10.037     0.200
     0.457    11.021     0.200
     0.474    12.006     0.200
     0.479    11.295     0.200
     0.487    11.345     0.200
     0.528    12.900     0.200
     0.536    11.771     0.200
     0.534    11.363     0.200
     0.567    12.026     0.200
     0.565    11.472     0.200
     0.567    11.526     0.200
     0.567    13.831     0.200
     0.582    12.764     0.200
     0.598    12.507     0.200
     0.590    13.992     0.200
     0.625    12.945     0.200
     0.658    14.429     0.200
     0.678    15.987     0.200
     0.671    13.540     0.200
     0.671    15.407     0.200
     0.722    15.236     0.200
     0.722    17.025     0.200
     0.723    16.761     0.200
     0.733    15.417     0.200
     0.749    15.868     0.200
     0.790    16.769     0.200
     0.785    16.943     0.200
     0.811    16.275     0.200
     0.827    16.084     0.200
     1.543    31.183     0.200
     1.541    28.253     0.200
     0.086     2.767     0.200
     0.139     3.350     0.200
     0.142     4.638     0.200
     0.188     5.386     0.200
     0.187     5.281     0.200
     0.209     5.003     0.200
     0.209     5.071     0.200
     0.209     5.264     0.200
     0.225     4.930     0.200
     0.248     5.785     0.200
     0.248     6.105     0.200
     0.226     6.565     0.200
     0.260     5.642     0.200
     0.241     5.351     0.200
     0.249     5.949     0.200
     0.290     6.775     0.200
     0.290     7.045     0.200
     0.285     6.856     0.200
     0.320     7.479     0.200
     0.330     7.658     0.200
     0.320     8.071     0.200
     0.342     8.409     0.200
     0.363     8.444     0.200
     0.347     8.385     0.200
     0.344     8.004     0.200
     0.353     8.760     0.200
     0.366     9.736     0.200
     0.385     9.444     0.200
     0.411     9.978     0.200
     0.427     9.409     0.200
     0.398     8.952     0.200
     0.399     8.953     0.200
     0.411     9.893     0.200
     0.418     9.749     0.200
     0.430    10.144     0.200
     0.426     9.498     0.200
     0.432     9.645     0.200
     0.451     9.763     0.200
     0.433     9.568     0.200
     0.457    10.444     0.200
     0.471     9.869     0.200
     0.520    11.194     0.200
     0.516    11.416     0.200
     0.525    12.448     0.200
     0.532    11.853     0.200
     0.543    11.557     0.200
     0.567    13.294     0.200
     0.537    11.926     0.200
     0.566    12.913     0.200
     0.547    12.482     0.200
     0.557    12.689     0.200
     0.560    12.185     0.200
     0.569    12.630     0.200
     0.582    12.762     0.200
     0.607    12.465     0.200
     0.596    13.465     0.200
     0.635    13.617     0.200
     0.634    12.811     0.200
     0.634    13.533     0.200
     0.641    13.004     0.200
     0.617    15.284     0.200
     0.622    14.130     0.200
     0.664    13.849     0.200
     0.666    13.863     0.200
     0.643    13.531     0.200
     0.652    13.630     0.200
     0.657    13.682     0.200
     0.664    13.778     0.200
     0.685    14.276     0.200
     0.685    14.276     0.200
     0.660    14.265     0.200
     0.661    14.894     0.200
     0.699    15.329     0.200
     0.682    14.413     0.200
     0.703    15.659     0.200
     0.699    14.279     0.200
     0.688    14.314     0.200
     0.707    14.662     0.200
     0.717    14.592     0.200
     0.733    15.635     0.200
     0.703    15.933     0.200
     0.708    14.977     0.200
     0.711    15.948     0.200
     0.747    17.442     0.200
     0.740    14.902     0.200
     0.736    15.139     0.200
     0.747    15.285     0.200
     0.759    14.972     0.200
     0.759    15.164     0.200
     0.761    15.141     0.200
     0.765    15.552     0.200
     0.753    15.689     0.200
     0.782    17.671     0.200
     0.794    17.657     0.200
     0.795    16.070     0.200
     0.773    16.172     0.200
     0.790    15.828     0.200
     0.780    16.675     0.200
     0.788    16.341     0.200
     0.787    16.456     0.200
     0.788    16.872     0.200
     0.808    16.046     0.200
     0.808    15.995     0.200
     0.807    17.033     0.200
     0.832    16.713     0.200
     0.853    16.533     0.200
     0.853    16.802     0.200
     0.857    16.813     0.200
     0.874    17.309     0.200
     0.875    17.642     0.200
     0.911    17.937     0.200
     1.353    23.222     0.200
     0.173     5.339     0.200
     0.158     4.695     0.200
     0.205     5.760     0.200
     0.215     6.802     0.200
     0.243     6.173     0.200
     0.232     5.846     0.200
     0.241     5.921     0.200
     0.246     6.150     0.200
     0.269     6.515     0.200
     0.316     7.632     0.200
     0.298     6.817     0.200
     0.296     6.974     0.200
     0.329     8.157     0.200
     0.299     7.282     0.200
     0.340     8.336     0.200
     0.342     8.416     0.200
     0.341     7.465     0.200
     0.324     7.317     0.200
     0.346     7.900     0.200
     0.374     8.790     0.200
     0.385     9.069     0.200
     0.391     8.649     0.200
     0.366     7.717     0.200
     0.371     8.025     0.200
     0.397     8.864     0.200
     0.427     9.300     0.200
     0.394     8.866     0.200
     0.429     9.984     0.200
     0.432     9.965     0.200
     0.418    10.945     0.200
     0.447     9.824     0.200
     0.442     9.823     0.200
     0.439     9.054     0.200
     0.434     9.435     0.200
     0.444     9.133     0.200
     0.444     9.213     0.200
     0.468    10.058     0.200
     0.502    10.343     0.200
     0.495    10.833     0.200
     0.509    10.981     0.200
     0.511    10.862     0.200
     0.517    10.670     0.200
     0.512    10.429     0.200
     0.528    11.363     0.200
     0.526    10.902     0.200
     0.542    11.167     0.200
     0.551    11.466     0.200
     0.521    10.424     0.200
     0.552    13.437     0.200
     0.542    12.886     0.200
     0.532    11.950     0.200
     0.565    12.235     0.200
     0.531    10.815     0.200
     0.534    11.612     0.200
     0.558    12.734     0.200
     0.540    11.187     0.200
     0.583    13.074     0.200
     0.598    12.309     0.200
     0.592    12.734     0.200
     0.594    12.445     0.200
     0.611    12.791     0.200
     0.633    14.882     0.200
     0.641    13.923     0.200
     0.628    13.378     0.200
     0.667    13.648     0.200
     0.650    14.442     0.200
     0.652    14.457     0.200
     0.662    13.857     0.200
     0.694    14.996     0.200
     0.676    14.286     0.200
     0.673    13.606     0.200
     0.673    13.646     0.200
     0.685    15.517     0.200
     0.673    13.724     0.200
     0.699    13.643     0.200
     0.707    15.360     0.200
     0.711    14.238     0.200
     0.682    14.773     0.200
     0.702    15.110     0.200
     0.688    14.534     0.200
     0.685    14.691     0.200
     0.695    14.263     0.200
     0.731    15.121     0.200
     0.711    14.173     0.200
     0.727    15.914     0.200
     0.721    14.783     0.200
     0.710    15.025     0.200
     0.739    14.355     0.200
     0.750    15.411     0.200
     0.759    16.258     0.200
     0.751    16.954     0.200
     0.773    16.374     0.200
     0.770    15.999     0.200
     0.791    15.410     0.200
     0.779    15.508     0.200
     0.831    15.880     0.200
     0.861    16.589     0.200
     0.885    16.973     0.200
     2.125    38.288     0.200
     2.213    39.807     0.200
     2.943    49.460     0.200
     0.029     1.713     0.200
     0.028     1.913     0.200
     0.083     3.952     0.200
     0.078     3.596     0.200
     0.119     4.704     0.200
     0.164     5.969     0.200
     0.166     5.965     0.200
     0.187     6.700     0.200
     0.206     7.046     0.200
     0.195     6.518     0.200
     0.202     5.221     0.200
     0.302     8.643     0.200
     0.307     6.770     0.200
     0.311     7.435     0.200
     0.360     9.345     0.200
     0.416    11.098     0.200
     0.467    10.630     0.200
     0.524    12.377     0.200
     0.549    13.364     0.200
     0.562    12.109     0.200
     0.558    13.709     0.200
     0.575    13.444     0.200
     0.570    11.879     0.200
     0.586    12.940     0.200
     0.641    14.354     0.200
     0.643    14.121     0.200
     0.651    14.796     0.200
     0.656    15.116     0.200
     0.665    13.586     0.200
     0.698    14.634     0.200
     0.692    15.675     0.200
     0.715    16.169     0.200
     0.722    15.474     0.200
     0.762    16.989     0.200
     0.772    16.510     0.200
     0.777    18.226     0.200
     0.788    16.164     0.200
     0.820    18.196     0.200
     0.825    16.994     0.200
     0.033     1.764     0.200
     0.088     3.985     0.200
     0.073     3.694     0.200
     0.124     4.803     0.200
     0.172     6.079     0.200
     0.170     5.970     0.200
     0.191     7.078     0.200
     0.208     6.990     0.200
     0.196     5.360     0.200
     0.307     8.707     0.200
     0.312     5.917     0.200
     0.315     7.313     0.200
     0.341     8.765     0.200
     0.373     9.735     0.200
     0.442    11.667     0.200
     0.446    10.886     0.200
     0.462    10.885     0.200
     0.496    11.647     0.200
     0.500    11.556     0.200
     0.521    12.216     0.200
     0.527    12.389     0.200
     0.549    13.055     0.200
     0.567    11.865     0.200
     0.579    13.493     0.200
     0.573    12.117     0.200
     0.589    13.375     0.200
     0.589    14.145     0.200
     0.596    14.310     0.200
     0.643    14.641     0.200
     0.640    14.238     0.200
     0.654    15.039     0.200
     0.656    14.610     0.200
     0.667    14.464     0.200
     0.702    14.765     0.200
     0.696    15.905     0.200
     0.716    16.149     0.200
     0.721    16.182     0.200
     0.726    15.761     0.200
     0.760    16.965     0.200
     0.775    15.783     0.200
     0.785    16.222     0.200
     0.784    17.717     0.200
     0.819    18.198     0.200
     0.914    18.423     0.200
     0.025     2.312     0.200
     0.064     3.573     0.200
     0.100     3.372     0.200
     0.094     3.762     0.200
     0.147     5.713     0.200
     0.147     5.672     0.200
     0.209     7.453     0.200
     0.207     6.839     0.200
     0.215     7.175     0.200
     0.220     5.451     0.200
     0.299     7.108     0.200
     0.299     7.428     0.200
     0.318     8.607     0.200
     0.347     9.312     0.200
     0.476    12.090     0.200
     0.505    12.178     0.200
     0.482    10.731     0.200
     0.547    12.010     0.200
     0.523    11.755     0.200
     0.555    11.560     0.200
     0.559    11.829     0.200
     0.559    14.059     0.200
     0.545    12.777     0.200
     0.606    12.954     0.200
     0.632    14.978     0.200
     0.646    13.649     0.200
     0.644    14.340     0.200
     0.652    14.116     0.200
     0.652    13.497     0.200
     0.668    15.213     0.200
     0.674    14.650     0.200
     0.661    14.622     0.200
     0.691    14.587     0.200
     0.713    15.352     0.200
     0.701    15.278     0.200
     0.712    15.756     0.200
     0.723    16.122     0.200
     0.755    15.279     0.200
     0.779    17.316     0.200
     0.796    18.428     0.200
     0.806    16.385     0.200
     0.052     3.340     0.200
     0.051     3.829     0.200
     0.094     4.465     0.200
     0.104     4.639     0.200
     0.104     4.639     0.200
     0.098     4.638     0.200
     0.157     5.841     0.200
     0.228     4.990     0.200
     0.228     4.720     0.200
     0.233     5.809     0.200
     0.237     7.278     0.200
     0.237     7.278     0.200
     0.246     7.258     0.200
     0.288     8.134     0.200
     0.272     6.967     0.200
     0.326     8.793     0.200
     0.317     8.704     0.200
     0.318     7.786     0.200
     0.367     8.651     0.200
     0.364    10.022     0.200
     0.362    10.500     0.200
     0.362    10.180     0.200
     0.484    10.364     0.200
     0.497    11.811     0.200
     0.511    11.386     0.200
     0.496    11.993     0.200
     0.518    11.866     0.200
     0.514    12.213     0.200
     0.510    12.271     0.200
     0.536    11.370     0.200
     0.523    13.080     0.200
     0.523    12.360     0.200
     0.547    12.175     0.200
     0.584    11.746     0.200
     0.579    13.134     0.200
     0.577    13.633     0.200
     0.593    12.215     0.200
     0.593    13.345     0.200
     0.607    13.574     0.200
     0.579    12.031     0.200
     0.600    13.613     0.200
     0.620    12.962     0.200
     0.642    14.024     0.200
     0.642    14.944     0.200
     0.635    14.803     0.200
     0.624    13.988     0.200
     0.666    15.089     0.200
     0.666    14.259     0.200
     0.672    14.869     0.200
     0.675    14.762     0.200
     0.696    15.471     0.200
     0.687    14.237     0.200
     0.766    16.271     0.200
     0.775    15.947     0.200
     0.764    15.677     0.200
     0.758    16.264     0.200
     0.774    15.309     0.200
     0.858    17.179     0.200
     0.977    18.878     0.200
     0.988    18.991     0.200
     1.040    19.577     0.200
     1.034    19.608     0.200
     1.391    24.168     0.200
     0.005     3.765     0.200
     0.065     3.669     0.200
     0.135     4.068     0.200
     0.179     5.261     0.200
     0.198     4.972     0.200
     0.218     5.179     0.200
     0.241     5.827     0.200
     0.267     6.170     0.200
     0.279     6.813     0.200
     0.275     6.244     0.200
     0.286     6.469     0.200
     0.282     7.492     0.200
     0.309     7.416     0.200
     0.331     7.696     0.200
     0.334     7.288     0.200
     0.336     8.323     0.200
     0.336     7.769     0.200
     0.342     9.202     0.200
     0.375     8.306     0.200
     0.355     9.191     0.200
     0.401     9.011     0.200
     0.404     9.006     0.200
     0.386     9.287     0.200
     0.390     9.163     0.200
     0.411     8.886     0.200
     0.404     9.618     0.200
     0.430     9.262     0.200
     0.438     9.780     0.200
     0.441     9.501     0.200
     0.444     9.742     0.200
     0.434     9.927     0.200
     0.465    10.131     0.200
     0.453    10.389     0.200
     0.486     9.970     0.200
     0.483     9.956     0.200
     0.476    11.750     0.200
     0.477    10.303     0.200
     0.483    11.432     0.200
     0.499    10.326     0.200
     0.510    10.679     0.200
     0.519    11.404     0.200
     0.533    10.681     0.200
     0.556    12.085     0.200
     0.574    11.425     0.200
     0.560    11.639     0.200
     0.568    12.351     0.200
     0.578    12.497     0.200
     0.607    12.659     0.200
     0.600    12.673     0.200
     0.612    12.276     0.200
     0.606    12.810     0.200
     0.598    12.598     0.200
     0.611    13.399     0.200
     0.609    13.421     0.200
     0.620    12.953     0.200
     0.616    14.082     0.200
     0.647    12.816     0.200
     0.645    13.519     0.200
     0.656    12.950     0.200
     0.652    13.162     0.200
     0.660    13.262     0.200
     0.656    15.099     0.200
     0.654    13.495     0.200
     0.673    13.595     0.200
     0.675    14.245     0.200
     0.682    13.728     0.200
     0.690    15.689     0.200
     0.706    16.541     0.200
     0.716    14.564     0.200
     0.704    14.455     0.200
     0.725    14.211     0.200
     0.729    14.256     0.200
     0.732    14.468     0.200
     0.741    14.446     0.200
     0.738    14.666     0.200
     0.728    15.216     0.200
     0.734    14.833     0.200
     0.751    14.553     0.200
     0.762    14.819     0.200
     0.768    14.819     0.200
     0.768    15.472     0.200
     0.787    15.422     0.200
     0.800    15.480     0.200
     0.802    15.587     0.200
     0.826    15.871     0.200
     0.835    16.219     0.200
     0.846    16.578     0.200
     0.854    16.544     0.200
     0.921    17.376     0.200
     1.280    21.684     0.200
     0.040     3.314     0.200
     0.124     4.992     0.200
     0.174     5.961     0.200
     0.195     6.239     0.200
     0.185     6.587     0.200
     0.193     7.038     0.200
     0.209     5.895     0.200
     0.242     6.514     0.200
     0.249     5.685     0.200
     0.287     8.892     0.200
     0.337     9.288     0.200
     0.322     8.955     0.200
     0.326     7.435     0.200
     0.356     8.556     0.200
     0.368     9.087     0.200
     0.448    11.530     0.200
     0.428     9.036     0.200
     0.439    10.593     0.200
     0.484    10.401     0.200
     0.483    10.859     0.200
     0.497    12.404     0.200
     0.553    12.047     0.200
     0.560    13.659     0.200
     0.603    13.974     0.200
     0.618    12.221     0.200
     0.617    15.056     0.200
     0.641    14.794     0.200
     0.652    13.243     0.200
     0.701    15.727     0.200
     0.709    16.598     0.200
     0.723    15.576     0.200
     0.752    17.268     0.200
     0.782    15.994     0.200
     0.801    17.246     0.200
     0.841    16.911     0.200
     0.835    16.342     0.200
     0.906    18.056     0.200
     0.124     5.004     0.200
     0.098     5.445     0.200
     0.163     6.258     0.200
     0.178     6.012     0.200
     0.154     6.905     0.200
     0.189     6.659     0.200
     0.196     6.503     0.200
     0.192     6.103     0.200
     0.179     7.514     0.200
     0.212     5.058     0.200
     0.240     7.353     0.200
     0.246     5.652     0.200
     0.288     8.050     0.200
     0.324     9.040     0.200
     0.330     7.493     0.200
     0.359     8.655     0.200
     0.367     9.479     0.200
     0.407     9.240     0.200
     0.432     8.925     0.200
     0.442    10.767     0.200
     0.446    12.173     0.200
     0.481    10.284     0.200
     0.486    11.044     0.200
     0.516    12.235     0.200
     0.497    12.288     0.200
     0.562    13.052     0.200
     0.556    11.587     0.200
     0.602    13.542     0.200
     0.615    12.185     0.200
     0.635    14.027     0.200
     0.650    12.989     0.200
     0.642    14.831     0.200
     0.709    16.466     0.200
     0.700    15.874     0.200
     0.726    16.009     0.200
     0.714    15.490     0.200
     0.751    16.870     0.200
     0.753    17.415     0.200
     0.748    15.230     0.200
     0.763    15.117     0.200
     0.786    16.117     0.200
     0.780    16.707     0.200
     0.798    16.190     0.200
     0.837    16.509     0.200
     0.982    18.602     0.200
     1.067    19.920     0.200
     0.035     2.703     0.200
     0.104     5.392     0.200
     0.125     5.186     0.200
     0.169     5.965     0.200
     0.162     6.972     0.200
     0.206     5.241     0.200
     0.199     6.175     0.200
     0.245     7.356     0.200
     0.287     8.437     0.200
     0.320     7.488     0.200
     0.352     8.476     0.200
     0.342     9.341     0.200
     0.371     9.708     0.200
     0.399     9.208     0.200
     0.423     8.700     0.200
     0.434    10.588     0.200
     0.452    11.206     0.200
     0.451    11.917     0.200
     0.478    10.887     0.200
     0.469    10.743     0.200
     0.488    10.606     0.200
     0.498    12.341     0.200
     0.519    12.584     0.200
     0.547    12.184     0.200
     0.559    13.362     0.200
     0.606    13.977     0.200
     0.629    13.197     0.200
     0.623    12.170     0.200
     0.623    12.740     0.200
     0.640    14.707     0.200
     0.655    13.235     0.200
     0.698    15.951     0.200
     0.720    15.780     0.200
     0.739    15.473     0.200
     0.721    15.643     0.200
     0.755    16.301     0.200
     0.762    16.219     0.200
     0.784    17.575     0.200
     0.773    16.352     0.200
     0.795    16.720     0.200
     0.785    16.335     0.200
     0.804    16.684     0.200
     0.832    16.372     0.200
     0.836    17.141     0.200
     0.831    17.183     0.200
     0.849    17.420     0.200
     0.887    17.857     0.200
     0.902    18.186     0.200
     0.936    18.090     0.200
     0.975    19.095     0.200
     0.988    19.402     0.200
     1.013    19.685     0.200
     1.070    20.279     0.200
     0.034     2.747     0.200
     0.105     5.388     0.200
     0.124     4.936     0.200
     0.168     5.901     0.200
     0.163     6.530     0.200
     0.179     6.079     0.200
     0.187     6.511     0.200
     0.186     7.509     0.200
     0.206     4.693     0.200
     0.199     6.174     0.200
     0.246     6.914     0.200
     0.288     7.929     0.200
     0.317     8.735     0.200
     0.351     8.509     0.200
     0.343     9.563     0.200
     0.371     9.460     0.200
     0.398     9.056     0.200
     0.422     8.865     0.200
     0.433    10.616     0.200
     0.452    11.734     0.200
     0.451    11.470     0.200
     0.478    10.954     0.200
     0.470    10.614     0.200
     0.498    12.676     0.200
     0.488    10.401     0.200
     0.547    11.550     0.200
     0.559    13.654     0.200
     0.607    14.341     0.200
     0.640    14.710     0.200
     0.623    12.050     0.200
     0.655    12.948     0.200
     0.699    15.300     0.200
     0.720    14.779     0.200
     0.707    16.614     0.200
     0.723    15.467     0.200
     0.746    16.594     0.200
     0.750    16.970     0.200
     0.785    17.397     0.200
     0.786    16.042     0.200
     0.796    15.285     0.200
     0.805    17.650     0.200
     0.827    17.207     0.200
     0.836    16.997     0.200
     0.902    17.897     0.200
     1.014    19.551     0.200
     1.167    21.766     0.200
     0.106     5.281     0.200
     0.120     5.033     0.200
     0.162     6.821     0.200
     0.156     5.999     0.200
     0.187     7.354     0.200
     0.173     6.024     0.200
     0.181     6.689     0.200
     0.194     6.152     0.200
     0.188     6.754     0.200
     0.211     5.816     0.200
     0.247     7.348     0.200
     0.292     7.966     0.200
     0.316     8.954     0.200
     0.343     9.350     0.200
     0.322     7.397     0.200
     0.357     8.507     0.200
     0.366     9.531     0.200
     0.426     9.198     0.200
     0.454    11.652     0.200
     0.438    10.768     0.200
     0.446    11.572     0.200
     0.471    11.059     0.200
     0.482    10.325     0.200
     0.483    11.071     0.200
     0.502    12.451     0.200
     0.514    12.234     0.200
     0.551    12.025     0.200
     0.564    13.330     0.200
     0.555    12.458     0.200
     0.609    13.885     0.200
     0.618    12.457     0.200
     0.635    13.875     0.200
     0.645    14.746     0.200
     0.650    13.074     0.200
     0.722    15.187     0.200
     0.703    16.533     0.200
     0.725    15.535     0.200
     0.744    15.581     0.200
     0.744    16.941     0.200
     0.760    16.571     0.200
     0.747    17.316     0.200
     0.767    15.136     0.200
     0.774    16.328     0.200
     0.787    15.968     0.200
     0.801    16.712     0.200
     0.829    16.368     0.200
     0.841    16.920     0.200
     0.907    17.794     0.200
     0.042     3.344     0.200
     0.101     5.333     0.200
     0.122     4.931     0.200
     0.178     6.028     0.200
     0.187     6.786     0.200
     0.181     7.326     0.200
     0.191     6.023     0.200
     0.194     6.476     0.200
     0.242     7.222     0.200
     0.249     5.799     0.200
     0.290     8.894     0.200
     0.321     8.980     0.200
     0.337     9.325     0.200
     0.365     9.426     0.200
     0.360     8.595     0.200
     0.432     9.178     0.200
     0.443    10.682     0.200
     0.449    12.022     0.200
     0.479    10.053     0.200
     0.487    11.055     0.200
     0.500    12.315     0.200
     0.559    12.692     0.200
     0.557    11.872     0.200
     0.564    13.317     0.200
     0.605    13.921     0.200
     0.614    12.341     0.200
     0.637    13.701     0.200
     0.648    13.341     0.200
     0.645    14.608     0.200
     0.698    15.336     0.200
     0.715    15.299     0.200
     0.749    16.843     0.200
     0.751    17.169     0.200
     0.749    15.599     0.200
     0.782    16.486     0.200
     0.800    16.701     0.200
     0.803    17.305     0.200
     0.835    16.346     0.200
     0.835    16.871     0.200
     0.910    17.991     0.200
     1.015    19.548     0.200
     0.146     4.636     0.200
     0.189     4.929     0.200
     0.187     5.524     0.200
     0.249     6.773     0.200
     0.252     6.224     0.200
     0.267     6.630     0.200
     0.283     7.641     0.200
     0.291     8.100     0.200
     0.352     9.819     0.200
     0.355     8.875     0.200
     0.349     8.747     0.200
     0.370     8.554     0.200
     0.392    10.827     0.200
     0.388     8.415     0.200
     0.401    10.874     0.200
     0.403     9.582     0.200
     0.390     8.695     0.200
     0.415    11.127     0.200
     0.420     8.971     0.200
     0.432    10.208     0.200
     0.426     9.050     0.200
     0.441    11.968     0.200
     0.445    10.223     0.200
     0.446     9.637     0.200
     0.467    10.771     0.200
     0.479    10.028     0.200
     0.490    10.241     0.200
     0.503    10.486     0.200
     0.525    12.298     0.200
     0.541    11.182     0.200
     0.562    11.506     0.200
     0.577    13.271     0.200
     0.568    11.758     0.200
     0.575    11.534     0.200
     0.606    13.346     0.200
     0.607    12.531     0.200
     0.615    14.729     0.200
     0.654    13.850     0.200
     0.646    13.162     0.200
     0.664    13.267     0.200
     0.668    14.417     0.200
     0.685    14.041     0.200
     0.688    13.857     0.200
     0.692    13.653     0.200
     0.695    13.679     0.200
     0.695    13.970     0.200
     0.695    14.011     0.200
     0.688    13.763     0.200
     0.713    14.077     0.200
     0.724    14.048     0.200
     0.730    15.182     0.200
     0.741    15.255     0.200
     0.757    16.025     0.200
     0.751    16.051     0.200
     0.773    15.399     0.200
     0.777    15.178     0.200
     0.791    15.694     0.200
     0.845    16.273     0.200
     0.863    16.164     0.200
     0.289     7.520     0.200
     0.307     6.783     0.200
     0.335     8.282     0.200
     0.326     7.364     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
