#!/bin/bash
gmt begin salton5.43_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance salton5.43'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.7  0.000
  0.7 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.800    15.951
     0.900    17.369
     1.000    18.787
     1.100    20.206
     1.200    21.624
     1.300    23.042
     1.400    24.461
     1.500    25.879
     1.600    27.297
     1.700    28.715
     1.800    30.134
     1.900    31.552
     2.000    32.970
     2.100    34.388
     2.200    35.807
     2.300    37.225
     2.400    38.643
     2.500    40.061
     2.600    41.480
     2.700    42.898
     2.800    44.316
     2.900    45.735
     3.000    47.153
     3.100    48.571
     3.200    49.989
     3.300    51.408
     3.400    52.826
     3.500    54.244
     3.600    55.662
     3.700    57.081
     3.800    58.499
     3.900    59.916
     4.000    61.334
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    53.662 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.911
     0.200     4.523
     0.300     6.298
     0.400     8.115
     0.500     9.922
     0.600    11.530
     0.700    13.137
     0.800    14.745
     0.900    16.353
     1.000    17.960
     1.100    19.568
     1.200    21.176
     1.300    22.783
     1.400    24.391
     1.500    25.999
     1.600    27.606
     1.700    29.214
     1.800    30.822
     1.900    32.429
     2.000    34.037
     2.100    35.645
     2.200    37.253
     2.300    38.860
     2.400    40.467
     2.500    42.075
     2.600    43.682
     2.700    45.289
     2.800    46.897
     2.900    48.504
     3.000    50.111
     3.100    51.718
     3.200    53.325
     3.300    54.933
     3.400    56.540
     3.500    58.147
     3.600    59.754
     3.700    61.361
     3.800    62.968
     3.900    64.575
     4.000    66.182
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    58.754 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    37.347
     2.100    39.230
     2.200    41.112
     2.300    42.994
     2.400    44.877
     2.500    46.759
     2.600    48.641
     2.700    50.524
     2.800    52.406
     2.900    54.289
     3.000    56.171
     3.100    58.053
     3.200    59.936
     3.300    61.818
     3.400    63.700
     3.500    65.583
     3.600    67.465
     3.700    69.348
     3.800    71.230
     3.900    73.112
     4.000    74.995
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    69.465 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.900    30.071
     1.000    32.556
     1.100    35.042
     1.200    37.528
     1.300    40.014
     1.400    42.500
     1.500    44.986
     1.600    47.472
     1.700    49.958
     1.800    52.444
     1.900    54.930
     2.000    57.416
     2.100    59.902
     2.200    62.388
     2.300    64.874
     2.400    67.360
     2.500    69.845
     2.600    72.331
     2.700    74.817
     2.800    77.303
     2.900    79.789
     3.000    82.275
     3.100    84.761
     3.200    87.247
     3.300    89.733
     3.400    92.219
     3.500    94.705
     3.600    97.191
     3.700    99.677
     3.800   102.162
     3.900   104.648
     4.000   107.133
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    95.191 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.957
     0.200     7.777
     0.300    10.928
     0.400    14.171
     0.500    17.218
     0.600    19.991
     0.700    22.764
     0.800    25.537
     0.900    28.310
     1.000    31.084
     1.100    33.857
     1.200    36.630
     1.300    39.403
     1.400    42.176
     1.500    44.950
     1.600    47.723
     1.700    50.496
     1.800    53.269
     1.900    56.042
     2.000    58.815
     2.100    61.589
     2.200    64.362
     2.300    67.134
     2.400    69.907
     2.500    72.680
     2.600    75.453
     2.700    78.226
     2.800    80.998
     2.900    83.771
     3.000    86.544
     3.100    89.317
     3.200    92.089
     3.300    94.861
     3.400    97.633
     3.500   100.405
     3.600   103.178
     3.700   105.950
     3.800   108.722
     3.900   111.494
     4.000   114.266
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   102.178 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     1.600    49.371
     1.700    52.542
     1.800    55.713
     1.900    58.885
     2.000    62.056
     2.100    65.228
     2.200    68.399
     2.300    71.570
     2.400    74.742
     2.500    77.913
     2.600    81.085
     2.700    84.256
     2.800    87.428
     2.900    90.599
     3.000    93.770
     3.100    96.942
     3.200   100.113
     3.300   103.285
     3.400   106.456
     3.500   109.627
     3.600   112.799
     3.700   115.970
     3.800   119.142
     3.900   122.313
     4.000   125.484
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   114.799 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    18.532
     1.000    19.950
     1.100    21.369
     1.200    22.787
     1.300    24.205
     1.400    25.624
     1.500    27.042
     1.600    28.460
     1.700    29.878
     1.800    31.297
     1.900    32.715
     2.000    34.133
     2.100    35.551
     2.200    36.970
     2.300    38.388
     2.400    39.806
     2.500    41.224
     2.600    42.643
     2.700    44.061
     2.800    45.479
     2.900    46.897
     3.000    48.316
     3.100    49.734
     3.200    51.152
     3.300    52.570
     3.400    53.989
     3.500    55.407
     3.600    56.825
     3.700    58.244
     3.800    59.662
     3.900    61.080
     4.000    62.498
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     2.353
     0.200     4.651
     0.300     6.556
     0.400     8.408
     0.500    10.260
     0.600    12.111
     0.700    13.963
     0.800    15.711
     0.900    17.319
     1.000    18.926
     1.100    20.534
     1.200    22.142
     1.300    23.749
     1.400    25.357
     1.500    26.965
     1.600    28.572
     1.700    30.180
     1.800    31.788
     1.900    33.395
     2.000    35.003
     2.100    36.611
     2.200    38.218
     2.300    39.826
     2.400    41.434
     2.500    43.041
     2.600    44.648
     2.700    46.256
     2.800    47.863
     2.900    49.470
     3.000    51.078
     3.100    52.685
     3.200    54.292
     3.300    55.899
     3.400    57.506
     3.500    59.113
     3.600    60.721
     3.700    62.328
     3.800    63.935
     3.900    65.542
     4.000    67.148
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    32.046
     1.000    34.533
     1.100    37.019
     1.200    39.505
     1.300    41.991
     1.400    44.477
     1.500    46.962
     1.600    49.448
     1.700    51.934
     1.800    54.420
     1.900    56.906
     2.000    59.392
     2.100    61.878
     2.200    64.364
     2.300    66.850
     2.400    69.336
     2.500    71.821
     2.600    74.307
     2.700    76.793
     2.800    79.279
     2.900    81.765
     3.000    84.251
     3.100    86.737
     3.200    89.223
     3.300    91.709
     3.400    94.194
     3.500    96.680
     3.600    99.166
     3.700   101.652
     3.800   104.138
     3.900   106.624
     4.000   109.109
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.765
     0.200     7.442
     0.300    11.138
     0.400    14.455
     0.500    17.771
     0.600    21.088
     0.700    24.405
     0.800    27.223
     0.900    29.996
     1.000    32.769
     1.100    35.542
     1.200    38.316
     1.300    41.089
     1.400    43.862
     1.500    46.635
     1.600    49.408
     1.700    52.181
     1.800    54.955
     1.900    57.728
     2.000    60.501
     2.100    63.274
     2.200    66.047
     2.300    68.821
     2.400    71.593
     2.500    74.366
     2.600    77.139
     2.700    79.912
     2.800    82.684
     2.900    85.457
     3.000    88.229
     3.100    91.003
     3.200    93.775
     3.300    96.548
     3.400    99.320
     3.500   102.092
     3.600   104.864
     3.700   107.636
     3.800   110.408
     3.900   113.180
     4.000   115.952
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    13.743
     0.800    15.161
     0.900    16.580
     1.000    17.998
     1.100    19.416
     1.200    20.834
     1.300    22.253
     1.400    23.671
     1.500    25.089
     1.600    26.507
     1.700    27.926
     1.800    29.344
     1.900    30.762
     2.000    32.180
     2.100    33.599
     2.200    35.017
     2.300    36.435
     2.400    37.854
     2.500    39.272
     2.600    40.690
     2.700    42.108
     2.800    43.527
     2.900    44.945
     3.000    46.363
     3.100    47.781
     3.200    49.200
     3.300    50.618
     3.400    52.036
     3.500    53.454
     3.600    54.873
     3.700    56.290
     3.800    57.708
     3.900    59.126
     4.000    60.544
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     4.001
     0.200     5.135
     0.300     6.566
     0.400     8.105
     0.500     9.681
     0.600    11.271
     0.700    12.867
     0.800    14.468
     0.900    16.070
     1.000    17.673
     1.100    19.277
     1.200    20.881
     1.300    22.486
     1.400    24.092
     1.500    25.697
     1.600    27.303
     1.700    28.909
     1.800    30.515
     1.900    32.121
     2.000    33.727
     2.100    35.333
     2.200    36.939
     2.300    38.546
     2.400    40.152
     2.500    41.758
     2.600    43.364
     2.700    44.971
     2.800    46.577
     2.900    48.183
     3.000    49.789
     3.100    51.396
     3.200    53.002
     3.300    54.608
     3.400    56.214
     3.500    57.821
     3.600    59.427
     3.700    61.033
     3.800    62.639
     3.900    64.245
     4.000    65.850
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    23.729
     0.800    26.215
     0.900    28.700
     1.000    31.186
     1.100    33.672
     1.200    36.158
     1.300    38.644
     1.400    41.130
     1.500    43.616
     1.600    46.102
     1.700    48.588
     1.800    51.074
     1.900    53.560
     2.000    56.045
     2.100    58.531
     2.200    61.017
     2.300    63.503
     2.400    65.989
     2.500    68.475
     2.600    70.961
     2.700    73.447
     2.800    75.933
     2.900    78.419
     3.000    80.905
     3.100    83.391
     3.200    85.876
     3.300    88.362
     3.400    90.848
     3.500    93.334
     3.600    95.820
     3.700    98.305
     3.800   100.791
     3.900   103.276
     4.000   105.761
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     6.884
     0.200     8.851
     0.300    11.333
     0.400    13.995
     0.500    16.718
     0.600    19.462
     0.700    22.217
     0.800    24.978
     0.900    27.742
     1.000    30.507
     1.100    33.275
     1.200    36.043
     1.300    38.811
     1.400    41.580
     1.500    44.350
     1.600    47.120
     1.700    49.890
     1.800    52.661
     1.900    55.431
     2.000    58.201
     2.100    60.972
     2.200    63.743
     2.300    66.514
     2.400    69.284
     2.500    72.055
     2.600    74.826
     2.700    77.597
     2.800    80.368
     2.900    83.139
     3.000    85.909
     3.100    88.680
     3.200    91.451
     3.300    94.222
     3.400    96.993
     3.500    99.763
     3.600   102.534
     3.700   105.304
     3.800   108.074
     3.900   110.845
     4.000   113.615
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
     0.981   518.051     0.150
     0.998   517.992     0.150
     1.025   518.262     0.150
     1.088   519.451     0.150
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.947    17.677     0.200
     1.114    20.251     0.200
     1.128    20.403     0.200
     1.200    21.116     0.200
     1.384    23.860     0.200
     1.418    24.421     0.200
     1.592    26.753     0.200
     1.690    28.284     0.200
     1.715    28.835     0.200
     1.869    29.778     0.200
     1.862    30.287     0.200
     1.955    31.799     0.200
     1.969    31.783     0.200
     1.984    31.942     0.200
     2.051    33.181     0.200
     2.177    35.686     0.200
     2.180    35.276     0.200
     2.202    35.177     0.200
     2.238    36.360     0.200
     2.269    36.169     0.200
     2.374    38.161     0.200
     2.522    39.811     0.200
     2.560    39.924     0.200
     2.633    40.274     0.200
     2.607    40.983     0.200
     2.679    41.595     0.200
     2.701    42.861     0.200
     2.741    42.775     0.200
     2.771    42.796     0.200
     2.841    44.519     0.200
     2.881    45.195     0.200
     3.175    49.350     0.200
     3.270    49.871     0.200
     3.377    50.584     0.200
     3.611    54.911     0.200
     3.840    56.644     0.200
     3.816    57.849     0.200
     3.920    59.828     0.200
     4.104    62.350     0.200
     4.141    63.259     0.200
     4.156    63.488     0.200
     4.266    66.028     0.200
     4.296    64.536     0.200
     4.393    66.104     0.200
     4.411    67.828     0.200
     4.445    67.938     0.200
     4.466    68.265     0.200
     4.587    68.288     0.200
     4.582    68.808     0.200
     4.873    73.258     0.200
     5.035    76.138     0.200
     5.345    79.793     0.200
     5.402    81.160     0.200
     5.550    82.729     0.200
     5.550    83.042     0.200
     5.725    84.418     0.200
     5.816    87.194     0.200
     6.802    99.498     0.200
     6.967   101.098     0.200
     6.993   102.769     0.200
     7.042   101.798     0.200
     7.090   103.038     0.200
     7.587   111.868     0.200
     8.044   116.818     0.200
     8.931   128.388     0.200
     9.228   131.998     0.200
     9.482   134.408     0.200
     9.911   143.008     0.200
    10.377   149.658     0.200
    10.377   152.988     0.200
    11.448   163.408     0.200
    11.448   163.663     0.200
    12.535   181.308     0.200
     0.990    18.492     0.200
     1.209    21.236     0.200
     1.198    21.984     0.200
     1.233    22.043     0.200
     1.248    22.254     0.200
     1.261    22.861     0.200
     1.509    26.635     0.200
     1.513    26.307     0.200
     1.591    26.844     0.200
     1.577    28.625     0.200
     1.581    27.268     0.200
     1.745    28.982     0.200
     1.768    29.320     0.200
     1.790    30.023     0.200
     1.904    31.154     0.200
     1.980    31.945     0.200
     2.066    33.967     0.200
     2.098    34.066     0.200
     2.164    35.547     0.200
     2.277    36.617     0.200
     2.319    35.961     0.200
     2.425    38.613     0.200
     2.504    40.039     0.200
     2.547    40.701     0.200
     2.636    41.588     0.200
     2.664    41.551     0.200
     2.694    42.572     0.200
     2.768    42.803     0.200
     2.814    44.195     0.200
     2.853    44.459     0.200
     2.906    45.697     0.200
     2.900    45.691     0.200
     3.074    48.027     0.200
     3.074    49.105     0.200
     3.078    47.924     0.200
     3.102    48.434     0.200
     3.152    49.143     0.200
     3.222    49.502     0.200
     3.261    51.242     0.200
     3.348    51.273     0.200
     3.429    52.055     0.200
     3.460    54.561     0.200
     3.506    55.139     0.200
     3.530    53.547     0.200
     3.552    55.512     0.200
     3.630    56.539     0.200
     3.662    57.051     0.200
     3.747    58.904     0.200
     3.846    59.328     0.200
     3.934    59.928     0.200
     3.935    61.113     0.200
     3.993    59.609     0.200
     3.990    60.930     0.200
     3.972    62.225     0.200
     4.023    60.094     0.200
     4.051    62.330     0.200
     4.058    63.119     0.200
     4.080    63.047     0.200
     4.100    63.025     0.200
     4.121    62.092     0.200
     4.167    63.697     0.200
     4.225    64.223     0.200
     4.240    64.711     0.200
     4.278    66.654     0.200
     4.279    66.314     0.200
     4.308    65.000     0.200
     4.308    66.885     0.200
     4.342    66.895     0.200
     4.406    65.273     0.200
     4.430    67.920     0.200
     4.418    67.658     0.200
     4.469    66.836     0.200
     4.499    68.766     0.200
     4.501    67.189     0.200
     4.511    69.254     0.200
     4.655    69.654     0.200
     4.696    71.117     0.200
     4.745    72.666     0.200
     4.762    70.234     0.200
     4.809    70.525     0.200
     4.820    71.443     0.200
     4.829    72.809     0.200
     4.857    77.117     0.200
     4.919    75.736     0.200
     4.939    75.154     0.200
     4.995    73.639     0.200
     5.050    74.445     0.200
     5.139    76.479     0.200
     5.216    77.232     0.200
     5.227    78.686     0.200
     5.367    78.938     0.200
     5.364    81.924     0.200
     5.480    80.787     0.200
     5.664    85.824     0.200
     5.775    84.598     0.200
     5.744    86.572     0.200
     5.782    87.859     0.200
     5.883    86.881     0.200
     6.349    92.930     0.200
     6.493    96.584     0.200
     6.601    98.254     0.200
     6.745   101.965     0.200
     6.749    99.355     0.200
     6.872   101.664     0.200
     6.917   105.375     0.200
     6.911   104.205     0.200
     6.950   103.594     0.200
     7.113   106.744     0.200
     7.339   108.305     0.200
     7.510   111.484     0.200
     7.538   113.455     0.200
     7.633   113.684     0.200
     7.959   116.795     0.200
     8.002   115.775     0.200
     8.129   119.684     0.200
     8.350   121.295     0.200
     8.553   129.135     0.200
     9.124   132.885     0.200
     9.367   134.924     0.200
     9.516   140.465     0.200
     9.780   142.004     0.200
    10.080   146.885     0.200
    10.301   150.814     0.200
    10.664   158.605     0.200
    10.819   159.344     0.200
    11.605   166.695     0.200
    14.883   213.404     0.200
    20.956   284.605     0.200
     0.887    16.605     0.200
     1.327    23.970     0.200
     1.351    23.877     0.200
     1.478    26.811     0.200
     1.521    27.300     0.200
     1.700    28.256     0.200
     1.727    28.643     0.200
     1.741    29.252     0.200
     1.961    31.114     0.200
     1.994    31.962     0.200
     2.268    36.740     0.200
     2.320    37.090     0.200
     2.384    38.148     0.200
     2.624    40.735     0.200
     2.681    42.061     0.200
     2.768    43.706     0.200
     2.793    43.610     0.200
     2.967    46.007     0.200
     2.979    45.135     0.200
     3.226    49.170     0.200
     3.165    49.060     0.200
     3.227    50.858     0.200
     3.238    51.085     0.200
     3.252    49.860     0.200
     3.232    50.151     0.200
     3.306    51.315     0.200
     3.467    53.338     0.200
     3.508    54.873     0.200
     3.710    56.003     0.200
     3.719    57.419     0.200
     3.830    58.951     0.200
     3.830    59.180     0.200
     3.906    59.375     0.200
     4.063    61.694     0.200
     4.062    62.339     0.200
     4.403    65.535     0.200
     4.513    67.126     0.200
     4.520    67.120     0.200
     4.561    69.820     0.200
     5.040    76.580     0.200
     6.043    89.150     0.200
     6.243    96.260     0.200
     7.420   109.311     0.200
     7.756   114.790     0.200
     7.892   114.641     0.200
    10.915   160.860     0.200
    11.259   163.210     0.200
     0.838    15.791     0.200
     1.304    22.608     0.200
     1.275    23.094     0.200
     1.386    24.467     0.200
     1.492    25.647     0.200
     1.496    26.578     0.200
     1.542    27.663     0.200
     1.556    27.321     0.200
     1.643    27.027     0.200
     1.611    28.603     0.200
     1.637    27.764     0.200
     1.820    29.829     0.200
     1.757    29.938     0.200
     1.811    30.631     0.200
     1.875    31.818     0.200
     1.917    32.385     0.200
     2.018    33.286     0.200
     2.035    33.568     0.200
     2.109    33.919     0.200
     2.225    35.173     0.200
     2.214    36.067     0.200
     2.214    36.953     0.200
     2.271    36.847     0.200
     2.271    37.033     0.200
     2.268    36.926     0.200
     2.357    36.413     0.200
     2.358    36.721     0.200
     2.465    39.222     0.200
     2.454    39.510     0.200
     2.534    40.807     0.200
     2.574    41.104     0.200
     2.574    41.522     0.200
     2.583    41.595     0.200
     2.635    41.824     0.200
     2.695    42.736     0.200
     2.742    43.734     0.200
     2.769    43.448     0.200
     2.769    44.103     0.200
     2.921    44.746     0.200
     2.939    44.922     0.200
     2.970    46.412     0.200
     3.079    46.877     0.200
     3.136    48.742     0.200
     3.100    48.574     0.200
     3.133    49.245     0.200
     3.235    50.993     0.200
     3.303    51.343     0.200
     3.272    51.167     0.200
     3.414    51.933     0.200
     3.372    52.295     0.200
     3.476    53.033     0.200
     3.470    53.954     0.200
     3.526    54.662     0.200
     3.628    54.934     0.200
     3.602    55.390     0.200
     3.659    56.101     0.200
     3.621    55.192     0.200
     3.659    55.693     0.200
     3.876    59.682     0.200
     4.006    61.521     0.200
     4.090    61.244     0.200
     4.133    63.401     0.200
     4.176    62.989     0.200
     4.210    62.446     0.200
     4.253    64.901     0.200
     4.282    64.982     0.200
     4.357    67.006     0.200
     4.399    66.970     0.200
     4.453    67.876     0.200
     4.471    69.204     0.200
     4.536    69.109     0.200
     4.544    69.162     0.200
     4.639    70.548     0.200
     4.693    69.694     0.200
     4.680    72.128     0.200
     4.680    71.783     0.200
     4.813    73.543     0.200
     4.883    72.128     0.200
     4.906    72.033     0.200
     4.836    74.225     0.200
     4.882    74.342     0.200
     4.945    75.145     0.200
     4.983    75.383     0.200
     5.043    76.262     0.200
     5.072    76.676     0.200
     5.100    77.226     0.200
     5.144    78.321     0.200
     5.155    78.351     0.200
     5.140    78.311     0.200
     5.195    79.183     0.200
     5.262    78.863     0.200
     5.370    79.793     0.200
     5.391    79.453     0.200
     5.508    81.001     0.200
     5.514    81.509     0.200
     5.584    81.812     0.200
     5.597    82.583     0.200
     5.821    85.618     0.200
     6.020    88.781     0.200
     6.026    89.716     0.200
     6.042    89.064     0.200
     6.038    89.470     0.200
     6.100    91.079     0.200
     6.133    91.513     0.200
     6.702    97.646     0.200
     7.343   107.562     0.200
     7.411   107.623     0.200
     9.508   136.743     0.200
     9.552   138.503     0.200
    10.773   159.719     0.200
    11.671   168.008     0.200
     0.861    16.062     0.200
     0.837    15.930     0.200
     1.491    25.805     0.200
     1.640    27.062     0.200
     1.545    27.312     0.200
     1.559    27.469     0.200
     1.614    28.672     0.200
     1.641    27.930     0.200
     1.761    31.539     0.200
     1.815    30.883     0.200
     1.974    33.023     0.200
     2.015    33.352     0.200
     2.035    33.531     0.200
     2.221    35.289     0.200
     2.217    36.312     0.200
     2.354    36.836     0.200
     2.354    36.930     0.200
     2.270    37.039     0.200
     2.274    36.891     0.200
     2.462    39.242     0.200
     2.454    39.547     0.200
     2.533    40.797     0.200
     2.633    41.891     0.200
     2.578    41.203     0.200
     2.692    42.703     0.200
     2.744    43.664     0.200
     2.708    43.008     0.200
     2.771    43.961     0.200
     2.771    44.312     0.200
     2.917    45.281     0.200
     2.935    45.266     0.200
     2.970    46.922     0.200
     3.076    47.133     0.200
     3.133    48.984     0.200
     3.099    49.133     0.200
     3.149    49.500     0.200
     3.136    49.930     0.200
     3.300    51.711     0.200
     3.371    52.508     0.200
     3.410    52.359     0.200
     3.472    53.305     0.200
     3.523    54.406     0.200
     3.625    55.102     0.200
     3.601    55.797     0.200
     3.655    56.203     0.200
     3.622    56.648     0.200
     3.873    59.891     0.200
     4.004    61.711     0.200
     4.131    63.297     0.200
     4.172    63.086     0.200
     4.206    62.688     0.200
     4.251    65.375     0.200
     4.279    65.000     0.200
     4.396    66.922     0.200
     4.356    67.016     0.200
     4.471    68.516     0.200
     4.533    69.094     0.200
     4.542    69.430     0.200
     4.638    70.664     0.200
     4.677    71.102     0.200
     4.677    71.883     0.200
     4.690    69.781     0.200
     4.781    72.023     0.200
     4.811    72.727     0.200
     4.902    72.602     0.200
     4.880    74.109     0.200
     5.007    74.680     0.200
     4.981    74.891     0.200
     5.152    77.727     0.200
     5.139    78.156     0.200
     5.367    79.750     0.200
     5.504    81.031     0.200
     5.596    83.023     0.200
     5.586    84.539     0.200
     5.818    85.609     0.200
     6.016    88.953     0.200
     6.023    89.336     0.200
     6.039    89.055     0.200
     6.099    90.852     0.200
     6.131    93.984     0.200
     7.342   108.406     0.200
     7.508   108.266     0.200
     1.059    19.512     0.200
     1.373    24.906     0.200
     1.433    24.777     0.200
     1.394    24.766     0.200
     1.503    25.766     0.200
     1.574    26.309     0.200
     1.623    27.617     0.200
     1.662    29.027     0.200
     1.766    28.648     0.200
     1.766    28.980     0.200
     1.795    30.688     0.200
     1.899    31.953     0.200
     1.899    32.441     0.200
     1.929    31.371     0.200
     1.969    31.512     0.200
     2.084    34.754     0.200
     2.079    34.387     0.200
     2.140    35.281     0.200
     2.250    35.828     0.200
     2.295    37.938     0.200
     2.359    37.461     0.200
     2.402    37.980     0.200
     2.439    39.617     0.200
     2.545    40.375     0.200
     2.530    40.945     0.200
     2.600    41.832     0.200
     2.701    41.746     0.200
     2.703    41.496     0.200
     2.807    44.852     0.200
     2.936    45.965     0.200
     2.964    47.000     0.200
     2.957    46.895     0.200
     3.095    49.316     0.200
     3.156    49.371     0.200
     3.247    49.680     0.200
     3.281    49.664     0.200
     3.425    51.777     0.200
     3.509    55.059     0.200
     3.749    56.020     0.200
     3.804    57.465     0.200
     3.944    58.863     0.200
     4.084    63.781     0.200
     4.436    65.844     0.200
     4.507    67.457     0.200
     4.505    68.453     0.200
     4.551    67.203     0.200
     4.599    69.137     0.200
     4.692    70.855     0.200
     4.796    70.828     0.200
     4.756    72.137     0.200
     4.967    74.391     0.200
     4.946    75.023     0.200
     4.946    75.539     0.200
     4.959    75.410     0.200
     4.959    75.559     0.200
     5.028    73.895     0.200
     5.052    77.523     0.200
     5.106    76.531     0.200
     5.104    77.430     0.200
     5.228    76.762     0.200
     5.251    77.191     0.200
     5.226    79.613     0.200
     5.330    79.688     0.200
     5.351    79.082     0.200
     5.351    80.871     0.200
     5.386    80.102     0.200
     5.403    81.582     0.200
     5.437    82.051     0.200
     5.593    84.188     0.200
     5.705    84.195     0.200
     5.833    86.684     0.200
     5.853    85.875     0.200
     5.945    87.668     0.200
     5.952    89.402     0.200
     6.011    90.336     0.200
     6.061    90.938     0.200
     6.116    90.723     0.200
     6.126    91.355     0.200
     6.163    90.355     0.200
     6.194    92.770     0.200
     6.238    96.051     0.200
     6.278    95.270     0.200
     6.360    93.406     0.200
     6.358    94.074     0.200
     6.362    93.781     0.200
     6.386    93.520     0.200
     6.393    95.191     0.200
     6.435    96.109     0.200
     6.581    96.168     0.200
     6.767   100.641     0.200
     6.800   100.832     0.200
     6.908   102.668     0.200
     6.937   101.500     0.200
     6.921   103.352     0.200
     6.983   103.828     0.200
     6.996   104.176     0.200
     7.024   103.410     0.200
     7.086   104.273     0.200
     7.108   104.629     0.200
     7.207   104.566     0.200
     7.372   108.242     0.200
     7.426   111.480     0.200
     7.462   109.895     0.200
     7.583   112.305     0.200
     7.601   111.938     0.200
     7.582   114.121     0.200
     7.672   112.395     0.200
     7.688   111.871     0.200
     7.691   112.098     0.200
     7.733   113.441     0.200
     7.771   115.309     0.200
     8.090   119.020     0.200
     8.156   120.082     0.200
     8.168   119.648     0.200
     8.260   119.809     0.200
     8.286   120.152     0.200
     8.325   122.695     0.200
     8.543   123.980     0.200
     8.739   126.414     0.200
     8.739   127.441     0.200
     8.897   128.785     0.200
     9.017   130.438     0.200
     9.116   133.012     0.200
     9.531   137.523     0.200
     9.616   138.262     0.200
     9.781   142.801     0.200
    10.887   158.789     0.200
    12.014   172.113     0.200
     1.058    19.598     0.200
     1.206    21.660     0.200
     1.224    22.000     0.200
     1.294    22.477     0.200
     1.283    22.672     0.200
     1.377    24.812     0.200
     1.431    25.133     0.200
     1.400    24.898     0.200
     1.580    26.445     0.200
     1.629    27.695     0.200
     1.664    29.109     0.200
     1.769    28.723     0.200
     1.769    28.441     0.200
     1.800    30.707     0.200
     1.899    31.664     0.200
     1.899    31.992     0.200
     1.926    31.645     0.200
     1.975    31.621     0.200
     2.087    34.660     0.200
     2.085    34.422     0.200
     2.147    35.301     0.200
     2.295    37.523     0.200
     2.356    37.543     0.200
     2.445    39.473     0.200
     2.532    40.879     0.200
     2.532    40.773     0.200
     2.604    41.926     0.200
     2.705    42.758     0.200
     2.707    41.676     0.200
     2.805    44.863     0.200
     2.942    46.059     0.200
     3.098    48.973     0.200
     3.155    49.602     0.200
     3.252    49.945     0.200
     3.285    50.027     0.200
     3.428    51.859     0.200
     3.809    57.633     0.200
     3.978    60.102     0.200
     4.512    67.617     0.200
     4.511    68.438     0.200
     4.605    69.188     0.200
     4.762    72.207     0.200
     4.951    75.332     0.200
     4.953    75.480     0.200
     4.965    75.219     0.200
     4.965    75.062     0.200
     5.111    77.160     0.200
     5.232    79.477     0.200
     5.443    82.160     0.200
     5.600    84.340     0.200
     5.839    86.875     0.200
     5.958    89.598     0.200
     6.018    90.641     0.200
     6.068    91.027     0.200
     6.122    91.922     0.200
     6.200    92.723     0.200
     6.365    93.551     0.200
     6.363    94.203     0.200
     6.399    95.230     0.200
     6.441    96.281     0.200
     6.773   100.738     0.200
     6.806   101.105     0.200
     7.091   104.031     0.200
     7.677   112.586     0.200
     1.218    21.051     0.200
     1.270    22.258     0.200
     1.239    21.367     0.200
     1.401    23.656     0.200
     1.403    23.527     0.200
     1.350    23.418     0.200
     1.457    24.703     0.200
     1.576    26.168     0.200
     1.656    27.059     0.200
     1.756    27.430     0.200
     1.718    28.215     0.200
     1.781    29.996     0.200
     1.812    27.777     0.200
     1.827    31.316     0.200
     1.832    30.305     0.200
     1.860    30.633     0.200
     1.941    32.156     0.200
     2.110    33.848     0.200
     2.121    34.207     0.200
     2.160    34.281     0.200
     2.156    34.617     0.200
     2.156    34.281     0.200
     2.197    36.637     0.200
     2.232    35.109     0.200
     2.348    36.160     0.200
     2.349    37.961     0.200
     2.370    37.090     0.200
     2.423    37.918     0.200
     2.785    43.766     0.200
     2.785    42.879     0.200
     2.872    44.238     0.200
     3.079    47.289     0.200
     3.121    47.762     0.200
     3.240    49.676     0.200
     3.240    49.254     0.200
     3.312    50.957     0.200
     3.495    52.285     0.200
     3.714    56.781     0.200
     3.746    56.824     0.200
     3.723    57.035     0.200
     3.894    59.504     0.200
     4.035    61.094     0.200
     4.202    64.043     0.200
     4.226    65.719     0.200
     4.226    63.656     0.200
     4.302    62.977     0.200
     4.630    72.246     0.200
     4.644    70.867     0.200
     4.834    74.547     0.200
     5.456    83.906     0.200
     5.498    82.309     0.200
     5.809    84.633     0.200
     5.931    88.855     0.200
     6.003    87.742     0.200
     6.034    87.836     0.200
     6.025    89.098     0.200
     6.149    89.777     0.200
     6.179    90.184     0.200
     6.257    90.891     0.200
     6.268    91.340     0.200
     6.426    93.926     0.200
     6.743    98.117     0.200
     6.768    98.648     0.200
     6.849    99.699     0.200
     6.995   101.535     0.200
     7.084   103.566     0.200
     7.152   104.137     0.200
     7.189   108.016     0.200
     7.243   107.957     0.200
     7.249   104.566     0.200
     7.352   106.922     0.200
     7.357   106.977     0.200
     7.358   108.605     0.200
     7.416   110.707     0.200
     7.450   109.668     0.200
     7.512   108.438     0.200
     7.555   110.547     0.200
     7.643   111.398     0.200
     7.652   111.719     0.200
     7.872   115.332     0.200
     7.872   114.426     0.200
     7.935   117.328     0.200
     8.035   117.809     0.200
     8.109   117.188     0.200
     8.670   124.277     0.200
     8.762   125.387     0.200
     8.884   127.496     0.200
     8.905   127.809     0.200
     8.905   127.516     0.200
     9.180   132.469     0.200
     9.286   133.793     0.200
     9.325   133.844     0.200
     9.654   139.559     0.200
     9.965   144.266     0.200
    10.049   143.637     0.200
    10.074   147.047     0.200
    10.109   145.797     0.200
    10.274   148.586     0.200
    10.397   149.746     0.200
    10.591   154.535     0.200
    10.610   157.008     0.200
    10.730   154.469     0.200
    10.810   154.898     0.200
    10.821   160.277     0.200
    10.857   155.387     0.200
    11.070   158.980     0.200
    11.203   164.918     0.200
    11.439   168.105     0.200
    11.767   167.309     0.200
    11.967   171.266     0.200
    12.034   172.328     0.200
    13.558   192.598     0.200
    13.705   194.488     0.200
    13.843   196.848     0.200
    14.006   199.078     0.200
    14.230   202.605     0.200
    14.448   204.195     0.200
    14.529   206.176     0.200
    14.959   210.047     0.200
    15.363   216.008     0.200
    15.778   223.047     0.200
    18.439   256.059     0.200
     1.213    21.336     0.200
     1.250    22.278     0.200
     1.252    21.925     0.200
     1.375    23.822     0.200
     1.742    27.648     0.200
     1.758    30.179     0.200
     1.787    28.358     0.200
     1.911    32.799     0.200
     1.852    30.592     0.200
     2.139    35.799     0.200
     2.186    37.299     0.200
     2.257    36.429     0.200
     2.215    36.688     0.200
     2.343    36.547     0.200
     2.373    37.072     0.200
     2.367    38.717     0.200
     2.447    38.452     0.200
     2.811    42.452     0.200
     3.108    47.874     0.200
     3.265    51.879     0.200
     3.341    52.869     0.200
     3.490    54.389     0.200
     3.750    57.252     0.200
     4.237    65.209     0.200
     4.290    65.358     0.200
     4.668    72.429     0.200
     4.859    75.809     0.200
     5.933    88.948     0.200
     5.955    90.729     0.200
     7.096   104.789     0.200
     7.173   109.129     0.200
     7.528   110.198     0.200
     7.571   110.119     0.200
     7.642   110.979     0.200
     7.874   114.528     0.200
     8.895   128.839     0.200
     9.196   135.139     0.200
     9.646   139.698     0.200
    10.634   157.379     0.200
    11.056   159.754     0.200
     1.376    24.789     0.200
     1.413    24.480     0.200
     1.421    25.734     0.200
     1.515    27.328     0.200
     1.586    24.977     0.200
     1.619    28.512     0.200
     1.679    27.902     0.200
     1.666    28.898     0.200
     1.725    30.250     0.200
     2.077    34.910     0.200
     2.138    35.738     0.200
     2.342    40.098     0.200
     2.341    38.750     0.200
     2.942    47.867     0.200
     4.764    73.539     0.200
     4.979    74.348     0.200
     5.153    78.508     0.200
    14.729   210.000     0.200
     0.905    17.200     0.200
     0.985    18.029     0.200
     0.975    18.408     0.200
     1.089    19.375     0.200
     1.066    19.889     0.200
     1.154    21.038     0.200
     1.169    21.841     0.200
     1.204    22.422     0.200
     1.264    21.976     0.200
     1.304    23.059     0.200
     1.268    23.789     0.200
     1.324    23.316     0.200
     1.332    24.459     0.200
     1.367    24.181     0.200
     1.478    25.443     0.200
     1.488    25.016     0.200
     1.630    28.728     0.200
     1.623    28.929     0.200
     1.678    28.733     0.200
     1.678    28.951     0.200
     1.784    30.291     0.200
     1.861    30.839     0.200
     1.977    31.769     0.200
     1.977    31.585     0.200
     1.951    33.391     0.200
     2.009    32.251     0.200
     1.997    33.575     0.200
     2.116    35.379     0.200
     2.253    36.669     0.200
     2.359    39.147     0.200
     2.558    42.165     0.200
     2.576    41.969     0.200
     2.749    43.163     0.200
     2.912    46.629     0.200
     3.022    48.561     0.200
     3.040    49.118     0.200
     3.257    49.944     0.200
     3.998    60.068     0.200
     4.103    64.049     0.200
     4.516    68.865     0.200
     4.501    68.889     0.200
     4.501    69.130     0.200
     4.566    68.739     0.200
     4.562    70.429     0.200
     4.598    70.658     0.200
     4.588    71.169     0.200
     4.629    70.039     0.200
     4.744    72.459     0.200
     4.823    73.089     0.200
     4.823    73.498     0.200
     4.932    75.148     0.200
     4.959    76.938     0.200
     5.409    79.079     0.200
     5.802    86.653     0.200
     5.912    88.959     0.200
     6.041    90.629     0.200
     6.055    91.959     0.200
     6.373    94.209     0.200
     6.454    95.809     0.200
     6.496    98.259     0.200
     7.025   104.488     0.200
     7.027   103.198     0.200
     7.122   104.769     0.200
     7.268   106.049     0.200
     7.586   109.079     0.200
     7.601   112.889     0.200
     7.788   113.789     0.200
     7.841   114.729     0.200
     7.938   117.238     0.200
     8.119   118.188     0.200
     8.339   122.386     0.200
     8.448   124.677     0.200
     8.454   122.851     0.200
     8.546   125.698     0.200
     8.699   127.629     0.200
     8.699   128.023     0.200
     9.658   140.704     0.200
     9.680   140.974     0.200
     9.775   144.509     0.200
     9.971   143.599     0.200
    10.509   153.999     0.200
    12.202   175.879     0.200
    14.281   205.929     0.200
     1.121    20.899     0.200
     1.349    24.330     0.200
     1.542    25.972     0.200
     1.479    26.239     0.200
     1.646    29.487     0.200
     1.713    27.979     0.200
     1.768    29.821     0.200
     1.879    31.013     0.200
     1.872    32.659     0.200
     1.922    33.140     0.200
     2.196    34.556     0.200
     2.266    36.282     0.200
     2.331    38.649     0.200
     2.889    44.318     0.200
     3.175    47.762     0.200
     3.184    51.250     0.200
     3.640    56.540     0.200
     4.754    70.109     0.200
     4.837    73.520     0.200
     5.117    75.939     0.200
     5.165    78.470     0.200
     5.345    81.909     0.200
     5.380    82.100     0.200
     5.648    82.425     0.200
     5.894    87.989     0.200
     6.004    90.149     0.200
     6.039    90.580     0.200
     7.240   105.659     0.200
     7.694   113.010     0.200
     7.787   114.449     0.200
     8.111   119.449     0.200
     8.159   120.689     0.200
     8.455   123.125     0.200
    11.134   164.500     0.200
     1.282    23.121     0.200
     1.343    24.180     0.200
     1.354    24.691     0.200
     1.473    26.410     0.200
     1.544    25.906     0.200
     1.652    28.980     0.200
     1.773    29.574     0.200
     1.773    29.832     0.200
     1.878    32.539     0.200
     1.928    32.531     0.200
     2.082    36.172     0.200
     2.075    35.703     0.200
     2.192    34.574     0.200
     2.337    37.969     0.200
     2.886    44.152     0.200
     3.170    47.672     0.200
     3.190    50.109     0.200
     3.644    56.609     0.200
     4.750    69.992     0.200
     4.837    73.410     0.200
     5.169    77.801     0.200
     5.654    86.422     0.200
     5.893    86.789     0.200
     6.010    89.160     0.200
     6.045    89.520     0.200
     7.236   105.699     0.200
     7.460   110.281     0.200
     7.695   113.262     0.200
     7.721   113.480     0.200
     7.793   114.590     0.200
     8.112   118.789     0.200
     8.161   119.379     0.200
     8.453   121.367     0.200
     9.376   134.762     0.200
    11.465   165.266     0.200
    14.825   211.812     0.200
     0.962    18.296     0.200
     1.098    19.904     0.200
     1.305    22.545     0.200
     1.333    24.121     0.200
     1.422    26.474     0.200
     1.433    25.096     0.200
     1.522    26.043     0.200
     1.553    27.151     0.200
     1.599    27.413     0.200
     1.620    26.627     0.200
     1.671    27.842     0.200
     1.811    31.412     0.200
     1.833    30.892     0.200
     1.930    32.359     0.200
     1.977    33.020     0.200
     2.026    32.926     0.200
     2.077    34.058     0.200
     2.100    33.781     0.200
     2.270    37.218     0.200
     2.319    37.100     0.200
     2.328    37.829     0.200
     2.478    41.644     0.200
     2.502    40.348     0.200
     2.642    42.093     0.200
     2.749    42.942     0.200
     2.800    44.273     0.200
     2.829    44.617     0.200
     2.829    45.034     0.200
     3.034    47.974     0.200
     3.087    48.183     0.200
     3.187    51.044     0.200
     3.271    51.394     0.200
     3.285    51.848     0.200
     3.362    50.329     0.200
     3.362    50.624     0.200
     4.674    71.804     0.200
     4.716    71.704     0.200
     4.838    73.943     0.200
     4.862    71.244     0.200
     4.990    75.364     0.200
     5.252    80.199     0.200
     5.644    84.344     0.200
     5.656    84.233     0.200
     5.794    86.404     0.200
     6.133    92.063     0.200
     6.156    92.294     0.200
     7.053   103.193     0.200
     7.234   106.684     0.200
     7.306   106.084     0.200
     7.376   109.374     0.200
     7.397   109.824     0.200
     7.397   109.164     0.200
     7.418   108.874     0.200
     7.428   111.934     0.200
     7.509   111.284     0.200
     7.642   110.824     0.200
     7.875   116.284     0.200
     7.939   117.454     0.200
     7.988   116.914     0.200
     8.191   118.864     0.200
     8.182   119.523     0.200
     8.216   120.604     0.200
     8.398   122.424     0.200
     8.398   121.824     0.200
     8.680   129.414     0.200
     8.854   128.264     0.200
     9.057   134.313     0.200
     9.392   138.634     0.200
     9.558   139.813     0.200
     9.703   144.878     0.200
     9.893   144.714     0.200
    10.016   147.714     0.200
    10.248   149.654     0.200
    10.273   149.594     0.200
    10.778   158.233     0.200
    10.801   158.594     0.200
    10.801   159.224     0.200
    10.865   157.054     0.200
    11.168   164.494     0.200
    11.247   164.844     0.200
    11.323   166.334     0.200
    11.384   164.313     0.200
    11.624   166.599     0.200
    12.084   173.594     0.200
    12.780   184.644     0.200
    13.422   190.443     0.200
    14.218   201.824     0.200
    14.406   203.494     0.200
    14.405   203.794     0.200
    14.494   206.504     0.200
    14.567   207.744     0.200
    14.683   207.644     0.200
    15.078   213.324     0.200
    15.383   218.834     0.200
    15.518   220.494     0.200
    15.784   220.693     0.200
    17.155   238.924     0.200
    17.853   248.034     0.200
    18.977   262.224     0.200
    19.940   274.754     0.200
     1.265    22.719     0.200
     1.265    22.883     0.200
     1.269    22.984     0.200
     1.298    23.477     0.200
     1.330    23.875     0.200
     1.343    23.922     0.200
     1.406    25.750     0.200
     1.410    24.516     0.200
     1.410    24.953     0.200
     1.440    25.320     0.200
     1.491    26.367     0.200
     1.508    26.000     0.200
     1.529    25.953     0.200
     1.529    26.805     0.200
     1.526    26.273     0.200
     1.525    26.711     0.200
     1.525    26.547     0.200
     1.561    26.445     0.200
     1.526    25.852     0.200
     1.526    26.562     0.200
     1.593    28.336     0.200
     1.604    27.891     0.200
     1.605    26.672     0.200
     1.625    28.172     0.200
     1.609    28.055     0.200
     1.679    28.703     0.200
     1.683    28.977     0.200
     1.740    28.953     0.200
     1.740    29.797     0.200
     1.747    29.742     0.200
     1.775    29.727     0.200
     1.769    31.562     0.200
     1.766    30.102     0.200
     1.892    31.477     0.200
     1.913    31.859     0.200
     1.913    32.234     0.200
     1.926    32.430     0.200
     1.953    30.273     0.200
     2.012    33.242     0.200
     2.056    33.562     0.200
     2.064    33.594     0.200
     2.064    34.266     0.200
     2.126    35.297     0.200
     2.134    35.414     0.200
     2.136    35.406     0.200
     2.199    34.969     0.200
     2.199    36.031     0.200
     2.217    36.516     0.200
     2.247    35.734     0.200
     2.274    36.992     0.200
     2.323    38.016     0.200
     2.456    39.820     0.200
     2.478    39.562     0.200
     2.489    40.727     0.200
     2.525    40.125     0.200
     2.555    41.375     0.200
     2.574    41.219     0.200
     2.574    41.602     0.200
     2.631    42.852     0.200
     2.655    42.570     0.200
     2.672    43.172     0.200
     2.678    41.695     0.200
     2.694    43.117     0.200
     2.754    43.531     0.200
     2.768    44.375     0.200
     2.768    43.648     0.200
     2.779    44.406     0.200
     2.793    44.742     0.200
     2.834    45.484     0.200
     2.861    45.070     0.200
     2.869    45.891     0.200
     2.988    46.977     0.200
     3.053    47.445     0.200
     3.115    48.820     0.200
     3.107    49.297     0.200
     3.178    50.312     0.200
     3.221    50.320     0.200
     3.230    50.844     0.200
     3.266    50.883     0.200
     3.280    51.312     0.200
     3.349    52.742     0.200
     3.434    51.203     0.200
     3.455    53.531     0.200
     3.514    55.133     0.200
     3.524    54.875     0.200
     3.524    54.711     0.200
     3.636    56.188     0.200
     3.657    56.258     0.200
     3.790    60.547     0.200
     3.892    60.375     0.200
     3.892    60.023     0.200
     4.270    65.734     0.200
     4.273    66.172     0.200
     4.680    71.070     0.200
     4.680    71.570     0.200
     4.719    71.383     0.200
     4.848    73.375     0.200
     4.897    74.727     0.200
     4.932    71.977     0.200
     4.932    72.102     0.200
     4.971    74.727     0.200
     5.017    76.672     0.200
     5.111    77.852     0.200
     5.207    78.773     0.200
     5.207    78.820     0.200
     5.470    83.000     0.200
     5.585    83.773     0.200
     5.604    85.977     0.200
     5.733    86.523     0.200
     5.847    86.992     0.200
     5.861    88.586     0.200
     6.145    92.805     0.200
     6.146    91.906     0.200
     6.169    92.273     0.200
     6.367    97.070     0.200
     6.369    95.484     0.200
     6.578    98.586     0.200
     6.765   101.422     0.200
     6.890   103.031     0.200
     6.955   103.875     0.200
     7.007   106.016     0.200
     7.020   104.375     0.200
     7.106   107.195     0.200
     7.099   104.430     0.200
     7.213   109.992     0.200
     7.249   108.555     0.200
     7.376   108.672     0.200
     7.378   108.875     0.200
     7.378   108.977     0.200
     7.423   110.852     0.200
     7.448   111.070     0.200
     7.550   111.773     0.200
     7.598   114.852     0.200
     7.650   114.992     0.200
     7.812   115.477     0.200
     7.828   115.852     0.200
     7.840   114.617     0.200
     7.858   113.812     0.200
     7.906   116.977     0.200
     7.943   117.750     0.200
     7.961   115.906     0.200
     7.973   117.805     0.200
     7.983   117.297     0.200
     8.080   119.852     0.200
     8.140   120.672     0.200
     8.187   122.414     0.200
     8.223   122.867     0.200
     8.252   120.125     0.200
     8.243   122.164     0.200
     8.249   122.211     0.200
     8.265   122.430     0.200
     8.376   123.992     0.200
     8.456   123.273     0.200
     8.456   123.172     0.200
     8.456   122.953     0.200
     8.449   125.086     0.200
     8.458   127.023     0.200
     8.492   126.312     0.200
     8.504   126.070     0.200
     8.592   127.164     0.200
     8.759   129.484     0.200
     8.849   129.773     0.200
     8.871   131.102     0.200
     8.913   132.211     0.200
     8.931   131.906     0.200
     8.944   131.570     0.200
     8.950   132.133     0.200
     8.977   129.242     0.200
     9.058   133.672     0.200
     9.111   134.492     0.200
     9.138   134.727     0.200
     9.169   135.250     0.200
     9.259   136.562     0.200
     9.415   138.383     0.200
     9.484   139.672     0.200
     9.591   140.102     0.200
     9.647   143.578     0.200
     9.912   148.227     0.200
     9.937   144.727     0.200
     9.991   147.367     0.200
    10.255   150.023     0.200
    10.486   156.922     0.200
    10.551   153.820     0.200
    10.704   157.125     0.200
    10.753   156.945     0.200
    10.807   157.961     0.200
    10.808   158.422     0.200
    10.808   158.422     0.200
    10.812   157.977     0.200
    10.864   159.602     0.200
    10.948   160.844     0.200
    10.985   161.820     0.200
    11.059   162.602     0.200
    11.168   163.422     0.200
    11.241   164.391     0.200
    11.361   164.992     0.200
    11.246   164.812     0.200
    11.321   166.516     0.200
    11.446   164.367     0.200
    11.562   170.227     0.200
    11.694   166.875     0.200
    11.695   167.875     0.200
    11.695   167.820     0.200
    11.734   173.297     0.200
    11.781   172.914     0.200
    11.882   174.734     0.200
    12.004   176.156     0.200
    12.021   175.773     0.200
    12.048   177.781     0.200
    12.079   178.422     0.200
    12.102   175.023     0.200
    12.361   178.320     0.200
    12.507   182.695     0.200
    12.548   184.445     0.200
    12.722   186.570     0.200
    12.768   186.812     0.200
    13.137   192.172     0.200
    13.161   192.781     0.200
    13.171   193.273     0.200
    13.199   192.125     0.200
    13.222   193.336     0.200
    13.420   195.555     0.200
    13.532   196.320     0.200
    13.701   198.594     0.200
    13.741   200.492     0.200
    13.744   199.242     0.200
    13.914   201.773     0.200
    13.991   203.156     0.200
    14.166   201.492     0.200
    14.174   204.992     0.200
    14.178   205.320     0.200
    14.198   205.586     0.200
    14.368   208.625     0.200
    14.407   207.367     0.200
    14.424   205.477     0.200
    14.426   208.094     0.200
    14.475   207.672     0.200
    14.472   209.336     0.200
    14.548   210.961     0.200
    14.662   211.672     0.200
    14.743   208.672     0.200
    14.835   212.773     0.200
    14.835   213.227     0.200
    15.030   216.031     0.200
    15.073   216.227     0.200
    15.577   221.422     0.200
    15.741   225.133     0.200
    15.809   225.133     0.200
    15.840   224.414     0.200
    16.094   227.734     0.200
    17.000   239.312     0.200
    17.213   242.086     0.200
    17.921   251.070     0.200
    19.226   267.617     0.200
    20.041   276.133     0.200
    20.238   278.383     0.200
     1.220    21.234     0.200
     1.232    22.266     0.200
     1.341    25.000     0.200
     1.545    27.086     0.200
     1.585    27.555     0.200
     1.642    27.242     0.200
     1.661    29.078     0.200
     1.866    33.102     0.200
     2.019    35.719     0.200
     2.159    35.664     0.200
     2.237    36.117     0.200
     2.692    41.734     0.200
     2.946    44.672     0.200
     3.374    51.969     0.200
     3.405    52.727     0.200
     3.783    58.477     0.200
     4.473    66.445     0.200
     4.487    70.047     0.200
     4.643    70.750     0.200
     4.878    74.297     0.200
     5.002    75.750     0.200
     5.545    82.984     0.200
     5.580    83.477     0.200
     5.580    83.477     0.200
     6.018    88.586     0.200
     6.173    92.148     0.200
     7.469   107.875     0.200
     7.706   115.289     0.200
     7.818   113.898     0.200
     8.102   116.688     0.200
     9.488   135.430     0.200
    10.847   156.945     0.200
    10.847   156.953     0.200
    11.219   161.523     0.200
     0.890    17.145     0.200
     0.844    16.262     0.200
     1.026    19.391     0.200
     1.026    19.145     0.200
     0.995    19.297     0.200
     1.093    20.293     0.200
     1.093    20.113     0.200
     1.051    19.395     0.200
     1.094    20.234     0.200
     1.094    20.562     0.200
     1.026    19.211     0.200
     1.057    21.031     0.200
     1.186    21.922     0.200
     1.227    22.262     0.200
     1.227    22.281     0.200
     1.251    23.062     0.200
     1.318    23.711     0.200
     1.269    23.422     0.200
     1.356    23.867     0.200
     1.344    24.855     0.200
     1.344    24.754     0.200
     1.407    25.203     0.200
     1.358    24.961     0.200
     1.392    25.473     0.200
     1.416    25.754     0.200
     1.455    26.441     0.200
     1.507    26.793     0.200
     1.507    26.992     0.200
     1.617    27.289     0.200
     1.644    27.754     0.200
     1.644    27.984     0.200
     1.562    27.578     0.200
     1.559    27.449     0.200
     1.559    27.801     0.200
     1.589    28.184     0.200
     1.699    28.820     0.200
     1.659    29.223     0.200
     1.667    29.324     0.200
     1.668    29.281     0.200
     1.672    29.352     0.200
     1.709    29.953     0.200
     1.743    29.859     0.200
     1.740    30.395     0.200
     1.824    31.562     0.200
     1.849    31.941     0.200
     1.912    32.633     0.200
     1.892    32.531     0.200
     1.986    33.867     0.200
     1.986    34.102     0.200
     2.024    33.832     0.200
     2.054    34.871     0.200
     2.162    36.234     0.200
     2.179    35.984     0.200
     2.192    36.621     0.200
     2.204    36.801     0.200
     2.235    37.211     0.200
     2.272    37.520     0.200
     2.272    37.895     0.200
     2.361    38.582     0.200
     2.450    40.594     0.200
     2.470    40.484     0.200
     2.650    42.422     0.200
     2.723    44.441     0.200
     2.849    45.535     0.200
     2.958    47.855     0.200
     2.958    48.074     0.200
     2.925    46.941     0.200
     2.980    47.852     0.200
     3.094    49.805     0.200
     3.211    50.398     0.200
     3.515    54.383     0.200
     3.666    55.914     0.200
     3.666    55.664     0.200
     4.227    65.074     0.200
     4.349    67.414     0.200
     4.445    69.223     0.200
     4.407    66.664     0.200
     4.455    69.113     0.200
     5.114    79.562     0.200
     5.148    77.574     0.200
     5.651    85.484     0.200
     6.461    96.402     0.200
     6.766    99.801     0.200
     6.724    97.684     0.200
     6.812    99.734     0.200
     6.906   101.031     0.200
     6.988   101.512     0.200
     7.216   105.234     0.200
     7.227   105.473     0.200
     7.398   107.852     0.200
     7.418   109.023     0.200
     7.515   108.613     0.200
     7.601   109.492     0.200
     7.723   113.191     0.200
     7.861   117.422     0.200
     8.304   120.312     0.200
     8.528   126.711     0.200
     0.940    17.055     0.200
     0.940    17.180     0.200
     0.998    17.992     0.200
     1.023    18.273     0.200
     1.114    19.664     0.200
     1.176    21.023     0.200
     1.168    20.633     0.200
     1.198    20.992     0.200
     1.303    22.492     0.200
     1.474    24.578     0.200
     1.625    27.609     0.200
     1.633    28.156     0.200
     1.636    28.133     0.200
     1.731    28.367     0.200
     1.741    28.648     0.200
     1.895    30.789     0.200
     1.894    30.953     0.200
     1.991    32.523     0.200
     1.992    33.570     0.200
     2.116    34.031     0.200
     2.391    39.562     0.200
     2.407    37.977     0.200
     2.415    37.727     0.200
     2.506    38.922     0.200
     2.566    38.906     0.200
     3.403    51.586     0.200
     3.473    53.703     0.200
     3.554    54.000     0.200
     3.939    59.781     0.200
     4.097    61.016     0.200
     4.260    64.281     0.200
     4.260    64.727     0.200
     5.297    79.375     0.200
     5.820    86.570     0.200
     6.094    90.656     0.200
     6.114    91.984     0.200
     6.572    95.383     0.200
     6.572    95.992     0.200
     7.303   105.266     0.200
     7.475   107.547     0.200
     7.495   109.523     0.200
     7.605   110.594     0.200
     7.694   114.359     0.200
     7.800   115.016     0.200
     9.001   128.320     0.200
     9.123   133.414     0.200
    10.327   151.055     0.200
    10.360   148.406     0.200
    10.803   156.375     0.200
    10.803   158.180     0.200
    10.838   155.320     0.200
    10.949   160.961     0.200
    11.248   161.516     0.200
    11.337   163.094     0.200
    13.012   188.945     0.200
     0.888    16.305     0.200
     0.862    15.316     0.200
     1.038    18.340     0.200
     1.137    20.051     0.200
     1.219    20.949     0.200
     1.169    21.391     0.200
     1.215    21.098     0.200
     1.190    21.117     0.200
     1.212    21.051     0.200
     1.354    22.703     0.200
     1.357    23.332     0.200
     1.448    24.477     0.200
     1.475    24.352     0.200
     1.510    26.094     0.200
     1.607    26.840     0.200
     1.587    26.984     0.200
     1.805    28.656     0.200
     1.806    30.137     0.200
     1.806    30.461     0.200
     1.896    30.312     0.200
     1.878    30.691     0.200
     1.897    31.445     0.200
     1.928    30.355     0.200
     2.118    33.395     0.200
     2.170    35.211     0.200
     2.231    35.766     0.200
     2.294    36.129     0.200
     2.315    36.422     0.200
     2.346    36.660     0.200
     2.369    38.227     0.200
     2.369    37.602     0.200
     2.402    38.672     0.200
     2.497    39.703     0.200
     2.634    41.660     0.200
     2.730    43.539     0.200
     2.805    43.562     0.200
     2.907    46.484     0.200
     3.060    48.543     0.200
     3.108    48.531     0.200
     3.197    48.930     0.200
     3.256    50.816     0.200
     3.266    51.035     0.200
     3.306    51.914     0.200
     3.524    55.086     0.200
     3.897    60.211     0.200
     4.236    64.457     0.200
     4.369    66.160     0.200
     4.411    66.750     0.200
     4.533    67.730     0.200
     4.608    69.711     0.200
     4.830    73.711     0.200
     4.851    73.352     0.200
     4.856    76.312     0.200
     5.241    79.633     0.200
     5.272    76.195     0.200
     5.770    85.762     0.200
     6.096    88.891     0.200
    11.784   168.402     0.200
     1.024    18.867     0.200
     1.116    20.617     0.200
     1.310    23.742     0.200
     1.369    24.602     0.200
     1.505    25.547     0.200
     1.491    26.422     0.200
     1.670    27.656     0.200
     1.853    30.836     0.200
     1.805    30.914     0.200
     2.156    34.352     0.200
     2.323    38.062     0.200
     2.567    43.219     0.200
     2.704    43.562     0.200
     2.900    46.047     0.200
     2.917    45.383     0.200
     3.931    62.859     0.200
     4.297    65.578     0.200
     4.715    70.977     0.200
     4.721    71.867     0.200
     4.754    72.617     0.200
     4.795    72.977     0.200
     4.919    75.062     0.200
     5.513    82.359     0.200
     5.505    84.359     0.200
     5.615    86.086     0.200
     5.646    85.508     0.200
     5.864    88.047     0.200
     6.045    93.406     0.200
     6.042    91.789     0.200
     6.438    99.492     0.200
     7.979   117.930     0.200
     8.003   118.133     0.200
     8.119   120.719     0.200
     8.220   120.703     0.200
     9.743   143.398     0.200
    10.587   155.180     0.200
    10.572   152.242     0.200
     0.980    18.570     0.200
     1.073    19.602     0.200
     1.127    20.164     0.200
     1.127    20.023     0.200
     1.128    20.023     0.200
     1.190    20.789     0.200
     1.182    22.086     0.200
     1.517    25.539     0.200
     1.532    25.430     0.200
     1.884    30.766     0.200
     1.885    30.742     0.200
     1.848    29.703     0.200
     2.448    39.344     0.200
     2.511    38.039     0.200
     2.524    41.906     0.200
     2.563    40.430     0.200
     2.582    42.516     0.200
     3.643    58.305     0.200
     3.730    57.781     0.200
     3.737    58.383     0.200
     4.067    60.242     0.200
     4.067    60.586     0.200
     4.312    66.484     0.200
     4.398    67.633     0.200
     4.486    68.242     0.200
     4.928    74.586     0.200
     4.941    74.984     0.200
     5.067    77.164     0.200
     5.222    81.094     0.200
     5.263    79.664     0.200
     5.295    79.531     0.200
     5.403    81.594     0.200
     5.755    86.094     0.200
     5.787    87.516     0.200
     5.924    90.172     0.200
     6.204    94.422     0.200
     6.554    95.023     0.200
     6.945   104.820     0.200
     7.254   107.352     0.200
     7.593   111.680     0.200
     7.617   113.031     0.200
     8.692   124.641     0.200
    10.423   152.086     0.200
     0.893    16.852     0.200
     0.893    16.984     0.200
     0.983    19.777     0.200
     1.150    22.625     0.200
     1.304    24.449     0.200
     1.324    24.395     0.200
     1.331    26.234     0.200
     1.391    26.387     0.200
     1.523    27.785     0.200
     1.539    28.840     0.200
     1.539    27.926     0.200
     1.588    27.957     0.200
     1.621    29.105     0.200
     1.714    30.406     0.200
     1.832    31.039     0.200
     1.850    33.496     0.200
     1.935    35.285     0.200
     2.276    35.945     0.200
     2.249    38.066     0.200
     2.455    40.086     0.200
     2.623    41.555     0.200
     2.625    42.109     0.200
     2.625    41.957     0.200
     2.688    43.406     0.200
     2.767    44.926     0.200
     3.087    49.719     0.200
     3.392    52.516     0.200
     3.951    60.805     0.200
     3.946    61.527     0.200
     4.076    63.527     0.200
     4.166    64.828     0.200
     4.275    66.477     0.200
     4.331    67.938     0.200
     4.455    68.375     0.200
     4.479    69.297     0.200
     4.508    68.285     0.200
     4.766    70.996     0.200
     4.884    74.945     0.200
     4.884    76.531     0.200
     5.344    80.887     0.200
     5.451    82.484     0.200
     5.416    82.125     0.200
     5.612    84.496     0.200
     5.691    84.445     0.200
     5.779    86.516     0.200
     7.141   104.961     0.200
     7.315   107.086     0.200
     7.411   108.895     0.200
    11.562   165.297     0.200
     1.335    26.551     0.200
     1.390    25.471     0.200
     1.456    26.971     0.200
     1.508    27.281     0.200
     1.519    27.881     0.200
     1.526    28.121     0.200
     1.550    27.551     0.200
     1.602    27.882     0.200
     1.620    29.871     0.200
     1.623    30.261     0.200
     1.713    31.311     0.200
     1.836    30.956     0.200
     2.260    37.681     0.200
     2.258    37.991     0.200
     2.273    37.421     0.200
     2.627    42.781     0.200
     2.631    43.171     0.200
     2.698    45.031     0.200
     2.781    46.451     0.200
     3.100    50.431     0.200
     3.957    61.461     0.200
     3.959    62.071     0.200
     4.088    64.361     0.200
     4.179    65.701     0.200
     4.345    68.921     0.200
     4.398    68.411     0.200
     4.503    71.151     0.200
     4.769    76.141     0.200
     4.856    76.481     0.200
     4.895    76.781     0.200
     5.143    81.321     0.200
     5.194    79.531     0.200
     5.288    83.511     0.200
     5.428    83.931     0.200
     6.889   103.261     0.200
     7.340   112.221     0.200
    11.287   165.301     0.200
    11.550   169.901     0.200
    14.616   210.861     0.200
     0.853    16.613     0.200
     0.870    16.176     0.200
     1.025    19.023     0.200
     1.031    19.383     0.200
     1.031    19.672     0.200
     1.046    19.512     0.200
     1.348    23.418     0.200
     1.384    24.973     0.200
     1.590    27.203     0.200
     1.637    27.148     0.200
     1.640    28.164     0.200
     1.675    28.793     0.200
     1.676    28.664     0.200
     2.004    33.973     0.200
     2.061    34.492     0.200
     2.314    37.914     0.200
     2.606    41.793     0.200
     2.747    44.422     0.200
     2.786    45.492     0.200
     2.911    45.152     0.200
     3.107    49.824     0.200
     3.342    53.332     0.200
     3.624    56.715     0.200
     3.977    62.762     0.200
     4.280    65.223     0.200
     4.507    68.902     0.200
     4.594    70.543     0.200
     4.708    71.742     0.200
     4.719    72.102     0.200
     4.822    75.312     0.200
     5.294    79.234     0.200
     5.325    81.555     0.200
     5.508    82.422     0.200
     5.835    86.965     0.200
     5.880    87.383     0.200
    12.142   175.453     0.200
    14.694   207.754     0.200
    15.024   213.504     0.200
     0.975    17.531     0.200
     0.983    17.648     0.200
     1.031    18.332     0.200
     1.097    19.289     0.200
     1.159    20.719     0.200
     1.159    20.359     0.200
     1.183    20.629     0.200
     1.183    20.555     0.200
     1.290    22.090     0.200
     1.468    24.375     0.200
     1.548    25.156     0.200
     1.753    28.504     0.200
     1.910    30.844     0.200
     2.405    37.176     0.200
     2.418    37.383     0.200
     2.572    38.617     0.200
     3.641    56.270     0.200
     3.717    57.168     0.200
     4.107    60.348     0.200
     4.107    60.707     0.200
     4.277    66.066     0.200
     4.277    63.730     0.200
     4.340    66.996     0.200
     4.863    73.996     0.200
     4.922    74.496     0.200
     5.827    89.797     0.200
     6.584    95.945     0.200
     7.565   113.008     0.200
     8.728   124.242     0.200
    10.819   158.797     0.200
    10.846   154.949     0.200
     1.168    20.734     0.200
     1.302    22.383     0.200
     1.302    22.477     0.200
     1.480    24.805     0.200
     1.535    25.359     0.200
     1.755    28.508     0.200
     1.909    30.867     0.200
     1.907    30.891     0.200
     2.421    38.055     0.200
     2.492    38.922     0.200
     2.493    41.438     0.200
     2.560    38.875     0.200
     2.738    42.273     0.200
     3.329    51.789     0.200
     3.415    51.547     0.200
     3.487    54.023     0.200
     3.648    55.430     0.200
     3.706    57.438     0.200
     4.095    60.438     0.200
     4.268    66.648     0.200
     4.334    66.805     0.200
     4.408    67.344     0.200
     4.720    75.188     0.200
     4.860    74.195     0.200
     4.988    75.805     0.200
     5.149    78.867     0.200
     5.668    84.609     0.200
     5.833    90.086     0.200
     6.127    93.156     0.200
     6.356    93.469     0.200
     6.571    95.477     0.200
     6.649    99.156     0.200
     7.258   107.219     0.200
    10.816   157.484     0.200
    10.834   155.609     0.200
     0.984    17.531     0.200
     0.995    17.836     0.200
     1.032    18.344     0.200
     1.109    19.500     0.200
     1.171    20.914     0.200
     1.177    20.617     0.200
     1.195    20.828     0.200
     1.302    22.250     0.200
     1.478    24.602     0.200
     1.738    28.211     0.200
     1.751    28.312     0.200
     1.902    30.867     0.200
     1.904    30.594     0.200
     1.981    32.281     0.200
     2.121    34.719     0.200
     2.417    37.648     0.200
     2.487    38.844     0.200
     2.506    38.844     0.200
     2.563    39.016     0.200
     2.734    42.273     0.200
     3.066    47.695     0.200
     3.113    47.781     0.200
     3.328    50.594     0.200
     3.411    51.516     0.200
     3.644    55.297     0.200
     4.096    60.734     0.200
     4.096    61.008     0.200
     4.265    66.102     0.200
     4.321    65.523     0.200
     5.828    86.867     0.200
     6.100    91.047     0.200
     6.353    93.008     0.200
     6.572    95.359     0.200
     7.484   110.031     0.200
     7.802   114.875     0.200
     8.716   126.266     0.200
     8.716   123.695     0.200
    10.812   159.703     0.200
    10.836   155.961     0.200
    13.021   187.445     0.200
    14.050   200.391     0.200
    15.394   218.758     0.200
    16.060   226.734     0.200
     0.937    17.969     0.200
     1.105    19.422     0.200
     1.179    20.703     0.200
     1.167    20.992     0.200
     1.167    20.797     0.200
     1.191    21.000     0.200
     1.475    24.617     0.200
     1.668    27.422     0.200
     1.742    28.461     0.200
     1.752    28.570     0.200
     1.906    30.891     0.200
     1.905    30.648     0.200
     1.980    32.336     0.200
     1.981    32.047     0.200
     2.119    34.000     0.200
     2.127    34.773     0.200
     2.190    34.867     0.200
     2.379    37.117     0.200
     2.418    37.688     0.200
     2.487    38.953     0.200
     2.502    39.039     0.200
     2.565    39.047     0.200
     2.609    40.367     0.200
     2.733    42.703     0.200
     2.922    45.117     0.200
     3.005    46.641     0.200
     3.064    48.891     0.200
     3.064    47.445     0.200
     3.110    47.258     0.200
     3.325    51.336     0.200
     3.325    50.047     0.200
     3.411    51.383     0.200
     3.420    52.328     0.200
     3.530    53.406     0.200
     3.560    54.383     0.200
     3.591    55.242     0.200
     3.644    55.312     0.200
     3.729    56.789     0.200
     3.950    62.586     0.200
     3.950    60.102     0.200
     3.981    60.391     0.200
     3.984    60.352     0.200
     4.037    60.820     0.200
     4.099    62.016     0.200
     4.099    61.477     0.200
     4.223    63.555     0.200
     4.269    63.789     0.200
     4.319    66.289     0.200
     4.570    69.320     0.200
     4.858    74.875     0.200
     4.987    77.250     0.200
     5.148    81.172     0.200
     5.271    78.680     0.200
     5.308    80.594     0.200
     5.308    79.133     0.200
     5.310    80.188     0.200
     5.364    82.266     0.200
     5.414    82.625     0.200
     5.580    82.117     0.200
     5.630    83.664     0.200
     5.666    86.211     0.200
     5.829    90.414     0.200
     5.829    87.672     0.200
     6.079    93.641     0.200
     6.348    95.055     0.200
     6.352    95.656     0.200
     6.575    96.445     0.200
     6.976   105.672     0.200
     7.138   108.602     0.200
     7.138   104.617     0.200
     7.157   108.305     0.200
     7.261   106.812     0.200
     7.291   111.750     0.200
     7.295   107.984     0.200
     7.314   109.633     0.200
     7.462   114.164     0.200
     7.486   110.227     0.200
     7.508   112.383     0.200
     7.510   112.281     0.200
     7.505   112.141     0.200
     7.545   114.094     0.200
     7.545   110.312     0.200
     7.556   114.773     0.200
     7.558   114.586     0.200
     7.560   111.344     0.200
     7.591   115.086     0.200
     7.625   115.312     0.200
     7.644   114.992     0.200
     7.657   116.195     0.200
     7.767   113.344     0.200
     7.804   114.102     0.200
     7.806   113.891     0.200
     7.806   116.266     0.200
     7.806   117.297     0.200
     7.806   113.203     0.200
     7.807   114.359     0.200
     7.841   118.812     0.200
     8.006   121.094     0.200
     8.237   124.641     0.200
     8.247   124.922     0.200
     8.547   127.531     0.200
     8.547   124.086     0.200
     8.630   128.523     0.200
     8.720   126.195     0.200
     8.720   125.969     0.200
     8.730   130.383     0.200
     8.808   128.922     0.200
     9.012   133.625     0.200
     9.135   135.812     0.200
     9.217   135.992     0.200
     9.217   132.781     0.200
     9.192   134.820     0.200
     9.271   137.875     0.200
     9.470   137.500     0.200
     9.470   136.977     0.200
     9.489   139.227     0.200
     9.620   137.992     0.200
     9.696   139.281     0.200
     9.765   140.336     0.200
    10.020   143.430     0.200
    10.023   147.312     0.200
    10.056   146.375     0.200
    10.164   145.500     0.200
    10.191   152.016     0.200
    10.308   148.547     0.200
    10.339   152.492     0.200
    10.371   153.086     0.200
    10.374   154.812     0.200
    10.483   153.844     0.200
    10.555   156.422     0.200
    10.624   157.383     0.200
    10.609   153.273     0.200
    10.728   155.781     0.200
    10.728   152.266     0.200
    10.750   154.188     0.200
    10.815   156.617     0.200
    10.815   158.844     0.200
    10.815   157.891     0.200
    10.815   158.023     0.200
    10.838   155.664     0.200
    10.839   155.422     0.200
    10.961   161.766     0.200
    11.054   162.000     0.200
    11.080   163.055     0.200
    11.113   160.031     0.200
    11.163   159.555     0.200
    11.198   164.281     0.200
    11.259   165.352     0.200
    11.349   164.133     0.200
    11.415   163.320     0.200
    11.570   166.609     0.200
    11.673   171.211     0.200
    11.682   165.688     0.200
    11.682   168.969     0.200
    11.883   173.844     0.200
    11.965   172.867     0.200
    11.965   173.148     0.200
    11.996   173.133     0.200
    12.006   171.398     0.200
    12.054   173.008     0.200
    12.160   178.586     0.200
    12.153   175.102     0.200
    12.188   179.117     0.200
    12.268   175.836     0.200
    12.300   180.617     0.200
    12.721   187.141     0.200
    12.759   179.852     0.200
    12.803   187.734     0.200
    12.806   183.648     0.200
    12.913   187.891     0.200
    12.980   184.430     0.200
    12.999   190.641     0.200
    13.024   188.531     0.200
    13.279   193.438     0.200
    13.387   191.953     0.200
    13.404   192.484     0.200
    13.404   191.102     0.200
    13.542   193.375     0.200
    13.615   193.859     0.200
    13.657   194.227     0.200
    13.657   193.344     0.200
    13.687   197.891     0.200
    13.839   200.742     0.200
    14.054   200.797     0.200
    14.054   198.734     0.200
    14.062   200.195     0.200
    14.233   203.141     0.200
    14.267   201.938     0.200
    14.267   202.742     0.200
    14.532   207.320     0.200
    14.686   207.648     0.200
    15.157   215.352     0.200
    15.264   217.781     0.200
    15.264   214.523     0.200
    15.321   214.438     0.200
    15.321   216.508     0.200
    15.397   218.477     0.200
    15.397   216.945     0.200
    15.440   219.414     0.200
    15.440   216.734     0.200
    15.571   221.297     0.200
    15.609   220.602     0.200
    15.668   220.477     0.200
    16.182   227.594     0.200
    16.474   232.125     0.200
    16.474   230.523     0.200
    16.562   231.867     0.200
    16.565   233.188     0.200
    17.112   238.461     0.200
    17.636   245.227     0.200
    17.706   246.312     0.200
    17.706   245.492     0.200
    17.872   248.828     0.200
    17.901   249.445     0.200
    18.168   252.516     0.200
    18.263   252.938     0.200
    18.263   253.125     0.200
    18.293   253.828     0.200
    18.298   253.688     0.200
    18.340   252.945     0.200
    18.343   253.258     0.200
    18.489   256.695     0.200
    18.519   257.523     0.200
    18.720   260.516     0.200
    18.753   261.414     0.200
    18.915   263.047     0.200
    18.964   263.016     0.200
    18.964   261.875     0.200
    19.029   262.875     0.200
    19.435   267.523     0.200
    19.553   271.633     0.200
    19.629   271.031     0.200
    19.648   269.797     0.200
    19.802   272.500     0.200
    19.852   271.781     0.200
    19.951   274.008     0.200
    19.993   274.156     0.200
    20.019   275.094     0.200
    20.048   274.438     0.200
    20.421   278.727     0.200
     0.949    17.594     0.200
     0.952    17.586     0.200
     0.983    18.336     0.200
     1.094    19.500     0.200
     1.155    20.711     0.200
     1.155    21.070     0.200
     1.185    20.953     0.200
     1.294    22.711     0.200
     2.508    40.453     0.200
     3.071    47.523     0.200
     3.324    52.891     0.200
     3.500    55.945     0.200
     4.099    61.172     0.200
     5.003    75.352     0.200
     5.324    78.266     0.200
     5.365    81.500     0.200
     5.377    79.789     0.200
     5.427    81.250     0.200
     5.578    81.031     0.200
     7.076   106.375     0.200
     7.195   106.445     0.200
     7.267   105.586     0.200
     7.724   114.305     0.200
     8.721   124.453     0.200
    10.572   150.695     0.200
    10.733   153.070     0.200
    10.831   155.203     0.200
     0.938    17.148     0.200
     0.968    17.281     0.200
     1.047    18.641     0.200
     1.060    18.734     0.200
     1.108    19.828     0.200
     1.142    20.055     0.200
     1.233    21.469     0.200
     1.254    21.742     0.200
     1.456    24.422     0.200
     1.585    27.844     0.200
     1.939    31.578     0.200
     1.961    31.719     0.200
     2.586    39.375     0.200
     3.664    57.375     0.200
     3.763    58.320     0.200
     4.133    61.359     0.200
     4.327    66.195     0.200
     4.966    74.758     0.200
     5.326    80.625     0.200
     5.854    88.891     0.200
     7.857   115.711     0.200
    10.865   155.445     0.200
    10.870   160.469     0.200
     0.935    18.312     0.200
     1.107    19.781     0.200
     1.176    20.680     0.200
     1.169    21.164     0.200
     1.193    21.086     0.200
     1.299    22.359     0.200
     1.474    24.836     0.200
     1.617    25.422     0.200
     1.616    27.742     0.200
     1.625    26.359     0.200
     1.628    28.203     0.200
     1.666    27.898     0.200
     1.739    28.453     0.200
     1.749    28.805     0.200
     1.902    31.086     0.200
     1.902    30.836     0.200
     1.983    32.391     0.200
     2.117    34.234     0.200
     2.126    34.695     0.200
     2.187    35.047     0.200
     2.378    37.312     0.200
     2.392    38.125     0.200
     2.415    38.070     0.200
     2.413    37.609     0.200
     2.461    39.203     0.200
     2.490    39.461     0.200
     2.484    39.000     0.200
     2.566    38.789     0.200
     2.608    40.664     0.200
     2.731    42.711     0.200
     2.918    44.992     0.200
     3.003    46.023     0.200
     3.063    47.492     0.200
     3.063    47.297     0.200
     3.110    47.242     0.200
     3.325    50.984     0.200
     3.325    50.398     0.200
     3.408    51.633     0.200
     3.418    52.305     0.200
     3.481    53.695     0.200
     3.557    54.055     0.200
     3.557    53.844     0.200
     3.641    55.352     0.200
     3.707    56.812     0.200
     3.728    56.430     0.200
     3.946    60.516     0.200
     3.946    60.359     0.200
     3.978    59.859     0.200
     3.983    60.617     0.200
     4.035    61.172     0.200
     4.099    60.281     0.200
     4.220    63.969     0.200
     4.267    64.906     0.200
     4.267    64.555     0.200
     4.331    65.812     0.200
     4.317    64.875     0.200
     4.404    66.844     0.200
     4.567    67.625     0.200
     4.714    71.352     0.200
     4.912    74.180     0.200
     4.984    75.422     0.200
     5.145    78.250     0.200
     5.269    79.734     0.200
     5.269    78.164     0.200
     5.305    79.383     0.200
     5.305    79.164     0.200
     5.307    80.602     0.200
     5.356    81.211     0.200
     5.361    83.086     0.200
     5.580    81.664     0.200
     5.632    81.445     0.200
     5.663    84.820     0.200
     5.708    86.656     0.200
     5.783    86.281     0.200
     5.826    86.180     0.200
     5.826    87.281     0.200
     6.076    91.156     0.200
     6.123    91.953     0.200
     6.299    97.336     0.200
     6.345    94.344     0.200
     6.349    93.891     0.200
     6.575    96.109     0.200
     6.642   102.172     0.200
     6.867   104.992     0.200
     7.136   107.031     0.200
     7.136   106.219     0.200
     7.156   106.945     0.200
     7.176   108.211     0.200
     7.260   105.969     0.200
     7.289   110.359     0.200
     7.311   108.805     0.200
     7.458   112.641     0.200
     7.483   113.422     0.200
     7.483   111.055     0.200
     7.505   111.922     0.200
     7.507   111.695     0.200
     7.512   112.125     0.200
     7.512   112.289     0.200
     7.502   110.930     0.200
     7.517   112.320     0.200
     7.524   111.445     0.200
     7.531   112.266     0.200
     7.544   109.633     0.200
     7.542   112.031     0.200
     7.552   112.586     0.200
     7.553   112.242     0.200
     7.559   111.961     0.200
     7.556   112.180     0.200
     7.569   112.891     0.200
     7.588   113.234     0.200
     7.592   113.219     0.200
     7.622   113.383     0.200
     7.642   113.430     0.200
     7.654   115.461     0.200
     7.688   114.070     0.200
     7.767   113.164     0.200
     7.777   115.195     0.200
     7.803   113.680     0.200
     7.805   112.430     0.200
     7.805   114.969     0.200
     7.805   114.398     0.200
     7.805   114.453     0.200
     7.858   117.070     0.200
     8.135   121.211     0.200
     8.217   121.539     0.200
     8.234   123.109     0.200
     8.244   123.570     0.200
     8.545   125.836     0.200
     8.545   124.641     0.200
     8.627   128.180     0.200
     8.720   125.352     0.200
     8.726   130.219     0.200
     8.806   128.414     0.200
     8.806   127.977     0.200
     9.009   131.750     0.200
     9.132   135.125     0.200
     9.189   133.859     0.200
     9.214   135.109     0.200
     9.214   134.281     0.200
     9.268   136.344     0.200
     9.468   137.750     0.200
     9.468   136.867     0.200
     9.489   138.094     0.200
     9.762   142.102     0.200
    10.018   144.211     0.200
    10.026   146.781     0.200
    10.053   144.250     0.200
    10.162   145.891     0.200
    10.305   146.398     0.200
    10.335   152.211     0.200
    10.368   153.172     0.200
    10.372   153.734     0.200
    10.481   154.062     0.200
    10.516   154.805     0.200
    10.627   155.086     0.200
    10.552   155.852     0.200
    10.552   151.648     0.200
    10.606   154.297     0.200
    10.727   157.930     0.200
    10.727   155.828     0.200
    10.747   156.391     0.200
    10.811   157.852     0.200
    10.811   156.719     0.200
    10.811   157.812     0.200
    10.811   156.609     0.200
    10.811   157.250     0.200
    10.838   154.961     0.200
    10.839   155.164     0.200
    10.898   159.086     0.200
    10.957   160.609     0.200
    10.987   156.805     0.200
    11.051   161.156     0.200
    11.076   163.000     0.200
    11.160   160.555     0.200
    11.170   163.836     0.200
    11.196   165.781     0.200
    11.256   164.602     0.200
    11.345   166.570     0.200
    11.412   164.742     0.200
    11.435   167.766     0.200
    11.535   171.602     0.200
    11.568   166.258     0.200
    11.669   171.469     0.200
    11.681   167.000     0.200
    11.962   173.930     0.200
    11.962   171.562     0.200
    11.966   176.719     0.200
    11.993   177.062     0.200
    11.993   172.195     0.200
    12.003   174.133     0.200
    12.052   173.391     0.200
    12.157   178.836     0.200
    12.150   173.914     0.200
    12.184   178.992     0.200
    12.211   179.289     0.200
    12.265   176.383     0.200
    12.297   179.820     0.200
    12.518   183.914     0.200
    12.718   186.812     0.200
    12.756   181.789     0.200
    12.800   187.930     0.200
    12.804   183.922     0.200
    12.910   188.500     0.200
    12.910   188.359     0.200
    12.977   188.102     0.200
    12.996   189.969     0.200
    13.020   188.609     0.200
    13.020   188.086     0.200
    13.385   191.281     0.200
    13.403   190.086     0.200
    13.527   196.633     0.200
    13.539   194.359     0.200
    13.608   198.414     0.200
    13.612   196.500     0.200
    13.657   196.414     0.200
    13.657   194.148     0.200
    13.684   199.172     0.200
    13.704   199.133     0.200
    13.836   200.664     0.200
    13.836   198.414     0.200
    13.901   202.484     0.200
    13.957   202.695     0.200
    14.053   200.773     0.200
    14.053   199.883     0.200
    14.061   199.016     0.200
    14.230   203.234     0.200
    14.239   205.484     0.200
    14.264   202.664     0.200
    14.264   203.117     0.200
    14.529   205.242     0.200
    14.686   210.359     0.200
    14.686   207.305     0.200
    15.154   215.039     0.200
    15.321   216.859     0.200
    15.321   215.805     0.200
    15.394   217.906     0.200
    15.394   217.500     0.200
    15.409   219.148     0.200
    15.440   218.664     0.200
    15.440   217.023     0.200
    15.568   218.945     0.200
    15.606   219.852     0.200
    15.606   221.594     0.200
    15.666   219.461     0.200
    15.990   225.742     0.200
    16.179   227.297     0.200
    16.472   231.664     0.200
    16.561   233.055     0.200
    16.562   231.914     0.200
    17.220   240.602     0.200
    17.705   246.070     0.200
    17.900   248.656     0.200
    18.049   249.633     0.200
    18.167   250.828     0.200
    18.191   251.820     0.200
    18.250   252.062     0.200
    18.260   251.789     0.200
    18.291   253.367     0.200
    18.297   253.422     0.200
    18.342   253.227     0.200
    18.414   254.961     0.200
    18.460   256.039     0.200
    18.592   257.953     0.200
    18.597   257.188     0.200
    18.719   260.914     0.200
    18.719   259.516     0.200
    18.752   261.234     0.200
    18.752   260.094     0.200
    18.913   262.812     0.200
    18.913   262.430     0.200
    18.957   262.859     0.200
    18.957   262.086     0.200
    18.963   262.984     0.200
    18.963   262.164     0.200
    18.964   263.289     0.200
    19.027   262.242     0.200
    19.032   263.211     0.200
    19.035   263.148     0.200
    19.064   265.164     0.200
    19.078   263.891     0.200
    19.091   266.383     0.200
    19.125   263.938     0.200
    19.137   263.891     0.200
    19.197   264.148     0.200
    19.221   264.594     0.200
    19.301   265.508     0.200
    19.354   267.086     0.200
    19.433   267.594     0.200
    19.469   267.891     0.200
    19.485   268.211     0.200
    19.505   268.586     0.200
    19.628   270.562     0.200
    19.628   270.086     0.200
    19.645   269.508     0.200
    19.715   271.133     0.200
    19.736   270.797     0.200
    19.782   270.750     0.200
    19.800   270.828     0.200
    19.818   272.469     0.200
    19.863   271.797     0.200
    19.885   272.500     0.200
    19.891   272.102     0.200
    19.949   272.711     0.200
    19.951   272.750     0.200
    19.991   276.234     0.200
    19.991   273.867     0.200
    20.012   276.562     0.200
    20.012   273.680     0.200
    20.018   273.297     0.200
    20.046   273.938     0.200
    20.128   274.750     0.200
    20.268   276.977     0.200
    20.317   277.133     0.200
    20.321   277.750     0.200
    20.351   279.430     0.200
    20.351   277.641     0.200
    20.369   277.852     0.200
    20.396   278.992     0.200
    20.398   277.547     0.200
    20.420   279.383     0.200
    20.420   278.547     0.200
    20.457   280.133     0.200
    20.532   280.039     0.200
    20.567   279.625     0.200
    20.665   280.602     0.200
    20.690   281.516     0.200
    20.715   281.180     0.200
    20.719   281.922     0.200
    20.776   282.664     0.200
    20.787   282.453     0.200
    20.797   282.555     0.200
    20.935   285.000     0.200
     1.128    19.914     0.200
     1.154    20.320     0.200
     1.191    21.172     0.200
     1.191    20.883     0.200
     1.210    21.414     0.200
     1.314    22.555     0.200
     1.480    24.961     0.200
     1.731    28.367     0.200
     1.889    30.375     0.200
     2.398    37.672     0.200
     2.424    37.922     0.200
     2.467    39.984     0.200
     2.473    38.656     0.200
     2.728    42.266     0.200
     3.398    51.547     0.200
     3.461    53.562     0.200
     3.930    60.383     0.200
     5.249    79.727     0.200
     5.642    84.766     0.200
     5.813    86.234     0.200
     5.813    86.242     0.200
     6.100    91.508     0.200
     6.332    95.203     0.200
     7.153   105.695     0.200
     7.266   109.148     0.200
     7.482   109.609     0.200
     7.494   113.086     0.200
     7.502   107.297     0.200
     7.509   112.453     0.200
     7.531   113.312     0.200
     7.533   112.617     0.200
     7.546   112.539     0.200
     7.599   113.836     0.200
     7.619   113.547     0.200
     7.665   111.648     0.200
     7.754   116.375     0.200
     7.787   113.164     0.200
     7.787   112.234     0.200
     8.605   127.172     0.200
     8.704   130.492     0.200
     8.988   132.258     0.200
    10.313   152.945     0.200
    10.349   152.484     0.200
    10.789   158.516     0.200
    10.789   155.914     0.200
    10.789   155.914     0.200
    10.831   156.969     0.200
    10.831   156.961     0.200
    10.935   162.594     0.200
    11.029   161.703     0.200
    11.945   174.406     0.200
     1.112    19.930     0.200
     1.152    20.039     0.200
     1.266    21.656     0.200
     1.472    24.500     0.200
     1.561    24.945     0.200
     1.559    24.953     0.200
     1.928    31.453     0.200
     1.946    33.023     0.200
     2.375    39.359     0.200
     2.570    38.727     0.200
     2.525    41.477     0.200
     2.525    41.359     0.200
     2.554    42.086     0.200
     2.750    44.688     0.200
     3.069    48.398     0.200
     3.302    50.266     0.200
     3.446    53.852     0.200
     3.581    56.258     0.200
     3.581    55.883     0.200
     3.679    57.117     0.200
     3.756    57.688     0.200
     3.999    63.234     0.200
     3.999    62.789     0.200
     4.119    60.664     0.200
     4.119    60.445     0.200
     4.264    66.242     0.200
     4.324    66.148     0.200
     4.393    67.438     0.200
     4.468    67.695     0.200
     4.958    73.906     0.200
     5.047    76.836     0.200
     5.209    81.414     0.200
     5.319    80.836     0.200
     5.319    79.859     0.200
     5.593    81.086     0.200
     5.772    89.609     0.200
     5.868    87.914     0.200
     6.378    94.992     0.200
     6.601    95.852     0.200
     7.193   105.445     0.200
     7.300   106.305     0.200
     7.583   110.375     0.200
     7.573   115.617     0.200
     7.614   115.062     0.200
     7.617   115.547     0.200
     7.653   116.094     0.200
     7.683   116.742     0.200
     7.846   114.781     0.200
     7.849   114.984     0.200
     7.849   114.945     0.200
     8.742   125.727     0.200
     8.742   125.422     0.200
    10.850   155.258     0.200
    10.849   155.586     0.200
    10.850   155.258     0.200
    10.875   161.836     0.200
     0.942    17.312     0.200
     0.950    17.461     0.200
     1.008    17.984     0.200
     0.989    17.742     0.200
     1.028    18.328     0.200
     1.122    19.648     0.200
     1.184    20.961     0.200
     1.165    20.359     0.200
     1.314    22.578     0.200
     1.485    24.984     0.200
     1.527    24.664     0.200
     1.620    24.844     0.200
     1.670    27.984     0.200
     1.724    28.180     0.200
     1.743    28.430     0.200
     1.900    30.508     0.200
     1.890    30.750     0.200
     1.989    32.320     0.200
     2.125    33.812     0.200
     2.134    35.320     0.200
     2.189    34.633     0.200
     2.310    36.164     0.200
     2.390    37.414     0.200
     2.401    39.531     0.200
     2.426    38.219     0.200
     2.410    37.758     0.200
     2.517    39.430     0.200
     2.484    38.727     0.200
     2.477    39.844     0.200
     2.737    42.406     0.200
     3.005    46.125     0.200
     3.071    47.156     0.200
     3.120    48.367     0.200
     3.338    50.273     0.200
     3.425    51.875     0.200
     3.409    51.578     0.200
     3.473    53.562     0.200
     3.541    53.617     0.200
     3.562    54.930     0.200
     3.562    53.758     0.200
     3.641    55.750     0.200
     3.692    56.430     0.200
     3.738    56.164     0.200
     3.942    60.258     0.200
     3.979    59.430     0.200
     4.086    60.133     0.200
     4.218    63.555     0.200
     4.251    65.000     0.200
     4.251    64.344     0.200
     4.317    66.008     0.200
     4.392    66.680     0.200
     4.844    73.492     0.200
     4.896    73.211     0.200
     4.972    75.664     0.200
     5.132    78.359     0.200
     5.253    79.062     0.200
     5.253    78.453     0.200
     5.298    79.484     0.200
     5.298    79.078     0.200
     5.341    82.891     0.200
     5.363    82.930     0.200
     5.413    84.578     0.200
     5.569    83.109     0.200
     5.653    84.812     0.200
     5.696    86.352     0.200
     5.824    87.211     0.200
     5.824    86.484     0.200
     6.103    93.820     0.200
     6.111    91.992     0.200
     6.352    94.141     0.200
     6.343    94.391     0.200
     6.561    95.852     0.200
     6.642   101.031     0.200
     7.120   106.969     0.200
     7.120   103.766     0.200
     7.141   106.352     0.200
     7.163   109.703     0.200
     7.245   106.203     0.200
     7.274   110.570     0.200
     7.298   108.523     0.200
     7.447   112.570     0.200
     7.472   109.094     0.200
     7.490   111.781     0.200
     7.492   111.820     0.200
     7.498   112.031     0.200
     7.497   111.789     0.200
     7.497   112.117     0.200
     7.504   112.523     0.200
     7.510   111.422     0.200
     7.529   110.141     0.200
     7.517   111.844     0.200
     7.544   113.250     0.200
     7.527   112.180     0.200
     7.537   112.383     0.200
     7.539   112.320     0.200
     7.541   112.359     0.200
     7.554   113.242     0.200
     7.573   112.914     0.200
     7.578   113.070     0.200
     7.607   113.570     0.200
     7.627   113.062     0.200
     7.642   115.281     0.200
     7.673   113.984     0.200
     7.762   115.164     0.200
     7.787   112.508     0.200
     7.789   114.508     0.200
     7.789   112.727     0.200
     7.835   118.594     0.200
     7.844   117.141     0.200
     8.125   121.031     0.200
     8.222   122.922     0.200
     8.232   123.219     0.200
     8.529   125.461     0.200
     8.529   122.719     0.200
     8.616   128.000     0.200
     8.707   125.320     0.200
     8.707   124.719     0.200
     8.715   129.750     0.200
     8.808   127.648     0.200
     8.999   131.992     0.200
     9.121   134.883     0.200
     9.192   132.367     0.200
     9.200   135.531     0.200
     9.200   132.234     0.200
     9.266   138.367     0.200
     9.253   136.062     0.200
     9.452   137.180     0.200
     9.452   134.914     0.200
     9.475   137.672     0.200
     9.764   139.375     0.200
    10.002   145.023     0.200
    10.290   146.844     0.200
    10.324   151.617     0.200
    10.373   151.117     0.200
    10.373   151.969     0.200
    10.466   153.172     0.200
    10.547   155.453     0.200
    10.554   156.234     0.200
    10.712   156.758     0.200
    10.712   152.156     0.200
    10.827   154.664     0.200
    10.828   155.812     0.200
    10.799   157.930     0.200
    10.799   154.805     0.200
    10.799   157.859     0.200
    10.799   157.312     0.200
    10.799   157.500     0.200
    10.884   158.805     0.200
    10.946   161.164     0.200
    10.972   161.367     0.200
    10.972   157.594     0.200
    11.040   160.820     0.200
    11.065   163.172     0.200
    11.159   159.609     0.200
    11.160   163.930     0.200
    11.196   164.953     0.200
    11.245   164.648     0.200
    11.335   166.273     0.200
    11.424   168.094     0.200
    11.518   168.031     0.200
    11.533   167.812     0.200
    11.569   164.828     0.200
    11.666   167.617     0.200
    11.659   170.562     0.200
    11.874   173.781     0.200
    11.949   174.328     0.200
    12.036   174.492     0.200
    12.147   177.609     0.200
    12.174   176.203     0.200
    12.201   178.562     0.200
    12.286   180.023     0.200
    12.514   183.711     0.200
    12.797   186.102     0.200
    12.900   188.617     0.200
    12.987   190.148     0.200
    13.009   188.750     0.200
    13.388   190.422     0.200
    13.603   198.078     0.200
    13.644   192.430     0.200
    13.680   198.641     0.200
    13.828   200.359     0.200
    13.897   201.289     0.200
    13.948   202.383     0.200
    14.038   199.820     0.200
    14.038   197.977     0.200
    14.250   201.023     0.200
    14.674   207.164     0.200
    14.725   211.883     0.200
    14.815   212.953     0.200
    15.255   219.133     0.200
    15.255   215.594     0.200
    15.306   216.594     0.200
    15.306   213.633     0.200
    15.382   218.859     0.200
    15.382   217.844     0.200
    15.426   218.570     0.200
    15.426   216.961     0.200
    15.595   221.438     0.200
    16.457   233.484     0.200
    16.457   230.391     0.200
    16.545   234.094     0.200
    16.545   230.648     0.200
    17.098   239.562     0.200
    17.621   247.680     0.200
    17.621   245.148     0.200
    17.691   245.852     0.200
    17.854   247.539     0.200
    17.885   247.758     0.200
    18.033   249.352     0.200
    18.068   252.703     0.200
    18.175   251.266     0.200
    18.327   253.148     0.200
    18.699   261.828     0.200
    19.409   268.594     0.200
    19.535   270.180     0.200
    20.336   279.062     0.200
     1.127    19.621     0.200
     1.111    19.352     0.200
     1.165    20.377     0.200
     1.189    21.031     0.200
     1.214    21.070     0.200
     1.320    22.469     0.200
     1.320    22.471     0.200
     1.491    24.758     0.200
     1.520    24.580     0.200
     1.675    27.973     0.200
     1.744    28.598     0.200
     1.721    28.305     0.200
     1.903    30.641     0.200
     1.889    30.889     0.200
     1.988    32.051     0.200
     2.131    34.230     0.200
     2.194    34.816     0.200
     2.305    36.230     0.200
     2.396    37.586     0.200
     2.407    38.432     0.200
     2.412    37.930     0.200
     2.433    37.635     0.200
     2.476    39.170     0.200
     2.488    38.830     0.200
     2.474    39.150     0.200
     2.523    39.035     0.200
     2.623    40.479     0.200
     2.550    38.490     0.200
     2.742    42.510     0.200
     2.917    44.875     0.200
     3.010    46.004     0.200
     3.077    48.211     0.200
     3.077    47.453     0.200
     3.127    47.627     0.200
     3.345    52.271     0.200
     3.345    50.207     0.200
     3.413    51.674     0.200
     3.431    51.832     0.200
     3.473    53.490     0.200
     3.548    53.645     0.200
     3.567    53.900     0.200
     3.567    53.779     0.200
     3.588    53.916     0.200
     3.645    55.131     0.200
     3.744    55.439     0.200
     3.686    55.881     0.200
     3.944    60.230     0.200
     3.984    59.773     0.200
     3.998    59.688     0.200
     4.046    60.473     0.200
     4.080    60.170     0.200
     4.080    59.969     0.200
     4.222    63.727     0.200
     4.247    64.900     0.200
     4.247    64.400     0.200
     4.332    65.375     0.200
     4.314    65.580     0.200
     4.391    66.682     0.200
     4.572    68.846     0.200
     4.727    71.811     0.200
     4.842    73.461     0.200
     4.890    73.031     0.200
     4.970    75.271     0.200
     5.130    77.941     0.200
     5.248    78.891     0.200
     5.312    78.061     0.200
     5.299    79.131     0.200
     5.299    78.959     0.200
     5.368    79.740     0.200
     5.367    84.111     0.200
     5.417    82.441     0.200
     5.653    84.570     0.200
     5.694    86.432     0.200
     5.785    85.900     0.200
     5.828    86.881     0.200
     5.828    86.355     0.200
     6.079    90.420     0.200
     6.109    90.641     0.200
     6.101    92.330     0.200
     6.109    91.191     0.200
     6.304    95.262     0.200
     6.346    94.102     0.200
     6.357    93.650     0.200
     6.872   103.250     0.200
     7.066   106.111     0.200
     7.071   103.141     0.200
     7.116   106.461     0.200
     7.116   105.238     0.200
     7.161   109.111     0.200
     7.295   108.580     0.200
     7.446   113.512     0.200
     7.472   112.730     0.200
     7.500   110.801     0.200
     7.487   110.670     0.200
     7.488   111.592     0.200
     7.502   112.410     0.200
     7.493   112.051     0.200
     7.494   111.791     0.200
     7.506   111.031     0.200
     7.513   111.631     0.200
     7.524   111.611     0.200
     7.533   111.941     0.200
     7.535   111.961     0.200
     7.538   111.910     0.200
     7.550   112.592     0.200
     7.570   112.471     0.200
     7.574   112.490     0.200
     7.604   113.061     0.200
     7.623   113.061     0.200
     7.641   115.271     0.200
     7.670   113.650     0.200
     7.759   114.691     0.200
     7.839   118.092     0.200
     7.850   119.000     0.200
     7.783   114.551     0.200
     7.842   116.740     0.200
     8.085   118.041     0.200
     8.125   121.471     0.200
     8.227   120.111     0.200
     8.221   122.762     0.200
     8.230   123.211     0.200
     8.512   123.330     0.200
     8.616   128.691     0.200
     8.714   129.920     0.200
     8.999   132.420     0.200
     9.120   134.830     0.200
     9.197   133.521     0.200
    10.323   152.031     0.200
    10.362   148.920     0.200
    10.378   154.129     0.200
    10.378   151.420     0.200
    10.551   153.471     0.200
    10.545   153.021     0.200
    10.556   157.092     0.200
    10.821   155.807     0.200
    10.946   161.160     0.200
    11.039   160.891     0.200
    11.064   162.670     0.200
    11.159   163.570     0.200
    11.201   164.820     0.200
    11.334   164.311     0.200
    11.537   169.811     0.200
    11.876   174.352     0.200
    11.981   174.480     0.200
    12.516   182.701     0.200
    12.721   184.621     0.200
    13.683   198.352     0.200
    13.703   199.451     0.200
     0.974    17.633     0.200
     0.976    17.527     0.200
     1.040    18.438     0.200
     1.087    19.172     0.200
     1.148    20.543     0.200
     1.196    20.797     0.200
     1.284    22.098     0.200
     1.468    24.492     0.200
     1.551    25.371     0.200
     1.764    28.750     0.200
     1.912    30.672     0.200
     1.968    31.672     0.200
     2.572    39.117     0.200
     3.726    58.141     0.200
     4.110    61.301     0.200
     4.110    60.902     0.200
     4.287    66.172     0.200
     4.930    74.410     0.200
     5.835    85.906     0.200
     6.588    95.820     0.200
     7.277   107.141     0.200
     7.823   117.840     0.200
    10.832   160.973     0.200
     0.926    19.243     0.200
     0.970    17.573     0.200
     0.968    17.418     0.200
     1.033    18.480     0.200
     1.084    19.313     0.200
     1.146    20.783     0.200
     1.170    20.583     0.200
     1.193    20.795     0.200
     1.277    22.063     0.200
     1.460    24.553     0.200
     1.558    25.493     0.200
     1.761    28.802     0.200
     1.759    28.988     0.200
     1.905    31.055     0.200
     1.921    31.286     0.200
     1.973    32.333     0.200
     2.107    34.266     0.200
     2.349    38.013     0.200
     2.395    37.169     0.200
     2.423    38.261     0.200
     2.486    39.683     0.200
     2.486    39.383     0.200
     2.511    40.293     0.200
     2.580    39.013     0.200
     2.580    39.279     0.200
     2.595    41.045     0.200
     2.724    42.787     0.200
     3.051    47.103     0.200
     3.494    54.463     0.200
     3.552    54.983     0.200
     3.642    56.203     0.200
     3.730    58.113     0.200
     3.955    61.143     0.200
     4.118    60.703     0.200
     4.290    66.163     0.200
     4.352    67.213     0.200
     4.423    67.783     0.200
     4.873    74.593     0.200
     4.935    74.393     0.200
     5.002    76.283     0.200
     5.165    79.443     0.200
     5.315    81.093     0.200
     5.346    81.663     0.200
     5.597    82.013     0.200
     5.678    85.563     0.200
     5.728    87.683     0.200
     5.828    89.343     0.200
     5.828    89.343     0.200
     6.346    94.543     0.200
     6.595    95.765     0.200
     6.643    97.603     0.200
     7.159   103.253     0.200
     7.283   107.583     0.200
     7.331   110.053     0.200
     7.499   110.623     0.200
     7.529   111.673     0.200
     7.510   109.013     0.200
     7.534   113.653     0.200
     7.553   114.413     0.200
     7.564   109.633     0.200
     7.575   113.613     0.200
     7.577   113.553     0.200
     7.591   114.423     0.200
     7.610   114.213     0.200
     7.614   114.663     0.200
     7.644   114.793     0.200
     7.710   115.233     0.200
     7.828   115.138     0.200
     7.828   116.053     0.200
     7.878   119.183     0.200
     8.251   121.193     0.200
     8.739   126.383     0.200
     8.739   125.803     0.200
     9.149   133.353     0.200
    10.352   154.073     0.200
    10.749   153.603     0.200
    10.855   155.333     0.200
    10.855   155.843     0.200
    10.856   155.843     0.200
    10.830   155.803     0.200
    10.830   154.783     0.200
    10.830   158.815     0.200
    10.830   157.493     0.200
    12.313   176.683     0.200
    12.539   179.483     0.200
    15.412   217.363     0.200
     0.766    14.312     0.200
     1.127    20.491     0.200
     1.319    23.211     0.200
     1.337    23.836     0.200
     1.378    24.092     0.200
     1.501    24.943     0.200
     1.671    26.941     0.200
     1.671    27.052     0.200
     1.650    29.302     0.200
     1.790    29.890     0.200
     1.805    29.701     0.200
     1.796    29.885     0.200
     1.845    30.153     0.200
     1.881    30.062     0.200
     1.871    31.236     0.200
     2.164    34.021     0.200
     2.246    35.846     0.200
     2.287    37.211     0.200
     2.312    37.292     0.200
     2.312    37.115     0.200
     2.320    37.329     0.200
     2.433    38.228     0.200
     2.536    40.708     0.200
     2.555    41.420     0.200
     2.697    43.011     0.200
     2.697    42.667     0.200
     2.873    45.336     0.200
     2.897    45.121     0.200
     2.919    45.042     0.200
     2.935    45.951     0.200
     2.959    46.953     0.200
     3.150    47.388     0.200
     3.181    49.427     0.200
     3.182    49.368     0.200
     3.415    51.721     0.200
     3.450    54.480     0.200
     3.607    57.241     0.200
     3.921    60.241     0.200
     3.921    60.379     0.200
     4.227    65.592     0.200
     4.299    65.021     0.200
     4.723    70.171     0.200
     4.723    70.022     0.200
     4.716    71.271     0.200
     4.751    71.941     0.200
     4.794    72.661     0.200
     4.794    72.424     0.200
     4.880    76.082     0.200
     4.914    74.381     0.200
     5.275    79.941     0.200
     5.351    80.524     0.200
     5.500    83.661     0.200
     5.515    82.421     0.200
     5.603    87.322     0.200
     5.852    87.104     0.200
     5.856    87.911     0.200
     6.040    91.451     0.200
     6.959   101.991     0.200
     7.206   104.720     0.200
     7.651   114.312     0.200
     7.651   112.819     0.200
     7.918   115.131     0.200
     7.968   120.391     0.200
     7.975   118.461     0.200
     7.974   118.771     0.200
     7.977   119.971     0.200
     7.984   118.562     0.200
     8.010   121.181     0.200
     8.016   119.261     0.200
     8.029   120.531     0.200
     8.042   121.881     0.200
     8.056   119.562     0.200
     8.084   119.871     0.200
     8.117   120.731     0.200
     8.134   121.062     0.200
     8.215   124.491     0.200
     8.230   124.221     0.200
     8.415   122.522     0.200
     9.347   134.287     0.200
     9.741   142.971     0.200
    11.096   164.911     0.200
     1.360    24.305     0.200
     1.395    25.609     0.200
     1.417    26.375     0.200
     1.542    27.109     0.200
     1.555    27.508     0.200
     1.555    27.383     0.200
     1.738    31.289     0.200
     1.833    33.188     0.200
     2.124    35.070     0.200
     2.182    36.734     0.200
     2.366    40.664     0.200
     2.482    40.383     0.200
     2.698    44.070     0.200
     2.694    43.141     0.200
     2.694    42.914     0.200
     2.714    44.734     0.200
     3.057    49.430     0.200
     3.057    48.633     0.200
     3.059    48.688     0.200
     3.194    50.344     0.200
     3.306    51.242     0.200
     3.292    52.133     0.200
     3.304    52.195     0.200
     3.819    59.016     0.200
     3.843    59.039     0.200
     3.956    61.469     0.200
     4.058    63.523     0.200
     4.144    64.789     0.200
     4.236    66.078     0.200
     4.442    68.125     0.200
     4.461    69.305     0.200
     4.493    69.656     0.200
     4.647    72.758     0.200
     4.854    74.617     0.200
     4.896    76.820     0.200
     4.896    75.023     0.200
     4.948    76.008     0.200
     5.147    77.867     0.200
     5.171    77.477     0.200
     5.318    80.867     0.200
     5.376    81.977     0.200
     5.419    82.484     0.200
     5.452    82.836     0.200
     5.553    85.141     0.200
     5.714    86.578     0.200
     5.941    89.398     0.200
     6.909   103.000     0.200
     7.189   107.086     0.200
     7.191   106.398     0.200
     7.195   106.477     0.200
     7.202   107.297     0.200
     7.203   107.461     0.200
     7.209   107.398     0.200
     7.210   106.961     0.200
     7.220   107.234     0.200
     7.235   107.445     0.200
     7.246   107.750     0.200
     7.256   108.023     0.200
     7.257   108.211     0.200
    10.201   150.031     0.200
    11.453   165.461     0.200
     1.023    18.781     0.200
     1.314    23.328     0.200
     1.379    25.594     0.200
     1.368    24.328     0.200
     1.481    25.141     0.200
     1.479    26.008     0.200
     1.629    27.062     0.200
     1.706    30.461     0.200
     1.849    30.672     0.200
     1.852    31.688     0.200
     1.858    31.383     0.200
     1.929    32.641     0.200
     2.058    35.898     0.200
     2.104    33.945     0.200
     2.190    35.141     0.200
     2.282    38.867     0.200
     2.344    38.219     0.200
     2.344    37.516     0.200
     2.447    39.133     0.200
     2.598    41.711     0.200
     2.615    43.414     0.200
     2.757    44.516     0.200
     2.757    43.984     0.200
     2.873    45.773     0.200
     3.088    46.742     0.200
     3.088    47.008     0.200
     3.233    52.719     0.200
     3.233    50.656     0.200
     3.942    62.094     0.200
     3.942    61.555     0.200
     4.253    65.125     0.200
     4.286    66.688     0.200
     4.662    70.344     0.200
     4.662    69.664     0.200
     4.704    71.867     0.200
     4.727    72.375     0.200
     4.757    72.578     0.200
     4.757    71.602     0.200
     5.120    78.695     0.200
     5.267    80.117     0.200
     5.367    80.914     0.200
     5.484    82.414     0.200
     5.671    85.664     0.200
     5.807    87.094     0.200
     5.858    87.875     0.200
     6.051    91.086     0.200
     6.127    90.703     0.200
     6.422    95.695     0.200
     7.147   104.492     0.200
     7.201   106.828     0.200
     7.617   114.477     0.200
     7.696   113.484     0.200
     7.724   114.156     0.200
     7.937   117.227     0.200
     7.941   117.438     0.200
     7.946   116.758     0.200
     7.950   116.148     0.200
     7.958   117.062     0.200
     7.971   117.398     0.200
     7.974   117.586     0.200
     7.983   118.016     0.200
     7.989   118.531     0.200
     8.001   117.664     0.200
     8.016   117.867     0.200
     8.028   120.945     0.200
     8.056   120.727     0.200
     8.088   119.594     0.200
     8.109   118.836     0.200
     8.365   120.547     0.200
    11.089   163.523     0.200
     0.968    18.047     0.200
     1.113    19.328     0.200
     1.211    21.426     0.200
     1.224    21.836     0.200
     1.274    21.914     0.200
     1.315    23.273     0.200
     1.452    23.617     0.200
     1.469    23.738     0.200
     1.432    24.641     0.200
     1.425    25.102     0.200
     1.499    26.566     0.200
     1.535    26.051     0.200
     1.571    27.668     0.200
     1.640    26.438     0.200
     1.640    26.617     0.200
     1.630    26.891     0.200
     1.717    28.594     0.200
     1.782    29.777     0.200
     1.857    28.305     0.200
     1.821    30.305     0.200
     1.803    30.445     0.200
     1.858    30.922     0.200
     1.922    32.246     0.200
     1.978    31.863     0.200
     1.967    32.355     0.200
     2.089    33.289     0.200
     2.168    35.668     0.200
     2.168    35.406     0.200
     2.200    36.012     0.200
     2.241    35.539     0.200
     2.387    36.277     0.200
     2.383    38.262     0.200
     2.530    40.531     0.200
     2.570    39.656     0.200
     2.570    40.316     0.200
     2.659    41.695     0.200
     2.680    41.703     0.200
     2.671    42.500     0.200
     2.706    43.105     0.200
     2.849    44.793     0.200
     2.918    44.605     0.200
     2.905    47.855     0.200
     2.962    46.383     0.200
     3.091    48.527     0.200
     3.170    49.746     0.200
     3.166    49.402     0.200
     3.203    50.379     0.200
     3.453    51.465     0.200
     3.423    52.996     0.200
     3.430    53.648     0.200
     3.549    55.492     0.200
     3.813    59.293     0.200
     3.821    57.465     0.200
     4.274    64.215     0.200
     4.373    66.348     0.200
     4.495    68.078     0.200
     4.536    68.043     0.200
     4.593    69.766     0.200
     4.579    70.457     0.200
     4.656    70.168     0.200
     4.656    70.473     0.200
     4.625    71.797     0.200
     4.756    71.977     0.200
     4.876    74.035     0.200
     4.930    71.527     0.200
     4.930    72.000     0.200
     4.916    73.988     0.200
     5.124    78.648     0.200
     5.124    77.828     0.200
     5.183    78.215     0.200
     5.366    81.027     0.200
     5.437    81.707     0.200
     5.507    81.797     0.200
     5.519    83.008     0.200
     5.528    84.758     0.200
     5.678    85.355     0.200
     5.702    85.836     0.200
     5.797    86.098     0.200
     5.899    89.008     0.200
     6.036    90.328     0.200
     6.078    91.305     0.200
     6.109    92.258     0.200
     6.274    94.105     0.200
     6.312    93.688     0.200
     6.440    93.258     0.200
     6.607    99.027     0.200
     6.883   102.516     0.200
     6.929   100.527     0.200
     6.959   102.715     0.200
     7.066   105.465     0.200
     7.173   103.836     0.200
     7.159   104.438     0.200
     7.259   106.668     0.200
     7.281   106.375     0.200
     7.281   107.762     0.200
     7.282   107.777     0.200
     7.282   107.953     0.200
     7.359   106.816     0.200
     7.330   108.086     0.200
     7.361   108.887     0.200
     7.351   107.457     0.200
     7.481   110.465     0.200
     7.481   110.262     0.200
     7.524   108.148     0.200
     7.558   111.266     0.200
     7.727   113.637     0.200
     7.729   114.086     0.200
     7.733   112.828     0.200
     7.741   113.898     0.200
     7.747   114.266     0.200
     7.748   114.227     0.200
     7.758   113.777     0.200
     7.773   114.387     0.200
     7.803   113.516     0.200
     7.784   114.355     0.200
     7.794   114.727     0.200
     7.796   114.996     0.200
     7.829   115.156     0.200
     7.828   115.207     0.200
     7.849   115.496     0.200
     7.885   116.035     0.200
     7.889   116.496     0.200
     7.898   116.215     0.200
     7.887   115.125     0.200
     7.927   114.797     0.200
     8.019   117.637     0.200
     7.999   118.277     0.200
     8.071   118.355     0.200
     8.093   118.336     0.200
     8.129   119.707     0.200
     8.213   118.727     0.200
     8.216   118.598     0.200
     8.413   121.965     0.200
     8.413   121.777     0.200
     8.413   122.621     0.200
     8.409   121.578     0.200
     8.402   121.285     0.200
     8.753   126.176     0.200
     8.854   126.637     0.200
     8.909   128.055     0.200
     8.909   130.570     0.200
     8.904   126.527     0.200
     9.066   129.766     0.200
     9.283   136.215     0.200
     9.331   134.785     0.200
     9.331   136.227     0.200
     9.457   134.816     0.200
     9.527   136.336     0.200
     9.514   134.746     0.200
     9.576   138.848     0.200
     9.832   141.902     0.200
     9.873   143.477     0.200
     9.873   142.070     0.200
     9.999   143.168     0.200
    10.153   145.285     0.200
    10.159   146.586     0.200
    10.159   145.812     0.200
    10.267   147.375     0.200
    10.303   146.527     0.200
    10.443   149.566     0.200
    10.492   152.016     0.200
    10.492   150.113     0.200
    10.562   150.727     0.200
    10.633   151.305     0.200
    10.667   151.359     0.200
    10.714   153.047     0.200
    10.715   151.746     0.200
    10.715   155.812     0.200
    10.736   152.953     0.200
    10.769   153.906     0.200
    10.771   152.543     0.200
    10.812   154.176     0.200
    10.853   156.348     0.200
    11.159   159.348     0.200
    11.260   159.082     0.200
    11.266   160.117     0.200
    11.414   163.277     0.200
    11.414   161.625     0.200
    11.450   162.293     0.200
    11.496   163.480     0.200
    11.700   167.488     0.200
    11.701   167.305     0.200
    11.925   169.738     0.200
    12.014   171.945     0.200
    12.018   170.047     0.200
    12.322   177.766     0.200
    12.322   173.863     0.200
    12.292   173.621     0.200
    12.801   184.109     0.200
    12.854   185.141     0.200
    12.933   185.344     0.200
    13.436   191.027     0.200
    13.675   193.996     0.200
    13.675   192.445     0.200
    13.830   196.375     0.200
    14.091   198.258     0.200
    14.141   199.797     0.200
    14.141   200.078     0.200
    14.284   200.898     0.200
    14.337   202.715     0.200
    14.464   204.125     0.200
    14.464   205.348     0.200
    14.460   205.969     0.200
    14.508   205.008     0.200
    14.508   205.680     0.200
    14.705   207.266     0.200
    14.705   207.809     0.200
    14.742   209.148     0.200
    14.742   210.684     0.200
    14.773   207.484     0.200
    14.871   210.176     0.200
    14.983   211.688     0.200
    15.328   217.074     0.200
    15.349   216.965     0.200
    15.349   217.285     0.200
    15.538   218.438     0.200
    15.646   219.578     0.200
    15.890   223.586     0.200
    15.998   224.496     0.200
    16.071   224.934     0.200
    16.226   227.195     0.200
    16.522   231.043     0.200
    16.940   236.938     0.200
    16.940   236.777     0.200
    17.168   238.828     0.200
    17.168   239.801     0.200
    17.411   242.840     0.200
    17.518   242.797     0.200
    17.543   245.027     0.200
    17.543   244.477     0.200
    17.538   242.305     0.200
    17.908   246.996     0.200
    18.525   257.125     0.200
    19.760   270.527     0.200
     0.815    15.250     0.200
     0.854    15.961     0.200
     0.897    16.805     0.200
     1.330    24.516     0.200
     1.439    23.961     0.200
     1.439    24.070     0.200
     1.443    25.141     0.200
     1.514    27.266     0.200
     1.585    27.961     0.200
     1.634    26.969     0.200
     1.638    28.055     0.200
     1.825    31.031     0.200
     1.820    31.031     0.200
     1.982    32.359     0.200
     1.981    32.992     0.200
     2.088    33.812     0.200
     2.218    37.086     0.200
     2.399    39.039     0.200
     2.588    41.461     0.200
     2.589    41.469     0.200
     2.662    42.109     0.200
     2.689    43.203     0.200
     2.724    42.148     0.200
     2.724    43.273     0.200
     2.923    47.656     0.200
     3.106    48.742     0.200
     3.183    50.609     0.200
     3.221    50.797     0.200
     3.438    53.031     0.200
     3.445    54.344     0.200
     3.445    54.227     0.200
     4.270    64.516     0.200
     4.381    66.875     0.200
     4.499    68.539     0.200
     4.600    70.320     0.200
     4.597    69.898     0.200
     4.656    71.281     0.200
     4.656    71.484     0.200
     4.765    73.547     0.200
     4.918    72.516     0.200
     4.890    73.547     0.200
     4.925    73.781     0.200
     5.110    78.305     0.200
     5.141    78.367     0.200
     5.141    79.086     0.200
     5.190    78.930     0.200
     5.383    80.109     0.200
     5.448    82.234     0.200
     5.502    81.516     0.200
     5.537    80.531     0.200
     5.710    84.930     0.200
     5.696    84.359     0.200
     5.917    88.094     0.200
     6.046    89.336     0.200
     6.087    90.398     0.200
     6.127    93.578     0.200
     7.349   106.883     0.200
     7.483   108.320     0.200
     8.207   119.656     0.200
     9.516   136.648     0.200
    10.725   158.375     0.200
    11.688   167.891     0.200
     1.312    22.689     0.200
     1.394    23.964     0.200
     1.599    27.949     0.200
     1.563    26.261     0.200
     1.744    29.040     0.200
     2.276    38.029     0.200
     2.287    39.559     0.200
     2.308    39.419     0.200
     2.350    39.309     0.200
     3.299    52.629     0.200
     3.408    54.469     0.200
     3.468    55.049     0.200
     3.657    56.549     0.200
     4.150    62.839     0.200
     4.175    64.069     0.200
     4.198    64.539     0.200
     4.246    64.689     0.200
     4.417    67.639     0.200
     4.822    73.259     0.200
     4.997    77.349     0.200
     5.120    76.769     0.200
     5.212    78.409     0.200
     5.488    82.969     0.200
     5.966    89.879     0.200
     7.040   103.609     0.200
     7.167   106.159     0.200
     7.311   108.449     0.200
     7.387   108.459     0.200
     7.392   108.359     0.200
     7.392   108.379     0.200
     7.395   108.559     0.200
     7.404   108.669     0.200
     7.411   109.729     0.200
     7.423   108.959     0.200
     7.433   109.409     0.200
     7.432   108.779     0.200
     7.436   109.449     0.200
     7.451   109.329     0.200
     7.473   109.479     0.200
     7.471   109.779     0.200
     7.494   109.919     0.200
     7.505   109.919     0.200
     7.529   110.709     0.200
     7.518   110.479     0.200
     7.565   110.609     0.200
     7.657   111.859     0.200
     7.676   111.859     0.200
     7.772   112.949     0.200
     9.155   132.549     0.200
    13.929   198.299     0.200
    14.036   199.179     0.200
     1.256    22.785     0.200
     1.385    25.906     0.200
     1.499    27.422     0.200
     1.736    28.676     0.200
     1.749    29.824     0.200
     1.865    33.406     0.200
     1.860    31.949     0.200
     2.146    37.238     0.200
     2.198    38.707     0.200
     2.375    39.195     0.200
     2.376    39.918     0.200
     2.812    48.176     0.200
     3.250    53.438     0.200
     3.276    53.516     0.200
     3.353    55.578     0.200
     3.753    59.188     0.200
     3.681    58.496     0.200
     4.285    65.168     0.200
     4.242    64.059     0.200
     4.229    65.578     0.200
     4.245    65.355     0.200
     4.679    71.648     0.200
     4.817    73.766     0.200
     4.973    75.188     0.200
     5.302    80.918     0.200
     5.458    83.988     0.200
     5.560    85.578     0.200
     5.540    84.879     0.200
     5.540    84.883     0.200
     5.789    84.406     0.200
     5.948    89.496     0.200
    10.645   156.508     0.200
    11.050   157.562     0.200
     1.004    18.773     0.200
     1.031    18.453     0.200
     1.263    22.156     0.200
     1.263    22.281     0.200
     1.278    22.164     0.200
     1.541    26.055     0.200
     1.644    26.656     0.200
     1.687    27.711     0.200
     1.886    32.492     0.200
     1.954    32.047     0.200
     2.193    35.242     0.200
     2.194    35.664     0.200
     2.240    37.945     0.200
     2.271    36.250     0.200
     2.309    36.656     0.200
     2.315    38.242     0.200
     2.358    38.266     0.200
     2.452    38.641     0.200
     2.710    41.641     0.200
     2.906    47.820     0.200
     3.197    49.055     0.200
     3.254    50.891     0.200
     3.282    51.906     0.200
     3.364    51.305     0.200
     3.430    54.203     0.200
     3.688    56.453     0.200
     3.734    58.844     0.200
     3.734    57.648     0.200
     4.195    63.070     0.200
     4.195    63.531     0.200
     4.197    64.570     0.200
     4.197    65.023     0.200
     4.208    64.375     0.200
     4.245    65.156     0.200
     4.420    67.852     0.200
     4.686    71.562     0.200
     4.820    74.055     0.200
     4.905    73.844     0.200
     5.000    75.281     0.200
     5.098    76.305     0.200
     5.153    77.859     0.200
     5.204    79.453     0.200
     5.241    79.281     0.200
     5.478    82.773     0.200
     5.556    83.070     0.200
     5.697    83.492     0.200
     5.951    88.391     0.200
     5.965    87.891     0.200
     6.130    91.102     0.200
     6.646    96.320     0.200
     6.656    98.820     0.200
     7.060   105.000     0.200
     7.170   106.664     0.200
     7.171   105.023     0.200
     7.186   106.336     0.200
     7.282   106.844     0.200
     7.369   108.922     0.200
     7.401   110.242     0.200
     7.407   107.664     0.200
     7.406   109.680     0.200
     7.424   110.000     0.200
     7.436   108.391     0.200
     7.445   111.164     0.200
     7.447   108.852     0.200
     7.465   111.031     0.200
     7.484   110.445     0.200
     7.488   112.344     0.200
     7.545   110.477     0.200
     7.567   111.125     0.200
     7.578   113.250     0.200
     7.670   112.375     0.200
     7.690   112.430     0.200
     7.806   117.375     0.200
     7.949   119.977     0.200
     8.077   117.766     0.200
     8.804   125.977     0.200
    10.160   146.336     0.200
    10.649   153.281     0.200
    10.649   157.734     0.200
    10.958   157.914     0.200
    10.958   157.906     0.200
     1.009    19.088     0.200
     1.062    19.354     0.200
     1.312    22.547     0.200
     1.377    24.014     0.200
     1.474    25.213     0.200
     1.552    26.203     0.200
     1.609    26.387     0.200
     1.609    26.223     0.200
     1.630    28.141     0.200
     1.638    28.713     0.200
     1.695    28.334     0.200
     1.704    29.463     0.200
     1.847    30.445     0.200
     1.974    32.578     0.200
     2.279    35.043     0.200
     2.311    39.002     0.200
     2.543    40.369     0.200
     2.627    41.529     0.200
     2.627    41.652     0.200
     2.710    42.623     0.200
     2.847    44.693     0.200
     2.884    44.793     0.200
     2.876    47.592     0.200
     3.081    50.773     0.200
     3.325    49.320     0.200
     3.304    51.893     0.200
     3.567    55.020     0.200
     3.590    55.156     0.200
     4.674    70.867     0.200
     4.680    71.262     0.200
     4.832    70.594     0.200
     4.832    70.473     0.200
     5.018    75.553     0.200
     5.269    80.312     0.200
     5.267    79.842     0.200
     5.480    81.672     0.200
     6.975   106.203     0.200
     7.280   105.273     0.200
     7.280   106.432     0.200
     7.513   113.113     0.200
     7.884   114.783     0.200
     8.170   118.973     0.200
     8.938   132.992     0.200
     9.440   135.883     0.200
    11.590   167.922     0.200
    13.453   196.453     0.200
     0.742    14.181     0.200
     0.757    14.871     0.200
     0.783    15.921     0.200
     0.842    15.721     0.200
     0.834    15.381     0.200
     0.807    15.381     0.200
     0.844    15.678     0.200
     0.820    15.440     0.200
     0.830    16.771     0.200
     0.833    15.991     0.200
     0.879    16.301     0.200
     0.918    16.443     0.200
     0.918    16.570     0.200
     0.918    16.451     0.200
     0.967    17.951     0.200
     0.975    18.541     0.200
     1.024    18.880     0.200
     0.985    18.211     0.200
     1.002    18.811     0.200
     1.013    18.511     0.200
     1.029    18.881     0.200
     1.066    18.661     0.200
     1.090    19.881     0.200
     1.063    19.511     0.200
     1.069    20.256     0.200
     1.094    20.354     0.200
     1.151    20.421     0.200
     1.124    20.911     0.200
     1.156    21.461     0.200
     1.184    21.331     0.200
     1.207    22.116     0.200
     1.271    22.440     0.200
     1.258    22.461     0.200
     1.259    22.550     0.200
     1.291    22.561     0.200
     1.361    24.667     0.200
     1.418    26.341     0.200
     1.470    25.484     0.200
     1.502    26.655     0.200
     1.502    26.860     0.200
     1.544    26.678     0.200
     1.569    26.183     0.200
     1.653    28.947     0.200
     1.653    29.131     0.200
     1.768    30.446     0.200
     1.849    31.163     0.200
     1.949    32.851     0.200
     1.954    31.131     0.200
     1.954    31.411     0.200
     1.994    32.681     0.200
     2.017    33.606     0.200
     2.182    34.841     0.200
     2.171    35.882     0.200
     2.193    35.422     0.200
     2.224    36.563     0.200
     2.224    36.701     0.200
     2.287    37.677     0.200
     2.779    44.825     0.200
     2.869    45.211     0.200
     2.886    44.110     0.200
     3.036    47.820     0.200
     3.082    48.421     0.200
     3.195    50.773     0.200
     3.195    50.061     0.200
     3.201    51.379     0.200
     3.473    51.121     0.200
     3.305    51.791     0.200
     3.925    59.811     0.200
     3.965    59.171     0.200
     3.965    59.471     0.200
     4.425    66.780     0.200
     4.606    69.581     0.200
     4.640    69.671     0.200
     4.653    69.811     0.200
     4.672    70.201     0.200
     4.675    70.320     0.200
     4.715    71.030     0.200
     4.738    71.411     0.200
     4.761    71.400     0.200
     4.930    74.850     0.200
     4.930    73.511     0.200
     4.973    74.591     0.200
     5.044    75.521     0.200
     5.261    78.201     0.200
     5.314    79.221     0.200
     5.415    79.040     0.200
     5.482    81.561     0.200
     5.680    84.070     0.200
     6.130    89.637     0.200
     6.130    90.201     0.200
     7.817   113.237     0.200
     9.994   142.776     0.200
     1.040    18.963     0.200
     1.041    18.941     0.200
     1.057    19.152     0.200
     1.088    19.332     0.200
     1.094    19.941     0.200
     1.141    20.131     0.200
     1.200    21.152     0.200
     1.205    21.162     0.200
     1.245    22.242     0.200
     1.261    22.221     0.200
     1.264    21.971     0.200
     1.270    22.162     0.200
     1.354    23.361     0.200
     1.505    26.441     0.200
     1.524    25.951     0.200
     1.524    26.512     0.200
     1.571    27.232     0.200
     1.584    26.742     0.200
     1.589    26.598     0.200
     1.589    27.902     0.200
     1.610    27.012     0.200
     1.654    27.602     0.200
     1.739    28.594     0.200
     1.776    29.416     0.200
     1.998    32.512     0.200
     2.008    33.471     0.200
     2.034    33.029     0.200
     2.144    35.551     0.200
     2.282    37.842     0.200
     2.324    36.768     0.200
     2.354    37.041     0.200
     2.355    40.461     0.200
     2.382    38.822     0.200
     2.444    37.621     0.200
     2.470    39.010     0.200
     2.596    40.613     0.200
     2.669    40.965     0.200
     2.669    41.391     0.200
     2.852    44.264     0.200
     2.949    45.496     0.200
     3.250    49.660     0.200
     3.277    51.482     0.200
     3.327    52.172     0.200
     3.414    51.766     0.200
     3.684    57.691     0.200
     3.784    59.582     0.200
     4.058    60.764     0.200
     4.164    63.391     0.200
     4.205    64.971     0.200
     4.230    65.721     0.200
     4.230    65.422     0.200
     4.278    64.922     0.200
     4.450    68.412     0.200
     4.590    71.402     0.200
     4.722    72.172     0.200
     4.854    74.551     0.200
     4.898    73.941     0.200
     5.029    78.311     0.200
     5.146    75.686     0.200
     5.146    78.131     0.200
     5.229    80.682     0.200
     5.239    79.471     0.200
     5.256    80.182     0.200
     5.518    81.982     0.200
     5.587    86.371     0.200
     5.664    84.447     0.200
     5.977    91.352     0.200
     5.986    87.652     0.200
     5.997    91.492     0.200
     6.621    96.137     0.200
     6.621    97.521     0.200
     7.268   106.641     0.200
     7.468   111.861     0.200
     7.503   112.701     0.200
     7.537   112.912     0.200
     7.545   110.416     0.200
     7.798   115.242     0.200
     7.798   115.891     0.200
     8.776   127.721     0.200
    10.683   156.471     0.200
    10.819   156.381     0.200
    10.922   157.096     0.200
     1.234    24.194     0.200
     1.327    23.924     0.200
     1.336    23.674     0.200
     1.359    24.094     0.200
     1.375    24.489     0.200
     1.384    25.082     0.200
     1.384    25.464     0.200
     1.416    25.074     0.200
     1.435    25.271     0.200
     1.443    26.574     0.200
     1.478    26.074     0.200
     1.483    26.674     0.200
     1.503    26.414     0.200
     1.575    27.664     0.200
     1.611    27.403     0.200
     1.629    29.484     0.200
     1.707    30.794     0.200
     1.804    31.924     0.200
     1.878    31.555     0.200
     1.896    33.781     0.200
     1.923    32.364     0.200
     1.973    32.972     0.200
     2.057    34.093     0.200
     2.057    33.987     0.200
     2.120    35.174     0.200
     2.126    36.484     0.200
     2.331    39.384     0.200
     2.435    39.471     0.200
     2.649    43.644     0.200
     2.665    43.164     0.200
     2.919    47.584     0.200
     3.015    48.394     0.200
     3.245    51.604     0.200
     3.349    51.314     0.200
     3.558    56.134     0.200
     3.823    59.654     0.200
     3.906    61.004     0.200
     4.041    62.744     0.200
     4.149    64.334     0.200
     4.212    65.054     0.200
     4.245    65.434     0.200
     4.395    67.594     0.200
     4.422    67.854     0.200
     4.690    69.437     0.200
     4.752    72.234     0.200
     4.808    73.204     0.200
     4.849    73.977     0.200
     4.849    73.724     0.200
     4.917    74.694     0.200
     5.100    77.164     0.200
     5.152    77.934     0.200
     5.239    78.084     0.200
     5.373    80.844     0.200
     5.894    88.124     0.200
     6.829   101.784     0.200
     6.829   100.944     0.200
     6.976   104.564     0.200
     7.049   103.559     0.200
     7.049   103.864     0.200
     7.183   105.134     0.200
     7.203   105.964     0.200
     7.304   107.474     0.200
     7.974   117.179     0.200
     7.974   116.564     0.200
     9.235   133.684     0.200
    10.176   149.871     0.200
    11.490   165.784     0.200
    11.490   164.964     0.200
     1.242    22.918     0.200
     1.347    24.141     0.200
     1.364    24.680     0.200
     1.371    25.723     0.200
     1.385    25.691     0.200
     1.385    25.336     0.200
     1.405    24.980     0.200
     1.431    26.641     0.200
     1.444    25.422     0.200
     1.483    27.332     0.200
     1.515    26.641     0.200
     1.518    26.742     0.200
     1.580    28.473     0.200
     1.610    28.121     0.200
     1.669    30.082     0.200
     1.688    29.352     0.200
     1.703    30.992     0.200
     1.707    31.191     0.200
     1.804    31.992     0.200
     1.911    32.289     0.200
     1.940    33.320     0.200
     1.985    33.320     0.200
     2.065    34.395     0.200
     2.128    35.051     0.200
     2.445    39.730     0.200
     2.630    42.438     0.200
     2.656    42.711     0.200
     2.677    43.359     0.200
     3.027    48.652     0.200
     3.256    51.867     0.200
     3.343    51.281     0.200
     3.570    56.340     0.200
     3.834    59.832     0.200
     4.051    63.129     0.200
     4.224    65.531     0.200
     4.434    68.191     0.200
     4.434    67.949     0.200
     4.455    69.980     0.200
     4.641    71.020     0.200
     4.688    69.602     0.200
     4.762    73.180     0.200
     4.818    73.820     0.200
     4.860    74.586     0.200
     4.860    73.801     0.200
     4.929    75.270     0.200
     5.077    77.660     0.200
     5.110    77.820     0.200
     5.384    81.820     0.200
     6.842   102.070     0.200
     7.049   104.121     0.200
     7.978   116.652     0.200
    10.188   150.152     0.200
    11.487   165.402     0.200
     0.881    16.099     0.200
     1.077    19.113     0.200
     1.165    20.229     0.200
     1.250    21.488     0.200
     1.250    21.528     0.200
     1.269    22.068     0.200
     1.348    24.379     0.200
     1.452    24.358     0.200
     1.549    26.549     0.200
     1.559    25.828     0.200
     1.565    25.929     0.200
     1.565    26.788     0.200
     1.635    25.578     0.200
     1.857    31.009     0.200
     1.984    32.101     0.200
     1.994    32.599     0.200
     2.120    34.209     0.200
     2.158    34.898     0.200
     2.403    37.828     0.200
     2.265    36.919     0.200
     2.337    38.669     0.200
     2.343    38.059     0.200
     2.423    40.129     0.200
     2.589    40.229     0.200
     2.686    40.309     0.200
     2.934    46.028     0.200
     3.246    50.639     0.200
     3.258    49.254     0.200
     3.357    51.879     0.200
     3.412    51.639     0.200
     3.412    51.176     0.200
     3.724    57.358     0.200
     3.806    57.898     0.200
     3.806    58.055     0.200
     4.191    61.969     0.200
     4.191    61.318     0.200
     4.247    65.038     0.200
     4.260    65.068     0.200
     4.272    65.738     0.200
     4.316    65.688     0.200
     4.489    68.389     0.200
     4.579    69.778     0.200
     4.759    72.398     0.200
     4.892    74.368     0.200
     4.937    73.898     0.200
     5.219    78.618     0.200
     5.280    79.599     0.200
     5.552    83.108     0.200
     5.685    82.709     0.200
     5.677    86.754     0.200
     5.677    84.839     0.200
     5.927    89.578     0.200
     5.919    86.969     0.200
     6.149    92.129     0.200
     6.198    92.108     0.200
     6.492    96.979     0.200
     6.652    97.269     0.200
     6.652    96.394     0.200
     6.717    99.438     0.200
     6.911   102.669     0.200
     6.916   103.068     0.200
     7.186   106.469     0.200
     7.199   105.898     0.200
     7.377   109.158     0.200
     7.562   111.389     0.200
     7.572   112.174     0.200
     7.836   114.248     0.200
     7.836   113.979     0.200
    10.721   157.968     0.200
    10.721   153.809     0.200
    10.946   156.951     0.200
    10.946   156.438     0.200
    14.602   206.938     0.200
     0.792    14.984     0.200
     0.902    17.094     0.200
     1.059    18.969     0.200
     1.097    20.273     0.200
     1.002    18.586     0.200
     1.051    18.914     0.200
     1.211    21.680     0.200
     1.233    21.844     0.200
     1.158    20.812     0.200
     1.348    23.523     0.200
     1.348    23.172     0.200
     1.756    29.266     0.200
     1.932    30.172     0.200
     2.014    32.484     0.200
     2.275    36.320     0.200
     2.738    43.289     0.200
     2.758    44.070     0.200
     2.936    45.953     0.200
     2.936    45.641     0.200
     3.059    46.336     0.200
     3.059    46.641     0.200
     3.188    50.141     0.200
     3.188    49.594     0.200
     3.617    55.281     0.200
     3.659    56.781     0.200
     3.810    58.805     0.200
     3.863    59.602     0.200
     3.988    60.852     0.200
     4.008    61.844     0.200
     4.226    64.742     0.200
     4.372    66.883     0.200
     4.407    64.594     0.200
     4.559    69.156     0.200
     4.595    71.109     0.200
     4.817    71.984     0.200
     4.852    73.055     0.200
     4.993    75.234     0.200
     5.038    75.516     0.200
     5.083    75.984     0.200
     5.083    77.445     0.200
     5.134    78.492     0.200
     5.131    77.281     0.200
     5.336    81.695     0.200
     5.594    84.531     0.200
     5.951    87.625     0.200
     6.780    98.953     0.200
     6.780    98.672     0.200
     6.774    99.227     0.200
     6.961   103.906     0.200
     6.961   102.430     0.200
     7.105   103.953     0.200
     7.379   108.953     0.200
     7.573   111.883     0.200
     8.963   128.484     0.200
    10.195   151.930     0.200
    11.204   160.633     0.200
    11.204   160.727     0.200
    11.204   159.711     0.200
     0.910    17.156     0.200
     0.979    18.031     0.200
     0.996    18.094     0.200
     1.089    18.883     0.200
     1.089    18.984     0.200
     1.088    19.363     0.200
     1.189    20.988     0.200
     1.225    21.781     0.200
     1.297    22.504     0.200
     1.285    22.918     0.200
     1.310    22.531     0.200
     1.334    23.414     0.200
     1.372    22.582     0.200
     1.384    23.398     0.200
     1.415    24.004     0.200
     1.459    25.113     0.200
     1.470    24.617     0.200
     1.468    24.129     0.200
     1.524    26.102     0.200
     1.644    27.664     0.200
     1.644    27.883     0.200
     1.642    28.062     0.200
     1.693    28.227     0.200
     1.671    27.773     0.200
     1.804    28.672     0.200
     1.956    31.371     0.200
     1.970    32.254     0.200
     1.994    32.621     0.200
     1.995    32.602     0.200
     2.043    32.273     0.200
     2.048    32.609     0.200
     2.102    34.324     0.200
     2.132    34.352     0.200
     2.132    34.566     0.200
     2.142    34.727     0.200
     2.222    35.672     0.200
     2.306    36.051     0.200
     2.306    36.199     0.200
     2.495    39.242     0.200
     2.579    40.645     0.200
     2.593    41.156     0.200
     2.651    42.328     0.200
     2.732    43.031     0.200
     2.905    45.582     0.200
     3.022    47.461     0.200
     3.047    48.086     0.200
     3.108    47.699     0.200
     3.236    48.973     0.200
     3.270    49.434     0.200
     3.267    51.215     0.200
     3.572    51.492     0.200
     3.747    57.941     0.200
     3.908    58.781     0.200
     3.978    59.203     0.200
     3.978    59.355     0.200
     4.020    62.484     0.200
     4.108    62.852     0.200
     4.257    64.434     0.200
     4.469    68.992     0.200
     4.501    67.812     0.200
     4.500    67.484     0.200
     4.500    68.023     0.200
     4.508    67.973     0.200
     4.545    68.051     0.200
     4.571    69.703     0.200
     4.588    69.352     0.200
     4.596    70.164     0.200
     4.596    70.301     0.200
     4.648    69.453     0.200
     4.765    71.773     0.200
     4.804    71.812     0.200
     4.804    72.430     0.200
     4.833    73.562     0.200
     4.947    74.273     0.200
     5.166    77.801     0.200
     5.179    77.641     0.200
     5.352    81.582     0.200
     5.431    79.824     0.200
     5.579    83.973     0.200
     5.782    85.922     0.200
     6.022    89.242     0.200
     6.688    98.914     0.200
     6.894   102.164     0.200
     7.021   102.887     0.200
     7.767   112.422     0.200
     8.679   127.758     0.200
     8.679   125.242     0.200
     9.009   131.762     0.200
     9.950   141.641     0.200
     9.950   142.109     0.200
    10.502   153.629     0.200
    10.502   154.312     0.200
    10.502   151.934     0.200
    12.180   174.211     0.200
    15.071   210.344     0.200
     1.142    20.844     0.200
     1.142    20.535     0.200
     1.281    22.859     0.200
     1.298    22.344     0.200
     1.416    23.275     0.200
     1.385    24.369     0.200
     1.415    23.645     0.200
     1.415    23.445     0.200
     1.415    23.305     0.200
     1.463    24.424     0.200
     1.475    24.064     0.200
     1.489    25.514     0.200
     1.498    26.436     0.200
     1.563    25.924     0.200
     1.582    27.475     0.200
     1.582    27.365     0.200
     1.563    26.418     0.200
     1.622    25.744     0.200
     1.622    25.895     0.200
     1.617    28.625     0.200
     1.636    26.814     0.200
     1.645    27.094     0.200
     1.766    28.414     0.200
     1.788    28.375     0.200
     1.764    29.314     0.200
     1.819    30.219     0.200
     1.830    28.775     0.200
     1.876    31.855     0.200
     1.876    31.494     0.200
     1.922    31.785     0.200
     2.012    32.369     0.200
     2.033    33.195     0.200
     2.118    35.105     0.200
     2.102    33.594     0.200
     2.142    35.514     0.200
     2.220    36.121     0.200
     2.294    35.455     0.200
     2.271    36.930     0.200
     2.350    36.436     0.200
     2.453    39.227     0.200
     2.533    40.055     0.200
     2.538    40.035     0.200
     2.581    40.484     0.200
     2.589    41.320     0.200
     2.689    41.834     0.200
     2.712    41.824     0.200
     2.933    42.574     0.200
     2.933    42.045     0.200
     2.741    43.395     0.200
     2.744    43.445     0.200
     2.773    43.975     0.200
     2.773    43.719     0.200
     2.874    46.094     0.200
     2.890    45.209     0.200
     2.914    44.834     0.200
     3.035    47.395     0.200
     3.139    48.801     0.200
     3.230    49.781     0.200
     3.232    50.674     0.200
     3.275    50.844     0.200
     3.407    50.664     0.200
     3.407    50.859     0.200
     3.476    53.594     0.200
     3.500    55.045     0.200
     3.500    54.688     0.200
     3.622    56.225     0.200
     3.622    56.521     0.200
     3.748    57.797     0.200
     3.877    59.555     0.200
     3.885    59.977     0.200
     4.115    63.234     0.200
     4.230    64.686     0.200
     4.275    64.275     0.200
     4.421    66.834     0.200
     4.523    68.725     0.200
     4.530    68.715     0.200
     4.575    67.025     0.200
     4.608    70.500     0.200
     4.651    71.064     0.200
     4.674    71.355     0.200
     4.674    70.643     0.200
     4.697    72.264     0.200
     4.809    72.164     0.200
     4.898    72.014     0.200
     4.898    72.248     0.200
     4.895    73.984     0.200
     4.944    74.084     0.200
     4.944    74.480     0.200
     4.967    74.904     0.200
     5.078    77.094     0.200
     5.123    76.344     0.200
     5.166    77.875     0.200
     5.197    79.605     0.200
     5.197    77.725     0.200
     5.228    78.615     0.200
     5.268    79.105     0.200
     5.411    81.795     0.200
     5.439    81.754     0.200
     5.506    81.754     0.200
     5.497    82.494     0.200
     5.588    83.514     0.200
     5.750    87.355     0.200
     5.752    86.025     0.200
     5.803    86.125     0.200
     5.803    86.270     0.200
     5.972    90.064     0.200
     6.089    91.174     0.200
     7.336   106.949     0.200
     7.340   108.121     0.200
     7.351   109.174     0.200
     7.505   110.113     0.200
     7.700   112.074     0.200
     7.767   113.154     0.200
     7.960   115.834     0.200
     7.960   116.279     0.200
     8.103   118.334     0.200
     8.206   118.924     0.200
     8.413   123.094     0.200
     8.413   122.494     0.200
     8.413   122.975     0.200
     8.931   130.646     0.200
     9.372   136.721     0.200
     9.500   135.717     0.200
     9.546   138.404     0.200
     9.647   144.422     0.200
     9.892   143.664     0.200
     9.892   143.836     0.200
     9.904   145.873     0.200
    10.227   150.260     0.200
    10.329   150.582     0.200
    10.506   152.195     0.200
    10.659   155.738     0.200
    10.751   153.795     0.200
    10.739   155.014     0.200
    10.767   155.867     0.200
    10.769   157.584     0.200
    10.769   158.861     0.200
    11.015   158.965     0.200
    11.197   163.227     0.200
    11.337   165.232     0.200
    11.405   164.449     0.200
    11.568   168.168     0.200
    11.663   167.205     0.200
    11.664   167.406     0.200
    11.664   167.064     0.200
    11.848   173.117     0.200
    12.060   173.264     0.200
    12.060   172.996     0.200
    12.104   173.959     0.200
    12.318   176.527     0.200
    12.462   179.570     0.200
    12.690   185.205     0.200
    12.873   187.348     0.200
    12.912   187.420     0.200
    13.505   196.205     0.200
    13.704   195.738     0.200
    14.126   201.145     0.200
    14.382   203.885     0.200
    14.382   203.572     0.200
    14.438   204.082     0.200
    14.525   203.936     0.200
    14.701   208.635     0.200
    14.814   211.418     0.200
    14.944   212.961     0.200
    15.351   217.312     0.200
    15.503   217.324     0.200
    16.054   226.354     0.200
    16.203   226.910     0.200
    16.547   232.885     0.200
    16.798   235.504     0.200
    16.955   238.035     0.200
    17.169   239.771     0.200
    17.430   243.834     0.200
    17.449   243.520     0.200
    17.513   244.785     0.200
    17.599   246.043     0.200
    17.778   247.814     0.200
    18.139   252.164     0.200
    18.434   255.912     0.200
    18.995   263.324     0.200
    19.561   268.936     0.200
    19.750   272.051     0.200
    20.543   282.475     0.200
     1.067    18.867     0.200
     1.064    18.664     0.200
     1.078    18.859     0.200
     1.126    20.141     0.200
     1.176    20.867     0.200
     1.168    20.359     0.200
     1.192    20.938     0.200
     1.233    21.242     0.200
     1.282    22.031     0.200
     1.323    23.297     0.200
     1.434    24.867     0.200
     1.434    24.992     0.200
     1.486    24.633     0.200
     1.544    24.922     0.200
     1.567    24.891     0.200
     1.682    27.531     0.200
     1.804    29.211     0.200
     1.928    31.320     0.200
     2.206    33.344     0.200
     2.360    38.047     0.200
     2.477    39.992     0.200
     2.555    38.773     0.200
     2.555    38.555     0.200
     2.543    40.180     0.200
     2.530    40.141     0.200
     2.964    46.344     0.200
     3.164    49.008     0.200
     3.318    50.461     0.200
     3.324    52.258     0.200
     3.452    52.133     0.200
     3.537    54.320     0.200
     3.719    55.344     0.200
     3.741    57.891     0.200
     3.736    55.859     0.200
     4.000    61.344     0.200
     4.103    61.320     0.200
     4.103    60.570     0.200
     4.310    65.977     0.200
     4.382    67.039     0.200
     4.441    68.562     0.200
     4.460    67.719     0.200
     4.570    68.367     0.200
     4.911    74.320     0.200
     4.942    74.023     0.200
     5.200    78.133     0.200
     5.304    78.977     0.200
     5.360    79.273     0.200
     5.720    84.297     0.200
     5.873    88.336     0.200
     5.873    87.703     0.200
     6.585    95.672     0.200
     7.567   110.492     0.200
     8.726   125.344     0.200
    10.834   153.961     0.200
    10.835   155.281     0.200
    10.835   153.828     0.200
    10.867   159.672     0.200
     0.930    16.719     0.200
     0.963    18.020     0.200
     0.979    17.730     0.200
     0.979    17.520     0.200
     1.022    18.059     0.200
     1.132    19.828     0.200
     1.190    20.621     0.200
     1.185    21.199     0.200
     1.208    21.211     0.200
     1.270    21.984     0.200
     1.310    22.449     0.200
     1.337    23.559     0.200
     1.534    25.316     0.200
     1.729    28.168     0.200
     1.804    29.441     0.200
     1.852    30.141     0.200
     1.989    31.754     0.200
     2.193    34.621     0.200
     2.450    37.852     0.200
     2.509    37.988     0.200
     3.377    52.188     0.200
     3.508    52.945     0.200
     3.581    55.879     0.200
     3.787    59.309     0.200
     4.051    62.348     0.200
     4.067    60.910     0.200
     4.067    60.234     0.200
     4.315    65.719     0.200
     4.315    65.055     0.200
     4.323    65.871     0.200
     4.485    68.578     0.200
     5.225    79.871     0.200
     5.297    80.371     0.200
     5.297    78.359     0.200
     5.791    87.520     0.200
     5.928    89.863     0.200
     6.554    95.641     0.200
     6.554    95.000     0.200
     7.818   113.996     0.200
    10.793   154.523     0.200
    10.898   159.699     0.200
     0.775    14.863     0.200
     0.863    16.102     0.200
     0.868    15.973     0.200
     0.871    16.371     0.200
     0.871    16.031     0.200
     0.879    16.293     0.200
     0.907    16.730     0.200
     0.921    17.023     0.200
     0.922    17.090     0.200
     0.942    17.473     0.200
     0.990    18.383     0.200
     1.012    18.320     0.200
     1.011    18.523     0.200
     1.037    19.051     0.200
     1.057    18.973     0.200
     1.057    19.129     0.200
     1.091    20.203     0.200
     1.116    19.742     0.200
     1.125    20.250     0.200
     1.125    19.949     0.200
     1.168    20.641     0.200
     1.186    21.023     0.200
     1.208    21.090     0.200
     1.223    21.301     0.200
     1.241    21.672     0.200
     1.246    21.672     0.200
     1.248    21.621     0.200
     1.276    22.000     0.200
     1.323    23.953     0.200
     1.355    23.211     0.200
     1.549    25.941     0.200
     1.582    26.480     0.200
     1.594    27.211     0.200
     1.643    27.961     0.200
     1.697    27.180     0.200
     1.824    29.750     0.200
     1.882    31.652     0.200
     1.907    31.680     0.200
     1.910    30.992     0.200
     1.925    31.293     0.200
     2.029    33.047     0.200
     2.034    33.453     0.200
     2.044    33.027     0.200
     2.244    33.773     0.200
     2.128    34.992     0.200
     2.167    34.895     0.200
     2.334    36.617     0.200
     2.352    38.691     0.200
     2.419    38.473     0.200
     2.475    38.684     0.200
     2.491    39.273     0.200
     2.491    39.109     0.200
     2.648    42.941     0.200
     2.664    41.734     0.200
     2.694    40.512     0.200
     2.694    40.902     0.200
     2.876    44.602     0.200
     2.973    45.793     0.200
     3.134    47.922     0.200
     3.164    47.980     0.200
     3.164    48.844     0.200
     3.305    50.262     0.200
     3.337    51.402     0.200
     3.403    51.992     0.200
     3.505    53.262     0.200
     3.575    54.562     0.200
     3.616    55.582     0.200
     3.874    59.273     0.200
     3.892    59.082     0.200
     4.001    61.043     0.200
     4.001    61.301     0.200
     4.236    64.152     0.200
     4.236    64.449     0.200
     4.256    62.953     0.200
     4.256    62.809     0.200
     4.447    65.992     0.200
     4.447    66.793     0.200
     4.478    66.531     0.200
     4.494    68.613     0.200
     4.534    68.293     0.200
     4.624    69.582     0.200
     5.096    75.973     0.200
     5.270    77.832     0.200
     5.382    79.832     0.200
     5.454    80.840     0.200
     5.454    81.543     0.200
     5.724    83.191     0.200
     5.796    85.793     0.200
     5.836    87.078     0.200
     5.836    86.762     0.200
     6.084    89.633     0.200
     6.140    89.762     0.200
     6.310    93.410     0.200
     6.366    94.211     0.200
     6.639    97.422     0.200
     6.741    97.492     0.200
     6.741    98.262     0.200
     7.338   107.500     0.200
     7.617   110.191     0.200
     7.666   111.602     0.200
     7.724   112.051     0.200
     7.740   112.152     0.200
     7.784   112.223     0.200
     7.965   116.031     0.200
     7.988   115.797     0.200
     7.988   116.211     0.200
     9.655   138.973     0.200
    10.950   157.051     0.200
    10.979   157.441     0.200
    10.979   157.453     0.200
    10.980   157.676     0.200
    12.119   171.172     0.200
     0.773    14.691     0.200
     0.773    14.891     0.200
     0.792    15.391     0.200
     0.801    15.488     0.200
     0.844    15.859     0.200
     0.863    16.379     0.200
     0.877    16.629     0.200
     0.945    17.602     0.200
     0.934    17.320     0.200
     0.941    17.969     0.200
     0.978    18.238     0.200
     0.978    17.918     0.200
     1.059    18.930     0.200
     1.062    19.148     0.200
     1.103    20.039     0.200
     1.121    19.980     0.200
     1.147    20.941     0.200
     1.119    19.871     0.200
     1.133    20.059     0.200
     1.133    20.141     0.200
     1.165    20.539     0.200
     1.225    21.340     0.200
     1.225    21.449     0.200
     1.206    22.480     0.200
     1.264    22.270     0.200
     1.262    22.031     0.200
     1.255    21.832     0.200
     1.367    24.250     0.200
     1.357    26.629     0.200
     1.371    25.641     0.200
     1.371    24.082     0.200
     1.378    24.539     0.200
     1.387    24.629     0.200
     1.473    25.180     0.200
     1.637    28.191     0.200
     1.596    26.734     0.200
     1.656    27.625     0.200
     1.674    29.012     0.200
     1.739    29.691     0.200
     1.725    28.875     0.200
     1.896    31.609     0.200
     2.127    34.312     0.200
     2.176    34.879     0.200
     2.216    36.980     0.200
     2.245    35.969     0.200
     2.561    39.289     0.200
     2.362    38.410     0.200
     2.353    38.531     0.200
     2.382    37.848     0.200
     2.444    38.684     0.200
     2.519    39.520     0.200
     2.596    39.211     0.200
     2.637    41.988     0.200
     2.698    42.359     0.200
     2.811    42.480     0.200
     2.809    43.668     0.200
     2.937    45.391     0.200
     2.971    46.512     0.200
     3.100    47.629     0.200
     3.141    47.984     0.200
     3.175    49.250     0.200
     3.175    48.918     0.200
     3.223    49.441     0.200
     3.261    49.918     0.200
     3.261    50.109     0.200
     3.458    52.691     0.200
     3.552    55.352     0.200
     3.656    56.129     0.200
     3.656    56.863     0.200
     3.914    59.730     0.200
     4.126    63.168     0.200
     4.173    63.578     0.200
     4.206    63.859     0.200
     4.224    65.930     0.200
     4.220    64.160     0.200
     4.215    63.730     0.200
     4.285    64.570     0.200
     4.401    67.129     0.200
     4.654    70.102     0.200
     4.791    71.730     0.200
     4.907    73.070     0.200
     4.961    73.398     0.200
     5.030    75.039     0.200
     5.030    76.621     0.200
     5.079    76.102     0.200
     5.287    79.418     0.200
     5.287    80.148     0.200
     5.420    81.918     0.200
     5.432    81.809     0.200
     5.518    82.113     0.200
     5.792    85.168     0.200
     5.790    86.410     0.200
     5.922    86.691     0.200
     6.040    89.551     0.200
     6.559    97.609     0.200
     6.729    98.551     0.200
     6.729    98.656     0.200
     7.164   105.441     0.200
     7.158   104.148     0.200
     7.208   105.570     0.200
     7.416   108.660     0.200
     7.432   110.914     0.200
     7.534   110.320     0.200
     7.633   111.480     0.200
     7.864   115.461     0.200
    10.620   156.840     0.200
    11.052   158.559     0.200
    11.052   158.578     0.200
    11.053   157.074     0.200
    11.053   158.578     0.200
     0.772    14.632     0.200
     0.776    15.032     0.200
     0.795    15.262     0.200
     0.803    15.372     0.200
     0.850    15.662     0.200
     0.866    16.231     0.200
     0.879    16.592     0.200
     0.940    17.191     0.200
     0.946    17.452     0.200
     0.946    17.632     0.200
     0.985    18.071     0.200
     0.985    17.948     0.200
     1.003    17.941     0.200
     1.036    18.812     0.200
     1.057    18.782     0.200
     1.065    19.042     0.200
     1.106    19.861     0.200
     1.116    19.762     0.200
     1.121    19.731     0.200
     1.135    20.092     0.200
     1.136    20.142     0.200
     1.161    20.602     0.200
     1.221    21.792     0.200
     1.210    21.782     0.200
     1.222    21.481     0.200
     1.222    21.282     0.200
     1.259    22.071     0.200
     1.257    22.182     0.200
     1.257    22.032     0.200
     1.262    21.952     0.200
     1.328    23.062     0.200
     1.362    24.182     0.200
     1.364    23.992     0.200
     1.361    24.111     0.200
     1.376    24.409     0.200
     1.384    24.782     0.200
     1.392    24.262     0.200
     1.456    24.622     0.200
     1.480    25.371     0.200
     1.603    27.007     0.200
     1.630    28.262     0.200
     1.678    28.762     0.200
     1.736    27.691     0.200
     1.731    29.012     0.200
     1.726    29.002     0.200
     1.855    30.687     0.200
     1.867    31.492     0.200
     2.101    34.731     0.200
     2.135    34.371     0.200
     2.172    35.672     0.200
     2.183    34.771     0.200
     2.219    37.742     0.200
     2.364    38.071     0.200
     2.358    38.582     0.200
     2.553    39.021     0.200
     2.449    39.105     0.200
     2.526    40.832     0.200
     2.591    39.481     0.200
     2.643    42.151     0.200
     2.808    43.021     0.200
     2.817    43.892     0.200
     2.979    47.702     0.200
     3.107    48.015     0.200
     3.146    49.066     0.200
     3.231    50.882     0.200
     3.266    50.632     0.200
     3.266    50.472     0.200
     3.462    54.282     0.200
     3.559    56.271     0.200
     3.663    57.432     0.200
     3.663    57.002     0.200
     3.677    56.621     0.200
     3.737    58.275     0.200
     3.921    61.642     0.200
     4.058    62.251     0.200
     4.134    63.812     0.200
     4.180    64.271     0.200
     4.228    65.712     0.200
     4.226    64.622     0.200
     4.222    64.242     0.200
     4.284    64.912     0.200
     4.284    65.356     0.200
     4.333    67.092     0.200
     4.408    67.632     0.200
     4.451    67.361     0.200
     4.591    69.532     0.200
     4.660    71.592     0.200
     4.798    73.922     0.200
     4.914    74.082     0.200
     4.963    74.602     0.200
     5.038    76.552     0.200
     5.290    80.353     0.200
     5.525    82.226     0.200
     5.797    85.842     0.200
     5.821    86.992     0.200
     5.998    89.212     0.200
     6.673    98.542     0.200
     6.728    98.842     0.200
     6.765    99.642     0.200
     7.034   103.252     0.200
     7.049   103.662     0.200
     7.349   106.682     0.200
    10.626   155.502     0.200
    11.050   160.526     0.200
    15.020   209.762     0.200
    15.029   214.742     0.200
    15.211   214.182     0.200
     1.054    19.039     0.200
     1.074    19.479     0.200
     1.088    19.608     0.200
     1.114    20.229     0.200
     1.134    20.198     0.200
     1.131    20.159     0.200
     1.146    20.789     0.200
     1.145    20.349     0.200
     1.239    21.698     0.200
     1.268    22.349     0.200
     1.319    22.969     0.200
     1.351    25.209     0.200
     1.380    24.579     0.200
     1.379    24.229     0.200
     1.379    24.118     0.200
     1.459    25.169     0.200
     1.469    25.079     0.200
     1.597    26.638     0.200
     1.647    28.839     0.200
     1.642    27.923     0.200
     1.683    28.979     0.200
     1.714    28.795     0.200
     1.726    29.568     0.200
     1.733    29.619     0.200
     1.862    30.875     0.200
     1.874    31.349     0.200
     1.908    32.429     0.200
     2.125    34.617     0.200
     2.175    36.079     0.200
     2.178    35.919     0.200
     2.179    34.979     0.200
     2.179    35.125     0.200
     2.228    37.198     0.200
     2.341    38.259     0.200
     2.559    39.599     0.200
     2.453    38.794     0.200
     2.512    41.599     0.200
     2.588    39.249     0.200
     2.621    40.810     0.200
     2.645    41.619     0.200
     2.704    42.092     0.200
     2.800    42.929     0.200
     3.103    47.687     0.200
     3.151    48.363     0.200
     3.268    49.778     0.200
     3.268    50.031     0.200
     3.469    54.568     0.200
     3.551    55.759     0.200
     3.654    56.369     0.200
     3.745    57.801     0.200
     3.915    59.789     0.200
     4.065    61.712     0.200
     4.121    63.559     0.200
     4.174    63.358     0.200
     4.194    64.339     0.200
     4.210    64.729     0.200
     4.210    65.282     0.200
     4.210    64.188     0.200
     4.217    63.849     0.200
     4.272    63.559     0.200
     4.272    64.898     0.200
     4.391    67.339     0.200
     4.447    67.049     0.200
     4.584    69.278     0.200
     4.645    70.969     0.200
     4.782    72.709     0.200
     4.907    74.099     0.200
     4.946    74.679     0.200
     4.973    75.259     0.200
     5.027    75.898     0.200
     5.027    76.665     0.200
     5.058    76.619     0.200
     5.089    77.179     0.200
     5.273    79.229     0.200
     5.273    79.709     0.200
     5.423    81.309     0.200
     5.424    81.648     0.200
     5.520    82.485     0.200
     5.525    82.858     0.200
     5.636    84.979     0.200
     5.779    86.318     0.200
     5.784    85.219     0.200
     5.826    87.079     0.200
     6.042    89.688     0.200
     6.052    89.698     0.200
     6.671    98.019     0.200
     6.715    98.089     0.200
     6.715    98.429     0.200
     6.761    99.579     0.200
     6.911   101.629     0.200
     7.048   103.089     0.200
     7.150   103.089     0.200
     7.207   105.778     0.200
     7.428   109.387     0.200
     7.476   108.659     0.200
     7.520   109.769     0.200
     7.530   110.039     0.200
     7.618   111.129     0.200
     7.778   113.179     0.200
     7.849   116.448     0.200
     8.019   116.278     0.200
    10.610   155.929     0.200
    11.040   157.749     0.200
    11.040   160.278     0.200
    14.459   205.948     0.200
    14.974   211.419     0.200
    15.012   212.219     0.200
     0.773    14.838     0.200
     0.791    15.198     0.200
     0.800    15.368     0.200
     0.944    17.618     0.200
     0.986    18.158     0.200
     1.054    18.768     0.200
     1.062    18.958     0.200
     1.109    19.878     0.200
     1.114    19.718     0.200
     1.118    19.658     0.200
     1.132    19.858     0.200
     1.133    19.888     0.200
     1.219    21.200     0.200
     1.219    21.228     0.200
     1.257    21.998     0.200
     1.258    21.758     0.200
     1.325    22.878     0.200
     1.358    23.998     0.200
     1.360    23.688     0.200
     1.374    24.188     0.200
     1.374    23.936     0.200
     1.382    24.478     0.200
     1.389    24.298     0.200
     1.446    24.528     0.200
     1.453    24.338     0.200
     1.480    24.727     0.200
     1.602    26.341     0.200
     1.629    27.808     0.200
     1.675    28.668     0.200
     1.723    28.988     0.200
     1.740    27.948     0.200
     1.852    30.466     0.200
     1.896    32.138     0.200
     2.098    34.338     0.200
     2.169    35.448     0.200
     2.182    36.388     0.200
     2.216    36.338     0.200
     2.216    36.818     0.200
     2.360    38.278     0.200
     2.367    38.378     0.200
     2.446    38.386     0.200
     2.527    41.918     0.200
     2.594    38.898     0.200
     2.640    41.708     0.200
     2.811    42.418     0.200
     2.815    44.838     0.200
     2.977    47.178     0.200
     3.105    47.568     0.200
     3.143    48.130     0.200
     3.231    51.368     0.200
     3.264    51.098     0.200
     3.459    55.748     0.200
     3.662    57.378     0.200
     3.919    61.668     0.200
     4.134    63.508     0.200
     4.179    64.538     0.200
     4.213    65.118     0.200
     4.221    63.758     0.200
     4.228    64.698     0.200
     4.230    65.428     0.200
     4.287    64.348     0.200
     4.287    63.004     0.200
     4.409    67.528     0.200
     4.450    68.598     0.200
     4.589    69.768     0.200
     4.661    70.538     0.200
     4.966    74.388     0.200
     4.991    77.498     0.200
     5.081    75.838     0.200
     5.293    79.448     0.200
     5.439    81.548     0.200
     5.444    80.268     0.200
     5.482    83.288     0.200
     5.524    82.309     0.200
     5.524    83.318     0.200
     5.543    84.408     0.200
     5.774    86.618     0.200
     5.793    84.758     0.200
     5.798    84.848     0.200
     5.819    86.648     0.200
     5.926    88.448     0.200
     6.046    89.618     0.200
     6.050    90.198     0.200
     6.339    93.708     0.200
     6.712    98.938     0.200
     6.732    98.758     0.200
     6.732    97.886     0.200
     6.763    98.438     0.200
     7.168   106.548     0.200
     7.352   107.138     0.200
     7.359   106.038     0.200
     7.440   110.688     0.200
     7.869   114.783     0.200
     7.910   113.768     0.200
    10.627   157.188     0.200
    11.054   158.538     0.200
     0.863    16.279     0.200
     0.876    16.569     0.200
     0.956    17.648     0.200
     0.943    17.688     0.200
     0.985    18.115     0.200
     1.001    18.279     0.200
     1.035    18.648     0.200
     1.108    20.148     0.200
     1.115    19.969     0.200
     1.115    20.069     0.200
     1.118    19.859     0.200
     1.132    20.079     0.200
     1.220    21.569     0.200
     1.258    22.289     0.200
     1.259    22.109     0.200
     1.307    22.809     0.200
     1.363    24.969     0.200
     1.381    24.799     0.200
     1.388    24.329     0.200
     1.479    25.259     0.200
     1.479    26.327     0.200
     1.630    28.589     0.200
     1.852    30.530     0.200
     2.811    43.049     0.200
     2.811    42.424     0.200
     3.918    61.619     0.200
     4.132    64.389     0.200
     4.178    63.668     0.200
     4.212    64.729     0.200
     4.220    63.859     0.200
     4.226    65.688     0.200
     4.229    65.569     0.200
     4.287    64.069     0.200
     4.443    67.349     0.200
     4.449    67.139     0.200
     4.660    72.369     0.200
     4.798    74.789     0.200
     4.965    74.519     0.200
     5.080    77.609     0.200
     5.523    82.592     0.200
     5.796    85.049     0.200
     6.338    93.529     0.200
     6.563    98.279     0.200
     6.732    99.159     0.200
     7.089   104.979     0.200
     7.168   108.049     0.200
     7.351   106.449     0.200
     7.868   115.014     0.200
    10.626   155.543     0.200
    11.054   157.737     0.200
     1.033    19.090     0.200
     1.045    18.703     0.200
     1.050    20.262     0.200
     1.059    19.082     0.200
     1.409    24.984     0.200
     1.543    26.105     0.200
     1.586    27.703     0.200
     1.601    28.375     0.200
     2.019    32.965     0.200
     2.049    32.898     0.200
     2.408    38.355     0.200
     3.263    49.496     0.200
     3.327    53.633     0.200
     3.625    57.973     0.200
     4.140    63.094     0.200
     4.270    64.883     0.200
     4.372    65.922     0.200
     4.440    67.484     0.200
     4.604    69.652     0.200
     5.148    79.512     0.200
     5.515    84.094     0.200
     5.675    85.109     0.200
     5.989    91.242     0.200
     6.597    96.445     0.200
     7.058   105.242     0.200
     7.428   111.484     0.200
     7.775   116.305     0.200
    10.675   156.285     0.200
     0.981    17.672     0.200
     0.981    17.977     0.200
     1.013    18.023     0.200
     1.031    18.406     0.200
     1.050    19.031     0.200
     1.059    18.812     0.200
     1.071    19.242     0.200
     1.146    20.547     0.200
     1.155    20.328     0.200
     1.164    20.547     0.200
     1.192    20.906     0.200
     1.192    20.711     0.200
     1.216    21.492     0.200
     1.216    21.242     0.200
     1.219    21.227     0.200
     1.306    22.422     0.200
     1.306    22.547     0.200
     1.306    22.664     0.200
     1.341    23.031     0.200
     1.348    23.625     0.200
     1.411    24.328     0.200
     1.504    25.297     0.200
     1.522    24.703     0.200
     1.567    26.586     0.200
     1.700    27.992     0.200
     1.798    29.094     0.200
     1.942    31.945     0.200
     1.942    31.414     0.200
     1.951    31.352     0.200
     2.274    34.742     0.200
     2.336    37.547     0.200
     2.464    38.648     0.200
     2.493    40.328     0.200
     2.525    39.828     0.200
     2.537    38.633     0.200
     2.537    38.531     0.200
     2.533    39.828     0.200
     2.797    43.742     0.200
     3.165    48.617     0.200
     3.231    49.672     0.200
     3.323    50.562     0.200
     3.456    52.195     0.200
     3.528    54.102     0.200
     3.752    56.992     0.200
     3.996    59.961     0.200
     4.081    60.688     0.200
     4.287    64.625     0.200
     4.287    64.258     0.200
     4.363    66.336     0.200
     4.432    67.133     0.200
     4.444    67.211     0.200
     4.606    70.156     0.200
     4.801    71.508     0.200
     4.897    74.305     0.200
     4.918    73.578     0.200
     5.024    76.258     0.200
     5.182    78.312     0.200
     5.353    78.898     0.200
     5.464    80.445     0.200
     5.459    81.953     0.200
     5.557    81.273     0.200
     5.746    84.992     0.200
     5.777    86.758     0.200
     5.875    87.203     0.200
     6.084    89.336     0.200
     6.562    95.664     0.200
     7.157   106.094     0.200
     7.259   105.406     0.200
     7.621   112.602     0.200
     7.750   116.352     0.200
     7.809   113.898     0.200
     7.821   114.453     0.200
     7.893   115.094     0.200
     8.704   125.008     0.200
    10.815   154.758     0.200
    10.851   161.305     0.200
     0.976    17.617     0.200
     0.979    17.930     0.200
     1.032    18.508     0.200
     1.011    18.102     0.200
     1.048    18.797     0.200
     1.057    18.836     0.200
     1.068    19.109     0.200
     1.077    19.039     0.200
     1.144    20.516     0.200
     1.153    20.391     0.200
     1.162    20.578     0.200
     1.191    20.852     0.200
     1.190    20.719     0.200
     1.215    21.453     0.200
     1.215    21.352     0.200
     1.219    21.258     0.200
     1.346    23.688     0.200
     1.339    23.297     0.200
     1.383    23.750     0.200
     1.408    24.117     0.200
     1.501    25.688     0.200
     1.501    25.195     0.200
     1.524    24.977     0.200
     1.698    27.922     0.200
     1.796    29.273     0.200
     1.942    31.797     0.200
     1.942    31.695     0.200
     1.949    31.516     0.200
     2.208    33.680     0.200
     2.277    34.797     0.200
     2.337    37.492     0.200
     2.463    38.523     0.200
     2.539    38.781     0.200
     2.525    39.867     0.200
     2.531    39.242     0.200
     2.796    43.922     0.200
     2.972    46.242     0.200
     3.230    49.961     0.200
     3.321    50.008     0.200
     3.454    52.414     0.200
     3.527    54.547     0.200
     3.598    53.969     0.200
     3.749    56.852     0.200
     3.898    59.258     0.200
     3.994    60.562     0.200
     3.994    60.930     0.200
     4.084    60.422     0.200
     4.084    60.648     0.200
     4.288    64.812     0.200
     4.288    64.930     0.200
     4.363    66.531     0.200
     4.430    67.086     0.200
     4.443    67.648     0.200
     4.606    70.211     0.200
     4.799    71.312     0.200
     4.896    74.359     0.200
     4.919    74.461     0.200
     4.935    73.781     0.200
     5.023    74.977     0.200
     5.182    78.297     0.200
     5.351    79.602     0.200
     5.466    80.430     0.200
     5.456    81.312     0.200
     5.559    81.133     0.200
     5.746    86.102     0.200
     5.775    86.477     0.200
     5.830    86.617     0.200
     5.872    87.125     0.200
     6.082    89.578     0.200
     6.161    92.508     0.200
     6.393    95.336     0.200
     6.564    95.797     0.200
     7.158   106.242     0.200
     7.346   108.570     0.200
     7.437   108.078     0.200
     7.499   109.453     0.200
     7.553   109.930     0.200
     7.560   112.289     0.200
     7.748   117.148     0.200
     7.810   115.102     0.200
     8.706   125.289     0.200
    10.817   155.086     0.200
    10.851   159.609     0.200
     1.027    18.688     0.200
     1.022    18.707     0.200
     1.064    19.488     0.200
     1.029    19.586     0.200
     1.078    19.938     0.200
     1.119    20.746     0.200
     1.130    20.598     0.200
     1.181    20.855     0.200
     1.240    21.617     0.200
     1.220    21.605     0.200
     1.248    23.375     0.200
     1.569    26.426     0.200
     1.598    27.051     0.200
     1.668    27.977     0.200
     1.862    31.188     0.200
     1.976    31.648     0.200
     2.145    35.016     0.200
     2.188    35.000     0.200
     2.506    40.477     0.200
     2.576    40.957     0.200
     2.666    43.328     0.200
     2.760    41.965     0.200
     2.796    43.746     0.200
     2.912    45.016     0.200
     2.978    45.906     0.200
     3.020    46.195     0.200
     3.135    48.477     0.200
     3.263    50.027     0.200
     3.334    51.688     0.200
     3.699    57.047     0.200
     3.895    59.988     0.200
     4.232    64.926     0.200
     4.396    67.617     0.200
     4.405    67.508     0.200
     4.405    67.438     0.200
     4.431    67.746     0.200
     4.481    69.215     0.200
     4.531    68.605     0.200
     4.577    68.117     0.200
     4.823    73.059     0.200
     4.968    74.695     0.200
     4.980    73.715     0.200
     5.028    74.957     0.200
     5.107    77.078     0.200
     5.184    75.938     0.200
     5.232    77.348     0.200
     5.279    77.648     0.200
     5.379    80.137     0.200
     5.451    81.809     0.200
     5.488    84.281     0.200
     5.488    82.867     0.200
     5.556    81.637     0.200
     5.652    85.258     0.200
     5.727    84.809     0.200
     5.866    85.785     0.200
     5.908    86.945     0.200
     5.924    86.508     0.200
     5.941    87.297     0.200
     6.026    88.508     0.200
     6.098    88.965     0.200
     6.101    90.418     0.200
     6.123    90.246     0.200
     6.283    91.918     0.200
     6.591    96.238     0.200
     6.761    99.176     0.200
     6.988   101.285     0.200
     7.335   106.688     0.200
     7.362   107.125     0.200
     7.406   106.816     0.200
     7.514   107.695     0.200
     7.654   111.695     0.200
     7.708   111.148     0.200
     7.721   111.797     0.200
     7.900   113.297     0.200
     7.934   114.297     0.200
     8.135   117.398     0.200
    10.792   159.375     0.200
     0.880    16.336     0.200
     0.972    17.570     0.200
     0.981    17.789     0.200
     0.988    18.500     0.200
     0.992    21.117     0.200
     1.018    18.578     0.200
     1.081    19.297     0.200
     1.084    19.383     0.200
     1.082    19.602     0.200
     1.084    19.281     0.200
     1.122    19.930     0.200
     1.153    20.492     0.200
     1.172    20.516     0.200
     1.179    20.609     0.200
     1.192    21.219     0.200
     1.197    21.203     0.200
     1.237    21.750     0.200
     1.237    21.648     0.200
     1.309    22.633     0.200
     1.350    23.688     0.200
     1.490    26.617     0.200
     1.514    27.117     0.200
     1.526    26.156     0.200
     1.540    26.516     0.200
     1.548    25.828     0.200
     1.646    28.258     0.200
     1.769    29.812     0.200
     2.405    36.477     0.200
     2.327    38.227     0.200
     2.332    38.438     0.200
     2.432    39.977     0.200
     2.582    40.188     0.200
     2.645    43.828     0.200
     2.696    41.039     0.200
     2.696    41.320     0.200
     2.965    47.547     0.200
     3.070    47.312     0.200
     3.126    50.453     0.200
     3.361    52.297     0.200
     3.405    53.406     0.200
     3.579    55.422     0.200
     3.736    57.797     0.200
     3.807    59.219     0.200
     4.264    65.438     0.200
     4.281    65.742     0.200
     4.324    65.109     0.200
     4.497    69.156     0.200
     4.600    69.336     0.200
     5.211    78.117     0.200
     5.292    79.641     0.200
     5.576    83.898     0.200
     5.674    86.711     0.200
     6.664    97.516     0.200
    10.728   158.031     0.200
     0.747    14.127     0.200
     0.741    13.900     0.200
     0.767    14.267     0.200
     0.803    15.067     0.200
     0.817    15.147     0.200
     0.843    15.727     0.200
     0.855    15.567     0.200
     0.868    16.597     0.200
     0.940    16.937     0.200
     0.928    16.777     0.200
     0.966    17.367     0.200
     1.020    18.957     0.200
     1.020    19.247     0.200
     1.076    19.857     0.200
     1.117    20.267     0.200
     1.161    21.695     0.200
     1.238    22.167     0.200
     1.294    22.917     0.200
     1.293    23.337     0.200
     1.304    23.687     0.200
     1.347    24.367     0.200
     1.426    25.337     0.200
     1.457    25.607     0.200
     1.498    25.078     0.200
     1.611    27.218     0.200
     1.635    27.453     0.200
     1.673    28.229     0.200
     1.743    28.367     0.200
     1.742    30.067     0.200
     1.762    29.161     0.200
     1.858    31.927     0.200
     2.128    35.219     0.200
     2.156    35.237     0.200
     2.233    35.776     0.200
     2.263    35.884     0.200
     2.318    36.237     0.200
     2.320    37.194     0.200
     2.361    38.577     0.200
     2.362    37.878     0.200
     2.520    40.102     0.200
     2.550    40.287     0.200
     2.550    39.894     0.200
     2.760    43.021     0.200
     2.819    44.247     0.200
     2.899    45.467     0.200
     2.897    45.177     0.200
     3.015    45.127     0.200
     3.009    46.637     0.200
     2.992    47.127     0.200
     2.992    46.919     0.200
     3.010    47.004     0.200
     3.012    46.987     0.200
     3.026    47.237     0.200
     3.262    50.437     0.200
     3.260    50.906     0.200
     3.325    49.357     0.200
     3.325    49.695     0.200
     3.317    51.329     0.200
     3.432    53.225     0.200
     3.514    54.127     0.200
     3.528    54.691     0.200
     3.629    55.687     0.200
     3.788    58.207     0.200
     3.788    58.501     0.200
     3.898    60.257     0.200
     3.898    60.370     0.200
     4.182    64.207     0.200
     4.384    66.117     0.200
     4.518    69.387     0.200
     4.593    69.697     0.200
     4.686    69.467     0.200
     4.749    71.657     0.200
     4.840    72.737     0.200
     4.840    73.145     0.200
     4.878    71.547     0.200
     4.878    71.949     0.200
     4.859    73.416     0.200
     4.942    74.347     0.200
     4.944    74.427     0.200
     5.072    75.677     0.200
     5.066    75.267     0.200
     5.226    78.287     0.200
     5.232    78.897     0.200
     5.232    78.393     0.200
     5.436    81.377     0.200
     5.436    81.147     0.200
     5.465    82.232     0.200
     5.607    83.097     0.200
     6.022    89.317     0.200
     6.085    89.307     0.200
     6.355    92.247     0.200
     7.285   107.047     0.200
     7.348   107.077     0.200
     7.639   111.153     0.200
     8.511   122.252     0.200
    11.037   157.837     0.200
    11.037   159.277     0.200
    11.037   160.807     0.200
    11.612   165.097     0.200
    11.612   166.376     0.200
     0.761    14.234     0.200
     0.759    13.914     0.200
     0.733    14.242     0.200
     0.782    14.297     0.200
     0.782    14.312     0.200
     0.777    14.266     0.200
     0.823    14.930     0.200
     0.809    15.047     0.200
     0.866    15.633     0.200
     0.829    15.562     0.200
     0.837    15.992     0.200
     0.881    15.984     0.200
     0.857    16.383     0.200
     0.900    16.242     0.200
     0.920    16.359     0.200
     0.912    16.336     0.200
     0.927    16.633     0.200
     0.962    18.875     0.200
     0.985    17.625     0.200
     0.978    18.180     0.200
     1.010    18.742     0.200
     1.082    19.500     0.200
     1.086    19.953     0.200
     1.094    20.242     0.200
     1.185    21.164     0.200
     1.164    21.172     0.200
     1.207    21.930     0.200
     1.207    21.773     0.200
     1.231    22.375     0.200
     1.317    22.508     0.200
     1.340    23.633     0.200
     1.469    25.164     0.200
     1.546    27.125     0.200
     1.592    26.906     0.200
     1.680    27.383     0.200
     1.780    29.914     0.200
     1.819    30.766     0.200
     1.849    31.016     0.200
     2.021    32.961     0.200
     2.069    34.523     0.200
     2.148    35.281     0.200
     2.416    38.484     0.200
     2.482    39.531     0.200
     2.701    42.492     0.200
     2.680    42.898     0.200
     2.688    42.680     0.200
     2.802    45.375     0.200
     2.958    45.281     0.200
     3.203    49.742     0.200
     3.292    50.211     0.200
     4.537    69.312     0.200
     4.699    69.500     0.200
     4.902    73.836     0.200
     5.134    75.297     0.200
    14.762   207.164     0.200
     0.772    14.895     0.200
     0.867    16.405     0.200
     0.835    15.505     0.200
     0.842    16.125     0.200
     0.904    16.844     0.200
     0.876    16.165     0.200
     0.908    17.023     0.200
     0.957    17.665     0.200
     1.028    19.194     0.200
     1.023    19.012     0.200
     1.103    20.661     0.200
     1.152    21.115     0.200
     1.218    22.054     0.200
     1.218    21.917     0.200
     1.270    22.685     0.200
     1.279    22.314     0.200
     1.330    23.505     0.200
     1.368    23.895     0.200
     1.435    25.385     0.200
     1.522    25.435     0.200
     1.522    25.303     0.200
     1.548    26.688     0.200
     1.627    27.925     0.200
     1.646    27.503     0.200
     1.680    28.510     0.200
     1.852    30.378     0.200
     1.861    31.564     0.200
     1.936    32.255     0.200
     1.916    32.003     0.200
     1.976    32.784     0.200
     2.065    33.995     0.200
     2.089    34.334     0.200
     2.173    35.834     0.200
     2.279    37.115     0.200
     2.333    37.515     0.200
     2.338    37.927     0.200
     2.430    37.885     0.200
     2.393    38.422     0.200
     2.480    39.905     0.200
     2.510    40.695     0.200
     2.580    41.093     0.200
     2.751    44.354     0.200
     2.748    45.024     0.200
     2.896    46.353     0.200
     2.970    47.119     0.200
     3.042    47.522     0.200
     3.309    49.515     0.200
     3.185    50.324     0.200
     3.185    50.790     0.200
     3.458    54.385     0.200
     3.544    53.365     0.200
     3.544    53.555     0.200
     3.493    53.987     0.200
     3.870    60.165     0.200
     3.980    61.425     0.200
     4.210    64.985     0.200
     4.228    63.846     0.200
     4.378    65.820     0.200
     4.460    67.864     0.200
     4.777    73.017     0.200
     4.918    71.961     0.200
     6.863   100.136     0.200
     6.868   102.301     0.200
     7.288   106.544     0.200
     7.812   114.658     0.200
     7.812   114.463     0.200
     8.217   120.305     0.200
     8.217   119.569     0.200
     9.473   136.344     0.200
    10.304   151.695     0.200
    11.715   167.761     0.200
    14.344   204.591     0.200
     0.754    13.958     0.200
     0.778    14.529     0.200
     0.778    14.417     0.200
     0.807    15.489     0.200
     0.814    14.819     0.200
     0.841    15.108     0.200
     0.847    15.279     0.200
     0.877    15.958     0.200
     0.876    16.069     0.200
     0.904    16.789     0.200
     0.928    16.869     0.200
     0.943    17.039     0.200
     0.977    17.479     0.200
     0.977    18.289     0.200
     1.013    18.838     0.200
     1.013    18.703     0.200
     1.036    19.099     0.200
     1.083    19.469     0.200
     1.080    19.479     0.200
     1.229    21.055     0.200
     1.412    23.659     0.200
     1.414    24.265     0.200
     1.436    24.509     0.200
     1.489    25.018     0.200
     1.525    24.878     0.200
     1.591    26.926     0.200
     1.697    27.720     0.200
     1.754    29.499     0.200
     1.770    28.833     0.200
     1.958    31.361     0.200
     1.953    31.688     0.200
     1.953    31.849     0.200
     2.014    32.013     0.200
     2.040    32.779     0.200
     2.047    33.091     0.200
     2.065    33.268     0.200
     2.215    34.199     0.200
     2.262    36.979     0.200
     2.378    37.792     0.200
     2.504    39.194     0.200
     2.612    40.779     0.200
     2.620    41.418     0.200
     2.628    41.039     0.200
     2.825    40.599     0.200
     2.704    41.469     0.200
     2.704    41.597     0.200
     2.720    42.403     0.200
     2.806    43.188     0.200
     2.837    44.098     0.200
     2.892    45.019     0.200
     2.990    46.239     0.200
     3.014    45.128     0.200
     3.010    47.139     0.200
     3.105    47.810     0.200
     3.246    50.309     0.200
     3.270    49.139     0.200
     3.270    48.994     0.200
     3.276    50.278     0.200
     3.355    51.965     0.200
     3.377    51.544     0.200
     3.406    53.049     0.200
     3.980    61.039     0.200
     4.168    62.838     0.200
     4.199    63.668     0.200
     4.269    65.769     0.200
     4.395    66.128     0.200
     4.391    66.019     0.200
     4.475    67.799     0.200
     4.589    69.688     0.200
     4.604    69.759     0.200
     4.655    69.949     0.200
     4.735    70.878     0.200
     4.764    70.479     0.200
     4.764    69.875     0.200
     4.793    72.188     0.200
     4.802    70.799     0.200
     4.947    74.029     0.200
     4.983    74.719     0.200
     4.983    73.119     0.200
     5.171    76.229     0.200
     5.193    77.759     0.200
     5.286    79.148     0.200
     5.286    78.503     0.200
     5.397    80.128     0.200
     5.399    80.179     0.200
     5.502    82.929     0.200
     5.529    82.809     0.200
     5.702    83.062     0.200
     5.762    85.208     0.200
     5.819    86.349     0.200
     6.072    90.208     0.200
     6.407    94.108     0.200
     6.711    98.269     0.200
     7.207   104.619     0.200
     7.207   104.374     0.200
     7.390   107.838     0.200
     7.390   108.694     0.200
     7.429   108.688     0.200
     7.429   108.350     0.200
     7.710   112.199     0.200
     7.718   111.819     0.200
     7.734   113.029     0.200
     7.865   115.088     0.200
     7.994   115.659     0.200
     8.303   119.938     0.200
     9.369   133.039     0.200
     9.485   136.989     0.200
    10.759   156.419     0.200
    11.528   162.739     0.200
    15.107   213.809     0.200
    15.368   216.759     0.200
    15.929   224.958     0.200
    19.631   268.849     0.200
     0.871    16.892     0.200
     0.941    17.472     0.200
     0.941    17.335     0.200
     1.362    25.092     0.200
     1.340    24.732     0.200
     1.668    29.782     0.200
     1.735    28.851     0.200
     1.797    29.830     0.200
     2.112    34.777     0.200
     2.391    37.832     0.200
     2.201    36.643     0.200
     2.352    39.362     0.200
     2.649    43.112     0.200
     2.713    45.552     0.200
     2.806    45.282     0.200
     2.854    44.452     0.200
     2.854    43.517     0.200
     3.001    46.702     0.200
     3.178    49.342     0.200
     3.257    50.640     0.200
     3.449    53.412     0.200
     3.496    54.312     0.200
     3.768    58.672     0.200
     3.977    61.312     0.200
     4.101    63.152     0.200
     4.402    67.152     0.200
     4.395    66.712     0.200
     4.501    68.612     0.200
     4.516    68.282     0.200
     5.696    87.868     0.200
     7.691   114.982     0.200
    10.915   159.832     0.200
     0.772    14.727     0.200
     0.774    14.945     0.200
     0.835    15.555     0.200
     0.959    17.852     0.200
     1.007    18.594     0.200
     1.019    19.000     0.200
     1.033    19.273     0.200
     1.151    21.172     0.200
     1.222    21.766     0.200
     1.222    21.867     0.200
     1.275    22.492     0.200
     1.284    22.266     0.200
     1.373    24.453     0.200
     1.430    25.445     0.200
     1.430    24.977     0.200
     1.509    25.258     0.200
     1.525    25.398     0.200
     1.525    25.133     0.200
     1.543    25.742     0.200
     1.632    27.961     0.200
     1.643    27.305     0.200
     1.653    27.789     0.200
     1.678    28.523     0.200
     1.820    30.031     0.200
     1.850    30.422     0.200
     2.070    34.656     0.200
     2.083    34.258     0.200
     2.168    35.531     0.200
     2.274    37.008     0.200
     2.333    38.078     0.200
     2.391    38.648     0.200
     2.432    37.383     0.200
     2.506    39.984     0.200
     2.746    44.242     0.200
     2.746    44.227     0.200
     2.872    45.695     0.200
     2.892    45.727     0.200
     3.041    47.609     0.200
     3.180    50.555     0.200
     3.547    53.367     0.200
     3.626    56.602     0.200
     3.690    57.406     0.200
     4.141    63.477     0.200
     4.376    66.883     0.200
     4.376    67.023     0.200
     4.455    68.289     0.200
     4.772    72.305     0.200
     4.772    72.711     0.200
     4.796    71.172     0.200
     4.919    71.867     0.200
     5.568    83.961     0.200
     6.863   102.133     0.200
     7.289   106.555     0.200
     8.216   119.297     0.200
     9.473   136.352     0.200
    10.299   148.211     0.200
    11.319   161.445     0.200
    11.716   167.758     0.200
     1.200    21.086     0.200
     1.250    21.602     0.200
     1.337    23.992     0.200
     1.379    23.727     0.200
     1.523    26.617     0.200
     1.578    26.242     0.200
     1.651    27.102     0.200
     1.790    29.023     0.200
     2.664    40.250     0.200
     3.294    49.930     0.200
     3.392    53.289     0.200
     3.612    56.109     0.200
     4.178    62.906     0.200
     4.178    61.883     0.200
     4.262    65.820     0.200
     4.366    66.258     0.200
     4.517    69.086     0.200
     4.790    72.719     0.200
     4.942    74.750     0.200
     5.713    87.062     0.200
     6.643    96.531     0.200
     7.608   112.336     0.200
     7.839   116.430     0.200
    10.928   156.148     0.200
     1.024    19.251     0.200
     1.073    21.431     0.200
     1.406    26.436     0.200
     1.415    25.968     0.200
     1.435    25.311     0.200
     1.473    26.710     0.200
     1.520    27.379     0.200
     1.561    27.235     0.200
     1.606    28.791     0.200
     1.630    28.483     0.200
     1.660    28.021     0.200
     1.704    30.993     0.200
     1.731    28.981     0.200
     1.825    32.171     0.200
     1.882    32.941     0.200
     1.941    33.811     0.200
     1.942    34.001     0.200
     2.097    35.503     0.200
     2.122    36.568     0.200
     2.245    36.648     0.200
     2.265    37.461     0.200
     2.337    39.598     0.200
     2.386    38.863     0.200
     2.394    39.010     0.200
     2.464    41.036     0.200
     2.571    42.521     0.200
     2.571    42.836     0.200
     2.583    42.462     0.200
     2.636    43.636     0.200
     2.711    44.521     0.200
     2.779    44.801     0.200
     2.847    46.661     0.200
     3.128    47.171     0.200
     2.988    48.461     0.200
     3.005    48.917     0.200
     3.133    51.081     0.200
     3.197    51.298     0.200
     3.317    53.141     0.200
     3.323    52.831     0.200
     3.501    56.092     0.200
     3.531    56.302     0.200
     3.543    56.978     0.200
     3.711    56.416     0.200
     3.752    60.109     0.200
     3.835    60.861     0.200
     3.999    63.271     0.200
     4.186    65.681     0.200
     4.243    66.841     0.200
     4.256    67.241     0.200
     4.260    65.871     0.200
     4.459    70.704     0.200
     4.494    71.031     0.200
     4.537    71.951     0.200
     4.579    69.771     0.200
     4.592    70.541     0.200
     4.604    71.741     0.200
     4.639    71.721     0.200
     4.753    72.901     0.200
     4.823    74.121     0.200
     4.947    75.991     0.200
     4.956    75.971     0.200
     4.958    77.371     0.200
     4.970    76.511     0.200
     5.009    75.381     0.200
     5.064    78.311     0.200
     5.089    78.966     0.200
     5.122    78.351     0.200
     5.217    77.271     0.200
     5.217    77.392     0.200
     5.324    81.981     0.200
     5.392    82.271     0.200
     5.447    84.451     0.200
     5.597    85.151     0.200
     5.661    86.821     0.200
     5.787    88.391     0.200
     5.812    87.121     0.200
     5.836    89.491     0.200
     5.873    87.811     0.200
     5.920    89.901     0.200
     6.034    93.201     0.200
     6.098    93.041     0.200
     6.098    92.670     0.200
     6.094    94.171     0.200
     6.236    94.341     0.200
     6.262    94.741     0.200
     6.286    94.891     0.200
     6.358    97.051     0.200
     6.407    95.661     0.200
     6.551    99.741     0.200
     6.662    99.781     0.200
     6.717    99.411     0.200
     6.773   100.931     0.200
     6.953   103.451     0.200
     7.138   105.051     0.200
     7.183   105.721     0.200
     7.370   110.781     0.200
     7.369   110.071     0.200
     7.369   110.616     0.200
     7.442   111.121     0.200
     7.442   109.783     0.200
     7.467   109.751     0.200
     7.512   112.011     0.200
     7.587   114.021     0.200
     7.657   112.281     0.200
     7.657   112.173     0.200
     7.740   114.831     0.200
     7.762   115.391     0.200
     7.762   116.049     0.200
     8.033   118.771     0.200
     8.111   120.651     0.200
     8.219   118.781     0.200
     8.270   122.391     0.200
     8.314   120.991     0.200
     8.562   126.511     0.200
     8.718   128.071     0.200
     8.718   128.335     0.200
     8.701   128.251     0.200
     8.894   130.641     0.200
     9.056   133.191     0.200
     9.131   135.251     0.200
     9.191   135.821     0.200
     9.191   134.749     0.200
     9.211   136.041     0.200
     9.311   137.221     0.200
     9.470   140.681     0.200
     9.470   141.989     0.200
     9.570   139.531     0.200
     9.570   140.163     0.200
     9.570   139.651     0.200
     9.777   143.181     0.200
     9.821   142.003     0.200
     9.803   145.061     0.200
     9.958   146.051     0.200
    10.036   146.581     0.200
    10.160   145.771     0.200
    10.160   147.082     0.200
    10.250   149.281     0.200
    10.250   150.874     0.200
    10.316   151.791     0.200
    10.395   151.901     0.200
    10.386   152.351     0.200
    10.787   157.671     0.200
    10.787   156.008     0.200
    10.899   160.126     0.200
    10.899   159.041     0.200
    10.899   158.761     0.200
    10.899   160.691     0.200
    10.909   159.127     0.200
    10.999   160.461     0.200
    11.197   162.101     0.200
    11.407   165.511     0.200
    11.407   164.693     0.200
    11.626   166.821     0.200
    11.620   170.581     0.200
    11.719   170.961     0.200
    11.719   168.485     0.200
    11.756   171.901     0.200
    11.978   172.891     0.200
    12.095   174.041     0.200
    12.211   176.051     0.200
    12.235   176.441     0.200
    12.382   178.651     0.200
    12.403   179.851     0.200
    12.627   181.991     0.200
    13.003   187.851     0.200
    13.016   189.531     0.200
    13.069   189.591     0.200
    13.205   190.521     0.200
    13.321   190.511     0.200
    13.345   193.181     0.200
    13.522   196.371     0.200
    13.522   194.638     0.200
    13.917   198.571     0.200
    14.075   200.391     0.200
    14.415   206.201     0.200
    14.445   206.661     0.200
    14.561   206.501     0.200
    14.561   207.420     0.200
    14.759   210.301     0.200
    14.759   210.003     0.200
    14.779   209.771     0.200
    14.779   211.649     0.200
    14.789   210.821     0.200
    14.990   210.341     0.200
    15.011   213.221     0.200
    15.226   215.211     0.200
    15.476   219.461     0.200
    15.476   220.674     0.200
    15.483   219.851     0.200
    15.528   218.841     0.200
    15.985   224.191     0.200
    16.141   228.821     0.200
    16.334   229.301     0.200
    16.374   231.961     0.200
    16.374   231.764     0.200
    16.524   233.901     0.200
    16.526   231.151     0.200
    16.656   234.951     0.200
    16.760   233.051     0.200
    16.798   236.391     0.200
    17.233   240.291     0.200
    17.472   243.151     0.200
    17.954   250.381     0.200
    18.205   252.541     0.200
    18.787   261.271     0.200
    20.453   279.871     0.200
    20.788   283.781     0.200
     1.052    18.879     0.200
     1.082    19.141     0.200
     1.887    29.930     0.200
     2.656    42.020     0.200
     2.709    42.770     0.200
     3.341    50.930     0.200
     3.541    54.551     0.200
     4.446    65.410     0.200
     4.560    69.570     0.200
     4.562    69.648     0.200
     5.249    78.641     0.200
     5.714    87.000     0.200
     6.113    90.359     0.200
     6.927   100.859     0.200
     7.731   115.676     0.200
     8.146   119.160     0.200
    10.970   160.148     0.200
    11.174   161.352     0.200
     0.757    14.187     0.200
     0.757    14.117     0.200
     0.814    14.797     0.200
     0.902    16.347     0.200
     0.922    16.617     0.200
     0.961    17.197     0.200
     0.961    17.420     0.200
     0.972    17.417     0.200
     0.972    17.910     0.200
     0.991    17.606     0.200
     0.993    17.737     0.200
     1.077    19.037     0.200
     1.083    18.856     0.200
     1.095    19.367     0.200
     1.113    19.337     0.200
     1.123    19.537     0.200
     1.127    19.587     0.200
     1.126    20.083     0.200
     1.197    20.547     0.200
     1.207    20.947     0.200
     1.212    20.947     0.200
     1.216    20.767     0.200
     1.221    21.447     0.200
     1.295    22.007     0.200
     1.332    22.606     0.200
     1.348    23.377     0.200
     1.348    23.769     0.200
     1.412    23.497     0.200
     1.409    24.747     0.200
     1.454    24.097     0.200
     1.456    24.237     0.200
     1.458    24.047     0.200
     1.481    24.377     0.200
     1.519    25.717     0.200
     1.519    25.548     0.200
     1.739    28.567     0.200
     1.762    28.137     0.200
     1.848    30.197     0.200
     2.115    32.937     0.200
     2.347    37.227     0.200
     2.582    40.557     0.200
     2.623    40.657     0.200
     2.875    44.567     0.200
     3.057    47.837     0.200
     3.413    51.427     0.200
     3.611    54.767     0.200
     3.684    56.057     0.200
     3.823    58.677     0.200
     4.041    59.667     0.200
     4.041    59.467     0.200
     4.085    61.567     0.200
     4.317    64.847     0.200
     4.414    67.137     0.200
     4.515    67.396     0.200
     4.891    73.077     0.200
     5.242    77.987     0.200
     5.439    80.337     0.200
     5.432    79.777     0.200
     5.507    80.837     0.200
     5.965    90.287     0.200
     6.164    89.777     0.200
     6.227    92.277     0.200
     7.005   102.627     0.200
     7.188   103.977     0.200
     7.601   110.347     0.200
     7.807   111.937     0.200
     7.807   115.480     0.200
     7.835   116.487     0.200
    10.762   154.297     0.200
    10.763   153.962     0.200
    10.918   159.437     0.200
     1.030    18.449     0.200
     1.031    18.969     0.200
     1.030    19.168     0.200
     1.061    19.539     0.200
     1.158    21.379     0.200
     1.163    21.750     0.200
     1.197    21.480     0.200
     1.241    21.828     0.200
     1.274    23.359     0.200
     1.357    23.719     0.200
     1.446    24.801     0.200
     1.496    25.559     0.200
     1.543    26.129     0.200
     1.682    28.609     0.200
     1.702    29.090     0.200
     1.753    29.328     0.200
     1.781    29.469     0.200
     1.985    32.461     0.200
     1.990    32.371     0.200
     2.001    32.539     0.200
     2.953    46.219     0.200
     2.953    46.598     0.200
     4.787    72.043     0.200
     5.349    79.879     0.200
     5.832    86.730     0.200
     6.297    92.969     0.200
     6.770    99.961     0.200
     7.324   107.289     0.200
     7.979   116.277     0.200
     9.346   139.129     0.200
    10.130   148.160     0.200
    11.525   164.512     0.200
    14.280   203.152     0.200
    14.619   205.918     0.200
    15.869   222.539     0.200
    17.142   238.738     0.200
    18.582   257.418     0.200
     1.353    25.055     0.200
     1.659    29.750     0.200
     1.967    33.750     0.200
     2.064    35.375     0.200
     2.349    38.570     0.200
     2.403    39.609     0.200
     2.516    41.734     0.200
     3.178    50.508     0.200
     3.594    56.617     0.200
     3.777    58.195     0.200
     4.353    66.578     0.200
     4.386    67.445     0.200
     5.446    81.695     0.200
     6.791   100.102     0.200
     7.381   108.477     0.200
     7.906   117.320     0.200
    10.595   157.625     0.200
    11.125   162.227     0.200
     1.360    23.871     0.200
     1.365    23.500     0.200
     1.971    32.559     0.200
     2.067    34.879     0.200
     2.122    37.020     0.200
     2.145    37.848     0.200
     2.343    38.379     0.200
     2.398    39.520     0.200
     2.517    40.789     0.200
     4.370    66.211     0.200
     5.002    74.750     0.200
     5.445    80.418     0.200
     5.743    86.348     0.200
     7.377   109.684     0.200
    10.590   156.602     0.200
    11.121   158.418     0.200
     0.808    15.298     0.200
     0.830    15.578     0.200
     0.903    16.768     0.200
     1.079    19.878     0.200
     1.154    20.858     0.200
     1.267    23.238     0.200
     1.272    23.138     0.200
     1.519    26.428     0.200
     1.604    27.698     0.200
     1.727    28.438     0.200
     1.759    29.168     0.200
     1.722    29.948     0.200
     1.740    30.958     0.200
     1.880    32.278     0.200
     1.934    31.928     0.200
     1.994    34.288     0.200
     2.025    34.418     0.200
     2.187    36.158     0.200
     2.178    35.568     0.200
     2.322    37.688     0.200
     2.363    38.938     0.200
     2.384    39.508     0.200
     2.483    40.818     0.200
     2.608    42.628     0.200
     2.695    42.268     0.200
     2.697    43.368     0.200
     2.873    45.738     0.200
     2.885    46.448     0.200
     2.924    47.588     0.200
     3.214    47.478     0.200
     3.036    49.148     0.200
     3.210    49.888     0.200
     3.214    51.078     0.200
     3.229    50.948     0.200
     3.399    54.058     0.200
     3.485    52.938     0.200
     3.441    54.768     0.200
     3.654    56.738     0.200
     3.753    56.738     0.200
     3.861    59.558     0.200
     3.898    61.258     0.200
     4.192    63.648     0.200
     4.367    66.398     0.200
     4.513    69.268     0.200
     4.557    69.448     0.200
     4.569    69.538     0.200
     4.689    71.808     0.200
     4.871    74.438     0.200
     4.859    75.158     0.200
     4.904    74.698     0.200
     4.940    73.988     0.200
     4.988    77.458     0.200
     4.988    75.758     0.200
     5.040    75.708     0.200
     5.338    81.468     0.200
     5.433    80.998     0.200
     7.268   108.858     0.200
    10.811   159.458     0.200
    12.009   173.483     0.200
     1.078    19.859     0.200
     1.180    21.509     0.200
     1.473    24.209     0.200
     1.476    24.319     0.200
     1.482    25.709     0.200
     1.480    25.289     0.200
     1.554    26.779     0.200
     1.551    26.249     0.200
     1.678    27.329     0.200
     1.825    30.649     0.200
     1.987    33.179     0.200
     2.142    34.909     0.200
     2.153    35.609     0.200
     2.150    35.289     0.200
     2.412    37.549     0.200
     2.488    39.689     0.200
     2.488    39.919     0.200
     2.618    41.679     0.200
     2.694    42.769     0.200
     2.702    42.369     0.200
     2.707    42.939     0.200
     2.998    43.809     0.200
     2.956    45.419     0.200
     3.216    48.069     0.200
     3.207    50.329     0.200
     3.472    52.169     0.200
     4.958    75.169     0.200
     5.140    78.094     0.200
     7.313   107.769     0.200
     7.525   112.389     0.200
     8.453   122.463     0.200
     8.453   123.669     0.200
     8.453   123.859     0.200
     9.002   134.439     0.200
    10.191   151.089     0.200
    10.755   156.119     0.200
    11.423   168.929     0.200
    11.726   168.982     0.200
    14.379   205.269     0.200
    14.743   210.069     0.200
    14.768   209.438     0.200
    14.768   213.569     0.200
     0.802    15.117     0.200
     0.817    15.139     0.200
     0.867    16.078     0.200
     0.896    16.658     0.200
     0.916    16.998     0.200
     1.375    24.258     0.200
     1.569    26.178     0.200
     1.579    27.238     0.200
     1.798    29.277     0.200
     2.270    37.229     0.200
     2.290    38.947     0.200
     2.343    39.428     0.200
     2.454    37.219     0.200
     2.681    40.639     0.200
     2.950    46.068     0.200
     3.081    47.498     0.200
     3.109    48.018     0.200
     3.406    51.479     0.200
     3.698    55.678     0.200
     3.784    59.258     0.200
     4.178    63.678     0.200
     4.286    66.158     0.200
     5.661    85.064     0.200
     6.636    96.908     0.200
     7.547   112.469     0.200
     7.812   116.188     0.200
    10.691   159.219     0.200
    10.936   157.068     0.200
     1.014    18.266     0.200
     1.006    17.836     0.200
     1.027    18.203     0.200
     1.023    18.352     0.200
     1.039    18.273     0.200
     1.040    18.312     0.200
     1.071    19.492     0.200
     1.072    18.688     0.200
     1.142    20.016     0.200
     1.276    22.273     0.200
     1.343    22.461     0.200
     1.443    23.914     0.200
     1.640    28.094     0.200
     1.693    28.156     0.200
     1.829    30.234     0.200
     1.909    29.891     0.200
     2.364    36.867     0.200
     2.484    38.516     0.200
     2.611    39.055     0.200
     2.608    40.625     0.200
     2.676    42.094     0.200
     2.722    42.438     0.200
     2.733    42.664     0.200
     2.756    43.977     0.200
     2.811    42.125     0.200
     2.862    45.273     0.200
     2.910    43.578     0.200
     3.017    46.641     0.200
     3.199    48.578     0.200
     3.261    49.867     0.200
     3.326    50.484     0.200
     3.543    54.281     0.200
     3.785    57.852     0.200
     3.793    58.172     0.200
     3.808    57.953     0.200
     3.920    59.531     0.200
     4.058    61.492     0.200
     4.386    66.047     0.200
     4.469    65.695     0.200
     4.575    69.164     0.200
     4.577    69.102     0.200
     4.621    69.008     0.200
     4.767    71.773     0.200
     5.010    75.031     0.200
     5.614    83.516     0.200
     5.705    84.734     0.200
     5.705    85.016     0.200
     5.771    85.688     0.200
     6.138    90.352     0.200
     7.616   110.523     0.200
     7.731   112.062     0.200
     7.731   111.453     0.200
     7.809   112.984     0.200
     8.044   117.617     0.200
     8.167   119.156     0.200
     8.167   118.242     0.200
     9.092   130.508     0.200
    10.205   151.875     0.200
    10.190   149.055     0.200
    10.978   159.609     0.200
    10.978   160.297     0.200
    11.196   158.984     0.200
    11.197   160.656     0.200
    13.656   192.664     0.200
    13.778   194.773     0.200
    14.684   206.133     0.200
    14.764   208.102     0.200
    15.247   216.156     0.200
    15.247   214.156     0.200
    15.414   214.391     0.200
    15.562   218.695     0.200
    15.660   218.984     0.200
    15.696   219.984     0.200
    16.046   223.836     0.200
    16.449   229.641     0.200
    16.578   230.188     0.200
    16.924   234.852     0.200
    17.617   243.195     0.200
     0.983    17.879     0.200
     0.987    18.270     0.200
     1.011    18.820     0.200
     1.064    18.969     0.200
     1.107    20.188     0.200
     1.159    20.820     0.200
     1.239    21.828     0.200
     1.269    22.230     0.200
     1.355    24.121     0.200
     1.484    25.090     0.200
     1.604    27.871     0.200
     1.708    29.348     0.200
     1.891    31.648     0.200
     2.177    35.520     0.200
     2.227    35.738     0.200
     2.359    39.230     0.200
     2.378    38.430     0.200
     2.638    41.609     0.200
     2.747    42.750     0.200
     3.022    46.949     0.200
     3.308    50.961     0.200
     3.705    56.820     0.200
     3.738    57.719     0.200
     4.230    64.449     0.200
     4.258    64.090     0.200
     4.690    70.770     0.200
    10.655   156.258     0.200
     0.967    18.379     0.200
     2.181    37.059     0.200
     2.869    47.559     0.200
     7.862   114.742     0.200
    10.663   154.648     0.200
    11.019   159.477     0.200
    15.034   215.395     0.200
    18.756   262.711     0.200
     1.362    23.551     0.200
     1.403    27.129     0.200
     1.606    27.629     0.200
     2.266    39.609     0.200
     2.538    38.410     0.200
     2.884    47.730     0.200
    10.655   156.301     0.200
    11.007   158.727     0.200
     0.795    15.117     0.200
     0.827    15.914     0.200
     0.899    16.594     0.200
     0.981    18.070     0.200
     0.993    18.320     0.200
     1.092    19.500     0.200
     1.257    22.148     0.200
     1.370    24.180     0.200
     1.382    25.578     0.200
     1.487    25.289     0.200
     2.077    35.719     0.200
     2.176    34.891     0.200
     2.215    35.258     0.200
     2.347    37.180     0.200
     2.360    37.211     0.200
     2.557    38.672     0.200
     2.628    40.984     0.200
     2.634    41.039     0.200
     2.657    41.758     0.200
     2.738    42.852     0.200
     5.556    84.727     0.200
    10.636   156.164     0.200
     1.388    25.340     0.200
     1.394    25.891     0.200
     1.490    27.242     0.200
     1.534    27.320     0.200
     1.687    29.660     0.200
     1.757    30.762     0.200
     1.787    30.703     0.200
     1.765    30.742     0.200
     1.851    31.891     0.200
     1.949    33.070     0.200
     2.027    35.043     0.200
     2.046    34.453     0.200
     2.102    34.902     0.200
     2.241    37.051     0.200
     2.282    37.863     0.200
     2.379    38.680     0.200
     2.394    39.160     0.200
     2.409    39.633     0.200
     2.539    41.840     0.200
     2.605    42.723     0.200
     2.831    45.090     0.200
     2.836    45.652     0.200
     2.842    46.113     0.200
     2.897    46.422     0.200
     2.995    47.512     0.200
     3.138    50.223     0.200
     3.414    54.461     0.200
     3.435    54.672     0.200
     3.623    57.461     0.200
     3.726    58.910     0.200
     3.934    60.820     0.200
     4.001    61.461     0.200
     4.146    63.730     0.200
     4.169    64.832     0.200
     4.182    64.273     0.200
     4.251    66.211     0.200
     4.267    67.051     0.200
     4.365    67.730     0.200
     4.432    67.680     0.200
     4.468    66.793     0.200
     4.607    70.973     0.200
     4.615    71.352     0.200
     4.690    72.031     0.200
     4.725    72.477     0.200
     4.725    72.281     0.200
     4.825    74.383     0.200
     4.914    75.410     0.200
     4.971    76.223     0.200
     4.995    74.391     0.200
     5.019    76.410     0.200
     5.162    78.531     0.200
     5.196    79.613     0.200
     5.270    80.293     0.200
     5.382    81.762     0.200
     5.440    82.191     0.200
     5.518    83.992     0.200
     5.631    85.180     0.200
     5.736    87.102     0.200
     6.081    91.391     0.200
     6.220    93.230     0.200
     6.699    99.641     0.200
     6.847   101.223     0.200
     7.220   106.332     0.200
     7.363   107.941     0.200
     7.432   109.133     0.200
     7.444   107.043     0.200
     7.480   107.922     0.200
    10.312   153.086     0.200
    11.792   170.902     0.200
     0.887    16.984     0.200
     0.970    18.266     0.200
     0.970    18.125     0.200
     1.003    18.508     0.200
     1.079    19.672     0.200
     1.155    20.781     0.200
     1.333    24.172     0.200
     2.495    40.641     0.200
     3.251    50.594     0.200
     3.729    57.852     0.200
     4.131    61.906     0.200
     4.196    63.945     0.200
     4.373    65.953     0.200
     4.454    68.141     0.200
     4.852    72.812     0.200
     4.935    74.742     0.200
     4.997    75.867     0.200
     5.290    79.281     0.200
     5.508    81.125     0.200
     5.801    85.008     0.200
     6.288    92.883     0.200
     6.606    96.797     0.200
     7.829   117.383     0.200
     8.751   126.477     0.200
    10.810   159.312     0.200
    10.872   155.875     0.200
     1.335    24.594     0.200
     1.577    27.617     0.200
     2.075    35.805     0.200
     2.346    38.289     0.200
     2.350    38.742     0.200
     2.886    46.133     0.200
     3.079    50.367     0.200
     3.817    60.398     0.200
    10.801   162.219     0.200
     0.900    17.734     0.200
     1.339    23.648     0.200
     1.485    26.031     0.200
     1.638    27.719     0.200
     2.082    34.977     0.200
     3.028    45.977     0.200
     3.085    48.000     0.200
     3.245    50.219     0.200
     3.376    51.945     0.200
     3.945    59.336     0.200
     4.130    61.367     0.200
     4.190    64.414     0.200
     4.275    65.594     0.200
     4.365    66.031     0.200
     4.844    72.156     0.200
     4.930    74.648     0.200
     4.994    75.438     0.200
     4.974    75.617     0.200
     5.140    78.758     0.200
     5.284    80.055     0.200
     5.378    80.141     0.200
     5.506    80.766     0.200
     5.613    82.406     0.200
     5.648    83.711     0.200
     5.688    84.289     0.200
     6.267    93.930     0.200
     6.315    93.664     0.200
     6.316    93.617     0.200
     6.537    96.234     0.200
     6.603    97.164     0.200
     7.681   112.914     0.200
     7.681   113.430     0.200
     7.824   114.930     0.200
     7.825   116.484     0.200
     7.825   114.945     0.200
     8.749   126.641     0.200
     8.922   127.547     0.200
     9.303   134.797     0.200
     9.517   138.031     0.200
    10.083   145.227     0.200
    10.256   147.180     0.200
    10.534   151.906     0.200
    10.802   157.492     0.200
    10.802   155.648     0.200
    10.871   155.219     0.200
    10.872   155.984     0.200
    10.872   155.750     0.200
    11.044   158.688     0.200
    11.911   170.469     0.200
    15.348   216.484     0.200
    17.223   239.875     0.200
     1.111    19.586     0.200
     1.124    19.828     0.200
     1.142    21.195     0.200
     1.157    20.688     0.200
     1.167    21.086     0.200
     1.335    23.148     0.200
     1.481    25.758     0.200
     1.572    26.273     0.200
     2.348    36.367     0.200
     2.864    44.094     0.200
     3.087    46.328     0.200
     3.946    59.055     0.200
     4.000    61.141     0.200
     4.132    61.109     0.200
     4.191    63.250     0.200
     4.400    66.547     0.200
     4.450    66.805     0.200
     4.583    70.086     0.200
     4.934    73.477     0.200
     4.978    74.734     0.200
     5.144    75.977     0.200
     6.284    92.656     0.200
     6.606    96.414     0.200
     7.272   105.891     0.200
     7.784   112.695     0.200
    10.873   154.258     0.200
    10.873   154.484     0.200
     1.119    19.647     0.200
     1.157    20.227     0.200
     1.165    20.327     0.200
     1.332    23.647     0.200
     1.482    25.517     0.200
     1.578    25.297     0.200
     1.588    26.887     0.200
     1.630    26.707     0.200
     1.667    27.977     0.200
     1.745    29.277     0.200
     2.076    34.017     0.200
     2.350    37.897     0.200
     2.354    35.457     0.200
     2.349    38.447     0.200
     2.419    39.097     0.200
     2.423    38.927     0.200
     2.449    38.857     0.200
     2.490    39.737     0.200
     2.834    44.147     0.200
     2.858    44.557     0.200
     2.889    44.657     0.200
     2.964    46.367     0.200
     3.021    47.357     0.200
     3.081    47.507     0.200
     3.205    48.827     0.200
     3.242    49.877     0.200
     3.371    51.607     0.200
     3.730    56.527     0.200
     3.820    59.347     0.200
     3.918    60.317     0.200
     4.137    60.927     0.200
     4.137    61.517     0.200
     4.281    65.247     0.200
     4.398    66.817     0.200
     4.846    73.227     0.200
     5.314    78.967     0.200
     5.674    82.737     0.200
     5.791    87.082     0.200
     5.791    85.637     0.200
     6.418    94.957     0.200
     7.149   108.107     0.200
     7.276   106.027     0.200
     7.468   108.777     0.200
     7.470   112.127     0.200
     7.679   113.207     0.200
     7.679   111.917     0.200
     7.804   112.427     0.200
     7.831   116.326     0.200
     7.831   114.387     0.200
     8.757   126.237     0.200
     9.121   136.077     0.200
    10.063   149.226     0.200
    10.334   150.685     0.200
    10.558   151.517     0.200
    10.804   158.307     0.200
    10.879   155.957     0.200
    10.879   155.757     0.200
    13.694   194.677     0.200
    14.082   202.207     0.200
    14.080   200.787     0.200
    14.107   201.127     0.200
    14.265   202.327     0.200
    14.343   203.857     0.200
    14.709   208.687     0.200
    14.860   210.297     0.200
    15.151   213.937     0.200
    15.235   217.526     0.200
    15.235   215.487     0.200
    15.387   217.097     0.200
    15.411   217.757     0.200
    15.592   220.177     0.200
    17.148   238.487     0.200
    17.667   243.987     0.200
    18.271   253.317     0.200
     0.825    15.630     0.200
     0.969    17.430     0.200
     0.971    17.960     0.200
     0.986    17.670     0.200
     0.986    17.770     0.200
     1.094    19.270     0.200
     1.116    19.730     0.200
     1.159    20.450     0.200
     1.140    21.180     0.200
     1.197    21.280     0.200
     1.333    23.330     0.200
     1.486    25.720     0.200
     1.580    27.980     0.200
     1.624    26.880     0.200
     1.675    28.750     0.200
     2.068    34.700     0.200
     2.343    39.010     0.200
     2.348    38.740     0.200
     2.439    39.550     0.200
     2.485    40.680     0.200
     2.826    43.520     0.200
     2.954    46.060     0.200
     3.072    48.120     0.200
     3.195    49.400     0.200
     3.232    50.570     0.200
     3.362    51.380     0.200
     3.508    54.300     0.200
     3.730    57.640     0.200
     3.909    59.940     0.200
     3.931    59.310     0.200
     3.985    61.150     0.200
     4.142    61.940     0.200
     4.176    64.160     0.200
     4.278    66.370     0.200
     4.329    66.130     0.200
     4.356    65.790     0.200
     4.391    66.890     0.200
     4.435    66.770     0.200
     4.559    69.230     0.200
     4.839    72.730     0.200
     4.937    74.630     0.200
     4.979    74.200     0.200
     5.518    81.670     0.200
     5.682    83.310     0.200
     5.781    89.613     0.200
     5.781    86.880     0.200
     6.279    93.880     0.200
     6.522    95.290     0.200
     6.615    96.750     0.200
     7.102   105.230     0.200
     7.278   106.660     0.200
     7.292   105.750     0.200
     7.671   114.680     0.200
     7.671   111.180     0.200
     7.832   116.824     0.200
     7.832   113.710     0.200
     9.315   134.400     0.200
     9.482   135.980     0.200
     9.926   142.020     0.200
    10.268   146.490     0.200
    10.546   150.740     0.200
    10.798   157.849     0.200
    10.885   157.405     0.200
     1.156    20.586     0.200
     1.143    20.997     0.200
     1.171    20.847     0.200
     1.335    23.606     0.200
     1.478    25.517     0.200
     1.569    25.517     0.200
     1.640    26.767     0.200
     1.658    27.606     0.200
     2.087    33.537     0.200
     2.432    41.557     0.200
     2.494    40.527     0.200
     2.846    43.896     0.200
     2.975    48.167     0.200
     3.093    47.507     0.200
     3.252    52.007     0.200
     3.383    50.927     0.200
     3.528    54.037     0.200
     3.727    58.447     0.200
     4.129    61.907     0.200
     4.281    64.927     0.200
     4.337    67.077     0.200
     4.403    67.297     0.200
     5.506    81.217     0.200
     5.802    88.934     0.200
     5.802    85.697     0.200
     6.603    96.507     0.200
     7.689   115.231     0.200
     7.689   111.947     0.200
     7.696   114.547     0.200
     7.827   117.076     0.200
     7.827   115.146     0.200
     8.749   126.497     0.200
    10.810   159.207     0.200
    10.870   154.957     0.200
    10.870   154.757     0.200
    15.228   212.767     0.200
    15.245   214.047     0.200
    16.243   227.157     0.200
     0.977    18.571     0.200
     1.317    24.302     0.200
     1.338    23.432     0.200
     1.393    23.941     0.200
     1.428    26.791     0.200
     1.491    25.741     0.200
     1.507    25.701     0.200
     1.678    27.842     0.200
     1.713    28.842     0.200
     2.071    33.602     0.200
     2.360    35.781     0.200
     2.412    41.092     0.200
     2.956    45.512     0.200
     3.072    48.791     0.200
     4.137    61.142     0.200
     4.982    75.291     0.200
     5.132    79.371     0.200
     5.781    88.468     0.200
     6.302    94.661     0.200
     6.609    96.382     0.200
     7.096   103.251     0.200
     7.272   106.291     0.200
     7.286   107.191     0.200
     7.465   109.501     0.200
     7.669   114.251     0.200
     7.669   111.961     0.200
     7.827   115.420     0.200
     8.756   126.481     0.200
    10.072   147.646     0.200
    10.794   158.372     0.200
    10.881   156.126     0.200
    15.233   214.142     0.200
    15.353   216.821     0.200
    15.377   217.722     0.200
    15.373   216.371     0.200
    15.832   222.121     0.200
     1.101    19.598     0.200
     1.123    21.008     0.200
     1.149    20.207     0.200
     1.176    21.227     0.200
     1.500    25.348     0.200
     1.563    27.289     0.200
     1.576    27.277     0.200
     1.679    28.309     0.200
     2.083    35.227     0.200
     2.329    39.438     0.200
     2.348    35.848     0.200
     3.236    49.277     0.200
     4.123    61.719     0.200
     5.634    84.559     0.200
     5.690    87.117     0.200
     5.787    87.191     0.200
     6.265    94.008     0.200
     6.595    96.727     0.200
    10.788   158.441     0.200
    10.867   155.074     0.200
     0.844    15.559     0.200
     0.895    16.301     0.200
     0.899    16.863     0.200
     0.907    16.594     0.200
     0.987    17.809     0.200
     1.002    18.031     0.200
     1.124    20.238     0.200
     1.135    19.891     0.200
     1.175    20.711     0.200
     1.351    23.922     0.200
     1.499    26.148     0.200
     1.564    25.512     0.200
     1.641    26.898     0.200
     1.679    28.211     0.200
     2.082    33.980     0.200
     2.349    35.520     0.200
     2.358    37.809     0.200
     2.446    38.391     0.200
     2.473    39.871     0.200
     5.787    87.312     0.200
     7.813   114.594     0.200
    10.788   157.750     0.200
    10.867   158.035     0.200
     1.003    17.992     0.200
     1.135    20.125     0.200
     1.172    20.805     0.200
     1.154    20.172     0.200
     1.349    24.211     0.200
     1.564    25.320     0.200
     1.580    26.852     0.200
     1.642    26.875     0.200
     2.290    35.086     0.200
     2.084    34.711     0.200
     2.347    36.531     0.200
     2.332    37.484     0.200
     2.360    37.555     0.200
     2.429    37.703     0.200
     2.449    39.836     0.200
     2.476    40.391     0.200
     2.860    44.531     0.200
     2.967    45.711     0.200
     3.030    47.695     0.200
     5.790    87.133     0.200
     7.815   113.859     0.200
    10.792   158.094     0.200
    10.867   156.617     0.200
     0.837    15.586     0.200
     1.155    20.414     0.200
     1.190    20.719     0.200
     1.327    23.500     0.200
     1.463    25.398     0.200
     1.566    25.469     0.200
     1.648    26.898     0.200
     1.638    27.656     0.200
     2.258    35.008     0.200
     2.099    34.453     0.200
     2.330    35.430     0.200
     2.354    36.859     0.200
     2.371    38.508     0.200
     2.439    38.516     0.200
     2.452    39.258     0.200
     2.479    39.133     0.200
     2.511    39.969     0.200
     2.859    44.766     0.200
     2.888    44.789     0.200
     2.919    45.023     0.200
     2.992    47.914     0.200
     3.112    48.844     0.200
     3.234    49.398     0.200
     3.272    50.008     0.200
     3.401    52.445     0.200
     3.489    53.773     0.200
     3.735    57.133     0.200
     3.969    60.789     0.200
     4.126    60.906     0.200
     4.293    64.859     0.200
     4.352    66.188     0.200
     4.422    66.250     0.200
     4.871    72.406     0.200
     4.940    74.555     0.200
     5.000    76.016     0.200
     5.821    88.914     0.200
    10.828   158.406     0.200
    10.864   155.688     0.200
     0.865    16.117     0.200
     0.941    17.430     0.200
     1.016    18.422     0.200
     1.024    18.750     0.200
     1.048    18.789     0.200
     1.150    20.117     0.200
     1.264    22.148     0.200
     1.398    24.031     0.200
     1.410    24.430     0.200
     1.443    24.203     0.200
     1.608    27.617     0.200
     1.595    25.961     0.200
     1.812    29.750     0.200
     2.278    37.570     0.200
     2.293    36.352     0.200
     2.422    36.898     0.200
     2.364    38.141     0.200
     2.437    37.031     0.200
     2.754    43.781     0.200
     2.855    44.297     0.200
     3.315    51.023     0.200
     7.534   113.320     0.200
     7.778   112.148     0.200
    10.667   156.820     0.200
    10.908   155.852     0.200
    15.091   211.742     0.200
    15.448   215.680     0.200
     1.014    18.094     0.200
     1.005    18.047     0.200
     1.007    18.109     0.200
     1.029    18.383     0.200
     1.054    19.070     0.200
     1.054    19.523     0.200
     1.080    19.797     0.200
     1.123    19.703     0.200
     1.202    20.930     0.200
     1.231    21.680     0.200
     1.239    21.594     0.200
     1.378    24.516     0.200
     1.469    25.641     0.200
     1.575    27.102     0.200
     1.581    26.305     0.200
     1.612    27.023     0.200
     1.603    26.984     0.200
     1.787    28.812     0.200
     2.001    32.875     0.200
     2.407    35.445     0.200
     2.283    37.164     0.200
     2.302    38.844     0.200
     2.334    39.414     0.200
     2.356    38.742     0.200
     2.750    43.945     0.200
     2.951    46.492     0.200
     7.806   116.023     0.200
    10.698   156.852     0.200
    10.923   156.156     0.200
     1.156    21.104     0.200
     1.222    22.943     0.200
     1.273    22.443     0.200
     1.273    23.314     0.200
     1.565    28.074     0.200
     1.675    28.344     0.200
     1.818    29.734     0.200
     1.801    31.523     0.200
     1.882    32.055     0.200
     2.053    33.523     0.200
     2.129    36.334     0.200
     2.143    35.994     0.200
     2.363    38.854     0.200
     2.450    40.533     0.200
     2.537    41.693     0.200
     2.670    43.084     0.200
     2.771    44.953     0.200
     2.989    48.203     0.200
     3.043    48.914     0.200
     3.071    47.773     0.200
     3.377    53.863     0.200
     3.413    54.363     0.200
     3.569    56.475     0.200
     3.801    59.234     0.200
     3.886    59.805     0.200
     4.221    65.094     0.200
     4.271    66.635     0.200
     4.380    66.555     0.200
     4.652    71.324     0.200
     4.689    71.713     0.200
     4.697    72.395     0.200
     4.865    74.385     0.200
     4.930    75.824     0.200
     5.060    77.924     0.200
     5.056    77.283     0.200
     5.119    79.475     0.200
     5.520    84.414     0.200
     5.688    86.764     0.200
     5.922    88.654     0.200
     6.772   100.693     0.200
     7.439   111.475     0.200
     8.114   120.023     0.200
     8.339   122.174     0.200
     8.340   121.504     0.200
     8.533   123.904     0.200
     8.828   128.643     0.200
     8.828   128.873     0.200
     9.471   138.771     0.200
    10.996   162.955     0.200
    12.059   172.998     0.200
     1.291    22.039     0.200
     1.384    23.445     0.200
     1.449    24.711     0.200
     1.532    26.156     0.200
     1.597    26.648     0.200
     1.600    26.469     0.200
     1.691    29.195     0.200
     1.773    29.219     0.200
     1.722    30.031     0.200
     1.848    31.281     0.200
     1.940    32.008     0.200
     2.015    33.898     0.200
     2.052    32.695     0.200
     2.117    33.828     0.200
     2.119    34.727     0.200
     2.135    35.016     0.200
     2.217    35.859     0.200
     2.243    36.398     0.200
     2.319    37.906     0.200
     2.386    37.898     0.200
     2.412    38.422     0.200
     2.403    39.305     0.200
     2.485    39.320     0.200
     2.464    39.086     0.200
     2.480    39.922     0.200
     2.620    41.180     0.200
     2.793    43.492     0.200
     2.783    43.328     0.200
     2.832    43.445     0.200
     3.051    42.891     0.200
     3.023    45.625     0.200
     3.062    47.070     0.200
     3.172    48.195     0.200
     3.172    50.070     0.200
     3.198    49.906     0.200
     3.330    51.586     0.200
     3.423    52.211     0.200
     3.682    55.586     0.200
     3.682    56.406     0.200
     3.779    57.258     0.200
     3.860    59.305     0.200
     3.856    58.586     0.200
     3.963    60.117     0.200
     4.111    62.391     0.200
     4.289    65.086     0.200
     4.416    66.680     0.200
     4.439    66.867     0.200
     4.538    66.992     0.200
     4.632    70.031     0.200
     4.700    69.422     0.200
     4.678    69.227     0.200
     4.922    71.250     0.200
     5.051    72.375     0.200
     5.514    79.898     0.200
     5.549    80.406     0.200
     5.591    80.789     0.200
     5.566    80.289     0.200
     5.850    83.891     0.200
     5.892    84.977     0.200
     6.079    86.789     0.200
     6.078    88.445     0.200
     6.303    89.906     0.200
     6.387    91.648     0.200
     6.541    93.688     0.200
     6.683    94.805     0.200
     6.859    97.672     0.200
     6.880    98.188     0.200
     6.936   100.398     0.200
     6.996   100.422     0.200
     6.970   101.797     0.200
     6.984   101.500     0.200
     7.047   101.375     0.200
     7.031   100.961     0.200
     7.192   102.172     0.200
     7.204   102.508     0.200
     7.210   102.406     0.200
     7.224   102.367     0.200
     7.258   103.188     0.200
     7.263   102.609     0.200
     7.294   103.750     0.200
     7.359   105.891     0.200
     7.390   106.492     0.200
     7.433   106.188     0.200
     7.453   107.070     0.200
     7.486   107.648     0.200
     7.483   107.656     0.200
     7.533   108.289     0.200
     7.892   112.555     0.200
     7.892   112.078     0.200
     7.892   112.320     0.200
    10.940   156.227     0.200
    11.333   161.578     0.200
    11.334   162.297     0.200
     1.043    19.418     0.200
     1.212    21.219     0.200
     1.207    21.879     0.200
     1.244    22.000     0.200
     1.587    27.328     0.200
     1.797    29.680     0.200
     2.301    36.699     0.200
     2.287    36.641     0.200
     2.384    37.941     0.200
     2.438    36.770     0.200
     2.664    40.430     0.200
     2.746    42.602     0.200
     2.857    43.918     0.200
     5.670    85.055     0.200
     7.549   112.453     0.200
    10.686   156.781     0.200
    10.918   158.680     0.200
     1.046    18.875     0.200
     1.072    20.219     0.200
     1.447    20.531     0.200
     1.583    27.148     0.200
     1.560    27.781     0.200
     1.584    26.008     0.200
     1.608    27.641     0.200
     1.794    28.398     0.200
     2.002    33.617     0.200
     2.295    38.141     0.200
     2.563    40.078     0.200
     3.048    48.625     0.200
    10.919   159.375     0.200
     0.775    14.711     0.200
     0.791    14.859     0.200
     0.797    15.102     0.200
     0.804    15.512     0.200
     0.795    15.270     0.200
     0.809    15.289     0.200
     0.821    15.309     0.200
     0.838    15.629     0.200
     0.845    15.930     0.200
     0.871    16.121     0.200
     0.872    16.129     0.200
     0.890    16.500     0.200
     0.903    16.738     0.200
     0.903    16.980     0.200
     0.987    18.352     0.200
     1.121    20.918     0.200
     1.201    21.551     0.200
     1.227    21.648     0.200
     1.245    21.789     0.200
     1.254    22.020     0.200
     1.339    23.449     0.200
     1.406    24.719     0.200
     1.432    24.762     0.200
     1.531    26.078     0.200
     1.569    26.539     0.200
     1.575    26.551     0.200
     1.593    28.121     0.200
     1.649    27.570     0.200
     1.667    27.699     0.200
     1.748    29.020     0.200
     1.815    29.609     0.200
     2.000    32.391     0.200
     2.379    36.520     0.200
     2.279    37.461     0.200
     2.350    38.270     0.200
     2.339    39.250     0.200
     2.342    39.059     0.200
     2.367    39.930     0.200
     2.349    38.949     0.200
     2.441    40.359     0.200
     2.754    42.730     0.200
     2.768    43.941     0.200
     2.799    45.828     0.200
     2.875    45.699     0.200
     2.948    46.289     0.200
     2.991    48.219     0.200
     3.115    47.410     0.200
     3.151    48.879     0.200
     3.281    50.801     0.200
     3.311    50.301     0.200
     3.380    53.148     0.200
     3.431    52.441     0.200
     3.465    54.461     0.200
     3.730    57.941     0.200
     3.830    59.301     0.200
     3.850    59.199     0.200
     3.881    60.789     0.200
     3.902    60.371     0.200
     4.073    63.012     0.200
     4.095    62.531     0.200
     4.163    62.129     0.200
     4.184    63.000     0.200
     4.259    65.602     0.200
     4.284    65.078     0.200
     4.337    65.449     0.200
     4.353    66.039     0.200
     4.439    67.699     0.200
     4.494    68.289     0.200
     4.509    68.340     0.200
     4.675    70.352     0.200
     4.888    74.031     0.200
     4.910    73.461     0.200
     4.913    74.660     0.200
     4.942    74.738     0.200
     5.186    76.648     0.200
     5.202    77.129     0.200
     5.235    77.418     0.200
     5.284    78.109     0.200
     5.319    79.141     0.200
     5.575    82.711     0.200
     5.601    82.699     0.200
     5.602    83.918     0.200
     5.615    84.180     0.200
     5.676    84.301     0.200
     5.700    86.371     0.200
     6.221    91.629     0.200
     6.471    93.660     0.200
     6.515    95.289     0.200
     6.810    98.668     0.200
     7.296   105.641     0.200
     7.493   108.148     0.200
     7.596   112.863     0.200
     7.617   111.070     0.200
     7.802   112.699     0.200
     7.840   114.359     0.200
     8.800   125.879     0.200
     9.171   132.230     0.200
     9.236   132.488     0.200
    10.244   148.586     0.200
     1.083    18.848     0.200
     1.101    19.688     0.200
     1.411    19.719     0.200
     1.199    20.656     0.200
     1.359    23.527     0.200
     1.498    26.078     0.200
     1.548    26.355     0.200
     1.553    26.227     0.200
     1.583    26.316     0.200
     1.589    26.836     0.200
     1.612    27.398     0.200
     1.712    28.828     0.200
     1.759    28.855     0.200
     1.995    32.727     0.200
     2.010    32.098     0.200
     2.050    33.828     0.200
     2.382    34.938     0.200
     2.290    35.328     0.200
     2.319    36.828     0.200
     2.316    35.777     0.200
     2.329    36.336     0.200
     2.329    36.117     0.200
     2.362    36.797     0.200
     2.426    37.469     0.200
     2.423    38.219     0.200
     2.762    43.496     0.200
     2.770    43.516     0.200
     2.878    42.777     0.200
     2.942    44.887     0.200
     2.959    45.227     0.200
     2.959    43.906     0.200
     2.984    44.879     0.200
     2.988    44.629     0.200
     2.980    43.789     0.200
     2.996    44.527     0.200
     3.116    46.727     0.200
     3.147    47.617     0.200
     3.281    48.969     0.200
     3.323    48.547     0.200
     3.369    51.078     0.200
     3.437    52.426     0.200
     3.461    51.926     0.200
     3.705    56.199     0.200
     3.725    55.328     0.200
     3.824    57.727     0.200
     3.852    56.906     0.200
     3.896    57.828     0.200
     3.896    59.328     0.200
     4.065    59.246     0.200
     4.092    59.758     0.200
     4.092    64.328     0.200
     4.176    60.316     0.200
     4.168    62.027     0.200
     4.186    65.629     0.200
     4.239    63.887     0.200
     4.270    65.828     0.200
     4.273    63.887     0.200
     4.320    64.879     0.200
     4.350    65.176     0.200
     4.440    65.129     0.200
     4.492    67.629     0.200
     4.539    68.117     0.200
     4.686    69.648     0.200
     4.765    70.867     0.200
     4.875    72.969     0.200
     4.919    70.906     0.200
     4.897    72.797     0.200
     4.968    73.617     0.200
     5.082    73.426     0.200
     5.183    76.219     0.200
     5.199    75.668     0.200
     5.244    76.316     0.200
     5.562    81.539     0.200
     5.656    82.836     0.200
     5.698    85.301     0.200
     6.218    90.547     0.200
     6.219    90.848     0.200
     6.456    94.027     0.200
     6.468    91.938     0.200
     6.508    97.805     0.200
     6.515    92.137     0.200
     6.631    95.957     0.200
     6.705    95.707     0.200
     6.871    98.418     0.200
     7.105   106.766     0.200
     7.212   104.398     0.200
     7.220   105.508     0.200
     7.240   106.227     0.200
     7.288   106.598     0.200
     7.336   107.129     0.200
     7.368   108.586     0.200
     7.385   109.727     0.200
     7.564   111.918     0.200
     7.586   112.227     0.200
     7.820   116.070     0.200
     7.820   116.328     0.200
     7.820   113.848     0.200
     7.844   116.258     0.200
     7.997   117.988     0.200
     8.783   126.223     0.200
     8.783   126.828     0.200
     8.783   126.328     0.200
     9.038   134.227     0.200
     9.544   137.336     0.200
    10.153   150.395     0.200
    10.245   149.434     0.200
    10.575   150.277     0.200
    10.622   153.363     0.200
    10.726   156.977     0.200
    10.726   157.727     0.200
    10.919   156.926     0.200
    10.919   156.629     0.200
    10.921   156.828     0.200
    10.921   157.602     0.200
    10.921   156.527     0.200
    14.049   198.027     0.200
    14.347   204.766     0.200
    14.430   203.855     0.200
    14.552   202.129     0.200
    14.591   204.508     0.200
    14.700   205.047     0.200
    14.875   206.098     0.200
    15.025   209.316     0.200
    15.140   214.973     0.200
    15.180   210.816     0.200
    15.223   211.168     0.200
    15.309   212.855     0.200
    15.382   212.977     0.200
    15.444   213.496     0.200
    15.498   214.688     0.200
    15.497   214.988     0.200
    15.525   215.426     0.200
    15.590   216.137     0.200
    15.599   216.738     0.200
    15.663   217.969     0.200
    15.794   218.508     0.200
    15.800   218.117     0.200
    16.001   221.105     0.200
    16.578   227.887     0.200
    17.306   236.227     0.200
    17.592   240.207     0.200
    17.600   241.188     0.200
    17.699   241.578     0.200
    18.099   246.676     0.200
    18.201   247.516     0.200
    18.370   256.727     0.200
    20.401   278.898     0.200
    20.401   280.926     0.200
     1.009    18.867     0.200
     1.099    20.547     0.200
     1.123    19.781     0.200
     1.180    21.422     0.200
     1.210    21.984     0.200
     1.223    22.312     0.200
     1.225    21.414     0.200
     1.225    21.391     0.200
     1.361    24.422     0.200
     1.359    24.953     0.200
     1.412    24.703     0.200
     1.433    24.586     0.200
     1.438    25.141     0.200
     1.494    26.117     0.200
     1.551    26.914     0.200
     1.554    26.641     0.200
     1.582    26.875     0.200
     1.586    27.391     0.200
     1.612    27.336     0.200
     1.655    27.883     0.200
     1.710    29.555     0.200
     1.736    28.836     0.200
     2.008    32.930     0.200
     2.289    37.000     0.200
     2.314    37.531     0.200
     2.325    37.961     0.200
     2.327    37.516     0.200
     2.361    38.117     0.200
     2.361    38.281     0.200
     2.420    39.883     0.200
     2.428    37.805     0.200
     2.760    44.172     0.200
     2.767    44.555     0.200
     2.790    45.016     0.200
     2.875    46.031     0.200
     2.957    46.344     0.200
     2.976    46.641     0.200
     3.076    47.773     0.200
     3.113    48.922     0.200
     3.144    50.133     0.200
     3.278    51.320     0.200
     3.322    52.500     0.200
     3.365    53.422     0.200
     3.434    54.367     0.200
     3.458    55.094     0.200
     3.702    57.945     0.200
     3.708    58.203     0.200
     3.721    57.422     0.200
     3.820    60.852     0.200
     3.859    61.234     0.200
     3.892    60.422     0.200
     3.897    59.844     0.200
     4.062    63.391     0.200
     4.089    61.836     0.200
     4.175    64.875     0.200
     4.169    63.375     0.200
     4.237    64.742     0.200
     4.269    64.555     0.200
     4.267    64.703     0.200
     4.317    65.422     0.200
     4.347    68.094     0.200
     4.437    67.906     0.200
     4.488    67.562     0.200
     4.481    68.773     0.200
     4.488    68.297     0.200
     4.536    68.844     0.200
     4.684    70.336     0.200
     4.761    71.547     0.200
     4.872    73.734     0.200
     4.893    74.000     0.200
     4.918    73.820     0.200
     4.921    73.891     0.200
     5.079    76.453     0.200
     5.180    77.727     0.200
     5.195    77.156     0.200
     5.242    77.641     0.200
     5.282    80.023     0.200
     5.437    79.922     0.200
     5.558    82.891     0.200
     5.598    84.367     0.200
     5.608    82.141     0.200
     5.597    83.930     0.200
     5.653    83.055     0.200
     5.662    82.711     0.200
     6.025    88.516     0.200
     6.170    90.922     0.200
     6.215    91.000     0.200
     6.223    91.641     0.200
     6.453    95.062     0.200
     6.464    94.844     0.200
     6.512    94.453     0.200
     6.631    96.305     0.200
     6.637    97.172     0.200
     6.737    98.711     0.200
     6.790    97.320     0.200
     7.103   103.102     0.200
     7.237   104.750     0.200
     7.287   105.336     0.200
     7.382   106.500     0.200
     7.471   106.742     0.200
     7.458   106.211     0.200
     7.583   114.195     0.200
     7.583   109.930     0.200
     7.743   112.375     0.200
     7.782   112.875     0.200
     7.819   115.945     0.200
     7.819   113.047     0.200
     7.820   112.531     0.200
     7.820   112.797     0.200
     8.030   115.211     0.200
     8.783   125.953     0.200
     9.149   132.391     0.200
    10.156   148.617     0.200
    10.243   149.102     0.200
    10.576   151.406     0.200
    10.722   153.445     0.200
    10.722   152.156     0.200
    10.722   158.625     0.200
    10.922   155.648     0.200
     0.900    16.442     0.200
     0.906    16.442     0.200
     0.932    17.082     0.200
     0.948    17.142     0.200
     0.943    17.012     0.200
     1.012    17.972     0.200
     1.109    19.462     0.200
     1.103    20.372     0.200
     1.206    21.182     0.200
     1.357    23.942     0.200
     1.548    26.802     0.200
     1.615    25.542     0.200
     1.760    29.202     0.200
     2.007    32.532     0.200
     2.287    36.922     0.200
     2.331    38.652     0.200
     2.328    38.922     0.200
     2.359    38.042     0.200
     2.429    36.592     0.200
     2.424    38.922     0.200
     2.664    40.402     0.200
     2.759    42.492     0.200
     2.767    43.912     0.200
     3.114    47.282     0.200
     3.145    47.922     0.200
     5.696    86.183     0.200
     7.585   113.202     0.200
     7.823   115.321     0.200
    10.726   159.199     0.200
    10.925   156.627     0.200
     0.755    14.451     0.200
     0.776    14.832     0.200
     0.802    14.902     0.200
     0.797    14.982     0.200
     0.793    14.672     0.200
     0.791    14.711     0.200
     0.809    15.223     0.200
     0.819    15.252     0.200
     0.819    15.152     0.200
     0.831    15.461     0.200
     0.849    15.803     0.200
     0.863    15.771     0.200
     0.885    16.082     0.200
     0.858    15.732     0.200
     0.865    16.002     0.200
     0.879    16.412     0.200
     0.886    16.201     0.200
     0.898    16.643     0.200
     0.898    16.633     0.200
     0.908    16.621     0.200
     0.926    17.021     0.200
     0.940    17.092     0.200
     0.994    17.672     0.200
     0.976    17.492     0.200
     0.979    17.752     0.200
     1.012    18.053     0.200
     0.977    18.451     0.200
     0.988    18.012     0.200
     1.011    18.271     0.200
     1.011    18.191     0.200
     1.023    18.633     0.200
     1.043    18.482     0.200
     1.027    18.332     0.200
     1.026    18.352     0.200
     1.056    19.492     0.200
     1.083    19.111     0.200
     1.070    18.852     0.200
     1.096    19.252     0.200
     1.106    19.502     0.200
     1.083    19.121     0.200
     1.100    20.621     0.200
     1.150    20.371     0.200
     1.171    20.822     0.200
     1.184    20.951     0.200
     1.184    20.672     0.200
     1.218    21.451     0.200
     1.216    21.172     0.200
     1.258    22.883     0.200
     1.279    22.361     0.200
     1.358    23.691     0.200
     1.347    24.521     0.200
     1.368    23.432     0.200
     1.373    23.883     0.200
     1.406    23.961     0.200
     1.398    24.102     0.200
     1.550    25.852     0.200
     1.568    27.162     0.200
     1.553    25.912     0.200
     1.621    26.922     0.200
     1.643    28.012     0.200
     1.668    27.973     0.200
     1.704    28.521     0.200
     1.796    29.531     0.200
     1.970    32.422     0.200
     2.253    36.723     0.200
     2.325    37.371     0.200
     2.468    37.383     0.200
     2.698    40.893     0.200
     2.721    42.781     0.200
     2.725    44.451     0.200
     2.921    46.162     0.200
     3.072    46.912     0.200
     3.105    48.312     0.200
     3.237    49.432     0.200
     3.393    51.732     0.200
     3.683    58.951     0.200
     3.717    57.652     0.200
     3.807    57.711     0.200
     3.874    59.133     0.200
     3.914    59.461     0.200
     4.049    61.771     0.200
     4.197    62.541     0.200
     4.197    62.422     0.200
     4.307    65.211     0.200
     4.447    66.482     0.200
     4.647    68.973     0.200
     4.738    71.111     0.200
     4.879    72.861     0.200
     4.871    73.412     0.200
     4.932    73.662     0.200
     5.317    78.393     0.200
     5.654    83.020     0.200
     6.181    91.012     0.200
     6.471    94.893     0.200
     6.655    97.242     0.200
     7.293   106.791     0.200
     7.830   113.582     0.200
     7.832   112.916     0.200
    10.954   157.078     0.200
     0.760    14.365     0.200
     0.800    15.094     0.200
     0.813    15.094     0.200
     0.906    16.535     0.200
     0.908    16.654     0.200
     0.931    17.145     0.200
     1.197    21.225     0.200
     1.349    24.404     0.200
     1.539    26.574     0.200
     1.578    26.504     0.200
     1.593    26.844     0.200
     1.618    27.514     0.200
     1.712    28.594     0.200
     1.752    29.305     0.200
     2.007    32.764     0.200
     2.378    36.764     0.200
     2.287    37.365     0.200
     2.338    37.545     0.200
     2.360    38.264     0.200
     2.358    38.115     0.200
     2.376    38.594     0.200
     2.433    39.215     0.200
     2.665    40.965     0.200
     2.761    42.674     0.200
     2.771    42.594     0.200
     2.799    43.445     0.200
     2.989    45.934     0.200
     3.089    48.645     0.200
     3.118    47.934     0.200
     3.147    47.924     0.200
     3.151    48.285     0.200
     3.283    50.555     0.200
     3.319    50.074     0.200
     3.436    51.945     0.200
     3.465    52.105     0.200
     3.719    57.385     0.200
     3.730    56.465     0.200
     3.829    57.994     0.200
     3.853    58.115     0.200
     3.871    58.955     0.200
     3.901    59.084     0.200
     3.906    59.635     0.200
     3.916    58.744     0.200
     4.071    60.994     0.200
     4.174    62.734     0.200
     4.249    63.924     0.200
     4.280    64.895     0.200
     4.280    65.635     0.200
     4.330    66.035     0.200
     4.501    68.605     0.200
     4.548    67.775     0.200
     4.774    71.715     0.200
     4.883    73.855     0.200
     4.931    74.855     0.200
     5.187    76.305     0.200
     5.287    78.154     0.200
     5.570    82.244     0.200
     6.638    97.275     0.200
    10.927   155.869     0.200
     0.792    14.727     0.200
     0.808    14.992     0.200
     0.810    14.891     0.200
     0.815    15.195     0.200
     0.881    16.242     0.200
     0.911    16.633     0.200
     0.913    16.781     0.200
     0.943    17.188     0.200
     0.992    17.875     0.200
     1.000    18.547     0.200
     1.010    18.344     0.200
     1.025    18.297     0.200
     1.091    19.578     0.200
     1.107    20.836     0.200
     1.424    20.672     0.200
     1.562    25.664     0.200
     1.552    26.344     0.200
     1.569    27.156     0.200
     1.632    27.328     0.200
     1.689    29.383     0.200
     1.774    29.047     0.200
     1.987    31.797     0.200
     2.056    33.344     0.200
     2.236    36.164     0.200
     2.403    36.383     0.200
     2.268    36.797     0.200
     2.293    37.727     0.200
     2.313    37.477     0.200
     2.340    37.719     0.200
     2.339    37.617     0.200
     2.420    39.117     0.200
     2.739    42.812     0.200
     2.775    44.281     0.200
     2.936    45.414     0.200
     2.965    45.969     0.200
     2.966    46.414     0.200
     3.094    46.672     0.200
     3.082    48.492     0.200
     3.127    47.664     0.200
     3.259    49.766     0.200
     3.301    49.719     0.200
     3.720    56.695     0.200
     3.805    58.633     0.200
     3.829    57.594     0.200
     3.877    58.125     0.200
     3.893    59.102     0.200
     3.866    58.016     0.200
     3.912    59.086     0.200
     4.047    61.742     0.200
     4.071    60.633     0.200
     4.188    61.102     0.200
     4.329    66.031     0.200
     4.313    65.273     0.200
     4.468    66.688     0.200
     4.486    68.469     0.200
     4.756    71.477     0.200
     4.934    74.055     0.200
     5.162    76.773     0.200
     5.178    77.688     0.200
     5.221    78.234     0.200
     5.315    78.477     0.200
     5.550    83.398     0.200
     5.677    86.164     0.200
     5.774    84.703     0.200
     6.020    89.656     0.200
     6.150    91.227     0.200
     6.197    92.008     0.200
     6.217    93.188     0.200
     6.718    97.992     0.200
     7.109   105.188     0.200
     7.236   105.898     0.200
     7.291   105.383     0.200
     7.375   106.844     0.200
     7.483   108.367     0.200
     7.493   108.055     0.200
     7.571   112.547     0.200
     7.571   109.133     0.200
     7.599   108.836     0.200
     7.727   113.117     0.200
     7.746   113.422     0.200
     7.780   112.906     0.200
     7.832   115.391     0.200
     7.832   114.438     0.200
     8.022   116.227     0.200
     8.802   125.492     0.200
     9.028   129.984     0.200
     9.235   133.281     0.200
    10.718   158.570     0.200
    10.942   155.562     0.200
    10.942   156.172     0.200
    13.421   191.406     0.200
    15.123   211.406     0.200
    15.274   216.445     0.200
    15.420   217.984     0.200
     0.795    15.044     0.200
     0.824    15.624     0.200
     0.826    15.563     0.200
     0.865    16.144     0.200
     1.464    21.714     0.200
     1.229    21.944     0.200
     1.363    24.794     0.200
     1.815    30.194     0.200
     2.163    34.914     0.200
     2.239    37.834     0.200
     2.272    39.154     0.200
     2.335    37.464     0.200
     2.393    39.273     0.200
     2.712    41.684     0.200
     2.704    43.104     0.200
     2.731    43.924     0.200
     2.815    46.494     0.200
     5.634    86.236     0.200
     7.529   112.139     0.200
     7.831   117.070     0.200
    10.684   159.414     0.200
    10.965   159.449     0.200
     0.846    15.883     0.200
     0.884    16.703     0.200
     0.886    16.521     0.200
     0.892    16.521     0.200
     0.919    17.123     0.200
     0.938    17.373     0.200
     0.961    17.562     0.200
     0.966    18.242     0.200
     0.998    18.082     0.200
     0.999    18.342     0.200
     1.011    18.213     0.200
     1.011    18.262     0.200
     1.015    18.732     0.200
     1.038    19.203     0.200
     1.050    18.752     0.200
     1.061    19.252     0.200
     1.094    19.453     0.200
     1.093    20.283     0.200
     1.113    19.793     0.200
     1.161    20.703     0.200
     1.165    20.553     0.200
     1.465    21.283     0.200
     1.230    21.703     0.200
     1.364    24.342     0.200
     1.442    27.033     0.200
     1.649    28.562     0.200
     1.817    30.232     0.200
     2.238    37.012     0.200
     2.252    36.703     0.200
     2.311    38.223     0.200
     2.335    38.682     0.200
     2.392    40.082     0.200
     2.703    43.033     0.200
     2.704    42.902     0.200
     2.713    41.832     0.200
     2.813    44.322     0.200
     3.051    47.613     0.200
     5.632    85.146     0.200
     7.528   112.582     0.200
     7.831   116.352     0.200
    10.683   155.758     0.200
    10.966   158.258     0.200
    15.079   215.938     0.200
     0.958    18.625     0.200
     0.967    18.525     0.200
     1.045    19.645     0.200
     1.086    19.496     0.200
     1.102    20.826     0.200
     1.104    19.885     0.200
     1.154    21.525     0.200
     1.167    20.936     0.200
     1.163    21.096     0.200
     1.216    21.695     0.200
     1.222    22.086     0.200
     1.266    22.205     0.200
     1.307    22.766     0.200
     1.355    24.475     0.200
     1.351    23.885     0.200
     1.392    24.016     0.200
     1.576    28.045     0.200
     1.813    30.564     0.200
     2.441    40.865     0.200
     2.812    43.166     0.200
     5.633    87.156     0.200
     7.532   112.654     0.200
     7.839   115.854     0.200
    10.689   158.225     0.200
    10.972   157.721     0.200
     1.153    21.299     0.200
     1.166    21.250     0.200
     1.163    20.920     0.200
     1.215    21.230     0.200
     1.221    21.859     0.200
     1.459    21.410     0.200
     1.258    22.299     0.200
     1.354    23.840     0.200
     1.352    24.039     0.200
     1.377    24.090     0.200
     1.449    26.891     0.200
     1.532    25.699     0.200
     1.534    25.740     0.200
     1.526    27.570     0.200
     1.575    27.189     0.200
     1.602    26.789     0.200
     1.647    28.891     0.200
     1.811    29.859     0.200
     2.233    36.750     0.200
     2.400    38.699     0.200
     2.704    43.180     0.200
     2.900    45.600     0.200
     3.073    48.539     0.200
     3.216    49.641     0.200
     3.318    51.721     0.200
     3.786    57.830     0.200
     3.836    60.119     0.200
     3.926    60.260     0.200
     4.237    65.000     0.200
     4.250    65.010     0.200
     4.287    65.061     0.200
     4.287    65.221     0.200
     4.462    67.959     0.200
     4.498    67.910     0.200
     4.728    72.670     0.200
     4.828    73.850     0.200
     4.862    72.660     0.200
     4.940    74.240     0.200
     5.634    88.254     0.200
     7.101   104.209     0.200
     7.533   114.635     0.200
     7.550   110.650     0.200
    10.691   158.543     0.200
     1.075    20.297     0.200
     1.079    19.789     0.200
     1.080    19.656     0.200
     1.081    19.984     0.200
     1.117    20.180     0.200
     1.176    21.031     0.200
     1.261    22.211     0.200
     1.274    22.406     0.200
     1.268    22.805     0.200
     1.301    23.789     0.200
     1.344    24.047     0.200
     1.352    23.945     0.200
     1.392    25.758     0.200
     1.609    27.070     0.200
     1.609    27.984     0.200
     1.629    27.555     0.200
     1.688    29.195     0.200
     1.829    30.875     0.200
     1.871    29.984     0.200
     2.090    34.617     0.200
     2.153    36.211     0.200
     2.419    37.508     0.200
     2.424    40.125     0.200
     2.603    40.828     0.200
     2.615    41.422     0.200
     2.652    42.719     0.200
     2.685    42.688     0.200
     2.827    44.266     0.200
     2.886    44.008     0.200
     3.006    47.336     0.200
     3.048    47.156     0.200
     3.155    48.359     0.200
     3.229    49.508     0.200
     3.312    51.047     0.200
     3.343    52.305     0.200
     3.462    53.695     0.200
     3.482    53.758     0.200
     3.747    57.797     0.200
     3.776    58.250     0.200
     3.781    58.336     0.200
     3.869    59.047     0.200
     3.933    60.422     0.200
     3.954    59.172     0.200
     3.996    60.508     0.200
     4.076    61.125     0.200
     4.120    62.180     0.200
     4.132    62.391     0.200
     4.184    62.461     0.200
     4.345    65.734     0.200
     4.383    66.469     0.200
     4.382    65.922     0.200
     4.484    68.211     0.200
     4.505    68.648     0.200
     4.509    69.070     0.200
     4.513    68.477     0.200
     4.560    68.445     0.200
     4.700    70.398     0.200
     4.742    72.688     0.200
     4.796    72.484     0.200
     4.942    75.398     0.200
     5.082    75.867     0.200
     5.091    76.570     0.200
     5.163    77.977     0.200
     5.187    77.758     0.200
     5.209    77.438     0.200
     5.210    79.875     0.200
     5.562    83.555     0.200
     5.585    82.797     0.200
     5.633    84.008     0.200
     5.670    86.219     0.200
     5.707    84.852     0.200
     5.808    85.281     0.200
     6.207    92.070     0.200
     6.302    93.578     0.200
     6.451    95.320     0.200
     6.460    94.930     0.200
     6.905   100.867     0.200
     7.372   108.602     0.200
     7.674   114.680     0.200
     7.674   112.281     0.200
     7.713   113.711     0.200
     7.794   114.406     0.200
     8.108   121.125     0.200
     8.108   118.797     0.200
     9.495   137.117     0.200
     9.603   138.875     0.200
    10.910   159.656     0.200
    11.167   161.680     0.200
     0.753    14.129     0.200
     0.771    14.398     0.200
     0.799    14.891     0.200
     0.801    15.020     0.200
     0.811    15.109     0.200
     0.817    15.109     0.200
     0.836    15.430     0.200
     0.851    15.641     0.200
     0.857    15.750     0.200
     0.871    16.090     0.200
     0.890    16.430     0.200
     0.898    16.238     0.200
     0.904    16.707     0.200
     0.905    16.598     0.200
     0.908    16.609     0.200
     0.920    16.840     0.200
     0.923    17.000     0.200
     0.933    16.988     0.200
     0.937    17.027     0.200
     0.971    17.609     0.200
     0.984    18.438     0.200
     1.003    18.000     0.200
     1.005    18.020     0.200
     1.023    18.328     0.200
     1.102    19.789     0.200
     1.124    20.258     0.200
     1.184    20.770     0.200
     1.182    20.520     0.200
     1.224    21.410     0.200
     1.336    23.629     0.200
     1.384    25.469     0.200
     1.513    25.539     0.200
     1.527    26.180     0.200
     1.596    26.777     0.200
     1.628    26.027     0.200
     1.709    28.449     0.200
     1.745    28.699     0.200
     2.001    32.078     0.200
     2.279    36.359     0.200
     2.433    36.590     0.200
     2.673    40.199     0.200
     2.755    42.559     0.200
     2.795    43.188     0.200
     3.117    47.527     0.200
     3.154    47.398     0.200
     3.283    50.180     0.200
     3.384    51.488     0.200
     3.727    56.699     0.200
     3.733    56.598     0.200
     3.834    58.008     0.200
     3.919    58.789     0.200
     4.185    62.199     0.200
     4.262    64.051     0.200
     4.288    65.090     0.200
     4.557    68.801     0.200
     5.703    85.059     0.200
     7.600   113.254     0.200
     7.843   114.672     0.200
    10.745   155.680     0.200
    10.936   156.031     0.200
     0.750    14.117     0.200
     0.726    13.727     0.200
     0.758    14.037     0.200
     0.782    14.267     0.200
     0.762    14.317     0.200
     0.833    15.447     0.200
     0.811    14.647     0.200
     0.780    14.897     0.200
     0.850    15.217     0.200
     0.834    15.287     0.200
     0.830    15.207     0.200
     0.859    15.507     0.200
     0.807    15.207     0.200
     0.932    17.457     0.200
     0.881    16.137     0.200
     0.871    16.607     0.200
     0.897    16.377     0.200
     0.903    16.677     0.200
     0.963    17.077     0.200
     0.896    16.837     0.200
     0.904    17.057     0.200
     0.925    16.757     0.200
     1.097    19.647     0.200
     1.061    19.837     0.200
     1.182    20.947     0.200
     1.258    22.207     0.200
     1.275    21.807     0.200
     1.424    23.237     0.200
     1.434    23.967     0.200
     1.452    24.517     0.200
     1.598    26.157     0.200
     1.627    26.427     0.200
     1.985    32.147     0.200
     2.029    33.097     0.200
     2.160    34.527     0.200
     2.122    34.227     0.200
     2.201    35.357     0.200
     2.237    36.438     0.200
     2.359    35.957     0.200
     2.360    36.367     0.200
     2.432    39.587     0.200
     2.512    39.947     0.200
     2.663    41.647     0.200
     2.966    42.907     0.200
     2.905    44.257     0.200
     3.169    47.207     0.200
     3.202    49.577     0.200
     3.195    49.637     0.200
     3.416    52.817     0.200
     3.461    53.347     0.200
     4.500    67.627     0.200
     4.544    67.557     0.200
     4.774    72.127     0.200
     4.905    71.507     0.200
     4.932    74.067     0.200
     5.160    78.433     0.200
     5.496    81.617     0.200
     5.582    83.027     0.200
     5.714    84.667     0.200
     5.952    87.707     0.200
     6.648    97.297     0.200
     7.243   105.567     0.200
     7.338   105.757     0.200
     7.311   107.054     0.200
     7.740   112.077     0.200
     7.733   112.117     0.200
     8.402   121.366     0.200
     8.402   120.977     0.200
     8.403   120.847     0.200
     8.909   129.717     0.200
     9.504   134.627     0.200
    10.246   146.577     0.200
    10.734   154.981     0.200
    11.315   161.857     0.200
    11.673   166.967     0.200
    11.674   167.107     0.200
    11.674   166.277     0.200
     0.892    16.656     0.200
     0.885    16.766     0.200
     0.895    16.566     0.200
     0.918    17.328     0.200
     0.912    17.098     0.200
     0.921    17.578     0.200
     0.981    18.277     0.200
     1.048    18.875     0.200
     1.086    19.855     0.200
     1.112    20.598     0.200
     1.264    21.926     0.200
     1.293    23.285     0.200
     1.340    23.566     0.200
     1.482    26.328     0.200
     1.641    26.875     0.200
     1.695    30.516     0.200
     1.778    29.086     0.200
     1.957    33.027     0.200
     2.042    32.809     0.200
     2.068    34.867     0.200
     2.169    36.656     0.200
     2.208    36.777     0.200
     2.308    37.547     0.200
     2.530    41.027     0.200
     2.606    42.125     0.200
     3.064    48.035     0.200
     3.117    49.215     0.200
     5.200    80.051     0.200
     5.200    78.406     0.200
     5.899    88.008     0.200
     5.913    87.898     0.200
     6.515    94.516     0.200
     6.687    99.598     0.200
     6.805   101.777     0.200
     7.080   104.715     0.200
     7.105   104.215     0.200
     7.510   111.887     0.200
     7.721   112.715     0.200
     7.922   117.445     0.200
     8.127   121.578     0.200
     8.322   120.207     0.200
     8.323   121.168     0.200
     8.819   131.855     0.200
     9.551   141.773     0.200
     9.879   142.668     0.200
    11.049   162.090     0.200
    16.218   225.105     0.200
    16.491   229.316     0.200
    18.266   251.258     0.200
     0.985    17.664     0.200
     1.042    18.422     0.200
     1.061    19.703     0.200
     1.071    18.875     0.200
     1.071    18.922     0.200
     1.085    19.258     0.200
     1.088    19.234     0.200
     1.102    19.492     0.200
     1.109    19.578     0.200
     1.115    19.672     0.200
     1.139    20.320     0.200
     1.163    20.969     0.200
     1.169    20.734     0.200
     1.204    21.008     0.200
     1.211    21.031     0.200
     1.211    20.984     0.200
     1.223    21.250     0.200
     1.228    21.469     0.200
     1.271    22.000     0.200
     1.436    24.023     0.200
     1.442    24.141     0.200
     1.446    24.164     0.200
     1.453    24.375     0.200
     1.458    24.312     0.200
     1.466    24.461     0.200
     1.485    24.414     0.200
     1.482    24.555     0.200
     1.543    25.648     0.200
     1.541    26.352     0.200
     1.570    26.258     0.200
     1.637    27.133     0.200
     1.752    28.250     0.200
     1.820    30.008     0.200
     2.138    32.758     0.200
     1.988    32.938     0.200
     2.213    33.828     0.200
     2.215    34.523     0.200
     2.336    37.219     0.200
     2.486    37.984     0.200
     2.561    39.828     0.200
     2.601    40.562     0.200
     2.979    44.750     0.200
     3.011    45.312     0.200
     3.031    46.008     0.200
     3.116    46.242     0.200
     3.160    48.094     0.200
     3.156    47.734     0.200
     3.239    48.750     0.200
     3.358    50.438     0.200
     3.371    51.305     0.200
     3.390    52.562     0.200
     3.586    54.859     0.200
     3.705    55.953     0.200
     3.810    57.055     0.200
     3.922    59.273     0.200
     3.977    59.539     0.200
     4.044    59.500     0.200
     4.061    61.523     0.200
     4.093    62.664     0.200
     4.142    62.391     0.200
     4.302    65.102     0.200
     4.337    65.469     0.200
     4.354    64.820     0.200
     4.394    66.859     0.200
     4.683    69.914     0.200
     4.729    69.641     0.200
     5.069    74.602     0.200
     5.128    75.703     0.200
     5.243    77.508     0.200
     5.325    78.484     0.200
     5.455    80.594     0.200
     5.824    84.422     0.200
     5.943    86.281     0.200
     6.200    89.125     0.200
     6.462    93.289     0.200
     7.172   103.141     0.200
     7.224   103.969     0.200
     7.383   105.273     0.200
     7.557   107.812     0.200
     7.604   108.328     0.200
     7.604   109.602     0.200
     7.689   109.523     0.200
     7.728   110.000     0.200
     7.799   116.102     0.200
     7.799   111.625     0.200
     7.811   112.609     0.200
     7.831   112.188     0.200
     7.931   112.664     0.200
     8.669   123.961     0.200
    10.769   154.156     0.200
     0.984    18.863     0.200
     1.007    19.164     0.200
     0.998    19.262     0.200
     1.002    19.102     0.200
     1.048    19.492     0.200
     1.113    20.363     0.200
     1.117    19.832     0.200
     1.145    21.672     0.200
     1.288    22.863     0.200
     1.290    23.801     0.200
     1.333    24.762     0.200
     1.514    25.891     0.200
     1.493    26.293     0.200
     1.550    27.914     0.200
     1.607    26.961     0.200
     1.714    28.023     0.200
     1.763    30.984     0.200
     1.919    32.504     0.200
     2.009    33.273     0.200
     2.077    34.902     0.200
     2.107    36.004     0.200
     2.188    36.262     0.200
     2.205    37.121     0.200
     2.304    35.984     0.200
     2.321    37.801     0.200
     2.444    40.523     0.200
     2.489    40.652     0.200
     2.580    42.262     0.200
     2.596    42.262     0.200
     2.684    42.922     0.200
     2.781    45.133     0.200
     2.884    45.141     0.200
     3.096    46.832     0.200
     3.125    47.062     0.200
     3.256    52.203     0.200
     3.283    52.961     0.200
     3.324    53.414     0.200
     3.358    51.031     0.200
     3.420    53.824     0.200
     3.474    54.781     0.200
     3.479    54.613     0.200
     3.666    58.004     0.200
     3.908    61.113     0.200
     3.996    62.414     0.200
     4.029    62.543     0.200
     4.249    64.824     0.200
     4.246    64.953     0.200
     4.306    66.324     0.200
     4.305    65.863     0.200
     4.430    68.203     0.200
     4.514    67.773     0.200
     4.549    69.621     0.200
     4.575    70.953     0.200
     4.644    71.363     0.200
     4.658    71.742     0.200
     4.746    73.074     0.200
     4.757    71.164     0.200
     4.778    73.973     0.200
     4.790    73.523     0.200
     4.822    74.051     0.200
     4.854    71.961     0.200
     4.854    71.852     0.200
     5.212    79.824     0.200
     5.238    80.754     0.200
     5.243    80.211     0.200
     5.243    80.363     0.200
     5.479    82.184     0.200
     5.517    83.621     0.200
     5.780    87.012     0.200
     5.796    88.043     0.200
     5.921    88.133     0.200
     6.060    89.652     0.200
     6.205    91.562     0.200
     6.357    93.391     0.200
     6.451    96.441     0.200
     7.296   106.422     0.200
     7.293   106.684     0.200
     7.383   110.137     0.200
     7.788   115.891     0.200
     8.385   122.332     0.200
     8.385   122.762     0.200
     8.385   122.992     0.200
     9.459   135.734     0.200
    10.785   156.664     0.200
    11.264   160.551     0.200
    11.617   166.688     0.200
    11.617   165.723     0.200
    14.852   213.082     0.200
    15.175   214.164     0.200
    15.180   214.484     0.200
    16.017   225.453     0.200
    16.060   225.613     0.200
    16.096   225.891     0.200
    16.151   226.352     0.200
    16.152   227.082     0.200
    16.164   227.762     0.200
    16.234   227.074     0.200
    16.638   233.051     0.200
    16.868   235.242     0.200
    16.937   236.371     0.200
    17.045   237.543     0.200
    17.460   242.824     0.200
    18.304   252.934     0.200
     1.046    19.146     0.200
     1.058    20.516     0.200
     1.064    19.916     0.200
     1.096    19.605     0.200
     1.439    25.465     0.200
     1.653    28.555     0.200
     1.679    29.095     0.200
     1.705    29.755     0.200
     1.787    29.275     0.200
     1.909    32.485     0.200
     1.932    32.166     0.200
     2.033    32.675     0.200
     2.125    35.766     0.200
     2.253    36.726     0.200
     2.266    37.405     0.200
     2.310    38.335     0.200
     2.353    37.416     0.200
     2.375    38.615     0.200
     2.559    41.436     0.200
     2.581    42.155     0.200
     2.641    42.555     0.200
     2.720    42.666     0.200
     2.796    45.055     0.200
     2.943    47.996     0.200
     3.026    48.585     0.200
     5.152    78.920     0.200
     7.462   111.120     0.200
     8.809   127.989     0.200
    11.007   159.715     0.200
    12.026   172.049     0.200
    14.860   212.140     0.200
     1.052    19.166     0.200
     1.086    19.436     0.200
     1.183    21.057     0.200
     1.198    21.156     0.200
     1.209    21.176     0.200
     1.215    21.996     0.200
     1.209    21.285     0.200
     1.222    22.346     0.200
     1.467    21.506     0.200
     1.262    22.396     0.200
     1.259    22.506     0.200
     1.267    22.887     0.200
     1.273    22.166     0.200
     1.267    22.096     0.200
     1.307    22.936     0.200
     1.406    24.846     0.200
     1.407    24.246     0.200
     1.426    24.695     0.200
     1.430    26.875     0.200
     1.443    26.096     0.200
     1.508    25.547     0.200
     1.511    26.146     0.200
     1.533    26.557     0.200
     1.595    27.496     0.200
     1.592    26.926     0.200
     1.593    26.797     0.200
     1.600    27.826     0.200
     1.660    27.756     0.200
     1.667    29.166     0.200
     1.677    28.365     0.200
     1.690    28.855     0.200
     1.740    29.945     0.200
     1.746    29.506     0.200
     1.772    29.807     0.200
     1.813    29.855     0.200
     1.875    31.705     0.200
     1.980    32.525     0.200
     2.004    33.146     0.200
     2.287    38.436     0.200
     2.320    37.137     0.200
     2.363    39.346     0.200
     2.366    38.846     0.200
     2.370    38.066     0.200
     2.441    37.307     0.200
     2.661    41.266     0.200
     2.750    43.176     0.200
     2.776    43.186     0.200
     2.851    44.326     0.200
     3.026    47.057     0.200
     3.085    47.426     0.200
     3.104    48.105     0.200
     3.131    48.186     0.200
     3.325    52.115     0.200
     3.609    56.016     0.200
     3.668    56.855     0.200
     3.722    57.346     0.200
     3.712    58.205     0.200
     3.729    57.875     0.200
     3.830    59.365     0.200
     3.865    58.375     0.200
     4.053    61.977     0.200
     4.097    62.486     0.200
     4.153    61.846     0.200
     4.153    61.996     0.200
     4.189    64.217     0.200
     4.188    65.887     0.200
     4.262    65.076     0.200
     4.434    68.346     0.200
     4.466    66.986     0.200
     4.482    68.557     0.200
     4.683    70.666     0.200
     4.707    72.785     0.200
     4.839    74.146     0.200
     4.882    74.176     0.200
     4.910    73.105     0.200
     5.234    76.406     0.200
     5.268    77.547     0.200
     5.432    80.846     0.200
     5.514    81.387     0.200
     5.542    83.236     0.200
     5.571    85.236     0.200
     5.659    84.971     0.200
     6.200    91.605     0.200
     6.414    96.816     0.200
     6.608    97.436     0.200
     7.053   103.896     0.200
     7.253   106.396     0.200
     7.534   111.910     0.200
     7.782   114.529     0.200
     8.764   125.336     0.200
    10.215   150.543     0.200
    10.561   151.336     0.200
    10.668   156.936     0.200
    10.912   157.410     0.200
    14.141   200.455     0.200
    14.180   202.396     0.200
    14.315   202.646     0.200
    14.414   203.846     0.200
    14.476   204.455     0.200
    14.511   204.826     0.200
    14.516   205.227     0.200
    14.732   208.797     0.200
    14.834   207.057     0.200
    14.912   210.086     0.200
    14.988   211.275     0.200
    15.090   213.365     0.200
    15.343   216.236     0.200
    15.458   217.416     0.200
    15.494   218.406     0.200
    17.074   237.736     0.200
    17.152   238.486     0.200
    17.253   240.756     0.200
    18.168   252.016     0.200
    18.168   251.666     0.200
    18.336   254.266     0.200
    18.336   253.486     0.200
     1.126    20.312     0.200
     1.179    20.922     0.200
     1.194    21.213     0.200
     1.206    21.252     0.200
     1.205    21.223     0.200
     1.213    21.672     0.200
     1.223    22.133     0.200
     1.473    21.701     0.200
     1.258    22.521     0.200
     1.269    23.232     0.200
     1.303    22.803     0.200
     1.301    23.021     0.200
     1.355    23.812     0.200
     1.408    24.771     0.200
     1.404    24.213     0.200
     1.422    24.582     0.200
     1.425    26.941     0.200
     1.437    25.232     0.200
     1.506    25.713     0.200
     1.507    25.812     0.200
     1.541    26.432     0.200
     1.590    26.861     0.200
     1.590    27.021     0.200
     1.601    26.652     0.200
     1.686    28.762     0.200
     1.756    29.682     0.200
     1.818    29.752     0.200
     1.975    32.422     0.200
     2.001    33.021     0.200
     2.429    35.521     0.200
     2.271    36.781     0.200
     2.285    36.912     0.200
     2.360    39.752     0.200
     2.367    37.691     0.200
     2.362    38.383     0.200
     2.445    37.082     0.200
     2.664    41.072     0.200
     2.734    43.121     0.200
     2.746    43.031     0.200
     2.772    43.053     0.200
     2.943    48.072     0.200
     3.023    48.672     0.200
     3.081    48.232     0.200
     3.099    48.043     0.200
     3.127    48.621     0.200
     3.309    52.082     0.200
     3.322    52.742     0.200
     3.646    57.252     0.200
     3.666    56.793     0.200
     3.720    57.633     0.200
     3.708    57.432     0.200
     3.724    59.383     0.200
     3.770    60.252     0.200
     3.827    59.152     0.200
     3.865    59.492     0.200
     3.896    59.072     0.200
     4.047    61.762     0.200
     4.093    61.531     0.200
     4.154    61.502     0.200
     4.154    62.281     0.200
     4.186    64.742     0.200
     4.213    64.973     0.200
     4.258    65.572     0.200
     4.461    67.201     0.200
     4.477    68.701     0.200
     4.702    71.342     0.200
     4.834    73.842     0.200
     4.907    73.982     0.200
     5.268    78.662     0.200
     5.500    81.852     0.200
     5.515    82.031     0.200
     5.538    83.053     0.200
     5.567    85.502     0.200
     5.653    84.242     0.200
     5.654    85.182     0.200
     6.609    96.713     0.200
     6.731    99.082     0.200
     7.050   104.152     0.200
     7.323   107.252     0.200
     7.528   111.105     0.200
     7.781   113.793     0.200
     8.765   126.713     0.200
     8.975   130.252     0.200
    10.178   146.482     0.200
    10.381   149.111     0.200
    10.663   156.432     0.200
    10.914   156.707     0.200
    14.137   200.133     0.200
    14.557   206.312     0.200
    15.085   212.912     0.200
    15.085   213.402     0.200
    15.168   214.441     0.200
    15.344   216.182     0.200
    15.351   216.271     0.200
    15.457   218.152     0.200
    15.477   218.232     0.200
    15.559   219.172     0.200
    15.737   222.213     0.200
     0.796    15.514     0.200
     0.808    15.062     0.200
     0.835    16.793     0.200
     0.844    15.604     0.200
     0.844    15.723     0.200
     0.863    15.873     0.200
     0.889    16.303     0.200
     0.889    16.344     0.200
     0.883    16.613     0.200
     0.904    16.773     0.200
     0.917    16.732     0.200
     0.908    16.793     0.200
     1.037    19.322     0.200
     1.152    20.264     0.200
     1.453    21.094     0.200
     1.227    21.523     0.200
     1.228    21.492     0.200
     1.257    22.062     0.200
     1.566    26.504     0.200
     1.796    29.543     0.200
     2.021    33.033     0.200
     2.060    34.062     0.200
     2.283    37.434     0.200
     2.294    37.783     0.200
     2.374    38.684     0.200
     2.389    38.443     0.200
     2.613    41.523     0.200
     2.645    40.223     0.200
     2.768    44.023     0.200
     2.795    43.383     0.200
     3.331    52.273     0.200
     3.655    57.732     0.200
     3.858    59.264     0.200
     4.140    61.344     0.200
     4.190    63.834     0.200
     5.260    78.664     0.200
     5.679    85.047     0.200
     5.679    84.934     0.200
     6.598    96.543     0.200
     7.236   106.742     0.200
     7.550   114.701     0.200
     7.777   114.873     0.200
     7.777   114.273     0.200
    10.548   151.664     0.200
    10.679   157.711     0.200
    10.898   156.273     0.200
    14.579   206.072     0.200
     0.847    15.537     0.200
     0.977    17.598     0.200
     1.204    20.967     0.200
     1.606    26.588     0.200
     1.718    28.117     0.200
     1.712    30.088     0.200
     1.841    30.816     0.200
     2.014    32.547     0.200
     2.044    32.678     0.200
     2.350    37.447     0.200
     2.391    38.316     0.200
     2.661    40.178     0.200
     2.768    43.297     0.200
     2.812    43.646     0.200
     2.890    44.707     0.200
     3.155    48.377     0.200
     3.390    52.697     0.200
     3.726    57.098     0.200
     3.900    60.416     0.200
     3.910    58.777     0.200
     4.174    62.268     0.200
     4.292    65.896     0.200
     4.937    74.428     0.200
     5.714    84.752     0.200
     7.289   107.197     0.200
     7.608   111.850     0.200
     7.835   114.549     0.200
    10.580   151.777     0.200
    10.748   156.170     0.200
    10.748   157.156     0.200
    10.923   156.217     0.200
    10.924   155.996     0.200
    10.924   159.406     0.200
    15.160   216.674     0.200
    15.160   214.957     0.200
     1.300    23.898     0.200
     1.319    22.738     0.200
     1.422    25.176     0.200
     1.482    25.855     0.200
     1.537    25.047     0.200
     1.759    30.078     0.200
     1.779    29.469     0.200
     1.824    30.438     0.200
     1.816    28.438     0.200
     1.835    30.496     0.200
     1.978    32.168     0.200
     2.030    32.598     0.200
     2.194    35.496     0.200
     2.202    34.656     0.200
     2.215    34.336     0.200
     2.284    35.945     0.200
     2.323    37.328     0.200
     2.362    38.535     0.200
     2.394    40.207     0.200
     2.516    41.438     0.200
     2.597    42.906     0.200
     2.718    43.488     0.200
     2.906    46.438     0.200
     3.113    49.367     0.200
     3.126    49.855     0.200
     3.270    50.766     0.200
     3.367    53.207     0.200
     3.394    53.367     0.200
     3.428    52.535     0.200
     3.423    53.035     0.200
     3.527    54.027     0.200
     3.570    55.746     0.200
     3.574    54.566     0.200
     3.925    59.938     0.200
     3.986    60.535     0.200
     3.988    60.219     0.200
     4.001    60.535     0.200
     4.087    62.125     0.200
     4.180    63.836     0.200
     4.292    65.547     0.200
     4.335    66.086     0.200
     4.395    66.559     0.200
     4.626    69.945     0.200
     4.664    70.668     0.200
     4.756    69.176     0.200
     4.766    69.566     0.200
     4.836    73.816     0.200
     4.922    74.527     0.200
     5.036    75.617     0.200
     5.190    77.688     0.200
     5.265    78.438     0.200
     5.305    79.516     0.200
     5.317    80.496     0.200
     5.631    83.828     0.200
     5.718    86.309     0.200
     5.893    87.766     0.200
     6.128    90.227     0.200
     6.120    89.336     0.200
     6.201    91.227     0.200
     6.579    97.797     0.200
     7.089   103.316     0.200
     7.206   105.988     0.200
     7.367   107.758     0.200
     7.393   109.168     0.200
     7.512   110.488     0.200
     7.632   111.336     0.200
     7.731   112.406     0.200
     7.753   112.828     0.200
     7.767   112.188     0.200
     7.787   113.285     0.200
     7.794   113.508     0.200
     7.897   115.027     0.200
     7.884   116.168     0.200
     7.926   115.926     0.200
     8.060   117.766     0.200
     8.314   120.746     0.200
     8.871   129.828     0.200
     9.372   134.617     0.200
     9.983   143.477     0.200
    10.026   144.078     0.200
    10.354   147.969     0.200
    10.787   153.477     0.200
     1.427    24.477     0.200
     1.512    24.848     0.200
     1.700    27.555     0.200
     1.722    28.316     0.200
     1.797    29.867     0.200
     1.808    30.348     0.200
     1.980    32.297     0.200
     2.243    37.066     0.200
     2.516    38.875     0.200
     2.537    42.797     0.200
     2.559    40.535     0.200
     2.574    43.105     0.200
     3.165    49.238     0.200
     3.570    56.195     0.200
     3.730    58.445     0.200
     3.811    59.406     0.200
     3.951    61.125     0.200
     4.071    60.656     0.200
     4.394    67.938     0.200
     4.481    68.426     0.200
     4.642    70.848     0.200
     4.719    71.297     0.200
     4.832    73.555     0.200
     4.928    74.457     0.200
     5.264    78.496     0.200
     5.458    80.465     0.200
     5.916    87.266     0.200
     6.557    95.875     0.200
     7.793   114.965     0.200
     7.817   114.059     0.200
     8.695   124.695     0.200
    10.798   154.465     0.200
    10.889   159.574     0.200
     1.262    24.387     0.200
     1.256    21.719     0.200
     1.427    24.039     0.200
     1.436    24.039     0.200
     1.446    27.617     0.200
     1.454    24.207     0.200
     1.510    24.590     0.200
     1.527    27.508     0.200
     1.528    26.508     0.200
     1.561    27.719     0.200
     1.543    25.668     0.200
     1.657    28.688     0.200
     1.703    30.090     0.200
     1.691    31.457     0.200
     1.700    28.008     0.200
     1.723    28.066     0.200
     1.792    29.637     0.200
     1.793    29.527     0.200
     1.806    29.816     0.200
     1.815    34.117     0.200
     1.919    29.066     0.200
     1.918    32.238     0.200
     1.976    32.117     0.200
     2.184    35.027     0.200
     2.244    34.316     0.200
     2.241    35.477     0.200
     2.377    41.719     0.200
     2.515    38.137     0.200
     2.519    40.309     0.200
     2.524    39.250     0.200
     2.534    39.656     0.200
     2.555    40.418     0.200
     2.573    41.406     0.200
     2.572    41.027     0.200
     2.573    40.777     0.200
     2.948    46.438     0.200
     2.982    47.039     0.200
     3.000    46.527     0.200
     3.009    47.438     0.200
     3.086    47.848     0.200
     3.125    48.406     0.200
     3.161    48.867     0.200
     3.341    51.930     0.200
     3.476    54.137     0.200
     3.567    54.949     0.200
     3.636    55.988     0.200
     3.726    56.699     0.200
     3.807    58.027     0.200
     3.869    58.918     0.200
     3.914    60.000     0.200
     3.947    59.699     0.200
     3.941    59.539     0.200
     3.990    60.340     0.200
     4.069    60.039     0.200
     4.063    60.277     0.200
     4.111    61.188     0.200
     4.274    63.520     0.200
     4.390    66.758     0.200
     4.471    67.387     0.200
     4.477    67.840     0.200
     4.542    67.457     0.200
     4.567    69.477     0.200
     4.638    70.078     0.200
     4.693    70.250     0.200
     4.697    71.816     0.200
     4.715    71.027     0.200
     4.828    73.379     0.200
     4.828    72.957     0.200
     4.849    72.988     0.200
     4.925    73.848     0.200
     5.058    76.277     0.200
     5.097    75.816     0.200
     5.159    76.457     0.200
     5.213    78.906     0.200
     5.261    77.867     0.200
     5.291    78.906     0.200
     5.298    78.359     0.200
     5.416    81.047     0.200
     5.424    81.949     0.200
     5.455    80.297     0.200
     5.481    82.270     0.200
     5.540    81.207     0.200
     5.633    84.148     0.200
     5.745    85.969     0.200
     5.770    86.059     0.200
     5.778    87.918     0.200
     5.794    88.957     0.200
     5.817    87.867     0.200
     5.873    89.227     0.200
     5.915    91.719     0.200
     5.915    89.918     0.200
     6.027    91.027     0.200
     6.034    90.418     0.200
     6.341    94.637     0.200
     6.431    96.629     0.200
     6.435    95.699     0.200
     6.554    95.438     0.200
     6.645    97.957     0.200
     6.649    98.039     0.200
     6.801    99.887     0.200
     6.937   103.617     0.200
     6.985   102.797     0.200
     7.068   104.227     0.200
     7.142   105.398     0.200
     7.243   105.578     0.200
     7.246   107.547     0.200
     7.301   107.398     0.200
     7.340   110.848     0.200
     7.376   108.750     0.200
     7.435   109.527     0.200
     7.535   111.207     0.200
     7.563   112.789     0.200
     7.585   112.457     0.200
     7.589   113.828     0.200
     7.594   112.898     0.200
     7.603   114.199     0.200
     7.620   113.137     0.200
     7.645   113.137     0.200
     7.665   112.816     0.200
     7.673   112.457     0.200
     7.690   114.219     0.200
     7.790   114.520     0.200
     7.814   114.469     0.200
     7.814   115.207     0.200
     7.924   117.539     0.200
     8.342   123.090     0.200
     8.619   126.688     0.200
     8.715   127.617     0.200
    10.797   154.504     0.200
    10.885   160.027     0.200
    11.767   167.918     0.200
     1.700    30.680     0.200
     1.811    33.031     0.200
     1.921    34.188     0.200
     3.002    48.797     0.200
     3.735    58.508     0.200
     3.817    59.828     0.200
     3.923    61.219     0.200
     3.957    62.336     0.200
     4.400    67.750     0.200
     4.648    71.562     0.200
     4.724    72.969     0.200
     4.838    74.086     0.200
     5.268    78.547     0.200
    10.801   154.102     0.200
    10.894   160.219     0.200
     1.515    25.688     0.200
     1.701    30.664     0.200
     1.721    29.984     0.200
     1.804    31.633     0.200
     1.922    33.711     0.200
     2.244    34.469     0.200
     2.436    40.641     0.200
     2.518    39.578     0.200
     2.517    39.391     0.200
     2.578    41.023     0.200
    10.800   156.289     0.200
    10.895   158.062     0.200
     1.433    24.547     0.200
     1.509    24.945     0.200
     1.552    27.273     0.200
     1.705    31.703     0.200
     1.695    30.031     0.200
     1.726    28.336     0.200
     1.813    32.203     0.200
     1.984    32.461     0.200
     2.137    33.883     0.200
     2.239    34.492     0.200
     2.376    37.133     0.200
     2.512    38.383     0.200
     3.921    60.547     0.200
     3.953    60.195     0.200
     5.786    87.305     0.200
     7.817   114.555     0.200
    10.795   157.805     0.200
     1.430    24.523     0.200
     1.508    24.891     0.200
     1.524    27.109     0.200
     1.703    30.898     0.200
     1.794    31.562     0.200
     2.512    38.367     0.200
     2.673    45.719     0.200
     2.940    47.352     0.200
    10.794   155.055     0.200
    10.886   156.633     0.200
     1.332    23.012     0.200
     1.343    23.762     0.200
     1.365    23.742     0.200
     1.429    23.801     0.200
     1.455    23.570     0.200
     1.653    28.152     0.200
     1.690    28.160     0.200
     1.834    30.480     0.200
     1.898    30.133     0.200
     2.004    32.211     0.200
     2.079    33.121     0.200
     2.108    33.562     0.200
     2.149    36.441     0.200
     2.251    35.922     0.200
     2.362    37.152     0.200
     2.475    42.230     0.200
     2.612    40.723     0.200
     2.732    42.391     0.200
     2.901    43.570     0.200
     4.458    65.492     0.200
     4.562    69.172     0.200
     5.703    86.461     0.200
     8.153   119.156     0.200
    10.190   149.617     0.200
    10.967   160.812     0.200
    11.186   160.535     0.200
    14.924   211.062     0.200
    15.241   215.812     0.200
    15.516   219.152     0.200
    15.988   224.102     0.200
    16.797   235.871     0.200
    15.698   220.742     0.200
     1.379    24.167     0.200
     1.407    24.378     0.200
     1.447    25.858     0.200
     1.491    26.878     0.200
     1.547    26.917     0.200
     1.578    27.598     0.200
     1.658    29.368     0.200
     1.730    29.438     0.200
     2.010    32.688     0.200
     1.994    33.938     0.200
     2.007    33.858     0.200
     2.233    36.698     0.200
     2.231    37.318     0.200
     2.308    36.378     0.200
     2.317    37.968     0.200
     2.408    39.568     0.200
     2.643    42.528     0.200
     2.726    44.618     0.200
     2.875    44.928     0.200
    15.276   218.448     0.200
    15.311   217.428     0.200
    15.402   218.917     0.200
    15.774   223.098     0.200
    15.955   225.128     0.200
    16.256   228.458     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     4.156    77.468     0.200
     4.266    81.158     0.200
     4.445    82.278     0.200
     4.873    91.488     0.200
     5.346    99.548     0.200
     5.550   102.508     0.200
     5.725   108.098     0.200
     6.761   128.988     0.200
     6.802   128.519     0.200
     6.967   131.368     0.200
     6.997   130.979     0.200
     7.042   132.218     0.200
     7.090   131.688     0.200
     7.587   144.458     0.200
     8.044   151.878     0.200
     9.911   184.558     0.200
     2.148    37.908     0.200
     3.074    58.275     0.200
     3.747    70.105     0.200
     3.972    73.514     0.200
     4.278    79.084     0.200
     4.308    79.445     0.200
     4.342    80.395     0.200
     4.511    83.654     0.200
     4.809    90.375     0.200
     5.167    96.035     0.200
     5.664   106.945     0.200
     6.745   126.355     0.200
     6.872   129.695     0.200
     6.917   132.684     0.200
     7.113   131.764     0.200
     7.339   139.994     0.200
     7.483   142.834     0.200
     7.510   139.875     0.200
     7.633   145.514     0.200
     7.959   147.975     0.200
     8.002   151.365     0.200
     8.129   149.865     0.200
     8.350   156.664     0.200
     3.232    59.490     0.200
     4.700    86.160     0.200
     5.040    92.440     0.200
     6.243   116.050     0.200
     7.534   142.230     0.200
     7.646   144.385     0.200
     7.646   144.160     0.200
     7.756   144.970     0.200
     7.892   146.780     0.200
     8.180   152.735     0.200
     2.769    51.703     0.200
     4.983    92.673     0.200
     5.195    96.033     0.200
     6.678   125.203     0.200
     2.217    40.031     0.200
     2.771    50.453     0.200
     4.811    89.383     0.200
     4.902    92.750     0.200
     4.981    92.359     0.200
     5.586   104.383     0.200
     6.131   113.156     0.200
     7.508   137.945     0.200
     5.052    93.172     0.200
     2.147    39.332     0.200
     2.257    40.828     0.200
     2.342    41.273     0.200
     7.555   140.355     0.200
     7.652   144.535     0.200
     7.935   151.195     0.200
     3.341    64.698     0.200
     4.237    80.648     0.200
     4.290    81.398     0.200
     4.668    88.379     0.200
     4.859    91.068     0.200
     5.528   103.204     0.200
     5.933   113.409     0.200
     5.955   113.759     0.200
     7.874   146.979     0.200
     3.998    74.618     0.200
     4.562    86.099     0.200
     4.598    84.959     0.200
     4.588    84.829     0.200
     4.744    87.589     0.200
     4.959    93.929     0.200
     5.912   108.789     0.200
     6.041   111.299     0.200
     6.055   113.929     0.200
     6.496   120.019     0.200
     7.025   131.778     0.200
     7.027   131.329     0.200
     7.122   133.749     0.200
     7.268   134.368     0.200
     2.087    37.399     0.200
     2.088    37.739     0.200
     2.324    40.909     0.200
     3.184    59.109     0.200
     3.640    67.770     0.200
     4.837    92.779     0.200
     5.117    93.920     0.200
     5.165   100.140     0.200
     5.345   100.130     0.200
     5.380   100.140     0.200
     5.894   110.500     0.200
     6.004   114.180     0.200
     6.039   110.290     0.200
     6.449   123.060     0.200
     8.159   152.439     0.200
     3.190    61.492     0.200
     4.750    90.551     0.200
     4.837    92.742     0.200
     5.169    98.219     0.200
     6.010   115.449     0.200
     7.793   144.566     0.200
     2.829    51.904     0.200
     3.271    61.063     0.200
     3.362    61.054     0.200
     5.252    97.799     0.200
     5.644   103.733     0.200
     5.656   106.824     0.200
     6.133   113.634     0.200
     6.156   113.854     0.200
     7.234   134.063     0.200
     7.378   138.172     0.200
     2.085    37.250     0.200
     8.113   148.234     0.200
     2.723    50.723     0.200
     3.049    55.652     0.200
     3.666    67.352     0.200
     4.349    83.523     0.200
     4.445    82.094     0.200
     4.407    81.484     0.200
     5.035    94.434     0.200
     5.651   103.523     0.200
     7.227   133.824     0.200
     5.241   100.270     0.200
     7.227   137.109     0.200
     2.093    37.555     0.200
     2.332    41.820     0.200
     2.917    53.297     0.200
     5.361    99.578     0.200
     5.615   105.430     0.200
     5.646   105.117     0.200
     6.042   111.938     0.200
     7.703   144.883     0.200
     2.350    42.492     0.200
     4.432    81.633     0.200
     2.276    41.918     0.200
     2.257    41.125     0.200
     7.300   140.297     0.200
     6.946   133.021     0.200
     7.326   140.351     0.200
     7.340   140.571     0.200
     7.475   143.991     0.200
     2.004    36.129     0.200
     2.036    37.203     0.200
     2.076    38.051     0.200
     2.150    39.617     0.200
     2.485    46.875     0.200
     2.499    45.469     0.200
     3.950    75.016     0.200
     3.977    75.922     0.200
     4.312    81.523     0.200
     5.279    98.758     0.200
     5.827   109.648     0.200
     2.325    41.789     0.200
     2.398    42.586     0.200
     2.467    44.336     0.200
     3.069    56.945     0.200
     5.833   110.188     0.200
     2.382    42.062     0.200
     2.417    42.906     0.200
     2.921    54.492     0.200
     3.006    56.992     0.200
     3.066    55.328     0.200
     3.422    64.578     0.200
     3.533    67.031     0.200
     3.561    67.555     0.200
     3.590    68.172     0.200
     3.731    70.961     0.200
     3.948    74.836     0.200
     3.981    76.000     0.200
     3.987    76.188     0.200
     4.039    77.922     0.200
     4.222    80.336     0.200
     4.265    80.148     0.200
     4.570    87.578     0.200
     5.267    98.078     0.200
     5.306   100.352     0.200
     5.310   101.320     0.200
     7.802   144.953     0.200
     7.806   144.164     0.200
     5.030    96.516     0.200
     2.382    42.055     0.200
     5.854   110.641     0.200
     7.857   146.641     0.200
     3.533    63.320     0.200
     7.060   136.305     0.200
     7.512   144.062     0.200
     7.805   145.305     0.200
     2.306    41.664     0.200
     3.337    60.438     0.200
     5.813   109.438     0.200
     5.813   109.438     0.200
     7.340   135.789     0.200
     7.787   144.938     0.200
     7.787   144.117     0.200
     2.397    43.109     0.200
     2.463    44.023     0.200
     3.679    69.797     0.200
     4.324    82.227     0.200
     5.827   112.938     0.200
     5.868   113.133     0.200
     6.682   129.477     0.200
     6.905   135.844     0.200
     7.105   137.148     0.200
     7.376   141.484     0.200
     7.718   148.125     0.200
     7.849   147.109     0.200
     8.108   154.156     0.200
     8.307   157.336     0.200
     2.390    43.023     0.200
     2.470    44.453     0.200
     2.484    45.891     0.200
     2.556    45.703     0.200
     2.617    47.000     0.200
     5.824   108.688     0.200
     7.789   145.234     0.200
     3.645    68.531     0.200
     4.080    75.842     0.200
     6.109   113.980     0.200
     6.357   117.441     0.200
     7.116   133.861     0.200
     7.472   141.092     0.200
     7.500   143.682     0.200
     2.362    41.840     0.200
     2.380    42.163     0.200
     2.925    54.910     0.200
     3.051    58.113     0.200
     7.828   144.988     0.200
     2.070    37.398     0.200
     4.144    77.367     0.200
     4.442    83.688     0.200
     4.461    84.086     0.200
     4.493    84.094     0.200
     4.896    90.570     0.200
     5.147    96.641     0.200
     5.171    96.727     0.200
     5.318    99.664     0.200
     5.376   103.039     0.200
     5.553   106.484     0.200
     5.941   113.859     0.200
     7.210   135.695     0.200
     7.220   137.961     0.200
     7.235   137.406     0.200
     7.256   134.547     0.200
     2.057    37.727     0.200
     2.058    37.484     0.200
     2.142    38.617     0.200
     2.372    42.570     0.200
     3.015    53.914     0.200
     3.219    59.273     0.200
     3.498    64.961     0.200
     5.484   103.352     0.200
     5.671   104.203     0.200
     5.858   111.406     0.200
     6.127   118.227     0.200
     7.617   142.602     0.200
     7.696   144.688     0.200
     7.775   145.227     0.200
     7.937   151.812     0.200
     7.941   151.578     0.200
     7.946   149.984     0.200
     7.950   150.195     0.200
     7.958   149.844     0.200
     7.983   151.547     0.200
     7.989   152.828     0.200
     8.001   152.398     0.200
     8.016   151.547     0.200
     8.028   152.016     0.200
     8.056   153.602     0.200
     8.088   151.477     0.200
     8.109   153.125     0.200
     2.184    39.219     0.200
     2.546    47.883     0.200
     2.979    55.906     0.200
     3.566    66.836     0.200
     5.546   102.398     0.200
     2.664    48.973     0.200
     2.733    51.404     0.200
     3.405    65.444     0.200
     2.241    41.230     0.200
     2.457    45.797     0.200
     2.647    50.836     0.200
     2.328    41.977     0.200
     2.460    44.227     0.200
     2.548    45.891     0.200
     2.704    51.195     0.200
     2.800    53.414     0.200
     3.373    64.359     0.200
     3.416    65.047     0.200
     3.770    71.695     0.200
     3.834    73.039     0.200
     5.098    96.547     0.200
     5.241    97.742     0.200
     7.303   137.883     0.200
     2.023    36.230     0.200
     2.114    38.887     0.200
     2.311    40.930     0.200
     2.430    43.143     0.200
     2.686    47.721     0.200
     2.755    51.848     0.200
     3.291    62.775     0.200
     3.425    65.586     0.200
     3.450    65.859     0.200
     3.632    69.064     0.200
     3.784    71.523     0.200
     3.822    72.359     0.200
     3.875    73.508     0.200
     4.164    78.717     0.200
     4.205    79.152     0.200
     4.400    83.229     0.200
     2.331    41.789     0.200
     2.649    50.301     0.200
     4.849    89.809     0.200
     6.829   127.034     0.200
     7.974   146.404     0.200
     2.052    36.949     0.200
     2.333    41.949     0.200
     2.333    42.297     0.200
     2.604    48.098     0.200
     2.656    48.996     0.200
     4.434    82.863     0.200
     4.860    90.152     0.200
     6.842   128.270     0.200
     2.020    36.599     0.200
     2.325    41.311     0.200
     2.483    44.360     0.200
     2.075    37.125     0.200
     2.211    39.430     0.200
     2.271    40.102     0.200
     5.083    93.805     0.200
     4.596    84.938     0.200
     6.894   127.711     0.200
     8.679   158.434     0.200
     5.197    95.979     0.200
     8.413   153.969     0.200
     2.519    44.988     0.200
     2.674    48.484     0.200
     2.815    51.086     0.200
     3.019    55.328     0.200
     2.242    39.816     0.200
     2.262    40.078     0.200
     2.499    44.547     0.200
     3.604    68.195     0.200
     3.961    74.867     0.200
     5.293    99.207     0.200
     2.176    40.176     0.200
     2.805    50.105     0.200
     2.246    40.336     0.200
     2.364    42.147     0.200
     2.382    41.872     0.200
     2.630    49.512     0.200
     2.704    51.252     0.200
     2.808    53.342     0.200
     2.260    40.194     0.200
     2.373    42.261     0.200
     2.397    42.556     0.200
     2.816    53.381     0.200
     3.285    62.527     0.200
     3.510    66.213     0.200
     2.243    40.051     0.200
     2.243    40.019     0.200
     3.173    59.779     0.200
     3.370    62.958     0.200
     3.630    68.469     0.200
     2.281    40.914     0.200
     2.763    51.828     0.200
     3.433    65.109     0.200
     3.434    65.254     0.200
     3.790    71.977     0.200
     4.068    77.152     0.200
     4.140    78.051     0.200
     2.433    43.211     0.200
     2.533    47.211     0.200
     2.968    54.992     0.200
     3.601    67.648     0.200
     3.996    75.281     0.200
     4.025    76.406     0.200
     4.353    82.500     0.200
     5.353   102.391     0.200
     2.401    42.984     0.200
     2.430    43.430     0.200
     2.531    48.391     0.200
     2.638    47.719     0.200
     2.770    49.656     0.200
     3.454    67.258     0.200
     4.014    77.578     0.200
     4.023    77.727     0.200
     5.351   102.250     0.200
    10.851   199.344     0.200
     2.153    38.355     0.200
     2.474    44.422     0.200
     2.776    52.922     0.200
     3.273    62.203     0.200
     3.405    64.977     0.200
     3.414    64.867     0.200
     3.807    72.242     0.200
     2.978    56.141     0.200
     5.929   110.957     0.200
     2.186    39.086     0.200
     2.104    38.188     0.200
     2.562    46.645     0.200
     3.746    69.625     0.200
     2.356    41.371     0.200
     2.083    37.276     0.200
     2.499    46.086     0.200
     2.796    51.324     0.200
     2.848    52.934     0.200
     3.170    59.704     0.200
     3.441    64.724     0.200
     3.485    65.469     0.200
     2.102    37.969     0.200
     2.575    49.555     0.200
     2.710    49.691     0.200
     2.561    46.277     0.200
     2.728    49.336     0.200
     2.739    50.438     0.200
     7.812   144.512     0.200
     7.479   138.434     0.200
     2.537    47.020     0.200
     2.889    55.031     0.200
     2.227    40.711     0.200
     2.680    49.730     0.200
     2.857    52.809     0.200
     3.321    59.949     0.200
     3.610    67.570     0.200
     4.227    80.898     0.200
     4.244    79.449     0.200
     4.320    79.988     0.200
     7.848   143.500     0.200
     2.628    47.453     0.200
     7.462   139.461     0.200
     5.801   108.328     0.200
     7.688   146.336     0.200
     7.829   146.430     0.200
    10.810   202.617     0.200
     7.681   142.062     0.200
     7.825   146.555     0.200
    10.802   198.844     0.200
     7.679   145.107     0.200
     5.781   107.380     0.200
     7.671   143.855     0.200
     7.832   146.999     0.200
    10.798   203.530     0.200
     2.361    41.527     0.200
     5.802   108.007     0.200
     7.689   145.332     0.200
     7.827   147.500     0.200
    10.810   200.407     0.200
     5.781   107.468     0.200
     7.669   144.751     0.200
     7.827   144.245     0.200
     2.359    42.508     0.200
     5.787   108.242     0.200
     7.668   142.523     0.200
     7.813   146.141     0.200
     2.428    43.301     0.200
     7.672   143.047     0.200
     7.815   144.164     0.200
     5.821   107.414     0.200
     7.709   145.203     0.200
     7.833   148.078     0.200
     3.292    62.070     0.200
     3.489    65.523     0.200
     3.556    67.062     0.200
     3.741    70.547     0.200
     3.777    71.992     0.200
     5.662   105.336     0.200
     5.766   105.648     0.200
     6.142   113.617     0.200
     6.179   113.859     0.200
    10.667   201.812     0.200
     2.749    52.695     0.200
     2.768    51.422     0.200
     3.096    59.773     0.200
     5.675   105.781     0.200
     7.558   141.453     0.200
     7.806   145.570     0.200
     7.439   139.873     0.200
     8.828   163.168     0.200
     2.761    50.281     0.200
     2.751    49.441     0.200
     2.954    54.129     0.200
     2.966    60.711     0.200
     3.304    62.121     0.200
     3.501    66.328     0.200
     3.520    67.699     0.200
     3.523    66.629     0.200
     3.540    67.121     0.200
     3.546    66.629     0.200
     3.551    67.090     0.200
     3.569    67.461     0.200
     3.692    69.699     0.200
     3.754    70.418     0.200
     3.765    71.449     0.200
     4.235    80.559     0.200
     5.670   104.453     0.200
     2.286    41.445     0.200
     2.305    40.641     0.200
     2.751    50.375     0.200
     2.763    50.617     0.200
     2.858    51.859     0.200
     2.960    54.016     0.200
     5.671   105.250     0.200
     5.700   105.613     0.200
     7.596   144.664     0.200
     7.840   146.734     0.200
     7.586   141.879     0.200
     5.695   106.805     0.200
     7.583   142.320     0.200
     7.819   146.492     0.200
     7.585   143.527     0.200
     7.823   144.621     0.200
     5.701   105.869     0.200
     5.677   105.945     0.200
     7.571   142.078     0.200
     7.832   146.094     0.200
     2.093    37.514     0.200
     5.634   104.389     0.200
     7.529   140.688     0.200
     7.831   145.775     0.200
     5.632   104.797     0.200
     2.250    39.885     0.200
     2.343    41.576     0.200
     2.333    41.375     0.200
     5.633   105.225     0.200
     7.532   142.051     0.200
     7.839   146.045     0.200
     5.634   104.061     0.200
     7.533   142.188     0.200
     7.840   147.355     0.200
     5.670   104.500     0.200
     7.674   143.375     0.200
     8.108   153.570     0.200
     2.803    51.719     0.200
     2.877    53.801     0.200
     5.703   106.016     0.200
     2.905    51.667     0.200
     7.311   135.376     0.200
    10.734   199.215     0.200
     5.200    96.512     0.200
     7.510   140.160     0.200
     5.243    96.738     0.200
     7.383   138.539     0.200
     7.534   140.910     0.200
     7.782   143.205     0.200
    10.668   200.236     0.200
     5.654   104.082     0.200
     7.528   141.182     0.200
     7.781   144.150     0.200
     2.768    50.414     0.200
     5.679   105.957     0.200
     5.714   105.271     0.200
     7.608   141.635     0.200
     7.835   144.682     0.200
     5.916   109.664     0.200
     7.793   147.742     0.200
     7.817   144.711     0.200
     7.797   146.000     0.200
     7.822   145.195     0.200
    10.894   203.023     0.200
     7.798   144.914     0.200
     7.822   143.969     0.200
     2.577    47.109     0.200
     7.817   142.898     0.200
     7.813   143.625     0.200
     5.703   104.512     0.200
     7.724   144.836     0.200
     8.153   153.656     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.285     6.179     0.200
     0.343     6.648     0.200
     0.343     6.971     0.200
     0.517     9.791     0.200
     0.806    14.171     0.200
     0.878    16.088     0.200
     0.883    16.408     0.200
     0.890    16.894     0.200
     1.059    18.294     0.200
     1.288    21.733     0.200
     5.346    90.229     0.200
     5.725    94.918     0.200
     6.967   114.578     0.200
     0.218     4.465     0.200
     0.331     6.445     0.200
     0.663    12.785     0.200
     0.711    13.607     0.200
     0.866    16.340     0.200
     0.928    17.414     0.200
     0.982    17.484     0.200
     0.964    18.252     0.200
     1.020    19.012     0.200
     1.412    23.725     0.200
     1.406    23.889     0.200
     1.581    29.801     0.200
     1.745    30.969     0.200
     1.805    33.844     0.200
     1.807    32.377     0.200
     1.904    35.355     0.200
     1.900    33.471     0.200
     1.980    36.506     0.200
     2.387    41.992     0.200
     2.425    42.346     0.200
     0.239     5.030     0.200
     0.277     5.519     0.200
     0.386     7.980     0.200
     0.458     8.910     0.200
     0.374     7.785     0.200
     0.454     8.863     0.200
     0.479     9.220     0.200
     0.509     9.900     0.200
     0.543    10.380     0.200
     0.598    11.621     0.200
     0.598    11.450     0.200
     0.692    13.210     0.200
     0.743    14.049     0.200
     0.670    12.720     0.200
     0.670    12.601     0.200
     0.694    13.240     0.200
     0.904    16.905     0.200
     0.945    17.610     0.200
     1.039    18.070     0.200
     1.065    19.499     0.200
     1.293    22.355     0.200
     1.374    22.589     0.200
     1.435    24.038     0.200
     1.999    35.820     0.200
     4.947    83.851     0.200
     0.167     3.649     0.200
     0.551    10.573     0.200
     0.635    12.188     0.200
     0.674    12.735     0.200
     0.743    13.757     0.200
     0.783    14.473     0.200
     0.775    14.325     0.200
     0.865    15.959     0.200
     0.902    17.124     0.200
     1.422    23.716     0.200
     1.976    35.463     0.200
     0.167     3.805     0.200
     0.167     3.445     0.200
     0.551    10.477     0.200
     0.673    12.859     0.200
     0.740    13.922     0.200
     0.639    12.250     0.200
     0.783    14.383     0.200
     0.778    14.570     0.200
     0.904    17.180     0.200
     1.418    23.742     0.200
     1.418    23.477     0.200
     1.497    27.742     0.200
     0.292     6.156     0.200
     0.356     7.004     0.200
     0.645    11.797     0.200
     0.714    13.613     0.200
     0.837    15.199     0.200
     0.759    14.227     0.200
     0.876    16.219     0.200
     0.987    17.926     0.200
     1.052    18.492     0.200
     1.210    21.246     0.200
     1.188    20.559     0.200
     1.225    22.168     0.200
     1.299    22.340     0.200
     1.285    22.648     0.200
     0.289     6.344     0.200
     0.362     7.078     0.200
     0.639    12.070     0.200
     0.712    13.648     0.200
     0.763    14.500     0.200
     0.833    14.723     0.200
     0.883    16.348     0.200
     0.987    17.844     0.200
     1.054    18.578     0.200
     1.194    20.656     0.200
     1.497    25.922     0.200
     0.120     3.059     0.200
     0.382     7.398     0.200
     0.393     8.086     0.200
     0.411     7.992     0.200
     0.475     9.098     0.200
     0.532    10.105     0.200
     0.675    12.129     0.200
     0.658    12.527     0.200
     0.711    13.504     0.200
     0.727    13.426     0.200
     0.738    13.137     0.200
     0.704    13.707     0.200
     0.772    14.016     0.200
     0.821    14.637     0.200
     0.821    14.168     0.200
     0.980    16.988     0.200
     0.971    17.797     0.200
     1.008    18.016     0.200
     1.108    19.371     0.200
     1.812    30.316     0.200
     4.355    72.727     0.200
     0.353     7.297     0.200
     0.446     9.019     0.200
     0.432     8.615     0.200
     0.420     8.009     0.200
     0.450     9.019     0.200
     0.504    10.019     0.200
     0.645    12.028     0.200
     0.664    12.028     0.200
     0.719    13.028     0.200
     0.703    13.376     0.200
     0.698    13.674     0.200
     0.677    12.929     0.200
     0.747    13.969     0.200
     0.806    14.509     0.200
     0.806    14.039     0.200
     0.734    14.291     0.200
     0.951    17.249     0.200
     0.993    18.118     0.200
     0.994    17.969     0.200
     1.115    19.488     0.200
     1.374    23.469     0.200
     1.787    30.509     0.200
     1.853    32.778     0.200
     5.528    90.653     0.200
     0.286     5.797     0.200
     0.349     7.090     0.200
     0.350     6.809     0.200
     0.369     6.660     0.200
     0.371     7.668     0.200
     0.486     9.547     0.200
     0.489     9.617     0.200
     0.531    10.227     0.200
     0.594    11.070     0.200
     0.594    11.340     0.200
     0.613    11.691     0.200
     0.648    12.453     0.200
     0.661    12.621     0.200
     0.707    13.328     0.200
     0.726    13.875     0.200
     0.841    15.711     0.200
     0.921    17.105     0.200
     0.946    17.570     0.200
     1.093    20.480     0.200
     1.366    22.918     0.200
     1.366    23.172     0.200
     1.586    28.547     0.200
     1.873    33.438     0.200
     0.291     5.650     0.200
     0.433     8.401     0.200
     0.666    13.022     0.200
     0.769    13.736     0.200
     0.114     3.140     0.200
     0.114     2.938     0.200
     0.348     6.760     0.200
     0.475     8.904     0.200
     0.408     8.140     0.200
     0.419     8.239     0.200
     0.507     9.560     0.200
     0.487     9.590     0.200
     0.503     9.899     0.200
     0.621    11.500     0.200
     0.621    11.703     0.200
     0.633    11.908     0.200
     0.726    13.710     0.200
     0.923    17.298     0.200
     1.006    17.872     0.200
     1.048    19.043     0.200
     1.062    18.649     0.200
     1.121    20.319     0.200
     1.291    21.824     0.200
     1.286    23.300     0.200
     1.347    24.690     0.200
     1.881    33.890     0.200
     1.949    36.137     0.200
     0.110     3.109     0.200
     0.111     2.770     0.200
     0.343     6.719     0.200
     0.406     8.121     0.200
     0.421     8.250     0.200
     0.472     8.793     0.200
     0.500     9.512     0.200
     0.490     9.602     0.200
     0.549    10.859     0.200
     0.506     9.922     0.200
     0.544    10.531     0.200
     0.627    11.617     0.200
     0.627    11.512     0.200
     0.636    11.684     0.200
     0.721    13.699     0.200
     0.929    17.332     0.200
     1.008    17.910     0.200
     1.056    19.082     0.200
     1.053    19.070     0.200
     1.115    20.270     0.200
     1.288    21.781     0.200
     1.875    33.891     0.200
     1.955    36.020     0.200
     0.219     4.421     0.200
     0.219     4.254     0.200
     0.501     9.328     0.200
     0.685    12.628     0.200
     0.682    12.992     0.200
     0.698    13.155     0.200
     0.744    13.504     0.200
     0.766    13.924     0.200
     0.780    14.590     0.200
     0.846    15.541     0.200
     1.376    22.907     0.200
     2.829    49.084     0.200
     0.167     3.945     0.200
     0.162     4.062     0.200
     0.183     4.406     0.200
     0.192     4.023     0.200
     0.192     3.766     0.200
     0.247     5.492     0.200
     0.314     6.977     0.200
     0.485     9.625     0.200
     0.482     9.305     0.200
     0.493     9.766     0.200
     0.532     9.984     0.200
     0.511    10.062     0.200
     0.517    10.047     0.200
     0.554    10.820     0.200
     0.560    10.500     0.200
     0.564    10.984     0.200
     0.549    10.703     0.200
     0.606    11.680     0.200
     0.580    11.227     0.200
     0.611    11.602     0.200
     0.693    13.047     0.200
     0.737    13.875     0.200
     0.737    13.836     0.200
     0.718    12.953     0.200
     0.711    13.320     0.200
     0.755    13.805     0.200
     0.755    14.016     0.200
     0.753    13.664     0.200
     0.753    14.133     0.200
     0.771    14.477     0.200
     0.780    14.266     0.200
     0.777    14.445     0.200
     0.831    15.469     0.200
     0.859    16.445     0.200
     0.847    15.812     0.200
     0.890    16.383     0.200
     0.901    16.289     0.200
     0.922    16.930     0.200
     0.909    17.227     0.200
     0.909    16.844     0.200
     0.928    17.070     0.200
     0.973    18.086     0.200
     0.991    18.141     0.200
     1.145    20.664     0.200
     1.142    20.852     0.200
     1.343    22.859     0.200
     1.683    30.617     0.200
     0.152     4.047     0.200
     0.272     5.227     0.200
     0.272     5.547     0.200
     0.276     5.758     0.200
     0.339     6.711     0.200
     0.383     7.641     0.200
     0.394     8.266     0.200
     0.386     8.109     0.200
     0.449     8.711     0.200
     0.460     9.438     0.200
     0.507     9.734     0.200
     0.517     9.898     0.200
     0.563    10.688     0.200
     0.593    11.258     0.200
     0.593    11.070     0.200
     0.669    12.773     0.200
     0.745    13.820     0.200
     0.836    15.656     0.200
     0.903    16.508     0.200
     0.944    16.445     0.200
     0.971    17.727     0.200
     0.987    17.438     0.200
     1.095    19.352     0.200
     1.363    23.086     0.200
     1.686    31.188     0.200
     3.228    55.805     0.200
     0.122     3.262     0.200
     0.350     7.172     0.200
     0.372     7.676     0.200
     0.372     7.512     0.200
     0.376     7.414     0.200
     0.376     7.133     0.200
     0.432     8.844     0.200
     0.448     8.852     0.200
     0.504     9.773     0.200
     0.457     9.004     0.200
     0.487     9.582     0.200
     0.509     9.922     0.200
     0.480     9.719     0.200
     0.542    10.672     0.200
     0.554    11.051     0.200
     0.578    11.293     0.200
     0.728    13.941     0.200
     0.621    12.051     0.200
     0.730    14.004     0.200
     0.719    13.574     0.200
     0.722    13.992     0.200
     0.735    13.992     0.200
     0.772    14.812     0.200
     0.892    16.121     0.200
     0.844    16.121     0.200
     1.013    18.633     0.200
     0.928    17.621     0.200
     1.098    19.824     0.200
     1.070    19.711     0.200
     1.037    19.441     0.200
     1.059    19.801     0.200
     1.172    20.633     0.200
     1.172    21.422     0.200
     1.169    21.281     0.200
     1.095    20.691     0.200
     1.144    20.941     0.200
     1.250    22.551     0.200
     1.364    24.551     0.200
     1.404    25.492     0.200
     1.575    27.672     0.200
     1.549    27.512     0.200
     1.617    28.324     0.200
     1.562    27.754     0.200
     1.589    28.973     0.200
     1.937    35.066     0.200
     0.105     3.273     0.200
     0.219     4.750     0.200
     0.234     5.492     0.200
     0.255     5.703     0.200
     0.292     5.906     0.200
     0.314     6.641     0.200
     0.372     7.570     0.200
     0.413     7.914     0.200
     0.412     8.023     0.200
     0.494     9.391     0.200
     0.574    10.727     0.200
     0.583    11.320     0.200
     0.614    11.336     0.200
     0.620    11.602     0.200
     0.620    11.273     0.200
     0.620    12.195     0.200
     0.659    12.000     0.200
     0.704    13.133     0.200
     0.735    14.055     0.200
     0.998    17.680     0.200
     1.123    19.477     0.200
     1.154    19.852     0.200
     1.624    28.875     0.200
     2.460    43.102     0.200
     5.820    97.602     0.200
     0.319     6.305     0.200
     0.330     6.156     0.200
     0.330     6.492     0.200
     0.554    10.402     0.200
     0.755    13.629     0.200
     0.850    15.059     0.200
     1.154    19.773     0.200
     2.739    47.980     0.200
     0.148     3.648     0.200
     0.273     5.289     0.200
     0.397     7.922     0.200
     0.437     8.453     0.200
     0.488     9.406     0.200
     0.446     8.977     0.200
     0.550    10.961     0.200
     0.462     9.133     0.200
     0.541    10.508     0.200
     0.613    11.266     0.200
     0.595    11.453     0.200
     0.676    12.875     0.200
     0.754    14.438     0.200
     0.966    17.508     0.200
     0.945    17.688     0.200
     1.250    21.453     0.200
     1.349    24.922     0.200
     1.662    29.820     0.200
     1.869    33.453     0.200
     1.894    33.922     0.200
     1.946    36.031     0.200
     1.945    34.289     0.200
     3.194    53.523     0.200
     0.118     3.156     0.200
     0.154     3.977     0.200
     0.173     4.484     0.200
     0.213     5.125     0.200
     0.212     4.742     0.200
     0.233     5.250     0.200
     0.207     5.133     0.200
     0.364     7.234     0.200
     0.473     9.164     0.200
     0.512     9.742     0.200
     0.551    10.664     0.200
     0.554    10.461     0.200
     0.603    12.203     0.200
     0.603    11.672     0.200
     0.578    11.594     0.200
     0.617    11.242     0.200
     0.737    13.680     0.200
     0.723    13.727     0.200
     0.776    14.406     0.200
     0.789    14.625     0.200
     0.809    15.203     0.200
     0.980    17.484     0.200
     1.017    17.727     0.200
     1.020    17.625     0.200
     1.046    18.320     0.200
     1.085    19.070     0.200
     1.191    20.516     0.200
     1.266    21.719     0.200
     0.196     3.996     0.200
     0.297     6.176     0.200
     0.265     5.156     0.200
     0.349     6.637     0.200
     0.350     6.676     0.200
     0.457     8.965     0.200
     0.359     7.867     0.200
     0.475     9.465     0.200
     0.489     9.496     0.200
     0.517     9.906     0.200
     0.619    12.152     0.200
     0.564    10.758     0.200
     0.626    11.984     0.200
     0.688    13.957     0.200
     0.720    13.566     0.200
     0.788    15.715     0.200
     0.739    13.984     0.200
     0.773    14.715     0.200
     0.753    14.230     0.200
     0.753    15.527     0.200
     0.956    17.195     0.200
     0.956    17.715     0.200
     0.902    16.750     0.200
     0.957    17.797     0.200
     0.979    17.805     0.200
     0.986    18.531     0.200
     0.983    18.469     0.200
     1.014    18.793     0.200
     1.022    19.285     0.200
     1.077    20.008     0.200
     1.203    21.336     0.200
     1.249    22.418     0.200
     1.249    22.602     0.200
     1.249    22.555     0.200
     1.232    23.297     0.200
     1.371    23.887     0.200
     1.364    23.727     0.200
     1.495    27.848     0.200
     1.565    29.402     0.200
     1.588    29.555     0.200
     1.850    34.418     0.200
     0.208     4.288     0.200
     0.292     6.511     0.200
     0.337     6.481     0.200
     0.338     7.027     0.200
     0.338     6.451     0.200
     0.359     7.811     0.200
     0.456     9.291     0.200
     0.466     9.811     0.200
     0.475     9.721     0.200
     0.478     9.861     0.200
     0.505    10.241     0.200
     0.554    11.081     0.200
     0.611    12.561     0.200
     0.618    12.475     0.200
     0.619    12.321     0.200
     0.686    13.541     0.200
     0.714    13.911     0.200
     0.732    14.211     0.200
     0.757    14.427     0.200
     0.757    16.081     0.200
     0.761    15.081     0.200
     0.822    16.481     0.200
     0.895    17.061     0.200
     0.943    18.061     0.200
     0.944    17.547     0.200
     0.944    17.981     0.200
     0.966    18.301     0.200
     0.973    18.915     0.200
     0.995    18.705     0.200
     1.020    19.621     0.200
     1.028    19.014     0.200
     1.065    20.301     0.200
     1.108    20.891     0.200
     1.190    21.615     0.200
     1.236    22.811     0.200
     1.236    22.952     0.200
     1.236    22.831     0.200
     1.241    23.489     0.200
     1.298    24.981     0.200
     1.305    24.437     0.200
     1.324    25.011     0.200
     1.366    24.101     0.200
     1.366    24.211     0.200
     1.367    23.969     0.200
     1.550    29.270     0.200
     1.576    29.660     0.200
     1.602    30.261     0.200
     1.739    32.447     0.200
     1.850    34.704     0.200
     1.935    35.431     0.200
     0.293     5.715     0.200
     0.294     5.461     0.200
     0.294     5.754     0.200
     0.376     8.023     0.200
     0.426     8.379     0.200
     0.440     8.664     0.200
     0.500    10.094     0.200
     0.535    11.191     0.200
     0.543    10.512     0.200
     0.546    10.574     0.200
     0.570    11.203     0.200
     0.560    10.852     0.200
     0.636    12.223     0.200
     0.636    12.414     0.200
     0.673    12.773     0.200
     0.673    12.922     0.200
     0.714    13.477     0.200
     0.714    13.773     0.200
     0.721    13.551     0.200
     0.721    13.602     0.200
     0.711    13.652     0.200
     0.732    13.824     0.200
     0.768    14.125     0.200
     0.765    14.645     0.200
     0.763    14.188     0.200
     0.910    16.723     0.200
     1.048    18.633     0.200
     1.296    22.934     0.200
     1.358    22.992     0.200
     1.358    22.832     0.200
     1.348    25.691     0.200
     1.394    25.625     0.200
     1.508    27.273     0.200
     1.508    28.512     0.200
     1.530    29.312     0.200
     1.594    28.191     0.200
     1.590    29.664     0.200
     1.619    28.449     0.200
     1.626    30.199     0.200
     1.664    29.684     0.200
     1.640    29.504     0.200
     1.646    29.492     0.200
     1.680    30.242     0.200
     1.703    30.043     0.200
     1.705    30.762     0.200
     1.821    31.172     0.200
     1.851    33.570     0.200
     1.851    34.254     0.200
     1.879    34.113     0.200
     1.886    34.875     0.200
     1.966    35.434     0.200
     2.173    37.344     0.200
     2.891    48.281     0.200
     0.202     4.637     0.200
     0.217     5.199     0.200
     0.249     5.508     0.200
     0.477     9.156     0.200
     0.584    11.262     0.200
     0.597    11.637     0.200
     0.634    11.812     0.200
     0.633    11.527     0.200
     0.652    10.559     0.200
     0.721    13.695     0.200
     0.938    16.840     0.200
     1.140    19.461     0.200
     1.748    31.926     0.200
     0.213     4.688     0.200
     0.213     4.555     0.200
     0.242     5.453     0.200
     0.294     6.562     0.200
     0.301     6.453     0.200
     0.367     7.438     0.200
     0.400     7.734     0.200
     0.406     7.812     0.200
     0.483     9.258     0.200
     0.592    11.305     0.200
     0.605    11.945     0.200
     0.634    12.258     0.200
     0.621    11.258     0.200
     0.646    10.969     0.200
     0.733    13.648     0.200
     0.942    17.422     0.200
     0.946    17.383     0.200
     0.949    17.367     0.200
     0.949    16.812     0.200
     0.986    17.516     0.200
     0.994    17.805     0.200
     0.994    18.109     0.200
     1.037    18.102     0.200
     1.131    19.398     0.200
     1.181    20.320     0.200
     1.195    20.633     0.200
     0.215     4.734     0.200
     0.227     5.336     0.200
     0.247     5.555     0.200
     0.298     6.625     0.200
     0.305     6.547     0.200
     0.404     7.781     0.200
     0.487     9.328     0.200
     0.595    11.359     0.200
     0.608    11.820     0.200
     0.621    11.383     0.200
     0.629    12.367     0.200
     0.650    10.875     0.200
     0.695    12.891     0.200
     0.733    13.953     0.200
     0.938    17.711     0.200
     0.943    17.039     0.200
     0.946    16.836     0.200
     0.946    16.938     0.200
     1.129    19.461     0.200
     1.171    20.141     0.200
     1.302    22.188     0.200
     0.211     4.586     0.200
     0.246     5.547     0.200
     0.223     5.242     0.200
     0.296     6.523     0.200
     0.302     6.406     0.200
     0.411     7.945     0.200
     0.401     7.688     0.200
     0.483     9.172     0.200
     0.624    11.602     0.200
     0.631    12.383     0.200
     0.591    11.406     0.200
     0.604    11.875     0.200
     0.650    11.227     0.200
     0.729    13.844     0.200
     0.944    16.945     0.200
     0.981    17.625     0.200
     0.991    18.016     0.200
     1.032    18.289     0.200
     1.133    19.680     0.200
     1.298    22.117     0.200
     3.560    59.406     0.200
     6.832   134.672     0.200
     0.209     4.898     0.200
     0.233     5.211     0.200
     0.202     4.125     0.200
     0.279     6.211     0.200
     0.286     6.383     0.200
     0.356     7.336     0.200
     0.385     7.398     0.200
     0.469     8.781     0.200
     0.579    10.930     0.200
     0.591    11.352     0.200
     0.636    12.711     0.200
     0.628    11.219     0.200
     0.724    13.867     0.200
     1.539    28.180     0.200
     0.165     4.227     0.200
     0.158     3.750     0.200
     0.231     5.359     0.200
     0.215     5.320     0.200
     0.245     5.695     0.200
     0.246     5.469     0.200
     0.311     6.594     0.200
     0.348     6.836     0.200
     0.434     8.289     0.200
     0.424     8.250     0.200
     0.533    10.273     0.200
     0.545    10.664     0.200
     0.626    10.594     0.200
     0.668    11.969     0.200
     0.678    12.523     0.200
     0.681    12.836     0.200
     0.683    13.141     0.200
     0.941    16.656     0.200
     1.191    20.461     0.200
     0.212     4.664     0.200
     0.226     5.234     0.200
     0.249     5.484     0.200
     0.305     6.414     0.200
     0.486     9.336     0.200
     0.594    11.578     0.200
     0.624    11.242     0.200
     0.607    11.969     0.200
     0.628    12.117     0.200
     0.653    11.070     0.200
     0.698    13.000     0.200
     0.698    12.789     0.200
     0.731    13.836     0.200
     0.942    16.945     0.200
     0.980    17.727     0.200
     0.992    18.094     0.200
     1.029    18.586     0.200
     1.130    19.516     0.200
     1.625    27.812     0.200
     0.233     5.055     0.200
     0.249     5.719     0.200
     0.261     5.719     0.200
     0.321     7.039     0.200
     0.386     7.734     0.200
     0.408     7.883     0.200
     0.426     8.195     0.200
     0.509     9.695     0.200
     0.610    11.266     0.200
     0.608    12.008     0.200
     0.616    11.758     0.200
     0.629    12.148     0.200
     0.666    11.477     0.200
     0.709    13.016     0.200
     0.709    12.445     0.200
     0.748    14.188     0.200
     0.934    17.266     0.200
     0.942    17.008     0.200
     0.984    17.719     0.200
     1.012    18.234     0.200
     1.017    18.125     0.200
     1.108    19.172     0.200
     2.464    42.914     0.200
     4.714    77.938     0.200
     5.402    88.867     0.200
     6.631   106.734     0.200
     0.163     4.219     0.200
     0.215     5.227     0.200
     0.168     3.742     0.200
     0.237     5.625     0.200
     0.241     5.383     0.200
     0.341     6.766     0.200
     0.320     6.492     0.200
     0.419     8.055     0.200
     0.424     8.266     0.200
     0.536    10.438     0.200
     0.546    10.695     0.200
     0.611    10.477     0.200
     0.662    12.453     0.200
     0.657    11.703     0.200
     0.694    13.156     0.200
     0.689    12.547     0.200
     0.947    17.078     0.200
     0.950    18.789     0.200
     0.954    17.062     0.200
     0.957    16.758     0.200
     0.984    17.297     0.200
     1.053    18.594     0.200
     1.189    20.203     0.200
     1.189    19.945     0.200
     1.239    20.844     0.200
     1.266    21.617     0.200
     3.104    53.852     0.200
     0.240     5.602     0.200
     0.228     4.984     0.200
     0.250     5.609     0.200
     0.310     6.852     0.200
     0.382     7.750     0.200
     0.402     7.750     0.200
     0.500     9.570     0.200
     0.609    11.602     0.200
     0.621    12.133     0.200
     0.655    10.734     0.200
     0.610    11.102     0.200
     0.619    12.008     0.200
     0.698    12.828     0.200
     0.698    12.578     0.200
     0.950    17.000     0.200
     1.115    19.250     0.200
     1.208    21.000     0.200
     1.314    22.789     0.200
     3.338    54.281     0.200
     0.234     5.102     0.200
     0.243     5.631     0.200
     0.247     5.570     0.200
     0.311     6.861     0.200
     0.320     6.781     0.200
     0.503     9.570     0.200
     0.613    11.691     0.200
     0.620    11.898     0.200
     0.625    11.990     0.200
     0.603    11.080     0.200
     0.651    10.730     0.200
     0.752    14.072     0.200
     0.694    12.531     0.200
     0.948    17.518     0.200
     0.952    16.951     0.200
     0.955    17.160     0.200
     0.996    17.805     0.200
     1.014    18.111     0.200
     1.014    17.900     0.200
     1.032    18.398     0.200
     0.194     4.352     0.200
     0.205     4.973     0.200
     0.241     5.520     0.200
     0.285     6.121     0.200
     0.308     6.051     0.200
     0.347     7.090     0.200
     0.418     8.051     0.200
     0.465     8.902     0.200
     0.573    10.973     0.200
     0.586    11.449     0.200
     0.643    10.852     0.200
     0.638    11.691     0.200
     0.646    12.480     0.200
     0.714    13.742     0.200
     0.942    16.746     0.200
     1.151    19.816     0.200
     2.345    40.691     0.200
     0.189     4.283     0.200
     0.205     4.813     0.200
     0.249     5.503     0.200
     0.314     6.103     0.200
     0.343     7.033     0.200
     0.465     8.823     0.200
     0.571    10.933     0.200
     0.584    11.623     0.200
     0.645    11.723     0.200
     0.642    12.531     0.200
     0.708    13.649     0.200
     0.930    16.733     0.200
     0.933    16.713     0.200
     1.153    19.952     0.200
     1.277    21.992     0.200
     2.448    42.323     0.200
     0.153     3.731     0.200
     0.409     7.761     0.200
     0.444     8.271     0.200
     0.463     9.812     0.200
     0.449     8.691     0.200
     0.459     8.751     0.200
     0.500     9.302     0.200
     0.528    10.312     0.200
     0.529    10.265     0.200
     0.560    10.842     0.200
     0.602    11.171     0.200
     0.602    11.316     0.200
     0.594    11.101     0.200
     0.656    12.111     0.200
     0.672    12.433     0.200
     0.672    12.471     0.200
     0.761    14.171     0.200
     0.761    13.991     0.200
     0.933    17.342     0.200
     0.964    16.967     0.200
     1.015    18.174     0.200
     1.047    18.072     0.200
     1.255    20.812     0.200
     1.255    20.957     0.200
     1.650    29.761     0.200
     1.882    33.111     0.200
     1.934    33.673     0.200
     1.934    33.812     0.200
     2.098    36.781     0.200
     2.099    36.812     0.200
     2.082    36.046     0.200
     2.700    46.968     0.200
     5.634    90.822     0.200
     0.469     9.234     0.200
     0.471     9.227     0.200
     0.515    10.164     0.200
     0.761    14.367     0.200
     0.847    16.594     0.200
     0.959    17.352     0.200
     0.935    17.758     0.200
     0.975    18.617     0.200
     1.035    19.602     0.200
     1.056    19.570     0.200
     1.241    21.852     0.200
     1.240    22.148     0.200
     1.291    22.656     0.200
     1.280    23.508     0.200
     1.360    24.000     0.200
     1.920    35.547     0.200
     1.968    35.852     0.200
     4.655    76.648     0.200
     0.178     4.211     0.200
     0.262     5.148     0.200
     0.384     7.312     0.200
     0.366     7.227     0.200
     0.420     9.203     0.200
     0.445     8.477     0.200
     0.498     9.867     0.200
     0.475     9.336     0.200
     0.510     9.953     0.200
     0.557    11.203     0.200
     0.563    10.797     0.200
     0.635    12.047     0.200
     0.637    12.008     0.200
     0.637    12.172     0.200
     0.666    12.633     0.200
     0.725    13.727     0.200
     0.725    13.648     0.200
     0.766    14.562     0.200
     0.936    16.961     0.200
     0.986    18.305     0.200
     0.993    18.555     0.200
     1.198    20.664     0.200
     1.829    33.961     0.200
     1.941    34.398     0.200
     1.973    36.586     0.200
     1.994    35.492     0.200
     5.639    91.547     0.200
     0.091     2.477     0.200
     0.091     2.621     0.200
     0.095     2.688     0.200
     0.096     2.703     0.200
     0.624    11.496     0.200
     0.612    11.418     0.200
     0.623    11.688     0.200
     0.699    12.477     0.200
     0.799    14.289     0.200
     0.822    14.832     0.200
     0.822    14.816     0.200
     0.851    14.996     0.200
     0.851    15.168     0.200
     0.859    15.594     0.200
     0.874    15.406     0.200
     0.834    15.773     0.200
     0.911    16.238     0.200
     0.915    16.559     0.200
     1.093    19.176     0.200
     1.232    20.887     0.200
     1.857    30.707     0.200
     0.111     2.406     0.200
     0.111     2.711     0.200
     0.607    11.625     0.200
     0.623    12.055     0.200
     0.630    12.008     0.200
     0.782    14.523     0.200
     0.815    15.008     0.200
     0.837    15.141     0.200
     0.852    16.375     0.200
     1.240    22.617     0.200
     1.275    22.453     0.200
     1.442    27.266     0.200
     1.546    28.125     0.200
     1.731    31.289     0.200
     1.875    33.828     0.200
     0.187     4.029     0.200
     0.218     5.509     0.200
     0.323     6.420     0.200
     0.318     7.079     0.200
     0.451     8.723     0.200
     0.458     9.049     0.200
     0.514    10.419     0.200
     0.663    11.599     0.200
     0.633    11.799     0.200
     0.714    13.335     0.200
     0.769    14.390     0.200
     0.825    14.969     0.200
     0.825    15.307     0.200
     0.851    15.915     0.200
     1.008    18.395     0.200
     1.039    19.579     0.200
     1.039    18.189     0.200
     1.055    18.399     0.200
     1.898    34.659     0.200
     0.341     6.168     0.200
     0.442     8.457     0.200
     0.703    13.109     0.200
     0.692    13.980     0.200
     0.684    14.246     0.200
     0.747    15.203     0.200
     0.987    18.336     0.200
     1.003    18.449     0.200
     1.119    19.508     0.200
     1.119    19.281     0.200
     1.211    22.137     0.200
     1.211    22.027     0.200
     1.619    31.770     0.200
     0.323     6.523     0.200
     0.463     9.453     0.200
     0.447     8.992     0.200
     0.485     9.750     0.200
     0.443     8.797     0.200
     0.495    10.203     0.200
     0.575    10.992     0.200
     0.593    11.070     0.200
     0.636    12.000     0.200
     0.709    12.734     0.200
     0.709    12.953     0.200
     0.708    13.391     0.200
     0.734    14.375     0.200
     0.742    14.102     0.200
     0.778    14.484     0.200
     0.778    14.680     0.200
     0.868    13.852     0.200
     0.815    15.625     0.200
     1.031    18.227     0.200
     1.064    18.641     0.200
     1.069    18.930     0.200
     1.203    20.977     0.200
     1.278    22.031     0.200
     1.348    22.984     0.200
     1.639    29.336     0.200
     0.265     5.594     0.200
     0.265     5.432     0.200
     0.460     9.043     0.200
     0.641    11.912     0.200
     0.711    13.053     0.200
     0.739    13.961     0.200
     0.717    13.496     0.200
     0.757    13.773     0.200
     0.724    13.883     0.200
     0.839    15.471     0.200
     0.947    17.012     0.200
     1.345    22.271     0.200
     1.345    22.143     0.200
     1.851    32.980     0.200
     2.353    40.992     0.200
     2.431    41.922     0.200
     0.096     3.190     0.200
     0.127     3.521     0.200
     0.118     3.641     0.200
     0.196     4.641     0.200
     0.268     5.650     0.200
     0.268     5.971     0.200
     0.292     5.730     0.200
     0.254     5.871     0.200
     0.315     6.391     0.200
     0.309     6.661     0.200
     0.317     6.811     0.200
     0.331     7.161     0.200
     0.331     6.961     0.200
     0.363     7.381     0.200
     0.378     7.551     0.200
     0.399     7.900     0.200
     0.409     8.131     0.200
     0.372     7.860     0.200
     0.376     7.621     0.200
     0.400     8.301     0.200
     0.390     8.391     0.200
     0.399     8.561     0.200
     0.443     8.690     0.200
     0.460     9.131     0.200
     0.478     8.630     0.200
     0.478     8.900     0.200
     0.481     8.911     0.200
     0.453     9.221     0.200
     0.461     8.986     0.200
     0.461     9.190     0.200
     0.499     9.591     0.200
     0.485     9.661     0.200
     0.529     9.741     0.200
     0.520    10.171     0.200
     0.562    10.751     0.200
     0.558    10.841     0.200
     0.583    11.521     0.200
     0.588    11.521     0.200
     0.611    12.081     0.200
     0.665    12.681     0.200
     0.680    12.501     0.200
     0.714    13.501     0.200
     0.716    13.201     0.200
     0.708    13.314     0.200
     0.715    13.690     0.200
     0.776    13.860     0.200
     0.804    14.421     0.200
     0.156     3.551     0.200
     0.190     4.781     0.200
     0.210     4.432     0.200
     0.291     5.816     0.200
     0.294     6.102     0.200
     0.323     7.051     0.200
     0.354     7.391     0.200
     0.362     7.322     0.200
     0.411     8.582     0.200
     0.426     8.371     0.200
     0.443     9.051     0.200
     0.481     9.426     0.200
     0.515    10.191     0.200
     0.527    10.152     0.200
     0.530    10.561     0.200
     0.536    10.662     0.200
     0.549    10.352     0.200
     0.558    11.111     0.200
     0.579    10.721     0.200
     0.577    11.672     0.200
     0.601    11.232     0.200
     0.676    12.334     0.200
     0.677    12.941     0.200
     0.682    12.789     0.200
     0.682    12.891     0.200
     0.696    12.941     0.200
     0.705    13.592     0.200
     0.741    13.996     0.200
     0.783    14.432     0.200
     0.815    14.891     0.200
     0.818    15.291     0.200
     0.821    15.342     0.200
     0.868    16.234     0.200
     0.866    16.172     0.200
     0.880    16.461     0.200
     0.909    17.021     0.200
     0.928    17.602     0.200
     0.930    17.221     0.200
     0.981    17.912     0.200
     0.996    17.541     0.200
     0.998    17.842     0.200
     1.010    18.531     0.200
     1.025    18.291     0.200
     1.069    19.002     0.200
     1.102    18.711     0.200
     1.130    19.941     0.200
     1.217    21.211     0.200
     1.288    22.316     0.200
     1.288    22.322     0.200
     1.383    23.674     0.200
     2.418    40.922     0.200
     0.074     1.769     0.200
     0.174     3.464     0.200
     0.279     6.004     0.200
     0.287     6.134     0.200
     0.313     6.354     0.200
     0.397     7.954     0.200
     0.404     7.874     0.200
     0.451     8.894     0.200
     0.454     9.224     0.200
     0.477     9.144     0.200
     0.479     8.929     0.200
     0.479     9.213     0.200
     0.555    11.038     0.200
     0.596    11.354     0.200
     0.622    12.224     0.200
     0.615    11.894     0.200
     0.618    11.984     0.200
     0.646    12.414     0.200
     0.652    12.764     0.200
     0.688    13.264     0.200
     0.693    13.264     0.200
     0.736    14.194     0.200
     0.770    14.498     0.200
     0.761    14.644     0.200
     0.782    14.894     0.200
     0.789    15.164     0.200
     0.808    15.500     0.200
     0.832    16.224     0.200
     0.840    15.794     0.200
     0.862    16.264     0.200
     0.869    16.794     0.200
     0.886    16.754     0.200
     0.904    16.843     0.200
     0.894    16.974     0.200
     0.899    16.864     0.200
     0.903    17.054     0.200
     0.903    16.944     0.200
     0.902    17.114     0.200
     0.929    17.339     0.200
     0.940    17.634     0.200
     1.004    18.294     0.200
     1.004    18.774     0.200
     1.025    19.079     0.200
     1.044    19.014     0.200
     1.046    19.184     0.200
     1.054    20.224     0.200
     1.078    19.894     0.200
     1.088    20.282     0.200
     1.106    20.314     0.200
     1.118    20.634     0.200
     1.160    21.684     0.200
     1.191    21.784     0.200
     1.196    21.864     0.200
     1.209    22.104     0.200
     1.202    21.904     0.200
     1.245    23.314     0.200
     1.268    22.634     0.200
     1.266    23.004     0.200
     1.274    23.474     0.200
     1.280    22.617     0.200
     1.284    22.364     0.200
     1.315    24.864     0.200
     1.937    34.860     0.200
     0.085     1.598     0.200
     0.186     3.660     0.200
     0.267     5.832     0.200
     0.277     5.930     0.200
     0.331     6.660     0.200
     0.391     7.781     0.200
     0.395     7.801     0.200
     0.453     9.402     0.200
     0.459     9.199     0.200
     0.468     9.082     0.200
     0.468     8.609     0.200
     0.469     9.445     0.200
     0.469     9.109     0.200
     0.469     8.930     0.200
     0.551    10.941     0.200
     0.589    11.422     0.200
     0.606    11.832     0.200
     0.610    12.141     0.200
     0.613    12.051     0.200
     0.636    12.312     0.200
     0.640    12.902     0.200
     0.679    13.180     0.200
     0.685    13.211     0.200
     0.725    13.980     0.200
     0.749    14.582     0.200
     0.775    14.602     0.200
     0.776    14.879     0.200
     0.787    15.402     0.200
     0.811    15.781     0.200
     0.821    16.270     0.200
     0.835    15.902     0.200
     0.856    16.320     0.200
     0.872    16.930     0.200
     0.883    16.910     0.200
     0.897    16.973     0.200
     0.893    17.051     0.200
     0.893    17.129     0.200
     0.902    17.289     0.200
     0.916    17.090     0.200
     0.916    16.934     0.200
     0.941    17.750     0.200
     0.938    17.789     0.200
     0.992    18.289     0.200
     0.992    18.156     0.200
     1.019    19.211     0.200
     1.032    18.930     0.200
     1.034    19.082     0.200
     1.054    20.090     0.200
     1.076    20.090     0.200
     1.076    20.211     0.200
     1.076    20.012     0.200
     1.104    20.461     0.200
     1.117    20.891     0.200
     1.162    21.922     0.200
     1.181    21.879     0.200
     1.192    22.039     0.200
     1.221    22.352     0.200
     1.231    22.410     0.200
     1.242    23.230     0.200
     1.249    23.473     0.200
     1.250    23.609     0.200
     1.257    22.832     0.200
     1.268    22.852     0.200
     1.268    22.520     0.200
     1.294    22.750     0.200
     1.315    24.172     0.200
     1.319    25.121     0.200
     1.330    23.492     0.200
     1.610    30.371     0.200
     1.616    29.660     0.200
     1.938    35.242     0.200
     0.252     5.067     0.200
     0.236     4.908     0.200
     0.384     7.608     0.200
     0.518     9.639     0.200
     0.504    10.009     0.200
     0.564    10.488     0.200
     0.561    11.379     0.200
     0.516    10.059     0.200
     0.516     9.860     0.200
     0.568    11.028     0.200
     0.542    10.549     0.200
     0.542    10.658     0.200
     0.563    10.948     0.200
     0.600    10.959     0.200
     0.641    11.998     0.200
     0.641    11.802     0.200
     0.665    12.748     0.200
     0.648    12.288     0.200
     0.701    13.278     0.200
     0.705    12.788     0.200
     0.703    12.698     0.200
     0.802    14.019     0.200
     0.773    14.028     0.200
     0.804    14.868     0.200
     0.807    14.948     0.200
     0.807    14.763     0.200
     0.834    15.339     0.200
     0.859    15.889     0.200
     0.890    16.488     0.200
     0.881    16.229     0.200
     0.908    16.658     0.200
     0.910    16.818     0.200
     0.984    17.759     0.200
     0.999    18.049     0.200
     0.990    17.788     0.200
     0.990    17.669     0.200
     0.997    17.688     0.200
     1.029    18.448     0.200
     1.094    19.209     0.200
     1.090    19.139     0.200
     1.077    20.028     0.200
     1.115    18.339     0.200
     1.111    20.908     0.200
     1.182    20.419     0.200
     1.232    21.089     0.200
     1.243    21.229     0.200
     1.252    21.368     0.200
     1.321    22.519     0.200
     1.360    22.919     0.200
     1.615    30.179     0.200
     1.696    31.229     0.200
     2.274    39.388     0.200
     0.108     2.750     0.200
     0.311     6.367     0.200
     0.265     5.344     0.200
     0.265     5.031     0.200
     0.387     7.680     0.200
     0.629    11.953     0.200
     0.668    13.156     0.200
     0.615    11.125     0.200
     0.828    15.102     0.200
     0.836    15.234     0.200
     1.048    18.602     0.200
     1.008    17.703     0.200
     1.172    20.273     0.200
     1.352    23.273     0.200
     1.415    24.266     0.200
     1.454    24.789     0.200
     1.454    24.672     0.200
     1.407    24.672     0.200
     1.660    28.109     0.200
     0.296     6.406     0.200
     0.351     6.844     0.200
     0.356     7.324     0.200
     0.442     8.238     0.200
     0.509     9.258     0.200
     0.509     9.461     0.200
     0.517     9.387     0.200
     0.687    12.930     0.200
     0.749    13.891     0.200
     1.242    21.082     0.200
     0.137     3.805     0.200
     0.161     3.475     0.200
     0.174     4.455     0.200
     0.166     4.014     0.200
     0.167     4.170     0.200
     0.167     3.914     0.200
     0.167     4.057     0.200
     0.188     4.674     0.200
     0.195     4.834     0.200
     0.296     6.164     0.200
     0.269     5.936     0.200
     0.300     6.154     0.200
     0.292     6.064     0.200
     0.357     7.445     0.200
     0.421     8.395     0.200
     0.437     8.795     0.200
     0.464     9.164     0.200
     0.496     9.814     0.200
     0.511     9.895     0.200
     0.502     9.994     0.200
     0.522    10.035     0.200
     0.551    10.475     0.200
     0.533    10.305     0.200
     0.535    10.344     0.200
     0.607    11.275     0.200
     0.618    12.215     0.200
     0.644    11.875     0.200
     0.625    12.074     0.200
     0.642    12.205     0.200
     0.642    12.104     0.200
     0.650    12.686     0.200
     0.686    12.975     0.200
     0.679    12.535     0.200
     0.670    12.795     0.200
     0.727    13.715     0.200
     0.716    13.125     0.200
     0.715    13.164     0.200
     0.738    13.365     0.200
     0.739    13.785     0.200
     0.785    14.436     0.200
     0.785    14.314     0.200
     0.781    14.365     0.200
     0.781    14.295     0.200
     0.819    14.844     0.200
     0.842    15.584     0.200
     0.832    15.064     0.200
     0.807    15.494     0.200
     0.841    15.545     0.200
     0.845    15.615     0.200
     0.883    16.234     0.200
     0.883    15.914     0.200
     0.858    16.084     0.200
     0.858    15.510     0.200
     0.909    16.074     0.200
     0.910    16.055     0.200
     0.927    16.635     0.200
     0.902    16.545     0.200
     0.905    17.240     0.200
     0.946    17.254     0.200
     0.954    18.045     0.200
     1.026    18.305     0.200
     1.062    19.324     0.200
     1.062    19.205     0.200
     1.406    22.984     0.200
     0.061     2.602     0.200
     0.175     4.461     0.200
     0.207     5.062     0.200
     0.184     4.297     0.200
     0.203     4.633     0.200
     0.250     5.562     0.200
     0.364     7.727     0.200
     0.364     7.844     0.200
     0.404     7.883     0.200
     0.435     8.414     0.200
     0.435     8.188     0.200
     0.555    10.859     0.200
     0.557    10.477     0.200
     0.550    10.641     0.200
     0.559    10.812     0.200
     0.606    10.992     0.200
     0.602    11.680     0.200
     0.640    11.711     0.200
     0.655    12.219     0.200
     0.685    13.141     0.200
     0.710    13.516     0.200
     0.858    15.711     0.200
     0.904    16.000     0.200
     0.920    16.719     0.200
     0.972    16.422     0.200
     0.973    17.203     0.200
     0.954    17.188     0.200
     0.954    17.359     0.200
     0.963    17.297     0.200
     0.968    17.094     0.200
     1.282    21.828     0.200
     1.740    30.758     0.200
     1.788    31.266     0.200
     1.950    34.117     0.200
     2.140    37.180     0.200
     2.384    41.492     0.200
     2.411    41.727     0.200
     2.469    42.711     0.200
     3.999    68.562     0.200
     5.304    92.000     0.200
     0.112     3.879     0.200
     0.151     4.039     0.200
     0.212     4.457     0.200
     0.212     4.988     0.200
     0.230     5.277     0.200
     0.234     5.379     0.200
     0.273     6.141     0.200
     0.295     6.141     0.200
     0.310     6.621     0.200
     0.357     7.008     0.200
     0.364     6.949     0.200
     0.423     8.270     0.200
     0.423     8.211     0.200
     0.501    10.070     0.200
     0.551    10.340     0.200
     0.551    10.199     0.200
     0.549    10.203     0.200
     0.549    10.777     0.200
     0.554    10.527     0.200
     0.554    10.199     0.200
     0.568    11.500     0.200
     0.617     9.801     0.200
     0.618    11.570     0.200
     0.618    11.000     0.200
     0.648    12.418     0.200
     0.741    13.719     0.200
     0.736    13.375     0.200
     0.728    13.562     0.200
     0.852    15.320     0.200
     0.924    15.898     0.200
     1.015    20.258     0.200
     1.022    17.820     0.200
     1.022    17.953     0.200
     1.092    19.027     0.200
     1.310    22.273     0.200
     1.418    25.121     0.200
     1.755    30.719     0.200
     2.152    35.648     0.200
     2.428    42.434     0.200
     2.522    43.133     0.200
     2.526    43.160     0.200
     2.586    44.230     0.200
     3.218    53.371     0.200
     4.049    69.188     0.200
     0.028     2.102     0.200
     0.164     4.273     0.200
     0.178     4.070     0.200
     0.181     4.031     0.200
     0.185     4.352     0.200
     0.310     5.953     0.200
     0.312     6.922     0.200
     0.317     6.211     0.200
     0.335     6.543     0.200
     0.369     7.660     0.200
     0.386     8.090     0.200
     0.419     8.230     0.200
     0.426     8.883     0.200
     0.439     8.930     0.200
     0.457     8.691     0.200
     0.462     9.223     0.200
     0.469     9.371     0.200
     0.552    10.852     0.200
     0.553    10.660     0.200
     0.625    11.910     0.200
     0.667    12.273     0.200
     0.667    12.152     0.200
     0.696    13.102     0.200
     0.706    13.543     0.200
     0.719    13.523     0.200
     0.715    14.062     0.200
     0.723    13.570     0.200
     0.744    13.930     0.200
     0.757    14.160     0.200
     0.798    14.363     0.200
     0.798    14.469     0.200
     0.805    14.852     0.200
     0.808    14.973     0.200
     0.856    15.602     0.200
     0.871    15.910     0.200
     0.916    16.871     0.200
     0.997    18.262     0.200
     1.037    19.203     0.200
     1.108    18.730     0.200
     1.170    21.562     0.200
     1.305    22.402     0.200
     1.305    22.234     0.200
     1.309    23.570     0.200
     1.355    23.094     0.200
     1.617    28.938     0.200
     0.299     6.551     0.200
     0.361     7.230     0.200
     0.367     7.141     0.200
     0.432     8.918     0.200
     0.385     7.910     0.200
     0.406     8.020     0.200
     0.458     9.359     0.200
     0.406     8.500     0.200
     0.417     8.078     0.200
     0.465     8.961     0.200
     0.451     9.199     0.200
     0.511    10.141     0.200
     0.549    10.770     0.200
     0.558    11.191     0.200
     0.573    11.121     0.200
     0.658    12.199     0.200
     0.678    12.602     0.200
     0.679    12.719     0.200
     0.635    11.891     0.200
     0.670    12.793     0.200
     0.674    12.828     0.200
     0.677    12.836     0.200
     0.719    13.031     0.200
     0.712    13.719     0.200
     0.729    13.512     0.200
     0.762    14.648     0.200
     0.724    14.078     0.200
     0.724    14.238     0.200
     0.759    14.539     0.200
     0.749    14.461     0.200
     0.803    14.410     0.200
     0.803    14.582     0.200
     0.848    15.398     0.200
     0.960    16.211     0.200
     1.007    18.051     0.200
     1.041    18.551     0.200
     1.225    21.137     0.200
     1.313    22.449     0.200
     1.656    30.520     0.200
     7.432   122.691     0.200
     0.199     4.782     0.200
     0.212     4.992     0.200
     0.292     6.282     0.200
     0.354     7.002     0.200
     0.360     7.151     0.200
     0.392     7.782     0.200
     0.425     8.672     0.200
     0.413     7.922     0.200
     0.423     7.962     0.200
     0.412     8.412     0.200
     0.450     9.182     0.200
     0.458     8.952     0.200
     0.449     9.202     0.200
     0.505     9.812     0.200
     0.541    10.592     0.200
     0.551    10.882     0.200
     0.573    11.092     0.200
     0.651    11.892     0.200
     0.639    11.742     0.200
     0.674    12.571     0.200
     0.671    12.382     0.200
     0.673    13.452     0.200
     0.677    12.702     0.200
     0.680    12.702     0.200
     0.711    13.361     0.200
     0.715    13.102     0.200
     0.707    13.552     0.200
     0.722    13.382     0.200
     0.731    14.012     0.200
     0.755    14.392     0.200
     0.757    14.532     0.200
     0.751    14.401     0.200
     0.801    14.562     0.200
     0.843    15.231     0.200
     0.953    16.392     0.200
     1.140    21.361     0.200
     1.306    22.432     0.200
     1.480    27.151     0.200
     1.603    28.622     0.200
     3.175    55.631     0.200
     0.214     4.948     0.200
     0.227     5.198     0.200
     0.296     6.469     0.200
     0.368     7.219     0.200
     0.373     7.318     0.200
     0.373     7.204     0.200
     0.386     7.818     0.200
     0.400     7.919     0.200
     0.406     7.898     0.200
     0.406     8.047     0.200
     0.411     8.429     0.200
     0.431     9.108     0.200
     0.461     9.309     0.200
     0.465     9.469     0.200
     0.474     9.119     0.200
     0.552    11.099     0.200
     0.555    11.009     0.200
     0.588    11.579     0.200
     0.645    12.339     0.200
     0.662    12.409     0.200
     0.671    12.738     0.200
     0.685    12.488     0.200
     0.681    12.609     0.200
     0.685    13.108     0.200
     0.688    13.148     0.200
     0.708    13.219     0.200
     0.717    13.589     0.200
     0.725    13.929     0.200
     0.725    13.988     0.200
     0.725    14.206     0.200
     0.738    13.709     0.200
     0.738    13.923     0.200
     0.762    14.579     0.200
     0.771    14.879     0.200
     0.773    15.039     0.200
     0.787    14.938     0.200
     0.791    14.509     0.200
     0.786    14.988     0.200
     0.805    15.448     0.200
     0.814    15.619     0.200
     0.840    15.289     0.200
     0.851    15.889     0.200
     0.875    16.398     0.200
     0.889    16.849     0.200
     0.940    17.339     0.200
     0.958    18.028     0.200
     0.950    17.909     0.200
     0.959    17.858     0.200
     0.968    18.068     0.200
     1.021    18.278     0.200
     1.074    19.108     0.200
     1.597    29.879     0.200
     0.198     4.768     0.200
     0.208     5.058     0.200
     0.294     6.338     0.200
     0.353     6.988     0.200
     0.360     7.138     0.200
     0.391     7.928     0.200
     0.414     8.108     0.200
     0.410     8.488     0.200
     0.425     8.098     0.200
     0.426     8.648     0.200
     0.450     9.248     0.200
     0.446     9.218     0.200
     0.457     8.928     0.200
     0.507     9.838     0.200
     0.542    10.618     0.200
     0.553    10.978     0.200
     0.570    11.208     0.200
     0.636    11.928     0.200
     0.651    11.898     0.200
     0.677    12.658     0.200
     0.671    12.298     0.200
     0.670    13.106     0.200
     0.674    12.728     0.200
     0.677    12.758     0.200
     0.705    13.458     0.200
     0.713    13.138     0.200
     0.719    12.928     0.200
     0.721    13.398     0.200
     0.730    14.098     0.200
     0.748    14.418     0.200
     0.754    14.138     0.200
     0.753    14.518     0.200
     0.769    14.628     0.200
     0.804    14.488     0.200
     0.804    14.383     0.200
     0.846    15.248     0.200
     0.847    15.668     0.200
     0.863    16.238     0.200
     0.876    16.408     0.200
     0.938    17.158     0.200
     0.942    17.428     0.200
     0.955    15.908     0.200
     0.986    17.735     0.200
     1.000    17.738     0.200
     1.034    18.268     0.200
     1.109    19.348     0.200
     1.159    20.178     0.200
     1.219    21.068     0.200
     1.254    21.633     0.200
     1.306    22.268     0.200
     1.365    25.078     0.200
     0.209     5.109     0.200
     0.295     6.339     0.200
     0.355     7.119     0.200
     0.361     7.138     0.200
     0.427     8.779     0.200
     0.424     8.037     0.200
     0.452     9.279     0.200
     0.508     9.909     0.200
     0.543    10.659     0.200
     0.636    11.829     0.200
     0.652    11.958     0.200
     0.672    12.359     0.200
     0.674    12.819     0.200
     0.677    12.839     0.200
     0.706    13.679     0.200
     0.719    13.139     0.200
     0.722    13.469     0.200
     0.729    14.098     0.200
     0.755    14.449     0.200
     0.755    14.589     0.200
     0.804    14.809     0.200
     0.804    14.437     0.200
     1.143    21.759     0.200
     1.254    21.755     0.200
     1.601    29.719     0.200
     1.731    30.458     0.200
     1.740    30.719     0.200
     2.216    38.559     0.200
     0.151     3.562     0.200
     0.303     6.062     0.200
     0.307     6.262     0.200
     0.350     7.152     0.200
     0.347     7.422     0.200
     0.358     7.664     0.200
     0.401     8.402     0.200
     0.441     8.734     0.200
     0.446     9.035     0.200
     0.477     9.273     0.200
     0.507     9.844     0.200
     0.519    10.152     0.200
     0.551    10.395     0.200
     0.542    10.613     0.200
     0.556    10.215     0.200
     0.560    11.004     0.200
     0.569    11.145     0.200
     0.574    11.184     0.200
     0.610    11.465     0.200
     0.652    12.145     0.200
     0.652    12.305     0.200
     0.676    12.605     0.200
     0.695    13.215     0.200
     0.701    13.133     0.200
     0.717    13.984     0.200
     0.762    14.164     0.200
     0.762    14.410     0.200
     0.805    14.113     0.200
     0.843    15.582     0.200
     0.843    15.477     0.200
     0.879    16.000     0.200
     1.099    19.203     0.200
     1.220    21.004     0.200
     1.310    22.477     0.200
     1.407    23.777     0.200
     1.454    27.414     0.200
     1.592    30.043     0.200
     1.592    29.816     0.200
     1.638    30.613     0.200
     2.378    41.203     0.200
     0.058     2.203     0.200
     0.158     3.867     0.200
     0.197     4.727     0.200
     0.201     4.961     0.200
     0.208     4.523     0.200
     0.227     4.977     0.200
     0.260     6.125     0.200
     0.269     5.797     0.200
     0.364     7.875     0.200
     0.363     6.992     0.200
     0.360     7.234     0.200
     0.384     7.945     0.200
     0.384     7.766     0.200
     0.456     8.664     0.200
     0.456     8.711     0.200
     0.465     9.188     0.200
     0.487     9.188     0.200
     0.539    10.344     0.200
     0.572    10.953     0.200
     0.581    11.156     0.200
     0.604    11.547     0.200
     0.604    11.133     0.200
     0.617    11.508     0.200
     0.621    12.008     0.200
     0.675    13.031     0.200
     0.725    13.695     0.200
     0.734    13.867     0.200
     0.740    13.625     0.200
     0.761    14.398     0.200
     0.776    14.195     0.200
     0.791    13.992     0.200
     0.878    15.102     0.200
     0.880    16.016     0.200
     0.889    16.156     0.200
     0.889    15.938     0.200
     0.940    17.016     0.200
     0.954    16.734     0.200
     0.977    17.383     0.200
     0.978    17.656     0.200
     0.987    17.531     0.200
     0.981    17.375     0.200
     0.981    17.477     0.200
     1.079    18.938     0.200
     1.088    19.078     0.200
     1.154    19.938     0.200
     1.190    20.508     0.200
     1.219    21.086     0.200
     1.415    23.961     0.200
     1.454    25.773     0.200
     0.056     2.156     0.200
     0.161     3.828     0.200
     0.196     4.680     0.200
     0.203     4.867     0.200
     0.203     5.039     0.200
     0.206     4.461     0.200
     0.206     4.617     0.200
     0.269     5.766     0.200
     0.269     5.922     0.200
     0.257     6.148     0.200
     0.364     6.930     0.200
     0.359     7.148     0.200
     0.366     7.898     0.200
     0.366     8.047     0.200
     0.386     8.461     0.200
     0.387     7.680     0.200
     0.456     8.688     0.200
     0.455     8.742     0.200
     0.463     9.531     0.200
     0.489     9.141     0.200
     0.545    10.742     0.200
     0.542    10.438     0.200
     0.542    10.547     0.200
     0.572    10.922     0.200
     0.581    11.180     0.200
     0.581    11.289     0.200
     0.606    11.266     0.200
     0.619    12.703     0.200
     0.618    11.562     0.200
     0.619    12.102     0.200
     0.673    13.008     0.200
     0.732    13.820     0.200
     0.724    13.648     0.200
     0.738    13.648     0.200
     0.759    13.891     0.200
     0.773    14.258     0.200
     0.794    14.180     0.200
     0.877    16.172     0.200
     0.892    16.008     0.200
     0.938    17.078     0.200
     0.952    16.930     0.200
     0.976    18.086     0.200
     0.985    17.602     0.200
     0.985    17.711     0.200
     0.979    17.266     0.200
     0.979    17.516     0.200
     1.086    19.141     0.200
     1.154    20.031     0.200
     1.188    20.508     0.200
     1.284    22.000     0.200
     1.304    22.289     0.200
     1.389    23.703     0.200
     1.412    23.930     0.200
     1.454    25.516     0.200
     1.654    30.469     0.200
     1.796    33.438     0.200
     2.493    42.812     0.200
     7.748   129.117     0.200
     0.179     4.016     0.200
     0.293     6.406     0.200
     0.309     6.156     0.200
     0.345     6.906     0.200
     0.364     7.277     0.200
     0.365     7.266     0.200
     0.412     8.406     0.200
     0.412     8.316     0.200
     0.471     9.117     0.200
     0.477     9.809     0.200
     0.456     8.918     0.200
     0.488     9.598     0.200
     0.503     9.809     0.200
     0.487     9.105     0.200
     0.498     9.566     0.200
     0.501     9.559     0.200
     0.553    11.027     0.200
     0.526    10.297     0.200
     0.576    11.125     0.200
     0.596    11.238     0.200
     0.562    10.988     0.200
     0.605    11.098     0.200
     0.572    11.285     0.200
     0.583    11.465     0.200
     0.641    12.918     0.200
     0.644    12.488     0.200
     0.658    12.816     0.200
     0.672    12.797     0.200
     0.689    13.277     0.200
     0.756    14.098     0.200
     0.769    13.996     0.200
     0.755    14.297     0.200
     0.756    14.387     0.200
     0.795    14.598     0.200
     0.788    14.688     0.200
     0.822    15.125     0.200
     0.818    15.547     0.200
     0.866    15.625     0.200
     0.882    16.168     0.200
     0.853    16.098     0.200
     0.858    16.098     0.200
     0.870    16.398     0.200
     0.906    16.578     0.200
     0.899    16.816     0.200
     0.906    16.926     0.200
     0.940    16.746     0.200
     0.955    17.621     0.200
     0.976    17.918     0.200
     0.994    18.156     0.200
     1.036    17.715     0.200
     1.043    18.348     0.200
     1.371    23.035     0.200
     1.806    33.754     0.200
     1.933    34.352     0.200
     1.987    35.215     0.200
     2.006    34.277     0.200
     2.602    44.176     0.200
     2.633    44.059     0.200
     0.137     3.922     0.200
     0.144     3.359     0.200
     0.208     4.906     0.200
     0.244     4.992     0.200
     0.245     5.086     0.200
     0.276     6.117     0.200
     0.291     6.547     0.200
     0.316     6.812     0.200
     0.358     7.398     0.200
     0.374     7.508     0.200
     0.402     8.547     0.200
     0.406     8.297     0.200
     0.492    10.086     0.200
     0.515     9.750     0.200
     0.523    10.008     0.200
     0.541    10.531     0.200
     0.547    10.297     0.200
     0.544    10.648     0.200
     0.560    10.992     0.200
     0.611    11.156     0.200
     0.632    11.984     0.200
     0.657    13.047     0.200
     0.689    13.258     0.200
     0.713    13.148     0.200
     0.715    12.383     0.200
     0.715    12.891     0.200
     0.765    14.039     0.200
     0.765    13.531     0.200
     0.784    15.062     0.200
     0.799    14.688     0.200
     0.799    14.977     0.200
     0.804    14.383     0.200
     0.822    15.438     0.200
     0.972    16.859     0.200
     1.222    21.172     0.200
     1.232    21.359     0.200
     1.237    21.320     0.200
     1.242    21.453     0.200
     1.336    22.789     0.200
     1.618    30.516     0.200
     1.707    31.461     0.200
     0.121     3.617     0.200
     0.125     3.057     0.200
     0.142     3.877     0.200
     0.197     4.347     0.200
     0.269     5.557     0.200
     0.351     7.207     0.200
     0.367     7.557     0.200
     0.403     8.007     0.200
     0.454     8.767     0.200
     0.459     9.187     0.200
     0.501     9.487     0.200
     0.510     9.877     0.200
     0.498     9.387     0.200
     0.535    10.457     0.200
     0.557    11.247     0.200
     0.569    10.727     0.200
     0.590    11.297     0.200
     0.596    11.287     0.200
     0.586    11.027     0.200
     0.595    10.947     0.200
     0.585    11.047     0.200
     0.585    11.152     0.200
     0.600    11.117     0.200
     0.613    11.647     0.200
     0.624    11.717     0.200
     0.647    12.467     0.200
     0.643    12.377     0.200
     0.663    12.277     0.200
     0.659    12.557     0.200
     0.739    13.377     0.200
     0.996    17.544     0.200
     1.238    21.027     0.200
     1.396    23.113     0.200
     1.456    26.347     0.200
     1.766    32.041     0.200
     1.890    33.440     0.200
     2.073    35.477     0.200
     0.074     3.016     0.200
     0.100     3.414     0.200
     0.125     3.023     0.200
     0.125     3.414     0.200
     0.126     3.375     0.200
     0.121     3.750     0.200
     0.128     3.797     0.200
     0.190     3.805     0.200
     0.240     4.977     0.200
     0.199     4.836     0.200
     0.219     4.891     0.200
     0.315     6.500     0.200
     0.372     7.445     0.200
     0.391     8.016     0.200
     0.566    10.859     0.200
     0.606    11.484     0.200
     0.579    11.070     0.200
     0.577    11.555     0.200
     0.663    12.500     0.200
     0.689    12.656     0.200
     0.812    14.391     0.200
     0.812    14.625     0.200
     0.908    16.492     0.200
     0.896    17.273     0.200
     0.980    17.086     0.200
     1.434    26.945     0.200
     1.501    26.797     0.200
     1.627    28.016     0.200
     1.693    30.156     0.200
     1.997    35.781     0.200
     0.159     3.745     0.200
     0.211     4.895     0.200
     0.275     5.435     0.200
     0.283     5.895     0.200
     0.327     6.385     0.200
     0.327     6.515     0.200
     0.327     6.203     0.200
     0.327     6.475     0.200
     0.384     7.695     0.200
     0.383     7.594     0.200
     0.375     7.435     0.200
     0.448     8.895     0.200
     0.610    11.685     0.200
     0.549    10.655     0.200
     0.603    11.574     0.200
     0.601    11.505     0.200
     0.698    13.475     0.200
     0.663    12.695     0.200
     0.727    14.015     0.200
     0.744    14.304     0.200
     0.696    13.225     0.200
     0.767    14.635     0.200
     0.769    14.475     0.200
     0.792    14.834     0.200
     1.008    18.645     0.200
     1.067    18.615     0.200
     1.509    28.115     0.200
     1.533    27.024     0.200
     1.565    27.975     0.200
     1.652    29.383     0.200
     1.725    30.284     0.200
     1.700    30.420     0.200
     1.818    31.930     0.200
     0.156     3.749     0.200
     0.256     5.319     0.200
     0.259     5.079     0.200
     0.259     5.371     0.200
     0.266     5.458     0.200
     0.284     6.229     0.200
     0.274     5.799     0.200
     0.308     6.418     0.200
     0.324     6.739     0.200
     0.329     6.869     0.200
     0.348     6.969     0.200
     0.370     7.668     0.200
     0.397     7.909     0.200
     0.406     8.108     0.200
     0.419     8.069     0.200
     0.458     9.029     0.200
     0.477     9.708     0.200
     0.483    10.069     0.200
     0.473     9.299     0.200
     0.507     9.799     0.200
     0.573    10.999     0.200
     0.557    10.829     0.200
     0.589    11.049     0.200
     0.610    11.329     0.200
     0.592    11.429     0.200
     0.637    12.029     0.200
     0.599    11.389     0.200
     0.659    12.499     0.200
     0.648    12.188     0.200
     0.659    12.579     0.200
     0.665    12.119     0.200
     0.658    12.349     0.200
     0.677    12.438     0.200
     0.669    12.489     0.200
     0.696    12.958     0.200
     0.682    12.929     0.200
     0.720    13.199     0.200
     0.754    13.929     0.200
     0.774    14.299     0.200
     0.788    14.458     0.200
     0.777    14.838     0.200
     0.805    14.188     0.200
     0.841    15.039     0.200
     0.859    15.769     0.200
     0.882    15.269     0.200
     0.923    16.329     0.200
     1.042    17.958     0.200
     1.281    20.628     0.200
     1.279    21.299     0.200
     1.495    26.219     0.200
     1.548    26.749     0.200
     1.900    33.773     0.200
     7.390   123.154     0.200
     8.303   138.998     0.200
     0.106     2.702     0.200
     0.157     2.962     0.200
     0.175     3.662     0.200
     0.225     5.012     0.200
     0.292     6.362     0.200
     0.299     6.662     0.200
     0.304     6.582     0.200
     0.347     7.122     0.200
     0.347     7.512     0.200
     0.342     6.972     0.200
     0.411     7.742     0.200
     0.436     8.311     0.200
     0.478    10.232     0.200
     0.447     8.864     0.200
     0.460     9.122     0.200
     0.473     9.622     0.200
     0.535    10.852     0.200
     0.590    11.762     0.200
     0.596    11.692     0.200
     0.618    11.872     0.200
     0.617    12.362     0.200
     0.705    13.352     0.200
     0.715    13.472     0.200
     0.697    13.172     0.200
     0.701    13.407     0.200
     0.708    13.502     0.200
     0.708    13.802     0.200
     0.708    13.276     0.200
     0.731    13.652     0.200
     0.752    14.052     0.200
     0.775    15.132     0.200
     0.829    15.092     0.200
     0.925    16.632     0.200
     0.966    17.892     0.200
     0.968    18.002     0.200
     0.978    18.092     0.200
     1.003    18.452     0.200
     1.003    18.432     0.200
     1.052    19.452     0.200
     1.078    19.802     0.200
     1.079    19.632     0.200
     1.095    20.772     0.200
     1.190    21.065     0.200
     1.276    22.098     0.200
     1.457    24.957     0.200
     7.691   128.357     0.200
     0.154     3.805     0.200
     0.211     4.977     0.200
     0.280     5.633     0.200
     0.282     5.953     0.200
     0.292     5.953     0.200
     0.332     6.484     0.200
     0.332     6.664     0.200
     0.335     6.602     0.200
     0.370     7.406     0.200
     0.387     7.633     0.200
     0.387     7.781     0.200
     0.450     8.961     0.200
     0.487     9.594     0.200
     0.545    10.758     0.200
     0.552    10.734     0.200
     0.611    11.742     0.200
     0.598    11.555     0.200
     0.605    11.633     0.200
     0.663    12.703     0.200
     0.668    12.633     0.200
     0.702    13.695     0.200
     0.725    13.953     0.200
     0.732    14.148     0.200
     0.747    14.383     0.200
     0.768    14.461     0.200
     0.794    14.914     0.200
     0.816    15.703     0.200
     0.841    15.547     0.200
     0.903    17.023     0.200
     0.942    17.703     0.200
     1.071    18.750     0.200
     1.099    20.836     0.200
     1.538    26.961     0.200
     1.564    27.281     0.200
     1.699    30.312     0.200
     1.912    34.711     0.200
     2.856    49.961     0.200
     2.967    50.508     0.200
     0.055     1.172     0.200
     0.105     2.500     0.200
     0.149     4.148     0.200
     0.225     4.688     0.200
     0.229     4.859     0.200
     0.286     6.336     0.200
     0.319     6.680     0.200
     0.323     7.031     0.200
     0.364     7.883     0.200
     0.364     7.289     0.200
     0.376     7.750     0.200
     0.514    10.320     0.200
     0.524    10.656     0.200
     0.534     9.812     0.200
     0.549    10.438     0.200
     0.583    10.688     0.200
     0.578    11.172     0.200
     0.579    11.062     0.200
     0.599    11.461     0.200
     0.617    11.680     0.200
     0.639    12.391     0.200
     0.662    12.633     0.200
     0.691    12.430     0.200
     0.691    12.531     0.200
     0.694    13.328     0.200
     0.765    13.539     0.200
     0.802    14.477     0.200
     0.800    15.117     0.200
     0.834    15.211     0.200
     0.834    15.414     0.200
     0.843    15.688     0.200
     0.918    16.703     0.200
     0.929    17.062     0.200
     0.933    17.242     0.200
     0.973    17.516     0.200
     0.984    17.633     0.200
     1.036    18.359     0.200
     1.107    19.523     0.200
     1.124    20.148     0.200
     1.150    20.148     0.200
     1.183    20.938     0.200
     1.379    23.305     0.200
     1.716    31.266     0.200
     0.193     3.681     0.200
     0.199     3.911     0.200
     0.224     5.081     0.200
     0.227     4.881     0.200
     0.231     5.121     0.200
     0.276     5.761     0.200
     0.313     6.671     0.200
     0.340     6.461     0.200
     0.340     6.285     0.200
     0.343     6.462     0.200
     0.330     7.271     0.200
     0.330     7.016     0.200
     0.402     7.971     0.200
     0.417     7.751     0.200
     0.437     8.801     0.200
     0.460     9.591     0.200
     0.465     9.761     0.200
     0.481     9.701     0.200
     0.501     9.851     0.200
     0.508     9.991     0.200
     0.527    10.691     0.200
     0.558    11.091     0.200
     0.580    11.301     0.200
     0.585    11.221     0.200
     0.608    12.301     0.200
     0.626    12.291     0.200
     0.626    12.291     0.200
     0.648    12.591     0.200
     0.673    13.181     0.200
     0.677    13.171     0.200
     0.670    13.311     0.200
     0.689    13.291     0.200
     0.700    13.311     0.200
     0.726    14.121     0.200
     0.733    14.411     0.200
     0.733    14.301     0.200
     0.723    14.411     0.200
     0.741    14.071     0.200
     0.730    14.251     0.200
     0.735    14.541     0.200
     0.739    14.611     0.200
     0.801    15.151     0.200
     0.791    15.431     0.200
     0.805    15.451     0.200
     0.808    15.631     0.200
     0.827    15.661     0.200
     0.865    16.211     0.200
     0.866    16.361     0.200
     0.872    16.461     0.200
     0.872    16.306     0.200
     0.881    17.081     0.200
     0.916    17.841     0.200
     0.908    16.871     0.200
     0.921    17.051     0.200
     0.911    16.941     0.200
     0.928    17.711     0.200
     0.910    18.041     0.200
     0.921    17.511     0.200
     0.933    17.901     0.200
     0.978    18.411     0.200
     1.012    18.781     0.200
     1.020    19.250     0.200
     1.029    19.090     0.200
     1.165    21.351     0.200
     1.165    21.166     0.200
     1.244    22.746     0.200
     1.326    24.094     0.200
     1.325    24.461     0.200
     0.136     3.281     0.200
     0.154     3.391     0.200
     0.176     3.789     0.200
     0.280     5.961     0.200
     0.257     5.660     0.200
     0.278     6.039     0.200
     0.340     7.191     0.200
     0.387     7.730     0.200
     0.385     7.539     0.200
     0.378     7.051     0.200
     0.378     7.359     0.200
     0.342     7.512     0.200
     0.357     7.879     0.200
     0.380     8.359     0.200
     0.425     9.059     0.200
     0.435     8.461     0.200
     0.457     8.988     0.200
     0.479     9.051     0.200
     0.505    10.531     0.200
     0.546    11.012     0.200
     0.580    11.359     0.200
     0.563    11.230     0.200
     0.601    11.891     0.200
     0.669    12.461     0.200
     0.614    11.500     0.200
     0.638    12.391     0.200
     0.643    12.461     0.200
     0.631    12.078     0.200
     0.690    12.809     0.200
     0.661    12.391     0.200
     0.697    13.422     0.200
     0.732    13.539     0.200
     0.708    13.250     0.200
     0.736    14.250     0.200
     0.781    14.422     0.200
     0.745    13.828     0.200
     0.745    13.621     0.200
     0.803    15.352     0.200
     0.774    14.449     0.200
     0.852    15.551     0.200
     0.835    14.609     0.200
     0.894    16.352     0.200
     0.863    15.941     0.200
     0.908    16.820     0.200
     0.890    15.781     0.200
     0.948    17.238     0.200
     0.992    18.289     0.200
     1.016    18.691     0.200
     1.015    18.500     0.200
     1.033    19.262     0.200
     0.976    17.102     0.200
     1.039    18.449     0.200
     1.222    22.051     0.200
     2.162    36.898     0.200
     5.714    95.023     0.200
     7.731   128.199     0.200
     0.148     3.917     0.200
     0.180     4.487     0.200
     0.224     5.177     0.200
     0.227     5.497     0.200
     0.230     5.257     0.200
     0.238     5.377     0.200
     0.257     5.727     0.200
     0.275     5.597     0.200
     0.274     6.247     0.200
     0.274     6.127     0.200
     0.293     5.957     0.200
     0.293     6.447     0.200
     0.301     6.007     0.200
     0.333     7.497     0.200
     0.338     6.847     0.200
     0.364     6.937     0.200
     0.376     7.657     0.200
     0.386     7.327     0.200
     0.420     7.937     0.200
     0.420     8.097     0.200
     0.465     8.547     0.200
     0.486     9.687     0.200
     0.479     9.317     0.200
     0.497     9.777     0.200
     0.512     9.577     0.200
     0.513     9.817     0.200
     0.513     9.940     0.200
     0.544    10.867     0.200
     0.553    10.667     0.200
     0.554    10.537     0.200
     0.561    10.997     0.200
     0.604    10.907     0.200
     0.661    12.347     0.200
     0.681    12.817     0.200
     0.703    13.567     0.200
     0.787    13.697     0.200
     0.830    14.747     0.200
     0.837    14.967     0.200
     0.850    15.227     0.200
     1.036    17.727     0.200
     1.056    18.177     0.200
     1.060    18.146     0.200
     1.060    18.307     0.200
     1.060    18.031     0.200
     1.192    19.867     0.200
     1.277    21.537     0.200
     1.282    21.747     0.200
     2.115    35.367     0.200
     0.112     2.879     0.200
     0.348     7.230     0.200
     0.393     7.828     0.200
     0.445     8.758     0.200
     0.440     8.301     0.200
     0.442     8.961     0.200
     0.510     9.609     0.200
     0.511     9.539     0.200
     0.511     9.680     0.200
     0.512     9.711     0.200
     0.612    11.520     0.200
     0.643    12.250     0.200
     0.677    12.828     0.200
     0.682    13.379     0.200
     0.692    13.461     0.200
     0.713    13.781     0.200
     0.769    14.371     0.200
     0.785    14.641     0.200
     0.788    14.801     0.200
     0.848    15.871     0.200
     0.878    16.348     0.200
     1.293    21.840     0.200
     1.388    23.551     0.200
     1.413    23.699     0.200
     0.247     5.750     0.200
     0.306     6.559     0.200
     0.317     6.609     0.200
     0.329     7.000     0.200
     0.370     7.340     0.200
     0.374     8.109     0.200
     0.408     8.008     0.200
     0.412     8.027     0.200
     0.418     8.156     0.200
     0.414     8.566     0.200
     0.436     8.297     0.200
     0.496     9.738     0.200
     0.504    10.309     0.200
     0.516    10.438     0.200
     0.523    10.188     0.200
     0.557    10.527     0.200
     0.588    11.637     0.200
     0.607    11.828     0.200
     0.601    11.277     0.200
     0.601    11.445     0.200
     0.633    12.750     0.200
     0.655    12.770     0.200
     0.716    13.188     0.200
     0.722    13.188     0.200
     0.720    13.750     0.200
     0.726    14.117     0.200
     0.759    14.020     0.200
     0.757    14.008     0.200
     0.775    14.770     0.200
     0.790    14.617     0.200
     0.788    14.879     0.200
     0.796    14.477     0.200
     0.794    15.328     0.200
     0.876    16.340     0.200
     0.928    16.527     0.200
     0.963    17.809     0.200
     0.989    18.109     0.200
     0.999    18.359     0.200
     1.022    18.457     0.200
     1.033    19.309     0.200
     1.136    20.680     0.200
     1.274    22.359     0.200
     1.318    24.199     0.200
     0.181     4.301     0.200
     0.306     6.559     0.200
     0.315     6.539     0.200
     0.365     7.258     0.200
     0.375     7.961     0.200
     0.412     7.938     0.200
     0.421     8.121     0.200
     0.406     7.969     0.200
     0.421     8.480     0.200
     0.432     8.230     0.200
     0.501     9.641     0.200
     0.506    10.199     0.200
     0.519    10.238     0.200
     0.529    10.270     0.200
     0.560    10.480     0.200
     0.588    11.461     0.200
     0.605    11.391     0.200
     0.605    11.277     0.200
     0.633    12.551     0.200
     0.653    12.711     0.200
     0.685    13.129     0.200
     0.719    13.121     0.200
     0.726    13.230     0.200
     0.724    13.930     0.200
     0.732    14.000     0.200
     0.742    13.969     0.200
     0.757    13.961     0.200
     0.762    13.910     0.200
     0.775    14.520     0.200
     0.792    14.641     0.200
     0.799    15.188     0.200
     0.793    14.391     0.200
     0.792    14.840     0.200
     0.856    15.988     0.200
     0.872    16.109     0.200
     0.863    16.430     0.200
     0.926    16.488     0.200
     0.957    17.859     0.200
     1.005    18.391     0.200
     0.993    18.078     0.200
     1.034    19.328     0.200
     1.028    18.531     0.200
     1.130    20.000     0.200
     1.280    22.508     0.200
     1.313    24.531     0.200
     5.445    91.137     0.200
     0.162     3.768     0.200
     0.169     3.758     0.200
     0.185     4.068     0.200
     0.134     3.378     0.200
     0.162     3.368     0.200
     0.209     4.508     0.200
     0.165     3.998     0.200
     0.195     4.398     0.200
     0.314     6.152     0.200
     0.406     8.508     0.200
     0.387     7.278     0.200
     0.366     7.758     0.200
     0.463     9.258     0.200
     0.501    10.038     0.200
     0.583    11.258     0.200
     0.617    12.328     0.200
     0.572    11.078     0.200
     0.574    11.398     0.200
     0.632    12.658     0.200
     0.648    12.998     0.200
     0.722    13.628     0.200
     0.677    13.088     0.200
     0.767    14.998     0.200
     0.776    14.518     0.200
     0.726    13.848     0.200
     0.820    15.218     0.200
     0.954    17.828     0.200
     1.207    22.398     0.200
     1.708    29.748     0.200
     1.735    30.438     0.200
     0.126     3.260     0.200
     0.193     3.899     0.200
     0.225     4.889     0.200
     0.324     7.149     0.200
     0.458     9.019     0.200
     0.465     9.399     0.200
     0.486     9.869     0.200
     0.565    10.969     0.200
     0.583    11.459     0.200
     0.608    11.739     0.200
     0.664    13.159     0.200
     0.675    13.029     0.200
     0.697    13.409     0.200
     0.760    14.399     0.200
     0.753    14.299     0.200
     0.779    14.609     0.200
     0.781    14.529     0.200
     0.787    14.969     0.200
     0.799    15.339     0.200
     0.809    15.089     0.200
     0.818    15.179     0.200
     0.814    15.099     0.200
     0.843    16.009     0.200
     0.861    16.559     0.200
     0.863    16.349     0.200
     0.878    16.319     0.200
     0.890    17.059     0.200
     0.902    16.949     0.200
     0.899    16.409     0.200
     0.908    16.779     0.200
     0.898    16.409     0.200
     0.902    17.239     0.200
     0.921    17.069     0.200
     0.973    17.439     0.200
     0.984    18.229     0.200
     0.989    17.859     0.200
     1.016    18.709     0.200
     1.066    18.679     0.200
     1.318    22.649     0.200
     0.081     2.059     0.200
     0.157     3.707     0.200
     0.212     4.469     0.200
     0.284     5.908     0.200
     0.294     6.338     0.200
     0.310     6.928     0.200
     0.279     5.168     0.200
     0.366     7.348     0.200
     0.414     8.148     0.200
     0.414     8.568     0.200
     0.438     8.828     0.200
     0.521    10.299     0.200
     0.488     9.697     0.200
     0.532    10.688     0.200
     0.545    10.318     0.200
     0.526    10.328     0.200
     0.517    10.248     0.200
     0.538    10.268     0.200
     0.554    10.809     0.200
     0.552    10.777     0.200
     0.593    11.178     0.200
     0.579    11.508     0.200
     0.592    10.988     0.200
     0.662    12.678     0.200
     0.671    12.488     0.200
     0.696    13.438     0.200
     0.690    12.658     0.200
     0.706    13.088     0.200
     0.773    14.207     0.200
     0.810    14.938     0.200
     0.810    14.828     0.200
     0.818    14.588     0.200
     0.851    15.559     0.200
     1.011    17.998     0.200
     1.047    19.668     0.200
     1.081    19.229     0.200
     1.115    19.639     0.200
     1.082    20.049     0.200
     1.211    21.049     0.200
     1.232    21.818     0.200
     1.459    27.088     0.200
     0.365     7.594     0.200
     0.378     7.922     0.200
     0.402     8.453     0.200
     0.424     8.633     0.200
     0.447     8.281     0.200
     0.492     9.234     0.200
     0.492     8.977     0.200
     0.513    10.094     0.200
     0.526    10.516     0.200
     0.558    10.461     0.200
     0.565    11.016     0.200
     0.620    11.875     0.200
     0.651    11.445     0.200
     0.629    11.734     0.200
     0.634    11.516     0.200
     0.659    12.422     0.200
     0.675    12.227     0.200
     0.662    12.164     0.200
     0.679    12.656     0.200
     0.686    13.383     0.200
     0.691    12.664     0.200
     0.693    12.664     0.200
     0.693    12.547     0.200
     0.717    13.406     0.200
     0.726    13.656     0.200
     0.752    13.531     0.200
     0.747    13.914     0.200
     0.768    13.688     0.200
     0.778    14.016     0.200
     0.782    14.602     0.200
     0.785    14.258     0.200
     0.810    15.023     0.200
     0.852    14.492     0.200
     0.846    15.352     0.200
     0.875    15.578     0.200
     0.875    15.141     0.200
     0.895    16.203     0.200
     0.899    16.047     0.200
     0.913    15.812     0.200
     0.974    17.375     0.200
     0.971    17.242     0.200
     0.999    16.906     0.200
     1.018    18.445     0.200
     2.142    37.141     0.200
     7.731   126.711     0.200
     0.092     2.809     0.200
     0.102     2.379     0.200
     0.114     2.961     0.200
     0.104     2.980     0.200
     0.153     3.250     0.200
     0.179     3.750     0.200
     0.229     5.059     0.200
     0.248     5.449     0.200
     0.324     6.270     0.200
     0.381     7.910     0.200
     0.435     8.879     0.200
     0.448     8.781     0.200
     0.507    10.641     0.200
     0.590    11.418     0.200
     0.637    11.621     0.200
     0.676    13.109     0.200
     0.682    12.418     0.200
     0.712    13.531     0.200
     0.715    13.430     0.200
     0.772    14.020     0.200
     0.775    14.820     0.200
     0.780    15.039     0.200
     0.803    14.719     0.200
     0.826    15.738     0.200
     0.831    15.879     0.200
     0.909    15.871     0.200
     0.993    17.719     0.200
     0.104     2.148     0.200
     0.106     1.480     0.200
     0.113     2.770     0.200
     0.172     3.340     0.200
     0.162     3.129     0.200
     0.163     4.391     0.200
     0.240     4.930     0.200
     0.315     6.602     0.200
     0.373     7.430     0.200
     0.401     8.109     0.200
     0.394     8.039     0.200
     0.423     8.172     0.200
     0.457     8.691     0.200
     0.444     8.801     0.200
     0.459     8.809     0.200
     0.457     9.070     0.200
     0.463     9.121     0.200
     0.512     9.828     0.200
     0.602    11.359     0.200
     0.610    12.238     0.200
     0.590    11.738     0.200
     0.630    12.141     0.200
     0.628    11.879     0.200
     0.687    12.910     0.200
     0.681    13.070     0.200
     0.717    14.121     0.200
     0.712    15.500     0.200
     0.716    14.000     0.200
     0.719    13.867     0.200
     0.719    14.148     0.200
     0.719    13.980     0.200
     0.770    13.730     0.200
     0.761    14.551     0.200
     0.798    15.129     0.200
     0.783    15.320     0.200
     0.782    14.828     0.200
     0.784    14.828     0.200
     0.809    15.391     0.200
     0.829    16.180     0.200
     0.833    16.129     0.200
     0.899    16.941     0.200
     0.911    17.121     0.200
     0.967    18.250     0.200
     0.987    18.469     0.200
     1.020    19.039     0.200
     0.090     2.219     0.200
     0.102     1.809     0.200
     0.101     2.891     0.200
     0.112     2.969     0.200
     0.154     3.309     0.200
     0.174     4.359     0.200
     0.237     5.359     0.200
     0.243     5.621     0.200
     0.318     6.441     0.200
     0.321     6.379     0.200
     0.371     7.738     0.200
     0.405     8.512     0.200
     0.408     8.379     0.200
     0.433     8.570     0.200
     0.449     8.980     0.200
     0.445     9.020     0.200
     0.448     8.801     0.200
     0.454     9.059     0.200
     0.470     9.539     0.200
     0.468     9.500     0.200
     0.496     9.969     0.200
     0.496    10.160     0.200
     0.525    10.262     0.200
     0.605    11.391     0.200
     0.603    11.730     0.200
     0.609    12.121     0.200
     0.621    11.910     0.200
     0.635    11.941     0.200
     0.637    12.359     0.200
     0.668    12.410     0.200
     0.690    12.820     0.200
     0.726    14.301     0.200
     0.722    13.477     0.200
     0.729    13.820     0.200
     0.758    13.871     0.200
     0.774    14.770     0.200
     0.790    14.379     0.200
     0.798    15.039     0.200
     0.821    15.680     0.200
     0.840    16.000     0.200
     0.899    15.602     0.200
     0.914    17.051     0.200
     0.923    17.051     0.200
     0.996    17.922     0.200
     1.011    18.910     0.200
     1.030    18.328     0.200
     1.075    18.852     0.200
     1.092    19.609     0.200
     1.098    20.449     0.200
     1.111    19.738     0.200
     1.167    20.551     0.200
     1.165    20.539     0.200
     1.178    20.539     0.200
     1.243    21.820     0.200
     1.299    22.512     0.200
     1.657    31.238     0.200
     0.093     2.203     0.200
     0.078     2.570     0.200
     0.089     2.812     0.200
     0.124     4.078     0.200
     0.135     3.055     0.200
     0.188     3.898     0.200
     0.190     4.469     0.200
     0.236     5.531     0.200
     0.260     5.523     0.200
     0.338     6.883     0.200
     0.342     6.617     0.200
     0.395     8.094     0.200
     0.408     8.414     0.200
     0.427     8.898     0.200
     0.430     8.359     0.200
     0.450     8.680     0.200
     0.472     9.273     0.200
     0.445     9.312     0.200
     0.469     9.469     0.200
     0.519    10.484     0.200
     0.519    10.391     0.200
     0.516    10.219     0.200
     0.598    11.344     0.200
     0.640    12.094     0.200
     0.660    12.820     0.200
     0.655    12.188     0.200
     0.682    12.531     0.200
     0.673    12.664     0.200
     0.713    13.320     0.200
     0.714    13.578     0.200
     0.714    13.422     0.200
     0.769    13.969     0.200
     0.761    14.773     0.200
     0.775    14.844     0.200
     0.809    14.805     0.200
     0.782    14.617     0.200
     0.922    15.891     0.200
     1.009    17.688     0.200
     1.075    19.031     0.200
     1.287    22.188     0.200
     2.661    46.219     0.200
     0.140     3.723     0.200
     0.302     5.840     0.200
     0.339     6.641     0.200
     0.340     6.660     0.200
     0.346     6.773     0.200
     0.356     7.152     0.200
     0.344     7.301     0.200
     0.352     7.191     0.200
     0.347     6.801     0.200
     0.424     8.453     0.200
     0.431     8.633     0.200
     0.457     9.012     0.200
     0.470     9.320     0.200
     0.459     9.332     0.200
     0.481     9.473     0.200
     0.475     9.730     0.200
     0.504     9.941     0.200
     0.501    10.062     0.200
     0.524    10.273     0.200
     0.526    10.531     0.200
     0.526    10.523     0.200
     0.549    10.871     0.200
     0.581    11.402     0.200
     0.588    11.910     0.200
     0.592    11.762     0.200
     0.623    12.133     0.200
     0.687    13.070     0.200
     0.680    13.000     0.200
     0.704    13.762     0.200
     0.741    14.250     0.200
     0.756    14.652     0.200
     0.774    14.980     0.200
     0.762    14.711     0.200
     0.801    15.562     0.200
     0.814    15.883     0.200
     0.803    15.293     0.200
     0.844    15.723     0.200
     0.849    16.273     0.200
     0.880    16.812     0.200
     0.880    16.641     0.200
     0.898    16.941     0.200
     0.975    18.512     0.200
     1.047    19.242     0.200
     1.048    19.352     0.200
     1.039    19.340     0.200
     1.038    20.160     0.200
     1.043    20.102     0.200
     1.071    19.902     0.200
     1.075    20.211     0.200
     1.094    20.500     0.200
     1.122    20.301     0.200
     1.124    20.023     0.200
     1.124    21.191     0.200
     1.164    21.023     0.200
     1.145    21.672     0.200
     1.169    22.051     0.200
     1.285    23.461     0.200
     1.293    24.273     0.200
     1.320    23.570     0.200
     1.322    24.480     0.200
     0.122     3.516     0.200
     0.206     4.492     0.200
     0.276     6.234     0.200
     0.316     6.094     0.200
     0.307     6.523     0.200
     0.323     6.773     0.200
     0.333     7.297     0.200
     0.355     7.055     0.200
     0.345     7.086     0.200
     0.395     8.266     0.200
     0.410     7.953     0.200
     0.445     8.656     0.200
     0.480     9.125     0.200
     0.533     9.867     0.200
     0.606    11.594     0.200
     0.581    11.094     0.200
     0.597    11.492     0.200
     0.619    11.758     0.200
     0.660    12.836     0.200
     0.677    12.656     0.200
     0.686    12.852     0.200
     0.716    13.273     0.200
     0.817    14.586     0.200
     0.881    15.836     0.200
     0.907    16.867     0.200
     0.910    15.883     0.200
     0.910    16.797     0.200
     0.947    17.031     0.200
     0.982    18.258     0.200
     0.994    18.891     0.200
     1.006    18.273     0.200
     1.144    21.094     0.200
     1.172    21.508     0.200
     0.031     0.625     0.200
     0.163     3.617     0.200
     0.197     4.422     0.200
     0.208     4.445     0.200
     0.216     5.117     0.200
     0.317     6.562     0.200
     0.312     6.273     0.200
     0.348     7.312     0.200
     0.342     7.023     0.200
     0.385     8.156     0.200
     0.453     8.625     0.200
     0.488     9.086     0.200
     0.538     9.977     0.200
     0.587    11.469     0.200
     0.614    11.844     0.200
     0.608    11.695     0.200
     0.647    12.656     0.200
     0.654    12.562     0.200
     0.690    12.266     0.200
     0.674    12.805     0.200
     0.709    13.422     0.200
     0.897    16.805     0.200
     0.900    16.062     0.200
     0.900    16.695     0.200
     0.971    18.242     0.200
     0.993    18.227     0.200
     1.080    19.953     0.200
     1.090    19.883     0.200
     1.121    20.945     0.200
     1.140    21.258     0.200
     1.161    21.664     0.200
     0.024     0.961     0.200
     0.157     3.648     0.200
     0.199     4.219     0.200
     0.212     4.586     0.200
     0.230     5.320     0.200
     0.238     5.234     0.200
     0.281     6.328     0.200
     0.315     6.688     0.200
     0.309     5.914     0.200
     0.351     7.180     0.200
     0.347     6.859     0.200
     0.392     8.164     0.200
     0.418     8.094     0.200
     0.446     8.750     0.200
     0.494     9.867     0.200
     0.488     9.219     0.200
     0.532     9.914     0.200
     0.604    11.727     0.200
     0.611    11.789     0.200
     0.607    11.461     0.200
     0.652    12.609     0.200
     0.660    12.688     0.200
     0.681    13.000     0.200
     0.683    12.477     0.200
     0.716    13.016     0.200
     0.821    15.039     0.200
     0.878    15.656     0.200
     0.889    16.070     0.200
     0.904    16.508     0.200
     0.907    16.430     0.200
     0.975    17.547     0.200
     0.976    17.930     0.200
     1.001    18.094     0.200
     0.999    18.141     0.200
     1.078    19.586     0.200
     1.084    19.359     0.200
     1.097    19.484     0.200
     1.087    19.078     0.200
     1.127    20.438     0.200
     1.161    20.805     0.200
     1.138    21.086     0.200
     1.164    21.531     0.200
     1.204    21.336     0.200
     1.206    21.547     0.200
     1.741    32.141     0.200
     0.024     1.000     0.200
     0.195     4.227     0.200
     0.193     4.945     0.200
     0.208     4.438     0.200
     0.226     5.266     0.200
     0.223     4.914     0.200
     0.280     6.438     0.200
     0.311     6.594     0.200
     0.314     5.938     0.200
     0.329     7.227     0.200
     0.347     7.047     0.200
     0.414     8.016     0.200
     0.392     8.023     0.200
     0.484     9.156     0.200
     0.492     9.750     0.200
     0.534     9.859     0.200
     0.608    11.445     0.200
     0.615    11.719     0.200
     0.682    12.453     0.200
     0.714    13.258     0.200
     0.821    14.617     0.200
     0.878    15.914     0.200
     0.907    16.586     0.200
     0.971    17.555     0.200
     1.000    17.914     0.200
     1.001    18.008     0.200
     1.084    19.367     0.200
     0.030     3.187     0.200
     0.113     3.377     0.200
     0.160     3.767     0.200
     0.188     4.987     0.200
     0.206     4.517     0.200
     0.219     4.977     0.200
     0.286     6.397     0.200
     0.345     7.047     0.200
     0.313     6.837     0.200
     0.323     6.947     0.200
     0.345     6.907     0.200
     0.385     8.037     0.200
     0.417     8.057     0.200
     0.485     9.217     0.200
     0.600    11.687     0.200
     0.611    11.807     0.200
     0.687    12.267     0.200
     0.708    13.087     0.200
     0.827    14.987     0.200
     0.872    15.527     0.200
     0.877    15.297     0.200
     0.893    17.884     0.200
     0.901    16.107     0.200
     0.901    16.247     0.200
     0.969    17.447     0.200
     0.970    17.777     0.200
     0.994    17.877     0.200
     0.996    17.887     0.200
     1.087    19.137     0.200
     1.143    19.827     0.200
     0.170     4.060     0.200
     0.207     4.530     0.200
     0.211     4.810     0.200
     0.234     5.500     0.200
     0.303     6.620     0.200
     0.295     6.580     0.200
     0.314     6.760     0.200
     0.321     6.830     0.200
     0.313     5.890     0.200
     0.347     7.330     0.200
     0.336     6.720     0.200
     0.378     7.910     0.200
     0.425     8.230     0.200
     0.460     8.850     0.200
     0.490     9.340     0.200
     0.544     9.990     0.200
     0.604    11.590     0.200
     0.622    11.550     0.200
     0.667    12.660     0.200
     0.702    13.090     0.200
     0.697    12.280     0.200
     0.836    15.040     0.200
     0.863    15.460     0.200
     0.892    16.524     0.200
     0.892    16.000     0.200
     0.019     1.287     0.200
     0.149     3.657     0.200
     0.207     4.707     0.200
     0.223     5.237     0.200
     0.231     5.117     0.200
     0.228     5.157     0.200
     0.274     6.157     0.200
     0.307     6.577     0.200
     0.315     6.097     0.200
     0.324     6.997     0.200
     0.347     6.807     0.200
     0.334     7.187     0.200
     0.355     7.157     0.200
     0.397     8.247     0.200
     0.410     7.947     0.200
     0.443     8.606     0.200
     0.481     9.197     0.200
     0.495     9.856     0.200
     0.531     9.816     0.200
     0.582    11.106     0.200
     0.598    11.597     0.200
     0.603    11.327     0.200
     0.619    12.007     0.200
     0.660    12.847     0.200
     0.676    12.157     0.200
     0.668    12.626     0.200
     0.688    12.967     0.200
     0.718    13.336     0.200
     0.836    14.997     0.200
     0.890    16.237     0.200
     0.883    15.617     0.200
     0.904    15.979     0.200
     0.909    16.047     0.200
     0.912    15.801     0.200
     0.912    16.617     0.200
     0.972    17.747     0.200
     1.007    17.997     0.200
     1.080    19.086     0.200
     1.597    29.737     0.200
     0.037     1.382     0.200
     0.102     3.142     0.200
     0.170     4.102     0.200
     0.186     4.911     0.200
     0.202     4.382     0.200
     0.213     4.571     0.200
     0.239     5.521     0.200
     0.251     5.481     0.200
     0.295     6.571     0.200
     0.303     6.571     0.200
     0.313     6.731     0.200
     0.324     6.901     0.200
     0.307     5.911     0.200
     0.335     6.731     0.200
     0.352     7.182     0.200
     0.381     8.012     0.200
     0.428     8.291     0.200
     0.456     8.892     0.200
     0.486     9.711     0.200
     0.495     9.451     0.200
     0.539    10.021     0.200
     0.592    11.281     0.200
     0.609    11.882     0.200
     0.600    11.642     0.200
     0.618    11.592     0.200
     0.647    12.291     0.200
     0.667    12.632     0.200
     0.707    13.191     0.200
     0.697    12.531     0.200
     0.830    15.382     0.200
     0.834    14.802     0.200
     0.866    15.481     0.200
     0.881    16.262     0.200
     0.888    15.901     0.200
     0.892    16.151     0.200
     0.895    16.320     0.200
     0.895    16.132     0.200
     0.885    15.281     0.200
     0.935    16.961     0.200
     0.970    17.571     0.200
     0.975    17.451     0.200
     0.982    17.722     0.200
     0.990    17.932     0.200
     0.986    17.781     0.200
     1.054    18.571     0.200
     1.068    18.861     0.200
     1.084    19.222     0.200
     1.089    19.432     0.200
     1.098    19.401     0.200
     1.098    19.182     0.200
     1.122    19.632     0.200
     1.135    21.762     0.200
     1.165    20.661     0.200
     1.154    21.441     0.200
     1.193    20.671     0.200
     1.203    21.432     0.200
     1.261    21.671     0.200
     1.308    22.182     0.200
     1.316    22.392     0.200
     1.363    23.132     0.200
     1.737    31.941     0.200
     0.030     2.559     0.200
     0.167     3.879     0.200
     0.213     4.617     0.200
     0.225     4.797     0.200
     0.245     5.648     0.200
     0.288     6.270     0.200
     0.295     5.609     0.200
     0.309     6.637     0.200
     0.318     6.809     0.200
     0.329     6.957     0.200
     0.336     6.668     0.200
     0.365     7.367     0.200
     0.393     8.277     0.200
     0.432     8.316     0.200
     0.443     8.668     0.200
     0.500     9.969     0.200
     0.503     9.617     0.200
     0.525     9.789     0.200
     0.570    11.238     0.200
     0.603    11.469     0.200
     0.598    11.496     0.200
     0.606    11.398     0.200
     0.641    12.336     0.200
     0.652    12.406     0.200
     0.675    12.617     0.200
     0.691    12.906     0.200
     0.721    13.367     0.200
     0.845    15.547     0.200
     0.877    15.859     0.200
     0.896    16.348     0.200
     0.904    16.418     0.200
     0.907    16.492     0.200
     0.988    17.688     0.200
     0.991    17.648     0.200
     1.003    18.219     0.200
     1.136    19.887     0.200
     0.167     3.961     0.200
     0.224     4.852     0.200
     0.243     5.359     0.200
     0.244     5.648     0.200
     0.288     6.430     0.200
     0.296     5.730     0.200
     0.308     6.711     0.200
     0.318     6.852     0.200
     0.336     6.719     0.200
     0.364     7.352     0.200
     0.393     8.230     0.200
     0.431     8.352     0.200
     0.444     8.672     0.200
     0.502     9.551     0.200
     0.499     9.961     0.200
     0.525     9.801     0.200
     0.602    11.512     0.200
     0.598    11.500     0.200
     0.606    11.410     0.200
     0.618    11.891     0.200
     0.675    12.891     0.200
     0.691    12.379     0.200
     0.720    13.379     0.200
     0.825    14.590     0.200
     0.876    15.770     0.200
     0.907    16.328     0.200
     0.991    17.602     0.200
     1.101    19.230     0.200
     1.150    19.840     0.200
     1.727    31.770     0.200
     0.027     1.352     0.200
     0.164     3.945     0.200
     0.210     4.570     0.200
     0.222     4.867     0.200
     0.240     5.336     0.200
     0.241     5.531     0.200
     0.200     5.195     0.200
     0.212     4.922     0.200
     0.285     6.336     0.200
     0.325     6.922     0.200
     0.299     5.852     0.200
     0.362     7.344     0.200
     0.340     6.852     0.200
     0.428     8.266     0.200
     0.394     8.086     0.200
     0.443     8.672     0.200
     0.499     9.383     0.200
     0.499     9.953     0.200
     0.526     9.812     0.200
     0.599    11.586     0.200
     0.569    11.195     0.200
     0.605    11.391     0.200
     0.615    12.062     0.200
     0.602    11.742     0.200
     0.688    12.617     0.200
     0.644    12.516     0.200
     0.655    12.516     0.200
     0.677    12.695     0.200
     0.721    13.250     0.200
     0.843    15.453     0.200
     0.895    16.211     0.200
     0.878    15.664     0.200
     0.905    16.367     0.200
     0.908    16.312     0.200
     0.908    16.203     0.200
     0.985    17.438     0.200
     0.994    17.641     0.200
     1.097    19.133     0.200
     1.496    26.188     0.200
     1.675    29.047     0.200
     0.021     1.617     0.200
     0.130     3.328     0.200
     0.185     4.234     0.200
     0.199     4.453     0.200
     0.206     5.305     0.200
     0.205     4.969     0.200
     0.215     4.914     0.200
     0.249     5.688     0.200
     0.257     5.953     0.200
     0.327     6.438     0.200
     0.338     7.000     0.200
     0.353     7.680     0.200
     0.375     7.477     0.200
     0.390     7.609     0.200
     0.409     8.539     0.200
     0.435     8.523     0.200
     0.465     8.906     0.200
     0.501    10.062     0.200
     0.528     9.805     0.200
     0.571    11.266     0.200
     0.569    10.875     0.200
     0.639    12.414     0.200
     0.657    12.188     0.200
     0.680    13.086     0.200
     0.687    13.016     0.200
     0.725    13.312     0.200
     0.800    14.906     0.200
     0.894    16.305     0.200
     0.897    15.867     0.200
     0.922    16.914     0.200
     0.925    16.547     0.200
     0.925    16.438     0.200
     0.965    17.438     0.200
     1.016    18.188     0.200
     1.026    18.344     0.200
     1.060    18.789     0.200
     1.126    19.984     0.200
     1.144    20.312     0.200
     1.617    28.984     0.200
     0.050     1.734     0.200
     0.081     4.844     0.200
     0.203     4.148     0.200
     0.245     4.562     0.200
     0.338     7.273     0.200
     0.309     6.234     0.200
     0.313     6.289     0.200
     0.301     6.539     0.200
     0.368     7.867     0.200
     0.364     7.453     0.200
     0.414     8.711     0.200
     0.467     9.117     0.200
     0.488     9.719     0.200
     0.528    10.398     0.200
     0.561    11.070     0.200
     0.520    10.219     0.200
     0.562    10.484     0.200
     0.618    11.562     0.200
     0.694    12.992     0.200
     0.660    12.164     0.200
     0.724    13.891     0.200
     0.793    14.438     0.200
     0.832    15.188     0.200
     0.819    14.320     0.200
     0.932    16.664     0.200
     1.046    18.469     0.200
     1.231    21.281     0.200
     1.580    29.133     0.200
     1.634    29.180     0.200
     0.017     1.711     0.200
     0.067     1.773     0.200
     0.143     3.531     0.200
     0.224     4.633     0.200
     0.281     6.203     0.200
     0.273     5.055     0.200
     0.277     5.742     0.200
     0.280     5.820     0.200
     0.352     7.211     0.200
     0.400     8.383     0.200
     0.412     8.297     0.200
     0.464     9.359     0.200
     0.496     9.570     0.200
     0.523    10.109     0.200
     0.535    10.109     0.200
     0.529    10.414     0.200
     0.587    11.055     0.200
     0.567    11.156     0.200
     0.679    12.500     0.200
     0.673    12.609     0.200
     0.691    13.375     0.200
     0.804    14.180     0.200
     0.824    14.719     0.200
     0.824    15.242     0.200
     0.878    16.391     0.200
     0.929    17.312     0.200
     1.080    20.516     0.200
     0.231     4.773     0.200
     0.236     5.104     0.200
     0.269     5.635     0.200
     0.273     6.293     0.200
     0.306     6.123     0.200
     0.293     6.074     0.200
     0.313     6.434     0.200
     0.336     7.074     0.200
     0.341     6.773     0.200
     0.352     7.805     0.200
     0.419     8.184     0.200
     0.429     8.713     0.200
     0.449     9.123     0.200
     0.454     8.867     0.200
     0.456     8.873     0.200
     0.457     8.904     0.200
     0.472     9.225     0.200
     0.458     9.135     0.200
     0.502    10.395     0.200
     0.503     9.885     0.200
     0.539    10.594     0.200
     0.534    10.443     0.200
     0.603    11.904     0.200
     0.626    12.574     0.200
     0.627    12.494     0.200
     0.636    12.385     0.200
     0.652    12.873     0.200
     0.681    13.023     0.200
     0.671    13.314     0.200
     0.673    12.934     0.200
     0.690    13.363     0.200
     0.683    13.363     0.200
     0.697    13.555     0.200
     0.735    14.395     0.200
     0.773    14.094     0.200
     0.775    14.873     0.200
     0.801    15.373     0.200
     0.791    15.414     0.200
     0.809    15.043     0.200
     0.820    16.064     0.200
     0.823    15.334     0.200
     0.831    16.504     0.200
     0.842    16.305     0.200
     0.839    16.293     0.200
     0.895    16.623     0.200
     0.910    17.234     0.200
     0.933    17.924     0.200
     0.984    18.293     0.200
     0.979    18.805     0.200
     1.008    18.623     0.200
     0.229     5.102     0.200
     0.233     5.297     0.200
     0.391     8.102     0.200
     0.440     8.711     0.200
     0.437     8.320     0.200
     0.450     8.852     0.200
     0.453     8.969     0.200
     0.495     8.961     0.200
     0.498     9.039     0.200
     0.506     9.547     0.200
     0.541     9.836     0.200
     0.499    10.047     0.200
     0.566    11.141     0.200
     0.586    11.438     0.200
     0.639    11.789     0.200
     0.652    12.320     0.200
     0.648    11.852     0.200
     0.654    11.992     0.200
     0.659    12.078     0.200
     0.656    12.031     0.200
     0.672    12.070     0.200
     0.651    11.859     0.200
     0.667    12.719     0.200
     0.704    12.992     0.200
     0.711    13.586     0.200
     0.733    13.445     0.200
     0.760    14.016     0.200
     0.788    14.758     0.200
     0.729    14.398     0.200
     0.800    15.086     0.200
     0.827    14.859     0.200
     0.839    14.859     0.200
     0.855    15.508     0.200
     0.859    15.789     0.200
     0.895    15.766     0.200
     0.912    16.555     0.200
     0.912    16.797     0.200
     0.912    16.969     0.200
     0.923    16.469     0.200
     0.936    17.031     0.200
     0.916    17.102     0.200
     0.940    17.047     0.200
     0.968    17.547     0.200
     0.955    18.398     0.200
     0.955    18.906     0.200
     1.097    19.789     0.200
     1.019    19.898     0.200
     1.143    19.625     0.200
     1.123    19.617     0.200
     1.172    20.289     0.200
     1.192    20.555     0.200
     1.155    20.328     0.200
     1.145    20.906     0.200
     1.247    22.695     0.200
     1.276    21.625     0.200
     1.277    22.758     0.200
     1.281    22.156     0.200
     0.011     0.328     0.200
     0.011     1.148     0.200
     0.071     1.750     0.200
     0.095     2.352     0.200
     0.112     2.609     0.200
     0.151     3.648     0.200
     0.194     4.578     0.200
     0.203     4.758     0.200
     0.215     4.441     0.200
     0.262     4.898     0.200
     0.288     6.391     0.200
     0.289     5.871     0.200
     0.293     6.008     0.200
     0.328     7.238     0.200
     0.425     8.410     0.200
     0.485     9.430     0.200
     0.468     9.500     0.200
     0.520    10.168     0.200
     0.574    10.730     0.200
     0.535    10.551     0.200
     0.545    10.309     0.200
     0.568    10.969     0.200
     0.599    11.102     0.200
     0.647    12.590     0.200
     0.605    11.988     0.200
     0.672    12.148     0.200
     0.611    11.770     0.200
     0.626    12.102     0.200
     0.690    12.980     0.200
     0.644    11.871     0.200
     0.706    13.379     0.200
     0.680    12.820     0.200
     0.681    12.770     0.200
     0.705    13.641     0.200
     0.703    13.570     0.200
     0.774    14.039     0.200
     0.725    13.398     0.200
     0.760    14.500     0.200
     0.808    14.180     0.200
     0.794    14.801     0.200
     0.789    14.418     0.200
     0.813    15.418     0.200
     0.826    15.270     0.200
     0.835    15.648     0.200
     0.854    15.930     0.200
     0.873    16.250     0.200
     0.869    16.141     0.200
     0.885    16.441     0.200
     0.885    16.410     0.200
     0.893    16.531     0.200
     0.898    16.371     0.200
     0.907    16.879     0.200
     0.914    16.602     0.200
     0.933    17.320     0.200
     0.935    17.199     0.200
     1.009    17.961     0.200
     1.068    19.488     0.200
     1.068    20.539     0.200
     1.026    18.020     0.200
     1.133    19.820     0.200
     1.451    20.941     0.200
     1.323    25.168     0.200
     1.390    23.758     0.200
     1.606    27.801     0.200
     0.007     1.305     0.200
     0.069     3.891     0.200
     0.112     2.539     0.200
     0.099     2.391     0.200
     0.195     4.438     0.200
     0.204     4.836     0.200
     0.285     5.648     0.200
     0.286     6.227     0.200
     0.289     5.695     0.200
     0.346     7.328     0.200
     0.326     7.258     0.200
     0.355     7.336     0.200
     0.403     8.289     0.200
     0.367     7.734     0.200
     0.421     8.195     0.200
     0.432     9.125     0.200
     0.488     8.922     0.200
     0.522    10.180     0.200
     0.542    10.047     0.200
     0.542    10.930     0.200
     0.536    10.602     0.200
     0.523    10.180     0.200
     0.537    10.648     0.200
     0.576    10.711     0.200
     0.565    10.984     0.200
     0.622    12.039     0.200
     0.609    11.961     0.200
     0.603    12.906     0.200
     0.647    12.406     0.200
     0.646    12.680     0.200
     0.643    11.898     0.200
     0.678    12.336     0.200
     0.674    12.289     0.200
     0.691    13.000     0.200
     0.699    13.508     0.200
     0.710    13.461     0.200
     0.775    13.977     0.200
     0.806    14.109     0.200
     0.788    14.484     0.200
     0.794    14.797     0.200
     0.811    15.227     0.200
     0.825    14.641     0.200
     0.852    15.766     0.200
     0.875    16.227     0.200
     0.932    16.906     0.200
     0.961    17.367     0.200
     1.212    20.945     0.200
     0.047     3.320     0.200
     0.048     1.328     0.200
     0.063     1.512     0.200
     0.110     4.441     0.200
     0.118     2.762     0.200
     0.150     3.410     0.200
     0.232     4.680     0.200
     0.222     5.211     0.200
     0.251     5.520     0.200
     0.260     5.301     0.200
     0.297     6.371     0.200
     0.332     6.949     0.200
     0.332     6.781     0.200
     0.369     7.250     0.200
     0.376     8.180     0.200
     0.388     8.102     0.200
     0.391     8.590     0.200
     0.434     8.828     0.200
     0.500     9.941     0.200
     0.495     9.289     0.200
     0.508    10.129     0.200
     0.512     9.852     0.200
     0.523    10.129     0.200
     0.537    10.969     0.200
     0.538    10.262     0.200
     0.579    11.398     0.200
     0.566    11.012     0.200
     0.566    11.070     0.200
     0.594    11.379     0.200
     0.586    11.320     0.200
     0.591    10.961     0.200
     0.617    13.090     0.200
     0.623    11.641     0.200
     0.628    12.230     0.200
     0.621    12.469     0.200
     0.647    12.051     0.200
     0.655    12.309     0.200
     0.660    12.988     0.200
     0.638    12.281     0.200
     0.664    13.051     0.200
     0.647    12.648     0.200
     0.689    12.801     0.200
     0.697    12.391     0.200
     0.752    14.270     0.200
     0.759    14.469     0.200
     0.777    13.262     0.200
     0.790    14.281     0.200
     0.786    14.070     0.200
     0.823    14.629     0.200
     0.823    15.258     0.200
     0.853    15.719     0.200
     0.860    15.809     0.200
     0.896    16.520     0.200
     0.905    16.602     0.200
     0.920    16.891     0.200
     0.923    16.449     0.200
     0.913    16.230     0.200
     0.934    17.070     0.200
     0.936    17.051     0.200
     0.974    17.461     0.200
     1.003    18.059     0.200
     1.026    18.449     0.200
     1.018    18.199     0.200
     1.031    18.949     0.200
     1.037    18.668     0.200
     1.055    18.801     0.200
     1.086    19.680     0.200
     1.098    20.059     0.200
     1.112    19.859     0.200
     1.130    19.918     0.200
     1.153    20.160     0.200
     1.159    19.621     0.200
     1.183    19.770     0.200
     1.196    20.711     0.200
     1.222    21.168     0.200
     1.223    20.230     0.200
     1.263    21.609     0.200
     1.276    21.980     0.200
     1.287    21.660     0.200
     1.311    22.449     0.200
     1.324    22.648     0.200
     1.482    28.109     0.200
     1.509    27.320     0.200
     1.708    30.090     0.200
     1.711    31.410     0.200
     0.029     1.266     0.200
     0.051     1.449     0.200
     0.033     1.355     0.200
     0.098     2.406     0.200
     0.135     3.156     0.200
     0.220     5.188     0.200
     0.251     5.098     0.200
     0.286     5.488     0.200
     0.330     6.938     0.200
     0.322     6.488     0.200
     0.377     7.906     0.200
     0.399     8.406     0.200
     0.452     8.656     0.200
     0.506     9.117     0.200
     0.483     9.836     0.200
     0.519     9.996     0.200
     0.531    10.078     0.200
     0.525     9.887     0.200
     0.540    10.586     0.200
     0.524     9.738     0.200
     0.556    10.766     0.200
     0.563    10.836     0.200
     0.599    11.105     0.200
     0.576    10.566     0.200
     0.608    11.316     0.200
     0.642    11.629     0.200
     0.642    11.777     0.200
     0.631    11.617     0.200
     0.620    12.277     0.200
     0.624    12.266     0.200
     0.664    12.406     0.200
     0.655    11.938     0.200
     0.671    12.008     0.200
     0.680    12.918     0.200
     0.739    14.207     0.200
     0.778    13.828     0.200
     0.795    14.457     0.200
     0.806    14.707     0.200
     0.815    14.797     0.200
     0.799    13.977     0.200
     0.824    14.926     0.200
     0.799    14.926     0.200
     0.825    14.727     0.200
     0.813    14.656     0.200
     0.833    14.816     0.200
     0.833    15.148     0.200
     0.831    15.129     0.200
     0.833    14.629     0.200
     0.855    15.438     0.200
     0.873    15.527     0.200
     0.880    15.738     0.200
     0.884    16.008     0.200
     0.884    16.078     0.200
     0.904    16.426     0.200
     0.909    16.508     0.200
     0.897    16.188     0.200
     0.915    16.539     0.200
     0.909    16.578     0.200
     0.902    16.406     0.200
     0.924    16.398     0.200
     0.935    16.379     0.200
     0.951    17.129     0.200
     0.959    17.297     0.200
     0.946    16.828     0.200
     0.965    17.727     0.200
     0.995    17.926     0.200
     0.995    17.539     0.200
     1.007    17.828     0.200
     1.015    18.098     0.200
     1.022    18.086     0.200
     1.052    18.129     0.200
     1.112    18.957     0.200
     2.362    41.328     0.200
     0.026     1.305     0.200
     0.030     2.773     0.200
     0.053     1.500     0.200
     0.100     2.453     0.200
     0.122     3.055     0.200
     0.167     4.383     0.200
     0.258     5.250     0.200
     0.285     5.453     0.200
     0.314     6.773     0.200
     0.324     6.984     0.200
     0.324     6.641     0.200
     0.333     6.961     0.200
     0.391     7.727     0.200
     0.380     8.141     0.200
     0.385     8.117     0.200
     0.402     8.734     0.200
     0.452     9.133     0.200
     0.510     9.594     0.200
     0.521    10.414     0.200
     0.525    10.383     0.200
     0.515     9.922     0.200
     0.534    10.320     0.200
     0.521    10.172     0.200
     0.544    10.781     0.200
     0.562    10.430     0.200
     0.553    10.914     0.200
     0.560    10.945     0.200
     0.584    11.430     0.200
     0.577    10.711     0.200
     0.600    11.594     0.200
     0.607    11.586     0.200
     0.618    13.133     0.200
     0.621    12.273     0.200
     0.642    12.453     0.200
     0.645    12.125     0.200
     0.634    11.734     0.200
     0.653    12.195     0.200
     0.670    12.594     0.200
     0.681    13.211     0.200
     0.683    13.305     0.200
     0.667    12.875     0.200
     0.681    12.672     0.200
     0.681    12.445     0.200
     0.736    14.164     0.200
     0.762    14.391     0.200
     0.782    13.516     0.200
     0.774    13.852     0.200
     0.797    15.344     0.200
     0.797    14.594     0.200
     0.797    15.273     0.200
     0.806    15.047     0.200
     0.816    15.250     0.200
     0.810    15.055     0.200
     0.821    15.203     0.200
     0.831    15.211     0.200
     0.829    15.305     0.200
     0.831    15.352     0.200
     0.855    15.711     0.200
     0.855    15.703     0.200
     0.874    15.961     0.200
     0.882    16.492     0.200
     0.883    16.242     0.200
     0.883    16.266     0.200
     0.894    16.234     0.200
     0.903    16.562     0.200
     0.899    16.430     0.200
     0.906    16.977     0.200
     0.914    16.883     0.200
     0.922    16.703     0.200
     0.932    17.047     0.200
     0.934    17.133     0.200
     0.945    17.133     0.200
     0.951    17.242     0.200
     0.996    17.656     0.200
     1.014    18.195     0.200
     1.020    18.125     0.200
     1.043    18.586     0.200
     1.048    18.727     0.200
     1.046    18.617     0.200
     1.055    18.422     0.200
     1.052    18.836     0.200
     1.064    18.852     0.200
     1.064    18.891     0.200
     1.079    19.992     0.200
     1.108    20.031     0.200
     1.113    19.414     0.200
     1.112    19.547     0.200
     1.125    19.891     0.200
     1.198    20.695     0.200
     1.206    20.820     0.200
     1.213    20.117     0.200
     1.256    21.625     0.200
     1.266    21.625     0.200
     1.274    21.742     0.200
     1.295    22.125     0.200
     1.304    22.156     0.200
     1.326    22.547     0.200
     1.342    22.844     0.200
     0.030     1.452     0.200
     0.054     1.732     0.200
     0.101     2.622     0.200
     0.121     3.172     0.200
     0.135     3.252     0.200
     0.249     5.192     0.200
     0.217     5.112     0.200
     0.254     5.282     0.200
     0.227     5.162     0.200
     0.257     5.752     0.200
     0.250     5.192     0.200
     0.311     6.832     0.200
     0.289     5.462     0.200
     0.325     6.572     0.200
     0.333     6.872     0.200
     0.322     6.972     0.200
     0.379     8.102     0.200
     0.387     7.762     0.200
     0.400     8.642     0.200
     0.386     8.021     0.200
     0.449     9.092     0.200
     0.507     9.582     0.200
     0.480     9.752     0.200
     0.516     9.902     0.200
     0.530    10.382     0.200
     0.522    10.332     0.200
     0.542    10.632     0.200
     0.559    10.562     0.200
     0.524    10.242     0.200
     0.555    10.882     0.200
     0.561    10.862     0.200
     0.579    10.732     0.200
     0.596    11.542     0.200
     0.584    11.282     0.200
     0.605    11.542     0.200
     0.641    12.122     0.200
     0.618    12.352     0.200
     0.634    12.182     0.200
     0.621    12.052     0.200
     0.639    12.442     0.200
     0.668    12.552     0.200
     0.664    12.922     0.200
     0.677    12.892     0.200
     0.680    13.021     0.200
     0.684    12.472     0.200
     0.740    14.172     0.200
     0.781    13.771     0.200
     0.793    14.692     0.200
     0.776    13.812     0.200
     0.796    14.352     0.200
     0.818    15.082     0.200
     0.796    15.082     0.200
     0.822    15.172     0.200
     0.810    14.932     0.200
     0.830    15.192     0.200
     0.852    15.612     0.200
     0.870    15.852     0.200
     0.878    16.072     0.200
     0.894    16.092     0.200
     0.968    16.892     0.200
     0.993    17.632     0.200
     1.135    22.992     0.200
     1.195    20.672     0.200
     2.862    48.602     0.200
     0.029     1.492     0.200
     0.036     0.982     0.200
     0.093     5.111     0.200
     0.139     5.191     0.200
     0.271     5.441     0.200
     0.298     6.492     0.200
     0.291     6.352     0.200
     0.299     5.602     0.200
     0.343     7.371     0.200
     0.344     7.211     0.200
     0.363     7.291     0.200
     0.375     7.582     0.200
     0.400     7.893     0.200
     0.421     8.723     0.200
     0.430     8.951     0.200
     0.439     9.383     0.200
     0.439     8.941     0.200
     0.501    10.102     0.200
     0.495     9.541     0.200
     0.536    10.771     0.200
     0.541    10.121     0.200
     0.542    10.482     0.200
     0.519    10.102     0.200
     0.518    10.211     0.200
     0.553    10.521     0.200
     0.542    10.572     0.200
     0.585    10.932     0.200
     0.584    10.742     0.200
     0.574    10.992     0.200
     0.592    11.422     0.200
     0.577    11.723     0.200
     0.580    11.432     0.200
     0.611    11.781     0.200
     0.610    11.223     0.200
     0.613    11.361     0.200
     0.643    12.312     0.200
     0.659    12.361     0.200
     0.666    12.941     0.200
     0.669    12.951     0.200
     0.674    12.441     0.200
     0.684    13.242     0.200
     0.709    12.992     0.200
     0.721    13.332     0.200
     0.725    13.662     0.200
     0.738    14.002     0.200
     0.757    14.072     0.200
     0.769    14.252     0.200
     0.809    14.312     0.200
     0.852    15.482     0.200
     0.953    16.402     0.200
     0.978    17.371     0.200
     1.042    18.332     0.200
     1.145    19.922     0.200
     1.172    20.291     0.200
     1.222    21.082     0.200
     1.233    20.922     0.200
     1.320    22.492     0.200
     1.351    22.992     0.200
     1.475    26.512     0.200
     1.546    28.611     0.200
     2.208    38.512     0.200
     0.039     1.514     0.200
     0.054     1.664     0.200
     0.102     2.555     0.200
     0.115     3.014     0.200
     0.144     3.375     0.200
     0.223     5.164     0.200
     0.258     5.285     0.200
     0.240     4.994     0.200
     0.245     5.135     0.200
     0.250     5.625     0.200
     0.296     5.574     0.200
     0.302     6.674     0.200
     0.321     6.994     0.200
     0.324     6.635     0.200
     0.328     6.814     0.200
     0.378     7.555     0.200
     0.393     8.535     0.200
     0.444     9.035     0.200
     0.499     9.445     0.200
     0.509    10.135     0.200
     0.519    10.264     0.200
     0.533    10.344     0.200
     0.516     9.924     0.200
     0.522    10.184     0.200
     0.563    11.004     0.200
     0.567    10.904     0.200
     0.550    10.254     0.200
     0.589    11.404     0.200
     0.581    10.775     0.200
     0.590    11.404     0.200
     0.603    11.514     0.200
     0.621    12.705     0.200
     0.625    12.264     0.200
     0.637    12.395     0.200
     0.632    11.904     0.200
     0.632    12.135     0.200
     0.665    12.514     0.200
     0.671    12.934     0.200
     0.655    12.674     0.200
     0.682    12.605     0.200
     0.687    12.514     0.200
     0.748    14.234     0.200
     0.777    13.855     0.200
     0.775    13.615     0.200
     0.797    14.465     0.200
     0.785    14.805     0.200
     0.812    14.994     0.200
     0.814    15.125     0.200
     0.830    15.225     0.200
     0.848    15.605     0.200
     0.864    15.785     0.200
     0.870    15.885     0.200
     0.898    16.205     0.200
     0.908    16.504     0.200
     0.985    17.555     0.200
     1.104    19.404     0.200
     1.111    19.174     0.200
     1.193    20.795     0.200
     1.227    21.645     0.200
     1.505    26.234     0.200
     0.028     2.164     0.200
     0.031     2.805     0.200
     0.074     4.555     0.200
     0.140     3.594     0.200
     0.198     4.828     0.200
     0.235     4.828     0.200
     0.255     5.117     0.200
     0.257     5.156     0.200
     0.303     6.734     0.200
     0.275     6.094     0.200
     0.322     7.047     0.200
     0.366     7.617     0.200
     0.345     7.031     0.200
     0.353     7.328     0.200
     0.387     7.633     0.200
     0.399     8.477     0.200
     0.435     8.797     0.200
     0.460     9.523     0.200
     0.507    10.086     0.200
     0.521    10.508     0.200
     0.530    10.266     0.200
     0.520     9.688     0.200
     0.514    10.031     0.200
     0.542    10.516     0.200
     0.540    10.688     0.200
     0.564    10.914     0.200
     0.536    10.172     0.200
     0.566    10.484     0.200
     0.597    11.883     0.200
     0.622    12.055     0.200
     0.597    10.969     0.200
     0.651    12.328     0.200
     0.668    12.922     0.200
     0.668    12.844     0.200
     0.655    12.148     0.200
     0.703    12.938     0.200
     0.700    12.727     0.200
     0.775    14.094     0.200
     0.810    14.586     0.200
     0.800    13.914     0.200
     0.795    14.086     0.200
     0.987    17.312     0.200
     1.038    18.523     0.200
     1.097    19.164     0.200
     1.169    20.719     0.200
     1.179    20.023     0.200
     1.204    20.867     0.200
     1.213    21.844     0.200
     1.382    23.328     0.200
     1.484    26.578     0.200
     1.693    31.281     0.200
     0.042     1.794     0.200
     0.050     1.044     0.200
     0.111     2.504     0.200
     0.099     2.364     0.200
     0.163     4.124     0.200
     0.157     3.483     0.200
     0.183     4.304     0.200
     0.155     3.813     0.200
     0.165     4.054     0.200
     0.194     3.764     0.200
     0.287     5.813     0.200
     0.287     5.824     0.200
     0.280     6.174     0.200
     0.302     5.374     0.200
     0.324     6.964     0.200
     0.362     7.604     0.200
     0.412     8.204     0.200
     0.427     8.684     0.200
     0.441     9.144     0.200
     0.419     9.204     0.200
     0.496     9.794     0.200
     0.478     9.194     0.200
     0.499     9.914     0.200
     0.499     9.724     0.200
     0.523    10.313     0.200
     0.554    10.664     0.200
     0.561    10.504     0.200
     0.563    10.824     0.200
     0.569    10.834     0.200
     0.561    11.174     0.200
     0.595    11.834     0.200
     0.601    11.254     0.200
     0.622    11.523     0.200
     0.635    12.094     0.200
     0.672    12.634     0.200
     0.664    12.964     0.200
     0.671    12.974     0.200
     0.699    13.504     0.200
     0.712    13.424     0.200
     0.718    13.164     0.200
     0.733    13.974     0.200
     0.741    13.824     0.200
     0.750    14.304     0.200
     0.778    14.483     0.200
     0.776    14.534     0.200
     0.778    14.154     0.200
     0.822    14.504     0.200
     0.843    14.773     0.200
     0.832    15.154     0.200
     0.838    15.744     0.200
     0.872    16.014     0.200
     0.887    16.424     0.200
     0.885    16.733     0.200
     0.893    16.504     0.200
     0.919    17.014     0.200
     0.967    17.624     0.200
     0.963    17.634     0.200
     0.960    17.284     0.200
     0.999    17.904     0.200
     0.999    18.294     0.200
     1.020    18.404     0.200
     1.015    18.404     0.200
     1.043    18.733     0.200
     1.048    18.964     0.200
     1.040    19.324     0.200
     1.051    18.894     0.200
     1.063    19.483     0.200
     1.094    19.724     0.200
     1.094    20.634     0.200
     1.151    20.224     0.200
     1.161    20.844     0.200
     1.167    20.563     0.200
     1.263    21.394     0.200
     1.525    28.444     0.200
     1.673    31.284     0.200
     0.043     0.502     0.200
     0.051     0.762     0.200
     0.098     2.213     0.200
     0.113     2.543     0.200
     0.154     3.771     0.200
     0.158     3.533     0.200
     0.185     4.262     0.200
     0.192     3.902     0.200
     0.280     6.053     0.200
     0.289     5.822     0.200
     0.301     5.553     0.200
     0.320     6.893     0.200
     0.323     6.893     0.200
     0.363     7.732     0.200
     0.396     8.062     0.200
     0.413     8.162     0.200
     0.418     8.742     0.200
     0.427     8.682     0.200
     0.443     9.172     0.200
     0.461     9.783     0.200
     0.477     9.182     0.200
     0.496     9.863     0.200
     0.497     9.883     0.200
     0.497     9.752     0.200
     0.521    10.363     0.200
     0.555    10.762     0.200
     0.557    11.932     0.200
     0.563    10.863     0.200
     0.562    10.533     0.200
     0.560    11.521     0.200
     0.570    10.902     0.200
     0.596    11.562     0.200
     0.602    11.842     0.200
     0.602    11.252     0.200
     0.606    12.402     0.200
     0.623    11.592     0.200
     0.635    12.133     0.200
     0.664    12.963     0.200
     0.672    13.021     0.200
     0.673    12.633     0.200
     0.693    12.873     0.200
     0.700    13.512     0.200
     0.719    13.162     0.200
     0.736    14.262     0.200
     0.740    13.652     0.200
     0.732    13.893     0.200
     0.738    13.473     0.200
     0.748    14.283     0.200
     0.766    14.613     0.200
     0.770    13.232     0.200
     0.777    14.402     0.200
     0.775    14.482     0.200
     0.805    14.973     0.200
     0.810    15.133     0.200
     0.813    15.262     0.200
     0.824    15.463     0.200
     0.826    15.402     0.200
     0.823    14.662     0.200
     0.831    15.402     0.200
     0.836    15.793     0.200
     0.844    15.053     0.200
     0.865    15.953     0.200
     0.894    16.312     0.200
     0.958    17.293     0.200
     0.961    17.293     0.200
     0.973    17.482     0.200
     1.000    17.883     0.200
     1.264    21.012     0.200
     1.524    28.652     0.200
     1.671    31.262     0.200
     0.184     4.156     0.200
     0.165     3.906     0.200
     0.282     5.555     0.200
     0.282     5.625     0.200
     0.273     5.936     0.200
     0.309     5.516     0.200
     0.318     6.795     0.200
     0.322     6.875     0.200
     0.405     8.035     0.200
     0.419     8.416     0.200
     0.443     9.115     0.200
     0.458     9.625     0.200
     0.483     9.375     0.200
     0.488     9.586     0.200
     0.520    10.215     0.200
     0.547    10.555     0.200
     0.558    10.406     0.200
     0.574    11.195     0.200
     0.555    11.736     0.200
     0.556    10.756     0.200
     0.558    11.275     0.200
     0.596    11.246     0.200
     0.587    11.516     0.200
     0.595    11.445     0.200
     0.628    11.576     0.200
     0.628    11.926     0.200
     0.656    12.715     0.200
     0.666    12.756     0.200
     0.663    12.656     0.200
     0.696    13.285     0.200
     0.725    13.225     0.200
     0.693    13.875     0.200
     0.706    13.365     0.200
     0.742    13.686     0.200
     0.740    14.215     0.200
     0.736    13.875     0.200
     0.746    14.465     0.200
     0.765    14.580     0.200
     0.773    14.326     0.200
     0.773    14.445     0.200
     0.805    15.055     0.200
     0.844    15.635     0.200
     0.830    15.656     0.200
     0.837    15.715     0.200
     0.843    15.846     0.200
     0.859    16.145     0.200
     0.879    16.576     0.200
     0.930    17.416     0.200
     0.956    17.285     0.200
     0.961    17.506     0.200
     0.992    18.195     0.200
     0.992    18.055     0.200
     0.992    18.016     0.200
     1.012    18.535     0.200
     1.008    18.586     0.200
     1.025    19.236     0.200
     1.035    18.375     0.200
     1.048    19.176     0.200
     1.062    19.105     0.200
     1.070    19.115     0.200
     1.203    20.766     0.200
     1.269    21.225     0.200
     1.264    22.055     0.200
     1.349    23.145     0.200
     1.447    27.086     0.200
     1.525    28.305     0.200
     1.660    29.385     0.200
     1.646    29.625     0.200
     2.510    43.656     0.200
     0.047     1.439     0.200
     0.055     2.420     0.200
     0.114     2.670     0.200
     0.155     3.770     0.200
     0.166     3.900     0.200
     0.183     4.289     0.200
     0.198     3.980     0.200
     0.273     6.061     0.200
     0.281     5.699     0.200
     0.281     5.680     0.200
     0.317     6.789     0.200
     0.310     5.650     0.200
     0.323     6.910     0.200
     0.357     7.510     0.200
     0.404     8.061     0.200
     0.396     8.020     0.200
     0.419     8.590     0.200
     0.417     8.811     0.200
     0.442     9.180     0.200
     0.457     9.619     0.200
     0.488     9.789     0.200
     0.484     9.330     0.200
     0.499     9.840     0.200
     0.502     9.799     0.200
     0.521    10.299     0.200
     0.546    10.629     0.200
     0.557    10.439     0.200
     0.556    10.709     0.200
     0.555    11.670     0.200
     0.558    11.221     0.200
     0.586    11.400     0.200
     0.574    10.971     0.200
     0.595    11.609     0.200
     0.592    10.939     0.200
     0.627    11.900     0.200
     0.628    11.619     0.200
     0.655    12.670     0.200
     0.662    12.869     0.200
     0.665    12.561     0.200
     0.696    13.279     0.200
     0.706    13.391     0.200
     0.692    13.539     0.200
     0.726    13.369     0.200
     0.734    14.369     0.200
     0.737    13.379     0.200
     0.742    13.779     0.200
     0.747    14.430     0.200
     0.741    14.039     0.200
     0.759    14.430     0.200
     0.773    14.650     0.200
     0.771    14.529     0.200
     0.773    14.354     0.200
     0.786    14.811     0.200
     0.800    14.850     0.200
     0.804    15.100     0.200
     0.800    14.910     0.200
     0.815    15.250     0.200
     0.818    15.209     0.200
     0.828    14.709     0.200
     0.831    15.279     0.200
     0.843    14.299     0.200
     0.838    16.029     0.200
     0.844    16.209     0.200
     0.856    15.750     0.200
     0.859    16.199     0.200
     0.866    16.029     0.200
     0.885    16.240     0.200
     0.880    16.420     0.200
     0.879    16.090     0.200
     0.887    16.400     0.200
     0.911    16.730     0.200
     0.929    17.141     0.200
     0.961    17.500     0.200
     0.957    17.240     0.200
     0.991    18.141     0.200
     0.992    18.049     0.200
     0.992    17.930     0.200
     1.007    18.279     0.200
     1.006    18.109     0.200
     1.006    18.160     0.200
     1.025    18.650     0.200
     1.034    18.279     0.200
     1.039    18.580     0.200
     1.049    18.689     0.200
     1.046    19.160     0.200
     1.070    19.039     0.200
     1.063    18.980     0.200
     1.085    19.100     0.200
     1.103    19.590     0.200
     1.103    20.289     0.200
     1.131    19.600     0.200
     1.129    20.090     0.200
     1.151    20.119     0.200
     1.203    20.789     0.200
     1.214    21.010     0.200
     1.219    21.080     0.200
     1.263    21.641     0.200
     1.266    21.770     0.200
     1.269    20.990     0.200
     1.280    21.779     0.200
     1.307    22.410     0.200
     1.333    22.730     0.200
     1.681    31.299     0.200
     0.190     4.000     0.200
     0.299     6.320     0.200
     0.306     6.484     0.200
     0.307     6.234     0.200
     0.321     7.102     0.200
     0.322     7.219     0.200
     0.333     6.984     0.200
     0.346     7.141     0.200
     0.362     7.875     0.200
     0.378     7.781     0.200
     0.422     8.031     0.200
     0.422     8.328     0.200
     0.427     8.148     0.200
     0.430     8.219     0.200
     0.447     9.508     0.200
     0.471     9.070     0.200
     0.535    10.430     0.200
     0.544    10.227     0.200
     0.551    11.000     0.200
     0.580    11.750     0.200
     0.586    11.141     0.200
     0.589    11.398     0.200
     0.667    12.328     0.200
     0.677    12.695     0.200
     0.715    13.367     0.200
     0.718    13.219     0.200
     0.721    13.797     0.200
     0.736    13.930     0.200
     0.743    14.234     0.200
     0.744    13.898     0.200
     0.818    15.195     0.200
     0.812    15.500     0.200
     0.828    15.352     0.200
     0.839    15.805     0.200
     0.858    15.719     0.200
     0.884    16.297     0.200
     0.893    16.852     0.200
     0.921    16.984     0.200
     0.918    17.289     0.200
     0.952    17.047     0.200
     0.950    17.648     0.200
     0.966    17.828     0.200
     0.976    17.891     0.200
     0.999    18.758     0.200
     1.006    18.266     0.200
     1.024    18.852     0.200
     1.048    19.156     0.200
     1.100    20.148     0.200
     1.352    23.156     0.200
     1.376    23.234     0.200
     0.050     1.539     0.200
     0.052     1.539     0.200
     0.063     1.730     0.200
     0.110     2.629     0.200
     0.116     3.039     0.200
     0.154     3.520     0.200
     0.228     4.539     0.200
     0.225     5.289     0.200
     0.232     4.668     0.200
     0.235     5.410     0.200
     0.248     5.570     0.200
     0.264     5.449     0.200
     0.293     6.508     0.200
     0.309     5.688     0.200
     0.330     6.969     0.200
     0.331     6.777     0.200
     0.365     7.348     0.200
     0.374     8.180     0.200
     0.390     7.957     0.200
     0.433     8.777     0.200
     0.491     9.309     0.200
     0.483     9.891     0.200
     0.496    10.020     0.200
     0.509     9.957     0.200
     0.516    10.301     0.200
     0.507    10.008     0.200
     0.534    10.898     0.200
     0.539    10.090     0.200
     0.542    10.539     0.200
     0.569    11.148     0.200
     0.569    11.000     0.200
     0.576    11.277     0.200
     0.591    10.957     0.200
     0.588    11.367     0.200
     0.594    11.430     0.200
     0.620    11.699     0.200
     0.623    12.230     0.200
     0.637    11.867     0.200
     0.628    12.277     0.200
     0.654    12.418     0.200
     0.658    12.688     0.200
     0.643    12.520     0.200
     0.662    12.879     0.200
     0.688    12.688     0.200
     0.698    12.648     0.200
     0.762    14.617     0.200
     0.774    13.469     0.200
     0.786    14.020     0.200
     0.792    14.469     0.200
     0.797    15.129     0.200
     0.824    15.020     0.200
     0.911    15.980     0.200
     0.913    16.398     0.200
     1.015    17.918     0.200
     1.047    18.379     0.200
     1.091    19.117     0.200
     1.223    20.188     0.200
     1.714    31.527     0.200
     0.170     4.057     0.200
     0.167     3.877     0.200
     0.128     3.627     0.200
     0.128     3.301     0.200
     0.155     4.177     0.200
     0.216     4.697     0.200
     0.174     4.517     0.200
     0.203     4.737     0.200
     0.265     5.727     0.200
     0.330     6.747     0.200
     0.330     6.757     0.200
     0.332     6.777     0.200
     0.297     6.417     0.200
     0.283     6.357     0.200
     0.318     6.497     0.200
     0.371     7.587     0.200
     0.405     8.057     0.200
     0.332     7.137     0.200
     0.402     7.917     0.200
     0.345     7.077     0.200
     0.351     7.747     0.200
     0.388     8.037     0.200
     0.436     8.807     0.200
     0.490     9.297     0.200
     0.498     9.397     0.200
     0.535    10.167     0.200
     0.457     9.117     0.200
     0.541    10.367     0.200
     0.464     9.327     0.200
     0.515    10.237     0.200
     0.539    10.047     0.200
     0.514     9.977     0.200
     0.496     9.787     0.200
     0.513    10.317     0.200
     0.596    11.077     0.200
     0.542    11.027     0.200
     0.579    11.367     0.200
     0.637    11.527     0.200
     0.611    11.857     0.200
     0.612    11.847     0.200
     0.578    11.357     0.200
     0.638    12.377     0.200
     0.663    12.367     0.200
     0.679    12.347     0.200
     0.670    12.317     0.200
     0.644    12.217     0.200
     0.637    11.857     0.200
     0.681    12.417     0.200
     0.717    13.207     0.200
     0.726    13.327     0.200
     0.742    13.347     0.200
     0.698    13.487     0.200
     0.761    13.857     0.200
     0.748    13.557     0.200
     0.763    13.637     0.200
     0.752    13.667     0.200
     0.743    14.007     0.200
     0.780    14.067     0.200
     0.760    13.777     0.200
     0.794    14.737     0.200
     0.820    14.837     0.200
     0.813    14.747     0.200
     0.823    14.907     0.200
     0.839    15.457     0.200
     0.830    15.297     0.200
     0.854    15.207     0.200
     0.850    15.207     0.200
     0.878    15.877     0.200
     0.888    16.137     0.200
     0.907    16.327     0.200
     0.917    16.438     0.200
     0.916    16.567     0.200
     0.922    16.547     0.200
     0.943    16.447     0.200
     0.963    17.287     0.200
     1.182    21.188     0.200
     0.105     3.688     0.200
     0.140     3.996     0.200
     0.133     3.906     0.200
     0.171     4.297     0.200
     0.197     4.559     0.200
     0.192     4.918     0.200
     0.221     5.355     0.200
     0.245     5.965     0.200
     0.269     5.828     0.200
     0.263     5.957     0.200
     0.277     6.148     0.200
     0.293     6.168     0.200
     0.296     6.066     0.200
     0.306     6.367     0.200
     0.329     6.918     0.200
     0.331     6.945     0.200
     0.317     6.906     0.200
     0.343     7.008     0.200
     0.344     7.105     0.200
     0.340     7.195     0.200
     0.372     7.457     0.200
     0.385     7.836     0.200
     0.389     7.867     0.200
     0.389     7.938     0.200
     0.386     7.918     0.200
     0.405     8.125     0.200
     0.400     8.016     0.200
     0.396     8.367     0.200
     0.396     8.047     0.200
     0.410     8.777     0.200
     0.438     8.809     0.200
     0.434     8.605     0.200
     0.440     8.676     0.200
     0.463     9.406     0.200
     0.454     8.695     0.200
     0.469     9.281     0.200
     0.470     8.387     0.200
     0.469     9.168     0.200
     0.477     9.168     0.200
     0.465     9.207     0.200
     0.482     9.676     0.200
     0.475     9.465     0.200
     0.499     9.418     0.200
     0.511    10.008     0.200
     0.503     9.668     0.200
     0.523    10.035     0.200
     0.527    10.438     0.200
     0.577    11.445     0.200
     0.555    11.375     0.200
     0.562    10.809     0.200
     0.581    11.426     0.200
     0.575    11.809     0.200
     0.576    11.348     0.200
     0.586    11.207     0.200
     0.613    11.535     0.200
     0.620    11.777     0.200
     0.640    12.148     0.200
     0.657    12.785     0.200
     0.652    12.078     0.200
     0.646    12.316     0.200
     0.643    12.566     0.200
     0.650    12.637     0.200
     0.661    12.605     0.200
     0.665    12.715     0.200
     0.684    12.957     0.200
     0.692    12.586     0.200
     0.709    13.785     0.200
     0.705    13.648     0.200
     0.705    13.926     0.200
     0.706    13.688     0.200
     0.716    13.445     0.200
     0.715    13.398     0.200
     0.731    13.957     0.200
     0.743    13.508     0.200
     0.746    14.508     0.200
     0.742    14.195     0.200
     0.755    14.117     0.200
     0.776    14.605     0.200
     0.787    14.168     0.200
     0.789    14.898     0.200
     0.797    14.945     0.200
     0.815    14.656     0.200
     0.816    15.438     0.200
     0.819    15.578     0.200
     0.819    15.516     0.200
     0.831    15.195     0.200
     0.820    15.195     0.200
     0.822    15.547     0.200
     0.837    15.496     0.200
     0.842    15.738     0.200
     0.851    15.867     0.200
     0.855    16.066     0.200
     0.854    16.207     0.200
     0.871    16.059     0.200
     0.873    16.426     0.200
     0.094     2.641     0.200
     0.126     3.898     0.200
     0.126     3.820     0.200
     0.133     3.625     0.200
     0.133     3.594     0.200
     0.174     4.305     0.200
     0.175     4.883     0.200
     0.181     4.500     0.200
     0.188     4.750     0.200
     0.204     5.414     0.200
     0.235     5.273     0.200
     0.235     5.070     0.200
     0.261     5.961     0.200
     0.273     6.453     0.200
     0.297     6.672     0.200
     0.297     6.055     0.200
     0.316     7.078     0.200
     0.318     7.469     0.200
     0.322     6.414     0.200
     0.359     7.500     0.200
     0.378     7.852     0.200
     0.388     7.508     0.200
     0.420     8.625     0.200
     0.435     8.164     0.200
     0.461     8.828     0.200
     0.454     9.500     0.200
     0.457     9.688     0.200
     0.479     9.961     0.200
     0.487     9.680     0.200
     0.487     9.531     0.200
     0.488     9.664     0.200
     0.502    10.008     0.200
     0.528    10.875     0.200
     0.536    10.469     0.200
     0.534     9.953     0.200
     0.567    10.828     0.200
     0.565    10.805     0.200
     0.565    10.922     0.200
     0.582    11.500     0.200
     0.598    11.141     0.200
     0.590    11.781     0.200
     0.625    11.461     0.200
     0.631    12.289     0.200
     0.658    12.531     0.200
     0.678    12.703     0.200
     0.678    13.141     0.200
     0.671    12.812     0.200
     0.722    13.805     0.200
     0.723    13.578     0.200
     0.724    13.805     0.200
     0.733    14.094     0.200
     0.749    14.188     0.200
     0.761    14.508     0.200
     0.790    14.742     0.200
     0.785    14.812     0.200
     0.793    14.375     0.200
     0.808    14.758     0.200
     0.823    15.961     0.200
     0.830    14.898     0.200
     0.827    14.602     0.200
     0.829    15.055     0.200
     0.858    15.914     0.200
     0.862    16.203     0.200
     0.879    15.578     0.200
     0.891    16.461     0.200
     0.890    16.320     0.200
     0.918    16.680     0.200
     0.926    16.773     0.200
     0.930    16.750     0.200
     0.972    17.422     0.200
     0.981    17.391     0.200
     0.985    17.719     0.200
     0.999    17.641     0.200
     1.018    17.711     0.200
     1.039    17.828     0.200
     1.044    18.133     0.200
     1.044    18.273     0.200
     1.114    19.414     0.200
     1.147    19.922     0.200
     1.152    20.008     0.200
     1.174    20.992     0.200
     1.238    21.219     0.200
     1.298    22.188     0.200
     1.349    22.750     0.200
     1.383    23.383     0.200
     1.400    23.539     0.200
     1.687    29.219     0.200
     1.715    29.078     0.200
     1.832    31.055     0.200
     1.915    34.828     0.200
     1.946    33.055     0.200
     0.086     2.121     0.200
     0.139     2.984     0.200
     0.142     3.594     0.200
     0.188     4.414     0.200
     0.187     4.434     0.200
     0.202     3.566     0.200
     0.209     4.344     0.200
     0.209     4.156     0.200
     0.225     4.453     0.200
     0.248     5.121     0.200
     0.226     5.203     0.200
     0.260     5.262     0.200
     0.241     4.852     0.200
     0.247     5.613     0.200
     0.249     5.211     0.200
     0.290     6.184     0.200
     0.290     6.102     0.200
     0.285     6.004     0.200
     0.320     6.293     0.200
     0.330     6.723     0.200
     0.320     6.871     0.200
     0.342     7.281     0.200
     0.363     7.344     0.200
     0.347     7.461     0.200
     0.344     7.012     0.200
     0.353     7.422     0.200
     0.366     7.801     0.200
     0.385     7.973     0.200
     0.411     8.633     0.200
     0.427     8.414     0.200
     0.397     8.934     0.200
     0.398     7.871     0.200
     0.399     7.941     0.200
     0.434     8.621     0.200
     0.411     8.402     0.200
     0.426     8.582     0.200
     0.418     8.473     0.200
     0.430     9.113     0.200
     0.426     8.492     0.200
     0.432     8.773     0.200
     0.451     8.883     0.200
     0.433     8.422     0.200
     0.457     9.164     0.200
     0.471     9.211     0.200
     0.520    10.062     0.200
     0.533    10.152     0.200
     0.516    10.301     0.200
     0.525    10.824     0.200
     0.532    10.492     0.200
     0.543    10.594     0.200
     0.567    11.531     0.200
     0.537    10.633     0.200
     0.566    11.254     0.200
     0.552    10.801     0.200
     0.547    10.891     0.200
     0.557    11.422     0.200
     0.560    11.043     0.200
     0.569    11.242     0.200
     0.582    11.434     0.200
     0.607    11.461     0.200
     0.596    11.773     0.200
     0.635    12.051     0.200
     0.634    12.023     0.200
     0.641    12.031     0.200
     0.617    12.664     0.200
     0.622    12.562     0.200
     0.626    12.414     0.200
     0.666    12.781     0.200
     0.643    12.473     0.200
     0.652    12.602     0.200
     0.657    12.543     0.200
     0.664    12.703     0.200
     0.685    13.023     0.200
     0.685    13.031     0.200
     0.660    12.773     0.200
     0.661    12.891     0.200
     0.692    13.363     0.200
     0.699    13.484     0.200
     0.682    12.922     0.200
     0.703    13.641     0.200
     0.699    13.184     0.200
     0.688    13.434     0.200
     0.707    13.422     0.200
     0.717    13.523     0.200
     0.733    14.234     0.200
     0.703    13.844     0.200
     0.708    13.801     0.200
     0.711    13.941     0.200
     0.747    14.422     0.200
     0.740    13.762     0.200
     0.755    14.242     0.200
     0.747    14.102     0.200
     0.759    14.223     0.200
     0.761    14.121     0.200
     0.765    14.383     0.200
     0.753    14.254     0.200
     0.782    14.902     0.200
     0.782    14.883     0.200
     0.794    15.004     0.200
     0.795    14.992     0.200
     0.773    14.512     0.200
     0.795    14.992     0.200
     0.790    14.762     0.200
     0.780    14.871     0.200
     0.788    14.941     0.200
     0.788    15.113     0.200
     0.808    14.914     0.200
     0.808    14.922     0.200
     0.807    15.484     0.200
     0.815    15.312     0.200
     0.832    15.672     0.200
     0.814    15.562     0.200
     0.815    15.723     0.200
     0.853    15.723     0.200
     0.842    16.121     0.200
     0.857    15.781     0.200
     0.837    16.062     0.200
     0.869    16.344     0.200
     0.866    16.184     0.200
     0.874    15.012     0.200
     0.875    16.211     0.200
     0.878    16.312     0.200
     0.871    16.461     0.200
     0.882    16.703     0.200
     0.887    16.902     0.200
     0.890    16.801     0.200
     0.911    16.863     0.200
     0.928    17.324     0.200
     0.940    17.613     0.200
     0.961    18.012     0.200
     0.954    19.332     0.200
     0.955    18.324     0.200
     0.962    18.562     0.200
     0.997    18.141     0.200
     0.972    18.422     0.200
     1.003    18.234     0.200
     1.110    19.324     0.200
     1.353    22.602     0.200
     1.361    23.004     0.200
     1.369    23.184     0.200
     1.369    23.332     0.200
     1.667    29.934     0.200
     0.173     4.425     0.200
     0.156     4.536     0.200
     0.158     4.016     0.200
     0.215     5.585     0.200
     0.220     5.235     0.200
     0.232     5.146     0.200
     0.241     5.325     0.200
     0.316     6.695     0.200
     0.286     5.896     0.200
     0.286     5.936     0.200
     0.296     6.295     0.200
     0.329     7.105     0.200
     0.340     7.355     0.200
     0.342     7.315     0.200
     0.341     6.755     0.200
     0.324     6.755     0.200
     0.346     7.166     0.200
     0.374     7.845     0.200
     0.385     8.025     0.200
     0.391     7.726     0.200
     0.371     7.516     0.200
     0.397     8.055     0.200
     0.427     8.525     0.200
     0.394     8.005     0.200
     0.395     8.045     0.200
     0.429     9.085     0.200
     0.432     8.925     0.200
     0.447     8.735     0.200
     0.442     9.025     0.200
     0.439     8.605     0.200
     0.444     8.515     0.200
     0.444     8.675     0.200
     0.454     9.195     0.200
     0.468     9.315     0.200
     0.495     9.735     0.200
     0.509     9.875     0.200
     0.511    10.115     0.200
     0.517     9.775     0.200
     0.512     9.825     0.200
     0.528    10.345     0.200
     0.542    10.125     0.200
     0.551    10.405     0.200
     0.552    11.396     0.200
     0.542    11.305     0.200
     0.565    10.996     0.200
     0.534    10.615     0.200
     0.558    11.186     0.200
     0.540    10.325     0.200
     0.583    11.675     0.200
     0.598    11.615     0.200
     0.592    11.575     0.200
     0.594    11.465     0.200
     0.611    11.795     0.200
     0.633    12.896     0.200
     0.641    12.465     0.200
     0.667    12.405     0.200
     0.652    12.865     0.200
     0.662    12.825     0.200
     0.694    13.335     0.200
     0.673    12.666     0.200
     0.685    13.695     0.200
     0.673    12.945     0.200
     0.699    12.805     0.200
     0.707    13.505     0.200
     0.711    11.746     0.200
     0.682    13.246     0.200
     0.688    13.125     0.200
     0.685    13.166     0.200
     0.731    13.686     0.200
     0.727    14.166     0.200
     0.739    13.375     0.200
     0.750    14.235     0.200
     0.781    14.135     0.200
     0.773    14.625     0.200
     0.770    14.666     0.200
     0.791    14.266     0.200
     0.774    14.976     0.200
     0.774    14.956     0.200
     0.779    14.505     0.200
     0.788    14.815     0.200
     0.824    15.295     0.200
     0.813    15.195     0.200
     0.810    15.445     0.200
     0.827    15.635     0.200
     0.821    16.036     0.200
     0.831    14.815     0.200
     0.819    15.536     0.200
     0.828    15.496     0.200
     0.861    15.355     0.200
     0.855    16.055     0.200
     0.865    15.905     0.200
     0.867    16.456     0.200
     0.873    15.815     0.200
     0.885    16.286     0.200
     0.877    16.706     0.200
     0.903    17.335     0.200
     0.894    16.686     0.200
     0.894    16.715     0.200
     0.942    17.646     0.200
     0.977    17.365     0.200
     1.011    18.396     0.200
     1.838    32.005     0.200
     0.029     0.637     0.200
     0.028     0.686     0.200
     0.083     2.047     0.200
     0.078     1.936     0.200
     0.119     2.785     0.200
     0.164     3.836     0.200
     0.166     3.525     0.200
     0.187     4.406     0.200
     0.206     4.996     0.200
     0.195     4.625     0.200
     0.202     4.096     0.200
     0.302     6.576     0.200
     0.307     6.086     0.200
     0.311     6.246     0.200
     0.319     6.746     0.200
     0.333     7.217     0.200
     0.367     7.785     0.200
     0.366     7.426     0.200
     0.360     7.666     0.200
     0.416     8.596     0.200
     0.436     9.195     0.200
     0.443     8.646     0.200
     0.450     9.615     0.200
     0.456     9.596     0.200
     0.480     9.516     0.200
     0.467     8.996     0.200
     0.499    10.125     0.200
     0.506     9.797     0.200
     0.524    10.387     0.200
     0.526    10.477     0.200
     0.549    10.695     0.200
     0.562    10.676     0.200
     0.558    11.086     0.200
     0.575    11.477     0.200
     0.570    10.637     0.200
     0.586    11.266     0.200
     0.584    11.506     0.200
     0.600    11.955     0.200
     0.641    12.236     0.200
     0.651    12.195     0.200
     0.656    12.977     0.200
     0.665    12.775     0.200
     0.689    12.916     0.200
     0.698    13.137     0.200
     0.692    13.115     0.200
     0.715    13.736     0.200
     0.719    13.717     0.200
     0.722    13.945     0.200
     0.762    14.656     0.200
     0.772    13.967     0.200
     0.777    15.125     0.200
     0.788    14.625     0.200
     0.789    14.646     0.200
     0.819    14.307     0.200
     0.820    15.486     0.200
     0.827    15.387     0.200
     0.825    15.195     0.200
     0.827    15.381     0.200
     0.858    15.955     0.200
     0.858    16.086     0.200
     0.857    15.875     0.200
     0.863    16.057     0.200
     0.866    16.125     0.200
     0.879    16.336     0.200
     0.889    16.596     0.200
     0.889    16.406     0.200
     0.913    16.516     0.200
     0.917    17.057     0.200
     0.931    16.785     0.200
     0.923    16.807     0.200
     0.935    16.586     0.200
     0.937    17.666     0.200
     0.943    17.146     0.200
     0.973    17.605     0.200
     0.999    17.186     0.200
     0.992    18.387     0.200
     1.000    17.705     0.200
     1.008    18.137     0.200
     1.019    18.406     0.200
     1.042    18.516     0.200
     1.025    19.076     0.200
     1.050    18.775     0.200
     1.052    19.266     0.200
     1.056    18.967     0.200
     1.062    18.836     0.200
     1.061    18.875     0.200
     1.069    19.166     0.200
     1.079    19.656     0.200
     1.092    19.275     0.200
     1.092    19.307     0.200
     1.088    19.105     0.200
     1.145    20.176     0.200
     1.195    20.547     0.200
     1.214    20.355     0.200
     1.261    21.887     0.200
     1.276    22.096     0.200
     1.305    25.166     0.200
     1.326    22.756     0.200
     1.325    22.756     0.200
     1.340    22.996     0.200
     1.368    23.285     0.200
     1.393    23.785     0.200
     1.786    32.227     0.200
     0.031     0.602     0.200
     0.033     0.582     0.200
     0.088     2.012     0.200
     0.073     1.982     0.200
     0.124     2.723     0.200
     0.172     3.912     0.200
     0.170     3.951     0.200
     0.183     4.332     0.200
     0.191     4.502     0.200
     0.196     4.062     0.200
     0.307     6.633     0.200
     0.312     6.172     0.200
     0.315     6.402     0.200
     0.319     6.682     0.200
     0.332     7.162     0.200
     0.341     7.043     0.200
     0.356     7.512     0.200
     0.373     7.932     0.200
     0.371     7.463     0.200
     0.421     8.723     0.200
     0.442     9.342     0.200
     0.446     8.713     0.200
     0.455     9.723     0.200
     0.452     9.572     0.200
     0.480     9.602     0.200
     0.462     9.043     0.200
     0.496    10.072     0.200
     0.500     9.812     0.200
     0.521    10.383     0.200
     0.527    10.262     0.200
     0.549    10.793     0.200
     0.553    10.902     0.200
     0.567    10.582     0.200
     0.579    11.521     0.200
     0.573    10.621     0.200
     0.589    11.281     0.200
     0.589    11.543     0.200
     0.596    12.072     0.200
     0.643    12.201     0.200
     0.640    11.912     0.200
     0.654    12.883     0.200
     0.656    12.611     0.200
     0.667    12.682     0.200
     0.688    12.842     0.200
     0.702    13.143     0.200
     0.696    13.031     0.200
     0.716    13.871     0.200
     0.721    13.633     0.200
     0.726    13.852     0.200
     0.760    14.312     0.200
     0.773    15.152     0.200
     0.775    14.062     0.200
     0.785    14.441     0.200
     0.784    14.473     0.200
     0.819    15.432     0.200
     0.824    15.422     0.200
     0.824    15.232     0.200
     0.822    15.271     0.200
     0.824    14.691     0.200
     0.824    15.477     0.200
     0.860    15.902     0.200
     0.854    15.793     0.200
     0.863    15.521     0.200
     0.858    16.502     0.200
     0.861    15.771     0.200
     0.879    16.223     0.200
     0.887    16.531     0.200
     0.885    16.402     0.200
     0.914    16.602     0.200
     0.915    17.072     0.200
     0.920    16.832     0.200
     0.934    17.383     0.200
     0.940    17.293     0.200
     0.940    16.463     0.200
     0.972    17.662     0.200
     0.986    18.182     0.200
     0.995    17.682     0.200
     1.004    18.182     0.200
     1.017    18.432     0.200
     1.020    19.262     0.200
     1.044    18.611     0.200
     1.048    18.812     0.200
     1.050    19.152     0.200
     1.054    19.092     0.200
     1.059    18.861     0.200
     1.058    18.922     0.200
     1.049    19.521     0.200
     1.068    19.252     0.200
     1.093    19.312     0.200
     1.094    19.352     0.200
     1.083    19.121     0.200
     1.146    20.201     0.200
     1.156    20.322     0.200
     1.200    20.592     0.200
     1.217    20.402     0.200
     1.265    22.021     0.200
     1.259    21.922     0.200
     1.271    21.973     0.200
     1.263    21.951     0.200
     1.274    21.951     0.200
     1.327    22.633     0.200
     1.324    22.621     0.200
     1.339    22.861     0.200
     1.368    23.352     0.200
     1.391    23.762     0.200
     1.634    30.482     0.200
     0.025     0.914     0.200
     0.030     2.363     0.200
     0.064     1.643     0.200
     0.100     2.312     0.200
     0.094     2.283     0.200
     0.147     3.643     0.200
     0.147     3.533     0.200
     0.209     5.203     0.200
     0.207     4.822     0.200
     0.215     4.973     0.200
     0.220     4.463     0.200
     0.284     6.273     0.200
     0.284     6.273     0.200
     0.299     6.133     0.200
     0.299     6.133     0.200
     0.318     6.553     0.200
     0.328     6.674     0.200
     0.354     7.643     0.200
     0.347     7.424     0.200
     0.397     8.322     0.200
     0.380     7.902     0.200
     0.420     9.053     0.200
     0.438     8.334     0.200
     0.438     8.674     0.200
     0.488     9.822     0.200
     0.476    10.094     0.200
     0.505     9.854     0.200
     0.482     9.053     0.200
     0.516    10.232     0.200
     0.547    10.312     0.200
     0.523    10.312     0.200
     0.565    11.072     0.200
     0.568    11.344     0.200
     0.555    10.363     0.200
     0.559    11.062     0.200
     0.545    10.434     0.200
     0.577    11.273     0.200
     0.606    11.424     0.200
     0.632    11.873     0.200
     0.646    11.604     0.200
     0.646    11.754     0.200
     0.652    11.953     0.200
     0.652    11.553     0.200
     0.668    12.963     0.200
     0.674    12.703     0.200
     0.661    12.164     0.200
     0.691    13.014     0.200
     0.713    13.674     0.200
     0.701    13.164     0.200
     0.712    13.303     0.200
     0.723    13.764     0.200
     0.722    13.803     0.200
     0.755    13.742     0.200
     0.842    15.482     0.200
     0.886    16.062     0.200
     0.916    16.062     0.200
     0.929    16.793     0.200
     0.985    16.732     0.200
     1.042    18.383     0.200
     1.042    18.514     0.200
     1.038    18.232     0.200
     1.053    19.914     0.200
     1.097    19.273     0.200
     1.179    20.303     0.200
     1.197    20.084     0.200
     1.459    26.053     0.200
     1.642    30.584     0.200
     0.052     1.916     0.200
     0.051     1.746     0.200
     0.055     1.797     0.200
     0.094     2.566     0.200
     0.104     2.707     0.200
     0.104     2.697     0.200
     0.098     2.527     0.200
     0.157     3.707     0.200
     0.228     4.666     0.200
     0.228     4.678     0.200
     0.233     4.848     0.200
     0.237     5.227     0.200
     0.237     5.227     0.200
     0.236     5.447     0.200
     0.286     6.156     0.200
     0.288     6.447     0.200
     0.272     5.396     0.200
     0.326     6.938     0.200
     0.317     6.746     0.200
     0.318     6.527     0.200
     0.367     7.428     0.200
     0.364     7.996     0.200
     0.362     7.746     0.200
     0.362     7.758     0.200
     0.379     8.338     0.200
     0.443     9.066     0.200
     0.484     9.178     0.200
     0.497    10.088     0.200
     0.511    10.008     0.200
     0.518    10.258     0.200
     0.514    10.088     0.200
     0.510     9.816     0.200
     0.536    10.047     0.200
     0.523    10.297     0.200
     0.547    10.486     0.200
     0.584    11.307     0.200
     0.579    11.236     0.200
     0.577    11.307     0.200
     0.593    10.807     0.200
     0.607    11.537     0.200
     0.579    10.777     0.200
     0.620    11.707     0.200
     0.640    12.428     0.200
     0.642    12.486     0.200
     0.635    12.377     0.200
     0.624    11.646     0.200
     0.666    12.787     0.200
     0.666    12.406     0.200
     0.672    12.906     0.200
     0.675    12.438     0.200
     0.696    12.736     0.200
     0.687    12.566     0.200
     0.775    14.377     0.200
     0.763    13.406     0.200
     0.764    13.367     0.200
     0.758    14.566     0.200
     0.807    15.027     0.200
     0.774    13.807     0.200
     0.814    14.688     0.200
     0.814    14.227     0.200
     0.837    15.197     0.200
     0.837    15.221     0.200
     0.847    15.566     0.200
     0.858    15.727     0.200
     0.861    15.787     0.200
     0.899    15.637     0.200
     0.910    16.396     0.200
     0.919    16.717     0.200
     0.952    16.098     0.200
     0.988    17.527     0.200
     1.040    18.217     0.200
     1.034    18.236     0.200
     1.100    19.367     0.200
     1.120    19.297     0.200
     1.105    19.566     0.200
     1.120    20.387     0.200
     1.186    20.906     0.200
     1.194    20.697     0.200
     1.210    19.916     0.200
     1.391    22.508     0.200
     0.005     2.207     0.200
     0.065     2.738     0.200
     0.135     3.398     0.200
     0.179     4.258     0.200
     0.198     4.445     0.200
     0.218     4.605     0.200
     0.241     5.137     0.200
     0.279     5.898     0.200
     0.275     5.527     0.200
     0.286     5.766     0.200
     0.309     6.445     0.200
     0.336     7.047     0.200
     0.336     6.816     0.200
     0.342     7.355     0.200
     0.375     7.547     0.200
     0.355     7.637     0.200
     0.401     8.078     0.200
     0.404     8.047     0.200
     0.386     7.977     0.200
     0.390     7.887     0.200
     0.411     8.035     0.200
     0.404     8.348     0.200
     0.430     8.367     0.200
     0.438     8.875     0.200
     0.441     8.828     0.200
     0.444     8.785     0.200
     0.434     8.758     0.200
     0.465     9.246     0.200
     0.453     9.078     0.200
     0.486     9.277     0.200
     0.483     9.219     0.200
     0.476     9.926     0.200
     0.477     9.238     0.200
     0.480     9.707     0.200
     0.483     9.738     0.200
     0.499     9.488     0.200
     0.510     9.836     0.200
     0.519    10.219     0.200
     0.533    10.086     0.200
     0.556    10.746     0.200
     0.574    10.887     0.200
     0.560    10.598     0.200
     0.568    11.047     0.200
     0.577    10.855     0.200
     0.578    11.188     0.200
     0.607    11.625     0.200
     0.612    11.418     0.200
     0.606    11.559     0.200
     0.598    11.137     0.200
     0.602    11.387     0.200
     0.611    11.828     0.200
     0.609    11.656     0.200
     0.620    11.887     0.200
     0.616    11.668     0.200
     0.647    11.887     0.200
     0.645    12.367     0.200
     0.656    12.195     0.200
     0.652    12.266     0.200
     0.660    12.418     0.200
     0.663    12.695     0.200
     0.656    12.457     0.200
     0.654    12.238     0.200
     0.673    12.656     0.200
     0.675    12.938     0.200
     0.682    12.906     0.200
     0.690    12.898     0.200
     0.706    13.848     0.200
     0.716    13.496     0.200
     0.704    13.316     0.200
     0.704    13.098     0.200
     0.725    13.297     0.200
     0.729    13.387     0.200
     0.732    13.457     0.200
     0.741    13.527     0.200
     0.738    13.766     0.200
     0.728    13.758     0.200
     0.734    13.656     0.200
     0.751    13.797     0.200
     0.762    13.957     0.200
     0.768    14.047     0.200
     0.778    14.516     0.200
     0.768    14.016     0.200
     0.789    15.047     0.200
     0.787    14.945     0.200
     0.787    13.977     0.200
     0.800    14.547     0.200
     0.800    14.926     0.200
     0.790    14.836     0.200
     0.826    14.957     0.200
     0.835    15.707     0.200
     0.846    15.598     0.200
     0.832    15.246     0.200
     0.832    15.566     0.200
     0.853    15.398     0.200
     0.854    15.637     0.200
     0.867    15.047     0.200
     0.899    16.188     0.200
     0.898    16.648     0.200
     0.894    16.828     0.200
     0.885    16.477     0.200
     0.909    16.355     0.200
     0.913    16.988     0.200
     0.921    16.688     0.200
     0.926    17.477     0.200
     0.924    17.176     0.200
     0.923    17.367     0.200
     0.950    17.535     0.200
     0.977    17.605     0.200
     0.981    17.918     0.200
     1.051    19.297     0.200
     1.066    20.047     0.200
     1.097    19.855     0.200
     1.199    20.648     0.200
     1.248    21.285     0.200
     1.280    21.168     0.200
     0.059     2.246     0.200
     0.100     3.215     0.200
     0.118     2.965     0.200
     0.124     3.215     0.200
     0.157     4.348     0.200
     0.181     4.895     0.200
     0.162     4.156     0.200
     0.174     4.426     0.200
     0.195     4.445     0.200
     0.185     4.598     0.200
     0.193     4.855     0.200
     0.242     5.777     0.200
     0.249     5.816     0.200
     0.337     7.188     0.200
     0.322     7.035     0.200
     0.326     6.438     0.200
     0.356     7.316     0.200
     0.368     7.375     0.200
     0.404     7.688     0.200
     0.448     9.238     0.200
     0.428     8.266     0.200
     0.439     9.156     0.200
     0.465     8.988     0.200
     0.451     8.996     0.200
     0.484     8.996     0.200
     0.483     9.547     0.200
     0.497    10.137     0.200
     0.517     9.996     0.200
     0.560    11.316     0.200
     0.553    10.746     0.200
     0.560    10.766     0.200
     0.603    11.805     0.200
     0.618    11.438     0.200
     0.617    11.738     0.200
     0.641    12.348     0.200
     0.652    11.637     0.200
     0.701    13.586     0.200
     0.717    13.516     0.200
     0.709    13.438     0.200
     0.723    13.586     0.200
     0.744    14.285     0.200
     0.758    14.328     0.200
     0.768    14.426     0.200
     0.762    13.875     0.200
     0.750    14.117     0.200
     0.752    13.805     0.200
     0.782    14.355     0.200
     0.785    14.477     0.200
     0.801    15.008     0.200
     0.825    15.746     0.200
     0.831    15.535     0.200
     0.848    15.156     0.200
     0.841    15.555     0.200
     0.835    14.688     0.200
     0.861    15.676     0.200
     0.890    16.266     0.200
     0.906    16.457     0.200
     0.956    17.387     0.200
     0.940    16.848     0.200
     0.979    17.445     0.200
     1.013    17.578     0.200
     1.013    17.637     0.200
     1.068    18.066     0.200
     1.121    19.855     0.200
     1.128    20.645     0.200
     1.170    20.527     0.200
     1.179    22.078     0.200
     1.259    22.105     0.200
     1.320    22.598     0.200
     1.013    18.098     0.200
     0.120     3.059     0.200
     0.124     3.250     0.200
     0.098     3.348     0.200
     0.163     4.188     0.200
     0.178     4.578     0.200
     0.154     4.387     0.200
     0.189     4.680     0.200
     0.192     4.488     0.200
     0.179     4.988     0.200
     0.240     5.637     0.200
     0.246     5.758     0.200
     0.324     7.117     0.200
     0.330     6.566     0.200
     0.335     7.156     0.200
     0.359     7.438     0.200
     0.367     7.500     0.200
     0.407     7.828     0.200
     0.432     8.367     0.200
     0.442     9.316     0.200
     0.450     8.930     0.200
     0.436     9.078     0.200
     0.446     9.219     0.200
     0.463     9.098     0.200
     0.481     9.078     0.200
     0.486     9.727     0.200
     0.516    10.000     0.200
     0.497    10.398     0.200
     0.562    10.789     0.200
     0.556    10.809     0.200
     0.562    11.387     0.200
     0.602    11.789     0.200
     0.615    11.430     0.200
     0.635    12.168     0.200
     0.650    11.750     0.200
     0.642    12.328     0.200
     0.709    13.238     0.200
     0.695    13.477     0.200
     0.726    13.738     0.200
     0.714    13.758     0.200
     0.763    13.977     0.200
     0.766    14.379     0.200
     0.786    14.379     0.200
     0.780    14.258     0.200
     0.798    14.539     0.200
     0.800    14.719     0.200
     0.837    14.867     0.200
     0.834    15.469     0.200
     0.822    15.859     0.200
     0.844    15.648     0.200
     0.832    15.918     0.200
     0.848    15.188     0.200
     0.892    16.348     0.200
     0.908    16.500     0.200
     0.944    16.977     0.200
     0.935    16.887     0.200
     0.957    17.359     0.200
     0.982    17.590     0.200
     0.988    17.297     0.200
     1.013    17.637     0.200
     1.044    18.547     0.200
     1.040    18.508     0.200
     1.041    18.488     0.200
     1.067    18.047     0.200
     1.057    18.797     0.200
     1.087    19.277     0.200
     1.079    19.180     0.200
     1.093    19.188     0.200
     1.099    19.539     0.200
     1.132    20.387     0.200
     1.110    20.289     0.200
     1.121    19.547     0.200
     1.119    19.547     0.200
     1.172    20.219     0.200
     1.173    20.406     0.200
     1.175    20.637     0.200
     1.175    20.219     0.200
     1.192    20.809     0.200
     1.194    20.828     0.200
     1.212    21.328     0.200
     1.207    20.840     0.200
     1.227    21.258     0.200
     1.240    21.250     0.200
     1.240    21.316     0.200
     1.321    22.500     0.200
     1.324    24.098     0.200
     1.343    23.227     0.200
     1.359    23.066     0.200
     1.370    23.129     0.200
     1.409    23.656     0.200
     1.412    23.848     0.200
     0.065     2.188     0.200
     0.104     3.250     0.200
     0.125     3.117     0.200
     0.160     4.039     0.200
     0.169     4.281     0.200
     0.180     4.398     0.200
     0.188     4.508     0.200
     0.162     4.406     0.200
     0.185     4.992     0.200
     0.206     4.578     0.200
     0.245     5.852     0.200
     0.252     5.750     0.200
     0.320     6.258     0.200
     0.318     7.117     0.200
     0.352     7.227     0.200
     0.342     7.242     0.200
     0.371     7.469     0.200
     0.399     7.438     0.200
     0.423     8.312     0.200
     0.434     9.039     0.200
     0.441     9.031     0.200
     0.452     9.070     0.200
     0.478     9.562     0.200
     0.469     9.117     0.200
     0.488     9.102     0.200
     0.498    10.148     0.200
     0.519    10.008     0.200
     0.547    10.570     0.200
     0.557    11.078     0.200
     0.559    11.266     0.200
     0.629    12.039     0.200
     0.623    11.469     0.200
     0.640    12.562     0.200
     0.655    11.758     0.200
     0.708    13.477     0.200
     0.720    13.742     0.200
     0.739    14.148     0.200
     0.721    13.742     0.200
     0.747    14.062     0.200
     0.751    14.297     0.200
     0.762    13.930     0.200
     0.784    14.703     0.200
     0.773    14.516     0.200
     0.795    14.359     0.200
     0.785    14.656     0.200
     0.804    14.859     0.200
     0.827    15.578     0.200
     0.832    14.758     0.200
     0.836    15.727     0.200
     0.835    15.656     0.200
     0.831    16.078     0.200
     0.887    16.547     0.200
     0.902    16.516     0.200
     0.936    16.820     0.200
     0.935    16.969     0.200
     0.953    17.422     0.200
     0.975    17.656     0.200
     0.988    17.219     0.200
     1.013    17.742     0.200
     1.013    17.805     0.200
     1.070    18.461     0.200
     1.123    20.188     0.200
     1.124    19.492     0.200
     1.167    20.953     0.200
     1.185    21.852     0.200
     1.265    23.297     0.200
     1.318    23.383     0.200
     1.429    24.609     0.200
     0.066     2.211     0.200
     0.105     3.250     0.200
     0.114     2.789     0.200
     0.124     3.102     0.200
     0.168     4.320     0.200
     0.163     4.383     0.200
     0.179     4.438     0.200
     0.187     4.492     0.200
     0.186     5.000     0.200
     0.199     4.641     0.200
     0.246     5.758     0.200
     0.253     5.812     0.200
     0.319     6.273     0.200
     0.317     7.453     0.200
     0.351     7.234     0.200
     0.343     7.398     0.200
     0.371     7.508     0.200
     0.398     7.570     0.200
     0.422     7.922     0.200
     0.433     9.062     0.200
     0.442     9.031     0.200
     0.452     9.117     0.200
     0.451     8.922     0.200
     0.478     9.508     0.200
     0.470     9.133     0.200
     0.498    10.242     0.200
     0.488     9.094     0.200
     0.519     9.992     0.200
     0.547    10.555     0.200
     0.559    11.344     0.200
     0.629    12.078     0.200
     0.640    12.469     0.200
     0.623    11.648     0.200
     0.655    11.773     0.200
     0.720    13.711     0.200
     0.707    13.711     0.200
     0.739    14.422     0.200
     0.723    13.852     0.200
     0.746    14.039     0.200
     0.762    13.938     0.200
     0.785    14.578     0.200
     0.774    14.672     0.200
     0.786    14.758     0.200
     0.796    14.531     0.200
     0.805    14.992     0.200
     0.827    15.570     0.200
     0.836    15.602     0.200
     0.831    14.742     0.200
     0.836    15.953     0.200
     0.832    16.023     0.200
     0.850    15.180     0.200
     0.887    16.844     0.200
     0.902    16.633     0.200
     0.936    16.852     0.200
     0.934    16.883     0.200
     0.974    17.484     0.200
     1.014    17.711     0.200
     1.014    17.977     0.200
     1.122    20.219     0.200
     1.125    20.039     0.200
     1.167    20.539     0.200
     1.186    21.719     0.200
     1.266    22.484     0.200
     1.318    23.305     0.200
     1.429    25.250     0.200
     2.565    45.141     0.200
     0.063     2.234     0.200
     0.106     3.180     0.200
     0.120     3.164     0.200
     0.162     4.391     0.200
     0.156     4.000     0.200
     0.187     4.930     0.200
     0.173     4.305     0.200
     0.181     4.500     0.200
     0.194     4.547     0.200
     0.188     4.594     0.200
     0.247     5.859     0.200
     0.292     6.766     0.200
     0.316     7.094     0.200
     0.343     7.234     0.200
     0.322     6.281     0.200
     0.357     7.242     0.200
     0.366     7.477     0.200
     0.399     7.594     0.200
     0.443     9.203     0.200
     0.426     8.000     0.200
     0.454     9.195     0.200
     0.438     9.273     0.200
     0.446     9.047     0.200
     0.471     9.047     0.200
     0.482     9.047     0.200
     0.483     9.445     0.200
     0.502    10.141     0.200
     0.514    10.055     0.200
     0.551    10.883     0.200
     0.564    11.383     0.200
     0.555    10.812     0.200
     0.609    11.727     0.200
     0.618    11.523     0.200
     0.635    12.172     0.200
     0.645    12.352     0.200
     0.650    11.742     0.200
     0.722    13.727     0.200
     0.703    13.547     0.200
     0.725    13.625     0.200
     0.744    14.242     0.200
     0.744    14.141     0.200
     0.760    14.445     0.200
     0.747    14.414     0.200
     0.767    13.703     0.200
     0.774    14.406     0.200
     0.787    14.672     0.200
     0.789    14.547     0.200
     0.801    14.445     0.200
     0.807    14.875     0.200
     0.828    15.891     0.200
     0.839    15.805     0.200
     0.833    15.375     0.200
     0.829    14.406     0.200
     0.841    15.586     0.200
     0.893    16.234     0.200
     0.907    16.406     0.200
     0.940    16.805     0.200
     0.935    16.805     0.200
     0.964    17.773     0.200
     1.018    17.984     0.200
     1.018    17.820     0.200
     1.065    18.180     0.200
     1.126    19.945     0.200
     1.172    20.656     0.200
     1.182    20.656     0.200
     1.264    21.961     0.200
     1.323    22.703     0.200
     1.018    18.031     0.200
     0.101     3.273     0.200
     0.118     3.008     0.200
     0.122     3.188     0.200
     0.160     4.141     0.200
     0.156     4.328     0.200
     0.178     4.531     0.200
     0.187     4.641     0.200
     0.181     4.938     0.200
     0.191     4.461     0.200
     0.194     4.727     0.200
     0.242     5.758     0.200
     0.249     5.703     0.200
     0.290     6.891     0.200
     0.321     7.078     0.200
     0.329     6.508     0.200
     0.337     7.203     0.200
     0.365     7.406     0.200
     0.360     7.367     0.200
     0.405     7.797     0.200
     0.432     8.367     0.200
     0.447     8.852     0.200
     0.443     9.273     0.200
     0.449     9.141     0.200
     0.465     9.031     0.200
     0.479     9.023     0.200
     0.487     9.648     0.200
     0.500    10.180     0.200
     0.514     9.922     0.200
     0.559    10.773     0.200
     0.557    10.789     0.200
     0.564    11.383     0.200
     0.605    11.703     0.200
     0.614    11.227     0.200
     0.637    12.297     0.200
     0.648    11.672     0.200
     0.645    12.461     0.200
     0.706    13.750     0.200
     0.698    13.320     0.200
     0.715    13.641     0.200
     0.727    13.688     0.200
     0.749    14.180     0.200
     0.751    14.461     0.200
     0.749    14.242     0.200
     0.765    13.938     0.200
     0.768    14.320     0.200
     0.782    14.273     0.200
     0.800    14.609     0.200
     0.803    14.711     0.200
     0.822    15.781     0.200
     0.835    14.562     0.200
     0.836    15.438     0.200
     0.835    15.688     0.200
     0.858    15.430     0.200
     0.850    15.172     0.200
     0.894    16.273     0.200
     0.910    16.461     0.200
     0.942    16.852     0.200
     0.938    16.812     0.200
     0.984    17.586     0.200
     1.016    17.906     0.200
     1.015    17.852     0.200
     1.064    17.922     0.200
     1.121    19.789     0.200
     1.132    20.891     0.200
     1.176    21.867     0.200
     1.174    20.273     0.200
     1.258    22.930     0.200
     1.323    22.617     0.200
     1.015    17.430     0.200
     0.146     3.562     0.200
     0.189     4.152     0.200
     0.187     4.250     0.200
     0.249     5.473     0.200
     0.252     5.473     0.200
     0.267     5.652     0.200
     0.283     6.242     0.200
     0.291     6.422     0.200
     0.352     7.312     0.200
     0.352     7.762     0.200
     0.355     7.441     0.200
     0.349     7.102     0.200
     0.365     8.109     0.200
     0.370     7.500     0.200
     0.392     8.012     0.200
     0.388     7.641     0.200
     0.401     8.672     0.200
     0.403     8.172     0.200
     0.390     7.711     0.200
     0.415     8.859     0.200
     0.420     8.012     0.200
     0.432     8.762     0.200
     0.426     8.223     0.200
     0.441     9.480     0.200
     0.445     8.859     0.200
     0.467     9.609     0.200
     0.479     9.062     0.200
     0.487     9.410     0.200
     0.541    10.312     0.200
     0.562    10.641     0.200
     0.568    11.012     0.200
     0.615    12.152     0.200
     0.622    12.551     0.200
     0.654    12.230     0.200
     0.646    12.250     0.200
     0.664    12.371     0.200
     0.668    12.832     0.200
     0.688    12.781     0.200
     0.695    12.980     0.200
     0.695    12.754     0.200
     0.688    12.801     0.200
     0.713    13.211     0.200
     0.741    13.633     0.200
     0.757    13.930     0.200
     0.773    14.289     0.200
     0.777    14.301     0.200
     0.791    14.652     0.200
     0.815    15.320     0.200
     0.824    15.492     0.200
     0.846    14.871     0.200
     0.840    15.340     0.200
     0.850    15.691     0.200
     0.863    15.301     0.200
     0.878    16.012     0.200
     0.885    16.512     0.200
     0.889    16.172     0.200
     0.903    16.051     0.200
     0.904    16.262     0.200
     0.915    16.562     0.200
     0.908    16.840     0.200
     0.935    17.449     0.200
     0.967    17.422     0.200
     0.969    17.449     0.200
     1.040    17.750     0.200
     1.067    19.230     0.200
     1.066    19.789     0.200
     1.079    18.262     0.200
     1.141    20.430     0.200
     0.114     2.667     0.200
     0.023     1.508     0.200
     0.146     3.408     0.200
     0.263     5.518     0.200
     0.289     6.038     0.200
     0.307     5.908     0.200
     0.330     6.647     0.200
     0.335     6.868     0.200
     0.249     5.378     0.200
     0.247     5.358     0.200
     0.377     7.128     0.200
     0.489     9.348     0.200
     0.646    12.788     0.200
     0.665    12.568     0.200
     0.745    14.368     0.200
     0.793    15.068     0.200
     0.779    15.048     0.200
     0.883    16.708     0.200
     0.830    16.038     0.200
     0.888    16.938     0.200
     0.906    16.938     0.200
     0.860    16.628     0.200
     0.982    18.948     0.200
     1.108    20.268     0.200
     1.076    19.798     0.200
     1.121    20.808     0.200
     1.290    22.828     0.200
     1.238    23.138     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.878    27.494     0.200
     0.883    28.382     0.200
     0.890    29.261     0.200
     0.947    30.424     0.200
     1.059    32.023     0.200
     1.114    35.603     0.200
     1.128    37.179     0.200
     1.200    37.269     0.200
     1.384    44.014     0.200
     1.418    44.680     0.200
     0.928    29.623     0.200
     0.964    31.174     0.200
     1.020    32.459     0.200
     1.209    38.221     0.200
     1.233    38.293     0.200
     1.248    38.725     0.200
     1.261    39.799     0.200
     1.406    43.754     0.200
     1.509    48.525     0.200
     1.513    45.965     0.200
     1.513    48.295     0.200
     4.430   119.133     0.200
     0.887    28.581     0.200
     0.945    30.150     0.200
     1.039    32.510     0.200
     1.065    34.419     0.200
     1.293    40.420     0.200
     1.327    41.790     0.200
     1.351    43.386     0.200
     1.435    44.589     0.200
     1.478    46.110     0.200
     0.865    27.609     0.200
     0.902    29.313     0.200
     1.304    41.368     0.200
     1.275    40.031     0.200
     1.386    44.461     0.200
     1.492    46.710     0.200
     1.496    47.669     0.200
     2.109    58.697     0.200
     2.225    61.428     0.200
     2.357    65.613     0.200
     2.358    64.958     0.200
     2.921    80.162     0.200
     3.079    83.113     0.200
     0.861    27.672     0.200
     0.904    29.352     0.200
     1.491    46.758     0.200
     1.497    47.453     0.200
     1.816    52.031     0.200
     2.106    58.805     0.200
     2.221    61.445     0.200
     2.354    64.883     0.200
     3.076    83.148     0.200
     3.133    85.016     0.200
     3.472    93.070     0.200
     3.598    95.688     0.200
     3.625    96.875     0.200
     3.655    97.570     0.200
     4.206   110.586     0.200
     0.876    27.664     0.200
     0.987    30.711     0.200
     1.052    32.438     0.200
     1.210    38.203     0.200
     1.188    37.035     0.200
     1.225    39.090     0.200
     1.299    41.434     0.200
     1.285    40.168     0.200
     1.373    43.879     0.200
     1.433    44.043     0.200
     1.394    43.000     0.200
     0.883    27.738     0.200
     0.987    30.480     0.200
     1.058    33.578     0.200
     1.054    33.316     0.200
     1.206    38.062     0.200
     1.194    37.113     0.200
     1.294    41.188     0.200
     1.283    38.613     0.200
     1.377    43.492     0.200
     1.431    44.465     0.200
     1.400    43.680     0.200
     1.497    44.938     0.200
     0.821    26.488     0.200
     0.821    26.141     0.200
     0.980    30.598     0.200
     0.971    31.215     0.200
     1.008    32.219     0.200
     1.108    34.648     0.200
     1.218    37.320     0.200
     1.270    39.098     0.200
     1.239    38.699     0.200
     1.401    41.918     0.200
     1.403    41.926     0.200
     1.350    43.137     0.200
     1.457    45.832     0.200
     1.812    49.469     0.200
     4.226   115.688     0.200
     4.644   122.328     0.200
     4.834   128.488     0.200
     7.189   187.246     0.200
     8.762   227.105     0.200
     9.654   248.926     0.200
     9.965   255.477     0.200
     0.993    31.690     0.200
     0.994    32.169     0.200
     1.115    34.603     0.200
     1.213    37.606     0.200
     1.250    38.849     0.200
     1.252    40.257     0.200
     1.374    41.759     0.200
     1.375    44.000     0.200
     1.486    47.350     0.200
     1.742    49.253     0.200
     3.341    92.789     0.200
     8.895   229.028     0.200
     0.946    30.219     0.200
     0.946    32.348     0.200
     1.093    34.609     0.200
     1.261    40.090     0.200
     1.376    42.988     0.200
     1.421    43.910     0.200
     1.515    47.387     0.200
     0.985    31.097     0.200
     0.975    32.019     0.200
     1.089    33.436     0.200
     1.066    34.158     0.200
     1.154    35.562     0.200
     1.169    37.404     0.200
     1.204    38.898     0.200
     1.264    38.822     0.200
     1.304    39.799     0.200
     1.268    40.274     0.200
     1.324    40.485     0.200
     1.332    42.419     0.200
     1.367    42.391     0.200
     1.478    45.535     0.200
     1.488    45.511     0.200
     0.923    29.825     0.200
     1.048    32.824     0.200
     1.121    34.500     0.200
     1.121    38.000     0.200
     1.286    40.580     0.200
     1.347    42.636     0.200
     0.929    29.590     0.200
     1.056    32.980     0.200
     1.053    32.508     0.200
     1.115    34.672     0.200
     1.282    40.609     0.200
     1.354    42.762     0.200
     1.473    46.441     0.200
     3.644    99.812     0.200
     4.750   127.582     0.200
     5.169   138.590     0.200
     5.893   154.730     0.200
     6.010   158.480     0.200
     6.045   160.160     0.200
     7.236   189.969     0.200
     0.846    26.913     0.200
     0.962    31.383     0.200
     1.305    40.934     0.200
     1.333    42.360     0.200
     1.422    43.983     0.200
     2.829    78.214     0.200
     7.418   191.504     0.200
     2.525    70.586     0.200
     4.932   130.070     0.200
     5.604   146.414     0.200
     7.106   183.703     0.200
     7.099   184.977     0.200
     7.858   202.992     0.200
    11.695   296.125     0.200
     0.944    32.430     0.200
     1.095    34.602     0.200
     1.220    37.711     0.200
     1.232    38.695     0.200
     1.232    40.164     0.200
     1.363    42.406     0.200
     2.692    74.250     0.200
     0.928    30.344     0.200
     0.995    32.965     0.200
     1.093    35.066     0.200
     1.227    37.996     0.200
     1.318    40.582     0.200
     1.344    43.719     0.200
     1.358    43.504     0.200
     1.455    45.562     0.200
     1.549    49.703     0.200
     1.562    48.395     0.200
     1.559    48.996     0.200
     0.940    30.227     0.200
     0.940    30.109     0.200
     0.998    31.430     0.200
     1.023    32.188     0.200
     1.114    33.844     0.200
     1.123    35.336     0.200
     1.154    35.344     0.200
     1.168    36.695     0.200
     1.303    39.547     0.200
     0.888    27.746     0.200
     0.862    27.012     0.200
     1.038    31.633     0.200
     1.156    36.367     0.200
     1.137    33.672     0.200
     1.219    38.008     0.200
     1.169    37.156     0.200
     1.190    37.422     0.200
     1.024    32.227     0.200
     1.349    42.695     0.200
     2.086    58.203     0.200
     2.087    57.953     0.200
     0.980    30.539     0.200
     0.980    31.086     0.200
     1.020    32.477     0.200
     1.127    34.992     0.200
     1.127    35.586     0.200
     1.128    34.750     0.200
     1.182    36.852     0.200
     1.266    38.531     0.200
     1.311    39.258     0.200
     0.893    29.445     0.200
     0.983    31.684     0.200
     0.983    33.816     0.200
     1.014    34.406     0.200
     1.077    34.387     0.200
     1.249    38.586     0.200
     1.249    39.375     0.200
     1.249    38.715     0.200
     1.249    38.938     0.200
     1.232    38.934     0.200
     1.275    40.066     0.200
     1.371    42.195     0.200
     1.364    42.301     0.200
     1.304    41.156     0.200
     1.391    43.207     0.200
     1.495    48.195     0.200
     1.539    49.145     0.200
     1.023    35.341     0.200
     1.065    34.811     0.200
     1.108    35.981     0.200
     1.195    39.881     0.200
     1.236    39.331     0.200
     1.236    39.661     0.200
     1.236    39.320     0.200
     1.236    39.401     0.200
     1.305    41.409     0.200
     1.305    41.741     0.200
     1.366    44.151     0.200
     1.366    45.911     0.200
     1.367    45.661     0.200
     1.367    42.721     0.200
     1.390    43.911     0.200
     1.456    46.111     0.200
     1.508    48.871     0.200
     1.508    49.501     0.200
     1.550    48.835     0.200
     1.550    50.661     0.200
     1.576    49.723     0.200
     2.627    75.581     0.200
     5.639   148.641     0.200
     6.814   178.791     0.200
     7.142   185.901     0.200
    11.375   293.111     0.200
    12.378   315.861     0.200
     1.025    32.793     0.200
     1.031    33.078     0.200
     1.046    33.184     0.200
     1.255    39.824     0.200
     1.348    42.273     0.200
     1.348    43.305     0.200
     1.384    42.922     0.200
     1.384    43.941     0.200
     1.394    44.062     0.200
     6.028   159.504     0.200
     0.938    30.059     0.200
     0.938    29.535     0.200
     0.975    31.070     0.200
     0.983    31.047     0.200
     1.031    32.426     0.200
     1.140    35.906     0.200
     1.140    35.344     0.200
     1.159    36.496     0.200
     1.159    34.996     0.200
     1.183    36.098     0.200
     1.183    38.688     0.200
     1.290    40.301     0.200
     1.468    43.426     0.200
     2.493    68.656     0.200
     3.641    96.207     0.200
     0.942    30.883     0.200
     0.946    30.516     0.200
     0.949    30.766     0.200
     0.949    30.383     0.200
     0.986    31.102     0.200
     0.994    31.453     0.200
     1.037    32.930     0.200
     1.131    36.344     0.200
     1.131    35.453     0.200
     1.168    37.117     0.200
     1.195    36.242     0.200
     1.302    40.297     0.200
     1.302    39.555     0.200
     0.938    30.656     0.200
     0.946    30.945     0.200
     0.946    30.250     0.200
     0.984    31.375     0.200
     0.995    31.125     0.200
     1.032    32.602     0.200
     1.109    33.914     0.200
     1.129    35.094     0.200
     1.171    36.438     0.200
     1.171    36.211     0.200
     1.302    40.227     0.200
     1.981    55.055     0.200
     0.937    30.094     0.200
     0.944    30.430     0.200
     0.981    31.648     0.200
     1.105    34.422     0.200
     1.167    36.703     0.200
     0.949    31.055     0.200
     0.952    31.094     0.200
     0.983    31.469     0.200
     1.145    35.844     0.200
     1.145    36.172     0.200
     1.155    35.586     0.200
     1.155    36.086     0.200
     1.294    39.891     0.200
     1.294    40.984     0.200
     0.941    30.133     0.200
     0.968    31.375     0.200
     1.047    32.391     0.200
     1.108    34.523     0.200
     1.191    37.500     0.200
     1.233    38.750     0.200
     1.254    39.453     0.200
     1.456    45.672     0.200
     0.935    30.609     0.200
     0.942    30.406     0.200
     0.992    31.289     0.200
     1.029    33.008     0.200
     1.107    34.023     0.200
     1.130    35.406     0.200
     1.169    36.836     0.200
     1.169    36.055     0.200
     1.193    36.742     0.200
     1.299    40.367     0.200
     2.461    68.469     0.200
     0.934    29.516     0.200
     0.942    30.180     0.200
     0.984    31.625     0.200
     1.017    32.555     0.200
     1.108    35.664     0.200
     1.108    35.055     0.200
     1.191    37.984     0.200
     1.191    37.109     0.200
     1.314    39.898     0.200
     1.480    46.289     0.200
     0.950    29.586     0.200
     0.957    30.258     0.200
     0.984    31.430     0.200
     1.189    36.219     0.200
     1.189    36.922     0.200
     1.266    39.555     0.200
     1.472    46.906     0.200
     1.559    44.055     0.200
     4.324   116.523     0.200
     0.942    30.062     0.200
     0.950    31.305     0.200
     0.950    30.281     0.200
     1.008    31.773     0.200
     1.008    32.648     0.200
     0.989    31.688     0.200
     1.028    32.711     0.200
     1.122    34.430     0.200
     1.184    37.773     0.200
     1.184    36.883     0.200
     1.115    35.414     0.200
     1.208    36.984     0.200
     1.620    46.992     0.200
     0.948    29.932     0.200
     0.952    30.811     0.200
     0.955    30.650     0.200
     0.955    30.475     0.200
     0.996    31.939     0.200
     1.014    32.000     0.200
     1.032    33.053     0.200
     1.127    35.121     0.200
     1.111    34.404     0.200
     1.189    37.480     0.200
     1.320    40.605     0.200
     1.320    40.602     0.200
     2.550    68.670     0.200
     6.555   166.771     0.200
     7.850   198.250     0.200
     0.942    29.758     0.200
     0.974    30.680     0.200
     0.976    30.926     0.200
     1.040    32.547     0.200
     1.087    33.301     0.200
     1.148    36.742     0.200
     1.148    36.359     0.200
     1.151    35.715     0.200
     1.196    37.016     0.200
     1.284    39.266     0.200
     0.926    29.893     0.200
     0.930    29.443     0.200
     0.933    29.723     0.200
     0.933    30.351     0.200
     0.970    30.953     0.200
     0.970    30.833     0.200
     0.968    31.119     0.200
     1.033    32.898     0.200
     1.084    34.253     0.200
     1.153    36.043     0.200
     1.153    36.316     0.200
     1.146    36.173     0.200
     1.146    36.583     0.200
     1.170    36.393     0.200
     1.277    39.213     0.200
     3.494    94.973     0.200
     3.552    94.213     0.200
     3.642    96.833     0.200
     3.730    99.193     0.200
     3.955   102.713     0.200
     0.933    29.514     0.200
     1.015    31.677     0.200
     1.127    37.031     0.200
     1.255    38.630     0.200
     1.337    41.486     0.200
     2.697    75.174     0.200
     0.975    31.953     0.200
     1.240    39.695     0.200
     1.240    39.352     0.200
     1.291    42.375     0.200
     1.280    41.914     0.200
     1.331    42.094     0.200
     1.360    42.344     0.200
     1.417    44.883     0.200
     1.441    45.812     0.200
     1.542    49.797     0.200
     1.555    50.211     0.200
     1.023    32.328     0.200
     0.993    31.898     0.200
     1.379    43.680     0.200
     1.481    45.781     0.200
     2.190    61.680     0.200
     3.088    81.625     0.200
     3.088    82.438     0.200
     0.859    27.516     0.200
     0.834    27.184     0.200
     0.915    28.699     0.200
     0.968    31.047     0.200
     1.093    33.137     0.200
     1.211    37.078     0.200
     1.224    37.941     0.200
     1.274    40.578     0.200
     1.315    42.008     0.200
     0.854    27.305     0.200
     0.897    28.562     0.200
     0.852    28.109     0.200
     1.196    36.984     0.200
     1.240    39.281     0.200
     1.275    40.359     0.200
     1.330    41.906     0.200
     0.825    27.133     0.200
     0.851    28.052     0.200
     0.964    31.849     0.200
     1.008    32.041     0.200
     1.039    32.468     0.200
     1.312    40.567     0.200
     0.987    33.016     0.200
     1.499    48.914     0.200
     1.004    32.922     0.200
     1.031    32.727     0.200
     1.064    34.016     0.200
     1.263    38.836     0.200
     1.263    39.664     0.200
     1.278    39.461     0.200
     0.839    26.822     0.200
     1.009    32.260     0.200
     1.062    32.822     0.200
     1.312    40.316     0.200
     1.377    42.629     0.200
     1.474    46.826     0.200
     2.627    73.037     0.200
     0.842    26.661     0.200
     0.807    25.911     0.200
     0.844    26.304     0.200
     0.830    29.201     0.200
     0.918    28.414     0.200
     0.936    29.241     0.200
     0.967    30.581     0.200
     1.024    31.960     0.200
     1.024    31.631     0.200
     0.985    31.591     0.200
     1.013    31.871     0.200
     1.029    32.461     0.200
     1.066    32.480     0.200
     1.063    33.221     0.200
     1.069    34.627     0.200
     1.094    34.802     0.200
     1.094    34.621     0.200
     1.151    34.991     0.200
     1.124    35.320     0.200
     1.156    36.832     0.200
     1.201    37.900     0.200
     1.207    38.312     0.200
     1.271    38.681     0.200
     1.259    39.880     0.200
     1.285    39.617     0.200
     1.285    39.221     0.200
     1.310    40.931     0.200
     1.361    42.863     0.200
     1.470    46.063     0.200
     0.868    29.459     0.200
     1.025    33.061     0.200
     1.130    35.641     0.200
     1.205    37.752     0.200
     1.217    39.332     0.200
     1.288    39.160     0.200
     1.383    43.080     0.200
     1.025    33.163     0.200
     1.025    33.284     0.200
     1.078    34.444     0.200
     1.088    34.658     0.200
     1.191    37.464     0.200
     1.196    37.504     0.200
     1.202    38.094     0.200
     1.234    39.734     0.200
     1.336    42.752     0.200
     1.375    42.678     0.200
     1.384    44.024     0.200
     1.435    45.408     0.200
     1.076    34.512     0.200
     1.076    34.789     0.200
     1.117    35.629     0.200
     1.181    37.641     0.200
     1.192    37.891     0.200
     1.192    37.473     0.200
     1.231    38.973     0.200
     1.242    40.109     0.200
     1.249    39.562     0.200
     1.257    39.340     0.200
     1.273    40.562     0.200
     1.330    43.008     0.200
     1.364    42.914     0.200
     1.385    44.352     0.200
     1.444    45.961     0.200
     1.518    48.695     0.200
     0.807    26.724     0.200
     0.807    26.071     0.200
     0.834    27.089     0.200
     0.881    28.434     0.200
     0.984    31.028     0.200
     0.999    31.669     0.200
     0.990    32.408     0.200
     0.990    31.709     0.200
     1.094    34.118     0.200
     1.077    35.509     0.200
     1.077    33.790     0.200
     1.111    36.019     0.200
     1.165    36.479     0.200
     1.209    38.169     0.200
     1.250    37.744     0.200
     1.250    37.799     0.200
     1.059    32.406     0.200
     1.002    31.992     0.200
     1.051    32.750     0.200
     1.233    38.539     0.200
     1.454    42.703     0.200
     0.749    23.777     0.200
     0.910    29.953     0.200
     0.979    31.266     0.200
     1.089    33.145     0.200
     1.189    36.910     0.200
     1.225    38.469     0.200
     1.242    38.438     0.200
     1.285    40.164     0.200
     1.310    40.457     0.200
     1.384    42.691     0.200
     6.894   179.488     0.200
     0.842    26.885     0.200
     0.842    27.029     0.200
     0.832    27.625     0.200
     0.807    26.664     0.200
     0.846    28.545     0.200
     0.883    27.705     0.200
     0.858    27.465     0.200
     0.853    27.574     0.200
     0.852    27.295     0.200
     0.895    30.264     0.200
     0.895    30.725     0.200
     0.902    28.254     0.200
     0.905    29.494     0.200
     1.026    31.525     0.200
     1.281    39.525     0.200
     1.298    41.834     0.200
     1.385    44.547     0.200
     1.489    46.654     0.200
    21.661   539.279     0.200
     0.954    29.570     0.200
     0.963    29.898     0.200
     0.968    30.695     0.200
     1.078    33.461     0.200
     1.233    38.164     0.200
     1.282    39.172     0.200
     0.930    28.859     0.200
     1.022    31.543     0.200
     1.132    34.926     0.200
     1.190    35.961     0.200
     1.310    39.156     0.200
     2.509    67.934     0.200
     0.805    25.930     0.200
     0.808    26.051     0.200
     0.808    27.891     0.200
     0.856    27.180     0.200
     0.863    27.703     0.200
     0.868    28.191     0.200
     0.871    27.945     0.200
     0.871    28.051     0.200
     0.879    28.711     0.200
     0.907    29.062     0.200
     0.916    29.211     0.200
     0.921    29.852     0.200
     1.011    31.980     0.200
     1.037    33.680     0.200
     1.057    33.277     0.200
     1.116    35.133     0.200
     1.125    35.285     0.200
     1.125    35.590     0.200
     1.164    36.891     0.200
     1.241    39.402     0.200
     1.305    41.668     0.200
     1.355    43.262     0.200
     0.844    28.180     0.200
     0.863    28.531     0.200
     0.877    28.648     0.200
     0.945    31.559     0.200
     0.934    31.520     0.200
     1.007    31.602     0.200
     0.978    32.375     0.200
     1.059    33.371     0.200
     1.225    37.656     0.200
     1.255    39.852     0.200
     1.371    43.691     0.200
     1.473    47.227     0.200
     0.850    28.632     0.200
     0.866    28.452     0.200
     0.879    29.132     0.200
     0.940    31.182     0.200
     0.946    31.412     0.200
     0.985    31.756     0.200
     1.036    32.861     0.200
     1.057    33.892     0.200
     1.117    36.702     0.200
     1.161    36.852     0.200
     1.210    38.332     0.200
     1.221    38.672     0.200
     1.222    38.786     0.200
     1.257    41.820     0.200
     1.376    45.450     0.200
     0.851    28.339     0.200
     0.875    28.219     0.200
     0.889    29.259     0.200
     0.940    31.108     0.200
     0.950    31.249     0.200
     0.959    31.659     0.200
     0.968    32.080     0.200
     1.054    32.948     0.200
     1.074    34.119     0.200
     1.074    34.738     0.200
     1.088    34.249     0.200
     1.179    37.259     0.200
     1.268    40.770     0.200
     1.379    44.525     0.200
     0.847    27.618     0.200
     0.863    27.958     0.200
     0.876    28.468     0.200
     0.942    30.748     0.200
     1.000    31.168     0.200
     1.034    32.058     0.200
     1.054    33.088     0.200
     1.062    34.258     0.200
     1.109    34.188     0.200
     1.219    37.198     0.200
     1.257    38.228     0.200
     1.374    43.135     0.200
     0.847    27.938     0.200
     0.863    27.999     0.200
     0.876    28.619     0.200
     0.937    30.579     0.200
     0.943    30.559     0.200
     0.943    30.259     0.200
     0.985    31.049     0.200
     1.001    31.309     0.200
     1.035    33.009     0.200
     1.055    33.188     0.200
     1.062    34.319     0.200
     1.108    34.469     0.200
     1.115    34.639     0.200
     1.115    36.199     0.200
     1.160    35.688     0.200
     1.219    37.329     0.200
     1.220    37.205     0.200
     1.220    37.479     0.200
     1.373    41.251     0.200
     1.662    47.842     0.200
     0.843    27.105     0.200
     0.843    27.422     0.200
     0.879    28.734     0.200
     0.890    29.082     0.200
     0.903    29.453     0.200
     0.932    30.914     0.200
     0.951    31.562     0.200
     0.953    31.355     0.200
     1.033    33.414     0.200
     1.033    34.113     0.200
     1.310    40.137     0.200
     0.889    29.344     0.200
     0.940    30.703     0.200
     0.977    31.133     0.200
     0.987    32.031     0.200
     0.981    30.875     0.200
     0.981    31.078     0.200
     1.031    32.727     0.200
     1.050    34.031     0.200
     1.079    33.727     0.200
     1.088    33.633     0.200
     1.154    37.047     0.200
     1.192    36.266     0.200
     1.192    36.461     0.200
     1.219    40.000     0.200
     1.306    40.617     0.200
     0.892    29.461     0.200
     0.938    30.680     0.200
     0.952    30.312     0.200
     0.976    31.008     0.200
     0.985    30.953     0.200
     0.985    31.883     0.200
     0.979    30.953     0.200
     1.032    32.750     0.200
     1.011    31.922     0.200
     1.048    33.570     0.200
     1.068    34.711     0.200
     1.086    33.531     0.200
     1.077    33.492     0.200
     1.154    36.883     0.200
     1.191    36.352     0.200
     1.191    36.250     0.200
     1.191    37.758     0.200
     1.215    37.211     0.200
     1.215    37.602     0.200
     1.215    38.367     0.200
     1.219    39.172     0.200
     1.271    38.172     0.200
     1.304    40.617     0.200
     1.501    48.258     0.200
     0.866    28.367     0.200
     0.870    27.906     0.200
     0.899    28.996     0.200
     0.906    28.766     0.200
     1.036    32.926     0.200
     1.022    32.742     0.200
     1.064    33.277     0.200
     1.119    35.426     0.200
     1.181    37.035     0.200
     1.248    39.590     0.200
     0.880    28.766     0.200
     0.900    30.180     0.200
     0.972    31.172     0.200
     0.980    32.141     0.200
     0.981    31.609     0.200
     0.988    31.672     0.200
     0.992    32.109     0.200
     1.081    34.391     0.200
     1.084    33.758     0.200
     1.082    34.906     0.200
     1.084    36.406     0.200
     1.122    35.977     0.200
     1.179    36.836     0.200
     1.197    36.883     0.200
     1.216    38.422     0.200
     1.232    39.992     0.200
     1.237    38.828     0.200
     1.237    38.008     0.200
     1.292    40.547     0.200
     1.350    43.492     0.200
     0.781    25.457     0.200
     0.803    26.057     0.200
     0.817    28.157     0.200
     0.843    27.297     0.200
     0.855    27.277     0.200
     0.855    26.807     0.200
     0.868    28.007     0.200
     0.914    29.277     0.200
     0.925    28.877     0.200
     0.928    29.027     0.200
     1.076    34.287     0.200
     1.161    36.927     0.200
     1.235    38.467     0.200
     1.321    40.777     0.200
     1.304    41.347     0.200
     1.444    44.587     0.200
     1.457    45.019     0.200
     0.780    25.102     0.200
     0.809    25.602     0.200
     0.829    26.492     0.200
     0.829    25.914     0.200
     0.837    27.125     0.200
     0.837    27.250     0.200
     0.900    28.477     0.200
     0.908    28.391     0.200
     0.908    28.594     0.200
     0.962    31.625     0.200
     1.010    31.609     0.200
     1.094    34.180     0.200
     1.185    36.633     0.200
     1.207    37.773     0.200
     1.317    41.727     0.200
     1.340    43.000     0.200
     1.434    45.875     0.200
     1.469    46.070     0.200
     3.819   103.391     0.200
     0.842    28.115     0.200
     0.904    29.995     0.200
     0.908    29.344     0.200
     1.008    32.093     0.200
     1.028    32.494     0.200
     1.023    32.298     0.200
     1.103    36.135     0.200
     1.152    36.979     0.200
     1.218    37.695     0.200
     1.270    39.544     0.200
     1.435    45.861     0.200
     0.754    24.168     0.200
     0.754    23.952     0.200
     0.754    24.249     0.200
     0.788    27.648     0.200
     0.789    26.929     0.200
     0.778    25.188     0.200
     0.777    25.819     0.200
     0.805    25.829     0.200
     0.807    27.519     0.200
     0.859    26.769     0.200
     0.877    27.418     0.200
     0.876    27.769     0.200
     1.013    32.695     0.200
     1.229    38.277     0.200
     1.414    44.126     0.200
     0.844    27.702     0.200
     0.941    30.518     0.200
     0.968    31.222     0.200
     1.003    32.036     0.200
     1.190    38.156     0.200
     1.276    39.605     0.200
     1.457    46.578     0.200
     2.854    77.366     0.200
     0.841    28.195     0.200
     0.908    30.078     0.200
     0.903    29.031     0.200
     0.903    29.625     0.200
     0.942    30.211     0.200
     1.007    32.125     0.200
     1.019    32.219     0.200
     1.033    32.789     0.200
     1.099    35.789     0.200
     1.151    36.742     0.200
     1.222    37.656     0.200
     1.430    45.789     0.200
     0.802    25.727     0.200
     0.800    26.141     0.200
     0.831    26.992     0.200
     0.834    27.180     0.200
     0.843    27.219     0.200
     0.880    28.391     0.200
     0.918    29.328     0.200
     0.913    30.336     0.200
     0.929    30.266     0.200
     1.030    32.461     0.200
     1.036    32.078     0.200
     1.107    35.008     0.200
     1.250    38.117     0.200
     1.379    43.977     0.200
     2.441    68.328     0.200
     0.978    31.681     0.200
     1.012    32.547     0.200
     1.020    32.756     0.200
     1.029    33.239     0.200
     1.073    35.951     0.200
     1.165    36.701     0.200
     1.165    36.580     0.200
     1.326    42.747     0.200
     1.325    42.111     0.200
     1.406    45.423     0.200
     1.415    45.599     0.200
     1.520    47.095     0.200
     1.561    49.126     0.200
     2.265    64.916     0.200
     3.711   101.355     0.200
     4.459   121.806     0.200
     4.947   133.595     0.200
     0.803    26.328     0.200
     0.829    26.672     0.200
     0.835    27.941     0.200
     0.894    28.211     0.200
     0.863    27.711     0.200
     0.908    28.852     0.200
     0.890    28.969     0.200
     0.992    31.672     0.200
     1.039    33.148     0.200
     1.039    35.230     0.200
     1.052    33.879     0.200
     0.787    27.277     0.200
     0.814    26.137     0.200
     0.830    27.106     0.200
     0.837    27.207     0.200
     0.850    27.887     0.200
     0.902    28.687     0.200
     0.902    31.367     0.200
     0.922    29.747     0.200
     0.961    30.459     0.200
     0.972    30.817     0.200
     0.972    30.651     0.200
     0.991    31.387     0.200
     0.993    31.207     0.200
     1.036    32.137     0.200
     1.060    32.681     0.200
     1.077    33.137     0.200
     1.123    35.367     0.200
     1.126    35.637     0.200
     1.192    38.267     0.200
     1.207    36.827     0.200
     1.221    37.237     0.200
     1.332    41.727     0.200
     1.348    41.943     0.200
     1.365    41.757     0.200
     1.409    43.697     0.200
     1.409    43.562     0.200
     1.456    43.407     0.200
     0.848    27.340     0.200
     0.867    27.859     0.200
     0.878    28.301     0.200
     0.895    29.629     0.200
     0.931    29.828     0.200
     0.929    29.668     0.200
     4.787   127.371     0.200
     0.862    29.180     0.200
     0.989    32.195     0.200
     0.810    26.469     0.200
     0.856    28.359     0.200
     0.872    28.070     0.200
     0.863    29.320     0.200
     0.891    28.828     0.200
     0.957    30.871     0.200
     1.005    31.828     0.200
     0.993    31.660     0.200
     1.028    32.141     0.200
     1.051    33.410     0.200
     0.861    29.219     0.200
     0.890    29.439     0.200
     0.899    29.889     0.200
     0.898    28.969     0.200
     0.896    29.109     0.200
     0.902    30.939     0.200
     0.810    26.838     0.200
     0.851    27.559     0.200
     0.867    28.549     0.200
     0.867    28.738     0.200
     0.916    30.197     0.200
     0.717    22.742     0.200
     0.726    23.641     0.200
     0.752    24.023     0.200
     0.768    24.781     0.200
     0.782    25.164     0.200
     0.785    24.594     0.200
     0.810    25.625     0.200
     0.852    26.742     0.200
     0.846    26.406     0.200
     0.875    26.906     0.200
     0.895    27.797     0.200
     0.899    27.461     0.200
     0.974    29.906     0.200
     0.971    30.086     0.200
     1.014    31.781     0.200
     1.018    31.906     0.200
     1.006    31.094     0.200
     1.027    31.773     0.200
     1.023    32.484     0.200
     1.039    32.375     0.200
     1.040    32.211     0.200
     1.071    34.977     0.200
     1.072    33.078     0.200
     0.831    28.031     0.200
     0.967    31.910     0.200
     0.983    32.281     0.200
     0.987    32.531     0.200
     1.011    32.750     0.200
     0.899    30.039     0.200
     0.904    29.621     0.200
     0.911    30.840     0.200
     0.987    31.699     0.200
     0.840    28.000     0.200
     0.845    27.340     0.200
     0.905    29.820     0.200
     0.914    29.379     0.200
     1.075    34.102     0.200
     1.288    39.801     0.200
     0.827    27.758     0.200
     0.833    27.633     0.200
     0.884    29.312     0.200
     0.899    29.633     0.200
     0.973    31.359     0.200
     0.974    32.141     0.200
     0.993    32.539     0.200
     0.965    32.141     0.200
     0.975    31.621     0.200
     1.071    34.082     0.200
     1.075    34.660     0.200
     1.094    35.621     0.200
     1.285    39.652     0.200
     1.388    44.781     0.200
     1.394    44.172     0.200
     1.490    46.762     0.200
     1.534    47.703     0.200
     0.834    27.352     0.200
     0.907    29.141     0.200
     0.910    29.125     0.200
     0.947    30.367     0.200
     0.970    30.867     0.200
     0.970    30.562     0.200
     0.994    31.766     0.200
     1.079    33.875     0.200
     1.124    34.906     0.200
     0.938    30.875     0.200
     0.985    32.445     0.200
     0.907    30.156     0.200
     0.946    30.594     0.200
     0.946    30.367     0.200
     0.976    30.938     0.200
     0.981    31.500     0.200
     0.993    31.820     0.200
     0.999    31.586     0.200
     1.084    33.867     0.200
     1.204    37.281     0.200
     0.821    26.820     0.200
     0.834    27.516     0.200
     0.887    28.406     0.200
     0.907    28.594     0.200
     0.971    30.289     0.200
     1.000    32.047     0.200
     1.001    31.047     0.200
     1.084    33.719     0.200
     1.124    34.344     0.200
     1.142    36.125     0.200
     1.157    36.094     0.200
     1.167    36.516     0.200
     0.827    28.037     0.200
     0.881    29.297     0.200
     0.877    28.897     0.200
     0.897    29.567     0.200
     0.901    28.901     0.200
     0.901    29.787     0.200
     0.938    30.967     0.200
     1.087    33.977     0.200
     1.119    34.997     0.200
     1.157    36.607     0.200
    10.063   258.876     0.200
     0.836    27.010     0.200
     0.889    28.410     0.200
     0.892    29.174     0.200
     0.931    29.580     0.200
     0.931    29.800     0.200
     0.969    30.190     0.200
     0.986    31.300     0.200
     1.094    33.890     0.200
     1.116    33.970     0.200
     0.890    28.457     0.200
     0.912    29.226     0.200
     0.912    29.027     0.200
     0.830    26.722     0.200
     0.834    26.932     0.200
     0.881    28.722     0.200
     0.892    28.531     0.200
     0.895    28.771     0.200
     0.885    28.211     0.200
     0.935    30.132     0.200
     0.975    31.441     0.200
     0.977    31.262     0.200
     1.052    32.432     0.200
     1.084    34.241     0.200
     1.098    35.262     0.200
     1.122    34.802     0.200
     1.317    41.531     0.200
     0.845    27.699     0.200
     0.900    29.000     0.200
     0.907    29.242     0.200
     0.948    30.449     0.200
     0.907    28.668     0.200
     0.843    27.406     0.200
     0.878    28.266     0.200
     0.905    29.391     0.200
     0.908    29.438     0.200
     0.908    29.211     0.200
     1.097    34.594     0.200
     1.135    35.188     0.200
     1.126    34.719     0.200
     1.144    35.648     0.200
     0.832    27.453     0.200
     0.832    27.219     0.200
     0.851    27.664     0.200
     0.865    28.898     0.200
     0.819    26.422     0.200
     0.884    28.641     0.200
     0.894    29.617     0.200
     0.894    29.242     0.200
     0.922    30.422     0.200
     0.941    31.539     0.200
     0.944    30.789     0.200
     0.932    31.078     0.200
     1.003    32.109     0.200
     1.024    34.328     0.200
     1.046    32.633     0.200
     1.231    37.508     0.200
     0.825    26.891     0.200
     0.824    26.898     0.200
     0.824    26.727     0.200
     0.880    29.023     0.200
     0.878    28.641     0.200
     0.910    30.234     0.200
     1.005    32.172     0.200
     1.054    34.844     0.200
     1.202    36.453     0.200
     0.842    27.475     0.200
     0.788    26.359     0.200
     0.800    26.602     0.200
     0.827    26.055     0.200
     0.855    26.281     0.200
     0.895    27.969     0.200
     0.912    28.391     0.200
     0.912    28.930     0.200
     0.924    28.617     0.200
     0.923    29.602     0.200
     0.936    28.695     0.200
     0.940    30.297     0.200
     0.955    31.422     0.200
     1.172    34.797     0.200
     1.155    35.570     0.200
     1.145    35.688     0.200
     0.824    27.121     0.200
     0.826    27.508     0.200
     0.835    27.398     0.200
     0.869    28.430     0.200
     0.885    29.500     0.200
     0.885    29.430     0.200
     0.907    29.711     0.200
     0.914    30.621     0.200
     0.920    29.758     0.200
     0.933    30.078     0.200
     1.009    32.281     0.200
     0.849    27.781     0.200
     0.825    27.180     0.200
     0.852    27.688     0.200
     0.866    27.891     0.200
     0.884    29.086     0.200
     0.883    28.859     0.200
     0.875    29.375     0.200
     0.912    30.172     0.200
     0.919    29.680     0.200
     0.933    30.320     0.200
     0.932    30.922     0.200
     0.940    30.234     0.200
     0.975    30.977     0.200
     1.014    32.008     0.200
     1.004    32.234     0.200
     1.072    33.234     0.200
     1.134    35.211     0.200
     0.821    26.602     0.200
     0.823    27.082     0.200
     0.838    26.941     0.200
     0.845    27.352     0.200
     0.860    27.949     0.200
     0.871    28.852     0.200
     0.890    29.539     0.200
     0.896    29.801     0.200
     0.903    29.980     0.200
     0.903    30.121     0.200
     0.920    30.230     0.200
     0.923    30.750     0.200
     0.940    30.199     0.200
     0.936    30.309     0.200
     0.987    31.449     0.200
     1.003    32.531     0.200
     1.026    32.660     0.200
     1.031    33.051     0.200
     1.034    32.379     0.200
     1.093    34.031     0.200
     1.152    35.469     0.200
     1.181    37.891     0.200
     1.196    38.668     0.200
     1.201    38.078     0.200
     1.234    37.570     0.200
     1.276    39.281     0.200
     1.324    40.379     0.200
     0.739    25.078     0.200
     0.763    25.438     0.200
     0.795    24.977     0.200
     0.773    24.848     0.200
     0.806    26.496     0.200
     0.799    25.105     0.200
     0.824    25.969     0.200
     0.799    27.266     0.200
     0.813    26.797     0.200
     0.831    26.887     0.200
     0.833    26.906     0.200
     0.873    27.258     0.200
     0.880    27.578     0.200
     0.884    28.777     0.200
     0.884    28.078     0.200
     0.897    28.938     0.200
     0.909    29.809     0.200
     0.902    28.789     0.200
     0.924    29.277     0.200
     0.951    31.559     0.200
     0.959    29.898     0.200
     0.995    30.449     0.200
     1.007    30.688     0.200
     0.821    26.594     0.200
     0.825    27.094     0.200
     0.829    26.961     0.200
     0.831    27.695     0.200
     0.831    26.781     0.200
     0.855    27.617     0.200
     0.882    28.344     0.200
     0.883    29.031     0.200
     0.883    28.891     0.200
     0.894    29.031     0.200
     0.903    29.523     0.200
     0.899    28.773     0.200
     0.906    29.750     0.200
     0.914    30.211     0.200
     0.912    30.305     0.200
     0.934    30.445     0.200
     0.960    30.773     0.200
     1.009    31.906     0.200
     1.048    33.102     0.200
     1.064    33.352     0.200
     1.064    33.867     0.200
     1.079    35.102     0.200
     1.113    34.602     0.200
     1.099    35.031     0.200
     1.173    36.914     0.200
     1.170    37.555     0.200
     1.180    36.992     0.200
     1.188    37.891     0.200
     1.203    36.812     0.200
     1.210    37.797     0.200
     1.223    38.633     0.200
     1.225    38.703     0.200
     1.295    39.367     0.200
     1.304    40.547     0.200
     1.361    42.047     0.200
     1.467    43.766     0.200
     0.803    26.652     0.200
     0.812    26.021     0.200
     0.818    26.362     0.200
     0.822    26.632     0.200
     0.810    26.852     0.200
     0.828    26.952     0.200
     0.830    26.996     0.200
     0.852    27.342     0.200
     0.854    27.602     0.200
     0.878    28.042     0.200
     0.912    30.252     0.200
     0.894    28.842     0.200
     0.912    30.052     0.200
     0.900    29.112     0.200
     0.906    29.482     0.200
     0.930    29.932     0.200
     0.932    30.812     0.200
     0.943    30.342     0.200
     1.005    31.252     0.200
     1.012    32.412     0.200
     1.012    32.021     0.200
     1.051    32.512     0.200
     1.049    33.362     0.200
     0.797    26.031     0.200
     0.831    26.682     0.200
     0.849    27.332     0.200
     0.863    27.383     0.200
     0.852    28.271     0.200
     0.885    28.223     0.200
     0.865    28.252     0.200
     0.879    28.633     0.200
     0.886    28.621     0.200
     0.898    29.312     0.200
     0.898    29.291     0.200
     0.908    29.611     0.200
     0.926    29.711     0.200
     0.940    30.133     0.200
     0.953    30.111     0.200
     0.976    31.133     0.200
     0.979    31.352     0.200
     0.978    31.211     0.200
     0.977    32.791     0.200
     0.988    32.152     0.200
     1.043    32.342     0.200
     1.027    32.562     0.200
     1.042    32.143     0.200
     1.083    35.832     0.200
     1.070    33.562     0.200
     1.096    33.633     0.200
     1.145    34.883     0.200
     1.150    36.312     0.200
     1.172    35.691     0.200
     1.171    36.803     0.200
     1.187    36.393     0.200
     1.184    37.262     0.200
     1.219    37.041     0.200
     1.238    38.102     0.200
     1.277    38.461     0.200
     1.277    38.961     0.200
     1.278    38.492     0.200
     1.309    39.842     0.200
     1.320    39.701     0.200
     1.373    42.781     0.200
     7.832   202.467     0.200
    10.954   278.473     0.200
     0.813    27.125     0.200
     0.807    26.264     0.200
     0.880    28.295     0.200
     0.898    28.955     0.200
     0.906    29.305     0.200
     0.921    29.234     0.200
     0.908    28.605     0.200
     0.928    30.275     0.200
     0.985    30.744     0.200
     1.104    34.195     0.200
     0.800    26.195     0.200
     0.808    25.875     0.200
     0.808    25.906     0.200
     0.815    26.477     0.200
     0.834    26.922     0.200
     0.862    28.383     0.200
     0.862    28.219     0.200
     0.874    28.383     0.200
     0.885    29.492     0.200
     0.893    29.703     0.200
     0.881    28.203     0.200
     0.913    29.672     0.200
     1.097    33.398     0.200
     1.074    34.625     0.200
     1.107    35.203     0.200
     1.179    38.547     0.200
     1.204    36.852     0.200
     1.236    37.477     0.200
     0.826    27.023     0.200
     0.838    27.194     0.200
     0.866    29.074     0.200
     0.872    29.174     0.200
     0.887    29.784     0.200
     0.885    30.164     0.200
     0.967    31.773     0.200
     0.963    31.214     0.200
     0.960    31.364     0.200
     0.999    31.444     0.200
     1.020    32.273     0.200
     1.012    33.034     0.200
     1.012    32.864     0.200
     1.043    32.874     0.200
     0.824    27.062     0.200
     0.826    27.133     0.200
     0.831    27.363     0.200
     0.836    27.332     0.200
     0.846    28.592     0.200
     0.865    29.082     0.200
     0.884    29.682     0.200
     0.892    29.252     0.200
     0.919    29.213     0.200
     0.938    29.912     0.200
     0.961    31.912     0.200
     0.958    31.443     0.200
     0.961    30.432     0.200
     0.966    32.012     0.200
     0.973    31.053     0.200
     0.998    32.152     0.200
     1.000    31.352     0.200
     0.999    32.482     0.200
     1.011    32.623     0.200
     1.011    32.412     0.200
     1.015    33.152     0.200
     1.044    32.473     0.200
     1.050    33.492     0.200
     0.859    29.025     0.200
     0.886    28.736     0.200
     1.012    32.045     0.200
     1.006    32.875     0.200
     1.006    32.465     0.200
     1.035    32.785     0.200
     1.040    32.576     0.200
     1.048    33.275     0.200
     1.167    36.096     0.200
     1.216    37.795     0.200
     1.266    39.965     0.200
     1.344    42.395     0.200
     0.828    26.869     0.200
     0.831    27.129     0.200
     0.844    28.311     0.200
     0.856    27.609     0.200
     0.859    28.600     0.200
     0.879    29.459     0.200
     0.887    28.459     0.200
     0.929    29.680     0.200
     0.961    31.240     0.200
     0.991    31.299     0.200
     0.992    32.189     0.200
     1.006    32.311     0.200
     1.006    32.561     0.200
     1.025    32.869     0.200
     1.034    32.641     0.200
     1.039    32.879     0.200
     1.070    34.641     0.200
     1.085    34.090     0.200
     1.131    35.529     0.200
     1.215    38.100     0.200
     1.266    39.789     0.200
     0.818    26.969     0.200
     0.814    28.086     0.200
     0.833    27.070     0.200
     0.839    27.047     0.200
     0.858    27.500     0.200
     0.864    28.188     0.200
     0.887    28.938     0.200
     0.893    28.500     0.200
     0.893    29.102     0.200
     0.904    28.906     0.200
     0.918    29.719     0.200
     0.795    25.949     0.200
     0.799    25.719     0.200
     0.797    27.277     0.200
     0.811    27.070     0.200
     0.822    26.738     0.200
     0.824    26.867     0.200
     0.824    26.617     0.200
     0.836    26.957     0.200
     0.846    26.980     0.200
     0.911    28.969     0.200
     0.905    29.457     0.200
     0.908    29.090     0.200
     0.920    29.801     0.200
     1.003    31.828     0.200
     1.005    32.270     0.200
     1.015    31.758     0.200
     1.124    35.078     0.200
     0.750    24.227     0.200
     0.752    24.337     0.200
     0.743    24.147     0.200
     0.758    24.507     0.200
     0.794    25.037     0.200
     0.782    25.037     0.200
     0.823    26.227     0.200
     0.762    24.827     0.200
     0.833    26.167     0.200
     0.839    26.417     0.200
     0.780    26.097     0.200
     0.830    25.987     0.200
     0.854    27.147     0.200
     0.834    26.727     0.200
     0.830    26.117     0.200
     0.878    27.447     0.200
     0.878    27.577     0.200
     0.873    29.397     0.200
     0.807    27.337     0.200
     0.888    27.447     0.200
     0.917    28.157     0.200
     0.916    28.438     0.200
     0.922    28.347     0.200
     0.922    28.477     0.200
     0.932    29.697     0.200
     0.943    29.477     0.200
     0.943    29.747     0.200
     0.897    28.287     0.200
     0.903    28.897     0.200
     0.896    29.637     0.200
     0.904    29.137     0.200
     0.925    28.847     0.200
     1.182    36.227     0.200
     0.784    25.926     0.200
     0.779    25.625     0.200
     0.789    25.098     0.200
     0.797    25.988     0.200
     0.816    26.148     0.200
     0.819    26.688     0.200
     0.819    27.008     0.200
     0.831    26.066     0.200
     0.820    25.918     0.200
     0.841    27.316     0.200
     0.822    26.547     0.200
     0.837    27.207     0.200
     0.852    27.336     0.200
     0.840    26.918     0.200
     0.855    27.648     0.200
     0.854    27.918     0.200
     0.882    28.738     0.200
     0.871    27.477     0.200
     0.873    29.086     0.200
     0.885    29.656     0.200
     0.895    28.367     0.200
     0.918    30.156     0.200
     0.912    28.926     0.200
     0.921    30.926     0.200
     0.981    31.117     0.200
     1.011    32.215     0.200
     0.808    27.172     0.200
     0.823    28.453     0.200
     0.830    26.859     0.200
     0.829    27.055     0.200
     0.858    28.133     0.200
     0.862    27.570     0.200
     0.879    27.828     0.200
     0.891    28.531     0.200
     0.890    28.344     0.200
     0.918    29.234     0.200
     0.926    29.312     0.200
     0.930    29.609     0.200
     0.972    31.375     0.200
     0.981    30.539     0.200
     0.981    30.859     0.200
     0.985    30.930     0.200
     0.999    30.883     0.200
     1.018    31.930     0.200
     1.044    33.141     0.200
     1.061    33.555     0.200
     1.088    33.742     0.200
     1.088    34.289     0.200
     1.114    34.359     0.200
     1.139    35.469     0.200
     1.174    37.750     0.200
     1.169    36.078     0.200
     1.211    36.875     0.200
     1.211    36.883     0.200
     1.228    37.250     0.200
     1.228    37.453     0.200
     1.383    41.602     0.200
     1.446    45.391     0.200
     0.814    26.512     0.200
     0.825    27.312     0.200
     0.815    26.793     0.200
     0.848    29.051     0.200
     0.842    27.863     0.200
     0.837    27.902     0.200
     0.869    29.223     0.200
     0.866    27.824     0.200
     0.878    27.973     0.200
     0.860    28.461     0.200
     0.871    28.133     0.200
     0.848    28.484     0.200
     0.887    28.754     0.200
     0.890    28.902     0.200
     0.906    30.191     0.200
     0.997    31.082     0.200
     1.048    33.594     0.200
     1.110    34.062     0.200
     1.113    35.414     0.200
     1.117    35.191     0.200
     1.290    41.641     0.200
     1.361    40.762     0.200
     1.514    45.902     0.200
     0.774    25.175     0.200
     0.774    25.365     0.200
     0.788    25.655     0.200
     0.790    25.786     0.200
     0.824    27.005     0.200
     0.813    26.605     0.200
     0.810    26.335     0.200
     0.827    27.545     0.200
     0.821    27.305     0.200
     0.819    26.325     0.200
     0.828    26.175     0.200
     0.821    26.605     0.200
     0.820    26.456     0.200
     0.846    28.295     0.200
     0.831    27.625     0.200
     0.855    27.105     0.200
     0.865    29.175     0.200
     0.859    27.476     0.200
     0.873    27.195     0.200
     0.885    28.945     0.200
     0.877    28.485     0.200
     0.869    28.175     0.200
     0.903    30.726     0.200
     0.894    28.416     0.200
     0.887    28.246     0.200
     0.894    28.555     0.200
     0.913    29.845     0.200
     0.942    30.045     0.200
     0.977    29.905     0.200
     0.960    31.706     0.200
     1.011    30.885     0.200
     1.058    35.295     0.200
     1.096    33.965     0.200
     1.412    44.325     0.200
     1.453    45.226     0.200
     5.152   139.670     0.200
     0.827    28.006     0.200
     0.827    27.246     0.200
     0.858    28.057     0.200
     0.857    28.016     0.200
     0.889    29.656     0.200
     0.889    29.826     0.200
     0.913    29.316     0.200
     0.990    32.186     0.200
     1.042    32.727     0.200
     1.058    33.217     0.200
     1.079    34.846     0.200
     1.092    34.326     0.200
     1.092    34.596     0.200
     1.154    36.717     0.200
     1.183    38.205     0.200
     1.222    37.307     0.200
     1.214    38.826     0.200
     1.368    41.785     0.200
     0.824    27.127     0.200
     0.824    27.152     0.200
     0.860    27.922     0.200
     0.854    27.982     0.200
     0.861    28.562     0.200
     0.887    29.652     0.200
     0.885    29.762     0.200
     0.934    30.031     0.200
     0.940    31.312     0.200
     1.044    32.973     0.200
     1.094    34.812     0.200
     1.156    36.861     0.200
     1.223    37.352     0.200
     1.217    38.762     0.200
     0.842    27.533     0.200
     0.844    27.547     0.200
     0.844    27.533     0.200
     0.863    27.812     0.200
     0.889    28.463     0.200
     0.889    28.562     0.200
     0.883    29.303     0.200
     0.886    29.414     0.200
     0.904    29.863     0.200
     0.905    29.943     0.200
     0.917    29.193     0.200
     0.929    30.072     0.200
     1.042    32.254     0.200
     1.038    32.344     0.200
     1.097    33.863     0.200
     0.807    26.348     0.200
     0.805    25.928     0.200
     0.824    27.607     0.200
     0.837    26.855     0.200
     0.847    26.947     0.200
     0.847    27.227     0.200
     0.861    27.338     0.200
     0.884    28.707     0.200
     0.899    29.967     0.200
     0.916    29.977     0.200
     0.910    29.357     0.200
     0.918    30.076     0.200
     0.926    29.727     0.200
     1.204    36.447     0.200
     1.204    38.137     0.200
     1.204    39.018     0.200
    10.924   279.666     0.200
     0.778    25.016     0.200
     0.789    25.617     0.200
     0.787    25.738     0.200
     0.800    25.375     0.200
     0.790    25.848     0.200
     0.832    26.926     0.200
     0.853    26.656     0.200
     0.899    27.969     0.200
     0.898    28.535     0.200
     0.905    28.168     0.200
     0.894    28.766     0.200
     0.885    28.195     0.200
     0.909    28.207     0.200
     0.905    28.285     0.200
     0.977    30.277     0.200
     1.199    35.945     0.200
     1.248    38.355     0.200
     1.300    38.777     0.200
     1.319    40.875     0.200
     1.422    43.195     0.200
     0.825    26.695     0.200
     0.831    26.988     0.200
     0.848    27.418     0.200
     0.861    28.477     0.200
     0.979    30.598     0.200
     1.013    31.809     0.200
     0.800    26.508     0.200
     0.834    27.316     0.200
     0.822    27.738     0.200
     0.844    26.988     0.200
     0.921    30.859     0.200
     0.908    28.629     0.200
     0.935    30.707     0.200
     0.982    31.020     0.200
     1.044    32.668     0.200
     1.087    34.199     0.200
     1.093    33.559     0.200
     1.132    35.457     0.200
     1.175    36.238     0.200
     1.175    37.840     0.200
     1.192    36.250     0.200
     1.212    37.098     0.200
     0.827    27.016     0.200
     0.953    30.539     0.200
     1.013    32.375     0.200
     1.124    35.570     0.200
     1.167    35.859     0.200
     1.185    37.367     0.200
     1.265    40.391     0.200
     0.887    29.070     0.200
     0.974    30.820     0.200
     1.014    32.055     0.200
     1.070    37.039     0.200
     1.125    35.531     0.200
     0.828    26.672     0.200
     0.839    28.406     0.200
     0.833    26.984     0.200
     0.853    27.891     0.200
     0.856    27.594     0.200
     0.893    29.180     0.200
     0.914    30.883     0.200
     0.940    30.664     0.200
     0.964    30.375     0.200
     0.980    30.836     0.200
     1.018    31.945     0.200
     1.172    36.102     0.200
     1.182    37.055     0.200
     0.822    26.898     0.200
     0.836    27.203     0.200
     0.845    27.047     0.200
     0.850    27.398     0.200
     0.942    29.617     0.200
     0.938    30.656     0.200
     1.016    32.047     0.200
     1.176    37.633     0.200
     1.258    40.750     0.200
     0.824    26.332     0.200
     0.850    26.992     0.200
     0.851    26.883     0.200
     0.878    27.500     0.200
     0.885    28.402     0.200
     0.889    27.711     0.200
     0.904    29.223     0.200
     0.905    28.160     0.200
     0.915    28.711     0.200
     0.908    28.531     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.285    10.285     0.200
     0.343    11.938     0.200
     0.517    17.115     0.200
     0.806    25.063     0.200
     0.218     7.920     0.200
     0.331    11.619     0.200
     0.711    23.322     0.200
     0.866    27.684     0.200
     0.982    30.318     0.200
     1.591    49.965     0.200
     1.577    49.385     0.200
     0.277     9.360     0.200
     0.374    13.012     0.200
     0.454    15.253     0.200
     0.509    16.920     0.200
     0.598    19.633     0.200
     0.743    24.188     0.200
     0.670    20.980     0.200
     1.039    31.867     0.200
     1.374    40.588     0.200
     1.521    47.610     0.200
     1.992    58.449     0.200
     2.091    61.084     0.200
     0.167     6.128     0.200
     0.551    17.750     0.200
     0.635    20.764     0.200
     0.674    21.801     0.200
     0.743    23.954     0.200
     0.783    24.633     0.200
     0.775    24.650     0.200
     0.838    26.860     0.200
     1.422    41.280     0.200
     1.422    41.692     0.200
     1.542    48.482     0.200
     1.811    53.471     0.200
     0.167     6.312     0.200
     0.167     6.172     0.200
     0.551    18.148     0.200
     0.673    21.789     0.200
     0.740    24.172     0.200
     0.639    21.203     0.200
     0.783    24.680     0.200
     0.837    27.023     0.200
     0.778    24.633     0.200
     1.418    41.523     0.200
     1.418    41.672     0.200
     1.545    48.031     0.200
     1.974    58.664     0.200
     0.292    10.148     0.200
     0.356    11.719     0.200
     0.356    12.059     0.200
     0.645    20.570     0.200
     0.714    22.770     0.200
     0.837    26.270     0.200
     0.759    24.938     0.200
     1.503    44.945     0.200
     1.574    49.176     0.200
     1.929    56.000     0.200
     2.545    71.582     0.200
     6.908   199.418     0.200
     0.289    10.422     0.200
     0.362    11.793     0.200
     0.639    20.648     0.200
     0.712    22.734     0.200
     0.763    24.738     0.200
     0.833    25.961     0.200
     1.580    49.398     0.200
     0.382    12.680     0.200
     0.411    14.316     0.200
     0.658    21.738     0.200
     0.711    22.996     0.200
     0.727    23.469     0.200
     0.704    23.652     0.200
     0.772    24.727     0.200
     1.576    49.738     0.200
     1.941    57.477     0.200
     2.197    63.668     0.200
     4.302   118.879     0.200
     0.432    14.815     0.200
     0.703    23.037     0.200
     0.698    23.223     0.200
     0.677    22.159     0.200
     0.677    22.913     0.200
     0.747    24.608     0.200
     0.806    26.698     0.200
     0.806    25.522     0.200
     0.734    24.300     0.200
     1.371    39.398     0.200
     0.369    11.797     0.200
     0.613    19.965     0.200
     0.648    20.801     0.200
     0.661    21.395     0.200
     0.707    22.750     0.200
     0.707    23.137     0.200
     0.726    23.566     0.200
     0.841    26.590     0.200
     0.921    28.988     0.200
     1.586    49.438     0.200
     1.788    53.395     0.200
     0.291    10.311     0.200
     0.433    14.669     0.200
     0.666    22.245     0.200
     0.114     5.146     0.200
     0.475    15.175     0.200
     0.408    13.840     0.200
     0.419    14.390     0.200
     0.458    15.979     0.200
     0.487    16.260     0.200
     0.503    16.779     0.200
     0.621    19.819     0.200
     0.726    23.729     0.200
     1.542    47.766     0.200
     4.754   134.640     0.200
     0.111     5.000     0.200
     0.406    13.891     0.200
     0.452    14.941     0.200
     0.421    14.051     0.200
     0.472    14.977     0.200
     0.490    16.230     0.200
     0.544    17.492     0.200
     0.627    19.434     0.200
     0.636    20.500     0.200
     0.636    20.531     0.200
     1.008    30.562     0.200
     1.544    47.801     0.200
     0.219     7.950     0.200
     0.685    21.996     0.200
     0.682    22.425     0.200
     0.698    22.816     0.200
     0.744    23.164     0.200
     0.766    24.091     0.200
     0.780    24.874     0.200
     1.098    33.273     0.200
     1.522    47.803     0.200
     1.553    49.648     0.200
     1.833    54.164     0.200
     3.271    91.674     0.200
     0.167     6.516     0.200
     0.192     7.117     0.200
     0.532    17.367     0.200
     0.611    20.531     0.200
     0.755    24.055     0.200
     0.753    23.750     0.200
     0.780    25.023     0.200
     0.831    26.453     0.200
     0.890    27.891     0.200
     0.901    28.398     0.200
     5.207   144.625     0.200
     5.207   144.625     0.200
     0.272     9.406     0.200
     0.449    14.617     0.200
     0.460    15.984     0.200
     0.507    16.906     0.200
     0.563    18.781     0.200
     0.563    20.055     0.200
     0.593    19.180     0.200
     0.669    21.875     0.200
     0.745    23.359     0.200
     0.903    28.039     0.200
     0.944    29.250     0.200
     0.971    30.133     0.200
     0.987    30.516     0.200
     0.987    30.047     0.200
     1.545    48.070     0.200
     3.228    92.398     0.200
     3.374    96.375     0.200
     3.783   108.258     0.200
     0.372    12.973     0.200
     0.376    12.574     0.200
     0.480    16.762     0.200
     0.735    23.750     0.200
     0.890    29.027     0.200
     1.250    37.254     0.200
     1.589    50.805     0.200
     2.361    68.824     0.200
     3.049    91.152     0.200
     0.219     7.516     0.200
     0.583    19.156     0.200
     0.583    19.344     0.200
     0.620    19.750     0.200
     0.620    20.328     0.200
     0.659    20.797     0.200
     0.704    23.766     0.200
     0.735    23.875     0.200
     0.319    11.359     0.200
     0.330    10.801     0.200
     0.554    18.508     0.200
     0.755    23.801     0.200
     0.850    26.070     0.200
     1.354    41.078     0.200
     1.357    42.480     0.200
     1.448    44.789     0.200
     1.475    45.754     0.200
     1.510    46.891     0.200
     0.148     6.180     0.200
     0.437    14.156     0.200
     0.451    15.008     0.200
     0.446    15.023     0.200
     0.613    19.414     0.200
     0.676    22.117     0.200
     0.754    24.797     0.200
     1.250    36.602     0.200
     1.877    55.898     0.200
     0.212     8.141     0.200
     0.551    17.844     0.200
     0.551    18.039     0.200
     0.556    18.492     0.200
     0.554    18.930     0.200
     0.617    19.312     0.200
     0.737    23.805     0.200
     0.723    23.602     0.200
     1.073    32.852     0.200
     1.517    46.242     0.200
     0.196     7.031     0.200
     0.350    11.570     0.200
     0.619    20.484     0.200
     0.788    27.598     0.200
     0.753    24.664     0.200
     0.821    27.207     0.200
     0.893    28.953     0.200
     0.956    30.152     0.200
     0.902    28.512     0.200
     0.986    31.293     0.200
     1.022    32.477     0.200
     1.203    36.695     0.200
     1.588    50.293     0.200
     0.208     7.321     0.200
     0.338    11.958     0.200
     0.618    21.038     0.200
     0.686    23.051     0.200
     0.761    25.531     0.200
     0.777    27.841     0.200
     0.822    27.541     0.200
     0.895    28.960     0.200
     0.901    29.358     0.200
     0.901    29.521     0.200
     0.944    30.370     0.200
     0.973    31.799     0.200
     0.995    31.937     0.200
     1.020    32.741     0.200
     1.053    34.161     0.200
     1.165    36.961     0.200
     1.190    36.938     0.200
     1.366    42.379     0.200
     2.260    66.391     0.200
     2.273    67.661     0.200
     5.408   151.021     0.200
     5.610   165.861     0.200
     0.294     9.770     0.200
     0.543    18.113     0.200
     0.636    20.781     0.200
     0.673    22.062     0.200
     0.714    23.371     0.200
     0.721    23.258     0.200
     0.721    23.164     0.200
     0.721    23.293     0.200
     0.711    23.324     0.200
     0.763    24.273     0.200
     0.870    27.672     0.200
     1.594    49.664     0.200
     1.590    49.410     0.200
     1.590    50.383     0.200
     2.902    86.895     0.200
     0.202     7.457     0.200
     0.202     7.730     0.200
     0.249    10.426     0.200
     0.584    19.109     0.200
     0.584    19.008     0.200
     0.634    20.730     0.200
     0.633    20.746     0.200
     0.633    19.496     0.200
     0.652    20.008     0.200
     0.721    23.582     0.200
     1.097    33.129     0.200
     1.979    57.348     0.200
     0.213     7.586     0.200
     0.242    10.555     0.200
     0.592    19.336     0.200
     0.634    21.266     0.200
     0.621    20.102     0.200
     0.646    20.797     0.200
     0.733    23.891     0.200
     1.535    47.117     0.200
     0.215     7.531     0.200
     0.215     8.203     0.200
     0.247    10.758     0.200
     0.595    19.477     0.200
     0.608    20.047     0.200
     0.621    19.828     0.200
     0.629    20.945     0.200
     0.650    20.570     0.200
     0.733    24.180     0.200
     0.591    19.594     0.200
     0.729    24.156     0.200
     1.980    59.055     0.200
     1.981    58.523     0.200
     8.006   226.703     0.200
     0.233     9.992     0.200
     0.579    18.977     0.200
     0.591    19.672     0.200
     0.636    21.602     0.200
     0.628    19.953     0.200
     0.724    23.367     0.200
     1.094    33.281     0.200
     1.539    47.102     0.200
     2.336    67.531     0.200
     2.508    72.055     0.200
     0.158     6.508     0.200
     0.231    10.266     0.200
     0.215     9.609     0.200
     0.246    10.250     0.200
     0.533    17.805     0.200
     0.626    19.773     0.200
     0.668    21.180     0.200
     0.681    22.516     0.200
     0.683    22.695     0.200
     1.585    48.930     0.200
     0.212     7.969     0.200
     0.212     7.773     0.200
     0.594    19.055     0.200
     0.624    20.398     0.200
     0.628    21.414     0.200
     0.653    20.523     0.200
     0.698    21.945     0.200
     0.731    24.242     0.200
     1.299    38.523     0.200
     2.490    73.852     0.200
     2.484    73.906     0.200
     3.325    92.414     0.200
     0.233     7.477     0.200
     0.610    18.805     0.200
     0.608    20.297     0.200
     0.616    20.328     0.200
     0.616    19.883     0.200
     0.629    21.133     0.200
     0.666    21.258     0.200
     0.709    22.797     0.200
     0.748    24.711     0.200
     2.306    67.148     0.200
     2.467    70.969     0.200
     6.857   190.164     0.200
     0.168     6.734     0.200
     0.536    17.938     0.200
     0.611    19.812     0.200
     0.657    20.719     0.200
     0.657    20.180     0.200
     0.694    22.477     0.200
     2.375    70.492     0.200
     2.463    72.727     0.200
     2.554    75.742     0.200
     3.540   101.773     0.200
     3.756   104.555     0.200
     0.228     8.805     0.200
     0.228     7.617     0.200
     0.250    10.719     0.200
     0.609    20.195     0.200
     0.621    21.328     0.200
     0.655    20.562     0.200
     0.610    20.141     0.200
     0.610    19.414     0.200
     0.619    20.609     0.200
     0.746    24.453     0.200
     1.989    58.078     0.200
     0.247    10.580     0.200
     0.613    20.111     0.200
     0.613    19.184     0.200
     0.620    20.779     0.200
     0.625    20.820     0.200
     0.603    18.664     0.200
     0.651    20.480     0.200
     0.752    24.199     0.200
     0.694    22.641     0.200
     1.520    45.361     0.200
     0.194     7.777     0.200
     0.285    11.180     0.200
     0.573    19.250     0.200
     0.573    18.734     0.200
     0.586    19.723     0.200
     0.643    20.012     0.200
     0.638    20.824     0.200
     0.646    21.480     0.200
     0.714    23.297     0.200
     1.968    56.641     0.200
     0.189     7.250     0.200
     0.571    19.053     0.200
     0.571    18.822     0.200
     0.584    19.593     0.200
     0.645    19.423     0.200
     0.645    20.062     0.200
     0.650    20.733     0.200
     0.642    21.534     0.200
     0.708    23.631     0.200
     1.558    47.113     0.200
     1.973    58.863     0.200
     2.511    71.073     0.200
     0.153     6.441     0.200
     0.153     6.219     0.200
     0.409    13.302     0.200
     0.444    14.251     0.200
     0.449    14.822     0.200
     0.459    14.931     0.200
     0.529    17.046     0.200
     0.602    19.035     0.200
     0.594    19.001     0.200
     0.656    20.681     0.200
     0.672    21.280     0.200
     0.761    24.261     0.200
     0.761    23.921     0.200
     1.501    46.329     0.200
     1.790    52.551     0.200
     1.796    52.481     0.200
     1.871    54.714     0.200
     2.099    61.881     0.200
     0.469    15.688     0.200
     0.471    15.648     0.200
     0.515    17.234     0.200
     0.761    24.859     0.200
     0.847    28.133     0.200
     1.035    33.086     0.200
     1.056    33.516     0.200
     1.291    39.883     0.200
     0.178     6.828     0.200
     0.178     7.164     0.200
     0.384    12.219     0.200
     0.384    12.648     0.200
     0.366    12.352     0.200
     0.420    15.969     0.200
     0.475    15.516     0.200
     0.475    15.969     0.200
     0.635    20.062     0.200
     0.637    20.320     0.200
     0.725    23.156     0.200
     0.725    23.469     0.200
     0.766    24.852     0.200
     0.766    26.227     0.200
     0.936    28.797     0.200
     1.198    36.078     0.200
     1.929    57.164     0.200
     1.994    59.586     0.200
     2.142    63.328     0.200
     2.757    78.109     0.200
     5.267   151.336     0.200
     0.091     4.125     0.200
     0.091     4.531     0.200
     0.096     4.703     0.200
     0.612    20.078     0.200
     0.623    19.977     0.200
     0.799    24.934     0.200
     0.822    25.152     0.200
     0.851    26.117     0.200
     1.469    43.508     0.200
     1.432    44.762     0.200
     1.571    48.156     0.200
     1.821    53.074     0.200
     0.111     4.758     0.200
     0.607    19.383     0.200
     0.623    20.773     0.200
     0.630    20.273     0.200
     0.782    25.133     0.200
     0.815    25.734     0.200
     1.439    41.914     0.200
     1.634    47.703     0.200
     1.825    54.062     0.200
     0.323    10.872     0.200
     0.451    14.765     0.200
     0.663    20.226     0.200
     0.714    22.943     0.200
     0.769    25.272     0.200
     0.442    14.668     0.200
     0.703    22.742     0.200
     0.692    24.004     0.200
     0.684    25.156     0.200
     0.747    27.008     0.200
     1.003    32.250     0.200
     0.323    10.688     0.200
     0.443    14.992     0.200
     0.709    22.438     0.200
     0.708    23.102     0.200
     0.734    24.805     0.200
     0.742    24.500     0.200
     0.778    25.914     0.200
     0.868    26.883     0.200
     0.815    27.117     0.200
     1.639    48.555     0.200
     4.195   118.203     0.200
     0.265     9.369     0.200
     0.460    15.133     0.200
     0.641    20.715     0.200
     0.711    22.223     0.200
     0.739    23.725     0.200
     0.717    23.518     0.200
     0.757    23.561     0.200
     0.724    23.465     0.200
     0.947    29.182     0.200
     1.552    48.635     0.200
     1.600    50.455     0.200
     1.847    54.107     0.200
     0.096     5.261     0.200
     0.127     5.860     0.200
     0.196     7.730     0.200
     0.268     9.993     0.200
     0.268    10.121     0.200
     0.292     9.681     0.200
     0.254     9.961     0.200
     0.315    10.721     0.200
     0.317    11.591     0.200
     0.331    11.561     0.200
     0.331    11.730     0.200
     0.363    12.400     0.200
     0.378    13.061     0.200
     0.399    13.431     0.200
     0.409    13.551     0.200
     0.376    12.951     0.200
     0.400    13.971     0.200
     0.390    13.891     0.200
     0.399    14.541     0.200
     0.443    14.451     0.200
     0.460    15.631     0.200
     0.478    14.911     0.200
     0.481    14.681     0.200
     0.461    15.618     0.200
     0.499    16.360     0.200
     0.529    16.251     0.200
     0.520    17.411     0.200
     0.562    17.980     0.200
     0.611    20.711     0.200
     0.665    21.400     0.200
     0.680    21.501     0.200
     0.714    22.261     0.200
     0.716    22.230     0.200
     0.708    22.874     0.200
     0.776    24.261     0.200
     0.742    24.301     0.200
     0.804    24.780     0.200
     0.918    28.190     0.200
     1.502    45.614     0.200
     1.569    49.046     0.200
     1.954    55.593     0.200
     0.291    10.436     0.200
     0.481    15.779     0.200
     0.481    16.771     0.200
     0.549    18.551     0.200
     0.579    19.121     0.200
     0.676    21.467     0.200
     0.682    22.660     0.200
     0.705    23.861     0.200
     0.741    24.326     0.200
     0.821    27.516     0.200
     0.821    26.812     0.200
     1.040    32.201     0.200
     1.589    50.539     0.200
     0.074     2.980     0.200
     0.279    10.574     0.200
     0.287    10.374     0.200
     0.327    10.984     0.200
     0.397    13.454     0.200
     0.404    13.224     0.200
     0.451    15.124     0.200
     0.454    16.114     0.200
     0.477    15.624     0.200
     0.479    15.614     0.200
     0.555    18.487     0.200
     0.555    18.754     0.200
     0.596    19.594     0.200
     0.615    20.334     0.200
     0.618    20.704     0.200
     0.646    21.024     0.200
     0.652    22.254     0.200
     0.688    22.434     0.200
     0.693    22.664     0.200
     0.736    23.884     0.200
     0.770    24.827     0.200
     0.770    25.074     0.200
     0.761    25.124     0.200
     0.782    25.674     0.200
     0.808    26.405     0.200
     0.840    27.144     0.200
     0.862    27.664     0.200
     0.894    29.134     0.200
     0.899    28.704     0.200
     0.902    29.154     0.200
     0.929    30.259     0.200
     0.940    30.094     0.200
     1.004    31.694     0.200
     1.004    32.164     0.200
     0.267    10.410     0.200
     0.277    10.230     0.200
     0.312    11.199     0.200
     0.331    11.602     0.200
     0.391    13.242     0.200
     0.395    13.332     0.200
     0.453    15.949     0.200
     0.459    15.520     0.200
     0.468    15.672     0.200
     0.469    15.801     0.200
     0.551    18.910     0.200
     0.589    19.461     0.200
     0.606    20.223     0.200
     0.610    20.531     0.200
     0.636    20.973     0.200
     0.636    21.129     0.200
     0.640    22.512     0.200
     0.679    22.500     0.200
     0.685    22.473     0.200
     0.725    24.012     0.200
     0.749    25.402     0.200
     0.775    25.191     0.200
     0.775    25.348     0.200
     0.776    25.340     0.200
     0.787    26.570     0.200
     0.811    27.039     0.200
     0.821    28.602     0.200
     0.835    26.973     0.200
     0.856    27.500     0.200
     0.883    29.039     0.200
     0.893    28.621     0.200
     0.893    29.082     0.200
     0.938    30.379     0.200
     0.992    31.391     0.200
     1.019    32.531     0.200
     0.254     8.849     0.200
     0.516    17.488     0.200
     0.641    20.797     0.200
     0.701    22.858     0.200
     0.703    22.729     0.200
     0.703    22.148     0.200
     0.773    25.309     0.200
     0.311    11.250     0.200
     0.265     8.906     0.200
     0.629    20.500     0.200
     0.615    19.461     0.200
     0.792    25.680     0.200
     0.836    26.461     0.200
     1.172    35.133     0.200
     0.296    11.004     0.200
     0.351    11.762     0.200
     0.356    12.352     0.200
     0.442    14.723     0.200
     0.509    16.395     0.200
     0.687    22.195     0.200
     1.468    45.652     0.200
     0.137     6.365     0.200
     0.137     6.234     0.200
     0.178     6.955     0.200
     0.174     7.615     0.200
     0.166     6.834     0.200
     0.167     6.920     0.200
     0.188     7.615     0.200
     0.195     8.295     0.200
     0.296    10.445     0.200
     0.269     9.725     0.200
     0.300    10.844     0.200
     0.300    10.734     0.200
     0.292    10.195     0.200
     0.357    12.424     0.200
     0.421    14.785     0.200
     0.437    15.254     0.200
     0.464    15.436     0.200
     0.496    16.795     0.200
     0.511    16.764     0.200
     0.502    17.125     0.200
     0.522    17.074     0.200
     0.551    18.014     0.200
     0.551    18.250     0.200
     0.533    17.605     0.200
     0.535    17.324     0.200
     0.607    19.186     0.200
     0.618    21.895     0.200
     0.644    20.484     0.200
     0.644    20.314     0.200
     0.625    20.674     0.200
     0.642    20.725     0.200
     0.642    20.965     0.200
     0.650    21.445     0.200
     0.670    21.844     0.200
     0.670    22.494     0.200
     0.727    23.436     0.200
     0.716    23.525     0.200
     0.715    22.645     0.200
     0.738    23.625     0.200
     0.785    24.885     0.200
     0.781    24.531     0.200
     0.781    24.525     0.200
     0.819    25.404     0.200
     0.841    26.475     0.200
     0.883    27.574     0.200
     0.927    28.475     0.200
     1.498    47.986     0.200
     1.563    48.908     0.200
     0.061     5.367     0.200
     0.175     7.977     0.200
     0.207     9.547     0.200
     0.184     7.297     0.200
     0.203     7.938     0.200
     0.250    10.258     0.200
     0.364    13.617     0.200
     0.435    14.344     0.200
     0.550    17.633     0.200
     0.640    20.188     0.200
     0.685    22.562     0.200
     0.710    23.102     0.200
     0.710    23.242     0.200
     0.151     7.801     0.200
     0.171     7.961     0.200
     0.212     8.184     0.200
     0.230     9.430     0.200
     0.234     9.359     0.200
     0.295    10.621     0.200
     0.317    10.871     0.200
     0.357    13.078     0.200
     0.364    13.578     0.200
     0.423    13.891     0.200
     0.551    18.398     0.200
     0.549    17.801     0.200
     0.549    17.949     0.200
     0.554    18.121     0.200
     0.568    20.820     0.200
     0.618    19.477     0.200
     0.618    20.461     0.200
     0.736    23.738     0.200
     0.728    23.617     0.200
     0.113     5.652     0.200
     0.164     7.941     0.200
     0.178     7.660     0.200
     0.181     7.402     0.200
     0.185     8.363     0.200
     0.201     8.293     0.200
     0.310    10.852     0.200
     0.312    12.762     0.200
     0.335    11.730     0.200
     0.335    11.680     0.200
     0.369    13.723     0.200
     0.419    14.441     0.200
     0.419    14.254     0.200
     0.426    16.062     0.200
     0.439    15.461     0.200
     0.469    17.680     0.200
     0.552    18.730     0.200
     0.552    18.465     0.200
     0.553    19.781     0.200
     0.625    21.273     0.200
     0.667    23.133     0.200
     0.667    21.961     0.200
     0.667    21.883     0.200
     0.696    23.680     0.200
     0.706    24.590     0.200
     0.719    22.230     0.200
     0.723    24.293     0.200
     0.744    24.461     0.200
     0.744    24.156     0.200
     0.757    24.652     0.200
     0.798    25.172     0.200
     0.798    25.695     0.200
     2.334    67.926     0.200
     0.299    11.738     0.200
     0.361    12.219     0.200
     0.367    12.148     0.200
     0.367    12.043     0.200
     0.432    16.000     0.200
     0.385    13.910     0.200
     0.406    14.691     0.200
     0.458    16.668     0.200
     0.406    15.219     0.200
     0.417    14.500     0.200
     0.417    14.047     0.200
     0.451    16.090     0.200
     0.511    18.500     0.200
     0.549    19.379     0.200
     0.558    20.961     0.200
     0.573    20.191     0.200
     0.658    21.738     0.200
     0.678    22.000     0.200
     0.679    23.531     0.200
     0.635    20.781     0.200
     0.674    22.531     0.200
     0.677    22.461     0.200
     0.719    23.578     0.200
     0.712    23.250     0.200
     0.712    23.078     0.200
     0.729    23.180     0.200
     0.762    25.410     0.200
     0.724    24.410     0.200
     0.724    24.602     0.200
     0.759    25.109     0.200
     0.749    24.488     0.200
     0.749    24.961     0.200
     0.773    25.148     0.200
     0.803    24.539     0.200
     0.803    25.473     0.200
     0.773    25.949     0.200
     0.792    26.859     0.200
     0.801    26.641     0.200
     1.596    51.145     0.200
     1.656    48.734     0.200
     0.292    11.782     0.200
     0.360    11.852     0.200
     0.392    14.102     0.200
     0.413    14.962     0.200
     0.423    14.164     0.200
     0.412    15.602     0.200
     0.450    16.592     0.200
     0.458    15.821     0.200
     0.449    15.702     0.200
     0.505    18.492     0.200
     0.541    18.742     0.200
     0.551    20.382     0.200
     0.651    21.271     0.200
     0.639    20.861     0.200
     0.674    23.282     0.200
     0.671    21.852     0.200
     0.673    23.552     0.200
     0.677    22.602     0.200
     0.680    22.659     0.200
     0.707    23.212     0.200
     0.707    22.931     0.200
     0.722    23.382     0.200
     0.722    23.813     0.200
     0.731    24.592     0.200
     0.731    24.459     0.200
     0.755    25.172     0.200
     0.757    25.632     0.200
     0.751    25.882     0.200
     0.751    25.012     0.200
     0.772    25.481     0.200
     0.801    26.029     0.200
     0.776    26.722     0.200
     1.660    49.250     0.200
     0.214     9.159     0.200
     0.227     9.269     0.200
     0.373    11.515     0.200
     0.386    13.849     0.200
     0.400    14.329     0.200
     0.406    14.079     0.200
     0.406    13.803     0.200
     0.411    15.229     0.200
     0.465    16.738     0.200
     0.474    15.909     0.200
     0.552    19.488     0.200
     0.555    20.679     0.200
     0.588    19.329     0.200
     0.645    21.049     0.200
     0.662    22.019     0.200
     0.685    22.549     0.200
     0.681    22.629     0.200
     0.685    22.688     0.200
     0.688    22.674     0.200
     0.688    22.886     0.200
     0.708    22.209     0.200
     0.725    24.238     0.200
     0.725    24.094     0.200
     0.725    24.192     0.200
     0.738    23.559     0.200
     0.738    24.100     0.200
     0.762    25.698     0.200
     0.771    25.759     0.200
     0.773    26.219     0.200
     0.787    25.789     0.200
     0.791    24.869     0.200
     0.791    25.871     0.200
     0.786    26.369     0.200
     0.805    27.229     0.200
     0.814    26.938     0.200
     1.597    51.609     0.200
     0.198     8.868     0.200
     0.208     8.008     0.200
     0.294    11.618     0.200
     0.391    13.568     0.200
     0.410    14.798     0.200
     0.425    14.258     0.200
     0.425    14.146     0.200
     0.426    16.568     0.200
     0.450    16.388     0.200
     0.446    16.108     0.200
     0.457    15.558     0.200
     0.507    18.368     0.200
     0.542    19.198     0.200
     0.553    20.598     0.200
     0.570    18.858     0.200
     0.636    20.418     0.200
     0.651    21.008     0.200
     0.677    23.338     0.200
     0.671    21.608     0.200
     0.674    22.308     0.200
     0.677    22.483     0.200
     0.677    22.048     0.200
     0.677    22.229     0.200
     0.705    22.988     0.200
     0.721    23.198     0.200
     0.730    24.118     0.200
     0.748    24.558     0.200
     0.748    24.678     0.200
     0.754    24.798     0.200
     0.753    24.888     0.200
     0.769    25.238     0.200
     0.773    26.098     0.200
     0.791    26.588     0.200
     0.804    24.988     0.200
     0.804    25.094     0.200
     0.800    26.458     0.200
     0.199     8.949     0.200
     0.209     8.119     0.200
     0.295    12.099     0.200
     0.390    13.529     0.200
     0.412    14.039     0.200
     0.409    14.769     0.200
     0.424    13.999     0.200
     0.424    14.119     0.200
     0.452    16.499     0.200
     0.446    16.299     0.200
     0.459    15.679     0.200
     0.543    18.969     0.200
     0.554    20.809     0.200
     0.570    19.289     0.200
     0.636    20.559     0.200
     0.672    21.599     0.200
     0.677    22.829     0.200
     0.674    22.648     0.200
     0.677    22.839     0.200
     0.677    22.128     0.200
     0.677    22.299     0.200
     0.677    22.491     0.200
     0.706    23.029     0.200
     0.706    23.292     0.200
     0.722    23.349     0.200
     0.729    24.069     0.200
     0.729    23.779     0.200
     0.748    24.949     0.200
     0.748    25.208     0.200
     0.755    25.089     0.200
     0.754    25.009     0.200
     0.773    26.119     0.200
     0.791    26.479     0.200
     0.804    24.739     0.200
     0.804    25.466     0.200
     0.800    26.609     0.200
     0.151     7.172     0.200
     0.303    10.355     0.200
     0.303     9.727     0.200
     0.307    10.945     0.200
     0.350    13.023     0.200
     0.347    13.395     0.200
     0.358    13.594     0.200
     0.401    15.555     0.200
     0.441    15.473     0.200
     0.446    16.324     0.200
     0.477    16.215     0.200
     0.507    17.875     0.200
     0.519    17.594     0.200
     0.551    18.113     0.200
     0.542    18.355     0.200
     0.556    17.984     0.200
     0.560    19.582     0.200
     0.569    20.434     0.200
     0.574    20.043     0.200
     0.610    19.895     0.200
     0.652    20.445     0.200
     0.676    22.883     0.200
     0.695    23.082     0.200
     0.695    22.457     0.200
     0.701    23.434     0.200
     0.762    25.125     0.200
     0.762    24.824     0.200
     0.805    25.562     0.200
     0.058     4.594     0.200
     0.158     7.562     0.200
     0.197     8.547     0.200
     0.201     9.555     0.200
     0.208     7.734     0.200
     0.208     8.055     0.200
     0.260    11.047     0.200
     0.364    13.977     0.200
     0.363    12.188     0.200
     0.360    12.648     0.200
     0.384    13.992     0.200
     0.456    15.023     0.200
     0.465    16.516     0.200
     0.487    16.125     0.200
     0.572    19.055     0.200
     0.581    19.477     0.200
     0.617    19.227     0.200
     0.617    19.680     0.200
     0.617    19.523     0.200
     0.621    21.508     0.200
     0.675    22.922     0.200
     0.675    22.344     0.200
     0.734    23.586     0.200
     0.734    23.836     0.200
     0.740    24.195     0.200
     0.761    25.352     0.200
     0.776    25.422     0.200
     0.056     4.961     0.200
     0.161     7.672     0.200
     0.196     8.656     0.200
     0.206     7.703     0.200
     0.206     7.875     0.200
     0.257    11.266     0.200
     0.359    12.766     0.200
     0.366    13.820     0.200
     0.386    14.836     0.200
     0.387    14.406     0.200
     0.456    14.953     0.200
     0.463    16.781     0.200
     0.489    16.227     0.200
     0.542    18.883     0.200
     0.572    18.477     0.200
     0.572    18.750     0.200
     0.581    18.922     0.200
     0.606    20.789     0.200
     0.606    21.070     0.200
     0.618    19.672     0.200
     0.618    19.773     0.200
     0.619    21.391     0.200
     0.673    22.711     0.200
     0.732    23.891     0.200
     0.732    24.047     0.200
     0.732    24.188     0.200
     0.724    24.352     0.200
     0.738    24.500     0.200
     0.759    25.930     0.200
     0.773    25.359     0.200
     0.979    30.102     0.200
     0.179     7.246     0.200
     0.293    11.309     0.200
     0.309    10.777     0.200
     0.345    11.695     0.200
     0.364    12.809     0.200
     0.365    12.418     0.200
     0.365    12.285     0.200
     0.412    15.738     0.200
     0.412    14.465     0.200
     0.471    15.457     0.200
     0.471    15.355     0.200
     0.477    17.168     0.200
     0.456    15.457     0.200
     0.488    16.027     0.200
     0.503    16.727     0.200
     0.487    15.215     0.200
     0.498    16.266     0.200
     0.534    19.918     0.200
     0.501    16.406     0.200
     0.553    19.527     0.200
     0.526    17.426     0.200
     0.526    17.535     0.200
     0.576    19.105     0.200
     0.596    19.375     0.200
     0.562    19.176     0.200
     0.605    19.207     0.200
     0.572    18.828     0.200
     0.583    19.695     0.200
     0.641    22.066     0.200
     0.644    21.297     0.200
     0.644    21.586     0.200
     0.658    21.438     0.200
     0.672    21.809     0.200
     0.689    22.875     0.200
     0.756    23.688     0.200
     0.769    23.816     0.200
     0.755    24.867     0.200
     0.756    24.688     0.200
     0.795    26.605     0.200
     0.822    25.387     0.200
     0.818    26.066     0.200
     0.882    27.625     0.200
     0.853    27.098     0.200
     0.906    28.195     0.200
     0.955    29.648     0.200
     1.043    31.738     0.200
     1.043    31.867     0.200
     1.569    49.543     0.200
     0.144     5.461     0.200
     0.244     7.500     0.200
     0.244     9.039     0.200
     0.245     8.891     0.200
     0.276    11.320     0.200
     0.316    12.570     0.200
     0.358    13.727     0.200
     0.374    12.562     0.200
     0.492    18.539     0.200
     0.515    17.258     0.200
     0.523    17.422     0.200
     0.523    17.312     0.200
     0.545    19.711     0.200
     0.547    19.297     0.200
     0.544    18.852     0.200
     0.557    18.617     0.200
     0.562    20.578     0.200
     0.560    19.680     0.200
     0.632    20.852     0.200
     0.636    21.008     0.200
     0.657    22.539     0.200
     0.689    22.711     0.200
     0.713    23.922     0.200
     0.715    22.898     0.200
     0.765    24.938     0.200
     0.784    25.562     0.200
     0.796    26.578     0.200
     0.799    25.938     0.200
     0.849    26.617     0.200
     0.880    27.633     0.200
     0.121     6.037     0.200
     0.125     5.057     0.200
     0.142     6.527     0.200
     0.197     7.547     0.200
     0.197     7.357     0.200
     0.269     9.617     0.200
     0.269     9.297     0.200
     0.269    10.427     0.200
     0.269    10.547     0.200
     0.351    12.167     0.200
     0.367    12.587     0.200
     0.372    13.367     0.200
     0.403    13.527     0.200
     0.403    13.807     0.200
     0.414    13.967     0.200
     0.408    14.257     0.200
     0.427    14.957     0.200
     0.453    14.817     0.200
     0.454    15.037     0.200
     0.459    15.497     0.200
     0.501    16.037     0.200
     0.501    15.697     0.200
     0.501    16.527     0.200
     0.510    16.557     0.200
     0.498    15.737     0.200
     0.557    19.387     0.200
     0.569    18.317     0.200
     0.569    18.607     0.200
     0.590    19.477     0.200
     0.596    18.777     0.200
     0.596    18.988     0.200
     0.586    18.887     0.200
     0.595    18.807     0.200
     0.585    18.925     0.200
     0.585    18.997     0.200
     0.600    19.157     0.200
     0.613    19.827     0.200
     0.613    20.127     0.200
     0.624    20.107     0.200
     0.650    22.497     0.200
     0.650    22.327     0.200
     0.647    21.407     0.200
     0.643    20.537     0.200
     0.663    20.867     0.200
     0.663    21.207     0.200
     0.663    21.397     0.200
     0.663    21.457     0.200
     0.659    21.217     0.200
     0.694    21.607     0.200
     0.694    21.867     0.200
     0.705    23.597     0.200
     0.701    22.287     0.200
     0.739    23.387     0.200
     0.747    24.897     0.200
     0.741    23.837     0.200
     0.741    24.007     0.200
     1.459    38.957     0.200
     1.498    46.597     0.200
     2.550    71.693     0.200
     0.074     5.133     0.200
     0.100     6.297     0.200
     0.125     5.695     0.200
     0.126     5.680     0.200
     0.121     6.695     0.200
     0.128     6.305     0.200
     0.240     8.227     0.200
     0.199     8.211     0.200
     0.219     8.555     0.200
     0.315    11.047     0.200
     0.372    12.977     0.200
     0.419    13.875     0.200
     0.391    13.633     0.200
     0.443    15.156     0.200
     0.453    15.414     0.200
     0.455    15.109     0.200
     0.461    15.320     0.200
     0.566    18.594     0.200
     0.606    19.289     0.200
     0.583    19.156     0.200
     0.579    18.906     0.200
     0.577    19.672     0.200
     0.663    20.922     0.200
     0.663    20.969     0.200
     0.669    21.961     0.200
     0.761    24.211     0.200
     0.782    24.305     0.200
     0.782    24.070     0.200
     0.812    24.961     0.200
     0.812    25.367     0.200
     0.812    25.156     0.200
     0.823    25.391     0.200
     0.838    25.750     0.200
     0.881    27.273     0.200
     1.501    48.688     0.200
     1.592    49.602     0.200
     1.780    51.953     0.200
     0.072     4.615     0.200
     0.159     6.495     0.200
     0.211     8.665     0.200
     0.275     9.385     0.200
     0.283    10.215     0.200
     0.283    10.100     0.200
     0.327    11.015     0.200
     0.327    10.865     0.200
     0.384    13.235     0.200
     0.383    12.875     0.200
     0.375    12.705     0.200
     0.448    15.284     0.200
     0.434    15.044     0.200
     0.438    14.635     0.200
     0.483    16.054     0.200
     0.493    16.185     0.200
     0.513    17.084     0.200
     0.610    19.594     0.200
     0.549    17.955     0.200
     0.603    19.274     0.200
     0.601    19.975     0.200
     0.654    21.284     0.200
     0.630    20.344     0.200
     0.698    23.544     0.200
     0.670    21.314     0.200
     0.663    22.354     0.200
     0.669    22.554     0.200
     0.727    23.975     0.200
     0.744    25.155     0.200
     0.721    23.455     0.200
     0.696    23.084     0.200
     0.772    24.715     0.200
     0.772    25.328     0.200
     0.767    24.875     0.200
     0.769    25.334     0.200
     0.792    25.205     0.200
     0.867    27.215     0.200
     0.835    26.515     0.200
     0.876    27.794     0.200
     0.957    29.794     0.200
     1.067    32.529     0.200
     1.548    49.333     0.200
     0.156     6.429     0.200
     0.256     9.309     0.200
     0.259     9.423     0.200
     0.266     9.409     0.200
     0.284    10.989     0.200
     0.274    10.069     0.200
     0.308    11.429     0.200
     0.324    11.479     0.200
     0.329    12.179     0.200
     0.348    12.029     0.200
     0.370    13.148     0.200
     0.397    13.369     0.200
     0.406    13.769     0.200
     0.419    13.938     0.200
     0.458    15.569     0.200
     0.477    17.119     0.200
     0.483    17.779     0.200
     0.473    16.019     0.200
     0.507    16.668     0.200
     0.573    19.249     0.200
     0.557    18.958     0.200
     0.610    19.838     0.200
     0.610    20.041     0.200
     0.592    20.119     0.200
     0.637    20.708     0.200
     0.599    19.429     0.200
     0.659    23.179     0.200
     0.648    20.659     0.200
     0.659    21.338     0.200
     0.665    20.889     0.200
     0.658    21.199     0.200
     0.677    21.309     0.200
     0.669    21.449     0.200
     0.696    23.668     0.200
     0.682    22.299     0.200
     0.774    24.219     0.200
     0.814    25.398     0.200
     0.841    26.092     0.200
     0.841    26.019     0.200
     0.847    26.279     0.200
     1.436    43.261     0.200
     1.489    46.662     0.200
     1.591    50.300     0.200
     0.157     5.207     0.200
     0.225     9.152     0.200
     0.347    13.592     0.200
     0.411    13.462     0.200
     0.458    17.112     0.200
     0.436    14.482     0.200
     0.436    14.381     0.200
     0.478    18.462     0.200
     0.447    15.267     0.200
     0.460    15.562     0.200
     0.473    15.922     0.200
     0.590    20.722     0.200
     0.596    21.142     0.200
     0.691    22.862     0.200
     0.705    24.182     0.200
     0.715    22.922     0.200
     0.715    23.082     0.200
     0.697    22.362     0.200
     0.708    23.002     0.200
     0.731    23.552     0.200
     0.843    26.762     0.200
     0.853    27.512     0.200
     0.871    28.212     0.200
     0.925    29.012     0.200
     0.912    28.652     0.200
     0.956    30.012     0.200
     2.112    61.546     0.200
     0.154     6.406     0.200
     0.211     8.523     0.200
     0.282     9.992     0.200
     0.282    10.141     0.200
     0.332    11.211     0.200
     0.332    11.047     0.200
     0.370    12.617     0.200
     0.387    12.773     0.200
     0.387    13.492     0.200
     0.439    15.156     0.200
     0.443    14.984     0.200
     0.450    15.242     0.200
     0.487    15.781     0.200
     0.497    16.227     0.200
     0.518    17.031     0.200
     0.545    18.695     0.200
     0.552    18.211     0.200
     0.611    19.797     0.200
     0.598    20.070     0.200
     0.605    19.578     0.200
     0.633    20.453     0.200
     0.659    21.211     0.200
     0.663    22.664     0.200
     0.668    21.852     0.200
     0.673    21.656     0.200
     0.696    22.695     0.200
     0.702    23.492     0.200
     0.725    23.531     0.200
     0.732    24.258     0.200
     0.747    25.594     0.200
     0.768    25.312     0.200
     0.772    25.047     0.200
     0.774    25.977     0.200
     0.774    25.156     0.200
     0.794    25.156     0.200
     0.794    25.414     0.200
     0.835    26.586     0.200
     0.876    27.805     0.200
     1.071    32.938     0.200
     1.538    47.242     0.200
     1.543    48.898     0.200
     0.055     3.297     0.200
     0.105     5.531     0.200
     0.149     7.812     0.200
     0.225     6.945     0.200
     0.286    11.500     0.200
     0.319    12.500     0.200
     0.323    12.422     0.200
     0.364    12.953     0.200
     0.376    14.133     0.200
     0.483    16.000     0.200
     0.506    18.516     0.200
     0.514    18.078     0.200
     0.534    17.680     0.200
     0.549    17.961     0.200
     0.549    17.836     0.200
     0.583    18.641     0.200
     0.578    19.633     0.200
     0.579    19.430     0.200
     0.617    20.430     0.200
     0.639    21.586     0.200
     0.662    21.500     0.200
     0.678    22.797     0.200
     0.691    21.562     0.200
     0.694    22.930     0.200
     0.765    24.578     0.200
     0.199     6.541     0.200
     0.224     8.351     0.200
     0.227     8.031     0.200
     0.231     8.461     0.200
     0.276     9.531     0.200
     0.313    10.961     0.200
     0.330    11.649     0.200
     0.402    13.121     0.200
     0.417    12.941     0.200
     0.437    14.761     0.200
     0.460    16.271     0.200
     0.465    16.281     0.200
     0.481    16.311     0.200
     0.501    16.691     0.200
     0.508    17.001     0.200
     0.527    18.051     0.200
     0.558    19.071     0.200
     0.580    19.171     0.200
     0.585    18.871     0.200
     0.608    20.811     0.200
     0.626    20.941     0.200
     0.648    21.821     0.200
     0.673    21.711     0.200
     0.677    22.391     0.200
     0.670    22.591     0.200
     0.689    22.761     0.200
     0.700    22.351     0.200
     0.726    23.401     0.200
     0.733    24.241     0.200
     0.733    24.531     0.200
     0.723    24.361     0.200
     0.730    24.151     0.200
     0.735    24.551     0.200
     0.801    25.661     0.200
     0.791    26.081     0.200
     0.805    26.391     0.200
     0.808    26.551     0.200
     0.827    26.401     0.200
     0.865    27.651     0.200
     0.866    27.871     0.200
     0.872    27.671     0.200
     1.122    35.151     0.200
     2.571    75.167     0.200
     3.005    85.525     0.200
     3.531    99.594     0.200
     0.136     5.891     0.200
     0.154     5.801     0.200
     0.176     6.352     0.200
     0.176     6.559     0.200
     0.280    10.719     0.200
     0.280    10.520     0.200
     0.257    10.090     0.200
     0.278    10.898     0.200
     0.340    13.172     0.200
     0.340    12.969     0.200
     0.387    13.301     0.200
     0.387    13.531     0.200
     0.385    12.922     0.200
     0.385    12.809     0.200
     0.378    12.691     0.200
     0.378    12.602     0.200
     0.342    13.398     0.200
     0.357    14.191     0.200
     0.380    14.879     0.200
     0.425    15.340     0.200
     0.435    14.512     0.200
     0.405    14.398     0.200
     0.515    17.070     0.200
     0.505    19.238     0.200
     0.546    19.852     0.200
     0.580    19.301     0.200
     0.593    20.160     0.200
     0.601    21.488     0.200
     0.669    21.230     0.200
     0.638    22.488     0.200
     0.631    21.121     0.200
     0.690    22.031     0.200
     0.661    21.621     0.200
     0.697    22.738     0.200
     0.697    22.430     0.200
     0.732    23.090     0.200
     0.732    22.988     0.200
     0.705    22.559     0.200
     0.704    22.391     0.200
     0.708    22.559     0.200
     0.708    22.742     0.200
     0.736    23.789     0.200
     0.743    25.211     0.200
     0.781    24.871     0.200
     0.745    24.301     0.200
     0.764    25.910     0.200
     0.745    24.512     0.200
     0.801    25.488     0.200
     0.774    25.172     0.200
     0.852    26.461     0.200
     0.894    27.922     0.200
     0.112     6.467     0.200
     0.148     7.687     0.200
     0.180     8.337     0.200
     0.224     9.617     0.200
     0.227    10.597     0.200
     0.230     9.887     0.200
     0.257    10.837     0.200
     0.275    10.307     0.200
     0.274    11.317     0.200
     0.274    11.198     0.200
     0.301    10.567     0.200
     0.333    13.527     0.200
     0.338    12.646     0.200
     0.376    12.847     0.200
     0.386    12.707     0.200
     0.420    13.907     0.200
     0.465    15.167     0.200
     0.479    17.057     0.200
     0.497    18.207     0.200
     0.513    18.247     0.200
     0.513    17.718     0.200
     0.544    19.356     0.200
     0.554    17.987     0.200
     0.604    18.937     0.200
     0.661    23.327     0.200
     0.681    23.347     0.200
     0.703    24.687     0.200
     0.703    24.174     0.200
     0.757    24.827     0.200
     0.757    24.646     0.200
     0.757    24.767     0.200
     1.519    45.034     0.200
     2.115    60.890     0.200
     0.348    12.250     0.200
     0.393    13.469     0.200
     0.445    14.828     0.200
     0.442    15.590     0.200
     0.510    16.438     0.200
     0.511    16.559     0.200
     0.512    16.309     0.200
     0.600    19.828     0.200
     0.612    19.688     0.200
     0.643    21.039     0.200
     0.677    21.660     0.200
     0.682    23.688     0.200
     0.713    23.801     0.200
     0.714    22.898     0.200
     0.718    23.320     0.200
     0.785    25.129     0.200
     0.788    25.148     0.200
     0.817    27.020     0.200
     0.843    26.660     0.200
     0.869    27.641     0.200
     0.908    28.711     0.200
     0.143     4.957     0.200
     0.247    10.418     0.200
     0.306    10.438     0.200
     0.317    11.066     0.200
     0.329    12.348     0.200
     0.370    12.906     0.200
     0.374    14.457     0.200
     0.408    13.867     0.200
     0.412    13.930     0.200
     0.414    14.816     0.200
     0.436    14.430     0.200
     0.504    18.367     0.200
     0.523    17.406     0.200
     0.557    18.578     0.200
     0.588    20.898     0.200
     0.598    20.156     0.200
     0.607    20.816     0.200
     0.601    20.020     0.200
     0.655    21.738     0.200
     0.681    22.609     0.200
     0.681    22.277     0.200
     0.702    23.078     0.200
     0.716    23.148     0.200
     0.722    23.488     0.200
     0.720    24.270     0.200
     0.723    24.027     0.200
     0.726    23.887     0.200
     0.740    25.867     0.200
     0.733    24.477     0.200
     0.757    24.805     0.200
     0.765    25.891     0.200
     0.790    26.617     0.200
     0.788    25.336     0.200
     0.794    26.781     0.200
     0.806    26.320     0.200
     0.876    27.359     0.200
     0.137     4.859     0.200
     0.315    11.238     0.200
     0.329    12.160     0.200
     0.365    12.668     0.200
     0.375    14.359     0.200
     0.421    13.500     0.200
     0.406    14.000     0.200
     0.421    14.789     0.200
     0.432    14.008     0.200
     0.506    18.379     0.200
     0.519    18.508     0.200
     0.529    17.590     0.200
     0.588    21.000     0.200
     0.610    21.309     0.200
     0.601    19.828     0.200
     0.653    21.680     0.200
     0.685    23.109     0.200
     0.685    22.309     0.200
     0.719    22.711     0.200
     0.706    23.168     0.200
     0.726    23.230     0.200
     0.729    23.539     0.200
     0.724    24.070     0.200
     0.732    23.848     0.200
     0.742    25.328     0.200
     0.738    24.160     0.200
     0.762    24.590     0.200
     0.775    26.270     0.200
     0.766    25.711     0.200
     0.792    26.449     0.200
     0.799    26.469     0.200
     0.162     6.128     0.200
     0.134     5.408     0.200
     0.162     5.568     0.200
     0.209     7.448     0.200
     0.165     6.608     0.200
     0.177     7.078     0.200
     0.195     7.238     0.200
     0.314    10.127     0.200
     0.406    13.968     0.200
     0.366    12.778     0.200
     0.463    15.178     0.200
     0.418    14.158     0.200
     0.418    14.138     0.200
     0.531    17.488     0.200
     0.460    15.688     0.200
     0.501    17.138     0.200
     0.583    18.988     0.200
     0.522    17.738     0.200
     0.572    18.938     0.200
     0.574    19.338     0.200
     0.683    21.788     0.200
     0.614    19.998     0.200
     0.632    21.498     0.200
     0.648    22.198     0.200
     0.708    23.088     0.200
     0.677    22.138     0.200
     0.689    22.378     0.200
     0.767    24.948     0.200
     0.776    24.958     0.200
     0.726    23.658     0.200
     0.743    24.278     0.200
     0.808    25.858     0.200
     0.830    26.678     0.200
     0.770    24.908     0.200
     0.820    25.498     0.200
     0.903    28.348     0.200
     0.225     8.279     0.200
     0.324    11.759     0.200
     0.365    13.329     0.200
     0.397    13.579     0.200
     0.413    14.319     0.200
     0.446    14.979     0.200
     0.449    15.359     0.200
     0.459    15.639     0.200
     0.458    15.139     0.200
     0.465    15.849     0.200
     0.486    17.039     0.200
     0.565    18.609     0.200
     0.583    19.369     0.200
     0.583    19.819     0.200
     0.588    19.119     0.200
     0.608    19.939     0.200
     0.600    19.869     0.200
     0.665    23.159     0.200
     0.675    22.009     0.200
     0.688    22.169     0.200
     0.685    24.199     0.200
     0.697    23.309     0.200
     0.760    24.819     0.200
     0.734    23.719     0.200
     0.740    24.459     0.200
     0.779    24.809     0.200
     0.781    25.159     0.200
     0.787    25.629     0.200
     0.799    26.659     0.200
     0.809    25.799     0.200
     0.806    26.209     0.200
     0.818    25.999     0.200
     0.814    25.569     0.200
     0.834    26.319     0.200
     0.834    26.569     0.200
     0.843    27.289     0.200
     0.863    27.869     0.200
     0.879    27.649     0.200
     0.947    30.049     0.200
     0.212     7.787     0.200
     0.284    10.148     0.200
     0.294    11.688     0.200
     0.310    12.158     0.200
     0.279     9.277     0.200
     0.348    13.428     0.200
     0.366    13.908     0.200
     0.414    16.639     0.200
     0.438    15.457     0.200
     0.521    18.178     0.200
     0.488    16.588     0.200
     0.532    19.838     0.200
     0.545    18.107     0.200
     0.526    18.338     0.200
     0.517    17.799     0.200
     0.538    18.979     0.200
     0.554    20.178     0.200
     0.552    19.508     0.200
     0.593    19.328     0.200
     0.579    20.928     0.200
     0.592    19.469     0.200
     0.662    22.059     0.200
     0.671    22.018     0.200
     0.696    23.238     0.200
     0.690    22.309     0.200
     0.706    23.768     0.200
     0.773    24.969     0.200
     0.802    26.428     0.200
     0.817    26.178     0.200
     0.810    25.637     0.200
     0.818    26.148     0.200
     0.261     9.445     0.200
     0.256     9.656     0.200
     0.357    13.211     0.200
     0.382    12.281     0.200
     0.365    14.023     0.200
     0.384    12.828     0.200
     0.378    14.766     0.200
     0.402    15.344     0.200
     0.424    15.172     0.200
     0.415    13.336     0.200
     0.415    14.445     0.200
     0.447    14.766     0.200
     0.492    16.367     0.200
     0.492    15.836     0.200
     0.526    19.578     0.200
     0.558    18.367     0.200
     0.565    20.281     0.200
     0.620    21.773     0.200
     0.651    20.125     0.200
     0.629    20.641     0.200
     0.659    22.891     0.200
     0.675    20.977     0.200
     0.662    21.305     0.200
     0.679    21.625     0.200
     0.686    21.531     0.200
     0.691    21.727     0.200
     0.693    21.750     0.200
     0.693    21.484     0.200
     0.747    23.305     0.200
     0.778    24.164     0.200
     0.999    29.445     0.200
     0.102     5.070     0.200
     0.153     6.121     0.200
     0.179     7.910     0.200
     0.248     9.449     0.200
     0.448    15.430     0.200
     0.456    16.621     0.200
     0.712    23.500     0.200
     0.715    23.328     0.200
     0.780    26.000     0.200
     0.104     5.090     0.200
     0.106     3.539     0.200
     0.113     6.148     0.200
     0.172     7.488     0.200
     0.162     6.512     0.200
     0.163     8.000     0.200
     0.240    10.020     0.200
     0.230     9.270     0.200
     0.394    13.699     0.200
     0.423    15.051     0.200
     0.457    16.211     0.200
     0.444    15.781     0.200
     0.459    16.070     0.200
     0.457    16.910     0.200
     0.463    17.398     0.200
     0.492    17.699     0.200
     0.610    22.090     0.200
     0.590    20.398     0.200
     0.630    22.070     0.200
     0.628    20.852     0.200
     0.641    22.488     0.200
     0.678    22.570     0.200
     0.687    22.750     0.200
     0.681    22.469     0.200
     0.717    24.211     0.200
     0.716    24.012     0.200
     0.719    24.070     0.200
     0.719    23.648     0.200
     0.770    24.891     0.200
     0.761    24.770     0.200
     0.783    26.629     0.200
     0.782    26.500     0.200
     0.784    25.730     0.200
     0.809    27.141     0.200
     0.829    28.609     0.200
     0.833    27.691     0.200
     0.090     4.980     0.200
     0.102     3.270     0.200
     0.154     5.891     0.200
     0.174     8.059     0.200
     0.243     9.980     0.200
     0.318    10.879     0.200
     0.321    10.922     0.200
     0.371    13.301     0.200
     0.405    14.949     0.200
     0.408    14.590     0.200
     0.433    15.000     0.200
     0.445    15.801     0.200
     0.448    15.180     0.200
     0.454    15.641     0.200
     0.470    16.949     0.200
     0.468    16.480     0.200
     0.496    17.500     0.200
     0.496    19.180     0.200
     0.605    19.969     0.200
     0.603    20.570     0.200
     0.609    22.320     0.200
     0.621    21.520     0.200
     0.635    20.570     0.200
     0.637    22.910     0.200
     0.668    22.141     0.200
     0.696    22.602     0.200
     0.726    24.551     0.200
     0.726    23.781     0.200
     0.729    23.719     0.200
     0.774    25.711     0.200
     0.790    25.699     0.200
     0.784    26.559     0.200
     0.794    25.930     0.200
     0.798    26.070     0.200
     0.821    27.449     0.200
     0.093     5.211     0.200
     0.089     5.672     0.200
     0.135     5.102     0.200
     0.188     7.898     0.200
     0.190     8.359     0.200
     0.260    10.914     0.200
     0.338    11.484     0.200
     0.408    14.648     0.200
     0.427    15.742     0.200
     0.430    15.250     0.200
     0.450    15.312     0.200
     0.445    16.078     0.200
     0.469    16.719     0.200
     0.519    19.773     0.200
     0.516    17.148     0.200
     0.598    20.484     0.200
     0.628    20.828     0.200
     0.640    21.758     0.200
     0.655    21.133     0.200
     0.682    22.648     0.200
     0.673    21.953     0.200
     0.713    23.062     0.200
     0.711    23.555     0.200
     0.714    22.852     0.200
     0.714    23.500     0.200
     0.769    23.461     0.200
     0.761    25.922     0.200
     0.775    25.750     0.200
     0.782    25.953     0.200
     0.795    26.258     0.200
     0.808    27.148     0.200
     1.009    31.453     0.200
     0.140     6.441     0.200
     0.302     9.691     0.200
     0.339    11.461     0.200
     0.340    11.320     0.200
     0.346    11.340     0.200
     0.356    12.160     0.200
     0.352    12.512     0.200
     0.347    11.672     0.200
     0.424    14.332     0.200
     0.431    14.633     0.200
     0.457    15.582     0.200
     0.470    15.602     0.200
     0.459    16.160     0.200
     0.481    16.121     0.200
     0.481    15.992     0.200
     0.475    16.781     0.200
     0.504    16.953     0.200
     0.501    17.230     0.200
     0.526    18.332     0.200
     0.526    18.180     0.200
     0.549    18.602     0.200
     0.581    19.281     0.200
     0.592    20.113     0.200
     0.623    20.652     0.200
     0.687    22.062     0.200
     0.680    21.602     0.200
     0.704    23.211     0.200
     0.693    23.422     0.200
     0.741    24.340     0.200
     0.756    25.332     0.200
     0.774    25.410     0.200
     0.762    24.660     0.200
     0.766    26.363     0.200
     0.814    27.723     0.200
     0.821    28.023     0.200
     0.803    25.793     0.200
     0.844    27.301     0.200
     0.849    27.281     0.200
     0.880    28.121     0.200
     0.880    28.742     0.200
     0.898    28.742     0.200
     0.958    30.660     0.200
     1.047    32.680     0.200
     1.583    50.180     0.200
     0.122     6.031     0.200
     0.206     7.953     0.200
     0.316    10.523     0.200
     0.307    11.633     0.200
     0.323    12.836     0.200
     0.333    13.164     0.200
     0.355    12.547     0.200
     0.345    12.305     0.200
     0.410    13.938     0.200
     0.480    15.773     0.200
     0.493    17.156     0.200
     0.533    17.445     0.200
     0.606    20.523     0.200
     0.581    19.977     0.200
     0.597    20.633     0.200
     0.619    20.344     0.200
     0.660    22.711     0.200
     0.667    22.227     0.200
     0.686    23.156     0.200
     0.716    23.227     0.200
     0.817    27.625     0.200
     0.881    27.953     0.200
     0.910    28.961     0.200
     0.031     2.398     0.200
     0.163     7.258     0.200
     0.197     6.734     0.200
     0.208     8.016     0.200
     0.312    10.156     0.200
     0.321    12.133     0.200
     0.342    12.469     0.200
     0.421    13.914     0.200
     0.488    15.773     0.200
     0.603    20.398     0.200
     0.608    20.703     0.200
     0.647    21.844     0.200
     0.654    22.086     0.200
     0.674    22.883     0.200
     0.709    23.312     0.200
     0.882    28.594     0.200
     0.897    29.156     0.200
     0.900    29.023     0.200
     0.973    31.258     0.200
     0.971    30.438     0.200
     0.157     7.250     0.200
     0.212     7.836     0.200
     0.220     9.578     0.200
     0.238     9.867     0.200
     0.309    10.508     0.200
     0.418    14.156     0.200
     0.446    16.031     0.200
     0.494    17.500     0.200
     0.532    16.906     0.200
     0.604    20.648     0.200
     0.611    20.617     0.200
     0.607    20.711     0.200
     0.652    22.117     0.200
     0.660    22.578     0.200
     0.683    22.531     0.200
     0.716    23.289     0.200
     0.878    27.695     0.200
     0.907    27.734     0.200
     0.907    28.641     0.200
     0.975    30.359     0.200
     0.024     2.977     0.200
     0.195     7.367     0.200
     0.193     9.055     0.200
     0.208     7.820     0.200
     0.223     9.641     0.200
     0.311    11.844     0.200
     0.314    10.547     0.200
     0.318    13.078     0.200
     0.329    13.008     0.200
     0.347    12.547     0.200
     0.350    12.344     0.200
     0.447    16.000     0.200
     0.484    16.117     0.200
     0.492    17.336     0.200
     0.584    19.789     0.200
     0.608    20.828     0.200
     0.615    20.148     0.200
     0.662    21.977     0.200
     0.714    22.523     0.200
     0.878    27.445     0.200
     0.113     6.057     0.200
     0.160     7.377     0.200
     0.206     8.087     0.200
     0.219     9.407     0.200
     0.286    12.247     0.200
     0.313    12.347     0.200
     0.323    12.677     0.200
     0.345    12.847     0.200
     0.485    16.487     0.200
     0.453    16.117     0.200
     0.614    21.267     0.200
     0.611    20.467     0.200
     0.687    22.717     0.200
     0.708    22.227     0.200
     0.103     5.350     0.200
     0.170     7.740     0.200
     0.207     7.980     0.200
     0.211     9.010     0.200
     0.303    12.300     0.200
     0.295    12.230     0.200
     0.314    12.700     0.200
     0.321    12.030     0.200
     0.336    11.750     0.200
     0.425    14.440     0.200
     0.490    16.040     0.200
     0.587    19.700     0.200
     0.604    20.440     0.200
     0.604    19.860     0.200
     0.647    21.570     0.200
     0.642    21.510     0.200
     0.702    22.510     0.200
     0.697    22.570     0.200
     0.863    27.100     0.200
     0.892    27.790     0.200
     0.019     3.277     0.200
     0.149     7.066     0.200
     0.207     8.077     0.200
     0.223     9.497     0.200
     0.231     9.626     0.200
     0.228     9.876     0.200
     0.274    11.697     0.200
     0.307    12.106     0.200
     0.315    10.417     0.200
     0.324    12.617     0.200
     0.347    12.467     0.200
     0.334    13.197     0.200
     0.355    12.557     0.200
     0.397    14.396     0.200
     0.410    14.057     0.200
     0.443    15.707     0.200
     0.481    16.287     0.200
     0.495    17.277     0.200
     0.531    17.197     0.200
     0.582    19.267     0.200
     0.598    20.467     0.200
     0.603    20.427     0.200
     0.619    19.836     0.200
     0.660    22.396     0.200
     0.676    22.257     0.200
     0.668    22.057     0.200
     0.688    23.146     0.200
     0.718    23.467     0.200
     0.909    28.287     0.200
     5.802   159.832     0.200
     0.037     3.472     0.200
     0.102     6.241     0.200
     0.170     7.831     0.200
     0.186     8.892     0.200
     0.202     7.701     0.200
     0.213     8.031     0.200
     0.239     9.241     0.200
     0.251    10.321     0.200
     0.295    12.342     0.200
     0.313    11.762     0.200
     0.324    12.691     0.200
     0.307    10.512     0.200
     0.335    11.331     0.200
     0.352    12.611     0.200
     0.428    14.472     0.200
     0.456    16.111     0.200
     0.486    17.302     0.200
     0.495    16.741     0.200
     0.539    17.581     0.200
     0.592    19.481     0.200
     0.609    20.571     0.200
     0.600    20.241     0.200
     0.618    20.981     0.200
     0.647    22.012     0.200
     0.667    22.671     0.200
     0.707    22.991     0.200
     0.697    22.981     0.200
     0.866    27.291     0.200
     0.167     7.836     0.200
     0.213     8.086     0.200
     0.225     8.156     0.200
     0.245     9.996     0.200
     0.242    10.137     0.200
     0.288    12.148     0.200
     0.295     9.797     0.200
     0.309    12.586     0.200
     0.318    12.586     0.200
     0.329    12.316     0.200
     0.336    11.879     0.200
     0.365    13.066     0.200
     0.393    14.727     0.200
     0.432    14.488     0.200
     0.443    15.879     0.200
     0.500    17.520     0.200
     0.503    16.727     0.200
     0.525    17.289     0.200
     0.570    19.969     0.200
     0.603    19.867     0.200
     0.598    20.359     0.200
     0.619    20.789     0.200
     0.606    20.809     0.200
     0.652    22.047     0.200
     0.167     7.672     0.200
     0.224     8.391     0.200
     0.243    10.059     0.200
     0.244    10.328     0.200
     0.288    11.961     0.200
     0.296     9.910     0.200
     0.308    12.430     0.200
     0.318    13.109     0.200
     0.336    12.070     0.200
     0.364    12.949     0.200
     0.393    14.660     0.200
     0.430    15.988     0.200
     0.431    14.539     0.200
     0.444    15.891     0.200
     0.502    16.398     0.200
     0.499    17.320     0.200
     0.525    17.219     0.200
     0.602    19.719     0.200
     0.606    20.531     0.200
     0.618    20.480     0.200
     0.720    24.070     0.200
     0.027     3.516     0.200
     0.164     7.617     0.200
     0.210     7.953     0.200
     0.222     8.062     0.200
     0.240     9.711     0.200
     0.200     9.664     0.200
     0.212     9.250     0.200
     0.285    11.711     0.200
     0.325    12.055     0.200
     0.299    10.023     0.200
     0.362    12.711     0.200
     0.340    11.797     0.200
     0.428    14.891     0.200
     0.394    14.531     0.200
     0.443    15.875     0.200
     0.499    16.383     0.200
     0.526    17.266     0.200
     0.599    19.547     0.200
     0.605    20.570     0.200
     0.615    20.617     0.200
     0.602    19.695     0.200
     0.644    21.625     0.200
     0.655    21.781     0.200
     0.677    23.336     0.200
     0.721    23.281     0.200
     0.021     3.453     0.200
     0.130     6.344     0.200
     0.185     7.156     0.200
     0.199     7.484     0.200
     0.205     9.117     0.200
     0.215     8.805     0.200
     0.249    10.625     0.200
     0.327    11.000     0.200
     0.338    11.688     0.200
     0.343    12.977     0.200
     0.353    13.625     0.200
     0.375    13.266     0.200
     0.435    15.625     0.200
     0.465    15.195     0.200
     0.501    17.188     0.200
     0.571    19.969     0.200
     0.569    18.680     0.200
     0.639    21.156     0.200
     0.657    22.234     0.200
     0.680    22.617     0.200
     0.687    22.617     0.200
     0.725    23.406     0.200
     0.897    28.188     0.200
     0.925    28.750     0.200
     0.203     7.148     0.200
     0.245     8.164     0.200
     0.338    13.320     0.200
     0.313    10.750     0.200
     0.301    12.172     0.200
     0.368    13.867     0.200
     0.364    13.852     0.200
     0.414    15.969     0.200
     0.445    15.352     0.200
     0.467    15.938     0.200
     0.507    17.523     0.200
     0.528    18.281     0.200
     0.561    19.781     0.200
     0.520    18.430     0.200
     0.566    18.383     0.200
     0.618    19.797     0.200
     0.694    23.422     0.200
     0.660    21.859     0.200
     0.701    22.930     0.200
     0.793    25.680     0.200
     0.067     4.141     0.200
     0.143     6.781     0.200
     0.224     8.250     0.200
     0.281    11.227     0.200
     0.273     8.859     0.200
     0.277     9.750     0.200
     0.280     9.961     0.200
     0.339    12.984     0.200
     0.400    15.625     0.200
     0.412    14.359     0.200
     0.496    16.383     0.200
     0.523    18.242     0.200
     0.535    17.586     0.200
     0.529    18.047     0.200
     0.540    18.852     0.200
     0.587    19.016     0.200
     0.567    19.953     0.200
     0.607    20.477     0.200
     0.679    21.781     0.200
     0.691    22.891     0.200
     0.099     4.744     0.200
     0.231     7.684     0.200
     0.236     8.203     0.200
     0.269     9.074     0.200
     0.273    10.443     0.200
     0.302     9.854     0.200
     0.293     9.664     0.200
     0.313    10.555     0.200
     0.336    11.764     0.200
     0.341    10.963     0.200
     0.352    12.943     0.200
     0.419    14.234     0.200
     0.429    14.484     0.200
     0.449    15.234     0.200
     0.454    14.943     0.200
     0.457    14.514     0.200
     0.472    15.805     0.200
     0.458    16.064     0.200
     0.502    17.273     0.200
     0.503    16.543     0.200
     0.539    17.494     0.200
     0.534    17.494     0.200
     0.603    19.914     0.200
     0.626    21.193     0.200
     0.627    20.324     0.200
     0.636    20.953     0.200
     0.652    21.873     0.200
     0.681    22.064     0.200
     0.671    21.984     0.200
     0.696    23.475     0.200
     0.673    21.994     0.200
     0.690    22.305     0.200
     0.683    22.463     0.200
     0.697    23.373     0.200
     0.735    24.084     0.200
     0.739    24.293     0.200
     0.738    24.914     0.200
     0.773    24.574     0.200
     0.775    25.213     0.200
     0.801    25.684     0.200
     0.791    25.754     0.200
     0.809    25.764     0.200
     0.823    26.344     0.200
     0.837    27.283     0.200
     0.839    27.734     0.200
     0.895    28.273     0.200
     5.119   142.297     0.200
     0.229     8.539     0.200
     0.233     8.758     0.200
     0.440    15.719     0.200
     0.437    14.586     0.200
     0.453    15.477     0.200
     0.495    15.039     0.200
     0.498    15.539     0.200
     0.506    16.680     0.200
     0.541    16.570     0.200
     0.499    17.586     0.200
     0.566    19.867     0.200
     0.586    19.398     0.200
     0.639    20.102     0.200
     0.648    19.969     0.200
     0.654    20.445     0.200
     0.659    20.852     0.200
     0.656    20.461     0.200
     0.667    22.547     0.200
     0.704    22.008     0.200
     0.711    23.016     0.200
     0.733    22.938     0.200
     0.760    23.719     0.200
     0.839    25.711     0.200
     1.276    37.195     0.200
     0.011     1.410     0.200
     0.071     4.441     0.200
     0.095     5.039     0.200
     0.151     6.719     0.200
     0.194     8.328     0.200
     0.191     9.301     0.200
     0.203     9.051     0.200
     0.215     8.121     0.200
     0.262     8.691     0.200
     0.289    11.270     0.200
     0.293     9.961     0.200
     0.350    13.590     0.200
     0.366    13.660     0.200
     0.425    14.898     0.200
     0.468    15.910     0.200
     0.520    17.738     0.200
     0.574    18.559     0.200
     0.535    18.418     0.200
     0.545    18.250     0.200
     0.568    19.281     0.200
     0.599    19.641     0.200
     0.605    20.941     0.200
     0.672    22.258     0.200
     0.611    20.160     0.200
     0.626    21.121     0.200
     0.644    21.309     0.200
     0.680    22.340     0.200
     0.681    23.250     0.200
     0.705    24.250     0.200
     0.703    23.840     0.200
     0.725    25.039     0.200
     0.760    25.609     0.200
     0.808    27.000     0.200
     0.794    27.551     0.200
     0.813    27.621     0.200
     0.826    26.125     0.200
     0.893    28.320     0.200
     0.112     5.656     0.200
     0.099     5.211     0.200
     0.204     8.328     0.200
     0.286    11.336     0.200
     0.289    10.172     0.200
     0.367    13.711     0.200
     0.421    14.617     0.200
     0.488    16.711     0.200
     0.522    17.945     0.200
     0.542    18.172     0.200
     0.542    20.086     0.200
     0.536    18.797     0.200
     0.564    19.391     0.200
     0.595    19.289     0.200
     0.576    18.484     0.200
     0.609    21.281     0.200
     0.646    22.602     0.200
     0.676    21.906     0.200
     0.643    21.398     0.200
     0.674    21.367     0.200
     0.699    23.602     0.200
     0.699    23.352     0.200
     0.725    24.930     0.200
     0.759    25.758     0.200
     0.775    25.109     0.200
     0.782    27.461     0.200
     0.788    25.188     0.200
     0.794    26.469     0.200
     0.811    27.000     0.200
     0.825    26.398     0.200
     0.895    28.172     0.200
     0.063     3.871     0.200
     0.150     7.141     0.200
     0.232     7.199     0.200
     0.222     9.020     0.200
     0.251    10.352     0.200
     0.260     9.762     0.200
     0.297    11.801     0.200
     0.332    12.930     0.200
     0.332    12.520     0.200
     0.369    13.668     0.200
     0.388    14.320     0.200
     0.391    15.352     0.200
     0.434    16.199     0.200
     0.495    16.551     0.200
     0.508    17.699     0.200
     0.512    18.301     0.200
     0.523    18.809     0.200
     0.543    17.559     0.200
     0.537    19.531     0.200
     0.579    20.031     0.200
     0.566    19.480     0.200
     0.566    19.891     0.200
     0.586    20.500     0.200
     0.591    19.418     0.200
     0.623    21.191     0.200
     0.628    21.578     0.200
     0.647    21.488     0.200
     0.655    19.941     0.200
     0.660    22.191     0.200
     0.638    22.148     0.200
     0.664    22.879     0.200
     0.647    22.012     0.200
     0.689    23.449     0.200
     0.697    22.461     0.200
     0.752    25.020     0.200
     0.775    25.148     0.200
     0.759    26.289     0.200
     0.777    24.918     0.200
     0.791    26.219     0.200
     0.797    26.621     0.200
     0.790    24.609     0.200
     0.804    26.512     0.200
     0.795    27.371     0.200
     0.786    25.262     0.200
     0.809    26.750     0.200
     0.823    26.031     0.200
     0.853    27.262     0.200
     0.974    30.289     0.200
     0.029     2.836     0.200
     0.051     3.977     0.200
     0.098     5.605     0.200
     0.135     7.047     0.200
     0.220    10.047     0.200
     0.255    10.957     0.200
     0.310    11.855     0.200
     0.286     9.809     0.200
     0.330    12.879     0.200
     0.322    12.316     0.200
     0.325    12.406     0.200
     0.388    13.605     0.200
     0.483    17.508     0.200
     0.531    17.238     0.200
     0.525    18.629     0.200
     0.540    19.516     0.200
     0.559    18.086     0.200
     0.599    20.148     0.200
     0.576    18.828     0.200
     0.587    19.707     0.200
     0.642    20.277     0.200
     0.631    21.719     0.200
     0.664    21.836     0.200
     0.680    22.355     0.200
     0.679    22.508     0.200
     0.681    21.789     0.200
     0.026     2.922     0.200
     0.053     3.734     0.200
     0.100     5.141     0.200
     0.122     6.250     0.200
     0.167     8.062     0.200
     0.226     9.875     0.200
     0.258     9.180     0.200
     0.285     9.445     0.200
     0.324    12.742     0.200
     0.324    12.094     0.200
     0.333    12.812     0.200
     0.402    15.742     0.200
     0.452    16.406     0.200
     0.480    17.000     0.200
     0.510    16.820     0.200
     0.521    18.422     0.200
     0.525    18.367     0.200
     0.534    18.594     0.200
     0.521    17.375     0.200
     0.544    19.766     0.200
     0.562    18.297     0.200
     0.553    19.195     0.200
     0.560    18.766     0.200
     0.584    20.297     0.200
     0.577    18.875     0.200
     0.600    20.250     0.200
     0.607    20.492     0.200
     0.645    21.352     0.200
     0.634    21.820     0.200
     0.653    21.633     0.200
     0.670    21.906     0.200
     0.681    22.742     0.200
     0.683    23.352     0.200
     0.667    22.156     0.200
     0.681    22.992     0.200
     0.681    21.953     0.200
     0.762    25.344     0.200
     0.782    25.477     0.200
     0.774    24.531     0.200
     0.797    25.820     0.200
     0.797    25.156     0.200
     0.797    27.281     0.200
     0.806    26.797     0.200
     0.810    26.844     0.200
     0.831    26.516     0.200
     0.874    27.562     0.200
     0.996    30.664     0.200
     0.030     3.122     0.200
     0.054     3.992     0.200
     0.101     5.632     0.200
     0.121     6.302     0.200
     0.135     6.812     0.200
     0.217     9.422     0.200
     0.254     9.052     0.200
     0.227     9.922     0.200
     0.257    10.492     0.200
     0.250     9.412     0.200
     0.311    12.021     0.200
     0.289     9.442     0.200
     0.325    12.012     0.200
     0.333    12.582     0.200
     0.379    14.992     0.200
     0.387    13.521     0.200
     0.386    13.962     0.200
     0.507    16.832     0.200
     0.480    17.182     0.200
     0.516    17.992     0.200
     0.530    17.942     0.200
     0.522    18.271     0.200
     0.542    19.702     0.200
     0.559    18.152     0.200
     0.524    17.521     0.200
     0.555    19.232     0.200
     0.561    19.232     0.200
     0.579    18.642     0.200
     0.596    20.172     0.200
     0.584    20.042     0.200
     0.605    20.172     0.200
     0.641    20.832     0.200
     0.639    21.842     0.200
     0.652    21.372     0.200
     0.664    21.952     0.200
     0.677    22.662     0.200
     0.683    22.892     0.200
     0.684    21.902     0.200
     0.740    24.212     0.200
     0.760    25.552     0.200
     0.781    24.412     0.200
     0.793    25.362     0.200
     0.776    24.582     0.200
     0.796    27.262     0.200
     0.036     2.262     0.200
     0.291    11.281     0.200
     0.299     9.512     0.200
     0.343    13.082     0.200
     0.363    13.342     0.200
     0.430    16.053     0.200
     0.439    16.291     0.200
     0.501    17.383     0.200
     0.495    16.682     0.200
     0.541    17.701     0.200
     0.542    18.592     0.200
     0.519    18.252     0.200
     0.518    17.092     0.200
     0.553    19.461     0.200
     0.542    19.002     0.200
     0.585    18.992     0.200
     0.584    20.771     0.200
     0.574    19.072     0.200
     0.592    20.002     0.200
     0.611    20.682     0.200
     0.610    19.602     0.200
     0.613    20.121     0.200
     0.643    21.242     0.200
     0.659    21.562     0.200
     0.666    22.143     0.200
     0.669    22.701     0.200
     0.674    23.441     0.200
     0.684    22.861     0.200
     0.709    22.893     0.200
     0.721    23.711     0.200
     0.725    24.291     0.200
     0.738    24.812     0.200
     0.755    26.143     0.200
     0.776    25.812     0.200
     0.769    25.883     0.200
     0.793    25.932     0.200
     0.791    25.633     0.200
     0.793    25.816     0.200
     0.793    25.711     0.200
     0.809    25.732     0.200
     1.550    47.582     0.200
     0.039     3.174     0.200
     0.054     3.904     0.200
     0.102     5.215     0.200
     0.115     6.115     0.200
     0.144     6.924     0.200
     0.223     9.574     0.200
     0.240     7.705     0.200
     0.245     8.785     0.200
     0.250    10.484     0.200
     0.296     9.625     0.200
     0.302    11.814     0.200
     0.321    12.355     0.200
     0.324    12.145     0.200
     0.328    12.744     0.200
     0.378    13.305     0.200
     0.374    14.715     0.200
     0.393    15.395     0.200
     0.444    15.715     0.200
     0.485    17.475     0.200
     0.499    16.145     0.200
     0.519    18.184     0.200
     0.533    17.705     0.200
     0.516    18.125     0.200
     0.522    17.635     0.200
     0.536    19.555     0.200
     0.563    19.805     0.200
     0.567    19.145     0.200
     0.550    17.744     0.200
     0.589    20.195     0.200
     0.581    18.855     0.200
     0.590    19.615     0.200
     0.637    21.725     0.200
     0.632    20.584     0.200
     0.632    21.445     0.200
     0.653    21.314     0.200
     0.671    22.324     0.200
     0.655    21.955     0.200
     0.682    22.955     0.200
     0.687    21.744     0.200
     0.748    24.725     0.200
     0.760    25.154     0.200
     0.775    23.764     0.200
     0.797    24.865     0.200
     0.830    26.164     0.200
     0.140     6.969     0.200
     0.198     9.328     0.200
     0.257     9.023     0.200
     0.303    12.008     0.200
     0.275    11.094     0.200
     0.345    12.758     0.200
     0.387    13.492     0.200
     0.399    15.586     0.200
     0.417    16.195     0.200
     0.507    17.719     0.200
     0.521    18.328     0.200
     0.520    17.234     0.200
     0.514    16.852     0.200
     0.542    18.477     0.200
     0.540    18.375     0.200
     0.566    17.922     0.200
     0.622    21.219     0.200
     0.597    19.445     0.200
     0.651    20.367     0.200
     0.644    21.008     0.200
     0.668    21.805     0.200
     0.655    22.445     0.200
     0.669    22.492     0.200
     0.740    25.062     0.200
     0.700    21.266     0.200
     0.775    24.258     0.200
     0.776    26.758     0.200
     0.744    24.508     0.200
     0.789    26.555     0.200
     0.810    24.703     0.200
     0.810    25.742     0.200
     0.795    25.297     0.200
     0.987    30.227     0.200
     0.050     3.004     0.200
     0.111     5.794     0.200
     0.099     5.523     0.200
     0.163     7.954     0.200
     0.157     7.464     0.200
     0.183     8.324     0.200
     0.155     7.684     0.200
     0.165     8.014     0.200
     0.287    10.233     0.200
     0.318    11.974     0.200
     0.302    10.023     0.200
     0.324    12.444     0.200
     0.362    13.784     0.200
     0.395    15.034     0.200
     0.412    14.804     0.200
     0.427    14.284     0.200
     0.496    17.694     0.200
     0.499    17.884     0.200
     0.523    18.354     0.200
     0.554    19.654     0.200
     0.561    18.444     0.200
     0.569    20.504     0.200
     0.595    19.754     0.200
     0.601    19.944     0.200
     0.596    20.164     0.200
     0.622    20.604     0.200
     0.635    21.744     0.200
     0.672    22.124     0.200
     0.671    23.454     0.200
     0.692    24.523     0.200
     0.699    23.634     0.200
     0.712    24.974     0.200
     0.718    23.864     0.200
     0.741    24.224     0.200
     0.750    24.523     0.200
     0.778    25.933     0.200
     0.806    26.284     0.200
     0.824    26.874     0.200
     0.865    27.714     0.200
     0.051     2.072     0.200
     0.098     5.113     0.200
     0.113     5.771     0.200
     0.154     7.521     0.200
     0.185     8.582     0.200
     0.192     7.193     0.200
     0.280    11.193     0.200
     0.301     9.822     0.200
     0.320    12.271     0.200
     0.363    13.873     0.200
     0.396    14.803     0.200
     0.413    14.713     0.200
     0.427    15.422     0.200
     0.443    17.053     0.200
     0.461    18.092     0.200
     0.477    16.143     0.200
     0.496    17.203     0.200
     0.497    17.262     0.200
     0.521    18.172     0.200
     0.555    18.953     0.200
     0.562    18.252     0.200
     0.560    19.213     0.200
     0.570    19.883     0.200
     0.596    20.002     0.200
     0.595    20.693     0.200
     0.602    20.521     0.200
     0.602    19.902     0.200
     0.606    21.822     0.200
     0.623    20.072     0.200
     0.635    21.203     0.200
     0.664    22.422     0.200
     0.672    23.213     0.200
     0.673    22.592     0.200
     0.693    24.363     0.200
     0.711    24.492     0.200
     0.700    23.592     0.200
     0.719    23.082     0.200
     0.736    26.283     0.200
     0.740    24.543     0.200
     0.732    25.602     0.200
     0.738    24.832     0.200
     0.766    25.502     0.200
     0.775    25.992     0.200
     0.777    25.877     0.200
     0.795    26.582     0.200
     0.805    26.123     0.200
     0.810    26.213     0.200
     0.823    25.852     0.200
     0.865    27.521     0.200
     0.055     2.676     0.200
     0.115     5.705     0.200
     0.106     5.076     0.200
     0.161     6.906     0.200
     0.155     7.846     0.200
     0.184     8.246     0.200
     0.165     7.826     0.200
     0.282    10.766     0.200
     0.273    11.225     0.200
     0.309    10.135     0.200
     0.322    11.926     0.200
     0.359    13.775     0.200
     0.384    14.064     0.200
     0.405    14.656     0.200
     0.443    17.195     0.200
     0.458    18.096     0.200
     0.483    16.705     0.200
     0.501    17.725     0.200
     0.520    18.736     0.200
     0.547    19.064     0.200
     0.558    18.465     0.200
     0.574    20.406     0.200
     0.596    19.736     0.200
     0.592    20.746     0.200
     0.595    20.826     0.200
     0.628    20.555     0.200
     0.628    21.285     0.200
     0.666    22.305     0.200
     0.696    24.006     0.200
     0.693    23.375     0.200
     0.706    23.506     0.200
     0.742    25.176     0.200
     0.773    25.969     0.200
     0.787    26.275     0.200
     0.800    25.945     0.200
     0.816    27.115     0.200
     0.857    27.586     0.200
     0.114     5.779     0.200
     0.183     8.391     0.200
     0.273    10.820     0.200
     0.281     9.879     0.200
     0.281     9.721     0.200
     0.317    12.570     0.200
     0.310    10.100     0.200
     0.323    12.061     0.200
     0.357    13.629     0.200
     0.404    14.230     0.200
     0.396    14.850     0.200
     0.417    15.500     0.200
     0.484    16.449     0.200
     0.499    18.049     0.200
     0.521    18.480     0.200
     0.546    18.539     0.200
     0.557    18.340     0.200
     0.586    19.221     0.200
     0.574    20.160     0.200
     0.595    19.439     0.200
     0.595    20.189     0.200
     0.592    19.430     0.200
     0.604    20.990     0.200
     0.627    20.350     0.200
     0.628    20.529     0.200
     0.655    21.900     0.200
     0.662    22.730     0.200
     0.665    21.689     0.200
     0.696    24.340     0.200
     0.706    23.561     0.200
     0.692    23.289     0.200
     0.737    24.029     0.200
     0.742    25.000     0.200
     0.747    24.660     0.200
     0.759    25.840     0.200
     0.771    25.119     0.200
     0.773    24.062     0.200
     0.773    25.020     0.200
     0.800    26.340     0.200
     0.800    25.629     0.200
     0.815    26.529     0.200
     0.866    27.520     0.200
     1.534    48.010     0.200
     0.190     7.148     0.200
     0.203     8.156     0.200
     0.299    11.578     0.200
     0.306    11.461     0.200
     0.321    13.016     0.200
     0.322    13.078     0.200
     0.346    12.461     0.200
     0.362    14.078     0.200
     0.378    14.484     0.200
     0.379    15.008     0.200
     0.392    13.930     0.200
     0.414    14.586     0.200
     0.408    14.852     0.200
     0.422    14.648     0.200
     0.427    14.078     0.200
     0.430    14.047     0.200
     0.447    16.828     0.200
     0.444    14.875     0.200
     0.471    15.766     0.200
     0.484    17.125     0.200
     0.551    19.734     0.200
     0.541    17.875     0.200
     0.577    20.141     0.200
     0.580    20.852     0.200
     0.591    19.945     0.200
     0.589    19.508     0.200
     0.603    19.961     0.200
     0.622    22.336     0.200
     0.649    23.711     0.200
     0.667    20.898     0.200
     0.675    21.875     0.200
     0.677    21.445     0.200
     0.677    21.578     0.200
     0.680    22.039     0.200
     0.680    21.898     0.200
     0.715    22.828     0.200
     0.718    22.648     0.200
     0.721    23.430     0.200
     0.727    24.727     0.200
     0.743    23.781     0.200
     0.743    24.234     0.200
     0.765    24.156     0.200
     0.776    24.852     0.200
     0.804    26.281     0.200
     0.812    26.109     0.200
     0.828    26.148     0.200
     0.884    27.688     0.200
     0.893    28.266     0.200
     0.893    27.789     0.200
     0.916    28.867     0.200
     0.050     3.668     0.200
     0.063     4.418     0.200
     0.110     6.039     0.200
     0.116     6.059     0.200
     0.154     7.160     0.200
     0.225    10.141     0.200
     0.232     8.559     0.200
     0.235     9.988     0.200
     0.248    10.328     0.200
     0.264    10.000     0.200
     0.309    10.141     0.200
     0.330    12.730     0.200
     0.331    12.289     0.200
     0.365    12.988     0.200
     0.374    14.840     0.200
     0.390    13.758     0.200
     0.491    16.328     0.200
     0.483    17.359     0.200
     0.496    17.418     0.200
     0.509    17.301     0.200
     0.516    19.090     0.200
     0.507    17.840     0.200
     0.534    19.301     0.200
     0.539    17.770     0.200
     0.542    18.277     0.200
     0.569    19.777     0.200
     0.569    19.219     0.200
     0.576    18.879     0.200
     0.591    19.141     0.200
     0.588    20.230     0.200
     0.594    19.988     0.200
     0.620    20.230     0.200
     0.623    21.391     0.200
     0.637    21.918     0.200
     0.628    21.359     0.200
     0.648    21.250     0.200
     0.654    21.539     0.200
     0.658    22.207     0.200
     0.643    21.328     0.200
     0.662    22.289     0.200
     0.688    23.051     0.200
     0.698    22.008     0.200
     0.753    24.848     0.200
     0.762    25.188     0.200
     0.771    24.758     0.200
     0.786    24.949     0.200
     0.792    25.309     0.200
     0.163     7.137     0.200
     0.102     5.477     0.200
     0.170     7.117     0.200
     0.167     6.527     0.200
     0.128     6.097     0.200
     0.128     6.097     0.200
     0.155     7.547     0.200
     0.174     7.887     0.200
     0.206     7.607     0.200
     0.203     8.087     0.200
     0.256     9.647     0.200
     0.265     9.747     0.200
     0.330    11.477     0.200
     0.330    11.537     0.200
     0.332    11.688     0.200
     0.297    11.007     0.200
     0.283    11.587     0.200
     0.319    11.127     0.200
     0.371    13.117     0.200
     0.405    13.938     0.200
     0.332    12.447     0.200
     0.402    13.797     0.200
     0.345    12.057     0.200
     0.351    13.737     0.200
     0.365    12.707     0.200
     0.421    13.987     0.200
     0.340    12.677     0.200
     0.388    13.897     0.200
     0.364    13.177     0.200
     0.436    15.197     0.200
     0.425    15.517     0.200
     0.418    14.767     0.200
     0.490    15.827     0.200
     0.455    15.457     0.200
     0.498    16.107     0.200
     0.535    17.167     0.200
     0.457    15.917     0.200
     0.541    18.037     0.200
     0.464    16.287     0.200
     0.515    17.487     0.200
     0.539    17.217     0.200
     0.512    16.847     0.200
     0.514    17.607     0.200
     0.496    16.987     0.200
     0.513    17.417     0.200
     0.596    18.727     0.200
     0.542    20.037     0.200
     0.579    19.727     0.200
     0.606    19.427     0.200
     0.637    19.767     0.200
     0.611    21.307     0.200
     0.612    21.277     0.200
     0.578    19.837     0.200
     0.638    22.207     0.200
     0.663    21.137     0.200
     0.636    21.137     0.200
     0.679    21.147     0.200
     0.670    21.057     0.200
     0.623    20.767     0.200
     0.644    20.777     0.200
     0.627    21.137     0.200
     0.637    20.337     0.200
     0.681    21.897     0.200
     0.726    22.677     0.200
     0.733    23.057     0.200
     0.747    23.297     0.200
     0.761    23.627     0.200
     0.748    23.467     0.200
     0.763    23.627     0.200
     0.780    24.037     0.200
     0.736    23.887     0.200
     0.726    24.167     0.200
     0.732    23.777     0.200
     0.820    25.377     0.200
     0.813    25.137     0.200
     0.823    25.197     0.200
     0.823    25.467     0.200
     0.854    26.237     0.200
     0.854    25.877     0.200
     0.963    29.247     0.200
     1.192    34.877     0.200
     0.140     6.406     0.200
     0.133     6.375     0.200
     0.171     7.367     0.200
     0.197     7.578     0.200
     0.192     8.285     0.200
     0.221     8.875     0.200
     0.258     9.246     0.200
     0.245    10.246     0.200
     0.269     9.527     0.200
     0.263    10.016     0.200
     0.277    10.406     0.200
     0.300    10.785     0.200
     0.296    10.156     0.200
     0.331    11.578     0.200
     0.317    11.488     0.200
     0.344    11.648     0.200
     0.346    12.188     0.200
     0.375    12.496     0.200
     0.372    12.578     0.200
     0.385    13.105     0.200
     0.389    12.816     0.200
     0.389    13.105     0.200
     0.386    13.375     0.200
     0.405    13.387     0.200
     0.406    13.516     0.200
     0.400    13.676     0.200
     0.410    13.707     0.200
     0.396    14.105     0.200
     0.396    13.668     0.200
     0.427    13.898     0.200
     0.438    14.676     0.200
     0.434    14.457     0.200
     0.451    15.035     0.200
     0.440    14.656     0.200
     0.463    15.617     0.200
     0.454    14.465     0.200
     0.469    15.285     0.200
     0.477    15.496     0.200
     0.465    15.637     0.200
     0.482    16.176     0.200
     0.475    16.258     0.200
     0.499    16.117     0.200
     0.511    16.605     0.200
     0.503    16.516     0.200
     0.523    17.285     0.200
     0.527    17.957     0.200
     0.571    18.078     0.200
     0.577    18.426     0.200
     0.555    19.898     0.200
     0.562    18.465     0.200
     0.571    18.176     0.200
     0.581    19.355     0.200
     0.575    20.297     0.200
     0.576    19.215     0.200
     0.586    19.426     0.200
     0.605    19.297     0.200
     0.613    19.527     0.200
     0.625    19.836     0.200
     0.620    20.246     0.200
     0.645    21.938     0.200
     0.640    20.586     0.200
     0.657    21.496     0.200
     0.652    20.777     0.200
     0.657    21.438     0.200
     0.646    20.945     0.200
     0.643    22.637     0.200
     0.650    21.695     0.200
     0.665    22.117     0.200
     0.684    22.277     0.200
     0.692    21.809     0.200
     0.709    23.496     0.200
     0.705    23.117     0.200
     0.710    23.625     0.200
     0.705    23.945     0.200
     0.706    23.457     0.200
     0.716    22.445     0.200
     0.731    23.695     0.200
     0.733    23.605     0.200
     0.738    24.066     0.200
     0.732    23.027     0.200
     0.732    23.566     0.200
     0.743    23.258     0.200
     0.750    24.406     0.200
     0.742    24.758     0.200
     0.768    26.258     0.200
     0.753    23.668     0.200
     0.755    24.195     0.200
     0.787    24.297     0.200
     0.815    25.215     0.200
     0.094     5.578     0.200
     0.126     7.500     0.200
     0.126     6.328     0.200
     0.133     6.672     0.200
     0.174     8.023     0.200
     0.175     9.391     0.200
     0.235     7.875     0.200
     0.235     8.000     0.200
     0.261    10.039     0.200
     0.266    10.961     0.200
     0.273     9.125     0.200
     0.297    12.000     0.200
     0.316    11.773     0.200
     0.322    10.922     0.200
     0.341    13.188     0.200
     0.359    14.125     0.200
     0.378    13.250     0.200
     0.388    12.930     0.200
     0.435    14.523     0.200
     0.435    14.625     0.200
     0.435    14.070     0.200
     0.461    15.414     0.200
     0.457    16.359     0.200
     0.474    17.539     0.200
     0.479    16.891     0.200
     0.487    17.031     0.200
     0.528    19.062     0.200
     0.536    18.023     0.200
     0.534    17.594     0.200
     0.567    18.648     0.200
     0.565    18.062     0.200
     0.567    18.148     0.200
     0.567    20.453     0.200
     0.582    19.555     0.200
     0.598    19.484     0.200
     0.590    20.883     0.200
     0.625    20.242     0.200
     0.658    22.109     0.200
     0.678    23.898     0.200
     0.671    21.375     0.200
     0.671    23.242     0.200
     0.722    23.664     0.200
     0.722    25.453     0.200
     0.723    25.203     0.200
     0.733    23.969     0.200
     0.749    24.609     0.200
     0.790    25.984     0.200
     0.785    26.109     0.200
     0.811    25.734     0.200
     0.827    25.734     0.200
     1.543    49.188     0.200
     1.541    46.242     0.200
     0.086     3.773     0.200
     0.139     4.973     0.200
     0.142     6.301     0.200
     0.188     7.574     0.200
     0.187     7.461     0.200
     0.209     7.441     0.200
     0.209     7.508     0.200
     0.209     7.703     0.200
     0.225     7.551     0.200
     0.248     8.684     0.200
     0.248     9.004     0.200
     0.226     9.203     0.200
     0.260     8.672     0.200
     0.241     8.164     0.200
     0.249     8.852     0.200
     0.290    10.164     0.200
     0.290    10.434     0.200
     0.285    10.184     0.200
     0.320    11.211     0.200
     0.330    11.512     0.200
     0.320    11.801     0.200
     0.342    12.402     0.200
     0.363    12.684     0.200
     0.347    12.434     0.200
     0.344    12.023     0.200
     0.353    12.883     0.200
     0.366    14.004     0.200
     0.385    13.941     0.200
     0.411    14.773     0.200
     0.427    14.391     0.200
     0.398    13.602     0.200
     0.399    13.613     0.200
     0.411    14.691     0.200
     0.418    14.621     0.200
     0.430    15.164     0.200
     0.426    14.473     0.200
     0.432    14.684     0.200
     0.451    15.031     0.200
     0.433    14.621     0.200
     0.457    15.773     0.200
     0.471    15.363     0.200
     0.520    17.262     0.200
     0.516    17.434     0.200
     0.525    18.574     0.200
     0.532    18.062     0.200
     0.543    17.891     0.200
     0.567    19.914     0.200
     0.537    18.191     0.200
     0.566    19.523     0.200
     0.547    18.863     0.200
     0.557    19.191     0.200
     0.560    18.723     0.200
     0.569    19.273     0.200
     0.582    19.551     0.200
     0.607    19.551     0.200
     0.596    20.422     0.200
     0.635    21.023     0.200
     0.634    20.211     0.200
     0.634    20.934     0.200
     0.641    20.484     0.200
     0.617    22.484     0.200
     0.622    21.391     0.200
     0.664    21.594     0.200
     0.666    21.633     0.200
     0.643    21.031     0.200
     0.652    21.234     0.200
     0.657    21.344     0.200
     0.664    21.531     0.200
     0.685    22.273     0.200
     0.685    22.273     0.200
     0.660    21.973     0.200
     0.661    22.613     0.200
     0.699    23.492     0.200
     0.682    22.371     0.200
     0.703    23.863     0.200
     0.699    22.441     0.200
     0.688    22.344     0.200
     0.707    22.914     0.200
     0.717    22.961     0.200
     0.733    24.191     0.200
     0.703    24.133     0.200
     0.708    23.242     0.200
     0.711    24.242     0.200
     0.747    26.164     0.200
     0.740    23.543     0.200
     0.736    23.723     0.200
     0.747    24.004     0.200
     0.759    23.832     0.200
     0.759    24.023     0.200
     0.761    24.023     0.200
     0.765    24.484     0.200
     0.753    24.473     0.200
     0.782    26.793     0.200
     0.794    26.922     0.200
     0.795    25.344     0.200
     0.773    25.191     0.200
     0.790    25.043     0.200
     0.780    25.773     0.200
     0.788    25.531     0.200
     0.787    25.641     0.200
     0.788    26.062     0.200
     0.808    25.473     0.200
     0.808    25.422     0.200
     0.807    26.453     0.200
     0.832    26.422     0.200
     0.853    26.492     0.200
     0.853    26.762     0.200
     0.857    26.812     0.200
     0.874    27.512     0.200
     0.875    27.852     0.200
     0.911    28.574     0.200
     1.353    39.012     0.200
     0.173     7.355     0.200
     0.158     6.536     0.200
     0.205     8.155     0.200
     0.215     9.315     0.200
     0.243     9.005     0.200
     0.232     8.555     0.200
     0.241     8.735     0.200
     0.246     9.025     0.200
     0.269     9.655     0.200
     0.316    11.315     0.200
     0.298    10.295     0.200
     0.296    10.425     0.200
     0.329    11.996     0.200
     0.299    10.775     0.200
     0.340    12.305     0.200
     0.342    12.405     0.200
     0.341    11.445     0.200
     0.324    11.095     0.200
     0.346    11.936     0.200
     0.374    13.155     0.200
     0.385    13.565     0.200
     0.391    13.215     0.200
     0.366    11.985     0.200
     0.371    12.355     0.200
     0.397    13.496     0.200
     0.427    14.286     0.200
     0.394    13.465     0.200
     0.429    14.985     0.200
     0.432    15.005     0.200
     0.418    15.825     0.200
     0.447    15.036     0.200
     0.442    14.976     0.200
     0.439    14.175     0.200
     0.434    14.505     0.200
     0.444    14.314     0.200
     0.444    14.396     0.200
     0.468    15.516     0.200
     0.502    16.206     0.200
     0.495    16.605     0.200
     0.509    16.925     0.200
     0.511    16.825     0.200
     0.517    16.706     0.200
     0.512    16.405     0.200
     0.528    17.525     0.200
     0.526    17.045     0.200
     0.542    17.496     0.200
     0.551    17.896     0.200
     0.521    16.505     0.200
     0.552    19.875     0.200
     0.542    19.215     0.200
     0.532    18.155     0.200
     0.565    18.825     0.200
     0.531    17.016     0.200
     0.534    17.845     0.200
     0.558    19.246     0.200
     0.540    17.485     0.200
     0.583    19.875     0.200
     0.598    19.286     0.200
     0.592    19.646     0.200
     0.594    19.375     0.200
     0.611    19.916     0.200
     0.633    22.266     0.200
     0.641    21.405     0.200
     0.628    20.706     0.200
     0.667    21.436     0.200
     0.650    22.025     0.200
     0.652    22.065     0.200
     0.662    21.585     0.200
     0.694    23.095     0.200
     0.676    22.175     0.200
     0.673    21.456     0.200
     0.673    21.496     0.200
     0.685    23.516     0.200
     0.673    21.575     0.200
     0.699    21.805     0.200
     0.707    23.615     0.200
     0.711    22.536     0.200
     0.682    22.735     0.200
     0.702    23.305     0.200
     0.688    22.565     0.200
     0.685    22.686     0.200
     0.695    22.375     0.200
     0.731    23.655     0.200
     0.711    22.465     0.200
     0.727    24.396     0.200
     0.721    23.195     0.200
     0.710    23.315     0.200
     0.739    22.976     0.200
     0.750    24.166     0.200
     0.759    25.115     0.200
     0.751    25.715     0.200
     0.773    25.396     0.200
     0.770    24.985     0.200
     0.791    24.646     0.200
     0.779    24.595     0.200
     0.831    25.575     0.200
     0.861    26.635     0.200
     0.885    27.305     0.200
     2.125    63.085     0.200
     2.213    65.635     0.200
     2.943    83.805     0.200
     0.029     2.047     0.200
     0.028     2.236     0.200
     0.083     4.916     0.200
     0.078     4.506     0.200
     0.119     6.096     0.200
     0.164     7.887     0.200
     0.166     7.906     0.200
     0.187     8.887     0.200
     0.206     9.455     0.200
     0.195     8.797     0.200
     0.202     7.576     0.200
     0.302    12.166     0.200
     0.307    10.355     0.200
     0.311    11.066     0.200
     0.360    13.547     0.200
     0.416    15.955     0.200
     0.467    16.086     0.200
     0.524    18.486     0.200
     0.549    19.775     0.200
     0.562    18.666     0.200
     0.558    20.217     0.200
     0.575    20.156     0.200
     0.570    18.535     0.200
     0.586    19.775     0.200
     0.641    21.836     0.200
     0.643    21.625     0.200
     0.651    22.396     0.200
     0.656    22.766     0.200
     0.665    21.346     0.200
     0.698    22.785     0.200
     0.692    23.756     0.200
     0.715    24.516     0.200
     0.722    23.896     0.200
     0.762    25.887     0.200
     0.772    25.516     0.200
     0.777    27.297     0.200
     0.788    25.365     0.200
     0.820    27.766     0.200
     0.825    26.625     0.200
     0.033     2.152     0.200
     0.088     5.012     0.200
     0.073     4.543     0.200
     0.124     6.252     0.200
     0.172     8.082     0.200
     0.170     7.951     0.200
     0.191     9.303     0.200
     0.208     9.422     0.200
     0.196     7.652     0.200
     0.307    12.293     0.200
     0.312     9.553     0.200
     0.315    10.992     0.200
     0.341    12.742     0.200
     0.373    14.082     0.200
     0.442    16.822     0.200
     0.446    16.092     0.200
     0.462    16.281     0.200
     0.496    17.432     0.200
     0.500    17.393     0.200
     0.521    18.293     0.200
     0.527    18.543     0.200
     0.549    19.463     0.200
     0.567    18.482     0.200
     0.579    20.252     0.200
     0.573    18.803     0.200
     0.589    20.252     0.200
     0.589    21.021     0.200
     0.596    21.262     0.200
     0.643    22.143     0.200
     0.640    21.701     0.200
     0.654    22.672     0.200
     0.656    22.262     0.200
     0.667    22.242     0.200
     0.702    22.963     0.200
     0.696    24.031     0.200
     0.716    24.502     0.200
     0.721    24.592     0.200
     0.726    24.232     0.200
     0.760    25.832     0.200
     0.775    24.822     0.200
     0.785    25.383     0.200
     0.784    26.871     0.200
     0.819    27.752     0.200
     0.914    29.092     0.200
     0.025     2.604     0.200
     0.064     4.322     0.200
     0.100     4.533     0.200
     0.094     4.854     0.200
     0.147     7.424     0.200
     0.147     7.383     0.200
     0.209     9.893     0.200
     0.207     9.254     0.200
     0.215     9.684     0.200
     0.220     8.023     0.200
     0.299    10.594     0.200
     0.299    10.914     0.200
     0.318    12.312     0.200
     0.347    13.363     0.200
     0.476    17.643     0.200
     0.505    18.072     0.200
     0.482    16.354     0.200
     0.547    18.393     0.200
     0.523    17.863     0.200
     0.555    18.033     0.200
     0.559    18.354     0.200
     0.559    20.584     0.200
     0.545    19.143     0.200
     0.606    20.023     0.200
     0.632    22.354     0.200
     0.646    21.193     0.200
     0.644    21.854     0.200
     0.652    21.723     0.200
     0.652    21.104     0.200
     0.668    23.014     0.200
     0.674    22.514     0.200
     0.661    22.334     0.200
     0.691    22.652     0.200
     0.713    23.674     0.200
     0.701    23.453     0.200
     0.712    24.062     0.200
     0.723    24.562     0.200
     0.755    24.094     0.200
     0.779    26.402     0.200
     0.796    27.723     0.200
     0.806    25.793     0.200
     0.052     3.947     0.200
     0.051     4.428     0.200
     0.094     5.557     0.200
     0.104     5.848     0.200
     0.104     5.848     0.200
     0.098     5.777     0.200
     0.157     7.678     0.200
     0.228     7.646     0.200
     0.228     7.377     0.200
     0.233     8.527     0.200
     0.237    10.047     0.200
     0.237    10.047     0.200
     0.246    10.127     0.200
     0.288    11.496     0.200
     0.272    10.137     0.200
     0.326    12.598     0.200
     0.317    12.406     0.200
     0.318    11.496     0.200
     0.367    12.938     0.200
     0.364    14.268     0.200
     0.362    14.727     0.200
     0.362    14.406     0.200
     0.484    16.018     0.200
     0.497    17.607     0.200
     0.511    17.348     0.200
     0.496    17.777     0.200
     0.518    17.916     0.200
     0.514    18.217     0.200
     0.510    18.217     0.200
     0.536    17.627     0.200
     0.523    19.188     0.200
     0.523    18.467     0.200
     0.547    18.557     0.200
     0.584    18.557     0.200
     0.579    19.896     0.200
     0.577    20.367     0.200
     0.593    19.137     0.200
     0.593    20.268     0.200
     0.607    20.656     0.200
     0.579    18.787     0.200
     0.600    20.617     0.200
     0.620    20.197     0.200
     0.642    21.518     0.200
     0.642    22.438     0.200
     0.635    22.217     0.200
     0.624    21.268     0.200
     0.666    22.857     0.200
     0.666    22.027     0.200
     0.672    22.707     0.200
     0.675    22.637     0.200
     0.696    23.598     0.200
     0.687    22.258     0.200
     0.766    25.207     0.200
     0.775    24.986     0.200
     0.764    24.598     0.200
     0.758    25.107     0.200
     0.774    24.338     0.200
     0.858    27.197     0.200
     0.977    30.277     0.200
     0.988    30.518     0.200
     1.040    31.717     0.200
     1.034    31.678     0.200
     1.391    40.396     0.200
     0.005     3.828     0.200
     0.065     4.426     0.200
     0.135     5.648     0.200
     0.179     7.355     0.200
     0.198     7.285     0.200
     0.218     7.727     0.200
     0.241     8.637     0.200
     0.267     9.285     0.200
     0.279    10.066     0.200
     0.275     9.457     0.200
     0.286     9.809     0.200
     0.282    10.785     0.200
     0.309    11.027     0.200
     0.331    11.559     0.200
     0.334    11.188     0.200
     0.336    12.246     0.200
     0.336    11.695     0.200
     0.342    13.188     0.200
     0.375    12.688     0.200
     0.355    13.336     0.200
     0.401    13.688     0.200
     0.404    13.719     0.200
     0.386    13.797     0.200
     0.390    13.719     0.200
     0.411    13.688     0.200
     0.404    14.328     0.200
     0.430    14.277     0.200
     0.438    14.887     0.200
     0.441    14.648     0.200
     0.444    14.926     0.200
     0.434    14.996     0.200
     0.465    15.559     0.200
     0.453    15.676     0.200
     0.486    15.637     0.200
     0.483    15.598     0.200
     0.476    17.309     0.200
     0.477    15.867     0.200
     0.483    17.066     0.200
     0.499    16.148     0.200
     0.510    16.625     0.200
     0.519    17.457     0.200
     0.533    16.898     0.200
     0.556    18.578     0.200
     0.574    18.125     0.200
     0.560    18.176     0.200
     0.568    18.977     0.200
     0.578    19.246     0.200
     0.607    19.746     0.200
     0.600    19.676     0.200
     0.612    19.418     0.200
     0.606    19.887     0.200
     0.598    19.578     0.200
     0.611    20.527     0.200
     0.609    20.527     0.200
     0.620    20.188     0.200
     0.616    21.266     0.200
     0.647    20.367     0.200
     0.645    21.047     0.200
     0.656    20.605     0.200
     0.652    20.766     0.200
     0.660    20.969     0.200
     0.656    22.758     0.200
     0.654    21.125     0.200
     0.673    21.445     0.200
     0.675    22.125     0.200
     0.682    21.688     0.200
     0.690    23.746     0.200
     0.706    24.777     0.200
     0.716    22.918     0.200
     0.704    22.668     0.200
     0.725    22.676     0.200
     0.729    22.758     0.200
     0.732    23.016     0.200
     0.741    23.098     0.200
     0.738    23.277     0.200
     0.728    23.707     0.200
     0.734    23.398     0.200
     0.751    23.316     0.200
     0.762    23.707     0.200
     0.768    23.785     0.200
     0.768    24.438     0.200
     0.787    24.605     0.200
     0.800    24.816     0.200
     0.802    24.945     0.200
     0.826    25.508     0.200
     0.835    25.969     0.200
     0.846    26.457     0.200
     0.854    26.516     0.200
     0.921    28.125     0.200
     1.280    36.617     0.200
     0.040     3.785     0.200
     0.124     6.445     0.200
     0.174     7.996     0.200
     0.195     8.516     0.200
     0.185     8.746     0.200
     0.193     9.285     0.200
     0.209     8.336     0.200
     0.242     9.336     0.200
     0.249     8.586     0.200
     0.287    12.246     0.200
     0.337    13.227     0.200
     0.322    12.707     0.200
     0.326    11.238     0.200
     0.356    12.707     0.200
     0.368    13.387     0.200
     0.448    16.758     0.200
     0.428    14.035     0.200
     0.439    15.715     0.200
     0.484    16.047     0.200
     0.483    16.496     0.200
     0.497    18.207     0.200
     0.553    18.496     0.200
     0.560    20.195     0.200
     0.603    21.016     0.200
     0.618    19.438     0.200
     0.617    22.258     0.200
     0.641    22.277     0.200
     0.652    20.855     0.200
     0.701    23.906     0.200
     0.709    24.867     0.200
     0.723    24.016     0.200
     0.752    26.047     0.200
     0.782    25.117     0.200
     0.801    26.598     0.200
     0.841    26.727     0.200
     0.835    26.086     0.200
     0.906    28.625     0.200
     0.124     6.457     0.200
     0.098     6.590     0.200
     0.163     8.156     0.200
     0.178     8.090     0.200
     0.154     8.699     0.200
     0.189     8.859     0.200
     0.196     8.789     0.200
     0.192     8.348     0.200
     0.179     9.598     0.200
     0.212     7.527     0.200
     0.240    10.148     0.200
     0.246     8.527     0.200
     0.288    11.406     0.200
     0.324    12.816     0.200
     0.330    11.340     0.200
     0.359    12.840     0.200
     0.367    13.758     0.200
     0.407    13.988     0.200
     0.432    13.969     0.200
     0.442    15.930     0.200
     0.446    17.379     0.200
     0.481    15.898     0.200
     0.486    16.719     0.200
     0.516    18.258     0.200
     0.497    18.090     0.200
     0.562    19.609     0.200
     0.556    18.078     0.200
     0.602    20.566     0.200
     0.615    19.367     0.200
     0.635    21.438     0.200
     0.650    20.578     0.200
     0.642    22.328     0.200
     0.709    24.738     0.200
     0.700    24.047     0.200
     0.726    24.477     0.200
     0.714    23.816     0.200
     0.751    25.637     0.200
     0.753    26.207     0.200
     0.748    23.957     0.200
     0.763    24.020     0.200
     0.786    25.289     0.200
     0.780    25.809     0.200
     0.798    25.500     0.200
     0.837    26.277     0.200
     0.982    30.066     0.200
     1.067    32.367     0.200
     0.035     3.117     0.200
     0.104     6.602     0.200
     0.125     6.641     0.200
     0.169     7.938     0.200
     0.162     8.859     0.200
     0.206     7.641     0.200
     0.199     8.500     0.200
     0.245    10.219     0.200
     0.287    11.789     0.200
     0.320    11.227     0.200
     0.352    12.578     0.200
     0.342    13.328     0.200
     0.371    14.039     0.200
     0.399    13.867     0.200
     0.423    13.633     0.200
     0.434    15.648     0.200
     0.452    16.477     0.200
     0.451    17.180     0.200
     0.478    16.469     0.200
     0.469    16.219     0.200
     0.488    16.297     0.200
     0.498    18.148     0.200
     0.519    18.641     0.200
     0.547    18.570     0.200
     0.559    19.883     0.200
     0.606    21.047     0.200
     0.629    20.539     0.200
     0.623    19.438     0.200
     0.623    20.008     0.200
     0.640    22.172     0.200
     0.655    20.883     0.200
     0.698    24.102     0.200
     0.720    24.180     0.200
     0.739    24.102     0.200
     0.721    24.062     0.200
     0.755    25.109     0.200
     0.762    25.109     0.200
     0.784    26.727     0.200
     0.773    25.367     0.200
     0.795    26.000     0.200
     0.785    25.492     0.200
     0.804    26.062     0.200
     0.832    26.078     0.200
     0.836    26.898     0.200
     0.831    26.883     0.200
     0.849    27.328     0.200
     0.887    28.211     0.200
     0.902    28.711     0.200
     0.936    29.008     0.200
     0.975    30.469     0.200
     0.988    30.938     0.200
     1.013    31.508     0.200
     1.070    32.766     0.200
     0.034     3.148     0.200
     0.105     6.609     0.200
     0.124     6.383     0.200
     0.168     7.867     0.200
     0.163     8.430     0.200
     0.179     8.164     0.200
     0.187     8.688     0.200
     0.186     9.680     0.200
     0.206     7.094     0.200
     0.199     8.500     0.200
     0.246     9.789     0.200
     0.288    11.289     0.200
     0.317    12.438     0.200
     0.351    12.609     0.200
     0.343    13.562     0.200
     0.371    13.789     0.200
     0.398    13.703     0.200
     0.422    13.789     0.200
     0.433    15.672     0.200
     0.452    17.008     0.200
     0.451    16.734     0.200
     0.478    16.531     0.200
     0.470    16.102     0.200
     0.498    18.492     0.200
     0.488    16.094     0.200
     0.547    17.930     0.200
     0.559    20.180     0.200
     0.607    21.422     0.200
     0.640    22.180     0.200
     0.623    19.320     0.200
     0.655    20.594     0.200
     0.699    23.461     0.200
     0.720    23.180     0.200
     0.707    24.867     0.200
     0.723    23.898     0.200
     0.746    25.305     0.200
     0.750    25.719     0.200
     0.785    26.555     0.200
     0.786    25.211     0.200
     0.796    24.570     0.200
     0.805    27.039     0.200
     0.827    26.859     0.200
     0.836    26.750     0.200
     0.902    28.422     0.200
     1.014    31.383     0.200
     1.167    35.383     0.200
     0.106     6.516     0.200
     0.120     6.430     0.200
     0.162     8.711     0.200
     0.156     7.820     0.200
     0.187     9.531     0.200
     0.173     8.047     0.200
     0.181     8.797     0.200
     0.194     8.414     0.200
     0.188     8.945     0.200
     0.211     8.281     0.200
     0.247    10.234     0.200
     0.292    11.375     0.200
     0.316    12.641     0.200
     0.343    13.352     0.200
     0.322    11.156     0.200
     0.357    12.672     0.200
     0.366    13.797     0.200
     0.426    14.172     0.200
     0.454    16.945     0.200
     0.438    15.883     0.200
     0.446    16.781     0.200
     0.471    16.555     0.200
     0.482    15.953     0.200
     0.483    16.711     0.200
     0.502    18.312     0.200
     0.514    18.227     0.200
     0.551    18.461     0.200
     0.564    19.914     0.200
     0.555    18.930     0.200
     0.609    20.992     0.200
     0.618    19.664     0.200
     0.635    21.281     0.200
     0.645    22.273     0.200
     0.650    20.656     0.200
     0.722    23.609     0.200
     0.703    24.742     0.200
     0.725    24.000     0.200
     0.744    24.266     0.200
     0.744    25.625     0.200
     0.760    25.445     0.200
     0.747    26.031     0.200
     0.767    24.086     0.200
     0.774    25.359     0.200
     0.787    25.156     0.200
     0.801    26.055     0.200
     0.829    26.047     0.200
     0.841    26.734     0.200
     0.907    28.383     0.200
     0.042     3.836     0.200
     0.101     6.508     0.200
     0.122     6.352     0.200
     0.178     8.109     0.200
     0.187     8.969     0.200
     0.181     9.438     0.200
     0.191     8.250     0.200
     0.194     8.742     0.200
     0.242    10.047     0.200
     0.249     8.703     0.200
     0.290    12.281     0.200
     0.321    12.727     0.200
     0.337    13.258     0.200
     0.365    13.680     0.200
     0.360    12.797     0.200
     0.432    14.219     0.200
     0.443    15.852     0.200
     0.449    17.258     0.200
     0.479    15.648     0.200
     0.487    16.742     0.200
     0.500    18.148     0.200
     0.559    19.219     0.200
     0.557    18.367     0.200
     0.564    19.898     0.200
     0.605    20.977     0.200
     0.614    19.508     0.200
     0.637    21.133     0.200
     0.648    20.906     0.200
     0.645    22.133     0.200
     0.698    23.477     0.200
     0.715    23.648     0.200
     0.749    25.578     0.200
     0.751    25.930     0.200
     0.749    24.336     0.200
     0.782    25.617     0.200
     0.800    26.039     0.200
     0.803    26.672     0.200
     0.835    26.086     0.200
     0.835    26.617     0.200
     0.910    28.609     0.200
     1.015    31.398     0.200
     0.146     6.340     0.200
     0.189     7.141     0.200
     0.187     7.711     0.200
     0.249     9.680     0.200
     0.252     9.160     0.200
     0.267     9.742     0.200
     0.283    10.941     0.200
     0.291    11.500     0.200
     0.352    13.930     0.200
     0.355    13.020     0.200
     0.349    12.820     0.200
     0.370    12.871     0.200
     0.392    15.402     0.200
     0.388    12.941     0.200
     0.401    15.551     0.200
     0.403    14.289     0.200
     0.390    13.250     0.200
     0.415    15.973     0.200
     0.420    13.871     0.200
     0.432    15.250     0.200
     0.426    14.020     0.200
     0.441    17.109     0.200
     0.445    15.422     0.200
     0.446    14.840     0.200
     0.467    16.223     0.200
     0.479    15.621     0.200
     0.490    15.961     0.200
     0.503    16.359     0.200
     0.525    18.430     0.200
     0.541    17.492     0.200
     0.562    18.062     0.200
     0.577    20.000     0.200
     0.568    18.383     0.200
     0.575    18.242     0.200
     0.606    20.422     0.200
     0.607    19.609     0.200
     0.615    21.902     0.200
     0.654    21.480     0.200
     0.646    20.699     0.200
     0.664    21.020     0.200
     0.668    22.211     0.200
     0.685    22.031     0.200
     0.688    21.883     0.200
     0.692    21.723     0.200
     0.695    21.789     0.200
     0.695    22.078     0.200
     0.695    22.121     0.200
     0.688    21.789     0.200
     0.713    22.402     0.200
     0.724    22.492     0.200
     0.730    23.699     0.200
     0.741    23.902     0.200
     0.757    24.859     0.200
     0.751    24.812     0.200
     0.773    24.422     0.200
     0.777    24.242     0.200
     0.791    24.922     0.200
     0.845    26.133     0.200
     0.863    26.230     0.200
     0.289    10.888     0.200
     0.307    10.368     0.200
     0.335    12.188     0.200
     0.326    11.167     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.841    85.238     0.200
     3.920   123.758     0.200
     4.156   132.718     0.200
     4.266   134.378     0.200
     4.411   139.408     0.200
     4.445   142.678     0.200
     4.873   156.948     0.200
     5.035   163.124     0.200
     5.550   173.128     0.200
     5.725   183.769     0.200
     6.761   215.658     0.200
     6.802   214.068     0.200
     6.967   221.528     0.200
     6.997   222.108     0.200
     7.587   239.948     0.200
     8.044   251.479     0.200
     8.101   249.588     0.200
     8.643   275.998     0.200
     9.228   289.979     0.200
    11.448   358.613     0.200
     1.745    53.924     0.200
     1.768    54.688     0.200
     1.790    56.098     0.200
     1.805    57.039     0.200
     1.807    56.221     0.200
     1.900    58.059     0.200
     2.015    63.219     0.200
     2.027    64.375     0.200
     2.066    64.875     0.200
     2.098    64.750     0.200
     2.148    66.201     0.200
     2.164    67.982     0.200
     2.214    68.348     0.200
     2.387    73.508     0.200
     2.425    76.330     0.200
     2.547    79.055     0.200
     2.586    79.787     0.200
     2.814    85.906     0.200
     2.853    87.650     0.200
     2.963    90.828     0.200
     3.074    94.656     0.200
     3.972   125.465     0.200
     4.278   135.084     0.200
     4.342   136.414     0.200
     4.511   141.404     0.200
     4.809   153.414     0.200
     4.857   155.367     0.200
     6.601   210.805     0.200
     6.745   214.654     0.200
     6.872   219.465     0.200
     6.911   214.914     0.200
     6.950   218.865     0.200
     7.113   223.314     0.200
     7.483   239.975     0.200
     7.959   253.855     0.200
     8.002   249.674     0.200
     8.129   254.625     0.200
     8.350   270.615     0.200
     9.124   289.984     0.200
     1.700    53.300     0.200
     1.727    55.052     0.200
     1.741    54.485     0.200
     1.961    59.998     0.200
     1.922    60.850     0.200
     1.994    61.476     0.200
     1.993    61.269     0.200
     2.041    63.670     0.200
     1.960    60.979     0.200
     1.999    62.160     0.200
     2.209    68.522     0.200
     2.268    72.740     0.200
     2.320    72.694     0.200
     2.396    74.761     0.200
     2.384    74.523     0.200
     2.681    82.774     0.200
     2.673    82.428     0.200
     2.715    85.305     0.200
     2.696    83.637     0.200
     2.768    86.724     0.200
     2.793    87.517     0.200
     2.785    87.285     0.200
     3.050    94.379     0.200
     3.232   100.090     0.200
     3.830   118.601     0.200
     4.520   141.410     0.200
     4.561   143.720     0.200
     4.700   150.101     0.200
     4.947   156.920     0.200
     5.609   179.569     0.200
     6.043   189.330     0.200
     7.420   237.120     0.200
     7.646   241.610     0.200
     7.646   241.800     0.200
     7.756   244.630     0.200
     7.892   249.271     0.200
     1.637    50.858     0.200
     1.757    54.801     0.200
     1.875    59.363     0.200
     1.917    59.692     0.200
     1.976    63.543     0.200
     2.018    62.753     0.200
     2.035    64.009     0.200
     2.214    68.766     0.200
     2.271    70.989     0.200
     2.268    70.852     0.200
     2.583    79.840     0.200
     2.635    82.054     0.200
     2.695    83.106     0.200
     2.704    83.552     0.200
     2.769    86.111     0.200
     5.195   164.812     0.200
    11.671   368.583     0.200
     1.614    49.305     0.200
     1.641    51.461     0.200
     1.761    55.078     0.200
     1.974    62.742     0.200
     1.920    59.711     0.200
     2.015    62.250     0.200
     2.217    68.609     0.200
     2.217    68.781     0.200
     2.274    70.297     0.200
     2.586    79.711     0.200
     2.692    83.453     0.200
     2.771    86.195     0.200
     2.771    84.781     0.200
     4.811   149.555     0.200
     4.981   155.352     0.200
     6.131   192.555     0.200
     7.342   228.312     0.200
     7.508   236.523     0.200
     1.623    50.590     0.200
     1.662    51.742     0.200
     1.795    56.168     0.200
     1.899    58.832     0.200
     2.084    65.176     0.200
     2.079    64.609     0.200
     2.250    69.500     0.200
     2.295    71.242     0.200
     2.402    73.914     0.200
     2.439    76.605     0.200
     2.530    78.758     0.200
     2.530    79.129     0.200
     2.600    82.039     0.200
     2.936    90.223     0.200
     5.052   160.465     0.200
     8.739   273.766     0.200
    10.887   347.578     0.200
     1.629    51.043     0.200
     1.664    50.828     0.200
     1.800    56.750     0.200
     1.899    58.973     0.200
     2.087    65.422     0.200
     2.085    64.934     0.200
     2.147    66.152     0.200
     2.257    69.988     0.200
     2.295    71.469     0.200
     2.408    74.000     0.200
     2.445    76.402     0.200
     2.532    78.668     0.200
     2.604    81.719     0.200
     2.942    90.465     0.200
     1.756    53.820     0.200
     1.718    53.148     0.200
     1.781    53.457     0.200
     1.812    54.238     0.200
     1.827    55.246     0.200
     1.832    57.086     0.200
     1.860    58.188     0.200
     2.110    65.574     0.200
     2.121    64.797     0.200
     2.160    67.129     0.200
     2.156    68.133     0.200
     2.232    69.086     0.200
     2.349    72.113     0.200
     2.370    71.594     0.200
     2.342    71.754     0.200
     2.372    71.480     0.200
     2.423    74.992     0.200
     3.240   102.598     0.200
     4.226   133.828     0.200
     5.456   172.488     0.200
     5.910   187.879     0.200
     6.025   188.078     0.200
     7.084   226.148     0.200
     7.243   229.887     0.200
     7.358   231.559     0.200
     7.512   239.246     0.200
     7.555   240.277     0.200
     7.643   240.508     0.200
     7.652   240.586     0.200
     7.872   244.105     0.200
     7.935   251.309     0.200
    11.070   349.223     0.200
     1.670    51.525     0.200
     1.739    54.525     0.200
     1.758    53.139     0.200
     1.787    53.769     0.200
     1.853    59.139     0.200
     2.139    67.438     0.200
     2.171    66.954     0.200
     2.186    70.209     0.200
     2.215    69.479     0.200
     2.239    68.808     0.200
     2.343    70.825     0.200
     2.373    72.562     0.200
     2.367    71.715     0.200
     2.360    72.010     0.200
     2.447    75.589     0.200
     4.237   132.938     0.200
     4.290   136.999     0.200
     4.668   148.608     0.200
     4.859   155.409     0.200
     5.528   177.729     0.200
     5.933   189.459     0.200
     5.955   189.938     0.200
     7.096   222.559     0.200
     7.173   227.309     0.200
     7.528   239.068     0.200
     7.571   239.169     0.200
     7.642   239.898     0.200
     1.693    53.547     0.200
     1.873    58.301     0.200
     2.082    64.578     0.200
     2.145    66.234     0.200
     1.623    50.690     0.200
     1.678    50.091     0.200
     1.784    53.418     0.200
     1.861    59.188     0.200
     1.977    60.599     0.200
     1.977    60.233     0.200
     1.997    62.637     0.200
     2.066    63.052     0.200
     2.116    67.188     0.200
     2.912    91.339     0.200
     3.998   125.608     0.200
     4.103   132.639     0.200
     4.501   142.049     0.200
     4.562   146.879     0.200
     4.823   150.948     0.200
     4.932   154.219     0.200
     4.959   155.289     0.200
     5.409   171.209     0.200
     6.454   203.229     0.200
     6.496   205.919     0.200
     7.027   222.599     0.200
     7.122   222.408     0.200
     7.268   227.429     0.200
    12.202   385.959     0.200
     1.646    50.748     0.200
     1.879    58.459     0.200
     1.872    58.739     0.200
     1.881    58.159     0.200
     1.922    59.600     0.200
     2.069    64.066     0.200
     2.287    70.444     0.200
     2.324    72.229     0.200
     2.319    71.484     0.200
     3.184   100.029     0.200
     3.640   113.880     0.200
     4.837   152.229     0.200
     5.117   165.040     0.200
     5.165   162.409     0.200
     5.345   168.159     0.200
     5.380   168.380     0.200
     6.004   187.489     0.200
     6.039   188.260     0.200
     7.787   243.725     0.200
     8.159   253.920     0.200
     1.652    51.031     0.200
     1.773    53.652     0.200
     1.883    58.680     0.200
     1.878    57.691     0.200
     1.928    57.652     0.200
    11.465   360.914     0.200
     1.671    50.426     0.200
     1.811    56.334     0.200
     1.930    59.934     0.200
     1.977    61.474     0.200
     2.026    62.995     0.200
     2.100    64.140     0.200
     2.270    70.601     0.200
     2.270    70.844     0.200
     2.328    72.726     0.200
     2.642    81.315     0.200
     2.829    87.812     0.200
     2.829    88.023     0.200
     3.271   104.174     0.200
     3.362   105.864     0.200
     4.674   149.404     0.200
     4.990   155.514     0.200
     5.252   167.225     0.200
     5.656   176.264     0.200
     6.133   192.233     0.200
     7.053   221.914     0.200
     7.234   226.364     0.200
     7.397   232.249     0.200
     7.875   248.744     0.200
     7.939   246.754     0.200
     7.988   253.414     0.200
     8.398   262.924     0.200
     8.398   264.364     0.200
     8.854   281.934     0.200
     9.392   294.813     0.200
     9.558   297.184     0.200
    10.801   344.074     0.200
     1.775    53.156     0.200
     1.913    60.094     0.200
     2.056    64.359     0.200
     2.199    68.797     0.200
     2.274    71.352     0.200
     2.768    86.977     0.200
     2.768    85.922     0.200
     5.207   165.727     0.200
     7.378   233.117     0.200
    10.808   347.859     0.200
    11.695   366.875     0.200
    14.835   471.820     0.200
     1.661    51.281     0.200
     1.866    57.555     0.200
     1.919    58.445     0.200
     1.968    61.422     0.200
     1.998    62.148     0.200
     2.085    63.000     0.200
     2.159    65.414     0.200
     2.232    68.352     0.200
     2.386    73.836     0.200
     7.592   234.586     0.200
     7.681   241.477     0.200
     8.113   253.484     0.200
     1.699    53.918     0.200
     1.937    60.758     0.200
     1.912    61.281     0.200
     1.986    61.762     0.200
     2.235    70.859     0.200
     2.272    71.168     0.200
     2.361    74.316     0.200
     2.497    79.457     0.200
     2.650    83.098     0.200
     2.723    84.203     0.200
     2.788    87.992     0.200
     4.349   136.133     0.200
     4.445   139.273     0.200
     4.407   137.781     0.200
     5.651   177.512     0.200
     6.461   199.852     0.200
     6.698   212.082     0.200
     6.841   213.973     0.200
     7.398   233.461     0.200
     7.418   237.383     0.200
     7.426   234.812     0.200
     1.624    49.945     0.200
     1.731    53.336     0.200
     2.607    80.180     0.200
     2.728    84.266     0.200
     5.820   185.836     0.200
     7.694   241.727     0.200
     7.800   243.703     0.200
    10.803   346.430     0.200
    10.838   341.672     0.200
     1.878    58.477     0.200
     1.897    60.023     0.200
     2.118    65.148     0.200
     2.170    67.016     0.200
     2.231    69.781     0.200
     2.315    71.520     0.200
     2.402    74.348     0.200
     3.897   122.031     0.200
     4.851   152.172     0.200
     5.241   161.801     0.200
     5.383   166.320     0.200
     7.844   249.109     0.200
     1.662    51.648     0.200
     1.853    57.422     0.200
     1.805    56.305     0.200
     1.869    57.750     0.200
     1.894    58.367     0.200
     1.945    58.922     0.200
     2.093    64.617     0.200
     2.332    72.062     0.200
     3.931   123.062     0.200
     5.505   173.820     0.200
     5.864   183.688     0.200
     1.801    55.367     0.200
     1.884    56.930     0.200
     1.885    57.711     0.200
     1.848    57.742     0.200
     2.450    74.898     0.200
     5.755   185.273     0.200
     1.621    49.676     0.200
     1.621    50.785     0.200
     1.622    50.816     0.200
     1.731    54.023     0.200
     1.714    52.375     0.200
     1.785    55.203     0.200
     1.832    57.109     0.200
     1.850    57.398     0.200
     1.850    57.547     0.200
     1.936    59.605     0.200
     1.938    59.484     0.200
     1.935    60.016     0.200
     2.041    63.805     0.200
     2.181    66.996     0.200
     3.612   111.176     0.200
     4.884   153.480     0.200
     8.091   252.891     0.200
     1.620    50.901     0.200
     1.620    51.591     0.200
     1.623    52.021     0.200
     1.641    52.891     0.200
     1.713    53.011     0.200
     1.713    53.681     0.200
     1.739    54.395     0.200
     1.781    55.736     0.200
     1.836    57.220     0.200
     1.850    57.657     0.200
     1.850    57.361     0.200
     1.924    59.501     0.200
     1.930    59.761     0.200
     1.931    59.495     0.200
     1.935    60.911     0.200
     2.173    66.466     0.200
     2.258    69.776     0.200
     2.428    74.739     0.200
     5.639   182.151     0.200
     7.475   239.821     0.200
     7.496   237.591     0.200
     1.626    51.742     0.200
     1.664    51.625     0.200
     1.640    51.672     0.200
     1.680    52.492     0.200
     1.703    53.172     0.200
     1.851    58.098     0.200
     2.036    63.613     0.200
     2.036    63.902     0.200
     2.061    65.715     0.200
     2.076    64.637     0.200
     4.822   151.664     0.200
     5.708   177.734     0.200
     1.748    53.715     0.200
     1.903    62.262     0.200
     2.186    68.441     0.200
     2.405    74.324     0.200
     2.602    80.785     0.200
     2.728    84.203     0.200
     5.827   185.496     0.200
     1.741    53.695     0.200
     2.325    72.406     0.200
     2.384    74.125     0.200
     2.418    74.523     0.200
     2.560    79.555     0.200
     2.614    80.727     0.200
     2.738    85.102     0.200
     7.803   245.430     0.200
     1.738    53.734     0.200
     2.417    73.992     0.200
     2.734    84.523     0.200
     7.802   244.555     0.200
    10.375   327.664     0.200
     2.414    75.875     0.200
     2.502    78.078     0.200
     2.609    81.773     0.200
     2.733    85.023     0.200
     7.806   245.367     0.200
    10.839   341.617     0.200
     1.755    54.367     0.200
     1.768    55.859     0.200
     2.381    73.711     0.200
     2.594    81.312     0.200
     2.733    84.234     0.200
     3.018    92.680     0.200
     7.857   246.641     0.200
    10.865   339.414     0.200
     1.628    50.039     0.200
     1.739    52.758     0.200
     7.512   242.539     0.200
     7.805   244.336     0.200
    10.839   340.812     0.200
     2.118    66.109     0.200
     2.179    67.375     0.200
     2.386    73.555     0.200
     2.394    74.914     0.200
     2.464    76.133     0.200
     2.611    81.211     0.200
     2.728    84.320     0.200
     3.337   101.336     0.200
     7.787   245.586     0.200
     8.070   257.656     0.200
     1.800    54.406     0.200
     2.397    73.836     0.200
     3.679   118.547     0.200
     7.849   247.406     0.200
     8.108   260.930     0.200
    10.850   339.164     0.200
     1.743    55.570     0.200
     2.390    74.719     0.200
     2.410    75.695     0.200
     2.737    84.891     0.200
     3.005    93.336     0.200
     7.789   245.156     0.200
     2.131    65.805     0.200
     2.623    81.420     0.200
     2.742    85.346     0.200
     3.645   114.740     0.200
     5.828   182.807     0.200
     7.472   235.080     0.200
     7.783   244.352     0.200
     1.760    54.102     0.200
     2.403    73.391     0.200
     2.572    77.672     0.200
     7.823   245.941     0.200
     1.761    54.571     0.200
     2.362    72.714     0.200
     2.724    84.378     0.200
     7.828   242.813     0.200
     8.211   258.383     0.200
    10.856   341.688     0.200
    10.830   346.565     0.200
     1.650    50.803     0.200
     1.845    57.064     0.200
     1.934    60.090     0.200
     2.098    62.832     0.200
     2.082    64.417     0.200
     2.246    68.906     0.200
     2.312    71.412     0.200
     2.320    71.110     0.200
     2.433    75.292     0.200
     2.555    78.865     0.200
     2.700    83.048     0.200
     1.968    61.664     0.200
     2.016    64.258     0.200
     2.070    63.578     0.200
     2.313    71.242     0.200
     2.366    73.219     0.200
     2.482    77.859     0.200
     2.553    78.625     0.200
     2.665    84.422     0.200
     4.655   146.094     0.200
     4.896   155.242     0.200
     6.868   215.570     0.200
     7.959   248.789     0.200
     1.706    53.570     0.200
     1.849    57.523     0.200
     1.858    55.711     0.200
     1.941    59.742     0.200
     1.973    61.781     0.200
     2.057    64.586     0.200
     2.228    68.328     0.200
     2.344    72.297     0.200
     2.372    73.164     0.200
     2.447    75.898     0.200
     3.233    98.898     0.200
     5.671   179.797     0.200
     5.858   185.547     0.200
     7.282   227.965     0.200
     1.731    54.086     0.200
     1.875    58.602     0.200
     1.982    61.836     0.200
     1.981    62.273     0.200
     2.184    68.164     0.200
     2.399    75.312     0.200
     2.588    79.609     0.200
     2.589    79.289     0.200
     2.546    78.492     0.200
     5.141   164.680     0.200
     5.141   164.680     0.200
     1.622    49.697     0.200
     2.371    72.597     0.200
     2.507    78.038     0.200
     2.593    80.741     0.200
     1.676    50.695     0.200
     1.749    54.953     0.200
     5.540   176.707     0.200
     7.458   235.336     0.200
     7.876   244.078     0.200
     2.548    79.766     0.200
     5.611   176.906     0.200
     1.630    51.055     0.200
     1.851    57.174     0.200
     1.974    61.891     0.200
     2.023    62.770     0.200
     2.038    63.199     0.200
     2.099    64.555     0.200
     2.430    74.793     0.200
     2.686    82.350     0.200
     1.653    50.645     0.200
     1.849    57.914     0.200
     2.017    62.940     0.200
     2.182    67.699     0.200
     2.213    69.361     0.200
     2.224    69.441     0.200
     1.654    51.691     0.200
     7.545   235.447     0.200
     7.798   243.492     0.200
     1.611    48.687     0.200
     1.878    58.755     0.200
     1.937    60.711     0.200
     1.973    62.404     0.200
     2.057    64.003     0.200
     2.435    76.058     0.200
     2.600    80.943     0.200
     2.649    82.064     0.200
     4.849   153.559     0.200
     6.829   214.831     0.200
     7.974   248.352     0.200
     1.883    59.105     0.200
     1.938    61.203     0.200
     1.985    62.781     0.200
     2.065    65.129     0.200
     2.445    76.652     0.200
     2.630    82.965     0.200
     2.656    83.406     0.200
     4.860   152.613     0.200
     6.842   214.723     0.200
     6.984   221.723     0.200
     7.978   248.973     0.200
     1.696    52.709     0.200
     1.696    52.149     0.200
     2.325    71.279     0.200
     2.589    79.605     0.200
     5.677   180.604     0.200
     7.572   238.448     0.200
     7.836   246.674     0.200
     1.658    52.617     0.200
     2.211    68.883     0.200
     2.159    67.867     0.200
     5.083   162.023     0.200
     6.961   219.602     0.200
     7.757   240.531     0.200
     1.671    52.457     0.200
     4.596   147.418     0.200
     6.894   215.812     0.200
     8.679   268.984     0.200
    12.180   385.867     0.200
     1.645    50.287     0.200
     1.764    53.695     0.200
     2.033    64.432     0.200
     2.102    65.818     0.200
     9.647   304.633     0.200
    10.751   338.994     0.200
    10.769   342.211     0.200
    11.664   366.756     0.200
    14.814   468.668     0.200
    26.938   846.395     0.200
     1.788    54.875     0.200
     2.411    73.039     0.200
     2.624    80.430     0.200
     2.760    85.047     0.200
     5.873   185.047     0.200
     1.804    55.520     0.200
     2.193    67.828     0.200
     2.450    74.379     0.200
     2.674    81.906     0.200
     5.928   188.035     0.200
     7.804   244.262     0.200
     7.818   241.570     0.200
    10.793   339.051     0.200
     1.617    51.293     0.200
     1.910    58.719     0.200
     2.242    69.586     0.200
     2.262    70.059     0.200
     2.499    77.395     0.200
     2.664    82.781     0.200
     2.973    92.410     0.200
     7.988   248.746     0.200
     1.725    51.641     0.200
     1.881    59.930     0.200
     2.127    67.543     0.200
     2.176    67.004     0.200
     2.176    68.363     0.200
     2.245    68.945     0.200
     2.361    73.004     0.200
     2.444    75.508     0.200
     5.518   173.715     0.200
     7.432   233.363     0.200
     7.864   243.863     0.200
    10.064   315.148     0.200
    10.620   338.914     0.200
    11.053   345.551     0.200
     2.449    76.050     0.200
     1.886    61.104     0.200
     5.520   173.153     0.200
     7.428   235.411     0.200
     7.849   243.499     0.200
    11.040   350.221     0.200
     1.852    57.442     0.200
     2.174    67.205     0.200
     2.243    69.010     0.200
     2.361    72.840     0.200
     2.378    72.158     0.200
     2.446    75.338     0.200
     5.524   175.238     0.200
     7.869   244.433     0.200
     1.731    53.482     0.200
     1.852    57.770     0.200
     2.174    66.700     0.200
     2.243    68.611     0.200
     2.446    75.167     0.200
     5.523   178.119     0.200
     7.438   231.310     0.200
     7.868   242.714     0.200
     1.638    50.672     0.200
     2.378    73.531     0.200
     7.775   245.930     0.200
     2.433    74.438     0.200
     5.875   190.008     0.200
     7.750   246.453     0.200
     7.809   242.125     0.200
    10.815   339.703     0.200
     1.706    54.242     0.200
     1.796    56.953     0.200
     2.152    67.500     0.200
     2.401    74.836     0.200
     2.430    75.359     0.200
     2.539    78.297     0.200
     2.638    80.961     0.200
     2.770    85.906     0.200
     7.748   241.672     0.200
     7.810   241.453     0.200
    10.817   340.516     0.200
    10.851   344.133     0.200
     1.668    52.113     0.200
     1.908    58.691     0.200
     1.928    59.918     0.200
     2.153    66.414     0.200
     2.145    67.754     0.200
     2.295    71.078     0.200
     5.488   173.637     0.200
     1.618    51.023     0.200
     1.707    53.148     0.200
     2.696    82.109     0.200
     5.674   180.406     0.200
     7.575   239.211     0.200
     1.611    50.233     0.200
     1.635    48.754     0.200
     1.762    55.065     0.200
     1.766    55.468     0.200
     1.890    58.818     0.200
     2.128    65.600     0.200
     2.156    67.801     0.200
     2.233    69.838     0.200
     2.263    70.408     0.200
     2.320    71.861     0.200
     2.362    72.695     0.200
     2.520    77.738     0.200
     2.978    91.007     0.200
     2.992    91.637     0.200
     5.465   172.582     0.200
     7.639   239.252     0.200
     8.511   264.202     0.200
     9.884   312.912     0.200
     1.693    52.969     0.200
     1.819    57.305     0.200
     1.849    57.859     0.200
     1.997    62.516     0.200
     2.021    62.711     0.200
     2.132    66.047     0.200
     2.148    66.688     0.200
     2.203    68.859     0.200
     2.407    75.383     0.200
     2.515    77.750     0.200
     2.680    83.352     0.200
     2.700    84.273     0.200
     1.646    51.244     0.200
     1.652    50.080     0.200
     1.680    52.557     0.200
     1.700    53.052     0.200
     1.818    54.990     0.200
     1.852    58.200     0.200
     1.916    60.370     0.200
     1.976    62.864     0.200
     2.104    65.425     0.200
     2.338    73.547     0.200
     2.393    74.969     0.200
     2.580    81.096     0.200
     4.777   151.156     0.200
     6.868   213.133     0.200
     8.217   254.688     0.200
     1.697    52.482     0.200
     1.770    54.316     0.200
     1.900    58.319     0.200
     1.958    60.855     0.200
     1.953    61.356     0.200
     2.014    62.719     0.200
     2.047    63.665     0.200
     2.065    65.098     0.200
     7.390   232.179     0.200
     8.303   259.873     0.200
     9.756   307.287     0.200
     1.862    57.874     0.200
     1.939    59.632     0.200
     2.017    63.030     0.200
     2.083    64.489     0.200
     2.333    71.740     0.200
     2.499    77.258     0.200
     2.796    86.812     0.200
     5.696   179.482     0.200
     7.691   240.257     0.200
     1.643    51.461     0.200
     1.653    51.023     0.200
     1.678    52.469     0.200
     1.699    53.078     0.200
     1.820    55.984     0.200
     1.850    57.469     0.200
     1.912    60.227     0.200
     1.971    62.258     0.200
     2.333    73.305     0.200
     2.391    74.727     0.200
     4.772   149.055     0.200
     8.216   254.820     0.200
     1.651    51.883     0.200
     1.716    52.250     0.200
     2.011    62.711     0.200
     2.290    70.688     0.200
     2.313    72.258     0.200
     2.336    72.023     0.200
     2.506    77.609     0.200
     2.619    81.320     0.200
     2.664    81.492     0.200
     5.713   182.492     0.200
     7.608   238.109     0.200
     7.839   247.102     0.200
    10.928   343.844     0.200
     1.630    51.606     0.200
     1.731    53.319     0.200
     1.825    56.396     0.200
     1.941    60.162     0.200
     2.097    64.000     0.200
     2.464    78.438     0.200
     2.988    95.209     0.200
     3.133    98.374     0.200
     3.501   108.212     0.200
     3.543   111.669     0.200
     3.752   118.909     0.200
     5.089   161.075     0.200
     7.369   231.341     0.200
     9.470   297.319     0.200
    11.978   375.841     0.200
     5.714   179.102     0.200
     7.731   242.352     0.200
    11.174   353.051     0.200
     1.848    58.027     0.200
     7.807   243.306     0.200
     7.835   248.487     0.200
    10.763   341.361     0.200
     4.787   149.320     0.200
     6.770   209.586     0.200
     7.979   247.953     0.200
     9.346   291.977     0.200
    14.280   448.703     0.200
     7.906   248.000     0.200
    11.125   351.922     0.200
     5.445   173.434     0.200
     7.377   231.633     0.200
     7.900   245.777     0.200
     4.988   160.180     0.200
     7.268   225.908     0.200
     8.697   270.777     0.200
     8.453   265.013     0.200
     7.547   236.518     0.200
     7.812   243.662     0.200
    10.936   344.533     0.200
     8.167   253.406     0.200
    11.197   350.438     0.200
     7.488   235.750     0.200
     7.862   244.145     0.200
    11.019   344.578     0.200
     5.580   177.539     0.200
     5.556   175.539     0.200
     7.462   235.789     0.200
     1.646    50.680     0.200
     4.725   148.703     0.200
     5.801   185.086     0.200
     7.688   242.039     0.200
     7.829   244.656     0.200
    10.872   344.562     0.200
     7.676   241.445     0.200
     7.825   245.656     0.200
    10.802   344.062     0.200
    10.872   345.500     0.200
     5.791   182.403     0.200
     7.679   238.532     0.200
     7.831   244.901     0.200
    10.334   326.685     0.200
    10.804   342.220     0.200
    22.525   713.157     0.200
     5.781   182.163     0.200
     7.671   240.505     0.200
    10.798   342.749     0.200
    10.885   343.480     0.200
     5.802   185.007     0.200
    10.870   344.344     0.200
    15.245   484.201     0.200
     7.669   243.477     0.200
     7.827   246.545     0.200
    10.881   342.278     0.200
     7.668   241.148     0.200
     7.813   244.867     0.200
     5.787   183.535     0.200
     7.669   238.375     0.200
     7.813   241.094     0.200
    10.788   344.773     0.200
     7.672   237.617     0.200
     7.815   244.016     0.200
    10.792   340.938     0.200
    10.867   340.469     0.200
     5.821   181.703     0.200
     7.709   241.609     0.200
     7.833   244.672     0.200
    10.864   343.219     0.200
     5.662   180.039     0.200
     7.534   234.969     0.200
     7.778   243.039     0.200
     5.675   177.992     0.200
     7.558   236.930     0.200
     7.806   243.695     0.200
    10.923   341.695     0.200
     5.119   163.723     0.200
     7.439   233.174     0.200
     8.828   276.693     0.200
     9.471   297.062     0.200
     7.796   243.648     0.200
     5.671   180.883     0.200
     7.552   239.000     0.200
     7.799   245.398     0.200
     7.840   247.660     0.200
     5.698   178.188     0.200
     7.586   235.453     0.200
     7.820   245.547     0.200
    10.245   322.484     0.200
    10.726   339.918     0.200
    10.921   345.812     0.200
    15.140   479.320     0.200
    22.456   708.227     0.200
    29.368   929.996     0.200
     1.689    52.234     0.200
     5.695   182.484     0.200
     7.819   246.367     0.200
    10.922   345.477     0.200
     5.696   181.327     0.200
     7.585   239.227     0.200
     7.823   244.671     0.200
     7.832   242.441     0.200
    10.954   345.646     0.200
     5.677   179.617     0.200
     7.571   239.352     0.200
     7.832   243.594     0.200
    10.942   341.852     0.200
     5.634   178.035     0.200
     5.632   176.297     0.200
     7.528   235.277     0.200
     7.831   245.484     0.200
    10.683   342.270     0.200
    10.966   346.625     0.200
     5.633   177.916     0.200
     7.532   238.275     0.200
    10.689   343.422     0.200
    10.972   347.428     0.200
     7.533   237.459     0.200
    10.691   342.658     0.200
     5.670   178.820     0.200
     7.674   242.305     0.200
     5.703   178.707     0.200
     7.600   239.680     0.200
     7.843   247.324     0.200
    10.936   346.148     0.200
     7.311   228.183     0.200
     8.402   261.876     0.200
    10.734   339.763     0.200
     5.200   162.125     0.200
     7.510   233.961     0.200
     8.819   275.957     0.200
     9.551   299.266     0.200
    10.769   340.078     0.200
     1.714    54.762     0.200
     5.243   166.012     0.200
    11.617   365.961     0.200
     1.653    49.726     0.200
     1.679    50.365     0.200
     1.717    52.905     0.200
     1.858    58.125     0.200
     5.152   164.121     0.200
     7.462   232.496     0.200
     8.809   276.864     0.200
     1.695    51.346     0.200
     5.659   180.486     0.200
     7.534   237.635     0.200
     7.782   242.305     0.200
    10.215   321.645     0.200
    10.668   340.861     0.200
    10.912   345.387     0.200
     5.654   179.383     0.200
     7.528   236.482     0.200
     7.781   242.775     0.200
    10.663   340.557     0.200
    10.914   342.832     0.200
     5.679   182.428     0.200
     7.550   237.977     0.200
     7.777   245.172     0.200
    10.898   345.754     0.200
     5.714   179.195     0.200
     7.608   237.727     0.200
     7.835   245.205     0.200
    10.748   341.469     0.200
    10.924   343.469     0.200
     7.793   245.164     0.200
     7.817   245.684     0.200
    10.798   340.168     0.200
     5.915   188.352     0.200
    10.797   338.629     0.200
     7.822   241.352     0.200
    10.801   342.016     0.200
    10.894   347.719     0.200
    10.800   340.438     0.200
     7.817   241.547     0.200
     1.703    53.742     0.200
     7.813   243.250     0.200
    10.794   342.578     0.200
     2.149    65.141     0.200
     5.703   178.887     0.200
     7.724   240.512     0.200
     8.153   252.680     0.200
    11.186   351.562     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.285    10.285     0.200
     0.343    11.938     0.200
     0.517    17.115     0.200
     0.806    25.063     0.200
     0.218     7.920     0.200
     0.331    11.619     0.200
     0.711    23.322     0.200
     0.866    27.684     0.200
     0.982    30.318     0.200
     1.591    49.965     0.200
     1.577    49.385     0.200
     0.277     9.360     0.200
     0.374    13.012     0.200
     0.454    15.253     0.200
     0.509    16.920     0.200
     0.598    19.633     0.200
     0.743    24.188     0.200
     0.670    20.980     0.200
     1.039    31.867     0.200
     1.374    40.588     0.200
     1.521    47.610     0.200
     1.992    58.449     0.200
     2.091    61.084     0.200
     0.167     6.128     0.200
     0.551    17.750     0.200
     0.635    20.764     0.200
     0.674    21.801     0.200
     0.743    23.954     0.200
     0.783    24.633     0.200
     0.775    24.650     0.200
     0.838    26.860     0.200
     1.422    41.280     0.200
     1.422    41.692     0.200
     1.542    48.482     0.200
     1.811    53.471     0.200
     0.167     6.312     0.200
     0.167     6.172     0.200
     0.551    18.148     0.200
     0.673    21.789     0.200
     0.740    24.172     0.200
     0.639    21.203     0.200
     0.783    24.680     0.200
     0.837    27.023     0.200
     0.778    24.633     0.200
     1.418    41.523     0.200
     1.418    41.672     0.200
     1.545    48.031     0.200
     1.974    58.664     0.200
     0.292    10.148     0.200
     0.356    11.719     0.200
     0.356    12.059     0.200
     0.645    20.570     0.200
     0.714    22.770     0.200
     0.837    26.270     0.200
     0.759    24.938     0.200
     1.503    44.945     0.200
     1.574    49.176     0.200
     1.929    56.000     0.200
     2.545    71.582     0.200
     6.908   199.418     0.200
     0.289    10.422     0.200
     0.362    11.793     0.200
     0.639    20.648     0.200
     0.712    22.734     0.200
     0.763    24.738     0.200
     0.833    25.961     0.200
     1.580    49.398     0.200
     0.382    12.680     0.200
     0.411    14.316     0.200
     0.658    21.738     0.200
     0.711    22.996     0.200
     0.727    23.469     0.200
     0.704    23.652     0.200
     0.772    24.727     0.200
     1.576    49.738     0.200
     1.941    57.477     0.200
     2.197    63.668     0.200
     4.302   118.879     0.200
     0.432    14.815     0.200
     0.703    23.037     0.200
     0.698    23.223     0.200
     0.677    22.159     0.200
     0.677    22.913     0.200
     0.747    24.608     0.200
     0.806    26.698     0.200
     0.806    25.522     0.200
     0.734    24.300     0.200
     1.371    39.398     0.200
     0.369    11.797     0.200
     0.613    19.965     0.200
     0.648    20.801     0.200
     0.661    21.395     0.200
     0.707    22.750     0.200
     0.707    23.137     0.200
     0.726    23.566     0.200
     0.841    26.590     0.200
     0.921    28.988     0.200
     1.586    49.438     0.200
     1.788    53.395     0.200
     0.291    10.311     0.200
     0.433    14.669     0.200
     0.666    22.245     0.200
     0.114     5.146     0.200
     0.475    15.175     0.200
     0.408    13.840     0.200
     0.419    14.390     0.200
     0.458    15.979     0.200
     0.487    16.260     0.200
     0.503    16.779     0.200
     0.621    19.819     0.200
     0.726    23.729     0.200
     1.542    47.766     0.200
     4.754   134.640     0.200
     0.111     5.000     0.200
     0.406    13.891     0.200
     0.452    14.941     0.200
     0.421    14.051     0.200
     0.472    14.977     0.200
     0.490    16.230     0.200
     0.544    17.492     0.200
     0.627    19.434     0.200
     0.636    20.500     0.200
     0.636    20.531     0.200
     1.008    30.562     0.200
     1.544    47.801     0.200
     0.219     7.950     0.200
     0.685    21.996     0.200
     0.682    22.425     0.200
     0.698    22.816     0.200
     0.744    23.164     0.200
     0.766    24.091     0.200
     0.780    24.874     0.200
     1.098    33.273     0.200
     1.522    47.803     0.200
     1.553    49.648     0.200
     1.833    54.164     0.200
     3.271    91.674     0.200
     0.167     6.516     0.200
     0.192     7.117     0.200
     0.532    17.367     0.200
     0.611    20.531     0.200
     0.755    24.055     0.200
     0.753    23.750     0.200
     0.780    25.023     0.200
     0.831    26.453     0.200
     0.890    27.891     0.200
     0.901    28.398     0.200
     5.207   144.625     0.200
     5.207   144.625     0.200
     0.272     9.406     0.200
     0.449    14.617     0.200
     0.460    15.984     0.200
     0.507    16.906     0.200
     0.563    18.781     0.200
     0.563    20.055     0.200
     0.593    19.180     0.200
     0.669    21.875     0.200
     0.745    23.359     0.200
     0.903    28.039     0.200
     0.944    29.250     0.200
     0.971    30.133     0.200
     0.987    30.516     0.200
     0.987    30.047     0.200
     1.545    48.070     0.200
     3.228    92.398     0.200
     3.374    96.375     0.200
     3.783   108.258     0.200
     0.372    12.973     0.200
     0.376    12.574     0.200
     0.480    16.762     0.200
     0.735    23.750     0.200
     0.890    29.027     0.200
     1.250    37.254     0.200
     1.589    50.805     0.200
     2.361    68.824     0.200
     3.049    91.152     0.200
     0.219     7.516     0.200
     0.583    19.156     0.200
     0.583    19.344     0.200
     0.620    19.750     0.200
     0.620    20.328     0.200
     0.659    20.797     0.200
     0.704    23.766     0.200
     0.735    23.875     0.200
     0.319    11.359     0.200
     0.330    10.801     0.200
     0.554    18.508     0.200
     0.755    23.801     0.200
     0.850    26.070     0.200
     1.354    41.078     0.200
     1.357    42.480     0.200
     1.448    44.789     0.200
     1.475    45.754     0.200
     1.510    46.891     0.200
     0.148     6.180     0.200
     0.437    14.156     0.200
     0.451    15.008     0.200
     0.446    15.023     0.200
     0.613    19.414     0.200
     0.676    22.117     0.200
     0.754    24.797     0.200
     1.250    36.602     0.200
     1.877    55.898     0.200
     0.212     8.141     0.200
     0.551    17.844     0.200
     0.551    18.039     0.200
     0.556    18.492     0.200
     0.554    18.930     0.200
     0.617    19.312     0.200
     0.737    23.805     0.200
     0.723    23.602     0.200
     1.073    32.852     0.200
     1.517    46.242     0.200
     0.196     7.031     0.200
     0.350    11.570     0.200
     0.619    20.484     0.200
     0.788    27.598     0.200
     0.753    24.664     0.200
     0.821    27.207     0.200
     0.893    28.953     0.200
     0.956    30.152     0.200
     0.902    28.512     0.200
     0.986    31.293     0.200
     1.022    32.477     0.200
     1.203    36.695     0.200
     1.588    50.293     0.200
     0.208     7.321     0.200
     0.338    11.958     0.200
     0.618    21.038     0.200
     0.686    23.051     0.200
     0.761    25.531     0.200
     0.777    27.841     0.200
     0.822    27.541     0.200
     0.895    28.960     0.200
     0.901    29.358     0.200
     0.901    29.521     0.200
     0.944    30.370     0.200
     0.973    31.799     0.200
     0.995    31.937     0.200
     1.020    32.741     0.200
     1.053    34.161     0.200
     1.165    36.961     0.200
     1.190    36.938     0.200
     1.366    42.379     0.200
     2.260    66.391     0.200
     2.273    67.661     0.200
     5.408   151.021     0.200
     5.610   165.861     0.200
     0.294     9.770     0.200
     0.543    18.113     0.200
     0.636    20.781     0.200
     0.673    22.062     0.200
     0.714    23.371     0.200
     0.721    23.258     0.200
     0.721    23.164     0.200
     0.721    23.293     0.200
     0.711    23.324     0.200
     0.763    24.273     0.200
     0.870    27.672     0.200
     1.594    49.664     0.200
     1.590    49.410     0.200
     1.590    50.383     0.200
     2.902    86.895     0.200
     0.202     7.457     0.200
     0.202     7.730     0.200
     0.249    10.426     0.200
     0.584    19.109     0.200
     0.584    19.008     0.200
     0.634    20.730     0.200
     0.633    20.746     0.200
     0.633    19.496     0.200
     0.652    20.008     0.200
     0.721    23.582     0.200
     1.097    33.129     0.200
     1.979    57.348     0.200
     0.213     7.586     0.200
     0.242    10.555     0.200
     0.592    19.336     0.200
     0.634    21.266     0.200
     0.621    20.102     0.200
     0.646    20.797     0.200
     0.733    23.891     0.200
     1.535    47.117     0.200
     0.215     7.531     0.200
     0.215     8.203     0.200
     0.247    10.758     0.200
     0.595    19.477     0.200
     0.608    20.047     0.200
     0.621    19.828     0.200
     0.629    20.945     0.200
     0.650    20.570     0.200
     0.733    24.180     0.200
     0.591    19.594     0.200
     0.729    24.156     0.200
     1.980    59.055     0.200
     1.981    58.523     0.200
     8.006   226.703     0.200
     0.233     9.992     0.200
     0.579    18.977     0.200
     0.591    19.672     0.200
     0.636    21.602     0.200
     0.628    19.953     0.200
     0.724    23.367     0.200
     1.094    33.281     0.200
     1.539    47.102     0.200
     2.336    67.531     0.200
     2.508    72.055     0.200
     0.158     6.508     0.200
     0.231    10.266     0.200
     0.215     9.609     0.200
     0.246    10.250     0.200
     0.533    17.805     0.200
     0.626    19.773     0.200
     0.668    21.180     0.200
     0.681    22.516     0.200
     0.683    22.695     0.200
     1.585    48.930     0.200
     0.212     7.969     0.200
     0.212     7.773     0.200
     0.594    19.055     0.200
     0.624    20.398     0.200
     0.628    21.414     0.200
     0.653    20.523     0.200
     0.698    21.945     0.200
     0.731    24.242     0.200
     1.299    38.523     0.200
     2.490    73.852     0.200
     2.484    73.906     0.200
     3.325    92.414     0.200
     0.233     7.477     0.200
     0.610    18.805     0.200
     0.608    20.297     0.200
     0.616    20.328     0.200
     0.616    19.883     0.200
     0.629    21.133     0.200
     0.666    21.258     0.200
     0.709    22.797     0.200
     0.748    24.711     0.200
     2.306    67.148     0.200
     2.467    70.969     0.200
     6.857   190.164     0.200
     0.168     6.734     0.200
     0.536    17.938     0.200
     0.611    19.812     0.200
     0.657    20.719     0.200
     0.657    20.180     0.200
     0.694    22.477     0.200
     2.375    70.492     0.200
     2.463    72.727     0.200
     2.554    75.742     0.200
     3.540   101.773     0.200
     3.756   104.555     0.200
     0.228     8.805     0.200
     0.228     7.617     0.200
     0.250    10.719     0.200
     0.609    20.195     0.200
     0.621    21.328     0.200
     0.655    20.562     0.200
     0.610    20.141     0.200
     0.610    19.414     0.200
     0.619    20.609     0.200
     0.746    24.453     0.200
     1.989    58.078     0.200
     0.247    10.580     0.200
     0.613    20.111     0.200
     0.613    19.184     0.200
     0.620    20.779     0.200
     0.625    20.820     0.200
     0.603    18.664     0.200
     0.651    20.480     0.200
     0.752    24.199     0.200
     0.694    22.641     0.200
     1.520    45.361     0.200
     0.194     7.777     0.200
     0.285    11.180     0.200
     0.573    19.250     0.200
     0.573    18.734     0.200
     0.586    19.723     0.200
     0.643    20.012     0.200
     0.638    20.824     0.200
     0.646    21.480     0.200
     0.714    23.297     0.200
     1.968    56.641     0.200
     0.189     7.250     0.200
     0.571    19.053     0.200
     0.571    18.822     0.200
     0.584    19.593     0.200
     0.645    19.423     0.200
     0.645    20.062     0.200
     0.650    20.733     0.200
     0.642    21.534     0.200
     0.708    23.631     0.200
     1.558    47.113     0.200
     1.973    58.863     0.200
     2.511    71.073     0.200
     0.153     6.441     0.200
     0.153     6.219     0.200
     0.409    13.302     0.200
     0.444    14.251     0.200
     0.449    14.822     0.200
     0.459    14.931     0.200
     0.529    17.046     0.200
     0.602    19.035     0.200
     0.594    19.001     0.200
     0.656    20.681     0.200
     0.672    21.280     0.200
     0.761    24.261     0.200
     0.761    23.921     0.200
     1.501    46.329     0.200
     1.790    52.551     0.200
     1.796    52.481     0.200
     1.871    54.714     0.200
     2.099    61.881     0.200
     0.469    15.688     0.200
     0.471    15.648     0.200
     0.515    17.234     0.200
     0.761    24.859     0.200
     0.847    28.133     0.200
     1.035    33.086     0.200
     1.056    33.516     0.200
     1.291    39.883     0.200
     0.178     6.828     0.200
     0.178     7.164     0.200
     0.384    12.219     0.200
     0.384    12.648     0.200
     0.366    12.352     0.200
     0.420    15.969     0.200
     0.475    15.516     0.200
     0.475    15.969     0.200
     0.635    20.062     0.200
     0.637    20.320     0.200
     0.725    23.156     0.200
     0.725    23.469     0.200
     0.766    24.852     0.200
     0.766    26.227     0.200
     0.936    28.797     0.200
     1.198    36.078     0.200
     1.929    57.164     0.200
     1.994    59.586     0.200
     2.142    63.328     0.200
     2.757    78.109     0.200
     5.267   151.336     0.200
     0.091     4.125     0.200
     0.091     4.531     0.200
     0.096     4.703     0.200
     0.612    20.078     0.200
     0.623    19.977     0.200
     0.799    24.934     0.200
     0.822    25.152     0.200
     0.851    26.117     0.200
     1.469    43.508     0.200
     1.432    44.762     0.200
     1.571    48.156     0.200
     1.821    53.074     0.200
     0.111     4.758     0.200
     0.607    19.383     0.200
     0.623    20.773     0.200
     0.630    20.273     0.200
     0.782    25.133     0.200
     0.815    25.734     0.200
     1.439    41.914     0.200
     1.634    47.703     0.200
     1.825    54.062     0.200
     0.323    10.872     0.200
     0.451    14.765     0.200
     0.663    20.226     0.200
     0.714    22.943     0.200
     0.769    25.272     0.200
     0.442    14.668     0.200
     0.703    22.742     0.200
     0.692    24.004     0.200
     0.684    25.156     0.200
     0.747    27.008     0.200
     1.003    32.250     0.200
     0.323    10.688     0.200
     0.443    14.992     0.200
     0.709    22.438     0.200
     0.708    23.102     0.200
     0.734    24.805     0.200
     0.742    24.500     0.200
     0.778    25.914     0.200
     0.868    26.883     0.200
     0.815    27.117     0.200
     1.639    48.555     0.200
     4.195   118.203     0.200
     0.265     9.369     0.200
     0.460    15.133     0.200
     0.641    20.715     0.200
     0.711    22.223     0.200
     0.739    23.725     0.200
     0.717    23.518     0.200
     0.757    23.561     0.200
     0.724    23.465     0.200
     0.947    29.182     0.200
     1.552    48.635     0.200
     1.600    50.455     0.200
     1.847    54.107     0.200
     0.096     5.261     0.200
     0.127     5.860     0.200
     0.196     7.730     0.200
     0.268     9.993     0.200
     0.268    10.121     0.200
     0.292     9.681     0.200
     0.254     9.961     0.200
     0.315    10.721     0.200
     0.317    11.591     0.200
     0.331    11.561     0.200
     0.331    11.730     0.200
     0.363    12.400     0.200
     0.378    13.061     0.200
     0.399    13.431     0.200
     0.409    13.551     0.200
     0.376    12.951     0.200
     0.400    13.971     0.200
     0.390    13.891     0.200
     0.399    14.541     0.200
     0.443    14.451     0.200
     0.460    15.631     0.200
     0.478    14.911     0.200
     0.481    14.681     0.200
     0.461    15.618     0.200
     0.499    16.360     0.200
     0.529    16.251     0.200
     0.520    17.411     0.200
     0.562    17.980     0.200
     0.611    20.711     0.200
     0.665    21.400     0.200
     0.680    21.501     0.200
     0.714    22.261     0.200
     0.716    22.230     0.200
     0.708    22.874     0.200
     0.776    24.261     0.200
     0.742    24.301     0.200
     0.804    24.780     0.200
     0.918    28.190     0.200
     1.502    45.614     0.200
     1.569    49.046     0.200
     1.954    55.593     0.200
     0.291    10.436     0.200
     0.481    15.779     0.200
     0.481    16.771     0.200
     0.549    18.551     0.200
     0.579    19.121     0.200
     0.676    21.467     0.200
     0.682    22.660     0.200
     0.705    23.861     0.200
     0.741    24.326     0.200
     0.821    27.516     0.200
     0.821    26.812     0.200
     1.040    32.201     0.200
     1.589    50.539     0.200
     0.074     2.980     0.200
     0.279    10.574     0.200
     0.287    10.374     0.200
     0.327    10.984     0.200
     0.397    13.454     0.200
     0.404    13.224     0.200
     0.451    15.124     0.200
     0.454    16.114     0.200
     0.477    15.624     0.200
     0.479    15.614     0.200
     0.555    18.487     0.200
     0.555    18.754     0.200
     0.596    19.594     0.200
     0.615    20.334     0.200
     0.618    20.704     0.200
     0.646    21.024     0.200
     0.652    22.254     0.200
     0.688    22.434     0.200
     0.693    22.664     0.200
     0.736    23.884     0.200
     0.770    24.827     0.200
     0.770    25.074     0.200
     0.761    25.124     0.200
     0.782    25.674     0.200
     0.808    26.405     0.200
     0.840    27.144     0.200
     0.862    27.664     0.200
     0.894    29.134     0.200
     0.899    28.704     0.200
     0.902    29.154     0.200
     0.929    30.259     0.200
     0.940    30.094     0.200
     1.004    31.694     0.200
     1.004    32.164     0.200
     0.267    10.410     0.200
     0.277    10.230     0.200
     0.312    11.199     0.200
     0.331    11.602     0.200
     0.391    13.242     0.200
     0.395    13.332     0.200
     0.453    15.949     0.200
     0.459    15.520     0.200
     0.468    15.672     0.200
     0.469    15.801     0.200
     0.551    18.910     0.200
     0.589    19.461     0.200
     0.606    20.223     0.200
     0.610    20.531     0.200
     0.636    20.973     0.200
     0.636    21.129     0.200
     0.640    22.512     0.200
     0.679    22.500     0.200
     0.685    22.473     0.200
     0.725    24.012     0.200
     0.749    25.402     0.200
     0.775    25.191     0.200
     0.775    25.348     0.200
     0.776    25.340     0.200
     0.787    26.570     0.200
     0.811    27.039     0.200
     0.821    28.602     0.200
     0.835    26.973     0.200
     0.856    27.500     0.200
     0.883    29.039     0.200
     0.893    28.621     0.200
     0.893    29.082     0.200
     0.938    30.379     0.200
     0.992    31.391     0.200
     1.019    32.531     0.200
     0.254     8.849     0.200
     0.516    17.488     0.200
     0.641    20.797     0.200
     0.701    22.858     0.200
     0.703    22.729     0.200
     0.703    22.148     0.200
     0.773    25.309     0.200
     0.311    11.250     0.200
     0.265     8.906     0.200
     0.629    20.500     0.200
     0.615    19.461     0.200
     0.792    25.680     0.200
     0.836    26.461     0.200
     1.172    35.133     0.200
     0.296    11.004     0.200
     0.351    11.762     0.200
     0.356    12.352     0.200
     0.442    14.723     0.200
     0.509    16.395     0.200
     0.687    22.195     0.200
     1.468    45.652     0.200
     0.137     6.365     0.200
     0.137     6.234     0.200
     0.178     6.955     0.200
     0.174     7.615     0.200
     0.166     6.834     0.200
     0.167     6.920     0.200
     0.188     7.615     0.200
     0.195     8.295     0.200
     0.296    10.445     0.200
     0.269     9.725     0.200
     0.300    10.844     0.200
     0.300    10.734     0.200
     0.292    10.195     0.200
     0.357    12.424     0.200
     0.421    14.785     0.200
     0.437    15.254     0.200
     0.464    15.436     0.200
     0.496    16.795     0.200
     0.511    16.764     0.200
     0.502    17.125     0.200
     0.522    17.074     0.200
     0.551    18.014     0.200
     0.551    18.250     0.200
     0.533    17.605     0.200
     0.535    17.324     0.200
     0.607    19.186     0.200
     0.618    21.895     0.200
     0.644    20.484     0.200
     0.644    20.314     0.200
     0.625    20.674     0.200
     0.642    20.725     0.200
     0.642    20.965     0.200
     0.650    21.445     0.200
     0.670    21.844     0.200
     0.670    22.494     0.200
     0.727    23.436     0.200
     0.716    23.525     0.200
     0.715    22.645     0.200
     0.738    23.625     0.200
     0.785    24.885     0.200
     0.781    24.531     0.200
     0.781    24.525     0.200
     0.819    25.404     0.200
     0.841    26.475     0.200
     0.883    27.574     0.200
     0.927    28.475     0.200
     1.498    47.986     0.200
     1.563    48.908     0.200
     0.061     5.367     0.200
     0.175     7.977     0.200
     0.207     9.547     0.200
     0.184     7.297     0.200
     0.203     7.938     0.200
     0.250    10.258     0.200
     0.364    13.617     0.200
     0.435    14.344     0.200
     0.550    17.633     0.200
     0.640    20.188     0.200
     0.685    22.562     0.200
     0.710    23.102     0.200
     0.710    23.242     0.200
     0.151     7.801     0.200
     0.171     7.961     0.200
     0.212     8.184     0.200
     0.230     9.430     0.200
     0.234     9.359     0.200
     0.295    10.621     0.200
     0.317    10.871     0.200
     0.357    13.078     0.200
     0.364    13.578     0.200
     0.423    13.891     0.200
     0.551    18.398     0.200
     0.549    17.801     0.200
     0.549    17.949     0.200
     0.554    18.121     0.200
     0.568    20.820     0.200
     0.618    19.477     0.200
     0.618    20.461     0.200
     0.736    23.738     0.200
     0.728    23.617     0.200
     0.113     5.652     0.200
     0.164     7.941     0.200
     0.178     7.660     0.200
     0.181     7.402     0.200
     0.185     8.363     0.200
     0.201     8.293     0.200
     0.310    10.852     0.200
     0.312    12.762     0.200
     0.335    11.730     0.200
     0.335    11.680     0.200
     0.369    13.723     0.200
     0.419    14.441     0.200
     0.419    14.254     0.200
     0.426    16.062     0.200
     0.439    15.461     0.200
     0.469    17.680     0.200
     0.552    18.730     0.200
     0.552    18.465     0.200
     0.553    19.781     0.200
     0.625    21.273     0.200
     0.667    23.133     0.200
     0.667    21.961     0.200
     0.667    21.883     0.200
     0.696    23.680     0.200
     0.706    24.590     0.200
     0.719    22.230     0.200
     0.723    24.293     0.200
     0.744    24.461     0.200
     0.744    24.156     0.200
     0.757    24.652     0.200
     0.798    25.172     0.200
     0.798    25.695     0.200
     2.334    67.926     0.200
     0.299    11.738     0.200
     0.361    12.219     0.200
     0.367    12.148     0.200
     0.367    12.043     0.200
     0.432    16.000     0.200
     0.385    13.910     0.200
     0.406    14.691     0.200
     0.458    16.668     0.200
     0.406    15.219     0.200
     0.417    14.500     0.200
     0.417    14.047     0.200
     0.451    16.090     0.200
     0.511    18.500     0.200
     0.549    19.379     0.200
     0.558    20.961     0.200
     0.573    20.191     0.200
     0.658    21.738     0.200
     0.678    22.000     0.200
     0.679    23.531     0.200
     0.635    20.781     0.200
     0.674    22.531     0.200
     0.677    22.461     0.200
     0.719    23.578     0.200
     0.712    23.250     0.200
     0.712    23.078     0.200
     0.729    23.180     0.200
     0.762    25.410     0.200
     0.724    24.410     0.200
     0.724    24.602     0.200
     0.759    25.109     0.200
     0.749    24.488     0.200
     0.749    24.961     0.200
     0.773    25.148     0.200
     0.803    24.539     0.200
     0.803    25.473     0.200
     0.773    25.949     0.200
     0.792    26.859     0.200
     0.801    26.641     0.200
     1.596    51.145     0.200
     1.656    48.734     0.200
     0.292    11.782     0.200
     0.360    11.852     0.200
     0.392    14.102     0.200
     0.413    14.962     0.200
     0.423    14.164     0.200
     0.412    15.602     0.200
     0.450    16.592     0.200
     0.458    15.821     0.200
     0.449    15.702     0.200
     0.505    18.492     0.200
     0.541    18.742     0.200
     0.551    20.382     0.200
     0.651    21.271     0.200
     0.639    20.861     0.200
     0.674    23.282     0.200
     0.671    21.852     0.200
     0.673    23.552     0.200
     0.677    22.602     0.200
     0.680    22.659     0.200
     0.707    23.212     0.200
     0.707    22.931     0.200
     0.722    23.382     0.200
     0.722    23.813     0.200
     0.731    24.592     0.200
     0.731    24.459     0.200
     0.755    25.172     0.200
     0.757    25.632     0.200
     0.751    25.882     0.200
     0.751    25.012     0.200
     0.772    25.481     0.200
     0.801    26.029     0.200
     0.776    26.722     0.200
     1.660    49.250     0.200
     0.214     9.159     0.200
     0.227     9.269     0.200
     0.373    11.515     0.200
     0.386    13.849     0.200
     0.400    14.329     0.200
     0.406    14.079     0.200
     0.406    13.803     0.200
     0.411    15.229     0.200
     0.465    16.738     0.200
     0.474    15.909     0.200
     0.552    19.488     0.200
     0.555    20.679     0.200
     0.588    19.329     0.200
     0.645    21.049     0.200
     0.662    22.019     0.200
     0.685    22.549     0.200
     0.681    22.629     0.200
     0.685    22.688     0.200
     0.688    22.674     0.200
     0.688    22.886     0.200
     0.708    22.209     0.200
     0.725    24.238     0.200
     0.725    24.094     0.200
     0.725    24.192     0.200
     0.738    23.559     0.200
     0.738    24.100     0.200
     0.762    25.698     0.200
     0.771    25.759     0.200
     0.773    26.219     0.200
     0.787    25.789     0.200
     0.791    24.869     0.200
     0.791    25.871     0.200
     0.786    26.369     0.200
     0.805    27.229     0.200
     0.814    26.938     0.200
     1.597    51.609     0.200
     0.198     8.868     0.200
     0.208     8.008     0.200
     0.294    11.618     0.200
     0.391    13.568     0.200
     0.410    14.798     0.200
     0.425    14.258     0.200
     0.425    14.146     0.200
     0.426    16.568     0.200
     0.450    16.388     0.200
     0.446    16.108     0.200
     0.457    15.558     0.200
     0.507    18.368     0.200
     0.542    19.198     0.200
     0.553    20.598     0.200
     0.570    18.858     0.200
     0.636    20.418     0.200
     0.651    21.008     0.200
     0.677    23.338     0.200
     0.671    21.608     0.200
     0.674    22.308     0.200
     0.677    22.483     0.200
     0.677    22.048     0.200
     0.677    22.229     0.200
     0.705    22.988     0.200
     0.721    23.198     0.200
     0.730    24.118     0.200
     0.748    24.558     0.200
     0.748    24.678     0.200
     0.754    24.798     0.200
     0.753    24.888     0.200
     0.769    25.238     0.200
     0.773    26.098     0.200
     0.791    26.588     0.200
     0.804    24.988     0.200
     0.804    25.094     0.200
     0.800    26.458     0.200
     0.199     8.949     0.200
     0.209     8.119     0.200
     0.295    12.099     0.200
     0.390    13.529     0.200
     0.412    14.039     0.200
     0.409    14.769     0.200
     0.424    13.999     0.200
     0.424    14.119     0.200
     0.452    16.499     0.200
     0.446    16.299     0.200
     0.459    15.679     0.200
     0.543    18.969     0.200
     0.554    20.809     0.200
     0.570    19.289     0.200
     0.636    20.559     0.200
     0.672    21.599     0.200
     0.677    22.829     0.200
     0.674    22.648     0.200
     0.677    22.839     0.200
     0.677    22.128     0.200
     0.677    22.299     0.200
     0.677    22.491     0.200
     0.706    23.029     0.200
     0.706    23.292     0.200
     0.722    23.349     0.200
     0.729    24.069     0.200
     0.729    23.779     0.200
     0.748    24.949     0.200
     0.748    25.208     0.200
     0.755    25.089     0.200
     0.754    25.009     0.200
     0.773    26.119     0.200
     0.791    26.479     0.200
     0.804    24.739     0.200
     0.804    25.466     0.200
     0.800    26.609     0.200
     0.151     7.172     0.200
     0.303    10.355     0.200
     0.303     9.727     0.200
     0.307    10.945     0.200
     0.350    13.023     0.200
     0.347    13.395     0.200
     0.358    13.594     0.200
     0.401    15.555     0.200
     0.441    15.473     0.200
     0.446    16.324     0.200
     0.477    16.215     0.200
     0.507    17.875     0.200
     0.519    17.594     0.200
     0.551    18.113     0.200
     0.542    18.355     0.200
     0.556    17.984     0.200
     0.560    19.582     0.200
     0.569    20.434     0.200
     0.574    20.043     0.200
     0.610    19.895     0.200
     0.652    20.445     0.200
     0.676    22.883     0.200
     0.695    23.082     0.200
     0.695    22.457     0.200
     0.701    23.434     0.200
     0.762    25.125     0.200
     0.762    24.824     0.200
     0.805    25.562     0.200
     0.058     4.594     0.200
     0.158     7.562     0.200
     0.197     8.547     0.200
     0.201     9.555     0.200
     0.208     7.734     0.200
     0.208     8.055     0.200
     0.260    11.047     0.200
     0.364    13.977     0.200
     0.363    12.188     0.200
     0.360    12.648     0.200
     0.384    13.992     0.200
     0.456    15.023     0.200
     0.465    16.516     0.200
     0.487    16.125     0.200
     0.572    19.055     0.200
     0.581    19.477     0.200
     0.617    19.227     0.200
     0.617    19.680     0.200
     0.617    19.523     0.200
     0.621    21.508     0.200
     0.675    22.922     0.200
     0.675    22.344     0.200
     0.734    23.586     0.200
     0.734    23.836     0.200
     0.740    24.195     0.200
     0.761    25.352     0.200
     0.776    25.422     0.200
     0.056     4.961     0.200
     0.161     7.672     0.200
     0.196     8.656     0.200
     0.206     7.703     0.200
     0.206     7.875     0.200
     0.257    11.266     0.200
     0.359    12.766     0.200
     0.366    13.820     0.200
     0.386    14.836     0.200
     0.387    14.406     0.200
     0.456    14.953     0.200
     0.463    16.781     0.200
     0.489    16.227     0.200
     0.542    18.883     0.200
     0.572    18.477     0.200
     0.572    18.750     0.200
     0.581    18.922     0.200
     0.606    20.789     0.200
     0.606    21.070     0.200
     0.618    19.672     0.200
     0.618    19.773     0.200
     0.619    21.391     0.200
     0.673    22.711     0.200
     0.732    23.891     0.200
     0.732    24.047     0.200
     0.732    24.188     0.200
     0.724    24.352     0.200
     0.738    24.500     0.200
     0.759    25.930     0.200
     0.773    25.359     0.200
     0.979    30.102     0.200
     0.179     7.246     0.200
     0.293    11.309     0.200
     0.309    10.777     0.200
     0.345    11.695     0.200
     0.364    12.809     0.200
     0.365    12.418     0.200
     0.365    12.285     0.200
     0.412    15.738     0.200
     0.412    14.465     0.200
     0.471    15.457     0.200
     0.471    15.355     0.200
     0.477    17.168     0.200
     0.456    15.457     0.200
     0.488    16.027     0.200
     0.503    16.727     0.200
     0.487    15.215     0.200
     0.498    16.266     0.200
     0.534    19.918     0.200
     0.501    16.406     0.200
     0.553    19.527     0.200
     0.526    17.426     0.200
     0.526    17.535     0.200
     0.576    19.105     0.200
     0.596    19.375     0.200
     0.562    19.176     0.200
     0.605    19.207     0.200
     0.572    18.828     0.200
     0.583    19.695     0.200
     0.641    22.066     0.200
     0.644    21.297     0.200
     0.644    21.586     0.200
     0.658    21.438     0.200
     0.672    21.809     0.200
     0.689    22.875     0.200
     0.756    23.688     0.200
     0.769    23.816     0.200
     0.755    24.867     0.200
     0.756    24.688     0.200
     0.795    26.605     0.200
     0.822    25.387     0.200
     0.818    26.066     0.200
     0.882    27.625     0.200
     0.853    27.098     0.200
     0.906    28.195     0.200
     0.955    29.648     0.200
     1.043    31.738     0.200
     1.043    31.867     0.200
     1.569    49.543     0.200
     0.144     5.461     0.200
     0.244     7.500     0.200
     0.244     9.039     0.200
     0.245     8.891     0.200
     0.276    11.320     0.200
     0.316    12.570     0.200
     0.358    13.727     0.200
     0.374    12.562     0.200
     0.492    18.539     0.200
     0.515    17.258     0.200
     0.523    17.422     0.200
     0.523    17.312     0.200
     0.545    19.711     0.200
     0.547    19.297     0.200
     0.544    18.852     0.200
     0.557    18.617     0.200
     0.562    20.578     0.200
     0.560    19.680     0.200
     0.632    20.852     0.200
     0.636    21.008     0.200
     0.657    22.539     0.200
     0.689    22.711     0.200
     0.713    23.922     0.200
     0.715    22.898     0.200
     0.765    24.938     0.200
     0.784    25.562     0.200
     0.796    26.578     0.200
     0.799    25.938     0.200
     0.849    26.617     0.200
     0.880    27.633     0.200
     0.121     6.037     0.200
     0.125     5.057     0.200
     0.142     6.527     0.200
     0.197     7.547     0.200
     0.197     7.357     0.200
     0.269     9.617     0.200
     0.269     9.297     0.200
     0.269    10.427     0.200
     0.269    10.547     0.200
     0.351    12.167     0.200
     0.367    12.587     0.200
     0.372    13.367     0.200
     0.403    13.527     0.200
     0.403    13.807     0.200
     0.414    13.967     0.200
     0.408    14.257     0.200
     0.427    14.957     0.200
     0.453    14.817     0.200
     0.454    15.037     0.200
     0.459    15.497     0.200
     0.501    16.037     0.200
     0.501    15.697     0.200
     0.501    16.527     0.200
     0.510    16.557     0.200
     0.498    15.737     0.200
     0.557    19.387     0.200
     0.569    18.317     0.200
     0.569    18.607     0.200
     0.590    19.477     0.200
     0.596    18.777     0.200
     0.596    18.988     0.200
     0.586    18.887     0.200
     0.595    18.807     0.200
     0.585    18.925     0.200
     0.585    18.997     0.200
     0.600    19.157     0.200
     0.613    19.827     0.200
     0.613    20.127     0.200
     0.624    20.107     0.200
     0.650    22.497     0.200
     0.650    22.327     0.200
     0.647    21.407     0.200
     0.643    20.537     0.200
     0.663    20.867     0.200
     0.663    21.207     0.200
     0.663    21.397     0.200
     0.663    21.457     0.200
     0.659    21.217     0.200
     0.694    21.607     0.200
     0.694    21.867     0.200
     0.705    23.597     0.200
     0.701    22.287     0.200
     0.739    23.387     0.200
     0.747    24.897     0.200
     0.741    23.837     0.200
     0.741    24.007     0.200
     1.459    38.957     0.200
     1.498    46.597     0.200
     2.550    71.693     0.200
     0.074     5.133     0.200
     0.100     6.297     0.200
     0.125     5.695     0.200
     0.126     5.680     0.200
     0.121     6.695     0.200
     0.128     6.305     0.200
     0.240     8.227     0.200
     0.199     8.211     0.200
     0.219     8.555     0.200
     0.315    11.047     0.200
     0.372    12.977     0.200
     0.419    13.875     0.200
     0.391    13.633     0.200
     0.443    15.156     0.200
     0.453    15.414     0.200
     0.455    15.109     0.200
     0.461    15.320     0.200
     0.566    18.594     0.200
     0.606    19.289     0.200
     0.583    19.156     0.200
     0.579    18.906     0.200
     0.577    19.672     0.200
     0.663    20.922     0.200
     0.663    20.969     0.200
     0.669    21.961     0.200
     0.761    24.211     0.200
     0.782    24.305     0.200
     0.782    24.070     0.200
     0.812    24.961     0.200
     0.812    25.367     0.200
     0.812    25.156     0.200
     0.823    25.391     0.200
     0.838    25.750     0.200
     0.881    27.273     0.200
     1.501    48.688     0.200
     1.592    49.602     0.200
     1.780    51.953     0.200
     0.072     4.615     0.200
     0.159     6.495     0.200
     0.211     8.665     0.200
     0.275     9.385     0.200
     0.283    10.215     0.200
     0.283    10.100     0.200
     0.327    11.015     0.200
     0.327    10.865     0.200
     0.384    13.235     0.200
     0.383    12.875     0.200
     0.375    12.705     0.200
     0.448    15.284     0.200
     0.434    15.044     0.200
     0.438    14.635     0.200
     0.483    16.054     0.200
     0.493    16.185     0.200
     0.513    17.084     0.200
     0.610    19.594     0.200
     0.549    17.955     0.200
     0.603    19.274     0.200
     0.601    19.975     0.200
     0.654    21.284     0.200
     0.630    20.344     0.200
     0.698    23.544     0.200
     0.670    21.314     0.200
     0.663    22.354     0.200
     0.669    22.554     0.200
     0.727    23.975     0.200
     0.744    25.155     0.200
     0.721    23.455     0.200
     0.696    23.084     0.200
     0.772    24.715     0.200
     0.772    25.328     0.200
     0.767    24.875     0.200
     0.769    25.334     0.200
     0.792    25.205     0.200
     0.867    27.215     0.200
     0.835    26.515     0.200
     0.876    27.794     0.200
     0.957    29.794     0.200
     1.067    32.529     0.200
     1.548    49.333     0.200
     0.156     6.429     0.200
     0.256     9.309     0.200
     0.259     9.423     0.200
     0.266     9.409     0.200
     0.284    10.989     0.200
     0.274    10.069     0.200
     0.308    11.429     0.200
     0.324    11.479     0.200
     0.329    12.179     0.200
     0.348    12.029     0.200
     0.370    13.148     0.200
     0.397    13.369     0.200
     0.406    13.769     0.200
     0.419    13.938     0.200
     0.458    15.569     0.200
     0.477    17.119     0.200
     0.483    17.779     0.200
     0.473    16.019     0.200
     0.507    16.668     0.200
     0.573    19.249     0.200
     0.557    18.958     0.200
     0.610    19.838     0.200
     0.610    20.041     0.200
     0.592    20.119     0.200
     0.637    20.708     0.200
     0.599    19.429     0.200
     0.659    23.179     0.200
     0.648    20.659     0.200
     0.659    21.338     0.200
     0.665    20.889     0.200
     0.658    21.199     0.200
     0.677    21.309     0.200
     0.669    21.449     0.200
     0.696    23.668     0.200
     0.682    22.299     0.200
     0.774    24.219     0.200
     0.814    25.398     0.200
     0.841    26.092     0.200
     0.841    26.019     0.200
     0.847    26.279     0.200
     1.436    43.261     0.200
     1.489    46.662     0.200
     1.591    50.300     0.200
     0.157     5.207     0.200
     0.225     9.152     0.200
     0.347    13.592     0.200
     0.411    13.462     0.200
     0.458    17.112     0.200
     0.436    14.482     0.200
     0.436    14.381     0.200
     0.478    18.462     0.200
     0.447    15.267     0.200
     0.460    15.562     0.200
     0.473    15.922     0.200
     0.590    20.722     0.200
     0.596    21.142     0.200
     0.691    22.862     0.200
     0.705    24.182     0.200
     0.715    22.922     0.200
     0.715    23.082     0.200
     0.697    22.362     0.200
     0.708    23.002     0.200
     0.731    23.552     0.200
     0.843    26.762     0.200
     0.853    27.512     0.200
     0.871    28.212     0.200
     0.925    29.012     0.200
     0.912    28.652     0.200
     0.956    30.012     0.200
     2.112    61.546     0.200
     0.154     6.406     0.200
     0.211     8.523     0.200
     0.282     9.992     0.200
     0.282    10.141     0.200
     0.332    11.211     0.200
     0.332    11.047     0.200
     0.370    12.617     0.200
     0.387    12.773     0.200
     0.387    13.492     0.200
     0.439    15.156     0.200
     0.443    14.984     0.200
     0.450    15.242     0.200
     0.487    15.781     0.200
     0.497    16.227     0.200
     0.518    17.031     0.200
     0.545    18.695     0.200
     0.552    18.211     0.200
     0.611    19.797     0.200
     0.598    20.070     0.200
     0.605    19.578     0.200
     0.633    20.453     0.200
     0.659    21.211     0.200
     0.663    22.664     0.200
     0.668    21.852     0.200
     0.673    21.656     0.200
     0.696    22.695     0.200
     0.702    23.492     0.200
     0.725    23.531     0.200
     0.732    24.258     0.200
     0.747    25.594     0.200
     0.768    25.312     0.200
     0.772    25.047     0.200
     0.774    25.977     0.200
     0.774    25.156     0.200
     0.794    25.156     0.200
     0.794    25.414     0.200
     0.835    26.586     0.200
     0.876    27.805     0.200
     1.071    32.938     0.200
     1.538    47.242     0.200
     1.543    48.898     0.200
     0.055     3.297     0.200
     0.105     5.531     0.200
     0.149     7.812     0.200
     0.225     6.945     0.200
     0.286    11.500     0.200
     0.319    12.500     0.200
     0.323    12.422     0.200
     0.364    12.953     0.200
     0.376    14.133     0.200
     0.483    16.000     0.200
     0.506    18.516     0.200
     0.514    18.078     0.200
     0.534    17.680     0.200
     0.549    17.961     0.200
     0.549    17.836     0.200
     0.583    18.641     0.200
     0.578    19.633     0.200
     0.579    19.430     0.200
     0.617    20.430     0.200
     0.639    21.586     0.200
     0.662    21.500     0.200
     0.678    22.797     0.200
     0.691    21.562     0.200
     0.694    22.930     0.200
     0.765    24.578     0.200
     0.199     6.541     0.200
     0.224     8.351     0.200
     0.227     8.031     0.200
     0.231     8.461     0.200
     0.276     9.531     0.200
     0.313    10.961     0.200
     0.330    11.649     0.200
     0.402    13.121     0.200
     0.417    12.941     0.200
     0.437    14.761     0.200
     0.460    16.271     0.200
     0.465    16.281     0.200
     0.481    16.311     0.200
     0.501    16.691     0.200
     0.508    17.001     0.200
     0.527    18.051     0.200
     0.558    19.071     0.200
     0.580    19.171     0.200
     0.585    18.871     0.200
     0.608    20.811     0.200
     0.626    20.941     0.200
     0.648    21.821     0.200
     0.673    21.711     0.200
     0.677    22.391     0.200
     0.670    22.591     0.200
     0.689    22.761     0.200
     0.700    22.351     0.200
     0.726    23.401     0.200
     0.733    24.241     0.200
     0.733    24.531     0.200
     0.723    24.361     0.200
     0.730    24.151     0.200
     0.735    24.551     0.200
     0.801    25.661     0.200
     0.791    26.081     0.200
     0.805    26.391     0.200
     0.808    26.551     0.200
     0.827    26.401     0.200
     0.865    27.651     0.200
     0.866    27.871     0.200
     0.872    27.671     0.200
     1.122    35.151     0.200
     2.571    75.167     0.200
     3.005    85.525     0.200
     3.531    99.594     0.200
     0.136     5.891     0.200
     0.154     5.801     0.200
     0.176     6.352     0.200
     0.176     6.559     0.200
     0.280    10.719     0.200
     0.280    10.520     0.200
     0.257    10.090     0.200
     0.278    10.898     0.200
     0.340    13.172     0.200
     0.340    12.969     0.200
     0.387    13.301     0.200
     0.387    13.531     0.200
     0.385    12.922     0.200
     0.385    12.809     0.200
     0.378    12.691     0.200
     0.378    12.602     0.200
     0.342    13.398     0.200
     0.357    14.191     0.200
     0.380    14.879     0.200
     0.425    15.340     0.200
     0.435    14.512     0.200
     0.405    14.398     0.200
     0.515    17.070     0.200
     0.505    19.238     0.200
     0.546    19.852     0.200
     0.580    19.301     0.200
     0.593    20.160     0.200
     0.601    21.488     0.200
     0.669    21.230     0.200
     0.638    22.488     0.200
     0.631    21.121     0.200
     0.690    22.031     0.200
     0.661    21.621     0.200
     0.697    22.738     0.200
     0.697    22.430     0.200
     0.732    23.090     0.200
     0.732    22.988     0.200
     0.705    22.559     0.200
     0.704    22.391     0.200
     0.708    22.559     0.200
     0.708    22.742     0.200
     0.736    23.789     0.200
     0.743    25.211     0.200
     0.781    24.871     0.200
     0.745    24.301     0.200
     0.764    25.910     0.200
     0.745    24.512     0.200
     0.801    25.488     0.200
     0.774    25.172     0.200
     0.852    26.461     0.200
     0.894    27.922     0.200
     0.112     6.467     0.200
     0.148     7.687     0.200
     0.180     8.337     0.200
     0.224     9.617     0.200
     0.227    10.597     0.200
     0.230     9.887     0.200
     0.257    10.837     0.200
     0.275    10.307     0.200
     0.274    11.317     0.200
     0.274    11.198     0.200
     0.301    10.567     0.200
     0.333    13.527     0.200
     0.338    12.646     0.200
     0.376    12.847     0.200
     0.386    12.707     0.200
     0.420    13.907     0.200
     0.465    15.167     0.200
     0.479    17.057     0.200
     0.497    18.207     0.200
     0.513    18.247     0.200
     0.513    17.718     0.200
     0.544    19.356     0.200
     0.554    17.987     0.200
     0.604    18.937     0.200
     0.661    23.327     0.200
     0.681    23.347     0.200
     0.703    24.687     0.200
     0.703    24.174     0.200
     0.757    24.827     0.200
     0.757    24.646     0.200
     0.757    24.767     0.200
     1.519    45.034     0.200
     2.115    60.890     0.200
     0.348    12.250     0.200
     0.393    13.469     0.200
     0.445    14.828     0.200
     0.442    15.590     0.200
     0.510    16.438     0.200
     0.511    16.559     0.200
     0.512    16.309     0.200
     0.600    19.828     0.200
     0.612    19.688     0.200
     0.643    21.039     0.200
     0.677    21.660     0.200
     0.682    23.688     0.200
     0.713    23.801     0.200
     0.714    22.898     0.200
     0.718    23.320     0.200
     0.785    25.129     0.200
     0.788    25.148     0.200
     0.817    27.020     0.200
     0.843    26.660     0.200
     0.869    27.641     0.200
     0.908    28.711     0.200
     0.143     4.957     0.200
     0.247    10.418     0.200
     0.306    10.438     0.200
     0.317    11.066     0.200
     0.329    12.348     0.200
     0.370    12.906     0.200
     0.374    14.457     0.200
     0.408    13.867     0.200
     0.412    13.930     0.200
     0.414    14.816     0.200
     0.436    14.430     0.200
     0.504    18.367     0.200
     0.523    17.406     0.200
     0.557    18.578     0.200
     0.588    20.898     0.200
     0.598    20.156     0.200
     0.607    20.816     0.200
     0.601    20.020     0.200
     0.655    21.738     0.200
     0.681    22.609     0.200
     0.681    22.277     0.200
     0.702    23.078     0.200
     0.716    23.148     0.200
     0.722    23.488     0.200
     0.720    24.270     0.200
     0.723    24.027     0.200
     0.726    23.887     0.200
     0.740    25.867     0.200
     0.733    24.477     0.200
     0.757    24.805     0.200
     0.765    25.891     0.200
     0.790    26.617     0.200
     0.788    25.336     0.200
     0.794    26.781     0.200
     0.806    26.320     0.200
     0.876    27.359     0.200
     0.137     4.859     0.200
     0.315    11.238     0.200
     0.329    12.160     0.200
     0.365    12.668     0.200
     0.375    14.359     0.200
     0.421    13.500     0.200
     0.406    14.000     0.200
     0.421    14.789     0.200
     0.432    14.008     0.200
     0.506    18.379     0.200
     0.519    18.508     0.200
     0.529    17.590     0.200
     0.588    21.000     0.200
     0.610    21.309     0.200
     0.601    19.828     0.200
     0.653    21.680     0.200
     0.685    23.109     0.200
     0.685    22.309     0.200
     0.719    22.711     0.200
     0.706    23.168     0.200
     0.726    23.230     0.200
     0.729    23.539     0.200
     0.724    24.070     0.200
     0.732    23.848     0.200
     0.742    25.328     0.200
     0.738    24.160     0.200
     0.762    24.590     0.200
     0.775    26.270     0.200
     0.766    25.711     0.200
     0.792    26.449     0.200
     0.799    26.469     0.200
     0.162     6.128     0.200
     0.134     5.408     0.200
     0.162     5.568     0.200
     0.209     7.448     0.200
     0.165     6.608     0.200
     0.177     7.078     0.200
     0.195     7.238     0.200
     0.314    10.127     0.200
     0.406    13.968     0.200
     0.366    12.778     0.200
     0.463    15.178     0.200
     0.418    14.158     0.200
     0.418    14.138     0.200
     0.531    17.488     0.200
     0.460    15.688     0.200
     0.501    17.138     0.200
     0.583    18.988     0.200
     0.522    17.738     0.200
     0.572    18.938     0.200
     0.574    19.338     0.200
     0.683    21.788     0.200
     0.614    19.998     0.200
     0.632    21.498     0.200
     0.648    22.198     0.200
     0.708    23.088     0.200
     0.677    22.138     0.200
     0.689    22.378     0.200
     0.767    24.948     0.200
     0.776    24.958     0.200
     0.726    23.658     0.200
     0.743    24.278     0.200
     0.808    25.858     0.200
     0.830    26.678     0.200
     0.770    24.908     0.200
     0.820    25.498     0.200
     0.903    28.348     0.200
     0.225     8.279     0.200
     0.324    11.759     0.200
     0.365    13.329     0.200
     0.397    13.579     0.200
     0.413    14.319     0.200
     0.446    14.979     0.200
     0.449    15.359     0.200
     0.459    15.639     0.200
     0.458    15.139     0.200
     0.465    15.849     0.200
     0.486    17.039     0.200
     0.565    18.609     0.200
     0.583    19.369     0.200
     0.583    19.819     0.200
     0.588    19.119     0.200
     0.608    19.939     0.200
     0.600    19.869     0.200
     0.665    23.159     0.200
     0.675    22.009     0.200
     0.688    22.169     0.200
     0.685    24.199     0.200
     0.697    23.309     0.200
     0.760    24.819     0.200
     0.734    23.719     0.200
     0.740    24.459     0.200
     0.779    24.809     0.200
     0.781    25.159     0.200
     0.787    25.629     0.200
     0.799    26.659     0.200
     0.809    25.799     0.200
     0.806    26.209     0.200
     0.818    25.999     0.200
     0.814    25.569     0.200
     0.834    26.319     0.200
     0.834    26.569     0.200
     0.843    27.289     0.200
     0.863    27.869     0.200
     0.879    27.649     0.200
     0.947    30.049     0.200
     0.212     7.787     0.200
     0.284    10.148     0.200
     0.294    11.688     0.200
     0.310    12.158     0.200
     0.279     9.277     0.200
     0.348    13.428     0.200
     0.366    13.908     0.200
     0.414    16.639     0.200
     0.438    15.457     0.200
     0.521    18.178     0.200
     0.488    16.588     0.200
     0.532    19.838     0.200
     0.545    18.107     0.200
     0.526    18.338     0.200
     0.517    17.799     0.200
     0.538    18.979     0.200
     0.554    20.178     0.200
     0.552    19.508     0.200
     0.593    19.328     0.200
     0.579    20.928     0.200
     0.592    19.469     0.200
     0.662    22.059     0.200
     0.671    22.018     0.200
     0.696    23.238     0.200
     0.690    22.309     0.200
     0.706    23.768     0.200
     0.773    24.969     0.200
     0.802    26.428     0.200
     0.817    26.178     0.200
     0.810    25.637     0.200
     0.818    26.148     0.200
     0.261     9.445     0.200
     0.256     9.656     0.200
     0.357    13.211     0.200
     0.382    12.281     0.200
     0.365    14.023     0.200
     0.384    12.828     0.200
     0.378    14.766     0.200
     0.402    15.344     0.200
     0.424    15.172     0.200
     0.415    13.336     0.200
     0.415    14.445     0.200
     0.447    14.766     0.200
     0.492    16.367     0.200
     0.492    15.836     0.200
     0.526    19.578     0.200
     0.558    18.367     0.200
     0.565    20.281     0.200
     0.620    21.773     0.200
     0.651    20.125     0.200
     0.629    20.641     0.200
     0.659    22.891     0.200
     0.675    20.977     0.200
     0.662    21.305     0.200
     0.679    21.625     0.200
     0.686    21.531     0.200
     0.691    21.727     0.200
     0.693    21.750     0.200
     0.693    21.484     0.200
     0.747    23.305     0.200
     0.778    24.164     0.200
     0.999    29.445     0.200
     0.102     5.070     0.200
     0.153     6.121     0.200
     0.179     7.910     0.200
     0.248     9.449     0.200
     0.448    15.430     0.200
     0.456    16.621     0.200
     0.712    23.500     0.200
     0.715    23.328     0.200
     0.780    26.000     0.200
     0.104     5.090     0.200
     0.106     3.539     0.200
     0.113     6.148     0.200
     0.172     7.488     0.200
     0.162     6.512     0.200
     0.163     8.000     0.200
     0.240    10.020     0.200
     0.230     9.270     0.200
     0.394    13.699     0.200
     0.423    15.051     0.200
     0.457    16.211     0.200
     0.444    15.781     0.200
     0.459    16.070     0.200
     0.457    16.910     0.200
     0.463    17.398     0.200
     0.492    17.699     0.200
     0.610    22.090     0.200
     0.590    20.398     0.200
     0.630    22.070     0.200
     0.628    20.852     0.200
     0.641    22.488     0.200
     0.678    22.570     0.200
     0.687    22.750     0.200
     0.681    22.469     0.200
     0.717    24.211     0.200
     0.716    24.012     0.200
     0.719    24.070     0.200
     0.719    23.648     0.200
     0.770    24.891     0.200
     0.761    24.770     0.200
     0.783    26.629     0.200
     0.782    26.500     0.200
     0.784    25.730     0.200
     0.809    27.141     0.200
     0.829    28.609     0.200
     0.833    27.691     0.200
     0.090     4.980     0.200
     0.102     3.270     0.200
     0.154     5.891     0.200
     0.174     8.059     0.200
     0.243     9.980     0.200
     0.318    10.879     0.200
     0.321    10.922     0.200
     0.371    13.301     0.200
     0.405    14.949     0.200
     0.408    14.590     0.200
     0.433    15.000     0.200
     0.445    15.801     0.200
     0.448    15.180     0.200
     0.454    15.641     0.200
     0.470    16.949     0.200
     0.468    16.480     0.200
     0.496    17.500     0.200
     0.496    19.180     0.200
     0.605    19.969     0.200
     0.603    20.570     0.200
     0.609    22.320     0.200
     0.621    21.520     0.200
     0.635    20.570     0.200
     0.637    22.910     0.200
     0.668    22.141     0.200
     0.696    22.602     0.200
     0.726    24.551     0.200
     0.726    23.781     0.200
     0.729    23.719     0.200
     0.774    25.711     0.200
     0.790    25.699     0.200
     0.784    26.559     0.200
     0.794    25.930     0.200
     0.798    26.070     0.200
     0.821    27.449     0.200
     0.093     5.211     0.200
     0.089     5.672     0.200
     0.135     5.102     0.200
     0.188     7.898     0.200
     0.190     8.359     0.200
     0.260    10.914     0.200
     0.338    11.484     0.200
     0.408    14.648     0.200
     0.427    15.742     0.200
     0.430    15.250     0.200
     0.450    15.312     0.200
     0.445    16.078     0.200
     0.469    16.719     0.200
     0.519    19.773     0.200
     0.516    17.148     0.200
     0.598    20.484     0.200
     0.628    20.828     0.200
     0.640    21.758     0.200
     0.655    21.133     0.200
     0.682    22.648     0.200
     0.673    21.953     0.200
     0.713    23.062     0.200
     0.711    23.555     0.200
     0.714    22.852     0.200
     0.714    23.500     0.200
     0.769    23.461     0.200
     0.761    25.922     0.200
     0.775    25.750     0.200
     0.782    25.953     0.200
     0.795    26.258     0.200
     0.808    27.148     0.200
     1.009    31.453     0.200
     0.140     6.441     0.200
     0.302     9.691     0.200
     0.339    11.461     0.200
     0.340    11.320     0.200
     0.346    11.340     0.200
     0.356    12.160     0.200
     0.352    12.512     0.200
     0.347    11.672     0.200
     0.424    14.332     0.200
     0.431    14.633     0.200
     0.457    15.582     0.200
     0.470    15.602     0.200
     0.459    16.160     0.200
     0.481    16.121     0.200
     0.481    15.992     0.200
     0.475    16.781     0.200
     0.504    16.953     0.200
     0.501    17.230     0.200
     0.526    18.332     0.200
     0.526    18.180     0.200
     0.549    18.602     0.200
     0.581    19.281     0.200
     0.592    20.113     0.200
     0.623    20.652     0.200
     0.687    22.062     0.200
     0.680    21.602     0.200
     0.704    23.211     0.200
     0.693    23.422     0.200
     0.741    24.340     0.200
     0.756    25.332     0.200
     0.774    25.410     0.200
     0.762    24.660     0.200
     0.766    26.363     0.200
     0.814    27.723     0.200
     0.821    28.023     0.200
     0.803    25.793     0.200
     0.844    27.301     0.200
     0.849    27.281     0.200
     0.880    28.121     0.200
     0.880    28.742     0.200
     0.898    28.742     0.200
     0.958    30.660     0.200
     1.047    32.680     0.200
     1.583    50.180     0.200
     0.122     6.031     0.200
     0.206     7.953     0.200
     0.316    10.523     0.200
     0.307    11.633     0.200
     0.323    12.836     0.200
     0.333    13.164     0.200
     0.355    12.547     0.200
     0.345    12.305     0.200
     0.410    13.938     0.200
     0.480    15.773     0.200
     0.493    17.156     0.200
     0.533    17.445     0.200
     0.606    20.523     0.200
     0.581    19.977     0.200
     0.597    20.633     0.200
     0.619    20.344     0.200
     0.660    22.711     0.200
     0.667    22.227     0.200
     0.686    23.156     0.200
     0.716    23.227     0.200
     0.817    27.625     0.200
     0.881    27.953     0.200
     0.910    28.961     0.200
     0.031     2.398     0.200
     0.163     7.258     0.200
     0.197     6.734     0.200
     0.208     8.016     0.200
     0.312    10.156     0.200
     0.321    12.133     0.200
     0.342    12.469     0.200
     0.421    13.914     0.200
     0.488    15.773     0.200
     0.603    20.398     0.200
     0.608    20.703     0.200
     0.647    21.844     0.200
     0.654    22.086     0.200
     0.674    22.883     0.200
     0.709    23.312     0.200
     0.882    28.594     0.200
     0.897    29.156     0.200
     0.900    29.023     0.200
     0.973    31.258     0.200
     0.971    30.438     0.200
     0.157     7.250     0.200
     0.212     7.836     0.200
     0.220     9.578     0.200
     0.238     9.867     0.200
     0.309    10.508     0.200
     0.418    14.156     0.200
     0.446    16.031     0.200
     0.494    17.500     0.200
     0.532    16.906     0.200
     0.604    20.648     0.200
     0.611    20.617     0.200
     0.607    20.711     0.200
     0.652    22.117     0.200
     0.660    22.578     0.200
     0.683    22.531     0.200
     0.716    23.289     0.200
     0.878    27.695     0.200
     0.907    27.734     0.200
     0.907    28.641     0.200
     0.975    30.359     0.200
     0.024     2.977     0.200
     0.195     7.367     0.200
     0.193     9.055     0.200
     0.208     7.820     0.200
     0.223     9.641     0.200
     0.311    11.844     0.200
     0.314    10.547     0.200
     0.318    13.078     0.200
     0.329    13.008     0.200
     0.347    12.547     0.200
     0.350    12.344     0.200
     0.447    16.000     0.200
     0.484    16.117     0.200
     0.492    17.336     0.200
     0.584    19.789     0.200
     0.608    20.828     0.200
     0.615    20.148     0.200
     0.662    21.977     0.200
     0.714    22.523     0.200
     0.878    27.445     0.200
     0.113     6.057     0.200
     0.160     7.377     0.200
     0.206     8.087     0.200
     0.219     9.407     0.200
     0.286    12.247     0.200
     0.313    12.347     0.200
     0.323    12.677     0.200
     0.345    12.847     0.200
     0.485    16.487     0.200
     0.453    16.117     0.200
     0.614    21.267     0.200
     0.611    20.467     0.200
     0.687    22.717     0.200
     0.708    22.227     0.200
     0.103     5.350     0.200
     0.170     7.740     0.200
     0.207     7.980     0.200
     0.211     9.010     0.200
     0.303    12.300     0.200
     0.295    12.230     0.200
     0.314    12.700     0.200
     0.321    12.030     0.200
     0.336    11.750     0.200
     0.425    14.440     0.200
     0.490    16.040     0.200
     0.587    19.700     0.200
     0.604    20.440     0.200
     0.604    19.860     0.200
     0.647    21.570     0.200
     0.642    21.510     0.200
     0.702    22.510     0.200
     0.697    22.570     0.200
     0.863    27.100     0.200
     0.892    27.790     0.200
     0.019     3.277     0.200
     0.149     7.066     0.200
     0.207     8.077     0.200
     0.223     9.497     0.200
     0.231     9.626     0.200
     0.228     9.876     0.200
     0.274    11.697     0.200
     0.307    12.106     0.200
     0.315    10.417     0.200
     0.324    12.617     0.200
     0.347    12.467     0.200
     0.334    13.197     0.200
     0.355    12.557     0.200
     0.397    14.396     0.200
     0.410    14.057     0.200
     0.443    15.707     0.200
     0.481    16.287     0.200
     0.495    17.277     0.200
     0.531    17.197     0.200
     0.582    19.267     0.200
     0.598    20.467     0.200
     0.603    20.427     0.200
     0.619    19.836     0.200
     0.660    22.396     0.200
     0.676    22.257     0.200
     0.668    22.057     0.200
     0.688    23.146     0.200
     0.718    23.467     0.200
     0.909    28.287     0.200
     5.802   159.832     0.200
     0.037     3.472     0.200
     0.102     6.241     0.200
     0.170     7.831     0.200
     0.186     8.892     0.200
     0.202     7.701     0.200
     0.213     8.031     0.200
     0.239     9.241     0.200
     0.251    10.321     0.200
     0.295    12.342     0.200
     0.313    11.762     0.200
     0.324    12.691     0.200
     0.307    10.512     0.200
     0.335    11.331     0.200
     0.352    12.611     0.200
     0.428    14.472     0.200
     0.456    16.111     0.200
     0.486    17.302     0.200
     0.495    16.741     0.200
     0.539    17.581     0.200
     0.592    19.481     0.200
     0.609    20.571     0.200
     0.600    20.241     0.200
     0.618    20.981     0.200
     0.647    22.012     0.200
     0.667    22.671     0.200
     0.707    22.991     0.200
     0.697    22.981     0.200
     0.866    27.291     0.200
     0.167     7.836     0.200
     0.213     8.086     0.200
     0.225     8.156     0.200
     0.245     9.996     0.200
     0.242    10.137     0.200
     0.288    12.148     0.200
     0.295     9.797     0.200
     0.309    12.586     0.200
     0.318    12.586     0.200
     0.329    12.316     0.200
     0.336    11.879     0.200
     0.365    13.066     0.200
     0.393    14.727     0.200
     0.432    14.488     0.200
     0.443    15.879     0.200
     0.500    17.520     0.200
     0.503    16.727     0.200
     0.525    17.289     0.200
     0.570    19.969     0.200
     0.603    19.867     0.200
     0.598    20.359     0.200
     0.619    20.789     0.200
     0.606    20.809     0.200
     0.652    22.047     0.200
     0.167     7.672     0.200
     0.224     8.391     0.200
     0.243    10.059     0.200
     0.244    10.328     0.200
     0.288    11.961     0.200
     0.296     9.910     0.200
     0.308    12.430     0.200
     0.318    13.109     0.200
     0.336    12.070     0.200
     0.364    12.949     0.200
     0.393    14.660     0.200
     0.430    15.988     0.200
     0.431    14.539     0.200
     0.444    15.891     0.200
     0.502    16.398     0.200
     0.499    17.320     0.200
     0.525    17.219     0.200
     0.602    19.719     0.200
     0.606    20.531     0.200
     0.618    20.480     0.200
     0.720    24.070     0.200
     0.027     3.516     0.200
     0.164     7.617     0.200
     0.210     7.953     0.200
     0.222     8.062     0.200
     0.240     9.711     0.200
     0.200     9.664     0.200
     0.212     9.250     0.200
     0.285    11.711     0.200
     0.325    12.055     0.200
     0.299    10.023     0.200
     0.362    12.711     0.200
     0.340    11.797     0.200
     0.428    14.891     0.200
     0.394    14.531     0.200
     0.443    15.875     0.200
     0.499    16.383     0.200
     0.526    17.266     0.200
     0.599    19.547     0.200
     0.605    20.570     0.200
     0.615    20.617     0.200
     0.602    19.695     0.200
     0.644    21.625     0.200
     0.655    21.781     0.200
     0.677    23.336     0.200
     0.721    23.281     0.200
     0.021     3.453     0.200
     0.130     6.344     0.200
     0.185     7.156     0.200
     0.199     7.484     0.200
     0.205     9.117     0.200
     0.215     8.805     0.200
     0.249    10.625     0.200
     0.327    11.000     0.200
     0.338    11.688     0.200
     0.343    12.977     0.200
     0.353    13.625     0.200
     0.375    13.266     0.200
     0.435    15.625     0.200
     0.465    15.195     0.200
     0.501    17.188     0.200
     0.571    19.969     0.200
     0.569    18.680     0.200
     0.639    21.156     0.200
     0.657    22.234     0.200
     0.680    22.617     0.200
     0.687    22.617     0.200
     0.725    23.406     0.200
     0.897    28.188     0.200
     0.925    28.750     0.200
     0.203     7.148     0.200
     0.245     8.164     0.200
     0.338    13.320     0.200
     0.313    10.750     0.200
     0.301    12.172     0.200
     0.368    13.867     0.200
     0.364    13.852     0.200
     0.414    15.969     0.200
     0.445    15.352     0.200
     0.467    15.938     0.200
     0.507    17.523     0.200
     0.528    18.281     0.200
     0.561    19.781     0.200
     0.520    18.430     0.200
     0.566    18.383     0.200
     0.618    19.797     0.200
     0.694    23.422     0.200
     0.660    21.859     0.200
     0.701    22.930     0.200
     0.793    25.680     0.200
     0.067     4.141     0.200
     0.143     6.781     0.200
     0.224     8.250     0.200
     0.281    11.227     0.200
     0.273     8.859     0.200
     0.277     9.750     0.200
     0.280     9.961     0.200
     0.339    12.984     0.200
     0.400    15.625     0.200
     0.412    14.359     0.200
     0.496    16.383     0.200
     0.523    18.242     0.200
     0.535    17.586     0.200
     0.529    18.047     0.200
     0.540    18.852     0.200
     0.587    19.016     0.200
     0.567    19.953     0.200
     0.607    20.477     0.200
     0.679    21.781     0.200
     0.691    22.891     0.200
     0.099     4.744     0.200
     0.231     7.684     0.200
     0.236     8.203     0.200
     0.269     9.074     0.200
     0.273    10.443     0.200
     0.302     9.854     0.200
     0.293     9.664     0.200
     0.313    10.555     0.200
     0.336    11.764     0.200
     0.341    10.963     0.200
     0.352    12.943     0.200
     0.419    14.234     0.200
     0.429    14.484     0.200
     0.449    15.234     0.200
     0.454    14.943     0.200
     0.457    14.514     0.200
     0.472    15.805     0.200
     0.458    16.064     0.200
     0.502    17.273     0.200
     0.503    16.543     0.200
     0.539    17.494     0.200
     0.534    17.494     0.200
     0.603    19.914     0.200
     0.626    21.193     0.200
     0.627    20.324     0.200
     0.636    20.953     0.200
     0.652    21.873     0.200
     0.681    22.064     0.200
     0.671    21.984     0.200
     0.696    23.475     0.200
     0.673    21.994     0.200
     0.690    22.305     0.200
     0.683    22.463     0.200
     0.697    23.373     0.200
     0.735    24.084     0.200
     0.739    24.293     0.200
     0.738    24.914     0.200
     0.773    24.574     0.200
     0.775    25.213     0.200
     0.801    25.684     0.200
     0.791    25.754     0.200
     0.809    25.764     0.200
     0.823    26.344     0.200
     0.837    27.283     0.200
     0.839    27.734     0.200
     0.895    28.273     0.200
     5.119   142.297     0.200
     0.229     8.539     0.200
     0.233     8.758     0.200
     0.440    15.719     0.200
     0.437    14.586     0.200
     0.453    15.477     0.200
     0.495    15.039     0.200
     0.498    15.539     0.200
     0.506    16.680     0.200
     0.541    16.570     0.200
     0.499    17.586     0.200
     0.566    19.867     0.200
     0.586    19.398     0.200
     0.639    20.102     0.200
     0.648    19.969     0.200
     0.654    20.445     0.200
     0.659    20.852     0.200
     0.656    20.461     0.200
     0.667    22.547     0.200
     0.704    22.008     0.200
     0.711    23.016     0.200
     0.733    22.938     0.200
     0.760    23.719     0.200
     0.839    25.711     0.200
     1.276    37.195     0.200
     0.011     1.410     0.200
     0.071     4.441     0.200
     0.095     5.039     0.200
     0.151     6.719     0.200
     0.194     8.328     0.200
     0.191     9.301     0.200
     0.203     9.051     0.200
     0.215     8.121     0.200
     0.262     8.691     0.200
     0.289    11.270     0.200
     0.293     9.961     0.200
     0.350    13.590     0.200
     0.366    13.660     0.200
     0.425    14.898     0.200
     0.468    15.910     0.200
     0.520    17.738     0.200
     0.574    18.559     0.200
     0.535    18.418     0.200
     0.545    18.250     0.200
     0.568    19.281     0.200
     0.599    19.641     0.200
     0.605    20.941     0.200
     0.672    22.258     0.200
     0.611    20.160     0.200
     0.626    21.121     0.200
     0.644    21.309     0.200
     0.680    22.340     0.200
     0.681    23.250     0.200
     0.705    24.250     0.200
     0.703    23.840     0.200
     0.725    25.039     0.200
     0.760    25.609     0.200
     0.808    27.000     0.200
     0.794    27.551     0.200
     0.813    27.621     0.200
     0.826    26.125     0.200
     0.893    28.320     0.200
     0.112     5.656     0.200
     0.099     5.211     0.200
     0.204     8.328     0.200
     0.286    11.336     0.200
     0.289    10.172     0.200
     0.367    13.711     0.200
     0.421    14.617     0.200
     0.488    16.711     0.200
     0.522    17.945     0.200
     0.542    18.172     0.200
     0.542    20.086     0.200
     0.536    18.797     0.200
     0.564    19.391     0.200
     0.595    19.289     0.200
     0.576    18.484     0.200
     0.609    21.281     0.200
     0.646    22.602     0.200
     0.676    21.906     0.200
     0.643    21.398     0.200
     0.674    21.367     0.200
     0.699    23.602     0.200
     0.699    23.352     0.200
     0.725    24.930     0.200
     0.759    25.758     0.200
     0.775    25.109     0.200
     0.782    27.461     0.200
     0.788    25.188     0.200
     0.794    26.469     0.200
     0.811    27.000     0.200
     0.825    26.398     0.200
     0.895    28.172     0.200
     0.063     3.871     0.200
     0.150     7.141     0.200
     0.232     7.199     0.200
     0.222     9.020     0.200
     0.251    10.352     0.200
     0.260     9.762     0.200
     0.297    11.801     0.200
     0.332    12.930     0.200
     0.332    12.520     0.200
     0.369    13.668     0.200
     0.388    14.320     0.200
     0.391    15.352     0.200
     0.434    16.199     0.200
     0.495    16.551     0.200
     0.508    17.699     0.200
     0.512    18.301     0.200
     0.523    18.809     0.200
     0.543    17.559     0.200
     0.537    19.531     0.200
     0.579    20.031     0.200
     0.566    19.480     0.200
     0.566    19.891     0.200
     0.586    20.500     0.200
     0.591    19.418     0.200
     0.623    21.191     0.200
     0.628    21.578     0.200
     0.647    21.488     0.200
     0.655    19.941     0.200
     0.660    22.191     0.200
     0.638    22.148     0.200
     0.664    22.879     0.200
     0.647    22.012     0.200
     0.689    23.449     0.200
     0.697    22.461     0.200
     0.752    25.020     0.200
     0.775    25.148     0.200
     0.759    26.289     0.200
     0.777    24.918     0.200
     0.791    26.219     0.200
     0.797    26.621     0.200
     0.790    24.609     0.200
     0.804    26.512     0.200
     0.795    27.371     0.200
     0.786    25.262     0.200
     0.809    26.750     0.200
     0.823    26.031     0.200
     0.853    27.262     0.200
     0.974    30.289     0.200
     0.029     2.836     0.200
     0.051     3.977     0.200
     0.098     5.605     0.200
     0.135     7.047     0.200
     0.220    10.047     0.200
     0.255    10.957     0.200
     0.310    11.855     0.200
     0.286     9.809     0.200
     0.330    12.879     0.200
     0.322    12.316     0.200
     0.325    12.406     0.200
     0.388    13.605     0.200
     0.483    17.508     0.200
     0.531    17.238     0.200
     0.525    18.629     0.200
     0.540    19.516     0.200
     0.559    18.086     0.200
     0.599    20.148     0.200
     0.576    18.828     0.200
     0.587    19.707     0.200
     0.642    20.277     0.200
     0.631    21.719     0.200
     0.664    21.836     0.200
     0.680    22.355     0.200
     0.679    22.508     0.200
     0.681    21.789     0.200
     0.026     2.922     0.200
     0.053     3.734     0.200
     0.100     5.141     0.200
     0.122     6.250     0.200
     0.167     8.062     0.200
     0.226     9.875     0.200
     0.258     9.180     0.200
     0.285     9.445     0.200
     0.324    12.742     0.200
     0.324    12.094     0.200
     0.333    12.812     0.200
     0.402    15.742     0.200
     0.452    16.406     0.200
     0.480    17.000     0.200
     0.510    16.820     0.200
     0.521    18.422     0.200
     0.525    18.367     0.200
     0.534    18.594     0.200
     0.521    17.375     0.200
     0.544    19.766     0.200
     0.562    18.297     0.200
     0.553    19.195     0.200
     0.560    18.766     0.200
     0.584    20.297     0.200
     0.577    18.875     0.200
     0.600    20.250     0.200
     0.607    20.492     0.200
     0.645    21.352     0.200
     0.634    21.820     0.200
     0.653    21.633     0.200
     0.670    21.906     0.200
     0.681    22.742     0.200
     0.683    23.352     0.200
     0.667    22.156     0.200
     0.681    22.992     0.200
     0.681    21.953     0.200
     0.762    25.344     0.200
     0.782    25.477     0.200
     0.774    24.531     0.200
     0.797    25.820     0.200
     0.797    25.156     0.200
     0.797    27.281     0.200
     0.806    26.797     0.200
     0.810    26.844     0.200
     0.831    26.516     0.200
     0.874    27.562     0.200
     0.996    30.664     0.200
     0.030     3.122     0.200
     0.054     3.992     0.200
     0.101     5.632     0.200
     0.121     6.302     0.200
     0.135     6.812     0.200
     0.217     9.422     0.200
     0.254     9.052     0.200
     0.227     9.922     0.200
     0.257    10.492     0.200
     0.250     9.412     0.200
     0.311    12.021     0.200
     0.289     9.442     0.200
     0.325    12.012     0.200
     0.333    12.582     0.200
     0.379    14.992     0.200
     0.387    13.521     0.200
     0.386    13.962     0.200
     0.507    16.832     0.200
     0.480    17.182     0.200
     0.516    17.992     0.200
     0.530    17.942     0.200
     0.522    18.271     0.200
     0.542    19.702     0.200
     0.559    18.152     0.200
     0.524    17.521     0.200
     0.555    19.232     0.200
     0.561    19.232     0.200
     0.579    18.642     0.200
     0.596    20.172     0.200
     0.584    20.042     0.200
     0.605    20.172     0.200
     0.641    20.832     0.200
     0.639    21.842     0.200
     0.652    21.372     0.200
     0.664    21.952     0.200
     0.677    22.662     0.200
     0.683    22.892     0.200
     0.684    21.902     0.200
     0.740    24.212     0.200
     0.760    25.552     0.200
     0.781    24.412     0.200
     0.793    25.362     0.200
     0.776    24.582     0.200
     0.796    27.262     0.200
     0.036     2.262     0.200
     0.291    11.281     0.200
     0.299     9.512     0.200
     0.343    13.082     0.200
     0.363    13.342     0.200
     0.430    16.053     0.200
     0.439    16.291     0.200
     0.501    17.383     0.200
     0.495    16.682     0.200
     0.541    17.701     0.200
     0.542    18.592     0.200
     0.519    18.252     0.200
     0.518    17.092     0.200
     0.553    19.461     0.200
     0.542    19.002     0.200
     0.585    18.992     0.200
     0.584    20.771     0.200
     0.574    19.072     0.200
     0.592    20.002     0.200
     0.611    20.682     0.200
     0.610    19.602     0.200
     0.613    20.121     0.200
     0.643    21.242     0.200
     0.659    21.562     0.200
     0.666    22.143     0.200
     0.669    22.701     0.200
     0.674    23.441     0.200
     0.684    22.861     0.200
     0.709    22.893     0.200
     0.721    23.711     0.200
     0.725    24.291     0.200
     0.738    24.812     0.200
     0.755    26.143     0.200
     0.776    25.812     0.200
     0.769    25.883     0.200
     0.793    25.932     0.200
     0.791    25.633     0.200
     0.793    25.816     0.200
     0.793    25.711     0.200
     0.809    25.732     0.200
     1.550    47.582     0.200
     0.039     3.174     0.200
     0.054     3.904     0.200
     0.102     5.215     0.200
     0.115     6.115     0.200
     0.144     6.924     0.200
     0.223     9.574     0.200
     0.240     7.705     0.200
     0.245     8.785     0.200
     0.250    10.484     0.200
     0.296     9.625     0.200
     0.302    11.814     0.200
     0.321    12.355     0.200
     0.324    12.145     0.200
     0.328    12.744     0.200
     0.378    13.305     0.200
     0.374    14.715     0.200
     0.393    15.395     0.200
     0.444    15.715     0.200
     0.485    17.475     0.200
     0.499    16.145     0.200
     0.519    18.184     0.200
     0.533    17.705     0.200
     0.516    18.125     0.200
     0.522    17.635     0.200
     0.536    19.555     0.200
     0.563    19.805     0.200
     0.567    19.145     0.200
     0.550    17.744     0.200
     0.589    20.195     0.200
     0.581    18.855     0.200
     0.590    19.615     0.200
     0.637    21.725     0.200
     0.632    20.584     0.200
     0.632    21.445     0.200
     0.653    21.314     0.200
     0.671    22.324     0.200
     0.655    21.955     0.200
     0.682    22.955     0.200
     0.687    21.744     0.200
     0.748    24.725     0.200
     0.760    25.154     0.200
     0.775    23.764     0.200
     0.797    24.865     0.200
     0.830    26.164     0.200
     0.140     6.969     0.200
     0.198     9.328     0.200
     0.257     9.023     0.200
     0.303    12.008     0.200
     0.275    11.094     0.200
     0.345    12.758     0.200
     0.387    13.492     0.200
     0.399    15.586     0.200
     0.417    16.195     0.200
     0.507    17.719     0.200
     0.521    18.328     0.200
     0.520    17.234     0.200
     0.514    16.852     0.200
     0.542    18.477     0.200
     0.540    18.375     0.200
     0.566    17.922     0.200
     0.622    21.219     0.200
     0.597    19.445     0.200
     0.651    20.367     0.200
     0.644    21.008     0.200
     0.668    21.805     0.200
     0.655    22.445     0.200
     0.669    22.492     0.200
     0.740    25.062     0.200
     0.700    21.266     0.200
     0.775    24.258     0.200
     0.776    26.758     0.200
     0.744    24.508     0.200
     0.789    26.555     0.200
     0.810    24.703     0.200
     0.810    25.742     0.200
     0.795    25.297     0.200
     0.987    30.227     0.200
     0.050     3.004     0.200
     0.111     5.794     0.200
     0.099     5.523     0.200
     0.163     7.954     0.200
     0.157     7.464     0.200
     0.183     8.324     0.200
     0.155     7.684     0.200
     0.165     8.014     0.200
     0.287    10.233     0.200
     0.318    11.974     0.200
     0.302    10.023     0.200
     0.324    12.444     0.200
     0.362    13.784     0.200
     0.395    15.034     0.200
     0.412    14.804     0.200
     0.427    14.284     0.200
     0.496    17.694     0.200
     0.499    17.884     0.200
     0.523    18.354     0.200
     0.554    19.654     0.200
     0.561    18.444     0.200
     0.569    20.504     0.200
     0.595    19.754     0.200
     0.601    19.944     0.200
     0.596    20.164     0.200
     0.622    20.604     0.200
     0.635    21.744     0.200
     0.672    22.124     0.200
     0.671    23.454     0.200
     0.692    24.523     0.200
     0.699    23.634     0.200
     0.712    24.974     0.200
     0.718    23.864     0.200
     0.741    24.224     0.200
     0.750    24.523     0.200
     0.778    25.933     0.200
     0.806    26.284     0.200
     0.824    26.874     0.200
     0.865    27.714     0.200
     0.051     2.072     0.200
     0.098     5.113     0.200
     0.113     5.771     0.200
     0.154     7.521     0.200
     0.185     8.582     0.200
     0.192     7.193     0.200
     0.280    11.193     0.200
     0.301     9.822     0.200
     0.320    12.271     0.200
     0.363    13.873     0.200
     0.396    14.803     0.200
     0.413    14.713     0.200
     0.427    15.422     0.200
     0.443    17.053     0.200
     0.461    18.092     0.200
     0.477    16.143     0.200
     0.496    17.203     0.200
     0.497    17.262     0.200
     0.521    18.172     0.200
     0.555    18.953     0.200
     0.562    18.252     0.200
     0.560    19.213     0.200
     0.570    19.883     0.200
     0.596    20.002     0.200
     0.595    20.693     0.200
     0.602    20.521     0.200
     0.602    19.902     0.200
     0.606    21.822     0.200
     0.623    20.072     0.200
     0.635    21.203     0.200
     0.664    22.422     0.200
     0.672    23.213     0.200
     0.673    22.592     0.200
     0.693    24.363     0.200
     0.711    24.492     0.200
     0.700    23.592     0.200
     0.719    23.082     0.200
     0.736    26.283     0.200
     0.740    24.543     0.200
     0.732    25.602     0.200
     0.738    24.832     0.200
     0.766    25.502     0.200
     0.775    25.992     0.200
     0.777    25.877     0.200
     0.795    26.582     0.200
     0.805    26.123     0.200
     0.810    26.213     0.200
     0.823    25.852     0.200
     0.865    27.521     0.200
     0.055     2.676     0.200
     0.115     5.705     0.200
     0.106     5.076     0.200
     0.161     6.906     0.200
     0.155     7.846     0.200
     0.184     8.246     0.200
     0.165     7.826     0.200
     0.282    10.766     0.200
     0.273    11.225     0.200
     0.309    10.135     0.200
     0.322    11.926     0.200
     0.359    13.775     0.200
     0.384    14.064     0.200
     0.405    14.656     0.200
     0.443    17.195     0.200
     0.458    18.096     0.200
     0.483    16.705     0.200
     0.501    17.725     0.200
     0.520    18.736     0.200
     0.547    19.064     0.200
     0.558    18.465     0.200
     0.574    20.406     0.200
     0.596    19.736     0.200
     0.592    20.746     0.200
     0.595    20.826     0.200
     0.628    20.555     0.200
     0.628    21.285     0.200
     0.666    22.305     0.200
     0.696    24.006     0.200
     0.693    23.375     0.200
     0.706    23.506     0.200
     0.742    25.176     0.200
     0.773    25.969     0.200
     0.787    26.275     0.200
     0.800    25.945     0.200
     0.816    27.115     0.200
     0.857    27.586     0.200
     0.114     5.779     0.200
     0.183     8.391     0.200
     0.273    10.820     0.200
     0.281     9.879     0.200
     0.281     9.721     0.200
     0.317    12.570     0.200
     0.310    10.100     0.200
     0.323    12.061     0.200
     0.357    13.629     0.200
     0.404    14.230     0.200
     0.396    14.850     0.200
     0.417    15.500     0.200
     0.484    16.449     0.200
     0.499    18.049     0.200
     0.521    18.480     0.200
     0.546    18.539     0.200
     0.557    18.340     0.200
     0.586    19.221     0.200
     0.574    20.160     0.200
     0.595    19.439     0.200
     0.595    20.189     0.200
     0.592    19.430     0.200
     0.604    20.990     0.200
     0.627    20.350     0.200
     0.628    20.529     0.200
     0.655    21.900     0.200
     0.662    22.730     0.200
     0.665    21.689     0.200
     0.696    24.340     0.200
     0.706    23.561     0.200
     0.692    23.289     0.200
     0.737    24.029     0.200
     0.742    25.000     0.200
     0.747    24.660     0.200
     0.759    25.840     0.200
     0.771    25.119     0.200
     0.773    24.062     0.200
     0.773    25.020     0.200
     0.800    26.340     0.200
     0.800    25.629     0.200
     0.815    26.529     0.200
     0.866    27.520     0.200
     1.534    48.010     0.200
     0.190     7.148     0.200
     0.203     8.156     0.200
     0.299    11.578     0.200
     0.306    11.461     0.200
     0.321    13.016     0.200
     0.322    13.078     0.200
     0.346    12.461     0.200
     0.362    14.078     0.200
     0.378    14.484     0.200
     0.379    15.008     0.200
     0.392    13.930     0.200
     0.414    14.586     0.200
     0.408    14.852     0.200
     0.422    14.648     0.200
     0.427    14.078     0.200
     0.430    14.047     0.200
     0.447    16.828     0.200
     0.444    14.875     0.200
     0.471    15.766     0.200
     0.484    17.125     0.200
     0.551    19.734     0.200
     0.541    17.875     0.200
     0.577    20.141     0.200
     0.580    20.852     0.200
     0.591    19.945     0.200
     0.589    19.508     0.200
     0.603    19.961     0.200
     0.622    22.336     0.200
     0.649    23.711     0.200
     0.667    20.898     0.200
     0.675    21.875     0.200
     0.677    21.445     0.200
     0.677    21.578     0.200
     0.680    22.039     0.200
     0.680    21.898     0.200
     0.715    22.828     0.200
     0.718    22.648     0.200
     0.721    23.430     0.200
     0.727    24.727     0.200
     0.743    23.781     0.200
     0.743    24.234     0.200
     0.765    24.156     0.200
     0.776    24.852     0.200
     0.804    26.281     0.200
     0.812    26.109     0.200
     0.828    26.148     0.200
     0.884    27.688     0.200
     0.893    28.266     0.200
     0.893    27.789     0.200
     0.916    28.867     0.200
     0.050     3.668     0.200
     0.063     4.418     0.200
     0.110     6.039     0.200
     0.116     6.059     0.200
     0.154     7.160     0.200
     0.225    10.141     0.200
     0.232     8.559     0.200
     0.235     9.988     0.200
     0.248    10.328     0.200
     0.264    10.000     0.200
     0.309    10.141     0.200
     0.330    12.730     0.200
     0.331    12.289     0.200
     0.365    12.988     0.200
     0.374    14.840     0.200
     0.390    13.758     0.200
     0.491    16.328     0.200
     0.483    17.359     0.200
     0.496    17.418     0.200
     0.509    17.301     0.200
     0.516    19.090     0.200
     0.507    17.840     0.200
     0.534    19.301     0.200
     0.539    17.770     0.200
     0.542    18.277     0.200
     0.569    19.777     0.200
     0.569    19.219     0.200
     0.576    18.879     0.200
     0.591    19.141     0.200
     0.588    20.230     0.200
     0.594    19.988     0.200
     0.620    20.230     0.200
     0.623    21.391     0.200
     0.637    21.918     0.200
     0.628    21.359     0.200
     0.648    21.250     0.200
     0.654    21.539     0.200
     0.658    22.207     0.200
     0.643    21.328     0.200
     0.662    22.289     0.200
     0.688    23.051     0.200
     0.698    22.008     0.200
     0.753    24.848     0.200
     0.762    25.188     0.200
     0.771    24.758     0.200
     0.786    24.949     0.200
     0.792    25.309     0.200
     0.163     7.137     0.200
     0.102     5.477     0.200
     0.170     7.117     0.200
     0.167     6.527     0.200
     0.128     6.097     0.200
     0.128     6.097     0.200
     0.155     7.547     0.200
     0.174     7.887     0.200
     0.206     7.607     0.200
     0.203     8.087     0.200
     0.256     9.647     0.200
     0.265     9.747     0.200
     0.330    11.477     0.200
     0.330    11.537     0.200
     0.332    11.688     0.200
     0.297    11.007     0.200
     0.283    11.587     0.200
     0.319    11.127     0.200
     0.371    13.117     0.200
     0.405    13.938     0.200
     0.332    12.447     0.200
     0.402    13.797     0.200
     0.345    12.057     0.200
     0.351    13.737     0.200
     0.365    12.707     0.200
     0.421    13.987     0.200
     0.340    12.677     0.200
     0.388    13.897     0.200
     0.364    13.177     0.200
     0.436    15.197     0.200
     0.425    15.517     0.200
     0.418    14.767     0.200
     0.490    15.827     0.200
     0.455    15.457     0.200
     0.498    16.107     0.200
     0.535    17.167     0.200
     0.457    15.917     0.200
     0.541    18.037     0.200
     0.464    16.287     0.200
     0.515    17.487     0.200
     0.539    17.217     0.200
     0.512    16.847     0.200
     0.514    17.607     0.200
     0.496    16.987     0.200
     0.513    17.417     0.200
     0.596    18.727     0.200
     0.542    20.037     0.200
     0.579    19.727     0.200
     0.606    19.427     0.200
     0.637    19.767     0.200
     0.611    21.307     0.200
     0.612    21.277     0.200
     0.578    19.837     0.200
     0.638    22.207     0.200
     0.663    21.137     0.200
     0.636    21.137     0.200
     0.679    21.147     0.200
     0.670    21.057     0.200
     0.623    20.767     0.200
     0.644    20.777     0.200
     0.627    21.137     0.200
     0.637    20.337     0.200
     0.681    21.897     0.200
     0.726    22.677     0.200
     0.733    23.057     0.200
     0.747    23.297     0.200
     0.761    23.627     0.200
     0.748    23.467     0.200
     0.763    23.627     0.200
     0.780    24.037     0.200
     0.736    23.887     0.200
     0.726    24.167     0.200
     0.732    23.777     0.200
     0.820    25.377     0.200
     0.813    25.137     0.200
     0.823    25.197     0.200
     0.823    25.467     0.200
     0.854    26.237     0.200
     0.854    25.877     0.200
     0.963    29.247     0.200
     1.192    34.877     0.200
     0.140     6.406     0.200
     0.133     6.375     0.200
     0.171     7.367     0.200
     0.197     7.578     0.200
     0.192     8.285     0.200
     0.221     8.875     0.200
     0.258     9.246     0.200
     0.245    10.246     0.200
     0.269     9.527     0.200
     0.263    10.016     0.200
     0.277    10.406     0.200
     0.300    10.785     0.200
     0.296    10.156     0.200
     0.331    11.578     0.200
     0.317    11.488     0.200
     0.344    11.648     0.200
     0.346    12.188     0.200
     0.375    12.496     0.200
     0.372    12.578     0.200
     0.385    13.105     0.200
     0.389    12.816     0.200
     0.389    13.105     0.200
     0.386    13.375     0.200
     0.405    13.387     0.200
     0.406    13.516     0.200
     0.400    13.676     0.200
     0.410    13.707     0.200
     0.396    14.105     0.200
     0.396    13.668     0.200
     0.427    13.898     0.200
     0.438    14.676     0.200
     0.434    14.457     0.200
     0.451    15.035     0.200
     0.440    14.656     0.200
     0.463    15.617     0.200
     0.454    14.465     0.200
     0.469    15.285     0.200
     0.477    15.496     0.200
     0.465    15.637     0.200
     0.482    16.176     0.200
     0.475    16.258     0.200
     0.499    16.117     0.200
     0.511    16.605     0.200
     0.503    16.516     0.200
     0.523    17.285     0.200
     0.527    17.957     0.200
     0.571    18.078     0.200
     0.577    18.426     0.200
     0.555    19.898     0.200
     0.562    18.465     0.200
     0.571    18.176     0.200
     0.581    19.355     0.200
     0.575    20.297     0.200
     0.576    19.215     0.200
     0.586    19.426     0.200
     0.605    19.297     0.200
     0.613    19.527     0.200
     0.625    19.836     0.200
     0.620    20.246     0.200
     0.645    21.938     0.200
     0.640    20.586     0.200
     0.657    21.496     0.200
     0.652    20.777     0.200
     0.657    21.438     0.200
     0.646    20.945     0.200
     0.643    22.637     0.200
     0.650    21.695     0.200
     0.665    22.117     0.200
     0.684    22.277     0.200
     0.692    21.809     0.200
     0.709    23.496     0.200
     0.705    23.117     0.200
     0.710    23.625     0.200
     0.705    23.945     0.200
     0.706    23.457     0.200
     0.716    22.445     0.200
     0.731    23.695     0.200
     0.733    23.605     0.200
     0.738    24.066     0.200
     0.732    23.027     0.200
     0.732    23.566     0.200
     0.743    23.258     0.200
     0.750    24.406     0.200
     0.742    24.758     0.200
     0.768    26.258     0.200
     0.753    23.668     0.200
     0.755    24.195     0.200
     0.787    24.297     0.200
     0.815    25.215     0.200
     0.094     5.578     0.200
     0.126     7.500     0.200
     0.126     6.328     0.200
     0.133     6.672     0.200
     0.174     8.023     0.200
     0.175     9.391     0.200
     0.235     7.875     0.200
     0.235     8.000     0.200
     0.261    10.039     0.200
     0.266    10.961     0.200
     0.273     9.125     0.200
     0.297    12.000     0.200
     0.316    11.773     0.200
     0.322    10.922     0.200
     0.341    13.188     0.200
     0.359    14.125     0.200
     0.378    13.250     0.200
     0.388    12.930     0.200
     0.435    14.523     0.200
     0.435    14.625     0.200
     0.435    14.070     0.200
     0.461    15.414     0.200
     0.457    16.359     0.200
     0.474    17.539     0.200
     0.479    16.891     0.200
     0.487    17.031     0.200
     0.528    19.062     0.200
     0.536    18.023     0.200
     0.534    17.594     0.200
     0.567    18.648     0.200
     0.565    18.062     0.200
     0.567    18.148     0.200
     0.567    20.453     0.200
     0.582    19.555     0.200
     0.598    19.484     0.200
     0.590    20.883     0.200
     0.625    20.242     0.200
     0.658    22.109     0.200
     0.678    23.898     0.200
     0.671    21.375     0.200
     0.671    23.242     0.200
     0.722    23.664     0.200
     0.722    25.453     0.200
     0.723    25.203     0.200
     0.733    23.969     0.200
     0.749    24.609     0.200
     0.790    25.984     0.200
     0.785    26.109     0.200
     0.811    25.734     0.200
     0.827    25.734     0.200
     1.543    49.188     0.200
     1.541    46.242     0.200
     0.086     3.773     0.200
     0.139     4.973     0.200
     0.142     6.301     0.200
     0.188     7.574     0.200
     0.187     7.461     0.200
     0.209     7.441     0.200
     0.209     7.508     0.200
     0.209     7.703     0.200
     0.225     7.551     0.200
     0.248     8.684     0.200
     0.248     9.004     0.200
     0.226     9.203     0.200
     0.260     8.672     0.200
     0.241     8.164     0.200
     0.249     8.852     0.200
     0.290    10.164     0.200
     0.290    10.434     0.200
     0.285    10.184     0.200
     0.320    11.211     0.200
     0.330    11.512     0.200
     0.320    11.801     0.200
     0.342    12.402     0.200
     0.363    12.684     0.200
     0.347    12.434     0.200
     0.344    12.023     0.200
     0.353    12.883     0.200
     0.366    14.004     0.200
     0.385    13.941     0.200
     0.411    14.773     0.200
     0.427    14.391     0.200
     0.398    13.602     0.200
     0.399    13.613     0.200
     0.411    14.691     0.200
     0.418    14.621     0.200
     0.430    15.164     0.200
     0.426    14.473     0.200
     0.432    14.684     0.200
     0.451    15.031     0.200
     0.433    14.621     0.200
     0.457    15.773     0.200
     0.471    15.363     0.200
     0.520    17.262     0.200
     0.516    17.434     0.200
     0.525    18.574     0.200
     0.532    18.062     0.200
     0.543    17.891     0.200
     0.567    19.914     0.200
     0.537    18.191     0.200
     0.566    19.523     0.200
     0.547    18.863     0.200
     0.557    19.191     0.200
     0.560    18.723     0.200
     0.569    19.273     0.200
     0.582    19.551     0.200
     0.607    19.551     0.200
     0.596    20.422     0.200
     0.635    21.023     0.200
     0.634    20.211     0.200
     0.634    20.934     0.200
     0.641    20.484     0.200
     0.617    22.484     0.200
     0.622    21.391     0.200
     0.664    21.594     0.200
     0.666    21.633     0.200
     0.643    21.031     0.200
     0.652    21.234     0.200
     0.657    21.344     0.200
     0.664    21.531     0.200
     0.685    22.273     0.200
     0.685    22.273     0.200
     0.660    21.973     0.200
     0.661    22.613     0.200
     0.699    23.492     0.200
     0.682    22.371     0.200
     0.703    23.863     0.200
     0.699    22.441     0.200
     0.688    22.344     0.200
     0.707    22.914     0.200
     0.717    22.961     0.200
     0.733    24.191     0.200
     0.703    24.133     0.200
     0.708    23.242     0.200
     0.711    24.242     0.200
     0.747    26.164     0.200
     0.740    23.543     0.200
     0.736    23.723     0.200
     0.747    24.004     0.200
     0.759    23.832     0.200
     0.759    24.023     0.200
     0.761    24.023     0.200
     0.765    24.484     0.200
     0.753    24.473     0.200
     0.782    26.793     0.200
     0.794    26.922     0.200
     0.795    25.344     0.200
     0.773    25.191     0.200
     0.790    25.043     0.200
     0.780    25.773     0.200
     0.788    25.531     0.200
     0.787    25.641     0.200
     0.788    26.062     0.200
     0.808    25.473     0.200
     0.808    25.422     0.200
     0.807    26.453     0.200
     0.832    26.422     0.200
     0.853    26.492     0.200
     0.853    26.762     0.200
     0.857    26.812     0.200
     0.874    27.512     0.200
     0.875    27.852     0.200
     0.911    28.574     0.200
     1.353    39.012     0.200
     0.173     7.355     0.200
     0.158     6.536     0.200
     0.205     8.155     0.200
     0.215     9.315     0.200
     0.243     9.005     0.200
     0.232     8.555     0.200
     0.241     8.735     0.200
     0.246     9.025     0.200
     0.269     9.655     0.200
     0.316    11.315     0.200
     0.298    10.295     0.200
     0.296    10.425     0.200
     0.329    11.996     0.200
     0.299    10.775     0.200
     0.340    12.305     0.200
     0.342    12.405     0.200
     0.341    11.445     0.200
     0.324    11.095     0.200
     0.346    11.936     0.200
     0.374    13.155     0.200
     0.385    13.565     0.200
     0.391    13.215     0.200
     0.366    11.985     0.200
     0.371    12.355     0.200
     0.397    13.496     0.200
     0.427    14.286     0.200
     0.394    13.465     0.200
     0.429    14.985     0.200
     0.432    15.005     0.200
     0.418    15.825     0.200
     0.447    15.036     0.200
     0.442    14.976     0.200
     0.439    14.175     0.200
     0.434    14.505     0.200
     0.444    14.314     0.200
     0.444    14.396     0.200
     0.468    15.516     0.200
     0.502    16.206     0.200
     0.495    16.605     0.200
     0.509    16.925     0.200
     0.511    16.825     0.200
     0.517    16.706     0.200
     0.512    16.405     0.200
     0.528    17.525     0.200
     0.526    17.045     0.200
     0.542    17.496     0.200
     0.551    17.896     0.200
     0.521    16.505     0.200
     0.552    19.875     0.200
     0.542    19.215     0.200
     0.532    18.155     0.200
     0.565    18.825     0.200
     0.531    17.016     0.200
     0.534    17.845     0.200
     0.558    19.246     0.200
     0.540    17.485     0.200
     0.583    19.875     0.200
     0.598    19.286     0.200
     0.592    19.646     0.200
     0.594    19.375     0.200
     0.611    19.916     0.200
     0.633    22.266     0.200
     0.641    21.405     0.200
     0.628    20.706     0.200
     0.667    21.436     0.200
     0.650    22.025     0.200
     0.652    22.065     0.200
     0.662    21.585     0.200
     0.694    23.095     0.200
     0.676    22.175     0.200
     0.673    21.456     0.200
     0.673    21.496     0.200
     0.685    23.516     0.200
     0.673    21.575     0.200
     0.699    21.805     0.200
     0.707    23.615     0.200
     0.711    22.536     0.200
     0.682    22.735     0.200
     0.702    23.305     0.200
     0.688    22.565     0.200
     0.685    22.686     0.200
     0.695    22.375     0.200
     0.731    23.655     0.200
     0.711    22.465     0.200
     0.727    24.396     0.200
     0.721    23.195     0.200
     0.710    23.315     0.200
     0.739    22.976     0.200
     0.750    24.166     0.200
     0.759    25.115     0.200
     0.751    25.715     0.200
     0.773    25.396     0.200
     0.770    24.985     0.200
     0.791    24.646     0.200
     0.779    24.595     0.200
     0.831    25.575     0.200
     0.861    26.635     0.200
     0.885    27.305     0.200
     2.125    63.085     0.200
     2.213    65.635     0.200
     2.943    83.805     0.200
     0.029     2.047     0.200
     0.028     2.236     0.200
     0.083     4.916     0.200
     0.078     4.506     0.200
     0.119     6.096     0.200
     0.164     7.887     0.200
     0.166     7.906     0.200
     0.187     8.887     0.200
     0.206     9.455     0.200
     0.195     8.797     0.200
     0.202     7.576     0.200
     0.302    12.166     0.200
     0.307    10.355     0.200
     0.311    11.066     0.200
     0.360    13.547     0.200
     0.416    15.955     0.200
     0.467    16.086     0.200
     0.524    18.486     0.200
     0.549    19.775     0.200
     0.562    18.666     0.200
     0.558    20.217     0.200
     0.575    20.156     0.200
     0.570    18.535     0.200
     0.586    19.775     0.200
     0.641    21.836     0.200
     0.643    21.625     0.200
     0.651    22.396     0.200
     0.656    22.766     0.200
     0.665    21.346     0.200
     0.698    22.785     0.200
     0.692    23.756     0.200
     0.715    24.516     0.200
     0.722    23.896     0.200
     0.762    25.887     0.200
     0.772    25.516     0.200
     0.777    27.297     0.200
     0.788    25.365     0.200
     0.820    27.766     0.200
     0.825    26.625     0.200
     0.033     2.152     0.200
     0.088     5.012     0.200
     0.073     4.543     0.200
     0.124     6.252     0.200
     0.172     8.082     0.200
     0.170     7.951     0.200
     0.191     9.303     0.200
     0.208     9.422     0.200
     0.196     7.652     0.200
     0.307    12.293     0.200
     0.312     9.553     0.200
     0.315    10.992     0.200
     0.341    12.742     0.200
     0.373    14.082     0.200
     0.442    16.822     0.200
     0.446    16.092     0.200
     0.462    16.281     0.200
     0.496    17.432     0.200
     0.500    17.393     0.200
     0.521    18.293     0.200
     0.527    18.543     0.200
     0.549    19.463     0.200
     0.567    18.482     0.200
     0.579    20.252     0.200
     0.573    18.803     0.200
     0.589    20.252     0.200
     0.589    21.021     0.200
     0.596    21.262     0.200
     0.643    22.143     0.200
     0.640    21.701     0.200
     0.654    22.672     0.200
     0.656    22.262     0.200
     0.667    22.242     0.200
     0.702    22.963     0.200
     0.696    24.031     0.200
     0.716    24.502     0.200
     0.721    24.592     0.200
     0.726    24.232     0.200
     0.760    25.832     0.200
     0.775    24.822     0.200
     0.785    25.383     0.200
     0.784    26.871     0.200
     0.819    27.752     0.200
     0.914    29.092     0.200
     0.025     2.604     0.200
     0.064     4.322     0.200
     0.100     4.533     0.200
     0.094     4.854     0.200
     0.147     7.424     0.200
     0.147     7.383     0.200
     0.209     9.893     0.200
     0.207     9.254     0.200
     0.215     9.684     0.200
     0.220     8.023     0.200
     0.299    10.594     0.200
     0.299    10.914     0.200
     0.318    12.312     0.200
     0.347    13.363     0.200
     0.476    17.643     0.200
     0.505    18.072     0.200
     0.482    16.354     0.200
     0.547    18.393     0.200
     0.523    17.863     0.200
     0.555    18.033     0.200
     0.559    18.354     0.200
     0.559    20.584     0.200
     0.545    19.143     0.200
     0.606    20.023     0.200
     0.632    22.354     0.200
     0.646    21.193     0.200
     0.644    21.854     0.200
     0.652    21.723     0.200
     0.652    21.104     0.200
     0.668    23.014     0.200
     0.674    22.514     0.200
     0.661    22.334     0.200
     0.691    22.652     0.200
     0.713    23.674     0.200
     0.701    23.453     0.200
     0.712    24.062     0.200
     0.723    24.562     0.200
     0.755    24.094     0.200
     0.779    26.402     0.200
     0.796    27.723     0.200
     0.806    25.793     0.200
     0.052     3.947     0.200
     0.051     4.428     0.200
     0.094     5.557     0.200
     0.104     5.848     0.200
     0.104     5.848     0.200
     0.098     5.777     0.200
     0.157     7.678     0.200
     0.228     7.646     0.200
     0.228     7.377     0.200
     0.233     8.527     0.200
     0.237    10.047     0.200
     0.237    10.047     0.200
     0.246    10.127     0.200
     0.288    11.496     0.200
     0.272    10.137     0.200
     0.326    12.598     0.200
     0.317    12.406     0.200
     0.318    11.496     0.200
     0.367    12.938     0.200
     0.364    14.268     0.200
     0.362    14.727     0.200
     0.362    14.406     0.200
     0.484    16.018     0.200
     0.497    17.607     0.200
     0.511    17.348     0.200
     0.496    17.777     0.200
     0.518    17.916     0.200
     0.514    18.217     0.200
     0.510    18.217     0.200
     0.536    17.627     0.200
     0.523    19.188     0.200
     0.523    18.467     0.200
     0.547    18.557     0.200
     0.584    18.557     0.200
     0.579    19.896     0.200
     0.577    20.367     0.200
     0.593    19.137     0.200
     0.593    20.268     0.200
     0.607    20.656     0.200
     0.579    18.787     0.200
     0.600    20.617     0.200
     0.620    20.197     0.200
     0.642    21.518     0.200
     0.642    22.438     0.200
     0.635    22.217     0.200
     0.624    21.268     0.200
     0.666    22.857     0.200
     0.666    22.027     0.200
     0.672    22.707     0.200
     0.675    22.637     0.200
     0.696    23.598     0.200
     0.687    22.258     0.200
     0.766    25.207     0.200
     0.775    24.986     0.200
     0.764    24.598     0.200
     0.758    25.107     0.200
     0.774    24.338     0.200
     0.858    27.197     0.200
     0.977    30.277     0.200
     0.988    30.518     0.200
     1.040    31.717     0.200
     1.034    31.678     0.200
     1.391    40.396     0.200
     0.005     3.828     0.200
     0.065     4.426     0.200
     0.135     5.648     0.200
     0.179     7.355     0.200
     0.198     7.285     0.200
     0.218     7.727     0.200
     0.241     8.637     0.200
     0.267     9.285     0.200
     0.279    10.066     0.200
     0.275     9.457     0.200
     0.286     9.809     0.200
     0.282    10.785     0.200
     0.309    11.027     0.200
     0.331    11.559     0.200
     0.334    11.188     0.200
     0.336    12.246     0.200
     0.336    11.695     0.200
     0.342    13.188     0.200
     0.375    12.688     0.200
     0.355    13.336     0.200
     0.401    13.688     0.200
     0.404    13.719     0.200
     0.386    13.797     0.200
     0.390    13.719     0.200
     0.411    13.688     0.200
     0.404    14.328     0.200
     0.430    14.277     0.200
     0.438    14.887     0.200
     0.441    14.648     0.200
     0.444    14.926     0.200
     0.434    14.996     0.200
     0.465    15.559     0.200
     0.453    15.676     0.200
     0.486    15.637     0.200
     0.483    15.598     0.200
     0.476    17.309     0.200
     0.477    15.867     0.200
     0.483    17.066     0.200
     0.499    16.148     0.200
     0.510    16.625     0.200
     0.519    17.457     0.200
     0.533    16.898     0.200
     0.556    18.578     0.200
     0.574    18.125     0.200
     0.560    18.176     0.200
     0.568    18.977     0.200
     0.578    19.246     0.200
     0.607    19.746     0.200
     0.600    19.676     0.200
     0.612    19.418     0.200
     0.606    19.887     0.200
     0.598    19.578     0.200
     0.611    20.527     0.200
     0.609    20.527     0.200
     0.620    20.188     0.200
     0.616    21.266     0.200
     0.647    20.367     0.200
     0.645    21.047     0.200
     0.656    20.605     0.200
     0.652    20.766     0.200
     0.660    20.969     0.200
     0.656    22.758     0.200
     0.654    21.125     0.200
     0.673    21.445     0.200
     0.675    22.125     0.200
     0.682    21.688     0.200
     0.690    23.746     0.200
     0.706    24.777     0.200
     0.716    22.918     0.200
     0.704    22.668     0.200
     0.725    22.676     0.200
     0.729    22.758     0.200
     0.732    23.016     0.200
     0.741    23.098     0.200
     0.738    23.277     0.200
     0.728    23.707     0.200
     0.734    23.398     0.200
     0.751    23.316     0.200
     0.762    23.707     0.200
     0.768    23.785     0.200
     0.768    24.438     0.200
     0.787    24.605     0.200
     0.800    24.816     0.200
     0.802    24.945     0.200
     0.826    25.508     0.200
     0.835    25.969     0.200
     0.846    26.457     0.200
     0.854    26.516     0.200
     0.921    28.125     0.200
     1.280    36.617     0.200
     0.040     3.785     0.200
     0.124     6.445     0.200
     0.174     7.996     0.200
     0.195     8.516     0.200
     0.185     8.746     0.200
     0.193     9.285     0.200
     0.209     8.336     0.200
     0.242     9.336     0.200
     0.249     8.586     0.200
     0.287    12.246     0.200
     0.337    13.227     0.200
     0.322    12.707     0.200
     0.326    11.238     0.200
     0.356    12.707     0.200
     0.368    13.387     0.200
     0.448    16.758     0.200
     0.428    14.035     0.200
     0.439    15.715     0.200
     0.484    16.047     0.200
     0.483    16.496     0.200
     0.497    18.207     0.200
     0.553    18.496     0.200
     0.560    20.195     0.200
     0.603    21.016     0.200
     0.618    19.438     0.200
     0.617    22.258     0.200
     0.641    22.277     0.200
     0.652    20.855     0.200
     0.701    23.906     0.200
     0.709    24.867     0.200
     0.723    24.016     0.200
     0.752    26.047     0.200
     0.782    25.117     0.200
     0.801    26.598     0.200
     0.841    26.727     0.200
     0.835    26.086     0.200
     0.906    28.625     0.200
     0.124     6.457     0.200
     0.098     6.590     0.200
     0.163     8.156     0.200
     0.178     8.090     0.200
     0.154     8.699     0.200
     0.189     8.859     0.200
     0.196     8.789     0.200
     0.192     8.348     0.200
     0.179     9.598     0.200
     0.212     7.527     0.200
     0.240    10.148     0.200
     0.246     8.527     0.200
     0.288    11.406     0.200
     0.324    12.816     0.200
     0.330    11.340     0.200
     0.359    12.840     0.200
     0.367    13.758     0.200
     0.407    13.988     0.200
     0.432    13.969     0.200
     0.442    15.930     0.200
     0.446    17.379     0.200
     0.481    15.898     0.200
     0.486    16.719     0.200
     0.516    18.258     0.200
     0.497    18.090     0.200
     0.562    19.609     0.200
     0.556    18.078     0.200
     0.602    20.566     0.200
     0.615    19.367     0.200
     0.635    21.438     0.200
     0.650    20.578     0.200
     0.642    22.328     0.200
     0.709    24.738     0.200
     0.700    24.047     0.200
     0.726    24.477     0.200
     0.714    23.816     0.200
     0.751    25.637     0.200
     0.753    26.207     0.200
     0.748    23.957     0.200
     0.763    24.020     0.200
     0.786    25.289     0.200
     0.780    25.809     0.200
     0.798    25.500     0.200
     0.837    26.277     0.200
     0.982    30.066     0.200
     1.067    32.367     0.200
     0.035     3.117     0.200
     0.104     6.602     0.200
     0.125     6.641     0.200
     0.169     7.938     0.200
     0.162     8.859     0.200
     0.206     7.641     0.200
     0.199     8.500     0.200
     0.245    10.219     0.200
     0.287    11.789     0.200
     0.320    11.227     0.200
     0.352    12.578     0.200
     0.342    13.328     0.200
     0.371    14.039     0.200
     0.399    13.867     0.200
     0.423    13.633     0.200
     0.434    15.648     0.200
     0.452    16.477     0.200
     0.451    17.180     0.200
     0.478    16.469     0.200
     0.469    16.219     0.200
     0.488    16.297     0.200
     0.498    18.148     0.200
     0.519    18.641     0.200
     0.547    18.570     0.200
     0.559    19.883     0.200
     0.606    21.047     0.200
     0.629    20.539     0.200
     0.623    19.438     0.200
     0.623    20.008     0.200
     0.640    22.172     0.200
     0.655    20.883     0.200
     0.698    24.102     0.200
     0.720    24.180     0.200
     0.739    24.102     0.200
     0.721    24.062     0.200
     0.755    25.109     0.200
     0.762    25.109     0.200
     0.784    26.727     0.200
     0.773    25.367     0.200
     0.795    26.000     0.200
     0.785    25.492     0.200
     0.804    26.062     0.200
     0.832    26.078     0.200
     0.836    26.898     0.200
     0.831    26.883     0.200
     0.849    27.328     0.200
     0.887    28.211     0.200
     0.902    28.711     0.200
     0.936    29.008     0.200
     0.975    30.469     0.200
     0.988    30.938     0.200
     1.013    31.508     0.200
     1.070    32.766     0.200
     0.034     3.148     0.200
     0.105     6.609     0.200
     0.124     6.383     0.200
     0.168     7.867     0.200
     0.163     8.430     0.200
     0.179     8.164     0.200
     0.187     8.688     0.200
     0.186     9.680     0.200
     0.206     7.094     0.200
     0.199     8.500     0.200
     0.246     9.789     0.200
     0.288    11.289     0.200
     0.317    12.438     0.200
     0.351    12.609     0.200
     0.343    13.562     0.200
     0.371    13.789     0.200
     0.398    13.703     0.200
     0.422    13.789     0.200
     0.433    15.672     0.200
     0.452    17.008     0.200
     0.451    16.734     0.200
     0.478    16.531     0.200
     0.470    16.102     0.200
     0.498    18.492     0.200
     0.488    16.094     0.200
     0.547    17.930     0.200
     0.559    20.180     0.200
     0.607    21.422     0.200
     0.640    22.180     0.200
     0.623    19.320     0.200
     0.655    20.594     0.200
     0.699    23.461     0.200
     0.720    23.180     0.200
     0.707    24.867     0.200
     0.723    23.898     0.200
     0.746    25.305     0.200
     0.750    25.719     0.200
     0.785    26.555     0.200
     0.786    25.211     0.200
     0.796    24.570     0.200
     0.805    27.039     0.200
     0.827    26.859     0.200
     0.836    26.750     0.200
     0.902    28.422     0.200
     1.014    31.383     0.200
     1.167    35.383     0.200
     0.106     6.516     0.200
     0.120     6.430     0.200
     0.162     8.711     0.200
     0.156     7.820     0.200
     0.187     9.531     0.200
     0.173     8.047     0.200
     0.181     8.797     0.200
     0.194     8.414     0.200
     0.188     8.945     0.200
     0.211     8.281     0.200
     0.247    10.234     0.200
     0.292    11.375     0.200
     0.316    12.641     0.200
     0.343    13.352     0.200
     0.322    11.156     0.200
     0.357    12.672     0.200
     0.366    13.797     0.200
     0.426    14.172     0.200
     0.454    16.945     0.200
     0.438    15.883     0.200
     0.446    16.781     0.200
     0.471    16.555     0.200
     0.482    15.953     0.200
     0.483    16.711     0.200
     0.502    18.312     0.200
     0.514    18.227     0.200
     0.551    18.461     0.200
     0.564    19.914     0.200
     0.555    18.930     0.200
     0.609    20.992     0.200
     0.618    19.664     0.200
     0.635    21.281     0.200
     0.645    22.273     0.200
     0.650    20.656     0.200
     0.722    23.609     0.200
     0.703    24.742     0.200
     0.725    24.000     0.200
     0.744    24.266     0.200
     0.744    25.625     0.200
     0.760    25.445     0.200
     0.747    26.031     0.200
     0.767    24.086     0.200
     0.774    25.359     0.200
     0.787    25.156     0.200
     0.801    26.055     0.200
     0.829    26.047     0.200
     0.841    26.734     0.200
     0.907    28.383     0.200
     0.042     3.836     0.200
     0.101     6.508     0.200
     0.122     6.352     0.200
     0.178     8.109     0.200
     0.187     8.969     0.200
     0.181     9.438     0.200
     0.191     8.250     0.200
     0.194     8.742     0.200
     0.242    10.047     0.200
     0.249     8.703     0.200
     0.290    12.281     0.200
     0.321    12.727     0.200
     0.337    13.258     0.200
     0.365    13.680     0.200
     0.360    12.797     0.200
     0.432    14.219     0.200
     0.443    15.852     0.200
     0.449    17.258     0.200
     0.479    15.648     0.200
     0.487    16.742     0.200
     0.500    18.148     0.200
     0.559    19.219     0.200
     0.557    18.367     0.200
     0.564    19.898     0.200
     0.605    20.977     0.200
     0.614    19.508     0.200
     0.637    21.133     0.200
     0.648    20.906     0.200
     0.645    22.133     0.200
     0.698    23.477     0.200
     0.715    23.648     0.200
     0.749    25.578     0.200
     0.751    25.930     0.200
     0.749    24.336     0.200
     0.782    25.617     0.200
     0.800    26.039     0.200
     0.803    26.672     0.200
     0.835    26.086     0.200
     0.835    26.617     0.200
     0.910    28.609     0.200
     1.015    31.398     0.200
     0.146     6.340     0.200
     0.189     7.141     0.200
     0.187     7.711     0.200
     0.249     9.680     0.200
     0.252     9.160     0.200
     0.267     9.742     0.200
     0.283    10.941     0.200
     0.291    11.500     0.200
     0.352    13.930     0.200
     0.355    13.020     0.200
     0.349    12.820     0.200
     0.370    12.871     0.200
     0.392    15.402     0.200
     0.388    12.941     0.200
     0.401    15.551     0.200
     0.403    14.289     0.200
     0.390    13.250     0.200
     0.415    15.973     0.200
     0.420    13.871     0.200
     0.432    15.250     0.200
     0.426    14.020     0.200
     0.441    17.109     0.200
     0.445    15.422     0.200
     0.446    14.840     0.200
     0.467    16.223     0.200
     0.479    15.621     0.200
     0.490    15.961     0.200
     0.503    16.359     0.200
     0.525    18.430     0.200
     0.541    17.492     0.200
     0.562    18.062     0.200
     0.577    20.000     0.200
     0.568    18.383     0.200
     0.575    18.242     0.200
     0.606    20.422     0.200
     0.607    19.609     0.200
     0.615    21.902     0.200
     0.654    21.480     0.200
     0.646    20.699     0.200
     0.664    21.020     0.200
     0.668    22.211     0.200
     0.685    22.031     0.200
     0.688    21.883     0.200
     0.692    21.723     0.200
     0.695    21.789     0.200
     0.695    22.078     0.200
     0.695    22.121     0.200
     0.688    21.789     0.200
     0.713    22.402     0.200
     0.724    22.492     0.200
     0.730    23.699     0.200
     0.741    23.902     0.200
     0.757    24.859     0.200
     0.751    24.812     0.200
     0.773    24.422     0.200
     0.777    24.242     0.200
     0.791    24.922     0.200
     0.845    26.133     0.200
     0.863    26.230     0.200
     0.289    10.888     0.200
     0.307    10.368     0.200
     0.335    12.188     0.200
     0.326    11.167     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
