#!/bin/bash
gmt begin salton5.43_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source salton5.43'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.7 -10.0
  0.7 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.285    -0.101     0.200
     0.343    -0.618     0.200
     0.343    -0.296     0.200
     0.517    -0.266     0.200
     0.806    -0.429     0.200
     0.878     0.166     0.200
     0.883     0.526     0.200
     0.890     0.757     0.200
     0.218    -0.381     0.200
     0.331    -0.443     0.200
     0.663     0.015     0.200
     0.711    -0.029     0.200
     0.866     0.349     0.200
     0.928     0.433     0.200
     0.982    -0.325     0.200
     0.964     0.650     0.200
     0.239    -0.153     0.200
     0.277    -0.353     0.200
     0.386     0.142     0.200
     0.458    -0.249     0.200
     0.374     0.056     0.200
     0.454    -0.268     0.200
     0.479    -0.334     0.200
     0.509    -0.278     0.200
     0.543    -0.286     0.200
     0.598    -0.040     0.200
     0.598    -0.211     0.200
     0.692     0.120     0.200
     0.743     0.072     0.200
     0.670    -0.035     0.200
     0.670    -0.154     0.200
     0.694     0.132     0.200
     0.904     0.425     0.200
     0.945     0.370     0.200
     0.167    -0.391     0.200
     0.551    -0.381     0.200
     0.635     0.008     0.200
     0.674    -0.151     0.200
     0.743    -0.116     0.200
     0.783    -0.073     0.200
     0.775    -0.067     0.200
     0.865     0.037     0.200
     0.902     0.510     0.200
     0.167    -0.176     0.200
     0.167    -0.535     0.200
     0.551    -0.544     0.200
     0.673    -0.072     0.200
     0.740     0.021     0.200
     0.639    -0.061     0.200
     0.783    -0.246     0.200
     0.778     0.067     0.200
     0.904     0.463     0.200
     0.292    -0.085     0.200
     0.356    -0.424     0.200
     0.645    -0.364     0.200
     0.714     0.179     0.200
     0.837    -0.082     0.200
     0.759     0.057     0.200
     0.876     0.216     0.200
     0.987     0.158     0.200
     0.289     0.179     0.200
     0.362    -0.434     0.200
     0.639    -0.043     0.200
     0.712     0.191     0.200
     0.763     0.208     0.200
     0.833    -0.546     0.200
     0.883     0.190     0.200
     0.987     0.019     0.200
     0.120    -0.470     0.200
     0.382    -0.397     0.200
     0.393     0.090     0.200
     0.411    -0.367     0.200
     0.475    -0.184     0.200
     0.532    -0.088     0.200
     0.675    -0.375     0.200
     0.658     0.191     0.200
     0.711     0.256     0.200
     0.727     0.011     0.200
     0.738    -0.386     0.200
     0.704     0.616     0.200
     0.772    -0.176     0.200
     0.821    -0.258     0.200
     0.821    -0.727     0.200
     0.980    -0.428     0.200
     0.971     0.501     0.200
     0.353     0.055     0.200
     0.446     0.087     0.200
     0.432    -0.120     0.200
     0.420    -0.476     0.200
     0.450     0.004     0.200
     0.504     0.027     0.200
     0.645    -0.327     0.200
     0.664    -0.636     0.200
     0.719    -0.520     0.200
     0.703     0.025     0.200
     0.698     0.301     0.200
     0.677    -0.038     0.200
     0.747    -0.145     0.200
     0.806    -0.476     0.200
     0.806    -0.946     0.200
     0.734     0.387     0.200
     0.951    -0.021     0.200
     0.993     0.130     0.200
     0.994    -0.022     0.200
     0.286    -0.278     0.200
     0.349    -0.173     0.200
     0.350    -0.465     0.200
     0.369    -0.927     0.200
     0.371     0.023     0.200
     0.486    -0.153     0.200
     0.489    -0.118     0.200
     0.531    -0.269     0.200
     0.594    -0.477     0.200
     0.594    -0.207     0.200
     0.613    -0.139     0.200
     0.648     0.003     0.200
     0.661     0.032     0.200
     0.707    -0.120     0.200
     0.726     0.201     0.200
     0.841     0.103     0.200
     0.921     0.230     0.200
     0.946     0.296     0.200
     0.291    -0.601     0.200
     0.433    -0.347     0.200
     0.666     0.287     0.200
     0.769    -0.669     0.200
     0.114    -0.287     0.200
     0.114    -0.491     0.200
     0.348    -0.438     0.200
     0.475    -0.558     0.200
     0.408    -0.174     0.200
     0.419    -0.264     0.200
     0.507    -0.407     0.200
     0.487    -0.083     0.200
     0.503    -0.034     0.200
     0.621    -0.403     0.200
     0.621    -0.200     0.200
     0.633    -0.094     0.200
     0.726     0.123     0.200
     0.923     0.607     0.200
     0.110    -0.369     0.200
     0.111    -0.710     0.200
     0.343    -0.425     0.200
     0.406    -0.187     0.200
     0.421    -0.274     0.200
     0.472    -0.544     0.200
     0.500    -0.290     0.200
     0.490    -0.058     0.200
     0.549     0.291     0.200
     0.506    -0.002     0.200
     0.544    -0.050     0.200
     0.627    -0.316     0.200
     0.627    -0.421     0.200
     0.636    -0.288     0.200
     0.721     0.244     0.200
     0.929     0.610     0.200
     0.219    -0.589     0.200
     0.219    -0.756     0.200
     0.501    -0.710     0.200
     0.685    -0.201     0.200
     0.682     0.174     0.200
     0.698    -0.006     0.200
     0.744    -0.308     0.200
     0.766    -0.215     0.200
     0.780     0.154     0.200
     0.846     0.029     0.200
     0.167     0.051     0.200
     0.162     0.173     0.200
     0.183     0.170     0.200
     0.192    -0.363     0.200
     0.192    -0.621     0.200
     0.247     0.134     0.200
     0.314     0.383     0.200
     0.485    -0.054     0.200
     0.482    -0.319     0.200
     0.493    -0.050     0.200
     0.532    -0.624     0.200
     0.511    -0.097     0.200
     0.517    -0.204     0.200
     0.554    -0.126     0.200
     0.560    -0.538     0.200
     0.564    -0.118     0.200
     0.549    -0.117     0.200
     0.606    -0.067     0.200
     0.580    -0.140     0.200
     0.611    -0.262     0.200
     0.693    -0.098     0.200
     0.737     0.010     0.200
     0.737    -0.029     0.200
     0.718    -0.587     0.200
     0.711    -0.232     0.200
     0.755    -0.370     0.200
     0.755    -0.159     0.200
     0.753    -0.454     0.200
     0.753     0.015     0.200
     0.771     0.041     0.200
     0.780    -0.288     0.200
     0.777    -0.109     0.200
     0.831     0.029     0.200
     0.859     0.646     0.200
     0.847     0.147     0.200
     0.890    -0.047     0.200
     0.901    -0.301     0.200
     0.922     0.119     0.200
     0.909     0.416     0.200
     0.909     0.033     0.200
     0.928     0.131     0.200
     0.973     0.443     0.200
     0.991     0.125     0.200
     0.152     0.325     0.200
     0.272    -0.587     0.200
     0.272    -0.266     0.200
     0.276    -0.116     0.200
     0.339    -0.327     0.200
     0.383    -0.172     0.200
     0.394     0.262     0.200
     0.386     0.255     0.200
     0.449    -0.393     0.200
     0.460     0.229     0.200
     0.507    -0.365     0.200
     0.517    -0.303     0.200
     0.563    -0.365     0.200
     0.593    -0.258     0.200
     0.593    -0.446     0.200
     0.669     0.047     0.200
     0.745    -0.076     0.200
     0.836     0.216     0.200
     0.903     0.114     0.200
     0.944    -0.619     0.200
     0.971     0.229     0.200
     0.987    -0.361     0.200
     0.122     0.369     0.200
     0.350     0.039     0.200
     0.372     0.098     0.200
     0.372    -0.066     0.200
     0.376    -0.226     0.200
     0.376    -0.508     0.200
     0.432     0.181     0.200
     0.448    -0.123     0.200
     0.504    -0.214     0.200
     0.457    -0.144     0.200
     0.487    -0.106     0.200
     0.509    -0.176     0.200
     0.480     0.120     0.200
     0.542    -0.011     0.200
     0.554     0.133     0.200
     0.578    -0.063     0.200
     0.728    -0.194     0.200
     0.621    -0.105     0.200
     0.730    -0.120     0.200
     0.719    -0.369     0.200
     0.722    -0.081     0.200
     0.735    -0.263     0.200
     0.772    -0.016     0.200
     0.892    -0.609     0.200
     0.844     0.074     0.200
     0.928     0.230     0.200
     0.105     0.105     0.200
     0.219    -0.213     0.200
     0.234     0.275     0.200
     0.255     0.123     0.200
     0.292    -0.325     0.200
     0.314     0.026     0.200
     0.372    -0.100     0.200
     0.413    -0.473     0.200
     0.412    -0.344     0.200
     0.494    -0.309     0.200
     0.574    -0.234     0.200
     0.583     0.121     0.200
     0.614    -0.414     0.200
     0.620    -0.171     0.200
     0.620    -0.499     0.200
     0.620     0.383     0.200
     0.659    -0.354     0.200
     0.704     0.081     0.200
     0.735     0.319     0.200
     0.998    -0.156     0.200
     0.319    -0.535     0.200
     0.330    -0.911     0.200
     0.330    -0.575     0.200
     0.554    -0.304     0.200
     0.755    -0.227     0.200
     0.850    -0.215     0.200
     0.148     0.087     0.200
     0.273    -0.428     0.200
     0.397    -0.118     0.200
     0.437    -0.281     0.200
     0.488    -0.277     0.200
     0.446     0.060     0.200
     0.550     0.146     0.200
     0.462    -0.079     0.200
     0.541    -0.202     0.200
     0.613    -0.785     0.200
     0.595    -0.208     0.200
     0.676    -0.159     0.200
     0.754     0.046     0.200
     0.966    -0.287     0.200
     0.945     0.295     0.200
     0.118    -0.037     0.200
     0.154     0.214     0.200
     0.173     0.411     0.200
     0.213     0.357     0.200
     0.212    -0.016     0.200
     0.233     0.134     0.200
     0.207     0.480     0.200
     0.364    -0.240     0.200
     0.473    -0.293     0.200
     0.512    -0.354     0.200
     0.551    -0.147     0.200
     0.554    -0.332     0.200
     0.603     0.652     0.200
     0.603     0.121     0.200
     0.578     0.435     0.200
     0.617    -0.598     0.200
     0.737    -0.203     0.200
     0.723     0.126     0.200
     0.776     0.029     0.200
     0.789     0.024     0.200
     0.809     0.285     0.200
     0.980    -0.182     0.200
     0.196    -0.326     0.200
     0.297     0.033     0.200
     0.265    -0.417     0.200
     0.349    -0.505     0.200
     0.350    -0.495     0.200
     0.457    -0.136     0.200
     0.359     0.573     0.200
     0.475     0.037     0.200
     0.489    -0.239     0.200
     0.517    -0.340     0.200
     0.619     0.009     0.200
     0.564    -0.358     0.200
     0.626    -0.236     0.200
     0.688     0.551     0.200
     0.720    -0.387     0.200
     0.788     0.733     0.200
     0.739    -0.275     0.200
     0.773    -0.184     0.200
     0.753    -0.383     0.200
     0.753     0.914     0.200
     0.956    -0.504     0.200
     0.956     0.016     0.200
     0.902    -0.124     0.200
     0.957     0.058     0.200
     0.979    -0.256     0.200
     0.986     0.181     0.200
     0.983     0.270     0.200
     0.208    -0.686     0.200
     0.292     0.085     0.200
     0.337    -0.814     0.200
     0.338    -0.298     0.200
     0.338    -0.874     0.200
     0.359     0.148     0.200
     0.456    -0.172     0.200
     0.466     0.175     0.200
     0.475    -0.135     0.200
     0.478    -0.050     0.200
     0.505    -0.160     0.200
     0.554    -0.227     0.200
     0.611     0.233     0.200
     0.618    -0.029     0.200
     0.619    -0.145     0.200
     0.686    -0.200     0.200
     0.714    -0.343     0.200
     0.732    -0.376     0.200
     0.757    -0.685     0.200
     0.757     0.969     0.200
     0.761    -0.168     0.200
     0.822     0.362     0.200
     0.895    -0.232     0.200
     0.943     0.008     0.200
     0.944    -0.500     0.200
     0.944    -0.066     0.200
     0.966    -0.090     0.200
     0.973     0.254     0.200
     0.995    -0.230     0.200
     0.293    -0.456     0.200
     0.294    -0.735     0.200
     0.294    -0.442     0.200
     0.376     0.307     0.200
     0.426    -0.255     0.200
     0.440    -0.158     0.200
     0.500     0.192     0.200
     0.535     0.631     0.200
     0.543    -0.207     0.200
     0.546    -0.198     0.200
     0.570    -0.009     0.200
     0.560    -0.169     0.200
     0.636    -0.080     0.200
     0.636     0.111     0.200
     0.673    -0.153     0.200
     0.673    -0.004     0.200
     0.714    -0.156     0.200
     0.714     0.141     0.200
     0.721    -0.119     0.200
     0.721    -0.068     0.200
     0.711     0.114     0.200
     0.732    -0.009     0.200
     0.768    -0.419     0.200
     0.765     0.296     0.200
     0.763    -0.276     0.200
     0.910     0.005     0.200
     0.202    -0.081     0.200
     0.217     0.248     0.200
     0.249     0.011     0.200
     0.477    -0.233     0.200
     0.584     0.085     0.200
     0.597     0.198     0.200
     0.634    -0.194     0.200
     0.633    -0.413     0.200
     0.652    -1.643     0.200
     0.721     0.222     0.200
     0.938    -0.070     0.200
     0.213    -0.114     0.200
     0.213    -0.247     0.200
     0.242     0.159     0.200
     0.294     0.346     0.200
     0.301     0.107     0.200
     0.367    -0.100     0.200
     0.400    -0.399     0.200
     0.406    -0.430     0.200
     0.483    -0.358     0.200
     0.592    -0.133     0.200
     0.605     0.260     0.200
     0.634     0.132     0.200
     0.621    -0.607     0.200
     0.646    -1.261     0.200
     0.733    -0.141     0.200
     0.942     0.336     0.200
     0.946     0.224     0.200
     0.949     0.159     0.200
     0.949    -0.395     0.200
     0.986    -0.265     0.200
     0.994    -0.047     0.200
     0.994     0.257     0.200
     0.215    -0.176     0.200
     0.227     0.236     0.200
     0.247     0.112     0.200
     0.298     0.272     0.200
     0.305     0.072     0.200
     0.404    -0.447     0.200
     0.487    -0.236     0.200
     0.595    -0.015     0.200
     0.608     0.193     0.200
     0.621    -0.378     0.200
     0.629     0.423     0.200
     0.650    -1.320     0.200
     0.695    -0.010     0.200
     0.733     0.263     0.200
     0.938     0.783     0.200
     0.943     0.038     0.200
     0.946    -0.214     0.200
     0.946    -0.112     0.200
     0.211    -0.196     0.200
     0.246     0.156     0.200
     0.223     0.260     0.200
     0.296     0.260     0.200
     0.302     0.030     0.200
     0.411    -0.398     0.200
     0.401    -0.483     0.200
     0.483    -0.407     0.200
     0.624    -0.293     0.200
     0.631     0.327     0.200
     0.591     0.022     0.200
     0.604     0.236     0.200
     0.650    -1.036     0.200
     0.729     0.143     0.200
     0.944    -0.150     0.200
     0.981    -0.043     0.200
     0.991     0.241     0.200
     0.209     0.236     0.200
     0.233     0.118     0.200
     0.202    -0.440     0.200
     0.279     0.289     0.200
     0.286     0.335     0.200
     0.356     0.023     0.200
     0.385    -0.443     0.200
     0.469    -0.597     0.200
     0.579    -0.357     0.200
     0.591    -0.175     0.200
     0.636     0.579     0.200
     0.628    -0.830     0.200
     0.724     0.153     0.200
     0.165     0.187     0.200
     0.158    -0.200     0.200
     0.231     0.205     0.200
     0.215     0.445     0.200
     0.245     0.298     0.200
     0.246     0.057     0.200
     0.311     0.026     0.200
     0.348    -0.395     0.200
     0.434    -0.453     0.200
     0.424    -0.344     0.200
     0.533    -0.129     0.200
     0.545     0.014     0.200
     0.626    -1.243     0.200
     0.668    -0.583     0.200
     0.678    -0.128     0.200
     0.681     0.027     0.200
     0.683     0.235     0.200
     0.941    -0.341     0.200
     0.212    -0.129     0.200
     0.226     0.218     0.200
     0.249     0.060     0.200
     0.305    -0.006     0.200
     0.486    -0.314     0.200
     0.594     0.129     0.200
     0.624    -0.668     0.200
     0.607     0.263     0.200
     0.628     0.090     0.200
     0.653    -1.265     0.200
     0.698    -0.045     0.200
     0.698    -0.256     0.200
     0.731     0.093     0.200
     0.942    -0.147     0.200
     0.980     0.053     0.200
     0.992     0.270     0.200
     0.233    -0.079     0.200
     0.249     0.309     0.200
     0.261     0.090     0.200
     0.321     0.347     0.200
     0.386    -0.147     0.200
     0.408    -0.388     0.200
     0.426    -0.423     0.200
     0.509    -0.342     0.200
     0.610    -0.438     0.200
     0.608     0.293     0.200
     0.616    -0.067     0.200
     0.629     0.059     0.200
     0.666    -1.086     0.200
     0.709    -0.220     0.200
     0.709    -0.790     0.200
     0.748     0.155     0.200
     0.934     0.286     0.200
     0.942    -0.093     0.200
     0.984    -0.025     0.200
     0.163     0.139     0.200
     0.215     0.304     0.200
     0.168    -0.424     0.200
     0.237     0.331     0.200
     0.241     0.010     0.200
     0.341    -0.371     0.200
     0.320    -0.263     0.200
     0.419    -0.388     0.200
     0.424    -0.260     0.200
     0.536     0.041     0.200
     0.546     0.078     0.200
     0.611    -1.061     0.200
     0.662     0.112     0.200
     0.657    -0.610     0.200
     0.694     0.130     0.200
     0.689    -0.337     0.200
     0.947     0.111     0.200
     0.950     1.707     0.200
     0.954    -0.095     0.200
     0.957    -0.448     0.200
     0.984    -0.319     0.200
     0.240     0.330     0.200
     0.228    -0.093     0.200
     0.250     0.159     0.200
     0.310     0.343     0.200
     0.382    -0.067     0.200
     0.402    -0.427     0.200
     0.500    -0.291     0.200
     0.609    -0.077     0.200
     0.621     0.203     0.200
     0.655    -1.613     0.200
     0.610    -0.562     0.200
     0.619     0.140     0.200
     0.698    -0.200     0.200
     0.698    -0.450     0.200
     0.950    -0.189     0.200
     0.234    -0.181     0.200
     0.243     0.200     0.200
     0.247     0.076     0.200
     0.311     0.257     0.200
     0.320     0.010     0.200
     0.503    -0.193     0.200
     0.613     0.093     0.200
     0.620     0.172     0.200
     0.625     0.147     0.200
     0.603    -0.331     0.200
     0.651    -1.417     0.200
     0.752     0.151     0.200
     0.694    -0.285     0.200
     0.948     0.503     0.200
     0.952    -0.136     0.200
     0.955     0.024     0.200
     0.996     0.044     0.200
     0.194    -0.196     0.200
     0.205     0.246     0.200
     0.241     0.174     0.200
     0.285     0.014     0.200
     0.308    -0.464     0.200
     0.347    -0.135     0.200
     0.418    -0.409     0.200
     0.465    -0.319     0.200
     0.573    -0.052     0.200
     0.586     0.171     0.200
     0.643    -1.233     0.200
     0.638    -0.361     0.200
     0.646     0.255     0.200
     0.714     0.354     0.200
     0.942    -0.243     0.200
     0.189    -0.103     0.200
     0.205     0.164     0.200
     0.249     0.095     0.200
     0.314    -0.478     0.200
     0.343    -0.067     0.200
     0.465    -0.505     0.200
     0.571    -0.168     0.200
     0.584     0.256     0.200
     0.645    -0.539     0.200
     0.642     0.260     0.200
     0.708     0.245     0.200
     0.930    -0.180     0.200
     0.933    -0.249     0.200
     0.153    -0.477     0.200
     0.409    -0.525     0.200
     0.444    -0.510     0.200
     0.463     0.606     0.200
     0.449    -0.201     0.200
     0.459    -0.271     0.200
     0.500    -0.375     0.200
     0.528     0.204     0.200
     0.529     0.037     0.200
     0.560     0.216     0.200
     0.602    -0.248     0.200
     0.602    -0.103     0.200
     0.594    -0.090     0.200
     0.656    -0.088     0.200
     0.672    -0.005     0.200
     0.672     0.033     0.200
     0.761     0.192     0.200
     0.761     0.012     0.200
     0.933     0.659     0.200
     0.964    -0.264     0.200
     0.469    -0.224     0.200
     0.471    -0.268     0.200
     0.515    -0.133     0.200
     0.761    -0.420     0.200
     0.847     0.282     0.200
     0.959    -0.580     0.200
     0.935     0.090     0.200
     0.975     0.346     0.200
     0.178     0.033     0.200
     0.262    -0.414     0.200
     0.384    -0.472     0.200
     0.366    -0.283     0.200
     0.420     0.687     0.200
     0.445    -0.445     0.200
     0.498    -0.018     0.200
     0.475    -0.140     0.200
     0.510    -0.165     0.200
     0.557     0.245     0.200
     0.563    -0.283     0.200
     0.635    -0.293     0.200
     0.637    -0.360     0.200
     0.637    -0.091     0.200
     0.666    -0.112     0.200
     0.725     0.037     0.200
     0.725    -0.041     0.200
     0.766     0.125     0.200
     0.936    -0.213     0.200
     0.986     0.420     0.200
     0.993     0.530     0.200
     0.091    -1.115     0.200
     0.091    -0.974     0.200
     0.095    -0.952     0.200
     0.096    -0.940     0.200
     0.624    -0.283     0.200
     0.612    -0.053     0.200
     0.623    -0.032     0.200
     0.699    -0.348     0.200
     0.799    -0.151     0.200
     0.822     0.032     0.200
     0.822     0.016     0.200
     0.851    -0.305     0.200
     0.851    -0.133     0.200
     0.859     0.097     0.200
     0.874    -0.225     0.200
     0.834     0.597     0.200
     0.911     0.020     0.200
     0.915     0.190     0.200
     0.111    -0.782     0.200
     0.111    -0.477     0.200
     0.607    -0.215     0.200
     0.623     0.086     0.200
     0.630    -0.156     0.200
     0.782     0.032     0.200
     0.815    -0.016     0.200
     0.837    -0.265     0.200
     0.852     0.582     0.200
     0.187    -0.212     0.200
     0.218     0.730     0.200
     0.323    -0.273     0.200
     0.318     0.498     0.200
     0.451    -0.355     0.200
     0.458    -0.100     0.200
     0.514     0.210     0.200
     0.663    -1.101     0.200
     0.633    -0.379     0.200
     0.714    -0.212     0.200
     0.769    -0.132     0.200
     0.825    -0.383     0.200
     0.825    -0.045     0.200
     0.851     0.132     0.200
     0.341    -0.902     0.200
     0.442    -0.526     0.200
     0.703    -0.706     0.200
     0.692     0.325     0.200
     0.684     0.773     0.200
     0.747     0.516     0.200
     0.987    -0.130     0.200
     0.323    -0.156     0.200
     0.463     0.205     0.200
     0.447     0.042     0.200
     0.485     0.093     0.200
     0.443    -0.136     0.200
     0.495     0.364     0.200
     0.575    -0.233     0.200
     0.593    -0.455     0.200
     0.636    -0.224     0.200
     0.709    -0.695     0.200
     0.709    -0.476     0.200
     0.708    -0.049     0.200
     0.734     0.459     0.200
     0.742     0.022     0.200
     0.778    -0.120     0.200
     0.778     0.075     0.200
     0.868    -2.093     0.200
     0.815     0.414     0.200
     0.265    -0.243     0.200
     0.265    -0.405     0.200
     0.460    -0.270     0.200
     0.641    -0.144     0.200
     0.711    -0.168     0.200
     0.739     0.250     0.200
     0.717     0.185     0.200
     0.757    -0.154     0.200
     0.724     0.368     0.200
     0.839     0.137     0.200
     0.947     0.012     0.200
     0.096    -0.149     0.200
     0.127    -0.261     0.200
     0.118     0.012     0.200
     0.196    -0.111     0.200
     0.268    -0.297     0.200
     0.268     0.024     0.200
     0.292    -0.695     0.200
     0.254     0.163     0.200
     0.315    -0.381     0.200
     0.309     0.041     0.200
     0.317     0.060     0.200
     0.331     0.200     0.200
     0.331    -0.001     0.200
     0.363    -0.100     0.200
     0.378    -0.256     0.200
     0.399    -0.248     0.200
     0.409    -0.171     0.200
     0.372     0.250     0.200
     0.376    -0.052     0.200
     0.400     0.183     0.200
     0.390     0.484     0.200
     0.399     0.501     0.200
     0.443    -0.140     0.200
     0.460    -0.039     0.200
     0.478    -0.779     0.200
     0.478    -0.509     0.200
     0.481    -0.554     0.200
     0.453     0.096     0.200
     0.461    -0.223     0.200
     0.461    -0.018     0.200
     0.499    -0.094     0.200
     0.485     0.242     0.200
     0.529    -0.402     0.200
     0.520     0.181     0.200
     0.562    -0.007     0.200
     0.558     0.092     0.200
     0.583     0.429     0.200
     0.588     0.308     0.200
     0.611     0.638     0.200
     0.665     0.273     0.200
     0.680    -0.044     0.200
     0.714     0.391     0.200
     0.716     0.006     0.200
     0.708     0.196     0.200
     0.715     0.431     0.200
     0.776    -0.260     0.200
     0.804    -0.149     0.200
     0.156    -0.119     0.200
     0.190     0.522     0.200
     0.210    -0.204     0.200
     0.291    -0.279     0.200
     0.294    -0.055     0.200
     0.323     0.381     0.200
     0.354     0.161     0.200
     0.362    -0.054     0.200
     0.411     0.305     0.200
     0.426    -0.183     0.200
     0.443     0.184     0.200
     0.481    -0.204     0.200
     0.515    -0.032     0.200
     0.527    -0.275     0.200
     0.530     0.071     0.200
     0.536     0.072     0.200
     0.549    -0.480     0.200
     0.558     0.081     0.200
     0.579    -0.602     0.200
     0.577     0.390     0.200
     0.601    -0.457     0.200
     0.676    -0.593     0.200
     0.677     0.037     0.200
     0.682    -0.262     0.200
     0.682    -0.160     0.200
     0.696    -0.249     0.200
     0.705     0.113     0.200
     0.741    -0.098     0.200
     0.783    -0.193     0.200
     0.815    -0.236     0.200
     0.818     0.021     0.200
     0.821     0.020     0.200
     0.868     0.153     0.200
     0.866     0.150     0.200
     0.880     0.220     0.200
     0.909     0.279     0.200
     0.928     0.555     0.200
     0.930     0.146     0.200
     0.981     0.076     0.200
     0.996    -0.479     0.200
     0.998    -0.268     0.200
     0.074    -0.280     0.200
     0.174    -0.409     0.200
     0.279     0.196     0.200
     0.287     0.173     0.200
     0.313    -0.103     0.200
     0.397    -0.035     0.200
     0.404    -0.255     0.200
     0.451    -0.113     0.200
     0.454     0.171     0.200
     0.477    -0.373     0.200
     0.479    -0.619     0.200
     0.479    -0.335     0.200
     0.555     0.084     0.200
     0.596    -0.366     0.200
     0.622     0.073     0.200
     0.615    -0.186     0.200
     0.618    -0.145     0.200
     0.646    -0.209     0.200
     0.652     0.071     0.200
     0.688    -0.167     0.200
     0.693    -0.237     0.200
     0.736    -0.069     0.200
     0.770    -0.326     0.200
     0.761    -0.005     0.200
     0.782    -0.166     0.200
     0.789     0.003     0.200
     0.808    -0.084     0.200
     0.832     0.455     0.200
     0.840    -0.159     0.200
     0.862    -0.046     0.200
     0.869     0.189     0.200
     0.886     0.072     0.200
     0.904    -0.215     0.200
     0.894     0.101     0.200
     0.899    -0.042     0.200
     0.903     0.077     0.200
     0.903    -0.024     0.200
     0.902     0.057     0.200
     0.929    -0.088     0.200
     0.940     0.062     0.200
     0.085    -0.655     0.200
     0.186    -0.559     0.200
     0.267     0.116     0.200
     0.277     0.024     0.200
     0.331    -0.266     0.200
     0.391    -0.238     0.200
     0.395    -0.273     0.200
     0.453     0.254     0.200
     0.459    -0.094     0.200
     0.468    -0.386     0.200
     0.468    -0.858     0.200
     0.469    -0.054     0.200
     0.469    -0.390     0.200
     0.469    -0.570     0.200
     0.551    -0.059     0.200
     0.589    -0.295     0.200
     0.606    -0.209     0.200
     0.610     0.045     0.200
     0.613    -0.055     0.200
     0.636    -0.260     0.200
     0.640     0.306     0.200
     0.679    -0.208     0.200
     0.685    -0.269     0.200
     0.725    -0.202     0.200
     0.749    -0.021     0.200
     0.775    -0.461     0.200
     0.776    -0.243     0.200
     0.787     0.122     0.200
     0.811    -0.006     0.200
     0.821     0.534     0.200
     0.835    -0.122     0.200
     0.856    -0.050     0.200
     0.872     0.128     0.200
     0.883     0.064     0.200
     0.897    -0.033     0.200
     0.893     0.090     0.200
     0.893     0.068     0.200
     0.902     0.168     0.200
     0.916    -0.311     0.200
     0.916    -0.468     0.200
     0.941    -0.007     0.200
     0.938     0.103     0.200
     0.992    -0.222     0.200
     0.992    -0.355     0.200
     0.252    -0.461     0.200
     0.236    -0.352     0.200
     0.384    -0.268     0.200
     0.518    -0.442     0.200
     0.504     0.151     0.200
     0.564    -0.330     0.200
     0.561     0.621     0.200
     0.516    -0.090     0.200
     0.516    -0.288     0.200
     0.568     0.120     0.200
     0.542     0.047     0.200
     0.542     0.170     0.200
     0.563     0.099     0.200
     0.600    -0.446     0.200
     0.641    -0.130     0.200
     0.641    -0.327     0.200
     0.665     0.179     0.200
     0.648     0.111     0.200
     0.701     0.100     0.200
     0.705    -0.285     0.200
     0.703    -0.407     0.200
     0.802    -0.627     0.200
     0.773    -0.169     0.200
     0.804     0.080     0.200
     0.807     0.109     0.200
     0.807    -0.076     0.200
     0.834     0.096     0.200
     0.859     0.245     0.200
     0.890     0.310     0.200
     0.881     0.193     0.200
     0.908     0.196     0.200
     0.910     0.331     0.200
     0.984     0.161     0.200
     0.999     0.199     0.200
     0.990     0.021     0.200
     0.990    -0.107     0.200
     0.997    -0.143     0.200
     0.108    -0.447     0.200
     0.311    -0.252     0.200
     0.265    -0.449     0.200
     0.265    -0.762     0.200
     0.387    -0.232     0.200
     0.629    -0.070     0.200
     0.668     0.641     0.200
     0.615    -0.611     0.200
     0.828    -0.018     0.200
     0.836    -0.014     0.200
     0.296    -0.154     0.200
     0.351    -0.522     0.200
     0.356    -0.030     0.200
     0.442    -0.501     0.200
     0.509    -0.627     0.200
     0.509    -0.424     0.200
     0.517    -0.620     0.200
     0.687     0.184     0.200
     0.749     0.144     0.200
     0.137     0.061     0.200
     0.161    -0.649     0.200
     0.174     0.124     0.200
     0.166    -0.187     0.200
     0.167    -0.047     0.200
     0.167    -0.302     0.200
     0.167    -0.160     0.200
     0.188     0.122     0.200
     0.195     0.178     0.200
     0.296    -0.200     0.200
     0.269     0.028     0.200
     0.300    -0.222     0.200
     0.292    -0.257     0.200
     0.357    -0.050     0.200
     0.421    -0.114     0.200
     0.437    -0.025     0.200
     0.464    -0.123     0.200
     0.496     0.040     0.200
     0.511    -0.115     0.200
     0.502     0.154     0.200
     0.522    -0.142     0.200
     0.551    -0.305     0.200
     0.533    -0.058     0.200
     0.535    -0.042     0.200
     0.607    -0.260     0.200
     0.618     0.542     0.200
     0.644    -0.241     0.200
     0.625     0.163     0.200
     0.642     0.084     0.200
     0.642    -0.017     0.200
     0.650     0.420     0.200
     0.686     0.193     0.200
     0.679    -0.132     0.200
     0.670     0.152     0.200
     0.727     0.254     0.200
     0.716    -0.147     0.200
     0.715    -0.079     0.200
     0.738    -0.249     0.200
     0.739     0.096     0.200
     0.785     0.031     0.200
     0.785    -0.090     0.200
     0.781     0.059     0.200
     0.781    -0.011     0.200
     0.819    -0.076     0.200
     0.842     0.225     0.200
     0.832    -0.047     0.200
     0.807     0.716     0.200
     0.841     0.197     0.200
     0.845     0.249     0.200
     0.883     0.243     0.200
     0.883    -0.078     0.200
     0.858     0.452     0.200
     0.858    -0.122     0.200
     0.909    -0.299     0.200
     0.910    -0.325     0.200
     0.927    -0.024     0.200
     0.902     0.275     0.200
     0.905     0.752     0.200
     0.946     0.279     0.200
     0.954     0.801     0.200
     0.061    -0.196     0.200
     0.175     0.161     0.200
     0.207     0.250     0.200
     0.184    -0.161     0.200
     0.203    -0.136     0.200
     0.250     0.011     0.200
     0.364     0.204     0.200
     0.364     0.321     0.200
     0.404    -0.283     0.200
     0.435    -0.261     0.200
     0.435    -0.491     0.200
     0.555     0.271     0.200
     0.557    -0.147     0.200
     0.550     0.054     0.200
     0.559     0.019     0.200
     0.606    -0.429     0.200
     0.602     0.317     0.200
     0.640    -0.308     0.200
     0.655     0.023     0.200
     0.685     0.357     0.200
     0.710     0.261     0.200
     0.858     0.136     0.200
     0.904    -0.205     0.200
     0.920     0.167     0.200
     0.972    -0.871     0.200
     0.973    -0.128     0.200
     0.954     0.142     0.200
     0.954     0.314     0.200
     0.963     0.107     0.200
     0.968    -0.258     0.200
     0.112     0.537     0.200
     0.151     0.138     0.200
     0.212    -0.448     0.200
     0.212     0.083     0.200
     0.230     0.086     0.200
     0.234     0.112     0.200
     0.273     0.209     0.200
     0.295    -0.186     0.200
     0.310     0.037     0.200
     0.357    -0.413     0.200
     0.364    -0.582     0.200
     0.423    -0.227     0.200
     0.423    -0.290     0.200
     0.501     0.332     0.200
     0.551    -0.210     0.200
     0.551    -0.351     0.200
     0.549    -0.392     0.200
     0.549     0.182     0.200
     0.554    -0.188     0.200
     0.554    -0.516     0.200
     0.568     0.684     0.200
     0.617    -1.802     0.200
     0.618    -0.103     0.200
     0.618    -0.673     0.200
     0.648     0.295     0.200
     0.741     0.117     0.200
     0.736    -0.323     0.200
     0.728     0.077     0.200
     0.852    -0.072     0.200
     0.924    -0.652     0.200
     0.028    -0.169     0.200
     0.164     0.320     0.200
     0.178    -0.103     0.200
     0.181    -0.215     0.200
     0.185     0.050     0.200
     0.310    -0.554     0.200
     0.312     0.388     0.200
     0.317    -0.413     0.200
     0.335    -0.414     0.200
     0.369     0.098     0.200
     0.386     0.212     0.200
     0.419    -0.296     0.200
     0.426     0.284     0.200
     0.439     0.010     0.200
     0.457    -0.478     0.200
     0.462    -0.046     0.200
     0.469    -0.022     0.200
     0.552    -0.039     0.200
     0.553    -0.068     0.200
     0.625     0.003     0.200
     0.667    -0.303     0.200
     0.667    -0.428     0.200
     0.696     0.072     0.200
     0.706     0.238     0.200
     0.719     0.069     0.200
     0.715     0.726     0.200
     0.723     0.068     0.200
     0.744     0.017     0.200
     0.757     0.115     0.200
     0.798    -0.366     0.200
     0.798    -0.261     0.200
     0.805     0.023     0.200
     0.808     0.095     0.200
     0.856    -0.022     0.200
     0.871    -0.046     0.200
     0.916     0.261     0.200
     0.997     0.236     0.200
     0.299     0.303     0.200
     0.361    -0.161     0.200
     0.367    -0.362     0.200
     0.432     0.239     0.200
     0.385     0.071     0.200
     0.406    -0.208     0.200
     0.458     0.210     0.200
     0.406     0.273     0.200
     0.417    -0.389     0.200
     0.465    -0.330     0.200
     0.451     0.166     0.200
     0.511     0.003     0.200
     0.549    -0.005     0.200
     0.558     0.274     0.200
     0.573    -0.074     0.200
     0.658    -0.348     0.200
     0.678    -0.278     0.200
     0.679    -0.156     0.200
     0.635    -0.298     0.200
     0.670    -0.048     0.200
     0.674    -0.075     0.200
     0.677    -0.120     0.200
     0.719    -0.495     0.200
     0.712     0.147     0.200
     0.729    -0.247     0.200
     0.762     0.313     0.200
     0.724     0.357     0.200
     0.724     0.518     0.200
     0.759     0.266     0.200
     0.749     0.370     0.200
     0.803    -0.515     0.200
     0.803    -0.343     0.200
     0.848    -0.192     0.200
     0.960    -1.193     0.200
     0.199     0.299     0.200
     0.212     0.277     0.200
     0.292     0.138     0.200
     0.354    -0.273     0.200
     0.360    -0.233     0.200
     0.392    -0.205     0.200
     0.425     0.110     0.200
     0.413    -0.455     0.200
     0.423    -0.633     0.200
     0.412     0.051     0.200
     0.450     0.158     0.200
     0.458    -0.228     0.200
     0.449     0.188     0.200
     0.505    -0.204     0.200
     0.541    -0.012     0.200
     0.551     0.124     0.200
     0.573    -0.048     0.200
     0.651    -0.485     0.200
     0.639    -0.464     0.200
     0.674    -0.173     0.200
     0.671    -0.331     0.200
     0.673     0.605     0.200
     0.677    -0.209     0.200
     0.680    -0.260     0.200
     0.711     0.019     0.200
     0.715    -0.317     0.200
     0.707     0.097     0.200
     0.722    -0.220     0.200
     0.731     0.225     0.200
     0.755     0.216     0.200
     0.757     0.341     0.200
     0.751     0.327     0.200
     0.801    -0.273     0.200
     0.843    -0.226     0.200
     0.953    -0.850     0.200
     0.214     0.276     0.200
     0.227     0.292     0.200
     0.296     0.307     0.200
     0.368    -0.264     0.200
     0.373    -0.262     0.200
     0.373    -0.376     0.200
     0.386    -0.015     0.200
     0.400    -0.171     0.200
     0.406    -0.343     0.200
     0.406    -0.195     0.200
     0.411     0.139     0.200
     0.431     0.478     0.200
     0.461     0.117     0.200
     0.465     0.187     0.200
     0.474    -0.323     0.200
     0.552     0.224     0.200
     0.555     0.090     0.200
     0.588     0.043     0.200
     0.645    -0.124     0.200
     0.662    -0.301     0.200
     0.671    -0.106     0.200
     0.685    -0.608     0.200
     0.681    -0.521     0.200
     0.685    -0.084     0.200
     0.688    -0.096     0.200
     0.708    -0.237     0.200
     0.717    -0.001     0.200
     0.725     0.029     0.200
     0.725     0.141     0.200
     0.725     0.359     0.200
     0.738    -0.309     0.200
     0.738    -0.095     0.200
     0.762     0.171     0.200
     0.771     0.295     0.200
     0.773     0.422     0.200
     0.787     0.115     0.200
     0.791    -0.322     0.200
     0.786     0.164     0.200
     0.805     0.332     0.200
     0.814     0.346     0.200
     0.840    -0.275     0.200
     0.851     0.082     0.200
     0.875     0.149     0.200
     0.889     0.384     0.200
     0.940     0.052     0.200
     0.958     0.552     0.200
     0.950     0.547     0.200
     0.959     0.218     0.200
     0.968     0.391     0.200
     0.198     0.252     0.200
     0.208     0.355     0.200
     0.294     0.129     0.200
     0.353    -0.307     0.200
     0.360    -0.269     0.200
     0.391    -0.057     0.200
     0.414    -0.296     0.200
     0.410     0.143     0.200
     0.425    -0.548     0.200
     0.426     0.037     0.200
     0.450     0.198     0.200
     0.446     0.243     0.200
     0.457    -0.251     0.200
     0.507    -0.145     0.200
     0.542     0.073     0.200
     0.553     0.256     0.200
     0.570     0.188     0.200
     0.636    -0.163     0.200
     0.651    -0.420     0.200
     0.677    -0.066     0.200
     0.671    -0.342     0.200
     0.670     0.376     0.200
     0.674    -0.066     0.200
     0.677    -0.087     0.200
     0.705     0.111     0.200
     0.713    -0.163     0.200
     0.719    -0.476     0.200
     0.721    -0.119     0.200
     0.730     0.399     0.200
     0.748     0.464     0.200
     0.754     0.044     0.200
     0.753     0.443     0.200
     0.769     0.331     0.200
     0.804    -0.335     0.200
     0.804    -0.440     0.200
     0.846    -0.189     0.200
     0.847     0.146     0.200
     0.863     0.396     0.200
     0.876     0.386     0.200
     0.938     0.121     0.200
     0.942     0.283     0.200
     0.955    -1.294     0.200
     0.986    -0.008     0.200
     0.209     0.469     0.200
     0.295     0.163     0.200
     0.355    -0.159     0.200
     0.361    -0.253     0.200
     0.427     0.182     0.200
     0.424    -0.552     0.200
     0.452     0.236     0.200
     0.508    -0.162     0.200
     0.543    -0.013     0.200
     0.636    -0.365     0.200
     0.652    -0.486     0.200
     0.672    -0.409     0.200
     0.674    -0.079     0.200
     0.677    -0.111     0.200
     0.706     0.207     0.200
     0.719    -0.376     0.200
     0.722    -0.176     0.200
     0.729     0.308     0.200
     0.755     0.227     0.200
     0.755     0.367     0.200
     0.804    -0.121     0.200
     0.804    -0.493     0.200
     0.151    -0.084     0.200
     0.303    -0.270     0.200
     0.307    -0.160     0.200
     0.350    -0.035     0.200
     0.347     0.294     0.200
     0.358     0.323     0.200
     0.401     0.289     0.200
     0.441    -0.121     0.200
     0.446     0.086     0.200
     0.477    -0.306     0.200
     0.507    -0.227     0.200
     0.519    -0.165     0.200
     0.551    -0.407     0.200
     0.542    -0.076     0.200
     0.556    -0.662     0.200
     0.560     0.057     0.200
     0.569     0.064     0.200
     0.574    -0.026     0.200
     0.610    -0.288     0.200
     0.652    -0.323     0.200
     0.652    -0.163     0.200
     0.676    -0.194     0.200
     0.695     0.029     0.200
     0.701    -0.085     0.200
     0.717     0.395     0.200
     0.762    -0.195     0.200
     0.762     0.051     0.200
     0.805    -0.782     0.200
     0.843    -0.017     0.200
     0.843    -0.122     0.200
     0.879    -0.190     0.200
     0.058    -0.306     0.200
     0.158    -0.011     0.200
     0.197     0.211     0.200
     0.201     0.370     0.200
     0.208    -0.201     0.200
     0.227    -0.072     0.200
     0.260     0.518     0.200
     0.269     0.027     0.200
     0.364     0.386     0.200
     0.363    -0.480     0.200
     0.360    -0.186     0.200
     0.384     0.101     0.200
     0.384    -0.087     0.200
     0.456    -0.495     0.200
     0.456    -0.444     0.200
     0.465    -0.111     0.200
     0.487    -0.477     0.200
     0.539    -0.144     0.200
     0.572    -0.148     0.200
     0.581    -0.139     0.200
     0.604     0.011     0.200
     0.604    -0.403     0.200
     0.617    -0.278     0.200
     0.621     0.188     0.200
     0.675     0.265     0.200
     0.725     0.180     0.200
     0.734     0.082     0.200
     0.740    -0.131     0.200
     0.761     0.297     0.200
     0.776    -0.111     0.200
     0.791    -0.544     0.200
     0.878    -0.822     0.200
     0.880    -0.063     0.200
     0.889     0.040     0.200
     0.889    -0.179     0.200
     0.940    -0.017     0.200
     0.954    -0.448     0.200
     0.977    -0.195     0.200
     0.978    -0.005     0.200
     0.987    -0.195     0.200
     0.981    -0.334     0.200
     0.981    -0.233     0.200
     0.056    -0.232     0.200
     0.161    -0.035     0.200
     0.196     0.214     0.200
     0.203     0.280     0.200
     0.203     0.452     0.200
     0.206    -0.193     0.200
     0.206    -0.037     0.200
     0.269     0.023     0.200
     0.269     0.179     0.200
     0.257     0.618     0.200
     0.364    -0.532     0.200
     0.359    -0.222     0.200
     0.366     0.395     0.200
     0.366     0.543     0.200
     0.386     0.598     0.200
     0.387    -0.195     0.200
     0.456    -0.458     0.200
     0.455    -0.399     0.200
     0.463     0.259     0.200
     0.489    -0.614     0.200
     0.545     0.102     0.200
     0.542    -0.148     0.200
     0.542    -0.038     0.200
     0.572    -0.226     0.200
     0.581    -0.166     0.200
     0.581    -0.057     0.200
     0.606    -0.363     0.200
     0.619     0.882     0.200
     0.618    -0.309     0.200
     0.619     0.262     0.200
     0.673     0.205     0.200
     0.732     0.006     0.200
     0.724     0.103     0.200
     0.738    -0.131     0.200
     0.759    -0.231     0.200
     0.773    -0.067     0.200
     0.794    -0.452     0.200
     0.877     0.070     0.200
     0.892    -0.206     0.200
     0.938     0.024     0.200
     0.952    -0.271     0.200
     0.976     0.469     0.200
     0.985    -0.160     0.200
     0.985    -0.051     0.200
     0.979    -0.461     0.200
     0.979    -0.211     0.200
     0.179    -0.168     0.200
     0.293     0.240     0.200
     0.309    -0.321     0.200
     0.345    -0.225     0.200
     0.364    -0.175     0.200
     0.365    -0.220     0.200
     0.412     0.071     0.200
     0.412    -0.044     0.200
     0.471    -0.398     0.200
     0.477     0.287     0.200
     0.456    -0.241     0.200
     0.488    -0.197     0.200
     0.503    -0.276     0.200
     0.487    -0.609     0.200
     0.498    -0.454     0.200
     0.501    -0.508     0.200
     0.553     0.244     0.200
     0.526    -0.133     0.200
     0.576    -0.060     0.200
     0.596    -0.309     0.200
     0.562    -0.064     0.200
     0.605    -0.536     0.200
     0.572     0.072     0.200
     0.583     0.092     0.200
     0.641     0.587     0.200
     0.644     0.135     0.200
     0.658     0.239     0.200
     0.672    -0.017     0.200
     0.689     0.150     0.200
     0.756     0.035     0.200
     0.769    -0.306     0.200
     0.755     0.145     0.200
     0.756     0.290     0.200
     0.795    -0.082     0.200
     0.788     0.086     0.200
     0.822    -0.028     0.200
     0.818     0.473     0.200
     0.866    -0.188     0.200
     0.882     0.049     0.200
     0.853     0.404     0.200
     0.858     0.341     0.200
     0.870     0.412     0.200
     0.906     0.107     0.200
     0.899     0.423     0.200
     0.906     0.415     0.200
     0.940    -0.271     0.200
     0.955     0.363     0.200
     0.976     0.320     0.200
     0.994     0.281     0.200
     0.137     0.474     0.200
     0.144    -0.197     0.200
     0.208     0.269     0.200
     0.244    -0.295     0.200
     0.245    -0.229     0.200
     0.276     0.263     0.200
     0.291     0.427     0.200
     0.316     0.241     0.200
     0.358     0.062     0.200
     0.374    -0.123     0.200
     0.402     0.396     0.200
     0.406     0.074     0.200
     0.492     0.281     0.200
     0.515    -0.436     0.200
     0.523    -0.407     0.200
     0.541    -0.110     0.200
     0.547    -0.405     0.200
     0.544    -0.051     0.200
     0.560     0.038     0.200
     0.611    -0.585     0.200
     0.632    -0.162     0.200
     0.657     0.449     0.200
     0.689     0.108     0.200
     0.713    -0.221     0.200
     0.715    -1.072     0.200
     0.715    -0.564     0.200
     0.765    -0.199     0.200
     0.765    -0.706     0.200
     0.784     0.432     0.200
     0.799    -0.179     0.200
     0.799     0.110     0.200
     0.804    -0.463     0.200
     0.822     0.220     0.200
     0.972    -0.716     0.200
     0.121    -0.036     0.200
     0.125    -0.521     0.200
     0.142    -0.045     0.200
     0.197    -0.327     0.200
     0.269    -0.459     0.200
     0.351    -0.196     0.200
     0.367    -0.130     0.200
     0.403    -0.147     0.200
     0.454    -0.319     0.200
     0.459     0.037     0.200
     0.501    -0.276     0.200
     0.510     0.002     0.200
     0.498    -0.311     0.200
     0.535     0.071     0.200
     0.557     0.629     0.200
     0.569    -0.105     0.200
     0.590     0.119     0.200
     0.596    -0.044     0.200
     0.586    -0.079     0.200
     0.595    -0.342     0.200
     0.585    -0.045     0.200
     0.585     0.060     0.200
     0.600    -0.253     0.200
     0.613     0.114     0.200
     0.624     0.002     0.200
     0.647     0.351     0.200
     0.643     0.280     0.200
     0.663    -0.069     0.200
     0.659     0.239     0.200
     0.739    -0.197     0.200
     0.996    -0.235     0.200
     0.074    -0.215     0.200
     0.100    -0.136     0.200
     0.125    -0.810     0.200
     0.125    -0.419     0.200
     0.126    -0.465     0.200
     0.121    -0.032     0.200
     0.128    -0.077     0.200
     0.190    -0.862     0.200
     0.240    -0.481     0.200
     0.199    -0.052     0.200
     0.219    -0.332     0.200
     0.315    -0.244     0.200
     0.372    -0.123     0.200
     0.391     0.053     0.200
     0.566     0.140     0.200
     0.606    -0.009     0.200
     0.579     0.138     0.200
     0.577     0.637     0.200
     0.663     0.140     0.200
     0.689    -0.004     0.200
     0.812    -0.246     0.200
     0.812    -0.026     0.200
     0.908     0.232     0.200
     0.896     1.262     0.200
     0.980    -0.256     0.200
     0.159    -0.109     0.200
     0.211     0.209     0.200
     0.275    -0.387     0.200
     0.283    -0.150     0.200
     0.327    -0.438     0.200
     0.327    -0.307     0.200
     0.327    -0.619     0.200
     0.327    -0.346     0.200
     0.384    -0.130     0.200
     0.383    -0.260     0.200
     0.375    -0.242     0.200
     0.448    -0.102     0.200
     0.610    -0.119     0.200
     0.549    -0.234     0.200
     0.603    -0.137     0.200
     0.601    -0.314     0.200
     0.698     0.293     0.200
     0.663     0.007     0.200
     0.727     0.339     0.200
     0.744     0.391     0.200
     0.696     0.019     0.200
     0.767     0.236     0.200
     0.769     0.124     0.200
     0.792     0.086     0.200
     0.156    -0.461     0.200
     0.256    -0.512     0.200
     0.259    -0.790     0.200
     0.259    -0.498     0.200
     0.266    -0.428     0.200
     0.284     0.078     0.200
     0.274    -0.291     0.200
     0.308    -0.247     0.200
     0.324    -0.174     0.200
     0.329    -0.115     0.200
     0.348    -0.309     0.200
     0.370     0.093     0.200
     0.397    -0.170     0.200
     0.406    -0.105     0.200
     0.419    -0.373     0.200
     0.458     0.046     0.200
     0.477     0.466     0.200
     0.483     0.731     0.200
     0.473    -0.035     0.200
     0.507    -0.105     0.200
     0.573     0.208     0.200
     0.557     0.236     0.200
     0.589    -0.011     0.200
     0.610    -0.064     0.200
     0.592     0.295     0.200
     0.637     0.170     0.200
     0.599     0.080     0.200
     0.659     0.331     0.200
     0.648     0.140     0.200
     0.659     0.277     0.200
     0.665    -0.193     0.200
     0.658     0.139     0.200
     0.677    -0.030     0.200
     0.669     0.099     0.200
     0.696     0.200     0.200
     0.682     0.268     0.200
     0.720     0.049     0.200
     0.754     0.138     0.200
     0.774     0.234     0.200
     0.788     0.220     0.200
     0.777     0.689     0.200
     0.805    -0.338     0.200
     0.841    -0.067     0.200
     0.859     0.337     0.200
     0.882    -0.496     0.200
     0.923    -0.079     0.200
     0.106    -0.013     0.200
     0.157    -0.659     0.200
     0.175    -0.279     0.200
     0.225     0.170     0.200
     0.292     0.297     0.200
     0.299     0.470     0.200
     0.304     0.295     0.200
     0.347     0.044     0.200
     0.347     0.434     0.200
     0.342    -0.019     0.200
     0.411    -0.515     0.200
     0.436    -0.441     0.200
     0.478     0.738     0.200
     0.447    -0.148     0.200
     0.460    -0.042     0.200
     0.473     0.159     0.200
     0.535     0.309     0.200
     0.590     0.198     0.200
     0.596    -0.014     0.200
     0.618    -0.247     0.200
     0.617     0.311     0.200
     0.705    -0.122     0.200
     0.715    -0.265     0.200
     0.697    -0.194     0.200
     0.701    -0.111     0.200
     0.708    -0.127     0.200
     0.708     0.172     0.200
     0.708    -0.354     0.200
     0.731    -0.283     0.200
     0.752    -0.230     0.200
     0.775     0.410     0.200
     0.829    -0.382     0.200
     0.925    -0.437     0.200
     0.966     0.168     0.200
     0.968     0.181     0.200
     0.978     0.216     0.200
     0.154     0.011     0.200
     0.211     0.281     0.200
     0.280    -0.285     0.200
     0.282    -0.069     0.200
     0.292    -0.210     0.200
     0.332    -0.431     0.200
     0.332    -0.252     0.200
     0.335    -0.383     0.200
     0.370    -0.185     0.200
     0.387    -0.290     0.200
     0.387    -0.107     0.200
     0.450    -0.085     0.200
     0.487    -0.151     0.200
     0.545    -0.030     0.200
     0.552    -0.177     0.200
     0.611    -0.068     0.200
     0.598    -0.207     0.200
     0.605    -0.095     0.200
     0.663     0.041     0.200
     0.668    -0.101     0.200
     0.702     0.458     0.200
     0.725     0.194     0.200
     0.732     0.410     0.200
     0.747     0.430     0.200
     0.768     0.143     0.200
     0.794     0.145     0.200
     0.816     0.608     0.200
     0.841     0.048     0.200
     0.903     0.480     0.200
     0.942     0.575     0.200
     0.055    -1.311     0.200
     0.105    -0.570     0.200
     0.149     0.419     0.200
     0.225    -0.323     0.200
     0.229    -0.235     0.200
     0.286     0.248     0.200
     0.319     0.009     0.200
     0.323     0.293     0.200
     0.364     0.407     0.200
     0.364    -0.196     0.200
     0.376     0.047     0.200
     0.514     0.219     0.200
     0.524     0.413     0.200
     0.534    -0.601     0.200
     0.549    -0.304     0.200
     0.583    -0.511     0.200
     0.578     0.029     0.200
     0.579    -0.102     0.200
     0.599    -0.028     0.200
     0.617    -0.136     0.200
     0.639     0.167     0.200
     0.662     0.157     0.200
     0.691    -0.557     0.200
     0.691    -0.456     0.200
     0.694     0.178     0.200
     0.765    -0.597     0.200
     0.802    -0.256     0.200
     0.800     0.311     0.200
     0.834    -0.129     0.200
     0.834     0.075     0.200
     0.843     0.216     0.200
     0.918     0.004     0.200
     0.929     0.197     0.200
     0.933     0.310     0.200
     0.973     0.016     0.200
     0.984    -0.049     0.200
     0.193    -0.560     0.200
     0.199    -0.461     0.200
     0.224     0.290     0.200
     0.227     0.006     0.200
     0.231     0.185     0.200
     0.276    -0.008     0.200
     0.313     0.202     0.200
     0.340    -0.523     0.200
     0.340    -0.699     0.200
     0.343    -0.565     0.200
     0.330     0.516     0.200
     0.330     0.261     0.200
     0.402    -0.109     0.200
     0.417    -0.615     0.200
     0.437     0.030     0.200
     0.460     0.434     0.200
     0.465     0.493     0.200
     0.481     0.141     0.200
     0.501    -0.073     0.200
     0.508    -0.064     0.200
     0.527     0.264     0.200
     0.558     0.123     0.200
     0.580    -0.073     0.200
     0.585    -0.269     0.200
     0.608     0.391     0.200
     0.626     0.076     0.200
     0.626     0.076     0.200
     0.648    -0.051     0.200
     0.673     0.014     0.200
     0.677    -0.003     0.200
     0.670     0.246     0.200
     0.689    -0.112     0.200
     0.700    -0.339     0.200
     0.726     0.032     0.200
     0.733     0.225     0.200
     0.733     0.106     0.200
     0.723     0.382     0.200
     0.741    -0.246     0.200
     0.730     0.110     0.200
     0.735     0.297     0.200
     0.739     0.296     0.200
     0.801    -0.178     0.200
     0.791     0.113     0.200
     0.805     0.075     0.200
     0.808     0.227     0.200
     0.827    -0.074     0.200
     0.865    -0.142     0.200
     0.866     0.020     0.200
     0.872    -0.081     0.200
     0.872    -0.236     0.200
     0.881     0.496     0.200
     0.916     0.717     0.200
     0.908    -0.187     0.200
     0.921    -0.199     0.200
     0.911    -0.175     0.200
     0.928     0.402     0.200
     0.910     1.005     0.200
     0.921     0.158     0.200
     0.933     0.387     0.200
     0.978     0.270     0.200
     0.136    -0.235     0.200
     0.154    -0.422     0.200
     0.176    -0.387     0.200
     0.280    -0.019     0.200
     0.257     0.098     0.200
     0.278     0.110     0.200
     0.340     0.145     0.200
     0.387    -0.268     0.200
     0.385    -0.365     0.200
     0.378    -0.683     0.200
     0.378    -0.380     0.200
     0.342     0.430     0.200
     0.357     0.530     0.200
     0.380     0.600     0.200
     0.425     0.389     0.200
     0.435    -0.326     0.200
     0.457    -0.187     0.200
     0.479    -0.493     0.200
     0.505     0.589     0.200
     0.546     0.401     0.200
     0.580     0.100     0.200
     0.563     0.348     0.200
     0.601     0.389     0.200
     0.669    -0.167     0.200
     0.614    -0.218     0.200
     0.638     0.297     0.200
     0.643     0.296     0.200
     0.631     0.048     0.200
     0.690    -0.164     0.200
     0.661    -0.107     0.200
     0.697     0.287     0.200
     0.732    -0.078     0.200
     0.708    -0.077     0.200
     0.736     0.462     0.200
     0.781    -0.015     0.200
     0.745    -0.014     0.200
     0.745    -0.190     0.200
     0.803     0.448     0.200
     0.774     0.067     0.200
     0.852     0.016     0.200
     0.835    -0.655     0.200
     0.894     0.134     0.200
     0.863     0.111     0.200
     0.908     0.280     0.200
     0.890    -0.364     0.200
     0.948     0.155     0.200
     0.992     0.516     0.200
     0.976    -0.482     0.200
     0.148    -0.076     0.200
     0.180     0.018     0.200
     0.224    -0.003     0.200
     0.227     0.271     0.200
     0.230    -0.008     0.200
     0.238    -0.019     0.200
     0.257     0.024     0.200
     0.275    -0.402     0.200
     0.274     0.266     0.200
     0.274     0.145     0.200
     0.293    -0.338     0.200
     0.293     0.153     0.200
     0.301    -0.424     0.200
     0.333     0.568     0.200
     0.338    -0.163     0.200
     0.364    -0.485     0.200
     0.376     0.030     0.200
     0.386    -0.470     0.200
     0.420    -0.407     0.200
     0.420    -0.241     0.200
     0.465    -0.510     0.200
     0.486     0.300     0.200
     0.479     0.036     0.200
     0.497     0.225     0.200
     0.512    -0.231     0.200
     0.513    -0.027     0.200
     0.513     0.096     0.200
     0.544     0.539     0.200
     0.553     0.115     0.200
     0.554    -0.074     0.200
     0.561     0.405     0.200
     0.604    -0.437     0.200
     0.661     0.141     0.200
     0.681     0.274     0.200
     0.703     0.687     0.200
     0.787    -0.536     0.200
     0.830    -0.224     0.200
     0.837    -0.087     0.200
     0.850    -0.072     0.200
     0.112    -0.161     0.200
     0.348     0.066     0.200
     0.393    -0.176     0.200
     0.445    -0.184     0.200
     0.440    -0.524     0.200
     0.442     0.080     0.200
     0.510    -0.553     0.200
     0.511    -0.648     0.200
     0.511    -0.507     0.200
     0.512    -0.494     0.200
     0.612    -0.429     0.200
     0.643    -0.204     0.200
     0.677    -0.143     0.200
     0.682     0.439     0.200
     0.692     0.366     0.200
     0.713     0.324     0.200
     0.769    -0.028     0.200
     0.785     0.003     0.200
     0.788     0.046     0.200
     0.848     0.209     0.200
     0.878     0.199     0.200
     0.247     0.503     0.200
     0.306     0.233     0.200
     0.317     0.047     0.200
     0.329     0.216     0.200
     0.370    -0.183     0.200
     0.374     0.529     0.200
     0.408    -0.211     0.200
     0.412    -0.300     0.200
     0.418    -0.239     0.200
     0.414     0.233     0.200
     0.436    -0.441     0.200
     0.496    -0.093     0.200
     0.504     0.328     0.200
     0.516     0.238     0.200
     0.523    -0.148     0.200
     0.557    -0.443     0.200
     0.588     0.113     0.200
     0.607    -0.041     0.200
     0.601    -0.555     0.200
     0.601    -0.387     0.200
     0.633     0.462     0.200
     0.655    -0.013     0.200
     0.716    -0.454     0.200
     0.722    -0.549     0.200
     0.720    -0.071     0.200
     0.726     0.226     0.200
     0.759    -0.297     0.200
     0.757    -0.369     0.200
     0.775     0.192     0.200
     0.790    -0.211     0.200
     0.788    -0.037     0.200
     0.796    -0.449     0.200
     0.794     0.310     0.200
     0.876     0.083     0.200
     0.928    -0.506     0.200
     0.963     0.162     0.200
     0.989    -0.005     0.200
     0.999     0.131     0.200
     0.181     0.122     0.200
     0.306     0.163     0.200
     0.315    -0.054     0.200
     0.365    -0.234     0.200
     0.375     0.312     0.200
     0.412    -0.405     0.200
     0.421    -0.390     0.200
     0.406    -0.305     0.200
     0.421    -0.018     0.200
     0.432    -0.486     0.200
     0.501    -0.313     0.200
     0.506     0.179     0.200
     0.519    -0.001     0.200
     0.529    -0.147     0.200
     0.560    -0.443     0.200
     0.588     0.112     0.200
     0.605    -0.343     0.200
     0.605    -0.456     0.200
     0.633     0.474     0.200
     0.653     0.184     0.200
     0.685     0.126     0.200
     0.719    -0.346     0.200
     0.726    -0.351     0.200
     0.724     0.268     0.200
     0.732     0.238     0.200
     0.742     0.146     0.200
     0.757    -0.108     0.200
     0.762    -0.325     0.200
     0.775     0.158     0.200
     0.792     0.014     0.200
     0.799     0.314     0.200
     0.793    -0.268     0.200
     0.792     0.092     0.200
     0.856     0.209     0.200
     0.872     0.132     0.200
     0.863     0.622     0.200
     0.926    -0.299     0.200
     0.957     0.528     0.200
     0.993     0.127     0.200
     0.162    -0.055     0.200
     0.169    -0.188     0.200
     0.185    -0.164     0.200
     0.134     0.049     0.200
     0.162    -0.462     0.200
     0.209    -0.121     0.200
     0.165     0.168     0.200
     0.195     0.040     0.200
     0.314    -0.395     0.200
     0.406     0.275     0.200
     0.387    -0.556     0.200
     0.366     0.274     0.200
     0.463     0.010     0.200
     0.501     0.069     0.200
     0.583    -0.196     0.200
     0.617     0.324     0.200
     0.572    -0.168     0.200
     0.574     0.100     0.200
     0.632     0.404     0.200
     0.648     0.485     0.200
     0.722    -0.060     0.200
     0.677     0.125     0.200
     0.767     0.593     0.200
     0.776    -0.049     0.200
     0.726     0.059     0.200
     0.820    -0.105     0.200
     0.954     0.305     0.200
     0.126     0.083     0.200
     0.193    -0.390     0.200
     0.225    -0.035     0.200
     0.324     0.414     0.200
     0.458    -0.145     0.200
     0.465     0.115     0.200
     0.486     0.223     0.200
     0.565    -0.160     0.200
     0.583    -0.007     0.200
     0.608    -0.190     0.200
     0.664     0.379     0.200
     0.675     0.010     0.200
     0.697    -0.055     0.200
     0.760     0.023     0.200
     0.753     0.078     0.200
     0.779    -0.040     0.200
     0.781    -0.224     0.200
     0.787     0.159     0.200
     0.799     0.394     0.200
     0.809    -0.049     0.200
     0.818    -0.131     0.200
     0.814    -0.172     0.200
     0.843     0.145     0.200
     0.861     0.608     0.200
     0.863     0.335     0.200
     0.878     0.076     0.200
     0.890     0.616     0.200
     0.902     0.253     0.200
     0.899    -0.145     0.200
     0.908     0.025     0.200
     0.898    -0.243     0.200
     0.902     0.597     0.200
     0.921     0.093     0.200
     0.973    -0.338     0.200
     0.984     0.257     0.200
     0.989    -0.146     0.200
     0.081    -0.577     0.200
     0.157    -0.069     0.200
     0.212    -0.256     0.200
     0.284    -0.106     0.200
     0.294     0.161     0.200
     0.310     0.463     0.200
     0.279    -0.769     0.200
     0.366    -0.141     0.200
     0.414    -0.217     0.200
     0.414     0.204     0.200
     0.438     0.031     0.200
     0.521     0.005     0.200
     0.488    -0.078     0.200
     0.532     0.239     0.200
     0.545    -0.344     0.200
     0.526    -0.070     0.200
     0.517    -0.004     0.200
     0.538    -0.276     0.200
     0.554     0.012     0.200
     0.552    -0.046     0.200
     0.593    -0.272     0.200
     0.579     0.306     0.200
     0.592    -0.433     0.200
     0.662     0.111     0.200
     0.671    -0.283     0.200
     0.696     0.226     0.200
     0.690    -0.387     0.200
     0.706    -0.154     0.200
     0.773    -0.141     0.200
     0.810    -0.094     0.200
     0.810    -0.203     0.200
     0.818    -0.476     0.200
     0.851    -0.120     0.200
     0.365     0.043     0.200
     0.378     0.163     0.200
     0.402     0.323     0.200
     0.424     0.007     0.200
     0.447    -0.577     0.200
     0.492    -0.444     0.200
     0.492    -0.579     0.200
     0.513     0.209     0.200
     0.526     0.421     0.200
     0.558    -0.245     0.200
     0.565     0.299     0.200
     0.620     0.276     0.200
     0.651    -0.681     0.200
     0.629    -0.055     0.200
     0.634    -0.321     0.200
     0.659     0.206     0.200
     0.675    -0.287     0.200
     0.662    -0.144     0.200
     0.679     0.025     0.200
     0.686     0.622     0.200
     0.691    -0.096     0.200
     0.693    -0.219     0.200
     0.693    -0.336     0.200
     0.717     0.137     0.200
     0.726     0.248     0.200
     0.752    -0.203     0.200
     0.747     0.179     0.200
     0.768    -0.267     0.200
     0.778    -0.148     0.200
     0.782     0.265     0.200
     0.785    -0.085     0.200
     0.810     0.288     0.200
     0.852    -0.828     0.200
     0.846     0.014     0.200
     0.875    -0.107     0.200
     0.875    -0.535     0.200
     0.895     0.086     0.200
     0.899    -0.024     0.200
     0.913    -0.461     0.200
     0.974     0.107     0.200
     0.971    -0.021     0.200
     0.999    -0.806     0.200
     0.092     0.130     0.200
     0.102    -0.439     0.200
     0.114    -0.042     0.200
     0.104     0.129     0.200
     0.153    -0.413     0.200
     0.179    -0.343     0.200
     0.229     0.072     0.200
     0.248     0.124     0.200
     0.324    -0.437     0.200
     0.381     0.167     0.200
     0.435     0.115     0.200
     0.448    -0.253     0.200
     0.507     0.585     0.200
     0.590    -0.062     0.200
     0.637    -0.610     0.200
     0.676     0.241     0.200
     0.682    -0.527     0.200
     0.712    -0.003     0.200
     0.715    -0.156     0.200
     0.772    -0.422     0.200
     0.775     0.268     0.200
     0.780     0.442     0.200
     0.803    -0.168     0.200
     0.826     0.375     0.200
     0.831     0.434     0.200
     0.909    -0.733     0.200
     0.993    -0.265     0.200
     0.104    -0.450     0.200
     0.106    -1.164     0.200
     0.113     0.011     0.200
     0.172    -0.495     0.200
     0.162    -0.528     0.200
     0.163     0.721     0.200
     0.240    -0.160     0.200
     0.315     0.130     0.200
     0.373    -0.104     0.200
     0.401     0.054     0.200
     0.394     0.095     0.200
     0.423    -0.295     0.200
     0.457    -0.451     0.200
     0.444    -0.077     0.200
     0.459    -0.345     0.200
     0.457    -0.028     0.200
     0.463    -0.117     0.200
     0.512    -0.302     0.200
     0.602    -0.413     0.200
     0.610     0.309     0.200
     0.590     0.179     0.200
     0.630    -0.149     0.200
     0.628    -0.389     0.200
     0.687    -0.455     0.200
     0.681    -0.149     0.200
     0.717     0.218     0.200
     0.712     1.694     0.200
     0.716     0.127     0.200
     0.719    -0.057     0.200
     0.719     0.225     0.200
     0.719     0.057     0.200
     0.770    -0.954     0.200
     0.761    -0.045     0.200
     0.798     0.058     0.200
     0.783     0.356     0.200
     0.782    -0.078     0.200
     0.784    -0.126     0.200
     0.809     0.009     0.200
     0.829     0.497     0.200
     0.833     0.378     0.200
     0.899     0.193     0.200
     0.911     0.121     0.200
     0.967     0.303     0.200
     0.987     0.306     0.200
     0.090    -0.339     0.200
     0.102    -0.925     0.200
     0.101     0.163     0.200
     0.112     0.066     0.200
     0.154    -0.316     0.200
     0.174     0.410     0.200
     0.237     0.266     0.200
     0.243     0.429     0.200
     0.318    -0.129     0.200
     0.321    -0.252     0.200
     0.371     0.197     0.200
     0.405     0.356     0.200
     0.408     0.149     0.200
     0.433    -0.103     0.200
     0.449    -0.000     0.200
     0.445     0.091     0.200
     0.448    -0.206     0.200
     0.454    -0.036     0.200
     0.470     0.161     0.200
     0.468     0.158     0.200
     0.496     0.132     0.200
     0.496     0.323     0.200
     0.525    -0.122     0.200
     0.605    -0.391     0.200
     0.603    -0.032     0.200
     0.609     0.281     0.200
     0.621    -0.122     0.200
     0.635    -0.329     0.200
     0.637     0.074     0.200
     0.668    -0.381     0.200
     0.690    -0.348     0.200
     0.726     0.457     0.200
     0.722    -0.295     0.200
     0.729    -0.068     0.200
     0.758    -0.420     0.200
     0.774     0.150     0.200
     0.790    -0.361     0.200
     0.798     0.064     0.200
     0.821     0.314     0.200
     0.840     0.334     0.200
     0.899    -0.907     0.200
     0.914     0.182     0.200
     0.923     0.064     0.200
     0.996    -0.249     0.200
     0.093    -0.486     0.200
     0.078     0.090     0.200
     0.089     0.181     0.200
     0.124     0.908     0.200
     0.135    -0.300     0.200
     0.188    -0.353     0.200
     0.190     0.190     0.200
     0.236     0.419     0.200
     0.260    -0.019     0.200
     0.338    -0.080     0.200
     0.342    -0.420     0.200
     0.395     0.104     0.200
     0.408     0.159     0.200
     0.427     0.309     0.200
     0.430    -0.336     0.200
     0.450    -0.325     0.200
     0.472    -0.138     0.200
     0.445     0.362     0.200
     0.469     0.101     0.200
     0.519     0.211     0.200
     0.519     0.123     0.200
     0.516    -0.006     0.200
     0.598    -0.260     0.200
     0.640    -0.162     0.200
     0.660     0.245     0.200
     0.655    -0.338     0.200
     0.682    -0.419     0.200
     0.673    -0.156     0.200
     0.713    -0.205     0.200
     0.714     0.013     0.200
     0.714    -0.143     0.200
     0.769    -0.429     0.200
     0.761     0.439     0.200
     0.775     0.291     0.200
     0.809    -0.165     0.200
     0.782    -0.020     0.200
     0.922    -0.917     0.200
     0.140     0.484     0.200
     0.302    -0.398     0.200
     0.339    -0.331     0.200
     0.340    -0.324     0.200
     0.346    -0.334     0.200
     0.356    -0.120     0.200
     0.344     0.201     0.200
     0.352    -0.014     0.200
     0.347    -0.293     0.200
     0.424    -0.076     0.200
     0.431    -0.037     0.200
     0.457    -0.103     0.200
     0.470    -0.061     0.200
     0.459     0.143     0.200
     0.481    -0.105     0.200
     0.475     0.278     0.200
     0.504    -0.084     0.200
     0.501     0.118     0.200
     0.524    -0.083     0.200
     0.526     0.074     0.200
     0.526     0.072     0.200
     0.549     0.049     0.200
     0.581    -0.017     0.200
     0.588     0.363     0.200
     0.592     0.145     0.200
     0.623    -0.061     0.200
     0.687    -0.292     0.200
     0.680    -0.223     0.200
     0.704    -0.029     0.200
     0.741    -0.031     0.200
     0.756     0.180     0.200
     0.774     0.116     0.200
     0.762     0.113     0.200
     0.801     0.346     0.200
     0.814     0.480     0.200
     0.803     0.047     0.200
     0.844    -0.175     0.200
     0.849     0.196     0.200
     0.880     0.220     0.200
     0.880     0.092     0.200
     0.898     0.102     0.200
     0.975     0.441     0.200
     0.122     0.416     0.200
     0.206    -0.064     0.200
     0.276     0.426     0.200
     0.316    -0.463     0.200
     0.307     0.153     0.200
     0.323     0.119     0.200
     0.333     0.450     0.200
     0.355    -0.195     0.200
     0.345     0.005     0.200
     0.395     0.286     0.200
     0.410    -0.313     0.200
     0.445    -0.253     0.200
     0.480    -0.438     0.200
     0.533    -0.671     0.200
     0.606    -0.154     0.200
     0.581    -0.339     0.200
     0.597    -0.243     0.200
     0.619    -0.313     0.200
     0.660     0.180     0.200
     0.677    -0.263     0.200
     0.686    -0.243     0.200
     0.716    -0.269     0.200
     0.817    -0.564     0.200
     0.881    -0.370     0.200
     0.907     0.158     0.200
     0.910    -0.875     0.200
     0.910     0.039     0.200
     0.947    -0.296     0.200
     0.982     0.325     0.200
     0.994     0.783     0.200
     0.031    -0.638     0.200
     0.163    -0.023     0.200
     0.197     0.144     0.200
     0.208    -0.051     0.200
     0.216     0.491     0.200
     0.317     0.067     0.200
     0.312    -0.136     0.200
     0.348     0.234     0.200
     0.342     0.055     0.200
     0.385     0.402     0.200
     0.453    -0.391     0.200
     0.488    -0.593     0.200
     0.538    -0.621     0.200
     0.587    -0.061     0.200
     0.614    -0.160     0.200
     0.608    -0.239     0.200
     0.647     0.023     0.200
     0.654    -0.198     0.200
     0.690    -1.141     0.200
     0.674    -0.328     0.200
     0.709    -0.344     0.200
     0.897    -0.132     0.200
     0.900    -0.923     0.200
     0.900    -0.290     0.200
     0.971     0.179     0.200
     0.993    -0.270     0.200
     0.024    -1.035     0.200
     0.157    -0.085     0.200
     0.199    -0.254     0.200
     0.212    -0.108     0.200
     0.230     0.311     0.200
     0.238     0.093     0.200
     0.281     0.398     0.200
     0.315     0.150     0.200
     0.309    -0.541     0.200
     0.351    -0.028     0.200
     0.347    -0.273     0.200
     0.392     0.210     0.200
     0.418    -0.334     0.200
     0.446    -0.186     0.200
     0.494     0.040     0.200
     0.488    -0.500     0.200
     0.532    -0.601     0.200
     0.604    -0.071     0.200
     0.611    -0.096     0.200
     0.607    -0.254     0.200
     0.652     0.132     0.200
     0.660     0.071     0.200
     0.681     0.050     0.200
     0.683    -0.482     0.200
     0.716    -0.473     0.200
     0.821    -0.117     0.200
     0.878    -0.440     0.200
     0.889    -0.275     0.200
     0.904    -0.102     0.200
     0.907    -0.229     0.200
     0.975    -0.132     0.200
     0.976     0.236     0.200
     0.999    -0.009     0.200
     0.024    -1.271     0.200
     0.195    -0.279     0.200
     0.193     0.486     0.200
     0.208    -0.285     0.200
     0.226     0.240     0.200
     0.223    -0.059     0.200
     0.280     0.463     0.200
     0.311     0.064     0.200
     0.314    -0.653     0.200
     0.329     0.386     0.200
     0.347    -0.142     0.200
     0.414    -0.390     0.200
     0.392     0.034     0.200
     0.484    -0.455     0.200
     0.492     0.010     0.200
     0.534    -0.554     0.200
     0.608    -0.144     0.200
     0.615    -0.082     0.200
     0.682    -0.338     0.200
     0.714    -0.061     0.200
     0.821    -0.392     0.200
     0.878    -0.041     0.200
     0.907     0.074     0.200
     0.971     0.076     0.200
     0.030     0.933     0.200
     0.113     0.234     0.200
     0.160    -0.119     0.200
     0.188     0.646     0.200
     0.206    -0.152     0.200
     0.219     0.091     0.200
     0.286     0.329     0.200
     0.345    -0.096     0.200
     0.313     0.297     0.200
     0.323     0.217     0.200
     0.345    -0.234     0.200
     0.385     0.171     0.200
     0.417    -0.396     0.200
     0.485    -0.436     0.200
     0.600     0.069     0.200
     0.611     0.034     0.200
     0.687    -0.640     0.200
     0.708    -0.165     0.200
     0.827    -0.148     0.200
     0.872    -0.352     0.200
     0.877    -0.634     0.200
     0.893     1.571     0.200
     0.901    -0.328     0.200
     0.901    -0.188     0.200
     0.969    -0.013     0.200
     0.970     0.293     0.200
     0.994    -0.061     0.200
     0.996    -0.088     0.200
     0.170    -0.027     0.200
     0.207    -0.201     0.200
     0.211     0.034     0.200
     0.234     0.315     0.200
     0.303     0.226     0.200
     0.295     0.318     0.200
     0.314     0.177     0.200
     0.321     0.114     0.200
     0.313    -0.699     0.200
     0.347     0.142     0.200
     0.336    -0.281     0.200
     0.378     0.169     0.200
     0.425    -0.381     0.200
     0.460    -0.339     0.200
     0.490    -0.352     0.200
     0.544    -0.561     0.200
     0.604    -0.009     0.200
     0.622    -0.235     0.200
     0.667     0.102     0.200
     0.702    -0.016     0.200
     0.697    -0.730     0.200
     0.836    -0.189     0.200
     0.863    -0.231     0.200
     0.892     0.270     0.200
     0.892    -0.254     0.200
     0.019    -0.900     0.200
     0.149    -0.045     0.200
     0.207     0.011     0.200
     0.223     0.293     0.200
     0.231     0.025     0.200
     0.228     0.119     0.200
     0.274     0.301     0.200
     0.307     0.134     0.200
     0.315    -0.498     0.200
     0.324     0.258     0.200
     0.347    -0.365     0.200
     0.334     0.259     0.200
     0.355    -0.161     0.200
     0.397     0.179     0.200
     0.410    -0.368     0.200
     0.443    -0.304     0.200
     0.481    -0.401     0.200
     0.495     0.025     0.200
     0.531    -0.579     0.200
     0.582    -0.184     0.200
     0.598     0.008     0.200
     0.603    -0.220     0.200
     0.619     0.101     0.200
     0.660     0.346     0.200
     0.676    -0.576     0.200
     0.668    -0.003     0.200
     0.688     0.013     0.200
     0.718    -0.078     0.200
     0.836    -0.417     0.200
     0.890    -0.017     0.200
     0.883    -0.456     0.200
     0.904    -0.525     0.200
     0.909    -0.531     0.200
     0.912    -0.826     0.200
     0.912    -0.010     0.200
     0.972     0.230     0.200
     0.037    -0.849     0.200
     0.102     0.187     0.200
     0.170     0.078     0.200
     0.186     0.621     0.200
     0.202    -0.190     0.200
     0.213    -0.196     0.200
     0.239     0.317     0.200
     0.251     0.061     0.200
     0.295     0.363     0.200
     0.303     0.219     0.200
     0.313     0.191     0.200
     0.324     0.157     0.200
     0.307    -0.536     0.200
     0.335    -0.203     0.200
     0.352    -0.075     0.200
     0.381     0.243     0.200
     0.428    -0.352     0.200
     0.456    -0.257     0.200
     0.486     0.013     0.200
     0.495    -0.398     0.200
     0.539    -0.532     0.200
     0.592    -0.197     0.200
     0.609     0.080     0.200
     0.600     0.012     0.200
     0.618    -0.220     0.200
     0.647    -0.028     0.200
     0.667    -0.020     0.200
     0.707    -0.070     0.200
     0.697    -0.560     0.200
     0.830     0.038     0.200
     0.834    -0.478     0.200
     0.866    -0.334     0.200
     0.881     0.120     0.200
     0.888    -0.361     0.200
     0.892    -0.184     0.200
     0.895    -0.064     0.200
     0.895    -0.253     0.200
     0.885    -0.818     0.200
     0.935    -0.036     0.200
     0.970    -0.019     0.200
     0.975    -0.136     0.200
     0.982    -0.063     0.200
     0.990     0.025     0.200
     0.986    -0.071     0.200
     0.030     0.403     0.200
     0.167    -0.079     0.200
     0.213    -0.144     0.200
     0.225    -0.176     0.200
     0.245     0.342     0.200
     0.288     0.189     0.200
     0.295    -0.618     0.200
     0.309     0.192     0.200
     0.318     0.181     0.200
     0.329     0.135     0.200
     0.336    -0.289     0.200
     0.365    -0.109     0.200
     0.393     0.290     0.200
     0.432    -0.382     0.200
     0.443    -0.236     0.200
     0.500     0.026     0.200
     0.503    -0.372     0.200
     0.525    -0.551     0.200
     0.570     0.170     0.200
     0.603    -0.191     0.200
     0.598    -0.107     0.200
     0.606    -0.230     0.200
     0.641     0.108     0.200
     0.652    -0.015     0.200
     0.675    -0.168     0.200
     0.691    -0.113     0.200
     0.721    -0.136     0.200
     0.845    -0.046     0.200
     0.877    -0.149     0.200
     0.896    -0.042     0.200
     0.904    -0.122     0.200
     0.907    -0.097     0.200
     0.988    -0.130     0.200
     0.991    -0.302     0.200
     0.167    -0.101     0.200
     0.224    -0.189     0.200
     0.243     0.020     0.200
     0.244     0.279     0.200
     0.288     0.288     0.200
     0.296    -0.568     0.200
     0.308     0.213     0.200
     0.318     0.172     0.200
     0.336    -0.291     0.200
     0.364    -0.159     0.200
     0.393     0.209     0.200
     0.431    -0.365     0.200
     0.444    -0.236     0.200
     0.502    -0.315     0.200
     0.499     0.142     0.200
     0.525    -0.434     0.200
     0.602    -0.023     0.200
     0.598     0.007     0.200
     0.606    -0.110     0.200
     0.618     0.046     0.200
     0.675     0.223     0.200
     0.691    -0.526     0.200
     0.720     0.000     0.200
     0.825    -0.441     0.200
     0.876    -0.118     0.200
     0.907    -0.139     0.200
     0.991    -0.233     0.200
     0.027    -0.882     0.200
     0.164     0.005     0.200
     0.210    -0.167     0.200
     0.222    -0.083     0.200
     0.240     0.087     0.200
     0.241     0.269     0.200
     0.200     0.645     0.200
     0.212     0.160     0.200
     0.285     0.284     0.200
     0.325     0.155     0.200
     0.299    -0.462     0.200
     0.362    -0.094     0.200
     0.340    -0.194     0.200
     0.428    -0.372     0.200
     0.394     0.064     0.200
     0.443    -0.237     0.200
     0.499    -0.491     0.200
     0.499     0.068     0.200
     0.526    -0.490     0.200
     0.599     0.036     0.200
     0.569     0.184     0.200
     0.605    -0.174     0.200
     0.615     0.205     0.200
     0.602     0.122     0.200
     0.688    -0.302     0.200
     0.644     0.275     0.200
     0.655     0.093     0.200
     0.677    -0.084     0.200
     0.721    -0.199     0.200
     0.843    -0.069     0.200
     0.895    -0.116     0.200
     0.878    -0.320     0.200
     0.905    -0.143     0.200
     0.908    -0.247     0.200
     0.908    -0.357     0.200
     0.985    -0.285     0.200
     0.994    -0.313     0.200
     0.021    -0.607     0.200
     0.130    -0.084     0.200
     0.185    -0.084     0.200
     0.199    -0.118     0.200
     0.206     0.651     0.200
     0.205     0.317     0.200
     0.215     0.088     0.200
     0.249     0.283     0.200
     0.257     0.402     0.200
     0.327    -0.392     0.200
     0.338    -0.020     0.200
     0.353     0.396     0.200
     0.375    -0.213     0.200
     0.390    -0.356     0.200
     0.409     0.242     0.200
     0.435    -0.246     0.200
     0.465    -0.409     0.200
     0.501     0.158     0.200
     0.528    -0.534     0.200
     0.571     0.230     0.200
     0.569    -0.182     0.200
     0.639     0.206     0.200
     0.657    -0.227     0.200
     0.680     0.277     0.200
     0.687     0.095     0.200
     0.725    -0.192     0.200
     0.800     0.211     0.200
     0.894     0.005     0.200
     0.897    -0.414     0.200
     0.922     0.148     0.200
     0.925    -0.268     0.200
     0.925    -0.378     0.200
     0.965     0.054     0.200
     0.050    -0.600     0.200
     0.081     2.173     0.200
     0.203    -0.444     0.200
     0.245    -0.776     0.200
     0.338     0.282     0.200
     0.309    -0.243     0.200
     0.313    -0.262     0.200
     0.301     0.224     0.200
     0.368     0.329     0.200
     0.364    -0.001     0.200
     0.414     0.335     0.200
     0.467    -0.286     0.200
     0.488    -0.016     0.200
     0.528    -0.015     0.200
     0.561     0.133     0.200
     0.520    -0.009     0.200
     0.562    -0.433     0.200
     0.618    -0.264     0.200
     0.694    -0.053     0.200
     0.660    -0.381     0.200
     0.724     0.251     0.200
     0.793    -0.203     0.200
     0.832    -0.174     0.200
     0.819    -0.733     0.200
     0.932    -0.193     0.200
     0.017    -0.432     0.200
     0.067    -0.740     0.200
     0.143    -0.058     0.200
     0.224    -0.320     0.200
     0.281     0.244     0.200
     0.273    -0.776     0.200
     0.277    -0.156     0.200
     0.280    -0.143     0.200
     0.352    -0.028     0.200
     0.400     0.265     0.200
     0.412    -0.049     0.200
     0.464     0.065     0.200
     0.496    -0.371     0.200
     0.523    -0.171     0.200
     0.535    -0.362     0.200
     0.529     0.009     0.200
     0.587    -0.260     0.200
     0.567     0.130     0.200
     0.679    -0.329     0.200
     0.673    -0.098     0.200
     0.691     0.267     0.200
     0.804    -0.628     0.200
     0.824    -0.503     0.200
     0.824     0.020     0.200
     0.878     0.275     0.200
     0.929     0.393     0.200
     0.231    -0.232     0.200
     0.236     0.042     0.200
     0.269    -0.045     0.200
     0.273     0.561     0.200
     0.306    -0.261     0.200
     0.293    -0.030     0.200
     0.313    -0.074     0.200
     0.336     0.155     0.200
     0.341    -0.250     0.200
     0.352     0.633     0.200
     0.419    -0.237     0.200
     0.429     0.057     0.200
     0.449     0.112     0.200
     0.454    -0.241     0.200
     0.456    -0.275     0.200
     0.457    -0.251     0.200
     0.472    -0.163     0.200
     0.458    -0.033     0.200
     0.502     0.420     0.200
     0.503    -0.106     0.200
     0.539    -0.028     0.200
     0.534    -0.084     0.200
     0.603     0.090     0.200
     0.626     0.338     0.200
     0.627     0.039     0.200
     0.636    -0.014     0.200
     0.652     0.232     0.200
     0.681    -0.089     0.200
     0.671     0.230     0.200
     0.673    -0.067     0.200
     0.690     0.057     0.200
     0.683     0.218     0.200
     0.697     0.144     0.200
     0.735     0.396     0.200
     0.773    -0.530     0.200
     0.775     0.243     0.200
     0.801     0.231     0.200
     0.791     0.498     0.200
     0.809    -0.126     0.200
     0.820     0.728     0.200
     0.823    -0.104     0.200
     0.831     0.992     0.200
     0.842     0.422     0.200
     0.839     0.631     0.200
     0.895     0.025     0.200
     0.910     0.429     0.200
     0.933     0.615     0.200
     0.984     0.189     0.200
     0.979     0.880     0.200
     0.229    -0.316     0.200
     0.233    -0.287     0.200
     0.391     0.089     0.200
     0.440     0.046     0.200
     0.437    -0.310     0.200
     0.450     0.024     0.200
     0.453     0.023     0.200
     0.495    -0.721     0.200
     0.498    -0.684     0.200
     0.506    -0.189     0.200
     0.541    -0.481     0.200
     0.499     0.315     0.200
     0.566     0.462     0.200
     0.586     0.391     0.200
     0.639    -0.201     0.200
     0.652     0.234     0.200
     0.648    -0.270     0.200
     0.654    -0.201     0.200
     0.659    -0.125     0.200
     0.656    -0.237     0.200
     0.672    -0.338     0.200
     0.651    -0.190     0.200
     0.667     0.417     0.200
     0.704    -0.037     0.200
     0.711     0.575     0.200
     0.733    -0.025     0.200
     0.760     0.070     0.200
     0.788     0.514     0.200
     0.729     1.039     0.200
     0.800     0.411     0.200
     0.827    -0.044     0.200
     0.839    -0.226     0.200
     0.855     0.082     0.200
     0.859     0.294     0.200
     0.895    -0.213     0.200
     0.912     0.189     0.200
     0.912     0.401     0.200
     0.912     0.658     0.200
     0.923     0.055     0.200
     0.936     0.348     0.200
     0.916     0.645     0.200
     0.940     0.353     0.200
     0.968     0.358     0.200
     0.955     1.293     0.200
     0.955     1.939     0.200
     0.011    -1.515     0.200
     0.011    -0.696     0.200
     0.071    -0.595     0.200
     0.095    -0.332     0.200
     0.112    -0.333     0.200
     0.151     0.068     0.200
     0.194     0.243     0.200
     0.203     0.265     0.200
     0.215    -0.283     0.200
     0.262    -0.676     0.200
     0.288     0.358     0.200
     0.289    -0.186     0.200
     0.293    -0.127     0.200
     0.328     0.485     0.200
     0.425    -0.126     0.200
     0.485    -0.266     0.200
     0.468     0.160     0.200
     0.520    -0.144     0.200
     0.574    -0.513     0.200
     0.535    -0.044     0.200
     0.545    -0.449     0.200
     0.568    -0.190     0.200
     0.599    -0.543     0.200
     0.647     0.185     0.200
     0.605     0.257     0.200
     0.672    -0.710     0.200
     0.611    -0.071     0.200
     0.626    -0.003     0.200
     0.690    -0.120     0.200
     0.644    -0.481     0.200
     0.706     0.015     0.200
     0.680    -0.204     0.200
     0.681    -0.199     0.200
     0.705     0.256     0.200
     0.703     0.124     0.200
     0.774    -0.439     0.200
     0.725    -0.266     0.200
     0.760     0.034     0.200
     0.808    -0.829     0.200
     0.794    -0.005     0.200
     0.789    -0.294     0.200
     0.813     0.210     0.200
     0.826    -0.137     0.200
     0.835     0.106     0.200
     0.854     0.069     0.200
     0.873     0.078     0.200
     0.869     0.063     0.200
     0.885     0.123     0.200
     0.885     0.068     0.200
     0.893     0.169     0.200
     0.898    -0.171     0.200
     0.907     0.175     0.200
     0.914    -0.176     0.200
     0.933     0.193     0.200
     0.935     0.048     0.200
     0.007    -0.698     0.200
     0.069     1.440     0.200
     0.112    -0.487     0.200
     0.099    -0.448     0.200
     0.195     0.033     0.200
     0.204     0.273     0.200
     0.285    -0.369     0.200
     0.286     0.205     0.200
     0.289    -0.400     0.200
     0.346     0.203     0.200
     0.326     0.511     0.200
     0.355     0.064     0.200
     0.403     0.124     0.200
     0.367     0.239     0.200
     0.421    -0.287     0.200
     0.432     0.440     0.200
     0.488    -0.859     0.200
     0.522    -0.142     0.200
     0.542    -0.593     0.200
     0.542     0.293     0.200
     0.536     0.039     0.200
     0.523    -0.189     0.200
     0.537     0.051     0.200
     0.576    -0.476     0.200
     0.565    -0.070     0.200
     0.622     0.078     0.200
     0.609     0.234     0.200
     0.603     1.295     0.200
     0.647     0.086     0.200
     0.646     0.345     0.200
     0.643    -0.363     0.200
     0.678    -0.509     0.200
     0.674    -0.524     0.200
     0.691    -0.024     0.200
     0.699     0.292     0.200
     0.710     0.115     0.200
     0.775    -0.440     0.200
     0.806    -0.788     0.200
     0.788    -0.135     0.200
     0.794     0.067     0.200
     0.811     0.137     0.200
     0.825    -0.668     0.200
     0.852     0.009     0.200
     0.875     0.111     0.200
     0.932    -0.115     0.200
     0.961    -0.079     0.200
     0.047     1.119     0.200
     0.048    -0.885     0.200
     0.063    -0.851     0.200
     0.110     1.447     0.200
     0.118    -0.355     0.200
     0.150    -0.219     0.200
     0.232    -0.389     0.200
     0.222     0.343     0.200
     0.251     0.128     0.200
     0.260    -0.265     0.200
     0.297     0.144     0.200
     0.332     0.097     0.200
     0.332    -0.071     0.200
     0.369    -0.280     0.200
     0.376     0.510     0.200
     0.388     0.229     0.200
     0.391     0.648     0.200
     0.434     0.100     0.200
     0.500    -0.004     0.200
     0.495    -0.554     0.200
     0.508     0.029     0.200
     0.512    -0.319     0.200
     0.523    -0.213     0.200
     0.537     0.401     0.200
     0.538    -0.430     0.200
     0.579     0.129     0.200
     0.566    -0.058     0.200
     0.566     0.007     0.200
     0.594    -0.123     0.200
     0.586    -0.077     0.200
     0.591    -0.477     0.200
     0.617     1.248     0.200
     0.623    -0.396     0.200
     0.628     0.183     0.200
     0.621     0.555     0.200
     0.647    -0.282     0.200
     0.655    -0.170     0.200
     0.660     0.401     0.200
     0.638     0.090     0.200
     0.664     0.400     0.200
     0.647     0.190     0.200
     0.689    -0.200     0.200
     0.697    -0.808     0.200
     0.752     0.000     0.200
     0.759     0.329     0.200
     0.777    -1.169     0.200
     0.790    -0.384     0.200
     0.786    -0.528     0.200
     0.823    -0.653     0.200
     0.823    -0.024     0.200
     0.853    -0.019     0.200
     0.860    -0.026     0.200
     0.896     0.053     0.200
     0.905    -0.003     0.200
     0.920     0.055     0.200
     0.923    -0.441     0.200
     0.913    -0.380     0.200
     0.934     0.050     0.200
     0.936    -0.080     0.200
     0.974    -0.179     0.200
     0.029    -1.861     0.200
     0.051    -1.778     0.200
     0.033    -1.785     0.200
     0.098    -1.205     0.200
     0.135    -0.865     0.200
     0.220    -0.001     0.200
     0.251    -0.585     0.200
     0.286    -0.763     0.200
     0.330     0.025     0.200
     0.322    -0.296     0.200
     0.377     0.249     0.200
     0.399     0.401     0.200
     0.452    -0.208     0.200
     0.506    -0.621     0.200
     0.483     0.479     0.200
     0.519     0.058     0.200
     0.531    -0.078     0.200
     0.525    -0.168     0.200
     0.540     0.309     0.200
     0.524    -0.388     0.200
     0.556     0.192     0.200
     0.563     0.147     0.200
     0.599    -0.142     0.200
     0.576    -0.295     0.200
     0.608    -0.058     0.200
     0.642    -0.359     0.200
     0.642    -0.211     0.200
     0.631    -0.119     0.200
     0.620     0.719     0.200
     0.624     0.646     0.200
     0.664     0.008     0.200
     0.655    -0.171     0.200
     0.671    -0.382     0.200
     0.680     0.359     0.200
     0.739     0.737     0.200
     0.778    -0.286     0.200
     0.795     0.007     0.200
     0.806     0.028     0.200
     0.815    -0.014     0.200
     0.799    -0.472     0.200
     0.824    -0.004     0.200
     0.799     0.493     0.200
     0.825    -0.124     0.200
     0.813    -0.033     0.200
     0.833    -0.274     0.200
     0.833     0.059     0.200
     0.831     0.072     0.200
     0.833    -0.461     0.200
     0.855     0.009     0.200
     0.873    -0.180     0.200
     0.880    -0.068     0.200
     0.884     0.125     0.200
     0.884     0.171     0.200
     0.904     0.190     0.200
     0.909     0.314     0.200
     0.897     0.053     0.200
     0.915     0.117     0.200
     0.909     0.386     0.200
     0.902     0.193     0.200
     0.924    -0.163     0.200
     0.935    -0.353     0.200
     0.951     0.186     0.200
     0.959     0.227     0.200
     0.946    -0.121     0.200
     0.965     0.626     0.200
     0.995     0.311     0.200
     0.995    -0.075     0.200
     0.026    -0.747     0.200
     0.030     0.701     0.200
     0.053    -0.757     0.200
     0.100    -0.394     0.200
     0.122    -0.126     0.200
     0.167     0.472     0.200
     0.258    -0.277     0.200
     0.285    -0.571     0.200
     0.314     0.242     0.200
     0.324     0.265     0.200
     0.324    -0.071     0.200
     0.333     0.081     0.200
     0.391    -0.206     0.200
     0.380     0.405     0.200
     0.385     0.284     0.200
     0.402     0.593     0.200
     0.452     0.075     0.200
     0.510    -0.529     0.200
     0.521     0.087     0.200
     0.525    -0.012     0.200
     0.515    -0.285     0.200
     0.534    -0.220     0.200
     0.521    -0.238     0.200
     0.544     0.108     0.200
     0.562    -0.553     0.200
     0.553     0.056     0.200
     0.560    -0.034     0.200
     0.584     0.063     0.200
     0.577    -0.508     0.200
     0.600    -0.020     0.200
     0.607    -0.116     0.200
     0.618     1.272     0.200
     0.621     0.353     0.200
     0.642     0.183     0.200
     0.645    -0.255     0.200
     0.634    -0.384     0.200
     0.653    -0.224     0.200
     0.670    -0.136     0.200
     0.681     0.287     0.200
     0.683     0.341     0.200
     0.667     0.082     0.200
     0.681    -0.214     0.200
     0.681    -0.490     0.200
     0.736     0.382     0.200
     0.762    -0.031     0.200
     0.782    -0.999     0.200
     0.774    -0.554     0.200
     0.797     0.506     0.200
     0.797    -0.170     0.200
     0.797     0.534     0.200
     0.806     0.031     0.200
     0.816     0.082     0.200
     0.810     0.061     0.200
     0.821    -0.071     0.200
     0.831    -0.198     0.200
     0.829    -0.071     0.200
     0.831    -0.058     0.200
     0.855    -0.066     0.200
     0.855    -0.107     0.200
     0.874    -0.115     0.200
     0.882     0.300     0.200
     0.883     0.005     0.200
     0.883     0.052     0.200
     0.894    -0.200     0.200
     0.903    -0.006     0.200
     0.899    -0.079     0.200
     0.906     0.475     0.200
     0.914     0.133     0.200
     0.922    -0.183     0.200
     0.932     0.015     0.200
     0.934     0.074     0.200
     0.945    -0.138     0.200
     0.951    -0.050     0.200
     0.996    -0.339     0.200
     0.030    -0.858     0.200
     0.054    -0.751     0.200
     0.101    -0.408     0.200
     0.121    -0.136     0.200
     0.135    -0.259     0.200
     0.249    -0.251     0.200
     0.217     0.242     0.200
     0.254    -0.247     0.200
     0.227     0.116     0.200
     0.257     0.185     0.200
     0.250    -0.255     0.200
     0.311     0.302     0.200
     0.289    -0.691     0.200
     0.325    -0.213     0.200
     0.333    -0.050     0.200
     0.322     0.236     0.200
     0.379     0.337     0.200
     0.387    -0.142     0.200
     0.400     0.497     0.200
     0.386     0.139     0.200
     0.449     0.062     0.200
     0.507    -0.385     0.200
     0.480     0.222     0.200
     0.516    -0.203     0.200
     0.530     0.029     0.200
     0.522     0.109     0.200
     0.542     0.103     0.200
     0.559    -0.241     0.200
     0.524    -0.095     0.200
     0.555     0.111     0.200
     0.561    -0.010     0.200
     0.579    -0.400     0.200
     0.596     0.113     0.200
     0.584     0.033     0.200
     0.605    -0.001     0.200
     0.641    -0.073     0.200
     0.618     0.617     0.200
     0.634     0.175     0.200
     0.621     0.255     0.200
     0.639     0.335     0.200
     0.668    -0.010     0.200
     0.664     0.313     0.200
     0.677     0.152     0.200
     0.680     0.237     0.200
     0.684    -0.386     0.200
     0.740     0.449     0.200
     0.781    -0.603     0.200
     0.793     0.042     0.200
     0.776    -0.503     0.200
     0.796    -0.271     0.200
     0.818    -0.010     0.200
     0.796     0.470     0.200
     0.822     0.053     0.200
     0.810     0.063     0.200
     0.830    -0.071     0.200
     0.852     0.008     0.200
     0.870    -0.041     0.200
     0.878     0.067     0.200
     0.894    -0.226     0.200
     0.968    -0.477     0.200
     0.993    -0.177     0.200
     0.029    -0.846     0.200
     0.036    -1.395     0.200
     0.093     2.171     0.200
     0.139     1.591     0.200
     0.271    -0.405     0.200
     0.298     0.192     0.200
     0.291     0.169     0.200
     0.299    -0.741     0.200
     0.343     0.257     0.200
     0.344     0.078     0.200
     0.363    -0.187     0.200
     0.375    -0.104     0.200
     0.400    -0.257     0.200
     0.421     0.192     0.200
     0.430     0.242     0.200
     0.439     0.536     0.200
     0.439     0.098     0.200
     0.501     0.233     0.200
     0.495    -0.310     0.200
     0.536     0.356     0.200
     0.541    -0.381     0.200
     0.542    -0.052     0.200
     0.519    -0.086     0.200
     0.518     0.050     0.200
     0.553    -0.163     0.200
     0.542     0.012     0.200
     0.585    -0.271     0.200
     0.584    -0.432     0.200
     0.574    -0.045     0.200
     0.592     0.085     0.200
     0.577     0.664     0.200
     0.580     0.316     0.200
     0.611     0.142     0.200
     0.610    -0.384     0.200
     0.613    -0.282     0.200
     0.643     0.166     0.200
     0.659    -0.105     0.200
     0.666     0.402     0.200
     0.669     0.352     0.200
     0.674    -0.189     0.200
     0.684     0.318     0.200
     0.709    -0.255     0.200
     0.721    -0.043     0.200
     0.725    -0.034     0.200
     0.738     0.342     0.200
     0.757     0.079     0.200
     0.769     0.063     0.200
     0.809    -0.512     0.200
     0.852    -0.146     0.200
     0.953    -0.708     0.200
     0.978    -0.204     0.200
     0.039    -0.835     0.200
     0.054    -0.806     0.200
     0.102    -0.465     0.200
     0.115    -0.203     0.200
     0.144    -0.264     0.200
     0.223     0.203     0.200
     0.258    -0.295     0.200
     0.240    -0.286     0.200
     0.245    -0.233     0.200
     0.250     0.177     0.200
     0.296    -0.694     0.200
     0.302     0.304     0.200
     0.321     0.278     0.200
     0.324    -0.132     0.200
     0.328    -0.023     0.200
     0.378    -0.190     0.200
     0.393     0.528     0.200
     0.444     0.081     0.200
     0.499    -0.395     0.200
     0.509     0.127     0.200
     0.519     0.092     0.200
     0.533    -0.142     0.200
     0.516    -0.181     0.200
     0.522    -0.040     0.200
     0.563     0.099     0.200
     0.567    -0.069     0.200
     0.550    -0.413     0.200
     0.589     0.075     0.200
     0.581    -0.397     0.200
     0.590     0.076     0.200
     0.603    -0.016     0.200
     0.621     0.908     0.200
     0.625     0.400     0.200
     0.637     0.312     0.200
     0.632    -0.156     0.200
     0.632     0.155     0.200
     0.665    -0.009     0.200
     0.671     0.287     0.200
     0.655     0.201     0.200
     0.682    -0.166     0.200
     0.687    -0.406     0.200
     0.748     0.374     0.200
     0.777    -0.485     0.200
     0.775    -0.676     0.200
     0.797    -0.190     0.200
     0.785     0.281     0.200
     0.812    -0.007     0.200
     0.814     0.113     0.200
     0.830    -0.058     0.200
     0.848     0.056     0.200
     0.864    -0.012     0.200
     0.870     0.003     0.200
     0.898    -0.194     0.200
     0.908     0.084     0.200
     0.985    -0.140     0.200
     0.028    -0.203     0.200
     0.031     0.426     0.200
     0.074     1.813     0.200
     0.140    -0.042     0.200
     0.198     0.260     0.200
     0.235    -0.381     0.200
     0.255    -0.442     0.200
     0.257    -0.457     0.200
     0.303     0.318     0.200
     0.275     0.187     0.200
     0.322     0.296     0.200
     0.366     0.085     0.200
     0.345    -0.133     0.200
     0.353     0.029     0.200
     0.387    -0.294     0.200
     0.399     0.343     0.200
     0.435     0.024     0.200
     0.460     0.353     0.200
     0.507     0.137     0.200
     0.521     0.345     0.200
     0.530    -0.059     0.200
     0.520    -0.456     0.200
     0.514    -0.109     0.200
     0.542    -0.018     0.200
     0.540     0.191     0.200
     0.564     0.021     0.200
     0.536    -0.223     0.200
     0.566    -0.411     0.200
     0.597     0.511     0.200
     0.622     0.262     0.200
     0.597    -0.421     0.200
     0.651     0.062     0.200
     0.668     0.365     0.200
     0.668     0.286     0.200
     0.655    -0.155     0.200
     0.703    -0.136     0.200
     0.700    -0.358     0.200
     0.775    -0.169     0.200
     0.810    -0.323     0.200
     0.800    -0.735     0.200
     0.795    -0.498     0.200
     0.987    -0.382     0.200
     0.042    -0.192     0.200
     0.050    -1.020     0.200
     0.111    -0.404     0.200
     0.099    -0.346     0.200
     0.163     0.350     0.200
     0.157    -0.182     0.200
     0.183     0.176     0.200
     0.155     0.177     0.200
     0.165     0.240     0.200
     0.194    -0.562     0.200
     0.287    -0.212     0.200
     0.287    -0.192     0.200
     0.280     0.294     0.200
     0.302    -0.911     0.200
     0.324     0.280     0.200
     0.362     0.234     0.200
     0.412    -0.089     0.200
     0.427     0.104     0.200
     0.441     0.309     0.200
     0.419     0.775     0.200
     0.496    -0.062     0.200
     0.478    -0.374     0.200
     0.499    -0.008     0.200
     0.499    -0.187     0.200
     0.523    -0.047     0.200
     0.554    -0.252     0.200
     0.561    -0.534     0.200
     0.563    -0.268     0.200
     0.569    -0.348     0.200
     0.561     0.133     0.200
     0.595     0.206     0.200
     0.601    -0.452     0.200
     0.622    -0.518     0.200
     0.635    -0.171     0.200
     0.672    -0.285     0.200
     0.664     0.212     0.200
     0.671     0.109     0.200
     0.699     0.110     0.200
     0.712    -0.291     0.200
     0.718    -0.470     0.200
     0.733     0.156     0.200
     0.741    -0.148     0.200
     0.750     0.179     0.200
     0.778    -0.175     0.200
     0.776    -0.090     0.200
     0.778    -0.504     0.200
     0.822    -0.774     0.200
     0.843    -0.821     0.200
     0.832    -0.395     0.200
     0.838     0.115     0.200
     0.872    -0.165     0.200
     0.887     0.017     0.200
     0.885     0.356     0.200
     0.893    -0.035     0.200
     0.919     0.126     0.200
     0.967    -0.056     0.200
     0.963     0.118     0.200
     0.960    -0.231     0.200
     0.999    -0.238     0.200
     0.999     0.104     0.200
     0.043    -1.566     0.200
     0.051    -1.383     0.200
     0.098    -0.529     0.200
     0.113    -0.429     0.200
     0.154     0.130     0.200
     0.158    -0.183     0.200
     0.185     0.081     0.200
     0.192    -0.418     0.200
     0.280     0.165     0.200
     0.289    -0.245     0.200
     0.301    -0.744     0.200
     0.320     0.277     0.200
     0.323     0.222     0.200
     0.363     0.322     0.200
     0.396     0.052     0.200
     0.413    -0.164     0.200
     0.418     0.329     0.200
     0.427     0.089     0.200
     0.443     0.300     0.200
     0.461     0.577     0.200
     0.477    -0.367     0.200
     0.496    -0.001     0.200
     0.497    -0.018     0.200
     0.497    -0.136     0.200
     0.521     0.021     0.200
     0.555    -0.169     0.200
     0.557     0.996     0.200
     0.563    -0.189     0.200
     0.562    -0.502     0.200
     0.560     0.534     0.200
     0.570    -0.255     0.200
     0.596    -0.035     0.200
     0.602     0.162     0.200
     0.602    -0.437     0.200
     0.606     0.675     0.200
     0.623    -0.419     0.200
     0.635    -0.087     0.200
     0.664     0.248     0.200
     0.672     0.189     0.200
     0.673    -0.266     0.200
     0.693    -0.262     0.200
     0.700     0.137     0.200
     0.719    -0.437     0.200
     0.736     0.446     0.200
     0.740    -0.263     0.200
     0.732     0.128     0.200
     0.738    -0.384     0.200
     0.748     0.221     0.200
     0.766     0.176     0.200
     0.770    -1.252     0.200
     0.777    -0.201     0.200
     0.775    -0.086     0.200
     0.805    -0.084     0.200
     0.810    -0.011     0.200
     0.813     0.112     0.200
     0.824     0.116     0.200
     0.826     0.038     0.200
     0.823    -0.587     0.200
     0.831    -0.082     0.200
     0.836     0.230     0.200
     0.844    -0.525     0.200
     0.865    -0.037     0.200
     0.894    -0.125     0.200
     0.958    -0.160     0.200
     0.961    -0.163     0.200
     0.973    -0.152     0.200
     0.184     0.030     0.200
     0.165     0.129     0.200
     0.282    -0.359     0.200
     0.282    -0.289     0.200
     0.273     0.196     0.200
     0.309    -0.900     0.200
     0.318     0.229     0.200
     0.322     0.245     0.200
     0.405    -0.132     0.200
     0.419    -0.010     0.200
     0.443     0.262     0.200
     0.458     0.483     0.200
     0.483    -0.271     0.200
     0.488    -0.120     0.200
     0.520    -0.097     0.200
     0.547    -0.234     0.200
     0.558    -0.577     0.200
     0.574    -0.085     0.200
     0.555     0.821     0.200
     0.556    -0.204     0.200
     0.558     0.299     0.200
     0.596    -0.427     0.200
     0.587    -0.028     0.200
     0.595    -0.208     0.200
     0.628    -0.610     0.200
     0.628    -0.260     0.200
     0.656     0.049     0.200
     0.666    -0.109     0.200
     0.663    -0.123     0.200
     0.696     0.022     0.200
     0.725    -0.566     0.200
     0.693     0.529     0.200
     0.706    -0.294     0.200
     0.742    -0.313     0.200
     0.740     0.231     0.200
     0.736    -0.058     0.200
     0.746     0.350     0.200
     0.765     0.088     0.200
     0.773    -0.285     0.200
     0.773    -0.166     0.200
     0.805    -0.048     0.200
     0.844    -0.017     0.200
     0.830     0.101     0.200
     0.837     0.055     0.200
     0.843     0.213     0.200
     0.859     0.130     0.200
     0.879     0.257     0.200
     0.930     0.325     0.200
     0.956    -0.215     0.200
     0.961    -0.113     0.200
     0.992     0.134     0.200
     0.992    -0.069     0.200
     0.992    -0.116     0.200
     0.047    -0.681     0.200
     0.055     0.221     0.200
     0.114    -0.336     0.200
     0.155     0.095     0.200
     0.166     0.044     0.200
     0.183     0.125     0.200
     0.198    -0.447     0.200
     0.273     0.290     0.200
     0.281    -0.225     0.200
     0.281    -0.244     0.200
     0.317     0.213     0.200
     0.310    -0.807     0.200
     0.323     0.238     0.200
     0.357     0.205     0.200
     0.404    -0.105     0.200
     0.396     0.011     0.200
     0.419     0.155     0.200
     0.417     0.405     0.200
     0.442     0.323     0.200
     0.457     0.479     0.200
     0.488     0.076     0.200
     0.484    -0.358     0.200
     0.499    -0.094     0.200
     0.502    -0.187     0.200
     0.521    -0.043     0.200
     0.546    -0.148     0.200
     0.557    -0.499     0.200
     0.556    -0.231     0.200
     0.555     0.768     0.200
     0.558     0.261     0.200
     0.586    -0.037     0.200
     0.574    -0.237     0.200
     0.595     0.051     0.200
     0.592    -0.555     0.200
     0.627    -0.189     0.200
     0.628    -0.477     0.200
     0.655     0.107     0.200
     0.662     0.195     0.200
     0.665    -0.193     0.200
     0.696     0.116     0.200
     0.706    -0.179     0.200
     0.692     0.305     0.200
     0.726    -0.334     0.200
     0.734     0.588     0.200
     0.737    -0.469     0.200
     0.742    -0.122     0.200
     0.747     0.396     0.200
     0.741     0.131     0.200
     0.759     0.115     0.200
     0.773     0.127     0.200
     0.771     0.040     0.200
     0.773    -0.170     0.200
     0.786     0.071     0.200
     0.800    -0.137     0.200
     0.804     0.107     0.200
     0.800    -0.054     0.200
     0.815     0.063     0.200
     0.818    -0.015     0.200
     0.828    -0.616     0.200
     0.831    -0.198     0.200
     0.843    -1.247     0.200
     0.838     0.445     0.200
     0.844     0.659     0.200
     0.856    -0.082     0.200
     0.859     0.276     0.200
     0.866    -0.004     0.200
     0.885    -0.038     0.200
     0.880     0.171     0.200
     0.879    -0.139     0.200
     0.887     0.001     0.200
     0.911     0.022     0.200
     0.929     0.151     0.200
     0.961    -0.028     0.200
     0.957    -0.179     0.200
     0.991     0.187     0.200
     0.992     0.018     0.200
     0.992    -0.111     0.200
     0.190    -0.334     0.200
     0.299     0.055     0.200
     0.306     0.091     0.200
     0.307    -0.193     0.200
     0.321     0.448     0.200
     0.322     0.534     0.200
     0.333     0.098     0.200
     0.346     0.032     0.200
     0.362     0.475     0.200
     0.378     0.084     0.200
     0.422    -0.471     0.200
     0.422    -0.183     0.200
     0.427    -0.469     0.200
     0.430    -0.446     0.200
     0.447     0.536     0.200
     0.471    -0.341     0.200
     0.535    -0.208     0.200
     0.544    -0.435     0.200
     0.551     0.223     0.200
     0.580     0.502     0.200
     0.586    -0.289     0.200
     0.589    -0.088     0.200
     0.667    -0.347     0.200
     0.677    -0.223     0.200
     0.715    -0.163     0.200
     0.718    -0.291     0.200
     0.721     0.157     0.200
     0.736     0.175     0.200
     0.743     0.245     0.200
     0.744    -0.039     0.200
     0.818     0.118     0.200
     0.812     0.419     0.200
     0.828     0.083     0.200
     0.839     0.271     0.200
     0.858    -0.013     0.200
     0.884     0.152     0.200
     0.893     0.535     0.200
     0.921     0.125     0.200
     0.918     0.452     0.200
     0.952    -0.242     0.200
     0.950     0.406     0.200
     0.966     0.267     0.200
     0.976     0.263     0.200
     0.999     0.738     0.200
     0.050    -0.959     0.200
     0.052    -0.972     0.200
     0.063    -0.883     0.200
     0.110    -0.552     0.200
     0.116    -0.222     0.200
     0.154    -0.315     0.200
     0.228    -0.560     0.200
     0.225     0.273     0.200
     0.232    -0.507     0.200
     0.235     0.208     0.200
     0.248     0.144     0.200
     0.264    -0.263     0.200
     0.293     0.277     0.200
     0.309    -0.837     0.200
     0.330     0.092     0.200
     0.331    -0.125     0.200
     0.365    -0.175     0.200
     0.374     0.500     0.200
     0.390    -0.012     0.200
     0.433     0.032     0.200
     0.491    -0.376     0.200
     0.483     0.335     0.200
     0.496     0.243     0.200
     0.509    -0.024     0.200
     0.516     0.219     0.200
     0.507     0.052     0.200
     0.534     0.525     0.200
     0.539    -0.373     0.200
     0.542    -0.065     0.200
     0.569     0.176     0.200
     0.569     0.032     0.200
     0.576     0.197     0.200
     0.591    -0.340     0.200
     0.588     0.080     0.200
     0.594     0.077     0.200
     0.620    -0.130     0.200
     0.623     0.432     0.200
     0.637    -0.155     0.200
     0.628     0.384     0.200
     0.654     0.099     0.200
     0.658     0.286     0.200
     0.643     0.270     0.200
     0.662     0.405     0.200
     0.688    -0.152     0.200
     0.698    -0.419     0.200
     0.762     0.575     0.200
     0.774    -0.771     0.200
     0.786    -0.431     0.200
     0.792    -0.066     0.200
     0.797     0.533     0.200
     0.824    -0.127     0.200
     0.911    -0.454     0.200
     0.913    -0.193     0.200
     0.170    -0.394     0.200
     0.167    -0.521     0.200
     0.128    -0.401     0.200
     0.128    -0.727     0.200
     0.155    -0.195     0.200
     0.216    -0.434     0.200
     0.174    -0.114     0.200
     0.203    -0.336     0.200
     0.265    -0.262     0.200
     0.330    -0.247     0.200
     0.330    -0.237     0.200
     0.332    -0.171     0.200
     0.297    -0.048     0.200
     0.283     0.219     0.200
     0.318    -0.351     0.200
     0.371    -0.121     0.200
     0.405    -0.096     0.200
     0.332     0.203     0.200
     0.402    -0.140     0.200
     0.345    -0.209     0.200
     0.351     0.518     0.200
     0.388     0.162     0.200
     0.436     0.214     0.200
     0.490    -0.234     0.200
     0.498    -0.245     0.200
     0.535    -0.160     0.200
     0.457     0.131     0.200
     0.541     0.050     0.200
     0.464     0.252     0.200
     0.515     0.338     0.200
     0.539    -0.238     0.200
     0.514     0.073     0.200
     0.496     0.090     0.200
     0.513     0.440     0.200
     0.596    -0.172     0.200
     0.542     0.693     0.200
     0.579     0.440     0.200
     0.637    -0.338     0.200
     0.611     0.465     0.200
     0.612     0.442     0.200
     0.578     0.395     0.200
     0.638     0.543     0.200
     0.663     0.029     0.200
     0.679    -0.168     0.200
     0.670    -0.054     0.200
     0.644     0.251     0.200
     0.637    -0.090     0.200
     0.681    -0.113     0.200
     0.717     0.088     0.200
     0.726     0.063     0.200
     0.742    -0.181     0.200
     0.698     0.546     0.200
     0.761     0.028     0.200
     0.748    -0.120     0.200
     0.763    -0.226     0.200
     0.752    -0.000     0.200
     0.743     0.429     0.200
     0.780    -0.052     0.200
     0.760    -0.012     0.200
     0.794     0.384     0.200
     0.820    -0.008     0.200
     0.813     0.083     0.200
     0.823     0.045     0.200
     0.839     0.308     0.200
     0.830     0.373     0.200
     0.854    -0.113     0.200
     0.850    -0.031     0.200
     0.878     0.095     0.200
     0.888     0.279     0.200
     0.907     0.154     0.200
     0.917     0.066     0.200
     0.916     0.250     0.200
     0.922     0.090     0.200
     0.943    -0.308     0.200
     0.963     0.209     0.200
     0.105     0.230     0.200
     0.140     0.096     0.200
     0.133     0.103     0.200
     0.171    -0.099     0.200
     0.197    -0.257     0.200
     0.192     0.252     0.200
     0.221     0.224     0.200
     0.245     0.424     0.200
     0.269    -0.172     0.200
     0.263     0.127     0.200
     0.277     0.082     0.200
     0.293    -0.277     0.200
     0.296    -0.368     0.200
     0.306    -0.244     0.200
     0.329    -0.097     0.200
     0.331    -0.101     0.200
     0.317     0.200     0.200
     0.343    -0.148     0.200
     0.344    -0.122     0.200
     0.340     0.064     0.200
     0.372    -0.171     0.200
     0.385    -0.082     0.200
     0.389    -0.123     0.200
     0.389     0.036     0.200
     0.386     0.104     0.200
     0.405    -0.139     0.200
     0.400    -0.025     0.200
     0.396     0.390     0.200
     0.396     0.019     0.200
     0.410     0.579     0.200
     0.438     0.017     0.200
     0.434     0.008     0.200
     0.440    -0.042     0.200
     0.463     0.348     0.200
     0.454    -0.220     0.200
     0.469     0.020     0.200
     0.470    -0.888     0.200
     0.469    -0.093     0.200
     0.477    -0.239     0.200
     0.465     0.120     0.200
     0.482     0.276     0.200
     0.475     0.193     0.200
     0.499    -0.300     0.200
     0.511     0.179     0.200
     0.503    -0.023     0.200
     0.523    -0.045     0.200
     0.527     0.348     0.200
     0.577     0.550     0.200
     0.555     0.850     0.200
     0.562     0.120     0.200
     0.581     0.429     0.200
     0.575     0.928     0.200
     0.576     0.472     0.200
     0.586     0.177     0.200
     0.613    -0.018     0.200
     0.620     0.200     0.200
     0.640     0.211     0.200
     0.657     0.620     0.200
     0.652    -0.083     0.200
     0.646     0.289     0.200
     0.643     0.628     0.200
     0.650     0.584     0.200
     0.661     0.373     0.200
     0.665     0.385     0.200
     0.684     0.360     0.200
     0.692    -0.185     0.200
     0.709     0.778     0.200
     0.705     0.565     0.200
     0.705     0.983     0.200
     0.706     0.704     0.200
     0.716     0.315     0.200
     0.715     0.269     0.200
     0.731     0.523     0.200
     0.743    -0.094     0.200
     0.746     0.868     0.200
     0.742     0.667     0.200
     0.755     0.359     0.200
     0.776     0.526     0.200
     0.787    -0.164     0.200
     0.789     0.592     0.200
     0.797     0.528     0.200
     0.815    -0.089     0.200
     0.816     0.679     0.200
     0.819     0.775     0.200
     0.819     0.720     0.200
     0.831     0.135     0.200
     0.820     0.388     0.200
     0.822     0.715     0.200
     0.837     0.413     0.200
     0.842     0.606     0.200
     0.851     0.570     0.200
     0.855     0.688     0.200
     0.854     0.854     0.200
     0.871     0.417     0.200
     0.873     0.764     0.200
     0.094    -0.288     0.200
     0.126     0.516     0.200
     0.126     0.438     0.200
     0.133     0.137     0.200
     0.133     0.106     0.200
     0.174     0.168     0.200
     0.175     0.731     0.200
     0.181     0.235     0.200
     0.188     0.370     0.200
     0.204     0.768     0.200
     0.235     0.078     0.200
     0.235    -0.125     0.200
     0.261     0.312     0.200
     0.273     0.597     0.200
     0.297     0.382     0.200
     0.297    -0.231     0.200
     0.316     0.460     0.200
     0.318     0.807     0.200
     0.322    -0.321     0.200
     0.359     0.114     0.200
     0.378     0.104     0.200
     0.388    -0.411     0.200
     0.420     0.119     0.200
     0.435    -0.623     0.200
     0.461    -0.398     0.200
     0.454     0.384     0.200
     0.457     0.522     0.200
     0.479     0.445     0.200
     0.487     0.039     0.200
     0.487    -0.109     0.200
     0.488     0.005     0.200
     0.502     0.114     0.200
     0.528     0.578     0.200
     0.536     0.033     0.200
     0.534    -0.454     0.200
     0.567    -0.233     0.200
     0.565    -0.165     0.200
     0.565    -0.047     0.200
     0.582     0.340     0.200
     0.598    -0.334     0.200
     0.590     0.472     0.200
     0.625    -0.428     0.200
     0.631     0.337     0.200
     0.658     0.109     0.200
     0.678    -0.003     0.200
     0.678     0.434     0.200
     0.671     0.194     0.200
     0.722     0.387     0.200
     0.723     0.141     0.200
     0.724     0.351     0.200
     0.733     0.400     0.200
     0.749     0.292     0.200
     0.761     0.380     0.200
     0.790     0.200     0.200
     0.785     0.329     0.200
     0.793    -0.203     0.200
     0.808    -0.083     0.200
     0.823     0.905     0.200
     0.830    -0.256     0.200
     0.827    -0.522     0.200
     0.829    -0.134     0.200
     0.858     0.234     0.200
     0.862     0.526     0.200
     0.879    -0.352     0.200
     0.891     0.333     0.200
     0.890     0.065     0.200
     0.918    -0.002     0.200
     0.926     0.052     0.200
     0.930    -0.102     0.200
     0.972    -0.140     0.200
     0.981    -0.232     0.200
     0.985    -0.019     0.200
     0.999    -0.266     0.200
     0.086    -0.580     0.200
     0.139    -0.504     0.200
     0.142    -0.057     0.200
     0.188     0.049     0.200
     0.187     0.090     0.200
     0.202    -1.059     0.200
     0.209    -0.398     0.200
     0.209    -0.584     0.200
     0.225    -0.477     0.200
     0.248    -0.246     0.200
     0.226     0.157     0.200
     0.260    -0.289     0.200
     0.241    -0.389     0.200
     0.247     0.206     0.200
     0.249    -0.234     0.200
     0.290     0.011     0.200
     0.290    -0.071     0.200
     0.285    -0.105     0.200
     0.320    -0.354     0.200
     0.330    -0.138     0.200
     0.320     0.170     0.200
     0.342     0.187     0.200
     0.363    -0.159     0.200
     0.347     0.269     0.200
     0.344    -0.151     0.200
     0.353     0.106     0.200
     0.366     0.321     0.200
     0.385     0.135     0.200
     0.411     0.328     0.200
     0.427    -0.184     0.200
     0.397     0.801     0.200
     0.398    -0.280     0.200
     0.399    -0.229     0.200
     0.434    -0.137     0.200
     0.411     0.091     0.200
     0.426    -0.016     0.200
     0.418     0.024     0.200
     0.430     0.431     0.200
     0.426    -0.176     0.200
     0.432     0.018     0.200
     0.451    -0.203     0.200
     0.433    -0.293     0.200
     0.457     0.022     0.200
     0.471    -0.266     0.200
     0.520    -0.264     0.200
     0.533    -0.440     0.200
     0.516    -0.004     0.200
     0.525     0.412     0.200
     0.532    -0.041     0.200
     0.543    -0.092     0.200
     0.567     0.495     0.200
     0.537    -0.066     0.200
     0.566     0.232     0.200
     0.552    -0.129     0.200
     0.547     0.148     0.200
     0.557     0.510     0.200
     0.560     0.059     0.200
     0.569     0.118     0.200
     0.582     0.105     0.200
     0.607    -0.265     0.200
     0.596     0.218     0.200
     0.635    -0.080     0.200
     0.634    -0.107     0.200
     0.641    -0.200     0.200
     0.617     0.780     0.200
     0.622     0.608     0.200
     0.626     0.381     0.200
     0.666     0.132     0.200
     0.643     0.187     0.200
     0.652     0.182     0.200
     0.657     0.052     0.200
     0.664     0.080     0.200
     0.685     0.072     0.200
     0.685     0.080     0.200
     0.660     0.118     0.200
     0.661     0.248     0.200
     0.692     0.321     0.200
     0.699     0.324     0.200
     0.682    -0.093     0.200
     0.703     0.423     0.200
     0.699     0.005     0.200
     0.688     0.398     0.200
     0.707     0.092     0.200
     0.717     0.048     0.200
     0.733     0.512     0.200
     0.703     0.553     0.200
     0.708     0.452     0.200
     0.711     0.374     0.200
     0.747     0.491     0.200
     0.740    -0.073     0.200
     0.755     0.093     0.200
     0.747     0.159     0.200
     0.759     0.050     0.200
     0.761    -0.119     0.200
     0.765     0.078     0.200
     0.753     0.226     0.200
     0.782     0.419     0.200
     0.782     0.399     0.200
     0.794     0.321     0.200
     0.795     0.210     0.200
     0.773     0.093     0.200
     0.795     0.299     0.200
     0.790     0.134     0.200
     0.780     0.359     0.200
     0.788     0.353     0.200
     0.788     0.431     0.200
     0.808    -0.004     0.200
     0.808     0.004     0.200
     0.807     0.543     0.200
     0.815     0.209     0.200
     0.832     0.269     0.200
     0.814     0.513     0.200
     0.815     0.545     0.200
     0.853     0.031     0.200
     0.842     0.668     0.200
     0.857     0.033     0.200
     0.837     0.633     0.200
     0.869     0.451     0.200
     0.866     0.334     0.200
     0.874    -0.973     0.200
     0.875     0.216     0.200
     0.878     0.268     0.200
     0.871     0.469     0.200
     0.882     0.520     0.200
     0.887     0.649     0.200
     0.890     0.530     0.200
     0.911     0.274     0.200
     0.928     0.488     0.200
     0.940     0.579     0.200
     0.961     0.636     0.200
     0.954     2.046     0.200
     0.955     0.857     0.200
     0.962     1.149     0.200
     0.997     0.156     0.200
     0.972     0.789     0.200
     0.173     0.056     0.200
     0.156     0.425     0.200
     0.158    -0.194     0.200
     0.215     0.548     0.200
     0.220     0.125     0.200
     0.232    -0.237     0.200
     0.241    -0.215     0.200
     0.316    -0.007     0.200
     0.286    -0.413     0.200
     0.286    -0.362     0.200
     0.296    -0.161     0.200
     0.329     0.203     0.200
     0.340     0.272     0.200
     0.342     0.140     0.200
     0.341    -0.409     0.200
     0.324    -0.114     0.200
     0.346    -0.127     0.200
     0.374     0.167     0.200
     0.385     0.150     0.200
     0.391    -0.216     0.200
     0.371    -0.212     0.200
     0.397     0.025     0.200
     0.427     0.039     0.200
     0.394    -0.091     0.200
     0.395    -0.063     0.200
     0.429     0.585     0.200
     0.432     0.366     0.200
     0.447    -0.066     0.200
     0.442     0.282     0.200
     0.439    -0.081     0.200
     0.444    -0.351     0.200
     0.444    -0.190     0.200
     0.454     0.147     0.200
     0.468     0.168     0.200
     0.495     0.096     0.200
     0.509     0.067     0.200
     0.511     0.242     0.200
     0.517    -0.287     0.200
     0.512    -0.033     0.200
     0.528     0.201     0.200
     0.542    -0.295     0.200
     0.551    -0.069     0.200
     0.552     0.913     0.200
     0.542     0.938     0.200
     0.565     0.300     0.200
     0.534     0.370     0.200
     0.558     0.584     0.200
     0.540     0.026     0.200
     0.583     0.688     0.200
     0.598     0.348     0.200
     0.592     0.427     0.200
     0.594     0.258     0.200
     0.611     0.331     0.200
     0.633     1.114     0.200
     0.641     0.512     0.200
     0.667     0.062     0.200
     0.652     0.775     0.200
     0.662     0.508     0.200
     0.694     0.569     0.200
     0.673     0.216     0.200
     0.685     1.056     0.200
     0.673     0.511     0.200
     0.699    -0.130     0.200
     0.707     0.524     0.200
     0.711    -1.301     0.200
     0.682     0.667     0.200
     0.688     0.458     0.200
     0.685     0.456     0.200
     0.731     0.318     0.200
     0.727     0.868     0.200
     0.739    -0.154     0.200
     0.750     0.548     0.200
     0.781    -0.040     0.200
     0.773     0.581     0.200
     0.770     0.645     0.200
     0.791    -0.117     0.200
     0.774     0.889     0.200
     0.774     0.872     0.200
     0.779     0.347     0.200
     0.788     0.529     0.200
     0.824     0.443     0.200
     0.813     0.500     0.200
     0.810     0.788     0.200
     0.827     0.731     0.200
     0.821     1.195     0.200
     0.831    -0.227     0.200
     0.819     0.755     0.200
     0.828     0.526     0.200
     0.861    -0.143     0.200
     0.855     0.679     0.200
     0.865     0.396     0.200
     0.867     0.907     0.200
     0.873     0.086     0.200
     0.885     0.424     0.200
     0.877     0.979     0.200
     0.903     1.213     0.200
     0.894     0.662     0.200
     0.894     0.679     0.200
     0.942     0.850     0.200
     0.977     0.026     0.200
     0.029    -1.256     0.200
     0.028    -1.203     0.200
     0.083    -0.434     0.200
     0.078    -0.480     0.200
     0.119    -0.256     0.200
     0.164     0.031     0.200
     0.166    -0.314     0.200
     0.187     0.200     0.200
     0.206     0.448     0.200
     0.195     0.275     0.200
     0.202    -0.377     0.200
     0.302     0.299     0.200
     0.307    -0.298     0.200
     0.311    -0.215     0.200
     0.319     0.152     0.200
     0.333     0.360     0.200
     0.367     0.306     0.200
     0.366    -0.024     0.200
     0.360     0.322     0.200
     0.416     0.222     0.200
     0.436     0.450     0.200
     0.443    -0.216     0.200
     0.450     0.627     0.200
     0.456     0.481     0.200
     0.480    -0.030     0.200
     0.467    -0.378     0.200
     0.499     0.230     0.200
     0.506    -0.244     0.200
     0.524     0.034     0.200
     0.526     0.059     0.200
     0.549    -0.144     0.200
     0.562    -0.387     0.200
     0.558     0.080     0.200
     0.575     0.196     0.200
     0.570    -0.566     0.200
     0.586    -0.196     0.200
     0.584     0.096     0.200
     0.600     0.285     0.200
     0.641    -0.127     0.200
     0.651    -0.299     0.200
     0.656     0.397     0.200
     0.665     0.009     0.200
     0.689    -0.205     0.200
     0.698    -0.197     0.200
     0.692    -0.038     0.200
     0.715     0.168     0.200
     0.719     0.085     0.200
     0.722     0.190     0.200
     0.762     0.132     0.200
     0.772    -0.490     0.200
     0.777     0.606     0.200
     0.788    -0.098     0.200
     0.789    -0.097     0.200
     0.819    -0.899     0.200
     0.820     0.149     0.200
     0.827    -0.055     0.200
     0.825    -0.211     0.200
     0.827    -0.061     0.200
     0.858    -0.005     0.200
     0.858     0.273     0.200
     0.857    -0.046     0.200
     0.863     0.032     0.200
     0.866     0.041     0.200
     0.879     0.081     0.200
     0.889     0.190     0.200
     0.889     0.081     0.200
     0.913    -0.274     0.200
     0.917     0.162     0.200
     0.931    -0.285     0.200
     0.923    -0.178     0.200
     0.935    -0.470     0.200
     0.937     0.470     0.200
     0.943    -0.185     0.200
     0.973    -0.135     0.200
     0.999    -0.903     0.200
     0.992     0.368     0.200
     1.000    -0.445     0.200
     0.031    -1.312     0.200
     0.033    -1.343     0.200
     0.088    -0.546     0.200
     0.073    -0.364     0.200
     0.124    -0.399     0.200
     0.172    -0.020     0.200
     0.170     0.052     0.200
     0.183     0.206     0.200
     0.191     0.236     0.200
     0.196    -0.314     0.200
     0.307     0.257     0.200
     0.312    -0.290     0.200
     0.315    -0.133     0.200
     0.319     0.085     0.200
     0.332     0.335     0.200
     0.341     0.053     0.200
     0.356     0.249     0.200
     0.373     0.360     0.200
     0.371    -0.081     0.200
     0.421     0.252     0.200
     0.442     0.497     0.200
     0.446    -0.215     0.200
     0.455     0.635     0.200
     0.452     0.538     0.200
     0.480     0.053     0.200
     0.462    -0.237     0.200
     0.496     0.236     0.200
     0.500    -0.128     0.200
     0.521     0.058     0.200
     0.527    -0.161     0.200
     0.549    -0.040     0.200
     0.553    -0.018     0.200
     0.567    -0.565     0.200
     0.579     0.177     0.200
     0.573    -0.623     0.200
     0.589    -0.237     0.200
     0.589     0.047     0.200
     0.596     0.471     0.200
     0.643    -0.190     0.200
     0.640    -0.389     0.200
     0.654     0.326     0.200
     0.656     0.047     0.200
     0.667    -0.111     0.200
     0.688    -0.264     0.200
     0.702    -0.256     0.200
     0.696    -0.185     0.200
     0.716     0.294     0.200
     0.721    -0.021     0.200
     0.726     0.028     0.200
     0.760    -0.169     0.200
     0.773     0.701     0.200
     0.775    -0.440     0.200
     0.785    -0.227     0.200
     0.784    -0.201     0.200
     0.819     0.116     0.200
     0.824     0.029     0.200
     0.824    -0.160     0.200
     0.822    -0.086     0.200
     0.824    -0.599     0.200
     0.824     0.084     0.200
     0.860    -0.076     0.200
     0.854    -0.087     0.200
     0.863    -0.371     0.200
     0.858     0.560     0.200
     0.861    -0.236     0.200
     0.879    -0.026     0.200
     0.887     0.160     0.200
     0.885     0.142     0.200
     0.914    -0.210     0.200
     0.915     0.217     0.200
     0.920    -0.110     0.200
     0.934     0.226     0.200
     0.940     0.008     0.200
     0.940    -0.668     0.200
     0.972    -0.069     0.200
     0.986     0.246     0.200
     0.995    -0.400     0.200
     0.025    -1.132     0.200
     0.030     0.290     0.200
     0.064    -0.736     0.200
     0.100    -0.526     0.200
     0.094    -0.471     0.200
     0.147     0.066     0.200
     0.147    -0.044     0.200
     0.209     0.557     0.200
     0.207     0.216     0.200
     0.215     0.222     0.200
     0.220    -0.393     0.200
     0.284     0.289     0.200
     0.284     0.289     0.200
     0.299    -0.130     0.200
     0.299    -0.131     0.200
     0.318    -0.044     0.200
     0.328    -0.109     0.200
     0.354     0.378     0.200
     0.347     0.288     0.200
     0.397     0.280     0.200
     0.380     0.175     0.200
     0.420     0.590     0.200
     0.438    -0.459     0.200
     0.438    -0.119     0.200
     0.488     0.103     0.200
     0.476     0.601     0.200
     0.505    -0.178     0.200
     0.482    -0.605     0.200
     0.516     0.006     0.200
     0.547    -0.420     0.200
     0.523    -0.072     0.200
     0.565     0.056     0.200
     0.568     0.271     0.200
     0.555    -0.498     0.200
     0.559     0.125     0.200
     0.545    -0.312     0.200
     0.577     0.014     0.200
     0.606    -0.261     0.200
     0.632    -0.220     0.200
     0.646    -0.719     0.200
     0.646    -0.568     0.200
     0.652    -0.512     0.200
     0.652    -0.912     0.200
     0.668     0.265     0.200
     0.674    -0.059     0.200
     0.661    -0.390     0.200
     0.691    -0.112     0.200
     0.713     0.147     0.200
     0.701    -0.051     0.200
     0.712    -0.071     0.200
     0.723     0.158     0.200
     0.722     0.215     0.200
     0.755    -0.360     0.200
     0.842    -0.107     0.200
     0.886    -0.246     0.200
     0.916    -0.587     0.200
     0.929    -0.150     0.200
     0.985    -1.029     0.200
     0.052    -0.522     0.200
     0.051    -0.686     0.200
     0.055    -0.672     0.200
     0.094    -0.336     0.200
     0.104    -0.331     0.200
     0.104    -0.341     0.200
     0.098    -0.427     0.200
     0.157    -0.146     0.200
     0.228    -0.390     0.200
     0.228    -0.379     0.200
     0.233    -0.307     0.200
     0.237     0.015     0.200
     0.237     0.015     0.200
     0.236     0.271     0.200
     0.286     0.072     0.200
     0.288     0.334     0.200
     0.272    -0.429     0.200
     0.326     0.141     0.200
     0.317     0.111     0.200
     0.318    -0.122     0.200
     0.367    -0.119     0.200
     0.364     0.518     0.200
     0.362     0.298     0.200
     0.362     0.310     0.200
     0.379     0.587     0.200
     0.443     0.135     0.200
     0.484    -0.442     0.200
     0.497     0.266     0.200
     0.511    -0.052     0.200
     0.518     0.082     0.200
     0.514    -0.001     0.200
     0.510    -0.200     0.200
     0.536    -0.412     0.200
     0.523     0.058     0.200
     0.547    -0.234     0.200
     0.584     0.066     0.200
     0.579     0.051     0.200
     0.577     0.166     0.200
     0.593    -0.552     0.200
     0.607    -0.059     0.200
     0.579    -0.366     0.200
     0.620    -0.168     0.200
     0.640     0.296     0.200
     0.642     0.208     0.200
     0.635     0.337     0.200
     0.624    -0.208     0.200
     0.666     0.215     0.200
     0.666    -0.142     0.200
     0.672     0.237     0.200
     0.675    -0.234     0.200
     0.696    -0.283     0.200
     0.687    -0.362     0.200
     0.775     0.007     0.200
     0.763    -0.692     0.200
     0.764    -0.761     0.200
     0.758     0.548     0.200
     0.807     0.120     0.200
     0.774    -0.484     0.200
     0.814    -0.220     0.200
     0.814    -0.683     0.200
     0.837    -0.200     0.200
     0.837    -0.176     0.200
     0.847     0.020     0.200
     0.858     0.009     0.200
     0.861     0.049     0.200
     0.899    -0.633     0.200
     0.910    -0.194     0.200
     0.919    -0.002     0.200
     0.952    -1.030     0.200
     0.988    -0.224     0.200
     0.005    -0.437     0.200
     0.065    -0.209     0.200
     0.135    -0.381     0.200
     0.179    -0.175     0.200
     0.198    -0.263     0.200
     0.218    -0.437     0.200
     0.241    -0.292     0.200
     0.279    -0.258     0.200
     0.275    -0.578     0.200
     0.286    -0.456     0.200
     0.309    -0.204     0.200
     0.336    -0.101     0.200
     0.336    -0.222     0.200
     0.342     0.235     0.200
     0.375    -0.236     0.200
     0.355     0.301     0.200
     0.401    -0.068     0.200
     0.404    -0.118     0.200
     0.386     0.140     0.200
     0.390    -0.064     0.200
     0.411    -0.241     0.200
     0.404     0.232     0.200
     0.430    -0.293     0.200
     0.438     0.118     0.200
     0.441     0.014     0.200
     0.444    -0.096     0.200
     0.434     0.107     0.200
     0.465    -0.015     0.200
     0.453     0.164     0.200
     0.486    -0.227     0.200
     0.483    -0.315     0.200
     0.476     0.649     0.200
     0.477    -0.099     0.200
     0.480     0.375     0.200
     0.483     0.357     0.200
     0.499    -0.170     0.200
     0.510    -0.133     0.200
     0.519     0.209     0.200
     0.533    -0.198     0.200
     0.556     0.170     0.200
     0.574    -0.073     0.200
     0.560    -0.037     0.200
     0.568     0.155     0.200
     0.577    -0.063     0.200
     0.578     0.207     0.200
     0.607     0.186     0.200
     0.612    -0.085     0.200
     0.606     0.092     0.200
     0.598    -0.117     0.200
     0.602     0.096     0.200
     0.611     0.352     0.200
     0.609     0.248     0.200
     0.620     0.149     0.200
     0.616     0.153     0.200
     0.647    -0.183     0.200
     0.645     0.340     0.200
     0.656     0.010     0.200
     0.652     0.110     0.200
     0.660     0.126     0.200
     0.663     0.392     0.200
     0.656     0.288     0.200
     0.654     0.061     0.200
     0.673     0.161     0.200
     0.675     0.407     0.200
     0.682     0.186     0.200
     0.690     0.179     0.200
     0.706     0.833     0.200
     0.716     0.269     0.200
     0.704     0.261     0.200
     0.704     0.166     0.200
     0.725    -0.010     0.200
     0.729     0.017     0.200
     0.732     0.042     0.200
     0.741    -0.029     0.200
     0.738     0.200     0.200
     0.728     0.349     0.200
     0.734     0.147     0.200
     0.751     0.054     0.200
     0.762     0.005     0.200
     0.768     0.061     0.200
     0.778     0.325     0.200
     0.768    -0.066     0.200
     0.789     0.672     0.200
     0.787     0.457     0.200
     0.787    -0.316     0.200
     0.800     0.050     0.200
     0.800     0.406     0.200
     0.790     0.460     0.200
     0.826     0.047     0.200
     0.835     0.600     0.200
     0.846     0.357     0.200
     0.832     0.251     0.200
     0.832     0.472     0.200
     0.853    -0.009     0.200
     0.854     0.223     0.200
     0.867    -0.523     0.200
     0.899     0.030     0.200
     0.898     0.549     0.200
     0.894     0.672     0.200
     0.885     0.560     0.200
     0.909     0.113     0.200
     0.913     0.677     0.200
     0.921     0.241     0.200
     0.926     0.917     0.200
     0.924     0.615     0.200
     0.923     0.872     0.200
     0.950     0.629     0.200
     0.977     0.200     0.200
     0.981     0.478     0.200
     0.059    -0.067     0.200
     0.100     0.375     0.200
     0.118    -0.152     0.200
     0.124     0.003     0.200
     0.157     0.608     0.200
     0.181     0.743     0.200
     0.162     0.335     0.200
     0.174     0.385     0.200
     0.195     0.045     0.200
     0.185     0.373     0.200
     0.193     0.499     0.200
     0.242     0.555     0.200
     0.249     0.472     0.200
     0.337     0.235     0.200
     0.322     0.367     0.200
     0.326    -0.315     0.200
     0.356     0.024     0.200
     0.368    -0.149     0.200
     0.404    -0.482     0.200
     0.448     0.263     0.200
     0.428    -0.362     0.200
     0.439     0.337     0.200
     0.465    -0.313     0.200
     0.451    -0.034     0.200
     0.484    -0.647     0.200
     0.483    -0.089     0.200
     0.497     0.252     0.200
     0.517    -0.256     0.200
     0.560     0.359     0.200
     0.553    -0.160     0.200
     0.560    -0.195     0.200
     0.603     0.166     0.200
     0.618    -0.499     0.200
     0.617    -0.121     0.200
     0.641     0.082     0.200
     0.652    -0.819     0.200
     0.701     0.385     0.200
     0.717    -0.050     0.200
     0.709     0.107     0.200
     0.723    -0.027     0.200
     0.744     0.285     0.200
     0.758     0.161     0.200
     0.768     0.093     0.200
     0.762    -0.337     0.200
     0.750     0.126     0.200
     0.752    -0.229     0.200
     0.782    -0.197     0.200
     0.785    -0.105     0.200
     0.801     0.137     0.200
     0.825     0.524     0.200
     0.831     0.125     0.200
     0.848    -0.417     0.200
     0.841     0.017     0.200
     0.835    -0.675     0.200
     0.861    -0.108     0.200
     0.890    -0.105     0.200
     0.906    -0.136     0.200
     0.956    -0.017     0.200
     0.940    -0.239     0.200
     0.979    -0.282     0.200
     0.120    -0.242     0.200
     0.124    -0.111     0.200
     0.098     0.361     0.200
     0.163     0.229     0.200
     0.178     0.367     0.200
     0.154     0.576     0.200
     0.189     0.292     0.200
     0.192     0.036     0.200
     0.179     0.772     0.200
     0.240     0.377     0.200
     0.246     0.377     0.200
     0.324     0.355     0.200
     0.330    -0.308     0.200
     0.335     0.199     0.200
     0.359     0.042     0.200
     0.367    -0.039     0.200
     0.407    -0.439     0.200
     0.432    -0.370     0.200
     0.442     0.394     0.200
     0.450    -0.115     0.200
     0.436     0.286     0.200
     0.446     0.247     0.200
     0.463    -0.156     0.200
     0.481    -0.476     0.200
     0.486     0.078     0.200
     0.516    -0.104     0.200
     0.497     0.599     0.200
     0.562    -0.068     0.200
     0.556    -0.024     0.200
     0.562     0.542     0.200
     0.602     0.307     0.200
     0.615    -0.328     0.200
     0.635     0.116     0.200
     0.650    -0.541     0.200
     0.642     0.176     0.200
     0.709     0.035     0.200
     0.695     0.499     0.200
     0.726     0.220     0.200
     0.714     0.374     0.200
     0.763    -0.112     0.200
     0.766     0.220     0.200
     0.786    -0.083     0.200
     0.780    -0.133     0.200
     0.798    -0.116     0.200
     0.800     0.003     0.200
     0.837    -0.398     0.200
     0.834     0.145     0.200
     0.822     0.830     0.200
     0.844     0.189     0.200
     0.832     0.724     0.200
     0.848    -0.246     0.200
     0.892     0.077     0.200
     0.908    -0.002     0.200
     0.944    -0.029     0.200
     0.935    -0.201     0.200
     0.957     0.062     0.200
     0.982    -0.056     0.200
     0.988    -0.413     0.200
     0.065    -0.024     0.200
     0.104     0.482     0.200
     0.125     0.007     0.200
     0.160     0.326     0.200
     0.169     0.409     0.200
     0.180     0.337     0.200
     0.188     0.306     0.200
     0.162     0.665     0.200
     0.185     0.840     0.200
     0.206     0.045     0.200
     0.245     0.615     0.200
     0.252     0.391     0.200
     0.320    -0.357     0.200
     0.318     0.543     0.200
     0.352     0.043     0.200
     0.342     0.246     0.200
     0.371    -0.074     0.200
     0.399    -0.620     0.200
     0.423    -0.185     0.200
     0.434     0.341     0.200
     0.441     0.216     0.200
     0.452     0.047     0.200
     0.478     0.037     0.200
     0.469    -0.231     0.200
     0.488    -0.592     0.200
     0.498     0.278     0.200
     0.519    -0.256     0.200
     0.547    -0.257     0.200
     0.557     0.096     0.200
     0.559     0.263     0.200
     0.629    -0.157     0.200
     0.623    -0.646     0.200
     0.640     0.215     0.200
     0.655    -0.853     0.200
     0.708     0.048     0.200
     0.720     0.077     0.200
     0.739     0.122     0.200
     0.721    -0.008     0.200
     0.747     0.002     0.200
     0.751     0.185     0.200
     0.762    -0.381     0.200
     0.784     0.030     0.200
     0.773     0.010     0.200
     0.795    -0.493     0.200
     0.785    -0.050     0.200
     0.804    -0.155     0.200
     0.827     0.128     0.200
     0.832    -0.660     0.200
     0.836     0.161     0.200
     0.835     0.175     0.200
     0.831     0.657     0.200
     0.887     0.115     0.200
     0.902    -0.123     0.200
     0.936    -0.295     0.200
     0.935    -0.354     0.200
     0.953    -0.053     0.200
     0.975    -0.103     0.200
     0.988    -0.745     0.200
     0.066     0.036     0.200
     0.105     0.500     0.200
     0.114    -0.124     0.200
     0.124     0.031     0.200
     0.168     0.477     0.200
     0.163     0.644     0.200
     0.179     0.413     0.200
     0.187     0.327     0.200
     0.186     0.847     0.200
     0.199     0.246     0.200
     0.246     0.515     0.200
     0.253     0.447     0.200
     0.319    -0.314     0.200
     0.317     0.907     0.200
     0.351     0.062     0.200
     0.343     0.391     0.200
     0.371    -0.023     0.200
     0.398    -0.461     0.200
     0.422    -0.556     0.200
     0.433     0.379     0.200
     0.442     0.203     0.200
     0.452     0.098     0.200
     0.451    -0.085     0.200
     0.478    -0.006     0.200
     0.470    -0.229     0.200
     0.498     0.364     0.200
     0.488    -0.596     0.200
     0.519    -0.259     0.200
     0.547    -0.257     0.200
     0.559     0.338     0.200
     0.629    -0.151     0.200
     0.640     0.081     0.200
     0.623    -0.502     0.200
     0.655    -0.868     0.200
     0.720     0.012     0.200
     0.707     0.262     0.200
     0.739     0.369     0.200
     0.723     0.051     0.200
     0.746    -0.039     0.200
     0.762    -0.415     0.200
     0.785    -0.137     0.200
     0.774     0.116     0.200
     0.786     0.002     0.200
     0.796    -0.361     0.200
     0.805    -0.071     0.200
     0.827     0.090     0.200
     0.836     0.009     0.200
     0.831    -0.692     0.200
     0.836     0.425     0.200
     0.832     0.557     0.200
     0.850    -0.561     0.200
     0.887     0.376     0.200
     0.902    -0.039     0.200
     0.936    -0.515     0.200
     0.934    -0.248     0.200
     0.974    -0.304     0.200
     0.063    -0.172     0.200
     0.106     0.217     0.200
     0.120    -0.009     0.200
     0.162     0.538     0.200
     0.156     0.242     0.200
     0.187     0.659     0.200
     0.173     0.256     0.200
     0.181     0.326     0.200
     0.194     0.146     0.200
     0.188     0.297     0.200
     0.247     0.520     0.200
     0.292     0.622     0.200
     0.316     0.514     0.200
     0.343     0.171     0.200
     0.322    -0.414     0.200
     0.357    -0.082     0.200
     0.366    -0.005     0.200
     0.399    -0.492     0.200
     0.443     0.305     0.200
     0.426    -0.597     0.200
     0.454     0.109     0.200
     0.438     0.456     0.200
     0.446     0.087     0.200
     0.471    -0.363     0.200
     0.482    -0.576     0.200
     0.483    -0.202     0.200
     0.502     0.160     0.200
     0.514    -0.106     0.200
     0.551     0.027     0.200
     0.564     0.398     0.200
     0.555    -0.025     0.200
     0.609     0.032     0.200
     0.618    -0.366     0.200
     0.635     0.028     0.200
     0.645     0.057     0.200
     0.650    -0.638     0.200
     0.722     0.113     0.200
     0.703     0.331     0.200
     0.725     0.011     0.200
     0.744     0.279     0.200
     0.744     0.272     0.200
     0.760     0.266     0.200
     0.747     0.502     0.200
     0.767    -0.548     0.200
     0.774     0.019     0.200
     0.787     0.063     0.200
     0.789    -0.070     0.200
     0.801    -0.354     0.200
     0.807    -0.052     0.200
     0.828     0.659     0.200
     0.839     0.406     0.200
     0.833    -0.021     0.200
     0.829    -0.834     0.200
     0.841     0.083     0.200
     0.893    -0.147     0.200
     0.907    -0.181     0.200
     0.940    -0.456     0.200
     0.935    -0.169     0.200
     0.964     0.317     0.200
     0.101     0.364     0.200
     0.118    -0.156     0.200
     0.122    -0.036     0.200
     0.160     0.304     0.200
     0.156     0.565     0.200
     0.178     0.384     0.200
     0.187     0.344     0.200
     0.181     0.750     0.200
     0.191     0.100     0.200
     0.194     0.308     0.200
     0.242     0.504     0.200
     0.249     0.327     0.200
     0.290     0.773     0.200
     0.321     0.398     0.200
     0.329    -0.311     0.200
     0.337     0.240     0.200
     0.365    -0.062     0.200
     0.360    -0.021     0.200
     0.405    -0.406     0.200
     0.432    -0.341     0.200
     0.447    -0.133     0.200
     0.443     0.366     0.200
     0.449     0.139     0.200
     0.465    -0.281     0.200
     0.479    -0.553     0.200
     0.487    -0.078     0.200
     0.500     0.254     0.200
     0.514    -0.226     0.200
     0.559    -0.124     0.200
     0.557    -0.132     0.200
     0.564     0.417     0.200
     0.605     0.095     0.200
     0.614    -0.592     0.200
     0.637     0.134     0.200
     0.648    -0.669     0.200
     0.645     0.187     0.200
     0.706     0.508     0.200
     0.698     0.216     0.200
     0.715     0.144     0.200
     0.727     0.057     0.200
     0.749     0.257     0.200
     0.751     0.503     0.200
     0.749     0.224     0.200
     0.765    -0.275     0.200
     0.768     0.042     0.200
     0.782    -0.242     0.200
     0.800    -0.167     0.200
     0.803    -0.131     0.200
     0.822     0.663     0.200
     0.835    -0.744     0.200
     0.836     0.008     0.200
     0.835     0.368     0.200
     0.858    -0.255     0.200
     0.850    -0.388     0.200
     0.894    -0.112     0.200
     0.910    -0.150     0.200
     0.942    -0.207     0.200
     0.938    -0.400     0.200
     0.984    -0.160     0.200
     0.146    -0.267     0.200
     0.189    -0.368     0.200
     0.187    -0.234     0.200
     0.249    -0.038     0.200
     0.252    -0.101     0.200
     0.267    -0.179     0.200
     0.283     0.133     0.200
     0.291     0.175     0.200
     0.352    -0.013     0.200
     0.352     0.435     0.200
     0.355     0.063     0.200
     0.349    -0.203     0.200
     0.365     0.558     0.200
     0.370    -0.188     0.200
     0.392     0.032     0.200
     0.388    -0.302     0.200
     0.401     0.545     0.200
     0.403     0.002     0.200
     0.390    -0.339     0.200
     0.415     0.494     0.200
     0.420    -0.447     0.200
     0.432     0.131     0.200
     0.426    -0.335     0.200
     0.441     0.708     0.200
     0.445     0.012     0.200
     0.467     0.410     0.200
     0.479    -0.338     0.200
     0.487    -0.208     0.200
     0.541    -0.166     0.200
     0.562    -0.161     0.200
     0.568     0.092     0.200
     0.615     0.575     0.200
     0.622     0.862     0.200
     0.654    -0.018     0.200
     0.646     0.104     0.200
     0.664    -0.045     0.200
     0.668     0.325     0.200
     0.688    -0.095     0.200
     0.695    -0.000     0.200
     0.695    -0.226     0.200
     0.688     0.003     0.200
     0.713    -0.031     0.200
     0.741    -0.011     0.200
     0.757     0.066     0.200
     0.773     0.062     0.200
     0.777     0.072     0.200
     0.791     0.207     0.200
     0.815     0.420     0.200
     0.824     0.451     0.200
     0.846    -0.439     0.200
     0.840     0.136     0.200
     0.850     0.214     0.200
     0.863    -0.272     0.200
     0.878     0.197     0.200
     0.885     0.539     0.200
     0.889     0.179     0.200
     0.903    -0.156     0.200
     0.904    -0.100     0.200
     0.915     0.154     0.200
     0.908     0.437     0.200
     0.935     0.675     0.200
     0.967     0.050     0.200
     0.969     0.116     0.200
     0.114    -0.181     0.200
     0.023    -0.289     0.200
     0.146     0.022     0.200
     0.263     0.000     0.200
     0.289     0.021     0.200
     0.307    -0.440     0.200
     0.330    -0.098     0.200
     0.335     0.003     0.200
     0.249     0.086     0.200
     0.247     0.068     0.200
     0.377    -0.554     0.200
     0.489    -0.407     0.200
     0.646     0.115     0.200
     0.665    -0.337     0.200
     0.745     0.208     0.200
     0.793     0.070     0.200
     0.779     0.276     0.200
     0.883     0.282     0.200
     0.830     0.346     0.200
     0.888     0.417     0.200
     0.906     0.135     0.200
     0.860     0.542     0.200
     0.982     0.934     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.947    -0.097     0.200
     0.990    -0.538     0.200
     0.887    -0.813     0.200
     0.838    -0.839     0.200
     0.861    -1.027     0.200
     0.837    -0.775     0.200
     0.905    -0.328     0.200
     0.985    -0.696     0.200
     0.975    -0.250     0.200
     0.962    -0.100     0.200
     0.890    -0.873     0.200
     0.844    -1.095     0.200
     0.995    -0.146     0.200
     0.940    -0.853     0.200
     0.940    -0.728     0.200
     0.998    -0.639     0.200
     0.888    -0.442     0.200
     0.862    -1.020     0.200
     0.980     0.036     0.200
     0.893    -1.048     0.200
     0.893    -0.916     0.200
     0.983     0.554     0.200
     0.853    -0.313     0.200
     0.870    -1.135     0.200
     0.975    -0.787     0.200
     0.983    -0.717     0.200
     0.984    -0.939     0.200
     0.995    -0.727     0.200
     0.937     0.038     0.200
     0.949    -0.646     0.200
     0.952    -0.696     0.200
     0.983    -0.282     0.200
     0.938    -0.655     0.200
     0.968    -1.008     0.200
     0.935     0.374     0.200
     0.942    -0.704     0.200
     0.950    -0.663     0.200
     0.989    -0.916     0.200
     0.974    -0.644     0.200
     0.976    -0.842     0.200
     0.926     1.413     0.200
     0.970    -0.779     0.200
     0.968    -0.973     0.200
     0.766    -0.815     0.200
     0.968     0.045     0.200
     0.815    -0.955     0.200
     0.854    -0.913     0.200
     0.897    -0.648     0.200
     0.742    -0.623     0.200
     0.757    -0.111     0.200
     0.783     0.558     0.200
     0.842    -0.528     0.200
     0.834    -0.784     0.200
     0.807    -0.426     0.200
     0.844    -0.698     0.200
     0.820    -0.537     0.200
     0.830     0.756     0.200
     0.833    -0.187     0.200
     0.879    -0.604     0.200
     0.918    -0.832     0.200
     0.918    -0.705     0.200
     0.918    -0.824     0.200
     0.967    -0.158     0.200
     0.975     0.444     0.200
     0.985    -0.212     0.200
     0.881    -0.992     0.200
     0.792    -0.890     0.200
     0.902    -0.243     0.200
     0.910     0.129     0.200
     0.979    -0.020     0.200
     0.996    -0.287     0.200
     0.930    -0.844     0.200
     0.963    -0.038     0.200
     0.979    -0.553     0.200
     0.979    -0.764     0.200
     0.775    -0.798     0.200
     0.863    -0.842     0.200
     0.868    -1.042     0.200
     0.871    -0.683     0.200
     0.871    -1.023     0.200
     0.879    -0.846     0.200
     0.907    -0.693     0.200
     0.921    -0.742     0.200
     0.922    -0.693     0.200
     0.942    -0.596     0.200
     0.990    -0.353     0.200
     0.773    -1.089     0.200
     0.773    -0.935     0.200
     0.792    -0.691     0.200
     0.801    -0.721     0.200
     0.844    -0.895     0.200
     0.863    -0.719     0.200
     0.877    -0.634     0.200
     0.945    -0.694     0.200
     0.934    -0.781     0.200
     0.941    -0.126     0.200
     0.978    -0.409     0.200
     0.978    -0.730     0.200
     0.772    -1.072     0.200
     0.776    -0.766     0.200
     0.795    -0.794     0.200
     0.803    -0.801     0.200
     0.850    -1.109     0.200
     0.866    -0.849     0.200
     0.879    -0.641     0.200
     0.940    -0.934     0.200
     0.946    -0.787     0.200
     0.946    -0.471     0.200
     0.985    -0.603     0.200
     0.985    -0.726     0.200
     0.773    -0.828     0.200
     0.791    -0.724     0.200
     0.800    -0.671     0.200
     0.944    -0.360     0.200
     0.986    -0.450     0.200
     0.863    -0.808     0.200
     0.876    -0.670     0.200
     0.956    -0.605     0.200
     0.943    -0.422     0.200
     0.985    -0.615     0.200
     0.981    -0.916     0.200
     0.981    -0.611     0.200
     0.976    -0.968     0.200
     0.979    -0.697     0.200
     0.880    -0.948     0.200
     0.972    -0.900     0.200
     0.981    -0.913     0.200
     0.988    -0.200     0.200
     0.992     2.413     0.200
     0.747    -0.790     0.200
     0.741    -1.000     0.200
     0.767    -0.929     0.200
     0.803    -0.671     0.200
     0.817    -0.759     0.200
     0.843    -0.546     0.200
     0.855    -1.018     0.200
     0.868    -0.135     0.200
     0.940    -0.718     0.200
     0.928    -0.808     0.200
     0.966    -0.652     0.200
     0.761    -0.822     0.200
     0.759    -1.059     0.200
     0.733    -0.452     0.200
     0.782    -1.004     0.200
     0.782    -0.988     0.200
     0.777    -1.065     0.200
     0.823    -1.004     0.200
     0.809    -0.737     0.200
     0.866    -0.845     0.200
     0.829    -0.438     0.200
     0.837    -0.337     0.200
     0.881    -0.726     0.200
     0.857    -0.018     0.200
     0.900    -0.852     0.200
     0.920    -0.891     0.200
     0.912    -0.869     0.200
     0.927    -0.776     0.200
     0.962     0.866     0.200
     0.985    -0.538     0.200
     0.978     0.042     0.200
     0.772    -0.891     0.200
     0.867    -0.742     0.200
     0.835    -1.075     0.200
     0.842    -0.561     0.200
     0.904    -0.672     0.200
     0.876    -0.994     0.200
     0.908    -0.678     0.200
     0.957    -0.710     0.200
     0.754    -1.009     0.200
     0.778    -0.707     0.200
     0.778    -0.818     0.200
     0.807    -0.246     0.200
     0.814    -0.874     0.200
     0.841    -0.964     0.200
     0.847    -0.877     0.200
     0.877    -0.680     0.200
     0.876    -0.575     0.200
     0.904    -0.279     0.200
     0.928    -0.434     0.200
     0.943    -0.487     0.200
     0.977    -0.613     0.200
     0.977     0.220     0.200
     0.871    -0.555     0.200
     0.941    -0.976     0.200
     0.941    -1.113     0.200
     0.772    -1.028     0.200
     0.774    -0.838     0.200
     0.835    -1.003     0.200
     0.959    -0.526     0.200
     0.757    -0.973     0.200
     0.757    -0.972     0.200
     0.814    -1.014     0.200
     0.902    -0.684     0.200
     0.922    -0.814     0.200
     0.961    -0.819     0.200
     0.961    -0.596     0.200
     0.972    -0.631     0.200
     0.972    -0.138     0.200
     0.991    -0.787     0.200
     0.993    -0.601     0.200
     0.808    -1.067     0.200
     0.830    -1.043     0.200
     0.903    -0.939     0.200
     0.802    -1.035     0.200
     0.817    -1.218     0.200
     0.867    -0.957     0.200
     0.896    -0.838     0.200
     0.916    -0.765     0.200
     0.983    -0.942     0.200
     0.987    -0.490     0.200
     0.967    -0.604     0.200
     0.795    -0.996     0.200
     0.827    -0.681     0.200
     0.899    -1.042     0.200
     0.981    -0.608     0.200
     0.993    -0.554     0.200
     0.887    -0.502     0.200
     0.970    -0.319     0.200
     0.970    -0.456     0.200
     0.900     0.124     0.200
     0.825    -0.704     0.200
     0.969    -0.848     0.200
     0.971    -0.357     0.200
     0.986    -0.956     0.200
     0.986    -0.874     0.200
     0.977     0.066     0.200
     0.844    -1.027     0.200
     0.895    -0.982     0.200
     0.899    -0.503     0.200
     0.907    -0.880     0.200
     0.987    -0.709     0.200
     0.837    -0.980     0.200
     0.865    -0.921     0.200
     0.941    -0.658     0.200
     0.775    -1.054     0.200
     0.791    -1.196     0.200
     0.797    -1.011     0.200
     0.804    -0.676     0.200
     0.795    -0.686     0.200
     0.809    -0.918     0.200
     0.821    -1.156     0.200
     0.838    -1.042     0.200
     0.845    -0.893     0.200
     0.871    -1.017     0.200
     0.872    -1.034     0.200
     0.890    -0.948     0.200
     0.903    -0.900     0.200
     0.903    -0.513     0.200
     0.987    -0.370     0.200
     0.900    -0.999     0.200
     0.906    -0.923     0.200
     0.932    -0.790     0.200
     0.948    -0.901     0.200
     0.943    -1.065     0.200
     0.755    -0.760     0.200
     0.776    -0.819     0.200
     0.802    -1.071     0.200
     0.797    -0.955     0.200
     0.793    -1.214     0.200
     0.791    -1.145     0.200
     0.809    -0.895     0.200
     0.819    -0.979     0.200
     0.819    -1.114     0.200
     0.831    -0.935     0.200
     0.849    -0.860     0.200
     0.863    -1.064     0.200
     0.885    -1.042     0.200
     0.858    -1.100     0.200
     0.865    -0.769     0.200
     0.879    -0.694     0.200
     0.886    -1.010     0.200
     0.898    -0.735     0.200
     0.898    -0.741     0.200
     0.908    -0.928     0.200
     0.926    -0.686     0.200
     0.940    -0.817     0.200
     0.994    -0.958     0.200
     0.976    -1.000     0.200
     0.979    -0.757     0.200
     0.977     0.052     0.200
     0.988    -0.564     0.200
     0.760    -1.239     0.200
     0.800    -0.777     0.200
     0.813    -1.023     0.200
     0.906    -1.001     0.200
     0.908    -0.761     0.200
     0.931    -0.732     0.200
     0.792    -1.077     0.200
     0.808    -1.095     0.200
     0.810    -1.207     0.200
     0.815    -0.949     0.200
     0.881    -0.889     0.200
     0.911    -0.905     0.200
     0.913    -0.775     0.200
     0.943    -0.743     0.200
     0.992    -0.818     0.200
     1.000    -0.148     0.200
     0.795    -1.170     0.200
     0.824    -0.978     0.200
     0.826    -1.067     0.200
     0.865    -1.025     0.200
     0.846    -0.873     0.200
     0.884    -0.732     0.200
     0.886    -0.941     0.200
     0.892    -1.067     0.200
     0.919    -0.752     0.200
     0.938    -0.757     0.200
     0.961    -0.972     0.200
     0.966    -0.277     0.200
     0.998    -0.953     0.200
     0.999    -0.686     0.200
     0.958     0.128     0.200
     0.967    -0.115     0.200
     0.753    -1.329     0.200
     0.771    -1.127     0.200
     0.799    -1.075     0.200
     0.801    -0.937     0.200
     0.811    -0.933     0.200
     0.817    -1.096     0.200
     0.836    -1.031     0.200
     0.851    -1.010     0.200
     0.857    -0.966     0.200
     0.871    -0.857     0.200
     0.890    -0.824     0.200
     0.898    -1.155     0.200
     0.904    -0.743     0.200
     0.905    -0.726     0.200
     0.908    -0.910     0.200
     0.920    -0.830     0.200
     0.923    -0.722     0.200
     0.933    -0.809     0.200
     0.937    -0.925     0.200
     0.971    -0.694     0.200
     0.984    -0.045     0.200
     0.750    -0.631     0.200
     0.726    -0.739     0.200
     0.758    -0.850     0.200
     0.782    -0.996     0.200
     0.762    -0.644     0.200
     0.833    -0.570     0.200
     0.811    -0.929     0.200
     0.780    -0.342     0.200
     0.850    -0.917     0.200
     0.834    -0.728     0.200
     0.830    -0.711     0.200
     0.859    -0.747     0.200
     0.807    -0.447     0.200
     0.932    -0.005     0.200
     0.881    -0.486     0.200
     0.871    -0.086     0.200
     0.897    -0.482     0.200
     0.903    -0.252     0.200
     0.963    -0.689     0.200
     0.896    -0.006     0.200
     0.904     0.093     0.200
     0.925    -0.493     0.200
     0.892    -0.234     0.200
     0.885    -0.021     0.200
     0.895    -0.411     0.200
     0.918     0.075     0.200
     0.912    -0.108     0.200
     0.921     0.277     0.200
     0.981     0.068     0.200
     0.985    -0.934     0.200
     0.984     0.255     0.200
     0.998     0.416     0.200
     0.796    -0.460     0.200
     0.808    -1.127     0.200
     0.835     0.288     0.200
     0.844    -1.190     0.200
     0.844    -1.072     0.200
     0.863    -1.202     0.200
     0.889    -1.095     0.200
     0.889    -1.054     0.200
     0.883    -0.743     0.200
     0.904    -0.831     0.200
     0.917    -1.047     0.200
     0.908    -0.771     0.200
     0.847    -1.132     0.200
     0.977    -0.836     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.285    -0.566     0.200
     0.343    -0.614     0.200
     0.517    -0.254     0.200
     0.806    -0.158     0.200
     0.218    -0.323     0.200
     0.331    -0.298     0.200
     0.711    -0.303     0.200
     0.866    -0.027     0.200
     0.982    -0.536     0.200
     0.277    -0.792     0.200
     0.374    -0.379     0.200
     0.454    -0.704     0.200
     0.509    -0.854     0.200
     0.598    -0.576     0.200
     0.743    -0.018     0.200
     0.670    -1.127     0.200
     0.167    -0.755     0.200
     0.551    -1.226     0.200
     0.635    -0.346     0.200
     0.674    -0.515     0.200
     0.743    -0.084     0.200
     0.783    -0.560     0.200
     0.775    -0.283     0.200
     0.838     0.072     0.200
     0.167    -0.446     0.200
     0.167    -0.587     0.200
     0.551    -0.962     0.200
     0.673    -0.624     0.200
     0.740     0.066     0.200
     0.639    -0.153     0.200
     0.783    -0.677     0.200
     0.837     0.130     0.200
     0.778    -0.513     0.200
     0.292    -0.653     0.200
     0.356    -1.103     0.200
     0.356    -0.763     0.200
     0.645    -0.480     0.200
     0.714    -0.450     0.200
     0.837    -0.157     0.200
     0.759     0.453     0.200
     0.289    -0.235     0.200
     0.362    -1.213     0.200
     0.639    -0.333     0.200
     0.712    -0.538     0.200
     0.763     0.030     0.200
     0.833    -0.458     0.200
     0.382    -0.806     0.200
     0.411    -0.126     0.200
     0.658     0.438     0.200
     0.711     0.133     0.200
     0.727     0.302     0.200
     0.704     1.053     0.200
     0.772     0.228     0.200
     0.432    -0.424     0.200
     0.703    -0.103     0.200
     0.698     0.060     0.200
     0.677    -0.312     0.200
     0.677     0.442     0.200
     0.747     0.161     0.200
     0.806     0.735     0.200
     0.806    -0.441     0.200
     0.734     0.213     0.200
     0.369    -1.372     0.200
     0.613    -0.560     0.200
     0.648    -0.781     0.200
     0.661    -0.438     0.200
     0.707    -0.545     0.200
     0.707    -0.159     0.200
     0.726    -0.132     0.200
     0.841    -0.432     0.200
     0.921    -0.223     0.200
     0.291    -0.351     0.200
     0.433    -0.611     0.200
     0.666     0.190     0.200
     0.114    -0.692     0.200
     0.475    -1.227     0.200
     0.408    -0.661     0.200
     0.419    -0.460     0.200
     0.458    -0.134     0.200
     0.487    -0.501     0.200
     0.503    -0.430     0.200
     0.621    -0.775     0.200
     0.726     0.229     0.200
     0.111    -0.939     0.200
     0.406    -0.498     0.200
     0.452    -0.864     0.200
     0.421    -0.716     0.200
     0.472    -1.193     0.200
     0.490    -0.489     0.200
     0.544    -0.810     0.200
     0.627    -1.196     0.200
     0.636    -0.214     0.200
     0.636    -0.183     0.200
     0.219    -0.647     0.200
     0.685    -0.214     0.200
     0.682     0.240     0.200
     0.698     0.053     0.200
     0.744    -0.735     0.200
     0.766    -0.379     0.200
     0.780    -0.095     0.200
     0.167    -0.127     0.200
     0.192    -0.343     0.200
     0.532    -1.242     0.200
     0.611    -0.055     0.200
     0.755    -0.519     0.200
     0.753    -0.731     0.200
     0.780    -0.210     0.200
     0.831    -0.296     0.200
     0.890    -0.558     0.200
     0.901    -0.332     0.200
     0.272    -0.651     0.200
     0.449    -1.246     0.200
     0.460    -0.088     0.200
     0.507    -0.600     0.200
     0.563    -0.361     0.200
     0.563     0.912     0.200
     0.593    -0.765     0.200
     0.669    -0.160     0.200
     0.745    -0.703     0.200
     0.903    -0.337     0.200
     0.944    -0.282     0.200
     0.971    -0.147     0.200
     0.987    -0.277     0.200
     0.987    -0.746     0.200
     0.372    -0.208     0.200
     0.376    -0.720     0.200
     0.480    -0.035     0.200
     0.735    -1.064     0.200
     0.890    -0.185     0.200
     0.219    -1.054     0.200
     0.583    -0.213     0.200
     0.583    -0.026     0.200
     0.620    -0.612     0.200
     0.620    -0.095     0.200
     0.659    -0.576     0.200
     0.704     1.186     0.200
     0.735     0.146     0.200
     0.319    -0.444     0.200
     0.330    -1.386     0.200
     0.554     0.051     0.200
     0.755    -0.100     0.200
     0.850    -0.297     0.200
     0.148     0.231     0.200
     0.437    -1.111     0.200
     0.451    -0.824     0.200
     0.446    -0.563     0.200
     0.613    -1.661     0.200
     0.676    -0.535     0.200
     0.754    -0.180     0.200
     0.212    -0.050     0.200
     0.551    -0.888     0.200
     0.551    -0.693     0.200
     0.556    -0.448     0.200
     0.554     0.217     0.200
     0.617    -1.199     0.200
     0.737    -0.210     0.200
     0.723     0.062     0.200
     0.196    -0.312     0.200
     0.350    -0.881     0.200
     0.619    -0.875     0.200
     0.788     1.540     0.200
     0.753    -0.724     0.200
     0.821     0.139     0.200
     0.893    -0.101     0.200
     0.956    -0.589     0.200
     0.902    -0.801     0.200
     0.986    -0.544     0.200
     0.208    -0.621     0.200
     0.338    -0.547     0.200
     0.618    -0.743     0.200
     0.686    -0.949     0.200
     0.761    -0.868     0.200
     0.777     1.266     0.200
     0.822    -0.376     0.200
     0.895    -0.983     0.200
     0.901    -0.745     0.200
     0.901    -0.582     0.200
     0.944    -0.880     0.200
     0.973    -0.482     0.200
     0.995    -0.832     0.200
     0.294    -0.906     0.200
     0.543    -0.706     0.200
     0.636    -0.586     0.200
     0.673    -0.375     0.200
     0.714    -0.278     0.200
     0.721    -0.467     0.200
     0.721    -0.561     0.200
     0.721    -0.432     0.200
     0.711    -0.168     0.200
     0.763    -0.802     0.200
     0.870    -0.325     0.200
     0.202    -0.685     0.200
     0.202    -0.411     0.200
     0.249     0.902     0.200
     0.584    -0.213     0.200
     0.584    -0.315     0.200
     0.634    -0.020     0.200
     0.633     0.102     0.200
     0.633    -1.148     0.200
     0.652    -1.094     0.200
     0.721     0.314     0.200
     0.213    -0.685     0.200
     0.242     1.406     0.200
     0.592    -0.468     0.200
     0.634     0.279     0.200
     0.621    -0.443     0.200
     0.646    -0.385     0.200
     0.733     0.046     0.200
     0.215    -0.947     0.200
     0.215    -0.275     0.200
     0.247     1.333     0.200
     0.595    -0.190     0.200
     0.608    -0.048     0.200
     0.621    -0.510     0.200
     0.629     0.298     0.200
     0.650    -0.525     0.200
     0.733     0.534     0.200
     0.591    -0.110     0.200
     0.729     0.472     0.200
     0.233     1.208     0.200
     0.579    -0.584     0.200
     0.591    -0.294     0.200
     0.636     0.571     0.200
     0.628    -0.926     0.200
     0.724    -0.364     0.200
     0.158    -0.278     0.200
     0.231     1.355     0.200
     0.215     1.191     0.200
     0.246     0.884     0.200
     0.533    -0.194     0.200
     0.626    -0.712     0.200
     0.668    -0.532     0.200
     0.681     0.368     0.200
     0.683     0.393     0.200
     0.212    -0.289     0.200
     0.212    -0.484     0.200
     0.594    -0.766     0.200
     0.624    -0.223     0.200
     0.628     0.599     0.200
     0.653    -0.839     0.200
     0.698    -0.643     0.200
     0.731     0.480     0.200
     0.233    -1.381     0.200
     0.610    -1.465     0.200
     0.608     0.016     0.200
     0.616    -0.146     0.200
     0.616    -0.592     0.200
     0.629     0.211     0.200
     0.666    -0.501     0.200
     0.709    -0.125     0.200
     0.748     0.445     0.200
     0.168    -0.439     0.200
     0.536    -0.036     0.200
     0.611    -0.141     0.200
     0.657    -0.566     0.200
     0.657    -1.105     0.200
     0.694    -0.019     0.200
     0.228     0.044     0.200
     0.228    -1.144     0.200
     0.250     1.289     0.200
     0.609    -0.017     0.200
     0.621     0.690     0.200
     0.655    -0.816     0.200
     0.610    -0.051     0.200
     0.610    -0.777     0.200
     0.619     0.073     0.200
     0.746     0.302     0.200
     0.247     1.057     0.200
     0.613     0.075     0.200
     0.613    -0.853     0.200
     0.620     0.525     0.200
     0.625     0.370     0.200
     0.603    -1.054     0.200
     0.651    -0.514     0.200
     0.752     0.171     0.200
     0.694     0.488     0.200
     0.194    -0.061     0.200
     0.285     0.576     0.200
     0.573     0.185     0.200
     0.573    -0.331     0.200
     0.586     0.227     0.200
     0.643    -0.895     0.200
     0.638    -0.020     0.200
     0.646     0.348     0.200
     0.714     0.170     0.200
     0.189    -0.288     0.200
     0.571    -0.173     0.200
     0.571    -0.404     0.200
     0.584    -0.084     0.200
     0.645    -1.809     0.200
     0.645    -1.171     0.200
     0.650    -0.584     0.200
     0.642     0.294     0.200
     0.708     0.448     0.200
     0.153    -0.779     0.200
     0.153    -1.001     0.200
     0.409    -1.014     0.200
     0.444    -0.931     0.200
     0.449    -0.546     0.200
     0.459    -0.665     0.200
     0.529    -0.617     0.200
     0.602    -0.678     0.200
     0.594    -0.337     0.200
     0.656    -0.393     0.200
     0.672    -0.211     0.200
     0.761     0.131     0.200
     0.761    -0.209     0.200
     0.469    -0.812     0.200
     0.471    -0.916     0.200
     0.515    -0.769     0.200
     0.761    -0.847     0.200
     0.847    -0.179     0.200
     0.178    -0.240     0.200
     0.178     0.096     0.200
     0.384    -1.351     0.200
     0.384    -0.921     0.200
     0.366    -0.699     0.200
     0.420     1.127     0.200
     0.475    -1.072     0.200
     0.475    -0.619     0.200
     0.635    -1.338     0.200
     0.637    -1.129     0.200
     0.725    -0.590     0.200
     0.725    -0.278     0.200
     0.766    -0.168     0.200
     0.766     1.207     0.200
     0.936    -0.945     0.200
     0.091    -2.041     0.200
     0.091    -1.640     0.200
     0.096    -1.552     0.200
     0.612     0.277     0.200
     0.623    -0.241     0.200
     0.799     0.003     0.200
     0.822    -0.399     0.200
     0.851    -0.292     0.200
     0.111    -0.655     0.200
     0.607    -1.119     0.200
     0.623     0.028     0.200
     0.630    -0.795     0.200
     0.782     0.029     0.200
     0.815    -0.287     0.200
     0.323    -0.747     0.200
     0.451    -1.090     0.200
     0.663    -1.798     0.200
     0.714    -0.536     0.200
     0.769     0.127     0.200
     0.442    -0.959     0.200
     0.703    -1.490     0.200
     0.692    -0.066     0.200
     0.684     1.408     0.200
     0.747     1.499     0.200
     0.323    -0.906     0.200
     0.443    -0.602     0.200
     0.709    -0.845     0.200
     0.708    -0.193     0.200
     0.734     0.696     0.200
     0.742     0.117     0.200
     0.778     0.615     0.200
     0.868    -0.745     0.200
     0.815     0.773     0.200
     0.265    -0.689     0.200
     0.460    -0.968     0.200
     0.641    -0.145     0.200
     0.711    -0.640     0.200
     0.739     0.023     0.200
     0.717     0.499     0.200
     0.757    -0.528     0.200
     0.724     0.108     0.200
     0.947    -0.202     0.200
     0.096    -0.474     0.200
     0.127    -0.637     0.200
     0.196    -0.471     0.200
     0.268    -0.337     0.200
     0.268    -0.209     0.200
     0.292    -1.413     0.200
     0.254     0.082     0.200
     0.315    -0.974     0.200
     0.317    -0.077     0.200
     0.331    -0.475     0.200
     0.331    -0.305     0.200
     0.363    -0.531     0.200
     0.378    -0.417     0.200
     0.399    -0.636     0.200
     0.409    -0.781     0.200
     0.376    -0.313     0.200
     0.400    -0.050     0.200
     0.390     0.226     0.200
     0.399     0.613     0.200
     0.443    -0.798     0.200
     0.460    -0.191     0.200
     0.478    -1.331     0.200
     0.481    -1.658     0.200
     0.461    -0.266     0.200
     0.499    -0.367     0.200
     0.529    -1.273     0.200
     0.520     0.151     0.200
     0.562    -0.589     0.200
     0.611     0.944     0.200
     0.665    -0.017     0.200
     0.680    -0.169     0.200
     0.714    -0.382     0.200
     0.716    -0.550     0.200
     0.708     0.234     0.200
     0.776    -0.121     0.200
     0.742     0.885     0.200
     0.804    -0.376     0.200
     0.918    -0.086     0.200
     0.291    -0.114     0.200
     0.481    -1.067     0.200
     0.481    -0.075     0.200
     0.549    -0.283     0.200
     0.579    -0.540     0.200
     0.676    -0.956     0.200
     0.682     0.029     0.200
     0.705     0.501     0.200
     0.741    -0.089     0.200
     0.821     0.974     0.200
     0.821     0.271     0.200
     0.074    -0.288     0.200
     0.279     0.552     0.200
     0.287     0.078     0.200
     0.327    -0.690     0.200
     0.397    -0.473     0.200
     0.404    -0.955     0.200
     0.451    -0.623     0.200
     0.454     0.280     0.200
     0.477    -1.034     0.200
     0.479    -1.100     0.200
     0.555    -0.745     0.200
     0.555    -0.478     0.200
     0.596    -1.008     0.200
     0.615    -0.914     0.200
     0.618    -0.632     0.200
     0.646    -1.199     0.200
     0.652    -0.102     0.200
     0.688    -1.220     0.200
     0.693    -1.082     0.200
     0.736    -0.950     0.200
     0.770    -0.970     0.200
     0.770    -0.723     0.200
     0.761    -0.376     0.200
     0.782    -0.522     0.200
     0.808    -0.677     0.200
     0.840    -0.600     0.200
     0.862    -0.696     0.200
     0.894    -0.187     0.200
     0.899    -0.685     0.200
     0.902    -0.477     0.200
     0.929    -0.023     0.200
     0.940    -0.442     0.200
     0.267     0.630     0.200
     0.277     0.109     0.200
     0.312    -0.089     0.200
     0.331    -0.341     0.200
     0.391    -0.665     0.200
     0.395    -0.673     0.200
     0.453     0.020     0.200
     0.459    -0.665     0.200
     0.468    -0.821     0.200
     0.469    -0.750     0.200
     0.551    -0.330     0.200
     0.589    -1.060     0.200
     0.606    -0.880     0.200
     0.610    -0.669     0.200
     0.636    -1.084     0.200
     0.636    -0.928     0.200
     0.640     0.404     0.200
     0.679    -1.013     0.200
     0.685    -1.276     0.200
     0.725    -0.719     0.200
     0.749     0.019     0.200
     0.775    -0.978     0.200
     0.775    -0.822     0.200
     0.776    -0.926     0.200
     0.787     0.028     0.200
     0.811    -0.358     0.200
     0.821     1.260     0.200
     0.835    -0.856     0.200
     0.856    -0.926     0.200
     0.883    -0.200     0.200
     0.893    -0.824     0.200
     0.893    -0.518     0.200
     0.938    -0.316     0.200
     0.992    -0.735     0.200
     0.254    -0.789     0.200
     0.516    -0.064     0.200
     0.641    -0.175     0.200
     0.701     0.091     0.200
     0.703     0.066     0.200
     0.703    -0.514     0.200
     0.773     0.758     0.200
     0.311    -0.160     0.200
     0.265    -1.071     0.200
     0.629    -0.297     0.200
     0.615    -0.852     0.200
     0.792     0.343     0.200
     0.836     0.082     0.200
     0.296    -0.297     0.200
     0.351    -0.942     0.200
     0.356    -0.349     0.200
     0.442    -0.366     0.200
     0.509    -0.659     0.200
     0.687     0.207     0.200
     0.137    -0.046     0.200
     0.137    -0.177     0.200
     0.178    -0.429     0.200
     0.174     0.192     0.200
     0.166    -0.364     0.200
     0.167    -0.306     0.200
     0.188    -0.194     0.200
     0.195     0.304     0.200
     0.296    -0.548     0.200
     0.269    -0.465     0.200
     0.300    -0.224     0.200
     0.300    -0.333     0.200
     0.292    -0.708     0.200
     0.357    -0.507     0.200
     0.421     0.043     0.200
     0.437    -0.017     0.200
     0.464    -0.634     0.200
     0.496    -0.121     0.200
     0.511    -0.559     0.200
     0.502     0.091     0.200
     0.522    -0.538     0.200
     0.551    -0.616     0.200
     0.551    -0.380     0.200
     0.533    -0.326     0.200
     0.535    -0.649     0.200
     0.607    -0.771     0.200
     0.618     1.693     0.200
     0.644    -0.478     0.200
     0.644    -0.648     0.200
     0.625     0.081     0.200
     0.642    -0.240     0.200
     0.642     0.000     0.200
     0.650     0.235     0.200
     0.670    -0.008     0.200
     0.670     0.643     0.200
     0.727     0.157     0.200
     0.716     0.570     0.200
     0.715    -0.263     0.200
     0.738     0.078     0.200
     0.785    -0.020     0.200
     0.781    -0.209     0.200
     0.781    -0.215     0.200
     0.819    -0.396     0.200
     0.841    -0.052     0.200
     0.883    -0.068     0.200
     0.927    -0.325     0.200
     0.061     0.571     0.200
     0.175     0.561     0.200
     0.207     1.230     0.200
     0.184    -0.393     0.200
     0.203    -0.295     0.200
     0.250     0.634     0.200
     0.364     0.595     0.200
     0.435    -0.664     0.200
     0.550    -0.660     0.200
     0.640    -0.581     0.200
     0.685     0.484     0.200
     0.710     0.221     0.200
     0.710     0.361     0.200
     0.151     1.087     0.200
     0.171     0.686     0.200
     0.212    -0.290     0.200
     0.230     0.445     0.200
     0.234     0.249     0.200
     0.295    -0.375     0.200
     0.317    -0.812     0.200
     0.357     0.219     0.200
     0.364     0.537     0.200
     0.423    -0.813     0.200
     0.551     0.152     0.200
     0.549    -0.512     0.200
     0.549    -0.363     0.200
     0.554    -0.391     0.200
     0.568     2.112     0.200
     0.618    -0.700     0.200
     0.618     0.285     0.200
     0.736     0.090     0.200
     0.728     0.323     0.200
     0.113     0.275     0.200
     0.164     1.158     0.200
     0.178     0.489     0.200
     0.181     0.108     0.200
     0.185     0.969     0.200
     0.201     0.425     0.200
     0.310    -0.444     0.200
     0.312     1.410     0.200
     0.335    -0.360     0.200
     0.335    -0.409     0.200
     0.369     0.537     0.200
     0.419    -0.421     0.200
     0.419    -0.609     0.200
     0.426     1.028     0.200
     0.439    -0.187     0.200
     0.469     1.389     0.200
     0.552    -0.116     0.200
     0.552    -0.382     0.200
     0.553     1.185     0.200
     0.625     0.648     0.200
     0.667     1.351     0.200
     0.667     0.180     0.200
     0.667     0.094     0.200
     0.696     1.114     0.200
     0.706     1.569     0.200
     0.719    -1.061     0.200
     0.723     0.918     0.200
     0.744     0.389     0.200
     0.744     0.085     0.200
     0.757     0.342     0.200
     0.798    -0.318     0.200
     0.798     0.206     0.200
     0.299     0.903     0.200
     0.361    -0.646     0.200
     0.367    -0.919     0.200
     0.367    -1.024     0.200
     0.432     0.822     0.200
     0.385     0.257     0.200
     0.406     0.339     0.200
     0.458     0.651     0.200
     0.406     0.871     0.200
     0.417    -0.258     0.200
     0.417    -0.711     0.200
     0.451     0.287     0.200
     0.511     0.833     0.200
     0.549     0.673     0.200
     0.558     2.009     0.200
     0.573     0.765     0.200
     0.658    -0.024     0.200
     0.678    -0.334     0.200
     0.679     1.204     0.200
     0.635    -0.359     0.200
     0.674     0.173     0.200
     0.677     0.013     0.200
     0.719     0.128     0.200
     0.712    -0.251     0.200
     0.712    -0.423     0.200
     0.729    -0.659     0.200
     0.762     0.584     0.200
     0.724     0.645     0.200
     0.724     0.836     0.200
     0.759     0.389     0.200
     0.749     0.078     0.200
     0.749     0.551     0.200
     0.773     0.069     0.200
     0.803    -1.316     0.200
     0.803    -0.382     0.200
     0.773     0.812     0.200
     0.792     1.216     0.200
     0.801     0.747     0.200
     0.292     1.126     0.200
     0.360    -1.005     0.200
     0.392     0.184     0.200
     0.413     0.343     0.200
     0.423    -0.818     0.200
     0.412     1.015     0.200
     0.450     0.797     0.200
     0.458    -0.251     0.200
     0.449    -0.069     0.200
     0.505     1.106     0.200
     0.541     0.342     0.200
     0.551     1.717     0.200
     0.651    -0.184     0.200
     0.639    -0.297     0.200
     0.674     1.192     0.200
     0.671    -0.183     0.200
     0.673     1.302     0.200
     0.677     0.243     0.200
     0.680     0.211     0.200
     0.707    -0.075     0.200
     0.707    -0.356     0.200
     0.722    -0.174     0.200
     0.722     0.258     0.200
     0.731     0.724     0.200
     0.731     0.591     0.200
     0.755     0.634     0.200
     0.757     1.065     0.200
     0.751     1.511     0.200
     0.751     0.641     0.200
     0.772     0.523     0.200
     0.801     0.342     0.200
     0.776     1.611     0.200
     0.214     1.137     0.200
     0.227     0.836     0.200
     0.373    -1.688     0.200
     0.386     0.203     0.200
     0.400     0.222     0.200
     0.406    -0.281     0.200
     0.406    -0.557     0.200
     0.411     0.767     0.200
     0.465     0.492     0.200
     0.474    -0.628     0.200
     0.552     0.470     0.200
     0.555     1.596     0.200
     0.588    -0.714     0.200
     0.645    -0.592     0.200
     0.662    -0.052     0.200
     0.685    -0.188     0.200
     0.681    -0.149     0.200
     0.685    -0.196     0.200
     0.688    -0.301     0.200
     0.688    -0.089     0.200
     0.708    -1.148     0.200
     0.725     0.144     0.200
     0.725    -0.000     0.200
     0.725     0.181     0.200
     0.738    -0.755     0.200
     0.738    -0.214     0.200
     0.762     0.713     0.200
     0.771     0.477     0.200
     0.773     0.877     0.200
     0.787     0.089     0.200
     0.791    -0.852     0.200
     0.791     0.150     0.200
     0.786     0.671     0.200
     0.805     1.027     0.200
     0.814     0.466     0.200
     0.198     1.094     0.200
     0.208    -0.093     0.200
     0.294     0.842     0.200
     0.391    -0.345     0.200
     0.410     0.242     0.200
     0.425    -0.809     0.200
     0.425    -0.920     0.200
     0.426     1.508     0.200
     0.450     0.636     0.200
     0.446     0.455     0.200
     0.457    -0.394     0.200
     0.507     1.057     0.200
     0.542     0.917     0.200
     0.553     2.013     0.200
     0.570    -0.238     0.200
     0.636    -0.525     0.200
     0.651    -0.329     0.200
     0.677     1.299     0.200
     0.671    -0.284     0.200
     0.674     0.169     0.200
     0.677     0.254     0.200
     0.677    -0.181     0.200
     0.677     0.000     0.200
     0.705    -0.097     0.200
     0.721    -0.196     0.200
     0.730     0.419     0.200
     0.748     0.412     0.200
     0.748     0.532     0.200
     0.754     0.417     0.200
     0.753     0.540     0.200
     0.769     0.502     0.200
     0.773     1.210     0.200
     0.791     1.192     0.200
     0.804    -0.662     0.200
     0.804    -0.556     0.200
     0.800     0.833     0.200
     0.199     1.283     0.200
     0.209     0.143     0.200
     0.295     1.389     0.200
     0.390    -0.288     0.200
     0.412    -0.527     0.200
     0.409     0.298     0.200
     0.424    -0.976     0.200
     0.424    -0.856     0.200
     0.452     0.671     0.200
     0.446     0.631     0.200
     0.459    -0.379     0.200
     0.543     0.442     0.200
     0.554     1.986     0.200
     0.570    -0.034     0.200
     0.636    -0.588     0.200
     0.672    -0.541     0.200
     0.677     0.565     0.200
     0.674     0.302     0.200
     0.677     0.403     0.200
     0.677    -0.307     0.200
     0.677    -0.137     0.200
     0.677     0.055     0.200
     0.706    -0.298     0.200
     0.706    -0.034     0.200
     0.722    -0.292     0.200
     0.729     0.186     0.200
     0.729    -0.104     0.200
     0.748     0.587     0.200
     0.748     0.847     0.200
     0.755     0.461     0.200
     0.754     0.427     0.200
     0.773     1.019     0.200
     0.791     0.870     0.200
     0.804    -1.122     0.200
     0.804    -0.395     0.200
     0.800     0.768     0.200
     0.151     0.941     0.200
     0.303    -0.620     0.200
     0.303    -1.249     0.200
     0.307    -0.184     0.200
     0.350     0.510     0.200
     0.347     0.991     0.200
     0.358     0.806     0.200
     0.401     1.389     0.200
     0.441    -0.017     0.200
     0.446     0.664     0.200
     0.477    -0.634     0.200
     0.507     0.362     0.200
     0.519    -0.310     0.200
     0.551    -0.632     0.200
     0.542    -0.189     0.200
     0.556    -0.889     0.200
     0.560     0.588     0.200
     0.569     1.207     0.200
     0.574     0.602     0.200
     0.610    -0.490     0.200
     0.652    -1.166     0.200
     0.676     0.691     0.200
     0.695     0.238     0.200
     0.695    -0.387     0.200
     0.701     0.524     0.200
     0.762     0.272     0.200
     0.762    -0.028     0.200
     0.805    -0.243     0.200
     0.058     0.319     0.200
     0.158     0.908     0.200
     0.197     0.772     0.200
     0.201     1.647     0.200
     0.208    -0.404     0.200
     0.208    -0.084     0.200
     0.260     1.337     0.200
     0.364     0.923     0.200
     0.363    -0.830     0.200
     0.360    -0.280     0.200
     0.384     0.288     0.200
     0.456    -0.857     0.200
     0.465     0.391     0.200
     0.487    -0.628     0.200
     0.572    -0.165     0.200
     0.581    -0.070     0.200
     0.617    -1.178     0.200
     0.617    -0.725     0.200
     0.617    -0.881     0.200
     0.621     1.038     0.200
     0.675     0.834     0.200
     0.675     0.256     0.200
     0.734    -0.248     0.200
     0.734     0.002     0.200
     0.740     0.390     0.200
     0.761     0.951     0.200
     0.776     0.663     0.200
     0.056     0.903     0.200
     0.161     1.052     0.200
     0.196     0.978     0.200
     0.206    -0.302     0.200
     0.206    -0.130     0.200
     0.257     1.699     0.200
     0.359    -0.072     0.200
     0.366     0.744     0.200
     0.386     1.115     0.200
     0.387     0.666     0.200
     0.456    -1.037     0.200
     0.463     0.612     0.200
     0.489    -0.696     0.200
     0.542     0.524     0.200
     0.572    -0.839     0.200
     0.572    -0.565     0.200
     0.581    -0.726     0.200
     0.606     0.633     0.200
     0.606     0.915     0.200
     0.618    -0.897     0.200
     0.618    -0.795     0.200
     0.619     0.872     0.200
     0.673     0.545     0.200
     0.732    -0.008     0.200
     0.732     0.148     0.200
     0.732     0.288     0.200
     0.724     0.894     0.200
     0.738     0.640     0.200
     0.759     1.479     0.200
     0.773     0.553     0.200
     0.979    -0.556     0.200
     0.179     0.074     0.200
     0.293     0.610     0.200
     0.309    -0.446     0.200
     0.345    -0.704     0.200
     0.364    -0.175     0.200
     0.365    -0.620     0.200
     0.365    -0.753     0.200
     0.412     1.171     0.200
     0.412    -0.120     0.200
     0.471    -1.248     0.200
     0.471    -1.350     0.200
     0.477     0.584     0.200
     0.456    -0.562     0.200
     0.488    -1.062     0.200
     0.503    -0.755     0.200
     0.487    -1.683     0.200
     0.498    -1.103     0.200
     0.534     1.740     0.200
     0.501    -1.041     0.200
     0.553     0.823     0.200
     0.526    -0.654     0.200
     0.526    -0.544     0.200
     0.576    -0.286     0.200
     0.596    -0.632     0.200
     0.562     0.029     0.200
     0.605    -0.962     0.200
     0.572    -0.596     0.200
     0.583    -0.007     0.200
     0.641     0.714     0.200
     0.644    -0.097     0.200
     0.644     0.192     0.200
     0.658    -0.343     0.200
     0.672    -0.377     0.200
     0.689     0.154     0.200
     0.756    -0.672     0.200
     0.769    -0.950     0.200
     0.755     0.375     0.200
     0.756     0.278     0.200
     0.795     1.180     0.200
     0.822    -0.846     0.200
     0.818    -0.035     0.200
     0.882    -0.275     0.200
     0.853    -0.062     0.200
     0.906    -0.319     0.200
     0.955    -0.222     0.200
     0.144    -0.616     0.200
     0.244    -1.620     0.200
     0.244    -0.081     0.200
     0.245    -0.273     0.200
     0.276     1.182     0.200
     0.316     1.156     0.200
     0.358     0.947     0.200
     0.374    -0.740     0.200
     0.492     1.472     0.200
     0.515    -0.420     0.200
     0.523    -0.633     0.200
     0.523    -0.742     0.200
     0.545     1.214     0.200
     0.547     0.729     0.200
     0.544     0.295     0.200
     0.557    -0.240     0.200
     0.562     1.585     0.200
     0.560     0.685     0.200
     0.632    -0.195     0.200
     0.636    -0.069     0.200
     0.657     0.723     0.200
     0.689    -0.050     0.200
     0.713     0.751     0.200
     0.715    -0.409     0.200
     0.765     0.275     0.200
     0.784     0.239     0.200
     0.796     0.934     0.200
     0.799     0.206     0.200
     0.849    -0.464     0.200
     0.880    -0.376     0.200
     0.121    -0.223     0.200
     0.125    -1.089     0.200
     0.142    -0.203     0.200
     0.197    -0.519     0.200
     0.197    -0.709     0.200
     0.269    -0.743     0.200
     0.269    -1.063     0.200
     0.269     0.067     0.200
     0.269     0.187     0.200
     0.351    -0.634     0.200
     0.367    -0.697     0.200
     0.372    -0.109     0.200
     0.403    -0.583     0.200
     0.403    -0.303     0.200
     0.414    -0.513     0.200
     0.408    -0.183     0.200
     0.427     0.023     0.200
     0.453    -0.861     0.200
     0.454    -0.661     0.200
     0.459    -0.314     0.200
     0.501    -0.843     0.200
     0.501    -1.183     0.200
     0.501    -0.353     0.200
     0.510    -0.522     0.200
     0.498    -1.033     0.200
     0.557     1.024     0.200
     0.569    -0.412     0.200
     0.569    -0.122     0.200
     0.590     0.152     0.200
     0.596    -0.801     0.200
     0.596    -0.590     0.200
     0.586    -0.313     0.200
     0.595    -0.705     0.200
     0.585    -0.252     0.200
     0.585    -0.180     0.200
     0.600    -0.494     0.200
     0.613    -0.111     0.200
     0.613     0.189     0.200
     0.624    -0.145     0.200
     0.650     1.344     0.200
     0.650     1.174     0.200
     0.647     0.469     0.200
     0.643    -0.360     0.200
     0.663    -0.474     0.200
     0.663    -0.134     0.200
     0.663     0.056     0.200
     0.663     0.137     0.200
     0.659    -0.068     0.200
     0.694    -0.579     0.200
     0.694    -0.334     0.200
     0.705     1.118     0.200
     0.701    -0.157     0.200
     0.739    -0.068     0.200
     0.747     1.252     0.200
     0.741     0.294     0.200
     0.741     0.464     0.200
     0.074    -0.414     0.200
     0.100     0.202     0.200
     0.125    -0.892     0.200
     0.126    -0.919     0.200
     0.121     0.196     0.200
     0.128    -0.352     0.200
     0.240    -1.206     0.200
     0.199    -0.223     0.200
     0.219    -0.455     0.200
     0.315    -0.593     0.200
     0.372    -0.099     0.200
     0.419    -0.663     0.200
     0.391    -0.109     0.200
     0.443     0.074     0.200
     0.453     0.011     0.200
     0.455    -0.332     0.200
     0.461    -0.298     0.200
     0.566     0.089     0.200
     0.606    -0.530     0.200
     0.583     0.079     0.200
     0.579     0.035     0.200
     0.577     0.829     0.200
     0.663    -0.239     0.200
     0.663    -0.353     0.200
     0.669     0.571     0.200
     0.761     0.290     0.200
     0.782    -0.130     0.200
     0.782    -0.365     0.200
     0.812    -0.308     0.200
     0.812     0.099     0.200
     0.812    -0.137     0.200
     0.823    -0.252     0.200
     0.838    -0.249     0.200
     0.881     0.080     0.200
     0.072     0.359     0.200
     0.159    -0.053     0.200
     0.211     0.628     0.200
     0.275    -0.660     0.200
     0.283    -0.143     0.200
     0.283    -0.258     0.200
     0.327    -0.774     0.200
     0.327    -0.920     0.200
     0.384    -0.393     0.200
     0.383    -0.773     0.200
     0.375    -0.644     0.200
     0.448    -0.445     0.200
     0.434    -0.283     0.200
     0.438    -0.823     0.200
     0.483    -0.844     0.200
     0.493    -1.152     0.200
     0.513    -0.850     0.200
     0.610    -0.882     0.200
     0.549    -0.935     0.200
     0.603    -1.041     0.200
     0.601    -0.503     0.200
     0.654    -0.402     0.200
     0.630    -0.730     0.200
     0.698     0.683     0.200
     0.670    -0.862     0.200
     0.663     0.357     0.200
     0.669     0.418     0.200
     0.727     0.265     0.200
     0.744     1.031     0.200
     0.721    -0.289     0.200
     0.696     0.191     0.200
     0.772    -0.373     0.200
     0.772     0.240     0.200
     0.767    -0.069     0.200
     0.769     0.461     0.200
     0.792    -0.351     0.200
     0.867    -0.522     0.200
     0.835    -0.186     0.200
     0.876    -0.039     0.200
     0.957    -0.376     0.200
     0.156    -0.827     0.200
     0.256    -0.748     0.200
     0.259    -0.700     0.200
     0.266    -0.761     0.200
     0.284     0.358     0.200
     0.274    -0.441     0.200
     0.308    -0.069     0.200
     0.324    -0.448     0.200
     0.329     0.129     0.200
     0.348    -0.531     0.200
     0.370     0.068     0.200
     0.397    -0.569     0.200
     0.406    -0.404     0.200
     0.419    -0.625     0.200
     0.458     0.059     0.200
     0.477     1.152     0.200
     0.483     1.647     0.200
     0.473    -0.077     0.200
     0.507    -0.408     0.200
     0.573     0.614     0.200
     0.557     0.674     0.200
     0.610     0.166     0.200
     0.610     0.368     0.200
     0.592     0.896     0.200
     0.637     0.237     0.200
     0.599    -0.086     0.200
     0.659     2.166     0.200
     0.648    -0.137     0.200
     0.659     0.117     0.200
     0.665    -0.364     0.200
     0.658     0.123     0.200
     0.677    -0.220     0.200
     0.669     0.062     0.200
     0.696     1.637     0.200
     0.682     0.455     0.200
     0.774    -0.057     0.200
     0.814     0.063     0.200
     0.841     0.015     0.200
     0.841    -0.058     0.200
     0.847     0.035     0.200
     0.157    -0.932     0.200
     0.225     0.842     0.200
     0.347     1.285     0.200
     0.411    -0.950     0.200
     0.458     1.145     0.200
     0.436    -0.802     0.200
     0.436    -0.903     0.200
     0.478     1.833     0.200
     0.447    -0.465     0.200
     0.460    -0.472     0.200
     0.473    -0.627     0.200
     0.590     0.505     0.200
     0.596     0.675     0.200
     0.691    -0.226     0.200
     0.705     0.774     0.200
     0.715    -0.921     0.200
     0.715    -0.761     0.200
     0.697    -0.856     0.200
     0.708    -0.655     0.200
     0.731    -0.643     0.200
     0.843    -0.555     0.200
     0.853    -0.058     0.200
     0.871     0.018     0.200
     0.925    -0.588     0.200
     0.912    -0.500     0.200
     0.956    -0.368     0.200
     0.154    -0.042     0.200
     0.211     0.467     0.200
     0.282    -0.307     0.200
     0.282    -0.158     0.200
     0.332    -0.743     0.200
     0.332    -0.907     0.200
     0.370    -0.577     0.200
     0.387    -0.997     0.200
     0.387    -0.249     0.200
     0.439    -0.317     0.200
     0.443    -0.623     0.200
     0.450    -0.574     0.200
     0.487    -1.347     0.200
     0.497    -1.183     0.200
     0.518    -0.990     0.200
     0.545    -0.019     0.200
     0.552    -0.713     0.200
     0.611    -0.687     0.200
     0.598    -0.303     0.200
     0.605    -0.761     0.200
     0.633    -0.656     0.200
     0.659    -0.581     0.200
     0.663     0.715     0.200
     0.668    -0.222     0.200
     0.673    -0.559     0.200
     0.696    -0.179     0.200
     0.702     0.541     0.200
     0.725    -0.293     0.200
     0.732     0.444     0.200
     0.747     1.406     0.200
     0.768     0.499     0.200
     0.772     0.004     0.200
     0.774     0.883     0.200
     0.774     0.063     0.200
     0.794    -0.430     0.200
     0.794    -0.172     0.200
     0.835    -0.081     0.200
     0.876     0.007     0.200
     0.055    -0.934     0.200
     0.105     0.286     0.200
     0.149     1.417     0.200
     0.225    -1.697     0.200
     0.286     0.939     0.200
     0.319     0.900     0.200
     0.323     0.705     0.200
     0.364    -0.091     0.200
     0.376     0.693     0.200
     0.483    -0.629     0.200
     0.506     1.276     0.200
     0.514     0.572     0.200
     0.534    -0.364     0.200
     0.549    -0.634     0.200
     0.549    -0.759     0.200
     0.583    -0.758     0.200
     0.578     0.334     0.200
     0.579     0.095     0.200
     0.617    -0.022     0.200
     0.639     0.440     0.200
     0.662    -0.101     0.200
     0.678     0.785     0.200
     0.691    -0.914     0.200
     0.694     0.191     0.200
     0.765     0.112     0.200
     0.199    -0.901     0.200
     0.224     0.153     0.200
     0.227    -0.314     0.200
     0.231     0.004     0.200
     0.276    -0.419     0.200
     0.313    -0.240     0.200
     0.330    -0.067     0.200
     0.402    -0.972     0.200
     0.417    -1.663     0.200
     0.437    -0.559     0.200
     0.460     0.248     0.200
     0.465     0.066     0.200
     0.481    -0.431     0.200
     0.501    -0.700     0.200
     0.508    -0.627     0.200
     0.527    -0.239     0.200
     0.558    -0.195     0.200
     0.580    -0.821     0.200
     0.585    -1.326     0.200
     0.608    -0.138     0.200
     0.626    -0.558     0.200
     0.648    -0.443     0.200
     0.673    -1.594     0.200
     0.677    -0.792     0.200
     0.670    -0.457     0.200
     0.689    -0.768     0.200
     0.700    -1.627     0.200
     0.726    -1.178     0.200
     0.733    -0.464     0.200
     0.733    -0.188     0.200
     0.723    -0.105     0.200
     0.730    -0.473     0.200
     0.735    -0.248     0.200
     0.801    -1.008     0.200
     0.791    -0.543     0.200
     0.805    -0.360     0.200
     0.808    -0.251     0.200
     0.827    -0.967     0.200
     0.865    -0.783     0.200
     0.866    -0.549     0.200
     0.872    -1.076     0.200
     0.136    -0.127     0.200
     0.154    -0.730     0.200
     0.176    -0.818     0.200
     0.176    -0.611     0.200
     0.280     0.365     0.200
     0.280     0.166     0.200
     0.257     0.467     0.200
     0.278     0.622     0.200
     0.340     0.906     0.200
     0.340     0.703     0.200
     0.387    -0.550     0.200
     0.387    -0.320     0.200
     0.385    -0.819     0.200
     0.385    -0.933     0.200
     0.378    -0.790     0.200
     0.378    -0.889     0.200
     0.342     1.065     0.200
     0.357     1.381     0.200
     0.380     1.339     0.200
     0.425     0.246     0.200
     0.435    -0.838     0.200
     0.405     0.037     0.200
     0.515    -0.637     0.200
     0.505     2.000     0.200
     0.546     1.461     0.200
     0.580    -0.193     0.200
     0.593     0.458     0.200
     0.601     1.560     0.200
     0.669    -0.633     0.200
     0.638     1.538     0.200
     0.631     0.290     0.200
     0.690    -0.427     0.200
     0.661    -0.018     0.200
     0.697     0.008     0.200
     0.697    -0.301     0.200
     0.732    -0.485     0.200
     0.732    -0.586     0.200
     0.705    -0.428     0.200
     0.704    -0.416     0.200
     0.708    -0.498     0.200
     0.708    -0.314     0.200
     0.736    -0.063     0.200
     0.743     1.157     0.200
     0.781    -0.111     0.200
     0.745     0.341     0.200
     0.764     1.289     0.200
     0.745     0.599     0.200
     0.801    -0.034     0.200
     0.774     0.293     0.200
     0.852    -0.422     0.200
     0.894    -0.139     0.200
     0.112     0.423     0.200
     0.148     0.796     0.200
     0.180     0.611     0.200
     0.224     0.658     0.200
     0.227     1.557     0.200
     0.230     0.782     0.200
     0.257     0.978     0.200
     0.275    -0.064     0.200
     0.274     0.977     0.200
     0.274     0.858     0.200
     0.301    -0.546     0.200
     0.333     1.550     0.200
     0.338     0.533     0.200
     0.376    -0.333     0.200
     0.386    -0.762     0.200
     0.420    -0.506     0.200
     0.465    -0.476     0.200
     0.479     1.024     0.200
     0.497     1.705     0.200
     0.513     1.246     0.200
     0.513     0.717     0.200
     0.544     1.518     0.200
     0.554    -0.317     0.200
     0.604    -0.645     0.200
     0.661     2.251     0.200
     0.681     1.690     0.200
     0.703     2.445     0.200
     0.703     1.932     0.200
     0.757     0.815     0.200
     0.757     0.635     0.200
     0.757     0.868     0.200
     0.348    -0.196     0.200
     0.393    -0.470     0.200
     0.445    -0.805     0.200
     0.442     0.063     0.200
     0.510    -1.437     0.200
     0.511    -1.352     0.200
     0.512    -1.628     0.200
     0.600    -0.541     0.200
     0.612    -1.032     0.200
     0.643    -0.552     0.200
     0.677    -0.829     0.200
     0.682     1.236     0.200
     0.713     0.458     0.200
     0.714    -0.624     0.200
     0.718    -0.324     0.200
     0.785    -0.246     0.200
     0.788    -0.416     0.200
     0.817     0.790     0.200
     0.843    -0.359     0.200
     0.869    -0.105     0.200
     0.908    -0.112     0.200
     0.143    -0.757     0.200
     0.247     1.380     0.200
     0.306    -0.526     0.200
     0.317    -0.302     0.200
     0.329     0.583     0.200
     0.370    -0.186     0.200
     0.374     1.251     0.200
     0.408    -0.476     0.200
     0.412    -0.588     0.200
     0.414     0.269     0.200
     0.436    -0.841     0.200
     0.504     0.865     0.200
     0.523    -0.727     0.200
     0.557    -0.691     0.200
     0.588     0.783     0.200
     0.598    -0.430     0.200
     0.607     0.180     0.200
     0.601    -0.657     0.200
     0.655    -0.452     0.200
     0.681    -0.230     0.200
     0.681    -0.562     0.200
     0.702    -0.411     0.200
     0.716    -0.543     0.200
     0.722    -0.367     0.200
     0.720     0.287     0.200
     0.723    -0.037     0.200
     0.726    -0.221     0.200
     0.740     1.517     0.200
     0.733     0.132     0.200
     0.757    -0.143     0.200
     0.765     0.765     0.200
     0.790     0.877     0.200
     0.788    -0.536     0.200
     0.794     0.736     0.200
     0.806    -0.017     0.200
     0.876    -0.837     0.200
     0.137    -1.058     0.200
     0.315    -0.174     0.200
     0.329     0.295     0.200
     0.365    -0.365     0.200
     0.375     1.019     0.200
     0.421    -1.373     0.200
     0.406    -0.403     0.200
     0.421    -0.058     0.200
     0.432    -1.228     0.200
     0.506     0.988     0.200
     0.519     0.740     0.200
     0.529    -0.480     0.200
     0.588     1.317     0.200
     0.610     1.031     0.200
     0.601    -0.407     0.200
     0.653    -0.011     0.200
     0.685     0.591     0.200
     0.685    -0.210     0.200
     0.719    -0.623     0.200
     0.706     0.009     0.200
     0.726    -0.300     0.200
     0.729    -0.252     0.200
     0.724     0.420     0.200
     0.732     0.021     0.200
     0.742     1.379     0.200
     0.738     0.134     0.200
     0.762    -0.056     0.200
     0.775     1.391     0.200
     0.766     1.006     0.200
     0.792     1.114     0.200
     0.799     0.730     0.200
     0.162    -0.331     0.200
     0.134    -0.209     0.200
     0.162    -0.900     0.200
     0.209    -0.418     0.200
     0.165     0.109     0.200
     0.177     0.209     0.200
     0.195    -0.185     0.200
     0.314    -1.183     0.200
     0.406    -0.378     0.200
     0.366    -0.234     0.200
     0.463    -1.006     0.200
     0.418    -0.517     0.200
     0.418    -0.555     0.200
     0.531    -1.000     0.200
     0.460    -0.514     0.200
     0.501    -0.327     0.200
     0.583    -0.953     0.200
     0.522    -0.448     0.200
     0.572    -0.678     0.200
     0.574    -0.377     0.200
     0.683    -0.894     0.200
     0.614    -0.799     0.200
     0.632     0.214     0.200
     0.648     0.469     0.200
     0.708    -0.338     0.200
     0.677    -0.369     0.200
     0.689    -0.748     0.200
     0.767    -0.049     0.200
     0.776    -0.316     0.200
     0.726    -0.270     0.200
     0.743    -0.070     0.200
     0.808    -0.342     0.200
     0.830    -0.069     0.200
     0.770    -0.426     0.200
     0.820    -1.070     0.200
     0.903    -0.490     0.200
     0.225    -0.094     0.200
     0.324     0.117     0.200
     0.365     0.397     0.200
     0.397    -0.435     0.200
     0.413    -0.269     0.200
     0.446    -0.652     0.200
     0.449    -0.348     0.200
     0.459    -0.416     0.200
     0.458    -0.887     0.200
     0.465    -0.395     0.200
     0.486     0.137     0.200
     0.565    -0.936     0.200
     0.583    -0.671     0.200
     0.583    -0.254     0.200
     0.588    -1.161     0.200
     0.608    -0.792     0.200
     0.600    -0.926     0.200
     0.665     0.929     0.200
     0.675    -0.599     0.200
     0.688    -0.745     0.200
     0.685     1.398     0.200
     0.697    -0.053     0.200
     0.760    -0.133     0.200
     0.734    -0.458     0.200
     0.740     0.052     0.200
     0.779    -0.618     0.200
     0.781    -0.436     0.200
     0.787    -0.069     0.200
     0.799     0.717     0.200
     0.809    -0.471     0.200
     0.806     0.042     0.200
     0.818    -0.564     0.200
     0.814    -0.919     0.200
     0.834    -0.635     0.200
     0.834    -0.415     0.200
     0.843    -0.203     0.200
     0.863     0.088     0.200
     0.879    -0.553     0.200
     0.947    -0.038     0.200
     0.212    -0.342     0.200
     0.284    -0.256     0.200
     0.294     0.973     0.200
     0.310     0.935     0.200
     0.279    -0.988     0.200
     0.348     0.967     0.200
     0.366     0.856     0.200
     0.414     2.022     0.200
     0.438     0.068     0.200
     0.521     0.320     0.200
     0.488    -0.479     0.200
     0.532     1.709     0.200
     0.545    -0.388     0.200
     0.526     0.304     0.200
     0.517     0.015     0.200
     0.538     0.686     0.200
     0.554     1.449     0.200
     0.552     0.741     0.200
     0.593    -0.525     0.200
     0.579     1.500     0.200
     0.592    -0.336     0.200
     0.662     0.279     0.200
     0.671    -0.104     0.200
     0.696     0.367     0.200
     0.690    -0.289     0.200
     0.706     0.820     0.200
     0.773     0.119     0.200
     0.802     0.618     0.200
     0.817    -0.044     0.200
     0.810    -0.377     0.200
     0.818     0.062     0.200
     0.261    -0.921     0.200
     0.256    -0.553     0.200
     0.357     0.378     0.200
     0.382    -1.364     0.200
     0.365     0.984     0.200
     0.384    -0.762     0.200
     0.378     1.367     0.200
     0.402     1.304     0.200
     0.424     0.299     0.200
     0.415    -1.111     0.200
     0.415     0.041     0.200
     0.447    -0.530     0.200
     0.492    -0.326     0.200
     0.492    -0.665     0.200
     0.526     2.145     0.200
     0.558    -0.103     0.200
     0.565     1.776     0.200
     0.620     1.745     0.200
     0.651    -0.805     0.200
     0.629     0.293     0.200
     0.659     1.798     0.200
     0.675    -0.621     0.200
     0.662     0.061     0.200
     0.679    -0.168     0.200
     0.686    -0.482     0.200
     0.691    -0.300     0.200
     0.693    -0.473     0.200
     0.693    -0.739     0.200
     0.747    -0.390     0.200
     0.778    -0.282     0.200
     0.999    -1.122     0.200
     0.102     0.291     0.200
     0.153    -0.128     0.200
     0.179     0.901     0.200
     0.248     0.256     0.200
     0.448    -0.346     0.200
     0.456     0.637     0.200
     0.712     0.049     0.200
     0.715    -0.212     0.200
     0.780     0.713     0.200
     0.104     0.759     0.200
     0.106    -0.870     0.200
     0.113     1.541     0.200
     0.172     0.981     0.200
     0.162     0.327     0.200
     0.163     1.786     0.200
     0.240     1.276     0.200
     0.230     0.876     0.200
     0.394    -0.150     0.200
     0.423     0.264     0.200
     0.457     0.227     0.200
     0.444     0.264     0.200
     0.459     0.057     0.200
     0.457     0.993     0.200
     0.463     1.236     0.200
     0.492     0.624     0.200
     0.610     1.104     0.200
     0.590     0.075     0.200
     0.630     0.542     0.200
     0.628    -0.657     0.200
     0.641     0.656     0.200
     0.678    -0.330     0.200
     0.687    -0.485     0.200
     0.681    -0.523     0.200
     0.717     0.057     0.200
     0.716    -0.092     0.200
     0.719    -0.122     0.200
     0.719    -0.544     0.200
     0.770    -0.623     0.200
     0.761    -0.582     0.200
     0.783     0.645     0.200
     0.782     0.610     0.200
     0.784    -0.242     0.200
     0.809     0.435     0.200
     0.829     1.383     0.200
     0.833     0.348     0.200
     0.090     0.665     0.200
     0.102    -1.350     0.200
     0.154    -0.275     0.200
     0.174     1.315     0.200
     0.243     1.037     0.200
     0.318    -0.514     0.200
     0.321    -0.584     0.200
     0.371     0.162     0.200
     0.405     0.712     0.200
     0.408     0.226     0.200
     0.433    -0.161     0.200
     0.445     0.193     0.200
     0.448    -0.552     0.200
     0.454    -0.265     0.200
     0.470     0.529     0.200
     0.468     0.133     0.200
     0.496     0.255     0.200
     0.496     1.934     0.200
     0.605    -0.496     0.200
     0.603     0.141     0.200
     0.609     1.754     0.200
     0.621     0.621     0.200
     0.635    -0.737     0.200
     0.637     1.575     0.200
     0.668    -0.065     0.200
     0.696    -0.500     0.200
     0.726     0.549     0.200
     0.726    -0.210     0.200
     0.729    -0.362     0.200
     0.774     0.370     0.200
     0.790     0.130     0.200
     0.784     0.933     0.200
     0.794     0.104     0.200
     0.798     0.113     0.200
     0.821     0.822     0.200
     0.093     0.653     0.200
     0.089     1.214     0.200
     0.135    -0.609     0.200
     0.188     0.611     0.200
     0.190     1.023     0.200
     0.260     1.336     0.200
     0.338    -0.613     0.200
     0.408     0.238     0.200
     0.427     0.726     0.200
     0.430     0.081     0.200
     0.450    -0.443     0.200
     0.445     0.434     0.200
     0.469     0.318     0.200
     0.519     1.863     0.200
     0.516    -0.706     0.200
     0.598     0.348     0.200
     0.628    -0.121     0.200
     0.640     0.493     0.200
     0.655    -0.595     0.200
     0.682     0.188     0.200
     0.673    -0.281     0.200
     0.713    -0.378     0.200
     0.711     0.140     0.200
     0.714    -0.653     0.200
     0.714    -0.004     0.200
     0.769    -1.489     0.200
     0.761     1.092     0.200
     0.775     0.544     0.200
     0.782     0.596     0.200
     0.795     0.537     0.200
     0.808     1.025     0.200
     0.140     1.020     0.200
     0.302    -1.101     0.200
     0.339    -0.633     0.200
     0.340    -0.796     0.200
     0.346    -0.996     0.200
     0.356    -0.473     0.200
     0.352     0.001     0.200
     0.347    -0.647     0.200
     0.424    -0.552     0.200
     0.431    -0.502     0.200
     0.457    -0.360     0.200
     0.470    -0.811     0.200
     0.459     0.096     0.200
     0.481    -0.643     0.200
     0.481    -0.772     0.200
     0.475     0.237     0.200
     0.504    -0.612     0.200
     0.501    -0.191     0.200
     0.526     0.004     0.200
     0.526    -0.142     0.200
     0.549    -0.397     0.200
     0.581    -0.787     0.200
     0.592    -0.310     0.200
     0.623    -0.804     0.200
     0.687    -1.256     0.200
     0.680    -1.494     0.200
     0.704    -0.765     0.200
     0.693    -0.035     0.200
     0.741    -0.499     0.200
     0.756     0.154     0.200
     0.774    -0.426     0.200
     0.762    -0.730     0.200
     0.766     0.859     0.200
     0.814     0.939     0.200
     0.821     1.064     0.200
     0.803    -0.714     0.200
     0.844    -0.334     0.200
     0.849    -0.647     0.200
     0.880    -0.693     0.200
     0.880    -0.003     0.200
     0.898    -0.504     0.200
     0.958    -0.152     0.200
     0.122     0.771     0.200
     0.206     0.148     0.200
     0.316    -0.845     0.200
     0.307     0.585     0.200
     0.323     1.277     0.200
     0.333     1.264     0.200
     0.355    -0.068     0.200
     0.345    -0.008     0.200
     0.410    -0.494     0.200
     0.480    -0.978     0.200
     0.493    -0.021     0.200
     0.533    -0.969     0.200
     0.606     0.124     0.200
     0.581     0.134     0.200
     0.597     0.278     0.200
     0.619    -0.595     0.200
     0.660     0.752     0.200
     0.667     0.063     0.200
     0.686     0.442     0.200
     0.716    -0.264     0.200
     0.817     1.357     0.200
     0.881    -0.132     0.200
     0.910    -0.061     0.200
     0.031     0.379     0.200
     0.163     1.115     0.200
     0.197    -0.549     0.200
     0.208     0.342     0.200
     0.312    -0.944     0.200
     0.321     0.763     0.200
     0.342     0.366     0.200
     0.421    -0.792     0.200
     0.488    -1.183     0.200
     0.603    -0.457     0.200
     0.608    -0.285     0.200
     0.647    -0.401     0.200
     0.654    -0.388     0.200
     0.674    -0.264     0.200
     0.709    -0.761     0.200
     0.882    -0.405     0.200
     0.897    -0.272     0.200
     0.900    -0.490     0.200
     0.973    -0.176     0.200
     0.971    -0.948     0.200
     0.157     0.872     0.200
     0.212    -0.222     0.200
     0.220     1.262     0.200
     0.238     1.002     0.200
     0.309    -0.679     0.200
     0.418    -0.567     0.200
     0.446     0.397     0.200
     0.494     0.283     0.200
     0.532    -1.350     0.200
     0.604     0.201     0.200
     0.611     0.015     0.200
     0.607     0.383     0.200
     0.652     0.480     0.200
     0.660     0.703     0.200
     0.683     0.061     0.200
     0.716    -0.094     0.200
     0.878    -0.186     0.200
     0.907    -1.101     0.200
     0.907    -0.195     0.200
     0.975    -0.248     0.200
     0.024    -0.888     0.200
     0.195    -0.385     0.200
     0.193     1.378     0.200
     0.208    -0.311     0.200
     0.223     1.055     0.200
     0.311     0.497     0.200
     0.314    -0.888     0.200
     0.318     1.506     0.200
     0.329     1.102     0.200
     0.347     0.030     0.200
     0.350    -0.256     0.200
     0.447     0.382     0.200
     0.484    -0.544     0.200
     0.492     0.453     0.200
     0.584     0.254     0.200
     0.608     0.753     0.200
     0.615    -0.274     0.200
     0.662     0.327     0.200
     0.714    -0.532     0.200
     0.878    -0.157     0.200
     0.113     0.689     0.200
     0.160     0.711     0.200
     0.206     0.054     0.200
     0.219     0.978     0.200
     0.286     1.724     0.200
     0.313     0.976     0.200
     0.323     0.971     0.200
     0.345     0.417     0.200
     0.485    -0.252     0.200
     0.453     0.284     0.200
     0.614     0.971     0.200
     0.611     0.085     0.200
     0.687     0.364     0.200
     0.708    -0.719     0.200
     0.103     0.087     0.200
     0.170     0.715     0.200
     0.207    -0.170     0.200
     0.211     0.771     0.200
     0.303     1.186     0.200
     0.295     1.358     0.200
     0.314     1.251     0.200
     0.321     0.350     0.200
     0.336    -0.433     0.200
     0.425    -0.530     0.200
     0.490    -0.753     0.200
     0.587     0.126     0.200
     0.604     0.309     0.200
     0.604    -0.208     0.200
     0.647     0.387     0.200
     0.642     0.491     0.200
     0.702    -0.171     0.200
     0.697     0.053     0.200
     0.863    -0.041     0.200
     0.892    -0.306     0.200
     0.019    -0.439     0.200
     0.149     0.725     0.200
     0.207    -0.001     0.200
     0.223     0.970     0.200
     0.231     0.836     0.200
     0.228     1.180     0.200
     0.274     1.552     0.200
     0.307     0.917     0.200
     0.315    -1.021     0.200
     0.324     0.891     0.200
     0.347    -0.016     0.200
     0.334     1.138     0.200
     0.355    -0.188     0.200
     0.397     0.309     0.200
     0.410    -0.468     0.200
     0.443     0.144     0.200
     0.481    -0.359     0.200
     0.495     0.229     0.200
     0.531    -0.825     0.200
     0.582    -0.286     0.200
     0.598     0.406     0.200
     0.603     0.416     0.200
     0.619    -0.776     0.200
     0.660     0.748     0.200
     0.676     0.203     0.200
     0.668     0.186     0.200
     0.688     0.718     0.200
     0.718     0.238     0.200
     0.909    -0.381     0.200
     0.037    -0.315     0.200
     0.102     1.206     0.200
     0.170     0.930     0.200
     0.186     1.520     0.200
     0.202    -0.158     0.200
     0.213    -0.171     0.200
     0.239     0.255     0.200
     0.251     0.951     0.200
     0.295     1.572     0.200
     0.313     0.396     0.200
     0.324     0.967     0.200
     0.307    -0.661     0.200
     0.335    -0.727     0.200
     0.352    -0.023     0.200
     0.428    -0.639     0.200
     0.456     0.128     0.200
     0.486     0.477     0.200
     0.495    -0.344     0.200
     0.539    -0.721     0.200
     0.592    -0.404     0.200
     0.609     0.136     0.200
     0.600     0.099     0.200
     0.618     0.507     0.200
     0.647     0.670     0.200
     0.667     0.756     0.200
     0.707     0.020     0.200
     0.697     0.303     0.200
     0.866    -0.085     0.200
     0.167     1.054     0.200
     0.213    -0.106     0.200
     0.225    -0.405     0.200
     0.245     0.831     0.200
     0.242     1.046     0.200
     0.288     1.607     0.200
     0.295    -0.984     0.200
     0.309     1.388     0.200
     0.318     1.067     0.200
     0.329     0.453     0.200
     0.336    -0.220     0.200
     0.365     0.040     0.200
     0.393     0.785     0.200
     0.432    -0.721     0.200
     0.443     0.299     0.200
     0.500     0.268     0.200
     0.503    -0.605     0.200
     0.525    -0.649     0.200
     0.570     0.775     0.200
     0.603    -0.335     0.200
     0.598     0.260     0.200
     0.619     0.062     0.200
     0.606     0.646     0.200
     0.652     0.525     0.200
     0.167     0.689     0.200
     0.224    -0.308     0.200
     0.243     0.821     0.200
     0.244     1.039     0.200
     0.288     1.300     0.200
     0.296    -1.011     0.200
     0.308     1.130     0.200
     0.318     1.489     0.200
     0.336    -0.129     0.200
     0.364    -0.142     0.200
     0.393     0.652     0.200
     0.430     0.940     0.200
     0.431    -0.569     0.200
     0.444     0.452     0.200
     0.502    -0.690     0.200
     0.499     0.314     0.200
     0.525    -0.507     0.200
     0.602    -0.237     0.200
     0.606     0.586     0.200
     0.618    -0.001     0.200
     0.720     0.923     0.200
     0.027    -0.282     0.200
     0.164     0.857     0.200
     0.210    -0.203     0.200
     0.222    -0.466     0.200
     0.240     0.642     0.200
     0.200     1.829     0.200
     0.212     1.042     0.200
     0.285     1.217     0.200
     0.325     0.286     0.200
     0.299    -0.917     0.200
     0.362    -0.248     0.200
     0.340    -0.462     0.200
     0.428    -0.211     0.200
     0.394     0.526     0.200
     0.443     0.333     0.200
     0.499    -0.738     0.200
     0.526    -0.594     0.200
     0.599    -0.453     0.200
     0.605     0.531     0.200
     0.615     0.096     0.200
     0.602    -0.422     0.200
     0.644     0.426     0.200
     0.655     0.269     0.200
     0.677     1.209     0.200
     0.721    -0.006     0.200
     0.021    -0.329     0.200
     0.130     0.506     0.200
     0.185    -0.263     0.200
     0.199    -0.377     0.200
     0.205     1.103     0.200
     0.215     0.483     0.200
     0.249     1.278     0.200
     0.327    -0.857     0.200
     0.338    -0.527     0.200
     0.343     0.622     0.200
     0.353     0.932     0.200
     0.375    -0.145     0.200
     0.435     0.317     0.200
     0.465    -0.960     0.200
     0.501     0.017     0.200
     0.571     0.848     0.200
     0.569    -0.468     0.200
     0.639     0.028     0.200
     0.657     0.733     0.200
     0.680     0.441     0.200
     0.687     0.250     0.200
     0.725     0.027     0.200
     0.897     0.020     0.200
     0.925    -0.324     0.200
     0.203    -0.752     0.200
     0.245    -1.045     0.200
     0.338     1.156     0.200
     0.313    -0.608     0.200
     0.301     1.211     0.200
     0.368     0.724     0.200
     0.364     0.858     0.200
     0.414     1.330     0.200
     0.445    -0.309     0.200
     0.467    -0.507     0.200
     0.507     0.084     0.200
     0.528     0.227     0.200
     0.561     0.824     0.200
     0.520     0.688     0.200
     0.566    -0.660     0.200
     0.618    -0.701     0.200
     0.694     0.824     0.200
     0.660     0.130     0.200
     0.701     0.037     0.200
     0.793     0.330     0.200
     0.067    -0.133     0.200
     0.143     0.640     0.200
     0.224    -0.288     0.200
     0.281     0.898     0.200
     0.273    -1.222     0.200
     0.277    -0.458     0.200
     0.280    -0.358     0.200
     0.339     0.781     0.200
     0.400     1.447     0.200
     0.412    -0.222     0.200
     0.496    -0.845     0.200
     0.523     0.412     0.200
     0.535    -0.572     0.200
     0.529     0.007     0.200
     0.540     0.491     0.200
     0.587    -0.596     0.200
     0.567     0.845     0.200
     0.607     0.307     0.200
     0.679    -0.437     0.200
     0.691     0.205     0.200
     0.099     0.168     0.200
     0.231    -0.866     0.200
     0.236    -0.472     0.200
     0.269    -0.696     0.200
     0.273     0.565     0.200
     0.302    -1.013     0.200
     0.293    -0.883     0.200
     0.313    -0.695     0.200
     0.336    -0.231     0.200
     0.341    -1.213     0.200
     0.352     0.474     0.200
     0.419    -0.465     0.200
     0.429    -0.618     0.200
     0.449    -0.507     0.200
     0.454    -0.972     0.200
     0.457    -1.487     0.200
     0.472    -0.629     0.200
     0.458     0.035     0.200
     0.502    -0.203     0.200
     0.503    -0.965     0.200
     0.539    -1.151     0.200
     0.534    -0.984     0.200
     0.603    -0.735     0.200
     0.626    -0.081     0.200
     0.627    -1.294     0.200
     0.636    -0.601     0.200
     0.652    -0.102     0.200
     0.681    -0.723     0.200
     0.671    -0.732     0.200
     0.696     0.249     0.200
     0.673    -0.598     0.200
     0.690    -0.809     0.200
     0.683    -0.381     0.200
     0.697     0.079     0.200
     0.735    -0.230     0.200
     0.739    -0.119     0.200
     0.738     0.511     0.200
     0.773    -0.815     0.200
     0.775    -0.191     0.200
     0.801    -0.588     0.200
     0.791    -0.140     0.200
     0.809    -0.572     0.200
     0.823    -0.449     0.200
     0.837     0.110     0.200
     0.839     0.550     0.200
     0.895    -0.521     0.200
     0.229    -0.804     0.200
     0.233    -0.858     0.200
     0.440     0.750     0.200
     0.437    -0.321     0.200
     0.453     0.035     0.200
     0.495    -1.664     0.200
     0.498    -1.235     0.200
     0.506    -0.136     0.200
     0.541    -1.245     0.200
     0.499     0.796     0.200
     0.566     1.424     0.200
     0.586     0.327     0.200
     0.639    -0.582     0.200
     0.648    -0.943     0.200
     0.654    -0.593     0.200
     0.659    -0.217     0.200
     0.656    -0.702     0.200
     0.667     1.303     0.200
     0.704    -0.469     0.200
     0.711     0.549     0.200
     0.733    -0.304     0.200
     0.760    -0.336     0.200
     0.839    -0.332     0.200
     0.011    -1.693     0.200
     0.071     0.482     0.200
     0.095     0.499     0.200
     0.151     0.618     0.200
     0.194     0.895     0.200
     0.191     1.958     0.200
     0.203     1.340     0.200
     0.215     0.007     0.200
     0.262    -0.917     0.200
     0.289     0.789     0.200
     0.293    -0.654     0.200
     0.350     1.124     0.200
     0.366     0.670     0.200
     0.425    -0.019     0.200
     0.468    -0.444     0.200
     0.520    -0.338     0.200
     0.574    -0.967     0.200
     0.535    -0.088     0.200
     0.545    -0.471     0.200
     0.568    -0.095     0.200
     0.599    -0.575     0.200
     0.605     0.574     0.200
     0.672    -0.046     0.200
     0.611    -0.394     0.200
     0.626     0.115     0.200
     0.644    -0.132     0.200
     0.680    -0.246     0.200
     0.681     0.751     0.200
     0.705     1.038     0.200
     0.703     0.536     0.200
     0.725     1.337     0.200
     0.760     0.566     0.200
     0.808     0.981     0.200
     0.794     1.886     0.200
     0.813     1.277     0.200
     0.826    -0.564     0.200
     0.893    -0.036     0.200
     0.112     0.505     0.200
     0.099     0.386     0.200
     0.204     0.483     0.200
     0.286     0.901     0.200
     0.289    -0.370     0.200
     0.367     0.649     0.200
     0.421    -0.206     0.200
     0.488    -0.424     0.200
     0.522     0.029     0.200
     0.542    -0.293     0.200
     0.542     1.626     0.200
     0.536     0.467     0.200
     0.564     0.291     0.200
     0.595    -0.656     0.200
     0.576    -0.923     0.200
     0.609     0.944     0.200
     0.646     1.216     0.200
     0.676    -0.403     0.200
     0.643     0.136     0.200
     0.674    -0.837     0.200
     0.699     0.702     0.200
     0.699     0.323     0.200
     0.725     1.406     0.200
     0.759     0.913     0.200
     0.775     0.133     0.200
     0.782     2.351     0.200
     0.788    -0.138     0.200
     0.794     0.956     0.200
     0.811     0.881     0.200
     0.825    -0.100     0.200
     0.895    -0.214     0.200
     0.063    -0.132     0.200
     0.150     0.940     0.200
     0.232    -1.531     0.200
     0.222     0.632     0.200
     0.251     1.039     0.200
     0.260     0.144     0.200
     0.297     1.002     0.200
     0.332     1.015     0.200
     0.332     0.607     0.200
     0.369     0.548     0.200
     0.388     0.585     0.200
     0.391     1.492     0.200
     0.434     0.939     0.200
     0.495    -0.624     0.200
     0.508     0.130     0.200
     0.512     0.622     0.200
     0.523     0.856     0.200
     0.543    -0.961     0.200
     0.537     1.189     0.200
     0.579     0.484     0.200
     0.566     0.279     0.200
     0.566     0.700     0.200
     0.586     0.735     0.200
     0.591    -0.424     0.200
     0.623     0.328     0.200
     0.628     0.687     0.200
     0.647     0.100     0.200
     0.655    -1.694     0.200
     0.660     0.374     0.200
     0.638     1.006     0.200
     0.664     0.951     0.200
     0.647     0.430     0.200
     0.689     0.909     0.200
     0.697    -0.410     0.200
     0.752     0.333     0.200
     0.775     0.072     0.200
     0.759     1.786     0.200
     0.777    -0.086     0.200
     0.791     0.624     0.200
     0.797     0.896     0.200
     0.790    -0.796     0.200
     0.804     0.620     0.200
     0.795     1.876     0.200
     0.786    -0.028     0.200
     0.809     0.799     0.200
     0.823    -0.423     0.200
     0.853     0.018     0.200
     0.974    -0.246     0.200
     0.029    -2.538     0.200
     0.051    -1.571     0.200
     0.098    -0.609     0.200
     0.135     0.120     0.200
     0.220     1.090     0.200
     0.255     1.056     0.200
     0.310     0.450     0.200
     0.286    -0.986     0.200
     0.330     0.935     0.200
     0.322     0.595     0.200
     0.325     0.586     0.200
     0.388     0.060     0.200
     0.483     1.346     0.200
     0.531    -0.299     0.200
     0.525     1.266     0.200
     0.540     1.767     0.200
     0.559    -0.195     0.200
     0.599     0.731     0.200
     0.576     0.072     0.200
     0.587     0.596     0.200
     0.642    -0.410     0.200
     0.631     1.452     0.200
     0.664     0.449     0.200
     0.680     0.677     0.200
     0.679     0.909     0.200
     0.681     0.066     0.200
     0.026    -0.549     0.200
     0.053    -0.088     0.200
     0.100     0.302     0.200
     0.122     0.832     0.200
     0.167     1.368     0.200
     0.226     1.345     0.200
     0.258    -0.356     0.200
     0.285    -0.966     0.200
     0.324     1.066     0.200
     0.324     0.432     0.200
     0.333     0.848     0.200
     0.402     1.525     0.200
     0.452     0.555     0.200
     0.480     0.241     0.200
     0.510    -0.776     0.200
     0.521     0.497     0.200
     0.525     0.325     0.200
     0.534     0.303     0.200
     0.521    -0.677     0.200
     0.544     1.242     0.200
     0.562    -0.760     0.200
     0.553     0.359     0.200
     0.560    -0.279     0.200
     0.584     0.584     0.200
     0.577    -0.588     0.200
     0.600     0.109     0.200
     0.607     0.196     0.200
     0.645    -0.104     0.200
     0.634     0.803     0.200
     0.653     0.096     0.200
     0.670    -0.161     0.200
     0.681     0.344     0.200
     0.683     0.884     0.200
     0.667    -0.002     0.200
     0.681     0.651     0.200
     0.681    -0.464     0.200
     0.762     0.394     0.200
     0.782     0.328     0.200
     0.774    -0.426     0.200
     0.797     0.128     0.200
     0.797    -0.419     0.200
     0.797     1.743     0.200
     0.806     0.804     0.200
     0.810     0.873     0.200
     0.831    -0.159     0.200
     0.874    -0.266     0.200
     0.996    -0.484     0.200
     0.030    -0.812     0.200
     0.054    -0.241     0.200
     0.101     0.454     0.200
     0.121     0.642     0.200
     0.135     0.797     0.200
     0.217     1.017     0.200
     0.254    -0.504     0.200
     0.227     1.207     0.200
     0.257     0.856     0.200
     0.250    -0.009     0.200
     0.311     0.673     0.200
     0.289    -1.218     0.200
     0.325     0.209     0.200
     0.333     0.532     0.200
     0.379     1.442     0.200
     0.387    -0.272     0.200
     0.386     0.201     0.200
     0.507    -0.442     0.200
     0.480     0.662     0.200
     0.516     0.480     0.200
     0.530     0.005     0.200
     0.522     0.558     0.200
     0.542     1.459     0.200
     0.559    -0.562     0.200
     0.524    -0.374     0.200
     0.555     0.577     0.200
     0.561     0.404     0.200
     0.579    -0.642     0.200
     0.596     0.381     0.200
     0.584     0.564     0.200
     0.605     0.182     0.200
     0.641    -0.272     0.200
     0.639     0.879     0.200
     0.652     0.106     0.200
     0.664     0.143     0.200
     0.677     0.612     0.200
     0.683     0.763     0.200
     0.684    -0.349     0.200
     0.740     0.460     0.200
     0.760     0.893     0.200
     0.781    -0.463     0.200
     0.793     0.024     0.200
     0.776    -0.188     0.200
     0.796     1.975     0.200
     0.036    -1.791     0.200
     0.291     0.551     0.200
     0.299    -1.487     0.200
     0.343     0.691     0.200
     0.363     0.303     0.200
     0.430     0.934     0.200
     0.439     0.953     0.200
     0.501     0.286     0.200
     0.495    -0.371     0.200
     0.541    -0.491     0.200
     0.542     0.347     0.200
     0.519     0.609     0.200
     0.518    -0.507     0.200
     0.553     0.952     0.200
     0.542     0.716     0.200
     0.585    -0.408     0.200
     0.584     1.418     0.200
     0.574    -0.041     0.200
     0.592     0.375     0.200
     0.611     0.530     0.200
     0.610    -0.496     0.200
     0.613    -0.041     0.200
     0.643     0.216     0.200
     0.659    -0.005     0.200
     0.666     0.442     0.200
     0.669     0.897     0.200
     0.674     1.577     0.200
     0.684     0.512     0.200
     0.709    -0.027     0.200
     0.721     0.562     0.200
     0.725     0.629     0.200
     0.738     1.174     0.200
     0.755     2.024     0.200
     0.776     0.930     0.200
     0.769     1.336     0.200
     0.793     0.585     0.200
     0.791     0.344     0.200
     0.793     0.469     0.200
     0.793     0.364     0.200
     0.809     0.087     0.200
     0.039    -0.825     0.200
     0.054    -0.303     0.200
     0.102     0.057     0.200
     0.115     0.615     0.200
     0.144     0.686     0.200
     0.223     1.008     0.200
     0.240    -1.415     0.200
     0.245    -0.485     0.200
     0.250     1.060     0.200
     0.296    -1.238     0.200
     0.302     0.752     0.200
     0.321     0.677     0.200
     0.324     0.377     0.200
     0.328     0.846     0.200
     0.378    -0.203     0.200
     0.374     1.339     0.200
     0.393     1.413     0.200
     0.444     0.162     0.200
     0.485     0.822     0.200
     0.499    -0.913     0.200
     0.519     0.557     0.200
     0.533    -0.450     0.200
     0.516     0.611     0.200
     0.522    -0.081     0.200
     0.536     1.465     0.200
     0.563     0.916     0.200
     0.567     0.140     0.200
     0.550    -0.738     0.200
     0.589     0.577     0.200
     0.581    -0.499     0.200
     0.590    -0.005     0.200
     0.637     0.802     0.200
     0.632    -0.290     0.200
     0.632     0.697     0.200
     0.653    -0.017     0.200
     0.671     0.432     0.200
     0.655     0.378     0.200
     0.682     0.840     0.200
     0.687    -0.617     0.200
     0.748     0.735     0.200
     0.760     0.480     0.200
     0.775    -0.970     0.200
     0.797    -0.493     0.200
     0.830    -0.263     0.200
     0.140     0.731     0.200
     0.198     1.453     0.200
     0.257    -0.686     0.200
     0.303     0.860     0.200
     0.275     0.850     0.200
     0.345     0.276     0.200
     0.387    -0.344     0.200
     0.399     1.395     0.200
     0.417     1.514     0.200
     0.507     0.486     0.200
     0.521     0.727     0.200
     0.520    -0.335     0.200
     0.514    -0.696     0.200
     0.542     0.242     0.200
     0.540     0.201     0.200
     0.566    -0.943     0.200
     0.622     0.807     0.200
     0.597    -0.273     0.200
     0.651    -0.861     0.200
     0.644    -0.122     0.200
     0.668     0.080     0.200
     0.655     1.149     0.200
     0.669     0.614     0.200
     0.740     1.013     0.200
     0.700    -1.368     0.200
     0.775    -0.414     0.200
     0.776     2.107     0.200
     0.744     0.718     0.200
     0.789     1.465     0.200
     0.810    -1.068     0.200
     0.810    -0.029     0.200
     0.795     0.071     0.200
     0.987    -0.361     0.200
     0.050    -0.469     0.200
     0.111     0.871     0.200
     0.099     0.942     0.200
     0.163     1.517     0.200
     0.157     1.218     0.200
     0.183     1.264     0.200
     0.155     1.487     0.200
     0.165     1.507     0.200
     0.287    -0.185     0.200
     0.318     0.565     0.200
     0.302    -0.857     0.200
     0.324     0.838     0.200
     0.362     0.953     0.200
     0.395     1.123     0.200
     0.412     0.323     0.200
     0.427    -0.709     0.200
     0.496     0.419     0.200
     0.499     0.516     0.200
     0.523     0.141     0.200
     0.554     0.627     0.200
     0.561    -0.755     0.200
     0.569     1.077     0.200
     0.595    -0.437     0.200
     0.601    -0.385     0.200
     0.596    -0.013     0.200
     0.622    -0.304     0.200
     0.635     0.452     0.200
     0.672    -0.285     0.200
     0.671     1.131     0.200
     0.692     1.689     0.200
     0.699     0.414     0.200
     0.712     1.218     0.200
     0.718     0.216     0.200
     0.741    -0.013     0.200
     0.750     0.027     0.200
     0.778     0.528     0.200
     0.806     0.103     0.200
     0.824     0.228     0.200
     0.865    -0.048     0.200
     0.051    -1.547     0.200
     0.098     0.469     0.200
     0.113     0.728     0.200
     0.154     1.310     0.200
     0.185     1.422     0.200
     0.192    -0.209     0.200
     0.280     1.007     0.200
     0.301    -1.081     0.200
     0.320     0.784     0.200
     0.363     0.966     0.200
     0.396     0.823     0.200
     0.413     0.172     0.200
     0.427     0.405     0.200
     0.443     1.532     0.200
     0.461     1.974     0.200
     0.477    -0.559     0.200
     0.496    -0.087     0.200
     0.497    -0.087     0.200
     0.521     0.081     0.200
     0.555    -0.026     0.200
     0.562    -0.911     0.200
     0.560     0.132     0.200
     0.570     0.508     0.200
     0.596    -0.126     0.200
     0.595     0.627     0.200
     0.602     0.249     0.200
     0.602    -0.388     0.200
     0.606     1.463     0.200
     0.623    -0.773     0.200
     0.635    -0.002     0.200
     0.664     0.368     0.200
     0.672     0.957     0.200
     0.673     0.226     0.200
     0.693     1.576     0.200
     0.711     0.840     0.200
     0.700     0.414     0.200
     0.719    -0.496     0.200
     0.736     2.323     0.200
     0.740     0.415     0.200
     0.732     1.731     0.200
     0.738     0.801     0.200
     0.766     0.492     0.200
     0.775     0.753     0.200
     0.777     0.578     0.200
     0.795     0.789     0.200
     0.805     0.044     0.200
     0.810    -0.015     0.200
     0.823    -0.577     0.200
     0.865    -0.174     0.200
     0.055    -0.773     0.200
     0.115     0.763     0.200
     0.106     0.391     0.200
     0.161     0.587     0.200
     0.155     1.694     0.200
     0.184     1.195     0.200
     0.165     1.391     0.200
     0.282     0.544     0.200
     0.273     1.308     0.200
     0.309    -0.979     0.200
     0.322     0.418     0.200
     0.359     1.064     0.200
     0.384     0.502     0.200
     0.405     0.401     0.200
     0.443     1.710     0.200
     0.458     2.094     0.200
     0.483    -0.175     0.200
     0.501     0.292     0.200
     0.520     0.652     0.200
     0.547     0.137     0.200
     0.558    -0.743     0.200
     0.574     0.759     0.200
     0.596    -0.547     0.200
     0.592     0.622     0.200
     0.595     0.579     0.200
     0.628    -0.613     0.200
     0.628     0.119     0.200
     0.666    -0.022     0.200
     0.696     0.979     0.200
     0.693     0.227     0.200
     0.706    -0.164     0.200
     0.742     0.879     0.200
     0.773     0.636     0.200
     0.787     0.545     0.200
     0.800    -0.150     0.200
     0.816     0.602     0.200
     0.857    -0.038     0.200
     0.114     0.675     0.200
     0.183     1.258     0.200
     0.273     0.841     0.200
     0.281    -0.359     0.200
     0.281    -0.522     0.200
     0.317     1.152     0.200
     0.310    -1.090     0.200
     0.323     0.472     0.200
     0.357     0.910     0.200
     0.404    -0.024     0.200
     0.396     0.872     0.200
     0.417     0.815     0.200
     0.484    -0.502     0.200
     0.499     0.641     0.200
     0.521     0.409     0.200
     0.546    -0.174     0.200
     0.557    -0.654     0.200
     0.586    -0.629     0.200
     0.574     0.700     0.200
     0.595    -0.628     0.200
     0.595     0.129     0.200
     0.592    -0.525     0.200
     0.604     0.704     0.200
     0.627    -0.627     0.200
     0.628    -0.460     0.200
     0.655     0.111     0.200
     0.662     0.749     0.200
     0.665    -0.422     0.200
     0.696     1.507     0.200
     0.706     0.068     0.200
     0.692     0.356     0.200
     0.737     0.020     0.200
     0.742     0.893     0.200
     0.747     0.333     0.200
     0.759     1.043     0.200
     0.771     0.019     0.200
     0.773    -1.097     0.200
     0.773    -0.140     0.200
     0.800     0.385     0.200
     0.800    -0.288     0.200
     0.815     0.224     0.200
     0.866    -0.243     0.200
     0.190    -0.289     0.200
     0.203     0.334     0.200
     0.299     0.711     0.200
     0.306     0.361     0.200
     0.321     1.454     0.200
     0.322     1.458     0.200
     0.346     0.086     0.200
     0.362     1.183     0.200
     0.378     1.059     0.200
     0.379     1.535     0.200
     0.392     0.007     0.200
     0.414    -0.025     0.200
     0.408     0.443     0.200
     0.422    -0.220     0.200
     0.427    -0.980     0.200
     0.430    -1.097     0.200
     0.447     1.127     0.200
     0.444    -0.774     0.200
     0.471    -0.718     0.200
     0.484     0.070     0.200
     0.551     1.033     0.200
     0.541    -0.726     0.200
     0.577     0.647     0.200
     0.580     1.338     0.200
     0.591    -0.253     0.200
     0.589    -0.400     0.200
     0.603    -0.251     0.200
     0.622     1.663     0.200
     0.649     2.282     0.200
     0.667    -1.073     0.200
     0.675    -0.457     0.200
     0.677    -0.930     0.200
     0.677    -0.797     0.200
     0.680    -0.377     0.200
     0.680    -0.559     0.200
     0.715    -0.605     0.200
     0.718    -0.759     0.200
     0.721    -0.190     0.200
     0.727     1.144     0.200
     0.743    -0.455     0.200
     0.743     0.011     0.200
     0.765    -0.620     0.200
     0.776    -0.322     0.200
     0.804     0.312     0.200
     0.812     0.001     0.200
     0.828    -0.294     0.200
     0.884    -0.272     0.200
     0.893    -0.125     0.200
     0.893    -0.428     0.200
     0.916     0.009     0.200
     0.050    -0.594     0.200
     0.063    -0.044     0.200
     0.110     0.595     0.200
     0.116     0.475     0.200
     0.154     0.576     0.200
     0.225     1.475     0.200
     0.232    -0.375     0.200
     0.235     0.994     0.200
     0.248     0.938     0.200
     0.264     0.108     0.200
     0.309    -1.181     0.200
     0.330     0.762     0.200
     0.331     0.276     0.200
     0.365    -0.125     0.200
     0.374     1.440     0.200
     0.390    -0.157     0.200
     0.491    -0.451     0.200
     0.483     0.801     0.200
     0.496     0.480     0.200
     0.509     0.012     0.200
     0.516     1.624     0.200
     0.507     0.594     0.200
     0.534     1.331     0.200
     0.539    -0.351     0.200
     0.542    -0.073     0.200
     0.569     0.782     0.200
     0.569     0.232     0.200
     0.576    -0.305     0.200
     0.591    -0.421     0.200
     0.588     0.693     0.200
     0.594     0.332     0.200
     0.620    -0.237     0.200
     0.623     0.964     0.200
     0.637     1.104     0.200
     0.628     0.771     0.200
     0.648     0.120     0.200
     0.654     0.218     0.200
     0.658     0.747     0.200
     0.643     0.144     0.200
     0.662     0.705     0.200
     0.688     0.827     0.200
     0.698    -0.599     0.200
     0.753     0.441     0.200
     0.762     0.891     0.200
     0.771     0.068     0.200
     0.786    -0.049     0.200
     0.792     0.165     0.200
     0.163    -0.589     0.200
     0.102    -0.972     0.200
     0.170    -0.556     0.200
     0.167    -1.054     0.200
     0.128    -0.825     0.200
     0.128    -0.822     0.200
     0.155     0.031     0.200
     0.174    -0.081     0.200
     0.206    -0.937     0.200
     0.203    -0.644     0.200
     0.256    -0.408     0.200
     0.265    -0.577     0.200
     0.330    -0.591     0.200
     0.330    -0.530     0.200
     0.332    -0.315     0.200
     0.297    -0.148     0.200
     0.283     0.979     0.200
     0.319    -0.709     0.200
     0.371    -0.173     0.200
     0.405    -0.138     0.200
     0.332     0.466     0.200
     0.402    -0.121     0.200
     0.345    -0.507     0.200
     0.351     1.246     0.200
     0.365    -0.382     0.200
     0.421    -0.634     0.200
     0.340     0.474     0.200
     0.388     0.300     0.200
     0.364     0.242     0.200
     0.436     0.353     0.200
     0.425     0.987     0.200
     0.418     0.344     0.200
     0.490    -0.625     0.200
     0.455    -0.151     0.200
     0.498    -0.539     0.200
     0.535    -0.647     0.200
     0.457     0.404     0.200
     0.541     0.223     0.200
     0.464     0.615     0.200
     0.515     0.394     0.200
     0.539    -0.540     0.200
     0.512    -0.186     0.200
     0.514     0.512     0.200
     0.496     0.261     0.200
     0.513     0.365     0.200
     0.596    -0.685     0.200
     0.542     2.195     0.200
     0.579     0.861     0.200
     0.606    -0.169     0.200
     0.637    -0.716     0.200
     0.611     1.631     0.200
     0.612     1.581     0.200
     0.578     0.919     0.200
     0.638     1.770     0.200
     0.663    -0.151     0.200
     0.636     0.675     0.200
     0.679    -0.460     0.200
     0.670    -0.303     0.200
     0.623     0.618     0.200
     0.644     0.120     0.200
     0.627     0.661     0.200
     0.637    -0.274     0.200
     0.681     0.262     0.200
     0.726    -0.223     0.200
     0.733    -0.039     0.200
     0.747    -0.212     0.200
     0.761    -0.250     0.200
     0.748    -0.135     0.200
     0.763    -0.306     0.200
     0.780    -0.340     0.200
     0.736     0.656     0.200
     0.726     1.205     0.200
     0.732     0.494     0.200
     0.820    -0.240     0.200
     0.813    -0.180     0.200
     0.823    -0.456     0.200
     0.823    -0.186     0.200
     0.854    -0.210     0.200
     0.854    -0.570     0.200
     0.963    -0.233     0.200
     0.140    -0.307     0.200
     0.133    -0.172     0.200
     0.171    -0.205     0.200
     0.197    -0.723     0.200
     0.192     0.227     0.200
     0.221    -0.007     0.200
     0.258    -0.899     0.200
     0.245     0.647     0.200
     0.269    -0.874     0.200
     0.263    -0.092     0.200
     0.277    -0.085     0.200
     0.300    -0.524     0.200
     0.296    -0.961     0.200
     0.331    -0.585     0.200
     0.317    -0.109     0.200
     0.344    -0.832     0.200
     0.346    -0.269     0.200
     0.375    -0.880     0.200
     0.372    -0.601     0.200
     0.385    -0.562     0.200
     0.389    -0.974     0.200
     0.389    -0.546     0.200
     0.386    -0.132     0.200
     0.405    -0.873     0.200
     0.406    -0.751     0.200
     0.400    -0.222     0.200
     0.410    -0.661     0.200
     0.396     0.316     0.200
     0.396    -0.199     0.200
     0.427    -0.766     0.200
     0.438    -0.494     0.200
     0.434    -0.400     0.200
     0.451    -0.637     0.200
     0.440    -0.404     0.200
     0.463    -0.034     0.200
     0.454    -0.942     0.200
     0.469    -0.699     0.200
     0.477    -0.737     0.200
     0.465    -0.067     0.200
     0.482    -0.060     0.200
     0.475     0.240     0.200
     0.499    -0.659     0.200
     0.511    -0.376     0.200
     0.503    -0.230     0.200
     0.523    -0.119     0.200
     0.527     0.525     0.200
     0.571    -0.564     0.200
     0.577    -0.394     0.200
     0.555     1.715     0.200
     0.562     0.005     0.200
     0.571    -0.504     0.200
     0.581     0.365     0.200
     0.575     1.504     0.200
     0.576     0.429     0.200
     0.586     0.372     0.200
     0.605    -0.287     0.200
     0.613    -0.413     0.200
     0.625    -0.279     0.200
     0.620     0.247     0.200
     0.645     1.199     0.200
     0.640    -0.027     0.200
     0.657     0.483     0.200
     0.652    -0.215     0.200
     0.657     0.369     0.200
     0.646     0.175     0.200
     0.643     2.014     0.200
     0.650     0.875     0.200
     0.665     0.825     0.200
     0.684     0.519     0.200
     0.692    -0.243     0.200
     0.709     1.030     0.200
     0.705     0.543     0.200
     0.710     1.059     0.200
     0.705     1.591     0.200
     0.706     1.037     0.200
     0.716    -0.229     0.200
     0.731     0.508     0.200
     0.733     0.386     0.200
     0.738     0.732     0.200
     0.732    -0.093     0.200
     0.732     0.298     0.200
     0.743    -0.226     0.200
     0.750     0.589     0.200
     0.742     1.393     0.200
     0.768     2.161     0.200
     0.753    -0.030     0.200
     0.755     0.436     0.200
     0.787    -0.441     0.200
     0.815    -0.241     0.200
     0.094     0.577     0.200
     0.126     1.710     0.200
     0.126     0.538     0.200
     0.133     0.698     0.200
     0.174     0.913     0.200
     0.175     2.253     0.200
     0.235    -1.095     0.200
     0.235    -0.970     0.200
     0.261     0.257     0.200
     0.266     1.033     0.200
     0.273    -1.027     0.200
     0.297     1.082     0.200
     0.316     0.270     0.200
     0.322    -0.783     0.200
     0.341     0.884     0.200
     0.359     1.247     0.200
     0.378    -0.264     0.200
     0.388    -0.894     0.200
     0.435    -0.759     0.200
     0.435    -0.658     0.200
     0.435    -1.212     0.200
     0.461    -0.581     0.200
     0.457     0.469     0.200
     0.474     1.203     0.200
     0.479     0.394     0.200
     0.487     0.320     0.200
     0.528     1.219     0.200
     0.536    -0.057     0.200
     0.534    -0.437     0.200
     0.567    -0.492     0.200
     0.565    -0.927     0.200
     0.567    -0.992     0.200
     0.567     1.313     0.200
     0.582     0.221     0.200
     0.598    -0.381     0.200
     0.590     1.295     0.200
     0.625    -0.343     0.200
     0.658     0.605     0.200
     0.678     1.899     0.200
     0.671    -0.471     0.200
     0.671     1.397     0.200
     0.722     0.438     0.200
     0.722     2.227     0.200
     0.723     1.943     0.200
     0.733     0.283     0.200
     0.749     0.566     0.200
     0.790     0.825     0.200
     0.785     1.052     0.200
     0.811     0.057     0.200
     0.827    -0.432     0.200
     0.086    -0.811     0.200
     0.139    -0.975     0.200
     0.142     0.099     0.200
     0.188     0.125     0.200
     0.187     0.045     0.200
     0.209    -0.659     0.200
     0.209    -0.589     0.200
     0.209    -0.398     0.200
     0.225    -0.942     0.200
     0.248    -0.571     0.200
     0.248    -0.250     0.200
     0.226     0.578     0.200
     0.260    -0.926     0.200
     0.241    -0.862     0.200
     0.249    -0.467     0.200
     0.290    -0.430     0.200
     0.290    -0.160     0.200
     0.285    -0.260     0.200
     0.320    -0.329     0.200
     0.330    -0.383     0.200
     0.320     0.235     0.200
     0.342     0.105     0.200
     0.363    -0.325     0.200
     0.347    -0.028     0.200
     0.344    -0.368     0.200
     0.353     0.207     0.200
     0.366     0.973     0.200
     0.385     0.270     0.200
     0.411     0.267     0.200
     0.427    -0.640     0.200
     0.398    -0.569     0.200
     0.399    -0.592     0.200
     0.411     0.174     0.200
     0.418    -0.125     0.200
     0.430     0.000     0.200
     0.426    -0.624     0.200
     0.432    -0.579     0.200
     0.451    -0.847     0.200
     0.433    -0.615     0.200
     0.457    -0.234     0.200
     0.471    -1.192     0.200
     0.520    -0.656     0.200
     0.516    -0.437     0.200
     0.525     0.510     0.200
     0.532    -0.208     0.200
     0.543    -0.647     0.200
     0.567     0.765     0.200
     0.537    -0.351     0.200
     0.566     0.398     0.200
     0.547     0.225     0.200
     0.557     0.263     0.200
     0.560    -0.327     0.200
     0.569    -0.020     0.200
     0.582    -0.093     0.200
     0.607    -0.781     0.200
     0.596     0.385     0.200
     0.635    -0.012     0.200
     0.634    -0.823     0.200
     0.634    -0.101     0.200
     0.641    -0.726     0.200
     0.617     1.880     0.200
     0.622     0.663     0.200
     0.664    -0.269     0.200
     0.666    -0.295     0.200
     0.643    -0.268     0.200
     0.652    -0.297     0.200
     0.657    -0.313     0.200
     0.664    -0.352     0.200
     0.685    -0.177     0.200
     0.685    -0.178     0.200
     0.660     0.050     0.200
     0.661     0.708     0.200
     0.699     0.678     0.200
     0.682    -0.168     0.200
     0.703     0.951     0.200
     0.699    -0.401     0.200
     0.688    -0.246     0.200
     0.707    -0.185     0.200
     0.717    -0.391     0.200
     0.733     0.411     0.200
     0.703     1.108     0.200
     0.708     0.111     0.200
     0.711     0.765     0.200
     0.747     2.021     0.200
     0.740    -0.432     0.200
     0.736    -0.121     0.200
     0.747    -0.157     0.200
     0.759    -0.719     0.200
     0.759    -0.528     0.200
     0.761    -0.638     0.200
     0.765    -0.290     0.200
     0.753     0.163     0.200
     0.782     1.697     0.200
     0.794     1.482     0.200
     0.795    -0.253     0.200
     0.773     0.220     0.200
     0.790    -0.299     0.200
     0.780     0.639     0.200
     0.788     0.255     0.200
     0.787     0.301     0.200
     0.788     0.641     0.200
     0.808    -0.370     0.200
     0.808    -0.421     0.200
     0.807     0.575     0.200
     0.832    -0.241     0.200
     0.853    -0.679     0.200
     0.853    -0.410     0.200
     0.857    -0.456     0.200
     0.874    -0.171     0.200
     0.875     0.151     0.200
     0.911    -0.151     0.200
     0.173    -0.179     0.200
     0.158    -0.705     0.200
     0.205    -0.334     0.200
     0.215     0.605     0.200
     0.243    -0.531     0.200
     0.232    -0.736     0.200
     0.241    -0.829     0.200
     0.246    -0.707     0.200
     0.269    -0.702     0.200
     0.316    -0.275     0.200
     0.298    -0.935     0.200
     0.296    -0.727     0.200
     0.329     0.059     0.200
     0.299    -0.518     0.200
     0.340     0.055     0.200
     0.342     0.008     0.200
     0.341    -0.932     0.200
     0.324    -0.776     0.200
     0.346    -0.654     0.200
     0.374    -0.112     0.200
     0.385    -0.039     0.200
     0.391    -0.509     0.200
     0.366    -1.167     0.200
     0.371    -0.980     0.200
     0.397    -0.381     0.200
     0.427    -0.384     0.200
     0.394    -0.507     0.200
     0.429     0.291     0.200
     0.432     0.210     0.200
     0.418     1.355     0.200
     0.447    -0.175     0.200
     0.442    -0.132     0.200
     0.439    -0.836     0.200
     0.434    -0.733     0.200
     0.444    -0.989     0.200
     0.444    -0.908     0.200
     0.468    -0.292     0.200
     0.502    -0.554     0.200
     0.495    -0.041     0.200
     0.509    -0.024     0.200
     0.511    -0.230     0.200
     0.517    -0.660     0.200
     0.512    -0.629     0.200
     0.528     0.003     0.200
     0.526    -0.426     0.200
     0.542    -0.496     0.200
     0.551    -0.203     0.200
     0.521    -0.795     0.200
     0.552     1.763     0.200
     0.542     1.307     0.200
     0.532     0.489     0.200
     0.565     0.345     0.200
     0.531    -0.546     0.200
     0.534     0.149     0.200
     0.558     0.930     0.200
     0.540    -0.310     0.200
     0.583     0.893     0.200
     0.598    -0.174     0.200
     0.592     0.386     0.200
     0.594     0.020     0.200
     0.611     0.115     0.200
     0.633     1.912     0.200
     0.641     0.761     0.200
     0.628     0.477     0.200
     0.667     0.112     0.200
     0.650     0.859     0.200
     0.652     1.179     0.200
     0.662     0.318     0.200
     0.694     1.041     0.200
     0.676     0.564     0.200
     0.673    -0.047     0.200
     0.673    -0.005     0.200
     0.685     1.683     0.200
     0.673     0.097     0.200
     0.699    -0.525     0.200
     0.707     1.192     0.200
     0.711     0.000     0.200
     0.682     1.006     0.200
     0.702     0.851     0.200
     0.688     0.682     0.200
     0.685     0.746     0.200
     0.695     0.201     0.200
     0.731     0.566     0.200
     0.711    -0.083     0.200
     0.727     1.427     0.200
     0.721     0.371     0.200
     0.710     0.740     0.200
     0.739    -0.387     0.200
     0.750     0.527     0.200
     0.759     1.255     0.200
     0.751     2.081     0.200
     0.773     1.140     0.200
     0.770     0.774     0.200
     0.791    -0.187     0.200
     0.779     0.146     0.200
     0.831    -0.391     0.200
     0.861    -0.122     0.200
     0.885    -0.085     0.200
     0.029    -1.137     0.200
     0.028    -0.940     0.200
     0.083     0.727     0.200
     0.078     0.429     0.200
     0.119     0.939     0.200
     0.164     1.394     0.200
     0.166     1.353     0.200
     0.187     1.684     0.200
     0.206     1.648     0.200
     0.195     1.342     0.200
     0.202    -0.090     0.200
     0.302     1.285     0.200
     0.307    -0.708     0.200
     0.311    -0.131     0.200
     0.360     0.761     0.200
     0.416     1.327     0.200
     0.467    -0.303     0.200
     0.524     0.342     0.200
     0.549     0.887     0.200
     0.562    -0.553     0.200
     0.558     1.053     0.200
     0.575     0.563     0.200
     0.570    -0.925     0.200
     0.586    -0.129     0.200
     0.641     0.378     0.200
     0.643     0.172     0.200
     0.651     0.707     0.200
     0.656     0.932     0.200
     0.665    -0.804     0.200
     0.698    -0.338     0.200
     0.692     0.930     0.200
     0.715     0.981     0.200
     0.722     0.053     0.200
     0.762     0.738     0.200
     0.772     0.445     0.200
     0.777     2.115     0.200
     0.788    -0.164     0.200
     0.820     1.194     0.200
     0.825    -0.068     0.200
     0.033    -1.087     0.200
     0.088     0.690     0.200
     0.073     0.586     0.200
     0.124     0.954     0.200
     0.172     1.365     0.200
     0.170     1.292     0.200
     0.191     1.995     0.200
     0.208     1.554     0.200
     0.196     0.156     0.200
     0.307     1.236     0.200
     0.312    -1.651     0.200
     0.315    -0.338     0.200
     0.341     0.589     0.200
     0.373     0.889     0.200
     0.442     1.352     0.200
     0.446     0.474     0.200
     0.462     0.061     0.200
     0.496     0.185     0.200
     0.500    -0.030     0.200
     0.521     0.156     0.200
     0.527     0.294     0.200
     0.549     0.583     0.200
     0.567    -0.881     0.200
     0.579     0.547     0.200
     0.573    -0.728     0.200
     0.589     0.251     0.200
     0.589     1.054     0.200
     0.596     1.112     0.200
     0.643     0.637     0.200
     0.640     0.344     0.200
     0.654     0.878     0.200
     0.656     0.452     0.200
     0.667     0.048     0.200
     0.702    -0.272     0.200
     0.696     1.097     0.200
     0.716     0.952     0.200
     0.721     0.911     0.200
     0.726     0.271     0.200
     0.760     0.756     0.200
     0.775    -0.327     0.200
     0.785    -0.052     0.200
     0.784     1.429     0.200
     0.819     1.218     0.200
     0.914    -0.029     0.200
     0.025    -0.858     0.200
     0.064     0.290     0.200
     0.100    -0.291     0.200
     0.094     0.176     0.200
     0.147     1.316     0.200
     0.147     1.275     0.200
     0.209     1.900     0.200
     0.207     1.330     0.200
     0.215     1.506     0.200
     0.220    -0.333     0.200
     0.299    -0.257     0.200
     0.299     0.062     0.200
     0.318     0.855     0.200
     0.347     0.944     0.200
     0.476     1.011     0.200
     0.505     0.619     0.200
     0.482    -0.614     0.200
     0.547    -0.233     0.200
     0.523    -0.157     0.200
     0.555    -0.813     0.200
     0.559    -0.623     0.200
     0.559     1.607     0.200
     0.545     0.501     0.200
     0.606    -0.244     0.200
     0.632     1.380     0.200
     0.646    -0.176     0.200
     0.644     0.501     0.200
     0.652     0.117     0.200
     0.652    -0.503     0.200
     0.668     1.001     0.200
     0.674     0.385     0.200
     0.661     0.565     0.200
     0.691    -0.088     0.200
     0.713     0.249     0.200
     0.701     0.548     0.200
     0.712     0.880     0.200
     0.723     0.988     0.200
     0.755    -0.342     0.200
     0.779     0.986     0.200
     0.796     2.189     0.200
     0.806    -0.048     0.200
     0.052    -0.205     0.200
     0.051     0.286     0.200
     0.094     0.603     0.200
     0.104     0.659     0.200
     0.104     0.659     0.200
     0.098     0.733     0.200
     0.157     1.067     0.200
     0.228    -1.075     0.200
     0.228    -1.345     0.200
     0.233    -0.365     0.200
     0.237     1.041     0.200
     0.237     1.041     0.200
     0.246     0.855     0.200
     0.288     0.891     0.200
     0.272     0.048     0.200
     0.326     0.778     0.200
     0.317     0.871     0.200
     0.318    -0.063     0.200
     0.367    -0.216     0.200
     0.364     1.232     0.200
     0.362     1.743     0.200
     0.362     1.422     0.200
     0.484    -0.662     0.200
     0.497     0.580     0.200
     0.511    -0.088     0.200
     0.496     0.799     0.200
     0.518     0.280     0.200
     0.514     0.726     0.200
     0.510     0.853     0.200
     0.536    -0.498     0.200
     0.523     1.439     0.200
     0.523     0.718     0.200
     0.547    -0.004     0.200
     0.584    -0.913     0.200
     0.579     0.524     0.200
     0.577     1.071     0.200
     0.593    -0.543     0.200
     0.593     0.588     0.200
     0.607     0.570     0.200
     0.579    -0.520     0.200
     0.600     0.665     0.200
     0.620    -0.359     0.200
     0.642     0.273     0.200
     0.642     1.193     0.200
     0.635     1.362     0.200
     0.624     0.733     0.200
     0.666     1.092     0.200
     0.666     0.300     0.200
     0.672     0.774     0.200
     0.675     0.693     0.200
     0.696     1.054     0.200
     0.687    -0.121     0.200
     0.766     0.358     0.200
     0.775     0.129     0.200
     0.764     0.143     0.200
     0.758     0.842     0.200
     0.774    -0.395     0.200
     0.858     0.014     0.200
     0.977    -0.114     0.200
     0.988    -0.182     0.200
     0.005    -0.704     0.200
     0.065    -0.632     0.200
     0.135    -0.856     0.200
     0.179    -0.294     0.200
     0.198    -0.855     0.200
     0.218    -1.001     0.200
     0.241    -0.769     0.200
     0.267    -1.028     0.200
     0.279    -0.580     0.200
     0.275    -1.095     0.200
     0.286    -1.009     0.200
     0.282     0.130     0.200
     0.309    -0.470     0.200
     0.331    -0.617     0.200
     0.334    -1.117     0.200
     0.336    -0.100     0.200
     0.336    -0.480     0.200
     0.342     0.870     0.200
     0.375    -0.752     0.200
     0.355     0.646     0.200
     0.401    -0.387     0.200
     0.404    -0.394     0.200
     0.386     0.243     0.200
     0.390    -0.024     0.200
     0.411    -0.618     0.200
     0.404     0.293     0.200
     0.430    -0.675     0.200
     0.438    -0.238     0.200
     0.441    -0.575     0.200
     0.444    -0.410     0.200
     0.434     0.045     0.200
     0.465    -0.425     0.200
     0.453     0.265     0.200
     0.486    -0.781     0.200
     0.483    -0.860     0.200
     0.476     1.270     0.200
     0.477    -0.267     0.200
     0.483     0.847     0.200
     0.499    -0.546     0.200
     0.510    -0.582     0.200
     0.519     0.163     0.200
     0.533    -0.861     0.200
     0.556     0.300     0.200
     0.574    -0.798     0.200
     0.560    -0.204     0.200
     0.568     0.176     0.200
     0.578     0.279     0.200
     0.607    -0.013     0.200
     0.600     0.158     0.200
     0.612    -0.453     0.200
     0.606     0.087     0.200
     0.598     0.132     0.200
     0.611     0.701     0.200
     0.609     0.812     0.200
     0.620    -0.070     0.200
     0.616     1.366     0.200
     0.647    -0.482     0.200
     0.645     0.269     0.200
     0.656    -0.448     0.200
     0.652    -0.229     0.200
     0.660    -0.262     0.200
     0.656     1.729     0.200
     0.654     0.091     0.200
     0.673    -0.135     0.200
     0.675     0.482     0.200
     0.682    -0.268     0.200
     0.690     1.769     0.200
     0.706     2.299     0.200
     0.716     0.082     0.200
     0.704     0.132     0.200
     0.725    -0.311     0.200
     0.729    -0.336     0.200
     0.732    -0.158     0.200
     0.741    -0.320     0.200
     0.738    -0.146     0.200
     0.728     0.556     0.200
     0.734     0.074     0.200
     0.751    -0.418     0.200
     0.762    -0.382     0.200
     0.768    -0.374     0.200
     0.768     0.129     0.200
     0.787    -0.083     0.200
     0.800    -0.224     0.200
     0.802    -0.150     0.200
     0.826    -0.246     0.200
     0.835    -0.118     0.200
     0.846     0.133     0.200
     0.854    -0.100     0.200
     0.921    -0.279     0.200
     0.040     0.168     0.200
     0.124     0.976     0.200
     0.174     1.076     0.200
     0.195     0.961     0.200
     0.185     1.503     0.200
     0.193     1.810     0.200
     0.209     0.336     0.200
     0.242     0.323     0.200
     0.249    -0.644     0.200
     0.287     1.771     0.200
     0.337     1.131     0.200
     0.322     1.126     0.200
     0.326    -0.489     0.200
     0.356     0.012     0.200
     0.368     0.276     0.200
     0.448     1.049     0.200
     0.428    -1.044     0.200
     0.439     0.293     0.200
     0.484    -0.849     0.200
     0.483    -0.397     0.200
     0.497     0.956     0.200
     0.553    -0.419     0.200
     0.560     1.175     0.200
     0.603     0.823     0.200
     0.618    -1.259     0.200
     0.617     1.684     0.200
     0.641     1.006     0.200
     0.652    -0.741     0.200
     0.701     1.017     0.200
     0.709     1.757     0.200
     0.723     0.426     0.200
     0.752     1.724     0.200
     0.782    -0.094     0.200
     0.801     0.838     0.200
     0.841    -0.178     0.200
     0.835    -0.531     0.200
     0.906    -0.097     0.200
     0.124     0.705     0.200
     0.098     1.488     0.200
     0.163     1.360     0.200
     0.178     0.850     0.200
     0.154     2.160     0.200
     0.189     1.309     0.200
     0.196     1.020     0.200
     0.192     0.683     0.200
     0.179     2.348     0.200
     0.212    -0.728     0.200
     0.240     1.054     0.200
     0.246    -0.780     0.200
     0.288     0.801     0.200
     0.324     1.059     0.200
     0.330    -0.612     0.200
     0.359    -0.045     0.200
     0.367     0.614     0.200
     0.407    -0.459     0.200
     0.432    -1.239     0.200
     0.442     0.443     0.200
     0.446     1.819     0.200
     0.481    -0.662     0.200
     0.486    -0.003     0.200
     0.516     0.747     0.200
     0.497     1.104     0.200
     0.562     0.802     0.200
     0.556    -0.676     0.200
     0.602     0.677     0.200
     0.615    -0.986     0.200
     0.635     0.573     0.200
     0.650    -0.700     0.200
     0.642     1.286     0.200
     0.709     1.880     0.200
     0.700     1.434     0.200
     0.726     1.083     0.200
     0.714     0.666     0.200
     0.751     1.606     0.200
     0.753     2.115     0.200
     0.748    -0.126     0.200
     0.763    -0.361     0.200
     0.786     0.264     0.200
     0.780     0.911     0.200
     0.798     0.143     0.200
     0.837    -0.136     0.200
     0.982    -0.447     0.200
     0.035    -0.079     0.200
     0.104     1.924     0.200
     0.125     1.370     0.200
     0.169     1.331     0.200
     0.162     2.482     0.200
     0.206    -0.124     0.200
     0.199     0.947     0.200
     0.245     1.191     0.200
     0.287     1.402     0.200
     0.320    -0.251     0.200
     0.352     0.083     0.200
     0.342     1.163     0.200
     0.371     0.900     0.200
     0.399    -0.193     0.200
     0.423    -1.211     0.200
     0.434     0.445     0.200
     0.452     0.689     0.200
     0.451     1.420     0.200
     0.478    -0.213     0.200
     0.469    -0.150     0.200
     0.488    -0.688     0.200
     0.498     0.844     0.200
     0.519     0.631     0.200
     0.547    -0.408     0.200
     0.559     0.700     0.200
     0.606     0.575     0.200
     0.629    -0.636     0.200
     0.623    -1.594     0.200
     0.623    -1.023     0.200
     0.640     0.732     0.200
     0.655    -1.009     0.200
     0.698     1.061     0.200
     0.720     0.473     0.200
     0.739    -0.222     0.200
     0.721     0.218     0.200
     0.755     0.427     0.200
     0.762     0.284     0.200
     0.784     1.275     0.200
     0.773     0.209     0.200
     0.795     0.240     0.200
     0.785    -0.012     0.200
     0.804     0.027     0.200
     0.832    -0.661     0.200
     0.836    -0.082     0.200
     0.831     0.140     0.200
     0.849     0.111     0.200
     0.887    -0.256     0.200
     0.902    -0.119     0.200
     0.936    -0.654     0.200
     0.975    -0.302     0.200
     0.988    -0.189     0.200
     0.034     0.076     0.200
     0.105     1.970     0.200
     0.124     1.188     0.200
     0.168     1.320     0.200
     0.163     2.062     0.200
     0.179     1.296     0.200
     0.187     1.571     0.200
     0.186     2.581     0.200
     0.206    -0.638     0.200
     0.199     0.977     0.200
     0.246     0.754     0.200
     0.288     0.902     0.200
     0.317     1.082     0.200
     0.351     0.134     0.200
     0.343     1.379     0.200
     0.371     0.672     0.200
     0.398    -0.309     0.200
     0.422    -1.019     0.200
     0.433     0.496     0.200
     0.452     1.226     0.200
     0.451     0.976     0.200
     0.478    -0.129     0.200
     0.470    -0.291     0.200
     0.498     1.173     0.200
     0.488    -0.884     0.200
     0.547    -1.098     0.200
     0.559     0.920     0.200
     0.607     0.859     0.200
     0.640     0.663     0.200
     0.623    -1.781     0.200
     0.655    -1.359     0.200
     0.699     0.329     0.200
     0.720    -0.594     0.200
     0.707     1.516     0.200
     0.723    -0.040     0.200
     0.746     0.868     0.200
     0.750     1.192     0.200
     0.785     1.023     0.200
     0.786    -0.386     0.200
     0.796    -1.267     0.200
     0.805     0.912     0.200
     0.827     0.022     0.200
     0.836    -0.285     0.200
     0.902    -0.472     0.200
     0.106     1.472     0.200
     0.120     1.021     0.200
     0.162     2.115     0.200
     0.156     1.391     0.200
     0.187     2.199     0.200
     0.173     1.107     0.200
     0.181     1.638     0.200
     0.194     0.854     0.200
     0.188     1.570     0.200
     0.211     0.176     0.200
     0.247     1.010     0.200
     0.292     0.719     0.200
     0.316     1.216     0.200
     0.343     1.057     0.200
     0.322    -0.471     0.200
     0.357    -0.082     0.200
     0.366     0.761     0.200
     0.426    -0.853     0.200
     0.454     1.036     0.200
     0.438     0.463     0.200
     0.446     1.102     0.200
     0.471     0.094     0.200
     0.482    -0.836     0.200
     0.483    -0.123     0.200
     0.502     0.989     0.200
     0.514     0.591     0.200
     0.551    -0.358     0.200
     0.564     0.859     0.200
     0.555     0.130     0.200
     0.609     0.711     0.200
     0.618    -0.943     0.200
     0.635     0.231     0.200
     0.645     0.961     0.200
     0.650    -0.803     0.200
     0.722     0.037     0.200
     0.703     1.838     0.200
     0.725     0.416     0.200
     0.744     0.088     0.200
     0.744     1.594     0.200
     0.760     0.887     0.200
     0.747     1.925     0.200
     0.767    -0.603     0.200
     0.774     0.441     0.200
     0.787    -0.144     0.200
     0.801     0.423     0.200
     0.829    -0.349     0.200
     0.841    -0.103     0.200
     0.907    -0.322     0.200
     0.042     0.032     0.200
     0.101     1.553     0.200
     0.122     0.852     0.200
     0.178     0.994     0.200
     0.187     1.591     0.200
     0.181     2.250     0.200
     0.191     0.758     0.200
     0.194     1.149     0.200
     0.242     0.973     0.200
     0.249    -0.588     0.200
     0.290     1.670     0.200
     0.321     1.122     0.200
     0.337     1.140     0.200
     0.365     0.667     0.200
     0.360    -0.071     0.200
     0.432    -1.004     0.200
     0.443     0.269     0.200
     0.449     1.499     0.200
     0.479    -1.031     0.200
     0.487    -0.171     0.200
     0.500     0.924     0.200
     0.559     0.321     0.200
     0.557    -0.561     0.200
     0.564     0.880     0.200
     0.605     0.849     0.200
     0.614    -0.972     0.200
     0.637     0.055     0.200
     0.648    -0.480     0.200
     0.645     0.860     0.200
     0.698     0.769     0.200
     0.715     0.281     0.200
     0.749     1.458     0.200
     0.751     1.749     0.200
     0.749     0.067     0.200
     0.782     0.484     0.200
     0.800     0.451     0.200
     0.803     0.975     0.200
     0.835    -0.421     0.200
     0.835     0.088     0.200
     0.910    -0.132     0.200
     0.146    -0.247     0.200
     0.189    -0.654     0.200
     0.187    -0.021     0.200
     0.249     0.132     0.200
     0.252    -0.488     0.200
     0.267    -0.364     0.200
     0.283     0.340     0.200
     0.291     0.645     0.200
     0.352     1.199     0.200
     0.355     0.211     0.200
     0.349     0.096     0.200
     0.370    -0.436     0.200
     0.392     1.566     0.200
     0.388    -0.810     0.200
     0.401     1.478     0.200
     0.403     0.142     0.200
     0.390    -0.675     0.200
     0.415     1.490     0.200
     0.420    -0.770     0.200
     0.432     0.309     0.200
     0.426    -0.791     0.200
     0.441     1.925     0.200
     0.445     0.106     0.200
     0.446    -0.509     0.200
     0.467     0.300     0.200
     0.479    -0.646     0.200
     0.490    -0.765     0.200
     0.503    -0.757     0.200
     0.525     0.888     0.200
     0.541    -0.620     0.200
     0.562    -0.610     0.200
     0.577     1.041     0.200
     0.568    -0.489     0.200
     0.575    -0.666     0.200
     0.606     0.638     0.200
     0.607    -0.563     0.200
     0.615     1.880     0.200
     0.654     0.307     0.200
     0.646    -0.293     0.200
     0.664    -0.443     0.200
     0.668     0.598     0.200
     0.685    -0.092     0.200
     0.688    -0.360     0.200
     0.692    -0.466     0.200
     0.695    -0.635     0.200
     0.695    -0.344     0.200
     0.695    -0.303     0.200
     0.688    -0.332     0.200
     0.713    -0.478     0.200
     0.724    -0.565     0.200
     0.730     0.292     0.200
     0.741     0.322     0.200
     0.757     0.893     0.200
     0.751     0.839     0.200
     0.773    -0.155     0.200
     0.777    -0.346     0.200
     0.791    -0.042     0.200
     0.845    -0.282     0.200
     0.863    -0.682     0.200
     0.289     0.496     0.200
     0.307    -0.623     0.200
     0.335     0.277     0.200
     0.326    -0.431     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.878    -1.755     0.200
     0.883    -0.783     0.200
     0.890    -0.357     0.200
     0.947    -0.316     0.200
     0.928    -1.556     0.200
     0.964    -0.998     0.200
     0.887    -1.552     0.200
     0.945    -1.368     0.200
     0.865    -1.870     0.200
     0.902    -1.288     0.200
     0.861    -1.900     0.200
     0.904    -1.472     0.200
     0.876    -1.845     0.200
     0.987    -1.529     0.200
     0.883    -2.052     0.200
     0.987    -1.890     0.200
     0.821    -1.141     0.200
     0.821    -1.489     0.200
     0.980    -0.908     0.200
     0.971    -0.153     0.200
     0.993    -1.028     0.200
     0.994    -0.520     0.200
     0.946    -1.372     0.200
     0.946     0.757     0.200
     0.985    -1.336     0.200
     0.975    -0.282     0.200
     0.923    -0.742     0.200
     0.929    -0.970     0.200
     0.846    -1.843     0.200
     0.962    -0.437     0.200
     0.944     1.272     0.200
     0.928    -1.809     0.200
     0.995    -0.792     0.200
     0.940    -0.747     0.200
     0.940    -0.864     0.200
     0.998    -0.828     0.200
     0.888    -1.187     0.200
     0.862    -1.221     0.200
     0.980    -1.564     0.200
     0.980    -1.017     0.200
     0.893    -1.597     0.200
     0.983    -1.670     0.200
     0.983     0.463     0.200
     0.938    -0.788     0.200
     0.938    -1.312     0.200
     0.975    -0.625     0.200
     0.983    -0.740     0.200
     0.942    -0.340     0.200
     0.946    -0.821     0.200
     0.949    -0.646     0.200
     0.949    -1.029     0.200
     0.986    -1.182     0.200
     0.994    -0.906     0.200
     0.938    -0.232     0.200
     0.946    -0.132     0.200
     0.946    -0.827     0.200
     0.984    -0.589     0.200
     0.995    -1.011     0.200
     0.937    -0.928     0.200
     0.944    -0.781     0.200
     0.981    -0.435     0.200
     0.949    -0.520     0.200
     0.952    -0.556     0.200
     0.983    -0.783     0.200
     0.941    -0.892     0.200
     0.968    -0.275     0.200
     0.935    -0.429     0.200
     0.942    -0.821     0.200
     0.992    -1.021     0.200
     0.934    -1.550     0.200
     0.942    -1.073     0.200
     0.984    -0.609     0.200
     0.950    -1.521     0.200
     0.957    -1.040     0.200
     0.984    -0.489     0.200
     0.942    -1.111     0.200
     0.950    -0.057     0.200
     0.950    -1.081     0.200
     0.989    -0.616     0.200
     0.948    -1.034     0.200
     0.952    -0.268     0.200
     0.955    -0.504     0.200
     0.955    -0.679     0.200
     0.996    -0.166     0.200
     0.942    -1.232     0.200
     0.974    -0.955     0.200
     0.976    -0.861     0.200
     0.926    -0.957     0.200
     0.930    -1.522     0.200
     0.933    -1.316     0.200
     0.933    -0.688     0.200
     0.970    -0.826     0.200
     0.970    -0.946     0.200
     0.968    -0.719     0.200
     0.933    -0.884     0.200
     0.975    -1.593     0.200
     0.993    -0.903     0.200
     0.859    -0.859     0.200
     0.834    -0.749     0.200
     0.915    -0.999     0.200
     0.968    -0.075     0.200
     0.854    -1.879     0.200
     0.897    -1.635     0.200
     0.852    -1.216     0.200
     0.825    -1.532     0.200
     0.851    -1.298     0.200
     0.964    -0.188     0.200
     0.987    -0.785     0.200
     0.839    -1.604     0.200
     0.842    -1.405     0.200
     0.807    -1.372     0.200
     0.844    -1.968     0.200
     0.830     1.534     0.200
     0.918    -1.450     0.200
     0.936    -1.146     0.200
     0.967    -0.732     0.200
     0.985    -0.262     0.200
     0.868    -0.372     0.200
     0.807    -0.947     0.200
     0.807    -1.600     0.200
     0.834    -1.188     0.200
     0.881    -1.103     0.200
     0.984    -0.860     0.200
     0.999    -0.608     0.200
     0.990     0.219     0.200
     0.990    -0.505     0.200
     0.749    -1.804     0.200
     0.910     0.509     0.200
     0.979     0.034     0.200
     0.842    -1.550     0.200
     0.842    -1.405     0.200
     0.832    -0.396     0.200
     0.807    -0.894     0.200
     0.846     0.163     0.200
     0.883    -1.694     0.200
     0.858    -1.420     0.200
     0.853    -1.120     0.200
     0.852    -1.407     0.200
     0.895     0.403     0.200
     0.895     0.864     0.200
     0.902    -1.594     0.200
     0.905    -0.766     0.200
     0.954    -1.403     0.200
     0.963    -1.299     0.200
     0.968    -0.801     0.200
     0.930    -1.514     0.200
     0.805    -1.761     0.200
     0.808    -1.715     0.200
     0.808     0.125     0.200
     0.856    -1.758     0.200
     0.863    -1.592     0.200
     0.868    -1.228     0.200
     0.871    -1.543     0.200
     0.871    -1.437     0.200
     0.879    -0.932     0.200
     0.907    -1.098     0.200
     0.916    -1.237     0.200
     0.921    -0.884     0.200
     0.844    -0.810     0.200
     0.863    -1.047     0.200
     0.877    -1.224     0.200
     0.945    -0.112     0.200
     0.934     0.181     0.200
     0.978     0.066     0.200
     0.850    -0.382     0.200
     0.866    -1.090     0.200
     0.879    -0.682     0.200
     0.940    -0.193     0.200
     0.946    -0.155     0.200
     0.985    -0.593     0.200
     0.851    -1.082     0.200
     0.875    -1.905     0.200
     0.889    -1.187     0.200
     0.940    -0.627     0.200
     0.950    -0.563     0.200
     0.959    -0.621     0.200
     0.968    -0.234     0.200
     0.847    -1.175     0.200
     0.863    -1.346     0.200
     0.876    -1.105     0.200
     0.942    -0.577     0.200
     0.847    -1.096     0.200
     0.863    -1.559     0.200
     0.876    -1.211     0.200
     0.937    -0.820     0.200
     0.943    -1.031     0.200
     0.943    -1.113     0.200
     0.985    -1.402     0.200
     0.843    -1.899     0.200
     0.843    -1.583     0.200
     0.879    -1.201     0.200
     0.890    -1.040     0.200
     0.903    -0.997     0.200
     0.932    -0.317     0.200
     0.951    -0.135     0.200
     0.953    -0.398     0.200
     0.889    -0.297     0.200
     0.940    -0.409     0.200
     0.977    -0.790     0.200
     0.987    -0.121     0.200
     0.981    -1.299     0.200
     0.981    -1.096     0.200
     0.892    -0.380     0.200
     0.938    -0.514     0.200
     0.952    -1.088     0.200
     0.976    -1.024     0.200
     0.985    -1.302     0.200
     0.985    -0.372     0.200
     0.979    -1.297     0.200
     0.866    -0.868     0.200
     0.870    -1.674     0.200
     0.899    -1.176     0.200
     0.906    -1.585     0.200
     0.880    -1.129     0.200
     0.900    -0.193     0.200
     0.972    -0.821     0.200
     0.980    -0.197     0.200
     0.981    -0.775     0.200
     0.988    -0.723     0.200
     0.992    -0.426     0.200
     0.781    -1.222     0.200
     0.803    -1.122     0.200
     0.817     0.675     0.200
     0.843    -0.823     0.200
     0.855    -1.362     0.200
     0.855    -1.832     0.200
     0.868    -0.905     0.200
     0.914    -0.869     0.200
     0.925    -1.437     0.200
     0.928    -1.381     0.200
     0.780    -1.381     0.200
     0.809    -1.636     0.200
     0.829    -1.139     0.200
     0.829    -1.717     0.200
     0.837    -1.045     0.200
     0.837    -0.920     0.200
     0.900    -1.057     0.200
     0.908    -1.299     0.200
     0.908    -1.096     0.200
     0.962     0.503     0.200
     0.842    -0.763     0.200
     0.904    -0.341     0.200
     0.908    -1.298     0.200
     0.754    -1.586     0.200
     0.754    -1.802     0.200
     0.754    -1.565     0.200
     0.788     1.230     0.200
     0.789     0.481     0.200
     0.778    -1.107     0.200
     0.777    -0.517     0.200
     0.805    -1.039     0.200
     0.807     0.375     0.200
     0.859    -1.513     0.200
     0.877    -1.327     0.200
     0.876    -0.992     0.200
     0.844    -1.811     0.200
     0.941    -1.444     0.200
     0.968    -1.370     0.200
     0.841    -0.624     0.200
     0.908    -0.324     0.200
     0.903    -1.447     0.200
     0.903    -0.854     0.200
     0.942    -1.132     0.200
     0.802    -1.807     0.200
     0.800    -1.530     0.200
     0.831    -1.440     0.200
     0.834    -1.329     0.200
     0.843    -1.476     0.200
     0.880    -1.216     0.200
     0.918    -1.297     0.200
     0.913    -0.152     0.200
     0.929    -0.599     0.200
     0.978    -1.587     0.200
     0.803    -1.532     0.200
     0.829    -1.718     0.200
     0.835    -0.398     0.200
     0.894    -1.606     0.200
     0.863    -1.578     0.200
     0.908    -1.501     0.200
     0.890    -0.733     0.200
     0.992    -0.545     0.200
     0.787     0.756     0.200
     0.814    -1.156     0.200
     0.830    -0.611     0.200
     0.837    -0.616     0.200
     0.850    -0.337     0.200
     0.902    -0.742     0.200
     0.902     1.939     0.200
     0.922    -0.374     0.200
     0.961    -0.672     0.200
     0.972    -0.397     0.200
     0.972    -0.563     0.200
     0.991    -0.424     0.200
     0.993    -0.518     0.200
     0.848    -1.786     0.200
     0.867    -1.821     0.200
     0.878    -1.567     0.200
     0.895    -0.532     0.200
     0.931    -1.547     0.200
     0.929    -1.484     0.200
     0.862    -0.584     0.200
     0.989    -0.846     0.200
     0.810    -1.613     0.200
     0.856    -0.904     0.200
     0.872    -1.449     0.200
     0.863     0.052     0.200
     0.891    -1.367     0.200
     0.957    -0.766     0.200
     0.993    -0.939     0.200
     0.861    -0.415     0.200
     0.890    -0.993     0.200
     0.899    -0.675     0.200
     0.898    -1.805     0.200
     0.896    -1.749     0.200
     0.902     0.199     0.200
     0.810    -1.261     0.200
     0.851    -1.525     0.200
     0.867    -0.920     0.200
     0.867    -0.731     0.200
     0.916    -0.542     0.200
     0.717    -1.673     0.200
     0.726    -0.996     0.200
     0.752    -1.093     0.200
     0.768    -0.636     0.200
     0.782    -0.917     0.200
     0.785    -1.488     0.200
     0.810    -1.061     0.200
     0.852    -0.794     0.200
     0.846    -1.226     0.200
     0.875    -1.199     0.200
     0.895    -1.013     0.200
     0.899    -1.247     0.200
     0.974    -0.655     0.200
     0.971    -0.513     0.200
     0.831    -0.766     0.200
     0.967    -0.337     0.200
     0.983    -0.319     0.200
     0.987     0.019     0.200
     0.899    -0.993     0.200
     0.904    -1.661     0.200
     0.911    -0.588     0.200
     0.987    -1.485     0.200
     0.840    -1.202     0.200
     0.845    -1.985     0.200
     0.905    -0.895     0.200
     0.914    -1.690     0.200
     0.827    -0.942     0.200
     0.833    -1.237     0.200
     0.884    -0.711     0.200
     0.899    -0.890     0.200
     0.973    -1.041     0.200
     0.974    -0.230     0.200
     0.993    -0.169     0.200
     0.965    -0.558     0.200
     0.975    -1.518     0.200
     0.834    -1.625     0.200
     0.907    -1.654     0.200
     0.910    -1.745     0.200
     0.947    -1.370     0.200
     0.970    -1.338     0.200
     0.970    -1.638     0.200
     0.994    -1.189     0.200
     0.938    -1.580     0.200
     0.985    -1.234     0.200
     0.907    -0.511     0.200
     0.946    -0.976     0.200
     0.946    -1.203     0.200
     0.976    -1.281     0.200
     0.981    -1.010     0.200
     0.993    -0.972     0.200
     0.999    -1.401     0.200
     0.821    -1.105     0.200
     0.834    -0.980     0.200
     0.887    -1.368     0.200
     0.907    -1.729     0.200
     0.971    -1.478     0.200
     0.827    -0.103     0.200
     0.881    -0.404     0.200
     0.877    -0.474     0.200
     0.897    -0.583     0.200
     0.901    -1.324     0.200
     0.901    -0.438     0.200
     0.938    -0.147     0.200
     0.836    -1.234     0.200
     0.889    -1.417     0.200
     0.892    -0.728     0.200
     0.931    -1.235     0.200
     0.931    -1.015     0.200
     0.969    -1.454     0.200
     0.986    -0.939     0.200
     0.890    -1.478     0.200
     0.912    -1.302     0.200
     0.912    -1.501     0.200
     0.830    -1.830     0.200
     0.834    -1.460     0.200
     0.881    -1.059     0.200
     0.892    -1.567     0.200
     0.895    -1.403     0.200
     0.885    -1.446     0.200
     0.935    -0.975     0.200
     0.975    -0.543     0.200
     0.977    -0.788     0.200
     0.845    -1.253     0.200
     0.900    -1.316     0.200
     0.907    -1.262     0.200
     0.948    -1.021     0.200
     0.907    -1.550     0.200
     0.843    -1.395     0.200
     0.878    -1.226     0.200
     0.905    -0.951     0.200
     0.908    -0.979     0.200
     0.908    -1.206     0.200
     0.832    -1.136     0.200
     0.832    -1.370     0.200
     0.851    -1.398     0.200
     0.865    -0.562     0.200
     0.819    -1.623     0.200
     0.884    -1.196     0.200
     0.894    -0.455     0.200
     0.894    -0.830     0.200
     0.922    -0.419     0.200
     0.941     0.234     0.200
     0.944    -0.591     0.200
     0.932     0.247     0.200
     0.825    -1.502     0.200
     0.824    -1.469     0.200
     0.824    -1.641     0.200
     0.880    -0.686     0.200
     0.878    -1.124     0.200
     0.910    -0.285     0.200
     0.842    -2.202     0.200
     0.788     0.195     0.200
     0.800    -0.337     0.200
     0.827    -1.140     0.200
     0.855    -1.757     0.200
     0.895    -0.886     0.200
     0.912    -1.176     0.200
     0.912    -0.482     0.200
     0.924    -1.072     0.200
     0.923     0.076     0.200
     0.936    -1.282     0.200
     0.940     0.337     0.200
     0.955     0.990     0.200
     0.824    -1.597     0.200
     0.826    -1.263     0.200
     0.835    -1.569     0.200
     0.869    -1.361     0.200
     0.885    -0.668     0.200
     0.885    -0.779     0.200
     0.907    -1.063     0.200
     0.914    -0.342     0.200
     0.920    -1.370     0.200
     0.933    -1.352     0.200
     0.849    -1.314     0.200
     0.825    -1.370     0.200
     0.852    -1.558     0.200
     0.866    -1.631     0.200
     0.884    -0.883     0.200
     0.883    -1.069     0.200
     0.875    -0.439     0.200
     0.912    -0.556     0.200
     0.919    -1.218     0.200
     0.933    -0.904     0.200
     0.932    -0.275     0.200
     0.940    -1.235     0.200
     0.975    -1.183     0.200
     0.821    -1.865     0.200
     0.823    -1.433     0.200
     0.838    -1.891     0.200
     0.845    -1.741     0.200
     0.860    -1.383     0.200
     0.871    -0.801     0.200
     0.890    -0.651     0.200
     0.896    -0.566     0.200
     0.903    -0.543     0.200
     0.903    -0.172     0.200
     0.920    -0.686     0.200
     0.923    -0.252     0.200
     0.940    -1.127     0.200
     0.936    -1.080     0.200
     0.987    -0.986     0.200
     0.739     0.005     0.200
     0.763    -0.701     0.200
     0.795    -1.623     0.200
     0.773    -1.092     0.200
     0.806    -0.488     0.200
     0.799    -1.489     0.200
     0.824    -1.381     0.200
     0.799     0.701     0.200
     0.813    -0.181     0.200
     0.831    -0.683     0.200
     0.833    -0.715     0.200
     0.873    -1.293     0.200
     0.880    -1.115     0.200
     0.884    -0.057     0.200
     0.884    -0.798     0.200
     0.897    -0.316     0.200
     0.909     0.522     0.200
     0.902    -0.584     0.200
     0.924    -0.623     0.200
     0.951     1.095     0.200
     0.959    -0.755     0.200
     0.995    -1.031     0.200
     0.821    -1.902     0.200
     0.825    -1.433     0.200
     0.829    -1.701     0.200
     0.831    -1.018     0.200
     0.831    -1.932     0.200
     0.855    -1.719     0.200
     0.882    -1.542     0.200
     0.883    -0.953     0.200
     0.883    -1.052     0.200
     0.894    -1.285     0.200
     0.903    -0.980     0.200
     0.899    -1.655     0.200
     0.906    -0.612     0.200
     0.914    -0.576     0.200
     0.912    -0.156     0.200
     0.934    -0.816     0.200
     0.960    -1.029     0.200
     0.803    -1.092     0.200
     0.812    -1.926     0.200
     0.818    -1.747     0.200
     0.822    -1.503     0.200
     0.810    -0.898     0.200
     0.828    -1.380     0.200
     0.830    -1.387     0.200
     0.852    -1.550     0.200
     0.854    -1.397     0.200
     0.878    -1.450     0.200
     0.912     0.083     0.200
     0.894    -1.189     0.200
     0.912    -0.393     0.200
     0.900    -1.048     0.200
     0.906    -0.573     0.200
     0.930    -0.938     0.200
     0.932    -0.109     0.200
     0.943    -0.930     0.200
     0.797    -1.494     0.200
     0.831    -1.653     0.200
     0.849    -1.469     0.200
     0.863    -1.722     0.200
     0.852    -0.680     0.200
     0.885    -1.389     0.200
     0.865    -0.759     0.200
     0.879    -0.940     0.200
     0.886    -1.137     0.200
     0.898    -0.739     0.200
     0.898    -0.753     0.200
     0.908    -0.733     0.200
     0.926    -0.927     0.200
     0.940    -0.859     0.200
     0.953    -1.042     0.200
     0.976    -0.869     0.200
     0.979    -0.685     0.200
     0.978    -0.713     0.200
     0.977     0.935     0.200
     0.988    -0.009     0.200
     0.813    -0.733     0.200
     0.807    -1.577     0.200
     0.880    -1.338     0.200
     0.898    -1.208     0.200
     0.906    -1.022     0.200
     0.921    -1.446     0.200
     0.908    -1.502     0.200
     0.928    -0.584     0.200
     0.985    -1.357     0.200
     0.800    -1.359     0.200
     0.808    -1.907     0.200
     0.808    -1.849     0.200
     0.815    -1.413     0.200
     0.834    -1.512     0.200
     0.862    -0.667     0.200
     0.862    -0.873     0.200
     0.874    -1.070     0.200
     0.885     0.028     0.200
     0.893    -0.185     0.200
     0.881    -1.409     0.200
     0.913    -0.691     0.200
     0.826    -1.748     0.200
     0.838    -1.959     0.200
     0.866    -0.750     0.200
     0.872    -0.814     0.200
     0.887    -0.552     0.200
     0.885    -0.128     0.200
     0.967    -0.526     0.200
     0.963    -0.800     0.200
     0.960    -0.670     0.200
     0.999    -1.529     0.200
     0.824    -1.577     0.200
     0.826    -1.539     0.200
     0.831    -1.532     0.200
     0.836    -1.683     0.200
     0.846    -0.414     0.200
     0.865    -0.626     0.200
     0.884    -0.493     0.200
     0.892    -1.184     0.200
     0.919    -1.742     0.200
     0.938    -1.490     0.200
     0.961    -0.187     0.200
     0.958    -0.459     0.200
     0.961    -1.456     0.200
     0.966    -0.074     0.200
     0.973    -1.078     0.200
     0.998    -0.827     0.200
     0.999    -0.488     0.200
     0.859    -0.742     0.200
     0.886    -1.569     0.200
     0.828    -1.700     0.200
     0.831    -1.748     0.200
     0.844    -0.622     0.200
     0.856    -1.771     0.200
     0.859    -0.951     0.200
     0.879    -0.560     0.200
     0.887    -1.840     0.200
     0.929    -1.486     0.200
     0.961    -0.781     0.200
     0.991    -1.341     0.200
     0.992    -0.606     0.200
     0.818    -1.157     0.200
     0.814     0.032     0.200
     0.833    -1.455     0.200
     0.839    -1.859     0.200
     0.858    -1.639     0.200
     0.864    -1.380     0.200
     0.887    -0.905     0.200
     0.893    -1.787     0.200
     0.893    -0.977     0.200
     0.904    -1.437     0.200
     0.918    -1.214     0.200
     0.795    -1.503     0.200
     0.799    -1.852     0.200
     0.797    -0.013     0.200
     0.811    -0.655     0.200
     0.822    -1.394     0.200
     0.824    -1.315     0.200
     0.824    -1.565     0.200
     0.836    -1.491     0.200
     0.846    -1.769     0.200
     0.911    -1.132     0.200
     0.905    -0.522     0.200
     0.908    -1.204     0.200
     0.920    -0.761     0.200
     0.750    -1.218     0.200
     0.752    -1.119     0.200
     0.743    -1.202     0.200
     0.758    -1.189     0.200
     0.794    -1.483     0.200
     0.782    -1.308     0.200
     0.823    -1.092     0.200
     0.762    -0.994     0.200
     0.833    -1.486     0.200
     0.839    -1.358     0.200
     0.780    -0.209     0.200
     0.830    -1.417     0.200
     0.854    -0.866     0.200
     0.834    -0.936     0.200
     0.830    -1.383     0.200
     0.878    -1.309     0.200
     0.878    -1.179     0.200
     0.873     0.941     0.200
     0.807     0.312     0.200
     0.888    -1.400     0.200
     0.917    -1.500     0.200
     0.916    -1.119     0.200
     0.922    -1.441     0.200
     0.922    -1.311     0.200
     0.932    -0.481     0.200
     0.943    -0.761     0.200
     0.943    -0.490     0.200
     0.897    -0.863     0.200
     0.903    -0.378     0.200
     0.896     0.516     0.200
     0.904    -0.197     0.200
     0.925    -0.991     0.200
     0.784    -0.588     0.200
     0.779    -0.775     0.200
     0.789    -1.598     0.200
     0.797    -0.866     0.200
     0.816    -1.256     0.200
     0.819    -0.784     0.200
     0.819    -0.451     0.200
     0.831    -1.793     0.200
     0.820    -1.558     0.200
     0.841    -0.625     0.200
     0.822    -0.957     0.200
     0.837    -0.656     0.200
     0.852    -1.154     0.200
     0.840    -1.065     0.200
     0.855    -0.714     0.200
     0.854    -0.397     0.200
     0.882    -0.241     0.200
     0.871    -1.295     0.200
     0.873     0.302     0.200
     0.885     0.637     0.200
     0.895    -0.977     0.200
     0.918     0.323     0.200
     0.912    -0.823     0.200
     0.921     1.004     0.200
     0.981    -0.384     0.200
     0.808    -0.539     0.200
     0.823     0.427     0.200
     0.830    -1.288     0.200
     0.829    -1.196     0.200
     0.858    -0.861     0.200
     0.862    -1.416     0.200
     0.879    -1.544     0.200
     0.891    -1.117     0.200
     0.890    -1.570     0.200
     0.918    -1.335     0.200
     0.926    -1.263     0.200
     0.930    -1.209     0.200
     0.972    -0.566     0.200
     0.981    -1.446     0.200
     0.981    -1.126     0.200
     0.985    -1.268     0.200
     0.999    -1.543     0.200
     0.814    -1.600     0.200
     0.825    -0.973     0.200
     0.815    -1.577     0.200
     0.848    -0.063     0.200
     0.842    -0.846     0.200
     0.837    -0.811     0.200
     0.869    -0.160     0.200
     0.866    -1.496     0.200
     0.878    -1.645     0.200
     0.860    -0.836     0.200
     0.871    -1.463     0.200
     0.848    -0.630     0.200
     0.887    -1.234     0.200
     0.890    -1.102     0.200
     0.906    -0.235     0.200
     0.997    -1.544     0.200
     0.774    -1.194     0.200
     0.774    -0.999     0.200
     0.788    -1.011     0.200
     0.790    -0.899     0.200
     0.824    -0.498     0.200
     0.813    -0.671     0.200
     0.810    -0.917     0.200
     0.827    -0.059     0.200
     0.821    -0.222     0.200
     0.819    -1.079     0.200
     0.828    -1.562     0.200
     0.821    -0.947     0.200
     0.820    -1.266     0.200
     0.846     0.167     0.200
     0.831    -0.083     0.200
     0.855    -1.255     0.200
     0.865     0.633     0.200
     0.859    -0.988     0.200
     0.873    -1.705     0.200
     0.885    -0.128     0.200
     0.877    -0.409     0.200
     0.869    -0.881     0.200
     0.903     1.237     0.200
     0.894    -0.949     0.200
     0.887    -0.835     0.200
     0.894    -0.837     0.200
     0.913     0.060     0.200
     0.942    -0.512     0.200
     0.977    -1.458     0.200
     0.960     0.823     0.200
     0.827    -0.833     0.200
     0.827    -1.592     0.200
     0.858    -1.576     0.200
     0.857    -1.568     0.200
     0.889    -0.660     0.200
     0.889    -0.339     0.200
     0.913    -1.581     0.200
     0.990    -0.586     0.200
     0.824    -1.637     0.200
     0.824    -1.610     0.200
     0.860    -1.739     0.200
     0.854    -1.536     0.200
     0.861    -1.170     0.200
     0.887    -0.610     0.200
     0.885    -0.303     0.200
     0.934    -1.360     0.200
     0.940    -0.068     0.200
     0.842    -1.457     0.200
     0.844    -1.498     0.200
     0.844    -1.510     0.200
     0.863    -1.720     0.200
     0.889    -1.644     0.200
     0.889    -1.545     0.200
     0.883    -0.723     0.200
     0.886    -0.707     0.200
     0.904    -0.607     0.200
     0.905    -0.568     0.200
     0.917    -1.584     0.200
     0.929    -0.974     0.200
     0.807    -1.473     0.200
     0.805    -1.696     0.200
     0.824    -0.528     0.200
     0.837    -1.750     0.200
     0.847    -1.871     0.200
     0.847    -1.591     0.200
     0.861    -1.756     0.200
     0.884    -1.050     0.200
     0.899     0.085     0.200
     0.916    -0.618     0.200
     0.910    -1.110     0.200
     0.918    -0.321     0.200
     0.926    -1.113     0.200
     0.778    -1.520     0.200
     0.789    -1.223     0.200
     0.787    -1.339     0.200
     0.800    -1.671     0.200
     0.790    -0.996     0.200
     0.832    -1.048     0.200
     0.853    -1.763     0.200
     0.899    -1.614     0.200
     0.898    -0.955     0.200
     0.905    -1.417     0.200
     0.894    -0.863     0.200
     0.885    -1.031     0.200
     0.909    -1.469     0.200
     0.905    -1.374     0.200
     0.977    -1.241     0.200
     0.825    -1.699     0.200
     0.831    -1.713     0.200
     0.848    -1.515     0.200
     0.861    -0.755     0.200
     0.979    -1.662     0.200
     0.800    -1.011     0.200
     0.834    -1.141     0.200
     0.822    -0.246     0.200
     0.844    -1.663     0.200
     0.921     0.462     0.200
     0.908    -1.648     0.200
     0.935    -0.550     0.200
     0.982    -1.003     0.200
     0.827    -1.838     0.200
     0.953    -1.453     0.200
     0.887    -1.398     0.200
     0.974    -1.652     0.200
     0.828    -1.710     0.200
     0.839    -0.233     0.200
     0.833    -1.667     0.200
     0.853    -1.092     0.200
     0.856    -1.447     0.200
     0.893    -1.008     0.200
     0.914     0.412     0.200
     0.940    -0.945     0.200
     0.964    -1.438     0.200
     0.980    -1.356     0.200
     0.822    -1.294     0.200
     0.836    -1.487     0.200
     0.845    -1.823     0.200
     0.850    -1.471     0.200
     0.942    -1.549     0.200
     0.938    -0.865     0.200
     0.824    -1.602     0.200
     0.850    -1.632     0.200
     0.851    -1.738     0.200
     0.878    -1.581     0.200
     0.885    -0.950     0.200
     0.889    -1.641     0.200
     0.904    -0.782     0.200
     0.905    -1.857     0.200
     0.915    -1.311     0.200
     0.908    -1.491     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00   -0.055
 0.70   -0.055
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.1
 0.70    0.1
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-0.7)
     0.050     7.000   Pg = red x; average =  -0.1 (solid red line)
     0.050    -7.500   Sg = red circles; average =   0.1 (dashed red line)
EOF
gmt end
