#!/bin/bash
gmt begin salton5.43_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic salton5.43'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.552
   136.000     1.637
   136.500     1.726
   137.000     1.817
   137.500     1.912
   138.000     2.010
   138.500     2.112
   139.000     2.217
   139.500     2.326
   140.000     2.438
   140.500     2.555
   141.000     2.676
   141.500     2.802
   142.000     2.932
   142.500     3.067
   143.000     3.207
   143.500     3.352
   144.000     3.503
   144.500     3.659
   145.000     3.821
   145.500     3.990
   146.000     4.165
   146.500     4.346
   147.000     4.535
   147.500     4.730
   148.000     4.933
   148.500     5.144
   149.000     5.364
   149.500     5.592
   150.000     5.830
   150.500     6.078
   151.000     6.336
   151.500     6.605
   152.000     6.884
   152.500     7.172
   153.000     7.471
   153.500     7.781
   154.000     8.101
   154.500     8.432
   155.000     8.774
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.687
   145.500     0.276
   146.000     1.303
   146.500     2.372
   147.000     3.476
   147.500     4.610
   148.000     5.771
   148.500     6.957
   149.000     8.167
   149.500     9.400
   150.000    10.655
   150.500    11.930
   151.000    13.227
   151.500    14.543
   152.000    15.878
   152.500    17.232
   153.000    18.603
   153.500    19.993
   154.000    21.399
   154.500    22.824
   155.000    24.265
   155.500    25.724
   156.000    27.199
   156.500    28.691
   157.000    30.200
   157.500    31.725
   158.000    33.267
   158.500    34.826
   159.000    36.401
   159.500    37.993
   160.000    39.600
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.690
   145.500     0.076
   146.000     0.769
   146.500     1.411
   147.000     2.010
   147.500     2.570
   148.000     3.095
   148.500     3.587
   149.000     4.053
   149.500     4.499
   150.000     4.929
   150.500     5.346
   151.000     5.753
   151.500     6.150
   152.000     6.538
   152.500     6.920
   153.000     7.295
   153.500     7.667
   154.000     8.036
   154.500     8.402
   155.000     8.767
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   143.337     0.787     0.200
   145.775     0.495     0.200
   146.999     2.637     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   146.932     2.344     0.200
   148.202     8.063     0.200
   148.537     9.641     0.200
   148.543     6.333     0.200
   145.377     0.577     0.200
   145.384     0.795     0.200
   145.384     0.592     0.200
   145.692     1.759     0.200
   145.382     0.829     0.200
   145.686     1.846     0.200
   145.797     0.666     0.200
   146.341     1.699     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   145.775     3.456     0.200
   146.020     2.938     0.200
   148.889     5.131     0.200
   145.270     3.617     0.200
   145.374     1.790     0.200
   145.374     2.056     0.200
   145.709     2.451     0.200
   146.205     2.957     0.200
   145.707     2.097     0.200
   146.205     4.046     0.200
   146.185     3.020     0.200
   146.960     3.610     0.200
   145.842     2.622     0.200
   147.013     4.667     0.200
   145.401     2.346     0.200
   146.262     6.002     0.200
   146.922     3.959     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
