#!/bin/bash
gmt begin salton5.43_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P salton5.43'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.708
    79.000     8.533
    80.000     7.443
    81.000     6.438
    82.000     5.519
    83.000     4.684
    84.000     3.933
    85.000     3.270
    86.000     2.692
    87.000     2.193
    88.000     1.797
    89.000     1.497
    90.000     1.239
    91.000     1.013
    92.000     0.812
    93.000     0.630
    94.000     0.464
    95.000     0.319
    96.000     0.199
    97.000     0.106
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    14.343     4.604     0.200
    14.551     6.692     0.200
    22.153     1.894     0.200
    84.460     1.704     0.200
    91.976     0.391     0.200
    93.602    -1.811     0.200
    22.618     3.252     0.200
    93.835     1.356     0.200
    36.250     2.174     0.200
    81.594    -0.749     0.200
    81.594     2.251     0.200
    93.591    -0.349     0.200
    93.593    -0.194     0.200
    14.959     7.233     0.200
    15.363     5.009     0.200
    18.184     2.092     0.200
    21.128     2.153     0.200
    22.370     2.105     0.200
    23.490     2.951     0.200
    26.893     4.241     0.200
    29.195     2.632     0.200
    36.482     3.123     0.200
    36.756     3.031     0.200
    85.120    -0.759     0.200
    92.637     0.599     0.200
    94.264    -0.890     0.200
    14.989     7.185     0.200
    22.428     0.037     0.200
    28.581    -0.252     0.200
    35.798     0.089     0.200
    81.213    -1.619     0.200
    93.180    -2.049     0.200
    15.270     3.800     0.200
    15.270     3.406     0.200
    29.543     4.084     0.200
    14.428     8.887     0.200
    14.864     4.021     0.200
    14.864     3.471     0.200
    15.109     7.550     0.200
    15.452     4.371     0.200
    15.761     3.374     0.200
    16.028     1.918     0.200
    18.408    -0.564     0.200
    21.431     1.036     0.200
    21.511     1.696     0.200
    21.672     1.760     0.200
    22.412     2.382     0.200
    23.609     3.245     0.200
    23.623    -0.172     0.200
    24.842     0.259     0.200
    26.924     0.054     0.200
    29.140    -0.029     0.200
    36.310     1.551     0.200
    36.487     2.084     0.200
    36.856    -0.177     0.200
    37.072     0.065     0.200
    40.480     0.768     0.200
    93.893    -2.904     0.200
    96.627     1.107     0.200
    16.080     3.875     0.200
    16.592     6.017     0.200
    17.637     2.713     0.200
    18.601     1.490     0.200
    19.037     1.105     0.200
    19.919     0.858     0.200
    20.550     2.276     0.200
    21.452     1.367     0.200
    21.566     1.553     0.200
    21.705     2.647     0.200
    21.832     1.683     0.200
    21.852     2.923     0.200
    21.898     2.395     0.200
    22.109     4.890     0.200
    22.472     1.955     0.200
    22.565     2.034     0.200
    22.632     2.154     0.200
    22.808     1.481     0.200
    23.506     1.447     0.200
    23.621     0.426     0.200
    23.621     0.528     0.200
    23.803     2.235     0.200
    24.414     0.609     0.200
    24.441     1.579     0.200
    24.645     1.891     0.200
    24.764     2.196     0.200
    24.908     1.445     0.200
    24.957     3.739     0.200
    25.262     1.459     0.200
    25.343     1.774     0.200
    25.463     2.482     0.200
    26.391     1.422     0.200
    26.626     1.990     0.200
    26.626     2.373     0.200
    26.981     0.960     0.200
    26.981     1.280     0.200
    27.101     1.474     0.200
    27.508     1.281     0.200
    27.560     1.603     0.200
    28.017     3.375     0.200
    29.115     0.351     0.200
    29.115     0.601     0.200
    29.190     1.394     0.200
    29.566     1.853     0.200
    29.917     5.248     0.200
    30.633     3.804     0.200
    30.872    -0.266     0.200
    31.536     2.376     0.200
    31.553     3.035     0.200
    31.801     1.187     0.200
    31.833    -1.980     0.200
    32.277     5.051     0.200
    33.026     6.462     0.200
    33.075     2.590     0.200
    33.376     2.470     0.200
    33.782     1.942     0.200
    33.797     1.766     0.200
    33.950     2.321     0.200
    33.987     3.530     0.200
    34.085     1.700     0.200
    34.298     0.303     0.200
    34.445     2.295     0.200
    34.479     0.944     0.200
    34.479     2.486     0.200
    34.580     3.369     0.200
    34.657     2.144     0.200
    34.674     1.832     0.200
    34.721     2.855     0.200
    34.814     1.350     0.200
    34.928     3.263     0.200
    35.051     2.395     0.200
    35.087     2.490     0.200
    35.205     2.792     0.200
    35.626     2.610     0.200
    35.624     2.585     0.200
    35.657     2.304     0.200
    35.870     2.473     0.200
    36.145     2.299     0.200
    36.202     2.017     0.200
    36.212     3.227     0.200
    36.238     5.900     0.200
    36.270     1.004     0.200
    36.270     1.629     0.200
    36.387     2.038     0.200
    36.437     1.295     0.200
    36.437     1.404     0.200
    36.437     1.404     0.200
    36.635     1.681     0.200
    36.670     2.318     0.200
    36.806     5.264     0.200
    36.990     2.900     0.200
    36.982     1.686     0.200
    37.289     1.357     0.200
    37.320     1.167     0.200
    37.597     3.646     0.200
    37.829     1.543     0.200
    37.870     2.702     0.200
    39.094     3.973     0.200
    39.120     2.553     0.200
    39.167     2.901     0.200
    39.412     0.973     0.200
    40.505    -0.042     0.200
    40.505     0.598     0.200
    42.256     0.325     0.200
    42.679     0.510     0.200
    44.318     1.343     0.200
    44.878    -0.659     0.200
    45.858     1.629     0.200
    46.639     5.234     0.200
    47.046     5.909     0.200
    47.377     5.693     0.200
    47.392     3.873     0.200
    47.623     4.916     0.200
    47.750     0.523     0.200
    48.158     4.162     0.200
    48.251     4.577     0.200
    48.410     2.800     0.200
    48.410     3.355     0.200
    48.563     6.130     0.200
    48.598     3.029     0.200
    48.632     4.233     0.200
    48.680     4.659     0.200
    48.728     2.123     0.200
    48.754     0.703     0.200
    49.057    -0.046     0.200
    50.018     1.410     0.200
    50.323     0.489     0.200
    50.323     1.153     0.200
    52.569     0.670     0.200
    54.165     6.634     0.200
    54.657     5.551     0.200
    54.904     1.467     0.200
    54.904     1.248     0.200
    61.315     2.164     0.200
    61.315     5.062     0.200
    61.685     1.310     0.200
    61.689     5.310     0.200
    61.689     1.286     0.200
    62.982     1.592     0.200
    62.982     5.264     0.200
    63.154     5.934     0.200
    64.065     3.218     0.200
    65.861     3.558     0.200
    67.615     1.236     0.200
    71.083     6.079     0.200
    71.840     2.751     0.200
    72.158     2.141     0.200
    72.991     0.336     0.200
    72.991     5.984     0.200
    73.657     0.360     0.200
    73.657     0.360     0.200
    73.745     4.988     0.200
    74.555     4.036     0.200
    74.555     6.356     0.200
    75.308     6.412     0.200
    76.239     4.387     0.200
    76.524     4.266     0.200
    76.690     1.065     0.200
    76.708     0.931     0.200
    76.708     1.181     0.200
    76.708     1.181     0.200
    79.094     3.080     0.200
    79.326     8.386     0.200
    79.723    -0.877     0.200
    80.502     5.316     0.200
    80.698     0.570     0.200
    80.698     0.593     0.200
    80.778     0.390     0.200
    80.843     1.796     0.200
    80.948     6.927     0.200
    81.174     4.825     0.200
    81.430     1.571     0.200
    81.528     0.283     0.200
    81.529     1.201     0.200
    81.529     0.443     0.200
    81.568     6.317     0.200
    81.577     4.588     0.200
    81.788     1.679     0.200
    81.858    -0.592     0.200
    82.030     4.037     0.200
    82.173     5.553     0.200
    82.255     5.726     0.200
    82.332     3.322     0.200
    82.406     0.433     0.200
    82.690    -0.146     0.200
    82.905     7.338     0.200
    82.905     5.939     0.200
    83.187     7.480     0.200
    83.441     5.771     0.200
    83.785     6.801     0.200
    84.039     2.604     0.200
    84.086     6.865     0.200
    84.190     0.938     0.200
    84.244     6.860     0.200
    84.601     6.855     0.200
    84.776     4.563     0.200
    84.862     1.475     0.200
    84.934     7.072     0.200
    84.948     6.697     0.200
    85.039     6.444     0.200
    85.111     6.879     0.200
    85.113     6.673     0.200
    85.129     6.596     0.200
    85.147     7.401     0.200
    85.190     6.791     0.200
    85.261     3.435     0.200
    85.305     6.614     0.200
    85.652     6.454     0.200
    85.771     6.282     0.200
    85.907     5.821     0.200
    85.990     6.183     0.200
    86.203     6.053     0.200
    86.271     6.821     0.200
    86.315     6.003     0.200
    86.345     3.855     0.200
    86.473     6.032     0.200
    86.499     2.198     0.200
    86.577     5.518     0.200
    86.577     8.416     0.200
    86.849     6.383     0.200
    86.849     2.234     0.200
    86.996     9.766     0.200
    87.476     5.840     0.200
    87.476     5.840     0.200
    87.677     5.872     0.200
    88.180     6.580     0.200
    88.228     4.151     0.200
    88.228     6.448     0.200
    88.489     4.518     0.200
    88.836     3.587     0.200
    89.023     6.605     0.200
    89.106     7.219     0.200
    89.448     3.408     0.200
    89.725     6.318     0.200
    90.029     6.292     0.200
    90.073     6.193     0.200
    90.097    10.077     0.200
    90.405     5.743     0.200
    90.405     2.110     0.200
    90.412     3.812     0.200
    90.430     3.980     0.200
    90.443     1.489     0.200
    90.443     1.489     0.200
    90.469     2.445     0.200
    90.938     0.990     0.200
    90.938     5.365     0.200
    90.938     0.959     0.200
    90.939     4.656     0.200
    90.941     4.819     0.200
    90.984     3.950     0.200
    91.048     0.799     0.200
    91.052     1.483     0.200
    91.052     0.780     0.200
    91.052     5.132     0.200
    91.700     7.527     0.200
    92.181    -3.199     0.200
    92.315     6.240     0.200
    92.665     5.467     0.200
    93.042     3.033     0.200
    93.258     5.731     0.200
    93.680     2.692     0.200
    93.790     5.586     0.200
    93.833     0.889     0.200
    94.572     5.892     0.200
    95.170     4.257     0.200
    95.170     4.858     0.200
    95.441     6.018     0.200
    96.561     1.617     0.200
    98.377     1.130     0.200
    98.377     1.130     0.200
    16.463     6.599     0.200
    15.253     4.488     0.200
    37.078     2.178     0.200
    17.681     1.055     0.200
    36.140     1.281     0.200
    14.535     7.993     0.200
    15.265     6.281     0.200
    37.091     1.912     0.200
    15.262     3.648     0.200
    15.606     3.491     0.200
    27.219     2.658     0.200
    36.121     2.023     0.200
    37.086     3.417     0.200
    40.071     2.794     0.200
    94.593     0.081     0.200
    14.733     4.216     0.200
    15.264     3.929     0.200
    15.412     2.549     0.200
    15.609     2.538     0.200
    15.993     1.849     0.200
    16.062     3.879     0.200
    17.223     1.676     0.200
    17.636     0.914     0.200
    18.051     0.698     0.200
    18.193     0.661     0.200
    18.172     3.594     0.200
    18.252     0.487     0.200
    18.343     1.612     0.200
    18.415    -1.794     0.200
    18.462    -0.935     0.200
    18.567    -1.167     0.200
    18.594    -0.055     0.200
    18.599    -0.466     0.200
    18.611    -0.166     0.200
    18.705    -0.092     0.200
    18.717     0.357     0.200
    18.720     0.549     0.200
    18.753    -0.201     0.200
    18.846     0.072     0.200
    18.915     0.214     0.200
    18.958     0.497     0.200
    18.965     0.183     0.200
    19.034     0.550     0.200
    19.036     0.344     0.200
    19.054    -0.858     0.200
    19.065    -0.429     0.200
    19.080     0.228     0.200
    19.094    -1.119     0.200
    19.125    -1.074     0.200
    19.137    -0.101     0.200
    19.173    -0.867     0.200
    19.199    -0.010     0.200
    19.212    -0.134     0.200
    19.222    -0.127     0.200
    19.301     0.471     0.200
    19.356     0.145     0.200
    19.426    -0.180     0.200
    19.470    -0.768     0.200
    19.487    -0.147     0.200
    19.507    -0.843     0.200
    19.553     0.767     0.200
    19.629    -0.471     0.200
    19.717     0.331     0.200
    19.736     0.337     0.200
    19.762     0.539     0.200
    19.777     0.480     0.200
    19.782     0.450     0.200
    19.791     0.695     0.200
    19.801     0.329     0.200
    19.819    -0.766     0.200
    19.861     1.072     0.200
    19.864     0.867     0.200
    19.887     1.179     0.200
    19.892     0.547     0.200
    19.952     0.858     0.200
    20.013     0.892     0.200
    20.061    -0.741     0.200
    20.070     0.004     0.200
    20.129    -1.845     0.200
    20.267    -0.650     0.200
    20.270    -1.113     0.200
    20.297    -0.338     0.200
    20.317    -0.751     0.200
    20.323    -0.489     0.200
    20.353    -0.807     0.200
    20.353    -1.090     0.200
    20.365    -0.941     0.200
    20.369    -0.122     0.200
    20.398     0.688     0.200
    20.398    -0.773     0.200
    20.400     0.661     0.200
    20.412     0.132     0.200
    20.421    -0.104     0.200
    20.459    -1.297     0.200
    20.533    -0.611     0.200
    20.567    -1.150     0.200
    20.568    -0.886     0.200
    20.667     0.628     0.200
    20.691    -0.131     0.200
    20.717    -0.331     0.200
    20.721    -0.784     0.200
    20.777    -0.112     0.200
    20.789    -0.273     0.200
    20.799    -0.042     0.200
    20.816    -0.232     0.200
    20.856     1.227     0.200
    20.937     0.141     0.200
    20.939    -0.148     0.200
    20.980    -0.418     0.200
    20.985    -0.053     0.200
    20.989     0.218     0.200
    20.994    -0.992     0.200
    21.014    -1.911     0.200
    21.032     1.373     0.200
    21.039     0.733     0.200
    21.059     5.280     0.200
    21.059    -0.665     0.200
    21.067    -0.191     0.200
    21.107    -1.153     0.200
    21.126     0.514     0.200
    21.158     0.619     0.200
    21.161     0.311     0.200
    21.161     1.256     0.200
    21.174     0.996     0.200
    21.175    -0.356     0.200
    21.197     1.203     0.200
    21.196     2.384     0.200
    21.251    -0.214     0.200
    21.271    -0.652     0.200
    21.318     0.145     0.200
    21.328    -0.281     0.200
    21.344     0.511     0.200
    21.371     0.552     0.200
    21.419    -0.832     0.200
    21.452     0.830     0.200
    21.465     0.072     0.200
    21.505    -0.340     0.200
    21.523    -0.158     0.200
    21.543    -0.570     0.200
    21.552     0.563     0.200
    21.570    -0.127     0.200
    21.629    -0.084     0.200
    21.632    -0.524     0.200
    21.640     0.366     0.200
    21.645    -1.014     0.200
    21.658    -0.140     0.200
    21.675     0.089     0.200
    21.711     0.346     0.200
    21.713    -0.425     0.200
    21.719    -0.256     0.200
    21.771    -0.019     0.200
    21.782     0.403     0.200
    21.790     0.175     0.200
    21.796    -0.073     0.200
    21.801     0.162     0.200
    21.910     0.599     0.200
    21.930    -1.482     0.200
    21.934    -0.502     0.200
    21.949     0.639     0.200
    21.954     0.125     0.200
    21.961     0.879     0.200
    22.009     0.337     0.200
    22.062     0.424     0.200
    22.106     0.174     0.200
    22.114    -0.338     0.200
    22.117     0.172     0.200
    22.134    -0.820     0.200
    22.143     0.548     0.200
    22.171    -1.474     0.200
    22.195    -0.790     0.200
    22.195    -0.110     0.200
    22.224    -0.513     0.200
    22.236    -0.654     0.200
    22.264    -0.296     0.200
    22.283    -0.213     0.200
    22.286    -0.263     0.200
    22.289     2.309     0.200
    22.289    -0.183     0.200
    22.289    -0.043     0.200
    22.341    -1.102     0.200
    22.347     2.161     0.200
    22.347    -0.792     0.200
    22.377    -2.167     0.200
    22.437    -0.274     0.200
    22.457    -0.145     0.200
    22.459    -0.852     0.200
    22.462    -0.828     0.200
    22.499    -0.215     0.200
    22.528     0.354     0.200
    22.597    -0.513     0.200
    22.616     0.152     0.200
    22.682     0.148     0.200
    22.724    -0.822     0.200
    22.731    -0.504     0.200
    22.745    -0.674     0.200
    22.782     0.620     0.200
    22.782    -0.317     0.200
    22.788    -0.106     0.200
    22.789    -1.459     0.200
    22.829    -0.417     0.200
    22.838    -0.967     0.200
    22.864     0.089     0.200
    22.902    -0.481     0.200
    22.917    -0.486     0.200
    22.937    -0.459     0.200
    22.978    -3.213     0.200
    23.014    -3.191     0.200
    23.056     1.184     0.200
    23.060    -3.529     0.200
    23.119    -3.992     0.200
    23.148    -3.211     0.200
    23.170     1.401     0.200
    23.202    -3.113     0.200
    23.233    -4.527     0.200
    23.274    -2.209     0.200
    23.292    -2.936     0.200
    23.343    -3.169     0.200
    23.369    -1.621     0.200
    23.415    -3.137     0.200
    23.420    -3.526     0.200
    23.424    -3.004     0.200
    23.454    -1.193     0.200
    23.486    -2.078     0.200
    23.505    -2.459     0.200
    23.574    -3.655     0.200
    23.607    -2.106     0.200
    23.612    -3.271     0.200
    23.675     0.737     0.200
    23.680    -2.891     0.200
    23.719     0.463     0.200
    23.716    -0.900     0.200
    23.731     0.773     0.200
    23.734    -2.116     0.200
    23.779     0.932     0.200
    23.808     0.432     0.200
    23.844    -1.879     0.200
    23.909    -0.552     0.200
    23.927    -1.555     0.200
    23.927    -1.359     0.200
    23.949    -0.672     0.200
    23.950    -1.237     0.200
    23.989    -1.866     0.200
    24.048     0.948     0.200
    24.058     1.699     0.200
    24.070     0.477     0.200
    24.122     1.733     0.200
    24.153     1.426     0.200
    24.163     0.845     0.200
    24.179     1.182     0.200
    24.249     1.794     0.200
    24.263     1.004     0.200
    24.301     1.192     0.200
    24.313     0.923     0.200
    24.321     0.154     0.200
    24.327    -0.664     0.200
    24.328    -0.507     0.200
    24.388    -0.212     0.200
    24.424     0.199     0.200
    24.461     0.845     0.200
    24.483     1.914     0.200
    24.585     0.330     0.200
    24.587     1.217     0.200
    24.590     0.500     0.200
    24.637    -1.427     0.200
    24.643    -0.832     0.200
    24.671    -1.172     0.200
    24.703     0.821     0.200
    24.789     0.430     0.200
    24.792     1.171     0.200
    24.803     1.944     0.200
    24.822     1.635     0.200
    24.867     2.190     0.200
    24.869     1.931     0.200
    24.882     2.442     0.200
    24.980     2.629     0.200
    25.071     2.214     0.200
    25.075     1.177     0.200
    25.102     0.820     0.200
    25.242     1.324     0.200
    25.247     1.927     0.200
    25.363     0.522     0.200
    25.395     1.684     0.200
    25.394     2.457     0.200
    25.400     0.980     0.200
    25.404     1.697     0.200
    25.422     1.928     0.200
    25.423     3.198     0.200
    25.427     1.924     0.200
    25.444     1.693     0.200
    25.524     0.091     0.200
    25.555     1.409     0.200
    25.587     0.710     0.200
    25.624     1.182     0.200
    25.776     1.674     0.200
    25.781     2.335     0.200
    25.850     1.163     0.200
    25.849     1.147     0.200
    25.879     1.416     0.200
    25.979     1.169     0.200
    25.980     0.146     0.200
    26.050     0.147     0.200
    26.095     1.911     0.200
    26.138     1.475     0.200
    26.146     1.464     0.200
    26.148     0.823     0.200
    26.254     1.150     0.200
    26.312     0.471     0.200
    26.326     2.135     0.200
    26.337    -0.179     0.200
    26.411     1.192     0.200
    26.416     1.400     0.200
    26.435    -0.862     0.200
    26.460    -1.667     0.200
    26.521    -0.358     0.200
    26.618    -0.644     0.200
    26.651     0.123     0.200
    26.775     1.195     0.200
    26.807     0.890     0.200
    26.825     1.140     0.200
    26.898     1.409     0.200
    26.904     1.897     0.200
    26.942     1.682     0.200
    27.196     1.408     0.200
    27.220     2.531     0.200
    27.257     1.379     0.200
    27.276     1.941     0.200
    27.350     1.028     0.200
    27.389     0.456     0.200
    27.623     2.413     0.200
    27.670     1.673     0.200
    28.949     1.863     0.200
    28.996     2.831     0.200
    29.345     0.769     0.200
    29.388     1.104     0.200
    29.488     2.682     0.200
    29.632     1.883     0.200
    30.390     2.101     0.200
    30.921    -0.464     0.200
    32.422     0.770     0.200
    32.536     0.498     0.200
    32.971     6.737     0.200
    33.419     5.592     0.200
    33.633     0.743     0.200
    35.172     4.538     0.200
    35.501    -0.469     0.200
    36.123     2.249     0.200
    36.801     1.920     0.200
    36.821     7.606     0.200
    37.087     3.064     0.200
    37.087     3.165     0.200
    37.635     3.262     0.200
    37.996     2.963     0.200
    40.071     2.433     0.200
    40.544     1.717     0.200
    46.580     2.161     0.200
    47.086     4.052     0.200
    47.540     3.566     0.200
    47.772     0.999     0.200
    53.323     4.080     0.200
    54.990     2.482     0.200
    54.990     2.342     0.200
    62.053     3.670     0.200
    62.053     3.998     0.200
    62.118     3.029     0.200
    62.504     2.498     0.200
    64.260    -6.251     0.200
    66.767     1.480     0.200
    73.861    -0.054     0.200
    74.799     1.099     0.200
    76.528     2.165     0.200
    76.758     1.441     0.200
    77.970     4.869     0.200
    78.620     1.775     0.200
    80.402     2.068     0.200
    80.581     1.943     0.200
    80.839     1.351     0.200
    80.938     1.354     0.200
    81.591     3.513     0.200
    82.380     3.892     0.200
    82.380     0.990     0.200
    83.076     3.772     0.200
    83.904     2.038     0.200
    83.926     3.400     0.200
    84.339     3.469     0.200
    84.441     1.974     0.200
    84.634     4.703     0.200
    84.759     4.972     0.200
    85.351     4.532     0.200
    86.236    -4.052     0.200
    86.760    -0.710     0.200
    86.791     2.284     0.200
    86.825    -1.828     0.200
    86.983     0.069     0.200
    87.063     2.058     0.200
    87.794    -1.019     0.200
    88.799    -1.971     0.200
    88.896     4.323     0.200
    89.008     3.397     0.200
    89.760     6.079     0.200
    90.121     1.688     0.200
    90.756     5.630     0.200
    91.002     2.792     0.200
    91.022     1.097     0.200
    91.131     5.377     0.200
    91.145     2.988     0.200
    91.599     4.993     0.200
    91.599     1.696     0.200
    91.743     3.447     0.200
    93.214     3.561     0.200
    93.777     2.470     0.200
    94.123     2.279     0.200
    94.150     1.379     0.200
    94.593    -2.481     0.200
    95.137     4.328     0.200
    95.682     3.541     0.200
    98.740    -1.374     0.200
    15.304     7.513     0.200
    27.249     4.662     0.200
    37.112     2.906     0.200
    40.094     2.995     0.200
    14.505     5.092     0.200
    14.730     6.389     0.200
    14.728     4.991     0.200
    14.816     8.589     0.200
    14.893     4.613     0.200
    14.958     5.607     0.200
    15.261     2.739     0.200
    15.369     3.151     0.200
    16.059     3.352     0.200
    16.179     6.309     0.200
    16.245     5.165     0.200
    16.472     1.774     0.200
    16.561     3.864     0.200
    16.686     6.062     0.200
    17.112     3.739     0.200
    17.633     2.102     0.200
    17.633     0.563     0.200
    17.705     5.555     0.200
    17.870     0.305     0.200
    18.167     4.877     0.200
    18.169     3.647     0.200
    18.260     1.315     0.200
    18.338     0.458     0.200
    18.342     1.718     0.200
    18.488    -1.339     0.200
    18.517    -1.176     0.200
    18.567    -1.154     0.200
    18.610    -1.714     0.200
    18.703    -0.146     0.200
    18.715    -0.460     0.200
    18.843    -0.977     0.200
    19.053    -1.159     0.200
    19.064    -0.595     0.200
    19.091    -0.316     0.200
    19.172    -0.509     0.200
    19.210     0.030     0.200
    19.425     0.103     0.200
    19.551     0.360     0.200
    19.761     0.339     0.200
    19.776     0.517     0.200
    19.788     0.153     0.200
    19.788     0.481     0.200
    19.799     0.514     0.200
    19.850     0.374     0.200
    19.860    -0.046     0.200
    20.058     0.556     0.200
    20.067    -0.224     0.200
    20.266     0.720     0.200
    20.296    -0.052     0.200
    20.352    -0.048     0.200
    20.363     0.590     0.200
    20.396     0.163     0.200
    20.412     0.546     0.200
    20.457     0.538     0.200
    20.566    -0.432     0.200
    20.815     0.129     0.200
    20.854    -0.512     0.200
    20.938    -0.997     0.200
    20.977    -0.431     0.200
    20.983     0.857     0.200
    20.989     0.350     0.200
    20.994     0.957     0.200
    21.010     0.773     0.200
    21.011    -0.021     0.200
    21.031     3.511     0.200
    21.038    -0.253     0.200
    21.064     0.991     0.200
    21.066     0.712     0.200
    21.106    -1.556     0.200
    21.126    -1.560     0.200
    21.157    -1.757     0.200
    21.159     0.586     0.200
    21.171     0.135     0.200
    21.174    -1.004     0.200
    21.197    -0.788     0.200
    21.193     2.365     0.200
    21.193     1.764     0.200
    21.249    -0.281     0.200
    21.255     2.463     0.200
    21.269    -0.640     0.200
    21.316     2.114     0.200
    21.316    -0.972     0.200
    21.325    -1.588     0.200
    21.343    -1.010     0.200
    21.368     2.052     0.200
    21.368    -0.761     0.200
    21.418    -1.386     0.200
    21.450     1.085     0.200
    21.462     0.524     0.200
    21.503    -0.117     0.200
    21.522     0.305     0.200
    21.536    -0.607     0.200
    21.542    -1.003     0.200
    21.550     0.300     0.200
    21.623     0.687     0.200
    21.627     0.557     0.200
    21.632     0.920     0.200
    21.638    -0.261     0.200
    21.644    -0.453     0.200
    21.657     0.497     0.200
    21.674     0.326     0.200
    21.708     0.931     0.200
    21.712    -0.137     0.200
    21.719     0.859     0.200
    21.769     0.610     0.200
    21.781     1.348     0.200
    21.781     0.668     0.200
    21.789    -0.635     0.200
    21.794     1.022     0.200
    21.800    -0.643     0.200
    21.907    -1.171     0.200
    21.928    -0.430     0.200
    21.933    -1.205     0.200
    21.946     0.802     0.200
    21.952    -0.774     0.200
    21.959     2.727     0.200
    22.007     0.084     0.200
    22.060     0.428     0.200
    22.105    -0.083     0.200
    22.113    -0.052     0.200
    22.114     0.874     0.200
    22.134     0.315     0.200
    22.141    -0.357     0.200
    22.192     0.730     0.200
    22.222    -0.583     0.200
    22.234    -0.234     0.200
    22.263     0.674     0.200
    22.262     0.842     0.200
    22.265     0.298     0.200
    22.281     0.576     0.200
    22.285     0.189     0.200
    22.288     1.146     0.200
    22.288     0.365     0.200
    22.289     0.478     0.200
    22.302     0.307     0.200
    22.341    -0.428     0.200
    22.345     1.562     0.200
    22.345     0.914     0.200
    22.375    -0.078     0.200
    22.435     0.788     0.200
    22.455     0.637     0.200
    22.458     0.101     0.200
    22.461     0.325     0.200
    22.497     0.437     0.200
    22.525     0.811     0.200
    22.525     1.201     0.200
    22.596    -0.653     0.200
    22.614    -0.044     0.200
    22.680    -1.588     0.200
    22.722     0.562     0.200
    22.730     0.445     0.200
    22.736     0.472     0.200
    22.744     0.870     0.200
    22.779     1.605     0.200
    22.779     1.073     0.200
    22.786     0.186     0.200
    22.788     0.847     0.200
    22.826     1.306     0.200
    22.826    -0.866     0.200
    22.836     0.720     0.200
    22.851     1.945     0.200
    22.861     0.674     0.200
    22.900     0.876     0.200
    22.906     0.121     0.200
    22.916     0.666     0.200
    22.928     1.929     0.200
    22.936     0.128     0.200
    22.976    -0.460     0.200
    23.013     0.283     0.200
    23.017     4.438     0.200
    23.017     0.282     0.200
    23.053     1.339     0.200
    23.053    -0.349     0.200
    23.056    -0.180     0.200
    23.059     0.095     0.200
    23.100     0.042     0.200
    23.118    -0.470     0.200
    23.146    -0.457     0.200
    23.168     1.132     0.200
    23.168    -0.290     0.200
    23.200    -0.402     0.200
    23.232    -1.409     0.200
    23.273    -1.786     0.200
    23.290     0.180     0.200
    23.294    -0.055     0.200
    23.341    -1.766     0.200
    23.367    -2.122     0.200
    23.383     1.410     0.200
    23.383    -1.145     0.200
    23.413    -0.044     0.200
    23.419    -0.848     0.200
    23.422     1.172     0.200
    23.422    -1.445     0.200
    23.439     6.092     0.200
    23.439     1.052     0.200
    23.452     0.105     0.200
    23.453     1.028     0.200
    23.471    -0.927     0.200
    23.484     1.955     0.200
    23.484    -0.365     0.200
    23.504     0.475     0.200
    23.533     0.128     0.200
    23.573    -0.195     0.200
    23.606     0.948     0.200
    23.610    -0.069     0.200
    23.654    -0.662     0.200
    23.673    -1.064     0.200
    23.679    -1.122     0.200
    23.697     0.359     0.200
    23.718    -0.152     0.200
    23.712     0.154     0.200
    23.728     0.251     0.200
    23.733    -0.745     0.200
    23.778    -0.377     0.200
    23.806    -1.304     0.200
    23.843    -0.373     0.200
    23.883     2.960     0.200
    23.883    -0.048     0.200
    23.907     2.693     0.200
    23.907     0.419     0.200
    23.926     1.135     0.200
    23.946     1.531     0.200
    23.946     0.555     0.200
    23.948     0.496     0.200
    23.968     0.252     0.200
    23.988     0.392     0.200
    24.047     1.339     0.200
    24.056    -0.186     0.200
    24.068    -0.014     0.200
    24.120    -1.111     0.200
    24.152    -0.162     0.200
    24.162     0.947     0.200
    24.177    -0.561     0.200
    24.195     3.611     0.200
    24.203     0.026     0.200
    24.204     1.356     0.200
    24.204    -0.972     0.200
    24.248     1.702     0.200
    24.261    -0.900     0.200
    24.293    -0.190     0.200
    24.299     0.809     0.200
    24.299     0.379     0.200
    24.312     0.746     0.200
    24.320     0.556     0.200
    24.327     0.364     0.200
    24.324     0.001     0.200
    24.386    -1.377     0.200
    24.423     0.958     0.200
    24.460     0.282     0.200
    24.484     1.823     0.200
    24.585     1.344     0.200
    24.589     1.114     0.200
    24.635     3.233     0.200
    24.635     0.233     0.200
    24.641     0.192     0.200
    24.669    -1.885     0.200
    24.670    -0.917     0.200
    24.703    -2.055     0.200
    24.701    -0.992     0.200
    24.751     0.384     0.200
    24.787    -0.554     0.200
    24.791    -0.944     0.200
    24.802    -1.313     0.200
    24.820    -1.879     0.200
    24.836     0.212     0.200
    24.865     3.353     0.200
    24.865     0.548     0.200
    24.868    -0.386     0.200
    24.881    -0.765     0.200
    24.977    -0.027     0.200
    25.069    -0.745     0.200
    25.074    -0.762     0.200
    25.100    -2.082     0.200
    25.185     0.368     0.200
    25.240    -1.176     0.200
    25.246    -0.396     0.200
    25.361     0.383     0.200
    25.394     0.941     0.200
    25.394     0.365     0.200
    25.400     0.895     0.200
    25.403    -1.707     0.200
    25.421     1.668     0.200
    25.422     2.357     0.200
    25.426     1.477     0.200
    25.442    -0.573     0.200
    25.547    -0.426     0.200
    25.554     0.905     0.200
    25.585    -0.153     0.200
    25.623     0.746     0.200
    25.774     1.853     0.200
    25.778     0.678     0.200
    25.848     0.350     0.200
    25.848     1.839     0.200
    25.860     1.144     0.200
    25.878     0.730     0.200
    25.918    -0.005     0.200
    25.977     0.742     0.200
    26.049    -0.211     0.200
    26.136    -0.409     0.200
    26.144     1.334     0.200
    26.146    -0.208     0.200
    26.253     0.903     0.200
    26.325     0.413     0.200
    26.336     1.501     0.200
    26.434     0.903     0.200
    26.458    -0.982     0.200
    26.474     0.169     0.200
    26.519     0.917     0.200
    26.622    -0.182     0.200
    26.642     0.621     0.200
    26.649     0.531     0.200
    26.661     1.692     0.200
    26.722    -0.094     0.200
    26.773     0.199     0.200
    26.823    -0.986     0.200
    26.858     1.265     0.200
    26.896     1.652     0.200
    26.902     0.887     0.200
    26.940     1.106     0.200
    27.013     1.328     0.200
    27.105     2.195     0.200
    27.217     3.106     0.200
    27.217     3.216     0.200
    27.255    -0.804     0.200
    27.388     0.693     0.200
    27.621     0.703     0.200
    28.657     4.313     0.200
    28.947    -1.022     0.200
    28.997     2.014     0.200
    29.284     6.782     0.200
    29.343     0.497     0.200
    29.485     1.337     0.200
    29.520     3.308     0.200
    29.630     5.323     0.200
    30.389     5.055     0.200
    30.389    -0.664     0.200
    30.388     3.215     0.200
    30.919     0.451     0.200
    30.934     0.808     0.200
    32.420     1.624     0.200
    32.420     1.155     0.200
    32.534     3.452     0.200
    32.534     1.515     0.200
    32.968     3.833     0.200
    33.417     6.859     0.200
    33.631     1.872     0.200
    34.191     4.959     0.200
    34.392     3.144     0.200
    35.382     5.737     0.200
    35.427     2.843     0.200
    35.499     0.112     0.200
    35.629     3.536     0.200
    35.710    -1.036     0.200
    35.722     3.192     0.200
    35.784     3.207     0.200
    36.094     3.386     0.200
    36.595     5.923     0.200
    36.797     2.299     0.200
    36.797     1.549     0.200
    36.934     3.074     0.200
    37.056     3.216     0.200
    37.084     1.754     0.200
    37.084     2.558     0.200
    37.084     2.964     0.200
    37.261     3.376     0.200
    37.287     2.495     0.200
    37.349     2.418     0.200
    37.426    -1.633     0.200
    37.632     3.850     0.200
    37.637     2.688     0.200
    37.993     2.479     0.200
    38.114     2.080     0.200
    38.490     3.115     0.200
    39.752     3.559     0.200
    40.068     1.434     0.200
    40.541     3.875     0.200
    40.541    -0.219     0.200
    42.954     1.756     0.200
    44.761     1.972     0.200
    47.291     5.296     0.200
    47.774     2.627     0.200
    47.812     5.404     0.200
    54.987     1.981     0.200
    62.050     2.186     0.200
    62.050     2.585     0.200
    62.119     2.382     0.200
    62.502     1.855     0.200
    64.995     0.666     0.200
    66.436     2.118     0.200
    66.769     2.638     0.200
    67.962     5.575     0.200
    69.475     0.107     0.200
    73.812     1.980     0.200
    73.858     0.713     0.200
    77.968     1.756     0.200
    78.253     1.486     0.200
    78.617     2.160     0.200
    80.400     0.456     0.200
    80.583     1.466     0.200
    80.836     0.412     0.200
    80.940     1.310     0.200
    80.940     2.279     0.200
    81.589     3.013     0.200
    81.589     1.716     0.200
    82.378     2.179     0.200
    82.379     2.066     0.200
    83.074     1.952     0.200
    83.901     1.228     0.200
    83.923     1.582     0.200
    84.342     2.805     0.200
    84.342     4.055     0.200
    84.438     1.465     0.200
    84.631     1.387     0.200
    86.495    -0.533     0.200
    86.757    -1.441     0.200
    86.788     1.773     0.200
    86.822     2.637     0.200
    86.980    -0.240     0.200
    87.060    -1.063     0.200
    87.791    -0.109     0.200
    88.303     2.392     0.200
    88.303     2.392     0.200
    88.415    -1.679     0.200
    88.893     3.208     0.200
    89.025     1.465     0.200
    89.757     3.261     0.200
    90.752     1.275     0.200
    90.752     1.518     0.200
    90.999     0.569     0.200
    91.019     0.406     0.200
    91.019     2.078     0.200
    91.129     4.121     0.200
    91.142     1.810     0.200
    91.595     1.856     0.200
    91.595     0.981     0.200
    91.595     1.254     0.200
    91.740     1.535     0.200
    92.337     2.292     0.200
    94.119     2.423     0.200
    94.119     1.962     0.200
    94.147     1.773     0.200
    94.590    -0.301     0.200
    95.133     2.815     0.200
    95.679     2.818     0.200
    95.679     1.326     0.200
    95.781     2.343     0.200
    98.737    -1.589     0.200
    15.243     3.501     0.200
    22.502     1.176     0.200
    27.203     2.248     0.200
    29.466     1.247     0.200
    29.466     1.247     0.200
    37.071     1.585     0.200
    37.071     1.585     0.200
    40.056     1.501     0.200
    15.316     6.042     0.200
    27.263     3.737     0.200
    37.126     2.257     0.200
    37.126     2.257     0.200
    14.956     4.360     0.200
    15.255     4.951     0.200
    15.565     5.680     0.200
    15.595     4.499     0.200
    15.664     4.126     0.200
    16.051     3.831     0.200
    16.684     5.926     0.200
    18.235    -0.120     0.200
    18.245     1.332     0.200
    18.245     0.527     0.200
    18.282    -0.153     0.200
    18.275     0.093     0.200
    18.327     0.938     0.200
    18.322     0.059     0.200
    18.445    -0.185     0.200
    18.552    -0.360     0.200
    18.576    -0.500     0.200
    18.582    -0.566     0.200
    18.687     0.251     0.200
    18.703     2.084     0.200
    18.703     0.607     0.200
    18.699     0.382     0.200
    18.737     1.521     0.200
    18.737    -1.925     0.200
    18.828    -0.755     0.200
    18.897     2.260     0.200
    18.897     0.002     0.200
    18.948     1.070     0.200
    18.948    -0.173     0.200
    18.948    -0.755     0.200
    19.017    -0.297     0.200
    19.038     0.554     0.200
    19.049     0.183     0.200
    19.062     0.454     0.200
    19.078     1.878     0.200
    19.078     1.027     0.200
    19.110     0.562     0.200
    19.157     0.364     0.200
    19.181     0.905     0.200
    19.195     0.121     0.200
    19.277     0.383     0.200
    19.338     0.593     0.200
    19.453    -0.042     0.200
    19.470     1.041     0.200
    19.490    -0.940     0.200
    19.535     0.182     0.200
    19.612    -0.445     0.200
    19.630    -0.070     0.200
    19.700    -0.773     0.200
    19.721    -0.750     0.200
    19.747     0.073     0.200
    19.761     0.169     0.200
    19.785    -0.028     0.200
    19.784     1.376     0.200
    19.835     1.326     0.200
    19.870     1.093     0.200
    19.875     0.739     0.200
    19.934    -0.074     0.200
    19.975     2.340     0.200
    19.975     0.652     0.200
    20.003     0.533     0.200
    19.996     1.311     0.200
    19.996     0.874     0.200
    20.030     1.404     0.200
    20.043     1.657     0.200
    20.052     1.777     0.200
    20.112     0.721     0.200
    20.250     0.425     0.200
    20.253     0.884     0.200
    20.305     0.584     0.200
    20.336     1.411     0.200
    20.354     1.261     0.200
    20.347     1.167     0.200
    20.380     2.768     0.200
    20.380     0.916     0.200
    20.382     0.269     0.200
    20.404     1.247     0.200
    20.404     1.083     0.200
    20.441     2.795     0.200
    20.441     1.412     0.200
    20.516     1.502     0.200
    20.552     2.589     0.200
    20.552     0.886     0.200
    20.649     0.243     0.200
    20.704     0.178     0.200
    20.699     1.059     0.200
    20.760     0.834     0.200
    20.772     1.379     0.200
    20.781     0.839     0.200
    20.838     0.796     0.200
    20.920     1.653     0.200
    20.979    -0.029     0.200
    20.962    -0.052     0.200
    20.967     0.031     0.200
    20.994     1.120     0.200
    20.996     0.750     0.200
    21.015     2.435     0.200
    21.044     1.350     0.200
    21.050     0.705     0.200
    21.048     0.909     0.200
    21.092     0.702     0.200
    21.143     1.565     0.200
    21.143     0.745     0.200
    21.156     0.142     0.200
    21.191     2.055     0.200
    21.233    -0.482     0.200
    21.254     0.292     0.200
    21.300     2.054     0.200
    21.300     0.976     0.200
    21.310     0.108     0.200
    21.353     2.462     0.200
    21.353     0.916     0.200
    21.434    -1.124     0.200
    21.447    -0.032     0.200
    21.488    -0.343     0.200
    21.527     0.543     0.200
    21.534    -0.143     0.200
    21.608    -0.961     0.200
    21.612     0.559     0.200
    21.696     0.717     0.200
    21.693     0.919     0.200
    21.753    -0.311     0.200
    21.766     2.258     0.200
    21.766     0.024     0.200
    21.778     0.603     0.200
    21.893    -0.413     0.200
    21.912    -0.047     0.200
    21.936    -0.100     0.200
    21.931     0.228     0.200
    21.944     1.572     0.200
    21.991     0.998     0.200
    22.044    -0.127     0.200
    22.097     0.410     0.200
    22.099     0.317     0.200
    22.126     0.207     0.200
    22.177     2.034     0.200
    22.177     0.433     0.200
    22.206    -0.097     0.200
    22.219    -0.365     0.200
    22.270    -0.621     0.200
    22.272     1.412     0.200
    22.272    -0.259     0.200
    22.266     1.796     0.200
    22.330     1.508     0.200
    22.330     0.211     0.200
    22.420    -0.318     0.200
    22.442    -0.255     0.200
    22.439     0.192     0.200
    22.445     0.528     0.200
    22.482     0.061     0.200
    22.511     1.227     0.200
    22.511     1.673     0.200
    22.665     0.018     0.200
    22.706    -0.250     0.200
    22.728    -0.427     0.200
    22.764     1.589     0.200
    22.764     0.761     0.200
    22.770     0.490     0.200
    22.811     1.523     0.200
    22.811     0.140     0.200
    22.820    -0.210     0.200
    22.846     0.465     0.200
    23.002     2.428     0.200
    23.002    -0.447     0.200
    23.041     0.562     0.200
    23.038     0.975     0.200
    23.038     0.826     0.200
    23.084     0.228     0.200
    23.152     0.941     0.200
    23.152    -0.473     0.200
    23.184     0.058     0.200
    23.257    -0.642     0.200
    23.279    -0.603     0.200
    23.275    -0.781     0.200
    23.326    -0.323     0.200
    23.367     1.471     0.200
    23.367    -0.935     0.200
    23.407     1.388     0.200
    23.407    -1.604     0.200
    23.468     2.445     0.200
    23.468    -0.172     0.200
    23.518    -0.614     0.200
    23.590     1.292     0.200
    23.590    -0.231     0.200
    23.594    -0.131     0.200
    23.682    -1.001     0.200
    23.702    -0.572     0.200
    23.718     0.698     0.200
    23.701    -0.056     0.200
    23.713     0.279     0.200
    23.868    -0.282     0.200
    23.932     0.059     0.200
    23.931     1.881     0.200
    23.931     0.654     0.200
    23.952     0.371     0.200
    24.052     0.811     0.200
    24.179     1.887     0.200
    24.189     1.285     0.200
    24.246    -0.280     0.200
    24.297     1.298     0.200
    24.407    -1.141     0.200
    24.444    -0.428     0.200
    24.573    -0.067     0.200
    24.569     0.150     0.200
    24.568     0.086     0.200
    24.619     2.203     0.200
    24.619    -1.047     0.200
    24.654    -0.931     0.200
    24.685     0.648     0.200
    24.685    -0.461     0.200
    24.850     2.205     0.200
    24.850    -0.990     0.200
    24.962     0.088     0.200
    25.054     0.678     0.200
    25.224    -1.037     0.200
    25.345     0.315     0.200
    25.379     0.749     0.200
    25.385     1.505     0.200
    25.407     1.408     0.200
    26.128    -0.602     0.200
    26.320     0.565     0.200
    26.418    -0.097     0.200
    26.545    -1.159     0.200
    26.601    -1.023     0.200
    26.633    -1.382     0.200
    26.881    -1.199     0.200
    26.924    -0.441     0.200
    26.997     1.648     0.200
    27.214     2.402     0.200
    27.214     3.331     0.200
    29.477     2.259     0.200
    30.386     3.107     0.200
    31.909     2.195     0.200
    32.967     3.517     0.200
    33.616    -1.789     0.200
    34.390     1.880     0.200
    35.618     3.825     0.200
    35.720     3.123     0.200
    35.784     2.860     0.200
    36.093     3.273     0.200
    36.793     2.060     0.200
    36.793     2.380     0.200
    36.934     2.890     0.200
    37.055     3.025     0.200
    37.083     1.638     0.200
    37.083     2.302     0.200
    37.083     2.771     0.200
    37.260     3.165     0.200
    37.286     2.198     0.200
    37.348     3.124     0.200
    37.637     2.471     0.200
    37.993     2.498     0.200
    38.489     2.997     0.200
    39.750     3.572     0.200
    40.067     2.065     0.200
    40.539     4.040     0.200
    54.976     1.495     0.200
    54.976     1.800     0.200
    62.051     1.381     0.200
    62.506     0.755     0.200
    73.848     0.476     0.200
    74.783    -0.571     0.200
    76.520     0.209     0.200
    76.743     1.722     0.200
    78.241     1.687     0.200
    80.825     1.378     0.200
    80.934     1.527     0.200
    81.593     1.547     0.200
    83.886     0.830     0.200
    83.909     1.442     0.200
    84.742     1.117     0.200
    91.142     1.967     0.200
    91.592     0.297     0.200
    92.325     1.609     0.200
    94.141    -0.838     0.200
    94.593    -0.629     0.200
    95.674     0.951     0.200
    95.777     0.483     0.200
    14.236     4.657     0.200
    15.568     5.148     0.200
    18.168     3.711     0.200
    62.512     2.006     0.200
    68.505     6.597     0.200
    73.848     1.019     0.200
    74.780     0.387     0.200
    76.741     1.775     0.200
    76.741     1.800     0.200
    78.239     0.464     0.200
    78.626     2.288     0.200
    80.825     1.052     0.200
    84.335     2.509     0.200
    89.868    -3.308     0.200
    91.006     0.364     0.200
    91.146     3.000     0.200
    91.594     1.382     0.200
    92.085    -2.209     0.200
    94.143     2.888     0.200
    94.347     2.371     0.200
    94.362     2.703     0.200
    94.397     4.539     0.200
    94.597    -0.378     0.200
    95.676     1.978     0.200
    95.779     1.512     0.200
    15.270     5.024     0.200
    37.086     3.239     0.200
    94.588    -0.893     0.200
    14.742     4.211     0.200
    18.450     0.237     0.200
    18.525     0.507     0.200
    18.680    -0.311     0.200
    18.802    -0.551     0.200
    18.802     0.457     0.200
    19.000     0.320     0.200
    19.000     0.664     0.200
    19.138     0.427     0.200
    19.138     1.048     0.200
    19.374    -1.336     0.200
    19.454     0.134     0.200
    19.559     0.542     0.200
    19.615     0.142     0.200
    19.615     0.857     0.200
    19.760     0.021     0.200
    20.023     0.325     0.200
    20.060     0.844     0.200
    20.312    -0.253     0.200
    20.458     0.735     0.200
    20.503    -0.852     0.200
    20.806     0.358     0.200
    20.851    -0.855     0.200
    20.863    -0.264     0.200
    20.935     1.850     0.200
    20.935     0.135     0.200
    20.994     0.161     0.200
    20.994     1.438     0.200
    21.039     0.520     0.200
    21.099    -0.433     0.200
    21.100     0.383     0.200
    21.221    -0.654     0.200
    21.269    -0.864     0.200
    21.269     0.011     0.200
    21.270    -0.628     0.200
    21.308    -0.468     0.200
    21.347     0.190     0.200
    21.366     0.953     0.200
    21.366     0.539     0.200
    21.431    -0.670     0.200
    21.477     0.628     0.200
    21.519     0.784     0.200
    21.574     0.428     0.200
    21.575     1.054     0.200
    21.639    -0.319     0.200
    21.628     0.491     0.200
    21.642     0.187     0.200
    21.667     0.441     0.200
    21.749     0.925     0.200
    21.804     0.221     0.200
    21.804     0.373     0.200
    21.874    -1.172     0.200
    21.963     2.490     0.200
    21.985     1.950     0.200
    22.167     1.084     0.200
    22.198     0.808     0.200
    22.225     1.497     0.200
    22.220     0.016     0.200
    22.240    -0.098     0.200
    22.356    -0.941     0.200
    22.412    -1.821     0.200
    22.433     0.802     0.200
    22.433    -0.089     0.200
    22.442    -0.093     0.200
    22.441     0.859     0.200
    22.483     0.349     0.200
    22.526     0.312     0.200
    22.563     0.634     0.200
    22.567     0.838     0.200
    22.566     0.021     0.200
    22.566     0.611     0.200
    22.594     0.655     0.200
    22.650    -0.333     0.200
    22.712    -1.247     0.200
    22.751    -0.198     0.200
    22.751     0.080     0.200
    22.752    -0.400     0.200
    22.861     0.119     0.200
    22.853     0.636     0.200
    22.902     0.137     0.200
    22.988    -0.931     0.200
    23.018    -0.341     0.200
    23.107    -0.780     0.200
    23.113    -1.700     0.200
    23.119    -2.039     0.200
    23.153    -0.316     0.200
    23.159    -1.406     0.200
    23.168     0.835     0.200
    23.281     1.247     0.200
    23.341    -0.245     0.200
    23.401    -1.933     0.200
    23.419     0.112     0.200
    23.463     1.507     0.200
    23.465     0.392     0.200
    23.535     0.502     0.200
    23.553     2.218     0.200
    23.526    -1.636     0.200
    23.526    -0.714     0.200
    23.614    -2.189     0.200
    23.614    -0.657     0.200
    23.633    -1.737     0.200
    23.656    -3.409     0.200
    23.652    -1.463     0.200
    23.708    -1.138     0.200
    23.769     0.492     0.200
    23.794     0.212     0.200
    23.820    -1.616     0.200
    23.820     0.228     0.200
    23.860    -0.691     0.200
    23.885    -1.608     0.200
    24.048     0.886     0.200
    24.065     0.911     0.200
    24.185    -0.479     0.200
    24.216    -0.931     0.200
    24.343    -1.141     0.200
    24.382    -1.832     0.200
    24.381    -1.614     0.200
    24.409     0.890     0.200
    24.457    -1.615     0.200
    24.509    -1.778     0.200
    24.611     0.686     0.200
    24.649    -0.032     0.200
    24.660     0.191     0.200
    24.720    -0.479     0.200
    24.752     2.009     0.200
    24.769     2.010     0.200
    24.856     2.053     0.200
    24.957     0.880     0.200
    24.966     0.657     0.200
    24.975     0.893     0.200
    25.019     1.092     0.200
    25.011    -0.428     0.200
    25.079     1.335     0.200
    25.201    -1.632     0.200
    25.378     2.972     0.200
    25.441    -1.869     0.200
    25.467    -1.377     0.200
    25.501    -2.091     0.200
    25.529     0.429     0.200
    25.576     1.310     0.200
    25.727    -2.770     0.200
    25.860    -0.732     0.200
    26.001     0.399     0.200
    26.080     3.377     0.200
    26.101    -0.912     0.200
    26.205    -0.713     0.200
    26.307    -0.738     0.200
    26.391     0.158     0.200
    26.457     1.303     0.200
    26.465     0.385     0.200
    26.579    -0.970     0.200
    26.645     1.069     0.200
    26.680     0.897     0.200
    26.715    -0.302     0.200
    26.722    -2.304     0.200
    26.841    -1.670     0.200
    26.950     1.078     0.200
    26.976     0.827     0.200
    27.016    -0.243     0.200
    27.481     1.292     0.200
    27.716    -0.295     0.200
    27.716     0.373     0.200
    27.848     1.958     0.200
    28.016    -0.964     0.200
    28.711    -1.436     0.200
    28.991     1.492     0.200
    29.021     1.891     0.200
    29.166     1.243     0.200
    29.326     0.330     0.200
    29.517    -0.120     0.200
    29.816     0.852     0.200
    29.816     1.000     0.200
    30.315     0.760     0.200
    30.761     1.200     0.200
    31.579     0.952     0.200
    32.081     0.269     0.200
    32.161     0.705     0.200
    32.818    -0.866     0.200
    32.864     2.486     0.200
    32.895    -0.443     0.200
    33.700     0.060     0.200
    34.017    -0.058     0.200
    34.419     0.104     0.200
    34.732     1.009     0.200
    35.025     1.097     0.200
    35.897    -0.539     0.200
    36.149    -0.349     0.200
    36.124    -0.482     0.200
    36.182     0.347     0.200
    36.359     2.037     0.200
    39.329    -0.510     0.200
    39.847     0.656     0.200
    54.584     2.156     0.200
    54.584     4.926     0.200
    61.247     4.673     0.200
    61.247     3.017     0.200
    63.090     5.809     0.200
    65.742     0.319     0.200
    65.742     3.858     0.200
    72.940     5.608     0.200
    77.772     5.234     0.200
    80.585     5.854     0.200
    81.488     3.093     0.200
    83.937     4.109     0.200
    84.589     2.596     0.200
    85.295     6.712     0.200
    88.151     6.705     0.200
    88.740     4.028     0.200
    89.978     6.223     0.200
    90.311     3.973     0.200
    90.843     4.997     0.200
    90.843     1.657     0.200
    90.844     4.690     0.200
    93.768     0.375     0.200
    95.082    -0.110     0.200
    95.082     4.050     0.200
    96.511     0.741     0.200
    29.161    -0.285     0.200
    14.210    10.079     0.200
    27.048     0.599     0.200
    21.138     0.598     0.200
    27.112    -0.114     0.200
    15.100     3.509     0.200
    22.415     0.886     0.200
    36.634     1.082     0.200
    36.922     1.953     0.200
    15.124     6.681     0.200
    36.935     0.790     0.200
    14.285     5.026     0.200
    14.285     7.190     0.200
    15.242     5.044     0.200
    19.414     0.497     0.200
    19.462    -1.119     0.200
    19.524    -0.528     0.200
    19.697    -0.485     0.200
    19.959    -0.910     0.200
    20.770    -0.515     0.200
    21.259    -0.794     0.200
    21.259     1.035     0.200
    22.418     1.760     0.200
    22.418     0.401     0.200
    22.685     0.614     0.200
    26.012     2.262     0.200
    28.584     0.430     0.200
    35.675     1.545     0.200
    35.809     1.493     0.200
    37.348     0.962     0.200
    37.348     0.861     0.200
    38.267     1.380     0.200
    93.141     0.568     0.200
    93.196     0.681     0.200
    14.814     4.028     0.200
    15.022     3.850     0.200
    16.400     3.224     0.200
    16.656     1.851     0.200
    17.884     1.598     0.200
    17.884     2.047     0.200
    17.988     1.230     0.200
    18.557     0.646     0.200
    18.800     0.550     0.200
    19.185     0.891     0.200
    19.272     0.854     0.200
    19.610     1.253     0.200
    19.610     0.396     0.200
    19.788     1.340     0.200
    20.021     0.689     0.200
    20.058     0.968     0.200
    20.058     0.388     0.200
    20.164    -0.134     0.200
    20.507     1.714     0.200
    20.932    -0.292     0.200
    20.943     0.472     0.200
    21.410     1.508     0.200
    21.410     0.711     0.200
    21.485     1.722     0.200
    21.522     0.696     0.200
    21.661     1.102     0.200
    21.811     1.254     0.200
    22.383    -1.443     0.200
    22.429     1.230     0.200
    22.587    -1.663     0.200
    22.614     2.418     0.200
    22.614    -0.476     0.200
    22.621     0.746     0.200
    22.763    -0.310     0.200
    23.623    -0.753     0.200
    23.689     0.125     0.200
    23.691    -2.064     0.200
    23.838     0.173     0.200
    24.086    -0.694     0.200
    24.396     0.422     0.200
    24.603     0.820     0.200
    24.603     0.209     0.200
    24.748     0.890     0.200
    24.917     0.940     0.200
    24.903     0.335     0.200
    25.236     0.453     0.200
    25.324     1.973     0.200
    25.367     1.607     0.200
    25.456     1.229     0.200
    25.517    -0.398     0.200
    25.726    -0.003     0.200
    25.859     0.033     0.200
    25.858     0.192     0.200
    26.140     0.727     0.200
    26.348     0.699     0.200
    26.458    -0.147     0.200
    26.478    -0.551     0.200
    26.615     2.658     0.200
    26.615     2.288     0.200
    26.913    -0.036     0.200
    26.938     1.921     0.200
    27.013    -0.728     0.200
    27.219    -0.776     0.200
    27.466     0.344     0.200
    27.515     0.878     0.200
    27.743    -1.099     0.200
    28.140    -0.024     0.200
    28.855     1.857     0.200
    28.869     0.320     0.200
    28.879     0.543     0.200
    28.993     0.125     0.200
    29.091     1.892     0.200
    29.115    -0.032     0.200
    29.179     2.164     0.200
    29.343    -0.220     0.200
    29.522    -0.942     0.200
    29.765    -0.482     0.200
    29.905     1.289     0.200
    29.906     0.077     0.200
    30.130     1.145     0.200
    30.182    -0.680     0.200
    30.232    -0.403     0.200
    30.297    -2.295     0.200
    30.458    -3.220     0.200
    30.625     0.710     0.200
    30.669     0.923     0.200
    30.699     0.013     0.200
    30.754     1.262     0.200
    30.827     1.910     0.200
    30.827     1.004     0.200
    30.906     1.345     0.200
    30.954     0.254     0.200
    30.969    -1.404     0.200
    30.972     0.764     0.200
    31.027    -1.070     0.200
    31.375    -1.604     0.200
    31.416    -0.905     0.200
    31.536     1.327     0.200
    31.662    -1.469     0.200
    31.758    -1.833     0.200
    31.873    -1.234     0.200
    31.877    -0.220     0.200
    31.913     0.451     0.200
    31.962    -0.237     0.200
    32.254    -0.441     0.200
    32.653    -1.564     0.200
    32.775    -0.305     0.200
    32.868    -1.179     0.200
    32.882    -1.038     0.200
    33.023     0.554     0.200
    33.465    -1.767     0.200
    33.512    -1.049     0.200
    33.653    -0.339     0.200
    33.773    -0.862     0.200
    33.848    -1.967     0.200
    33.869    -2.514     0.200
    34.040    -2.133     0.200
    34.216    -2.030     0.200
    34.306    -2.190     0.200
    34.354    -1.112     0.200
    34.417     0.779     0.200
    34.434    -0.716     0.200
    34.494    -0.942     0.200
    34.468    -0.343     0.200
    34.483    -1.076     0.200
    34.580    -0.542     0.200
    34.623     0.448     0.200
    34.581     0.004     0.200
    34.641    -0.415     0.200
    34.694    -0.962     0.200
    34.719    -0.076     0.200
    34.744    -1.374     0.200
    34.925     0.604     0.200
    34.966     0.191     0.200
    34.981     0.838     0.200
    35.009    -1.167     0.200
    35.067    -0.238     0.200
    35.098    -0.207     0.200
    35.215    -1.511     0.200
    35.250    -1.306     0.200
    35.337    -1.311     0.200
    35.404    -0.098     0.200
    35.419     0.505     0.200
    35.468     0.741     0.200
    35.557     1.396     0.200
    35.612    -2.813     0.200
    35.623    -0.836     0.200
    35.661    -1.666     0.200
    35.860    -1.164     0.200
    35.919     0.093     0.200
    36.010    -0.785     0.200
    36.051     0.899     0.200
    36.167    -0.155     0.200
    36.196    -0.482     0.200
    36.208     0.236     0.200
    36.256    -1.310     0.200
    36.382    -0.498     0.200
    36.398     0.096     0.200
    36.407    -1.761     0.200
    36.431     1.928     0.200
    36.618    -0.842     0.200
    36.629    -0.022     0.200
    36.666     0.189     0.200
    36.781     0.671     0.200
    36.799    -2.666     0.200
    36.800     2.495     0.200
    36.803     0.023     0.200
    36.832    -0.307     0.200
    36.840    -1.391     0.200
    36.869    -1.480     0.200
    36.968     2.265     0.200
    36.995     0.970     0.200
    36.995    -1.055     0.200
    37.015     1.540     0.200
    37.015    -0.190     0.200
    37.286    -0.022     0.200
    37.312    -1.465     0.200
    37.315     0.289     0.200
    37.316     0.548     0.200
    37.316    -0.012     0.200
    37.421    -0.930     0.200
    37.458     0.697     0.200
    37.474     0.591     0.200
    37.477    -1.065     0.200
    37.644     0.468     0.200
    37.647    -0.214     0.200
    37.805    -0.459     0.200
    37.825    -0.316     0.200
    37.824    -0.376     0.200
    37.969    -0.208     0.200
    37.981    -0.241     0.200
    38.327    -0.059     0.200
    38.487     0.934     0.200
    38.494     0.610     0.200
    38.886    -0.546     0.200
    38.893    -1.144     0.200
    38.970    -0.697     0.200
    39.113     0.105     0.200
    39.402     0.687     0.200
    39.778    -0.492     0.200
    39.920     0.073     0.200
    40.537    -1.684     0.200
    41.810    -2.654     0.200
    42.651     1.720     0.200
    42.651     1.255     0.200
    42.945    -1.082     0.200
    43.519    -1.671     0.200
    43.545     0.974     0.200
    43.545     0.432     0.200
    44.317     0.718     0.200
    45.319     0.056     0.200
    45.564     1.054     0.200
    45.603    -0.210     0.200
    45.655     3.235     0.200
    46.467     2.618     0.200
    46.613     5.329     0.200
    46.904     4.014     0.200
    46.993     0.424     0.200
    47.371     2.303     0.200
    47.400    -4.676     0.200
    47.479    -4.333     0.200
    47.517     0.190     0.200
    48.131     4.110     0.200
    48.229     1.426     0.200
    48.384     3.095     0.200
    48.384     2.156     0.200
    48.653     1.059     0.200
    48.730     0.466     0.200
    48.981     4.318     0.200
    49.323     2.668     0.200
    50.286     0.896     0.200
    51.962     3.460     0.200
    54.513     2.019     0.200
    54.655     1.866     0.200
    54.869     1.635     0.200
    54.869     1.825     0.200
    58.552     4.954     0.200
    59.491     0.044     0.200
    59.792     2.224     0.200
    61.699     0.865     0.200
    61.699     0.891     0.200
    61.699     0.185     0.200
    63.159     4.950     0.200
    65.193     3.636     0.200
    65.815     3.202     0.200
    65.815     0.003     0.200
    67.599     1.199     0.200
    68.239    -0.912     0.200
    69.220    -0.205     0.200
    70.291     0.085     0.200
    71.081     4.695     0.200
    73.626     0.868     0.200
    74.854     1.551     0.200
    76.011     0.722     0.200
    76.011     0.088     0.200
    76.011     0.197     0.200
    76.660     0.510     0.200
    76.672     2.004     0.200
    76.759     0.054     0.200
    77.134     2.044     0.200
    77.223     0.943     0.200
    77.838     0.728     0.200
    77.838     0.103     0.200
    78.165     0.881     0.200
    78.801    -1.053     0.200
    80.665     0.751     0.200
    80.789    -0.633     0.200
    80.789     0.098     0.200
    80.789     0.823     0.200
    80.789    -0.062     0.200
    81.280     1.677     0.200
    81.546    -0.062     0.200
    81.545     0.286     0.200
    81.545    -0.638     0.200
    81.546    -0.063     0.200
    81.841    -0.548     0.200
    82.327     0.962     0.200
    84.003     4.802     0.200
    84.144     5.385     0.200
    84.655    -2.404     0.200
    85.087     1.370     0.200
    85.153     1.600     0.200
    85.349     6.781     0.200
    85.737     1.627     0.200
    85.956     1.575     0.200
    86.136     1.686     0.200
    86.505     5.648     0.200
    86.672     6.152     0.200
    86.810     2.608     0.200
    87.540     1.751     0.200
    87.560     5.129     0.200
    87.639     4.920     0.200
    88.804     2.454     0.200
    89.100     6.564     0.200
    89.351     6.586     0.200
    89.444     1.549     0.200
    90.163     1.590     0.200
    90.375     0.601     0.200
    90.381     5.492     0.200
    90.381     1.373     0.200
    90.441     1.644     0.200
    90.903     2.930     0.200
    90.903     1.043     0.200
    91.039    -0.777     0.200
    91.097     0.745     0.200
    93.397     4.738     0.200
    93.397     1.212     0.200
    94.530     3.282     0.200
    94.928     8.584     0.200
    95.155     0.545     0.200
    95.258     1.039     0.200
    96.573     2.587     0.200
    98.364    -0.092     0.200
    98.585    -2.682     0.200
    27.240     3.024     0.200
    37.091     1.808     0.200
    17.275     1.490     0.200
    36.777     1.480     0.200
    14.984     5.044     0.200
    14.974     3.703     0.200
    20.372    -1.943     0.200
    22.007    -2.626     0.200
    15.308     3.870     0.200
    29.379    -1.075     0.200
    36.687     1.228     0.200
    22.170     1.054     0.200
    36.029     1.483     0.200
    36.024     1.406     0.200
    14.779     3.801     0.200
    15.477     3.640     0.200
    15.709     3.448     0.200
    16.354     2.828     0.200
    16.475     3.673     0.200
    17.398     1.228     0.200
    17.660     1.596     0.200
    17.725     2.151     0.200
    17.725     1.519     0.200
    18.787     0.662     0.200
    18.983    -1.218     0.200
    19.305     0.478     0.200
    19.997    -0.894     0.200
    20.449     1.274     0.200
    21.296     1.695     0.200
    21.595     1.752     0.200
    21.595     2.303     0.200
    21.821     1.002     0.200
    21.889     1.307     0.200
    22.738     2.108     0.200
    22.780     0.227     0.200
    23.037     1.853     0.200
    23.259     0.773     0.200
    23.606    -0.700     0.200
    23.678     1.318     0.200
    24.600     0.139     0.200
    29.074     1.862     0.200
    30.569     1.163     0.200
    30.574     0.567     0.200
    30.643     1.744     0.200
    31.520     2.668     0.200
    32.078    -0.219     0.200
    32.078     2.841     0.200
    32.538     1.024     0.200
    32.989     2.784     0.200
    33.001     1.842     0.200
    33.001     3.188     0.200
    33.353     1.844     0.200
    33.353     3.169     0.200
    33.366     3.347     0.200
    33.648    -0.491     0.200
    33.648     2.756     0.200
    33.924     2.353     0.200
    33.940     1.591     0.200
    33.940     2.532     0.200
    34.552     1.906     0.200
    34.679     0.629     0.200
    34.679     2.307     0.200
    34.842     2.025     0.200
    34.842     2.689     0.200
    34.918     0.619     0.200
    34.918     2.510     0.200
    34.917     2.658     0.200
    34.994     0.730     0.200
    35.030     2.297     0.200
    35.116     2.867     0.200
    35.207     2.089     0.200
    35.265     2.264     0.200
    35.450     2.837     0.200
    35.621     3.041     0.200
    35.721     2.444     0.200
    35.726     1.477     0.200
    35.938     1.855     0.200
    36.051     1.837     0.200
    36.229     2.023     0.200
    36.289     2.335     0.200
    36.437     2.027     0.200
    36.484     0.631     0.200
    36.596     1.979     0.200
    36.623     1.986     0.200
    37.062     3.194     0.200
    37.069     1.992     0.200
    37.159     1.784     0.200
    37.248     1.176     0.200
    37.339     2.172     0.200
    37.468     1.751     0.200
    37.516     1.972     0.200
    37.674     1.622     0.200
    37.674     1.967     0.200
    37.732     1.179     0.200
    37.814     1.069     0.200
    38.021     2.538     0.200
    38.134     1.520     0.200
    38.224     1.520     0.200
    38.312     1.759     0.200
    38.312     0.744     0.200
    38.438     1.531     0.200
    38.617     1.886     0.200
    38.743     1.063     0.200
    38.743     1.711     0.200
    38.745     0.930     0.200
    38.762     0.896     0.200
    38.788     2.096     0.200
    38.842     1.491     0.200
    38.873     1.302     0.200
    38.957     0.687     0.200
    39.106     2.096     0.200
    39.121     0.895     0.200
    39.144     1.672     0.200
    39.333     2.466     0.200
    39.394     2.279     0.200
    39.502     1.876     0.200
    39.735     0.302     0.200
    39.843     1.050     0.200
    39.891     1.462     0.200
    41.065     1.416     0.200
    41.242     1.410     0.200
    41.390     2.190     0.200
    48.815     0.738     0.200
    54.958     2.579     0.200
    64.552     1.201     0.200
    65.687     1.102     0.200
    70.978     1.490     0.200
    76.772     2.367     0.200
    80.733     1.814     0.200
    82.037     1.820     0.200
    93.633    -2.794     0.200
    93.636     2.109     0.200
    36.964     1.552     0.200
    37.223     1.716     0.200
    20.777     0.082     0.200
    22.956    -0.224     0.200
    26.627    -0.454     0.200
    28.535    -0.128     0.200
    34.659    -0.616     0.200
    36.045     0.687     0.200
    36.045     1.308     0.200
    37.520    -1.201     0.200
    38.021    -0.190     0.200
    40.159    -0.327     0.200
    54.238     0.423     0.200
    55.072    -2.034     0.200
    69.943     0.063     0.200
    36.193     3.443     0.200
    16.271     4.676     0.200
    19.038     2.445     0.200
    21.409     2.891     0.200
    22.608    -0.120     0.200
    22.608     3.005     0.200
    23.661     5.257     0.200
    24.251     3.485     0.200
    24.842     3.687     0.200
    25.309     3.477     0.200
    25.376     3.223     0.200
    25.397     3.002     0.200
    26.357     3.561     0.200
    26.558     3.339     0.200
    27.110     3.231     0.200
    27.566     3.406     0.200
    27.598     2.819     0.200
    27.636     2.275     0.200
    28.486     1.670     0.200
    28.798     2.010     0.200
    28.820     2.333     0.200
    29.048     0.576     0.200
    29.061     3.275     0.200
    29.119     2.878     0.200
    29.706     2.544     0.200
    29.836     2.522     0.200
    30.080     2.908     0.200
    30.123     2.861     0.200
    30.468     3.059     0.200
    30.566     2.856     0.200
    30.844     2.787     0.200
    30.912     3.045     0.200
    30.911     2.728     0.200
    30.968     3.279     0.200
    31.316     3.633     0.200
    31.337     3.698     0.200
    31.475     4.019     0.200
    31.601     3.350     0.200
    31.818     3.472     0.200
    31.852     3.100     0.200
    31.900     3.312     0.200
    32.149     3.788     0.200
    32.177     3.070     0.200
    32.194     2.637     0.200
    32.282     3.067     0.200
    32.466     5.265     0.200
    32.714     4.417     0.200
    32.808     4.424     0.200
    32.960     4.508     0.200
    33.062     5.112     0.200
    33.072     4.860     0.200
    33.089     4.264     0.200
    33.363     4.006     0.200
    33.404     3.801     0.200
    33.408     4.074     0.200
    33.451     4.606     0.200
    33.593     3.811     0.200
    33.741     4.617     0.200
    33.785     3.664     0.200
    33.976     3.702     0.200
    34.023     4.236     0.200
    34.080     3.817     0.200
    34.155     3.599     0.200
    34.243     3.397     0.200
    34.292     3.294     0.200
    34.352     3.227     0.200
    34.417     3.671     0.200
    34.514     3.044     0.200
    34.523     3.440     0.200
    34.516     3.561     0.200
    34.632     3.610     0.200
    34.654     2.939     0.200
    34.656     3.273     0.200
    34.679     2.196     0.200
    34.922     2.833     0.200
    34.945     3.131     0.200
    34.979     3.070     0.200
    34.982     2.946     0.200
    35.007     1.915     0.200
    35.022     2.105     0.200
    35.042     1.713     0.200
    35.069     1.492     0.200
    35.153     2.680     0.200
    35.260     2.267     0.200
    35.343     2.116     0.200
    35.358     1.767     0.200
    35.403     2.844     0.200
    35.448     2.725     0.200
    35.478     3.287     0.200
    35.494     3.104     0.200
    35.521     3.495     0.200
    35.584     3.185     0.200
    35.599     3.339     0.200
    35.691     3.367     0.200
    35.776     2.926     0.200
    35.800     2.896     0.200
    35.893     3.269     0.200
    35.947     2.845     0.200
    35.953     2.697     0.200
    35.987     3.751     0.200
    35.987     3.643     0.200
    36.000     3.587     0.200
    36.132     3.366     0.200
    36.136     3.442     0.200
    36.159     3.611     0.200
    36.167     3.528     0.200
    36.202     0.492     0.200
    36.202     2.492     0.200
    36.202     4.641     0.200
    36.321     3.087     0.200
    36.333     3.152     0.200
    36.342     2.914     0.200
    36.371     0.951     0.200
    36.496     2.997     0.200
    36.506     3.325     0.200
    36.553     3.023     0.200
    36.604     3.293     0.200
    36.717     3.481     0.200
    36.735     3.265     0.200
    36.739     3.909     0.200
    36.739     2.759     0.200
    36.739     6.019     0.200
    36.758     2.877     0.200
    36.764     2.503     0.200
    36.780     3.074     0.200
    36.804    -0.069     0.200
    36.899    -0.370     0.200
    36.934     0.898     0.200
    36.953     2.019     0.200
    37.024     1.845     0.200
    37.126     1.825     0.200
    37.206     1.132     0.200
    37.248     0.623     0.200
    37.250     0.722     0.200
    37.254     1.334     0.200
    37.361     0.024     0.200
    37.398     1.107     0.200
    37.406    -0.137     0.200
    37.418     1.455     0.200
    37.456     1.149     0.200
    37.523     1.705     0.200
    37.581     1.177     0.200
    37.585     1.425     0.200
    37.586     2.479     0.200
    37.601     1.469     0.200
    37.621     1.623     0.200
    37.740     1.710     0.200
    37.743     2.175     0.200
    37.763     1.780     0.200
    37.793     1.567     0.200
    37.909     1.541     0.200
    37.915     1.095     0.200
    37.919     1.173     0.200
    37.991     1.230     0.200
    38.086     0.981     0.200
    38.256     1.705     0.200
    38.266     1.516     0.200
    38.340     1.595     0.200
    38.343     1.210     0.200
    38.381     1.221     0.200
    38.412     1.271     0.200
    38.422     1.004     0.200
    38.467     1.193     0.200
    38.523     1.055     0.200
    38.616     0.384     0.200
    38.651     0.260     0.200
    38.743     0.995     0.200
    38.832     1.264     0.200
    38.838     1.204     0.200
    38.848     1.020     0.200
    38.885     1.367     0.200
    38.895     0.980     0.200
    38.903     1.057     0.200
    38.961     1.564     0.200
    38.981     1.122     0.200
    39.053     1.498     0.200
    39.097     0.735     0.200
    39.175     0.928     0.200
    39.221     1.736     0.200
    39.231     0.118     0.200
    39.237     0.647     0.200
    39.267     0.636     0.200
    39.377     0.735     0.200
    39.427     1.240     0.200
    39.464     1.026     0.200
    39.541     0.836     0.200
    39.574     1.714     0.200
    39.588     0.893     0.200
    39.708     1.371     0.200
    39.715     0.870     0.200
    39.813     0.777     0.200
    39.862     0.556     0.200
    39.871     0.965     0.200
    39.975     1.279     0.200
    39.987     0.978     0.200
    40.020     0.651     0.200
    40.037     0.893     0.200
    40.121    -0.143     0.200
    40.124    -0.084     0.200
    40.378    -0.263     0.200
    40.394    -0.887     0.200
    40.419    -0.031     0.200
    40.431     0.371     0.200
    40.464     0.298     0.200
    40.467     0.385     0.200
    40.470     0.086     0.200
    40.493     0.231     0.200
    40.523     0.692     0.200
    40.546     0.616     0.200
    40.613     0.393     0.200
    40.739     1.157     0.200
    40.930     0.702     0.200
    40.955     1.051     0.200
    41.156     0.707     0.200
    41.328     0.932     0.200
    41.471     1.385     0.200
    41.475     1.137     0.200
    41.614     1.385     0.200
    41.616     1.220     0.200
    41.666     1.365     0.200
    41.678     1.236     0.200
    41.825     1.087     0.200
    41.862     2.059     0.200
    41.868     1.143     0.200
    42.018     1.146     0.200
    42.056     1.339     0.200
    42.143     0.432     0.200
    42.191     0.785     0.200
    42.407     0.996     0.200
    42.527     0.975     0.200
    42.653     1.665     0.200
    42.798     1.791     0.200
    42.845     1.340     0.200
    42.881     1.186     0.200
    42.977     1.550     0.200
    43.054     1.299     0.200
    43.129     1.942     0.200
    43.227     1.423     0.200
    43.374     1.411     0.200
    43.461     1.086     0.200
    43.484     0.846     0.200
    43.603     0.820     0.200
    43.775     0.830     0.200
    44.012     0.715     0.200
    44.396     0.690     0.200
    48.450     3.622     0.200
    48.680     4.760     0.200
    54.594     5.245     0.200
    54.592     3.898     0.200
    58.929     3.495     0.200
    61.252     4.760     0.200
    61.632     0.615     0.200
    63.093     4.809     0.200
    63.093     5.019     0.200
    65.756     3.374     0.200
    65.756     3.583     0.200
    71.018     4.036     0.200
    74.845     1.396     0.200
    75.959     0.196     0.200
    75.959     3.946     0.200
    78.144     1.950     0.200
    80.638     1.955     0.200
    81.478     2.705     0.200
    81.839     3.272     0.200
    82.856     7.155     0.200
    83.045     6.631     0.200
    83.128     6.094     0.200
    83.135     6.799     0.200
    83.425     2.360     0.200
    83.970     3.419     0.200
    84.620     0.515     0.200
    85.124     5.990     0.200
    85.152     2.738     0.200
    86.798     1.646     0.200
    87.134     5.849     0.200
    87.522     4.778     0.200
    88.162     5.228     0.200
    88.775     3.836     0.200
    88.777     2.507     0.200
    88.967     0.666     0.200
    89.039     5.492     0.200
    89.045     0.418     0.200
    90.373     3.551     0.200
    90.378     2.549     0.200
    90.880     0.043     0.200
    90.880     3.993     0.200
    90.880     3.293     0.200
    90.985     1.658     0.200
    91.628     4.526     0.200
    92.561     3.810     0.200
    92.980     3.876     0.200
    93.520     3.689     0.200
    93.623     4.215     0.200
    93.640     0.963     0.200
    93.771    -1.467     0.200
    95.102     4.126     0.200
    95.205     2.705     0.200
    96.505    -0.965     0.200
    18.352    -0.611     0.200
    18.445    -1.564     0.200
    18.548    -1.338     0.200
    19.073    -0.749     0.200
    19.142    -1.418     0.200
    19.978    -0.347     0.200
    20.279    -0.904     0.200
    21.064     1.103     0.200
    21.064     0.705     0.200
    21.384     0.462     0.200
    21.502    -0.804     0.200
    22.744     1.602     0.200
    22.744     0.829     0.200
    23.849     0.490     0.200
    24.833     1.263     0.200
    25.430     1.459     0.200
    25.961     1.339     0.200
    25.977     1.576     0.200
    27.235     1.034     0.200
    27.440     1.053     0.200
    27.533     1.410     0.200
    27.629     1.153     0.200
    28.134     0.858     0.200
    28.178     0.261     0.200
    28.196     0.753     0.200
    28.458     0.924     0.200
    29.057     1.055     0.200
    29.362     0.487     0.200
    29.397     0.239     0.200
    29.500     1.834     0.200
    29.500     1.045     0.200
    29.599     0.513     0.200
    29.700     0.780     0.200
    30.247     0.574     0.200
    30.261     0.191     0.200
    30.276     0.909     0.200
    30.416     0.197     0.200
    30.587     0.843     0.200
    30.697     0.308     0.200
    31.051     0.615     0.200
    31.144     0.986     0.200
    31.161     1.123     0.200
    31.210     1.169     0.200
    31.434     1.481     0.200
    31.473     1.777     0.200
    31.492     1.398     0.200
    31.541     1.641     0.200
    31.895     1.979     0.200
    31.923     1.596     0.200
    32.030     1.603     0.200
    32.067     1.573     0.200
    32.184     1.706     0.200
    32.386     1.603     0.200
    32.496     1.548     0.200
    32.722     1.688     0.200
    32.776     0.416     0.200
    32.776     0.725     0.200
    32.875     0.385     0.200
    33.174     0.872     0.200
    33.193     0.981     0.200
    33.304     1.169     0.200
    33.555     0.805     0.200
    33.626     1.086     0.200
    33.655     0.708     0.200
    33.688     0.440     0.200
    33.965     1.073     0.200
    33.966     0.755     0.200
    34.037     1.027     0.200
    34.172     0.911     0.200
    34.283     1.498     0.200
    34.381     0.880     0.200
    34.406     0.291     0.200
    34.625     0.259     0.200
    34.745     0.475     0.200
    34.848     0.718     0.200
    34.885     0.170     0.200
    34.967     0.201     0.200
    35.035    -0.497     0.200
    35.111     0.605     0.200
    35.125     0.652     0.200
    35.176     0.398     0.200
    35.229     0.480     0.200
    35.243     0.618     0.200
    35.256     0.375     0.200
    35.460     0.573     0.200
    35.502     0.551     0.200
    35.543    -0.928     0.200
    35.543    -0.256     0.200
    35.548    -0.456     0.200
    35.590    -1.200     0.200
    35.593    -0.244     0.200
    35.603    -0.542     0.200
    35.609     1.129     0.200
    35.747     0.129     0.200
    35.816     0.963     0.200
    35.816     0.080     0.200
    35.949    -0.207     0.200
    35.985    -0.026     0.200
    36.017     0.387     0.200
    36.024     0.645     0.200
    36.089     0.506     0.200
    36.157     0.180     0.200
    36.193     0.220     0.200
    36.264     0.492     0.200
    36.328     0.289     0.200
    36.381     0.812     0.200
    36.495    -0.515     0.200
    36.495     0.743     0.200
    36.564     0.378     0.200
    36.592     0.181     0.200
    36.655     0.196     0.200
    36.708     0.110     0.200
    36.720     0.785     0.200
    36.735     1.514     0.200
    36.735     0.850     0.200
    36.912     0.543     0.200
    36.944     0.594     0.200
    36.954     2.618     0.200
    36.954     0.407     0.200
    36.956     0.013     0.200
    37.058     0.356     0.200
    37.083     0.223     0.200
    37.166     0.349     0.200
    37.199     0.412     0.200
    37.236     0.519     0.200
    37.280     0.197     0.200
    37.293     0.214     0.200
    37.311     0.692     0.200
    37.323     0.675     0.200
    37.326     0.584     0.200
    37.339     0.369     0.200
    37.362     0.312     0.200
    37.386     0.838     0.200
    37.419     0.671     0.200
    37.522     0.742     0.200
    37.552     0.270     0.200
    37.568     0.293     0.200
    37.568     1.035     0.200
    37.692     1.115     0.200
    37.827     0.427     0.200
    37.847     0.723     0.200
    37.853     0.234     0.200
    37.860     0.488     0.200
    37.975    -0.026     0.200
    37.983     0.164     0.200
    37.997     0.060     0.200
    38.028    -0.206     0.200
    38.072     0.298     0.200
    38.071    -0.105     0.200
    38.071     0.778     0.200
    38.156    -0.517     0.200
    38.156     0.429     0.200
    38.158     0.748     0.200
    38.180     0.589     0.200
    38.186     0.847     0.200
    38.229     0.326     0.200
    38.351     0.836     0.200
    38.355     1.102     0.200
    38.354     0.745     0.200
    38.357     0.178     0.200
    38.490     0.499     0.200
    38.492     0.373     0.200
    38.518     0.790     0.200
    38.534     0.085     0.200
    38.653     0.619     0.200
    38.855     0.347     0.200
    38.866     0.295     0.200
    38.892     0.519     0.200
    38.946     0.530     0.200
    38.946     0.303     0.200
    38.998     0.374     0.200
    39.008     0.274     0.200
    39.008     0.891     0.200
    39.032     0.945     0.200
    39.035     0.619     0.200
    39.109     1.029     0.200
    39.187     0.932     0.200
    39.231     0.922     0.200
    39.332     0.303     0.200
    39.355     0.268     0.200
    39.421     0.780     0.200
    39.447     1.099     0.200
    39.480     0.881     0.200
    39.510     0.934     0.200
    39.525     0.766     0.200
    39.714     1.365     0.200
    39.745     1.479     0.200
    39.774     1.729     0.200
    39.812     0.889     0.200
    39.843     0.266     0.200
    39.877    -0.198     0.200
    39.990     0.119     0.200
    40.019     0.749     0.200
    40.036     0.439     0.200
    40.134     0.564     0.200
    40.157     0.449     0.200
    40.173     0.304     0.200
    40.263     0.852     0.200
    40.312    -0.068     0.200
    40.392    -0.041     0.200
    40.431     0.316     0.200
    40.476    -0.209     0.200
    40.581     0.385     0.200
    40.589     0.407     0.200
    40.602     0.175     0.200
    40.603     0.544     0.200
    40.696     0.187     0.200
    40.736     0.103     0.200
    40.948    -0.693     0.200
    40.948     1.432     0.200
    40.982     0.753     0.200
    41.003     0.211     0.200
    41.037     0.228     0.200
    41.064     0.747     0.200
    41.064     0.247     0.200
    41.091    -0.094     0.200
    41.109    -0.150     0.200
    41.136     0.354     0.200
    41.138    -0.545     0.200
    41.138     0.588     0.200
    41.199     0.594     0.200
    41.343     0.904     0.200
    41.510     1.739     0.200
    41.530     1.699     0.200
    41.534     2.212     0.200
    41.549     2.162     0.200
    41.745     1.824     0.200
    41.914     1.941     0.200
    42.052     2.052     0.200
    42.073     2.481     0.200
    42.189     2.289     0.200
    42.228     1.529     0.200
    42.258     2.143     0.200
    42.280     1.784     0.200
    42.435     1.824     0.200
    42.442     1.733     0.200
    42.447     1.477     0.200
    42.585     0.985     0.200
    42.585     1.828     0.200
    42.656     1.889     0.200
    42.774     2.367     0.200
    42.997     0.071     0.200
    42.997     1.438     0.200
    43.129     1.525     0.200
    43.245     1.314     0.200
    43.372     1.191     0.200
    43.372     2.129     0.200
    43.411     0.888     0.200
    43.486     1.510     0.200
    43.558     1.547     0.200
    43.654     1.850     0.200
    43.750     1.128     0.200
    43.813     0.422     0.200
    43.813     0.617     0.200
    43.965     1.404     0.200
    44.028     2.224     0.200
    44.073     2.205     0.200
    44.206     1.377     0.200
    44.362     2.076     0.200
    44.589     1.395     0.200
    44.857     1.129     0.200
    44.987     1.111     0.200
    44.987     1.705     0.200
    45.865     1.654     0.200
    62.253     1.261     0.200
    75.607     0.949     0.200
    76.478     2.751     0.200
    76.478     1.321     0.200
    77.003     1.283     0.200
    79.941     2.730     0.200
    83.196     0.843     0.200
    84.023     0.833     0.200
    91.525     4.153     0.200
    94.131     3.243     0.200
    94.387    -0.052     0.200
    95.730     3.660     0.200
    97.126    -0.028     0.200
    36.827     2.688     0.200
    15.190     5.421     0.200
    15.334     5.254     0.200
    17.353     2.129     0.200
    21.068    -0.260     0.200
    21.166     0.044     0.200
    21.236    -0.949     0.200
    22.337    -0.596     0.200
    23.009    -1.180     0.200
    23.656    -1.446     0.200
    23.921    -0.842     0.200
    25.996    -0.958     0.200
    28.705    -1.460     0.200
    36.530    -2.144     0.200
    36.836    -0.479     0.200
    36.836     0.919     0.200
    36.836     0.591     0.200
    38.429     0.337     0.200
    38.628     0.329     0.200
    39.819    -0.018     0.200
    41.385     0.817     0.200
    41.638     0.460     0.200
    43.698    -0.364     0.200
    62.259     0.921     0.200
    76.603     0.930     0.200
    78.100     0.751     0.200
    83.837     0.741     0.200
    86.785    -0.676     0.200
    94.341     0.277     0.200
    97.141    -0.978     0.200
    36.838    -0.044     0.200
    94.346     1.004     0.200
    26.442     2.785     0.200
    36.815     0.843     0.200
    94.324     0.618     0.200
    35.974     1.052     0.200
    15.237     5.160     0.200
    94.557    -3.039     0.200
    18.271     2.216     0.200
    18.372     2.979     0.200
    18.801     0.410     0.200
    19.805     0.231     0.200
    20.221     0.174     0.200
    20.420    -0.375     0.200
    21.158     1.456     0.200
    21.265     0.459     0.200
    21.265     2.449     0.200
    21.755     0.349     0.200
    21.953     0.314     0.200
    22.525     1.897     0.200
    22.525     0.507     0.200
    29.462     0.859     0.200
    33.251     0.993     0.200
    34.254     0.971     0.200
    34.589     0.359     0.200
    35.613     0.714     0.200
    37.049     3.320     0.200
    37.049    -0.030     0.200
    52.505     2.742     0.200
    59.678     1.293     0.200
    62.461     2.142     0.200
    62.461    -1.108     0.200
    73.843     2.842     0.200
    80.824     1.593     0.200
    80.824    -0.639     0.200
    91.565     3.669     0.200
    91.565     0.675     0.200
    94.551    -1.211     0.200
    95.416    -1.465     0.200
    95.753     2.681     0.200
    97.341    -1.106     0.200
    15.245     4.485     0.200
    16.583     1.758     0.200
    18.367     0.629     0.200
    27.470    -0.194     0.200
    15.224     5.288     0.200
    25.027    -1.170     0.200
    26.051    -0.866     0.200
    27.482    -0.293     0.200
    28.017    -0.327     0.200
    28.200    -1.325     0.200
    37.040     1.784     0.200
    94.543    -1.697     0.200
    97.949    -0.767     0.200
    15.229     4.011     0.200
    15.091     7.229     0.200
    94.439    -1.529     0.200
    22.882     2.903     0.200
    36.928     2.415     0.200
    36.929     2.450     0.200
    94.463    -1.854     0.200
    14.199     6.255     0.200
    15.140     6.398     0.200
    15.482     3.010     0.200
    15.482     7.022     0.200
    18.221     1.962     0.200
    18.804    -3.547     0.200
    19.552    -3.478     0.200
    19.630    -2.935     0.200
    20.129    -2.878     0.200
    20.342    -1.535     0.200
    20.401    -2.739     0.200
    20.423    -3.151     0.200
    21.065     1.776     0.200
    21.201    -2.231     0.200
    21.201     1.933     0.200
    21.201     1.511     0.200
    21.591    -2.585     0.200
    21.829    -2.707     0.200
    21.967    -2.164     0.200
    22.170    -3.072     0.200
    22.279     2.863     0.200
    22.303    -2.339     0.200
    22.456     1.998     0.200
    22.456     1.576     0.200
    22.456     1.373     0.200
    22.671    -1.594     0.200
    22.884    -1.761     0.200
    22.930    -1.849     0.200
    23.157    -2.081     0.200
    23.464    -1.049     0.200
    23.619    -1.899     0.200
    23.619    -1.634     0.200
    23.619     1.186     0.200
    23.619     1.967     0.200
    24.741    -1.267     0.200
    25.031    -1.758     0.200
    25.069    -1.757     0.200
    25.122    -2.414     0.200
    26.172    -2.869     0.200
    28.177    -3.045     0.200
    28.405    -3.347     0.200
    28.606    -3.456     0.200
    28.685    -2.609     0.200
    29.039    -5.151     0.200
    29.368     2.217     0.200
    29.368     2.940     0.200
    29.437    -2.567     0.200
    29.610    -3.052     0.200
    31.073    -3.247     0.200
    31.261    -3.740     0.200
    31.515    -3.069     0.200
    32.229    -4.744     0.200
    32.369    -4.632     0.200
    32.420    -4.244     0.200
    32.628    -3.989     0.200
    33.163    -3.983     0.200
    33.469    -3.708     0.200
    33.545    -4.386     0.200
    33.628    -4.995     0.200
    33.767    -3.451     0.200
    34.092    -3.110     0.200
    34.259     2.039     0.200
    34.698    -3.177     0.200
    35.481    -3.161     0.200
    35.501     3.365     0.200
    35.688    -2.133     0.200
    36.453    -2.507     0.200
    36.673     3.441     0.200
    36.863    -3.292     0.200
    36.928     3.361     0.200
    36.943     2.737     0.200
    36.956     2.824     0.200
    36.956     3.624     0.200
    37.133     3.320     0.200
    37.160    -2.393     0.200
    37.233    -2.440     0.200
    37.273    -1.870     0.200
    37.328     3.768     0.200
    37.328     4.987     0.200
    37.364    -1.479     0.200
    37.381    -2.259     0.200
    37.382    -0.971     0.200
    37.404    -1.482     0.200
    37.532    -0.833     0.200
    37.532     3.238     0.200
    37.584    -1.220     0.200
    37.683    -0.833     0.200
    37.762    -1.605     0.200
    37.848    -1.214     0.200
    37.866    -1.343     0.200
    37.866     2.817     0.200
    37.866     3.317     0.200
    37.990    -1.871     0.200
    37.995    -1.605     0.200
    38.091    -1.477     0.200
    38.121    -1.345     0.200
    38.238    -0.569     0.200
    38.363    -0.042     0.200
    38.480    -0.962     0.200
    38.868    -0.700     0.200
    38.994    -0.967     0.200
    39.035    -1.344     0.200
    39.228    -1.740     0.200
    39.233    -0.821     0.200
    39.433    -0.699     0.200
    39.625    -0.807     0.200
    39.736    -1.084     0.200
    39.940    -0.434     0.200
    40.105    -0.298     0.200
    40.213    -1.208     0.200
    41.417    -0.818     0.200
    41.451    -1.434     0.200
    41.995    -1.610     0.200
    42.293    -2.252     0.200
    42.490    -1.609     0.200
    43.338    -1.112     0.200
    43.361    -1.067     0.200
    43.519    -1.123     0.200
    43.818    -1.333     0.200
    44.110    -1.578     0.200
    44.856     5.828     0.200
    44.910     0.297     0.200
    45.535     3.742     0.200
    45.723    -0.645     0.200
    46.738    -1.427     0.200
    46.772     1.397     0.200
    47.285     3.892     0.200
    47.385     2.616     0.200
    47.851    -0.758     0.200
    47.883    -0.948     0.200
    47.883     3.251     0.200
    47.883     0.431     0.200
    48.551     9.087     0.200
    48.605     2.077     0.200
    48.720     6.990     0.200
    48.911     8.725     0.200
    52.142     3.419     0.200
    52.741     1.973     0.200
    54.896     3.353     0.200
    54.896     2.708     0.200
    54.896     4.310     0.200
    54.896    -0.792     0.200
    55.225     4.900     0.200
    55.225     2.130     0.200
    55.418     0.132     0.200
    57.583     0.493     0.200
    59.591     1.432     0.200
    59.591     1.330     0.200
    59.862    -0.054     0.200
    59.856     2.811     0.200
    60.363     1.031     0.200
    61.924     2.752     0.200
    64.209     0.374     0.200
    65.367     5.112     0.200
    66.308     1.459     0.200
    66.308    -0.580     0.200
    67.237     2.938     0.200
    67.764     0.643     0.200
    68.518    -0.683     0.200
    68.731     0.227     0.200
    68.731     1.422     0.200
    69.112    -0.295     0.200
    69.558     0.094     0.200
    69.558     3.910     0.200
    69.593     0.360     0.200
    69.721     1.073     0.200
    69.949     0.498     0.200
    69.949     1.736     0.200
    70.553     0.753     0.200
    71.595     1.652     0.200
    71.654     2.639     0.200
    71.654     4.311     0.200
    71.654     6.241     0.200
    71.814     5.331     0.200
    71.814     0.855     0.200
    72.390     1.664     0.200
    72.390     1.332     0.200
    72.390     2.722     0.200
    72.881     0.753     0.200
    73.693     4.710     0.200
    74.240     0.754     0.200
    74.726     3.314     0.200
    75.155     1.050     0.200
    75.155     3.710     0.200
    75.271     3.344     0.200
    76.345     0.560     0.200
    76.401     2.086     0.200
    76.401    -0.222     0.200
    76.527     0.036     0.200
    76.584     0.561     0.200
    76.667     3.982     0.200
    76.687     0.302     0.200
    76.896     0.131     0.200
    76.908     1.220     0.200
    77.109     2.616     0.200
    77.434     0.635     0.200
    77.764    -0.662     0.200
    77.842     3.493     0.200
    77.872     0.877     0.200
    78.179    -0.517     0.200
    78.179     0.932     0.200
    78.208    -0.402     0.200
    78.494     5.296     0.200
    78.494     3.378     0.200
    78.924    -0.118     0.200
    79.024     1.156     0.200
    80.028     4.602     0.200
    80.504     5.507     0.200
    80.678     0.800     0.200
    80.739     0.564     0.200
    80.740     0.274     0.200
    80.828     4.780     0.200
    81.053    -0.261     0.200
    81.053     3.899     0.200
    81.053     0.618     0.200
    81.093     5.447     0.200
    81.122    -0.499     0.200
    81.122    -1.308     0.200
    81.468    -0.905     0.200
    81.597     5.967     0.200
    81.602     4.980     0.200
    81.221     7.036     0.200
    81.963     3.786     0.200
    82.004     1.628     0.200
    82.107     5.499     0.200
    82.265    -0.698     0.200
    82.266     3.498     0.200
    82.266     0.025     0.200
    82.728     4.287     0.200
    82.893     1.756     0.200
    82.971     6.438     0.200
    82.971     4.395     0.200
    83.056     3.782     0.200
    83.056     6.485     0.200
    83.059     4.466     0.200
    83.059     5.716     0.200
    83.264     5.132     0.200
    83.386     5.898     0.200
    83.640     3.715     0.200
    83.770     3.941     0.200
    83.856     0.180     0.200
    83.856     1.220     0.200
    84.150     2.168     0.200
    84.217    -0.471     0.200
    84.217     4.830     0.200
    84.466     3.187     0.200
    84.467     6.031     0.200
    84.686     5.953     0.200
    84.686     0.832     0.200
    84.686     5.597     0.200
    84.686     2.355     0.200
    84.686     6.054     0.200
    84.817     5.925     0.200
    84.966     3.955     0.200
    84.967     3.643     0.200
    84.967     2.944     0.200
    85.003     6.893     0.200
    85.012     0.185     0.200
    85.174     3.351     0.200
    85.174     3.003     0.200
    85.271     4.391     0.200
    85.271     5.688     0.200
    85.271     5.930     0.200
    85.791     4.829     0.200
    86.194     3.836     0.200
    86.505     8.309     0.200
    86.713     3.487     0.200
    86.713     4.510     0.200
    86.713     0.987     0.200
    86.830     0.576     0.200
    86.830     4.311     0.200
    87.197     4.477     0.200
    87.577    -0.907     0.200
    87.582     4.420     0.200
    87.716     1.669     0.200
    87.898     0.723     0.200
    88.082     5.785     0.200
    88.289     1.561     0.200
    88.339     3.494     0.200
    88.868     1.076     0.200
    88.951     2.641     0.200
    89.991     3.218     0.200
    90.671     1.946     0.200
    90.739     4.329     0.200
    90.780    -5.360     0.200
    90.928     4.927     0.200
    90.928     4.150     0.200
    91.470     4.587     0.200
    91.613     4.574     0.200
    91.764     7.177     0.200
    92.226     2.537     0.200
    92.695    -0.426     0.200
    93.111     4.753     0.200
    94.009     3.319     0.200
    94.027     4.513     0.200
    94.465    -1.073     0.200
    95.007     4.544     0.200
    95.329    -4.827     0.200
    95.555     0.441     0.200
    95.583     2.712     0.200
    95.658     4.422     0.200
    15.137     5.043     0.200
    36.953     3.930     0.200
    38.548     0.418     0.200
    39.937     1.709     0.200
    15.397     5.164     0.200
    15.611     4.183     0.200
    15.671     4.060     0.200
    15.812     4.833     0.200
    36.935     2.215     0.200
    15.080     7.793     0.200
    27.575     3.046     0.200
    36.892     0.926     0.200
    29.309     1.026     0.200
    36.890     0.504     0.200
    94.400    -2.842     0.200
    36.891     0.940     0.200
    15.196     5.004     0.200
    36.921     4.332     0.200
    14.775     5.965     0.200
    22.581     1.256     0.200
    29.052     1.072     0.200
    36.395     2.209     0.200
    19.849    -2.411     0.200
    21.348    -2.023     0.200
    23.891    -3.280     0.200
    29.207     3.863     0.200
    36.383     2.856     0.200
    37.201     0.516     0.200
    18.656    -0.468     0.200
    18.964    -0.468     0.200
    19.414    -0.363     0.200
    19.993    -0.243     0.200
    20.118    -0.235     0.200
    20.905    -0.007     0.200
    21.414    -0.297     0.200
    21.651    -0.785     0.200
    22.129    -0.341     0.200
    22.436    -0.456     0.200
    22.622     0.654     0.200
    22.622    -0.291     0.200
    23.365    -1.111     0.200
    23.608    -0.823     0.200
    24.739    -0.979     0.200
    29.119     0.104     0.200
    29.127     0.924     0.200
    29.127     0.413     0.200
    33.820    -0.577     0.200
    35.029     0.134     0.200
    36.299    -0.794     0.200
    36.479     1.873     0.200
    36.479    -0.103     0.200
    40.464     0.976     0.200
    61.752     3.819     0.200
    78.895     0.633     0.200
    80.689     1.674     0.200
    82.379     1.812     0.200
    90.925     0.473     0.200
    93.727     2.165     0.200
    95.301     0.647     0.200
    21.705     0.061     0.200
    22.881    -0.946     0.200
    22.889     0.497     0.200
    23.781     0.570     0.200
    29.159     1.234     0.200
    29.159     0.789     0.200
    36.338     1.602     0.200
    61.469     1.193     0.200
    78.742    -0.621     0.200
    15.090     4.757     0.200
    18.771    -1.352     0.200
    18.859    -0.653     0.200
    18.940    -1.228     0.200
    20.075    -1.433     0.200
    20.304    -0.778     0.200
    20.359    -1.114     0.200
    21.145     0.638     0.200
    22.399     1.096     0.200
    23.562    -0.510     0.200
    29.316     0.732     0.200
    34.263     0.774     0.200
    36.627     0.175     0.200
    36.918     2.177     0.200
    38.060    -1.374     0.200
    52.084    -1.605     0.200
    55.360     0.420     0.200
    59.535    -1.146     0.200
    62.361     1.585     0.200
    73.107     0.030     0.200
    73.907     0.957     0.200
    74.256    -0.298     0.200
    74.353    -1.260     0.200
    76.610     1.542     0.200
    79.345     0.873     0.200
    81.899    -0.793     0.200
    83.002    -0.002     0.200
    83.802     0.714     0.200
    84.159     0.872     0.200
    85.489     0.428     0.200
    86.772     0.221     0.200
    87.370    -1.956     0.200
    15.085     5.126     0.200
    18.335     0.495     0.200
    20.357     0.689     0.200
    21.141     0.497     0.200
    22.395     1.662     0.200
    23.557     0.492     0.200
    29.310     1.825     0.200
    34.266    -0.326     0.200
    35.254     0.693     0.200
    36.621     0.547     0.200
    36.912     1.518     0.200
    37.284     0.386     0.200
    59.529    -0.134     0.200
    59.576     0.033     0.200
    76.009     1.039     0.200
    78.001    -0.333     0.200
    79.339     0.498     0.200
    83.203     0.822     0.200
    86.768     1.077     0.200
    95.502     0.867     0.200
    15.108     5.303     0.200
    15.723     6.569     0.200
    17.068     3.950     0.200
    29.333     3.501     0.200
    33.704     0.468     0.200
    36.937     2.751     0.200
    29.389     0.337     0.200
    36.972     1.188     0.200
    79.398     1.542     0.200
    82.998    -2.295     0.200
    37.180     0.680     0.200
    16.911     1.285     0.200
    18.432    -1.052     0.200
    18.535    -1.150     0.200
    18.699    -1.449     0.200
    19.836    -0.366     0.200
    20.271     1.249     0.200
    21.371    -1.152     0.200
    21.490    -0.561     0.200
    21.558    -0.771     0.200
    22.077    -0.836     0.200
    22.270    -0.003     0.200
    22.496     0.356     0.200
    23.264    -0.782     0.200
    34.281     0.271     0.200
    36.952     0.172     0.200
    37.821    -0.336     0.200
    39.771     0.176     0.200
    41.532     0.193     0.200
    79.372     3.807     0.200
    34.161    -0.128     0.200
    39.928     0.462     0.200
    15.175     4.816     0.200
    15.236     6.000     0.200
    15.705     3.717     0.200
    16.568     1.664     0.200
    17.275     1.854     0.200
    17.704     1.868     0.200
    19.417     0.843     0.200
    20.111     1.082     0.200
    20.794     1.413     0.200
    20.911     0.872     0.200
    21.552     2.098     0.200
    22.523     1.075     0.200
    22.739    -0.767     0.200
    23.286     0.716     0.200
    24.670     0.459     0.200
    33.411     1.202     0.200
    40.313     0.912     0.200
    40.560     1.928     0.200
    41.705     1.031     0.200
    43.507     0.809     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
    99.670     2.397     0.200
   100.989     2.331     0.200
    99.851     2.105     0.200
   106.004     1.001     0.200
   106.714     3.344     0.200
   108.168    -0.217     0.200
   100.585     1.051     0.200
   100.068     1.274     0.200
   101.296    -1.584     0.200
   105.629    -1.746     0.200
   107.759    -0.515     0.200
   101.237    -1.110     0.200
   105.568    -2.464     0.200
   107.695    -0.818     0.200
   111.627    -1.196     0.200
   105.131    -1.324     0.200
   110.418     0.470     0.200
   100.626     1.331     0.200
   101.981     2.807     0.200
   106.333    -2.542     0.200
   112.462     0.212     0.200
   100.623     1.810     0.200
   100.851     2.200     0.200
   101.978     1.987     0.200
   106.331    -0.862     0.200
   112.460     1.389     0.200
   100.620     1.206     0.200
   101.980    -0.338     0.200
   106.333    -1.691     0.200
   100.624     2.164     0.200
   106.338    -0.740     0.200
   100.627     1.690     0.200
    99.940     1.851     0.200
   101.170    -0.519     0.200
   105.505    -0.986     0.200
   100.013     1.956     0.200
   100.653    -0.290     0.200
   104.807     3.339     0.200
   105.573     0.239     0.200
    99.955     3.653     0.200
   100.623     3.481     0.200
   100.885     1.716     0.200
   100.378     1.831     0.200
   101.016     1.797     0.200
   100.594     2.547     0.200
   100.590     1.269     0.200
   106.292    -1.377     0.200
   100.380     4.246     0.200
   100.496     3.430     0.200
   100.752     3.291     0.200
   101.140     0.370     0.200
   101.852     2.100     0.200
   112.343     0.164     0.200
   100.431     1.753     0.200
   125.906    -0.119     0.200
   125.911    -3.481     0.200
   126.674    -3.098     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    93.591     4.752     0.200
    99.393     1.851     0.200
    54.657    62.152     0.200
    71.083    25.079     0.200
    72.991    18.937     0.200
    76.524     8.969     0.200
    76.524    15.266     0.200
    81.577     9.353     0.200
    81.788     7.882     0.200
    85.795     8.995     0.200
    90.412     5.812     0.200
    98.398     4.856     0.200
    99.496     2.025     0.200
    97.386     1.379     0.200
    97.384     0.819     0.200
    97.644     0.648     0.200
    98.740     0.728     0.200
    97.382     1.497     0.200
    97.387     0.657     0.200
    98.922     0.514     0.200
    97.393     1.905     0.200
     0.981   499.186     0.200
     0.998   498.795     0.200
     1.025   498.548     0.200
     1.088   498.547     0.200
    28.584   190.656     0.200
    54.655    64.266     0.200
    71.081    22.794     0.200
    76.759     7.554     0.200
    81.778     6.413     0.200
    81.869     6.254     0.200
    81.944     6.041     0.200
    82.133     6.750     0.200
    82.205     4.392     0.200
    82.312     6.902     0.200
    82.864     6.592     0.200
    90.375     2.101     0.200
    98.364     1.309     0.200
    98.008     1.435     0.200
    71.654    19.440     0.200
    81.640     5.547     0.200
    81.700     5.333     0.200
    81.810     5.503     0.200
    82.728     5.978     0.200
    86.163     2.759     0.200
    86.424     4.931     0.200
    86.686     2.655     0.200
    86.752     3.764     0.200
    86.826     5.283     0.200
    87.339     2.937     0.200
    88.412     2.064     0.200
    88.701     1.658     0.200
    88.721     1.574     0.200
    98.800     4.478     0.200
    98.409     0.690     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
