#!/bin/bash
gmt begin salton5.43_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times salton5.43'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.720
    25.500   328.263
    26.000   332.796
    26.500   337.316
    27.000   341.824
    27.500   346.316
    28.000   350.788
    28.500   355.244
    29.000   359.689
    29.500   364.125
    30.000   368.554
    30.500   372.974
    31.000   377.388
    31.500   381.793
    32.000   386.190
    32.500   390.578
    33.000   394.955
    33.500   399.319
    34.000   403.669
    34.500   408.005
    35.000   412.325
    35.500   416.630
    36.000   420.921
    36.500   425.195
    37.000   429.455
    37.500   433.699
    38.000   437.927
    38.500   442.138
    39.000   446.333
    39.500   450.512
    40.000   454.673
    40.500   458.817
    41.000   462.944
    41.500   467.054
    42.000   471.147
    42.500   475.223
    43.000   479.281
    43.500   483.322
    44.000   487.345
    44.500   491.350
    45.000   495.338
    45.500   499.307
    46.000   503.259
    46.500   507.192
    47.000   511.107
    47.500   515.005
    48.000   518.884
    48.500   522.745
    49.000   526.588
    49.500   530.413
    50.000   534.219
    50.500   538.007
    51.000   541.777
    51.500   545.529
    52.000   549.262
    52.500   552.978
    53.000   556.676
    53.500   560.356
    54.000   564.018
    54.500   567.661
    55.000   571.286
    55.500   574.893
    56.000   578.481
    56.500   582.051
    57.000   585.602
    57.500   589.136
    58.000   592.651
    58.500   596.148
    59.000   599.627
    59.500   603.088
    60.000   606.530
    60.500   609.954
    61.000   613.359
    61.500   616.746
    62.000   620.115
    62.500   623.466
    63.000   626.798
    63.500   630.113
    64.000   633.410
    64.500   636.690
    65.000   639.951
    65.500   643.194
    66.000   646.419
    66.500   649.626
    67.000   652.816
    67.500   655.987
    68.000   659.139
    68.500   662.274
    69.000   665.391
    69.500   668.489
    70.000   671.569
    70.500   674.631
    71.000   677.675
    71.500   680.701
    72.000   683.708
    72.500   686.698
    73.000   689.669
    73.500   692.621
    74.000   695.555
    74.500   698.470
    75.000   701.366
    75.500   704.244
    76.000   707.104
    76.500   709.945
    77.000   712.768
    77.500   715.573
    78.000   718.360
    78.500   721.129
    79.000   723.880
    79.500   726.612
    80.000   729.326
    80.500   732.020
    81.000   734.696
    81.500   737.352
    82.000   739.988
    82.500   742.606
    83.000   745.206
    83.500   747.786
    84.000   750.347
    84.500   752.888
    85.000   755.408
    85.500   757.909
    86.000   760.390
    86.500   762.854
    87.000   765.301
    87.500   767.724
    88.000   770.112
    88.500   772.479
    89.000   774.833
    89.500   777.179
    90.000   779.516
    90.500   781.848
    91.000   784.172
    91.500   786.492
    92.000   788.807
    92.500   791.117
    93.000   793.424
    93.500   795.728
    94.000   798.028
    94.500   800.324
    95.000   802.614
    95.500   804.899
    96.000   807.177
    96.500   809.448
    97.000   811.714
    97.500   813.972
    98.000   816.224
    98.500   818.468
    99.000   820.704
    99.500   822.933
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1121.945
   116.000  1122.907
   116.500  1123.869
   117.000  1124.831
   117.500  1125.793
   118.000  1126.755
   118.500  1127.717
   119.000  1128.678
   119.500  1129.640
   120.000  1130.601
   120.500  1131.562
   121.000  1132.523
   121.500  1133.484
   122.000  1134.444
   122.500  1135.404
   123.000  1136.363
   123.500  1137.322
   124.000  1138.281
   124.500  1139.239
   125.000  1140.197
   125.500  1141.154
   126.000  1142.111
   126.500  1143.066
   127.000  1144.022
   127.500  1144.976
   128.000  1145.930
   128.500  1146.882
   129.000  1147.834
   129.500  1148.785
   130.000  1149.735
   130.500  1150.684
   131.000  1151.631
   131.500  1152.578
   132.000  1153.523
   132.500  1154.467
   133.000  1155.409
   133.500  1156.349
   134.000  1157.288
   134.500  1158.225
   135.000  1159.161
   135.500  1160.094
   136.000  1161.025
   136.500  1161.954
   137.000  1162.880
   137.500  1163.804
   138.000  1164.725
   138.500  1165.644
   139.000  1166.560
   139.500  1167.473
   140.000  1168.382
   140.500  1169.288
   141.000  1170.191
   141.500  1171.089
   142.000  1171.984
   142.500  1172.874
   143.000  1173.760
   143.500  1174.642
   144.000  1175.518
   144.500  1176.389
   145.000  1177.255
   145.500  1178.115
   146.000  1178.968
   146.500  1179.816
   147.000  1180.657
   147.500  1181.491
   148.000  1182.318
   148.500  1183.138
   149.000  1183.949
   149.500  1184.752
   150.000  1185.545
   150.500  1186.329
   151.000  1187.102
   151.500  1187.865
   152.000  1188.619
   152.500  1189.362
   153.000  1190.096
   153.500  1190.819
   154.000  1191.531
   154.500  1192.232
   155.000  1192.923
   155.500  1193.602
   156.000  1194.269
   156.500  1194.925
   157.000  1195.568
   157.500  1196.200
   158.000  1196.819
   158.500  1197.426
   159.000  1198.020
   159.500  1198.601
   160.000  1199.170
   160.500  1199.725
   161.000  1200.267
   161.500  1200.797
   162.000  1201.313
   162.500  1201.816
   163.000  1202.306
   163.500  1202.781
   164.000  1203.244
   164.500  1203.692
   165.000  1204.126
   165.500  1204.547
   166.000  1204.954
   166.500  1205.347
   167.000  1205.726
   167.500  1206.092
   168.000  1206.443
   168.500  1206.780
   169.000  1207.103
   169.500  1207.411
   170.000  1207.706
   170.500  1207.986
   171.000  1208.252
   171.500  1208.504
   172.000  1208.742
   172.500  1208.965
   173.000  1209.174
   173.500  1209.368
   174.000  1209.549
   174.500  1209.714
   175.000  1209.866
   175.500  1210.003
   176.000  1210.125
   176.500  1210.234
   177.000  1210.328
   177.500  1210.407
   178.000  1210.472
   178.500  1210.522
   179.000  1210.559
   179.500  1210.580
   180.000  1210.588
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   992.886
     1.000   992.895
     1.500   992.909
     2.000   992.928
     2.500   992.953
     3.000   992.984
     3.500   993.020
     4.000   993.062
     4.500   993.110
     5.000   993.163
     5.500   993.222
     6.000   993.286
     6.500   993.356
     7.000   993.431
     7.500   993.513
     8.000   993.599
     8.500   993.691
     9.000   993.789
     9.500   993.892
    10.000   994.001
    10.500   994.116
    11.000   994.236
    11.500   994.361
    12.000   994.492
    12.500   994.629
    13.000   994.771
    13.500   994.919
    14.000   995.072
    14.500   995.231
    15.000   995.395
    15.500   995.565
    16.000   995.740
    16.500   995.921
    17.000   996.107
    17.500   996.299
    18.000   996.496
    18.500   996.699
    19.000   996.907
    19.500   997.121
    20.000   997.340
    20.500   997.564
    21.000   997.794
    21.500   998.030
    22.000   998.270
    22.500   998.516
    23.000   998.768
    23.500   999.025
    24.000   999.288
    24.500   999.555
    25.000   999.828
    25.500  1000.107
    26.000  1000.391
    26.500  1000.680
    27.000  1000.974
    27.500  1001.274
    28.000  1001.579
    28.500  1001.890
    29.000  1002.205
    29.500  1002.526
    30.000  1002.853
    30.500  1003.184
    31.000  1003.521
    31.500  1003.863
    32.000  1004.210
    32.500  1004.562
    33.000  1004.920
    33.500  1005.283
    34.000  1005.651
    34.500  1006.024
    35.000  1006.402
    35.500  1006.785
    36.000  1007.174
    36.500  1007.567
    37.000  1007.966
    37.500  1008.370
    38.000  1008.779
    38.500  1009.193
    39.000  1009.612
    39.500  1010.036
    40.000  1010.465
    40.500  1010.899
    41.000  1011.338
    41.500  1011.782
    42.000  1012.230
    42.500  1012.684
    43.000  1013.143
    43.500  1013.607
    44.000  1014.075
    44.500  1014.549
    45.000  1015.027
    45.500  1015.510
    46.000  1015.998
    46.500  1016.491
    47.000  1016.989
    47.500  1017.491
    48.000  1017.998
    48.500  1018.510
    49.000  1019.027
    49.500  1019.548
    50.000  1020.074
    50.500  1020.605
    51.000  1021.141
    51.500  1021.681
    52.000  1022.225
    52.500  1022.775
    53.000  1023.329
    53.500  1023.887
    54.000  1024.450
    54.500  1025.018
    55.000  1025.590
    55.500  1026.167
    56.000  1026.748
    56.500  1027.333
    57.000  1027.924
    57.500  1028.518
    58.000  1029.117
    58.500  1029.720
    59.000  1030.328
    59.500  1030.940
    60.000  1031.557
    60.500  1032.177
    61.000  1032.802
    61.500  1033.432
    62.000  1034.065
    62.500  1034.703
    63.000  1035.345
    63.500  1035.991
    64.000  1036.642
    64.500  1037.296
    65.000  1037.955
    65.500  1038.618
    66.000  1039.285
    66.500  1039.956
    67.000  1040.631
    67.500  1041.310
    68.000  1041.993
    68.500  1042.680
    69.000  1043.372
    69.500  1044.067
    70.000  1044.766
    70.500  1045.469
    71.000  1046.176
    71.500  1046.886
    72.000  1047.601
    72.500  1048.319
    73.000  1049.041
    73.500  1049.767
    74.000  1050.497
    74.500  1051.231
    75.000  1051.968
    75.500  1052.709
    76.000  1053.453
    76.500  1054.202
    77.000  1054.954
    77.500  1055.709
    78.000  1056.468
    78.500  1057.231
    79.000  1057.997
    79.500  1058.767
    80.000  1059.540
    80.500  1060.317
    81.000  1061.097
    81.500  1061.881
    82.000  1062.668
    82.500  1063.458
    83.000  1064.252
    83.500  1065.049
    84.000  1065.849
    84.500  1066.653
    85.000  1067.460
    85.500  1068.271
    86.000  1069.084
    86.500  1069.901
    87.000  1070.721
    87.500  1071.544
    88.000  1072.370
    88.500  1073.199
    89.000  1074.031
    89.500  1074.867
    90.000  1075.705
    90.500  1076.547
    91.000  1077.391
    91.500  1078.239
    92.000  1079.089
    92.500  1079.943
    93.000  1080.799
    93.500  1081.658
    94.000  1082.520
    94.500  1083.385
    95.000  1084.252
    95.500  1085.123
    96.000  1085.996
    96.500  1086.872
    97.000  1087.750
    97.500  1088.632
    98.000  1089.516
    98.500  1090.402
    99.000  1091.291
    99.500  1092.183
   100.000  1093.077
   100.500  1093.974
   101.000  1094.874
   101.500  1095.776
   102.000  1096.680
   102.500  1097.587
   103.000  1098.496
   103.500  1099.408
   104.000  1100.322
   104.500  1101.238
   105.000  1102.157
   105.500  1103.078
   106.000  1104.001
   106.500  1104.927
   107.000  1105.855
   107.500  1106.785
   108.000  1107.717
   108.500  1108.651
   109.000  1109.588
   109.500  1110.526
   110.000  1111.467
   110.500  1112.410
   111.000  1113.354
   111.500  1114.301
   112.000  1115.250
   112.500  1116.201
   113.000  1117.153
   113.500  1118.108
   114.000  1119.064
   114.500  1120.023
   115.000  1120.983
   115.500  1121.945
   116.000  1122.909
   116.500  1123.875
   117.000  1124.842
   117.500  1125.811
   118.000  1126.782
   118.500  1127.754
   119.000  1128.728
   119.500  1129.704
   120.000  1130.681
   120.500  1131.660
   121.000  1132.641
   121.500  1133.623
   122.000  1134.606
   122.500  1135.591
   123.000  1136.578
   123.500  1137.566
   124.000  1138.555
   124.500  1139.546
   125.000  1140.538
   125.500  1141.531
   126.000  1142.526
   126.500  1143.522
   127.000  1144.519
   127.500  1145.518
   128.000  1146.518
   128.500  1147.519
   129.000  1148.521
   129.500  1149.524
   130.000  1150.529
   130.500  1151.534
   131.000  1152.541
   131.500  1153.548
   132.000  1154.557
   132.500  1155.567
   133.000  1156.578
   133.500  1157.590
   134.000  1158.602
   134.500  1159.616
   135.000  1160.630
   135.500  1161.646
   136.000  1162.662
   136.500  1163.679
   137.000  1164.697
   137.500  1165.716
   138.000  1166.735
   138.500  1167.756
   139.000  1168.776
   139.500  1169.798
   140.000  1170.820
   140.500  1171.844
   141.000  1172.867
   141.500  1173.891
   142.000  1174.916
   142.500  1175.942
   143.000  1176.967
   143.500  1177.994
   144.000  1179.021
   144.500  1180.048
   145.000  1181.076
   145.500  1182.104
   146.000  1183.133
   146.500  1184.162
   147.000  1185.192
   147.500  1186.222
   148.000  1187.252
   148.500  1188.282
   149.000  1189.313
   149.500  1190.344
   150.000  1191.375
   150.500  1192.407
   151.000  1193.438
   151.500  1194.470
   152.000  1195.503
   152.500  1196.535
   153.000  1197.567
   153.500  1198.599
   154.000  1199.632
   154.500  1200.664
   155.000  1201.697
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.568
   145.500  1178.391
   146.000  1180.271
   146.500  1182.188
   147.000  1184.133
   147.500  1186.101
   148.000  1188.089
   148.500  1190.095
   149.000  1192.116
   149.500  1194.152
   150.000  1196.200
   150.500  1198.259
   151.000  1200.329
   151.500  1202.409
   152.000  1204.497
   152.500  1206.594
   153.000  1208.699
   153.500  1210.811
   154.000  1212.930
   154.500  1215.056
   155.000  1217.188
   155.500  1219.325
   156.000  1221.468
   156.500  1223.616
   157.000  1225.768
   157.500  1227.925
   158.000  1230.086
   158.500  1232.251
   159.000  1234.421
   159.500  1236.594
   160.000  1238.770
   160.500  1240.949
   161.000  1243.132
   161.500  1245.318
   162.000  1247.506
   162.500  1249.696
   163.000  1251.890
   163.500  1254.085
   164.000  1256.282
   164.500  1258.482
   165.000  1260.684
   165.500  1262.887
   166.000  1265.092
   166.500  1267.299
   167.000  1269.507
   167.500  1271.717
   168.000  1273.928
   168.500  1276.140
   169.000  1278.353
   169.500  1280.568
   170.000  1282.783
   170.500  1285.000
   171.000  1287.217
   171.500  1289.435
   172.000  1291.653
   172.500  1293.873
   173.000  1296.093
   173.500  1298.313
   174.000  1300.534
   174.500  1302.756
   175.000  1304.978
   175.500  1307.200
   176.000  1309.422
   176.500  1311.644
   177.000  1313.867
   177.500  1316.090
   178.000  1318.313
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.565
   145.500  1178.191
   146.000  1179.738
   146.500  1181.227
   147.000  1182.667
   147.500  1184.061
   148.000  1185.413
   148.500  1186.725
   149.000  1188.002
   149.500  1189.251
   150.000  1190.474
   150.500  1191.675
   151.000  1192.855
   151.500  1194.015
   152.000  1195.157
   152.500  1196.282
   153.000  1197.391
   153.500  1198.485
   154.000  1199.567
   154.500  1200.635
   155.000  1201.689
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   509.762
     1.000   509.798
     1.500   509.858
     2.000   509.942
     2.500   510.050
     3.000   510.182
     3.500   510.338
     4.000   510.517
     4.500   510.721
     5.000   510.949
     5.500   511.200
     6.000   511.475
     6.500   511.774
     7.000   512.096
     7.500   512.442
     8.000   512.811
     8.500   513.204
     9.000   513.620
     9.500   514.060
    10.000   514.522
    10.500   515.008
    11.000   515.517
    11.500   516.049
    12.000   516.603
    12.500   517.180
    13.000   517.780
    13.500   518.403
    14.000   519.047
    14.500   519.714
    15.000   520.403
    15.500   521.115
    16.000   521.848
    16.500   522.602
    17.000   523.379
    17.500   524.177
    18.000   524.996
    18.500   525.837
    19.000   526.698
    19.500   527.581
    20.000   528.484
    20.500   529.408
    21.000   530.352
    21.500   531.317
    22.000   532.302
    22.500   533.306
    23.000   534.331
    23.500   535.375
    24.000   536.439
    24.500   537.522
    25.000   538.624
    25.500   539.745
    26.000   540.885
    26.500   542.044
    27.000   543.221
    27.500   544.416
    28.000   545.629
    28.500   546.861
    29.000   548.110
    29.500   549.376
    30.000   550.660
    30.500   551.961
    31.000   553.279
    31.500   554.614
    32.000   555.966
    32.500   557.334
    33.000   558.718
    33.500   560.118
    34.000   561.535
    34.500   562.966
    35.000   564.414
    35.500   565.877
    36.000   567.354
    36.500   568.847
    37.000   570.355
    37.500   571.877
    38.000   573.413
    38.500   574.964
    39.000   576.529
    39.500   578.108
    40.000   579.700
    40.500   581.305
    41.000   582.924
    41.500   584.557
    42.000   586.202
    42.500   587.859
    43.000   589.530
    43.500   591.212
    44.000   592.907
    44.500   594.614
    45.000   596.333
    45.500   598.063
    46.000   599.805
    46.500   601.558
    47.000   603.323
    47.500   605.098
    48.000   606.884
    48.500   608.681
    49.000   610.488
    49.500   612.305
    50.000   614.133
    50.500   615.971
    51.000   617.818
    51.500   619.675
    52.000   621.541
    52.500   623.417
    53.000   625.302
    53.500   627.196
    54.000   629.098
    54.500   631.010
    55.000   632.930
    55.500   634.858
    56.000   636.794
    56.500   638.739
    57.000   640.691
    57.500   642.652
    58.000   644.620
    58.500   646.595
    59.000   648.577
    59.500   650.567
    60.000   652.564
    60.500   654.568
    61.000   656.578
    61.500   658.596
    62.000   660.619
    62.500   662.649
    63.000   664.686
    63.500   666.728
    64.000   668.776
    64.500   670.831
    65.000   672.890
    65.500   674.956
    66.000   677.027
    66.500   679.103
    67.000   681.185
    67.500   683.271
    68.000   685.363
    68.500   687.459
    69.000   689.560
    69.500   691.666
    70.000   693.776
    70.500   695.891
    71.000   698.010
    71.500   700.133
    72.000   702.261
    72.500   704.392
    73.000   706.527
    73.500   708.666
    74.000   710.808
    74.500   712.954
    75.000   715.104
    75.500   717.257
    76.000   719.413
    76.500   721.572
    77.000   723.735
    77.500   725.900
    78.000   728.068
    78.500   730.239
    79.000   732.413
    79.500   734.589
    80.000   736.768
    80.500   738.950
    81.000   741.133
    81.500   743.319
    82.000   745.508
    82.500   747.698
    83.000   749.890
    83.500   752.084
    84.000   754.281
    84.500   756.479
    85.000   758.678
    85.500   760.880
    86.000   763.083
    86.500   765.287
    87.000   767.493
    87.500   769.701
    88.000   771.909
    88.500   774.119
    89.000   776.330
    89.500   778.542
    90.000   780.756
    90.500   782.970
    91.000   785.185
    91.500   787.401
    92.000   789.618
    92.500   791.836
    93.000   794.054
    93.500   796.273
    94.000   798.493
    94.500   800.713
    95.000   802.933
    95.500   805.155
    96.000   807.376
    96.500   809.598
    97.000   811.820
    97.500   814.042
    98.000   816.265
    98.500   818.487
    99.000   820.710
    99.500   822.933
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.564
    29.000   425.122
    29.500   430.679
    30.000   436.235
    30.500   441.790
    31.000   447.343
    31.500   452.895
    32.000   458.445
    32.500   463.992
    33.000   469.537
    33.500   475.078
    34.000   480.615
    34.500   486.149
    35.000   491.677
    35.500   497.201
    36.000   502.719
    36.500   508.231
    37.000   513.737
    37.500   519.235
    38.000   524.725
    38.500   530.208
    39.000   535.681
    39.500   541.145
    40.000   546.599
    40.500   552.042
    41.000   557.475
    41.500   562.895
    42.000   568.303
    42.500   573.699
    43.000   579.081
    43.500   584.449
    44.000   589.803
    44.500   595.141
    45.000   600.465
    45.500   605.773
    46.000   611.065
    46.500   616.340
    47.000   621.598
    47.500   626.342
    48.000   630.912
    48.500   635.478
    49.000   640.040
    49.500   644.596
    50.000   649.148
    50.500   653.694
    51.000   658.235
    51.500   662.770
    52.000   667.300
    52.500   671.825
    53.000   676.343
    53.500   680.855
    54.000   685.360
    54.500   689.857
    55.000   694.346
    55.500   698.824
    56.000   703.292
    56.500   707.751
    57.000   712.205
    57.500   716.653
    58.000   721.097
    58.500   725.536
    59.000   729.970
    59.500   734.401
    60.000   738.828
    60.500   743.251
    61.000   747.670
    61.500   752.086
    62.000   756.497
    62.500   760.905
    63.000   765.309
    63.500   769.708
    64.000   774.104
    64.500   778.494
    65.000   782.880
    65.500   787.261
    66.000   791.635
    66.500   796.004
    67.000   800.365
    67.500   804.720
    68.000   809.068
    68.500   813.408
    69.000   817.740
    69.500   822.065
    70.000   826.382
    70.500   830.692
    71.000   834.994
    71.500   839.289
    72.000   843.576
    72.500   847.856
    73.000   852.127
    73.500   856.392
    74.000   860.648
    74.500   864.896
    75.000   869.137
    75.500   873.370
    76.000   877.594
    76.500   881.811
    77.000   886.019
    77.500   890.219
    78.000   894.411
    78.500   898.595
    79.000   902.770
    79.500   906.936
    80.000   911.094
    80.500   915.243
    81.000   919.383
    81.500   923.516
    82.000   927.639
    82.500   931.754
    83.000   935.861
    83.500   939.959
    84.000   944.049
    84.500   948.130
    85.000   952.202
    85.500   956.265
    86.000   960.320
    86.500   964.366
    87.000   968.403
    87.500   972.432
    88.000   976.451
    88.500   980.462
    89.000   984.463
    89.500   988.456
    90.000   992.440
    90.500   996.415
    91.000  1000.380
    91.500  1004.337
    92.000  1008.285
    92.500  1012.224
    93.000  1016.154
    93.500  1020.074
    94.000  1023.986
    94.500  1027.889
    95.000  1031.782
    95.500  1035.667
    96.000  1039.542
    96.500  1043.409
    97.000  1047.266
    97.500  1051.115
    98.000  1054.954
    98.500  1058.784
    99.000  1062.605
    99.500  1066.416
   100.000  1070.219
   100.500  1074.013
   101.000  1077.797
   101.500  1081.572
   102.000  1085.338
   102.500  1089.095
   103.000  1092.843
   103.500  1096.581
   104.000  1100.311
   104.500  1104.032
   105.000  1107.744
   105.500  1111.447
   106.000  1115.141
   106.500  1118.827
   107.000  1122.503
   107.500  1126.170
   108.000  1129.828
   108.500  1133.478
   109.000  1137.117
   109.500  1140.748
   110.000  1144.369
   110.500  1147.981
   111.000  1151.584
   111.500  1155.177
   112.000  1158.762
   112.500  1162.337
   113.000  1165.902
   113.500  1169.459
   114.000  1173.007
   114.500  1176.545
   115.000  1180.075
   115.500  1183.595
   116.000  1187.107
   116.500  1190.609
   117.000  1194.102
   117.500  1197.587
   118.000  1201.062
   118.500  1204.528
   119.000  1207.984
   119.500  1211.432
   120.000  1214.870
   120.500  1218.300
   121.000  1221.719
   121.500  1225.130
   122.000  1228.532
   122.500  1231.924
   123.000  1235.307
   123.500  1238.681
   124.000  1242.046
   124.500  1245.402
   125.000  1248.749
   125.500  1252.087
   126.000  1255.416
   126.500  1258.736
   127.000  1262.047
   127.500  1265.349
   128.000  1268.643
   128.500  1271.927
   129.000  1275.202
   129.500  1278.469
   130.000  1281.726
   130.500  1284.974
   131.000  1288.214
   131.500  1291.444
   132.000  1294.666
   132.500  1297.878
   133.000  1301.081
   133.500  1304.276
   134.000  1307.461
   134.500  1310.637
   135.000  1313.804
   135.500  1316.962
   136.000  1320.111
   136.500  1323.251
   137.000  1326.382
   137.500  1329.503
   138.000  1332.616
   138.500  1335.719
   139.000  1338.814
   139.500  1341.899
   140.000  1344.975
   140.500  1348.042
   141.000  1351.101
   141.500  1354.150
   142.000  1357.190
   142.500  1360.221
   143.000  1363.242
   143.500  1366.255
   144.000  1369.259
   144.500  1372.254
   145.000  1375.239
   145.500  1378.215
   146.000  1381.182
   146.500  1384.140
   147.000  1387.089
   147.500  1390.028
   148.000  1392.957
   148.500  1395.878
   149.000  1398.789
   149.500  1401.690
   150.000  1404.582
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.156
   100.500   827.379
   101.000   829.602
   101.500   831.824
   102.000   834.047
   102.500   836.270
   103.000   838.493
   103.500   840.716
   104.000   842.939
   104.500   845.161
   105.000   847.384
   105.500   849.607
   106.000   851.830
   106.500   854.053
   107.000   856.276
   107.500   858.498
   108.000   860.721
   108.500   862.944
   109.000   865.167
   109.500   867.390
   110.000   869.613
   110.500   871.835
   111.000   874.058
   111.500   876.281
   112.000   878.504
   112.500   880.727
   113.000   882.950
   113.500   885.172
   114.000   887.395
   114.500   889.618
   115.000   891.841
   115.500   894.064
   116.000   896.287
   116.500   898.509
   117.000   900.732
   117.500   902.955
   118.000   905.178
   118.500   907.401
   119.000   909.624
   119.500   911.846
   120.000   914.069
   120.500   916.292
   121.000   918.515
   121.500   920.738
   122.000   922.961
   122.500   925.183
   123.000   927.406
   123.500   929.629
   124.000   931.852
   124.500   934.075
   125.000   936.298
   125.500   938.520
   126.000   940.743
   126.500   942.966
   127.000   945.189
   127.500   947.412
   128.000   949.635
   128.500   951.857
   129.000   954.080
   129.500   956.303
   130.000   958.526
   130.500   960.749
   131.000   962.972
   131.500   965.194
   132.000   967.417
   132.500   969.640
   133.000   971.863
   133.500   974.086
   134.000   976.309
   134.500   978.531
   135.000   980.754
   135.500   982.977
   136.000   985.200
   136.500   987.423
   137.000   989.646
   137.500   991.869
   138.000   994.091
   138.500   996.314
   139.000   998.537
   139.500  1000.760
   140.000  1002.983
   140.500  1005.205
   141.000  1007.428
   141.500  1009.651
   142.000  1011.874
   142.500  1014.097
   143.000  1016.320
   143.500  1018.542
   144.000  1020.765
   144.500  1022.988
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   385.450
    15.000   395.688
    15.500   405.923
    16.000   416.151
    16.500   426.368
    17.000   436.571
    17.500   446.756
    18.000   456.918
    18.500   467.052
    19.000   477.152
    19.500   487.212
    20.000   497.227
    20.500   507.190
    21.000   517.096
    21.500   526.939
    22.000   536.713
    22.500   546.415
    23.000   555.082
    23.500   563.225
    24.000   571.334
    24.500   579.411
    25.000   587.443
    25.500   595.396
    26.000   603.308
    26.500   611.208
    27.000   619.099
    27.500   626.983
    28.000   634.860
    28.500   642.731
    29.000   650.595
    29.500   658.452
    30.000   666.302
    30.500   674.143
    31.000   681.975
    31.500   689.796
    32.000   697.604
    32.500   705.398
    33.000   713.176
    33.500   720.938
    34.000   728.682
    34.500   736.407
    35.000   744.113
    35.500   751.800
    36.000   759.467
    36.500   767.114
    37.000   774.741
    37.500   782.347
    38.000   789.932
    38.500   797.495
    39.000   805.037
    39.500   812.555
    40.000   820.051
    40.500   827.524
    41.000   834.974
    41.500   842.400
    42.000   849.802
    42.500   857.179
    43.000   864.533
    43.500   871.862
    44.000   879.166
    44.500   886.445
    45.000   893.699
    45.500   900.928
    46.000   908.131
    46.500   915.308
    47.000   922.459
    47.500   929.584
    48.000   936.682
    48.500   943.754
    49.000   950.798
    49.500   957.815
    50.000   964.806
    50.500   971.769
    51.000   978.705
    51.500   985.614
    52.000   992.495
    52.500   999.348
    53.000  1006.174
    53.500  1012.974
    54.000  1019.748
    54.500  1026.496
    55.000  1033.218
    55.500  1039.912
    56.000  1046.579
    56.500  1053.217
    57.000  1059.828
    57.500  1066.411
    58.000  1072.966
    58.500  1079.493
    59.000  1085.992
    59.500  1092.463
    60.000  1098.907
    60.500  1105.324
    61.000  1111.712
    61.500  1118.072
    62.000  1124.404
    62.500  1130.708
    63.000  1136.983
    63.500  1143.230
    64.000  1149.448
    64.500  1155.638
    65.000  1161.800
    65.500  1167.933
    66.000  1174.038
    66.500  1180.115
    67.000  1186.164
    67.500  1192.184
    68.000  1198.175
    68.500  1204.138
    69.000  1210.072
    69.500  1215.978
    70.000  1221.855
    70.500  1227.703
    71.000  1233.522
    71.500  1239.313
    72.000  1245.074
    72.500  1250.806
    73.000  1256.508
    73.500  1262.180
    74.000  1267.822
    74.500  1273.435
    75.000  1279.017
    75.500  1284.570
    76.000  1290.094
    76.500  1295.588
    77.000  1301.053
    77.500  1306.488
    78.000  1311.892
    78.500  1317.266
    79.000  1322.610
    79.500  1327.924
    80.000  1333.210
    80.500  1338.466
    81.000  1343.692
    81.500  1348.886
    82.000  1354.049
    82.500  1359.179
    83.000  1364.278
    83.500  1369.346
    84.000  1374.382
    84.500  1379.387
    85.000  1384.362
    85.500  1389.305
    86.000  1394.216
    86.500  1399.095
    87.000  1403.942
    87.500  1408.757
    88.000  1413.538
    88.500  1418.286
    89.000  1423.002
    89.500  1427.683
    90.000  1432.331
    90.500  1436.945
    91.000  1441.526
    91.500  1446.072
    92.000  1450.585
    92.500  1455.064
    93.000  1459.509
    93.500  1463.920
    94.000  1468.305
    94.500  1472.673
    95.000  1477.028
    95.500  1481.371
    96.000  1485.703
    96.500  1490.021
    97.000  1494.323
    97.500  1498.605
    98.000  1502.867
    98.500  1507.109
    99.000  1511.332
    99.500  1515.535
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   720.501
     1.000   720.548
     1.500   720.625
     2.000   720.734
     2.500   720.874
     3.000   721.045
     3.500   721.248
     4.000   721.481
     4.500   721.745
     5.000   722.039
     5.500   722.365
     6.000   722.721
     6.500   723.108
     7.000   723.525
     7.500   723.973
     8.000   724.451
     8.500   724.959
     9.000   725.497
     9.500   726.066
    10.000   726.664
    10.500   727.291
    11.000   727.948
    11.500   728.635
    12.000   729.350
    12.500   730.095
    13.000   730.868
    13.500   731.670
    14.000   732.501
    14.500   733.360
    15.000   734.246
    15.500   735.161
    16.000   736.103
    16.500   737.073
    17.000   738.070
    17.500   739.094
    18.000   740.145
    18.500   741.222
    19.000   742.325
    19.500   743.455
    20.000   744.610
    20.500   745.791
    21.000   746.997
    21.500   748.228
    22.000   749.484
    22.500   750.764
    23.000   752.068
    23.500   753.396
    24.000   754.748
    24.500   756.123
    25.000   757.521
    25.500   758.942
    26.000   760.385
    26.500   761.850
    27.000   763.337
    27.500   764.846
    28.000   766.376
    28.500   767.927
    29.000   769.498
    29.500   771.089
    30.000   772.701
    30.500   774.332
    31.000   775.983
    31.500   777.652
    32.000   779.340
    32.500   781.047
    33.000   782.771
    33.500   784.513
    34.000   786.272
    34.500   788.049
    35.000   789.842
    35.500   791.651
    36.000   793.477
    36.500   795.318
    37.000   797.175
    37.500   799.046
    38.000   800.932
    38.500   802.833
    39.000   804.747
    39.500   806.675
    40.000   808.617
    40.500   810.571
    41.000   812.538
    41.500   814.518
    42.000   816.509
    42.500   818.512
    43.000   820.527
    43.500   822.552
    44.000   824.588
    44.500   826.635
    45.000   828.691
    45.500   830.757
    46.000   832.833
    46.500   834.917
    47.000   837.011
    47.500   839.112
    48.000   841.222
    48.500   843.339
    49.000   845.464
    49.500   847.596
    50.000   849.735
    50.500   851.881
    51.000   854.032
    51.500   856.190
    52.000   858.353
    52.500   860.522
    53.000   862.696
    53.500   864.874
    54.000   867.057
    54.500   869.245
    55.000   871.436
    55.500   873.631
    56.000   875.829
    56.500   878.031
    57.000   880.236
    57.500   882.443
    58.000   884.653
    58.500   886.865
    59.000   889.079
    59.500   891.295
    60.000   893.512
    60.500   895.731
    61.000   897.951
    61.500   900.172
    62.000   902.394
    62.500   904.616
    63.000   906.839
    63.500   909.061
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   932.555
     1.000   932.621
     1.500   932.732
     2.000   932.887
     2.500   933.086
     3.000   933.330
     3.500   933.617
     4.000   933.949
     4.500   934.325
     5.000   934.744
     5.500   935.208
     6.000   935.715
     6.500   936.266
     7.000   936.860
     7.500   937.498
     8.000   938.180
     8.500   938.904
     9.000   939.672
     9.500   940.483
    10.000   941.336
    10.500   942.232
    11.000   943.171
    11.500   944.152
    12.000   945.174
    12.500   946.239
    13.000   947.346
    13.500   948.494
    14.000   949.684
    14.500   950.915
    15.000   952.186
    15.500   953.498
    16.000   954.851
    16.500   956.244
    17.000   957.677
    17.500   959.149
    18.000   960.662
    18.500   962.213
    19.000   963.803
    19.500   965.432
    20.000   967.099
    20.500   968.805
    21.000   970.548
    21.500   972.329
    22.000   974.148
    22.500   976.003
    23.000   977.895
    23.500   979.823
    24.000   981.787
    24.500   983.788
    25.000   985.823
    25.500   987.894
    26.000   990.000
    26.500   992.140
    27.000   994.315
    27.500   996.523
    28.000   998.765
    28.500  1001.040
    29.000  1003.349
    29.500  1005.689
    30.000  1008.062
    30.500  1010.467
    31.000  1012.904
    31.500  1015.372
    32.000  1017.870
    32.500  1020.400
    33.000  1022.959
    33.500  1025.549
    34.000  1028.168
    34.500  1030.816
    35.000  1033.493
    35.500  1036.199
    36.000  1038.933
    36.500  1041.695
    37.000  1044.485
    37.500  1047.301
    38.000  1050.145
    38.500  1053.015
    39.000  1055.912
    39.500  1058.834
    40.000  1061.782
    40.500  1064.755
    41.000  1067.753
    41.500  1070.775
    42.000  1073.822
    42.500  1076.893
    43.000  1079.987
    43.500  1083.104
    44.000  1086.245
    44.500  1089.408
    45.000  1092.593
    45.500  1095.800
    46.000  1099.029
    46.500  1102.280
    47.000  1105.551
    47.500  1108.843
    48.000  1112.155
    48.500  1115.488
    49.000  1118.840
    49.500  1122.212
    50.000  1125.603
    50.500  1129.012
    51.000  1132.441
    51.500  1135.887
    52.000  1139.352
    52.500  1142.834
    53.000  1146.334
    53.500  1149.851
    54.000  1153.385
    54.500  1156.935
    55.000  1160.501
    55.500  1164.084
    56.000  1167.682
    56.500  1171.296
    57.000  1174.925
    57.500  1178.569
    58.000  1182.227
    58.500  1185.900
    59.000  1189.587
    59.500  1193.288
    60.000  1197.002
    60.500  1200.730
    61.000  1204.471
    61.500  1208.225
    62.000  1211.991
    62.500  1215.770
    63.000  1219.561
    63.500  1223.363
    64.000  1227.178
    64.500  1231.003
    65.000  1234.840
    65.500  1238.688
    66.000  1242.547
    66.500  1246.416
    67.000  1250.295
    67.500  1254.184
    68.000  1258.083
    68.500  1261.992
    69.000  1265.910
    69.500  1269.838
    70.000  1273.774
    70.500  1277.719
    71.000  1281.673
    71.500  1285.635
    72.000  1289.605
    72.500  1293.583
    73.000  1297.569
    73.500  1301.562
    74.000  1305.563
    74.500  1309.571
    75.000  1313.586
    75.500  1317.608
    76.000  1321.636
    76.500  1325.671
    77.000  1329.712
    77.500  1333.759
    78.000  1337.812
    78.500  1341.871
    79.000  1345.936
    79.500  1350.006
    80.000  1354.081
    80.500  1358.161
    81.000  1362.246
    81.500  1366.336
    82.000  1370.431
    82.500  1374.530
    83.000  1378.633
    83.500  1382.740
    84.000  1386.852
    84.500  1390.967
    85.000  1395.086
    85.500  1399.208
    86.000  1403.334
    86.500  1407.463
    87.000  1411.596
    87.500  1415.731
    88.000  1419.869
    88.500  1424.010
    89.000  1428.153
    89.500  1432.299
    90.000  1436.447
    90.500  1440.597
    91.000  1444.750
    91.500  1448.904
    92.000  1453.060
    92.500  1457.218
    93.000  1461.378
    93.500  1465.539
    94.000  1469.701
    94.500  1473.865
    95.000  1478.030
    95.500  1482.195
    96.000  1486.362
    96.500  1490.530
    97.000  1494.698
    97.500  1498.867
    98.000  1503.036
    98.500  1507.206
    99.000  1511.376
    99.500  1515.546
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   773.404
    29.500   783.643
    30.000   793.881
    30.500   804.118
    31.000   814.352
    31.500   824.582
    32.000   834.809
    32.500   845.030
    33.000   855.245
    33.500   865.454
    34.000   875.655
    34.500   885.846
    35.000   896.028
    35.500   906.198
    36.000   916.356
    36.500   926.500
    37.000   936.628
    37.500   946.740
    38.000   956.834
    38.500   966.577
    39.000   976.962
    39.500   986.993
    40.000   996.999
    40.500  1006.980
    41.000  1016.934
    41.500  1026.860
    42.000  1036.755
    42.500  1046.619
    43.000  1056.451
    43.500  1066.249
    44.000  1076.011
    44.500  1085.738
    45.000  1095.427
    45.500  1104.795
    46.000  1112.965
    46.500  1121.118
    47.000  1129.254
    47.500  1137.374
    48.000  1145.477
    48.500  1153.564
    49.000  1161.633
    49.500  1169.682
    50.000  1177.705
    50.500  1185.691
    51.000  1193.621
    51.500  1201.537
    52.000  1209.446
    52.500  1217.349
    53.000  1225.247
    53.500  1233.141
    54.000  1241.031
    54.500  1248.917
    55.000  1256.800
    55.500  1264.679
    56.000  1272.555
    56.500  1280.427
    57.000  1288.296
    57.500  1296.162
    58.000  1304.025
    58.500  1311.884
    59.000  1319.740
    59.500  1327.592
    60.000  1335.440
    60.500  1343.285
    61.000  1351.125
    61.500  1358.960
    62.000  1366.790
    62.500  1374.614
    63.000  1382.432
    63.500  1390.245
    64.000  1398.050
    64.500  1405.849
    65.000  1413.640
    65.500  1421.423
    66.000  1429.198
    66.500  1436.965
    67.000  1444.723
    67.500  1452.472
    68.000  1460.213
    68.500  1467.944
    69.000  1475.666
    69.500  1483.378
    70.000  1491.080
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     0.343    12.013     0.150
     1.288    40.554     0.150
     2.841    52.948     0.150
     2.982    46.913     0.150
     3.920    71.678     0.150
     4.587    84.368     0.150
     4.587   142.078     0.150
     4.873    83.019     0.150
     5.346    74.328     0.150
     6.761   103.788     0.150
     6.993   120.258     0.150
     6.993   216.848     0.150
     6.997   100.498     0.150
     7.032   184.816     0.150
     7.042   234.758     0.150
     7.090   218.348     0.150
     7.217   126.288     0.150
     7.764   121.418     0.150
     7.764   153.068     0.150
     7.794   111.888     0.150
     7.794   263.698     0.150
     8.101   115.198     0.150
     8.101   139.368     0.150
     8.643   130.938     0.150
     9.228   230.558     0.150
     9.482   134.408     0.150
    10.377   325.663     0.150
    11.367   170.769     0.150
    12.341   168.578     0.150
    12.535   312.798     0.150
    14.551   203.448     0.150
     0.331     6.492     0.150
     0.331    10.818     0.150
     0.331     6.445     0.150
     0.331    11.615     0.150
     1.412    23.715     0.150
     1.412    45.645     0.150
     1.513    26.395     0.150
     1.513    28.455     0.150
     2.027    37.693     0.150
     2.066    38.727     0.150
     2.214    41.225     0.150
     2.277    70.375     0.150
     2.504    78.889     0.150
     4.308   133.295     0.150
     4.857    92.967     0.150
     5.167    80.715     0.150
     5.312    84.475     0.150
     5.364   169.225     0.150
     5.822    84.918     0.150
     7.339   229.555     0.150
     7.510   231.834     0.150
    10.445   157.684     0.150
    11.013   151.193     0.150
    11.060   160.244     0.150
    11.605   372.389     0.150
    15.273   225.145     0.150
     0.598    19.110     0.150
     0.904    28.907     0.150
     1.039    17.990     0.150
     1.327    45.950     0.150
     1.478    48.690     0.150
     1.478    49.641     0.150
     2.114    39.771     0.150
     2.268    41.760     0.150
     3.830    70.430     0.150
     4.247    63.371     0.150
     5.609    88.645     0.150
     5.609   100.669     0.150
     6.043   109.570     0.150
     7.420   135.090     0.150
     7.534   234.851     0.150
     0.167     3.673     0.150
     0.167     6.133     0.150
     1.422    23.723     0.150
     1.643    50.882     0.150
     1.875    31.883     0.150
     2.214    42.173     0.150
     2.271    70.828     0.150
     2.704    48.269     0.150
     3.602    50.382     0.150
     7.343   136.263     0.150
     7.511   105.713     0.150
    10.773   339.283     0.150
     1.640    50.812     0.150
     1.974    36.961     0.150
     2.771    78.820     0.150
     4.663    80.227     0.150
     5.586    96.727     0.150
     5.586   170.016     0.150
     7.342   135.844     0.150
    93.835  1848.734     0.150
     0.356     6.918     0.150
     1.059    33.441     0.150
     1.795    30.691     0.150
     1.899    57.090     0.150
     1.969    61.117     0.150
     2.140    63.941     0.150
     2.530    41.031     0.150
     5.052    77.520     0.150
     5.052    93.168     0.150
     5.052   160.469     0.150
     6.908   199.418     0.150
    10.887   158.789     0.150
    10.887   347.578     0.150
    12.014   172.121     0.150
    36.250   425.039     0.150
    81.594   922.391     0.150
    81.594  1352.191     0.150
     0.362     6.102     0.150
     1.224    36.332     0.150
     1.800    30.621     0.150
     1.975    61.422     0.150
    93.593     7.801     0.150
     0.692    13.137     0.150
     0.700    13.137     0.150
     0.658    12.547     0.150
     0.658    21.969     0.150
     0.821    14.555     0.150
     0.980    57.906     0.150
     1.401    58.887     0.150
     1.401    62.809     0.150
     1.403    61.855     0.150
     1.576    49.738     0.150
     1.656    48.352     0.150
     1.941    72.266     0.150
     1.941    77.738     0.150
     2.156    61.707     0.150
     2.348    72.473     0.150
     2.785    79.969     0.150
     3.312    92.098     0.150
     4.302   118.879     0.150
     4.969    72.688     0.150
     5.498    99.605     0.150
     5.498    82.309     0.150
     5.498    99.605     0.150
     5.796    83.906     0.150
     5.796   153.926     0.150
     5.910    91.027     0.150
     5.931   191.488     0.150
     6.025   159.977     0.150
     6.995   229.988     0.150
     7.152   228.887     0.150
     7.249   233.188     0.150
     7.416   236.266     0.150
     7.872   244.105     0.150
     7.872   249.816     0.150
     8.035   260.059     0.150
     8.905   231.176     0.150
    10.049   260.879     0.150
    10.044   154.734     0.150
    10.044   322.637     0.150
    10.044   154.738     0.150
    10.044   322.637     0.150
    10.074   260.617     0.150
    10.610   157.137     0.150
    10.610   157.008     0.150
    10.850   155.117     0.150
    11.070   158.977     0.150
    11.070   349.227     0.150
    11.031   163.848     0.150
    11.966   170.656     0.150
    12.264   173.797     0.150
    12.735   181.566     0.150
    12.800   178.879     0.150
    13.367   188.266     0.150
    14.146   197.129     0.150
    22.370   299.738     0.150
    26.893   344.656     0.150
    29.195   363.605     0.150
    36.482   427.707     0.150
    36.756   429.957     0.150
    93.846   802.758     0.150
    93.846   802.758     0.150
    95.366   810.258     0.150
    95.469   810.258     0.150
    98.608   823.543     0.150
    98.608   823.547     0.150
   111.295  1117.059     0.150
   119.023  1133.758     0.150
   119.023  1133.758     0.150
     0.676    13.028     0.150
     0.677    12.997     0.150
     0.806    14.596     0.150
     0.951    52.729     0.150
     1.371    21.198     0.150
     1.371    50.648     0.150
     1.486    27.063     0.150
     1.853    36.089     0.150
     2.139    40.809     0.150
     2.186    42.188     0.150
     2.215    42.648     0.150
     3.265    63.839     0.150
     3.265   106.379     0.150
     5.528    90.659     0.150
     5.528   103.209     0.150
     5.528   177.729     0.150
     7.096   135.869     0.150
     7.571   138.879     0.150
     7.874   240.054     0.150
     7.874   114.528     0.150
     7.874   146.979     0.150
     7.874   240.049     0.150
    10.634   345.542     0.150
    10.634   157.379     0.150
    10.634   345.539     0.150
    11.056   354.328     0.150
    11.056   159.759     0.150
    11.056   354.329     0.150
    14.989   219.028     0.150
     0.369     6.652     0.150
     0.709     6.898     0.150
     1.376    50.387     0.150
     1.586    42.949     0.150
     1.662    29.684     0.150
     0.527     9.148     0.150
     0.527    15.499     0.150
     0.527    15.969     0.150
     0.527     9.073     0.150
     0.527    15.499     0.150
     0.527     9.213     0.150
     0.527    15.855     0.150
     0.769    23.310     0.150
     0.905    29.522     0.150
     1.332    24.401     0.150
     1.389    23.419     0.150
     1.389    40.815     0.150
     1.630    51.479     0.150
     1.623    52.738     0.150
     1.623    28.954     0.150
     2.009    61.237     0.150
     2.116    39.349     0.150
     2.116    35.465     0.150
     4.103    81.118     0.150
     4.501    82.309     0.150
     4.598   137.969     0.150
     4.588   148.929     0.150
     4.588    71.174     0.150
     4.588    84.823     0.150
     4.588   148.925     0.150
     4.744   129.639     0.150
     5.912   193.979     0.150
     6.041   187.539     0.150
     6.055   188.509     0.150
     7.025   214.688     0.150
     7.586   144.139     0.150
     7.586   247.759     0.150
     7.601   145.519     0.150
     7.601   239.278     0.150
     7.788   114.552     0.150
     7.938   244.858     0.150
     8.119   249.849     0.150
     8.699   268.519     0.150
     8.699   268.523     0.150
    10.509   153.999     0.150
    12.202   175.874     0.150
    12.202   385.956     0.150
    14.281   205.924     0.150
    22.428   298.724     0.150
    28.581   355.743     0.150
    35.798   419.320     0.150
    93.180     7.699     0.150
   100.585   833.648     0.150
     0.408     8.140     0.150
     0.408    13.479     0.150
     0.458     8.580     0.150
     0.458    14.970     0.150
     0.621    19.550     0.150
     0.621    11.750     0.150
     0.621    19.550     0.150
     0.726    25.989     0.150
     0.726    28.050     0.150
     1.291    21.819     0.150
     1.349    42.479     0.150
     1.949    36.137     0.150
     2.088    65.010     0.150
     2.331    43.229     0.150
     2.331    70.840     0.150
     3.175    47.830     0.150
     4.754    94.449     0.150
     5.648   102.100     0.150
     5.648   173.765     0.150
     5.894   192.409     0.150
     6.449    99.359     0.150
     6.449   197.630     0.150
     7.240   237.680     0.150
     7.694   247.830     0.150
     7.787   141.824     0.150
     8.111   252.340     0.150
    11.469   167.675     0.150
     0.406     8.219     0.150
     0.406    13.891     0.150
     0.452     8.562     0.150
     0.632    11.141     0.150
     1.115    40.719     0.150
     1.343    42.520     0.150
     1.875    58.492     0.150
     2.082    64.031     0.150
     2.328    43.121     0.150
     2.328    67.031     0.150
     2.337    68.391     0.150
     3.170    87.680     0.150
     3.190    89.969     0.150
     4.837   130.410     0.150
     5.654   103.016     0.150
     5.654   186.789     0.150
     5.893   112.910     0.150
     6.045   116.152     0.150
     7.793   247.566     0.150
     8.453   259.691     0.150
    11.137   159.922     0.150
     0.219     7.523     0.150
     1.098    19.904     0.150
     1.098    33.273     0.150
     1.376    22.904     0.150
     1.553    49.648     0.150
     1.930    32.344     0.150
     1.930    36.054     0.150
     2.270    37.284     0.150
     2.270    41.764     0.150
     2.477    41.494     0.150
     2.477    69.834     0.150
     2.477    41.494     0.150
     2.477    69.834     0.150
     2.478    70.554     0.150
     3.034    55.943     0.150
     3.034    94.054     0.150
     4.716    86.754     0.150
     4.716   145.544     0.150
     4.838    88.284     0.150
     4.838   148.304     0.150
     4.862    89.454     0.150
     4.990    90.504     0.150
     5.644   170.693     0.150
     5.794   105.954     0.150
     5.794   179.924     0.150
     6.156   191.934     0.150
     7.053   129.854     0.150
     7.234   125.374     0.150
     7.397   232.254     0.150
     9.193   139.523     0.150
     9.703   302.165     0.150
     9.960   151.693     0.150
    10.939   164.644     0.150
    10.985   158.594     0.150
    11.061   164.404     0.150
    11.463   176.273     0.150
    11.564   171.084     0.150
    11.624   361.703     0.150
    11.747   173.574     0.150
    12.041   180.674     0.150
    12.310   175.454     0.150
    12.731   199.374     0.150
    13.199   186.733     0.150
    13.551   201.644     0.150
    13.717   191.664     0.150
    26.333   336.004     0.150
    28.959   359.924     0.150
     0.114     3.375     0.150
     0.114     3.531     0.150
     0.167     4.062     0.150
     0.192     5.648     0.150
     0.192     4.070     0.150
     0.314     6.961     0.150
     0.314     6.930     0.150
     0.641    12.086     0.150
     0.711    13.297     0.150
     0.771    14.492     0.150
     0.910    16.703     0.150
     0.922    16.391     0.150
     0.928    17.094     0.150
     1.115    39.117     0.150
     1.280    22.945     0.150
     1.330    23.891     0.150
     1.417    48.133     0.150
     1.447    25.375     0.150
     1.447    23.797     0.150
     1.447    25.406     0.150
     1.526    26.305     0.150
     1.679    27.250     0.150
     1.892    62.375     0.150
     1.892    31.562     0.150
     1.892    31.516     0.150
     1.892    62.414     0.150
     2.147    34.133     0.150
     2.525    40.125     0.150
     2.525    70.586     0.150
     2.555    41.336     0.150
     2.768    44.414     0.150
     2.768    86.992     0.150
     2.988    47.000     0.150
     3.524    54.875     0.150
     3.892    60.391     0.150
     4.680    71.023     0.150
     4.680    71.562     0.150
     4.771    73.453     0.150
     4.932    71.930     0.150
     4.932   130.086     0.150
     5.017    76.656     0.150
     5.207   144.625     0.150
     5.207    96.727     0.150
     5.207   144.625     0.150
     5.585    83.781     0.150
     6.169    92.266     0.150
     6.367    97.062     0.150
     7.007   185.766     0.150
     7.020   178.070     0.150
     7.020   104.320     0.150
     7.020   178.070     0.150
     7.106   107.195     0.150
     7.106   183.703     0.150
     7.376   108.641     0.150
     7.448   111.117     0.150
     7.858   113.812     0.150
     7.858   202.992     0.150
     8.140   120.641     0.150
     8.456   262.359     0.150
     8.456   262.367     0.150
     8.624   130.977     0.150
     8.624   130.992     0.150
     8.849   129.797     0.150
     9.154   136.375     0.150
     9.154   136.383     0.150
     9.413   143.406     0.150
     9.647   294.586     0.150
     9.647   145.930     0.150
     9.647   294.594     0.150
    10.689   163.711     0.150
    10.753   338.445     0.150
    10.812   157.945     0.150
    11.361   162.414     0.150
    11.355   169.711     0.150
    11.695   167.820     0.150
    11.781   280.875     0.150
    11.914   176.992     0.150
    12.056   178.891     0.150
    12.222   181.094     0.150
    12.297   181.477     0.150
    12.334   187.172     0.150
    12.334   187.195     0.150
    12.509   184.977     0.150
    12.509   184.953     0.150
    12.670   187.016     0.150
    12.722   186.570     0.150
    13.171   193.273     0.150
    13.914   201.773     0.150
    14.424   205.430     0.150
    14.475   207.672     0.150
    14.743   208.672     0.150
    14.835   471.820     0.150
    15.445   222.023     0.150
    17.921   251.047     0.150
    19.037   263.242     0.150
    19.919   272.625     0.150
    21.832   294.203     0.150
    22.472   301.312     0.150
    22.632   303.172     0.150
    23.621   311.836     0.150
    23.734   313.742     0.150
    24.764   323.953     0.150
    26.981   342.875     0.150
    27.058   347.945     0.150
    27.508   347.883     0.150
    27.784   354.945     0.150
    29.017   361.242     0.150
    29.190   362.961     0.150
    29.566   366.727     0.150
    33.797   403.906     0.150
    34.479   408.922     0.150
    34.580   412.234     0.150
    34.721   413.016     0.150
    34.928   415.172     0.150
    35.087   415.750     0.150
    36.145   424.633     0.150
    36.212   426.195     0.150
    36.270   425.031     0.150
    36.387   426.516     0.150
    36.605   428.234     0.150
    36.990   435.094     0.150
    36.990   435.094     0.150
    37.465   439.250     0.150
    42.679   477.477     0.150
    42.679   477.477     0.150
    42.708   482.594     0.150
    48.632   529.570     0.150
    49.006   529.570     0.150
    50.323   537.375     0.150
    54.657   699.273     0.150
    54.904   572.273     0.150
    58.920  1081.773     0.150
    59.522   602.875     0.150
    59.751  1090.875     0.150
    61.169   623.570     0.150
    64.065   637.312     0.150
    64.604  1154.070     0.150
    71.083   693.070     0.150
    71.083   935.375     0.150
    71.840   685.711     0.150
    72.991  1254.773     0.150
    73.745   699.281     0.150
    76.524   993.977     0.150
    76.690   716.773     0.150
    77.170   718.375     0.150
    79.326   734.273     0.150
    80.698   733.906     0.150
    81.451   742.461     0.150
    81.529   742.875     0.150
    81.788   740.773     0.150
    81.788   740.773     0.150
    81.788   746.977     0.150
    81.858     3.297     0.150
    82.173   746.680     0.150
    82.469   750.977     0.150
    82.905   750.867     0.150
    84.039   753.352     0.150
    84.646   758.977     0.150
    84.673   760.375     0.150
    84.673   760.375     0.150
    84.673   760.367     0.150
    84.673    -0.492     0.150
    84.673   762.977     0.150
    84.673   771.172     0.150
    84.673  1385.773     0.150
    84.673  1385.773     0.150
    84.673  1724.773     0.150
    84.862   761.977     0.150
    85.148   763.672     0.150
    85.148   763.672     0.150
    86.428   771.172     0.150
    86.428   771.164     0.150
    86.577   771.875     0.150
    86.577   771.820     0.150
    86.849   771.203     0.150
    86.996   775.273     0.150
    87.008   772.352     0.150
    87.476   773.672     0.150
    90.097   790.273     0.150
    90.097   790.266     0.150
    90.405   787.875     0.150
    90.405  1001.477     0.150
    90.405  1418.172     0.150
    90.412   792.672     0.150
    90.938   785.102     0.150
    90.984   788.273     0.150
    91.052  1012.500     0.150
    92.319   796.672     0.150
    92.319   796.672     0.150
    92.665   797.570     0.150
    93.680   802.773     0.150
    95.170   808.461     0.150
    98.377   823.875     0.150
    98.377   823.820     0.150
   100.022   825.773     0.150
   100.947   837.422     0.150
   105.127  1116.023     0.150
   129.100  1135.633     0.150
   143.337  1175.391     0.150
   145.775  1179.273     0.150
   145.775  1179.312     0.150
   145.775  1182.297     0.150
   146.020  1182.133     0.150
   148.537  1193.117     0.150
     0.583    12.031     0.150
     0.593    11.180     0.150
     0.593    19.023     0.150
     0.593    18.859     0.150
     0.944    33.766     0.150
     0.944    34.164     0.150
     0.987    17.367     0.150
     1.585    49.430     0.150
     2.150    36.594     0.150
     2.159    75.625     0.150
     2.237    71.445     0.150
     3.405   101.445     0.150
     5.002    91.578     0.150
     5.186    82.547     0.150
     5.580   100.625     0.150
     5.580   172.727     0.150
     5.580   100.625     0.150
     5.580   172.727     0.150
     7.592   136.930     0.150
     7.681   122.336     0.150
    15.885   217.391     0.150
    36.603   424.008     0.150
     0.376    12.328     0.150
     0.569     5.703     0.150
     0.569    11.152     0.150
     0.480     9.773     0.150
     1.037    19.422     0.150
     1.344    41.594     0.150
     1.507    48.812     0.150
     1.644    52.051     0.150
     1.986    62.336     0.150
     2.024    59.180     0.150
     2.361    38.551     0.150
     2.361    43.863     0.150
     2.361    46.281     0.150
     2.470    78.094     0.150
     2.958    93.332     0.150
     3.049    55.652     0.150
     3.049    91.152     0.150
     4.463    67.691     0.150
     5.035    71.703     0.150
     5.035   124.051     0.150
     5.148   155.594     0.150
     6.698    94.242     0.150
     6.812   209.711     0.150
     6.841    92.973     0.150
     7.227   222.473     0.150
     7.398   107.793     0.150
     7.426   106.871     0.150
     7.515   232.242     0.150
     7.664   107.941     0.150
     8.148   117.223     0.150
     8.162   118.043     0.150
     0.219     4.797     0.150
     0.583    11.320     0.150
     0.659    34.344     0.150
     1.154    41.336     0.150
     1.176    40.812     0.150
     1.991    56.242     0.150
     2.566    38.891     0.150
     5.263    80.922     0.150
     6.345    91.023     0.150
     7.694   124.328     0.150
     7.800   139.703     0.150
    11.661   167.062     0.150
    11.957   168.781     0.150
    12.517   183.781     0.150
     0.330    10.680     0.150
     1.156    19.160     0.150
     1.212    69.590     0.150
     1.587    26.922     0.150
     1.587    27.031     0.150
     1.805    28.633     0.150
     1.806    53.555     0.150
     1.806    53.961     0.150
     1.928    59.789     0.150
     1.928    30.371     0.150
     1.928    34.852     0.150
     1.974    36.430     0.150
     2.294    36.051     0.150
     3.266    51.020     0.150
     3.897    70.723     0.150
     4.738    83.520     0.150
     4.851    73.320     0.150
     5.383    78.402     0.150
     5.383    94.371     0.150
     6.034   109.930     0.150
     7.844   147.500     0.150
     0.437     8.406     0.150
     0.451     8.320     0.150
     0.446     8.930     0.150
     0.613    11.359     0.150
     0.613    19.242     0.150
     0.754    14.453     0.150
     0.754    19.141     0.150
     0.754    14.453     0.150
     0.754    19.141     0.150
     1.036    37.203     0.150
     1.036    39.742     0.150
     1.036    42.438     0.150
     1.036    20.727     0.150
     1.116    30.102     0.150
     1.250    21.367     0.150
     1.670    27.703     0.150
     1.670    32.281     0.150
     2.086    35.438     0.150
     2.086    35.438     0.150
     2.086    58.203     0.150
     2.323    42.906     0.150
     2.323    42.812     0.150
     3.427    61.422     0.150
     3.931    72.398     0.150
     3.931    78.453     0.150
     5.134    91.008     0.150
     5.361    83.062     0.150
     7.703   117.469     0.150
    10.011   150.023     0.150
     0.212     4.773     0.150
     0.212     8.125     0.150
     0.364     7.273     0.150
     0.551    10.633     0.150
     0.556    10.125     0.150
     0.554    21.773     0.150
     0.737    13.750     0.150
     0.737    23.812     0.150
     1.020    17.695     0.150
     1.092    20.680     0.150
     1.092    34.727     0.150
     1.127    20.164     0.150
     1.127    34.992     0.150
     1.105    21.594     0.150
     1.179    22.625     0.150
     1.182    20.125     0.150
     1.182    21.977     0.150
     1.311    22.141     0.150
     1.311    24.250     0.150
     1.443    27.406     0.150
     1.884    30.766     0.150
     1.884    56.930     0.150
     2.812    86.289     0.150
     3.577    59.391     0.150
     4.047    64.625     0.150
     5.537    77.586     0.150
     7.182   110.727     0.150
     0.350     6.656     0.150
     1.014    32.270     0.150
     1.371    23.867     0.150
     1.364    26.207     0.150
     1.364    23.637     0.150
     1.565    49.480     0.150
     1.588    50.355     0.150
     1.832    58.035     0.150
     2.257    69.094     0.150
     2.430    74.027     0.150
     3.087    49.637     0.150
     5.652    82.086     0.150
     7.141   105.035     0.150
     8.091   142.031     0.150
    10.293   147.980     0.150
     0.337    10.361     0.150
     0.338    10.421     0.150
     0.618     6.712     0.150
     0.757    24.914     0.150
     0.777    17.531     0.150
     0.901    11.608     0.150
     0.901    17.117     0.150
     0.944    30.381     0.150
     1.028    32.808     0.150
     1.142    22.601     0.150
     1.236    23.451     0.150
     1.305    24.461     0.150
     1.366    26.501     0.150
     1.367    26.011     0.150
     1.367    22.621     0.150
     1.602    50.339     0.150
     1.605    30.071     0.150
     1.950    36.931     0.150
     2.014    37.801     0.150
     2.631    75.451     0.150
     4.284    68.901     0.150
     4.521    81.071     0.150
     5.354    94.781     0.150
     5.408    84.891     0.150
     5.408   151.021     0.150
     5.610   165.861     0.150
     5.639   171.641     0.150
     6.814   123.681     0.150
     7.093   127.011     0.150
     7.093   230.671     0.150
     7.326   236.001     0.150
     7.496   143.781     0.150
    10.491   151.001     0.150
    11.287   284.661     0.150
    11.550   299.941     0.150
    12.279   308.731     0.150
     0.440     8.645     0.150
     0.673    21.523     0.150
     0.768    15.781     0.150
     0.768    26.652     0.150
     0.768    26.742     0.150
     0.786    15.012     0.150
     0.800    16.434     0.150
     0.800    27.973     0.150
     1.025    36.023     0.150
     1.025    36.074     0.150
     1.031    33.082     0.150
     1.175    20.422     0.150
     1.296    59.293     0.150
     1.637    27.094     0.150
     2.036    37.262     0.150
     2.173    66.074     0.150
     2.290    34.602     0.150
     4.625    65.781     0.150
     4.902    77.715     0.150
     5.057    79.082     0.150
     5.064    80.133     0.150
     5.307    90.824     0.150
     5.371    78.305     0.150
     6.230   108.562     0.150
     6.230   166.953     0.150
     7.528   203.984     0.150
     7.611   203.422     0.150
    15.024   372.043     0.150
     0.202     4.621     0.150
     0.584    11.496     0.150
     0.633    11.457     0.150
     0.698    16.098     0.150
     0.698    15.617     0.150
     0.698    24.426     0.150
     0.698    15.617     0.150
     0.698    24.426     0.150
     1.140    21.727     0.150
     1.159    20.359     0.150
     1.159    34.996     0.150
     1.753    50.426     0.150
     1.903    36.117     0.150
     1.910    61.586     0.150
     1.979    34.078     0.150
     1.979    34.078     0.150
     1.979    57.348     0.150
     2.113    39.949     0.150
     2.186    41.195     0.150
     2.336    42.066     0.150
     2.371    43.500     0.150
     2.485    81.238     0.150
     7.815   138.645     0.150
     7.815   240.219     0.150
    10.819   340.496     0.150
    10.846   331.871     0.150
     0.592    11.250     0.150
     0.592    19.359     0.150
     0.621    13.680     0.150
     0.621    11.305     0.150
     0.646    31.375     0.150
     1.131    21.445     0.150
     2.492    45.727     0.150
     4.095    60.523     0.150
     4.268    62.844     0.150
     4.720    75.188     0.150
     4.910    77.555     0.150
     5.268    81.328     0.150
     5.362    84.812     0.150
     5.575    84.273     0.150
     6.352    97.477     0.150
     7.315   114.109     0.150
     7.803   146.055     0.150
     7.842   109.812     0.150
    10.834   355.586     0.150
     0.215     4.750     0.150
     0.369     6.508     0.150
     0.595    11.430     0.150
     0.595    19.406     0.150
     0.621    20.148     0.150
     0.650    29.289     0.150
     0.650    48.086     0.150
     0.695    16.359     0.150
     0.695    12.891     0.150
     0.995    18.664     0.150
     1.171    20.141     0.150
     1.171    36.211     0.150
     1.536    30.500     0.150
     1.669    29.891     0.150
     1.751    50.969     0.150
     1.981    32.281     0.150
     1.981    55.055     0.150
     2.323    45.789     0.150
     2.395    44.430     0.150
     2.464    45.102     0.150
     2.611    48.938     0.150
     3.006    91.602     0.150
     3.328   100.188     0.150
     3.422   104.898     0.150
     4.909    75.859     0.150
     5.828   111.336     0.150
     7.484   129.969     0.150
     7.802   232.531     0.150
     9.132   129.125     0.150
    10.836   345.477     0.150
    12.911   181.070     0.150
    15.262   492.836     0.150
    24.481   322.203     0.150
    37.086   433.898     0.150
     0.211     4.602     0.150
     0.364     7.945     0.150
     0.624    11.594     0.150
     0.624    11.523     0.150
     0.591    11.586     0.150
     0.650    39.672     0.150
     0.937   277.094     0.150
     0.941    22.781     0.150
     0.944    17.867     0.150
     0.944    17.891     0.150
     0.991    23.188     0.150
     1.133    21.453     0.150
     1.167    20.797     0.150
     1.167    36.703     0.150
     1.298    24.883     0.150
     1.539    27.484     0.150
     1.980    32.336     0.150
     1.980    59.055     0.150
     1.981    32.047     0.150
     1.981    58.523     0.150
     2.328    42.781     0.150
     2.393    45.305     0.150
     2.414    37.234     0.150
     2.493    41.703     0.150
     2.462    45.438     0.150
     2.487    45.195     0.150
     2.487    45.195     0.150
     3.484    56.336     0.150
     3.644    55.297     0.150
     3.709    60.211     0.150
     4.099    61.992     0.150
     4.269    67.562     0.150
     4.334    68.625     0.150
     4.408    68.617     0.150
     4.715    75.367     0.150
     4.913    75.438     0.150
     5.271    83.312     0.150
     5.712    89.867     0.150
     5.786    91.250     0.150
     5.829   111.547     0.150
     6.118    98.086     0.150
     6.126    96.367     0.150
     6.099    93.102     0.150
     6.099    93.094     0.150
     6.302   100.156     0.150
     6.348    95.094     0.150
     6.352    95.695     0.150
     6.378    99.516     0.150
     6.645   104.102     0.150
     6.832   134.672     0.150
     6.832   206.641     0.150
     6.870   107.875     0.150
     7.069   111.727     0.150
     7.179   111.805     0.150
     7.291   111.750     0.150
     7.314   109.594     0.150
     7.462   114.164     0.150
     7.486   116.727     0.150
     7.515   114.734     0.150
     7.514   115.422     0.150
     7.505   112.195     0.150
     7.527   107.297     0.150
     7.534   115.094     0.150
     7.554   115.391     0.150
     7.571   117.312     0.150
     7.595   117.125     0.150
     7.691   117.273     0.150
     7.806   245.367     0.150
     8.080   125.625     0.150
     8.080   125.594     0.150
     8.504   128.867     0.150
     9.012   133.594     0.150
     9.696   139.297     0.150
     9.707   146.234     0.150
    10.020   148.820     0.150
    10.483   153.891     0.150
    10.483   148.352     0.150
    10.555   150.875     0.150
    10.815   153.914     0.150
    10.990   163.023     0.150
    10.990   156.055     0.150
    11.174   161.516     0.150
    11.883   173.891     0.150
    11.969   177.500     0.150
    12.721   187.141     0.150
    12.913   187.891     0.150
    12.913   184.516     0.150
    13.024   185.969     0.150
    13.611   199.047     0.150
    13.657   194.195     0.150
    13.839   195.859     0.150
    14.054   200.797     0.150
    14.267   201.891     0.150
    15.264   217.797     0.150
    17.112   238.492     0.150
    18.343   255.797     0.150
    18.958   259.414     0.150
    19.736   274.797     0.150
    19.791   276.906     0.150
    19.868   277.102     0.150
    20.398   277.391     0.150
    21.012   282.086     0.150
    21.032   284.891     0.150
    21.065   284.086     0.150
    21.782   291.992     0.150
    21.782   291.898     0.150
    22.195   295.195     0.150
    22.528   715.695     0.150
    23.018   301.914     0.150
    23.056   301.852     0.150
    23.058   300.547     0.150
    23.102   300.938     0.150
    23.170   301.367     0.150
    23.296   303.883     0.150
    23.385   303.953     0.150
    23.474   306.641     0.150
    23.716   310.992     0.150
    23.844   316.914     0.150
    24.203   321.797     0.150
    24.301   315.586     0.150
    24.301   315.594     0.150
    27.015   344.492     0.150
    32.971   401.297     0.150
    34.395   403.805     0.150
    35.632   424.414     0.150
    36.096   428.773     0.150
    36.123   424.094     0.150
    37.458   440.281     0.150
    37.458   440.297     0.150
    38.493   448.516     0.150
    47.772   517.992     0.150
    54.990   573.492     0.150
    56.876  4178.594     0.150
    58.824  1088.695     0.150
    64.260   628.695     0.150
    73.412   689.297     0.150
    73.814   700.992     0.150
    73.814   973.297     0.150
    73.814  1273.195     0.150
    79.916  1361.797     0.150
    79.916  1659.391     0.150
    81.275  1639.195     0.150
    84.634   751.094     0.150
    84.634  1927.094     0.150
    84.634  2095.094     0.150
    84.634  1386.094     0.150
    84.759   754.352     0.150
    85.351   761.492     0.150
    87.848   764.547     0.150
    89.008  1103.797     0.150
    89.028   772.438     0.150
    90.756  1003.695     0.150
    94.123   797.734     0.150
   100.626   834.094     0.150
   100.855   834.195     0.150
   101.981   844.094     0.150
   132.917  1128.695     0.150
   145.374  1179.797     0.150
     0.202     4.219     0.150
     0.579    10.984     0.150
     0.591    26.500     0.150
     0.636    39.766     0.150
     0.628    10.320     0.150
     0.628    19.469     0.150
     0.648    11.977     0.150
     1.145    21.250     0.150
     1.155    21.070     0.150
     1.155    36.086     0.150
     1.294    22.984     0.150
     1.964    33.625     0.150
     1.964    33.625     0.150
     2.336    41.805     0.150
     5.164    73.953     0.150
     5.683    82.539     0.150
     5.727    82.914     0.150
     5.765   177.445     0.150
    10.831   154.266     0.150
    11.985   167.961     0.150
     0.231     5.359     0.150
     0.246     5.469     0.150
     0.533    10.281     0.150
     0.533    17.844     0.150
     0.545    10.688     0.150
     0.668    11.992     0.150
     1.108    19.898     0.150
     1.108    19.898     0.150
     1.108    34.523     0.150
     1.254    27.547     0.150
    27.249   342.328     0.150
     0.212     4.594     0.150
     0.653    32.320     0.150
     0.653    49.859     0.150
     0.698    12.789     0.150
     0.698    21.945     0.150
     0.935   330.812     0.150
     1.107    19.742     0.150
     1.169    21.586     0.150
     1.169    21.586     0.150
     1.169    36.055     0.150
     1.299    22.250     0.150
     1.617    47.312     0.150
     1.983    56.602     0.150
     1.983    32.391     0.150
     1.983    56.602     0.150
     2.392    38.109     0.150
     2.484    39.016     0.150
     2.484    73.914     0.150
     2.484    38.945     0.150
     2.502    38.727     0.150
     3.063    88.023     0.150
     3.325    92.414     0.150
     3.529    52.922     0.150
     3.557    99.984     0.150
     3.557    54.016     0.150
     3.557   100.016     0.150
     3.588    53.969     0.150
     3.641    55.312     0.150
     4.099    60.312     0.150
     4.099    60.273     0.150
     5.411    86.266     0.150
     5.826   111.734     0.150
     6.097    93.391     0.150
     6.097    93.414     0.150
     6.123    91.914     0.150
     6.349    93.914     0.150
     7.066   109.336     0.150
     7.311   108.812     0.150
     7.335   112.445     0.150
     7.348   113.180     0.150
     7.502   110.914     0.150
     7.805   145.305     0.150
     7.805   244.336     0.150
     7.805   114.914     0.150
     7.835   110.422     0.150
     8.077   123.484     0.150
     8.077   123.516     0.150
     8.502   130.836     0.150
     8.720   125.445     0.150
     9.009   131.711     0.150
     9.262   142.680     0.150
     9.617   147.453     0.150
     9.704   147.234     0.150
    10.018   149.961     0.150
    10.188   153.812     0.150
    10.305   146.398     0.150
    10.372   156.133     0.150
    10.481   154.109     0.150
    10.481   149.805     0.150
    10.548   158.734     0.150
    10.558   158.086     0.150
    10.987   164.766     0.150
    11.535   171.602     0.150
    11.681   171.570     0.150
    11.879   176.109     0.150
    11.879   176.109     0.150
    12.052   181.086     0.150
    12.525   175.773     0.150
    12.538   186.625     0.150
    12.910   188.516     0.150
    13.276   197.281     0.150
    13.385   198.312     0.150
    13.403   193.984     0.150
    13.657   196.414     0.150
    13.901   202.484     0.150
    14.053   200.812     0.150
    14.264   202.711     0.150
    14.505   210.109     0.150
    15.261   490.336     0.150
    15.261   218.031     0.150
    15.261   490.336     0.150
    15.261   218.016     0.150
    15.261   217.898     0.150
    15.570   222.016     0.150
    17.112   242.711     0.150
    18.083   253.422     0.150
    18.342   255.914     0.150
    18.488   261.016     0.150
    18.491   260.836     0.150
    18.715   263.680     0.150
    19.353   270.406     0.150
    19.425   271.180     0.150
    19.551   273.164     0.150
    19.736   277.312     0.150
    20.396   279.016     0.150
    21.031   287.109     0.150
    21.058   290.461     0.150
    21.058   283.453     0.150
    21.249   288.531     0.150
    21.255   288.516     0.150
    21.638   297.516     0.150
    21.781   293.016     0.150
    22.192   296.812     0.150
    22.192   296.852     0.150
    22.525   717.359     0.150
    22.525   717.359     0.150
    22.525   300.812     0.150
    22.916   309.812     0.150
    23.017   309.211     0.150
    23.294   313.484     0.150
    23.606   315.109     0.150
    23.712   312.016     0.150
    23.733   316.562     0.150
    23.926   319.750     0.150
    24.299   318.016     0.150
    24.593   326.766     0.150
    24.791   326.266     0.150
    25.100   328.984     0.150
    25.523   333.336     0.150
    27.013   343.195     0.150
    27.062   348.875     0.150
    27.105   347.531     0.150
    29.343   365.430     0.150
    30.919   382.195     0.150
    31.043   383.461     0.150
    32.968   398.414     0.150
    33.707   408.305     0.150
    33.847   409.086     0.150
    35.265   421.570     0.150
    35.382   421.211     0.150
    35.618   424.375     0.150
    35.784   422.109     0.150
    36.797   429.211     0.150
    46.354   513.234     0.150
    46.774   521.875     0.150
    47.774   531.625     0.150
    47.774   519.609     0.150
    47.774   531.609     0.150
    47.781   944.109     0.150
    48.138   531.172     0.150
    54.987   573.109     0.150
    54.987   573.109     0.150
    64.718  1165.812     0.150
    64.995   640.516     0.150
    66.769   656.266     0.150
    66.769   656.312     0.150
    68.401   667.203     0.150
    73.410   695.609     0.150
    73.812   703.914     0.150
    73.812   969.711     0.150
    73.812  1738.016     0.150
    80.583   733.812     0.150
    80.940   736.516     0.150
    82.379   743.914     0.150
    84.342   756.016     0.150
    84.631  1435.812     0.150
    84.631  1723.812     0.150
    84.631  1927.812     0.150
    84.631  2089.812     0.150
    85.348   759.055     0.150
    85.348   759.016     0.150
    88.303   773.812     0.150
    89.005   776.312     0.150
    89.005   988.016     0.150
    89.005  1103.516     0.150
    89.005  1777.914     0.150
    90.118   774.914     0.150
    90.752  1798.109     0.150
    91.595   788.109     0.150
    94.590  1852.812     0.150
    98.737  1184.109     0.150
   100.623   834.312     0.150
   101.978   842.109     0.150
   101.978  1082.312     0.150
   101.978  1535.812     0.150
   101.978  1963.312     0.150
   117.092  1126.812     0.150
   128.124  1135.820     0.150
   128.124  1135.812     0.150
   145.377  1179.344     0.150
   145.377  1179.312     0.150
     0.233     5.062     0.150
     0.610    11.258     0.150
     0.616    11.719     0.150
     1.108    19.258     0.150
     1.191    41.867     0.150
     1.716    49.867     0.150
     1.731    50.703     0.150
     1.889    57.609     0.150
     2.394    41.555     0.150
     2.464    44.758     0.150
     3.065    56.672     0.150
     3.065    94.328     0.150
     3.552    58.805     0.150
     5.352    86.953     0.150
     5.355    85.766     0.150
     6.064    97.617     0.150
     6.096    94.055     0.150
     6.290   100.594     0.150
     6.631   178.586     0.150
     6.857   108.539     0.150
     6.857   190.164     0.150
     7.114   101.234     0.150
     7.324   114.188     0.150
     7.376   194.203     0.150
     7.436   114.086     0.150
     7.484   104.898     0.150
     7.489   116.844     0.150
     7.529   114.859     0.150
     8.114   123.516     0.150
     9.110   138.516     0.150
     9.246   141.492     0.150
    11.413   172.062     0.150
    12.975   194.133     0.150
    21.296   291.062     0.150
    27.203   345.805     0.150
    35.370   424.977     0.150
     0.168     3.734     0.150
     0.168     6.664     0.150
     0.536    10.438     0.150
     0.611    33.047     0.150
     0.611    37.562     0.150
     0.657    11.672     0.150
     0.947    17.125     0.150
     0.947    28.969     0.150
     0.954    35.633     0.150
     0.957    35.367     0.150
     0.957    16.688     0.150
     1.112    46.688     0.150
     1.074    18.312     0.150
     1.805    31.062     0.150
     1.966    33.594     0.150
     3.069   100.445     0.150
     3.540    56.828     0.150
     5.725    87.734     0.150
     5.868   113.133     0.150
     7.573   115.617     0.150
     7.580   115.859     0.150
     7.849   114.906     0.150
     7.838   119.047     0.150
    10.764   158.938     0.150
     0.609    11.602     0.150
     0.610    11.148     0.150
     0.698    24.141     0.150
     0.698    12.578     0.150
     0.698    24.141     0.150
     0.746    14.203     0.150
     0.946    17.789     0.150
     1.008    17.930     0.150
     1.184    20.867     0.150
     1.184    20.867     0.150
     1.184    36.883     0.150
     1.115    19.219     0.150
     1.620    54.859     0.150
     1.989    32.320     0.150
     1.989    58.078     0.150
     2.915    44.570     0.150
     3.942    60.211     0.150
     3.992    59.305     0.150
     4.086    60.062     0.150
     4.721    75.641     0.150
     5.363    86.039     0.150
     5.782    91.414     0.150
     6.075    95.602     0.150
     6.868   105.891     0.150
     7.472   113.469     0.150
     7.790   112.492     0.150
     8.080   122.930     0.150
     8.506   126.922     0.150
    10.002   141.883     0.150
    10.361   147.852     0.150
    10.828   338.195     0.150
    12.900   183.227     0.150
    13.009   184.336     0.150
    13.828   195.375     0.150
    14.250   204.773     0.150
    14.722   212.898     0.150
    18.165   254.883     0.150
    19.612   268.469     0.150
    21.233   287.414     0.150
    22.246   295.758     0.150
    23.352   308.477     0.150
    24.232   316.352     0.150
    24.477   319.977     0.150
    26.997   341.039     0.150
    35.425   419.070     0.150
     0.234     5.109     0.150
     0.234     7.650     0.150
     0.613    11.719     0.150
     0.603    11.104     0.150
     0.651    49.420     0.150
     0.694    12.531     0.150
     0.694    22.641     0.150
     0.948   223.131     0.150
     0.955    17.070     0.150
     1.111    19.305     0.150
     1.189    41.420     0.150
     1.189    20.941     0.150
     1.189    20.941     0.150
     1.189    37.480     0.150
     1.988    56.361     0.150
     1.988    32.051     0.150
     1.988    56.361     0.150
     1.989    30.311     0.150
     1.989    44.021     0.150
     2.488    38.844     0.150
     2.550    38.539     0.150
     3.944    60.205     0.150
     4.080   127.381     0.150
     4.080    60.131     0.150
     4.247    77.391     0.150
     4.247   145.170     0.150
     5.248    78.824     0.150
     6.357   197.061     0.150
     6.376    88.211     0.150
     6.646   104.400     0.150
     7.116   229.441     0.150
     7.339   114.631     0.150
     7.355   109.420     0.150
     7.500   231.012     0.150
     8.512   212.801     0.150
    10.196   153.762     0.150
    10.378   334.879     0.150
    10.378   334.881     0.150
    11.957   176.980     0.150
    12.800   188.551     0.150
    13.605   198.801     0.150
    21.195   289.682     0.150
    63.922   634.400     0.150
    85.450   748.932     0.150
    92.328   786.230     0.150
   100.624   836.432     0.150
   122.045  1141.006     0.150
     0.194     4.340     0.150
     0.573    10.957     0.150
     0.643    40.199     0.150
     1.148    20.562     0.150
     1.148    20.562     0.150
     1.148    36.359     0.150
     1.968    56.641     0.150
     5.835   113.047     0.150
     5.835   190.195     0.150
     7.560   112.020     0.150
     7.823   120.340     0.150
     7.823   148.742     0.150
     7.823   148.742     0.150
     7.823   245.941     0.150
    10.848   158.820     0.150
    10.832   351.270     0.150
    10.848   158.820     0.150
    10.848   345.219     0.150
     0.189     4.288     0.150
     0.571    10.905     0.150
     0.584    21.233     0.150
     0.584    21.313     0.150
     0.645    11.638     0.150
     0.933    16.797     0.150
     0.970    17.613     0.150
     1.153    22.113     0.150
     1.146    20.783     0.150
     1.146    20.783     0.150
     1.146    36.583     0.150
     1.973    32.333     0.150
     1.973    58.863     0.150
     2.349    66.493     0.150
     2.380    67.973     0.150
     2.448    68.963     0.150
     2.486    71.773     0.150
     3.305    48.923     0.150
     4.118    58.623     0.150
     4.118   105.913     0.150
     4.290   110.633     0.150
     5.292    82.363     0.150
     5.828   112.818     0.150
     6.088   109.073     0.150
     6.142    95.653     0.150
     7.566   114.973     0.150
     7.828   144.983     0.150
     7.828   242.813     0.150
     7.835   112.583     0.150
     8.150   123.543     0.150
     8.643   131.093     0.150
     9.024   136.633     0.150
     9.235   138.263     0.150
    10.371   158.581     0.150
    10.371   334.151     0.150
    10.830   346.563     0.150
    11.067   157.903     0.150
    11.187   161.453     0.150
    11.452   164.793     0.150
     0.153     3.751     0.150
     0.409     7.787     0.150
     0.409    13.308     0.150
     0.444     8.256     0.150
     0.444    14.257     0.150
     0.449     8.721     0.150
     0.449    14.861     0.150
     0.656    11.542     0.150
     0.656    20.641     0.150
     0.761    13.991     0.150
     0.761    23.921     0.150
     1.047    49.531     0.150
     1.047    50.021     0.150
     1.127    20.491     0.150
     1.127    37.031     0.150
     1.671    53.886     0.150
     1.805    56.021     0.150
     1.881    63.961     0.150
     2.098    36.781     0.150
     2.098    62.832     0.150
     2.224    40.827     0.150
     2.536    71.552     0.150
     2.555    43.342     0.150
     3.182    51.941     0.150
     5.127    79.691     0.150
     6.001    95.161     0.150
     6.189    97.751     0.150
     6.432   101.851     0.150
     7.678   118.921     0.150
    11.096   165.292     0.150
     0.109     2.859     0.150
     0.109     4.734     0.150
     0.471     9.250     0.150
     0.471    15.516     0.150
     0.935    29.805     0.150
     1.241    37.289     0.150
     1.240    23.008     0.150
     1.291    24.156     0.150
     1.331    24.719     0.150
     1.441    26.758     0.150
     1.915    56.750     0.150
     1.920    60.492     0.150
     3.009    90.570     0.150
     3.946    71.820     0.150
     7.195   140.180     0.150
     7.959   144.484     0.150
     0.178     4.172     0.150
     0.384     7.305     0.150
     0.366     7.219     0.150
     0.420    18.086     0.150
     0.420    18.664     0.150
     0.475     9.273     0.150
     0.637    22.477     0.150
     0.637    11.992     0.150
     0.666    21.398     0.150
     0.666    12.688     0.150
     0.766    14.562     0.150
     0.766    24.852     0.150
     0.766    14.523     0.150
     0.766    30.016     0.150
     0.986    37.844     0.150
     0.986    38.953     0.150
     1.066    24.977     0.150
     1.066    46.273     0.150
     1.066    24.977     0.150
     1.066    46.273     0.150
     1.198    20.609     0.150
     1.198    20.586     0.150
     1.368    20.867     0.150
     1.629    26.984     0.150
     1.852    55.461     0.150
     1.973    36.586     0.150
     2.057    37.727     0.150
     2.057    64.586     0.150
     2.057    35.914     0.150
     2.058    64.586     0.150
     2.598    73.250     0.150
     2.615    74.680     0.150
     3.454    56.922     0.150
     3.750    69.211     0.150
     4.899    72.773     0.150
     5.484   175.734     0.150
     5.671    89.875     0.150
     5.671   103.258     0.150
     5.687    86.992     0.150
     5.807   186.625     0.150
     6.422   112.086     0.150
     8.365   253.594     0.150
    11.380   169.133     0.150
     0.624    11.465     0.150
     0.799    14.238     0.150
     0.915    16.496     0.150
     0.968    32.625     0.150
     0.968    33.457     0.150
     0.976    17.027     0.150
     1.211    40.586     0.150
     1.452    23.578     0.150
     1.452    23.652     0.150
     1.452    23.676     0.150
     1.499    26.578     0.150
     1.803    30.477     0.150
     1.803    30.426     0.150
     2.706    43.078     0.150
     2.706    43.117     0.150
     2.905    47.875     0.150
     3.430    53.676     0.150
     3.430    53.664     0.150
     4.593    69.777     0.150
     4.876    73.945     0.150
     4.930    71.578     0.150
     5.092    73.137     0.150
     5.209    78.828     0.150
     5.209    78.875     0.150
     5.519    82.977     0.150
     5.678    85.375     0.150
     5.797    86.180     0.150
     6.078    91.277     0.150
     6.528    97.246     0.150
     6.929   100.578     0.150
     7.281   106.375     0.150
     7.361   108.875     0.150
     7.635   112.176     0.150
     8.413   265.297     0.150
     8.413   122.059     0.150
     8.413   265.297     0.150
     8.557   123.535     0.150
     8.557   123.578     0.150
     8.590   121.406     0.150
     8.753   126.176     0.150
     8.964   127.758     0.150
     9.066   129.777     0.150
     9.527   136.301     0.150
     9.514   134.746     0.150
     9.576   293.945     0.150
     9.576   138.875     0.150
     9.576   144.078     0.150
     9.576   293.945     0.150
     9.951   143.207     0.150
    10.715   151.918     0.150
    10.736   151.875     0.150
    10.736   151.875     0.150
    10.890   154.855     0.150
    11.073   156.668     0.150
    11.159   157.406     0.150
    11.150   157.617     0.150
    11.339   160.258     0.150
    11.339   160.277     0.150
    11.914   169.957     0.150
    12.014   169.195     0.150
    12.049   170.785     0.150
    12.067   170.508     0.150
    12.626   179.898     0.150
    12.626   179.875     0.150
    14.337   202.676     0.150
    14.337   202.617     0.150
    14.464   204.176     0.150
    14.508   204.977     0.150
    14.705   207.277     0.150
    14.742   209.176     0.150
    17.908   246.977     0.150
    19.000   261.176     0.150
    20.935   283.777     0.150
    21.574   289.277     0.150
    22.433   298.777     0.150
    22.566   299.375     0.150
    23.621   308.984     0.150
    26.542   336.695     0.150
    27.502   345.406     0.150
    29.021   360.945     0.150
    36.182   422.078     0.150
    36.727   433.176     0.150
    54.584   636.375     0.150
    54.584   694.277     0.150
    54.584   762.777     0.150
    81.489   743.875     0.150
    83.937   753.277     0.150
    84.580   757.977     0.150
    85.295   762.777     0.150
    90.092   786.277     0.150
    90.311  1790.676     0.150
    93.589   795.027     0.150
    93.589   800.676     0.150
    93.768    10.602     0.150
     0.111     1.836     0.150
     1.634    27.023     0.150
     1.820    30.984     0.150
     1.931    35.906     0.150
     2.088    59.359     0.150
     2.254    70.492     0.150
     3.438    53.414     0.150
     7.292   103.445     0.150
     0.095     1.639     0.150
     0.663    11.522     0.150
     1.008    19.779     0.150
     1.039    18.218     0.150
     1.721    32.886     0.150
     2.229    42.231     0.150
     2.308    43.728     0.150
     2.311    43.585     0.150
     2.361    41.369     0.150
     2.371    44.627     0.150
     5.603   100.079     0.150
     6.695   117.719     0.150
     0.801    12.617     0.150
     0.801    22.035     0.150
     0.801    12.703     0.150
     0.801    22.578     0.150
     0.684    14.531     0.150
     0.684    24.906     0.150
     0.684    14.227     0.150
     0.684    25.086     0.150
     1.119    33.719     0.150
     1.119    33.805     0.150
     1.676    29.531     0.150
     1.619    31.770     0.150
     1.860    61.277     0.150
     1.899    37.668     0.150
     2.152    41.285     0.150
     2.198    42.781     0.150
     2.221    43.938     0.150
     2.241    72.066     0.150
     2.804    41.637     0.150
     4.426    66.945     0.150
     5.123    94.219     0.150
    11.050   340.832     0.150
     0.323     6.523     0.150
     0.709    12.930     0.150
     0.708    13.375     0.150
     0.708    23.086     0.150
     0.734    26.141     0.150
     0.734    26.172     0.150
     0.742    14.086     0.150
     0.868    37.266     0.150
     0.868    44.602     0.150
     1.064    19.438     0.150
     1.263    48.406     0.150
     1.745    29.992     0.150
     1.982    37.648     0.150
     2.203    41.312     0.150
     2.266    42.656     0.150
     2.271    43.086     0.150
     2.460    77.430     0.150
     4.195    63.125     0.150
     5.611    88.742     0.150
     5.611    99.805     0.150
     5.863   103.680     0.150
     7.507   113.359     0.150
     7.498   107.203     0.150
     9.171   137.109     0.150
    10.958   337.820     0.150
     0.265     9.213     0.150
     0.757    13.842     0.150
     0.757    23.633     0.150
     1.062    19.354     0.150
     1.062    32.822     0.150
     1.600    30.361     0.150
     1.600    50.455     0.150
     1.974    32.482     0.150
     1.974    36.672     0.150
     2.038    37.713     0.150
     2.279    42.922     0.150
     2.430    43.143     0.150
     2.431    74.523     0.150
     2.780    49.406     0.150
     3.325    53.822     0.150
     0.118     6.291     0.150
     0.443     8.641     0.150
     0.443    14.501     0.150
     0.478    14.646     0.150
     0.485    16.591     0.150
     0.708    13.341     0.150
     0.708    22.951     0.150
     0.844    15.711     0.150
     0.844    26.291     0.150
     0.863    16.331     0.150
     0.936    17.230     0.150
     1.024    18.911     0.150
     1.069    20.251     0.150
     1.069    34.631     0.150
     1.094    20.261     0.150
     1.156    21.480     0.150
     1.193    20.230     0.150
     1.207    22.181     0.150
     1.285    22.347     0.150
     1.285    22.351     0.150
     1.310    22.036     0.150
     1.364    23.707     0.150
     1.364    42.131     0.150
     1.511    26.610     0.150
     1.544    46.985     0.150
     2.351    72.946     0.150
     2.413    38.449     0.150
     5.415    79.121     0.150
     0.291     5.832     0.150
     0.354   507.551     0.150
     0.481     9.461     0.150
     0.676    12.332     0.150
     0.741    14.061     0.150
     0.821    15.330     0.150
     0.868    16.271     0.150
     0.880    16.412     0.150
     1.040    19.031     0.150
     1.250    23.482     0.150
     1.288    22.412     0.150
     1.389    25.852     0.150
     1.776    31.141     0.150
     2.299    43.232     0.150
     2.324    36.781     0.150
     2.501    47.586     0.150
     3.414    51.861     0.150
     6.142    95.912     0.150
    10.683   345.564     0.150
    10.922   353.287     0.150
    94.437   802.422     0.150
     0.074     1.794     0.150
     0.479    15.154     0.150
     0.479    15.372     0.150
     0.479     9.214     0.150
     0.479     9.204     0.150
     0.479    15.654     0.150
     0.555    11.054     0.150
     0.646    12.364     0.150
     0.646    21.114     0.150
     0.770    14.504     0.150
     0.779    13.474     0.150
     0.808    15.514     0.150
     0.808    26.394     0.150
     0.904    28.647     0.150
     0.904    16.834     0.150
     0.904    28.764     0.150
     0.929    17.404     0.150
     1.004    18.324     0.150
     1.025    19.084     0.150
     1.078    19.864     0.150
     1.088    20.214     0.150
     1.088    34.614     0.150
     1.280    22.624     0.150
     1.302    25.144     0.150
     1.309    23.024     0.150
     1.336    23.654     0.150
     1.375    25.154     0.150
     1.435    25.284     0.150
     1.657    29.874     0.150
     1.700    29.894     0.150
     3.015    48.394     0.150
     3.208    51.034     0.150
     4.690    69.514     0.150
     7.194   103.604     0.150
     0.085     3.480     0.150
     0.085     3.453     0.150
     0.469    15.473     0.150
     0.469     9.141     0.150
     0.469    15.797     0.150
     0.551    10.855     0.150
     0.636    12.270     0.150
     0.775    14.559     0.150
     0.811    15.754     0.150
     0.811    26.984     0.150
     0.916    29.172     0.150
     0.916    29.473     0.150
     0.941    17.688     0.150
     1.019    19.125     0.150
     1.019    32.547     0.150
     1.076    20.062     0.150
     1.076    34.777     0.150
     1.192    22.141     0.150
     1.268    22.496     0.150
     1.272    22.262     0.150
     1.300    22.840     0.150
     1.330    23.508     0.150
     1.364    25.094     0.150
     1.364    25.121     0.150
     1.407    26.180     0.150
     1.444    25.363     0.150
     1.509    27.512     0.150
     1.518    26.816     0.150
     1.646    30.371     0.150
     1.676    30.012     0.150
     1.883    31.977     0.150
     3.027    48.598     0.150
     3.343    51.293     0.150
     4.688    69.523     0.150
     7.978   144.121     0.150
     0.252     7.261     0.150
     0.701    13.276     0.150
     0.701    22.794     0.150
     0.703    12.733     0.150
     0.807    14.868     0.150
     0.859    15.849     0.150
     1.209    22.278     0.150
     1.250    21.475     0.150
     1.360    22.852     0.150
     1.520    25.726     0.150
     1.615    26.693     0.150
     1.696    27.740     0.150
     1.753    28.552     0.150
     1.815    31.559     0.150
     1.815    29.771     0.150
     2.007    37.488     0.150
     2.686    40.341     0.150
    10.946   340.977     0.150
     0.629    11.984     0.150
     0.629    12.055     0.150
     0.629    20.586     0.150
     1.026    19.141     0.150
     1.002    18.562     0.150
     1.051    18.820     0.150
     1.511    25.773     0.150
     1.420    23.836     0.150
     1.663    28.023     0.150
     1.658    27.867     0.150
     1.756    29.148     0.150
     1.981    32.961     0.150
     2.063    34.070     0.150
     2.169    34.742     0.150
     2.169    68.008     0.150
     2.614    42.016     0.150
     4.407    64.562     0.150
     4.559    69.211     0.150
     7.757   137.352     0.150
     0.509    15.434     0.150
     0.509     9.496     0.150
     1.334    23.484     0.150
     1.372    42.711     0.150
     1.470    45.508     0.150
     1.644    51.336     0.150
     3.022    47.543     0.150
     3.316    51.812     0.150
     4.500   137.738     0.150
     7.767   112.473     0.150
     9.009   279.082     0.150
    10.502   328.438     0.150
    21.743   289.082     0.150
     0.137     3.805     0.150
     0.178     3.955     0.150
     0.161    61.475     0.150
     0.167     6.674     0.150
     0.296     6.145     0.150
     0.296    10.365     0.150
     0.357     7.475     0.150
     0.357    12.475     0.150
     0.551    10.490     0.150
     0.551    10.484     0.150
     0.551    20.115     0.150
     0.551    24.145     0.150
     0.644    11.814     0.150
     0.686    22.814     0.150
     0.670    12.715     0.150
     0.738    13.365     0.150
     0.738    23.719     0.150
     0.738    13.355     0.150
     0.785    24.814     0.150
     0.785    25.645     0.150
     0.785    25.775     0.150
     0.781    14.324     0.150
     0.819    14.844     0.150
     0.819    29.004     0.150
     0.819    29.045     0.150
     0.842    15.562     0.150
     0.842    15.535     0.150
     0.832    15.045     0.150
     0.846    15.195     0.150
     0.858    27.490     0.150
     0.853    16.225     0.150
     0.852    15.914     0.150
     0.895    17.215     0.150
     0.895    17.164     0.150
     0.895    31.674     0.150
     0.911    16.105     0.150
     0.911    16.105     0.150
     0.927    16.584     0.150
     0.902    16.635     0.150
     0.931    17.875     0.150
     0.946    17.275     0.150
     1.022    18.945     0.150
     1.055    18.385     0.150
     1.142    37.844     0.150
     1.142    38.205     0.150
     1.170    20.045     0.150
     1.170    20.004     0.150
     1.406    22.984     0.150
     1.406    56.324     0.150
     1.406    63.484     0.150
     1.413    23.205     0.150
     1.415    23.674     0.150
     1.415    44.637     0.150
     1.498    47.986     0.150
     1.876    31.875     0.150
     2.581    40.494     0.150
     2.773    43.975     0.150
     3.407    50.865     0.150
     3.500    55.074     0.150
     3.904    60.105     0.150
     4.898    71.975     0.150
     5.197   166.453     0.150
     5.268    79.074     0.150
     5.588    83.475     0.150
     5.752    86.074     0.150
     7.351   233.125     0.150
     8.413   267.619     0.150
     8.413   122.490     0.150
    10.071   149.119     0.150
    10.506   152.174     0.150
    10.516   155.518     0.150
    10.841   159.332     0.150
    11.333   167.176     0.150
    11.523   170.162     0.150
    11.664   167.074     0.150
    12.091   177.014     0.150
    12.366   181.162     0.150
    14.382   203.875     0.150
    14.701   208.674     0.150
    14.701   208.688     0.150
    16.547   232.844     0.150
    17.611   247.564     0.150
    18.800   259.715     0.150
    20.193   275.863     0.150
    22.614   710.312     0.150
    22.614   299.875     0.150
    27.057   341.527     0.150
    28.974   359.455     0.150
    28.974   357.424     0.150
    33.132   393.932     0.150
    33.152   394.428     0.150
    34.083   401.807     0.150
    34.417   412.793     0.150
    34.577   407.271     0.150
    34.716   408.477     0.150
    34.981   410.297     0.150
    35.085   412.504     0.150
    36.230   421.223     0.150
    36.256   427.924     0.150
    36.800   424.270     0.150
    37.426   431.920     0.150
    40.462   461.750     0.150
    42.651   477.475     0.150
    43.196   476.689     0.150
    47.195   513.135     0.150
    48.334   514.094     0.150
    48.613   517.955     0.150
    50.286   541.270     0.150
    54.655   687.775     0.150
    54.869   571.674     0.150
    56.755  4183.076     0.150
    61.699   617.975     0.150
    65.815   644.875     0.150
    67.599   656.125     0.150
    67.599   656.174     0.150
    71.081  1514.975     0.150
    73.003   688.275     0.150
    76.672   716.375     0.150
    78.801   721.475     0.150
    80.789   733.174     0.150
    81.546   737.275     0.150
    81.545   736.674     0.150
    84.003   754.875     0.150
    84.003  1379.174     0.150
    84.003  1379.174     0.150
    84.146   756.508     0.150
    84.634   758.475     0.150
    84.634   758.475     0.150
    85.087   756.975     0.150
    85.349   763.574     0.150
    87.158   764.674     0.150
    87.158  1082.875     0.150
    87.158  1749.775     0.150
    87.158  1962.674     0.150
    87.158   764.705     0.150
    87.158   764.705     0.150
    87.158   764.705     0.150
    87.158   968.254     0.150
    87.158  1082.885     0.150
    87.158  1391.445     0.150
    87.158  1749.775     0.150
    87.158  1962.764     0.150
    87.488   764.400     0.150
    87.560   767.475     0.150
    88.804  1098.475     0.150
    90.381   779.855     0.150
    90.381  1800.375     0.150
    91.039   789.547     0.150
    91.039   783.275     0.150
    93.837   792.074     0.150
    94.928   810.574     0.150
    95.155   801.965     0.150
    98.585  2139.574     0.150
     0.184     4.273     0.150
     0.184     7.352     0.150
     0.550    10.641     0.150
     0.559    10.883     0.150
     0.606    11.047     0.150
     0.640    11.727     0.150
     0.640    11.727     0.150
     0.673     9.344     0.150
     0.673     9.633     0.150
     0.673    16.664     0.150
     0.710    13.492     0.150
     0.963    17.250     0.150
     0.968    17.164     0.150
     1.126    20.094     0.150
     1.323    23.383     0.150
     1.486    46.906     0.150
     1.804    52.289     0.150
     2.384    72.445     0.150
     2.555    38.602     0.150
     5.304    92.000     0.150
     5.873    99.492     0.150
     6.585    95.734     0.150
     8.726   125.305     0.150
    10.835   337.523     0.150
     0.171     4.000     0.150
     0.310     6.699     0.150
     0.317     5.801     0.150
     0.618    11.539     0.150
     0.736    13.871     0.150
     0.998    18.398     0.150
     1.022    31.641     0.150
     1.190    38.027     0.150
     2.509    38.082     0.150
     3.646    58.898     0.150
     4.624    70.301     0.150
     7.818   143.719     0.150
     0.028     0.949     0.150
     0.028     2.141     0.150
     0.028     0.980     0.150
     0.028     2.090     0.150
     0.045     2.633     0.150
     0.113     2.680     0.150
     0.113     2.680     0.150
     0.181     4.031     0.150
     0.181     7.402     0.150
     0.201     4.332     0.150
     0.201     4.332     0.150
     0.296     6.590     0.150
     0.296    10.070     0.150
     0.310     5.953     0.150
     0.312     6.941     0.150
     0.335     6.121     0.150
     0.419     8.203     0.150
     0.419     8.250     0.150
     0.419    14.281     0.150
     0.426     8.840     0.150
     0.439     8.961     0.150
     0.552    10.891     0.150
     0.552    10.883     0.150
     0.553    10.660     0.150
     0.667    12.203     0.150
     0.667    26.992     0.150
     0.667    37.820     0.150
     0.744    13.934     0.150
     0.759     7.680     0.150
     0.759    13.691     0.150
     0.775    26.500     0.150
     0.798    14.453     0.150
     0.808    15.043     0.150
     0.808    26.062     0.150
     0.808    27.980     0.150
     0.871    15.988     0.150
     0.871    27.988     0.150
     0.879    16.281     0.150
     0.879    28.660     0.150
     0.907    16.793     0.150
     0.985    18.281     0.150
     0.990    18.453     0.150
     1.011    18.480     0.150
     1.011    31.902     0.150
     1.011    33.453     0.150
     1.011    38.773     0.150
     1.125    20.551     0.150
     1.164    21.402     0.150
     1.395    26.133     0.150
     3.505    53.258     0.150
     7.441   106.113     0.150
     7.784   247.195     0.150
    11.937   168.363     0.150
     0.206     8.480     0.150
     0.213     8.301     0.150
     0.367     7.125     0.150
     0.417     8.059     0.150
     0.465    17.461     0.150
     0.670   141.840     0.150
     0.718    12.578     0.150
     0.677    12.891     0.150
     0.677    12.941     0.150
     0.677    23.129     0.150
     0.677    13.008     0.150
     0.677    22.555     0.150
     0.712    13.637     0.150
     0.729    13.512     0.150
     0.729    23.145     0.150
     0.749    14.430     0.150
     0.848    29.141     0.150
     1.111    21.660     0.150
     1.225    22.801     0.150
     1.255    22.730     0.150
     1.454    26.441     0.150
     1.473    25.082     0.150
     1.596    51.145     0.150
     1.725    32.668     0.150
     1.881    35.680     0.150
     2.176    41.316     0.150
     2.382    73.082     0.150
     2.622    49.348     0.150
     2.811    42.445     0.150
     3.284    62.570     0.150
     3.670    69.609     0.150
     3.733    70.594     0.150
     3.744    71.418     0.150
     3.914    74.379     0.150
     4.054    76.488     0.150
     4.285    79.992     0.150
     5.518    94.738     0.150
     0.360     7.138     0.150
     0.423     7.981     0.150
     0.673   191.802     0.150
     0.680    12.782     0.150
     0.680    12.797     0.150
     0.707    13.521     0.150
     0.722    13.421     0.150
     0.731    13.966     0.150
     0.751    14.352     0.150
     0.801    14.524     0.150
     1.136    37.111     0.150
     1.222    21.492     0.150
     1.450    24.592     0.150
     1.480    48.820     0.150
     1.603    52.535     0.150
     1.731    55.852     0.150
     1.855    61.326     0.150
     2.177    41.018     0.150
     2.183    41.390     0.150
     2.808    42.980     0.150
     2.944    47.422     0.150
     3.175    51.672     0.150
     3.921    61.622     0.150
     4.228    65.647     0.150
     5.525   170.636     0.150
     6.728    98.784     0.150
    10.626   334.401     0.150
    11.050   342.651     0.150
     0.508    10.448     0.150
     0.681   134.679     0.150
     0.688    13.059     0.150
     0.688    13.184     0.150
     0.725    13.962     0.150
     0.762    14.528     0.150
     0.791    14.448     0.150
     0.968    18.042     0.150
     1.134    36.448     0.150
     1.145    37.148     0.150
     1.469    25.163     0.150
     1.597    51.609     0.150
     1.714    29.608     0.150
     1.886    36.099     0.150
     2.189    40.990     0.150
     2.930    47.068     0.150
     3.654    56.293     0.150
    11.040   157.759     0.150
     0.360     7.142     0.150
     0.425     8.085     0.150
     0.670   178.838     0.150
     0.677    12.708     0.150
     0.677    12.770     0.150
     0.705    13.458     0.150
     0.705    22.971     0.150
     0.713    22.668     0.150
     0.721    13.394     0.150
     0.721    23.140     0.150
     0.730    14.030     0.150
     0.730    24.022     0.150
     0.748    14.398     0.150
     0.804    24.608     0.150
     1.142    23.948     0.150
     1.219    37.238     0.150
     2.811    42.418     0.150
     2.805    86.331     0.150
     4.799    75.028     0.150
     7.440   239.763     0.150
     7.869   143.383     0.150
    10.627   342.113     0.150
    11.054   345.289     0.150
     0.554    10.668     0.150
     0.677    12.799     0.150
     0.677    12.859     0.150
     0.706    13.594     0.150
     0.722    13.467     0.150
     0.722    23.259     0.150
     0.846    14.958     0.150
     0.985    31.121     0.150
     1.160    21.329     0.150
     1.220    22.639     0.150
     1.361    25.479     0.150
     1.453    26.659     0.150
     1.479    43.977     0.150
     1.601    46.839     0.150
     3.289    65.628     0.150
     4.408    68.569     0.150
     5.523    94.442     0.150
    11.054   341.591     0.150
     0.211     9.652     0.150
     0.303     6.090     0.150
     0.477     9.207     0.150
     0.477    16.148     0.150
     0.652    20.426     0.150
     0.695    13.215     0.150
     0.840    27.594     0.150
     0.843    14.379     0.150
     0.843    14.535     0.150
     0.843    27.594     0.150
     0.879    28.820     0.150
     1.260    23.305     0.150
     1.275    25.855     0.150
     1.638    30.633     0.150
     1.750    33.289     0.150
     1.768    33.152     0.150
     1.768    30.203     0.150
     2.258    42.035     0.150
     2.258    42.398     0.150
     2.323    43.547     0.150
     2.337    43.797     0.150
     2.378    44.844     0.150
     5.675   103.832     0.150
     6.597    94.840     0.150
    10.899   159.910     0.150
    10.899   347.250     0.150
    36.933   427.941     0.150
     0.058     2.195     0.150
     0.083     4.984     0.150
     0.197     4.727     0.150
     0.197     8.547     0.150
     0.201     4.992     0.150
     0.208     4.594     0.150
     0.208     4.578     0.150
     0.208    14.367     0.150
     0.208    21.211     0.150
     0.269     5.781     0.150
     0.363     6.992     0.150
     0.360     7.234     0.150
     0.384     7.766     0.150
     0.539    10.352     0.150
     0.572    11.000     0.150
     0.572    19.078     0.150
     0.572    10.945     0.150
     0.581    11.203     0.150
     0.604    30.727     0.150
     0.604    34.234     0.150
     0.617    11.422     0.150
     0.617    11.531     0.150
     0.666     8.797     0.150
     0.675    13.078     0.150
     0.734    13.805     0.150
     0.734    13.875     0.150
     0.734    23.805     0.150
     0.734    24.914     0.150
     0.987    17.617     0.150
     1.013    18.008     0.150
     1.088    19.008     0.150
     1.164    37.336     0.150
     1.192    44.227     0.150
     1.265    18.102     0.150
     1.286    23.555     0.150
     1.386    26.266     0.150
     1.392    26.242     0.150
     1.504    47.469     0.150
     1.567    59.781     0.150
     1.655    31.531     0.150
     1.669    31.977     0.150
     2.640    49.484     0.150
     2.772    91.172     0.150
     4.016    74.445     0.150
     4.081    60.688     0.150
     6.562    95.734     0.150
     7.527   127.398     0.150
     7.809   142.203     0.150
     9.978   138.172     0.150
    10.851   356.258     0.150
     0.084     2.102     0.150
     0.056     4.992     0.150
     0.196     4.680     0.150
     0.206     4.461     0.150
     0.364    11.789     0.150
     0.364     6.930     0.150
     0.364    11.789     0.150
     0.359     7.148     0.150
     0.359    12.766     0.150
     0.387     7.680     0.150
     0.387    14.406     0.150
     0.572    10.977     0.150
     0.606    11.266     0.150
     0.606    23.297     0.150
     0.606    30.766     0.150
     0.618    11.484     0.150
     0.618    11.539     0.150
     0.668     9.547     0.150
     0.673    12.945     0.150
     0.673    22.656     0.150
     0.732    13.836     0.150
     0.732    13.930     0.150
     0.877    29.953     0.150
     0.892    16.070     0.150
     0.985    33.312     0.150
     0.979    17.430     0.150
     1.011    18.078     0.150
     1.086    34.461     0.150
     1.086    19.062     0.150
     1.077    18.984     0.150
     1.191    20.820     0.150
     1.191    39.992     0.150
     1.215    37.148     0.150
     1.219    21.203     0.150
     1.266    18.531     0.150
     1.304    22.289     0.150
     1.304    22.383     0.150
     1.706    31.445     0.150
     2.152    39.523     0.150
     2.539    38.688     0.150
     2.966    53.781     0.150
     3.046    59.344     0.150
     3.754    72.500     0.150
     4.569    69.906     0.150
     5.872   191.836     0.150
     6.564    95.859     0.150
     7.810   139.430     0.150
     8.706   125.320     0.150
     0.064     3.945     0.150
     0.229     9.727     0.150
     0.365     7.273     0.150
     0.471     9.098     0.150
     0.534    11.277     0.150
     0.501    16.035     0.150
     0.501     9.637     0.150
     0.501    16.117     0.150
     0.501     9.656     0.150
     0.526    10.277     0.150
     0.596    11.207     0.150
     0.596    19.340     0.150
     0.670    13.816     0.150
     0.670    24.559     0.150
     0.644    12.438     0.150
     0.755    14.309     0.150
     0.755    24.824     0.150
     0.788    24.797     0.150
     0.946    17.648     0.150
     1.022    18.668     0.150
     1.043    18.352     0.150
     1.181    21.688     0.150
     1.186    22.938     0.150
     1.220    37.855     0.150
     1.226    23.348     0.150
     1.248    23.348     0.150
     1.276    24.066     0.150
     1.334    25.367     0.150
     4.188    64.008     0.150
     5.488    96.938     0.150
    11.286   166.961     0.150
     0.208     7.258     0.150
     0.244     4.953     0.150
     0.406    13.688     0.150
     0.523    10.031     0.150
     0.545     9.742     0.150
     0.557     9.727     0.150
     0.562     9.867     0.150
     0.632    20.844     0.150
     0.689    13.234     0.150
     0.689    22.727     0.150
     0.799    26.352     0.150
     0.799    14.953     0.150
     0.799    26.406     0.150
     0.822    26.906     0.150
     0.880    16.305     0.150
     1.084    19.352     0.150
     1.172    38.281     0.150
     1.350    25.055     0.150
     1.548    25.289     0.150
     1.752    33.555     0.150
     2.277    42.812     0.150
     2.332    44.281     0.150
     2.459    40.320     0.150
     2.776    91.492     0.150
    10.956   162.008     0.150
    10.956   350.133     0.150
     0.142     3.897     0.150
     0.142     6.547     0.150
     0.197     4.347     0.150
     0.269     5.567     0.150
     0.269     5.583     0.150
     0.269     9.249     0.150
     0.403    13.537     0.150
     0.454    14.487     0.150
     0.454     8.807     0.150
     0.454     8.852     0.150
     0.454    14.855     0.150
     0.454     8.801     0.150
     0.454    14.576     0.150
     0.501     9.507     0.150
     0.501    16.537     0.150
     0.596    11.293     0.150
     0.595    10.997     0.150
     0.595    18.797     0.150
     0.613    11.627     0.150
     0.613    20.777     0.150
     0.613    21.097     0.150
     0.613    11.677     0.150
     0.613    19.855     0.150
     0.650    13.267     0.150
     0.650    13.327     0.150
     0.650    23.497     0.150
     0.650    25.327     0.150
     0.694    13.057     0.150
     0.694    13.117     0.150
     0.739    22.997     0.150
     0.739    24.797     0.150
     0.760    15.147     0.150
     0.803    15.067     0.150
     0.803    15.117     0.150
     0.803    25.967     0.150
     0.855    15.587     0.150
     0.928    16.677     0.150
     0.980    17.977     0.150
     0.996    31.758     0.150
     1.161    36.980     0.150
     1.235    22.477     0.150
     1.238    46.217     0.150
     1.294    22.987     0.150
     1.321    23.967     0.150
     1.321    44.797     0.150
     1.459    22.507     0.150
     1.459    38.307     0.150
     1.459    38.957     0.150
     1.457    25.668     0.150
     2.156    35.250     0.150
     5.465    93.857     0.150
     5.929    86.137     0.150
     6.252    90.367     0.150
     7.348   107.015     0.150
    11.037   345.307     0.150
     0.074     2.961     0.150
     0.074     5.070     0.150
     0.125     3.102     0.150
     0.125     5.719     0.150
     0.579    11.102     0.150
     0.579    18.984     0.150
     0.759    24.516     0.150
     0.782    14.352     0.150
     0.777    24.844     0.150
     0.829    15.500     0.150
     0.900    16.227     0.150
     1.501    48.688     0.150
     1.819    30.820     0.150
     2.648    86.305     0.150
     3.221    49.930     0.150
     3.477    53.312     0.150
     7.315   102.930     0.150
    11.819   164.625     0.150
    11.831   166.422     0.150
    13.281   184.734     0.150
     0.072     2.534     0.150
     0.283     5.955     0.150
     0.327    11.104     0.150
     0.327     6.516     0.150
     0.327    11.093     0.150
     0.327    11.039     0.150
     0.601    11.489     0.150
     0.601    19.920     0.150
     0.772    14.838     0.150
     0.792    14.794     0.150
     0.792    25.216     0.150
     0.835    15.574     0.150
     0.937    17.544     0.150
     1.008    18.621     0.150
     1.067    18.592     0.150
     1.218    37.750     0.150
     1.279    40.472     0.150
     1.312    22.365     0.150
     1.435    25.290     0.150
     1.522    47.675     0.150
     2.480    39.838     0.150
     2.480    77.427     0.150
     3.371    52.774     0.150
    11.715   364.215     0.150
     0.200     8.199     0.150
     0.259     9.239     0.150
     0.259     5.373     0.150
     0.274     5.769     0.150
     0.274    10.088     0.150
     0.507     9.824     0.150
     0.507    16.687     0.150
     0.610    11.260     0.150
     0.659    12.542     0.150
     0.659    21.425     0.150
     0.720    24.619     0.150
     0.754    13.909     0.150
     0.754    13.908     0.150
     0.754    24.346     0.150
     0.789    14.139     0.150
     0.778    25.153     0.150
     0.841    15.130     0.150
     0.895    15.659     0.150
     0.987    17.249     0.150
     1.065    18.059     0.150
     1.118    18.809     0.150
     1.117    20.449     0.150
     1.184    19.719     0.150
     1.279    21.608     0.150
     1.591    50.300     0.150
     2.356    66.689     0.150
     2.892    45.062     0.150
     4.589    69.707     0.150
     5.286    90.378     0.150
     8.303   138.998     0.150
    10.639   331.624     0.150
    10.759   336.878     0.150
    11.528   162.739     0.150
    11.528   356.216     0.150
     0.136     2.552     0.150
     0.157     2.950     0.150
     0.268     5.542     0.150
     0.458     9.632     0.150
     0.715    13.452     0.150
     0.708    22.942     0.150
     0.708    13.471     0.150
     0.708    22.886     0.150
     0.708    23.051     0.150
     0.925    16.628     0.150
     0.925    28.924     0.150
     1.003    18.378     0.150
     1.384    24.922     0.150
     1.735    56.637     0.150
     1.717    32.512     0.150
     1.797    58.798     0.150
     1.862    33.639     0.150
     2.022    57.450     0.150
     2.017    37.622     0.150
     2.333    44.152     0.150
     2.352    43.613     0.150
     2.371    43.976     0.150
     2.817    52.183     0.150
    11.136   164.479     0.150
     0.071     4.492     0.150
     0.282     6.008     0.150
     0.332    10.797     0.150
     0.332     6.648     0.150
     0.332    11.273     0.150
     0.332     6.398     0.150
     0.332    11.172     0.150
     0.598    11.531     0.150
     0.774    14.961     0.150
     0.794    14.914     0.150
     0.816    27.367     0.150
     1.007    18.578     0.150
     1.284    40.594     0.150
     1.335    43.531     0.150
     1.525    49.789     0.150
     1.971    35.672     0.150
     2.083    64.828     0.150
     3.547    53.352     0.150
     4.919    71.883     0.150
     6.863   209.180     0.150
    11.716   362.219     0.150
     0.225     4.695     0.150
     0.549    10.422     0.150
     0.617    20.469     0.150
     0.691    21.594     0.150
     0.694    13.312     0.150
     0.694    22.852     0.150
     0.834    15.375     0.150
     0.834    27.180     0.150
     1.250    21.680     0.150
     1.552    48.164     0.150
     1.790    58.750     0.150
     1.844    59.516     0.150
     2.072    68.086     0.150
     2.371    78.008     0.150
     2.664    40.203     0.150
     3.730    58.922     0.150
    10.751   161.062     0.150
     0.121     3.601     0.150
     0.121     6.111     0.150
     0.122     4.131     0.150
     0.139     4.371     0.150
     0.193     6.011     0.150
     0.193     5.981     0.150
     0.236     7.641     0.150
     0.340    10.411     0.150
     0.340    10.510     0.150
     0.340     6.281     0.150
     0.340    10.534     0.150
     0.343    43.991     0.150
     0.626    20.501     0.150
     0.626    12.281     0.150
     0.626    20.567     0.150
     0.648    12.641     0.150
     0.673    12.938     0.150
     0.673    21.589     0.150
     0.741    23.951     0.150
     0.791    15.485     0.150
     0.791    26.177     0.150
     0.872    27.597     0.150
     0.916    30.321     0.150
     0.921    28.541     0.150
     0.911    28.301     0.150
     0.929    17.981     0.150
     0.990    18.521     0.150
     1.012    18.709     0.150
     1.020    19.561     0.150
     1.122    20.911     0.150
     1.244    40.505     0.150
     1.642    29.671     0.150
     1.704    53.956     0.150
     1.731    29.069     0.150
     1.825    32.232     0.150
     2.122    63.875     0.150
     2.245    66.476     0.150
     2.256    39.701     0.150
     2.265    37.498     0.150
     2.337    73.744     0.150
     2.636    77.251     0.150
     3.427    53.091     0.150
     4.947    76.059     0.150
     4.970    76.596     0.150
     4.970   153.358     0.150
     5.217   157.512     0.150
     5.358    83.121     0.150
     6.098   186.018     0.150
     6.567    98.161     0.150
     7.102   102.531     0.150
     7.442   227.425     0.150
     8.718   269.635     0.150
     8.718   128.252     0.150
    10.899   340.977     0.150
    10.999   160.423     0.150
    11.377   166.641     0.150
    12.752   184.638     0.150
    13.016   186.384     0.150
    15.011   213.136     0.150
    15.483   219.919     0.150
    21.889   295.186     0.150
    32.538   394.098     0.150
    37.814   439.841     0.150
    38.745   446.667     0.150
     0.176     3.762     0.150
     0.168     7.840     0.150
     0.280     5.980     0.150
     0.278     6.039     0.150
     0.278    10.898     0.150
     0.387     7.719     0.150
     0.387    13.281     0.150
     0.385     7.539     0.150
     0.342     7.539     0.150
     0.425     9.039     0.150
     0.425    15.352     0.150
     0.425    17.680     0.150
     0.491    10.039     0.150
     0.491    18.531     0.150
     0.505    10.520     0.150
     0.580    11.340     0.150
     0.593    11.328     0.150
     0.601    11.852     0.150
     0.601    21.441     0.150
     0.669    23.520     0.150
     0.614    20.059     0.150
     0.690    12.852     0.150
     0.690    22.078     0.150
     0.732    23.988     0.150
     0.732    24.359     0.150
     0.708    13.344     0.150
     0.745    13.621     0.150
     0.745    24.512     0.150
     0.835    14.660     0.150
     0.835    41.230     0.150
     0.908    16.859     0.150
     0.890    15.770     0.150
     0.948    17.238     0.150
     0.948    30.238     0.150
     1.036    19.629     0.150
     1.256    18.520     0.150
     1.356    22.988     0.150
     2.373    43.719     0.150
     3.206    58.891     0.150
     7.515   115.512     0.150
     8.146   149.320     0.150
     8.146   258.719     0.150
    10.970   344.449     0.150
     0.032     3.657     0.150
     0.081     4.707     0.150
     0.112     2.957     0.150
     0.112     2.977     0.150
     0.148     3.927     0.150
     0.180     4.487     0.150
     0.180     8.337     0.150
     0.224     5.167     0.150
     0.274     6.127     0.150
     0.301     6.007     0.150
     0.338     6.847     0.150
     0.338    12.646     0.150
     0.376     7.657     0.150
     0.479     9.277     0.150
     0.512    18.297     0.150
     0.513     9.757     0.150
     0.553    19.237     0.150
     0.553    10.667     0.150
     0.554    10.467     0.150
     0.561    20.477     0.150
     0.604    10.937     0.150
     0.661    12.317     0.150
     0.703    33.077     0.150
     0.703    38.877     0.150
     0.703    13.542     0.150
     0.757    14.187     0.150
     0.902    31.437     0.150
     0.993    17.727     0.150
     0.993    31.197     0.150
     1.056    34.047     0.150
     1.083    34.727     0.150
     1.083    18.837     0.150
     1.095    35.337     0.150
     1.113    35.417     0.150
     1.113    19.317     0.150
     1.409    24.707     0.150
     0.292    10.039     0.150
     0.511     9.453     0.150
     0.511    16.152     0.150
     0.853    26.789     0.150
     1.240    23.250     0.150
     1.346    22.578     0.150
     7.979   142.352     0.150
    10.130   316.941     0.150
    11.525   359.262     0.150
     0.062     3.348     0.150
     0.143     2.809     0.150
     0.174     4.148     0.150
     0.496    18.398     0.150
     0.601    18.871     0.150
     0.775    26.156     0.150
     1.191    22.250     0.150
     1.361    25.031     0.150
     1.386    25.484     0.150
     1.711    30.555     0.150
     1.810    31.461     0.150
     3.487    63.695     0.150
     5.446   166.766     0.150
     5.748    87.219     0.150
     7.381   225.977     0.150
     7.906   143.898     0.150
    10.595   328.211     0.150
     0.057     3.188     0.150
     0.137     2.758     0.150
     0.251    10.391     0.150
     0.501    18.461     0.150
     0.605    21.629     0.150
     0.633    23.320     0.150
     0.793    25.840     0.150
     1.390    24.449     0.150
     1.705    30.699     0.150
     2.674    42.520     0.150
     3.174    52.391     0.150
     4.237    67.668     0.150
     4.349    67.039     0.150
     7.900   112.727     0.150
     7.900   139.852     0.150
     0.314     6.128     0.150
     0.683    13.638     0.150
     1.200    21.688     0.150
     2.351    38.938     0.150
     4.988    87.733     0.150
     0.127     3.809     0.150
     0.130     3.013     0.150
     0.130     3.379     0.150
     0.130     3.369     0.150
     0.130     5.599     0.150
     0.208     7.879     0.150
     0.234     5.259     0.150
     0.311     6.819     0.150
     0.311    11.539     0.150
     0.324     7.169     0.150
     0.600    11.639     0.150
     0.760    14.369     0.150
     0.760    24.869     0.150
     0.753    25.489     0.150
     0.834    26.659     0.150
     0.878    27.659     0.150
     0.914    16.649     0.150
     0.956    18.509     0.150
     0.978    17.539     0.150
     1.040    17.889     0.150
     1.476    24.369     0.150
     1.482    25.669     0.150
     1.825    30.669     0.150
     2.180    32.809     0.150
     2.488    39.669     0.150
     2.707    42.969     0.150
     4.958    75.259     0.150
     5.140   159.055     0.150
     7.313   224.144     0.150
     7.319   114.669     0.150
     9.086   139.639     0.150
     9.557   140.869     0.150
    10.191   154.189     0.150
    10.755   333.519     0.150
    10.779   160.789     0.150
    10.816   347.563     0.150
    11.726   366.937     0.150
    14.379   205.309     0.150
    14.743   210.109     0.150
    14.768   213.639     0.150
    18.568   261.419     0.150
    23.564   314.929     0.150
    24.883   330.329     0.150
    30.614   377.497     0.150
    32.589   396.931     0.150
    32.605   396.709     0.150
    44.254   489.362     0.150
    54.846   576.459     0.150
    84.152   754.612     0.150
    84.620     5.000     0.150
    87.134   772.259     0.150
    87.134   772.259     0.150
    87.134   964.619     0.150
    87.134  1119.509     0.150
    87.134  1761.108     0.150
    87.134  1969.269     0.150
    87.134   772.169     0.150
    87.134   774.069     0.150
    87.134  1398.369     0.150
    87.134  1467.869     0.150
    87.134  1969.269     0.150
    88.775  1101.069     0.150
    98.309   823.469     0.150
   101.175   827.969     0.150
     0.867    16.078     0.150
     4.219    66.777     0.150
     0.143     5.836     0.150
     0.175     6.453     0.150
     0.186     4.188     0.150
     0.186     8.094     0.150
     0.198     3.773     0.150
     0.198     6.875     0.150
     0.261     5.141     0.150
     0.256     5.203     0.150
     0.298     6.062     0.150
     0.357     7.094     0.150
     0.382     7.078     0.150
     0.384     6.992     0.150
     0.415     7.594     0.150
     0.415     8.125     0.150
     0.513    18.812     0.150
     0.634    20.391     0.150
     0.679    12.633     0.150
     0.679    21.625     0.150
     0.693    13.102     0.150
     0.693    21.812     0.150
     1.335    22.703     0.150
     3.504    51.547     0.150
     5.705   174.805     0.150
     7.731   235.086     0.150
     8.167   146.953     0.150
    10.205   328.930     0.150
    10.190   313.750     0.150
    10.978   337.609     0.150
    11.197   162.664     0.150
    15.247   473.805     0.150
    20.353   272.914     0.150
    35.502   415.836     0.150
    35.622   415.898     0.150
    40.589   458.430     0.150
    62.253   624.680     0.150
    91.525   783.914     0.150
     0.171     7.891     0.150
     0.324    12.371     0.150
     0.381    13.328     0.150
     0.715    13.430     0.150
     4.432    66.250     0.150
     5.569   102.008     0.150
    11.021   164.102     0.150
     0.230     4.270     0.150
     0.315    12.461     0.150
     0.401    14.301     0.150
     0.499    10.648     0.150
     0.492    10.398     0.150
     0.602    19.480     0.150
     0.678    13.051     0.150
     0.712   225.500     0.150
     0.782    14.820     0.150
     0.782    26.441     0.150
     0.904    29.449     0.150
     0.987    18.719     0.150
     1.017    19.629     0.150
     1.111    21.551     0.150
     1.111    21.391     0.150
     1.166    22.320     0.150
     1.596    29.359     0.150
     5.578   100.875     0.150
    27.131   342.672     0.150
    82.093   740.270     0.150
     0.794    25.910     0.150
     1.526    27.770     0.150
     3.803    70.359     0.150
     4.506    80.961     0.150
     5.012    91.441     0.150
     5.580   100.898     0.150
     7.423   134.578     0.150
     0.342    13.961     0.150
     0.472    16.688     0.150
     0.519    19.438     0.150
     2.204    40.812     0.150
     2.252    41.062     0.150
     5.556   100.539     0.150
     7.847   145.727     0.150
     7.847   250.727     0.150
    11.019   162.664     0.150
    11.019   353.289     0.150
     0.009     1.961     0.150
     0.339    11.203     0.150
     0.339     6.680     0.150
     0.344    12.883     0.150
     0.481     9.453     0.150
     0.524    17.152     0.150
     0.762    14.242     0.150
     0.762    24.691     0.150
     1.117    20.633     0.150
     1.290    23.551     0.150
     1.312    24.051     0.150
     1.361    23.551     0.150
     1.361    40.391     0.150
     1.374    24.961     0.150
     1.407    25.820     0.150
     1.583    29.242     0.150
     1.646    29.082     0.150
     1.978    33.602     0.150
     2.507    41.801     0.150
     3.443    55.383     0.150
     4.531    67.383     0.150
     4.725    87.227     0.150
     4.982    74.082     0.150
     7.463   106.730     0.150
     7.525   108.250     0.150
    11.792   362.328     0.150
     0.233     5.133     0.150
     0.910    16.742     0.150
     1.078    20.070     0.150
     1.124    21.047     0.150
     1.638    28.531     0.150
    10.810   352.586     0.150
     0.188     2.727     0.150
     0.385    11.633     0.150
     0.488     9.312     0.150
     0.487     9.258     0.150
     0.900    28.461     0.150
     0.900    16.703     0.150
     0.900    28.492     0.150
     1.631    28.539     0.150
     5.789   104.523     0.150
     5.789   175.930     0.150
     7.829   121.266     0.150
     7.829   253.992     0.150
    10.801   162.219     0.150
    10.879   161.906     0.150
     0.195     4.875     0.150
     0.351    11.617     0.150
     0.392    11.227     0.150
     0.588    20.578     0.150
     0.907    16.391     0.150
     1.272    22.844     0.150
     1.339    25.484     0.150
     5.795   105.086     0.150
     5.795   179.711     0.150
     7.681   237.438     0.150
     0.318     7.258     0.150
     0.392    11.914     0.150
     0.682    18.805     0.150
     1.636    28.508     0.150
     4.848    71.227     0.150
    10.873   154.258     0.150
     0.345    13.457     0.150
     0.385    11.107     0.150
     0.417    15.307     0.150
     0.893   332.657     0.150
     0.901    17.176     0.150
     0.938    30.917     0.150
     1.746    29.427     0.150
     5.791   106.432     0.150
     7.679   113.257     0.150
    10.063   324.026     0.150
    10.334   150.657     0.150
    10.490   157.297     0.150
    10.531   156.827     0.150
    10.879   284.667     0.150
    10.879   350.385     0.150
    14.265   205.197     0.150
    15.235   475.201     0.150
    15.235   222.777     0.150
    54.978   577.147     0.150
    59.914  1099.457     0.150
    76.747   722.757     0.150
    84.627   748.657     0.150
    84.627  1712.657     0.150
     0.378    11.030     0.150
     1.158    21.140     0.150
     1.192    20.150     0.150
     7.832   248.624     0.150
    10.798   151.790     0.150
    10.798   150.910     0.150
    10.884   153.690     0.150
    10.885   153.700     0.150
    37.040   434.630     0.150
     0.076     5.777     0.150
     0.123     6.126     0.150
     0.195     7.097     0.150
     2.343    37.347     0.150
     5.802   159.832     0.150
     7.689   245.106     0.150
     7.827   248.776     0.150
    10.810   351.683     0.150
    10.810   153.697     0.150
     0.888    15.901     0.150
     0.895    16.321     0.150
     0.895    28.751     0.150
     0.935    16.951     0.150
     1.054    33.901     0.150
     1.186    21.932     0.150
     1.260    21.741     0.150
     1.331    22.491     0.150
     1.628    25.642     0.150
     7.827   115.421     0.150
    10.072   147.642     0.150
     0.200     9.457     0.150
     0.907    16.508     0.150
     1.351    24.977     0.150
    10.788   278.543     0.150
     0.030     1.109     0.150
     0.030     3.078     0.150
     0.107     5.539     0.150
     0.213     8.039     0.150
     0.329    11.789     0.150
     2.330    41.941     0.150
     2.412    43.512     0.150
     5.787   105.398     0.150
     7.669   142.523     0.150
     7.813   143.594     0.150
     0.110     5.922     0.150
     0.312     6.086     0.150
     1.127    20.945     0.150
     2.416    44.602     0.150
     5.790   105.445     0.150
     5.790   180.242     0.150
     0.343     6.812     0.150
     0.390    14.297     0.150
     0.409    12.133     0.150
     0.528    18.625     0.150
     0.800    25.266     0.150
     3.949    58.500     0.150
     0.074     4.492     0.150
     0.191     8.453     0.150
     0.163     7.383     0.150
     0.210     9.523     0.150
     0.488    18.531     0.150
     0.832    15.242     0.150
     2.367    36.562     0.150
     2.749    40.148     0.150
     5.662    88.562     0.150
     5.969   101.289     0.150
     6.203   110.547     0.150
     6.482   116.891     0.150
     7.038   100.703     0.150
     7.249   101.703     0.150
     7.534   141.969     0.150
     7.778   117.328     0.150
     7.778   148.117     0.150
    10.667   346.070     0.150
    10.667   152.500     0.150
    10.908   159.219     0.150
    10.908   283.945     0.150
    10.908   347.547     0.150
     0.100     5.602     0.150
     0.180     8.680     0.150
     0.198     8.875     0.150
     0.207     9.250     0.150
     0.804    25.484     0.150
     0.824    26.766     0.150
     0.880    29.070     0.150
     2.397    40.172     0.150
     2.439    38.547     0.150
    10.698   337.938     0.150
     0.099     3.014     0.150
     0.454     8.895     0.150
     0.454    14.443     0.150
     0.636    12.373     0.150
     0.636    20.424     0.150
     0.696    13.963     0.150
     0.837    16.305     0.150
     1.005    18.793     0.150
     5.119    94.449     0.150
     5.119   142.297     0.150
     0.107     2.336     0.150
     0.107     4.086     0.150
     0.148     4.781     0.150
     0.422     7.477     0.150
     0.422    12.547     0.150
     0.391    14.047     0.150
     0.498     8.867     0.150
     0.498    13.945     0.150
     0.652    20.469     0.150
     0.654    11.992     0.150
     0.654    20.352     0.150
     0.672    19.656     0.150
     0.637    12.852     0.150
     0.637    22.219     0.150
     0.735    13.789     0.150
     0.924    16.852     0.150
     0.916    30.336     0.150
     0.975    19.336     0.150
     1.045    19.438     0.150
     1.132    19.000     0.150
     1.132    32.422     0.150
     1.139    20.477     0.150
     1.117    19.500     0.150
     1.186    22.047     0.150
     1.281    38.500     0.150
     1.362    23.289     0.150
     1.418    27.109     0.150
     3.883    60.531     0.150
     4.090    64.289     0.150
     4.934    71.477     0.150
     4.987    71.828     0.150
     4.988    71.875     0.150
     5.030    72.172     0.150
     5.147    75.625     0.150
     5.263    75.461     0.150
     5.427    77.969     0.150
     5.839    82.805     0.150
     6.582    94.055     0.150
     6.720    94.258     0.150
     6.857    96.055     0.150
     6.917    97.461     0.150
     7.200   101.539     0.150
     7.238   101.961     0.150
     7.247   102.508     0.150
     7.263   102.609     0.150
     7.291   103.117     0.150
     7.314   104.555     0.150
     7.624   107.500     0.150
     0.405     7.738     0.150
     0.485    15.418     0.150
     0.462    14.340     0.150
     0.557    20.000     0.150
     0.564     6.148     0.150
     0.826    15.297     0.150
     0.826    15.371     0.150
     0.845    16.230     0.150
     0.963    18.281     0.150
     1.451    20.941     0.150
     1.275    25.219     0.150
     1.459    23.129     0.150
     2.292    42.359     0.150
     2.296    43.602     0.150
     2.360    43.211     0.150
   100.844    66.031     0.150
     3.789    70.730     0.150
    11.844    72.918     0.150
    80.490    74.148     0.150
     5.670    85.059     0.150
     7.549   141.453     0.150
     7.796   117.824     0.150
     7.796   146.824     0.150
    10.918   351.078     0.150
    36.928   431.480     0.150
     0.007     0.422     0.150
     0.148     7.109     0.150
     0.187     8.750     0.150
     0.218     7.898     0.150
     0.265     8.469     0.150
     0.564     6.070     0.150
     0.595     9.836     0.150
     0.825    13.750     0.150
     0.895    15.461     0.150
     1.022    17.078     0.150
     1.059    33.695     0.150
     1.134    21.109     0.150
     1.129    19.148     0.150
     1.447    20.531     0.150
     1.216    21.688     0.150
     1.240    20.758     0.150
     1.386    22.461     0.150
     2.295    41.820     0.150
     2.331    43.422     0.150
     2.359    43.266     0.150
     2.388    43.422     0.150
     2.665    43.359     0.150
     2.540    50.711     0.150
     2.953    57.375     0.150
     3.118    58.672     0.150
     7.552   142.125     0.150
     7.799   147.445     0.150
    36.929   431.375     0.150
     0.146     7.359     0.150
     0.236     4.762     0.150
     0.232     9.852     0.150
     0.306    10.129     0.150
     0.376    15.520     0.150
     0.500    18.320     0.150
     0.543     9.668     0.150
     0.617    23.770     0.150
     0.823    15.270     0.150
     0.823    27.141     0.150
     0.923    29.012     0.150
     1.034    18.871     0.150
     1.055    33.871     0.150
     1.093    18.840     0.150
     1.159    36.559     0.150
     1.399    20.578     0.150
     1.188    20.238     0.150
     1.371    24.121     0.150
     1.417    23.961     0.150
     1.627    28.520     0.150
     4.184    30.539     0.150
     1.703    31.621     0.150
     1.722    32.012     0.150
     2.434    39.441     0.150
     2.674    43.941     0.150
     3.098    50.410     0.150
    57.035    71.250     0.150
     5.700   186.820     0.150
     7.500   107.898     0.150
     7.596   242.863     0.150
     7.596   112.871     0.150
     7.840   114.359     0.150
    10.244   327.117     0.150
    10.742   160.539     0.150
    10.742   353.000     0.150
    10.936   153.816     0.150
    10.936   340.875     0.150
     0.119     2.656     0.150
     0.119     6.027     0.150
     0.250     7.605     0.150
     0.255     4.797     0.150
     0.255     8.137     0.150
     0.255     5.316     0.150
     0.229     4.629     0.150
     0.310     6.309     0.150
     0.325     6.727     0.150
     0.388     7.137     0.150
     0.377    15.199     0.150
     0.519    18.176     0.150
     0.513     9.977     0.150
     0.513    18.539     0.150
     0.559     9.727     0.150
     0.556    10.727     0.150
     0.773    14.008     0.150
     0.815    26.887     0.150
     0.826    21.027     0.150
     0.833    15.645     0.150
     0.833    28.371     0.150
     0.833    14.727     0.150
     0.904    29.547     0.150
     0.915    29.977     0.150
     0.933    30.297     0.150
     0.935    31.328     0.150
     0.946    30.438     0.150
     1.041    18.879     0.150
     1.083    20.426     0.150
     1.134    20.129     0.150
     1.134    35.328     0.150
     1.207    20.355     0.150
     1.630    31.027     0.150
     2.290    35.348     0.150
     2.346    36.227     0.150
     2.615    45.926     0.150
     2.661    41.277     0.150
     2.794    41.727     0.150
     3.079    45.137     0.150
     3.116    46.676     0.150
     3.437    52.398     0.150
     3.710    54.289     0.150
     3.824    57.758     0.150
     3.917    56.766     0.150
     4.168    62.008     0.150
     4.168    62.098     0.150
     4.168    63.828     0.150
     4.186    68.129     0.150
     4.270    63.605     0.150
     4.440    65.098     0.150
     4.485    65.316     0.150
     4.492    67.629     0.150
    57.026    69.855     0.150
     5.082    73.406     0.150
     5.285    74.758     0.150
     5.601    79.629     0.150
     5.600    79.688     0.150
     5.809    82.219     0.150
     5.984    83.629     0.150
     5.984    83.598     0.150
     6.173    87.008     0.150
     6.225    86.027     0.150
     6.225    86.059     0.150
     6.218    90.527     0.150
     6.456    94.027     0.150
     6.515    92.137     0.150
     6.740    93.227     0.150
     7.088    99.156     0.150
     7.105   109.828     0.150
     7.240   106.258     0.150
     7.385   109.719     0.150
     7.385   115.527     0.150
    10.241   151.426     0.150
    10.439   159.926     0.150
    10.710   160.527     0.150
    13.905   192.938     0.150
    14.049   198.066     0.150
    14.132   193.707     0.150
    14.141   193.059     0.150
    14.203   194.137     0.150
    14.199   194.727     0.150
    14.199   194.766     0.150
    14.199   204.621     0.150
     3.887   205.688     0.150
    14.552   202.129     0.150
    14.616   203.469     0.150
    14.728   203.438     0.150
    14.765   203.496     0.150
    14.787   204.227     0.150
    14.806   204.039     0.150
    14.858   204.488     0.150
    14.875   206.098     0.150
    82.602   206.348     0.150
    14.951   206.688     0.150
    15.060   208.199     0.150
    15.140   209.496     0.150
    15.140   221.227     0.150
    15.366   212.078     0.150
    15.382   212.977     0.150
    15.444   213.496     0.150
    15.505   214.777     0.150
    15.658   216.117     0.150
   101.943   218.238     0.150
    15.800   218.117     0.150
    16.289   224.027     0.150
    16.339   224.328     0.150
    16.578   227.887     0.150
    16.750   228.758     0.150
    57.026   234.848     0.150
    17.306   236.227     0.150
    17.753   242.988     0.150
    18.221   256.578     0.150
    18.370   256.676     0.150
    19.100   257.699     0.150
    20.129   270.098     0.150
    20.401   273.188     0.150
    21.065   527.078     0.150
    21.148   280.867     0.150
    21.329   282.949     0.150
    22.170   291.957     0.150
    22.456   306.926     0.150
    22.884   300.855     0.150
    23.035   309.672     0.150
    23.035   310.727     0.150
    23.421   310.953     0.150
    23.619   308.547     0.150
    23.619   314.129     0.150
    23.961   310.586     0.150
    24.305   314.027     0.150
    24.305   314.016     0.150
    24.305   321.523     0.150
    24.305   322.426     0.150
    24.342   314.977     0.150
    25.548   324.668     0.150
    26.480   338.449     0.150
    26.836   335.727     0.150
    26.836   335.766     0.150
    26.836   344.102     0.150
    27.010   336.996     0.150
    28.374   349.809     0.150
    31.030   373.496     0.150
    32.409   384.188     0.150
    33.611   394.477     0.150
    35.290   410.949     0.150
    35.481   412.316     0.150
    35.501   412.508     0.150
    35.551   413.199     0.150
    35.594   412.656     0.150
    35.656   414.227     0.150
    35.656   414.219     0.150
    36.673   429.152     0.150
    36.726   423.105     0.150
    36.928   425.527     0.150
    36.928   425.477     0.150
    36.956   424.938     0.150
    36.956   431.727     0.150
    37.031   425.578     0.150
    82.278   427.387     0.150
    37.133   427.355     0.150
    37.221   427.836     0.150
    37.328   429.156     0.150
    83.610   433.676     0.150
    39.115   444.836     0.150
    39.479   448.258     0.150
    40.213   459.703     0.150
    40.213   459.629     0.150
    41.451   464.199     0.150
    41.950   467.598     0.150
    79.828   483.105     0.150
    79.828   488.926     0.150
    43.969   473.828     0.150
    33.939   509.129     0.150
    24.247   506.727     0.150
    43.938   510.328     0.150
    46.714   498.828     0.150
    47.640   522.754     0.150
    47.640   514.348     0.150
    47.851   933.527     0.150
    47.883   515.988     0.150
    47.907   516.566     0.150
    47.907   522.129     0.150
    23.778   524.227     0.150
    48.551   531.227     0.150
    52.142   552.727     0.150
    54.896   568.727     0.150
    55.225   570.719     0.150
    59.591   604.133     0.150
    59.591   606.629     0.150
    60.363   609.039     0.150
    61.863   616.828     0.150
    61.863  1119.730     0.150
    62.381   627.152     0.150
    66.882   658.203     0.150
    69.593   672.598     0.150
    71.654     8.801     0.150
    71.654  1510.426     0.150
    71.654  1710.527     0.150
    71.756   673.828     0.150
    73.755   696.977     0.150
    73.755   697.027     0.150
    76.401   713.652     0.150
    76.667   715.203     0.150
    77.109   714.828     0.150
    77.109   712.117     0.150
    77.109   718.527     0.150
    78.165   723.672     0.150
    80.678   732.719     0.150
    80.740   737.578     0.150
    80.740   732.559     0.150
    81.053   737.828     0.150
    81.468   741.027     0.150
    81.468   740.578     0.150
    81.468   735.258     0.150
    82.265   745.848     0.150
    82.265   739.578     0.150
    82.728   742.828     0.150
    82.728   742.789     0.150
    82.988   749.727     0.150
    83.856   754.227     0.150
    84.150  1915.129     0.150
    84.217   749.926     0.150
    84.467   754.828     0.150
    84.554   757.727     0.150
    84.554  1386.027     0.150
    84.554  1386.027     0.150
    84.554  1386.027     0.150
    84.554  1729.027     0.150
    84.554  1933.027     0.150
    84.892   759.227     0.150
    84.892   765.828     0.150
    84.967   757.828     0.150
    86.194   764.098     0.150
    86.212   760.926     0.150
    86.212   760.957     0.150
    86.713   763.809     0.150
    86.713   766.328     0.150
    87.197   769.676     0.150
    87.197   769.676     0.150
    87.197   972.367     0.150
    87.197  1086.801     0.150
    87.197  1965.121     0.150
    87.197   769.629     0.150
    87.197   972.328     0.150
    87.197  1086.730     0.150
    87.197  1394.629     0.150
    87.197  1752.129     0.150
    87.197  1965.027     0.150
    87.565   765.426     0.150
    87.774   771.441     0.150
    88.184   775.762     0.150
    90.780    26.102     0.150
    91.015   788.605     0.150
    97.263   817.129     0.150
    98.800   823.227     0.150
   100.380  1202.527     0.150
   100.380  2161.230     0.150
   112.343  2101.527     0.150
   117.057  1129.176     0.150
   119.091  1132.574     0.150
   145.495  1181.527     0.150
     0.131     6.516     0.150
     0.216     9.711     0.150
     0.253     7.547     0.150
     0.247     9.391     0.150
     0.258    10.695     0.150
     0.480     9.094     0.150
     0.618    23.047     0.150
     0.825    15.922     0.150
     0.831    15.992     0.150
     1.170    20.117     0.150
     1.415    21.094     0.150
     1.415    36.094     0.150
     4.172    27.234     0.150
     2.663    42.742     0.150
     3.849    61.883     0.150
    57.023    72.570     0.150
     5.299    76.602     0.150
     5.695    89.125     0.150
     7.458   106.211     0.150
     7.583   242.773     0.150
    16.813   112.250     0.150
    10.243   326.641     0.150
    10.243   149.102     0.150
    10.722   152.156     0.150
    10.722   344.820     0.150
    11.570   163.625     0.150
    11.855   168.695     0.150
    15.137   218.797     0.150
     0.163     8.012     0.150
     0.830    15.165     0.150
     0.830    15.252     0.150
     0.968    29.702     0.150
     1.082    20.162     0.150
     1.412    20.362     0.150
     5.696   103.877     0.150
     7.585   113.202     0.150
     7.823   115.322     0.150
    10.925   328.552     0.150
     0.111     5.393     0.150
     0.157     7.842     0.150
     0.163     7.432     0.150
     0.176     8.092     0.150
     0.186     8.521     0.150
     0.213     7.682     0.150
     0.273     9.752     0.150
     0.536    16.201     0.150
     0.793    14.641     0.150
     0.793    14.652     0.150
     1.445    36.422     0.150
     1.233    38.361     0.150
     1.502    25.732     0.150
     4.137    28.383     0.150
     5.654    98.572     0.150
     5.654   169.797     0.150
     7.549   107.422     0.150
     7.549   134.771     0.150
     7.549   228.848     0.150
    10.700   152.643     0.150
     0.157     7.824     0.150
     0.621    23.844     0.150
     0.665    19.285     0.150
     1.091    20.174     0.150
     1.404    20.605     0.150
    57.033    70.535     0.150
     5.701   176.812     0.150
    10.735   150.533     0.150
    10.927   338.695     0.150
     0.154     7.586     0.150
     0.126     6.383     0.150
     0.122     5.836     0.150
     0.208     8.969     0.150
     0.298     9.812     0.150
     0.353    12.836     0.150
     0.876    16.773     0.150
     1.099    20.164     0.150
     1.074    19.914     0.150
     1.424    36.453     0.150
     1.227    21.305     0.150
     1.352    22.828     0.150
     4.159    26.969     0.150
     2.684    42.922     0.150
     5.591    84.664     0.150
     6.632    94.023     0.150
     6.649    95.617     0.150
    10.942   153.734     0.150
    12.919   180.406     0.150
    13.857   192.594     0.150
     0.318     7.313     0.150
     0.395     8.424     0.150
     0.441    14.184     0.150
     0.419    14.664     0.150
     0.778    14.458     0.150
     0.778    26.154     0.150
     7.529   240.839     0.150
     7.529   112.134     0.150
     7.831   250.757     0.150
     7.831   117.074     0.150
    10.684   347.767     0.150
    10.965   350.712     0.150
    15.080   220.944     0.150
    27.575   350.304     0.150
     0.164     8.162     0.150
     0.164     7.682     0.150
     0.289     8.672     0.150
     0.323     9.973     0.150
     0.777    14.451     0.150
     0.777    26.012     0.150
     0.813    27.002     0.150
     1.653    29.182     0.150
     7.528   140.633     0.150
     7.528   112.582     0.150
     7.831   145.227     0.150
     7.831   206.977     0.150
     7.831   116.352     0.150
    29.309   363.643     0.150
    84.515  2833.232     0.150
   100.431   833.932     0.150
     0.048    -2.455     0.150
     0.048    -1.744     0.150
     0.055    -2.254     0.150
     0.115    -0.465     0.150
     0.106    -0.674     0.150
     0.161     0.256     0.150
     0.155     1.205     0.150
     0.154     7.715     0.150
     0.197     1.535     0.150
     0.397     8.365     0.150
     0.417     9.496     0.150
     1.460    38.836     0.150
     1.460    21.656     0.150
     1.269    23.545     0.150
     1.392    44.055     0.150
     2.013    38.564     0.150
     7.532   112.656     0.150
     7.839   248.395     0.150
     7.839   115.855     0.150
     0.595    10.740     0.150
     0.766    17.943     0.150
     0.773    14.391     0.150
     0.804    26.680     0.150
     1.177    37.029     0.150
     1.214    39.240     0.150
     1.307    41.609     0.150
     1.391    23.590     0.150
     1.391    43.619     0.150
     4.120    29.340     0.150
     1.845    34.619     0.150
     7.840   119.189     0.150
     7.840   249.078     0.150
    10.972   162.668     0.150
    10.972   354.484     0.150
     0.203     4.352     0.150
     0.313     6.211     0.150
     0.379     8.305     0.150
     0.490    18.555     0.150
     0.510    19.555     0.150
     0.649    13.227     0.150
     0.677    12.648     0.150
     0.688    23.852     0.150
     0.826    26.922     0.150
     0.893    28.141     0.150
     0.893    16.695     0.150
     1.012    18.977     0.150
     1.058    19.727     0.150
     1.311    19.430     0.150
     1.311    33.672     0.150
     1.081    20.609     0.150
     1.239    22.648     0.150
     2.022    34.227     0.150
     4.698    70.156     0.150
    57.099    71.906     0.150
     5.004    74.336     0.150
    17.095   112.031     0.150
     8.108   259.469     0.150
     0.144     7.527     0.150
     0.791    26.391     0.150
     0.817   296.379     0.150
     0.824    15.023     0.150
     0.851    27.129     0.150
     0.857    27.148     0.150
     1.395    20.129     0.150
     4.945    72.809     0.150
     7.600   140.902     0.150
     7.600   113.258     0.150
     7.843   145.223     0.150
     7.843   204.281     0.150
     7.843   114.668     0.150
    10.745   345.188     0.150
     0.163     4.157     0.150
     0.102     3.237     0.150
     0.128     3.587     0.150
     0.128     6.127     0.150
     0.330     6.757     0.150
     0.332     6.787     0.150
     0.332    11.627     0.150
     0.418     8.617     0.150
     0.679    21.107     0.150
     0.717    23.397     0.150
     0.717    13.207     0.150
     0.717    23.397     0.150
     0.742    24.287     0.150
     0.760    25.397     0.150
     0.823    14.867     0.150
     0.817    15.257     0.150
     0.817    27.167     0.150
     0.878    15.857     0.150
     0.873    15.457     0.150
     0.873    15.457     0.150
     0.922    16.607     0.150
     0.943    16.507     0.150
     1.192    19.688     0.150
     1.424    23.257     0.150
     1.462    15.457     0.150
     5.160   140.568     0.150
     8.402   155.201     0.150
    10.734   154.977     0.150
    11.674   364.354     0.150
    22.581   300.757     0.150
    29.052   360.387     0.150
    36.395   425.667     0.150
     0.049     4.887     0.150
     0.258     5.625     0.150
     0.240     9.266     0.150
     0.270     9.617     0.150
     0.283     9.938     0.150
     0.306    10.309     0.150
     0.372    12.375     0.150
     0.469    15.004     0.150
     0.469    15.309     0.150
     0.645    12.695     0.150
     0.768    15.238     0.150
     0.784    15.297     0.150
     0.837    16.176     0.150
     0.841    16.309     0.150
     0.852    16.156     0.150
     0.882    16.965     0.150
     0.918    29.148     0.150
     1.011    18.809     0.150
     1.087    19.586     0.150
     1.771    27.746     0.150
     2.381    38.508     0.150
     7.510   111.918     0.150
    10.907   153.715     0.150
    10.950   154.207     0.150
    11.049   156.137     0.150
    11.751   165.445     0.150
    11.904   166.715     0.150
    12.012   174.625     0.150
    12.226   171.488     0.150
    13.187   183.777     0.150
    21.742   287.535     0.150
    76.053   713.387     0.150
     0.039     1.734     0.150
     0.094     2.641     0.150
     0.094     5.578     0.150
     0.188     4.750     0.150
     0.256     5.688     0.150
     0.256     9.711     0.150
     0.297    11.180     0.150
     0.297     6.672     0.150
     0.341     7.211     0.150
     0.341     7.211     0.150
     0.378     7.852     0.150
     0.474    10.023     0.150
     0.488    18.094     0.150
     0.536    21.594     0.150
     0.569    15.914     0.150
     0.567    10.844     0.150
     0.598    11.180     0.150
     0.631    22.039     0.150
     0.678    22.102     0.150
     0.671    12.102     0.150
     0.723    23.594     0.150
     0.793    26.664     0.150
     0.811    14.594     0.150
     0.926    36.891     0.150
     1.214    17.648     0.150
     1.214    30.594     0.150
     0.985    32.234     0.150
     0.999    17.711     0.150
     0.999    30.789     0.150
     1.044    18.273     0.150
     1.044    33.297     0.150
     1.057    33.914     0.150
     1.058    33.961     0.150
     1.114    19.438     0.150
     1.114    35.062     0.150
     1.124    19.469     0.150
     1.139    20.305     0.150
     1.139    35.391     0.150
     1.196    20.289     0.150
     1.204    39.109     0.150
     1.214    17.820     0.150
     1.214    30.898     0.150
     1.228    21.523     0.150
     1.271    21.641     0.150
     1.278    40.203     0.150
     1.334    20.789     0.150
     1.356    22.680     0.150
     1.427    23.500     0.150
     1.442    45.742     0.150
     1.543    49.188     0.150
     1.840    34.211     0.150
     2.549    38.898     0.150
     3.034    45.484     0.150
     4.647    69.062     0.150
     4.879    71.109     0.150
     4.911    69.352     0.150
     5.432    79.062     0.150
     5.845    84.312     0.150
     5.943   107.953     0.150
     5.943   192.805     0.150
     6.185    88.672     0.150
     6.531    93.914     0.150
     7.417   104.883     0.150
     7.547   107.219     0.150
     7.585   107.320     0.150
     7.646   108.414     0.150
     7.743   110.359     0.150
     7.799   144.852     0.150
     7.799   249.453     0.150
     7.811   146.203     0.150
     7.811   249.578     0.150
     7.931   112.664     0.150
    10.769   151.875     0.150
    10.896   153.852     0.150
    10.896   161.984     0.150
    10.896   154.289     0.150
    12.076   169.289     0.150
     0.117     5.273     0.150
     0.183     6.902     0.150
     0.208     7.492     0.150
     0.248     5.133     0.150
     0.373     7.441     0.150
     0.373    12.883     0.150
     0.426    14.703     0.150
     0.533    17.031     0.150
     0.552    18.484     0.150
     0.634    21.324     0.150
     0.634    11.934     0.150
     0.634    20.254     0.150
     0.664    12.914     0.150
     0.736    13.973     0.150
     0.755    23.961     0.150
     0.759    27.621     0.150
     0.759    27.672     0.150
     0.759    14.262     0.150
     0.795    14.992     0.150
     0.795    25.301     0.150
     0.795    27.262     0.150
     0.808    26.102     0.150
     0.848    16.973     0.150
     0.853    15.734     0.150
     0.860    16.691     0.150
     0.848    16.984     0.150
     0.911    16.801     0.150
     0.911    28.613     0.150
     0.906    17.402     0.150
     0.947    17.043     0.150
     1.048    19.562     0.150
     1.353    60.594     0.150
     1.353    67.332     0.150
     1.365    22.953     0.150
     1.365    40.641     0.150
     1.365    59.961     0.150
     1.365    66.254     0.150
     1.682    25.781     0.150
     1.553    25.574     0.150
     1.682    25.594     0.150
     1.682    44.371     0.150
     7.383   228.262     0.150
     8.385   256.707     0.150
     9.697   147.109     0.150
     9.697   300.211     0.150
    10.785   153.332     0.150
    12.641   234.363     0.150
     0.093     3.746     0.150
     0.091     3.476     0.150
     0.091     5.666     0.150
     0.156     7.575     0.150
     0.205     4.775     0.150
     0.298     6.186     0.150
     0.676    13.105     0.150
     0.751    14.825     0.150
     0.790    15.266     0.150
     0.821    15.766     0.150
     0.820    15.585     0.150
     0.831    16.186     0.150
     0.861    15.325     0.150
     0.861    26.615     0.150
     0.885    16.255     0.150
     0.887    16.605     0.150
     0.913    17.445     0.150
     0.921    17.025     0.150
     0.960    18.385     0.150
     0.981    18.266     0.150
     1.412    26.166     0.150
     1.453    26.726     0.150
     1.815    28.305     0.150
     1.717    30.646     0.150
     1.815    28.286     0.150
     1.815    48.545     0.150
     1.815    50.565     0.150
     1.815    51.125     0.150
     1.863    32.845     0.150
     1.863    56.766     0.150
     2.213    37.706     0.150
     2.943   100.855     0.150
     5.152    93.220     0.150
     5.152   139.670     0.150
     5.152    93.215     0.150
     5.152   139.675     0.150
     7.462   136.621     0.150
    12.026   376.725     0.150
    61.469   617.186     0.150
     0.643    12.477     0.150
     0.820   256.189     0.150
     0.827    15.346     0.150
     0.827    15.275     0.150
     1.058    19.977     0.150
     1.128    21.246     0.150
     1.154    22.217     0.150
     1.453    24.666     0.150
     1.527    26.105     0.150
     1.761    30.566     0.150
     1.935    32.217     0.150
     4.153    61.875     0.150
     5.659   102.311     0.150
    15.090   473.154     0.150
    26.440   336.576     0.150
    56.974   720.307     0.150
    82.998   745.945     0.150
    83.207   746.266     0.150
    84.945   755.436     0.150
     0.183     6.883     0.150
     0.553    20.861     0.150
     0.817   271.383     0.150
     0.824    15.232     0.150
     0.879    29.143     0.150
     1.061    19.652     0.150
     1.076    20.492     0.150
     1.093    34.672     0.150
     1.452    24.621     0.150
     7.781   113.727     0.150
    15.085   472.502     0.150
     0.299    17.363     0.150
     0.354     7.643     0.150
     0.397    14.254     0.150
     0.432     8.742     0.150
     0.505     9.854     0.150
     0.505    18.072     0.150
     0.547    10.312     0.150
     0.547    18.393     0.150
     0.565    11.104     0.150
     0.565    18.963     0.150
     0.565    74.883     0.150
     0.565    79.133     0.150
     0.568    20.072     0.150
     0.559    21.174     0.150
     0.559    11.014     0.150
     0.606    11.383     0.150
     0.606    19.973     0.150
     0.644    11.143     0.150
     0.674    35.482     0.150
     0.674    48.354     0.150
     0.691    12.992     0.150
     0.691    22.732     0.150
     0.712    61.982     0.150
     0.713    13.652     0.150
     0.713    23.773     0.150
     0.916    16.084     0.150
     0.916    28.354     0.150
     0.985    16.723     0.150
     1.453    21.104     0.150
     2.404    34.004     0.150
     5.679   155.129     0.150
     5.824   101.713     0.150
     7.550   142.502     0.150
     7.777   147.447     0.150
    10.166   145.047     0.150
    10.679   346.277     0.150
    10.679   157.713     0.150
    10.898   156.273     0.150
    29.333   366.232     0.150
    36.937   431.754     0.150
     0.153     7.877     0.150
     0.228    14.697     0.150
     0.228    14.826     0.150
     0.286     8.258     0.150
     0.288     6.447     0.150
     0.288    11.496     0.150
     0.317     6.746     0.150
     0.317    12.406     0.150
     0.367     7.428     0.150
     0.484     9.178     0.150
     0.484    16.018     0.150
     0.518    22.807     0.150
     0.518    10.217     0.150
     0.518    18.008     0.150
     0.510     9.816     0.150
     0.536    10.088     0.150
     0.536    17.697     0.150
     0.523    10.297     0.150
     0.593    10.787     0.150
     0.620    21.557     0.150
     0.620    11.758     0.150
     0.620    20.197     0.150
     0.642    22.447     0.150
     0.687    12.576     0.150
     0.764    36.457     0.150
     0.811    13.416     0.150
     0.899    15.617     0.150
     0.899    28.227     0.150
     0.952    29.178     0.150
     0.977    32.477     0.150
     0.977    17.598     0.150
     1.040    33.188     0.150
     1.040    39.678     0.150
     1.036    17.246     0.150
     1.389    19.967     0.150
     1.389    19.947     0.150
     1.855    30.777     0.150
     4.924    77.736     0.150
     5.714    84.758     0.150
     7.608   199.701     0.150
     7.835   114.547     0.150
    69.585   147.877     0.150
    29.389   363.367     0.150
    36.972   430.287     0.150
     0.282     6.047     0.150
     0.331     6.746     0.150
     0.577    19.176     0.150
     0.600    11.625     0.150
     0.663    22.488     0.150
     0.708    12.977     0.150
     0.708    24.266     0.150
     0.779    15.727     0.150
     0.779    27.328     0.150
     0.802    14.727     0.150
     0.856    17.078     0.150
     0.867    27.977     0.150
     0.887    15.648     0.150
     0.914    16.418     0.150
     0.989    18.527     0.150
     1.029    19.398     0.150
     1.113    18.707     0.150
     2.526    42.648     0.150
     3.267    50.195     0.150
     4.605    65.035     0.150
    10.967   154.375     0.150
     0.040     1.695     0.150
     0.744    23.785     0.150
     1.919    37.547     0.150
     2.184    39.227     0.150
     0.044     1.719     0.150
     0.044     3.789     0.150
     0.055     2.289     0.150
     0.196     4.770     0.150
     0.335    11.688     0.150
     0.751    14.137     0.150
     0.848    27.977     0.150
     0.968    16.438     0.150
     0.957    30.918     0.150
     1.228    17.969     0.150
     0.988    31.578     0.150
     1.013    32.277     0.150
     1.013    19.098     0.150
     1.013    32.777     0.150
     1.026    18.000     0.150
     1.026    32.949     0.150
     1.121    34.867     0.150
     1.173    38.090     0.150
     1.256    39.867     0.150
     1.271    40.406     0.150
     1.341    25.258     0.150
     1.359    42.750     0.150
     1.383    26.328     0.150
     1.417    23.789     0.150
     1.427    23.777     0.150
     1.559    27.949     0.150
     1.737    31.598     0.150
     1.738    32.906     0.150
     1.810    33.258     0.150
     1.815    34.117     0.150
     1.873    34.488     0.150
     2.014    36.969     0.150
     2.519    40.656     0.150
     4.306    63.566     0.150
     5.915   112.754     0.150
     6.954   102.348     0.150
    10.885   155.719     0.150
     0.035     1.227     0.150
     1.219    17.828     0.150
     1.985    34.477     0.150
     2.183    37.859     0.150
     2.247    39.141     0.150
     2.518    43.539     0.150
     2.577    44.766     0.150
     5.919   106.953     0.150
     7.797   239.125     0.150
     0.034     1.219     0.150
     0.159     8.094     0.150
     0.629    19.688     0.150
     1.218    17.852     0.150
     1.070    20.328     0.150
     1.986    34.672     0.150
     2.184    37.273     0.150
     5.920   108.078     0.150
     7.798   238.484     0.150
     7.822   240.773     0.150
     0.036     1.445     0.150
     0.036     3.500     0.150
     0.036    27.320     0.150
     0.036    29.312     0.150
     0.036    77.773     0.150
     0.036    79.797     0.150
     0.036    92.125     0.150
     0.063    28.109     0.150
     0.063    90.836     0.150
     0.106    32.453     0.150
     0.106    79.547     0.150
     0.106    91.586     0.150
     0.106    94.953     0.150
     0.113    28.695     0.150
     0.113    91.406     0.150
     0.120    29.031     0.150
     0.120    32.281     0.150
     0.120    79.375     0.150
     0.120    82.586     0.150
     0.120    91.742     0.150
     0.120    94.945     0.150
     0.162    30.242     0.150
     0.162    80.570     0.150
     0.162    92.875     0.150
     0.162    96.805     0.150
     0.156    30.016     0.150
     0.156    80.305     0.150
     0.156    84.570     0.150
     0.156    92.797     0.150
     0.187    30.836     0.150
     0.187    81.125     0.150
     0.187    85.711     0.150
     0.187    93.461     0.150
     0.187    98.062     0.150
     0.173    30.125     0.150
     0.173    33.852     0.150
     0.173    80.836     0.150
     0.173    92.820     0.150
     0.173    96.312     0.150
     0.181    30.305     0.150
     0.181    34.086     0.150
     0.181    80.734     0.150
     0.181    84.922     0.150
     0.181    92.992     0.150
     0.181    97.203     0.150
     0.194    30.414     0.150
     0.194    34.680     0.150
     0.194    93.031     0.150
     0.188    30.383     0.150
     0.211    30.641     0.150
     0.211    84.547     0.150
     0.211    93.125     0.150
     0.247    31.883     0.150
     0.247    36.281     0.150
     0.247    94.141     0.150
     0.254     9.922     0.150
     0.254    94.586     0.150
     0.343    95.781     0.150
     0.322    32.281     0.150
     0.322    36.711     0.150
     0.322    82.672     0.150
     0.357    33.055     0.150
     0.357    38.602     0.150
     0.357    83.406     0.150
     0.357    95.773     0.150
     0.366    83.672     0.150
     0.366    95.977     0.150
     0.366   102.281     0.150
     0.399    83.977     0.150
     0.426    34.430     0.150
     0.426    39.586     0.150
     0.426    84.055     0.150
     0.426    89.906     0.150
     0.426    96.922     0.150
     0.438    35.016     0.150
     0.438    41.555     0.150
     0.438    84.266     0.150
     0.438    92.359     0.150
     0.438    97.680     0.150
     0.438   104.195     0.150
     0.471    35.133     0.150
     0.482    42.211     0.150
     0.482    85.234     0.150
     0.482    92.234     0.150
     0.482    97.562     0.150
     0.482   104.602     0.150
     0.483    42.766     0.150
     0.483    97.977     0.150
     0.483   104.875     0.150
     0.502    43.922     0.150
     0.502   106.234     0.150
     0.514    86.773     0.150
     0.514    99.297     0.150
     0.551    36.773     0.150
     0.551    44.625     0.150
     0.551    87.180     0.150
     0.551    94.562     0.150
     0.551    99.516     0.150
     0.551   107.453     0.150
     0.564   100.109     0.150
     0.618    38.727     0.150
     0.618    89.672     0.150
     0.618   101.773     0.150
     0.635    47.500     0.150
     0.635    89.320     0.150
     0.645    47.922     0.150
     0.645   110.125     0.150
     0.650    38.156     0.150
     0.650    88.281     0.150
     0.650    96.914     0.150
     0.650   109.336     0.150
     0.702    24.562     0.150
     0.722    38.195     0.150
     0.722    89.984     0.150
     0.722   100.555     0.150
     0.722   102.172     0.150
     0.744    40.133     0.150
     0.744    49.820     0.150
     0.774    40.492     0.150
     0.787    52.383     0.150
     0.787    92.141     0.150
     0.787   103.055     0.150
     0.801    42.664     0.150
     0.801    51.680     0.150
     0.801    91.562     0.150
     0.801   103.430     0.150
     0.828    92.492     0.150
     0.833    52.812     0.150
     0.853    53.859     0.150
     0.853   104.203     0.150
     0.853   116.312     0.150
     0.841    52.812     0.150
     0.841   103.070     0.150
     0.841   115.516     0.150
     0.893   105.523     0.150
     0.907    43.812     0.150
     0.907    54.914     0.150
     0.907   105.359     0.150
     0.940    57.070     0.150
     0.940   119.031     0.150
     0.935    93.414     0.150
     0.935   105.820     0.150
     0.959    56.977     0.150
     0.959    93.562     0.150
     0.964    56.109     0.150
     0.980    18.414     0.150
     0.980    48.391     0.150
     0.980    56.336     0.150
     0.980    94.305     0.150
     0.980   106.070     0.150
     0.980   119.164     0.150
     0.993   120.312     0.150
     1.018    45.102     0.150
     1.018    57.734     0.150
     1.018   107.414     0.150
     1.018   121.453     0.150
     1.030    58.797     0.150
     1.030   121.359     0.150
     1.084   122.766     0.150
     1.126    48.445     0.150
     1.172   111.914     0.150
     1.509   106.609     0.150
     1.984   112.477     0.150
     2.158    36.016     0.150
     2.530   122.570     0.150
     2.676    70.844     0.150
     5.922   101.852     0.150
     7.798   139.930     0.150
     7.798   233.281     0.150
    10.795   343.500     0.150
     0.042     1.719     0.150
     1.227    17.898     0.150
     2.376    42.656     0.150
     5.917   102.727     0.150
     7.792   140.227     0.150
     0.173     8.102     0.150
     0.392     8.723     0.150
     0.446     8.762     0.150
     0.487    16.012     0.150
     0.490     9.430     0.150
     0.503    10.633     0.150
     0.503    18.992     0.150
     0.518    19.660     0.150
     0.606    11.570     0.150
     0.840    26.281     0.150
     0.904    28.312     0.150
     1.265    18.680     0.150
     2.244    37.449     0.150
     5.703   104.512     0.150
     7.724   116.688     0.150
    10.190   314.398     0.150
    10.967   342.211     0.150
    15.241   220.504     0.150
    21.062   289.410     0.150
    21.062     0.000     0.150
    29.494   368.711     0.150
    29.494     0.000     0.150
    36.952   434.461     0.150
    36.952     0.000     0.150
    79.372    -0.004     0.150
    82.884   741.312     0.150
    91.522   791.824     0.150
    91.522     0.008     0.150
     0.185     7.908     0.150
     1.269    21.848     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.285     6.179     0.150
     0.285    10.285     0.150
     0.343     6.648     0.150
     0.343    11.938     0.150
     0.343     6.971     0.150
     0.517     9.791     0.150
     0.517    17.115     0.150
     0.806    14.171     0.150
     0.806    25.063     0.150
     0.878    16.088     0.150
     0.878    27.494     0.150
     0.883    16.408     0.150
     0.883    28.382     0.150
     0.890    16.894     0.150
     0.890    29.261     0.150
     0.947    17.677     0.150
     0.947    30.424     0.150
     1.059    18.294     0.150
     1.059    32.023     0.150
     1.114    20.251     0.150
     1.114    35.603     0.150
     1.128    20.403     0.150
     1.128    37.179     0.150
     1.200    21.116     0.150
     1.200    37.269     0.150
     1.288    21.733     0.150
     1.384    23.860     0.150
     1.384    44.014     0.150
     1.418    24.421     0.150
     1.418    44.680     0.150
     1.592    26.753     0.150
     1.690    28.284     0.150
     1.715    28.835     0.150
     1.869    29.778     0.150
     1.862    30.287     0.150
     1.955    31.799     0.150
     1.969    31.783     0.150
     1.984    31.942     0.150
     2.051    33.181     0.150
     2.177    35.686     0.150
     2.180    35.276     0.150
     2.202    35.177     0.150
     2.238    36.360     0.150
     2.269    36.169     0.150
     2.374    38.161     0.150
     2.522    39.811     0.150
     2.560    39.924     0.150
     2.633    40.274     0.150
     2.607    40.983     0.150
     2.679    41.595     0.150
     2.701    42.861     0.150
     2.741    42.775     0.150
     2.771    42.796     0.150
     2.841    44.519     0.150
     2.841    85.238     0.150
     2.881    45.195     0.150
     3.175    49.350     0.150
     3.270    49.871     0.150
     3.377    50.584     0.150
     3.611    54.911     0.150
     3.840    56.644     0.150
     3.816    57.849     0.150
     3.920    59.828     0.150
     3.920   123.758     0.150
     4.104    62.350     0.150
     4.141    63.259     0.150
     4.156    63.488     0.150
     4.156    77.468     0.150
     4.156   132.718     0.150
     4.266    66.028     0.150
     4.266    81.158     0.150
     4.266   134.378     0.150
     4.296    64.536     0.150
     4.393    66.104     0.150
     4.411    67.828     0.150
     4.411   139.408     0.150
     4.445    67.938     0.150
     4.445    82.278     0.150
     4.445   142.678     0.150
     4.466    68.265     0.150
     4.587    68.288     0.150
     4.582    68.808     0.150
     4.873    73.258     0.150
     4.873    91.488     0.150
     4.873   156.948     0.150
     5.035    76.138     0.150
     5.035   163.124     0.150
     5.345    79.793     0.150
     5.346    90.229     0.150
     5.346    99.548     0.150
     5.402    81.160     0.150
     5.550    82.729     0.150
     5.550   102.508     0.150
     5.550   173.128     0.150
     5.550    83.042     0.150
     5.725    84.418     0.150
     5.725    94.918     0.150
     5.725   108.098     0.150
     5.725   183.769     0.150
     5.816    87.194     0.150
     6.761   128.988     0.150
     6.761   215.658     0.150
     6.802    99.498     0.150
     6.802   128.519     0.150
     6.802   214.068     0.150
     6.967   101.098     0.150
     6.967   114.578     0.150
     6.967   131.368     0.150
     6.967   221.528     0.150
     6.993   102.769     0.150
     6.997   130.979     0.150
     6.997   222.108     0.150
     7.042   101.798     0.150
     7.042   132.218     0.150
     7.090   103.038     0.150
     7.090   131.688     0.150
     7.587   111.868     0.150
     7.587   144.458     0.150
     7.587   239.948     0.150
     8.044   116.818     0.150
     8.044   151.878     0.150
     8.044   251.479     0.150
     8.101   249.588     0.150
     8.643   275.998     0.150
     8.931   128.388     0.150
     9.228   131.998     0.150
     9.228   289.979     0.150
     9.911   143.008     0.150
     9.911   184.558     0.150
    10.377   149.658     0.150
    10.377   152.988     0.150
    11.448   163.408     0.150
    11.448   163.663     0.150
    11.448   358.613     0.150
    12.535   181.308     0.150
    14.343   207.138     0.150
    14.551   212.068     0.150
     0.218     4.465     0.150
     0.218     7.920     0.150
     0.331     6.445     0.150
     0.331    11.619     0.150
     0.663    12.785     0.150
     0.711    13.607     0.150
     0.711    23.322     0.150
     0.866    16.340     0.150
     0.866    27.684     0.150
     0.928    17.414     0.150
     0.928    29.623     0.150
     0.982    17.484     0.150
     0.982    30.318     0.150
     0.990    18.492     0.150
     0.964    18.252     0.150
     0.964    31.174     0.150
     1.020    19.012     0.150
     1.020    32.459     0.150
     1.209    21.236     0.150
     1.209    38.221     0.150
     1.198    21.984     0.150
     1.233    22.043     0.150
     1.233    38.293     0.150
     1.248    22.254     0.150
     1.248    38.725     0.150
     1.261    22.861     0.150
     1.261    39.799     0.150
     1.412    23.725     0.150
     1.406    23.889     0.150
     1.406    43.754     0.150
     1.509    26.635     0.150
     1.509    48.525     0.150
     1.513    26.307     0.150
     1.513    45.965     0.150
     1.513    48.295     0.150
     1.591    26.844     0.150
     1.591    49.965     0.150
     1.577    28.625     0.150
     1.577    49.385     0.150
     1.581    27.268     0.150
     1.581    29.801     0.150
     1.745    28.982     0.150
     1.745    30.969     0.150
     1.745    53.924     0.150
     1.768    29.320     0.150
     1.768    54.688     0.150
     1.790    30.023     0.150
     1.790    56.098     0.150
     1.805    33.844     0.150
     1.805    57.039     0.150
     1.807    32.377     0.150
     1.807    56.221     0.150
     1.904    31.154     0.150
     1.904    35.355     0.150
     1.900    33.471     0.150
     1.900    58.059     0.150
     1.980    31.945     0.150
     1.980    36.506     0.150
     2.015    63.219     0.150
     2.027    64.375     0.150
     2.066    33.967     0.150
     2.066    64.875     0.150
     2.098    34.066     0.150
     2.098    64.750     0.150
     2.148    37.908     0.150
     2.148    66.201     0.150
     2.164    35.547     0.150
     2.164    67.982     0.150
     2.214    68.348     0.150
     2.277    36.617     0.150
     2.319    35.961     0.150
     2.387    41.992     0.150
     2.387    73.508     0.150
     2.425    38.613     0.150
     2.425    42.346     0.150
     2.425    76.330     0.150
     2.504    40.039     0.150
     2.547    40.701     0.150
     2.547    79.055     0.150
     2.586    79.787     0.150
     2.636    41.588     0.150
     2.664    41.551     0.150
     2.694    42.572     0.150
     2.768    42.803     0.150
     2.814    44.195     0.150
     2.814    85.906     0.150
     2.853    44.459     0.150
     2.853    87.650     0.150
     2.906    45.697     0.150
     2.900    45.691     0.150
     2.963    90.828     0.150
     3.074    48.027     0.150
     3.074    94.656     0.150
     3.074    49.105     0.150
     3.074    58.275     0.150
     3.078    47.924     0.150
     3.102    48.434     0.150
     3.152    49.143     0.150
     3.222    49.502     0.150
     3.261    51.242     0.150
     3.348    51.273     0.150
     3.429    52.055     0.150
     3.460    54.561     0.150
     3.506    55.139     0.150
     3.530    53.547     0.150
     3.552    55.512     0.150
     3.630    56.539     0.150
     3.662    57.051     0.150
     3.747    58.904     0.150
     3.747    70.105     0.150
     3.846    59.328     0.150
     3.934    59.928     0.150
     3.935    61.113     0.150
     3.993    59.609     0.150
     3.990    60.930     0.150
     3.972    62.225     0.150
     3.972    73.514     0.150
     3.972   125.465     0.150
     4.023    60.094     0.150
     4.051    62.330     0.150
     4.058    63.119     0.150
     4.080    63.047     0.150
     4.100    63.025     0.150
     4.121    62.092     0.150
     4.167    63.697     0.150
     4.225    64.223     0.150
     4.240    64.711     0.150
     4.278    66.654     0.150
     4.278    79.084     0.150
     4.278   135.084     0.150
     4.279    66.314     0.150
     4.308    65.000     0.150
     4.308    66.885     0.150
     4.308    79.445     0.150
     4.342    66.895     0.150
     4.342    80.395     0.150
     4.342   136.414     0.150
     4.406    65.273     0.150
     4.430    67.920     0.150
     4.430   119.133     0.150
     4.418    67.658     0.150
     4.469    66.836     0.150
     4.499    68.766     0.150
     4.501    67.189     0.150
     4.511    69.254     0.150
     4.511    83.654     0.150
     4.511   141.404     0.150
     4.655    69.654     0.150
     4.696    71.117     0.150
     4.745    72.666     0.150
     4.762    70.234     0.150
     4.809    70.525     0.150
     4.809    90.375     0.150
     4.809   153.414     0.150
     4.820    71.443     0.150
     4.829    72.809     0.150
     4.857    77.117     0.150
     4.857   155.367     0.150
     4.919    75.736     0.150
     4.939    75.154     0.150
     4.995    73.639     0.150
     5.050    74.445     0.150
     5.139    76.479     0.150
     5.167    96.035     0.150
     5.216    77.232     0.150
     5.227    78.686     0.150
     5.367    78.938     0.150
     5.364    81.924     0.150
     5.480    80.787     0.150
     5.664    85.824     0.150
     5.664   106.945     0.150
     5.775    84.598     0.150
     5.744    86.572     0.150
     5.782    87.859     0.150
     5.883    86.881     0.150
     6.349    92.930     0.150
     6.493    96.584     0.150
     6.601    98.254     0.150
     6.601   210.805     0.150
     6.745   101.965     0.150
     6.745   126.355     0.150
     6.745   214.654     0.150
     6.749    99.355     0.150
     6.872   101.664     0.150
     6.872   129.695     0.150
     6.872   219.465     0.150
     6.917   105.375     0.150
     6.917   132.684     0.150
     6.911   104.205     0.150
     6.911   214.914     0.150
     6.950   103.594     0.150
     6.950   218.865     0.150
     7.113   106.744     0.150
     7.113   131.764     0.150
     7.113   223.314     0.150
     7.339   108.305     0.150
     7.339   139.994     0.150
     7.483   142.834     0.150
     7.483   239.975     0.150
     7.510   111.484     0.150
     7.510   139.875     0.150
     7.538   113.455     0.150
     7.633   113.684     0.150
     7.633   145.514     0.150
     7.959   116.795     0.150
     7.959   147.975     0.150
     7.959   253.855     0.150
     8.002   115.775     0.150
     8.002   151.365     0.150
     8.002   249.674     0.150
     8.129   119.684     0.150
     8.129   149.865     0.150
     8.129   254.625     0.150
     8.350   121.295     0.150
     8.350   156.664     0.150
     8.350   270.615     0.150
     8.553   129.135     0.150
     9.124   132.885     0.150
     9.124   289.984     0.150
     9.367   134.924     0.150
     9.516   140.465     0.150
     9.780   142.004     0.150
    10.080   146.885     0.150
    10.301   150.814     0.150
    10.664   158.605     0.150
    10.819   159.344     0.150
    11.605   166.695     0.150
    14.883   213.404     0.150
    20.956   284.605     0.150
    22.153   297.844     0.150
    84.460   754.645     0.150
    91.976   789.344     0.150
    93.602   794.645     0.150
    93.602  1460.445     0.150
    99.670   826.344     0.150
   100.989   832.145     0.150
   100.989   834.645     0.150
     0.239     5.030     0.150
     0.277     5.519     0.150
     0.277     9.360     0.150
     0.386     7.980     0.150
     0.458     8.910     0.150
     0.374     7.785     0.150
     0.374    13.012     0.150
     0.454     8.863     0.150
     0.454    15.253     0.150
     0.479     9.220     0.150
     0.509     9.900     0.150
     0.509    16.920     0.150
     0.543    10.380     0.150
     0.598    11.621     0.150
     0.598    19.633     0.150
     0.598    11.450     0.150
     0.692    13.210     0.150
     0.743    14.049     0.150
     0.743    24.188     0.150
     0.670    12.720     0.150
     0.670    12.601     0.150
     0.670    20.980     0.150
     0.694    13.240     0.150
     0.887    16.605     0.150
     0.887    28.581     0.150
     0.904    16.905     0.150
     0.945    17.610     0.150
     0.945    30.150     0.150
     1.039    18.070     0.150
     1.039    31.867     0.150
     1.039    32.510     0.150
     1.065    19.499     0.150
     1.065    34.419     0.150
     1.293    22.355     0.150
     1.293    40.420     0.150
     1.374    22.589     0.150
     1.374    40.588     0.150
     1.327    23.970     0.150
     1.327    41.790     0.150
     1.351    23.877     0.150
     1.351    43.386     0.150
     1.435    24.038     0.150
     1.435    44.589     0.150
     1.478    26.811     0.150
     1.478    46.110     0.150
     1.521    27.300     0.150
     1.521    47.610     0.150
     1.700    28.256     0.150
     1.700    53.300     0.150
     1.727    28.643     0.150
     1.727    55.052     0.150
     1.741    29.252     0.150
     1.741    54.485     0.150
     1.961    31.114     0.150
     1.961    59.998     0.150
     1.922    60.850     0.150
     1.994    31.962     0.150
     1.994    61.476     0.150
     1.993    61.269     0.150
     2.041    63.670     0.150
     1.960    60.979     0.150
     1.999    35.820     0.150
     1.999    62.160     0.150
     1.992    58.449     0.150
     2.091    61.084     0.150
     2.209    68.522     0.150
     2.268    36.740     0.150
     2.268    72.740     0.150
     2.320    37.090     0.150
     2.320    72.694     0.150
     2.396    74.761     0.150
     2.384    38.148     0.150
     2.384    74.523     0.150
     2.624    40.735     0.150
     2.681    42.061     0.150
     2.681    82.774     0.150
     2.673    82.428     0.150
     2.715    85.305     0.150
     2.696    83.637     0.150
     2.768    43.706     0.150
     2.768    86.724     0.150
     2.793    43.610     0.150
     2.793    87.517     0.150
     2.785    87.285     0.150
     2.967    46.007     0.150
     2.979    45.135     0.150
     3.050    94.379     0.150
     3.226    49.170     0.150
     3.165    49.060     0.150
     3.227    50.858     0.150
     3.238    51.085     0.150
     3.252    49.860     0.150
     3.232    50.151     0.150
     3.232    59.490     0.150
     3.232   100.090     0.150
     3.306    51.315     0.150
     3.467    53.338     0.150
     3.508    54.873     0.150
     3.710    56.003     0.150
     3.719    57.419     0.150
     3.830    58.951     0.150
     3.830    59.180     0.150
     3.830   118.601     0.150
     3.906    59.375     0.150
     4.063    61.694     0.150
     4.062    62.339     0.150
     4.403    65.535     0.150
     4.513    67.126     0.150
     4.520    67.120     0.150
     4.520   141.410     0.150
     4.561    69.820     0.150
     4.561   143.720     0.150
     4.700    86.160     0.150
     4.700   150.101     0.150
     4.947    83.851     0.150
     4.947   156.920     0.150
     5.040    76.580     0.150
     5.040    92.440     0.150
     5.609   179.569     0.150
     6.043    89.150     0.150
     6.043   189.330     0.150
     6.243    96.260     0.150
     6.243   116.050     0.150
     7.420   109.311     0.150
     7.420   237.120     0.150
     7.534   142.230     0.150
     7.646   144.385     0.150
     7.646   241.610     0.150
     7.646   144.160     0.150
     7.646   241.800     0.150
     7.756   114.790     0.150
     7.756   144.970     0.150
     7.756   244.630     0.150
     7.892   114.641     0.150
     7.892   146.780     0.150
     7.892   249.271     0.150
     8.180   152.735     0.150
    10.915   160.860     0.150
    11.259   163.210     0.150
     0.167     3.649     0.150
     0.167     6.128     0.150
     0.551    10.573     0.150
     0.551    17.750     0.150
     0.635    12.188     0.150
     0.635    20.764     0.150
     0.674    12.735     0.150
     0.674    21.801     0.150
     0.743    13.757     0.150
     0.743    23.954     0.150
     0.783    14.473     0.150
     0.783    24.633     0.150
     0.775    14.325     0.150
     0.775    24.650     0.150
     0.838    15.791     0.150
     0.838    26.860     0.150
     0.865    15.959     0.150
     0.865    27.609     0.150
     0.902    17.124     0.150
     0.902    29.313     0.150
     1.304    22.608     0.150
     1.304    41.368     0.150
     1.275    23.094     0.150
     1.275    40.031     0.150
     1.422    23.716     0.150
     1.422    41.280     0.150
     1.422    41.692     0.150
     1.386    24.467     0.150
     1.386    44.461     0.150
     1.492    25.647     0.150
     1.492    46.710     0.150
     1.496    26.578     0.150
     1.496    47.669     0.150
     1.542    27.663     0.150
     1.542    48.482     0.150
     1.556    27.321     0.150
     1.643    27.027     0.150
     1.611    28.603     0.150
     1.637    27.764     0.150
     1.637    50.858     0.150
     1.820    29.829     0.150
     1.757    29.938     0.150
     1.757    54.801     0.150
     1.811    30.631     0.150
     1.811    53.471     0.150
     1.875    31.818     0.150
     1.875    59.363     0.150
     1.917    32.385     0.150
     1.917    59.692     0.150
     1.976    35.463     0.150
     1.976    63.543     0.150
     2.018    33.286     0.150
     2.018    62.753     0.150
     2.035    33.568     0.150
     2.035    64.009     0.150
     2.109    33.919     0.150
     2.109    58.697     0.150
     2.225    35.173     0.150
     2.225    61.428     0.150
     2.214    36.067     0.150
     2.214    68.766     0.150
     2.214    36.953     0.150
     2.271    36.847     0.150
     2.271    70.989     0.150
     2.271    37.033     0.150
     2.268    36.926     0.150
     2.268    70.852     0.150
     2.357    36.413     0.150
     2.357    65.613     0.150
     2.358    36.721     0.150
     2.358    64.958     0.150
     2.465    39.222     0.150
     2.454    39.510     0.150
     2.534    40.807     0.150
     2.574    41.104     0.150
     2.574    41.522     0.150
     2.583    41.595     0.150
     2.583    79.840     0.150
     2.635    41.824     0.150
     2.635    82.054     0.150
     2.695    42.736     0.150
     2.695    83.106     0.150
     2.704    83.552     0.150
     2.742    43.734     0.150
     2.769    43.448     0.150
     2.769    86.111     0.150
     2.769    44.103     0.150
     2.769    51.703     0.150
     2.921    44.746     0.150
     2.921    80.162     0.150
     2.939    44.922     0.150
     2.970    46.412     0.150
     3.079    46.877     0.150
     3.079    83.113     0.150
     3.136    48.742     0.150
     3.100    48.574     0.150
     3.133    49.245     0.150
     3.235    50.993     0.150
     3.303    51.343     0.150
     3.272    51.167     0.150
     3.414    51.933     0.150
     3.372    52.295     0.150
     3.476    53.033     0.150
     3.470    53.954     0.150
     3.526    54.662     0.150
     3.628    54.934     0.150
     3.602    55.390     0.150
     3.659    56.101     0.150
     3.621    55.192     0.150
     3.659    55.693     0.150
     3.876    59.682     0.150
     4.006    61.521     0.150
     4.090    61.244     0.150
     4.133    63.401     0.150
     4.176    62.989     0.150
     4.210    62.446     0.150
     4.253    64.901     0.150
     4.282    64.982     0.150
     4.357    67.006     0.150
     4.399    66.970     0.150
     4.453    67.876     0.150
     4.471    69.204     0.150
     4.536    69.109     0.150
     4.544    69.162     0.150
     4.639    70.548     0.150
     4.693    69.694     0.150
     4.680    72.128     0.150
     4.680    71.783     0.150
     4.813    73.543     0.150
     4.883    72.128     0.150
     4.906    72.033     0.150
     4.836    74.225     0.150
     4.882    74.342     0.150
     4.945    75.145     0.150
     4.983    75.383     0.150
     4.983    92.673     0.150
     5.043    76.262     0.150
     5.072    76.676     0.150
     5.100    77.226     0.150
     5.144    78.321     0.150
     5.155    78.351     0.150
     5.140    78.311     0.150
     5.195    79.183     0.150
     5.195    96.033     0.150
     5.195   164.812     0.150
     5.262    78.863     0.150
     5.370    79.793     0.150
     5.391    79.453     0.150
     5.508    81.001     0.150
     5.514    81.509     0.150
     5.584    81.812     0.150
     5.597    82.583     0.150
     5.821    85.618     0.150
     6.020    88.781     0.150
     6.026    89.716     0.150
     6.042    89.064     0.150
     6.038    89.470     0.150
     6.100    91.079     0.150
     6.133    91.513     0.150
     6.702    97.646     0.150
     6.678   125.203     0.150
     7.343   107.562     0.150
     7.411   107.623     0.150
     9.508   136.743     0.150
     9.552   138.503     0.150
    10.773   159.719     0.150
    11.671   168.008     0.150
    11.671   368.583     0.150
    22.618   303.982     0.150
     0.167     3.805     0.150
     0.167     6.312     0.150
     0.167     3.445     0.150
     0.167     6.172     0.150
     0.551    10.477     0.150
     0.551    18.148     0.150
     0.673    12.859     0.150
     0.673    21.789     0.150
     0.740    13.922     0.150
     0.740    24.172     0.150
     0.639    12.250     0.150
     0.639    21.203     0.150
     0.783    14.383     0.150
     0.783    24.680     0.150
     0.861    16.062     0.150
     0.861    27.672     0.150
     0.837    15.930     0.150
     0.837    27.023     0.150
     0.778    14.570     0.150
     0.778    24.633     0.150
     0.904    17.180     0.150
     0.904    29.352     0.150
     1.418    23.742     0.150
     1.418    41.523     0.150
     1.418    23.477     0.150
     1.418    41.672     0.150
     1.491    25.805     0.150
     1.491    46.758     0.150
     1.497    27.742     0.150
     1.497    47.453     0.150
     1.640    27.062     0.150
     1.545    27.312     0.150
     1.545    48.031     0.150
     1.559    27.469     0.150
     1.614    28.672     0.150
     1.614    49.305     0.150
     1.641    27.930     0.150
     1.641    51.461     0.150
     1.816    52.031     0.150
     1.761    31.539     0.150
     1.761    55.078     0.150
     1.815    30.883     0.150
     1.974    33.023     0.150
     1.974    58.664     0.150
     1.974    62.742     0.150
     1.920    59.711     0.150
     2.015    33.352     0.150
     2.015    62.250     0.150
     2.035    33.531     0.150
     2.106    58.805     0.150
     2.221    35.289     0.150
     2.221    61.445     0.150
     2.217    68.609     0.150
     2.217    36.312     0.150
     2.217    40.031     0.150
     2.217    68.781     0.150
     2.354    36.836     0.150
     2.354    64.883     0.150
     2.354    36.930     0.150
     2.270    37.039     0.150
     2.274    36.891     0.150
     2.274    70.297     0.150
     2.462    39.242     0.150
     2.454    39.547     0.150
     2.533    40.797     0.150
     2.633    41.891     0.150
     2.586    79.711     0.150
     2.578    41.203     0.150
     2.692    42.703     0.150
     2.692    83.453     0.150
     2.744    43.664     0.150
     2.708    43.008     0.150
     2.771    43.961     0.150
     2.771    86.195     0.150
     2.771    44.312     0.150
     2.771    50.453     0.150
     2.771    84.781     0.150
     2.917    45.281     0.150
     2.935    45.266     0.150
     2.970    46.922     0.150
     3.076    47.133     0.150
     3.076    83.148     0.150
     3.133    48.984     0.150
     3.133    85.016     0.150
     3.099    49.133     0.150
     3.149    49.500     0.150
     3.136    49.930     0.150
     3.300    51.711     0.150
     3.371    52.508     0.150
     3.410    52.359     0.150
     3.472    53.305     0.150
     3.472    93.070     0.150
     3.523    54.406     0.150
     3.598    95.688     0.150
     3.625    55.102     0.150
     3.625    96.875     0.150
     3.601    55.797     0.150
     3.655    56.203     0.150
     3.655    97.570     0.150
     3.622    56.648     0.150
     3.873    59.891     0.150
     4.004    61.711     0.150
     4.131    63.297     0.150
     4.172    63.086     0.150
     4.206    62.688     0.150
     4.206   110.586     0.150
     4.251    65.375     0.150
     4.279    65.000     0.150
     4.396    66.922     0.150
     4.356    67.016     0.150
     4.471    68.516     0.150
     4.533    69.094     0.150
     4.542    69.430     0.150
     4.638    70.664     0.150
     4.677    71.102     0.150
     4.677    71.883     0.150
     4.690    69.781     0.150
     4.781    72.023     0.150
     4.811    72.727     0.150
     4.811    89.383     0.150
     4.811   149.555     0.150
     4.902    72.602     0.150
     4.902    92.750     0.150
     4.880    74.109     0.150
     5.007    74.680     0.150
     4.981    74.891     0.150
     4.981    92.359     0.150
     4.981   155.352     0.150
     5.152    77.727     0.150
     5.139    78.156     0.150
     5.367    79.750     0.150
     5.504    81.031     0.150
     5.596    83.023     0.150
     5.586    84.539     0.150
     5.586   104.383     0.150
     5.818    85.609     0.150
     6.016    88.953     0.150
     6.023    89.336     0.150
     6.039    89.055     0.150
     6.099    90.852     0.150
     6.131    93.984     0.150
     6.131   113.156     0.150
     6.131   192.555     0.150
     7.342   108.406     0.150
     7.342   228.312     0.150
     7.508   108.266     0.150
     7.508   137.945     0.150
     7.508   236.523     0.150
    93.835   798.836     0.150
    93.835  1027.031     0.150
    93.835  1433.031     0.150
    93.835  1467.633     0.150
     0.292     6.156     0.150
     0.292    10.148     0.150
     0.356     7.004     0.150
     0.356    11.719     0.150
     0.356    12.059     0.150
     0.645    11.797     0.150
     0.645    20.570     0.150
     0.714    13.613     0.150
     0.714    22.770     0.150
     0.837    15.199     0.150
     0.837    26.270     0.150
     0.759    14.227     0.150
     0.759    24.938     0.150
     0.876    16.219     0.150
     0.876    27.664     0.150
     0.987    17.926     0.150
     0.987    30.711     0.150
     1.059    19.512     0.150
     1.052    18.492     0.150
     1.052    32.438     0.150
     1.210    21.246     0.150
     1.210    38.203     0.150
     1.188    20.559     0.150
     1.188    37.035     0.150
     1.225    22.168     0.150
     1.225    39.090     0.150
     1.299    22.340     0.150
     1.299    41.434     0.150
     1.285    22.648     0.150
     1.285    40.168     0.150
     1.373    24.906     0.150
     1.373    43.879     0.150
     1.433    24.777     0.150
     1.433    44.043     0.150
     1.394    24.766     0.150
     1.394    43.000     0.150
     1.503    25.766     0.150
     1.503    44.945     0.150
     1.574    26.309     0.150
     1.574    49.176     0.150
     1.623    27.617     0.150
     1.623    50.590     0.150
     1.662    29.027     0.150
     1.662    51.742     0.150
     1.766    28.648     0.150
     1.766    28.980     0.150
     1.795    30.688     0.150
     1.795    56.168     0.150
     1.899    31.953     0.150
     1.899    58.832     0.150
     1.899    32.441     0.150
     1.929    31.371     0.150
     1.929    56.000     0.150
     1.969    31.512     0.150
     2.084    34.754     0.150
     2.084    65.176     0.150
     2.079    34.387     0.150
     2.079    64.609     0.150
     2.140    35.281     0.150
     2.250    35.828     0.150
     2.250    69.500     0.150
     2.295    37.938     0.150
     2.295    71.242     0.150
     2.359    37.461     0.150
     2.402    37.980     0.150
     2.402    73.914     0.150
     2.439    39.617     0.150
     2.439    76.605     0.150
     2.545    40.375     0.150
     2.545    71.582     0.150
     2.530    40.945     0.150
     2.530    78.758     0.150
     2.530    79.129     0.150
     2.600    41.832     0.150
     2.600    82.039     0.150
     2.701    41.746     0.150
     2.703    41.496     0.150
     2.807    44.852     0.150
     2.936    45.965     0.150
     2.936    90.223     0.150
     2.964    47.000     0.150
     2.957    46.895     0.150
     3.095    49.316     0.150
     3.156    49.371     0.150
     3.247    49.680     0.150
     3.281    49.664     0.150
     3.425    51.777     0.150
     3.509    55.059     0.150
     3.749    56.020     0.150
     3.804    57.465     0.150
     3.944    58.863     0.150
     4.084    63.781     0.150
     4.436    65.844     0.150
     4.507    67.457     0.150
     4.505    68.453     0.150
     4.551    67.203     0.150
     4.599    69.137     0.150
     4.692    70.855     0.150
     4.796    70.828     0.150
     4.756    72.137     0.150
     4.967    74.391     0.150
     4.946    75.023     0.150
     4.946    75.539     0.150
     4.959    75.410     0.150
     4.959    75.559     0.150
     5.028    73.895     0.150
     5.052    77.523     0.150
     5.052    93.172     0.150
     5.052   160.465     0.150
     5.106    76.531     0.150
     5.104    77.430     0.150
     5.228    76.762     0.150
     5.251    77.191     0.150
     5.226    79.613     0.150
     5.330    79.688     0.150
     5.351    79.082     0.150
     5.351    80.871     0.150
     5.386    80.102     0.150
     5.403    81.582     0.150
     5.437    82.051     0.150
     5.593    84.188     0.150
     5.705    84.195     0.150
     5.833    86.684     0.150
     5.853    85.875     0.150
     5.945    87.668     0.150
     5.952    89.402     0.150
     6.011    90.336     0.150
     6.061    90.938     0.150
     6.116    90.723     0.150
     6.126    91.355     0.150
     6.163    90.355     0.150
     6.194    92.770     0.150
     6.238    96.051     0.150
     6.278    95.270     0.150
     6.360    93.406     0.150
     6.358    94.074     0.150
     6.362    93.781     0.150
     6.386    93.520     0.150
     6.393    95.191     0.150
     6.435    96.109     0.150
     6.581    96.168     0.150
     6.767   100.641     0.150
     6.800   100.832     0.150
     6.908   102.668     0.150
     6.937   101.500     0.150
     6.921   103.352     0.150
     6.983   103.828     0.150
     6.996   104.176     0.150
     7.024   103.410     0.150
     7.086   104.273     0.150
     7.108   104.629     0.150
     7.207   104.566     0.150
     7.372   108.242     0.150
     7.426   111.480     0.150
     7.462   109.895     0.150
     7.583   112.305     0.150
     7.601   111.938     0.150
     7.582   114.121     0.150
     7.672   112.395     0.150
     7.688   111.871     0.150
     7.691   112.098     0.150
     7.733   113.441     0.150
     7.771   115.309     0.150
     8.090   119.020     0.150
     8.156   120.082     0.150
     8.168   119.648     0.150
     8.260   119.809     0.150
     8.286   120.152     0.150
     8.325   122.695     0.150
     8.543   123.980     0.150
     8.739   126.414     0.150
     8.739   273.766     0.150
     8.739   127.441     0.150
     8.897   128.785     0.150
     9.017   130.438     0.150
     9.116   133.012     0.150
     9.531   137.523     0.150
     9.616   138.262     0.150
     9.781   142.801     0.150
    10.887   158.789     0.150
    10.887   347.578     0.150
    12.014   172.113     0.150
    36.250   425.039     0.150
    81.594   736.891     0.150
    81.594   739.891     0.150
    93.591   795.590     0.150
    93.591   800.691     0.150
    93.591  1020.691     0.150
    93.591  1428.090     0.150
    93.591  1458.391     0.150
    93.591  1838.391     0.150
    99.851   826.391     0.150
     0.289     6.344     0.150
     0.289    10.422     0.150
     0.362     7.078     0.150
     0.362    11.793     0.150
     0.639    12.070     0.150
     0.639    20.648     0.150
     0.712    13.648     0.150
     0.712    22.734     0.150
     0.763    14.500     0.150
     0.763    24.738     0.150
     0.833    14.723     0.150
     0.833    25.961     0.150
     0.883    16.348     0.150
     0.883    27.738     0.150
     0.987    17.844     0.150
     0.987    30.480     0.150
     1.058    19.598     0.150
     1.058    33.578     0.150
     1.054    18.578     0.150
     1.054    33.316     0.150
     1.206    21.660     0.150
     1.206    38.062     0.150
     1.194    20.656     0.150
     1.194    37.113     0.150
     1.224    22.000     0.150
     1.294    22.477     0.150
     1.294    41.188     0.150
     1.283    22.672     0.150
     1.283    38.613     0.150
     1.377    24.812     0.150
     1.377    43.492     0.150
     1.431    25.133     0.150
     1.431    44.465     0.150
     1.400    24.898     0.150
     1.400    43.680     0.150
     1.497    25.922     0.150
     1.497    44.938     0.150
     1.580    26.445     0.150
     1.580    49.398     0.150
     1.629    27.695     0.150
     1.629    51.043     0.150
     1.664    29.109     0.150
     1.664    50.828     0.150
     1.769    28.723     0.150
     1.769    28.441     0.150
     1.800    30.707     0.150
     1.800    56.750     0.150
     1.899    31.664     0.150
     1.899    58.973     0.150
     1.899    31.992     0.150
     1.926    31.645     0.150
     1.975    31.621     0.150
     2.087    34.660     0.150
     2.087    65.422     0.150
     2.085    34.422     0.150
     2.085    64.934     0.150
     2.147    35.301     0.150
     2.147    39.332     0.150
     2.147    66.152     0.150
     2.257    40.828     0.150
     2.257    69.988     0.150
     2.295    37.523     0.150
     2.295    71.469     0.150
     2.356    37.543     0.150
     2.408    74.000     0.150
     2.445    39.473     0.150
     2.445    76.402     0.150
     2.532    40.879     0.150
     2.532    78.668     0.150
     2.532    40.773     0.150
     2.604    41.926     0.150
     2.604    81.719     0.150
     2.705    42.758     0.150
     2.707    41.676     0.150
     2.805    44.863     0.150
     2.942    46.059     0.150
     2.942    90.465     0.150
     3.098    48.973     0.150
     3.155    49.602     0.150
     3.252    49.945     0.150
     3.285    50.027     0.150
     3.428    51.859     0.150
     3.809    57.633     0.150
     3.978    60.102     0.150
     4.512    67.617     0.150
     4.511    68.438     0.150
     4.605    69.188     0.150
     4.762    72.207     0.150
     4.951    75.332     0.150
     4.953    75.480     0.150
     4.965    75.219     0.150
     4.965    75.062     0.150
     5.111    77.160     0.150
     5.232    79.477     0.150
     5.443    82.160     0.150
     5.600    84.340     0.150
     5.839    86.875     0.150
     5.958    89.598     0.150
     6.018    90.641     0.150
     6.068    91.027     0.150
     6.122    91.922     0.150
     6.200    92.723     0.150
     6.365    93.551     0.150
     6.363    94.203     0.150
     6.399    95.230     0.150
     6.441    96.281     0.150
     6.773   100.738     0.150
     6.806   101.105     0.150
     7.091   104.031     0.150
     7.677   112.586     0.150
    93.593   795.852     0.150
    93.593  1023.152     0.150
    93.593  1427.852     0.150
    93.593  1460.152     0.150
    93.593  1468.152     0.150
     0.120     3.059     0.150
     0.382     7.398     0.150
     0.382    12.680     0.150
     0.393     8.086     0.150
     0.411     7.992     0.150
     0.411    14.316     0.150
     0.475     9.098     0.150
     0.532    10.105     0.150
     0.675    12.129     0.150
     0.658    12.527     0.150
     0.658    21.738     0.150
     0.711    13.504     0.150
     0.711    22.996     0.150
     0.727    13.426     0.150
     0.727    23.469     0.150
     0.738    13.137     0.150
     0.704    13.707     0.150
     0.704    23.652     0.150
     0.772    14.016     0.150
     0.772    24.727     0.150
     0.821    14.637     0.150
     0.821    26.488     0.150
     0.821    14.168     0.150
     0.821    26.141     0.150
     0.980    16.988     0.150
     0.980    30.598     0.150
     0.971    17.797     0.150
     0.971    31.215     0.150
     1.008    18.016     0.150
     1.008    32.219     0.150
     1.108    19.371     0.150
     1.108    34.648     0.150
     1.218    21.051     0.150
     1.218    37.320     0.150
     1.270    22.258     0.150
     1.270    39.098     0.150
     1.239    21.367     0.150
     1.239    38.699     0.150
     1.401    23.656     0.150
     1.401    41.918     0.150
     1.403    23.527     0.150
     1.403    41.926     0.150
     1.350    23.418     0.150
     1.350    43.137     0.150
     1.457    24.703     0.150
     1.457    45.832     0.150
     1.576    26.168     0.150
     1.656    27.059     0.150
     1.756    27.430     0.150
     1.756    53.820     0.150
     1.718    28.215     0.150
     1.718    53.148     0.150
     1.781    29.996     0.150
     1.781    53.457     0.150
     1.812    30.316     0.150
     1.812    27.777     0.150
     1.812    49.469     0.150
     1.812    54.238     0.150
     1.827    31.316     0.150
     1.827    55.246     0.150
     1.832    30.305     0.150
     1.832    57.086     0.150
     1.860    30.633     0.150
     1.860    58.188     0.150
     1.941    32.156     0.150
     1.941    57.477     0.150
     2.110    33.848     0.150
     2.110    65.574     0.150
     2.121    34.207     0.150
     2.121    64.797     0.150
     2.160    34.281     0.150
     2.160    67.129     0.150
     2.156    34.617     0.150
     2.156    34.281     0.150
     2.156    68.133     0.150
     2.197    36.637     0.150
     2.197    63.668     0.150
     2.232    35.109     0.150
     2.232    69.086     0.150
     2.348    36.160     0.150
     2.349    37.961     0.150
     2.349    72.113     0.150
     2.370    37.090     0.150
     2.370    71.594     0.150
     2.342    41.273     0.150
     2.342    71.754     0.150
     2.372    71.480     0.150
     2.423    37.918     0.150
     2.423    74.992     0.150
     2.785    43.766     0.150
     2.785    42.879     0.150
     2.872    44.238     0.150
     3.079    47.289     0.150
     3.121    47.762     0.150
     3.240    49.676     0.150
     3.240   102.598     0.150
     3.240    49.254     0.150
     3.312    50.957     0.150
     3.495    52.285     0.150
     3.714    56.781     0.150
     3.746    56.824     0.150
     3.723    57.035     0.150
     3.894    59.504     0.150
     4.035    61.094     0.150
     4.202    64.043     0.150
     4.226    65.719     0.150
     4.226   115.688     0.150
     4.226   133.828     0.150
     4.226    63.656     0.150
     4.302    62.977     0.150
     4.355    72.727     0.150
     4.630    72.246     0.150
     4.644    70.867     0.150
     4.644   122.328     0.150
     4.834    74.547     0.150
     4.834   128.488     0.150
     5.456    83.906     0.150
     5.456   172.488     0.150
     5.498    82.309     0.150
     5.809    84.633     0.150
     5.910   187.879     0.150
     5.931    88.855     0.150
     6.003    87.742     0.150
     6.034    87.836     0.150
     6.025    89.098     0.150
     6.025   188.078     0.150
     6.149    89.777     0.150
     6.179    90.184     0.150
     6.257    90.891     0.150
     6.268    91.340     0.150
     6.426    93.926     0.150
     6.743    98.117     0.150
     6.768    98.648     0.150
     6.849    99.699     0.150
     6.995   101.535     0.150
     7.084   103.566     0.150
     7.084   226.148     0.150
     7.152   104.137     0.150
     7.189   108.016     0.150
     7.189   187.246     0.150
     7.243   107.957     0.150
     7.243   229.887     0.150
     7.249   104.566     0.150
     7.352   106.922     0.150
     7.357   106.977     0.150
     7.358   108.605     0.150
     7.358   231.559     0.150
     7.416   110.707     0.150
     7.450   109.668     0.150
     7.512   108.438     0.150
     7.512   239.246     0.150
     7.555   110.547     0.150
     7.555   140.355     0.150
     7.555   240.277     0.150
     7.643   111.398     0.150
     7.643   240.508     0.150
     7.652   111.719     0.150
     7.652   144.535     0.150
     7.652   240.586     0.150
     7.872   115.332     0.150
     7.872   244.105     0.150
     7.872   114.426     0.150
     7.935   117.328     0.150
     7.935   151.195     0.150
     7.935   251.309     0.150
     8.035   117.809     0.150
     8.109   117.188     0.150
     8.670   124.277     0.150
     8.762   125.387     0.150
     8.762   227.105     0.150
     8.884   127.496     0.150
     8.905   127.809     0.150
     8.905   127.516     0.150
     9.180   132.469     0.150
     9.286   133.793     0.150
     9.325   133.844     0.150
     9.654   139.559     0.150
     9.654   248.926     0.150
     9.965   144.266     0.150
     9.965   255.477     0.150
    10.049   143.637     0.150
    10.074   147.047     0.150
    10.109   145.797     0.150
    10.274   148.586     0.150
    10.397   149.746     0.150
    10.591   154.535     0.150
    10.610   157.008     0.150
    10.730   154.469     0.150
    10.810   154.898     0.150
    10.821   160.277     0.150
    10.857   155.387     0.150
    11.070   158.980     0.150
    11.070   349.223     0.150
    11.203   164.918     0.150
    11.439   168.105     0.150
    11.767   167.309     0.150
    11.967   171.266     0.150
    12.034   172.328     0.150
    13.558   192.598     0.150
    13.705   194.488     0.150
    13.843   196.848     0.150
    14.006   199.078     0.150
    14.230   202.605     0.150
    14.448   204.195     0.150
    14.529   206.176     0.150
    14.959   218.184     0.150
    14.959   210.047     0.150
    15.363   216.008     0.150
    15.363   221.285     0.150
    15.778   223.047     0.150
    18.184   254.047     0.150
    18.439   256.059     0.150
    21.128   286.469     0.150
    22.370   299.730     0.150
    23.490   312.406     0.150
    26.893   344.656     0.150
    29.195   363.602     0.150
    36.482   427.707     0.150
    36.756   429.957     0.150
    85.120   754.758     0.150
    92.637   791.855     0.150
    94.264   797.855     0.150
    94.264  1026.758     0.150
    94.264  1432.355     0.150
    94.264  1466.559     0.150
    94.264  1848.957     0.150
   106.004   852.355     0.150
   106.714   857.855     0.150
   106.714  1126.758     0.150
   106.714  1577.059     0.150
   106.714  2029.059     0.150
   108.168   860.758     0.150
   108.168  1106.957     0.150
   108.168  1133.457     0.150
   111.295  1113.957     0.150
     0.353     7.297     0.150
     0.446     9.019     0.150
     0.432     8.615     0.150
     0.432    14.815     0.150
     0.420     8.009     0.150
     0.450     9.019     0.150
     0.504    10.019     0.150
     0.645    12.028     0.150
     0.664    12.028     0.150
     0.719    13.028     0.150
     0.703    13.376     0.150
     0.703    23.037     0.150
     0.698    13.674     0.150
     0.698    23.223     0.150
     0.677    12.929     0.150
     0.677    22.159     0.150
     0.677    22.913     0.150
     0.747    13.969     0.150
     0.747    24.608     0.150
     0.806    14.509     0.150
     0.806    26.698     0.150
     0.806    14.039     0.150
     0.806    25.522     0.150
     0.734    14.291     0.150
     0.734    24.300     0.150
     0.951    17.249     0.150
     0.993    18.118     0.150
     0.993    31.690     0.150
     0.994    17.969     0.150
     0.994    32.169     0.150
     1.115    19.488     0.150
     1.115    34.603     0.150
     1.213    21.336     0.150
     1.213    37.606     0.150
     1.250    22.278     0.150
     1.250    38.849     0.150
     1.252    21.925     0.150
     1.252    40.257     0.150
     1.371    39.398     0.150
     1.374    23.469     0.150
     1.374    41.759     0.150
     1.375    23.822     0.150
     1.375    44.000     0.150
     1.486    47.350     0.150
     1.670    51.525     0.150
     1.742    27.648     0.150
     1.742    49.253     0.150
     1.739    54.525     0.150
     1.758    30.179     0.150
     1.758    53.139     0.150
     1.787    30.509     0.150
     1.787    28.358     0.150
     1.787    53.769     0.150
     1.853    32.778     0.150
     1.853    59.139     0.150
     1.911    32.799     0.150
     1.852    30.592     0.150
     2.139    35.799     0.150
     2.139    67.438     0.150
     2.171    66.954     0.150
     2.186    37.299     0.150
     2.186    70.209     0.150
     2.257    36.429     0.150
     2.215    36.688     0.150
     2.215    69.479     0.150
     2.239    68.808     0.150
     2.343    36.547     0.150
     2.343    70.825     0.150
     2.373    37.072     0.150
     2.373    72.562     0.150
     2.367    38.717     0.150
     2.367    71.715     0.150
     2.360    72.010     0.150
     2.447    38.452     0.150
     2.447    75.589     0.150
     2.811    42.452     0.150
     3.108    47.874     0.150
     3.265    51.879     0.150
     3.341    52.869     0.150
     3.341    64.698     0.150
     3.341    92.789     0.150
     3.490    54.389     0.150
     3.750    57.252     0.150
     4.237    65.209     0.150
     4.237    80.648     0.150
     4.237   132.938     0.150
     4.290    65.358     0.150
     4.290    81.398     0.150
     4.290   136.999     0.150
     4.668    72.429     0.150
     4.668    88.379     0.150
     4.668   148.608     0.150
     4.859    75.809     0.150
     4.859    91.068     0.150
     4.859   155.409     0.150
     5.528    90.653     0.150
     5.528   103.204     0.150
     5.528   177.729     0.150
     5.933    88.948     0.150
     5.933   113.409     0.150
     5.933   189.459     0.150
     5.955    90.729     0.150
     5.955   113.759     0.150
     5.955   189.938     0.150
     7.096   104.789     0.150
     7.096   222.559     0.150
     7.173   109.129     0.150
     7.173   227.309     0.150
     7.528   110.198     0.150
     7.528   239.068     0.150
     7.571   110.119     0.150
     7.571   239.169     0.150
     7.642   110.979     0.150
     7.642   239.898     0.150
     7.874   114.528     0.150
     7.874   146.979     0.150
     8.895   128.839     0.150
     8.895   229.028     0.150
     9.196   135.139     0.150
     9.646   139.698     0.150
    10.634   157.379     0.150
    11.056   159.754     0.150
    14.989   219.028     0.150
     0.286     5.797     0.150
     0.349     7.090     0.150
     0.350     6.809     0.150
     0.369     6.660     0.150
     0.369    11.797     0.150
     0.371     7.668     0.150
     0.486     9.547     0.150
     0.489     9.617     0.150
     0.531    10.227     0.150
     0.594    11.070     0.150
     0.594    11.340     0.150
     0.613    11.691     0.150
     0.613    19.965     0.150
     0.648    12.453     0.150
     0.648    20.801     0.150
     0.661    12.621     0.150
     0.661    21.395     0.150
     0.707    13.328     0.150
     0.707    22.750     0.150
     0.707    23.137     0.150
     0.726    13.875     0.150
     0.726    23.566     0.150
     0.841    15.711     0.150
     0.841    26.590     0.150
     0.921    17.105     0.150
     0.921    28.988     0.150
     0.946    17.570     0.150
     0.946    30.219     0.150
     0.946    32.348     0.150
     1.093    20.480     0.150
     1.093    34.609     0.150
     1.261    40.090     0.150
     1.366    22.918     0.150
     1.366    23.172     0.150
     1.376    24.789     0.150
     1.376    42.988     0.150
     1.413    24.480     0.150
     1.421    25.734     0.150
     1.421    43.910     0.150
     1.515    27.328     0.150
     1.515    47.387     0.150
     1.586    28.547     0.150
     1.586    24.977     0.150
     1.586    49.438     0.150
     1.619    28.512     0.150
     1.679    27.902     0.150
     1.666    28.898     0.150
     1.693    53.547     0.150
     1.725    30.250     0.150
     1.788    53.395     0.150
     1.873    33.438     0.150
     1.873    58.301     0.150
     2.077    34.910     0.150
     2.082    64.578     0.150
     2.138    35.738     0.150
     2.145    66.234     0.150
     2.342    40.098     0.150
     2.341    38.750     0.150
     2.942    47.867     0.150
     4.764    73.539     0.150
     4.979    74.348     0.150
     5.153    78.508     0.150
    14.729   210.000     0.150
     0.291     5.650     0.150
     0.291    10.311     0.150
     0.433     8.401     0.150
     0.433    14.669     0.150
     0.666    13.022     0.150
     0.666    22.245     0.150
     0.769    13.736     0.150
     0.905    17.200     0.150
     0.985    18.029     0.150
     0.985    31.097     0.150
     0.975    18.408     0.150
     0.975    32.019     0.150
     1.089    19.375     0.150
     1.089    33.436     0.150
     1.066    19.889     0.150
     1.066    34.158     0.150
     1.154    21.038     0.150
     1.154    35.562     0.150
     1.169    21.841     0.150
     1.169    37.404     0.150
     1.204    22.422     0.150
     1.204    38.898     0.150
     1.264    21.976     0.150
     1.264    38.822     0.150
     1.304    23.059     0.150
     1.304    39.799     0.150
     1.268    23.789     0.150
     1.268    40.274     0.150
     1.324    23.316     0.150
     1.324    40.485     0.150
     1.332    24.459     0.150
     1.332    42.419     0.150
     1.367    24.181     0.150
     1.367    42.391     0.150
     1.478    25.443     0.150
     1.478    45.535     0.150
     1.488    25.016     0.150
     1.488    45.511     0.150
     1.630    28.728     0.150
     1.623    28.929     0.150
     1.623    50.690     0.150
     1.678    28.733     0.150
     1.678    28.951     0.150
     1.678    50.091     0.150
     1.784    30.291     0.150
     1.784    53.418     0.150
     1.861    30.839     0.150
     1.861    59.188     0.150
     1.977    31.769     0.150
     1.977    60.599     0.150
     1.977    31.585     0.150
     1.977    60.233     0.150
     1.951    33.391     0.150
     2.009    32.251     0.150
     1.997    33.575     0.150
     1.997    62.637     0.150
     2.066    63.052     0.150
     2.116    35.379     0.150
     2.116    67.188     0.150
     2.253    36.669     0.150
     2.359    39.147     0.150
     2.558    42.165     0.150
     2.576    41.969     0.150
     2.749    43.163     0.150
     2.912    46.629     0.150
     2.912    91.339     0.150
     3.022    48.561     0.150
     3.040    49.118     0.150
     3.257    49.944     0.150
     3.998    60.068     0.150
     3.998    74.618     0.150
     3.998   125.608     0.150
     4.103    64.049     0.150
     4.103   132.639     0.150
     4.516    68.865     0.150
     4.501    68.889     0.150
     4.501   142.049     0.150
     4.501    69.130     0.150
     4.566    68.739     0.150
     4.562    70.429     0.150
     4.562    86.099     0.150
     4.562   146.879     0.150
     4.598    70.658     0.150
     4.598    84.959     0.150
     4.588    71.169     0.150
     4.588    84.829     0.150
     4.629    70.039     0.150
     4.744    72.459     0.150
     4.744    87.589     0.150
     4.823    73.089     0.150
     4.823   150.948     0.150
     4.823    73.498     0.150
     4.932    75.148     0.150
     4.932   154.219     0.150
     4.959    76.938     0.150
     4.959    93.929     0.150
     4.959   155.289     0.150
     5.409    79.079     0.150
     5.409   171.209     0.150
     5.802    86.653     0.150
     5.912    88.959     0.150
     5.912   108.789     0.150
     6.041    90.629     0.150
     6.041   111.299     0.150
     6.055    91.959     0.150
     6.055   113.929     0.150
     6.373    94.209     0.150
     6.454    95.809     0.150
     6.454   203.229     0.150
     6.496    98.259     0.150
     6.496   120.019     0.150
     6.496   205.919     0.150
     7.025   104.488     0.150
     7.025   131.778     0.150
     7.027   103.198     0.150
     7.027   131.329     0.150
     7.027   222.599     0.150
     7.122   104.769     0.150
     7.122   133.749     0.150
     7.122   222.408     0.150
     7.268   106.049     0.150
     7.268   134.368     0.150
     7.268   227.429     0.150
     7.586   109.079     0.150
     7.601   112.889     0.150
     7.788   113.789     0.150
     7.841   114.729     0.150
     7.938   117.238     0.150
     8.119   118.188     0.150
     8.339   122.386     0.150
     8.448   124.677     0.150
     8.454   122.851     0.150
     8.546   125.698     0.150
     8.699   127.629     0.150
     8.699   128.023     0.150
     9.658   140.704     0.150
     9.680   140.974     0.150
     9.775   144.509     0.150
     9.971   143.599     0.150
    10.509   153.999     0.150
    12.202   175.879     0.150
    12.202   385.959     0.150
    14.281   205.929     0.150
    22.428   298.729     0.150
    28.581   355.749     0.150
    35.798   419.318     0.150
    81.213   734.249     0.150
    93.180   792.249     0.150
    93.180  1017.849     0.150
    93.180  1426.049     0.150
    93.180  1456.549     0.150
    93.180  1836.249     0.150
    99.393   824.349     0.150
   100.585   828.849     0.150
   100.585   832.049     0.150
   100.585  1077.349     0.150
     0.114     3.140     0.150
     0.114     2.938     0.150
     0.114     5.146     0.150
     0.348     6.760     0.150
     0.475     8.904     0.150
     0.475    15.175     0.150
     0.408     8.140     0.150
     0.408    13.840     0.150
     0.419     8.239     0.150
     0.419    14.390     0.150
     0.458    15.979     0.150
     0.507     9.560     0.150
     0.487     9.590     0.150
     0.487    16.260     0.150
     0.503     9.899     0.150
     0.503    16.779     0.150
     0.621    11.500     0.150
     0.621    11.703     0.150
     0.621    19.819     0.150
     0.633    11.908     0.150
     0.726    13.710     0.150
     0.726    23.729     0.150
     0.923    17.298     0.150
     0.923    29.825     0.150
     1.006    17.872     0.150
     1.048    19.043     0.150
     1.048    32.824     0.150
     1.062    18.649     0.150
     1.121    20.319     0.150
     1.121    20.899     0.150
     1.121    34.500     0.150
     1.121    38.000     0.150
     1.291    21.824     0.150
     1.286    23.300     0.150
     1.286    40.580     0.150
     1.347    24.690     0.150
     1.347    42.636     0.150
     1.349    24.330     0.150
     1.542    25.972     0.150
     1.542    47.766     0.150
     1.479    26.239     0.150
     1.646    29.487     0.150
     1.646    50.748     0.150
     1.713    27.979     0.150
     1.768    29.821     0.150
     1.879    31.013     0.150
     1.879    58.459     0.150
     1.872    32.659     0.150
     1.872    58.739     0.150
     1.881    33.890     0.150
     1.881    58.159     0.150
     1.922    33.140     0.150
     1.922    59.600     0.150
     2.069    64.066     0.150
     2.087    37.399     0.150
     2.088    37.739     0.150
     2.196    34.556     0.150
     2.266    36.282     0.150
     2.287    70.444     0.150
     2.324    40.909     0.150
     2.324    72.229     0.150
     2.331    38.649     0.150
     2.319    71.484     0.150
     2.889    44.318     0.150
     3.175    47.762     0.150
     3.184    51.250     0.150
     3.184    59.109     0.150
     3.184   100.029     0.150
     3.640    56.540     0.150
     3.640    67.770     0.150
     3.640   113.880     0.150
     4.754    70.109     0.150
     4.754   134.640     0.150
     4.837    73.520     0.150
     4.837    92.779     0.150
     4.837   152.229     0.150
     5.117    75.939     0.150
     5.117    93.920     0.150
     5.117   165.040     0.150
     5.165    78.470     0.150
     5.165   100.140     0.150
     5.165   162.409     0.150
     5.345    81.909     0.150
     5.345   100.130     0.150
     5.345   168.159     0.150
     5.380    82.100     0.150
     5.380   100.140     0.150
     5.380   168.380     0.150
     5.648    82.425     0.150
     5.894    87.989     0.150
     5.894   110.500     0.150
     6.004    90.149     0.150
     6.004   114.180     0.150
     6.004   187.489     0.150
     6.039    90.580     0.150
     6.039   110.290     0.150
     6.039   188.260     0.150
     6.449   123.060     0.150
     7.240   105.659     0.150
     7.694   113.010     0.150
     7.787   114.449     0.150
     7.787   243.725     0.150
     8.111   119.449     0.150
     8.159   120.689     0.150
     8.159   152.439     0.150
     8.159   253.920     0.150
     8.455   123.125     0.150
    11.134   164.500     0.150
     0.110     3.109     0.150
     0.111     2.770     0.150
     0.111     5.000     0.150
     0.343     6.719     0.150
     0.406     8.121     0.150
     0.406    13.891     0.150
     0.452    14.941     0.150
     0.421     8.250     0.150
     0.421    14.051     0.150
     0.472     8.793     0.150
     0.472    14.977     0.150
     0.500     9.512     0.150
     0.490     9.602     0.150
     0.490    16.230     0.150
     0.549    10.859     0.150
     0.506     9.922     0.150
     0.544    10.531     0.150
     0.544    17.492     0.150
     0.627    11.617     0.150
     0.627    19.434     0.150
     0.627    11.512     0.150
     0.636    11.684     0.150
     0.636    20.500     0.150
     0.636    20.531     0.150
     0.721    13.699     0.150
     0.929    17.332     0.150
     0.929    29.590     0.150
     1.008    17.910     0.150
     1.008    30.562     0.150
     1.056    19.082     0.150
     1.056    32.980     0.150
     1.053    19.070     0.150
     1.053    32.508     0.150
     1.115    20.270     0.150
     1.115    34.672     0.150
     1.288    21.781     0.150
     1.282    23.121     0.150
     1.282    40.609     0.150
     1.343    24.180     0.150
     1.354    24.691     0.150
     1.354    42.762     0.150
     1.473    26.410     0.150
     1.473    46.441     0.150
     1.544    25.906     0.150
     1.544    47.801     0.150
     1.652    28.980     0.150
     1.652    51.031     0.150
     1.773    29.574     0.150
     1.773    29.832     0.150
     1.773    53.652     0.150
     1.875    33.891     0.150
     1.883    58.680     0.150
     1.878    32.539     0.150
     1.878    57.691     0.150
     1.928    32.531     0.150
     1.928    57.652     0.150
     1.955    36.020     0.150
     2.082    36.172     0.150
     2.075    35.703     0.150
     2.192    34.574     0.150
     2.337    37.969     0.150
     2.886    44.152     0.150
     3.170    47.672     0.150
     3.190    50.109     0.150
     3.190    61.492     0.150
     3.644    56.609     0.150
     3.644    99.812     0.150
     4.750    69.992     0.150
     4.750    90.551     0.150
     4.750   127.582     0.150
     4.837    73.410     0.150
     4.837    92.742     0.150
     5.169    77.801     0.150
     5.169    98.219     0.150
     5.169   138.590     0.150
     5.654    86.422     0.150
     5.893    86.789     0.150
     5.893   154.730     0.150
     6.010    89.160     0.150
     6.010   115.449     0.150
     6.010   158.480     0.150
     6.045    89.520     0.150
     6.045   160.160     0.150
     7.236   105.699     0.150
     7.236   189.969     0.150
     7.460   110.281     0.150
     7.695   113.262     0.150
     7.721   113.480     0.150
     7.793   114.590     0.150
     7.793   144.566     0.150
     8.112   118.789     0.150
     8.161   119.379     0.150
     8.453   121.367     0.150
     9.376   134.762     0.150
    11.465   165.266     0.150
    11.465   360.914     0.150
    14.825   211.812     0.150
    15.270   219.016     0.150
    15.270   218.621     0.150
    29.543   368.324     0.150
     0.219     4.421     0.150
     0.219     7.950     0.150
     0.219     4.254     0.150
     0.501     9.328     0.150
     0.685    12.628     0.150
     0.685    21.996     0.150
     0.682    12.992     0.150
     0.682    22.425     0.150
     0.698    13.155     0.150
     0.698    22.816     0.150
     0.744    13.504     0.150
     0.744    23.164     0.150
     0.766    13.924     0.150
     0.766    24.091     0.150
     0.780    14.590     0.150
     0.780    24.874     0.150
     0.846    15.541     0.150
     0.846    26.913     0.150
     0.962    18.296     0.150
     0.962    31.383     0.150
     1.098    19.904     0.150
     1.098    33.273     0.150
     1.305    22.545     0.150
     1.305    40.934     0.150
     1.333    24.121     0.150
     1.333    42.360     0.150
     1.376    22.907     0.150
     1.422    26.474     0.150
     1.422    43.983     0.150
     1.433    25.096     0.150
     1.522    26.043     0.150
     1.522    47.803     0.150
     1.553    27.151     0.150
     1.599    27.413     0.150
     1.620    26.627     0.150
     1.671    27.842     0.150
     1.671    50.426     0.150
     1.811    31.412     0.150
     1.811    56.334     0.150
     1.833    30.892     0.150
     1.833    54.164     0.150
     1.930    32.359     0.150
     1.930    59.934     0.150
     1.977    33.020     0.150
     1.977    61.474     0.150
     2.026    32.926     0.150
     2.026    62.995     0.150
     2.077    34.058     0.150
     2.100    33.781     0.150
     2.100    64.140     0.150
     2.270    37.218     0.150
     2.270    70.601     0.150
     2.270    70.844     0.150
     2.319    37.100     0.150
     2.328    37.829     0.150
     2.328    72.726     0.150
     2.478    41.644     0.150
     2.502    40.348     0.150
     2.642    42.093     0.150
     2.642    81.315     0.150
     2.749    42.942     0.150
     2.800    44.273     0.150
     2.829    44.617     0.150
     2.829    87.812     0.150
     2.829    45.034     0.150
     2.829    49.084     0.150
     2.829    51.904     0.150
     2.829    78.214     0.150
     2.829    88.023     0.150
     3.034    47.974     0.150
     3.087    48.183     0.150
     3.187    51.044     0.150
     3.271    51.394     0.150
     3.271    61.063     0.150
     3.271    91.674     0.150
     3.271   104.174     0.150
     3.285    51.848     0.150
     3.362    50.329     0.150
     3.362    50.624     0.150
     3.362    61.054     0.150
     3.362   105.864     0.150
     4.674    71.804     0.150
     4.674   149.404     0.150
     4.716    71.704     0.150
     4.838    73.943     0.150
     4.862    71.244     0.150
     4.990    75.364     0.150
     4.990   155.514     0.150
     5.252    80.199     0.150
     5.252    97.799     0.150
     5.252   167.225     0.150
     5.644    84.344     0.150
     5.644   103.733     0.150
     5.656    84.233     0.150
     5.656   106.824     0.150
     5.656   176.264     0.150
     5.794    86.404     0.150
     6.133    92.063     0.150
     6.133   113.634     0.150
     6.133   192.233     0.150
     6.156    92.294     0.150
     6.156   113.854     0.150
     7.053   103.193     0.150
     7.053   221.914     0.150
     7.234   106.684     0.150
     7.234   134.063     0.150
     7.234   226.364     0.150
     7.306   106.084     0.150
     7.376   109.374     0.150
     7.397   109.824     0.150
     7.397   232.249     0.150
     7.397   109.164     0.150
     7.418   108.874     0.150
     7.418   191.504     0.150
     7.428   111.934     0.150
     7.509   111.284     0.150
     7.642   110.824     0.150
     7.875   116.284     0.150
     7.875   248.744     0.150
     7.939   117.454     0.150
     7.939   246.754     0.150
     7.988   116.914     0.150
     7.988   253.414     0.150
     8.191   118.864     0.150
     8.182   119.523     0.150
     8.216   120.604     0.150
     8.398   122.424     0.150
     8.398   262.924     0.150
     8.398   121.824     0.150
     8.398   264.364     0.150
     8.680   129.414     0.150
     8.854   128.264     0.150
     8.854   281.934     0.150
     9.057   134.313     0.150
     9.392   138.634     0.150
     9.392   294.813     0.150
     9.558   139.813     0.150
     9.558   297.184     0.150
     9.703   144.878     0.150
     9.893   144.714     0.150
    10.016   147.714     0.150
    10.248   149.654     0.150
    10.273   149.594     0.150
    10.778   158.233     0.150
    10.801   158.594     0.150
    10.801   159.224     0.150
    10.801   344.074     0.150
    10.865   157.054     0.150
    11.168   164.494     0.150
    11.247   164.844     0.150
    11.323   166.334     0.150
    11.384   164.313     0.150
    11.624   166.599     0.150
    12.084   173.594     0.150
    12.780   184.644     0.150
    13.422   190.443     0.150
    14.218   201.824     0.150
    14.406   203.494     0.150
    14.405   203.794     0.150
    14.428   212.834     0.150
    14.494   206.504     0.150
    14.567   207.744     0.150
    14.683   207.644     0.150
    14.864   213.924     0.150
    14.864   213.374     0.150
    15.078   213.324     0.150
    15.109   220.744     0.150
    15.383   218.834     0.150
    15.452   222.074     0.150
    15.518   220.494     0.150
    15.761   225.104     0.150
    15.784   220.693     0.150
    16.028   227.094     0.150
    17.155   238.924     0.150
    17.853   248.034     0.150
    18.408   254.364     0.150
    18.568   264.844     0.150
    18.977   262.224     0.150
    19.940   274.754     0.150
    21.431   288.894     0.150
    21.511   290.414     0.150
    21.672   292.214     0.150
    22.412   300.733     0.150
    23.609   314.134     0.150
    23.623   310.844     0.150
    24.842   322.394     0.150
    26.924   341.049     0.150
    29.140   360.761     0.150
    36.310   424.974     0.150
    36.487   427.023     0.150
    36.856   427.904     0.150
    37.072   429.983     0.150
    40.480   459.273     0.150
    93.893   794.474     0.150
    93.893  1023.674     0.150
    93.893  1464.273     0.150
    93.893  1843.574     0.150
    96.627   810.974     0.150
   100.068   826.574     0.150
   101.296   829.174     0.150
   105.629   848.273     0.150
   107.759   858.974     0.150
   107.759  1105.174     0.150
   107.759  1128.773     0.150
   146.932  1182.724     0.150
     0.167     3.945     0.150
     0.167     6.516     0.150
     0.162     4.062     0.150
     0.183     4.406     0.150
     0.192     4.023     0.150
     0.192     3.766     0.150
     0.192     7.117     0.150
     0.247     5.492     0.150
     0.314     6.977     0.150
     0.485     9.625     0.150
     0.482     9.305     0.150
     0.493     9.766     0.150
     0.532     9.984     0.150
     0.532    17.367     0.150
     0.511    10.062     0.150
     0.517    10.047     0.150
     0.554    10.820     0.150
     0.560    10.500     0.150
     0.564    10.984     0.150
     0.549    10.703     0.150
     0.606    11.680     0.150
     0.580    11.227     0.150
     0.611    11.602     0.150
     0.611    20.531     0.150
     0.693    13.047     0.150
     0.737    13.875     0.150
     0.737    13.836     0.150
     0.718    12.953     0.150
     0.711    13.320     0.150
     0.755    13.805     0.150
     0.755    14.016     0.150
     0.755    24.055     0.150
     0.753    13.664     0.150
     0.753    23.750     0.150
     0.753    14.133     0.150
     0.771    14.477     0.150
     0.780    14.266     0.150
     0.780    25.023     0.150
     0.777    14.445     0.150
     0.831    15.469     0.150
     0.831    26.453     0.150
     0.859    16.445     0.150
     0.847    15.812     0.150
     0.890    16.383     0.150
     0.890    27.891     0.150
     0.901    16.289     0.150
     0.901    28.398     0.150
     0.922    16.930     0.150
     0.909    17.227     0.150
     0.909    16.844     0.150
     0.928    17.070     0.150
     0.973    18.086     0.150
     0.991    18.141     0.150
     1.145    20.664     0.150
     1.142    20.852     0.150
     1.265    22.719     0.150
     1.265    22.883     0.150
     1.269    22.984     0.150
     1.298    23.477     0.150
     1.330    23.875     0.150
     1.343    22.859     0.150
     1.343    23.922     0.150
     1.406    25.750     0.150
     1.410    24.516     0.150
     1.410    24.953     0.150
     1.440    25.320     0.150
     1.491    26.367     0.150
     1.508    26.000     0.150
     1.529    25.953     0.150
     1.529    26.805     0.150
     1.526    26.273     0.150
     1.525    26.711     0.150
     1.525    26.547     0.150
     1.561    26.445     0.150
     1.526    25.852     0.150
     1.526    26.562     0.150
     1.593    28.336     0.150
     1.604    27.891     0.150
     1.605    26.672     0.150
     1.625    28.172     0.150
     1.609    28.055     0.150
     1.679    28.703     0.150
     1.683    28.977     0.150
     1.683    30.617     0.150
     1.740    28.953     0.150
     1.740    29.797     0.150
     1.747    29.742     0.150
     1.775    29.727     0.150
     1.775    53.156     0.150
     1.769    31.562     0.150
     1.766    30.102     0.150
     1.892    31.477     0.150
     1.913    31.859     0.150
     1.913    60.094     0.150
     1.913    32.234     0.150
     1.926    32.430     0.150
     1.953    30.273     0.150
     2.012    33.242     0.150
     2.056    33.562     0.150
     2.056    64.359     0.150
     2.064    33.594     0.150
     2.064    34.266     0.150
     2.126    35.297     0.150
     2.134    35.414     0.150
     2.136    35.406     0.150
     2.199    34.969     0.150
     2.199    68.797     0.150
     2.199    36.031     0.150
     2.217    36.516     0.150
     2.247    35.734     0.150
     2.274    36.992     0.150
     2.274    71.352     0.150
     2.323    38.016     0.150
     2.456    39.820     0.150
     2.478    39.562     0.150
     2.489    40.727     0.150
     2.525    40.125     0.150
     2.525    70.586     0.150
     2.555    41.375     0.150
     2.574    41.219     0.150
     2.574    41.602     0.150
     2.631    42.852     0.150
     2.655    42.570     0.150
     2.672    43.172     0.150
     2.678    41.695     0.150
     2.694    43.117     0.150
     2.754    43.531     0.150
     2.768    44.375     0.150
     2.768    86.977     0.150
     2.768    43.648     0.150
     2.768    85.922     0.150
     2.779    44.406     0.150
     2.793    44.742     0.150
     2.834    45.484     0.150
     2.861    45.070     0.150
     2.869    45.891     0.150
     2.988    46.977     0.150
     3.053    47.445     0.150
     3.115    48.820     0.150
     3.107    49.297     0.150
     3.178    50.312     0.150
     3.221    50.320     0.150
     3.230    50.844     0.150
     3.266    50.883     0.150
     3.280    51.312     0.150
     3.349    52.742     0.150
     3.434    51.203     0.150
     3.455    53.531     0.150
     3.514    55.133     0.150
     3.524    54.875     0.150
     3.524    54.711     0.150
     3.636    56.188     0.150
     3.657    56.258     0.150
     3.790    60.547     0.150
     3.892    60.375     0.150
     3.892    60.023     0.150
     4.270    65.734     0.150
     4.273    66.172     0.150
     4.680    71.070     0.150
     4.680    71.570     0.150
     4.719    71.383     0.150
     4.848    73.375     0.150
     4.897    74.727     0.150
     4.932    71.977     0.150
     4.932   130.070     0.150
     4.932    72.102     0.150
     4.971    74.727     0.150
     5.017    76.672     0.150
     5.111    77.852     0.150
     5.207    78.773     0.150
     5.207    78.820     0.150
     5.207   165.727     0.150
     5.470    83.000     0.150
     5.585    83.773     0.150
     5.604    85.977     0.150
     5.604   146.414     0.150
     5.733    86.523     0.150
     5.847    86.992     0.150
     5.861    88.586     0.150
     6.145    92.805     0.150
     6.146    91.906     0.150
     6.169    92.273     0.150
     6.367    97.070     0.150
     6.369    95.484     0.150
     6.578    98.586     0.150
     6.765   101.422     0.150
     6.890   103.031     0.150
     6.955   103.875     0.150
     7.007   106.016     0.150
     7.020   104.375     0.150
     7.106   107.195     0.150
     7.106   183.703     0.150
     7.099   104.430     0.150
     7.099   184.977     0.150
     7.213   109.992     0.150
     7.249   108.555     0.150
     7.376   108.672     0.150
     7.378   108.875     0.150
     7.378   138.172     0.150
     7.378   233.117     0.150
     7.378   108.977     0.150
     7.423   110.852     0.150
     7.448   111.070     0.150
     7.550   111.773     0.150
     7.598   114.852     0.150
     7.650   114.992     0.150
     7.812   115.477     0.150
     7.828   115.852     0.150
     7.840   114.617     0.150
     7.858   113.812     0.150
     7.858   202.992     0.150
     7.906   116.977     0.150
     7.943   117.750     0.150
     7.961   115.906     0.150
     7.973   117.805     0.150
     7.983   117.297     0.150
     8.080   119.852     0.150
     8.140   120.672     0.150
     8.187   122.414     0.150
     8.223   122.867     0.150
     8.252   120.125     0.150
     8.243   122.164     0.150
     8.249   122.211     0.150
     8.265   122.430     0.150
     8.376   123.992     0.150
     8.456   123.273     0.150
     8.456   123.172     0.150
     8.456   122.953     0.150
     8.449   125.086     0.150
     8.458   127.023     0.150
     8.492   126.312     0.150
     8.504   126.070     0.150
     8.592   127.164     0.150
     8.759   129.484     0.150
     8.759   946.484     0.150
     8.849   129.773     0.150
     8.871   131.102     0.150
     8.913   132.211     0.150
     8.931   131.906     0.150
     8.944   131.570     0.150
     8.950   132.133     0.150
     8.977   129.242     0.150
     9.058   133.672     0.150
     9.111   134.492     0.150
     9.138   134.727     0.150
     9.169   135.250     0.150
     9.259   136.562     0.150
     9.415   138.383     0.150
     9.484   139.672     0.150
     9.591   140.102     0.150
     9.647   143.578     0.150
     9.912   148.227     0.150
     9.937   144.727     0.150
     9.991   147.367     0.150
    10.255   150.023     0.150
    10.486   156.922     0.150
    10.551   153.820     0.150
    10.704   157.125     0.150
    10.753   156.945     0.150
    10.807   157.961     0.150
    10.808   158.422     0.150
    10.808   158.422     0.150
    10.808   347.859     0.150
    10.812   157.977     0.150
    10.864   159.602     0.150
    10.948   160.844     0.150
    10.985   161.820     0.150
    11.059   162.602     0.150
    11.168   163.422     0.150
    11.241   164.391     0.150
    11.361   164.992     0.150
    11.246   164.812     0.150
    11.321   166.516     0.150
    11.446   164.367     0.150
    11.562   170.227     0.150
    11.694   166.875     0.150
    11.695   167.875     0.150
    11.695   167.820     0.150
    11.695   296.125     0.150
    11.695   366.875     0.150
    11.734   173.297     0.150
    11.781   172.914     0.150
    11.882   174.734     0.150
    12.004   176.156     0.150
    12.021   175.773     0.150
    12.048   177.781     0.150
    12.079   178.422     0.150
    12.102   175.023     0.150
    12.361   178.320     0.150
    12.507   182.695     0.150
    12.548   184.445     0.150
    12.722   186.570     0.150
    12.768   186.812     0.150
    13.137   192.172     0.150
    13.161   192.781     0.150
    13.199   192.125     0.150
    13.222   193.336     0.150
    13.420   195.555     0.150
    13.532   196.320     0.150
    13.701   198.594     0.150
    13.741   200.492     0.150
    13.744   199.242     0.150
    13.914   201.773     0.150
    13.991   203.156     0.150
    14.166   201.492     0.150
    14.174   204.992     0.150
    14.178   205.320     0.150
    14.198   205.586     0.150
    14.368   208.625     0.150
    14.407   207.367     0.150
    14.424   205.477     0.150
    14.426   208.094     0.150
    14.475   207.672     0.150
    14.472   209.336     0.150
    14.548   210.961     0.150
    14.662   211.672     0.150
    14.743   208.672     0.150
    14.835   212.773     0.150
    14.835   471.820     0.150
    14.835   213.227     0.150
    15.030   216.031     0.150
    15.073   216.227     0.150
    15.577   221.422     0.150
    15.741   225.133     0.150
    15.809   225.133     0.150
    15.840   224.414     0.150
    16.094   227.734     0.150
    16.080   230.023     0.150
    16.592   238.711     0.150
    17.000   239.312     0.150
    17.213   242.086     0.150
    17.637   248.492     0.150
    17.921   251.070     0.150
    18.601   258.867     0.150
    19.037   263.273     0.150
    19.226   267.617     0.150
    19.919   272.672     0.150
    20.041   276.133     0.150
    20.238   278.383     0.150
    20.550   280.945     0.150
    21.452   289.781     0.150
    21.566   291.195     0.150
    21.705   293.781     0.150
    21.832   294.172     0.150
    21.852   295.625     0.150
    21.898   295.594     0.150
    22.109   300.344     0.150
    22.472   301.273     0.150
    22.565   302.344     0.150
    22.632   303.172     0.150
    22.808   304.367     0.150
    23.506   311.695     0.150
    23.621   311.773     0.150
    23.621   311.875     0.150
    23.803   315.242     0.150
    24.414   319.195     0.150
    24.441   320.414     0.150
    24.645   322.586     0.150
    24.764   323.977     0.150
    24.908   324.531     0.150
    24.957   327.273     0.150
    25.262   327.766     0.150
    25.343   328.820     0.150
    25.463   330.617     0.150
    26.391   337.961     0.150
    26.626   340.648     0.150
    26.626   341.031     0.150
    26.981   342.820     0.150
    26.981   343.141     0.150
    27.101   344.414     0.150
    27.508   347.875     0.150
    27.560   348.664     0.150
    28.017   354.523     0.150
    29.115   361.266     0.150
    29.115   361.516     0.150
    29.190   362.977     0.150
    29.566   366.773     0.150
    29.917   373.273     0.150
    30.633   378.156     0.150
    30.872   376.195     0.150
    31.536   384.695     0.150
    31.553   385.500     0.150
    31.801   385.836     0.150
    31.833   382.953     0.150
    32.277   393.883     0.150
    33.026   401.852     0.150
    33.075   398.406     0.150
    33.376   400.914     0.150
    33.782   403.922     0.150
    33.797   403.875     0.150
    33.950   405.766     0.150
    33.987   407.297     0.150
    34.085   406.312     0.150
    34.298   406.766     0.150
    34.445   410.031     0.150
    34.479   408.977     0.150
    34.479   410.516     0.150
    34.580   412.273     0.150
    34.657   411.711     0.150
    34.674   411.547     0.150
    34.721   412.977     0.150
    34.814   412.273     0.150
    34.928   415.172     0.150
    35.051   415.367     0.150
    35.087   415.773     0.150
    35.205   417.094     0.150
    35.626   420.531     0.150
    35.624   420.492     0.150
    35.657   420.492     0.150
    35.870   422.484     0.150
    36.145   424.672     0.150
    36.202   424.875     0.150
    36.212   426.172     0.150
    36.238   429.062     0.150
    36.270   424.445     0.150
    36.270   425.070     0.150
    36.387   426.477     0.150
    36.437   426.164     0.150
    36.437   426.273     0.150
    36.437   426.273     0.150
    36.635   428.234     0.150
    36.670   429.172     0.150
    36.806   433.273     0.150
    36.990   432.477     0.150
    36.982   431.195     0.150
    37.289   433.477     0.150
    37.320   433.547     0.150
    37.597   438.375     0.150
    37.829   438.234     0.150
    37.870   439.742     0.150
    38.804   537.562     0.150
    39.094   451.305     0.150
    39.120   450.102     0.150
    39.167   450.844     0.150
    39.412   450.961     0.150
    40.505   459.023     0.150
    40.505   459.664     0.150
    42.256   473.773     0.150
    42.679   477.398     0.150
    44.318   491.453     0.150
    44.878   493.922     0.150
    45.858   503.977     0.150
    46.639   513.727     0.150
    47.046   517.586     0.150
    47.377   519.953     0.150
    47.392   518.250     0.150
    47.623   521.086     0.150
    47.750   517.680     0.150
    48.158   524.484     0.150
    48.251   525.617     0.150
    48.410   525.062     0.150
    48.410   525.617     0.150
    48.563   529.570     0.150
    48.598   526.742     0.150
    48.632   528.211     0.150
    48.680   529.000     0.150
    48.728   526.836     0.150
    48.754   525.617     0.150
    49.057   527.195     0.150
    50.018   535.977     0.150
    50.323   537.375     0.150
    50.323   538.039     0.150
    52.569   554.375     0.150
    54.165   572.070     0.150
    54.657   574.570     0.150
    54.657   631.172     0.150
    54.904   572.273     0.150
    54.904   572.055     0.150
    61.169  1118.773     0.150
    61.315   617.875     0.150
    61.315   620.773     0.150
    61.685   619.523     0.150
    61.689   623.547     0.150
    61.689   619.523     0.150
    62.982   628.492     0.150
    62.982   632.164     0.150
    63.154   633.977     0.150
    64.065   637.273     0.150
    65.861   649.305     0.150
    67.615   658.172     0.150
    71.083   684.477     0.150
    71.083   703.477     0.150
    71.083  1238.070     0.150
    71.840   685.719     0.150
    72.158   687.016     0.150
    72.991   690.172     0.150
    72.991     4.000     0.150
    72.991   708.773     0.150
    72.991  1291.773     0.150
    72.991   695.820     0.150
    73.657   694.125     0.150
    73.657   694.125     0.150
    73.745   699.273     0.150
    74.555   703.047     0.150
    74.555   705.367     0.150
    75.308   709.773     0.150
    76.239   713.070     0.150
    76.524   714.570     0.150
    76.524     3.305     0.150
    76.524   719.273     0.150
    76.524   725.570     0.150
    76.524  1302.375     0.150
    76.524  1330.875     0.150
    76.524  1599.172     0.150
    76.690   712.305     0.150
    76.708   712.273     0.150
    76.708   712.523     0.150
    76.708   712.523     0.150
    79.094   727.695     0.150
    79.723   727.172     0.150
    80.502   737.570     0.150
    80.698   733.875     0.150
    80.698   733.898     0.150
    80.778   734.125     0.150
    80.843   735.875     0.150
    80.948   741.570     0.150
    81.174   740.672     0.150
    81.430   738.773     0.150
    81.528   738.008     0.150
    81.529   738.930     0.150
    81.529   738.172     0.150
    81.529  1351.570     0.150
    81.568   744.250     0.150
    81.577   742.570     0.150
    81.577   747.336     0.150
    81.788   740.773     0.150
    81.788   746.977     0.150
    81.858   738.875     0.150
    81.858  1349.172     0.150
    82.030   744.406     0.150
    82.030  1370.836     0.150
    82.173   746.672     0.150
    82.255   747.273     0.150
    82.332   745.273     0.150
    82.406   742.773     0.150
    82.690   743.672     0.150
    82.905   752.273     0.150
    82.905     3.797     0.150
    82.905   750.875     0.150
    83.187   753.875     0.150
    83.187     3.797     0.150
    83.441   753.477     0.150
    83.785   756.273     0.150
    83.785     4.102     0.150
    84.039   753.375     0.150
    84.086   757.875     0.150
    84.086     3.695     0.150
    84.190   752.477     0.150
    84.244   758.672     0.150
    84.244     3.805     0.150
    84.601   760.477     0.150
    84.601     3.695     0.150
    84.646  1383.375     0.150
    84.673     3.695     0.150
    84.673  1385.773     0.150
    84.673  1442.773     0.150
    84.776   759.070     0.150
    84.862   756.414     0.150
    84.934   762.375     0.150
    84.934     3.500     0.150
    84.948   762.070     0.150
    84.948     3.805     0.150
    85.039   762.273     0.150
    85.039     3.898     0.150
    85.111   763.070     0.150
    85.111     3.602     0.150
    85.113   762.875     0.150
    85.113     3.898     0.150
    85.129   762.875     0.150
    85.129     4.000     0.150
    85.147   763.773     0.150
    85.147     3.703     0.150
    85.190   763.375     0.150
    85.190     3.797     0.150
    85.261   760.375     0.150
    85.305   763.773     0.150
    85.305     4.000     0.150
    85.652   765.344     0.150
    85.771   765.766     0.150
    85.795   768.594     0.150
    85.907   765.977     0.150
    85.907  1401.172     0.150
    85.990   766.750     0.150
    86.203   767.672     0.150
    86.207   767.570     0.150
    86.271   768.773     0.150
    86.271     4.000     0.150
    86.315   768.172     0.150
    86.345   766.172     0.150
    86.473   768.977     0.150
    86.499   765.273     0.150
    86.577   768.977     0.150
    86.577  1407.570     0.150
    86.849   771.172     0.150
    86.849   767.023     0.150
    86.996  1405.375     0.150
    87.241   772.672     0.150
    87.476   773.672     0.150
    87.476   773.672     0.150
    87.677   774.672     0.150
    88.180   777.773     0.150
    88.228   775.570     0.150
    88.228   777.867     0.150
    88.489   777.172     0.150
    88.836   777.875     0.150
    89.023   781.773     0.150
    89.106   782.773     0.150
    89.448   780.570     0.150
    89.725   784.773     0.150
    90.029   786.172     0.150
    90.073   786.273     0.150
    90.405   787.375     0.150
    90.405  1505.875     0.150
    90.405  1798.070     0.150
    90.405   783.742     0.150
    90.412   785.477     0.150
    90.412   787.477     0.150
    90.430   785.727     0.150
    90.443   783.297     0.150
    90.443   783.297     0.150
    90.469   784.375     0.150
    90.469   993.977     0.150
    90.938   785.102     0.150
    90.938   789.477     0.150
    90.938   785.070     0.150
    90.939   788.773     0.150
    90.941   788.945     0.150
    90.984   788.273     0.150
    91.048   785.422     0.150
    91.052   786.125     0.150
    91.052   785.422     0.150
    91.052   789.773     0.150
    91.700   795.172     0.150
    92.181   786.672     0.150
    92.181  1440.875     0.150
    92.181  1817.875     0.150
    92.315   796.727     0.150
    92.665   797.570     0.150
    93.042   796.875     0.150
    93.258   800.570     0.150
    93.680   799.477     0.150
    93.790   802.875     0.150
    93.833   798.375     0.150
    93.833  1026.070     0.150
    93.833  1430.773     0.150
    93.833  1463.672     0.150
    93.833  1845.273     0.150
    94.152  1819.312     0.150
    94.572   806.773     0.150
    95.170   807.875     0.150
    95.170   808.477     0.150
    95.441   810.875     0.150
    96.561   811.570     0.150
    96.561  1490.070     0.150
    98.377   819.273     0.150
    98.377   819.273     0.150
    98.398   823.094     0.150
   100.022   830.773     0.150
   100.022  1462.773     0.150
   100.022  1516.172     0.150
   100.022  1933.172     0.150
   101.237   829.773     0.150
   101.237   834.570     0.150
   101.237   836.875     0.150
   101.237  1080.977     0.150
   101.237  1466.977     0.150
   101.237  1523.977     0.150
   101.237  1947.273     0.150
   102.145  1092.461     0.150
   105.568   847.672     0.150
   105.568  1562.273     0.150
   105.568  2006.070     0.150
   107.695   858.773     0.150
   107.695  1105.672     0.150
   107.695  1129.273     0.150
   107.695  2035.773     0.150
   110.839  1112.672     0.150
   110.839  1119.172     0.150
   110.839  1153.477     0.150
   110.839  1606.273     0.150
   110.839  2078.375     0.150
   111.627   875.875     0.150
   111.627  2090.477     0.150
   116.370  1124.820     0.150
   118.311  1134.031     0.150
   118.428  1128.477     0.150
   118.428  1128.477     0.150
   143.337  1175.375     0.150
   145.775  1179.312     0.150
   145.775  1182.273     0.150
   146.020  1182.172     0.150
   146.020  1183.570     0.150
   146.999  1183.523     0.150
   148.202  1190.945     0.150
   148.537  1193.070     0.150
   148.543  1189.773     0.150
   148.889  1189.133     0.150
     0.152     4.047     0.150
     0.272     5.227     0.150
     0.272     9.406     0.150
     0.272     5.547     0.150
     0.276     5.758     0.150
     0.339     6.711     0.150
     0.383     7.641     0.150
     0.394     8.266     0.150
     0.386     8.109     0.150
     0.449     8.711     0.150
     0.449    14.617     0.150
     0.460     9.438     0.150
     0.460    15.984     0.150
     0.507     9.734     0.150
     0.507    16.906     0.150
     0.517     9.898     0.150
     0.563    10.688     0.150
     0.563    18.781     0.150
     0.563    20.055     0.150
     0.593    11.258     0.150
     0.593    19.180     0.150
     0.593    11.070     0.150
     0.669    12.773     0.150
     0.669    21.875     0.150
     0.745    13.820     0.150
     0.745    23.359     0.150
     0.836    15.656     0.150
     0.903    16.508     0.150
     0.903    28.039     0.150
     0.944    16.445     0.150
     0.944    29.250     0.150
     0.944    32.430     0.150
     0.971    17.727     0.150
     0.971    30.133     0.150
     0.987    17.438     0.150
     0.987    30.516     0.150
     0.987    30.047     0.150
     1.095    19.352     0.150
     1.095    34.602     0.150
     1.220    21.234     0.150
     1.220    37.711     0.150
     1.232    22.266     0.150
     1.232    38.695     0.150
     1.232    40.164     0.150
     1.341    25.000     0.150
     1.363    23.086     0.150
     1.363    42.406     0.150
     1.545    27.086     0.150
     1.545    48.070     0.150
     1.585    27.555     0.150
     1.642    27.242     0.150
     1.661    29.078     0.150
     1.661    51.281     0.150
     1.686    31.188     0.150
     1.866    33.102     0.150
     1.866    57.555     0.150
     1.919    58.445     0.150
     1.968    61.422     0.150
     1.998    62.148     0.150
     2.019    35.719     0.150
     2.085    37.250     0.150
     2.085    63.000     0.150
     2.159    35.664     0.150
     2.159    65.414     0.150
     2.237    36.117     0.150
     2.232    68.352     0.150
     2.386    73.836     0.150
     2.692    41.734     0.150
     2.692    74.250     0.150
     2.946    44.672     0.150
     3.228    55.805     0.150
     3.228    92.398     0.150
     3.374    51.969     0.150
     3.374    96.375     0.150
     3.405    52.727     0.150
     3.783    58.477     0.150
     3.783   108.258     0.150
     4.473    66.445     0.150
     4.487    70.047     0.150
     4.643    70.750     0.150
     4.878    74.297     0.150
     5.002    75.750     0.150
     5.545    82.984     0.150
     5.580    83.477     0.150
     5.580    83.477     0.150
     6.018    88.586     0.150
     6.173    92.148     0.150
     7.469   107.875     0.150
     7.592   234.586     0.150
     7.681   241.477     0.150
     7.706   115.289     0.150
     7.818   113.898     0.150
     8.102   116.688     0.150
     8.113   148.234     0.150
     8.113   253.484     0.150
     9.488   135.430     0.150
    10.847   156.945     0.150
    10.847   156.953     0.150
    11.219   161.523     0.150
    16.463   237.461     0.150
     0.122     3.262     0.150
     0.350     7.172     0.150
     0.372     7.676     0.150
     0.372    12.973     0.150
     0.372     7.512     0.150
     0.376     7.414     0.150
     0.376     7.133     0.150
     0.376    12.574     0.150
     0.432     8.844     0.150
     0.448     8.852     0.150
     0.504     9.773     0.150
     0.457     9.004     0.150
     0.487     9.582     0.150
     0.509     9.922     0.150
     0.480     9.719     0.150
     0.480    16.762     0.150
     0.542    10.672     0.150
     0.554    11.051     0.150
     0.578    11.293     0.150
     0.728    13.941     0.150
     0.621    12.051     0.150
     0.730    14.004     0.150
     0.719    13.574     0.150
     0.722    13.992     0.150
     0.735    13.992     0.150
     0.735    23.750     0.150
     0.772    14.812     0.150
     0.890    17.145     0.150
     0.890    29.027     0.150
     0.892    16.121     0.150
     0.844    16.262     0.150
     0.844    16.121     0.150
     1.013    18.633     0.150
     0.928    17.621     0.150
     0.928    30.344     0.150
     1.026    19.391     0.150
     1.026    19.145     0.150
     0.995    19.297     0.150
     0.995    32.965     0.150
     1.093    20.293     0.150
     1.093    35.066     0.150
     1.093    20.113     0.150
     1.051    19.395     0.150
     1.094    20.234     0.150
     1.098    19.824     0.150
     1.070    19.711     0.150
     1.094    20.562     0.150
     1.026    19.211     0.150
     1.037    19.441     0.150
     1.057    21.031     0.150
     1.059    19.801     0.150
     1.172    20.633     0.150
     1.172    21.422     0.150
     1.169    21.281     0.150
     1.095    20.691     0.150
     1.144    20.941     0.150
     1.186    21.922     0.150
     1.250    22.551     0.150
     1.250    37.254     0.150
     1.227    22.262     0.150
     1.227    37.996     0.150
     1.227    22.281     0.150
     1.251    23.062     0.150
     1.318    23.711     0.150
     1.318    40.582     0.150
     1.269    23.422     0.150
     1.364    24.551     0.150
     1.356    23.867     0.150
     1.404    25.492     0.150
     1.344    24.855     0.150
     1.344    43.719     0.150
     1.344    24.754     0.150
     1.407    25.203     0.150
     1.358    24.961     0.150
     1.358    43.504     0.150
     1.392    25.473     0.150
     1.416    25.754     0.150
     1.455    26.441     0.150
     1.455    45.562     0.150
     1.507    26.793     0.150
     1.507    26.992     0.150
     1.575    27.672     0.150
     1.549    27.512     0.150
     1.549    49.703     0.150
     1.617    28.324     0.150
     1.617    27.289     0.150
     1.644    27.754     0.150
     1.644    27.984     0.150
     1.562    27.578     0.150
     1.562    48.395     0.150
     1.562    27.754     0.150
     1.559    27.449     0.150
     1.559    48.996     0.150
     1.559    27.801     0.150
     1.589    28.973     0.150
     1.589    50.805     0.150
     1.589    28.184     0.150
     1.699    28.820     0.150
     1.699    53.918     0.150
     1.659    29.223     0.150
     1.667    29.324     0.150
     1.668    29.281     0.150
     1.672    29.352     0.150
     1.709    29.953     0.150
     1.743    29.859     0.150
     1.740    30.395     0.150
     1.824    31.562     0.150
     1.937    35.066     0.150
     1.937    60.758     0.150
     1.849    31.941     0.150
     1.912    32.633     0.150
     1.912    61.281     0.150
     1.892    32.531     0.150
     1.986    33.867     0.150
     1.986    34.102     0.150
     1.986    61.762     0.150
     2.024    33.832     0.150
     2.054    34.871     0.150
     2.162    36.234     0.150
     2.179    35.984     0.150
     2.192    36.621     0.150
     2.204    36.801     0.150
     2.235    37.211     0.150
     2.235    70.859     0.150
     2.272    37.520     0.150
     2.272    71.168     0.150
     2.272    37.895     0.150
     2.361    38.582     0.150
     2.361    74.316     0.150
     2.361    68.824     0.150
     2.450    40.594     0.150
     2.470    40.484     0.150
     2.497    79.457     0.150
     2.650    42.422     0.150
     2.650    83.098     0.150
     2.723    44.441     0.150
     2.723    50.723     0.150
     2.723    84.203     0.150
     2.788    87.992     0.150
     2.849    45.535     0.150
     2.958    47.855     0.150
     2.958    48.074     0.150
     2.925    46.941     0.150
     3.049    55.652     0.150
     3.049    91.152     0.150
     2.980    47.852     0.150
     3.094    49.805     0.150
     3.211    50.398     0.150
     3.515    54.383     0.150
     3.666    55.914     0.150
     3.666    55.664     0.150
     3.666    67.352     0.150
     4.227    65.074     0.150
     4.349    67.414     0.150
     4.349    83.523     0.150
     4.349   136.133     0.150
     4.445    69.223     0.150
     4.445    82.094     0.150
     4.445   139.273     0.150
     4.407    66.664     0.150
     4.407    81.484     0.150
     4.407   137.781     0.150
     4.455    69.113     0.150
     5.035    94.434     0.150
     5.114    79.562     0.150
     5.148    77.574     0.150
     5.651    85.484     0.150
     5.651   103.523     0.150
     5.651   177.512     0.150
     6.461    96.402     0.150
     6.461   199.852     0.150
     6.698   212.082     0.150
     6.766    99.801     0.150
     6.724    97.684     0.150
     6.812    99.734     0.150
     6.841   213.973     0.150
     6.906   101.031     0.150
     6.988   101.512     0.150
     7.216   105.234     0.150
     7.227   105.473     0.150
     7.227   133.824     0.150
     7.398   107.852     0.150
     7.398   233.461     0.150
     7.418   109.023     0.150
     7.418   237.383     0.150
     7.426   234.812     0.150
     7.515   108.613     0.150
     7.601   109.492     0.150
     7.723   113.191     0.150
     7.861   117.422     0.150
     8.304   120.312     0.150
     8.528   126.711     0.150
    99.496   825.973     0.150
   105.131   847.672     0.150
   110.418   872.973     0.150
     0.105     3.273     0.150
     0.219     4.750     0.150
     0.219     7.516     0.150
     0.234     5.492     0.150
     0.255     5.703     0.150
     0.292     5.906     0.150
     0.314     6.641     0.150
     0.372     7.570     0.150
     0.413     7.914     0.150
     0.412     8.023     0.150
     0.494     9.391     0.150
     0.574    10.727     0.150
     0.583    11.320     0.150
     0.583    19.156     0.150
     0.583    19.344     0.150
     0.614    11.336     0.150
     0.620    11.602     0.150
     0.620    19.750     0.150
     0.620    11.273     0.150
     0.620    12.195     0.150
     0.620    20.328     0.150
     0.659    12.000     0.150
     0.659    20.797     0.150
     0.704    13.133     0.150
     0.704    23.766     0.150
     0.735    14.055     0.150
     0.735    23.875     0.150
     0.940    17.055     0.150
     0.940    30.227     0.150
     0.940    17.180     0.150
     0.940    30.109     0.150
     0.998    17.992     0.150
     0.998    31.430     0.150
     0.998    17.680     0.150
     1.023    18.273     0.150
     1.023    32.188     0.150
     1.114    19.664     0.150
     1.114    33.844     0.150
     1.123    19.477     0.150
     1.123    35.336     0.150
     1.154    19.852     0.150
     1.154    35.344     0.150
     1.176    21.023     0.150
     1.168    20.633     0.150
     1.168    36.695     0.150
     1.198    20.992     0.150
     1.303    22.492     0.150
     1.303    39.547     0.150
     1.474    24.578     0.150
     1.624    28.875     0.150
     1.624    49.945     0.150
     1.625    27.609     0.150
     1.633    28.156     0.150
     1.636    28.133     0.150
     1.731    28.367     0.150
     1.731    53.336     0.150
     1.741    28.648     0.150
     1.895    30.789     0.150
     1.894    30.953     0.150
     1.991    32.523     0.150
     1.992    33.570     0.150
     2.116    34.031     0.150
     2.391    39.562     0.150
     2.407    37.977     0.150
     2.415    37.727     0.150
     2.460    43.102     0.150
     2.506    38.922     0.150
     2.566    38.906     0.150
     2.607    80.180     0.150
     2.728    84.266     0.150
     3.403    51.586     0.150
     3.473    53.703     0.150
     3.554    54.000     0.150
     3.939    59.781     0.150
     4.097    61.016     0.150
     4.260    64.281     0.150
     4.260    64.727     0.150
     5.297    79.375     0.150
     5.820    86.570     0.150
     5.820    97.602     0.150
     5.820   185.836     0.150
     6.094    90.656     0.150
     6.114    91.984     0.150
     6.572    95.383     0.150
     6.572    95.992     0.150
     7.303   105.266     0.150
     7.475   107.547     0.150
     7.495   109.523     0.150
     7.605   110.594     0.150
     7.694   114.359     0.150
     7.694   241.727     0.150
     7.800   115.016     0.150
     7.800   243.703     0.150
     9.001   128.320     0.150
     9.123   133.414     0.150
    10.327   151.055     0.150
    10.360   148.406     0.150
    10.803   156.375     0.150
    10.803   158.180     0.150
    10.803   346.430     0.150
    10.838   155.320     0.150
    10.838   341.672     0.150
    10.949   160.961     0.150
    11.248   161.516     0.150
    11.337   163.094     0.150
    13.012   188.945     0.150
    15.253   219.477     0.150
    37.078   432.023     0.150
     0.319     6.305     0.150
     0.319    11.359     0.150
     0.330     6.156     0.150
     0.330    10.801     0.150
     0.330     6.492     0.150
     0.554    10.402     0.150
     0.554    18.508     0.150
     0.755    13.629     0.150
     0.755    23.801     0.150
     0.850    15.059     0.150
     0.850    26.070     0.150
     0.888    16.305     0.150
     0.888    27.746     0.150
     0.862    15.316     0.150
     0.862    27.012     0.150
     1.038    18.340     0.150
     1.038    31.633     0.150
     1.156    36.367     0.150
     1.154    19.773     0.150
     1.137    20.051     0.150
     1.137    33.672     0.150
     1.219    20.949     0.150
     1.219    38.008     0.150
     1.169    21.391     0.150
     1.169    37.156     0.150
     1.215    21.098     0.150
     1.190    21.117     0.150
     1.190    37.422     0.150
     1.212    21.051     0.150
     1.354    22.703     0.150
     1.354    41.078     0.150
     1.357    23.332     0.150
     1.357    42.480     0.150
     1.448    24.477     0.150
     1.448    44.789     0.150
     1.475    24.352     0.150
     1.475    45.754     0.150
     1.510    26.094     0.150
     1.510    46.891     0.150
     1.607    26.840     0.150
     1.587    26.984     0.150
     1.805    28.656     0.150
     1.806    30.137     0.150
     1.806    30.461     0.150
     1.896    30.312     0.150
     1.878    30.691     0.150
     1.878    58.477     0.150
     1.897    31.445     0.150
     1.897    60.023     0.150
     1.928    30.355     0.150
     2.118    33.395     0.150
     2.118    65.148     0.150
     2.170    35.211     0.150
     2.170    67.016     0.150
     2.231    35.766     0.150
     2.231    69.781     0.150
     2.294    36.129     0.150
     2.315    36.422     0.150
     2.315    71.520     0.150
     2.346    36.660     0.150
     2.369    38.227     0.150
     2.369    37.602     0.150
     2.402    38.672     0.150
     2.402    74.348     0.150
     2.497    39.703     0.150
     2.634    41.660     0.150
     2.739    47.980     0.150
     2.730    43.539     0.150
     2.805    43.562     0.150
     2.907    46.484     0.150
     3.060    48.543     0.150
     3.108    48.531     0.150
     3.197    48.930     0.150
     3.256    50.816     0.150
     3.266    51.035     0.150
     3.306    51.914     0.150
     3.524    55.086     0.150
     3.897    60.211     0.150
     3.897   122.031     0.150
     4.236    64.457     0.150
     4.369    66.160     0.150
     4.411    66.750     0.150
     4.533    67.730     0.150
     4.608    69.711     0.150
     4.830    73.711     0.150
     4.851    73.352     0.150
     4.851   152.172     0.150
     4.856    76.312     0.150
     5.241    79.633     0.150
     5.241   100.270     0.150
     5.241   161.801     0.150
     5.272    76.195     0.150
     5.383   166.320     0.150
     5.770    85.762     0.150
     6.096    88.891     0.150
     7.227   137.109     0.150
     7.844   249.109     0.150
    11.784   168.402     0.150
     0.148     3.648     0.150
     0.148     6.180     0.150
     0.273     5.289     0.150
     0.397     7.922     0.150
     0.437     8.453     0.150
     0.437    14.156     0.150
     0.451    15.008     0.150
     0.488     9.406     0.150
     0.446     8.977     0.150
     0.446    15.023     0.150
     0.550    10.961     0.150
     0.462     9.133     0.150
     0.541    10.508     0.150
     0.613    11.266     0.150
     0.613    19.414     0.150
     0.595    11.453     0.150
     0.676    12.875     0.150
     0.676    22.117     0.150
     0.754    14.438     0.150
     0.754    24.797     0.150
     0.966    17.508     0.150
     0.945    17.688     0.150
     1.024    18.867     0.150
     1.024    32.227     0.150
     1.116    20.617     0.150
     1.250    21.453     0.150
     1.250    36.602     0.150
     1.310    23.742     0.150
     1.349    24.922     0.150
     1.349    42.695     0.150
     1.369    24.602     0.150
     1.505    25.547     0.150
     1.491    26.422     0.150
     1.670    27.656     0.150
     1.662    29.820     0.150
     1.662    51.648     0.150
     1.853    30.836     0.150
     1.853    57.422     0.150
     1.805    30.914     0.150
     1.805    56.305     0.150
     1.869    33.453     0.150
     1.869    57.750     0.150
     1.894    33.922     0.150
     1.894    58.367     0.150
     1.877    55.898     0.150
     1.946    36.031     0.150
     1.945    34.289     0.150
     1.945    58.922     0.150
     2.086    58.203     0.150
     2.087    57.953     0.150
     2.156    34.352     0.150
     2.093    37.555     0.150
     2.093    64.617     0.150
     2.323    38.062     0.150
     2.332    41.820     0.150
     2.332    72.062     0.150
     2.567    43.219     0.150
     2.704    43.562     0.150
     2.900    46.047     0.150
     2.917    45.383     0.150
     2.917    53.297     0.150
     3.194    53.523     0.150
     3.931    62.859     0.150
     3.931   123.062     0.150
     4.297    65.578     0.150
     4.715    70.977     0.150
     4.721    71.867     0.150
     4.754    72.617     0.150
     4.795    72.977     0.150
     4.919    75.062     0.150
     5.361    99.578     0.150
     5.513    82.359     0.150
     5.505    84.359     0.150
     5.505   173.820     0.150
     5.615    86.086     0.150
     5.615   105.430     0.150
     5.646    85.508     0.150
     5.646   105.117     0.150
     5.864    88.047     0.150
     5.864   183.688     0.150
     6.045    93.406     0.150
     6.042    91.789     0.150
     6.042   111.938     0.150
     6.438    99.492     0.150
     7.703   144.883     0.150
     7.979   117.930     0.150
     8.003   118.133     0.150
     8.119   120.719     0.150
     8.220   120.703     0.150
     9.743   143.398     0.150
    10.587   155.180     0.150
    10.572   152.242     0.150
     0.118     3.156     0.150
     0.154     3.977     0.150
     0.173     4.484     0.150
     0.213     5.125     0.150
     0.212     4.742     0.150
     0.212     8.141     0.150
     0.233     5.250     0.150
     0.207     5.133     0.150
     0.364     7.234     0.150
     0.473     9.164     0.150
     0.512     9.742     0.150
     0.551    10.664     0.150
     0.551    17.844     0.150
     0.551    18.039     0.150
     0.556    18.492     0.150
     0.554    10.461     0.150
     0.554    18.930     0.150
     0.603    12.203     0.150
     0.603    11.672     0.150
     0.578    11.594     0.150
     0.617    11.242     0.150
     0.617    19.312     0.150
     0.737    13.680     0.150
     0.737    23.805     0.150
     0.723    13.727     0.150
     0.723    23.602     0.150
     0.776    14.406     0.150
     0.789    14.625     0.150
     0.809    15.203     0.150
     0.980    17.484     0.150
     0.980    30.539     0.150
     0.980    18.570     0.150
     0.980    31.086     0.150
     1.017    17.727     0.150
     1.020    17.625     0.150
     1.020    32.477     0.150
     1.046    18.320     0.150
     1.073    19.602     0.150
     1.073    32.852     0.150
     1.085    19.070     0.150
     1.127    20.164     0.150
     1.127    34.992     0.150
     1.127    20.023     0.150
     1.127    35.586     0.150
     1.128    20.023     0.150
     1.128    34.750     0.150
     1.191    20.516     0.150
     1.190    20.789     0.150
     1.182    22.086     0.150
     1.182    36.852     0.150
     1.266    21.719     0.150
     1.266    38.531     0.150
     1.311    39.258     0.150
     1.517    25.539     0.150
     1.517    46.242     0.150
     1.532    25.430     0.150
     1.801    55.367     0.150
     1.884    30.766     0.150
     1.884    56.930     0.150
     1.885    30.742     0.150
     1.885    57.711     0.150
     1.848    29.703     0.150
     1.848    57.742     0.150
     2.350    42.492     0.150
     2.448    39.344     0.150
     2.450    74.898     0.150
     2.511    38.039     0.150
     2.524    41.906     0.150
     2.563    40.430     0.150
     2.582    42.516     0.150
     3.643    58.305     0.150
     3.730    57.781     0.150
     3.737    58.383     0.150
     4.067    60.242     0.150
     4.067    60.586     0.150
     4.312    66.484     0.150
     4.398    67.633     0.150
     4.432    81.633     0.150
     4.486    68.242     0.150
     4.928    74.586     0.150
     4.941    74.984     0.150
     5.067    77.164     0.150
     5.222    81.094     0.150
     5.263    79.664     0.150
     5.295    79.531     0.150
     5.403    81.594     0.150
     5.755    86.094     0.150
     5.755   185.273     0.150
     5.787    87.516     0.150
     5.924    90.172     0.150
     6.204    94.422     0.150
     6.554    95.023     0.150
     6.945   104.820     0.150
     7.254   107.352     0.150
     7.593   111.680     0.150
     7.617   113.031     0.150
     8.692   124.641     0.150
    10.423   152.086     0.150
    17.681   247.172     0.150
     0.196     3.996     0.150
     0.196     7.031     0.150
     0.297     6.176     0.150
     0.265     5.156     0.150
     0.349     6.637     0.150
     0.350     6.676     0.150
     0.350    11.570     0.150
     0.457     8.965     0.150
     0.359     7.867     0.150
     0.475     9.465     0.150
     0.489     9.496     0.150
     0.517     9.906     0.150
     0.619    12.152     0.150
     0.619    20.484     0.150
     0.564    10.758     0.150
     0.626    11.984     0.150
     0.688    13.957     0.150
     0.720    13.566     0.150
     0.788    15.715     0.150
     0.788    27.598     0.150
     0.739    13.984     0.150
     0.773    14.715     0.150
     0.753    14.230     0.150
     0.753    24.664     0.150
     0.753    15.527     0.150
     0.821    27.207     0.150
     0.893    16.852     0.150
     0.893    28.953     0.150
     0.893    16.984     0.150
     0.893    29.445     0.150
     0.956    17.195     0.150
     0.956    30.152     0.150
     0.956    17.715     0.150
     0.902    16.750     0.150
     0.902    28.512     0.150
     0.957    17.797     0.150
     0.979    17.805     0.150
     0.986    18.531     0.150
     0.986    31.293     0.150
     0.983    18.469     0.150
     0.983    31.684     0.150
     0.983    19.777     0.150
     0.983    33.816     0.150
     1.014    18.793     0.150
     1.014    34.406     0.150
     1.022    19.285     0.150
     1.022    32.477     0.150
     1.077    20.008     0.150
     1.077    34.387     0.150
     1.150    22.625     0.150
     1.203    21.336     0.150
     1.203    36.695     0.150
     1.249    22.418     0.150
     1.249    38.586     0.150
     1.249    39.375     0.150
     1.249    22.602     0.150
     1.249    38.715     0.150
     1.249    22.555     0.150
     1.249    38.938     0.150
     1.232    23.297     0.150
     1.232    38.934     0.150
     1.275    40.066     0.150
     1.371    23.887     0.150
     1.371    42.195     0.150
     1.364    23.727     0.150
     1.364    42.301     0.150
     1.304    24.449     0.150
     1.304    41.156     0.150
     1.324    24.395     0.150
     1.331    26.234     0.150
     1.391    26.387     0.150
     1.391    43.207     0.150
     1.495    27.848     0.150
     1.495    48.195     0.150
     1.565    29.402     0.150
     1.523    27.785     0.150
     1.539    28.840     0.150
     1.539    49.145     0.150
     1.539    27.926     0.150
     1.588    27.957     0.150
     1.588    50.293     0.150
     1.588    29.555     0.150
     1.621    29.105     0.150
     1.621    49.676     0.150
     1.621    50.785     0.150
     1.622    50.816     0.150
     1.731    54.023     0.150
     1.714    30.406     0.150
     1.714    52.375     0.150
     1.785    55.203     0.150
     1.832    31.039     0.150
     1.832    57.109     0.150
     1.850    33.496     0.150
     1.850    57.398     0.150
     1.850    34.418     0.150
     1.850    57.547     0.150
     1.936    59.605     0.150
     1.938    59.484     0.150
     1.935    35.285     0.150
     1.935    60.016     0.150
     2.041    63.805     0.150
     2.181    66.996     0.150
     2.276    35.945     0.150
     2.276    41.918     0.150
     2.249    38.066     0.150
     2.257    41.125     0.150
     2.455    40.086     0.150
     2.623    41.555     0.150
     2.625    42.109     0.150
     2.625    41.957     0.150
     2.688    43.406     0.150
     2.767    44.926     0.150
     3.087    49.719     0.150
     3.392    52.516     0.150
     3.612   111.176     0.150
     3.951    60.805     0.150
     3.946    61.527     0.150
     4.076    63.527     0.150
     4.166    64.828     0.150
     4.275    66.477     0.150
     4.331    67.938     0.150
     4.455    68.375     0.150
     4.479    69.297     0.150
     4.508    68.285     0.150
     4.766    70.996     0.150
     4.884    74.945     0.150
     4.884    76.531     0.150
     4.884   153.480     0.150
     5.344    80.887     0.150
     5.451    82.484     0.150
     5.416    82.125     0.150
     5.612    84.496     0.150
     5.691    84.445     0.150
     5.779    86.516     0.150
     7.141   104.961     0.150
     7.315   107.086     0.150
     7.300   140.297     0.150
     7.411   108.895     0.150
     8.091   252.891     0.150
    11.562   165.297     0.150
    36.140   424.207     0.150
     0.208     4.288     0.150
     0.208     7.321     0.150
     0.292     6.511     0.150
     0.337     6.481     0.150
     0.338     7.027     0.150
     0.338    11.958     0.150
     0.338     6.451     0.150
     0.359     7.811     0.150
     0.456     9.291     0.150
     0.466     9.811     0.150
     0.475     9.721     0.150
     0.478     9.861     0.150
     0.505    10.241     0.150
     0.554    11.081     0.150
     0.611    12.561     0.150
     0.618    12.475     0.150
     0.618    21.038     0.150
     0.619    12.321     0.150
     0.686    13.541     0.150
     0.686    23.051     0.150
     0.714    13.911     0.150
     0.732    14.211     0.150
     0.757    14.427     0.150
     0.757    16.081     0.150
     0.761    15.081     0.150
     0.761    25.531     0.150
     0.777    27.841     0.150
     0.822    16.481     0.150
     0.822    27.541     0.150
     0.895    17.061     0.150
     0.895    28.960     0.150
     0.901    29.358     0.150
     0.901    29.521     0.150
     0.943    18.061     0.150
     0.944    17.547     0.150
     0.944    30.370     0.150
     0.944    17.981     0.150
     0.966    18.301     0.150
     0.973    18.915     0.150
     0.973    31.799     0.150
     0.995    18.705     0.150
     0.995    31.937     0.150
     1.020    19.621     0.150
     1.020    32.741     0.150
     1.023    35.341     0.150
     1.028    19.014     0.150
     1.053    34.161     0.150
     1.065    20.301     0.150
     1.065    34.811     0.150
     1.108    20.891     0.150
     1.108    35.981     0.150
     1.165    36.961     0.150
     1.190    21.615     0.150
     1.190    36.938     0.150
     1.195    39.881     0.150
     1.236    22.811     0.150
     1.236    39.331     0.150
     1.236    39.661     0.150
     1.236    22.952     0.150
     1.236    39.320     0.150
     1.236    22.831     0.150
     1.236    39.401     0.150
     1.241    23.489     0.150
     1.298    24.981     0.150
     1.305    24.437     0.150
     1.305    41.409     0.150
     1.305    41.741     0.150
     1.324    25.011     0.150
     1.335    26.551     0.150
     1.366    24.101     0.150
     1.366    42.379     0.150
     1.366    24.211     0.150
     1.366    44.151     0.150
     1.366    45.911     0.150
     1.367    45.661     0.150
     1.367    23.969     0.150
     1.367    42.721     0.150
     1.390    25.471     0.150
     1.390    43.911     0.150
     1.456    26.971     0.150
     1.456    46.111     0.150
     1.508    27.281     0.150
     1.508    48.871     0.150
     1.508    49.501     0.150
     1.519    27.881     0.150
     1.526    28.121     0.150
     1.550    29.270     0.150
     1.550    48.835     0.150
     1.550    27.551     0.150
     1.550    50.661     0.150
     1.576    29.660     0.150
     1.576    49.723     0.150
     1.602    27.882     0.150
     1.602    30.261     0.150
     1.620    29.871     0.150
     1.620    50.901     0.150
     1.620    51.591     0.150
     1.623    30.261     0.150
     1.623    52.021     0.150
     1.641    52.891     0.150
     1.713    31.311     0.150
     1.713    53.011     0.150
     1.713    53.681     0.150
     1.739    32.447     0.150
     1.739    54.395     0.150
     1.781    55.736     0.150
     1.836    30.956     0.150
     1.836    57.220     0.150
     1.850    34.704     0.150
     1.850    57.657     0.150
     1.850    57.361     0.150
     1.924    59.501     0.150
     1.930    59.761     0.150
     1.931    59.495     0.150
     1.935    35.431     0.150
     1.935    60.911     0.150
     2.173    66.466     0.150
     2.260    37.681     0.150
     2.260    66.391     0.150
     2.258    69.776     0.150
     2.258    37.991     0.150
     2.273    37.421     0.150
     2.273    67.661     0.150
     2.428    74.739     0.150
     2.627    42.781     0.150
     2.627    75.581     0.150
     2.631    43.171     0.150
     2.698    45.031     0.150
     2.781    46.451     0.150
     3.100    50.431     0.150
     3.957    61.461     0.150
     3.959    62.071     0.150
     4.088    64.361     0.150
     4.179    65.701     0.150
     4.345    68.921     0.150
     4.398    68.411     0.150
     4.503    71.151     0.150
     4.769    76.141     0.150
     4.856    76.481     0.150
     4.895    76.781     0.150
     5.143    81.321     0.150
     5.194    79.531     0.150
     5.288    83.511     0.150
     5.428    83.931     0.150
     5.639   148.641     0.150
     5.639   182.151     0.150
     6.814   178.791     0.150
     6.889   103.261     0.150
     6.946   133.021     0.150
     7.142   185.901     0.150
     7.326   140.351     0.150
     7.340   112.221     0.150
     7.340   140.571     0.150
     7.475   143.991     0.150
     7.475   239.821     0.150
     7.496   237.591     0.150
    11.287   165.301     0.150
    11.375   293.111     0.150
    11.550   169.901     0.150
    12.378   315.861     0.150
    14.616   210.861     0.150
     0.293     5.715     0.150
     0.294     5.461     0.150
     0.294     9.770     0.150
     0.294     5.754     0.150
     0.376     8.023     0.150
     0.426     8.379     0.150
     0.440     8.664     0.150
     0.500    10.094     0.150
     0.535    11.191     0.150
     0.543    10.512     0.150
     0.543    18.113     0.150
     0.546    10.574     0.150
     0.570    11.203     0.150
     0.560    10.852     0.150
     0.636    12.223     0.150
     0.636    20.781     0.150
     0.636    12.414     0.150
     0.673    12.773     0.150
     0.673    22.062     0.150
     0.673    12.922     0.150
     0.714    13.477     0.150
     0.714    23.371     0.150
     0.714    13.773     0.150
     0.721    13.551     0.150
     0.721    23.258     0.150
     0.721    13.602     0.150
     0.721    23.164     0.150
     0.721    23.293     0.150
     0.711    13.652     0.150
     0.711    23.324     0.150
     0.732    13.824     0.150
     0.768    14.125     0.150
     0.765    14.645     0.150
     0.763    14.188     0.150
     0.763    24.273     0.150
     0.853    16.613     0.150
     0.870    16.176     0.150
     0.870    27.672     0.150
     0.910    16.723     0.150
     1.025    19.023     0.150
     1.025    32.793     0.150
     1.048    18.633     0.150
     1.031    19.383     0.150
     1.031    33.078     0.150
     1.031    19.672     0.150
     1.046    19.512     0.150
     1.046    33.184     0.150
     1.255    39.824     0.150
     1.296    22.934     0.150
     1.358    22.992     0.150
     1.358    22.832     0.150
     1.348    23.418     0.150
     1.348    42.273     0.150
     1.348    25.691     0.150
     1.348    43.305     0.150
     1.384    24.973     0.150
     1.384    42.922     0.150
     1.384    43.941     0.150
     1.394    25.625     0.150
     1.394    44.062     0.150
     1.508    27.273     0.150
     1.508    28.512     0.150
     1.530    29.312     0.150
     1.594    28.191     0.150
     1.594    49.664     0.150
     1.590    27.203     0.150
     1.590    49.410     0.150
     1.590    29.664     0.150
     1.590    50.383     0.150
     1.619    28.449     0.150
     1.637    27.148     0.150
     1.626    30.199     0.150
     1.626    51.742     0.150
     1.664    29.684     0.150
     1.664    51.625     0.150
     1.640    28.164     0.150
     1.640    29.504     0.150
     1.640    51.672     0.150
     1.646    29.492     0.150
     1.675    28.793     0.150
     1.676    28.664     0.150
     1.680    30.242     0.150
     1.680    52.492     0.150
     1.703    30.043     0.150
     1.703    53.172     0.150
     1.705    30.762     0.150
     1.821    31.172     0.150
     1.851    33.570     0.150
     1.851    58.098     0.150
     1.851    34.254     0.150
     1.879    34.113     0.150
     1.886    34.875     0.150
     1.966    35.434     0.150
     2.004    36.129     0.150
     2.004    33.973     0.150
     2.036    37.203     0.150
     2.036    63.613     0.150
     2.036    63.902     0.150
     2.061    34.492     0.150
     2.061    65.715     0.150
     2.076    38.051     0.150
     2.076    64.637     0.150
     2.173    37.344     0.150
     2.150    39.617     0.150
     2.314    37.914     0.150
     2.606    41.793     0.150
     2.747    44.422     0.150
     2.786    45.492     0.150
     2.911    45.152     0.150
     2.891    48.281     0.150
     2.902    86.895     0.150
     3.107    49.824     0.150
     3.342    53.332     0.150
     3.624    56.715     0.150
     3.977    62.762     0.150
     4.280    65.223     0.150
     4.507    68.902     0.150
     4.594    70.543     0.150
     4.708    71.742     0.150
     4.719    72.102     0.150
     4.822    75.312     0.150
     4.822   151.664     0.150
     5.294    79.234     0.150
     5.325    81.555     0.150
     5.508    82.422     0.150
     5.708   177.734     0.150
     5.835    86.965     0.150
     5.880    87.383     0.150
     6.028   159.504     0.150
    12.142   175.453     0.150
    14.535   213.773     0.150
    14.694   207.754     0.150
    15.024   213.504     0.150
     0.202     4.637     0.150
     0.202     7.457     0.150
     0.202     7.730     0.150
     0.217     5.199     0.150
     0.249     5.508     0.150
     0.249    10.426     0.150
     0.477     9.156     0.150
     0.584    19.109     0.150
     0.584    11.262     0.150
     0.584    19.008     0.150
     0.597    11.637     0.150
     0.634    11.812     0.150
     0.634    20.730     0.150
     0.633    11.527     0.150
     0.633    20.746     0.150
     0.633    19.496     0.150
     0.652    10.559     0.150
     0.652    20.008     0.150
     0.721    13.695     0.150
     0.721    23.582     0.150
     0.938    30.059     0.150
     0.938    16.840     0.150
     0.938    29.535     0.150
     0.975    17.531     0.150
     0.975    31.070     0.150
     0.983    17.648     0.150
     0.983    31.047     0.150
     1.031    18.332     0.150
     1.031    32.426     0.150
     1.097    19.289     0.150
     1.097    33.129     0.150
     1.140    35.906     0.150
     1.140    19.461     0.150
     1.140    35.344     0.150
     1.159    20.719     0.150
     1.159    36.496     0.150
     1.159    20.359     0.150
     1.159    34.996     0.150
     1.183    20.629     0.150
     1.183    36.098     0.150
     1.183    20.555     0.150
     1.183    38.688     0.150
     1.290    22.090     0.150
     1.290    40.301     0.150
     1.468    24.375     0.150
     1.468    43.426     0.150
     1.548    25.156     0.150
     1.748    31.926     0.150
     1.748    53.715     0.150
     1.753    28.504     0.150
     1.903    62.262     0.150
     1.910    30.844     0.150
     1.979    57.348     0.150
     2.186    68.441     0.150
     2.405    37.176     0.150
     2.405    74.324     0.150
     2.418    37.383     0.150
     2.485    46.875     0.150
     2.493    68.656     0.150
     2.499    45.469     0.150
     2.572    38.617     0.150
     2.602    80.785     0.150
     2.728    84.203     0.150
     3.641    56.270     0.150
     3.641    96.207     0.150
     3.717    57.168     0.150
     3.950    75.016     0.150
     3.977    75.922     0.150
     4.107    60.348     0.150
     4.107    60.707     0.150
     4.277    66.066     0.150
     4.277    63.730     0.150
     4.312    81.523     0.150
     4.340    66.996     0.150
     4.863    73.996     0.150
     4.922    74.496     0.150
     5.279    98.758     0.150
     5.827    89.797     0.150
     5.827   109.648     0.150
     5.827   185.496     0.150
     6.584    95.945     0.150
     7.565   113.008     0.150
     8.728   124.242     0.150
    10.819   158.797     0.150
    10.846   154.949     0.150
    15.265   221.371     0.150
     0.213     4.688     0.150
     0.213     4.555     0.150
     0.213     7.586     0.150
     0.242     5.453     0.150
     0.242    10.555     0.150
     0.294     6.562     0.150
     0.301     6.453     0.150
     0.367     7.438     0.150
     0.400     7.734     0.150
     0.406     7.812     0.150
     0.483     9.258     0.150
     0.592    11.305     0.150
     0.592    19.336     0.150
     0.605    11.945     0.150
     0.634    12.258     0.150
     0.634    21.266     0.150
     0.621    11.258     0.150
     0.621    20.102     0.150
     0.646    10.969     0.150
     0.646    20.797     0.150
     0.733    13.648     0.150
     0.733    23.891     0.150
     0.942    17.422     0.150
     0.942    30.883     0.150
     0.946    17.383     0.150
     0.946    30.516     0.150
     0.949    17.367     0.150
     0.949    30.766     0.150
     0.949    16.812     0.150
     0.949    30.383     0.150
     0.986    17.516     0.150
     0.986    31.102     0.150
     0.994    17.805     0.150
     0.994    18.109     0.150
     0.994    31.453     0.150
     1.037    18.102     0.150
     1.037    32.930     0.150
     1.131    36.344     0.150
     1.131    19.398     0.150
     1.131    35.453     0.150
     1.181    20.320     0.150
     1.168    20.734     0.150
     1.168    37.117     0.150
     1.195    20.633     0.150
     1.195    36.242     0.150
     1.302    22.383     0.150
     1.302    40.297     0.150
     1.302    22.477     0.150
     1.302    39.555     0.150
     1.480    24.805     0.150
     1.535    25.359     0.150
     1.535    47.117     0.150
     1.741    53.695     0.150
     1.755    28.508     0.150
     1.909    30.867     0.150
     1.907    30.891     0.150
     2.325    41.789     0.150
     2.325    72.406     0.150
     2.384    74.125     0.150
     2.398    42.586     0.150
     2.421    38.055     0.150
     2.418    74.523     0.150
     2.467    44.336     0.150
     2.492    38.922     0.150
     2.493    41.438     0.150
     2.560    38.875     0.150
     2.560    79.555     0.150
     2.614    80.727     0.150
     2.738    42.273     0.150
     2.738    85.102     0.150
     3.069    56.945     0.150
     3.329    51.789     0.150
     3.415    51.547     0.150
     3.487    54.023     0.150
     3.648    55.430     0.150
     3.706    57.438     0.150
     4.095    60.438     0.150
     4.268    66.648     0.150
     4.334    66.805     0.150
     4.408    67.344     0.150
     4.860    74.195     0.150
     4.988    75.805     0.150
     5.149    78.867     0.150
     5.668    84.609     0.150
     5.833    90.086     0.150
     5.833   110.188     0.150
     6.127    93.156     0.150
     6.356    93.469     0.150
     6.571    95.477     0.150
     6.649    99.156     0.150
     7.258   107.219     0.150
     7.803   245.430     0.150
    10.816   157.484     0.150
    10.834   155.609     0.150
    37.091   432.039     0.150
     0.215     4.734     0.150
     0.215     7.531     0.150
     0.215     8.203     0.150
     0.227     5.336     0.150
     0.247     5.555     0.150
     0.247    10.758     0.150
     0.298     6.625     0.150
     0.305     6.547     0.150
     0.404     7.781     0.150
     0.487     9.328     0.150
     0.595    11.359     0.150
     0.595    19.477     0.150
     0.608    11.820     0.150
     0.608    20.047     0.150
     0.621    11.383     0.150
     0.621    19.828     0.150
     0.629    12.367     0.150
     0.629    20.945     0.150
     0.650    10.875     0.150
     0.650    20.570     0.150
     0.695    12.891     0.150
     0.733    13.953     0.150
     0.733    24.180     0.150
     0.938    17.711     0.150
     0.938    30.656     0.150
     0.943    17.039     0.150
     0.946    16.836     0.150
     0.946    30.945     0.150
     0.946    16.938     0.150
     0.946    30.250     0.150
     0.984    17.531     0.150
     0.984    31.375     0.150
     0.995    17.836     0.150
     0.995    31.125     0.150
     1.032    18.344     0.150
     1.032    32.602     0.150
     1.109    19.500     0.150
     1.109    33.914     0.150
     1.129    19.461     0.150
     1.129    35.094     0.150
     1.171    20.914     0.150
     1.171    36.438     0.150
     1.171    20.141     0.150
     1.171    36.211     0.150
     1.177    20.617     0.150
     1.195    20.828     0.150
     1.302    22.188     0.150
     1.302    40.227     0.150
     1.302    22.250     0.150
     1.478    24.602     0.150
     1.738    28.211     0.150
     1.738    53.734     0.150
     1.751    28.312     0.150
     1.902    30.867     0.150
     1.904    30.594     0.150
     1.981    32.281     0.150
     1.981    55.055     0.150
     2.121    34.719     0.150
     2.382    42.062     0.150
     2.417    42.906     0.150
     2.417    73.992     0.150
     2.417    37.648     0.150
     2.487    38.844     0.150
     2.506    38.844     0.150
     2.563    39.016     0.150
     2.734    42.273     0.150
     2.734    84.523     0.150
     2.921    54.492     0.150
     3.006    56.992     0.150
     3.066    55.328     0.150
     3.066    47.695     0.150
     3.113    47.781     0.150
     3.328    50.594     0.150
     3.411    51.516     0.150
     3.422    64.578     0.150
     3.533    67.031     0.150
     3.561    67.555     0.150
     3.590    68.172     0.150
     3.644    55.297     0.150
     3.731    70.961     0.150
     3.948    74.836     0.150
     3.981    76.000     0.150
     3.987    76.188     0.150
     4.039    77.922     0.150
     4.096    60.734     0.150
     4.096    61.008     0.150
     4.222    80.336     0.150
     4.265    66.102     0.150
     4.265    80.148     0.150
     4.321    65.523     0.150
     4.570    87.578     0.150
     5.267    98.078     0.150
     5.306   100.352     0.150
     5.310   101.320     0.150
     5.828    86.867     0.150
     6.100    91.047     0.150
     6.353    93.008     0.150
     6.572    95.359     0.150
     7.484   110.031     0.150
     7.802   114.875     0.150
     7.802   144.953     0.150
     7.802   244.555     0.150
     8.716   126.266     0.150
     8.716   123.695     0.150
    10.375   327.664     0.150
    10.812   159.703     0.150
    10.836   155.961     0.150
    13.021   187.445     0.150
    14.050   200.391     0.150
    15.262   218.734     0.150
    15.394   218.758     0.150
    15.606   223.078     0.150
    16.060   226.734     0.150
    27.219   346.156     0.150
    36.121   423.680     0.150
    37.086   433.305     0.150
    40.071   457.750     0.150
    94.593   800.508     0.150
    97.386   814.508     0.150
     0.211     4.586     0.150
     0.246     5.547     0.150
     0.223     5.242     0.150
     0.296     6.523     0.150
     0.302     6.406     0.150
     0.411     7.945     0.150
     0.401     7.688     0.150
     0.483     9.172     0.150
     0.624    11.602     0.150
     0.631    12.383     0.150
     0.591    11.406     0.150
     0.591    19.594     0.150
     0.604    11.875     0.150
     0.650    11.227     0.150
     0.729    13.844     0.150
     0.729    24.156     0.150
     0.937    17.969     0.150
     0.937    30.094     0.150
     0.944    16.945     0.150
     0.944    30.430     0.150
     0.981    17.625     0.150
     0.981    31.648     0.150
     0.991    18.016     0.150
     1.032    18.289     0.150
     1.133    19.680     0.150
     1.105    19.422     0.150
     1.105    34.422     0.150
     1.179    20.703     0.150
     1.167    20.992     0.150
     1.167    20.797     0.150
     1.167    36.703     0.150
     1.191    21.000     0.150
     1.298    22.117     0.150
     1.475    24.617     0.150
     1.668    27.422     0.150
     1.742    28.461     0.150
     1.752    28.570     0.150
     1.906    30.891     0.150
     1.905    30.648     0.150
     1.980    32.336     0.150
     1.980    59.055     0.150
     1.981    32.047     0.150
     1.981    58.523     0.150
     2.119    34.000     0.150
     2.127    34.773     0.150
     2.190    34.867     0.150
     2.379    37.117     0.150
     2.418    37.688     0.150
     2.414    75.875     0.150
     2.487    38.953     0.150
     2.502    39.039     0.150
     2.502    78.078     0.150
     2.565    39.047     0.150
     2.609    40.367     0.150
     2.609    81.773     0.150
     2.733    42.703     0.150
     2.733    85.023     0.150
     2.922    45.117     0.150
     3.005    46.641     0.150
     3.064    48.891     0.150
     3.064    47.445     0.150
     3.110    47.258     0.150
     3.325    51.336     0.150
     3.325    50.047     0.150
     3.411    51.383     0.150
     3.420    52.328     0.150
     3.530    53.406     0.150
     3.560    59.406     0.150
     3.560    54.383     0.150
     3.591    55.242     0.150
     3.644    55.312     0.150
     3.729    56.789     0.150
     3.950    62.586     0.150
     3.950    60.102     0.150
     3.981    60.391     0.150
     3.984    60.352     0.150
     4.037    60.820     0.150
     4.099    62.016     0.150
     4.099    61.477     0.150
     4.223    63.555     0.150
     4.269    63.789     0.150
     4.319    66.289     0.150
     4.570    69.320     0.150
     4.858    74.875     0.150
     4.987    77.250     0.150
     5.148    81.172     0.150
     5.271    78.680     0.150
     5.308    80.594     0.150
     5.308    79.133     0.150
     5.310    80.188     0.150
     5.364    82.266     0.150
     5.414    82.625     0.150
     5.580    82.117     0.150
     5.630    83.664     0.150
     5.666    86.211     0.150
     5.829    90.414     0.150
     5.829    87.672     0.150
     6.079    93.641     0.150
     6.348    95.055     0.150
     6.352    95.656     0.150
     6.575    96.445     0.150
     6.976   105.672     0.150
     7.138   108.602     0.150
     7.138   104.617     0.150
     7.157   108.305     0.150
     7.261   106.812     0.150
     7.295   107.984     0.150
     7.314   109.633     0.150
     7.486   110.227     0.150
     7.508   112.383     0.150
     7.510   112.281     0.150
     7.505   112.141     0.150
     7.545   114.094     0.150
     7.545   110.312     0.150
     7.556   114.773     0.150
     7.558   114.586     0.150
     7.560   111.344     0.150
     7.591   115.086     0.150
     7.625   115.312     0.150
     7.644   114.992     0.150
     7.657   116.195     0.150
     7.767   113.344     0.150
     7.804   114.102     0.150
     7.806   113.891     0.150
     7.806   144.164     0.150
     7.806   245.367     0.150
     7.806   116.266     0.150
     7.806   117.297     0.150
     7.806   113.203     0.150
     7.807   114.359     0.150
     7.841   118.812     0.150
     8.006   121.094     0.150
     8.006   226.703     0.150
     8.237   124.641     0.150
     8.247   124.922     0.150
     8.547   127.531     0.150
     8.547   124.086     0.150
     8.630   128.523     0.150
     8.720   126.195     0.150
     8.720   125.969     0.150
     8.730   130.383     0.150
     8.808   128.922     0.150
     9.012   133.625     0.150
     9.135   135.812     0.150
     9.217   135.992     0.150
     9.217   132.781     0.150
     9.192   134.820     0.150
     9.271   137.875     0.150
     9.470   137.500     0.150
     9.470   136.977     0.150
     9.489   139.227     0.150
     9.620   137.992     0.150
     9.696   139.281     0.150
     9.765   140.336     0.150
    10.020   143.430     0.150
    10.023   147.312     0.150
    10.056   146.375     0.150
    10.164   145.500     0.150
    10.191   152.016     0.150
    10.308   148.547     0.150
    10.339   152.492     0.150
    10.371   153.086     0.150
    10.374   154.812     0.150
    10.483   153.844     0.150
    10.555   156.422     0.150
    10.624   157.383     0.150
    10.609   153.273     0.150
    10.728   155.781     0.150
    10.728   152.266     0.150
    10.750   154.188     0.150
    10.815   156.617     0.150
    10.815   158.844     0.150
    10.815   157.891     0.150
    10.815   158.023     0.150
    10.838   155.664     0.150
    10.839   155.422     0.150
    10.839   341.617     0.150
    10.961   161.766     0.150
    11.054   162.000     0.150
    11.080   163.055     0.150
    11.113   160.031     0.150
    11.163   159.555     0.150
    11.198   164.281     0.150
    11.259   165.352     0.150
    11.349   164.133     0.150
    11.415   163.320     0.150
    11.570   166.609     0.150
    11.673   171.211     0.150
    11.682   165.688     0.150
    11.682   168.969     0.150
    11.883   173.844     0.150
    11.965   172.867     0.150
    11.965   173.148     0.150
    11.996   173.133     0.150
    12.006   171.398     0.150
    12.054   173.008     0.150
    12.160   178.586     0.150
    12.153   175.102     0.150
    12.188   179.117     0.150
    12.268   175.836     0.150
    12.300   180.617     0.150
    12.759   179.852     0.150
    12.803   187.734     0.150
    12.806   183.648     0.150
    12.913   187.891     0.150
    12.980   184.430     0.150
    12.999   190.641     0.150
    13.024   188.531     0.150
    13.279   193.438     0.150
    13.387   191.953     0.150
    13.404   192.484     0.150
    13.404   191.102     0.150
    13.542   193.375     0.150
    13.615   193.859     0.150
    13.657   194.227     0.150
    13.657   193.344     0.150
    13.687   197.891     0.150
    13.839   200.742     0.150
    14.054   200.797     0.150
    14.054   198.734     0.150
    14.062   200.195     0.150
    14.233   203.141     0.150
    14.267   201.938     0.150
    14.267   202.742     0.150
    14.532   207.320     0.150
    14.686   207.648     0.150
    14.733   212.320     0.150
    15.157   215.352     0.150
    15.264   219.148     0.150
    15.264   217.781     0.150
    15.264   214.523     0.150
    15.321   214.438     0.150
    15.321   216.508     0.150
    15.397   218.477     0.150
    15.397   216.945     0.150
    15.412   219.711     0.150
    15.440   219.414     0.150
    15.440   216.734     0.150
    15.571   221.297     0.150
    15.609   222.273     0.150
    15.609   220.602     0.150
    15.668   220.477     0.150
    15.993   226.570     0.150
    16.062   229.484     0.150
    16.182   227.594     0.150
    16.474   232.125     0.150
    16.474   230.523     0.150
    16.562   231.867     0.150
    16.565   233.188     0.150
    17.112   238.461     0.150
    17.223   241.992     0.150
    17.636   245.227     0.150
    17.636   246.375     0.150
    17.706   246.312     0.150
    17.706   245.492     0.150
    17.872   248.828     0.150
    17.901   249.445     0.150
    18.051   251.273     0.150
    18.168   252.516     0.150
    18.193   252.984     0.150
    18.172   255.656     0.150
    18.252   253.531     0.150
    18.263   252.938     0.150
    18.263   253.125     0.150
    18.293   253.828     0.150
    18.298   253.688     0.150
    18.340   252.945     0.150
    18.343   255.773     0.150
    18.343   253.258     0.150
    18.415   253.195     0.150
    18.462   254.570     0.150
    18.489   256.695     0.150
    18.519   257.523     0.150
    18.567   255.500     0.150
    18.594   256.906     0.150
    18.599   256.547     0.150
    18.611   256.977     0.150
    18.705   258.086     0.150
    18.717   258.672     0.150
    18.720   260.516     0.150
    18.720   258.898     0.150
    18.753   261.414     0.150
    18.753   258.508     0.150
    18.846   259.797     0.150
    18.915   263.047     0.150
    18.915   260.695     0.150
    18.958   261.453     0.150
    18.965   261.219     0.150
    18.964   263.016     0.150
    18.964   261.875     0.150
    19.029   262.875     0.150
    19.034   262.344     0.150
    19.036   262.156     0.150
    19.054   261.148     0.150
    19.065   261.703     0.150
    19.080   262.523     0.150
    19.094   261.336     0.150
    19.125   261.719     0.150
    19.137   262.820     0.150
    19.173   262.453     0.150
    19.199   263.594     0.150
    19.212   263.609     0.150
    19.222   263.727     0.150
    19.301   265.188     0.150
    19.356   265.461     0.150
    19.426   265.906     0.150
    19.435   267.523     0.150
    19.470   265.805     0.150
    19.487   266.609     0.150
    19.507   266.125     0.150
    19.553   271.633     0.150
    19.553   268.242     0.150
    19.629   271.031     0.150
    19.629   267.836     0.150
    19.648   269.797     0.150
    19.717   269.594     0.150
    19.736   269.812     0.150
    19.762   270.297     0.150
    19.777   270.398     0.150
    19.782   270.430     0.150
    19.791   270.766     0.150
    19.801   270.516     0.150
    19.802   272.500     0.150
    19.819   269.609     0.150
    19.852   271.781     0.150
    19.861   271.906     0.150
    19.864   271.734     0.150
    19.887   272.297     0.150
    19.892   271.727     0.150
    19.951   274.008     0.150
    19.952   272.688     0.150
    19.993   274.156     0.150
    20.013   273.391     0.150
    20.019   275.094     0.150
    20.048   274.438     0.150
    20.061   272.273     0.150
    20.070   273.117     0.150
    20.129   271.914     0.150
    20.267   274.609     0.150
    20.270   274.180     0.150
    20.297   275.242     0.150
    20.317   275.055     0.150
    20.323   275.375     0.150
    20.353   275.391     0.150
    20.353   275.102     0.150
    20.365   275.383     0.150
    20.369   276.250     0.150
    20.398   277.367     0.150
    20.398   275.906     0.150
    20.400   277.367     0.150
    20.412   276.969     0.150
    20.421   278.727     0.150
    20.421   276.828     0.150
    20.459   276.047     0.150
    20.533   277.539     0.150
    20.567   277.367     0.150
    20.568   277.641     0.150
    20.667   280.227     0.150
    20.691   279.727     0.150
    20.717   279.812     0.150
    20.721   279.398     0.150
    20.777   280.680     0.150
    20.789   280.648     0.150
    20.799   280.984     0.150
    20.816   280.984     0.150
    20.856   282.875     0.150
    20.937   282.656     0.150
    20.939   282.398     0.150
    20.980   282.562     0.150
    20.985   282.984     0.150
    20.989   283.305     0.150
    20.994   282.148     0.150
    21.014   281.438     0.150
    21.032   284.922     0.150
    21.039   284.352     0.150
    21.059   289.117     0.150
    21.059   283.172     0.150
    21.067   283.734     0.150
    21.107   283.203     0.150
    21.126   285.078     0.150
    21.158   285.523     0.150
    21.161   285.250     0.150
    21.161   286.195     0.150
    21.174   286.070     0.150
    21.175   284.734     0.150
    21.197   286.531     0.150
    21.196   287.695     0.150
    21.251   285.695     0.150
    21.271   285.469     0.150
    21.318   286.773     0.150
    21.328   286.453     0.150
    21.344   287.422     0.150
    21.371   287.750     0.150
    21.419   286.883     0.150
    21.452   288.898     0.150
    21.465   288.281     0.150
    21.505   288.305     0.150
    21.523   288.680     0.150
    21.543   288.477     0.150
    21.552   289.711     0.150
    21.570   289.211     0.150
    21.629   289.891     0.150
    21.632   289.484     0.150
    21.640   290.461     0.150
    21.645   289.133     0.150
    21.658   290.141     0.150
    21.675   290.555     0.150
    21.711   291.195     0.150
    21.713   290.453     0.150
    21.719   290.688     0.150
    21.771   291.477     0.150
    21.782   292.016     0.150
    21.790   291.875     0.150
    21.796   291.688     0.150
    21.801   291.977     0.150
    21.910   293.578     0.150
    21.930   291.711     0.150
    21.934   292.742     0.150
    21.949   294.039     0.150
    21.954   293.578     0.150
    21.961   294.406     0.150
    22.009   294.383     0.150
    22.062   295.031     0.150
    22.106   295.250     0.150
    22.114   294.828     0.150
    22.117   295.367     0.150
    22.134   294.562     0.150
    22.143   296.023     0.150
    22.171   294.297     0.150
    22.195   295.234     0.150
    22.195   295.914     0.150
    22.224   295.820     0.150
    22.236   295.812     0.150
    22.264   296.469     0.150
    22.283   296.758     0.150
    22.286   296.734     0.150
    22.289   299.344     0.150
    22.289   296.852     0.150
    22.289   296.992     0.150
    22.341   296.484     0.150
    22.347   299.812     0.150
    22.347   296.859     0.150
    22.377   295.797     0.150
    22.437   298.336     0.150
    22.457   298.672     0.150
    22.459   297.984     0.150
    22.462   298.047     0.150
    22.499   299.055     0.150
    22.528   299.922     0.150
    22.597   299.789     0.150
    22.616   300.656     0.150
    22.682   301.359     0.150
    22.724   300.828     0.150
    22.731   301.219     0.150
    22.745   301.203     0.150
    22.782   302.883     0.150
    22.782   301.945     0.150
    22.788   302.227     0.150
    22.789   300.883     0.150
    22.829   302.344     0.150
    22.838   301.891     0.150
    22.864   303.219     0.150
    22.902   303.055     0.150
    22.917   303.211     0.150
    22.937   303.445     0.150
    22.978   301.125     0.150
    23.014   301.531     0.150
    23.056   306.344     0.150
    23.060   301.680     0.150
    23.119   301.836     0.150
    23.148   302.922     0.150
    23.170   307.766     0.150
    23.202   303.586     0.150
    23.233   302.500     0.150
    23.274   305.250     0.150
    23.292   304.719     0.150
    23.343   305.016     0.150
    23.369   306.844     0.150
    23.415   305.805     0.150
    23.420   305.469     0.150
    23.424   306.039     0.150
    23.454   308.164     0.150
    23.486   307.609     0.150
    23.505   307.430     0.150
    23.574   306.891     0.150
    23.607   308.750     0.150
    23.612   307.625     0.150
    23.675   312.211     0.150
    23.680   308.633     0.150
    23.719   312.344     0.150
    23.716   310.945     0.150
    23.731   312.758     0.150
    23.734   309.898     0.150
    23.779   313.359     0.150
    23.808   313.117     0.150
    23.844   311.141     0.150
    23.909   313.062     0.150
    23.927   312.227     0.150
    23.927   312.422     0.150
    23.949   313.305     0.150
    23.950   312.750     0.150
    23.989   312.477     0.150
    24.048   315.828     0.150
    24.058   316.672     0.150
    24.070   315.562     0.150
    24.122   317.289     0.150
    24.153   317.266     0.150
    24.163   316.773     0.150
    24.179   317.258     0.150
    24.249   318.516     0.150
    24.263   317.852     0.150
    24.301   318.383     0.150
    24.313   318.227     0.150
    24.321   317.531     0.150
    24.327   316.766     0.150
    24.328   316.930     0.150
    24.388   317.773     0.150
    24.424   318.516     0.150
    24.461   319.500     0.150
    24.483   320.766     0.150
    24.585   320.117     0.150
    24.587   321.016     0.150
    24.590   320.328     0.150
    24.637   318.828     0.150
    24.643   319.477     0.150
    24.671   319.391     0.150
    24.703   321.680     0.150
    24.789   322.070     0.150
    24.792   322.836     0.150
    24.803   323.711     0.150
    24.822   323.578     0.150
    24.867   324.539     0.150
    24.869   324.305     0.150
    24.882   324.930     0.150
    24.980   326.008     0.150
    25.071   326.422     0.150
    25.075   325.422     0.150
    25.102   325.305     0.150
    25.242   327.086     0.150
    25.247   327.734     0.150
    25.363   327.383     0.150
    25.395   328.836     0.150
    25.394   329.602     0.150
    25.400   328.180     0.150
    25.404   328.930     0.150
    25.422   329.328     0.150
    25.423   330.602     0.150
    25.427   329.367     0.150
    25.444   329.289     0.150
    25.524   328.414     0.150
    25.555   330.016     0.150
    25.587   329.602     0.150
    25.624   330.414     0.150
    25.776   332.281     0.150
    25.781   332.984     0.150
    25.850   332.438     0.150
    25.849   332.414     0.150
    25.879   332.953     0.150
    25.979   333.617     0.150
    25.980   332.602     0.150
    26.050   333.234     0.150
    26.095   335.406     0.150
    26.138   335.359     0.150
    26.146   335.422     0.150
    26.148   334.797     0.150
    26.254   336.086     0.150
    26.312   335.930     0.150
    26.326   337.719     0.150
    26.337   335.508     0.150
    26.411   337.547     0.150
    26.416   337.797     0.150
    26.435   335.711     0.150
    26.460   335.125     0.150
    26.521   336.984     0.150
    26.618   337.578     0.150
    26.651   338.641     0.150
    26.775   340.836     0.150
    26.807   340.812     0.150
    26.825   341.227     0.150
    26.898   342.156     0.150
    26.904   342.695     0.150
    26.942   342.820     0.150
    27.196   344.836     0.150
    27.220   346.172     0.150
    27.257   345.352     0.150
    27.276   346.086     0.150
    27.350   345.836     0.150
    27.389   345.617     0.150
    27.623   349.672     0.150
    27.670   349.352     0.150
    28.949   360.938     0.150
    28.996   362.320     0.150
    29.345   363.359     0.150
    29.388   364.078     0.150
    29.488   366.539     0.150
    29.632   367.016     0.150
    30.390   373.945     0.150
    30.921   376.062     0.150
    32.422   390.500     0.150
    32.536   391.227     0.150
    32.971   401.273     0.150
    33.419   404.047     0.150
    33.633   401.062     0.150
    35.172   418.188     0.150
    35.501   416.008     0.150
    36.123   424.062     0.150
    36.801   429.516     0.150
    36.821   435.375     0.150
    37.087   433.094     0.150
    37.087   433.195     0.150
    37.635   437.945     0.150
    37.996   440.695     0.150
    40.071   457.531     0.150
    40.544   460.734     0.150
    46.580   509.812     0.150
    47.086   515.664     0.150
    47.540   518.719     0.150
    47.772   517.953     0.150
    47.778   937.391     0.150
    53.323   562.969     0.150
    54.990   573.531     0.150
    54.990   573.391     0.150
    62.053   623.969     0.150
    62.053   624.297     0.150
    62.118   623.766     0.150
    62.504   625.820     0.150
    66.767   652.641     0.150
    73.412  1259.195     0.150
    73.412  1551.297     0.150
    73.861   694.516     0.150
    74.799   701.133     0.150
    76.528   712.094     0.150
    76.758   712.672     0.150
    77.970   722.891     0.150
    77.970  1319.094     0.150
    78.620   723.391     0.150
    79.068  1342.195     0.150
    80.402   733.391     0.150
    80.581   734.227     0.150
    80.839   735.016     0.150
    80.938   735.547     0.150
    81.140  1370.594     0.150
    81.591   741.172     0.150
    81.942  1342.594     0.150
    82.380   745.695     0.150
    82.380   742.797     0.150
    83.076   749.195     0.150
    83.904   751.719     0.150
    83.926   753.195     0.150
    84.339   755.367     0.150
    84.441   754.391     0.150
    84.634  1386.094     0.150
    84.634  1439.094     0.150
    84.634  1717.094     0.150
    84.634   758.094     0.150
    84.759   758.992     0.150
    85.207  1395.992     0.150
    85.351   761.523     0.150
    86.236   757.328     0.150
    86.275  1404.594     0.150
    86.433  1405.891     0.150
    86.521  1404.891     0.150
    86.722  1406.594     0.150
    86.760   763.242     0.150
    86.791   766.391     0.150
    86.825   762.445     0.150
    86.983   765.109     0.150
    87.063   767.492     0.150
    87.794   767.938     0.150
    88.799   771.742     0.150
    88.896   778.492     0.150
    89.008   778.094     0.150
    89.008   985.391     0.150
    89.760   784.297     0.150
    90.121   781.594     0.150
    90.756   788.492     0.150
    90.756  1419.797     0.150
    90.756  1510.797     0.150
    91.002   786.797     0.150
    91.022   785.195     0.150
    91.131   789.984     0.150
    91.145   787.656     0.150
    91.599   791.766     0.150
    91.599   788.469     0.150
    91.743   790.891     0.150
    93.214   797.797     0.150
    93.777   799.297     0.150
    94.123   800.695     0.150
    94.150   799.922     0.150
    94.593   798.094     0.150
    94.593  1464.094     0.150
    95.137   807.391     0.150
    95.682   809.094     0.150
    97.384   814.094     0.150
    97.644   815.094     0.150
    98.740   817.992     0.150
    98.740   820.094     0.150
    98.740  1455.492     0.150
   100.626   829.094     0.150
   101.981   836.594     0.150
   101.981   841.094     0.150
   106.333   850.594     0.150
   111.622  1114.094     0.150
   112.462   880.594     0.150
   112.462  1161.094     0.150
   112.462  2100.891     0.150
   117.091  1126.172     0.150
   119.100  1130.195     0.150
   119.118  1130.945     0.150
   145.270  1181.156     0.150
   145.374  1179.508     0.150
   145.374  1179.773     0.150
   145.709  1180.742     0.150
   146.205  1182.094     0.150
     0.209     4.898     0.150
     0.233     5.211     0.150
     0.233     9.992     0.150
     0.202     4.125     0.150
     0.279     6.211     0.150
     0.286     6.383     0.150
     0.356     7.336     0.150
     0.385     7.398     0.150
     0.469     8.781     0.150
     0.579    10.930     0.150
     0.579    18.977     0.150
     0.591    11.352     0.150
     0.591    19.672     0.150
     0.636    12.711     0.150
     0.636    21.602     0.150
     0.628    19.953     0.150
     0.628    11.219     0.150
     0.724    13.867     0.150
     0.724    23.367     0.150
     0.949    17.594     0.150
     0.949    31.055     0.150
     0.952    17.586     0.150
     0.952    31.094     0.150
     0.983    18.336     0.150
     0.983    31.469     0.150
     1.094    19.500     0.150
     1.094    33.281     0.150
     1.145    35.844     0.150
     1.145    36.172     0.150
     1.155    20.711     0.150
     1.155    35.586     0.150
     1.155    21.070     0.150
     1.155    36.086     0.150
     1.185    20.953     0.150
     1.294    22.711     0.150
     1.294    39.891     0.150
     1.294    40.984     0.150
     1.539    28.180     0.150
     1.539    47.102     0.150
     1.755    54.367     0.150
     1.768    55.859     0.150
     2.336    67.531     0.150
     2.508    40.453     0.150
     2.508    72.055     0.150
     3.071    47.523     0.150
     3.324    52.891     0.150
     3.500    55.945     0.150
     4.099    61.172     0.150
     5.003    75.352     0.150
     5.030    96.516     0.150
     5.324    78.266     0.150
     5.365    81.500     0.150
     5.377    79.789     0.150
     5.427    81.250     0.150
     5.578    81.031     0.150
     7.076   106.375     0.150
     7.195   106.445     0.150
     7.267   105.586     0.150
     7.724   114.305     0.150
     8.721   124.453     0.150
    10.572   150.695     0.150
    10.733   153.070     0.150
    10.831   155.203     0.150
     0.165     4.227     0.150
     0.158     3.750     0.150
     0.158     6.508     0.150
     0.231     5.359     0.150
     0.231    10.266     0.150
     0.215     5.320     0.150
     0.215     9.609     0.150
     0.245     5.695     0.150
     0.246     5.469     0.150
     0.246    10.250     0.150
     0.311     6.594     0.150
     0.348     6.836     0.150
     0.434     8.289     0.150
     0.424     8.250     0.150
     0.533    10.273     0.150
     0.533    17.805     0.150
     0.545    10.664     0.150
     0.626    10.594     0.150
     0.626    19.773     0.150
     0.668    11.969     0.150
     0.668    21.180     0.150
     0.678    12.523     0.150
     0.681    12.836     0.150
     0.681    22.516     0.150
     0.683    13.141     0.150
     0.683    22.695     0.150
     0.938    17.148     0.150
     0.941    16.656     0.150
     0.941    30.133     0.150
     0.968    17.281     0.150
     0.968    31.375     0.150
     1.047    18.641     0.150
     1.047    32.391     0.150
     1.060    18.734     0.150
     1.108    19.828     0.150
     1.108    34.523     0.150
     1.142    20.055     0.150
     1.191    20.461     0.150
     1.191    37.500     0.150
     1.233    21.469     0.150
     1.233    38.750     0.150
     1.254    21.742     0.150
     1.254    39.453     0.150
     1.456    24.422     0.150
     1.456    45.672     0.150
     1.585    27.844     0.150
     1.585    48.930     0.150
     1.939    31.578     0.150
     1.961    31.719     0.150
     2.382    42.055     0.150
     2.381    73.711     0.150
     2.586    39.375     0.150
     2.594    81.312     0.150
     2.733    84.234     0.150
     3.018    92.680     0.150
     3.664    57.375     0.150
     3.763    58.320     0.150
     4.133    61.359     0.150
     4.327    66.195     0.150
     4.966    74.758     0.150
     5.326    80.625     0.150
     5.854    88.891     0.150
     5.854   110.641     0.150
     7.857   115.711     0.150
     7.857   146.641     0.150
     7.857   246.641     0.150
    10.865   155.445     0.150
    10.865   339.414     0.150
    10.870   160.469     0.150
    15.304   223.195     0.150
    27.249   348.492     0.150
    37.112   433.070     0.150
    40.094   458.211     0.150
     0.212     4.664     0.150
     0.212     7.969     0.150
     0.212     7.773     0.150
     0.226     5.234     0.150
     0.249     5.484     0.150
     0.305     6.414     0.150
     0.486     9.336     0.150
     0.594    11.578     0.150
     0.594    19.055     0.150
     0.624    11.242     0.150
     0.624    20.398     0.150
     0.607    11.969     0.150
     0.628    12.117     0.150
     0.628    21.414     0.150
     0.653    11.070     0.150
     0.653    20.523     0.150
     0.698    13.000     0.150
     0.698    12.789     0.150
     0.698    21.945     0.150
     0.731    13.836     0.150
     0.731    24.242     0.150
     0.935    18.312     0.150
     0.935    30.609     0.150
     0.942    16.945     0.150
     0.942    30.406     0.150
     0.980    17.727     0.150
     0.992    18.094     0.150
     0.992    31.289     0.150
     1.029    18.586     0.150
     1.029    33.008     0.150
     1.107    19.781     0.150
     1.107    34.023     0.150
     1.130    19.516     0.150
     1.130    35.406     0.150
     1.176    20.680     0.150
     1.169    21.164     0.150
     1.169    36.836     0.150
     1.169    36.055     0.150
     1.193    21.086     0.150
     1.193    36.742     0.150
     1.299    22.359     0.150
     1.299    40.367     0.150
     1.299    38.523     0.150
     1.474    24.836     0.150
     1.617    25.422     0.150
     1.616    27.742     0.150
     1.625    27.812     0.150
     1.625    26.359     0.150
     1.628    28.203     0.150
     1.628    50.039     0.150
     1.666    27.898     0.150
     1.739    28.453     0.150
     1.739    52.758     0.150
     1.749    28.805     0.150
     1.902    31.086     0.150
     1.902    30.836     0.150
     1.983    32.391     0.150
     2.117    34.234     0.150
     2.126    34.695     0.150
     2.187    35.047     0.150
     2.378    37.312     0.150
     2.392    38.125     0.150
     2.415    38.070     0.150
     2.413    37.609     0.150
     2.461    39.203     0.150
     2.461    68.469     0.150
     2.490    39.461     0.150
     2.490    73.852     0.150
     2.484    39.000     0.150
     2.484    73.906     0.150
     2.566    38.789     0.150
     2.608    40.664     0.150
     2.731    42.711     0.150
     2.918    44.992     0.150
     3.003    46.023     0.150
     3.063    47.492     0.150
     3.063    47.297     0.150
     3.110    47.242     0.150
     3.325    50.984     0.150
     3.325    50.398     0.150
     3.408    51.633     0.150
     3.418    52.305     0.150
     3.481    53.695     0.150
     3.533    63.320     0.150
     3.557    54.055     0.150
     3.557    53.844     0.150
     3.641    55.352     0.150
     3.707    56.812     0.150
     3.728    56.430     0.150
     3.946    60.516     0.150
     3.946    60.359     0.150
     3.978    59.859     0.150
     3.983    60.617     0.150
     4.035    61.172     0.150
     4.099    60.281     0.150
     4.220    63.969     0.150
     4.267    64.906     0.150
     4.267    64.555     0.150
     4.331    65.812     0.150
     4.317    64.875     0.150
     4.404    66.844     0.150
     4.567    67.625     0.150
     4.714    71.352     0.150
     4.912    74.180     0.150
     4.984    75.422     0.150
     5.145    78.250     0.150
     5.269    79.734     0.150
     5.269    78.164     0.150
     5.305    79.383     0.150
     5.305    79.164     0.150
     5.307    80.602     0.150
     5.356    81.211     0.150
     5.361    83.086     0.150
     5.580    81.664     0.150
     5.632    81.445     0.150
     5.663    84.820     0.150
     5.708    86.656     0.150
     5.783    86.281     0.150
     5.826    86.180     0.150
     5.826    87.281     0.150
     6.076    91.156     0.150
     6.123    91.953     0.150
     6.299    97.336     0.150
     6.345    94.344     0.150
     6.349    93.891     0.150
     6.575    96.109     0.150
     6.642   102.172     0.150
     6.867   104.992     0.150
     7.060   136.305     0.150
     7.136   107.031     0.150
     7.136   106.219     0.150
     7.156   106.945     0.150
     7.176   108.211     0.150
     7.260   105.969     0.150
     7.289   110.359     0.150
     7.311   108.805     0.150
     7.458   112.641     0.150
     7.483   113.422     0.150
     7.483   111.055     0.150
     7.505   111.922     0.150
     7.507   111.695     0.150
     7.512   112.125     0.150
     7.512   112.289     0.150
     7.512   144.062     0.150
     7.512   242.539     0.150
     7.502   110.930     0.150
     7.517   112.320     0.150
     7.524   111.445     0.150
     7.531   112.266     0.150
     7.544   109.633     0.150
     7.542   112.031     0.150
     7.552   112.586     0.150
     7.553   112.242     0.150
     7.559   111.961     0.150
     7.556   112.180     0.150
     7.569   112.891     0.150
     7.588   113.234     0.150
     7.592   113.219     0.150
     7.622   113.383     0.150
     7.642   113.430     0.150
     7.654   115.461     0.150
     7.688   114.070     0.150
     7.767   113.164     0.150
     7.777   115.195     0.150
     7.803   113.680     0.150
     7.805   112.430     0.150
     7.805   145.305     0.150
     7.805   244.336     0.150
     7.805   114.969     0.150
     7.805   114.398     0.150
     7.805   114.453     0.150
     7.858   117.070     0.150
     8.135   121.211     0.150
     8.217   121.539     0.150
     8.234   123.109     0.150
     8.244   123.570     0.150
     8.545   125.836     0.150
     8.545   124.641     0.150
     8.627   128.180     0.150
     8.720   125.352     0.150
     8.726   130.219     0.150
     8.806   128.414     0.150
     8.806   127.977     0.150
     9.009   131.750     0.150
     9.132   135.125     0.150
     9.189   133.859     0.150
     9.214   135.109     0.150
     9.214   134.281     0.150
     9.268   136.344     0.150
     9.468   137.750     0.150
     9.468   136.867     0.150
     9.489   138.094     0.150
     9.762   142.102     0.150
    10.018   144.211     0.150
    10.026   146.781     0.150
    10.053   144.250     0.150
    10.162   145.891     0.150
    10.335   152.211     0.150
    10.368   153.172     0.150
    10.372   153.734     0.150
    10.481   154.062     0.150
    10.516   154.805     0.150
    10.627   155.086     0.150
    10.552   155.852     0.150
    10.552   151.648     0.150
    10.606   154.297     0.150
    10.727   157.930     0.150
    10.727   155.828     0.150
    10.747   156.391     0.150
    10.811   157.852     0.150
    10.811   156.719     0.150
    10.811   157.812     0.150
    10.811   156.609     0.150
    10.811   157.250     0.150
    10.838   154.961     0.150
    10.839   155.164     0.150
    10.839   340.812     0.150
    10.898   159.086     0.150
    10.957   160.609     0.150
    10.987   156.805     0.150
    11.051   161.156     0.150
    11.076   163.000     0.150
    11.160   160.555     0.150
    11.170   163.836     0.150
    11.196   165.781     0.150
    11.256   164.602     0.150
    11.345   166.570     0.150
    11.412   164.742     0.150
    11.435   167.766     0.150
    11.568   166.258     0.150
    11.669   171.469     0.150
    11.681   167.000     0.150
    11.962   173.930     0.150
    11.962   171.562     0.150
    11.966   176.719     0.150
    11.993   177.062     0.150
    11.993   172.195     0.150
    12.003   174.133     0.150
    12.052   173.391     0.150
    12.157   178.836     0.150
    12.150   173.914     0.150
    12.184   178.992     0.150
    12.211   179.289     0.150
    12.265   176.383     0.150
    12.297   179.820     0.150
    12.518   183.914     0.150
    12.718   186.812     0.150
    12.756   181.789     0.150
    12.800   187.930     0.150
    12.804   183.922     0.150
    12.910   188.500     0.150
    12.910   188.359     0.150
    12.977   188.102     0.150
    12.996   189.969     0.150
    13.020   188.609     0.150
    13.020   188.086     0.150
    13.385   191.281     0.150
    13.403   190.086     0.150
    13.527   196.633     0.150
    13.539   194.359     0.150
    13.608   198.414     0.150
    13.612   196.500     0.150
    13.657   196.414     0.150
    13.657   194.148     0.150
    13.684   199.172     0.150
    13.704   199.133     0.150
    13.836   200.664     0.150
    13.836   198.414     0.150
    13.957   202.695     0.150
    14.053   200.773     0.150
    14.053   199.883     0.150
    14.061   199.016     0.150
    14.230   203.234     0.150
    14.239   205.484     0.150
    14.264   202.664     0.150
    14.264   203.117     0.150
    14.505   210.125     0.150
    14.529   205.242     0.150
    14.686   210.359     0.150
    14.686   207.305     0.150
    14.730   214.484     0.150
    14.728   213.062     0.150
    14.816   217.859     0.150
    14.893   214.930     0.150
    14.958   216.812     0.150
    15.154   215.039     0.150
    15.261   217.953     0.150
    15.321   216.859     0.150
    15.321   215.805     0.150
    15.369   219.789     0.150
    15.394   217.906     0.150
    15.394   217.500     0.150
    15.409   219.148     0.150
    15.440   218.664     0.150
    15.440   217.023     0.150
    15.568   218.945     0.150
    15.606   219.852     0.150
    15.606   221.594     0.150
    15.666   219.461     0.150
    15.990   225.742     0.150
    16.059   228.953     0.150
    16.179   233.461     0.150
    16.179   227.297     0.150
    16.245   233.156     0.150
    16.472   232.672     0.150
    16.472   231.664     0.150
    16.561   235.883     0.150
    16.561   233.055     0.150
    16.562   231.914     0.150
    16.686   239.672     0.150
    17.112   242.703     0.150
    17.220   240.602     0.150
    17.633   247.562     0.150
    17.633   246.023     0.150
    17.705   251.906     0.150
    17.705   246.070     0.150
    17.870   248.695     0.150
    17.900   248.656     0.150
    18.049   249.633     0.150
    18.167   256.914     0.150
    18.167   250.828     0.150
    18.169   255.711     0.150
    18.191   251.820     0.150
    18.250   252.062     0.150
    18.260   254.500     0.150
    18.260   251.789     0.150
    18.291   253.367     0.150
    18.297   253.422     0.150
    18.338   254.594     0.150
    18.342   255.906     0.150
    18.342   253.227     0.150
    18.414   254.961     0.150
    18.460   256.039     0.150
    18.488   254.500     0.150
    18.517   254.977     0.150
    18.567   255.547     0.150
    18.592   257.953     0.150
    18.597   257.188     0.150
    18.610   255.461     0.150
    18.703   258.055     0.150
    18.715   257.875     0.150
    18.719   260.914     0.150
    18.719   259.516     0.150
    18.752   261.234     0.150
    18.752   260.094     0.150
    18.843   258.766     0.150
    18.913   262.812     0.150
    18.913   262.430     0.150
    18.957   262.859     0.150
    18.957   262.086     0.150
    18.963   262.984     0.150
    18.963   262.164     0.150
    18.964   263.289     0.150
    19.027   262.242     0.150
    19.032   263.211     0.150
    19.035   263.148     0.150
    19.053   260.883     0.150
    19.064   265.164     0.150
    19.064   261.570     0.150
    19.078   263.891     0.150
    19.091   266.383     0.150
    19.091   262.148     0.150
    19.125   263.938     0.150
    19.137   263.891     0.150
    19.172   262.844     0.150
    19.197   264.148     0.150
    19.210   263.797     0.150
    19.221   264.594     0.150
    19.301   265.508     0.150
    19.354   267.086     0.150
    19.425   266.219     0.150
    19.433   267.594     0.150
    19.469   267.891     0.150
    19.485   268.211     0.150
    19.505   268.586     0.150
    19.551   267.852     0.150
    19.628   270.562     0.150
    19.628   270.086     0.150
    19.645   269.508     0.150
    19.715   271.133     0.150
    19.736   270.797     0.150
    19.761   270.133     0.150
    19.776   270.469     0.150
    19.782   270.750     0.150
    19.788   270.242     0.150
    19.788   270.570     0.150
    19.799   270.719     0.150
    19.800   270.828     0.150
    19.818   272.469     0.150
    19.850   271.133     0.150
    19.860   270.820     0.150
    19.863   271.797     0.150
    19.885   272.500     0.150
    19.891   272.102     0.150
    19.949   272.711     0.150
    19.951   272.750     0.150
    19.991   276.234     0.150
    19.991   273.867     0.150
    20.012   276.562     0.150
    20.012   273.680     0.150
    20.018   273.297     0.150
    20.046   273.938     0.150
    20.058   273.586     0.150
    20.067   272.906     0.150
    20.128   274.750     0.150
    20.266   276.008     0.150
    20.268   276.977     0.150
    20.296   275.562     0.150
    20.317   277.133     0.150
    20.321   277.750     0.150
    20.352   276.180     0.150
    20.351   279.430     0.150
    20.351   277.641     0.150
    20.363   276.930     0.150
    20.369   277.852     0.150
    20.396   278.992     0.150
    20.396   276.867     0.150
    20.398   277.547     0.150
    20.412   277.422     0.150
    20.420   279.383     0.150
    20.420   278.547     0.150
    20.457   280.133     0.150
    20.457   277.898     0.150
    20.532   280.039     0.150
    20.566   278.117     0.150
    20.567   279.625     0.150
    20.665   280.602     0.150
    20.690   281.516     0.150
    20.715   281.180     0.150
    20.719   281.922     0.150
    20.776   282.664     0.150
    20.787   282.453     0.150
    20.797   282.555     0.150
    20.815   281.375     0.150
    20.854   281.156     0.150
    20.935   285.000     0.150
    20.938   281.578     0.150
    20.977   282.562     0.150
    20.983   283.914     0.150
    20.989   283.477     0.150
    20.994   284.133     0.150
    21.010   284.125     0.150
    21.011   283.344     0.150
    21.031   287.086     0.150
    21.038   283.398     0.150
    21.064   284.922     0.150
    21.066   284.664     0.150
    21.106   282.836     0.150
    21.126   283.039     0.150
    21.157   283.180     0.150
    21.159   285.547     0.150
    21.171   285.227     0.150
    21.174   284.117     0.150
    21.197   284.578     0.150
    21.193   287.688     0.150
    21.193   287.086     0.150
    21.249   285.648     0.150
    21.255   288.461     0.150
    21.269   285.508     0.150
    21.316   288.766     0.150
    21.316   285.680     0.150
    21.325   285.164     0.150
    21.343   285.930     0.150
    21.368   289.266     0.150
    21.368   286.453     0.150
    21.418   286.359     0.150
    21.450   289.180     0.150
    21.462   288.750     0.150
    21.503   288.547     0.150
    21.522   289.172     0.150
    21.536   288.414     0.150
    21.542   288.078     0.150
    21.550   289.469     0.150
    21.623   290.641     0.150
    21.627   290.555     0.150
    21.632   290.969     0.150
    21.638   289.852     0.150
    21.644   289.727     0.150
    21.657   290.812     0.150
    21.674   290.828     0.150
    21.708   291.797     0.150
    21.712   290.766     0.150
    21.719   291.836     0.150
    21.769   292.125     0.150
    21.781   292.992     0.150
    21.781   292.312     0.150
    21.789   291.094     0.150
    21.794   292.805     0.150
    21.800   291.203     0.150
    21.907   291.820     0.150
    21.928   292.789     0.150
    21.933   292.070     0.150
    21.946   294.219     0.150
    21.952   292.703     0.150
    21.959   296.281     0.150
    22.007   294.148     0.150
    22.060   295.055     0.150
    22.105   295.023     0.150
    22.113   295.141     0.150
    22.114   296.086     0.150
    22.134   295.734     0.150
    22.141   295.141     0.150
    22.192   296.773     0.150
    22.222   295.773     0.150
    22.234   296.258     0.150
    22.263   297.469     0.150
    22.262   297.625     0.150
    22.265   297.117     0.150
    22.281   297.562     0.150
    22.285   297.219     0.150
    22.288   298.203     0.150
    22.288   297.422     0.150
    22.289   297.547     0.150
    22.302   297.523     0.150
    22.341   297.195     0.150
    22.345   299.234     0.150
    22.345   298.586     0.150
    22.375   297.914     0.150
    22.435   299.414     0.150
    22.455   299.477     0.150
    22.458   298.969     0.150
    22.461   299.227     0.150
    22.497   299.727     0.150
    22.525   300.391     0.150
    22.525   300.781     0.150
    22.596   299.680     0.150
    22.614   300.484     0.150
    22.680   299.641     0.150
    22.722   302.234     0.150
    22.730   302.203     0.150
    22.736   302.297     0.150
    22.744   302.773     0.150
    22.779   303.883     0.150
    22.779   303.352     0.150
    22.786   302.539     0.150
    22.788   303.219     0.150
    22.826   304.086     0.150
    22.826   301.914     0.150
    22.836   303.602     0.150
    22.851   304.984     0.150
    22.861   303.820     0.150
    22.900   304.438     0.150
    22.906   303.742     0.150
    22.916   304.398     0.150
    22.928   305.781     0.150
    22.936   304.070     0.150
    22.976   303.906     0.150
    23.013   305.039     0.150
    23.017   309.234     0.150
    23.017   305.078     0.150
    23.053   306.516     0.150
    23.053   304.828     0.150
    23.056   305.031     0.150
    23.059   305.336     0.150
    23.100   305.711     0.150
    23.118   305.391     0.150
    23.146   305.703     0.150
    23.168   307.516     0.150
    23.168   306.094     0.150
    23.200   306.320     0.150
    23.232   305.648     0.150
    23.273   305.703     0.150
    23.290   307.852     0.150
    23.294   307.664     0.150
    23.341   306.445     0.150
    23.367   306.359     0.150
    23.383   310.062     0.150
    23.383   307.508     0.150
    23.413   308.922     0.150
    23.419   308.180     0.150
    23.422   310.234     0.150
    23.422   307.617     0.150
    23.439   315.336     0.150
    23.439   310.297     0.150
    23.452   309.477     0.150
    23.453   310.414     0.150
    23.471   308.648     0.150
    23.484   311.664     0.150
    23.484   309.344     0.150
    23.504   310.398     0.150
    23.533   310.352     0.150
    23.573   310.391     0.150
    23.606   311.836     0.150
    23.610   310.852     0.150
    23.654   310.664     0.150
    23.673   310.438     0.150
    23.679   310.438     0.150
    23.697   312.078     0.150
    23.718   311.758     0.150
    23.712   312.016     0.150
    23.728   312.258     0.150
    23.733   311.305     0.150
    23.778   312.086     0.150
    23.806   311.414     0.150
    23.843   312.680     0.150
    23.883   316.383     0.150
    23.883   313.375     0.150
    23.907   316.336     0.150
    23.907   314.062     0.150
    23.926   314.953     0.150
    23.946   315.531     0.150
    23.946   314.555     0.150
    23.948   314.508     0.150
    23.968   314.445     0.150
    23.988   314.773     0.150
    24.047   316.258     0.150
    24.056   314.820     0.150
    24.068   315.094     0.150
    24.120   314.477     0.150
    24.152   315.719     0.150
    24.162   316.914     0.150
    24.177   315.547     0.150
    24.195   319.883     0.150
    24.203   316.367     0.150
    24.204   317.711     0.150
    24.204   315.383     0.150
    24.248   318.453     0.150
    24.261   315.977     0.150
    24.293   316.977     0.150
    24.299   318.031     0.150
    24.299   317.602     0.150
    24.312   318.086     0.150
    24.320   317.969     0.150
    24.327   317.836     0.150
    24.324   317.453     0.150
    24.386   316.633     0.150
    24.423   319.305     0.150
    24.460   318.969     0.150
    24.484   320.734     0.150
    24.585   321.172     0.150
    24.589   320.977     0.150
    24.635   323.516     0.150
    24.635   320.516     0.150
    24.641   320.531     0.150
    24.669   318.711     0.150
    24.670   319.688     0.150
    24.703   318.844     0.150
    24.701   319.891     0.150
    24.751   321.727     0.150
    24.787   321.117     0.150
    24.791   320.758     0.150
    24.802   320.492     0.150
    24.820   320.086     0.150
    24.836   322.328     0.150
    24.865   325.734     0.150
    24.865   322.930     0.150
    24.868   322.023     0.150
    24.881   321.758     0.150
    24.977   323.375     0.150
    25.069   323.492     0.150
    25.074   323.516     0.150
    25.100   322.438     0.150
    25.185   325.656     0.150
    25.240   324.609     0.150
    25.246   325.445     0.150
    25.361   327.273     0.150
    25.394   328.125     0.150
    25.394   327.555     0.150
    25.400   328.133     0.150
    25.403   325.562     0.150
    25.421   329.102     0.150
    25.422   329.797     0.150
    25.426   328.953     0.150
    25.442   327.055     0.150
    25.547   328.148     0.150
    25.554   329.547     0.150
    25.585   328.766     0.150
    25.623   330.008     0.150
    25.774   332.492     0.150
    25.778   331.352     0.150
    25.848   331.656     0.150
    25.848   333.141     0.150
    25.860   332.555     0.150
    25.878   332.305     0.150
    25.918   331.938     0.150
    25.977   333.219     0.150
    26.049   332.914     0.150
    26.136   333.508     0.150
    26.144   335.320     0.150
    26.146   333.797     0.150
    26.253   335.875     0.150
    26.325   336.031     0.150
    26.336   337.219     0.150
    26.434   337.508     0.150
    26.458   335.844     0.150
    26.474   337.133     0.150
    26.519   338.289     0.150
    26.622   338.117     0.150
    26.642   339.102     0.150
    26.649   339.078     0.150
    26.661   340.344     0.150
    26.722   339.109     0.150
    26.773   339.867     0.150
    26.823   339.133     0.150
    26.858   341.695     0.150
    26.896   342.430     0.150
    26.902   341.719     0.150
    26.940   342.273     0.150
    27.013   343.156     0.150
    27.105   344.852     0.150
    27.217   346.766     0.150
    27.217   346.875     0.150
    27.255   343.203     0.150
    27.388   345.891     0.150
    27.621   347.992     0.150
    28.657   360.836     0.150
    28.947   358.086     0.150
    28.997   361.562     0.150
    29.284   368.875     0.150
    29.343   363.117     0.150
    29.485   365.211     0.150
    29.520   367.492     0.150
    29.630   370.484     0.150
    30.389   376.930     0.150
    30.389   371.211     0.150
    30.388   375.086     0.150
    30.919   377.008     0.150
    30.934   377.500     0.150
    32.420   391.383     0.150
    32.420   390.914     0.150
    32.534   394.211     0.150
    32.534   392.273     0.150
    32.968   398.391     0.150
    33.417   405.344     0.150
    33.631   402.219     0.150
    34.191   410.172     0.150
    34.392   410.102     0.150
    35.382   421.234     0.150
    35.427   418.734     0.150
    35.499   416.617     0.150
    35.629   421.156     0.150
    35.710   417.281     0.150
    35.722   421.609     0.150
    35.784   422.156     0.150
    36.094   424.992     0.150
    36.595   431.812     0.150
    36.797   429.914     0.150
    36.797   429.164     0.150
    36.934   431.852     0.150
    37.056   433.031     0.150
    37.084   431.805     0.150
    37.084   432.609     0.150
    37.084   433.016     0.150
    37.261   434.930     0.150
    37.287   434.273     0.150
    37.349   434.719     0.150
    37.426   431.320     0.150
    37.632   438.555     0.150
    37.637   437.430     0.150
    37.993   440.234     0.150
    38.114   440.852     0.150
    38.490   445.055     0.150
    39.752   456.055     0.150
    40.068   456.555     0.150
    40.541   462.914     0.150
    40.541   458.820     0.150
    42.954   480.547     0.150
    44.761   495.289     0.150
    47.291   518.555     0.150
    47.774   519.641     0.150
    47.812   522.711     0.150
    54.987   573.055     0.150
    58.827  1091.211     0.150
    59.917  1108.516     0.150
    62.050   622.516     0.150
    62.050   622.914     0.150
    62.119   623.172     0.150
    62.502   625.211     0.150
    64.995   640.461     0.150
    66.436   651.211     0.150
    66.769   653.859     0.150
    67.962   664.352     0.150
    69.475   668.320     0.150
    73.812   696.312     0.150
    73.812  1269.609     0.150
    73.812  1551.211     0.150
    73.858   695.312     0.150
    77.968   719.812     0.150
    77.968  1315.812     0.150
    78.253   721.125     0.150
    78.617   723.812     0.150
    80.400   731.812     0.150
    80.583   733.805     0.150
    80.836   734.109     0.150
    80.940   735.562     0.150
    80.940   736.531     0.150
    81.589   740.711     0.150
    81.589   739.414     0.150
    82.378   744.023     0.150
    82.379   743.914     0.150
    83.074   747.414     0.150
    83.901   750.945     0.150
    83.923   751.414     0.150
    84.342   754.766     0.150
    84.342   756.016     0.150
    84.438   753.914     0.150
    84.631   754.812     0.150
    84.631  1380.812     0.150
    85.204  1391.914     0.150
    86.271  1400.914     0.150
    86.495   762.172     0.150
    86.518  1376.711     0.150
    86.719  1401.016     0.150
    86.757   762.547     0.150
    86.788   765.914     0.150
    86.822   766.945     0.150
    86.980   764.836     0.150
    87.060   764.406     0.150
    87.791   768.883     0.150
    88.303   773.812     0.150
    88.303   773.812     0.150
    88.415   770.273     0.150
    88.893   777.414     0.150
    89.005  1405.711     0.150
    89.025   776.289     0.150
    89.757   781.516     0.150
    90.752   784.172     0.150
    90.752   784.414     0.150
    90.752   999.914     0.150
    90.752  1415.711     0.150
    90.752  1503.812     0.150
    90.752  1512.109     0.150
    90.999   784.609     0.150
    91.019   784.539     0.150
    91.019   786.211     0.150
    91.129   788.766     0.150
    91.142   786.516     0.150
    91.595   788.664     0.150
    91.595   787.789     0.150
    91.595   788.062     0.150
    91.740   789.016     0.150
    92.337   792.531     0.150
    92.321  1459.016     0.150
    94.119   800.875     0.150
    94.119   800.414     0.150
    94.147   800.352     0.150
    94.590   800.312     0.150
    94.590  1468.812     0.150
    95.133   805.914     0.150
    95.679   808.406     0.150
    95.679   806.914     0.150
    95.781   808.398     0.150
    97.382   814.812     0.150
    98.737   817.812     0.150
    98.737     3.398     0.150
    98.737  1058.609     0.150
    98.737  1455.414     0.150
    98.737  1915.211     0.150
   100.623   829.609     0.150
   100.851   831.016     0.150
   101.978   835.812     0.150
   101.978   839.812     0.150
   106.331   852.312     0.150
   106.331  1570.312     0.150
   106.331  2018.109     0.150
   111.620  1114.312     0.150
   112.460   881.812     0.150
   112.460  1162.312     0.150
   112.460  2104.109     0.150
   117.082  1129.680     0.150
   117.092  1126.805     0.150
   119.097  1131.516     0.150
   119.119  1129.609     0.150
   145.377  1178.352     0.150
   145.707  1180.438     0.150
   146.205  1183.234     0.150
     0.233     5.055     0.150
     0.233     7.477     0.150
     0.249     5.719     0.150
     0.261     5.719     0.150
     0.321     7.039     0.150
     0.386     7.734     0.150
     0.408     7.883     0.150
     0.426     8.195     0.150
     0.509     9.695     0.150
     0.610    11.266     0.150
     0.610    18.805     0.150
     0.608    12.008     0.150
     0.608    20.297     0.150
     0.616    11.758     0.150
     0.616    20.328     0.150
     0.616    19.883     0.150
     0.629    12.148     0.150
     0.629    21.133     0.150
     0.666    11.477     0.150
     0.666    21.258     0.150
     0.709    13.016     0.150
     0.709    12.445     0.150
     0.709    22.797     0.150
     0.748    14.188     0.150
     0.748    24.711     0.150
     0.934    17.266     0.150
     0.934    29.516     0.150
     0.942    17.008     0.150
     0.942    30.180     0.150
     0.984    17.719     0.150
     0.984    31.625     0.150
     1.012    18.234     0.150
     1.017    18.125     0.150
     1.017    32.555     0.150
     1.108    19.172     0.150
     1.108    35.664     0.150
     1.108    35.055     0.150
     1.128    19.914     0.150
     1.154    20.320     0.150
     1.191    21.172     0.150
     1.191    37.984     0.150
     1.191    20.883     0.150
     1.191    37.109     0.150
     1.210    21.414     0.150
     1.314    22.555     0.150
     1.314    39.898     0.150
     1.480    24.961     0.150
     1.480    46.289     0.150
     1.731    28.367     0.150
     1.889    30.375     0.150
     2.118    66.109     0.150
     2.179    67.375     0.150
     2.306    41.664     0.150
     2.306    67.148     0.150
     2.386    73.555     0.150
     2.398    37.672     0.150
     2.394    74.914     0.150
     2.424    37.922     0.150
     2.467    39.984     0.150
     2.467    70.969     0.150
     2.464    42.914     0.150
     2.464    76.133     0.150
     2.473    38.656     0.150
     2.611    81.211     0.150
     2.728    42.266     0.150
     2.728    84.320     0.150
     3.337    60.438     0.150
     3.337   101.336     0.150
     3.398    51.547     0.150
     3.461    53.562     0.150
     3.930    60.383     0.150
     4.714    77.938     0.150
     5.249    79.727     0.150
     5.402    88.867     0.150
     5.642    84.766     0.150
     5.813    86.234     0.150
     5.813   109.438     0.150
     5.813    86.242     0.150
     5.813   109.438     0.150
     6.100    91.508     0.150
     6.332    95.203     0.150
     6.631   106.734     0.150
     7.153   105.695     0.150
     7.266   109.148     0.150
     7.340   135.789     0.150
     7.482   109.609     0.150
     7.494   113.086     0.150
     7.502   107.297     0.150
     7.509   112.453     0.150
     7.531   113.312     0.150
     7.533   112.617     0.150
     7.546   112.539     0.150
     7.599   113.836     0.150
     7.619   113.547     0.150
     7.665   111.648     0.150
     7.754   116.375     0.150
     7.787   113.164     0.150
     7.787   144.938     0.150
     7.787   245.586     0.150
     7.787   112.234     0.150
     7.787   144.117     0.150
     8.070   257.656     0.150
     8.605   127.172     0.150
     8.704   130.492     0.150
     8.988   132.258     0.150
    10.313   152.945     0.150
    10.349   152.484     0.150
    10.789   158.516     0.150
    10.789   155.914     0.150
    10.789   155.914     0.150
    10.831   156.969     0.150
    10.831   156.961     0.150
    10.935   162.594     0.150
    11.029   161.703     0.150
    11.945   174.406     0.150
    15.243   218.508     0.150
    22.502   300.539     0.150
    27.203   345.812     0.150
    29.466   364.984     0.150
    29.466   364.984     0.150
    37.071   431.562     0.150
    37.071   431.562     0.150
    40.056   456.555     0.150
     0.163     4.219     0.150
     0.215     5.227     0.150
     0.168     3.742     0.150
     0.168     6.734     0.150
     0.237     5.625     0.150
     0.241     5.383     0.150
     0.341     6.766     0.150
     0.320     6.492     0.150
     0.419     8.055     0.150
     0.424     8.266     0.150
     0.536    10.438     0.150
     0.536    17.938     0.150
     0.546    10.695     0.150
     0.611    10.477     0.150
     0.611    19.812     0.150
     0.662    12.453     0.150
     0.657    11.703     0.150
     0.657    20.719     0.150
     0.657    20.180     0.150
     0.694    13.156     0.150
     0.694    22.477     0.150
     0.689    12.547     0.150
     0.947    17.078     0.150
     0.950    18.789     0.150
     0.950    29.586     0.150
     0.954    17.062     0.150
     0.957    16.758     0.150
     0.957    30.258     0.150
     0.984    17.297     0.150
     0.984    31.430     0.150
     1.053    18.594     0.150
     1.112    19.930     0.150
     1.152    20.039     0.150
     1.189    20.203     0.150
     1.189    36.219     0.150
     1.189    19.945     0.150
     1.189    36.922     0.150
     1.239    20.844     0.150
     1.266    21.617     0.150
     1.266    39.555     0.150
     1.266    21.656     0.150
     1.472    24.500     0.150
     1.472    46.906     0.150
     1.561    24.945     0.150
     1.559    24.953     0.150
     1.559    44.055     0.150
     1.800    54.406     0.150
     1.928    31.453     0.150
     1.946    33.023     0.150
     2.375    39.359     0.150
     2.375    70.492     0.150
     2.397    43.109     0.150
     2.397    73.836     0.150
     2.463    44.023     0.150
     2.463    72.727     0.150
     2.570    38.727     0.150
     2.525    41.477     0.150
     2.525    41.359     0.150
     2.554    42.086     0.150
     2.554    75.742     0.150
     2.750    44.688     0.150
     3.069    48.398     0.150
     3.104    53.852     0.150
     3.302    50.266     0.150
     3.446    53.852     0.150
     3.540   101.773     0.150
     3.581    56.258     0.150
     3.581    55.883     0.150
     3.679    57.117     0.150
     3.679    69.797     0.150
     3.679   118.547     0.150
     3.756    57.688     0.150
     3.756   104.555     0.150
     3.999    63.234     0.150
     3.999    62.789     0.150
     4.119    60.664     0.150
     4.119    60.445     0.150
     4.264    66.242     0.150
     4.324    66.148     0.150
     4.324    82.227     0.150
     4.324   116.523     0.150
     4.393    67.438     0.150
     4.468    67.695     0.150
     4.958    73.906     0.150
     5.047    76.836     0.150
     5.209    81.414     0.150
     5.319    80.836     0.150
     5.319    79.859     0.150
     5.593    81.086     0.150
     5.772    89.609     0.150
     5.827   112.938     0.150
     5.868   113.133     0.150
     5.868    87.914     0.150
     6.378    94.992     0.150
     6.601    95.852     0.150
     6.682   129.477     0.150
     6.905   135.844     0.150
     7.105   137.148     0.150
     7.193   105.445     0.150
     7.300   106.305     0.150
     7.376   141.484     0.150
     7.583   110.375     0.150
     7.614   115.062     0.150
     7.617   115.547     0.150
     7.653   116.094     0.150
     7.683   116.742     0.150
     7.718   148.125     0.150
     7.846   114.781     0.150
     7.849   114.984     0.150
     7.849   147.109     0.150
     7.849   247.406     0.150
     7.849   114.945     0.150
     8.108   154.156     0.150
     8.108   260.930     0.150
     8.307   157.336     0.150
     8.742   125.727     0.150
     8.742   125.422     0.150
    10.850   155.258     0.150
    10.849   155.586     0.150
    10.850   155.258     0.150
    10.850   339.164     0.150
    10.875   161.836     0.150
    15.316   221.789     0.150
    27.263   347.586     0.150
    37.126   432.438     0.150
    37.126   432.438     0.150
     0.240     5.602     0.150
     0.228     8.805     0.150
     0.228     4.984     0.150
     0.228     7.617     0.150
     0.250     5.609     0.150
     0.250    10.719     0.150
     0.310     6.852     0.150
     0.382     7.750     0.150
     0.402     7.750     0.150
     0.500     9.570     0.150
     0.609    11.602     0.150
     0.609    20.195     0.150
     0.621    12.133     0.150
     0.621    21.328     0.150
     0.655    10.734     0.150
     0.655    20.562     0.150
     0.610    11.102     0.150
     0.610    20.141     0.150
     0.610    19.414     0.150
     0.619    12.008     0.150
     0.619    20.609     0.150
     0.698    12.828     0.150
     0.698    12.578     0.150
     0.746    24.453     0.150
     0.942    17.312     0.150
     0.942    30.062     0.150
     0.950    17.461     0.150
     0.950    31.305     0.150
     0.950    17.000     0.150
     0.950    30.281     0.150
     1.008    17.984     0.150
     1.008    31.773     0.150
     1.008    32.648     0.150
     0.989    17.742     0.150
     0.989    31.688     0.150
     1.028    18.328     0.150
     1.028    32.711     0.150
     1.122    19.648     0.150
     1.122    34.430     0.150
     1.184    20.961     0.150
     1.184    37.773     0.150
     1.184    36.883     0.150
     1.115    19.250     0.150
     1.115    35.414     0.150
     1.208    21.000     0.150
     1.208    36.984     0.150
     1.165    20.359     0.150
     1.314    22.578     0.150
     1.314    22.789     0.150
     1.485    24.984     0.150
     1.527    24.664     0.150
     1.620    24.844     0.150
     1.620    46.992     0.150
     1.670    27.984     0.150
     1.724    28.180     0.150
     1.743    28.430     0.150
     1.743    55.570     0.150
     1.900    30.508     0.150
     1.890    30.750     0.150
     1.989    32.320     0.150
     1.989    58.078     0.150
     2.125    33.812     0.150
     2.134    35.320     0.150
     2.189    34.633     0.150
     2.310    36.164     0.150
     2.390    37.414     0.150
     2.390    43.023     0.150
     2.390    74.719     0.150
     2.401    39.531     0.150
     2.426    38.219     0.150
     2.410    37.758     0.150
     2.410    75.695     0.150
     2.470    44.453     0.150
     2.517    39.430     0.150
     2.484    45.891     0.150
     2.484    38.727     0.150
     2.477    39.844     0.150
     2.556    45.703     0.150
     2.617    47.000     0.150
     2.737    42.406     0.150
     2.737    84.891     0.150
     3.005    46.125     0.150
     3.005    93.336     0.150
     3.071    47.156     0.150
     3.120    48.367     0.150
     3.338    54.281     0.150
     3.338    50.273     0.150
     3.425    51.875     0.150
     3.409    51.578     0.150
     3.473    53.562     0.150
     3.541    53.617     0.150
     3.562    54.930     0.150
     3.562    53.758     0.150
     3.641    55.750     0.150
     3.692    56.430     0.150
     3.738    56.164     0.150
     3.942    60.258     0.150
     3.979    59.430     0.150
     4.086    60.133     0.150
     4.218    63.555     0.150
     4.251    65.000     0.150
     4.251    64.344     0.150
     4.317    66.008     0.150
     4.392    66.680     0.150
     4.844    73.492     0.150
     4.896    73.211     0.150
     4.972    75.664     0.150
     5.132    78.359     0.150
     5.253    79.062     0.150
     5.253    78.453     0.150
     5.298    79.484     0.150
     5.298    79.078     0.150
     5.341    82.891     0.150
     5.363    82.930     0.150
     5.413    84.578     0.150
     5.569    83.109     0.150
     5.653    84.812     0.150
     5.696    86.352     0.150
     5.824    87.211     0.150
     5.824    86.484     0.150
     5.824   108.688     0.150
     6.103    93.820     0.150
     6.111    91.992     0.150
     6.352    94.141     0.150
     6.343    94.391     0.150
     6.561    95.852     0.150
     6.642   101.031     0.150
     7.120   106.969     0.150
     7.120   103.766     0.150
     7.141   106.352     0.150
     7.163   109.703     0.150
     7.245   106.203     0.150
     7.274   110.570     0.150
     7.298   108.523     0.150
     7.447   112.570     0.150
     7.472   109.094     0.150
     7.490   111.781     0.150
     7.492   111.820     0.150
     7.498   112.031     0.150
     7.497   111.789     0.150
     7.497   112.117     0.150
     7.504   112.523     0.150
     7.510   111.422     0.150
     7.529   110.141     0.150
     7.517   111.844     0.150
     7.544   113.250     0.150
     7.527   112.180     0.150
     7.537   112.383     0.150
     7.539   112.320     0.150
     7.541   112.359     0.150
     7.554   113.242     0.150
     7.573   112.914     0.150
     7.578   113.070     0.150
     7.607   113.570     0.150
     7.627   113.062     0.150
     7.642   115.281     0.150
     7.673   113.984     0.150
     7.762   115.164     0.150
     7.787   112.508     0.150
     7.789   114.508     0.150
     7.789   145.234     0.150
     7.789   245.156     0.150
     7.789   112.727     0.150
     7.835   118.594     0.150
     7.844   117.141     0.150
     8.125   121.031     0.150
     8.222   122.922     0.150
     8.232   123.219     0.150
     8.529   125.461     0.150
     8.529   122.719     0.150
     8.616   128.000     0.150
     8.707   125.320     0.150
     8.707   124.719     0.150
     8.715   129.750     0.150
     8.808   127.648     0.150
     8.999   131.992     0.150
     9.121   134.883     0.150
     9.192   132.367     0.150
     9.200   135.531     0.150
     9.200   132.234     0.150
     9.266   138.367     0.150
     9.253   136.062     0.150
     9.452   137.180     0.150
     9.452   134.914     0.150
     9.475   137.672     0.150
     9.764   139.375     0.150
    10.002   145.023     0.150
    10.290   146.844     0.150
    10.324   151.617     0.150
    10.373   151.117     0.150
    10.373   151.969     0.150
    10.466   153.172     0.150
    10.547   155.453     0.150
    10.554   156.234     0.150
    10.712   156.758     0.150
    10.712   152.156     0.150
    10.827   154.664     0.150
    10.828   155.812     0.150
    10.799   157.930     0.150
    10.799   154.805     0.150
    10.799   157.859     0.150
    10.799   157.312     0.150
    10.799   157.500     0.150
    10.884   158.805     0.150
    10.946   161.164     0.150
    10.972   161.367     0.150
    10.972   157.594     0.150
    11.040   160.820     0.150
    11.065   163.172     0.150
    11.159   159.609     0.150
    11.160   163.930     0.150
    11.196   164.953     0.150
    11.245   164.648     0.150
    11.335   166.273     0.150
    11.424   168.094     0.150
    11.518   168.031     0.150
    11.533   167.812     0.150
    11.569   164.828     0.150
    11.666   167.617     0.150
    11.659   170.562     0.150
    11.874   173.781     0.150
    11.949   174.328     0.150
    12.036   174.492     0.150
    12.147   177.609     0.150
    12.174   176.203     0.150
    12.201   178.562     0.150
    12.286   180.023     0.150
    12.514   183.711     0.150
    12.797   186.102     0.150
    12.900   188.617     0.150
    12.987   190.148     0.150
    13.009   188.750     0.150
    13.388   190.422     0.150
    13.603   198.078     0.150
    13.644   192.430     0.150
    13.680   198.641     0.150
    13.828   200.359     0.150
    13.897   201.289     0.150
    13.948   202.383     0.150
    14.038   199.820     0.150
    14.038   197.977     0.150
    14.250   201.023     0.150
    14.674   207.164     0.150
    14.725   211.883     0.150
    14.815   212.953     0.150
    14.956   215.508     0.150
    15.255   220.062     0.150
    15.255   219.133     0.150
    15.255   215.594     0.150
    15.306   216.594     0.150
    15.306   213.633     0.150
    15.382   218.859     0.150
    15.382   217.844     0.150
    15.426   218.570     0.150
    15.426   216.961     0.150
    15.565   224.859     0.150
    15.595   224.070     0.150
    15.595   221.438     0.150
    15.664   224.594     0.150
    16.051   229.305     0.150
    16.457   233.484     0.150
    16.457   230.391     0.150
    16.545   234.094     0.150
    16.545   230.648     0.150
    16.684   239.484     0.150
    17.098   239.562     0.150
    17.621   247.680     0.150
    17.621   245.148     0.150
    17.691   245.852     0.150
    17.854   247.539     0.150
    17.885   247.758     0.150
    18.033   249.352     0.150
    18.068   252.703     0.150
    18.175   251.266     0.150
    18.235   252.727     0.150
    18.245   254.305     0.150
    18.245   253.500     0.150
    18.282   253.266     0.150
    18.275   253.438     0.150
    18.327   254.914     0.150
    18.327   253.148     0.150
    18.322   253.977     0.150
    18.445   255.148     0.150
    18.552   256.148     0.150
    18.576   256.281     0.150
    18.582   256.273     0.150
    18.687   258.250     0.150
    18.703   260.258     0.150
    18.703   258.781     0.150
    18.699   261.828     0.150
    18.699   258.516     0.150
    18.737   260.062     0.150
    18.737   256.617     0.150
    18.828   258.789     0.150
    18.897   262.562     0.150
    18.897   260.305     0.150
    18.948   261.930     0.150
    18.948   260.688     0.150
    18.948   260.109     0.150
    19.017   261.320     0.150
    19.038   262.406     0.150
    19.049   262.156     0.150
    19.062   262.570     0.150
    19.078   264.164     0.150
    19.078   263.312     0.150
    19.110   263.203     0.150
    19.157   263.523     0.150
    19.181   264.328     0.150
    19.195   263.688     0.150
    19.277   264.852     0.150
    19.338   265.734     0.150
    19.409   268.594     0.150
    19.453   266.352     0.150
    19.470   267.617     0.150
    19.490   265.859     0.150
    19.535   270.180     0.150
    19.535   267.477     0.150
    19.612   267.688     0.150
    19.630   268.258     0.150
    19.700   268.320     0.150
    19.721   268.578     0.150
    19.747   269.680     0.150
    19.761   269.930     0.150
    19.785   269.992     0.150
    19.784   271.383     0.150
    19.835   271.891     0.150
    19.870   272.039     0.150
    19.875   271.742     0.150
    19.934   271.570     0.150
    19.975   274.438     0.150
    19.975   272.750     0.150
    20.003   272.930     0.150
    19.996   273.633     0.150
    19.996   273.195     0.150
    20.030   274.102     0.150
    20.043   274.492     0.150
    20.052   274.711     0.150
    20.112   274.312     0.150
    20.250   275.516     0.150
    20.253   276.000     0.150
    20.305   276.273     0.150
    20.336   279.062     0.150
    20.336   277.430     0.150
    20.354   277.477     0.150
    20.347   277.312     0.150
    20.380   279.273     0.150
    20.380   277.422     0.150
    20.382   276.797     0.150
    20.404   278.008     0.150
    20.404   277.844     0.150
    20.441   279.961     0.150
    20.441   278.578     0.150
    20.516   279.477     0.150
    20.552   280.953     0.150
    20.552   279.250     0.150
    20.649   279.664     0.150
    20.704   280.188     0.150
    20.699   281.023     0.150
    20.760   281.453     0.150
    20.772   282.125     0.150
    20.781   281.688     0.150
    20.838   282.266     0.150
    20.920   284.000     0.150
    20.979   282.961     0.150
    20.962   282.758     0.150
    20.967   282.891     0.150
    20.994   284.273     0.150
    20.996   283.922     0.150
    21.015   285.812     0.150
    21.044   285.039     0.150
    21.050   284.461     0.150
    21.048   284.641     0.150
    21.092   284.906     0.150
    21.143   286.328     0.150
    21.143   285.508     0.150
    21.156   285.039     0.150
    21.191   287.336     0.150
    21.233   285.250     0.150
    21.254   286.242     0.150
    21.300   288.508     0.150
    21.300   287.430     0.150
    21.310   286.664     0.150
    21.353   289.484     0.150
    21.353   287.938     0.150
    21.434   286.773     0.150
    21.447   288.000     0.150
    21.488   288.125     0.150
    21.527   289.438     0.150
    21.534   288.828     0.150
    21.608   288.797     0.150
    21.612   290.359     0.150
    21.696   291.422     0.150
    21.693   291.594     0.150
    21.753   291.008     0.150
    21.766   293.711     0.150
    21.766   291.477     0.150
    21.778   292.188     0.150
    21.893   292.398     0.150
    21.912   292.977     0.150
    21.936   293.180     0.150
    21.931   293.453     0.150
    21.944   294.930     0.150
    21.991   294.867     0.150
    22.044   294.305     0.150
    22.097   295.406     0.150
    22.099   295.336     0.150
    22.126   295.508     0.150
    22.177   297.883     0.150
    22.177   296.281     0.150
    22.206   296.062     0.150
    22.219   295.930     0.150
    22.270   296.219     0.150
    22.272   298.273     0.150
    22.272   296.602     0.150
    22.266   298.594     0.150
    22.330   298.984     0.150
    22.330   297.688     0.150
    22.420   298.117     0.150
    22.442   298.422     0.150
    22.439   298.836     0.150
    22.445   299.234     0.150
    22.482   299.156     0.150
    22.511   300.633     0.150
    22.511   301.078     0.150
    22.665   301.055     0.150
    22.706   301.227     0.150
    22.728   301.281     0.150
    22.764   303.680     0.150
    22.764   302.852     0.150
    22.770   302.648     0.150
    22.811   304.109     0.150
    22.811   302.727     0.150
    22.820   302.477     0.150
    22.846   303.422     0.150
    23.002   307.031     0.150
    23.002   304.156     0.150
    23.041   305.578     0.150
    23.038   305.961     0.150
    23.038   305.812     0.150
    23.084   305.703     0.150
    23.152   307.133     0.150
    23.152   305.719     0.150
    23.184   306.586     0.150
    23.257   306.656     0.150
    23.279   306.922     0.150
    23.275   306.703     0.150
    23.326   307.695     0.150
    23.367   309.930     0.150
    23.367   307.523     0.150
    23.407   310.258     0.150
    23.407   307.266     0.150
    23.468   311.961     0.150
    23.468   309.344     0.150
    23.518   309.422     0.150
    23.590   312.008     0.150
    23.590   310.484     0.150
    23.594   310.617     0.150
    23.682   310.547     0.150
    23.702   311.164     0.150
    23.718   312.578     0.150
    23.701   311.672     0.150
    23.713   312.117     0.150
    23.868   312.969     0.150
    23.932   313.898     0.150
    23.931   315.711     0.150
    23.931   314.484     0.150
    23.952   314.391     0.150
    24.052   315.750     0.150
    24.179   317.984     0.150
    24.189   317.469     0.150
    24.246   316.422     0.150
    24.297   318.469     0.150
    24.407   317.031     0.150
    24.444   318.086     0.150
    24.573   319.625     0.150
    24.569   319.805     0.150
    24.568   319.727     0.150
    24.619   322.312     0.150
    24.619   319.062     0.150
    24.654   319.492     0.150
    24.685   321.359     0.150
    24.685   320.250     0.150
    24.850   324.414     0.150
    24.850   321.219     0.150
    24.962   323.320     0.150
    25.054   324.742     0.150
    25.224   324.578     0.150
    25.345   327.031     0.150
    25.379   327.773     0.150
    25.385   328.578     0.150
    25.407   328.680     0.150
    26.128   333.211     0.150
    26.320   336.109     0.150
    26.418   336.336     0.150
    26.545   336.422     0.150
    26.601   337.062     0.150
    26.633   336.992     0.150
    26.881   339.406     0.150
    26.924   340.555     0.150
    26.997   343.305     0.150
    27.214   346.008     0.150
    27.214   346.938     0.150
    29.477   366.039     0.150
    30.386   374.930     0.150
    31.909   387.438     0.150
    32.967   398.039     0.150
    33.616   398.391     0.150
    34.390   408.789     0.150
    35.618   421.320     0.150
    35.720   421.500     0.150
    35.784   421.781     0.150
    36.093   424.844     0.150
    36.793   429.609     0.150
    36.793   429.930     0.150
    36.934   431.641     0.150
    37.055   432.805     0.150
    37.083   431.648     0.150
    37.083   432.312     0.150
    37.083   432.781     0.150
    37.260   434.680     0.150
    37.286   433.938     0.150
    37.348   435.391     0.150
    37.637   437.180     0.150
    37.993   440.219     0.150
    38.489   444.898     0.150
    39.750   456.023     0.150
    40.067   457.148     0.150
    40.539   463.031     0.150
    54.976   572.453     0.150
    54.976   572.758     0.150
    62.051   621.688     0.150
    62.506   624.109     0.150
    73.848   694.984     0.150
    74.783   699.383     0.150
    76.520   710.109     0.150
    76.743   712.883     0.150
    78.241   721.227     0.150
    80.825   734.984     0.150
    80.934   735.711     0.150
    81.593   739.234     0.150
    83.886   750.438     0.150
    83.909   751.164     0.150
    84.742   755.070     0.150
    91.142   786.641     0.150
    91.592   787.055     0.150
    92.325   791.758     0.150
    94.141   797.680     0.150
    94.593   799.961     0.150
    95.674   806.484     0.150
    95.777   806.484     0.150
    97.387   813.961     0.150
    98.922   820.711     0.150
   100.620   828.961     0.150
   101.980   833.461     0.150
   101.980   837.961     0.150
   101.980   841.758     0.150
   106.333   851.461     0.150
   117.107  1126.508     0.150
   119.134  1129.922     0.150
   119.101  1131.062     0.150
   119.123  1130.852     0.150
   145.384  1178.547     0.150
   145.384  1178.344     0.150
   145.692  1180.039     0.150
     0.234     5.102     0.150
     0.243     5.631     0.150
     0.247     5.570     0.150
     0.247    10.580     0.150
     0.311     6.861     0.150
     0.320     6.781     0.150
     0.503     9.570     0.150
     0.613    11.691     0.150
     0.613    20.111     0.150
     0.613    19.184     0.150
     0.620    11.898     0.150
     0.620    20.779     0.150
     0.625    11.990     0.150
     0.625    20.820     0.150
     0.603    11.080     0.150
     0.603    18.664     0.150
     0.651    10.730     0.150
     0.651    20.480     0.150
     0.752    14.072     0.150
     0.752    24.199     0.150
     0.694    12.531     0.150
     0.694    22.641     0.150
     0.948    17.518     0.150
     0.948    29.932     0.150
     0.952    16.951     0.150
     0.952    30.811     0.150
     0.955    17.160     0.150
     0.955    30.650     0.150
     0.955    30.475     0.150
     0.996    17.805     0.150
     0.996    31.939     0.150
     1.014    18.111     0.150
     1.014    17.900     0.150
     1.014    32.000     0.150
     1.032    18.398     0.150
     1.032    33.053     0.150
     1.127    19.621     0.150
     1.127    35.121     0.150
     1.111    19.352     0.150
     1.111    34.404     0.150
     1.165    20.377     0.150
     1.189    21.031     0.150
     1.189    37.480     0.150
     1.214    21.070     0.150
     1.320    22.469     0.150
     1.320    40.605     0.150
     1.320    22.471     0.150
     1.320    40.602     0.150
     1.491    24.758     0.150
     1.520    24.580     0.150
     1.520    45.361     0.150
     1.675    27.973     0.150
     1.744    28.598     0.150
     1.721    28.305     0.150
     1.903    30.641     0.150
     1.889    30.889     0.150
     1.988    32.051     0.150
     2.131    34.230     0.150
     2.131    65.805     0.150
     2.194    34.816     0.150
     2.305    36.230     0.150
     2.396    37.586     0.150
     2.407    38.432     0.150
     2.412    37.930     0.150
     2.433    37.635     0.150
     2.476    39.170     0.150
     2.488    38.830     0.150
     2.474    39.150     0.150
     2.523    39.035     0.150
     2.623    40.479     0.150
     2.623    81.420     0.150
     2.550    38.490     0.150
     2.550    68.670     0.150
     2.742    42.510     0.150
     2.742    85.346     0.150
     2.917    44.875     0.150
     3.010    46.004     0.150
     3.077    48.211     0.150
     3.077    47.453     0.150
     3.127    47.627     0.150
     3.345    52.271     0.150
     3.345    50.207     0.150
     3.413    51.674     0.150
     3.431    51.832     0.150
     3.473    53.490     0.150
     3.548    53.645     0.150
     3.567    53.900     0.150
     3.567    53.779     0.150
     3.588    53.916     0.150
     3.645    55.131     0.150
     3.645    68.531     0.150
     3.645   114.740     0.150
     3.744    55.439     0.150
     3.686    55.881     0.150
     3.944    60.230     0.150
     3.984    59.773     0.150
     3.998    59.688     0.150
     4.046    60.473     0.150
     4.080    60.170     0.150
     4.080    75.842     0.150
     4.080    59.969     0.150
     4.222    63.727     0.150
     4.247    64.900     0.150
     4.247    64.400     0.150
     4.332    65.375     0.150
     4.314    65.580     0.150
     4.391    66.682     0.150
     4.572    68.846     0.150
     4.727    71.811     0.150
     4.842    73.461     0.150
     4.890    73.031     0.150
     4.970    75.271     0.150
     5.130    77.941     0.150
     5.248    78.891     0.150
     5.312    78.061     0.150
     5.299    79.131     0.150
     5.299    78.959     0.150
     5.368    79.740     0.150
     5.367    84.111     0.150
     5.417    82.441     0.150
     5.653    84.570     0.150
     5.694    86.432     0.150
     5.785    85.900     0.150
     5.828    86.881     0.150
     5.828    86.355     0.150
     5.828   182.807     0.150
     6.079    90.420     0.150
     6.109    90.641     0.150
     6.109   113.980     0.150
     6.101    92.330     0.150
     6.109    91.191     0.150
     6.304    95.262     0.150
     6.346    94.102     0.150
     6.357    93.650     0.150
     6.357   117.441     0.150
     6.555   166.771     0.150
     6.872   103.250     0.150
     7.066   106.111     0.150
     7.071   103.141     0.150
     7.116   106.461     0.150
     7.116   133.861     0.150
     7.116   105.238     0.150
     7.161   109.111     0.150
     7.295   108.580     0.150
     7.446   113.512     0.150
     7.472   112.730     0.150
     7.472   141.092     0.150
     7.472   235.080     0.150
     7.500   110.801     0.150
     7.500   143.682     0.150
     7.487   110.670     0.150
     7.488   111.592     0.150
     7.502   112.410     0.150
     7.493   112.051     0.150
     7.494   111.791     0.150
     7.506   111.031     0.150
     7.513   111.631     0.150
     7.524   111.611     0.150
     7.533   111.941     0.150
     7.535   111.961     0.150
     7.538   111.910     0.150
     7.550   112.592     0.150
     7.570   112.471     0.150
     7.574   112.490     0.150
     7.604   113.061     0.150
     7.623   113.061     0.150
     7.641   115.271     0.150
     7.670   113.650     0.150
     7.759   114.691     0.150
     7.839   118.092     0.150
     7.850   119.000     0.150
     7.850   198.250     0.150
     7.783   114.551     0.150
     7.783   244.352     0.150
     7.842   116.740     0.150
     8.085   118.041     0.150
     8.125   121.471     0.150
     8.227   120.111     0.150
     8.221   122.762     0.150
     8.230   123.211     0.150
     8.512   123.330     0.150
     8.616   128.691     0.150
     8.714   129.920     0.150
     8.999   132.420     0.150
     9.120   134.830     0.150
     9.197   133.521     0.150
    10.323   152.031     0.150
    10.362   148.920     0.150
    10.378   154.129     0.150
    10.378   151.420     0.150
    10.551   153.471     0.150
    10.545   153.021     0.150
    10.556   157.092     0.150
    10.821   155.807     0.150
    10.946   161.160     0.150
    11.039   160.891     0.150
    11.064   162.670     0.150
    11.159   163.570     0.150
    11.201   164.820     0.150
    11.334   164.311     0.150
    11.537   169.811     0.150
    11.876   174.352     0.150
    11.981   174.480     0.150
    12.516   182.701     0.150
    12.721   184.621     0.150
    13.683   198.352     0.150
    13.703   199.451     0.150
    14.236   205.781     0.150
    15.568   224.131     0.150
    18.168   255.500     0.150
    62.512   625.105     0.150
    68.505   668.451     0.150
    73.848   695.230     0.150
    74.780   700.031     0.150
    76.741   712.631     0.150
    76.741   712.656     0.150
    78.239   719.699     0.150
    78.626   723.656     0.150
    80.825   734.355     0.150
    84.335   754.105     0.150
    89.868   775.131     0.150
    91.006   784.104     0.150
    91.146   787.391     0.150
    91.594   787.850     0.150
    92.085   786.531     0.150
    94.143   801.111     0.150
    94.347   801.531     0.150
    94.362   801.932     0.150
    94.397   803.932     0.150
    94.597   799.932     0.150
    95.676   807.221     0.150
    95.779   807.223     0.150
    97.393   814.932     0.150
   100.624   829.631     0.150
   106.338   852.131     0.150
   107.025  2036.932     0.150
   111.628  1114.932     0.150
   119.106  1130.830     0.150
   121.806  1136.984     0.150
   121.915  1138.594     0.150
   145.382  1178.270     0.150
   145.686  1179.807     0.150
   146.185  1181.830     0.150
     0.194     4.352     0.150
     0.194     7.777     0.150
     0.205     4.973     0.150
     0.241     5.520     0.150
     0.285     6.121     0.150
     0.285    11.180     0.150
     0.308     6.051     0.150
     0.347     7.090     0.150
     0.418     8.051     0.150
     0.465     8.902     0.150
     0.573    10.973     0.150
     0.573    19.250     0.150
     0.573    18.734     0.150
     0.586    11.449     0.150
     0.586    19.723     0.150
     0.643    10.852     0.150
     0.643    20.012     0.150
     0.638    11.691     0.150
     0.638    20.824     0.150
     0.646    12.480     0.150
     0.646    21.480     0.150
     0.714    13.742     0.150
     0.714    23.297     0.150
     0.942    16.746     0.150
     0.942    29.758     0.150
     0.974    17.633     0.150
     0.974    30.680     0.150
     0.976    17.527     0.150
     0.976    30.926     0.150
     1.040    18.438     0.150
     1.040    32.547     0.150
     1.087    19.172     0.150
     1.087    33.301     0.150
     1.148    20.543     0.150
     1.148    36.742     0.150
     1.148    36.359     0.150
     1.151    19.816     0.150
     1.151    35.715     0.150
     1.196    20.797     0.150
     1.196    37.016     0.150
     1.284    22.098     0.150
     1.284    39.266     0.150
     1.468    24.492     0.150
     1.551    25.371     0.150
     1.760    54.102     0.150
     1.764    28.750     0.150
     1.912    30.672     0.150
     1.968    56.641     0.150
     1.968    31.672     0.150
     2.345    40.691     0.150
     2.403    73.391     0.150
     2.572    39.117     0.150
     2.572    77.672     0.150
     3.726    58.141     0.150
     4.110    61.301     0.150
     4.110    60.902     0.150
     4.287    66.172     0.150
     4.930    74.410     0.150
     5.835    85.906     0.150
     6.588    95.820     0.150
     7.277   107.141     0.150
     7.823   245.941     0.150
     7.823   117.840     0.150
    10.832   160.973     0.150
     0.189     4.283     0.150
     0.189     7.250     0.150
     0.205     4.813     0.150
     0.249     5.503     0.150
     0.314     6.103     0.150
     0.343     7.033     0.150
     0.465     8.823     0.150
     0.571    10.933     0.150
     0.571    19.053     0.150
     0.571    18.822     0.150
     0.584    11.623     0.150
     0.584    19.593     0.150
     0.645    11.723     0.150
     0.645    19.423     0.150
     0.645    20.062     0.150
     0.650    20.733     0.150
     0.642    12.531     0.150
     0.642    21.534     0.150
     0.708    13.649     0.150
     0.708    23.631     0.150
     0.926    19.243     0.150
     0.926    29.893     0.150
     0.930    16.733     0.150
     0.930    29.443     0.150
     0.933    16.713     0.150
     0.933    29.723     0.150
     0.933    30.351     0.150
     0.970    17.573     0.150
     0.970    30.953     0.150
     0.970    30.833     0.150
     0.968    17.418     0.150
     0.968    31.119     0.150
     1.033    18.480     0.150
     1.033    32.898     0.150
     1.084    19.313     0.150
     1.084    34.253     0.150
     1.153    36.043     0.150
     1.153    19.952     0.150
     1.153    36.316     0.150
     1.146    20.783     0.150
     1.146    36.173     0.150
     1.146    36.583     0.150
     1.170    20.583     0.150
     1.170    36.393     0.150
     1.193    20.795     0.150
     1.277    21.992     0.150
     1.277    22.063     0.150
     1.277    39.213     0.150
     1.460    24.553     0.150
     1.558    25.493     0.150
     1.558    47.113     0.150
     1.761    28.802     0.150
     1.761    54.571     0.150
     1.759    28.988     0.150
     1.905    31.055     0.150
     1.921    31.286     0.150
     1.973    32.333     0.150
     1.973    58.863     0.150
     2.107    34.266     0.150
     2.349    38.013     0.150
     2.362    41.840     0.150
     2.362    72.714     0.150
     2.380    42.163     0.150
     2.395    37.169     0.150
     2.423    38.261     0.150
     2.448    42.323     0.150
     2.486    39.683     0.150
     2.486    39.383     0.150
     2.511    40.293     0.150
     2.511    71.073     0.150
     2.580    39.013     0.150
     2.580    39.279     0.150
     2.595    41.045     0.150
     2.724    42.787     0.150
     2.724    84.378     0.150
     2.925    54.910     0.150
     3.051    47.103     0.150
     3.051    58.113     0.150
     3.494    54.463     0.150
     3.494    94.973     0.150
     3.552    54.983     0.150
     3.552    94.213     0.150
     3.642    56.203     0.150
     3.642    96.833     0.150
     3.730    58.113     0.150
     3.730    99.193     0.150
     3.955    61.143     0.150
     3.955   102.713     0.150
     4.118    60.703     0.150
     4.290    66.163     0.150
     4.352    67.213     0.150
     4.423    67.783     0.150
     4.873    74.593     0.150
     4.935    74.393     0.150
     5.002    76.283     0.150
     5.165    79.443     0.150
     5.315    81.093     0.150
     5.346    81.663     0.150
     5.597    82.013     0.150
     5.678    85.563     0.150
     5.728    87.683     0.150
     5.828    89.343     0.150
     5.828    89.343     0.150
     6.346    94.543     0.150
     6.595    95.765     0.150
     6.643    97.603     0.150
     7.159   103.253     0.150
     7.283   107.583     0.150
     7.331   110.053     0.150
     7.499   110.623     0.150
     7.529   111.673     0.150
     7.510   109.013     0.150
     7.534   113.653     0.150
     7.553   114.413     0.150
     7.564   109.633     0.150
     7.575   113.613     0.150
     7.577   113.553     0.150
     7.591   114.423     0.150
     7.610   114.213     0.150
     7.614   114.663     0.150
     7.644   114.793     0.150
     7.710   115.233     0.150
     7.828   115.138     0.150
     7.828   144.988     0.150
     7.828   242.813     0.150
     7.828   116.053     0.150
     7.878   119.183     0.150
     8.211   258.383     0.150
     8.251   121.193     0.150
     8.739   126.383     0.150
     8.739   125.803     0.150
     9.149   133.353     0.150
    10.352   154.073     0.150
    10.749   153.603     0.150
    10.855   155.333     0.150
    10.855   155.843     0.150
    10.856   155.843     0.150
    10.856   341.688     0.150
    10.830   155.803     0.150
    10.830   154.783     0.150
    10.830   158.815     0.150
    10.830   346.565     0.150
    10.830   157.493     0.150
    12.313   176.683     0.150
    12.539   179.483     0.150
    15.270   220.387     0.150
    15.412   217.363     0.150
    37.086   433.343     0.150
    94.588   799.743     0.150
   100.627   829.543     0.150
     0.153     3.731     0.150
     0.153     6.441     0.150
     0.153     6.219     0.150
     0.409     7.761     0.150
     0.409    13.302     0.150
     0.444     8.271     0.150
     0.444    14.251     0.150
     0.463     9.812     0.150
     0.449     8.691     0.150
     0.449    14.822     0.150
     0.459     8.751     0.150
     0.459    14.931     0.150
     0.500     9.302     0.150
     0.528    10.312     0.150
     0.529    10.265     0.150
     0.529    17.046     0.150
     0.560    10.842     0.150
     0.602    11.171     0.150
     0.602    11.316     0.150
     0.602    19.035     0.150
     0.594    11.101     0.150
     0.594    19.001     0.150
     0.656    20.681     0.150
     0.656    12.111     0.150
     0.672    12.433     0.150
     0.672    21.280     0.150
     0.672    12.471     0.150
     0.766    14.312     0.150
     0.761    14.171     0.150
     0.761    24.261     0.150
     0.761    13.991     0.150
     0.761    23.921     0.150
     0.933    17.342     0.150
     0.933    29.514     0.150
     0.964    16.967     0.150
     1.015    18.174     0.150
     1.015    31.677     0.150
     1.047    18.072     0.150
     1.127    20.491     0.150
     1.127    37.031     0.150
     1.255    20.812     0.150
     1.255    20.957     0.150
     1.255    38.630     0.150
     1.319    23.211     0.150
     1.337    23.836     0.150
     1.337    41.486     0.150
     1.378    24.092     0.150
     1.501    24.943     0.150
     1.501    46.329     0.150
     1.671    26.941     0.150
     1.671    27.052     0.150
     1.650    29.761     0.150
     1.650    29.302     0.150
     1.650    50.803     0.150
     1.790    29.890     0.150
     1.790    52.551     0.150
     1.805    29.701     0.150
     1.796    29.885     0.150
     1.796    52.481     0.150
     1.845    30.153     0.150
     1.845    57.064     0.150
     1.881    30.062     0.150
     1.871    31.236     0.150
     1.871    54.714     0.150
     1.882    33.111     0.150
     1.934    33.673     0.150
     1.934    60.090     0.150
     1.934    33.812     0.150
     2.098    36.781     0.150
     2.098    62.832     0.150
     2.099    36.812     0.150
     2.099    61.881     0.150
     2.082    36.046     0.150
     2.082    64.417     0.150
     2.164    34.021     0.150
     2.246    35.846     0.150
     2.246    68.906     0.150
     2.287    37.211     0.150
     2.312    37.292     0.150
     2.312    37.115     0.150
     2.312    71.412     0.150
     2.320    37.329     0.150
     2.320    71.110     0.150
     2.433    38.228     0.150
     2.433    75.292     0.150
     2.536    40.708     0.150
     2.555    41.420     0.150
     2.555    78.865     0.150
     2.700    46.968     0.150
     2.700    83.048     0.150
     2.697    43.011     0.150
     2.697    42.667     0.150
     2.697    75.174     0.150
     2.873    45.336     0.150
     2.897    45.121     0.150
     2.919    45.042     0.150
     2.935    45.951     0.150
     2.959    46.953     0.150
     3.150    47.388     0.150
     3.181    49.427     0.150
     3.182    49.368     0.150
     3.415    51.721     0.150
     3.450    54.480     0.150
     3.607    57.241     0.150
     3.921    60.241     0.150
     3.921    60.379     0.150
     4.227    65.592     0.150
     4.299    65.021     0.150
     4.723    70.171     0.150
     4.723    70.022     0.150
     4.716    71.271     0.150
     4.751    71.941     0.150
     4.794    72.661     0.150
     4.794    72.424     0.150
     4.880    76.082     0.150
     4.914    74.381     0.150
     5.275    79.941     0.150
     5.351    80.524     0.150
     5.500    83.661     0.150
     5.515    82.421     0.150
     5.603    87.322     0.150
     5.634    90.822     0.150
     5.852    87.104     0.150
     5.856    87.911     0.150
     6.040    91.451     0.150
     6.959   101.991     0.150
     7.206   104.720     0.150
     7.651   114.312     0.150
     7.651   112.819     0.150
     7.918   115.131     0.150
     7.968   120.391     0.150
     7.975   118.461     0.150
     7.974   118.771     0.150
     7.977   119.971     0.150
     7.984   118.562     0.150
     8.010   121.181     0.150
     8.016   119.261     0.150
     8.029   120.531     0.150
     8.042   121.881     0.150
     8.056   119.562     0.150
     8.084   119.871     0.150
     8.117   120.731     0.150
     8.134   121.062     0.150
     8.215   124.491     0.150
     8.230   124.221     0.150
     8.415   122.522     0.150
     9.347   134.287     0.150
     9.741   142.971     0.150
    11.096   164.911     0.150
     0.469     9.234     0.150
     0.469    15.688     0.150
     0.471     9.227     0.150
     0.471    15.648     0.150
     0.515    10.164     0.150
     0.515    17.234     0.150
     0.761    14.367     0.150
     0.761    24.859     0.150
     0.847    16.594     0.150
     0.847    28.133     0.150
     0.959    17.352     0.150
     0.935    17.758     0.150
     0.975    18.617     0.150
     0.975    31.953     0.150
     1.035    19.602     0.150
     1.035    33.086     0.150
     1.056    19.570     0.150
     1.056    33.516     0.150
     1.241    21.852     0.150
     1.240    39.695     0.150
     1.240    22.148     0.150
     1.240    39.352     0.150
     1.291    42.375     0.150
     1.291    22.656     0.150
     1.291    39.883     0.150
     1.280    23.508     0.150
     1.280    41.914     0.150
     1.331    42.094     0.150
     1.360    24.000     0.150
     1.360    42.344     0.150
     1.360    24.305     0.150
     1.395    25.609     0.150
     1.417    26.375     0.150
     1.417    44.883     0.150
     1.441    45.812     0.150
     1.542    27.109     0.150
     1.542    49.797     0.150
     1.555    27.508     0.150
     1.555    27.383     0.150
     1.555    50.211     0.150
     1.738    31.289     0.150
     1.833    33.188     0.150
     1.920    35.547     0.150
     1.968    35.852     0.150
     1.968    61.664     0.150
     2.016    64.258     0.150
     2.070    37.398     0.150
     2.070    63.578     0.150
     2.124    35.070     0.150
     2.182    36.734     0.150
     2.313    71.242     0.150
     2.366    40.664     0.150
     2.366    73.219     0.150
     2.482    40.383     0.150
     2.482    77.859     0.150
     2.553    78.625     0.150
     2.665    84.422     0.150
     2.698    44.070     0.150
     2.694    43.141     0.150
     2.694    42.914     0.150
     2.714    44.734     0.150
     3.057    49.430     0.150
     3.057    48.633     0.150
     3.059    48.688     0.150
     3.194    50.344     0.150
     3.306    51.242     0.150
     3.292    52.133     0.150
     3.304    52.195     0.150
     3.819    59.016     0.150
     3.843    59.039     0.150
     3.956    61.469     0.150
     4.058    63.523     0.150
     4.144    64.789     0.150
     4.144    77.367     0.150
     4.236    66.078     0.150
     4.442    68.125     0.150
     4.442    83.688     0.150
     4.461    69.305     0.150
     4.461    84.086     0.150
     4.493    69.656     0.150
     4.493    84.094     0.150
     4.655    76.648     0.150
     4.655   146.094     0.150
     4.647    72.758     0.150
     4.854    74.617     0.150
     4.896    76.820     0.150
     4.896    75.023     0.150
     4.896    90.570     0.150
     4.896   155.242     0.150
     4.948    76.008     0.150
     5.147    77.867     0.150
     5.147    96.641     0.150
     5.171    77.477     0.150
     5.171    96.727     0.150
     5.318    80.867     0.150
     5.318    99.664     0.150
     5.376    81.977     0.150
     5.376   103.039     0.150
     5.419    82.484     0.150
     5.452    82.836     0.150
     5.553    85.141     0.150
     5.553   106.484     0.150
     5.714    86.578     0.150
     5.941    89.398     0.150
     5.941   113.859     0.150
     6.868   215.570     0.150
     6.909   103.000     0.150
     7.189   107.086     0.150
     7.191   106.398     0.150
     7.195   106.477     0.150
     7.202   107.297     0.150
     7.203   107.461     0.150
     7.209   107.398     0.150
     7.210   106.961     0.150
     7.210   135.695     0.150
     7.220   107.234     0.150
     7.220   137.961     0.150
     7.235   107.445     0.150
     7.235   137.406     0.150
     7.246   107.750     0.150
     7.256   108.023     0.150
     7.256   134.547     0.150
     7.257   108.211     0.150
     7.959   248.789     0.150
    10.201   150.031     0.150
    11.453   165.461     0.150
     0.178     4.211     0.150
     0.178     6.828     0.150
     0.178     7.164     0.150
     0.262     5.148     0.150
     0.384     7.312     0.150
     0.384    12.219     0.150
     0.384    12.648     0.150
     0.366     7.227     0.150
     0.366    12.352     0.150
     0.420     9.203     0.150
     0.420    15.969     0.150
     0.445     8.477     0.150
     0.498     9.867     0.150
     0.475     9.336     0.150
     0.475    15.516     0.150
     0.475    15.969     0.150
     0.510     9.953     0.150
     0.557    11.203     0.150
     0.563    10.797     0.150
     0.635    12.047     0.150
     0.635    20.062     0.150
     0.637    12.008     0.150
     0.637    20.320     0.150
     0.637    12.172     0.150
     0.666    12.633     0.150
     0.725    13.727     0.150
     0.725    23.156     0.150
     0.725    13.648     0.150
     0.725    23.469     0.150
     0.766    14.562     0.150
     0.766    24.852     0.150
     0.766    26.227     0.150
     0.936    16.961     0.150
     0.936    28.797     0.150
     1.023    18.781     0.150
     1.023    32.328     0.150
     0.986    18.305     0.150
     0.993    18.555     0.150
     0.993    31.898     0.150
     1.198    20.664     0.150
     1.198    36.078     0.150
     1.314    23.328     0.150
     1.379    25.594     0.150
     1.379    43.680     0.150
     1.368    24.328     0.150
     1.481    25.141     0.150
     1.481    45.781     0.150
     1.479    26.008     0.150
     1.629    27.062     0.150
     1.706    30.461     0.150
     1.706    53.570     0.150
     1.829    33.961     0.150
     1.849    30.672     0.150
     1.849    57.523     0.150
     1.852    31.688     0.150
     1.858    31.383     0.150
     1.858    55.711     0.150
     1.941    34.398     0.150
     1.941    59.742     0.150
     1.973    61.781     0.150
     1.929    32.641     0.150
     1.929    57.164     0.150
     1.994    35.492     0.150
     1.994    59.586     0.150
     2.057    37.727     0.150
     2.057    64.586     0.150
     2.058    37.484     0.150
     2.058    35.898     0.150
     2.104    33.945     0.150
     2.142    38.617     0.150
     2.142    63.328     0.150
     2.190    35.141     0.150
     2.190    61.680     0.150
     2.228    68.328     0.150
     2.282    38.867     0.150
     2.344    38.219     0.150
     2.344    37.516     0.150
     2.344    72.297     0.150
     2.372    42.570     0.150
     2.372    73.164     0.150
     2.447    39.133     0.150
     2.447    75.898     0.150
     2.598    41.711     0.150
     2.615    43.414     0.150
     2.757    44.516     0.150
     2.757    43.984     0.150
     2.757    78.109     0.150
     2.873    45.773     0.150
     3.015    53.914     0.150
     3.088    46.742     0.150
     3.088    81.625     0.150
     3.088    47.008     0.150
     3.088    82.438     0.150
     3.219    59.273     0.150
     3.233    52.719     0.150
     3.233    50.656     0.150
     3.233    98.898     0.150
     3.498    64.961     0.150
     3.942    62.094     0.150
     3.942    61.555     0.150
     4.253    65.125     0.150
     4.286    66.688     0.150
     4.662    70.344     0.150
     4.662    69.664     0.150
     4.704    71.867     0.150
     4.727    72.375     0.150
     4.757    72.578     0.150
     4.757    71.602     0.150
     5.120    78.695     0.150
     5.267    80.117     0.150
     5.267   151.336     0.150
     5.367    80.914     0.150
     5.484    82.414     0.150
     5.484   103.352     0.150
     5.639    91.547     0.150
     5.671    85.664     0.150
     5.671   104.203     0.150
     5.671   179.797     0.150
     5.807    87.094     0.150
     5.858    87.875     0.150
     5.858   111.406     0.150
     5.858   185.547     0.150
     6.051    91.086     0.150
     6.127    90.703     0.150
     6.127   118.227     0.150
     6.422    95.695     0.150
     7.147   104.492     0.150
     7.201   106.828     0.150
     7.617   114.477     0.150
     7.617   142.602     0.150
     7.696   113.484     0.150
     7.696   144.688     0.150
     7.724   114.156     0.150
     7.775   145.227     0.150
     7.937   117.227     0.150
     7.937   151.812     0.150
     7.941   117.438     0.150
     7.941   151.578     0.150
     7.946   116.758     0.150
     7.946   149.984     0.150
     7.950   116.148     0.150
     7.950   150.195     0.150
     7.958   117.062     0.150
     7.958   149.844     0.150
     7.971   117.398     0.150
     7.974   117.586     0.150
     7.983   118.016     0.150
     7.983   151.547     0.150
     7.989   118.531     0.150
     7.989   152.828     0.150
     8.001   117.664     0.150
     8.001   152.398     0.150
     8.016   117.867     0.150
     8.016   151.547     0.150
     8.028   120.945     0.150
     8.028   152.016     0.150
     8.056   120.727     0.150
     8.056   153.602     0.150
     8.088   119.594     0.150
     8.088   151.477     0.150
     8.109   118.836     0.150
     8.109   153.125     0.150
     8.365   120.547     0.150
    11.089   163.523     0.150
     0.091     2.477     0.150
     0.091     4.125     0.150
     0.091     2.621     0.150
     0.091     4.531     0.150
     0.095     2.688     0.150
     0.096     2.703     0.150
     0.096     4.703     0.150
     0.624    11.496     0.150
     0.612    11.418     0.150
     0.612    20.078     0.150
     0.623    11.688     0.150
     0.623    19.977     0.150
     0.699    12.477     0.150
     0.799    14.289     0.150
     0.799    24.934     0.150
     0.822    14.832     0.150
     0.822    25.152     0.150
     0.822    14.816     0.150
     0.851    14.996     0.150
     0.851    15.168     0.150
     0.851    26.117     0.150
     0.859    15.594     0.150
     0.859    27.516     0.150
     0.874    15.406     0.150
     0.834    15.773     0.150
     0.834    27.184     0.150
     0.911    16.238     0.150
     0.915    16.559     0.150
     0.915    28.699     0.150
     0.968    18.047     0.150
     0.968    31.047     0.150
     1.093    19.176     0.150
     1.093    33.137     0.150
     1.113    19.328     0.150
     1.211    21.426     0.150
     1.211    37.078     0.150
     1.232    20.887     0.150
     1.224    21.836     0.150
     1.224    37.941     0.150
     1.274    21.914     0.150
     1.274    40.578     0.150
     1.315    23.273     0.150
     1.315    42.008     0.150
     1.452    23.617     0.150
     1.469    23.738     0.150
     1.469    43.508     0.150
     1.432    24.641     0.150
     1.432    44.762     0.150
     1.425    25.102     0.150
     1.499    26.566     0.150
     1.535    26.051     0.150
     1.571    27.668     0.150
     1.571    48.156     0.150
     1.640    26.438     0.150
     1.640    26.617     0.150
     1.630    26.891     0.150
     1.717    28.594     0.150
     1.782    29.777     0.150
     1.857    30.707     0.150
     1.857    28.305     0.150
     1.821    30.305     0.150
     1.821    53.074     0.150
     1.803    30.445     0.150
     1.858    30.922     0.150
     1.922    32.246     0.150
     1.978    31.863     0.150
     1.967    32.355     0.150
     2.089    33.289     0.150
     2.168    35.668     0.150
     2.168    35.406     0.150
     2.200    36.012     0.150
     2.241    35.539     0.150
     2.387    36.277     0.150
     2.383    38.262     0.150
     2.530    40.531     0.150
     2.570    39.656     0.150
     2.570    40.316     0.150
     2.659    41.695     0.150
     2.680    41.703     0.150
     2.671    42.500     0.150
     2.706    43.105     0.150
     2.849    44.793     0.150
     2.918    44.605     0.150
     2.905    47.855     0.150
     2.962    46.383     0.150
     3.091    48.527     0.150
     3.170    49.746     0.150
     3.166    49.402     0.150
     3.203    50.379     0.150
     3.453    51.465     0.150
     3.423    52.996     0.150
     3.430    53.648     0.150
     3.549    55.492     0.150
     3.813    59.293     0.150
     3.821    57.465     0.150
     4.274    64.215     0.150
     4.373    66.348     0.150
     4.495    68.078     0.150
     4.536    68.043     0.150
     4.593    69.766     0.150
     4.579    70.457     0.150
     4.656    70.168     0.150
     4.656    70.473     0.150
     4.625    71.797     0.150
     4.756    71.977     0.150
     4.876    74.035     0.150
     4.930    71.527     0.150
     4.930    72.000     0.150
     4.916    73.988     0.150
     5.124    78.648     0.150
     5.124    77.828     0.150
     5.183    78.215     0.150
     5.366    81.027     0.150
     5.437    81.707     0.150
     5.507    81.797     0.150
     5.519    83.008     0.150
     5.528    84.758     0.150
     5.678    85.355     0.150
     5.702    85.836     0.150
     5.797    86.098     0.150
     5.899    89.008     0.150
     6.036    90.328     0.150
     6.078    91.305     0.150
     6.109    92.258     0.150
     6.274    94.105     0.150
     6.312    93.688     0.150
     6.440    93.258     0.150
     6.607    99.027     0.150
     6.883   102.516     0.150
     6.929   100.527     0.150
     6.959   102.715     0.150
     7.066   105.465     0.150
     7.173   103.836     0.150
     7.159   104.438     0.150
     7.259   106.668     0.150
     7.281   106.375     0.150
     7.281   107.762     0.150
     7.282   107.777     0.150
     7.282   107.953     0.150
     7.282   227.965     0.150
     7.359   106.816     0.150
     7.330   108.086     0.150
     7.361   108.887     0.150
     7.351   107.457     0.150
     7.481   110.465     0.150
     7.481   110.262     0.150
     7.524   108.148     0.150
     7.558   111.266     0.150
     7.727   113.637     0.150
     7.729   114.086     0.150
     7.733   112.828     0.150
     7.741   113.898     0.150
     7.747   114.266     0.150
     7.748   114.227     0.150
     7.758   113.777     0.150
     7.773   114.387     0.150
     7.803   113.516     0.150
     7.784   114.355     0.150
     7.794   114.727     0.150
     7.796   114.996     0.150
     7.829   115.156     0.150
     7.828   115.207     0.150
     7.849   115.496     0.150
     7.885   116.035     0.150
     7.889   116.496     0.150
     7.898   116.215     0.150
     7.887   115.125     0.150
     7.927   114.797     0.150
     8.019   117.637     0.150
     7.999   118.277     0.150
     8.071   118.355     0.150
     8.093   118.336     0.150
     8.129   119.707     0.150
     8.213   118.727     0.150
     8.216   118.598     0.150
     8.413   121.965     0.150
     8.413   121.777     0.150
     8.413   122.621     0.150
     8.409   121.578     0.150
     8.402   121.285     0.150
     8.753   126.176     0.150
     8.854   126.637     0.150
     8.909   128.055     0.150
     8.909   130.570     0.150
     8.904   126.527     0.150
     9.066   129.766     0.150
     9.283   136.215     0.150
     9.331   134.785     0.150
     9.331   136.227     0.150
     9.457   134.816     0.150
     9.527   136.336     0.150
     9.576   138.848     0.150
     9.832   141.902     0.150
     9.873   143.477     0.150
     9.873   142.070     0.150
     9.999   143.168     0.150
    10.153   145.285     0.150
    10.159   146.586     0.150
    10.159   145.812     0.150
    10.267   147.375     0.150
    10.303   146.527     0.150
    10.443   149.566     0.150
    10.492   152.016     0.150
    10.492   150.113     0.150
    10.562   150.727     0.150
    10.633   151.305     0.150
    10.667   151.359     0.150
    10.714   153.047     0.150
    10.715   151.746     0.150
    10.715   155.812     0.150
    10.736   152.953     0.150
    10.769   153.906     0.150
    10.771   152.543     0.150
    10.812   154.176     0.150
    10.853   156.348     0.150
    11.159   159.348     0.150
    11.260   159.082     0.150
    11.266   160.117     0.150
    11.414   163.277     0.150
    11.414   161.625     0.150
    11.450   162.293     0.150
    11.496   163.480     0.150
    11.700   167.488     0.150
    11.701   167.305     0.150
    11.925   169.738     0.150
    12.014   171.945     0.150
    12.018   170.047     0.150
    12.322   177.766     0.150
    12.322   173.863     0.150
    12.292   173.621     0.150
    12.801   184.109     0.150
    12.854   185.141     0.150
    12.933   185.344     0.150
    13.436   191.027     0.150
    13.675   193.996     0.150
    13.675   192.445     0.150
    13.830   196.375     0.150
    14.091   198.258     0.150
    14.141   199.797     0.150
    14.141   200.078     0.150
    14.284   200.898     0.150
    14.337   202.715     0.150
    14.464   204.125     0.150
    14.464   205.348     0.150
    14.460   205.969     0.150
    14.508   205.008     0.150
    14.508   205.680     0.150
    14.705   207.266     0.150
    14.705   207.809     0.150
    14.742   209.148     0.150
    14.742   210.684     0.150
    14.742   211.938     0.150
    14.773   207.484     0.150
    14.871   210.176     0.150
    14.983   211.688     0.150
    15.328   217.074     0.150
    15.349   216.965     0.150
    15.349   217.285     0.150
    15.538   218.438     0.150
    15.646   219.578     0.150
    15.890   223.586     0.150
    15.998   224.496     0.150
    16.071   224.934     0.150
    16.226   227.195     0.150
    16.522   231.043     0.150
    16.940   236.938     0.150
    16.940   236.777     0.150
    17.168   238.828     0.150
    17.168   239.801     0.150
    17.411   242.840     0.150
    17.518   242.797     0.150
    17.543   245.027     0.150
    17.543   244.477     0.150
    17.538   242.305     0.150
    17.908   246.996     0.150
    18.450   255.035     0.150
    18.525   256.125     0.150
    18.525   257.125     0.150
    18.680   257.016     0.150
    18.802   258.117     0.150
    18.802   259.125     0.150
    19.000   261.156     0.150
    19.000   261.500     0.150
    19.138   262.777     0.150
    19.138   263.398     0.150
    19.374   263.598     0.150
    19.454   265.945     0.150
    19.559   267.504     0.150
    19.615   267.715     0.150
    19.615   268.430     0.150
    19.760   269.176     0.150
    19.760   270.527     0.150
    20.023   272.348     0.150
    20.060   273.273     0.150
    20.312   274.914     0.150
    20.458   277.488     0.150
    20.503   276.391     0.150
    20.806   280.879     0.150
    20.851   280.152     0.150
    20.863   280.871     0.150
    20.935   283.766     0.150
    20.935   282.051     0.150
    20.994   282.715     0.150
    20.994   283.992     0.150
    21.039   283.555     0.150
    21.099   283.258     0.150
    21.100   284.078     0.150
    21.221   284.352     0.150
    21.269   284.656     0.150
    21.269   285.531     0.150
    21.270   284.898     0.150
    21.308   285.469     0.150
    21.347   286.543     0.150
    21.366   287.516     0.150
    21.366   287.102     0.150
    21.431   286.586     0.150
    21.477   288.383     0.150
    21.519   288.988     0.150
    21.574   289.227     0.150
    21.575   289.859     0.150
    21.639   289.180     0.150
    21.628   289.871     0.150
    21.642   289.719     0.150
    21.667   290.242     0.150
    21.749   291.598     0.150
    21.804   291.488     0.150
    21.804   291.641     0.150
    21.874   290.840     0.150
    21.963   295.453     0.150
    21.985   295.148     0.150
    22.167   296.230     0.150
    22.198   296.277     0.150
    22.225   297.254     0.150
    22.220   295.723     0.150
    22.240   295.820     0.150
    22.356   296.215     0.150
    22.412   295.930     0.150
    22.433   298.777     0.150
    22.433   297.887     0.150
    22.442   297.977     0.150
    22.441   298.914     0.150
    22.483   298.859     0.150
    22.526   299.273     0.150
    22.563   299.988     0.150
    22.567   300.234     0.150
    22.566   299.406     0.150
    22.566   299.996     0.150
    22.594   300.340     0.150
    22.650   299.949     0.150
    22.712   299.688     0.150
    22.751   301.148     0.150
    22.751   301.426     0.150
    22.752   300.961     0.150
    22.861   302.629     0.150
    22.853   303.070     0.150
    22.902   303.082     0.150
    22.988   302.930     0.150
    23.018   303.828     0.150
    23.107   304.332     0.150
    23.113   303.473     0.150
    23.119   303.195     0.150
    23.153   305.277     0.150
    23.159   304.258     0.150
    23.168   306.590     0.150
    23.281   308.195     0.150
    23.341   307.328     0.150
    23.401   306.277     0.150
    23.419   308.508     0.150
    23.463   310.363     0.150
    23.465   309.266     0.150
    23.535   310.078     0.150
    23.553   311.957     0.150
    23.526   307.855     0.150
    23.526   308.777     0.150
    23.614   308.105     0.150
    23.614   309.637     0.150
    23.633   308.730     0.150
    23.656   307.273     0.150
    23.652   309.184     0.150
    23.708   310.020     0.150
    23.769   312.203     0.150
    23.794   312.152     0.150
    23.820   310.566     0.150
    23.820   312.410     0.150
    23.860   311.855     0.150
    23.885   311.164     0.150
    24.048   315.145     0.150
    24.065   315.332     0.150
    24.185   315.031     0.150
    24.216   314.863     0.150
    24.343   315.812     0.150
    24.382   315.480     0.150
    24.381   315.691     0.150
    24.409   318.445     0.150
    24.457   316.379     0.150
    24.509   316.691     0.150
    24.611   320.086     0.150
    24.649   319.711     0.150
    24.660   320.039     0.150
    24.720   319.914     0.150
    24.752   322.695     0.150
    24.769   322.844     0.150
    24.856   323.684     0.150
    24.957   323.426     0.150
    24.966   323.289     0.150
    24.975   323.605     0.150
    25.019   324.207     0.150
    25.011   322.613     0.150
    25.079   324.992     0.150
    25.201   323.137     0.150
    25.378   329.348     0.150
    25.441   325.074     0.150
    25.467   325.805     0.150
    25.501   325.402     0.150
    25.529   328.172     0.150
    25.576   329.484     0.150
    25.727   326.770     0.150
    25.860   330.012     0.150
    26.001   332.426     0.150
    26.080   336.117     0.150
    26.101   332.012     0.150
    26.205   333.156     0.150
    26.307   334.055     0.150
    26.391   335.703     0.150
    26.457   337.449     0.150
    26.465   336.602     0.150
    26.579   336.273     0.150
    26.645   338.910     0.150
    26.680   339.055     0.150
    26.715   338.172     0.150
    26.722   336.234     0.150
    26.841   337.938     0.150
    26.950   341.664     0.150
    26.976   341.652     0.150
    27.016   340.941     0.150
    27.481   346.656     0.150
    27.716   347.168     0.150
    27.716   347.836     0.150
    27.848   350.605     0.150
    28.016   349.184     0.150
    28.711   354.902     0.150
    28.991   360.316     0.150
    29.021   360.977     0.150
    29.166   361.617     0.150
    29.326   362.129     0.150
    29.517   363.367     0.150
    29.816   366.988     0.150
    29.816   367.137     0.150
    30.315   371.312     0.150
    30.761   375.695     0.150
    31.579   382.652     0.150
    32.081   386.379     0.150
    32.161   387.516     0.150
    32.818   391.703     0.150
    32.864   395.465     0.150
    32.895   392.801     0.150
    33.700   400.328     0.150
    34.017   402.965     0.150
    34.419   406.617     0.150
    34.732   410.227     0.150
    35.025   412.844     0.150
    35.897   418.703     0.150
    36.149   421.051     0.150
    36.124   420.703     0.150
    36.182   422.035     0.150
    36.359   425.230     0.150
    39.329   447.777     0.150
    39.847   453.258     0.150
    54.584   569.605     0.150
    54.584   572.375     0.150
    61.247   618.875     0.150
    61.247   617.219     0.150
    63.090   632.375     0.150
    65.742   644.238     0.150
    65.742   647.777     0.150
    72.940   694.078     0.150
    77.772   721.477     0.150
    80.585   737.477     0.150
    81.488   739.527     0.150
    83.937   753.277     0.150
    84.580   757.977     0.150
    84.589   755.078     0.150
    85.295   762.738     0.150
    88.151   776.676     0.150
    88.740   776.777     0.150
    88.740   981.977     0.150
    89.978   784.777     0.150
    90.311   784.078     0.150
    90.311   993.477     0.150
    90.311  1411.375     0.150
    90.843   787.578     0.150
    90.843   784.238     0.150
    90.844   787.277     0.150
    93.768   796.477     0.150
    93.768  1430.078     0.150
    93.768  1461.676     0.150
    93.768  1471.977     0.150
    95.082   802.016     0.150
    95.082   806.176     0.150
    96.511   809.375     0.150
    99.940   825.875     0.150
   101.170   828.977     0.150
   101.170   833.477     0.150
   101.170   835.676     0.150
   101.170  1080.176     0.150
   105.505   847.777     0.150
     0.111     2.406     0.150
     0.111     2.711     0.150
     0.111     4.758     0.150
     0.607    11.625     0.150
     0.607    19.383     0.150
     0.623    12.055     0.150
     0.623    20.773     0.150
     0.630    12.008     0.150
     0.630    20.273     0.150
     0.782    14.523     0.150
     0.782    25.133     0.150
     0.815    15.250     0.150
     0.815    25.734     0.150
     0.815    15.008     0.150
     0.837    15.141     0.150
     0.854    15.961     0.150
     0.854    27.305     0.150
     0.897    16.805     0.150
     0.897    28.562     0.150
     0.852    16.375     0.150
     0.852    28.109     0.150
     1.196    36.984     0.150
     1.240    22.617     0.150
     1.240    39.281     0.150
     1.275    22.453     0.150
     1.275    40.359     0.150
     1.330    24.516     0.150
     1.330    41.906     0.150
     1.439    23.961     0.150
     1.439    24.070     0.150
     1.439    41.914     0.150
     1.443    25.141     0.150
     1.442    27.266     0.150
     1.514    27.266     0.150
     1.546    28.125     0.150
     1.585    27.961     0.150
     1.634    26.969     0.150
     1.634    47.703     0.150
     1.638    28.055     0.150
     1.731    31.289     0.150
     1.731    54.086     0.150
     1.825    31.031     0.150
     1.825    54.062     0.150
     1.820    31.031     0.150
     1.875    33.828     0.150
     1.875    58.602     0.150
     1.982    32.359     0.150
     1.982    61.836     0.150
     1.981    32.992     0.150
     1.981    62.273     0.150
     2.088    33.812     0.150
     2.184    39.219     0.150
     2.184    68.164     0.150
     2.218    37.086     0.150
     2.399    39.039     0.150
     2.399    75.312     0.150
     2.588    41.461     0.150
     2.588    79.609     0.150
     2.589    41.469     0.150
     2.589    79.289     0.150
     2.546    47.883     0.150
     2.546    78.492     0.150
     2.662    42.109     0.150
     2.689    43.203     0.150
     2.724    42.148     0.150
     2.724    43.273     0.150
     2.923    47.656     0.150
     2.979    55.906     0.150
     3.106    48.742     0.150
     3.183    50.609     0.150
     3.221    50.797     0.150
     3.438    53.031     0.150
     3.445    54.344     0.150
     3.445    54.227     0.150
     3.566    66.836     0.150
     4.270    64.516     0.150
     4.381    66.875     0.150
     4.499    68.539     0.150
     4.600    70.320     0.150
     4.597    69.898     0.150
     4.656    71.281     0.150
     4.656    71.484     0.150
     4.765    73.547     0.150
     4.918    72.516     0.150
     4.890    73.547     0.150
     4.925    73.781     0.150
     5.110    78.305     0.150
     5.141    78.367     0.150
     5.141   164.680     0.150
     5.141    79.086     0.150
     5.141   164.680     0.150
     5.190    78.930     0.150
     5.383    80.109     0.150
     5.448    82.234     0.150
     5.502    81.516     0.150
     5.537    80.531     0.150
     5.546   102.398     0.150
     5.710    84.930     0.150
     5.696    84.359     0.150
     5.917    88.094     0.150
     6.046    89.336     0.150
     6.087    90.398     0.150
     6.127    93.578     0.150
     7.349   106.883     0.150
     7.483   108.320     0.150
     8.207   119.656     0.150
     9.516   136.648     0.150
    10.725   158.375     0.150
    11.688   167.891     0.150
    29.161   360.867     0.150
     0.187     4.029     0.150
     0.218     5.509     0.150
     0.323     6.420     0.150
     0.323    10.872     0.150
     0.318     7.079     0.150
     0.451     8.723     0.150
     0.451    14.765     0.150
     0.458     9.049     0.150
     0.514    10.419     0.150
     0.663    11.599     0.150
     0.663    20.226     0.150
     0.633    11.799     0.150
     0.714    13.335     0.150
     0.714    22.943     0.150
     0.769    14.390     0.150
     0.769    25.272     0.150
     0.825    14.969     0.150
     0.825    15.307     0.150
     0.825    27.133     0.150
     0.851    15.915     0.150
     0.851    28.052     0.150
     0.964    31.849     0.150
     1.008    18.395     0.150
     1.008    32.041     0.150
     1.039    19.579     0.150
     1.039    18.189     0.150
     1.039    32.468     0.150
     1.055    18.399     0.150
     1.312    22.689     0.150
     1.312    40.567     0.150
     1.394    23.964     0.150
     1.599    27.949     0.150
     1.563    26.261     0.150
     1.622    49.697     0.150
     1.744    29.040     0.150
     1.898    34.659     0.150
     2.276    38.029     0.150
     2.287    39.559     0.150
     2.308    39.419     0.150
     2.350    39.309     0.150
     2.371    72.597     0.150
     2.507    78.038     0.150
     2.664    48.973     0.150
     2.593    80.741     0.150
     2.733    51.404     0.150
     3.299    52.629     0.150
     3.405    65.444     0.150
     3.408    54.469     0.150
     3.468    55.049     0.150
     3.657    56.549     0.150
     4.150    62.839     0.150
     4.175    64.069     0.150
     4.198    64.539     0.150
     4.246    64.689     0.150
     4.417    67.639     0.150
     4.822    73.259     0.150
     4.997    77.349     0.150
     5.120    76.769     0.150
     5.212    78.409     0.150
     5.488    82.969     0.150
     5.966    89.879     0.150
     7.040   103.609     0.150
     7.167   106.159     0.150
     7.311   108.449     0.150
     7.387   108.459     0.150
     7.392   108.359     0.150
     7.392   108.379     0.150
     7.395   108.559     0.150
     7.404   108.669     0.150
     7.411   109.729     0.150
     7.423   108.959     0.150
     7.433   109.409     0.150
     7.432   108.779     0.150
     7.436   109.449     0.150
     7.451   109.329     0.150
     7.473   109.479     0.150
     7.471   109.779     0.150
     7.494   109.919     0.150
     7.505   109.919     0.150
     7.529   110.709     0.150
     7.518   110.479     0.150
     7.565   110.609     0.150
     7.657   111.859     0.150
     7.676   111.859     0.150
     7.772   112.949     0.150
     9.155   132.549     0.150
    13.929   198.299     0.150
    14.036   199.179     0.150
    14.210   211.309     0.150
    27.048   343.029     0.150
     0.341     6.168     0.150
     0.442     8.457     0.150
     0.442    14.668     0.150
     0.703    13.109     0.150
     0.703    22.742     0.150
     0.692    13.980     0.150
     0.692    24.004     0.150
     0.684    25.156     0.150
     0.684    14.246     0.150
     0.747    15.203     0.150
     0.747    27.008     0.150
     0.987    18.336     0.150
     0.987    33.016     0.150
     1.003    18.449     0.150
     1.003    32.250     0.150
     1.119    19.508     0.150
     1.119    19.281     0.150
     1.211    22.137     0.150
     1.211    22.027     0.150
     1.256    22.785     0.150
     1.385    25.906     0.150
     1.499    27.422     0.150
     1.499    48.914     0.150
     1.736    28.676     0.150
     1.676    50.695     0.150
     1.749    29.824     0.150
     1.749    54.953     0.150
     1.865    33.406     0.150
     1.860    31.949     0.150
     2.146    37.238     0.150
     2.198    38.707     0.150
     2.375    39.195     0.150
     2.241    41.230     0.150
     2.376    39.918     0.150
     2.457    45.797     0.150
     2.647    50.836     0.150
     2.812    48.176     0.150
     3.250    53.438     0.150
     3.276    53.516     0.150
     3.353    55.578     0.150
     3.753    59.188     0.150
     3.681    58.496     0.150
     4.285    65.168     0.150
     4.242    64.059     0.150
     4.229    65.578     0.150
     4.245    65.355     0.150
     4.679    71.648     0.150
     4.817    73.766     0.150
     4.973    75.188     0.150
     5.302    80.918     0.150
     5.458    83.988     0.150
     5.560    85.578     0.150
     5.540    84.879     0.150
     5.540    84.883     0.150
     5.540   176.707     0.150
     5.789    84.406     0.150
     5.948    89.496     0.150
     7.458   235.336     0.150
     7.876   244.078     0.150
    10.645   156.508     0.150
    11.050   157.562     0.150
     0.323     6.523     0.150
     0.323    10.688     0.150
     0.463     9.453     0.150
     0.447     8.992     0.150
     0.485     9.750     0.150
     0.443     8.797     0.150
     0.443    14.992     0.150
     0.495    10.203     0.150
     0.575    10.992     0.150
     0.593    11.070     0.150
     0.636    12.000     0.150
     0.709    12.734     0.150
     0.709    12.953     0.150
     0.709    22.438     0.150
     0.708    13.391     0.150
     0.708    23.102     0.150
     0.734    14.375     0.150
     0.734    24.805     0.150
     0.742    14.102     0.150
     0.742    24.500     0.150
     0.778    14.484     0.150
     0.778    14.680     0.150
     0.778    25.914     0.150
     0.868    13.852     0.150
     0.868    26.883     0.150
     0.815    15.625     0.150
     0.815    27.117     0.150
     1.004    18.773     0.150
     1.004    32.922     0.150
     1.031    18.227     0.150
     1.031    18.453     0.150
     1.031    32.727     0.150
     1.064    18.641     0.150
     1.064    34.016     0.150
     1.069    18.930     0.150
     1.203    20.977     0.150
     1.263    22.156     0.150
     1.263    38.836     0.150
     1.263    22.281     0.150
     1.263    39.664     0.150
     1.278    22.031     0.150
     1.278    39.461     0.150
     1.278    22.164     0.150
     1.348    22.984     0.150
     1.541    26.055     0.150
     1.644    26.656     0.150
     1.639    29.336     0.150
     1.639    48.555     0.150
     1.687    27.711     0.150
     1.886    32.492     0.150
     1.954    32.047     0.150
     2.193    35.242     0.150
     2.194    35.664     0.150
     2.240    37.945     0.150
     2.271    36.250     0.150
     2.309    36.656     0.150
     2.315    38.242     0.150
     2.328    41.977     0.150
     2.358    38.266     0.150
     2.452    38.641     0.150
     2.460    44.227     0.150
     2.548    45.891     0.150
     2.548    79.766     0.150
     2.710    41.641     0.150
     2.704    51.195     0.150
     2.800    53.414     0.150
     2.906    47.820     0.150
     3.197    49.055     0.150
     3.254    50.891     0.150
     3.282    51.906     0.150
     3.364    51.305     0.150
     3.373    64.359     0.150
     3.416    65.047     0.150
     3.430    54.203     0.150
     3.688    56.453     0.150
     3.734    58.844     0.150
     3.734    57.648     0.150
     3.770    71.695     0.150
     3.834    73.039     0.150
     4.195    63.070     0.150
     4.195    63.531     0.150
     4.195   118.203     0.150
     4.197    64.570     0.150
     4.197    65.023     0.150
     4.208    64.375     0.150
     4.245    65.156     0.150
     4.420    67.852     0.150
     4.686    71.562     0.150
     4.820    74.055     0.150
     4.905    73.844     0.150
     5.000    75.281     0.150
     5.098    76.305     0.150
     5.098    96.547     0.150
     5.153    77.859     0.150
     5.204    79.453     0.150
     5.241    79.281     0.150
     5.241    97.742     0.150
     5.478    82.773     0.150
     5.556    83.070     0.150
     5.611   176.906     0.150
     5.697    83.492     0.150
     5.951    88.391     0.150
     5.965    87.891     0.150
     6.130    91.102     0.150
     6.646    96.320     0.150
     6.656    98.820     0.150
     7.060   105.000     0.150
     7.170   106.664     0.150
     7.171   105.023     0.150
     7.186   106.336     0.150
     7.282   106.844     0.150
     7.303   137.883     0.150
     7.369   108.922     0.150
     7.401   110.242     0.150
     7.407   107.664     0.150
     7.406   109.680     0.150
     7.424   110.000     0.150
     7.436   108.391     0.150
     7.445   111.164     0.150
     7.447   108.852     0.150
     7.465   111.031     0.150
     7.484   110.445     0.150
     7.488   112.344     0.150
     7.545   110.477     0.150
     7.567   111.125     0.150
     7.578   113.250     0.150
     7.670   112.375     0.150
     7.690   112.430     0.150
     7.806   117.375     0.150
     7.949   119.977     0.150
     8.077   117.766     0.150
     8.804   125.977     0.150
    10.160   146.336     0.150
    10.649   153.281     0.150
    10.649   157.734     0.150
    10.958   157.914     0.150
    10.958   157.906     0.150
    21.138   285.602     0.150
    27.112   342.891     0.150
     0.265     5.594     0.150
     0.265     9.369     0.150
     0.265     5.432     0.150
     0.460     9.043     0.150
     0.460    15.133     0.150
     0.641    11.912     0.150
     0.641    20.715     0.150
     0.711    13.053     0.150
     0.711    22.223     0.150
     0.739    13.961     0.150
     0.739    23.725     0.150
     0.717    13.496     0.150
     0.717    23.518     0.150
     0.757    13.773     0.150
     0.757    23.561     0.150
     0.724    13.883     0.150
     0.724    23.465     0.150
     0.839    15.471     0.150
     0.839    26.822     0.150
     0.947    17.012     0.150
     0.947    29.182     0.150
     1.009    19.088     0.150
     1.009    32.260     0.150
     1.062    19.354     0.150
     1.062    32.822     0.150
     1.312    22.547     0.150
     1.312    40.316     0.150
     1.345    22.271     0.150
     1.345    22.143     0.150
     1.377    24.014     0.150
     1.377    42.629     0.150
     1.474    25.213     0.150
     1.474    46.826     0.150
     1.552    26.203     0.150
     1.552    48.635     0.150
     1.609    26.387     0.150
     1.609    26.223     0.150
     1.630    28.141     0.150
     1.630    51.055     0.150
     1.638    28.713     0.150
     1.695    28.334     0.150
     1.704    29.463     0.150
     1.847    30.445     0.150
     1.847    54.107     0.150
     1.851    32.980     0.150
     1.851    57.174     0.150
     1.974    32.578     0.150
     1.974    61.891     0.150
     2.023    36.230     0.150
     2.023    62.770     0.150
     2.038    63.199     0.150
     2.099    64.555     0.150
     2.114    38.887     0.150
     2.279    35.043     0.150
     2.311    40.930     0.150
     2.311    39.002     0.150
     2.353    40.992     0.150
     2.430    43.143     0.150
     2.430    74.793     0.150
     2.431    41.922     0.150
     2.543    40.369     0.150
     2.627    41.529     0.150
     2.627    73.037     0.150
     2.627    41.652     0.150
     2.686    47.721     0.150
     2.686    82.350     0.150
     2.710    42.623     0.150
     2.847    44.693     0.150
     2.884    44.793     0.150
     2.876    47.592     0.150
     3.081    50.773     0.150
     3.325    49.320     0.150
     3.304    51.893     0.150
     3.567    55.020     0.150
     3.590    55.156     0.150
     4.674    70.867     0.150
     4.680    71.262     0.150
     4.832    70.594     0.150
     4.832    70.473     0.150
     5.018    75.553     0.150
     5.269    80.312     0.150
     5.267    79.842     0.150
     5.480    81.672     0.150
     6.975   106.203     0.150
     7.280   105.273     0.150
     7.280   106.432     0.150
     7.513   113.113     0.150
     7.884   114.783     0.150
     8.170   118.973     0.150
     8.938   132.992     0.150
     9.440   135.883     0.150
    11.590   167.922     0.150
    13.453   196.453     0.150
     0.096     3.190     0.150
     0.096     5.261     0.150
     0.127     3.521     0.150
     0.127     5.860     0.150
     0.118     3.641     0.150
     0.196     4.641     0.150
     0.196     7.730     0.150
     0.268     5.650     0.150
     0.268     9.993     0.150
     0.268     5.971     0.150
     0.268    10.121     0.150
     0.292     5.730     0.150
     0.292     9.681     0.150
     0.254     5.871     0.150
     0.254     9.961     0.150
     0.315     6.391     0.150
     0.315    10.721     0.150
     0.309     6.661     0.150
     0.317     6.811     0.150
     0.317    11.591     0.150
     0.331     7.161     0.150
     0.331    11.561     0.150
     0.331     6.961     0.150
     0.331    11.730     0.150
     0.363     7.381     0.150
     0.363    12.400     0.150
     0.378     7.551     0.150
     0.378    13.061     0.150
     0.399     7.900     0.150
     0.399    13.431     0.150
     0.409     8.131     0.150
     0.409    13.551     0.150
     0.372     7.860     0.150
     0.376     7.621     0.150
     0.376    12.951     0.150
     0.400     8.301     0.150
     0.400    13.971     0.150
     0.390     8.391     0.150
     0.390    13.891     0.150
     0.399     8.561     0.150
     0.399    14.541     0.150
     0.443     8.690     0.150
     0.443    14.451     0.150
     0.460     9.131     0.150
     0.460    15.631     0.150
     0.478     8.630     0.150
     0.478     8.900     0.150
     0.478    14.911     0.150
     0.481     8.911     0.150
     0.481    14.681     0.150
     0.453     9.221     0.150
     0.461     8.986     0.150
     0.461    15.618     0.150
     0.461     9.190     0.150
     0.499     9.591     0.150
     0.499    16.360     0.150
     0.485     9.661     0.150
     0.529     9.741     0.150
     0.529    16.251     0.150
     0.520    10.171     0.150
     0.520    17.411     0.150
     0.562    10.751     0.150
     0.562    17.980     0.150
     0.558    10.841     0.150
     0.583    11.521     0.150
     0.588    11.521     0.150
     0.611    12.081     0.150
     0.611    20.711     0.150
     0.665    12.681     0.150
     0.665    21.400     0.150
     0.680    12.501     0.150
     0.680    21.501     0.150
     0.714    13.501     0.150
     0.714    22.261     0.150
     0.716    13.201     0.150
     0.716    22.230     0.150
     0.708    13.314     0.150
     0.708    22.874     0.150
     0.715    13.690     0.150
     0.776    13.860     0.150
     0.776    24.261     0.150
     0.742    14.181     0.150
     0.742    24.301     0.150
     0.757    14.871     0.150
     0.804    14.421     0.150
     0.804    24.780     0.150
     0.783    15.921     0.150
     0.842    15.721     0.150
     0.842    26.661     0.150
     0.834    15.381     0.150
     0.807    15.381     0.150
     0.807    25.911     0.150
     0.844    15.678     0.150
     0.844    26.304     0.150
     0.820    15.440     0.150
     0.830    16.771     0.150
     0.830    29.201     0.150
     0.833    15.991     0.150
     0.879    16.301     0.150
     0.918    16.443     0.150
     0.918    28.414     0.150
     0.918    16.570     0.150
     0.918    16.451     0.150
     0.918    28.190     0.150
     0.936    29.241     0.150
     0.967    17.951     0.150
     0.967    30.581     0.150
     0.975    18.541     0.150
     1.024    18.880     0.150
     1.024    31.960     0.150
     1.024    31.631     0.150
     0.985    18.211     0.150
     0.985    31.591     0.150
     1.002    18.811     0.150
     1.013    18.511     0.150
     1.013    31.871     0.150
     1.029    18.881     0.150
     1.029    32.461     0.150
     1.066    18.661     0.150
     1.066    32.480     0.150
     1.090    19.881     0.150
     1.063    19.511     0.150
     1.063    33.221     0.150
     1.069    20.256     0.150
     1.069    34.627     0.150
     1.094    20.354     0.150
     1.094    34.802     0.150
     1.094    34.621     0.150
     1.151    34.991     0.150
     1.151    20.421     0.150
     1.124    20.911     0.150
     1.124    35.320     0.150
     1.156    21.461     0.150
     1.156    36.832     0.150
     1.184    21.331     0.150
     1.201    37.900     0.150
     1.207    22.116     0.150
     1.207    38.312     0.150
     1.271    38.681     0.150
     1.271    22.440     0.150
     1.258    22.461     0.150
     1.259    22.550     0.150
     1.259    39.880     0.150
     1.285    39.617     0.150
     1.285    39.221     0.150
     1.291    22.561     0.150
     1.310    40.931     0.150
     1.361    24.667     0.150
     1.361    42.863     0.150
     1.418    26.341     0.150
     1.470    25.484     0.150
     1.470    46.063     0.150
     1.502    26.655     0.150
     1.502    45.614     0.150
     1.502    26.860     0.150
     1.544    26.678     0.150
     1.569    26.183     0.150
     1.569    49.046     0.150
     1.653    28.947     0.150
     1.653    50.645     0.150
     1.653    29.131     0.150
     1.768    30.446     0.150
     1.849    31.163     0.150
     1.849    57.914     0.150
     1.949    32.851     0.150
     1.954    31.131     0.150
     1.954    55.593     0.150
     1.954    31.411     0.150
     1.994    32.681     0.150
     2.017    33.606     0.150
     2.017    62.940     0.150
     2.182    34.841     0.150
     2.182    67.699     0.150
     2.171    35.882     0.150
     2.193    35.422     0.150
     2.213    69.361     0.150
     2.224    36.563     0.150
     2.224    69.441     0.150
     2.224    36.701     0.150
     2.287    37.677     0.150
     2.779    44.825     0.150
     2.869    45.211     0.150
     2.886    44.110     0.150
     3.036    47.820     0.150
     3.082    48.421     0.150
     3.195    50.773     0.150
     3.195    50.061     0.150
     3.201    51.379     0.150
     3.473    51.121     0.150
     3.305    51.791     0.150
     3.925    59.811     0.150
     3.965    59.171     0.150
     3.965    59.471     0.150
     4.425    66.780     0.150
     4.606    69.581     0.150
     4.640    69.671     0.150
     4.653    69.811     0.150
     4.672    70.201     0.150
     4.675    70.320     0.150
     4.715    71.030     0.150
     4.738    71.411     0.150
     4.761    71.400     0.150
     4.930    74.850     0.150
     4.930    73.511     0.150
     4.973    74.591     0.150
     5.044    75.521     0.150
     5.261    78.201     0.150
     5.314    79.221     0.150
     5.415    79.040     0.150
     5.482    81.561     0.150
     5.680    84.070     0.150
     6.130    89.637     0.150
     6.130    90.201     0.150
     7.817   113.237     0.150
     9.994   142.776     0.150
     0.156     3.551     0.150
     0.190     4.781     0.150
     0.210     4.432     0.150
     0.291     5.816     0.150
     0.291    10.436     0.150
     0.294     6.102     0.150
     0.323     7.051     0.150
     0.354     7.391     0.150
     0.362     7.322     0.150
     0.411     8.582     0.150
     0.426     8.371     0.150
     0.443     9.051     0.150
     0.481     9.426     0.150
     0.481    15.779     0.150
     0.481    16.771     0.150
     0.515    10.191     0.150
     0.527    10.152     0.150
     0.530    10.561     0.150
     0.536    10.662     0.150
     0.549    10.352     0.150
     0.549    18.551     0.150
     0.558    11.111     0.150
     0.579    10.721     0.150
     0.579    19.121     0.150
     0.577    11.672     0.150
     0.601    11.232     0.150
     0.676    12.334     0.150
     0.676    21.467     0.150
     0.677    12.941     0.150
     0.682    12.789     0.150
     0.682    22.660     0.150
     0.682    12.891     0.150
     0.696    12.941     0.150
     0.705    13.592     0.150
     0.705    23.861     0.150
     0.741    13.996     0.150
     0.741    24.326     0.150
     0.783    14.432     0.150
     0.815    14.891     0.150
     0.818    15.291     0.150
     0.821    15.342     0.150
     0.821    27.516     0.150
     0.821    26.812     0.150
     0.868    16.234     0.150
     0.868    29.459     0.150
     0.866    16.172     0.150
     0.880    16.461     0.150
     0.909    17.021     0.150
     0.928    17.602     0.150
     0.930    17.221     0.150
     0.981    17.912     0.150
     0.981   518.051     0.150
     0.996    17.541     0.150
     0.998    17.842     0.150
     0.998   517.992     0.150
     1.010    18.531     0.150
     1.025    18.291     0.150
     1.025    33.061     0.150
     1.025   518.262     0.150
     1.040    18.963     0.150
     1.040    32.201     0.150
     1.041    18.941     0.150
     1.057    19.152     0.150
     1.069    19.002     0.150
     1.088    19.332     0.150
     1.088   519.451     0.150
     1.094    19.941     0.150
     1.102    18.711     0.150
     1.130    19.941     0.150
     1.130    35.641     0.150
     1.141    20.131     0.150
     1.200    21.152     0.150
     1.205    21.162     0.150
     1.205    37.752     0.150
     1.217    21.211     0.150
     1.217    39.332     0.150
     1.245    22.242     0.150
     1.261    22.221     0.150
     1.264    21.971     0.150
     1.270    22.162     0.150
     1.288    22.316     0.150
     1.288    39.160     0.150
     1.288    22.322     0.150
     1.354    23.361     0.150
     1.383    23.674     0.150
     1.383    43.080     0.150
     1.505    26.441     0.150
     1.524    25.951     0.150
     1.524    26.512     0.150
     1.571    27.232     0.150
     1.584    26.742     0.150
     1.589    26.598     0.150
     1.589    50.539     0.150
     1.589    27.902     0.150
     1.610    27.012     0.150
     1.654    27.602     0.150
     1.654    51.691     0.150
     1.739    28.594     0.150
     1.776    29.416     0.150
     1.998    32.512     0.150
     2.008    33.471     0.150
     2.034    33.029     0.150
     2.144    35.551     0.150
     2.418    40.922     0.150
     2.282    37.842     0.150
     2.324    36.768     0.150
     2.354    37.041     0.150
     2.355    40.461     0.150
     2.382    38.822     0.150
     2.444    37.621     0.150
     2.470    39.010     0.150
     2.596    40.613     0.150
     2.669    40.965     0.150
     2.669    41.391     0.150
     2.755    51.848     0.150
     2.852    44.264     0.150
     2.949    45.496     0.150
     3.250    49.660     0.150
     3.277    51.482     0.150
     3.291    62.775     0.150
     3.327    52.172     0.150
     3.414    51.766     0.150
     3.425    65.586     0.150
     3.450    65.859     0.150
     3.632    69.064     0.150
     3.684    57.691     0.150
     3.784    71.523     0.150
     3.784    59.582     0.150
     3.822    72.359     0.150
     3.875    73.508     0.150
     4.058    60.764     0.150
     4.164    78.717     0.150
     4.164    63.391     0.150
     4.205    79.152     0.150
     4.205    64.971     0.150
     4.230    65.721     0.150
     4.230    65.422     0.150
     4.278    64.922     0.150
     4.400    83.229     0.150
     4.450    68.412     0.150
     4.590    71.402     0.150
     4.722    72.172     0.150
     4.854    74.551     0.150
     4.898    73.941     0.150
     5.029    78.311     0.150
     5.146    75.686     0.150
     5.146    78.131     0.150
     5.229    80.682     0.150
     5.239    79.471     0.150
     5.256    80.182     0.150
     5.518    81.982     0.150
     5.587    86.371     0.150
     5.664    84.447     0.150
     5.977    91.352     0.150
     5.986    87.652     0.150
     5.997    91.492     0.150
     6.621    96.137     0.150
     6.621    97.521     0.150
     7.268   106.641     0.150
     7.468   111.861     0.150
     7.503   112.701     0.150
     7.537   112.912     0.150
     7.545   110.416     0.150
     7.545   235.447     0.150
     7.798   115.242     0.150
     7.798   243.492     0.150
     7.798   115.891     0.150
     8.776   127.721     0.150
    10.683   156.471     0.150
    10.819   156.381     0.150
    10.922   157.096     0.150
    15.100   216.881     0.150
    22.415   299.621     0.150
    36.634   427.646     0.150
    36.922   430.971     0.150
     0.074     1.769     0.150
     0.074     2.980     0.150
     0.174     3.464     0.150
     0.279     6.004     0.150
     0.279    10.574     0.150
     0.287     6.134     0.150
     0.287    10.374     0.150
     0.313     6.354     0.150
     0.327    10.984     0.150
     0.397     7.954     0.150
     0.397    13.454     0.150
     0.404     7.874     0.150
     0.404    13.224     0.150
     0.451     8.894     0.150
     0.451    15.124     0.150
     0.454     9.224     0.150
     0.454    16.114     0.150
     0.477     9.144     0.150
     0.477    15.624     0.150
     0.479     8.929     0.150
     0.479     9.213     0.150
     0.479    15.614     0.150
     0.555    11.038     0.150
     0.555    18.487     0.150
     0.555    18.754     0.150
     0.596    11.354     0.150
     0.596    19.594     0.150
     0.622    12.224     0.150
     0.615    11.894     0.150
     0.615    20.334     0.150
     0.618    11.984     0.150
     0.618    20.704     0.150
     0.646    12.414     0.150
     0.646    21.024     0.150
     0.652    12.764     0.150
     0.652    22.254     0.150
     0.688    13.264     0.150
     0.688    22.434     0.150
     0.693    13.264     0.150
     0.693    22.664     0.150
     0.736    14.194     0.150
     0.736    23.884     0.150
     0.770    14.498     0.150
     0.770    24.827     0.150
     0.770    25.074     0.150
     0.761    14.644     0.150
     0.761    25.124     0.150
     0.782    14.894     0.150
     0.782    25.674     0.150
     0.789    15.164     0.150
     0.808    15.500     0.150
     0.808    26.405     0.150
     0.832    16.224     0.150
     0.840    15.794     0.150
     0.840    27.144     0.150
     0.862    16.264     0.150
     0.862    27.664     0.150
     0.869    16.794     0.150
     0.886    16.754     0.150
     0.904    16.843     0.150
     0.894    16.974     0.150
     0.894    29.134     0.150
     0.899    16.864     0.150
     0.899    28.704     0.150
     0.903    17.054     0.150
     0.903    16.944     0.150
     0.902    17.114     0.150
     0.902    29.154     0.150
     0.929    17.339     0.150
     0.929    30.259     0.150
     0.940    17.634     0.150
     0.940    30.094     0.150
     1.004    18.294     0.150
     1.004    31.694     0.150
     1.004    32.164     0.150
     1.004    18.774     0.150
     1.025    19.079     0.150
     1.025    33.163     0.150
     1.025    33.284     0.150
     1.044    19.014     0.150
     1.046    19.184     0.150
     1.054    20.224     0.150
     1.078    19.894     0.150
     1.078    34.444     0.150
     1.088    20.282     0.150
     1.088    34.658     0.150
     1.106    20.314     0.150
     1.118    20.634     0.150
     1.160    21.684     0.150
     1.191    21.784     0.150
     1.191    37.464     0.150
     1.196    21.864     0.150
     1.196    37.504     0.150
     1.209    22.104     0.150
     1.202    21.904     0.150
     1.202    38.094     0.150
     1.234    39.734     0.150
     1.234    24.194     0.150
     1.245    23.314     0.150
     1.268    22.634     0.150
     1.266    23.004     0.150
     1.274    23.474     0.150
     1.280    22.617     0.150
     1.284    22.364     0.150
     1.315    24.864     0.150
     1.327    23.924     0.150
     1.336    23.674     0.150
     1.336    42.752     0.150
     1.359    24.094     0.150
     1.375    24.489     0.150
     1.375    42.678     0.150
     1.384    25.082     0.150
     1.384    44.024     0.150
     1.384    25.464     0.150
     1.416    25.074     0.150
     1.435    25.271     0.150
     1.435    45.408     0.150
     1.443    26.574     0.150
     1.478    26.074     0.150
     1.483    26.674     0.150
     1.503    26.414     0.150
     1.575    27.664     0.150
     1.611    27.403     0.150
     1.611    48.687     0.150
     1.629    29.484     0.150
     1.707    30.794     0.150
     1.804    31.924     0.150
     1.878    31.555     0.150
     1.878    58.755     0.150
     1.896    33.781     0.150
     1.923    32.364     0.150
     1.937    34.860     0.150
     1.937    60.711     0.150
     1.973    32.972     0.150
     1.973    62.404     0.150
     2.057    34.093     0.150
     2.057    33.987     0.150
     2.057    64.003     0.150
     2.120    35.174     0.150
     2.126    36.484     0.150
     2.331    41.789     0.150
     2.331    39.384     0.150
     2.435    39.471     0.150
     2.435    76.058     0.150
     2.600    80.943     0.150
     2.649    50.301     0.150
     2.649    82.064     0.150
     2.649    43.644     0.150
     2.665    43.164     0.150
     2.919    47.584     0.150
     3.015    48.394     0.150
     3.245    51.604     0.150
     3.349    51.314     0.150
     3.558    56.134     0.150
     3.823    59.654     0.150
     3.906    61.004     0.150
     4.041    62.744     0.150
     4.149    64.334     0.150
     4.212    65.054     0.150
     4.245    65.434     0.150
     4.395    67.594     0.150
     4.422    67.854     0.150
     4.690    69.437     0.150
     4.752    72.234     0.150
     4.808    73.204     0.150
     4.849    73.977     0.150
     4.849    89.809     0.150
     4.849   153.559     0.150
     4.849    73.724     0.150
     4.917    74.694     0.150
     5.100    77.164     0.150
     5.152    77.934     0.150
     5.239    78.084     0.150
     5.373    80.844     0.150
     5.894    88.124     0.150
     6.829   101.784     0.150
     6.829   127.034     0.150
     6.829   214.831     0.150
     6.829   100.944     0.150
     6.976   104.564     0.150
     7.049   103.559     0.150
     7.049   103.864     0.150
     7.183   105.134     0.150
     7.203   105.964     0.150
     7.304   107.474     0.150
     7.974   117.179     0.150
     7.974   146.404     0.150
     7.974   248.352     0.150
     7.974   116.564     0.150
     9.235   133.684     0.150
    10.176   149.871     0.150
    11.490   165.784     0.150
    11.490   164.964     0.150
     0.085     1.598     0.150
     0.186     3.660     0.150
     0.267     5.832     0.150
     0.267    10.410     0.150
     0.277     5.930     0.150
     0.277    10.230     0.150
     0.312    11.199     0.150
     0.331     6.660     0.150
     0.331    11.602     0.150
     0.391     7.781     0.150
     0.391    13.242     0.150
     0.395     7.801     0.150
     0.395    13.332     0.150
     0.453     9.402     0.150
     0.453    15.949     0.150
     0.459     9.199     0.150
     0.459    15.520     0.150
     0.468     9.082     0.150
     0.468    15.672     0.150
     0.468     8.609     0.150
     0.469     9.445     0.150
     0.469     9.109     0.150
     0.469    15.801     0.150
     0.469     8.930     0.150
     0.551    10.941     0.150
     0.551    18.910     0.150
     0.589    11.422     0.150
     0.589    19.461     0.150
     0.606    11.832     0.150
     0.606    20.223     0.150
     0.610    12.141     0.150
     0.610    20.531     0.150
     0.613    12.051     0.150
     0.636    12.312     0.150
     0.636    20.973     0.150
     0.636    21.129     0.150
     0.640    12.902     0.150
     0.640    22.512     0.150
     0.679    13.180     0.150
     0.679    22.500     0.150
     0.685    13.211     0.150
     0.685    22.473     0.150
     0.725    13.980     0.150
     0.725    24.012     0.150
     0.749    14.582     0.150
     0.749    25.402     0.150
     0.775    14.602     0.150
     0.775    25.191     0.150
     0.775    25.348     0.150
     0.776    14.879     0.150
     0.776    25.340     0.150
     0.787    15.402     0.150
     0.787    26.570     0.150
     0.811    15.781     0.150
     0.811    27.039     0.150
     0.821    16.270     0.150
     0.821    28.602     0.150
     0.835    15.902     0.150
     0.835    26.973     0.150
     0.856    16.320     0.150
     0.856    27.500     0.150
     0.872    16.930     0.150
     0.883    16.910     0.150
     0.883    29.039     0.150
     0.897    16.973     0.150
     0.893    17.051     0.150
     0.893    28.621     0.150
     0.893    17.129     0.150
     0.893    29.082     0.150
     0.902    17.289     0.150
     0.916    17.090     0.150
     0.916    16.934     0.150
     0.941    17.750     0.150
     0.938    17.789     0.150
     0.938    30.379     0.150
     0.992    18.289     0.150
     0.992    18.156     0.150
     0.992    31.391     0.150
     1.019    19.211     0.150
     1.019    32.531     0.150
     1.032    18.930     0.150
     1.034    19.082     0.150
     1.054    20.090     0.150
     1.076    20.090     0.150
     1.076    20.211     0.150
     1.076    34.512     0.150
     1.076    20.012     0.150
     1.076    34.789     0.150
     1.104    20.461     0.150
     1.117    20.891     0.150
     1.117    35.629     0.150
     1.162    21.922     0.150
     1.181    21.879     0.150
     1.181    37.641     0.150
     1.192    37.891     0.150
     1.192    22.039     0.150
     1.192    37.473     0.150
     1.221    22.352     0.150
     1.231    22.410     0.150
     1.231    38.973     0.150
     1.242    23.230     0.150
     1.242    22.918     0.150
     1.242    40.109     0.150
     1.249    23.473     0.150
     1.249    39.562     0.150
     1.250    23.609     0.150
     1.257    22.832     0.150
     1.257    39.340     0.150
     1.268    22.852     0.150
     1.268    22.520     0.150
     1.273    40.562     0.150
     1.294    22.750     0.150
     1.315    24.172     0.150
     1.319    25.121     0.150
     1.330    23.492     0.150
     1.330    43.008     0.150
     1.347    24.141     0.150
     1.364    24.680     0.150
     1.364    42.914     0.150
     1.371    25.723     0.150
     1.385    25.691     0.150
     1.385    25.336     0.150
     1.385    44.352     0.150
     1.405    24.980     0.150
     1.431    26.641     0.150
     1.444    25.422     0.150
     1.444    45.961     0.150
     1.483    27.332     0.150
     1.515    26.641     0.150
     1.518    26.742     0.150
     1.518    48.695     0.150
     1.580    28.473     0.150
     1.610    28.121     0.150
     1.610    30.371     0.150
     1.616    29.660     0.150
     1.669    30.082     0.150
     1.688    29.352     0.150
     1.703    30.992     0.150
     1.707    31.191     0.150
     1.804    31.992     0.150
     1.883    59.105     0.150
     1.911    32.289     0.150
     1.940    33.320     0.150
     1.938    35.242     0.150
     1.938    61.203     0.150
     1.985    33.320     0.150
     1.985    62.781     0.150
     2.052    36.949     0.150
     2.065    34.395     0.150
     2.065    65.129     0.150
     2.128    35.051     0.150
     2.333    41.949     0.150
     2.333    42.297     0.150
     2.445    39.730     0.150
     2.445    76.652     0.150
     2.604    48.098     0.150
     2.630    42.438     0.150
     2.630    82.965     0.150
     2.656    42.711     0.150
     2.656    48.996     0.150
     2.656    83.406     0.150
     2.677    43.359     0.150
     3.027    48.652     0.150
     3.256    51.867     0.150
     3.343    51.281     0.150
     3.570    56.340     0.150
     3.834    59.832     0.150
     4.051    63.129     0.150
     4.224    65.531     0.150
     4.434    68.191     0.150
     4.434    67.949     0.150
     4.434    82.863     0.150
     4.455    69.980     0.150
     4.641    71.020     0.150
     4.688    69.602     0.150
     4.762    73.180     0.150
     4.818    73.820     0.150
     4.860    74.586     0.150
     4.860    90.152     0.150
     4.860   152.613     0.150
     4.860    73.801     0.150
     4.929    75.270     0.150
     5.077    77.660     0.150
     5.110    77.820     0.150
     5.384    81.820     0.150
     6.842   102.070     0.150
     6.842   128.270     0.150
     6.842   214.723     0.150
     6.984   221.723     0.150
     7.049   104.121     0.150
     7.978   248.973     0.150
     7.978   116.652     0.150
    10.188   150.152     0.150
    11.487   165.402     0.150
     0.252     5.067     0.150
     0.254     8.849     0.150
     0.236     4.908     0.150
     0.384     7.608     0.150
     0.518     9.639     0.150
     0.504    10.009     0.150
     0.564    10.488     0.150
     0.561    11.379     0.150
     0.516    10.059     0.150
     0.516     9.860     0.150
     0.516    17.488     0.150
     0.568    11.028     0.150
     0.542    10.549     0.150
     0.542    10.658     0.150
     0.563    10.948     0.150
     0.600    10.959     0.150
     0.641    11.998     0.150
     0.641    11.802     0.150
     0.641    20.797     0.150
     0.665    12.748     0.150
     0.648    12.288     0.150
     0.701    13.278     0.150
     0.701    22.858     0.150
     0.705    12.788     0.150
     0.703    12.698     0.150
     0.703    22.729     0.150
     0.703    22.148     0.150
     0.802    14.019     0.150
     0.773    14.028     0.150
     0.773    25.309     0.150
     0.804    14.868     0.150
     0.807    14.948     0.150
     0.807    26.724     0.150
     0.807    14.763     0.150
     0.807    26.071     0.150
     0.834    15.339     0.150
     0.834    27.089     0.150
     0.859    15.889     0.150
     0.890    16.488     0.150
     0.881    16.229     0.150
     0.881    16.099     0.150
     0.881    28.434     0.150
     0.908    16.658     0.150
     0.910    16.818     0.150
     0.984    31.028     0.150
     0.984    17.759     0.150
     0.999    31.669     0.150
     0.999    18.049     0.150
     0.990    17.788     0.150
     0.990    32.408     0.150
     0.990    17.669     0.150
     0.990    31.709     0.150
     0.997    17.688     0.150
     1.029    18.448     0.150
     1.094    19.209     0.150
     1.094    34.118     0.150
     1.090    19.139     0.150
     1.077    20.028     0.150
     1.077    35.509     0.150
     1.077    19.113     0.150
     1.077    33.790     0.150
     1.115    18.339     0.150
     1.111    20.908     0.150
     1.111    36.019     0.150
     1.165    20.229     0.150
     1.165    36.479     0.150
     1.182    20.419     0.150
     1.209    38.169     0.150
     1.250    21.488     0.150
     1.250    37.744     0.150
     1.250    21.528     0.150
     1.250    37.799     0.150
     1.232    21.089     0.150
     1.243    21.229     0.150
     1.252    21.368     0.150
     1.269    22.068     0.150
     1.321    22.519     0.150
     1.348    24.379     0.150
     1.360    22.919     0.150
     1.452    24.358     0.150
     1.549    26.549     0.150
     1.559    25.828     0.150
     1.565    25.929     0.150
     1.565    26.788     0.150
     1.635    25.578     0.150
     1.615    30.179     0.150
     1.696    31.229     0.150
     1.696    52.709     0.150
     1.696    52.149     0.150
     1.857    31.009     0.150
     1.984    32.101     0.150
     1.994    32.599     0.150
     2.020    36.599     0.150
     2.120    34.209     0.150
     2.158    34.898     0.150
     2.403    37.828     0.150
     2.265    36.919     0.150
     2.274    39.388     0.150
     2.325    41.311     0.150
     2.325    71.279     0.150
     2.337    38.669     0.150
     2.343    38.059     0.150
     2.423    40.129     0.150
     2.483    44.360     0.150
     2.589    40.229     0.150
     2.589    79.605     0.150
     2.686    40.309     0.150
     2.934    46.028     0.150
     3.246    50.639     0.150
     3.258    49.254     0.150
     3.357    51.879     0.150
     3.412    51.639     0.150
     3.412    51.176     0.150
     3.724    57.358     0.150
     3.806    57.898     0.150
     3.806    58.055     0.150
     4.191    61.969     0.150
     4.191    61.318     0.150
     4.247    65.038     0.150
     4.260    65.068     0.150
     4.272    65.738     0.150
     4.316    65.688     0.150
     4.489    68.389     0.150
     4.579    69.778     0.150
     4.759    72.398     0.150
     4.892    74.368     0.150
     4.937    73.898     0.150
     5.219    78.618     0.150
     5.280    79.599     0.150
     5.552    83.108     0.150
     5.685    82.709     0.150
     5.677    86.754     0.150
     5.677   180.604     0.150
     5.677    84.839     0.150
     5.927    89.578     0.150
     5.919    86.969     0.150
     6.149    92.129     0.150
     6.198    92.108     0.150
     6.492    96.979     0.150
     6.652    97.269     0.150
     6.652    96.394     0.150
     6.717    99.438     0.150
     6.911   102.669     0.150
     6.916   103.068     0.150
     7.186   106.469     0.150
     7.199   105.898     0.150
     7.377   109.158     0.150
     7.562   111.389     0.150
     7.572   112.174     0.150
     7.572   238.448     0.150
     7.836   114.248     0.150
     7.836   246.674     0.150
     7.836   113.979     0.150
    10.721   157.968     0.150
    10.721   153.809     0.150
    10.946   156.951     0.150
    10.946   156.438     0.150
    14.602   206.938     0.150
    15.124   219.973     0.150
    36.935   429.419     0.150
     0.108     2.750     0.150
     0.311     6.367     0.150
     0.311    11.250     0.150
     0.265     5.344     0.150
     0.265     5.031     0.150
     0.265     8.906     0.150
     0.387     7.680     0.150
     0.629    11.953     0.150
     0.629    20.500     0.150
     0.668    13.156     0.150
     0.615    11.125     0.150
     0.615    19.461     0.150
     0.792    25.680     0.150
     0.792    14.984     0.150
     0.828    15.102     0.150
     0.836    15.234     0.150
     0.836    26.461     0.150
     0.902    17.094     0.150
     1.059    18.969     0.150
     1.059    32.406     0.150
     1.048    18.602     0.150
     1.097    20.273     0.150
     1.002    18.586     0.150
     1.002    31.992     0.150
     1.051    18.914     0.150
     1.051    32.750     0.150
     1.008    17.703     0.150
     1.172    20.273     0.150
     1.172    35.133     0.150
     1.211    21.680     0.150
     1.233    21.844     0.150
     1.233    38.539     0.150
     1.158    20.812     0.150
     1.352    23.273     0.150
     1.415    24.266     0.150
     1.454    24.789     0.150
     1.454    24.672     0.150
     1.454    42.703     0.150
     1.407    24.672     0.150
     1.348    23.523     0.150
     1.348    23.172     0.150
     1.660    28.109     0.150
     1.658    52.617     0.150
     1.756    29.266     0.150
     1.932    30.172     0.150
     2.075    37.125     0.150
     2.014    32.484     0.150
     2.211    39.430     0.150
     2.211    68.883     0.150
     2.271    40.102     0.150
     2.159    67.867     0.150
     2.275    36.320     0.150
     2.738    43.289     0.150
     2.758    44.070     0.150
     2.936    45.953     0.150
     2.936    45.641     0.150
     3.059    46.336     0.150
     3.059    46.641     0.150
     3.188    50.141     0.150
     3.188    49.594     0.150
     3.617    55.281     0.150
     3.659    56.781     0.150
     3.810    58.805     0.150
     3.863    59.602     0.150
     3.988    60.852     0.150
     4.008    61.844     0.150
     4.226    64.742     0.150
     4.372    66.883     0.150
     4.407    64.594     0.150
     4.559    69.156     0.150
     4.595    71.109     0.150
     4.817    71.984     0.150
     4.852    73.055     0.150
     4.993    75.234     0.150
     5.038    75.516     0.150
     5.083    75.984     0.150
     5.083    93.805     0.150
     5.083   162.023     0.150
     5.083    77.445     0.150
     5.134    78.492     0.150
     5.131    77.281     0.150
     5.336    81.695     0.150
     5.594    84.531     0.150
     5.951    87.625     0.150
     6.780    98.953     0.150
     6.780    98.672     0.150
     6.774    99.227     0.150
     6.961   103.906     0.150
     6.961   219.602     0.150
     6.961   102.430     0.150
     7.105   103.953     0.150
     7.379   108.953     0.150
     7.573   111.883     0.150
     7.757   240.531     0.150
     8.963   128.484     0.150
    10.195   151.930     0.150
    11.204   160.633     0.150
    11.204   160.727     0.150
    11.204   159.711     0.150
     0.296     6.406     0.150
     0.296    11.004     0.150
     0.351     6.844     0.150
     0.351    11.762     0.150
     0.356    12.352     0.150
     0.356     7.324     0.150
     0.442     8.238     0.150
     0.442    14.723     0.150
     0.509     9.258     0.150
     0.509     9.461     0.150
     0.509    16.395     0.150
     0.517     9.387     0.150
     0.687    12.930     0.150
     0.687    22.195     0.150
     0.749    13.891     0.150
     0.749    23.777     0.150
     0.910    17.156     0.150
     0.910    29.953     0.150
     0.979    18.031     0.150
     0.979    31.266     0.150
     0.996    18.094     0.150
     1.089    18.883     0.150
     1.089    18.984     0.150
     1.089    33.145     0.150
     1.088    19.363     0.150
     1.189    20.988     0.150
     1.189    36.910     0.150
     1.225    21.781     0.150
     1.225    38.469     0.150
     1.242    21.082     0.150
     1.242    38.438     0.150
     1.297    22.504     0.150
     1.285    22.918     0.150
     1.285    40.164     0.150
     1.310    22.531     0.150
     1.310    40.457     0.150
     1.334    23.414     0.150
     1.372    22.582     0.150
     1.384    23.398     0.150
     1.384    42.691     0.150
     1.415    24.004     0.150
     1.459    25.113     0.150
     1.470    24.617     0.150
     1.468    24.129     0.150
     1.468    45.652     0.150
     1.524    26.102     0.150
     1.644    27.664     0.150
     1.644    27.883     0.150
     1.642    28.062     0.150
     1.693    28.227     0.150
     1.671    27.773     0.150
     1.671    52.457     0.150
     1.804    28.672     0.150
     1.956    31.371     0.150
     1.970    32.254     0.150
     1.994    32.621     0.150
     1.995    32.602     0.150
     2.043    32.273     0.150
     2.048    32.609     0.150
     2.102    34.324     0.150
     2.132    34.352     0.150
     2.132    34.566     0.150
     2.142    34.727     0.150
     2.222    35.672     0.150
     2.306    36.051     0.150
     2.306    36.199     0.150
     2.495    39.242     0.150
     2.579    40.645     0.150
     2.593    41.156     0.150
     2.651    42.328     0.150
     2.732    43.031     0.150
     2.905    45.582     0.150
     3.022    47.461     0.150
     3.047    48.086     0.150
     3.108    47.699     0.150
     3.236    48.973     0.150
     3.270    49.434     0.150
     3.267    51.215     0.150
     3.572    51.492     0.150
     3.747    57.941     0.150
     3.908    58.781     0.150
     3.978    59.203     0.150
     3.978    59.355     0.150
     4.020    62.484     0.150
     4.108    62.852     0.150
     4.257    64.434     0.150
     4.469    68.992     0.150
     4.501    67.812     0.150
     4.500    67.484     0.150
     4.500    68.023     0.150
     4.508    67.973     0.150
     4.545    68.051     0.150
     4.571    69.703     0.150
     4.588    69.352     0.150
     4.596    70.164     0.150
     4.596    84.938     0.150
     4.596   147.418     0.150
     4.596    70.301     0.150
     4.648    69.453     0.150
     4.765    71.773     0.150
     4.804    71.812     0.150
     4.804    72.430     0.150
     4.833    73.562     0.150
     4.947    74.273     0.150
     5.166    77.801     0.150
     5.179    77.641     0.150
     5.352    81.582     0.150
     5.431    79.824     0.150
     5.579    83.973     0.150
     5.782    85.922     0.150
     6.022    89.242     0.150
     6.688    98.914     0.150
     6.894   102.164     0.150
     6.894   127.711     0.150
     6.894   179.488     0.150
     6.894   215.812     0.150
     7.021   102.887     0.150
     7.767   112.422     0.150
     8.679   127.758     0.150
     8.679   158.434     0.150
     8.679   268.984     0.150
     8.679   125.242     0.150
     9.009   131.762     0.150
     9.950   141.641     0.150
     9.950   142.109     0.150
    10.502   153.629     0.150
    10.502   154.312     0.150
    10.502   151.934     0.150
    12.180   174.211     0.150
    12.180   385.867     0.150
    14.285   206.430     0.150
    14.285   208.594     0.150
    15.071   210.344     0.150
    15.242   219.363     0.150
    19.414   265.762     0.150
    19.462   264.664     0.150
    19.524   265.934     0.150
    19.697   267.871     0.150
    19.959   270.301     0.150
    20.770   279.504     0.150
    21.259   284.504     0.150
    21.259   286.332     0.150
    22.418   299.461     0.150
    22.418   298.102     0.150
    22.685   301.152     0.150
    26.012   334.262     0.150
    28.584   355.512     0.150
    28.584   545.738     0.150
    35.675   418.762     0.150
    35.809   419.863     0.150
    37.348   432.453     0.150
    37.348   432.352     0.150
    38.267   440.641     0.150
    93.141   793.645     0.150
    93.196   794.012     0.150
   116.107  1122.152     0.150
   118.200  1126.012     0.150
     0.137     3.805     0.150
     0.137     6.365     0.150
     0.137     6.234     0.150
     0.178     6.955     0.150
     0.161     3.475     0.150
     0.174     4.455     0.150
     0.174     7.615     0.150
     0.166     4.014     0.150
     0.166     6.834     0.150
     0.167     4.170     0.150
     0.167     6.920     0.150
     0.167     3.914     0.150
     0.167     4.057     0.150
     0.188     4.674     0.150
     0.188     7.615     0.150
     0.195     4.834     0.150
     0.195     8.295     0.150
     0.296     6.164     0.150
     0.296    10.445     0.150
     0.269     5.936     0.150
     0.269     9.725     0.150
     0.300    10.844     0.150
     0.300     6.154     0.150
     0.300    10.734     0.150
     0.292     6.064     0.150
     0.292    10.195     0.150
     0.357     7.445     0.150
     0.357    12.424     0.150
     0.421     8.395     0.150
     0.421    14.785     0.150
     0.437     8.795     0.150
     0.437    15.254     0.150
     0.464     9.164     0.150
     0.464    15.436     0.150
     0.496     9.814     0.150
     0.496    16.795     0.150
     0.511     9.895     0.150
     0.511    16.764     0.150
     0.502     9.994     0.150
     0.502    17.125     0.150
     0.522    10.035     0.150
     0.522    17.074     0.150
     0.551    10.475     0.150
     0.551    18.014     0.150
     0.551    18.250     0.150
     0.533    10.305     0.150
     0.533    17.605     0.150
     0.535    10.344     0.150
     0.535    17.324     0.150
     0.607    11.275     0.150
     0.607    19.186     0.150
     0.618    12.215     0.150
     0.618    21.895     0.150
     0.644    11.875     0.150
     0.644    20.484     0.150
     0.644    20.314     0.150
     0.625    12.074     0.150
     0.625    20.674     0.150
     0.642    12.205     0.150
     0.642    20.725     0.150
     0.642    12.104     0.150
     0.642    20.965     0.150
     0.650    12.686     0.150
     0.650    21.445     0.150
     0.686    12.975     0.150
     0.679    12.535     0.150
     0.670    12.795     0.150
     0.670    21.844     0.150
     0.670    22.494     0.150
     0.727    13.715     0.150
     0.727    23.436     0.150
     0.716    13.125     0.150
     0.716    23.525     0.150
     0.715    13.164     0.150
     0.715    22.645     0.150
     0.738    13.365     0.150
     0.738    23.625     0.150
     0.739    13.785     0.150
     0.785    14.436     0.150
     0.785    24.885     0.150
     0.785    14.314     0.150
     0.781    14.365     0.150
     0.781    24.531     0.150
     0.781    14.295     0.150
     0.781    24.525     0.150
     0.819    14.844     0.150
     0.819    25.404     0.150
     0.842    15.584     0.150
     0.842    26.885     0.150
     0.842    27.029     0.150
     0.832    15.064     0.150
     0.832    27.625     0.150
     0.807    15.494     0.150
     0.807    26.664     0.150
     0.846    28.545     0.150
     0.841    15.545     0.150
     0.841    26.475     0.150
     0.845    15.615     0.150
     0.883    16.234     0.150
     0.883    27.574     0.150
     0.883    15.914     0.150
     0.883    27.705     0.150
     0.858    16.084     0.150
     0.858    27.465     0.150
     0.858    15.510     0.150
     0.853    27.574     0.150
     0.852    27.295     0.150
     0.895    30.264     0.150
     0.895    30.725     0.150
     0.909    16.074     0.150
     0.910    16.055     0.150
     0.927    16.635     0.150
     0.927    28.475     0.150
     0.902    16.545     0.150
     0.902    28.254     0.150
     0.905    17.240     0.150
     0.905    29.494     0.150
     0.946    17.254     0.150
     0.954    18.045     0.150
     1.026    18.305     0.150
     1.026    31.525     0.150
     1.062    19.324     0.150
     1.062    19.205     0.150
     1.142    20.844     0.150
     1.142    20.535     0.150
     1.281    22.859     0.150
     1.281    39.525     0.150
     1.298    22.344     0.150
     1.298    41.834     0.150
     1.406    22.984     0.150
     1.416    23.275     0.150
     1.385    24.369     0.150
     1.385    44.547     0.150
     1.415    23.645     0.150
     1.415    23.445     0.150
     1.415    23.305     0.150
     1.463    24.424     0.150
     1.475    24.064     0.150
     1.489    25.514     0.150
     1.489    46.654     0.150
     1.498    26.436     0.150
     1.563    25.924     0.150
     1.582    27.475     0.150
     1.582    27.365     0.150
     1.563    26.418     0.150
     1.563    48.908     0.150
     1.622    25.744     0.150
     1.622    25.895     0.150
     1.617    28.625     0.150
     1.636    26.814     0.150
     1.645    27.094     0.150
     1.645    50.287     0.150
     1.766    28.414     0.150
     1.788    28.375     0.150
     1.764    29.314     0.150
     1.764    53.695     0.150
     1.819    30.219     0.150
     1.830    28.775     0.150
     1.876    31.855     0.150
     1.876    31.494     0.150
     1.922    31.785     0.150
     2.012    32.369     0.150
     2.033    33.195     0.150
     2.033    64.432     0.150
     2.118    35.105     0.150
     2.102    33.594     0.150
     2.102    65.818     0.150
     2.142    35.514     0.150
     2.220    36.121     0.150
     2.294    35.455     0.150
     2.271    36.930     0.150
     2.350    36.436     0.150
     2.453    39.227     0.150
     2.533    40.055     0.150
     2.538    40.035     0.150
     2.581    40.484     0.150
     2.589    41.320     0.150
     2.689    41.834     0.150
     2.712    41.824     0.150
     2.933    42.574     0.150
     2.933    42.045     0.150
     2.741    43.395     0.150
     2.744    43.445     0.150
     2.773    43.975     0.150
     2.773    43.719     0.150
     2.874    46.094     0.150
     2.890    45.209     0.150
     2.914    44.834     0.150
     3.035    47.395     0.150
     3.139    48.801     0.150
     3.230    49.781     0.150
     3.232    50.674     0.150
     3.275    50.844     0.150
     3.407    50.664     0.150
     3.407    50.859     0.150
     3.476    53.594     0.150
     3.500    55.045     0.150
     3.500    54.688     0.150
     3.622    56.225     0.150
     3.622    56.521     0.150
     3.748    57.797     0.150
     3.877    59.555     0.150
     3.885    59.977     0.150
     4.115    63.234     0.150
     4.230    64.686     0.150
     4.275    64.275     0.150
     4.421    66.834     0.150
     4.523    68.725     0.150
     4.530    68.715     0.150
     4.575    67.025     0.150
     4.608    70.500     0.150
     4.651    71.064     0.150
     4.674    71.355     0.150
     4.674    70.643     0.150
     4.697    72.264     0.150
     4.809    72.164     0.150
     4.898    72.014     0.150
     4.898    72.248     0.150
     4.895    73.984     0.150
     4.944    74.084     0.150
     4.944    74.480     0.150
     4.967    74.904     0.150
     5.078    77.094     0.150
     5.123    76.344     0.150
     5.166    77.875     0.150
     5.197    79.605     0.150
     5.197    95.979     0.150
     5.197    77.725     0.150
     5.228    78.615     0.150
     5.268    79.105     0.150
     5.411    81.795     0.150
     5.439    81.754     0.150
     5.506    81.754     0.150
     5.497    82.494     0.150
     5.588    83.514     0.150
     5.750    87.355     0.150
     5.752    86.025     0.150
     5.803    86.125     0.150
     5.803    86.270     0.150
     5.972    90.064     0.150
     6.089    91.174     0.150
     7.336   106.949     0.150
     7.340   108.121     0.150
     7.351   109.174     0.150
     7.505   110.113     0.150
     7.700   112.074     0.150
     7.767   113.154     0.150
     7.960   115.834     0.150
     7.960   116.279     0.150
     8.103   118.334     0.150
     8.206   118.924     0.150
     8.413   123.094     0.150
     8.413   153.969     0.150
     8.413   122.494     0.150
     8.413   122.975     0.150
     8.931   130.646     0.150
     9.372   136.721     0.150
     9.500   135.717     0.150
     9.546   138.404     0.150
     9.647   144.422     0.150
     9.647   304.633     0.150
     9.892   143.664     0.150
     9.892   143.836     0.150
     9.904   145.873     0.150
    10.227   150.260     0.150
    10.329   150.582     0.150
    10.506   152.195     0.150
    10.659   155.738     0.150
    10.751   153.795     0.150
    10.751   338.994     0.150
    10.739   155.014     0.150
    10.767   155.867     0.150
    10.769   157.584     0.150
    10.769   158.861     0.150
    10.769   342.211     0.150
    11.015   158.965     0.150
    11.197   163.227     0.150
    11.337   165.232     0.150
    11.405   164.449     0.150
    11.568   168.168     0.150
    11.663   167.205     0.150
    11.664   167.406     0.150
    11.664   366.756     0.150
    11.664   167.064     0.150
    11.848   173.117     0.150
    12.060   173.264     0.150
    12.060   172.996     0.150
    12.104   173.959     0.150
    12.318   176.527     0.150
    12.462   179.570     0.150
    12.690   185.205     0.150
    12.873   187.348     0.150
    12.912   187.420     0.150
    13.505   196.205     0.150
    13.704   195.738     0.150
    14.126   201.145     0.150
    14.382   203.885     0.150
    14.382   203.572     0.150
    14.438   204.082     0.150
    14.438   385.553     0.150
    14.525   203.936     0.150
    14.701   208.635     0.150
    14.814   213.145     0.150
    14.814   468.668     0.150
    14.814   211.418     0.150
    14.944   212.961     0.150
    15.022   215.805     0.150
    15.351   217.312     0.150
    15.503   217.324     0.150
    15.503   406.738     0.150
    16.054   226.354     0.150
    16.054   416.217     0.150
    16.203   226.910     0.150
    16.203   420.104     0.150
    16.400   233.074     0.150
    16.547   232.885     0.150
    16.656   234.955     0.150
    16.798   235.504     0.150
    16.955   238.035     0.150
    17.169   239.771     0.150
    17.169   441.082     0.150
    17.430   243.834     0.150
    17.449   243.520     0.150
    17.513   244.785     0.150
    17.599   246.043     0.150
    17.778   247.814     0.150
    17.884   250.025     0.150
    17.884   250.475     0.150
    17.988   250.945     0.150
    18.139   252.164     0.150
    18.434   255.912     0.150
    18.557   257.098     0.150
    18.800   259.674     0.150
    18.995   263.324     0.150
    18.995   478.428     0.150
    19.185   264.240     0.150
    19.272   265.154     0.150
    19.561   268.936     0.150
    19.610   269.254     0.150
    19.610   268.396     0.150
    19.750   272.051     0.150
    19.788   271.285     0.150
    20.021   273.174     0.150
    20.058   273.855     0.150
    20.058   273.275     0.150
    20.164   273.904     0.150
    20.507   279.484     0.150
    20.543   282.475     0.150
    20.932   282.074     0.150
    20.943   282.961     0.150
    21.410   289.025     0.150
    21.410   288.229     0.150
    21.485   290.045     0.150
    21.522   289.424     0.150
    21.661   291.318     0.150
    21.661   539.279     0.150
    21.811   293.076     0.150
    22.383   296.484     0.150
    22.429   299.650     0.150
    22.587   298.432     0.150
    22.587   551.488     0.150
    22.614   302.799     0.150
    22.614   299.904     0.150
    22.621   301.205     0.150
    22.763   301.654     0.150
    23.623   310.135     0.150
    23.689   311.625     0.150
    23.691   309.449     0.150
    23.691   573.324     0.150
    23.838   313.035     0.150
    24.086   314.428     0.150
    24.086   582.627     0.150
    24.396   318.377     0.150
    24.396   585.910     0.150
    24.603   320.664     0.150
    24.603   320.053     0.150
    24.603   591.668     0.150
    24.748   322.055     0.150
    24.917   323.637     0.150
    24.903   322.904     0.150
    25.236   326.055     0.150
    25.324   328.369     0.150
    25.367   328.395     0.150
    25.456   328.832     0.150
    25.517   327.754     0.150
    25.726   330.045     0.150
    25.859   331.283     0.150
    25.858   331.436     0.150
    26.140   334.527     0.150
    26.348   336.375     0.150
    26.458   336.525     0.150
    26.478   336.305     0.150
    26.615   340.750     0.150
    26.615   340.381     0.150
    26.913   340.734     0.150
    26.938   342.918     0.150
    26.938   846.395     0.150
    27.013   340.947     0.150
    27.219   342.752     0.150
    27.466   346.086     0.150
    27.515   347.064     0.150
    27.743   347.125     0.150
    28.140   351.742     0.150
    28.855   359.994     0.150
    28.869   358.574     0.150
    28.879   358.893     0.150
    28.993   359.484     0.150
    29.091   362.125     0.150
    29.115   360.410     0.150
    29.179   363.178     0.150
    29.343   362.242     0.150
    29.522   363.113     0.150
    29.765   365.721     0.150
    29.905   368.738     0.150
    29.906   367.533     0.150
    30.130   370.582     0.150
    30.182   369.219     0.150
    30.232   369.936     0.150
    30.297   368.621     0.150
    30.458   369.115     0.150
    30.625   374.523     0.150
    30.669   375.125     0.150
    30.699   374.477     0.150
    30.754   376.213     0.150
    30.827   377.500     0.150
    30.827   376.594     0.150
    30.906   377.633     0.150
    30.954   376.965     0.150
    30.969   375.439     0.150
    30.972   377.633     0.150
    31.027   376.283     0.150
    31.375   378.824     0.150
    31.416   379.879     0.150
    31.536   383.172     0.150
    31.662   381.479     0.150
    31.758   381.959     0.150
    31.873   383.576     0.150
    31.877   384.617     0.150
    31.913   385.611     0.150
    31.962   385.354     0.150
    32.254   387.711     0.150
    32.653   390.082     0.150
    32.775   392.416     0.150
    32.868   392.355     0.150
    32.882   392.617     0.150
    33.023   395.438     0.150
    33.465   396.982     0.150
    33.512   398.105     0.150
    33.653   400.041     0.150
    33.773   400.564     0.150
    33.848   400.109     0.150
    33.869   399.752     0.150
    34.040   401.611     0.150
    34.216   403.244     0.150
    34.306   403.869     0.150
    34.354   405.355     0.150
    34.417   407.799     0.150
    34.434   406.449     0.150
    34.494   406.744     0.150
    34.468   407.117     0.150
    34.483   406.516     0.150
    34.580   407.883     0.150
    34.623   409.248     0.150
    34.581   408.439     0.150
    34.641   408.537     0.150
    34.694   408.451     0.150
    34.719   409.557     0.150
    34.744   408.471     0.150
    34.925   412.012     0.150
    34.966   411.957     0.150
    34.981   412.734     0.150
    35.009   410.965     0.150
    35.067   412.398     0.150
    35.098   412.695     0.150
    35.215   412.396     0.150
    35.250   412.908     0.150
    35.337   413.652     0.150
    35.404   415.434     0.150
    35.419   416.174     0.150
    35.468   416.828     0.150
    35.557   418.248     0.150
    35.612   414.508     0.150
    35.623   416.582     0.150
    35.661   416.078     0.150
    35.860   418.289     0.150
    35.919   420.047     0.150
    36.010   419.951     0.150
    36.051   421.982     0.150
    36.167   421.926     0.150
    36.196   421.848     0.150
    36.208   422.664     0.150
    36.256   421.529     0.150
    36.382   423.424     0.150
    36.398   424.146     0.150
    36.407   422.375     0.150
    36.431   426.266     0.150
    36.618   425.092     0.150
    36.629   426.004     0.150
    36.666   426.533     0.150
    36.781   427.992     0.150
    36.799   424.805     0.150
    36.800   429.975     0.150
    36.803   427.529     0.150
    36.832   427.447     0.150
    36.840   426.436     0.150
    36.869   426.592     0.150
    36.968   431.174     0.150
    36.995   430.115     0.150
    36.995   428.090     0.150
    37.015   430.855     0.150
    37.015   429.125     0.150
    37.286   431.594     0.150
    37.312   430.369     0.150
    37.315   432.145     0.150
    37.316   432.414     0.150
    37.316   431.854     0.150
    37.421   431.828     0.150
    37.458   433.771     0.150
    37.474   433.795     0.150
    37.477   432.172     0.150
    37.644   435.119     0.150
    37.647   434.457     0.150
    37.805   435.551     0.150
    37.825   435.863     0.150
    37.824   435.793     0.150
    37.969   437.188     0.150
    37.981   437.258     0.150
    38.327   440.352     0.150
    38.487   442.693     0.150
    38.494   442.428     0.150
    38.886   444.564     0.150
    38.893   444.025     0.150
    38.970   445.117     0.150
    39.113   447.111     0.150
    39.402   450.105     0.150
    39.778   452.061     0.150
    39.920   453.811     0.150
    40.537   457.170     0.150
    41.810   466.668     0.150
    42.651   477.900     0.150
    42.651   477.436     0.150
    42.945   477.480     0.150
    43.519   481.531     0.150
    43.545   484.385     0.150
    43.545   483.844     0.150
    44.317   490.332     0.150
    45.319   497.654     0.150
    45.564   500.594     0.150
    45.603   499.635     0.150
    45.655   503.494     0.150
    46.467   509.275     0.150
    46.613   513.135     0.150
    46.904   514.094     0.150
    46.993   511.205     0.150
    47.371   516.025     0.150
    47.400   509.275     0.150
    47.479   510.234     0.150
    47.517   515.055     0.150
    48.131   523.734     0.150
    48.229   521.805     0.150
    48.384   524.674     0.150
    48.384   523.734     0.150
    48.653   524.705     0.150
    48.730   524.705     0.150
    48.981   530.484     0.150
    49.323   531.455     0.150
    50.286   537.004     0.150
    51.962   552.164     0.150
    54.513   569.494     0.150
    54.655   570.375     0.150
    54.655   632.775     0.150
    54.869   571.695     0.150
    54.869   571.885     0.150
    58.552   601.186     0.150
    59.491   602.785     0.150
    59.792   607.045     0.150
    61.699   618.674     0.150
    61.699   618.699     0.150
    61.699   617.994     0.150
    63.159   632.520     0.150
    65.193   644.557     0.150
    65.815   648.145     0.150
    65.815   644.945     0.150
    67.599   657.525     0.150
    68.239   659.445     0.150
    69.220   666.264     0.150
    70.291   673.154     0.150
    71.081   682.574     0.150
    71.081     3.201     0.150
    71.081   700.674     0.150
    71.081   840.174     0.150
    71.081  1240.074     0.150
    71.081  1286.574     0.150
    73.626   693.945     0.150
    74.854   701.789     0.150
    76.011   707.600     0.150
    76.011   706.965     0.150
    76.011   707.074     0.150
    76.660   711.074     0.150
    76.672   712.633     0.150
    76.759   711.174     0.150
    76.759   718.674     0.150
    77.134   715.275     0.150
    77.223   714.674     0.150
    77.838   717.900     0.150
    77.838   717.275     0.150
    78.165   719.871     0.150
    78.801   721.445     0.150
    80.665   733.367     0.150
    80.789   732.645     0.150
    80.789   733.375     0.150
    80.789   734.100     0.150
    80.789   733.215     0.150
    81.280   737.574     0.150
    81.546   737.244     0.150
    81.545   737.588     0.150
    81.545   736.664     0.150
    81.546   737.244     0.150
    81.778   744.945     0.150
    81.841   738.314     0.150
    81.841     6.189     0.150
    81.869   745.264     0.150
    81.944   745.445     0.150
    82.133   747.145     0.150
    82.205   745.164     0.150
    82.312   748.234     0.150
    82.327   742.375     0.150
    82.327  1360.475     0.150
    82.864   750.805     0.150
    84.003   754.875     0.150
    84.003  1379.174     0.150
    84.144   756.174     0.150
    84.634  1389.475     0.150
    84.634  1719.475     0.150
    84.655   750.975     0.150
    84.655   947.674     0.150
    84.655  1372.275     0.150
    84.655  1709.574     0.150
    85.087   756.924     0.150
    85.153   757.484     0.150
    85.349   763.645     0.150
    85.349  1399.475     0.150
    85.737   760.424     0.150
    85.956   761.455     0.150
    86.136   762.455     0.150
    86.505   768.234     0.150
    86.672   769.557     0.150
    86.810   766.689     0.150
    87.158   968.174     0.150
    87.158  1391.375     0.150
    87.540   769.375     0.150
    87.560   772.850     0.150
    87.639   773.020     0.150
    88.804   776.074     0.150
    88.804   982.574     0.150
    89.100   781.574     0.150
    89.351   782.775     0.150
    89.351  1414.975     0.150
    89.351  1430.975     0.150
    89.444   778.174     0.150
    90.163   781.574     0.150
    90.375   781.574     0.150
    90.375   783.074     0.150
    90.381   786.494     0.150
    90.381   782.375     0.150
    90.381   998.074     0.150
    90.381  1413.775     0.150
    90.441   782.926     0.150
    90.903   786.361     0.150
    90.903   784.475     0.150
    91.039   783.285     0.150
    91.097   785.074     0.150
    93.397   799.699     0.150
    93.397   796.174     0.150
    94.530   803.449     0.150
    94.928  1483.674     0.150
    95.155   803.574     0.150
    95.258   804.539     0.150
    96.573   812.074     0.150
    98.364   818.875     0.150
    98.364   817.475     0.150
    98.585   815.875     0.150
    98.585  1453.674     0.150
   100.013   826.875     0.150
   100.653   827.475     0.150
   104.807   849.574     0.150
   104.807  1107.574     0.150
   104.807  2001.775     0.150
   105.573   849.875     0.150
   110.207  1110.875     0.150
   116.412  1124.557     0.150
   118.470  1127.910     0.150
   145.797  1178.988     0.150
   146.960  1183.900     0.150
     0.061     2.602     0.150
     0.061     5.367     0.150
     0.175     4.461     0.150
     0.175     7.977     0.150
     0.207     5.062     0.150
     0.207     9.547     0.150
     0.184     4.297     0.150
     0.184     7.297     0.150
     0.203     4.633     0.150
     0.203     7.938     0.150
     0.250     5.562     0.150
     0.250    10.258     0.150
     0.364     7.727     0.150
     0.364     7.844     0.150
     0.364    13.617     0.150
     0.404     7.883     0.150
     0.435     8.414     0.150
     0.435    14.344     0.150
     0.435     8.188     0.150
     0.555    10.859     0.150
     0.557    10.477     0.150
     0.550    10.641     0.150
     0.550    17.633     0.150
     0.559    10.812     0.150
     0.606    10.992     0.150
     0.602    11.680     0.150
     0.640    11.711     0.150
     0.640    20.188     0.150
     0.655    12.219     0.150
     0.685    13.141     0.150
     0.685    22.562     0.150
     0.710    13.516     0.150
     0.710    23.102     0.150
     0.710    23.242     0.150
     0.858    15.711     0.150
     0.904    16.000     0.150
     0.920    16.719     0.150
     0.972    16.422     0.150
     0.973    17.203     0.150
     0.954    17.188     0.150
     0.954    17.359     0.150
     0.954    29.570     0.150
     0.963    17.297     0.150
     0.963    29.898     0.150
     0.968    17.094     0.150
     0.968    30.695     0.150
     1.067    18.867     0.150
     1.064    18.664     0.150
     1.078    18.859     0.150
     1.078    33.461     0.150
     1.126    20.141     0.150
     1.176    20.867     0.150
     1.168    20.359     0.150
     1.192    20.938     0.150
     1.233    21.242     0.150
     1.233    38.164     0.150
     1.282    22.031     0.150
     1.282    21.828     0.150
     1.282    39.172     0.150
     1.323    23.297     0.150
     1.434    24.867     0.150
     1.434    24.992     0.150
     1.486    24.633     0.150
     1.544    24.922     0.150
     1.567    24.891     0.150
     1.682    27.531     0.150
     1.740    30.758     0.150
     1.788    31.266     0.150
     1.788    54.875     0.150
     1.804    29.211     0.150
     1.928    31.320     0.150
     1.950    34.117     0.150
     2.206    33.344     0.150
     2.140    37.180     0.150
     2.360    38.047     0.150
     2.384    41.492     0.150
     2.411    41.727     0.150
     2.411    73.039     0.150
     2.469    42.711     0.150
     2.477    39.992     0.150
     2.555    38.773     0.150
     2.555    38.555     0.150
     2.543    40.180     0.150
     2.530    40.141     0.150
     2.624    80.430     0.150
     2.760    85.047     0.150
     2.964    46.344     0.150
     3.164    49.008     0.150
     3.318    50.461     0.150
     3.324    52.258     0.150
     3.452    52.133     0.150
     3.537    54.320     0.150
     3.719    55.344     0.150
     3.741    57.891     0.150
     3.736    55.859     0.150
     4.000    61.344     0.150
     3.999    68.562     0.150
     4.103    61.320     0.150
     4.103    60.570     0.150
     4.310    65.977     0.150
     4.382    67.039     0.150
     4.441    68.562     0.150
     4.460    67.719     0.150
     4.570    68.367     0.150
     4.911    74.320     0.150
     4.942    74.023     0.150
     5.200    78.133     0.150
     5.304    78.977     0.150
     5.360    79.273     0.150
     5.720    84.297     0.150
     5.873    88.336     0.150
     5.873   185.047     0.150
     5.873    87.703     0.150
     6.585    95.672     0.150
     7.567   110.492     0.150
     8.726   125.344     0.150
    10.834   153.961     0.150
    10.835   155.281     0.150
    10.835   153.828     0.150
    10.867   159.672     0.150
     0.112     3.879     0.150
     0.151     4.039     0.150
     0.151     7.801     0.150
     0.171     7.961     0.150
     0.212     4.457     0.150
     0.212     8.184     0.150
     0.212     4.988     0.150
     0.230     5.277     0.150
     0.230     9.430     0.150
     0.234     5.379     0.150
     0.234     9.359     0.150
     0.273     6.141     0.150
     0.295     6.141     0.150
     0.295    10.621     0.150
     0.310     6.621     0.150
     0.317    10.871     0.150
     0.357     7.008     0.150
     0.357    13.078     0.150
     0.364     6.949     0.150
     0.364    13.578     0.150
     0.423     8.270     0.150
     0.423    13.891     0.150
     0.423     8.211     0.150
     0.501    10.070     0.150
     0.551    10.340     0.150
     0.551    10.199     0.150
     0.551    18.398     0.150
     0.549    10.203     0.150
     0.549    17.801     0.150
     0.549    10.777     0.150
     0.549    17.949     0.150
     0.554    10.527     0.150
     0.554    10.199     0.150
     0.554    18.121     0.150
     0.568    11.500     0.150
     0.568    20.820     0.150
     0.617     9.801     0.150
     0.618    11.570     0.150
     0.618    11.000     0.150
     0.618    19.477     0.150
     0.618    20.461     0.150
     0.648    12.418     0.150
     0.741    13.719     0.150
     0.736    13.375     0.150
     0.736    23.738     0.150
     0.728    13.562     0.150
     0.728    23.617     0.150
     0.852    15.320     0.150
     0.930    16.719     0.150
     0.930    28.859     0.150
     0.924    15.898     0.150
     0.963    18.020     0.150
     0.979    17.730     0.150
     0.979    17.520     0.150
     1.015    20.258     0.150
     1.022    17.820     0.150
     1.022    31.543     0.150
     1.022    18.059     0.150
     1.022    17.953     0.150
     1.092    19.027     0.150
     1.132    19.828     0.150
     1.132    34.926     0.150
     1.190    20.621     0.150
     1.190    35.961     0.150
     1.185    21.199     0.150
     1.208    21.211     0.150
     1.270    21.984     0.150
     1.310    22.449     0.150
     1.310    22.273     0.150
     1.310    39.156     0.150
     1.337    23.559     0.150
     1.418    25.121     0.150
     1.534    25.316     0.150
     1.729    28.168     0.150
     1.755    30.719     0.150
     1.804    29.441     0.150
     1.804    55.520     0.150
     1.852    30.141     0.150
     2.152    35.648     0.150
     1.989    31.754     0.150
     2.193    34.621     0.150
     2.193    67.828     0.150
     2.428    42.434     0.150
     2.450    37.852     0.150
     2.450    74.379     0.150
     2.509    37.988     0.150
     2.509    67.934     0.150
     2.522    43.133     0.150
     2.526    43.160     0.150
     2.519    44.988     0.150
     2.586    44.230     0.150
     2.674    48.484     0.150
     2.674    81.906     0.150
     2.815    51.086     0.150
     3.019    55.328     0.150
     3.218    53.371     0.150
     3.377    52.188     0.150
     3.508    52.945     0.150
     3.581    55.879     0.150
     3.787    59.309     0.150
     4.049    69.188     0.150
     4.051    62.348     0.150
     4.067    60.910     0.150
     4.067    60.234     0.150
     4.315    65.719     0.150
     4.315    65.055     0.150
     4.323    65.871     0.150
     4.485    68.578     0.150
     5.225    79.871     0.150
     5.297    80.371     0.150
     5.297    78.359     0.150
     5.791    87.520     0.150
     5.928    89.863     0.150
     5.928   188.035     0.150
     6.554    95.641     0.150
     6.554    95.000     0.150
     7.804   244.262     0.150
     7.818   113.996     0.150
     7.818   241.570     0.150
    10.793   154.523     0.150
    10.793   339.051     0.150
    10.898   159.699     0.150
     0.028     2.102     0.150
     0.113     5.652     0.150
     0.164     4.273     0.150
     0.164     7.941     0.150
     0.178     4.070     0.150
     0.178     7.660     0.150
     0.181     4.031     0.150
     0.181     7.402     0.150
     0.185     4.352     0.150
     0.185     8.363     0.150
     0.201     8.293     0.150
     0.310     5.953     0.150
     0.310    10.852     0.150
     0.312     6.922     0.150
     0.312    12.762     0.150
     0.317     6.211     0.150
     0.335    11.730     0.150
     0.335     6.543     0.150
     0.335    11.680     0.150
     0.369     7.660     0.150
     0.369    13.723     0.150
     0.386     8.090     0.150
     0.419     8.230     0.150
     0.419    14.441     0.150
     0.419    14.254     0.150
     0.426     8.883     0.150
     0.426    16.062     0.150
     0.439     8.930     0.150
     0.439    15.461     0.150
     0.457     8.691     0.150
     0.462     9.223     0.150
     0.469     9.371     0.150
     0.469    17.680     0.150
     0.552    10.852     0.150
     0.552    18.730     0.150
     0.552    18.465     0.150
     0.553    10.660     0.150
     0.553    19.781     0.150
     0.625    11.910     0.150
     0.625    21.273     0.150
     0.667    12.273     0.150
     0.667    23.133     0.150
     0.667    21.961     0.150
     0.667    12.152     0.150
     0.667    21.883     0.150
     0.696    13.102     0.150
     0.696    23.680     0.150
     0.706    13.543     0.150
     0.706    24.590     0.150
     0.719    13.523     0.150
     0.719    22.230     0.150
     0.715    14.062     0.150
     0.723    13.570     0.150
     0.723    24.293     0.150
     0.744    13.930     0.150
     0.744    24.461     0.150
     0.744    24.156     0.150
     0.757    14.160     0.150
     0.757    24.652     0.150
     0.775    14.863     0.150
     0.798    14.363     0.150
     0.798    25.172     0.150
     0.798    14.469     0.150
     0.798    25.695     0.150
     0.805    25.930     0.150
     0.805    14.852     0.150
     0.808    14.973     0.150
     0.808    26.051     0.150
     0.808    27.891     0.150
     0.856    15.602     0.150
     0.856    27.180     0.150
     0.863    16.102     0.150
     0.863    27.703     0.150
     0.868    15.973     0.150
     0.868    28.191     0.150
     0.871    16.371     0.150
     0.871    27.945     0.150
     0.871    15.910     0.150
     0.871    16.031     0.150
     0.871    28.051     0.150
     0.879    16.293     0.150
     0.879    28.711     0.150
     0.907    16.730     0.150
     0.907    29.062     0.150
     0.916    16.871     0.150
     0.916    29.211     0.150
     0.921    17.023     0.150
     0.921    29.852     0.150
     0.922    17.090     0.150
     0.942    17.473     0.150
     0.990    18.383     0.150
     0.997    18.262     0.150
     1.012    18.320     0.150
     1.011    18.523     0.150
     1.011    31.980     0.150
     1.037    19.203     0.150
     1.037    33.680     0.150
     1.037    19.051     0.150
     1.057    18.973     0.150
     1.057    19.129     0.150
     1.057    33.277     0.150
     1.091    20.203     0.150
     1.108    18.730     0.150
     1.116    19.742     0.150
     1.116    35.133     0.150
     1.125    20.250     0.150
     1.125    19.949     0.150
     1.125    35.285     0.150
     1.125    35.590     0.150
     1.164    36.891     0.150
     1.168    20.641     0.150
     1.170    21.562     0.150
     1.186    21.023     0.150
     1.208    21.090     0.150
     1.223    21.301     0.150
     1.241    21.672     0.150
     1.241    39.402     0.150
     1.246    21.672     0.150
     1.248    21.621     0.150
     1.276    22.000     0.150
     1.305    22.402     0.150
     1.305    22.234     0.150
     1.305    41.668     0.150
     1.309    23.570     0.150
     1.323    23.953     0.150
     1.355    23.211     0.150
     1.355    23.094     0.150
     1.355    43.262     0.150
     1.549    25.941     0.150
     1.582    26.480     0.150
     1.594    27.211     0.150
     1.617    28.938     0.150
     1.617    51.293     0.150
     1.643    27.961     0.150
     1.697    27.180     0.150
     1.824    29.750     0.150
     1.882    31.652     0.150
     1.907    31.680     0.150
     1.910    30.992     0.150
     1.910    58.719     0.150
     1.925    31.293     0.150
     2.029    33.047     0.150
     2.034    33.453     0.150
     2.044    33.027     0.150
     2.244    33.773     0.150
     2.128    34.992     0.150
     2.167    34.895     0.150
     2.242    39.816     0.150
     2.242    69.586     0.150
     2.262    40.078     0.150
     2.262    70.059     0.150
     2.334    36.617     0.150
     2.334    67.926     0.150
     2.352    38.691     0.150
     2.419    38.473     0.150
     2.475    38.684     0.150
     2.491    39.273     0.150
     2.491    39.109     0.150
     2.499    44.547     0.150
     2.499    77.395     0.150
     2.648    42.941     0.150
     2.664    41.734     0.150
     2.664    82.781     0.150
     2.694    40.512     0.150
     2.694    40.902     0.150
     2.876    44.602     0.150
     2.973    45.793     0.150
     2.973    92.410     0.150
     3.134    47.922     0.150
     3.164    47.980     0.150
     3.164    48.844     0.150
     3.305    50.262     0.150
     3.337    51.402     0.150
     3.403    51.992     0.150
     3.505    53.262     0.150
     3.575    54.562     0.150
     3.604    68.195     0.150
     3.616    55.582     0.150
     3.874    59.273     0.150
     3.892    59.082     0.150
     3.961    74.867     0.150
     4.001    61.043     0.150
     4.001    61.301     0.150
     4.236    64.152     0.150
     4.236    64.449     0.150
     4.256    62.953     0.150
     4.256    62.809     0.150
     4.447    65.992     0.150
     4.447    66.793     0.150
     4.478    66.531     0.150
     4.494    68.613     0.150
     4.534    68.293     0.150
     4.624    69.582     0.150
     5.096    75.973     0.150
     5.270    77.832     0.150
     5.293    99.207     0.150
     5.382    79.832     0.150
     5.454    80.840     0.150
     5.454    81.543     0.150
     5.724    83.191     0.150
     5.796    85.793     0.150
     5.836    87.078     0.150
     5.836    86.762     0.150
     6.084    89.633     0.150
     6.140    89.762     0.150
     6.310    93.410     0.150
     6.366    94.211     0.150
     6.639    97.422     0.150
     6.741    97.492     0.150
     6.741    98.262     0.150
     7.338   107.500     0.150
     7.617   110.191     0.150
     7.666   111.602     0.150
     7.724   112.051     0.150
     7.740   112.152     0.150
     7.784   112.223     0.150
     7.965   116.031     0.150
     7.988   115.797     0.150
     7.988   248.746     0.150
     7.988   116.211     0.150
     9.655   138.973     0.150
    10.950   157.051     0.150
    10.979   157.441     0.150
    10.979   157.453     0.150
    10.980   157.676     0.150
    12.119   171.172     0.150
    27.240   346.926     0.150
    37.091   431.953     0.150
     0.299     6.551     0.150
     0.299    11.738     0.150
     0.361     7.230     0.150
     0.361    12.219     0.150
     0.367     7.141     0.150
     0.367    12.148     0.150
     0.367    12.043     0.150
     0.432     8.918     0.150
     0.432    16.000     0.150
     0.385     7.910     0.150
     0.385    13.910     0.150
     0.406     8.020     0.150
     0.406    14.691     0.150
     0.458     9.359     0.150
     0.458    16.668     0.150
     0.406     8.500     0.150
     0.406    15.219     0.150
     0.417     8.078     0.150
     0.417    14.500     0.150
     0.417    14.047     0.150
     0.465     8.961     0.150
     0.451     9.199     0.150
     0.451    16.090     0.150
     0.511    10.141     0.150
     0.511    18.500     0.150
     0.549    10.770     0.150
     0.549    19.379     0.150
     0.558    11.191     0.150
     0.558    20.961     0.150
     0.573    11.121     0.150
     0.573    20.191     0.150
     0.658    12.199     0.150
     0.658    21.738     0.150
     0.678    12.602     0.150
     0.678    22.000     0.150
     0.679    12.719     0.150
     0.679    23.531     0.150
     0.635    11.891     0.150
     0.635    20.781     0.150
     0.670    12.793     0.150
     0.674    12.828     0.150
     0.674    22.531     0.150
     0.677    12.836     0.150
     0.677    22.461     0.150
     0.719    13.031     0.150
     0.719    23.578     0.150
     0.712    13.719     0.150
     0.712    23.250     0.150
     0.712    23.078     0.150
     0.729    13.512     0.150
     0.729    23.180     0.150
     0.762    14.648     0.150
     0.762    25.410     0.150
     0.724    14.078     0.150
     0.724    24.410     0.150
     0.724    14.238     0.150
     0.724    24.602     0.150
     0.759    14.539     0.150
     0.759    25.109     0.150
     0.749    14.461     0.150
     0.749    24.488     0.150
     0.749    24.961     0.150
     0.773    14.691     0.150
     0.773    25.148     0.150
     0.803    14.410     0.150
     0.803    24.539     0.150
     0.803    14.582     0.150
     0.803    25.473     0.150
     0.773    14.891     0.150
     0.773    25.949     0.150
     0.792    15.391     0.150
     0.792    26.859     0.150
     0.801    15.488     0.150
     0.801    26.641     0.150
     0.848    15.398     0.150
     0.844    15.859     0.150
     0.844    28.180     0.150
     0.863    16.379     0.150
     0.863    28.531     0.150
     0.877    16.629     0.150
     0.877    28.648     0.150
     0.960    16.211     0.150
     0.945    17.602     0.150
     0.945    31.559     0.150
     0.934    17.320     0.150
     0.934    31.520     0.150
     0.941    17.969     0.150
     1.007    18.051     0.150
     1.007    31.602     0.150
     0.978    18.238     0.150
     0.978    17.918     0.150
     0.978    32.375     0.150
     1.041    18.551     0.150
     1.059    18.930     0.150
     1.059    33.371     0.150
     1.062    19.148     0.150
     1.103    20.039     0.150
     1.121    19.980     0.150
     1.147    20.941     0.150
     1.119    19.871     0.150
     1.133    20.059     0.150
     1.133    20.141     0.150
     1.165    20.539     0.150
     1.225    21.340     0.150
     1.225    21.137     0.150
     1.225    37.656     0.150
     1.225    21.449     0.150
     1.206    22.480     0.150
     1.264    22.270     0.150
     1.262    22.031     0.150
     1.255    21.832     0.150
     1.255    39.852     0.150
     1.313    22.449     0.150
     1.367    24.250     0.150
     1.357    26.629     0.150
     1.371    25.641     0.150
     1.371    24.082     0.150
     1.371    43.691     0.150
     1.378    24.539     0.150
     1.387    24.629     0.150
     1.473    25.180     0.150
     1.473    47.227     0.150
     1.637    28.191     0.150
     1.596    26.734     0.150
     1.656    30.520     0.150
     1.656    27.625     0.150
     1.656    48.734     0.150
     1.674    29.012     0.150
     1.739    29.691     0.150
     1.725    28.875     0.150
     1.725    51.641     0.150
     1.881    59.930     0.150
     1.896    31.609     0.150
     2.127    34.312     0.150
     2.127    67.543     0.150
     2.176    40.176     0.150
     2.176    67.004     0.150
     2.176    34.879     0.150
     2.176    68.363     0.150
     2.216    36.980     0.150
     2.245    35.969     0.150
     2.245    68.945     0.150
     2.561    39.289     0.150
     2.362    38.410     0.150
     2.353    38.531     0.150
     2.361    73.004     0.150
     2.382    37.848     0.150
     2.444    38.684     0.150
     2.444    75.508     0.150
     2.519    39.520     0.150
     2.596    39.211     0.150
     2.637    41.988     0.150
     2.698    42.359     0.150
     2.811    42.480     0.150
     2.805    50.105     0.150
     2.809    43.668     0.150
     2.937    45.391     0.150
     2.971    46.512     0.150
     3.100    47.629     0.150
     3.141    47.984     0.150
     3.175    49.250     0.150
     3.175    48.918     0.150
     3.223    49.441     0.150
     3.261    49.918     0.150
     3.261    50.109     0.150
     3.458    52.691     0.150
     3.552    55.352     0.150
     3.656    56.129     0.150
     3.656    56.863     0.150
     3.914    59.730     0.150
     4.126    63.168     0.150
     4.173    63.578     0.150
     4.206    63.859     0.150
     4.224    65.930     0.150
     4.220    64.160     0.150
     4.215    63.730     0.150
     4.285    64.570     0.150
     4.401    67.129     0.150
     4.654    70.102     0.150
     4.791    71.730     0.150
     4.907    73.070     0.150
     4.961    73.398     0.150
     5.030    75.039     0.150
     5.030    76.621     0.150
     5.079    76.102     0.150
     5.287    79.418     0.150
     5.287    80.148     0.150
     5.420    81.918     0.150
     5.432    81.809     0.150
     5.518    82.113     0.150
     5.518   173.715     0.150
     5.792    85.168     0.150
     5.790    86.410     0.150
     5.922    86.691     0.150
     6.040    89.551     0.150
     6.559    97.609     0.150
     6.729    98.551     0.150
     6.729    98.656     0.150
     7.164   105.441     0.150
     7.158   104.148     0.150
     7.208   105.570     0.150
     7.416   108.660     0.150
     7.432   110.914     0.150
     7.432   122.691     0.150
     7.432   233.363     0.150
     7.534   110.320     0.150
     7.633   111.480     0.150
     7.864   115.461     0.150
     7.864   243.863     0.150
    10.064   315.148     0.150
    10.620   156.840     0.150
    10.620   338.914     0.150
    11.052   158.559     0.150
    11.052   158.578     0.150
    11.053   157.074     0.150
    11.053   345.551     0.150
    11.053   158.578     0.150
    17.275   242.711     0.150
    36.777   429.164     0.150
     0.199     4.782     0.150
     0.212     4.992     0.150
     0.292     6.282     0.150
     0.292    11.782     0.150
     0.354     7.002     0.150
     0.360     7.151     0.150
     0.360    11.852     0.150
     0.392     7.782     0.150
     0.392    14.102     0.150
     0.425     8.672     0.150
     0.413     7.922     0.150
     0.413    14.962     0.150
     0.423     7.962     0.150
     0.423    14.164     0.150
     0.412     8.412     0.150
     0.412    15.602     0.150
     0.450     9.182     0.150
     0.450    16.592     0.150
     0.458     8.952     0.150
     0.458    15.821     0.150
     0.449     9.202     0.150
     0.449    15.702     0.150
     0.505     9.812     0.150
     0.505    18.492     0.150
     0.541    10.592     0.150
     0.541    18.742     0.150
     0.551    10.882     0.150
     0.551    20.382     0.150
     0.573    11.092     0.150
     0.651    11.892     0.150
     0.651    21.271     0.150
     0.639    11.742     0.150
     0.639    20.861     0.150
     0.674    12.571     0.150
     0.674    23.282     0.150
     0.671    12.382     0.150
     0.671    21.852     0.150
     0.673    13.452     0.150
     0.673    23.552     0.150
     0.677    12.702     0.150
     0.677    22.602     0.150
     0.680    12.702     0.150
     0.680    22.659     0.150
     0.711    13.361     0.150
     0.715    13.102     0.150
     0.707    13.552     0.150
     0.707    23.212     0.150
     0.707    22.931     0.150
     0.722    13.382     0.150
     0.722    23.382     0.150
     0.722    23.813     0.150
     0.731    14.012     0.150
     0.731    24.592     0.150
     0.731    24.459     0.150
     0.755    14.392     0.150
     0.755    25.172     0.150
     0.757    14.532     0.150
     0.757    25.632     0.150
     0.751    14.401     0.150
     0.751    25.882     0.150
     0.751    25.012     0.150
     0.772    14.632     0.150
     0.772    25.481     0.150
     0.801    14.562     0.150
     0.801    26.029     0.150
     0.776    15.032     0.150
     0.776    26.722     0.150
     0.795    15.262     0.150
     0.803    15.372     0.150
     0.843    15.231     0.150
     0.850    15.662     0.150
     0.850    28.632     0.150
     0.866    16.231     0.150
     0.866    28.452     0.150
     0.879    16.592     0.150
     0.879    29.132     0.150
     0.953    16.392     0.150
     0.940    17.191     0.150
     0.940    31.182     0.150
     0.946    17.452     0.150
     0.946    31.412     0.150
     0.946    17.632     0.150
     0.985    18.071     0.150
     0.985    17.948     0.150
     0.985    31.756     0.150
     1.003    17.941     0.150
     1.036    18.812     0.150
     1.036    32.861     0.150
     1.057    18.782     0.150
     1.057    33.892     0.150
     1.065    19.042     0.150
     1.106    19.861     0.150
     1.116    19.762     0.150
     1.140    21.361     0.150
     1.117    36.702     0.150
     1.121    19.731     0.150
     1.135    20.092     0.150
     1.136    20.142     0.150
     1.161    20.602     0.150
     1.161    36.852     0.150
     1.210    38.332     0.150
     1.221    21.792     0.150
     1.221    38.672     0.150
     1.210    21.782     0.150
     1.222    21.481     0.150
     1.222    38.786     0.150
     1.222    21.282     0.150
     1.259    22.071     0.150
     1.257    22.182     0.150
     1.257    22.032     0.150
     1.257    41.820     0.150
     1.262    21.952     0.150
     1.306    22.432     0.150
     1.328    23.062     0.150
     1.362    24.182     0.150
     1.364    23.992     0.150
     1.361    24.111     0.150
     1.376    24.409     0.150
     1.376    45.450     0.150
     1.384    24.782     0.150
     1.392    24.262     0.150
     1.456    24.622     0.150
     1.480    27.151     0.150
     1.480    25.371     0.150
     1.603    28.622     0.150
     1.603    27.007     0.150
     1.630    28.262     0.150
     1.660    49.250     0.150
     1.678    28.762     0.150
     1.736    27.691     0.150
     1.731    29.012     0.150
     1.726    29.002     0.150
     1.855    30.687     0.150
     1.867    31.492     0.150
     2.101    34.731     0.150
     2.135    34.371     0.150
     2.172    35.672     0.150
     2.183    34.771     0.150
     2.219    37.742     0.150
     2.246    40.336     0.150
     2.364    38.071     0.150
     2.358    38.582     0.150
     2.553    39.021     0.150
     2.364    42.147     0.150
     2.382    41.872     0.150
     2.449    39.105     0.150
     2.449    76.050     0.150
     2.526    40.832     0.150
     2.591    39.481     0.150
     2.630    49.512     0.150
     2.643    42.151     0.150
     2.704    51.252     0.150
     2.808    43.021     0.150
     2.808    53.342     0.150
     2.817    43.892     0.150
     2.979    47.702     0.150
     3.107    48.015     0.150
     3.146    49.066     0.150
     3.175    55.631     0.150
     3.231    50.882     0.150
     3.266    50.632     0.150
     3.266    50.472     0.150
     3.462    54.282     0.150
     3.559    56.271     0.150
     3.663    57.432     0.150
     3.663    57.002     0.150
     3.677    56.621     0.150
     3.737    58.275     0.150
     3.921    61.642     0.150
     4.058    62.251     0.150
     4.134    63.812     0.150
     4.180    64.271     0.150
     4.228    65.712     0.150
     4.226    64.622     0.150
     4.222    64.242     0.150
     4.284    64.912     0.150
     4.284    65.356     0.150
     4.333    67.092     0.150
     4.408    67.632     0.150
     4.451    67.361     0.150
     4.591    69.532     0.150
     4.660    71.592     0.150
     4.798    73.922     0.150
     4.914    74.082     0.150
     4.963    74.602     0.150
     5.038    76.552     0.150
     5.290    80.353     0.150
     5.525    82.226     0.150
     5.797    85.842     0.150
     5.821    86.992     0.150
     5.998    89.212     0.150
     6.673    98.542     0.150
     6.728    98.842     0.150
     6.765    99.642     0.150
     7.034   103.252     0.150
     7.049   103.662     0.150
     7.349   106.682     0.150
    10.626   155.502     0.150
    11.050   160.526     0.150
    14.984   216.721     0.150
    15.020   209.762     0.150
    15.029   214.742     0.150
    15.211   214.182     0.150
     0.214     4.948     0.150
     0.214     9.159     0.150
     0.227     5.198     0.150
     0.227     9.269     0.150
     0.296     6.469     0.150
     0.368     7.219     0.150
     0.373     7.318     0.150
     0.373     7.204     0.150
     0.373    11.515     0.150
     0.386     7.818     0.150
     0.386    13.849     0.150
     0.400     7.919     0.150
     0.400    14.329     0.150
     0.406     7.898     0.150
     0.406    14.079     0.150
     0.406     8.047     0.150
     0.406    13.803     0.150
     0.411     8.429     0.150
     0.411    15.229     0.150
     0.431     9.108     0.150
     0.461     9.309     0.150
     0.465     9.469     0.150
     0.465    16.738     0.150
     0.474     9.119     0.150
     0.474    15.909     0.150
     0.552    11.099     0.150
     0.552    19.488     0.150
     0.555    11.009     0.150
     0.555    20.679     0.150
     0.588    11.579     0.150
     0.588    19.329     0.150
     0.645    12.339     0.150
     0.645    21.049     0.150
     0.662    12.409     0.150
     0.662    22.019     0.150
     0.671    12.738     0.150
     0.685    12.488     0.150
     0.685    22.549     0.150
     0.681    12.609     0.150
     0.681    22.629     0.150
     0.685    13.108     0.150
     0.685    22.688     0.150
     0.688    13.148     0.150
     0.688    22.674     0.150
     0.688    22.886     0.150
     0.708    13.219     0.150
     0.708    22.209     0.150
     0.717    13.589     0.150
     0.725    13.929     0.150
     0.725    24.238     0.150
     0.725    24.094     0.150
     0.725    13.988     0.150
     0.725    14.206     0.150
     0.725    24.192     0.150
     0.738    13.709     0.150
     0.738    23.559     0.150
     0.738    13.923     0.150
     0.738    24.100     0.150
     0.762    14.579     0.150
     0.762    25.698     0.150
     0.771    14.879     0.150
     0.771    25.759     0.150
     0.773    15.039     0.150
     0.773    26.219     0.150
     0.787    14.938     0.150
     0.787    25.789     0.150
     0.791    14.509     0.150
     0.791    24.869     0.150
     0.791    25.871     0.150
     0.786    14.988     0.150
     0.786    26.369     0.150
     0.805    15.448     0.150
     0.805    27.229     0.150
     0.814    15.619     0.150
     0.814    26.938     0.150
     0.840    15.289     0.150
     0.851    15.889     0.150
     0.851    28.339     0.150
     0.875    16.398     0.150
     0.875    28.219     0.150
     0.889    16.849     0.150
     0.889    29.259     0.150
     0.940    17.339     0.150
     0.940    31.108     0.150
     0.958    18.028     0.150
     0.950    17.909     0.150
     0.950    31.249     0.150
     0.959    17.858     0.150
     0.959    31.659     0.150
     0.968    18.068     0.150
     0.968    32.080     0.150
     1.021    18.278     0.150
     1.054    19.039     0.150
     1.054    32.948     0.150
     1.074    19.108     0.150
     1.074    34.119     0.150
     1.074    19.479     0.150
     1.074    34.738     0.150
     1.088    19.608     0.150
     1.088    34.249     0.150
     1.114    20.229     0.150
     1.134    20.198     0.150
     1.131    20.159     0.150
     1.146    20.789     0.150
     1.145    20.349     0.150
     1.179    37.259     0.150
     1.239    21.698     0.150
     1.268    22.349     0.150
     1.268    40.770     0.150
     1.319    22.969     0.150
     1.351    25.209     0.150
     1.380    24.579     0.150
     1.379    24.229     0.150
     1.379    24.118     0.150
     1.379    44.525     0.150
     1.459    25.169     0.150
     1.469    25.079     0.150
     1.597    29.879     0.150
     1.597    26.638     0.150
     1.647    28.839     0.150
     1.642    27.923     0.150
     1.683    28.979     0.150
     1.714    28.795     0.150
     1.726    29.568     0.150
     1.733    29.619     0.150
     1.862    30.875     0.150
     1.874    31.349     0.150
     1.886    61.104     0.150
     1.908    32.429     0.150
     2.125    34.617     0.150
     2.175    36.079     0.150
     2.178    35.919     0.150
     2.179    34.979     0.150
     2.179    35.125     0.150
     2.228    37.198     0.150
     2.260    40.194     0.150
     2.341    38.259     0.150
     2.373    42.261     0.150
     2.559    39.599     0.150
     2.397    42.556     0.150
     2.453    38.794     0.150
     2.512    41.599     0.150
     2.588    39.249     0.150
     2.621    40.810     0.150
     2.645    41.619     0.150
     2.704    42.092     0.150
     2.800    42.929     0.150
     2.816    53.381     0.150
     3.103    47.687     0.150
     3.151    48.363     0.150
     3.268    49.778     0.150
     3.268    50.031     0.150
     3.285    62.527     0.150
     3.469    54.568     0.150
     3.510    66.213     0.150
     3.551    55.759     0.150
     3.654    56.369     0.150
     3.745    57.801     0.150
     3.915    59.789     0.150
     4.065    61.712     0.150
     4.121    63.559     0.150
     4.174    63.358     0.150
     4.194    64.339     0.150
     4.210    64.729     0.150
     4.210    65.282     0.150
     4.210    64.188     0.150
     4.217    63.849     0.150
     4.272    63.559     0.150
     4.272    64.898     0.150
     4.391    67.339     0.150
     4.447    67.049     0.150
     4.584    69.278     0.150
     4.645    70.969     0.150
     4.782    72.709     0.150
     4.907    74.099     0.150
     4.946    74.679     0.150
     4.973    75.259     0.150
     5.027    75.898     0.150
     5.027    76.665     0.150
     5.058    76.619     0.150
     5.089    77.179     0.150
     5.273    79.229     0.150
     5.273    79.709     0.150
     5.423    81.309     0.150
     5.424    81.648     0.150
     5.520    82.485     0.150
     5.520   173.153     0.150
     5.525    82.858     0.150
     5.636    84.979     0.150
     5.779    86.318     0.150
     5.784    85.219     0.150
     5.826    87.079     0.150
     6.042    89.688     0.150
     6.052    89.698     0.150
     6.671    98.019     0.150
     6.715    98.089     0.150
     6.715    98.429     0.150
     6.761    99.579     0.150
     6.911   101.629     0.150
     7.048   103.089     0.150
     7.150   103.089     0.150
     7.207   105.778     0.150
     7.428   109.387     0.150
     7.428   235.411     0.150
     7.476   108.659     0.150
     7.520   109.769     0.150
     7.530   110.039     0.150
     7.618   111.129     0.150
     7.778   113.179     0.150
     7.849   116.448     0.150
     7.849   243.499     0.150
     8.019   116.278     0.150
    10.610   155.929     0.150
    11.040   157.749     0.150
    11.040   160.278     0.150
    11.040   350.221     0.150
    14.459   205.948     0.150
    14.974   215.473     0.150
    14.974   211.419     0.150
    15.012   212.219     0.150
    20.372   274.909     0.150
    22.007   291.849     0.150
     0.198     4.768     0.150
     0.198     8.868     0.150
     0.208     5.058     0.150
     0.208     8.008     0.150
     0.294     6.338     0.150
     0.294    11.618     0.150
     0.353     6.988     0.150
     0.360     7.138     0.150
     0.391     7.928     0.150
     0.391    13.568     0.150
     0.414     8.108     0.150
     0.410     8.488     0.150
     0.410    14.798     0.150
     0.425     8.098     0.150
     0.425    14.258     0.150
     0.425    14.146     0.150
     0.426     8.648     0.150
     0.426    16.568     0.150
     0.450     9.248     0.150
     0.450    16.388     0.150
     0.446     9.218     0.150
     0.446    16.108     0.150
     0.457     8.928     0.150
     0.457    15.558     0.150
     0.507     9.838     0.150
     0.507    18.368     0.150
     0.542    10.618     0.150
     0.542    19.198     0.150
     0.553    10.978     0.150
     0.553    20.598     0.150
     0.570    11.208     0.150
     0.570    18.858     0.150
     0.636    11.928     0.150
     0.636    20.418     0.150
     0.651    11.898     0.150
     0.651    21.008     0.150
     0.677    12.658     0.150
     0.677    23.338     0.150
     0.671    12.298     0.150
     0.671    21.608     0.150
     0.670    13.106     0.150
     0.674    12.728     0.150
     0.674    22.308     0.150
     0.677    12.758     0.150
     0.677    22.483     0.150
     0.677    22.048     0.150
     0.677    22.229     0.150
     0.705    13.458     0.150
     0.705    22.988     0.150
     0.713    13.138     0.150
     0.719    12.928     0.150
     0.721    13.398     0.150
     0.721    23.198     0.150
     0.730    14.098     0.150
     0.730    24.118     0.150
     0.748    14.418     0.150
     0.748    24.558     0.150
     0.748    24.678     0.150
     0.754    14.138     0.150
     0.754    24.798     0.150
     0.753    14.518     0.150
     0.753    24.888     0.150
     0.769    14.628     0.150
     0.769    25.238     0.150
     0.773    14.838     0.150
     0.773    26.098     0.150
     0.791    15.198     0.150
     0.791    26.588     0.150
     0.804    24.988     0.150
     0.804    14.488     0.150
     0.804    14.383     0.150
     0.804    25.094     0.150
     0.800    15.368     0.150
     0.800    26.458     0.150
     0.846    15.248     0.150
     0.847    15.668     0.150
     0.847    27.618     0.150
     0.863    16.238     0.150
     0.863    27.958     0.150
     0.876    16.408     0.150
     0.876    28.468     0.150
     0.938    17.158     0.150
     0.944    17.618     0.150
     0.942    17.428     0.150
     0.942    30.748     0.150
     0.955    15.908     0.150
     0.986    18.158     0.150
     0.986    17.735     0.150
     1.000    17.738     0.150
     1.000    31.168     0.150
     1.034    18.268     0.150
     1.034    32.058     0.150
     1.054    18.768     0.150
     1.054    33.088     0.150
     1.062    18.958     0.150
     1.062    34.258     0.150
     1.109    19.348     0.150
     1.109    19.878     0.150
     1.109    34.188     0.150
     1.114    19.718     0.150
     1.118    19.658     0.150
     1.132    19.858     0.150
     1.133    19.888     0.150
     1.159    20.178     0.150
     1.219    21.068     0.150
     1.219    37.198     0.150
     1.219    21.200     0.150
     1.219    21.228     0.150
     1.254    21.633     0.150
     1.257    21.998     0.150
     1.257    38.228     0.150
     1.258    21.758     0.150
     1.306    22.268     0.150
     1.325    22.878     0.150
     1.358    23.998     0.150
     1.365    25.078     0.150
     1.360    23.688     0.150
     1.374    24.188     0.150
     1.374    23.936     0.150
     1.374    43.135     0.150
     1.382    24.478     0.150
     1.389    24.298     0.150
     1.446    24.528     0.150
     1.453    24.338     0.150
     1.480    24.727     0.150
     1.602    26.341     0.150
     1.629    27.808     0.150
     1.675    28.668     0.150
     1.723    28.988     0.150
     1.740    27.948     0.150
     1.852    30.466     0.150
     1.852    57.442     0.150
     1.896    32.138     0.150
     2.098    34.338     0.150
     2.169    35.448     0.150
     2.174    67.205     0.150
     2.182    36.388     0.150
     2.216    36.338     0.150
     2.216    36.818     0.150
     2.243    40.051     0.150
     2.243    69.010     0.150
     2.360    38.278     0.150
     2.367    38.378     0.150
     2.361    72.840     0.150
     2.378    72.158     0.150
     2.446    38.386     0.150
     2.446    75.338     0.150
     2.527    41.918     0.150
     2.594    38.898     0.150
     2.640    41.708     0.150
     2.811    42.418     0.150
     2.815    44.838     0.150
     2.977    47.178     0.150
     3.105    47.568     0.150
     3.143    48.130     0.150
     3.231    51.368     0.150
     3.264    51.098     0.150
     3.459    55.748     0.150
     3.662    57.378     0.150
     3.919    61.668     0.150
     4.134    63.508     0.150
     4.179    64.538     0.150
     4.213    65.118     0.150
     4.221    63.758     0.150
     4.228    64.698     0.150
     4.230    65.428     0.150
     4.287    64.348     0.150
     4.287    63.004     0.150
     4.409    67.528     0.150
     4.450    68.598     0.150
     4.589    69.768     0.150
     4.661    70.538     0.150
     4.966    74.388     0.150
     4.991    77.498     0.150
     5.081    75.838     0.150
     5.293    79.448     0.150
     5.439    81.548     0.150
     5.444    80.268     0.150
     5.482    83.288     0.150
     5.524    82.309     0.150
     5.524   175.238     0.150
     5.524    83.318     0.150
     5.543    84.408     0.150
     5.774    86.618     0.150
     5.793    84.758     0.150
     5.798    84.848     0.150
     5.819    86.648     0.150
     5.926    88.448     0.150
     6.046    89.618     0.150
     6.050    90.198     0.150
     6.339    93.708     0.150
     6.712    98.938     0.150
     6.732    98.758     0.150
     6.732    97.886     0.150
     6.763    98.438     0.150
     7.168   106.548     0.150
     7.352   107.138     0.150
     7.359   106.038     0.150
     7.440   110.688     0.150
     7.869   114.783     0.150
     7.869   244.433     0.150
     7.910   113.768     0.150
    10.627   157.188     0.150
    11.054   158.538     0.150
     0.199     8.949     0.150
     0.209     5.109     0.150
     0.209     8.119     0.150
     0.295     6.339     0.150
     0.295    12.099     0.150
     0.355     7.119     0.150
     0.361     7.138     0.150
     0.390    13.529     0.150
     0.412    14.039     0.150
     0.409    14.769     0.150
     0.427     8.779     0.150
     0.424    13.999     0.150
     0.424     8.037     0.150
     0.424    14.119     0.150
     0.452     9.279     0.150
     0.452    16.499     0.150
     0.446    16.299     0.150
     0.459    15.679     0.150
     0.508     9.909     0.150
     0.543    10.659     0.150
     0.543    18.969     0.150
     0.554    20.809     0.150
     0.570    19.289     0.150
     0.636    11.829     0.150
     0.636    20.559     0.150
     0.652    11.958     0.150
     0.672    12.359     0.150
     0.672    21.599     0.150
     0.677    22.829     0.150
     0.674    12.819     0.150
     0.674    22.648     0.150
     0.677    12.839     0.150
     0.677    22.839     0.150
     0.677    22.128     0.150
     0.677    22.299     0.150
     0.677    22.491     0.150
     0.706    13.679     0.150
     0.706    23.029     0.150
     0.706    23.292     0.150
     0.719    13.139     0.150
     0.722    13.469     0.150
     0.722    23.349     0.150
     0.729    24.069     0.150
     0.729    14.098     0.150
     0.729    23.779     0.150
     0.748    24.949     0.150
     0.748    25.208     0.150
     0.755    14.449     0.150
     0.755    14.589     0.150
     0.755    25.089     0.150
     0.754    25.009     0.150
     0.773    26.119     0.150
     0.791    26.479     0.150
     0.804    14.809     0.150
     0.804    24.739     0.150
     0.804    14.437     0.150
     0.804    25.466     0.150
     0.800    26.609     0.150
     0.847    27.938     0.150
     0.863    16.279     0.150
     0.863    27.999     0.150
     0.876    16.569     0.150
     0.876    28.619     0.150
     0.937    30.579     0.150
     0.956    17.648     0.150
     0.943    30.559     0.150
     0.943    17.688     0.150
     0.943    30.259     0.150
     0.985    31.049     0.150
     0.985    18.115     0.150
     1.001    18.279     0.150
     1.001    31.309     0.150
     1.035    18.648     0.150
     1.035    33.009     0.150
     1.055    33.188     0.150
     1.062    34.319     0.150
     1.108    20.148     0.150
     1.108    34.469     0.150
     1.115    19.969     0.150
     1.115    34.639     0.150
     1.115    20.069     0.150
     1.115    36.199     0.150
     1.118    19.859     0.150
     1.143    21.759     0.150
     1.132    20.079     0.150
     1.160    35.688     0.150
     1.219    37.329     0.150
     1.220    21.569     0.150
     1.220    37.205     0.150
     1.220    37.479     0.150
     1.258    22.289     0.150
     1.254    21.755     0.150
     1.259    22.109     0.150
     1.307    22.809     0.150
     1.363    24.969     0.150
     1.373    41.251     0.150
     1.381    24.799     0.150
     1.388    24.329     0.150
     1.479    25.259     0.150
     1.479    26.327     0.150
     1.601    29.719     0.150
     1.630    28.589     0.150
     1.662    47.842     0.150
     1.731    30.458     0.150
     1.731    53.482     0.150
     1.740    30.719     0.150
     1.852    30.530     0.150
     1.852    57.770     0.150
     2.174    66.700     0.150
     2.216    38.559     0.150
     2.243    40.019     0.150
     2.243    68.611     0.150
     2.446    75.167     0.150
     2.811    43.049     0.150
     2.811    42.424     0.150
     3.173    59.779     0.150
     3.370    62.958     0.150
     3.630    68.469     0.150
     3.918    61.619     0.150
     4.132    64.389     0.150
     4.178    63.668     0.150
     4.212    64.729     0.150
     4.220    63.859     0.150
     4.226    65.688     0.150
     4.229    65.569     0.150
     4.287    64.069     0.150
     4.443    67.349     0.150
     4.449    67.139     0.150
     4.660    72.369     0.150
     4.798    74.789     0.150
     4.965    74.519     0.150
     5.080    77.609     0.150
     5.523    82.592     0.150
     5.523   178.119     0.150
     5.796    85.049     0.150
     6.338    93.529     0.150
     6.563    98.279     0.150
     6.732    99.159     0.150
     7.089   104.979     0.150
     7.168   108.049     0.150
     7.351   106.449     0.150
     7.438   231.310     0.150
     7.868   115.014     0.150
     7.868   242.714     0.150
    10.626   155.543     0.150
    11.054   157.737     0.150
     0.151     3.562     0.150
     0.151     7.172     0.150
     0.303     6.062     0.150
     0.303    10.355     0.150
     0.303     9.727     0.150
     0.307     6.262     0.150
     0.307    10.945     0.150
     0.350     7.152     0.150
     0.350    13.023     0.150
     0.347     7.422     0.150
     0.347    13.395     0.150
     0.358     7.664     0.150
     0.358    13.594     0.150
     0.401     8.402     0.150
     0.401    15.555     0.150
     0.441     8.734     0.150
     0.441    15.473     0.150
     0.446     9.035     0.150
     0.446    16.324     0.150
     0.477     9.273     0.150
     0.477    16.215     0.150
     0.507     9.844     0.150
     0.507    17.875     0.150
     0.519    10.152     0.150
     0.519    17.594     0.150
     0.551    10.395     0.150
     0.551    18.113     0.150
     0.542    10.613     0.150
     0.542    18.355     0.150
     0.556    10.215     0.150
     0.556    17.984     0.150
     0.560    11.004     0.150
     0.560    19.582     0.150
     0.569    11.145     0.150
     0.569    20.434     0.150
     0.574    11.184     0.150
     0.574    20.043     0.150
     0.610    19.895     0.150
     0.610    11.465     0.150
     0.652    12.145     0.150
     0.652    20.445     0.150
     0.652    12.305     0.150
     0.676    12.605     0.150
     0.676    22.883     0.150
     0.695    13.215     0.150
     0.695    23.082     0.150
     0.695    22.457     0.150
     0.701    13.133     0.150
     0.701    23.434     0.150
     0.717    13.984     0.150
     0.762    14.164     0.150
     0.762    25.125     0.150
     0.762    14.410     0.150
     0.762    24.824     0.150
     0.805    14.113     0.150
     0.805    25.562     0.150
     0.843    27.105     0.150
     0.843    15.582     0.150
     0.843    15.477     0.150
     0.843    27.422     0.150
     0.879    28.734     0.150
     0.879    16.000     0.150
     0.890    29.082     0.150
     0.903    29.453     0.150
     0.932    30.914     0.150
     0.951    31.562     0.150
     0.953    31.355     0.150
     1.033    33.414     0.150
     1.033    19.090     0.150
     1.033    34.113     0.150
     1.045    18.703     0.150
     1.050    20.262     0.150
     1.059    19.082     0.150
     1.099    19.203     0.150
     1.220    21.004     0.150
     1.310    22.477     0.150
     1.310    40.137     0.150
     1.409    24.984     0.150
     1.407    23.777     0.150
     1.454    27.414     0.150
     1.543    26.105     0.150
     1.586    27.703     0.150
     1.601    28.375     0.150
     1.592    30.043     0.150
     1.592    29.816     0.150
     1.638    30.613     0.150
     1.638    50.672     0.150
     2.019    32.965     0.150
     2.049    32.898     0.150
     2.408    38.355     0.150
     2.281    40.914     0.150
     2.378    73.531     0.150
     2.378    41.203     0.150
     2.763    51.828     0.150
     3.263    49.496     0.150
     3.327    53.633     0.150
     3.433    65.109     0.150
     3.434    65.254     0.150
     3.625    57.973     0.150
     3.790    71.977     0.150
     4.068    77.152     0.150
     4.140    63.094     0.150
     4.140    78.051     0.150
     4.270    64.883     0.150
     4.372    65.922     0.150
     4.440    67.484     0.150
     4.604    69.652     0.150
     5.148    79.512     0.150
     5.515    84.094     0.150
     5.675    85.109     0.150
     5.989    91.242     0.150
     6.597    96.445     0.150
     7.058   105.242     0.150
     7.428   111.484     0.150
     7.775   116.305     0.150
     7.775   245.930     0.150
    10.675   156.285     0.150
     0.058     2.203     0.150
     0.058     4.594     0.150
     0.158     3.867     0.150
     0.158     7.562     0.150
     0.197     4.727     0.150
     0.197     8.547     0.150
     0.201     4.961     0.150
     0.201     9.555     0.150
     0.208     4.523     0.150
     0.208     7.734     0.150
     0.208     8.055     0.150
     0.227     4.977     0.150
     0.260     6.125     0.150
     0.260    11.047     0.150
     0.269     5.797     0.150
     0.364     7.875     0.150
     0.364    13.977     0.150
     0.363     6.992     0.150
     0.363    12.188     0.150
     0.360     7.234     0.150
     0.360    12.648     0.150
     0.384     7.945     0.150
     0.384     7.766     0.150
     0.384    13.992     0.150
     0.456     8.664     0.150
     0.456    15.023     0.150
     0.456     8.711     0.150
     0.465     9.188     0.150
     0.465    16.516     0.150
     0.487     9.188     0.150
     0.487    16.125     0.150
     0.539    10.344     0.150
     0.572    10.953     0.150
     0.572    19.055     0.150
     0.581    11.156     0.150
     0.581    19.477     0.150
     0.604    11.547     0.150
     0.604    11.133     0.150
     0.617    11.508     0.150
     0.617    19.227     0.150
     0.617    19.680     0.150
     0.617    19.523     0.150
     0.621    12.008     0.150
     0.621    21.508     0.150
     0.675    13.031     0.150
     0.675    22.922     0.150
     0.675    22.344     0.150
     0.725    13.695     0.150
     0.734    13.867     0.150
     0.734    23.586     0.150
     0.734    23.836     0.150
     0.740    13.625     0.150
     0.740    24.195     0.150
     0.761    14.398     0.150
     0.761    25.352     0.150
     0.776    14.195     0.150
     0.776    25.422     0.150
     0.791    13.992     0.150
     0.878    15.102     0.150
     0.880    16.016     0.150
     0.889    16.156     0.150
     0.889    29.344     0.150
     0.889    15.938     0.150
     0.940    17.016     0.150
     0.940    30.703     0.150
     0.954    16.734     0.150
     0.977    17.383     0.150
     0.977    31.133     0.150
     0.978    17.656     0.150
     0.987    17.531     0.150
     0.987    32.031     0.150
     0.981    17.672     0.150
     0.981    30.875     0.150
     0.981    17.375     0.150
     0.981    17.977     0.150
     0.981    17.477     0.150
     0.981    31.078     0.150
     1.013    18.023     0.150
     1.031    18.406     0.150
     1.031    32.727     0.150
     1.050    19.031     0.150
     1.050    34.031     0.150
     1.059    18.812     0.150
     1.071    19.242     0.150
     1.079    18.938     0.150
     1.079    33.727     0.150
     1.088    19.078     0.150
     1.088    33.633     0.150
     1.146    20.547     0.150
     1.154    19.938     0.150
     1.154    37.047     0.150
     1.155    20.328     0.150
     1.164    20.547     0.150
     1.192    20.906     0.150
     1.192    36.266     0.150
     1.192    20.711     0.150
     1.192    36.461     0.150
     1.190    20.508     0.150
     1.216    21.492     0.150
     1.216    21.242     0.150
     1.219    21.227     0.150
     1.219    21.086     0.150
     1.219    40.000     0.150
     1.306    22.422     0.150
     1.306    22.547     0.150
     1.306    40.617     0.150
     1.306    22.664     0.150
     1.341    23.031     0.150
     1.348    23.625     0.150
     1.411    24.328     0.150
     1.415    23.961     0.150
     1.454    25.773     0.150
     1.504    25.297     0.150
     1.522    24.703     0.150
     1.567    26.586     0.150
     1.700    27.992     0.150
     1.798    29.094     0.150
     1.942    31.945     0.150
     1.942    31.414     0.150
     1.951    31.352     0.150
     2.274    34.742     0.150
     2.336    37.547     0.150
     2.433    43.211     0.150
     2.433    74.438     0.150
     2.464    38.648     0.150
     2.493    40.328     0.150
     2.525    39.828     0.150
     2.537    38.633     0.150
     2.537    38.531     0.150
     2.533    39.828     0.150
     2.533    47.211     0.150
     2.797    43.742     0.150
     2.968    54.992     0.150
     3.165    48.617     0.150
     3.231    49.672     0.150
     3.323    50.562     0.150
     3.456    52.195     0.150
     3.528    54.102     0.150
     3.601    67.648     0.150
     3.752    56.992     0.150
     3.996    59.961     0.150
     3.996    75.281     0.150
     4.025    76.406     0.150
     4.081    60.688     0.150
     4.287    64.625     0.150
     4.287    64.258     0.150
     4.353    82.500     0.150
     4.363    66.336     0.150
     4.432    67.133     0.150
     4.444    67.211     0.150
     4.606    70.156     0.150
     4.801    71.508     0.150
     4.897    74.305     0.150
     4.918    73.578     0.150
     5.024    76.258     0.150
     5.182    78.312     0.150
     5.353    78.898     0.150
     5.353   102.391     0.150
     5.464    80.445     0.150
     5.459    81.953     0.150
     5.557    81.273     0.150
     5.746    84.992     0.150
     5.777    86.758     0.150
     5.875    87.203     0.150
     5.875   190.008     0.150
     6.084    89.336     0.150
     6.562    95.664     0.150
     7.157   106.094     0.150
     7.259   105.406     0.150
     7.621   112.602     0.150
     7.750   116.352     0.150
     7.750   246.453     0.150
     7.809   113.898     0.150
     7.809   242.125     0.150
     7.821   114.453     0.150
     7.893   115.094     0.150
     8.704   125.008     0.150
    10.815   154.758     0.150
    10.815   339.703     0.150
    10.851   161.305     0.150
     0.056     4.961     0.150
     0.056     2.156     0.150
     0.161     3.828     0.150
     0.161     7.672     0.150
     0.196     4.680     0.150
     0.196     8.656     0.150
     0.203     4.867     0.150
     0.203     5.039     0.150
     0.206     4.461     0.150
     0.206     7.703     0.150
     0.206     7.875     0.150
     0.206     4.617     0.150
     0.269     5.766     0.150
     0.269     5.922     0.150
     0.257     6.148     0.150
     0.257    11.266     0.150
     0.364     6.930     0.150
     0.359     7.148     0.150
     0.359    12.766     0.150
     0.366     7.898     0.150
     0.366    13.820     0.150
     0.366     8.047     0.150
     0.386     8.461     0.150
     0.386    14.836     0.150
     0.387     7.680     0.150
     0.387    14.406     0.150
     0.456     8.688     0.150
     0.456    14.953     0.150
     0.455     8.742     0.150
     0.463     9.531     0.150
     0.463    16.781     0.150
     0.489     9.141     0.150
     0.489    16.227     0.150
     0.545    10.742     0.150
     0.542    10.438     0.150
     0.542    18.883     0.150
     0.542    10.547     0.150
     0.572    10.922     0.150
     0.572    18.477     0.150
     0.572    18.750     0.150
     0.581    11.180     0.150
     0.581    18.922     0.150
     0.581    11.289     0.150
     0.606    11.266     0.150
     0.606    20.789     0.150
     0.606    21.070     0.150
     0.619    12.703     0.150
     0.618    11.562     0.150
     0.618    19.672     0.150
     0.618    19.773     0.150
     0.619    12.102     0.150
     0.619    21.391     0.150
     0.673    13.008     0.150
     0.673    22.711     0.150
     0.732    13.820     0.150
     0.732    23.891     0.150
     0.732    24.047     0.150
     0.732    24.188     0.150
     0.724    13.648     0.150
     0.724    24.352     0.150
     0.738    13.648     0.150
     0.738    24.500     0.150
     0.759    13.891     0.150
     0.759    25.930     0.150
     0.773    14.258     0.150
     0.773    25.359     0.150
     0.794    14.180     0.150
     0.877    16.172     0.150
     0.892    16.008     0.150
     0.892    29.461     0.150
     0.938    17.078     0.150
     0.938    30.680     0.150
     0.952    16.930     0.150
     0.952    30.312     0.150
     0.976    18.086     0.150
     0.976    31.008     0.150
     0.985    17.602     0.150
     0.985    17.711     0.150
     0.985    30.953     0.150
     0.985    31.883     0.150
     0.976    17.617     0.150
     0.979    17.930     0.150
     0.979    30.102     0.150
     0.979    17.266     0.150
     0.979    17.516     0.150
     0.979    30.953     0.150
     1.032    18.508     0.150
     1.032    32.750     0.150
     1.011    18.102     0.150
     1.011    31.922     0.150
     1.048    18.797     0.150
     1.048    33.570     0.150
     1.057    18.836     0.150
     1.068    19.109     0.150
     1.068    34.711     0.150
     1.086    19.141     0.150
     1.086    33.531     0.150
     1.077    19.039     0.150
     1.077    33.492     0.150
     1.144    20.516     0.150
     1.153    20.391     0.150
     1.162    20.578     0.150
     1.154    20.031     0.150
     1.154    36.883     0.150
     1.191    20.852     0.150
     1.191    36.352     0.150
     1.191    36.250     0.150
     1.191    37.758     0.150
     1.188    20.508     0.150
     1.190    20.719     0.150
     1.215    21.453     0.150
     1.215    37.211     0.150
     1.215    21.352     0.150
     1.215    37.602     0.150
     1.215    38.367     0.150
     1.219    21.258     0.150
     1.219    39.172     0.150
     1.271    38.172     0.150
     1.284    22.000     0.150
     1.304    22.289     0.150
     1.304    40.617     0.150
     1.346    23.688     0.150
     1.339    23.297     0.150
     1.383    23.750     0.150
     1.389    23.703     0.150
     1.412    23.930     0.150
     1.408    24.117     0.150
     1.454    25.516     0.150
     1.501    25.688     0.150
     1.501    25.195     0.150
     1.501    48.258     0.150
     1.524    24.977     0.150
     1.654    30.469     0.150
     1.698    27.922     0.150
     1.706    54.242     0.150
     1.796    33.438     0.150
     1.796    29.273     0.150
     1.796    56.953     0.150
     1.942    31.797     0.150
     1.942    31.695     0.150
     1.949    31.516     0.150
     2.208    33.680     0.150
     2.152    67.500     0.150
     2.277    34.797     0.150
     2.337    37.492     0.150
     2.401    42.984     0.150
     2.401    74.836     0.150
     2.430    43.430     0.150
     2.430    75.359     0.150
     2.463    38.523     0.150
     2.493    42.812     0.150
     2.539    38.781     0.150
     2.539    78.297     0.150
     2.525    39.867     0.150
     2.531    39.242     0.150
     2.531    48.391     0.150
     2.638    47.719     0.150
     2.638    80.961     0.150
     2.770    49.656     0.150
     2.770    85.906     0.150
     2.796    43.922     0.150
     2.972    46.242     0.150
     3.230    49.961     0.150
     3.321    50.008     0.150
     3.454    67.258     0.150
     3.454    52.414     0.150
     3.527    54.547     0.150
     3.598    53.969     0.150
     3.749    56.852     0.150
     3.898    59.258     0.150
     3.994    60.562     0.150
     3.994    60.930     0.150
     4.014    77.578     0.150
     4.023    77.727     0.150
     4.084    60.422     0.150
     4.084    60.648     0.150
     4.288    64.812     0.150
     4.288    64.930     0.150
     4.363    66.531     0.150
     4.430    67.086     0.150
     4.443    67.648     0.150
     4.606    70.211     0.150
     4.799    71.312     0.150
     4.896    74.359     0.150
     4.919    74.461     0.150
     4.935    73.781     0.150
     5.023    74.977     0.150
     5.182    78.297     0.150
     5.351    79.602     0.150
     5.351   102.250     0.150
     5.466    80.430     0.150
     5.456    81.312     0.150
     5.559    81.133     0.150
     5.746    86.102     0.150
     5.775    86.477     0.150
     5.830    86.617     0.150
     5.872    87.125     0.150
     6.082    89.578     0.150
     6.161    92.508     0.150
     6.393    95.336     0.150
     6.564    95.797     0.150
     7.158   106.242     0.150
     7.346   108.570     0.150
     7.437   108.078     0.150
     7.499   109.453     0.150
     7.553   109.930     0.150
     7.560   112.289     0.150
     7.748   117.148     0.150
     7.748   129.117     0.150
     7.748   241.672     0.150
     7.810   115.102     0.150
     7.810   241.453     0.150
     8.706   125.289     0.150
    10.817   155.086     0.150
    10.817   340.516     0.150
    10.851   159.609     0.150
    10.851   199.344     0.150
    10.851   344.133     0.150
    15.308   219.781     0.150
     0.179     4.016     0.150
     0.179     7.246     0.150
     0.293     6.406     0.150
     0.293    11.309     0.150
     0.309     6.156     0.150
     0.309    10.777     0.150
     0.345     6.906     0.150
     0.345    11.695     0.150
     0.364     7.277     0.150
     0.364    12.809     0.150
     0.365     7.266     0.150
     0.365    12.418     0.150
     0.365    12.285     0.150
     0.412     8.406     0.150
     0.412    15.738     0.150
     0.412     8.316     0.150
     0.412    14.465     0.150
     0.471     9.117     0.150
     0.471    15.457     0.150
     0.471    15.355     0.150
     0.477     9.809     0.150
     0.477    17.168     0.150
     0.456     8.918     0.150
     0.456    15.457     0.150
     0.488     9.598     0.150
     0.488    16.027     0.150
     0.503     9.809     0.150
     0.503    16.727     0.150
     0.487     9.105     0.150
     0.487    15.215     0.150
     0.498     9.566     0.150
     0.498    16.266     0.150
     0.534    19.918     0.150
     0.501     9.559     0.150
     0.501    16.406     0.150
     0.553    11.027     0.150
     0.553    19.527     0.150
     0.526    10.297     0.150
     0.526    17.426     0.150
     0.526    17.535     0.150
     0.576    11.125     0.150
     0.576    19.105     0.150
     0.596    11.238     0.150
     0.596    19.375     0.150
     0.562    10.988     0.150
     0.562    19.176     0.150
     0.605    11.098     0.150
     0.605    19.207     0.150
     0.572    11.285     0.150
     0.572    18.828     0.150
     0.583    11.465     0.150
     0.583    19.695     0.150
     0.641    12.918     0.150
     0.641    22.066     0.150
     0.644    12.488     0.150
     0.644    21.297     0.150
     0.644    21.586     0.150
     0.658    12.816     0.150
     0.658    21.438     0.150
     0.672    12.797     0.150
     0.672    21.809     0.150
     0.689    13.277     0.150
     0.689    22.875     0.150
     0.756    14.098     0.150
     0.756    23.688     0.150
     0.769    13.996     0.150
     0.769    23.816     0.150
     0.755    14.297     0.150
     0.755    24.867     0.150
     0.756    14.387     0.150
     0.756    24.688     0.150
     0.795    14.598     0.150
     0.795    26.605     0.150
     0.788    14.688     0.150
     0.822    15.125     0.150
     0.822    25.387     0.150
     0.818    15.547     0.150
     0.818    26.066     0.150
     0.866    15.625     0.150
     0.866    28.367     0.150
     0.882    16.168     0.150
     0.882    27.625     0.150
     0.853    16.098     0.150
     0.853    27.098     0.150
     0.858    16.098     0.150
     0.870    16.398     0.150
     0.870    27.906     0.150
     0.906    16.578     0.150
     0.906    28.195     0.150
     0.899    16.816     0.150
     0.899    28.996     0.150
     0.906    16.926     0.150
     0.906    28.766     0.150
     0.940    16.746     0.150
     0.955    17.621     0.150
     0.955    29.648     0.150
     0.976    17.918     0.150
     0.994    18.156     0.150
     1.027    18.688     0.150
     1.036    17.715     0.150
     1.036    32.926     0.150
     1.022    18.707     0.150
     1.022    32.742     0.150
     1.043    18.348     0.150
     1.043    31.738     0.150
     1.043    31.867     0.150
     1.064    19.488     0.150
     1.064    33.277     0.150
     1.029    19.586     0.150
     1.078    19.938     0.150
     1.119    20.746     0.150
     1.119    35.426     0.150
     1.130    20.598     0.150
     1.181    20.855     0.150
     1.181    37.035     0.150
     1.240    21.617     0.150
     1.220    21.605     0.150
     1.248    23.375     0.150
     1.248    39.590     0.150
     1.371    23.035     0.150
     1.569    26.426     0.150
     1.569    49.543     0.150
     1.598    27.051     0.150
     1.668    27.977     0.150
     1.668    52.113     0.150
     1.806    33.754     0.150
     1.862    31.188     0.150
     1.908    58.691     0.150
     1.933    34.352     0.150
     1.928    59.918     0.150
     1.976    31.648     0.150
     1.987    35.215     0.150
     2.006    34.277     0.150
     2.153    38.355     0.150
     2.153    66.414     0.150
     2.145    35.016     0.150
     2.145    67.754     0.150
     2.188    35.000     0.150
     2.295    71.078     0.150
     2.602    44.176     0.150
     2.506    40.477     0.150
     2.576    40.957     0.150
     2.633    44.059     0.150
     2.666    43.328     0.150
     2.760    41.965     0.150
     2.796    43.746     0.150
     2.912    45.016     0.150
     2.978    45.906     0.150
     3.020    46.195     0.150
     3.135    48.477     0.150
     3.263    50.027     0.150
     3.334    51.688     0.150
     3.699    57.047     0.150
     3.895    59.988     0.150
     4.232    64.926     0.150
     4.396    67.617     0.150
     4.405    67.508     0.150
     4.405    67.438     0.150
     4.431    67.746     0.150
     4.481    69.215     0.150
     4.531    68.605     0.150
     4.577    68.117     0.150
     4.823    73.059     0.150
     4.968    74.695     0.150
     4.980    73.715     0.150
     5.028    74.957     0.150
     5.107    77.078     0.150
     5.184    75.938     0.150
     5.232    77.348     0.150
     5.279    77.648     0.150
     5.379    80.137     0.150
     5.451    81.809     0.150
     5.488    84.281     0.150
     5.488   173.637     0.150
     5.488    82.867     0.150
     5.556    81.637     0.150
     5.652    85.258     0.150
     5.727    84.809     0.150
     5.866    85.785     0.150
     5.908    86.945     0.150
     5.924    86.508     0.150
     5.941    87.297     0.150
     6.026    88.508     0.150
     6.098    88.965     0.150
     6.101    90.418     0.150
     6.123    90.246     0.150
     6.283    91.918     0.150
     6.591    96.238     0.150
     6.761    99.176     0.150
     6.988   101.285     0.150
     7.335   106.688     0.150
     7.362   107.125     0.150
     7.406   106.816     0.150
     7.514   107.695     0.150
     7.654   111.695     0.150
     7.708   111.148     0.150
     7.721   111.797     0.150
     7.900   113.297     0.150
     7.934   114.297     0.150
     8.135   117.398     0.150
    10.792   159.375     0.150
     0.137     3.922     0.150
     0.144     3.359     0.150
     0.144     5.461     0.150
     0.208     4.906     0.150
     0.244     4.992     0.150
     0.244     7.500     0.150
     0.244     9.039     0.150
     0.245     5.086     0.150
     0.245     8.891     0.150
     0.276     6.117     0.150
     0.276    11.320     0.150
     0.291     6.547     0.150
     0.316     6.812     0.150
     0.316    12.570     0.150
     0.358     7.398     0.150
     0.358    13.727     0.150
     0.374     7.508     0.150
     0.374    12.562     0.150
     0.402     8.547     0.150
     0.406     8.297     0.150
     0.492    10.086     0.150
     0.492    18.539     0.150
     0.515     9.750     0.150
     0.515    17.258     0.150
     0.523    10.008     0.150
     0.523    17.422     0.150
     0.523    17.312     0.150
     0.545    19.711     0.150
     0.541    10.531     0.150
     0.547    10.297     0.150
     0.547    19.297     0.150
     0.544    10.648     0.150
     0.544    18.852     0.150
     0.557    18.617     0.150
     0.562    20.578     0.150
     0.560    10.992     0.150
     0.560    19.680     0.150
     0.611    11.156     0.150
     0.632    20.852     0.150
     0.632    11.984     0.150
     0.636    21.008     0.150
     0.657    13.047     0.150
     0.657    22.539     0.150
     0.689    13.258     0.150
     0.689    22.711     0.150
     0.713    13.148     0.150
     0.713    23.922     0.150
     0.715    12.383     0.150
     0.715    12.891     0.150
     0.715    22.898     0.150
     0.765    14.039     0.150
     0.765    24.938     0.150
     0.765    13.531     0.150
     0.784    15.062     0.150
     0.784    25.562     0.150
     0.796    26.578     0.150
     0.799    14.688     0.150
     0.799    25.938     0.150
     0.799    14.977     0.150
     0.804    14.383     0.150
     0.822    15.438     0.150
     0.849    26.617     0.150
     0.880    27.633     0.150
     0.880    16.336     0.150
     0.880    28.766     0.150
     0.900    30.180     0.150
     0.972    17.570     0.150
     0.972    31.172     0.150
     0.972    16.859     0.150
     0.980    32.141     0.150
     0.981    17.789     0.150
     0.981    31.609     0.150
     0.988    18.500     0.150
     0.988    31.672     0.150
     0.992    21.117     0.150
     0.992    32.109     0.150
     1.018    18.578     0.150
     1.081    19.297     0.150
     1.081    34.391     0.150
     1.084    19.383     0.150
     1.084    33.758     0.150
     1.082    19.602     0.150
     1.082    34.906     0.150
     1.084    19.281     0.150
     1.084    36.406     0.150
     1.122    19.930     0.150
     1.122    35.977     0.150
     1.153    20.492     0.150
     1.172    20.516     0.150
     1.179    20.609     0.150
     1.179    36.836     0.150
     1.192    21.219     0.150
     1.197    21.203     0.150
     1.197    36.883     0.150
     1.216    38.422     0.150
     1.222    21.172     0.150
     1.232    21.359     0.150
     1.232    39.992     0.150
     1.237    21.320     0.150
     1.237    21.750     0.150
     1.237    38.828     0.150
     1.237    21.648     0.150
     1.237    38.008     0.150
     1.242    21.453     0.150
     1.292    40.547     0.150
     1.309    22.633     0.150
     1.336    22.789     0.150
     1.350    23.688     0.150
     1.350    43.492     0.150
     1.490    26.617     0.150
     1.514    27.117     0.150
     1.526    26.156     0.150
     1.540    26.516     0.150
     1.548    25.828     0.150
     1.618    30.516     0.150
     1.618    51.023     0.150
     1.646    28.258     0.150
     1.707    31.461     0.150
     1.707    53.148     0.150
     1.769    29.812     0.150
     2.405    36.477     0.150
     2.327    38.227     0.150
     2.332    38.438     0.150
     2.432    39.977     0.150
     2.474    44.422     0.150
     2.582    40.188     0.150
     2.645    43.828     0.150
     2.696    41.039     0.150
     2.696    41.320     0.150
     2.696    82.109     0.150
     2.776    52.922     0.150
     2.965    47.547     0.150
     3.070    47.312     0.150
     3.126    50.453     0.150
     3.273    62.203     0.150
     3.361    52.297     0.150
     3.405    53.406     0.150
     3.405    64.977     0.150
     3.414    64.867     0.150
     3.579    55.422     0.150
     3.736    57.797     0.150
     3.807    59.219     0.150
     3.807    72.242     0.150
     4.264    65.438     0.150
     4.281    65.742     0.150
     4.324    65.109     0.150
     4.497    69.156     0.150
     4.600    69.336     0.150
     5.211    78.117     0.150
     5.292    79.641     0.150
     5.576    83.898     0.150
     5.674    86.711     0.150
     5.674   180.406     0.150
     6.664    97.516     0.150
     7.575   239.211     0.150
    10.728   158.031     0.150
     0.121     3.617     0.150
     0.121     6.037     0.150
     0.125     3.057     0.150
     0.125     5.057     0.150
     0.142     3.877     0.150
     0.142     6.527     0.150
     0.197     4.347     0.150
     0.197     7.547     0.150
     0.197     7.357     0.150
     0.269     5.557     0.150
     0.269     9.617     0.150
     0.269     9.297     0.150
     0.269    10.427     0.150
     0.269    10.547     0.150
     0.351    12.167     0.150
     0.351     7.207     0.150
     0.367     7.557     0.150
     0.367    12.587     0.150
     0.372    13.367     0.150
     0.403    13.527     0.150
     0.403     8.007     0.150
     0.403    13.807     0.150
     0.414    13.967     0.150
     0.408    14.257     0.150
     0.427    14.957     0.150
     0.453    14.817     0.150
     0.454     8.767     0.150
     0.454    15.037     0.150
     0.459     9.187     0.150
     0.459    15.497     0.150
     0.501     9.487     0.150
     0.501    16.037     0.150
     0.501    15.697     0.150
     0.501    16.527     0.150
     0.510     9.877     0.150
     0.510    16.557     0.150
     0.498     9.387     0.150
     0.498    15.737     0.150
     0.535    10.457     0.150
     0.557    11.247     0.150
     0.557    19.387     0.150
     0.569    10.727     0.150
     0.569    18.317     0.150
     0.569    18.607     0.150
     0.590    11.297     0.150
     0.590    19.477     0.150
     0.596    11.287     0.150
     0.596    18.777     0.150
     0.596    18.988     0.150
     0.586    11.027     0.150
     0.586    18.887     0.150
     0.595    10.947     0.150
     0.595    18.807     0.150
     0.585    11.047     0.150
     0.585    11.152     0.150
     0.585    18.925     0.150
     0.585    18.997     0.150
     0.600    11.117     0.150
     0.600    19.157     0.150
     0.613    11.647     0.150
     0.613    19.827     0.150
     0.613    20.127     0.150
     0.624    11.717     0.150
     0.624    20.107     0.150
     0.650    22.497     0.150
     0.650    22.327     0.150
     0.647    12.467     0.150
     0.647    21.407     0.150
     0.643    12.377     0.150
     0.643    20.537     0.150
     0.663    12.277     0.150
     0.663    20.867     0.150
     0.663    21.207     0.150
     0.663    21.397     0.150
     0.663    21.457     0.150
     0.659    12.557     0.150
     0.659    21.217     0.150
     0.694    21.607     0.150
     0.694    21.867     0.150
     0.705    23.597     0.150
     0.701    22.287     0.150
     0.739    13.377     0.150
     0.739    23.387     0.150
     0.747    24.897     0.150
     0.747    14.127     0.150
     0.741    23.837     0.150
     0.741    13.900     0.150
     0.741    24.007     0.150
     0.767    14.267     0.150
     0.781    25.457     0.150
     0.803    15.067     0.150
     0.803    26.057     0.150
     0.817    15.147     0.150
     0.817    28.157     0.150
     0.843    15.727     0.150
     0.843    27.297     0.150
     0.855    15.567     0.150
     0.855    27.277     0.150
     0.855    26.807     0.150
     0.868    16.597     0.150
     0.868    28.007     0.150
     0.914    29.277     0.150
     0.940    16.937     0.150
     0.925    28.877     0.150
     0.928    16.777     0.150
     0.928    29.027     0.150
     0.966    17.367     0.150
     0.996    17.544     0.150
     1.020    18.957     0.150
     1.020    19.247     0.150
     1.076    19.857     0.150
     1.076    34.287     0.150
     1.117    20.267     0.150
     1.161    36.927     0.150
     1.161    21.695     0.150
     1.235    38.467     0.150
     1.238    22.167     0.150
     1.238    21.027     0.150
     1.294    22.917     0.150
     1.293    23.337     0.150
     1.321    40.777     0.150
     1.304    23.687     0.150
     1.304    41.347     0.150
     1.347    24.367     0.150
     1.396    23.113     0.150
     1.426    25.337     0.150
     1.444    44.587     0.150
     1.456    26.347     0.150
     1.457    25.607     0.150
     1.457    45.019     0.150
     1.498    25.078     0.150
     1.498    46.597     0.150
     1.611    27.218     0.150
     1.611    50.233     0.150
     1.635    27.453     0.150
     1.635    48.754     0.150
     1.673    28.229     0.150
     1.743    28.367     0.150
     1.742    30.067     0.150
     1.762    29.161     0.150
     1.762    55.065     0.150
     1.766    32.041     0.150
     1.766    55.468     0.150
     1.858    31.927     0.150
     1.890    33.440     0.150
     1.890    58.818     0.150
     2.073    35.477     0.150
     2.128    35.219     0.150
     2.128    65.600     0.150
     2.156    35.237     0.150
     2.156    67.801     0.150
     2.233    35.776     0.150
     2.233    69.838     0.150
     2.263    35.884     0.150
     2.263    70.408     0.150
     2.318    36.237     0.150
     2.320    37.194     0.150
     2.320    71.861     0.150
     2.361    38.577     0.150
     2.362    37.878     0.150
     2.362    72.695     0.150
     2.520    40.102     0.150
     2.520    77.738     0.150
     2.550    40.287     0.150
     2.550    39.894     0.150
     2.550    71.693     0.150
     2.760    43.021     0.150
     2.819    44.247     0.150
     2.899    45.467     0.150
     2.897    45.177     0.150
     2.978    56.141     0.150
     2.978    91.007     0.150
     3.015    45.127     0.150
     3.009    46.637     0.150
     2.992    47.127     0.150
     2.992    46.919     0.150
     2.992    91.637     0.150
     3.010    47.004     0.150
     3.012    46.987     0.150
     3.026    47.237     0.150
     3.262    50.437     0.150
     3.260    50.906     0.150
     3.325    49.357     0.150
     3.325    49.695     0.150
     3.317    51.329     0.150
     3.432    53.225     0.150
     3.514    54.127     0.150
     3.528    54.691     0.150
     3.629    55.687     0.150
     3.788    58.207     0.150
     3.788    58.501     0.150
     3.898    60.257     0.150
     3.898    60.370     0.150
     4.182    64.207     0.150
     4.384    66.117     0.150
     4.518    69.387     0.150
     4.593    69.697     0.150
     4.686    69.467     0.150
     4.749    71.657     0.150
     4.840    72.737     0.150
     4.840    73.145     0.150
     4.878    71.547     0.150
     4.878    71.949     0.150
     4.859    73.416     0.150
     4.942    74.347     0.150
     4.944    74.427     0.150
     5.072    75.677     0.150
     5.066    75.267     0.150
     5.226    78.287     0.150
     5.232    78.897     0.150
     5.232    78.393     0.150
     5.436    81.377     0.150
     5.436    81.147     0.150
     5.465    82.232     0.150
     5.465   172.582     0.150
     5.607    83.097     0.150
     5.929   110.957     0.150
     6.022    89.317     0.150
     6.085    89.307     0.150
     6.355    92.247     0.150
     7.285   107.047     0.150
     7.348   107.077     0.150
     7.639   111.153     0.150
     7.639   239.252     0.150
     8.511   122.252     0.150
     8.511   264.202     0.150
     9.884   312.912     0.150
    11.037   157.837     0.150
    11.037   159.277     0.150
    11.037   160.807     0.150
    11.612   165.097     0.150
    11.612   166.376     0.150
    29.379   361.573     0.150
    36.687   427.612     0.150
     0.074     3.016     0.150
     0.074     5.133     0.150
     0.100     3.414     0.150
     0.100     6.297     0.150
     0.125     3.023     0.150
     0.125     3.414     0.150
     0.125     5.695     0.150
     0.126     3.375     0.150
     0.126     5.680     0.150
     0.121     3.750     0.150
     0.121     6.695     0.150
     0.128     3.797     0.150
     0.128     6.305     0.150
     0.190     3.805     0.150
     0.240     4.977     0.150
     0.240     8.227     0.150
     0.199     4.836     0.150
     0.199     8.211     0.150
     0.219     4.891     0.150
     0.219     8.555     0.150
     0.315     6.500     0.150
     0.315    11.047     0.150
     0.372     7.445     0.150
     0.372    12.977     0.150
     0.419    13.875     0.150
     0.391     8.016     0.150
     0.391    13.633     0.150
     0.443    15.156     0.150
     0.453    15.414     0.150
     0.455    15.109     0.150
     0.461    15.320     0.150
     0.566    10.859     0.150
     0.566    18.594     0.150
     0.606    11.484     0.150
     0.606    19.289     0.150
     0.583    19.156     0.150
     0.579    11.070     0.150
     0.579    18.906     0.150
     0.577    11.555     0.150
     0.577    19.672     0.150
     0.663    20.922     0.150
     0.663    12.500     0.150
     0.663    20.969     0.150
     0.669    21.961     0.150
     0.689    12.656     0.150
     0.761    14.234     0.150
     0.761    24.211     0.150
     0.759    13.914     0.150
     0.733    14.242     0.150
     0.782    14.297     0.150
     0.782    24.305     0.150
     0.782    14.312     0.150
     0.782    24.070     0.150
     0.812    24.961     0.150
     0.812    14.391     0.150
     0.812    25.367     0.150
     0.777    14.266     0.150
     0.780    25.102     0.150
     0.812    14.625     0.150
     0.812    25.156     0.150
     0.823    14.930     0.150
     0.823    25.391     0.150
     0.809    15.047     0.150
     0.809    25.602     0.150
     0.838    25.750     0.150
     0.866    15.633     0.150
     0.829    15.562     0.150
     0.829    26.492     0.150
     0.829    25.914     0.150
     0.837    27.125     0.150
     0.837    15.992     0.150
     0.837    27.250     0.150
     0.881    15.984     0.150
     0.881    27.273     0.150
     0.857    16.383     0.150
     0.900    16.242     0.150
     0.900    28.477     0.150
     0.908    28.391     0.150
     0.908    16.492     0.150
     0.908    28.594     0.150
     0.920    16.359     0.150
     0.912    16.336     0.150
     0.927    16.633     0.150
     0.896    17.273     0.150
     0.962    31.625     0.150
     0.962    18.875     0.150
     0.980    17.086     0.150
     0.985    17.625     0.150
     0.978    18.180     0.150
     1.010    18.742     0.150
     1.010    31.609     0.150
     1.082    19.500     0.150
     1.086    19.953     0.150
     1.094    20.242     0.150
     1.094    34.180     0.150
     1.185    21.164     0.150
     1.185    36.633     0.150
     1.164    21.172     0.150
     1.207    21.930     0.150
     1.207    21.773     0.150
     1.207    37.773     0.150
     1.231    22.375     0.150
     1.317    22.508     0.150
     1.317    41.727     0.150
     1.340    23.633     0.150
     1.340    43.000     0.150
     1.434    26.945     0.150
     1.434    45.875     0.150
     1.469    25.164     0.150
     1.469    46.070     0.150
     1.501    26.797     0.150
     1.546    27.125     0.150
     1.592    26.906     0.150
     1.592    49.602     0.150
     1.627    28.016     0.150
     1.680    27.383     0.150
     1.693    30.156     0.150
     1.693    52.969     0.150
     1.780    29.914     0.150
     1.780    51.953     0.150
     1.819    30.766     0.150
     1.819    57.305     0.150
     1.849    31.016     0.150
     1.849    57.859     0.150
     1.997    35.781     0.150
     1.997    62.516     0.150
     2.021    32.961     0.150
     2.021    62.711     0.150
     2.069    34.523     0.150
     2.132    66.047     0.150
     2.186    39.086     0.150
     2.148    35.281     0.150
     2.148    66.688     0.150
     2.203    68.859     0.150
     2.416    38.484     0.150
     2.407    75.383     0.150
     2.482    39.531     0.150
     2.515    77.750     0.150
     2.701    42.492     0.150
     2.680    42.898     0.150
     2.680    83.352     0.150
     2.688    42.680     0.150
     2.700    84.273     0.150
     2.802    45.375     0.150
     2.958    45.281     0.150
     3.203    49.742     0.150
     3.292    50.211     0.150
     3.819   103.391     0.150
     4.537    69.312     0.150
     4.699    69.500     0.150
     4.902    73.836     0.150
     5.134    75.297     0.150
    14.762   207.164     0.150
     0.072     4.615     0.150
     0.159     3.745     0.150
     0.159     6.495     0.150
     0.211     4.895     0.150
     0.211     8.665     0.150
     0.275     5.435     0.150
     0.275     9.385     0.150
     0.283     5.895     0.150
     0.283    10.215     0.150
     0.283    10.100     0.150
     0.327     6.385     0.150
     0.327    11.015     0.150
     0.327     6.515     0.150
     0.327     6.203     0.150
     0.327     6.475     0.150
     0.327    10.865     0.150
     0.384     7.695     0.150
     0.384    13.235     0.150
     0.383     7.594     0.150
     0.383    12.875     0.150
     0.375     7.435     0.150
     0.375    12.705     0.150
     0.448     8.895     0.150
     0.448    15.284     0.150
     0.434    15.044     0.150
     0.438    14.635     0.150
     0.483    16.054     0.150
     0.493    16.185     0.150
     0.513    17.084     0.150
     0.610    11.685     0.150
     0.610    19.594     0.150
     0.549    10.655     0.150
     0.549    17.955     0.150
     0.603    11.574     0.150
     0.603    19.274     0.150
     0.601    11.505     0.150
     0.601    19.975     0.150
     0.654    21.284     0.150
     0.630    20.344     0.150
     0.698    13.475     0.150
     0.698    23.544     0.150
     0.670    21.314     0.150
     0.663    12.695     0.150
     0.663    22.354     0.150
     0.669    22.554     0.150
     0.727    14.015     0.150
     0.727    23.975     0.150
     0.744    14.304     0.150
     0.744    25.155     0.150
     0.721    23.455     0.150
     0.696    13.225     0.150
     0.696    23.084     0.150
     0.772    14.895     0.150
     0.772    24.715     0.150
     0.772    25.328     0.150
     0.767    14.635     0.150
     0.767    24.875     0.150
     0.769    14.475     0.150
     0.769    25.334     0.150
     0.792    14.834     0.150
     0.792    25.205     0.150
     0.867    16.405     0.150
     0.867    27.215     0.150
     0.835    15.505     0.150
     0.835    26.515     0.150
     0.842    16.125     0.150
     0.842    28.115     0.150
     0.904    16.844     0.150
     0.904    29.995     0.150
     0.876    16.165     0.150
     0.876    27.794     0.150
     0.908    17.023     0.150
     0.908    29.344     0.150
     0.957    17.665     0.150
     0.957    29.794     0.150
     1.008    18.645     0.150
     1.008    32.093     0.150
     1.028    19.194     0.150
     1.028    32.494     0.150
     1.067    18.615     0.150
     1.067    32.529     0.150
     1.023    19.012     0.150
     1.023    32.298     0.150
     1.103    20.661     0.150
     1.103    36.135     0.150
     1.152    21.115     0.150
     1.152    36.979     0.150
     1.218    22.054     0.150
     1.218    37.695     0.150
     1.218    21.917     0.150
     1.270    22.685     0.150
     1.270    39.544     0.150
     1.279    22.314     0.150
     1.330    23.505     0.150
     1.368    23.895     0.150
     1.435    25.385     0.150
     1.435    45.861     0.150
     1.509    28.115     0.150
     1.522    25.435     0.150
     1.522    25.303     0.150
     1.533    27.024     0.150
     1.548    26.688     0.150
     1.548    49.333     0.150
     1.565    27.975     0.150
     1.627    27.925     0.150
     1.646    27.503     0.150
     1.646    51.244     0.150
     1.652    29.383     0.150
     1.652    50.080     0.150
     1.725    30.284     0.150
     1.680    28.510     0.150
     1.680    52.557     0.150
     1.700    30.420     0.150
     1.700    53.052     0.150
     1.818    31.930     0.150
     1.818    54.990     0.150
     1.852    30.378     0.150
     1.852    58.200     0.150
     1.861    31.564     0.150
     1.936    32.255     0.150
     1.916    32.003     0.150
     1.916    60.370     0.150
     1.976    32.784     0.150
     1.976    62.864     0.150
     2.065    33.995     0.150
     2.089    34.334     0.150
     2.104    38.188     0.150
     2.104    65.425     0.150
     2.173    35.834     0.150
     2.279    37.115     0.150
     2.333    37.515     0.150
     2.338    37.927     0.150
     2.338    73.547     0.150
     2.430    37.885     0.150
     2.393    38.422     0.150
     2.393    74.969     0.150
     2.480    39.905     0.150
     2.510    40.695     0.150
     2.562    46.645     0.150
     2.580    41.093     0.150
     2.580    81.096     0.150
     2.751    44.354     0.150
     2.748    45.024     0.150
     2.896    46.353     0.150
     2.970    47.119     0.150
     3.042    47.522     0.150
     3.309    49.515     0.150
     3.185    50.324     0.150
     3.185    50.790     0.150
     3.458    54.385     0.150
     3.544    53.365     0.150
     3.544    53.555     0.150
     3.493    53.987     0.150
     3.746    69.625     0.150
     3.870    60.165     0.150
     3.980    61.425     0.150
     4.210    64.985     0.150
     4.228    63.846     0.150
     4.378    65.820     0.150
     4.460    67.864     0.150
     4.777    73.017     0.150
     4.777   151.156     0.150
     4.918    71.961     0.150
     6.863   100.136     0.150
     6.868   102.301     0.150
     6.868   213.133     0.150
     7.288   106.544     0.150
     7.812   114.658     0.150
     7.812   114.463     0.150
     8.217   120.305     0.150
     8.217   119.569     0.150
     8.217   254.688     0.150
     9.473   136.344     0.150
    10.304   151.695     0.150
    11.715   167.761     0.150
    14.344   204.591     0.150
    22.170   297.102     0.150
    36.029   422.794     0.150
     0.156     3.749     0.150
     0.156     6.429     0.150
     0.256     5.319     0.150
     0.256     9.309     0.150
     0.259     5.079     0.150
     0.259     5.371     0.150
     0.259     9.423     0.150
     0.266     5.458     0.150
     0.266     9.409     0.150
     0.284     6.229     0.150
     0.284    10.989     0.150
     0.274     5.799     0.150
     0.274    10.069     0.150
     0.308     6.418     0.150
     0.308    11.429     0.150
     0.324     6.739     0.150
     0.324    11.479     0.150
     0.329     6.869     0.150
     0.329    12.179     0.150
     0.348     6.969     0.150
     0.348    12.029     0.150
     0.370     7.668     0.150
     0.370    13.148     0.150
     0.397     7.909     0.150
     0.397    13.369     0.150
     0.406     8.108     0.150
     0.406    13.769     0.150
     0.419     8.069     0.150
     0.419    13.938     0.150
     0.458     9.029     0.150
     0.458    15.569     0.150
     0.477     9.708     0.150
     0.477    17.119     0.150
     0.483    10.069     0.150
     0.483    17.779     0.150
     0.473     9.299     0.150
     0.473    16.019     0.150
     0.507     9.799     0.150
     0.507    16.668     0.150
     0.573    10.999     0.150
     0.573    19.249     0.150
     0.557    10.829     0.150
     0.557    18.958     0.150
     0.589    11.049     0.150
     0.610    11.329     0.150
     0.610    19.838     0.150
     0.610    20.041     0.150
     0.592    11.429     0.150
     0.592    20.119     0.150
     0.637    12.029     0.150
     0.637    20.708     0.150
     0.599    11.389     0.150
     0.599    19.429     0.150
     0.659    12.499     0.150
     0.659    23.179     0.150
     0.648    12.188     0.150
     0.648    20.659     0.150
     0.659    12.579     0.150
     0.659    21.338     0.150
     0.665    12.119     0.150
     0.665    20.889     0.150
     0.658    12.349     0.150
     0.658    21.199     0.150
     0.677    12.438     0.150
     0.677    21.309     0.150
     0.669    12.489     0.150
     0.669    21.449     0.150
     0.696    12.958     0.150
     0.696    23.668     0.150
     0.682    12.929     0.150
     0.682    22.299     0.150
     0.720    13.199     0.150
     0.754    13.929     0.150
     0.754    24.168     0.150
     0.754    23.952     0.150
     0.754    13.958     0.150
     0.754    24.249     0.150
     0.774    24.219     0.150
     0.774    14.299     0.150
     0.788    14.458     0.150
     0.788    27.648     0.150
     0.789    26.929     0.150
     0.778    14.529     0.150
     0.778    25.188     0.150
     0.778    14.417     0.150
     0.777    14.838     0.150
     0.777    25.819     0.150
     0.805    14.188     0.150
     0.805    25.829     0.150
     0.807    15.489     0.150
     0.807    27.519     0.150
     0.814    14.819     0.150
     0.814    25.398     0.150
     0.841    15.039     0.150
     0.841    26.092     0.150
     0.841    15.108     0.150
     0.841    26.019     0.150
     0.847    15.279     0.150
     0.847    26.279     0.150
     0.859    15.769     0.150
     0.859    26.769     0.150
     0.882    15.269     0.150
     0.877    15.958     0.150
     0.877    27.418     0.150
     0.876    16.069     0.150
     0.876    27.769     0.150
     0.904    16.789     0.150
     0.923    16.329     0.150
     0.928    16.869     0.150
     0.943    17.039     0.150
     0.977    17.479     0.150
     0.977    18.289     0.150
     1.013    18.838     0.150
     1.013    18.703     0.150
     1.013    32.695     0.150
     1.042    17.958     0.150
     1.036    19.099     0.150
     1.083    19.469     0.150
     1.080    19.479     0.150
     1.229    21.055     0.150
     1.229    38.277     0.150
     1.281    20.628     0.150
     1.279    21.299     0.150
     1.412    23.659     0.150
     1.414    24.265     0.150
     1.414    44.126     0.150
     1.436    24.509     0.150
     1.436    43.261     0.150
     1.495    26.219     0.150
     1.489    25.018     0.150
     1.489    46.662     0.150
     1.525    24.878     0.150
     1.548    26.749     0.150
     1.591    26.926     0.150
     1.697    27.720     0.150
     1.697    52.482     0.150
     1.754    29.499     0.150
     1.770    28.833     0.150
     1.770    54.316     0.150
     1.900    33.773     0.150
     1.900    58.319     0.150
     1.958    31.361     0.150
     1.958    60.855     0.150
     1.953    31.688     0.150
     1.953    31.849     0.150
     1.953    61.356     0.150
     2.014    32.013     0.150
     2.014    62.719     0.150
     2.040    32.779     0.150
     2.047    33.091     0.150
     2.047    63.665     0.150
     2.065    33.268     0.150
     2.065    65.098     0.150
     2.215    34.199     0.150
     2.262    36.979     0.150
     2.356    41.371     0.150
     2.378    37.792     0.150
     2.504    39.194     0.150
     2.612    40.779     0.150
     2.620    41.418     0.150
     2.628    41.039     0.150
     2.825    40.599     0.150
     2.704    41.469     0.150
     2.704    41.597     0.150
     2.720    42.403     0.150
     2.806    43.188     0.150
     2.837    44.098     0.150
     2.892    45.019     0.150
     2.990    46.239     0.150
     3.014    45.128     0.150
     3.010    47.139     0.150
     3.105    47.810     0.150
     3.246    50.309     0.150
     3.270    49.139     0.150
     3.270    48.994     0.150
     3.276    50.278     0.150
     3.355    51.965     0.150
     3.377    51.544     0.150
     3.406    53.049     0.150
     3.980    61.039     0.150
     4.168    62.838     0.150
     4.199    63.668     0.150
     4.269    65.769     0.150
     4.395    66.128     0.150
     4.391    66.019     0.150
     4.475    67.799     0.150
     4.589    69.688     0.150
     4.604    69.759     0.150
     4.655    69.949     0.150
     4.735    70.878     0.150
     4.764    70.479     0.150
     4.764    69.875     0.150
     4.793    72.188     0.150
     4.802    70.799     0.150
     4.947    74.029     0.150
     4.983    74.719     0.150
     4.983    73.119     0.150
     5.171    76.229     0.150
     5.193    77.759     0.150
     5.286    79.148     0.150
     5.286    78.503     0.150
     5.397    80.128     0.150
     5.399    80.179     0.150
     5.502    82.929     0.150
     5.529    82.809     0.150
     5.702    83.062     0.150
     5.762    85.208     0.150
     5.819    86.349     0.150
     6.072    90.208     0.150
     6.407    94.108     0.150
     6.711    98.269     0.150
     7.207   104.619     0.150
     7.207   104.374     0.150
     7.390   107.838     0.150
     7.390   108.694     0.150
     7.390   123.154     0.150
     7.390   232.179     0.150
     7.429   108.688     0.150
     7.429   108.350     0.150
     7.710   112.199     0.150
     7.718   111.819     0.150
     7.734   113.029     0.150
     7.865   115.088     0.150
     7.994   115.659     0.150
     8.303   119.938     0.150
     8.303   259.873     0.150
     9.369   133.039     0.150
     9.485   136.989     0.150
     9.756   307.287     0.150
    10.759   156.419     0.150
    15.107   213.809     0.150
    15.368   216.759     0.150
    15.929   224.958     0.150
    19.631   268.849     0.150
     0.106     2.702     0.150
     0.157     2.962     0.150
     0.157     5.207     0.150
     0.175     3.662     0.150
     0.225     5.012     0.150
     0.225     9.152     0.150
     0.292     6.362     0.150
     0.299     6.662     0.150
     0.304     6.582     0.150
     0.347     7.122     0.150
     0.347     7.512     0.150
     0.347    13.592     0.150
     0.342     6.972     0.150
     0.411     7.742     0.150
     0.411    13.462     0.150
     0.458    17.112     0.150
     0.436    14.482     0.150
     0.436     8.311     0.150
     0.436    14.381     0.150
     0.478    10.232     0.150
     0.478    18.462     0.150
     0.447     8.864     0.150
     0.447    15.267     0.150
     0.460     9.122     0.150
     0.460    15.562     0.150
     0.473     9.622     0.150
     0.473    15.922     0.150
     0.535    10.852     0.150
     0.590    11.762     0.150
     0.590    20.722     0.150
     0.596    11.692     0.150
     0.596    21.142     0.150
     0.618    11.872     0.150
     0.617    12.362     0.150
     0.691    22.862     0.150
     0.705    13.352     0.150
     0.705    24.182     0.150
     0.715    13.472     0.150
     0.715    22.922     0.150
     0.715    23.082     0.150
     0.697    13.172     0.150
     0.697    22.362     0.150
     0.701    13.407     0.150
     0.708    13.502     0.150
     0.708    23.002     0.150
     0.708    13.802     0.150
     0.708    13.276     0.150
     0.731    13.652     0.150
     0.731    23.552     0.150
     0.752    14.052     0.150
     0.775    15.132     0.150
     0.829    15.092     0.150
     0.844    27.702     0.150
     0.843    26.762     0.150
     0.853    27.512     0.150
     0.871    16.892     0.150
     0.871    28.212     0.150
     0.925    16.632     0.150
     0.925    29.012     0.150
     0.941    17.472     0.150
     0.941    17.335     0.150
     0.941    30.518     0.150
     0.912    28.652     0.150
     0.966    17.892     0.150
     0.956    30.012     0.150
     0.968    18.002     0.150
     0.968    31.222     0.150
     0.978    18.092     0.150
     1.003    18.452     0.150
     1.003    32.036     0.150
     1.003    18.432     0.150
     1.052    19.452     0.150
     1.078    19.802     0.150
     1.079    19.632     0.150
     1.095    20.772     0.150
     1.190    21.065     0.150
     1.190    38.156     0.150
     1.276    22.098     0.150
     1.276    39.605     0.150
     1.362    25.092     0.150
     1.340    24.732     0.150
     1.457    24.957     0.150
     1.457    46.578     0.150
     1.668    29.782     0.150
     1.735    28.851     0.150
     1.797    29.830     0.150
     1.862    57.874     0.150
     1.939    59.632     0.150
     2.017    63.030     0.150
     2.083    37.276     0.150
     2.083    64.489     0.150
     2.112    34.777     0.150
     2.112    61.546     0.150
     2.391    37.832     0.150
     2.201    36.643     0.150
     2.333    71.740     0.150
     2.352    39.362     0.150
     2.499    46.086     0.150
     2.499    77.258     0.150
     2.649    43.112     0.150
     2.713    45.552     0.150
     2.806    45.282     0.150
     2.796    51.324     0.150
     2.796    86.812     0.150
     2.854    44.452     0.150
     2.854    43.517     0.150
     2.854    77.366     0.150
     2.848    52.934     0.150
     3.001    46.702     0.150
     3.178    49.342     0.150
     3.170    59.704     0.150
     3.257    50.640     0.150
     3.441    64.724     0.150
     3.449    53.412     0.150
     3.485    65.469     0.150
     3.496    54.312     0.150
     3.768    58.672     0.150
     3.977    61.312     0.150
     4.101    63.152     0.150
     4.402    67.152     0.150
     4.395    66.712     0.150
     4.501    68.612     0.150
     4.516    68.282     0.150
     5.696    87.868     0.150
     5.696   179.482     0.150
     7.691   114.982     0.150
     7.691   128.357     0.150
     7.691   240.257     0.150
    10.915   159.832     0.150
     0.154     3.805     0.150
     0.154     6.406     0.150
     0.211     4.977     0.150
     0.211     8.523     0.150
     0.280     5.633     0.150
     0.282     5.953     0.150
     0.282     9.992     0.150
     0.282    10.141     0.150
     0.292     5.953     0.150
     0.332     6.484     0.150
     0.332     6.664     0.150
     0.332    11.211     0.150
     0.332    11.047     0.150
     0.335     6.602     0.150
     0.370     7.406     0.150
     0.370    12.617     0.150
     0.387     7.633     0.150
     0.387    12.773     0.150
     0.387     7.781     0.150
     0.387    13.492     0.150
     0.439    15.156     0.150
     0.443    14.984     0.150
     0.450     8.961     0.150
     0.450    15.242     0.150
     0.487     9.594     0.150
     0.487    15.781     0.150
     0.497    16.227     0.150
     0.518    17.031     0.150
     0.545    10.758     0.150
     0.545    18.695     0.150
     0.552    10.734     0.150
     0.552    18.211     0.150
     0.611    11.742     0.150
     0.611    19.797     0.150
     0.598    11.555     0.150
     0.598    20.070     0.150
     0.605    11.633     0.150
     0.605    19.578     0.150
     0.633    20.453     0.150
     0.659    21.211     0.150
     0.663    12.703     0.150
     0.663    22.664     0.150
     0.668    12.633     0.150
     0.668    21.852     0.150
     0.673    21.656     0.150
     0.696    22.695     0.150
     0.702    13.695     0.150
     0.702    23.492     0.150
     0.725    13.953     0.150
     0.725    23.531     0.150
     0.732    14.148     0.150
     0.732    24.258     0.150
     0.747    14.383     0.150
     0.747    25.594     0.150
     0.768    14.461     0.150
     0.768    25.312     0.150
     0.772    14.727     0.150
     0.772    25.047     0.150
     0.774    14.945     0.150
     0.774    25.977     0.150
     0.774    25.156     0.150
     0.794    14.914     0.150
     0.794    25.156     0.150
     0.794    25.414     0.150
     0.816    15.703     0.150
     0.835    15.555     0.150
     0.835    26.586     0.150
     0.841    15.547     0.150
     0.841    28.195     0.150
     0.876    27.805     0.150
     0.908    30.078     0.150
     0.903    29.031     0.150
     0.903    17.023     0.150
     0.903    29.625     0.150
     0.942    17.703     0.150
     0.942    30.211     0.150
     0.959    17.852     0.150
     1.007    18.594     0.150
     1.007    32.125     0.150
     1.019    19.000     0.150
     1.019    32.219     0.150
     1.033    19.273     0.150
     1.033    32.789     0.150
     1.071    18.750     0.150
     1.071    32.938     0.150
     1.099    20.836     0.150
     1.099    35.789     0.150
     1.151    21.172     0.150
     1.151    36.742     0.150
     1.222    21.766     0.150
     1.222    21.867     0.150
     1.222    37.656     0.150
     1.275    22.492     0.150
     1.284    22.266     0.150
     1.373    24.453     0.150
     1.430    25.445     0.150
     1.430    24.977     0.150
     1.430    45.789     0.150
     1.509    25.258     0.150
     1.525    25.398     0.150
     1.525    25.133     0.150
     1.538    26.961     0.150
     1.538    47.242     0.150
     1.543    25.742     0.150
     1.543    48.898     0.150
     1.564    27.281     0.150
     1.632    27.961     0.150
     1.643    27.305     0.150
     1.643    51.461     0.150
     1.653    27.789     0.150
     1.653    51.023     0.150
     1.678    28.523     0.150
     1.678    52.469     0.150
     1.699    30.312     0.150
     1.699    53.078     0.150
     1.820    30.031     0.150
     1.820    55.984     0.150
     1.850    30.422     0.150
     1.850    57.469     0.150
     1.912    34.711     0.150
     1.912    60.227     0.150
     1.971    62.258     0.150
     2.070    34.656     0.150
     2.083    34.258     0.150
     2.102    37.969     0.150
     2.168    35.531     0.150
     2.274    37.008     0.150
     2.333    38.078     0.150
     2.333    73.305     0.150
     2.391    38.648     0.150
     2.391    74.727     0.150
     2.432    37.383     0.150
     2.506    39.984     0.150
     2.575    49.555     0.150
     2.746    44.242     0.150
     2.746    44.227     0.150
     2.856    49.961     0.150
     2.872    45.695     0.150
     2.892    45.727     0.150
     2.967    50.508     0.150
     3.041    47.609     0.150
     3.180    50.555     0.150
     3.547    53.367     0.150
     3.626    56.602     0.150
     3.690    57.406     0.150
     4.141    63.477     0.150
     4.376    66.883     0.150
     4.376    67.023     0.150
     4.455    68.289     0.150
     4.772    72.305     0.150
     4.772    72.711     0.150
     4.772   149.055     0.150
     4.796    71.172     0.150
     4.919    71.867     0.150
     5.568    83.961     0.150
     6.863   102.133     0.150
     7.289   106.555     0.150
     8.216   119.297     0.150
     8.216   254.820     0.150
     9.473   136.352     0.150
    10.299   148.211     0.150
    11.319   161.445     0.150
    11.716   167.758     0.150
    36.024   422.648     0.150
     0.055     1.172     0.150
     0.055     3.297     0.150
     0.105     2.500     0.150
     0.105     5.531     0.150
     0.149     4.148     0.150
     0.149     7.812     0.150
     0.225     4.688     0.150
     0.225     6.945     0.150
     0.229     4.859     0.150
     0.286     6.336     0.150
     0.286    11.500     0.150
     0.319     6.680     0.150
     0.319    12.500     0.150
     0.323     7.031     0.150
     0.323    12.422     0.150
     0.364     7.883     0.150
     0.364     7.289     0.150
     0.364    12.953     0.150
     0.376     7.750     0.150
     0.376    14.133     0.150
     0.483    16.000     0.150
     0.506    18.516     0.150
     0.514    10.320     0.150
     0.514    18.078     0.150
     0.524    10.656     0.150
     0.534    17.680     0.150
     0.534     9.812     0.150
     0.549    10.438     0.150
     0.549    17.961     0.150
     0.549    17.836     0.150
     0.583    10.688     0.150
     0.583    18.641     0.150
     0.578    11.172     0.150
     0.578    19.633     0.150
     0.579    11.062     0.150
     0.579    19.430     0.150
     0.599    11.461     0.150
     0.617    20.430     0.150
     0.617    11.680     0.150
     0.639    21.586     0.150
     0.639    12.391     0.150
     0.662    12.633     0.150
     0.662    21.500     0.150
     0.678    22.797     0.150
     0.691    12.430     0.150
     0.691    21.562     0.150
     0.691    12.531     0.150
     0.694    13.328     0.150
     0.694    22.930     0.150
     0.765    24.578     0.150
     0.765    13.539     0.150
     0.802    25.727     0.150
     0.802    14.477     0.150
     0.800    15.117     0.150
     0.800    26.141     0.150
     0.831    26.992     0.150
     0.834    15.211     0.150
     0.834    15.414     0.150
     0.834    27.180     0.150
     0.843    15.688     0.150
     0.843    27.219     0.150
     0.880    28.391     0.150
     0.918    16.703     0.150
     0.918    29.328     0.150
     0.913    30.336     0.150
     0.929    17.062     0.150
     0.929    30.266     0.150
     0.933    17.242     0.150
     0.973    17.516     0.150
     0.984    17.633     0.150
     1.030    32.461     0.150
     1.036    18.359     0.150
     1.036    32.078     0.150
     1.107    19.523     0.150
     1.107    35.008     0.150
     1.124    20.148     0.150
     1.150    20.148     0.150
     1.183    20.938     0.150
     1.200    21.086     0.150
     1.250    21.602     0.150
     1.250    38.117     0.150
     1.337    23.992     0.150
     1.379    23.727     0.150
     1.379    23.305     0.150
     1.379    43.977     0.150
     1.523    26.617     0.150
     1.578    26.242     0.150
     1.651    27.102     0.150
     1.651    51.883     0.150
     1.716    31.266     0.150
     1.716    52.250     0.150
     1.790    29.023     0.150
     2.011    62.711     0.150
     2.290    70.688     0.150
     2.313    72.258     0.150
     2.336    72.023     0.150
     2.441    68.328     0.150
     2.506    77.609     0.150
     2.619    81.320     0.150
     2.664    40.250     0.150
     2.664    81.492     0.150
     3.294    49.930     0.150
     3.392    53.289     0.150
     3.612    56.109     0.150
     4.178    62.906     0.150
     4.178    61.883     0.150
     4.262    65.820     0.150
     4.366    66.258     0.150
     4.517    69.086     0.150
     4.790    72.719     0.150
     4.942    74.750     0.150
     5.713    87.062     0.150
     5.713   182.492     0.150
     6.643    96.531     0.150
     7.608   112.336     0.150
     7.608   238.109     0.150
     7.839   116.430     0.150
     7.839   247.102     0.150
    10.928   156.148     0.150
    10.928   343.844     0.150
     0.193     3.681     0.150
     0.199     3.911     0.150
     0.199     6.541     0.150
     0.224     5.081     0.150
     0.224     8.351     0.150
     0.227     4.881     0.150
     0.227     8.031     0.150
     0.231     5.121     0.150
     0.231     8.461     0.150
     0.276     5.761     0.150
     0.276     9.531     0.150
     0.313     6.671     0.150
     0.313    10.961     0.150
     0.340     6.461     0.150
     0.340     6.285     0.150
     0.343     6.462     0.150
     0.330     7.271     0.150
     0.330     7.016     0.150
     0.330    11.649     0.150
     0.402     7.971     0.150
     0.402    13.121     0.150
     0.417     7.751     0.150
     0.417    12.941     0.150
     0.437     8.801     0.150
     0.437    14.761     0.150
     0.460     9.591     0.150
     0.460    16.271     0.150
     0.465     9.761     0.150
     0.465    16.281     0.150
     0.481     9.701     0.150
     0.481    16.311     0.150
     0.501     9.851     0.150
     0.501    16.691     0.150
     0.508     9.991     0.150
     0.508    17.001     0.150
     0.527    10.691     0.150
     0.527    18.051     0.150
     0.558    11.091     0.150
     0.558    19.071     0.150
     0.580    11.301     0.150
     0.580    19.171     0.150
     0.585    11.221     0.150
     0.585    18.871     0.150
     0.608    12.301     0.150
     0.608    20.811     0.150
     0.626    12.291     0.150
     0.626    12.291     0.150
     0.626    20.941     0.150
     0.648    12.591     0.150
     0.648    21.821     0.150
     0.673    13.181     0.150
     0.673    21.711     0.150
     0.677    13.171     0.150
     0.677    22.391     0.150
     0.670    13.311     0.150
     0.670    22.591     0.150
     0.689    13.291     0.150
     0.689    22.761     0.150
     0.700    13.311     0.150
     0.700    22.351     0.150
     0.726    14.121     0.150
     0.726    23.401     0.150
     0.733    14.411     0.150
     0.733    24.241     0.150
     0.733    14.301     0.150
     0.733    24.531     0.150
     0.723    14.411     0.150
     0.723    24.361     0.150
     0.741    14.071     0.150
     0.730    14.251     0.150
     0.730    24.151     0.150
     0.735    14.541     0.150
     0.735    24.551     0.150
     0.739    14.611     0.150
     0.801    15.151     0.150
     0.801    25.661     0.150
     0.791    15.431     0.150
     0.791    26.081     0.150
     0.805    15.451     0.150
     0.805    26.391     0.150
     0.808    15.631     0.150
     0.808    26.551     0.150
     0.827    15.661     0.150
     0.827    26.401     0.150
     0.865    16.211     0.150
     0.865    27.651     0.150
     0.866    16.361     0.150
     0.866    27.871     0.150
     0.872    16.461     0.150
     0.872    27.671     0.150
     0.872    16.306     0.150
     0.881    17.081     0.150
     0.916    17.841     0.150
     0.908    16.871     0.150
     0.921    17.051     0.150
     0.911    16.941     0.150
     0.928    17.711     0.150
     0.910    18.041     0.150
     0.921    17.511     0.150
     0.933    17.901     0.150
     0.978    18.411     0.150
     0.978    31.681     0.150
     1.024    19.251     0.150
     1.012    18.781     0.150
     1.012    32.547     0.150
     1.020    19.250     0.150
     1.020    32.756     0.150
     1.029    19.090     0.150
     1.029    33.239     0.150
     1.073    21.431     0.150
     1.073    35.951     0.150
     1.122    35.151     0.150
     1.165    21.351     0.150
     1.165    36.701     0.150
     1.165    21.166     0.150
     1.165    36.580     0.150
     1.244    22.746     0.150
     1.326    24.094     0.150
     1.326    42.747     0.150
     1.325    24.461     0.150
     1.325    42.111     0.150
     1.406    26.436     0.150
     1.406    45.423     0.150
     1.415    25.968     0.150
     1.415    45.599     0.150
     1.435    25.311     0.150
     1.473    26.710     0.150
     1.520    27.379     0.150
     1.520    47.095     0.150
     1.561    27.235     0.150
     1.561    49.126     0.150
     1.606    28.791     0.150
     1.630    28.483     0.150
     1.630    51.606     0.150
     1.660    28.021     0.150
     1.704    30.993     0.150
     1.731    28.981     0.150
     1.731    53.319     0.150
     1.825    32.171     0.150
     1.825    56.396     0.150
     1.882    32.941     0.150
     1.941    33.811     0.150
     1.941    60.162     0.150
     1.942    34.001     0.150
     2.097    35.503     0.150
     2.097    64.000     0.150
     2.122    36.568     0.150
     2.245    36.648     0.150
     2.265    37.461     0.150
     2.265    64.916     0.150
     2.337    39.598     0.150
     2.386    38.863     0.150
     2.394    39.010     0.150
     2.464    41.036     0.150
     2.464    78.438     0.150
     2.571    42.521     0.150
     2.571    42.836     0.150
     2.571    75.167     0.150
     2.583    42.462     0.150
     2.636    43.636     0.150
     2.711    44.521     0.150
     2.779    44.801     0.150
     2.847    46.661     0.150
     3.128    47.171     0.150
     2.988    48.461     0.150
     2.988    95.209     0.150
     3.005    48.917     0.150
     3.005    85.525     0.150
     3.133    51.081     0.150
     3.133    98.374     0.150
     3.197    51.298     0.150
     3.317    53.141     0.150
     3.323    52.831     0.150
     3.501    56.092     0.150
     3.501   108.212     0.150
     3.531    56.302     0.150
     3.531    99.594     0.150
     3.543    56.978     0.150
     3.543   111.669     0.150
     3.711    56.416     0.150
     3.711   101.355     0.150
     3.752    60.109     0.150
     3.752   118.909     0.150
     3.835    60.861     0.150
     3.999    63.271     0.150
     4.186    65.681     0.150
     4.243    66.841     0.150
     4.256    67.241     0.150
     4.260    65.871     0.150
     4.459    70.704     0.150
     4.459   121.806     0.150
     4.494    71.031     0.150
     4.537    71.951     0.150
     4.579    69.771     0.150
     4.592    70.541     0.150
     4.604    71.741     0.150
     4.639    71.721     0.150
     4.753    72.901     0.150
     4.823    74.121     0.150
     4.947    75.991     0.150
     4.947   133.595     0.150
     4.956    75.971     0.150
     4.958    77.371     0.150
     4.970    76.511     0.150
     5.009    75.381     0.150
     5.064    78.311     0.150
     5.089    78.966     0.150
     5.089   161.075     0.150
     5.122    78.351     0.150
     5.217    77.271     0.150
     5.217    77.392     0.150
     5.324    81.981     0.150
     5.392    82.271     0.150
     5.447    84.451     0.150
     5.597    85.151     0.150
     5.661    86.821     0.150
     5.787    88.391     0.150
     5.812    87.121     0.150
     5.836    89.491     0.150
     5.873    87.811     0.150
     5.920    89.901     0.150
     6.034    93.201     0.150
     6.098    93.041     0.150
     6.098    92.670     0.150
     6.094    94.171     0.150
     6.236    94.341     0.150
     6.262    94.741     0.150
     6.286    94.891     0.150
     6.358    97.051     0.150
     6.407    95.661     0.150
     6.551    99.741     0.150
     6.662    99.781     0.150
     6.717    99.411     0.150
     6.773   100.931     0.150
     6.953   103.451     0.150
     7.138   105.051     0.150
     7.183   105.721     0.150
     7.370   110.781     0.150
     7.369   110.071     0.150
     7.369   110.616     0.150
     7.369   231.341     0.150
     7.442   111.121     0.150
     7.442   109.783     0.150
     7.467   109.751     0.150
     7.512   112.011     0.150
     7.587   114.021     0.150
     7.657   112.281     0.150
     7.657   112.173     0.150
     7.740   114.831     0.150
     7.762   115.391     0.150
     7.762   116.049     0.150
     8.033   118.771     0.150
     8.111   120.651     0.150
     8.219   118.781     0.150
     8.270   122.391     0.150
     8.314   120.991     0.150
     8.562   126.511     0.150
     8.718   128.071     0.150
     8.718   128.335     0.150
     8.701   128.251     0.150
     8.894   130.641     0.150
     9.056   133.191     0.150
     9.131   135.251     0.150
     9.191   135.821     0.150
     9.191   134.749     0.150
     9.211   136.041     0.150
     9.311   137.221     0.150
     9.470   140.681     0.150
     9.470   141.989     0.150
     9.470   297.319     0.150
     9.570   139.531     0.150
     9.570   140.163     0.150
     9.570   139.651     0.150
     9.777   143.181     0.150
     9.821   142.003     0.150
     9.803   145.061     0.150
     9.958   146.051     0.150
    10.036   146.581     0.150
    10.160   145.771     0.150
    10.160   147.082     0.150
    10.250   149.281     0.150
    10.250   150.874     0.150
    10.316   151.791     0.150
    10.395   151.901     0.150
    10.386   152.351     0.150
    10.787   157.671     0.150
    10.787   156.008     0.150
    10.899   160.126     0.150
    10.899   159.041     0.150
    10.899   158.761     0.150
    10.899   160.691     0.150
    10.909   159.127     0.150
    10.999   160.461     0.150
    11.197   162.101     0.150
    11.407   165.511     0.150
    11.407   164.693     0.150
    11.626   166.821     0.150
    11.620   170.581     0.150
    11.719   170.961     0.150
    11.719   168.485     0.150
    11.756   171.901     0.150
    11.978   172.891     0.150
    11.978   375.841     0.150
    12.095   174.041     0.150
    12.211   176.051     0.150
    12.235   176.441     0.150
    12.382   178.651     0.150
    12.403   179.851     0.150
    12.627   181.991     0.150
    13.003   187.851     0.150
    13.016   189.531     0.150
    13.069   189.591     0.150
    13.205   190.521     0.150
    13.321   190.511     0.150
    13.345   193.181     0.150
    13.522   196.371     0.150
    13.522   194.638     0.150
    13.917   198.571     0.150
    14.075   200.391     0.150
    14.415   206.201     0.150
    14.445   206.661     0.150
    14.561   206.501     0.150
    14.561   207.420     0.150
    14.759   210.301     0.150
    14.759   210.003     0.150
    14.779   209.771     0.150
    14.779   213.410     0.150
    14.779   211.649     0.150
    14.789   210.821     0.150
    14.990   210.341     0.150
    15.011   213.221     0.150
    15.226   215.211     0.150
    15.477   222.571     0.150
    15.476   219.461     0.150
    15.476   220.674     0.150
    15.483   219.851     0.150
    15.528   218.841     0.150
    15.709   225.411     0.150
    15.985   224.191     0.150
    16.141   228.821     0.150
    16.334   229.301     0.150
    16.354   233.121     0.150
    16.374   231.961     0.150
    16.374   231.764     0.150
    16.475   235.501     0.150
    16.524   233.901     0.150
    16.526   231.151     0.150
    16.656   234.951     0.150
    16.760   233.051     0.150
    16.798   236.391     0.150
    17.233   240.291     0.150
    17.398   244.681     0.150
    17.472   243.151     0.150
    17.660   248.311     0.150
    17.725   249.671     0.150
    17.725   249.039     0.150
    17.954   250.381     0.150
    18.205   252.541     0.150
    18.787   261.271     0.150
    18.787   260.772     0.150
    18.983   261.051     0.150
    19.305   266.274     0.150
    19.997   272.461     0.150
    20.449   279.551     0.150
    20.453   279.871     0.150
    20.788   283.781     0.150
    21.296   289.131     0.150
    21.595   292.401     0.150
    21.595   292.953     0.150
    21.821   294.081     0.150
    21.889   295.111     0.150
    22.738   304.961     0.150
    22.780   303.516     0.150
    23.037   307.861     0.150
    23.259   309.131     0.150
    23.606   311.251     0.150
    23.678   313.921     0.150
    24.600   321.161     0.150
    29.074   363.166     0.150
    30.569   375.702     0.150
    30.574   375.148     0.150
    30.643   376.937     0.150
    31.520   385.593     0.150
    32.078   387.611     0.150
    32.078   390.671     0.150
    32.538   392.891     0.150
    32.989   398.605     0.150
    33.001   397.761     0.150
    33.001   399.106     0.150
    33.353   400.841     0.150
    33.353   402.166     0.150
    33.366   402.459     0.150
    33.648   401.081     0.150
    33.648   404.327     0.150
    33.924   406.325     0.150
    33.940   405.701     0.150
    33.940   406.642     0.150
    34.552   411.320     0.150
    34.679   411.141     0.150
    34.679   412.818     0.150
    34.842   413.951     0.150
    34.842   414.615     0.150
    34.918   413.201     0.150
    34.918   415.091     0.150
    34.917   415.228     0.150
    34.994   413.966     0.150
    35.030   415.841     0.150
    35.116   417.151     0.150
    35.207   417.160     0.150
    35.265   417.839     0.150
    35.450   420.003     0.150
    35.621   421.673     0.150
    35.721   421.935     0.150
    35.726   421.014     0.150
    35.938   423.211     0.150
    36.051   424.162     0.150
    36.229   425.864     0.150
    36.289   426.691     0.150
    36.437   427.647     0.150
    36.484   426.651     0.150
    36.596   428.959     0.150
    36.623   429.198     0.150
    37.062   434.141     0.150
    37.069   433.003     0.150
    37.159   433.559     0.150
    37.248   433.705     0.150
    37.339   435.472     0.150
    37.468   436.143     0.150
    37.516   436.776     0.150
    37.674   437.761     0.150
    37.674   438.106     0.150
    37.732   437.811     0.150
    37.814   438.391     0.150
    38.021   441.610     0.150
    38.134   441.547     0.150
    38.224   442.301     0.150
    38.312   443.281     0.150
    38.312   442.266     0.150
    38.438   444.115     0.150
    38.617   445.973     0.150
    38.743   446.211     0.150
    38.743   446.859     0.150
    38.745   446.091     0.150
    38.762   446.207     0.150
    38.788   447.625     0.150
    38.842   447.471     0.150
    38.873   447.536     0.150
    38.957   447.632     0.150
    39.106   450.289     0.150
    39.121   449.213     0.150
    39.144   450.178     0.150
    39.333   452.555     0.150
    39.394   452.872     0.150
    39.502   453.373     0.150
    39.735   453.742     0.150
    39.843   455.391     0.150
    39.891   456.198     0.150
    41.065   465.868     0.150
    41.242   467.316     0.150
    41.390   469.316     0.150
    48.815   526.891     0.150
    54.958   574.561     0.150
    64.552   639.241     0.150
    65.687   646.521     0.150
    70.978   680.051     0.150
    76.772   714.881     0.150
    80.733   736.116     0.150
    82.037   743.041     0.150
    93.633   794.591     0.150
    93.636   799.511     0.150
     0.136     3.281     0.150
     0.136     5.891     0.150
     0.154     3.391     0.150
     0.154     5.801     0.150
     0.176     3.789     0.150
     0.176     6.352     0.150
     0.176     6.559     0.150
     0.280     5.961     0.150
     0.280    10.719     0.150
     0.280    10.520     0.150
     0.257     5.660     0.150
     0.257    10.090     0.150
     0.278     6.039     0.150
     0.278    10.898     0.150
     0.340    13.172     0.150
     0.340     7.191     0.150
     0.340    12.969     0.150
     0.387     7.730     0.150
     0.387    13.301     0.150
     0.387    13.531     0.150
     0.385     7.539     0.150
     0.385    12.922     0.150
     0.385    12.809     0.150
     0.378     7.051     0.150
     0.378    12.691     0.150
     0.378     7.359     0.150
     0.378    12.602     0.150
     0.342     7.512     0.150
     0.342    13.398     0.150
     0.357     7.879     0.150
     0.357    14.191     0.150
     0.380     8.359     0.150
     0.380    14.879     0.150
     0.425     9.059     0.150
     0.425    15.340     0.150
     0.435     8.461     0.150
     0.435    14.512     0.150
     0.405    14.398     0.150
     0.457     8.988     0.150
     0.515    17.070     0.150
     0.479     9.051     0.150
     0.505    10.531     0.150
     0.505    19.238     0.150
     0.546    11.012     0.150
     0.546    19.852     0.150
     0.580    11.359     0.150
     0.580    19.301     0.150
     0.563    11.230     0.150
     0.593    20.160     0.150
     0.601    11.891     0.150
     0.601    21.488     0.150
     0.669    21.230     0.150
     0.669    12.461     0.150
     0.614    11.500     0.150
     0.638    12.391     0.150
     0.638    22.488     0.150
     0.643    12.461     0.150
     0.631    12.078     0.150
     0.631    21.121     0.150
     0.690    12.809     0.150
     0.690    22.031     0.150
     0.661    12.391     0.150
     0.661    21.621     0.150
     0.697    22.738     0.150
     0.697    22.430     0.150
     0.697    13.422     0.150
     0.732    23.090     0.150
     0.732    13.539     0.150
     0.732    22.988     0.150
     0.705    22.559     0.150
     0.704    22.391     0.150
     0.708    13.250     0.150
     0.708    22.559     0.150
     0.708    22.742     0.150
     0.736    14.250     0.150
     0.736    23.789     0.150
     0.743    25.211     0.150
     0.781    14.422     0.150
     0.781    24.871     0.150
     0.745    13.828     0.150
     0.745    24.301     0.150
     0.764    25.910     0.150
     0.745    13.621     0.150
     0.745    24.512     0.150
     0.801    25.488     0.150
     0.803    26.328     0.150
     0.803    15.352     0.150
     0.774    14.449     0.150
     0.774    25.172     0.150
     0.852    26.461     0.150
     0.852    15.551     0.150
     0.829    26.672     0.150
     0.835    14.609     0.150
     0.835    27.941     0.150
     0.894    27.922     0.150
     0.894    16.352     0.150
     0.894    28.211     0.150
     0.863    15.941     0.150
     0.863    27.711     0.150
     0.908    16.820     0.150
     0.908    28.852     0.150
     0.890    15.781     0.150
     0.890    28.969     0.150
     0.948    17.238     0.150
     0.992    18.289     0.150
     0.992    31.672     0.150
     1.016    18.691     0.150
     1.015    18.500     0.150
     1.033    19.262     0.150
     0.976    17.102     0.150
     1.039    18.449     0.150
     1.039    33.148     0.150
     1.039    35.230     0.150
     1.052    18.879     0.150
     1.052    33.879     0.150
     1.082    19.141     0.150
     1.222    22.051     0.150
     1.887    29.930     0.150
     2.162    36.898     0.150
     2.656    42.020     0.150
     2.710    49.691     0.150
     2.709    42.770     0.150
     3.341    50.930     0.150
     3.541    54.551     0.150
     4.446    65.410     0.150
     4.560    69.570     0.150
     4.562    69.648     0.150
     5.249    78.641     0.150
     5.714    87.000     0.150
     5.714    95.023     0.150
     5.714   179.102     0.150
     6.113    90.359     0.150
     6.927   100.859     0.150
     7.731   115.676     0.150
     7.731   128.199     0.150
     7.731   242.352     0.150
     8.146   119.160     0.150
    10.970   160.148     0.150
    11.174   161.352     0.150
    11.174   353.051     0.150
    36.964   430.602     0.150
     0.112     6.467     0.150
     0.148     3.917     0.150
     0.148     7.687     0.150
     0.180     4.487     0.150
     0.180     8.337     0.150
     0.224     5.177     0.150
     0.224     9.617     0.150
     0.227     5.497     0.150
     0.227    10.597     0.150
     0.230     5.257     0.150
     0.230     9.887     0.150
     0.238     5.377     0.150
     0.257     5.727     0.150
     0.257    10.837     0.150
     0.275     5.597     0.150
     0.275    10.307     0.150
     0.274     6.247     0.150
     0.274    11.317     0.150
     0.274     6.127     0.150
     0.274    11.198     0.150
     0.293     5.957     0.150
     0.293     6.447     0.150
     0.301     6.007     0.150
     0.301    10.567     0.150
     0.333     7.497     0.150
     0.333    13.527     0.150
     0.338     6.847     0.150
     0.338    12.646     0.150
     0.364     6.937     0.150
     0.376     7.657     0.150
     0.376    12.847     0.150
     0.386     7.327     0.150
     0.386    12.707     0.150
     0.420     7.937     0.150
     0.420    13.907     0.150
     0.420     8.097     0.150
     0.465     8.547     0.150
     0.465    15.167     0.150
     0.486     9.687     0.150
     0.479     9.317     0.150
     0.479    17.057     0.150
     0.497     9.777     0.150
     0.497    18.207     0.150
     0.512     9.577     0.150
     0.513     9.817     0.150
     0.513    18.247     0.150
     0.513     9.940     0.150
     0.513    17.718     0.150
     0.544    10.867     0.150
     0.544    19.356     0.150
     0.553    10.667     0.150
     0.554    10.537     0.150
     0.554    17.987     0.150
     0.561    10.997     0.150
     0.604    10.907     0.150
     0.604    18.937     0.150
     0.661    12.347     0.150
     0.661    23.327     0.150
     0.681    12.817     0.150
     0.681    23.347     0.150
     0.703    13.567     0.150
     0.703    24.687     0.150
     0.703    24.174     0.150
     0.757    14.187     0.150
     0.757    24.827     0.150
     0.757    24.646     0.150
     0.757    14.117     0.150
     0.757    24.767     0.150
     0.787    13.697     0.150
     0.787    27.277     0.150
     0.814    14.797     0.150
     0.814    26.137     0.150
     0.830    14.747     0.150
     0.830    27.106     0.150
     0.837    14.967     0.150
     0.837    27.207     0.150
     0.850    15.227     0.150
     0.850    27.887     0.150
     0.902    16.347     0.150
     0.902    28.687     0.150
     0.902    31.367     0.150
     0.922    16.617     0.150
     0.922    29.747     0.150
     0.961    17.197     0.150
     0.961    17.420     0.150
     0.961    30.459     0.150
     0.972    17.417     0.150
     0.972    30.817     0.150
     0.972    17.910     0.150
     0.972    30.651     0.150
     0.991    17.606     0.150
     0.991    31.387     0.150
     0.993    17.737     0.150
     0.993    31.207     0.150
     1.036    17.727     0.150
     1.036    32.137     0.150
     1.056    18.177     0.150
     1.060    18.146     0.150
     1.060    18.307     0.150
     1.060    18.031     0.150
     1.060    32.681     0.150
     1.077    19.037     0.150
     1.077    33.137     0.150
     1.083    18.856     0.150
     1.095    19.367     0.150
     1.113    19.337     0.150
     1.123    19.537     0.150
     1.123    35.367     0.150
     1.127    19.587     0.150
     1.126    20.083     0.150
     1.126    35.637     0.150
     1.197    20.547     0.150
     1.192    19.867     0.150
     1.192    38.267     0.150
     1.207    20.947     0.150
     1.207    36.827     0.150
     1.212    20.947     0.150
     1.216    20.767     0.150
     1.221    21.447     0.150
     1.221    37.237     0.150
     1.277    21.537     0.150
     1.282    21.747     0.150
     1.295    22.007     0.150
     1.332    22.606     0.150
     1.332    41.727     0.150
     1.348    23.377     0.150
     1.348    23.769     0.150
     1.348    41.943     0.150
     1.365    41.757     0.150
     1.412    23.497     0.150
     1.409    24.747     0.150
     1.409    43.697     0.150
     1.409    43.562     0.150
     1.454    24.097     0.150
     1.456    24.237     0.150
     1.456    43.407     0.150
     1.458    24.047     0.150
     1.481    24.377     0.150
     1.519    25.717     0.150
     1.519    25.548     0.150
     1.519    45.034     0.150
     1.739    28.567     0.150
     1.762    28.137     0.150
     1.848    30.197     0.150
     1.848    58.027     0.150
     2.115    32.937     0.150
     2.115    60.890     0.150
     2.115    35.367     0.150
     2.347    37.227     0.150
     2.561    46.277     0.150
     2.582    40.557     0.150
     2.623    40.657     0.150
     2.875    44.567     0.150
     3.057    47.837     0.150
     3.413    51.427     0.150
     3.611    54.767     0.150
     3.684    56.057     0.150
     3.823    58.677     0.150
     4.041    59.667     0.150
     4.041    59.467     0.150
     4.085    61.567     0.150
     4.317    64.847     0.150
     4.414    67.137     0.150
     4.515    67.396     0.150
     4.891    73.077     0.150
     5.242    77.987     0.150
     5.439    80.337     0.150
     5.432    79.777     0.150
     5.507    80.837     0.150
     5.965    90.287     0.150
     6.164    89.777     0.150
     6.227    92.277     0.150
     7.005   102.627     0.150
     7.188   103.977     0.150
     7.601   110.347     0.150
     7.807   111.937     0.150
     7.807   115.480     0.150
     7.807   243.306     0.150
     7.835   116.487     0.150
     7.835   248.487     0.150
    10.762   154.297     0.150
    10.763   153.962     0.150
    10.763   341.361     0.150
    10.918   159.437     0.150
    37.223   432.487     0.150
     0.112     2.879     0.150
     0.348     7.230     0.150
     0.348    12.250     0.150
     0.393     7.828     0.150
     0.393    13.469     0.150
     0.445     8.758     0.150
     0.445    14.828     0.150
     0.440     8.301     0.150
     0.442     8.961     0.150
     0.442    15.590     0.150
     0.510     9.609     0.150
     0.510    16.438     0.150
     0.511     9.539     0.150
     0.511     9.680     0.150
     0.511    16.559     0.150
     0.512     9.711     0.150
     0.512    16.309     0.150
     0.600    19.828     0.150
     0.612    19.688     0.150
     0.612    11.520     0.150
     0.643    12.250     0.150
     0.643    21.039     0.150
     0.677    12.828     0.150
     0.677    21.660     0.150
     0.682    13.379     0.150
     0.682    23.688     0.150
     0.692    13.461     0.150
     0.713    13.781     0.150
     0.713    23.801     0.150
     0.714    22.898     0.150
     0.718    23.320     0.150
     0.769    14.371     0.150
     0.785    14.641     0.150
     0.785    25.129     0.150
     0.788    14.801     0.150
     0.788    25.148     0.150
     0.817    27.020     0.150
     0.843    26.660     0.150
     0.848    15.871     0.150
     0.848    27.340     0.150
     0.869    27.641     0.150
     0.867    27.859     0.150
     0.878    16.348     0.150
     0.878    28.301     0.150
     0.895    29.629     0.150
     0.908    28.711     0.150
     0.931    29.828     0.150
     0.929    29.668     0.150
     1.030    18.449     0.150
     1.031    18.969     0.150
     1.030    19.168     0.150
     1.061    19.539     0.150
     1.158    21.379     0.150
     1.163    21.750     0.150
     1.197    21.480     0.150
     1.241    21.828     0.150
     1.274    23.359     0.150
     1.293    21.840     0.150
     1.357    23.719     0.150
     1.388    23.551     0.150
     1.413    23.699     0.150
     1.446    24.801     0.150
     1.496    25.559     0.150
     1.543    26.129     0.150
     1.682    28.609     0.150
     1.702    29.090     0.150
     1.753    29.328     0.150
     1.781    29.469     0.150
     1.985    32.461     0.150
     1.990    32.371     0.150
     2.001    32.539     0.150
     2.953    46.219     0.150
     2.953    46.598     0.150
     4.787    72.043     0.150
     4.787   127.371     0.150
     4.787   149.320     0.150
     5.349    79.879     0.150
     5.832    86.730     0.150
     6.297    92.969     0.150
     6.770    99.961     0.150
     6.770   209.586     0.150
     7.324   107.289     0.150
     7.979   116.277     0.150
     7.979   247.953     0.150
     9.346   139.129     0.150
     9.346   291.977     0.150
    10.130   148.160     0.150
    11.525   164.512     0.150
    14.280   203.152     0.150
    14.280   448.703     0.150
    14.619   205.918     0.150
    15.869   222.539     0.150
    17.142   238.738     0.150
    18.582   257.418     0.150
    20.777   281.199     0.150
    22.956   304.211     0.150
    26.627   338.199     0.150
    28.535   355.617     0.150
    34.659   408.961     0.150
    36.045   422.188     0.150
    36.045   422.809     0.150
    37.520   432.859     0.150
    38.021   438.109     0.150
    40.159   455.859     0.150
    54.238   566.379     0.150
    55.072   569.969     0.150
    69.943   671.488     0.150
   146.341  1181.461     0.150
     0.143     4.957     0.150
     0.247     5.750     0.150
     0.247    10.418     0.150
     0.306     6.559     0.150
     0.306    10.438     0.150
     0.317     6.609     0.150
     0.317    11.066     0.150
     0.329     7.000     0.150
     0.329    12.348     0.150
     0.370     7.340     0.150
     0.370    12.906     0.150
     0.374     8.109     0.150
     0.374    14.457     0.150
     0.408     8.008     0.150
     0.408    13.867     0.150
     0.412     8.027     0.150
     0.412    13.930     0.150
     0.418     8.156     0.150
     0.414     8.566     0.150
     0.414    14.816     0.150
     0.436     8.297     0.150
     0.436    14.430     0.150
     0.496     9.738     0.150
     0.504    10.309     0.150
     0.504    18.367     0.150
     0.516    10.438     0.150
     0.523    10.188     0.150
     0.523    17.406     0.150
     0.557    10.527     0.150
     0.557    18.578     0.150
     0.588    11.637     0.150
     0.588    20.898     0.150
     0.598    20.156     0.150
     0.607    11.828     0.150
     0.607    20.816     0.150
     0.601    11.277     0.150
     0.601    20.020     0.150
     0.601    11.445     0.150
     0.633    12.750     0.150
     0.655    12.770     0.150
     0.655    21.738     0.150
     0.681    22.609     0.150
     0.681    22.277     0.150
     0.702    23.078     0.150
     0.716    13.188     0.150
     0.716    23.148     0.150
     0.722    13.188     0.150
     0.722    23.488     0.150
     0.720    13.750     0.150
     0.720    24.270     0.150
     0.723    24.027     0.150
     0.726    14.117     0.150
     0.726    23.887     0.150
     0.740    25.867     0.150
     0.733    24.477     0.150
     0.759    14.020     0.150
     0.757    14.008     0.150
     0.757    24.805     0.150
     0.765    25.891     0.150
     0.775    14.770     0.150
     0.790    14.617     0.150
     0.790    26.617     0.150
     0.788    14.879     0.150
     0.788    25.336     0.150
     0.796    14.477     0.150
     0.794    15.328     0.150
     0.794    26.781     0.150
     0.806    26.320     0.150
     0.862    29.180     0.150
     0.876    16.340     0.150
     0.876    27.359     0.150
     0.928    16.527     0.150
     0.963    17.809     0.150
     0.989    18.109     0.150
     0.989    32.195     0.150
     0.999    18.359     0.150
     1.022    18.457     0.150
     1.033    19.309     0.150
     1.136    20.680     0.150
     1.274    22.359     0.150
     1.318    24.199     0.150
     1.353    25.055     0.150
     1.659    29.750     0.150
     1.967    33.750     0.150
     2.064    35.375     0.150
     2.349    38.570     0.150
     2.403    39.609     0.150
     2.516    41.734     0.150
     2.728    49.336     0.150
     2.739    50.438     0.150
     3.178    50.508     0.150
     3.594    56.617     0.150
     3.777    58.195     0.150
     4.353    66.578     0.150
     4.386    67.445     0.150
     5.446    81.695     0.150
     6.791   100.102     0.150
     7.381   108.477     0.150
     7.906   117.320     0.150
     7.906   248.000     0.150
    10.595   157.625     0.150
    11.125   162.227     0.150
    11.125   351.922     0.150
     0.137     4.859     0.150
     0.181     4.301     0.150
     0.306     6.559     0.150
     0.315     6.539     0.150
     0.315    11.238     0.150
     0.329    12.160     0.150
     0.365     7.258     0.150
     0.365    12.668     0.150
     0.375     7.961     0.150
     0.375    14.359     0.150
     0.412     7.938     0.150
     0.421     8.121     0.150
     0.421    13.500     0.150
     0.406     7.969     0.150
     0.406    14.000     0.150
     0.421     8.480     0.150
     0.421    14.789     0.150
     0.432     8.230     0.150
     0.432    14.008     0.150
     0.501     9.641     0.150
     0.506    10.199     0.150
     0.506    18.379     0.150
     0.519    10.238     0.150
     0.519    18.508     0.150
     0.529    10.270     0.150
     0.529    17.590     0.150
     0.560    10.480     0.150
     0.588    11.461     0.150
     0.588    21.000     0.150
     0.610    21.309     0.150
     0.601    19.828     0.150
     0.605    11.391     0.150
     0.605    11.277     0.150
     0.633    12.551     0.150
     0.653    12.711     0.150
     0.653    21.680     0.150
     0.685    13.129     0.150
     0.685    23.109     0.150
     0.685    22.309     0.150
     0.719    13.121     0.150
     0.719    22.711     0.150
     0.706    23.168     0.150
     0.726    13.230     0.150
     0.726    23.230     0.150
     0.729    23.539     0.150
     0.724    13.930     0.150
     0.724    24.070     0.150
     0.732    14.000     0.150
     0.732    23.848     0.150
     0.742    13.969     0.150
     0.742    25.328     0.150
     0.738    24.160     0.150
     0.757    13.961     0.150
     0.762    13.910     0.150
     0.762    24.590     0.150
     0.775    14.520     0.150
     0.775    26.270     0.150
     0.766    25.711     0.150
     0.792    14.641     0.150
     0.792    26.449     0.150
     0.799    15.188     0.150
     0.799    26.469     0.150
     0.793    14.391     0.150
     0.792    14.840     0.150
     0.810    26.469     0.150
     0.856    15.988     0.150
     0.856    28.359     0.150
     0.872    16.109     0.150
     0.872    28.070     0.150
     0.863    16.430     0.150
     0.863    29.320     0.150
     0.891    28.828     0.150
     0.926    16.488     0.150
     0.957    17.859     0.150
     0.957    30.871     0.150
     1.005    18.391     0.150
     1.005    31.828     0.150
     0.993    18.078     0.150
     0.993    31.660     0.150
     1.034    19.328     0.150
     1.028    18.531     0.150
     1.028    32.141     0.150
     1.051    33.410     0.150
     1.130    20.000     0.150
     1.280    22.508     0.150
     1.313    24.531     0.150
     1.360    23.871     0.150
     1.365    23.500     0.150
     1.971    32.559     0.150
     2.067    34.879     0.150
     2.122    37.020     0.150
     2.145    37.848     0.150
     2.343    38.379     0.150
     2.398    39.520     0.150
     2.517    40.789     0.150
     4.370    66.211     0.150
     5.002    74.750     0.150
     5.445    80.418     0.150
     5.445    91.137     0.150
     5.445   173.434     0.150
     5.743    86.348     0.150
     7.377   109.684     0.150
     7.377   231.633     0.150
     7.900   245.777     0.150
    10.590   156.602     0.150
    11.121   158.418     0.150
     0.162     3.768     0.150
     0.162     6.128     0.150
     0.169     3.758     0.150
     0.185     4.068     0.150
     0.134     3.378     0.150
     0.134     5.408     0.150
     0.162     3.368     0.150
     0.162     5.568     0.150
     0.209     4.508     0.150
     0.209     7.448     0.150
     0.165     3.998     0.150
     0.165     6.608     0.150
     0.177     7.078     0.150
     0.195     4.398     0.150
     0.195     7.238     0.150
     0.314     6.152     0.150
     0.314    10.127     0.150
     0.406     8.508     0.150
     0.406    13.968     0.150
     0.387     7.278     0.150
     0.366     7.758     0.150
     0.366    12.778     0.150
     0.463     9.258     0.150
     0.463    15.178     0.150
     0.418    14.158     0.150
     0.418    14.138     0.150
     0.531    17.488     0.150
     0.460    15.688     0.150
     0.501    10.038     0.150
     0.501    17.138     0.150
     0.583    11.258     0.150
     0.583    18.988     0.150
     0.522    17.738     0.150
     0.617    12.328     0.150
     0.572    11.078     0.150
     0.572    18.938     0.150
     0.574    11.398     0.150
     0.574    19.338     0.150
     0.683    21.788     0.150
     0.614    19.998     0.150
     0.632    12.658     0.150
     0.632    21.498     0.150
     0.648    12.998     0.150
     0.648    22.198     0.150
     0.722    13.628     0.150
     0.708    23.088     0.150
     0.677    13.088     0.150
     0.677    22.138     0.150
     0.689    22.378     0.150
     0.767    14.998     0.150
     0.767    24.948     0.150
     0.776    14.518     0.150
     0.776    24.958     0.150
     0.726    13.848     0.150
     0.726    23.658     0.150
     0.743    24.278     0.150
     0.808    15.298     0.150
     0.808    25.858     0.150
     0.830    15.578     0.150
     0.830    26.678     0.150
     0.770    24.908     0.150
     0.820    15.218     0.150
     0.820    25.498     0.150
     0.903    16.768     0.150
     0.903    28.348     0.150
     0.954    17.828     0.150
     1.079    19.878     0.150
     1.154    20.858     0.150
     1.267    23.238     0.150
     1.207    22.398     0.150
     1.272    23.138     0.150
     1.519    26.428     0.150
     1.604    27.698     0.150
     1.708    29.748     0.150
     1.727    28.438     0.150
     1.735    30.438     0.150
     1.759    29.168     0.150
     1.722    29.948     0.150
     1.740    30.958     0.150
     1.880    32.278     0.150
     1.934    31.928     0.150
     1.994    34.288     0.150
     2.025    34.418     0.150
     2.187    36.158     0.150
     2.178    35.568     0.150
     2.322    37.688     0.150
     2.363    38.938     0.150
     2.384    39.508     0.150
     2.483    40.818     0.150
     2.608    42.628     0.150
     2.695    42.268     0.150
     2.697    43.368     0.150
     2.873    45.738     0.150
     2.885    46.448     0.150
     2.924    47.588     0.150
     3.214    47.478     0.150
     3.036    49.148     0.150
     3.210    49.888     0.150
     3.214    51.078     0.150
     3.229    50.948     0.150
     3.399    54.058     0.150
     3.485    52.938     0.150
     3.441    54.768     0.150
     3.654    56.738     0.150
     3.753    56.738     0.150
     3.861    59.558     0.150
     3.898    61.258     0.150
     4.192    63.648     0.150
     4.367    66.398     0.150
     4.513    69.268     0.150
     4.557    69.448     0.150
     4.569    69.538     0.150
     4.689    71.808     0.150
     4.871    74.438     0.150
     4.859    75.158     0.150
     4.904    74.698     0.150
     4.940    73.988     0.150
     4.988    77.458     0.150
     4.988   160.180     0.150
     4.988    75.758     0.150
     5.040    75.708     0.150
     5.338    81.468     0.150
     5.433    80.998     0.150
     7.268   108.858     0.150
     7.268   225.908     0.150
     8.697   270.777     0.150
    10.811   159.458     0.150
    12.009   173.483     0.150
    36.193   426.358     0.150
     0.126     3.260     0.150
     0.193     3.899     0.150
     0.225     4.889     0.150
     0.225     8.279     0.150
     0.324     7.149     0.150
     0.324    11.759     0.150
     0.365    13.329     0.150
     0.397    13.579     0.150
     0.413    14.319     0.150
     0.446    14.979     0.150
     0.449    15.359     0.150
     0.459    15.639     0.150
     0.458     9.019     0.150
     0.458    15.139     0.150
     0.465     9.399     0.150
     0.465    15.849     0.150
     0.486     9.869     0.150
     0.486    17.039     0.150
     0.565    10.969     0.150
     0.565    18.609     0.150
     0.583    19.369     0.150
     0.583    11.459     0.150
     0.583    19.819     0.150
     0.588    19.119     0.150
     0.608    11.739     0.150
     0.608    19.939     0.150
     0.600    19.869     0.150
     0.664    13.159     0.150
     0.665    23.159     0.150
     0.675    13.029     0.150
     0.675    22.009     0.150
     0.688    22.169     0.150
     0.685    24.199     0.150
     0.697    13.409     0.150
     0.697    23.309     0.150
     0.760    14.399     0.150
     0.760    24.819     0.150
     0.734    23.719     0.150
     0.740    24.459     0.150
     0.753    14.299     0.150
     0.779    14.609     0.150
     0.779    24.809     0.150
     0.781    14.529     0.150
     0.781    25.159     0.150
     0.787    14.969     0.150
     0.787    25.629     0.150
     0.799    15.339     0.150
     0.799    26.659     0.150
     0.809    15.089     0.150
     0.809    25.799     0.150
     0.806    26.209     0.150
     0.818    15.179     0.150
     0.818    25.999     0.150
     0.814    15.099     0.150
     0.814    25.569     0.150
     0.834    26.319     0.150
     0.834    26.569     0.150
     0.843    16.009     0.150
     0.843    27.289     0.150
     0.861    16.559     0.150
     0.861    29.219     0.150
     0.863    16.349     0.150
     0.863    27.869     0.150
     0.878    16.319     0.150
     0.879    27.649     0.150
     0.890    17.059     0.150
     0.890    29.439     0.150
     0.902    16.949     0.150
     0.899    16.409     0.150
     0.899    29.889     0.150
     0.908    16.779     0.150
     0.898    16.409     0.150
     0.898    28.969     0.150
     0.896    29.109     0.150
     0.902    17.239     0.150
     0.902    30.939     0.150
     0.921    17.069     0.150
     0.947    30.049     0.150
     0.973    17.439     0.150
     0.984    18.229     0.150
     0.989    17.859     0.150
     1.016    18.709     0.150
     1.066    18.679     0.150
     1.078    19.859     0.150
     1.180    21.509     0.150
     1.318    22.649     0.150
     1.473    24.209     0.150
     1.476    24.319     0.150
     1.482    25.709     0.150
     1.480    25.289     0.150
     1.554    26.779     0.150
     1.551    26.249     0.150
     1.678    27.329     0.150
     1.825    30.649     0.150
     1.987    33.179     0.150
     2.142    34.909     0.150
     2.153    35.609     0.150
     2.150    35.289     0.150
     2.412    37.549     0.150
     2.488    39.689     0.150
     2.488    39.919     0.150
     2.618    41.679     0.150
     2.694    42.769     0.150
     2.702    42.369     0.150
     2.707    42.939     0.150
     2.998    43.809     0.150
     2.956    45.419     0.150
     3.216    48.069     0.150
     3.207    50.329     0.150
     3.472    52.169     0.150
     4.958    75.169     0.150
     5.140    78.094     0.150
     7.313   107.769     0.150
     7.525   112.389     0.150
     8.453   122.463     0.150
     8.453   265.013     0.150
     8.453   123.669     0.150
     8.453   123.859     0.150
     9.002   134.439     0.150
    10.191   151.089     0.150
    10.755   156.119     0.150
    11.423   168.929     0.150
    11.726   168.982     0.150
    14.379   205.269     0.150
    14.743   210.069     0.150
    14.768   209.438     0.150
    14.768   213.569     0.150
    16.271   233.449     0.150
    19.038   264.819     0.150
    21.409   291.039     0.150
    22.608   300.844     0.150
    22.608   303.969     0.150
    23.661   317.179     0.150
    24.251   320.795     0.150
    24.842   326.383     0.150
    25.309   330.420     0.150
    25.376   330.777     0.150
    25.397   330.745     0.150
    26.357   340.006     0.150
    26.558   341.602     0.150
    27.110   346.464     0.150
    27.566   350.734     0.150
    27.598   350.434     0.150
    27.636   350.225     0.150
    28.486   357.209     0.150
    28.798   360.322     0.150
    28.820   360.842     0.150
    29.048   361.115     0.150
    29.061   363.925     0.150
    29.119   364.046     0.150
    29.706   368.917     0.150
    29.836   370.049     0.150
    30.080   372.592     0.150
    30.123   372.927     0.150
    30.468   376.168     0.150
    30.566   376.833     0.150
    30.844   379.224     0.150
    30.912   380.075     0.150
    30.911   379.756     0.150
    30.968   380.801     0.150
    31.316   384.224     0.150
    31.337   384.480     0.150
    31.475   386.009     0.150
    31.601   386.457     0.150
    31.818   388.487     0.150
    31.852   388.413     0.150
    31.900   389.045     0.150
    32.149   391.708     0.150
    32.177   391.240     0.150
    32.194   390.950     0.150
    32.282   392.156     0.150
    32.466   395.963     0.150
    32.714   397.291     0.150
    32.808   398.125     0.150
    32.960   399.539     0.150
    33.062   401.033     0.150
    33.072   400.863     0.150
    33.089   400.421     0.150
    33.363   402.551     0.150
    33.404   402.704     0.150
    33.408   403.011     0.150
    33.451   403.923     0.150
    33.593   404.361     0.150
    33.741   406.455     0.150
    33.785   405.892     0.150
    33.976   407.589     0.150
    34.023   408.526     0.150
    34.080   408.602     0.150
    34.155   409.034     0.150
    34.243   409.594     0.150
    34.292   409.918     0.150
    34.352   410.370     0.150
    34.417   411.383     0.150
    34.514   411.597     0.150
    34.523   412.064     0.150
    34.516   412.131     0.150
    34.632   413.176     0.150
    34.654   412.704     0.150
    34.656   413.055     0.150
    34.679   412.170     0.150
    34.922   414.905     0.150
    34.945   415.409     0.150
    34.979   415.642     0.150
    34.982   415.542     0.150
    35.007   414.724     0.150
    35.022   415.043     0.150
    35.042   414.828     0.150
    35.069   414.837     0.150
    35.153   416.747     0.150
    35.260   417.260     0.150
    35.343   417.820     0.150
    35.358   417.600     0.150
    35.403   419.063     0.150
    35.448   419.334     0.150
    35.478   420.151     0.150
    35.494   420.108     0.150
    35.521   420.731     0.150
    35.584   420.963     0.150
    35.599   421.245     0.150
    35.691   422.064     0.150
    35.776   422.351     0.150
    35.800   422.529     0.150
    35.893   423.701     0.150
    35.947   423.739     0.150
    35.953   423.639     0.150
    35.987   424.986     0.150
    35.987   424.874     0.150
    36.000   424.934     0.150
    36.132   425.844     0.150
    36.136   425.948     0.150
    36.159   426.318     0.150
    36.167   426.304     0.150
    36.202   423.569     0.150
    36.202   425.569     0.150
    36.202   427.719     0.150
    36.321   427.178     0.150
    36.333   427.345     0.150
    36.342   427.187     0.150
    36.371   425.469     0.150
    36.496   428.584     0.150
    36.506   428.999     0.150
    36.553   429.097     0.150
    36.604   429.804     0.150
    36.717   430.949     0.150
    36.735   430.889     0.150
    36.739   431.569     0.150
    36.739   430.419     0.150
    36.739   433.679     0.150
    36.758   430.693     0.150
    36.764   430.378     0.150
    36.780   431.083     0.150
    36.804   428.141     0.150
    36.899   428.648     0.150
    36.934   430.220     0.150
    36.953   431.496     0.150
    37.024   431.926     0.150
    37.126   432.774     0.150
    37.206   432.764     0.150
    37.248   432.611     0.150
    37.250   432.725     0.150
    37.254   433.372     0.150
    37.361   432.971     0.150
    37.398   434.363     0.150
    37.406   433.193     0.150
    37.418   434.880     0.150
    37.456   434.897     0.150
    37.523   436.026     0.150
    37.581   435.985     0.150
    37.585   436.266     0.150
    37.586   437.334     0.150
    37.601   436.450     0.150
    37.621   436.770     0.150
    37.740   437.862     0.150
    37.743   438.354     0.150
    37.763   438.129     0.150
    37.793   438.175     0.150
    37.909   439.125     0.150
    37.915   438.728     0.150
    37.919   438.838     0.150
    37.991   439.510     0.150
    38.086   440.059     0.150
    38.256   442.218     0.150
    38.266   442.107     0.150
    38.340   442.810     0.150
    38.343   442.458     0.150
    38.381   442.789     0.150
    38.412   443.093     0.150
    38.422   442.913     0.150
    38.467   443.482     0.150
    38.523   443.814     0.150
    38.616   443.920     0.150
    38.651   444.096     0.150
    38.743   445.601     0.150
    38.832   446.619     0.150
    38.838   446.607     0.150
    38.848   446.508     0.150
    38.885   447.167     0.150
    38.895   446.864     0.150
    38.903   447.004     0.150
    38.961   447.997     0.150
    38.981   447.723     0.150
    39.053   448.705     0.150
    39.097   448.309     0.150
    39.175   449.149     0.150
    39.221   450.342     0.150
    39.231   448.812     0.150
    39.237   449.387     0.150
    39.267   449.628     0.150
    39.377   450.644     0.150
    39.427   451.569     0.150
    39.464   451.665     0.150
    39.541   452.115     0.150
    39.574   453.271     0.150
    39.588   452.562     0.150
    39.708   454.045     0.150
    39.715   453.602     0.150
    39.813   454.323     0.150
    39.862   454.507     0.150
    39.871   454.996     0.150
    39.975   456.173     0.150
    39.987   455.970     0.150
    40.020   455.916     0.150
    40.037   456.303     0.150
    40.121   455.960     0.150
    40.124   456.049     0.150
    40.378   457.975     0.150
    40.394   457.477     0.150
    40.419   458.547     0.150
    40.431   459.047     0.150
    40.464   459.244     0.150
    40.467   459.358     0.150
    40.470   459.079     0.150
    40.493   459.421     0.150
    40.523   460.126     0.150
    40.546   460.242     0.150
    40.613   460.570     0.150
    40.739   462.375     0.150
    40.930   463.499     0.150
    40.955   464.051     0.150
    41.156   465.361     0.150
    41.328   467.003     0.150
    41.471   468.627     0.150
    41.475   468.415     0.150
    41.614   469.806     0.150
    41.616   469.650     0.150
    41.666   470.206     0.150
    41.678   470.175     0.150
    41.825   471.235     0.150
    41.862   472.507     0.150
    41.868   471.639     0.150
    42.018   472.866     0.150
    42.056   473.376     0.150
    42.143   473.177     0.150
    42.191   473.921     0.150
    42.407   475.893     0.150
    42.527   476.844     0.150
    42.653   478.559     0.150
    42.798   479.862     0.150
    42.845   479.795     0.150
    42.881   479.935     0.150
    42.977   481.075     0.150
    43.054   481.448     0.150
    43.129   482.695     0.150
    43.227   482.975     0.150
    43.374   484.150     0.150
    43.461   484.524     0.150
    43.484   484.467     0.150
    43.603   485.405     0.150
    43.775   486.794     0.150
    44.012   488.585     0.150
    44.396   491.641     0.150
    48.450   526.419     0.150
    48.680   529.329     0.150
    54.594   574.029     0.150
    54.592   572.669     0.150
    58.929   603.069     0.150
    61.252   620.269     0.150
    61.632   618.694     0.150
    63.093   632.669     0.150
    63.093   632.879     0.150
    65.756   648.669     0.150
    65.756   648.879     0.150
    71.018   682.269     0.150
    74.845   702.319     0.150
    75.959   707.519     0.150
    75.959   711.269     0.150
    78.144   721.566     0.150
    80.638   735.169     0.150
    81.478   740.394     0.150
    81.839   742.869     0.150
    82.856   752.069     0.150
    83.045   752.529     0.150
    83.128   752.419     0.150
    83.135   753.159     0.150
    83.425   750.219     0.150
    83.970   754.069     0.150
    84.620   754.469     0.150
    84.620     5.000     0.150
    84.620  1373.469     0.150
    85.124   762.479     0.150
    85.152   759.369     0.150
    86.289   766.538     0.150
    86.542   770.436     0.150
    86.798   766.417     0.150
    86.803   768.798     0.150
    86.875   769.300     0.150
    86.943   769.674     0.150
    87.134   772.259     0.150
    87.134     1.890     0.150
    87.134  1398.389     0.150
    87.134  1467.919     0.150
    87.444   772.563     0.150
    87.522   773.069     0.150
    87.658   773.212     0.150
    88.162   776.569     0.150
    88.416   777.304     0.150
    88.477   777.810     0.150
    88.775   778.069     0.150
    88.777   776.749     0.150
    88.967   775.805     0.150
    89.039   780.969     0.150
    89.045   775.923     0.150
    90.373   785.269     0.150
    90.373   998.769     0.150
    90.373  1414.568     0.150
    90.373  1504.269     0.150
    90.378   784.289     0.150
    90.880   784.119     0.150
    90.880   788.069     0.150
    90.880   787.369     0.150
    90.985   786.219     0.150
    91.628   792.069     0.150
    92.561   795.669     0.150
    92.980   797.669     0.150
    93.520   799.969     0.150
    93.623   800.969     0.150
    93.640   797.794     0.150
    93.771   795.969     0.150
    95.102   807.669     0.150
    95.205   806.719     0.150
    96.505   808.969     0.150
    99.955   829.069     0.150
   100.623   831.869     0.150
   100.885   831.269     0.150
   116.353  1127.469     0.150
   120.637  1133.669     0.150
   123.322  1141.013     0.150
   128.839  1151.069     0.150
   145.842  1181.794     0.150
   147.013  1185.819     0.150
     0.081     2.059     0.150
     0.157     3.707     0.150
     0.212     4.469     0.150
     0.212     7.787     0.150
     0.284     5.908     0.150
     0.284    10.148     0.150
     0.294     6.338     0.150
     0.294    11.688     0.150
     0.310    12.158     0.150
     0.310     6.928     0.150
     0.279     5.168     0.150
     0.279     9.277     0.150
     0.348    13.428     0.150
     0.366     7.348     0.150
     0.366    13.908     0.150
     0.414     8.148     0.150
     0.414     8.568     0.150
     0.414    16.639     0.150
     0.438     8.828     0.150
     0.438    15.457     0.150
     0.521    10.299     0.150
     0.521    18.178     0.150
     0.488     9.697     0.150
     0.488    16.588     0.150
     0.532    10.688     0.150
     0.532    19.838     0.150
     0.545    10.318     0.150
     0.545    18.107     0.150
     0.526    10.328     0.150
     0.526    18.338     0.150
     0.517    10.248     0.150
     0.517    17.799     0.150
     0.538    10.268     0.150
     0.538    18.979     0.150
     0.554    10.809     0.150
     0.554    20.178     0.150
     0.552    10.777     0.150
     0.552    19.508     0.150
     0.593    19.328     0.150
     0.593    11.178     0.150
     0.579    11.508     0.150
     0.579    20.928     0.150
     0.592    10.988     0.150
     0.592    19.469     0.150
     0.662    22.059     0.150
     0.662    12.678     0.150
     0.671    12.488     0.150
     0.671    22.018     0.150
     0.696    13.438     0.150
     0.696    23.238     0.150
     0.690    12.658     0.150
     0.690    22.309     0.150
     0.706    13.088     0.150
     0.706    23.768     0.150
     0.773    24.969     0.150
     0.773    14.207     0.150
     0.802    15.117     0.150
     0.802    26.428     0.150
     0.817    15.139     0.150
     0.817    26.178     0.150
     0.810    14.938     0.150
     0.810    25.637     0.150
     0.810    26.838     0.150
     0.810    14.828     0.150
     0.818    26.148     0.150
     0.818    14.588     0.150
     0.851    15.559     0.150
     0.851    27.559     0.150
     0.867    16.078     0.150
     0.867    28.549     0.150
     0.867    28.738     0.150
     0.896    16.658     0.150
     0.916    16.998     0.150
     0.916    30.197     0.150
     1.011    17.998     0.150
     1.047    19.668     0.150
     1.081    19.229     0.150
     1.115    19.639     0.150
     1.082    20.049     0.150
     1.211    21.049     0.150
     1.232    21.818     0.150
     1.375    24.258     0.150
     1.459    27.088     0.150
     1.569    26.178     0.150
     1.579    27.238     0.150
     1.798    29.277     0.150
     2.270    37.229     0.150
     2.290    38.947     0.150
     2.343    39.428     0.150
     2.454    37.219     0.150
     2.681    40.639     0.150
     2.950    46.068     0.150
     3.081    47.498     0.150
     3.109    48.018     0.150
     3.406    51.479     0.150
     3.698    55.678     0.150
     3.784    59.258     0.150
     4.178    63.678     0.150
     4.286    66.158     0.150
     5.661    85.064     0.150
     6.636    96.908     0.150
     7.547   112.469     0.150
     7.547   236.518     0.150
     7.812   116.188     0.150
     7.812   144.512     0.150
     7.812   243.662     0.150
    10.691   159.219     0.150
    10.936   157.068     0.150
    10.936   344.533     0.150
     0.261     9.445     0.150
     0.256     9.656     0.150
     0.357    13.211     0.150
     0.382    12.281     0.150
     0.365     7.594     0.150
     0.365    14.023     0.150
     0.384    12.828     0.150
     0.378     7.922     0.150
     0.378    14.766     0.150
     0.402     8.453     0.150
     0.402    15.344     0.150
     0.424     8.633     0.150
     0.424    15.172     0.150
     0.415    13.336     0.150
     0.415    14.445     0.150
     0.447     8.281     0.150
     0.447    14.766     0.150
     0.492     9.234     0.150
     0.492    16.367     0.150
     0.492     8.977     0.150
     0.492    15.836     0.150
     0.513    10.094     0.150
     0.526    10.516     0.150
     0.526    19.578     0.150
     0.558    10.461     0.150
     0.558    18.367     0.150
     0.565    11.016     0.150
     0.565    20.281     0.150
     0.620    11.875     0.150
     0.620    21.773     0.150
     0.651    11.445     0.150
     0.651    20.125     0.150
     0.629    11.734     0.150
     0.629    20.641     0.150
     0.634    11.516     0.150
     0.659    12.422     0.150
     0.659    22.891     0.150
     0.675    12.227     0.150
     0.675    20.977     0.150
     0.662    12.164     0.150
     0.662    21.305     0.150
     0.679    12.656     0.150
     0.679    21.625     0.150
     0.686    13.383     0.150
     0.686    21.531     0.150
     0.691    12.664     0.150
     0.691    21.727     0.150
     0.693    21.750     0.150
     0.693    12.664     0.150
     0.693    21.484     0.150
     0.693    12.547     0.150
     0.717    13.406     0.150
     0.717    22.742     0.150
     0.726    13.656     0.150
     0.726    23.641     0.150
     0.752    13.531     0.150
     0.752    24.023     0.150
     0.747    13.914     0.150
     0.747    23.305     0.150
     0.768    13.688     0.150
     0.768    24.781     0.150
     0.778    14.016     0.150
     0.778    24.164     0.150
     0.782    14.602     0.150
     0.782    25.164     0.150
     0.785    14.258     0.150
     0.785    24.594     0.150
     0.810    15.023     0.150
     0.810    25.625     0.150
     0.852    14.492     0.150
     0.852    26.742     0.150
     0.846    15.352     0.150
     0.846    26.406     0.150
     0.875    15.578     0.150
     0.875    26.906     0.150
     0.875    15.141     0.150
     0.895    16.203     0.150
     0.895    27.797     0.150
     0.899    16.047     0.150
     0.899    27.461     0.150
     0.913    15.812     0.150
     0.974    17.375     0.150
     0.974    29.906     0.150
     0.971    17.242     0.150
     0.971    30.086     0.150
     1.014    18.266     0.150
     1.014    31.781     0.150
     0.999    16.906     0.150
     0.999    29.445     0.150
     1.018    18.445     0.150
     1.018    31.906     0.150
     1.006    17.836     0.150
     1.006    31.094     0.150
     1.027    18.203     0.150
     1.027    31.773     0.150
     1.023    18.352     0.150
     1.023    32.484     0.150
     1.039    18.273     0.150
     1.039    32.375     0.150
     1.040    18.312     0.150
     1.040    32.211     0.150
     1.071    19.492     0.150
     1.071    34.977     0.150
     1.072    18.688     0.150
     1.072    33.078     0.150
     1.142    20.016     0.150
     1.276    22.273     0.150
     1.343    22.461     0.150
     1.443    23.914     0.150
     1.640    28.094     0.150
     1.693    28.156     0.150
     1.829    30.234     0.150
     1.909    29.891     0.150
     2.142    37.141     0.150
     2.364    36.867     0.150
     2.484    38.516     0.150
     2.611    39.055     0.150
     2.608    40.625     0.150
     2.676    42.094     0.150
     2.722    42.438     0.150
     2.733    42.664     0.150
     2.756    43.977     0.150
     2.811    42.125     0.150
     2.862    45.273     0.150
     2.910    43.578     0.150
     3.017    46.641     0.150
     3.199    48.578     0.150
     3.261    49.867     0.150
     3.326    50.484     0.150
     3.543    54.281     0.150
     3.785    57.852     0.150
     3.793    58.172     0.150
     3.808    57.953     0.150
     3.920    59.531     0.150
     4.058    61.492     0.150
     4.386    66.047     0.150
     4.469    65.695     0.150
     4.575    69.164     0.150
     4.577    69.102     0.150
     4.621    69.008     0.150
     4.767    71.773     0.150
     5.010    75.031     0.150
     5.614    83.516     0.150
     5.705    84.734     0.150
     5.705    85.016     0.150
     5.771    85.688     0.150
     6.138    90.352     0.150
     7.616   110.523     0.150
     7.731   112.062     0.150
     7.731   126.711     0.150
     7.731   111.453     0.150
     7.809   112.984     0.150
     8.044   117.617     0.150
     8.167   119.156     0.150
     8.167   253.406     0.150
     8.167   118.242     0.150
     9.092   130.508     0.150
    10.205   151.875     0.150
    10.190   149.055     0.150
    10.978   159.609     0.150
    10.978   160.297     0.150
    11.196   158.984     0.150
    11.197   160.656     0.150
    11.197   350.438     0.150
    13.656   192.664     0.150
    13.778   194.773     0.150
    14.684   206.133     0.150
    14.764   208.102     0.150
    15.247   216.156     0.150
    15.247   214.156     0.150
    15.414   214.391     0.150
    15.562   218.695     0.150
    15.660   218.984     0.150
    15.696   219.984     0.150
    16.046   223.836     0.150
    16.449   229.641     0.150
    16.578   230.188     0.150
    16.924   234.852     0.150
    17.617   243.195     0.150
    18.352   252.523     0.150
    18.445   252.594     0.150
    18.548   253.953     0.150
    19.073   260.297     0.150
    19.142   260.391     0.150
    19.978   270.594     0.150
    20.279   273.305     0.150
    21.064   283.812     0.150
    21.064   283.414     0.150
    21.384   286.625     0.150
    21.502   286.625     0.150
    22.744   302.281     0.150
    22.744   301.508     0.150
    23.849   312.297     0.150
    24.833   322.047     0.150
    25.430   327.664     0.150
    25.961   332.359     0.150
    25.977   332.742     0.150
    27.235   343.547     0.150
    27.440   345.406     0.150
    27.533   346.594     0.150
    27.629   347.203     0.150
    28.134   351.414     0.150
    28.178   351.211     0.150
    28.196   351.859     0.150
    28.458   354.367     0.150
    29.057   359.820     0.150
    29.362   361.961     0.150
    29.397   362.023     0.150
    29.500   364.531     0.150
    29.500   363.742     0.150
    29.599   364.086     0.150
    29.700   365.250     0.150
    30.247   369.883     0.150
    30.261   369.625     0.150
    30.276   370.477     0.150
    30.416   371.000     0.150
    30.587   373.156     0.150
    30.697   373.594     0.150
    31.051   377.023     0.150
    31.144   378.211     0.150
    31.161   378.500     0.150
    31.210   378.977     0.150
    31.434   381.258     0.150
    31.473   381.898     0.150
    31.492   381.688     0.150
    31.541   382.367     0.150
    31.895   385.812     0.150
    31.923   385.680     0.150
    32.030   386.625     0.150
    32.067   386.922     0.150
    32.184   388.078     0.150
    32.386   389.750     0.150
    32.496   390.656     0.150
    32.722   392.781     0.150
    32.776   391.977     0.150
    32.776   392.289     0.150
    32.875   392.812     0.150
    33.174   395.914     0.150
    33.193   396.188     0.150
    33.304   397.344     0.150
    33.555   399.172     0.150
    33.626   400.070     0.150
    33.655   399.938     0.150
    33.688   399.961     0.150
    33.965   403.000     0.150
    33.966   402.695     0.150
    34.037   403.578     0.150
    34.172   404.641     0.150
    34.283   406.188     0.150
    34.381   406.414     0.150
    34.406   406.047     0.150
    34.625   407.906     0.150
    34.745   409.156     0.150
    34.848   410.297     0.150
    34.885   410.062     0.150
    34.967   410.805     0.150
    35.035   410.688     0.150
    35.111   412.445     0.150
    35.125   412.617     0.150
    35.176   412.797     0.150
    35.229   413.336     0.150
    35.243   413.594     0.150
    35.256   413.469     0.150
    35.460   415.422     0.150
    35.502   415.758     0.150
    35.543   414.633     0.150
    35.543   415.305     0.150
    35.548   415.148     0.150
    35.590   414.766     0.150
    35.593   415.742     0.150
    35.603   415.531     0.150
    35.609   417.258     0.150
    35.747   417.438     0.150
    35.816   418.867     0.150
    35.816   417.984     0.150
    35.949   418.836     0.150
    35.985   419.320     0.150
    36.017   420.008     0.150
    36.024   420.328     0.150
    36.089   420.742     0.150
    36.157   421.000     0.150
    36.193   421.352     0.150
    36.264   422.227     0.150
    36.328   422.570     0.150
    36.381   423.547     0.150
    36.495   423.195     0.150
    36.495   424.453     0.150
    36.564   424.680     0.150
    36.592   424.719     0.150
    36.655   425.266     0.150
    36.708   425.633     0.150
    36.720   426.414     0.150
    36.735   427.266     0.150
    36.735   426.602     0.150
    36.912   427.805     0.150
    36.944   428.125     0.150
    36.954   430.234     0.150
    36.954   428.023     0.150
    36.956   427.648     0.150
    37.058   428.859     0.150
    37.083   428.938     0.150
    37.166   429.766     0.150
    37.199   430.109     0.150
    37.236   430.531     0.150
    37.280   430.586     0.150
    37.293   430.711     0.150
    37.311   431.344     0.150
    37.323   431.430     0.150
    37.326   431.359     0.150
    37.339   431.258     0.150
    37.362   431.398     0.150
    37.386   432.125     0.150
    37.419   432.234     0.150
    37.522   433.180     0.150
    37.552   432.961     0.150
    37.568   433.125     0.150
    37.568   433.867     0.150
    37.692   434.992     0.150
    37.827   435.445     0.150
    37.847   435.906     0.150
    37.853   435.477     0.150
    37.860   435.789     0.150
    37.975   436.242     0.150
    37.983   436.500     0.150
    37.997   436.516     0.150
    38.028   436.508     0.150
    38.072   437.383     0.150
    38.071   436.977     0.150
    38.071   437.859     0.150
    38.156   437.281     0.150
    38.156   438.227     0.150
    38.158   438.562     0.150
    38.180   438.586     0.150
    38.186   438.891     0.150
    38.229   438.734     0.150
    38.351   440.273     0.150
    38.355   440.570     0.150
    38.354   440.211     0.150
    38.357   439.664     0.150
    38.490   441.102     0.150
    38.492   440.992     0.150
    38.518   441.633     0.150
    38.534   441.062     0.150
    38.653   442.594     0.150
    38.855   444.016     0.150
    38.866   444.055     0.150
    38.892   444.500     0.150
    38.946   444.961     0.150
    38.946   444.734     0.150
    38.998   445.242     0.150
    39.008   445.227     0.150
    39.008   445.844     0.150
    39.032   446.094     0.150
    39.035   445.797     0.150
    39.109   446.820     0.150
    39.187   447.383     0.150
    39.231   447.734     0.150
    39.332   447.961     0.150
    39.355   448.117     0.150
    39.421   449.180     0.150
    39.447   449.719     0.150
    39.480   449.773     0.150
    39.510   450.078     0.150
    39.525   450.031     0.150
    39.714   452.211     0.150
    39.745   452.578     0.150
    39.774   453.070     0.150
    39.812   452.547     0.150
    39.843   452.180     0.150
    39.877   452.000     0.150
    39.990   453.258     0.150
    40.019   454.125     0.150
    40.036   453.961     0.150
    40.134   454.898     0.150
    40.157   454.969     0.150
    40.173   454.961     0.150
    40.263   456.250     0.150
    40.312   455.742     0.150
    40.392   456.430     0.150
    40.431   457.109     0.150
    40.476   456.953     0.150
    40.581   458.414     0.150
    40.589   458.508     0.150
    40.602   458.383     0.150
    40.603   458.758     0.150
    40.696   459.172     0.150
    40.736   459.414     0.150
    40.948   460.367     0.150
    40.948   462.492     0.150
    40.982   462.094     0.150
    41.003   461.727     0.150
    41.037   462.023     0.150
    41.064   462.766     0.150
    41.064   462.266     0.150
    41.091   462.141     0.150
    41.109   462.234     0.150
    41.136   462.961     0.150
    41.138   462.078     0.150
    41.138   463.211     0.150
    41.199   463.719     0.150
    41.343   465.211     0.150
    41.510   467.422     0.150
    41.530   467.539     0.150
    41.534   468.086     0.150
    41.549   468.164     0.150
    41.745   469.430     0.150
    41.914   470.930     0.150
    42.052   472.164     0.150
    42.073   472.766     0.150
    42.189   473.523     0.150
    42.228   473.078     0.150
    42.258   473.938     0.150
    42.280   473.758     0.150
    42.435   475.055     0.150
    42.442   475.023     0.150
    42.447   474.812     0.150
    42.585   475.438     0.150
    42.585   476.281     0.150
    42.656   476.922     0.150
    42.774   478.352     0.150
    42.997   477.867     0.150
    42.997   479.234     0.150
    43.129   480.391     0.150
    43.245   481.117     0.150
    43.372   482.016     0.150
    43.372   482.953     0.150
    43.411   482.031     0.150
    43.486   483.258     0.150
    43.558   483.875     0.150
    43.654   484.953     0.150
    43.750   485.000     0.150
    43.813   484.797     0.150
    43.813   484.992     0.150
    43.965   487.008     0.150
    44.028   488.328     0.150
    44.073   488.672     0.150
    44.206   488.906     0.150
    44.362   490.859     0.150
    44.589   491.992     0.150
    44.857   493.859     0.150
    44.987   494.875     0.150
    44.987   495.469     0.150
    45.865   502.375     0.150
    62.253   621.562     0.150
    75.607   704.266     0.150
    76.478   711.031     0.150
    76.478   709.602     0.150
    77.003   712.523     0.150
    79.941   730.188     0.150
    83.196   745.508     0.150
    84.023   749.742     0.150
    91.525   789.195     0.150
    94.131   800.305     0.150
    94.387   798.188     0.150
    95.730   808.039     0.150
    97.126   810.688     0.150
    98.008   816.125     0.150
   110.759  1112.188     0.150
     0.092     2.809     0.150
     0.102     2.379     0.150
     0.102     5.070     0.150
     0.114     2.961     0.150
     0.104     2.980     0.150
     0.153     3.250     0.150
     0.153     6.121     0.150
     0.179     3.750     0.150
     0.179     7.910     0.150
     0.229     5.059     0.150
     0.248     5.449     0.150
     0.248     9.449     0.150
     0.324     6.270     0.150
     0.381     7.910     0.150
     0.435     8.879     0.150
     0.448     8.781     0.150
     0.448    15.430     0.150
     0.456    16.621     0.150
     0.507    10.641     0.150
     0.590    11.418     0.150
     0.637    11.621     0.150
     0.676    13.109     0.150
     0.682    12.418     0.150
     0.712    13.531     0.150
     0.712    23.500     0.150
     0.715    13.430     0.150
     0.715    23.328     0.150
     0.772    14.020     0.150
     0.775    14.820     0.150
     0.780    26.000     0.150
     0.780    15.039     0.150
     0.803    14.719     0.150
     0.826    15.738     0.150
     0.831    15.879     0.150
     0.831    28.031     0.150
     0.909    15.871     0.150
     0.967    31.910     0.150
     0.993    17.719     0.150
     0.983    17.879     0.150
     0.983    32.281     0.150
     0.987    18.270     0.150
     0.987    32.531     0.150
     1.011    18.820     0.150
     1.011    32.750     0.150
     1.064    18.969     0.150
     1.107    20.188     0.150
     1.159    20.820     0.150
     1.239    21.828     0.150
     1.269    22.230     0.150
     1.355    24.121     0.150
     1.484    25.090     0.150
     1.604    27.871     0.150
     1.708    29.348     0.150
     1.891    31.648     0.150
     2.177    35.520     0.150
     2.227    35.738     0.150
     2.359    39.230     0.150
     2.378    38.430     0.150
     2.638    41.609     0.150
     2.747    42.750     0.150
     3.022    46.949     0.150
     3.308    50.961     0.150
     3.705    56.820     0.150
     3.738    57.719     0.150
     4.230    64.449     0.150
     4.258    64.090     0.150
     4.690    70.770     0.150
     7.479   138.434     0.150
    10.655   156.258     0.150
    36.827   430.836     0.150
     0.104     2.148     0.150
     0.104     5.090     0.150
     0.106     1.480     0.150
     0.106     3.539     0.150
     0.113     2.770     0.150
     0.113     6.148     0.150
     0.172     3.340     0.150
     0.172     7.488     0.150
     0.162     3.129     0.150
     0.162     6.512     0.150
     0.163     4.391     0.150
     0.163     8.000     0.150
     0.240     4.930     0.150
     0.240    10.020     0.150
     0.230     9.270     0.150
     0.315     6.602     0.150
     0.373     7.430     0.150
     0.401     8.109     0.150
     0.394     8.039     0.150
     0.394    13.699     0.150
     0.423     8.172     0.150
     0.423    15.051     0.150
     0.457    16.211     0.150
     0.457     8.691     0.150
     0.444     8.801     0.150
     0.444    15.781     0.150
     0.459     8.809     0.150
     0.459    16.070     0.150
     0.457     9.070     0.150
     0.457    16.910     0.150
     0.463     9.121     0.150
     0.463    17.398     0.150
     0.492    17.699     0.150
     0.512     9.828     0.150
     0.602    11.359     0.150
     0.610    12.238     0.150
     0.610    22.090     0.150
     0.590    20.398     0.150
     0.590    11.738     0.150
     0.630    12.141     0.150
     0.630    22.070     0.150
     0.628    20.852     0.150
     0.628    11.879     0.150
     0.641    22.488     0.150
     0.678    22.570     0.150
     0.687    12.910     0.150
     0.687    22.750     0.150
     0.681    22.469     0.150
     0.681    13.070     0.150
     0.717    14.121     0.150
     0.717    24.211     0.150
     0.712    15.500     0.150
     0.716    14.000     0.150
     0.716    24.012     0.150
     0.719    13.867     0.150
     0.719    24.070     0.150
     0.719    14.148     0.150
     0.719    23.648     0.150
     0.719    13.980     0.150
     0.770    13.730     0.150
     0.770    24.891     0.150
     0.761    14.551     0.150
     0.761    24.770     0.150
     0.798    15.129     0.150
     0.783    26.629     0.150
     0.783    15.320     0.150
     0.782    14.828     0.150
     0.782    26.500     0.150
     0.784    14.828     0.150
     0.784    25.730     0.150
     0.809    15.391     0.150
     0.809    27.141     0.150
     0.829    28.609     0.150
     0.829    16.180     0.150
     0.833    16.129     0.150
     0.833    27.691     0.150
     0.899    16.941     0.150
     0.899    30.039     0.150
     0.904    29.621     0.150
     0.911    17.121     0.150
     0.911    30.840     0.150
     0.967    18.250     0.150
     0.967    18.379     0.150
     0.987    31.699     0.150
     0.987    18.469     0.150
     1.020    19.039     0.150
     2.181    37.059     0.150
     2.537    47.020     0.150
     2.869    47.559     0.150
     2.889    55.031     0.150
     7.488   235.750     0.150
     7.862   114.742     0.150
     7.862   244.145     0.150
    10.663   154.648     0.150
    11.019   159.477     0.150
    11.019   344.578     0.150
    15.034   215.395     0.150
    15.190   220.340     0.150
    15.334   222.078     0.150
    17.353   244.781     0.150
    18.756   262.711     0.150
    21.068   284.441     0.150
    21.166   285.809     0.150
    21.236   285.570     0.150
    22.337   297.719     0.150
    23.009   304.262     0.150
    23.656   310.672     0.150
    23.921   313.699     0.150
    25.996   332.461     0.150
    28.705   356.270     0.150
    36.530   423.980     0.150
    36.836   428.250     0.150
    36.836   429.648     0.150
    36.836   429.320     0.150
    38.429   442.551     0.150
    38.628   444.219     0.150
    39.819   453.828     0.150
    41.385   467.602     0.150
    41.638   469.320     0.150
    43.698   485.230     0.150
    62.259   623.477     0.150
    76.603   712.172     0.150
    78.100   720.383     0.150
    83.837   750.977     0.150
    86.785   764.301     0.150
    94.341   800.602     0.150
    97.141   812.102     0.150
   100.378   829.398     0.150
   101.016   832.199     0.150
   110.723  1113.398     0.150
     0.090     2.219     0.150
     0.090     4.980     0.150
     0.102     1.809     0.150
     0.102     3.270     0.150
     0.101     2.891     0.150
     0.112     2.969     0.150
     0.154     3.309     0.150
     0.154     5.891     0.150
     0.174     4.359     0.150
     0.174     8.059     0.150
     0.237     5.359     0.150
     0.243     5.621     0.150
     0.243     9.980     0.150
     0.318     6.441     0.150
     0.318    10.879     0.150
     0.321     6.379     0.150
     0.321    10.922     0.150
     0.371     7.738     0.150
     0.371    13.301     0.150
     0.405     8.512     0.150
     0.405    14.949     0.150
     0.408     8.379     0.150
     0.408    14.590     0.150
     0.433     8.570     0.150
     0.433    15.000     0.150
     0.449     8.980     0.150
     0.445     9.020     0.150
     0.445    15.801     0.150
     0.448     8.801     0.150
     0.448    15.180     0.150
     0.454     9.059     0.150
     0.454    15.641     0.150
     0.470     9.539     0.150
     0.470    16.949     0.150
     0.468     9.500     0.150
     0.468    16.480     0.150
     0.496     9.969     0.150
     0.496    17.500     0.150
     0.496    10.160     0.150
     0.496    19.180     0.150
     0.525    10.262     0.150
     0.605    11.391     0.150
     0.605    19.969     0.150
     0.603    11.730     0.150
     0.603    20.570     0.150
     0.609    12.121     0.150
     0.609    22.320     0.150
     0.621    11.910     0.150
     0.621    21.520     0.150
     0.635    11.941     0.150
     0.635    20.570     0.150
     0.637    12.359     0.150
     0.637    22.910     0.150
     0.668    12.410     0.150
     0.668    22.141     0.150
     0.696    22.602     0.150
     0.690    12.820     0.150
     0.726    14.301     0.150
     0.726    24.551     0.150
     0.722    13.477     0.150
     0.726    23.781     0.150
     0.729    13.820     0.150
     0.729    23.719     0.150
     0.758    13.871     0.150
     0.774    14.770     0.150
     0.774    25.711     0.150
     0.790    14.379     0.150
     0.790    25.699     0.150
     0.784    26.559     0.150
     0.794    25.930     0.150
     0.798    15.039     0.150
     0.798    26.070     0.150
     0.821    15.680     0.150
     0.821    27.449     0.150
     0.840    16.000     0.150
     0.840    28.000     0.150
     0.845    27.340     0.150
     0.899    15.602     0.150
     0.905    29.820     0.150
     0.914    17.051     0.150
     0.914    29.379     0.150
     0.923    17.051     0.150
     0.996    17.922     0.150
     1.011    18.910     0.150
     1.030    18.328     0.150
     1.075    18.852     0.150
     1.075    34.102     0.150
     1.092    19.609     0.150
     1.098    20.449     0.150
     1.111    19.738     0.150
     1.167    20.551     0.150
     1.165    20.539     0.150
     1.178    20.539     0.150
     1.243    21.820     0.150
     1.288    39.801     0.150
     1.299    22.512     0.150
     1.362    23.551     0.150
     1.403    27.129     0.150
     1.606    27.629     0.150
     1.657    31.238     0.150
     2.227    40.711     0.150
     2.266    39.609     0.150
     2.538    38.410     0.150
     2.680    49.730     0.150
     2.857    52.809     0.150
     2.884    47.730     0.150
     3.321    59.949     0.150
     3.610    67.570     0.150
     4.227    80.898     0.150
     4.244    79.449     0.150
     4.320    79.988     0.150
     5.580   177.539     0.150
     7.848   143.500     0.150
    10.655   156.301     0.150
    11.007   158.727     0.150
    36.838   428.332     0.150
    94.346   800.949     0.150
     0.093     2.203     0.150
     0.093     5.211     0.150
     0.078     2.570     0.150
     0.089     2.812     0.150
     0.089     5.672     0.150
     0.124     4.078     0.150
     0.135     3.055     0.150
     0.135     5.102     0.150
     0.188     3.898     0.150
     0.188     7.898     0.150
     0.190     4.469     0.150
     0.190     8.359     0.150
     0.236     5.531     0.150
     0.260     5.523     0.150
     0.260    10.914     0.150
     0.338     6.883     0.150
     0.338    11.484     0.150
     0.342     6.617     0.150
     0.395     8.094     0.150
     0.408     8.414     0.150
     0.408    14.648     0.150
     0.427     8.898     0.150
     0.427    15.742     0.150
     0.430     8.359     0.150
     0.430    15.250     0.150
     0.450     8.680     0.150
     0.450    15.312     0.150
     0.472     9.273     0.150
     0.445     9.312     0.150
     0.445    16.078     0.150
     0.469     9.469     0.150
     0.469    16.719     0.150
     0.519    10.484     0.150
     0.519    19.773     0.150
     0.519    10.391     0.150
     0.516    10.219     0.150
     0.516    17.148     0.150
     0.598    11.344     0.150
     0.598    20.484     0.150
     0.628    20.828     0.150
     0.640    12.094     0.150
     0.640    21.758     0.150
     0.660    12.820     0.150
     0.655    12.188     0.150
     0.655    21.133     0.150
     0.682    12.531     0.150
     0.682    22.648     0.150
     0.673    12.664     0.150
     0.673    21.953     0.150
     0.713    13.320     0.150
     0.713    23.062     0.150
     0.711    23.555     0.150
     0.714    13.578     0.150
     0.714    22.852     0.150
     0.714    13.422     0.150
     0.714    23.500     0.150
     0.769    13.969     0.150
     0.769    23.461     0.150
     0.761    14.773     0.150
     0.761    25.922     0.150
     0.775    14.844     0.150
     0.775    25.750     0.150
     0.809    14.805     0.150
     0.782    14.617     0.150
     0.782    25.953     0.150
     0.795    15.117     0.150
     0.795    26.258     0.150
     0.808    27.148     0.150
     0.827    15.914     0.150
     0.827    27.758     0.150
     0.833    27.633     0.150
     0.884    29.312     0.150
     0.922    15.891     0.150
     0.899    16.594     0.150
     0.899    29.633     0.150
     0.973    31.359     0.150
     0.974    32.141     0.150
     0.981    18.070     0.150
     0.993    18.320     0.150
     0.993    32.539     0.150
     1.009    17.688     0.150
     1.009    31.453     0.150
     1.075    19.031     0.150
     1.092    19.500     0.150
     1.257    22.148     0.150
     1.287    22.188     0.150
     1.370    24.180     0.150
     1.382    25.578     0.150
     1.487    25.289     0.150
     2.077    35.719     0.150
     2.176    34.891     0.150
     2.215    35.258     0.150
     2.347    37.180     0.150
     2.360    37.211     0.150
     2.557    38.672     0.150
     2.628    40.984     0.150
     2.628    47.453     0.150
     2.634    41.039     0.150
     2.657    41.758     0.150
     2.661    46.219     0.150
     2.738    42.852     0.150
     5.556    84.727     0.150
     5.556   175.539     0.150
     7.462   139.461     0.150
     7.462   235.789     0.150
    10.636   156.164     0.150
    26.442   339.734     0.150
    36.815   428.883     0.150
    94.324   800.312     0.150
     0.140     3.723     0.150
     0.140     6.441     0.150
     0.302     5.840     0.150
     0.302     9.691     0.150
     0.339     6.641     0.150
     0.339    11.461     0.150
     0.340     6.660     0.150
     0.340    11.320     0.150
     0.346     6.773     0.150
     0.346    11.340     0.150
     0.356     7.152     0.150
     0.356    12.160     0.150
     0.344     7.301     0.150
     0.352     7.191     0.150
     0.352    12.512     0.150
     0.347     6.801     0.150
     0.347    11.672     0.150
     0.424     8.453     0.150
     0.424    14.332     0.150
     0.431     8.633     0.150
     0.431    14.633     0.150
     0.457     9.012     0.150
     0.457    15.582     0.150
     0.470     9.320     0.150
     0.470    15.602     0.150
     0.459     9.332     0.150
     0.459    16.160     0.150
     0.481     9.473     0.150
     0.481    16.121     0.150
     0.481    15.992     0.150
     0.475     9.730     0.150
     0.475    16.781     0.150
     0.504     9.941     0.150
     0.504    16.953     0.150
     0.501    10.062     0.150
     0.501    17.230     0.150
     0.524    10.273     0.150
     0.526    10.531     0.150
     0.526    18.332     0.150
     0.526    10.523     0.150
     0.526    18.180     0.150
     0.549    10.871     0.150
     0.549    18.602     0.150
     0.581    11.402     0.150
     0.581    19.281     0.150
     0.588    11.910     0.150
     0.592    11.762     0.150
     0.592    20.113     0.150
     0.623    12.133     0.150
     0.623    20.652     0.150
     0.687    13.070     0.150
     0.687    22.062     0.150
     0.680    13.000     0.150
     0.680    21.602     0.150
     0.704    13.762     0.150
     0.704    23.211     0.150
     0.693    23.422     0.150
     0.741    14.250     0.150
     0.741    24.340     0.150
     0.756    14.652     0.150
     0.756    25.332     0.150
     0.774    14.980     0.150
     0.774    25.410     0.150
     0.762    24.660     0.150
     0.762    14.711     0.150
     0.766    26.363     0.150
     0.801    15.562     0.150
     0.814    15.883     0.150
     0.814    27.723     0.150
     0.821    28.023     0.150
     0.803    15.293     0.150
     0.803    25.793     0.150
     0.844    15.723     0.150
     0.844    27.301     0.150
     0.849    16.273     0.150
     0.849    27.281     0.150
     0.880    16.812     0.150
     0.880    28.121     0.150
     0.880    16.641     0.150
     0.880    28.742     0.150
     0.898    16.941     0.150
     0.898    28.742     0.150
     0.965    32.141     0.150
     0.958    30.660     0.150
     0.975    18.512     0.150
     0.975    31.621     0.150
     1.047    19.242     0.150
     1.047    32.680     0.150
     1.048    19.352     0.150
     1.039    19.340     0.150
     1.038    20.160     0.150
     1.043    20.102     0.150
     1.071    19.902     0.150
     1.071    34.082     0.150
     1.075    20.211     0.150
     1.075    34.660     0.150
     1.094    20.500     0.150
     1.094    35.621     0.150
     1.122    20.301     0.150
     1.124    20.023     0.150
     1.124    21.191     0.150
     1.164    21.023     0.150
     1.145    21.672     0.150
     1.169    22.051     0.150
     1.285    23.461     0.150
     1.285    39.652     0.150
     1.293    24.273     0.150
     1.320    23.570     0.150
     1.322    24.480     0.150
     1.388    25.340     0.150
     1.388    44.781     0.150
     1.394    25.891     0.150
     1.394    44.172     0.150
     1.490    27.242     0.150
     1.490    46.762     0.150
     1.534    27.320     0.150
     1.534    47.703     0.150
     1.583    50.180     0.150
     1.646    50.680     0.150
     1.687    29.660     0.150
     1.757    30.762     0.150
     1.787    30.703     0.150
     1.765    30.742     0.150
     1.851    31.891     0.150
     1.949    33.070     0.150
     2.027    35.043     0.150
     2.046    34.453     0.150
     2.102    34.902     0.150
     2.241    37.051     0.150
     2.282    37.863     0.150
     2.379    38.680     0.150
     2.394    39.160     0.150
     2.409    39.633     0.150
     2.539    41.840     0.150
     2.605    42.723     0.150
     2.831    45.090     0.150
     2.836    45.652     0.150
     2.842    46.113     0.150
     2.897    46.422     0.150
     2.995    47.512     0.150
     3.138    50.223     0.150
     3.414    54.461     0.150
     3.435    54.672     0.150
     3.623    57.461     0.150
     3.726    58.910     0.150
     3.934    60.820     0.150
     4.001    61.461     0.150
     4.146    63.730     0.150
     4.169    64.832     0.150
     4.182    64.273     0.150
     4.251    66.211     0.150
     4.267    67.051     0.150
     4.365    67.730     0.150
     4.432    67.680     0.150
     4.468    66.793     0.150
     4.607    70.973     0.150
     4.615    71.352     0.150
     4.690    72.031     0.150
     4.725    72.477     0.150
     4.725   148.703     0.150
     4.725    72.281     0.150
     4.825    74.383     0.150
     4.914    75.410     0.150
     4.971    76.223     0.150
     4.995    74.391     0.150
     5.019    76.410     0.150
     5.162    78.531     0.150
     5.196    79.613     0.150
     5.270    80.293     0.150
     5.382    81.762     0.150
     5.440    82.191     0.150
     5.518    83.992     0.150
     5.631    85.180     0.150
     5.736    87.102     0.150
     6.081    91.391     0.150
     6.220    93.230     0.150
     6.699    99.641     0.150
     6.847   101.223     0.150
     7.220   106.332     0.150
     7.363   107.941     0.150
     7.432   109.133     0.150
     7.444   107.043     0.150
     7.480   107.922     0.150
    10.312   153.086     0.150
    11.792   170.902     0.150
    35.974   422.562     0.150
     0.122     3.516     0.150
     0.122     6.031     0.150
     0.206     4.492     0.150
     0.206     7.953     0.150
     0.276     6.234     0.150
     0.316     6.094     0.150
     0.316    10.523     0.150
     0.307     6.523     0.150
     0.307    11.633     0.150
     0.323     6.773     0.150
     0.323    12.836     0.150
     0.333     7.297     0.150
     0.333    13.164     0.150
     0.355     7.055     0.150
     0.355    12.547     0.150
     0.345     7.086     0.150
     0.345    12.305     0.150
     0.395     8.266     0.150
     0.410     7.953     0.150
     0.410    13.938     0.150
     0.445     8.656     0.150
     0.480     9.125     0.150
     0.480    15.773     0.150
     0.493    17.156     0.150
     0.533     9.867     0.150
     0.533    17.445     0.150
     0.606    11.594     0.150
     0.606    20.523     0.150
     0.581    11.094     0.150
     0.581    19.977     0.150
     0.597    11.492     0.150
     0.597    20.633     0.150
     0.619    11.758     0.150
     0.619    20.344     0.150
     0.660    12.836     0.150
     0.660    22.711     0.150
     0.677    12.656     0.150
     0.667    22.227     0.150
     0.686    12.852     0.150
     0.686    23.156     0.150
     0.716    13.273     0.150
     0.716    23.227     0.150
     0.817    14.586     0.150
     0.817    27.625     0.150
     0.834    27.352     0.150
     0.881    27.953     0.150
     0.881    15.836     0.150
     0.887    16.984     0.150
     0.907    16.867     0.150
     0.907    29.141     0.150
     0.910    15.883     0.150
     0.910    28.961     0.150
     0.910    16.797     0.150
     0.910    29.125     0.150
     0.947    30.367     0.150
     0.947    17.031     0.150
     0.970    18.266     0.150
     0.970    30.867     0.150
     0.970    18.125     0.150
     0.970    30.562     0.150
     0.982    18.258     0.150
     0.994    18.891     0.150
     0.994    31.766     0.150
     1.006    18.273     0.150
     1.003    18.508     0.150
     1.079    19.672     0.150
     1.079    33.875     0.150
     1.144    21.094     0.150
     1.124    34.906     0.150
     1.172    21.508     0.150
     1.155    20.781     0.150
     1.333    24.172     0.150
     2.495    40.641     0.150
     3.251    50.594     0.150
     3.729    57.852     0.150
     4.131    61.906     0.150
     4.196    63.945     0.150
     4.373    65.953     0.150
     4.454    68.141     0.150
     4.852    72.812     0.150
     4.935    74.742     0.150
     4.997    75.867     0.150
     5.290    79.281     0.150
     5.508    81.125     0.150
     5.801    85.008     0.150
     5.801   108.328     0.150
     5.801   185.086     0.150
     6.288    92.883     0.150
     6.606    96.797     0.150
     7.688   146.336     0.150
     7.688   242.039     0.150
     7.829   117.383     0.150
     7.829   146.430     0.150
     7.829   244.656     0.150
     8.751   126.477     0.150
    10.810   159.312     0.150
    10.810   202.617     0.150
    10.872   155.875     0.150
    10.872   344.562     0.150
     0.031     0.625     0.150
     0.031     2.398     0.150
     0.163     3.617     0.150
     0.163     7.258     0.150
     0.197     4.422     0.150
     0.197     6.734     0.150
     0.208     4.445     0.150
     0.208     8.016     0.150
     0.216     5.117     0.150
     0.317     6.562     0.150
     0.312     6.273     0.150
     0.312    10.156     0.150
     0.321    12.133     0.150
     0.348     7.312     0.150
     0.342     7.023     0.150
     0.342    12.469     0.150
     0.385     8.156     0.150
     0.421    13.914     0.150
     0.453     8.625     0.150
     0.488     9.086     0.150
     0.488    15.773     0.150
     0.538     9.977     0.150
     0.587    11.469     0.150
     0.603    20.398     0.150
     0.614    11.844     0.150
     0.608    11.695     0.150
     0.608    20.703     0.150
     0.647    12.656     0.150
     0.647    21.844     0.150
     0.654    12.562     0.150
     0.654    22.086     0.150
     0.690    12.266     0.150
     0.674    12.805     0.150
     0.674    22.883     0.150
     0.709    13.422     0.150
     0.709    23.312     0.150
     0.882    28.594     0.150
     0.897    16.805     0.150
     0.897    29.156     0.150
     0.900    16.062     0.150
     0.900    16.695     0.150
     0.900    29.023     0.150
     0.938    30.875     0.150
     0.973    31.258     0.150
     0.971    18.242     0.150
     0.971    30.438     0.150
     0.985    32.445     0.150
     0.993    18.227     0.150
     1.080    19.953     0.150
     1.090    19.883     0.150
     1.121    20.945     0.150
     1.140    21.258     0.150
     1.161    21.664     0.150
     1.335    24.594     0.150
     1.577    27.617     0.150
     2.075    35.805     0.150
     2.346    38.289     0.150
     2.350    38.742     0.150
     2.886    46.133     0.150
     3.079    50.367     0.150
     3.817    60.398     0.150
     7.676   241.445     0.150
     0.024     0.961     0.150
     0.157     3.648     0.150
     0.157     7.250     0.150
     0.199     4.219     0.150
     0.212     7.836     0.150
     0.212     4.586     0.150
     0.230     5.320     0.150
     0.220     9.578     0.150
     0.238     5.234     0.150
     0.238     9.867     0.150
     0.281     6.328     0.150
     0.315     6.688     0.150
     0.309     5.914     0.150
     0.309    10.508     0.150
     0.351     7.180     0.150
     0.347     6.859     0.150
     0.392     8.164     0.150
     0.418     8.094     0.150
     0.418    14.156     0.150
     0.446     8.750     0.150
     0.446    16.031     0.150
     0.494     9.867     0.150
     0.494    17.500     0.150
     0.488     9.219     0.150
     0.532     9.914     0.150
     0.532    16.906     0.150
     0.604    11.727     0.150
     0.604    20.648     0.150
     0.611    11.789     0.150
     0.611    20.617     0.150
     0.607    11.461     0.150
     0.607    20.711     0.150
     0.652    12.609     0.150
     0.652    22.117     0.150
     0.660    12.688     0.150
     0.660    22.578     0.150
     0.681    13.000     0.150
     0.683    12.477     0.150
     0.683    22.531     0.150
     0.716    13.016     0.150
     0.716    23.289     0.150
     0.821    15.039     0.150
     0.878    15.656     0.150
     0.878    27.695     0.150
     0.889    16.070     0.150
     0.900    17.734     0.150
     0.904    16.508     0.150
     0.907    16.430     0.150
     0.907    27.734     0.150
     0.907    28.641     0.150
     0.907    30.156     0.150
     0.946    30.594     0.150
     0.946    30.367     0.150
     0.975    17.547     0.150
     0.975    30.359     0.150
     0.976    17.930     0.150
     0.976    30.938     0.150
     0.981    31.500     0.150
     0.993    31.820     0.150
     1.001    18.094     0.150
     0.999    18.141     0.150
     0.999    31.586     0.150
     1.078    19.586     0.150
     1.084    19.359     0.150
     1.084    33.867     0.150
     1.097    19.484     0.150
     1.087    19.078     0.150
     1.127    20.438     0.150
     1.161    20.805     0.150
     1.138    21.086     0.150
     1.164    21.531     0.150
     1.204    21.336     0.150
     1.204    37.281     0.150
     1.206    21.547     0.150
     1.339    23.648     0.150
     1.485    26.031     0.150
     1.638    27.719     0.150
     1.741    32.141     0.150
     2.082    34.977     0.150
     3.028    45.977     0.150
     3.085    48.000     0.150
     3.245    50.219     0.150
     3.376    51.945     0.150
     3.945    59.336     0.150
     4.130    61.367     0.150
     4.190    64.414     0.150
     4.275    65.594     0.150
     4.365    66.031     0.150
     4.844    72.156     0.150
     4.930    74.648     0.150
     4.994    75.438     0.150
     4.974    75.617     0.150
     5.140    78.758     0.150
     5.284    80.055     0.150
     5.378    80.141     0.150
     5.506    80.766     0.150
     5.613    82.406     0.150
     5.648    83.711     0.150
     5.688    84.289     0.150
     6.267    93.930     0.150
     6.315    93.664     0.150
     6.316    93.617     0.150
     6.537    96.234     0.150
     6.603    97.164     0.150
     7.681   112.914     0.150
     7.681   142.062     0.150
     7.681   113.430     0.150
     7.824   114.930     0.150
     7.825   116.484     0.150
     7.825   146.555     0.150
     7.825   245.656     0.150
     7.825   114.945     0.150
     8.749   126.641     0.150
     8.922   127.547     0.150
     9.303   134.797     0.150
     9.517   138.031     0.150
    10.083   145.227     0.150
    10.256   147.180     0.150
    10.534   151.906     0.150
    10.802   157.492     0.150
    10.802   198.844     0.150
    10.802   344.062     0.150
    10.802   155.648     0.150
    10.871   155.219     0.150
    10.872   155.984     0.150
    10.872   345.500     0.150
    10.872   155.750     0.150
    11.044   158.688     0.150
    11.911   170.469     0.150
    15.237   220.258     0.150
    15.348   216.484     0.150
    17.223   239.875     0.150
    94.557   797.688     0.150
   100.594   830.484     0.150
     0.024     1.000     0.150
     0.024     2.977     0.150
     0.195     4.227     0.150
     0.195     7.367     0.150
     0.193     4.945     0.150
     0.193     9.055     0.150
     0.208     4.438     0.150
     0.208     7.820     0.150
     0.226     5.266     0.150
     0.223     4.914     0.150
     0.223     9.641     0.150
     0.280     6.438     0.150
     0.311     6.594     0.150
     0.311    11.844     0.150
     0.314     5.938     0.150
     0.314    10.547     0.150
     0.318    13.078     0.150
     0.329     7.227     0.150
     0.329    13.008     0.150
     0.347     7.047     0.150
     0.347    12.547     0.150
     0.350    12.344     0.150
     0.414     8.016     0.150
     0.392     8.023     0.150
     0.447    16.000     0.150
     0.484     9.156     0.150
     0.484    16.117     0.150
     0.492     9.750     0.150
     0.492    17.336     0.150
     0.534     9.859     0.150
     0.584    19.789     0.150
     0.608    11.445     0.150
     0.608    20.828     0.150
     0.615    11.719     0.150
     0.615    20.148     0.150
     0.682    12.453     0.150
     0.662    21.977     0.150
     0.714    13.258     0.150
     0.714    22.523     0.150
     0.821    14.617     0.150
     0.821    26.820     0.150
     0.834    27.516     0.150
     0.878    15.914     0.150
     0.878    27.445     0.150
     0.887    28.406     0.150
     0.907    16.586     0.150
     0.907    28.594     0.150
     0.971    17.555     0.150
     0.971    30.289     0.150
     1.000    17.914     0.150
     1.000    32.047     0.150
     1.001    18.008     0.150
     1.001    31.047     0.150
     1.084    19.367     0.150
     1.084    33.719     0.150
     1.111    19.586     0.150
     1.124    19.828     0.150
     1.124    34.344     0.150
     1.142    21.195     0.150
     1.142    36.125     0.150
     1.157    20.688     0.150
     1.157    36.094     0.150
     1.167    21.086     0.150
     1.167    36.516     0.150
     1.335    23.148     0.150
     1.481    25.758     0.150
     1.572    26.273     0.150
     2.348    36.367     0.150
     2.864    44.094     0.150
     3.087    46.328     0.150
     3.946    59.055     0.150
     4.000    61.141     0.150
     4.132    61.109     0.150
     4.191    63.250     0.150
     4.400    66.547     0.150
     4.450    66.805     0.150
     4.583    70.086     0.150
     4.934    73.477     0.150
     4.978    74.734     0.150
     5.144    75.977     0.150
     6.284    92.656     0.150
     6.606    96.414     0.150
     7.272   105.891     0.150
     7.784   112.695     0.150
    10.873   154.484     0.150
     0.030     3.187     0.150
     0.113     3.377     0.150
     0.113     6.057     0.150
     0.160     3.767     0.150
     0.160     7.377     0.150
     0.188     4.987     0.150
     0.206     4.517     0.150
     0.206     8.087     0.150
     0.219     4.977     0.150
     0.219     9.407     0.150
     0.286     6.397     0.150
     0.286    12.247     0.150
     0.345     7.047     0.150
     0.313     6.837     0.150
     0.313    12.347     0.150
     0.323     6.947     0.150
     0.323    12.677     0.150
     0.345     6.907     0.150
     0.345    12.847     0.150
     0.385     8.037     0.150
     0.417     8.057     0.150
     0.485     9.217     0.150
     0.485    16.487     0.150
     0.453    16.117     0.150
     0.600    11.687     0.150
     0.614    21.267     0.150
     0.611    11.807     0.150
     0.611    20.467     0.150
     0.687    12.267     0.150
     0.687    22.717     0.150
     0.708    13.087     0.150
     0.708    22.227     0.150
     0.827    14.987     0.150
     0.827    28.037     0.150
     0.881    29.297     0.150
     0.872    15.527     0.150
     0.877    15.297     0.150
     0.877    28.897     0.150
     0.893    17.884     0.150
     0.897    29.567     0.150
     0.901    28.901     0.150
     0.901    16.107     0.150
     0.901    29.787     0.150
     0.901    16.247     0.150
     0.938    30.967     0.150
     0.969    17.447     0.150
     0.970    17.777     0.150
     0.994    17.877     0.150
     0.996    17.887     0.150
     1.087    19.137     0.150
     1.087    33.977     0.150
     1.119    19.647     0.150
     1.119    34.997     0.150
     1.157    20.227     0.150
     1.157    36.607     0.150
     1.143    19.827     0.150
     1.165    20.327     0.150
     1.332    23.647     0.150
     1.482    25.517     0.150
     1.578    25.297     0.150
     1.588    26.887     0.150
     1.630    26.707     0.150
     1.667    27.977     0.150
     1.745    29.277     0.150
     2.076    34.017     0.150
     2.350    37.897     0.150
     2.354    35.457     0.150
     2.349    38.447     0.150
     2.419    39.097     0.150
     2.423    38.927     0.150
     2.449    38.857     0.150
     2.490    39.737     0.150
     2.834    44.147     0.150
     2.858    44.557     0.150
     2.889    44.657     0.150
     2.964    46.367     0.150
     3.021    47.357     0.150
     3.081    47.507     0.150
     3.205    48.827     0.150
     3.242    49.877     0.150
     3.371    51.607     0.150
     3.730    56.527     0.150
     3.820    59.347     0.150
     3.918    60.317     0.150
     4.137    60.927     0.150
     4.137    61.517     0.150
     4.281    65.247     0.150
     4.398    66.817     0.150
     4.846    73.227     0.150
     5.314    78.967     0.150
     5.674    82.737     0.150
     5.791    87.082     0.150
     5.791   182.403     0.150
     5.791    85.637     0.150
     6.418    94.957     0.150
     7.149   108.107     0.150
     7.276   106.027     0.150
     7.468   108.777     0.150
     7.470   112.127     0.150
     7.679   113.207     0.150
     7.679   145.107     0.150
     7.679   238.532     0.150
     7.679   111.917     0.150
     7.804   112.427     0.150
     7.831   116.326     0.150
     7.831   244.901     0.150
     7.831   114.387     0.150
     8.757   126.237     0.150
     9.121   136.077     0.150
    10.063   149.226     0.150
    10.063   258.876     0.150
    10.334   150.685     0.150
    10.334   326.685     0.150
    10.558   151.517     0.150
    10.804   158.307     0.150
    10.804   342.220     0.150
    10.879   155.957     0.150
    10.879   155.757     0.150
    13.694   194.677     0.150
    14.082   202.207     0.150
    14.080   200.787     0.150
    14.107   201.127     0.150
    14.265   202.327     0.150
    14.343   203.857     0.150
    14.709   208.687     0.150
    14.860   210.297     0.150
    15.151   213.937     0.150
    15.235   217.526     0.150
    15.235   215.487     0.150
    15.387   217.097     0.150
    15.411   217.757     0.150
    15.592   220.177     0.150
    17.148   238.487     0.150
    17.667   243.987     0.150
    18.271   253.317     0.150
    18.271   255.557     0.150
    18.372   257.557     0.150
    18.801   259.717     0.150
    19.805   270.527     0.150
    20.221   275.007     0.150
    20.420   276.617     0.150
    21.158   286.432     0.150
    21.265   286.587     0.150
    21.265   288.577     0.150
    21.755   291.747     0.150
    21.953   293.827     0.150
    22.525   301.507     0.150
    22.525   713.157     0.150
    22.525   300.117     0.150
    29.462   364.559     0.150
    33.251   398.057     0.150
    34.254   406.757     0.150
    34.589   409.047     0.150
    35.613   418.227     0.150
    37.049   433.107     0.150
    37.049   429.757     0.150
    52.505   555.667     0.150
    59.678   605.517     0.150
    62.461   625.257     0.150
    62.461   622.007     0.150
    73.843   697.387     0.150
    80.824   735.259     0.150
    80.824   733.027     0.150
    84.627  1388.657     0.150
    91.565   790.371     0.150
    91.565   787.377     0.150
    94.551   799.257     0.150
    95.416   802.957     0.150
    95.753   808.639     0.150
    97.341   812.057     0.150
   100.590   828.957     0.150
   106.292   851.657     0.150
   145.401  1180.197     0.150
     0.103     5.350     0.150
     0.170     4.060     0.150
     0.170     7.740     0.150
     0.207     4.530     0.150
     0.207     7.980     0.150
     0.211     4.810     0.150
     0.211     9.010     0.150
     0.234     5.500     0.150
     0.303     6.620     0.150
     0.303    12.300     0.150
     0.295     6.580     0.150
     0.295    12.230     0.150
     0.314     6.760     0.150
     0.314    12.700     0.150
     0.321     6.830     0.150
     0.321    12.030     0.150
     0.313     5.890     0.150
     0.347     7.330     0.150
     0.336     6.720     0.150
     0.336    11.750     0.150
     0.378     7.910     0.150
     0.425     8.230     0.150
     0.425    14.440     0.150
     0.460     8.850     0.150
     0.490     9.340     0.150
     0.490    16.040     0.150
     0.544     9.990     0.150
     0.587    19.700     0.150
     0.604    20.440     0.150
     0.604    11.590     0.150
     0.604    19.860     0.150
     0.622    11.550     0.150
     0.647    21.570     0.150
     0.642    21.510     0.150
     0.667    12.660     0.150
     0.702    13.090     0.150
     0.702    22.510     0.150
     0.697    12.280     0.150
     0.697    22.570     0.150
     0.825    15.630     0.150
     0.836    15.040     0.150
     0.836    27.010     0.150
     0.863    15.460     0.150
     0.863    27.100     0.150
     0.889    28.410     0.150
     0.892    16.524     0.150
     0.892    29.174     0.150
     0.892    16.000     0.150
     0.892    27.790     0.150
     0.931    29.580     0.150
     0.931    29.800     0.150
     0.969    17.430     0.150
     0.969    30.190     0.150
     0.971    17.960     0.150
     0.986    17.670     0.150
     0.986    31.300     0.150
     0.986    17.770     0.150
     1.094    19.270     0.150
     1.094    33.890     0.150
     1.116    19.730     0.150
     1.116    33.970     0.150
     1.159    20.450     0.150
     1.140    21.180     0.150
     1.197    21.280     0.150
     1.333    23.330     0.150
     1.486    25.720     0.150
     1.580    27.980     0.150
     1.624    26.880     0.150
     1.675    28.750     0.150
     2.068    34.700     0.150
     2.343    39.010     0.150
     2.348    38.740     0.150
     2.439    39.550     0.150
     2.485    40.680     0.150
     2.826    43.520     0.150
     2.954    46.060     0.150
     3.072    48.120     0.150
     3.195    49.400     0.150
     3.232    50.570     0.150
     3.362    51.380     0.150
     3.508    54.300     0.150
     3.730    57.640     0.150
     3.909    59.940     0.150
     3.931    59.310     0.150
     3.985    61.150     0.150
     4.142    61.940     0.150
     4.176    64.160     0.150
     4.278    66.370     0.150
     4.329    66.130     0.150
     4.356    65.790     0.150
     4.391    66.890     0.150
     4.435    66.770     0.150
     4.559    69.230     0.150
     4.839    72.730     0.150
     4.937    74.630     0.150
     4.979    74.200     0.150
     5.518    81.670     0.150
     5.682    83.310     0.150
     5.781    89.613     0.150
     5.781   107.380     0.150
     5.781   182.163     0.150
     5.781    86.880     0.150
     6.279    93.880     0.150
     6.522    95.290     0.150
     6.615    96.750     0.150
     7.102   105.230     0.150
     7.278   106.660     0.150
     7.292   105.750     0.150
     7.671   114.680     0.150
     7.671   143.855     0.150
     7.671   240.505     0.150
     7.671   111.180     0.150
     7.832   116.824     0.150
     7.832   146.999     0.150
     7.832   113.710     0.150
     9.315   134.400     0.150
     9.482   135.980     0.150
     9.926   142.020     0.150
    10.268   146.490     0.150
    10.546   150.740     0.150
    10.798   157.849     0.150
    10.798   203.530     0.150
    10.798   342.749     0.150
    10.885   157.405     0.150
    10.885   343.480     0.150
     0.019     1.287     0.150
     0.019     3.277     0.150
     0.149     3.657     0.150
     0.149     7.066     0.150
     0.207     4.707     0.150
     0.207     8.077     0.150
     0.223     5.237     0.150
     0.223     9.497     0.150
     0.231     5.117     0.150
     0.231     9.626     0.150
     0.228     5.157     0.150
     0.228     9.876     0.150
     0.274     6.157     0.150
     0.274    11.697     0.150
     0.307     6.577     0.150
     0.307    12.106     0.150
     0.315     6.097     0.150
     0.315    10.417     0.150
     0.324     6.997     0.150
     0.324    12.617     0.150
     0.347     6.807     0.150
     0.347    12.467     0.150
     0.334     7.187     0.150
     0.334    13.197     0.150
     0.355     7.157     0.150
     0.355    12.557     0.150
     0.397    14.396     0.150
     0.397     8.247     0.150
     0.410     7.947     0.150
     0.410    14.057     0.150
     0.443     8.606     0.150
     0.443    15.707     0.150
     0.481     9.197     0.150
     0.481    16.287     0.150
     0.495     9.856     0.150
     0.495    17.277     0.150
     0.531     9.816     0.150
     0.531    17.197     0.150
     0.582    11.106     0.150
     0.582    19.267     0.150
     0.598    11.597     0.150
     0.598    20.467     0.150
     0.603    11.327     0.150
     0.603    20.427     0.150
     0.619    12.007     0.150
     0.619    19.836     0.150
     0.660    12.847     0.150
     0.660    22.396     0.150
     0.676    22.257     0.150
     0.676    12.157     0.150
     0.668    12.626     0.150
     0.668    22.057     0.150
     0.688    12.967     0.150
     0.688    23.146     0.150
     0.718    13.336     0.150
     0.718    23.467     0.150
     0.836    14.997     0.150
     0.890    16.237     0.150
     0.890    28.457     0.150
     0.883    15.617     0.150
     0.904    15.979     0.150
     0.909    16.047     0.150
     0.909    28.287     0.150
     0.912    15.801     0.150
     0.912    29.226     0.150
     0.912    16.617     0.150
     0.912    29.027     0.150
     0.972    17.747     0.150
     1.007    17.997     0.150
     1.080    19.086     0.150
     1.156    20.586     0.150
     1.143    20.997     0.150
     1.171    20.847     0.150
     1.335    23.606     0.150
     1.478    25.517     0.150
     1.569    25.517     0.150
     1.597    29.737     0.150
     1.640    26.767     0.150
     1.658    27.606     0.150
     2.087    33.537     0.150
     2.361    41.527     0.150
     2.432    41.557     0.150
     2.494    40.527     0.150
     2.846    43.896     0.150
     2.975    48.167     0.150
     3.093    47.507     0.150
     3.252    52.007     0.150
     3.383    50.927     0.150
     3.528    54.037     0.150
     3.727    58.447     0.150
     4.129    61.907     0.150
     4.281    64.927     0.150
     4.337    67.077     0.150
     4.403    67.297     0.150
     5.506    81.217     0.150
     5.802    88.934     0.150
     5.802   108.007     0.150
     5.802   185.007     0.150
     5.802    85.697     0.150
     6.603    96.507     0.150
     7.689   115.231     0.150
     7.689   145.332     0.150
     7.689   111.947     0.150
     7.696   114.547     0.150
     7.827   117.076     0.150
     7.827   147.500     0.150
     7.827   115.146     0.150
     8.749   126.497     0.150
    10.810   159.207     0.150
    10.810   200.407     0.150
    10.870   154.957     0.150
    10.870   344.344     0.150
    10.870   154.757     0.150
    15.228   212.767     0.150
    15.245   219.526     0.150
    15.245   394.076     0.150
    15.245   484.201     0.150
    15.245   214.047     0.150
    16.243   227.157     0.150
    16.583   234.106     0.150
    18.367   255.157     0.150
    27.470   345.787     0.150
     0.037     1.382     0.150
     0.037     3.472     0.150
     0.102     3.142     0.150
     0.102     6.241     0.150
     0.170     4.102     0.150
     0.170     7.831     0.150
     0.186     4.911     0.150
     0.186     8.892     0.150
     0.202     4.382     0.150
     0.202     7.701     0.150
     0.213     4.571     0.150
     0.213     8.031     0.150
     0.239     5.521     0.150
     0.239     9.241     0.150
     0.251     5.481     0.150
     0.251    10.321     0.150
     0.295     6.571     0.150
     0.295    12.342     0.150
     0.303     6.571     0.150
     0.313     6.731     0.150
     0.313    11.762     0.150
     0.324     6.901     0.150
     0.324    12.691     0.150
     0.307     5.911     0.150
     0.307    10.512     0.150
     0.335     6.731     0.150
     0.335    11.331     0.150
     0.352     7.182     0.150
     0.352    12.611     0.150
     0.381     8.012     0.150
     0.428     8.291     0.150
     0.428    14.472     0.150
     0.456     8.892     0.150
     0.456    16.111     0.150
     0.486     9.711     0.150
     0.486    17.302     0.150
     0.495     9.451     0.150
     0.495    16.741     0.150
     0.539    10.021     0.150
     0.539    17.581     0.150
     0.592    11.281     0.150
     0.592    19.481     0.150
     0.609    11.882     0.150
     0.609    20.571     0.150
     0.600    11.642     0.150
     0.600    20.241     0.150
     0.618    11.592     0.150
     0.618    20.981     0.150
     0.647    12.291     0.150
     0.647    22.012     0.150
     0.667    12.632     0.150
     0.667    22.671     0.150
     0.707    13.191     0.150
     0.707    22.991     0.150
     0.697    22.981     0.150
     0.697    12.531     0.150
     0.830    15.382     0.150
     0.830    26.722     0.150
     0.834    14.802     0.150
     0.834    26.932     0.150
     0.866    15.481     0.150
     0.866    27.291     0.150
     0.881    16.262     0.150
     0.881    28.722     0.150
     0.888    15.901     0.150
     0.892    16.151     0.150
     0.892    28.531     0.150
     0.895    16.320     0.150
     0.895    28.771     0.150
     0.895    16.132     0.150
     0.885    15.281     0.150
     0.885    28.211     0.150
     0.935    16.961     0.150
     0.935    30.132     0.150
     0.970    17.571     0.150
     0.975    17.451     0.150
     0.975    31.441     0.150
     0.977    18.571     0.150
     0.977    31.262     0.150
     0.982    17.722     0.150
     0.990    17.932     0.150
     0.986    17.781     0.150
     1.054    18.571     0.150
     1.068    18.861     0.150
     1.052    32.432     0.150
     1.084    19.222     0.150
     1.084    34.241     0.150
     1.089    19.432     0.150
     1.098    19.401     0.150
     1.098    35.262     0.150
     1.098    19.182     0.150
     1.122    34.802     0.150
     1.122    19.632     0.150
     1.135    21.762     0.150
     1.165    20.661     0.150
     1.154    21.441     0.150
     1.193    20.671     0.150
     1.203    21.432     0.150
     1.261    21.671     0.150
     1.308    22.182     0.150
     1.317    24.302     0.150
     1.317    41.531     0.150
     1.316    22.392     0.150
     1.338    23.432     0.150
     1.363    23.132     0.150
     1.393    23.941     0.150
     1.428    26.791     0.150
     1.491    25.741     0.150
     1.507    25.701     0.150
     1.678    27.842     0.150
     1.713    28.842     0.150
     1.737    31.941     0.150
     2.071    33.602     0.150
     2.360    35.781     0.150
     2.412    41.092     0.150
     2.956    45.512     0.150
     3.072    48.791     0.150
     4.137    61.142     0.150
     4.982    75.291     0.150
     5.132    79.371     0.150
     5.781    88.468     0.150
     5.781   107.468     0.150
     6.302    94.661     0.150
     6.609    96.382     0.150
     7.096   103.251     0.150
     7.272   106.291     0.150
     7.286   107.191     0.150
     7.465   109.501     0.150
     7.669   114.251     0.150
     7.669   144.751     0.150
     7.669   243.477     0.150
     7.669   111.961     0.150
     7.827   115.420     0.150
     7.827   144.245     0.150
     7.827   246.545     0.150
     8.756   126.481     0.150
    10.072   147.646     0.150
    10.794   158.372     0.150
    10.881   156.126     0.150
    10.881   342.278     0.150
    15.224   220.096     0.150
    15.233   214.142     0.150
    15.353   216.821     0.150
    15.377   217.722     0.150
    15.373   216.371     0.150
    15.832   222.121     0.150
    25.027   322.771     0.150
    26.051   332.371     0.150
    27.482   345.842     0.150
    28.017   350.592     0.150
    28.200   351.222     0.150
    37.040   431.553     0.150
    94.543   798.802     0.150
    97.949   815.201     0.150
   110.924  1112.501     0.150
     0.030     2.559     0.150
     0.167     3.879     0.150
     0.167     7.836     0.150
     0.213     4.617     0.150
     0.213     8.086     0.150
     0.225     4.797     0.150
     0.225     8.156     0.150
     0.245     5.648     0.150
     0.245     9.996     0.150
     0.242    10.137     0.150
     0.288     6.270     0.150
     0.288    12.148     0.150
     0.295     5.609     0.150
     0.295     9.797     0.150
     0.309     6.637     0.150
     0.309    12.586     0.150
     0.318     6.809     0.150
     0.318    12.586     0.150
     0.329     6.957     0.150
     0.329    12.316     0.150
     0.336     6.668     0.150
     0.336    11.879     0.150
     0.365     7.367     0.150
     0.365    13.066     0.150
     0.393    14.727     0.150
     0.393     8.277     0.150
     0.432     8.316     0.150
     0.432    14.488     0.150
     0.443     8.668     0.150
     0.443    15.879     0.150
     0.500     9.969     0.150
     0.500    17.520     0.150
     0.503    16.727     0.150
     0.503     9.617     0.150
     0.525     9.789     0.150
     0.525    17.289     0.150
     0.570    11.238     0.150
     0.570    19.969     0.150
     0.603    11.469     0.150
     0.603    19.867     0.150
     0.598    20.359     0.150
     0.598    11.496     0.150
     0.619    20.789     0.150
     0.606    11.398     0.150
     0.606    20.809     0.150
     0.641    12.336     0.150
     0.652    12.406     0.150
     0.652    22.047     0.150
     0.675    12.617     0.150
     0.691    12.906     0.150
     0.721    13.367     0.150
     0.845    15.547     0.150
     0.845    27.699     0.150
     0.877    15.859     0.150
     0.896    16.348     0.150
     0.900    29.000     0.150
     0.904    16.418     0.150
     0.907    16.492     0.150
     0.907    29.242     0.150
     0.948    30.449     0.150
     0.988    17.688     0.150
     0.991    17.648     0.150
     1.003    18.219     0.150
     1.101    19.598     0.150
     1.136    19.887     0.150
     1.123    21.008     0.150
     1.149    20.207     0.150
     1.176    21.227     0.150
     1.500    25.348     0.150
     1.563    27.289     0.150
     1.576    27.277     0.150
     1.679    28.309     0.150
     2.083    35.227     0.150
     2.329    39.438     0.150
     2.348    35.848     0.150
     2.359    42.508     0.150
     3.236    49.277     0.150
     4.123    61.719     0.150
     5.634    84.559     0.150
     5.690    87.117     0.150
     5.787    87.191     0.150
     5.787   108.242     0.150
     6.265    94.008     0.150
     6.595    96.727     0.150
     7.668   142.523     0.150
     7.668   241.148     0.150
     7.813   146.141     0.150
     7.813   244.867     0.150
    10.788   158.441     0.150
    10.867   155.074     0.150
     0.167     3.961     0.150
     0.167     7.672     0.150
     0.224     4.852     0.150
     0.224     8.391     0.150
     0.243     5.359     0.150
     0.243    10.059     0.150
     0.244     5.648     0.150
     0.244    10.328     0.150
     0.288     6.430     0.150
     0.288    11.961     0.150
     0.296     5.730     0.150
     0.296     9.910     0.150
     0.308     6.711     0.150
     0.308    12.430     0.150
     0.318     6.852     0.150
     0.318    13.109     0.150
     0.336     6.719     0.150
     0.336    12.070     0.150
     0.364     7.352     0.150
     0.364    12.949     0.150
     0.393     8.230     0.150
     0.393    14.660     0.150
     0.430    15.988     0.150
     0.431     8.352     0.150
     0.431    14.539     0.150
     0.444     8.672     0.150
     0.444    15.891     0.150
     0.502     9.551     0.150
     0.502    16.398     0.150
     0.499     9.961     0.150
     0.499    17.320     0.150
     0.525     9.801     0.150
     0.525    17.219     0.150
     0.602    11.512     0.150
     0.602    19.719     0.150
     0.598    11.500     0.150
     0.606    11.410     0.150
     0.606    20.531     0.150
     0.618    11.891     0.150
     0.618    20.480     0.150
     0.675    12.891     0.150
     0.691    12.379     0.150
     0.720    13.379     0.150
     0.720    24.070     0.150
     0.825    14.590     0.150
     0.844    15.559     0.150
     0.876    15.770     0.150
     0.895    16.301     0.150
     0.899    16.863     0.150
     0.907    16.594     0.150
     0.907    28.668     0.150
     0.907    16.328     0.150
     0.987    17.809     0.150
     0.991    17.602     0.150
     1.002    18.031     0.150
     1.101    19.230     0.150
     1.124    20.238     0.150
     1.135    19.891     0.150
     1.150    19.840     0.150
     1.175    20.711     0.150
     1.351    23.922     0.150
     1.499    26.148     0.150
     1.564    25.512     0.150
     1.641    26.898     0.150
     1.679    28.211     0.150
     1.727    31.770     0.150
     2.082    33.980     0.150
     2.349    35.520     0.150
     2.358    37.809     0.150
     2.428    43.301     0.150
     2.446    38.391     0.150
     2.473    39.871     0.150
     5.787    87.312     0.150
     5.787   183.535     0.150
     7.669   238.375     0.150
     7.813   114.594     0.150
     7.813   241.094     0.150
    10.788   157.750     0.150
    10.788   344.773     0.150
    10.867   158.035     0.150
     0.027     1.352     0.150
     0.027     3.516     0.150
     0.164     3.945     0.150
     0.164     7.617     0.150
     0.210     4.570     0.150
     0.210     7.953     0.150
     0.222     4.867     0.150
     0.222     8.062     0.150
     0.240     5.336     0.150
     0.240     9.711     0.150
     0.241     5.531     0.150
     0.200     5.195     0.150
     0.200     9.664     0.150
     0.212     4.922     0.150
     0.212     9.250     0.150
     0.285     6.336     0.150
     0.285    11.711     0.150
     0.325     6.922     0.150
     0.325    12.055     0.150
     0.299     5.852     0.150
     0.299    10.023     0.150
     0.362     7.344     0.150
     0.362    12.711     0.150
     0.340     6.852     0.150
     0.340    11.797     0.150
     0.428     8.266     0.150
     0.428    14.891     0.150
     0.394     8.086     0.150
     0.394    14.531     0.150
     0.443     8.672     0.150
     0.443    15.875     0.150
     0.499     9.383     0.150
     0.499    16.383     0.150
     0.499     9.953     0.150
     0.526     9.812     0.150
     0.526    17.266     0.150
     0.599    11.586     0.150
     0.599    19.547     0.150
     0.569    11.195     0.150
     0.605    11.391     0.150
     0.605    20.570     0.150
     0.615    12.062     0.150
     0.615    20.617     0.150
     0.602    11.742     0.150
     0.602    19.695     0.150
     0.688    12.617     0.150
     0.644    12.516     0.150
     0.644    21.625     0.150
     0.655    12.516     0.150
     0.655    21.781     0.150
     0.677    12.695     0.150
     0.677    23.336     0.150
     0.721    23.281     0.150
     0.721    13.250     0.150
     0.843    15.453     0.150
     0.843    27.406     0.150
     0.895    16.211     0.150
     0.878    15.664     0.150
     0.878    28.266     0.150
     0.905    16.367     0.150
     0.905    29.391     0.150
     0.908    16.312     0.150
     0.908    29.438     0.150
     0.908    16.203     0.150
     0.908    29.211     0.150
     0.985    17.438     0.150
     1.003    17.992     0.150
     0.994    17.641     0.150
     1.097    19.133     0.150
     1.097    34.594     0.150
     1.135    20.125     0.150
     1.135    35.188     0.150
     1.172    20.805     0.150
     1.154    20.172     0.150
     1.349    24.211     0.150
     1.496    26.188     0.150
     1.564    25.320     0.150
     1.580    26.852     0.150
     1.675    29.047     0.150
     1.642    26.875     0.150
     2.290    35.086     0.150
     2.084    34.711     0.150
     2.347    36.531     0.150
     2.332    37.484     0.150
     2.360    37.555     0.150
     2.429    37.703     0.150
     2.449    39.836     0.150
     2.476    40.391     0.150
     2.860    44.531     0.150
     2.967    45.711     0.150
     3.030    47.695     0.150
     5.790    87.133     0.150
     7.672   143.047     0.150
     7.672   237.617     0.150
     7.815   113.859     0.150
     7.815   144.164     0.150
     7.815   244.016     0.150
    10.792   158.094     0.150
    10.792   340.938     0.150
    10.867   156.617     0.150
    10.867   340.469     0.150
    15.229   218.836     0.150
     0.021     1.617     0.150
     0.021     3.453     0.150
     0.130     3.328     0.150
     0.130     6.344     0.150
     0.185     4.234     0.150
     0.185     7.156     0.150
     0.199     4.453     0.150
     0.199     7.484     0.150
     0.206     5.305     0.150
     0.205     4.969     0.150
     0.205     9.117     0.150
     0.215     4.914     0.150
     0.215     8.805     0.150
     0.249     5.688     0.150
     0.249    10.625     0.150
     0.257     5.953     0.150
     0.327     6.438     0.150
     0.327    11.000     0.150
     0.338     7.000     0.150
     0.338    11.688     0.150
     0.343    12.977     0.150
     0.353     7.680     0.150
     0.353    13.625     0.150
     0.375     7.477     0.150
     0.375    13.266     0.150
     0.390     7.609     0.150
     0.409     8.539     0.150
     0.435     8.523     0.150
     0.435    15.625     0.150
     0.465     8.906     0.150
     0.465    15.195     0.150
     0.501    10.062     0.150
     0.501    17.188     0.150
     0.528     9.805     0.150
     0.571    11.266     0.150
     0.571    19.969     0.150
     0.569    10.875     0.150
     0.569    18.680     0.150
     0.639    12.414     0.150
     0.639    21.156     0.150
     0.657    12.188     0.150
     0.657    22.234     0.150
     0.680    13.086     0.150
     0.680    22.617     0.150
     0.687    13.016     0.150
     0.687    22.617     0.150
     0.725    13.312     0.150
     0.725    23.406     0.150
     0.800    14.906     0.150
     0.837    15.586     0.150
     0.894    16.305     0.150
     0.897    15.867     0.150
     0.897    28.188     0.150
     0.922    16.914     0.150
     0.925    16.547     0.150
     0.925    28.750     0.150
     0.925    16.438     0.150
     0.965    17.438     0.150
     1.016    18.188     0.150
     1.026    18.344     0.150
     1.060    18.789     0.150
     1.126    19.984     0.150
     1.126    34.719     0.150
     1.144    20.312     0.150
     1.144    35.648     0.150
     1.155    20.414     0.150
     1.190    20.719     0.150
     1.327    23.500     0.150
     1.463    25.398     0.150
     1.566    25.469     0.150
     1.617    28.984     0.150
     1.648    26.898     0.150
     1.638    27.656     0.150
     2.258    35.008     0.150
     2.099    34.453     0.150
     2.330    35.430     0.150
     2.354    36.859     0.150
     2.371    38.508     0.150
     2.439    38.516     0.150
     2.452    39.258     0.150
     2.479    39.133     0.150
     2.511    39.969     0.150
     2.859    44.766     0.150
     2.888    44.789     0.150
     2.919    45.023     0.150
     2.992    47.914     0.150
     3.112    48.844     0.150
     3.234    49.398     0.150
     3.272    50.008     0.150
     3.401    52.445     0.150
     3.489    53.773     0.150
     3.735    57.133     0.150
     3.969    60.789     0.150
     4.126    60.906     0.150
     4.293    64.859     0.150
     4.352    66.188     0.150
     4.422    66.250     0.150
     4.871    72.406     0.150
     4.940    74.555     0.150
     5.000    76.016     0.150
     5.821    88.914     0.150
     5.821   107.414     0.150
     5.821   181.703     0.150
     7.709   145.203     0.150
     7.709   241.609     0.150
     7.833   148.078     0.150
     7.833   244.672     0.150
    10.828   158.406     0.150
    10.864   155.688     0.150
    10.864   343.219     0.150
     0.050     1.734     0.150
     0.081     4.844     0.150
     0.203     4.148     0.150
     0.203     7.148     0.150
     0.245     4.562     0.150
     0.245     8.164     0.150
     0.338     7.273     0.150
     0.338    13.320     0.150
     0.309     6.234     0.150
     0.313     6.289     0.150
     0.313    10.750     0.150
     0.301     6.539     0.150
     0.301    12.172     0.150
     0.368     7.867     0.150
     0.368    13.867     0.150
     0.364     7.453     0.150
     0.364    13.852     0.150
     0.414     8.711     0.150
     0.414    15.969     0.150
     0.445    15.352     0.150
     0.467     9.117     0.150
     0.467    15.938     0.150
     0.488     9.719     0.150
     0.507    17.523     0.150
     0.528    10.398     0.150
     0.528    18.281     0.150
     0.561    11.070     0.150
     0.561    19.781     0.150
     0.520    10.219     0.150
     0.520    18.430     0.150
     0.562    10.484     0.150
     0.566    18.383     0.150
     0.618    11.562     0.150
     0.618    19.797     0.150
     0.694    12.992     0.150
     0.694    23.422     0.150
     0.660    12.164     0.150
     0.660    21.859     0.150
     0.701    22.930     0.150
     0.724    13.891     0.150
     0.793    14.438     0.150
     0.793    25.680     0.150
     0.832    15.188     0.150
     0.832    27.453     0.150
     0.832    27.219     0.150
     0.851    27.664     0.150
     0.865    16.117     0.150
     0.865    28.898     0.150
     0.819    14.320     0.150
     0.819    26.422     0.150
     0.884    28.641     0.150
     0.894    29.617     0.150
     0.894    29.242     0.150
     0.922    30.422     0.150
     0.941    17.430     0.150
     0.941    31.539     0.150
     0.944    30.789     0.150
     0.932    16.664     0.150
     0.932    31.078     0.150
     1.003    32.109     0.150
     1.016    18.422     0.150
     1.024    18.750     0.150
     1.024    34.328     0.150
     1.046    18.469     0.150
     1.046    32.633     0.150
     1.048    18.789     0.150
     1.150    20.117     0.150
     1.231    21.281     0.150
     1.231    37.508     0.150
     1.264    22.148     0.150
     1.398    24.031     0.150
     1.410    24.430     0.150
     1.443    24.203     0.150
     1.580    29.133     0.150
     1.608    27.617     0.150
     1.595    25.961     0.150
     1.634    29.180     0.150
     1.812    29.750     0.150
     2.278    37.570     0.150
     2.293    36.352     0.150
     2.422    36.898     0.150
     2.364    38.141     0.150
     2.437    37.031     0.150
     2.754    43.781     0.150
     2.855    44.297     0.150
     3.292    62.070     0.150
     3.315    51.023     0.150
     3.489    65.523     0.150
     3.556    67.062     0.150
     3.741    70.547     0.150
     3.777    71.992     0.150
     5.662   105.336     0.150
     5.662   180.039     0.150
     5.766   105.648     0.150
     6.142   113.617     0.150
     6.179   113.859     0.150
     7.534   113.320     0.150
     7.534   234.969     0.150
     7.778   243.039     0.150
     7.778   112.148     0.150
    10.667   156.820     0.150
    10.667   201.812     0.150
    10.908   155.852     0.150
    15.091   220.289     0.150
    15.091   211.742     0.150
    15.448   215.680     0.150
    94.439   798.492     0.150
     0.017     1.711     0.150
     0.067     1.773     0.150
     0.067     4.141     0.150
     0.143     3.531     0.150
     0.143     6.781     0.150
     0.224     4.633     0.150
     0.224     8.250     0.150
     0.281     6.203     0.150
     0.281    11.227     0.150
     0.273     5.055     0.150
     0.273     8.859     0.150
     0.277     5.742     0.150
     0.277     9.750     0.150
     0.280     5.820     0.150
     0.280     9.961     0.150
     0.339    12.984     0.150
     0.352     7.211     0.150
     0.400     8.383     0.150
     0.400    15.625     0.150
     0.412     8.297     0.150
     0.412    14.359     0.150
     0.464     9.359     0.150
     0.496     9.570     0.150
     0.496    16.383     0.150
     0.523    10.109     0.150
     0.523    18.242     0.150
     0.535    10.109     0.150
     0.535    17.586     0.150
     0.529    10.414     0.150
     0.529    18.047     0.150
     0.540    18.852     0.150
     0.587    11.055     0.150
     0.587    19.016     0.150
     0.567    11.156     0.150
     0.567    19.953     0.150
     0.607    20.477     0.150
     0.679    12.500     0.150
     0.679    21.781     0.150
     0.673    12.609     0.150
     0.691    13.375     0.150
     0.691    22.891     0.150
     0.804    14.180     0.150
     0.825    26.891     0.150
     0.824    14.719     0.150
     0.824    26.898     0.150
     0.824    15.242     0.150
     0.824    26.727     0.150
     0.880    29.023     0.150
     0.878    16.391     0.150
     0.878    28.641     0.150
     0.910    30.234     0.150
     0.929    17.312     0.150
     1.014    18.094     0.150
     1.005    18.047     0.150
     1.005    32.172     0.150
     1.007    18.109     0.150
     1.029    18.383     0.150
     1.054    19.070     0.150
     1.054    19.523     0.150
     1.054    34.844     0.150
     1.080    20.516     0.150
     1.080    19.797     0.150
     1.123    19.703     0.150
     1.202    20.930     0.150
     1.202    36.453     0.150
     1.231    21.680     0.150
     1.239    21.594     0.150
     1.378    24.516     0.150
     1.469    25.641     0.150
     1.575    27.102     0.150
     1.581    26.305     0.150
     1.612    27.023     0.150
     1.603    26.984     0.150
     1.787    28.812     0.150
     2.001    32.875     0.150
     2.407    35.445     0.150
     2.283    37.164     0.150
     2.302    38.844     0.150
     2.334    39.414     0.150
     2.356    38.742     0.150
     2.749    52.695     0.150
     2.750    43.945     0.150
     2.768    51.422     0.150
     2.951    46.492     0.150
     3.096    59.773     0.150
     5.675   105.781     0.150
     5.675   177.992     0.150
     7.558   141.453     0.150
     7.558   236.930     0.150
     7.806   116.023     0.150
     7.806   145.570     0.150
     7.806   243.695     0.150
    10.698   156.852     0.150
    10.923   156.156     0.150
    10.923   341.695     0.150
     0.099     4.744     0.150
     0.231     4.773     0.150
     0.231     7.684     0.150
     0.236     5.104     0.150
     0.236     8.203     0.150
     0.269     5.635     0.150
     0.269     9.074     0.150
     0.273     6.293     0.150
     0.273    10.443     0.150
     0.302     9.854     0.150
     0.306     6.123     0.150
     0.293     6.074     0.150
     0.293     9.664     0.150
     0.313     6.434     0.150
     0.313    10.555     0.150
     0.336     7.074     0.150
     0.336    11.764     0.150
     0.341     6.773     0.150
     0.341    10.963     0.150
     0.352     7.805     0.150
     0.352    12.943     0.150
     0.419     8.184     0.150
     0.419    14.234     0.150
     0.429     8.713     0.150
     0.429    14.484     0.150
     0.449     9.123     0.150
     0.449    15.234     0.150
     0.454     8.867     0.150
     0.454    14.943     0.150
     0.456     8.873     0.150
     0.457     8.904     0.150
     0.457    14.514     0.150
     0.472     9.225     0.150
     0.472    15.805     0.150
     0.458     9.135     0.150
     0.458    16.064     0.150
     0.502    10.395     0.150
     0.502    17.273     0.150
     0.503     9.885     0.150
     0.503    16.543     0.150
     0.539    10.594     0.150
     0.539    17.494     0.150
     0.534    10.443     0.150
     0.534    17.494     0.150
     0.603    11.904     0.150
     0.603    19.914     0.150
     0.626    12.574     0.150
     0.626    21.193     0.150
     0.627    12.494     0.150
     0.627    20.324     0.150
     0.636    12.385     0.150
     0.636    20.953     0.150
     0.652    12.873     0.150
     0.652    21.873     0.150
     0.681    13.023     0.150
     0.681    22.064     0.150
     0.671    13.314     0.150
     0.671    21.984     0.150
     0.696    23.475     0.150
     0.673    12.934     0.150
     0.673    21.994     0.150
     0.690    13.363     0.150
     0.690    22.305     0.150
     0.683    13.363     0.150
     0.683    22.463     0.150
     0.697    13.555     0.150
     0.697    23.373     0.150
     0.735    14.395     0.150
     0.735    24.084     0.150
     0.739    24.293     0.150
     0.738    24.914     0.150
     0.773    14.094     0.150
     0.773    24.574     0.150
     0.775    14.873     0.150
     0.775    25.213     0.150
     0.801    15.373     0.150
     0.801    25.684     0.150
     0.791    15.414     0.150
     0.791    25.754     0.150
     0.809    15.043     0.150
     0.809    25.764     0.150
     0.820    16.064     0.150
     0.823    15.334     0.150
     0.823    26.344     0.150
     0.837    27.283     0.150
     0.831    16.504     0.150
     0.842    16.305     0.150
     0.842    27.475     0.150
     0.839    16.293     0.150
     0.839    27.734     0.150
     0.895    16.623     0.150
     0.895    28.273     0.150
     0.910    17.234     0.150
     0.933    17.924     0.150
     0.984    18.293     0.150
     0.979    18.805     0.150
     1.008    18.623     0.150
     1.156    21.104     0.150
     1.222    22.943     0.150
     1.273    22.443     0.150
     1.273    23.314     0.150
     1.565    28.074     0.150
     1.675    28.344     0.150
     1.818    29.734     0.150
     1.801    31.523     0.150
     1.882    32.055     0.150
     2.053    33.523     0.150
     2.129    36.334     0.150
     2.143    35.994     0.150
     2.363    38.854     0.150
     2.450    40.533     0.150
     2.537    41.693     0.150
     2.670    43.084     0.150
     2.771    44.953     0.150
     2.989    48.203     0.150
     3.043    48.914     0.150
     3.071    47.773     0.150
     3.377    53.863     0.150
     3.413    54.363     0.150
     3.569    56.475     0.150
     3.801    59.234     0.150
     3.886    59.805     0.150
     4.221    65.094     0.150
     4.271    66.635     0.150
     4.380    66.555     0.150
     4.652    71.324     0.150
     4.689    71.713     0.150
     4.697    72.395     0.150
     4.865    74.385     0.150
     4.930    75.824     0.150
     5.060    77.924     0.150
     5.056    77.283     0.150
     5.119    79.475     0.150
     5.119   163.723     0.150
     5.520    84.414     0.150
     5.688    86.764     0.150
     5.922    88.654     0.150
     6.772   100.693     0.150
     7.439   111.475     0.150
     7.439   139.873     0.150
     7.439   233.174     0.150
     8.114   120.023     0.150
     8.339   122.174     0.150
     8.340   121.504     0.150
     8.533   123.904     0.150
     8.828   128.643     0.150
     8.828   163.168     0.150
     8.828   276.693     0.150
     8.828   128.873     0.150
     9.471   138.771     0.150
     9.471   297.062     0.150
    10.996   162.955     0.150
    12.059   172.998     0.150
    22.882   306.850     0.150
     0.229     5.102     0.150
     0.229     8.539     0.150
     0.233     5.297     0.150
     0.233     8.758     0.150
     0.391     8.102     0.150
     0.440     8.711     0.150
     0.440    15.719     0.150
     0.437     8.320     0.150
     0.437    14.586     0.150
     0.450     8.852     0.150
     0.453     8.969     0.150
     0.453    15.477     0.150
     0.495     8.961     0.150
     0.495    15.039     0.150
     0.498     9.039     0.150
     0.498    15.539     0.150
     0.506     9.547     0.150
     0.506    16.680     0.150
     0.541     9.836     0.150
     0.541    16.570     0.150
     0.499    10.047     0.150
     0.499    17.586     0.150
     0.566    11.141     0.150
     0.566    19.867     0.150
     0.586    11.438     0.150
     0.586    19.398     0.150
     0.639    11.789     0.150
     0.639    20.102     0.150
     0.652    12.320     0.150
     0.648    11.852     0.150
     0.648    19.969     0.150
     0.654    11.992     0.150
     0.654    20.445     0.150
     0.659    12.078     0.150
     0.659    20.852     0.150
     0.656    12.031     0.150
     0.656    20.461     0.150
     0.672    12.070     0.150
     0.651    11.859     0.150
     0.667    12.719     0.150
     0.667    22.547     0.150
     0.704    12.992     0.150
     0.704    22.008     0.150
     0.711    13.586     0.150
     0.711    23.016     0.150
     0.733    13.445     0.150
     0.733    22.938     0.150
     0.760    14.016     0.150
     0.760    23.719     0.150
     0.788    14.758     0.150
     0.788    26.359     0.150
     0.729    14.398     0.150
     0.800    15.086     0.150
     0.800    26.602     0.150
     0.827    14.859     0.150
     0.827    26.055     0.150
     0.839    14.859     0.150
     0.839    25.711     0.150
     0.855    15.508     0.150
     0.855    26.281     0.150
     0.859    15.789     0.150
     0.895    15.766     0.150
     0.895    27.969     0.150
     0.912    16.555     0.150
     0.912    16.797     0.150
     0.912    28.391     0.150
     0.912    16.969     0.150
     0.912    28.930     0.150
     0.924    28.617     0.150
     0.923    16.469     0.150
     0.923    29.602     0.150
     0.936    17.031     0.150
     0.936    28.695     0.150
     0.916    17.102     0.150
     0.940    17.047     0.150
     0.940    30.297     0.150
     0.968    17.547     0.150
     0.955    18.398     0.150
     0.955    18.906     0.150
     0.955    31.422     0.150
     1.097    19.789     0.150
     1.019    19.898     0.150
     1.143    19.625     0.150
     1.123    19.617     0.150
     1.172    20.289     0.150
     1.172    34.797     0.150
     1.192    20.555     0.150
     1.155    20.328     0.150
     1.155    35.570     0.150
     1.145    20.906     0.150
     1.145    35.688     0.150
     1.247    22.695     0.150
     1.276    21.625     0.150
     1.276    37.195     0.150
     1.277    22.758     0.150
     1.281    22.156     0.150
     1.291    22.039     0.150
     1.384    23.445     0.150
     1.449    24.711     0.150
     1.532    26.156     0.150
     1.597    26.648     0.150
     1.600    26.469     0.150
     1.691    29.195     0.150
     1.773    29.219     0.150
     1.722    30.031     0.150
     1.848    31.281     0.150
     1.940    32.008     0.150
     2.015    33.898     0.150
     2.052    32.695     0.150
     2.117    33.828     0.150
     2.119    34.727     0.150
     2.135    35.016     0.150
     2.217    35.859     0.150
     2.243    36.398     0.150
     2.319    37.906     0.150
     2.386    37.898     0.150
     2.412    38.422     0.150
     2.403    39.305     0.150
     2.485    39.320     0.150
     2.464    39.086     0.150
     2.480    39.922     0.150
     2.620    41.180     0.150
     2.793    43.492     0.150
     2.783    43.328     0.150
     2.832    43.445     0.150
     3.051    42.891     0.150
     3.023    45.625     0.150
     3.062    47.070     0.150
     3.172    48.195     0.150
     3.172    50.070     0.150
     3.198    49.906     0.150
     3.330    51.586     0.150
     3.423    52.211     0.150
     3.682    55.586     0.150
     3.682    56.406     0.150
     3.779    57.258     0.150
     3.860    59.305     0.150
     3.856    58.586     0.150
     3.963    60.117     0.150
     4.111    62.391     0.150
     4.289    65.086     0.150
     4.416    66.680     0.150
     4.439    66.867     0.150
     4.538    66.992     0.150
     4.632    70.031     0.150
     4.700    69.422     0.150
     4.678    69.227     0.150
     4.922    71.250     0.150
     5.051    72.375     0.150
     5.514    79.898     0.150
     5.549    80.406     0.150
     5.591    80.789     0.150
     5.566    80.289     0.150
     5.850    83.891     0.150
     5.892    84.977     0.150
     6.079    86.789     0.150
     6.078    88.445     0.150
     6.303    89.906     0.150
     6.387    91.648     0.150
     6.541    93.688     0.150
     6.683    94.805     0.150
     6.859    97.672     0.150
     6.880    98.188     0.150
     6.936   100.398     0.150
     6.996   100.422     0.150
     6.970   101.797     0.150
     6.984   101.500     0.150
     7.047   101.375     0.150
     7.031   100.961     0.150
     7.192   102.172     0.150
     7.204   102.508     0.150
     7.210   102.406     0.150
     7.224   102.367     0.150
     7.258   103.188     0.150
     7.294   103.750     0.150
     7.359   105.891     0.150
     7.390   106.492     0.150
     7.433   106.188     0.150
     7.453   107.070     0.150
     7.486   107.648     0.150
     7.483   107.656     0.150
     7.533   108.289     0.150
     7.892   112.555     0.150
     7.892   112.078     0.150
     7.892   112.320     0.150
    10.940   156.227     0.150
    11.333   161.578     0.150
    11.334   162.297     0.150
     0.011     0.328     0.150
     0.011     1.410     0.150
     0.011     1.148     0.150
     0.071     1.750     0.150
     0.071     4.441     0.150
     0.095     2.352     0.150
     0.095     5.039     0.150
     0.112     2.609     0.150
     0.151     3.648     0.150
     0.151     6.719     0.150
     0.194     4.578     0.150
     0.194     8.328     0.150
     0.191     9.301     0.150
     0.203     4.758     0.150
     0.203     9.051     0.150
     0.215     4.441     0.150
     0.215     8.121     0.150
     0.262     4.898     0.150
     0.262     8.691     0.150
     0.288     6.391     0.150
     0.289     5.871     0.150
     0.289    11.270     0.150
     0.293     9.961     0.150
     0.293     6.008     0.150
     0.350    13.590     0.150
     0.328     7.238     0.150
     0.366    13.660     0.150
     0.425     8.410     0.150
     0.425    14.898     0.150
     0.485     9.430     0.150
     0.468     9.500     0.150
     0.468    15.910     0.150
     0.520    10.168     0.150
     0.520    17.738     0.150
     0.574    10.730     0.150
     0.574    18.559     0.150
     0.535    10.551     0.150
     0.535    18.418     0.150
     0.545    10.309     0.150
     0.545    18.250     0.150
     0.568    10.969     0.150
     0.568    19.281     0.150
     0.599    11.102     0.150
     0.599    19.641     0.150
     0.647    12.590     0.150
     0.605    11.988     0.150
     0.605    20.941     0.150
     0.672    12.148     0.150
     0.672    22.258     0.150
     0.611    11.770     0.150
     0.611    20.160     0.150
     0.626    12.102     0.150
     0.626    21.121     0.150
     0.690    12.980     0.150
     0.644    11.871     0.150
     0.644    21.309     0.150
     0.706    13.379     0.150
     0.680    12.820     0.150
     0.680    22.340     0.150
     0.681    12.770     0.150
     0.681    23.250     0.150
     0.705    13.641     0.150
     0.705    24.250     0.150
     0.703    13.570     0.150
     0.703    23.840     0.150
     0.774    14.039     0.150
     0.725    13.398     0.150
     0.725    25.039     0.150
     0.760    14.500     0.150
     0.760    25.609     0.150
     0.808    14.180     0.150
     0.808    27.000     0.150
     0.794    14.801     0.150
     0.794    27.551     0.150
     0.789    14.418     0.150
     0.813    15.418     0.150
     0.813    27.621     0.150
     0.826    15.270     0.150
     0.824    27.121     0.150
     0.826    26.125     0.150
     0.826    27.508     0.150
     0.835    15.648     0.150
     0.835    27.398     0.150
     0.854    15.930     0.150
     0.873    16.250     0.150
     0.869    16.141     0.150
     0.869    28.430     0.150
     0.885    16.441     0.150
     0.885    29.500     0.150
     0.885    16.410     0.150
     0.885    29.430     0.150
     0.893    16.531     0.150
     0.893    28.320     0.150
     0.898    16.371     0.150
     0.907    16.879     0.150
     0.907    29.711     0.150
     0.914    16.602     0.150
     0.914    30.621     0.150
     0.920    29.758     0.150
     0.933    17.320     0.150
     0.933    30.078     0.150
     0.935    17.199     0.150
     1.043    19.418     0.150
     1.009    17.961     0.150
     1.009    32.281     0.150
     1.068    19.488     0.150
     1.068    20.539     0.150
     1.026    18.020     0.150
     1.133    19.820     0.150
     1.212    21.219     0.150
     1.207    21.879     0.150
     1.244    22.000     0.150
     1.323    25.168     0.150
     1.390    23.758     0.150
     1.606    27.801     0.150
     1.587    27.328     0.150
     1.797    29.680     0.150
     2.301    36.699     0.150
     2.287    36.641     0.150
     2.384    37.941     0.150
     2.438    36.770     0.150
     2.664    40.430     0.150
     2.746    42.602     0.150
     2.761    50.281     0.150
     2.751    49.441     0.150
     2.857    43.918     0.150
     2.954    54.129     0.150
     2.966    60.711     0.150
     3.304    62.121     0.150
     3.501    66.328     0.150
     3.520    67.699     0.150
     3.523    66.629     0.150
     3.540    67.121     0.150
     3.546    66.629     0.150
     3.551    67.090     0.150
     3.569    67.461     0.150
     3.692    69.699     0.150
     3.754    70.418     0.150
     3.765    71.449     0.150
     4.235    80.559     0.150
     5.670    85.055     0.150
     5.670   104.453     0.150
     7.549   112.453     0.150
     7.796   243.648     0.150
    10.686   156.781     0.150
    10.918   158.680     0.150
    36.928   431.480     0.150
     0.007     1.305     0.150
     0.069     3.891     0.150
     0.112     2.539     0.150
     0.112     5.656     0.150
     0.099     2.391     0.150
     0.099     5.211     0.150
     0.195     4.438     0.150
     0.204     4.836     0.150
     0.204     8.328     0.150
     0.285     5.648     0.150
     0.286     6.227     0.150
     0.286    11.336     0.150
     0.289     5.695     0.150
     0.289    10.172     0.150
     0.346     7.328     0.150
     0.326     7.258     0.150
     0.355     7.336     0.150
     0.403     8.289     0.150
     0.367     7.734     0.150
     0.367    13.711     0.150
     0.421     8.195     0.150
     0.421    14.617     0.150
     0.432     9.125     0.150
     0.488     8.922     0.150
     0.488    16.711     0.150
     0.522    10.180     0.150
     0.522    17.945     0.150
     0.542    10.047     0.150
     0.542    18.172     0.150
     0.542    10.930     0.150
     0.542    20.086     0.150
     0.536    10.602     0.150
     0.536    18.797     0.150
     0.564    19.391     0.150
     0.523    10.180     0.150
     0.537    10.648     0.150
     0.595    19.289     0.150
     0.576    10.711     0.150
     0.576    18.484     0.150
     0.565    10.984     0.150
     0.622    12.039     0.150
     0.609    11.961     0.150
     0.609    21.281     0.150
     0.603    12.906     0.150
     0.647    12.406     0.150
     0.646    12.680     0.150
     0.646    22.602     0.150
     0.676    21.906     0.150
     0.643    11.898     0.150
     0.643    21.398     0.150
     0.678    12.336     0.150
     0.674    12.289     0.150
     0.674    21.367     0.150
     0.691    13.000     0.150
     0.699    13.508     0.150
     0.699    23.602     0.150
     0.699    23.352     0.150
     0.710    13.461     0.150
     0.725    24.930     0.150
     0.759    25.758     0.150
     0.775    13.977     0.150
     0.775    25.109     0.150
     0.806    14.109     0.150
     0.782    27.461     0.150
     0.788    14.484     0.150
     0.788    25.188     0.150
     0.794    14.797     0.150
     0.794    26.469     0.150
     0.811    15.227     0.150
     0.811    27.000     0.150
     0.825    14.641     0.150
     0.849    27.781     0.150
     0.825    26.398     0.150
     0.825    27.180     0.150
     0.852    15.766     0.150
     0.852    27.688     0.150
     0.866    27.891     0.150
     0.895    28.172     0.150
     0.884    29.086     0.150
     0.883    28.859     0.150
     0.875    16.227     0.150
     0.875    29.375     0.150
     0.912    30.172     0.150
     0.919    29.680     0.150
     0.933    30.320     0.150
     0.932    16.906     0.150
     0.932    30.922     0.150
     0.940    30.234     0.150
     0.961    17.367     0.150
     0.975    30.977     0.150
     1.014    32.008     0.150
     1.004    32.234     0.150
     1.072    33.234     0.150
     1.046    18.875     0.150
     1.072    20.219     0.150
     1.134    35.211     0.150
     1.212    20.945     0.150
     1.583    27.148     0.150
     1.560    27.781     0.150
     1.584    26.008     0.150
     1.608    27.641     0.150
     1.794    28.398     0.150
     2.002    33.617     0.150
     2.286    41.445     0.150
     2.295    38.141     0.150
     2.305    40.641     0.150
     2.563    40.078     0.150
     2.751    50.375     0.150
     2.763    50.617     0.150
     2.858    51.859     0.150
     2.960    54.016     0.150
     3.048    48.625     0.150
     5.671   105.250     0.150
     5.671   180.883     0.150
     7.552   239.000     0.150
     7.799   245.398     0.150
    10.919   159.375     0.150
    36.929   431.375     0.150
     0.047     3.320     0.150
     0.048     1.328     0.150
     0.063     1.512     0.150
     0.063     3.871     0.150
     0.110     4.441     0.150
     0.118     2.762     0.150
     0.150     3.410     0.150
     0.150     7.141     0.150
     0.232     4.680     0.150
     0.232     7.199     0.150
     0.222     5.211     0.150
     0.222     9.020     0.150
     0.251     5.520     0.150
     0.251    10.352     0.150
     0.260     5.301     0.150
     0.260     9.762     0.150
     0.297     6.371     0.150
     0.297    11.801     0.150
     0.332     6.949     0.150
     0.332    12.930     0.150
     0.332     6.781     0.150
     0.332    12.520     0.150
     0.369     7.250     0.150
     0.369    13.668     0.150
     0.376     8.180     0.150
     0.388     8.102     0.150
     0.388    14.320     0.150
     0.391     8.590     0.150
     0.391    15.352     0.150
     0.434     8.828     0.150
     0.434    16.199     0.150
     0.500     9.941     0.150
     0.495     9.289     0.150
     0.495    16.551     0.150
     0.508    10.129     0.150
     0.508    17.699     0.150
     0.512     9.852     0.150
     0.512    18.301     0.150
     0.523    10.129     0.150
     0.523    18.809     0.150
     0.543    17.559     0.150
     0.537    10.969     0.150
     0.537    19.531     0.150
     0.538    10.262     0.150
     0.579    11.398     0.150
     0.579    20.031     0.150
     0.566    11.012     0.150
     0.566    19.480     0.150
     0.566    11.070     0.150
     0.566    19.891     0.150
     0.594    11.379     0.150
     0.586    11.320     0.150
     0.586    20.500     0.150
     0.591    10.961     0.150
     0.591    19.418     0.150
     0.617    13.090     0.150
     0.623    11.641     0.150
     0.623    21.191     0.150
     0.628    12.230     0.150
     0.628    21.578     0.150
     0.621    12.469     0.150
     0.647    12.051     0.150
     0.647    21.488     0.150
     0.655    12.309     0.150
     0.655    19.941     0.150
     0.660    12.988     0.150
     0.660    22.191     0.150
     0.638    12.281     0.150
     0.638    22.148     0.150
     0.664    13.051     0.150
     0.664    22.879     0.150
     0.647    12.648     0.150
     0.647    22.012     0.150
     0.689    12.801     0.150
     0.689    23.449     0.150
     0.697    22.461     0.150
     0.697    12.391     0.150
     0.752    14.270     0.150
     0.752    25.020     0.150
     0.775    14.711     0.150
     0.775    25.148     0.150
     0.759    14.469     0.150
     0.759    26.289     0.150
     0.777    13.262     0.150
     0.777    24.918     0.150
     0.791    14.859     0.150
     0.791    26.219     0.150
     0.797    15.102     0.150
     0.797    26.621     0.150
     0.790    14.281     0.150
     0.790    24.609     0.150
     0.804    15.512     0.150
     0.804    26.512     0.150
     0.795    15.270     0.150
     0.795    27.371     0.150
     0.786    14.070     0.150
     0.786    25.262     0.150
     0.809    15.289     0.150
     0.809    26.750     0.150
     0.823    14.629     0.150
     0.823    26.031     0.150
     0.821    15.309     0.150
     0.821    26.602     0.150
     0.823    15.258     0.150
     0.823    27.082     0.150
     0.838    15.629     0.150
     0.838    26.941     0.150
     0.845    15.930     0.150
     0.845    27.352     0.150
     0.853    15.719     0.150
     0.853    27.262     0.150
     0.860    15.809     0.150
     0.860    27.949     0.150
     0.871    16.121     0.150
     0.871    28.852     0.150
     0.872    16.129     0.150
     0.890    16.500     0.150
     0.890    29.539     0.150
     0.896    16.520     0.150
     0.896    29.801     0.150
     0.903    16.738     0.150
     0.903    29.980     0.150
     0.903    16.980     0.150
     0.903    30.121     0.150
     0.905    16.602     0.150
     0.920    16.891     0.150
     0.920    30.230     0.150
     0.923    30.750     0.150
     0.923    16.449     0.150
     0.913    16.230     0.150
     0.934    17.070     0.150
     0.940    30.199     0.150
     0.936    17.051     0.150
     0.936    30.309     0.150
     0.974    17.461     0.150
     0.974    30.289     0.150
     0.987    18.352     0.150
     0.987    31.449     0.150
     1.003    18.059     0.150
     1.003    32.531     0.150
     1.026    18.449     0.150
     1.026    32.660     0.150
     1.018    18.199     0.150
     1.031    18.949     0.150
     1.031    33.051     0.150
     1.034    32.379     0.150
     1.037    18.668     0.150
     1.055    18.801     0.150
     1.086    19.680     0.150
     1.093    34.031     0.150
     1.098    20.059     0.150
     1.112    19.859     0.150
     1.130    19.918     0.150
     1.121    20.918     0.150
     1.152    35.469     0.150
     1.153    20.160     0.150
     1.159    19.621     0.150
     1.183    19.770     0.150
     1.181    37.891     0.150
     1.196    20.711     0.150
     1.196    38.668     0.150
     1.201    21.551     0.150
     1.201    38.078     0.150
     1.222    21.168     0.150
     1.234    37.570     0.150
     1.227    21.648     0.150
     1.245    21.789     0.150
     1.223    20.230     0.150
     1.254    22.020     0.150
     1.263    21.609     0.150
     1.276    21.980     0.150
     1.276    39.281     0.150
     1.287    21.660     0.150
     1.311    22.449     0.150
     1.324    22.648     0.150
     1.324    40.379     0.150
     1.339    23.449     0.150
     1.406    24.719     0.150
     1.432    24.762     0.150
     1.482    28.109     0.150
     1.509    27.320     0.150
     1.531    26.078     0.150
     1.569    26.539     0.150
     1.575    26.551     0.150
     1.593    28.121     0.150
     1.649    27.570     0.150
     1.667    27.699     0.150
     1.708    30.090     0.150
     1.711    31.410     0.150
     1.748    29.020     0.150
     1.815    29.609     0.150
     2.000    32.391     0.150
     2.379    36.520     0.150
     2.279    37.461     0.150
     2.350    38.270     0.150
     2.339    39.250     0.150
     2.342    39.059     0.150
     2.367    39.930     0.150
     2.349    38.949     0.150
     2.441    40.359     0.150
     2.754    42.730     0.150
     2.768    43.941     0.150
     2.799    45.828     0.150
     2.875    45.699     0.150
     2.948    46.289     0.150
     2.991    48.219     0.150
     3.115    47.410     0.150
     3.151    48.879     0.150
     3.281    50.801     0.150
     3.311    50.301     0.150
     3.380    53.148     0.150
     3.431    52.441     0.150
     3.465    54.461     0.150
     3.730    57.941     0.150
     3.830    59.301     0.150
     3.850    59.199     0.150
     3.881    60.789     0.150
     3.902    60.371     0.150
     4.073    63.012     0.150
     4.095    62.531     0.150
     4.163    62.129     0.150
     4.184    63.000     0.150
     4.259    65.602     0.150
     4.284    65.078     0.150
     4.337    65.449     0.150
     4.353    66.039     0.150
     4.439    67.699     0.150
     4.494    68.289     0.150
     4.509    68.340     0.150
     4.675    70.352     0.150
     4.888    74.031     0.150
     4.910    73.461     0.150
     4.913    74.660     0.150
     4.942    74.738     0.150
     5.186    76.648     0.150
     5.202    77.129     0.150
     5.235    77.418     0.150
     5.284    78.109     0.150
     5.319    79.141     0.150
     5.575    82.711     0.150
     5.601    82.699     0.150
     5.602    83.918     0.150
     5.615    84.180     0.150
     5.676    84.301     0.150
     5.700    86.371     0.150
     5.700   105.613     0.150
     6.221    91.629     0.150
     6.471    93.660     0.150
     6.515    95.289     0.150
     6.810    98.668     0.150
     7.296   105.641     0.150
     7.493   108.148     0.150
     7.596   112.863     0.150
     7.596   144.664     0.150
     7.617   111.070     0.150
     7.802   112.699     0.150
     7.840   114.359     0.150
     7.840   146.734     0.150
     7.840   247.660     0.150
     8.800   125.879     0.150
     9.171   132.230     0.150
     9.236   132.488     0.150
    10.244   148.586     0.150
    94.463   798.391     0.150
     0.029     1.266     0.150
     0.029     2.836     0.150
     0.051     1.449     0.150
     0.051     3.977     0.150
     0.033     1.355     0.150
     0.098     2.406     0.150
     0.098     5.605     0.150
     0.135     3.156     0.150
     0.135     7.047     0.150
     0.220     5.188     0.150
     0.220    10.047     0.150
     0.255    10.957     0.150
     0.251     5.098     0.150
     0.310    11.855     0.150
     0.286     5.488     0.150
     0.286     9.809     0.150
     0.330     6.938     0.150
     0.330    12.879     0.150
     0.322     6.488     0.150
     0.322    12.316     0.150
     0.325    12.406     0.150
     0.388    13.605     0.150
     0.377     7.906     0.150
     0.399     8.406     0.150
     0.452     8.656     0.150
     0.506     9.117     0.150
     0.483     9.836     0.150
     0.483    17.508     0.150
     0.519     9.996     0.150
     0.531    10.078     0.150
     0.531    17.238     0.150
     0.525     9.887     0.150
     0.525    18.629     0.150
     0.540    10.586     0.150
     0.540    19.516     0.150
     0.559    18.086     0.150
     0.524     9.738     0.150
     0.556    10.766     0.150
     0.563    10.836     0.150
     0.599    11.105     0.150
     0.599    20.148     0.150
     0.576    10.566     0.150
     0.576    18.828     0.150
     0.587    19.707     0.150
     0.608    11.316     0.150
     0.642    11.629     0.150
     0.642    11.777     0.150
     0.642    20.277     0.150
     0.631    11.617     0.150
     0.631    21.719     0.150
     0.620    12.277     0.150
     0.624    12.266     0.150
     0.664    12.406     0.150
     0.664    21.836     0.150
     0.655    11.938     0.150
     0.671    12.008     0.150
     0.680    12.918     0.150
     0.680    22.355     0.150
     0.679    22.508     0.150
     0.681    21.789     0.150
     0.739    14.207     0.150
     0.739    25.078     0.150
     0.763    25.438     0.150
     0.778    13.828     0.150
     0.795    14.457     0.150
     0.795    24.977     0.150
     0.773    24.848     0.150
     0.806    14.707     0.150
     0.806    26.496     0.150
     0.815    14.797     0.150
     0.799    13.977     0.150
     0.799    25.105     0.150
     0.824    14.926     0.150
     0.824    25.969     0.150
     0.799    14.926     0.150
     0.799    27.266     0.150
     0.825    14.727     0.150
     0.813    14.656     0.150
     0.813    26.797     0.150
     0.833    14.816     0.150
     0.833    15.148     0.150
     0.831    15.129     0.150
     0.831    26.887     0.150
     0.833    14.629     0.150
     0.833    26.906     0.150
     0.855    15.438     0.150
     0.873    15.527     0.150
     0.873    27.258     0.150
     0.880    15.738     0.150
     0.880    27.578     0.150
     0.884    16.008     0.150
     0.884    28.777     0.150
     0.884    16.078     0.150
     0.884    28.078     0.150
     0.904    16.426     0.150
     0.909    16.508     0.150
     0.897    16.188     0.150
     0.897    28.938     0.150
     0.915    16.539     0.150
     0.909    16.578     0.150
     0.909    29.809     0.150
     0.902    16.406     0.150
     0.902    28.789     0.150
     0.924    16.398     0.150
     0.924    29.277     0.150
     0.935    16.379     0.150
     0.951    17.129     0.150
     0.951    31.559     0.150
     0.959    17.297     0.150
     0.959    29.898     0.150
     0.946    16.828     0.150
     0.965    17.727     0.150
     0.995    17.926     0.150
     0.995    17.539     0.150
     0.995    30.449     0.150
     1.007    17.828     0.150
     1.007    30.688     0.150
     1.015    18.098     0.150
     1.022    18.086     0.150
     1.052    18.129     0.150
     1.112    18.957     0.150
     1.083    18.848     0.150
     1.101    19.688     0.150
     1.411    19.719     0.150
     1.199    20.656     0.150
     1.359    23.527     0.150
     1.498    26.078     0.150
     1.548    26.355     0.150
     1.553    26.227     0.150
     1.583    26.316     0.150
     1.589    26.836     0.150
     1.612    27.398     0.150
     1.712    28.828     0.150
     1.759    28.855     0.150
     1.995    32.727     0.150
     2.010    32.098     0.150
     2.050    33.828     0.150
     2.382    34.938     0.150
     2.290    35.328     0.150
     2.319    36.828     0.150
     2.316    35.777     0.150
     2.329    36.336     0.150
     2.329    36.117     0.150
     2.362    41.328     0.150
     2.362    36.797     0.150
     2.426    37.469     0.150
     2.423    38.219     0.150
     2.762    43.496     0.150
     2.770    43.516     0.150
     2.878    42.777     0.150
     2.942    44.887     0.150
     2.959    45.227     0.150
     2.959    43.906     0.150
     2.984    44.879     0.150
     2.988    44.629     0.150
     2.980    43.789     0.150
     2.996    44.527     0.150
     3.116    46.727     0.150
     3.147    47.617     0.150
     3.281    48.969     0.150
     3.323    48.547     0.150
     3.369    51.078     0.150
     3.437    52.426     0.150
     3.461    51.926     0.150
     3.705    56.199     0.150
     3.725    55.328     0.150
     3.824    57.727     0.150
     3.852    56.906     0.150
     3.896    57.828     0.150
     3.896    59.328     0.150
     4.065    59.246     0.150
     4.092    59.758     0.150
     4.092    64.328     0.150
     4.176    60.316     0.150
     4.168    62.027     0.150
     4.186    65.629     0.150
     4.239    63.887     0.150
     4.270    65.828     0.150
     4.273    63.887     0.150
     4.320    64.879     0.150
     4.350    65.176     0.150
     4.440    65.129     0.150
     4.492    67.629     0.150
     4.539    68.117     0.150
     4.686    69.648     0.150
     4.765    70.867     0.150
     4.875    72.969     0.150
     4.919    70.906     0.150
     4.897    72.797     0.150
     4.968    73.617     0.150
     5.082    73.426     0.150
     5.183    76.219     0.150
     5.199    75.668     0.150
     5.244    76.316     0.150
     5.562    81.539     0.150
     5.656    82.836     0.150
     5.698    85.301     0.150
     5.698   178.188     0.150
     6.218    90.547     0.150
     6.219    90.848     0.150
     6.456    94.027     0.150
     6.468    91.938     0.150
     6.508    97.805     0.150
     6.631    95.957     0.150
     6.705    95.707     0.150
     6.871    98.418     0.150
     7.105   106.766     0.150
     7.212   104.398     0.150
     7.220   105.508     0.150
     7.240   106.227     0.150
     7.288   106.598     0.150
     7.336   107.129     0.150
     7.368   108.586     0.150
     7.385   109.727     0.150
     7.564   111.918     0.150
     7.586   112.227     0.150
     7.586   141.879     0.150
     7.586   235.453     0.150
     7.820   116.070     0.150
     7.820   245.547     0.150
     7.820   116.328     0.150
     7.820   113.848     0.150
     7.844   116.258     0.150
     7.997   117.988     0.150
     8.783   126.223     0.150
     8.783   126.828     0.150
     8.783   126.328     0.150
     9.038   134.227     0.150
     9.544   137.336     0.150
    10.153   150.395     0.150
    10.245   149.434     0.150
    10.245   322.484     0.150
    10.575   150.277     0.150
    10.622   153.363     0.150
    10.726   156.977     0.150
    10.726   339.918     0.150
    10.726   157.727     0.150
    10.919   156.926     0.150
    10.919   156.629     0.150
    10.921   156.828     0.150
    10.921   157.602     0.150
    10.921   345.812     0.150
    10.921   156.527     0.150
    14.049   198.027     0.150
    14.199   206.426     0.150
    14.347   204.766     0.150
    14.430   203.855     0.150
    14.591   204.508     0.150
    14.700   205.047     0.150
    15.025   209.316     0.150
    15.140   214.973     0.150
    15.140   479.320     0.150
    15.140   219.328     0.150
    15.180   210.816     0.150
    15.223   211.168     0.150
    15.309   212.855     0.150
    15.482   220.414     0.150
    15.482   224.426     0.150
    15.498   214.688     0.150
    15.497   214.988     0.150
    15.525   215.426     0.150
    15.590   216.137     0.150
    15.599   216.738     0.150
    15.663   217.969     0.150
    15.794   218.508     0.150
    16.001   221.105     0.150
    17.592   240.207     0.150
    17.600   241.188     0.150
    17.699   241.578     0.150
    18.099   246.676     0.150
    18.201   247.516     0.150
    18.221   253.926     0.150
    18.370   256.727     0.150
    18.804   254.969     0.150
    19.552   263.238     0.150
    19.630   264.637     0.150
    20.129   270.129     0.150
    20.342   273.789     0.150
    20.401   273.227     0.150
    20.401   278.898     0.150
    20.401   280.926     0.150
    20.423   273.047     0.150
    21.065   284.926     0.150
    21.201   282.387     0.150
    21.201   286.551     0.150
    21.201   286.129     0.150
    21.591   286.227     0.150
    21.829   288.648     0.150
    21.967   290.676     0.150
    22.170   291.926     0.150
    22.279   299.027     0.150
    22.303   294.078     0.150
    22.456   300.051     0.150
    22.456   708.227     0.150
    22.456   299.629     0.150
    22.456   299.426     0.150
    22.671   298.738     0.150
    22.884   300.828     0.150
    22.930   301.227     0.150
    23.157   303.387     0.150
    23.464   307.648     0.150
    23.619   308.258     0.150
    23.619   308.527     0.150
    23.619   311.348     0.150
    23.619   312.129     0.150
    24.741   319.137     0.150
    25.031   321.277     0.150
    25.069   321.629     0.150
    25.122   321.457     0.150
    26.172   330.516     0.150
    28.177   348.355     0.150
    28.405   350.086     0.150
    28.606   351.766     0.150
    28.685   353.309     0.150
    29.039   353.918     0.150
    29.368   364.203     0.150
    29.368   929.996     0.150
    29.368   364.926     0.150
    29.437   360.027     0.150
    29.610   361.078     0.150
    31.073   373.809     0.150
    31.261   374.977     0.150
    31.515   377.887     0.150
    32.229   382.488     0.150
    32.369   383.828     0.150
    32.420   384.656     0.150
    32.628   386.738     0.150
    33.163   391.418     0.150
    33.469   394.367     0.150
    33.545   394.348     0.150
    33.628   394.469     0.150
    33.767   397.219     0.150
    34.092   400.387     0.150
    34.259   406.980     0.150
    34.698   405.566     0.150
    35.481   412.328     0.150
    35.501   419.027     0.150
    35.688   415.137     0.150
    36.453   421.309     0.150
    36.673   429.129     0.150
    36.863   424.016     0.150
    36.928   431.227     0.150
    36.943   430.727     0.150
    36.956   430.926     0.150
    36.956   431.727     0.150
    37.133   432.926     0.150
    37.160   427.438     0.150
    37.233   428.016     0.150
    37.273   428.926     0.150
    37.328   435.027     0.150
    37.328   436.246     0.150
    37.364   430.086     0.150
    37.381   429.449     0.150
    37.382   430.746     0.150
    37.404   430.426     0.150
    37.532   432.156     0.150
    37.532   436.227     0.150
    37.584   432.207     0.150
    37.683   433.438     0.150
    37.762   433.328     0.150
    37.848   434.449     0.150
    37.866   434.469     0.150
    37.866   438.629     0.150
    37.866   439.129     0.150
    37.990   434.988     0.150
    37.995   435.297     0.150
    38.091   436.238     0.150
    38.121   436.617     0.150
    38.238   438.379     0.150
    38.363   439.957     0.150
    38.480   440.027     0.150
    38.868   443.547     0.150
    38.994   444.336     0.150
    39.035   444.297     0.150
    39.228   445.516     0.150
    39.233   446.477     0.150
    39.433   448.266     0.150
    39.625   449.758     0.150
    39.736   450.406     0.150
    39.940   452.758     0.150
    40.105   454.258     0.150
    40.213   454.246     0.150
    41.417   464.566     0.150
    41.451   464.227     0.150
    41.995   468.508     0.150
    42.293   470.297     0.150
    42.490   472.539     0.150
    43.338   479.906     0.150
    43.361   480.137     0.150
    43.519   481.355     0.150
    43.818   483.559     0.150
    44.110   485.656     0.150
    44.856   499.027     0.150
    44.910   493.926     0.150
    45.535   502.328     0.150
    45.723   499.426     0.150
    46.738   506.629     0.150
    46.772   509.727     0.150
    47.285   516.227     0.150
    47.385   515.727     0.150
    47.851   515.969     0.150
    47.851  1140.730     0.150
    47.883   516.027     0.150
    47.883   520.227     0.150
    47.883   517.406     0.150
    48.605   524.629     0.150
    48.720   530.426     0.150
    48.911   533.629     0.150
    52.142   552.727     0.150
    52.741   555.727     0.150
    54.896   572.871     0.150
    54.896   572.227     0.150
    54.896   573.828     0.150
    54.896   568.727     0.150
    55.225   576.797     0.150
    55.225   574.027     0.150
    55.418   573.418     0.150
    57.583   589.199     0.150
    59.591   604.129     0.150
    59.591   604.027     0.150
    59.862   604.508     0.150
    59.856   607.328     0.150
    59.978  1095.324     0.150
    59.978  1334.426     0.150
    60.363   609.027     0.150
    61.924   621.328     0.150
    64.209   634.129     0.150
    64.786  1155.926     0.150
    64.786  1411.027     0.150
    65.367   646.414     0.150
    66.308   648.828     0.150
    66.308   646.789     0.150
    67.237   656.227     0.150
    67.764   657.266     0.150
    68.518   660.668     0.150
    68.731   662.906     0.150
    68.731   664.102     0.150
    69.112   664.758     0.150
    69.558   667.906     0.150
    69.558   671.723     0.150
    69.593   668.387     0.150
    69.721   669.887     0.150
    69.949   670.719     0.150
    69.949   671.957     0.150
    70.553   674.668     0.150
    71.595   681.887     0.150
    71.654   683.227     0.150
    71.654   700.027     0.150
    71.654  1239.324     0.150
    71.654  1286.527     0.150
    71.654   684.898     0.150
    71.654   686.828     0.150
    71.814   686.883     0.150
    71.814   682.406     0.150
    72.390   686.668     0.150
    72.390   686.336     0.150
    72.390   687.727     0.150
    72.881   688.676     0.150
    73.693   697.426     0.150
    73.693  1265.527     0.150
    74.240   696.668     0.150
    74.726   702.051     0.150
    75.155   702.266     0.150
    75.155   704.926     0.150
    75.271   705.227     0.150
    76.345   708.578     0.150
    76.401   879.426     0.150
    76.401   710.426     0.150
    76.401   708.117     0.150
    76.527   709.086     0.150
    76.584   709.938     0.150
    76.667   713.828     0.150
    76.687   710.258     0.150
    76.896   711.266     0.150
    76.908   712.426     0.150
    77.109   714.949     0.150
    77.434   714.789     0.150
    77.764   715.336     0.150
    77.842   719.926     0.150
    77.842  1312.527     0.150
    77.872   717.477     0.150
    78.179   717.789     0.150
    78.179   719.238     0.150
    78.208   718.066     0.150
    78.494   725.344     0.150
    78.494   723.426     0.150
    78.924   722.297     0.150
    79.024   724.117     0.150
    80.028   733.027     0.150
    80.504   736.496     0.150
    80.678   732.727     0.150
    80.739   732.816     0.150
    80.740   732.527     0.150
    80.828   737.508     0.150
    81.053   733.668     0.150
    81.053   737.828     0.150
    81.053   734.547     0.150
    81.093   739.586     0.150
    81.122   733.797     0.150
    81.122   732.988     0.150
    81.468   735.227     0.150
    81.597   742.781     0.150
    81.602   741.816     0.150
    81.640   742.586     0.150
    81.700   742.688     0.150
    81.810   743.438     0.150
    81.221   741.855     0.150
    81.963   742.527     0.150
    82.004   740.586     0.150
    82.107   744.996     0.150
    82.265   739.629     0.150
    82.266   743.828     0.150
    82.266   740.355     0.150
    82.728   748.719     0.150
    82.728   747.027     0.150
    82.893   745.355     0.150
    82.971   750.441     0.150
    82.988  1371.730     0.150
    82.971   748.398     0.150
    83.056   748.223     0.150
    83.056   750.926     0.150
    83.059   748.926     0.150
    83.059   750.176     0.150
    83.264   750.648     0.150
    83.386   752.043     0.150
    83.640   751.168     0.150
    83.770   752.059     0.150
    83.856   748.738     0.150
    83.856   749.777     0.150
    84.150   752.227     0.150
    84.150  1374.324     0.150
    84.217   749.926     0.150
    84.217   755.227     0.150
    84.466   754.848     0.150
    84.467   757.695     0.150
    84.554  1386.027     0.150
    84.554  1436.027     0.150
    84.686   758.727     0.150
    84.686   753.605     0.150
    84.686   758.371     0.150
    84.686   755.129     0.150
    84.686   758.828     0.150
    84.817   759.355     0.150
    84.966   758.137     0.150
    84.967   757.828     0.150
    84.967   757.129     0.150
    85.003   761.258     0.150
    85.012   754.598     0.150
    85.174   758.574     0.150
    85.174   758.227     0.150
    85.271   760.098     0.150
    85.271   761.395     0.150
    85.271   761.637     0.150
    85.271  1397.027     0.150
    85.791   763.129     0.150
    86.163   762.898     0.150
    86.194   764.129     0.150
    86.424   766.355     0.150
    86.505   770.129     0.150
    86.686   765.363     0.150
    86.713   766.328     0.150
    86.713   767.352     0.150
    86.713   763.828     0.150
    86.752   766.797     0.150
    86.826   768.676     0.150
    86.830   763.988     0.150
    86.830   767.723     0.150
    87.197   769.676     0.150
    87.197  1394.645     0.150
    87.197  1752.145     0.150
    87.339   768.824     0.150
    87.577   766.129     0.150
    87.582   771.480     0.150
    87.716   769.371     0.150
    87.898   769.293     0.150
    88.082   775.227     0.150
    88.289   771.980     0.150
    88.339   774.152     0.150
    88.412   773.066     0.150
    88.701   774.023     0.150
    88.721   774.035     0.150
    88.868   774.227     0.150
    88.951   776.184     0.150
    89.991   781.629     0.150
    90.671   783.527     0.150
    90.671   998.926     0.150
    90.671  1414.926     0.150
    90.671  1506.926     0.150
    90.739   786.227     0.150
    90.780   776.727     0.150
    90.928   787.703     0.150
    90.928   786.926     0.150
    91.470   789.879     0.150
    91.613   790.527     0.150
    91.764   793.828     0.150
    92.226   791.328     0.150
    92.695   790.527     0.150
    93.111   797.629     0.150
    94.009   800.328     0.150
    94.027   801.602     0.150
    94.465   798.027     0.150
    95.007   806.129     0.150
    95.329   798.227     0.150
    95.555   804.527     0.150
    95.583   806.926     0.150
    95.658   808.977     0.150
    95.658  1038.301     0.150
    98.800   823.227     0.150
   100.380   830.027     0.150
   100.380  1076.027     0.150
   100.380  1468.926     0.150
   100.380  1940.730     0.150
   100.496   829.727     0.150
   100.752   830.727     0.150
   101.140   829.527     0.150
   101.852   834.426     0.150
   112.343   879.129     0.150
   112.343  1160.527     0.150
   112.343  1624.129     0.150
   118.974  1133.879     0.150
   122.986  1139.121     0.150
   127.924  1146.277     0.150
   127.924  1268.840     0.150
   127.924  1573.535     0.150
   146.262  1184.324     0.150
     0.026     1.305     0.150
     0.026     2.922     0.150
     0.030     2.773     0.150
     0.053     1.500     0.150
     0.053     3.734     0.150
     0.100     2.453     0.150
     0.100     5.141     0.150
     0.122     3.055     0.150
     0.122     6.250     0.150
     0.167     4.383     0.150
     0.167     8.062     0.150
     0.226     9.875     0.150
     0.258     5.250     0.150
     0.258     9.180     0.150
     0.285     5.453     0.150
     0.285     9.445     0.150
     0.314     6.773     0.150
     0.324     6.984     0.150
     0.324    12.742     0.150
     0.324     6.641     0.150
     0.324    12.094     0.150
     0.333     6.961     0.150
     0.333    12.812     0.150
     0.391     7.727     0.150
     0.380     8.141     0.150
     0.385     8.117     0.150
     0.402     8.734     0.150
     0.402    15.742     0.150
     0.452     9.133     0.150
     0.452    16.406     0.150
     0.480    17.000     0.150
     0.510     9.594     0.150
     0.510    16.820     0.150
     0.521    10.414     0.150
     0.521    18.422     0.150
     0.525    10.383     0.150
     0.525    18.367     0.150
     0.515     9.922     0.150
     0.534    10.320     0.150
     0.534    18.594     0.150
     0.521    10.172     0.150
     0.521    17.375     0.150
     0.544    10.781     0.150
     0.544    19.766     0.150
     0.562    10.430     0.150
     0.562    18.297     0.150
     0.553    10.914     0.150
     0.553    19.195     0.150
     0.560    10.945     0.150
     0.560    18.766     0.150
     0.584    11.430     0.150
     0.584    20.297     0.150
     0.577    10.711     0.150
     0.577    18.875     0.150
     0.600    11.594     0.150
     0.600    20.250     0.150
     0.607    11.586     0.150
     0.607    20.492     0.150
     0.618    13.133     0.150
     0.621    12.273     0.150
     0.642    12.453     0.150
     0.645    12.125     0.150
     0.645    21.352     0.150
     0.634    11.734     0.150
     0.634    21.820     0.150
     0.653    12.195     0.150
     0.653    21.633     0.150
     0.670    12.594     0.150
     0.670    21.906     0.150
     0.681    13.211     0.150
     0.681    22.742     0.150
     0.683    13.305     0.150
     0.683    23.352     0.150
     0.667    12.875     0.150
     0.667    22.156     0.150
     0.681    12.672     0.150
     0.681    22.992     0.150
     0.681    12.445     0.150
     0.681    21.953     0.150
     0.736    14.164     0.150
     0.762    14.391     0.150
     0.762    25.344     0.150
     0.782    13.516     0.150
     0.782    25.477     0.150
     0.774    13.852     0.150
     0.774    24.531     0.150
     0.797    15.344     0.150
     0.797    25.820     0.150
     0.797    14.594     0.150
     0.797    25.156     0.150
     0.797    15.273     0.150
     0.797    27.281     0.150
     0.806    15.047     0.150
     0.806    26.797     0.150
     0.816    15.250     0.150
     0.810    15.055     0.150
     0.810    26.844     0.150
     0.821    15.203     0.150
     0.821    26.594     0.150
     0.825    27.094     0.150
     0.831    15.211     0.150
     0.831    26.516     0.150
     0.829    15.305     0.150
     0.829    26.961     0.150
     0.831    27.695     0.150
     0.831    15.352     0.150
     0.831    26.781     0.150
     0.855    15.711     0.150
     0.855    15.703     0.150
     0.855    27.617     0.150
     0.874    15.961     0.150
     0.874    27.562     0.150
     0.882    16.492     0.150
     0.882    28.344     0.150
     0.883    16.242     0.150
     0.883    29.031     0.150
     0.883    16.266     0.150
     0.883    28.891     0.150
     0.894    16.234     0.150
     0.894    29.031     0.150
     0.903    16.562     0.150
     0.903    29.523     0.150
     0.899    16.430     0.150
     0.899    28.773     0.150
     0.906    16.977     0.150
     0.906    29.750     0.150
     0.914    16.883     0.150
     0.914    30.211     0.150
     0.912    30.305     0.150
     0.922    16.703     0.150
     0.932    17.047     0.150
     0.934    17.133     0.150
     0.934    30.445     0.150
     0.945    17.133     0.150
     0.951    17.242     0.150
     0.960    30.773     0.150
     0.996    17.656     0.150
     0.996    30.664     0.150
     1.009    18.867     0.150
     1.009    31.906     0.150
     1.014    18.195     0.150
     1.020    18.125     0.150
     1.043    18.586     0.150
     1.048    18.727     0.150
     1.048    33.102     0.150
     1.046    18.617     0.150
     1.055    18.422     0.150
     1.052    18.836     0.150
     1.064    18.852     0.150
     1.064    33.352     0.150
     1.064    18.891     0.150
     1.064    33.867     0.150
     1.079    19.992     0.150
     1.079    35.102     0.150
     1.108    20.031     0.150
     1.113    19.414     0.150
     1.113    34.602     0.150
     1.112    19.547     0.150
     1.099    20.547     0.150
     1.099    35.031     0.150
     1.125    19.891     0.150
     1.123    19.781     0.150
     1.173    36.914     0.150
     1.170    37.555     0.150
     1.180    21.422     0.150
     1.180    36.992     0.150
     1.188    37.891     0.150
     1.198    20.695     0.150
     1.203    36.812     0.150
     1.210    21.984     0.150
     1.210    37.797     0.150
     1.206    20.820     0.150
     1.223    22.312     0.150
     1.223    38.633     0.150
     1.213    20.117     0.150
     1.225    21.414     0.150
     1.225    38.703     0.150
     1.225    21.391     0.150
     1.256    21.625     0.150
     1.266    21.625     0.150
     1.274    21.742     0.150
     1.295    22.125     0.150
     1.295    39.367     0.150
     1.304    22.156     0.150
     1.304    40.547     0.150
     1.326    22.547     0.150
     1.342    22.844     0.150
     1.361    24.422     0.150
     1.361    42.047     0.150
     1.359    24.953     0.150
     1.412    24.703     0.150
     1.433    24.586     0.150
     1.438    25.141     0.150
     1.467    43.766     0.150
     1.494    26.117     0.150
     1.551    26.914     0.150
     1.554    26.641     0.150
     1.582    26.875     0.150
     1.586    27.391     0.150
     1.612    27.336     0.150
     1.655    27.883     0.150
     1.689    52.234     0.150
     1.710    29.555     0.150
     1.736    28.836     0.150
     2.008    32.930     0.150
     2.289    37.000     0.150
     2.314    37.531     0.150
     2.325    37.961     0.150
     2.327    37.516     0.150
     2.361    38.117     0.150
     2.361    38.281     0.150
     2.420    39.883     0.150
     2.428    37.805     0.150
     2.760    44.172     0.150
     2.767    44.555     0.150
     2.790    45.016     0.150
     2.875    46.031     0.150
     2.957    46.344     0.150
     2.976    46.641     0.150
     3.076    47.773     0.150
     3.113    48.922     0.150
     3.144    50.133     0.150
     3.278    51.320     0.150
     3.322    52.500     0.150
     3.365    53.422     0.150
     3.434    54.367     0.150
     3.458    55.094     0.150
     3.702    57.945     0.150
     3.708    58.203     0.150
     3.721    57.422     0.150
     3.820    60.852     0.150
     3.859    61.234     0.150
     3.892    60.422     0.150
     3.897    59.844     0.150
     4.062    63.391     0.150
     4.089    61.836     0.150
     4.175    64.875     0.150
     4.169    63.375     0.150
     4.237    64.742     0.150
     4.269    64.555     0.150
     4.267    64.703     0.150
     4.317    65.422     0.150
     4.347    68.094     0.150
     4.437    67.906     0.150
     4.488    67.562     0.150
     4.481    68.773     0.150
     4.488    68.297     0.150
     4.536    68.844     0.150
     4.684    70.336     0.150
     4.761    71.547     0.150
     4.872    73.734     0.150
     4.893    74.000     0.150
     4.918    73.820     0.150
     4.921    73.891     0.150
     5.079    76.453     0.150
     5.180    77.727     0.150
     5.195    77.156     0.150
     5.242    77.641     0.150
     5.282    80.023     0.150
     5.437    79.922     0.150
     5.558    82.891     0.150
     5.598    84.367     0.150
     5.608    82.141     0.150
     5.597    83.930     0.150
     5.653    83.055     0.150
     5.662    82.711     0.150
     5.695   106.805     0.150
     5.695   182.484     0.150
     6.025    88.516     0.150
     6.170    90.922     0.150
     6.215    91.000     0.150
     6.223    91.641     0.150
     6.453    95.062     0.150
     6.464    94.844     0.150
     6.512    94.453     0.150
     6.631    96.305     0.150
     6.637    97.172     0.150
     6.737    98.711     0.150
     6.790    97.320     0.150
     7.103   103.102     0.150
     7.237   104.750     0.150
     7.287   105.336     0.150
     7.382   106.500     0.150
     7.471   106.742     0.150
     7.583   114.195     0.150
     7.583   142.320     0.150
     7.583   109.930     0.150
     7.743   112.375     0.150
     7.782   112.875     0.150
     7.819   115.945     0.150
     7.819   146.492     0.150
     7.819   246.367     0.150
     7.819   113.047     0.150
     7.820   112.531     0.150
     7.820   112.797     0.150
     8.030   115.211     0.150
     8.783   125.953     0.150
     9.149   132.391     0.150
    10.156   148.617     0.150
    10.243   149.102     0.150
    10.576   151.406     0.150
    10.722   153.445     0.150
    10.722   158.625     0.150
    10.922   155.648     0.150
    10.922   345.477     0.150
    15.137   218.789     0.150
    36.953   433.070     0.150
    38.548   443.047     0.150
    39.937   455.945     0.150
     0.030     1.452     0.150
     0.030     3.122     0.150
     0.054     1.732     0.150
     0.054     3.992     0.150
     0.101     2.622     0.150
     0.101     5.632     0.150
     0.121     3.172     0.150
     0.121     6.302     0.150
     0.135     3.252     0.150
     0.135     6.812     0.150
     0.249     5.192     0.150
     0.217     5.112     0.150
     0.217     9.422     0.150
     0.254     5.282     0.150
     0.254     9.052     0.150
     0.227     5.162     0.150
     0.227     9.922     0.150
     0.257     5.752     0.150
     0.257    10.492     0.150
     0.250     5.192     0.150
     0.250     9.412     0.150
     0.311     6.832     0.150
     0.311    12.021     0.150
     0.289     5.462     0.150
     0.289     9.442     0.150
     0.325     6.572     0.150
     0.325    12.012     0.150
     0.333     6.872     0.150
     0.333    12.582     0.150
     0.322     6.972     0.150
     0.379     8.102     0.150
     0.379    14.992     0.150
     0.387     7.762     0.150
     0.387    13.521     0.150
     0.400     8.642     0.150
     0.386     8.021     0.150
     0.386    13.962     0.150
     0.449     9.092     0.150
     0.507     9.582     0.150
     0.507    16.832     0.150
     0.480     9.752     0.150
     0.480    17.182     0.150
     0.516     9.902     0.150
     0.516    17.992     0.150
     0.530    10.382     0.150
     0.530    17.942     0.150
     0.522    10.332     0.150
     0.522    18.271     0.150
     0.542    10.632     0.150
     0.542    19.702     0.150
     0.559    18.152     0.150
     0.559    10.562     0.150
     0.524    17.521     0.150
     0.524    10.242     0.150
     0.555    10.882     0.150
     0.555    19.232     0.150
     0.561    10.862     0.150
     0.561    19.232     0.150
     0.579    10.732     0.150
     0.579    18.642     0.150
     0.596    11.542     0.150
     0.596    20.172     0.150
     0.584    11.282     0.150
     0.584    20.042     0.150
     0.605    11.542     0.150
     0.605    20.172     0.150
     0.641    12.122     0.150
     0.641    20.832     0.150
     0.618    12.352     0.150
     0.634    12.182     0.150
     0.621    12.052     0.150
     0.639    21.842     0.150
     0.639    12.442     0.150
     0.652    21.372     0.150
     0.668    12.552     0.150
     0.664    12.922     0.150
     0.664    21.952     0.150
     0.677    12.892     0.150
     0.677    22.662     0.150
     0.680    13.021     0.150
     0.683    22.892     0.150
     0.684    21.902     0.150
     0.684    12.472     0.150
     0.740    14.172     0.150
     0.740    24.212     0.150
     0.760    25.552     0.150
     0.781    13.771     0.150
     0.781    24.412     0.150
     0.793    14.692     0.150
     0.793    25.362     0.150
     0.776    13.812     0.150
     0.776    24.582     0.150
     0.803    26.652     0.150
     0.796    14.352     0.150
     0.812    26.021     0.150
     0.818    15.082     0.150
     0.818    26.362     0.150
     0.796    15.082     0.150
     0.796    27.262     0.150
     0.822    15.172     0.150
     0.822    26.632     0.150
     0.810    14.932     0.150
     0.810    26.852     0.150
     0.830    15.192     0.150
     0.828    26.952     0.150
     0.830    26.996     0.150
     0.852    15.612     0.150
     0.852    27.342     0.150
     0.854    27.602     0.150
     0.870    15.852     0.150
     0.878    16.072     0.150
     0.878    28.042     0.150
     0.912    30.252     0.150
     0.894    16.092     0.150
     0.894    28.842     0.150
     0.912    30.052     0.150
     0.900    16.442     0.150
     0.900    29.112     0.150
     0.906    16.442     0.150
     0.906    29.482     0.150
     0.930    29.932     0.150
     0.932    17.082     0.150
     0.932    30.812     0.150
     0.948    17.142     0.150
     0.943    17.012     0.150
     0.943    30.342     0.150
     0.968    16.892     0.150
     0.993    17.632     0.150
     1.005    31.252     0.150
     1.012    32.412     0.150
     1.012    17.972     0.150
     1.012    32.021     0.150
     1.051    32.512     0.150
     1.049    33.362     0.150
     1.109    19.462     0.150
     1.103    20.372     0.150
     1.135    22.992     0.150
     1.206    21.182     0.150
     1.195    20.672     0.150
     1.357    23.942     0.150
     1.548    26.802     0.150
     1.615    25.542     0.150
     1.760    29.202     0.150
     2.007    32.532     0.150
     2.287    36.922     0.150
     2.331    38.652     0.150
     2.328    38.922     0.150
     2.359    38.042     0.150
     2.429    36.592     0.150
     2.424    38.922     0.150
     2.664    40.402     0.150
     2.759    42.492     0.150
     2.767    43.912     0.150
     2.862    48.602     0.150
     3.114    47.282     0.150
     3.145    47.922     0.150
     5.696    86.183     0.150
     5.696   181.327     0.150
     7.585   113.202     0.150
     7.585   143.527     0.150
     7.585   239.227     0.150
     7.823   115.321     0.150
     7.823   144.621     0.150
     7.823   244.671     0.150
    10.726   159.199     0.150
    10.925   156.627     0.150
     0.029     1.492     0.150
     0.036     0.982     0.150
     0.036     2.262     0.150
     0.093     5.111     0.150
     0.139     5.191     0.150
     0.271     5.441     0.150
     0.298     6.492     0.150
     0.291     6.352     0.150
     0.291    11.281     0.150
     0.299     5.602     0.150
     0.299     9.512     0.150
     0.343     7.371     0.150
     0.343    13.082     0.150
     0.344     7.211     0.150
     0.363     7.291     0.150
     0.363    13.342     0.150
     0.375     7.582     0.150
     0.400     7.893     0.150
     0.421     8.723     0.150
     0.430     8.951     0.150
     0.430    16.053     0.150
     0.439     9.383     0.150
     0.439    16.291     0.150
     0.439     8.941     0.150
     0.501    10.102     0.150
     0.501    17.383     0.150
     0.495     9.541     0.150
     0.495    16.682     0.150
     0.536    10.771     0.150
     0.541    10.121     0.150
     0.541    17.701     0.150
     0.542    10.482     0.150
     0.542    18.592     0.150
     0.519    10.102     0.150
     0.519    18.252     0.150
     0.518    10.211     0.150
     0.518    17.092     0.150
     0.553    10.521     0.150
     0.553    19.461     0.150
     0.542    10.572     0.150
     0.542    19.002     0.150
     0.585    10.932     0.150
     0.585    18.992     0.150
     0.584    10.742     0.150
     0.584    20.771     0.150
     0.574    10.992     0.150
     0.574    19.072     0.150
     0.592    11.422     0.150
     0.592    20.002     0.150
     0.577    11.723     0.150
     0.580    11.432     0.150
     0.611    11.781     0.150
     0.611    20.682     0.150
     0.610    11.223     0.150
     0.610    19.602     0.150
     0.613    11.361     0.150
     0.613    20.121     0.150
     0.643    21.242     0.150
     0.643    12.312     0.150
     0.659    12.361     0.150
     0.659    21.562     0.150
     0.666    12.941     0.150
     0.666    22.143     0.150
     0.669    12.951     0.150
     0.669    22.701     0.150
     0.674    12.441     0.150
     0.674    23.441     0.150
     0.684    13.242     0.150
     0.684    22.861     0.150
     0.709    12.992     0.150
     0.709    22.893     0.150
     0.721    13.332     0.150
     0.721    23.711     0.150
     0.725    13.662     0.150
     0.725    24.291     0.150
     0.738    14.002     0.150
     0.738    24.812     0.150
     0.757    14.072     0.150
     0.755    14.451     0.150
     0.755    26.143     0.150
     0.776    14.832     0.150
     0.776    25.812     0.150
     0.769    14.252     0.150
     0.769    25.883     0.150
     0.802    14.902     0.150
     0.797    14.982     0.150
     0.797    26.031     0.150
     0.793    14.672     0.150
     0.793    25.932     0.150
     0.791    14.711     0.150
     0.791    25.633     0.150
     0.809    15.223     0.150
     0.793    25.816     0.150
     0.793    25.711     0.150
     0.819    15.252     0.150
     0.809    14.312     0.150
     0.809    25.732     0.150
     0.819    15.152     0.150
     0.831    15.461     0.150
     0.831    26.682     0.150
     0.849    15.803     0.150
     0.849    27.332     0.150
     0.863    15.771     0.150
     0.863    27.383     0.150
     0.852    15.482     0.150
     0.852    28.271     0.150
     0.885    16.082     0.150
     0.885    28.223     0.150
     0.858    15.732     0.150
     0.865    16.002     0.150
     0.865    28.252     0.150
     0.879    16.412     0.150
     0.879    28.633     0.150
     0.886    16.201     0.150
     0.886    28.621     0.150
     0.898    16.643     0.150
     0.898    29.312     0.150
     0.898    16.633     0.150
     0.898    29.291     0.150
     0.908    16.621     0.150
     0.908    29.611     0.150
     0.926    17.021     0.150
     0.926    29.711     0.150
     0.940    17.092     0.150
     0.940    30.133     0.150
     0.953    16.402     0.150
     0.953    30.111     0.150
     0.994    17.672     0.150
     0.976    17.492     0.150
     0.976    31.133     0.150
     0.979    17.752     0.150
     0.979    31.352     0.150
     0.978    17.371     0.150
     0.978    31.211     0.150
     1.012    18.053     0.150
     0.977    18.451     0.150
     0.977    32.791     0.150
     0.988    18.012     0.150
     0.988    32.152     0.150
     1.011    18.271     0.150
     1.011    18.191     0.150
     1.023    18.633     0.150
     1.043    18.482     0.150
     1.043    32.342     0.150
     1.027    18.332     0.150
     1.027    32.562     0.150
     1.026    18.352     0.150
     1.042    18.332     0.150
     1.042    32.143     0.150
     1.056    19.492     0.150
     1.083    19.111     0.150
     1.083    35.832     0.150
     1.070    18.852     0.150
     1.070    33.562     0.150
     1.096    19.252     0.150
     1.096    33.633     0.150
     1.106    19.502     0.150
     1.083    19.121     0.150
     1.100    20.621     0.150
     1.145    19.922     0.150
     1.145    34.883     0.150
     1.150    20.371     0.150
     1.150    36.312     0.150
     1.172    20.291     0.150
     1.172    35.691     0.150
     1.171    20.822     0.150
     1.171    36.803     0.150
     1.187    36.393     0.150
     1.184    20.951     0.150
     1.184    37.262     0.150
     1.184    20.672     0.150
     1.218    21.451     0.150
     1.219    37.041     0.150
     1.216    21.172     0.150
     1.222    21.082     0.150
     1.233    20.922     0.150
     1.238    38.102     0.150
     1.258    22.883     0.150
     1.277    38.461     0.150
     1.277    38.961     0.150
     1.278    38.492     0.150
     1.279    22.361     0.150
     1.309    39.842     0.150
     1.320    22.492     0.150
     1.320    39.701     0.150
     1.358    23.691     0.150
     1.351    22.992     0.150
     1.347    24.521     0.150
     1.368    23.432     0.150
     1.373    23.883     0.150
     1.373    42.781     0.150
     1.406    23.961     0.150
     1.398    24.102     0.150
     1.475    26.512     0.150
     1.550    25.852     0.150
     1.550    47.582     0.150
     1.568    27.162     0.150
     1.553    25.912     0.150
     1.546    28.611     0.150
     1.621    26.922     0.150
     1.643    28.012     0.150
     1.668    27.973     0.150
     1.704    28.521     0.150
     1.796    29.531     0.150
     1.970    32.422     0.150
     2.208    38.512     0.150
     2.253    36.723     0.150
     2.325    37.371     0.150
     2.468    37.383     0.150
     2.698    40.893     0.150
     2.721    42.781     0.150
     2.725    44.451     0.150
     2.921    46.162     0.150
     3.072    46.912     0.150
     3.105    48.312     0.150
     3.237    49.432     0.150
     3.393    51.732     0.150
     3.683    58.951     0.150
     3.717    57.652     0.150
     3.807    57.711     0.150
     3.874    59.133     0.150
     3.914    59.461     0.150
     4.049    61.771     0.150
     4.197    62.541     0.150
     4.197    62.422     0.150
     4.307    65.211     0.150
     4.447    66.482     0.150
     4.647    68.973     0.150
     4.738    71.111     0.150
     4.879    72.861     0.150
     4.871    73.412     0.150
     4.932    73.662     0.150
     5.317    78.393     0.150
     5.654    83.020     0.150
     6.181    91.012     0.150
     6.471    94.893     0.150
     6.655    97.242     0.150
     7.293   106.791     0.150
     7.830   113.582     0.150
     7.832   112.916     0.150
     7.832   202.467     0.150
     7.832   242.441     0.150
    10.954   157.078     0.150
    10.954   278.473     0.150
    10.954   345.646     0.150
     0.039     1.514     0.150
     0.039     3.174     0.150
     0.054     1.664     0.150
     0.054     3.904     0.150
     0.102     2.555     0.150
     0.102     5.215     0.150
     0.115     3.014     0.150
     0.115     6.115     0.150
     0.144     3.375     0.150
     0.144     6.924     0.150
     0.223     5.164     0.150
     0.223     9.574     0.150
     0.258     5.285     0.150
     0.240     4.994     0.150
     0.240     7.705     0.150
     0.245     8.785     0.150
     0.245     5.135     0.150
     0.250     5.625     0.150
     0.250    10.484     0.150
     0.296     5.574     0.150
     0.296     9.625     0.150
     0.302     6.674     0.150
     0.302    11.814     0.150
     0.321     6.994     0.150
     0.321    12.355     0.150
     0.324     6.635     0.150
     0.324    12.145     0.150
     0.328     6.814     0.150
     0.328    12.744     0.150
     0.378     7.555     0.150
     0.378    13.305     0.150
     0.374    14.715     0.150
     0.393     8.535     0.150
     0.393    15.395     0.150
     0.444     9.035     0.150
     0.444    15.715     0.150
     0.485    17.475     0.150
     0.499     9.445     0.150
     0.499    16.145     0.150
     0.509    10.135     0.150
     0.519    10.264     0.150
     0.519    18.184     0.150
     0.533    10.344     0.150
     0.533    17.705     0.150
     0.516     9.924     0.150
     0.516    18.125     0.150
     0.522    10.184     0.150
     0.522    17.635     0.150
     0.536    19.555     0.150
     0.563    11.004     0.150
     0.563    19.805     0.150
     0.567    10.904     0.150
     0.567    19.145     0.150
     0.550    10.254     0.150
     0.550    17.744     0.150
     0.589    11.404     0.150
     0.589    20.195     0.150
     0.581    10.775     0.150
     0.581    18.855     0.150
     0.590    11.404     0.150
     0.590    19.615     0.150
     0.603    11.514     0.150
     0.621    12.705     0.150
     0.625    12.264     0.150
     0.637    21.725     0.150
     0.637    12.395     0.150
     0.632    11.904     0.150
     0.632    20.584     0.150
     0.632    12.135     0.150
     0.632    21.445     0.150
     0.653    21.314     0.150
     0.665    12.514     0.150
     0.671    12.934     0.150
     0.671    22.324     0.150
     0.655    12.674     0.150
     0.655    21.955     0.150
     0.682    12.605     0.150
     0.682    22.955     0.150
     0.687    12.514     0.150
     0.687    21.744     0.150
     0.748    14.234     0.150
     0.748    24.725     0.150
     0.760    14.365     0.150
     0.760    25.154     0.150
     0.777    13.855     0.150
     0.775    13.615     0.150
     0.775    23.764     0.150
     0.797    14.465     0.150
     0.797    24.865     0.150
     0.800    15.094     0.150
     0.785    14.805     0.150
     0.813    15.094     0.150
     0.813    27.125     0.150
     0.807    26.264     0.150
     0.812    14.994     0.150
     0.814    15.125     0.150
     0.830    15.225     0.150
     0.830    26.164     0.150
     0.848    15.605     0.150
     0.864    15.785     0.150
     0.880    28.295     0.150
     0.870    15.885     0.150
     0.898    16.205     0.150
     0.898    28.955     0.150
     0.906    16.535     0.150
     0.906    29.305     0.150
     0.908    16.654     0.150
     0.921    29.234     0.150
     0.908    16.504     0.150
     0.908    28.605     0.150
     0.928    30.275     0.150
     0.931    17.145     0.150
     0.985    17.555     0.150
     0.985    30.744     0.150
     1.104    19.404     0.150
     1.104    34.195     0.150
     1.111    19.174     0.150
     1.193    20.795     0.150
     1.197    21.225     0.150
     1.227    21.645     0.150
     1.349    24.404     0.150
     1.505    26.234     0.150
     1.539    26.574     0.150
     1.578    26.504     0.150
     1.593    26.844     0.150
     1.618    27.514     0.150
     1.712    28.594     0.150
     1.752    29.305     0.150
     2.007    32.764     0.150
     2.378    36.764     0.150
     2.287    37.365     0.150
     2.338    37.545     0.150
     2.360    38.264     0.150
     2.358    38.115     0.150
     2.376    38.594     0.150
     2.433    39.215     0.150
     2.665    40.965     0.150
     2.761    42.674     0.150
     2.771    42.594     0.150
     2.799    43.445     0.150
     2.989    45.934     0.150
     3.089    48.645     0.150
     3.118    47.934     0.150
     3.147    47.924     0.150
     3.151    48.285     0.150
     3.283    50.555     0.150
     3.319    50.074     0.150
     3.436    51.945     0.150
     3.465    52.105     0.150
     3.719    57.385     0.150
     3.730    56.465     0.150
     3.829    57.994     0.150
     3.853    58.115     0.150
     3.871    58.955     0.150
     3.901    59.084     0.150
     3.906    59.635     0.150
     3.916    58.744     0.150
     4.071    60.994     0.150
     4.174    62.734     0.150
     4.249    63.924     0.150
     4.280    64.895     0.150
     4.280    65.635     0.150
     4.330    66.035     0.150
     4.501    68.605     0.150
     4.548    67.775     0.150
     4.774    71.715     0.150
     4.883    73.855     0.150
     4.931    74.855     0.150
     5.187    76.305     0.150
     5.287    78.154     0.150
     5.570    82.244     0.150
     5.701   105.869     0.150
     6.638    97.275     0.150
    10.927   155.869     0.150
     0.028     2.164     0.150
     0.031     2.805     0.150
     0.074     4.555     0.150
     0.140     3.594     0.150
     0.140     6.969     0.150
     0.198     4.828     0.150
     0.198     9.328     0.150
     0.235     4.828     0.150
     0.255     5.117     0.150
     0.257     5.156     0.150
     0.257     9.023     0.150
     0.303     6.734     0.150
     0.303    12.008     0.150
     0.275     6.094     0.150
     0.275    11.094     0.150
     0.322     7.047     0.150
     0.366     7.617     0.150
     0.345     7.031     0.150
     0.345    12.758     0.150
     0.353     7.328     0.150
     0.387     7.633     0.150
     0.387    13.492     0.150
     0.399     8.477     0.150
     0.399    15.586     0.150
     0.435     8.797     0.150
     0.417    16.195     0.150
     0.460     9.523     0.150
     0.507    10.086     0.150
     0.507    17.719     0.150
     0.521    10.508     0.150
     0.521    18.328     0.150
     0.530    10.266     0.150
     0.520     9.688     0.150
     0.520    17.234     0.150
     0.514    10.031     0.150
     0.514    16.852     0.150
     0.542    10.516     0.150
     0.542    18.477     0.150
     0.540    10.688     0.150
     0.540    18.375     0.150
     0.564    10.914     0.150
     0.536    10.172     0.150
     0.566    10.484     0.150
     0.566    17.922     0.150
     0.597    11.883     0.150
     0.622    12.055     0.150
     0.622    21.219     0.150
     0.597    10.969     0.150
     0.597    19.445     0.150
     0.651    12.328     0.150
     0.651    20.367     0.150
     0.644    21.008     0.150
     0.668    12.922     0.150
     0.668    21.805     0.150
     0.668    12.844     0.150
     0.655    12.148     0.150
     0.655    22.445     0.150
     0.669    22.492     0.150
     0.740    25.062     0.150
     0.703    12.938     0.150
     0.700    12.727     0.150
     0.700    21.266     0.150
     0.775    14.094     0.150
     0.775    24.258     0.150
     0.776    26.758     0.150
     0.744    24.508     0.150
     0.792    14.727     0.150
     0.789    26.555     0.150
     0.800    26.195     0.150
     0.808    14.992     0.150
     0.808    25.875     0.150
     0.810    14.586     0.150
     0.810    24.703     0.150
     0.808    25.906     0.150
     0.810    14.891     0.150
     0.810    25.742     0.150
     0.815    15.195     0.150
     0.815    26.477     0.150
     0.800    13.914     0.150
     0.834    26.922     0.150
     0.795    14.086     0.150
     0.795    25.297     0.150
     0.862    28.383     0.150
     0.862    28.219     0.150
     0.874    28.383     0.150
     0.885    29.492     0.150
     0.893    29.703     0.150
     0.881    16.242     0.150
     0.881    28.203     0.150
     0.911    16.633     0.150
     0.913    16.781     0.150
     0.913    29.672     0.150
     0.943    17.188     0.150
     0.987    17.312     0.150
     0.987    30.227     0.150
     0.992    17.875     0.150
     1.000    18.547     0.150
     1.010    18.344     0.150
     1.025    18.297     0.150
     1.038    18.523     0.150
     1.091    19.578     0.150
     1.097    19.164     0.150
     1.097    33.398     0.150
     1.074    34.625     0.150
     1.107    20.836     0.150
     1.107    35.203     0.150
     1.169    20.719     0.150
     1.179    20.023     0.150
     1.179    38.547     0.150
     1.424    20.672     0.150
     1.204    20.867     0.150
     1.204    36.852     0.150
     1.213    21.844     0.150
     1.236    37.477     0.150
     1.382    23.328     0.150
     1.484    26.578     0.150
     1.562    25.664     0.150
     1.552    26.344     0.150
     1.569    27.156     0.150
     1.632    27.328     0.150
     1.689    29.383     0.150
     1.693    31.281     0.150
     1.774    29.047     0.150
     1.987    31.797     0.150
     2.056    33.344     0.150
     2.236    36.164     0.150
     2.403    36.383     0.150
     2.268    36.797     0.150
     2.293    37.727     0.150
     2.313    37.477     0.150
     2.340    37.719     0.150
     2.339    37.617     0.150
     2.420    39.117     0.150
     2.739    42.812     0.150
     2.775    44.281     0.150
     2.936    45.414     0.150
     2.965    45.969     0.150
     2.966    46.414     0.150
     3.094    46.672     0.150
     3.082    48.492     0.150
     3.127    47.664     0.150
     3.259    49.766     0.150
     3.301    49.719     0.150
     3.720    56.695     0.150
     3.805    58.633     0.150
     3.829    57.594     0.150
     3.877    58.125     0.150
     3.893    59.102     0.150
     3.866    58.016     0.150
     3.912    59.086     0.150
     4.047    61.742     0.150
     4.071    60.633     0.150
     4.188    61.102     0.150
     4.329    66.031     0.150
     4.313    65.273     0.150
     4.468    66.688     0.150
     4.486    68.469     0.150
     4.756    71.477     0.150
     4.934    74.055     0.150
     5.162    76.773     0.150
     5.178    77.688     0.150
     5.221    78.234     0.150
     5.315    78.477     0.150
     5.550    83.398     0.150
     5.677    86.164     0.150
     5.677   105.945     0.150
     5.677   179.617     0.150
     5.774    84.703     0.150
     6.020    89.656     0.150
     6.150    91.227     0.150
     6.197    92.008     0.150
     6.217    93.188     0.150
     6.718    97.992     0.150
     7.109   105.188     0.150
     7.236   105.898     0.150
     7.291   105.383     0.150
     7.375   106.844     0.150
     7.483   108.367     0.150
     7.493   108.055     0.150
     7.571   112.547     0.150
     7.571   142.078     0.150
     7.571   239.352     0.150
     7.571   109.133     0.150
     7.599   108.836     0.150
     7.727   113.117     0.150
     7.746   113.422     0.150
     7.780   112.906     0.150
     7.832   115.391     0.150
     7.832   146.094     0.150
     7.832   243.594     0.150
     7.832   114.438     0.150
     8.022   116.227     0.150
     8.802   125.492     0.150
     9.028   129.984     0.150
     9.235   133.281     0.150
    10.718   158.570     0.150
    10.942   155.562     0.150
    10.942   156.172     0.150
    10.942   341.852     0.150
    13.421   191.406     0.150
    15.123   211.406     0.150
    15.274   216.445     0.150
    15.397   222.094     0.150
    15.420   217.984     0.150
    15.611   223.906     0.150
    15.671   224.562     0.150
    15.812   227.164     0.150
    36.935   430.906     0.150
     0.042     1.794     0.150
     0.050     1.044     0.150
     0.050     3.004     0.150
     0.111     2.504     0.150
     0.111     5.794     0.150
     0.099     2.364     0.150
     0.099     5.523     0.150
     0.163     4.124     0.150
     0.163     7.954     0.150
     0.157     3.483     0.150
     0.157     7.464     0.150
     0.183     4.304     0.150
     0.183     8.324     0.150
     0.155     3.813     0.150
     0.155     7.684     0.150
     0.165     4.054     0.150
     0.165     8.014     0.150
     0.194     3.764     0.150
     0.287     5.813     0.150
     0.287    10.233     0.150
     0.287     5.824     0.150
     0.280     6.174     0.150
     0.318    11.974     0.150
     0.302     5.374     0.150
     0.302    10.023     0.150
     0.324     6.964     0.150
     0.324    12.444     0.150
     0.362     7.604     0.150
     0.362    13.784     0.150
     0.395    15.034     0.150
     0.412     8.204     0.150
     0.412    14.804     0.150
     0.427     8.684     0.150
     0.427    14.284     0.150
     0.441     9.144     0.150
     0.419     9.204     0.150
     0.496     9.794     0.150
     0.496    17.694     0.150
     0.478     9.194     0.150
     0.499     9.914     0.150
     0.499     9.724     0.150
     0.499    17.884     0.150
     0.523    10.313     0.150
     0.523    18.354     0.150
     0.554    10.664     0.150
     0.554    19.654     0.150
     0.561    10.504     0.150
     0.561    18.444     0.150
     0.563    10.824     0.150
     0.569    10.834     0.150
     0.569    20.504     0.150
     0.561    11.174     0.150
     0.595    11.834     0.150
     0.595    19.754     0.150
     0.601    11.254     0.150
     0.601    19.944     0.150
     0.596    20.164     0.150
     0.622    11.523     0.150
     0.622    20.604     0.150
     0.635    12.094     0.150
     0.635    21.744     0.150
     0.672    12.634     0.150
     0.672    22.124     0.150
     0.664    12.964     0.150
     0.671    12.974     0.150
     0.671    23.454     0.150
     0.692    24.523     0.150
     0.699    13.504     0.150
     0.699    23.634     0.150
     0.712    13.424     0.150
     0.712    24.974     0.150
     0.718    13.164     0.150
     0.718    23.864     0.150
     0.733    13.974     0.150
     0.741    13.824     0.150
     0.741    24.224     0.150
     0.750    14.304     0.150
     0.750    24.523     0.150
     0.778    14.483     0.150
     0.776    14.534     0.150
     0.778    25.933     0.150
     0.778    14.154     0.150
     0.795    15.044     0.150
     0.806    26.284     0.150
     0.824    15.624     0.150
     0.824    26.874     0.150
     0.826    15.563     0.150
     0.826    27.023     0.150
     0.822    14.504     0.150
     0.843    14.773     0.150
     0.832    15.154     0.150
     0.865    16.144     0.150
     0.865    27.714     0.150
     0.838    27.194     0.150
     0.838    15.744     0.150
     0.866    29.074     0.150
     0.872    16.014     0.150
     0.872    29.174     0.150
     0.887    16.424     0.150
     0.887    29.784     0.150
     0.885    30.164     0.150
     0.885    16.733     0.150
     0.893    16.504     0.150
     0.919    17.014     0.150
     0.967    17.624     0.150
     0.967    31.773     0.150
     0.963    17.634     0.150
     0.963    31.214     0.150
     0.960    17.284     0.150
     0.960    31.364     0.150
     0.999    17.904     0.150
     0.999    31.444     0.150
     0.999    18.294     0.150
     1.020    18.404     0.150
     1.020    32.273     0.150
     1.015    18.404     0.150
     1.012    33.034     0.150
     1.012    32.864     0.150
     1.043    18.733     0.150
     1.043    32.874     0.150
     1.048    18.964     0.150
     1.040    19.324     0.150
     1.051    18.894     0.150
     1.063    19.483     0.150
     1.094    19.724     0.150
     1.094    20.634     0.150
     1.151    20.224     0.150
     1.161    20.844     0.150
     1.167    20.563     0.150
     1.464    21.714     0.150
     1.229    21.944     0.150
     1.263    21.394     0.150
     1.363    24.794     0.150
     1.525    28.444     0.150
     1.673    31.284     0.150
     1.815    30.194     0.150
     2.093    37.514     0.150
     2.163    34.914     0.150
     2.239    37.834     0.150
     2.272    39.154     0.150
     2.335    37.464     0.150
     2.393    39.273     0.150
     2.712    41.684     0.150
     2.704    43.104     0.150
     2.731    43.924     0.150
     2.815    46.494     0.150
     5.634    86.236     0.150
     5.634   104.389     0.150
     5.634   178.035     0.150
     7.529   112.139     0.150
     7.529   140.688     0.150
     7.831   117.070     0.150
     7.831   145.775     0.150
    10.684   159.414     0.150
    10.965   159.449     0.150
    15.080   220.947     0.150
    27.575   350.300     0.150
    36.892   429.731     0.150
     0.043     0.502     0.150
     0.051     0.762     0.150
     0.051     2.072     0.150
     0.098     2.213     0.150
     0.098     5.113     0.150
     0.113     2.543     0.150
     0.113     5.771     0.150
     0.154     3.771     0.150
     0.154     7.521     0.150
     0.158     3.533     0.150
     0.185     4.262     0.150
     0.185     8.582     0.150
     0.192     3.902     0.150
     0.192     7.193     0.150
     0.280     6.053     0.150
     0.280    11.193     0.150
     0.289     5.822     0.150
     0.301     5.553     0.150
     0.301     9.822     0.150
     0.320     6.893     0.150
     0.320    12.271     0.150
     0.323     6.893     0.150
     0.363     7.732     0.150
     0.363    13.873     0.150
     0.396     8.062     0.150
     0.396    14.803     0.150
     0.413     8.162     0.150
     0.413    14.713     0.150
     0.418     8.742     0.150
     0.427     8.682     0.150
     0.427    15.422     0.150
     0.443     9.172     0.150
     0.443    17.053     0.150
     0.461     9.783     0.150
     0.461    18.092     0.150
     0.477    16.143     0.150
     0.477     9.182     0.150
     0.496     9.863     0.150
     0.496    17.203     0.150
     0.497     9.883     0.150
     0.497    17.262     0.150
     0.497     9.752     0.150
     0.521    10.363     0.150
     0.521    18.172     0.150
     0.555    10.762     0.150
     0.555    18.953     0.150
     0.557    11.932     0.150
     0.563    10.863     0.150
     0.562    10.533     0.150
     0.562    18.252     0.150
     0.560    11.521     0.150
     0.560    19.213     0.150
     0.570    10.902     0.150
     0.570    19.883     0.150
     0.596    11.562     0.150
     0.596    20.002     0.150
     0.595    20.693     0.150
     0.602    20.521     0.150
     0.602    11.842     0.150
     0.602    19.902     0.150
     0.602    11.252     0.150
     0.606    12.402     0.150
     0.606    21.822     0.150
     0.623    11.592     0.150
     0.623    20.072     0.150
     0.635    12.133     0.150
     0.635    21.203     0.150
     0.664    12.963     0.150
     0.664    22.422     0.150
     0.672    13.021     0.150
     0.672    23.213     0.150
     0.673    12.633     0.150
     0.673    22.592     0.150
     0.693    12.873     0.150
     0.693    24.363     0.150
     0.711    24.492     0.150
     0.700    13.512     0.150
     0.700    23.592     0.150
     0.719    23.082     0.150
     0.719    13.162     0.150
     0.736    14.262     0.150
     0.736    26.283     0.150
     0.740    24.543     0.150
     0.740    13.652     0.150
     0.732    13.893     0.150
     0.732    25.602     0.150
     0.738    13.473     0.150
     0.738    24.832     0.150
     0.748    14.283     0.150
     0.766    14.613     0.150
     0.766    25.502     0.150
     0.770    13.232     0.150
     0.777    14.402     0.150
     0.775    14.482     0.150
     0.775    25.992     0.150
     0.777    25.877     0.150
     0.795    26.582     0.150
     0.805    14.973     0.150
     0.805    26.123     0.150
     0.810    15.133     0.150
     0.810    26.213     0.150
     0.813    15.262     0.150
     0.824    15.463     0.150
     0.824    27.062     0.150
     0.826    15.402     0.150
     0.826    27.133     0.150
     0.823    14.662     0.150
     0.823    25.852     0.150
     0.831    15.402     0.150
     0.831    27.363     0.150
     0.836    27.332     0.150
     0.836    15.793     0.150
     0.846    15.883     0.150
     0.846    28.592     0.150
     0.844    15.053     0.150
     0.865    15.953     0.150
     0.865    27.521     0.150
     0.865    29.082     0.150
     0.884    29.682     0.150
     0.884    16.703     0.150
     0.886    16.521     0.150
     0.894    16.312     0.150
     0.892    16.521     0.150
     0.892    29.252     0.150
     0.919    17.123     0.150
     0.919    29.213     0.150
     0.938    17.373     0.150
     0.938    29.912     0.150
     0.961    17.562     0.150
     0.961    31.912     0.150
     0.958    17.293     0.150
     0.958    31.443     0.150
     0.961    17.293     0.150
     0.961    30.432     0.150
     0.966    18.242     0.150
     0.966    32.012     0.150
     0.973    17.482     0.150
     0.973    31.053     0.150
     0.998    18.082     0.150
     0.998    32.152     0.150
     1.000    17.883     0.150
     1.000    31.352     0.150
     0.999    18.342     0.150
     0.999    32.482     0.150
     1.011    18.213     0.150
     1.011    32.623     0.150
     1.011    18.262     0.150
     1.011    32.412     0.150
     1.015    18.732     0.150
     1.015    33.152     0.150
     1.044    32.473     0.150
     1.038    19.203     0.150
     1.050    18.752     0.150
     1.050    33.492     0.150
     1.061    19.252     0.150
     1.094    19.453     0.150
     1.093    20.283     0.150
     1.113    19.793     0.150
     1.161    20.703     0.150
     1.165    20.553     0.150
     1.465    21.283     0.150
     1.230    21.703     0.150
     1.264    21.012     0.150
     1.364    24.342     0.150
     1.442    27.033     0.150
     1.524    28.652     0.150
     1.649    28.562     0.150
     1.671    31.262     0.150
     1.817    30.232     0.150
     2.238    37.012     0.150
     2.252    36.703     0.150
     2.311    38.223     0.150
     2.335    38.682     0.150
     2.392    40.082     0.150
     2.703    43.033     0.150
     2.704    42.902     0.150
     2.713    41.832     0.150
     2.813    44.322     0.150
     3.051    47.613     0.150
     5.632    85.146     0.150
     5.632   104.797     0.150
     5.632   176.297     0.150
     7.528   112.582     0.150
     7.528   235.277     0.150
     7.831   116.352     0.150
     7.831   245.484     0.150
    10.683   155.758     0.150
    10.683   342.270     0.150
    10.966   158.258     0.150
    10.966   346.625     0.150
    15.079   215.938     0.150
    29.309   363.646     0.150
    36.890   429.219     0.150
    94.400   797.232     0.150
   100.431   829.033     0.150
     0.055     2.676     0.150
     0.115     5.705     0.150
     0.106     5.076     0.150
     0.161     6.906     0.150
     0.155     7.846     0.150
     0.184     4.156     0.150
     0.184     8.246     0.150
     0.165     3.906     0.150
     0.165     7.826     0.150
     0.282     5.555     0.150
     0.282    10.766     0.150
     0.282     5.625     0.150
     0.273     5.936     0.150
     0.273    11.225     0.150
     0.309     5.516     0.150
     0.309    10.135     0.150
     0.318     6.795     0.150
     0.322     6.875     0.150
     0.322    11.926     0.150
     0.359    13.775     0.150
     0.384    14.064     0.150
     0.405     8.035     0.150
     0.405    14.656     0.150
     0.419     8.416     0.150
     0.443     9.115     0.150
     0.443    17.195     0.150
     0.458     9.625     0.150
     0.458    18.096     0.150
     0.483     9.375     0.150
     0.483    16.705     0.150
     0.488     9.586     0.150
     0.501    17.725     0.150
     0.520    10.215     0.150
     0.520    18.736     0.150
     0.547    10.555     0.150
     0.547    19.064     0.150
     0.558    10.406     0.150
     0.558    18.465     0.150
     0.574    11.195     0.150
     0.574    20.406     0.150
     0.555    11.736     0.150
     0.556    10.756     0.150
     0.558    11.275     0.150
     0.596    11.246     0.150
     0.596    19.736     0.150
     0.587    11.516     0.150
     0.592    20.746     0.150
     0.595    11.445     0.150
     0.595    20.826     0.150
     0.628    11.576     0.150
     0.628    20.555     0.150
     0.628    11.926     0.150
     0.628    21.285     0.150
     0.656    12.715     0.150
     0.666    12.756     0.150
     0.666    22.305     0.150
     0.663    12.656     0.150
     0.696    13.285     0.150
     0.696    24.006     0.150
     0.725    13.225     0.150
     0.693    13.875     0.150
     0.693    23.375     0.150
     0.706    13.365     0.150
     0.706    23.506     0.150
     0.742    13.686     0.150
     0.742    25.176     0.150
     0.740    14.215     0.150
     0.736    13.875     0.150
     0.746    14.465     0.150
     0.765    14.580     0.150
     0.773    14.326     0.150
     0.773    14.445     0.150
     0.773    25.969     0.150
     0.787    26.275     0.150
     0.805    15.055     0.150
     0.800    25.945     0.150
     0.816    27.115     0.150
     0.844    15.635     0.150
     0.830    15.656     0.150
     0.837    15.715     0.150
     0.843    15.846     0.150
     0.857    27.586     0.150
     0.859    16.145     0.150
     0.859    29.025     0.150
     0.886    28.736     0.150
     0.879    16.576     0.150
     0.930    17.416     0.150
     0.958    18.625     0.150
     0.956    17.285     0.150
     0.961    17.506     0.150
     0.967    18.525     0.150
     0.992    18.195     0.150
     0.992    18.055     0.150
     0.992    18.016     0.150
     1.012    18.535     0.150
     1.012    32.045     0.150
     1.006    32.875     0.150
     1.006    32.465     0.150
     1.008    18.586     0.150
     1.025    19.236     0.150
     1.035    18.375     0.150
     1.035    32.785     0.150
     1.040    32.576     0.150
     1.045    19.645     0.150
     1.048    19.176     0.150
     1.048    33.275     0.150
     1.062    19.105     0.150
     1.070    19.115     0.150
     1.086    19.496     0.150
     1.102    20.826     0.150
     1.104    19.885     0.150
     1.154    21.525     0.150
     1.167    20.936     0.150
     1.167    36.096     0.150
     1.163    21.096     0.150
     1.203    20.766     0.150
     1.216    21.695     0.150
     1.216    37.795     0.150
     1.222    22.086     0.150
     1.269    21.225     0.150
     1.264    22.055     0.150
     1.266    22.205     0.150
     1.266    39.965     0.150
     1.307    22.766     0.150
     1.344    42.395     0.150
     1.355    24.475     0.150
     1.349    23.145     0.150
     1.351    23.885     0.150
     1.392    24.016     0.150
     1.447    27.086     0.150
     1.525    28.305     0.150
     1.576    28.045     0.150
     1.660    29.385     0.150
     1.646    29.625     0.150
     1.813    30.564     0.150
     2.250    39.885     0.150
     2.343    41.576     0.150
     2.333    41.375     0.150
     2.441    40.865     0.150
     2.510    43.656     0.150
     2.812    43.166     0.150
     5.633    87.156     0.150
     5.633   105.225     0.150
     5.633   177.916     0.150
     7.532   112.654     0.150
     7.532   142.051     0.150
     7.532   238.275     0.150
     7.839   115.854     0.150
     7.839   146.045     0.150
    10.689   158.225     0.150
    10.689   343.422     0.150
    10.972   157.721     0.150
    10.972   347.428     0.150
    36.891   429.814     0.150
     0.047     1.439     0.150
     0.055     2.420     0.150
     0.114     2.670     0.150
     0.114     5.779     0.150
     0.155     3.770     0.150
     0.166     3.900     0.150
     0.183     4.289     0.150
     0.183     8.391     0.150
     0.198     3.980     0.150
     0.273     6.061     0.150
     0.273    10.820     0.150
     0.281     5.699     0.150
     0.281     9.879     0.150
     0.281     5.680     0.150
     0.281     9.721     0.150
     0.317     6.789     0.150
     0.317    12.570     0.150
     0.310     5.650     0.150
     0.310    10.100     0.150
     0.323     6.910     0.150
     0.323    12.061     0.150
     0.357     7.510     0.150
     0.357    13.629     0.150
     0.404     8.061     0.150
     0.404    14.230     0.150
     0.396     8.020     0.150
     0.396    14.850     0.150
     0.419     8.590     0.150
     0.417     8.811     0.150
     0.417    15.500     0.150
     0.442     9.180     0.150
     0.457     9.619     0.150
     0.488     9.789     0.150
     0.484     9.330     0.150
     0.484    16.449     0.150
     0.499     9.840     0.150
     0.499    18.049     0.150
     0.502     9.799     0.150
     0.521    10.299     0.150
     0.521    18.480     0.150
     0.546    10.629     0.150
     0.546    18.539     0.150
     0.557    10.439     0.150
     0.557    18.340     0.150
     0.556    10.709     0.150
     0.555    11.670     0.150
     0.558    11.221     0.150
     0.586    11.400     0.150
     0.586    19.221     0.150
     0.574    10.971     0.150
     0.574    20.160     0.150
     0.595    19.439     0.150
     0.595    11.609     0.150
     0.595    20.189     0.150
     0.592    10.939     0.150
     0.592    19.430     0.150
     0.604    20.990     0.150
     0.627    11.900     0.150
     0.627    20.350     0.150
     0.628    11.619     0.150
     0.628    20.529     0.150
     0.655    12.670     0.150
     0.655    21.900     0.150
     0.662    12.869     0.150
     0.662    22.730     0.150
     0.665    12.561     0.150
     0.665    21.689     0.150
     0.696    13.279     0.150
     0.696    24.340     0.150
     0.706    13.391     0.150
     0.706    23.561     0.150
     0.692    13.539     0.150
     0.692    23.289     0.150
     0.726    13.369     0.150
     0.734    14.369     0.150
     0.737    13.379     0.150
     0.737    24.029     0.150
     0.742    13.779     0.150
     0.742    25.000     0.150
     0.747    14.430     0.150
     0.747    24.660     0.150
     0.741    14.039     0.150
     0.759    14.430     0.150
     0.759    25.840     0.150
     0.773    14.650     0.150
     0.771    14.529     0.150
     0.771    25.119     0.150
     0.773    14.354     0.150
     0.773    24.062     0.150
     0.773    25.020     0.150
     0.786    14.811     0.150
     0.800    14.850     0.150
     0.800    26.340     0.150
     0.804    15.100     0.150
     0.800    14.910     0.150
     0.800    25.629     0.150
     0.815    15.250     0.150
     0.815    26.529     0.150
     0.818    15.209     0.150
     0.828    14.709     0.150
     0.828    26.869     0.150
     0.831    15.279     0.150
     0.831    27.129     0.150
     0.843    14.299     0.150
     0.838    16.029     0.150
     0.844    16.209     0.150
     0.844    28.311     0.150
     0.856    15.750     0.150
     0.856    27.609     0.150
     0.859    16.199     0.150
     0.859    28.600     0.150
     0.866    16.029     0.150
     0.866    27.520     0.150
     0.885    16.240     0.150
     0.880    16.420     0.150
     0.879    16.090     0.150
     0.879    29.459     0.150
     0.887    16.400     0.150
     0.887    28.459     0.150
     0.911    16.730     0.150
     0.929    17.141     0.150
     0.929    29.680     0.150
     0.961    17.500     0.150
     0.961    31.240     0.150
     0.957    17.240     0.150
     0.991    18.141     0.150
     0.991    31.299     0.150
     0.992    18.049     0.150
     0.992    32.189     0.150
     0.992    17.930     0.150
     1.007    18.279     0.150
     1.006    18.109     0.150
     1.006    32.311     0.150
     1.006    18.160     0.150
     1.006    32.561     0.150
     1.025    18.650     0.150
     1.025    32.869     0.150
     1.034    18.279     0.150
     1.034    32.641     0.150
     1.039    18.580     0.150
     1.039    32.879     0.150
     1.049    18.689     0.150
     1.046    19.160     0.150
     1.070    19.039     0.150
     1.070    34.641     0.150
     1.063    18.980     0.150
     1.085    19.100     0.150
     1.085    34.090     0.150
     1.103    19.590     0.150
     1.103    20.289     0.150
     1.131    19.600     0.150
     1.131    35.529     0.150
     1.129    20.090     0.150
     1.153    21.299     0.150
     1.151    20.119     0.150
     1.166    21.250     0.150
     1.163    20.920     0.150
     1.203    20.789     0.150
     1.215    21.230     0.150
     1.215    38.100     0.150
     1.214    21.010     0.150
     1.221    21.859     0.150
     1.459    21.410     0.150
     1.219    21.080     0.150
     1.263    21.641     0.150
     1.266    21.770     0.150
     1.266    39.789     0.150
     1.258    22.299     0.150
     1.269    20.990     0.150
     1.280    21.779     0.150
     1.307    22.410     0.150
     1.333    22.730     0.150
     1.354    23.840     0.150
     1.352    24.039     0.150
     1.377    24.090     0.150
     1.449    26.891     0.150
     1.532    25.699     0.150
     1.534    25.740     0.150
     1.534    48.010     0.150
     1.526    27.570     0.150
     1.575    27.189     0.150
     1.602    26.789     0.150
     1.647    28.891     0.150
     1.681    31.299     0.150
     1.811    29.859     0.150
     2.233    36.750     0.150
     2.400    38.699     0.150
     2.704    43.180     0.150
     2.900    45.600     0.150
     3.073    48.539     0.150
     3.216    49.641     0.150
     3.318    51.721     0.150
     3.786    57.830     0.150
     3.836    60.119     0.150
     3.926    60.260     0.150
     4.237    65.000     0.150
     4.250    65.010     0.150
     4.287    65.061     0.150
     4.287    65.221     0.150
     4.462    67.959     0.150
     4.498    67.910     0.150
     4.728    72.670     0.150
     4.828    73.850     0.150
     4.862    72.660     0.150
     4.940    74.240     0.150
     5.634    88.254     0.150
     5.634   104.061     0.150
     7.101   104.209     0.150
     7.533   114.635     0.150
     7.533   142.188     0.150
     7.533   237.459     0.150
     7.550   110.650     0.150
     7.840   147.355     0.150
    10.691   158.543     0.150
    10.691   342.658     0.150
     0.190     4.000     0.150
     0.190     7.148     0.150
     0.203     8.156     0.150
     0.299     6.320     0.150
     0.299    11.578     0.150
     0.306     6.484     0.150
     0.306    11.461     0.150
     0.307     6.234     0.150
     0.321     7.102     0.150
     0.321    13.016     0.150
     0.322     7.219     0.150
     0.322    13.078     0.150
     0.333     6.984     0.150
     0.346     7.141     0.150
     0.346    12.461     0.150
     0.362     7.875     0.150
     0.362    14.078     0.150
     0.378     7.781     0.150
     0.378    14.484     0.150
     0.379    15.008     0.150
     0.392    13.930     0.150
     0.414    14.586     0.150
     0.408    14.852     0.150
     0.422     8.031     0.150
     0.422     8.328     0.150
     0.422    14.648     0.150
     0.427     8.148     0.150
     0.427    14.078     0.150
     0.430     8.219     0.150
     0.430    14.047     0.150
     0.447     9.508     0.150
     0.447    16.828     0.150
     0.444    14.875     0.150
     0.471     9.070     0.150
     0.471    15.766     0.150
     0.484    17.125     0.150
     0.535    10.430     0.150
     0.544    10.227     0.150
     0.551    11.000     0.150
     0.551    19.734     0.150
     0.541    17.875     0.150
     0.577    20.141     0.150
     0.580    11.750     0.150
     0.580    20.852     0.150
     0.586    11.141     0.150
     0.591    19.945     0.150
     0.589    11.398     0.150
     0.589    19.508     0.150
     0.603    19.961     0.150
     0.622    22.336     0.150
     0.649    23.711     0.150
     0.667    12.328     0.150
     0.667    20.898     0.150
     0.677    12.695     0.150
     0.675    21.875     0.150
     0.677    21.445     0.150
     0.677    21.578     0.150
     0.680    22.039     0.150
     0.680    21.898     0.150
     0.715    13.367     0.150
     0.715    22.828     0.150
     0.718    13.219     0.150
     0.718    22.648     0.150
     0.721    13.797     0.150
     0.721    23.430     0.150
     0.727    24.727     0.150
     0.736    13.930     0.150
     0.743    23.781     0.150
     0.743    14.234     0.150
     0.743    24.234     0.150
     0.744    13.898     0.150
     0.765    24.156     0.150
     0.776    24.852     0.150
     0.804    26.281     0.150
     0.818    15.195     0.150
     0.818    26.969     0.150
     0.814    28.086     0.150
     0.812    15.500     0.150
     0.812    26.109     0.150
     0.833    27.070     0.150
     0.828    15.352     0.150
     0.828    26.148     0.150
     0.839    15.805     0.150
     0.839    27.047     0.150
     0.858    15.719     0.150
     0.858    27.500     0.150
     0.864    28.188     0.150
     0.887    28.938     0.150
     0.884    16.297     0.150
     0.884    27.688     0.150
     0.893    28.266     0.150
     0.893    28.500     0.150
     0.893    16.852     0.150
     0.893    29.102     0.150
     0.893    27.789     0.150
     0.904    28.906     0.150
     0.921    16.984     0.150
     0.918    17.289     0.150
     0.918    29.719     0.150
     0.916    28.867     0.150
     0.952    17.047     0.150
     0.950    17.648     0.150
     0.966    17.828     0.150
     0.976    17.891     0.150
     0.999    18.758     0.150
     1.006    18.266     0.150
     1.024    18.852     0.150
     1.048    19.156     0.150
     1.075    20.297     0.150
     1.079    19.789     0.150
     1.080    19.656     0.150
     1.081    19.984     0.150
     1.100    20.148     0.150
     1.117    20.180     0.150
     1.176    21.031     0.150
     1.261    22.211     0.150
     1.274    22.406     0.150
     1.268    22.805     0.150
     1.301    23.789     0.150
     1.344    24.047     0.150
     1.352    23.156     0.150
     1.352    23.945     0.150
     1.376    23.234     0.150
     1.392    25.758     0.150
     1.609    27.070     0.150
     1.609    27.984     0.150
     1.629    27.555     0.150
     1.688    29.195     0.150
     1.829    30.875     0.150
     1.871    29.984     0.150
     2.090    34.617     0.150
     2.153    36.211     0.150
     2.419    37.508     0.150
     2.424    40.125     0.150
     2.603    40.828     0.150
     2.615    41.422     0.150
     2.652    42.719     0.150
     2.685    42.688     0.150
     2.827    44.266     0.150
     2.886    44.008     0.150
     3.006    47.336     0.150
     3.048    47.156     0.150
     3.155    48.359     0.150
     3.229    49.508     0.150
     3.312    51.047     0.150
     3.343    52.305     0.150
     3.462    53.695     0.150
     3.482    53.758     0.150
     3.747    57.797     0.150
     3.776    58.250     0.150
     3.781    58.336     0.150
     3.869    59.047     0.150
     3.933    60.422     0.150
     3.954    59.172     0.150
     3.996    60.508     0.150
     4.076    61.125     0.150
     4.120    62.180     0.150
     4.132    62.391     0.150
     4.184    62.461     0.150
     4.345    65.734     0.150
     4.383    66.469     0.150
     4.382    65.922     0.150
     4.484    68.211     0.150
     4.505    68.648     0.150
     4.509    69.070     0.150
     4.513    68.477     0.150
     4.560    68.445     0.150
     4.700    70.398     0.150
     4.742    72.688     0.150
     4.796    72.484     0.150
     4.942    75.398     0.150
     5.082    75.867     0.150
     5.091    76.570     0.150
     5.163    77.977     0.150
     5.187    77.758     0.150
     5.209    77.438     0.150
     5.210    79.875     0.150
     5.562    83.555     0.150
     5.585    82.797     0.150
     5.633    84.008     0.150
     5.670    86.219     0.150
     5.670   104.500     0.150
     5.670   178.820     0.150
     5.707    84.852     0.150
     5.808    85.281     0.150
     6.207    92.070     0.150
     6.302    93.578     0.150
     6.451    95.320     0.150
     6.460    94.930     0.150
     6.905   100.867     0.150
     7.372   108.602     0.150
     7.674   114.680     0.150
     7.674   143.375     0.150
     7.674   242.305     0.150
     7.674   112.281     0.150
     7.713   113.711     0.150
     7.794   114.406     0.150
     8.108   121.125     0.150
     8.108   153.570     0.150
     8.108   118.797     0.150
     9.495   137.117     0.150
     9.603   138.875     0.150
    10.910   159.656     0.150
    11.167   161.680     0.150
    15.196   219.523     0.150
    36.921   433.188     0.150
     0.050     1.539     0.150
     0.050     3.668     0.150
     0.052     1.539     0.150
     0.063     1.730     0.150
     0.063     4.418     0.150
     0.110     2.629     0.150
     0.110     6.039     0.150
     0.116     3.039     0.150
     0.116     6.059     0.150
     0.154     3.520     0.150
     0.154     7.160     0.150
     0.228     4.539     0.150
     0.225     5.289     0.150
     0.225    10.141     0.150
     0.232     4.668     0.150
     0.232     8.559     0.150
     0.235     5.410     0.150
     0.235     9.988     0.150
     0.248     5.570     0.150
     0.248    10.328     0.150
     0.264     5.449     0.150
     0.264    10.000     0.150
     0.293     6.508     0.150
     0.309     5.688     0.150
     0.309    10.141     0.150
     0.330     6.969     0.150
     0.330    12.730     0.150
     0.331     6.777     0.150
     0.331    12.289     0.150
     0.365     7.348     0.150
     0.365    12.988     0.150
     0.374     8.180     0.150
     0.374    14.840     0.150
     0.390     7.957     0.150
     0.390    13.758     0.150
     0.433     8.777     0.150
     0.491     9.309     0.150
     0.491    16.328     0.150
     0.483     9.891     0.150
     0.483    17.359     0.150
     0.496    10.020     0.150
     0.496    17.418     0.150
     0.509     9.957     0.150
     0.509    17.301     0.150
     0.516    10.301     0.150
     0.516    19.090     0.150
     0.507    10.008     0.150
     0.507    17.840     0.150
     0.534    10.898     0.150
     0.534    19.301     0.150
     0.539    10.090     0.150
     0.539    17.770     0.150
     0.542    10.539     0.150
     0.542    18.277     0.150
     0.569    11.148     0.150
     0.569    19.777     0.150
     0.569    11.000     0.150
     0.569    19.219     0.150
     0.576    11.277     0.150
     0.576    18.879     0.150
     0.591    10.957     0.150
     0.591    19.141     0.150
     0.588    11.367     0.150
     0.588    20.230     0.150
     0.594    11.430     0.150
     0.594    19.988     0.150
     0.620    11.699     0.150
     0.620    20.230     0.150
     0.623    12.230     0.150
     0.623    21.391     0.150
     0.637    11.867     0.150
     0.637    21.918     0.150
     0.628    12.277     0.150
     0.628    21.359     0.150
     0.648    21.250     0.150
     0.654    12.418     0.150
     0.654    21.539     0.150
     0.658    12.688     0.150
     0.658    22.207     0.150
     0.643    12.520     0.150
     0.643    21.328     0.150
     0.662    12.879     0.150
     0.662    22.289     0.150
     0.688    12.688     0.150
     0.688    23.051     0.150
     0.698    12.648     0.150
     0.698    22.008     0.150
     0.753    14.129     0.150
     0.753    24.848     0.150
     0.762    14.617     0.150
     0.762    25.188     0.150
     0.774    13.469     0.150
     0.771    14.398     0.150
     0.771    24.758     0.150
     0.786    14.020     0.150
     0.786    24.949     0.150
     0.792    14.469     0.150
     0.792    25.309     0.150
     0.795    25.949     0.150
     0.799    14.891     0.150
     0.799    25.719     0.150
     0.801    15.020     0.150
     0.797    15.129     0.150
     0.797    27.277     0.150
     0.811    15.109     0.150
     0.811    27.070     0.150
     0.817    15.109     0.150
     0.824    15.020     0.150
     0.822    26.738     0.150
     0.824    26.867     0.150
     0.824    26.617     0.150
     0.836    15.430     0.150
     0.836    26.957     0.150
     0.846    26.980     0.150
     0.851    15.641     0.150
     0.857    15.750     0.150
     0.871    16.090     0.150
     0.890    16.430     0.150
     0.898    16.238     0.150
     0.911    15.980     0.150
     0.911    28.969     0.150
     0.904    16.707     0.150
     0.905    16.598     0.150
     0.905    29.457     0.150
     0.908    16.609     0.150
     0.908    29.090     0.150
     0.913    16.398     0.150
     0.920    16.840     0.150
     0.920    29.801     0.150
     0.923    17.000     0.150
     0.933    16.988     0.150
     0.937    17.027     0.150
     0.971    17.609     0.150
     0.984    18.438     0.150
     1.003    18.000     0.150
     1.003    31.828     0.150
     1.005    32.270     0.150
     1.005    18.020     0.150
     1.015    17.918     0.150
     1.015    31.758     0.150
     1.023    18.328     0.150
     1.047    18.379     0.150
     1.091    19.117     0.150
     1.102    19.789     0.150
     1.124    20.258     0.150
     1.124    35.078     0.150
     1.184    20.770     0.150
     1.182    20.520     0.150
     1.223    20.188     0.150
     1.224    21.410     0.150
     1.336    23.629     0.150
     1.384    25.469     0.150
     1.513    25.539     0.150
     1.527    26.180     0.150
     1.596    26.777     0.150
     1.628    26.027     0.150
     1.714    31.527     0.150
     1.709    28.449     0.150
     1.745    28.699     0.150
     2.001    32.078     0.150
     2.279    36.359     0.150
     2.433    36.590     0.150
     2.673    40.199     0.150
     2.755    42.559     0.150
     2.795    43.188     0.150
     2.803    51.719     0.150
     2.877    53.801     0.150
     3.117    47.527     0.150
     3.154    47.398     0.150
     3.283    50.180     0.150
     3.384    51.488     0.150
     3.727    56.699     0.150
     3.733    56.598     0.150
     3.834    58.008     0.150
     3.919    58.789     0.150
     4.185    62.199     0.150
     4.262    64.051     0.150
     4.288    65.090     0.150
     4.557    68.801     0.150
     5.703    85.059     0.150
     5.703   106.016     0.150
     5.703   178.707     0.150
     7.600   113.254     0.150
     7.600   239.680     0.150
     7.843   114.672     0.150
     7.843   247.324     0.150
    10.745   155.680     0.150
    10.936   156.031     0.150
    10.936   346.148     0.150
     0.163     7.137     0.150
     0.102     5.477     0.150
     0.170     4.057     0.150
     0.170     7.117     0.150
     0.167     3.877     0.150
     0.167     6.527     0.150
     0.128     3.627     0.150
     0.128     6.097     0.150
     0.128     6.097     0.150
     0.128     3.301     0.150
     0.155     4.177     0.150
     0.155     7.547     0.150
     0.216     4.697     0.150
     0.174     4.517     0.150
     0.174     7.887     0.150
     0.206     7.607     0.150
     0.203     4.737     0.150
     0.203     8.087     0.150
     0.256     9.647     0.150
     0.265     5.727     0.150
     0.265     9.747     0.150
     0.330     6.747     0.150
     0.330    11.477     0.150
     0.330     6.757     0.150
     0.330    11.537     0.150
     0.332     6.777     0.150
     0.332    11.688     0.150
     0.297     6.417     0.150
     0.297    11.007     0.150
     0.283     6.357     0.150
     0.283    11.587     0.150
     0.318     6.497     0.150
     0.319    11.127     0.150
     0.371     7.587     0.150
     0.371    13.117     0.150
     0.405     8.057     0.150
     0.405    13.938     0.150
     0.332     7.137     0.150
     0.332    12.447     0.150
     0.402     7.917     0.150
     0.402    13.797     0.150
     0.345     7.077     0.150
     0.345    12.057     0.150
     0.351     7.747     0.150
     0.351    13.737     0.150
     0.365    12.707     0.150
     0.421    13.987     0.150
     0.340    12.677     0.150
     0.388     8.037     0.150
     0.388    13.897     0.150
     0.364    13.177     0.150
     0.436     8.807     0.150
     0.436    15.197     0.150
     0.425    15.517     0.150
     0.418    14.767     0.150
     0.490     9.297     0.150
     0.490    15.827     0.150
     0.455    15.457     0.150
     0.498     9.397     0.150
     0.498    16.107     0.150
     0.535    10.167     0.150
     0.535    17.167     0.150
     0.457     9.117     0.150
     0.457    15.917     0.150
     0.541    10.367     0.150
     0.541    18.037     0.150
     0.464     9.327     0.150
     0.464    16.287     0.150
     0.515    10.237     0.150
     0.515    17.487     0.150
     0.539    10.047     0.150
     0.539    17.217     0.150
     0.512    16.847     0.150
     0.514     9.977     0.150
     0.514    17.607     0.150
     0.496     9.787     0.150
     0.496    16.987     0.150
     0.513    10.317     0.150
     0.513    17.417     0.150
     0.596    11.077     0.150
     0.596    18.727     0.150
     0.542    11.027     0.150
     0.542    20.037     0.150
     0.579    11.367     0.150
     0.579    19.727     0.150
     0.606    19.427     0.150
     0.637    11.527     0.150
     0.637    19.767     0.150
     0.611    11.857     0.150
     0.611    21.307     0.150
     0.612    11.847     0.150
     0.612    21.277     0.150
     0.578    11.357     0.150
     0.578    19.837     0.150
     0.638    12.377     0.150
     0.638    22.207     0.150
     0.663    12.367     0.150
     0.663    21.137     0.150
     0.636    21.137     0.150
     0.679    12.347     0.150
     0.679    21.147     0.150
     0.670    12.317     0.150
     0.670    21.057     0.150
     0.623    20.767     0.150
     0.644    12.217     0.150
     0.644    20.777     0.150
     0.627    21.137     0.150
     0.637    11.857     0.150
     0.637    20.337     0.150
     0.681    12.417     0.150
     0.681    21.897     0.150
     0.717    13.207     0.150
     0.726    13.327     0.150
     0.726    22.677     0.150
     0.733    23.057     0.150
     0.750    14.117     0.150
     0.750    24.227     0.150
     0.747    23.297     0.150
     0.742    13.347     0.150
     0.698    13.487     0.150
     0.761    13.857     0.150
     0.761    23.627     0.150
     0.748    13.557     0.150
     0.748    23.467     0.150
     0.763    13.637     0.150
     0.763    23.627     0.150
     0.752    13.667     0.150
     0.752    24.337     0.150
     0.743    14.007     0.150
     0.743    24.147     0.150
     0.780    14.067     0.150
     0.780    24.037     0.150
     0.760    13.777     0.150
     0.736    23.887     0.150
     0.726    13.727     0.150
     0.726    24.167     0.150
     0.732    23.777     0.150
     0.758    14.037     0.150
     0.758    24.507     0.150
     0.794    14.737     0.150
     0.794    25.037     0.150
     0.782    14.267     0.150
     0.782    25.037     0.150
     0.820    14.837     0.150
     0.820    25.377     0.150
     0.813    14.747     0.150
     0.813    25.137     0.150
     0.823    14.907     0.150
     0.823    25.197     0.150
     0.823    26.227     0.150
     0.823    25.467     0.150
     0.762    14.317     0.150
     0.762    24.827     0.150
     0.833    15.447     0.150
     0.833    26.167     0.150
     0.811    14.647     0.150
     0.839    15.457     0.150
     0.839    26.417     0.150
     0.780    14.897     0.150
     0.780    26.097     0.150
     0.830    15.297     0.150
     0.830    25.987     0.150
     0.854    26.237     0.150
     0.854    15.207     0.150
     0.854    25.877     0.150
     0.854    27.147     0.150
     0.850    15.207     0.150
     0.850    15.217     0.150
     0.834    15.287     0.150
     0.834    26.727     0.150
     0.830    15.207     0.150
     0.830    26.117     0.150
     0.878    15.877     0.150
     0.878    27.447     0.150
     0.878    27.577     0.150
     0.859    15.507     0.150
     0.873    29.397     0.150
     0.807    15.207     0.150
     0.807    27.337     0.150
     0.888    16.137     0.150
     0.888    27.447     0.150
     0.907    16.327     0.150
     0.917    16.438     0.150
     0.917    28.157     0.150
     0.916    16.567     0.150
     0.916    28.438     0.150
     0.922    16.547     0.150
     0.922    28.347     0.150
     0.922    28.477     0.150
     0.932    17.457     0.150
     0.932    29.697     0.150
     0.881    16.137     0.150
     0.871    16.607     0.150
     0.943    16.447     0.150
     0.943    29.477     0.150
     0.943    29.747     0.150
     0.897    16.377     0.150
     0.897    28.287     0.150
     0.903    16.677     0.150
     0.903    28.897     0.150
     0.963    17.077     0.150
     0.963    29.247     0.150
     0.963    17.287     0.150
     0.896    16.837     0.150
     0.896    29.637     0.150
     0.904    17.057     0.150
     0.904    29.137     0.150
     0.925    16.757     0.150
     0.925    28.847     0.150
     1.097    19.647     0.150
     1.061    19.837     0.150
     1.182    20.947     0.150
     1.182    36.227     0.150
     1.182    21.188     0.150
     1.192    34.877     0.150
     1.258    22.207     0.150
     1.275    21.807     0.150
     1.424    23.237     0.150
     1.434    23.967     0.150
     1.452    24.517     0.150
     1.598    26.157     0.150
     1.627    26.427     0.150
     1.985    32.147     0.150
     2.029    33.097     0.150
     2.160    34.527     0.150
     2.122    34.227     0.150
     2.201    35.357     0.150
     2.237    36.438     0.150
     2.359    35.957     0.150
     2.360    36.367     0.150
     2.432    39.587     0.150
     2.512    39.947     0.150
     2.663    41.647     0.150
     2.966    42.907     0.150
     2.905    44.257     0.150
     2.905    51.667     0.150
     3.169    47.207     0.150
     3.202    49.577     0.150
     3.195    49.637     0.150
     3.416    52.817     0.150
     3.461    53.347     0.150
     4.500    67.627     0.150
     4.544    67.557     0.150
     4.774    72.127     0.150
     4.905    71.507     0.150
     4.932    74.067     0.150
     5.160    78.433     0.150
     5.496    81.617     0.150
     5.582    83.027     0.150
     5.714    84.667     0.150
     5.952    87.707     0.150
     6.648    97.297     0.150
     7.243   105.567     0.150
     7.338   105.757     0.150
     7.311   107.054     0.150
     7.311   135.376     0.150
     7.311   228.183     0.150
     7.740   112.077     0.150
     7.733   112.117     0.150
     8.402   121.366     0.150
     8.402   261.876     0.150
     8.402   120.977     0.150
     8.403   120.847     0.150
     8.909   129.717     0.150
     9.504   134.627     0.150
    10.246   146.577     0.150
    10.734   154.981     0.150
    10.734   199.215     0.150
    10.734   339.763     0.150
    11.315   161.857     0.150
    11.673   166.967     0.150
    11.674   167.107     0.150
    11.674   166.277     0.150
    14.775   214.101     0.150
    22.581   300.757     0.150
    29.052   360.392     0.150
    36.395   425.670     0.150
     0.105     3.688     0.150
     0.140     3.996     0.150
     0.140     6.406     0.150
     0.133     3.906     0.150
     0.133     6.375     0.150
     0.171     4.297     0.150
     0.171     7.367     0.150
     0.197     4.559     0.150
     0.197     7.578     0.150
     0.192     4.918     0.150
     0.192     8.285     0.150
     0.221     5.355     0.150
     0.221     8.875     0.150
     0.258     9.246     0.150
     0.245     5.965     0.150
     0.245    10.246     0.150
     0.269     5.828     0.150
     0.269     9.527     0.150
     0.263     5.957     0.150
     0.263    10.016     0.150
     0.277     6.148     0.150
     0.277    10.406     0.150
     0.300    10.785     0.150
     0.293     6.168     0.150
     0.296     6.066     0.150
     0.296    10.156     0.150
     0.306     6.367     0.150
     0.329     6.918     0.150
     0.331     6.945     0.150
     0.331    11.578     0.150
     0.317     6.906     0.150
     0.317    11.488     0.150
     0.343     7.008     0.150
     0.344     7.105     0.150
     0.344    11.648     0.150
     0.340     7.195     0.150
     0.346    12.188     0.150
     0.375    12.496     0.150
     0.372     7.457     0.150
     0.372    12.578     0.150
     0.385     7.836     0.150
     0.385    13.105     0.150
     0.389     7.867     0.150
     0.389    12.816     0.150
     0.389     7.938     0.150
     0.389    13.105     0.150
     0.386     7.918     0.150
     0.386    13.375     0.150
     0.405     8.125     0.150
     0.405    13.387     0.150
     0.406    13.516     0.150
     0.400     8.016     0.150
     0.400    13.676     0.150
     0.410    13.707     0.150
     0.396     8.367     0.150
     0.396    14.105     0.150
     0.396     8.047     0.150
     0.396    13.668     0.150
     0.427    13.898     0.150
     0.410     8.777     0.150
     0.438     8.809     0.150
     0.438    14.676     0.150
     0.434     8.605     0.150
     0.434    14.457     0.150
     0.451    15.035     0.150
     0.440     8.676     0.150
     0.440    14.656     0.150
     0.463     9.406     0.150
     0.463    15.617     0.150
     0.454     8.695     0.150
     0.454    14.465     0.150
     0.469     9.281     0.150
     0.469    15.285     0.150
     0.470     8.387     0.150
     0.469     9.168     0.150
     0.477     9.168     0.150
     0.477    15.496     0.150
     0.465     9.207     0.150
     0.465    15.637     0.150
     0.482     9.676     0.150
     0.482    16.176     0.150
     0.475     9.465     0.150
     0.475    16.258     0.150
     0.499     9.418     0.150
     0.499    16.117     0.150
     0.511    10.008     0.150
     0.511    16.605     0.150
     0.503     9.668     0.150
     0.503    16.516     0.150
     0.523    10.035     0.150
     0.523    17.285     0.150
     0.527    10.438     0.150
     0.527    17.957     0.150
     0.571    18.078     0.150
     0.577    11.445     0.150
     0.577    18.426     0.150
     0.555    11.375     0.150
     0.555    19.898     0.150
     0.562    10.809     0.150
     0.562    18.465     0.150
     0.571    18.176     0.150
     0.581    11.426     0.150
     0.581    19.355     0.150
     0.575    11.809     0.150
     0.575    20.297     0.150
     0.576    11.348     0.150
     0.576    19.215     0.150
     0.586    11.207     0.150
     0.586    19.426     0.150
     0.605    19.297     0.150
     0.613    11.535     0.150
     0.613    19.527     0.150
     0.625    19.836     0.150
     0.620    11.777     0.150
     0.620    20.246     0.150
     0.645    21.938     0.150
     0.640    12.148     0.150
     0.640    20.586     0.150
     0.657    12.785     0.150
     0.657    21.496     0.150
     0.652    12.078     0.150
     0.652    20.777     0.150
     0.657    21.438     0.150
     0.646    12.316     0.150
     0.646    20.945     0.150
     0.643    12.566     0.150
     0.643    22.637     0.150
     0.650    12.637     0.150
     0.650    21.695     0.150
     0.661    12.605     0.150
     0.665    12.715     0.150
     0.665    22.117     0.150
     0.684    12.957     0.150
     0.684    22.277     0.150
     0.692    12.586     0.150
     0.692    21.809     0.150
     0.709    13.785     0.150
     0.709    23.496     0.150
     0.705    13.648     0.150
     0.705    23.117     0.150
     0.710    23.625     0.150
     0.705    13.926     0.150
     0.705    23.945     0.150
     0.706    13.688     0.150
     0.706    23.457     0.150
     0.716    13.445     0.150
     0.716    22.445     0.150
     0.715    13.398     0.150
     0.731    23.695     0.150
     0.731    13.957     0.150
     0.733    23.605     0.150
     0.738    24.066     0.150
     0.732    23.027     0.150
     0.732    23.566     0.150
     0.743    13.508     0.150
     0.743    23.258     0.150
     0.746    14.508     0.150
     0.750    24.406     0.150
     0.742    14.195     0.150
     0.742    24.758     0.150
     0.768    26.258     0.150
     0.753    23.668     0.150
     0.755    14.117     0.150
     0.755    24.195     0.150
     0.784    25.926     0.150
     0.776    14.605     0.150
     0.787    14.168     0.150
     0.787    24.297     0.150
     0.779    25.625     0.150
     0.789    14.898     0.150
     0.789    25.098     0.150
     0.797    14.945     0.150
     0.797    25.988     0.150
     0.815    14.656     0.150
     0.815    25.215     0.150
     0.816    15.438     0.150
     0.816    26.148     0.150
     0.819    15.578     0.150
     0.819    26.688     0.150
     0.819    15.516     0.150
     0.819    27.008     0.150
     0.831    15.195     0.150
     0.831    26.066     0.150
     0.820    15.195     0.150
     0.820    25.918     0.150
     0.841    27.316     0.150
     0.822    15.547     0.150
     0.822    26.547     0.150
     0.837    27.207     0.150
     0.837    15.496     0.150
     0.852    27.336     0.150
     0.840    26.918     0.150
     0.842    15.738     0.150
     0.851    15.867     0.150
     0.855    16.066     0.150
     0.855    27.648     0.150
     0.854    16.207     0.150
     0.854    27.918     0.150
     0.882    28.738     0.150
     0.871    16.059     0.150
     0.871    27.477     0.150
     0.892    16.656     0.150
     0.873    16.426     0.150
     0.873    29.086     0.150
     0.885    16.766     0.150
     0.885    29.656     0.150
     0.895    16.566     0.150
     0.895    28.367     0.150
     0.918    17.328     0.150
     0.918    30.156     0.150
     0.912    17.098     0.150
     0.912    28.926     0.150
     0.921    17.578     0.150
     0.921    30.926     0.150
     0.981    18.277     0.150
     0.981    31.117     0.150
     1.011    32.215     0.150
     1.048    18.875     0.150
     1.086    19.855     0.150
     1.112    20.598     0.150
     1.264    21.926     0.150
     1.293    23.285     0.150
     1.340    23.566     0.150
     1.482    26.328     0.150
     1.641    26.875     0.150
     1.695    30.516     0.150
     1.778    29.086     0.150
     1.957    33.027     0.150
     2.042    32.809     0.150
     2.068    34.867     0.150
     2.169    36.656     0.150
     2.208    36.777     0.150
     2.308    37.547     0.150
     2.530    41.027     0.150
     2.606    42.125     0.150
     3.064    48.035     0.150
     3.117    49.215     0.150
     5.200    80.051     0.150
     5.200    96.512     0.150
     5.200   162.125     0.150
     5.200    78.406     0.150
     5.899    88.008     0.150
     5.913    87.898     0.150
     6.515    94.516     0.150
     6.687    99.598     0.150
     6.805   101.777     0.150
     7.080   104.715     0.150
     7.105   104.215     0.150
     7.510   111.887     0.150
     7.510   140.160     0.150
     7.510   233.961     0.150
     7.721   112.715     0.150
     7.922   117.445     0.150
     8.127   121.578     0.150
     8.322   120.207     0.150
     8.323   121.168     0.150
     8.819   131.855     0.150
     8.819   275.957     0.150
     9.551   141.773     0.150
     9.551   299.266     0.150
     9.879   142.668     0.150
    11.049   162.090     0.150
    16.218   225.105     0.150
    16.491   229.316     0.150
    18.266   251.258     0.150
    19.849   267.957     0.150
    21.348   284.586     0.150
    23.891   309.809     0.150
    29.207   364.863     0.150
    36.383   426.523     0.150
     0.094     2.641     0.150
     0.094     5.578     0.150
     0.126     3.898     0.150
     0.126     7.500     0.150
     0.126     3.820     0.150
     0.126     6.328     0.150
     0.133     3.625     0.150
     0.133     3.594     0.150
     0.133     6.672     0.150
     0.174     4.305     0.150
     0.174     8.023     0.150
     0.175     4.883     0.150
     0.175     9.391     0.150
     0.181     4.500     0.150
     0.188     4.750     0.150
     0.204     5.414     0.150
     0.235     5.273     0.150
     0.235     7.875     0.150
     0.235     5.070     0.150
     0.235     8.000     0.150
     0.261     5.961     0.150
     0.261    10.039     0.150
     0.266    10.961     0.150
     0.273     6.453     0.150
     0.273     9.125     0.150
     0.297     6.672     0.150
     0.297    12.000     0.150
     0.297     6.055     0.150
     0.316     7.078     0.150
     0.316    11.773     0.150
     0.318     7.469     0.150
     0.322     6.414     0.150
     0.322    10.922     0.150
     0.341    13.188     0.150
     0.359     7.500     0.150
     0.359    14.125     0.150
     0.378     7.852     0.150
     0.378    13.250     0.150
     0.388     7.508     0.150
     0.388    12.930     0.150
     0.420     8.625     0.150
     0.435    14.523     0.150
     0.435    14.625     0.150
     0.435     8.164     0.150
     0.435    14.070     0.150
     0.461     8.828     0.150
     0.461    15.414     0.150
     0.454     9.500     0.150
     0.457     9.688     0.150
     0.457    16.359     0.150
     0.474    17.539     0.150
     0.479     9.961     0.150
     0.479    16.891     0.150
     0.487     9.680     0.150
     0.487     9.531     0.150
     0.487    17.031     0.150
     0.488     9.664     0.150
     0.502    10.008     0.150
     0.528    10.875     0.150
     0.528    19.062     0.150
     0.536    10.469     0.150
     0.536    18.023     0.150
     0.534     9.953     0.150
     0.534    17.594     0.150
     0.567    10.828     0.150
     0.567    18.648     0.150
     0.565    10.805     0.150
     0.565    18.062     0.150
     0.565    10.922     0.150
     0.567    18.148     0.150
     0.567    20.453     0.150
     0.582    11.500     0.150
     0.582    19.555     0.150
     0.598    11.141     0.150
     0.598    19.484     0.150
     0.590    11.781     0.150
     0.590    20.883     0.150
     0.625    11.461     0.150
     0.625    20.242     0.150
     0.631    12.289     0.150
     0.658    12.531     0.150
     0.658    22.109     0.150
     0.678    12.703     0.150
     0.678    23.898     0.150
     0.678    13.141     0.150
     0.671    21.375     0.150
     0.671    12.812     0.150
     0.671    23.242     0.150
     0.722    13.805     0.150
     0.722    23.664     0.150
     0.722    25.453     0.150
     0.723    13.578     0.150
     0.723    25.203     0.150
     0.724    13.805     0.150
     0.733    14.094     0.150
     0.733    23.969     0.150
     0.749    14.188     0.150
     0.749    24.609     0.150
     0.761    14.508     0.150
     0.790    14.742     0.150
     0.790    25.984     0.150
     0.785    14.812     0.150
     0.785    26.109     0.150
     0.793    14.375     0.150
     0.808    14.758     0.150
     0.808    27.172     0.150
     0.811    25.734     0.150
     0.823    15.961     0.150
     0.823    28.453     0.150
     0.830    14.898     0.150
     0.830    26.859     0.150
     0.827    14.602     0.150
     0.827    25.734     0.150
     0.829    15.055     0.150
     0.829    27.055     0.150
     0.858    15.914     0.150
     0.858    28.133     0.150
     0.862    16.203     0.150
     0.862    27.570     0.150
     0.879    15.578     0.150
     0.879    27.828     0.150
     0.891    16.461     0.150
     0.891    28.531     0.150
     0.890    16.320     0.150
     0.890    28.344     0.150
     0.918    16.680     0.150
     0.918    29.234     0.150
     0.926    16.773     0.150
     0.926    29.312     0.150
     0.930    16.750     0.150
     0.930    29.609     0.150
     0.972    17.422     0.150
     0.972    31.375     0.150
     0.981    17.391     0.150
     0.981    30.539     0.150
     0.981    30.859     0.150
     0.985    17.719     0.150
     0.985    30.930     0.150
     0.985    17.664     0.150
     0.999    17.641     0.150
     0.999    30.883     0.150
     1.018    17.711     0.150
     1.018    31.930     0.150
     1.039    17.828     0.150
     1.044    18.133     0.150
     1.044    33.141     0.150
     1.042    18.422     0.150
     1.044    18.273     0.150
     1.061    19.703     0.150
     1.061    33.555     0.150
     1.071    18.875     0.150
     1.071    18.922     0.150
     1.085    19.258     0.150
     1.088    19.234     0.150
     1.088    33.742     0.150
     1.088    34.289     0.150
     1.102    19.492     0.150
     1.109    19.578     0.150
     1.115    19.672     0.150
     1.114    19.414     0.150
     1.114    34.359     0.150
     1.139    20.320     0.150
     1.139    35.469     0.150
     1.147    19.922     0.150
     1.152    20.008     0.150
     1.163    20.969     0.150
     1.174    37.750     0.150
     1.174    20.992     0.150
     1.169    20.734     0.150
     1.169    36.078     0.150
     1.204    21.008     0.150
     1.211    21.031     0.150
     1.211    36.875     0.150
     1.211    20.984     0.150
     1.211    36.883     0.150
     1.223    21.250     0.150
     1.228    21.469     0.150
     1.228    37.250     0.150
     1.228    37.453     0.150
     1.238    21.219     0.150
     1.271    22.000     0.150
     1.298    22.188     0.150
     1.349    22.750     0.150
     1.383    23.383     0.150
     1.383    41.602     0.150
     1.400    23.539     0.150
     1.436    24.023     0.150
     1.442    24.141     0.150
     1.446    45.391     0.150
     1.446    24.164     0.150
     1.453    24.375     0.150
     1.458    24.312     0.150
     1.466    24.461     0.150
     1.485    24.414     0.150
     1.482    24.555     0.150
     1.543    25.648     0.150
     1.541    26.352     0.150
     1.541    46.242     0.150
     1.570    26.258     0.150
     1.637    27.133     0.150
     1.687    29.219     0.150
     1.715    29.078     0.150
     1.752    28.250     0.150
     1.820    30.008     0.150
     1.832    31.055     0.150
     1.915    34.828     0.150
     1.946    33.055     0.150
     2.138    32.758     0.150
     1.988    32.938     0.150
     2.213    33.828     0.150
     2.215    34.523     0.150
     2.336    37.219     0.150
     2.486    37.984     0.150
     2.561    39.828     0.150
     2.601    40.562     0.150
     2.979    44.750     0.150
     3.011    45.312     0.150
     3.031    46.008     0.150
     3.116    46.242     0.150
     3.160    48.094     0.150
     3.156    47.734     0.150
     3.239    48.750     0.150
     3.358    50.438     0.150
     3.371    51.305     0.150
     3.390    52.562     0.150
     3.586    54.859     0.150
     3.705    55.953     0.150
     3.810    57.055     0.150
     3.922    59.273     0.150
     3.977    59.539     0.150
     4.044    59.500     0.150
     4.061    61.523     0.150
     4.093    62.664     0.150
     4.142    62.391     0.150
     4.302    65.102     0.150
     4.337    65.469     0.150
     4.354    64.820     0.150
     4.394    66.859     0.150
     4.683    69.914     0.150
     4.729    69.641     0.150
     5.069    74.602     0.150
     5.128    75.703     0.150
     5.243    77.508     0.150
     5.325    78.484     0.150
     5.455    80.594     0.150
     5.824    84.422     0.150
     5.943    86.281     0.150
     6.200    89.125     0.150
     6.462    93.289     0.150
     7.172   103.141     0.150
     7.224   103.969     0.150
     7.383   105.273     0.150
     7.557   107.812     0.150
     7.604   108.328     0.150
     7.604   109.602     0.150
     7.689   109.523     0.150
     7.728   110.000     0.150
     7.799   116.102     0.150
     7.799   111.625     0.150
     7.811   112.609     0.150
     7.831   112.188     0.150
     8.669   123.961     0.150
    10.769   154.156     0.150
    10.769   340.078     0.150
    37.201   431.531     0.150
     0.086     2.121     0.150
     0.086     3.773     0.150
     0.139     2.984     0.150
     0.139     4.973     0.150
     0.142     3.594     0.150
     0.142     6.301     0.150
     0.188     4.414     0.150
     0.188     7.574     0.150
     0.187     4.434     0.150
     0.187     7.461     0.150
     0.202     3.566     0.150
     0.209     4.344     0.150
     0.209     7.441     0.150
     0.209     4.156     0.150
     0.209     7.508     0.150
     0.209     7.703     0.150
     0.225     4.453     0.150
     0.225     7.551     0.150
     0.248     5.121     0.150
     0.248     8.684     0.150
     0.248     9.004     0.150
     0.226     5.203     0.150
     0.226     9.203     0.150
     0.260     5.262     0.150
     0.260     8.672     0.150
     0.241     4.852     0.150
     0.241     8.164     0.150
     0.247     5.613     0.150
     0.249     5.211     0.150
     0.249     8.852     0.150
     0.290     6.184     0.150
     0.290    10.164     0.150
     0.290     6.102     0.150
     0.290    10.434     0.150
     0.285     6.004     0.150
     0.285    10.184     0.150
     0.320     6.293     0.150
     0.320    11.211     0.150
     0.330     6.723     0.150
     0.330    11.512     0.150
     0.320     6.871     0.150
     0.320    11.801     0.150
     0.342     7.281     0.150
     0.342    12.402     0.150
     0.363     7.344     0.150
     0.363    12.684     0.150
     0.347     7.461     0.150
     0.347    12.434     0.150
     0.344     7.012     0.150
     0.344    12.023     0.150
     0.353     7.422     0.150
     0.353    12.883     0.150
     0.366     7.801     0.150
     0.366    14.004     0.150
     0.385     7.973     0.150
     0.385    13.941     0.150
     0.411     8.633     0.150
     0.411    14.773     0.150
     0.427     8.414     0.150
     0.427    14.391     0.150
     0.397     8.934     0.150
     0.398     7.871     0.150
     0.398    13.602     0.150
     0.399     7.941     0.150
     0.399    13.613     0.150
     0.434     8.621     0.150
     0.411     8.402     0.150
     0.411    14.691     0.150
     0.426     8.582     0.150
     0.418     8.473     0.150
     0.418    14.621     0.150
     0.430     9.113     0.150
     0.430    15.164     0.150
     0.426     8.492     0.150
     0.426    14.473     0.150
     0.432     8.773     0.150
     0.432    14.684     0.150
     0.451     8.883     0.150
     0.451    15.031     0.150
     0.433     8.422     0.150
     0.433    14.621     0.150
     0.457     9.164     0.150
     0.457    15.773     0.150
     0.471     9.211     0.150
     0.471    15.363     0.150
     0.520    10.062     0.150
     0.520    17.262     0.150
     0.533    10.152     0.150
     0.516    10.301     0.150
     0.516    17.434     0.150
     0.525    10.824     0.150
     0.525    18.574     0.150
     0.532    10.492     0.150
     0.532    18.062     0.150
     0.543    10.594     0.150
     0.543    17.891     0.150
     0.567    11.531     0.150
     0.567    19.914     0.150
     0.537    10.633     0.150
     0.537    18.191     0.150
     0.566    11.254     0.150
     0.566    19.523     0.150
     0.552    10.801     0.150
     0.547    10.891     0.150
     0.547    18.863     0.150
     0.557    11.422     0.150
     0.557    19.191     0.150
     0.560    11.043     0.150
     0.560    18.723     0.150
     0.569    11.242     0.150
     0.569    19.273     0.150
     0.582    11.434     0.150
     0.582    19.551     0.150
     0.607    11.461     0.150
     0.607    19.551     0.150
     0.596    11.773     0.150
     0.596    20.422     0.150
     0.635    12.051     0.150
     0.635    21.023     0.150
     0.634    12.023     0.150
     0.634    20.211     0.150
     0.634    20.934     0.150
     0.641    12.031     0.150
     0.641    20.484     0.150
     0.617    12.664     0.150
     0.617    22.484     0.150
     0.622    12.562     0.150
     0.622    21.391     0.150
     0.626    12.414     0.150
     0.664    21.594     0.150
     0.666    12.781     0.150
     0.666    21.633     0.150
     0.643    12.473     0.150
     0.643    21.031     0.150
     0.652    12.602     0.150
     0.652    21.234     0.150
     0.657    12.543     0.150
     0.657    21.344     0.150
     0.664    12.703     0.150
     0.664    21.531     0.150
     0.685    13.023     0.150
     0.685    22.273     0.150
     0.685    13.031     0.150
     0.685    22.273     0.150
     0.660    12.773     0.150
     0.660    21.973     0.150
     0.661    12.891     0.150
     0.661    22.613     0.150
     0.692    13.363     0.150
     0.699    13.484     0.150
     0.699    23.492     0.150
     0.682    12.922     0.150
     0.682    22.371     0.150
     0.703    13.641     0.150
     0.703    23.863     0.150
     0.699    13.184     0.150
     0.699    22.441     0.150
     0.688    13.434     0.150
     0.688    22.344     0.150
     0.707    13.422     0.150
     0.707    22.914     0.150
     0.717    13.523     0.150
     0.717    22.961     0.150
     0.733    14.234     0.150
     0.733    24.191     0.150
     0.703    13.844     0.150
     0.703    24.133     0.150
     0.708    13.801     0.150
     0.708    23.242     0.150
     0.711    13.941     0.150
     0.711    24.242     0.150
     0.747    14.422     0.150
     0.747    26.164     0.150
     0.740    13.762     0.150
     0.740    23.543     0.150
     0.736    23.723     0.150
     0.755    14.242     0.150
     0.747    14.102     0.150
     0.747    24.004     0.150
     0.759    14.223     0.150
     0.759    23.832     0.150
     0.759    24.023     0.150
     0.761    14.121     0.150
     0.761    24.023     0.150
     0.765    14.383     0.150
     0.765    24.484     0.150
     0.753    14.254     0.150
     0.753    24.473     0.150
     0.782    14.902     0.150
     0.782    14.883     0.150
     0.782    26.793     0.150
     0.794    15.004     0.150
     0.794    26.922     0.150
     0.795    14.992     0.150
     0.795    25.344     0.150
     0.773    14.512     0.150
     0.773    25.191     0.150
     0.795    14.992     0.150
     0.790    14.762     0.150
     0.790    25.043     0.150
     0.780    14.871     0.150
     0.780    25.773     0.150
     0.788    14.941     0.150
     0.788    25.531     0.150
     0.787    25.641     0.150
     0.788    15.113     0.150
     0.788    26.062     0.150
     0.808    14.914     0.150
     0.808    25.473     0.150
     0.808    14.922     0.150
     0.808    25.422     0.150
     0.807    15.484     0.150
     0.807    26.453     0.150
     0.815    15.312     0.150
     0.832    15.672     0.150
     0.832    26.422     0.150
     0.814    15.562     0.150
     0.814    26.512     0.150
     0.825    27.312     0.150
     0.815    15.723     0.150
     0.815    26.793     0.150
     0.848    29.051     0.150
     0.853    15.723     0.150
     0.853    26.492     0.150
     0.853    26.762     0.150
     0.842    16.121     0.150
     0.842    27.863     0.150
     0.857    15.781     0.150
     0.857    26.812     0.150
     0.837    16.062     0.150
     0.837    27.902     0.150
     0.869    16.344     0.150
     0.869    29.223     0.150
     0.866    16.184     0.150
     0.866    27.824     0.150
     0.874    15.012     0.150
     0.874    27.512     0.150
     0.875    16.211     0.150
     0.875    27.852     0.150
     0.878    16.312     0.150
     0.878    27.973     0.150
     0.860    28.461     0.150
     0.871    16.461     0.150
     0.871    28.133     0.150
     0.848    28.484     0.150
     0.882    16.703     0.150
     0.887    16.902     0.150
     0.887    28.754     0.150
     0.890    16.801     0.150
     0.890    28.902     0.150
     0.911    16.863     0.150
     0.911    28.574     0.150
     0.928    17.324     0.150
     0.906    30.191     0.150
     0.940    17.613     0.150
     0.961    18.012     0.150
     0.954    19.332     0.150
     0.955    18.324     0.150
     0.962    18.562     0.150
     0.997    18.141     0.150
     0.997    31.082     0.150
     0.972    18.422     0.150
     1.003    18.234     0.150
     0.984    18.863     0.150
     1.007    19.164     0.150
     0.998    19.262     0.150
     1.002    19.102     0.150
     1.048    19.492     0.150
     1.048    33.594     0.150
     1.110    19.324     0.150
     1.110    34.062     0.150
     1.113    20.363     0.150
     1.113    35.414     0.150
     1.117    19.832     0.150
     1.117    35.191     0.150
     1.145    21.672     0.150
     1.288    22.863     0.150
     1.290    23.801     0.150
     1.290    41.641     0.150
     1.353    22.602     0.150
     1.353    39.012     0.150
     1.361    23.004     0.150
     1.361    40.762     0.150
     1.333    24.762     0.150
     1.369    23.184     0.150
     1.369    23.332     0.150
     1.514    25.891     0.150
     1.514    45.902     0.150
     1.493    26.293     0.150
     1.550    27.914     0.150
     1.607    26.961     0.150
     1.667    29.934     0.150
     1.714    28.023     0.150
     1.714    54.762     0.150
     1.763    30.984     0.150
     1.919    32.504     0.150
     2.009    33.273     0.150
     2.077    34.902     0.150
     2.107    36.004     0.150
     2.188    36.262     0.150
     2.205    37.121     0.150
     2.304    35.984     0.150
     2.321    37.801     0.150
     2.444    40.523     0.150
     2.489    40.652     0.150
     2.580    42.262     0.150
     2.596    42.262     0.150
     2.684    42.922     0.150
     2.781    45.133     0.150
     2.884    45.141     0.150
     3.096    46.832     0.150
     3.125    47.062     0.150
     3.256    52.203     0.150
     3.283    52.961     0.150
     3.324    53.414     0.150
     3.358    51.031     0.150
     3.420    53.824     0.150
     3.474    54.781     0.150
     3.479    54.613     0.150
     3.666    58.004     0.150
     3.908    61.113     0.150
     3.996    62.414     0.150
     4.029    62.543     0.150
     4.249    64.824     0.150
     4.246    64.953     0.150
     4.306    66.324     0.150
     4.305    65.863     0.150
     4.430    68.203     0.150
     4.514    67.773     0.150
     4.549    69.621     0.150
     4.575    70.953     0.150
     4.644    71.363     0.150
     4.658    71.742     0.150
     4.746    73.074     0.150
     4.757    71.164     0.150
     4.778    73.973     0.150
     4.790    73.523     0.150
     4.822    74.051     0.150
     4.854    71.961     0.150
     4.854    71.852     0.150
     5.212    79.824     0.150
     5.238    80.754     0.150
     5.243    80.211     0.150
     5.243    96.738     0.150
     5.243   166.012     0.150
     5.243    80.363     0.150
     5.479    82.184     0.150
     5.517    83.621     0.150
     5.780    87.012     0.150
     5.796    88.043     0.150
     5.921    88.133     0.150
     6.060    89.652     0.150
     6.205    91.562     0.150
     6.357    93.391     0.150
     6.451    96.441     0.150
     7.296   106.422     0.150
     7.293   106.684     0.150
     7.383   110.137     0.150
     7.383   138.539     0.150
     7.788   115.891     0.150
     8.385   122.332     0.150
     8.385   122.762     0.150
     8.385   122.992     0.150
     9.459   135.734     0.150
    10.785   156.664     0.150
    11.264   160.551     0.150
    11.617   166.688     0.150
    11.617   365.961     0.150
    11.617   165.723     0.150
    14.852   213.082     0.150
    15.175   214.164     0.150
    15.180   214.484     0.150
    16.017   225.453     0.150
    16.060   225.613     0.150
    16.096   225.891     0.150
    16.151   226.352     0.150
    16.152   227.082     0.150
    16.164   227.762     0.150
    16.234   227.074     0.150
    16.638   233.051     0.150
    16.868   235.242     0.150
    16.937   236.371     0.150
    17.045   237.543     0.150
    17.460   242.824     0.150
    18.304   252.934     0.150
    18.656   257.383     0.150
    18.964   260.773     0.150
    19.414   265.801     0.150
    19.993   272.242     0.150
    20.118   273.621     0.150
    20.905   282.383     0.150
    21.414   287.582     0.150
    21.651   289.641     0.150
    22.129   295.203     0.150
    22.436   298.352     0.150
    22.622   301.438     0.150
    22.622   300.492     0.150
    23.365   307.523     0.150
    23.608   310.262     0.150
    24.739   320.434     0.150
    29.119   360.922     0.150
    29.127   361.812     0.150
    29.127   361.301     0.150
    33.820   401.594     0.150
    35.029   412.781     0.150
    36.299   422.754     0.150
    36.479   426.961     0.150
    36.479   424.984     0.150
    40.464   459.562     0.150
    61.752   622.336     0.150
    78.895   724.012     0.150
    80.689   734.785     0.150
    82.379   743.863     0.150
    90.925   784.371     0.150
    93.727   799.016     0.150
    95.301   804.711     0.150
    98.409   818.824     0.150
   146.922  1184.562     0.150
     0.173     4.425     0.150
     0.173     7.355     0.150
     0.156     4.536     0.150
     0.158     4.016     0.150
     0.158     6.536     0.150
     0.205     8.155     0.150
     0.215     5.585     0.150
     0.215     9.315     0.150
     0.220     5.235     0.150
     0.243     9.005     0.150
     0.232     5.146     0.150
     0.232     8.555     0.150
     0.241     5.325     0.150
     0.241     8.735     0.150
     0.246     9.025     0.150
     0.269     9.655     0.150
     0.316     6.695     0.150
     0.316    11.315     0.150
     0.298    10.295     0.150
     0.286     5.896     0.150
     0.286     5.936     0.150
     0.296     6.295     0.150
     0.296    10.425     0.150
     0.329     7.105     0.150
     0.329    11.996     0.150
     0.299    10.775     0.150
     0.340     7.355     0.150
     0.340    12.305     0.150
     0.342     7.315     0.150
     0.342    12.405     0.150
     0.341     6.755     0.150
     0.341    11.445     0.150
     0.324     6.755     0.150
     0.324    11.095     0.150
     0.346     7.166     0.150
     0.346    11.936     0.150
     0.374     7.845     0.150
     0.374    13.155     0.150
     0.385     8.025     0.150
     0.385    13.565     0.150
     0.391     7.726     0.150
     0.391    13.215     0.150
     0.366    11.985     0.150
     0.371     7.516     0.150
     0.371    12.355     0.150
     0.397     8.055     0.150
     0.397    13.496     0.150
     0.427     8.525     0.150
     0.427    14.286     0.150
     0.394     8.005     0.150
     0.394    13.465     0.150
     0.395     8.045     0.150
     0.429     9.085     0.150
     0.429    14.985     0.150
     0.432     8.925     0.150
     0.432    15.005     0.150
     0.418    15.825     0.150
     0.447     8.735     0.150
     0.447    15.036     0.150
     0.442     9.025     0.150
     0.442    14.976     0.150
     0.439     8.605     0.150
     0.439    14.175     0.150
     0.434    14.505     0.150
     0.444     8.515     0.150
     0.444    14.314     0.150
     0.444    14.396     0.150
     0.444     8.675     0.150
     0.454     9.195     0.150
     0.468     9.315     0.150
     0.468    15.516     0.150
     0.502    16.206     0.150
     0.495     9.735     0.150
     0.495    16.605     0.150
     0.509     9.875     0.150
     0.509    16.925     0.150
     0.511    10.115     0.150
     0.511    16.825     0.150
     0.517     9.775     0.150
     0.517    16.706     0.150
     0.512     9.825     0.150
     0.512    16.405     0.150
     0.528    10.345     0.150
     0.528    17.525     0.150
     0.526    17.045     0.150
     0.542    10.125     0.150
     0.542    17.496     0.150
     0.551    10.405     0.150
     0.551    17.896     0.150
     0.521    16.505     0.150
     0.552    11.396     0.150
     0.552    19.875     0.150
     0.542    11.305     0.150
     0.542    19.215     0.150
     0.532    18.155     0.150
     0.565    10.996     0.150
     0.565    18.825     0.150
     0.531    17.016     0.150
     0.534    10.615     0.150
     0.534    17.845     0.150
     0.558    11.186     0.150
     0.558    19.246     0.150
     0.540    10.325     0.150
     0.540    17.485     0.150
     0.583    11.675     0.150
     0.583    19.875     0.150
     0.598    11.615     0.150
     0.598    19.286     0.150
     0.592    11.575     0.150
     0.592    19.646     0.150
     0.594    11.465     0.150
     0.594    19.375     0.150
     0.611    11.795     0.150
     0.611    19.916     0.150
     0.633    12.896     0.150
     0.633    22.266     0.150
     0.641    12.465     0.150
     0.641    21.405     0.150
     0.628    20.706     0.150
     0.667    12.405     0.150
     0.667    21.436     0.150
     0.650    22.025     0.150
     0.652    12.865     0.150
     0.652    22.065     0.150
     0.662    12.825     0.150
     0.662    21.585     0.150
     0.694    13.335     0.150
     0.694    23.095     0.150
     0.676    22.175     0.150
     0.673    12.666     0.150
     0.673    21.456     0.150
     0.673    21.496     0.150
     0.685    13.695     0.150
     0.685    23.516     0.150
     0.673    12.945     0.150
     0.673    21.575     0.150
     0.699    12.805     0.150
     0.699    21.805     0.150
     0.707    13.505     0.150
     0.707    23.615     0.150
     0.711    11.746     0.150
     0.711    22.536     0.150
     0.682    13.246     0.150
     0.682    22.735     0.150
     0.702    23.305     0.150
     0.688    13.125     0.150
     0.688    22.565     0.150
     0.685    13.166     0.150
     0.685    22.686     0.150
     0.695    22.375     0.150
     0.731    13.686     0.150
     0.731    23.655     0.150
     0.711    22.465     0.150
     0.727    14.166     0.150
     0.727    24.396     0.150
     0.721    23.195     0.150
     0.710    23.315     0.150
     0.739    13.375     0.150
     0.739    22.976     0.150
     0.750    14.235     0.150
     0.750    24.166     0.150
     0.759    25.115     0.150
     0.781    14.135     0.150
     0.751    25.715     0.150
     0.773    14.625     0.150
     0.773    25.396     0.150
     0.770    14.666     0.150
     0.770    24.985     0.150
     0.791    14.266     0.150
     0.791    24.646     0.150
     0.774    14.976     0.150
     0.774    25.175     0.150
     0.774    14.956     0.150
     0.774    25.365     0.150
     0.779    14.505     0.150
     0.779    24.595     0.150
     0.788    14.815     0.150
     0.788    25.655     0.150
     0.790    25.786     0.150
     0.824    15.295     0.150
     0.824    27.005     0.150
     0.813    26.605     0.150
     0.813    15.195     0.150
     0.810    15.445     0.150
     0.810    26.335     0.150
     0.827    15.635     0.150
     0.827    27.545     0.150
     0.821    16.036     0.150
     0.821    27.305     0.150
     0.831    14.815     0.150
     0.831    25.575     0.150
     0.819    15.536     0.150
     0.819    26.325     0.150
     0.828    15.496     0.150
     0.828    26.175     0.150
     0.821    26.605     0.150
     0.820    26.456     0.150
     0.846    28.295     0.150
     0.831    27.625     0.150
     0.861    15.355     0.150
     0.861    26.635     0.150
     0.855    16.055     0.150
     0.855    27.105     0.150
     0.865    15.905     0.150
     0.865    29.175     0.150
     0.859    27.476     0.150
     0.867    16.456     0.150
     0.873    15.815     0.150
     0.873    27.195     0.150
     0.885    16.286     0.150
     0.885    27.305     0.150
     0.885    28.945     0.150
     0.877    16.706     0.150
     0.877    28.485     0.150
     0.869    28.175     0.150
     0.903    17.335     0.150
     0.903    30.726     0.150
     0.894    16.686     0.150
     0.894    28.416     0.150
     0.887    28.246     0.150
     0.894    16.715     0.150
     0.894    28.555     0.150
     0.913    29.845     0.150
     0.942    17.646     0.150
     0.942    30.045     0.150
     0.977    17.365     0.150
     0.977    29.905     0.150
     0.960    31.706     0.150
     1.011    18.396     0.150
     1.011    30.885     0.150
     1.046    19.146     0.150
     1.058    20.516     0.150
     1.058    35.295     0.150
     1.064    19.916     0.150
     1.096    19.605     0.150
     1.096    33.965     0.150
     1.412    44.325     0.150
     1.439    25.465     0.150
     1.453    45.226     0.150
     1.653    28.555     0.150
     1.653    49.726     0.150
     1.679    29.095     0.150
     1.679    50.365     0.150
     1.717    52.905     0.150
     1.705    29.755     0.150
     1.787    29.275     0.150
     1.838    32.005     0.150
     1.858    58.125     0.150
     1.909    32.485     0.150
     1.932    32.166     0.150
     2.033    32.675     0.150
     2.125    35.766     0.150
     2.125    63.085     0.150
     2.213    65.635     0.150
     2.253    36.726     0.150
     2.266    37.405     0.150
     2.310    38.335     0.150
     2.353    37.416     0.150
     2.375    38.615     0.150
     2.559    41.436     0.150
     2.581    42.155     0.150
     2.641    42.555     0.150
     2.720    42.666     0.150
     2.796    45.055     0.150
     2.943    47.996     0.150
     2.943    83.805     0.150
     3.026    48.585     0.150
     5.152    78.920     0.150
     5.152   164.121     0.150
     7.462   111.120     0.150
     7.462   232.496     0.150
     8.809   127.989     0.150
     8.809   276.864     0.150
    11.007   159.715     0.150
    12.026   172.049     0.150
    14.860   212.140     0.150
    21.705   290.525     0.150
    22.881   302.036     0.150
    22.889   303.570     0.150
    23.781   312.666     0.150
    29.159   361.820     0.150
    29.159   361.375     0.150
    36.338   424.896     0.150
    61.469   617.188     0.150
    78.742   721.286     0.150
     0.029     0.637     0.150
     0.029     2.047     0.150
     0.028     0.686     0.150
     0.028     2.236     0.150
     0.083     2.047     0.150
     0.083     4.916     0.150
     0.078     1.936     0.150
     0.078     4.506     0.150
     0.119     2.785     0.150
     0.119     6.096     0.150
     0.164     3.836     0.150
     0.164     7.887     0.150
     0.166     3.525     0.150
     0.166     7.906     0.150
     0.187     4.406     0.150
     0.187     8.887     0.150
     0.206     4.996     0.150
     0.206     9.455     0.150
     0.195     4.625     0.150
     0.195     8.797     0.150
     0.202     4.096     0.150
     0.202     7.576     0.150
     0.302     6.576     0.150
     0.302    12.166     0.150
     0.307     6.086     0.150
     0.307    10.355     0.150
     0.311     6.246     0.150
     0.311    11.066     0.150
     0.319     6.746     0.150
     0.333     7.217     0.150
     0.367     7.785     0.150
     0.366     7.426     0.150
     0.360     7.666     0.150
     0.360    13.547     0.150
     0.416     8.596     0.150
     0.416    15.955     0.150
     0.436     9.195     0.150
     0.443     8.646     0.150
     0.450     9.615     0.150
     0.456     9.596     0.150
     0.480     9.516     0.150
     0.467     8.996     0.150
     0.467    16.086     0.150
     0.499    10.125     0.150
     0.506     9.797     0.150
     0.524    10.387     0.150
     0.524    18.486     0.150
     0.526    10.477     0.150
     0.549    10.695     0.150
     0.549    19.775     0.150
     0.562    10.676     0.150
     0.562    18.666     0.150
     0.558    11.086     0.150
     0.558    20.217     0.150
     0.575    11.477     0.150
     0.575    20.156     0.150
     0.570    10.637     0.150
     0.570    18.535     0.150
     0.586    11.266     0.150
     0.586    19.775     0.150
     0.584    11.506     0.150
     0.600    11.955     0.150
     0.641    12.236     0.150
     0.641    21.836     0.150
     0.643    21.625     0.150
     0.651    12.195     0.150
     0.651    22.396     0.150
     0.656    12.977     0.150
     0.656    22.766     0.150
     0.665    12.775     0.150
     0.665    21.346     0.150
     0.689    12.916     0.150
     0.698    13.137     0.150
     0.698    22.785     0.150
     0.692    13.115     0.150
     0.692    23.756     0.150
     0.715    13.736     0.150
     0.715    24.516     0.150
     0.719    13.717     0.150
     0.722    13.945     0.150
     0.722    23.896     0.150
     0.762    14.656     0.150
     0.762    25.887     0.150
     0.772    13.967     0.150
     0.772    25.516     0.150
     0.777    15.125     0.150
     0.777    27.297     0.150
     0.788    14.625     0.150
     0.788    25.365     0.150
     0.789    14.646     0.150
     0.819    14.307     0.150
     0.820    15.486     0.150
     0.820    27.766     0.150
     0.827    15.387     0.150
     0.825    15.195     0.150
     0.825    26.625     0.150
     0.827    15.381     0.150
     0.827    28.006     0.150
     0.827    27.246     0.150
     0.858    15.955     0.150
     0.858    28.057     0.150
     0.858    16.086     0.150
     0.857    15.875     0.150
     0.857    28.016     0.150
     0.863    16.057     0.150
     0.866    16.125     0.150
     0.879    16.336     0.150
     0.889    16.596     0.150
     0.889    29.656     0.150
     0.889    16.406     0.150
     0.889    29.826     0.150
     0.913    16.516     0.150
     0.913    29.316     0.150
     0.917    17.057     0.150
     0.931    16.785     0.150
     0.923    16.807     0.150
     0.935    16.586     0.150
     0.937    17.666     0.150
     0.943    17.146     0.150
     0.973    17.605     0.150
     0.990    32.186     0.150
     0.999    17.186     0.150
     0.992    18.387     0.150
     1.000    17.705     0.150
     1.008    18.137     0.150
     1.019    18.406     0.150
     1.042    18.516     0.150
     1.042    32.727     0.150
     1.025    19.076     0.150
     1.058    33.217     0.150
     1.050    18.775     0.150
     1.052    19.266     0.150
     1.056    18.967     0.150
     1.062    18.836     0.150
     1.061    18.875     0.150
     1.052    19.166     0.150
     1.069    19.166     0.150
     1.079    19.656     0.150
     1.079    34.846     0.150
     1.092    19.275     0.150
     1.092    34.326     0.150
     1.092    19.307     0.150
     1.092    34.596     0.150
     1.088    19.105     0.150
     1.086    19.436     0.150
     1.145    20.176     0.150
     1.154    36.717     0.150
     1.183    21.057     0.150
     1.183    38.205     0.150
     1.195    20.547     0.150
     1.198    21.156     0.150
     1.209    21.176     0.150
     1.215    21.996     0.150
     1.209    21.285     0.150
     1.222    22.346     0.150
     1.222    37.307     0.150
     1.214    20.355     0.150
     1.214    38.826     0.150
     1.467    21.506     0.150
     1.262    22.396     0.150
     1.259    22.506     0.150
     1.267    22.887     0.150
     1.261    21.887     0.150
     1.273    22.166     0.150
     1.267    22.096     0.150
     1.276    22.096     0.150
     1.307    22.936     0.150
     1.305    25.166     0.150
     1.326    22.756     0.150
     1.325    22.756     0.150
     1.340    22.996     0.150
     1.368    23.285     0.150
     1.368    41.785     0.150
     1.393    23.785     0.150
     1.406    24.846     0.150
     1.407    24.246     0.150
     1.426    24.695     0.150
     1.430    26.875     0.150
     1.443    26.096     0.150
     1.508    25.547     0.150
     1.511    26.146     0.150
     1.533    26.557     0.150
     1.595    27.496     0.150
     1.592    26.926     0.150
     1.593    26.797     0.150
     1.600    27.826     0.150
     1.660    27.756     0.150
     1.667    29.166     0.150
     1.677    28.365     0.150
     1.690    28.855     0.150
     1.695    51.346     0.150
     1.740    29.945     0.150
     1.746    29.506     0.150
     1.786    32.227     0.150
     1.772    29.807     0.150
     1.813    29.855     0.150
     1.875    31.705     0.150
     1.980    32.525     0.150
     2.004    33.146     0.150
     2.287    38.436     0.150
     2.320    37.137     0.150
     2.363    39.346     0.150
     2.366    38.846     0.150
     2.370    38.066     0.150
     2.441    37.307     0.150
     2.661    41.266     0.150
     2.750    43.176     0.150
     2.776    43.186     0.150
     2.851    44.326     0.150
     3.026    47.057     0.150
     3.085    47.426     0.150
     3.104    48.105     0.150
     3.131    48.186     0.150
     3.325    52.115     0.150
     3.609    56.016     0.150
     3.668    56.855     0.150
     3.722    57.346     0.150
     3.712    58.205     0.150
     3.729    57.875     0.150
     3.830    59.365     0.150
     3.865    58.375     0.150
     4.053    61.977     0.150
     4.097    62.486     0.150
     4.153    61.846     0.150
     4.153    61.996     0.150
     4.189    64.217     0.150
     4.188    65.887     0.150
     4.262    65.076     0.150
     4.434    68.346     0.150
     4.466    66.986     0.150
     4.482    68.557     0.150
     4.683    70.666     0.150
     4.707    72.785     0.150
     4.839    74.146     0.150
     4.882    74.176     0.150
     4.910    73.105     0.150
     5.234    76.406     0.150
     5.268    77.547     0.150
     5.432    80.846     0.150
     5.514    81.387     0.150
     5.542    83.236     0.150
     5.571    85.236     0.150
     5.659    84.971     0.150
     5.659   180.486     0.150
     6.200    91.605     0.150
     6.414    96.816     0.150
     6.608    97.436     0.150
     7.053   103.896     0.150
     7.253   106.396     0.150
     7.534   111.910     0.150
     7.534   140.910     0.150
     7.534   237.635     0.150
     7.782   114.529     0.150
     7.782   143.205     0.150
     7.782   242.305     0.150
     8.764   125.336     0.150
    10.215   150.543     0.150
    10.215   321.645     0.150
    10.561   151.336     0.150
    10.668   156.936     0.150
    10.668   200.236     0.150
    10.668   340.861     0.150
    10.912   157.410     0.150
    10.912   345.387     0.150
    14.141   200.455     0.150
    14.180   202.396     0.150
    14.315   202.646     0.150
    14.414   203.846     0.150
    14.476   204.455     0.150
    14.511   204.826     0.150
    14.516   205.227     0.150
    14.732   208.797     0.150
    14.834   207.057     0.150
    14.912   210.086     0.150
    14.988   211.275     0.150
    15.090   213.365     0.150
    15.090   218.029     0.150
    15.343   216.236     0.150
    15.458   217.416     0.150
    15.494   218.406     0.150
    17.074   237.736     0.150
    17.152   238.486     0.150
    17.253   240.756     0.150
    18.168   252.016     0.150
    18.168   251.666     0.150
    18.336   254.266     0.150
    18.336   253.486     0.150
    18.771   257.936     0.150
    18.859   259.605     0.150
    18.940   259.916     0.150
    20.075   272.125     0.150
    20.304   275.266     0.150
    20.359   275.525     0.150
    21.145   285.785     0.150
    22.399   299.686     0.150
    23.562   310.336     0.150
    29.316   363.477     0.150
    34.263   406.977     0.150
    36.627   426.705     0.150
    36.918   431.186     0.150
    38.060   437.316     0.150
    52.084   548.547     0.150
    55.360   574.566     0.150
    59.535   602.445     0.150
    62.361   624.387     0.150
    73.107   690.605     0.150
    73.907   696.236     0.150
    74.256   697.025     0.150
    74.353   696.625     0.150
    76.610   712.379     0.150
    79.345   726.910     0.150
    81.899   738.936     0.150
    83.002   745.486     0.150
    83.802   750.322     0.150
    84.159   752.307     0.150
    85.489   758.557     0.150
    86.772   764.686     0.150
    87.370   765.416     0.150
     0.031     0.602     0.150
     0.033     0.582     0.150
     0.033     2.152     0.150
     0.088     2.012     0.150
     0.088     5.012     0.150
     0.073     1.982     0.150
     0.073     4.543     0.150
     0.124     2.723     0.150
     0.124     6.252     0.150
     0.172     3.912     0.150
     0.172     8.082     0.150
     0.170     3.951     0.150
     0.170     7.951     0.150
     0.183     4.332     0.150
     0.191     4.502     0.150
     0.191     9.303     0.150
     0.208     9.422     0.150
     0.196     4.062     0.150
     0.196     7.652     0.150
     0.307     6.633     0.150
     0.307    12.293     0.150
     0.312     6.172     0.150
     0.312     9.553     0.150
     0.315     6.402     0.150
     0.315    10.992     0.150
     0.319     6.682     0.150
     0.332     7.162     0.150
     0.341     7.043     0.150
     0.341    12.742     0.150
     0.356     7.512     0.150
     0.373     7.932     0.150
     0.373    14.082     0.150
     0.371     7.463     0.150
     0.421     8.723     0.150
     0.442     9.342     0.150
     0.442    16.822     0.150
     0.446     8.713     0.150
     0.446    16.092     0.150
     0.455     9.723     0.150
     0.452     9.572     0.150
     0.480     9.602     0.150
     0.462     9.043     0.150
     0.462    16.281     0.150
     0.496    10.072     0.150
     0.496    17.432     0.150
     0.500     9.812     0.150
     0.500    17.393     0.150
     0.521    10.383     0.150
     0.521    18.293     0.150
     0.527    10.262     0.150
     0.527    18.543     0.150
     0.549    10.793     0.150
     0.549    19.463     0.150
     0.553    10.902     0.150
     0.567    10.582     0.150
     0.567    18.482     0.150
     0.579    11.521     0.150
     0.579    20.252     0.150
     0.573    10.621     0.150
     0.573    18.803     0.150
     0.589    11.281     0.150
     0.589    20.252     0.150
     0.589    11.543     0.150
     0.589    21.021     0.150
     0.596    12.072     0.150
     0.596    21.262     0.150
     0.643    12.201     0.150
     0.643    22.143     0.150
     0.640    11.912     0.150
     0.640    21.701     0.150
     0.654    12.883     0.150
     0.654    22.672     0.150
     0.656    12.611     0.150
     0.656    22.262     0.150
     0.667    12.682     0.150
     0.667    22.242     0.150
     0.688    12.842     0.150
     0.702    13.143     0.150
     0.702    22.963     0.150
     0.696    13.031     0.150
     0.696    24.031     0.150
     0.716    13.871     0.150
     0.716    24.502     0.150
     0.721    13.633     0.150
     0.721    24.592     0.150
     0.726    13.852     0.150
     0.726    24.232     0.150
     0.760    14.312     0.150
     0.760    25.832     0.150
     0.773    15.152     0.150
     0.775    14.062     0.150
     0.775    24.822     0.150
     0.785    14.441     0.150
     0.785    25.383     0.150
     0.784    14.473     0.150
     0.784    26.871     0.150
     0.819    15.432     0.150
     0.819    27.752     0.150
     0.824    15.422     0.150
     0.824    15.232     0.150
     0.822    15.271     0.150
     0.824    14.691     0.150
     0.824    15.477     0.150
     0.824    27.127     0.150
     0.824    27.152     0.150
     0.860    15.902     0.150
     0.860    27.922     0.150
     0.854    15.793     0.150
     0.854    27.982     0.150
     0.863    15.521     0.150
     0.858    16.502     0.150
     0.861    15.771     0.150
     0.861    28.562     0.150
     0.879    16.223     0.150
     0.887    16.531     0.150
     0.887    29.652     0.150
     0.885    16.402     0.150
     0.885    29.762     0.150
     0.914    16.602     0.150
     0.914    29.092     0.150
     0.915    17.072     0.150
     0.920    16.832     0.150
     0.934    30.031     0.150
     0.934    17.383     0.150
     0.940    17.293     0.150
     0.940    16.463     0.150
     0.940    31.312     0.150
     0.972    17.662     0.150
     0.986    18.182     0.150
     0.995    17.682     0.150
     1.004    18.182     0.150
     1.017    18.432     0.150
     1.020    19.262     0.150
     1.044    18.611     0.150
     1.044    32.973     0.150
     1.048    18.812     0.150
     1.050    19.152     0.150
     1.054    19.092     0.150
     1.059    18.861     0.150
     1.058    18.922     0.150
     1.049    19.521     0.150
     1.068    19.252     0.150
     1.093    19.312     0.150
     1.094    19.352     0.150
     1.094    34.812     0.150
     1.083    19.121     0.150
     1.126    20.312     0.150
     1.146    20.201     0.150
     1.156    20.322     0.150
     1.156    36.861     0.150
     1.179    20.922     0.150
     1.200    20.592     0.150
     1.194    21.213     0.150
     1.206    21.252     0.150
     1.205    21.223     0.150
     1.213    21.672     0.150
     1.223    22.133     0.150
     1.223    37.352     0.150
     1.217    20.402     0.150
     1.217    38.762     0.150
     1.473    21.701     0.150
     1.258    22.521     0.150
     1.265    22.021     0.150
     1.259    21.922     0.150
     1.269    23.232     0.150
     1.271    21.973     0.150
     1.263    21.951     0.150
     1.274    21.951     0.150
     1.303    22.803     0.150
     1.301    23.021     0.150
     1.327    22.633     0.150
     1.324    22.621     0.150
     1.339    22.861     0.150
     1.355    23.812     0.150
     1.368    23.352     0.150
     1.391    23.762     0.150
     1.408    24.771     0.150
     1.404    24.213     0.150
     1.422    24.582     0.150
     1.425    26.941     0.150
     1.437    25.232     0.150
     1.506    25.713     0.150
     1.507    25.812     0.150
     1.541    26.432     0.150
     1.590    26.861     0.150
     1.590    27.021     0.150
     1.601    26.652     0.150
     1.634    30.482     0.150
     1.686    28.762     0.150
     1.756    29.682     0.150
     1.818    29.752     0.150
     1.975    32.422     0.150
     2.001    33.021     0.150
     2.429    35.521     0.150
     2.271    36.781     0.150
     2.285    36.912     0.150
     2.360    39.752     0.150
     2.367    37.691     0.150
     2.362    38.383     0.150
     2.445    37.082     0.150
     2.664    41.072     0.150
     2.734    43.121     0.150
     2.746    43.031     0.150
     2.772    43.053     0.150
     2.943    48.072     0.150
     3.023    48.672     0.150
     3.081    48.232     0.150
     3.099    48.043     0.150
     3.127    48.621     0.150
     3.309    52.082     0.150
     3.322    52.742     0.150
     3.646    57.252     0.150
     3.666    56.793     0.150
     3.720    57.633     0.150
     3.708    57.432     0.150
     3.724    59.383     0.150
     3.770    60.252     0.150
     3.827    59.152     0.150
     3.865    59.492     0.150
     3.896    59.072     0.150
     4.047    61.762     0.150
     4.093    61.531     0.150
     4.154    61.502     0.150
     4.154    62.281     0.150
     4.186    64.742     0.150
     4.213    64.973     0.150
     4.258    65.572     0.150
     4.461    67.201     0.150
     4.477    68.701     0.150
     4.702    71.342     0.150
     4.834    73.842     0.150
     4.907    73.982     0.150
     5.268    78.662     0.150
     5.500    81.852     0.150
     5.515    82.031     0.150
     5.538    83.053     0.150
     5.567    85.502     0.150
     5.653    84.242     0.150
     5.654    85.182     0.150
     5.654   104.082     0.150
     5.654   179.383     0.150
     6.609    96.713     0.150
     6.731    99.082     0.150
     7.050   104.152     0.150
     7.323   107.252     0.150
     7.528   111.105     0.150
     7.528   141.182     0.150
     7.528   236.482     0.150
     7.781   113.793     0.150
     7.781   144.150     0.150
     7.781   242.775     0.150
     8.765   126.713     0.150
     8.975   130.252     0.150
    10.178   146.482     0.150
    10.381   149.111     0.150
    10.663   156.432     0.150
    10.663   340.557     0.150
    10.914   156.707     0.150
    10.914   342.832     0.150
    14.137   200.133     0.150
    14.557   206.312     0.150
    15.085   212.912     0.150
    15.085   218.326     0.150
    15.085   213.402     0.150
    15.168   214.441     0.150
    15.344   216.182     0.150
    15.351   216.271     0.150
    15.457   218.152     0.150
    15.477   218.232     0.150
    15.559   219.172     0.150
    15.737   222.213     0.150
    18.335   254.912     0.150
    20.357   277.312     0.150
    21.141   285.602     0.150
    22.395   300.207     0.150
    23.557   311.293     0.150
    29.310   364.521     0.150
    34.266   405.902     0.150
    35.254   415.463     0.150
    36.621   427.031     0.150
    36.912   430.482     0.150
    37.284   432.512     0.150
    59.529   603.422     0.150
    59.576   603.912     0.150
    76.009   708.463     0.150
    78.001   718.303     0.150
    79.339   726.508     0.150
    83.203   747.352     0.150
    86.768   765.521     0.150
    95.502   806.053     0.150
     0.025     0.914     0.150
     0.025     2.604     0.150
     0.030     2.363     0.150
     0.064     1.643     0.150
     0.064     4.322     0.150
     0.100     2.312     0.150
     0.100     4.533     0.150
     0.094     2.283     0.150
     0.094     4.854     0.150
     0.147     3.643     0.150
     0.147     7.424     0.150
     0.147     3.533     0.150
     0.147     7.383     0.150
     0.209     5.203     0.150
     0.209     9.893     0.150
     0.207     4.822     0.150
     0.207     9.254     0.150
     0.215     4.973     0.150
     0.215     9.684     0.150
     0.220     4.463     0.150
     0.220     8.023     0.150
     0.284     6.273     0.150
     0.284     6.273     0.150
     0.299     6.133     0.150
     0.299    10.594     0.150
     0.299     6.133     0.150
     0.299    10.914     0.150
     0.318     6.553     0.150
     0.318    12.312     0.150
     0.328     6.674     0.150
     0.354     7.643     0.150
     0.347     7.424     0.150
     0.347    13.363     0.150
     0.397     8.322     0.150
     0.380     7.902     0.150
     0.420     9.053     0.150
     0.438     8.334     0.150
     0.438     8.674     0.150
     0.488     9.822     0.150
     0.476    10.094     0.150
     0.476    17.643     0.150
     0.505     9.854     0.150
     0.505    18.072     0.150
     0.482     9.053     0.150
     0.482    16.354     0.150
     0.516    10.232     0.150
     0.547    10.312     0.150
     0.547    18.393     0.150
     0.523    10.312     0.150
     0.523    17.863     0.150
     0.565    11.072     0.150
     0.568    11.344     0.150
     0.555    10.363     0.150
     0.555    18.033     0.150
     0.559    11.062     0.150
     0.559    18.354     0.150
     0.559    20.584     0.150
     0.545    10.434     0.150
     0.545    19.143     0.150
     0.577    11.273     0.150
     0.606    11.424     0.150
     0.606    20.023     0.150
     0.632    11.873     0.150
     0.632    22.354     0.150
     0.646    11.604     0.150
     0.646    21.193     0.150
     0.646    11.754     0.150
     0.644    21.854     0.150
     0.652    11.953     0.150
     0.652    21.723     0.150
     0.652    11.553     0.150
     0.652    21.104     0.150
     0.668    12.963     0.150
     0.668    23.014     0.150
     0.674    12.703     0.150
     0.674    22.514     0.150
     0.661    12.164     0.150
     0.661    22.334     0.150
     0.691    13.014     0.150
     0.691    22.652     0.150
     0.713    13.674     0.150
     0.713    23.674     0.150
     0.701    23.453     0.150
     0.701    13.164     0.150
     0.712    13.303     0.150
     0.712    24.062     0.150
     0.723    13.764     0.150
     0.723    24.562     0.150
     0.722    13.803     0.150
     0.755    13.742     0.150
     0.755    24.094     0.150
     0.779    26.402     0.150
     0.796    15.514     0.150
     0.796    27.723     0.150
     0.806    25.793     0.150
     0.808    15.062     0.150
     0.835    16.793     0.150
     0.844    15.604     0.150
     0.842    15.482     0.150
     0.842    27.533     0.150
     0.844    15.723     0.150
     0.844    27.547     0.150
     0.844    27.533     0.150
     0.863    15.873     0.150
     0.863    27.812     0.150
     0.889    16.303     0.150
     0.889    28.463     0.150
     0.889    16.344     0.150
     0.889    28.562     0.150
     0.883    29.303     0.150
     0.883    16.613     0.150
     0.886    16.062     0.150
     0.886    29.414     0.150
     0.916    16.062     0.150
     0.904    16.773     0.150
     0.904    29.863     0.150
     0.905    29.943     0.150
     0.917    16.732     0.150
     0.917    29.193     0.150
     0.929    16.793     0.150
     0.929    30.072     0.150
     0.908    16.793     0.150
     0.985    16.732     0.150
     1.042    18.383     0.150
     1.042    32.254     0.150
     1.042    18.514     0.150
     1.038    18.232     0.150
     1.038    32.344     0.150
     1.037    19.322     0.150
     1.053    19.914     0.150
     1.097    19.273     0.150
     1.097    33.863     0.150
     1.152    20.264     0.150
     1.179    20.303     0.150
     1.197    20.084     0.150
     1.453    21.094     0.150
     1.227    21.523     0.150
     1.228    21.492     0.150
     1.257    22.062     0.150
     1.459    26.053     0.150
     1.566    26.504     0.150
     1.642    30.584     0.150
     1.796    29.543     0.150
     2.021    33.033     0.150
     2.060    34.062     0.150
     2.283    37.434     0.150
     2.294    37.783     0.150
     2.374    38.684     0.150
     2.389    38.443     0.150
     2.613    41.523     0.150
     2.645    40.223     0.150
     2.768    44.023     0.150
     2.768    50.414     0.150
     2.795    43.383     0.150
     3.331    52.273     0.150
     3.655    57.732     0.150
     3.858    59.264     0.150
     4.140    61.344     0.150
     4.190    63.834     0.150
     5.260    78.664     0.150
     5.679    85.047     0.150
     5.679   105.957     0.150
     5.679   182.428     0.150
     5.679    84.934     0.150
     6.598    96.543     0.150
     7.236   106.742     0.150
     7.550   114.701     0.150
     7.550   237.977     0.150
     7.777   114.873     0.150
     7.777   245.172     0.150
     7.777   114.273     0.150
    10.548   151.664     0.150
    10.679   157.711     0.150
    10.898   156.273     0.150
    10.898   345.754     0.150
    14.579   206.072     0.150
    15.108   218.672     0.150
    15.723   227.992     0.150
    17.068   242.543     0.150
    29.333   366.229     0.150
    33.704   401.652     0.150
    36.937   431.756     0.150
     0.052     1.916     0.150
     0.052     3.947     0.150
     0.051     1.746     0.150
     0.051     4.428     0.150
     0.055     1.797     0.150
     0.094     2.566     0.150
     0.094     5.557     0.150
     0.104     2.707     0.150
     0.104     5.848     0.150
     0.104     2.697     0.150
     0.104     5.848     0.150
     0.098     2.527     0.150
     0.098     5.777     0.150
     0.157     3.707     0.150
     0.157     7.678     0.150
     0.228     4.666     0.150
     0.228     7.646     0.150
     0.228     4.678     0.150
     0.228     7.377     0.150
     0.233     4.848     0.150
     0.233     8.527     0.150
     0.237     5.227     0.150
     0.237    10.047     0.150
     0.237     5.227     0.150
     0.237    10.047     0.150
     0.236     5.447     0.150
     0.246    10.127     0.150
     0.286     6.156     0.150
     0.288     6.447     0.150
     0.288    11.496     0.150
     0.272     5.396     0.150
     0.272    10.137     0.150
     0.326     6.938     0.150
     0.326    12.598     0.150
     0.317     6.746     0.150
     0.317    12.406     0.150
     0.318     6.527     0.150
     0.318    11.496     0.150
     0.367     7.428     0.150
     0.367    12.938     0.150
     0.364     7.996     0.150
     0.364    14.268     0.150
     0.362     7.746     0.150
     0.362    14.727     0.150
     0.362     7.758     0.150
     0.362    14.406     0.150
     0.379     8.338     0.150
     0.443     9.066     0.150
     0.484     9.178     0.150
     0.484    16.018     0.150
     0.497    10.088     0.150
     0.497    17.607     0.150
     0.511    10.008     0.150
     0.511    17.348     0.150
     0.496    17.777     0.150
     0.518    10.258     0.150
     0.518    17.916     0.150
     0.514    10.088     0.150
     0.514    18.217     0.150
     0.510     9.816     0.150
     0.510    18.217     0.150
     0.536    10.047     0.150
     0.536    17.627     0.150
     0.523    10.297     0.150
     0.523    19.188     0.150
     0.523    18.467     0.150
     0.547    10.486     0.150
     0.547    18.557     0.150
     0.584    11.307     0.150
     0.584    18.557     0.150
     0.579    11.236     0.150
     0.579    19.896     0.150
     0.577    11.307     0.150
     0.577    20.367     0.150
     0.593    10.807     0.150
     0.593    19.137     0.150
     0.593    20.268     0.150
     0.607    11.537     0.150
     0.607    20.656     0.150
     0.579    10.777     0.150
     0.579    18.787     0.150
     0.600    20.617     0.150
     0.620    11.707     0.150
     0.620    20.197     0.150
     0.640    12.428     0.150
     0.642    12.486     0.150
     0.642    21.518     0.150
     0.642    22.438     0.150
     0.635    12.377     0.150
     0.635    22.217     0.150
     0.624    11.646     0.150
     0.624    21.268     0.150
     0.666    12.787     0.150
     0.666    22.857     0.150
     0.666    12.406     0.150
     0.666    22.027     0.150
     0.672    12.906     0.150
     0.672    22.707     0.150
     0.675    12.438     0.150
     0.675    22.637     0.150
     0.696    12.736     0.150
     0.696    23.598     0.150
     0.687    12.566     0.150
     0.687    22.258     0.150
     0.766    25.207     0.150
     0.775    14.377     0.150
     0.775    24.986     0.150
     0.763    13.406     0.150
     0.764    13.367     0.150
     0.764    24.598     0.150
     0.758    14.566     0.150
     0.758    25.107     0.150
     0.807    15.027     0.150
     0.807    26.348     0.150
     0.774    13.807     0.150
     0.774    24.338     0.150
     0.805    25.928     0.150
     0.814    14.688     0.150
     0.814    14.227     0.150
     0.824    27.607     0.150
     0.837    15.197     0.150
     0.837    15.221     0.150
     0.837    26.855     0.150
     0.847    15.537     0.150
     0.847    26.947     0.150
     0.847    15.566     0.150
     0.847    27.227     0.150
     0.858    15.727     0.150
     0.858    27.197     0.150
     0.861    15.787     0.150
     0.861    27.338     0.150
     0.884    28.707     0.150
     0.899    15.637     0.150
     0.899    29.967     0.150
     0.916    29.977     0.150
     0.910    16.396     0.150
     0.910    29.357     0.150
     0.918    30.076     0.150
     0.926    29.727     0.150
     0.919    16.717     0.150
     0.952    16.098     0.150
     0.977    17.598     0.150
     0.977    30.277     0.150
     0.988    17.527     0.150
     0.988    30.518     0.150
     1.040    18.217     0.150
     1.040    31.717     0.150
     1.034    18.236     0.150
     1.034    31.678     0.150
     1.100    19.367     0.150
     1.120    19.297     0.150
     1.105    19.566     0.150
     1.120    20.387     0.150
     1.186    20.906     0.150
     1.194    20.697     0.150
     1.204    20.967     0.150
     1.204    36.447     0.150
     1.204    38.137     0.150
     1.204    39.018     0.150
     1.210    19.916     0.150
     1.391    22.508     0.150
     1.391    40.396     0.150
     1.606    26.588     0.150
     1.718    28.117     0.150
     1.712    30.088     0.150
     1.841    30.816     0.150
     2.014    32.547     0.150
     2.044    32.678     0.150
     2.350    37.447     0.150
     2.391    38.316     0.150
     2.661    40.178     0.150
     2.768    43.297     0.150
     2.812    43.646     0.150
     2.890    44.707     0.150
     3.155    48.377     0.150
     3.390    52.697     0.150
     3.726    57.098     0.150
     3.900    60.416     0.150
     3.910    58.777     0.150
     4.174    62.268     0.150
     4.292    65.896     0.150
     4.937    74.428     0.150
     5.714    84.752     0.150
     5.714   105.271     0.150
     5.714   179.195     0.150
     7.289   107.197     0.150
     7.608   111.850     0.150
     7.608   141.635     0.150
     7.608   237.727     0.150
     7.835   114.549     0.150
     7.835   144.682     0.150
     7.835   245.205     0.150
    10.580   151.777     0.150
    10.748   156.170     0.150
    10.748   341.469     0.150
    10.748   157.156     0.150
    10.923   156.217     0.150
    10.924   155.996     0.150
    10.924   279.666     0.150
    10.924   343.469     0.150
    10.924   159.406     0.150
    15.160   216.674     0.150
    15.160   214.957     0.150
    29.389   363.363     0.150
    36.972   430.289     0.150
    79.398   727.475     0.150
    82.998   742.777     0.150
     0.005     2.207     0.150
     0.005     3.828     0.150
     0.065     2.738     0.150
     0.065     4.426     0.150
     0.135     3.398     0.150
     0.135     5.648     0.150
     0.179     4.258     0.150
     0.179     7.355     0.150
     0.198     4.445     0.150
     0.198     7.285     0.150
     0.218     4.605     0.150
     0.218     7.727     0.150
     0.241     5.137     0.150
     0.241     8.637     0.150
     0.267     9.285     0.150
     0.279     5.898     0.150
     0.279    10.066     0.150
     0.275     5.527     0.150
     0.275     9.457     0.150
     0.286     5.766     0.150
     0.286     9.809     0.150
     0.282    10.785     0.150
     0.309     6.445     0.150
     0.309    11.027     0.150
     0.331    11.559     0.150
     0.334    11.188     0.150
     0.336     7.047     0.150
     0.336    12.246     0.150
     0.336     6.816     0.150
     0.336    11.695     0.150
     0.342     7.355     0.150
     0.342    13.188     0.150
     0.375     7.547     0.150
     0.375    12.688     0.150
     0.355     7.637     0.150
     0.355    13.336     0.150
     0.401     8.078     0.150
     0.401    13.688     0.150
     0.404     8.047     0.150
     0.404    13.719     0.150
     0.386     7.977     0.150
     0.386    13.797     0.150
     0.390     7.887     0.150
     0.390    13.719     0.150
     0.411     8.035     0.150
     0.411    13.688     0.150
     0.404     8.348     0.150
     0.404    14.328     0.150
     0.430     8.367     0.150
     0.430    14.277     0.150
     0.438     8.875     0.150
     0.438    14.887     0.150
     0.441     8.828     0.150
     0.441    14.648     0.150
     0.444     8.785     0.150
     0.444    14.926     0.150
     0.434     8.758     0.150
     0.434    14.996     0.150
     0.465     9.246     0.150
     0.465    15.559     0.150
     0.453     9.078     0.150
     0.453    15.676     0.150
     0.486     9.277     0.150
     0.486    15.637     0.150
     0.483     9.219     0.150
     0.483    15.598     0.150
     0.476     9.926     0.150
     0.476    17.309     0.150
     0.477     9.238     0.150
     0.477    15.867     0.150
     0.480     9.707     0.150
     0.483     9.738     0.150
     0.483    17.066     0.150
     0.499     9.488     0.150
     0.499    16.148     0.150
     0.510     9.836     0.150
     0.510    16.625     0.150
     0.519    10.219     0.150
     0.519    17.457     0.150
     0.533    10.086     0.150
     0.533    16.898     0.150
     0.556    10.746     0.150
     0.556    18.578     0.150
     0.574    10.887     0.150
     0.574    18.125     0.150
     0.560    10.598     0.150
     0.560    18.176     0.150
     0.568    11.047     0.150
     0.568    18.977     0.150
     0.577    10.855     0.150
     0.578    11.188     0.150
     0.578    19.246     0.150
     0.607    11.625     0.150
     0.607    19.746     0.150
     0.600    19.676     0.150
     0.612    11.418     0.150
     0.612    19.418     0.150
     0.606    11.559     0.150
     0.606    19.887     0.150
     0.598    11.137     0.150
     0.598    19.578     0.150
     0.602    11.387     0.150
     0.611    11.828     0.150
     0.611    20.527     0.150
     0.609    11.656     0.150
     0.609    20.527     0.150
     0.620    11.887     0.150
     0.620    20.188     0.150
     0.616    11.668     0.150
     0.616    21.266     0.150
     0.647    11.887     0.150
     0.647    20.367     0.150
     0.645    12.367     0.150
     0.645    21.047     0.150
     0.656    12.195     0.150
     0.656    20.605     0.150
     0.652    12.266     0.150
     0.652    20.766     0.150
     0.660    12.418     0.150
     0.660    20.969     0.150
     0.663    12.695     0.150
     0.656    12.457     0.150
     0.656    22.758     0.150
     0.654    12.238     0.150
     0.654    21.125     0.150
     0.673    12.656     0.150
     0.673    21.445     0.150
     0.675    12.938     0.150
     0.675    22.125     0.150
     0.682    12.906     0.150
     0.682    21.688     0.150
     0.690    12.898     0.150
     0.690    23.746     0.150
     0.706    13.848     0.150
     0.706    24.777     0.150
     0.716    13.496     0.150
     0.716    22.918     0.150
     0.704    13.316     0.150
     0.704    22.668     0.150
     0.704    13.098     0.150
     0.725    13.297     0.150
     0.725    22.676     0.150
     0.729    13.387     0.150
     0.729    22.758     0.150
     0.732    13.457     0.150
     0.732    23.016     0.150
     0.741    13.527     0.150
     0.741    23.098     0.150
     0.738    13.766     0.150
     0.738    23.277     0.150
     0.728    13.758     0.150
     0.728    23.707     0.150
     0.734    13.656     0.150
     0.734    23.398     0.150
     0.751    13.797     0.150
     0.751    23.316     0.150
     0.762    13.957     0.150
     0.762    23.707     0.150
     0.768    14.047     0.150
     0.768    23.785     0.150
     0.778    14.516     0.150
     0.778    25.016     0.150
     0.768    14.016     0.150
     0.768    24.438     0.150
     0.789    15.047     0.150
     0.789    25.617     0.150
     0.787    14.945     0.150
     0.787    25.738     0.150
     0.787    13.977     0.150
     0.787    24.605     0.150
     0.800    14.547     0.150
     0.800    24.816     0.150
     0.802    24.945     0.150
     0.800    14.926     0.150
     0.800    25.375     0.150
     0.790    14.836     0.150
     0.790    25.848     0.150
     0.826    14.957     0.150
     0.826    25.508     0.150
     0.835    15.707     0.150
     0.835    25.969     0.150
     0.846    15.598     0.150
     0.846    26.457     0.150
     0.832    15.246     0.150
     0.832    15.566     0.150
     0.832    26.926     0.150
     0.853    15.398     0.150
     0.853    26.656     0.150
     0.854    15.637     0.150
     0.854    26.516     0.150
     0.867    15.047     0.150
     0.899    16.188     0.150
     0.899    27.969     0.150
     0.898    16.648     0.150
     0.898    28.535     0.150
     0.905    28.168     0.150
     0.894    16.828     0.150
     0.894    28.766     0.150
     0.885    16.477     0.150
     0.885    28.195     0.150
     0.909    16.355     0.150
     0.909    28.207     0.150
     0.905    28.285     0.150
     0.913    16.988     0.150
     0.921    16.688     0.150
     0.921    28.125     0.150
     0.926    17.477     0.150
     0.924    17.176     0.150
     0.923    17.367     0.150
     0.950    17.535     0.150
     0.977    17.605     0.150
     0.977    30.277     0.150
     0.981    17.918     0.150
     1.051    19.297     0.150
     1.066    20.047     0.150
     1.097    19.855     0.150
     1.199    20.648     0.150
     1.199    35.945     0.150
     1.248    21.285     0.150
     1.248    38.355     0.150
     1.280    21.168     0.150
     1.280    36.617     0.150
     1.300    23.898     0.150
     1.300    38.777     0.150
     1.319    22.738     0.150
     1.319    40.875     0.150
     1.422    25.176     0.150
     1.422    43.195     0.150
     1.482    25.855     0.150
     1.537    25.047     0.150
     1.759    30.078     0.150
     1.779    29.469     0.150
     1.824    30.438     0.150
     1.816    28.438     0.150
     1.835    30.496     0.150
     1.978    32.168     0.150
     2.030    32.598     0.150
     2.194    35.496     0.150
     2.202    34.656     0.150
     2.215    34.336     0.150
     2.284    35.945     0.150
     2.323    37.328     0.150
     2.362    38.535     0.150
     2.394    40.207     0.150
     2.516    41.438     0.150
     2.597    42.906     0.150
     2.718    43.488     0.150
     2.906    46.438     0.150
     3.113    49.367     0.150
     3.126    49.855     0.150
     3.270    50.766     0.150
     3.367    53.207     0.150
     3.394    53.367     0.150
     3.428    52.535     0.150
     3.423    53.035     0.150
     3.527    54.027     0.150
     3.570    55.746     0.150
     3.574    54.566     0.150
     3.925    59.938     0.150
     3.986    60.535     0.150
     3.988    60.219     0.150
     4.001    60.535     0.150
     4.087    62.125     0.150
     4.180    63.836     0.150
     4.292    65.547     0.150
     4.335    66.086     0.150
     4.395    66.559     0.150
     4.626    69.945     0.150
     4.664    70.668     0.150
     4.756    69.176     0.150
     4.766    69.566     0.150
     4.836    73.816     0.150
     4.922    74.527     0.150
     5.036    75.617     0.150
     5.190    77.688     0.150
     5.265    78.438     0.150
     5.305    79.516     0.150
     5.317    80.496     0.150
     5.631    83.828     0.150
     5.718    86.309     0.150
     5.893    87.766     0.150
     6.128    90.227     0.150
     6.120    89.336     0.150
     6.201    91.227     0.150
     6.579    97.797     0.150
     7.089   103.316     0.150
     7.206   105.988     0.150
     7.367   107.758     0.150
     7.393   109.168     0.150
     7.512   110.488     0.150
     7.632   111.336     0.150
     7.731   112.406     0.150
     7.753   112.828     0.150
     7.767   112.188     0.150
     7.787   113.285     0.150
     7.794   113.508     0.150
     7.897   115.027     0.150
     7.884   116.168     0.150
     7.926   115.926     0.150
     8.060   117.766     0.150
     8.314   120.746     0.150
     8.871   129.828     0.150
     9.372   134.617     0.150
     9.983   143.477     0.150
    10.026   144.078     0.150
    10.354   147.969     0.150
    10.787   153.477     0.150
     0.059     2.246     0.150
     0.040     3.785     0.150
     0.100     3.215     0.150
     0.118     2.965     0.150
     0.124     3.215     0.150
     0.124     6.445     0.150
     0.157     4.348     0.150
     0.181     4.895     0.150
     0.162     4.156     0.150
     0.174     4.426     0.150
     0.174     7.996     0.150
     0.195     4.445     0.150
     0.195     8.516     0.150
     0.185     4.598     0.150
     0.185     8.746     0.150
     0.193     4.855     0.150
     0.193     9.285     0.150
     0.209     8.336     0.150
     0.242     5.777     0.150
     0.242     9.336     0.150
     0.249     5.816     0.150
     0.249     8.586     0.150
     0.287    12.246     0.150
     0.337     7.188     0.150
     0.337    13.227     0.150
     0.322     7.035     0.150
     0.322    12.707     0.150
     0.326     6.438     0.150
     0.326    11.238     0.150
     0.356     7.316     0.150
     0.356    12.707     0.150
     0.368     7.375     0.150
     0.368    13.387     0.150
     0.404     7.688     0.150
     0.448     9.238     0.150
     0.448    16.758     0.150
     0.428     8.266     0.150
     0.428    14.035     0.150
     0.439     9.156     0.150
     0.439    15.715     0.150
     0.465     8.988     0.150
     0.451     8.996     0.150
     0.484     8.996     0.150
     0.484    16.047     0.150
     0.483     9.547     0.150
     0.483    16.496     0.150
     0.497    10.137     0.150
     0.497    18.207     0.150
     0.517     9.996     0.150
     0.560    11.316     0.150
     0.553    10.746     0.150
     0.553    18.496     0.150
     0.560    10.766     0.150
     0.560    20.195     0.150
     0.603    11.805     0.150
     0.603    21.016     0.150
     0.618    11.438     0.150
     0.618    19.438     0.150
     0.617    11.738     0.150
     0.617    22.258     0.150
     0.641    12.348     0.150
     0.641    22.277     0.150
     0.652    11.637     0.150
     0.652    20.855     0.150
     0.701    13.586     0.150
     0.701    23.906     0.150
     0.717    13.516     0.150
     0.709    13.438     0.150
     0.709    24.867     0.150
     0.723    13.586     0.150
     0.723    24.016     0.150
     0.744    14.285     0.150
     0.758    14.328     0.150
     0.768    14.426     0.150
     0.762    13.875     0.150
     0.750    14.117     0.150
     0.752    13.805     0.150
     0.752    26.047     0.150
     0.782    14.355     0.150
     0.782    25.117     0.150
     0.785    14.477     0.150
     0.801    15.008     0.150
     0.801    26.598     0.150
     0.825    15.746     0.150
     0.825    26.695     0.150
     0.831    15.535     0.150
     0.831    26.988     0.150
     0.848    15.156     0.150
     0.848    27.418     0.150
     0.841    15.555     0.150
     0.841    26.727     0.150
     0.835    14.688     0.150
     0.835    26.086     0.150
     0.861    15.676     0.150
     0.861    28.477     0.150
     0.890    16.266     0.150
     0.906    16.457     0.150
     0.906    28.625     0.150
     0.956    17.387     0.150
     0.940    16.848     0.150
     0.979    30.598     0.150
     0.979    17.445     0.150
     1.013    17.578     0.150
     1.013    17.637     0.150
     1.013    31.809     0.150
     1.068    18.066     0.150
     1.121    19.855     0.150
     1.128    20.645     0.150
     1.170    20.527     0.150
     1.179    22.078     0.150
     1.259    22.105     0.150
     1.320    22.598     0.150
     1.427    24.477     0.150
     1.512    24.848     0.150
     1.700    27.555     0.150
     1.722    28.316     0.150
     1.797    29.867     0.150
     1.808    30.348     0.150
     1.980    32.297     0.150
     2.243    37.066     0.150
     2.516    38.875     0.150
     2.537    42.797     0.150
     2.559    40.535     0.150
     2.574    43.105     0.150
     3.165    49.238     0.150
     3.570    56.195     0.150
     3.730    58.445     0.150
     3.811    59.406     0.150
     3.951    61.125     0.150
     4.071    60.656     0.150
     4.394    67.938     0.150
     4.481    68.426     0.150
     4.642    70.848     0.150
     4.719    71.297     0.150
     4.832    73.555     0.150
     4.928    74.457     0.150
     5.264    78.496     0.150
     5.458    80.465     0.150
     5.916    87.266     0.150
     5.916   109.664     0.150
     6.557    95.875     0.150
     7.793   114.965     0.150
     7.793   147.742     0.150
     7.793   245.164     0.150
     7.817   114.059     0.150
     7.817   144.711     0.150
     7.817   245.684     0.150
     8.695   124.695     0.150
    10.798   154.465     0.150
    10.798   340.168     0.150
    10.889   159.574     0.150
     1.013    18.098     0.150
     0.120     3.059     0.150
     0.124     3.250     0.150
     0.124     6.457     0.150
     0.098     3.348     0.150
     0.098     6.590     0.150
     0.163     4.188     0.150
     0.163     8.156     0.150
     0.178     4.578     0.150
     0.178     8.090     0.150
     0.154     8.699     0.150
     0.154     4.387     0.150
     0.189     4.680     0.150
     0.189     8.859     0.150
     0.196     8.789     0.150
     0.192     4.488     0.150
     0.192     8.348     0.150
     0.179     4.988     0.150
     0.179     9.598     0.150
     0.212     7.527     0.150
     0.240     5.637     0.150
     0.240    10.148     0.150
     0.246     5.758     0.150
     0.246     8.527     0.150
     0.288    11.406     0.150
     0.324     7.117     0.150
     0.324    12.816     0.150
     0.330     6.566     0.150
     0.330    11.340     0.150
     0.335     7.156     0.150
     0.359     7.438     0.150
     0.359    12.840     0.150
     0.367     7.500     0.150
     0.367    13.758     0.150
     0.407     7.828     0.150
     0.407    13.988     0.150
     0.432     8.367     0.150
     0.432    13.969     0.150
     0.442     9.316     0.150
     0.442    15.930     0.150
     0.450     8.930     0.150
     0.436     9.078     0.150
     0.446     9.219     0.150
     0.446    17.379     0.150
     0.463     9.098     0.150
     0.481     9.078     0.150
     0.481    15.898     0.150
     0.486     9.727     0.150
     0.486    16.719     0.150
     0.516    10.000     0.150
     0.516    18.258     0.150
     0.497    10.398     0.150
     0.497    18.090     0.150
     0.562    10.789     0.150
     0.562    19.609     0.150
     0.556    10.809     0.150
     0.556    18.078     0.150
     0.562    11.387     0.150
     0.602    11.789     0.150
     0.602    20.566     0.150
     0.615    11.430     0.150
     0.615    19.367     0.150
     0.635    12.168     0.150
     0.635    21.438     0.150
     0.650    11.750     0.150
     0.650    20.578     0.150
     0.642    12.328     0.150
     0.642    22.328     0.150
     0.709    13.238     0.150
     0.709    24.738     0.150
     0.695    13.477     0.150
     0.700    24.047     0.150
     0.726    13.738     0.150
     0.726    24.477     0.150
     0.714    13.758     0.150
     0.714    23.816     0.150
     0.751    25.637     0.150
     0.753    26.207     0.150
     0.748    23.957     0.150
     0.763    13.977     0.150
     0.763    24.020     0.150
     0.766    14.379     0.150
     0.786    14.379     0.150
     0.786    25.289     0.150
     0.780    14.258     0.150
     0.780    25.809     0.150
     0.798    14.539     0.150
     0.798    25.500     0.150
     0.800    14.719     0.150
     0.800    26.508     0.150
     0.837    14.867     0.150
     0.837    26.277     0.150
     0.834    15.469     0.150
     0.834    27.316     0.150
     0.822    15.859     0.150
     0.822    27.738     0.150
     0.844    15.648     0.150
     0.844    26.988     0.150
     0.832    15.918     0.150
     0.848    15.188     0.150
     0.892    16.348     0.150
     0.921    30.859     0.150
     0.908    16.500     0.150
     0.908    28.629     0.150
     0.944    16.977     0.150
     0.935    16.887     0.150
     0.935    30.707     0.150
     0.957    17.359     0.150
     0.982    17.590     0.150
     0.982    30.066     0.150
     0.982    31.020     0.150
     0.988    17.297     0.150
     1.013    17.637     0.150
     1.044    18.547     0.150
     1.044    32.668     0.150
     1.040    18.508     0.150
     1.041    18.488     0.150
     1.067    18.047     0.150
     1.067    32.367     0.150
     1.057    18.797     0.150
     1.087    19.277     0.150
     1.087    34.199     0.150
     1.079    19.180     0.150
     1.093    19.188     0.150
     1.093    33.559     0.150
     1.099    19.539     0.150
     1.132    20.387     0.150
     1.132    35.457     0.150
     1.110    20.289     0.150
     1.121    19.547     0.150
     1.119    19.547     0.150
     1.172    20.219     0.150
     1.173    20.406     0.150
     1.175    20.637     0.150
     1.175    20.219     0.150
     1.175    36.238     0.150
     1.175    37.840     0.150
     1.192    20.809     0.150
     1.192    36.250     0.150
     1.194    20.828     0.150
     1.212    21.328     0.150
     1.212    37.098     0.150
     1.207    20.840     0.150
     1.227    21.258     0.150
     1.240    21.250     0.150
     1.240    21.316     0.150
     1.262    24.387     0.150
     1.256    21.719     0.150
     1.321    22.500     0.150
     1.324    24.098     0.150
     1.343    23.227     0.150
     1.359    23.066     0.150
     1.370    23.129     0.150
     1.409    23.656     0.150
     1.412    23.848     0.150
     1.427    24.039     0.150
     1.436    24.039     0.150
     1.446    27.617     0.150
     1.454    24.207     0.150
     1.510    24.590     0.150
     1.527    27.508     0.150
     1.528    26.508     0.150
     1.561    27.719     0.150
     1.543    25.668     0.150
     1.657    28.688     0.150
     1.703    30.090     0.150
     1.691    31.457     0.150
     1.700    28.008     0.150
     1.723    28.066     0.150
     1.792    29.637     0.150
     1.793    29.527     0.150
     1.806    29.816     0.150
     1.919    29.066     0.150
     1.918    32.238     0.150
     1.976    32.117     0.150
     2.184    35.027     0.150
     2.244    34.316     0.150
     2.241    35.477     0.150
     2.377    41.719     0.150
     2.515    38.137     0.150
     2.519    40.309     0.150
     2.524    39.250     0.150
     2.534    39.656     0.150
     2.555    40.418     0.150
     2.573    41.406     0.150
     2.572    41.027     0.150
     2.573    40.777     0.150
     2.948    46.438     0.150
     2.982    47.039     0.150
     3.000    46.527     0.150
     3.009    47.438     0.150
     3.086    47.848     0.150
     3.125    48.406     0.150
     3.161    48.867     0.150
     3.341    51.930     0.150
     3.476    54.137     0.150
     3.567    54.949     0.150
     3.636    55.988     0.150
     3.726    56.699     0.150
     3.807    58.027     0.150
     3.869    58.918     0.150
     3.914    60.000     0.150
     3.947    59.699     0.150
     3.941    59.539     0.150
     3.990    60.340     0.150
     4.069    60.039     0.150
     4.063    60.277     0.150
     4.111    61.188     0.150
     4.274    63.520     0.150
     4.390    66.758     0.150
     4.471    67.387     0.150
     4.477    67.840     0.150
     4.542    67.457     0.150
     4.567    69.477     0.150
     4.638    70.078     0.150
     4.693    70.250     0.150
     4.697    71.816     0.150
     4.715    71.027     0.150
     4.828    73.379     0.150
     4.828    72.957     0.150
     4.849    72.988     0.150
     4.925    73.848     0.150
     5.058    76.277     0.150
     5.097    75.816     0.150
     5.159    76.457     0.150
     5.213    78.906     0.150
     5.261    77.867     0.150
     5.291    78.906     0.150
     5.298    78.359     0.150
     5.416    81.047     0.150
     5.424    81.949     0.150
     5.455    80.297     0.150
     5.481    82.270     0.150
     5.540    81.207     0.150
     5.633    84.148     0.150
     5.745    85.969     0.150
     5.770    86.059     0.150
     5.778    87.918     0.150
     5.794    88.957     0.150
     5.817    87.867     0.150
     5.873    89.227     0.150
     5.915    91.719     0.150
     5.915   188.352     0.150
     5.915    89.918     0.150
     6.027    91.027     0.150
     6.034    90.418     0.150
     6.341    94.637     0.150
     6.431    96.629     0.150
     6.435    95.699     0.150
     6.554    95.438     0.150
     6.645    97.957     0.150
     6.649    98.039     0.150
     6.801    99.887     0.150
     6.937   103.617     0.150
     6.985   102.797     0.150
     7.068   104.227     0.150
     7.142   105.398     0.150
     7.243   105.578     0.150
     7.246   107.547     0.150
     7.301   107.398     0.150
     7.340   110.848     0.150
     7.376   108.750     0.150
     7.435   109.527     0.150
     7.535   111.207     0.150
     7.563   112.789     0.150
     7.585   112.457     0.150
     7.589   113.828     0.150
     7.594   112.898     0.150
     7.603   114.199     0.150
     7.620   113.137     0.150
     7.645   113.137     0.150
     7.665   112.816     0.150
     7.673   112.457     0.150
     7.690   114.219     0.150
     7.790   114.520     0.150
     7.814   114.469     0.150
     7.814   115.207     0.150
     7.924   117.539     0.150
     8.342   123.090     0.150
     8.619   126.688     0.150
     8.715   127.617     0.150
    10.797   154.504     0.150
    10.797   338.629     0.150
    10.885   160.027     0.150
    11.767   167.918     0.150
     0.035     3.117     0.150
     0.065     2.188     0.150
     0.104     3.250     0.150
     0.104     6.602     0.150
     0.125     3.117     0.150
     0.125     6.641     0.150
     0.160     4.039     0.150
     0.169     4.281     0.150
     0.169     7.938     0.150
     0.180     4.398     0.150
     0.188     4.508     0.150
     0.162     8.859     0.150
     0.162     4.406     0.150
     0.185     4.992     0.150
     0.206     4.578     0.150
     0.206     7.641     0.150
     0.199     8.500     0.150
     0.245     5.852     0.150
     0.245    10.219     0.150
     0.252     5.750     0.150
     0.287    11.789     0.150
     0.320     6.258     0.150
     0.320    11.227     0.150
     0.318     7.117     0.150
     0.352     7.227     0.150
     0.352    12.578     0.150
     0.342     7.242     0.150
     0.342    13.328     0.150
     0.371     7.469     0.150
     0.371    14.039     0.150
     0.399     7.438     0.150
     0.399    13.867     0.150
     0.423     8.312     0.150
     0.423    13.633     0.150
     0.434     9.039     0.150
     0.434    15.648     0.150
     0.441     9.031     0.150
     0.452     9.070     0.150
     0.452    16.477     0.150
     0.451    17.180     0.150
     0.478     9.562     0.150
     0.478    16.469     0.150
     0.469     9.117     0.150
     0.469    16.219     0.150
     0.488     9.102     0.150
     0.488    16.297     0.150
     0.498    10.148     0.150
     0.498    18.148     0.150
     0.519    10.008     0.150
     0.519    18.641     0.150
     0.547    10.570     0.150
     0.547    18.570     0.150
     0.557    11.078     0.150
     0.559    11.266     0.150
     0.559    19.883     0.150
     0.606    21.047     0.150
     0.629    12.039     0.150
     0.629    20.539     0.150
     0.623    19.438     0.150
     0.623    11.469     0.150
     0.623    20.008     0.150
     0.640    12.562     0.150
     0.640    22.172     0.150
     0.655    11.758     0.150
     0.655    20.883     0.150
     0.708    13.477     0.150
     0.698    24.102     0.150
     0.720    13.742     0.150
     0.720    24.180     0.150
     0.739    14.148     0.150
     0.739    24.102     0.150
     0.721    13.742     0.150
     0.721    24.062     0.150
     0.747    14.062     0.150
     0.751    14.297     0.150
     0.755    25.109     0.150
     0.762    13.930     0.150
     0.762    25.109     0.150
     0.784    14.703     0.150
     0.784    26.727     0.150
     0.773    14.516     0.150
     0.773    25.367     0.150
     0.795    14.359     0.150
     0.795    26.000     0.150
     0.785    14.656     0.150
     0.785    25.492     0.150
     0.804    14.859     0.150
     0.804    26.062     0.150
     0.827    15.578     0.150
     0.827    27.016     0.150
     0.832    14.758     0.150
     0.832    26.078     0.150
     0.836    15.727     0.150
     0.836    26.898     0.150
     0.835    15.656     0.150
     0.831    16.078     0.150
     0.831    26.883     0.150
     0.849    27.328     0.150
     0.887    16.547     0.150
     0.887    28.211     0.150
     0.902    16.516     0.150
     0.902    28.711     0.150
     0.936    16.820     0.150
     0.936    29.008     0.150
     0.935    16.969     0.150
     0.953    17.422     0.150
     0.953    30.539     0.150
     0.975    17.656     0.150
     0.975    30.469     0.150
     0.988    17.219     0.150
     0.988    30.938     0.150
     1.013    17.742     0.150
     1.013    31.508     0.150
     1.013    17.805     0.150
     1.013    32.375     0.150
     1.070    18.461     0.150
     1.070    32.766     0.150
     1.123    20.188     0.150
     1.124    19.492     0.150
     1.124    35.570     0.150
     1.167    20.953     0.150
     1.167    35.859     0.150
     1.185    21.852     0.150
     1.185    37.367     0.150
     1.265    23.297     0.150
     1.265    40.391     0.150
     1.318    23.383     0.150
     1.429    24.609     0.150
     1.700    30.680     0.150
     1.811    33.031     0.150
     1.921    34.188     0.150
     3.002    48.797     0.150
     3.735    58.508     0.150
     3.817    59.828     0.150
     3.923    61.219     0.150
     3.957    62.336     0.150
     4.400    67.750     0.150
     4.648    71.562     0.150
     4.724    72.969     0.150
     4.838    74.086     0.150
     5.268    78.547     0.150
     7.797   146.000     0.150
     7.822   145.195     0.150
     7.822   241.352     0.150
    10.801   154.102     0.150
    10.801   342.016     0.150
    10.894   160.219     0.150
    10.894   203.023     0.150
    10.894   347.719     0.150
     0.034     3.148     0.150
     0.066     2.211     0.150
     0.105     3.250     0.150
     0.105     6.609     0.150
     0.114     2.789     0.150
     0.124     3.102     0.150
     0.124     6.383     0.150
     0.168     4.320     0.150
     0.168     7.867     0.150
     0.163     4.383     0.150
     0.163     8.430     0.150
     0.179     4.438     0.150
     0.179     8.164     0.150
     0.187     4.492     0.150
     0.187     8.688     0.150
     0.186     5.000     0.150
     0.186     9.680     0.150
     0.206     7.094     0.150
     0.199     4.641     0.150
     0.199     8.500     0.150
     0.246     5.758     0.150
     0.246     9.789     0.150
     0.253     5.812     0.150
     0.288    11.289     0.150
     0.319     6.273     0.150
     0.317     7.453     0.150
     0.317    12.438     0.150
     0.351     7.234     0.150
     0.351    12.609     0.150
     0.343     7.398     0.150
     0.343    13.562     0.150
     0.371     7.508     0.150
     0.371    13.789     0.150
     0.398     7.570     0.150
     0.398    13.703     0.150
     0.422     7.922     0.150
     0.422    13.789     0.150
     0.433     9.062     0.150
     0.433    15.672     0.150
     0.442     9.031     0.150
     0.452     9.117     0.150
     0.452    17.008     0.150
     0.451     8.922     0.150
     0.451    16.734     0.150
     0.478     9.508     0.150
     0.478    16.531     0.150
     0.470     9.133     0.150
     0.470    16.102     0.150
     0.498    10.242     0.150
     0.498    18.492     0.150
     0.488     9.094     0.150
     0.488    16.094     0.150
     0.519     9.992     0.150
     0.547    10.555     0.150
     0.547    17.930     0.150
     0.559    11.344     0.150
     0.559    20.180     0.150
     0.607    21.422     0.150
     0.629    12.078     0.150
     0.640    12.469     0.150
     0.640    22.180     0.150
     0.623    11.648     0.150
     0.623    19.320     0.150
     0.655    11.773     0.150
     0.655    20.594     0.150
     0.699    23.461     0.150
     0.720    13.711     0.150
     0.720    23.180     0.150
     0.707    13.711     0.150
     0.707    24.867     0.150
     0.739    14.422     0.150
     0.723    13.852     0.150
     0.723    23.898     0.150
     0.746    14.039     0.150
     0.746    25.305     0.150
     0.750    25.719     0.150
     0.762    13.938     0.150
     0.785    14.578     0.150
     0.785    26.555     0.150
     0.774    14.672     0.150
     0.786    14.758     0.150
     0.786    25.211     0.150
     0.796    14.531     0.150
     0.796    24.570     0.150
     0.805    14.992     0.150
     0.805    27.039     0.150
     0.827    15.570     0.150
     0.827    26.859     0.150
     0.836    15.602     0.150
     0.836    26.750     0.150
     0.831    14.742     0.150
     0.836    15.953     0.150
     0.832    16.023     0.150
     0.850    15.180     0.150
     0.887    16.844     0.150
     0.887    29.070     0.150
     0.902    16.633     0.150
     0.902    28.422     0.150
     0.936    16.852     0.150
     0.934    16.883     0.150
     0.974    17.484     0.150
     0.974    30.820     0.150
     1.014    17.711     0.150
     1.014    31.383     0.150
     1.014    17.977     0.150
     1.014    32.055     0.150
     1.070    37.039     0.150
     1.122    20.219     0.150
     1.125    20.039     0.150
     1.125    35.531     0.150
     1.167    20.539     0.150
     1.167    35.383     0.150
     1.186    21.719     0.150
     1.266    22.484     0.150
     1.318    23.305     0.150
     1.429    25.250     0.150
     1.515    25.688     0.150
     1.701    30.664     0.150
     1.721    29.984     0.150
     1.804    31.633     0.150
     1.922    33.711     0.150
     2.244    34.469     0.150
     2.436    40.641     0.150
     2.518    39.578     0.150
     2.517    39.391     0.150
     2.565    45.141     0.150
     2.578    41.023     0.150
     7.798   144.914     0.150
     7.822   143.969     0.150
    10.800   156.289     0.150
    10.800   340.438     0.150
    10.895   158.062     0.150
     0.063     2.234     0.150
     0.106     3.180     0.150
     0.106     6.516     0.150
     0.120     3.164     0.150
     0.120     6.430     0.150
     0.162     4.391     0.150
     0.162     8.711     0.150
     0.156     4.000     0.150
     0.156     7.820     0.150
     0.187     4.930     0.150
     0.187     9.531     0.150
     0.173     4.305     0.150
     0.173     8.047     0.150
     0.181     4.500     0.150
     0.181     8.797     0.150
     0.194     4.547     0.150
     0.194     8.414     0.150
     0.188     4.594     0.150
     0.188     8.945     0.150
     0.211     8.281     0.150
     0.247     5.859     0.150
     0.247    10.234     0.150
     0.292     6.766     0.150
     0.292    11.375     0.150
     0.316     7.094     0.150
     0.316    12.641     0.150
     0.343     7.234     0.150
     0.343    13.352     0.150
     0.322     6.281     0.150
     0.322    11.156     0.150
     0.357     7.242     0.150
     0.357    12.672     0.150
     0.366     7.477     0.150
     0.366    13.797     0.150
     0.399     7.594     0.150
     0.443     9.203     0.150
     0.426     8.000     0.150
     0.426    14.172     0.150
     0.454     9.195     0.150
     0.454    16.945     0.150
     0.438     9.273     0.150
     0.438    15.883     0.150
     0.446     9.047     0.150
     0.446    16.781     0.150
     0.471     9.047     0.150
     0.471    16.555     0.150
     0.482     9.047     0.150
     0.482    15.953     0.150
     0.483     9.445     0.150
     0.483    16.711     0.150
     0.502    10.141     0.150
     0.502    18.312     0.150
     0.514    10.055     0.150
     0.514    18.227     0.150
     0.551    10.883     0.150
     0.551    18.461     0.150
     0.564    11.383     0.150
     0.564    19.914     0.150
     0.555    10.812     0.150
     0.555    18.930     0.150
     0.609    11.727     0.150
     0.609    20.992     0.150
     0.618    11.523     0.150
     0.618    19.664     0.150
     0.635    12.172     0.150
     0.635    21.281     0.150
     0.645    12.352     0.150
     0.645    22.273     0.150
     0.650    11.742     0.150
     0.650    20.656     0.150
     0.722    13.727     0.150
     0.722    23.609     0.150
     0.703    13.547     0.150
     0.703    24.742     0.150
     0.725    13.625     0.150
     0.725    24.000     0.150
     0.744    14.242     0.150
     0.744    24.266     0.150
     0.744    14.141     0.150
     0.744    25.625     0.150
     0.760    14.445     0.150
     0.760    25.445     0.150
     0.747    14.414     0.150
     0.747    26.031     0.150
     0.767    13.703     0.150
     0.767    24.086     0.150
     0.774    14.406     0.150
     0.774    25.359     0.150
     0.787    14.672     0.150
     0.787    25.156     0.150
     0.789    14.547     0.150
     0.801    14.445     0.150
     0.801    26.055     0.150
     0.807    14.875     0.150
     0.828    15.891     0.150
     0.828    26.672     0.150
     0.839    15.805     0.150
     0.839    28.406     0.150
     0.833    15.375     0.150
     0.833    26.984     0.150
     0.829    14.406     0.150
     0.829    26.047     0.150
     0.853    27.891     0.150
     0.841    15.586     0.150
     0.841    26.734     0.150
     0.856    27.594     0.150
     0.893    16.234     0.150
     0.893    29.180     0.150
     0.907    16.406     0.150
     0.907    28.383     0.150
     0.914    30.883     0.150
     0.940    16.805     0.150
     0.940    30.664     0.150
     0.935    16.805     0.150
     0.964    17.773     0.150
     0.964    30.375     0.150
     0.980    30.836     0.150
     1.018    17.984     0.150
     1.018    17.820     0.150
     1.018    31.945     0.150
     1.065    18.180     0.150
     1.126    19.945     0.150
     1.172    20.656     0.150
     1.172    36.102     0.150
     1.182    20.656     0.150
     1.182    37.055     0.150
     1.264    21.961     0.150
     1.323    22.703     0.150
     1.433    24.547     0.150
     1.509    24.945     0.150
     1.552    27.273     0.150
     1.705    31.703     0.150
     1.695    30.031     0.150
     1.726    28.336     0.150
     1.813    32.203     0.150
     1.984    32.461     0.150
     2.137    33.883     0.150
     2.239    34.492     0.150
     2.376    37.133     0.150
     2.512    38.383     0.150
     2.577    47.109     0.150
     3.921    60.547     0.150
     3.953    60.195     0.150
     5.786    87.305     0.150
     7.817   114.555     0.150
     7.817   142.898     0.150
     7.817   241.547     0.150
    10.795   157.805     0.150
    37.180   431.703     0.150
   125.906   940.250     0.150
     1.018    18.031     0.150
     0.042     3.836     0.150
     0.101     3.273     0.150
     0.101     6.508     0.150
     0.118     3.008     0.150
     0.122     3.188     0.150
     0.122     6.352     0.150
     0.160     4.141     0.150
     0.156     4.328     0.150
     0.178     4.531     0.150
     0.178     8.109     0.150
     0.187     4.641     0.150
     0.187     8.969     0.150
     0.181     4.938     0.150
     0.181     9.438     0.150
     0.191     4.461     0.150
     0.191     8.250     0.150
     0.194     4.727     0.150
     0.194     8.742     0.150
     0.242     5.758     0.150
     0.242    10.047     0.150
     0.249     5.703     0.150
     0.249     8.703     0.150
     0.290     6.891     0.150
     0.290    12.281     0.150
     0.321     7.078     0.150
     0.321    12.727     0.150
     0.329     6.508     0.150
     0.337     7.203     0.150
     0.337    13.258     0.150
     0.365     7.406     0.150
     0.365    13.680     0.150
     0.360     7.367     0.150
     0.360    12.797     0.150
     0.405     7.797     0.150
     0.432     8.367     0.150
     0.432    14.219     0.150
     0.447     8.852     0.150
     0.443     9.273     0.150
     0.443    15.852     0.150
     0.449     9.141     0.150
     0.449    17.258     0.150
     0.465     9.031     0.150
     0.479     9.023     0.150
     0.479    15.648     0.150
     0.487     9.648     0.150
     0.487    16.742     0.150
     0.500    10.180     0.150
     0.500    18.148     0.150
     0.514     9.922     0.150
     0.559    10.773     0.150
     0.559    19.219     0.150
     0.557    10.789     0.150
     0.557    18.367     0.150
     0.564    11.383     0.150
     0.564    19.898     0.150
     0.605    11.703     0.150
     0.605    20.977     0.150
     0.614    11.227     0.150
     0.614    19.508     0.150
     0.637    12.297     0.150
     0.637    21.133     0.150
     0.648    11.672     0.150
     0.648    20.906     0.150
     0.645    12.461     0.150
     0.645    22.133     0.150
     0.706    13.750     0.150
     0.698    13.320     0.150
     0.698    23.477     0.150
     0.715    13.641     0.150
     0.715    23.648     0.150
     0.727    13.688     0.150
     0.749    14.180     0.150
     0.749    25.578     0.150
     0.751    14.461     0.150
     0.751    25.930     0.150
     0.749    14.242     0.150
     0.749    24.336     0.150
     0.765    13.938     0.150
     0.768    14.320     0.150
     0.782    14.273     0.150
     0.782    25.617     0.150
     0.800    14.609     0.150
     0.800    26.039     0.150
     0.803    14.711     0.150
     0.803    26.672     0.150
     0.822    15.781     0.150
     0.822    26.898     0.150
     0.835    14.562     0.150
     0.835    26.086     0.150
     0.836    15.438     0.150
     0.836    27.203     0.150
     0.835    15.688     0.150
     0.835    26.617     0.150
     0.845    27.047     0.150
     0.858    15.430     0.150
     0.850    15.172     0.150
     0.850    27.398     0.150
     0.894    16.273     0.150
     0.910    16.461     0.150
     0.910    28.609     0.150
     0.942    16.852     0.150
     0.942    29.617     0.150
     0.938    16.812     0.150
     0.938    30.656     0.150
     0.984    17.586     0.150
     1.016    17.906     0.150
     1.016    32.047     0.150
     1.015    17.852     0.150
     1.015    31.398     0.150
     1.064    17.922     0.150
     1.121    19.789     0.150
     1.132    20.891     0.150
     1.176    21.867     0.150
     1.176    37.633     0.150
     1.174    20.273     0.150
     1.258    22.930     0.150
     1.258    40.750     0.150
     1.323    22.617     0.150
     1.430    24.523     0.150
     1.508    24.891     0.150
     1.524    27.109     0.150
     1.703    30.898     0.150
     1.703    53.742     0.150
     1.794    31.562     0.150
     2.512    38.367     0.150
     2.673    45.719     0.150
     2.940    47.352     0.150
     7.813   143.625     0.150
     7.813   243.250     0.150
    10.794   155.055     0.150
    10.794   342.578     0.150
    10.886   156.633     0.150
   125.911  1140.969     0.150
   125.911   936.875     0.150
   126.674   940.648     0.150
     1.015    17.430     0.150
     0.146     3.562     0.150
     0.146     6.340     0.150
     0.189     4.152     0.150
     0.189     7.141     0.150
     0.187     4.250     0.150
     0.187     7.711     0.150
     0.249     5.473     0.150
     0.249     9.680     0.150
     0.252     5.473     0.150
     0.252     9.160     0.150
     0.267     5.652     0.150
     0.267     9.742     0.150
     0.283     6.242     0.150
     0.283    10.941     0.150
     0.291     6.422     0.150
     0.291    11.500     0.150
     0.352     7.312     0.150
     0.352     7.762     0.150
     0.352    13.930     0.150
     0.355     7.441     0.150
     0.355    13.020     0.150
     0.349     7.102     0.150
     0.349    12.820     0.150
     0.365     8.109     0.150
     0.370     7.500     0.150
     0.370    12.871     0.150
     0.392     8.012     0.150
     0.392    15.402     0.150
     0.388     7.641     0.150
     0.388    12.941     0.150
     0.401     8.672     0.150
     0.401    15.551     0.150
     0.403     8.172     0.150
     0.403    14.289     0.150
     0.390     7.711     0.150
     0.390    13.250     0.150
     0.415     8.859     0.150
     0.415    15.973     0.150
     0.420     8.012     0.150
     0.420    13.871     0.150
     0.432     8.762     0.150
     0.432    15.250     0.150
     0.426     8.223     0.150
     0.426    14.020     0.150
     0.441     9.480     0.150
     0.441    17.109     0.150
     0.445     8.859     0.150
     0.445    15.422     0.150
     0.446    14.840     0.150
     0.467     9.609     0.150
     0.467    16.223     0.150
     0.479     9.062     0.150
     0.479    15.621     0.150
     0.487     9.410     0.150
     0.490    15.961     0.150
     0.503    16.359     0.150
     0.525    18.430     0.150
     0.541    10.312     0.150
     0.541    17.492     0.150
     0.562    10.641     0.150
     0.562    18.062     0.150
     0.577    20.000     0.150
     0.568    11.012     0.150
     0.568    18.383     0.150
     0.575    18.242     0.150
     0.606    20.422     0.150
     0.607    19.609     0.150
     0.615    12.152     0.150
     0.615    21.902     0.150
     0.622    12.551     0.150
     0.654    12.230     0.150
     0.654    21.480     0.150
     0.646    12.250     0.150
     0.646    20.699     0.150
     0.664    12.371     0.150
     0.664    21.020     0.150
     0.668    12.832     0.150
     0.668    22.211     0.150
     0.685    22.031     0.150
     0.688    12.781     0.150
     0.688    21.883     0.150
     0.692    21.723     0.150
     0.695    12.980     0.150
     0.695    21.789     0.150
     0.695    12.754     0.150
     0.695    22.078     0.150
     0.695    22.121     0.150
     0.688    12.801     0.150
     0.688    21.789     0.150
     0.713    13.211     0.150
     0.713    22.402     0.150
     0.724    22.492     0.150
     0.730    23.699     0.150
     0.741    13.633     0.150
     0.741    23.902     0.150
     0.757    13.930     0.150
     0.757    24.859     0.150
     0.751    24.812     0.150
     0.773    14.289     0.150
     0.773    24.422     0.150
     0.777    14.301     0.150
     0.777    24.242     0.150
     0.791    14.652     0.150
     0.791    24.922     0.150
     0.815    15.320     0.150
     0.824    15.492     0.150
     0.824    26.332     0.150
     0.846    14.871     0.150
     0.840    15.340     0.150
     0.850    15.691     0.150
     0.850    26.992     0.150
     0.851    26.883     0.150
     0.845    26.133     0.150
     0.863    15.301     0.150
     0.863    26.230     0.150
     0.878    16.012     0.150
     0.878    27.500     0.150
     0.885    16.512     0.150
     0.885    28.402     0.150
     0.889    16.172     0.150
     0.889    27.711     0.150
     0.903    16.051     0.150
     0.904    16.262     0.150
     0.904    29.223     0.150
     0.905    28.160     0.150
     0.915    16.562     0.150
     0.915    28.711     0.150
     0.908    16.840     0.150
     0.908    28.531     0.150
     0.935    17.449     0.150
     0.967    17.422     0.150
     0.969    17.449     0.150
     1.040    17.750     0.150
     1.067    19.230     0.150
     1.066    19.789     0.150
     1.079    18.262     0.150
     1.141    20.430     0.150
     1.332    23.012     0.150
     1.343    23.762     0.150
     1.365    23.742     0.150
     1.429    23.801     0.150
     1.455    23.570     0.150
     1.653    28.152     0.150
     1.690    28.160     0.150
     1.834    30.480     0.150
     1.898    30.133     0.150
     2.004    32.211     0.150
     2.079    33.121     0.150
     2.108    33.562     0.150
     2.149    36.441     0.150
     2.149    65.141     0.150
     2.251    35.922     0.150
     2.362    37.152     0.150
     2.475    42.230     0.150
     2.612    40.723     0.150
     2.732    42.391     0.150
     2.901    43.570     0.150
     4.458    65.492     0.150
     4.562    69.172     0.150
     5.703    86.461     0.150
     5.703   104.512     0.150
     5.703   178.887     0.150
     7.724   144.836     0.150
     7.724   240.512     0.150
     8.153   119.156     0.150
     8.153   153.656     0.150
     8.153   252.680     0.150
    10.190   149.617     0.150
    10.967   160.812     0.150
    11.186   160.535     0.150
    11.186   351.562     0.150
    14.924   211.062     0.150
    15.241   215.812     0.150
    15.516   219.152     0.150
    15.988   224.102     0.150
    16.797   235.871     0.150
    16.911   237.520     0.150
    18.432   253.941     0.150
    18.535   254.980     0.150
    18.699   256.480     0.150
    19.836   270.020     0.150
    20.271   276.371     0.150
    21.371   285.859     0.150
    21.490   287.730     0.150
    21.558   288.250     0.150
    22.077   293.742     0.150
    22.270   296.641     0.150
    22.496   299.402     0.150
    23.264   306.391     0.150
    34.281   406.020     0.150
    36.952   428.859     0.150
    37.821   435.711     0.150
    39.771   452.582     0.150
    41.532   467.141     0.150
    79.372   729.336     0.150
    15.698   220.742     0.150
    34.161   404.582     0.150
    39.928   454.172     0.150
     0.114     2.667     0.150
     0.023     1.508     0.150
     0.146     3.408     0.150
     0.263     5.518     0.150
     0.289     6.038     0.150
     0.289    10.888     0.150
     0.307    10.368     0.150
     0.307     5.908     0.150
     0.330     6.647     0.150
     0.335     6.868     0.150
     0.335    12.188     0.150
     0.249     5.378     0.150
     0.247     5.358     0.150
     0.326    11.167     0.150
     0.377     7.128     0.150
     0.489     9.348     0.150
     0.646    12.788     0.150
     0.665    12.568     0.150
     0.745    14.368     0.150
     0.793    15.068     0.150
     0.779    15.048     0.150
     0.883    16.708     0.150
     0.830    16.038     0.150
     0.888    16.938     0.150
     0.906    16.938     0.150
     0.860    16.628     0.150
     0.982    18.948     0.150
     1.108    20.268     0.150
     1.076    19.798     0.150
     1.121    20.808     0.150
     1.290    22.828     0.150
     1.238    23.138     0.150
     1.379    24.167     0.150
     1.407    24.378     0.150
     1.447    25.858     0.150
     1.491    26.878     0.150
     1.547    26.917     0.150
     1.578    27.598     0.150
     1.658    29.368     0.150
     1.730    29.438     0.150
     2.010    32.688     0.150
     1.994    33.938     0.150
     2.007    33.858     0.150
     2.233    36.698     0.150
     2.231    37.318     0.150
     2.308    36.378     0.150
     2.317    37.968     0.150
     2.408    39.568     0.150
     2.643    42.528     0.150
     2.726    44.618     0.150
     2.875    44.928     0.150
    15.175   219.458     0.150
    15.276   218.448     0.150
    15.236   221.448     0.150
    15.311   217.428     0.150
    15.402   218.917     0.150
    15.774   223.098     0.150
    15.705   225.298     0.150
    15.955   225.128     0.150
    16.256   228.458     0.150
    16.568   234.348     0.150
    17.275   243.438     0.150
    17.704   248.788     0.150
    19.417   267.498     0.150
    20.111   275.308     0.150
    20.794   283.058     0.150
    20.911   283.778     0.150
    21.552   291.917     0.150
    22.523   301.268     0.150
    22.739   301.718     0.150
    23.286   308.978     0.150
    24.670   321.728     0.150
    33.411   400.308     0.150
    40.313   458.748     0.150
    40.560   461.808     0.150
    41.705   470.338     0.150
    43.507   484.758     0.150
EOF
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jBL  << EOF
    60.000   140.000 P phases in red
EOF
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL  << EOF
    60.000   100.000 S phases in green
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL  << EOF
    60.000    60.000 Readings used for cluster vectors in black
EOF
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    60.000    20.000 Readings not used for cluster vectors in cyan
EOF
gmt end
