#!/bin/bash
gmt begin salton5.43_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-12/12/-12/12
gmt basemap $proj $reg -Bxa10f5+l'km' -Bya10f5+l'km' -BWeSn+t'Epicentral Mislocation salton5.43'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     3.828     3.828
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.827    -1.479
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.365    -2.102
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.922     1.698
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.922     1.698 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.120    -4.294
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.120    -4.294 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.045    -0.616
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.045    -0.616 5
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.709    -5.554
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.709    -5.554 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.770    -4.107
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.770    -4.107 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.652    -3.543
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.652    -3.543 8
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.277    -2.885
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.277    -2.885 9
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.200    -0.344
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.900    -1.231
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.427     3.309
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.427     3.309 12
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.772     0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.071    -1.422
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.310    -2.204
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.858     0.889
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.562    -2.135
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.562    -2.135 17
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.244    -0.522
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.307    -3.504
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.498     1.371
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.498     1.371 20
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.214    -2.861
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.782    -2.850
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.782    -2.850 22
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.248    -0.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.997    -1.659
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.069    -0.050
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.045     2.052
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.044    -0.497
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.296     1.827
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.939    -2.311
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.286    -0.924
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.479     0.026
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.758    -0.080
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.410    -4.339
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.410    -4.339 33
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.099    -4.944
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.099    -4.944 34
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.959     2.017
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.959     2.017 35
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.409    -1.336
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.415    -1.691
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.028    -0.035
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.515    -2.011
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.435     3.750
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.435     3.750 40
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.652    -3.711
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.652    -3.711 41
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.754    -5.094
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.754    -5.094 42
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.797    -2.192
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.797    -2.192 43
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.636    -6.508
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.636    -6.508 44
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.516    -3.107
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.190    -2.714
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.621    -1.621
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.524    -0.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.674     0.454
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.376     0.376
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.266    -2.982
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.361    -5.024
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.361    -5.024 52
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.093    -1.770
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.042    -2.404
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.464    -1.745
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.243    -1.535
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.152     0.311
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.865    -3.017
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.297    -1.168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.074    -0.846
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.654    -0.057
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.663    -0.430
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.256    -0.702
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.292    -0.657
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.209    -1.704
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.223    -2.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.423    -0.542
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.895    -1.105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.125    -1.783
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.012    -2.873
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.738    -0.912
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.518     1.339
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.213    -0.354
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.844    -0.029
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.931    -0.899
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.885    -2.507
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.672     0.231
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.259    -0.968
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.459    -0.195
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.050    -1.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.803    -4.247
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.803    -4.247 81
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.280    -0.813
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.033    -1.895
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.513    -1.489
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.129    -0.733
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.734    -0.809
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.283    -0.822
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.233    -1.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.745    -1.291
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.011     0.211
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000    -1.893
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.407    -0.084
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.947    -1.404
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.223    -2.223
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.009    -0.176
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.054    -0.884
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.642    -0.379
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.977    -0.542
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.230    -0.568
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.279    -3.986
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.279    -3.986 100
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.505     0.505
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.398     2.316
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.730    -1.433
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.502    -0.637
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.402    -4.201
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.402    -4.201 105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.480    -0.182
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.971    -2.820
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.594    -0.487
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.406    -2.340
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.225    -0.679
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.805    -1.993
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.972    -2.084
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.066     1.256
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.511     0.044
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.710    -2.063
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.815    -0.433
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.112    -0.933
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.927    -0.864
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.775     0.267
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.505    -0.439
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.393    -4.493
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.393    -4.493 121
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.346     0.118
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.622     0.065
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.028    -1.524
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.361    -1.459
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.589    -1.108
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.885    -0.949
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.551    -1.923
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.993    -0.846
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.251    -0.722
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     1.393
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.100    -1.912
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.939    -1.562
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.444    -0.469
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.159     1.294
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.424    -0.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.688     0.518
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.568    -6.290
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.568    -6.290 138
EOF
gmt plot $proj $reg -SE -Gred << EOF
     0.448    -1.233     0.000     1.500     1.500
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -10.500    10.500 Author: all ( 138 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -10.500   -10.500 Average =   1.3 km at 160.1 deg; median =    1.9 km
EOF
gmt end
