#!/bin/bash
gmt begin salton5.43_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-18/19/0/20
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depth Mislocation salton5.43' << EOF
    -1.100
     3.600
    -4.200
    -2.200
    -4.500
   -10.700
     3.100
    -5.800
    -6.300
     1.100
     4.700
    -4.300
    -5.900
     3.400
     0.300
     3.400
     5.200
    -0.200
    -2.000
     6.600
     6.800
    -1.300
    -1.300
    -3.200
     4.100
     2.100
    -0.000
   -10.000
     1.400
    -0.000
    -9.600
    -1.800
    -1.800
     1.400
    -3.900
     4.200
     2.800
    -0.200
     3.900
     0.800
    -6.200
    -2.500
    -1.600
    -0.700
     3.600
     1.200
     2.300
     2.400
     4.900
    13.500
    -1.800
     3.500
    -2.300
   -10.000
     1.800
     2.400
     4.400
    13.800
     6.500
     7.900
     3.700
     7.500
     3.700
     6.100
     5.200
    10.100
     3.700
     3.000
     2.400
     2.900
     1.300
     6.200
     6.900
     3.000
     4.000
     0.700
     4.000
     2.500
     5.800
     3.900
     1.900
     2.000
     1.700
    -8.200
     0.900
     3.300
     1.300
     3.700
     2.600
     3.200
     3.800
     4.600
    -2.100
    -1.300
     5.000
    -1.700
     6.500
     6.200
     8.100
     2.900
     6.400
     5.300
     4.300
     2.000
   -13.200
     3.000
     2.200
     7.000
    -7.100
     4.500
     1.000
     0.900
     5.500
     5.900
     4.000
     2.200
     1.000
     1.000
     6.000
     2.100
    -3.100
    -0.700
     6.100
    -0.600
     0.600
     0.900
    -0.600
     2.100
    -2.000
    -3.800
    -0.600
    -2.200
     0.400
     1.100
    -1.000
    -1.200
    -3.600
     9.200
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     2.050    18.050 Median =   2.1 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  2.1  0.
  2.1  17.7
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -17.000    18.950 Author: all ( 138 samples)
EOF
gmt end
