#!/bin/bash
gmt begin salton5.43_dcal pdf,ps
proj=-JM16.0c+
reg=-R-119.2/-113.3/31.0/35.9
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration salton5.43'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -115.998    34.001
  -116.070    33.721
>
  -115.998    34.001
  -116.070    33.721
>
  -116.459    33.612
  -116.070    33.721
>
  -116.459    33.612
  -116.070    33.721
>
  -116.459    33.612
  -116.070    33.721
>
  -115.454    33.655
  -116.070    33.721
>
  -115.454    33.655
  -116.070    33.721
>
  -115.998    34.001
  -116.207    33.869
>
  -115.998    34.001
  -116.207    33.869
>
  -116.459    33.612
  -116.207    33.869
>
  -116.459    33.612
  -116.207    33.869
>
  -115.454    33.655
  -116.207    33.869
>
  -115.969    32.887
  -116.063    33.113
>
  -115.800    32.945
  -116.063    33.113
>
  -115.800    32.945
  -116.063    33.113
>
  -115.727    32.849
  -116.063    33.113
>
  -115.638    33.402
  -116.063    33.113
>
  -116.422    32.892
  -116.063    33.113
>
  -116.422    32.892
  -116.063    33.113
>
  -116.101    32.659
  -116.063    33.113
>
  -116.101    32.659
  -116.063    33.113
>
  -115.923    32.648
  -116.063    33.113
>
  -116.079    32.603
  -116.063    33.113
>
  -116.079    32.603
  -116.063    33.113
>
  -115.725    32.649
  -116.063    33.113
>
  -116.459    33.612
  -116.063    33.113
>
  -116.459    33.612
  -116.063    33.113
>
  -116.459    33.612
  -116.063    33.113
>
  -115.638    33.708
  -116.063    33.113
>
  -116.672    32.680
  -116.063    33.113
>
  -116.672    32.680
  -116.063    33.113
>
  -116.672    32.680
  -116.063    33.113
>
  -116.846    32.891
  -116.063    33.113
>
  -116.459    33.612
  -116.459    33.444
>
  -116.459    33.612
  -116.459    33.444
>
  -116.422    32.892
  -116.459    33.444
>
  -116.422    32.892
  -116.459    33.444
>
  -117.195    33.600
  -116.459    33.444
>
  -117.195    33.600
  -116.459    33.444
>
  -115.998    34.001
  -116.459    33.444
>
  -115.998    34.001
  -116.459    33.444
>
  -116.459    33.612
  -116.454    33.444
>
  -116.459    33.612
  -116.454    33.444
>
  -116.459    33.612
  -116.454    33.444
>
  -116.459    33.612
  -116.454    33.444
>
  -116.422    32.892
  -116.454    33.444
>
  -116.422    32.892
  -116.454    33.444
>
  -115.998    34.001
  -116.454    33.444
>
  -115.998    34.001
  -116.454    33.444
>
  -117.195    33.600
  -116.454    33.444
>
  -117.195    33.600
  -116.454    33.444
>
  -117.195    33.600
  -116.866    33.503
>
  -117.195    33.600
  -116.866    33.503
>
  -116.459    33.612
  -116.866    33.503
>
  -116.459    33.612
  -116.866    33.503
>
  -116.459    33.612
  -116.866    33.503
>
  -117.105    32.889
  -116.866    33.503
>
  -117.105    32.889
  -116.866    33.503
>
  -117.195    33.600
  -116.872    33.498
>
  -117.195    33.600
  -116.872    33.498
>
  -116.459    33.612
  -116.872    33.498
>
  -116.459    33.612
  -116.872    33.498
>
  -117.105    32.889
  -116.872    33.498
>
  -117.105    32.889
  -116.872    33.498
>
  -115.638    33.402
  -115.750    33.326
>
  -115.800    32.945
  -115.750    33.326
>
  -115.800    32.945
  -115.750    33.326
>
  -115.638    33.708
  -115.750    33.326
>
  -115.454    33.655
  -115.750    33.326
>
  -115.454    33.655
  -115.750    33.326
>
  -115.969    32.887
  -115.750    33.326
>
  -115.437    32.862
  -115.750    33.326
>
  -115.725    32.649
  -115.750    33.326
>
  -116.459    33.612
  -115.750    33.326
>
  -116.459    33.612
  -115.750    33.326
>
  -115.800    32.945
  -115.743    33.296
>
  -115.727    32.849
  -115.743    33.296
>
  -115.454    33.655
  -115.743    33.296
>
  -115.454    33.655
  -115.743    33.296
>
  -115.638    33.708
  -115.743    33.296
>
  -115.969    32.887
  -115.743    33.296
>
  -115.437    32.862
  -115.743    33.296
>
  -115.725    32.649
  -115.743    33.296
>
  -115.923    32.648
  -115.743    33.296
>
  -116.422    32.892
  -115.743    33.296
>
  -116.422    32.892
  -115.743    33.296
>
  -116.459    33.612
  -115.743    33.296
>
  -116.459    33.612
  -115.743    33.296
>
  -116.459    33.612
  -115.743    33.296
>
  -116.602    33.495
  -116.440    33.242
>
  -116.423    32.893
  -116.440    33.242
>
  -116.422    32.892
  -116.440    33.242
>
  -116.459    33.612
  -116.440    33.242
>
  -116.459    33.612
  -116.440    33.242
>
  -116.862    33.353
  -116.440    33.242
>
  -116.942    32.999
  -116.440    33.242
>
  -116.846    32.891
  -116.440    33.242
>
  -115.969    32.887
  -116.440    33.242
>
  -116.672    32.680
  -116.440    33.242
>
  -116.672    32.680
  -116.440    33.242
>
  -115.800    32.945
  -116.440    33.242
>
  -115.800    32.945
  -116.440    33.242
>
  -116.101    32.659
  -116.440    33.242
>
  -116.101    32.659
  -116.440    33.242
>
  -117.105    32.889
  -116.440    33.242
>
  -117.105    32.889
  -116.440    33.242
>
  -116.921    34.262
  -116.924    33.970
>
  -116.921    34.262
  -116.924    33.970
>
  -117.195    33.600
  -116.924    33.970
>
  -117.195    33.600
  -116.924    33.970
>
  -117.659    34.239
  -116.924    33.970
>
  -117.659    34.239
  -116.924    33.970
>
  -116.423    32.893
  -116.363    32.995
>
  -116.422    32.892
  -116.363    32.995
>
  -116.422    32.892
  -116.363    32.995
>
  -115.969    32.887
  -116.363    32.995
>
  -115.800    32.945
  -116.363    32.995
>
  -115.800    32.945
  -116.363    32.995
>
  -116.672    32.680
  -116.363    32.995
>
  -116.672    32.680
  -116.363    32.995
>
  -116.846    32.891
  -116.363    32.995
>
  -116.846    32.891
  -116.363    32.995
>
  -116.079    32.603
  -116.363    32.995
>
  -115.923    32.648
  -116.363    32.995
>
  -116.942    32.999
  -116.363    32.995
>
  -116.942    32.999
  -116.363    32.995
>
  -116.960    33.026
  -116.363    32.995
>
  -116.960    33.026
  -116.363    32.995
>
  -116.459    33.612
  -116.363    32.995
>
  -116.459    33.612
  -116.363    32.995
>
  -116.459    33.612
  -116.363    32.995
>
  -117.105    32.889
  -116.363    32.995
>
  -116.423    32.893
  -116.359    32.989
>
  -116.422    32.892
  -116.359    32.989
>
  -116.422    32.892
  -116.359    32.989
>
  -115.969    32.887
  -116.359    32.989
>
  -116.672    32.680
  -116.359    32.989
>
  -116.672    32.680
  -116.359    32.989
>
  -116.079    32.603
  -116.359    32.989
>
  -116.846    32.891
  -116.359    32.989
>
  -116.846    32.891
  -116.359    32.989
>
  -115.800    32.945
  -116.359    32.989
>
  -115.800    32.945
  -116.359    32.989
>
  -115.923    32.648
  -116.359    32.989
>
  -116.942    32.999
  -116.359    32.989
>
  -116.942    32.999
  -116.359    32.989
>
  -115.727    32.849
  -116.359    32.989
>
  -116.960    33.026
  -116.359    32.989
>
  -116.602    33.495
  -116.359    32.989
>
  -116.602    33.495
  -116.359    32.989
>
  -116.459    33.612
  -116.359    32.989
>
  -116.459    33.612
  -116.359    32.989
>
  -116.459    33.612
  -116.359    32.989
>
  -117.105    32.889
  -116.359    32.989
>
  -117.105    32.889
  -116.359    32.989
>
  -117.105    32.889
  -116.359    32.989
>
  -116.459    33.612
  -116.418    33.395
>
  -116.459    33.612
  -116.418    33.395
>
  -116.459    33.612
  -116.418    33.395
>
  -116.422    32.892
  -116.418    33.395
>
  -115.800    32.945
  -116.418    33.395
>
  -115.800    32.945
  -116.418    33.395
>
  -117.195    33.600
  -116.418    33.395
>
  -117.195    33.600
  -116.418    33.395
>
  -115.998    34.001
  -116.418    33.395
>
  -115.998    34.001
  -116.418    33.395
>
  -116.417    33.268
  -116.496    33.422
>
  -116.417    33.268
  -116.496    33.422
>
  -116.613    33.552
  -116.496    33.422
>
  -116.631    33.567
  -116.496    33.422
>
  -116.459    33.612
  -116.496    33.422
>
  -116.459    33.612
  -116.496    33.422
>
  -116.459    33.612
  -116.496    33.422
>
  -116.737    33.565
  -116.496    33.422
>
  -116.862    33.353
  -116.496    33.422
>
  -117.009    33.650
  -116.496    33.422
>
  -115.990    33.655
  -116.496    33.422
>
  -117.041    33.612
  -116.496    33.422
>
  -116.422    32.892
  -116.496    33.422
>
  -116.422    32.892
  -116.496    33.422
>
  -117.004    33.709
  -116.496    33.422
>
  -116.578    33.936
  -116.496    33.422
>
  -116.960    33.026
  -116.496    33.422
>
  -116.252    32.900
  -116.496    33.422
>
  -116.942    32.999
  -116.496    33.422
>
  -115.841    33.459
  -116.496    33.422
>
  -116.846    32.891
  -116.496    33.422
>
  -115.872    33.677
  -116.496    33.422
>
  -117.195    33.600
  -116.496    33.422
>
  -117.195    33.600
  -116.496    33.422
>
  -115.969    32.887
  -116.496    33.422
>
  -115.823    33.117
  -115.996    33.163
>
  -115.800    32.945
  -115.996    33.163
>
  -115.800    32.945
  -115.996    33.163
>
  -115.800    32.945
  -115.996    33.163
>
  -115.969    32.887
  -115.996    33.163
>
  -116.252    32.900
  -115.996    33.163
>
  -115.638    33.402
  -115.996    33.163
>
  -115.527    33.141
  -115.996    33.163
>
  -115.727    32.849
  -115.996    33.163
>
  -116.422    32.892
  -115.996    33.163
>
  -116.422    32.892
  -115.996    33.163
>
  -115.732    32.759
  -115.996    33.163
>
  -115.732    32.759
  -115.996    33.163
>
  -116.093    32.661
  -115.996    33.163
>
  -116.093    32.661
  -115.996    33.163
>
  -115.923    32.648
  -115.996    33.163
>
  -116.079    32.603
  -115.996    33.163
>
  -116.079    32.603
  -115.996    33.163
>
  -116.079    32.603
  -115.996    33.163
>
  -116.459    33.612
  -115.996    33.163
>
  -116.459    33.612
  -115.996    33.163
>
  -116.459    33.612
  -115.996    33.163
>
  -115.454    33.655
  -115.996    33.163
>
  -115.454    33.655
  -115.996    33.163
>
  -116.578    33.936
  -116.446    33.988
>
  -116.049    34.106
  -116.446    33.988
>
  -115.998    34.001
  -116.446    33.988
>
  -115.998    34.001
  -116.446    33.988
>
  -115.998    34.001
  -116.446    33.988
>
  -116.459    33.612
  -116.446    33.988
>
  -116.459    33.612
  -116.446    33.988
>
  -116.459    33.612
  -116.446    33.988
>
  -116.287    34.401
  -116.446    33.988
>
  -116.631    33.567
  -116.446    33.988
>
  -115.990    33.655
  -116.446    33.988
>
  -116.613    33.552
  -116.446    33.988
>
  -116.737    33.565
  -116.446    33.988
>
  -116.602    33.495
  -116.446    33.988
>
  -116.921    34.262
  -116.446    33.988
>
  -116.921    34.262
  -116.446    33.988
>
  -117.004    33.709
  -116.446    33.988
>
  -117.098    34.106
  -116.446    33.988
>
  -117.009    33.650
  -116.446    33.988
>
  -117.041    33.612
  -116.446    33.988
>
  -115.527    33.141
  -115.566    33.041
>
  -115.800    32.945
  -115.566    33.041
>
  -115.800    32.945
  -115.566    33.041
>
  -115.727    32.849
  -115.566    33.041
>
  -115.447    32.805
  -115.566    33.041
>
  -115.220    33.012
  -115.566    33.041
>
  -115.732    32.759
  -115.566    33.041
>
  -115.969    32.887
  -115.566    33.041
>
  -115.725    32.649
  -115.566    33.041
>
  -115.123    32.863
  -115.566    33.041
>
  -115.923    32.648
  -115.566    33.041
>
  -114.985    32.739
  -115.566    33.041
>
  -116.093    32.661
  -115.566    33.041
>
  -116.093    32.661
  -115.566    33.041
>
  -116.093    32.661
  -115.566    33.041
>
  -116.079    32.603
  -115.566    33.041
>
  -114.827    33.051
  -115.566    33.041
>
  -114.827    33.051
  -115.566    33.041
>
  -114.827    33.051
  -115.566    33.041
>
  -115.454    33.655
  -115.566    33.041
>
  -115.454    33.655
  -115.566    33.041
>
  -115.304    32.418
  -115.566    33.041
>
  -115.304    32.418
  -115.566    33.041
>
  -117.195    33.600
  -116.837    33.711
>
  -117.195    33.600
  -116.837    33.711
>
  -116.459    33.612
  -116.837    33.711
>
  -116.459    33.612
  -116.837    33.711
>
  -116.459    33.612
  -116.837    33.711
>
  -116.921    34.262
  -116.837    33.711
>
  -116.921    34.262
  -116.837    33.711
>
  -116.422    32.892
  -116.314    33.009
>
  -116.422    32.892
  -116.314    33.009
>
  -116.417    33.268
  -116.314    33.009
>
  -116.109    32.650
  -116.314    33.009
>
  -115.800    32.945
  -116.314    33.009
>
  -115.800    32.945
  -116.314    33.009
>
  -116.079    32.603
  -116.314    33.009
>
  -115.923    32.648
  -116.314    33.009
>
  -116.672    32.680
  -116.314    33.009
>
  -116.672    32.680
  -116.314    33.009
>
  -115.732    32.759
  -116.314    33.009
>
  -116.846    32.891
  -116.314    33.009
>
  -116.602    33.495
  -116.314    33.009
>
  -116.459    33.612
  -116.314    33.009
>
  -116.459    33.612
  -116.314    33.009
>
  -116.942    32.736
  -116.314    33.009
>
  -117.105    32.889
  -116.314    33.009
>
  -117.105    32.889
  -116.314    33.009
>
  -115.437    32.862
  -115.548    32.934
>
  -115.447    32.805
  -115.548    32.934
>
  -115.727    32.849
  -115.548    32.934
>
  -115.663    32.743
  -115.548    32.934
>
  -115.800    32.945
  -115.548    32.934
>
  -115.800    32.945
  -115.548    32.934
>
  -115.732    32.759
  -115.548    32.934
>
  -115.527    33.141
  -115.548    32.934
>
  -115.123    32.863
  -115.548    32.934
>
  -115.638    33.402
  -115.548    32.934
>
  -114.985    32.739
  -115.548    32.934
>
  -116.109    32.650
  -115.548    32.934
>
  -116.109    32.650
  -115.548    32.934
>
  -116.109    32.650
  -115.548    32.934
>
  -116.079    32.603
  -115.548    32.934
>
  -115.304    32.418
  -115.548    32.934
>
  -115.304    32.418
  -115.548    32.934
>
  -115.198    32.407
  -115.548    32.934
>
  -115.198    32.407
  -115.548    32.934
>
  -115.841    33.459
  -115.548    32.934
>
  -114.827    33.051
  -115.548    32.934
>
  -114.827    33.051
  -115.548    32.934
>
  -115.998    34.001
  -116.157    33.856
>
  -115.998    34.001
  -116.157    33.856
>
  -115.872    33.677
  -116.157    33.856
>
  -116.049    34.106
  -116.157    33.856
>
  -116.456    33.611
  -116.157    33.856
>
  -116.459    33.612
  -116.157    33.856
>
  -116.459    33.612
  -116.157    33.856
>
  -115.638    33.708
  -116.157    33.856
>
  -116.578    33.936
  -116.157    33.856
>
  -115.841    33.459
  -116.157    33.856
>
  -116.631    33.567
  -116.157    33.856
>
  -116.602    33.495
  -116.157    33.856
>
  -115.454    33.655
  -116.157    33.856
>
  -115.454    33.655
  -116.157    33.856
>
  -116.737    33.565
  -116.157    33.856
>
  -115.638    33.402
  -116.157    33.856
>
  -116.981    33.921
  -116.157    33.856
>
  -115.998    34.001
  -116.161    33.842
>
  -115.998    34.001
  -116.161    33.842
>
  -115.872    33.677
  -116.161    33.842
>
  -116.456    33.611
  -116.161    33.842
>
  -116.459    33.612
  -116.161    33.842
>
  -116.459    33.612
  -116.161    33.842
>
  -116.459    33.612
  -116.161    33.842
>
  -116.578    33.936
  -116.161    33.842
>
  -115.638    33.708
  -116.161    33.842
>
  -115.841    33.459
  -116.161    33.842
>
  -116.613    33.552
  -116.161    33.842
>
  -116.631    33.567
  -116.161    33.842
>
  -116.602    33.495
  -116.161    33.842
>
  -116.737    33.565
  -116.161    33.842
>
  -116.417    33.268
  -116.161    33.842
>
  -115.454    33.655
  -116.161    33.842
>
  -115.454    33.655
  -116.161    33.842
>
  -115.638    33.402
  -116.161    33.842
>
  -116.981    33.921
  -116.161    33.842
>
  -116.981    33.921
  -116.161    33.842
>
  -116.456    33.611
  -116.415    33.319
>
  -116.459    33.612
  -116.415    33.319
>
  -116.459    33.612
  -116.415    33.319
>
  -116.459    33.612
  -116.415    33.319
>
  -116.862    33.353
  -116.415    33.319
>
  -116.422    32.892
  -116.415    33.319
>
  -116.252    32.900
  -116.415    33.319
>
  -115.841    33.459
  -116.415    33.319
>
  -115.823    33.117
  -116.415    33.319
>
  -116.960    33.026
  -116.415    33.319
>
  -116.960    33.026
  -116.415    33.319
>
  -116.942    32.999
  -116.415    33.319
>
  -115.969    32.887
  -116.415    33.319
>
  -116.846    32.891
  -116.415    33.319
>
  -115.800    32.945
  -116.415    33.319
>
  -115.800    32.945
  -116.415    33.319
>
  -115.800    32.945
  -116.415    33.319
>
  -116.672    32.680
  -116.415    33.319
>
  -116.672    32.680
  -116.415    33.319
>
  -116.672    32.680
  -116.415    33.319
>
  -115.800    32.945
  -115.581    33.029
>
  -115.800    32.945
  -115.581    33.029
>
  -115.800    32.945
  -115.581    33.029
>
  -115.727    32.849
  -115.581    33.029
>
  -115.447    32.805
  -115.581    33.029
>
  -115.447    32.805
  -115.581    33.029
>
  -115.923    32.648
  -115.581    33.029
>
  -116.109    32.650
  -115.581    33.029
>
  -116.109    32.650
  -115.581    33.029
>
  -116.109    32.650
  -115.581    33.029
>
  -116.079    32.603
  -115.581    33.029
>
  -115.454    33.655
  -115.581    33.029
>
  -115.454    33.655
  -115.581    33.029
>
  -114.827    33.051
  -115.581    33.029
>
  -114.827    33.051
  -115.581    33.029
>
  -114.827    33.051
  -115.581    33.029
>
  -115.304    32.418
  -115.581    33.029
>
  -115.304    32.418
  -115.581    33.029
>
  -115.800    32.945
  -115.566    33.027
>
  -115.800    32.945
  -115.566    33.027
>
  -115.800    32.945
  -115.566    33.027
>
  -115.447    32.805
  -115.566    33.027
>
  -115.447    32.805
  -115.566    33.027
>
  -115.663    32.743
  -115.566    33.027
>
  -115.732    32.759
  -115.566    33.027
>
  -115.969    32.887
  -115.566    33.027
>
  -115.725    32.649
  -115.566    33.027
>
  -115.123    32.863
  -115.566    33.027
>
  -115.923    32.648
  -115.566    33.027
>
  -116.109    32.650
  -115.566    33.027
>
  -116.109    32.650
  -115.566    33.027
>
  -116.079    32.603
  -115.566    33.027
>
  -115.454    33.655
  -115.566    33.027
>
  -115.454    33.655
  -115.566    33.027
>
  -114.827    33.051
  -115.566    33.027
>
  -114.827    33.051
  -115.566    33.027
>
  -115.304    32.418
  -115.566    33.027
>
  -115.304    32.418
  -115.566    33.027
>
  -115.800    32.945
  -115.566    33.032
>
  -115.800    32.945
  -115.566    33.032
>
  -115.800    32.945
  -115.566    33.032
>
  -115.727    32.849
  -115.566    33.032
>
  -115.447    32.805
  -115.566    33.032
>
  -115.447    32.805
  -115.566    33.032
>
  -115.663    32.743
  -115.566    33.032
>
  -115.732    32.759
  -115.566    33.032
>
  -115.725    32.649
  -115.566    33.032
>
  -115.923    32.648
  -115.566    33.032
>
  -116.109    32.650
  -115.566    33.032
>
  -116.109    32.650
  -115.566    33.032
>
  -116.079    32.603
  -115.566    33.032
>
  -116.079    32.603
  -115.566    33.032
>
  -114.827    33.051
  -115.566    33.032
>
  -114.827    33.051
  -115.566    33.032
>
  -115.454    33.655
  -115.566    33.032
>
  -115.454    33.655
  -115.566    33.032
>
  -115.304    32.418
  -115.566    33.032
>
  -115.304    32.418
  -115.566    33.032
>
  -115.198    32.407
  -115.566    33.032
>
  -115.800    32.945
  -115.570    33.030
>
  -115.447    32.805
  -115.570    33.030
>
  -115.727    32.849
  -115.570    33.030
>
  -115.663    32.743
  -115.570    33.030
>
  -115.732    32.759
  -115.570    33.030
>
  -115.123    32.863
  -115.570    33.030
>
  -115.725    32.649
  -115.570    33.030
>
  -115.923    32.648
  -115.570    33.030
>
  -114.827    33.051
  -115.570    33.030
>
  -115.454    33.655
  -115.570    33.030
>
  -116.109    32.650
  -115.570    33.030
>
  -116.109    32.650
  -115.570    33.030
>
  -116.079    32.603
  -115.570    33.030
>
  -115.304    32.418
  -115.570    33.030
>
  -115.727    32.849
  -115.574    33.014
>
  -115.447    32.805
  -115.574    33.014
>
  -115.447    32.805
  -115.574    33.014
>
  -115.800    32.945
  -115.574    33.014
>
  -115.663    32.743
  -115.574    33.014
>
  -115.732    32.759
  -115.574    33.014
>
  -115.969    32.887
  -115.574    33.014
>
  -115.725    32.649
  -115.574    33.014
>
  -115.923    32.648
  -115.574    33.014
>
  -116.109    32.650
  -115.574    33.014
>
  -116.109    32.650
  -115.574    33.014
>
  -116.079    32.603
  -115.574    33.014
>
  -116.079    32.603
  -115.574    33.014
>
  -115.304    32.418
  -115.574    33.014
>
  -115.304    32.418
  -115.574    33.014
>
  -114.827    33.051
  -115.574    33.014
>
  -114.827    33.051
  -115.574    33.014
>
  -115.727    32.849
  -115.619    32.987
>
  -115.800    32.945
  -115.619    32.987
>
  -115.800    32.945
  -115.619    32.987
>
  -115.447    32.805
  -115.619    32.987
>
  -115.447    32.805
  -115.619    32.987
>
  -115.823    33.117
  -115.619    32.987
>
  -115.823    33.117
  -115.619    32.987
>
  -115.663    32.743
  -115.619    32.987
>
  -115.732    32.759
  -115.619    32.987
>
  -115.732    32.759
  -115.619    32.987
>
  -115.969    32.887
  -115.619    32.987
>
  -115.725    32.649
  -115.619    32.987
>
  -115.123    32.863
  -115.619    32.987
>
  -115.923    32.648
  -115.619    32.987
>
  -116.109    32.650
  -115.619    32.987
>
  -116.109    32.650
  -115.619    32.987
>
  -116.079    32.603
  -115.619    32.987
>
  -115.304    32.418
  -115.619    32.987
>
  -115.304    32.418
  -115.619    32.987
>
  -114.827    33.051
  -115.619    32.987
>
  -114.827    33.051
  -115.619    32.987
>
  -115.198    32.407
  -115.619    32.987
>
  -115.454    33.655
  -115.619    32.987
>
  -115.454    33.655
  -115.619    32.987
>
  -116.422    32.892
  -115.619    32.987
>
  -116.422    32.892
  -115.619    32.987
>
  -115.800    32.945
  -115.570    33.033
>
  -115.800    32.945
  -115.570    33.033
>
  -115.800    32.945
  -115.570    33.033
>
  -115.727    32.849
  -115.570    33.033
>
  -115.447    32.805
  -115.570    33.033
>
  -115.732    32.759
  -115.570    33.033
>
  -115.923    32.648
  -115.570    33.033
>
  -116.109    32.650
  -115.570    33.033
>
  -116.109    32.650
  -115.570    33.033
>
  -114.827    33.051
  -115.570    33.033
>
  -114.827    33.051
  -115.570    33.033
>
  -116.079    32.603
  -115.570    33.033
>
  -115.454    33.655
  -115.570    33.033
>
  -115.454    33.655
  -115.570    33.033
>
  -115.304    32.418
  -115.570    33.033
>
  -115.304    32.418
  -115.570    33.033
>
  -115.198    32.407
  -115.570    33.033
>
  -115.198    32.407
  -115.570    33.033
>
  -115.198    32.407
  -115.570    33.033
>
  -115.800    32.945
  -115.554    33.052
>
  -115.800    32.945
  -115.554    33.052
>
  -115.727    32.849
  -115.554    33.052
>
  -115.447    32.805
  -115.554    33.052
>
  -115.663    32.743
  -115.554    33.052
>
  -115.969    32.887
  -115.554    33.052
>
  -115.123    32.863
  -115.554    33.052
>
  -115.725    32.649
  -115.554    33.052
>
  -115.923    32.648
  -115.554    33.052
>
  -114.827    33.051
  -115.554    33.052
>
  -114.827    33.051
  -115.554    33.052
>
  -115.454    33.655
  -115.554    33.052
>
  -115.454    33.655
  -115.554    33.052
>
  -116.109    32.650
  -115.554    33.052
>
  -116.109    32.650
  -115.554    33.052
>
  -116.109    32.650
  -115.554    33.052
>
  -116.079    32.603
  -115.554    33.052
>
  -116.079    32.603
  -115.554    33.052
>
  -115.304    32.418
  -115.554    33.052
>
  -115.304    32.418
  -115.554    33.052
>
  -115.727    32.849
  -115.604    32.976
>
  -115.447    32.805
  -115.604    32.976
>
  -115.800    32.945
  -115.604    32.976
>
  -115.800    32.945
  -115.604    32.976
>
  -115.663    32.743
  -115.604    32.976
>
  -115.732    32.759
  -115.604    32.976
>
  -115.725    32.649
  -115.604    32.976
>
  -115.969    32.887
  -115.604    32.976
>
  -115.123    32.863
  -115.604    32.976
>
  -115.923    32.648
  -115.604    32.976
>
  -116.109    32.650
  -115.604    32.976
>
  -116.109    32.650
  -115.604    32.976
>
  -116.079    32.603
  -115.604    32.976
>
  -115.304    32.418
  -115.604    32.976
>
  -115.304    32.418
  -115.604    32.976
>
  -115.198    32.407
  -115.604    32.976
>
  -114.827    33.051
  -115.604    32.976
>
  -114.827    33.051
  -115.604    32.976
>
  -114.827    33.051
  -115.604    32.976
>
  -116.422    32.892
  -115.604    32.976
>
  -116.422    32.892
  -115.604    32.976
>
  -115.454    33.655
  -115.604    32.976
>
  -115.727    32.849
  -115.553    33.040
>
  -115.800    32.945
  -115.553    33.040
>
  -115.800    32.945
  -115.553    33.040
>
  -115.800    32.945
  -115.553    33.040
>
  -115.447    32.805
  -115.553    33.040
>
  -115.447    32.805
  -115.553    33.040
>
  -115.663    32.743
  -115.553    33.040
>
  -115.969    32.887
  -115.553    33.040
>
  -115.123    32.863
  -115.553    33.040
>
  -115.923    32.648
  -115.553    33.040
>
  -116.109    32.650
  -115.553    33.040
>
  -116.109    32.650
  -115.553    33.040
>
  -116.079    32.603
  -115.553    33.040
>
  -116.079    32.603
  -115.553    33.040
>
  -115.304    32.418
  -115.553    33.040
>
  -115.304    32.418
  -115.553    33.040
>
  -114.827    33.051
  -115.553    33.040
>
  -114.827    33.051
  -115.553    33.040
>
  -114.827    33.051
  -115.553    33.040
>
  -115.454    33.655
  -115.553    33.040
>
  -115.454    33.655
  -115.553    33.040
>
  -115.198    32.407
  -115.553    33.040
>
  -115.198    32.407
  -115.553    33.040
>
  -115.800    32.945
  -115.545    33.039
>
  -115.727    32.849
  -115.545    33.039
>
  -115.447    32.805
  -115.545    33.039
>
  -115.447    32.805
  -115.545    33.039
>
  -115.663    32.743
  -115.545    33.039
>
  -115.732    32.759
  -115.545    33.039
>
  -115.923    32.648
  -115.545    33.039
>
  -116.109    32.650
  -115.545    33.039
>
  -116.109    32.650
  -115.545    33.039
>
  -116.109    32.650
  -115.545    33.039
>
  -115.454    33.655
  -115.545    33.039
>
  -115.454    33.655
  -115.545    33.039
>
  -116.079    32.603
  -115.545    33.039
>
  -116.079    32.603
  -115.545    33.039
>
  -114.827    33.051
  -115.545    33.039
>
  -114.827    33.051
  -115.545    33.039
>
  -115.304    32.418
  -115.545    33.039
>
  -115.304    32.418
  -115.545    33.039
>
  -115.198    32.407
  -115.545    33.039
>
  -115.198    32.407
  -115.545    33.039
>
  -115.800    32.945
  -115.586    33.017
>
  -115.800    32.945
  -115.586    33.017
>
  -115.727    32.849
  -115.586    33.017
>
  -115.447    32.805
  -115.586    33.017
>
  -115.732    32.759
  -115.586    33.017
>
  -115.732    32.759
  -115.586    33.017
>
  -115.220    33.012
  -115.586    33.017
>
  -115.969    32.887
  -115.586    33.017
>
  -115.123    32.863
  -115.586    33.017
>
  -115.923    32.648
  -115.586    33.017
>
  -116.109    32.650
  -115.586    33.017
>
  -116.109    32.650
  -115.586    33.017
>
  -116.109    32.650
  -115.586    33.017
>
  -116.079    32.603
  -115.586    33.017
>
  -116.079    32.603
  -115.586    33.017
>
  -115.304    32.418
  -115.586    33.017
>
  -115.304    32.418
  -115.586    33.017
>
  -114.827    33.051
  -115.586    33.017
>
  -114.827    33.051
  -115.586    33.017
>
  -115.454    33.655
  -115.586    33.017
>
  -115.454    33.655
  -115.586    33.017
>
  -115.800    32.945
  -115.594    33.022
>
  -115.800    32.945
  -115.594    33.022
>
  -115.727    32.849
  -115.594    33.022
>
  -115.447    32.805
  -115.594    33.022
>
  -115.220    33.012
  -115.594    33.022
>
  -115.969    32.887
  -115.594    33.022
>
  -115.923    32.648
  -115.594    33.022
>
  -116.109    32.650
  -115.594    33.022
>
  -116.109    32.650
  -115.594    33.022
>
  -116.109    32.650
  -115.594    33.022
>
  -116.079    32.603
  -115.594    33.022
>
  -116.079    32.603
  -115.594    33.022
>
  -114.827    33.051
  -115.594    33.022
>
  -114.827    33.051
  -115.594    33.022
>
  -114.827    33.051
  -115.594    33.022
>
  -115.304    32.418
  -115.594    33.022
>
  -115.454    33.655
  -115.594    33.022
>
  -115.454    33.655
  -115.594    33.022
>
  -116.422    32.892
  -116.322    33.020
>
  -116.422    32.892
  -116.322    33.020
>
  -116.422    32.892
  -116.322    33.020
>
  -116.109    32.650
  -116.322    33.020
>
  -116.109    32.650
  -116.322    33.020
>
  -115.800    32.945
  -116.322    33.020
>
  -115.800    32.945
  -116.322    33.020
>
  -116.079    32.603
  -116.322    33.020
>
  -116.672    32.680
  -116.322    33.020
>
  -116.672    32.680
  -116.322    33.020
>
  -116.846    32.891
  -116.322    33.020
>
  -116.846    32.891
  -116.322    33.020
>
  -115.923    32.648
  -116.322    33.020
>
  -115.727    32.849
  -116.322    33.020
>
  -116.602    33.495
  -116.322    33.020
>
  -116.602    33.495
  -116.322    33.020
>
  -115.732    32.759
  -116.322    33.020
>
  -116.459    33.612
  -116.322    33.020
>
  -116.459    33.612
  -116.322    33.020
>
  -116.459    33.612
  -116.322    33.020
>
  -116.942    32.736
  -116.322    33.020
>
  -116.942    32.736
  -116.322    33.020
>
  -116.675    32.433
  -116.322    33.020
>
  -116.675    32.433
  -116.322    33.020
>
  -117.105    32.889
  -116.322    33.020
>
  -117.105    32.889
  -116.322    33.020
>
  -117.105    32.889
  -116.322    33.020
>
  -116.456    33.611
  -116.004    33.891
>
  -116.456    33.611
  -116.004    33.891
>
  -116.459    33.612
  -116.004    33.891
>
  -116.459    33.612
  -116.004    33.891
>
  -115.454    33.655
  -116.004    33.891
>
  -115.454    33.655
  -116.004    33.891
>
  -116.422    32.892
  -116.252    32.998
>
  -116.422    32.892
  -116.252    32.998
>
  -116.422    32.892
  -116.252    32.998
>
  -115.969    32.887
  -116.252    32.998
>
  -115.800    32.945
  -116.252    32.998
>
  -115.800    32.945
  -116.252    32.998
>
  -115.800    32.945
  -116.252    32.998
>
  -116.109    32.650
  -116.252    32.998
>
  -116.109    32.650
  -116.252    32.998
>
  -116.079    32.603
  -116.252    32.998
>
  -116.079    32.603
  -116.252    32.998
>
  -115.923    32.648
  -116.252    32.998
>
  -115.732    32.759
  -116.252    32.998
>
  -116.672    32.680
  -116.252    32.998
>
  -116.672    32.680
  -116.252    32.998
>
  -116.672    32.680
  -116.252    32.998
>
  -116.846    32.891
  -116.252    32.998
>
  -115.663    32.743
  -116.252    32.998
>
  -115.725    32.649
  -116.252    32.998
>
  -116.456    33.611
  -116.252    32.998
>
  -116.456    33.611
  -116.252    32.998
>
  -116.459    33.612
  -116.252    32.998
>
  -116.459    33.612
  -116.252    32.998
>
  -116.942    32.736
  -116.252    32.998
>
  -116.675    32.433
  -116.252    32.998
>
  -116.422    32.892
  -116.470    33.516
>
  -117.195    33.600
  -116.470    33.516
>
  -117.195    33.600
  -116.470    33.516
>
  -115.998    34.001
  -116.470    33.516
>
  -115.998    34.001
  -116.470    33.516
>
  -116.846    32.891
  -116.470    33.516
>
  -116.459    33.612
  -116.460    33.500
>
  -116.459    33.612
  -116.460    33.500
>
  -116.459    33.612
  -116.460    33.500
>
  -116.422    32.892
  -116.460    33.500
>
  -116.422    32.892
  -116.460    33.500
>
  -117.195    33.600
  -116.460    33.500
>
  -117.195    33.600
  -116.460    33.500
>
  -115.998    34.001
  -116.460    33.500
>
  -115.998    34.001
  -116.460    33.500
>
  -115.638    33.402
  -115.593    33.219
>
  -115.823    33.117
  -115.593    33.219
>
  -115.800    32.945
  -115.593    33.219
>
  -115.800    32.945
  -115.593    33.219
>
  -115.841    33.459
  -115.593    33.219
>
  -115.454    33.655
  -115.593    33.219
>
  -115.454    33.655
  -115.593    33.219
>
  -115.969    32.887
  -115.593    33.219
>
  -115.872    33.677
  -115.593    33.219
>
  -114.827    33.051
  -115.593    33.219
>
  -114.827    33.051
  -115.593    33.219
>
  -115.923    32.648
  -115.593    33.219
>
  -115.800    32.945
  -115.737    33.280
>
  -115.454    33.655
  -115.737    33.280
>
  -115.454    33.655
  -115.737    33.280
>
  -116.109    32.650
  -115.737    33.280
>
  -116.109    32.650
  -115.737    33.280
>
  -116.422    32.892
  -115.737    33.280
>
  -116.422    32.892
  -115.737    33.280
>
  -115.800    32.945
  -115.642    33.240
>
  -115.800    32.945
  -115.642    33.240
>
  -115.447    32.805
  -115.642    33.240
>
  -115.969    32.887
  -115.642    33.240
>
  -115.732    32.759
  -115.642    33.240
>
  -115.454    33.655
  -115.642    33.240
>
  -115.454    33.655
  -115.642    33.240
>
  -115.663    32.743
  -115.642    33.240
>
  -115.123    32.863
  -115.642    33.240
>
  -115.725    32.649
  -115.642    33.240
>
  -115.923    32.648
  -115.642    33.240
>
  -116.459    33.612
  -116.391    33.353
>
  -116.459    33.612
  -116.391    33.353
>
  -116.459    33.612
  -116.391    33.353
>
  -116.422    32.892
  -116.391    33.353
>
  -116.422    32.892
  -116.391    33.353
>
  -115.800    32.945
  -116.391    33.353
>
  -115.800    32.945
  -116.391    33.353
>
  -116.923    33.687
  -116.985    33.803
>
  -116.923    33.687
  -116.985    33.803
>
  -116.981    33.921
  -116.985    33.803
>
  -117.041    33.612
  -116.985    33.803
>
  -117.041    33.612
  -116.985    33.803
>
  -117.195    33.600
  -116.985    33.803
>
  -117.195    33.600
  -116.985    33.803
>
  -117.195    33.600
  -116.985    33.803
>
  -117.195    33.600
  -116.985    33.803
>
  -116.674    33.669
  -116.985    33.803
>
  -116.674    33.669
  -116.985    33.803
>
  -117.111    34.035
  -116.985    33.803
>
  -117.111    34.035
  -116.985    33.803
>
  -116.737    33.565
  -116.985    33.803
>
  -116.737    33.565
  -116.985    33.803
>
  -117.355    33.823
  -116.985    33.803
>
  -117.098    34.106
  -116.985    33.803
>
  -117.098    34.106
  -116.985    33.803
>
  -117.327    33.973
  -116.985    33.803
>
  -117.327    33.973
  -116.985    33.803
>
  -117.327    33.973
  -116.985    33.803
>
  -117.327    33.973
  -116.985    33.803
>
  -116.578    33.936
  -116.985    33.803
>
  -116.578    33.936
  -116.985    33.803
>
  -116.631    33.567
  -116.985    33.803
>
  -116.631    33.567
  -116.985    33.803
>
  -116.613    33.552
  -116.985    33.803
>
  -116.613    33.552
  -116.985    33.803
>
  -116.667    33.492
  -116.985    33.803
>
  -116.667    33.492
  -116.985    33.803
>
  -117.219    34.121
  -116.985    33.803
>
  -117.375    33.993
  -116.985    33.803
>
  -117.375    33.993
  -116.985    33.803
>
  -117.427    33.648
  -116.985    33.803
>
  -117.427    33.648
  -116.985    33.803
>
  -117.283    34.105
  -116.985    33.803
>
  -117.283    34.105
  -116.985    33.803
>
  -117.317    34.093
  -116.985    33.803
>
  -117.317    34.093
  -116.985    33.803
>
  -116.602    33.495
  -116.985    33.803
>
  -116.602    33.495
  -116.985    33.803
>
  -116.862    33.353
  -116.985    33.803
>
  -116.862    33.353
  -116.985    33.803
>
  -116.459    33.612
  -116.985    33.803
>
  -116.459    33.612
  -116.985    33.803
>
  -116.459    33.612
  -116.985    33.803
>
  -116.456    33.611
  -116.985    33.803
>
  -116.456    33.611
  -116.985    33.803
>
  -117.003    34.257
  -116.985    33.803
>
  -116.921    34.262
  -116.985    33.803
>
  -116.921    34.262
  -116.985    33.803
>
  -116.921    34.262
  -116.985    33.803
>
  -116.408    33.941
  -116.985    33.803
>
  -116.408    33.941
  -116.985    33.803
>
  -117.561    33.876
  -116.985    33.803
>
  -116.378    33.648
  -116.985    33.803
>
  -116.378    33.648
  -116.985    33.803
>
  -117.562    34.005
  -116.985    33.803
>
  -117.562    34.005
  -116.985    33.803
>
  -116.389    34.069
  -116.985    33.803
>
  -116.389    34.069
  -116.985    33.803
>
  -116.827    34.348
  -116.985    33.803
>
  -117.358    34.298
  -116.985    33.803
>
  -117.500    34.208
  -116.985    33.803
>
  -117.680    33.999
  -116.985    33.803
>
  -117.680    33.999
  -116.985    33.803
>
  -116.647    33.199
  -116.985    33.803
>
  -116.647    33.199
  -116.985    33.803
>
  -117.229    33.154
  -116.985    33.803
>
  -117.229    33.154
  -116.985    33.803
>
  -115.582    33.038
  -115.615    33.192
>
  -115.823    33.117
  -115.615    33.192
>
  -115.638    33.402
  -115.615    33.192
>
  -115.800    32.945
  -115.615    33.192
>
  -115.800    32.945
  -115.615    33.192
>
  -115.824    32.955
  -115.615    33.192
>
  -115.986    33.280
  -115.615    33.192
>
  -115.728    32.850
  -115.615    33.192
>
  -115.437    32.862
  -115.615    33.192
>
  -115.447    32.805
  -115.615    33.192
>
  -115.969    32.887
  -115.615    33.192
>
  -115.732    32.759
  -115.615    33.192
>
  -115.454    33.655
  -115.615    33.192
>
  -115.454    33.655
  -115.615    33.192
>
  -115.454    33.655
  -115.615    33.192
>
  -115.638    33.708
  -115.615    33.192
>
  -115.123    32.863
  -115.615    33.192
>
  -115.872    33.677
  -115.615    33.192
>
  -116.254    33.193
  -115.615    33.192
>
  -115.725    32.649
  -115.615    33.192
>
  -115.725    32.649
  -115.615    33.192
>
  -115.990    33.655
  -115.615    33.192
>
  -114.977    32.972
  -115.615    33.192
>
  -114.977    32.972
  -115.615    33.192
>
  -115.445    32.632
  -115.615    33.192
>
  -115.923    32.648
  -115.615    33.192
>
  -114.827    33.051
  -115.615    33.192
>
  -114.827    33.051
  -115.615    33.192
>
  -116.417    33.268
  -115.615    33.192
>
  -116.109    32.650
  -115.615    33.192
>
  -116.109    32.650
  -115.615    33.192
>
  -116.109    32.650
  -115.615    33.192
>
  -114.985    32.739
  -115.615    33.192
>
  -116.049    34.106
  -116.032    33.932
>
  -115.990    33.655
  -116.032    33.932
>
  -115.990    33.655
  -116.032    33.932
>
  -115.872    33.677
  -116.032    33.932
>
  -115.872    33.677
  -116.032    33.932
>
  -116.408    33.941
  -116.032    33.932
>
  -116.389    34.069
  -116.032    33.932
>
  -115.638    33.708
  -116.032    33.932
>
  -115.638    33.708
  -116.032    33.932
>
  -116.378    33.648
  -116.032    33.932
>
  -116.378    33.648
  -116.032    33.932
>
  -116.356    34.295
  -116.032    33.932
>
  -116.356    34.295
  -116.032    33.932
>
  -116.578    33.936
  -116.032    33.932
>
  -116.578    33.936
  -116.032    33.932
>
  -116.456    33.611
  -116.032    33.932
>
  -116.456    33.611
  -116.032    33.932
>
  -116.459    33.612
  -116.032    33.932
>
  -116.459    33.612
  -116.032    33.932
>
  -116.459    33.612
  -116.032    33.932
>
  -115.454    33.655
  -116.032    33.932
>
  -115.454    33.655
  -116.032    33.932
>
  -115.454    33.655
  -116.032    33.932
>
  -116.674    33.669
  -116.032    33.932
>
  -116.674    33.669
  -116.032    33.932
>
  -115.638    33.402
  -116.032    33.932
>
  -116.613    33.552
  -116.032    33.932
>
  -116.613    33.552
  -116.032    33.932
>
  -116.631    33.567
  -116.032    33.932
>
  -116.631    33.567
  -116.032    33.932
>
  -116.602    33.495
  -116.032    33.932
>
  -116.602    33.495
  -116.032    33.932
>
  -115.986    33.280
  -116.032    33.932
>
  -115.986    33.280
  -116.032    33.932
>
  -116.667    33.492
  -116.032    33.932
>
  -116.667    33.492
  -116.032    33.932
>
  -116.737    33.565
  -116.032    33.932
>
  -116.737    33.565
  -116.032    33.932
>
  -116.049    34.106
  -116.034    33.920
>
  -115.990    33.655
  -116.034    33.920
>
  -115.990    33.655
  -116.034    33.920
>
  -115.872    33.677
  -116.034    33.920
>
  -115.872    33.677
  -116.034    33.920
>
  -116.408    33.941
  -116.034    33.920
>
  -116.389    34.069
  -116.034    33.920
>
  -116.389    34.069
  -116.034    33.920
>
  -115.638    33.708
  -116.034    33.920
>
  -115.638    33.708
  -116.034    33.920
>
  -116.378    33.648
  -116.034    33.920
>
  -116.378    33.648
  -116.034    33.920
>
  -116.578    33.936
  -116.034    33.920
>
  -116.578    33.936
  -116.034    33.920
>
  -116.356    34.295
  -116.034    33.920
>
  -116.356    34.295
  -116.034    33.920
>
  -116.456    33.611
  -116.034    33.920
>
  -116.456    33.611
  -116.034    33.920
>
  -116.456    33.611
  -116.034    33.920
>
  -116.459    33.612
  -116.034    33.920
>
  -116.459    33.612
  -116.034    33.920
>
  -116.459    33.612
  -116.034    33.920
>
  -116.459    33.612
  -116.034    33.920
>
  -115.454    33.655
  -116.034    33.920
>
  -115.454    33.655
  -116.034    33.920
>
  -116.674    33.669
  -116.034    33.920
>
  -116.674    33.669
  -116.034    33.920
>
  -116.613    33.552
  -116.034    33.920
>
  -116.613    33.552
  -116.034    33.920
>
  -116.631    33.567
  -116.034    33.920
>
  -116.631    33.567
  -116.034    33.920
>
  -115.638    33.402
  -116.034    33.920
>
  -116.602    33.495
  -116.034    33.920
>
  -116.602    33.495
  -116.034    33.920
>
  -116.602    33.495
  -116.034    33.920
>
  -115.986    33.280
  -116.034    33.920
>
  -115.986    33.280
  -116.034    33.920
>
  -116.667    33.492
  -116.034    33.920
>
  -116.667    33.492
  -116.034    33.920
>
  -116.737    33.565
  -116.034    33.920
>
  -116.737    33.565
  -116.034    33.920
>
  -115.800    32.945
  -115.655    33.166
>
  -115.824    32.955
  -115.655    33.166
>
  -115.638    33.402
  -115.655    33.166
>
  -115.969    32.887
  -115.655    33.166
>
  -115.725    32.649
  -115.655    33.166
>
  -116.254    33.193
  -115.655    33.166
>
  -115.923    32.648
  -115.655    33.166
>
  -115.445    32.632
  -115.655    33.166
>
  -115.454    33.655
  -115.655    33.166
>
  -115.454    33.655
  -115.655    33.166
>
  -115.454    33.655
  -115.655    33.166
>
  -116.252    32.900
  -115.655    33.166
>
  -115.872    33.677
  -115.655    33.166
>
  -115.638    33.708
  -115.655    33.166
>
  -115.990    33.655
  -115.655    33.166
>
  -114.977    32.972
  -115.655    33.166
>
  -116.109    32.650
  -115.655    33.166
>
  -116.109    32.650
  -115.655    33.166
>
  -116.109    32.650
  -115.655    33.166
>
  -116.079    32.603
  -115.655    33.166
>
  -116.417    33.268
  -115.655    33.166
>
  -115.638    33.708
  -115.733    33.782
>
  -115.998    34.001
  -115.733    33.782
>
  -115.998    34.001
  -115.733    33.782
>
  -115.454    33.655
  -115.733    33.782
>
  -115.454    33.655
  -115.733    33.782
>
  -115.454    33.655
  -115.733    33.782
>
  -115.638    33.402
  -115.733    33.782
>
  -116.459    33.612
  -115.733    33.782
>
  -116.459    33.612
  -115.733    33.782
>
  -115.823    33.117
  -115.733    33.782
>
  -115.145    34.157
  -115.733    33.782
>
  -115.145    34.157
  -115.733    33.782
>
  -116.921    34.262
  -116.899    33.966
>
  -116.921    34.262
  -116.899    33.966
>
  -116.674    33.669
  -116.899    33.966
>
  -116.674    33.669
  -116.899    33.966
>
  -117.327    33.973
  -116.899    33.966
>
  -117.327    33.973
  -116.899    33.966
>
  -117.195    33.600
  -116.899    33.966
>
  -117.195    33.600
  -116.899    33.966
>
  -116.459    33.612
  -116.899    33.966
>
  -116.459    33.612
  -116.899    33.966
>
  -116.459    33.612
  -116.899    33.966
>
  -116.453    33.606
  -116.899    33.966
>
  -117.659    34.239
  -116.899    33.966
>
  -117.659    34.239
  -116.899    33.966
>
  -116.602    33.495
  -116.449    33.444
>
  -116.602    33.495
  -116.449    33.444
>
  -116.602    33.495
  -116.449    33.444
>
  -116.417    33.268
  -116.449    33.444
>
  -116.453    33.606
  -116.449    33.444
>
  -116.613    33.552
  -116.449    33.444
>
  -116.613    33.552
  -116.449    33.444
>
  -116.456    33.611
  -116.449    33.444
>
  -116.456    33.611
  -116.449    33.444
>
  -116.459    33.612
  -116.449    33.444
>
  -116.459    33.612
  -116.449    33.444
>
  -116.459    33.612
  -116.449    33.444
>
  -116.459    33.612
  -116.449    33.444
>
  -116.667    33.492
  -116.449    33.444
>
  -116.667    33.492
  -116.449    33.444
>
  -116.631    33.567
  -116.449    33.444
>
  -116.631    33.567
  -116.449    33.444
>
  -116.647    33.199
  -116.449    33.444
>
  -116.647    33.199
  -116.449    33.444
>
  -116.737    33.565
  -116.449    33.444
>
  -116.737    33.565
  -116.449    33.444
>
  -116.254    33.193
  -116.449    33.444
>
  -116.254    33.193
  -116.449    33.444
>
  -116.254    33.193
  -116.449    33.444
>
  -116.674    33.669
  -116.449    33.444
>
  -116.674    33.669
  -116.449    33.444
>
  -116.862    33.353
  -116.449    33.444
>
  -116.862    33.353
  -116.449    33.444
>
  -115.986    33.280
  -116.449    33.444
>
  -115.986    33.280
  -116.449    33.444
>
  -115.990    33.655
  -116.449    33.444
>
  -115.990    33.655
  -116.449    33.444
>
  -116.923    33.687
  -116.449    33.444
>
  -116.923    33.687
  -116.449    33.444
>
  -116.408    33.941
  -116.449    33.444
>
  -116.408    33.941
  -116.449    33.444
>
  -117.009    33.650
  -116.449    33.444
>
  -117.009    33.650
  -116.449    33.444
>
  -116.578    33.936
  -116.449    33.444
>
  -116.578    33.936
  -116.449    33.444
>
  -117.041    33.612
  -116.449    33.444
>
  -117.041    33.612
  -116.449    33.444
>
  -116.422    32.892
  -116.449    33.444
>
  -116.422    32.892
  -116.449    33.444
>
  -116.422    32.892
  -116.449    33.444
>
  -117.004    33.709
  -116.449    33.444
>
  -117.004    33.709
  -116.449    33.444
>
  -115.872    33.677
  -116.449    33.444
>
  -115.872    33.677
  -116.449    33.444
>
  -116.942    32.999
  -116.449    33.444
>
  -116.942    32.999
  -116.449    33.444
>
  -115.823    33.117
  -116.449    33.444
>
  -115.823    33.117
  -116.449    33.444
>
  -116.846    32.891
  -116.449    33.444
>
  -116.846    32.891
  -116.449    33.444
>
  -116.846    32.891
  -116.449    33.444
>
  -116.389    34.069
  -116.449    33.444
>
  -116.389    34.069
  -116.449    33.444
>
  -117.195    33.600
  -116.449    33.444
>
  -117.195    33.600
  -116.449    33.444
>
  -117.195    33.600
  -116.449    33.444
>
  -117.195    33.600
  -116.449    33.444
>
  -116.981    33.921
  -116.449    33.444
>
  -116.981    33.921
  -116.449    33.444
>
  -115.969    32.887
  -116.449    33.444
>
  -115.638    33.402
  -116.449    33.444
>
  -115.998    34.001
  -116.449    33.444
>
  -115.998    34.001
  -116.449    33.444
>
  -115.998    34.001
  -116.449    33.444
>
  -115.728    32.850
  -115.584    32.978
>
  -115.728    32.850
  -115.584    32.978
>
  -115.447    32.805
  -115.584    32.978
>
  -115.447    32.805
  -115.584    32.978
>
  -115.800    32.945
  -115.584    32.978
>
  -115.800    32.945
  -115.584    32.978
>
  -115.824    32.955
  -115.584    32.978
>
  -115.824    32.955
  -115.584    32.978
>
  -115.732    32.759
  -115.584    32.978
>
  -115.732    32.759
  -115.584    32.978
>
  -115.445    32.632
  -115.584    32.978
>
  -115.445    32.632
  -115.584    32.978
>
  -115.445    32.632
  -115.584    32.978
>
  -115.123    32.863
  -115.584    32.978
>
  -115.922    32.647
  -115.584    32.978
>
  -115.922    32.647
  -115.584    32.978
>
  -115.923    32.648
  -115.584    32.978
>
  -115.094    32.605
  -115.584    32.978
>
  -114.985    32.739
  -115.584    32.978
>
  -116.109    32.650
  -115.584    32.978
>
  -116.109    32.650
  -115.584    32.978
>
  -116.079    32.603
  -115.584    32.978
>
  -115.304    32.418
  -115.584    32.978
>
  -116.254    33.193
  -115.584    32.978
>
  -114.827    33.051
  -115.584    32.978
>
  -114.827    33.051
  -115.584    32.978
>
  -115.198    32.407
  -115.584    32.978
>
  -115.454    33.655
  -115.584    32.978
>
  -115.454    33.655
  -115.584    32.978
>
  -115.582    33.038
  -115.548    32.930
>
  -115.447    32.805
  -115.548    32.930
>
  -115.447    32.805
  -115.548    32.930
>
  -115.728    32.850
  -115.548    32.930
>
  -115.800    32.945
  -115.548    32.930
>
  -115.800    32.945
  -115.548    32.930
>
  -115.800    32.945
  -115.548    32.930
>
  -115.732    32.759
  -115.548    32.930
>
  -115.732    32.759
  -115.548    32.930
>
  -115.824    32.955
  -115.548    32.930
>
  -115.824    32.955
  -115.548    32.930
>
  -115.472    32.664
  -115.548    32.930
>
  -115.669    32.652
  -115.548    32.930
>
  -115.669    32.652
  -115.548    32.930
>
  -115.445    32.632
  -115.548    32.930
>
  -115.725    32.649
  -115.548    32.930
>
  -115.969    32.887
  -115.548    32.930
>
  -115.969    32.887
  -115.548    32.930
>
  -115.123    32.863
  -115.548    32.930
>
  -115.123    32.863
  -115.548    32.930
>
  -115.922    32.647
  -115.548    32.930
>
  -115.922    32.647
  -115.548    32.930
>
  -115.923    32.648
  -115.548    32.930
>
  -115.094    32.605
  -115.548    32.930
>
  -115.304    32.418
  -115.548    32.930
>
  -115.304    32.418
  -115.548    32.930
>
  -115.304    32.418
  -115.548    32.930
>
  -116.109    32.650
  -115.548    32.930
>
  -116.109    32.650
  -115.548    32.930
>
  -116.109    32.650
  -115.548    32.930
>
  -116.109    32.650
  -115.548    32.930
>
  -116.079    32.603
  -115.548    32.930
>
  -116.079    32.603
  -115.548    32.930
>
  -116.079    32.603
  -115.548    32.930
>
  -115.145    32.473
  -115.548    32.930
>
  -115.145    32.473
  -115.548    32.930
>
  -115.130    32.422
  -115.548    32.930
>
  -114.827    33.051
  -115.548    32.930
>
  -114.827    33.051
  -115.548    32.930
>
  -114.827    33.051
  -115.548    32.930
>
  -114.827    33.051
  -115.548    32.930
>
  -116.254    33.193
  -115.548    32.930
>
  -115.728    32.850
  -115.771    32.958
>
  -115.823    33.117
  -115.771    32.958
>
  -115.823    33.117
  -115.771    32.958
>
  -115.582    33.038
  -115.771    32.958
>
  -115.582    33.038
  -115.771    32.958
>
  -115.969    32.887
  -115.771    32.958
>
  -115.969    32.887
  -115.771    32.958
>
  -115.561    32.902
  -115.771    32.958
>
  -115.561    32.902
  -115.771    32.958
>
  -115.732    32.759
  -115.771    32.958
>
  -115.725    32.649
  -115.771    32.958
>
  -115.725    32.649
  -115.771    32.958
>
  -115.447    32.805
  -115.771    32.958
>
  -115.447    32.805
  -115.771    32.958
>
  -115.669    32.652
  -115.771    32.958
>
  -115.923    32.648
  -115.771    32.958
>
  -115.922    32.647
  -115.771    32.958
>
  -115.922    32.647
  -115.771    32.958
>
  -115.986    33.280
  -115.771    32.958
>
  -115.986    33.280
  -115.771    32.958
>
  -115.472    32.664
  -115.771    32.958
>
  -116.109    32.650
  -115.771    32.958
>
  -116.109    32.650
  -115.771    32.958
>
  -116.109    32.650
  -115.771    32.958
>
  -115.445    32.632
  -115.771    32.958
>
  -115.445    32.632
  -115.771    32.958
>
  -116.079    32.603
  -115.771    32.958
>
  -116.079    32.603
  -115.771    32.958
>
  -115.638    33.402
  -115.771    32.958
>
  -115.385    32.628
  -115.771    32.958
>
  -116.254    33.193
  -115.771    32.958
>
  -116.254    33.193
  -115.771    32.958
>
  -116.422    32.892
  -115.771    32.958
>
  -116.422    32.892
  -115.771    32.958
>
  -116.422    32.892
  -115.771    32.958
>
  -115.123    32.863
  -115.771    32.958
>
  -115.123    32.863
  -115.771    32.958
>
  -116.417    33.268
  -115.771    32.958
>
  -116.417    33.268
  -115.771    32.958
>
  -115.304    32.418
  -115.771    32.958
>
  -115.304    32.418
  -115.771    32.958
>
  -115.304    32.418
  -115.771    32.958
>
  -114.977    32.972
  -115.771    32.958
>
  -114.977    32.972
  -115.771    32.958
>
  -114.985    32.739
  -115.771    32.958
>
  -114.985    32.739
  -115.771    32.958
>
  -115.582    33.038
  -115.735    33.309
>
  -115.582    33.038
  -115.735    33.309
>
  -115.824    32.955
  -115.735    33.309
>
  -115.824    32.955
  -115.735    33.309
>
  -115.800    32.945
  -115.735    33.309
>
  -115.800    32.945
  -115.735    33.309
>
  -115.800    32.945
  -115.735    33.309
>
  -115.561    32.902
  -115.735    33.309
>
  -115.561    32.902
  -115.735    33.309
>
  -115.872    33.677
  -115.735    33.309
>
  -115.872    33.677
  -115.735    33.309
>
  -115.638    33.708
  -115.735    33.309
>
  -115.638    33.708
  -115.735    33.309
>
  -115.728    32.850
  -115.735    33.309
>
  -115.728    32.850
  -115.735    33.309
>
  -115.990    33.655
  -115.735    33.309
>
  -115.990    33.655
  -115.735    33.309
>
  -115.454    33.655
  -115.735    33.309
>
  -115.454    33.655
  -115.735    33.309
>
  -115.454    33.655
  -115.735    33.309
>
  -115.969    32.887
  -115.735    33.309
>
  -116.254    33.193
  -115.735    33.309
>
  -116.254    33.193
  -115.735    33.309
>
  -115.437    32.862
  -115.735    33.309
>
  -115.437    32.862
  -115.735    33.309
>
  -115.732    32.759
  -115.735    33.309
>
  -115.732    32.759
  -115.735    33.309
>
  -115.447    32.805
  -115.735    33.309
>
  -115.447    32.805
  -115.735    33.309
>
  -116.417    33.268
  -115.735    33.309
>
  -116.417    33.268
  -115.735    33.309
>
  -115.725    32.649
  -115.735    33.309
>
  -115.725    32.649
  -115.735    33.309
>
  -115.923    32.648
  -115.735    33.309
>
  -115.923    32.648
  -115.735    33.309
>
  -115.123    32.863
  -115.735    33.309
>
  -115.123    32.863
  -115.735    33.309
>
  -116.378    33.648
  -115.735    33.309
>
  -116.378    33.648
  -115.735    33.309
>
  -116.453    33.606
  -115.735    33.309
>
  -116.456    33.611
  -115.735    33.309
>
  -116.456    33.611
  -115.735    33.309
>
  -116.459    33.612
  -115.735    33.309
>
  -116.459    33.612
  -115.735    33.309
>
  -115.823    33.117
  -115.735    33.302
>
  -115.986    33.280
  -115.735    33.302
>
  -115.582    33.038
  -115.735    33.302
>
  -115.582    33.038
  -115.735    33.302
>
  -115.824    32.955
  -115.735    33.302
>
  -115.800    32.945
  -115.735    33.302
>
  -115.800    32.945
  -115.735    33.302
>
  -115.872    33.677
  -115.735    33.302
>
  -115.872    33.677
  -115.735    33.302
>
  -115.561    32.902
  -115.735    33.302
>
  -115.638    33.708
  -115.735    33.302
>
  -115.638    33.708
  -115.735    33.302
>
  -115.454    33.655
  -115.735    33.302
>
  -115.454    33.655
  -115.735    33.302
>
  -115.990    33.655
  -115.735    33.302
>
  -115.990    33.655
  -115.735    33.302
>
  -115.728    32.850
  -115.735    33.302
>
  -115.728    32.850
  -115.735    33.302
>
  -115.969    32.887
  -115.735    33.302
>
  -115.969    32.887
  -115.735    33.302
>
  -116.254    33.193
  -115.735    33.302
>
  -116.254    33.193
  -115.735    33.302
>
  -115.437    32.862
  -115.735    33.302
>
  -115.437    32.862
  -115.735    33.302
>
  -115.732    32.759
  -115.735    33.302
>
  -115.732    32.759
  -115.735    33.302
>
  -115.447    32.805
  -115.735    33.302
>
  -115.447    32.805
  -115.735    33.302
>
  -116.417    33.268
  -115.735    33.302
>
  -115.725    32.649
  -115.735    33.302
>
  -115.725    32.649
  -115.735    33.302
>
  -116.378    33.648
  -115.735    33.302
>
  -116.378    33.648
  -115.735    33.302
>
  -115.123    32.863
  -115.735    33.302
>
  -115.123    32.863
  -115.735    33.302
>
  -115.923    32.648
  -115.735    33.302
>
  -115.923    32.648
  -115.735    33.302
>
  -116.453    33.606
  -115.735    33.302
>
  -116.453    33.606
  -115.735    33.302
>
  -116.456    33.611
  -115.735    33.302
>
  -116.456    33.611
  -115.735    33.302
>
  -116.459    33.612
  -115.735    33.302
>
  -116.459    33.612
  -115.735    33.302
>
  -115.823    33.117
  -115.718    33.313
>
  -115.823    33.117
  -115.718    33.313
>
  -115.986    33.280
  -115.718    33.313
>
  -115.986    33.280
  -115.718    33.313
>
  -115.582    33.038
  -115.718    33.313
>
  -115.824    32.955
  -115.718    33.313
>
  -115.800    32.945
  -115.718    33.313
>
  -115.800    32.945
  -115.718    33.313
>
  -115.800    32.945
  -115.718    33.313
>
  -115.872    33.677
  -115.718    33.313
>
  -115.872    33.677
  -115.718    33.313
>
  -115.638    33.708
  -115.718    33.313
>
  -115.638    33.708
  -115.718    33.313
>
  -115.454    33.655
  -115.718    33.313
>
  -115.454    33.655
  -115.718    33.313
>
  -115.454    33.655
  -115.718    33.313
>
  -115.454    33.655
  -115.718    33.313
>
  -115.990    33.655
  -115.718    33.313
>
  -115.990    33.655
  -115.718    33.313
>
  -115.561    32.902
  -115.718    33.313
>
  -115.728    32.850
  -115.718    33.313
>
  -116.254    33.193
  -115.718    33.313
>
  -116.254    33.193
  -115.718    33.313
>
  -115.969    32.887
  -115.718    33.313
>
  -115.969    32.887
  -115.718    33.313
>
  -115.732    32.759
  -115.718    33.313
>
  -115.732    32.759
  -115.718    33.313
>
  -115.447    32.805
  -115.718    33.313
>
  -115.447    32.805
  -115.718    33.313
>
  -116.417    33.268
  -115.718    33.313
>
  -116.417    33.268
  -115.718    33.313
>
  -116.378    33.648
  -115.718    33.313
>
  -116.378    33.648
  -115.718    33.313
>
  -115.725    32.649
  -115.718    33.313
>
  -115.725    32.649
  -115.718    33.313
>
  -115.123    32.863
  -115.718    33.313
>
  -115.923    32.648
  -115.718    33.313
>
  -115.923    32.648
  -115.718    33.313
>
  -116.453    33.606
  -115.718    33.313
>
  -116.453    33.606
  -115.718    33.313
>
  -116.456    33.611
  -115.718    33.313
>
  -116.456    33.611
  -115.718    33.313
>
  -116.459    33.612
  -115.718    33.313
>
  -116.459    33.612
  -115.718    33.313
>
  -116.459    33.612
  -115.718    33.313
>
  -115.823    33.117
  -115.739    33.302
>
  -115.823    33.117
  -115.739    33.302
>
  -115.986    33.280
  -115.739    33.302
>
  -115.986    33.280
  -115.739    33.302
>
  -115.582    33.038
  -115.739    33.302
>
  -115.582    33.038
  -115.739    33.302
>
  -115.824    32.955
  -115.739    33.302
>
  -115.800    32.945
  -115.739    33.302
>
  -115.872    33.677
  -115.739    33.302
>
  -115.872    33.677
  -115.739    33.302
>
  -115.638    33.708
  -115.739    33.302
>
  -115.990    33.655
  -115.739    33.302
>
  -115.990    33.655
  -115.739    33.302
>
  -115.454    33.655
  -115.739    33.302
>
  -115.454    33.655
  -115.739    33.302
>
  -115.454    33.655
  -115.739    33.302
>
  -115.561    32.902
  -115.739    33.302
>
  -115.561    32.902
  -115.739    33.302
>
  -115.728    32.850
  -115.739    33.302
>
  -115.728    32.850
  -115.739    33.302
>
  -116.254    33.193
  -115.739    33.302
>
  -116.254    33.193
  -115.739    33.302
>
  -115.969    32.887
  -115.739    33.302
>
  -115.969    32.887
  -115.739    33.302
>
  -115.437    32.862
  -115.739    33.302
>
  -115.437    32.862
  -115.739    33.302
>
  -115.732    32.759
  -115.739    33.302
>
  -115.732    32.759
  -115.739    33.302
>
  -115.447    32.805
  -115.739    33.302
>
  -115.447    32.805
  -115.739    33.302
>
  -116.417    33.268
  -115.739    33.302
>
  -116.417    33.268
  -115.739    33.302
>
  -116.378    33.648
  -115.739    33.302
>
  -116.378    33.648
  -115.739    33.302
>
  -115.725    32.649
  -115.739    33.302
>
  -115.725    32.649
  -115.739    33.302
>
  -115.123    32.863
  -115.739    33.302
>
  -115.123    32.863
  -115.739    33.302
>
  -115.923    32.648
  -115.739    33.302
>
  -115.923    32.648
  -115.739    33.302
>
  -116.453    33.606
  -115.739    33.302
>
  -116.456    33.611
  -115.739    33.302
>
  -116.456    33.611
  -115.739    33.302
>
  -116.459    33.612
  -115.739    33.302
>
  -116.459    33.612
  -115.739    33.302
>
  -116.459    33.612
  -115.739    33.302
>
  -116.459    33.612
  -115.739    33.302
>
  -115.823    33.117
  -115.738    33.303
>
  -115.986    33.280
  -115.738    33.303
>
  -115.986    33.280
  -115.738    33.303
>
  -115.582    33.038
  -115.738    33.303
>
  -115.582    33.038
  -115.738    33.303
>
  -115.824    32.955
  -115.738    33.303
>
  -115.800    32.945
  -115.738    33.303
>
  -115.872    33.677
  -115.738    33.303
>
  -115.638    33.708
  -115.738    33.303
>
  -115.990    33.655
  -115.738    33.303
>
  -115.561    32.902
  -115.738    33.303
>
  -115.454    33.655
  -115.738    33.303
>
  -115.454    33.655
  -115.738    33.303
>
  -115.454    33.655
  -115.738    33.303
>
  -115.728    32.850
  -115.738    33.303
>
  -115.728    32.850
  -115.738    33.303
>
  -116.254    33.193
  -115.738    33.303
>
  -115.969    32.887
  -115.738    33.303
>
  -115.437    32.862
  -115.738    33.303
>
  -115.732    32.759
  -115.738    33.303
>
  -115.732    32.759
  -115.738    33.303
>
  -115.447    32.805
  -115.738    33.303
>
  -116.417    33.268
  -115.738    33.303
>
  -116.378    33.648
  -115.738    33.303
>
  -116.378    33.648
  -115.738    33.303
>
  -115.725    32.649
  -115.738    33.303
>
  -115.923    32.648
  -115.738    33.303
>
  -115.923    32.648
  -115.738    33.303
>
  -115.123    32.863
  -115.738    33.303
>
  -116.456    33.611
  -115.738    33.303
>
  -116.456    33.611
  -115.738    33.303
>
  -116.459    33.612
  -115.738    33.303
>
  -116.459    33.612
  -115.738    33.303
>
  -116.459    33.612
  -115.738    33.303
>
  -116.459    33.612
  -115.738    33.303
>
  -116.459    33.612
  -115.738    33.303
>
  -115.582    33.038
  -115.587    33.190
>
  -115.582    33.038
  -115.587    33.190
>
  -115.800    32.945
  -115.587    33.190
>
  -115.800    32.945
  -115.587    33.190
>
  -115.800    32.945
  -115.587    33.190
>
  -115.824    32.955
  -115.587    33.190
>
  -115.824    32.955
  -115.587    33.190
>
  -115.437    32.862
  -115.587    33.190
>
  -115.437    32.862
  -115.587    33.190
>
  -115.986    33.280
  -115.587    33.190
>
  -115.986    33.280
  -115.587    33.190
>
  -115.728    32.850
  -115.587    33.190
>
  -115.728    32.850
  -115.587    33.190
>
  -115.447    32.805
  -115.587    33.190
>
  -115.447    32.805
  -115.587    33.190
>
  -115.969    32.887
  -115.587    33.190
>
  -115.969    32.887
  -115.587    33.190
>
  -115.732    32.759
  -115.587    33.190
>
  -115.732    32.759
  -115.587    33.190
>
  -115.454    33.655
  -115.587    33.190
>
  -115.454    33.655
  -115.587    33.190
>
  -115.123    32.863
  -115.587    33.190
>
  -115.123    32.863
  -115.587    33.190
>
  -115.638    33.708
  -115.587    33.190
>
  -115.638    33.708
  -115.587    33.190
>
  -115.725    32.649
  -115.587    33.190
>
  -115.725    32.649
  -115.587    33.190
>
  -115.872    33.677
  -115.587    33.190
>
  -115.872    33.677
  -115.587    33.190
>
  -114.977    32.972
  -115.587    33.190
>
  -114.977    32.972
  -115.587    33.190
>
  -116.254    33.193
  -115.587    33.190
>
  -116.254    33.193
  -115.587    33.190
>
  -115.445    32.632
  -115.587    33.190
>
  -115.445    32.632
  -115.587    33.190
>
  -115.990    33.655
  -115.587    33.190
>
  -115.990    33.655
  -115.587    33.190
>
  -115.923    32.648
  -115.587    33.190
>
  -115.923    32.648
  -115.587    33.190
>
  -114.827    33.051
  -115.587    33.190
>
  -114.827    33.051
  -115.587    33.190
>
  -114.827    33.051
  -115.587    33.190
>
  -114.985    32.739
  -115.587    33.190
>
  -114.985    32.739
  -115.587    33.190
>
  -116.109    32.650
  -115.587    33.190
>
  -116.109    32.650
  -115.587    33.190
>
  -116.109    32.650
  -115.587    33.190
>
  -115.437    32.862
  -115.557    32.985
>
  -115.437    32.862
  -115.557    32.985
>
  -115.728    32.850
  -115.557    32.985
>
  -115.728    32.850
  -115.557    32.985
>
  -115.447    32.805
  -115.557    32.985
>
  -115.447    32.805
  -115.557    32.985
>
  -115.800    32.945
  -115.557    32.985
>
  -115.800    32.945
  -115.557    32.985
>
  -115.800    32.945
  -115.557    32.985
>
  -115.824    32.955
  -115.557    32.985
>
  -115.823    33.117
  -115.557    32.985
>
  -115.823    33.117
  -115.557    32.985
>
  -115.732    32.759
  -115.557    32.985
>
  -115.445    32.632
  -115.557    32.985
>
  -115.445    32.632
  -115.557    32.985
>
  -115.725    32.649
  -115.557    32.985
>
  -115.725    32.649
  -115.557    32.985
>
  -115.969    32.887
  -115.557    32.985
>
  -115.969    32.887
  -115.557    32.985
>
  -115.385    32.628
  -115.557    32.985
>
  -115.123    32.863
  -115.557    32.985
>
  -115.123    32.863
  -115.557    32.985
>
  -115.923    32.648
  -115.557    32.985
>
  -115.923    32.648
  -115.557    32.985
>
  -115.922    32.647
  -115.557    32.985
>
  -115.986    33.280
  -115.557    32.985
>
  -115.986    33.280
  -115.557    32.985
>
  -114.977    32.972
  -115.557    32.985
>
  -114.977    32.972
  -115.557    32.985
>
  -114.985    32.739
  -115.557    32.985
>
  -116.109    32.650
  -115.557    32.985
>
  -116.109    32.650
  -115.557    32.985
>
  -116.079    32.603
  -115.557    32.985
>
  -116.079    32.603
  -115.557    32.985
>
  -115.304    32.418
  -115.557    32.985
>
  -115.304    32.418
  -115.557    32.985
>
  -114.827    33.051
  -115.557    32.985
>
  -114.827    33.051
  -115.557    32.985
>
  -114.827    33.051
  -115.557    32.985
>
  -114.827    33.051
  -115.557    32.985
>
  -116.254    33.193
  -115.557    32.985
>
  -116.254    33.193
  -115.557    32.985
>
  -115.454    33.655
  -115.557    32.985
>
  -115.454    33.655
  -115.557    32.985
>
  -115.454    33.655
  -115.557    32.985
>
  -115.437    32.862
  -115.559    32.986
>
  -115.437    32.862
  -115.559    32.986
>
  -115.728    32.850
  -115.559    32.986
>
  -115.728    32.850
  -115.559    32.986
>
  -115.447    32.805
  -115.559    32.986
>
  -115.447    32.805
  -115.559    32.986
>
  -115.800    32.945
  -115.559    32.986
>
  -115.800    32.945
  -115.559    32.986
>
  -115.800    32.945
  -115.559    32.986
>
  -115.800    32.945
  -115.559    32.986
>
  -115.732    32.759
  -115.559    32.986
>
  -115.732    32.759
  -115.559    32.986
>
  -115.823    33.117
  -115.559    32.986
>
  -115.823    33.117
  -115.559    32.986
>
  -115.725    32.649
  -115.559    32.986
>
  -115.969    32.887
  -115.559    32.986
>
  -115.969    32.887
  -115.559    32.986
>
  -115.445    32.632
  -115.559    32.986
>
  -115.445    32.632
  -115.559    32.986
>
  -115.445    32.632
  -115.559    32.986
>
  -115.385    32.628
  -115.559    32.986
>
  -115.385    32.628
  -115.559    32.986
>
  -115.123    32.863
  -115.559    32.986
>
  -115.123    32.863
  -115.559    32.986
>
  -115.923    32.648
  -115.559    32.986
>
  -115.923    32.648
  -115.559    32.986
>
  -115.922    32.647
  -115.559    32.986
>
  -115.986    33.280
  -115.559    32.986
>
  -115.986    33.280
  -115.559    32.986
>
  -114.977    32.972
  -115.559    32.986
>
  -114.977    32.972
  -115.559    32.986
>
  -115.094    32.605
  -115.559    32.986
>
  -114.985    32.739
  -115.559    32.986
>
  -114.985    32.739
  -115.559    32.986
>
  -114.985    32.739
  -115.559    32.986
>
  -116.109    32.650
  -115.559    32.986
>
  -116.109    32.650
  -115.559    32.986
>
  -116.109    32.650
  -115.559    32.986
>
  -116.079    32.603
  -115.559    32.986
>
  -116.079    32.603
  -115.559    32.986
>
  -116.079    32.603
  -115.559    32.986
>
  -115.304    32.418
  -115.559    32.986
>
  -115.304    32.418
  -115.559    32.986
>
  -115.304    32.418
  -115.559    32.986
>
  -115.145    32.473
  -115.559    32.986
>
  -114.827    33.051
  -115.559    32.986
>
  -114.827    33.051
  -115.559    32.986
>
  -114.827    33.051
  -115.559    32.986
>
  -116.254    33.193
  -115.559    32.986
>
  -116.254    33.193
  -115.559    32.986
>
  -115.454    33.655
  -115.559    32.986
>
  -115.454    33.655
  -115.559    32.986
>
  -116.254    33.193
  -116.049    33.245
>
  -116.254    33.193
  -116.049    33.245
>
  -115.730    33.365
  -116.049    33.245
>
  -115.730    33.365
  -116.049    33.245
>
  -116.417    33.268
  -116.049    33.245
>
  -116.417    33.268
  -116.049    33.245
>
  -115.824    32.955
  -116.049    33.245
>
  -115.824    32.955
  -116.049    33.245
>
  -115.969    32.887
  -116.049    33.245
>
  -115.969    32.887
  -116.049    33.245
>
  -115.800    32.945
  -116.049    33.245
>
  -115.800    32.945
  -116.049    33.245
>
  -115.800    32.945
  -116.049    33.245
>
  -115.580    33.121
  -116.049    33.245
>
  -115.580    33.121
  -116.049    33.245
>
  -115.990    33.655
  -116.049    33.245
>
  -115.990    33.655
  -116.049    33.245
>
  -116.422    32.892
  -116.049    33.245
>
  -116.422    32.892
  -116.049    33.245
>
  -116.422    32.892
  -116.049    33.245
>
  -115.728    32.850
  -116.049    33.245
>
  -115.728    32.850
  -116.049    33.245
>
  -115.872    33.677
  -116.049    33.245
>
  -115.872    33.677
  -116.049    33.245
>
  -116.598    33.081
  -116.049    33.245
>
  -116.598    33.081
  -116.049    33.245
>
  -116.647    33.199
  -116.049    33.245
>
  -116.647    33.199
  -116.049    33.245
>
  -116.378    33.648
  -116.049    33.245
>
  -116.378    33.648
  -116.049    33.245
>
  -116.456    33.611
  -116.049    33.245
>
  -116.456    33.611
  -116.049    33.245
>
  -115.561    32.902
  -116.049    33.245
>
  -116.459    33.612
  -116.049    33.245
>
  -116.459    33.612
  -116.049    33.245
>
  -115.732    32.759
  -116.049    33.245
>
  -115.732    32.759
  -116.049    33.245
>
  -116.602    33.495
  -116.049    33.245
>
  -116.602    33.495
  -116.049    33.245
>
  -116.602    33.495
  -116.049    33.245
>
  -115.638    33.708
  -116.049    33.245
>
  -115.638    33.708
  -116.049    33.245
>
  -116.109    32.650
  -116.049    33.245
>
  -116.109    32.650
  -116.049    33.245
>
  -116.613    33.552
  -116.049    33.245
>
  -116.613    33.552
  -116.049    33.245
>
  -115.923    32.648
  -116.049    33.245
>
  -115.923    32.648
  -116.049    33.245
>
  -116.667    33.492
  -116.049    33.245
>
  -116.667    33.492
  -116.049    33.245
>
  -116.631    33.567
  -116.049    33.245
>
  -116.631    33.567
  -116.049    33.245
>
  -116.079    32.603
  -116.049    33.245
>
  -116.079    32.603
  -116.049    33.245
>
  -115.454    33.655
  -116.049    33.245
>
  -115.454    33.655
  -116.049    33.245
>
  -115.454    33.655
  -116.049    33.245
>
  -116.737    33.565
  -116.049    33.245
>
  -116.737    33.565
  -116.049    33.245
>
  -116.674    33.669
  -116.049    33.245
>
  -116.674    33.669
  -116.049    33.245
>
  -116.862    33.353
  -116.049    33.245
>
  -116.862    33.353
  -116.049    33.245
>
  -115.823    33.117
  -115.669    33.163
>
  -115.582    33.038
  -115.669    33.163
>
  -115.582    33.038
  -115.669    33.163
>
  -115.730    33.365
  -115.669    33.163
>
  -115.800    32.945
  -115.669    33.163
>
  -115.800    32.945
  -115.669    33.163
>
  -115.800    32.945
  -115.669    33.163
>
  -115.824    32.955
  -115.669    33.163
>
  -115.824    32.955
  -115.669    33.163
>
  -115.561    32.902
  -115.669    33.163
>
  -115.561    32.902
  -115.669    33.163
>
  -115.986    33.280
  -115.669    33.163
>
  -115.728    32.850
  -115.669    33.163
>
  -115.728    32.850
  -115.669    33.163
>
  -115.437    32.862
  -115.669    33.163
>
  -115.437    32.862
  -115.669    33.163
>
  -115.969    32.887
  -115.669    33.163
>
  -115.969    32.887
  -115.669    33.163
>
  -115.447    32.805
  -115.669    33.163
>
  -115.732    32.759
  -115.669    33.163
>
  -116.254    33.193
  -115.669    33.163
>
  -116.254    33.193
  -115.669    33.163
>
  -115.725    32.649
  -115.669    33.163
>
  -115.725    32.649
  -115.669    33.163
>
  -115.454    33.655
  -115.669    33.163
>
  -115.454    33.655
  -115.669    33.163
>
  -115.454    33.655
  -115.669    33.163
>
  -115.338    32.693
  -115.669    33.163
>
  -115.872    33.677
  -115.669    33.163
>
  -115.123    32.863
  -115.669    33.163
>
  -115.123    32.863
  -115.669    33.163
>
  -115.638    33.708
  -115.669    33.163
>
  -115.638    33.708
  -115.669    33.163
>
  -115.923    32.648
  -115.669    33.163
>
  -115.445    32.632
  -115.669    33.163
>
  -115.990    33.655
  -115.669    33.163
>
  -115.990    33.655
  -115.669    33.163
>
  -114.977    32.972
  -115.669    33.163
>
  -116.109    32.650
  -115.669    33.163
>
  -116.109    32.650
  -115.669    33.163
>
  -116.417    33.268
  -115.669    33.163
>
  -116.079    32.603
  -115.669    33.163
>
  -116.079    32.603
  -115.669    33.163
>
  -116.422    32.892
  -115.669    33.163
>
  -116.422    32.892
  -115.669    33.163
>
  -116.598    33.081
  -116.485    33.157
>
  -116.598    33.081
  -116.485    33.157
>
  -116.417    33.268
  -116.485    33.157
>
  -116.417    33.268
  -116.485    33.157
>
  -116.647    33.199
  -116.485    33.157
>
  -116.647    33.199
  -116.485    33.157
>
  -116.254    33.193
  -116.485    33.157
>
  -116.254    33.193
  -116.485    33.157
>
  -116.254    33.193
  -116.485    33.157
>
  -116.422    32.892
  -116.485    33.157
>
  -116.422    32.892
  -116.485    33.157
>
  -116.422    32.892
  -116.485    33.157
>
  -116.422    32.892
  -116.485    33.157
>
  -116.422    32.892
  -116.485    33.157
>
  -116.602    33.495
  -116.485    33.157
>
  -116.602    33.495
  -116.485    33.157
>
  -116.667    33.492
  -116.485    33.157
>
  -116.667    33.492
  -116.485    33.157
>
  -116.862    33.353
  -116.485    33.157
>
  -116.846    32.891
  -116.485    33.157
>
  -116.846    32.891
  -116.485    33.157
>
  -116.846    32.891
  -116.485    33.157
>
  -116.942    32.999
  -116.485    33.157
>
  -116.613    33.552
  -116.485    33.157
>
  -116.631    33.567
  -116.485    33.157
>
  -116.456    33.611
  -116.485    33.157
>
  -116.459    33.612
  -116.485    33.157
>
  -116.459    33.612
  -116.485    33.157
>
  -116.737    33.565
  -116.485    33.157
>
  -116.737    33.565
  -116.485    33.157
>
  -116.672    32.680
  -116.485    33.157
>
  -116.672    32.680
  -116.485    33.157
>
  -116.672    32.680
  -116.485    33.157
>
  -116.672    32.680
  -116.485    33.157
>
  -115.969    32.887
  -116.485    33.157
>
  -115.969    32.887
  -116.485    33.157
>
  -116.378    33.648
  -116.485    33.157
>
  -116.378    33.648
  -116.485    33.157
>
  -116.674    33.669
  -116.485    33.157
>
  -115.823    33.117
  -116.485    33.157
>
  -115.823    33.117
  -116.485    33.157
>
  -116.942    32.736
  -116.485    33.157
>
  -116.942    32.736
  -116.485    33.157
>
  -116.942    32.736
  -116.485    33.157
>
  -115.824    32.955
  -116.485    33.157
>
  -115.824    32.955
  -116.485    33.157
>
  -116.109    32.650
  -116.485    33.157
>
  -116.109    32.650
  -116.485    33.157
>
  -116.109    32.650
  -116.485    33.157
>
  -117.057    32.820
  -116.485    33.157
>
  -117.057    32.820
  -116.485    33.157
>
  -116.607    32.569
  -116.485    33.157
>
  -116.607    32.569
  -116.485    33.157
>
  -117.105    32.889
  -116.485    33.157
>
  -117.105    32.889
  -116.485    33.157
>
  -117.105    32.889
  -116.485    33.157
>
  -117.105    32.889
  -116.485    33.157
>
  -116.775    32.607
  -116.485    33.157
>
  -116.775    32.607
  -116.485    33.157
>
  -115.800    32.945
  -116.485    33.157
>
  -115.800    32.945
  -116.485    33.157
>
  -115.800    32.945
  -116.485    33.157
>
  -117.229    33.154
  -116.485    33.157
>
  -117.229    33.154
  -116.485    33.157
>
  -116.079    32.603
  -116.485    33.157
>
  -116.079    32.603
  -116.485    33.157
>
  -115.990    33.655
  -116.485    33.157
>
  -115.990    33.655
  -116.485    33.157
>
  -116.923    33.687
  -116.485    33.157
>
  -116.923    33.687
  -116.485    33.157
>
  -116.930    32.608
  -116.485    33.157
>
  -116.930    32.608
  -116.485    33.157
>
  -116.930    32.608
  -116.485    33.157
>
  -116.930    32.608
  -116.485    33.157
>
  -117.138    32.784
  -116.485    33.157
>
  -117.009    33.650
  -116.485    33.157
>
  -117.009    33.650
  -116.485    33.157
>
  -115.923    32.648
  -116.485    33.157
>
  -115.922    32.647
  -116.485    33.157
>
  -116.613    33.552
  -116.514    33.495
>
  -116.613    33.552
  -116.514    33.495
>
  -116.459    33.612
  -116.514    33.495
>
  -116.459    33.612
  -116.514    33.495
>
  -116.459    33.612
  -116.514    33.495
>
  -116.456    33.611
  -116.514    33.495
>
  -116.456    33.611
  -116.514    33.495
>
  -116.631    33.567
  -116.514    33.495
>
  -116.631    33.567
  -116.514    33.495
>
  -116.667    33.492
  -116.514    33.495
>
  -116.667    33.492
  -116.514    33.495
>
  -116.378    33.648
  -116.514    33.495
>
  -116.417    33.268
  -116.514    33.495
>
  -116.417    33.268
  -116.514    33.495
>
  -116.737    33.565
  -116.514    33.495
>
  -116.737    33.565
  -116.514    33.495
>
  -116.674    33.669
  -116.514    33.495
>
  -116.674    33.669
  -116.514    33.495
>
  -116.647    33.199
  -116.514    33.495
>
  -116.647    33.199
  -116.514    33.495
>
  -116.254    33.193
  -116.514    33.495
>
  -116.254    33.193
  -116.514    33.495
>
  -116.598    33.081
  -116.514    33.495
>
  -116.923    33.687
  -116.514    33.495
>
  -116.923    33.687
  -116.514    33.495
>
  -116.578    33.936
  -116.514    33.495
>
  -116.408    33.941
  -116.514    33.495
>
  -117.041    33.612
  -116.514    33.495
>
  -117.004    33.709
  -116.514    33.495
>
  -115.872    33.677
  -116.514    33.495
>
  -115.872    33.677
  -116.514    33.495
>
  -116.422    32.892
  -116.514    33.495
>
  -116.422    32.892
  -116.514    33.495
>
  -116.389    34.069
  -116.514    33.495
>
  -117.195    33.600
  -116.514    33.495
>
  -117.195    33.600
  -116.514    33.495
>
  -116.981    33.921
  -116.514    33.495
>
  -116.981    33.921
  -116.514    33.495
>
  -116.846    32.891
  -116.514    33.495
>
  -115.998    34.001
  -116.514    33.495
>
  -115.998    34.001
  -116.514    33.495
>
  -117.161    33.892
  -116.514    33.495
>
  -117.229    33.154
  -116.514    33.495
>
  -116.389    34.069
  -116.325    33.919
>
  -116.389    34.069
  -116.325    33.919
>
  -116.578    33.936
  -116.325    33.919
>
  -116.578    33.936
  -116.325    33.919
>
  -116.378    33.648
  -116.325    33.919
>
  -116.378    33.648
  -116.325    33.919
>
  -115.998    34.001
  -116.325    33.919
>
  -115.998    34.001
  -116.325    33.919
>
  -115.998    34.001
  -116.325    33.919
>
  -116.459    33.612
  -116.325    33.919
>
  -116.459    33.612
  -116.325    33.919
>
  -116.459    33.612
  -116.325    33.919
>
  -116.459    33.612
  -116.325    33.919
>
  -116.456    33.611
  -116.325    33.919
>
  -116.456    33.611
  -116.325    33.919
>
  -115.990    33.655
  -116.325    33.919
>
  -115.990    33.655
  -116.325    33.919
>
  -116.674    33.669
  -116.325    33.919
>
  -116.674    33.669
  -116.325    33.919
>
  -116.356    34.295
  -116.325    33.919
>
  -116.356    34.295
  -116.325    33.919
>
  -115.872    33.677
  -116.325    33.919
>
  -115.872    33.677
  -116.325    33.919
>
  -116.631    33.567
  -116.325    33.919
>
  -116.613    33.552
  -116.325    33.919
>
  -116.602    33.495
  -116.325    33.919
>
  -116.737    33.565
  -116.325    33.919
>
  -116.667    33.492
  -116.325    33.919
>
  -115.638    33.708
  -116.325    33.919
>
  -115.638    33.708
  -116.325    33.919
>
  -116.923    33.687
  -116.325    33.919
>
  -116.923    33.687
  -116.325    33.919
>
  -117.004    33.709
  -116.325    33.919
>
  -117.004    33.709
  -116.325    33.919
>
  -116.921    34.262
  -116.325    33.919
>
  -116.921    34.262
  -116.325    33.919
>
  -116.417    33.268
  -116.325    33.919
>
  -117.009    33.650
  -116.325    33.919
>
  -115.986    33.280
  -116.325    33.919
>
  -115.986    33.280
  -116.325    33.919
>
  -117.041    33.612
  -116.325    33.919
>
  -117.111    34.035
  -116.325    33.919
>
  -117.111    34.035
  -116.325    33.919
>
  -117.098    34.106
  -116.325    33.919
>
  -117.161    33.892
  -116.325    33.919
>
  -117.161    33.892
  -116.325    33.919
>
  -116.417    33.268
  -116.299    33.390
>
  -116.417    33.268
  -116.299    33.390
>
  -116.456    33.611
  -116.299    33.390
>
  -116.456    33.611
  -116.299    33.390
>
  -116.459    33.612
  -116.299    33.390
>
  -116.459    33.612
  -116.299    33.390
>
  -116.459    33.612
  -116.299    33.390
>
  -116.378    33.648
  -116.299    33.390
>
  -116.378    33.648
  -116.299    33.390
>
  -115.986    33.280
  -116.299    33.390
>
  -115.986    33.280
  -116.299    33.390
>
  -116.602    33.495
  -116.299    33.390
>
  -116.602    33.495
  -116.299    33.390
>
  -116.613    33.552
  -116.299    33.390
>
  -116.613    33.552
  -116.299    33.390
>
  -116.667    33.492
  -116.299    33.390
>
  -116.667    33.492
  -116.299    33.390
>
  -116.631    33.567
  -116.299    33.390
>
  -116.631    33.567
  -116.299    33.390
>
  -116.647    33.199
  -116.299    33.390
>
  -116.647    33.199
  -116.299    33.390
>
  -115.990    33.655
  -116.299    33.390
>
  -115.990    33.655
  -116.299    33.390
>
  -116.598    33.081
  -116.299    33.390
>
  -116.598    33.081
  -116.299    33.390
>
  -116.737    33.565
  -116.299    33.390
>
  -116.737    33.565
  -116.299    33.390
>
  -116.674    33.669
  -116.299    33.390
>
  -116.674    33.669
  -116.299    33.390
>
  -115.872    33.677
  -116.299    33.390
>
  -115.872    33.677
  -116.299    33.390
>
  -115.730    33.365
  -116.299    33.390
>
  -115.730    33.365
  -116.299    33.390
>
  -115.823    33.117
  -116.299    33.390
>
  -115.823    33.117
  -116.299    33.390
>
  -116.862    33.353
  -116.299    33.390
>
  -116.862    33.353
  -116.299    33.390
>
  -116.422    32.892
  -116.299    33.390
>
  -116.422    32.892
  -116.299    33.390
>
  -115.969    32.887
  -116.299    33.390
>
  -115.969    32.887
  -116.299    33.390
>
  -116.408    33.941
  -116.299    33.390
>
  -116.408    33.941
  -116.299    33.390
>
  -115.824    32.955
  -116.299    33.390
>
  -115.800    32.945
  -116.299    33.390
>
  -115.800    32.945
  -116.299    33.390
>
  -115.800    32.945
  -116.299    33.390
>
  -116.578    33.936
  -116.299    33.390
>
  -116.578    33.936
  -116.299    33.390
>
  -115.638    33.708
  -116.299    33.390
>
  -115.638    33.708
  -116.299    33.390
>
  -116.923    33.687
  -116.299    33.390
>
  -116.923    33.687
  -116.299    33.390
>
  -115.580    33.121
  -116.299    33.390
>
  -115.580    33.121
  -116.299    33.390
>
  -117.009    33.650
  -116.299    33.390
>
  -117.009    33.650
  -116.299    33.390
>
  -115.998    34.001
  -116.299    33.390
>
  -115.998    34.001
  -116.299    33.390
>
  -116.942    32.999
  -116.299    33.390
>
  -116.942    32.999
  -116.299    33.390
>
  -117.041    33.612
  -116.299    33.390
>
  -117.041    33.612
  -116.299    33.390
>
  -116.846    32.891
  -116.299    33.390
>
  -116.846    32.891
  -116.299    33.390
>
  -117.004    33.709
  -116.299    33.390
>
  -117.004    33.709
  -116.299    33.390
>
  -115.582    33.038
  -116.299    33.390
>
  -115.582    33.038
  -116.299    33.390
>
  -116.389    34.069
  -116.299    33.390
>
  -116.389    34.069
  -116.299    33.390
>
  -115.823    33.117
  -115.929    33.059
>
  -115.800    32.945
  -115.929    33.059
>
  -115.800    32.945
  -115.929    33.059
>
  -115.969    32.887
  -115.929    33.059
>
  -115.986    33.280
  -115.929    33.059
>
  -115.986    33.280
  -115.929    33.059
>
  -115.582    33.038
  -115.929    33.059
>
  -115.580    33.121
  -115.929    33.059
>
  -116.254    33.193
  -115.929    33.059
>
  -115.730    33.365
  -115.929    33.059
>
  -115.561    32.902
  -115.929    33.059
>
  -115.561    32.902
  -115.929    33.059
>
  -115.732    32.759
  -115.929    33.059
>
  -115.923    32.648
  -115.929    33.059
>
  -115.923    32.648
  -115.929    33.059
>
  -115.437    32.862
  -115.929    33.059
>
  -116.109    32.650
  -115.929    33.059
>
  -116.109    32.650
  -115.929    33.059
>
  -116.109    32.650
  -115.929    33.059
>
  -115.447    32.805
  -115.929    33.059
>
  -115.447    32.805
  -115.929    33.059
>
  -116.422    32.892
  -115.929    33.059
>
  -116.422    32.892
  -115.929    33.059
>
  -116.417    33.268
  -115.929    33.059
>
  -116.417    33.268
  -115.929    33.059
>
  -116.079    32.603
  -115.929    33.059
>
  -116.079    32.603
  -115.929    33.059
>
  -115.492    32.669
  -115.929    33.059
>
  -115.445    32.632
  -115.929    33.059
>
  -115.445    32.632
  -115.929    33.059
>
  -115.990    33.655
  -115.929    33.059
>
  -115.990    33.655
  -115.929    33.059
>
  -115.872    33.677
  -115.929    33.059
>
  -115.338    32.693
  -115.929    33.059
>
  -115.638    33.708
  -115.929    33.059
>
  -116.378    33.648
  -115.929    33.059
>
  -116.378    33.648
  -115.929    33.059
>
  -116.389    34.069
  -116.325    33.924
>
  -116.389    34.069
  -116.325    33.924
>
  -116.578    33.936
  -116.325    33.924
>
  -116.578    33.936
  -116.325    33.924
>
  -116.378    33.648
  -116.325    33.924
>
  -115.998    34.001
  -116.325    33.924
>
  -115.998    34.001
  -116.325    33.924
>
  -115.998    34.001
  -116.325    33.924
>
  -116.049    34.106
  -116.325    33.924
>
  -116.459    33.612
  -116.325    33.924
>
  -116.459    33.612
  -116.325    33.924
>
  -116.459    33.612
  -116.325    33.924
>
  -116.459    33.612
  -116.325    33.924
>
  -116.453    33.606
  -116.325    33.924
>
  -116.356    34.295
  -116.325    33.924
>
  -116.356    34.295
  -116.325    33.924
>
  -116.674    33.669
  -116.325    33.924
>
  -116.674    33.669
  -116.325    33.924
>
  -115.990    33.655
  -116.325    33.924
>
  -115.990    33.655
  -116.325    33.924
>
  -116.631    33.567
  -116.325    33.924
>
  -116.613    33.552
  -116.325    33.924
>
  -115.872    33.677
  -116.325    33.924
>
  -115.872    33.677
  -116.325    33.924
>
  -116.602    33.495
  -116.325    33.924
>
  -116.602    33.495
  -116.325    33.924
>
  -116.737    33.565
  -116.325    33.924
>
  -116.667    33.492
  -116.325    33.924
>
  -116.981    33.921
  -116.325    33.924
>
  -116.981    33.921
  -116.325    33.924
>
  -116.923    33.687
  -116.325    33.924
>
  -116.923    33.687
  -116.325    33.924
>
  -115.638    33.708
  -116.325    33.924
>
  -115.638    33.708
  -116.325    33.924
>
  -116.921    34.262
  -116.325    33.924
>
  -116.921    34.262
  -116.325    33.924
>
  -117.004    33.709
  -116.325    33.924
>
  -117.004    33.709
  -116.325    33.924
>
  -117.009    33.650
  -116.325    33.924
>
  -116.417    33.268
  -116.325    33.924
>
  -117.111    34.035
  -116.325    33.924
>
  -117.111    34.035
  -116.325    33.924
>
  -117.098    34.106
  -116.325    33.924
>
  -117.098    34.106
  -116.325    33.924
>
  -117.041    33.612
  -116.325    33.924
>
  -117.161    33.892
  -116.325    33.924
>
  -115.582    33.038
  -115.646    33.129
>
  -115.582    33.038
  -115.646    33.129
>
  -115.823    33.117
  -115.646    33.129
>
  -115.823    33.117
  -115.646    33.129
>
  -115.800    32.945
  -115.646    33.129
>
  -115.800    32.945
  -115.646    33.129
>
  -115.824    32.955
  -115.646    33.129
>
  -115.728    32.850
  -115.646    33.129
>
  -115.728    32.850
  -115.646    33.129
>
  -115.437    32.862
  -115.646    33.129
>
  -115.437    32.862
  -115.646    33.129
>
  -115.986    33.280
  -115.646    33.129
>
  -115.986    33.280
  -115.646    33.129
>
  -115.447    32.805
  -115.646    33.129
>
  -115.969    32.887
  -115.646    33.129
>
  -115.969    32.887
  -115.646    33.129
>
  -115.732    32.759
  -115.646    33.129
>
  -115.732    32.759
  -115.646    33.129
>
  -115.725    32.649
  -115.646    33.129
>
  -115.338    32.693
  -115.646    33.129
>
  -116.254    33.193
  -115.646    33.129
>
  -116.254    33.193
  -115.646    33.129
>
  -115.445    32.632
  -115.646    33.129
>
  -115.923    32.648
  -115.646    33.129
>
  -115.923    32.648
  -115.646    33.129
>
  -115.454    33.655
  -115.646    33.129
>
  -115.454    33.655
  -115.646    33.129
>
  -115.454    33.655
  -115.646    33.129
>
  -114.977    32.972
  -115.646    33.129
>
  -114.977    32.972
  -115.646    33.129
>
  -115.638    33.708
  -115.646    33.129
>
  -115.638    33.708
  -115.646    33.129
>
  -115.872    33.677
  -115.646    33.129
>
  -115.872    33.677
  -115.646    33.129
>
  -115.990    33.655
  -115.646    33.129
>
  -116.109    32.650
  -115.646    33.129
>
  -116.109    32.650
  -115.646    33.129
>
  -116.079    32.603
  -115.646    33.129
>
  -116.079    32.603
  -115.646    33.129
>
  -116.417    33.268
  -115.646    33.129
>
  -116.417    33.268
  -115.646    33.129
>
  -114.985    32.739
  -115.646    33.129
>
  -114.827    33.051
  -115.646    33.129
>
  -114.827    33.051
  -115.646    33.129
>
  -114.827    33.051
  -115.646    33.129
>
  -116.422    32.892
  -115.646    33.129
>
  -116.422    32.892
  -115.646    33.129
>
  -116.602    33.495
  -116.831    33.472
>
  -116.613    33.552
  -116.831    33.472
>
  -116.613    33.552
  -116.831    33.472
>
  -117.041    33.612
  -116.831    33.472
>
  -117.041    33.612
  -116.831    33.472
>
  -116.923    33.687
  -116.831    33.472
>
  -116.923    33.687
  -116.831    33.472
>
  -117.009    33.650
  -116.831    33.472
>
  -117.009    33.650
  -116.831    33.472
>
  -117.004    33.709
  -116.831    33.472
>
  -117.004    33.709
  -116.831    33.472
>
  -116.647    33.199
  -116.831    33.472
>
  -116.647    33.199
  -116.831    33.472
>
  -116.459    33.612
  -116.831    33.472
>
  -116.459    33.612
  -116.831    33.472
>
  -116.453    33.606
  -116.831    33.472
>
  -117.195    33.600
  -116.831    33.472
>
  -117.195    33.600
  -116.831    33.472
>
  -117.195    33.600
  -116.831    33.472
>
  -116.417    33.268
  -116.831    33.472
>
  -116.417    33.268
  -116.831    33.472
>
  -116.378    33.648
  -116.831    33.472
>
  -116.378    33.648
  -116.831    33.472
>
  -116.598    33.081
  -116.831    33.472
>
  -116.598    33.081
  -116.831    33.472
>
  -117.229    33.154
  -116.831    33.472
>
  -117.229    33.154
  -116.831    33.472
>
  -116.981    33.921
  -116.831    33.472
>
  -116.981    33.921
  -116.831    33.472
>
  -116.942    32.999
  -116.831    33.472
>
  -116.942    32.999
  -116.831    33.472
>
  -117.161    33.892
  -116.831    33.472
>
  -117.161    33.892
  -116.831    33.472
>
  -116.578    33.936
  -116.831    33.472
>
  -116.578    33.936
  -116.831    33.472
>
  -117.427    33.648
  -116.831    33.472
>
  -117.427    33.648
  -116.831    33.472
>
  -116.254    33.193
  -116.831    33.472
>
  -116.254    33.193
  -116.831    33.472
>
  -116.846    32.891
  -116.831    33.472
>
  -116.846    32.891
  -116.831    33.472
>
  -116.408    33.941
  -116.831    33.472
>
  -116.408    33.941
  -116.831    33.472
>
  -117.111    34.035
  -116.831    33.472
>
  -117.111    34.035
  -116.831    33.472
>
  -117.105    32.889
  -116.831    33.472
>
  -117.105    32.889
  -116.831    33.472
>
  -117.105    32.889
  -116.831    33.472
>
  -117.327    33.973
  -116.831    33.472
>
  -117.327    33.973
  -116.831    33.472
>
  -116.422    32.892
  -116.831    33.472
>
  -116.422    32.892
  -116.831    33.472
>
  -117.057    32.820
  -116.831    33.472
>
  -117.057    32.820
  -116.831    33.472
>
  -117.098    34.106
  -116.831    33.472
>
  -117.098    34.106
  -116.831    33.472
>
  -117.375    33.993
  -116.831    33.472
>
  -117.375    33.993
  -116.831    33.472
>
  -115.969    32.887
  -115.989    33.022
>
  -115.969    32.887
  -115.989    33.022
>
  -115.824    32.955
  -115.989    33.022
>
  -115.824    32.955
  -115.989    33.022
>
  -115.800    32.945
  -115.989    33.022
>
  -115.800    32.945
  -115.989    33.022
>
  -115.800    32.945
  -115.989    33.022
>
  -116.254    33.193
  -115.989    33.022
>
  -116.254    33.193
  -115.989    33.022
>
  -116.254    33.193
  -115.989    33.022
>
  -115.986    33.280
  -115.989    33.022
>
  -115.986    33.280
  -115.989    33.022
>
  -115.728    32.850
  -115.989    33.022
>
  -115.728    32.850
  -115.989    33.022
>
  -115.732    32.759
  -115.989    33.022
>
  -115.732    32.759
  -115.989    33.022
>
  -115.732    32.759
  -115.989    33.022
>
  -116.422    32.892
  -115.989    33.022
>
  -116.422    32.892
  -115.989    33.022
>
  -116.422    32.892
  -115.989    33.022
>
  -116.109    32.650
  -115.989    33.022
>
  -116.109    32.650
  -115.989    33.022
>
  -116.109    32.650
  -115.989    33.022
>
  -115.923    32.648
  -115.989    33.022
>
  -115.923    32.648
  -115.989    33.022
>
  -115.922    32.647
  -115.989    33.022
>
  -115.922    32.647
  -115.989    33.022
>
  -115.582    33.038
  -115.989    33.022
>
  -115.582    33.038
  -115.989    33.022
>
  -115.580    33.121
  -115.989    33.022
>
  -115.580    33.121
  -115.989    33.022
>
  -115.561    32.902
  -115.989    33.022
>
  -115.561    32.902
  -115.989    33.022
>
  -116.079    32.603
  -115.989    33.022
>
  -116.079    32.603
  -115.989    33.022
>
  -116.417    33.268
  -115.989    33.022
>
  -116.417    33.268
  -115.989    33.022
>
  -115.730    33.365
  -115.989    33.022
>
  -115.669    32.652
  -115.989    33.022
>
  -116.598    33.081
  -115.989    33.022
>
  -115.638    33.402
  -115.989    33.022
>
  -115.447    32.805
  -115.989    33.022
>
  -115.447    32.805
  -115.989    33.022
>
  -115.492    32.669
  -115.989    33.022
>
  -115.492    32.669
  -115.989    33.022
>
  -116.647    33.199
  -115.989    33.022
>
  -116.647    33.199
  -115.989    33.022
>
  -115.472    32.664
  -115.989    33.022
>
  -115.581    32.537
  -115.989    33.022
>
  -115.445    32.632
  -115.989    33.022
>
  -115.445    32.632
  -115.989    33.022
>
  -116.672    32.680
  -115.989    33.022
>
  -116.672    32.680
  -115.989    33.022
>
  -115.304    33.239
  -115.989    33.022
>
  -115.338    32.693
  -115.989    33.022
>
  -115.338    32.693
  -115.989    33.022
>
  -115.385    32.628
  -115.989    33.022
>
  -115.990    33.655
  -115.989    33.022
>
  -115.990    33.655
  -115.989    33.022
>
  -116.607    32.569
  -115.989    33.022
>
  -116.607    32.569
  -115.989    33.022
>
  -115.872    33.677
  -115.989    33.022
>
  -115.872    33.677
  -115.989    33.022
>
  -116.602    33.495
  -115.989    33.022
>
  -116.602    33.495
  -115.989    33.022
>
  -116.602    33.495
  -115.989    33.022
>
  -115.447    32.805
  -115.523    32.898
>
  -115.582    33.038
  -115.523    32.898
>
  -115.582    33.038
  -115.523    32.898
>
  -115.728    32.850
  -115.523    32.898
>
  -115.728    32.850
  -115.523    32.898
>
  -115.732    32.759
  -115.523    32.898
>
  -115.732    32.759
  -115.523    32.898
>
  -115.580    33.121
  -115.523    32.898
>
  -115.580    33.121
  -115.523    32.898
>
  -115.492    32.669
  -115.523    32.898
>
  -115.492    32.669
  -115.523    32.898
>
  -115.472    32.664
  -115.523    32.898
>
  -115.338    32.693
  -115.523    32.898
>
  -115.338    32.693
  -115.523    32.898
>
  -115.669    32.652
  -115.523    32.898
>
  -115.669    32.652
  -115.523    32.898
>
  -115.445    32.632
  -115.523    32.898
>
  -115.445    32.632
  -115.523    32.898
>
  -115.445    32.632
  -115.523    32.898
>
  -115.445    32.632
  -115.523    32.898
>
  -115.385    32.628
  -115.523    32.898
>
  -115.385    32.628
  -115.523    32.898
>
  -115.725    32.649
  -115.523    32.898
>
  -115.725    32.649
  -115.523    32.898
>
  -115.823    33.117
  -115.523    32.898
>
  -115.823    33.117
  -115.523    32.898
>
  -115.123    32.863
  -115.523    32.898
>
  -115.123    32.863
  -115.523    32.898
>
  -115.581    32.537
  -115.523    32.898
>
  -115.969    32.887
  -115.523    32.898
>
  -115.969    32.887
  -115.523    32.898
>
  -115.304    33.239
  -115.523    32.898
>
  -115.304    33.239
  -115.523    32.898
>
  -115.923    32.648
  -115.523    32.898
>
  -115.923    32.648
  -115.523    32.898
>
  -115.922    32.647
  -115.523    32.898
>
  -114.977    32.972
  -115.523    32.898
>
  -114.977    32.972
  -115.523    32.898
>
  -115.733    33.353
  -115.523    32.898
>
  -114.985    32.739
  -115.523    32.898
>
  -114.985    32.739
  -115.523    32.898
>
  -115.730    33.365
  -115.523    32.898
>
  -115.730    33.365
  -115.523    32.898
>
  -115.638    33.402
  -115.523    32.898
>
  -115.304    32.418
  -115.523    32.898
>
  -115.304    32.418
  -115.523    32.898
>
  -115.304    32.418
  -115.523    32.898
>
  -115.304    32.418
  -115.523    32.898
>
  -115.986    33.280
  -115.523    32.898
>
  -115.986    33.280
  -115.523    32.898
>
  -116.109    32.650
  -115.523    32.898
>
  -116.079    32.603
  -115.523    32.898
>
  -116.079    32.603
  -115.523    32.898
>
  -115.198    32.407
  -115.523    32.898
>
  -114.827    33.051
  -115.523    32.898
>
  -114.827    33.051
  -115.523    32.898
>
  -114.964    32.433
  -115.523    32.898
>
  -114.964    32.433
  -115.523    32.898
>
  -116.254    33.193
  -115.523    32.898
>
  -116.254    33.193
  -115.523    32.898
>
  -116.049    34.106
  -116.050    33.993
>
  -115.872    33.677
  -116.050    33.993
>
  -115.872    33.677
  -116.050    33.993
>
  -116.356    34.295
  -116.050    33.993
>
  -116.356    34.295
  -116.050    33.993
>
  -115.638    33.708
  -116.050    33.993
>
  -115.638    33.708
  -116.050    33.993
>
  -116.378    33.648
  -116.050    33.993
>
  -116.578    33.936
  -116.050    33.993
>
  -116.578    33.936
  -116.050    33.993
>
  -116.456    33.611
  -116.050    33.993
>
  -116.456    33.611
  -116.050    33.993
>
  -116.459    33.612
  -116.050    33.993
>
  -116.459    33.612
  -116.050    33.993
>
  -116.459    33.612
  -116.050    33.993
>
  -116.453    33.606
  -116.050    33.993
>
  -116.453    33.606
  -116.050    33.993
>
  -115.454    33.655
  -116.050    33.993
>
  -116.674    33.669
  -116.050    33.993
>
  -116.674    33.669
  -116.050    33.993
>
  -116.613    33.552
  -116.050    33.993
>
  -116.613    33.552
  -116.050    33.993
>
  -116.602    33.495
  -116.050    33.993
>
  -116.602    33.495
  -116.050    33.993
>
  -115.730    33.365
  -116.050    33.993
>
  -115.730    33.365
  -116.050    33.993
>
  -115.733    33.353
  -116.050    33.993
>
  -115.638    33.402
  -115.804    33.364
>
  -115.823    33.117
  -115.804    33.364
>
  -115.823    33.117
  -115.804    33.364
>
  -115.580    33.121
  -115.804    33.364
>
  -115.580    33.121
  -115.804    33.364
>
  -115.872    33.677
  -115.804    33.364
>
  -115.872    33.677
  -115.804    33.364
>
  -115.990    33.655
  -115.804    33.364
>
  -115.990    33.655
  -115.804    33.364
>
  -115.638    33.708
  -115.804    33.364
>
  -115.638    33.708
  -115.804    33.364
>
  -115.582    33.038
  -115.804    33.364
>
  -115.582    33.038
  -115.804    33.364
>
  -115.824    32.955
  -115.804    33.364
>
  -115.824    32.955
  -115.804    33.364
>
  -115.454    33.655
  -115.804    33.364
>
  -115.454    33.655
  -115.804    33.364
>
  -115.800    32.945
  -115.804    33.364
>
  -116.254    33.193
  -115.804    33.364
>
  -116.254    33.193
  -115.804    33.364
>
  -115.304    33.239
  -115.804    33.364
>
  -115.304    33.239
  -115.804    33.364
>
  -115.969    32.887
  -115.804    33.364
>
  -115.561    32.902
  -115.804    33.364
>
  -115.561    32.902
  -115.804    33.364
>
  -115.728    32.850
  -115.804    33.364
>
  -116.417    33.268
  -115.804    33.364
>
  -116.417    33.268
  -115.804    33.364
>
  -116.378    33.648
  -115.804    33.364
>
  -116.378    33.648
  -115.804    33.364
>
  -115.437    32.862
  -115.804    33.364
>
  -115.437    32.862
  -115.804    33.364
>
  -116.456    33.611
  -115.804    33.364
>
  -115.732    32.759
  -115.804    33.364
>
  -115.732    32.759
  -115.804    33.364
>
  -116.459    33.612
  -115.804    33.364
>
  -116.459    33.612
  -115.804    33.364
>
  -116.459    33.612
  -115.804    33.364
>
  -115.447    32.805
  -115.804    33.364
>
  -115.998    34.001
  -115.804    33.364
>
  -115.998    34.001
  -115.804    33.364
>
  -116.602    33.495
  -115.804    33.364
>
  -116.602    33.495
  -115.804    33.364
>
  -115.638    33.402
  -115.798    33.368
>
  -115.986    33.280
  -115.798    33.368
>
  -115.580    33.121
  -115.798    33.368
>
  -115.872    33.677
  -115.798    33.368
>
  -115.872    33.677
  -115.798    33.368
>
  -115.990    33.655
  -115.798    33.368
>
  -115.638    33.708
  -115.798    33.368
>
  -115.638    33.708
  -115.798    33.368
>
  -115.582    33.038
  -115.798    33.368
>
  -115.582    33.038
  -115.798    33.368
>
  -115.824    32.955
  -115.798    33.368
>
  -115.800    32.945
  -115.798    33.368
>
  -115.800    32.945
  -115.798    33.368
>
  -115.454    33.655
  -115.798    33.368
>
  -115.454    33.655
  -115.798    33.368
>
  -116.254    33.193
  -115.798    33.368
>
  -116.254    33.193
  -115.798    33.368
>
  -115.304    33.239
  -115.798    33.368
>
  -115.304    33.239
  -115.798    33.368
>
  -115.969    32.887
  -115.798    33.368
>
  -115.561    32.902
  -115.798    33.368
>
  -115.561    32.902
  -115.798    33.368
>
  -115.728    32.850
  -115.798    33.368
>
  -115.728    32.850
  -115.798    33.368
>
  -116.417    33.268
  -115.798    33.368
>
  -116.417    33.268
  -115.798    33.368
>
  -116.378    33.648
  -115.798    33.368
>
  -115.437    32.862
  -115.798    33.368
>
  -115.437    32.862
  -115.798    33.368
>
  -115.732    32.759
  -115.798    33.368
>
  -116.456    33.611
  -115.798    33.368
>
  -116.459    33.612
  -115.798    33.368
>
  -116.459    33.612
  -115.798    33.368
>
  -115.447    32.805
  -115.798    33.368
>
  -115.998    34.001
  -115.798    33.368
>
  -115.998    34.001
  -115.798    33.368
>
  -116.602    33.495
  -115.798    33.368
>
  -116.602    33.495
  -115.798    33.368
>
  -116.602    33.495
  -115.798    33.368
>
  -116.667    33.492
  -116.833    33.575
>
  -116.667    33.492
  -116.833    33.575
>
  -116.631    33.567
  -116.833    33.575
>
  -116.613    33.552
  -116.833    33.575
>
  -116.923    33.687
  -116.833    33.575
>
  -116.923    33.687
  -116.833    33.575
>
  -116.674    33.669
  -116.833    33.575
>
  -116.674    33.669
  -116.833    33.575
>
  -116.602    33.495
  -116.833    33.575
>
  -116.602    33.495
  -116.833    33.575
>
  -117.009    33.650
  -116.833    33.575
>
  -117.009    33.650
  -116.833    33.575
>
  -117.041    33.612
  -116.833    33.575
>
  -117.004    33.709
  -116.833    33.575
>
  -117.004    33.709
  -116.833    33.575
>
  -116.459    33.612
  -116.833    33.575
>
  -116.459    33.612
  -116.833    33.575
>
  -116.647    33.199
  -116.833    33.575
>
  -116.647    33.199
  -116.833    33.575
>
  -116.378    33.648
  -116.833    33.575
>
  -116.981    33.921
  -116.833    33.575
>
  -116.981    33.921
  -116.833    33.575
>
  -116.417    33.268
  -116.833    33.575
>
  -116.417    33.268
  -116.833    33.575
>
  -116.578    33.936
  -116.833    33.575
>
  -117.161    33.892
  -116.833    33.575
>
  -116.598    33.081
  -116.833    33.575
>
  -116.811    34.036
  -116.833    33.575
>
  -117.427    33.648
  -116.833    33.575
>
  -117.427    33.648
  -116.833    33.575
>
  -116.942    32.999
  -116.833    33.575
>
  -116.942    32.999
  -116.833    33.575
>
  -116.936    34.091
  -116.833    33.575
>
  -116.254    33.193
  -116.833    33.575
>
  -117.327    33.973
  -116.833    33.575
>
  -117.327    33.973
  -116.833    33.575
>
  -117.098    34.106
  -116.833    33.575
>
  -117.098    34.106
  -116.833    33.575
>
  -116.846    32.891
  -116.833    33.575
>
  -117.375    33.993
  -116.833    33.575
>
  -117.219    34.121
  -116.833    33.575
>
  -117.219    34.121
  -116.833    33.575
>
  -117.283    34.105
  -116.833    33.575
>
  -117.283    34.105
  -116.833    33.575
>
  -117.561    33.876
  -116.833    33.575
>
  -117.561    33.876
  -116.833    33.575
>
  -116.921    34.262
  -116.833    33.575
>
  -116.453    33.606
  -116.511    33.489
>
  -116.378    33.648
  -116.511    33.489
>
  -116.674    33.669
  -116.511    33.489
>
  -116.674    33.669
  -116.511    33.489
>
  -116.862    33.353
  -116.511    33.489
>
  -116.862    33.353
  -116.511    33.489
>
  -116.254    33.193
  -116.511    33.489
>
  -116.923    33.687
  -116.511    33.489
>
  -116.598    33.081
  -116.511    33.489
>
  -117.009    33.650
  -116.511    33.489
>
  -116.578    33.936
  -116.511    33.489
>
  -117.041    33.612
  -116.511    33.489
>
  -116.408    33.941
  -116.511    33.489
>
  -116.408    33.941
  -116.511    33.489
>
  -115.990    33.655
  -116.511    33.489
>
  -115.990    33.655
  -116.511    33.489
>
  -115.986    33.280
  -116.511    33.489
>
  -115.986    33.280
  -116.511    33.489
>
  -115.872    33.677
  -116.511    33.489
>
  -115.872    33.677
  -116.511    33.489
>
  -117.195    33.600
  -116.511    33.489
>
  -116.981    33.921
  -116.511    33.489
>
  -116.981    33.921
  -116.511    33.489
>
  -116.389    34.069
  -116.511    33.489
>
  -116.942    32.999
  -116.511    33.489
>
  -116.942    32.999
  -116.511    33.489
>
  -116.811    34.036
  -116.511    33.489
>
  -115.733    33.353
  -116.511    33.489
>
  -115.730    33.365
  -116.511    33.489
>
  -117.161    33.892
  -116.511    33.489
>
  -117.161    33.892
  -116.511    33.489
>
  -117.229    33.154
  -116.511    33.489
>
  -115.823    33.117
  -116.511    33.489
>
  -116.936    34.091
  -116.511    33.489
>
  -116.936    34.091
  -116.511    33.489
>
  -115.582    33.038
  -115.633    33.190
>
  -115.638    33.402
  -115.633    33.190
>
  -115.638    33.402
  -115.633    33.190
>
  -115.824    32.955
  -115.633    33.190
>
  -115.824    32.955
  -115.633    33.190
>
  -115.561    32.902
  -115.633    33.190
>
  -115.561    32.902
  -115.633    33.190
>
  -115.986    33.280
  -115.633    33.190
>
  -115.986    33.280
  -115.633    33.190
>
  -115.304    33.239
  -115.633    33.190
>
  -115.304    33.239
  -115.633    33.190
>
  -115.728    32.850
  -115.633    33.190
>
  -115.437    32.862
  -115.633    33.190
>
  -115.437    32.862
  -115.633    33.190
>
  -115.969    32.887
  -115.633    33.190
>
  -115.447    32.805
  -115.633    33.190
>
  -115.447    32.805
  -115.633    33.190
>
  -115.732    32.759
  -115.633    33.190
>
  -115.732    32.759
  -115.633    33.190
>
  -116.254    33.193
  -115.633    33.190
>
  -116.254    33.193
  -115.633    33.190
>
  -115.454    33.655
  -115.633    33.190
>
  -115.454    33.655
  -115.633    33.190
>
  -115.492    32.669
  -115.633    33.190
>
  -115.492    32.669
  -115.633    33.190
>
  -115.725    32.649
  -115.633    33.190
>
  -115.725    32.649
  -115.633    33.190
>
  -115.872    33.677
  -115.633    33.190
>
  -115.872    33.677
  -115.633    33.190
>
  -115.638    33.708
  -115.633    33.190
>
  -115.638    33.708
  -115.633    33.190
>
  -115.123    32.863
  -115.633    33.190
>
  -115.123    32.863
  -115.633    33.190
>
  -115.338    32.693
  -115.633    33.190
>
  -115.338    32.693
  -115.633    33.190
>
  -115.990    33.655
  -115.633    33.190
>
  -115.990    33.655
  -115.633    33.190
>
  -115.923    32.648
  -115.633    33.190
>
  -115.923    32.648
  -115.633    33.190
>
  -115.445    32.632
  -115.633    33.190
>
  -115.445    32.632
  -115.633    33.190
>
  -114.977    32.972
  -115.633    33.190
>
  -114.977    32.972
  -115.633    33.190
>
  -116.417    33.268
  -115.633    33.190
>
  -116.417    33.268
  -115.633    33.190
>
  -116.109    32.650
  -115.633    33.190
>
  -116.109    32.650
  -115.633    33.190
>
  -116.079    32.603
  -115.633    33.190
>
  -116.079    32.603
  -115.633    33.190
>
  -114.827    33.051
  -115.633    33.190
>
  -114.827    33.051
  -115.633    33.190
>
  -116.254    33.193
  -116.016    33.025
>
  -115.986    33.280
  -116.016    33.025
>
  -115.732    32.759
  -116.016    33.025
>
  -116.109    32.650
  -116.016    33.025
>
  -115.582    33.038
  -116.016    33.025
>
  -115.582    33.038
  -116.016    33.025
>
  -115.923    32.648
  -116.016    33.025
>
  -115.580    33.121
  -116.016    33.025
>
  -115.580    33.121
  -116.016    33.025
>
  -115.561    32.902
  -116.016    33.025
>
  -115.561    32.902
  -116.016    33.025
>
  -116.079    32.603
  -116.016    33.025
>
  -116.079    32.603
  -116.016    33.025
>
  -116.417    33.268
  -116.016    33.025
>
  -115.730    33.365
  -116.016    33.025
>
  -115.725    32.649
  -116.016    33.025
>
  -115.725    32.649
  -116.016    33.025
>
  -116.598    33.081
  -116.016    33.025
>
  -116.598    33.081
  -116.016    33.025
>
  -115.638    33.402
  -116.016    33.025
>
  -115.638    33.402
  -116.016    33.025
>
  -115.437    32.862
  -116.016    33.025
>
  -115.447    32.805
  -116.016    33.025
>
  -115.447    32.805
  -116.016    33.025
>
  -116.647    33.199
  -116.016    33.025
>
  -116.647    33.199
  -116.016    33.025
>
  -115.492    32.669
  -116.016    33.025
>
  -115.492    32.669
  -116.016    33.025
>
  -115.445    32.632
  -116.016    33.025
>
  -115.445    32.632
  -116.016    33.025
>
  -116.672    32.680
  -116.016    33.025
>
  -116.672    32.680
  -116.016    33.025
>
  -115.990    33.655
  -116.016    33.025
>
  -115.990    33.655
  -116.016    33.025
>
  -115.304    33.239
  -116.016    33.025
>
  -115.338    32.693
  -116.016    33.025
>
  -115.338    32.693
  -116.016    33.025
>
  -116.607    32.569
  -116.016    33.025
>
  -116.607    32.569
  -116.016    33.025
>
  -115.872    33.677
  -116.016    33.025
>
  -115.872    33.677
  -116.016    33.025
>
  -116.602    33.495
  -116.016    33.025
>
  -116.602    33.495
  -116.016    33.025
>
  -116.453    33.606
  -116.016    33.025
>
  -116.453    33.606
  -116.016    33.025
>
  -116.378    33.648
  -116.016    33.025
>
  -116.378    33.648
  -116.016    33.025
>
  -116.459    33.612
  -116.016    33.025
>
  -116.459    33.612
  -116.016    33.025
>
  -116.459    33.612
  -116.016    33.025
>
  -116.459    33.612
  -116.016    33.025
>
  -115.593    33.276
  -115.713    33.262
>
  -115.593    33.276
  -115.713    33.262
>
  -115.637    33.167
  -115.713    33.262
>
  -115.730    33.365
  -115.713    33.262
>
  -115.638    33.402
  -115.713    33.262
>
  -115.638    33.402
  -115.713    33.262
>
  -115.580    33.121
  -115.713    33.262
>
  -115.580    33.121
  -115.713    33.262
>
  -115.986    33.280
  -115.713    33.262
>
  -115.582    33.038
  -115.713    33.262
>
  -115.582    33.038
  -115.713    33.262
>
  -115.800    32.945
  -115.713    33.262
>
  -115.561    32.902
  -115.713    33.262
>
  -115.872    33.677
  -115.713    33.262
>
  -115.454    33.655
  -115.713    33.262
>
  -115.454    33.655
  -115.713    33.262
>
  -115.990    33.655
  -115.713    33.262
>
  -115.447    32.805
  -115.713    33.262
>
  -116.417    33.268
  -115.713    33.262
>
  -115.923    32.648
  -115.713    33.262
>
  -116.378    33.648
  -115.713    33.262
>
  -114.977    32.972
  -115.713    33.262
>
  -115.593    33.276
  -115.714    33.252
>
  -115.593    33.276
  -115.714    33.252
>
  -115.637    33.167
  -115.714    33.252
>
  -115.637    33.167
  -115.714    33.252
>
  -115.730    33.365
  -115.714    33.252
>
  -115.730    33.365
  -115.714    33.252
>
  -115.580    33.121
  -115.714    33.252
>
  -115.580    33.121
  -115.714    33.252
>
  -115.638    33.402
  -115.714    33.252
>
  -115.638    33.402
  -115.714    33.252
>
  -115.823    33.117
  -115.714    33.252
>
  -115.823    33.117
  -115.714    33.252
>
  -115.582    33.038
  -115.714    33.252
>
  -115.582    33.038
  -115.714    33.252
>
  -115.986    33.280
  -115.714    33.252
>
  -115.800    32.945
  -115.714    33.252
>
  -115.561    32.902
  -115.714    33.252
>
  -115.728    32.850
  -115.714    33.252
>
  -116.174    33.171
  -115.714    33.252
>
  -116.174    33.171
  -115.714    33.252
>
  -115.969    32.887
  -115.714    33.252
>
  -115.969    32.887
  -115.714    33.252
>
  -115.454    33.655
  -115.714    33.252
>
  -115.454    33.655
  -115.714    33.252
>
  -115.872    33.677
  -115.714    33.252
>
  -115.872    33.677
  -115.714    33.252
>
  -115.638    33.708
  -115.714    33.252
>
  -115.638    33.708
  -115.714    33.252
>
  -116.254    33.193
  -115.714    33.252
>
  -116.254    33.193
  -115.714    33.252
>
  -115.990    33.655
  -115.714    33.252
>
  -115.990    33.655
  -115.714    33.252
>
  -115.732    32.759
  -115.714    33.252
>
  -116.311    33.364
  -115.714    33.252
>
  -115.725    32.649
  -115.714    33.252
>
  -115.492    32.669
  -115.714    33.252
>
  -115.492    32.669
  -115.714    33.252
>
  -116.417    33.268
  -115.714    33.252
>
  -116.417    33.268
  -115.714    33.252
>
  -115.123    32.863
  -115.714    33.252
>
  -115.123    32.863
  -115.714    33.252
>
  -115.923    32.648
  -115.714    33.252
>
  -115.923    32.648
  -115.714    33.252
>
  -115.338    32.693
  -115.714    33.252
>
  -114.977    32.972
  -115.714    33.252
>
  -116.109    32.650
  -115.714    33.252
>
  -116.109    32.650
  -115.714    33.252
>
  -116.378    33.648
  -115.714    33.252
>
  -116.378    33.648
  -115.714    33.252
>
  -115.637    33.167
  -115.698    33.256
>
  -115.637    33.167
  -115.698    33.256
>
  -115.733    33.353
  -115.698    33.256
>
  -115.730    33.365
  -115.698    33.256
>
  -115.638    33.402
  -115.698    33.256
>
  -115.638    33.402
  -115.698    33.256
>
  -115.823    33.117
  -115.698    33.256
>
  -115.823    33.117
  -115.698    33.256
>
  -115.582    33.038
  -115.698    33.256
>
  -115.986    33.280
  -115.698    33.256
>
  -115.986    33.280
  -115.698    33.256
>
  -115.824    32.955
  -115.698    33.256
>
  -115.824    32.955
  -115.698    33.256
>
  -115.800    32.945
  -115.698    33.256
>
  -115.800    32.945
  -115.698    33.256
>
  -115.561    32.902
  -115.698    33.256
>
  -115.561    32.902
  -115.698    33.256
>
  -115.728    32.850
  -115.698    33.256
>
  -115.728    32.850
  -115.698    33.256
>
  -116.174    33.171
  -115.698    33.256
>
  -116.174    33.171
  -115.698    33.256
>
  -115.969    32.887
  -115.698    33.256
>
  -115.969    32.887
  -115.698    33.256
>
  -115.437    32.862
  -115.698    33.256
>
  -115.872    33.677
  -115.698    33.256
>
  -115.872    33.677
  -115.698    33.256
>
  -115.454    33.655
  -115.698    33.256
>
  -115.454    33.655
  -115.698    33.256
>
  -115.638    33.708
  -115.698    33.256
>
  -115.638    33.708
  -115.698    33.256
>
  -116.254    33.193
  -115.698    33.256
>
  -116.254    33.193
  -115.698    33.256
>
  -115.990    33.655
  -115.698    33.256
>
  -115.990    33.655
  -115.698    33.256
>
  -115.732    32.759
  -115.698    33.256
>
  -115.732    32.759
  -115.698    33.256
>
  -115.447    32.805
  -115.698    33.256
>
  -115.447    32.805
  -115.698    33.256
>
  -116.311    33.364
  -115.698    33.256
>
  -115.725    32.649
  -115.698    33.256
>
  -115.725    32.649
  -115.698    33.256
>
  -116.417    33.268
  -115.698    33.256
>
  -116.417    33.268
  -115.698    33.256
>
  -115.492    32.669
  -115.698    33.256
>
  -115.492    32.669
  -115.698    33.256
>
  -115.123    32.863
  -115.698    33.256
>
  -115.123    32.863
  -115.698    33.256
>
  -115.923    32.648
  -115.698    33.256
>
  -115.923    32.648
  -115.698    33.256
>
  -115.338    32.693
  -115.698    33.256
>
  -115.338    32.693
  -115.698    33.256
>
  -114.977    32.972
  -115.698    33.256
>
  -114.977    32.972
  -115.698    33.256
>
  -116.109    32.650
  -115.698    33.256
>
  -116.378    33.648
  -115.698    33.256
>
  -115.637    33.167
  -115.704    33.279
>
  -115.638    33.402
  -115.704    33.279
>
  -115.638    33.402
  -115.704    33.279
>
  -115.580    33.121
  -115.704    33.279
>
  -115.580    33.121
  -115.704    33.279
>
  -115.823    33.117
  -115.704    33.279
>
  -115.823    33.117
  -115.704    33.279
>
  -115.986    33.280
  -115.704    33.279
>
  -115.582    33.038
  -115.704    33.279
>
  -115.582    33.038
  -115.704    33.279
>
  -115.824    32.955
  -115.704    33.279
>
  -115.824    32.955
  -115.704    33.279
>
  -115.800    32.945
  -115.704    33.279
>
  -115.561    32.902
  -115.704    33.279
>
  -116.174    33.171
  -115.704    33.279
>
  -116.174    33.171
  -115.704    33.279
>
  -115.728    32.850
  -115.704    33.279
>
  -115.728    32.850
  -115.704    33.279
>
  -115.454    33.655
  -115.704    33.279
>
  -115.454    33.655
  -115.704    33.279
>
  -115.969    32.887
  -115.704    33.279
>
  -115.969    32.887
  -115.704    33.279
>
  -115.437    32.862
  -115.704    33.279
>
  -115.990    33.655
  -115.704    33.279
>
  -115.990    33.655
  -115.704    33.279
>
  -116.254    33.193
  -115.704    33.279
>
  -116.254    33.193
  -115.704    33.279
>
  -115.447    32.805
  -115.704    33.279
>
  -115.447    32.805
  -115.704    33.279
>
  -115.732    32.759
  -115.704    33.279
>
  -116.311    33.364
  -115.704    33.279
>
  -116.311    33.364
  -115.704    33.279
>
  -116.417    33.268
  -115.704    33.279
>
  -116.417    33.268
  -115.704    33.279
>
  -115.725    32.649
  -115.704    33.279
>
  -115.123    32.863
  -115.704    33.279
>
  -115.123    32.863
  -115.704    33.279
>
  -115.338    32.693
  -115.704    33.279
>
  -115.923    32.648
  -115.704    33.279
>
  -115.923    32.648
  -115.704    33.279
>
  -114.977    32.972
  -115.704    33.279
>
  -114.977    32.972
  -115.704    33.279
>
  -116.378    33.648
  -115.704    33.279
>
  -116.378    33.648
  -115.704    33.279
>
  -116.578    33.936
  -116.411    33.949
>
  -116.578    33.936
  -116.411    33.949
>
  -116.378    33.648
  -116.411    33.949
>
  -116.378    33.648
  -116.411    33.949
>
  -116.459    33.612
  -116.411    33.949
>
  -116.459    33.612
  -116.411    33.949
>
  -116.456    33.611
  -116.411    33.949
>
  -116.456    33.611
  -116.411    33.949
>
  -115.998    34.001
  -116.411    33.949
>
  -115.998    34.001
  -116.411    33.949
>
  -116.674    33.669
  -116.411    33.949
>
  -116.674    33.669
  -116.411    33.949
>
  -116.811    34.036
  -116.411    33.949
>
  -116.809    33.832
  -116.411    33.949
>
  -116.809    33.832
  -116.411    33.949
>
  -116.356    34.295
  -116.411    33.949
>
  -116.356    34.295
  -116.411    33.949
>
  -116.631    33.567
  -116.411    33.949
>
  -116.631    33.567
  -116.411    33.949
>
  -116.613    33.552
  -116.411    33.949
>
  -116.613    33.552
  -116.411    33.949
>
  -115.990    33.655
  -116.411    33.949
>
  -115.990    33.655
  -116.411    33.949
>
  -116.737    33.565
  -116.411    33.949
>
  -116.737    33.565
  -116.411    33.949
>
  -116.936    34.091
  -116.411    33.949
>
  -116.936    34.091
  -116.411    33.949
>
  -116.602    33.495
  -116.411    33.949
>
  -116.602    33.495
  -116.411    33.949
>
  -116.602    33.495
  -116.411    33.949
>
  -116.981    33.921
  -116.411    33.949
>
  -116.981    33.921
  -116.411    33.949
>
  -116.667    33.492
  -116.411    33.949
>
  -116.667    33.492
  -116.411    33.949
>
  -116.923    33.687
  -116.411    33.949
>
  -116.923    33.687
  -116.411    33.949
>
  -115.872    33.677
  -116.411    33.949
>
  -116.921    34.262
  -116.411    33.949
>
  -116.921    34.262
  -116.411    33.949
>
  -116.827    34.348
  -116.411    33.949
>
  -116.827    34.348
  -116.411    33.949
>
  -117.004    33.709
  -116.411    33.949
>
  -117.004    33.709
  -116.411    33.949
>
  -117.009    33.650
  -116.411    33.949
>
  -117.009    33.650
  -116.411    33.949
>
  -117.111    34.035
  -116.411    33.949
>
  -117.098    34.106
  -116.411    33.949
>
  -117.098    34.106
  -116.411    33.949
>
  -117.041    33.612
  -116.411    33.949
>
  -117.041    33.612
  -116.411    33.949
>
  -115.638    33.708
  -116.411    33.949
>
  -115.638    33.708
  -116.411    33.949
>
  -116.417    33.268
  -116.411    33.949
>
  -116.417    33.268
  -116.411    33.949
>
  -117.219    34.121
  -116.411    33.949
>
  -115.637    33.167
  -115.606    33.048
>
  -115.637    33.167
  -115.606    33.048
>
  -115.824    32.955
  -115.606    33.048
>
  -115.824    32.955
  -115.606    33.048
>
  -115.447    32.805
  -115.606    33.048
>
  -115.304    33.239
  -115.606    33.048
>
  -115.304    33.239
  -115.606    33.048
>
  -115.732    32.759
  -115.606    33.048
>
  -115.732    32.759
  -115.606    33.048
>
  -115.733    33.353
  -115.606    33.048
>
  -115.733    33.353
  -115.606    33.048
>
  -115.730    33.365
  -115.606    33.048
>
  -115.730    33.365
  -115.606    33.048
>
  -115.638    33.402
  -115.606    33.048
>
  -115.638    33.402
  -115.606    33.048
>
  -115.969    32.887
  -115.606    33.048
>
  -115.969    32.887
  -115.606    33.048
>
  -115.986    33.280
  -115.606    33.048
>
  -115.725    32.649
  -115.606    33.048
>
  -115.725    32.649
  -115.606    33.048
>
  -115.123    32.863
  -115.606    33.048
>
  -115.923    32.648
  -115.606    33.048
>
  -115.923    32.648
  -115.606    33.048
>
  -116.174    33.171
  -115.606    33.048
>
  -114.977    32.972
  -115.606    33.048
>
  -114.977    32.972
  -115.606    33.048
>
  -114.985    32.739
  -115.606    33.048
>
  -114.985    32.739
  -115.606    33.048
>
  -116.109    32.650
  -115.606    33.048
>
  -116.109    32.650
  -115.606    33.048
>
  -116.079    32.603
  -115.606    33.048
>
  -116.079    32.603
  -115.606    33.048
>
  -115.454    33.655
  -115.606    33.048
>
  -115.454    33.655
  -115.606    33.048
>
  -115.638    33.708
  -115.606    33.048
>
  -115.638    33.708
  -115.606    33.048
>
  -115.304    32.418
  -115.606    33.048
>
  -115.872    33.677
  -115.606    33.048
>
  -115.990    33.655
  -115.606    33.048
>
  -115.990    33.655
  -115.606    33.048
>
  -115.561    32.902
  -115.609    33.060
>
  -115.561    32.902
  -115.609    33.060
>
  -115.800    32.945
  -115.609    33.060
>
  -115.800    32.945
  -115.609    33.060
>
  -115.824    32.955
  -115.609    33.060
>
  -115.824    32.955
  -115.609    33.060
>
  -115.593    33.276
  -115.609    33.060
>
  -115.732    32.759
  -115.609    33.060
>
  -115.304    33.239
  -115.609    33.060
>
  -115.304    33.239
  -115.609    33.060
>
  -115.730    33.365
  -115.609    33.060
>
  -115.969    32.887
  -115.609    33.060
>
  -115.638    33.402
  -115.609    33.060
>
  -115.638    33.402
  -115.609    33.060
>
  -115.986    33.280
  -115.609    33.060
>
  -115.725    32.649
  -115.609    33.060
>
  -115.123    32.863
  -115.609    33.060
>
  -115.923    32.648
  -115.609    33.060
>
  -115.923    32.648
  -115.609    33.060
>
  -114.977    32.972
  -115.609    33.060
>
  -116.109    32.650
  -115.609    33.060
>
  -116.079    32.603
  -115.609    33.060
>
  -114.985    32.739
  -115.609    33.060
>
  -115.454    33.655
  -115.609    33.060
>
  -115.454    33.655
  -115.609    33.060
>
  -115.638    33.708
  -115.609    33.060
>
  -115.638    33.708
  -115.609    33.060
>
  -115.872    33.677
  -115.609    33.060
>
  -115.872    33.677
  -115.609    33.060
>
  -115.304    32.418
  -115.609    33.060
>
  -115.990    33.655
  -115.609    33.060
>
  -115.990    33.655
  -115.609    33.060
>
  -115.561    32.902
  -115.602    33.055
>
  -115.561    32.902
  -115.602    33.055
>
  -115.800    32.945
  -115.602    33.055
>
  -115.824    32.955
  -115.602    33.055
>
  -115.824    32.955
  -115.602    33.055
>
  -115.728    32.850
  -115.602    33.055
>
  -115.593    33.276
  -115.602    33.055
>
  -115.437    32.862
  -115.602    33.055
>
  -115.437    32.862
  -115.602    33.055
>
  -115.447    32.805
  -115.602    33.055
>
  -115.732    32.759
  -115.602    33.055
>
  -115.304    33.239
  -115.602    33.055
>
  -115.304    33.239
  -115.602    33.055
>
  -115.969    32.887
  -115.602    33.055
>
  -115.638    33.402
  -115.602    33.055
>
  -115.986    33.280
  -115.602    33.055
>
  -115.725    32.649
  -115.602    33.055
>
  -115.725    32.649
  -115.602    33.055
>
  -115.123    32.863
  -115.602    33.055
>
  -115.123    32.863
  -115.602    33.055
>
  -116.174    33.171
  -115.602    33.055
>
  -116.174    33.171
  -115.602    33.055
>
  -115.923    32.648
  -115.602    33.055
>
  -114.977    32.972
  -115.602    33.055
>
  -114.977    32.972
  -115.602    33.055
>
  -116.079    32.603
  -115.602    33.055
>
  -116.079    32.603
  -115.602    33.055
>
  -115.454    33.655
  -115.602    33.055
>
  -115.454    33.655
  -115.602    33.055
>
  -114.985    32.739
  -115.602    33.055
>
  -114.985    32.739
  -115.602    33.055
>
  -115.638    33.708
  -115.602    33.055
>
  -115.638    33.708
  -115.602    33.055
>
  -115.872    33.677
  -115.602    33.055
>
  -115.872    33.677
  -115.602    33.055
>
  -115.990    33.655
  -115.602    33.055
>
  -115.304    32.418
  -115.602    33.055
>
  -115.304    32.418
  -115.602    33.055
>
  -115.800    32.945
  -115.606    33.052
>
  -115.800    32.945
  -115.606    33.052
>
  -115.823    33.117
  -115.606    33.052
>
  -115.823    33.117
  -115.606    33.052
>
  -115.824    32.955
  -115.606    33.052
>
  -115.824    32.955
  -115.606    33.052
>
  -115.728    32.850
  -115.606    33.052
>
  -115.593    33.276
  -115.606    33.052
>
  -115.593    33.276
  -115.606    33.052
>
  -115.447    32.805
  -115.606    33.052
>
  -115.732    32.759
  -115.606    33.052
>
  -115.732    32.759
  -115.606    33.052
>
  -115.304    33.239
  -115.606    33.052
>
  -115.304    33.239
  -115.606    33.052
>
  -115.733    33.353
  -115.606    33.052
>
  -115.730    33.365
  -115.606    33.052
>
  -115.730    33.365
  -115.606    33.052
>
  -115.969    32.887
  -115.606    33.052
>
  -115.969    32.887
  -115.606    33.052
>
  -115.638    33.402
  -115.606    33.052
>
  -115.725    32.649
  -115.606    33.052
>
  -115.986    33.280
  -115.606    33.052
>
  -115.123    32.863
  -115.606    33.052
>
  -115.923    32.648
  -115.606    33.052
>
  -115.923    32.648
  -115.606    33.052
>
  -116.174    33.171
  -115.606    33.052
>
  -116.174    33.171
  -115.606    33.052
>
  -114.977    32.972
  -115.606    33.052
>
  -116.109    32.650
  -115.606    33.052
>
  -114.985    32.739
  -115.606    33.052
>
  -114.985    32.739
  -115.606    33.052
>
  -115.454    33.655
  -115.606    33.052
>
  -115.454    33.655
  -115.606    33.052
>
  -115.304    32.418
  -115.606    33.052
>
  -115.872    33.677
  -115.606    33.052
>
  -115.637    33.167
  -115.611    33.057
>
  -115.637    33.167
  -115.611    33.057
>
  -115.561    32.902
  -115.611    33.057
>
  -115.561    32.902
  -115.611    33.057
>
  -115.823    33.117
  -115.611    33.057
>
  -115.824    32.955
  -115.611    33.057
>
  -115.824    32.955
  -115.611    33.057
>
  -115.593    33.276
  -115.611    33.057
>
  -115.593    33.276
  -115.611    33.057
>
  -115.447    32.805
  -115.611    33.057
>
  -115.447    32.805
  -115.611    33.057
>
  -115.969    32.887
  -115.611    33.057
>
  -115.733    33.353
  -115.611    33.057
>
  -115.733    33.353
  -115.611    33.057
>
  -115.730    33.365
  -115.611    33.057
>
  -115.730    33.365
  -115.611    33.057
>
  -115.638    33.402
  -115.611    33.057
>
  -115.638    33.402
  -115.611    33.057
>
  -115.986    33.280
  -115.611    33.057
>
  -115.725    32.649
  -115.611    33.057
>
  -115.923    32.648
  -115.611    33.057
>
  -115.923    32.648
  -115.611    33.057
>
  -115.123    32.863
  -115.611    33.057
>
  -116.079    32.603
  -115.611    33.057
>
  -114.985    32.739
  -115.611    33.057
>
  -115.454    33.655
  -115.611    33.057
>
  -115.454    33.655
  -115.611    33.057
>
  -115.304    32.418
  -115.611    33.057
>
  -115.304    32.418
  -115.611    33.057
>
  -115.637    33.167
  -115.615    33.065
>
  -115.561    32.902
  -115.615    33.065
>
  -115.561    32.902
  -115.615    33.065
>
  -115.824    32.955
  -115.615    33.065
>
  -115.824    32.955
  -115.615    33.065
>
  -115.593    33.276
  -115.615    33.065
>
  -115.593    33.276
  -115.615    33.065
>
  -115.728    32.850
  -115.615    33.065
>
  -115.733    33.353
  -115.615    33.065
>
  -115.733    33.353
  -115.615    33.065
>
  -115.447    32.805
  -115.615    33.065
>
  -115.447    32.805
  -115.615    33.065
>
  -115.730    33.365
  -115.615    33.065
>
  -115.730    33.365
  -115.615    33.065
>
  -115.732    32.759
  -115.615    33.065
>
  -115.732    32.759
  -115.615    33.065
>
  -115.304    33.239
  -115.615    33.065
>
  -115.969    32.887
  -115.615    33.065
>
  -115.638    33.402
  -115.615    33.065
>
  -115.638    33.402
  -115.615    33.065
>
  -115.986    33.280
  -115.615    33.065
>
  -115.725    32.649
  -115.615    33.065
>
  -115.725    32.649
  -115.615    33.065
>
  -115.123    32.863
  -115.615    33.065
>
  -115.923    32.648
  -115.615    33.065
>
  -115.923    32.648
  -115.615    33.065
>
  -114.977    32.972
  -115.615    33.065
>
  -116.109    32.650
  -115.615    33.065
>
  -116.079    32.603
  -115.615    33.065
>
  -115.454    33.655
  -115.615    33.065
>
  -115.454    33.655
  -115.615    33.065
>
  -114.985    32.739
  -115.615    33.065
>
  -115.872    33.677
  -115.615    33.065
>
  -115.638    33.708
  -115.615    33.065
>
  -115.990    33.655
  -115.615    33.065
>
  -115.304    32.418
  -115.615    33.065
>
  -115.304    32.418
  -115.615    33.065
>
  -115.561    32.902
  -115.603    33.047
>
  -115.561    32.902
  -115.603    33.047
>
  -115.824    32.955
  -115.603    33.047
>
  -115.824    32.955
  -115.603    33.047
>
  -115.728    32.850
  -115.603    33.047
>
  -115.728    32.850
  -115.603    33.047
>
  -115.437    32.862
  -115.603    33.047
>
  -115.437    32.862
  -115.603    33.047
>
  -115.593    33.276
  -115.603    33.047
>
  -115.593    33.276
  -115.603    33.047
>
  -115.447    32.805
  -115.603    33.047
>
  -115.447    32.805
  -115.603    33.047
>
  -115.732    32.759
  -115.603    33.047
>
  -115.732    32.759
  -115.603    33.047
>
  -115.304    33.239
  -115.603    33.047
>
  -115.304    33.239
  -115.603    33.047
>
  -115.733    33.353
  -115.603    33.047
>
  -115.733    33.353
  -115.603    33.047
>
  -115.969    32.887
  -115.603    33.047
>
  -115.969    32.887
  -115.603    33.047
>
  -115.730    33.365
  -115.603    33.047
>
  -115.730    33.365
  -115.603    33.047
>
  -115.638    33.402
  -115.603    33.047
>
  -115.638    33.402
  -115.603    33.047
>
  -115.986    33.280
  -115.603    33.047
>
  -115.986    33.280
  -115.603    33.047
>
  -115.725    32.649
  -115.603    33.047
>
  -115.725    32.649
  -115.603    33.047
>
  -115.123    32.863
  -115.603    33.047
>
  -115.123    32.863
  -115.603    33.047
>
  -115.923    32.648
  -115.603    33.047
>
  -115.923    32.648
  -115.603    33.047
>
  -116.174    33.171
  -115.603    33.047
>
  -116.174    33.171
  -115.603    33.047
>
  -114.977    32.972
  -115.603    33.047
>
  -114.977    32.972
  -115.603    33.047
>
  -116.109    32.650
  -115.603    33.047
>
  -116.109    32.650
  -115.603    33.047
>
  -116.079    32.603
  -115.603    33.047
>
  -116.079    32.603
  -115.603    33.047
>
  -114.985    32.739
  -115.603    33.047
>
  -114.985    32.739
  -115.603    33.047
>
  -115.454    33.655
  -115.603    33.047
>
  -115.454    33.655
  -115.603    33.047
>
  -115.638    33.708
  -115.603    33.047
>
  -115.638    33.708
  -115.603    33.047
>
  -115.304    32.418
  -115.603    33.047
>
  -115.304    32.418
  -115.603    33.047
>
  -115.872    33.677
  -115.603    33.047
>
  -115.872    33.677
  -115.603    33.047
>
  -115.990    33.655
  -115.603    33.047
>
  -115.990    33.655
  -115.603    33.047
>
  -115.637    33.167
  -115.609    33.068
>
  -115.637    33.167
  -115.609    33.068
>
  -115.561    32.902
  -115.609    33.068
>
  -115.561    32.902
  -115.609    33.068
>
  -115.823    33.117
  -115.609    33.068
>
  -115.823    33.117
  -115.609    33.068
>
  -115.800    32.945
  -115.609    33.068
>
  -115.800    32.945
  -115.609    33.068
>
  -115.824    32.955
  -115.609    33.068
>
  -115.824    32.955
  -115.609    33.068
>
  -115.728    32.850
  -115.609    33.068
>
  -115.728    32.850
  -115.609    33.068
>
  -115.437    32.862
  -115.609    33.068
>
  -115.437    32.862
  -115.609    33.068
>
  -115.447    32.805
  -115.609    33.068
>
  -115.447    32.805
  -115.609    33.068
>
  -115.733    33.353
  -115.609    33.068
>
  -115.730    33.365
  -115.609    33.068
>
  -115.730    33.365
  -115.609    33.068
>
  -115.732    32.759
  -115.609    33.068
>
  -115.732    32.759
  -115.609    33.068
>
  -115.304    33.239
  -115.609    33.068
>
  -115.304    33.239
  -115.609    33.068
>
  -115.638    33.402
  -115.609    33.068
>
  -115.638    33.402
  -115.609    33.068
>
  -115.969    32.887
  -115.609    33.068
>
  -115.969    32.887
  -115.609    33.068
>
  -115.986    33.280
  -115.609    33.068
>
  -115.725    32.649
  -115.609    33.068
>
  -115.725    32.649
  -115.609    33.068
>
  -115.123    32.863
  -115.609    33.068
>
  -115.123    32.863
  -115.609    33.068
>
  -116.174    33.171
  -115.609    33.068
>
  -116.174    33.171
  -115.609    33.068
>
  -115.923    32.648
  -115.609    33.068
>
  -115.923    32.648
  -115.609    33.068
>
  -114.977    32.972
  -115.609    33.068
>
  -114.977    32.972
  -115.609    33.068
>
  -116.109    32.650
  -115.609    33.068
>
  -116.109    32.650
  -115.609    33.068
>
  -116.079    32.603
  -115.609    33.068
>
  -116.079    32.603
  -115.609    33.068
>
  -115.454    33.655
  -115.609    33.068
>
  -115.454    33.655
  -115.609    33.068
>
  -114.985    32.739
  -115.609    33.068
>
  -114.985    32.739
  -115.609    33.068
>
  -115.872    33.677
  -115.609    33.068
>
  -115.872    33.677
  -115.609    33.068
>
  -115.990    33.655
  -115.609    33.068
>
  -115.990    33.655
  -115.609    33.068
>
  -115.304    32.418
  -115.609    33.068
>
  -115.304    32.418
  -115.609    33.068
>
  -115.561    32.902
  -115.592    33.067
>
  -115.561    32.902
  -115.592    33.067
>
  -115.800    32.945
  -115.592    33.067
>
  -115.800    32.945
  -115.592    33.067
>
  -115.824    32.955
  -115.592    33.067
>
  -115.824    32.955
  -115.592    33.067
>
  -115.728    32.850
  -115.592    33.067
>
  -115.728    32.850
  -115.592    33.067
>
  -115.437    32.862
  -115.592    33.067
>
  -115.447    32.805
  -115.592    33.067
>
  -115.447    32.805
  -115.592    33.067
>
  -115.304    33.239
  -115.592    33.067
>
  -115.304    33.239
  -115.592    33.067
>
  -115.733    33.353
  -115.592    33.067
>
  -115.733    33.353
  -115.592    33.067
>
  -115.730    33.365
  -115.592    33.067
>
  -115.730    33.365
  -115.592    33.067
>
  -115.732    32.759
  -115.592    33.067
>
  -115.732    32.759
  -115.592    33.067
>
  -115.638    33.402
  -115.592    33.067
>
  -115.638    33.402
  -115.592    33.067
>
  -115.969    32.887
  -115.592    33.067
>
  -115.969    32.887
  -115.592    33.067
>
  -115.986    33.280
  -115.592    33.067
>
  -115.986    33.280
  -115.592    33.067
>
  -115.725    32.649
  -115.592    33.067
>
  -115.725    32.649
  -115.592    33.067
>
  -115.123    32.863
  -115.592    33.067
>
  -115.123    32.863
  -115.592    33.067
>
  -116.174    33.171
  -115.592    33.067
>
  -116.174    33.171
  -115.592    33.067
>
  -115.923    32.648
  -115.592    33.067
>
  -115.923    32.648
  -115.592    33.067
>
  -114.977    32.972
  -115.592    33.067
>
  -114.977    32.972
  -115.592    33.067
>
  -116.254    33.193
  -115.592    33.067
>
  -116.254    33.193
  -115.592    33.067
>
  -116.109    32.650
  -115.592    33.067
>
  -116.109    32.650
  -115.592    33.067
>
  -115.454    33.655
  -115.592    33.067
>
  -115.454    33.655
  -115.592    33.067
>
  -116.079    32.603
  -115.592    33.067
>
  -114.985    32.739
  -115.592    33.067
>
  -114.985    32.739
  -115.592    33.067
>
  -115.638    33.708
  -115.592    33.067
>
  -115.872    33.677
  -115.592    33.067
>
  -115.872    33.677
  -115.592    33.067
>
  -115.990    33.655
  -115.592    33.067
>
  -115.304    32.418
  -115.592    33.067
>
  -115.561    32.902
  -115.593    33.067
>
  -115.561    32.902
  -115.593    33.067
>
  -115.824    32.955
  -115.593    33.067
>
  -115.824    32.955
  -115.593    33.067
>
  -115.437    32.862
  -115.593    33.067
>
  -115.437    32.862
  -115.593    33.067
>
  -115.728    32.850
  -115.593    33.067
>
  -115.728    32.850
  -115.593    33.067
>
  -115.447    32.805
  -115.593    33.067
>
  -115.447    32.805
  -115.593    33.067
>
  -115.304    33.239
  -115.593    33.067
>
  -115.304    33.239
  -115.593    33.067
>
  -115.733    33.353
  -115.593    33.067
>
  -115.733    33.353
  -115.593    33.067
>
  -115.730    33.365
  -115.593    33.067
>
  -115.730    33.365
  -115.593    33.067
>
  -115.638    33.402
  -115.593    33.067
>
  -115.638    33.402
  -115.593    33.067
>
  -115.969    32.887
  -115.593    33.067
>
  -115.969    32.887
  -115.593    33.067
>
  -115.986    33.280
  -115.593    33.067
>
  -115.986    33.280
  -115.593    33.067
>
  -115.338    32.693
  -115.593    33.067
>
  -115.725    32.649
  -115.593    33.067
>
  -115.725    32.649
  -115.593    33.067
>
  -115.123    32.863
  -115.593    33.067
>
  -115.123    32.863
  -115.593    33.067
>
  -115.923    32.648
  -115.593    33.067
>
  -115.923    32.648
  -115.593    33.067
>
  -116.174    33.171
  -115.593    33.067
>
  -116.174    33.171
  -115.593    33.067
>
  -114.977    32.972
  -115.593    33.067
>
  -114.977    32.972
  -115.593    33.067
>
  -116.109    32.650
  -115.593    33.067
>
  -116.109    32.650
  -115.593    33.067
>
  -115.454    33.655
  -115.593    33.067
>
  -114.985    32.739
  -115.593    33.067
>
  -114.985    32.739
  -115.593    33.067
>
  -116.079    32.603
  -115.593    33.067
>
  -116.079    32.603
  -115.593    33.067
>
  -115.990    33.655
  -115.593    33.067
>
  -115.304    32.418
  -115.593    33.067
>
  -115.561    32.902
  -115.593    33.063
>
  -115.561    32.902
  -115.593    33.063
>
  -115.800    32.945
  -115.593    33.063
>
  -115.800    32.945
  -115.593    33.063
>
  -115.824    32.955
  -115.593    33.063
>
  -115.824    32.955
  -115.593    33.063
>
  -115.437    32.862
  -115.593    33.063
>
  -115.437    32.862
  -115.593    33.063
>
  -115.728    32.850
  -115.593    33.063
>
  -115.823    33.117
  -115.593    33.063
>
  -115.823    33.117
  -115.593    33.063
>
  -115.593    33.276
  -115.593    33.063
>
  -115.593    33.276
  -115.593    33.063
>
  -115.447    32.805
  -115.593    33.063
>
  -115.447    32.805
  -115.593    33.063
>
  -115.732    32.759
  -115.593    33.063
>
  -115.732    32.759
  -115.593    33.063
>
  -115.304    33.239
  -115.593    33.063
>
  -115.304    33.239
  -115.593    33.063
>
  -115.969    32.887
  -115.593    33.063
>
  -115.969    32.887
  -115.593    33.063
>
  -115.638    33.402
  -115.593    33.063
>
  -115.638    33.402
  -115.593    33.063
>
  -115.725    32.649
  -115.593    33.063
>
  -115.725    32.649
  -115.593    33.063
>
  -115.986    33.280
  -115.593    33.063
>
  -115.986    33.280
  -115.593    33.063
>
  -115.123    32.863
  -115.593    33.063
>
  -115.123    32.863
  -115.593    33.063
>
  -115.923    32.648
  -115.593    33.063
>
  -115.923    32.648
  -115.593    33.063
>
  -116.174    33.171
  -115.593    33.063
>
  -114.977    32.972
  -115.593    33.063
>
  -114.977    32.972
  -115.593    33.063
>
  -116.109    32.650
  -115.593    33.063
>
  -116.109    32.650
  -115.593    33.063
>
  -116.254    33.193
  -115.593    33.063
>
  -114.985    32.739
  -115.593    33.063
>
  -114.985    32.739
  -115.593    33.063
>
  -116.079    32.603
  -115.593    33.063
>
  -116.079    32.603
  -115.593    33.063
>
  -115.454    33.655
  -115.593    33.063
>
  -115.454    33.655
  -115.593    33.063
>
  -115.304    32.418
  -115.593    33.063
>
  -115.638    33.708
  -115.593    33.063
>
  -115.638    33.708
  -115.593    33.063
>
  -115.872    33.677
  -115.593    33.063
>
  -115.872    33.677
  -115.593    33.063
>
  -115.990    33.655
  -115.593    33.063
>
  -115.990    33.655
  -115.593    33.063
>
  -115.561    32.902
  -115.603    33.027
>
  -115.561    32.902
  -115.603    33.027
>
  -115.800    32.945
  -115.603    33.027
>
  -115.800    32.945
  -115.603    33.027
>
  -115.824    32.955
  -115.603    33.027
>
  -115.824    32.955
  -115.603    33.027
>
  -115.823    33.117
  -115.603    33.027
>
  -115.728    32.850
  -115.603    33.027
>
  -115.728    32.850
  -115.603    33.027
>
  -115.437    32.862
  -115.603    33.027
>
  -115.437    32.862
  -115.603    33.027
>
  -115.593    33.276
  -115.603    33.027
>
  -115.593    33.276
  -115.603    33.027
>
  -115.447    32.805
  -115.603    33.027
>
  -115.304    33.239
  -115.603    33.027
>
  -115.304    33.239
  -115.603    33.027
>
  -115.969    32.887
  -115.603    33.027
>
  -115.969    32.887
  -115.603    33.027
>
  -115.733    33.353
  -115.603    33.027
>
  -115.730    33.365
  -115.603    33.027
>
  -115.730    33.365
  -115.603    33.027
>
  -115.638    33.402
  -115.603    33.027
>
  -115.638    33.402
  -115.603    33.027
>
  -115.725    32.649
  -115.603    33.027
>
  -115.986    33.280
  -115.603    33.027
>
  -115.123    32.863
  -115.603    33.027
>
  -115.123    32.863
  -115.603    33.027
>
  -115.923    32.648
  -115.603    33.027
>
  -115.923    32.648
  -115.603    33.027
>
  -116.174    33.171
  -115.603    33.027
>
  -116.174    33.171
  -115.603    33.027
>
  -114.977    32.972
  -115.603    33.027
>
  -116.254    33.193
  -115.603    33.027
>
  -116.254    33.193
  -115.603    33.027
>
  -116.109    32.650
  -115.603    33.027
>
  -116.109    32.650
  -115.603    33.027
>
  -115.454    33.655
  -115.603    33.027
>
  -115.454    33.655
  -115.603    33.027
>
  -115.304    32.418
  -115.603    33.027
>
  -115.304    32.418
  -115.603    33.027
>
  -115.638    33.708
  -115.603    33.027
>
  -115.638    33.708
  -115.603    33.027
>
  -115.872    33.677
  -115.603    33.027
>
  -115.872    33.677
  -115.603    33.027
>
  -115.638    33.402
  -115.594    33.202
>
  -115.638    33.402
  -115.594    33.202
>
  -115.304    33.239
  -115.594    33.202
>
  -115.304    33.239
  -115.594    33.202
>
  -115.986    33.280
  -115.594    33.202
>
  -115.986    33.280
  -115.594    33.202
>
  -115.800    32.945
  -115.594    33.202
>
  -115.824    32.955
  -115.594    33.202
>
  -115.824    32.955
  -115.594    33.202
>
  -115.561    32.902
  -115.594    33.202
>
  -115.561    32.902
  -115.594    33.202
>
  -115.728    32.850
  -115.594    33.202
>
  -115.728    32.850
  -115.594    33.202
>
  -115.437    32.862
  -115.594    33.202
>
  -115.437    32.862
  -115.594    33.202
>
  -115.447    32.805
  -115.594    33.202
>
  -115.447    32.805
  -115.594    33.202
>
  -115.969    32.887
  -115.594    33.202
>
  -115.454    33.655
  -115.594    33.202
>
  -115.454    33.655
  -115.594    33.202
>
  -116.174    33.171
  -115.594    33.202
>
  -115.638    33.708
  -115.594    33.202
>
  -115.872    33.677
  -115.594    33.202
>
  -115.872    33.677
  -115.594    33.202
>
  -115.990    33.655
  -115.594    33.202
>
  -115.990    33.655
  -115.594    33.202
>
  -115.123    32.863
  -115.594    33.202
>
  -115.123    32.863
  -115.594    33.202
>
  -115.725    32.649
  -115.594    33.202
>
  -114.977    32.972
  -115.594    33.202
>
  -115.923    32.648
  -115.594    33.202
>
  -115.923    32.648
  -115.594    33.202
>
  -116.417    33.268
  -115.594    33.202
>
  -116.417    33.268
  -115.594    33.202
>
  -114.827    33.051
  -115.594    33.202
>
  -114.827    33.051
  -115.594    33.202
>
  -115.582    33.038
  -115.622    33.178
>
  -115.582    33.038
  -115.622    33.178
>
  -115.638    33.402
  -115.622    33.178
>
  -115.638    33.402
  -115.622    33.178
>
  -115.561    32.902
  -115.622    33.178
>
  -115.561    32.902
  -115.622    33.178
>
  -115.304    33.239
  -115.622    33.178
>
  -115.304    33.239
  -115.622    33.178
>
  -115.800    32.945
  -115.622    33.178
>
  -115.800    32.945
  -115.622    33.178
>
  -115.824    32.955
  -115.622    33.178
>
  -115.824    32.955
  -115.622    33.178
>
  -115.728    32.850
  -115.622    33.178
>
  -115.437    32.862
  -115.622    33.178
>
  -115.447    32.805
  -115.622    33.178
>
  -115.447    32.805
  -115.622    33.178
>
  -115.969    32.887
  -115.622    33.178
>
  -115.969    32.887
  -115.622    33.178
>
  -116.174    33.171
  -115.622    33.178
>
  -115.454    33.655
  -115.622    33.178
>
  -115.454    33.655
  -115.622    33.178
>
  -115.123    32.863
  -115.622    33.178
>
  -115.123    32.863
  -115.622    33.178
>
  -115.725    32.649
  -115.622    33.178
>
  -115.725    32.649
  -115.622    33.178
>
  -115.638    33.708
  -115.622    33.178
>
  -115.638    33.708
  -115.622    33.178
>
  -115.872    33.677
  -115.622    33.178
>
  -115.923    32.648
  -115.622    33.178
>
  -115.923    32.648
  -115.622    33.178
>
  -115.990    33.655
  -115.622    33.178
>
  -115.990    33.655
  -115.622    33.178
>
  -116.311    33.364
  -115.622    33.178
>
  -114.827    33.051
  -115.622    33.178
>
  -114.827    33.051
  -115.622    33.178
>
  -116.417    33.268
  -115.622    33.178
>
  -116.079    32.603
  -115.622    33.178
>
  -116.079    32.603
  -115.622    33.178
>
  -116.737    33.565
  -116.951    33.418
>
  -116.737    33.565
  -116.951    33.418
>
  -117.009    33.650
  -116.951    33.418
>
  -117.009    33.650
  -116.951    33.418
>
  -116.923    33.687
  -116.951    33.418
>
  -116.923    33.687
  -116.951    33.418
>
  -117.195    33.600
  -116.951    33.418
>
  -117.195    33.600
  -116.951    33.418
>
  -116.602    33.495
  -116.951    33.418
>
  -116.631    33.567
  -116.951    33.418
>
  -117.004    33.709
  -116.951    33.418
>
  -117.004    33.709
  -116.951    33.418
>
  -116.613    33.552
  -116.951    33.418
>
  -116.613    33.552
  -116.951    33.418
>
  -116.647    33.199
  -116.951    33.418
>
  -116.647    33.199
  -116.951    33.418
>
  -116.674    33.669
  -116.951    33.418
>
  -116.674    33.669
  -116.951    33.418
>
  -117.229    33.154
  -116.951    33.418
>
  -117.229    33.154
  -116.951    33.418
>
  -116.942    32.999
  -116.951    33.418
>
  -116.942    32.999
  -116.951    33.418
>
  -116.809    33.832
  -116.951    33.418
>
  -116.809    33.832
  -116.951    33.418
>
  -116.598    33.081
  -116.951    33.418
>
  -116.598    33.081
  -116.951    33.418
>
  -116.459    33.612
  -116.951    33.418
>
  -116.459    33.612
  -116.951    33.418
>
  -116.453    33.606
  -116.951    33.418
>
  -116.456    33.611
  -116.951    33.418
>
  -116.456    33.611
  -116.951    33.418
>
  -116.417    33.268
  -116.951    33.418
>
  -116.417    33.268
  -116.951    33.418
>
  -117.427    33.648
  -116.951    33.418
>
  -117.427    33.648
  -116.951    33.418
>
  -116.981    33.921
  -116.951    33.418
>
  -116.981    33.921
  -116.951    33.418
>
  -117.161    33.892
  -116.951    33.418
>
  -117.161    33.892
  -116.951    33.418
>
  -116.311    33.364
  -116.951    33.418
>
  -116.311    33.364
  -116.951    33.418
>
  -116.846    32.891
  -116.951    33.418
>
  -116.846    32.891
  -116.951    33.418
>
  -116.578    33.936
  -116.951    33.418
>
  -116.578    33.936
  -116.951    33.418
>
  -116.254    33.193
  -116.951    33.418
>
  -116.254    33.193
  -116.951    33.418
>
  -116.811    34.036
  -116.951    33.418
>
  -116.811    34.036
  -116.951    33.418
>
  -117.327    33.973
  -116.951    33.418
>
  -117.327    33.973
  -116.951    33.418
>
  -117.138    32.784
  -116.951    33.418
>
  -117.138    32.784
  -116.951    33.418
>
  -116.942    32.736
  -116.951    33.418
>
  -116.942    32.736
  -116.951    33.418
>
  -116.936    34.091
  -116.951    33.418
>
  -116.936    34.091
  -116.951    33.418
>
  -116.174    33.171
  -116.951    33.418
>
  -117.375    33.993
  -116.951    33.418
>
  -117.375    33.993
  -116.951    33.418
>
  -116.408    33.941
  -116.951    33.418
>
  -116.408    33.941
  -116.951    33.418
>
  -117.561    33.876
  -116.951    33.418
>
  -117.561    33.876
  -116.951    33.418
>
  -117.098    34.106
  -116.951    33.418
>
  -117.098    34.106
  -116.951    33.418
>
  -115.638    33.708
  -115.898    33.782
>
  -115.638    33.708
  -115.898    33.782
>
  -115.998    34.001
  -115.898    33.782
>
  -115.998    34.001
  -115.898    33.782
>
  -115.454    33.655
  -115.898    33.782
>
  -115.730    33.365
  -115.898    33.782
>
  -115.730    33.365
  -115.898    33.782
>
  -115.638    33.402
  -115.898    33.782
>
  -115.638    33.402
  -115.898    33.782
>
  -115.733    33.353
  -115.898    33.782
>
  -116.408    33.941
  -115.898    33.782
>
  -116.408    33.941
  -115.898    33.782
>
  -116.456    33.611
  -115.898    33.782
>
  -116.456    33.611
  -115.898    33.782
>
  -116.459    33.612
  -115.898    33.782
>
  -116.459    33.612
  -115.898    33.782
>
  -115.986    33.280
  -115.898    33.782
>
  -115.986    33.280
  -115.898    33.782
>
  -116.311    33.364
  -115.898    33.782
>
  -116.311    33.364
  -115.898    33.782
>
  -116.389    34.069
  -115.898    33.782
>
  -116.389    34.069
  -115.898    33.782
>
  -115.593    33.276
  -115.898    33.782
>
  -115.593    33.276
  -115.898    33.782
>
  -116.578    33.936
  -115.898    33.782
>
  -116.578    33.936
  -115.898    33.782
>
  -116.613    33.552
  -115.898    33.782
>
  -116.613    33.552
  -115.898    33.782
>
  -116.174    33.171
  -115.898    33.782
>
  -116.631    33.567
  -115.898    33.782
>
  -116.631    33.567
  -115.898    33.782
>
  -116.602    33.495
  -115.898    33.782
>
  -116.602    33.495
  -115.898    33.782
>
  -116.254    33.193
  -115.898    33.782
>
  -116.254    33.193
  -115.898    33.782
>
  -116.674    33.669
  -115.898    33.782
>
  -116.674    33.669
  -115.898    33.782
>
  -116.417    33.268
  -115.898    33.782
>
  -115.637    33.167
  -115.898    33.782
>
  -115.823    33.117
  -115.898    33.782
>
  -115.823    33.117
  -115.898    33.782
>
  -115.531    33.098
  -115.611    33.187
>
  -115.582    33.038
  -115.611    33.187
>
  -115.582    33.038
  -115.611    33.187
>
  -115.733    33.353
  -115.611    33.187
>
  -115.733    33.353
  -115.611    33.187
>
  -115.823    33.117
  -115.611    33.187
>
  -115.730    33.365
  -115.611    33.187
>
  -115.730    33.365
  -115.611    33.187
>
  -115.638    33.402
  -115.611    33.187
>
  -115.638    33.402
  -115.611    33.187
>
  -115.304    33.238
  -115.611    33.187
>
  -115.304    33.238
  -115.611    33.187
>
  -115.561    32.902
  -115.611    33.187
>
  -115.800    32.945
  -115.611    33.187
>
  -115.800    32.945
  -115.611    33.187
>
  -115.824    32.955
  -115.611    33.187
>
  -115.824    32.955
  -115.611    33.187
>
  -115.728    32.850
  -115.611    33.187
>
  -115.986    33.280
  -115.611    33.187
>
  -115.866    33.485
  -115.611    33.187
>
  -115.969    32.887
  -115.611    33.187
>
  -115.969    32.887
  -115.611    33.187
>
  -115.454    33.655
  -115.611    33.187
>
  -116.168    33.156
  -115.611    33.187
>
  -116.168    33.156
  -115.611    33.187
>
  -115.638    33.708
  -115.611    33.187
>
  -115.638    33.708
  -115.611    33.187
>
  -114.977    32.972
  -115.611    33.187
>
  -114.977    32.972
  -115.611    33.187
>
  -115.872    33.677
  -115.611    33.187
>
  -115.872    33.677
  -115.611    33.187
>
  -115.725    32.649
  -115.611    33.187
>
  -115.725    32.649
  -115.611    33.187
>
  -116.097    32.792
  -115.611    33.187
>
  -116.097    32.792
  -115.611    33.187
>
  -115.922    32.647
  -115.611    33.187
>
  -115.922    32.647
  -115.611    33.187
>
  -115.093    32.708
  -115.611    33.187
>
  -116.077    33.651
  -115.611    33.187
>
  -116.077    33.651
  -115.611    33.187
>
  -114.827    33.051
  -115.611    33.187
>
  -114.827    33.051
  -115.611    33.187
>
  -116.310    33.362
  -115.611    33.187
>
  -116.310    33.362
  -115.611    33.187
>
  -116.303    32.955
  -115.611    33.187
>
  -116.303    32.955
  -115.611    33.187
>
  -114.985    32.739
  -115.611    33.187
>
  -116.226    33.575
  -115.611    33.187
>
  -116.226    33.575
  -115.611    33.187
>
  -116.109    32.650
  -115.611    33.187
>
  -116.109    32.650
  -115.611    33.187
>
  -116.417    33.268
  -115.611    33.187
>
  -116.417    33.268
  -115.611    33.187
>
  -115.531    33.098
  -115.615    33.184
>
  -115.531    33.098
  -115.615    33.184
>
  -115.733    33.353
  -115.615    33.184
>
  -115.730    33.365
  -115.615    33.184
>
  -115.730    33.365
  -115.615    33.184
>
  -115.800    32.945
  -115.615    33.184
>
  -115.561    32.902
  -115.615    33.184
>
  -115.561    32.902
  -115.615    33.184
>
  -115.824    32.955
  -115.615    33.184
>
  -115.824    32.955
  -115.615    33.184
>
  -115.728    32.850
  -115.615    33.184
>
  -115.986    33.280
  -115.615    33.184
>
  -115.437    32.862
  -115.615    33.184
>
  -115.447    32.805
  -115.615    33.184
>
  -115.866    33.485
  -115.615    33.184
>
  -115.866    33.485
  -115.615    33.184
>
  -115.969    32.887
  -115.615    33.184
>
  -115.969    32.887
  -115.615    33.184
>
  -115.595    32.752
  -115.615    33.184
>
  -115.454    33.655
  -115.615    33.184
>
  -115.454    33.655
  -115.615    33.184
>
  -115.123    32.863
  -115.615    33.184
>
  -115.123    32.863
  -115.615    33.184
>
  -115.725    32.649
  -115.615    33.184
>
  -115.725    32.649
  -115.615    33.184
>
  -115.338    32.693
  -115.615    33.184
>
  -115.338    32.693
  -115.615    33.184
>
  -116.254    33.193
  -115.615    33.184
>
  -116.254    33.193
  -115.615    33.184
>
  -116.097    32.792
  -115.615    33.184
>
  -115.638    33.708
  -115.615    33.184
>
  -115.872    33.677
  -115.615    33.184
>
  -115.922    32.647
  -115.615    33.184
>
  -114.977    32.972
  -115.615    33.184
>
  -114.977    32.972
  -115.615    33.184
>
  -115.990    33.655
  -115.615    33.184
>
  -116.303    32.955
  -115.615    33.184
>
  -116.310    33.362
  -115.615    33.184
>
  -116.310    33.362
  -115.615    33.184
>
  -116.095    33.635
  -115.615    33.184
>
  -115.093    32.708
  -115.615    33.184
>
  -116.367    33.327
  -115.615    33.184
>
  -116.367    33.327
  -115.615    33.184
>
  -116.109    32.650
  -115.615    33.184
>
  -116.226    33.575
  -115.615    33.184
>
  -116.226    33.575
  -115.615    33.184
>
  -116.417    33.268
  -115.615    33.184
>
  -114.827    33.051
  -115.615    33.184
>
  -114.827    33.051
  -115.615    33.184
>
  -114.985    32.739
  -115.615    33.184
>
  -116.438    33.077
  -115.615    33.184
>
  -116.438    33.077
  -115.615    33.184
>
  -116.079    32.603
  -115.615    33.184
>
  -115.531    33.098
  -115.651    33.141
>
  -115.582    33.038
  -115.651    33.141
>
  -115.579    33.279
  -115.651    33.141
>
  -115.579    33.279
  -115.651    33.141
>
  -115.800    32.945
  -115.651    33.141
>
  -115.800    32.945
  -115.651    33.141
>
  -115.733    33.353
  -115.651    33.141
>
  -115.733    33.353
  -115.651    33.141
>
  -115.561    32.902
  -115.651    33.141
>
  -115.561    32.902
  -115.651    33.141
>
  -115.638    33.402
  -115.651    33.141
>
  -115.638    33.402
  -115.651    33.141
>
  -115.728    32.850
  -115.651    33.141
>
  -115.728    32.850
  -115.651    33.141
>
  -115.437    32.862
  -115.651    33.141
>
  -115.437    32.862
  -115.651    33.141
>
  -115.320    32.960
  -115.651    33.141
>
  -115.320    32.960
  -115.651    33.141
>
  -115.969    32.887
  -115.651    33.141
>
  -115.969    32.887
  -115.651    33.141
>
  -115.447    32.805
  -115.651    33.141
>
  -115.866    33.485
  -115.651    33.141
>
  -115.866    33.485
  -115.651    33.141
>
  -115.595    32.752
  -115.651    33.141
>
  -115.595    32.752
  -115.651    33.141
>
  -116.168    33.156
  -115.651    33.141
>
  -116.168    33.156
  -115.651    33.141
>
  -116.019    32.748
  -115.651    33.141
>
  -115.725    32.649
  -115.651    33.141
>
  -115.725    32.649
  -115.651    33.141
>
  -116.254    33.193
  -115.651    33.141
>
  -116.254    33.193
  -115.651    33.141
>
  -116.097    32.792
  -115.651    33.141
>
  -116.097    32.792
  -115.651    33.141
>
  -115.123    32.863
  -115.651    33.141
>
  -115.123    32.863
  -115.651    33.141
>
  -115.922    32.647
  -115.651    33.141
>
  -115.445    32.632
  -115.651    33.141
>
  -115.445    32.632
  -115.651    33.141
>
  -115.454    33.655
  -115.651    33.141
>
  -116.303    32.955
  -115.651    33.141
>
  -116.303    32.955
  -115.651    33.141
>
  -115.872    33.677
  -115.651    33.141
>
  -115.872    33.677
  -115.651    33.141
>
  -115.638    33.708
  -115.651    33.141
>
  -115.638    33.708
  -115.651    33.141
>
  -116.310    33.362
  -115.651    33.141
>
  -115.990    33.655
  -115.651    33.141
>
  -115.990    33.655
  -115.651    33.141
>
  -114.977    32.972
  -115.651    33.141
>
  -114.977    32.972
  -115.651    33.141
>
  -116.095    33.635
  -115.651    33.141
>
  -116.109    32.650
  -115.651    33.141
>
  -116.109    32.650
  -115.651    33.141
>
  -116.367    33.327
  -115.651    33.141
>
  -116.367    33.327
  -115.651    33.141
>
  -116.077    33.651
  -115.651    33.141
>
  -116.226    33.575
  -115.651    33.141
>
  -116.226    33.575
  -115.651    33.141
>
  -116.417    33.268
  -115.651    33.141
>
  -116.417    33.268
  -115.651    33.141
>
  -116.411    32.972
  -115.651    33.141
>
  -116.411    32.972
  -115.651    33.141
>
  -115.093    32.708
  -115.651    33.141
>
  -115.093    32.708
  -115.651    33.141
>
  -116.438    33.077
  -115.651    33.141
>
  -116.438    33.077
  -115.651    33.141
>
  -116.079    32.603
  -115.651    33.141
>
  -116.079    32.603
  -115.651    33.141
>
  -114.985    32.739
  -115.651    33.141
>
  -114.985    32.739
  -115.651    33.141
>
  -114.827    33.051
  -115.651    33.141
>
  -114.827    33.051
  -115.651    33.141
>
  -115.579    33.279
  -115.630    33.151
>
  -115.579    33.279
  -115.630    33.151
>
  -115.733    33.353
  -115.630    33.151
>
  -115.733    33.353
  -115.630    33.151
>
  -115.561    32.902
  -115.630    33.151
>
  -115.638    33.402
  -115.630    33.151
>
  -115.728    32.850
  -115.630    33.151
>
  -115.304    33.238
  -115.630    33.151
>
  -115.304    33.238
  -115.630    33.151
>
  -115.437    32.862
  -115.630    33.151
>
  -115.437    32.862
  -115.630    33.151
>
  -115.320    32.960
  -115.630    33.151
>
  -115.320    32.960
  -115.630    33.151
>
  -115.986    33.280
  -115.630    33.151
>
  -115.969    32.887
  -115.630    33.151
>
  -115.447    32.805
  -115.630    33.151
>
  -115.595    32.752
  -115.630    33.151
>
  -116.168    33.156
  -115.630    33.151
>
  -115.725    32.649
  -115.630    33.151
>
  -115.946    33.556
  -115.630    33.151
>
  -115.946    33.556
  -115.630    33.151
>
  -116.019    32.748
  -115.630    33.151
>
  -116.097    32.792
  -115.630    33.151
>
  -116.097    32.792
  -115.630    33.151
>
  -116.254    33.193
  -115.630    33.151
>
  -116.254    33.193
  -115.630    33.151
>
  -115.445    32.632
  -115.630    33.151
>
  -115.445    32.632
  -115.630    33.151
>
  -115.922    32.647
  -115.630    33.151
>
  -115.454    33.655
  -115.630    33.151
>
  -115.638    33.708
  -115.630    33.151
>
  -115.872    33.677
  -115.630    33.151
>
  -116.303    32.955
  -115.630    33.151
>
  -116.303    32.955
  -115.630    33.151
>
  -114.977    32.972
  -115.630    33.151
>
  -114.977    32.972
  -115.630    33.151
>
  -115.990    33.655
  -115.630    33.151
>
  -116.310    33.362
  -115.630    33.151
>
  -116.109    32.650
  -115.630    33.151
>
  -116.109    32.650
  -115.630    33.151
>
  -116.109    32.650
  -115.630    33.151
>
  -115.093    32.708
  -115.630    33.151
>
  -115.093    32.708
  -115.630    33.151
>
  -116.095    33.635
  -115.630    33.151
>
  -116.077    33.651
  -115.630    33.151
>
  -116.079    32.603
  -115.630    33.151
>
  -116.079    32.603
  -115.630    33.151
>
  -116.226    33.575
  -115.630    33.151
>
  -116.417    33.268
  -115.630    33.151
>
  -116.411    32.972
  -115.630    33.151
>
  -116.411    32.972
  -115.630    33.151
>
  -114.985    32.739
  -115.630    33.151
>
  -114.827    33.051
  -115.630    33.151
>
  -115.531    33.098
  -115.630    33.154
>
  -115.531    33.098
  -115.630    33.154
>
  -115.582    33.038
  -115.630    33.154
>
  -115.582    33.038
  -115.630    33.154
>
  -115.823    33.117
  -115.630    33.154
>
  -115.823    33.117
  -115.630    33.154
>
  -115.730    33.365
  -115.630    33.154
>
  -115.824    32.955
  -115.630    33.154
>
  -115.824    32.955
  -115.630    33.154
>
  -115.304    33.238
  -115.630    33.154
>
  -115.304    33.238
  -115.630    33.154
>
  -115.728    32.850
  -115.630    33.154
>
  -115.986    33.280
  -115.630    33.154
>
  -115.986    33.280
  -115.630    33.154
>
  -115.320    32.960
  -115.630    33.154
>
  -115.320    32.960
  -115.630    33.154
>
  -115.437    32.862
  -115.630    33.154
>
  -115.437    32.862
  -115.630    33.154
>
  -115.969    32.887
  -115.630    33.154
>
  -115.447    32.805
  -115.630    33.154
>
  -115.866    33.485
  -115.630    33.154
>
  -115.595    32.752
  -115.630    33.154
>
  -115.595    32.752
  -115.630    33.154
>
  -116.168    33.156
  -115.630    33.154
>
  -116.168    33.156
  -115.630    33.154
>
  -115.946    33.556
  -115.630    33.154
>
  -115.725    32.649
  -115.630    33.154
>
  -115.725    32.649
  -115.630    33.154
>
  -116.019    32.748
  -115.630    33.154
>
  -116.019    32.748
  -115.630    33.154
>
  -116.254    33.193
  -115.630    33.154
>
  -116.254    33.193
  -115.630    33.154
>
  -115.123    32.863
  -115.630    33.154
>
  -116.097    32.792
  -115.630    33.154
>
  -116.097    32.792
  -115.630    33.154
>
  -115.454    33.655
  -115.630    33.154
>
  -115.454    33.655
  -115.630    33.154
>
  -115.445    32.632
  -115.630    33.154
>
  -115.445    32.632
  -115.630    33.154
>
  -115.922    32.647
  -115.630    33.154
>
  -115.922    32.647
  -115.630    33.154
>
  -115.638    33.708
  -115.630    33.154
>
  -115.638    33.708
  -115.630    33.154
>
  -115.872    33.677
  -115.630    33.154
>
  -115.872    33.677
  -115.630    33.154
>
  -115.990    33.655
  -115.630    33.154
>
  -115.990    33.655
  -115.630    33.154
>
  -114.977    32.972
  -115.630    33.154
>
  -114.977    32.972
  -115.630    33.154
>
  -116.303    32.955
  -115.630    33.154
>
  -116.303    32.955
  -115.630    33.154
>
  -116.310    33.362
  -115.630    33.154
>
  -116.310    33.362
  -115.630    33.154
>
  -116.095    33.635
  -115.630    33.154
>
  -116.077    33.651
  -115.630    33.154
>
  -116.367    33.327
  -115.630    33.154
>
  -116.109    32.650
  -115.630    33.154
>
  -116.109    32.650
  -115.630    33.154
>
  -115.093    32.708
  -115.630    33.154
>
  -115.093    32.708
  -115.630    33.154
>
  -116.226    33.575
  -115.630    33.154
>
  -116.226    33.575
  -115.630    33.154
>
  -116.417    33.268
  -115.630    33.154
>
  -116.417    33.268
  -115.630    33.154
>
  -116.411    32.972
  -115.630    33.154
>
  -116.411    32.972
  -115.630    33.154
>
  -116.438    33.077
  -115.630    33.154
>
  -116.438    33.077
  -115.630    33.154
>
  -116.079    32.603
  -115.630    33.154
>
  -116.079    32.603
  -115.630    33.154
>
  -114.985    32.739
  -115.630    33.154
>
  -114.985    32.739
  -115.630    33.154
>
  -114.827    33.051
  -115.630    33.154
>
  -114.827    33.051
  -115.630    33.154
>
  -115.531    33.098
  -115.633    33.152
>
  -115.531    33.098
  -115.633    33.152
>
  -115.582    33.038
  -115.633    33.152
>
  -115.582    33.038
  -115.633    33.152
>
  -115.579    33.279
  -115.633    33.152
>
  -115.579    33.279
  -115.633    33.152
>
  -115.800    32.945
  -115.633    33.152
>
  -115.733    33.353
  -115.633    33.152
>
  -115.733    33.353
  -115.633    33.152
>
  -115.824    32.955
  -115.633    33.152
>
  -115.824    32.955
  -115.633    33.152
>
  -115.730    33.365
  -115.633    33.152
>
  -115.730    33.365
  -115.633    33.152
>
  -115.561    32.902
  -115.633    33.152
>
  -115.561    32.902
  -115.633    33.152
>
  -115.638    33.402
  -115.633    33.152
>
  -115.638    33.402
  -115.633    33.152
>
  -115.728    32.850
  -115.633    33.152
>
  -115.728    32.850
  -115.633    33.152
>
  -115.304    33.238
  -115.633    33.152
>
  -115.304    33.238
  -115.633    33.152
>
  -115.320    32.960
  -115.633    33.152
>
  -115.320    32.960
  -115.633    33.152
>
  -115.437    32.862
  -115.633    33.152
>
  -115.437    32.862
  -115.633    33.152
>
  -115.986    33.280
  -115.633    33.152
>
  -115.447    32.805
  -115.633    33.152
>
  -115.447    32.805
  -115.633    33.152
>
  -115.969    32.887
  -115.633    33.152
>
  -115.969    32.887
  -115.633    33.152
>
  -115.595    32.752
  -115.633    33.152
>
  -115.866    33.485
  -115.633    33.152
>
  -115.866    33.485
  -115.633    33.152
>
  -116.168    33.156
  -115.633    33.152
>
  -115.725    32.649
  -115.633    33.152
>
  -115.725    32.649
  -115.633    33.152
>
  -115.946    33.556
  -115.633    33.152
>
  -115.946    33.556
  -115.633    33.152
>
  -115.123    32.863
  -115.633    33.152
>
  -115.123    32.863
  -115.633    33.152
>
  -116.097    32.792
  -115.633    33.152
>
  -116.097    32.792
  -115.633    33.152
>
  -116.254    33.193
  -115.633    33.152
>
  -116.254    33.193
  -115.633    33.152
>
  -115.445    32.632
  -115.633    33.152
>
  -115.445    32.632
  -115.633    33.152
>
  -115.922    32.647
  -115.633    33.152
>
  -115.922    32.647
  -115.633    33.152
>
  -115.454    33.655
  -115.633    33.152
>
  -115.454    33.655
  -115.633    33.152
>
  -115.638    33.708
  -115.633    33.152
>
  -115.638    33.708
  -115.633    33.152
>
  -115.872    33.677
  -115.633    33.152
>
  -115.872    33.677
  -115.633    33.152
>
  -114.977    32.972
  -115.633    33.152
>
  -114.977    32.972
  -115.633    33.152
>
  -116.303    32.955
  -115.633    33.152
>
  -116.303    32.955
  -115.633    33.152
>
  -115.990    33.655
  -115.633    33.152
>
  -115.990    33.655
  -115.633    33.152
>
  -116.310    33.362
  -115.633    33.152
>
  -116.310    33.362
  -115.633    33.152
>
  -116.109    32.650
  -115.633    33.152
>
  -116.109    32.650
  -115.633    33.152
>
  -116.095    33.635
  -115.633    33.152
>
  -115.093    32.708
  -115.633    33.152
>
  -116.077    33.651
  -115.633    33.152
>
  -116.367    33.327
  -115.633    33.152
>
  -116.367    33.327
  -115.633    33.152
>
  -116.226    33.575
  -115.633    33.152
>
  -116.417    33.268
  -115.633    33.152
>
  -116.079    32.603
  -115.633    33.152
>
  -116.079    32.603
  -115.633    33.152
>
  -116.411    32.972
  -115.633    33.152
>
  -116.411    32.972
  -115.633    33.152
>
  -116.438    33.077
  -115.633    33.152
>
  -114.985    32.739
  -115.633    33.152
>
  -114.827    33.051
  -115.633    33.152
>
  -114.827    33.051
  -115.633    33.152
>
  -115.531    33.098
  -115.656    33.189
>
  -115.800    32.945
  -115.656    33.189
>
  -115.561    32.902
  -115.656    33.189
>
  -115.986    33.280
  -115.656    33.189
>
  -115.986    33.280
  -115.656    33.189
>
  -115.304    33.238
  -115.656    33.189
>
  -115.304    33.238
  -115.656    33.189
>
  -115.728    32.850
  -115.656    33.189
>
  -115.728    32.850
  -115.656    33.189
>
  -115.866    33.485
  -115.656    33.189
>
  -115.320    32.960
  -115.656    33.189
>
  -115.320    32.960
  -115.656    33.189
>
  -115.437    32.862
  -115.656    33.189
>
  -115.969    32.887
  -115.656    33.189
>
  -115.447    32.805
  -115.656    33.189
>
  -116.168    33.156
  -115.656    33.189
>
  -116.168    33.156
  -115.656    33.189
>
  -115.595    32.752
  -115.656    33.189
>
  -115.595    32.752
  -115.656    33.189
>
  -115.946    33.556
  -115.656    33.189
>
  -116.254    33.193
  -115.656    33.189
>
  -116.254    33.193
  -115.656    33.189
>
  -115.454    33.655
  -115.656    33.189
>
  -115.454    33.655
  -115.656    33.189
>
  -116.019    32.748
  -115.656    33.189
>
  -115.725    32.649
  -115.656    33.189
>
  -115.725    32.649
  -115.656    33.189
>
  -116.097    32.792
  -115.656    33.189
>
  -116.097    32.792
  -115.656    33.189
>
  -115.872    33.677
  -115.656    33.189
>
  -115.872    33.677
  -115.656    33.189
>
  -115.638    33.708
  -115.656    33.189
>
  -115.638    33.708
  -115.656    33.189
>
  -115.123    32.863
  -115.656    33.189
>
  -115.123    32.863
  -115.656    33.189
>
  -115.990    33.655
  -115.656    33.189
>
  -115.990    33.655
  -115.656    33.189
>
  -115.922    32.647
  -115.656    33.189
>
  -115.922    32.647
  -115.656    33.189
>
  -115.445    32.632
  -115.656    33.189
>
  -115.445    32.632
  -115.656    33.189
>
  -116.310    33.362
  -115.656    33.189
>
  -116.310    33.362
  -115.656    33.189
>
  -116.303    32.955
  -115.656    33.189
>
  -116.303    32.955
  -115.656    33.189
>
  -116.095    33.635
  -115.656    33.189
>
  -116.077    33.651
  -115.656    33.189
>
  -116.367    33.327
  -115.656    33.189
>
  -116.367    33.327
  -115.656    33.189
>
  -114.977    32.972
  -115.656    33.189
>
  -114.977    32.972
  -115.656    33.189
>
  -116.226    33.575
  -115.656    33.189
>
  -116.226    33.575
  -115.656    33.189
>
  -116.417    33.268
  -115.656    33.189
>
  -116.417    33.268
  -115.656    33.189
>
  -116.109    32.650
  -115.656    33.189
>
  -116.109    32.650
  -115.656    33.189
>
  -116.438    33.077
  -115.656    33.189
>
  -116.438    33.077
  -115.656    33.189
>
  -116.411    32.972
  -115.656    33.189
>
  -116.411    32.972
  -115.656    33.189
>
  -115.093    32.708
  -115.656    33.189
>
  -115.093    32.708
  -115.656    33.189
>
  -116.079    32.603
  -115.656    33.189
>
  -116.079    32.603
  -115.656    33.189
>
  -115.531    33.098
  -115.639    33.144
>
  -115.531    33.098
  -115.639    33.144
>
  -115.582    33.038
  -115.639    33.144
>
  -115.582    33.038
  -115.639    33.144
>
  -115.579    33.279
  -115.639    33.144
>
  -115.579    33.279
  -115.639    33.144
>
  -115.733    33.353
  -115.639    33.144
>
  -115.733    33.353
  -115.639    33.144
>
  -115.638    33.402
  -115.639    33.144
>
  -115.800    32.945
  -115.639    33.144
>
  -115.800    32.945
  -115.639    33.144
>
  -115.824    32.955
  -115.639    33.144
>
  -115.824    32.955
  -115.639    33.144
>
  -115.561    32.902
  -115.639    33.144
>
  -115.561    32.902
  -115.639    33.144
>
  -115.304    33.238
  -115.639    33.144
>
  -115.304    33.238
  -115.639    33.144
>
  -115.728    32.850
  -115.639    33.144
>
  -115.728    32.850
  -115.639    33.144
>
  -115.986    33.280
  -115.639    33.144
>
  -115.986    33.280
  -115.639    33.144
>
  -115.320    32.960
  -115.639    33.144
>
  -115.320    32.960
  -115.639    33.144
>
  -115.437    32.862
  -115.639    33.144
>
  -115.437    32.862
  -115.639    33.144
>
  -115.969    32.887
  -115.639    33.144
>
  -115.969    32.887
  -115.639    33.144
>
  -115.447    32.805
  -115.639    33.144
>
  -115.595    32.752
  -115.639    33.144
>
  -115.595    32.752
  -115.639    33.144
>
  -116.168    33.156
  -115.639    33.144
>
  -116.168    33.156
  -115.639    33.144
>
  -115.946    33.556
  -115.639    33.144
>
  -115.725    32.649
  -115.639    33.144
>
  -115.725    32.649
  -115.639    33.144
>
  -116.019    32.748
  -115.639    33.144
>
  -116.254    33.193
  -115.639    33.144
>
  -116.254    33.193
  -115.639    33.144
>
  -115.454    33.655
  -115.639    33.144
>
  -115.454    33.655
  -115.639    33.144
>
  -115.123    32.863
  -115.639    33.144
>
  -115.123    32.863
  -115.639    33.144
>
  -116.097    32.792
  -115.639    33.144
>
  -116.097    32.792
  -115.639    33.144
>
  -115.445    32.632
  -115.639    33.144
>
  -115.638    33.708
  -115.639    33.144
>
  -115.638    33.708
  -115.639    33.144
>
  -115.872    33.677
  -115.639    33.144
>
  -115.872    33.677
  -115.639    33.144
>
  -115.922    32.647
  -115.639    33.144
>
  -115.922    32.647
  -115.639    33.144
>
  -115.990    33.655
  -115.639    33.144
>
  -115.990    33.655
  -115.639    33.144
>
  -114.977    32.972
  -115.639    33.144
>
  -114.977    32.972
  -115.639    33.144
>
  -116.303    32.955
  -115.639    33.144
>
  -116.303    32.955
  -115.639    33.144
>
  -116.310    33.362
  -115.639    33.144
>
  -116.095    33.635
  -115.639    33.144
>
  -116.077    33.651
  -115.639    33.144
>
  -116.367    33.327
  -115.639    33.144
>
  -116.367    33.327
  -115.639    33.144
>
  -116.109    32.650
  -115.639    33.144
>
  -116.109    32.650
  -115.639    33.144
>
  -115.093    32.708
  -115.639    33.144
>
  -115.093    32.708
  -115.639    33.144
>
  -116.226    33.575
  -115.639    33.144
>
  -116.417    33.268
  -115.639    33.144
>
  -116.411    32.972
  -115.639    33.144
>
  -116.411    32.972
  -115.639    33.144
>
  -116.079    32.603
  -115.639    33.144
>
  -116.079    32.603
  -115.639    33.144
>
  -114.985    32.739
  -115.639    33.144
>
  -114.985    32.739
  -115.639    33.144
>
  -114.827    33.051
  -115.639    33.144
>
  -114.827    33.051
  -115.639    33.144
>
  -115.582    33.038
  -115.650    33.167
>
  -115.582    33.038
  -115.650    33.167
>
  -115.733    33.353
  -115.650    33.167
>
  -115.733    33.353
  -115.650    33.167
>
  -115.638    33.402
  -115.650    33.167
>
  -115.800    32.945
  -115.650    33.167
>
  -115.824    32.955
  -115.650    33.167
>
  -115.824    32.955
  -115.650    33.167
>
  -115.986    33.280
  -115.650    33.167
>
  -115.986    33.280
  -115.650    33.167
>
  -115.561    32.902
  -115.650    33.167
>
  -115.561    32.902
  -115.650    33.167
>
  -115.728    32.850
  -115.650    33.167
>
  -115.866    33.485
  -115.650    33.167
>
  -115.320    32.960
  -115.650    33.167
>
  -115.320    32.960
  -115.650    33.167
>
  -115.437    32.862
  -115.650    33.167
>
  -115.969    32.887
  -115.650    33.167
>
  -115.969    32.887
  -115.650    33.167
>
  -115.447    32.805
  -115.650    33.167
>
  -115.447    32.805
  -115.650    33.167
>
  -116.168    33.156
  -115.650    33.167
>
  -115.595    32.752
  -115.650    33.167
>
  -115.946    33.556
  -115.650    33.167
>
  -116.254    33.193
  -115.650    33.167
>
  -116.254    33.193
  -115.650    33.167
>
  -116.019    32.748
  -115.650    33.167
>
  -116.019    32.748
  -115.650    33.167
>
  -116.097    32.792
  -115.650    33.167
>
  -115.725    32.649
  -115.650    33.167
>
  -115.725    32.649
  -115.650    33.167
>
  -115.454    33.655
  -115.650    33.167
>
  -115.454    33.655
  -115.650    33.167
>
  -115.872    33.677
  -115.650    33.167
>
  -115.872    33.677
  -115.650    33.167
>
  -115.638    33.708
  -115.650    33.167
>
  -115.638    33.708
  -115.650    33.167
>
  -115.990    33.655
  -115.650    33.167
>
  -115.123    32.863
  -115.650    33.167
>
  -115.922    32.647
  -115.650    33.167
>
  -115.922    32.647
  -115.650    33.167
>
  -116.095    33.635
  -115.650    33.167
>
  -116.367    33.327
  -115.650    33.167
>
  -116.367    33.327
  -115.650    33.167
>
  -114.977    32.972
  -115.650    33.167
>
  -114.977    32.972
  -115.650    33.167
>
  -116.417    33.268
  -115.650    33.167
>
  -116.417    33.268
  -115.650    33.167
>
  -116.109    32.650
  -115.650    33.167
>
  -116.438    33.077
  -115.650    33.167
>
  -116.438    33.077
  -115.650    33.167
>
  -116.411    32.972
  -115.650    33.167
>
  -115.093    32.708
  -115.650    33.167
>
  -115.093    32.708
  -115.650    33.167
>
  -116.079    32.603
  -115.650    33.167
>
  -115.580    33.121
  -115.663    33.209
>
  -115.580    33.121
  -115.663    33.209
>
  -115.823    33.117
  -115.663    33.209
>
  -115.823    33.117
  -115.663    33.209
>
  -115.531    33.098
  -115.663    33.209
>
  -115.531    33.098
  -115.663    33.209
>
  -115.582    33.038
  -115.663    33.209
>
  -115.582    33.038
  -115.663    33.209
>
  -115.733    33.353
  -115.663    33.209
>
  -115.733    33.353
  -115.663    33.209
>
  -115.730    33.365
  -115.663    33.209
>
  -115.730    33.365
  -115.663    33.209
>
  -115.638    33.402
  -115.663    33.209
>
  -115.824    32.955
  -115.663    33.209
>
  -115.824    32.955
  -115.663    33.209
>
  -115.800    32.945
  -115.663    33.209
>
  -115.986    33.280
  -115.663    33.209
>
  -115.561    32.902
  -115.663    33.209
>
  -115.304    33.238
  -115.663    33.209
>
  -115.304    33.238
  -115.663    33.209
>
  -115.866    33.485
  -115.663    33.209
>
  -115.866    33.485
  -115.663    33.209
>
  -115.728    32.850
  -115.663    33.209
>
  -115.728    32.850
  -115.663    33.209
>
  -115.437    32.862
  -115.663    33.209
>
  -115.969    32.887
  -115.663    33.209
>
  -115.969    32.887
  -115.663    33.209
>
  -116.168    33.156
  -115.663    33.209
>
  -116.168    33.156
  -115.663    33.209
>
  -115.447    32.805
  -115.663    33.209
>
  -115.946    33.556
  -115.663    33.209
>
  -116.254    33.193
  -115.663    33.209
>
  -116.254    33.193
  -115.663    33.209
>
  -115.454    33.655
  -115.663    33.209
>
  -115.872    33.677
  -115.663    33.209
>
  -115.638    33.708
  -115.663    33.209
>
  -115.638    33.708
  -115.663    33.209
>
  -115.990    33.655
  -115.663    33.209
>
  -115.990    33.655
  -115.663    33.209
>
  -116.097    32.792
  -115.663    33.209
>
  -116.097    32.792
  -115.663    33.209
>
  -115.725    32.649
  -115.663    33.209
>
  -115.725    32.649
  -115.663    33.209
>
  -116.310    33.362
  -115.663    33.209
>
  -115.123    32.863
  -115.663    33.209
>
  -115.123    32.863
  -115.663    33.209
>
  -116.077    33.651
  -115.663    33.209
>
  -116.303    32.955
  -115.663    33.209
>
  -116.303    32.955
  -115.663    33.209
>
  -115.922    32.647
  -115.663    33.209
>
  -115.922    32.647
  -115.663    33.209
>
  -116.226    33.575
  -115.663    33.209
>
  -114.977    32.972
  -115.663    33.209
>
  -114.977    32.972
  -115.663    33.209
>
  -116.417    33.268
  -115.663    33.209
>
  -116.417    33.268
  -115.663    33.209
>
  -116.109    32.650
  -115.663    33.209
>
  -116.109    32.650
  -115.663    33.209
>
  -116.438    33.077
  -115.663    33.209
>
  -116.411    32.972
  -115.663    33.209
>
  -116.411    32.972
  -115.663    33.209
>
  -115.093    32.708
  -115.663    33.209
>
  -116.079    32.603
  -115.663    33.209
>
  -116.079    32.603
  -115.663    33.209
>
  -115.580    33.121
  -115.663    33.211
>
  -115.580    33.121
  -115.663    33.211
>
  -115.733    33.353
  -115.663    33.211
>
  -115.733    33.353
  -115.663    33.211
>
  -115.531    33.098
  -115.663    33.211
>
  -115.582    33.038
  -115.663    33.211
>
  -115.582    33.038
  -115.663    33.211
>
  -115.638    33.402
  -115.663    33.211
>
  -115.638    33.402
  -115.663    33.211
>
  -115.986    33.280
  -115.663    33.211
>
  -115.986    33.280
  -115.663    33.211
>
  -115.824    32.955
  -115.663    33.211
>
  -115.304    33.238
  -115.663    33.211
>
  -115.304    33.238
  -115.663    33.211
>
  -115.561    32.902
  -115.663    33.211
>
  -115.561    32.902
  -115.663    33.211
>
  -115.866    33.485
  -115.663    33.211
>
  -115.728    32.850
  -115.663    33.211
>
  -115.728    32.850
  -115.663    33.211
>
  -115.437    32.862
  -115.663    33.211
>
  -115.437    32.862
  -115.663    33.211
>
  -115.969    32.887
  -115.663    33.211
>
  -115.969    32.887
  -115.663    33.211
>
  -115.946    33.556
  -115.663    33.211
>
  -116.168    33.156
  -115.663    33.211
>
  -116.168    33.156
  -115.663    33.211
>
  -115.447    32.805
  -115.663    33.211
>
  -115.447    32.805
  -115.663    33.211
>
  -115.595    32.752
  -115.663    33.211
>
  -115.595    32.752
  -115.663    33.211
>
  -115.454    33.655
  -115.663    33.211
>
  -115.454    33.655
  -115.663    33.211
>
  -116.254    33.193
  -115.663    33.211
>
  -116.254    33.193
  -115.663    33.211
>
  -115.872    33.677
  -115.663    33.211
>
  -115.872    33.677
  -115.663    33.211
>
  -115.638    33.708
  -115.663    33.211
>
  -115.990    33.655
  -115.663    33.211
>
  -115.990    33.655
  -115.663    33.211
>
  -116.097    32.792
  -115.663    33.211
>
  -116.097    32.792
  -115.663    33.211
>
  -116.095    33.635
  -115.663    33.211
>
  -116.310    33.362
  -115.663    33.211
>
  -115.725    32.649
  -115.663    33.211
>
  -115.725    32.649
  -115.663    33.211
>
  -116.077    33.651
  -115.663    33.211
>
  -116.077    33.651
  -115.663    33.211
>
  -115.123    32.863
  -115.663    33.211
>
  -115.123    32.863
  -115.663    33.211
>
  -116.303    32.955
  -115.663    33.211
>
  -116.303    32.955
  -115.663    33.211
>
  -116.226    33.575
  -115.663    33.211
>
  -116.367    33.327
  -115.663    33.211
>
  -116.367    33.327
  -115.663    33.211
>
  -115.922    32.647
  -115.663    33.211
>
  -115.922    32.647
  -115.663    33.211
>
  -115.445    32.632
  -115.663    33.211
>
  -115.445    32.632
  -115.663    33.211
>
  -114.977    32.972
  -115.663    33.211
>
  -114.977    32.972
  -115.663    33.211
>
  -116.417    33.268
  -115.663    33.211
>
  -116.417    33.268
  -115.663    33.211
>
  -116.438    33.077
  -115.663    33.211
>
  -116.438    33.077
  -115.663    33.211
>
  -116.411    32.972
  -115.663    33.211
>
  -116.411    32.972
  -115.663    33.211
>
  -116.109    32.650
  -115.663    33.211
>
  -116.109    32.650
  -115.663    33.211
>
  -115.093    32.708
  -115.663    33.211
>
  -115.093    32.708
  -115.663    33.211
>
  -116.079    32.603
  -115.663    33.211
>
  -116.079    32.603
  -115.663    33.211
>
  -115.580    33.121
  -115.672    33.207
>
  -115.579    33.279
  -115.672    33.207
>
  -115.531    33.098
  -115.672    33.207
>
  -115.823    33.117
  -115.672    33.207
>
  -115.582    33.038
  -115.672    33.207
>
  -115.582    33.038
  -115.672    33.207
>
  -115.730    33.365
  -115.672    33.207
>
  -115.730    33.365
  -115.672    33.207
>
  -115.800    32.945
  -115.672    33.207
>
  -115.800    32.945
  -115.672    33.207
>
  -115.824    32.955
  -115.672    33.207
>
  -115.986    33.280
  -115.672    33.207
>
  -115.986    33.280
  -115.672    33.207
>
  -115.304    33.238
  -115.672    33.207
>
  -115.304    33.238
  -115.672    33.207
>
  -115.561    32.902
  -115.672    33.207
>
  -115.866    33.485
  -115.672    33.207
>
  -115.866    33.485
  -115.672    33.207
>
  -115.728    32.850
  -115.672    33.207
>
  -115.320    32.960
  -115.672    33.207
>
  -115.969    32.887
  -115.672    33.207
>
  -115.969    32.887
  -115.672    33.207
>
  -116.168    33.156
  -115.672    33.207
>
  -115.447    32.805
  -115.672    33.207
>
  -115.447    32.805
  -115.672    33.207
>
  -115.595    32.752
  -115.672    33.207
>
  -115.595    32.752
  -115.672    33.207
>
  -115.454    33.655
  -115.672    33.207
>
  -115.454    33.655
  -115.672    33.207
>
  -116.254    33.193
  -115.672    33.207
>
  -115.638    33.708
  -115.672    33.207
>
  -115.990    33.655
  -115.672    33.207
>
  -115.990    33.655
  -115.672    33.207
>
  -116.097    32.792
  -115.672    33.207
>
  -116.097    32.792
  -115.672    33.207
>
  -115.725    32.649
  -115.672    33.207
>
  -115.725    32.649
  -115.672    33.207
>
  -115.123    32.863
  -115.672    33.207
>
  -115.123    32.863
  -115.672    33.207
>
  -116.095    33.635
  -115.672    33.207
>
  -116.310    33.362
  -115.672    33.207
>
  -116.077    33.651
  -115.672    33.207
>
  -115.922    32.647
  -115.672    33.207
>
  -115.922    32.647
  -115.672    33.207
>
  -116.303    32.955
  -115.672    33.207
>
  -116.226    33.575
  -115.672    33.207
>
  -116.367    33.327
  -115.672    33.207
>
  -116.367    33.327
  -115.672    33.207
>
  -114.977    32.972
  -115.672    33.207
>
  -114.977    32.972
  -115.672    33.207
>
  -116.417    33.268
  -115.672    33.207
>
  -116.417    33.268
  -115.672    33.207
>
  -116.438    33.077
  -115.672    33.207
>
  -116.109    32.650
  -115.672    33.207
>
  -116.109    32.650
  -115.672    33.207
>
  -116.411    32.972
  -115.672    33.207
>
  -115.093    32.708
  -115.672    33.207
>
  -115.093    32.708
  -115.672    33.207
>
  -116.079    32.603
  -115.672    33.207
>
  -116.079    32.603
  -115.672    33.207
>
  -115.580    33.121
  -115.673    33.206
>
  -115.580    33.121
  -115.673    33.206
>
  -115.733    33.353
  -115.673    33.206
>
  -115.730    33.365
  -115.673    33.206
>
  -115.582    33.038
  -115.673    33.206
>
  -115.582    33.038
  -115.673    33.206
>
  -115.638    33.402
  -115.673    33.206
>
  -115.986    33.280
  -115.673    33.206
>
  -115.986    33.280
  -115.673    33.206
>
  -115.824    32.955
  -115.673    33.206
>
  -115.824    32.955
  -115.673    33.206
>
  -115.800    32.945
  -115.673    33.206
>
  -115.800    32.945
  -115.673    33.206
>
  -115.561    32.902
  -115.673    33.206
>
  -115.561    32.902
  -115.673    33.206
>
  -115.304    33.238
  -115.673    33.206
>
  -115.304    33.238
  -115.673    33.206
>
  -115.866    33.485
  -115.673    33.206
>
  -115.866    33.485
  -115.673    33.206
>
  -115.728    32.850
  -115.673    33.206
>
  -115.728    32.850
  -115.673    33.206
>
  -115.969    32.887
  -115.673    33.206
>
  -115.969    32.887
  -115.673    33.206
>
  -115.437    32.862
  -115.673    33.206
>
  -115.437    32.862
  -115.673    33.206
>
  -116.168    33.156
  -115.673    33.206
>
  -115.946    33.556
  -115.673    33.206
>
  -115.946    33.556
  -115.673    33.206
>
  -115.447    32.805
  -115.673    33.206
>
  -115.595    32.752
  -115.673    33.206
>
  -116.254    33.193
  -115.673    33.206
>
  -115.454    33.655
  -115.673    33.206
>
  -115.454    33.655
  -115.673    33.206
>
  -115.872    33.677
  -115.673    33.206
>
  -115.872    33.677
  -115.673    33.206
>
  -115.638    33.708
  -115.673    33.206
>
  -115.990    33.655
  -115.673    33.206
>
  -115.990    33.655
  -115.673    33.206
>
  -116.097    32.792
  -115.673    33.206
>
  -116.097    32.792
  -115.673    33.206
>
  -115.725    32.649
  -115.673    33.206
>
  -115.725    32.649
  -115.673    33.206
>
  -116.310    33.362
  -115.673    33.206
>
  -116.095    33.635
  -115.673    33.206
>
  -116.077    33.651
  -115.673    33.206
>
  -116.303    32.955
  -115.673    33.206
>
  -116.303    32.955
  -115.673    33.206
>
  -115.123    32.863
  -115.673    33.206
>
  -115.123    32.863
  -115.673    33.206
>
  -115.922    32.647
  -115.673    33.206
>
  -116.367    33.327
  -115.673    33.206
>
  -116.367    33.327
  -115.673    33.206
>
  -116.226    33.575
  -115.673    33.206
>
  -116.226    33.575
  -115.673    33.206
>
  -115.445    32.632
  -115.673    33.206
>
  -116.417    33.268
  -115.673    33.206
>
  -116.417    33.268
  -115.673    33.206
>
  -114.977    32.972
  -115.673    33.206
>
  -114.977    32.972
  -115.673    33.206
>
  -116.438    33.077
  -115.673    33.206
>
  -116.438    33.077
  -115.673    33.206
>
  -116.411    32.972
  -115.673    33.206
>
  -116.411    32.972
  -115.673    33.206
>
  -116.109    32.650
  -115.673    33.206
>
  -116.109    32.650
  -115.673    33.206
>
  -115.093    32.708
  -115.673    33.206
>
  -115.093    32.708
  -115.673    33.206
>
  -116.079    32.603
  -115.673    33.206
>
  -116.079    32.603
  -115.673    33.206
>
  -115.969    32.887
  -115.961    33.078
>
  -115.969    32.887
  -115.961    33.078
>
  -115.986    33.280
  -115.961    33.078
>
  -115.728    32.850
  -115.961    33.078
>
  -115.728    32.850
  -115.961    33.078
>
  -115.616    33.178
  -115.961    33.078
>
  -115.616    33.178
  -115.961    33.078
>
  -116.097    32.792
  -115.961    33.078
>
  -115.582    33.038
  -115.961    33.078
>
  -115.582    33.038
  -115.961    33.078
>
  -115.580    33.121
  -115.961    33.078
>
  -115.580    33.121
  -115.961    33.078
>
  -116.019    32.748
  -115.961    33.078
>
  -115.730    33.365
  -115.961    33.078
>
  -115.730    33.365
  -115.961    33.078
>
  -115.531    33.098
  -115.961    33.078
>
  -115.531    33.098
  -115.961    33.078
>
  -115.579    33.279
  -115.961    33.078
>
  -115.579    33.279
  -115.961    33.078
>
  -115.561    32.902
  -115.961    33.078
>
  -116.411    32.972
  -115.961    33.078
>
  -115.866    33.485
  -115.961    33.078
>
  -116.310    33.362
  -115.961    33.078
>
  -115.638    33.402
  -115.961    33.078
>
  -116.367    33.327
  -115.961    33.078
>
  -116.367    33.327
  -115.961    33.078
>
  -116.417    33.268
  -115.961    33.078
>
  -116.417    33.268
  -115.961    33.078
>
  -115.922    32.647
  -115.961    33.078
>
  -115.922    32.647
  -115.961    33.078
>
  -115.595    32.752
  -115.961    33.078
>
  -115.595    32.752
  -115.961    33.078
>
  -116.109    32.650
  -115.961    33.078
>
  -115.725    32.649
  -115.961    33.078
>
  -115.725    32.649
  -115.961    33.078
>
  -116.079    32.603
  -115.961    33.078
>
  -116.598    33.081
  -115.961    33.078
>
  -116.226    33.575
  -115.961    33.078
>
  -115.320    32.960
  -115.961    33.078
>
  -115.320    32.960
  -115.961    33.078
>
  -116.529    32.823
  -115.961    33.078
>
  -115.990    33.655
  -115.961    33.078
>
  -116.077    33.651
  -115.961    33.078
>
  -116.077    33.651
  -115.961    33.078
>
  -116.627    32.906
  -115.961    33.078
>
  -116.426    33.523
  -115.961    33.078
>
  -116.647    33.199
  -115.961    33.078
>
  -116.647    33.199
  -115.961    33.078
>
  -115.872    33.677
  -115.961    33.078
>
  -115.445    32.632
  -115.961    33.078
>
  -115.338    32.693
  -115.961    33.078
>
  -116.378    33.648
  -115.961    33.078
>
  -116.378    33.648
  -115.961    33.078
>
  -116.459    33.612
  -115.961    33.078
>
  -116.456    33.612
  -115.961    33.078
>
  -116.459    33.612
  -115.961    33.078
>
  -116.459    33.612
  -115.961    33.078
>
  -116.602    33.495
  -115.961    33.078
>
  -116.603    33.495
  -115.961    33.078
>
  -115.531    33.098
  -115.653    33.138
>
  -115.531    33.098
  -115.653    33.138
>
  -115.582    33.038
  -115.653    33.138
>
  -115.582    33.038
  -115.653    33.138
>
  -115.579    33.279
  -115.653    33.138
>
  -115.579    33.279
  -115.653    33.138
>
  -115.800    32.945
  -115.653    33.138
>
  -115.733    33.353
  -115.653    33.138
>
  -115.733    33.353
  -115.653    33.138
>
  -115.824    32.955
  -115.653    33.138
>
  -115.824    32.955
  -115.653    33.138
>
  -115.730    33.365
  -115.653    33.138
>
  -115.730    33.365
  -115.653    33.138
>
  -115.561    32.902
  -115.653    33.138
>
  -115.561    32.902
  -115.653    33.138
>
  -115.638    33.402
  -115.653    33.138
>
  -115.638    33.402
  -115.653    33.138
>
  -115.728    32.850
  -115.653    33.138
>
  -115.304    33.238
  -115.653    33.138
>
  -115.304    33.238
  -115.653    33.138
>
  -115.437    32.862
  -115.653    33.138
>
  -115.437    32.862
  -115.653    33.138
>
  -115.320    32.960
  -115.653    33.138
>
  -115.320    32.960
  -115.653    33.138
>
  -115.969    32.887
  -115.653    33.138
>
  -115.969    32.887
  -115.653    33.138
>
  -115.447    32.805
  -115.653    33.138
>
  -115.447    32.805
  -115.653    33.138
>
  -115.866    33.485
  -115.653    33.138
>
  -115.866    33.485
  -115.653    33.138
>
  -116.168    33.156
  -115.653    33.138
>
  -115.725    32.649
  -115.653    33.138
>
  -115.725    32.649
  -115.653    33.138
>
  -115.946    33.556
  -115.653    33.138
>
  -115.946    33.556
  -115.653    33.138
>
  -116.019    32.748
  -115.653    33.138
>
  -116.019    32.748
  -115.653    33.138
>
  -116.097    32.792
  -115.653    33.138
>
  -116.097    32.792
  -115.653    33.138
>
  -115.338    32.693
  -115.653    33.138
>
  -115.338    32.693
  -115.653    33.138
>
  -116.254    33.193
  -115.653    33.138
>
  -116.254    33.193
  -115.653    33.138
>
  -115.445    32.632
  -115.653    33.138
>
  -115.445    32.632
  -115.653    33.138
>
  -115.922    32.647
  -115.653    33.138
>
  -115.922    32.647
  -115.653    33.138
>
  -115.454    33.655
  -115.653    33.138
>
  -115.454    33.655
  -115.653    33.138
>
  -115.638    33.708
  -115.653    33.138
>
  -115.638    33.708
  -115.653    33.138
>
  -115.872    33.677
  -115.653    33.138
>
  -115.872    33.677
  -115.653    33.138
>
  -116.303    32.955
  -115.653    33.138
>
  -116.303    32.955
  -115.653    33.138
>
  -114.977    32.972
  -115.653    33.138
>
  -114.977    32.972
  -115.653    33.138
>
  -115.990    33.655
  -115.653    33.138
>
  -115.990    33.655
  -115.653    33.138
>
  -116.310    33.362
  -115.653    33.138
>
  -116.310    33.362
  -115.653    33.138
>
  -116.109    32.650
  -115.653    33.138
>
  -116.109    32.650
  -115.653    33.138
>
  -116.077    33.651
  -115.653    33.138
>
  -116.077    33.651
  -115.653    33.138
>
  -115.093    32.708
  -115.653    33.138
>
  -115.093    32.708
  -115.653    33.138
>
  -116.367    33.327
  -115.653    33.138
>
  -116.367    33.327
  -115.653    33.138
>
  -116.226    33.575
  -115.653    33.138
>
  -116.417    33.268
  -115.653    33.138
>
  -116.417    33.268
  -115.653    33.138
>
  -116.411    32.972
  -115.653    33.138
>
  -116.411    32.972
  -115.653    33.138
>
  -116.079    32.603
  -115.653    33.138
>
  -116.079    32.603
  -115.653    33.138
>
  -116.438    33.077
  -115.653    33.138
>
  -116.438    33.077
  -115.653    33.138
>
  -114.985    32.739
  -115.653    33.138
>
  -114.985    32.739
  -115.653    33.138
>
  -114.827    33.051
  -115.653    33.138
>
  -114.827    33.051
  -115.653    33.138
>
  -116.561    33.352
  -116.447    33.484
>
  -116.531    33.557
  -116.447    33.484
>
  -116.367    33.327
  -116.447    33.484
>
  -116.367    33.327
  -116.447    33.484
>
  -116.310    33.362
  -116.447    33.484
>
  -116.310    33.362
  -116.447    33.484
>
  -116.459    33.612
  -116.447    33.484
>
  -116.459    33.612
  -116.447    33.484
>
  -116.456    33.612
  -116.447    33.484
>
  -116.459    33.612
  -116.447    33.484
>
  -116.613    33.552
  -116.447    33.484
>
  -116.613    33.552
  -116.447    33.484
>
  -116.417    33.268
  -116.447    33.484
>
  -116.631    33.567
  -116.447    33.484
>
  -116.631    33.567
  -116.447    33.484
>
  -116.226    33.575
  -116.447    33.484
>
  -116.596    33.644
  -116.447    33.484
>
  -116.596    33.644
  -116.447    33.484
>
  -116.737    33.565
  -116.447    33.484
>
  -116.674    33.669
  -116.447    33.484
>
  -116.674    33.669
  -116.447    33.484
>
  -116.647    33.199
  -116.447    33.484
>
  -116.647    33.199
  -116.447    33.484
>
  -116.647    33.199
  -116.447    33.484
>
  -116.647    33.199
  -116.447    33.484
>
  -116.254    33.193
  -116.447    33.484
>
  -116.254    33.193
  -116.447    33.484
>
  -116.800    33.512
  -116.447    33.484
>
  -116.800    33.512
  -116.447    33.484
>
  -116.237    33.706
  -116.447    33.484
>
  -116.237    33.706
  -116.447    33.484
>
  -116.714    33.711
  -116.447    33.484
>
  -116.712    33.714
  -116.447    33.484
>
  -116.862    33.353
  -116.447    33.484
>
  -116.862    33.353
  -116.447    33.484
>
  -116.438    33.077
  -116.447    33.484
>
  -116.438    33.077
  -116.447    33.484
>
  -116.239    33.768
  -116.447    33.484
>
  -116.239    33.768
  -116.447    33.484
>
  -116.168    33.156
  -116.447    33.484
>
  -116.168    33.156
  -116.447    33.484
>
  -116.715    33.746
  -116.447    33.484
>
  -116.715    33.746
  -116.447    33.484
>
  -116.077    33.651
  -116.447    33.484
>
  -116.077    33.651
  -116.447    33.484
>
  -116.848    33.630
  -116.447    33.484
>
  -116.598    33.081
  -116.447    33.484
>
  -116.369    33.818
  -116.447    33.484
>
  -116.911    33.482
  -116.447    33.484
>
  -116.911    33.482
  -116.447    33.484
>
  -116.221    33.797
  -116.447    33.484
>
  -115.986    33.280
  -116.447    33.484
>
  -115.986    33.280
  -116.447    33.484
>
  -115.946    33.556
  -116.447    33.484
>
  -115.990    33.655
  -116.447    33.484
>
  -116.768    33.073
  -116.447    33.484
>
  -116.768    33.073
  -116.447    33.484
>
  -116.797    33.834
  -116.447    33.484
>
  -117.032    33.389
  -116.447    33.484
>
  -117.032    33.389
  -116.447    33.484
>
  -116.579    32.959
  -116.447    33.484
>
  -116.579    32.959
  -116.447    33.484
>
  -116.409    33.941
  -116.447    33.484
>
  -116.409    33.941
  -116.447    33.484
>
  -116.303    32.955
  -116.447    33.484
>
  -116.303    32.955
  -116.447    33.484
>
  -116.578    33.936
  -116.447    33.484
>
  -116.578    33.936
  -116.447    33.484
>
  -117.064    33.491
  -116.447    33.484
>
  -117.064    33.491
  -116.447    33.484
>
  -117.021    33.239
  -116.447    33.484
>
  -117.021    33.239
  -116.447    33.484
>
  -117.041    33.612
  -116.447    33.484
>
  -117.001    33.708
  -116.447    33.484
>
  -117.001    33.708
  -116.447    33.484
>
  -116.173    33.925
  -116.447    33.484
>
  -116.173    33.925
  -116.447    33.484
>
  -116.784    33.914
  -116.447    33.484
>
  -116.784    33.914
  -116.447    33.484
>
  -116.627    32.906
  -116.447    33.484
>
  -116.627    32.906
  -116.447    33.484
>
  -116.968    33.808
  -116.447    33.484
>
  -116.968    33.808
  -116.447    33.484
>
  -117.140    33.504
  -116.447    33.484
>
  -117.140    33.504
  -116.447    33.484
>
  -117.171    33.458
  -116.447    33.484
>
  -116.942    32.999
  -116.447    33.484
>
  -116.942    32.999
  -116.447    33.484
>
  -115.733    33.353
  -116.447    33.484
>
  -115.733    33.353
  -116.447    33.484
>
  -115.730    33.365
  -116.447    33.484
>
  -115.730    33.365
  -116.447    33.484
>
  -116.648    34.038
  -116.447    33.484
>
  -116.648    34.038
  -116.447    33.484
>
  -115.823    33.117
  -116.447    33.484
>
  -115.823    33.117
  -116.447    33.484
>
  -116.529    32.823
  -116.447    33.484
>
  -116.529    32.823
  -116.447    33.484
>
  -117.195    33.600
  -116.447    33.484
>
  -116.846    32.891
  -116.447    33.484
>
  -116.846    32.891
  -116.447    33.484
>
  -117.122    33.123
  -116.447    33.484
>
  -117.122    33.123
  -116.447    33.484
>
  -116.981    33.921
  -116.447    33.484
>
  -117.156    33.736
  -116.447    33.484
>
  -117.156    33.736
  -116.447    33.484
>
  -116.808    34.035
  -116.447    33.484
>
  -115.998    34.001
  -116.447    33.484
>
  -115.998    34.001
  -116.447    33.484
>
  -115.638    33.402
  -116.447    33.484
>
  -115.638    33.402
  -116.447    33.484
>
  -116.940    34.049
  -116.447    33.484
>
  -117.032    33.389
  -116.919    33.342
>
  -116.911    33.482
  -116.919    33.342
>
  -116.911    33.482
  -116.919    33.342
>
  -117.021    33.239
  -116.919    33.342
>
  -117.021    33.239
  -116.919    33.342
>
  -116.759    33.236
  -116.919    33.342
>
  -116.759    33.236
  -116.919    33.342
>
  -116.800    33.512
  -116.919    33.342
>
  -116.800    33.512
  -116.919    33.342
>
  -117.064    33.491
  -116.919    33.342
>
  -117.064    33.491
  -116.919    33.342
>
  -117.176    33.290
  -116.919    33.342
>
  -117.176    33.290
  -116.919    33.342
>
  -116.667    33.492
  -116.919    33.342
>
  -117.140    33.504
  -116.919    33.342
>
  -117.140    33.504
  -116.919    33.342
>
  -116.647    33.199
  -116.919    33.342
>
  -116.647    33.199
  -116.919    33.342
>
  -117.111    33.134
  -116.919    33.342
>
  -117.111    33.134
  -116.919    33.342
>
  -117.122    33.123
  -116.919    33.342
>
  -117.122    33.123
  -116.919    33.342
>
  -116.561    33.352
  -116.919    33.342
>
  -116.848    33.630
  -116.919    33.342
>
  -116.768    33.073
  -116.919    33.342
>
  -116.768    33.073
  -116.919    33.342
>
  -116.602    33.495
  -116.919    33.342
>
  -116.631    33.567
  -116.919    33.342
>
  -116.613    33.552
  -116.919    33.342
>
  -116.613    33.552
  -116.919    33.342
>
  -117.291    33.281
  -116.919    33.342
>
  -117.291    33.281
  -116.919    33.342
>
  -116.942    32.999
  -116.919    33.342
>
  -116.924    33.687
  -116.919    33.342
>
  -116.924    33.687
  -116.919    33.342
>
  -117.325    33.342
  -116.919    33.342
>
  -117.195    33.600
  -116.919    33.342
>
  -116.598    33.081
  -116.919    33.342
>
  -117.001    33.708
  -116.919    33.342
>
  -117.001    33.708
  -116.919    33.342
>
  -116.674    33.669
  -116.919    33.342
>
  -116.674    33.669
  -116.919    33.342
>
  -116.531    33.557
  -116.919    33.342
>
  -116.531    33.557
  -116.919    33.342
>
  -116.980    33.729
  -116.919    33.342
>
  -116.980    33.729
  -116.919    33.342
>
  -117.163    33.014
  -116.919    33.342
>
  -117.163    33.014
  -116.919    33.342
>
  -116.596    33.644
  -116.919    33.342
>
  -116.596    33.644
  -116.919    33.342
>
  -116.714    33.711
  -116.919    33.342
>
  -117.042    32.955
  -116.919    33.342
>
  -117.042    32.955
  -116.919    33.342
>
  -116.712    33.714
  -116.919    33.342
>
  -117.245    33.054
  -116.919    33.342
>
  -117.245    33.054
  -116.919    33.342
>
  -117.334    33.535
  -116.919    33.342
>
  -117.334    33.535
  -116.919    33.342
>
  -116.417    33.268
  -116.919    33.342
>
  -117.378    33.198
  -116.919    33.342
>
  -116.715    33.746
  -116.919    33.342
>
  -116.715    33.746
  -116.919    33.342
>
  -117.030    32.917
  -116.919    33.342
>
  -117.030    32.917
  -116.919    33.342
>
  -116.426    33.523
  -116.919    33.342
>
  -117.156    33.736
  -116.919    33.342
>
  -117.156    33.736
  -116.919    33.342
>
  -116.367    33.327
  -116.919    33.342
>
  -116.367    33.327
  -116.919    33.342
>
  -116.846    32.891
  -116.919    33.342
>
  -116.846    32.891
  -116.919    33.342
>
  -116.459    33.612
  -116.919    33.342
>
  -116.459    33.612
  -116.919    33.342
>
  -116.453    33.606
  -116.919    33.342
>
  -116.459    33.612
  -116.919    33.342
>
  -116.579    32.959
  -116.919    33.342
>
  -116.579    32.959
  -116.919    33.342
>
  -117.142    32.915
  -116.919    33.342
>
  -117.142    32.915
  -116.919    33.342
>
  -116.438    33.077
  -116.919    33.342
>
  -116.438    33.077
  -116.919    33.342
>
  -117.326    33.675
  -116.919    33.342
>
  -117.326    33.675
  -116.919    33.342
>
  -116.627    32.906
  -116.919    33.342
>
  -116.627    32.906
  -116.919    33.342
>
  -116.310    33.362
  -116.919    33.342
>
  -116.310    33.362
  -116.919    33.342
>
  -116.974    32.840
  -116.919    33.342
>
  -116.974    32.840
  -116.919    33.342
>
  -117.426    33.649
  -116.919    33.342
>
  -117.426    33.649
  -116.919    33.342
>
  -117.224    32.879
  -116.919    33.342
>
  -117.224    32.879
  -116.919    33.342
>
  -116.550    33.824
  -116.919    33.342
>
  -116.254    33.193
  -116.919    33.342
>
  -116.254    33.193
  -116.919    33.342
>
  -117.580    33.388
  -116.919    33.342
>
  -117.580    33.388
  -116.919    33.342
>
  -117.391    33.744
  -116.919    33.342
>
  -117.391    33.744
  -116.919    33.342
>
  -117.205    33.862
  -116.919    33.342
>
  -116.784    33.914
  -116.919    33.342
>
  -116.784    33.914
  -116.919    33.342
>
  -117.428    33.731
  -116.919    33.342
>
  -117.428    33.731
  -116.919    33.342
>
  -117.558    33.558
  -116.919    33.342
>
  -117.558    33.558
  -116.919    33.342
>
  -117.138    32.784
  -116.919    33.342
>
  -117.138    32.784
  -116.919    33.342
>
  -116.942    32.736
  -116.919    33.342
>
  -116.529    32.823
  -116.919    33.342
>
  -116.529    32.823
  -116.919    33.342
>
  -116.226    33.575
  -116.919    33.342
>
  -117.080    32.735
  -116.919    33.342
>
  -117.080    32.735
  -116.919    33.342
>
  -116.303    32.955
  -116.919    33.342
>
  -117.173    33.947
  -116.919    33.342
>
  -117.173    33.947
  -116.919    33.342
>
  -116.168    33.156
  -116.919    33.342
>
  -116.168    33.156
  -116.919    33.342
>
  -116.755    32.703
  -116.919    33.342
>
  -116.755    32.703
  -116.919    33.342
>
  -116.578    33.936
  -116.919    33.342
>
  -117.445    33.817
  -116.919    33.342
>
  -117.445    33.817
  -116.919    33.342
>
  -117.669    33.485
  -116.919    33.342
>
  -117.669    33.485
  -116.919    33.342
>
  -117.241    32.749
  -116.919    33.342
>
  -117.241    32.749
  -116.919    33.342
>
  -117.158    32.710
  -116.919    33.342
>
  -117.609    33.674
  -116.919    33.342
>
  -117.609    33.674
  -116.919    33.342
>
  -117.077    32.669
  -116.919    33.342
>
  -117.077    32.669
  -116.919    33.342
>
  -116.672    32.680
  -116.919    33.342
>
  -116.672    32.680
  -116.919    33.342
>
  -115.582    33.038
  -115.522    32.923
>
  -115.582    33.038
  -115.522    32.923
>
  -115.582    33.038
  -115.522    32.923
>
  -115.582    33.038
  -115.522    32.923
>
  -115.447    32.805
  -115.522    32.923
>
  -115.447    32.805
  -115.522    32.923
>
  -115.447    32.805
  -115.522    32.923
>
  -115.320    32.960
  -115.522    32.923
>
  -115.320    32.960
  -115.522    32.923
>
  -115.531    33.098
  -115.522    32.923
>
  -115.531    33.098
  -115.522    32.923
>
  -115.595    32.752
  -115.522    32.923
>
  -115.728    32.850
  -115.522    32.923
>
  -115.580    33.121
  -115.522    32.923
>
  -115.800    32.945
  -115.522    32.923
>
  -115.800    32.945
  -115.522    32.923
>
  -115.800    32.945
  -115.522    32.923
>
  -115.800    32.945
  -115.522    32.923
>
  -115.472    32.664
  -115.522    32.923
>
  -115.472    32.664
  -115.522    32.923
>
  -115.616    33.178
  -115.522    32.923
>
  -115.623    33.183
  -115.522    32.923
>
  -115.623    33.183
  -115.522    32.923
>
  -115.445    32.632
  -115.522    32.923
>
  -115.445    32.632
  -115.522    32.923
>
  -115.669    32.652
  -115.522    32.923
>
  -115.385    32.628
  -115.522    32.923
>
  -115.385    32.628
  -115.522    32.923
>
  -115.823    33.117
  -115.522    32.923
>
  -115.725    32.649
  -115.522    32.923
>
  -115.725    32.649
  -115.522    32.923
>
  -115.123    32.863
  -115.522    32.923
>
  -115.579    33.279
  -115.522    32.923
>
  -115.579    33.279
  -115.522    32.923
>
  -115.969    32.887
  -115.522    32.923
>
  -115.969    32.887
  -115.522    32.923
>
  -115.581    32.537
  -115.522    32.923
>
  -115.581    32.537
  -115.522    32.923
>
  -115.093    32.708
  -115.522    32.923
>
  -115.922    32.647
  -115.522    32.923
>
  -115.922    32.647
  -115.522    32.923
>
  -115.922    32.647
  -115.522    32.923
>
  -115.922    32.647
  -115.522    32.923
>
  -114.977    32.972
  -115.522    32.923
>
  -114.977    32.972
  -115.522    32.923
>
  -116.019    32.748
  -115.522    32.923
>
  -115.978    33.174
  -115.522    32.923
>
  -115.978    33.174
  -115.522    32.923
>
  -115.730    33.365
  -115.522    32.923
>
  -115.094    32.605
  -115.522    32.923
>
  -115.094    32.605
  -115.522    32.923
>
  -114.985    32.739
  -115.522    32.923
>
  -114.985    32.739
  -115.522    32.923
>
  -114.985    32.739
  -115.522    32.923
>
  -115.638    33.402
  -115.522    32.923
>
  -116.097    32.792
  -115.522    32.923
>
  -115.986    33.280
  -115.522    32.923
>
  -115.986    33.280
  -115.522    32.923
>
  -115.304    32.418
  -115.522    32.923
>
  -115.304    32.418
  -115.522    32.923
>
  -115.305    32.420
  -115.522    32.923
>
  -115.305    32.420
  -115.522    32.923
>
  -116.079    32.603
  -115.522    32.923
>
  -116.079    32.603
  -115.522    32.923
>
  -116.109    32.650
  -115.522    32.923
>
  -116.109    32.650
  -115.522    32.923
>
  -116.109    32.650
  -115.522    32.923
>
  -116.079    32.603
  -115.522    32.923
>
  -116.079    32.603
  -115.522    32.923
>
  -115.198    32.407
  -115.522    32.923
>
  -115.198    32.407
  -115.522    32.923
>
  -114.827    33.051
  -115.522    32.923
>
  -114.827    33.051
  -115.522    32.923
>
  -116.168    33.156
  -115.522    32.923
>
  -116.168    33.156
  -115.522    32.923
>
  -114.784    32.845
  -115.522    32.923
>
  -114.784    32.845
  -115.522    32.923
>
  -115.866    33.485
  -115.522    32.923
>
  -116.303    32.955
  -115.522    32.923
>
  -116.303    32.955
  -115.522    32.923
>
  -114.964    32.433
  -115.522    32.923
>
  -114.964    32.433
  -115.522    32.923
>
  -114.964    32.433
  -115.522    32.923
>
  -116.254    33.193
  -115.522    32.923
>
  -116.254    33.193
  -115.522    32.923
>
  -116.254    33.193
  -115.522    32.923
>
  -116.417    33.268
  -116.405    33.407
>
  -116.417    33.268
  -116.405    33.407
>
  -116.561    33.352
  -116.405    33.407
>
  -116.561    33.352
  -116.405    33.407
>
  -116.603    33.495
  -116.405    33.407
>
  -116.603    33.495
  -116.405    33.407
>
  -116.602    33.495
  -116.405    33.407
>
  -116.602    33.495
  -116.405    33.407
>
  -116.453    33.606
  -116.405    33.407
>
  -116.459    33.612
  -116.405    33.407
>
  -116.459    33.612
  -116.405    33.407
>
  -116.459    33.612
  -116.405    33.407
>
  -116.459    33.612
  -116.405    33.407
>
  -116.459    33.612
  -116.405    33.407
>
  -116.226    33.575
  -116.405    33.407
>
  -116.226    33.575
  -116.405    33.407
>
  -116.254    33.193
  -116.405    33.407
>
  -116.254    33.193
  -116.405    33.407
>
  -116.254    33.193
  -116.405    33.407
>
  -116.613    33.552
  -116.405    33.407
>
  -116.613    33.552
  -116.405    33.407
>
  -116.103    33.469
  -116.405    33.407
>
  -116.103    33.469
  -116.405    33.407
>
  -116.378    33.648
  -116.405    33.407
>
  -116.378    33.648
  -116.405    33.407
>
  -116.631    33.567
  -116.405    33.407
>
  -116.596    33.598
  -116.405    33.407
>
  -116.596    33.598
  -116.405    33.407
>
  -116.647    33.199
  -116.405    33.407
>
  -116.647    33.199
  -116.405    33.407
>
  -116.647    33.199
  -116.405    33.407
>
  -116.647    33.199
  -116.405    33.407
>
  -116.596    33.644
  -116.405    33.407
>
  -116.596    33.644
  -116.405    33.407
>
  -116.168    33.156
  -116.405    33.407
>
  -116.168    33.156
  -116.405    33.407
>
  -116.438    33.077
  -116.405    33.407
>
  -116.438    33.077
  -116.405    33.407
>
  -116.737    33.565
  -116.405    33.407
>
  -116.737    33.565
  -116.405    33.407
>
  -116.759    33.236
  -116.405    33.407
>
  -116.759    33.236
  -116.405    33.407
>
  -116.598    33.081
  -116.405    33.407
>
  -116.598    33.081
  -116.405    33.407
>
  -116.800    33.512
  -116.405    33.407
>
  -116.800    33.512
  -116.405    33.407
>
  -116.674    33.669
  -116.405    33.407
>
  -116.674    33.669
  -116.405    33.407
>
  -116.764    33.594
  -116.405    33.407
>
  -116.764    33.594
  -116.405    33.407
>
  -116.077    33.651
  -116.405    33.407
>
  -116.077    33.651
  -116.405    33.407
>
  -116.239    33.768
  -116.405    33.407
>
  -116.239    33.768
  -116.405    33.407
>
  -115.946    33.556
  -116.405    33.407
>
  -115.946    33.556
  -116.405    33.407
>
  -115.978    33.174
  -116.405    33.407
>
  -115.978    33.174
  -116.405    33.407
>
  -116.717    33.708
  -116.405    33.407
>
  -116.714    33.711
  -116.405    33.407
>
  -116.714    33.711
  -116.405    33.407
>
  -116.712    33.714
  -116.405    33.407
>
  -116.712    33.714
  -116.405    33.407
>
  -116.411    32.972
  -116.405    33.407
>
  -116.369    33.818
  -116.405    33.407
>
  -116.369    33.818
  -116.405    33.407
>
  -115.990    33.655
  -116.405    33.407
>
  -116.221    33.797
  -116.405    33.407
>
  -116.221    33.797
  -116.405    33.407
>
  -116.911    33.482
  -116.405    33.407
>
  -116.911    33.482
  -116.405    33.407
>
  -116.715    33.746
  -116.405    33.407
>
  -116.715    33.746
  -116.405    33.407
>
  -116.848    33.630
  -116.405    33.407
>
  -116.848    33.630
  -116.405    33.407
>
  -116.768    33.073
  -116.405    33.407
>
  -116.768    33.073
  -116.405    33.407
>
  -116.550    33.824
  -116.405    33.407
>
  -116.550    33.824
  -116.405    33.407
>
  -115.866    33.485
  -116.405    33.407
>
  -115.866    33.485
  -116.405    33.407
>
  -116.579    32.959
  -116.405    33.407
>
  -116.579    32.959
  -116.405    33.407
>
  -115.872    33.677
  -116.405    33.407
>
  -115.872    33.677
  -116.405    33.407
>
  -116.627    32.906
  -116.405    33.407
>
  -116.924    33.687
  -116.405    33.407
>
  -116.924    33.687
  -116.405    33.407
>
  -117.032    33.389
  -116.405    33.407
>
  -117.032    33.389
  -116.405    33.407
>
  -116.409    33.941
  -116.405    33.407
>
  -116.409    33.941
  -116.405    33.407
>
  -117.021    33.239
  -116.405    33.407
>
  -117.021    33.239
  -116.405    33.407
>
  -115.823    33.117
  -116.405    33.407
>
  -115.823    33.117
  -116.405    33.407
>
  -116.797    33.834
  -116.405    33.407
>
  -116.797    33.834
  -116.405    33.407
>
  -115.730    33.365
  -116.405    33.407
>
  -115.730    33.365
  -116.405    33.407
>
  -116.173    33.925
  -116.405    33.407
>
  -116.578    33.936
  -116.405    33.407
>
  -116.578    33.936
  -116.405    33.407
>
  -117.064    33.491
  -116.405    33.407
>
  -117.064    33.491
  -116.405    33.407
>
  -117.009    33.650
  -116.405    33.407
>
  -117.009    33.650
  -116.405    33.407
>
  -117.041    33.612
  -116.405    33.407
>
  -117.041    33.612
  -116.405    33.407
>
  -117.001    33.708
  -116.405    33.407
>
  -117.001    33.708
  -116.405    33.407
>
  -116.942    32.999
  -116.405    33.407
>
  -116.942    32.999
  -116.405    33.407
>
  -116.784    33.914
  -116.405    33.407
>
  -116.784    33.914
  -116.405    33.407
>
  -115.969    32.887
  -116.405    33.407
>
  -115.969    32.887
  -116.405    33.407
>
  -116.846    32.891
  -116.405    33.407
>
  -116.846    32.891
  -116.405    33.407
>
  -116.846    32.891
  -116.405    33.407
>
  -115.638    33.402
  -116.405    33.407
>
  -115.638    33.402
  -116.405    33.407
>
  -116.968    33.808
  -116.405    33.407
>
  -116.968    33.808
  -116.405    33.407
>
  -117.140    33.504
  -116.405    33.407
>
  -117.140    33.504
  -116.405    33.407
>
  -116.968    33.822
  -116.405    33.407
>
  -115.824    32.955
  -116.405    33.407
>
  -116.097    32.792
  -116.405    33.407
>
  -116.097    32.792
  -116.405    33.407
>
  -117.171    33.458
  -116.405    33.407
>
  -117.171    33.458
  -116.405    33.407
>
  -117.111    33.134
  -116.405    33.407
>
  -117.111    33.134
  -116.405    33.407
>
  -117.176    33.290
  -116.405    33.407
>
  -117.176    33.290
  -116.405    33.407
>
  -117.122    33.123
  -116.405    33.407
>
  -117.122    33.123
  -116.405    33.407
>
  -115.800    32.945
  -116.405    33.407
>
  -115.800    32.945
  -116.405    33.407
>
  -115.800    32.945
  -116.405    33.407
>
  -115.800    32.945
  -116.405    33.407
>
  -116.390    34.069
  -116.405    33.407
>
  -116.390    34.069
  -116.405    33.407
>
  -116.648    34.038
  -116.405    33.407
>
  -116.648    34.038
  -116.405    33.407
>
  -115.623    33.183
  -116.405    33.407
>
  -115.616    33.178
  -116.405    33.407
>
  -115.616    33.178
  -116.405    33.407
>
  -115.998    34.001
  -116.405    33.407
>
  -115.998    34.001
  -116.405    33.407
>
  -117.042    32.955
  -116.405    33.407
>
  -117.042    32.955
  -116.405    33.407
>
  -117.195    33.600
  -116.405    33.407
>
  -117.195    33.600
  -116.405    33.407
>
  -117.021    33.239
  -116.920    33.390
>
  -117.021    33.239
  -116.920    33.390
>
  -117.064    33.491
  -116.920    33.390
>
  -116.800    33.512
  -116.920    33.390
>
  -116.800    33.512
  -116.920    33.390
>
  -116.759    33.236
  -116.920    33.390
>
  -117.140    33.504
  -116.920    33.390
>
  -117.140    33.504
  -116.920    33.390
>
  -117.171    33.458
  -116.920    33.390
>
  -117.041    33.612
  -116.920    33.390
>
  -116.737    33.565
  -116.920    33.390
>
  -116.737    33.565
  -116.920    33.390
>
  -116.764    33.594
  -116.920    33.390
>
  -116.764    33.594
  -116.920    33.390
>
  -116.848    33.630
  -116.920    33.390
>
  -117.009    33.650
  -116.920    33.390
>
  -117.122    33.123
  -116.920    33.390
>
  -117.122    33.123
  -116.920    33.390
>
  -116.647    33.199
  -116.920    33.390
>
  -116.603    33.495
  -116.920    33.390
>
  -116.602    33.495
  -116.920    33.390
>
  -116.924    33.687
  -116.920    33.390
>
  -116.924    33.687
  -116.920    33.390
>
  -117.291    33.281
  -116.920    33.390
>
  -117.291    33.281
  -116.920    33.390
>
  -116.631    33.567
  -116.920    33.390
>
  -117.255    33.197
  -116.920    33.390
>
  -117.255    33.197
  -116.920    33.390
>
  -117.325    33.342
  -116.920    33.390
>
  -117.325    33.342
  -116.920    33.390
>
  -116.768    33.073
  -116.920    33.390
>
  -116.768    33.073
  -116.920    33.390
>
  -117.001    33.708
  -116.920    33.390
>
  -117.001    33.708
  -116.920    33.390
>
  -116.674    33.669
  -116.920    33.390
>
  -116.674    33.669
  -116.920    33.390
>
  -117.334    33.535
  -116.920    33.390
>
  -117.334    33.535
  -116.920    33.390
>
  -117.379    33.427
  -116.920    33.390
>
  -117.379    33.427
  -116.920    33.390
>
  -116.942    32.999
  -116.920    33.390
>
  -116.942    32.999
  -116.920    33.390
>
  -116.531    33.557
  -116.920    33.390
>
  -116.596    33.644
  -116.920    33.390
>
  -116.596    33.644
  -116.920    33.390
>
  -117.156    33.736
  -116.920    33.390
>
  -117.156    33.736
  -116.920    33.390
>
  -117.163    33.014
  -116.920    33.390
>
  -117.163    33.014
  -116.920    33.390
>
  -116.715    33.746
  -116.920    33.390
>
  -116.715    33.746
  -116.920    33.390
>
  -116.715    33.747
  -116.920    33.390
>
  -117.378    33.198
  -116.920    33.390
>
  -117.378    33.198
  -116.920    33.390
>
  -117.245    33.054
  -116.920    33.390
>
  -117.245    33.054
  -116.920    33.390
>
  -116.968    33.808
  -116.920    33.390
>
  -117.042    32.955
  -116.920    33.390
>
  -117.042    32.955
  -116.920    33.390
>
  -117.326    33.675
  -116.920    33.390
>
  -117.326    33.675
  -116.920    33.390
>
  -116.417    33.268
  -116.920    33.390
>
  -116.417    33.268
  -116.920    33.390
>
  -116.426    33.523
  -116.920    33.390
>
  -116.459    33.612
  -116.920    33.390
>
  -116.459    33.612
  -116.920    33.390
>
  -116.459    33.612
  -116.920    33.390
>
  -116.459    33.612
  -116.920    33.390
>
  -116.797    33.834
  -116.920    33.390
>
  -116.367    33.327
  -116.920    33.390
>
  -116.367    33.327
  -116.920    33.390
>
  -116.846    32.891
  -116.920    33.390
>
  -117.426    33.649
  -116.920    33.390
>
  -117.426    33.649
  -116.920    33.390
>
  -117.142    32.915
  -116.920    33.390
>
  -117.142    32.915
  -116.920    33.390
>
  -116.438    33.077
  -116.920    33.390
>
  -116.438    33.077
  -116.920    33.390
>
  -116.579    32.959
  -116.920    33.390
>
  -116.579    32.959
  -116.920    33.390
>
  -116.310    33.362
  -116.920    33.390
>
  -116.310    33.362
  -116.920    33.390
>
  -117.391    33.744
  -116.920    33.390
>
  -117.391    33.744
  -116.920    33.390
>
  -117.205    33.862
  -116.920    33.390
>
  -116.627    32.906
  -116.920    33.390
>
  -116.627    32.906
  -116.920    33.390
>
  -116.974    32.840
  -116.920    33.390
>
  -116.974    32.840
  -116.920    33.390
>
  -116.378    33.648
  -116.920    33.390
>
  -117.580    33.388
  -116.920    33.390
>
  -117.580    33.388
  -116.920    33.390
>
  -117.428    33.731
  -116.920    33.390
>
  -117.428    33.731
  -116.920    33.390
>
  -116.981    33.921
  -116.920    33.390
>
  -117.226    32.886
  -116.920    33.390
>
  -117.226    32.886
  -116.920    33.390
>
  -116.550    33.824
  -116.920    33.390
>
  -116.784    33.914
  -116.920    33.390
>
  -116.784    33.914
  -116.920    33.390
>
  -117.558    33.558
  -116.920    33.390
>
  -117.558    33.558
  -116.920    33.390
>
  -116.387    33.696
  -116.920    33.390
>
  -116.387    33.696
  -116.920    33.390
>
  -117.599    33.526
  -116.920    33.390
>
  -117.599    33.526
  -116.920    33.390
>
  -116.411    32.972
  -116.920    33.390
>
  -116.411    32.972
  -116.920    33.390
>
  -116.254    33.193
  -116.920    33.390
>
  -116.254    33.193
  -116.920    33.390
>
  -117.173    33.947
  -116.920    33.390
>
  -117.173    33.947
  -116.920    33.390
>
  -117.445    33.817
  -116.920    33.390
>
  -117.445    33.817
  -116.920    33.390
>
  -117.669    33.485
  -116.920    33.390
>
  -117.669    33.485
  -116.920    33.390
>
  -117.609    33.674
  -116.920    33.390
>
  -117.609    33.674
  -116.920    33.390
>
  -116.369    33.818
  -116.920    33.390
>
  -117.080    32.735
  -116.920    33.390
>
  -117.080    32.735
  -116.920    33.390
>
  -116.808    34.035
  -116.920    33.390
>
  -116.237    33.706
  -116.920    33.390
>
  -116.237    33.706
  -116.920    33.390
>
  -117.111    34.035
  -116.920    33.390
>
  -117.111    34.035
  -116.920    33.390
>
  -117.241    32.749
  -116.920    33.390
>
  -117.241    32.749
  -116.920    33.390
>
  -116.303    32.955
  -116.920    33.390
>
  -117.327    33.973
  -116.920    33.390
>
  -117.327    33.973
  -116.920    33.390
>
  -117.327    33.973
  -116.920    33.390
>
  -117.691    33.628
  -116.920    33.390
>
  -117.691    33.628
  -116.920    33.390
>
  -116.168    33.156
  -116.920    33.390
>
  -116.168    33.156
  -116.920    33.390
>
  -116.755    32.703
  -116.920    33.390
>
  -116.755    32.703
  -116.920    33.390
>
  -116.239    33.768
  -116.920    33.390
>
  -116.239    33.768
  -116.920    33.390
>
  -116.103    33.469
  -116.920    33.390
>
  -116.103    33.469
  -116.920    33.390
>
  -116.648    34.038
  -116.920    33.390
>
  -116.648    34.038
  -116.920    33.390
>
  -116.409    33.941
  -116.920    33.390
>
  -115.531    33.098
  -115.599    33.203
>
  -115.531    33.098
  -115.599    33.203
>
  -115.582    33.038
  -115.599    33.203
>
  -115.582    33.038
  -115.599    33.203
>
  -115.624    33.037
  -115.599    33.203
>
  -115.624    33.037
  -115.599    33.203
>
  -115.733    33.353
  -115.599    33.203
>
  -115.733    33.353
  -115.599    33.203
>
  -115.823    33.117
  -115.599    33.203
>
  -115.823    33.117
  -115.599    33.203
>
  -115.730    33.365
  -115.599    33.203
>
  -115.730    33.365
  -115.599    33.203
>
  -115.638    33.402
  -115.599    33.203
>
  -115.638    33.402
  -115.599    33.203
>
  -115.561    32.902
  -115.599    33.203
>
  -115.561    32.902
  -115.599    33.203
>
  -115.800    32.945
  -115.599    33.203
>
  -115.800    32.945
  -115.599    33.203
>
  -115.824    32.955
  -115.599    33.203
>
  -115.824    32.955
  -115.599    33.203
>
  -115.978    33.174
  -115.599    33.203
>
  -115.986    33.280
  -115.599    33.203
>
  -115.728    32.850
  -115.599    33.203
>
  -115.437    32.862
  -115.599    33.203
>
  -115.866    33.485
  -115.599    33.203
>
  -115.866    33.485
  -115.599    33.203
>
  -115.447    32.805
  -115.599    33.203
>
  -115.447    32.805
  -115.599    33.203
>
  -115.621    32.765
  -115.599    33.203
>
  -115.969    32.887
  -115.599    33.203
>
  -115.595    32.752
  -115.599    33.203
>
  -115.946    33.556
  -115.599    33.203
>
  -116.168    33.156
  -115.599    33.203
>
  -115.454    33.655
  -115.599    33.203
>
  -115.454    33.655
  -115.599    33.203
>
  -116.103    33.469
  -115.599    33.203
>
  -115.638    33.708
  -115.599    33.203
>
  -115.123    32.863
  -115.599    33.203
>
  -115.123    32.863
  -115.599    33.203
>
  -115.872    33.677
  -115.599    33.203
>
  -116.254    33.193
  -115.599    33.203
>
  -116.254    33.193
  -115.599    33.203
>
  -115.725    32.649
  -115.599    33.203
>
  -115.725    32.649
  -115.599    33.203
>
  -115.990    33.655
  -115.599    33.203
>
  -115.990    33.655
  -115.599    33.203
>
  -116.019    32.748
  -115.599    33.203
>
  -116.019    32.748
  -115.599    33.203
>
  -114.977    32.972
  -115.599    33.203
>
  -114.977    32.972
  -115.599    33.203
>
  -116.097    32.792
  -115.599    33.203
>
  -116.097    32.792
  -115.599    33.203
>
  -115.445    32.632
  -115.599    33.203
>
  -116.077    33.651
  -115.599    33.203
>
  -116.303    32.955
  -115.599    33.203
>
  -116.303    32.955
  -115.599    33.203
>
  -116.226    33.575
  -115.599    33.203
>
  -115.093    32.708
  -115.599    33.203
>
  -115.093    32.708
  -115.599    33.203
>
  -116.367    33.327
  -115.599    33.203
>
  -116.367    33.327
  -115.599    33.203
>
  -114.827    33.051
  -115.599    33.203
>
  -114.827    33.051
  -115.599    33.203
>
  -116.417    33.268
  -115.599    33.203
>
  -116.109    32.650
  -115.599    33.203
>
  -116.109    32.650
  -115.599    33.203
>
  -114.985    32.739
  -115.599    33.203
>
  -114.985    32.739
  -115.599    33.203
>
  -115.531    33.098
  -115.600    33.208
>
  -115.531    33.098
  -115.600    33.208
>
  -115.624    33.037
  -115.600    33.208
>
  -115.624    33.037
  -115.600    33.208
>
  -115.582    33.038
  -115.600    33.208
>
  -115.582    33.038
  -115.600    33.208
>
  -115.733    33.353
  -115.600    33.208
>
  -115.730    33.365
  -115.600    33.208
>
  -115.730    33.365
  -115.600    33.208
>
  -115.823    33.117
  -115.600    33.208
>
  -115.638    33.402
  -115.600    33.208
>
  -115.638    33.402
  -115.600    33.208
>
  -115.561    32.902
  -115.600    33.208
>
  -115.561    32.902
  -115.600    33.208
>
  -115.800    32.945
  -115.600    33.208
>
  -115.800    32.945
  -115.600    33.208
>
  -115.824    32.955
  -115.600    33.208
>
  -115.824    32.955
  -115.600    33.208
>
  -115.978    33.174
  -115.600    33.208
>
  -115.986    33.280
  -115.600    33.208
>
  -115.320    32.960
  -115.600    33.208
>
  -115.320    32.960
  -115.600    33.208
>
  -115.866    33.485
  -115.600    33.208
>
  -115.728    32.850
  -115.600    33.208
>
  -115.728    32.850
  -115.600    33.208
>
  -115.437    32.862
  -115.600    33.208
>
  -115.447    32.805
  -115.600    33.208
>
  -115.621    32.765
  -115.600    33.208
>
  -115.621    32.765
  -115.600    33.208
>
  -115.969    32.887
  -115.600    33.208
>
  -115.969    32.887
  -115.600    33.208
>
  -115.595    32.752
  -115.600    33.208
>
  -115.946    33.556
  -115.600    33.208
>
  -116.168    33.156
  -115.600    33.208
>
  -115.454    33.655
  -115.600    33.208
>
  -115.454    33.655
  -115.600    33.208
>
  -116.103    33.469
  -115.600    33.208
>
  -116.103    33.469
  -115.600    33.208
>
  -115.638    33.708
  -115.600    33.208
>
  -115.638    33.708
  -115.600    33.208
>
  -115.872    33.677
  -115.600    33.208
>
  -115.872    33.677
  -115.600    33.208
>
  -115.123    32.863
  -115.600    33.208
>
  -115.123    32.863
  -115.600    33.208
>
  -116.254    33.193
  -115.600    33.208
>
  -116.254    33.193
  -115.600    33.208
>
  -115.990    33.655
  -115.600    33.208
>
  -115.725    32.649
  -115.600    33.208
>
  -115.725    32.649
  -115.600    33.208
>
  -116.019    32.748
  -115.600    33.208
>
  -116.019    32.748
  -115.600    33.208
>
  -114.977    32.972
  -115.600    33.208
>
  -114.977    32.972
  -115.600    33.208
>
  -116.097    32.792
  -115.600    33.208
>
  -116.097    32.792
  -115.600    33.208
>
  -115.445    32.632
  -115.600    33.208
>
  -115.445    32.632
  -115.600    33.208
>
  -116.077    33.651
  -115.600    33.208
>
  -116.077    33.651
  -115.600    33.208
>
  -116.303    32.955
  -115.600    33.208
>
  -116.303    32.955
  -115.600    33.208
>
  -116.226    33.575
  -115.600    33.208
>
  -116.226    33.575
  -115.600    33.208
>
  -116.367    33.327
  -115.600    33.208
>
  -116.367    33.327
  -115.600    33.208
>
  -115.093    32.708
  -115.600    33.208
>
  -115.093    32.708
  -115.600    33.208
>
  -114.827    33.051
  -115.600    33.208
>
  -114.827    33.051
  -115.600    33.208
>
  -116.417    33.268
  -115.600    33.208
>
  -114.985    32.739
  -115.600    33.208
>
  -114.985    32.739
  -115.600    33.208
>
  -115.582    33.038
  -115.588    33.185
>
  -115.582    33.038
  -115.588    33.185
>
  -115.582    33.038
  -115.588    33.185
>
  -115.582    33.038
  -115.588    33.185
>
  -115.823    33.117
  -115.588    33.185
>
  -115.823    33.117
  -115.588    33.185
>
  -115.733    33.353
  -115.588    33.185
>
  -115.733    33.353
  -115.588    33.185
>
  -115.730    33.365
  -115.588    33.185
>
  -115.730    33.365
  -115.588    33.185
>
  -115.638    33.402
  -115.588    33.185
>
  -115.638    33.402
  -115.588    33.185
>
  -115.561    32.902
  -115.588    33.185
>
  -115.561    32.902
  -115.588    33.185
>
  -115.800    32.945
  -115.588    33.185
>
  -115.800    32.945
  -115.588    33.185
>
  -115.800    32.945
  -115.588    33.185
>
  -115.800    32.945
  -115.588    33.185
>
  -115.320    32.960
  -115.588    33.185
>
  -115.320    32.960
  -115.588    33.185
>
  -115.978    33.174
  -115.588    33.185
>
  -115.728    32.850
  -115.588    33.185
>
  -115.986    33.280
  -115.588    33.185
>
  -115.986    33.280
  -115.588    33.185
>
  -115.447    32.805
  -115.588    33.185
>
  -115.866    33.485
  -115.588    33.185
>
  -115.621    32.765
  -115.588    33.185
>
  -115.969    32.887
  -115.588    33.185
>
  -115.969    32.887
  -115.588    33.185
>
  -116.168    33.156
  -115.588    33.185
>
  -115.946    33.556
  -115.588    33.185
>
  -115.946    33.556
  -115.588    33.185
>
  -115.123    32.863
  -115.588    33.185
>
  -115.123    32.863
  -115.588    33.185
>
  -115.454    33.655
  -115.588    33.185
>
  -115.454    33.655
  -115.588    33.185
>
  -116.103    33.469
  -115.588    33.185
>
  -115.725    32.649
  -115.588    33.185
>
  -115.725    32.649
  -115.588    33.185
>
  -115.638    33.708
  -115.588    33.185
>
  -115.638    33.708
  -115.588    33.185
>
  -115.445    32.632
  -115.588    33.185
>
  -116.019    32.748
  -115.588    33.185
>
  -114.977    32.972
  -115.588    33.185
>
  -114.977    32.972
  -115.588    33.185
>
  -116.254    33.193
  -115.588    33.185
>
  -116.254    33.193
  -115.588    33.185
>
  -116.254    33.193
  -115.588    33.185
>
  -115.872    33.677
  -115.588    33.185
>
  -115.872    33.677
  -115.588    33.185
>
  -115.990    33.655
  -115.588    33.185
>
  -115.922    32.647
  -115.588    33.185
>
  -115.922    32.647
  -115.588    33.185
>
  -115.093    32.708
  -115.588    33.185
>
  -115.093    32.708
  -115.588    33.185
>
  -115.581    32.537
  -115.588    33.185
>
  -115.581    32.537
  -115.588    33.185
>
  -115.581    32.537
  -115.588    33.185
>
  -116.303    32.955
  -115.588    33.185
>
  -114.827    33.051
  -115.588    33.185
>
  -114.827    33.051
  -115.588    33.185
>
  -114.827    33.051
  -115.588    33.185
>
  -114.827    33.051
  -115.588    33.185
>
  -116.367    33.327
  -115.588    33.185
>
  -116.367    33.327
  -115.588    33.185
>
  -114.985    32.739
  -115.588    33.185
>
  -114.985    32.739
  -115.588    33.185
>
  -116.226    33.575
  -115.588    33.185
>
  -116.226    33.575
  -115.588    33.185
>
  -116.109    32.650
  -115.588    33.185
>
  -116.109    32.650
  -115.588    33.185
>
  -115.582    33.038
  -115.641    33.130
>
  -115.582    33.038
  -115.641    33.130
>
  -115.582    33.038
  -115.641    33.130
>
  -115.582    33.038
  -115.641    33.130
>
  -115.579    33.279
  -115.641    33.130
>
  -115.579    33.279
  -115.641    33.130
>
  -115.800    32.945
  -115.641    33.130
>
  -115.800    32.945
  -115.641    33.130
>
  -115.800    32.945
  -115.641    33.130
>
  -115.800    32.945
  -115.641    33.130
>
  -115.824    32.955
  -115.641    33.130
>
  -115.824    32.955
  -115.641    33.130
>
  -115.561    32.902
  -115.641    33.130
>
  -115.561    32.902
  -115.641    33.130
>
  -115.561    32.902
  -115.641    33.130
>
  -115.561    32.902
  -115.641    33.130
>
  -115.733    33.353
  -115.641    33.130
>
  -115.730    33.365
  -115.641    33.130
>
  -115.978    33.174
  -115.641    33.130
>
  -115.728    32.850
  -115.641    33.130
>
  -115.728    32.850
  -115.641    33.130
>
  -115.638    33.402
  -115.641    33.130
>
  -115.638    33.402
  -115.641    33.130
>
  -115.986    33.280
  -115.641    33.130
>
  -115.986    33.280
  -115.641    33.130
>
  -115.437    32.862
  -115.641    33.130
>
  -115.437    32.862
  -115.641    33.130
>
  -115.320    32.960
  -115.641    33.130
>
  -115.320    32.960
  -115.641    33.130
>
  -115.969    32.887
  -115.641    33.130
>
  -115.969    32.887
  -115.641    33.130
>
  -115.621    32.765
  -115.641    33.130
>
  -115.621    32.765
  -115.641    33.130
>
  -115.447    32.805
  -115.641    33.130
>
  -115.447    32.805
  -115.641    33.130
>
  -115.447    32.805
  -115.641    33.130
>
  -115.447    32.805
  -115.641    33.130
>
  -115.595    32.752
  -115.641    33.130
>
  -116.168    33.156
  -115.641    33.130
>
  -115.725    32.649
  -115.641    33.130
>
  -115.725    32.649
  -115.641    33.130
>
  -116.019    32.748
  -115.641    33.130
>
  -116.019    32.748
  -115.641    33.130
>
  -116.097    32.792
  -115.641    33.130
>
  -116.097    32.792
  -115.641    33.130
>
  -115.946    33.556
  -115.641    33.130
>
  -116.254    33.193
  -115.641    33.130
>
  -116.254    33.193
  -115.641    33.130
>
  -116.103    33.469
  -115.641    33.130
>
  -116.103    33.469
  -115.641    33.130
>
  -115.123    32.863
  -115.641    33.130
>
  -115.123    32.863
  -115.641    33.130
>
  -115.922    32.647
  -115.641    33.130
>
  -115.922    32.647
  -115.641    33.130
>
  -115.445    32.632
  -115.641    33.130
>
  -115.445    32.632
  -115.641    33.130
>
  -115.445    32.632
  -115.641    33.130
>
  -115.454    33.655
  -115.641    33.130
>
  -115.454    33.655
  -115.641    33.130
>
  -116.303    32.955
  -115.641    33.130
>
  -116.303    32.955
  -115.641    33.130
>
  -115.872    33.677
  -115.641    33.130
>
  -115.872    33.677
  -115.641    33.130
>
  -115.638    33.708
  -115.641    33.130
>
  -115.638    33.708
  -115.641    33.130
>
  -115.581    32.537
  -115.641    33.130
>
  -115.581    32.537
  -115.641    33.130
>
  -115.581    32.537
  -115.641    33.130
>
  -116.310    33.362
  -115.641    33.130
>
  -116.310    33.362
  -115.641    33.130
>
  -114.977    32.972
  -115.641    33.130
>
  -114.977    32.972
  -115.641    33.130
>
  -115.990    33.655
  -115.641    33.130
>
  -116.109    32.650
  -115.641    33.130
>
  -116.109    32.650
  -115.641    33.130
>
  -116.367    33.327
  -115.641    33.130
>
  -116.079    32.603
  -115.641    33.130
>
  -116.079    32.603
  -115.641    33.130
>
  -116.079    32.603
  -115.641    33.130
>
  -116.077    33.651
  -115.641    33.130
>
  -116.077    33.651
  -115.641    33.130
>
  -115.093    32.708
  -115.641    33.130
>
  -115.093    32.708
  -115.641    33.130
>
  -116.411    32.972
  -115.641    33.130
>
  -116.411    32.972
  -115.641    33.130
>
  -116.417    33.268
  -115.641    33.130
>
  -116.417    33.268
  -115.641    33.130
>
  -116.438    33.077
  -115.641    33.130
>
  -116.438    33.077
  -115.641    33.130
>
  -114.985    32.739
  -115.641    33.130
>
  -114.985    32.739
  -115.641    33.130
>
  -115.094    32.605
  -115.641    33.130
>
  -115.094    32.605
  -115.641    33.130
>
  -114.827    33.051
  -115.641    33.130
>
  -114.827    33.051
  -115.641    33.130
>
  -116.417    33.268
  -116.306    33.367
>
  -116.417    33.268
  -116.306    33.367
>
  -116.254    33.193
  -116.306    33.367
>
  -116.254    33.193
  -116.306    33.367
>
  -116.103    33.469
  -116.306    33.367
>
  -116.103    33.469
  -116.306    33.367
>
  -116.226    33.575
  -116.306    33.367
>
  -116.226    33.575
  -116.306    33.367
>
  -116.168    33.156
  -116.306    33.367
>
  -116.168    33.156
  -116.306    33.367
>
  -116.531    33.557
  -116.306    33.367
>
  -116.603    33.495
  -116.306    33.367
>
  -116.603    33.495
  -116.306    33.367
>
  -116.459    33.612
  -116.306    33.367
>
  -116.459    33.612
  -116.306    33.367
>
  -116.378    33.648
  -116.306    33.367
>
  -116.378    33.648
  -116.306    33.367
>
  -115.986    33.280
  -116.306    33.367
>
  -116.438    33.077
  -116.306    33.367
>
  -116.438    33.077
  -116.306    33.367
>
  -116.647    33.199
  -116.306    33.367
>
  -116.596    33.598
  -116.306    33.367
>
  -116.631    33.567
  -116.306    33.367
>
  -116.631    33.567
  -116.306    33.367
>
  -115.978    33.174
  -116.306    33.367
>
  -115.978    33.174
  -116.306    33.367
>
  -116.077    33.651
  -116.306    33.367
>
  -116.077    33.651
  -116.306    33.367
>
  -116.598    33.081
  -116.306    33.367
>
  -116.598    33.081
  -116.306    33.367
>
  -115.946    33.556
  -116.306    33.367
>
  -115.946    33.556
  -116.306    33.367
>
  -116.759    33.236
  -116.306    33.367
>
  -116.759    33.236
  -116.306    33.367
>
  -116.411    32.972
  -116.306    33.367
>
  -116.411    32.972
  -116.306    33.367
>
  -115.866    33.485
  -116.306    33.367
>
  -115.866    33.485
  -116.306    33.367
>
  -115.990    33.655
  -116.306    33.367
>
  -115.990    33.655
  -116.306    33.367
>
  -116.303    32.955
  -116.306    33.367
>
  -116.303    32.955
  -116.306    33.367
>
  -116.239    33.768
  -116.306    33.367
>
  -116.239    33.768
  -116.306    33.367
>
  -116.674    33.669
  -116.306    33.367
>
  -116.674    33.669
  -116.306    33.367
>
  -116.800    33.512
  -116.306    33.367
>
  -116.800    33.512
  -116.306    33.367
>
  -116.808    33.503
  -116.306    33.367
>
  -116.808    33.503
  -116.306    33.367
>
  -116.764    33.594
  -116.306    33.367
>
  -116.764    33.594
  -116.306    33.367
>
  -116.221    33.797
  -116.306    33.367
>
  -116.221    33.797
  -116.306    33.367
>
  -116.862    33.353
  -116.306    33.367
>
  -116.862    33.353
  -116.306    33.367
>
  -116.369    33.818
  -116.306    33.367
>
  -116.369    33.818
  -116.306    33.367
>
  -116.768    33.073
  -116.306    33.367
>
  -116.768    33.073
  -116.306    33.367
>
  -116.714    33.711
  -116.306    33.367
>
  -116.714    33.711
  -116.306    33.367
>
  -115.823    33.117
  -116.306    33.367
>
  -115.823    33.117
  -116.306    33.367
>
  -115.872    33.677
  -116.306    33.367
>
  -115.872    33.677
  -116.306    33.367
>
  -115.733    33.353
  -116.306    33.367
>
  -115.730    33.365
  -116.306    33.367
>
  -115.730    33.365
  -116.306    33.367
>
  -116.550    33.824
  -116.306    33.367
>
  -116.550    33.824
  -116.306    33.367
>
  -116.715    33.746
  -116.306    33.367
>
  -116.715    33.746
  -116.306    33.367
>
  -116.911    33.482
  -116.306    33.367
>
  -116.911    33.482
  -116.306    33.367
>
  -116.627    32.906
  -116.306    33.367
>
  -116.627    32.906
  -116.306    33.367
>
  -115.969    32.887
  -116.306    33.367
>
  -115.969    32.887
  -116.306    33.367
>
  -116.529    32.823
  -116.306    33.367
>
  -116.529    32.823
  -116.306    33.367
>
  -115.638    33.402
  -116.306    33.367
>
  -115.638    33.402
  -116.306    33.367
>
  -116.173    33.925
  -116.306    33.367
>
  -116.173    33.925
  -116.306    33.367
>
  -115.824    32.955
  -116.306    33.367
>
  -116.409    33.941
  -116.306    33.367
>
  -116.409    33.941
  -116.306    33.367
>
  -117.032    33.389
  -116.306    33.367
>
  -117.032    33.389
  -116.306    33.367
>
  -116.097    32.792
  -116.306    33.367
>
  -117.021    33.239
  -116.306    33.367
>
  -117.021    33.239
  -116.306    33.367
>
  -116.924    33.687
  -116.306    33.367
>
  -116.924    33.687
  -116.306    33.367
>
  -115.800    32.945
  -116.306    33.367
>
  -115.800    32.945
  -116.306    33.367
>
  -115.623    33.183
  -116.306    33.367
>
  -116.578    33.936
  -116.306    33.367
>
  -116.578    33.936
  -116.306    33.367
>
  -115.616    33.178
  -116.306    33.367
>
  -115.616    33.178
  -116.306    33.367
>
  -116.797    33.834
  -116.306    33.367
>
  -116.797    33.834
  -116.306    33.367
>
  -115.579    33.279
  -116.306    33.367
>
  -115.579    33.279
  -116.306    33.367
>
  -116.942    32.999
  -116.306    33.367
>
  -116.942    32.999
  -116.306    33.367
>
  -117.064    33.491
  -116.306    33.367
>
  -117.064    33.491
  -116.306    33.367
>
  -116.846    32.891
  -116.306    33.367
>
  -116.846    32.891
  -116.306    33.367
>
  -117.009    33.650
  -116.306    33.367
>
  -117.009    33.650
  -116.306    33.367
>
  -117.041    33.612
  -116.306    33.367
>
  -117.041    33.612
  -116.306    33.367
>
  -116.019    32.748
  -116.306    33.367
>
  -115.580    33.121
  -116.306    33.367
>
  -115.580    33.121
  -116.306    33.367
>
  -115.638    33.708
  -116.306    33.367
>
  -115.638    33.708
  -116.306    33.367
>
  -117.001    33.708
  -116.306    33.367
>
  -117.001    33.708
  -116.306    33.367
>
  -116.784    33.914
  -116.306    33.367
>
  -116.784    33.914
  -116.306    33.367
>
  -115.998    34.001
  -116.306    33.367
>
  -115.998    34.001
  -116.306    33.367
>
  -115.582    33.038
  -116.306    33.367
>
  -115.582    33.038
  -116.306    33.367
>
  -115.505    32.829
  -115.551    32.941
>
  -115.437    32.862
  -115.551    32.941
>
  -115.437    32.862
  -115.551    32.941
>
  -115.531    33.098
  -115.551    32.941
>
  -115.580    33.121
  -115.551    32.941
>
  -115.447    32.805
  -115.551    32.941
>
  -115.728    32.850
  -115.551    32.941
>
  -115.728    32.850
  -115.551    32.941
>
  -115.320    32.960
  -115.551    32.941
>
  -115.320    32.960
  -115.551    32.941
>
  -115.621    32.765
  -115.551    32.941
>
  -115.621    32.765
  -115.551    32.941
>
  -115.595    32.752
  -115.551    32.941
>
  -115.595    32.752
  -115.551    32.941
>
  -115.800    32.945
  -115.551    32.941
>
  -115.616    33.178
  -115.551    32.941
>
  -115.616    33.178
  -115.551    32.941
>
  -115.623    33.183
  -115.551    32.941
>
  -115.623    33.183
  -115.551    32.941
>
  -115.823    33.117
  -115.551    32.941
>
  -115.579    33.279
  -115.551    32.941
>
  -115.579    33.279
  -115.551    32.941
>
  -115.445    32.632
  -115.551    32.941
>
  -115.445    32.632
  -115.551    32.941
>
  -115.725    32.649
  -115.551    32.941
>
  -115.725    32.649
  -115.551    32.941
>
  -115.969    32.887
  -115.551    32.941
>
  -115.969    32.887
  -115.551    32.941
>
  -115.123    32.863
  -115.551    32.941
>
  -115.123    32.863
  -115.551    32.941
>
  -115.581    32.537
  -115.551    32.941
>
  -115.730    33.365
  -115.551    32.941
>
  -115.730    33.365
  -115.551    32.941
>
  -115.922    32.647
  -115.551    32.941
>
  -115.922    32.647
  -115.551    32.941
>
  -116.019    32.748
  -115.551    32.941
>
  -116.019    32.748
  -115.551    32.941
>
  -115.638    33.402
  -115.551    32.941
>
  -115.093    32.708
  -115.551    32.941
>
  -114.977    32.972
  -115.551    32.941
>
  -114.977    32.972
  -115.551    32.941
>
  -116.097    32.792
  -115.551    32.941
>
  -116.097    32.792
  -115.551    32.941
>
  -115.986    33.280
  -115.551    32.941
>
  -115.986    33.280
  -115.551    32.941
>
  -114.985    32.739
  -115.551    32.941
>
  -116.168    33.156
  -115.551    32.941
>
  -116.109    32.650
  -115.551    32.941
>
  -116.109    32.650
  -115.551    32.941
>
  -115.305    32.420
  -115.551    32.941
>
  -115.305    32.420
  -115.551    32.941
>
  -115.866    33.485
  -115.551    32.941
>
  -115.866    33.485
  -115.551    32.941
>
  -114.827    33.051
  -115.551    32.941
>
  -114.827    33.051
  -115.551    32.941
>
  -115.109    32.448
  -115.551    32.941
>
  -115.109    32.448
  -115.551    32.941
>
  -116.254    33.193
  -115.551    32.941
>
  -116.254    33.193
  -115.551    32.941
>
  -114.784    32.845
  -115.551    32.941
>
  -114.784    32.845
  -115.551    32.941
>
  -115.505    32.829
  -115.548    32.944
>
  -115.437    32.862
  -115.548    32.944
>
  -115.437    32.862
  -115.548    32.944
>
  -115.447    32.805
  -115.548    32.944
>
  -115.447    32.805
  -115.548    32.944
>
  -115.728    32.850
  -115.548    32.944
>
  -115.728    32.850
  -115.548    32.944
>
  -115.531    33.098
  -115.548    32.944
>
  -115.531    33.098
  -115.548    32.944
>
  -115.621    32.765
  -115.548    32.944
>
  -115.621    32.765
  -115.548    32.944
>
  -115.595    32.752
  -115.548    32.944
>
  -115.320    32.960
  -115.548    32.944
>
  -115.320    32.960
  -115.548    32.944
>
  -115.580    33.121
  -115.548    32.944
>
  -115.580    33.121
  -115.548    32.944
>
  -115.800    32.945
  -115.548    32.944
>
  -115.616    33.178
  -115.548    32.944
>
  -115.616    33.178
  -115.548    32.944
>
  -115.623    33.183
  -115.548    32.944
>
  -115.623    33.183
  -115.548    32.944
>
  -115.823    33.117
  -115.548    32.944
>
  -115.445    32.632
  -115.548    32.944
>
  -115.445    32.632
  -115.548    32.944
>
  -115.725    32.649
  -115.548    32.944
>
  -115.725    32.649
  -115.548    32.944
>
  -115.579    33.279
  -115.548    32.944
>
  -115.969    32.887
  -115.548    32.944
>
  -115.969    32.887
  -115.548    32.944
>
  -115.123    32.863
  -115.548    32.944
>
  -115.123    32.863
  -115.548    32.944
>
  -115.581    32.537
  -115.548    32.944
>
  -115.581    32.537
  -115.548    32.944
>
  -115.922    32.647
  -115.548    32.944
>
  -115.922    32.647
  -115.548    32.944
>
  -116.019    32.748
  -115.548    32.944
>
  -116.019    32.748
  -115.548    32.944
>
  -115.093    32.708
  -115.548    32.944
>
  -115.733    33.353
  -115.548    32.944
>
  -115.730    33.365
  -115.548    32.944
>
  -115.730    33.365
  -115.548    32.944
>
  -115.638    33.402
  -115.548    32.944
>
  -114.977    32.972
  -115.548    32.944
>
  -114.977    32.972
  -115.548    32.944
>
  -116.097    32.792
  -115.548    32.944
>
  -116.097    32.792
  -115.548    32.944
>
  -114.985    32.739
  -115.548    32.944
>
  -114.985    32.739
  -115.548    32.944
>
  -115.986    33.280
  -115.548    32.944
>
  -115.986    33.280
  -115.548    32.944
>
  -115.305    32.420
  -115.548    32.944
>
  -115.305    32.420
  -115.548    32.944
>
  -116.109    32.650
  -115.548    32.944
>
  -116.109    32.650
  -115.548    32.944
>
  -116.168    33.156
  -115.548    32.944
>
  -115.866    33.485
  -115.548    32.944
>
  -115.866    33.485
  -115.548    32.944
>
  -114.827    33.051
  -115.548    32.944
>
  -114.827    33.051
  -115.548    32.944
>
  -116.303    32.955
  -115.548    32.944
>
  -116.303    32.955
  -115.548    32.944
>
  -114.784    32.845
  -115.548    32.944
>
  -114.784    32.845
  -115.548    32.944
>
  -116.254    33.193
  -115.548    32.944
>
  -116.254    33.193
  -115.548    32.944
>
  -115.946    33.556
  -115.548    32.944
>
  -115.582    33.038
  -115.556    32.937
>
  -115.582    33.038
  -115.556    32.937
>
  -115.437    32.862
  -115.556    32.937
>
  -115.437    32.862
  -115.556    32.937
>
  -115.447    32.805
  -115.556    32.937
>
  -115.728    32.850
  -115.556    32.937
>
  -115.728    32.850
  -115.556    32.937
>
  -115.621    32.765
  -115.556    32.937
>
  -115.595    32.752
  -115.556    32.937
>
  -115.531    33.098
  -115.556    32.937
>
  -115.531    33.098
  -115.556    32.937
>
  -115.580    33.121
  -115.556    32.937
>
  -115.800    32.945
  -115.556    32.937
>
  -115.800    32.945
  -115.556    32.937
>
  -115.320    32.960
  -115.556    32.937
>
  -115.616    33.178
  -115.556    32.937
>
  -115.616    33.178
  -115.556    32.937
>
  -115.623    33.183
  -115.556    32.937
>
  -115.823    33.117
  -115.556    32.937
>
  -115.725    32.649
  -115.556    32.937
>
  -115.725    32.649
  -115.556    32.937
>
  -115.445    32.632
  -115.556    32.937
>
  -115.969    32.887
  -115.556    32.937
>
  -115.969    32.887
  -115.556    32.937
>
  -115.579    33.279
  -115.556    32.937
>
  -115.579    33.279
  -115.556    32.937
>
  -115.123    32.863
  -115.556    32.937
>
  -115.123    32.863
  -115.556    32.937
>
  -115.581    32.537
  -115.556    32.937
>
  -115.581    32.537
  -115.556    32.937
>
  -115.922    32.647
  -115.556    32.937
>
  -115.922    32.647
  -115.556    32.937
>
  -116.019    32.748
  -115.556    32.937
>
  -116.019    32.748
  -115.556    32.937
>
  -115.733    33.353
  -115.556    32.937
>
  -115.093    32.708
  -115.556    32.937
>
  -115.093    32.708
  -115.556    32.937
>
  -115.730    33.365
  -115.556    32.937
>
  -116.097    32.792
  -115.556    32.937
>
  -116.097    32.792
  -115.556    32.937
>
  -115.638    33.402
  -115.556    32.937
>
  -115.638    33.402
  -115.556    32.937
>
  -114.977    32.972
  -115.556    32.937
>
  -114.977    32.972
  -115.556    32.937
>
  -115.986    33.280
  -115.556    32.937
>
  -115.986    33.280
  -115.556    32.937
>
  -114.985    32.739
  -115.556    32.937
>
  -114.985    32.739
  -115.556    32.937
>
  -116.109    32.650
  -115.556    32.937
>
  -116.109    32.650
  -115.556    32.937
>
  -115.305    32.420
  -115.556    32.937
>
  -116.168    33.156
  -115.556    32.937
>
  -116.168    33.156
  -115.556    32.937
>
  -115.866    33.485
  -115.556    32.937
>
  -116.303    32.955
  -115.556    32.937
>
  -116.303    32.955
  -115.556    32.937
>
  -114.827    33.051
  -115.556    32.937
>
  -114.827    33.051
  -115.556    32.937
>
  -114.827    33.051
  -115.556    32.937
>
  -116.254    33.193
  -115.556    32.937
>
  -116.254    33.193
  -115.556    32.937
>
  -114.784    32.845
  -115.556    32.937
>
  -114.784    32.845
  -115.556    32.937
>
  -115.946    33.556
  -115.556    32.937
>
  -115.582    33.038
  -115.556    32.936
>
  -115.582    33.038
  -115.556    32.936
>
  -115.505    32.829
  -115.556    32.936
>
  -115.437    32.862
  -115.556    32.936
>
  -115.437    32.862
  -115.556    32.936
>
  -115.728    32.850
  -115.556    32.936
>
  -115.728    32.850
  -115.556    32.936
>
  -115.531    33.098
  -115.556    32.936
>
  -115.531    33.098
  -115.556    32.936
>
  -115.621    32.765
  -115.556    32.936
>
  -115.621    32.765
  -115.556    32.936
>
  -115.595    32.752
  -115.556    32.936
>
  -115.595    32.752
  -115.556    32.936
>
  -115.580    33.121
  -115.556    32.936
>
  -115.580    33.121
  -115.556    32.936
>
  -115.800    32.945
  -115.556    32.936
>
  -115.320    32.960
  -115.556    32.936
>
  -115.320    32.960
  -115.556    32.936
>
  -115.616    33.178
  -115.556    32.936
>
  -115.616    33.178
  -115.556    32.936
>
  -115.623    33.183
  -115.556    32.936
>
  -115.823    33.117
  -115.556    32.936
>
  -115.725    32.649
  -115.556    32.936
>
  -115.445    32.632
  -115.556    32.936
>
  -115.445    32.632
  -115.556    32.936
>
  -115.969    32.887
  -115.556    32.936
>
  -115.969    32.887
  -115.556    32.936
>
  -115.579    33.279
  -115.556    32.936
>
  -115.579    33.279
  -115.556    32.936
>
  -115.123    32.863
  -115.556    32.936
>
  -115.123    32.863
  -115.556    32.936
>
  -115.581    32.537
  -115.556    32.936
>
  -115.581    32.537
  -115.556    32.936
>
  -115.922    32.647
  -115.556    32.936
>
  -115.922    32.647
  -115.556    32.936
>
  -116.019    32.748
  -115.556    32.936
>
  -116.019    32.748
  -115.556    32.936
>
  -115.733    33.353
  -115.556    32.936
>
  -115.730    33.365
  -115.556    32.936
>
  -115.730    33.365
  -115.556    32.936
>
  -115.093    32.708
  -115.556    32.936
>
  -115.093    32.708
  -115.556    32.936
>
  -116.097    32.792
  -115.556    32.936
>
  -116.097    32.792
  -115.556    32.936
>
  -115.638    33.402
  -115.556    32.936
>
  -115.638    33.402
  -115.556    32.936
>
  -115.986    33.280
  -115.556    32.936
>
  -115.986    33.280
  -115.556    32.936
>
  -114.977    32.972
  -115.556    32.936
>
  -114.977    32.972
  -115.556    32.936
>
  -114.985    32.739
  -115.556    32.936
>
  -116.109    32.650
  -115.556    32.936
>
  -116.109    32.650
  -115.556    32.936
>
  -116.168    33.156
  -115.556    32.936
>
  -116.168    33.156
  -115.556    32.936
>
  -115.866    33.485
  -115.556    32.936
>
  -116.303    32.955
  -115.556    32.936
>
  -116.254    33.193
  -115.556    32.936
>
  -116.254    33.193
  -115.556    32.936
>
  -114.827    33.051
  -115.556    32.936
>
  -114.827    33.051
  -115.556    32.936
>
  -114.784    32.845
  -115.556    32.936
>
  -114.784    32.845
  -115.556    32.936
>
  -115.946    33.556
  -115.556    32.936
>
  -115.582    33.038
  -115.549    32.936
>
  -115.582    33.038
  -115.549    32.936
>
  -115.437    32.862
  -115.549    32.936
>
  -115.437    32.862
  -115.549    32.936
>
  -115.531    33.098
  -115.549    32.936
>
  -115.531    33.098
  -115.549    32.936
>
  -115.447    32.805
  -115.549    32.936
>
  -115.447    32.805
  -115.549    32.936
>
  -115.580    33.121
  -115.549    32.936
>
  -115.580    33.121
  -115.549    32.936
>
  -115.728    32.850
  -115.549    32.936
>
  -115.728    32.850
  -115.549    32.936
>
  -115.621    32.765
  -115.549    32.936
>
  -115.621    32.765
  -115.549    32.936
>
  -115.320    32.960
  -115.549    32.936
>
  -115.320    32.960
  -115.549    32.936
>
  -115.595    32.752
  -115.549    32.936
>
  -115.595    32.752
  -115.549    32.936
>
  -115.800    32.945
  -115.549    32.936
>
  -115.616    33.178
  -115.549    32.936
>
  -115.616    33.178
  -115.549    32.936
>
  -115.823    33.117
  -115.549    32.936
>
  -115.823    33.117
  -115.549    32.936
>
  -115.445    32.632
  -115.549    32.936
>
  -115.445    32.632
  -115.549    32.936
>
  -115.579    33.279
  -115.549    32.936
>
  -115.579    33.279
  -115.549    32.936
>
  -115.725    32.649
  -115.549    32.936
>
  -115.725    32.649
  -115.549    32.936
>
  -115.969    32.887
  -115.549    32.936
>
  -115.969    32.887
  -115.549    32.936
>
  -115.123    32.863
  -115.549    32.936
>
  -115.123    32.863
  -115.549    32.936
>
  -115.581    32.537
  -115.549    32.936
>
  -115.733    33.353
  -115.549    32.936
>
  -115.922    32.647
  -115.549    32.936
>
  -115.922    32.647
  -115.549    32.936
>
  -115.730    33.365
  -115.549    32.936
>
  -115.730    33.365
  -115.549    32.936
>
  -116.019    32.748
  -115.549    32.936
>
  -116.019    32.748
  -115.549    32.936
>
  -115.093    32.708
  -115.549    32.936
>
  -115.093    32.708
  -115.549    32.936
>
  -115.638    33.402
  -115.549    32.936
>
  -115.638    33.402
  -115.549    32.936
>
  -114.977    32.972
  -115.549    32.936
>
  -114.977    32.972
  -115.549    32.936
>
  -116.097    32.792
  -115.549    32.936
>
  -116.097    32.792
  -115.549    32.936
>
  -115.986    33.280
  -115.549    32.936
>
  -115.986    33.280
  -115.549    32.936
>
  -114.985    32.739
  -115.549    32.936
>
  -114.985    32.739
  -115.549    32.936
>
  -116.109    32.650
  -115.549    32.936
>
  -116.109    32.650
  -115.549    32.936
>
  -116.168    33.156
  -115.549    32.936
>
  -116.168    33.156
  -115.549    32.936
>
  -115.305    32.420
  -115.549    32.936
>
  -115.305    32.420
  -115.549    32.936
>
  -115.866    33.485
  -115.549    32.936
>
  -115.866    33.485
  -115.549    32.936
>
  -114.827    33.051
  -115.549    32.936
>
  -114.827    33.051
  -115.549    32.936
>
  -116.303    32.955
  -115.549    32.936
>
  -116.303    32.955
  -115.549    32.936
>
  -116.254    33.193
  -115.549    32.936
>
  -116.254    33.193
  -115.549    32.936
>
  -114.784    32.845
  -115.549    32.936
>
  -114.784    32.845
  -115.549    32.936
>
  -115.582    33.038
  -115.546    32.942
>
  -115.582    33.038
  -115.546    32.942
>
  -115.505    32.829
  -115.546    32.942
>
  -115.437    32.862
  -115.546    32.942
>
  -115.437    32.862
  -115.546    32.942
>
  -115.447    32.805
  -115.546    32.942
>
  -115.531    33.098
  -115.546    32.942
>
  -115.728    32.850
  -115.546    32.942
>
  -115.728    32.850
  -115.546    32.942
>
  -115.621    32.765
  -115.546    32.942
>
  -115.621    32.765
  -115.546    32.942
>
  -115.580    33.121
  -115.546    32.942
>
  -115.580    33.121
  -115.546    32.942
>
  -115.320    32.960
  -115.546    32.942
>
  -115.320    32.960
  -115.546    32.942
>
  -115.595    32.752
  -115.546    32.942
>
  -115.595    32.752
  -115.546    32.942
>
  -115.616    33.178
  -115.546    32.942
>
  -115.616    33.178
  -115.546    32.942
>
  -115.623    33.183
  -115.546    32.942
>
  -115.623    33.183
  -115.546    32.942
>
  -115.823    33.117
  -115.546    32.942
>
  -115.823    33.117
  -115.546    32.942
>
  -115.445    32.632
  -115.546    32.942
>
  -115.445    32.632
  -115.546    32.942
>
  -115.725    32.649
  -115.546    32.942
>
  -115.579    33.279
  -115.546    32.942
>
  -115.579    33.279
  -115.546    32.942
>
  -115.123    32.863
  -115.546    32.942
>
  -115.123    32.863
  -115.546    32.942
>
  -115.969    32.887
  -115.546    32.942
>
  -115.969    32.887
  -115.546    32.942
>
  -115.581    32.537
  -115.546    32.942
>
  -115.922    32.647
  -115.546    32.942
>
  -115.922    32.647
  -115.546    32.942
>
  -115.093    32.708
  -115.546    32.942
>
  -116.019    32.748
  -115.546    32.942
>
  -116.019    32.748
  -115.546    32.942
>
  -115.730    33.365
  -115.546    32.942
>
  -115.730    33.365
  -115.546    32.942
>
  -115.638    33.402
  -115.546    32.942
>
  -114.977    32.972
  -115.546    32.942
>
  -114.977    32.972
  -115.546    32.942
>
  -116.097    32.792
  -115.546    32.942
>
  -116.097    32.792
  -115.546    32.942
>
  -115.986    33.280
  -115.546    32.942
>
  -115.986    33.280
  -115.546    32.942
>
  -114.985    32.739
  -115.546    32.942
>
  -115.305    32.420
  -115.546    32.942
>
  -115.305    32.420
  -115.546    32.942
>
  -116.109    32.650
  -115.546    32.942
>
  -116.109    32.650
  -115.546    32.942
>
  -116.168    33.156
  -115.546    32.942
>
  -116.168    33.156
  -115.546    32.942
>
  -115.866    33.485
  -115.546    32.942
>
  -115.866    33.485
  -115.546    32.942
>
  -114.827    33.051
  -115.546    32.942
>
  -114.827    33.051
  -115.546    32.942
>
  -116.303    32.955
  -115.546    32.942
>
  -116.303    32.955
  -115.546    32.942
>
  -114.784    32.845
  -115.546    32.942
>
  -114.784    32.845
  -115.546    32.942
>
  -116.254    33.193
  -115.546    32.942
>
  -116.254    33.193
  -115.546    32.942
>
  -115.946    33.556
  -115.546    32.942
>
  -115.946    33.556
  -115.546    32.942
>
  -115.969    32.887
  -116.001    33.031
>
  -115.969    32.887
  -116.001    33.031
>
  -115.800    32.945
  -116.001    33.031
>
  -115.800    32.945
  -116.001    33.031
>
  -116.168    33.156
  -116.001    33.031
>
  -116.168    33.156
  -116.001    33.031
>
  -115.986    33.280
  -116.001    33.031
>
  -115.986    33.280
  -116.001    33.031
>
  -116.097    32.792
  -116.001    33.031
>
  -116.097    32.792
  -116.001    33.031
>
  -116.254    33.193
  -116.001    33.031
>
  -116.254    33.193
  -116.001    33.031
>
  -116.019    32.748
  -116.001    33.031
>
  -116.019    32.748
  -116.001    33.031
>
  -115.728    32.850
  -116.001    33.031
>
  -115.728    32.850
  -116.001    33.031
>
  -115.623    33.183
  -116.001    33.031
>
  -115.582    33.038
  -116.001    33.031
>
  -115.582    33.038
  -116.001    33.031
>
  -115.616    33.178
  -116.001    33.031
>
  -115.616    33.178
  -116.001    33.031
>
  -116.411    32.972
  -116.001    33.031
>
  -116.411    32.972
  -116.001    33.031
>
  -115.580    33.121
  -116.001    33.031
>
  -116.438    33.077
  -116.001    33.031
>
  -116.438    33.077
  -116.001    33.031
>
  -115.733    33.353
  -116.001    33.031
>
  -115.561    32.902
  -116.001    33.031
>
  -115.922    32.647
  -116.001    33.031
>
  -115.922    32.647
  -116.001    33.031
>
  -115.531    33.098
  -116.001    33.031
>
  -115.531    33.098
  -116.001    33.031
>
  -115.730    33.365
  -116.001    33.031
>
  -115.730    33.365
  -116.001    33.031
>
  -116.109    32.650
  -116.001    33.031
>
  -116.109    32.650
  -116.001    33.031
>
  -115.621    32.765
  -116.001    33.031
>
  -115.621    32.765
  -116.001    33.031
>
  -116.310    33.362
  -116.001    33.031
>
  -116.310    33.362
  -116.001    33.031
>
  -115.579    33.279
  -116.001    33.031
>
  -115.579    33.279
  -116.001    33.031
>
  -116.367    33.327
  -116.001    33.031
>
  -116.367    33.327
  -116.001    33.031
>
  -115.595    32.752
  -116.001    33.031
>
  -115.595    32.752
  -116.001    33.031
>
  -116.103    33.469
  -116.001    33.031
>
  -116.103    33.469
  -116.001    33.031
>
  -115.725    32.649
  -116.001    33.031
>
  -115.866    33.485
  -116.001    33.031
>
  -115.866    33.485
  -116.001    33.031
>
  -115.638    33.402
  -116.001    33.031
>
  -115.638    33.402
  -116.001    33.031
>
  -116.366    32.651
  -116.001    33.031
>
  -116.529    32.823
  -116.001    33.031
>
  -116.598    33.081
  -116.001    33.031
>
  -115.946    33.556
  -116.001    33.031
>
  -116.627    32.906
  -116.001    33.031
>
  -116.627    32.906
  -116.001    33.031
>
  -116.485    32.643
  -116.001    33.031
>
  -116.485    32.643
  -116.001    33.031
>
  -115.320    32.960
  -116.001    33.031
>
  -116.647    33.199
  -116.001    33.031
>
  -116.647    33.199
  -116.001    33.031
>
  -116.226    33.575
  -116.001    33.031
>
  -115.581    32.537
  -116.001    33.031
>
  -116.426    33.523
  -116.001    33.031
>
  -115.445    32.632
  -116.001    33.031
>
  -115.445    32.632
  -116.001    33.031
>
  -116.077    33.651
  -116.001    33.031
>
  -115.872    33.677
  -116.001    33.031
>
  -115.872    33.677
  -116.001    33.031
>
  -116.768    33.073
  -116.001    33.031
>
  -116.768    33.073
  -116.001    33.031
>
  -116.672    32.680
  -116.001    33.031
>
  -116.672    32.680
  -116.001    33.031
>
  -116.759    33.236
  -116.001    33.031
>
  -116.759    33.236
  -116.001    33.031
>
  -116.603    33.495
  -116.001    33.031
>
  -116.531    33.557
  -116.001    33.031
>
  -116.531    33.557
  -116.001    33.031
>
  -116.378    33.648
  -116.001    33.031
>
  -116.459    33.612
  -116.001    33.031
>
  -116.459    33.612
  -116.001    33.031
>
  -116.459    33.612
  -116.001    33.031
>
  -116.459    33.612
  -116.001    33.031
>
  -116.459    33.612
  -116.001    33.031
>
  -116.607    32.569
  -116.001    33.031
>
  -116.607    32.569
  -116.001    33.031
>
  -116.221    33.797
  -116.170    33.902
>
  -116.239    33.768
  -116.170    33.902
>
  -116.077    33.651
  -116.170    33.902
>
  -115.990    33.655
  -116.170    33.902
>
  -115.990    33.655
  -116.170    33.902
>
  -116.378    33.648
  -116.170    33.902
>
  -116.378    33.648
  -116.170    33.902
>
  -116.226    33.575
  -116.170    33.902
>
  -115.872    33.677
  -116.170    33.902
>
  -115.872    33.677
  -116.170    33.902
>
  -116.038    34.126
  -116.170    33.902
>
  -116.390    34.069
  -116.170    33.902
>
  -116.550    33.824
  -116.170    33.902
>
  -116.459    33.612
  -116.170    33.902
>
  -116.712    33.714
  -116.170    33.902
>
  -115.454    33.655
  -116.170    33.902
>
  -116.417    33.268
  -116.170    33.902
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -115.998    34.001     0.300
  -116.459    33.612     0.300
  -115.454    33.655     0.300
  -115.969    32.887     0.300
  -115.800    32.945     0.300
  -115.727    32.849     0.300
  -115.638    33.402     0.300
  -116.422    32.892     0.300
  -116.101    32.659     0.300
  -115.923    32.648     0.300
  -116.079    32.603     0.300
  -115.725    32.649     0.300
  -115.638    33.708     0.300
  -116.672    32.680     0.300
  -116.846    32.891     0.300
  -117.195    33.600     0.300
  -117.105    32.889     0.300
  -115.437    32.862     0.300
  -116.602    33.495     0.300
  -116.423    32.893     0.300
  -116.862    33.353     0.300
  -116.942    32.999     0.300
  -116.921    34.262     0.300
  -117.659    34.239     0.300
  -116.960    33.026     0.300
  -117.105    32.889     0.300
  -116.417    33.268     0.300
  -116.613    33.552     0.300
  -116.631    33.567     0.300
  -116.737    33.565     0.300
  -117.009    33.650     0.300
  -115.990    33.655     0.300
  -117.041    33.612     0.300
  -117.004    33.709     0.300
  -116.578    33.936     0.300
  -116.252    32.900     0.300
  -115.841    33.459     0.300
  -115.872    33.677     0.300
  -115.823    33.117     0.300
  -115.527    33.141     0.300
  -115.732    32.759     0.300
  -116.093    32.661     0.300
  -116.049    34.106     0.300
  -116.287    34.401     0.300
  -117.098    34.106     0.300
  -115.447    32.805     0.300
  -115.220    33.012     0.300
  -115.123    32.863     0.300
  -114.985    32.739     0.300
  -114.827    33.051     0.300
  -115.304    32.418     0.300
  -116.109    32.650     0.300
  -116.942    32.736     0.300
  -115.663    32.743     0.300
  -115.198    32.407     0.300
  -116.456    33.611     0.300
  -116.981    33.921     0.300
  -116.675    32.433     0.300
  -116.923    33.687     0.300
  -116.674    33.669     0.300
  -117.111    34.035     0.300
  -117.355    33.823     0.300
  -117.327    33.973     0.300
  -116.667    33.492     0.300
  -117.219    34.121     0.300
  -117.375    33.993     0.300
  -117.427    33.648     0.300
  -117.283    34.105     0.300
  -117.317    34.093     0.300
  -117.003    34.257     0.300
  -116.408    33.941     0.300
  -117.561    33.876     0.300
  -116.378    33.648     0.300
  -117.562    34.005     0.300
  -116.389    34.069     0.300
  -116.827    34.348     0.300
  -117.358    34.298     0.300
  -117.500    34.208     0.300
  -117.680    33.999     0.300
  -116.647    33.199     0.300
  -117.229    33.154     0.300
  -115.582    33.038     0.300
  -115.824    32.955     0.300
  -115.986    33.280     0.300
  -115.728    32.850     0.300
  -116.254    33.193     0.300
  -114.977    32.972     0.300
  -115.445    32.632     0.300
  -116.356    34.295     0.300
  -115.145    34.157     0.300
  -116.453    33.606     0.300
  -115.922    32.647     0.300
  -115.094    32.605     0.300
  -115.472    32.664     0.300
  -115.669    32.652     0.300
  -115.145    32.473     0.300
  -115.130    32.422     0.300
  -115.561    32.902     0.300
  -115.385    32.628     0.300
  -115.730    33.365     0.300
  -115.580    33.121     0.300
  -116.598    33.081     0.300
  -115.338    32.693     0.300
  -117.057    32.820     0.300
  -116.607    32.569     0.300
  -116.775    32.607     0.300
  -116.930    32.608     0.300
  -117.138    32.784     0.300
  -117.161    33.892     0.300
  -115.492    32.669     0.300
  -115.581    32.537     0.300
  -115.304    33.239     0.300
  -115.733    33.353     0.300
  -114.964    32.433     0.300
  -116.811    34.036     0.300
  -116.936    34.091     0.300
  -115.593    33.276     0.300
  -115.637    33.167     0.300
  -116.174    33.171     0.300
  -116.311    33.364     0.300
  -116.809    33.832     0.300
  -115.531    33.098     0.300
  -115.582    33.038     0.300
  -115.823    33.117     0.300
  -115.730    33.365     0.300
  -115.304    33.238     0.300
  -115.561    32.902     0.300
  -115.800    32.945     0.300
  -115.824    32.955     0.300
  -115.986    33.280     0.300
  -115.866    33.485     0.300
  -116.168    33.156     0.300
  -116.097    32.792     0.300
  -115.093    32.708     0.300
  -116.077    33.651     0.300
  -116.310    33.362     0.300
  -116.303    32.955     0.300
  -114.985    32.739     0.300
  -116.226    33.575     0.300
  -116.417    33.268     0.300
  -115.447    32.805     0.300
  -115.595    32.752     0.300
  -115.990    33.655     0.300
  -116.095    33.635     0.300
  -116.367    33.327     0.300
  -116.438    33.077     0.300
  -115.579    33.279     0.300
  -115.320    32.960     0.300
  -116.019    32.748     0.300
  -116.411    32.972     0.300
  -115.946    33.556     0.300
  -115.616    33.178     0.300
  -116.598    33.081     0.300
  -116.529    32.823     0.300
  -116.627    32.906     0.300
  -116.426    33.523     0.300
  -116.647    33.199     0.300
  -116.456    33.612     0.300
  -116.603    33.495     0.300
  -116.561    33.352     0.300
  -116.531    33.557     0.300
  -116.613    33.552     0.300
  -116.596    33.644     0.300
  -116.800    33.512     0.300
  -116.237    33.706     0.300
  -116.714    33.711     0.300
  -116.712    33.714     0.300
  -116.239    33.768     0.300
  -116.715    33.746     0.300
  -116.848    33.630     0.300
  -116.369    33.818     0.300
  -116.911    33.482     0.300
  -116.221    33.797     0.300
  -116.768    33.073     0.300
  -116.797    33.834     0.300
  -117.032    33.389     0.300
  -116.579    32.959     0.300
  -116.409    33.941     0.300
  -116.578    33.936     0.300
  -117.064    33.491     0.300
  -117.021    33.239     0.300
  -117.041    33.612     0.300
  -117.001    33.708     0.300
  -116.173    33.925     0.300
  -116.784    33.914     0.300
  -116.968    33.808     0.300
  -117.140    33.504     0.300
  -117.171    33.458     0.300
  -116.648    34.038     0.300
  -117.195    33.600     0.300
  -117.122    33.123     0.300
  -116.981    33.921     0.300
  -117.156    33.736     0.300
  -116.808    34.035     0.300
  -115.998    34.001     0.300
  -116.940    34.049     0.300
  -116.759    33.236     0.300
  -117.176    33.290     0.300
  -116.667    33.492     0.300
  -117.111    33.134     0.300
  -117.291    33.281     0.300
  -116.924    33.687     0.300
  -117.325    33.342     0.300
  -116.980    33.729     0.300
  -117.163    33.014     0.300
  -117.042    32.955     0.300
  -117.245    33.054     0.300
  -117.334    33.535     0.300
  -117.378    33.198     0.300
  -117.030    32.917     0.300
  -117.142    32.915     0.300
  -117.326    33.675     0.300
  -116.974    32.840     0.300
  -117.426    33.649     0.300
  -117.224    32.879     0.300
  -116.550    33.824     0.300
  -117.580    33.388     0.300
  -117.391    33.744     0.300
  -117.205    33.862     0.300
  -117.428    33.731     0.300
  -117.558    33.558     0.300
  -117.138    32.784     0.300
  -116.942    32.736     0.300
  -117.080    32.735     0.300
  -117.173    33.947     0.300
  -116.755    32.703     0.300
  -117.445    33.817     0.300
  -117.669    33.485     0.300
  -117.241    32.749     0.300
  -117.158    32.710     0.300
  -117.609    33.674     0.300
  -117.077    32.669     0.300
  -115.623    33.183     0.300
  -115.978    33.174     0.300
  -115.094    32.605     0.300
  -115.305    32.420     0.300
  -114.784    32.845     0.300
  -116.459    33.612     0.300
  -116.103    33.469     0.300
  -116.596    33.598     0.300
  -116.764    33.594     0.300
  -116.717    33.708     0.300
  -116.968    33.822     0.300
  -116.390    34.069     0.300
  -117.255    33.197     0.300
  -117.379    33.427     0.300
  -116.715    33.747     0.300
  -117.226    32.886     0.300
  -116.387    33.696     0.300
  -117.599    33.526     0.300
  -117.327    33.973     0.300
  -117.327    33.973     0.300
  -117.691    33.628     0.300
  -115.624    33.037     0.300
  -115.621    32.765     0.300
  -116.808    33.503     0.300
  -115.505    32.829     0.300
  -115.109    32.448     0.300
  -116.366    32.651     0.300
  -116.485    32.643     0.300
  -116.038    34.126     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -116.070    33.721     0.200
>
  -116.207    33.869     0.200
>
  -116.063    33.113     0.200
>
  -116.459    33.444     0.200
>
  -116.454    33.444     0.200
>
  -116.866    33.503     0.200
>
  -116.872    33.498     0.200
>
  -115.750    33.326     0.200
>
  -115.743    33.296     0.200
>
  -116.440    33.242     0.200
>
  -116.924    33.970     0.200
>
  -116.363    32.995     0.200
>
  -116.359    32.989     0.200
>
  -116.418    33.395     0.200
>
  -116.496    33.422     0.200
>
  -115.996    33.163     0.200
>
  -116.446    33.988     0.200
>
  -115.566    33.041     0.200
>
  -116.837    33.711     0.200
>
  -116.314    33.009     0.200
>
  -115.548    32.934     0.200
>
  -116.157    33.856     0.200
>
  -116.161    33.842     0.200
>
  -116.415    33.319     0.200
>
  -115.581    33.029     0.200
>
  -115.566    33.027     0.200
>
  -115.566    33.032     0.200
>
  -115.570    33.030     0.200
>
  -115.574    33.014     0.200
>
  -115.619    32.987     0.200
>
  -115.570    33.033     0.200
>
  -115.554    33.052     0.200
>
  -115.604    32.976     0.200
>
  -115.553    33.040     0.200
>
  -115.545    33.039     0.200
>
  -115.586    33.017     0.200
>
  -115.594    33.022     0.200
>
  -116.322    33.020     0.200
>
  -116.004    33.891     0.200
>
  -116.252    32.998     0.200
>
  -116.470    33.516     0.200
>
  -116.460    33.500     0.200
>
  -115.593    33.219     0.200
>
  -115.737    33.280     0.200
>
  -115.642    33.240     0.200
>
  -116.391    33.353     0.200
>
  -116.985    33.803     0.200
>
  -115.615    33.192     0.200
>
  -116.032    33.932     0.200
>
  -116.034    33.920     0.200
>
  -115.655    33.166     0.200
>
  -115.733    33.782     0.200
>
  -116.899    33.966     0.200
>
  -116.449    33.444     0.200
>
  -115.584    32.978     0.200
>
  -115.548    32.930     0.200
>
  -115.771    32.958     0.200
>
  -115.735    33.309     0.200
>
  -115.735    33.302     0.200
>
  -115.718    33.313     0.200
>
  -115.739    33.302     0.200
>
  -115.738    33.303     0.200
>
  -115.587    33.190     0.200
>
  -115.557    32.985     0.200
>
  -115.559    32.986     0.200
>
  -116.049    33.245     0.200
>
  -115.669    33.163     0.200
>
  -116.485    33.157     0.200
>
  -116.514    33.495     0.200
>
  -116.325    33.919     0.200
>
  -116.299    33.390     0.200
>
  -115.929    33.059     0.200
>
  -116.325    33.924     0.200
>
  -115.646    33.129     0.200
>
  -116.831    33.472     0.200
>
  -115.989    33.022     0.200
>
  -115.523    32.898     0.200
>
  -116.050    33.993     0.200
>
  -115.804    33.364     0.200
>
  -115.798    33.368     0.200
>
  -116.833    33.575     0.200
>
  -116.511    33.489     0.200
>
  -115.633    33.190     0.200
>
  -116.016    33.025     0.200
>
  -115.713    33.262     0.200
>
  -115.714    33.252     0.200
>
  -115.698    33.256     0.200
>
  -115.704    33.279     0.200
>
  -116.411    33.949     0.200
>
  -115.606    33.048     0.200
>
  -115.609    33.060     0.200
>
  -115.602    33.055     0.200
>
  -115.606    33.052     0.200
>
  -115.611    33.057     0.200
>
  -115.615    33.065     0.200
>
  -115.603    33.047     0.200
>
  -115.609    33.068     0.200
>
  -115.592    33.067     0.200
>
  -115.593    33.067     0.200
>
  -115.593    33.063     0.200
>
  -115.603    33.027     0.200
>
  -115.594    33.202     0.200
>
  -115.622    33.178     0.200
>
  -116.951    33.418     0.200
>
  -115.898    33.782     0.200
>
  -115.611    33.187     0.200
>
  -115.615    33.184     0.200
>
  -115.651    33.141     0.200
>
  -115.630    33.151     0.200
>
  -115.630    33.154     0.200
>
  -115.633    33.152     0.200
>
  -115.656    33.189     0.200
>
  -115.639    33.144     0.200
>
  -115.650    33.167     0.200
>
  -115.663    33.209     0.200
>
  -115.663    33.211     0.200
>
  -115.672    33.207     0.200
>
  -115.673    33.206     0.200
>
  -115.961    33.078     0.200
>
  -115.653    33.138     0.200
>
  -116.447    33.484     0.200
>
  -116.919    33.342     0.200
>
  -115.522    32.923     0.200
>
  -116.405    33.407     0.200
>
  -116.920    33.390     0.200
>
  -115.599    33.203     0.200
>
  -115.600    33.208     0.200
>
  -115.588    33.185     0.200
>
  -115.641    33.130     0.200
>
  -116.306    33.367     0.200
>
  -115.551    32.941     0.200
>
  -115.548    32.944     0.200
>
  -115.556    32.937     0.200
>
  -115.556    32.936     0.200
>
  -115.549    32.936     0.200
>
  -115.546    32.942     0.200
>
  -116.001    33.031     0.200
>
  -116.170    33.902     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -115.929    33.268     0.000   222.000   222.000
  -115.929    33.268     0.000   444.000   444.000
EOF
gmt end
