#!/bin/bash
gmt begin salton5.43_base pdf,ps
proj=-JM16.0c+
reg=-R-117.1/-115.4/32.8/34.1
gmt basemap $proj $reg -Bxa0.5f0.1 -Bya0.5f0.1 -BWeSn+t'Base Map salton5.43'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -116.070    33.721 1
  -116.207    33.869 2
  -116.063    33.113 3
  -116.459    33.444 4
  -116.454    33.444 5
  -116.866    33.503 6
  -116.872    33.498 7
  -115.750    33.326 8
  -115.743    33.296 9
  -116.440    33.242 10
  -116.924    33.970 11
  -116.363    32.995 12
  -116.359    32.989 13
  -116.418    33.395 14
  -116.496    33.422 15
  -115.996    33.163 16
  -116.446    33.988 17
  -115.566    33.041 18
  -116.837    33.711 19
  -116.314    33.009 20
  -115.548    32.934 21
  -116.157    33.856 22
  -116.161    33.842 23
  -116.415    33.319 24
  -115.581    33.029 25
  -115.566    33.027 26
  -115.566    33.032 27
  -115.570    33.030 28
  -115.574    33.014 29
  -115.619    32.987 30
  -115.570    33.033 31
  -115.554    33.052 32
  -115.604    32.976 33
  -115.553    33.040 34
  -115.545    33.039 35
  -115.586    33.017 36
  -115.594    33.022 37
  -116.322    33.020 38
  -116.004    33.891 39
  -116.252    32.998 40
  -116.470    33.516 41
  -116.460    33.500 42
  -115.593    33.219 43
  -115.737    33.280 44
  -115.642    33.240 45
  -116.391    33.353 46
  -116.985    33.803 47
  -115.615    33.192 48
  -116.032    33.932 49
  -116.034    33.920 50
  -115.655    33.166 51
  -115.733    33.782 52
  -116.899    33.966 53
  -116.449    33.444 54
  -115.584    32.978 55
  -115.548    32.930 56
  -115.771    32.958 57
  -115.735    33.309 58
  -115.735    33.302 59
  -115.718    33.313 60
  -115.739    33.302 61
  -115.738    33.303 62
  -115.587    33.190 63
  -115.557    32.985 64
  -115.559    32.986 65
  -116.049    33.245 66
  -115.669    33.163 67
  -116.485    33.157 68
  -116.514    33.495 69
  -116.325    33.919 70
  -116.299    33.390 71
  -115.929    33.059 72
  -116.325    33.924 73
  -115.646    33.129 74
  -116.831    33.472 75
  -115.989    33.022 76
  -115.523    32.898 77
  -116.050    33.993 78
  -115.804    33.364 79
  -115.798    33.368 80
  -116.833    33.575 81
  -116.511    33.489 82
  -115.633    33.190 83
  -116.016    33.025 84
  -115.713    33.262 85
  -115.714    33.252 86
  -115.698    33.256 87
  -115.704    33.279 88
  -116.411    33.949 89
  -115.606    33.048 90
  -115.609    33.060 91
  -115.602    33.055 92
  -115.606    33.052 93
  -115.611    33.057 94
  -115.615    33.065 95
  -115.603    33.047 96
  -115.609    33.068 97
  -115.592    33.067 98
  -115.593    33.067 99
  -115.593    33.063 100
  -115.603    33.027 101
  -115.594    33.202 102
  -115.622    33.178 103
  -116.951    33.418 104
  -115.898    33.782 105
  -115.611    33.187 106
  -115.615    33.184 107
  -115.651    33.141 108
  -115.630    33.151 109
  -115.630    33.154 110
  -115.633    33.152 111
  -115.656    33.189 112
  -115.639    33.144 113
  -115.650    33.167 114
  -115.663    33.209 115
  -115.663    33.211 116
  -115.672    33.207 117
  -115.673    33.206 118
  -115.961    33.078 119
  -115.653    33.138 120
  -116.447    33.484 121
  -116.919    33.342 122
  -115.522    32.923 123
  -116.405    33.407 124
  -116.920    33.390 125
  -115.599    33.203 126
  -115.600    33.208 127
  -115.588    33.185 128
  -115.641    33.130 129
  -116.306    33.367 130
  -115.551    32.941 131
  -115.548    32.944 132
  -115.556    32.937 133
  -115.556    32.936 134
  -115.549    32.936 135
  -115.546    32.942 136
  -116.001    33.031 137
  -116.170    33.902 138
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -116.050    33.708
  -116.070    33.721
>
  -116.193    33.850
  -116.207    33.869
>
  -115.999    33.128
  -116.063    33.113
>
  -116.425    33.406
  -116.459    33.444
>
  -116.379    33.438
  -116.454    33.444
>
  -116.895    33.453
  -116.866    33.503
>
  -116.901    33.461
  -116.872    33.498
>
  -115.733    33.294
  -115.750    33.326
>
  -115.697    33.271
  -115.743    33.296
>
  -116.427    33.239
  -116.440    33.242
>
  -116.893    33.959
  -116.924    33.970
>
  -116.326    33.025
  -116.363    32.995
>
  -116.329    32.989
  -116.359    32.989
>
  -116.406    33.382
  -116.418    33.395
>
  -116.500    33.402
  -116.496    33.422
>
  -115.987    33.171
  -115.996    33.163
>
  -116.386    33.969
  -116.446    33.988
>
  -115.569    33.036
  -115.566    33.041
>
  -116.834    33.680
  -116.837    33.711
>
  -116.255    33.021
  -116.314    33.009
>
  -115.561    32.909
  -115.548    32.934
>
  -116.116    33.830
  -116.157    33.856
>
  -116.159    33.840
  -116.161    33.842
>
  -116.404    33.304
  -116.415    33.319
>
  -115.581    33.028
  -115.581    33.029
>
  -115.577    33.046
  -115.566    33.027
>
  -115.567    33.027
  -115.566    33.032
>
  -115.535    33.047
  -115.570    33.030
>
  -115.553    32.993
  -115.574    33.014
>
  -115.594    32.979
  -115.619    32.987
>
  -115.554    33.034
  -115.570    33.033
>
  -115.546    33.051
  -115.554    33.052
>
  -115.589    32.937
  -115.604    32.976
>
  -115.576    32.996
  -115.553    33.040
>
  -115.588    33.057
  -115.545    33.039
>
  -115.582    33.005
  -115.586    33.017
>
  -115.569    33.007
  -115.594    33.022
>
  -116.300    33.019
  -116.322    33.020
>
  -115.988    33.873
  -116.004    33.891
>
  -116.226    33.031
  -116.252    32.998
>
  -116.452    33.483
  -116.470    33.516
>
  -116.441    33.454
  -116.460    33.500
>
  -115.552    33.199
  -115.593    33.219
>
  -115.644    33.221
  -115.737    33.280
>
  -115.626    33.212
  -115.642    33.240
>
  -116.393    33.328
  -116.391    33.353
>
  -116.967    33.789
  -116.985    33.803
>
  -115.610    33.191
  -115.615    33.192
>
  -116.024    33.936
  -116.032    33.932
>
  -116.030    33.923
  -116.034    33.920
>
  -115.668    33.139
  -115.655    33.166
>
  -115.824    33.737
  -115.733    33.782
>
  -116.898    33.951
  -116.899    33.966
>
  -116.450    33.423
  -116.449    33.444
>
  -115.569    32.962
  -115.584    32.978
>
  -115.551    32.916
  -115.548    32.930
>
  -115.772    32.961
  -115.771    32.958
>
  -115.725    33.282
  -115.735    33.309
>
  -115.721    33.291
  -115.735    33.302
>
  -115.717    33.305
  -115.718    33.313
>
  -115.732    33.302
  -115.739    33.302
>
  -115.731    33.299
  -115.738    33.303
>
  -115.584    33.183
  -115.587    33.190
>
  -115.554    32.979
  -115.557    32.985
>
  -115.561    32.971
  -115.559    32.986
>
  -116.047    33.222
  -116.049    33.245
>
  -115.673    33.158
  -115.669    33.163
>
  -116.476    33.147
  -116.485    33.157
>
  -116.491    33.479
  -116.514    33.495
>
  -116.304    33.893
  -116.325    33.919
>
  -116.291    33.381
  -116.299    33.390
>
  -115.902    33.072
  -115.929    33.059
>
  -116.327    33.921
  -116.325    33.924
>
  -115.637    33.129
  -115.646    33.129
>
  -116.821    33.464
  -116.831    33.472
>
  -116.020    33.000
  -115.989    33.022
>
  -115.530    32.901
  -115.523    32.898
>
  -116.053    33.984
  -116.050    33.993
>
  -115.799    33.362
  -115.804    33.364
>
  -115.798    33.355
  -115.798    33.368
>
  -116.813    33.537
  -116.833    33.575
>
  -116.514    33.482
  -116.511    33.489
>
  -115.665    33.173
  -115.633    33.190
>
  -116.021    33.011
  -116.016    33.025
>
  -115.715    33.255
  -115.713    33.262
>
  -115.696    33.245
  -115.714    33.252
>
  -115.701    33.248
  -115.698    33.256
>
  -115.691    33.268
  -115.704    33.279
>
  -116.402    33.938
  -116.411    33.949
>
  -115.584    33.050
  -115.606    33.048
>
  -115.609    33.043
  -115.609    33.060
>
  -115.628    33.055
  -115.602    33.055
>
  -115.596    33.040
  -115.606    33.052
>
  -115.635    33.037
  -115.611    33.057
>
  -115.637    33.064
  -115.615    33.065
>
  -115.614    33.039
  -115.603    33.047
>
  -115.627    33.064
  -115.609    33.068
>
  -115.602    33.062
  -115.592    33.067
>
  -115.590    33.062
  -115.593    33.067
>
  -115.590    33.027
  -115.593    33.063
>
  -115.608    33.032
  -115.603    33.027
>
  -115.619    33.223
  -115.594    33.202
>
  -115.614    33.166
  -115.622    33.178
>
  -116.935    33.413
  -116.951    33.418
>
  -115.935    33.745
  -115.898    33.782
>
  -115.574    33.186
  -115.611    33.187
>
  -115.625    33.159
  -115.615    33.184
>
  -115.668    33.137
  -115.651    33.141
>
  -115.645    33.130
  -115.630    33.151
>
  -115.643    33.148
  -115.630    33.154
>
  -115.642    33.134
  -115.633    33.152
>
  -115.667    33.170
  -115.656    33.189
>
  -115.640    33.155
  -115.639    33.144
>
  -115.677    33.167
  -115.650    33.167
>
  -115.670    33.190
  -115.663    33.209
>
  -115.672    33.207
  -115.663    33.211
>
  -115.660    33.199
  -115.672    33.207
>
  -115.683    33.198
  -115.673    33.206
>
  -115.953    33.080
  -115.961    33.078
>
  -115.648    33.134
  -115.653    33.138
>
  -116.451    33.443
  -116.447    33.484
>
  -116.905    33.343
  -116.919    33.342
>
  -115.515    32.923
  -115.522    32.923
>
  -116.394    33.393
  -116.405    33.407
>
  -116.935    33.377
  -116.920    33.390
>
  -115.605    33.193
  -115.599    33.203
>
  -115.609    33.199
  -115.600    33.208
>
  -115.593    33.168
  -115.588    33.185
>
  -115.662    33.122
  -115.641    33.130
>
  -116.320    33.361
  -116.306    33.367
>
  -115.551    32.954
  -115.551    32.941
>
  -115.548    32.927
  -115.548    32.944
>
  -115.566    32.923
  -115.556    32.937
>
  -115.571    32.932
  -115.556    32.936
>
  -115.551    32.948
  -115.549    32.936
>
  -115.542    32.937
  -115.546    32.942
>
  -115.994    33.035
  -116.001    33.031
>
  -116.153    33.845
  -116.170    33.902
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -116.070    33.717
  -116.070    33.721
>
  -116.207    33.871
  -116.207    33.869
>
  -116.062    33.114
  -116.063    33.113
>
  -116.459    33.446
  -116.459    33.444
>
  -116.454    33.446
  -116.454    33.444
>
  -116.866    33.503
  -116.866    33.503
>
  -116.872    33.499
  -116.872    33.498
>
  -115.750    33.328
  -115.750    33.326
>
  -115.743    33.298
  -115.743    33.296
>
  -116.442    33.243
  -116.440    33.242
>
  -116.925    33.968
  -116.924    33.970
>
  -116.363    32.995
  -116.363    32.995
>
  -116.359    32.990
  -116.359    32.989
>
  -116.418    33.394
  -116.418    33.395
>
  -116.496    33.423
  -116.496    33.422
>
  -115.996    33.164
  -115.996    33.163
>
  -116.447    33.985
  -116.446    33.988
>
  -115.567    33.042
  -115.566    33.041
>
  -116.843    33.713
  -116.837    33.711
>
  -116.314    33.012
  -116.314    33.009
>
  -115.549    32.935
  -115.548    32.934
>
  -116.156    33.856
  -116.157    33.856
>
  -116.163    33.843
  -116.161    33.842
>
  -116.415    33.319
  -116.415    33.319
>
  -115.581    33.028
  -115.581    33.029
>
  -115.566    33.028
  -115.566    33.027
>
  -115.569    33.033
  -115.566    33.032
>
  -115.571    33.031
  -115.570    33.030
>
  -115.575    33.015
  -115.574    33.014
>
  -115.619    32.988
  -115.619    32.987
>
  -115.573    33.035
  -115.570    33.033
>
  -115.554    33.053
  -115.554    33.052
>
  -115.607    32.978
  -115.604    32.976
>
  -115.553    33.040
  -115.553    33.040
>
  -115.546    33.040
  -115.545    33.039
>
  -115.587    33.019
  -115.586    33.017
>
  -115.595    33.024
  -115.594    33.022
>
  -116.321    33.020
  -116.322    33.020
>
  -116.004    33.892
  -116.004    33.891
>
  -116.252    32.998
  -116.252    32.998
>
  -116.471    33.516
  -116.470    33.516
>
  -116.460    33.502
  -116.460    33.500
>
  -115.596    33.220
  -115.593    33.219
>
  -115.727    33.272
  -115.737    33.280
>
  -115.643    33.241
  -115.642    33.240
>
  -116.392    33.354
  -116.391    33.353
>
  -116.986    33.804
  -116.985    33.803
>
  -115.616    33.193
  -115.615    33.192
>
  -116.032    33.932
  -116.032    33.932
>
  -116.034    33.920
  -116.034    33.920
>
  -115.655    33.166
  -115.655    33.166
>
  -115.734    33.783
  -115.733    33.782
>
  -116.900    33.965
  -116.899    33.966
>
  -116.450    33.445
  -116.449    33.444
>
  -115.585    32.979
  -115.584    32.978
>
  -115.548    32.931
  -115.548    32.930
>
  -115.771    32.958
  -115.771    32.958
>
  -115.736    33.310
  -115.735    33.309
>
  -115.736    33.302
  -115.735    33.302
>
  -115.719    33.313
  -115.718    33.313
>
  -115.740    33.302
  -115.739    33.302
>
  -115.736    33.304
  -115.738    33.303
>
  -115.588    33.189
  -115.587    33.190
>
  -115.557    32.985
  -115.557    32.985
>
  -115.560    32.987
  -115.559    32.986
>
  -116.049    33.246
  -116.049    33.245
>
  -115.670    33.163
  -115.669    33.163
>
  -116.485    33.157
  -116.485    33.157
>
  -116.512    33.495
  -116.514    33.495
>
  -116.325    33.918
  -116.325    33.919
>
  -116.299    33.390
  -116.299    33.390
>
  -115.929    33.060
  -115.929    33.059
>
  -116.325    33.923
  -116.325    33.924
>
  -115.646    33.130
  -115.646    33.129
>
  -116.831    33.473
  -116.831    33.472
>
  -115.989    33.023
  -115.989    33.022
>
  -115.523    32.899
  -115.523    32.898
>
  -116.050    33.992
  -116.050    33.993
>
  -115.804    33.364
  -115.804    33.364
>
  -115.798    33.368
  -115.798    33.368
>
  -116.834    33.575
  -116.833    33.575
>
  -116.511    33.488
  -116.511    33.489
>
  -115.634    33.190
  -115.633    33.190
>
  -116.016    33.026
  -116.016    33.025
>
  -115.714    33.263
  -115.713    33.262
>
  -115.713    33.253
  -115.714    33.252
>
  -115.699    33.256
  -115.698    33.256
>
  -115.704    33.279
  -115.704    33.279
>
  -116.411    33.949
  -116.411    33.949
>
  -115.604    33.049
  -115.606    33.048
>
  -115.610    33.060
  -115.609    33.060
>
  -115.603    33.056
  -115.602    33.055
>
  -115.607    33.053
  -115.606    33.052
>
  -115.612    33.057
  -115.611    33.057
>
  -115.616    33.066
  -115.615    33.065
>
  -115.603    33.048
  -115.603    33.047
>
  -115.610    33.068
  -115.609    33.068
>
  -115.592    33.068
  -115.592    33.067
>
  -115.593    33.067
  -115.593    33.067
>
  -115.594    33.064
  -115.593    33.063
>
  -115.603    33.027
  -115.603    33.027
>
  -115.595    33.202
  -115.594    33.202
>
  -115.623    33.179
  -115.622    33.178
>
  -116.951    33.418
  -116.951    33.418
>
  -115.900    33.778
  -115.898    33.782
>
  -115.612    33.187
  -115.611    33.187
>
  -115.615    33.185
  -115.615    33.184
>
  -115.652    33.142
  -115.651    33.141
>
  -115.631    33.152
  -115.630    33.151
>
  -115.630    33.154
  -115.630    33.154
>
  -115.633    33.152
  -115.633    33.152
>
  -115.657    33.189
  -115.656    33.189
>
  -115.639    33.144
  -115.639    33.144
>
  -115.651    33.166
  -115.650    33.167
>
  -115.663    33.209
  -115.663    33.209
>
  -115.663    33.211
  -115.663    33.211
>
  -115.672    33.207
  -115.672    33.207
>
  -115.673    33.206
  -115.673    33.206
>
  -115.963    33.079
  -115.961    33.078
>
  -115.653    33.138
  -115.653    33.138
>
  -116.447    33.483
  -116.447    33.484
>
  -116.920    33.342
  -116.919    33.342
>
  -115.522    32.923
  -115.522    32.923
>
  -116.404    33.407
  -116.405    33.407
>
  -116.922    33.390
  -116.920    33.390
>
  -115.599    33.203
  -115.599    33.203
>
  -115.599    33.208
  -115.600    33.208
>
  -115.588    33.186
  -115.588    33.185
>
  -115.641    33.130
  -115.641    33.130
>
  -116.306    33.367
  -116.306    33.367
>
  -115.552    32.942
  -115.551    32.941
>
  -115.548    32.945
  -115.548    32.944
>
  -115.555    32.938
  -115.556    32.937
>
  -115.556    32.936
  -115.556    32.936
>
  -115.549    32.937
  -115.549    32.936
>
  -115.546    32.943
  -115.546    32.942
>
  -116.004    33.031
  -116.001    33.031
>
  -116.169    33.903
  -116.170    33.902
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -116.070    33.721    83.339     1.362     1.642
  -116.207    33.869   -85.658     1.001     1.151
  -116.063    33.113    12.450     0.934     1.080
  -116.459    33.444    71.820     0.894     1.104
  -116.454    33.444    73.687     1.185     1.334
  -116.866    33.503   -88.504     0.871     1.111
  -116.872    33.498   -86.434     0.958     1.118
  -115.750    33.326    29.349     1.078     1.212
  -115.743    33.296    30.537     1.294     1.512
  -116.440    33.242    47.354     1.539     1.665
  -116.924    33.970   -78.853     1.276     1.791
  -116.363    32.995   -53.900     1.066     1.145
  -116.359    32.989    88.821     1.122     1.662
  -116.418    33.395    40.556     1.036     1.241
  -116.496    33.422   -25.614     0.676     0.812
  -115.996    33.163    -5.179     1.205     1.250
  -116.446    33.988   -53.618     0.878     1.005
  -115.566    33.041    35.030     0.979     1.053
  -116.837    33.711    27.395     1.574     1.981
  -116.314    33.009   -52.280     1.119     1.359
  -115.548    32.934    75.556     1.072     1.166
  -116.157    33.856    88.810     1.095     1.313
  -116.161    33.842    86.967     1.001     1.294
  -116.415    33.319    18.615     0.966     1.063
  -115.581    33.029    42.362     1.239     1.633
  -115.566    33.027    45.248     1.203     1.271
  -115.566    33.032    12.150     0.974     1.292
  -115.570    33.030    43.267     0.776     1.125
  -115.574    33.014    66.516     1.930     2.038
  -115.619    32.987    -0.448     1.167     1.286
  -115.570    33.033    45.525     0.669     0.999
  -115.554    33.052    33.021     1.213     1.383
  -115.604    32.976    61.350     1.219     1.560
  -115.553    33.040    53.048     0.750     0.982
  -115.545    33.039    25.817     0.922     1.276
  -115.586    33.017    51.153     1.225     1.557
  -115.594    33.022    49.870     1.043     1.399
  -116.322    33.020    76.473     0.971     1.190
  -116.004    33.891    63.756     1.238     1.605
  -116.252    32.998   -87.781     0.906     1.201
  -116.470    33.516    38.043     0.848     1.231
  -116.460    33.500    49.335     1.240     1.524
  -115.593    33.219    28.170     1.425     2.226
  -115.737    33.280    46.401     2.719     4.079
  -115.642    33.240    20.780     1.016     1.243
  -116.391    33.353    39.774     1.274     1.622
  -116.985    33.803   -52.944     0.748     0.914
  -115.615    33.192   -18.786     0.766     0.955
  -116.032    33.932   -42.720     0.727     0.901
  -116.034    33.920   -41.035     0.661     0.839
  -115.655    33.166   -22.388     0.980     1.036
  -115.733    33.782   -22.429     1.602     1.648
  -116.899    33.966   -73.773     1.075     1.473
  -116.449    33.444   -24.775     0.584     0.613
  -115.584    32.978   -87.513     0.826     1.038
  -115.548    32.930   -86.379     0.994     1.186
  -115.771    32.958   -43.776     0.692     0.831
  -115.735    33.309   -27.697     0.660     0.894
  -115.735    33.302   -27.321     0.649     0.943
  -115.718    33.313   -19.868     0.695     0.929
  -115.739    33.302   -31.004     0.611     0.872
  -115.738    33.303   -20.288     0.779     1.057
  -115.587    33.190   -19.757     0.874     1.039
  -115.557    32.985   -65.942     0.669     0.822
  -115.559    32.986   -58.456     0.612     0.775
  -116.049    33.245   -39.942     0.815     0.936
  -115.669    33.163   -29.216     0.743     0.959
  -116.485    33.157    64.985     0.733     0.770
  -116.514    33.495    10.224     0.933     1.068
  -116.325    33.919   -33.151     0.820     0.884
  -116.299    33.390   -52.163     0.732     0.788
  -115.929    33.059   -40.944     0.898     1.090
  -116.325    33.924   -42.525     0.771     0.839
  -115.646    33.129   -35.064     0.644     0.788
  -116.831    33.472   -22.976     0.578     0.774
  -115.989    33.022   -62.949     0.678     0.850
  -115.523    32.898   -31.329     0.794     0.890
  -116.050    33.993   -39.487     0.928     1.581
  -115.804    33.364   -32.988     0.866     1.135
  -115.798    33.368   -40.244     0.956     1.241
  -116.833    33.575   -31.414     0.821     1.082
  -116.511    33.489   -30.601     0.650     0.732
  -115.633    33.190   -33.963     0.632     0.816
  -116.016    33.025   -60.947     0.593     0.822
  -115.713    33.262   -28.711     1.121     1.407
  -115.714    33.252   -26.756     0.872     1.035
  -115.698    33.256   -30.892     0.685     0.884
  -115.704    33.279   -40.685     0.783     0.939
  -116.411    33.949   -49.812     0.690     0.778
  -115.606    33.048   -35.737     0.876     0.913
  -115.609    33.060    26.572     1.150     1.299
  -115.602    33.055   -56.277     0.758     0.869
  -115.606    33.052   -81.326     0.934     0.981
  -115.611    33.057    -4.352     0.918     1.285
  -115.615    33.065    -5.967     0.702     0.893
  -115.603    33.047   -21.175     0.711     0.805
  -115.609    33.068   -42.977     0.650     0.753
  -115.592    33.067   -18.138     0.666     0.746
  -115.593    33.067   -46.161     0.579     0.691
  -115.593    33.063   -31.300     0.688     0.757
  -115.603    33.027   -38.681     0.781     0.839
  -115.594    33.202   -16.338     0.755     1.000
  -115.622    33.178   -10.583     0.771     0.910
  -116.951    33.418   -25.963     0.619     0.956
  -115.898    33.782   -54.773     1.298     1.910
  -115.611    33.187   -32.166     0.639     0.758
  -115.615    33.184   -38.881     0.621     0.925
  -115.651    33.141   -38.291     0.524     0.651
  -115.630    33.151   -46.294     0.771     0.922
  -115.630    33.154   -43.342     0.505     0.601
  -115.633    33.152   -32.234     0.409     0.492
  -115.656    33.189   -46.317     0.514     0.706
  -115.639    33.144   -35.666     0.487     0.591
  -115.650    33.167   -26.531     0.553     0.671
  -115.663    33.209   -22.730     0.594     0.725
  -115.663    33.211   -37.566     0.440     0.589
  -115.672    33.207   -38.655     0.557     0.753
  -115.673    33.206   -36.563     0.470     0.616
  -115.961    33.078   -45.257     0.691     0.775
  -115.653    33.138   -29.242     0.464     0.556
  -116.447    33.484    14.788     0.478     0.528
  -116.919    33.342     9.128     0.423     0.605
  -115.522    32.923   -61.277     0.703     0.906
  -116.405    33.407     4.038     0.463     0.508
  -116.920    33.390     9.263     0.390     0.532
  -115.599    33.203   -29.351     0.448     0.628
  -115.600    33.208   -28.330     0.474     0.629
  -115.588    33.185   -36.431     0.575     0.770
  -115.641    33.130   -46.403     0.495     0.604
  -116.306    33.367    22.059     0.486     0.545
  -115.551    32.941   -69.598     0.514     0.598
  -115.548    32.944   -61.840     0.545     0.636
  -115.556    32.937   -81.174     0.636     0.777
  -115.556    32.936   -69.398     0.700     0.784
  -115.549    32.936   -69.255     0.510     0.592
  -115.546    32.942   -67.080     0.566     0.659
  -116.001    33.031   -70.524     0.713     0.746
  -116.170    33.902   -86.202     1.168     1.534
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -117.022    32.852   -64.172     0.617     0.747
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -116.999    32.852   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -117.022    32.852     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -117.022    32.852     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -117.022    32.807   5 km
EOF
gmt end
