#!/bin/bash
gmt begin penasco2.16_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases penasco2.16'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     0.500     3.120
     1.000    -0.371
     1.500    -3.861
     2.000    -7.352
     2.500   -10.842
     3.000   -14.333
     3.500   -17.826
     4.000   -21.324
     4.500   -24.822
     5.000   -28.326
     5.500   -31.831
     6.000   -35.342
     6.500   -38.854
     7.000   -42.373
     7.500   -45.897
     8.000   -49.427
     8.500   -52.961
     9.000   -56.502
     9.500   -60.049
    10.000   -63.604
    10.500   -67.165
    11.000   -70.734
    11.500   -74.311
    12.000   -77.895
    12.500   -81.489
    13.000   -85.092
    13.500   -88.704
    14.000   -92.329
    14.500   -95.967
    15.000   -99.616
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -82.092 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     1.081
     1.000     0.378
     1.500    -0.682
     2.000    -1.741
     2.500    -2.802
     3.000    -3.864
     3.500    -4.928
     4.000    -5.994
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000    -8.994 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.531     2.254     0.200
     2.711     0.767     0.200
     3.131    -0.719     0.200
     3.231     0.072     0.200
     3.499     0.144     0.200
     3.873    -1.933     0.200
     2.954    -0.780     0.200
     3.180    -1.343     0.200
     3.228    -1.626     0.200
     3.366    -1.242     0.200
     3.442    -1.688     0.200
     3.113     0.951     0.200
     2.615    -0.847     0.200
     7.039     2.489     0.200
     7.428     1.959     0.200
     8.139    -1.528     0.200
     9.127    -0.821     0.200
     9.573     0.462     0.200
     3.942    -2.790     0.200
     4.035    -0.554     0.200
     3.826    -3.051     0.200
     4.077     0.481     0.200
     4.813     1.721     0.200
     4.907     1.919     0.200
     5.234     0.364     0.200
     5.463     2.418     0.200
     5.977     3.574     0.200
     6.770     5.212     0.200
     6.970     2.147     0.200
     7.414     1.924     0.200
     7.697    -0.232     0.200
     7.979    -0.831     0.200
     9.136     1.872     0.200
     9.819     1.660     0.200
     4.185    -0.383     0.200
     6.721     4.478     0.200
     8.289    -2.525     0.200
     9.160     2.917     0.200
     7.636    -4.834     0.200
     9.025     0.827     0.200
     9.025     0.826     0.200
    10.131     6.596     0.200
    12.601     3.688     0.200
     3.689    -0.606     0.200
     5.385     1.540     0.200
     7.225     7.140     0.200
     7.680     1.011     0.200
     7.680     1.612     0.200
     8.608     5.972     0.200
     9.024    -2.016     0.200
    12.666    -5.389     0.200
    13.172     5.006     0.200
     2.876    -0.786     0.200
     3.229    -1.521     0.200
     3.398     1.863     0.200
     3.828     1.397     0.200
     4.187    -2.869     0.200
     4.789     6.154     0.200
     5.307    -4.160     0.200
     7.073    -0.758     0.200
     7.860    -3.970     0.200
     8.775     0.953     0.200
     9.075    -2.226     0.200
    10.399    -0.213     0.200
    24.098     3.374     0.200
     3.244     0.324     0.200
     3.625    -0.756     0.200
     3.851     2.422     0.200
     4.787    -1.462     0.200
     4.938    -2.540     0.200
     5.315    -2.878     0.200
     5.614    -3.042     0.200
     5.655    -2.748     0.200
     5.798    -4.122     0.200
     7.623     4.844     0.200
     7.942    -3.159     0.200
     8.810    -0.002     0.200
     9.127    -2.864     0.200
    12.960    -8.724     0.200
    13.346   -15.811     0.200
    18.081    -3.650     0.200
     3.645     1.060     0.200
     8.609     3.393     0.200
     9.260     2.303     0.200
    12.831    -5.571     0.200
    13.140   -12.258     0.200
    17.901    -6.665     0.200
    26.003     1.081     0.200
     2.758     0.072     0.200
     3.111     0.308     0.200
     3.500    -2.982     0.200
     3.713     0.420     0.200
     4.068    -4.013     0.200
     8.669    11.939     0.200
     7.373    10.394     0.200
     7.484    -1.777     0.200
     9.025     7.051     0.200
     9.668    -4.284     0.200
     3.866    -1.831     0.200
     5.985     4.971     0.200
     6.221     4.678     0.200
     6.479     6.775     0.200
     7.037    -0.644     0.200
     8.151   -10.134     0.200
     8.853     1.589     0.200
     9.296    -5.265     0.200
    10.557    -1.590     0.200
    13.118    -3.552     0.200
     3.880    -0.112     0.200
     3.880     0.288     0.200
     4.204    -2.734     0.200
     4.753    -1.814     0.200
     4.945    -2.312     0.200
     5.628    -4.372     0.200
     7.023    -1.678     0.200
     8.135    -5.292     0.200
     8.864     0.958     0.200
     9.273    -5.995     0.200
    10.561    -0.939     0.200
    13.114    -8.306     0.200
    13.377    -6.075     0.200
    22.001    -1.888     0.200
    26.129    -9.110     0.200
     3.391    -1.380     0.200
     3.585     3.310     0.200
     7.840     5.199     0.200
     9.219    -0.251     0.200
    12.722     0.558     0.200
     2.735    -0.166     0.200
     2.936    -1.478     0.200
     3.067    -2.523     0.200
     3.283    -1.625     0.200
     3.160    -2.587     0.200
     3.167    -2.436     0.200
     2.981    -3.100     0.200
     3.328    -4.818     0.200
     3.690     4.739     0.200
     3.956    -3.088     0.200
     4.710    -6.539     0.200
     5.279    -6.765     0.200
     5.905     1.426     0.200
     5.983     1.127     0.200
     6.075    -7.798     0.200
     6.037     3.566     0.200
     6.320     1.960     0.200
     6.276     1.376     0.200
     6.516    -7.855     0.200
     6.947     4.311     0.200
     8.155    -8.335     0.200
     8.941    -4.122     0.200
     9.240    -5.714     0.200
     9.298    -5.849     0.200
     9.720     1.017     0.200
    12.285    -0.112     0.200
     3.300     5.504     0.200
     9.240     2.236     0.200
     9.833     5.842     0.200
    12.378    13.661     0.200
     3.167    -1.952     0.200
     7.005    -0.082     0.200
     7.727    -7.677     0.200
     8.915   -13.403     0.200
    10.404    10.171     0.200
     2.931     1.073     0.200
     7.559    -6.799     0.200
     9.433   -11.720     0.200
     9.471    12.047     0.200
    12.082     3.773     0.200
     7.588     8.550     0.200
     9.416     2.144     0.200
     3.498     5.741     0.200
     9.138   -14.138     0.200
    10.023    -4.065     0.200
     7.771     0.733     0.200
     8.886    -3.451     0.200
     3.128    -0.208     0.200
     3.899    -1.092     0.200
     7.001    -9.471     0.200
     8.088     5.483     0.200
     9.219     0.311     0.200
    10.558     2.909     0.200
    13.093     4.725     0.200
     3.939    -0.772     0.200
     6.959    -5.900     0.200
     8.006    -0.108     0.200
     8.905    -3.150     0.200
     9.123    -4.378     0.200
    10.557    -3.692     0.200
    13.059    -4.251     0.200
     7.734     0.503     0.200
     8.529     3.518     0.200
     9.127    -2.791     0.200
    10.144     3.959     0.200
     3.085    -2.507     0.200
     3.519     1.614     0.200
     7.723    -2.257     0.200
     9.170    -7.994     0.200
    10.071    -6.084     0.200
     2.693     6.234     0.200
     7.568    -2.853     0.200
     7.600     6.311     0.200
     9.261     7.996     0.200
     9.593     1.190     0.200
    11.927     9.502     0.200
     4.211    -2.811     0.200
     9.199    -6.299     0.200
     9.152   -13.771     0.200
     4.253    -1.796     0.200
     9.158    -3.165     0.200
     2.994     7.500     0.200
     7.513    -0.724     0.200
     7.889    13.573     0.200
     9.360    -3.493     0.200
     9.503     5.386     0.200
    12.087     6.546     0.200
     3.378     0.017     0.200
     7.710    -0.140     0.200
     9.253     2.619     0.200
     2.609    -0.985     0.200
     9.234     0.828     0.200
     7.401    -3.390     0.200
     7.525    -4.863     0.200
     8.432     7.332     0.200
     9.065    -2.740     0.200
     9.684    -0.571     0.200
    11.761    -1.068     0.200
    11.969    -1.164     0.200
    16.680    -5.542     0.200
    23.195    -8.515     0.200
     4.229     1.268     0.200
     6.679     1.780     0.200
     8.257    -5.644     0.200
     9.150   -10.694     0.200
     9.217     0.916     0.200
     4.464     0.069     0.200
     6.436    -1.450     0.200
     8.181    -2.797     0.200
     8.923    -2.335     0.200
     9.435     4.101     0.200
    11.068     2.293     0.200
    13.493    -3.308     0.200
    24.613     2.580     0.200
     4.225     0.898     0.200
     8.151     6.385     0.200
     9.058     1.118     0.200
     7.693     1.963     0.200
     8.423     6.250     0.200
     9.162    -3.815     0.200
    12.556     7.287     0.200
     3.648     0.538     0.200
     4.463    10.675     0.200
     8.020    -4.089     0.200
     8.781   -12.477     0.200
     9.413    10.211     0.200
    11.001     7.888     0.200
    13.381     2.558     0.200
     8.037    -1.039     0.200
     8.795    -4.284     0.200
     9.417     1.786     0.200
     4.442     0.677     0.200
     8.057    -2.163     0.200
     8.828    -4.072     0.200
     3.713    -1.339     0.200
     8.020     0.839     0.200
     8.823   -13.075     0.200
     9.354    16.895     0.200
    13.344     7.920     0.200
     4.409     6.252     0.200
     8.058    -6.570     0.200
     8.852   -10.355     0.200
     9.367     5.624     0.200
    10.973     0.781     0.200
    13.376    -3.342     0.200
     4.381    12.060     0.200
     7.974     0.027     0.200
     8.797    -8.223     0.200
    10.913     7.207     0.200
    13.300     4.122     0.200
     4.389     5.736     0.200
     8.007    -0.464     0.200
     3.585    -1.548     0.200
     4.426    16.345     0.200
     8.779   -17.097     0.200
     9.372    10.672     0.200
    10.956     4.336     0.200
     8.783    -8.371     0.200
     4.337     5.841     0.200
     7.916     0.250     0.200
     8.778    -6.014     0.200
     8.784    -1.730     0.200
     4.371     8.867     0.200
     7.973    -1.238     0.200
     8.804    -9.036     0.200
     4.347     8.412     0.200
     7.938    -0.810     0.200
     8.790    -9.943     0.200
     7.948    -0.732     0.200
     8.771    -9.049     0.200
     4.347    13.014     0.200
     7.941     1.095     0.200
     8.792    -7.608     0.200
     4.420     7.636     0.200
     7.985    -2.042     0.200
     8.780   -10.009     0.200
     9.366     9.456     0.200
    10.950     8.541     0.200
    13.330     8.347     0.200
     2.802     1.532     0.200
     2.802    -0.368     0.200
     4.450     1.722     0.200
     8.010    -2.336     0.200
     8.782    -8.304     0.200
     9.399     3.571     0.200
    10.986     1.467     0.200
     4.400     2.862     0.200
     7.967    -1.963     0.200
     8.779    -7.546     0.200
     9.345    -2.046     0.200
    10.926    -3.427     0.200
    13.306     1.665     0.200
     4.372    12.486     0.200
     7.938     3.760     0.200
     8.772    -8.055     0.200
     4.460     6.893     0.200
     8.154     2.144     0.200
     8.902    -4.982     0.200
     7.964    -5.921     0.200
     8.781    -9.633     0.200
     4.435     8.052     0.200
     8.010     3.738     0.200
     8.792    -6.660     0.200
     8.824    -5.914     0.200
    10.907     1.805     0.200
     4.243     6.356     0.200
     8.694     4.750     0.200
     9.156     8.429     0.200
    13.047    12.442     0.200
     4.385     9.039     0.200
     7.998    -0.900     0.200
     8.816    -7.280     0.200
    13.320     7.565     0.200
     8.813   -16.142     0.200
     9.297    16.463     0.200
    13.278    11.653     0.200
     7.989    -3.834     0.200
     8.811    -9.986     0.200
    10.918     1.863     0.200
    13.310    -1.904     0.200
     4.418     9.015     0.200
     8.001     4.958     0.200
     8.796    -9.599     0.200
     9.366     8.472     0.200
    10.955     8.249     0.200
    13.341     9.805     0.200
     4.416     2.473     0.200
     7.968    -2.184     0.200
     8.769    -6.650     0.200
    10.940     4.855     0.200
    13.316     3.066     0.200
     4.408     8.965     0.200
     7.997     5.380     0.200
     8.799    -4.761     0.200
    10.945    10.861     0.200
    13.332    12.577     0.200
     3.223    -0.406     0.200
     2.597    -1.109     0.200
     4.358    11.970     0.200
     7.954    -2.319     0.200
     8.796   -10.800     0.200
    13.272     4.690     0.200
     2.608     1.081     0.200
     7.988     7.458     0.200
     8.782    -3.666     0.200
     4.437     1.010     0.200
     8.044    -3.861     0.200
     8.820    -7.817     0.200
     4.406    16.507     0.200
     8.017     1.745     0.200
     8.818   -10.518     0.200
     9.358    15.519     0.200
    10.952    15.828     0.200
    13.345    11.907     0.200
     8.051    -1.125     0.200
     8.846    -8.275     0.200
     9.364    10.588     0.200
    13.370     6.418     0.200
     3.530    -0.664     0.200
     4.419     0.255     0.200
     8.032   -10.051     0.200
     8.822    -7.591     0.200
     9.372     1.041     0.200
    10.969    -2.893     0.200
    13.363    -4.433     0.200
     4.416     7.692     0.200
     7.986    -6.281     0.200
     8.784    -8.709     0.200
     4.453     8.228     0.200
     8.038    -1.331     0.200
     8.804    -9.101     0.200
     8.027     8.654     0.200
     8.794    -4.860     0.200
     4.365    13.089     0.200
     7.972    10.783     0.200
     8.806    -4.921     0.200
     3.428     0.916     0.200
     3.591    -0.343     0.200
     3.591     0.775     0.200
     3.645     4.322     0.200
     4.375     1.079     0.200
     4.948     0.228     0.200
     7.884     1.955     0.200
     8.725    -1.424     0.200
    10.869    -0.538     0.200
    13.231     2.290     0.200
     2.574     2.540     0.200
     8.032    -1.678     0.200
     3.683     3.105     0.200
     4.416     7.111     0.200
     5.937     4.758     0.200
     8.802    -7.726     0.200
     9.365     7.491     0.200
    10.956     6.496     0.200
     4.404     6.668     0.200
     8.004    -5.520     0.200
     8.808   -12.112     0.200
     3.557     1.725     0.200
     3.595     4.521     0.200
     4.470    11.355     0.200
     7.655     2.055     0.200
     8.047     0.747     0.200
     8.796    18.768     0.200
     8.801    -7.503     0.200
     9.423    11.240     0.200
    10.104     9.451     0.200
    11.018     9.163     0.200
    13.403     8.283     0.200
     4.388     6.164     0.200
     7.985    -2.013     0.200
     8.802    -7.221     0.200
     9.336     3.322     0.200
    10.924    -0.767     0.200
    13.312    -0.835     0.200
     8.003    -0.474     0.200
     8.794    -9.424     0.200
    13.346    -5.415     0.200
     4.448    11.574     0.200
     8.023    -0.456     0.200
     8.794   -15.491     0.200
     7.998     1.207     0.200
     8.788    -9.591     0.200
     4.375     2.854     0.200
     7.959    -6.417     0.200
     8.788    -7.384     0.200
     8.003     3.839     0.200
     4.386    10.823     0.200
     8.005     0.171     0.200
     8.820    -9.726     0.200
     4.458     5.952     0.200
     8.155    -4.039     0.200
     8.904    -7.641     0.200
     8.059     3.747     0.200
     8.824    -8.896     0.200
     3.583     0.566     0.200
     7.921     1.856     0.200
     8.743    -4.133     0.200
     8.011     0.159     0.200
     8.810    -7.684     0.200
     4.178    12.883     0.200
     7.756     2.433     0.200
     9.096     9.818     0.200
    10.647     5.515     0.200
    13.022     3.577     0.200
     2.585     2.131     0.200
     3.431     6.476     0.200
     3.538     1.114     0.200
     3.464     7.485     0.200
     7.730    -4.901     0.200
     4.196     4.743     0.200
     7.817    -2.022     0.200
     8.792    -8.206     0.200
     4.158    17.566     0.200
     7.818     0.915     0.200
     8.818   -10.820     0.200
     3.695     6.473     0.200
     7.637     3.494     0.200
     8.606    19.454     0.200
    12.637    12.956     0.200
     4.246     2.541     0.200
     7.840    -3.266     0.200
     8.776    -6.284     0.200
    10.742    -1.255     0.200
    13.124    -1.252     0.200
     4.198     5.555     0.200
     7.817     0.872     0.200
     8.790    -4.211     0.200
     7.875     0.958     0.200
     8.802    -5.645     0.200
    10.761     1.764     0.200
    13.151     6.052     0.200
     4.203    12.174     0.200
     7.848     3.916     0.200
     8.813    -5.801     0.200
    10.709     8.413     0.200
    13.104     3.113     0.200
     2.675     1.913     0.200
     3.616     0.046     0.200
     4.148     9.684     0.200
     7.769    -0.215     0.200
     8.785    -5.657     0.200
    13.013     0.916     0.200
     4.136    16.351     0.200
     7.769     1.950     0.200
     8.793    -7.717     0.200
     2.956     1.639     0.200
     3.571     9.680     0.200
     7.830     4.122     0.200
     9.220    -8.129     0.200
     2.749     1.011     0.200
     7.460    -0.135     0.200
     7.629    -0.978     0.200
     9.251    -1.130     0.200
     9.484    -1.371     0.200
    11.876     3.123     0.200
     2.798    -1.376     0.200
     2.716     0.234     0.200
     9.515     1.597     0.200
    11.864     5.289     0.200
     7.471    -7.119     0.200
     7.599    -2.691     0.200
     9.227    -5.789     0.200
     9.513    -1.782     0.200
    11.863    -6.312     0.200
    16.849    -4.446     0.200
     2.946     0.775     0.200
     3.177    -2.223     0.200
     7.537    -3.218     0.200
     7.847    -3.274     0.200
     9.408   -10.265     0.200
     9.473     1.174     0.200
    12.075     3.134     0.200
     3.086    -1.719     0.200
     2.825    11.136     0.200
     7.492    -2.817     0.200
     7.714    10.053     0.200
     9.338     6.222     0.200
     9.456    -7.428     0.200
     2.573     1.897     0.200
     3.158    -1.213     0.200
     7.486    -3.792     0.200
     9.321    -2.564     0.200
     9.462    -7.084     0.200
     3.161    -1.589     0.200
     2.835     9.290     0.200
     3.776    -2.843     0.200
     7.481    -4.392     0.200
     7.721     6.298     0.200
     9.340     2.511     0.200
     9.442    -8.116     0.200
    11.952     0.579     0.200
     3.153    -2.649     0.200
     3.759    -3.192     0.200
     7.774     0.466     0.200
     8.974    -3.630     0.200
    10.398     8.217     0.200
    12.851     2.230     0.200
     2.731    -2.682     0.200
     2.903    -2.514     0.200
     7.466     1.807     0.200
     9.643    -5.622     0.200
    11.807     2.180     0.200
     2.575     6.314     0.200
     7.464     7.311     0.200
     7.501    -3.739     0.200
     9.624    -3.980     0.200
    11.789     4.503     0.200
     3.453    15.323     0.200
     7.699    -4.068     0.200
     8.381    15.242     0.200
     9.195   -12.511     0.200
    10.003     5.824     0.200
    12.533     3.123     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.009     0.140     0.200
     2.207    -4.316     0.200
     2.679   -10.769     0.200
     0.901     0.286     0.200
     1.581    -3.316     0.200
     2.327    -7.660     0.200
     1.073    -1.111     0.200
     1.398    -1.546     0.200
     1.666    -3.031     0.200
     1.953    -7.031     0.200
     2.161    -5.564     0.200
     2.232    -7.046     0.200
     2.413    -8.388     0.200
     2.399    -7.507     0.200
     2.486    -7.869     0.200
     2.783   -10.888     0.200
     2.718    -9.359     0.200
     2.800   -10.317     0.200
     2.857   -10.917     0.200
     3.004   -10.780     0.200
     3.081   -10.803     0.200
     3.227   -13.193     0.200
     3.328   -13.780     0.200
     3.524   -16.189     0.200
     3.497   -13.784     0.200
     3.664   -16.119     0.200
     3.683   -15.734     0.200
     3.819   -16.381     0.200
     3.866   -17.907     0.200
     3.966   -17.450     0.200
     4.209   -20.162     0.200
     4.642   -22.349     0.200
     4.712   -21.949     0.200
     4.710   -21.200     0.200
     4.743   -21.402     0.200
     4.779   -22.806     0.200
     5.246   -25.428     0.200
     1.084    -1.090     0.200
     1.392    -1.434     0.200
     1.668    -2.601     0.200
     1.961    -6.345     0.200
     2.150    -5.881     0.200
     2.416    -8.374     0.200
     2.395    -7.413     0.200
     2.575    -8.277     0.200
     2.978   -12.172     0.200
     2.996   -11.663     0.200
     3.216   -12.628     0.200
     3.327   -13.687     0.200
     3.392   -13.718     0.200
     3.489   -14.085     0.200
     3.661   -16.231     0.200
     3.651   -16.376     0.200
     3.671   -16.492     0.200
     3.810   -16.094     0.200
     3.854   -17.367     0.200
     3.892   -17.888     0.200
     3.954   -17.991     0.200
     4.211   -20.633     0.200
     4.298   -21.133     0.200
     4.319   -21.404     0.200
     4.630   -22.501     0.200
     4.706   -22.288     0.200
     4.735   -22.256     0.200
     4.926   -24.653     0.200
     1.094    -0.680     0.200
     1.094     0.589     0.200
     1.370    -0.815     0.200
     1.646    -1.759     0.200
     2.372    -6.555     0.200
     2.779    -9.353     0.200
     3.504   -14.888     0.200
     3.657   -14.732     0.200
     3.791   -15.481     0.200
     3.670   -14.813     0.200
     3.846   -16.784     0.200
     1.067     0.172     0.200
     1.399    -1.736     0.200
     1.280    -1.258     0.200
     1.488    -1.605     0.200
     2.143    -4.880     0.200
     2.230    -7.042     0.200
     2.625   -10.271     0.200
     3.343   -13.875     0.200
     3.750   -15.454     0.200
     0.947     0.171     0.200
     1.783    -4.601     0.200
     3.436   -15.881     0.200
     4.166   -23.446     0.200
     5.936   -33.406     0.200
     9.819   -58.617     0.200
     1.601    -4.501     0.200
     2.534    -7.680     0.200
     2.653   -12.245     0.200
     2.694   -13.184     0.200
     2.942   -13.016     0.200
     3.077   -14.515     0.200
     3.221   -15.228     0.200
     3.662   -13.072     0.200
     8.289   -45.855     0.200
     2.922   -16.171     0.200
     3.074   -13.538     0.200
     3.080   -10.339     0.200
     3.080   -15.987     0.200
     3.183   -12.302     0.200
     3.383   -14.918     0.200
     3.640   -16.643     0.200
     5.145   -24.637     0.200
     5.174   -21.812     0.200
     5.323   -25.706     0.200
     6.379   -33.530     0.200
     6.869   -37.788     0.200
     7.120   -37.774     0.200
     7.636   -46.310     0.200
     8.787   -56.427     0.200
     8.905   -57.755     0.200
     1.287    -3.307     0.200
     1.367    -2.771     0.200
     1.367    -4.404     0.200
     2.879   -14.921     0.200
     3.050   -10.222     0.200
     3.050   -13.215     0.200
     2.959   -15.555     0.200
     3.689   -13.622     0.200
     4.071   -16.156     0.200
     4.574   -16.065     0.200
     4.710   -17.525     0.200
     4.801   -18.290     0.200
     4.818   -17.420     0.200
     7.680   -45.388     0.200
     9.024   -55.766     0.200
     9.134   -18.600     0.200
    14.490   -87.857     0.200
    15.266   -92.726     0.200
    17.253  -113.994     0.200
    20.140  -132.814     0.200
     1.465    -3.582     0.200
     1.946    -5.794     0.200
     2.960   -12.740     0.200
     3.013   -13.137     0.200
     3.621   -14.558     0.200
     1.378    -3.430     0.200
     2.960   -13.506     0.200
     3.038   -13.282     0.200
     3.451   -19.144     0.200
     7.942   -49.034     0.200
     9.127   -55.765     0.200
     1.188    -2.423     0.200
     2.844   -13.157     0.200
     3.219   -14.132     0.200
     3.605   -16.899     0.200
     3.916   -19.243     0.200
     4.061   -21.483     0.200
     5.423   -29.841     0.200
     9.260   -56.049     0.200
     2.925    -9.915     0.200
     3.133   -12.460     0.200
     3.538   -19.172     0.200
     5.342   -24.701     0.200
     0.743     3.109     0.200
     1.216    -1.062     0.200
     1.484    -1.930     0.200
     2.081    -6.231     0.200
     2.471    -8.626     0.200
     2.598    -8.415     0.200
     3.683   -16.992     0.200
     9.668   -59.546     0.200
     2.182    -8.018     0.200
     2.334    -8.304     0.200
     2.918   -12.969     0.200
     3.012   -14.128     0.200
     7.647   -35.903     0.200
     7.820   -33.572     0.200
     9.296   -60.490     0.200
     2.171    -8.672     0.200
     2.344    -8.037     0.200
     2.936   -11.599     0.200
     3.029   -12.885     0.200
     3.134   -18.206     0.200
     3.377   -20.649     0.200
     3.880   -20.187     0.200
     5.403   -22.516     0.200
     6.034   -24.024     0.200
     6.516   -52.491     0.200
     7.632   -34.833     0.200
     8.135   -48.067     0.200
     9.273   -59.116     0.200
    22.001  -151.988     0.200
     1.716    -5.853     0.200
     2.813   -15.937     0.200
     0.626     1.789     0.200
     1.379    -2.306     0.200
     1.601    -3.289     0.200
     2.000    -6.319     0.200
     2.192    -8.823     0.200
     2.346    -8.645     0.200
     3.129   -12.475     0.200
     0.796     2.564     0.200
     1.052    -0.487     0.200
     1.403    -2.207     0.200
     0.345     2.411     0.200
     3.058   -13.715     0.200
     0.735     1.496     0.200
     1.669    -5.527     0.200
     2.068    -7.856     0.200
     2.218   -10.076     0.200
     2.309    -9.503     0.200
     3.751   -18.245     0.200
     0.314     1.974     0.200
     1.395    -5.594     0.200
     1.395    -2.383     0.200
     1.474    -3.196     0.200
     1.316    -4.746     0.200
     2.421   -12.167     0.200
     3.008   -16.561     0.200
     3.081   -10.306     0.200
     3.301   -12.618     0.200
     1.549    -4.884     0.200
     1.699    -4.563     0.200
     2.519    -8.065     0.200
     4.029   -17.089     0.200
     5.378   -31.256     0.200
     0.591     2.319     0.200
     0.591     2.733     0.200
     1.061    -2.422     0.200
     1.518    -4.083     0.200
     1.595    -5.005     0.200
     1.729    -5.508     0.200
     2.505   -13.546     0.200
     2.625    -8.627     0.200
     3.198   -14.657     0.200
     3.484   -17.832     0.200
     4.081   -22.258     0.200
     4.284   -19.976     0.200
     5.426   -30.946     0.200
     2.604    -7.039     0.200
     4.023   -17.172     0.200
     5.676   -30.960     0.200
     0.866    -0.397     0.200
     0.995    -2.146     0.200
     1.177    -3.266     0.200
     1.089    -1.338     0.200
     1.588    -4.094     0.200
     2.601   -11.189     0.200
     1.112    -1.628     0.200
     1.338    -2.297     0.200
     1.453    -4.469     0.200
     1.533    -2.991     0.200
     2.873   -15.019     0.200
     3.159   -14.009     0.200
     3.262   -11.659     0.200
     3.597   -16.922     0.200
     3.723   -16.807     0.200
     5.086   -25.413     0.200
     5.619   -31.924     0.200
     7.395   -44.974     0.200
     7.976   -54.143     0.200
     0.632     1.056     0.200
     0.632     3.176     0.200
     0.807     1.498     0.200
     4.220   -20.125     0.200
     5.717   -33.016     0.200
     6.857   -41.628     0.200
     0.826     1.327     0.200
     0.612     2.799     0.200
     0.773     0.905     0.200
     1.546    -3.961     0.200
     2.180    -6.915     0.200
     1.038     0.103     0.200
     1.135    -0.899     0.200
     0.585     1.428     0.200
     0.585     2.115     0.200
     0.673     0.465     0.200
     0.673     1.547     0.200
     2.335    -9.418     0.200
     3.183   -14.061     0.200
     1.103    -2.530     0.200
     1.226    -1.613     0.200
     1.554    -3.358     0.200
     6.908   -35.697     0.200
     3.260   -13.416     0.200
     3.490   -15.228     0.200
     3.911   -13.243     0.200
     4.046   -20.582     0.200
     8.167   -50.940     0.200
     0.449     2.164     0.200
     1.202    -3.275     0.200
     1.464    -4.200     0.200
     3.939   -20.897     0.200
     1.078    -1.852     0.200
     2.774    -9.335     0.200
     2.855   -12.825     0.200
     7.535   -44.514     0.200
     3.225   -14.590     0.200
     3.225   -15.043     0.200
     3.279   -13.894     0.200
     3.519   -17.035     0.200
     5.316   -27.536     0.200
     6.351   -32.003     0.200
     7.559   -44.386     0.200
     7.723   -46.351     0.200
     7.723   -42.820     0.200
     7.992   -44.165     0.200
     8.242   -44.294     0.200
     8.312   -43.412     0.200
     8.515   -45.794     0.200
     8.830   -52.636     0.200
     9.052   -52.376     0.200
     9.170   -56.721     0.200
    10.150   -55.835     0.200
    11.389   -63.285     0.200
    12.347   -75.606     0.200
    12.992   -81.389     0.200
    13.213   -82.709     0.200
    13.645   -86.862     0.200
    14.198   -91.554     0.200
     0.939     2.581     0.200
     0.954     2.265     0.200
     1.401    -2.134     0.200
     2.080    -5.417     0.200
     3.931   -22.600     0.200
     4.388   -23.875     0.200
     7.568   -46.080     0.200
     7.778   -37.366     0.200
     0.941    -1.233     0.200
     1.670    -5.342     0.200
     2.015    -6.271     0.200
     2.074    -7.542     0.200
     4.392   -21.715     0.200
     0.941    -1.641     0.200
     1.491    -4.062     0.200
     1.690    -6.122     0.200
     3.245   -11.441     0.200
     3.341   -12.340     0.200
     3.490   -16.863     0.200
     4.022   -23.241     0.200
     8.245   -47.794     0.200
     1.579    -4.156     0.200
     0.676     1.873     0.200
     0.752     1.725     0.200
     1.235    -1.334     0.200
     1.515    -4.400     0.200
     2.983   -11.731     0.200
     3.137   -13.660     0.200
     3.295   -11.775     0.200
     3.538   -17.463     0.200
     3.936   -18.790     0.200
     5.299   -29.182     0.200
     6.053   -32.795     0.200
     0.718     0.327     0.200
     0.794     0.831     0.200
     0.975    -0.330     0.200
     0.997     0.252     0.200
     2.651   -11.678     0.200
     3.280   -16.661     0.200
     4.037   -18.299     0.200
     4.114   -15.740     0.200
     1.013    -0.316     0.200
     2.688    -8.531     0.200
     3.420   -15.159     0.200
     4.019   -16.471     0.200
     9.234   -54.695     0.200
     0.466     2.118     0.200
     0.935    -1.327     0.200
     3.270   -22.266     0.200
     4.491   -28.234     0.200
     8.432   -55.648     0.200
     8.964   -63.628     0.200
     9.089   -61.079     0.200
     9.458   -62.095     0.200
    11.975   -83.397     0.200
    13.868   -96.072     0.200
    15.575  -108.879     0.200
    15.596  -109.035     0.200
    15.610  -108.873     0.200
    15.855  -110.453     0.200
     0.503     2.358     0.200
     0.861    -0.637     0.200
     0.949    -0.704     0.200
     1.044    -1.745     0.200
     1.882    -5.122     0.200
     1.929    -7.197     0.200
     2.921   -16.559     0.200
     3.260   -13.311     0.200
     3.792   -16.217     0.200
     4.024   -25.429     0.200
     0.537     3.230     0.200
     0.811     2.249     0.200
     1.364    -2.582     0.200
     1.579    -3.681     0.200
     0.459     2.699     0.200
     1.919    -4.414     0.200
     2.665   -10.469     0.200
     3.209   -10.437     0.200
     8.181   -47.744     0.200
     8.923   -53.482     0.200
     0.452     2.706     0.200
     1.757    -6.456     0.200
     1.783    -5.021     0.200
     2.771   -12.931     0.200
     3.289   -15.367     0.200
     3.398   -18.282     0.200
     3.539   -16.886     0.200
     3.878   -18.680     0.200
     5.160   -29.016     0.200
     5.823   -36.121     0.200
     1.164    -3.418     0.200
     1.687    -4.704     0.200
     3.218   -11.845     0.200
     1.109    -3.613     0.200
     1.749    -5.036     0.200
     1.775    -5.845     0.200
     2.779   -13.272     0.200
     3.371   -17.099     0.200
     3.406   -13.529     0.200
     5.831   -37.278     0.200
     0.560     2.179     0.200
     0.560     1.015     0.200
     0.645     1.096     0.200
     0.645     1.987     0.200
     1.593    -5.174     0.200
     2.174   -10.269     0.200
     1.783    -4.571     0.200
     1.783    -5.511     0.200
     4.225   -16.102     0.200
     9.058   -53.507     0.200
     1.686    -3.197     0.200
     1.721    -4.948     0.200
     3.230   -13.060     0.200
     0.739     2.734     0.200
     0.739     3.303     0.200
     1.026    -0.229     0.200
     0.706     1.118     0.200
     1.066    -1.896     0.200
     0.704     1.714     0.200
     0.704     1.906     0.200
     1.157    -1.162     0.200
     1.500    -4.455     0.200
     2.627    -8.871     0.200
     0.733     1.186     0.200
     1.094    -1.412     0.200
     1.205    -1.114     0.200
     1.526    -2.816     0.200
     1.526    -3.074     0.200
     1.579    -3.266     0.200
     2.039    -6.198     0.200
     2.769   -15.598     0.200
     9.162   -54.042     0.200
     1.228    -0.917     0.200
     1.480    -2.764     0.200
     2.205    -5.877     0.200
     2.269    -6.939     0.200
     3.730   -14.389     0.200
     4.231   -17.641     0.200
     1.940    -6.792     0.200
     2.015    -8.570     0.200
     2.560   -11.284     0.200
     3.570   -18.877     0.200
     3.680   -15.148     0.200
     2.014    -7.880     0.200
     3.155   -10.124     0.200
     3.581   -21.735     0.200
     3.689   -14.857     0.200
     3.690   -18.741     0.200
     5.043   -31.269     0.200
     0.550     1.972     0.200
     0.905    -1.494     0.200
     1.898    -5.102     0.200
     1.971    -6.845     0.200
     3.503   -16.872     0.200
     0.854     1.742     0.200
     2.026    -7.649     0.200
     2.013    -7.213     0.200
     2.549    -6.731     0.200
     2.549    -9.263     0.200
     2.788    -8.757     0.200
     3.138   -10.847     0.200
     3.670   -14.200     0.200
     3.669   -14.834     0.200
     3.952   -14.999     0.200
     8.020   -47.413     0.200
     0.847     1.539     0.200
     0.929     2.430     0.200
     1.947    -5.496     0.200
     1.947    -5.918     0.200
     2.026    -7.862     0.200
     2.004    -3.996     0.200
     2.560    -7.319     0.200
     2.560    -9.878     0.200
     3.585   -19.134     0.200
     3.554   -14.766     0.200
     3.686   -13.975     0.200
     3.686   -16.116     0.200
     3.681   -15.907     0.200
     5.039   -29.687     0.200
     1.971    -9.852     0.200
     2.593   -15.336     0.200
     3.717   -21.783     0.200
     1.975    -6.643     0.200
     3.195   -14.554     0.200
     3.582   -18.731     0.200
     3.723   -14.054     0.200
     0.540     1.728     0.200
     2.850   -10.640     0.200
     2.836   -12.415     0.200
     3.564   -13.955     0.200
     3.720   -14.454     0.200
     5.058   -22.430     0.200
     2.622    -8.489     0.200
     3.208   -16.734     0.200
     3.603   -15.375     0.200
     3.743   -16.705     0.200
     3.736   -17.136     0.200
     5.090   -22.195     0.200
     8.058   -47.570     0.200
     1.946    -7.882     0.200
     1.966    -6.822     0.200
     2.590    -7.791     0.200
     2.590   -13.369     0.200
     3.202   -13.315     0.200
     3.518   -14.538     0.200
     3.671   -13.906     0.200
     3.704   -17.364     0.200
     5.027   -27.560     0.200
     0.924    -0.745     0.200
     1.420    -2.639     0.200
     1.485    -3.214     0.200
     1.726    -4.761     0.200
     1.880    -5.845     0.200
     1.952    -8.152     0.200
     1.953    -6.055     0.200
     3.207   -12.079     0.200
     3.484   -16.201     0.200
     3.551   -15.921     0.200
     3.722   -15.458     0.200
     8.007   -43.417     0.200
     8.821   -55.347     0.200
     1.901    -4.168     0.200
     1.968    -5.673     0.200
     1.975    -5.702     0.200
     3.506   -13.164     0.200
     0.854     2.260     0.200
     0.854     1.275     0.200
     1.547    -2.523     0.200
     1.784    -3.772     0.200
     2.011    -5.409     0.200
     2.551    -8.539     0.200
     3.140   -10.740     0.200
     3.571   -13.149     0.200
     3.673   -15.688     0.200
     3.260   -14.184     0.200
     3.424   -11.962     0.200
     3.514   -16.498     0.200
     3.744   -16.815     0.200
     0.876     1.313     0.200
     0.901     1.917     0.200
     0.901     2.409     0.200
     2.534    -9.198     0.200
     3.144   -11.689     0.200
     3.144   -14.275     0.200
     3.509   -13.917     0.200
     3.650   -14.710     0.200
     0.900     1.791     0.200
     1.953    -6.518     0.200
     1.983    -4.831     0.200
     3.189   -10.800     0.200
     3.685   -13.835     0.200
     0.555     1.727     0.200
     1.949    -6.862     0.200
     2.597   -14.541     0.200
     3.205   -11.663     0.200
     3.685   -15.248     0.200
     3.685   -16.389     0.200
     3.712   -15.077     0.200
     0.529     2.962     0.200
     1.926    -4.649     0.200
     2.625    -9.572     0.200
     2.625   -11.033     0.200
     3.232   -13.102     0.200
     3.459   -13.262     0.200
     3.546   -18.394     0.200
     3.550   -13.126     0.200
     3.709   -16.226     0.200
     3.740   -14.190     0.200
     1.901    -5.706     0.200
     1.958    -7.552     0.200
     3.185   -14.393     0.200
     3.499   -14.897     0.200
     3.500   -14.563     0.200
     3.590   -18.963     0.200
     3.647   -14.569     0.200
     3.681   -15.217     0.200
     1.434    -2.758     0.200
     1.897    -6.887     0.200
     1.974    -8.139     0.200
     2.598    -7.729     0.200
     3.192   -14.204     0.200
     3.503   -19.772     0.200
     3.704   -13.742     0.200
     3.717   -14.400     0.200
     1.892    -4.785     0.200
     1.948    -6.944     0.200
     2.576    -7.786     0.200
     3.195   -11.983     0.200
     3.490   -15.777     0.200
     3.653   -13.291     0.200
     5.009   -22.318     0.200
     1.924    -7.164     0.200
     1.990    -7.285     0.200
     2.560    -8.218     0.200
     2.560    -8.968     0.200
     2.827    -9.685     0.200
     2.827   -12.605     0.200
     3.163   -13.422     0.200
     3.163   -13.932     0.200
     3.526   -13.956     0.200
     3.660   -14.972     0.200
     3.677   -16.317     0.200
     3.977   -16.325     0.200
     5.015   -23.916     0.200
     7.988   -50.575     0.200
     1.938    -9.053     0.200
     2.010   -10.005     0.200
     2.804   -12.544     0.200
     2.880   -16.368     0.200
     3.150   -14.556     0.200
     3.150   -15.044     0.200
     3.557   -13.812     0.200
     3.669   -15.759     0.200
     3.675   -17.951     0.200
     7.664   -43.911     0.200
     8.009   -46.573     0.200
     1.905    -5.748     0.200
     3.699   -13.899     0.200
     1.946    -8.042     0.200
     2.580    -8.458     0.200
     3.197   -13.367     0.200
     3.693   -14.418     0.200
     4.010   -15.400     0.200
     0.927     0.911     0.200
     1.391    -1.522     0.200
     1.452    -2.918     0.200
     1.692    -3.484     0.200
     1.874    -4.855     0.200
     1.874    -5.804     0.200
     1.935    -8.080     0.200
     2.598    -6.788     0.200
     2.598   -10.148     0.200
     2.882    -8.422     0.200
     2.882    -8.704     0.200
     3.212   -17.241     0.200
     3.517   -12.234     0.200
     3.676   -16.950     0.200
     3.712   -14.036     0.200
     4.399   -18.816     0.200
     1.863    -5.130     0.200
     1.914    -7.225     0.200
     2.597   -11.553     0.200
     3.480   -14.190     0.200
     3.548   -16.981     0.200
     5.014   -28.050     0.200
     0.895     0.815     0.200
     1.890    -4.868     0.200
     1.942    -6.655     0.200
     2.574   -10.211     0.200
     2.880   -11.781     0.200
     3.197   -13.419     0.200
     3.485   -13.295     0.200
     3.576   -15.218     0.200
     3.686   -13.108     0.200
     4.010   -14.296     0.200
     0.475     2.401     0.200
     0.474     2.417     0.200
     0.543     0.746     0.200
     0.717     0.186     0.200
     1.590    -4.741     0.200
     2.099    -8.274     0.200
     2.096    -9.173     0.200
     0.734     2.672     0.200
     0.727     0.891     0.200
     0.830     0.404     0.200
     1.165    -1.499     0.200
     1.727    -4.792     0.200
     3.184   -14.083     0.200
     1.900    -5.698     0.200
     1.954    -7.213     0.200
     2.567    -9.932     0.200
     2.867   -11.201     0.200
     2.867   -14.011     0.200
     3.186   -13.849     0.200
     3.493   -14.176     0.200
     3.680   -13.794     0.200
     3.841   -15.775     0.200
     4.827   -22.754     0.200
     0.984    -2.784     0.200
     1.914    -6.292     0.200
     1.956    -6.136     0.200
     3.224   -12.612     0.200
     3.708   -13.758     0.200
     0.567     1.599     0.200
     1.899    -6.068     0.200
     2.614   -10.532     0.200
     3.240   -11.448     0.200
     3.487   -19.315     0.200
     3.671   -16.097     0.200
     3.723   -14.581     0.200
     1.494    -3.668     0.200
     1.920    -5.650     0.200
     1.985    -7.351     0.200
     1.995    -4.720     0.200
     1.995    -5.590     0.200
     2.563    -6.851     0.200
     2.832   -11.628     0.200
     3.167   -10.479     0.200
     3.167   -11.939     0.200
     3.530   -18.543     0.200
     3.660   -12.675     0.200
     3.809   -13.004     0.200
     4.349   -18.890     0.200
     1.530    -4.308     0.200
     1.941    -5.478     0.200
     1.941    -6.718     0.200
     2.007    -5.854     0.200
     2.007    -8.675     0.200
     2.013    -9.668     0.200
     2.554    -9.163     0.200
     3.148   -11.610     0.200
     3.558   -15.419     0.200
     3.558   -17.659     0.200
     3.637   -20.626     0.200
     3.668   -16.899     0.200
     3.673   -15.721     0.200
     4.450   -20.454     0.200
     8.782   -53.880     0.200
     1.470    -2.730     0.200
     1.707    -4.089     0.200
     1.906    -4.551     0.200
     1.906    -5.930     0.200
     1.966    -8.272     0.200
     1.987    -6.697     0.200
     2.569    -8.798     0.200
     3.181   -10.017     0.200
     3.181   -12.357     0.200
     3.655   -15.649     0.200
     3.655   -18.117     0.200
     3.683   -14.089     0.200
     3.829   -15.354     0.200
     3.994   -15.854     0.200
     4.370   -19.861     0.200
     4.814   -22.375     0.200
     5.010   -26.492     0.200
     5.608   -27.109     0.200
     5.616   -30.506     0.200
     1.888    -5.351     0.200
     1.939    -7.808     0.200
     1.981    -5.372     0.200
     3.198   -14.691     0.200
     3.198   -13.141     0.200
     3.642   -14.929     0.200
     3.685   -18.008     0.200
     4.011   -16.869     0.200
     4.843   -23.944     0.200
     0.847     0.718     0.200
     1.590    -3.111     0.200
     1.835    -4.532     0.200
     1.893    -4.254     0.200
     1.928    -4.211     0.200
     3.207   -15.684     0.200
     3.670   -17.719     0.200
     3.785   -15.139     0.200
     3.769   -12.857     0.200
     0.859     0.938     0.200
     0.859     1.668     0.200
     3.194   -10.717     0.200
     3.632   -16.319     0.200
     3.749   -14.541     0.200
     3.742   -13.125     0.200
     3.795   -15.426     0.200
     0.822     1.423     0.200
     1.622    -3.746     0.200
     2.648   -15.014     0.200
     3.200   -10.984     0.200
     3.200   -12.062     0.200
     3.700   -21.280     0.200
     3.775   -14.929     0.200
     3.802   -14.650     0.200
     3.802   -15.095     0.200
     4.750   -23.039     0.200
     5.153   -30.769     0.200
     1.900    -5.820     0.200
     1.959    -7.944     0.200
     1.983    -5.790     0.200
     2.573   -12.352     0.200
     2.860    -9.633     0.200
     3.186   -13.913     0.200
     3.509   -17.598     0.200
     3.656   -23.157     0.200
     3.687   -16.487     0.200
     5.012   -27.778     0.200
     0.571     1.391     0.200
     1.926    -6.623     0.200
     1.993    -7.612     0.200
     1.998    -9.375     0.200
     2.567   -10.826     0.200
     2.868   -15.184     0.200
     3.163   -15.978     0.200
     3.557   -18.085     0.200
     3.677   -19.070     0.200
     3.686   -15.307     0.200
     5.031   -28.996     0.200
     5.595   -32.523     0.200
     5.919   -31.489     0.200
     0.947    -0.059     0.200
     1.700    -5.139     0.200
     1.861    -3.831     0.200
     1.861    -3.612     0.200
     1.928    -5.590     0.200
     1.940    -4.822     0.200
     1.940    -4.424     0.200
     2.616    -7.951     0.200
     3.226   -13.129     0.200
     3.463   -16.496     0.200
     3.535   -16.253     0.200
     3.554   -14.551     0.200
     3.698   -16.891     0.200
     4.039   -13.693     0.200
     4.404   -18.341     0.200
     4.847   -21.230     0.200
     5.985   -33.840     0.200
     1.900    -6.627     0.200
     1.958    -8.033     0.200
     1.984    -8.484     0.200
     3.186   -14.451     0.200
     3.499   -16.287     0.200
     3.506   -17.108     0.200
     3.685   -16.836     0.200
     1.162    -1.654     0.200
     2.572    -6.550     0.200
     3.033    -8.589     0.200
     3.033   -14.519     0.200
     3.266   -12.260     0.200
     3.266   -12.869     0.200
     3.406    -9.959     0.200
     3.533   -10.818     0.200
     3.660   -11.574     0.200
     4.075   -13.483     0.200
     4.991   -22.216     0.200
     4.894   -18.792     0.200
     5.663   -28.340     0.200
     1.880    -3.842     0.200
     1.880    -5.462     0.200
     1.955    -4.097     0.200
     1.955    -5.298     0.200
     1.948    -7.200     0.200
     2.602    -6.941     0.200
     2.602   -11.142     0.200
     3.208   -13.788     0.200
     3.208   -15.538     0.200
     3.483   -15.662     0.200
     3.542   -20.228     0.200
     7.998   -44.525     0.200
     1.916    -6.869     0.200
     1.943    -7.258     0.200
     2.782   -12.602     0.200
     2.902    -9.989     0.200
     3.230   -12.749     0.200
     3.230   -13.980     0.200
     3.455   -16.970     0.200
     3.510   -16.488     0.200
     3.725   -15.841     0.200
     1.943    -5.143     0.200
     2.601   -13.532     0.200
     2.872   -12.208     0.200
     3.210   -16.636     0.200
     3.479   -14.699     0.200
     3.532   -14.726     0.200
     3.686   -21.036     0.200
     3.716   -13.676     0.200
     5.042   -25.651     0.200
     5.639   -35.885     0.200
     7.989   -43.459     0.200
     1.920    -6.195     0.200
     1.993    -7.034     0.200
     2.565   -10.010     0.200
     3.523   -18.713     0.200
     3.539   -17.338     0.200
     3.614   -13.750     0.200
     0.923     1.056     0.200
     1.502    -2.488     0.200
     1.740    -3.070     0.200
     1.982    -4.308     0.200
     1.982    -5.621     0.200
     3.693   -13.726     0.200
     4.418   -14.063     0.200
     0.914    -0.215     0.200
     1.482    -2.865     0.200
     1.921    -7.047     0.200
     2.001    -4.665     0.200
     2.001    -6.478     0.200
     2.555   -10.322     0.200
     2.846   -10.284     0.200
     2.838    -8.450     0.200
     3.165   -10.235     0.200
     3.521   -13.232     0.200
     3.514   -18.214     0.200
     3.611   -18.881     0.200
     3.647   -13.989     0.200
     3.671   -14.529     0.200
     3.979   -13.749     0.200
     4.416   -24.105     0.200
     7.968   -48.184     0.200
     0.925     0.956     0.200
     0.911     2.402     0.200
     0.911     2.120     0.200
     1.492    -2.271     0.200
     1.731    -3.343     0.200
     1.903    -3.565     0.200
     1.971    -6.533     0.200
     1.976    -4.649     0.200
     1.976    -4.501     0.200
     2.582    -9.903     0.200
     2.844   -10.155     0.200
     3.185   -10.092     0.200
     3.506   -12.340     0.200
     3.542   -16.318     0.200
     3.597   -13.080     0.200
     1.096    -1.415     0.200
     1.300    -1.555     0.200
     1.712    -3.108     0.200
     1.977    -4.313     0.200
     1.998    -4.881     0.200
     2.155    -6.579     0.200
     3.504   -13.343     0.200
     1.868    -4.817     0.200
     1.924    -6.673     0.200
     1.958    -4.696     0.200
     2.895   -11.966     0.200
     3.218   -14.261     0.200
     3.466   -14.654     0.200
     3.497   -15.374     0.200
     3.665   -15.384     0.200
     3.708   -13.668     0.200
     5.022   -26.351     0.200
     5.643   -24.618     0.200
     0.631     3.054     0.200
     0.890     0.428     0.200
     3.267   -11.566     0.200
     3.390   -16.418     0.200
     3.617   -16.077     0.200
     3.617   -16.237     0.200
     3.707   -16.504     0.200
     4.977   -24.346     0.200
     2.005    -7.339     0.200
     2.016    -9.166     0.200
     2.798   -10.717     0.200
     3.547   -14.766     0.200
     3.677   -14.954     0.200
     3.639   -16.893     0.200
     0.908     0.530     0.200
     1.496    -2.255     0.200
     1.985    -7.866     0.200
     1.994    -5.590     0.200
     2.564   -11.272     0.200
     2.831    -8.979     0.200
     3.522   -11.187     0.200
     3.612   -12.112     0.200
     3.681   -15.155     0.200
     0.515     1.414     0.200
     1.951    -5.650     0.200
     1.987    -7.768     0.200
     3.194   -12.714     0.200
     3.508   -13.827     0.200
     3.614   -16.826     0.200
     3.736   -16.074     0.200
     5.090   -24.119     0.200
     1.780    -5.214     0.200
     1.916    -6.298     0.200
     1.974    -5.942     0.200
     1.998    -8.206     0.200
     2.589   -11.107     0.200
     3.175   -13.936     0.200
     3.524   -15.525     0.200
     3.590   -14.665     0.200
     3.708   -15.695     0.200
     5.061   -23.246     0.200
     1.743    -5.710     0.200
     2.597    -9.035     0.200
     2.845    -9.743     0.200
     3.499   -11.543     0.200
     3.562   -12.606     0.200
     3.698   -14.624     0.200
     5.053   -25.793     0.200
     5.626   -28.070     0.200
     0.516     1.670     0.200
     1.460    -4.146     0.200
     1.524    -4.288     0.200
     1.766    -5.462     0.200
     1.968    -7.885     0.200
     2.619   -13.967     0.200
     2.843   -14.454     0.200
     3.207   -14.421     0.200
     3.493   -13.807     0.200
     3.595   -15.169     0.200
     3.730   -18.098     0.200
     5.084   -26.846     0.200
     5.642   -33.829     0.200
     0.966    -2.163     0.200
     1.928    -6.516     0.200
     2.627   -10.810     0.200
     3.240   -10.279     0.200
     3.448   -11.576     0.200
     0.540     1.656     0.200
     1.964    -8.287     0.200
     3.716   -17.012     0.200
     4.419   -23.045     0.200
     0.908     1.579     0.200
     0.908     2.118     0.200
     0.910     1.148     0.200
     1.915    -5.301     0.200
     1.980    -6.474     0.200
     1.990    -5.628     0.200
     2.567   -12.161     0.200
     2.836   -11.795     0.200
     3.684   -16.572     0.200
     0.563     1.361     0.200
     1.512    -3.683     0.200
     1.915    -5.160     0.200
     1.983    -5.202     0.200
     1.983    -6.182     0.200
     2.577    -9.155     0.200
     2.827   -13.898     0.200
     3.519   -14.272     0.200
     3.557   -14.006     0.200
     3.683   -13.821     0.200
     3.695   -16.837     0.200
     5.037   -19.975     0.200
     0.858     0.602     0.200
     0.858     0.902     0.200
     1.794    -4.177     0.200
     1.935    -6.664     0.200
     1.993    -7.351     0.200
     2.015    -7.720     0.200
     2.570    -8.818     0.200
     2.798    -8.375     0.200
     3.156   -14.077     0.200
     3.542   -15.433     0.200
     3.585   -13.632     0.200
     3.634   -19.752     0.200
     3.693   -13.081     0.200
     3.691   -17.277     0.200
     5.046   -25.848     0.200
     5.591   -22.712     0.200
     5.908   -25.245     0.200
     7.677   -42.759     0.200
     8.038   -44.433     0.200
     0.926     0.736     0.200
     2.889   -10.136     0.200
     3.150   -12.035     0.200
     3.575   -22.353     0.200
     3.546   -11.421     0.200
     3.683   -11.567     0.200
     1.917    -6.473     0.200
     1.981    -8.499     0.200
     1.992    -8.769     0.200
     2.579   -10.950     0.200
     3.172   -17.113     0.200
     3.522   -14.840     0.200
     3.567   -18.641     0.200
     3.690   -18.139     0.200
     5.044   -22.585     0.200
     1.930    -7.146     0.200
     2.602   -11.318     0.200
     3.218   -14.179     0.200
     3.469   -15.289     0.200
     3.515   -17.122     0.200
     5.035   -24.088     0.200
     1.422    -2.217     0.200
     1.942    -6.741     0.200
     2.018    -8.853     0.200
     2.004    -5.989     0.200
     2.558   -11.699     0.200
     3.147   -13.241     0.200
     3.571   -12.890     0.200
     3.548   -18.416     0.200
     3.678   -17.348     0.200
     5.031   -24.302     0.200
     0.881    -2.366     0.200
     1.923    -6.128     0.200
     1.997    -8.826     0.200
     1.989    -6.274     0.200
     1.989    -5.963     0.200
     2.572   -14.073     0.200
     3.563   -17.192     0.200
     3.683   -23.969     0.200
     3.691   -14.410     0.200
     5.037   -29.302     0.200
     0.647     2.836     0.200
     1.404    -3.092     0.200
     1.637    -3.729     0.200
     1.911    -5.228     0.200
     1.911    -5.431     0.200
     2.017    -5.464     0.200
     3.501   -16.271     0.200
     7.884   -40.545     0.200
     8.725   -50.486     0.200
     0.633     1.127     0.200
     1.061    -1.986     0.200
     2.592   -12.435     0.200
     3.246   -16.790     0.200
     3.398   -15.018     0.200
     3.428   -14.780     0.200
     3.516   -16.014     0.200
     0.928     1.406     0.200
     1.758    -3.890     0.200
     1.805    -5.040     0.200
     1.920    -4.162     0.200
     1.920    -3.971     0.200
     1.986    -4.655     0.200
     3.169   -12.540     0.200
     3.525   -12.269     0.200
     1.643    -4.949     0.200
     3.486   -13.114     0.200
     1.908    -4.751     0.200
     1.816    -4.650     0.200
     1.977    -6.692     0.200
     1.979    -6.757     0.200
     2.581    -7.826     0.200
     3.512   -15.847     0.200
     1.896    -5.900     0.200
     1.968    -6.115     0.200
     1.967    -8.174     0.200
     3.549   -22.379     0.200
     3.707   -15.637     0.200
     8.004   -46.442     0.200
     1.949    -4.726     0.200
     1.949    -7.196     0.200
     2.003    -5.169     0.200
     2.003    -8.989     0.200
     3.685   -13.965     0.200
     0.932    -0.840     0.200
     1.888    -5.193     0.200
     1.952    -7.008     0.200
     2.591    -9.874     0.200
     3.199   -15.728     0.200
     3.489   -13.000     0.200
     3.529   -16.414     0.200
     3.678   -17.272     0.200
     3.706   -14.953     0.200
     5.034   -26.974     0.200
     7.985   -43.646     0.200
     8.802   -52.217     0.200
     1.917    -5.834     0.200
     1.987    -8.533     0.200
     1.987    -5.836     0.200
     2.572   -10.962     0.200
     2.856   -15.392     0.200
     2.856   -11.842     0.200
     3.171   -14.216     0.200
     3.549   -21.971     0.200
     3.611   -16.959     0.200
     3.676   -17.274     0.200
     3.690   -16.627     0.200
     5.031   -28.514     0.200
     5.603   -23.803     0.200
     5.928   -29.752     0.200
     7.707   -45.248     0.200
     8.003   -45.622     0.200
    10.929   -70.326     0.200
    12.070   -71.832     0.200
    12.243   -82.496     0.200
    12.875   -82.812     0.200
    13.606   -82.652     0.200
    14.686   -90.685     0.200
    14.692   -95.234     0.200
     1.935    -7.495     0.200
     2.010    -9.348     0.200
     1.997    -6.150     0.200
     2.564   -11.183     0.200
     3.155   -12.210     0.200
     3.570   -17.406     0.200
     3.682   -20.533     0.200
     3.685   -15.431     0.200
     5.589   -36.216     0.200
     7.672   -44.776     0.200
     8.023   -46.058     0.200
     1.946    -6.198     0.200
     2.004    -8.248     0.200
     2.025    -8.710     0.200
     2.560   -10.217     0.200
     3.145   -12.582     0.200
     3.583   -17.856     0.200
     3.685   -14.161     0.200
     5.038   -27.001     0.200
     5.580   -30.302     0.200
     0.895     1.714     0.200
     0.915     1.335     0.200
     1.921    -5.596     0.200
     1.990    -5.518     0.200
     1.992    -5.684     0.200
     2.567    -6.836     0.200
     2.826   -12.100     0.200
     3.167   -14.167     0.200
     3.524   -13.490     0.200
     3.544   -16.453     0.200
     3.670   -12.348     0.200
     3.981   -12.833     0.200
     5.024   -22.749     0.200
     5.598   -27.392     0.200
     7.998   -44.244     0.200
     0.595     1.523     0.200
     2.683   -12.389     0.200
     3.347   -12.166     0.200
     3.347   -17.396     0.200
     3.397   -13.583     0.200
     3.414   -15.238     0.200
     3.669   -18.772     0.200
     3.779   -15.666     0.200
     1.762    -6.725     0.200
     1.792    -6.258     0.200
     1.888    -7.046     0.200
     3.347   -16.200     0.200
     3.435   -18.623     0.200
     3.328   -12.935     0.200
     3.328   -17.455     0.200
     3.770   -16.454     0.200
     1.447    -3.059     0.200
     1.685    -3.959     0.200
     1.884    -4.678     0.200
     1.884    -5.107     0.200
     1.941    -6.635     0.200
     1.970    -4.484     0.200
     2.585   -12.218     0.200
     2.805   -14.120     0.200
     2.878    -8.762     0.200
     3.202   -13.352     0.200
     3.202   -15.579     0.200
     3.482   -15.336     0.200
     3.502   -20.617     0.200
     3.572   -14.993     0.200
     3.660   -13.168     0.200
     3.660   -20.230     0.200
     3.698   -13.986     0.200
     4.016   -14.798     0.200
     4.395   -19.799     0.200
     5.017   -26.918     0.200
     7.959   -47.815     0.200
     8.845   -48.051     0.200
     0.581     1.907     0.200
     1.940    -9.985     0.200
     1.972    -6.271     0.200
     2.583    -8.419     0.200
     3.202   -12.505     0.200
     3.482   -20.923     0.200
     3.572   -18.967     0.200
     3.656   -19.815     0.200
     0.890    -1.548     0.200
     1.511    -4.903     0.200
     1.749    -5.150     0.200
     1.993    -5.795     0.200
     2.567    -8.117     0.200
     3.165   -11.138     0.200
     0.566     1.248     0.200
     1.489    -3.674     0.200
     1.728    -4.611     0.200
     1.903    -6.484     0.200
     1.970    -7.690     0.200
     1.977    -7.321     0.200
     2.581   -14.521     0.200
     3.185   -12.443     0.200
     3.538   -13.117     0.200
     5.031   -25.703     0.200
     5.615   -32.047     0.200
     1.882    -5.000     0.200
     1.960    -6.437     0.200
     2.596    -9.847     0.200
     3.205   -11.350     0.200
     3.484   -13.666     0.200
     3.532   -13.319     0.200
     3.683   -14.549     0.200
     3.683   -21.049     0.200
     3.711   -14.246     0.200
     5.039   -24.210     0.200
     5.634   -29.101     0.200
     0.945    -0.545     0.200
     1.879    -6.315     0.200
     1.949    -4.713     0.200
     1.952    -5.303     0.200
     3.209    -9.921     0.200
     3.573   -17.703     0.200
     3.698   -14.342     0.200
     3.698   -18.413     0.200
     3.722   -13.901     0.200
     8.005   -44.102     0.200
     0.824     1.260     0.200
     1.929    -5.746     0.200
     2.016    -6.945     0.200
     2.650   -11.142     0.200
     2.793   -11.795     0.200
     3.202   -12.111     0.200
     3.614   -18.654     0.200
     3.777   -14.954     0.200
     0.571     1.938     0.200
     1.929    -7.046     0.200
     2.003    -8.652     0.200
     1.995   -10.067     0.200
     2.565   -10.349     0.200
     3.561   -18.057     0.200
     3.534   -17.845     0.200
     5.592   -26.686     0.200
     1.559    -5.267     0.200
     1.799    -6.172     0.200
     1.925    -6.943     0.200
     2.011    -7.766     0.200
     2.588   -12.759     0.200
     2.800   -12.025     0.200
     3.168   -11.313     0.200
     3.168   -14.353     0.200
     3.534   -12.930     0.200
     3.626   -17.204     0.200
     3.606   -12.899     0.200
     3.710   -14.073     0.200
     3.715   -16.812     0.200
     1.933    -6.218     0.200
     1.991    -6.105     0.200
     1.991    -5.986     0.200
     2.012    -9.077     0.200
     2.571   -11.022     0.200
     2.801   -10.434     0.200
     3.158   -12.634     0.200
     3.540   -14.832     0.200
     3.631   -15.320     0.200
     1.964    -5.995     0.200
     2.011    -4.868     0.200
     2.862   -13.145     0.200
     3.169   -11.784     0.200
     3.511   -13.719     0.200
     3.466   -15.169     0.200
     3.614   -16.542     0.200
     4.971   -30.212     0.200
     5.592   -29.534     0.200
     7.655   -41.423     0.200
     8.808   -47.427     0.200
     1.900    -5.615     0.200
     1.900    -6.385     0.200
     1.972    -8.603     0.200
     2.590   -11.681     0.200
     2.842   -14.900     0.200
     3.189   -15.769     0.200
     3.504   -15.274     0.200
     3.556   -17.899     0.200
     3.595   -18.904     0.200
     1.107    -0.256     0.200
     1.550    -2.334     0.200
     2.882    -7.722     0.200
     3.136   -15.906     0.200
     3.912   -12.349     0.200
     4.190   -15.952     0.200
     0.627     1.865     0.200
     0.975    -1.092     0.200
     1.312    -1.993     0.200
     3.349   -12.751     0.200
     3.805   -15.480     0.200
     1.753    -4.505     0.200
     1.752    -4.316     0.200
     1.908    -4.232     0.200
     1.908    -4.902     0.200
     3.322   -14.928     0.200
     3.325   -10.496     0.200
     3.408   -13.227     0.200
     3.349   -14.284     0.200
     3.752   -15.112     0.200
     4.980   -30.243     0.200
     0.694     2.452     0.200
     1.762    -4.281     0.200
     1.771    -4.001     0.200
     1.934    -4.903     0.200
     1.953    -6.300     0.200
     2.594   -11.411     0.200
     2.612   -10.954     0.200
     3.336   -13.940     0.200
     3.293   -11.257     0.200
     3.336   -13.941     0.200
     3.728   -12.451     0.200
     4.950   -26.706     0.200
     7.752   -39.128     0.200
     0.654     1.508     0.200
     1.741    -5.267     0.200
     1.896    -5.564     0.200
     1.896    -7.494     0.200
     3.310   -13.200     0.200
     3.329   -13.810     0.200
     3.362   -13.499     0.200
     3.629   -13.971     0.200
     4.991   -28.912     0.200
     0.616     1.965     0.200
     1.371    -2.494     0.200
     1.608    -3.656     0.200
     1.860    -4.880     0.200
     1.897    -6.851     0.200
     1.970    -6.010     0.200
     1.025    -0.567     0.200
     2.648   -12.226     0.200
     3.291   -20.002     0.200
     3.278   -11.690     0.200
     0.743     0.959     0.200
     2.960   -16.546     0.200
     3.066   -13.479     0.200
     3.266   -14.549     0.200
     4.022   -17.385     0.200
     0.734     0.954     0.200
     3.271   -14.685     0.200
     0.661     0.909     0.200
     0.661     1.714     0.200
     1.739    -5.142     0.200
     1.899    -5.840     0.200
     3.362   -16.556     0.200
     1.233    -1.933     0.200
     1.474    -2.324     0.200
     1.762    -3.966     0.200
     1.762    -4.095     0.200
     1.773    -5.163     0.200
     1.907    -4.833     0.200
     2.659    -7.639     0.200
     2.659   -10.269     0.200
     3.338   -11.523     0.200
     3.354   -15.325     0.200
     3.335   -11.433     0.200
     3.335   -15.573     0.200
     3.424   -13.277     0.200
     3.751   -15.092     0.200
     1.735    -4.937     0.200
     3.300   -14.175     0.200
     3.354   -12.762     0.200
     3.372   -14.518     0.200
     0.871     1.161     0.200
     1.302    -2.899     0.200
     1.399    -1.834     0.200
     1.683    -3.795     0.200
     1.683    -4.060     0.200
     2.106    -5.405     0.200
     2.899    -9.957     0.200
     2.977   -12.717     0.200
     3.027   -11.180     0.200
     3.180   -14.154     0.200
     3.788   -15.744     0.200
     7.637   -39.655     0.200
     0.733     1.385     0.200
     1.392    -2.950     0.200
     2.225    -8.204     0.200
     2.975   -12.724     0.200
     3.279   -12.459     0.200
     0.731     1.097     0.200
     1.686    -5.121     0.200
     2.301    -9.603     0.200
     2.995   -12.710     0.200
     2.951   -10.804     0.200
     3.078   -14.645     0.200
     3.274   -15.579     0.200
     1.722    -4.641     0.200
     1.722    -4.255     0.200
     3.108   -12.289     0.200
     2.917   -13.312     0.200
     0.630     1.083     0.200
     1.522    -4.415     0.200
     1.802    -5.977     0.200
     1.821    -8.140     0.200
     1.934    -5.492     0.200
     1.934    -8.011     0.200
     2.668   -12.977     0.200
     2.626    -8.714     0.200
     2.626    -9.175     0.200
     3.382   -19.537     0.200
     3.291   -13.463     0.200
     3.379   -14.886     0.200
     3.469   -18.063     0.200
     4.983   -23.572     0.200
     5.701   -28.557     0.200
     7.840   -44.641     0.200
     8.776   -51.210     0.200
     8.916   -49.464     0.200
     0.639     1.168     0.200
     1.765    -4.769     0.200
     1.765    -5.608     0.200
     1.775    -6.485     0.200
     1.910    -7.499     0.200
     2.656   -12.938     0.200
     3.065   -13.498     0.200
     3.354   -14.918     0.200
     3.427   -17.771     0.200
     7.817   -43.526     0.200
     8.790   -51.285     0.200
     0.598     1.407     0.200
     1.792    -6.500     0.200
     1.822    -7.560     0.200
     1.915    -6.631     0.200
     2.643    -9.495     0.200
     3.378   -13.195     0.200
     3.465   -17.189     0.200
     7.875   -44.792     0.200
     8.802   -52.938     0.200
     0.632     3.075     0.200
     1.224    -0.885     0.200
     1.746    -2.939     0.200
     1.757    -4.233     0.200
     1.893    -3.719     0.200
     1.893    -4.066     0.200
     2.674    -7.706     0.200
     3.356   -12.436     0.200
     3.350   -12.839     0.200
     3.642   -15.114     0.200
     3.766   -14.516     0.200
     5.003   -24.723     0.200
     1.145    -1.488     0.200
     1.776    -5.973     0.200
     1.892    -5.312     0.200
     2.670   -11.747     0.200
     3.337   -17.634     0.200
     3.385   -14.790     0.200
     3.337   -14.373     0.200
     3.424   -18.433     0.200
     8.813   -54.063     0.200
     3.344   -12.488     0.200
     3.329   -15.041     0.200
     1.169    -1.128     0.200
     1.730    -4.733     0.200
     1.737    -3.583     0.200
     1.737    -4.023     0.200
     1.902    -5.332     0.200
     7.769   -41.147     0.200
     1.236    -1.233     0.200
     1.718    -4.641     0.200
     1.726    -3.073     0.200
     1.726    -3.594     0.200
     1.892    -4.989     0.200
     3.291   -13.763     0.200
     3.305   -11.874     0.200
     3.381   -10.567     0.200
     1.029    -1.557     0.200
     1.615    -4.393     0.200
     1.887    -5.873     0.200
     2.648   -10.040     0.200
     2.727   -11.473     0.200
     3.295   -15.931     0.200
     1.406    -4.734     0.200
     2.237    -8.006     0.200
     2.989   -11.062     0.200
     3.071   -11.661     0.200
     3.270   -11.972     0.200
     0.780     1.987     0.200
     0.886     1.198     0.200
     1.144    -1.999     0.200
     1.732    -4.572     0.200
     2.002    -7.912     0.200
     2.718   -12.302     0.200
     7.830   -38.128     0.200
     0.560     2.630     0.200
     0.589     1.075     0.200
     0.646     1.224     0.200
     0.773     0.517     0.200
     0.773     1.356     0.200
     0.835     0.727     0.200
     2.173    -9.066     0.200
     3.148   -13.200     0.200
     4.282   -23.366     0.200
     5.602   -30.807     0.200
     3.060   -10.316     0.200
     3.178    -9.725     0.200
     0.828     2.270     0.200
     1.563    -3.632     0.200
     3.135   -13.202     0.200
     3.900   -13.026     0.200
     0.822     0.628     0.200
     0.822     1.400     0.200
     1.196    -2.085     0.200
     1.545    -3.310     0.200
     2.783    -9.543     0.200
     2.864   -11.492     0.200
     3.151   -12.328     0.200
     0.528     2.290     0.200
     0.564     0.834     0.200
     0.677     0.509     0.200
     0.677     1.943     0.200
     0.802     1.120     0.200
     0.802     0.920     0.200
     0.798    -0.249     0.200
     0.798     1.333     0.200
     0.498     2.467     0.200
     0.699     0.308     0.200
     0.699     1.647     0.200
     2.116    -7.854     0.200
     0.625     3.664     0.200
     0.744     1.235     0.200
     1.578    -3.132     0.200
     0.771     2.207     0.200
     1.067    -2.237     0.200
     1.302    -1.322     0.200
     1.344    -1.647     0.200
     1.464    -2.073     0.200
     2.155    -8.267     0.200
     3.137   -14.332     0.200
     0.528     1.574     0.200
     0.565     1.128     0.200
     0.676     1.615     0.200
     1.567    -4.696     0.200
     2.141    -7.315     0.200
     3.166   -12.332     0.200
     3.886   -20.672     0.200
     4.311   -23.198     0.200
     4.735   -25.846     0.200
     5.630   -28.927     0.200
     7.041   -41.516     0.200
     9.247   -54.028     0.200
     9.513   -57.555     0.200
    11.863   -82.858     0.200
     0.680     1.969     0.200
     0.792     0.884     0.200
     0.792     1.525     0.200
     0.792     1.799     0.200
     1.331    -2.232     0.200
     1.539    -2.925     0.200
     0.726     2.227     0.200
     0.888     1.752     0.200
     0.894     2.670     0.200
     0.710     1.216     0.200
     0.813     0.648     0.200
     1.296    -1.815     0.200
     1.464    -2.769     0.200
     1.505    -2.927     0.200
     3.167   -13.552     0.200
     3.167   -13.162     0.200
     0.500     2.998     0.200
     0.500     4.148     0.200
     0.688     1.291     0.200
     0.688     2.541     0.200
     0.799     1.003     0.200
     0.799     1.123     0.200
     0.951    -0.470     0.200
     0.796     1.358     0.200
     1.732    -5.491     0.200
     2.869    -9.489     0.200
     3.142   -11.608     0.200
     3.263   -17.601     0.200
     5.256   -26.366     0.200
     6.266   -32.065     0.200
     0.738     2.354     0.200
     1.614    -5.668     0.200
     2.275    -7.228     0.200
     2.335    -6.942     0.200
     3.083    -9.552     0.200
     0.402     2.006     0.200
     0.402     2.865     0.200
     2.003    -6.567     0.200
     2.053    -8.118     0.200
     0.593     1.717     0.200
     0.780     1.145     0.200
     0.780     1.786     0.200
     1.013    -0.386     0.200
     1.251    -1.226     0.200
     1.520    -4.905     0.200
     0.724     2.123     0.200
     0.784     1.222     0.200
     1.008    -1.430     0.200
     1.520    -4.988     0.200
     2.214   -10.609     0.200
     2.277    -9.832     0.200
     3.178   -12.969     0.200
     5.550   -25.043     0.200
     0.653     2.555     0.200
     0.774     1.125     0.200
     1.335    -2.274     0.200
     1.524    -4.055     0.200
     2.240    -8.146     0.200
     2.304    -9.012     0.200
     0.588     1.127     0.200
     0.588     2.318     0.200
     0.657     0.338     0.200
     0.656     0.340     0.200
     0.656     0.148     0.200
     0.783     0.855     0.200
     0.783     0.956     0.200
     0.769     0.705     0.200
     0.768     1.128     0.200
     1.013    -1.822     0.200
     1.350    -3.458     0.200
     1.817    -5.530     0.200
     2.248   -12.887     0.200
     2.312   -11.911     0.200
     2.354    -9.901     0.200
     2.440    -8.473     0.200
     0.539     2.248     0.200
     0.696     0.879     0.200
     0.685     2.144     0.200
     0.685     1.720     0.200
     1.099    -1.882     0.200
     1.622    -5.345     0.200
     1.622    -6.588     0.200
     2.236    -7.753     0.200
     2.294    -7.483     0.200
     0.616     1.140     0.200
     0.616     2.050     0.200
     0.616     2.361     0.200
     0.605     1.346     0.200
     0.772     0.660     0.200
     0.772     1.631     0.200
     1.229    -1.623     0.200
     1.436    -2.842     0.200
     1.966    -6.198     0.200
     2.164    -8.550     0.200
     2.224    -6.659     0.200
     7.492   -38.167     0.200
     9.456   -59.252     0.200
     0.623     2.633     0.200
     0.620     2.056     0.200
     0.769     1.273     0.200
     0.769     1.930     0.200
     1.033    -1.243     0.200
     1.567    -4.055     0.200
     1.567    -3.384     0.200
     1.619    -3.491     0.200
     2.156    -7.569     0.200
     2.214    -8.806     0.200
     3.154   -13.104     0.200
     1.228    -1.900     0.200
     1.228    -2.158     0.200
     1.382    -1.905     0.200
     1.480    -3.451     0.200
     1.409    -2.547     0.200
     2.312    -6.911     0.200
     2.815    -9.054     0.200
     2.913    -8.468     0.200
     0.600     2.334     0.200
     0.600     2.787     0.200
     0.621     2.021     0.200
     0.621     2.174     0.200
     0.772     0.783     0.200
     0.772     2.096     0.200
     1.059    -1.059     0.200
     1.030    -1.242     0.200
     1.291    -1.937     0.200
     1.421    -2.661     0.200
     1.563    -3.245     0.200
     1.664    -4.037     0.200
     2.155    -5.452     0.200
     2.214    -6.680     0.200
     2.331    -7.900     0.200
     1.266    -3.449     0.200
     1.266    -4.499     0.200
     2.821   -14.107     0.200
     2.917   -14.919     0.200
     1.015    -0.291     0.200
     1.541    -2.798     0.200
     2.171    -6.980     0.200
     2.232    -9.314     0.200
     1.024    -0.023     0.200
     1.024    -0.780     0.200
     1.199    -1.369     0.200
     1.258    -2.145     0.200
     1.465    -1.858     0.200
     1.547    -3.123     0.200
     2.187    -6.592     0.200
     2.248    -8.871     0.200
     0.758     0.644     0.200
     0.758     1.273     0.200
     0.648     2.250     0.200
     1.039    -1.803     0.200
     2.178    -6.952     0.200
     2.237   -10.193     0.200
     0.597     1.991     0.200
     0.597     2.397     0.200
     0.671     1.389     0.200
     0.762     1.294     0.200
     0.762     0.864     0.200
     1.032    -0.967     0.200
     1.257    -2.868     0.200
     2.191    -8.998     0.200
     2.251    -9.343     0.200
     0.578     2.312     0.200
     0.643     1.559     0.200
     0.675     1.922     0.200
     1.262    -2.932     0.200
     1.578    -2.641     0.200
     1.578    -5.071     0.200
     2.206    -9.815     0.200
     2.265   -10.826     0.200
     3.131   -10.276     0.200
     1.454    -4.967     0.200
     2.927   -12.367     0.200
     3.030   -12.532     0.200
     3.114   -12.059     0.200
     3.310   -15.815     0.200
     3.783   -18.992     0.200
     0.541     2.746     0.200
     1.044    -1.850     0.200
     1.196    -6.202     0.200
     2.100    -9.981     0.200
     2.156   -11.025     0.200
     4.297   -19.012     0.200
     0.462     0.884     0.200
     0.461     0.943     0.200
     0.461     1.613     0.200
     0.639     1.386     0.200
     0.639     1.626     0.200
     1.435    -3.815     0.200
     1.925    -6.326     0.200
     1.978    -7.658     0.200
     3.266   -18.417     0.200
     0.362     2.557     0.200
     0.363     2.572     0.200
     0.464     0.893     0.200
     0.464     0.872     0.200
     0.464     1.402     0.200
     0.956    -2.610     0.200
     1.219    -3.478     0.200
     1.379    -4.479     0.200
     1.429    -4.214     0.200
     1.923    -6.309     0.200
     1.975    -7.891     0.200
     3.264   -18.737     0.200
     0.565     4.209     0.200
     0.725     0.963     0.200
     0.739     1.317     0.200
     0.742     1.521     0.200
     0.743     1.531     0.200
     0.785     0.755     0.200
     0.785     1.107     0.200
     0.785     2.314     0.200
     1.047    -1.318     0.200
     1.198    -1.108     0.200
     0.726     1.357     0.200
     0.759     1.843     0.200
     0.771     0.044     0.200
     0.824    -0.050     0.200
     0.824     1.067     0.200
     0.824     0.489     0.200
     1.123    -1.733     0.200
     0.472     1.077     0.200
     0.658     1.717     0.200
     0.658     1.447     0.200
     1.450    -3.850     0.200
     1.997    -7.601     0.200
     2.105    -8.161     0.200
     2.124    -8.699     0.200
     2.175    -8.958     0.200
     0.379     2.857     0.200
     0.475     1.125     0.200
     0.474     1.062     0.200
     0.913    -1.462     0.200
     1.233    -3.290     0.200
     1.307    -3.926     0.200
     1.442    -4.043     0.200
     1.561    -5.287     0.200
     1.946    -6.853     0.200
     1.941    -6.293     0.200
     1.994    -7.491     0.200
     2.116    -8.340     0.200
     2.101    -7.816     0.200
     2.287    -9.822     0.200
     2.459    -9.863     0.200
     0.497     1.597     0.200
     0.829     1.104     0.200
     0.958    -1.862     0.200
     1.250    -2.249     0.200
     1.293    -2.521     0.200
     1.443    -2.960     0.200
     1.576    -4.957     0.200
     1.960    -5.593     0.200
     2.013    -7.623     0.200
     0.415     2.335     0.200
     0.415     2.770     0.200
     0.415     3.290     0.200
     0.690     1.958     0.200
     0.690     1.856     0.200
     0.959    -1.558     0.200
     1.456    -3.497     0.200
     1.999    -7.076     0.200
     2.051    -8.885     0.200
     3.192   -15.597     0.200
     0.810     2.215     0.200
     1.095    -1.399     0.200
     1.208    -2.117     0.200
     1.417    -3.073     0.200
     1.923    -5.402     0.200
     0.376     2.675     0.200
     0.376     2.860     0.200
     0.488     0.660     0.200
     0.649     1.914     0.200
     1.113    -2.537     0.200
     1.238    -3.006     0.200
     1.238    -2.717     0.200
     1.433    -3.624     0.200
     1.688    -6.528     0.200
     1.999    -7.620     0.200
     2.105    -8.555     0.200
     2.106   -10.374     0.200
     3.239   -14.783     0.200
     0.722     2.075     0.200
     0.722     1.895     0.200
     0.762     1.845     0.200
     0.696     2.629     0.200
     1.071     0.054     0.200
     1.308    -0.958     0.200
     1.490    -2.567     0.200
     2.276    -6.453     0.200
     0.725     1.215     0.200
     1.050    -1.081     0.200
     1.300    -1.587     0.200
     9.195   -58.361     0.200
     0.612     1.396     0.200
     0.612     2.556     0.200
     0.589     2.957     0.200
     0.589     3.313     0.200
     0.620     1.914     0.200
     1.246    -3.400     0.200
     2.151    -6.924     0.200
     2.207    -8.189     0.200
     3.121   -15.378     0.200
     0.617     1.188     0.200
     0.617     2.768     0.200
     0.578     3.569     0.200
     1.349    -3.083     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.551    -0.320     0.200
     1.801     2.984     0.200
     1.877    -1.286     0.200
     1.962    -1.530     0.200
     1.994    -1.359     0.200
     2.087    -1.640     0.200
     2.255     0.234     0.200
     2.367     1.269     0.200
     0.614     0.370     0.200
     0.901     1.286     0.200
     1.077     0.329     0.200
     1.032     1.066     0.200
     1.368    -0.261     0.200
     2.179     1.192     0.200
     2.325     0.635     0.200
     0.643     0.576     0.200
     1.117     0.270     0.200
     1.482     0.604     0.200
     1.482     0.444     0.200
     1.368    -0.788     0.200
     0.655     0.346     0.200
     1.117     0.369     0.200
     1.493     0.618     0.200
     1.356    -0.385     0.200
     1.986    -2.311     0.200
     1.986     0.118     0.200
     1.095     2.153     0.200
     1.486     1.086     0.200
     1.347    -0.063     0.200
     1.984     1.956     0.200
     2.101    -1.461     0.200
     0.542    -0.400     0.200
     0.570     0.237     0.200
     0.570     0.393     0.200
     1.117     2.027     0.200
     0.830     0.641     0.200
     0.829     0.511     0.200
     0.895     1.870     0.200
     1.962    -1.776     0.200
     2.477    -0.825     0.200
     2.477    -1.180     0.200
     3.436    -6.202     0.200
     3.871    -8.902     0.200
     4.496    -7.568     0.200
     5.111    -5.544     0.200
     1.599    -1.093     0.200
     1.246    -0.761     0.200
     1.287    -0.487     0.200
     1.367     6.385     0.200
     1.369    -1.358     0.200
     1.694    -0.823     0.200
     2.757    -4.968     0.200
     3.112    -6.444     0.200
     3.223    -7.625     0.200
     6.440    17.799     0.200
     0.512     0.270     0.200
     1.036    -0.944     0.200
     1.037    -0.908     0.200
     1.037    -0.416     0.200
     1.008     0.991     0.200
     1.676    -0.136     0.200
     1.481   -20.602     0.200
     1.291    -0.312     0.200
     1.397    -1.275     0.200
     1.393    -0.890     0.200
     1.395    -1.262     0.200
     1.905    -2.516     0.200
     4.910    -6.185     0.200
     1.987    -1.692     0.200
     3.038    -6.182     0.200
     3.038    -7.872     0.200
     4.605    10.848     0.200
     4.625     9.943     0.200
     5.967    10.978     0.200
     7.047    14.665     0.200
     1.188     0.409     0.200
     1.278    -0.594     0.200
     1.403    -0.791     0.200
     1.403     0.979     0.200
     1.272    -1.248     0.200
     1.274    -0.999     0.200
     1.487    -1.405     0.200
     0.929     0.285     0.200
     1.043     0.557     0.200
     1.043     0.455     0.200
     1.042     0.647     0.200
     1.042     0.428     0.200
     1.042     1.166     0.200
     1.238     0.105     0.200
     1.352    -0.947     0.200
     1.484    -1.621     0.200
     1.953     0.439     0.200
     1.982     0.282     0.200
     2.490     4.223     0.200
     3.238    -4.967     0.200
     1.406     0.181     0.200
     4.930    -6.934     0.200
     5.290    -7.873     0.200
     5.613    -7.922     0.200
     1.393     0.553     0.200
     5.463   -15.448     0.200
     6.190    -9.348     0.200
     1.188     0.303     0.200
     1.818    -1.015     0.200
     3.385    -5.200     0.200
     3.946    -5.603     0.200
     0.609     0.311     0.200
     0.753     0.907     0.200
     0.753     1.009     0.200
     1.004     2.240     0.200
     1.065    -0.158     0.200
     1.352    -0.340     0.200
     1.513    -1.460     0.200
     1.564    -2.187     0.200
     1.608    -0.266     0.200
     1.608     0.297     0.200
     1.642     1.915     0.200
     1.765     0.807     0.200
     2.000    -0.808     0.200
     2.136    -4.653     0.200
     2.303     0.350     0.200
     0.570     0.891     0.200
     0.686     0.729     0.200
     0.796     1.164     0.200
     0.943    -0.737     0.200
     1.201    -0.032     0.200
     1.534    -1.771     0.200
     1.606    -1.648     0.200
     2.068    -3.574     0.200
     1.353    -2.322     0.200
     1.727    -2.324     0.200
     1.786     1.774     0.200
     3.638    -4.099     0.200
     4.234    -6.239     0.200
     0.640     1.143     0.200
     0.735    -0.043     0.200
     1.052    -0.762     0.200
     1.052     0.757     0.200
     0.994     0.070     0.200
     1.364    -1.966     0.200
     1.669    -3.387     0.200
     1.886    -2.343     0.200
     1.918    -2.865     0.200
     1.940    -2.770     0.200
     1.940    -0.850     0.200
     2.185    -2.310     0.200
     2.530    -2.807     0.200
     2.888    -4.809     0.200
     3.481    -4.469     0.200
     0.875    -0.338     0.200
     0.913     0.079     0.200
     1.443    -1.125     0.200
     1.501    -1.428     0.200
     3.397   -10.125     0.200
     0.591     1.366     0.200
     0.826     0.068     0.200
     0.839     0.515     0.200
     1.018     0.046     0.200
     1.061    -0.602     0.200
     1.286    -0.971     0.200
     1.518    -2.654     0.200
     1.595    -3.482     0.200
     2.434    -7.123     0.200
     0.619     1.280     0.200
     0.924     0.693     0.200
     0.880     0.392     0.200
     1.112    -0.205     0.200
     1.503    -1.647     0.200
     1.553    -1.931     0.200
     1.693     0.227     0.200
     2.530    -2.809     0.200
     3.206    -8.366     0.200
     0.600     0.648     0.200
     0.995    -0.576     0.200
     0.995    -0.106     0.200
     1.177    -0.686     0.200
     1.533    -1.322     0.200
     1.555     0.745     0.200
     1.774    -2.486     0.200
     0.720     1.130     0.200
     0.975     0.552     0.200
     1.112     1.242     0.200
     1.112     1.402     0.200
     1.228    -0.427     0.200
     1.338    -1.648     0.200
     1.813    -0.902     0.200
     0.613     1.373     0.200
     0.988     0.184     0.200
     0.988     0.334     0.200
     1.235     1.258     0.200
     1.235    -0.082     0.200
     1.472    -0.071     0.200
     1.490    -1.338     0.200
     1.490     1.652     0.200
     2.290    -0.613     0.200
     0.661     1.387     0.200
     0.616     0.897     0.200
     0.616     1.916     0.200
     0.826     0.478     0.200
     0.981    -0.070     0.200
     0.981    -0.179     0.200
     0.981     1.220     0.200
     1.250    -0.509     0.200
     1.467    -1.078     0.200
     1.467     0.241     0.200
     1.467     1.172     0.200
     1.631    -2.079     0.200
     2.330    -4.103     0.200
     2.988    -3.360     0.200
     0.609     1.007     0.200
     0.612     0.639     0.200
     1.021    -0.768     0.200
     1.021    -1.068     0.200
     1.021     0.251     0.200
     1.546    -1.091     0.200
     1.546    -0.390     0.200
     1.622    -2.784     0.200
     2.241     0.183     0.200
     3.164    -5.321     0.200
     4.239    -9.934     0.200
     5.566   -14.994     0.200
     0.708     0.760     0.200
     0.708     1.608     0.200
     0.816     0.414     0.200
     0.923    -0.038     0.200
     1.038     2.072     0.200
     1.135    -0.016     0.200
     1.182     1.480     0.200
     1.182     3.230     0.200
     1.596    -2.096     0.200
     1.596     1.088     0.200
     1.596     1.197     0.200
     2.254     1.915     0.200
     0.585     0.428     0.200
     0.790     0.199     0.200
     1.012     0.046     0.200
     1.012     0.566     0.200
     1.270     1.386     0.200
     1.382    -1.104     0.200
     1.504    -1.726     0.200
     1.866    -2.830     0.200
     2.269    -3.056     0.200
     0.705     1.345     0.200
     0.973     0.373     0.200
     1.540    -0.747     0.200
     0.665     1.357     0.200
     1.067     0.232     0.200
     1.317    -1.756     0.200
     1.330    -1.274     0.200
     1.598    -3.563     0.200
     2.137    -4.435     0.200
     0.390     1.165     0.200
     0.819     0.513     0.200
     0.819     0.970     0.200
     1.667    -2.965     0.200
     1.667    -2.683     0.200
     1.607     1.457     0.200
     1.662    -0.415     0.200
     1.863    -1.175     0.200
     1.921    -0.928     0.200
     2.011    -3.791     0.200
     0.395     0.895     0.200
     1.474    -1.650     0.200
     1.474     0.350     0.200
     1.474     1.202     0.200
     1.793     1.705     0.200
     1.793     1.822     0.200
     2.073    -4.267     0.200
     1.435    -1.971     0.200
     1.566    -2.168     0.200
     2.149    -5.821     0.200
     2.101    -2.880     0.200
     0.810     0.661     0.200
     1.078     0.128     0.200
     1.078     1.638     0.200
     1.261    -0.144     0.200
     1.261     0.336     0.200
     1.545    -2.158     0.200
     1.648     0.353     0.200
     1.648     0.674     0.200
     1.983    -2.775     0.200
     3.918    -9.716     0.200
     0.769     1.314     0.200
     1.037    -1.173     0.200
     1.037     0.452     0.200
     1.512    -1.901     0.200
     1.745    -1.824     0.200
     2.532    -2.655     0.200
     2.702    -8.641     0.200
     2.782    -8.746     0.200
     0.753     0.675     0.200
     0.753     1.976     0.200
     0.939     0.390     0.200
     0.939     0.679     0.200
     0.933     0.624     0.200
     0.987     3.406     0.200
     1.105     0.885     0.200
     1.097     1.908     0.200
     1.097     2.990     0.200
     1.342     2.472     0.200
     1.491    -1.308     0.200
     1.561     3.206     0.200
     1.677     1.819     0.200
     1.797     1.749     0.200
     2.020    -3.568     0.200
     0.756     0.223     0.200
     0.941    -0.131     0.200
     1.088    -1.282     0.200
     1.104    -0.853     0.200
     1.495    -2.026     0.200
     3.262    -4.326     0.200
     0.967     0.005     0.200
     0.999     1.624     0.200
     1.039     0.287     0.200
     1.112     0.432     0.200
     1.112    -0.403     0.200
     1.353    -2.937     0.200
     1.491     0.047     0.200
     1.897    -1.114     0.200
     0.476     1.667     0.200
     0.743     1.360     0.200
     0.934    -0.819     0.200
     0.934     0.620     0.200
     0.890    -0.155     0.200
     1.083    -1.395     0.200
     1.493    -3.478     0.200
     1.493    -0.389     0.200
     1.475    -2.595     0.200
     1.983    -4.436     0.200
     2.041    -5.971     0.200
     0.215     1.215     0.200
     1.063    -0.159     0.200
     1.624    -2.077     0.200
     1.624    -0.628     0.200
     1.642    -2.180     0.200
     0.204     1.714     0.200
     1.022     1.562     0.200
     1.656    -3.009     0.200
     1.658    -2.575     0.200
     0.402     2.918     0.200
     0.513     0.422     0.200
     0.778     0.630     0.200
     0.871    -0.792     0.200
     0.852    -0.062     0.200
     0.862     0.485     0.200
     0.903     0.787     0.200
     1.025    -0.193     0.200
     1.592    -3.582     0.200
     1.592    -0.863     0.200
     0.547     0.570     0.200
     0.707     1.753     0.200
     0.752     0.735     0.200
     1.051     0.942     0.200
     1.307     0.499     0.200
     1.317     1.451     0.200
     0.447     1.756     0.200
     1.330     0.258     0.200
     1.330     1.399     0.200
     1.452    -2.485     0.200
     1.581    -0.539     0.200
     1.581     1.163     0.200
     0.600     0.072     0.200
     1.109    -1.336     0.200
     1.088     0.260     0.200
     1.674    -2.941     0.200
     0.716     0.619     0.200
     1.104     1.285     0.200
     1.948    -0.246     0.200
     3.348    -4.749     0.200
     0.737     0.754     0.200
     0.959     2.131     0.200
     1.003     0.009     0.200
     1.128     0.987     0.200
     1.553     0.328     0.200
     0.321     1.962     0.200
     0.321     2.242     0.200
     0.466     0.848     0.200
     0.761     0.633     0.200
     0.777     0.702     0.200
     0.787     1.112     0.200
     0.827     0.074     0.200
     0.827     0.694     0.200
     0.863     2.245     0.200
     0.906     1.031     0.200
     0.970    -0.490     0.200
     1.029    -0.602     0.200
     1.265    -0.045     0.200
     1.895    -3.225     0.200
     1.946    -3.042     0.200
     2.506    -4.093     0.200
     0.503     0.949     0.200
     0.548     2.567     0.200
     0.736     1.613     0.200
     0.883     1.756     0.200
     0.883     1.916     0.200
     1.044     0.066     0.200
     1.882    -0.751     0.200
     1.929    -1.207     0.200
     0.213     3.057     0.200
     1.045    -0.059     0.200
     1.546    -0.566     0.200
     1.651    -1.545     0.200
     3.036    -9.991     0.200
     3.357    -5.720     0.200
     0.802     0.749     0.200
     0.979     1.548     0.200
     1.038     1.456     0.200
     1.323    -0.401     0.200
     1.483    -1.440     0.200
     0.414     0.491     0.200
     0.414     0.299     0.200
     0.823     0.355     0.200
     0.894     0.711     0.200
     0.948     0.307     0.200
     1.046    -0.647     0.200
     1.082    -0.614     0.200
     1.082     1.526     0.200
     1.208     0.646     0.200
     1.466    -3.176     0.200
     1.466    -0.719     0.200
     1.466     0.093     0.200
     1.466    -2.907     0.200
     1.946    -2.878     0.200
     2.005    -5.264     0.200
     0.456     0.539     0.200
     0.815     1.787     0.200
     1.581     0.079     0.200
     1.583     0.580     0.200
     1.640    -1.931     0.200
     1.696    -0.325     0.200
     1.861    -2.216     0.200
     1.919    -4.175     0.200
     2.021    -1.632     0.200
     0.452     1.174     0.200
     1.070     0.178     0.200
     1.102    -0.509     0.200
     1.102    -0.849     0.200
     1.351    -0.931     0.200
     1.473    -1.453     0.200
     1.602    -1.586     0.200
     1.783    -4.693     0.200
     1.844     0.470     0.200
     0.427     1.657     0.200
     1.127     0.171     0.200
     1.164    -0.908     0.200
     1.314     0.242     0.200
     1.507    -0.056     0.200
     1.569    -1.002     0.200
     1.718    -2.804     0.200
     1.718    -3.024     0.200
     1.912    -0.976     0.200
     2.038    -4.391     0.200
     2.838    -4.858     0.200
     3.123    -9.025     0.200
     3.547    -9.977     0.200
     0.448     0.810     0.200
     1.109     1.057     0.200
     1.347     0.172     0.200
     1.477     0.262     0.200
     1.598    -2.045     0.200
     1.852     0.346     0.200
     1.996    -2.782     0.200
     2.626    -3.410     0.200
     3.281    -6.833     0.200
     3.540   -10.397     0.200
     0.591    -0.154     0.200
     0.771     0.435     0.200
     0.771     0.004     0.200
     0.835     0.314     0.200
     1.002     0.729     0.200
     1.050    -0.636     0.200
     1.050    -0.838     0.200
     1.077    -0.612     0.200
     1.221    -0.828     0.200
     1.221    -0.369     0.200
     1.341    -1.823     0.200
     0.315     1.139     0.200
     1.050     0.139     0.200
     1.612    -2.717     0.200
     1.668    -2.523     0.200
     1.714    -3.598     0.200
     1.714    -3.428     0.200
     3.282    -6.545     0.200
     3.377    -7.988     0.200
     0.337     0.903     0.200
     0.337     1.783     0.200
     1.114    -0.611     0.200
     1.114    -0.131     0.200
     1.619    -3.088     0.200
     1.589    -0.564     0.200
     3.323    -8.361     0.200
     0.739     1.154     0.200
     0.951     1.326     0.200
     1.006     0.339     0.200
     1.026     0.480     0.200
     1.026     0.841     0.200
     1.138     0.869     0.200
     1.138     0.638     0.200
     1.471    -0.928     0.200
     1.471     0.602     0.200
     1.509     0.305     0.200
     1.509     2.385     0.200
     1.509     3.895     0.200
     1.627    -0.395     0.200
     1.799    -0.943     0.200
     2.621    -4.108     0.200
     2.700    -4.347     0.200
     0.974     0.154     0.200
     0.964     0.882     0.200
     1.191    -0.898     0.200
     1.191     0.945     0.200
     1.191     0.414     0.200
     1.573    -0.733     0.200
     1.559    -0.434     0.200
     2.665    -4.337     0.200
     0.704     0.746     0.200
     0.981     1.374     0.200
     0.971     0.265     0.200
     1.028     0.600     0.200
     1.157    -0.154     0.200
     1.500    -1.267     0.200
     1.523     0.019     0.200
     1.606     0.239     0.200
     1.843    -2.925     0.200
     2.705    -2.683     0.200
     3.250    -8.041     0.200
     0.929     1.144     0.200
     1.002     0.465     0.200
     1.205     0.718     0.200
     1.563    -1.554     0.200
     3.233    -6.644     0.200
     3.995    -7.984     0.200
     0.618     0.915     0.200
     0.616     0.622     0.200
     0.801     0.605     0.200
     0.992     0.473     0.200
     0.992     0.932     0.200
     1.228     2.442     0.200
     1.306     1.933     0.200
     1.502    -2.002     0.200
     1.502     2.068     0.200
     1.502    -1.041     0.200
     3.195    -5.778     0.200
     0.573     1.005     0.200
     0.863    -0.358     0.200
     0.922    -0.043     0.200
     1.422    -1.584     0.200
     1.539    -0.944     0.200
     1.586     0.351     0.200
     1.940    -3.722     0.200
     2.002    -4.159     0.200
     0.563     0.923     0.200
     0.859     0.416     0.200
     0.933     1.552     0.200
     1.434    -0.490     0.200
     1.587     0.003     0.200
     1.793     0.083     0.200
     1.994    -1.627     0.200
     1.994    -2.447     0.200
     2.568    -2.902     0.200
     0.905     0.529     0.200
     0.939     0.193     0.200
     1.422    -0.718     0.200
     1.502    -0.018     0.200
     1.826    -1.597     0.200
     1.898    -4.594     0.200
     1.967    -1.657     0.200
     1.967    -3.337     0.200
     3.710    -4.315     0.200
     0.583     0.688     0.200
     0.913     0.878     0.200
     1.417    -0.767     0.200
     1.545    -1.343     0.200
     1.576    -1.462     0.200
     1.782    -2.411     0.200
     1.776    -1.772     0.200
     1.951    -2.074     0.200
     2.013    -3.533     0.200
     3.557    -7.744     0.200
     0.569     0.868     0.200
     1.434    -0.920     0.200
     1.556    -0.719     0.200
     1.574    -0.668     0.200
     1.783    -1.444     0.200
     1.779     0.134     0.200
     2.004    -1.508     0.200
     0.536     0.689     0.200
     0.861     0.005     0.200
     0.960     0.059     0.200
     1.459    -1.726     0.200
     1.552    -1.528     0.200
     1.597    -0.428     0.200
     1.815    -1.749     0.200
     1.918    -3.161     0.200
     1.971    -4.372     0.200
     2.808    -5.435     0.200
     0.533     1.704     0.200
     0.893     1.126     0.200
     0.893     0.456     0.200
     0.958     0.534     0.200
     1.445    -1.443     0.200
     1.626     1.423     0.200
     1.833    -0.106     0.200
     1.895    -1.496     0.200
     1.957    -4.049     0.200
     1.957    -1.119     0.200
     3.502    -6.912     0.200
     0.909     1.285     0.200
     0.909     0.453     0.200
     0.949     0.291     0.200
     1.430    -1.439     0.200
     1.501    -1.889     0.200
     1.638    -0.621     0.200
     1.833    -1.228     0.200
     1.742    -2.926     0.200
     1.836    -1.753     0.200
     1.889    -2.203     0.200
     1.889    -4.332     0.200
     1.956    -2.599     0.200
     1.956    -5.118     0.200
     2.602    -7.839     0.200
     2.602    -6.808     0.200
     2.850    -8.300     0.200
     3.494   -10.264     0.200
     0.511     1.339     0.200
     0.890    -0.219     0.200
     0.890     0.918     0.200
     0.981    -0.912     0.200
     1.468    -2.613     0.200
     1.530    -2.377     0.200
     1.630    -3.311     0.200
     1.772    -3.651     0.200
     1.847    -3.949     0.200
     1.884    -3.109     0.200
     1.940    -3.573     0.200
     1.940    -4.476     0.200
     0.568     1.446     0.200
     0.920     0.501     0.200
     0.942     0.573     0.200
     0.942     0.323     0.200
     1.388    -1.373     0.200
     1.460    -2.048     0.200
     1.699    -2.616     0.200
     1.659    -1.362     0.200
     1.835    -2.444     0.200
     1.884    -2.576     0.200
     1.884    -4.475     0.200
     1.966    -2.651     0.200
     0.542     1.295     0.200
     0.924     1.177     0.200
     0.946    -0.070     0.200
     1.650    -1.079     0.200
     1.842    -2.506     0.200
     1.849    -1.982     0.200
     1.880    -1.611     0.200
     1.953    -4.219     0.200
     0.549     1.722     0.200
     0.900     1.562     0.200
     0.941     1.209     0.200
     1.425    -0.134     0.200
     1.508     0.015     0.200
     1.626     0.649     0.200
     1.748    -0.502     0.200
     1.824    -0.804     0.200
     1.901    -1.043     0.200
     1.968    -1.798     0.200
     2.591    -5.773     0.200
     2.591    -4.328     0.200
     3.563    -8.198     0.200
     3.695    -7.126     0.200
     0.580     1.086     0.200
     0.916     0.782     0.200
     1.420    -1.577     0.200
     1.576    -0.417     0.200
     1.777    -1.762     0.200
     2.011    -1.807     0.200
     2.551    -6.586     0.200
     3.556    -8.589     0.200
     0.549     1.245     0.200
     0.946     0.236     0.200
     1.006    -0.965     0.200
     1.387    -1.518     0.200
     1.403    -0.816     0.200
     1.724    -2.971     0.200
     1.827    -1.940     0.200
     1.827    -2.490     0.200
     1.890    -3.070     0.200
     1.882    -3.747     0.200
     1.920    -3.651     0.200
     1.920    -3.121     0.200
     2.634    -8.219     0.200
     2.634    -6.899     0.200
     3.260    -4.804     0.200
     0.613     1.080     0.200
     1.364    -0.621     0.200
     1.492    -1.586     0.200
     1.607    -0.884     0.200
     1.776    -1.369     0.200
     1.942    -2.568     0.200
     2.001    -1.431     0.200
     2.022    -4.142     0.200
     2.022    -3.321     0.200
     2.534    -6.182     0.200
     0.588     0.864     0.200
     0.944     0.708     0.200
     0.944     1.337     0.200
     1.368     0.586     0.200
     1.453    -0.382     0.200
     1.654    -1.574     0.200
     1.691    -0.418     0.200
     1.820    -1.129     0.200
     1.897    -1.911     0.200
     1.983    -3.129     0.200
     3.495    -4.849     0.200
     0.933     1.289     0.200
     0.933     1.844     0.200
     0.933     0.162     0.200
     1.405    -1.502     0.200
     1.473    -2.182     0.200
     1.654    -1.312     0.200
     1.712    -3.134     0.200
     1.838    -2.457     0.200
     1.959    -2.787     0.200
     1.959    -3.615     0.200
     2.597    -7.057     0.200
     2.867    -8.123     0.200
     3.485    -9.780     0.200
     0.959     0.479     0.200
     0.948     1.047     0.200
     0.948     0.348     0.200
     1.424    -1.099     0.200
     1.465    -0.142     0.200
     1.676    -1.741     0.200
     1.707    -2.038     0.200
     1.866    -2.864     0.200
     1.856    -0.950     0.200
     1.856    -3.142     0.200
     1.931    -1.685     0.200
     1.931    -3.126     0.200
     0.591     1.023     0.200
     0.897     0.335     0.200
     0.941     0.705     0.200
     0.941     0.836     0.200
     1.366    -1.050     0.200
     1.456    -0.930     0.200
     1.650    -2.055     0.200
     1.693    -1.636     0.200
     1.816    -2.545     0.200
     1.901    -2.078     0.200
     2.568    -6.807     0.200
     0.541     2.215     0.200
     0.949     0.180     0.200
     0.898    -0.002     0.200
     1.512    -2.746     0.200
     1.627    -0.128     0.200
     1.752    -1.527     0.200
     1.897    -1.987     0.200
     0.586     2.016     0.200
     0.903     0.624     0.200
     0.949     0.913     0.200
     0.949     0.463     0.200
     1.369    -1.206     0.200
     1.449    -1.906     0.200
     1.686    -3.131     0.200
     1.660    -0.734     0.200
     1.892    -2.875     0.200
     1.826    -1.458     0.200
     2.576    -7.346     0.200
     0.584     0.702     0.200
     0.906     0.142     0.200
     0.898    -0.382     0.200
     0.898    -0.861     0.200
     1.392    -0.475     0.200
     1.500    -0.670     0.200
     1.614    -1.774     0.200
     1.737    -1.762     0.200
     1.836    -2.880     0.200
     1.924    -3.104     0.200
     0.580     0.814     0.200
     0.872     0.801     0.200
     0.913     0.179     0.200
     1.410    -1.448     0.200
     1.528    -1.923     0.200
     1.592    -2.177     0.200
     1.765    -2.671     0.200
     1.808    -1.700     0.200
     1.938    -3.061     0.200
     2.556    -6.648     0.200
     2.556    -7.871     0.200
     2.804    -6.044     0.200
     0.596     1.419     0.200
     0.899     0.628     0.200
     1.003    -0.680     0.200
     1.003     0.850     0.200
     1.342    -0.328     0.200
     1.394    -1.206     0.200
     1.632    -1.196     0.200
     1.707    -0.296     0.200
     1.861    -1.413     0.200
     1.861    -4.391     0.200
     1.854    -1.538     0.200
     1.942    -1.427     0.200
     0.582     1.734     0.200
     0.906     0.379     0.200
     0.949     0.958     0.200
     0.949     1.517     0.200
     1.372    -1.141     0.200
     1.450    -1.416     0.200
     1.688    -2.152     0.200
     1.661    -2.179     0.200
     1.889    -1.483     0.200
     1.828    -2.936     0.200
     1.886    -2.049     0.200
     0.562     1.408     0.200
     0.952     2.338     0.200
     1.670    -0.362     0.200
     1.845    -0.962     0.200
     1.882    -2.281     0.200
     0.581     1.039     0.200
     0.911     1.010     0.200
     0.986     1.080     0.200
     0.986    -0.379     0.200
     1.361    -0.878     0.200
     1.853    -0.240     0.200
     2.908    -7.217     0.200
     3.224    -7.951     0.200
     0.593     1.160     0.200
     0.960     1.227     0.200
     0.960     2.307     0.200
     1.357    -0.580     0.200
     1.436    -1.310     0.200
     1.674    -2.042     0.200
     1.667    -0.667     0.200
     1.827    -0.208     0.200
     2.574    -6.252     0.200
     0.543     0.246     0.200
     0.543     0.106     0.200
     0.749     1.153     0.200
     0.749     1.413     0.200
     0.825    -0.494     0.200
     0.917     1.017     0.200
     0.917     0.665     0.200
     0.917     1.505     0.200
     0.934    -0.181     0.200
     1.032     0.005     0.200
     1.032    -0.455     0.200
     1.013    -0.526     0.200
     1.062     0.823     0.200
     1.174    -0.475     0.200
     1.130     1.352     0.200
     1.259     1.101     0.200
     1.590    -2.921     0.200
     1.541     0.978     0.200
     0.459     1.752     0.200
     0.540     0.672     0.200
     0.540     0.352     0.200
     0.830    -0.046     0.200
     0.902     2.382     0.200
     0.909     0.226     0.200
     0.920     0.006     0.200
     0.960    -0.101     0.200
     0.960     1.168     0.200
     1.034    -0.075     0.200
     1.244    -0.961     0.200
     1.314    -0.081     0.200
     1.595    -3.036     0.200
     1.595    -3.156     0.200
     1.650    -2.756     0.200
     2.224    -5.791     0.200
     0.595     0.997     0.200
     0.893     0.136     0.200
     0.946     1.453     0.200
     0.946    -0.006     0.200
     1.361    -2.099     0.200
     1.450    -3.185     0.200
     1.687    -3.645     0.200
     1.654    -0.947     0.200
     1.817    -2.587     0.200
     1.887    -2.506     0.200
     1.988    -4.930     0.200
     2.567    -7.163     0.200
     3.644    -9.857     0.200
     0.578     1.295     0.200
     0.913     0.365     0.200
     0.984    -0.077     0.200
     1.364    -1.264     0.200
     1.416    -1.353     0.200
     1.655    -1.835     0.200
     1.695    -3.205     0.200
     1.854    -2.547     0.200
     2.598    -7.475     0.200
     0.927    -0.215     0.200
     0.995     0.263     0.200
     0.995    -0.417     0.200
     1.372    -0.510     0.200
     1.648    -1.159     0.200
     1.709    -1.792     0.200
     1.870    -2.323     0.200
     1.846    -3.755     0.200
     1.846    -4.015     0.200
     1.941    -2.356     0.200
     1.941    -4.616     0.200
     2.614    -6.652     0.200
     3.240    -5.878     0.200
     0.583     0.996     0.200
     0.906     0.946     0.200
     0.905     1.672     0.200
     0.905     2.012     0.200
     1.390    -1.443     0.200
     1.731    -2.622     0.200
     1.620    -0.897     0.200
     1.801    -0.979     0.200
     1.842    -1.580     0.200
     0.581     1.247     0.200
     0.869     1.623     0.200
     0.912     0.242     0.200
     1.410    -2.446     0.200
     1.589     1.518     0.200
     1.784    -3.360     0.200
     1.806    -2.221     0.200
     2.554    -7.163     0.200
     0.585     0.924     0.200
     0.902     0.577     0.200
     1.377    -1.471     0.200
     1.641    -0.400     0.200
     1.813    -1.260     0.200
     1.987    -4.666     0.200
     1.866    -0.798     0.200
     2.569    -7.107     0.200
     0.595     1.098     0.200
     0.894     0.419     0.200
     1.354    -1.476     0.200
     1.432    -2.395     0.200
     1.670    -2.781     0.200
     1.670    -0.849     0.200
     1.888    -2.984     0.200
     1.828    -2.022     0.200
     1.904    -2.364     0.200
     1.981    -4.415     0.200
     2.574    -6.783     0.200
     0.478     0.186     0.200
     1.027     1.253     0.200
     1.529    -1.379     0.200
     1.603     1.939     0.200
     1.744     0.932     0.200
     1.928    -1.461     0.200
     1.998    -0.709     0.200
     1.853     0.297     0.200
     2.644    -5.792     0.200
     0.507     0.520     0.200
     0.992     0.428     0.200
     1.490    -0.435     0.200
     1.564    -2.024     0.200
     1.604    -0.402     0.200
     1.807    -1.814     0.200
     1.769    -0.937     0.200
     1.836    -1.486     0.200
     1.902    -3.340     0.200
     1.948    -3.393     0.200
     1.948    -3.803     0.200
     1.995    -2.140     0.200
     2.619    -6.252     0.200
     3.194    -8.436     0.200
     0.473     0.909     0.200
     1.044     0.575     0.200
     1.555    -1.847     0.200
     1.584     0.296     0.200
     1.713    -1.061     0.200
     1.849    -1.455     0.200
     1.906    -3.006     0.200
     1.931    -4.121     0.200
     1.931    -0.582     0.200
     2.648    -6.951     0.200
     3.775    -7.578     0.200
     0.584     0.886     0.200
     0.904     1.038     0.200
     0.935     0.081     0.200
     0.935     0.261     0.200
     1.376    -1.389     0.200
     1.376     7.531     0.200
     1.463    -0.695     0.200
     1.701    -3.679     0.200
     1.648    -1.231     0.200
     1.818    -2.246     0.200
     1.983    -5.079     0.200
     0.883    -0.539     0.200
     0.883    -0.750     0.200
     0.921    -0.681     0.200
     1.413    -1.892     0.200
     1.519    -3.282     0.200
     1.604     1.990     0.200
     1.799    -0.262     0.200
     1.993    -3.495     0.200
     0.541     1.969     0.200
     0.950     1.221     0.200
     1.675    -0.257     0.200
     1.859    -2.414     0.200
     1.875    -0.638     0.200
     2.887    -6.394     0.200
     3.226    -5.621     0.200
     0.586     1.227     0.200
     0.902    -0.119     0.200
     0.937    -0.715     0.200
     0.937     0.985     0.200
     1.373    -1.214     0.200
     1.461    -1.819     0.200
     1.698    -3.297     0.200
     1.649     1.601     0.200
     1.818    -1.646     0.200
     1.984    -5.364     0.200
     1.825    -1.234     0.200
     1.887     1.107     0.200
     1.831     0.846     0.200
     2.001    -1.323     0.200
     2.001    -2.932     0.200
     2.572    -1.980     0.200
     3.276    -7.073     0.200
     7.737     8.671     0.200
     0.548     0.429     0.200
     0.930     0.793     0.200
     0.940     1.411     0.200
     1.412    -0.028     0.200
     1.477    -1.147     0.200
     1.654    -0.717     0.200
     1.717    -2.311     0.200
     1.842    -0.759     0.200
     1.955    -3.109     0.200
     0.555     0.768     0.200
     0.935     0.432     0.200
     0.971    -0.127     0.200
     0.971    -0.367     0.200
     1.391    -1.019     0.200
     1.435    -1.344     0.200
     1.675    -3.694     0.200
     1.690    -2.057     0.200
     1.856    -2.646     0.200
     1.862    -2.857     0.200
     1.943    -2.889     0.200
     2.612    -6.955     0.200
     0.553     0.713     0.200
     0.935     1.616     0.200
     0.939    -0.103     0.200
     0.939     1.528     0.200
     1.404    -0.303     0.200
     1.660    -0.740     0.200
     1.707    -0.836     0.200
     1.843    -1.523     0.200
     1.877    -2.421     0.200
     1.877    -3.742     0.200
     1.955    -3.097     0.200
     1.955    -3.417     0.200
     2.812    -4.184     0.200
     0.578     0.831     0.200
     0.898     1.226     0.200
     0.898     0.628     0.200
     0.911     1.117     0.200
     1.398     0.069     0.200
     1.501     0.047     0.200
     1.616     0.506     0.200
     1.739    -1.398     0.200
     1.802    -0.219     0.200
     1.920    -1.015     0.200
     1.993    -1.733     0.200
     2.565    -5.181     0.200
     0.566     1.195     0.200
     0.901     0.834     0.200
     1.408    -0.806     0.200
     1.622     0.674     0.200
     1.811    -1.439     0.200
     1.811     2.042     0.200
     1.911    -3.294     0.200
     0.595     1.262     0.200
     0.893     0.990     0.200
     1.374    -1.723     0.200
     1.625     0.093     0.200
     1.718    -2.614     0.200
     1.798    -1.387     0.200
     2.555    -6.642     0.200
     2.838    -6.832     0.200
     0.564     0.932     0.200
     1.406    -1.412     0.200
     1.632     0.984     0.200
     1.819    -1.937     0.200
     2.582    -6.239     0.200
     0.678     1.063     0.200
     1.096     1.605     0.200
     1.090     0.469     0.200
     1.515    -1.448     0.200
     1.736    -1.419     0.200
     3.115    -7.067     0.200
     3.399    -4.947     0.200
     0.572     0.363     0.200
     0.917     0.518     0.200
     0.970     1.084     0.200
     0.970     0.166     0.200
     1.374    -0.695     0.200
     1.432    -1.854     0.200
     1.671    -2.722     0.200
     1.683     0.218     0.200
     1.849    -2.715     0.200
     1.958    -3.766     0.200
     1.084     1.557     0.200
     1.084     0.007     0.200
     1.295    -0.495     0.200
     1.310    -0.236     0.200
     1.547    -0.510     0.200
     1.776    -1.901     0.200
     1.824    -0.500     0.200
     1.824    -2.640     0.200
     1.892    -2.609     0.200
     1.951    -1.072     0.200
     1.951    -3.402     0.200
     2.608    -6.708     0.200
     0.577     1.300     0.200
     0.863    -0.517     0.200
     0.918    -0.071     0.200
     1.417    -1.771     0.200
     1.586     0.255     0.200
     1.538     0.304     0.200
     1.785    -0.397     0.200
     2.556    -3.065     0.200
     3.147    -7.103     0.200
     3.566    -9.663     0.200
     0.581     0.957     0.200
     0.903     1.148     0.200
     1.393    -1.168     0.200
     1.619     1.391     0.200
     1.802    -0.008     0.200
     1.994    -4.000     0.200
     0.871     0.318     0.200
     0.871    -0.010     0.200
     0.980     0.391     0.200
     1.474    -1.082     0.200
     1.548    -2.280     0.200
     1.612     1.532     0.200
     1.790    -3.155     0.200
     1.835    -2.518     0.200
     1.899    -1.917     0.200
     1.899    -4.073     0.200
     1.951    -3.017     0.200
     1.951    -3.548     0.200
     0.543     0.736     0.200
     0.870    -0.584     0.200
     0.870     2.025     0.200
     0.951    -0.119     0.200
     1.447    -2.555     0.200
     1.602    -0.907     0.200
     1.813    -1.321     0.200
     1.974    -5.285     0.200
     0.545     1.938     0.200
     0.906     0.999     0.200
     1.426    -1.064     0.200
     1.894    -2.535     0.200
     1.962    -3.814     0.200
     0.894    -0.322     0.200
     0.975    -0.825     0.200
     0.975    -0.661     0.200
     1.632     1.248     0.200
     1.845    -0.872     0.200
     1.943    -5.346     0.200
     1.943    -5.237     0.200
     0.535     0.815     0.200
     0.954     0.271     0.200
     1.411    -0.912     0.200
     1.445    -0.128     0.200
     1.691    -0.676     0.200
     1.847    -3.325     0.200
     1.873    -1.486     0.200
     1.912    -3.418     0.200
     1.928    -3.116     0.200
     3.702    -4.768     0.200
     0.890    -0.637     0.200
     0.951    -0.019     0.200
     1.439    -1.853     0.200
     1.620    -2.441     0.200
     1.761    -3.807     0.200
     1.825    -4.565     0.200
     1.902    -4.121     0.200
     1.964    -5.567     0.200
     0.579     1.298     0.200
     1.393    -0.725     0.200
     1.492    -1.612     0.200
     1.624     0.095     0.200
     1.730    -2.368     0.200
     1.915    -3.400     0.200
     0.892    -1.075     0.200
     0.928    -0.319     0.200
     1.416    -1.437     0.200
     1.615     1.076     0.200
     1.751    -3.862     0.200
     1.987    -3.123     0.200
     0.560     1.397     0.200
     0.858    -0.379     0.200
     0.936     0.303     0.200
     1.437    -0.385     0.200
     1.548    -0.785     0.200
     1.586    -0.611     0.200
     1.993    -3.383     0.200
     1.426    -0.615     0.200
     1.585    -0.267     0.200
     1.788    -1.481     0.200
     1.939    -0.451     0.200
     1.939    -1.900     0.200
     2.000    -1.092     0.200
     2.000    -1.291     0.200
     0.558     1.132     0.200
     0.884    -0.315     0.200
     0.884     1.532     0.200
     0.934     0.149     0.200
     1.425    -2.389     0.200
     1.610     0.550     0.200
     1.809    -2.435     0.200
     1.981    -2.225     0.200
     2.822    -6.119     0.200
     0.560     0.660     0.200
     0.929    -0.211     0.200
     0.957     1.713     0.200
     1.390    -0.829     0.200
     1.447    -1.701     0.200
     1.687    -1.301     0.200
     1.675    -1.593     0.200
     1.953    -3.644     0.200
     1.953    -4.973     0.200
     0.574     1.179     0.200
     0.921     0.896     0.200
     1.583     0.384     0.200
     1.780    -0.411     0.200
     1.785     0.342     0.200
     1.942    -1.741     0.200
     2.004    -3.778     0.200
     2.795    -6.178     0.200
     0.565     1.306     0.200
     0.927     0.693     0.200
     0.881     0.774     0.200
     1.420    -0.683     0.200
     1.605     0.042     0.200
     1.802    -1.768     0.200
     1.923    -4.738     0.200
     0.846     0.212     0.200
     0.985     1.265     0.200
     0.985     0.788     0.200
     1.299    -1.176     0.200
     1.673    -1.165     0.200
     3.177    -8.513     0.200
     0.879     0.039     0.200
     1.061    -1.457     0.200
     1.295    -0.960     0.200
     1.331    -0.925     0.200
     1.753    -2.308     0.200
     1.844    -3.789     0.200
     1.844    -4.199     0.200
     1.966    -4.771     0.200
     1.966    -4.621     0.200
     0.564     0.974     0.200
     0.885    -0.184     0.200
     1.419    -1.230     0.200
     1.609     1.107     0.200
     2.821    -4.163     0.200
     3.683    -5.328     0.200
     0.525     1.668     0.200
     0.910     1.025     0.200
     0.964    -0.242     0.200
     1.444    -2.451     0.200
     1.505    -0.789     0.200
     1.847    -4.696     0.200
     1.880    -1.987     0.200
     1.944    -5.158     0.200
     1.958    -3.578     0.200
     0.929     0.865     0.200
     1.414     0.672     0.200
     1.504     0.679     0.200
     1.624    -0.222     0.200
     1.624    -0.050     0.200
     1.908    -1.020     0.200
     1.977    -1.735     0.200
     2.836    -6.697     0.200
     3.552    -6.316     0.200
     3.683    -8.715     0.200
     0.554     0.776     0.200
     0.912    -0.777     0.200
     0.912     0.145     0.200
     0.934    -0.294     0.200
     1.414    -0.832     0.200
     1.636    -0.219     0.200
     1.826    -2.266     0.200
     1.968    -3.287     0.200
     3.688    -7.247     0.200
     0.565     1.208     0.200
     0.936     0.057     0.200
     1.443    -1.952     0.200
     1.565    -1.778     0.200
     1.569     2.063     0.200
     1.783    -1.678     0.200
     0.562     0.481     0.200
     0.926     1.165     0.200
     0.932     1.308     0.200
     1.398    -0.624     0.200
     1.471    -1.450     0.200
     1.652    -0.397     0.200
     1.711    -2.014     0.200
     1.833    -1.761     0.200
     1.863     0.292     0.200
     1.966    -3.522     0.200
     0.569     1.014     0.200
     0.895     1.288     0.200
     0.895     0.448     0.200
     0.921     0.709     0.200
     1.408    -1.348     0.200
     1.507    -2.220     0.200
     1.616    -2.699     0.200
     1.807    -3.552     0.200
     1.987    -5.086     0.200
     2.828    -5.996     0.200
     3.520    -9.054     0.200
     0.569     1.558     0.200
     0.867     0.334     0.200
     0.867     0.575     0.200
     0.925     0.472     0.200
     1.423    -0.436     0.200
     1.536    -2.352     0.200
     1.591    -1.342     0.200
     1.792    -2.963     0.200
     1.997    -4.640     0.200
     3.540    -9.121     0.200
     0.570     2.000     0.200
     0.849     0.431     0.200
     0.849     1.899     0.200
     0.928     0.091     0.200
     1.433    -1.500     0.200
     1.576    -1.725     0.200
     1.783    -2.595     0.200
     2.004    -4.388     0.200
     2.788    -6.231     0.200
     0.895     0.765     0.200
     1.403    -0.403     0.200
     1.614     1.328     0.200
     1.802     0.178     0.200
     2.826    -5.950     0.200
     3.167    -8.468     0.200
     0.956    -0.090     0.200
     1.147     0.193     0.200
     1.147    -1.747     0.200
     1.259    -0.137     0.200
     1.331    -0.938     0.200
     1.744    -2.482     0.200
     1.744    -3.252     0.200
     1.851    -2.367     0.200
     1.879    -3.084     0.200
     1.879    -4.164     0.200
     1.972    -2.534     0.200
     2.683    -7.288     0.200
     0.585     1.113     0.200
     0.951    -0.377     0.200
     1.117    -0.452     0.200
     1.117    -0.601     0.200
     1.289    -0.810     0.200
     1.340    -0.718     0.200
     1.531    -1.866     0.200
     1.762    -3.755     0.200
     1.824    -2.713     0.200
     1.953    -2.639     0.200
     2.671    -8.225     0.200
     2.671    -5.555     0.200
     3.415    -7.014     0.200
     0.578     1.122     0.200
     0.911     1.613     0.200
     1.375    -1.279     0.200
     1.685    -3.013     0.200
     1.666     1.374     0.200
     1.834    -1.651     0.200
     1.970    -3.914     0.200
     1.888    -0.787     0.200
     2.312    -5.203     0.200
     2.585    -5.898     0.200
     2.878    -7.708     0.200
     0.907    -0.483     0.200
     0.956    -0.224     0.200
     1.370    -1.475     0.200
     1.443    -1.301     0.200
     1.681    -2.130     0.200
     1.667    -3.044     0.200
     1.884    -1.930     0.200
     1.833    -3.114     0.200
     1.972    -3.537     0.200
     0.573     0.415     0.200
     0.890     1.726     0.200
     0.917     0.117     0.200
     1.407    -2.175     0.200
     1.610    -0.886     0.200
     4.430    -7.219     0.200
     0.922     0.137     0.200
     0.914     1.773     0.200
     1.402    -2.282     0.200
     1.634    -1.241     0.200
     1.819    -2.004     0.200
     1.903    -4.224     0.200
     1.977    -4.631     0.200
     2.581    -6.909     0.200
     0.557     1.436     0.200
     0.931     0.210     0.200
     0.935     0.675     0.200
     0.935     0.015     0.200
     1.470    -0.525     0.200
     1.656    -1.028     0.200
     1.838    -2.059     0.200
     1.864    -1.593     0.200
     0.543     1.414     0.200
     0.927     0.874     0.200
     0.927     1.843     0.200
     1.482    -1.659     0.200
     1.653    -0.422     0.200
     1.843    -1.446     0.200
     2.606    -2.438     0.200
     2.865    -6.286     0.200
     0.471     1.107     0.200
     1.045     0.572     0.200
     1.555    -1.855     0.200
     1.586    -0.811     0.200
     1.621    -1.783     0.200
     1.714    -1.034     0.200
     1.851    -1.955     0.200
     1.866    -2.690     0.200
     1.904    -3.098     0.200
     1.929    -2.863     0.200
     2.650    -6.814     0.200
     2.793    -6.795     0.200
     0.877     0.593     0.200
     0.921    -0.224     0.200
     1.416    -1.441     0.200
     1.599    -1.350     0.200
     1.763    -2.229     0.200
     1.796    -3.197     0.200
     1.995    -1.161     0.200
     2.565    -7.591     0.200
     3.159    -7.182     0.200
     5.031   -11.465     0.200
     0.540     0.853     0.200
     0.958    -0.450     0.200
     1.460    -3.450     0.200
     1.589     0.992     0.200
     1.808    -1.061     0.200
     1.925    -4.303     0.200
     1.978    -4.323     0.200
     2.588    -7.569     0.200
     0.559     1.137     0.200
     0.936     0.457     0.200
     1.436    -1.589     0.200
     1.545     0.431     0.200
     1.589     1.040     0.200
     1.796    -1.370     0.200
     0.952     2.300     0.200
     1.650    -1.646     0.200
     1.674     0.056     0.200
     1.799     0.198     0.200
     1.917    -2.750     0.200
     2.011    -4.378     0.200
     0.552     1.019     0.200
     0.905    -0.669     0.200
     0.905     1.351     0.200
     0.937    -0.078     0.200
     1.420    -1.843     0.200
     1.630    -0.208     0.200
     1.741    -2.848     0.200
     1.824    -1.545     0.200
     1.969    -4.150     0.200
     1.969    -3.119     0.200
     0.840     0.359     0.200
     0.804     1.017     0.200
     1.278    -0.614     0.200
     1.372     0.122     0.200
     1.520     0.136     0.200
     2.497    -4.815     0.200
     2.801    -3.826     0.200
     1.184     0.067     0.200
     1.222     1.102     0.200
     1.222     1.723     0.200
     1.428    -0.902     0.200
     1.700    -0.361     0.200
     1.700    -1.982     0.200
     1.921    -2.164     0.200
     1.856    -1.398     0.200
     1.856    -3.289     0.200
     2.022    -1.006     0.200
     3.399    -6.931     0.200
     0.661     1.459     0.200
     0.923     0.675     0.200
     1.199    -0.050     0.200
     1.196     0.823     0.200
     1.196    -0.447     0.200
     1.270    -0.325     0.200
     1.439    -1.224     0.200
     1.883    -1.875     0.200
     1.972    -0.098     0.200
     2.591    -2.752     0.200
     2.663    -3.412     0.200
     3.619    -9.074     0.200
     1.184     1.281     0.200
     1.206     0.630     0.200
     1.206     0.809     0.200
     1.238     1.417     0.200
     1.421     0.612     0.200
     1.421    -0.720     0.200
     1.934    -3.461     0.200
     1.884     0.140     0.200
     1.958    -0.957     0.200
     2.642    -6.868     0.200
     0.935     0.297     0.200
     1.194    -0.474     0.200
     1.203     0.263     0.200
     1.203    -0.917     0.200
     1.280    -0.364     0.200
     1.435    -1.235     0.200
     1.740    -4.173     0.200
     1.893    -3.243     0.200
     1.984    -4.014     0.200
     0.884     0.504     0.200
     1.023     0.655     0.200
     1.318    -1.791     0.200
     1.720     0.170     0.200
     1.860    -3.474     0.200
     1.854    -1.127     0.200
     1.970    -3.229     0.200
     0.757     0.819     0.200
     0.923     1.743     0.200
     1.156     0.238     0.200
     1.478    -1.290     0.200
     1.478     0.729     0.200
     1.515    -0.037     0.200
     1.613     0.654     0.200
     2.727    -4.924     0.200
     1.197    -0.220     0.200
     0.917     0.421     0.200
     1.537    -1.010     0.200
     1.176    -0.480     0.200
     1.448    -1.658     0.200
     1.448    -1.768     0.200
     1.391    -1.421     0.200
     1.684    -3.117     0.200
     1.684    -3.738     0.200
     2.312    -0.630     0.200
     2.984    -5.905     0.200
     1.188    -0.379     0.200
     0.929     0.346     0.200
     1.388    -0.676     0.200
     1.413    -0.084     0.200
     1.457    -1.337     0.200
     1.688    -3.655     0.200
     2.229    -4.144     0.200
     2.301    -3.782     0.200
     3.078    -7.745     0.200
     0.932     0.262     0.200
     1.188    -0.856     0.200
     1.209    -0.196     0.200
     1.209     0.608     0.200
     1.273    -0.939     0.200
     1.428    -0.629     0.200
     1.899    -4.082     0.200
     1.897    -1.904     0.200
     1.985    -1.043     0.200
     2.674    -4.451     0.200
     3.309    -9.160     0.200
     0.637     0.901     0.200
     0.925     1.380     0.200
     1.164     1.024     0.200
     1.164     0.493     0.200
     1.290    -0.695     0.200
     1.856    -1.738     0.200
     1.958    -1.839     0.200
     0.628     1.162     0.200
     0.955     0.330     0.200
     1.196     0.689     0.200
     1.196     0.368     0.200
     1.207    -0.943     0.200
     1.305    -0.608     0.200
     1.450    -1.412     0.200
     1.726    -2.217     0.200
     1.726    -3.396     0.200
     1.876    -4.522     0.200
     1.893    -1.938     0.200
     1.995    -3.011     0.200
     0.777     0.876     0.200
     1.039     0.005     0.200
     1.264     0.403     0.200
     1.388    -1.417     0.200
     1.399     0.182     0.200
     0.924    -0.353     0.200
     0.924     1.772     0.200
     1.184    -1.285     0.200
     1.209    -0.640     0.200
     1.406    -1.750     0.200
     1.436    -1.542     0.200
     1.436    -2.066     0.200
     1.537     0.876     0.200
     1.669    -2.689     0.200
     1.669    -3.556     0.200
     2.321    -2.434     0.200
     2.971    -8.258     0.200
     0.932     0.072     0.200
     1.190    -0.925     0.200
     1.189    -1.034     0.200
     1.189     0.575     0.200
     1.391    -2.298     0.200
     1.456    -3.041     0.200
     1.456    -2.154     0.200
     1.686    -3.121     0.200
     0.746     1.107     0.200
     0.929     1.258     0.200
     1.185     0.024     0.200
     1.155     0.160     0.200
     1.490    -2.564     0.200
     1.490    -2.697     0.200
     1.356    -0.980     0.200
     1.722    -3.044     0.200
     1.508    -2.749     0.200
     3.026    -4.511     0.200
     3.249    -8.317     0.200
     0.903     0.119     0.200
     1.111     0.144     0.200
     1.111    -0.067     0.200
     1.294    -1.796     0.200
     1.802    -4.678     0.200
     1.804    -3.370     0.200
     3.623   -10.696     0.200
     0.923    -0.015     0.200
     1.162    -1.279     0.200
     1.162    -0.598     0.200
     1.235    -0.966     0.200
     1.288    -1.262     0.200
     1.475    -2.319     0.200
     1.854    -2.934     0.200
     1.910    -5.159     0.200
     1.955    -4.036     0.200
     3.340    -9.216     0.200
     3.332    -8.269     0.200
     0.926     0.238     0.200
     1.093    -1.352     0.200
     1.093    -0.723     0.200
     1.307    -1.902     0.200
     1.327    -1.466     0.200
     1.548    -2.691     0.200
     1.796    -2.759     0.200
     1.915    -5.042     0.200
     1.923    -1.671     0.200
     3.298    -5.501     0.200
     4.250   -12.178     0.200
     0.632     0.954     0.200
     0.939     1.239     0.200
     1.176    -0.181     0.200
     1.176     1.990     0.200
     1.298    -0.492     0.200
     1.746    -2.631     0.200
     1.871    -2.098     0.200
     1.974    -2.702     0.200
     2.674    -4.226     0.200
     0.609     1.346     0.200
     0.942     1.167     0.200
     1.145    -0.328     0.200
     1.257    -0.726     0.200
     1.317    -0.263     0.200
     1.499    -1.677     0.200
     1.756    -3.561     0.200
     1.845    -2.678     0.200
     1.892    -4.105     0.200
     1.961    -2.623     0.200
     0.612     1.203     0.200
     0.945    -0.092     0.200
     1.155    -1.386     0.200
     1.155    -0.003     0.200
     1.247    -0.164     0.200
     1.315    -0.936     0.200
     1.489    -0.704     0.200
     1.749    -3.315     0.200
     1.749    -3.885     0.200
     1.855    -3.238     0.200
     1.855     0.699     0.200
     1.888    -4.035     0.200
     1.888    -4.625     0.200
     1.968    -2.446     0.200
     2.675    -8.025     0.200
     3.379    -8.883     0.200
     0.675     0.971     0.200
     0.930     1.314     0.200
     1.226     1.553     0.200
     1.226     1.833     0.200
     1.262     0.085     0.200
     1.910    -0.660     0.200
     1.902    -3.102     0.200
     3.388    -6.232     0.200
     0.673     0.715     0.200
     0.940     1.015     0.200
     1.161     0.125     0.200
     1.267     0.144     0.200
     1.401    -0.203     0.200
     1.892    -2.710     0.200
     1.922    -1.280     0.200
     2.003    -3.165     0.200
     2.686    -3.076     0.200
     0.761    -0.031     0.200
     1.055    -1.074     0.200
     0.919     0.985     0.200
     1.154    -0.200     0.200
     1.475    -1.358     0.200
     1.475    -0.118     0.200
     1.516    -1.562     0.200
     3.279    -6.349     0.200
     4.034   -10.140     0.200
     0.738     1.331     0.200
     0.924     0.645     0.200
     1.182    -0.348     0.200
     1.193     0.038     0.200
     1.452    -1.861     0.200
     1.452    -2.191     0.200
     1.391    -0.171     0.200
     1.685    -2.907     0.200
     1.685    -0.276     0.200
     1.685    -3.135     0.200
     2.307    -5.162     0.200
     1.144     1.110     0.200
     1.182     0.843     0.200
     1.182     1.202     0.200
     1.154     0.184     0.200
     1.448    -0.899     0.200
     1.448    -1.298     0.200
     1.465     0.192     0.200
     1.622    -0.988     0.200
     0.589     0.944     0.200
     0.996     1.373     0.200
     1.048    -0.406     0.200
     1.059     0.172     0.200
     1.079    -0.117     0.200
     1.220     0.560     0.200
     1.342    -0.977     0.200
     1.352     1.381     0.200
     1.593    -1.977     0.200
     1.593    -3.057     0.200
     1.667    -1.275     0.200
     2.117    -3.020     0.200
     0.242     0.797     0.200
     1.342    -0.180     0.200
     1.342    -0.050     0.200
     1.337    -0.121     0.200
     1.337     0.349     0.200
     1.378    -1.127     0.200
     1.378     1.564     0.200
     1.378    -0.607     0.200
     1.419    -0.617     0.200
     1.506    -1.012     0.200
     1.506     0.138     0.200
     1.481     0.570     0.200
     2.428    -2.318     0.200
     2.963    -3.627     0.200
     0.815     0.212     0.200
     1.082    -0.264     0.200
     1.209     0.184     0.200
     1.209     0.434     0.200
     1.283    -1.107     0.200
     1.508     0.397     0.200
     1.563    -2.480     0.200
     1.563     1.797     0.200
     1.671    -2.283     0.200
     2.879    -4.738     0.200
     3.276    -7.170     0.200
     0.824     1.042     0.200
     1.089    -0.327     0.200
     1.196    -0.265     0.200
     1.266     0.461     0.200
     1.266    -1.379     0.200
     1.545    -2.599     0.200
     1.526    -0.583     0.200
     1.655    -2.706     0.200
     3.290    -8.320     0.200
     0.564     0.086     0.200
     0.798    -0.698     0.200
     0.972     1.029     0.200
     0.970     0.072     0.200
     0.970     0.174     0.200
     0.969     0.570     0.200
     0.987     1.618     0.200
     1.034    -0.408     0.200
     1.028     0.130     0.200
     1.058    -0.229     0.200
     1.104     0.951     0.200
     1.195    -0.516     0.200
     1.195     0.074     0.200
     1.312    -1.675     0.200
     1.584    -2.184     0.200
     0.552     0.012     0.200
     0.551     0.103     0.200
     0.813     0.564     0.200
     0.813     0.434     0.200
     0.940     1.296     0.200
     0.941     1.350     0.200
     0.945    -0.937     0.200
     0.958     0.694     0.200
     0.958     1.313     0.200
     1.034    -0.231     0.200
     1.032    -0.569     0.200
     1.032    -0.139     0.200
     1.183     0.177     0.200
     1.283    -1.416     0.200
     1.331    -2.081     0.200
     1.337     0.142     0.200
     1.763    -3.263     0.200
     0.558     1.993     0.200
     0.619     0.285     0.200
     0.619     0.615     0.200
     1.014     0.269     0.200
     1.055     0.933     0.200
     1.084    -0.295     0.200
     1.084     0.236     0.200
     1.250    -0.334     0.200
     1.250     0.393     0.200
     1.268     0.450     0.200
     1.331    -0.841     0.200
     1.370    -1.533     0.200
     1.409     1.757     0.200
     1.630    -1.908     0.200
     1.630    -0.724     0.200
     1.832    -2.951     0.200
     2.006    -3.337     0.200
     2.188    -4.420     0.200
     3.114    -5.772     0.200
     0.526     2.436     0.200
     0.658     0.003     0.200
     0.593     0.063     0.200
     0.592    -0.037     0.200
     1.036     0.603     0.200
     1.067     0.255     0.200
     1.224    -0.324     0.200
     1.224     0.016     0.200
     1.235     0.459     0.200
     1.618    -1.331     0.200
     1.596     0.665     0.200
     0.566     0.147     0.200
     0.565     0.214     0.200
     0.802     0.523     0.200
     0.797     1.058     0.200
     0.797    -0.012     0.200
     0.970    -0.115     0.200
     0.968     0.421     0.200
     0.968     0.929     0.200
     0.987     1.164     0.200
     1.036     0.315     0.200
     1.028     0.174     0.200
     1.057     0.242     0.200
     1.105     1.049     0.200
     1.116     0.767     0.200
     1.197    -1.447     0.200
     1.197     0.428     0.200
     1.414    -2.913     0.200
     1.586    -2.174     0.200
     1.586     0.599     0.200
     0.507     2.668     0.200
     0.573    -0.109     0.200
     0.573     1.250     0.200
     0.573    -0.122     0.200
     0.680     0.860     0.200
     0.958     1.449     0.200
     1.053    -0.064     0.200
     1.053    -0.525     0.200
     1.028     0.220     0.200
     1.204    -0.382     0.200
     1.212     0.545     0.200
     1.286    -0.594     0.200
     1.321    -0.245     0.200
     1.356     2.411     0.200
     1.606    -1.788     0.200
     1.606    -2.038     0.200
     1.776    -1.182     0.200
     0.551     0.431     0.200
     0.550     0.749     0.200
     0.550     1.155     0.200
     0.726     0.306     0.200
     0.824     0.532     0.200
     0.824     0.048     0.200
     0.949     2.712     0.200
     0.983     1.724     0.200
     1.048     0.380     0.200
     1.232    -0.042     0.200
     1.278    -0.807     0.200
     1.392    -1.085     0.200
     1.610    -1.309     0.200
     1.724    -0.533     0.200
     0.558     0.254     0.200
     0.558     0.384     0.200
     0.813     0.515     0.200
     0.923     1.357     0.200
     0.923     1.600     0.200
     0.998     1.130     0.200
     1.050     0.091     0.200
     1.050    -0.089     0.200
     1.250    -0.225     0.200
     1.331    -0.437     0.200
     1.411    -1.547     0.200
     1.609    -1.597     0.200
     3.167    -4.912     0.200
     0.566     0.366     0.200
     0.566     0.346     0.200
     0.943     0.857     0.200
     0.951     1.201     0.200
     1.026     1.005     0.200
     1.047     0.112     0.200
     1.281    -0.406     0.200
     1.442    -1.141     0.200
     1.602    -2.009     0.200
     1.063     0.418     0.200
     1.197    -0.244     0.200
     1.197    -0.424     0.200
     1.279     0.170     0.200
     1.279    -0.489     0.200
     1.567    -2.055     0.200
     1.567    -2.526     0.200
     2.001    -3.617     0.200
     2.788    -7.476     0.200
     0.514     0.796     0.200
     0.690     0.630     0.200
     0.690     0.750     0.200
     0.708     0.319     0.200
     1.102    -0.004     0.200
     1.102    -0.144     0.200
     1.222    -1.022     0.200
     1.327    -0.257     0.200
     1.327     0.423     0.200
     1.326    -0.821     0.200
     1.412    -0.088     0.200
     1.550    -0.300     0.200
     1.614    -1.288     0.200
     0.554     0.215     0.200
     0.757     0.996     0.200
     0.678     1.477     0.200
     0.840     0.458     0.200
     0.834     1.497     0.200
     0.845     0.796     0.200
     0.867     0.693     0.200
     0.931    -0.676     0.200
     0.991     1.287     0.200
     1.068    -1.026     0.200
     1.068    -0.361     0.200
     1.179    -1.970     0.200
     1.635    -3.139     0.200
     0.593     0.870     0.200
     0.642     1.112     0.200
     0.642     0.871     0.200
     0.642     0.442     0.200
     1.013     0.016     0.200
     1.270    -1.037     0.200
     1.251     3.196     0.200
     1.251     0.664     0.200
     1.251     0.926     0.200
     1.322    -0.671     0.200
     1.466     0.843     0.200
     1.520    -2.073     0.200
     2.228    -2.959     0.200
     2.291    -4.124     0.200
     3.175    -7.291     0.200
     0.630     1.220     0.200
     0.630    -0.987     0.200
     0.601     0.838     0.200
     1.008    -0.320     0.200
     1.242    -0.680     0.200
     1.520    -2.586     0.200
     0.654     0.810     0.200
     0.653     0.832     0.200
     0.653     0.035     0.200
     1.019    -0.326     0.200
     1.280    -0.849     0.200
     1.261    -1.542     0.200
     1.261     0.817     0.200
     1.382    -0.824     0.200
     1.524    -2.594     0.200
     3.169    -8.722     0.200
     1.039     1.306     0.200
     1.013    -0.131     0.200
     1.299    -2.070     0.200
     1.260    -1.412     0.200
     1.260     0.877     0.200
     1.260     2.807     0.200
     1.450    -3.035     0.200
     1.390    -2.056     0.200
     1.513    -3.256     0.200
     1.513    -2.577     0.200
     1.513    -3.475     0.200
     0.539     0.842     0.200
     0.682     0.037     0.200
     0.682     0.034     0.200
     0.960     0.803     0.200
     1.099    -0.761     0.200
     1.108     0.731     0.200
     1.132     0.301     0.200
     1.128    -0.066     0.200
     1.170    -0.977     0.200
     1.371     0.050     0.200
     1.495    -1.265     0.200
     0.604     0.628     0.200
     0.604     0.889     0.200
     1.026    -0.166     0.200
     1.026     0.045     0.200
     1.165    -0.352     0.200
     1.229    -1.504     0.200
     1.416    -2.250     0.200
     1.557    -2.797     0.200
     1.816    -3.448     0.200
     0.602     1.263     0.200
     0.602     0.881     0.200
     0.603     0.945     0.200
     0.620     0.970     0.200
     0.769     0.250     0.200
     1.064     1.185     0.200
     1.079    -0.400     0.200
     1.033    -0.329     0.200
     1.033     0.460     0.200
     1.145     0.850     0.200
     1.209    -0.104     0.200
     1.229    -1.186     0.200
     1.229     0.502     0.200
     1.292    -0.480     0.200
     1.408     0.419     0.200
     1.453    -2.534     0.200
     1.413    -0.757     0.200
     1.567     0.070     0.200
     0.348     0.665     0.200
     0.348     0.922     0.200
     1.228    -0.240     0.200
     1.228     0.799     0.200
     1.192    -0.242     0.200
     1.192    -0.523     0.200
     1.382     0.185     0.200
     0.624     1.873     0.200
     0.601    -0.606     0.200
     0.600     1.287     0.200
     0.621     1.142     0.200
     1.065     1.086     0.200
     1.066     0.913     0.200
     1.066     1.034     0.200
     1.030    -0.270     0.200
     1.126     0.570     0.200
     1.148     0.162     0.200
     1.210     1.702     0.200
     1.226    -1.180     0.200
     1.226    -0.692     0.200
     1.410     0.752     0.200
     1.411    -0.584     0.200
     1.570    -0.588     0.200
     1.563    -2.545     0.200
     1.563     0.646     0.200
     1.617    -0.870     0.200
     3.801    -6.562     0.200
     4.643   -11.906     0.200
     0.369     0.903     0.200
     0.369     1.384     0.200
     1.201    -0.930     0.200
     1.201    -0.230     0.200
     1.201    -1.399     0.200
     1.266    -1.839     0.200
     1.266    -1.099     0.200
     1.365    -0.807     0.200
     1.365    -0.036     0.200
     1.350    -0.408     0.200
     1.638    -2.818     0.200
     1.638     0.651     0.200
     1.638     1.321     0.200
     1.572    -0.145     0.200
     1.896    -4.322     0.200
     0.603     1.024     0.200
     0.618     0.877     0.200
     0.780     0.086     0.200
     1.015     0.311     0.200
     1.225     0.481     0.200
     1.225     1.243     0.200
     1.225     2.192     0.200
     1.242     2.243     0.200
     1.309     0.373     0.200
     1.421     2.379     0.200
     1.541    -0.946     0.200
     1.561    -0.149     0.200
     0.618     0.695     0.200
     0.618     0.404     0.200
     0.604     1.273     0.200
     0.770     0.486     0.200
     1.238     0.170     0.200
     1.238     2.682     0.200
     1.238     0.463     0.200
     1.325    -0.032     0.200
     1.547    -0.931     0.200
     1.547     0.729     0.200
     0.602     0.780     0.200
     0.619     0.610     0.200
     0.618     0.611     0.200
     1.088     1.870     0.200
     1.039    -0.424     0.200
     1.039     0.276     0.200
     1.090    -0.570     0.200
     1.167    -0.176     0.200
     1.235     1.642     0.200
     1.243    -0.216     0.200
     1.243     2.483     0.200
     1.243     0.335     0.200
     1.314    -0.151     0.200
     1.568    -2.211     0.200
     1.568    -1.679     0.200
     2.550    -4.223     0.200
     3.147    -4.887     0.200
     0.597     1.202     0.200
     0.624     0.390     0.200
     0.623     0.240     0.200
     0.762     0.309     0.200
     1.032     0.494     0.200
     1.032     0.275     0.200
     1.193    -0.792     0.200
     1.245    -0.381     0.200
     1.245     0.283     0.200
     1.556    -2.761     0.200
     1.556    -2.355     0.200
     0.578     0.972     0.200
     0.643     0.141     0.200
     0.643     0.040     0.200
     0.740     0.379     0.200
     1.054    -0.311     0.200
     1.054    -0.029     0.200
     1.265    -0.331     0.200
     1.265     1.189     0.200
     1.342     0.186     0.200
     1.578     0.636     0.200
     1.655    -1.350     0.200
     1.925    -2.310     0.200
     0.683     0.945     0.200
     0.988     0.123     0.200
     1.167    -0.756     0.200
     1.246    -1.972     0.200
     1.479    -3.036     0.200
     1.479    -2.527     0.200
     1.465    -0.850     0.200
     1.690    -4.076     0.200
     1.690    -3.766     0.200
     1.886    -4.067     0.200
     0.578     0.048     0.200
     0.578     0.080     0.200
     0.816     0.886     0.200
     0.784     0.313     0.200
     0.978     1.117     0.200
     0.983    -1.046     0.200
     0.983    -0.187     0.200
     1.001     0.374     0.200
     1.040     0.613     0.200
     1.040     0.491     0.200
     1.064    -0.249     0.200
     1.044    -0.268     0.200
     1.209    -0.517     0.200
     1.209    -0.150     0.200
     1.209     1.221     0.200
     1.371    -0.338     0.200
     2.037    -1.508     0.200
     0.368     2.439     0.200
     0.928    -0.922     0.200
     0.928    -0.312     0.200
     0.834     0.250     0.200
     0.807     0.559     0.200
     0.821     0.940     0.200
     0.962    -1.342     0.200
     0.944     0.758     0.200
     0.951     1.518     0.200
     0.982     0.272     0.200
     0.982     0.162     0.200
     1.059     1.093     0.200
     1.169    -0.020     0.200
     1.671    -0.486     0.200
     1.752    -0.006     0.200
     1.849    -0.524     0.200
     1.930    -1.138     0.200
     2.085    -1.015     0.200
     2.127    -1.917     0.200
     2.157    -1.241     0.200
     2.174    -1.166     0.200
     2.260    -1.359     0.200
     2.312    -1.205     0.200
     2.319    -1.889     0.200
     2.444    -2.330     0.200
     3.291    -7.001     0.200
     0.802     0.205     0.200
     0.828     0.411     0.200
     0.816     0.783     0.200
     0.928    -2.175     0.200
     0.928    -1.005     0.200
     0.986     0.001     0.200
     0.986    -0.109     0.200
     1.305    -2.935     0.200
     1.477    -1.250     0.200
     1.542    -2.359     0.200
     0.236     0.582     0.200
     0.354     2.432     0.200
     0.565     1.298     0.200
     0.642    -0.073     0.200
     0.755     0.388     0.200
     0.945     0.436     0.200
     1.088    -0.361     0.200
     1.088    -0.591     0.200
     1.351    -0.726     0.200
     1.437    -1.136     0.200
     1.662    -2.044     0.200
     1.689    -1.880     0.200
     0.238     0.809     0.200
     0.238     0.827     0.200
     0.967    -0.084     0.200
     1.123    -1.350     0.200
     1.225    -1.702     0.200
     1.334    -2.257     0.200
     1.430    -1.508     0.200
     1.475    -1.730     0.200
     1.929    -2.495     0.200
     1.963    -3.532     0.200
     0.387     1.038     0.200
     0.473    -1.216     0.200
     0.826     0.630     0.200
     0.840     0.964     0.200
     0.849     1.331     0.200
     0.849     0.894     0.200
     0.892     0.449     0.200
     0.971     1.274     0.200
     0.972    -0.797     0.200
     0.912     0.101     0.200
     0.912     0.660     0.200
     1.036     0.528     0.200
     0.987     0.622     0.200
     0.987    -0.109     0.200
     0.987     1.172     0.200
     1.099    -1.549     0.200
     1.230     2.904     0.200
     1.314    -1.873     0.200
     1.954    -5.351     0.200
     0.651     1.930     0.200
     0.841     1.111     0.200
     0.834     1.450     0.200
     0.884     0.657     0.200
     0.964    -1.204     0.200
     0.964    -0.673     0.200
     0.956     1.034     0.200
     0.913    -0.212     0.200
     0.913     0.366     0.200
     0.964     0.650     0.200
     0.992     0.251     0.200
     0.992    -0.538     0.200
     1.075     0.124     0.200
     1.174    -1.319     0.200
     1.100    -1.449     0.200
     1.100    -1.890     0.200
     1.100     0.661     0.200
     1.229    -2.532     0.200
     0.497     0.886     0.200
     0.846     0.947     0.200
     0.842     2.058     0.200
     0.891     1.178     0.200
     0.891     1.319     0.200
     0.965     1.109     0.200
     0.965     1.381     0.200
     0.890    -0.265     0.200
     1.012     0.483     0.200
     1.094     0.422     0.200
     1.094     2.734     0.200
     1.122    -1.476     0.200
     1.122     0.934     0.200
     1.122     1.384     0.200
     1.179    -0.209     0.200
     0.533     0.117     0.200
     0.534     0.359     0.200
     0.857     1.373     0.200
     0.857     0.916     0.200
     0.877     1.147     0.200
     0.856     2.041     0.200
     0.850     1.440     0.200
     0.914     0.296     0.200
     1.042    -0.245     0.200
     0.991     0.859     0.200
     1.160    -0.337     0.200
     1.160    -0.606     0.200
     1.160     0.136     0.200
     1.134     0.288     0.200
     1.117     0.373     0.200
     1.279    -0.508     0.200
     0.794     0.344     0.200
     0.924    -0.594     0.200
     0.924    -0.453     0.200
     0.924     0.387     0.200
     0.943     0.015     0.200
     0.997     0.468     0.200
     0.997    -0.142     0.200
     1.095     0.991     0.200
     1.095     1.433     0.200
     1.095     2.093     0.200
     1.149    -0.426     0.200
     1.216    -1.624     0.200
     1.216    -1.116     0.200
     1.216    -1.777     0.200
     1.306    -1.622     0.200
     1.292    -0.312     0.200
     0.489     0.508     0.200
     0.817     0.697     0.200
     0.833     1.150     0.200
     0.902    -1.990     0.200
     0.902    -1.162     0.200
     0.902     0.459     0.200
     0.952    -0.218     0.200
     1.007     0.237     0.200
     1.007    -0.361     0.200
     1.113    -0.647     0.200
     1.113     1.455     0.200
     1.292    -1.911     0.200
     1.433    -2.804     0.200
     1.483    -3.407     0.200
     1.947     0.617     0.200
     0.762     0.749     0.200
     0.696     0.719     0.200
     1.197     1.166     0.200
     1.197     0.588     0.200
     1.071     0.484     0.200
     1.071     1.355     0.200
     1.264     0.295     0.200
     1.387     1.533     0.200
     1.308    -0.248     0.200
     1.308     0.862     0.200
     1.415    -0.602     0.200
     1.415    -0.453     0.200
     1.519     1.833     0.200
     2.337    -3.755     0.200
     0.953     2.329     0.200
     0.725    -0.035     0.200
     1.167    -0.466     0.200
     1.514     0.055     0.200
     1.598     1.371     0.200
     1.564    -1.097     0.200
     1.845    -1.201     0.200
     0.620     0.454     0.200
     1.018     2.712     0.200
     1.018    -0.208     0.200
     1.032    -0.473     0.200
     1.039     1.062     0.200
     1.092    -0.024     0.200
     1.072    -0.340     0.200
     1.072     0.290     0.200
     1.072    -0.800     0.200
     1.086     0.336     0.200
     1.250    -0.070     0.200
     1.250     0.700     0.200
     1.250     1.001     0.200
     1.250    -0.840     0.200
     1.286     0.360     0.200
     0.619    -0.351     0.200
     1.075    -0.762     0.200
     1.075     0.299     0.200
     1.005     2.615     0.200
     1.040     1.019     0.200
     1.079    -0.155     0.200
     1.250    -0.491     0.200
     1.250     1.578     0.200
EOF
gmt end
