#!/bin/bash
gmt begin penasco2.16_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional penasco2.16'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.526
    15.000    42.247
    15.500    41.966
    16.000    41.682
    16.500    41.392
    17.000    41.096
    17.500    40.791
    18.000    40.476
    18.500    40.149
    19.000    39.807
    19.500    39.449
    20.000    39.071
    20.500    38.672
    21.000    38.250
    21.500    37.802
    22.000    37.326
    22.500    36.820
    23.000    36.282
    23.500    35.711
    24.000    34.491
    24.500    33.219
    25.000    31.938
    25.500    30.645
    26.000    29.343
    26.500    28.028
    27.000    26.701
    27.500    25.358
    28.000    23.995
    28.500    22.616
    29.000    21.226
    29.500    19.827
    30.000    18.421
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    20.995 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500     5.112
     1.000     6.376
     1.500     7.640
     2.000     8.904
     2.500    10.168
     3.000    11.432
     3.500    12.696
     4.000    13.958
     4.500    15.219
     5.000    16.479
     5.500    17.738
     6.000    18.995
     6.500    20.251
     7.000    21.505
     7.500    22.757
     8.000    24.008
     8.500    25.256
     9.000    26.502
     9.500    27.746
    10.000    28.746
    10.500    29.674
    11.000    30.589
    11.500    31.486
    12.000    32.361
    12.500    33.214
    13.000    34.041
    13.500    34.841
    14.000    35.611
    14.500    36.350
    15.000    37.057
    15.500    37.731
    16.000    38.297
    16.500    38.799
    17.000    39.242
    17.500    39.654
    18.000    40.000
    18.500    40.289
    19.000    40.520
    19.500    40.692
    20.000    40.806
    20.500    40.861
    21.000    40.856
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    31.041 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.944
     1.000     6.845
     1.500     9.543
     2.000    12.240
     2.500    14.938
     3.000    17.634
     3.500    20.329
     4.000    23.024
     4.500    25.717
     5.000    28.409
     5.500    31.100
     6.000    33.788
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    26.409 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500    13.135
     1.000    19.659
     1.500    26.184
     2.000    32.708
     2.500    39.233
     3.000    45.757
     3.500    52.279
     4.000    58.796
     4.500    65.313
     5.000    71.824
     5.500    78.334
     6.000    84.838
     6.500    91.341
     7.000    97.837
     7.500   104.328
     8.000   110.813
     8.500   117.294
     9.000   123.768
     9.500   130.236
    10.000   136.696
    10.500   143.150
    11.000   149.596
    11.500   156.034
    12.000   162.465
    12.500   168.886
    13.000   175.298
    13.500   181.701
    14.000   188.091
    14.500   194.468
    15.000   200.834
    15.500   207.186
    16.000   213.527
    16.500   219.853
    17.000   226.167
    17.500   234.408
    18.000   240.680
    18.500   246.939
    19.000   253.185
    19.500   259.417
    20.000   265.636
    20.500   271.840
    21.000   278.030
    21.500   284.204
    22.000   290.363
    22.500   296.505
    23.000   302.632
    23.500   308.742
    24.000   314.834
    24.500   320.909
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    56.796 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    11.096
     1.000    20.408
     1.500    29.363
     2.000    38.319
     2.500    47.273
     3.000    56.226
     3.500    65.177
     4.000    74.126
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    63.177 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    15.902   338.186     0.150
    18.751    47.864     0.150
    15.917   230.706     0.150
    16.372   233.231     0.150
    16.576   334.210     0.150
    17.332    46.690     0.150
    17.070   239.229     0.150
    17.055    45.713     0.150
    26.003   306.545     0.150
    24.356   297.164     0.150
    24.356   472.089     0.150
    16.129   333.110     0.150
    23.596   473.402     0.150
    18.058    47.550     0.150
    18.190    47.512     0.150
    23.195   288.225     0.150
     3.067   796.116     0.150
    17.231    47.691     0.150
    18.889    51.198     0.150
    18.535    49.517     0.150
    17.629    47.493     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    16.747    43.424     0.200
    23.092    37.686     0.200
    14.518    41.593     0.200
    14.750    41.974     0.200
    14.780    41.601     0.200
    14.766    43.741     0.200
    14.941    42.175     0.200
    14.943    41.826     0.200
    14.945    43.294     0.200
    14.964    42.599     0.200
    15.045    42.473     0.200
    15.048    43.007     0.200
    15.064    42.601     0.200
    15.153    42.796     0.200
    15.489    42.092     0.200
    15.823    44.128     0.200
    15.956    42.999     0.200
    15.992    42.955     0.200
    16.065    42.053     0.200
    16.068    42.344     0.200
    16.137    42.813     0.200
    16.320    42.286     0.200
    16.348    45.599     0.200
    16.624    43.075     0.200
    16.887    44.178     0.200
    16.907    43.010     0.200
    16.993    42.978     0.200
    17.006    43.452     0.200
    17.215    43.311     0.200
    17.249    43.619     0.200
    17.264    42.463     0.200
    17.327    42.740     0.200
    17.330    42.713     0.200
    17.527    43.648     0.200
    17.587    42.484     0.200
    17.616    44.589     0.200
    17.846    42.850     0.200
    17.870    42.737     0.200
    17.935    43.401     0.200
    17.941    42.760     0.200
    18.052    42.710     0.200
    18.049    42.423     0.200
    18.068    43.132     0.200
    18.089    42.955     0.200
    18.163    43.151     0.200
    18.208    42.724     0.200
    18.298    43.875     0.200
    18.300    42.618     0.200
    18.387    41.636     0.200
    18.482    42.173     0.200
    18.547    41.216     0.200
    18.614    41.320     0.200
    18.718    41.059     0.200
    18.728    41.350     0.200
    18.732    40.895     0.200
    18.736    41.204     0.200
    18.797    41.369     0.200
    18.869    41.607     0.200
    18.898    42.095     0.200
    18.892    40.915     0.200
    18.948    41.882     0.200
    19.061    41.500     0.200
    19.138    41.518     0.200
    19.171    41.716     0.200
    19.189    41.727     0.200
    19.211    41.825     0.200
    19.270    41.360     0.200
    19.319    41.311     0.200
    19.332    41.125     0.200
    19.366    41.158     0.200
    19.379    41.517     0.200
    19.478    41.146     0.200
    19.649    41.018     0.200
    19.682    41.599     0.200
    19.683    41.436     0.200
    19.698    41.056     0.200
    19.744    41.093     0.200
    19.752    41.012     0.200
    19.785    41.542     0.200
    19.848    40.702     0.200
    19.900    41.626     0.200
    19.861    40.994     0.200
    20.062    41.116     0.200
    20.125    40.790     0.200
    20.177    40.411     0.200
    20.186    40.401     0.200
    20.202    41.073     0.200
    20.230    40.772     0.200
    20.242    40.474     0.200
    20.266    40.765     0.200
    20.298    40.779     0.200
    20.401    40.529     0.200
    20.388    39.528     0.200
    20.529    39.977     0.200
    20.600    40.207     0.200
    20.661    39.644     0.200
    20.704    39.432     0.200
    20.726    39.994     0.200
    20.718    40.354     0.200
    20.805    40.332     0.200
    20.914    39.797     0.200
    20.929    39.721     0.200
    20.966    39.971     0.200
    20.959    40.041     0.200
    21.115    39.511     0.200
    21.131    40.737     0.200
    21.148    39.591     0.200
    21.148    38.921     0.200
    21.196    38.949     0.200
    21.330    38.892     0.200
    21.336    39.597     0.200
    21.351    39.044     0.200
    21.436    39.307     0.200
    21.432    39.701     0.200
    21.506    39.205     0.200
    21.570    39.693     0.200
    21.665    40.323     0.200
    21.741    38.794     0.200
    21.745    39.016     0.200
    21.751    39.086     0.200
    21.760    38.133     0.200
    21.765    39.445     0.200
    21.793    38.776     0.200
    21.902    38.792     0.200
    22.109    39.336     0.200
    22.149    38.345     0.200
    22.157    38.514     0.200
    22.227    37.936     0.200
    22.313    38.023     0.200
    22.416    37.666     0.200
    22.543    37.326     0.200
    22.597    37.694     0.200
    22.654    37.829     0.200
    22.725    38.129     0.200
    22.781    38.517     0.200
    22.863    37.282     0.200
    22.886    37.731     0.200
    22.908    38.880     0.200
    23.002    37.272     0.200
    23.124    36.933     0.200
    23.124    37.550     0.200
    23.132    39.064     0.200
    23.178    36.133     0.200
    23.314    36.643     0.200
    23.362    37.640     0.200
    23.704    36.262     0.200
    24.342    35.928     0.200
    24.398    34.329     0.200
    24.398    35.270     0.200
    24.476    35.784     0.200
    24.540    34.938     0.200
    24.507    35.422     0.200
    24.559    34.032     0.200
    25.068    33.242     0.200
    25.068    33.496     0.200
    25.358    32.981     0.200
    25.510    31.654     0.200
    26.133    30.868     0.200
    26.133    31.643     0.200
    26.321    30.750     0.200
    26.321    30.350     0.200
    26.310    28.404     0.200
    26.310    31.392     0.200
    26.389    30.967     0.200
    27.406    28.086     0.200
    28.100    24.828     0.200
    28.100    25.623     0.200
    28.151    27.486     0.200
    28.947    24.704     0.200
    29.399    26.432     0.200
    29.451    23.095     0.200
    14.814    43.981     0.200
    15.137    42.349     0.200
    15.127    44.229     0.200
    15.268    44.044     0.200
    15.295    43.553     0.200
    15.515    41.763     0.200
    15.461    44.397     0.200
    15.673    42.511     0.200
    15.922    43.106     0.200
    16.161    42.233     0.200
    16.175    42.522     0.200
    16.310    42.346     0.200
    16.831    42.325     0.200
    17.654    43.271     0.200
    17.762    42.731     0.200
    17.762    43.055     0.200
    18.055    44.328     0.200
    18.161    42.820     0.200
    18.161    43.350     0.200
    18.410    40.144     0.200
    18.432    39.489     0.200
    18.451    41.029     0.200
    18.513    42.292     0.200
    18.492    40.825     0.200
    18.564    41.307     0.200
    18.628    40.462     0.200
    18.661    41.378     0.200
    18.661    39.948     0.200
    18.690    41.494     0.200
    18.682    39.733     0.200
    18.707    41.468     0.200
    18.759    40.686     0.200
    18.776    39.947     0.200
    18.838    41.512     0.200
    18.847    39.732     0.200
    18.862    41.045     0.200
    18.915    41.483     0.200
    18.929    41.909     0.200
    18.929    40.982     0.200
    18.942    41.991     0.200
    18.970    41.784     0.200
    18.970    41.234     0.200
    19.054    41.528     0.200
    19.088    41.036     0.200
    19.076    42.152     0.200
    19.127    40.960     0.200
    19.161    40.911     0.200
    19.212    40.262     0.200
    19.244    42.260     0.200
    19.228    40.120     0.200
    19.257    41.444     0.200
    19.308    41.399     0.200
    19.378    40.262     0.200
    19.419    40.079     0.200
    19.440    40.725     0.200
    19.472    39.658     0.200
    19.493    40.249     0.200
    19.493    38.744     0.200
    19.560    36.150     0.200
    19.599    40.361     0.200
    19.632    40.335     0.200
    19.656    41.672     0.200
    19.740    38.843     0.200
    19.775    39.001     0.200
    19.771    37.794     0.200
    19.821    39.502     0.200
    19.847    41.019     0.200
    19.869    38.668     0.200
    19.892    40.735     0.200
    19.928    38.724     0.200
    19.967    40.812     0.200
    20.064    36.831     0.200
    20.064    42.163     0.200
    20.100    40.431     0.200
    20.093    38.347     0.200
    20.133    40.889     0.200
    20.133    40.553     0.200
    20.141    41.857     0.200
    20.131    37.479     0.200
    20.193    41.402     0.200
    20.237    40.771     0.200
    20.298    40.132     0.200
    20.338    40.168     0.200
    20.376    39.494     0.200
    20.407    41.476     0.200
    20.388    39.973     0.200
    20.409    39.733     0.200
    20.455    40.569     0.200
    20.436    40.127     0.200
    20.492    38.492     0.200
    20.574    40.566     0.200
    20.553    40.718     0.200
    20.614    38.876     0.200
    20.664    38.056     0.200
    20.656    39.956     0.200
    20.806    40.614     0.200
    20.735    39.336     0.200
    20.742    39.381     0.200
    20.752    40.901     0.200
    20.785    38.675     0.200
    20.899    36.288     0.200
    20.889    41.231     0.200
    20.921    37.268     0.200
    21.013    39.058     0.200
    21.006    40.162     0.200
    21.010    39.367     0.200
    21.028    41.719     0.200
    21.038    40.826     0.200
    21.033    39.580     0.200
    21.033    40.287     0.200
    21.041    39.943     0.200
    21.085    39.906     0.200
    21.083    37.475     0.200
    21.171    40.063     0.200
    21.191    38.494     0.200
    21.205    38.785     0.200
    21.234    39.669     0.200
    21.234    38.518     0.200
    21.251    40.993     0.200
    21.250    38.709     0.200
    21.266    37.968     0.200
    21.288    37.236     0.200
    21.340    41.595     0.200
    21.379    40.502     0.200
    21.424    40.994     0.200
    21.460    39.045     0.200
    21.510    41.123     0.200
    21.504    38.940     0.200
    21.510    40.091     0.200
    21.533    38.215     0.200
    21.599    39.798     0.200
    21.583    38.858     0.200
    21.616    39.427     0.200
    21.631    41.224     0.200
    21.682    38.850     0.200
    21.704    40.624     0.200
    21.698    39.749     0.200
    21.688    41.167     0.200
    21.715    39.273     0.200
    21.751    40.869     0.200
    21.743    39.889     0.200
    21.750    40.679     0.200
    21.790    40.617     0.200
    21.832    39.736     0.200
    21.835    39.106     0.200
    21.860    38.935     0.200
    21.858    39.159     0.200
    21.888    40.248     0.200
    21.955    39.632     0.200
    22.001    40.120     0.200
    22.053    39.494     0.200
    22.062    39.559     0.200
    22.010    39.300     0.200
    22.064    40.026     0.200
    22.116    38.051     0.200
    22.105    38.320     0.200
    22.110    38.593     0.200
    22.158    39.110     0.200
    22.160    38.971     0.200
    22.202    38.008     0.200
    22.214    38.172     0.200
    22.276    37.494     0.200
    22.301    37.567     0.200
    22.301    39.005     0.200
    22.299    35.954     0.200
    22.313    37.319     0.200
    22.349    37.976     0.200
    22.400    38.358     0.200
    22.411    39.152     0.200
    22.403    37.555     0.200
    22.439    39.720     0.200
    22.476    39.600     0.200
    22.465    38.561     0.200
    22.465    38.779     0.200
    22.479    38.982     0.200
    22.511    39.296     0.200
    22.515    39.205     0.200
    22.515    37.006     0.200
    22.512    38.446     0.200
    22.561    37.668     0.200
    22.552    40.045     0.200
    22.543    37.717     0.200
    22.535    34.294     0.200
    22.540    38.467     0.200
    22.584    39.219     0.200
    22.676    40.437     0.200
    22.688    37.970     0.200
    22.695    38.026     0.200
    22.710    39.547     0.200
    22.781    38.702     0.200
    22.781    37.816     0.200
    22.864    38.099     0.200
    22.864    38.586     0.200
    22.917    38.265     0.200
    22.935    37.920     0.200
    23.006    37.773     0.200
    23.003    40.062     0.200
    22.980    37.389     0.200
    23.012    37.052     0.200
    23.012    36.743     0.200
    23.054    37.940     0.200
    23.057    37.469     0.200
    23.076    35.892     0.200
    23.064    36.902     0.200
    23.109    37.697     0.200
    23.151    37.495     0.200
    23.152    36.933     0.200
    23.201    38.761     0.200
    23.214    37.193     0.200
    23.248    38.478     0.200
    23.240    36.499     0.200
    23.393    38.987     0.200
    23.400    38.152     0.200
    23.432    35.467     0.200
    23.478    37.677     0.200
    23.465    37.401     0.200
    23.494    35.896     0.200
    23.543    38.118     0.200
    23.539    38.344     0.200
    23.543    36.934     0.200
    23.575    36.552     0.200
    23.636    38.152     0.200
    23.732    37.033     0.200
    23.822    35.110     0.200
    23.822    35.527     0.200
    23.814    35.406     0.200
    23.851    37.334     0.200
    23.928    34.035     0.200
    23.929    36.844     0.200
    24.001    36.188     0.200
    23.983    35.405     0.200
    24.015    35.340     0.200
    24.014    35.707     0.200
    24.075    35.293     0.200
    24.134    35.556     0.200
    24.250    34.599     0.200
    24.327    35.591     0.200
    24.355    37.970     0.200
    24.421    36.626     0.200
    24.539    37.170     0.200
    25.555    32.131     0.200
    25.710    32.698     0.200
    25.710    30.991     0.200
    14.051    41.785     0.200
    14.264    42.513     0.200
    14.317    41.676     0.200
    14.799    43.739     0.200
    14.803    46.117     0.200
    15.650    43.009     0.200
    15.851    47.381     0.200
    16.597    43.167     0.200
    17.056    45.007     0.200
    17.147    42.602     0.200
    17.496    45.582     0.200
    17.597    42.599     0.200
    17.720    43.149     0.200
    17.704    44.003     0.200
    17.827    42.625     0.200
    18.049    43.097     0.200
    18.165    42.634     0.200
    18.492    39.436     0.200
    18.477    40.554     0.200
    18.486    41.341     0.200
    18.502    39.379     0.200
    18.523    40.184     0.200
    18.535    39.599     0.200
    18.578    41.506     0.200
    18.699    40.837     0.200
    18.750    40.740     0.200
    18.725    40.820     0.200
    18.803    40.221     0.200
    18.869    38.946     0.200
    18.882    40.104     0.200
    18.884    40.572     0.200
    18.884    39.535     0.200
    18.962    39.694     0.200
    18.971    39.476     0.200
    18.960    39.648     0.200
    18.970    40.168     0.200
    19.045    40.204     0.200
    19.023    41.731     0.200
    19.089    41.009     0.200
    19.166    41.160     0.200
    19.188    41.283     0.200
    19.204    40.606     0.200
    19.237    40.631     0.200
    19.258    40.832     0.200
    19.273    40.234     0.200
    19.292    41.218     0.200
    19.327    41.750     0.200
    19.353    41.530     0.200
    19.303    42.197     0.200
    19.405    41.492     0.200
    19.364    42.051     0.200
    19.456    40.129     0.200
    19.469    40.270     0.200
    19.480    40.152     0.200
    19.526    40.042     0.200
    19.588    40.779     0.200
    19.643    41.277     0.200
    19.666    40.900     0.200
    19.690    40.549     0.200
    19.705    40.349     0.200
    19.763    39.063     0.200
    19.813    40.511     0.200
    19.846    39.390     0.200
    19.894    40.954     0.200
    19.911    40.262     0.200
    19.933    41.621     0.200
    19.944    40.897     0.200
    19.979    41.287     0.200
    20.046    39.237     0.200
    20.047    41.208     0.200
    20.047    39.950     0.200
    20.081    39.611     0.200
    20.129    40.599     0.200
    20.151    40.523     0.200
    20.155    39.546     0.200
    20.140    40.138     0.200
    20.146    40.736     0.200
    20.168    40.560     0.200
    20.184    41.426     0.200
    20.184    39.809     0.200
    20.267    40.118     0.200
    20.276    40.094     0.200
    20.265    38.482     0.200
    20.285    40.461     0.200
    20.328    39.244     0.200
    20.339    40.599     0.200
    20.361    38.981     0.200
    20.426    40.963     0.200
    20.423    40.620     0.200
    20.449    39.692     0.200
    20.443    40.600     0.200
    20.466    38.522     0.200
    20.467    40.825     0.200
    20.467    39.739     0.200
    20.541    38.082     0.200
    20.572    40.186     0.200
    20.569    40.032     0.200
    20.615    38.594     0.200
    20.617    40.525     0.200
    20.627    39.813     0.200
    20.715    39.583     0.200
    20.773    39.818     0.200
    20.777    39.417     0.200
    20.774    41.002     0.200
    20.793    39.996     0.200
    20.784    40.427     0.200
    20.827    40.689     0.200
    20.913    40.357     0.200
    20.914    39.944     0.200
    20.868    41.022     0.200
    20.936    40.202     0.200
    20.954    39.887     0.200
    21.018    39.240     0.200
    21.057    39.465     0.200
    21.057    38.777     0.200
    21.050    40.299     0.200
    21.060    39.382     0.200
    21.065    38.971     0.200
    21.085    43.569     0.200
    21.081    39.503     0.200
    21.080    39.291     0.200
    21.084    40.407     0.200
    21.084    39.641     0.200
    21.156    38.738     0.200
    21.226    38.873     0.200
    21.237    38.250     0.200
    21.267    38.416     0.200
    21.272    40.477     0.200
    21.272    39.922     0.200
    21.275    39.991     0.200
    21.275    40.749     0.200
    21.292    39.549     0.200
    21.306    40.526     0.200
    21.302    39.356     0.200
    21.299    40.217     0.200
    21.399    39.066     0.200
    21.387    41.369     0.200
    21.482    38.851     0.200
    21.538    38.349     0.200
    21.549    39.798     0.200
    21.549    38.970     0.200
    21.570    39.783     0.200
    21.616    39.392     0.200
    21.650    40.118     0.200
    21.656    39.901     0.200
    21.705    38.814     0.200
    21.682    39.304     0.200
    21.740    38.150     0.200
    21.741    39.544     0.200
    21.753    38.709     0.200
    21.773    38.131     0.200
    21.805    38.513     0.200
    21.799    38.627     0.200
    21.870    39.319     0.200
    21.878    39.306     0.200
    21.896    38.864     0.200
    21.901    38.506     0.200
    21.950    39.676     0.200
    21.978    40.471     0.200
    21.969    43.076     0.200
    21.969    38.725     0.200
    21.970    36.967     0.200
    22.045    38.019     0.200
    22.074    38.810     0.200
    22.130    39.496     0.200
    22.105    39.438     0.200
    22.105    38.907     0.200
    22.115    38.083     0.200
    22.138    38.963     0.200
    22.120    38.290     0.200
    22.165    38.772     0.200
    22.186    39.866     0.200
    22.224    38.929     0.200
    22.243    36.487     0.200
    22.242    38.927     0.200
    22.321    38.826     0.200
    22.319    38.105     0.200
    22.337    38.170     0.200
    22.349    42.622     0.200
    22.349    37.966     0.200
    22.341    39.553     0.200
    22.341    38.115     0.200
    22.394    37.192     0.200
    22.428    37.312     0.200
    22.450    38.644     0.200
    22.493    40.098     0.200
    22.494    38.614     0.200
    22.491    38.333     0.200
    22.517    37.104     0.200
    22.560    37.337     0.200
    22.560    37.314     0.200
    22.553    37.645     0.200
    22.561    38.481     0.200
    22.561    37.660     0.200
    22.599    37.583     0.200
    22.587    38.968     0.200
    22.635    38.328     0.200
    22.710    39.208     0.200
    22.730    39.288     0.200
    22.726    37.229     0.200
    22.758    36.962     0.200
    22.814    37.076     0.200
    22.820    37.329     0.200
    22.886    37.563     0.200
    22.874    37.252     0.200
    22.911    37.941     0.200
    22.971    38.272     0.200
    22.964    36.407     0.200
    22.998    37.678     0.200
    23.004    39.244     0.200
    23.004    38.416     0.200
    23.032    38.554     0.200
    23.032    37.804     0.200
    23.071    37.592     0.200
    23.055    37.263     0.200
    23.096    36.581     0.200
    23.109    36.883     0.200
    23.131    37.879     0.200
    23.182    38.939     0.200
    23.182    37.587     0.200
    23.188    38.804     0.200
    23.188    37.476     0.200
    23.219    36.912     0.200
    23.254    37.434     0.200
    23.267    36.938     0.200
    23.250    37.753     0.200
    23.292    38.036     0.200
    23.314    37.852     0.200
    23.314    37.704     0.200
    23.359    36.688     0.200
    23.393    38.207     0.200
    23.420    38.145     0.200
    23.453    38.314     0.200
    23.478    36.101     0.200
    23.516    37.872     0.200
    23.516    36.403     0.200
    23.506    36.526     0.200
    23.531    38.445     0.200
    23.572    36.815     0.200
    23.600    36.938     0.200
    23.612    37.130     0.200
    23.606    37.122     0.200
    23.606    36.115     0.200
    23.683    36.858     0.200
    23.677    36.983     0.200
    23.696    38.901     0.200
    23.686    37.012     0.200
    23.686    36.254     0.200
    23.710    42.636     0.200
    23.710    35.988     0.200
    23.720    36.227     0.200
    23.763    36.831     0.200
    23.768    37.855     0.200
    23.768    36.550     0.200
    23.847    37.020     0.200
    23.867    36.038     0.200
    23.859    37.679     0.200
    23.859    35.773     0.200
    23.866    35.306     0.200
    23.890    36.670     0.200
    23.882    34.577     0.200
    23.882    35.124     0.200
    23.929    37.224     0.200
    23.929    36.208     0.200
    23.955    37.903     0.200
    24.014    36.446     0.200
    24.016    37.116     0.200
    24.026    37.962     0.200
    23.970    36.651     0.200
    23.970    37.245     0.200
    24.049    36.320     0.200
    24.053    34.990     0.200
    24.080    36.279     0.200
    24.072    34.755     0.200
    24.066    35.521     0.200
    24.107    35.959     0.200
    24.157    36.401     0.200
    24.181    35.368     0.200
    24.286    35.725     0.200
    24.297    35.333     0.200
    24.359    36.056     0.200
    24.373    36.071     0.200
    24.375    36.423     0.200
    24.415    35.597     0.200
    24.445    36.139     0.200
    24.445    34.725     0.200
    24.458    35.453     0.200
    24.427    35.306     0.200
    24.461    36.596     0.200
    24.461    34.510     0.200
    24.508    38.828     0.200
    24.473    35.475     0.200
    24.534    35.489     0.200
    24.554    35.393     0.200
    24.579    34.559     0.200
    24.589    42.354     0.200
    24.589    35.729     0.200
    24.638    33.425     0.200
    24.724    35.202     0.200
    24.722    41.153     0.200
    24.722    35.036     0.200
    24.749    33.840     0.200
    24.771    34.451     0.200
    24.813    35.036     0.200
    24.813    33.607     0.200
    24.849    35.618     0.200
    24.849    35.391     0.200
    24.875    35.114     0.200
    24.875    35.371     0.200
    24.897    33.931     0.200
    24.911    33.828     0.200
    24.918    33.533     0.200
    24.923    33.324     0.200
    24.963    34.766     0.200
    24.963    33.391     0.200
    24.993    34.078     0.200
    24.987    33.638     0.200
    25.118    35.520     0.200
    25.192    33.111     0.200
    25.194    33.172     0.200
    25.233    33.976     0.200
    25.245    33.411     0.200
    25.276    35.109     0.200
    25.276    32.734     0.200
    25.296    33.127     0.200
    25.412    33.765     0.200
    25.471    33.262     0.200
    25.471    31.645     0.200
    25.471    34.031     0.200
    25.501    33.835     0.200
    25.552    31.839     0.200
    25.585    33.110     0.200
    25.590    33.094     0.200
    25.576    31.830     0.200
    25.609    31.871     0.200
    25.620    31.214     0.200
    25.649    31.805     0.200
    25.692    32.631     0.200
    25.710    32.596     0.200
    25.696    32.338     0.200
    25.712    32.861     0.200
    25.737    34.031     0.200
    25.737    34.625     0.200
    25.827    30.527     0.200
    25.870    32.172     0.200
    25.891    33.862     0.200
    25.891    32.112     0.200
    25.897    31.513     0.200
    25.893    31.368     0.200
    25.909    31.107     0.200
    25.924    30.136     0.200
    25.973    32.485     0.200
    25.980    32.121     0.200
    25.980    31.887     0.200
    26.043    29.959     0.200
    26.068    30.517     0.200
    26.109    29.756     0.200
    26.134    28.546     0.200
    26.181    30.399     0.200
    26.184    31.366     0.200
    26.221    29.698     0.200
    26.219    30.658     0.200
    26.253    30.452     0.200
    26.405    31.646     0.200
    26.420    29.775     0.200
    26.426    28.762     0.200
    26.459    29.500     0.200
    26.471    28.425     0.200
    26.510    29.332     0.200
    26.560    30.533     0.200
    26.580    28.768     0.200
    26.615    29.221     0.200
    26.720    27.394     0.200
    26.862    28.577     0.200
    26.871    27.960     0.200
    26.902    29.753     0.200
    26.906    30.280     0.200
    26.916    28.684     0.200
    26.916    28.122     0.200
    27.102    27.530     0.200
    27.122    28.508     0.200
    27.303    26.979     0.200
    27.697    26.024     0.200
    27.718    26.246     0.200
    29.290    21.318     0.200
    29.508    26.724     0.200
    29.555    23.866     0.200
    29.627    27.553     0.200
    29.953    21.874     0.200
    29.953    21.608     0.200
    14.114    41.594     0.200
    14.148    40.966     0.200
    14.211    42.109     0.200
    14.356    41.383     0.200
    14.466    41.855     0.200
    14.584    41.569     0.200
    14.589    41.746     0.200
    14.983    42.691     0.200
    15.667    41.928     0.200
    15.699    43.505     0.200
    16.169    43.000     0.200
    16.433    42.878     0.200
    16.437    42.602     0.200
    16.673    45.545     0.200
    16.784    42.275     0.200
    16.859    42.294     0.200
    17.086    43.274     0.200
    17.222    45.617     0.200
    17.310    44.116     0.200
    17.624    42.397     0.200
    17.765    43.954     0.200
    18.027    43.367     0.200
    17.972    43.733     0.200
    18.283    44.421     0.200
    18.646    41.790     0.200
    18.939    40.668     0.200
    19.225    41.651     0.200
    19.311    40.575     0.200
    19.439    42.556     0.200
    19.584    41.559     0.200
    19.618    42.453     0.200
    19.962    41.277     0.200
    20.033    42.274     0.200
    20.198    41.490     0.200
    20.327    41.155     0.200
    20.684    41.065     0.200
    21.034    40.582     0.200
    21.118    40.970     0.200
    21.281    40.942     0.200
    21.392    40.640     0.200
    21.426    41.979     0.200
    21.733    39.447     0.200
    21.770    37.406     0.200
    21.921    41.086     0.200
    22.063    40.101     0.200
    22.236    38.170     0.200
    22.247    39.469     0.200
    22.634    40.375     0.200
    22.671    37.965     0.200
    22.768    37.730     0.200
    22.889    37.210     0.200
    22.989    37.667     0.200
    23.131    37.960     0.200
    23.328    37.296     0.200
    23.404    36.273     0.200
    23.638    37.332     0.200
    23.682    37.554     0.200
    23.776    37.191     0.200
    23.810    36.674     0.200
    23.802    37.626     0.200
    23.835    37.488     0.200
    23.883    37.026     0.200
    23.951    37.138     0.200
    24.048    36.485     0.200
    24.045    37.310     0.200
    24.059    36.608     0.200
    24.046    36.721     0.200
    24.098    35.861     0.200
    24.087    36.995     0.200
    24.140    37.131     0.200
    24.140    36.131     0.200
    24.170    35.745     0.200
    24.186    35.447     0.200
    24.318    34.781     0.200
    24.323    35.702     0.200
    24.590    35.153     0.200
    24.593    35.712     0.200
    24.634    34.987     0.200
    24.672    35.262     0.200
    24.941    34.962     0.200
    24.978    35.323     0.200
    25.051    34.637     0.200
    25.079    34.557     0.200
    25.075    33.962     0.200
    25.122    34.697     0.200
    25.222    33.769     0.200
    25.252    34.692     0.200
    25.593    32.061     0.200
    25.705    31.315     0.200
    25.721    31.571     0.200
    25.777    32.034     0.200
    25.841    32.070     0.200
    25.872    32.824     0.200
    25.872    32.262     0.200
    26.027    30.907     0.200
    26.057    31.332     0.200
    26.098    31.290     0.200
    26.114    31.217     0.200
    26.120    30.857     0.200
    26.340    30.587     0.200
    26.380    30.316     0.200
    26.480    29.854     0.200
    26.548    28.484     0.200
    26.535    29.812     0.200
    26.513    32.564     0.200
    26.583    30.459     0.200
    26.615    27.394     0.200
    26.646    28.351     0.200
    26.879    29.540     0.200
    27.025    27.211     0.200
    27.020    28.292     0.200
    27.079    27.945     0.200
    27.151    28.947     0.200
    27.292    28.737     0.200
    27.451    27.930     0.200
    27.501    28.061     0.200
    27.563    27.612     0.200
    27.849    27.667     0.200
    27.913    25.594     0.200
    28.556    25.004     0.200
    28.567    24.466     0.200
    28.665    24.584     0.200
    28.794    23.803     0.200
    28.990    23.546     0.200
    29.033    22.870     0.200
    29.361    22.911     0.200
    14.145    43.314     0.200
    14.184    41.291     0.200
    14.339    41.514     0.200
    14.339    41.933     0.200
    14.255    41.628     0.200
    14.255    42.663     0.200
    14.265    44.014     0.200
    14.400    42.140     0.200
    14.447    41.552     0.200
    14.513    44.414     0.200
    14.533    42.335     0.200
    14.541    47.227     0.200
    14.637    42.450     0.200
    14.644    44.716     0.200
    14.737    42.049     0.200
    14.896    44.312     0.200
    14.897    46.764     0.200
    14.991    44.278     0.200
    15.078    43.284     0.200
    15.129    45.606     0.200
    15.274    41.857     0.200
    15.251    47.321     0.200
    15.435    44.630     0.200
    15.545    43.383     0.200
    15.830    43.019     0.200
    15.936    42.018     0.200
    15.995    47.665     0.200
    16.330    43.266     0.200
    16.483    44.231     0.200
    16.498    43.487     0.200
    16.527    44.724     0.200
    16.580    44.605     0.200
    16.739    45.341     0.200
    16.836    41.732     0.200
    17.005    43.577     0.200
    17.135    44.315     0.200
    17.467    42.915     0.200
    17.506    45.064     0.200
    17.775    43.442     0.200
    17.841    44.112     0.200
    17.923    42.179     0.200
    18.007    44.490     0.200
    18.081    42.670     0.200
    18.081    43.225     0.200
    18.034    43.595     0.200
    18.353    42.978     0.200
    18.465    38.011     0.200
    18.509    41.719     0.200
    18.509    44.430     0.200
    18.729    40.242     0.200
    18.747    40.960     0.200
    19.021    42.405     0.200
    19.231    39.591     0.200
    20.415    40.819     0.200
    20.765    39.589     0.200
    20.743    41.124     0.200
    20.930    39.155     0.200
    21.101    38.088     0.200
    21.105    41.379     0.200
    21.183    36.057     0.200
    21.256    41.432     0.200
    21.257    42.758     0.200
    21.257    42.151     0.200
    21.325    41.072     0.200
    21.318    38.631     0.200
    21.376    39.840     0.200
    21.364    40.388     0.200
    21.372    40.652     0.200
    21.466    41.162     0.200
    21.487    39.764     0.200
    21.499    41.209     0.200
    21.486    42.033     0.200
    21.532    40.351     0.200
    21.560    39.154     0.200
    21.650    40.225     0.200
    21.815    39.823     0.200
    21.847    39.126     0.200
    21.881    39.563     0.200
    21.909    38.800     0.200
    21.935    41.194     0.200
    22.143    39.975     0.200
    22.314    41.074     0.200
    22.316    40.624     0.200
    22.389    39.656     0.200
    22.389    39.536     0.200
    22.390    39.993     0.200
    22.594    40.210     0.200
    22.594    39.082     0.200
    22.753    38.774     0.200
    22.753    38.664     0.200
    22.708    35.128     0.200
    22.708    40.535     0.200
    22.830    38.902     0.200
    22.830    38.693     0.200
    22.849    38.780     0.200
    22.968    39.321     0.200
    23.032    38.816     0.200
    23.069    38.058     0.200
    23.134    37.875     0.200
    23.203    39.678     0.200
    23.216    40.253     0.200
    23.216    40.529     0.200
    23.260    38.722     0.200
    23.404    39.975     0.200
    23.478    39.465     0.200
    23.708    39.525     0.200
    23.762    36.135     0.200
    23.855    36.440     0.200
    23.892    35.998     0.200
    23.869    38.552     0.200
    23.909    38.523     0.200
    23.966    36.553     0.200
    24.130    34.944     0.200
    24.127    31.545     0.200
    24.138    33.647     0.200
    24.138    36.712     0.200
    24.179    35.039     0.200
    24.176    37.820     0.200
    24.115    37.325     0.200
    24.115    37.221     0.200
    24.160    37.708     0.200
    24.247    37.526     0.200
    24.265    35.764     0.200
    24.398    36.140     0.200
    24.390    35.417     0.200
    24.431    35.434     0.200
    24.479    34.479     0.200
    24.666    35.420     0.200
    24.666    37.146     0.200
    24.716    36.071     0.200
    24.666    35.834     0.200
    24.741    36.005     0.200
    24.815    35.017     0.200
    25.029    34.288     0.200
    25.012    34.989     0.200
    25.012    37.208     0.200
    25.128    32.858     0.200
    25.128    34.863     0.200
    25.158    34.723     0.200
    25.143    34.879     0.200
    25.203    34.434     0.200
    25.207    35.081     0.200
    25.302    34.078     0.200
    25.325    35.272     0.200
    25.472    31.450     0.200
    25.469    34.420     0.200
    25.487    33.978     0.200
    25.377    33.526     0.200
    25.486    34.666     0.200
    25.541    32.989     0.200
    25.626    31.013     0.200
    25.637    34.669     0.200
    25.611    33.878     0.200
    25.663    31.601     0.200
    25.663    34.642     0.200
    25.710    34.182     0.200
    25.781    31.929     0.200
    25.785    31.277     0.200
    25.782    31.319     0.200
    25.782    32.497     0.200
    25.794    31.339     0.200
    25.860    32.151     0.200
    25.915    31.705     0.200
    25.955    29.848     0.200
    25.967    32.583     0.200
    25.945    32.595     0.200
    25.945    29.650     0.200
    26.100    31.957     0.200
    26.101    32.039     0.200
    26.136    32.343     0.200
    26.136    31.831     0.200
    26.168    28.550     0.200
    26.168    32.018     0.200
    26.189    30.799     0.200
    26.189    33.478     0.200
    26.186    30.540     0.200
    26.186    35.930     0.200
    26.281    27.803     0.200
    26.267    30.100     0.200
    26.323    31.559     0.200
    26.363    31.756     0.200
    26.420    30.909     0.200
    26.420    31.130     0.200
    26.447    30.994     0.200
    26.463    30.064     0.200
    26.507    30.845     0.200
    26.505    31.522     0.200
    26.630    28.134     0.200
    26.630    30.567     0.200
    26.608    31.300     0.200
    26.663    30.463     0.200
    26.661    27.534     0.200
    26.661    30.565     0.200
    26.531    31.761     0.200
    26.690    28.428     0.200
    26.710    29.679     0.200
    26.728    29.862     0.200
    26.728    29.669     0.200
    26.728    31.787     0.200
    26.957    29.640     0.200
    27.029    29.947     0.200
    27.082    29.373     0.200
    27.061    30.532     0.200
    27.107    29.710     0.200
    27.107    29.372     0.200
    27.087    28.931     0.200
    27.148    29.132     0.200
    27.158    29.395     0.200
    27.158    29.219     0.200
    27.158    29.626     0.200
    27.234    28.712     0.200
    27.234    28.415     0.200
    27.221    30.660     0.200
    27.326    29.693     0.200
    28.062    17.560     0.200
    28.062    20.130     0.200
    27.372    28.799     0.200
    27.367    27.244     0.200
    27.424    28.553     0.200
    27.481    29.200     0.200
    27.496    29.199     0.200
    27.523    26.753     0.200
    27.576    27.919     0.200
    27.640    25.358     0.200
    27.640    28.752     0.200
    27.699    27.779     0.200
    27.690    27.665     0.200
    27.673    27.633     0.200
    27.834    27.437     0.200
    27.809    27.666     0.200
    27.957    26.236     0.200
    27.921    28.263     0.200
    27.921    27.615     0.200
    27.985    27.489     0.200
    27.998    27.163     0.200
    27.998    26.897     0.200
    27.984    25.856     0.200
    28.027    24.811     0.200
    28.039    27.635     0.200
    28.033    25.164     0.200
    28.033    27.355     0.200
    28.083    25.494     0.200
    28.132    23.493     0.200
    28.170    27.146     0.200
    28.197    26.316     0.200
    28.229    22.028     0.200
    28.229    26.115     0.200
    28.233    22.811     0.200
    28.233    26.040     0.200
    28.243    26.619     0.200
    28.276    28.084     0.200
    28.374    26.711     0.200
    28.444    25.675     0.200
    28.492    25.617     0.200
    28.519    24.943     0.200
    28.483    25.860     0.200
    28.590    25.140     0.200
    28.636    25.397     0.200
    28.636    24.973     0.200
    28.639    25.441     0.200
    28.720    24.837     0.200
    28.711    23.409     0.200
    28.741    21.828     0.200
    28.741    25.677     0.200
    28.819    24.477     0.200
    28.873    21.423     0.200
    28.873    24.060     0.200
    28.947    24.032     0.200
    29.020    20.592     0.200
    29.020    24.639     0.200
    29.033    21.122     0.200
    29.067    22.615     0.200
    29.067    25.427     0.200
    29.116    23.686     0.200
    29.111    19.776     0.200
    29.111    23.950     0.200
    29.169    23.294     0.200
    29.173    24.892     0.200
    29.226    25.202     0.200
    29.360    21.973     0.200
    29.318    22.162     0.200
    29.386    23.284     0.200
    29.434    22.893     0.200
    29.433    22.927     0.200
    29.439    20.052     0.200
    29.439    22.484     0.200
    29.539    22.974     0.200
    29.527    23.285     0.200
    29.534    22.692     0.200
    29.534    22.581     0.200
    29.572    20.132     0.200
    29.639    21.204     0.200
    29.758    18.014     0.200
    29.758    22.570     0.200
    29.870    24.364     0.200
    14.314    42.262     0.200
    14.359    44.608     0.200
    14.553    41.506     0.200
    14.766    44.888     0.200
    15.037    45.037     0.200
    15.109    43.848     0.200
    15.395    43.354     0.200
    15.584    42.587     0.200
    15.751    42.973     0.200
    15.722    45.096     0.200
    15.792    44.628     0.200
    16.021    43.435     0.200
    16.093    45.205     0.200
    16.422    43.141     0.200
    17.048    43.701     0.200
    17.600    44.264     0.200
    17.862    42.929     0.200
    17.901    43.042     0.200
    17.901    43.405     0.200
    17.931    42.454     0.200
    17.902    43.186     0.200
    18.155    44.015     0.200
    18.345    43.415     0.200
    18.429    40.933     0.200
    18.752    41.702     0.200
    18.789    42.261     0.200
    19.263    42.027     0.200
    20.111    41.995     0.200
    20.342    41.335     0.200
    20.400    41.070     0.200
    20.433    39.876     0.200
    20.433    41.887     0.200
    20.676    40.142     0.200
    21.176    42.422     0.200
    21.322    38.856     0.200
    21.349    41.081     0.200
    21.558    41.253     0.200
    21.568    41.683     0.200
    22.347    38.420     0.200
    22.393    40.553     0.200
    22.603    37.357     0.200
    22.678    38.208     0.200
    22.678    39.118     0.200
    22.759    38.187     0.200
    22.759    40.375     0.200
    22.816    37.078     0.200
    23.009    39.239     0.200
    23.083    39.033     0.200
    23.295    37.758     0.200
    23.355    38.451     0.200
    23.976    37.383     0.200
    24.093    35.692     0.200
    24.093    36.063     0.200
    24.112    37.611     0.200
    24.125    35.179     0.200
    24.153    35.193     0.200
    24.282    35.287     0.200
    24.282    36.904     0.200
    24.660    33.579     0.200
    25.135    34.883     0.200
    25.206    34.170     0.200
    25.735    31.491     0.200
    25.788    32.120     0.200
    25.856    33.259     0.200
    26.003    32.245     0.200
    26.003    34.420     0.200
    26.240    29.839     0.200
    26.243    29.742     0.200
    26.692    29.870     0.200
    26.985    28.186     0.200
    27.085    27.571     0.200
    27.128    28.398     0.200
    27.181    27.138     0.200
    27.284    27.532     0.200
    27.448    27.977     0.200
    27.471    26.082     0.200
    27.493    26.514     0.200
    27.513    26.353     0.200
    27.566    27.026     0.200
    27.677    26.125     0.200
    27.718    25.144     0.200
    27.771    24.969     0.200
    27.856    25.260     0.200
    27.928    29.792     0.200
    27.983    25.831     0.200
    28.000    24.968     0.200
    28.023    25.350     0.200
    28.073    24.822     0.200
    28.090    25.298     0.200
    28.125    24.918     0.200
    28.237    24.948     0.200
    28.249    23.917     0.200
    28.262    24.663     0.200
    28.263    23.439     0.200
    28.356    24.700     0.200
    28.414    23.066     0.200
    28.492    23.632     0.200
    28.516    23.349     0.200
    28.558    23.475     0.200
    28.598    23.493     0.200
    28.651    24.001     0.200
    28.673    23.261     0.200
    28.763    23.154     0.200
    28.778    23.157     0.200
    28.788    23.098     0.200
    28.894    23.129     0.200
    28.977    22.746     0.200
    29.082    22.141     0.200
    29.089    22.264     0.200
    29.106    23.560     0.200
    29.132    22.656     0.200
    29.136    22.673     0.200
    29.207    21.660     0.200
    29.259    21.402     0.200
    29.300    22.240     0.200
    29.464    21.346     0.200
    29.539    20.866     0.200
    29.554    22.370     0.200
    29.624    20.775     0.200
    29.632    21.671     0.200
    29.678    22.084     0.200
    29.706    21.439     0.200
    29.709    21.151     0.200
    29.725    23.664     0.200
    29.754    21.807     0.200
    29.770    21.267     0.200
    14.056    41.273     0.200
    14.212    41.496     0.200
    14.212    42.028     0.200
    14.259    40.563     0.200
    14.257    42.890     0.200
    14.371    42.156     0.200
    14.281    41.859     0.200
    14.309    42.103     0.200
    14.396    42.197     0.200
    14.368    43.587     0.200
    14.406    41.326     0.200
    14.473    41.719     0.200
    14.509    41.576     0.200
    14.503    41.371     0.200
    14.556    42.675     0.200
    14.572    43.134     0.200
    14.596    42.882     0.200
    14.834    47.764     0.200
    14.878    42.235     0.200
    14.879    41.842     0.200
    14.945    41.480     0.200
    14.988    41.760     0.200
    15.258    42.644     0.200
    15.258    42.316     0.200
    15.293    43.901     0.200
    15.273    44.248     0.200
    15.412    44.042     0.200
    15.561    42.300     0.200
    15.663    42.662     0.200
    15.720    41.559     0.200
    15.779    43.033     0.200
    15.833    42.551     0.200
    16.343    42.756     0.200
    17.659    42.744     0.200
    17.879    42.859     0.200
    17.941    43.637     0.200
    18.358    40.666     0.200
    18.423    39.082     0.200
    18.507    37.873     0.200
    18.593    38.035     0.200
    18.727    39.501     0.200
    18.760    41.181     0.200
    18.898    37.650     0.200
    18.873    39.905     0.200
    18.987    40.804     0.200
    19.003    39.712     0.200
    19.202    39.510     0.200
    19.181    40.445     0.200
    19.364    39.615     0.200
    19.516    39.011     0.200
    19.546    38.908     0.200
    19.546    41.439     0.200
    19.665    40.559     0.200
    19.855    41.319     0.200
    20.218    39.848     0.200
    20.253    40.145     0.200
    20.268    37.650     0.200
    20.376    37.571     0.200
    20.664    37.096     0.200
    20.723    37.589     0.200
    20.754    38.448     0.200
    20.984    37.317     0.200
    21.106    37.874     0.200
    21.295    40.219     0.200
    21.293    40.876     0.200
    21.453    40.786     0.200
    21.491    38.257     0.200
    21.823    38.093     0.200
    22.315    35.574     0.200
    22.552    35.701     0.200
    22.660    38.392     0.200
    22.695    35.477     0.200
    22.774    35.795     0.200
    22.799    36.065     0.200
    22.938    39.258     0.200
    22.970    35.842     0.200
    23.110    37.854     0.200
    23.223    39.461     0.200
    23.279    37.780     0.200
    23.386    39.465     0.200
    23.468    36.935     0.200
    23.718    34.560     0.200
    23.710    37.452     0.200
    23.815    38.199     0.200
    23.822    35.564     0.200
    23.897    37.877     0.200
    23.882    34.991     0.200
    23.897    34.207     0.200
    24.035    38.478     0.200
    24.035    34.697     0.200
    24.080    37.903     0.200
    24.080    36.786     0.200
    24.071    37.189     0.200
    24.100    33.357     0.200
    24.153    33.577     0.200
    24.223    32.119     0.200
    24.234    36.850     0.200
    24.387    31.488     0.200
    24.659    30.920     0.200
    24.746    32.644     0.200
    24.959    34.764     0.200
    25.010    33.299     0.200
    25.060    35.131     0.200
    25.104    33.694     0.200
    25.127    35.115     0.200
    25.152    35.280     0.200
    25.317    35.227     0.200
    25.665    30.935     0.200
    25.679    31.505     0.200
    25.758    30.316     0.200
    25.937    34.208     0.200
    25.937    34.435     0.200
    26.091    30.612     0.200
    26.383    29.912     0.200
    26.580    28.684     0.200
    26.603    28.738     0.200
    26.928    27.810     0.200
    27.125    27.135     0.200
    27.617    25.294     0.200
    27.661    27.615     0.200
    27.916    26.028     0.200
    27.983    24.902     0.200
    28.636    24.181     0.200
    28.839    21.216     0.200
    28.945    23.874     0.200
    29.014    20.669     0.200
    29.045    21.355     0.200
    29.499    20.187     0.200
    28.725    26.529     0.200
    14.113    42.623     0.200
    14.213    42.005     0.200
    14.499    42.306     0.200
    14.890    42.766     0.200
    14.850    44.476     0.200
    15.053    44.836     0.200
    15.104    44.208     0.200
    16.281    41.972     0.200
    16.901    41.846     0.200
    17.531    42.623     0.200
    17.736    42.086     0.200
    17.981    43.294     0.200
    17.981    43.004     0.200
    18.150    42.395     0.200
    18.177    43.081     0.200
    18.520    41.451     0.200
    18.552    41.092     0.200
    18.552    41.742     0.200
    18.622    40.849     0.200
    18.932    41.149     0.200
    18.954    40.562     0.200
    19.089    41.423     0.200
    19.203    39.499     0.200
    19.435    40.503     0.200
    19.438    40.178     0.200
    19.487    41.199     0.200
    19.460    41.392     0.200
    19.704    40.370     0.200
    19.829    40.897     0.200
    20.115    40.428     0.200
    20.244    40.820     0.200
    20.290    41.174     0.200
    20.468    40.186     0.200
    20.451    40.907     0.200
    20.451    41.525     0.200
    20.623    40.362     0.200
    20.614    39.357     0.200
    20.614    39.957     0.200
    20.950    40.466     0.200
    20.950    39.718     0.200
    20.950    39.727     0.200
    21.036    39.792     0.200
    21.171    41.070     0.200
    21.135    41.396     0.200
    21.221    39.651     0.200
    21.264    40.235     0.200
    21.305    41.502     0.200
    21.375    38.922     0.200
    21.500    40.656     0.200
    21.463    39.440     0.200
    21.460    40.671     0.200
    21.460    38.542     0.200
    21.534    39.523     0.200
    21.569    39.614     0.200
    21.569    39.280     0.200
    21.682    38.503     0.200
    21.703    40.173     0.200
    21.742    39.068     0.200
    21.767    40.121     0.200
    22.024    38.819     0.200
    22.056    39.158     0.200
    22.089    39.066     0.200
    22.022    38.013     0.200
    22.353    38.882     0.200
    22.524    38.275     0.200
    22.515    39.632     0.200
    22.592    37.076     0.200
    22.593    39.004     0.200
    22.804    38.826     0.200
    22.804    37.838     0.200
    22.945    38.220     0.200
    22.945    36.526     0.200
    22.914    38.812     0.200
    22.914    36.069     0.200
    23.039    37.904     0.200
    23.039    35.646     0.200
    23.059    38.012     0.200
    23.177    37.704     0.200
    23.239    38.383     0.200
    23.279    37.884     0.200
    23.405    38.806     0.200
    23.414    37.397     0.200
    23.414    36.798     0.200
    23.611    37.823     0.200
    23.683    38.189     0.200
    23.909    36.771     0.200
    23.972    37.221     0.200
    24.023    36.611     0.200
    24.065    36.689     0.200
    24.094    37.107     0.200
    24.064    37.214     0.200
    24.115    37.100     0.200
    24.171    36.751     0.200
    24.241    35.019     0.200
    24.338    35.343     0.200
    24.336    34.634     0.200
    24.365    34.247     0.200
    24.348    35.973     0.200
    24.348    33.377     0.200
    24.363    35.206     0.200
    24.456    34.848     0.200
    24.456    34.564     0.200
    24.474    35.926     0.200
    24.592    35.463     0.200
    24.604    35.860     0.200
    24.575    35.506     0.200
    24.869    34.193     0.200
    24.915    33.065     0.200
    24.940    35.118     0.200
    25.234    33.344     0.200
    25.214    33.445     0.200
    25.336    34.401     0.200
    25.340    33.804     0.200
    25.367    32.943     0.200
    25.413    33.400     0.200
    25.414    33.778     0.200
    25.512    32.573     0.200
    25.529    31.516     0.200
    25.751    33.079     0.200
    25.997    31.833     0.200
    26.075    30.945     0.200
    26.150    30.020     0.200
    26.150    30.871     0.200
    26.305    30.746     0.200
    26.346    30.802     0.200
    26.367    30.710     0.200
    26.367    28.213     0.200
    26.395    30.231     0.200
    26.630    30.334     0.200
    26.668    30.830     0.200
    26.717    28.711     0.200
    26.811    29.677     0.200
    26.839    29.515     0.200
    26.869    30.242     0.200
    26.936    29.962     0.200
    26.932    28.799     0.200
    27.166    28.325     0.200
    27.371    27.794     0.200
    27.368    27.504     0.200
    27.368    25.845     0.200
    27.359    28.892     0.200
    27.534    27.655     0.200
    27.534    27.207     0.200
    27.582    27.221     0.200
    27.689    27.185     0.200
    27.781    26.229     0.200
    27.848    27.166     0.200
    27.899    26.756     0.200
    28.124    26.536     0.200
    28.124    26.128     0.200
    28.208    26.334     0.200
    28.238    26.782     0.200
    28.339    25.735     0.200
    28.442    24.707     0.200
    28.380    22.902     0.200
    28.701    24.974     0.200
    28.701    25.893     0.200
    28.841    23.306     0.200
    28.912    23.380     0.200
    29.083    23.631     0.200
    29.132    22.430     0.200
    29.274    23.785     0.200
    29.320    22.268     0.200
    29.326    23.792     0.200
    29.326    22.934     0.200
    29.519    22.105     0.200
    29.648    22.458     0.200
    29.648    22.925     0.200
    29.644    22.864     0.200
    29.744    21.359     0.200
    29.744    21.716     0.200
    29.768    22.241     0.200
    29.866    21.692     0.200
    14.114    40.989     0.200
    14.803    40.917     0.200
    15.188    41.612     0.200
    15.524    41.029     0.200
    15.828    41.331     0.200
    15.926    41.256     0.200
    16.012    41.371     0.200
    16.178    42.038     0.200
    16.518    42.107     0.200
    16.574    42.092     0.200
    16.568    42.832     0.200
    16.575    42.074     0.200
    16.608    43.359     0.200
    16.618    41.804     0.200
    16.645    41.496     0.200
    16.686    41.471     0.200
    16.909    42.179     0.200
    16.909    42.190     0.200
    17.262    41.309     0.200
    17.269    42.201     0.200
    17.533    42.367     0.200
    17.581    42.448     0.200
    17.566    42.700     0.200
    17.627    42.584     0.200
    17.627    42.159     0.200
    17.855    42.858     0.200
    17.990    42.460     0.200
    18.149    43.424     0.200
    18.182    41.767     0.200
    18.182    42.223     0.200
    18.424    44.753     0.200
    19.069    42.562     0.200
    19.182    40.826     0.200
    19.497    41.034     0.200
    20.429    41.263     0.200
    21.179    40.672     0.200
    21.201    41.121     0.200
    21.249    40.662     0.200
    21.284    40.709     0.200
    21.352    40.100     0.200
    21.439    41.088     0.200
    21.515    40.689     0.200
    21.510    40.371     0.200
    21.559    40.943     0.200
    21.554    40.483     0.200
    21.651    40.792     0.200
    21.660    41.895     0.200
    21.725    40.017     0.200
    22.007    39.706     0.200
    22.036    40.482     0.200
    22.001    37.669     0.200
    22.505    39.441     0.200
    22.493    39.832     0.200
    22.578    39.872     0.200
    22.578    38.894     0.200
    22.572    40.185     0.200
    22.786    38.939     0.200
    22.786    38.471     0.200
    22.893    39.957     0.200
    22.893    37.877     0.200
    22.935    38.176     0.200
    22.935    37.760     0.200
    23.023    38.077     0.200
    23.023    37.964     0.200
    23.042    38.223     0.200
    23.158    39.163     0.200
    23.224    37.827     0.200
    23.261    37.892     0.200
    23.392    37.475     0.200
    23.430    38.685     0.200
    23.591    39.924     0.200
    23.955    37.221     0.200
    24.012    36.777     0.200
    24.081    37.756     0.200
    24.094    37.697     0.200
    24.225    36.098     0.200
    24.319    36.978     0.200
    24.319    36.834     0.200
    24.330    36.162     0.200
    24.330    35.585     0.200
    24.356    33.739     0.200
    24.342    36.677     0.200
    24.436    36.502     0.200
    24.436    34.729     0.200
    24.455    36.154     0.200
    24.583    36.834     0.200
    24.554    36.203     0.200
    24.903    34.664     0.200
    24.903    34.263     0.200
    25.193    34.930     0.200
    25.669    33.391     0.200
    25.732    31.762     0.200
    25.900    31.831     0.200
    25.925    31.774     0.200
    26.071    30.247     0.200
    26.129    31.024     0.200
    26.129    32.330     0.200
    26.699    29.863     0.200
    26.789    30.769     0.200
    26.822    30.507     0.200
    26.921    29.540     0.200
    26.911    29.598     0.200
    27.147    29.094     0.200
    27.354    28.018     0.200
    27.349    27.989     0.200
    27.349    28.155     0.200
    27.518    27.625     0.200
    27.670    27.957     0.200
    27.705    28.298     0.200
    27.828    28.082     0.200
    27.880    27.525     0.200
    27.880    26.187     0.200
    27.816    27.233     0.200
    28.103    27.208     0.200
    28.103    25.680     0.200
    28.607    25.171     0.200
    28.682    25.310     0.200
    28.682    22.715     0.200
    28.718    23.367     0.200
    28.909    24.411     0.200
    28.927    23.432     0.200
    29.064    23.824     0.200
    29.112    22.680     0.200
    29.255    23.722     0.200
    29.308    23.702     0.200
    29.308    21.335     0.200
    29.628    20.924     0.200
    29.725    20.049     0.200
    29.950    21.616     0.200
    29.950    18.471     0.200
    14.123    40.479     0.200
    14.167    42.182     0.200
    14.299    40.742     0.200
    14.398    41.826     0.200
    14.448    40.646     0.200
    14.647    43.005     0.200
    14.752    41.813     0.200
    15.132    43.434     0.200
    15.159    41.659     0.200
    15.142    42.842     0.200
    15.284    41.478     0.200
    15.322    43.165     0.200
    15.555    41.214     0.200
    15.511    43.080     0.200
    15.937    40.694     0.200
    16.363    43.148     0.200
    16.739    41.204     0.200
    17.237    41.581     0.200
    17.756    42.377     0.200
    17.756    42.002     0.200
    17.808    42.319     0.200
    17.808    41.952     0.200
    17.808    40.765     0.200
    17.824    41.700     0.200
    17.824    42.235     0.200
    18.190    40.883     0.200
    18.338    42.091     0.200
    18.972    40.367     0.200
    19.135    40.072     0.200
    19.197    39.648     0.200
    19.802    40.255     0.200
    20.275    38.847     0.200
    20.344    39.449     0.200
    20.344    39.934     0.200
    20.565    39.193     0.200
    20.670    39.097     0.200
    20.824    38.860     0.200
    20.934    38.442     0.200
    20.953    39.066     0.200
    21.225    38.434     0.200
    21.258    38.253     0.200
    21.439    39.025     0.200
    21.705    38.605     0.200
    21.795    38.719     0.200
    22.066    38.294     0.200
    22.140    38.412     0.200
    22.241    37.560     0.200
    22.248    38.125     0.200
    22.322    37.129     0.200
    22.373    37.590     0.200
    22.508    37.126     0.200
    22.508    37.618     0.200
    22.568    37.365     0.200
    22.568    37.568     0.200
    22.678    37.540     0.200
    22.678    37.723     0.200
    22.715    36.580     0.200
    22.715    37.619     0.200
    22.746    36.844     0.200
    22.906    36.623     0.200
    22.905    37.422     0.200
    22.989    36.613     0.200
    23.193    36.552     0.200
    23.224    37.410     0.200
    23.364    36.905     0.200
    23.652    35.634     0.200
    23.670    35.446     0.200
    23.707    35.673     0.200
    23.738    36.000     0.200
    23.785    35.880     0.200
    23.828    35.112     0.200
    23.881    35.941     0.200
    24.060    34.481     0.200
    24.060    35.133     0.200
    24.142    35.970     0.200
    24.201    34.966     0.200
    24.365    34.430     0.200
    24.380    34.387     0.200
    24.552    33.204     0.200
    24.552    33.665     0.200
    24.648    34.682     0.200
    24.889    32.957     0.200
    25.002    33.769     0.200
    25.092    31.987     0.200
    25.155    31.968     0.200
    25.169    31.800     0.200
    25.305    33.268     0.200
    25.468    32.146     0.200
    25.924    32.358     0.200
    25.924    32.491     0.200
    26.065    27.909     0.200
    26.593    27.502     0.200
    26.706    28.324     0.200
    26.896    28.218     0.200
    27.089    26.577     0.200
    27.089    27.499     0.200
    27.591    26.061     0.200
    28.536    22.907     0.200
    29.039    22.266     0.200
    29.900    20.609     0.200
    14.005    38.202     0.200
    14.391    38.608     0.200
    14.952    40.786     0.200
    15.959    40.322     0.200
    16.160    40.527     0.200
    16.307    41.156     0.200
    16.699    41.551     0.200
    16.893    42.052     0.200
    17.685    41.041     0.200
    18.214    39.802     0.200
    18.255    41.109     0.200
    18.179    40.565     0.200
    18.635    39.170     0.200
    18.734    39.059     0.200
    19.526    38.075     0.200
    19.583    37.252     0.200
    19.670    37.431     0.200
    19.898    39.220     0.200
    20.414    38.601     0.200
    20.464    37.852     0.200
    21.064    36.864     0.200
    21.209    36.991     0.200
    21.276    37.170     0.200
    21.335    35.014     0.200
    21.525    39.002     0.200
    21.644    37.845     0.200
    21.648    37.938     0.200
    21.741    36.203     0.200
    22.029    36.167     0.200
    21.939    39.376     0.200
    22.041    36.105     0.200
    22.075    36.079     0.200
    22.568    36.433     0.200
    22.893    40.808     0.200
    23.096    37.057     0.200
    23.062    34.954     0.200
    23.251    35.631     0.200
    23.377    35.011     0.200
    23.593    32.997     0.200
    23.879    33.684     0.200
    23.971    32.251     0.200
    24.057    32.336     0.200
    24.027    33.456     0.200
    24.116    34.925     0.200
    24.186    35.481     0.200
    24.246    34.948     0.200
    24.245    31.554     0.200
    24.347    34.918     0.200
    24.404    31.193     0.200
    24.404    32.966     0.200
    24.338    32.771     0.200
    24.464    33.815     0.200
    24.564    32.645     0.200
    24.583    32.397     0.200
    24.844    31.480     0.200
    24.941    29.978     0.200
    25.251    31.551     0.200
    25.199    32.423     0.200
    25.306    30.193     0.200
    26.131    29.752     0.200
    26.131    30.373     0.200
    26.126    26.521     0.200
    26.126    29.217     0.200
    26.624    27.828     0.200
    26.857    25.079     0.200
    27.359    25.637     0.200
    27.832    21.876     0.200
    27.956    22.211     0.200
    17.447    43.249     0.200
    23.661    34.717     0.200
    14.095    40.746     0.200
    14.285    40.692     0.200
    14.703    41.718     0.200
    15.898    39.699     0.200
    16.569    42.408     0.200
    17.345    42.112     0.200
    17.345    42.940     0.200
    17.711    42.003     0.200
    17.986    42.145     0.200
    19.552    40.232     0.200
    19.558    40.505     0.200
    19.832    39.055     0.200
    19.859    40.303     0.200
    19.955    39.953     0.200
    20.157    40.726     0.200
    21.924    38.914     0.200
    22.198    38.410     0.200
    22.198    38.535     0.200
    22.245    38.575     0.200
    22.259    37.245     0.200
    22.282    37.449     0.200
    22.282    39.856     0.200
    22.446    40.052     0.200
    22.540    39.142     0.200
    22.540    39.564     0.200
    23.149    38.869     0.200
    23.596    36.003     0.200
    23.596    35.183     0.200
    23.845    36.825     0.200
    24.020    34.763     0.200
    24.020    36.356     0.200
    24.020    34.060     0.200
    24.025    35.156     0.200
    24.210    34.940     0.200
    24.210    35.807     0.200
    24.223    35.469     0.200
    24.275    34.252     0.200
    24.532    34.293     0.200
    24.580    33.349     0.200
    24.898    33.505     0.200
    25.020    32.861     0.200
    25.023    33.671     0.200
    25.086    33.342     0.200
    25.184    31.905     0.200
    25.244    31.819     0.200
    25.262    31.180     0.200
    25.262    34.359     0.200
    25.464    31.462     0.200
    25.452    31.966     0.200
    25.452    33.943     0.200
    25.560    30.870     0.200
    25.570    29.946     0.200
    25.799    30.444     0.200
    25.862    29.904     0.200
    25.962    30.033     0.200
    25.950    31.606     0.200
    26.024    28.347     0.200
    26.018    30.417     0.200
    26.018    32.371     0.200
    26.087    31.923     0.200
    26.162    29.997     0.200
    26.162    31.708     0.200
    26.187    29.720     0.200
    26.249    30.711     0.200
    26.422    28.886     0.200
    26.481    28.378     0.200
    26.583    28.524     0.200
    26.707    28.685     0.200
    26.837    28.257     0.200
    26.889    27.893     0.200
    26.889    29.089     0.200
    27.234    28.366     0.200
    27.439    27.882     0.200
    27.582    25.923     0.200
    27.594    24.624     0.200
    27.877    25.768     0.200
    27.882    25.393     0.200
    28.190    24.926     0.200
    28.228    25.571     0.200
    28.368    25.041     0.200
    28.371    24.427     0.200
    28.556    24.923     0.200
    28.597    21.539     0.200
    28.825    24.281     0.200
    28.855    22.708     0.200
    28.953    20.792     0.200
    29.450    22.465     0.200
    29.454    22.932     0.200
    29.829    20.250     0.200
    29.858    20.304     0.200
    29.937    19.613     0.200
    15.352    42.558     0.200
    15.496    43.587     0.200
    15.515    41.726     0.200
    16.898    43.550     0.200
    17.406    42.956     0.200
    17.459    42.409     0.200
    18.884    41.308     0.200
    19.099    41.124     0.200
    19.446    41.306     0.200
    19.975    40.764     0.200
    20.167    40.609     0.200
    20.381    39.763     0.200
    20.965    39.899     0.200
    21.973    38.616     0.200
    22.265    38.569     0.200
    22.265    39.913     0.200
    22.250    39.316     0.200
    23.742    36.708     0.200
    15.997    40.599     0.200
    16.553    42.826     0.200
    16.615    41.559     0.200
    17.094    44.753     0.200
    17.094    43.850     0.200
    17.739    42.132     0.200
    18.725    38.679     0.200
    18.823    41.379     0.200
    20.015    40.027     0.200
    20.015    41.065     0.200
    20.060    40.264     0.200
    20.141    40.910     0.200
    20.281    40.221     0.200
    20.545    39.225     0.200
    21.172    39.940     0.200
    21.234    39.671     0.200
    21.820    38.738     0.200
    22.054    38.231     0.200
    22.054    38.619     0.200
    22.054    40.391     0.200
    22.240    36.547     0.200
    22.375    35.989     0.200
    22.553    38.539     0.200
    22.553    37.184     0.200
    22.553    40.589     0.200
    23.198    38.594     0.200
    23.325    35.855     0.200
    23.439    36.762     0.200
    23.724    37.250     0.200
    23.811    37.120     0.200
    24.010    36.069     0.200
    24.087    34.514     0.200
    24.087    37.483     0.200
    24.307    35.327     0.200
    25.042    32.225     0.200
    25.042    34.815     0.200
    25.146    34.238     0.200
    25.232    34.265     0.200
    25.431    33.567     0.200
    25.819    28.724     0.200
    26.029    31.502     0.200
    26.130    33.152     0.200
    26.226    32.428     0.200
    26.448    31.220     0.200
    26.789    29.356     0.200
    26.863    28.795     0.200
    26.863    28.558     0.200
    26.972    29.847     0.200
    27.420    28.101     0.200
    27.816    26.973     0.200
    28.107    25.775     0.200
    28.204    25.549     0.200
    28.561    24.245     0.200
    28.790    24.885     0.200
    28.902    21.519     0.200
    29.019    24.920     0.200
    29.176    23.353     0.200
    29.189    23.819     0.200
    29.596    22.884     0.200
    29.675    24.518     0.200
    17.160    42.927     0.200
    20.069    38.183     0.200
    20.866    38.406     0.200
    21.862    38.751     0.200
    22.410    37.868     0.200
    23.344    37.425     0.200
    17.651    44.369     0.200
    18.137    43.389     0.200
    16.855    40.513     0.200
    18.180    43.318     0.200
    19.456    39.493     0.200
    19.799    38.760     0.200
    21.959    37.449     0.200
    22.900    37.224     0.200
    24.324    34.626     0.200
    24.324    35.509     0.200
    28.164    23.632     0.200
    15.374    39.419     0.200
    16.213    39.104     0.200
    22.652    36.750     0.200
    23.948    34.249     0.200
    24.195    35.167     0.200
    24.269    33.594     0.200
    25.104    32.224     0.200
    25.348    30.301     0.200
    17.772    44.105     0.200
    18.252    42.692     0.200
    19.696    40.481     0.200
    14.619    44.348     0.200
    14.633    43.519     0.200
    14.670    41.756     0.200
    15.819    39.599     0.200
    16.868    41.984     0.200
    17.089    43.576     0.200
    17.698    43.208     0.200
    17.698    43.966     0.200
    17.730    42.337     0.200
    18.220    42.847     0.200
    18.875    39.421     0.200
    19.029    39.062     0.200
    19.271    40.974     0.200
    20.178    39.133     0.200
    20.433    38.820     0.200
    20.540    36.975     0.200
    20.725    38.940     0.200
    20.846    37.817     0.200
    21.099    37.778     0.200
    21.087    41.311     0.200
    21.136    38.597     0.200
    21.335    45.331     0.200
    21.426    37.828     0.200
    21.888    47.296     0.200
    22.114    36.534     0.200
    22.154    39.728     0.200
    22.154    46.830     0.200
    22.196    47.117     0.200
    22.437    36.612     0.200
    22.437    39.854     0.200
    22.579    36.258     0.200
    22.579    39.703     0.200
    22.594    36.755     0.200
    22.544    39.412     0.200
    23.139    35.627     0.200
    23.215    36.350     0.200
    23.823    35.030     0.200
    23.851    34.742     0.200
    23.851    36.188     0.200
    23.909    33.967     0.200
    24.048    35.387     0.200
    24.089    34.633     0.200
    24.089    37.040     0.200
    24.092    34.886     0.200
    24.288    33.916     0.200
    24.423    33.721     0.200
    24.423    34.182     0.200
    24.683    34.247     0.200
    25.069    32.456     0.200
    25.210    31.103     0.200
    25.549    29.206     0.200
    25.549    33.394     0.200
    25.577    31.424     0.200
    25.828    30.088     0.200
    26.017    30.500     0.200
    26.084    29.851     0.200
    26.084    31.469     0.200
    26.496    28.240     0.200
    26.500    28.570     0.200
    26.979    27.740     0.200
    27.587    27.305     0.200
    27.603    26.798     0.200
    27.941    25.832     0.200
    28.198    24.944     0.200
    28.588    24.409     0.200
    28.721    23.712     0.200
    28.724    24.611     0.200
    29.157    22.772     0.200
    29.562    19.740     0.200
    29.635    21.416     0.200
    29.728    20.162     0.200
    29.805    19.793     0.200
    29.805    20.512     0.200
    16.254    44.510     0.200
    16.590    44.179     0.200
    16.879    42.309     0.200
    16.879    44.262     0.200
    17.719    42.790     0.200
    17.806    42.538     0.200
    15.931    45.847     0.200
    16.341    43.971     0.200
    16.316    43.547     0.200
    16.688    41.666     0.200
    17.891    40.283     0.200
    18.292    42.653     0.200
    18.507    43.274     0.200
    18.883    39.560     0.200
    21.433    40.414     0.200
    21.703    39.129     0.200
    21.740    43.015     0.200
    22.079    39.691     0.200
    22.113    39.926     0.200
    22.572    39.240     0.200
    22.910    38.706     0.200
    23.366    38.511     0.200
    23.362    38.938     0.200
    24.562    36.409     0.200
    24.849    36.532     0.200
    25.284    35.459     0.200
    15.564    41.302     0.200
    15.908    39.388     0.200
    17.127    44.539     0.200
    17.568    45.210     0.200
    14.235    41.721     0.200
    14.360    42.116     0.200
    14.591    42.697     0.200
    14.618    45.035     0.200
    14.966    44.780     0.200
    15.871    41.104     0.200
    16.123    44.576     0.200
    16.361    41.791     0.200
    16.473    42.232     0.200
    17.610    43.270     0.200
    19.005    43.345     0.200
    22.399    40.457     0.200
    22.602    38.571     0.200
    23.807    39.260     0.200
    25.487    33.704     0.200
    14.594    39.956     0.200
    15.070    40.159     0.200
    15.801    40.515     0.200
    16.680    41.066     0.200
    16.680    41.218     0.200
    16.953    42.910     0.200
    17.810    42.117     0.200
    18.220    41.735     0.200
    18.381    43.311     0.200
    18.410    41.296     0.200
    18.445    39.220     0.200
    18.475    39.289     0.200
    18.519    38.138     0.200
    18.520    38.415     0.200
    18.568    41.522     0.200
    18.615    39.933     0.200
    18.588    38.882     0.200
    19.074    38.964     0.200
    19.075    38.950     0.200
    19.095    40.329     0.200
    19.178    39.855     0.200
    19.242    38.961     0.200
    19.316    38.754     0.200
    20.137    40.500     0.200
    20.440    35.304     0.200
    21.330    41.416     0.200
    21.365    40.569     0.200
    21.751    40.546     0.200
    21.751    40.547     0.200
    21.833    38.253     0.200
    21.948    39.217     0.200
    22.251    41.147     0.200
    22.597    39.461     0.200
    22.764    37.156     0.200
    22.764    38.226     0.200
    23.011    38.563     0.200
    23.011    38.229     0.200
    23.195    35.326     0.200
    23.195    34.875     0.200
    23.383    37.396     0.200
    23.462    36.061     0.200
    23.800    34.557     0.200
    23.903    34.837     0.200
    23.903    35.157     0.200
    24.018    35.843     0.200
    24.017    35.640     0.200
    24.017    35.390     0.200
    24.531    35.049     0.200
    24.719    32.942     0.200
    24.719    33.303     0.200
    25.215    32.217     0.200
    25.452    31.228     0.200
    25.509    33.252     0.200
    26.069    30.506     0.200
    26.536    30.074     0.200
    26.552    30.155     0.200
    27.148    28.786     0.200
    27.148    28.306     0.200
    27.538    27.564     0.200
    27.671    26.886     0.200
    27.673    26.996     0.200
    28.190    25.341     0.200
    28.585    24.933     0.200
    28.669    25.254     0.200
    28.757    24.464     0.200
    29.152    22.226     0.200
    29.159    22.724     0.200
    29.239    22.509     0.200
    29.794    21.179     0.200
    29.832    21.963     0.200
    29.833    21.413     0.200
    29.873    21.168     0.200
    29.980    19.866     0.200
    14.997    39.216     0.200
    15.178    41.344     0.200
    15.507    38.642     0.200
    15.801    39.405     0.200
    16.642    41.866     0.200
    18.527    39.974     0.200
    20.509    38.664     0.200
    21.531    37.053     0.200
    21.729    38.288     0.200
    22.132    37.697     0.200
    22.574    38.068     0.200
    22.917    38.329     0.200
    24.594    33.742     0.200
    24.594    32.562     0.200
    15.964    44.679     0.200
    16.388    42.731     0.200
    17.871    42.003     0.200
    18.697    40.402     0.200
    19.299    40.847     0.200
    19.419    40.883     0.200
    19.642    40.465     0.200
    19.642    41.542     0.200
    20.129    39.258     0.200
    20.164    39.099     0.200
    20.201    39.592     0.200
    20.436    39.485     0.200
    20.667    40.155     0.200
    21.207    36.897     0.200
    21.460    38.627     0.200
    21.667    38.696     0.200
    21.732    38.689     0.200
    22.052    38.065     0.200
    22.290    38.493     0.200
    22.453    37.431     0.200
    22.765    40.562     0.200
    22.778    36.841     0.200
    23.072    37.620     0.200
    23.161    35.177     0.200
    23.161    38.065     0.200
    23.500    37.447     0.200
    23.810    36.590     0.200
    24.023    35.829     0.200
    24.355    37.879     0.200
    24.397    33.865     0.200
    24.613    34.998     0.200
    24.613    33.596     0.200
    25.129    32.689     0.200
    25.654    30.256     0.200
    25.981    31.183     0.200
    26.148    32.322     0.200
    26.246    31.501     0.200
    26.440    32.997     0.200
    27.301    27.136     0.200
    27.942    24.806     0.200
    29.157    22.082     0.200
    14.323    44.374     0.200
    14.638    43.127     0.200
    15.806    41.118     0.200
    17.664    44.051     0.200
    19.654    39.977     0.200
    21.294    39.865     0.200
    22.112    38.648     0.200
    22.164    38.371     0.200
    22.402    39.027     0.200
    22.556    35.877     0.200
    23.120    38.267     0.200
    23.760    39.156     0.200
    23.814    38.484     0.200
    24.370    36.325     0.200
    24.945    35.821     0.200
    24.973    35.364     0.200
    21.381    38.897     0.200
    17.981    43.737     0.200
    18.192    43.282     0.200
    21.388    38.627     0.200
    21.807    40.277     0.200
    21.908    39.843     0.200
    22.306    39.658     0.200
    22.632    39.681     0.200
    23.336    38.817     0.200
    23.427    39.175     0.200
    24.250    36.356     0.200
    24.489    35.683     0.200
    24.547    35.526     0.200
    24.877    33.870     0.200
    18.631    39.348     0.200
    24.498    33.252     0.200
    15.572    41.021     0.200
    16.228    42.322     0.200
    22.622    41.228     0.200
    24.452    35.842     0.200
    15.603    40.003     0.200
    16.419    42.059     0.200
    17.554    40.714     0.200
    17.767    41.153     0.200
    17.843    42.427     0.200
    18.025    41.462     0.200
    18.237    41.666     0.200
    18.604    38.314     0.200
    18.724    40.384     0.200
    19.300    40.384     0.200
    20.318    39.713     0.200
    20.602    37.581     0.200
    21.082    37.930     0.200
    21.452    38.255     0.200
    21.438    39.003     0.200
    21.613    38.131     0.200
    21.842    37.893     0.200
    21.930    37.963     0.200
    22.321    37.537     0.200
    22.658    37.698     0.200
    22.747    38.021     0.200
    23.035    36.844     0.200
    23.396    34.210     0.200
    24.187    35.066     0.200
    24.488    35.136     0.200
    24.488    33.155     0.200
    25.003    31.865     0.200
    25.121    32.864     0.200
    24.459    36.425     0.200
    16.010    41.753     0.200
    16.516    41.824     0.200
    20.530    37.601     0.200
    21.593    36.985     0.200
    23.321    35.662     0.200
    24.384    35.241     0.200
    15.479    42.363     0.200
    15.582    40.868     0.200
    15.529    40.528     0.200
    15.534    40.676     0.200
    16.239    41.948     0.200
    16.323    40.787     0.200
    16.354    40.568     0.200
    16.640    40.602     0.200
    16.917    41.044     0.200
    17.495    41.433     0.200
    17.704    41.519     0.200
    17.704    43.220     0.200
    17.797    41.729     0.200
    17.960    41.416     0.200
    18.172    41.508     0.200
    18.310    41.066     0.200
    18.619    40.781     0.200
    20.609    38.890     0.200
    20.659    39.017     0.200
    21.378    39.725     0.200
    21.390    38.920     0.200
    21.457    39.674     0.200
    21.560    39.234     0.200
    21.667    37.955     0.200
    21.881    38.651     0.200
    22.133    38.601     0.200
    22.128    38.514     0.200
    22.282    38.942     0.200
    22.597    39.679     0.200
    22.597    41.031     0.200
    22.606    38.198     0.200
    22.615    38.255     0.200
    23.004    38.258     0.200
    23.046    37.059     0.200
    23.313    37.962     0.200
    23.401    35.606     0.200
    23.650    37.042     0.200
    24.132    35.110     0.200
    24.226    35.476     0.200
    24.290    34.563     0.200
    24.460    33.792     0.200
    24.460    33.138     0.200
    25.522    32.011     0.200
    27.130    27.519     0.200
    28.630    23.659     0.200
    20.549    39.229     0.200
    21.609    37.404     0.200
    22.108    38.737     0.200
    22.248    37.706     0.200
    23.634    36.327     0.200
    24.405    35.170     0.200
    24.405    34.314     0.200
    21.424    40.582     0.200
    14.990    41.906     0.200
    15.003    41.661     0.200
    15.101    41.551     0.200
    15.122    41.637     0.200
    15.844    41.965     0.200
    17.468    39.966     0.200
    18.606    39.697     0.200
    20.019    38.428     0.200
    22.601    37.132     0.200
    23.442    34.317     0.200
    24.455    33.951     0.200
    24.531    32.827     0.200
    24.967    32.296     0.200
    16.928    43.187     0.200
    17.717    44.162     0.200
    18.418    41.065     0.200
    18.539    40.199     0.200
    21.465    41.691     0.200
    21.550    40.118     0.200
    21.585    41.341     0.200
    21.786    40.611     0.200
    21.865    37.976     0.200
    22.606    38.993     0.200
    22.606    41.173     0.200
    22.962    41.500     0.200
    23.675    38.669     0.200
    23.803    39.761     0.200
    24.034    37.617     0.200
    24.127    38.045     0.200
    24.187    36.007     0.200
    24.187    39.765     0.200
    24.225    36.960     0.200
    24.249    35.793     0.200
    24.299    37.216     0.200
    24.415    37.673     0.200
    24.415    36.212     0.200
    24.539    37.812     0.200
    24.658    34.277     0.200
    24.930    34.274     0.200
    25.120    33.986     0.200
    25.509    34.205     0.200
    25.518    34.038     0.200
    25.826    33.289     0.200
    25.985    34.598     0.200
    26.005    31.089     0.200
    26.109    32.232     0.200
    26.248    34.349     0.200
    26.475    31.782     0.200
    26.663    30.322     0.200
    27.011    29.530     0.200
    27.127    30.355     0.200
    27.276    33.536     0.200
    27.471    28.577     0.200
    27.733    27.317     0.200
    27.790    27.585     0.200
    27.838    28.948     0.200
    27.916    28.475     0.200
    27.962    25.352     0.200
    28.889    26.539     0.200
    28.992    25.589     0.200
    29.072    25.520     0.200
    29.389    23.703     0.200
    29.423    23.599     0.200
    21.473    44.107     0.200
    15.225    42.796     0.200
    15.303    41.763     0.200
    16.636    40.962     0.200
    18.559    40.289     0.200
    20.553    39.726     0.200
    21.448    36.028     0.200
    23.346    34.315     0.200
    24.427    35.013     0.200
    24.427    32.237     0.200
    26.264    28.064     0.200
    17.708    40.388     0.200
    19.446    39.098     0.200
    21.449    37.136     0.200
    22.598    37.043     0.200
    24.240    34.268     0.200
    24.417    34.435     0.200
    24.417    33.633     0.200
    24.692    33.380     0.200
    28.985    21.134     0.200
    24.441    36.631     0.200
    15.576    44.171     0.200
    18.573    42.718     0.200
    20.562    41.140     0.200
    21.521    39.753     0.200
    21.624    39.101     0.200
    22.246    39.574     0.200
    22.565    36.961     0.200
    23.094    38.146     0.200
    23.353    38.029     0.200
    24.412    35.482     0.200
    24.412    34.717     0.200
    24.924    34.188     0.200
    14.950    43.400     0.200
    15.495    41.561     0.200
    17.354    43.818     0.200
    21.625    40.173     0.200
    23.363    37.139     0.200
    26.425    30.185     0.200
    24.430    38.014     0.200
    16.009    39.797     0.200
    17.850    40.304     0.200
    19.693    38.608     0.200
    20.562    37.054     0.200
    21.063    37.318     0.200
    21.409    37.482     0.200
    21.431    38.423     0.200
    21.904    37.346     0.200
    22.163    38.009     0.200
    24.469    33.855     0.200
    15.391    46.323     0.200
    17.730    42.258     0.200
    20.390    37.880     0.200
    20.390    41.212     0.200
    21.400    37.320     0.200
    21.678    37.929     0.200
    22.623    39.073     0.200
    22.623    39.413     0.200
    22.928    37.155     0.200
    23.029    38.937     0.200
    24.211    37.232     0.200
    24.485    34.799     0.200
    24.485    32.522     0.200
    24.551    33.473     0.200
    24.940    35.717     0.200
    24.934    35.471     0.200
    26.486    27.434     0.200
    16.223    43.193     0.200
    16.223    42.552     0.200
    16.875    43.443     0.200
    17.713    44.365     0.200
    17.825    43.952     0.200
    18.669    39.619     0.200
    18.690    38.499     0.200
    19.106    38.298     0.200
    19.137    38.172     0.200
    19.319    38.902     0.200
    20.006    37.469     0.200
    21.422    37.397     0.200
    22.607    35.732     0.200
    22.607    39.854     0.200
    22.604    35.793     0.200
    22.604    41.243     0.200
    22.604    40.582     0.200
    22.990    39.965     0.200
    24.134    32.990     0.200
    24.189    38.298     0.200
    24.189    37.485     0.200
    24.229    33.246     0.200
    24.243    32.792     0.200
    24.445    35.243     0.200
    24.534    32.716     0.200
    25.198    31.848     0.200
    25.501    31.233     0.200
    25.822    30.869     0.200
    26.287    32.012     0.200
    26.470    28.312     0.200
    27.966    24.475     0.200
    20.571    38.596     0.200
    21.118    36.051     0.200
    24.439    32.897     0.200
    15.677    42.065     0.200
    20.643    39.887     0.200
    20.964    38.752     0.200
    21.088    39.314     0.200
    22.316    36.850     0.200
    22.627    36.551     0.200
    23.436    37.529     0.200
    24.259    35.236     0.200
    24.499    36.689     0.200
    25.011    32.200     0.200
    25.844    29.272     0.200
    14.850    44.356     0.200
    16.193    43.413     0.200
    17.701    43.683     0.200
    19.123    41.351     0.200
    19.203    41.046     0.200
    19.227    40.569     0.200
    19.976    40.135     0.200
    20.350    41.205     0.200
    20.549    39.515     0.200
    20.954    41.692     0.200
    21.012    39.932     0.200
    21.105    40.578     0.200
    21.439    36.190     0.200
    21.540    39.486     0.200
    22.117    40.001     0.200
    22.130    38.758     0.200
    22.268    38.403     0.200
    22.512    37.940     0.200
    22.588    39.581     0.200
    22.591    40.156     0.200
    22.591    39.414     0.200
    22.591    41.254     0.200
    22.591    40.445     0.200
    22.627    39.642     0.200
    22.676    39.474     0.200
    22.963    39.807     0.200
    22.963    39.108     0.200
    24.174    36.165     0.200
    24.174    37.735     0.200
    24.174    37.075     0.200
    24.213    36.571     0.200
    24.417    35.584     0.200
    24.417    34.909     0.200
    24.417    35.940     0.200
    24.674    34.018     0.200
    24.877    34.592     0.200
    24.877    36.002     0.200
    24.931    33.891     0.200
    25.987    32.814     0.200
    26.072    30.073     0.200
    26.256    30.114     0.200
    26.256    31.864     0.200
    26.256    31.177     0.200
    26.410    30.176     0.200
    26.592    30.009     0.200
    27.115    28.184     0.200
    29.064    25.800     0.200
    29.376    22.012     0.200
    29.412    21.677     0.200
    15.544    41.030     0.200
    16.223    42.357     0.200
    17.706    42.155     0.200
    19.313    38.851     0.200
    19.466    37.917     0.200
    20.260    36.772     0.200
    20.362    37.769     0.200
    20.940    37.189     0.200
    20.954    36.912     0.200
    21.290    36.849     0.200
    21.413    40.271     0.200
    22.133    36.100     0.200
    22.261    36.037     0.200
    22.602    34.850     0.200
    22.598    37.389     0.200
    22.598    41.008     0.200
    22.598    41.818     0.200
    22.632    35.639     0.200
    22.895    35.413     0.200
    22.924    34.897     0.200
    22.990    39.089     0.200
    23.378    33.900     0.200
    24.184    37.406     0.200
    24.184    39.816     0.200
    24.224    32.372     0.200
    24.237    33.483     0.200
    24.445    35.239     0.200
    24.445    36.364     0.200
    26.289    31.257     0.200
    26.907    28.464     0.200
    24.471    34.280     0.200
    20.221    37.935     0.200
    20.525    37.585     0.200
    21.084    39.007     0.200
    21.439    38.234     0.200
    22.225    38.472     0.200
    22.485    36.494     0.200
    22.569    38.739     0.200
    22.889    38.085     0.200
    22.935    36.644     0.200
    23.318    36.571     0.200
    23.997    35.647     0.200
    24.091    36.046     0.200
    24.212    33.004     0.200
    24.389    35.307     0.200
    24.652    32.363     0.200
    24.903    31.388     0.200
    15.683    41.030     0.200
    16.225    41.216     0.200
    17.704    40.905     0.200
    24.447    35.017     0.200
    24.503    35.602     0.200
    21.403    41.123     0.200
    21.430    34.998     0.200
    15.471    41.901     0.200
    15.913    43.323     0.200
    17.550    44.931     0.200
    18.281    45.622     0.200
    18.281    46.126     0.200
    18.481    39.274     0.200
    18.589    39.207     0.200
    18.957    38.952     0.200
    19.016    39.488     0.200
    19.188    39.238     0.200
    19.688    38.638     0.200
    19.925    38.401     0.200
    20.040    38.267     0.200
    20.276    37.999     0.200
    20.265    37.591     0.200
    20.478    38.151     0.200
    20.732    37.238     0.200
    20.849    37.712     0.200
    20.960    37.691     0.200
    21.342    37.681     0.200
    21.342    43.521     0.200
    21.544    38.872     0.200
    21.635    37.216     0.200
    22.429    36.304     0.200
    22.657    35.490     0.200
    22.724    34.669     0.200
    23.056    35.190     0.200
    23.993    39.907     0.200
    24.140    37.011     0.200
    24.121    32.951     0.200
    24.396    32.886     0.200
    24.617    36.329     0.200
    24.659    32.373     0.200
    25.966    33.427     0.200
    26.312    27.632     0.200
    17.653    46.035     0.200
    24.200    36.005     0.200
    15.119    40.046     0.200
    15.488    40.078     0.200
    15.608    43.956     0.200
    16.013    43.130     0.200
    18.376    41.656     0.200
    18.376    43.627     0.200
    18.547    38.196     0.200
    19.021    39.222     0.200
    19.094    38.591     0.200
    19.281    40.388     0.200
    19.977    38.270     0.200
    21.431    39.269     0.200
    21.512    39.648     0.200
    22.053    36.548     0.200
    22.164    37.661     0.200
    22.487    35.869     0.200
    22.491    38.901     0.200
    22.491    36.700     0.200
    22.491    41.231     0.200
    22.739    35.581     0.200
    22.789    38.109     0.200
    22.789    34.469     0.200
    22.959    36.770     0.200
    23.200    36.130     0.200
    23.689    34.649     0.200
    23.868    34.359     0.200
    23.912    34.051     0.200
    23.989    33.877     0.200
    24.061    36.350     0.200
    24.094    33.615     0.200
    24.239    34.884     0.200
    24.239    33.505     0.200
    24.492    31.966     0.200
    24.711    33.694     0.200
    24.757    31.890     0.200
    24.768    32.127     0.200
    25.716    31.688     0.200
    25.908    32.226     0.200
    25.972    30.996     0.200
    15.973    40.778     0.200
    15.973    41.838     0.200
    16.320    41.957     0.200
    17.601    41.468     0.200
    17.735    41.683     0.200
    18.325    43.144     0.200
    18.325    43.538     0.200
    18.732    39.361     0.200
    18.797    39.312     0.200
    19.327    39.733     0.200
    20.314    38.447     0.200
    20.793    38.619     0.200
    20.810    38.706     0.200
    20.895    39.788     0.200
    21.247    37.308     0.200
    21.380    41.418     0.200
    21.380    38.668     0.200
    21.549    38.594     0.200
    21.692    36.974     0.200
    21.758    36.168     0.200
    22.158    37.115     0.200
    22.323    35.816     0.200
    22.483    39.605     0.200
    22.483    35.594     0.200
    22.483    40.375     0.200
    22.752    38.457     0.200
    22.752    35.525     0.200
    24.048    36.772     0.200
    24.048    33.722     0.200
    24.048    37.901     0.200
    24.201    34.075     0.200
    24.201    32.255     0.200
    24.441    31.940     0.200
    24.425    32.966     0.200
    24.679    34.249     0.200
    24.721    31.856     0.200
    25.087    30.343     0.200
    25.709    31.011     0.200
    25.906    31.226     0.200
    25.959    28.190     0.200
    25.964    31.511     0.200
    26.024    30.960     0.200
    26.213    27.803     0.200
    28.927    20.634     0.200
    29.155    22.890     0.200
    16.849    41.647     0.200
    14.538    39.543     0.200
    14.674    39.672     0.200
    14.894    40.529     0.200
    14.979    40.862     0.200
    15.165    39.393     0.200
    15.247    40.279     0.200
    15.292    40.281     0.200
    15.355    42.574     0.200
    15.387    39.829     0.200
    15.810    39.995     0.200
    16.037    39.601     0.200
    16.263    40.292     0.200
    16.435    40.289     0.200
    16.808    40.556     0.200
    16.849    41.704     0.200
    16.849    41.228     0.200
    16.849    40.189     0.200
    17.296    39.919     0.200
    17.710    41.022     0.200
    18.387    39.183     0.200
    18.740    39.650     0.200
    19.976    38.717     0.200
    20.071    38.192     0.200
    21.697    35.425     0.200
    21.877    38.817     0.200
    21.877    36.934     0.200
    22.510    39.256     0.200
    23.251    35.349     0.200
    23.251    34.192     0.200
    23.844    33.611     0.200
    23.947    33.597     0.200
    24.822    33.282     0.200
    25.474    29.129     0.200
    23.311    36.556     0.200
    18.183    42.000     0.200
    19.338    39.989     0.200
    20.087    39.283     0.200
    20.839    37.377     0.200
    21.070    36.968     0.200
    21.841    36.248     0.200
    23.207    37.744     0.200
    14.989    40.417     0.200
    23.801    38.292     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.009     6.820     0.200
     1.379     7.804     0.200
     1.596     8.958     0.200
     1.801     8.685     0.200
     1.962     9.438     0.200
     2.087    10.274     0.200
     2.207    11.642     0.200
     2.238    11.545     0.200
     2.367    11.847     0.200
     2.679    10.737     0.200
     2.711    12.860     0.200
     3.131    13.413     0.200
     3.231    14.383     0.200
     3.499    15.146     0.200
     3.873    15.488     0.200
     0.901     5.255     0.200
     1.368     8.617     0.200
     1.333     8.357     0.200
     1.581     8.541     0.200
     1.879     8.124     0.200
     2.140    10.411     0.200
     2.179    10.607     0.200
     2.228    10.337     0.200
     2.235     9.031     0.200
     2.325    10.979     0.200
     2.327    10.285     0.200
     2.498    11.182     0.200
     2.658    11.946     0.200
     2.715    10.581     0.200
     2.715    11.337     0.200
     2.841    11.670     0.200
     2.954    12.387     0.200
     3.012    12.238     0.200
     3.092    12.974     0.200
     3.180    12.726     0.200
     3.228    12.816     0.200
     3.246    12.279     0.200
     3.442    13.212     0.200
     3.438    12.820     0.200
     3.587    13.581     0.200
     3.681    13.525     0.200
     3.657    14.150     0.200
     3.712    13.848     0.200
     3.700    13.115     0.200
     3.869    14.116     0.200
     4.299    15.397     0.200
     4.445    15.892     0.200
     1.073     7.162     0.200
     1.368     8.840     0.200
     1.398     9.080     0.200
     1.666     9.264     0.200
     1.974    12.796     0.200
     1.953     8.973     0.200
     2.060    11.788     0.200
     2.092    13.119     0.200
     2.309    10.558     0.200
     2.363    10.335     0.200
     2.161    11.234     0.200
     2.232    11.081     0.200
     2.310    10.964     0.200
     2.413    11.275     0.200
     2.399    11.339     0.200
     2.472    11.516     0.200
     2.486    11.236     0.200
     2.830    15.410     0.200
     2.718    12.147     0.200
     2.800    12.121     0.200
     2.926    12.036     0.200
     2.990    12.685     0.200
     3.004    12.599     0.200
     3.113    12.462     0.200
     3.168    13.624     0.200
     3.243    14.117     0.200
     3.227    13.043     0.200
     3.402    13.621     0.200
     3.497    14.441     0.200
     3.664    14.713     0.200
     3.663    14.351     0.200
     3.683    14.259     0.200
     3.819    15.316     0.200
     3.866    14.595     0.200
     3.896    16.065     0.200
     4.097    17.061     0.200
     4.299    16.864     0.200
     4.384    16.053     0.200
     4.291    15.825     0.200
     4.298    17.872     0.200
     4.318    17.600     0.200
     4.331    15.442     0.200
     4.407    17.582     0.200
     4.441    15.577     0.200
     4.642    17.653     0.200
     4.712    18.967     0.200
     4.710    18.481     0.200
     4.779    17.605     0.200
     4.969    19.012     0.200
     4.982    18.272     0.200
     5.050    19.388     0.200
     5.246    20.123     0.200
     5.296    19.541     0.200
     5.506    20.020     0.200
     5.574    20.171     0.200
     5.604    20.843     0.200
     5.785    21.527     0.200
     5.835    21.247     0.200
     5.993    22.049     0.200
     6.135    21.587     0.200
     6.169    21.736     0.200
     6.114    21.673     0.200
     6.181    22.473     0.200
     6.251    23.299     0.200
     6.650    23.901     0.200
     6.819    24.414     0.200
     6.844    23.138     0.200
     6.972    23.564     0.200
     6.928    24.331     0.200
     7.491    24.912     0.200
     7.558    25.644     0.200
     7.815    27.221     0.200
     1.084     7.318     0.200
     1.356     9.051     0.200
     1.392     9.168     0.200
     1.668     9.306     0.200
     1.986    13.203     0.200
     1.961     9.753     0.200
     2.103    13.367     0.200
     2.150    11.371     0.200
     2.224    11.400     0.200
     2.309    11.407     0.200
     2.416    11.379     0.200
     2.395    11.816     0.200
     2.460    11.621     0.200
     2.473    11.408     0.200
     2.575    12.123     0.200
     2.712    12.475     0.200
     2.802    12.309     0.200
     2.978    12.552     0.200
     2.996    13.130     0.200
     3.216    12.981     0.200
     3.237    13.823     0.200
     3.392    13.865     0.200
     3.661    14.782     0.200
     3.651    14.422     0.200
     3.671    14.293     0.200
     3.810    15.297     0.200
     3.854    14.519     0.200
     3.892    15.645     0.200
     3.954    15.576     0.200
     4.091    16.692     0.200
     4.110    16.674     0.200
     4.279    15.816     0.200
     4.294    17.377     0.200
     4.311    17.359     0.200
     4.405    17.330     0.200
     4.429    15.884     0.200
     4.706    18.987     0.200
     4.701    18.604     0.200
     4.735    18.319     0.200
     4.768    17.489     0.200
     4.966    18.615     0.200
     4.980    18.518     0.200
     4.926    18.285     0.200
     5.046    19.707     0.200
     5.241    20.412     0.200
     5.286    19.815     0.200
     5.373    20.615     0.200
     5.571    20.439     0.200
     5.595    20.569     0.200
     5.692    21.179     0.200
     5.780    21.775     0.200
     5.835    21.461     0.200
     5.987    22.245     0.200
     6.133    23.518     0.200
     6.104    21.875     0.200
     6.172    22.645     0.200
     6.245    23.326     0.200
     6.644    23.974     0.200
     6.833    23.223     0.200
     1.094     7.237     0.200
     1.370     9.349     0.200
     1.646     9.655     0.200
     1.347     9.069     0.200
     2.286    11.697     0.200
     2.204    11.518     0.200
     2.372    11.877     0.200
     2.780    12.336     0.200
     2.449    11.885     0.200
     2.467    11.476     0.200
     2.557    12.575     0.200
     2.690    12.717     0.200
     2.976    13.037     0.200
     3.141    14.049     0.200
     2.975    13.180     0.200
     3.215    14.739     0.200
     3.207    13.646     0.200
     3.375    14.381     0.200
     3.468    15.101     0.200
     3.657    14.407     0.200
     3.647    14.456     0.200
     3.869    16.254     0.200
     3.791    15.468     0.200
     3.670    14.631     0.200
     3.846    15.217     0.200
     3.944    15.742     0.200
     4.093    16.443     0.200
     4.271    17.808     0.200
     4.381    18.138     0.200
     4.290    17.494     0.200
     4.278    16.330     0.200
     4.684    19.084     0.200
     4.682    18.395     0.200
     4.715    18.475     0.200
     4.753    18.446     0.200
     4.957    19.025     0.200
     4.943    19.155     0.200
     5.023    19.756     0.200
     5.269    20.240     0.200
     5.352    20.815     0.200
     5.548    21.082     0.200
     5.479    20.476     0.200
     5.577    20.896     0.200
     5.812    21.863     0.200
     5.757    22.077     0.200
     6.087    21.925     0.200
     6.153    22.876     0.200
     6.223    23.846     0.200
     1.314     6.773     0.200
     1.567     7.987     0.200
     1.699     7.766     0.200
     1.839     9.244     0.200
     1.951     9.397     0.200
     2.011     9.428     0.200
     7.039    22.129     0.200
     7.428    22.343     0.200
     8.139    24.076     0.200
     9.127    28.234     0.200
     9.573    28.975     0.200
    11.783    34.360     0.200
     1.117     7.232     0.200
     1.352     7.537     0.200
     1.280     8.561     0.200
     1.600     8.091     0.200
     1.488     8.969     0.200
     1.874     8.697     0.200
     2.049     9.831     0.200
     2.141    10.392     0.200
     2.143    10.848     0.200
     2.205     9.476     0.200
     2.143    10.667     0.200
     2.230    10.645     0.200
     2.625    11.287     0.200
     2.609    11.846     0.200
     2.651    13.206     0.200
     2.623    11.715     0.200
     2.743    12.047     0.200
     3.161    13.449     0.200
     3.343    13.264     0.200
     3.602    13.821     0.200
     3.750    14.998     0.200
     3.836    13.140     0.200
     4.028    14.655     0.200
     4.380    16.199     0.200
     4.200    15.342     0.200
     4.200    15.514     0.200
     4.650    17.918     0.200
     4.930    18.388     0.200
     5.121    19.784     0.200
     5.246    18.708     0.200
     5.363    17.551     0.200
     5.692    18.947     0.200
     5.692    19.431     0.200
     5.994    21.703     0.200
     6.220    21.627     0.200
     6.500    20.971     0.200
     6.799    22.501     0.200
     6.799    22.892     0.200
     6.860    21.049     0.200
     7.420    24.405     0.200
     7.690    21.371     0.200
     8.136    26.745     0.200
     1.783     9.351     0.200
     1.962     9.319     0.200
     2.477     9.734     0.200
     2.477    10.329     0.200
     3.484    12.317     0.200
     3.826    12.693     0.200
     3.871    13.294     0.200
     4.166    13.940     0.200
     4.077    16.628     0.200
     4.496    15.462     0.200
     4.813    14.786     0.200
     4.907    17.891     0.200
     5.111    16.845     0.200
     5.234    14.832     0.200
     5.936    18.540     0.200
     5.977    19.512     0.200
     6.045    18.377     0.200
     6.970    22.794     0.200
     7.414    24.536     0.200
     7.610    24.206     0.200
     7.697    22.704     0.200
     7.697    22.332     0.200
     7.979    24.305     0.200
     9.136    27.545     0.200
     9.819    29.303     0.200
    11.960    35.666     0.200
    16.744    41.219     0.200
     1.599     7.754     0.200
     1.599     7.604     0.200
     1.601     7.643     0.200
     1.744     6.363     0.200
     2.424    10.273     0.200
     2.534     9.748     0.200
     2.653    10.765     0.200
     2.694     9.681     0.200
     2.942    11.370     0.200
     3.077    11.563     0.200
     3.194    11.535     0.200
     3.194    11.166     0.200
     3.210    10.678     0.200
     3.221    11.466     0.200
     3.343    10.615     0.200
     3.505    12.273     0.200
     3.553    11.920     0.200
     3.898    12.730     0.200
     4.185    13.172     0.200
     4.185    12.973     0.200
     4.376    14.088     0.200
     4.502    13.927     0.200
     4.841    14.166     0.200
     4.939    15.622     0.200
     5.176    15.785     0.200
     5.244    15.963     0.200
     5.248    15.660     0.200
     5.431    16.832     0.200
     5.457    16.610     0.200
     5.599    16.252     0.200
     5.830    18.880     0.200
     5.830    17.649     0.200
     5.909    17.939     0.200
     5.929    18.239     0.200
     6.082    19.616     0.200
     6.079    18.995     0.200
     6.079    20.102     0.200
     6.067    18.811     0.200
     6.185    18.415     0.200
     6.304    18.585     0.200
     6.412    20.831     0.200
     6.527    18.732     0.200
     6.532    20.400     0.200
     6.643    21.194     0.200
     6.746    19.084     0.200
     6.721    21.849     0.200
     6.795    20.895     0.200
     6.930    19.636     0.200
     6.980    22.356     0.200
     7.189    23.313     0.200
     7.225    21.684     0.200
     7.244    23.172     0.200
     7.244    21.825     0.200
     7.236    22.624     0.200
     7.331    23.648     0.200
     7.302    21.531     0.200
     7.301    21.875     0.200
     7.444    23.109     0.200
     7.463    22.061     0.200
     7.566    23.836     0.200
     7.663    24.523     0.200
     7.679    22.110     0.200
     7.762    22.416     0.200
     7.770    22.376     0.200
     7.770    22.840     0.200
     7.894    24.589     0.200
     8.067    26.699     0.200
     8.245    25.785     0.200
     8.235    22.960     0.200
     8.235    24.108     0.200
     8.289    27.916     0.200
     8.512    25.338     0.200
     8.512    25.492     0.200
     8.634    26.483     0.200
     8.617    27.737     0.200
     8.676    26.621     0.200
     8.692    25.266     0.200
     8.692    25.993     0.200
     8.750    28.296     0.200
     9.173    30.390     0.200
     9.173    28.694     0.200
     9.160    23.767     0.200
     9.180    30.284     0.200
     9.437    27.635     0.200
     9.464    29.298     0.200
     9.538    29.467     0.200
     9.616    28.598     0.200
     9.670    29.568     0.200
     9.688    30.990     0.200
     9.924    28.025     0.200
     9.924    28.650     0.200
     9.960    31.707     0.200
    10.180    31.603     0.200
    10.179    27.603     0.200
    10.228    31.248     0.200
    10.334    33.415     0.200
    10.334    29.913     0.200
    10.362    28.867     0.200
    10.363    28.273     0.200
    10.499    29.255     0.200
    10.499    31.599     0.200
    10.601    29.393     0.200
    10.613    28.933     0.200
    10.637    29.718     0.200
    10.637    31.540     0.200
    10.641    28.963     0.200
    10.758    33.667     0.200
    10.802    32.758     0.200
    10.813    29.226     0.200
    10.881    30.928     0.200
    10.881    32.957     0.200
    10.876    29.391     0.200
    10.892    29.646     0.200
    10.950    34.605     0.200
    10.991    31.947     0.200
    11.043    34.322     0.200
    11.074    31.703     0.200
    11.173    33.914     0.200
    11.126    29.922     0.200
    11.137    30.186     0.200
    11.145    30.463     0.200
    11.178    30.413     0.200
    11.210    29.975     0.200
    11.307    31.537     0.200
    11.307    32.722     0.200
    11.293    30.155     0.200
    11.334    30.511     0.200
    11.419    35.467     0.200
    11.392    30.496     0.200
    11.420    31.957     0.200
    11.416    30.813     0.200
    11.472    35.105     0.200
    11.495    31.874     0.200
    11.515    31.774     0.200
    11.616    31.756     0.200
    11.617    31.350     0.200
    11.622    31.776     0.200
    11.666    31.754     0.200
    11.666    32.933     0.200
    11.709    33.327     0.200
    11.750    31.914     0.200
    11.767    33.557     0.200
    11.781    32.126     0.200
    11.824    36.432     0.200
    11.811    31.903     0.200
    11.836    31.829     0.200
    11.874    35.977     0.200
    11.911    35.711     0.200
    11.927    36.748     0.200
    11.912    33.151     0.200
    11.927    33.648     0.200
    11.925    32.399     0.200
    11.956    32.600     0.200
    12.104    35.033     0.200
    12.070    32.582     0.200
    12.116    35.519     0.200
    12.116    35.000     0.200
    12.109    33.068     0.200
    12.141    33.133     0.200
    12.167    34.075     0.200
    12.183    33.735     0.200
    12.208    35.247     0.200
    12.267    37.505     0.200
    12.367    33.625     0.200
    12.367    33.501     0.200
    12.449    36.219     0.200
    12.491    35.377     0.200
    12.433    33.368     0.200
    12.446    33.037     0.200
    12.448    33.546     0.200
    12.453    33.925     0.200
    12.489    33.775     0.200
    12.512    33.911     0.200
    12.514    34.059     0.200
    12.520    34.074     0.200
    12.576    36.169     0.200
    12.594    34.976     0.200
    12.657    36.006     0.200
    12.618    34.997     0.200
    12.623    34.151     0.200
    12.632    34.307     0.200
    12.723    33.771     0.200
    12.723    34.100     0.200
    12.752    34.073     0.200
    12.765    34.571     0.200
    12.853    35.340     0.200
    12.919    37.214     0.200
    12.901    34.255     0.200
    12.964    37.158     0.200
    12.946    34.733     0.200
    13.018    37.598     0.200
    12.976    34.802     0.200
    13.051    36.426     0.200
    13.016    34.426     0.200
    13.037    34.580     0.200
    13.046    34.838     0.200
    13.077    38.576     0.200
    13.056    34.614     0.200
    13.110    36.279     0.200
    13.104    35.081     0.200
    13.106    34.698     0.200
    13.123    35.111     0.200
    13.156    36.641     0.200
    13.156    37.680     0.200
    13.158    35.325     0.200
    13.159    34.703     0.200
    13.275    38.845     0.200
    13.249    35.593     0.200
    13.265    34.691     0.200
    13.276    34.828     0.200
    13.304    35.225     0.200
    13.328    34.955     0.200
    13.384    38.666     0.200
    13.367    36.810     0.200
    13.367    38.171     0.200
    13.435    38.372     0.200
    13.396    37.620     0.200
    13.392    35.802     0.200
    13.391    35.807     0.200
    13.458    37.848     0.200
    13.431    35.392     0.200
    13.557    38.815     0.200
    13.542    37.077     0.200
    13.559    35.563     0.200
    13.610    37.199     0.200
    13.641    38.937     0.200
    13.641    39.587     0.200
    13.610    35.320     0.200
    13.618    35.551     0.200
    13.626    35.322     0.200
    13.682    38.041     0.200
    13.682    38.750     0.200
    13.657    36.166     0.200
    13.669    36.613     0.200
    13.699    39.591     0.200
    13.728    36.008     0.200
    13.760    35.967     0.200
    13.764    35.500     0.200
    13.770    36.379     0.200
    13.783    35.684     0.200
    13.811    38.475     0.200
    13.798    35.702     0.200
    13.819    35.983     0.200
    13.868    39.188     0.200
    13.895    39.959     0.200
    13.877    36.267     0.200
    13.911    36.098     0.200
    13.942    40.337     0.200
    13.921    36.093     0.200
    13.921    35.712     0.200
    13.979    36.674     0.200
    14.027    36.587     0.200
    14.024    35.686     0.200
    14.036    37.001     0.200
    14.088    40.035     0.200
    14.047    36.339     0.200
    14.056    36.088     0.200
    14.092    39.996     0.200
    14.084    37.550     0.200
    14.097    37.014     0.200
    14.133    38.030     0.200
    14.133    38.802     0.200
    14.133    38.004     0.200
    14.209    40.650     0.200
    14.219    38.153     0.200
    14.241    37.130     0.200
    14.251    37.131     0.200
    14.271    37.479     0.200
    14.274    36.703     0.200
    14.307    37.432     0.200
    14.407    39.086     0.200
    14.352    36.895     0.200
    14.384    37.730     0.200
    14.379    37.088     0.200
    14.393    37.092     0.200
    14.427    37.301     0.200
    14.430    36.733     0.200
    14.463    41.292     0.200
    14.444    37.388     0.200
    14.507    39.092     0.200
    14.490    36.424     0.200
    14.513    36.823     0.200
    14.550    38.207     0.200
    14.597    37.730     0.200
    14.585    36.769     0.200
    14.592    36.613     0.200
    14.596    37.644     0.200
    14.606    36.484     0.200
    14.632    37.031     0.200
    14.632    36.569     0.200
    14.754    40.342     0.200
    14.726    37.243     0.200
    14.750    39.371     0.200
    14.742    38.744     0.200
    14.810    37.728     0.200
    14.810    39.285     0.200
    14.815    37.371     0.200
    14.828    37.808     0.200
    14.853    37.290     0.200
    14.858    37.018     0.200
    14.858    37.679     0.200
    14.890    38.621     0.200
    14.883    38.416     0.200
    14.940    38.402     0.200
    14.935    37.808     0.200
    14.962    36.659     0.200
    14.936    38.028     0.200
    14.955    38.629     0.200
    14.991    37.619     0.200
    15.008    38.549     0.200
    15.025    38.443     0.200
    15.032    37.297     0.200
    15.061    38.951     0.200
    15.087    37.835     0.200
    15.090    37.853     0.200
    15.133    40.628     0.200
    15.150    39.296     0.200
    15.186    38.300     0.200
    15.188    38.116     0.200
    15.188    39.431     0.200
    15.240    37.845     0.200
    15.302    40.803     0.200
    15.282    37.801     0.200
    15.346    40.941     0.200
    15.317    37.739     0.200
    15.350    37.954     0.200
    15.373    38.042     0.200
    15.373    40.275     0.200
    15.435    38.028     0.200
    15.497    41.108     0.200
    15.470    39.224     0.200
    15.467    39.732     0.200
    15.473    38.403     0.200
    15.478    39.364     0.200
    15.476    38.410     0.200
    15.485    37.870     0.200
    15.498    39.560     0.200
    15.497    38.112     0.200
    15.508    38.589     0.200
    15.531    40.024     0.200
    15.516    38.964     0.200
    15.597    40.537     0.200
    15.596    38.697     0.200
    15.683    41.372     0.200
    15.693    39.892     0.200
    15.704    39.174     0.200
    15.734    39.738     0.200
    15.800    41.927     0.200
    15.778    39.672     0.200
    15.790    39.900     0.200
    15.810    40.086     0.200
    15.800    39.741     0.200
    15.819    39.735     0.200
    15.810    38.849     0.200
    15.843    39.922     0.200
    15.870    39.657     0.200
    15.875    39.837     0.200
    15.895    38.840     0.200
    15.902    38.836     0.200
    15.973    40.009     0.200
    15.962    39.012     0.200
    15.979    38.706     0.200
    16.008    39.230     0.200
    16.036    39.652     0.200
    16.060    40.201     0.200
    16.150    38.673     0.200
    16.161    39.217     0.200
    16.170    39.383     0.200
    16.180    39.392     0.200
    16.185    38.288     0.200
    16.228    41.916     0.200
    16.230    39.661     0.200
    16.256    41.584     0.200
    16.262    39.073     0.200
    16.348    41.329     0.200
    16.302    38.538     0.200
    16.322    40.536     0.200
    16.310    39.305     0.200
    16.315    39.803     0.200
    16.358    40.354     0.200
    16.397    39.875     0.200
    16.409    40.428     0.200
    16.398    39.933     0.200
    16.412    39.713     0.200
    16.479    38.855     0.200
    16.494    40.370     0.200
    16.500    40.715     0.200
    16.539    40.127     0.200
    16.545    39.432     0.200
    16.550    39.841     0.200
    16.550    41.349     0.200
    16.574    39.911     0.200
    16.593    42.006     0.200
    16.645    39.881     0.200
    16.689    39.946     0.200
    16.729    40.904     0.200
    16.732    40.011     0.200
    16.735    39.917     0.200
    16.753    40.361     0.200
    16.777    39.739     0.200
    16.796    40.441     0.200
    16.807    39.812     0.200
    16.884    41.846     0.200
    16.836    39.805     0.200
    16.850    40.174     0.200
    16.865    40.179     0.200
    16.862    39.950     0.200
    16.862    40.325     0.200
    16.907    41.926     0.200
    16.913    41.268     0.200
    16.940    39.542     0.200
    16.948    39.646     0.200
    16.981    41.268     0.200
    16.998    41.501     0.200
    16.985    39.623     0.200
    17.029    40.190     0.200
    17.031    40.101     0.200
    17.052    39.903     0.200
    17.072    40.221     0.200
    17.112    41.432     0.200
    17.118    39.706     0.200
    17.118    41.454     0.200
    17.132    40.571     0.200
    17.178    40.413     0.200
    17.214    40.806     0.200
    17.240    41.980     0.200
    17.283    40.703     0.200
    17.297    41.102     0.200
    17.330    41.340     0.200
    17.357    40.340     0.200
    17.356    40.758     0.200
    17.382    40.554     0.200
    17.399    41.105     0.200
    17.411    40.019     0.200
    17.436    41.416     0.200
    17.462    42.212     0.200
    17.463    42.140     0.200
    17.474    40.425     0.200
    17.486    41.426     0.200
    17.511    40.150     0.200
    17.517    40.338     0.200
    17.577    41.731     0.200
    17.547    40.424     0.200
    17.573    39.957     0.200
    17.581    39.756     0.200
    17.583    39.874     0.200
    17.623    40.035     0.200
    17.721    40.402     0.200
    17.735    40.866     0.200
    17.774    40.689     0.200
    17.789    40.208     0.200
    17.808    41.121     0.200
    17.870    42.082     0.200
    17.866    41.940     0.200
    17.862    40.560     0.200
    17.862    40.590     0.200
    17.895    42.006     0.200
    18.009    40.769     0.200
    18.024    40.770     0.200
    18.024    40.501     0.200
    18.044    41.083     0.200
    18.060    40.745     0.200
    18.143    41.079     0.200
    18.186    41.304     0.200
    18.201    41.978     0.200
    18.255    42.024     0.200
    18.308    41.171     0.200
    18.323    40.439     0.200
    18.349    41.325     0.200
    18.418    43.317     0.200
    18.418    44.798     0.200
    18.405    42.426     0.200
    18.482    42.433     0.200
    18.482    43.634     0.200
    18.574    42.774     0.200
    18.582    43.358     0.200
    19.013    42.777     0.200
    19.064    42.092     0.200
    19.326    42.314     0.200
    19.423    45.652     0.200
    20.062    41.952     0.200
     1.246     6.219     0.200
     2.124     8.897     0.200
     2.473    11.338     0.200
     2.510     9.599     0.200
     2.510     9.146     0.200
     2.710    10.745     0.200
     2.776    10.823     0.200
     2.844    10.755     0.200
     2.922    10.694     0.200
     3.067    12.868     0.200
     3.074    10.847     0.200
     3.074    10.515     0.200
     3.133    11.315     0.200
     3.133    11.542     0.200
     3.080    14.574     0.200
     3.080    13.496     0.200
     3.257    11.434     0.200
     3.183    11.197     0.200
     3.383    13.071     0.200
     3.488    12.213     0.200
     3.635    14.583     0.200
     3.638    12.441     0.200
     3.638    12.168     0.200
     3.642    12.244     0.200
     3.640    13.420     0.200
     4.025    16.035     0.200
     4.148    13.870     0.200
     4.086    13.920     0.200
     4.369    14.556     0.200
     4.443    15.660     0.200
     4.543    17.673     0.200
     4.674    17.458     0.200
     4.971    20.937     0.200
     5.053    16.682     0.200
     5.145    17.254     0.200
     5.174    17.468     0.200
     5.323    18.044     0.200
     5.323    18.548     0.200
     5.587    18.898     0.200
     5.598    17.384     0.200
     5.598    17.591     0.200
     5.743    20.246     0.200
     5.705    18.228     0.200
     5.705    18.829     0.200
     5.930    19.397     0.200
     5.935    20.455     0.200
     6.151    21.132     0.200
     6.272    23.563     0.200
     6.272    19.297     0.200
     6.291    22.884     0.200
     6.383    21.148     0.200
     6.379    20.721     0.200
     6.528    21.996     0.200
     6.569    22.171     0.200
     6.569    20.823     0.200
     6.726    23.716     0.200
     6.723    24.116     0.200
     6.881    25.218     0.200
     6.907    22.552     0.200
     6.938    23.387     0.200
     6.869    19.908     0.200
     6.869    21.131     0.200
     6.869    19.768     0.200
     6.873    20.761     0.200
     6.919    22.987     0.200
     6.971    22.856     0.200
     7.120    21.584     0.200
     7.192    21.436     0.200
     7.312    22.860     0.200
     7.311    25.808     0.200
     7.428    19.810     0.200
     7.428    21.911     0.200
     7.524    25.159     0.200
     7.636    21.497     0.200
     7.636    21.673     0.200
     7.636    22.247     0.200
     7.801    24.126     0.200
     7.871    22.821     0.200
     7.882    22.971     0.200
     7.969    21.959     0.200
     7.986    25.872     0.200
     7.967    24.004     0.200
     7.967    24.301     0.200
     8.157    23.484     0.200
     8.550    24.774     0.200
     8.550    28.137     0.200
     8.698    24.781     0.200
     8.716    25.239     0.200
     8.787    27.904     0.200
     8.905    27.349     0.200
     8.922    28.210     0.200
     8.913    23.501     0.200
     9.048    30.259     0.200
     9.082    24.464     0.200
     9.024    23.900     0.200
     9.025    23.821     0.200
     9.025    23.817     0.200
     9.195    25.339     0.200
     9.221    27.717     0.200
     9.221    29.701     0.200
     9.381    27.508     0.200
     9.416    27.297     0.200
     9.464    27.354     0.200
     9.541    27.660     0.200
     9.575    30.015     0.200
     9.575    28.680     0.200
     9.610    31.843     0.200
     9.960    28.894     0.200
     9.960    28.710     0.200
    10.068    28.253     0.200
    10.086    28.766     0.200
    10.033    27.281     0.200
    10.033    25.711     0.200
    10.057    28.324     0.200
    10.131    29.903     0.200
    10.143    27.261     0.200
    10.186    26.713     0.200
    10.287    26.528     0.200
    10.262    26.343     0.200
    10.579    32.170     0.200
    10.554    30.746     0.200
    10.554    29.645     0.200
    10.654    28.895     0.200
    11.011    30.224     0.200
    11.062    33.100     0.200
    11.154    32.291     0.200
    11.169    29.460     0.200
    11.398    31.440     0.200
    11.398    31.155     0.200
    11.549    35.105     0.200
    12.116    31.744     0.200
    12.208    32.609     0.200
    12.208    31.339     0.200
    12.312    31.207     0.200
    12.348    33.212     0.200
    12.419    32.736     0.200
    12.364    32.636     0.200
    12.364    32.246     0.200
    12.497    33.533     0.200
    12.601    35.297     0.200
    12.601    32.988     0.200
    12.601    31.777     0.200
    12.601    34.007     0.200
    12.601    32.136     0.200
    12.797    37.219     0.200
    12.833    37.643     0.200
    12.905    38.418     0.200
    12.916    34.089     0.200
    12.899    36.643     0.200
    12.899    33.729     0.200
    12.849    33.061     0.200
    12.934    33.799     0.200
    12.903    32.411     0.200
    13.046    37.370     0.200
    13.117    37.097     0.200
    13.117    37.237     0.200
    13.178    36.764     0.200
    13.327    37.544     0.200
    13.380    35.884     0.200
    13.484    39.831     0.200
    13.497    34.061     0.200
    13.422    34.523     0.200
    13.422    34.902     0.200
    13.726    36.415     0.200
    13.882    39.245     0.200
    13.985    38.344     0.200
    14.148    40.656     0.200
    14.094    36.334     0.200
    14.178    38.456     0.200
    14.245    37.907     0.200
    14.737    40.904     0.200
    14.684    36.536     0.200
    14.860    40.924     0.200
    14.814    35.599     0.200
    14.917    39.869     0.200
    14.964    37.566     0.200
    15.040    40.803     0.200
    15.040    40.108     0.200
    14.977    35.238     0.200
    15.041    35.659     0.200
    15.041    37.210     0.200
    15.110    37.251     0.200
    15.214    38.055     0.200
    15.303    37.448     0.200
    15.349    38.651     0.200
    15.440    39.644     0.200
    15.479    38.267     0.200
    15.578    40.357     0.200
    15.578    39.572     0.200
    15.557    37.071     0.200
    15.578    38.706     0.200
    15.635    38.621     0.200
    15.679    38.123     0.200
    15.747    39.256     0.200
    15.793    38.373     0.200
    15.782    38.787     0.200
    15.861    38.471     0.200
    15.925    38.469     0.200
    15.925    39.087     0.200
    16.073    38.207     0.200
    16.073    39.235     0.200
    16.161    38.773     0.200
    16.150    38.311     0.200
    16.150    38.749     0.200
    16.192    39.410     0.200
    16.196    39.394     0.200
    16.196    39.000     0.200
    16.200    39.125     0.200
    16.224    38.825     0.200
    16.309    39.790     0.200
    16.242    39.518     0.200
    16.320    38.895     0.200
    16.319    39.204     0.200
    16.534    38.581     0.200
    16.534    39.272     0.200
    16.556    39.813     0.200
    16.556    41.493     0.200
    16.581    36.662     0.200
    16.590    38.448     0.200
    16.605    38.017     0.200
    16.725    39.907     0.200
    16.788    38.704     0.200
    16.839    39.598     0.200
    16.920    39.294     0.200
    16.968    39.782     0.200
    16.990    40.234     0.200
    17.081    39.630     0.200
    17.021    39.169     0.200
    17.054    40.717     0.200
    17.107    41.876     0.200
    17.072    39.986     0.200
    17.131    40.053     0.200
    17.118    40.661     0.200
    17.158    39.987     0.200
    17.166    38.874     0.200
    17.378    41.483     0.200
    17.305    39.484     0.200
    17.332    40.416     0.200
    17.450    39.855     0.200
    17.418    40.463     0.200
    17.477    39.885     0.200
    17.537    41.125     0.200
    17.528    40.825     0.200
    17.535    40.604     0.200
    17.654    42.056     0.200
    17.611    40.430     0.200
    17.618    42.006     0.200
    17.649    40.411     0.200
    17.645    40.339     0.200
    17.762    40.360     0.200
    17.709    41.209     0.200
    17.739    40.210     0.200
    17.760    39.713     0.200
    17.798    40.613     0.200
    17.846    39.774     0.200
    17.869    39.710     0.200
    17.996    41.841     0.200
    17.989    41.001     0.200
    17.989    40.129     0.200
    18.002    40.216     0.200
    18.032    41.730     0.200
    18.041    40.310     0.200
    18.124    41.374     0.200
    18.112    41.160     0.200
    18.112    41.570     0.200
    18.145    40.916     0.200
    18.159    41.048     0.200
    18.213    40.752     0.200
    18.233    41.013     0.200
    18.261    41.103     0.200
    18.332    39.446     0.200
    18.392    39.910     0.200
    18.341    40.519     0.200
    18.434    43.575     0.200
    18.663    46.394     0.200
    19.002    43.420     0.200
    19.300    42.866     0.200
    20.090    42.483     0.200
    20.568    42.525     0.200
     1.287     5.452     0.200
     1.369     7.032     0.200
     2.572     9.764     0.200
     2.572     9.615     0.200
     2.757    10.589     0.200
     2.828     9.661     0.200
     2.879    12.162     0.200
     2.879    10.763     0.200
     2.879    10.865     0.200
     3.050    12.058     0.200
     3.050    11.870     0.200
     2.959    10.847     0.200
     3.112    11.616     0.200
     3.115    11.295     0.200
     3.223    12.113     0.200
     3.223    10.488     0.200
     3.197    11.459     0.200
     3.527    12.383     0.200
     3.527    12.336     0.200
     3.668    12.018     0.200
     3.687    13.071     0.200
     3.689    13.040     0.200
     3.689    12.227     0.200
     4.104    14.429     0.200
     4.071    13.472     0.200
     4.441    15.132     0.200
     4.509    15.064     0.200
     4.574    16.838     0.200
     4.684    14.748     0.200
     4.710    15.766     0.200
     4.801    16.447     0.200
     4.818    17.016     0.200
     4.986    16.144     0.200
     5.016    20.021     0.200
     5.200    15.203     0.200
     5.279    16.691     0.200
     5.279    16.019     0.200
     5.385    17.996     0.200
     5.385    17.816     0.200
     5.627    17.948     0.200
     5.566    19.364     0.200
     5.647    17.285     0.200
     5.682    19.332     0.200
     5.760    19.137     0.200
     5.760    18.551     0.200
     5.797    17.438     0.200
     5.884    17.909     0.200
     6.000    19.714     0.200
     5.994    19.498     0.200
     6.107    20.174     0.200
     6.194    18.129     0.200
     6.208    19.011     0.200
     6.323    22.409     0.200
     6.323    19.565     0.200
     6.350    19.213     0.200
     6.506    20.893     0.200
     6.445    20.331     0.200
     6.440    22.185     0.200
     6.631    21.919     0.200
     6.631    20.489     0.200
     6.778    20.224     0.200
     6.775    19.748     0.200
     6.914    21.449     0.200
     6.915    21.735     0.200
     6.924    20.346     0.200
     6.973    22.572     0.200
     6.985    23.594     0.200
     6.997    21.166     0.200
     7.038    22.466     0.200
     7.159    21.646     0.200
     7.225    24.955     0.200
     7.232    22.873     0.200
     7.446    22.860     0.200
     7.446    21.953     0.200
     7.356    28.267     0.200
     7.371    33.175     0.200
     7.590    24.984     0.200
     7.677    21.772     0.200
     7.680    22.981     0.200
     7.680    23.668     0.200
     7.680    21.583     0.200
     7.680    22.752     0.200
     7.826    26.213     0.200
     7.865    23.968     0.200
     7.937    23.510     0.200
     7.939    35.364     0.200
     8.026    24.677     0.200
     8.026    22.818     0.200
     8.051    25.704     0.200
     8.141    26.872     0.200
     8.108    24.134     0.200
     8.162    28.276     0.200
     8.205    19.369     0.200
     8.211    29.219     0.200
     8.369    26.346     0.200
     8.495    34.530     0.200
     8.608    28.047     0.200
     8.608    28.446     0.200
     8.675    26.479     0.200
     8.724    28.353     0.200
     8.741    29.048     0.200
     8.746    28.371     0.200
     8.758    26.712     0.200
     8.775    28.927     0.200
     8.777    22.132     0.200
     8.780    28.571     0.200
     8.819    29.203     0.200
     8.766    26.331     0.200
     8.849    27.925     0.200
     8.854    28.354     0.200
     8.862    29.406     0.200
     8.963    28.298     0.200
     9.023    26.212     0.200
     9.024    25.750     0.200
     8.970    24.978     0.200
     8.988    28.021     0.200
     9.100    30.539     0.200
     9.107    29.216     0.200
     9.134    28.631     0.200
     9.277    24.306     0.200
     9.260    28.596     0.200
     9.482    31.108     0.200
     9.529    29.160     0.200
     9.607    30.645     0.200
     9.641    30.281     0.200
     9.641    26.320     0.200
     9.667    31.848     0.200
     9.861    33.376     0.200
     9.865    32.598     0.200
    10.012    28.877     0.200
    10.012    26.690     0.200
    10.063    31.187     0.200
    10.063    26.273     0.200
    10.126    32.733     0.200
    10.139    32.857     0.200
    10.181    30.593     0.200
    10.209    31.274     0.200
    10.252    31.509     0.200
    10.290    32.369     0.200
    10.290    29.501     0.200
    10.321    30.689     0.200
    10.353    31.696     0.200
    10.616    31.310     0.200
    10.616    29.661     0.200
    10.635    33.527     0.200
    10.720    33.036     0.200
    10.778    32.743     0.200
    11.066    27.909     0.200
    11.202    32.100     0.200
    11.202    30.733     0.200
    11.175    33.333     0.200
    11.220    33.572     0.200
    11.455    32.719     0.200
    11.455    29.563     0.200
    11.603    32.250     0.200
    11.971    31.841     0.200
    12.012    36.595     0.200
    12.217    33.232     0.200
    12.217    32.943     0.200
    12.177    33.062     0.200
    12.168    37.189     0.200
    12.384    33.811     0.200
    12.384    32.975     0.200
    12.354    35.624     0.200
    12.378    35.203     0.200
    12.398    36.547     0.200
    12.410    36.364     0.200
    12.469    38.101     0.200
    12.547    37.594     0.200
    12.547    32.899     0.200
    12.557    35.405     0.200
    12.666    34.443     0.200
    12.666    32.162     0.200
    12.666    34.942     0.200
    12.666    34.989     0.200
    12.666    34.333     0.200
    12.721    41.957     0.200
    12.816    38.549     0.200
    12.900    31.682     0.200
    12.853    37.535     0.200
    12.898    37.308     0.200
    12.965    37.034     0.200
    12.965    36.901     0.200
    12.959    37.622     0.200
    13.000    36.233     0.200
    12.968    38.207     0.200
    13.110    35.759     0.200
    13.112    36.496     0.200
    13.130    31.256     0.200
    13.172    37.974     0.200
    13.172    38.615     0.200
    13.244    37.122     0.200
    13.251    37.670     0.200
    13.282    36.363     0.200
    13.329    39.377     0.200
    13.393    36.794     0.200
    13.451    35.154     0.200
    13.451    34.623     0.200
    13.442    36.489     0.200
    13.442    35.231     0.200
    13.406    39.104     0.200
    13.510    37.570     0.200
    13.542    38.203     0.200
    13.727    38.058     0.200
    14.030    37.898     0.200
    13.941    38.998     0.200
    14.105    37.803     0.200
    14.105    36.865     0.200
    14.051    36.855     0.200
    14.159    37.064     0.200
    14.159    36.767     0.200
    14.194    37.284     0.200
    14.194    36.690     0.200
    14.206    38.916     0.200
    14.244    39.406     0.200
    14.291    37.346     0.200
    14.291    36.986     0.200
    14.253    40.189     0.200
    14.303    38.459     0.200
    14.368    41.326     0.200
    14.397    40.066     0.200
    14.367    38.801     0.200
    14.490    39.917     0.200
    14.795    39.748     0.200
    14.860    39.651     0.200
    14.920    41.214     0.200
    14.924    41.747     0.200
    14.982    39.472     0.200
    15.065    39.439     0.200
    15.106    41.050     0.200
    15.106    40.831     0.200
    15.201    41.219     0.200
    15.266    41.433     0.200
    15.499    41.685     0.200
    15.540    41.923     0.200
    15.545    40.689     0.200
    15.580    41.310     0.200
    15.639    39.466     0.200
    15.639    38.701     0.200
    15.687    39.151     0.200
    15.603    39.799     0.200
    15.734    40.839     0.200
    15.802    41.863     0.200
    15.917    42.386     0.200
    16.105    40.664     0.200
    16.105    39.969     0.200
    16.194    42.177     0.200
    16.227    41.685     0.200
    16.227    41.318     0.200
    16.239    41.993     0.200
    16.328    40.861     0.200
    16.363    41.740     0.200
    16.372    42.075     0.200
    16.373    41.782     0.200
    16.571    41.221     0.200
    16.571    40.065     0.200
    16.576    40.116     0.200
    16.576    39.452     0.200
    16.726    41.887     0.200
    16.726    39.566     0.200
    16.895    41.817     0.200
    17.008    41.898     0.200
    17.192    40.158     0.200
    17.171    41.277     0.200
    17.171    40.590     0.200
    17.332    39.205     0.200
    17.253    42.375     0.200
    17.294    41.674     0.200
    17.496    40.105     0.200
    17.440    42.357     0.200
    17.563    41.155     0.200
    17.514    42.370     0.200
    17.636    41.160     0.200
    17.650    40.774     0.200
    17.666    39.842     0.200
    17.720    41.993     0.200
    17.790    39.552     0.200
    17.822    40.534     0.200
    17.860    40.784     0.200
    17.881    41.597     0.200
    17.953    41.274     0.200
    18.029    40.006     0.200
    18.049    39.691     0.200
    18.060    39.322     0.200
    18.140    41.738     0.200
    18.140    40.378     0.200
    18.165    40.759     0.200
    18.118    41.861     0.200
    18.196    40.276     0.200
    18.238    41.936     0.200
    18.238    40.014     0.200
    18.217    41.105     0.200
    18.266    40.669     0.200
    18.224    42.299     0.200
    18.373    40.824     0.200
    18.330    41.242     0.200
    18.440    41.067     0.200
    18.458    43.189     0.200
    18.442    43.083     0.200
    18.578    43.623     0.200
    18.786    42.537     0.200
    18.803    42.580     0.200
    18.813    43.533     0.200
    18.960    43.867     0.200
    18.970    42.121     0.200
    19.023    42.325     0.200
    19.063    43.748     0.200
    19.094    44.551     0.200
    19.088    42.151     0.200
    19.095    41.968     0.200
    19.364    42.418     0.200
    19.456    42.309     0.200
    19.442    42.565     0.200
    19.933    43.285     0.200
    19.937    41.783     0.200
    20.007    41.845     0.200
    20.081    43.306     0.200
    20.140    42.622     0.200
    20.146    42.189     0.200
    20.168    41.755     0.200
    20.519    41.640     0.200
    20.658    41.971     0.200
    20.773    42.779     0.200
    20.777    41.692     0.200
    20.784    45.106     0.200
    20.912    41.423     0.200
    21.034    43.282     0.200
     1.256     7.228     0.200
     1.401     7.586     0.200
     1.465     7.539     0.200
     1.676     7.436     0.200
     1.946     8.623     0.200
     1.946     8.927     0.200
     2.097     8.907     0.200
     2.071     9.727     0.200
     2.133     9.506     0.200
     2.517    10.047     0.200
     2.543    12.014     0.200
     2.535    10.507     0.200
     2.585    11.235     0.200
     3.220    11.721     0.200
     3.220    12.033     0.200
     3.251    12.101     0.200
     3.454    13.773     0.200
     3.753    14.468     0.200
     3.926    12.890     0.200
     4.099    13.931     0.200
     4.636    13.928     0.200
     4.850    16.209     0.200
     5.084    18.539     0.200
     5.425    16.206     0.200
     5.507    19.889     0.200
     5.937    17.552     0.200
     6.032    21.626     0.200
     6.631    23.278     0.200
     9.631    25.553     0.200
     1.291     6.482     0.200
     1.397     6.772     0.200
     1.393     8.388     0.200
     1.393     8.185     0.200
     1.395     8.115     0.200
     1.395     8.224     0.200
     1.591     9.063     0.200
     1.807     9.741     0.200
     1.905     9.253     0.200
     1.905     8.847     0.200
     2.121    11.014     0.200
     2.258    12.223     0.200
     2.756    11.356     0.200
     2.756    11.727     0.200
     2.876    12.136     0.200
     2.960    13.095     0.200
     2.960    12.486     0.200
     2.971    12.185     0.200
     3.013    12.571     0.200
     3.013    12.001     0.200
     3.214    13.034     0.200
     3.214    12.675     0.200
     3.229    13.030     0.200
     3.396    13.426     0.200
     3.396    13.192     0.200
     3.398    12.557     0.200
     3.398    13.186     0.200
     3.488    13.156     0.200
     3.426    14.431     0.200
     3.621    13.595     0.200
     3.668    13.904     0.200
     3.712    14.284     0.200
     3.712    14.717     0.200
     3.825    14.300     0.200
     3.828    14.563     0.200
     3.828    14.133     0.200
     3.828    13.973     0.200
     3.891    14.278     0.200
     3.925    14.521     0.200
     3.981    14.606     0.200
     4.221    15.663     0.200
     4.413    15.495     0.200
     4.609    15.879     0.200
     4.601    17.187     0.200
     4.635    16.269     0.200
     4.720    16.544     0.200
     4.849    16.836     0.200
     5.128    23.074     0.200
     5.162    18.177     0.200
     5.405    18.745     0.200
     5.439    19.124     0.200
     5.439    18.074     0.200
     5.605    19.841     0.200
     5.605    19.145     0.200
     5.789    20.338     0.200
     5.771    19.798     0.200
     5.771    19.067     0.200
     5.771    18.825     0.200
     5.942    20.782     0.200
     5.969    20.712     0.200
     5.969    20.270     0.200
     6.191    21.181     0.200
     6.220    21.648     0.200
     6.364    20.242     0.200
     6.456    21.880     0.200
     6.456    21.599     0.200
     6.660    21.706     0.200
     6.709    23.151     0.200
     6.815    22.634     0.200
     6.815    22.189     0.200
     6.929    22.839     0.200
     7.079    22.316     0.200
     7.073    24.973     0.200
     7.187    24.041     0.200
     7.204    24.620     0.200
     7.253    24.140     0.200
     7.461    25.889     0.200
     7.555    23.746     0.200
     7.555    21.539     0.200
     7.808    26.047     0.200
     7.860    23.563     0.200
     7.860    23.989     0.200
     7.860    23.032     0.200
     8.062    26.192     0.200
     8.062    24.965     0.200
     8.119    25.338     0.200
     8.147    26.153     0.200
     8.120    23.166     0.200
     8.120    23.685     0.200
     8.239    26.284     0.200
     8.239    24.968     0.200
     8.270    27.653     0.200
     8.312    28.248     0.200
     8.327    26.668     0.200
     8.361    26.186     0.200
     8.713    28.645     0.200
     8.729    26.668     0.200
     8.775    28.455     0.200
     8.775    26.838     0.200
     8.851    28.053     0.200
     8.892    27.425     0.200
     8.942    26.769     0.200
     8.959    28.118     0.200
     8.964    26.857     0.200
     8.974    28.492     0.200
     8.986    27.761     0.200
     8.992    27.860     0.200
     8.993    27.366     0.200
     8.995    25.453     0.200
     8.999    27.154     0.200
     9.027    28.390     0.200
     9.036    28.228     0.200
     9.062    28.449     0.200
     9.068    28.340     0.200
     9.072    28.666     0.200
     9.074    28.252     0.200
     9.074    28.262     0.200
     9.075    27.379     0.200
     9.075    27.832     0.200
     9.190    29.032     0.200
     9.187    28.660     0.200
     9.207    29.301     0.200
     9.202    29.077     0.200
     9.230    29.121     0.200
     9.253    28.932     0.200
     9.272    27.710     0.200
     9.280    29.051     0.200
     9.480    27.840     0.200
     9.484    28.977     0.200
     9.484    27.797     0.200
     9.598    28.712     0.200
     9.700    29.472     0.200
     9.823    28.745     0.200
     9.825    29.895     0.200
     9.856    29.656     0.200
    10.011    28.819     0.200
    10.022    27.810     0.200
    10.214    30.915     0.200
    10.214    28.896     0.200
    10.208    30.959     0.200
    10.280    28.908     0.200
    10.289    29.051     0.200
    10.399    31.484     0.200
    10.399    30.394     0.200
    10.428    30.098     0.200
    10.470    30.018     0.200
    10.482    30.300     0.200
    10.482    34.960     0.200
    10.567    31.487     0.200
    10.813    32.336     0.200
    10.835    32.391     0.200
    10.835    30.676     0.200
    10.938    33.226     0.200
    11.360    33.269     0.200
    11.356    32.305     0.200
    11.393    34.530     0.200
    11.434    33.173     0.200
    11.667    34.787     0.200
    12.299    34.033     0.200
    12.393    34.843     0.200
    12.500    33.001     0.200
    12.565    37.042     0.200
    12.573    35.439     0.200
    12.592    37.997     0.200
    12.596    37.010     0.200
    12.745    30.066     0.200
    12.755    37.158     0.200
    12.886    35.716     0.200
    12.886    34.367     0.200
    12.886    37.976     0.200
    12.886    35.855     0.200
    12.937    34.600     0.200
    12.947    37.098     0.200
    13.099    36.741     0.200
    13.101    35.411     0.200
    13.103    35.845     0.200
    13.218    36.429     0.200
    13.320    38.636     0.200
    13.320    39.296     0.200
    13.331    34.202     0.200
    13.437    33.193     0.200
    13.462    36.362     0.200
    13.561    35.438     0.200
    13.594    36.631     0.200
    13.661    37.831     0.200
    13.728    37.564     0.200
    13.924    37.792     0.200
    14.109    36.950     0.200
    14.269    41.239     0.200
    14.322    37.366     0.200
    14.462    41.412     0.200
    14.475    40.585     0.200
    14.482    40.968     0.200
    14.476    37.616     0.200
    14.533    40.925     0.200
    14.567    41.342     0.200
    14.615    40.347     0.200
    14.579    37.419     0.200
    14.633    39.410     0.200
    14.685    41.011     0.200
    14.821    39.653     0.200
    14.957    39.916     0.200
    15.202    41.309     0.200
    15.213    41.350     0.200
    15.388    41.386     0.200
    15.719    40.942     0.200
    15.777    40.820     0.200
    15.775    40.956     0.200
    15.765    41.417     0.200
    15.856    40.198     0.200
    15.963    40.661     0.200
    15.988    42.536     0.200
    16.254    42.665     0.200
    16.311    42.257     0.200
    16.437    41.294     0.200
    16.460    42.622     0.200
    16.559    41.556     0.200
    16.563    41.548     0.200
    17.391    41.132     0.200
    17.391    39.527     0.200
    17.488    40.152     0.200
    17.709    41.823     0.200
    17.768    40.696     0.200
    17.937    41.569     0.200
    18.056    41.699     0.200
    18.504    42.354     0.200
    18.668    43.837     0.200
    18.807    43.637     0.200
    19.016    45.468     0.200
    19.618    42.132     0.200
     1.414     6.323     0.200
     1.376     7.951     0.200
     1.378     7.927     0.200
     1.545     8.976     0.200
     1.987     8.950     0.200
     2.290     9.936     0.200
     2.310     9.720     0.200
     2.803    11.319     0.200
     2.803    10.854     0.200
     2.892    13.163     0.200
     2.960    12.727     0.200
     2.998    12.592     0.200
     3.038    12.475     0.200
     3.038    12.295     0.200
     3.038    13.715     0.200
     3.221    13.306     0.200
     3.244    13.620     0.200
     3.451    14.469     0.200
     3.451    13.260     0.200
     3.479    12.831     0.200
     3.479    12.211     0.200
     3.479    11.933     0.200
     3.527    13.755     0.200
     3.400    17.360     0.200
     3.625    13.399     0.200
     3.625    14.946     0.200
     3.849    14.420     0.200
     3.851    14.285     0.200
     3.851    15.220     0.200
     3.938    14.262     0.200
     3.985    14.702     0.200
     4.015    16.526     0.200
     3.942    14.368     0.200
     4.291    15.520     0.200
     4.469    16.964     0.200
     4.652    17.133     0.200
     4.681    17.552     0.200
     4.783    17.329     0.200
     4.787    17.310     0.200
     4.884    20.151     0.200
     4.938    19.264     0.200
     5.139    18.559     0.200
     5.171    19.373     0.200
     5.472    19.273     0.200
     5.472    19.754     0.200
     5.488    18.991     0.200
     5.683    19.610     0.200
     5.798    20.097     0.200
     5.865    21.561     0.200
     5.846    18.894     0.200
     5.846    19.137     0.200
     5.967    23.059     0.200
     6.052    20.140     0.200
     6.052    20.501     0.200
     6.244    20.697     0.200
     6.292    21.154     0.200
     6.395    23.060     0.200
     6.476    21.560     0.200
     6.476    22.651     0.200
     6.633    22.914     0.200
     6.727    22.062     0.200
     6.778    22.629     0.200
     6.860    22.381     0.200
     6.860    23.929     0.200
     6.917    27.279     0.200
     7.160    22.340     0.200
     7.160    22.529     0.200
     7.201    26.192     0.200
     7.252    23.009     0.200
     7.275    24.486     0.200
     7.047    26.473     0.200
     7.320    24.050     0.200
     7.469    20.901     0.200
     7.623    19.597     0.200
     7.623    23.053     0.200
     7.879    26.155     0.200
     7.942    23.144     0.200
     7.942    24.049     0.200
     7.942    23.689     0.200
     7.942    23.427     0.200
     8.114    25.193     0.200
     8.127    24.567     0.200
     8.210    25.855     0.200
     8.148    23.820     0.200
     8.320    26.549     0.200
     8.340    27.544     0.200
     8.340    20.746     0.200
     8.396    26.354     0.200
     8.388    29.560     0.200
     8.792    29.985     0.200
     8.810    29.246     0.200
     8.810    31.417     0.200
     8.925    28.159     0.200
     8.882    26.979     0.200
     8.973    28.241     0.200
     9.044    28.073     0.200
     9.055    28.175     0.200
     9.066    28.452     0.200
     9.062    26.286     0.200
     9.142    28.581     0.200
     9.126    24.839     0.200
     9.127    26.241     0.200
     9.127    26.622     0.200
     9.567    30.235     0.200
     9.923    32.471     0.200
    10.297    34.295     0.200
    10.284    31.637     0.200
    10.284    33.391     0.200
    10.455    29.081     0.200
    10.455    31.320     0.200
    10.564    34.341     0.200
    10.616    32.479     0.200
    10.914    32.513     0.200
    11.433    35.005     0.200
    11.749    38.647     0.200
    11.772    38.746     0.200
    12.359    30.703     0.200
    12.359    37.689     0.200
    12.652    29.563     0.200
    12.828    38.435     0.200
    12.960    37.310     0.200
    12.960    37.209     0.200
    12.960    35.956     0.200
    12.768    34.553     0.200
    12.997    41.124     0.200
    13.155    38.716     0.200
    13.288    39.101     0.200
    13.346    38.551     0.200
    13.401    39.302     0.200
    13.531    30.500     0.200
    13.740    38.286     0.200
    13.798    39.873     0.200
    14.400    33.078     0.200
    14.551    32.884     0.200
    14.558    39.422     0.200
    14.602    33.756     0.200
    14.652    31.818     0.200
    14.659    32.670     0.200
    14.702    32.962     0.200
    14.649    38.645     0.200
    14.743    32.392     0.200
    15.028    31.939     0.200
    15.064    34.735     0.200
    15.289    33.993     0.200
    15.761    35.766     0.200
    15.765    36.823     0.200
    16.611    36.328     0.200
    16.830    35.949     0.200
    16.897    36.804     0.200
    17.005    41.016     0.200
    17.257    33.736     0.200
    17.393    37.500     0.200
    17.467    37.321     0.200
    17.472    40.039     0.200
    17.565    37.869     0.200
    17.669    35.706     0.200
    17.761    39.557     0.200
    17.801    37.405     0.200
    17.875    41.487     0.200
    18.127    41.109     0.200
    18.311    37.418     0.200
    18.353    41.462     0.200
    18.648    43.926     0.200
    18.747    43.392     0.200
    18.880    42.998     0.200
    18.948    45.759     0.200
    19.041    45.407     0.200
    18.998    42.428     0.200
    19.225    42.498     0.200
    19.308    42.563     0.200
    19.389    42.738     0.200
    19.507    43.264     0.200
    19.661    43.258     0.200
    19.658    44.677     0.200
    19.697    42.136     0.200
    19.905    41.457     0.200
    20.047    42.121     0.200
    20.098    44.329     0.200
    20.275    41.578     0.200
    20.405    42.006     0.200
    20.649    41.743     0.200
    20.765    42.257     0.200
    21.056    41.274     0.200
     1.186     6.894     0.200
     1.186     7.004     0.200
     1.278     6.756     0.200
     1.278     6.346     0.200
     1.403     8.822     0.200
     1.953    10.753     0.200
     1.925     9.313     0.200
     2.088     8.877     0.200
     2.088     9.084     0.200
     2.105     9.263     0.200
     2.134     9.608     0.200
     2.324     9.976     0.200
     2.488    11.675     0.200
     2.631    10.336     0.200
     2.614    10.559     0.200
     2.614    10.973     0.200
     2.685    10.206     0.200
     2.793    10.079     0.200
     2.844    12.082     0.200
     2.897    11.834     0.200
     3.015    12.371     0.200
     3.037    11.797     0.200
     3.219    12.515     0.200
     3.330    12.478     0.200
     3.420    12.820     0.200
     3.420    13.253     0.200
     3.485    11.558     0.200
     3.485    12.793     0.200
     3.605    13.901     0.200
     3.645    13.441     0.200
     3.645    12.340     0.200
     3.645    14.219     0.200
     3.748    13.376     0.200
     3.813    14.010     0.200
     3.916    14.141     0.200
     3.993    14.060     0.200
     4.061    14.543     0.200
     4.291    14.951     0.200
     4.399    15.966     0.200
     4.428    16.301     0.200
     4.458    15.486     0.200
     4.585    16.884     0.200
     4.594    16.599     0.200
     4.683    16.783     0.200
     4.708    16.184     0.200
     4.731    15.768     0.200
     4.932    19.795     0.200
     4.965    18.325     0.200
     4.959    16.220     0.200
     5.109    16.893     0.200
     5.142    16.782     0.200
     5.270    18.265     0.200
     5.270    19.198     0.200
     5.407    19.234     0.200
     5.423    18.562     0.200
     5.592    18.102     0.200
     5.579    18.806     0.200
     5.579    19.212     0.200
     5.668    18.544     0.200
     5.762    19.743     0.200
     5.893    18.989     0.200
     5.893    19.434     0.200
     6.029    22.305     0.200
     5.992    19.834     0.200
     5.992    20.791     0.200
     6.076    22.033     0.200
     6.062    20.693     0.200
     6.191    21.096     0.200
     6.269    20.776     0.200
     6.361    20.459     0.200
     6.428    21.200     0.200
     6.574    21.800     0.200
     6.632    22.103     0.200
     6.667    22.148     0.200
     6.667    22.269     0.200
     6.710    21.961     0.200
     6.753    21.854     0.200
     6.825    22.392     0.200
     6.945    22.900     0.200
     7.001    22.450     0.200
     7.136    24.562     0.200
     7.168    23.906     0.200
     7.171    22.943     0.200
     7.263    23.426     0.200
     7.349    23.477     0.200
     7.706    23.797     0.200
     7.706    23.140     0.200
     7.739    26.128     0.200
     7.921    24.594     0.200
     7.931    24.809     0.200
     7.938    22.754     0.200
     7.938    23.836     0.200
     8.085    25.441     0.200
     8.184    27.124     0.200
     8.198    25.820     0.200
     8.250    27.647     0.200
     8.247    25.978     0.200
     8.273    25.203     0.200
     8.609    27.367     0.200
     8.609    26.816     0.200
     8.676    25.718     0.200
     8.632    25.475     0.200
     8.699    29.253     0.200
     8.795    28.682     0.200
     8.883    27.746     0.200
     8.920    27.096     0.200
     8.945    27.651     0.200
     8.968    27.913     0.200
     8.978    28.227     0.200
     8.980    26.781     0.200
     8.980    28.136     0.200
     8.983    28.241     0.200
     9.191    28.023     0.200
     9.217    28.995     0.200
     9.259    26.856     0.200
     9.259    26.854     0.200
     9.260    26.097     0.200
     9.260    26.804     0.200
     9.427    29.039     0.200
     9.509    26.244     0.200
     9.769    30.203     0.200
     9.769    31.492     0.200
    10.278    31.027     0.200
    10.254    31.191     0.200
    10.254    31.816     0.200
    10.330    30.568     0.200
    10.359    32.569     0.200
    10.542    32.629     0.200
    10.813    30.814     0.200
    11.300    31.554     0.200
    11.319    34.935     0.200
    11.468    32.353     0.200
    11.468    33.724     0.200
    11.566    32.584     0.200
    11.679    32.397     0.200
    11.919    33.357     0.200
    12.390    33.952     0.200
    12.517    35.555     0.200
    12.468    35.784     0.200
    12.646    34.987     0.200
    12.834    35.055     0.200
    12.794    34.969     0.200
    12.830    34.500     0.200
    12.831    36.366     0.200
    12.831    35.764     0.200
    12.922    37.511     0.200
    12.962    39.543     0.200
    13.064    36.813     0.200
    13.140    37.952     0.200
    13.134    38.110     0.200
    13.385    37.823     0.200
    13.717    37.496     0.200
    13.870    37.381     0.200
    13.944    38.572     0.200
    14.197    40.480     0.200
    14.336    38.223     0.200
    14.454    37.931     0.200
    14.454    38.447     0.200
    14.546    38.021     0.200
    14.546    39.009     0.200
    14.788    40.397     0.200
    14.830    39.237     0.200
    14.930    40.071     0.200
    15.046    39.827     0.200
    15.139    40.195     0.200
    15.237    41.252     0.200
    15.541    40.123     0.200
    15.844    39.971     0.200
    15.844    41.420     0.200
    15.854    41.610     0.200
    15.937    41.629     0.200
    16.324    41.678     0.200
    16.332    42.214     0.200
    16.383    41.948     0.200
    16.371    40.562     0.200
    16.830    40.758     0.200
    16.836    41.528     0.200
    16.973    40.333     0.200
    16.973    42.407     0.200
    17.013    41.349     0.200
    17.307    42.024     0.200
    17.347    42.180     0.200
    17.829    41.683     0.200
    18.297    42.507     0.200
    18.446    42.669     0.200
    18.847    44.879     0.200
    19.069    42.949     0.200
    19.221    44.801     0.200
    19.263    42.656     0.200
    19.327    42.305     0.200
    19.545    42.747     0.200
    19.901    42.529     0.200
    20.400    42.453     0.200
     1.265     7.944     0.200
     2.012    10.354     0.200
     2.183     9.245     0.200
     2.198     9.613     0.200
     2.198    10.785     0.200
     2.342    10.548     0.200
     2.441    11.642     0.200
     2.573    11.017     0.200
     2.661    11.701     0.200
     2.705    10.616     0.200
     2.758    11.757     0.200
     2.859    11.764     0.200
     2.925    13.666     0.200
     2.976    11.379     0.200
     3.093    12.551     0.200
     3.111    11.946     0.200
     3.133    13.271     0.200
     3.133    14.872     0.200
     3.133    15.060     0.200
     3.385    13.692     0.200
     3.500    11.747     0.200
     3.500    13.786     0.200
     3.434    14.619     0.200
     3.619    14.817     0.200
     3.538    12.122     0.200
     3.538    16.185     0.200
     3.711    13.109     0.200
     3.713    14.345     0.200
     3.713    13.673     0.200
     3.873    14.977     0.200
     3.833    17.109     0.200
     4.068    13.638     0.200
     4.648    18.196     0.200
     5.009    21.909     0.200
     5.025    15.916     0.200
     5.042    16.775     0.200
     5.187    13.325     0.200
     5.331    18.771     0.200
     5.331    17.654     0.200
     5.342    20.704     0.200
     5.479    16.609     0.200
     5.574    20.332     0.200
     5.574    18.364     0.200
     5.669    17.113     0.200
     5.829    20.776     0.200
     5.967    20.511     0.200
     5.967    20.136     0.200
     6.103    19.495     0.200
     6.169    22.835     0.200
     6.254    21.996     0.200
     6.340    20.514     0.200
     6.340    18.897     0.200
     6.417    23.288     0.200
     6.595    22.197     0.200
     6.650    23.187     0.200
     6.717    22.444     0.200
     6.717    22.077     0.200
     6.783    22.302     0.200
     6.818    22.037     0.200
     6.904    19.750     0.200
     6.984    22.710     0.200
     7.120    24.773     0.200
     7.149    24.758     0.200
     7.119    22.368     0.200
     7.125    21.144     0.200
     7.341    21.660     0.200
     7.369    24.051     0.200
     7.633     9.033     0.200
     7.633    26.018     0.200
     7.753    27.280     0.200
     7.891    25.415     0.200
     7.973    25.259     0.200
     7.999    21.510     0.200
     8.022    22.824     0.200
     8.074    24.359     0.200
     8.201    23.964     0.200
     8.199    24.338     0.200
     8.213    23.557     0.200
     8.249    25.382     0.200
     8.228    23.489     0.200
     8.228    27.575     0.200
     8.575    27.886     0.200
     8.561    22.670     0.200
     8.669    32.275     0.200
     8.669    22.626     0.200
     8.754    22.784     0.200
     8.804    25.106     0.200
     8.871    24.272     0.200
     8.921    28.449     0.200
     8.919    25.038     0.200
     8.941    29.460     0.200
     8.955    24.197     0.200
     8.963    27.248     0.200
     8.969    25.539     0.200
     8.970    25.552     0.200
     8.971    26.422     0.200
     8.974    30.266     0.200
     9.014    27.691     0.200
     9.038    28.066     0.200
     9.047    26.099     0.200
     9.157    23.862     0.200
     9.148    28.676     0.200
     9.177    29.807     0.200
     9.158    27.174     0.200
     9.156    27.687     0.200
     9.167    28.720     0.200
     9.180    28.104     0.200
     9.207    28.212     0.200
     9.175    26.620     0.200
     9.175    26.626     0.200
     9.176    29.665     0.200
     9.176    26.751     0.200
     9.434    26.695     0.200
     9.489    24.558     0.200
     9.483    24.698     0.200
     9.483    23.675     0.200
     9.641    26.177     0.200
     9.713    25.013     0.200
     9.791    30.331     0.200
     9.791    30.651     0.200
     9.899    30.467     0.200
    10.165    28.326     0.200
    10.181    31.619     0.200
    10.222    25.703     0.200
    10.222    30.328     0.200
    10.316    29.668     0.200
    10.267    30.032     0.200
    10.373    32.194     0.200
    10.412    26.983     0.200
    10.499    29.819     0.200
    10.502    25.803     0.200
    10.502    32.850     0.200
    10.882    28.163     0.200
    10.930    29.292     0.200
    10.958    26.464     0.200
    11.335    29.742     0.200
    11.408    31.309     0.200
    11.658    29.501     0.200
    12.017    29.659     0.200
    12.195    27.548     0.200
    12.479    34.059     0.200
    12.389    35.536     0.200
    12.494    35.039     0.200
    12.539    35.301     0.200
    12.544    34.756     0.200
    12.575    33.379     0.200
    12.758    30.757     0.200
    12.839    31.188     0.200
    12.839    31.218     0.200
    12.839    40.484     0.200
    12.839    36.414     0.200
    12.920    33.713     0.200
    12.985    31.325     0.200
    12.990    33.072     0.200
    12.876    39.396     0.200
    13.015    36.068     0.200
    13.096    38.108     0.200
    13.096    35.147     0.200
    13.050    35.556     0.200
    13.161    33.816     0.200
    13.207    37.144     0.200
    13.274    32.222     0.200
    13.391    32.585     0.200
    13.404    30.197     0.200
    13.450    35.514     0.200
    13.572    32.415     0.200
    13.670    34.589     0.200
    13.653    34.648     0.200
    14.003    40.795     0.200
    14.422    40.801     0.200
    14.516    39.134     0.200
    14.522    40.397     0.200
    14.532    40.615     0.200
    14.650    37.930     0.200
    14.850    39.695     0.200
    14.785    39.020     0.200
    14.817    36.443     0.200
    14.902    40.784     0.200
    14.976    41.304     0.200
    15.015    41.029     0.200
    15.010    39.677     0.200
    15.056    37.975     0.200
    15.150    35.347     0.200
    15.807    40.474     0.200
    15.833    39.950     0.200
    15.857    40.001     0.200
    16.071    39.580     0.200
    16.037    40.469     0.200
    16.362    41.180     0.200
    16.362    39.547     0.200
    16.385    38.330     0.200
    16.310    39.640     0.200
    16.376    41.015     0.200
    16.464    40.102     0.200
    16.469    38.739     0.200
    16.533    38.688     0.200
    16.688    38.600     0.200
    16.755    38.976     0.200
    16.755    37.694     0.200
    16.788    41.060     0.200
    16.937    39.047     0.200
    16.993    40.249     0.200
    17.115    39.748     0.200
    17.279    39.717     0.200
    17.363    40.618     0.200
    17.316    39.868     0.200
    17.350    40.631     0.200
    17.350    38.959     0.200
    17.527    40.862     0.200
    17.543    38.262     0.200
    17.619    38.070     0.200
    17.781    38.364     0.200
    17.764    40.847     0.200
    17.879    41.258     0.200
    17.835    28.478     0.200
    17.835    40.134     0.200
    18.255    39.173     0.200
    18.324    39.607     0.200
    18.350    37.949     0.200
    19.232    44.850     0.200
     0.956     6.390     0.200
     0.956     6.101     0.200
     1.216     6.644     0.200
     1.238     6.374     0.200
     1.231     8.431     0.200
     1.305     7.949     0.200
     1.352     8.137     0.200
     1.352     8.333     0.200
     1.484     8.606     0.200
     1.620     8.890     0.200
     1.628     7.318     0.200
     1.626     8.212     0.200
     1.820     9.131     0.200
     1.905     9.589     0.200
     1.953     9.397     0.200
     1.982     9.215     0.200
     2.051     9.756     0.200
     2.081    10.061     0.200
     2.280    11.066     0.200
     2.471    11.055     0.200
     2.485    11.066     0.200
     2.560    12.029     0.200
     3.200    12.672     0.200
     3.238    13.044     0.200
     3.238    12.103     0.200
     3.414    14.425     0.200
     3.683    12.544     0.200
     3.739    15.057     0.200
     4.102    14.424     0.200
     4.102    13.354     0.200
     4.496    15.824     0.200
     4.614    17.816     0.200
     4.614    18.082     0.200
     4.757    17.158     0.200
     4.803    17.732     0.200
     5.051    19.245     0.200
     5.251    19.060     0.200
     5.251    18.779     0.200
     5.386    19.634     0.200
     5.470    20.440     0.200
     5.690    20.795     0.200
     5.781    19.231     0.200
     5.781    18.899     0.200
     6.596    22.588     0.200
     6.670    22.594     0.200
     6.806    18.773     0.200
     7.073    21.081     0.200
     7.403    23.979     0.200
     7.403    23.862     0.200
     7.797    23.304     0.200
     9.025    30.497     0.200
     9.667    28.144     0.200
     9.667    28.154     0.200
     9.668    27.517     0.200
     9.668    27.873     0.200
     2.014    10.188     0.200
     2.182     9.201     0.200
     2.182     8.963     0.200
     2.364    10.566     0.200
     2.612    10.498     0.200
     2.617    12.586     0.200
     2.618    12.048     0.200
     2.618    12.298     0.200
     2.807    12.067     0.200
     2.808    12.032     0.200
     2.837    12.910     0.200
     2.885    11.663     0.200
     2.885    12.703     0.200
     2.885    10.935     0.200
     2.891    12.699     0.200
     2.891    10.383     0.200
     2.918    11.766     0.200
     3.023    10.237     0.200
     3.012    10.303     0.200
     3.075    12.222     0.200
     3.195    12.329     0.200
     3.195    12.549     0.200
     3.237    11.795     0.200
     3.392    12.844     0.200
     3.553    14.645     0.200
     3.592    13.853     0.200
     3.592    12.578     0.200
     3.689    11.809     0.200
     3.689    13.039     0.200
     3.689    12.203     0.200
     3.866    14.115     0.200
     3.866    13.875     0.200
     3.866    12.303     0.200
     3.898    14.353     0.200
     3.783    11.543     0.200
     4.057    13.011     0.200
     4.188    13.942     0.200
     4.123    11.459     0.200
     4.344    15.055     0.200
     4.491    14.795     0.200
     4.570    15.051     0.200
     4.556    14.290     0.200
     4.735    14.687     0.200
     4.867    17.124     0.200
     4.907    17.438     0.200
     4.930    16.127     0.200
     5.290    16.621     0.200
     5.510    19.150     0.200
     5.510    16.054     0.200
     5.486    16.558     0.200
     5.688    18.391     0.200
     5.774    17.275     0.200
     5.848    20.170     0.200
     5.859    19.101     0.200
     5.859    18.463     0.200
     5.925    16.979     0.200
     6.054    19.111     0.200
     6.054    17.871     0.200
     6.054    18.732     0.200
     6.221    17.980     0.200
     6.249    20.054     0.200
     6.249    19.465     0.200
     6.295    21.436     0.200
     6.337    21.297     0.200
     6.397    21.467     0.200
     6.427    18.929     0.200
     6.447    21.756     0.200
     6.479    22.088     0.200
     6.479    19.241     0.200
     6.861    22.287     0.200
     6.921    23.085     0.200
     6.930    22.576     0.200
     6.930    20.597     0.200
     6.982    19.969     0.200
     7.037    21.162     0.200
     7.223    23.118     0.200
     7.247    24.219     0.200
     7.383    23.696     0.200
     7.369    21.675     0.200
     7.369    22.014     0.200
     7.424    23.803     0.200
     7.455    23.892     0.200
     7.440    22.916     0.200
     7.528    24.200     0.200
     7.550    25.267     0.200
     7.582    21.519     0.200
     7.619    21.768     0.200
     7.647    22.620     0.200
     7.820    21.893     0.200
     7.820    23.853     0.200
     7.820    22.052     0.200
     8.027    25.700     0.200
     8.099    24.405     0.200
     8.151    22.537     0.200
     8.151    22.952     0.200
     8.151    23.244     0.200
     8.205    25.957     0.200
     8.205    23.919     0.200
     8.331    26.857     0.200
     8.362    25.959     0.200
     8.269    23.377     0.200
     8.487    27.610     0.200
     8.493    25.840     0.200
     8.512    25.217     0.200
     8.512    24.245     0.200
     8.538    27.747     0.200
     8.853    27.285     0.200
     8.854    26.863     0.200
     8.939    28.947     0.200
     9.082    28.086     0.200
     9.104    28.657     0.200
     9.157    28.147     0.200
     9.256    26.146     0.200
     9.255    27.518     0.200
     9.299    28.528     0.200
     9.333    27.833     0.200
     9.295    24.942     0.200
     9.295    25.491     0.200
     9.296    24.700     0.200
     9.296    24.903     0.200
     9.429    28.600     0.200
     9.436    27.873     0.200
     9.453    28.930     0.200
     9.466    27.932     0.200
     9.714    27.828     0.200
     9.765    28.259     0.200
     9.765    26.665     0.200
     9.883    29.163     0.200
     9.912    27.712     0.200
     9.973    28.265     0.200
     9.988    28.894     0.200
    10.056    28.510     0.200
    10.056    27.221     0.200
    10.084    30.397     0.200
    10.223    31.120     0.200
    10.361    31.385     0.200
    10.488    30.951     0.200
    10.499    29.619     0.200
    10.499    27.513     0.200
    10.491    29.116     0.200
    10.491    28.741     0.200
    10.557    28.267     0.200
    10.557    30.477     0.200
    10.647    31.092     0.200
    10.684    30.784     0.200
    10.762    32.259     0.200
    10.771    30.325     0.200
    10.771    29.692     0.200
    10.807    31.172     0.200
    10.846    32.370     0.200
    11.054    31.303     0.200
    11.092    31.281     0.200
    11.554    31.438     0.200
    11.554    29.743     0.200
    11.607    32.227     0.200
    11.642    31.616     0.200
    11.786    33.909     0.200
    11.943    32.417     0.200
    11.943    31.937     0.200
    12.605    35.132     0.200
    12.543    33.347     0.200
    12.543    32.463     0.200
    12.645    35.467     0.200
    12.662    35.167     0.200
    12.702    36.108     0.200
    12.733    35.259     0.200
    12.811    33.788     0.200
    12.768    33.820     0.200
    12.768    33.451     0.200
    12.830    33.977     0.200
    12.958    35.392     0.200
    12.853    34.814     0.200
    13.052    35.588     0.200
    13.033    35.557     0.200
    13.064    36.846     0.200
    13.117    35.107     0.200
    13.117    32.100     0.200
    13.118    35.486     0.200
    13.118    35.756     0.200
    13.118    35.946     0.200
    13.120    36.302     0.200
    13.141    36.476     0.200
    13.141    34.756     0.200
    13.206    36.536     0.200
    13.162    35.384     0.200
    13.162    34.087     0.200
    13.254    37.477     0.200
    13.346    35.956     0.200
    13.346    32.319     0.200
    13.363    36.727     0.200
    13.363    35.799     0.200
    13.434    36.466     0.200
    13.479    35.330     0.200
    13.542    36.829     0.200
    13.547    37.521     0.200
    13.554    36.391     0.200
    13.576    36.128     0.200
    13.615    38.168     0.200
    13.615    32.385     0.200
    13.827    37.682     0.200
    13.917    37.021     0.200
    13.917    37.311     0.200
    13.875    36.161     0.200
    13.875    35.596     0.200
    14.160    37.997     0.200
    14.188    35.780     0.200
    14.435    38.602     0.200
    14.464    39.444     0.200
    14.484    38.653     0.200
    14.442    37.539     0.200
    14.437    38.846     0.200
    14.558    38.806     0.200
    14.562    40.156     0.200
    14.602    37.405     0.200
    14.657    39.932     0.200
    14.648    37.798     0.200
    14.648    38.485     0.200
    14.693    38.444     0.200
    14.781    39.386     0.200
    14.790    37.153     0.200
    14.767    38.169     0.200
    14.767    36.299     0.200
    14.804    37.673     0.200
    14.825    39.164     0.200
    14.826    38.925     0.200
    14.842    39.346     0.200
    15.027    38.322     0.200
    15.178    37.199     0.200
    15.277    38.276     0.200
    15.274    39.294     0.200
    15.426    41.031     0.200
    15.426    41.364     0.200
    15.509    40.592     0.200
    15.524    40.652     0.200
    15.674    38.905     0.200
    15.920    39.477     0.200
    15.959    37.550     0.200
    16.007    39.237     0.200
    16.119    40.466     0.200
    16.119    39.618     0.200
    16.168    41.040     0.200
    16.276    39.863     0.200
    16.568    37.061     0.200
    16.538    40.579     0.200
    16.538    39.935     0.200
    16.608    41.306     0.200
    16.615    38.575     0.200
    16.615    39.434     0.200
    16.635    38.792     0.200
    16.635    39.338     0.200
    16.589    40.323     0.200
    16.679    41.356     0.200
    16.730    40.411     0.200
    16.932    42.503     0.200
    16.932    38.676     0.200
    17.045    40.629     0.200
    17.045    40.343     0.200
    17.215    41.640     0.200
    17.210    41.502     0.200
    17.210    39.965     0.200
    17.277    40.553     0.200
    17.556    41.592     0.200
    17.595    41.928     0.200
    17.632    41.078     0.200
    17.847    40.675     0.200
    18.083    40.579     0.200
    18.177    41.491     0.200
    18.222    41.174     0.200
    18.328    40.531     0.200
    18.706    42.270     0.200
    18.846    42.171     0.200
    18.934    42.929     0.200
    19.107    42.431     0.200
    19.510    42.071     0.200
    19.510    42.326     0.200
    19.829    41.998     0.200
     2.053     9.649     0.200
     2.344    10.453     0.200
     2.369     9.547     0.200
     2.610    10.810     0.200
     2.611    10.978     0.200
     2.628    12.993     0.200
     2.637    12.496     0.200
     2.637    10.926     0.200
     2.821    11.778     0.200
     2.821    11.224     0.200
     2.851    12.296     0.200
     2.891    11.607     0.200
     2.891    10.857     0.200
     2.905    10.476     0.200
     2.936    11.273     0.200
     2.936    11.403     0.200
     2.936    11.633     0.200
     3.035    10.363     0.200
     3.029    11.785     0.200
     3.092    11.222     0.200
     3.134    10.492     0.200
     3.134     8.702     0.200
     3.212    12.291     0.200
     3.252    11.812     0.200
     3.377    13.053     0.200
     3.377    16.073     0.200
     3.557    13.285     0.200
     3.595    12.359     0.200
     3.609    13.037     0.200
     3.609    12.482     0.200
     3.672    13.786     0.200
     3.672    11.724     0.200
     3.895    13.784     0.200
     3.873    12.534     0.200
     3.880    13.497     0.200
     3.880    14.487     0.200
     3.880    13.003     0.200
     4.023    13.243     0.200
     4.068    14.030     0.200
     4.204    14.518     0.200
     4.360    15.753     0.200
     4.470    16.411     0.200
     4.574    15.150     0.200
     4.576    15.245     0.200
     4.633    14.470     0.200
     4.727    15.490     0.200
     4.753    16.326     0.200
     4.858    16.444     0.200
     4.908    17.761     0.200
     4.939    17.666     0.200
     4.945    17.973     0.200
     5.165    17.733     0.200
     5.307    18.707     0.200
     5.410    18.298     0.200
     5.403    18.476     0.200
     5.463    15.842     0.200
     5.522    19.586     0.200
     5.522    17.789     0.200
     5.628    18.913     0.200
     5.675    17.814     0.200
     5.790    19.140     0.200
     5.852    19.138     0.200
     5.852    18.864     0.200
     5.862    20.518     0.200
     5.934    19.541     0.200
     6.034    19.290     0.200
     6.034    18.460     0.200
     6.034    17.841     0.200
     6.237    19.827     0.200
     6.237    19.374     0.200
     6.237    19.565     0.200
     6.190    18.042     0.200
     6.305    21.799     0.200
     6.342    22.302     0.200
     6.443    21.169     0.200
     6.439    20.193     0.200
     6.414    20.791     0.200
     6.493    22.105     0.200
     6.493    20.347     0.200
     6.621    21.047     0.200
     6.516    23.958     0.200
     6.861    22.015     0.200
     6.919    22.926     0.200
     6.938    23.270     0.200
     6.938    21.052     0.200
     6.926    21.908     0.200
     6.994    22.776     0.200
     7.023    21.640     0.200
     7.258    25.064     0.200
     7.258    23.650     0.200
     7.352    21.959     0.200
     7.360    18.066     0.200
     7.383    24.428     0.200
     7.421    24.476     0.200
     7.455    24.062     0.200
     7.457    23.791     0.200
     7.535    24.523     0.200
     7.561    24.738     0.200
     7.601    21.863     0.200
     7.798    26.045     0.200
     7.798    22.189     0.200
     8.025    26.011     0.200
     8.135    22.418     0.200
     8.135    23.303     0.200
     8.116    24.441     0.200
     8.210    25.068     0.200
     8.210    23.601     0.200
     8.233    25.814     0.200
     8.332    25.483     0.200
     8.246    24.646     0.200
     8.246    20.786     0.200
     8.375    26.975     0.200
     8.485    26.108     0.200
     8.502    26.184     0.200
     8.502    24.845     0.200
     8.537    26.908     0.200
     8.510    26.629     0.200
     8.765    27.482     0.200
     8.864    27.196     0.200
     8.864    28.368     0.200
     8.871    27.229     0.200
     8.948    26.574     0.200
     9.079    28.605     0.200
     9.115    28.735     0.200
     9.148    28.993     0.200
     9.248    27.015     0.200
     9.325    28.772     0.200
     9.272    25.510     0.200
     9.272    25.268     0.200
     9.273    24.937     0.200
     9.273    25.231     0.200
     9.313    27.936     0.200
     9.380    28.412     0.200
     9.424    27.651     0.200
     9.432    28.347     0.200
     9.444    28.760     0.200
     9.457    28.478     0.200
     9.675    29.331     0.200
     9.710    29.751     0.200
     9.753    29.894     0.200
     9.753    27.115     0.200
     9.911    29.284     0.200
     9.895    29.507     0.200
     9.984    28.235     0.200
     9.986    28.019     0.200
    10.056    30.396     0.200
    10.056    28.364     0.200
    10.073    29.875     0.200
    10.096    30.052     0.200
    10.236    30.199     0.200
    10.372    30.519     0.200
    10.486    31.252     0.200
    10.486    29.779     0.200
    10.471    30.756     0.200
    10.471    29.114     0.200
    10.496    31.248     0.200
    10.561    28.903     0.200
    10.561    30.823     0.200
    10.644    31.753     0.200
    10.682    31.538     0.200
    10.756    31.808     0.200
    10.756    29.517     0.200
    10.762    31.198     0.200
    10.797    31.705     0.200
    10.858    31.030     0.200
    11.049    31.638     0.200
    11.085    31.902     0.200
    11.085    29.982     0.200
    11.057    31.598     0.200
    11.092    31.984     0.200
    11.542    31.939     0.200
    11.605    32.700     0.200
    11.622    34.419     0.200
    11.622    31.797     0.200
    11.799    34.335     0.200
    11.799    33.644     0.200
    11.932    34.110     0.200
    11.932    32.163     0.200
    12.142    32.670     0.200
    12.154    30.621     0.200
    12.520    32.510     0.200
    12.520    32.251     0.200
    12.652    34.642     0.200
    12.652    34.019     0.200
    12.621    33.577     0.200
    12.656    35.177     0.200
    12.710    35.414     0.200
    12.746    34.109     0.200
    12.747    35.262     0.200
    12.810    35.523     0.200
    12.822    34.537     0.200
    12.832    34.735     0.200
    12.974    33.095     0.200
    13.018    35.429     0.200
    13.018    35.783     0.200
    13.051    36.977     0.200
    13.077    35.196     0.200
    13.077    36.704     0.200
    13.114    35.745     0.200
    13.114    34.967     0.200
    13.114    35.984     0.200
    13.114    35.404     0.200
    13.114    35.194     0.200
    13.135    36.333     0.200
    13.154    36.341     0.200
    13.154    36.010     0.200
    13.196    35.762     0.200
    13.139    34.694     0.200
    13.258    36.048     0.200
    13.349    36.979     0.200
    13.349    36.001     0.200
    13.377    38.247     0.200
    13.377    37.199     0.200
    13.432    36.892     0.200
    13.494    36.761     0.200
    13.541    36.563     0.200
    13.545    36.998     0.200
    13.562    36.554     0.200
    13.587    37.457     0.200
    13.628    36.997     0.200
    13.628    38.027     0.200
    13.781    37.286     0.200
    13.826    37.558     0.200
    13.855    36.433     0.200
    13.910    36.150     0.200
    14.103    38.656     0.200
    14.103    38.976     0.200
    14.159    39.182     0.200
    14.199    38.304     0.200
    14.419    36.874     0.200
    14.447    38.581     0.200
    14.483    39.209     0.200
    14.483    37.064     0.200
    14.473    39.798     0.200
    14.497    38.158     0.200
    14.538    38.136     0.200
    14.538    36.908     0.200
    14.572    38.502     0.200
    14.581    38.781     0.200
    14.635    37.463     0.200
    14.658    40.136     0.200
    14.677    39.431     0.200
    14.691    39.053     0.200
    14.751    39.074     0.200
    14.751    38.333     0.200
    14.779    39.959     0.200
    14.790    40.075     0.200
    14.757    39.117     0.200
    14.825    39.955     0.200
    14.841    39.632     0.200
    14.831    40.159     0.200
    14.829    38.452     0.200
    14.935    39.267     0.200
    15.038    39.976     0.200
    15.066    38.527     0.200
    15.066    40.658     0.200
    15.083    39.461     0.200
    15.084    40.697     0.200
    15.257    40.488     0.200
    15.424    40.030     0.200
    15.424    40.319     0.200
    15.524    40.743     0.200
    15.517    40.609     0.200
    15.674    41.011     0.200
    15.757    40.351     0.200
    15.792    41.241     0.200
    15.818    41.651     0.200
    16.111    40.949     0.200
    16.257    40.240     0.200
    16.290    40.011     0.200
    16.518    40.127     0.200
    16.645    40.953     0.200
    16.696    40.215     0.200
    16.708    41.270     0.200
    16.909    40.334     0.200
    16.956    41.322     0.200
    17.028    41.135     0.200
    17.028    40.899     0.200
    17.196    40.617     0.200
    17.196    40.947     0.200
    17.222    41.294     0.200
    17.960    40.956     0.200
    18.063    40.677     0.200
    18.199    41.725     0.200
    18.306    41.107     0.200
    18.504    42.183     0.200
    18.553    41.564     0.200
    18.531    42.323     0.200
    18.607    42.438     0.200
    18.604    43.940     0.200
    18.623    41.918     0.200
    18.694    41.980     0.200
    18.704    42.865     0.200
    18.849    42.769     0.200
    18.915    41.917     0.200
    18.934    42.112     0.200
    18.934    42.461     0.200
    19.115    42.277     0.200
    19.197    42.579     0.200
    19.417    41.474     0.200
    19.417    42.761     0.200
    19.438    42.298     0.200
    19.478    42.530     0.200
    19.497    41.862     0.200
    19.577    42.744     0.200
    19.682    42.522     0.200
    19.824    42.148     0.200
    19.824    41.304     0.200
    20.098    42.100     0.200
    20.267    42.142     0.200
    20.429    41.431     0.200
    20.595    41.505     0.200
    20.595    41.202     0.200
    20.607    40.944     0.200
    20.607    41.200     0.200
    21.025    40.616     0.200
     1.157     4.900     0.200
     1.188     6.513     0.200
     1.188     6.212     0.200
     1.622     6.853     0.200
     1.622     6.963     0.200
     1.716     6.547     0.200
     1.716     6.828     0.200
     1.818     7.614     0.200
     1.818     7.313     0.200
     1.818     7.728     0.200
     1.818     7.833     0.200
     1.917     9.064     0.200
     1.996     8.531     0.200
     2.218     8.666     0.200
     2.310     9.583     0.200
     2.475     9.795     0.200
     2.527     9.306     0.200
     2.527     9.689     0.200
     2.538    10.785     0.200
     2.537    11.311     0.200
     2.582     9.041     0.200
     2.635    10.946     0.200
     2.729    10.463     0.200
     2.729    10.674     0.200
     2.729    10.857     0.200
     2.813    10.773     0.200
     2.861    10.592     0.200
     2.977    10.255     0.200
     2.977    12.056     0.200
     2.989    11.303     0.200
     3.110    11.499     0.200
     3.179    11.445     0.200
     3.251    12.441     0.200
     3.221    11.705     0.200
     3.221    13.533     0.200
     3.391    11.424     0.200
     3.391    11.045     0.200
     3.391    12.029     0.200
     3.503    12.361     0.200
     3.578    11.983     0.200
     3.579    12.475     0.200
     3.585    14.698     0.200
     3.585    13.698     0.200
     3.585    12.311     0.200
     3.661    12.319     0.200
     3.741    13.561     0.200
     3.668    16.060     0.200
     4.111    13.647     0.200
     4.297    13.929     0.200
     4.484    14.738     0.200
     4.519    15.726     0.200
     4.924    16.019     0.200
     5.068    17.083     0.200
     5.199    16.728     0.200
     5.330    16.952     0.200
     5.469    17.776     0.200
     5.582    17.575     0.200
     5.811    17.828     0.200
     5.811    18.535     0.200
     5.884    18.226     0.200
     5.966    17.376     0.200
     5.970    20.401     0.200
     6.051    20.125     0.200
     6.184    18.328     0.200
     6.214    17.346     0.200
     6.469    20.689     0.200
     6.583    20.042     0.200
     6.688    22.101     0.200
     6.852    20.992     0.200
     6.926    19.469     0.200
     6.993    22.433     0.200
     7.028    22.358     0.200
     7.063    22.290     0.200
     7.168    19.407     0.200
     7.223    19.392     0.200
     7.232    20.534     0.200
     7.632    23.774     0.200
     7.639    21.846     0.200
     7.639    22.225     0.200
     7.839    22.482     0.200
     7.839    22.103     0.200
     7.840    23.265     0.200
     7.840    20.390     0.200
     7.840    23.917     0.200
     7.888    20.630     0.200
     7.920    22.622     0.200
     7.945    23.001     0.200
     8.077    27.436     0.200
     8.092    25.399     0.200
     8.144    24.196     0.200
     8.137    24.468     0.200
     8.137    23.558     0.200
     8.405    22.470     0.200
     8.442    23.684     0.200
     8.536    27.536     0.200
     8.536    23.856     0.200
     8.687    25.755     0.200
     8.788    23.510     0.200
     8.772    24.945     0.200
     8.869    25.505     0.200
     8.870    24.301     0.200
     8.945    26.884     0.200
     9.029    23.544     0.200
     9.043    23.596     0.200
     9.034    26.862     0.200
     9.040    27.472     0.200
     9.054    25.178     0.200
     9.081    26.555     0.200
     9.106    25.297     0.200
     9.126    25.651     0.200
     9.218    26.992     0.200
     9.218    26.581     0.200
     9.219    26.733     0.200
     9.318    26.226     0.200
     9.357    24.456     0.200
     9.401    27.002     0.200
     9.401    27.361     0.200
     9.518    26.022     0.200
     9.582    25.295     0.200
     9.593    26.823     0.200
     9.649    26.902     0.200
     9.665    26.916     0.200
     9.665    27.357     0.200
     9.683    23.501     0.200
     9.927    25.135     0.200
    10.049    29.317     0.200
    10.138    27.406     0.200
    10.148    28.445     0.200
    10.148    29.574     0.200
    10.183    28.203     0.200
    10.183    27.499     0.200
    10.251    27.283     0.200
    10.246    28.293     0.200
    10.246    30.129     0.200
    10.290    27.877     0.200
    10.372    26.147     0.200
    10.429    28.143     0.200
    10.439    31.915     0.200
    10.439    30.543     0.200
    10.660    29.840     0.200
    10.703    29.788     0.200
    10.703    29.678     0.200
    10.760    30.106     0.200
    11.212    30.991     0.200
    11.241    29.929     0.200
    11.381    30.285     0.200
    11.381    30.843     0.200
    11.570    30.619     0.200
    11.570    31.080     0.200
    12.280    33.688     0.200
    12.327    35.154     0.200
    12.360    32.500     0.200
    12.417    33.411     0.200
    12.440    32.288     0.200
    12.413    32.985     0.200
    12.576    32.398     0.200
    12.576    34.179     0.200
    12.689    31.554     0.200
    12.722    36.815     0.200
    12.722    34.252     0.200
    12.722    35.146     0.200
    12.722    35.673     0.200
    12.722    34.575     0.200
    12.825    33.971     0.200
    12.882    36.793     0.200
    12.965    34.185     0.200
    12.965    33.857     0.200
    13.039    34.381     0.200
    12.976    34.412     0.200
    13.148    34.561     0.200
    13.095    33.612     0.200
    13.152    31.569     0.200
    13.206    33.960     0.200
    13.258    34.906     0.200
    13.281    34.982     0.200
    13.319    33.352     0.200
    13.324    34.681     0.200
    13.433    35.017     0.200
    13.527    34.874     0.200
    13.527    35.445     0.200
    13.547    34.471     0.200
    13.513    35.792     0.200
    13.634    34.804     0.200
    13.634    35.488     0.200
    13.870    37.613     0.200
    13.933    37.119     0.200
    13.944    34.170     0.200
    14.127    35.964     0.200
    14.238    33.905     0.200
    14.268    35.385     0.200
    14.289    36.220     0.200
    14.301    35.368     0.200
    14.386    36.380     0.200
    14.388    36.277     0.200
    14.462    35.862     0.200
    14.446    35.351     0.200
    14.558    35.487     0.200
    14.718    36.913     0.200
    14.681    36.538     0.200
    14.792    36.630     0.200
    14.880    36.122     0.200
    14.920    37.656     0.200
    14.940    37.485     0.200
    14.965    37.449     0.200
    14.986    37.620     0.200
    15.031    36.798     0.200
    15.031    37.305     0.200
    15.010    37.457     0.200
    15.132    37.309     0.200
    15.099    37.272     0.200
    15.102    37.412     0.200
    15.428    36.001     0.200
    15.474    38.336     0.200
    15.599    37.976     0.200
    15.588    37.569     0.200
    15.673    39.071     0.200
    15.635    37.969     0.200
    15.733    38.503     0.200
    15.733    39.253     0.200
    15.713    38.765     0.200
    16.003    37.467     0.200
    16.208    37.879     0.200
    16.217    37.717     0.200
    16.232    38.182     0.200
    16.232    39.537     0.200
    16.330    38.192     0.200
    16.286    37.162     0.200
    16.286    40.330     0.200
    16.532    38.851     0.200
    16.739    39.379     0.200
    16.766    38.970     0.200
    16.952    39.270     0.200
    17.149    36.982     0.200
    17.237    40.241     0.200
    17.239    40.203     0.200
    17.485    39.003     0.200
    17.526    37.945     0.200
    17.517    37.485     0.200
    17.647    36.517     0.200
    17.831    38.492     0.200
    18.196    37.739     0.200
    18.463    41.416     0.200
    19.104    41.027     0.200
    19.156    40.896     0.200
    19.156    41.814     0.200
    19.336    40.796     0.200
    19.435    41.038     0.200
    19.435    41.511     0.200
    19.629    40.703     0.200
    20.275    40.824     0.200
    20.299    40.258     0.200
    20.299    41.562     0.200
    20.565    40.486     0.200
     1.023     5.554     0.200
     1.065     7.361     0.200
     1.239     7.972     0.200
     1.228     8.788     0.200
     1.352     8.321     0.200
     1.355     8.046     0.200
     1.379     7.948     0.200
     1.379     7.800     0.200
     1.460     8.501     0.200
     1.513     8.347     0.200
     1.564     8.380     0.200
     1.608     8.893     0.200
     1.601     8.601     0.200
     1.765     7.474     0.200
     1.841     9.584     0.200
     1.890     8.177     0.200
     1.955     8.123     0.200
     2.000     7.858     0.200
     2.136     9.656     0.200
     2.192     9.212     0.200
     2.201     9.785     0.200
     2.249    10.267     0.200
     2.303     9.729     0.200
     2.346    10.649     0.200
     2.460    10.981     0.200
     2.679    12.071     0.200
     2.723    11.297     0.200
     2.735    11.513     0.200
     2.858    12.576     0.200
     2.970    12.479     0.200
     3.129    12.954     0.200
     3.129    11.966     0.200
     3.373    12.668     0.200
     3.609    14.805     0.200
     3.718    13.814     0.200
     4.237    13.839     0.200
     4.325    14.046     0.200
     4.316    14.378     0.200
     4.710    15.211     0.200
     4.766    16.880     0.200
     5.039    15.761     0.200
     5.661    16.947     0.200
     5.660    18.157     0.200
     5.921    19.003     0.200
     6.168    18.430     0.200
     6.517    20.947     0.200
     9.464    25.452     0.200
     9.464    25.181     0.200
     0.943     6.055     0.200
     0.952     5.977     0.200
     1.201     7.645     0.200
     1.281     8.077     0.200
     1.318     8.512     0.200
     1.403     8.153     0.200
     1.441     8.739     0.200
     1.494     8.661     0.200
     1.534     9.142     0.200
     1.606     8.856     0.200
     1.694     9.087     0.200
     1.770     8.321     0.200
     2.073     9.180     0.200
     2.068    11.508     0.200
     2.189    11.129     0.200
     2.235     9.591     0.200
     2.655    11.539     0.200
     2.645    12.178     0.200
     2.690    10.934     0.200
     3.157    12.759     0.200
     3.302    12.508     0.200
     3.557    14.766     0.200
     4.175    16.269     0.200
     4.371    15.855     0.200
     4.684    16.444     0.200
     4.763    16.985     0.200
     4.989    16.579     0.200
     5.271    18.278     0.200
     5.593    17.576     0.200
     5.598    17.698     0.200
     5.693    18.542     0.200
     5.859    19.221     0.200
     6.117    19.584     0.200
     7.025    21.489     0.200
     1.298     5.959     0.200
     1.362     6.793     0.200
     1.395     5.509     0.200
     1.469     6.637     0.200
     1.564     6.964     0.200
     1.727     7.064     0.200
     2.141     9.017     0.200
     2.151     8.336     0.200
     2.189     8.766     0.200
     2.189     8.566     0.200
     2.214     8.947     0.200
     3.058    12.518     0.200
     5.875    17.945     0.200
     0.952     5.672     0.200
     0.994     6.570     0.200
     1.145     6.724     0.200
     1.389     7.499     0.200
     1.669     7.392     0.200
     2.068     9.551     0.200
     2.068     9.407     0.200
     2.110    10.201     0.200
     2.218     9.241     0.200
     2.149     8.948     0.200
     2.309     9.031     0.200
     3.751    13.656     0.200
     3.766    12.968     0.200
     5.892    18.805     0.200
     0.314     2.481     0.200
     1.327     5.416     0.200
     1.395     6.229     0.200
     1.474     6.561     0.200
     1.316     6.544     0.200
     1.316     6.692     0.200
     1.514     5.249     0.200
     1.369     5.637     0.200
     1.593     6.493     0.200
     1.593     6.379     0.200
     1.829     7.488     0.200
     1.717     6.670     0.200
     1.717     6.940     0.200
     2.213     7.816     0.200
     2.213     8.164     0.200
     2.377     8.279     0.200
     2.421     9.799     0.200
     2.463     8.428     0.200
     2.332     8.297     0.200
     2.706     8.682     0.200
     2.676     8.802     0.200
     2.927     8.365     0.200
     2.966     9.786     0.200
     2.981     9.477     0.200
     3.008    10.185     0.200
     3.008    10.036     0.200
     3.112     9.497     0.200
     3.165    10.746     0.200
     3.081    10.988     0.200
     3.081    10.597     0.200
     3.286    11.390     0.200
     3.328    10.506     0.200
     3.380    11.924     0.200
     3.301     9.778     0.200
     3.629    12.161     0.200
     3.682    12.478     0.200
     3.682    10.747     0.200
     3.690    11.892     0.200
     3.690    12.150     0.200
     3.690    11.572     0.200
     3.690    12.400     0.200
     3.956    11.550     0.200
     3.956    12.432     0.200
     3.956    16.296     0.200
     3.956    11.884     0.200
     3.955    12.533     0.200
     4.098    13.052     0.200
     4.279    11.251     0.200
     4.186    13.483     0.200
     4.462    14.280     0.200
     4.803    15.073     0.200
     4.906    15.848     0.200
     4.977    16.262     0.200
     5.043    15.959     0.200
     5.616    16.925     0.200
     5.712    17.679     0.200
     5.905    18.703     0.200
     5.905    19.141     0.200
     6.091    18.486     0.200
     6.037    18.338     0.200
     6.037    17.889     0.200
     6.276    19.921     0.200
     6.416    19.725     0.200
     6.487    19.262     0.200
     6.516    19.846     0.200
     6.505    19.964     0.200
     6.569    17.711     0.200
     6.946    21.909     0.200
     6.928    20.819     0.200
     6.984    21.521     0.200
     7.014    21.929     0.200
     6.947    24.633     0.200
     7.301    22.017     0.200
     7.484    20.711     0.200
     7.522    22.697     0.200
     7.588    22.840     0.200
     7.609    23.515     0.200
     7.556    24.295     0.200
     7.556    24.487     0.200
     7.786    25.267     0.200
     8.088    24.046     0.200
     8.031    21.675     0.200
     8.155    22.688     0.200
     8.155    22.164     0.200
     8.155    24.047     0.200
     8.284    23.945     0.200
     8.284    21.945     0.200
     8.327    24.789     0.200
     8.194    22.677     0.200
     8.194    25.525     0.200
     8.548    24.716     0.200
     8.546    24.319     0.200
     8.546    25.444     0.200
     8.546    25.979     0.200
     8.860    25.146     0.200
     8.914    24.941     0.200
     8.941    27.392     0.200
     9.139    26.322     0.200
     9.188    25.885     0.200
     9.240    24.515     0.200
     9.240    26.144     0.200
     9.972    31.182     0.200
    10.062    31.759     0.200
    10.106    28.935     0.200
    10.124    31.995     0.200
    10.124    28.862     0.200
    10.124    30.495     0.200
    10.449    31.996     0.200
    10.519    29.421     0.200
    10.634    31.107     0.200
    10.634    28.681     0.200
    10.747    30.829     0.200
    10.830    32.255     0.200
    10.783    29.801     0.200
    10.783    30.172     0.200
    10.842    32.444     0.200
    11.137    30.617     0.200
    11.217    31.092     0.200
    11.263    32.598     0.200
    11.699    32.736     0.200
    12.874    34.704     0.200
    12.875    34.218     0.200
    12.769    33.971     0.200
    12.769    36.932     0.200
    13.174    35.321     0.200
    13.174    33.372     0.200
    13.174    35.352     0.200
    13.453    36.226     0.200
    13.890    34.413     0.200
    13.856    32.796     0.200
    13.869    34.593     0.200
    14.300    35.112     0.200
    14.547    36.982     0.200
    14.562    36.476     0.200
    14.523    36.523     0.200
    14.580    36.266     0.200
    14.567    35.566     0.200
    14.844    36.638     0.200
    14.906    33.487     0.200
    15.028    37.707     0.200
    15.085    36.439     0.200
    15.276    35.570     0.200
    15.486    38.016     0.200
    15.476    36.923     0.200
    15.727    35.212     0.200
    15.882    37.555     0.200
    16.000    35.331     0.200
    15.959    38.060     0.200
    16.160    37.585     0.200
    16.522    37.388     0.200
    16.522    36.970     0.200
    17.046    37.257     0.200
    17.225    38.918     0.200
    18.298    38.615     0.200
    18.923    39.532     0.200
    19.431    40.419     0.200
    19.531    41.170     0.200
    19.880    41.163     0.200
    20.603    39.214     0.200
    20.631    40.155     0.200
    20.989    39.041     0.200
     1.106     6.508     0.200
     1.443     8.147     0.200
     1.517     7.862     0.200
     1.549     7.780     0.200
     1.549     8.014     0.200
     1.501     8.534     0.200
     1.664     8.837     0.200
     1.682     9.346     0.200
     1.699     8.448     0.200
     2.519    12.412     0.200
     3.205    11.781     0.200
     3.397    14.122     0.200
     4.029    14.715     0.200
     4.029    15.270     0.200
     4.187    17.897     0.200
     5.378    17.850     0.200
     5.677    18.731     0.200
     8.204    27.823     0.200
     9.247    28.078     0.200
     9.821    28.690     0.200
    12.368    36.754     0.200
     0.826     5.031     0.200
     1.214     5.568     0.200
     1.286     7.159     0.200
     1.378     7.554     0.200
     1.378     7.265     0.200
     1.416     7.669     0.200
     1.472     7.594     0.200
     1.490     7.721     0.200
     1.525     8.198     0.200
     1.518     7.267     0.200
     1.518     7.478     0.200
     1.590     7.460     0.200
     1.595     7.692     0.200
     1.646     9.408     0.200
     1.652     8.203     0.200
     1.652     8.906     0.200
     1.756     8.487     0.200
     1.729     6.902     0.200
     1.769     8.575     0.200
     1.814     8.820     0.200
     1.896     9.941     0.200
     1.972     8.715     0.200
     2.030     8.943     0.200
     2.049     8.398     0.200
     2.070     9.277     0.200
     2.139     8.412     0.200
     2.157     8.868     0.200
     2.216     8.485     0.200
     2.216     9.548     0.200
     2.239     9.164     0.200
     2.239    10.164     0.200
     2.247    10.449     0.200
     2.268     9.364     0.200
     2.323     8.926     0.200
     2.434    10.584     0.200
     2.434    10.318     0.200
     2.505    10.249     0.200
     2.535     9.968     0.200
     2.625    10.775     0.200
     2.646    10.164     0.200
     2.716     9.904     0.200
     2.807    11.121     0.200
     2.818    11.156     0.200
     3.062    12.090     0.200
     3.062    11.825     0.200
     3.071    11.575     0.200
     3.174    11.863     0.200
     3.178    11.478     0.200
     3.185    11.591     0.200
     3.185    11.427     0.200
     3.185    13.763     0.200
     3.185    12.248     0.200
     3.205    11.687     0.200
     3.198    11.119     0.200
     3.198    12.174     0.200
     3.198    10.893     0.200
     3.198    11.401     0.200
     3.310    12.465     0.200
     3.484    12.155     0.200
     3.484    11.967     0.200
     3.582    12.014     0.200
     3.733    13.121     0.200
     3.754    12.306     0.200
     3.925    13.738     0.200
     4.060    13.209     0.200
     4.081    13.279     0.200
     4.108    14.538     0.200
     4.147    15.955     0.200
     4.174    14.074     0.200
     4.259    15.731     0.200
     4.253    15.182     0.200
     4.307    14.869     0.200
     4.284    13.412     0.200
     4.478    14.768     0.200
     4.572    14.724     0.200
     4.610    15.652     0.200
     4.629    15.740     0.200
     4.704    14.591     0.200
     4.769    15.730     0.200
     4.769    15.972     0.200
     5.010    16.432     0.200
     5.066    16.671     0.200
     5.066    17.288     0.200
     5.141    17.915     0.200
     5.181    16.086     0.200
     5.289    17.883     0.200
     5.385    16.845     0.200
     5.426    17.156     0.200
     5.508    18.678     0.200
     5.522    17.358     0.200
     5.547    18.437     0.200
     5.547    18.609     0.200
     5.612    17.886     0.200
     5.698    19.829     0.200
     5.685    18.176     0.200
     5.685    17.621     0.200
     5.820    18.561     0.200
     5.820    19.600     0.200
     5.840    18.235     0.200
     6.014    18.176     0.200
     6.063    20.004     0.200
     6.076    19.044     0.200
     6.269    20.955     0.200
     6.277    21.100     0.200
     6.445    23.072     0.200
     6.488    19.494     0.200
     6.488    21.423     0.200
     6.535    20.216     0.200
     6.584    18.715     0.200
     6.608    20.527     0.200
     6.643    21.292     0.200
     6.708    20.053     0.200
     6.732    19.848     0.200
     6.872    21.716     0.200
     6.872    23.643     0.200
     7.034    20.476     0.200
     7.138    20.680     0.200
     7.187    22.500     0.200
     7.378    20.447     0.200
     7.378    21.924     0.200
     7.440    21.007     0.200
     7.460    22.220     0.200
     7.484    21.991     0.200
     7.528    21.955     0.200
     7.594    22.533     0.200
     7.594    21.869     0.200
     7.602    23.222     0.200
     7.602    22.722     0.200
     7.602    24.488     0.200
     7.630    23.522     0.200
     7.644    23.281     0.200
     7.702    22.628     0.200
     7.694    22.793     0.200
     7.735    20.043     0.200
     7.775    23.287     0.200
     7.775    23.584     0.200
     7.775    24.334     0.200
     7.913    23.145     0.200
     7.942    22.600     0.200
     7.947    24.536     0.200
     7.998    23.426     0.200
     8.010    23.925     0.200
     8.051    23.564     0.200
     8.099    22.674     0.200
     8.099    27.502     0.200
     8.145    23.145     0.200
     8.251    23.473     0.200
     8.281    23.058     0.200
     8.336    25.532     0.200
     8.336    26.392     0.200
     8.352    22.621     0.200
     8.540    26.217     0.200
     8.590    23.448     0.200
     8.599    23.933     0.200
     8.606    25.374     0.200
     8.629    24.024     0.200
     8.885    24.355     0.200
     8.882    25.707     0.200
     8.928    23.934     0.200
     9.068    23.304     0.200
     9.156    25.121     0.200
     9.142    26.185     0.200
     9.165    26.133     0.200
     9.203    24.727     0.200
     9.209    25.549     0.200
     9.209    25.167     0.200
     9.209    27.932     0.200
     9.265    24.400     0.200
     9.297    26.517     0.200
     9.298    26.648     0.200
     9.298    26.351     0.200
     9.506    25.133     0.200
     9.616    24.935     0.200
     9.633    25.603     0.200
     9.682    24.736     0.200
     9.720    26.018     0.200
     9.720    30.713     0.200
     9.840    26.576     0.200
     9.833    26.719     0.200
     9.833    28.782     0.200
     9.828    27.493     0.200
     9.886    26.280     0.200
     9.914    26.916     0.200
    10.022    28.560     0.200
    10.106    28.198     0.200
    10.106    30.175     0.200
    10.160    27.543     0.200
    10.160    29.316     0.200
    10.299    27.406     0.200
    10.299    29.031     0.200
    10.313    26.835     0.200
    10.349    27.586     0.200
    10.460    27.193     0.200
    10.500    28.985     0.200
    10.763    33.665     0.200
    10.763    28.157     0.200
    10.783    28.315     0.200
    10.855    28.399     0.200
    10.975    29.537     0.200
    10.988    30.343     0.200
    11.210    31.420     0.200
    11.210    34.061     0.200
    11.215    32.186     0.200
    11.881    31.769     0.200
    11.900    32.476     0.200
    11.968    31.380     0.200
    11.968    35.896     0.200
    12.285    32.057     0.200
    12.285    35.197     0.200
    12.326    31.415     0.200
    12.388    31.935     0.200
    12.388    31.810     0.200
    12.411    33.077     0.200
    12.464    31.692     0.200
    12.423    33.351     0.200
    12.423    34.390     0.200
    12.445    32.848     0.200
    12.502    32.901     0.200
    12.502    32.792     0.200
    12.506    32.980     0.200
    12.506    33.644     0.200
    12.591    32.623     0.200
    12.663    33.779     0.200
    12.698    33.669     0.200
    12.704    33.802     0.200
    12.751    33.313     0.200
    12.823    32.826     0.200
    12.820    34.539     0.200
    12.831    33.664     0.200
    12.896    33.546     0.200
    12.984    33.694     0.200
    13.032    35.374     0.200
    13.044    32.839     0.200
    13.008    35.121     0.200
    13.097    32.571     0.200
    13.180    37.929     0.200
    13.495    35.727     0.200
    13.495    35.876     0.200
    13.856    35.360     0.200
    13.936    34.736     0.200
    13.943    34.898     0.200
    13.981    35.807     0.200
    13.996    34.836     0.200
    14.029    34.829     0.200
    14.173    36.364     0.200
    14.184    34.845     0.200
    14.184    36.814     0.200
    14.280    35.516     0.200
    14.295    36.706     0.200
    14.295    37.784     0.200
    14.351    34.536     0.200
    14.343    36.349     0.200
    14.364    36.322     0.200
    14.412    36.199     0.200
    14.404    37.125     0.200
    14.484    36.346     0.200
    14.558    35.806     0.200
    14.565    37.169     0.200
    14.588    36.481     0.200
    14.588    36.794     0.200
    14.567    37.691     0.200
    14.677    37.066     0.200
    14.677    36.074     0.200
    14.684    36.690     0.200
    14.722    37.814     0.200
    15.339    38.389     0.200
    15.898    40.527     0.200
    16.129    40.251     0.200
    16.498    39.057     0.200
    16.498    39.471     0.200
    16.569    40.369     0.200
    16.665    39.485     0.200
    16.747    39.941     0.200
    16.726    41.523     0.200
    16.809    39.643     0.200
    17.305    39.148     0.200
    17.711    41.331     0.200
    19.012    42.614     0.200
    20.029    41.218     0.200
    20.175    40.786     0.200
    20.543    41.776     0.200
     0.924     5.751     0.200
     1.136     7.022     0.200
     1.452     8.337     0.200
     1.503     8.988     0.200
     1.553     8.301     0.200
     1.693     9.385     0.200
     1.656     9.021     0.200
     1.813     9.667     0.200
     1.854     9.298     0.200
     1.867     8.841     0.200
     1.931     9.748     0.200
     2.012    11.064     0.200
     2.187    10.069     0.200
     2.187     9.444     0.200
     2.268    10.232     0.200
     2.322    10.538     0.200
     2.322    10.898     0.200
     2.326    11.407     0.200
     2.325     8.626     0.200
     2.377    10.924     0.200
     2.438    10.605     0.200
     2.530    11.725     0.200
     2.530    10.936     0.200
     2.604    10.611     0.200
     2.638    11.040     0.200
     2.734    12.018     0.200
     2.749    12.425     0.200
     2.749    12.238     0.200
     2.829    12.231     0.200
     2.914    12.221     0.200
     2.925    11.697     0.200
     3.165    12.279     0.200
     3.165    13.021     0.200
     3.161    13.356     0.200
     3.206    14.693     0.200
     3.206    14.521     0.200
     3.206    13.388     0.200
     3.290    13.869     0.200
     3.293    12.453     0.200
     3.300    14.488     0.200
     3.300    12.355     0.200
     3.300    15.980     0.200
     3.322    12.019     0.200
     3.365    13.023     0.200
     3.428    14.022     0.200
     3.386    15.847     0.200
     3.691    14.585     0.200
     3.863    14.986     0.200
     4.166    15.529     0.200
     4.175    16.020     0.200
     4.222    17.060     0.200
     4.292    17.144     0.200
     4.419    16.990     0.200
     4.680    15.948     0.200
     4.727    16.693     0.200
     4.818    17.616     0.200
     4.887    17.303     0.200
     4.887    16.435     0.200
     5.058    17.897     0.200
     5.144    18.294     0.200
     5.144    17.294     0.200
     5.303    17.632     0.200
     5.295    17.817     0.200
     5.503    18.625     0.200
     5.622    18.748     0.200
     5.601    19.647     0.200
     5.601    19.952     0.200
     5.640    18.817     0.200
     5.726    19.806     0.200
     5.706    18.733     0.200
     5.676    20.118     0.200
     5.676    19.680     0.200
     5.935    18.454     0.200
     5.935    19.908     0.200
     5.947    17.735     0.200
     6.117    19.020     0.200
     6.168    21.201     0.200
     6.176    19.332     0.200
     6.193    19.361     0.200
     6.390    21.119     0.200
     6.552    21.605     0.200
     6.606    20.336     0.200
     6.640    20.223     0.200
     6.680    20.697     0.200
     6.711    21.212     0.200
     6.824    21.219     0.200
     6.850    21.737     0.200
     6.885    22.969     0.200
     7.152    21.031     0.200
     7.284    22.187     0.200
     7.493    22.405     0.200
     7.493    24.249     0.200
     7.546    22.553     0.200
     7.592    20.881     0.200
     7.565    25.440     0.200
     7.625    23.214     0.200
     7.728    23.501     0.200
     7.743    22.551     0.200
     7.838    22.666     0.200
     7.838    24.401     0.200
     7.905    24.425     0.200
     8.053    23.175     0.200
     8.110    22.877     0.200
     8.128    22.972     0.200
     8.343    24.887     0.200
     8.470    24.940     0.200
     8.525    24.950     0.200
     8.546    24.884     0.200
     8.549    23.240     0.200
     8.598    24.244     0.200
     8.619    25.107     0.200
     8.625    24.134     0.200
     8.695    24.666     0.200
     8.717    24.307     0.200
     8.744    23.211     0.200
     8.733    25.622     0.200
     8.757    26.020     0.200
     8.765    25.644     0.200
     8.848    25.384     0.200
     9.096    26.425     0.200
     9.274    24.875     0.200
     9.254    26.083     0.200
     9.239    27.677     0.200
     9.240    28.238     0.200
     9.240    28.441     0.200
     9.312    28.136     0.200
     9.833    25.617     0.200
     9.980    27.629     0.200
     9.997    29.314     0.200
    10.196    29.213     0.200
    12.067    31.607     0.200
    12.439    30.380     0.200
    12.382    33.004     0.200
    12.532    31.598     0.200
    12.579    31.096     0.200
    12.689    32.016     0.200
    12.938    33.147     0.200
    12.931    33.460     0.200
    13.014    32.107     0.200
    13.083    33.360     0.200
    13.492    34.626     0.200
    13.492    36.494     0.200
    14.082    36.425     0.200
    14.208    35.341     0.200
    14.403    35.551     0.200
    14.780    35.995     0.200
    14.780    36.745     0.200
    15.153    35.716     0.200
    15.110    37.250     0.200
    15.208    37.301     0.200
    15.414    37.396     0.200
    15.414    39.513     0.200
    15.600    37.453     0.200
    15.826    38.841     0.200
    15.856    38.845     0.200
    15.990    37.943     0.200
    16.085    37.632     0.200
    16.139    39.230     0.200
    16.215    37.820     0.200
    16.328    39.454     0.200
    16.865    38.652     0.200
    16.898    39.628     0.200
    17.206    38.351     0.200
    17.316    38.739     0.200
    17.357    38.947     0.200
    17.406    38.846     0.200
    18.927    42.274     0.200
    19.099    43.218     0.200
    20.167    41.844     0.200
     0.995     5.706     0.200
     1.177     7.595     0.200
     1.177     7.435     0.200
     1.763     8.897     0.200
     2.601    11.169     0.200
     1.112     6.309     0.200
     1.228     8.029     0.200
     1.338     7.257     0.200
     1.453     8.583     0.200
     1.533     9.086     0.200
     1.813     9.595     0.200
     2.219    11.062     0.200
     2.873    10.065     0.200
     3.076    13.195     0.200
     3.159    14.400     0.200
     3.262    13.400     0.200
     3.597    14.235     0.200
     3.723    15.342     0.200
     5.086    16.681     0.200
     5.619    19.334     0.200
     7.727    23.590     0.200
     8.915    26.358     0.200
     1.336     9.328     0.200
     1.396     8.974     0.200
     1.472     8.970     0.200
     1.472     8.310     0.200
     1.472     8.430     0.200
     1.490     8.471     0.200
     1.563     8.758     0.200
     1.552     9.303     0.200
     1.545     8.477     0.200
     1.638     9.442     0.200
     1.798     8.249     0.200
     1.812     9.361     0.200
     1.908     7.122     0.200
     1.911     9.532     0.200
     1.976     8.665     0.200
     2.027     9.230     0.200
     2.027     9.934     0.200
     2.067     9.178     0.200
     2.062     9.858     0.200
     2.225    10.157     0.200
     2.225     8.986     0.200
     2.290    10.687     0.200
     2.312    11.286     0.200
     2.384    10.571     0.200
     2.467    10.926     0.200
     2.545    10.837     0.200
     2.608    11.172     0.200
     2.838    11.458     0.200
     2.838    12.323     0.200
     2.882    12.315     0.200
     2.924    10.853     0.200
     2.931    11.308     0.200
     2.931    10.753     0.200
     2.931    13.007     0.200
     2.946    11.555     0.200
     3.049    11.893     0.200
     3.202    10.486     0.200
     3.202    14.940     0.200
     3.339    12.556     0.200
     3.484    12.906     0.200
     3.514    12.975     0.200
     3.664    13.563     0.200
     3.827    15.230     0.200
     3.913    13.260     0.200
     3.945    15.898     0.200
     4.041    16.149     0.200
     4.060    14.133     0.200
     4.123    16.112     0.200
     4.220    14.301     0.200
     4.218    14.298     0.200
     4.336    16.376     0.200
     4.349    15.338     0.200
     4.454    16.238     0.200
     4.479    17.613     0.200
     4.507    14.910     0.200
     4.507    16.327     0.200
     4.529    15.539     0.200
     4.646    17.141     0.200
     4.879    19.803     0.200
     4.901    17.093     0.200
     4.901    18.265     0.200
     4.915    17.150     0.200
     4.929    15.741     0.200
     5.031    20.254     0.200
     5.218    19.173     0.200
     5.369    19.250     0.200
     5.411    18.420     0.200
     5.438    19.698     0.200
     5.437    21.344     0.200
     5.506    19.199     0.200
     5.566    20.416     0.200
     5.580    20.572     0.200
     5.602    18.260     0.200
     5.717    18.811     0.200
     5.717    19.497     0.200
     5.717    18.492     0.200
     5.789    19.586     0.200
     5.859    20.379     0.200
     5.869    21.498     0.200
     6.009    19.891     0.200
     6.026    21.135     0.200
     6.138    20.200     0.200
     6.226    18.934     0.200
     6.307    20.102     0.200
     6.374    21.272     0.200
     6.384    20.790     0.200
     6.544    18.613     0.200
     6.614    20.843     0.200
     6.596    17.880     0.200
     6.712    21.583     0.200
     6.953    21.447     0.200
     7.105    21.902     0.200
     7.124    21.050     0.200
     7.338    22.707     0.200
     7.559    22.074     0.200
     7.559    25.773     0.200
     7.642    24.125     0.200
     7.642    24.364     0.200
     7.642    26.015     0.200
     7.668    23.762     0.200
     7.668    21.693     0.200
     7.668    23.913     0.200
     7.700    22.511     0.200
     8.049    25.356     0.200
     8.050    24.640     0.200
     8.398    24.501     0.200
     8.414    24.424     0.200
     8.596    27.833     0.200
     8.596    26.953     0.200
     8.740    29.049     0.200
     8.740    30.069     0.200
     8.945    25.024     0.200
     8.981    26.175     0.200
     8.981    29.760     0.200
     9.471    32.386     0.200
     9.735    29.495     0.200
     9.735    26.044     0.200
     9.917    28.603     0.200
    10.086    30.223     0.200
    10.087    26.416     0.200
    10.122    27.952     0.200
    10.122    25.533     0.200
    10.129    29.812     0.200
    10.129    29.222     0.200
    10.545    33.845     0.200
    10.740    29.689     0.200
    11.077    31.589     0.200
    11.214    30.076     0.200
    11.647    35.651     0.200
    11.750    32.800     0.200
    11.751    29.717     0.200
    11.751    35.137     0.200
    12.082    32.210     0.200
    12.082    32.152     0.200
    12.082    37.242     0.200
    12.260    31.270     0.200
    12.260    32.859     0.200
    12.260    36.320     0.200
    12.299    31.243     0.200
    12.521    35.390     0.200
    12.521    33.308     0.200
    12.561    33.590     0.200
    13.265    34.664     0.200
    13.315    35.866     0.200
    13.315    35.517     0.200
    13.486    37.167     0.200
    13.486    38.417     0.200
    13.510    34.672     0.200
    13.510    34.020     0.200
    13.510    37.902     0.200
    13.630    35.963     0.200
    13.686    35.870     0.200
    14.121    34.425     0.200
    14.258    36.865     0.200
    14.383    37.056     0.200
    14.379    34.970     0.200
    14.379    35.889     0.200
    14.410    37.648     0.200
    14.410    37.898     0.200
    14.450    35.731     0.200
    14.450    36.631     0.200
    14.840    37.017     0.200
    15.086    38.000     0.200
    15.177    38.636     0.200
    15.177    38.837     0.200
    15.462    39.835     0.200
    15.530    37.551     0.200
    15.796    39.513     0.200
    15.839    39.263     0.200
    15.997    38.610     0.200
    16.132    40.434     0.200
    16.449    39.041     0.200
    16.796    40.760     0.200
    17.086    40.195     0.200
    17.086    39.928     0.200
    17.094    40.003     0.200
    17.675    41.420     0.200
    17.739    39.522     0.200
    17.739    39.239     0.200
    17.857    41.508     0.200
    19.790    41.954     0.200
    19.958    41.691     0.200
    20.141    41.610     0.200
    20.281    42.050     0.200
     1.250     7.021     0.200
     1.467     8.414     0.200
     1.498     7.951     0.200
     1.583     7.712     0.200
     1.631     8.560     0.200
     1.623     7.961     0.200
     1.877     8.124     0.200
     1.963     7.741     0.200
     2.026     8.044     0.200
     2.089     9.346     0.200
     2.263    10.017     0.200
     2.330    10.000     0.200
     2.355     9.461     0.200
     2.533    12.264     0.200
     2.881    11.496     0.200
     2.940    12.587     0.200
     2.988    12.555     0.200
     2.988    12.338     0.200
     3.218    12.601     0.200
     3.564    12.350     0.200
     3.892    15.653     0.200
     4.019    14.795     0.200
     4.332    14.416     0.200
     4.660    15.976     0.200
     4.955    17.734     0.200
     5.321    18.008     0.200
     5.481    18.869     0.200
     5.651    17.895     0.200
     5.727    18.106     0.200
     5.853    19.459     0.200
     6.436    20.810     0.200
     7.588    24.308     0.200
     7.690    23.566     0.200
     7.900    28.056     0.200
     9.032    27.714     0.200
     9.242    26.199     0.200
     9.416    27.475     0.200
    12.463    37.292     0.200
    18.768    41.177     0.200
     1.021     5.220     0.200
     1.546     6.916     0.200
     1.622     7.714     0.200
     1.950     7.682     0.200
     2.180     9.755     0.200
     2.241    10.047     0.200
     5.566    15.647     0.200
     1.135     6.882     0.200
     1.182     8.243     0.200
     1.182     7.063     0.200
     1.184     6.795     0.200
     1.264     8.784     0.200
     1.330     8.584     0.200
     1.318     8.856     0.200
     1.424     9.136     0.200
     1.479     9.065     0.200
     1.520     9.497     0.200
     1.520     9.887     0.200
     1.574     8.754     0.200
     1.596     9.036     0.200
     1.672     8.536     0.200
     1.672     8.235     0.200
     1.732     9.682     0.200
     1.748     8.384     0.200
     1.938    10.273     0.200
     2.050    10.589     0.200
     2.050    10.241     0.200
     2.111     9.767     0.200
     2.178    10.394     0.200
     2.254    10.740     0.200
     2.646    12.084     0.200
     2.670    12.176     0.200
     3.175    13.217     0.200
     3.280    13.206     0.200
     3.550    14.968     0.200
     3.785    15.774     0.200
     4.164    13.844     0.200
     4.627    16.847     0.200
     4.687    14.195     0.200
     4.773    16.262     0.200
     4.964    17.286     0.200
     4.973    16.964     0.200
     5.159    19.432     0.200
     5.517    20.196     0.200
     5.578    20.130     0.200
     5.593    20.896     0.200
     5.711    18.671     0.200
     5.848    21.054     0.200
     6.489    21.621     0.200
     6.833    22.964     0.200
     7.415    23.715     0.200
     8.118    23.937     0.200
     1.851     7.971     0.200
     1.866     6.916     0.200
     1.866     7.518     0.200
     2.269    10.428     0.200
     2.335     7.772     0.200
     3.183    14.199     0.200
     4.182    15.141     0.200
     1.103     5.574     0.200
     1.226     7.016     0.200
     1.595     7.881     0.200
     1.540     8.562     0.200
     1.725     9.291     0.200
     2.030    10.137     0.200
     2.386     9.957     0.200
     2.462     9.443     0.200
     2.702    11.570     0.200
     2.818    11.055     0.200
     3.021    13.608     0.200
     3.219    12.976     0.200
     3.220    11.859     0.200
     3.220    12.550     0.200
     3.313    14.033     0.200
     3.498    11.945     0.200
     4.289    16.173     0.200
     4.346    15.933     0.200
     4.624    16.454     0.200
     4.868    19.713     0.200
     5.011    17.909     0.200
     5.088    16.261     0.200
     5.138    17.890     0.200
     5.274    16.920     0.200
     5.500    21.057     0.200
     5.659    18.718     0.200
     5.816    20.509     0.200
     5.841    17.734     0.200
     5.863    18.804     0.200
     6.133    20.189     0.200
     6.131    20.897     0.200
     6.291    20.741     0.200
     6.344    21.480     0.200
     6.393    20.570     0.200
     6.445    18.390     0.200
     6.568    20.329     0.200
     6.694    21.102     0.200
     6.816    22.093     0.200
     6.843    22.467     0.200
     6.884    21.364     0.200
     7.051    20.701     0.200
     7.353    23.832     0.200
     7.457    22.666     0.200
     7.447    24.571     0.200
     7.687    22.525     0.200
     7.689    24.511     0.200
     7.773    21.855     0.200
     7.830    21.487     0.200
     7.893    23.761     0.200
     7.970    23.044     0.200
     8.418    29.981     0.200
     8.787    25.431     0.200
     9.014    27.016     0.200
     9.138    23.639     0.200
     9.475    29.691     0.200
     9.582    27.918     0.200
     9.823    31.470     0.200
    10.023    30.150     0.200
    12.533    34.520     0.200
    12.776    36.614     0.200
    13.751    36.951     0.200
    13.988    37.939     0.200
    14.399    38.926     0.200
    14.604    36.192     0.200
    14.641    36.328     0.200
    14.738    34.906     0.200
    15.678    36.700     0.200
     1.067     6.992     0.200
     1.317     7.730     0.200
     1.330     7.446     0.200
     1.582     7.388     0.200
     2.008     9.685     0.200
     2.320    11.203     0.200
     6.908    21.299     0.200
     7.771    23.458     0.200
     8.927    29.316     0.200
     8.886    25.439     0.200
    12.926    37.666     0.200
     1.667     8.926     0.200
     1.667     8.765     0.200
     1.684     8.583     0.200
     1.662     9.824     0.200
     1.868     9.854     0.200
     1.934     9.421     0.200
     1.863     9.003     0.200
     1.921    10.492     0.200
     2.011     8.778     0.200
     2.306    11.013     0.200
     2.736    10.999     0.200
     2.754    11.137     0.200
     3.260    13.464     0.200
     3.490    13.712     0.200
     3.490    13.860     0.200
     3.775    13.353     0.200
     1.363     8.217     0.200
     1.474     8.115     0.200
     1.512     8.632     0.200
     1.512     8.804     0.200
     1.793     8.848     0.200
     1.793     9.426     0.200
     2.073    10.437     0.200
     2.189    11.762     0.200
     2.330     9.561     0.200
     2.399    10.593     0.200
     2.595    11.093     0.200
     2.842    11.131     0.200
     2.893    12.334     0.200
     2.968    11.880     0.200
     3.121    12.423     0.200
     3.354    16.866     0.200
     3.553    13.940     0.200
     3.624    13.772     0.200
     3.873    15.002     0.200
     3.899    13.123     0.200
     3.899    14.334     0.200
     4.387    15.367     0.200
     5.541    15.856     0.200
     5.824    19.292     0.200
     6.444    21.482     0.200
     6.903    21.454     0.200
     7.379    23.095     0.200
     7.552    23.676     0.200
     7.609    25.340     0.200
     7.997    24.758     0.200
     8.088    24.829     0.200
     8.167    21.934     0.200
     8.877    27.568     0.200
     9.158    28.480     0.200
     9.219    28.148     0.200
     9.219    27.851     0.200
    10.490    29.957     0.200
    10.558    32.177     0.200
    14.480    34.706     0.200
    14.832    34.070     0.200
    14.932    35.344     0.200
    15.423    37.323     0.200
    16.228    38.290     0.200
    16.576    37.376     0.200
    16.610    38.364     0.200
    16.692    36.544     0.200
    16.700    37.319     0.200
    16.817    37.484     0.200
    16.871    37.829     0.200
    16.914    37.000     0.200
    16.980    38.901     0.200
    17.547    38.449     0.200
    17.603    38.623     0.200
    18.133    38.711     0.200
    20.411    40.818     0.200
     1.202     5.486     0.200
     1.435     7.049     0.200
     1.435     7.209     0.200
     1.464     6.652     0.200
     1.464     6.465     0.200
     1.566     7.830     0.200
     1.861     8.780     0.200
     2.149     9.502     0.200
     2.101    12.024     0.200
     2.384     8.764     0.200
     2.386     9.419     0.200
     2.191    10.665     0.200
     2.574     9.680     0.200
     2.885    11.641     0.200
     2.903    11.494     0.200
     3.030    12.945     0.200
     3.120    10.991     0.200
     2.999    14.009     0.200
     3.553    14.223     0.200
     3.541    12.126     0.200
     3.541    10.684     0.200
     3.841    13.960     0.200
     3.939    13.707     0.200
     3.939    13.547     0.200
     4.321    14.880     0.200
     4.440    15.672     0.200
     4.772    15.837     0.200
     4.894    16.056     0.200
     5.569    17.363     0.200
     5.778    19.172     0.200
     5.890    18.633     0.200
     6.392    20.730     0.200
     6.502    22.102     0.200
     6.718    20.428     0.200
     6.829    21.872     0.200
     6.880    22.116     0.200
     6.982    21.224     0.200
     6.959    19.523     0.200
     7.226    22.235     0.200
     7.218    21.720     0.200
     7.227    21.295     0.200
     7.293    20.580     0.200
     7.466    21.038     0.200
     7.566    25.976     0.200
     7.900    23.617     0.200
     8.006    22.349     0.200
     8.006    22.455     0.200
     8.408    22.816     0.200
     8.905    26.052     0.200
     8.893    26.194     0.200
     9.164    24.065     0.200
     9.061    26.195     0.200
     9.245    23.948     0.200
     9.122    26.166     0.200
     9.123    26.298     0.200
     9.123    26.029     0.200
    10.557    30.990     0.200
    11.220    30.176     0.200
    13.435    36.305     0.200
    15.225    36.567     0.200
    15.330    37.426     0.200
    15.609    37.845     0.200
    15.588    39.076     0.200
    16.028    36.759     0.200
    16.897    38.830     0.200
     1.078     6.878     0.200
     1.261     7.486     0.200
     1.261     8.265     0.200
     1.545     8.957     0.200
     1.648    10.374     0.200
     1.648    11.364     0.200
     1.983    10.550     0.200
     2.157    10.545     0.200
     2.503    11.784     0.200
     2.534    12.139     0.200
     2.557    11.353     0.200
     2.774    11.121     0.200
     2.855     8.919     0.200
     3.141    13.738     0.200
     3.158    16.688     0.200
     3.157    12.210     0.200
     3.284    13.175     0.200
     3.284    12.906     0.200
     3.431    14.108     0.200
     4.140    14.908     0.200
     4.193    15.707     0.200
     4.394    16.315     0.200
     4.468    16.309     0.200
     4.677    17.108     0.200
     5.230    18.499     0.200
     5.386    17.748     0.200
     5.981    21.249     0.200
     6.218    19.855     0.200
     6.412    20.643     0.200
     6.464    22.192     0.200
     6.594    22.129     0.200
     6.733    21.243     0.200
     6.815    22.718     0.200
     6.962    23.311     0.200
     6.970    22.329     0.200
     7.054    22.088     0.200
     7.139    21.967     0.200
     7.221    22.479     0.200
     7.310    21.389     0.200
     7.535    23.629     0.200
     7.566    23.681     0.200
     7.734    24.760     0.200
     7.734    24.918     0.200
     7.804    23.837     0.200
     7.807    24.092     0.200
     7.837    23.843     0.200
     8.044    25.773     0.200
     8.769    26.286     0.200
     8.783    25.490     0.200
     8.803    27.607     0.200
     8.872    28.672     0.200
     8.953    26.466     0.200
     9.017    27.220     0.200
     9.126    28.567     0.200
     9.127    27.878     0.200
     9.127    27.272     0.200
     9.518    27.493     0.200
     9.975    30.432     0.200
    10.363    29.969     0.200
    11.733    31.996     0.200
    12.314    33.823     0.200
    12.471    34.424     0.200
    12.844    32.213     0.200
    12.922    35.203     0.200
    14.521    36.814     0.200
    14.859    37.345     0.200
    15.468    38.050     0.200
    15.605    38.672     0.200
    16.632    40.589     0.200
    16.663    41.700     0.200
    17.161    40.534     0.200
     1.512     8.165     0.200
     1.583     8.843     0.200
     1.583     9.139     0.200
     1.745     8.789     0.200
     1.883     9.787     0.200
     1.897    11.678     0.200
     1.939    10.354     0.200
     1.923    10.147     0.200
     2.034     9.051     0.200
     2.092     9.888     0.200
     2.479    11.255     0.200
     2.467    11.355     0.200
     2.532     9.243     0.200
     2.601    12.510     0.200
     2.702    12.214     0.200
     2.702    12.018     0.200
     2.678    12.148     0.200
     2.782    11.611     0.200
     3.067    12.547     0.200
     3.225    11.628     0.200
     3.225    11.315     0.200
     3.225    16.221     0.200
     3.279    12.001     0.200
     3.373    13.573     0.200
     3.519    14.371     0.200
     3.519    13.926     0.200
     3.519    14.043     0.200
     3.745    16.035     0.200
     3.745    12.105     0.200
     3.959    13.359     0.200
     3.959    13.492     0.200
     3.979    13.748     0.200
     3.979    12.904     0.200
     4.063    15.521     0.200
     4.215    14.417     0.200
     4.269    13.931     0.200
     4.399    15.343     0.200
     4.680    15.523     0.200
     4.784    19.604     0.200
     4.878    17.146     0.200
     5.057    17.110     0.200
     5.117    17.974     0.200
     5.202    17.782     0.200
     5.316    17.555     0.200
     5.876    18.357     0.200
     6.142    20.358     0.200
     6.151    20.059     0.200
     6.401    20.532     0.200
     6.351    19.176     0.200
     6.430    19.899     0.200
     6.485    21.719     0.200
     6.615    20.073     0.200
     6.775    22.769     0.200
     6.775    26.676     0.200
     6.965    21.508     0.200
     7.051    21.233     0.200
     7.384    23.308     0.200
     7.389    24.257     0.200
     7.389    24.444     0.200
     7.559    21.951     0.200
     7.559    22.607     0.200
     7.723    23.107     0.200
     7.723    23.365     0.200
     7.723    22.490     0.200
     7.723    23.911     0.200
     7.826    22.909     0.200
     7.870    23.188     0.200
     7.992    24.609     0.200
     7.992    22.718     0.200
     7.992    25.242     0.200
     8.006    23.998     0.200
     8.006    25.966     0.200
     8.242    23.465     0.200
     8.312    25.563     0.200
     8.312    26.228     0.200
     8.450    28.454     0.200
     8.515    28.370     0.200
     8.738    24.518     0.200
     8.830    25.667     0.200
     8.830    26.214     0.200
     9.032    26.562     0.200
     9.052    26.046     0.200
     9.170    24.759     0.200
     9.170    26.509     0.200
     9.542    27.344     0.200
     9.558    31.407     0.200
     9.970    28.940     0.200
    10.021    28.239     0.200
    10.071    28.548     0.200
    10.071    29.688     0.200
    10.316    29.047     0.200
    11.086    34.921     0.200
    11.188    30.652     0.200
    11.389    31.886     0.200
    11.439    30.579     0.200
    11.773    30.763     0.200
    12.290    37.189     0.200
    12.347    32.214     0.200
    12.347    33.378     0.200
    12.592    30.249     0.200
    12.592    32.695     0.200
    12.592    35.140     0.200
    12.995    33.573     0.200
    13.005    36.963     0.200
    12.992    34.645     0.200
    12.992    36.536     0.200
    12.992    37.809     0.200
    13.213    37.752     0.200
    13.535    34.731     0.200
    13.535    35.262     0.200
    13.622    34.589     0.200
    13.645    35.640     0.200
    13.840    35.436     0.200
    14.027    36.424     0.200
    14.160    35.892     0.200
    14.198    36.502     0.200
    14.260    34.193     0.200
    14.326    35.715     0.200
    14.591    40.014     0.200
    14.695    35.123     0.200
    14.670    40.422     0.200
    14.810    36.258     0.200
    14.902    36.955     0.200
    14.899    36.558     0.200
    14.863    39.506     0.200
    15.819    37.825     0.200
    15.827    39.030     0.200
    15.895    36.775     0.200
    16.229    38.333     0.200
    16.445    39.097     0.200
    16.622    39.142     0.200
    16.688    39.896     0.200
    17.107    40.141     0.200
    17.102    39.173     0.200
    17.379    39.380     0.200
    17.728    39.751     0.200
    17.730    40.173     0.200
    18.075    39.757     0.200
    18.086    39.671     0.200
    18.270    38.760     0.200
    18.959    43.808     0.200
    19.143    45.551     0.200
    19.271    45.654     0.200
    19.301    43.120     0.200
    19.322    44.138     0.200
    19.462    44.423     0.200
    19.601    44.019     0.200
    19.936    43.209     0.200
    20.027    42.913     0.200
    20.403    49.043     0.200
    20.456    49.707     0.200
     0.987     6.436     0.200
     1.097     6.840     0.200
     1.157     7.479     0.200
     1.157     7.402     0.200
     1.342     7.976     0.200
     1.318     8.454     0.200
     1.496     8.779     0.200
     1.422     8.636     0.200
     1.474     8.574     0.200
     1.651     7.927     0.200
     1.539     8.716     0.200
     1.561     8.098     0.200
     1.588     8.105     0.200
     1.677     8.257     0.200
     1.746     7.210     0.200
     1.797     9.275     0.200
     1.887     9.887     0.200
     1.875     8.637     0.200
     2.020    10.824     0.200
     2.020    10.613     0.200
     2.080    10.241     0.200
     2.094    10.092     0.200
     2.154    10.418     0.200
     2.199    10.724     0.200
     2.235    10.932     0.200
     2.260     9.718     0.200
     2.402    10.281     0.200
     2.498    11.430     0.200
     2.693    11.110     0.200
     2.693    11.489     0.200
     2.751    11.938     0.200
     3.262    12.174     0.200
     3.283    13.058     0.200
     3.641    13.348     0.200
     3.931    16.243     0.200
     3.931    15.091     0.200
     3.893    14.805     0.200
     4.102    14.683     0.200
     4.242    14.891     0.200
     4.269    16.408     0.200
     4.459    15.746     0.200
     4.714    16.034     0.200
     4.698    15.430     0.200
     4.793    15.805     0.200
     4.879    17.726     0.200
     5.026    21.429     0.200
     5.039    19.287     0.200
     5.260    20.915     0.200
     5.610    20.808     0.200
     5.641    18.720     0.200
     5.690    21.670     0.200
     5.926    20.897     0.200
     5.989    22.736     0.200
     6.235    18.699     0.200
     6.231    24.582     0.200
     6.535    24.951     0.200
     6.645    23.132     0.200
     6.642    24.848     0.200
     6.872    23.321     0.200
     6.907    24.519     0.200
     7.053    23.116     0.200
     7.141    23.095     0.200
     7.249    26.403     0.200
     7.499    21.969     0.200
     7.568    24.999     0.200
     7.568    24.281     0.200
     7.568    24.402     0.200
     7.568    23.121     0.200
     7.563    22.466     0.200
     7.600    26.175     0.200
     7.600    26.070     0.200
     7.778    22.978     0.200
     7.899    26.603     0.200
     7.934    27.240     0.200
     8.182    27.473     0.200
     8.158    26.091     0.200
     8.193    26.884     0.200
     8.205    24.250     0.200
     8.207    26.201     0.200
     8.217    28.257     0.200
     8.272    27.162     0.200
     8.279    27.773     0.200
     8.279    27.802     0.200
     8.385    27.064     0.200
     8.434    27.439     0.200
     8.448    28.723     0.200
     8.831    27.954     0.200
     9.261    30.187     0.200
     9.391    30.023     0.200
     9.592    30.819     0.200
     9.593    30.939     0.200
     9.593    29.314     0.200
    10.373    32.019     0.200
    11.956    35.089     0.200
    12.164    36.957     0.200
    12.439    34.870     0.200
    13.586    36.350     0.200
    14.319    37.467     0.200
    14.664    40.814     0.200
    15.110    39.426     0.200
    20.100    41.737     0.200
     1.104     6.133     0.200
     1.104     7.372     0.200
     1.149     8.429     0.200
     1.151     6.648     0.200
     1.336     7.355     0.200
     1.495     8.289     0.200
     1.579     8.097     0.200
     1.670     7.943     0.200
     1.670     7.572     0.200
     1.789     8.470     0.200
     1.883     8.272     0.200
     2.015     9.845     0.200
     2.015     9.728     0.200
     2.074     9.728     0.200
     2.088     9.897     0.200
     2.251     9.841     0.200
     2.396    10.106     0.200
     2.684     8.815     0.200
     2.744    11.816     0.200
     3.633    13.228     0.200
     4.461    15.159     0.200
     4.714    17.302     0.200
     4.787    15.047     0.200
     5.253    18.273     0.200
     5.364    16.018     0.200
     5.602    19.444     0.200
     5.682    17.873     0.200
     5.917    19.021     0.200
     6.643    21.101     0.200
     6.987    23.072     0.200
     7.134    22.870     0.200
     0.946     5.048     0.200
     1.039     6.226     0.200
     1.112     6.544     0.200
     1.112     6.413     0.200
     1.112     7.020     0.200
     1.169     5.901     0.200
     1.170     6.287     0.200
     1.170     6.617     0.200
     1.353     6.442     0.200
     1.331     6.929     0.200
     1.491     7.502     0.200
     1.503     7.396     0.200
     1.428     7.394     0.200
     1.487     7.186     0.200
     1.551     7.172     0.200
     1.574     7.107     0.200
     1.599     7.516     0.200
     1.690     7.163     0.200
     1.809     7.725     0.200
     1.897     8.292     0.200
     2.032     8.868     0.200
     2.032     9.598     0.200
     2.106     8.999     0.200
     2.270     9.964     0.200
     2.706     9.417     0.200
     2.757    11.216     0.200
     3.296    10.927     0.200
     3.257    11.615     0.200
     3.257    11.477     0.200
     3.650    13.850     0.200
     3.895    13.480     0.200
     4.451    14.425     0.200
     4.709    15.869     0.200
     4.798    16.909     0.200
     4.879    17.186     0.200
     5.038    15.000     0.200
     5.050    16.436     0.200
     5.267    17.329     0.200
     5.619    18.344     0.200
     5.653    15.039     0.200
     5.698    18.733     0.200
     6.985    19.752     0.200
     7.147    22.573     0.200
     7.566    23.227     0.200
     7.771    21.369     0.200
     7.906    22.067     0.200
     8.162    24.464     0.200
     8.167    23.645     0.200
     8.210    20.823     0.200
     1.083     6.503     0.200
     1.118     6.773     0.200
     1.113     6.677     0.200
     1.304     6.732     0.200
     1.493     7.450     0.200
     1.475     7.700     0.200
     1.401     6.557     0.200
     1.548     7.231     0.200
     1.634     7.413     0.200
     1.855     8.075     0.200
     1.983     9.607     0.200
     1.983     9.067     0.200
     2.041     9.279     0.200
     2.224     9.326     0.200
     2.649     9.447     0.200
     2.730    10.311     0.200
     3.240     9.472     0.200
     3.277    10.464     0.200
     3.609    13.538     0.200
     3.882    12.596     0.200
     4.204    13.274     0.200
     4.484    16.084     0.200
     4.776    15.846     0.200
     4.875    15.532     0.200
     5.235    17.625     0.200
     5.579    18.173     0.200
     5.661    19.063     0.200
     1.063     6.135     0.200
     1.063     6.365     0.200
     1.275     6.640     0.200
     1.528     8.113     0.200
     1.624     9.172     0.200
     1.624     8.832     0.200
     1.642     8.885     0.200
     2.061    10.358     0.200
     2.622    11.113     0.200
     2.720    11.101     0.200
     2.907    11.484     0.200
     2.930    13.088     0.200
     2.928    11.480     0.200
     3.151    12.039     0.200
     3.220    12.875     0.200
     3.245    13.400     0.200
     3.245    13.170     0.200
     3.341    12.896     0.200
     3.408    13.320     0.200
     3.614    14.044     0.200
     3.780    14.449     0.200
     3.780    14.098     0.200
     3.879    14.628     0.200
     4.172    15.623     0.200
     4.211    15.105     0.200
     4.211    14.808     0.200
     4.465    16.226     0.200
     4.680    16.450     0.200
     5.085    17.351     0.200
     5.100    18.386     0.200
     5.217    16.603     0.200
     5.856    19.947     0.200
     5.867    20.649     0.200
     5.856    19.878     0.200
     6.099    21.511     0.200
     6.190    17.057     0.200
     6.639    23.441     0.200
     6.668    22.420     0.200
     6.723    23.587     0.200
     6.726    22.611     0.200
     6.850    22.020     0.200
     7.162    24.217     0.200
     7.213    24.504     0.200
     7.206    23.126     0.200
     7.270    24.263     0.200
     7.441    23.623     0.200
     7.453    23.190     0.200
     7.306    23.993     0.200
     7.510    23.407     0.200
     7.551    25.192     0.200
     7.592    22.873     0.200
     7.687    23.076     0.200
     7.769    23.942     0.200
     7.864    24.638     0.200
     7.984    24.527     0.200
     8.123    21.834     0.200
     8.033    27.760     0.200
     8.245    23.386     0.200
     8.245    24.196     0.200
     8.245    23.655     0.200
     8.245    24.030     0.200
     8.255    22.439     0.200
     8.567    23.989     0.200
     8.644    23.413     0.200
     8.710    23.545     0.200
     8.995    27.650     0.200
     9.106    24.064     0.200
     9.199    24.725     0.200
     9.127    27.289     0.200
     9.151    26.713     0.200
     9.152    26.714     0.200
     9.152    24.464     0.200
     9.227    28.570     0.200
     9.376    24.643     0.200
     9.428    25.517     0.200
     9.455    26.475     0.200
     9.383    28.600     0.200
     9.479    24.661     0.200
     9.449    24.257     0.200
     9.940    26.092     0.200
     9.932    28.545     0.200
    10.215    29.851     0.200
    10.447    30.348     0.200
    10.884    30.142     0.200
    11.304    32.121     0.200
    12.722    35.408     0.200
    13.389    38.185     0.200
    13.389    33.336     0.200
    14.598    39.482     0.200
    14.773    37.419     0.200
    14.815    38.051     0.200
    15.118    36.947     0.200
    15.113    39.619     0.200
    15.896    40.745     0.200
    16.296    38.186     0.200
    16.554    40.744     0.200
    16.932    38.003     0.200
    17.134    37.808     0.200
    17.223    40.435     0.200
    18.026    40.697     0.200
    18.078    38.249     0.200
    18.098    40.491     0.200
    18.324    38.513     0.200
    19.440    41.465     0.200
    19.426    42.658     0.200
    19.662    40.645     0.200
    20.501    41.249     0.200
    20.531    40.859     0.200
     1.285     6.379     0.200
     1.579     7.212     0.200
     1.656     8.641     0.200
     1.658     8.589     0.200
     1.813     7.650     0.200
     2.095    10.256     0.200
     2.095     9.836     0.200
     2.340    10.508     0.200
     2.660    10.572     0.200
     2.921    11.528     0.200
     2.921    10.550     0.200
     2.958    11.272     0.200
     3.193    11.631     0.200
     3.269    10.542     0.200
     3.279    12.799     0.200
     3.445    13.193     0.200
     3.819    14.566     0.200
     3.929    14.123     0.200
     4.222    14.466     0.200
     4.253    14.689     0.200
     4.490    15.683     0.200
     4.717    16.261     0.200
     5.134    17.380     0.200
     5.901    19.050     0.200
     5.917    19.444     0.200
     6.149    20.799     0.200
     6.718    21.957     0.200
     7.267    24.132     0.200
     8.283    23.434     0.200
     8.695    25.337     0.200
     9.013    27.142     0.200
     9.158    26.885     0.200
     9.158    25.301     0.200
     9.244    28.480     0.200
     9.949    28.856     0.200
    10.300    27.519     0.200
    10.457    30.085     0.200
    10.934    31.096     0.200
    11.318    31.969     0.200
    13.440    36.810     0.200
     0.852     4.890     0.200
     1.288     7.537     0.200
     1.307     6.539     0.200
     1.456     7.988     0.200
     1.450     7.761     0.200
     1.592     8.151     0.200
     1.593     6.590     0.200
     1.877     7.679     0.200
     1.979     9.018     0.200
     2.036     8.977     0.200
     2.117     9.830     0.200
     2.316    10.353     0.200
     2.357     9.896     0.200
     2.494    10.207     0.200
     2.574    11.152     0.200
     2.590    10.277     0.200
     2.617    11.472     0.200
     3.212    11.206     0.200
     3.498    11.089     0.200
     3.733    12.682     0.200
     3.775    13.845     0.200
     3.951    13.701     0.200
     4.008    11.924     0.200
     3.971    13.937     0.200
     4.020    14.245     0.200
     4.149    14.709     0.200
     4.446    14.209     0.200
     4.665    15.683     0.200
     4.665    16.399     0.200
     4.762    15.008     0.200
     4.777    15.809     0.200
     4.898    15.918     0.200
     4.899    16.161     0.200
     5.121    18.936     0.200
     5.278    17.745     0.200
     5.467    17.752     0.200
     5.507    17.923     0.200
     5.548    19.486     0.200
     5.785    19.251     0.200
     5.980    16.409     0.200
     6.063    17.785     0.200
     6.412    18.371     0.200
     6.574    19.120     0.200
     6.767    21.411     0.200
     6.799    19.408     0.200
     6.920    20.598     0.200
     6.909    20.017     0.200
     7.005    21.182     0.200
     7.356    21.852     0.200
     7.443    21.078     0.200
     7.754    22.920     0.200
     7.806    23.553     0.200
     8.002    22.706     0.200
     8.065    22.868     0.200
     8.075    21.713     0.200
     8.079    24.508     0.200
     8.080    20.318     0.200
     8.104    23.127     0.200
     1.235     6.197     0.200
     1.256     8.562     0.200
     1.307     7.980     0.200
     1.317     9.710     0.200
     1.541     9.280     0.200
     7.513    26.387     0.200
     7.889    28.589     0.200
     9.360    26.637     0.200
     9.503    30.200     0.200
    12.461    36.361     0.200
     1.330     8.306     0.200
     1.330     8.408     0.200
     1.452     8.050     0.200
     1.515     6.796     0.200
     1.581     8.264     0.200
     1.878     9.420     0.200
     2.166    10.446     0.200
     2.084    10.882     0.200
     2.275     9.731     0.200
     2.179    11.248     0.200
     2.262    11.605     0.200
     3.047    12.036     0.200
     2.983    12.467     0.200
     3.137    12.472     0.200
     3.295    15.693     0.200
     3.538    14.500     0.200
     3.635    14.102     0.200
     3.936    15.839     0.200
     5.299    18.688     0.200
     6.053    17.828     0.200
     1.109     7.236     0.200
     1.088     5.644     0.200
     1.225     6.603     0.200
     1.371     7.195     0.200
     1.376     6.908     0.200
     1.439     7.265     0.200
     1.636     7.067     0.200
     2.089     8.233     0.200
     2.192    10.184     0.200
     2.352    10.128     0.200
     2.552    10.535     0.200
     2.544     9.449     0.200
     2.601    10.902     0.200
     2.619    10.427     0.200
     2.686    10.574     0.200
     3.126    10.280     0.200
     3.244    10.244     0.200
     3.698    12.856     0.200
     4.595    13.231     0.200
     0.975     6.049     0.200
     0.981     6.508     0.200
     0.997     6.167     0.200
     1.229     8.292     0.200
     1.456     8.634     0.200
     1.468     8.163     0.200
     1.605     9.880     0.200
     1.587     9.185     0.200
     1.649     8.198     0.200
     1.658     7.780     0.200
     1.771    10.595     0.200
     1.818     9.409     0.200
     1.851    10.789     0.200
     1.902     9.179     0.200
     1.948    11.291     0.200
     1.983     9.495     0.200
     2.291    10.633     0.200
     2.339    10.810     0.200
     2.348    10.713     0.200
     2.348    10.506     0.200
     2.573    11.700     0.200
     2.573    11.387     0.200
     2.651    11.009     0.200
     2.804    11.849     0.200
     2.939    12.415     0.200
     3.022    12.485     0.200
     3.082    12.911     0.200
     3.184    13.376     0.200
     3.217    12.605     0.200
     3.276    13.701     0.200
     3.280    12.774     0.200
     3.280    10.914     0.200
     3.370    14.541     0.200
     3.348    14.244     0.200
     3.348    13.553     0.200
     3.378    13.003     0.200
     3.425    14.335     0.200
     3.926    14.413     0.200
     3.937    15.446     0.200
     4.037    14.369     0.200
     4.114    16.946     0.200
     4.977    17.226     0.200
     5.256    19.174     0.200
     5.730    19.221     0.200
     5.822    20.957     0.200
     6.292    21.451     0.200
     7.608    23.071     0.200
     7.710    24.524     0.200
     7.710    24.384     0.200
     7.934    24.102     0.200
     8.165    24.922     0.200
     8.310    28.629     0.200
     8.627    26.538     0.200
     9.122    27.347     0.200
     9.253    26.783     0.200
     9.253    27.525     0.200
     9.943    31.072     0.200
    10.042    29.078     0.200
    10.167    29.600     0.200
    10.415    30.366     0.200
    10.473    29.940     0.200
    11.081    32.198     0.200
    11.288    31.858     0.200
    12.493    38.338     0.200
    13.556    36.935     0.200
    14.291    37.878     0.200
    15.046    38.820     0.200
    15.501    37.982     0.200
    15.526    39.456     0.200
    18.900    42.254     0.200
     1.013     6.238     0.200
     1.003     6.436     0.200
     1.272     6.924     0.200
     1.464     9.195     0.200
     1.498     8.444     0.200
     1.535     8.443     0.200
     1.553     8.847     0.200
     1.646     8.861     0.200
     1.702     8.545     0.200
     1.700     8.922     0.200
     1.780     9.003     0.200
     1.787     9.295     0.200
     1.806    11.131     0.200
     1.844     9.771     0.200
     1.893    10.820     0.200
     1.893     9.199     0.200
     1.939     9.646     0.200
     2.020     9.476     0.200
     2.334    10.651     0.200
     2.380    11.156     0.200
     2.380    11.730     0.200
     2.609    11.770     0.200
     2.609    11.969     0.200
     2.609    12.110     0.200
     2.688    11.621     0.200
     2.842    12.103     0.200
     2.980    12.453     0.200
     3.065    12.839     0.200
     3.123    14.069     0.200
     3.223    14.612     0.200
     3.254    13.486     0.200
     3.287    13.537     0.200
     3.287    12.217     0.200
     3.287    13.096     0.200
     3.311    13.721     0.200
     3.315    13.733     0.200
     3.412    14.151     0.200
     3.420    15.892     0.200
     3.468    14.513     0.200
     4.019    14.456     0.200
     4.019    14.706     0.200
     5.287    19.558     0.200
     5.737    20.888     0.200
     6.329    22.064     0.200
     6.879    21.966     0.200
     7.600    23.323     0.200
     7.600    21.831     0.200
     7.721    23.222     0.200
     7.721    25.574     0.200
     7.721    24.695     0.200
     7.921    24.932     0.200
     8.689    29.039     0.200
     8.876    27.302     0.200
     9.234    27.355     0.200
     9.234    27.187     0.200
     9.466    31.680     0.200
     9.985    28.065     0.200
    10.036    31.559     0.200
    10.142    31.950     0.200
    10.305    31.449     0.200
    10.458    30.403     0.200
    10.521    32.336     0.200
    11.015    34.614     0.200
    11.230    33.025     0.200
    12.169    37.191     0.200
    12.529    33.353     0.200
    12.766    37.995     0.200
    13.557    36.669     0.200
    13.557    36.872     0.200
    15.555    40.105     0.200
    15.655    40.452     0.200
    15.871    40.682     0.200
     0.765     4.251     0.200
     0.777     4.736     0.200
     0.935     4.798     0.200
     0.970     5.194     0.200
     1.030     5.212     0.200
     1.029     5.719     0.200
     1.117     6.169     0.200
     1.194     6.414     0.200
     1.210     6.083     0.200
     1.210     5.902     0.200
     1.217     5.261     0.200
     1.265     5.994     0.200
     1.274     6.260     0.200
     1.279     7.104     0.200
     1.337     6.280     0.200
     1.351     6.368     0.200
     1.382     9.004     0.200
     1.388     6.753     0.200
     1.394     6.341     0.200
     1.471     7.119     0.200
     1.485     6.492     0.200
     1.515     7.754     0.200
     1.531     6.432     0.200
     1.574     8.199     0.200
     1.608     6.684     0.200
     1.632     5.764     0.200
     1.800     8.019     0.200
     1.845     7.971     0.200
     1.895     8.202     0.200
     1.946     7.927     0.200
     2.000     7.286     0.200
     2.050     8.187     0.200
     2.067     8.821     0.200
     2.081     7.617     0.200
     2.110     8.583     0.200
     2.253     8.592     0.200
     2.230     7.841     0.200
     2.272     9.481     0.200
     2.326     8.612     0.200
     2.407     8.811     0.200
     2.470     9.187     0.200
     2.491     8.379     0.200
     2.506     9.280     0.200
     2.506     8.601     0.200
     2.521     9.602     0.200
     2.535     9.119     0.200
     2.607    10.531     0.200
     2.859    10.153     0.200
     3.030    11.084     0.200
     3.114    10.155     0.200
     3.228    13.341     0.200
     3.232    11.191     0.200
     3.270    11.376     0.200
     3.270    11.195     0.200
     3.458    12.500     0.200
     3.615    11.921     0.200
     3.680    11.268     0.200
     3.743    14.621     0.200
     3.785    13.722     0.200
     3.933    11.912     0.200
     3.935    12.389     0.200
     4.095    12.820     0.200
     4.095    13.119     0.200
     4.491    14.363     0.200
     4.519    14.961     0.200
     4.556    13.666     0.200
     4.662    16.127     0.200
     4.791    17.939     0.200
     4.802    16.031     0.200
     4.946    15.508     0.200
     5.801    18.511     0.200
     7.401    21.442     0.200
     7.401    21.282     0.200
     7.450    23.832     0.200
     7.450    23.362     0.200
     7.525    22.736     0.200
     7.525    22.192     0.200
     7.525    23.992     0.200
     7.823    22.463     0.200
     7.823    21.692     0.200
     7.823    22.633     0.200
     8.249    24.147     0.200
     8.432    26.850     0.200
     8.432    21.636     0.200
     8.616    27.580     0.200
     8.682    24.595     0.200
     9.032    28.316     0.200
     9.032    25.946     0.200
     9.089    24.507     0.200
     9.089    26.207     0.200
     9.561    26.060     0.200
     9.684    26.672     0.200
     9.869    27.952     0.200
    10.196    29.097     0.200
    10.196    30.737     0.200
    10.432    25.740     0.200
    10.832    30.343     0.200
    10.881    31.791     0.200
    10.881    31.511     0.200
    11.216    33.066     0.200
    11.404    33.545     0.200
    11.761    31.656     0.200
    11.761    32.116     0.200
    11.864    34.800     0.200
    11.969    34.657     0.200
    12.227    32.158     0.200
    12.302    32.456     0.200
    12.445    33.969     0.200
    12.710    30.715     0.200
    13.320    33.740     0.200
    13.562    34.544     0.200
    13.562    37.444     0.200
    13.868    34.603     0.200
    13.868    34.203     0.200
    13.868    39.253     0.200
    13.880    31.954     0.200
    14.042    33.241     0.200
    14.555    35.816     0.200
    14.553    34.576     0.200
    14.848    33.198     0.200
    14.908    37.282     0.200
    14.927    37.353     0.200
    15.138    39.716     0.200
    15.575    36.107     0.200
    15.596    35.289     0.200
    15.610    35.181     0.200
    15.855    35.707     0.200
    16.089    39.753     0.200
    16.127    36.246     0.200
    16.185    39.273     0.200
    16.749    34.932     0.200
    16.953    39.210     0.200
    17.595    37.768     0.200
    17.953    37.424     0.200
    17.954    37.419     0.200
    17.948    38.263     0.200
    18.245    37.340     0.200
    18.272    38.229     0.200
    18.305    38.704     0.200
    18.467    41.507     0.200
    18.491    41.354     0.200
    18.573    42.285     0.200
    18.584    42.692     0.200
    18.620    41.093     0.200
    18.671    40.975     0.200
    18.722    40.785     0.200
    19.092    41.604     0.200
    19.123    42.919     0.200
    19.142    40.575     0.200
    19.143    41.121     0.200
    19.189    41.478     0.200
    19.506    39.918     0.200
    20.186    42.052     0.200
    20.186    39.813     0.200
    20.222    41.180     0.200
    20.383    40.476     0.200
    20.385    40.164     0.200
    20.496    40.564     0.200
    20.812    40.766     0.200
    20.932    40.468     0.200
     1.019     5.857     0.200
     1.882     8.732     0.200
     1.929     8.838     0.200
     1.719     7.314     0.200
     1.805     8.438     0.200
     1.805     8.024     0.200
     2.077     9.632     0.200
     2.639    10.220     0.200
     2.739    10.420     0.200
     2.921    13.099     0.200
     2.921     8.325     0.200
     2.926    11.267     0.200
     2.945    11.339     0.200
     3.036    11.935     0.200
     3.240    10.701     0.200
     3.629    12.418     0.200
     3.912    14.640     0.200
     4.229    12.350     0.200
     4.229    13.010     0.200
     4.697    14.675     0.200
     5.472    15.571     0.200
     6.444    19.494     0.200
     6.742    21.080     0.200
     7.181    20.314     0.200
     7.232    19.120     0.200
     7.267    19.678     0.200
     7.611    22.476     0.200
     7.707    22.587     0.200
     8.257    22.566     0.200
     9.030    27.233     0.200
     9.128    26.560     0.200
     9.150    25.066     0.200
     9.150    27.144     0.200
     9.175    25.402     0.200
     9.217    24.771     0.200
     9.373    26.275     0.200
     9.472    26.736     0.200
     9.935    29.527     0.200
    10.268    27.398     0.200
    10.725    28.748     0.200
    10.881    31.616     0.200
    10.903    34.258     0.200
    10.903    26.297     0.200
    11.015    26.928     0.200
    11.209    28.741     0.200
    11.306    32.447     0.200
    11.916    30.801     0.200
    12.442    34.713     0.200
    13.119    30.799     0.200
    13.143    35.063     0.200
    13.364    34.532     0.200
    13.408    34.963     0.200
    13.602    32.682     0.200
    13.685    34.162     0.200
    13.861    34.618     0.200
    13.904    35.111     0.200
    13.984    34.184     0.200
    14.024    34.180     0.200
    13.978    33.328     0.200
    14.269    37.770     0.200
    14.349    36.440     0.200
    14.497    36.760     0.200
    14.605    36.919     0.200
    14.636    35.200     0.200
    14.792    36.185     0.200
    14.820    36.596     0.200
    14.825    35.764     0.200
    14.984    35.749     0.200
    15.004    36.666     0.200
    15.120    37.524     0.200
    15.090    35.065     0.200
    15.237    38.170     0.200
    15.479    36.589     0.200
    15.433    37.312     0.200
    15.532    37.966     0.200
    15.724    38.330     0.200
    15.897    38.037     0.200
    17.038    39.277     0.200
    17.260    39.555     0.200
    18.527    42.318     0.200
    18.981    42.081     0.200
    19.959    40.831     0.200
     1.038     7.506     0.200
     1.189     7.310     0.200
     1.323     8.396     0.200
     1.410     7.968     0.200
     1.364     7.733     0.200
     1.483     8.530     0.200
     1.538     7.463     0.200
     1.579     8.132     0.200
     1.721     7.973     0.200
     1.964     9.092     0.200
     2.087    10.006     0.200
     2.256    10.146     0.200
     2.236     9.636     0.200
     2.317     9.911     0.200
     2.448    10.269     0.200
     2.724    11.097     0.200
     2.714    10.916     0.200
     2.691    11.162     0.200
     2.826    11.685     0.200
     3.174    12.474     0.200
     3.605    13.425     0.200
     3.818    14.423     0.200
     4.727    16.650     0.200
     4.798    16.864     0.200
     5.032    15.590     0.200
     5.208    17.851     0.200
     5.570    17.393     0.200
     5.638    15.913     0.200
     5.645    16.838     0.200
     6.086    19.728     0.200
     6.165    20.489     0.200
     1.466     7.409     0.200
     2.005     9.408     0.200
     1.581     9.188     0.200
     1.583    10.703     0.200
     1.640     8.496     0.200
     1.696    10.571     0.200
     1.861     9.498     0.200
     1.886     9.285     0.200
     1.919     9.381     0.200
     1.919     9.181     0.200
     2.021     8.802     0.200
     2.021     8.112     0.200
     2.338    10.988     0.200
     2.593    11.539     0.200
     2.665    10.873     0.200
     2.665    11.573     0.200
     2.789    13.887     0.200
     2.711    13.946     0.200
     2.962    11.987     0.200
     3.055    12.399     0.200
     3.210    12.893     0.200
     3.209    13.510     0.200
     3.406    12.637     0.200
     3.428    12.703     0.200
     3.519    13.100     0.200
     3.726    13.643     0.200
     3.726    14.313     0.200
     3.799    14.424     0.200
     3.890    15.126     0.200
     4.067    14.777     0.200
     4.154    15.652     0.200
     4.152    16.261     0.200
     4.189    15.229     0.200
     4.288    15.132     0.200
     4.318    14.532     0.200
     4.464    15.439     0.200
     4.464    18.534     0.200
     4.464    19.180     0.200
     4.499    16.281     0.200
     4.542    16.166     0.200
     4.640    16.374     0.200
     5.006    17.853     0.200
     5.140    18.404     0.200
     5.177    20.468     0.200
     5.428    19.501     0.200
     5.530    19.182     0.200
     5.848    18.609     0.200
     5.860    19.170     0.200
     5.951    19.299     0.200
     6.173    22.237     0.200
     6.173    19.637     0.200
     6.436    21.759     0.200
     6.582    20.919     0.200
     6.688    20.745     0.200
     6.838    22.001     0.200
     7.081    21.829     0.200
     7.252    22.748     0.200
     7.307    22.278     0.200
     7.486    22.690     0.200
     7.573    22.283     0.200
     7.598    23.332     0.200
     7.598    24.587     0.200
     7.764    24.455     0.200
     7.764    25.488     0.200
     7.786    24.382     0.200
     8.181    25.063     0.200
     8.181    23.802     0.200
     8.181    25.432     0.200
     8.327    25.800     0.200
     8.361    24.315     0.200
     8.737    25.082     0.200
     8.737    28.422     0.200
     8.832    25.499     0.200
     8.919    26.301     0.200
     8.923    26.452     0.200
     8.923    27.026     0.200
     8.923    26.264     0.200
     9.435    30.496     0.200
     9.461    25.981     0.200
    10.373    29.250     0.200
    10.502    29.137     0.200
    10.502    32.947     0.200
    10.634    30.094     0.200
    11.068    31.937     0.200
    11.068    34.917     0.200
    12.025    36.053     0.200
    12.150    34.072     0.200
    12.290    35.022     0.200
    13.226    36.965     0.200
    13.263    38.816     0.200
    13.493    34.144     0.200
    13.493    36.235     0.200
    13.493    34.763     0.200
    13.836    40.006     0.200
    13.961    38.686     0.200
    14.456    36.583     0.200
    14.979    37.894     0.200
    15.117    38.929     0.200
    15.139    39.833     0.200
    15.170    40.016     0.200
    15.247    39.302     0.200
    15.283    40.112     0.200
    15.334    37.451     0.200
    15.358    39.245     0.200
    15.444    38.289     0.200
    15.579    40.225     0.200
    15.685    39.211     0.200
    15.685    40.324     0.200
    16.001    39.402     0.200
    16.204    40.987     0.200
    16.388    40.040     0.200
    16.388    41.164     0.200
    16.424    40.213     0.200
    16.518    40.220     0.200
    17.048    40.674     0.200
    17.666    39.900     0.200
    18.125    40.130     0.200
    18.335    41.067     0.200
    18.466    40.987     0.200
    18.697    43.140     0.200
    18.697    44.793     0.200
    19.642    43.255     0.200
    20.958    45.502     0.200
     1.351     7.648     0.200
     1.757     7.373     0.200
     1.783     8.875     0.200
     1.991    10.321     0.200
     2.029    10.509     0.200
     2.771    10.693     0.200
     3.289    13.427     0.200
     3.398    13.284     0.200
     3.539    12.850     0.200
     3.878    12.764     0.200
     5.160    18.113     0.200
     5.823    18.852     0.200
     1.127     5.870     0.200
     1.164     5.640     0.200
     1.164     5.850     0.200
     1.687     8.224     0.200
     2.100    10.064     0.200
     3.218    12.085     0.200
     3.469    11.573     0.200
     1.749     8.229     0.200
     1.775     8.669     0.200
     2.626     9.383     0.200
     2.779     8.029     0.200
     3.371    12.892     0.200
     5.831    18.364     0.200
     1.002     6.588     0.200
     1.050     6.071     0.200
     1.077     6.327     0.200
     1.221     7.466     0.200
     1.216     8.872     0.200
     1.358     7.210     0.200
     1.341     7.538     0.200
     1.387     6.856     0.200
     1.595     8.428     0.200
     1.593     7.436     0.200
     1.749     6.881     0.200
     2.118     8.600     0.200
     2.174     7.637     0.200
     2.245     9.634     0.200
     2.286     9.216     0.200
     2.646     9.906     0.200
     2.683    10.992     0.200
     2.727    10.377     0.200
     2.749    12.014     0.200
     2.847    11.288     0.200
     2.938    10.889     0.200
     3.357    12.548     0.200
     3.548    11.650     0.200
     3.608    13.604     0.200
     3.804    12.638     0.200
     3.803    12.669     0.200
     4.357    14.275     0.200
     4.529    14.652     0.200
     4.716    15.837     0.200
     5.032    16.734     0.200
     5.204    17.849     0.200
     5.572    18.296     0.200
     5.678    16.529     0.200
     5.645    19.013     0.200
     5.741    18.461     0.200
     5.871    19.194     0.200
     5.916    19.575     0.200
     5.958    18.674     0.200
     8.084    23.612     0.200
     1.470     8.023     0.200
     1.612     8.504     0.200
     1.668     8.837     0.200
     1.714     8.924     0.200
     1.714     8.784     0.200
     1.726     9.009     0.200
     1.783     8.034     0.200
     2.532    10.577     0.200
     2.623    10.837     0.200
     3.282    11.272     0.200
     3.431    13.841     0.200
     3.687    14.453     0.200
     4.225    14.128     0.200
     8.151    24.768     0.200
     9.058    26.207     0.200
    13.332    37.028     0.200
     1.721     8.313     0.200
     2.570    11.191     0.200
     3.230    12.700     0.200
     3.323    14.504     0.200
     0.951     6.379     0.200
     1.026     6.206     0.200
     1.026     6.366     0.200
     1.471     8.502     0.200
     1.191     6.595     0.200
     1.191     8.025     0.200
     1.573    10.202     0.200
     1.559     9.799     0.200
     2.665    11.127     0.200
     1.500     8.266     0.200
     1.500     7.708     0.200
     1.523     9.667     0.200
     1.843     8.499     0.200
     1.910     7.524     0.200
     2.627    11.489     0.200
     2.705    12.986     0.200
     3.250    11.840     0.200
     1.094     6.325     0.200
     1.526     8.208     0.200
     1.579     8.473     0.200
     1.563     8.490     0.200
     1.656     9.103     0.200
     1.913     8.560     0.200
     1.913     9.157     0.200
     1.969    10.540     0.200
     1.887    10.978     0.200
     2.056     9.330     0.200
     2.395    10.194     0.200
     2.461    10.670     0.200
     2.691    11.555     0.200
     2.691    12.476     0.200
     2.769    11.180     0.200
     2.923    11.528     0.200
     3.034    12.528     0.200
     3.132    12.072     0.200
     3.233    15.876     0.200
     3.233    13.907     0.200
     3.251    12.631     0.200
     3.251    13.092     0.200
     3.304    12.560     0.200
     3.336    13.389     0.200
     3.487    13.140     0.200
     3.496    12.674     0.200
     3.496    14.565     0.200
     3.529    12.957     0.200
     3.545    13.380     0.200
     3.630    14.524     0.200
     3.632    14.339     0.200
     3.936    13.679     0.200
     3.927    14.479     0.200
     3.949    14.069     0.200
     4.046    14.583     0.200
     4.043    14.768     0.200
     3.995    17.957     0.200
     4.051    15.239     0.200
     4.198    15.358     0.200
     4.316    16.215     0.200
     4.364    15.803     0.200
     4.475    17.166     0.200
     4.607    17.168     0.200
     4.823    17.613     0.200
     4.861    17.632     0.200
     4.895    17.012     0.200
     4.957    17.950     0.200
     4.993    17.561     0.200
     5.168    17.587     0.200
     5.201    19.049     0.200
     5.300    18.969     0.200
     5.306    16.296     0.200
     5.397    18.282     0.200
     5.506    18.920     0.200
     5.690    19.126     0.200
     5.813    18.985     0.200
     5.827    19.390     0.200
     5.853    19.234     0.200
     6.363    19.045     0.200
     7.542    22.715     0.200
     7.714    23.968     0.200
     7.693    24.187     0.200
     7.693    23.581     0.200
     7.857    24.149     0.200
     8.423    29.054     0.200
     8.913    24.674     0.200
     8.938    25.590     0.200
     9.162    27.132     0.200
     9.162    26.754     0.200
     9.568    28.470     0.200
     9.979    29.763     0.200
    10.037    32.665     0.200
    10.159    29.116     0.200
    10.972    32.849     0.200
    11.167    32.261     0.200
    11.171    32.528     0.200
    11.251    32.346     0.200
    11.385    31.587     0.200
    12.556    37.710     0.200
    12.897    37.058     0.200
    12.981    38.910     0.200
    12.980    36.709     0.200
    13.171    37.232     0.200
    15.565    40.003     0.200
    16.079    39.106     0.200
    16.997    39.902     0.200
    19.284    43.489     0.200
    20.033    41.050     0.200
    20.209    41.300     0.200
     1.140     6.490     0.200
     1.231     7.334     0.200
     1.347     7.576     0.200
     1.480     7.428     0.200
     1.502     8.437     0.200
     1.586     8.627     0.200
     2.205    10.649     0.200
     2.269    10.854     0.200
     3.730    17.225     0.200
     4.231    17.225     0.200
     1.940     8.991     0.200
     2.002     9.553     0.200
     2.002     9.213     0.200
     2.015     9.388     0.200
     2.560    10.257     0.200
     3.570    13.218     0.200
     3.680    13.792     0.200
     2.568    11.912     0.200
     3.155    14.495     0.200
     3.581    11.361     0.200
     3.689    14.531     0.200
     3.690    12.203     0.200
     1.898     7.630     0.200
     1.898     9.005     0.200
     1.967     9.311     0.200
     1.971     8.403     0.200
     2.592     7.807     0.200
     3.503    11.381     0.200
     3.558    11.284     0.200
     1.545     8.778     0.200
     1.576     9.942     0.200
     1.782     9.812     0.200
     1.776    10.424     0.200
     1.951    10.201     0.200
     2.026     9.327     0.200
     2.013    10.597     0.200
     2.013     9.007     0.200
     2.549    11.698     0.200
     2.549     8.409     0.200
     2.788    12.809     0.200
     3.138    12.940     0.200
     3.138    12.530     0.200
     3.557    14.611     0.200
     3.670    15.299     0.200
     3.669    14.503     0.200
     3.952    16.340     0.200
     8.020    24.651     0.200
     8.781    25.125     0.200
    18.634    45.162     0.200
     1.434     8.736     0.200
     1.556     9.756     0.200
     1.574    10.231     0.200
     1.794    10.246     0.200
     1.783    10.526     0.200
     1.947     8.825     0.200
     1.947     9.466     0.200
     2.026     8.547     0.200
     2.004    10.014     0.200
     2.004     9.565     0.200
     2.317    10.717     0.200
     2.379    11.348     0.200
     2.560    11.413     0.200
     2.560    14.253     0.200
     2.560    10.253     0.200
     2.743    15.733     0.200
     2.981    13.362     0.200
     3.144    13.140     0.200
     3.412    15.266     0.200
     3.585    14.333     0.200
     3.554    14.650     0.200
     3.686    15.496     0.200
     3.681    13.984     0.200
     4.015    14.934     0.200
     4.171    16.125     0.200
     4.196    16.063     0.200
     4.213    16.471     0.200
     4.465    18.664     0.200
     4.465    15.562     0.200
     4.512    17.423     0.200
     4.860    18.001     0.200
     4.969    20.181     0.200
     5.024    17.447     0.200
     5.038    19.148     0.200
     5.039    18.568     0.200
     5.307    19.390     0.200
     5.336    18.734     0.200
     5.390    19.084     0.200
     5.730    20.350     0.200
     5.804    19.467     0.200
     6.064    20.311     0.200
     6.744    22.652     0.200
     7.227    21.831     0.200
     7.230    20.430     0.200
     7.261    23.907     0.200
     7.540    19.891     0.200
     7.454    23.334     0.200
     7.648    24.334     0.200
     7.685    24.744     0.200
     8.037    24.043     0.200
     8.037    24.230     0.200
     8.693    25.998     0.200
     8.797    27.185     0.200
     8.784    27.570     0.200
     8.794    26.834     0.200
     8.795    26.200     0.200
     8.795    28.012     0.200
     9.211    29.250     0.200
     9.135    30.488     0.200
     9.381    27.496     0.200
     9.417    26.375     0.200
     9.653    30.446     0.200
    11.009    29.663     0.200
    11.406    32.778     0.200
    11.437    32.593     0.200
    11.589    34.011     0.200
    11.936    35.072     0.200
    12.098    33.301     0.200
    12.219    34.765     0.200
    12.808    35.340     0.200
    12.998    37.809     0.200
    13.229    38.836     0.200
    13.393    34.714     0.200
    13.393    34.183     0.200
    13.712    40.111     0.200
    13.768    40.348     0.200
    13.766    37.268     0.200
    14.009    38.261     0.200
    14.070    40.155     0.200
    14.100    38.765     0.200
    14.270    38.490     0.200
    14.309    36.866     0.200
    14.655    38.074     0.200
    14.691    37.151     0.200
    14.807    37.628     0.200
    14.832    36.680     0.200
    14.847    37.736     0.200
    15.040    39.499     0.200
    15.108    38.413     0.200
    15.187    38.019     0.200
    15.522    38.898     0.200
    15.709    37.959     0.200
    15.979    40.170     0.200
    18.642    41.940     0.200
    18.642    43.374     0.200
    18.687    41.336     0.200
    20.289    41.349     0.200
     1.459     7.849     0.200
     1.552     7.780     0.200
     1.782     9.886     0.200
     1.918     9.485     0.200
     1.918     8.876     0.200
     1.971     9.547     0.200
     1.971     8.356     0.200
     3.175     9.499     0.200
     3.526    13.363     0.200
     3.717    11.955     0.200
     8.057    23.143     0.200
     8.828    26.302     0.200
     9.398    25.083     0.200
    10.999    29.868     0.200
    13.394    36.672     0.200
     0.893     5.694     0.200
     1.519     8.024     0.200
     1.760     8.822     0.200
     1.895     9.441     0.200
     1.895     9.571     0.200
     1.975     8.601     0.200
     1.957     9.789     0.200
     3.195    13.541     0.200
     3.502    14.370     0.200
     3.582    14.069     0.200
     3.723    15.335     0.200
     1.430     8.465     0.200
     1.742     9.497     0.200
     1.742     8.817     0.200
     2.273    10.386     0.200
     2.602     9.699     0.200
     2.602    11.121     0.200
     2.602    10.320     0.200
     2.850    12.988     0.200
     2.683    11.616     0.200
     2.924    11.967     0.200
     3.200    12.298     0.200
     3.349    12.309     0.200
     3.494    11.238     0.200
     3.564    13.929     0.200
     3.720    13.877     0.200
     3.763    12.448     0.200
     3.954    12.620     0.200
     4.151    13.966     0.200
     4.144    14.972     0.200
     4.441    14.462     0.200
     4.462    14.520     0.200
     4.477    15.705     0.200
     4.849    16.229     0.200
     4.982    16.571     0.200
     5.058    17.910     0.200
     5.249    16.392     0.200
     5.284    16.997     0.200
     5.367    17.465     0.200
     5.694    17.117     0.200
     5.697    17.856     0.200
     5.800    17.308     0.200
     6.004    17.817     0.200
     6.018    18.817     0.200
     7.094    19.419     0.200
     7.172    21.260     0.200
     7.207    20.913     0.200
     7.479    18.250     0.200
     7.464    20.211     0.200
     7.665    20.279     0.200
     7.711    26.429     0.200
     8.020    24.471     0.200
     8.020    22.475     0.200
     8.020    22.525     0.200
     8.020    22.295     0.200
    14.311    32.710     0.200
    15.186    34.010     0.200
    15.217    35.556     0.200
    15.246    34.807     0.200
    15.326    35.568     0.200
    15.428    35.759     0.200
    15.499    34.930     0.200
    15.519    36.175     0.200
    15.572    35.263     0.200
    15.978    34.793     0.200
    16.245    35.915     0.200
    16.384    38.110     0.200
     0.981     5.549     0.200
     1.468     7.633     0.200
     1.530     7.883     0.200
     1.630     7.762     0.200
     1.772     8.472     0.200
     1.772     8.922     0.200
     1.847     9.328     0.200
     1.884     9.307     0.200
     1.884     9.768     0.200
     1.940     9.361     0.200
     1.970     8.895     0.200
     2.316     9.749     0.200
     2.308    10.143     0.200
     2.622    10.010     0.200
     2.841    13.891     0.200
     2.682    13.086     0.200
     2.950    11.261     0.200
     3.208    11.967     0.200
     3.346    12.536     0.200
     3.493    12.322     0.200
     3.493    13.283     0.200
     3.603    13.428     0.200
     3.603    12.307     0.200
     3.743    13.345     0.200
     3.736    16.910     0.200
     3.765    12.670     0.200
     3.975    13.593     0.200
     4.153    13.327     0.200
     4.174    13.957     0.200
     4.211    15.424     0.200
     4.409    14.374     0.200
     4.480    14.610     0.200
     4.514    15.899     0.200
     4.887    18.079     0.200
     4.910    14.542     0.200
     5.017    16.522     0.200
     5.090    17.509     0.200
     5.275    16.002     0.200
     5.314    16.331     0.200
     5.406    18.665     0.200
     5.728    18.219     0.200
     5.735    18.580     0.200
     5.838    18.717     0.200
     6.035    17.486     0.200
     6.052    18.989     0.200
     6.586    21.441     0.200
     6.771    18.433     0.200
     7.132    21.698     0.200
     7.199    19.795     0.200
     7.236    20.167     0.200
     7.254    22.085     0.200
     7.480    19.826     0.200
     7.499    22.821     0.200
     7.633    21.116     0.200
     7.698    23.261     0.200
     7.731    21.538     0.200
     8.056    22.930     0.200
     8.058    23.591     0.200
     8.058    23.392     0.200
     8.058    23.622     0.200
     8.058    23.848     0.200
     8.229    24.508     0.200
     8.412    22.307     0.200
     8.456    25.867     0.200
     8.612    24.114     0.200
     8.716    25.374     0.200
     8.743    25.483     0.200
     8.716    22.791     0.200
     8.836    25.998     0.200
     8.851    25.754     0.200
     8.852    24.835     0.200
     9.087    25.804     0.200
     9.367    30.854     0.200
    10.152    29.647     0.200
    10.149    27.395     0.200
    10.225    26.635     0.200
    10.508    28.320     0.200
    10.724    28.251     0.200
    10.973    32.035     0.200
    11.017    30.992     0.200
    11.008    31.009     0.200
    11.395    29.797     0.200
    11.439    30.356     0.200
    11.511    30.667     0.200
    11.629    32.036     0.200
    12.150    32.873     0.200
    12.193    32.719     0.200
    12.283    31.014     0.200
    12.617    33.603     0.200
    12.857    34.910     0.200
    13.376    36.711     0.200
    13.376    32.890     0.200
    13.640    35.422     0.200
    13.735    32.944     0.200
    13.802    35.727     0.200
    14.137    36.188     0.200
    14.216    37.040     0.200
    14.247    34.051     0.200
    14.348    36.998     0.200
    14.388    35.603     0.200
    14.637    37.735     0.200
    14.732    37.297     0.200
    14.805    35.263     0.200
    14.869    38.108     0.200
    15.085    35.753     0.200
    15.113    35.493     0.200
    15.135    35.983     0.200
    15.159    35.941     0.200
    15.223    37.553     0.200
    15.254    38.903     0.200
    15.284    39.028     0.200
    15.268    35.564     0.200
    15.314    37.334     0.200
    15.349    35.589     0.200
    15.466    38.457     0.200
    15.508    39.099     0.200
    15.520    39.228     0.200
    15.536    38.387     0.200
    15.557    38.896     0.200
    15.556    37.071     0.200
    15.597    39.314     0.200
    15.686    38.093     0.200
    15.701    38.571     0.200
    15.745    38.717     0.200
    15.892    39.583     0.200
    16.016    39.549     0.200
    16.090    39.996     0.200
    16.097    36.877     0.200
    16.264    38.280     0.200
    16.313    38.867     0.200
    16.384    39.626     0.200
    16.701    40.171     0.200
    18.215    38.556     0.200
    18.292    39.173     0.200
    18.604    43.775     0.200
    18.941    41.010     0.200
    19.191    40.632     0.200
    19.998    40.377     0.200
    20.008    40.260     0.200
    20.261    40.464     0.200
    20.719    40.157     0.200
     1.388     8.117     0.200
     1.460     8.019     0.200
     1.699     9.207     0.200
     1.659    10.528     0.200
     1.835    10.927     0.200
     1.884     9.737     0.200
     1.946     7.611     0.200
     1.966    10.343     0.200
     1.966     9.538     0.200
     2.590    12.140     0.200
     2.590     9.101     0.200
     3.202    12.505     0.200
     3.485    13.116     0.200
     3.518    13.677     0.200
     3.671    16.142     0.200
     3.704    13.475     0.200
     5.027    17.777     0.200
     7.974    24.766     0.200
     8.797    26.391     0.200
     1.420     7.962     0.200
     1.485     7.710     0.200
     1.650    10.546     0.200
     1.726     8.004     0.200
     1.842    10.697     0.200
     1.849    10.792     0.200
     1.880     9.375     0.200
     1.952     8.090     0.200
     1.953     9.439     0.200
     3.207    13.156     0.200
     3.484    11.854     0.200
     3.551    14.215     0.200
     3.722    14.624     0.200
     4.389    19.194     0.200
     8.007    23.571     0.200
     8.821    25.686     0.200
     9.340    32.004     0.200
    10.934    33.549     0.200
     1.968    10.437     0.200
     1.975    10.058     0.200
     1.547     7.989     0.200
     1.784     9.470     0.200
     1.950     9.486     0.200
     1.950     9.744     0.200
     2.011    10.129     0.200
     2.551    12.722     0.200
     3.140    13.852     0.200
     3.571    13.539     0.200
     3.673    14.569     0.200
     2.634    12.393     0.200
     3.260    13.084     0.200
     3.424    13.887     0.200
     3.514    11.749     0.200
     3.744    14.283     0.200
     0.876     6.776     0.200
     1.492     8.455     0.200
     1.607     8.860     0.200
     1.727     9.041     0.200
     1.942     9.793     0.200
     1.942     9.636     0.200
     2.001     9.966     0.200
     2.022    10.969     0.200
     2.022    11.117     0.200
     2.534    12.518     0.200
     3.144    12.895     0.200
     3.144    12.669     0.200
     3.509    13.846     0.200
     3.650    14.223     0.200
     0.900     7.389     0.200
     1.897    10.107     0.200
     3.189    14.269     0.200
     3.685    15.513     0.200
     1.405     8.061     0.200
     1.473     7.768     0.200
     1.712     8.720     0.200
     1.959     9.656     0.200
     1.949     7.568     0.200
     2.597    12.652     0.200
     2.597     8.699     0.200
     2.867    13.241     0.200
     3.205    12.931     0.200
     3.205    13.243     0.200
     3.535    11.611     0.200
     3.685    14.177     0.200
     3.685    13.037     0.200
     3.712    14.730     0.200
     5.041    19.394     0.200
     0.529     5.664     0.200
     2.625    13.000     0.200
     2.625    12.613     0.200
     3.232    13.826     0.200
     3.459    16.021     0.200
     3.546    15.020     0.200
     3.709    15.661     0.200
     3.740    15.506     0.200
     1.901     9.417     0.200
     1.958     7.961     0.200
     2.568    12.199     0.200
     3.185    12.200     0.200
     3.499    13.360     0.200
     3.500    14.075     0.200
     3.590    14.276     0.200
     3.647    14.959     0.200
     3.681    13.806     0.200
     1.434     7.569     0.200
     1.512     7.580     0.200
     1.897     8.850     0.200
     1.974     8.875     0.200
     2.598    12.609     0.200
     3.503    13.540     0.200
     3.717    15.013     0.200
     1.369     8.096     0.200
     1.449     7.991     0.200
     1.686     8.777     0.200
     1.660    10.315     0.200
     1.892    10.192     0.200
     1.892     9.482     0.200
     2.576    12.770     0.200
     2.576    12.080     0.200
     3.195    13.946     0.200
     3.195    13.336     0.200
     3.490    12.212     0.200
     3.689    14.994     0.200
     5.009    17.902     0.200
     1.614     8.680     0.200
     1.797     9.926     0.200
     1.836    10.035     0.200
     1.924     9.856     0.200
     1.924     7.966     0.200
     1.990     7.766     0.200
     2.560    11.597     0.200
     2.560    11.716     0.200
     2.827    12.404     0.200
     2.827    11.154     0.200
     3.163    12.897     0.200
     3.163    11.617     0.200
     3.534    13.846     0.200
     3.660    14.905     0.200
     3.677    14.190     0.200
     3.977    15.690     0.200
     5.015    18.144     0.200
     7.988    23.300     0.200
     8.779    23.601     0.200
     1.410     7.988     0.200
     1.528     7.815     0.200
     1.592     9.055     0.200
     1.765     9.217     0.200
     1.808    10.145     0.200
     1.786     9.228     0.200
     1.938     9.273     0.200
     1.938     9.375     0.200
     2.010     7.425     0.200
     2.556    11.499     0.200
     2.556    10.703     0.200
     2.804    12.069     0.200
     2.804    11.429     0.200
     2.880    10.211     0.200
     3.150    12.952     0.200
     3.150     9.933     0.200
     3.557    13.477     0.200
     3.669    15.407     0.200
     3.675    13.730     0.200
     4.765    16.943     0.200
     8.009    24.033     0.200
     8.783    25.965     0.200
     1.003     5.898     0.200
     1.905     9.556     0.200
     3.226    14.238     0.200
     3.226    12.548     0.200
     3.699    15.389     0.200
     4.337    17.832     0.200
     7.916    24.044     0.200
     8.778    25.634     0.200
     9.276    28.862     0.200
    13.232    35.204     0.200
     1.372     8.727     0.200
     1.450     8.311     0.200
     1.688     9.335     0.200
     1.661     9.258     0.200
     1.889     9.415     0.200
     1.889    10.048     0.200
     1.828    10.616     0.200
     1.946     8.921     0.200
     1.886    11.058     0.200
     2.580    11.668     0.200
     3.197    12.663     0.200
     3.693    14.000     0.200
     4.010    15.562     0.200
     8.784    26.514     0.200
     9.324    29.359     0.200
     1.391     8.533     0.200
     1.452     7.706     0.200
     1.692     8.782     0.200
     1.692     9.762     0.200
     1.670    10.520     0.200
     1.874     8.783     0.200
     1.874    11.334     0.200
     1.935     9.777     0.200
     1.845    10.376     0.200
     1.882    11.629     0.200
     2.221    11.298     0.200
     2.303    12.240     0.200
     2.598    12.040     0.200
     2.598    11.657     0.200
     2.598    11.020     0.200
     2.662    15.363     0.200
     2.877    13.724     0.200
     2.882    13.611     0.200
     2.882    13.122     0.200
     2.882    14.630     0.200
     3.288    13.285     0.200
     3.212    14.522     0.200
     3.212    14.233     0.200
     3.320    13.749     0.200
     3.517    14.735     0.200
     3.712    15.064     0.200
     4.028    14.507     0.200
     4.094    16.125     0.200
     4.421    16.488     0.200
     4.426    17.157     0.200
     4.399    17.191     0.200
     4.805    16.153     0.200
     4.883    18.024     0.200
     4.931    17.330     0.200
     5.033    19.610     0.200
     5.202    20.262     0.200
     5.234    19.105     0.200
     5.319    19.586     0.200
     7.973    26.145     0.200
     8.804    27.859     0.200
    10.904    35.898     0.200
    16.351    39.112     0.200
     1.361     8.388     0.200
     1.653     8.787     0.200
     1.863     9.149     0.200
     1.863     9.358     0.200
     1.914     8.474     0.200
     2.182     9.885     0.200
     2.290     9.965     0.200
     2.597    10.421     0.200
     2.597    12.251     0.200
     2.647    12.930     0.200
     2.828    12.679     0.200
     2.839    11.839     0.200
     2.908    13.139     0.200
     2.908    14.370     0.200
     3.173    10.913     0.200
     3.224    12.087     0.200
     3.297    12.649     0.200
     3.480    12.101     0.200
     3.480    14.200     0.200
     3.548    15.063     0.200
     3.657    15.512     0.200
     3.722    13.353     0.200
     3.876    12.932     0.200
     4.055    14.382     0.200
     4.109    15.444     0.200
     4.110    13.880     0.200
     4.341    14.561     0.200
     4.347    14.350     0.200
     4.389    15.356     0.200
     4.387    15.498     0.200
     4.497    15.117     0.200
     4.790    15.942     0.200
     4.772    15.775     0.200
     4.863    16.104     0.200
     4.891    16.400     0.200
     5.014    18.260     0.200
     5.195    16.071     0.200
     5.283    16.545     0.200
     5.438    17.081     0.200
     5.608    18.105     0.200
     5.729    18.058     0.200
     5.915    17.722     0.200
     5.927    18.155     0.200
     6.603    19.576     0.200
     7.119    21.533     0.200
     7.136    20.108     0.200
     7.407    21.054     0.200
     7.546    22.443     0.200
     7.618    22.123     0.200
     7.709    21.205     0.200
     7.709    26.624     0.200
     7.938    24.038     0.200
     7.938    22.198     0.200
     8.662    24.089     0.200
     8.762    23.805     0.200
     8.790    24.224     0.200
     8.880    24.009     0.200
     9.289    29.211     0.200
    10.383    28.050     0.200
    13.094    35.013     0.200
    13.254    36.835     0.200
    13.880    34.275     0.200
    14.033    35.376     0.200
    14.246    34.171     0.200
    14.778    35.392     0.200
    15.150    34.754     0.200
    15.177    37.786     0.200
    16.207    39.816     0.200
    18.502    43.258     0.200
     1.357     8.324     0.200
     1.436     8.800     0.200
     1.674     9.330     0.200
     1.890    10.310     0.200
     1.942     9.370     0.200
     2.574    11.324     0.200
     2.880    14.124     0.200
     3.197    14.599     0.200
     3.197    13.897     0.200
     3.485    14.972     0.200
     3.576    15.094     0.200
     3.686    15.322     0.200
     4.010    16.039     0.200
     0.934     5.212     0.200
     1.062     6.889     0.200
     1.321     6.953     0.200
     1.320     7.075     0.200
     1.428     7.498     0.200
     1.590     8.128     0.200
     1.590     7.638     0.200
     1.516     7.490     0.200
     1.664     6.579     0.200
     2.099     7.513     0.200
     2.096     8.266     0.200
     2.204     8.712     0.200
     2.176     9.358     0.200
     2.253     9.468     0.200
     2.421     9.504     0.200
     2.651    10.430     0.200
     2.648    10.838     0.200
     2.762    11.347     0.200
     2.853    10.755     0.200
     3.182    11.566     0.200
     1.034     6.233     0.200
     1.113     7.141     0.200
     1.115     7.500     0.200
     1.165     6.084     0.200
     1.244     7.581     0.200
     1.244     7.521     0.200
     1.292     7.287     0.200
     1.314     7.583     0.200
     1.404     7.713     0.200
     1.459     7.727     0.200
     1.430     8.072     0.200
     1.501     8.078     0.200
     1.501     8.208     0.200
     1.595     8.285     0.200
     1.650     7.098     0.200
     1.748     9.142     0.200
     2.162     9.668     0.200
     2.192     9.363     0.200
     2.224    10.786     0.200
     2.238     9.968     0.200
     2.551    10.410     0.200
     2.635    11.089     0.200
     2.638    11.411     0.200
     2.747    11.346     0.200
     3.184    11.946     0.200
     1.361     7.560     0.200
     1.450     7.074     0.200
     1.687     8.309     0.200
     1.687     8.748     0.200
     1.654     8.508     0.200
     1.900     9.128     0.200
     1.900     9.240     0.200
     1.817     9.097     0.200
     1.954     7.803     0.200
     1.887    10.034     0.200
     1.988     9.491     0.200
     1.988     9.350     0.200
     2.209    10.257     0.200
     2.328    10.296     0.200
     2.567    10.664     0.200
     2.567    11.645     0.200
     2.567    10.366     0.200
     2.816    11.054     0.200
     2.686    13.868     0.200
     2.877    11.683     0.200
     2.867    12.949     0.200
     2.867    13.218     0.200
     3.186    12.739     0.200
     3.186    12.948     0.200
     3.297    12.859     0.200
     3.338    12.857     0.200
     3.493    13.163     0.200
     3.493    13.792     0.200
     3.762    13.141     0.200
     3.680    13.060     0.200
     3.916    13.298     0.200
     3.841    14.784     0.200
     4.039    14.212     0.200
     3.999    15.118     0.200
     4.089    14.404     0.200
     4.149    14.871     0.200
     4.107    15.177     0.200
     4.388    15.005     0.200
     4.430    15.209     0.200
     4.409    15.690     0.200
     4.383    16.027     0.200
     4.778    16.555     0.200
     4.827    16.901     0.200
     4.944    16.391     0.200
     4.918    16.643     0.200
     5.000    18.144     0.200
     5.203    16.926     0.200
     5.228    17.139     0.200
     5.296    17.336     0.200
     5.633    17.361     0.200
     5.628    17.664     0.200
     5.730    18.748     0.200
     5.947    18.044     0.200
     5.997    18.630     0.200
     5.956    17.534     0.200
     5.951    21.738     0.200
     6.485    19.524     0.200
     6.636    19.356     0.200
     6.712    17.832     0.200
     7.023    21.266     0.200
     7.121    20.460     0.200
     7.154    20.872     0.200
     7.144    21.148     0.200
     7.479    18.052     0.200
     7.399    21.520     0.200
     7.560    22.048     0.200
     7.585    22.353     0.200
     7.653    21.895     0.200
     7.605    22.661     0.200
     7.943    22.782     0.200
     7.946    22.406     0.200
     7.945    22.747     0.200
     7.948    24.545     0.200
     7.948    23.096     0.200
     7.948    22.756     0.200
     7.948    22.865     0.200
     8.747    25.296     0.200
     8.770    25.035     0.200
     8.771    26.376     0.200
     8.771    25.378     0.200
     9.505    25.963     0.200
    10.132    25.481     0.200
    12.060    28.547     0.200
    13.285    38.485     0.200
    15.117    38.212     0.200
    15.209    36.493     0.200
    15.148    36.630     0.200
    15.177    37.485     0.200
    15.207    38.138     0.200
    15.284    36.707     0.200
    15.431    37.376     0.200
    15.450    37.773     0.200
    15.515    37.805     0.200
    15.593    38.038     0.200
    15.639    38.259     0.200
    15.910    37.432     0.200
    16.207    39.306     0.200
    16.596    38.663     0.200
    17.448    39.365     0.200
     1.862     9.151     0.200
     1.914     7.027     0.200
     1.956     9.961     0.200
     2.598    12.345     0.200
     3.224    13.623     0.200
     3.708    13.569     0.200
     7.941    25.501     0.200
     8.792    26.801     0.200
     1.899     8.758     0.200
     3.240    13.688     0.200
     3.240    13.568     0.200
     3.487    13.221     0.200
     3.671    13.950     0.200
     3.723    14.577     0.200
     1.390     8.319     0.200
     1.494     7.746     0.200
     1.731     9.346     0.200
     1.620    10.854     0.200
     1.801    10.910     0.200
     1.920     9.819     0.200
     1.920     9.999     0.200
     1.842    11.225     0.200
     1.985     8.421     0.200
     1.995    10.199     0.200
     1.995    10.399     0.200
     2.254    10.979     0.200
     2.349    10.905     0.200
     2.563    12.316     0.200
     2.563    12.627     0.200
     2.851    12.914     0.200
     2.710    13.217     0.200
     2.920    12.443     0.200
     2.832    13.926     0.200
     3.167    13.886     0.200
     3.336    13.850     0.200
     3.369    13.343     0.200
     3.530    14.650     0.200
     3.530    12.961     0.200
     3.660    15.057     0.200
     3.788    14.292     0.200
     3.809    15.564     0.200
     3.957    15.003     0.200
     3.981    17.021     0.200
     4.134    16.412     0.200
     4.133    16.404     0.200
     4.420    15.881     0.200
     4.349    16.826     0.200
     4.452    16.922     0.200
     4.811    17.726     0.200
     4.962    18.577     0.200
     7.622    24.745     0.200
     7.985    23.098     0.200
     7.985    23.881     0.200
     8.667    25.931     0.200
     8.780    25.824     0.200
     9.366    31.078     0.200
    10.950    33.300     0.200
    13.330    35.754     0.200
    14.700    37.931     0.200
    16.235    36.655     0.200
    16.666    39.775     0.200
    18.583    43.597     0.200
     1.410     7.800     0.200
     1.530     6.734     0.200
     1.768     7.625     0.200
     1.784     8.802     0.200
     1.806    10.368     0.200
     1.941     8.431     0.200
     1.941     8.810     0.200
     2.007     8.641     0.200
     2.289     8.974     0.200
     2.372     9.683     0.200
     2.554    10.540     0.200
     2.554    10.758     0.200
     2.554     8.649     0.200
     2.802    12.186     0.200
     2.802    10.228     0.200
     2.883    10.795     0.200
     2.734    13.093     0.200
     2.935    12.440     0.200
     2.956    10.700     0.200
     3.148    13.169     0.200
     3.252    12.737     0.200
     3.370    12.861     0.200
     3.398    11.014     0.200
     3.558    12.804     0.200
     3.558    11.343     0.200
     3.558    13.192     0.200
     3.637    12.310     0.200
     3.668    13.480     0.200
     3.668    16.521     0.200
     3.673    13.985     0.200
     3.814    14.378     0.200
     3.992    14.671     0.200
     4.110    14.498     0.200
     4.170    14.400     0.200
     4.149    15.374     0.200
     4.202    15.591     0.200
     4.445    16.698     0.200
     4.450    15.508     0.200
     4.450    14.948     0.200
     4.450    16.598     0.200
     4.450    17.758     0.200
     4.484    15.394     0.200
     4.504    15.994     0.200
     4.548    16.764     0.200
     4.606    17.279     0.200
     4.834    17.669     0.200
     4.895    17.937     0.200
     4.958    18.480     0.200
     5.018    17.852     0.200
     5.780    18.710     0.200
     6.717    21.033     0.200
     7.434    23.170     0.200
     7.630    23.080     0.200
     7.662    25.896     0.200
     7.662    26.467     0.200
     8.010    23.735     0.200
     8.010    23.901     0.200
     8.583    26.729     0.200
     8.767    25.748     0.200
     8.782    25.815     0.200
     9.399    30.426     0.200
     9.624    29.166     0.200
    10.469    31.772     0.200
    10.986    33.691     0.200
    10.949    30.965     0.200
    11.113    33.876     0.200
    12.220    36.761     0.200
    13.109    38.445     0.200
    13.366    37.792     0.200
    13.366    37.460     0.200
    13.536    35.620     0.200
    13.574    35.476     0.200
    13.574    36.886     0.200
    13.992    36.310     0.200
    14.050    37.983     0.200
    14.287    38.495     0.200
    14.952    38.439     0.200
    15.000    38.066     0.200
    15.056    38.483     0.200
    15.081    38.353     0.200
    15.098    37.902     0.200
    15.111    38.709     0.200
    15.132    38.323     0.200
    15.156    38.358     0.200
    15.164    38.691     0.200
    15.193    39.370     0.200
    15.225    39.565     0.200
    15.286    38.197     0.200
    15.256    39.300     0.200
    15.362    39.124     0.200
    15.371    39.741     0.200
    15.458    39.229     0.200
    15.475    39.094     0.200
    15.498    39.313     0.200
    15.559    39.031     0.200
    15.534    35.896     0.200
    15.615    38.386     0.200
    15.628    39.674     0.200
    15.638    39.888     0.200
    15.643    39.664     0.200
    15.714    38.356     0.200
    15.686    39.541     0.200
    15.854    39.135     0.200
    15.831    39.922     0.200
    15.956    40.188     0.200
    15.999    39.140     0.200
    16.033    40.230     0.200
    16.239    40.229     0.200
    16.254    40.243     0.200
    16.338    39.841     0.200
    16.256    39.931     0.200
    16.700    39.746     0.200
    16.876    40.596     0.200
    17.001    40.313     0.200
    17.059    39.994     0.200
    17.171    40.352     0.200
    17.396    36.467     0.200
    18.619    43.561     0.200
    18.619    43.242     0.200
    18.687    42.019     0.200
    19.095    41.560     0.200
    19.266    40.700     0.200
    19.247    41.579     0.200
    19.307    41.190     0.200
    19.477    43.644     0.200
    19.588    41.058     0.200
    19.937    40.798     0.200
    20.041    40.863     0.200
    20.202    40.507     0.200
    20.363    42.794     0.200
    20.946    40.100     0.200
     1.377     7.605     0.200
     1.470     7.506     0.200
     1.707     8.325     0.200
     1.707     8.532     0.200
     1.641    10.918     0.200
     1.906     9.746     0.200
     1.906     8.367     0.200
     1.813     9.665     0.200
     1.966     8.027     0.200
     1.987     9.822     0.200
     1.866    11.014     0.200
     2.230    10.174     0.200
     2.334    10.333     0.200
     2.569    11.420     0.200
     2.569    12.459     0.200
     2.569    10.279     0.200
     2.830    12.006     0.200
     2.830    11.307     0.200
     2.694    12.830     0.200
     2.883    11.879     0.200
     2.896    11.850     0.200
     3.217    11.484     0.200
     3.313    13.172     0.200
     3.181    13.082     0.200
     3.181    12.606     0.200
     3.350    13.112     0.200
     3.512    14.138     0.200
     3.512    13.588     0.200
     3.655    13.534     0.200
     3.771    13.219     0.200
     3.683    13.925     0.200
     3.881    13.320     0.200
     3.933    15.524     0.200
     4.055    14.538     0.200
     4.109    15.510     0.200
     3.994    15.390     0.200
     4.158    14.845     0.200
     4.122    15.853     0.200
     4.400    15.384     0.200
     4.400    15.497     0.200
     4.430    16.281     0.200
     4.446    15.828     0.200
     4.370    16.092     0.200
     4.796    16.928     0.200
     4.844    16.132     0.200
     4.939    17.362     0.200
     4.961    17.522     0.200
     4.814    16.740     0.200
     5.010    18.025     0.200
     5.222    18.715     0.200
     5.249    18.693     0.200
     5.316    18.819     0.200
     5.654    19.601     0.200
     5.649    19.124     0.200
     5.608    17.715     0.200
     5.747    19.226     0.200
     5.616    18.316     0.200
     5.968    20.646     0.200
     5.977    20.584     0.200
     6.011    20.357     0.200
     6.657    22.178     0.200
     6.730    21.619     0.200
     7.041    21.907     0.200
     7.141    22.983     0.200
     7.174    23.541     0.200
     7.163    22.575     0.200
     7.488    19.350     0.200
     7.413    23.048     0.200
     7.579    23.028     0.200
     7.603    22.286     0.200
     7.673    23.259     0.200
     7.616    23.173     0.200
     7.730    23.970     0.200
     7.679    22.939     0.200
     7.967    24.472     0.200
     7.967    23.808     0.200
     7.967    23.698     0.200
     8.661    25.192     0.200
     8.757    25.931     0.200
     8.778    26.567     0.200
     8.779    26.265     0.200
     8.779    25.390     0.200
     9.345    30.159     0.200
     9.415    27.021     0.200
     9.509    27.799     0.200
     9.567    28.594     0.200
    10.153    30.160     0.200
    10.075    28.677     0.200
    10.926    31.274     0.200
    10.936    30.759     0.200
    11.303    31.408     0.200
    11.824    32.549     0.200
    12.071    32.690     0.200
    12.105    31.276     0.200
    12.570    31.386     0.200
    13.306    36.349     0.200
    14.644    37.087     0.200
    14.779    36.799     0.200
    15.042    37.453     0.200
    15.071    37.434     0.200
    15.133    38.570     0.200
    15.655    38.736     0.200
    15.802    38.180     0.200
    15.926    38.431     0.200
    16.223    39.322     0.200
    16.295    39.727     0.200
    16.333    38.527     0.200
    16.612    39.086     0.200
    18.559    43.463     0.200
     1.354     7.751     0.200
     1.432     7.249     0.200
     1.670     8.411     0.200
     1.670    10.061     0.200
     1.888     9.137     0.200
     1.828    11.133     0.200
     1.939     8.980     0.200
     1.904    10.526     0.200
     1.981     9.441     0.200
     2.574    12.376     0.200
     3.198    12.313     0.200
     3.642    14.167     0.200
     3.685    14.048     0.200
     4.011    16.625     0.200
     4.843    17.024     0.200
     7.938    24.355     0.200
     8.772    25.270     0.200
     1.590     8.542     0.200
     1.835     9.490     0.200
     1.893     9.949     0.200
     1.893    10.089     0.200
     1.928     9.448     0.200
     1.998     8.709     0.200
     3.670    14.608     0.200
     3.785    16.447     0.200
     3.769    15.382     0.200
     1.490     9.237     0.200
     1.564     9.024     0.200
     1.807     9.822     0.200
     1.769    10.735     0.200
     1.902    10.249     0.200
     1.902    10.749     0.200
     1.948    10.567     0.200
     1.948     9.825     0.200
     1.995     9.075     0.200
     2.619    13.042     0.200
     3.194    14.219     0.200
     3.194    15.661     0.200
     3.632    13.906     0.200
     3.749    15.148     0.200
     3.742    15.467     0.200
     3.795    15.738     0.200
     1.555     8.669     0.200
     1.622     8.329     0.200
     1.867     9.135     0.200
     1.906     9.768     0.200
     1.906     9.987     0.200
     1.931     9.352     0.200
     1.931     9.688     0.200
     2.018     8.465     0.200
     2.648    13.287     0.200
     3.200    14.798     0.200
     3.200    15.477     0.200
     3.700    14.295     0.200
     3.775    14.937     0.200
     3.802    14.977     0.200
     3.802    17.305     0.200
     4.750    19.759     0.200
     5.153    19.027     0.200
     8.154    25.247     0.200
     8.902    27.801     0.200
     9.429    31.477     0.200
    13.473    40.286     0.200
     1.701     8.159     0.200
     1.900     9.006     0.200
     1.959     8.135     0.200
     1.983     9.484     0.200
     2.573    10.875     0.200
     2.860    13.951     0.200
     3.186    12.082     0.200
     3.509    11.507     0.200
     3.656    11.665     0.200
     3.687    13.656     0.200
     5.012    15.761     0.200
     7.964    23.907     0.200
     8.781    25.887     0.200
    10.919    33.903     0.200
    13.300    38.938     0.200
     1.413     7.448     0.200
     1.519     6.370     0.200
     1.758     7.302     0.200
     1.926     8.160     0.200
     1.993     9.556     0.200
     1.993     8.665     0.200
     1.998     6.715     0.200
     2.281     8.986     0.200
     2.356     8.860     0.200
     2.567    10.333     0.200
     2.567     9.231     0.200
     2.868    11.034     0.200
     2.719    11.833     0.200
     2.945    11.228     0.200
     3.163    11.309     0.200
     3.356    11.769     0.200
     3.383    12.129     0.200
     3.557    13.196     0.200
     3.557    12.625     0.200
     3.686    13.690     0.200
     3.799    11.511     0.200
     3.979    13.538     0.200
     4.096    13.869     0.200
     4.160    14.345     0.200
     4.187    13.882     0.200
     4.154    15.026     0.200
     4.435    15.033     0.200
     4.490    15.213     0.200
     4.479    15.822     0.200
     4.533    14.094     0.200
     4.836    16.842     0.200
     4.989    16.501     0.200
     5.031    17.464     0.200
     5.271    15.772     0.200
     5.299    17.945     0.200
     5.361    17.976     0.200
     5.595    19.642     0.200
     5.705    18.341     0.200
     5.697    18.231     0.200
     5.783    18.424     0.200
     5.919    22.609     0.200
     6.028    19.715     0.200
     7.082    21.700     0.200
     7.225    21.307     0.200
     7.204    21.128     0.200
     7.638    23.324     0.200
     8.010    23.012     0.200
     8.010    23.137     0.200
     8.792    22.171     0.200
     8.792    25.468     0.200
     9.385    30.030     0.200
    10.204    28.647     0.200
    10.679    29.802     0.200
    10.973    31.035     0.200
    10.950    30.054     0.200
    13.357    36.864     0.200
    13.929    38.893     0.200
    15.197    37.545     0.200
    16.685    39.680     0.200
    17.136    39.786     0.200
    18.606    42.494     0.200
     1.411     7.553     0.200
     1.459     6.740     0.200
     1.700     8.435     0.200
     1.700     9.325     0.200
     1.675    10.150     0.200
     1.861     9.170     0.200
     1.861    10.365     0.200
     1.859    10.196     0.200
     1.875    10.982     0.200
     1.928    10.249     0.200
     1.940    10.495     0.200
     1.940    10.096     0.200
     2.234    11.244     0.200
     2.291    11.047     0.200
     2.616    14.250     0.200
     2.616    11.718     0.200
     2.652    14.203     0.200
     2.882    12.050     0.200
     2.887    12.832     0.200
     2.887    14.644     0.200
     2.887    15.793     0.200
     3.173    11.992     0.200
     3.226    12.278     0.200
     3.226    13.302     0.200
     3.287    13.092     0.200
     3.463    12.537     0.200
     3.463    12.935     0.200
     3.535    14.239     0.200
     3.535    11.302     0.200
     3.554    15.900     0.200
     3.698    14.264     0.200
     3.731    13.277     0.200
     3.731    14.877     0.200
     3.912    13.597     0.200
     4.025    14.577     0.200
     4.039    14.682     0.200
     4.102    14.641     0.200
     4.118    16.314     0.200
     4.365    15.689     0.200
     4.405    15.371     0.200
     4.441    15.028     0.200
     4.404    15.868     0.200
     4.464    19.495     0.200
     4.825    18.254     0.200
     4.847    17.151     0.200
     4.943    16.982     0.200
     5.207    18.108     0.200
     5.242    18.907     0.200
     5.337    18.344     0.200
     5.654    20.047     0.200
     5.662    19.124     0.200
     5.780    18.695     0.200
     5.963    21.128     0.200
     5.979    20.049     0.200
     5.985    18.817     0.200
     6.537    21.348     0.200
     6.651    21.834     0.200
     6.708    21.378     0.200
     6.734    22.561     0.200
     6.741    22.571     0.200
     6.904    23.032     0.200
     7.069    21.145     0.200
     7.129    21.768     0.200
     7.165    21.921     0.200
     7.190    21.884     0.200
     7.453    24.310     0.200
     7.565    22.666     0.200
     7.727    27.759     0.200
     7.950    23.726     0.200
     7.992    24.894     0.200
     8.357    24.059     0.200
     8.407    25.084     0.200
     8.489    24.103     0.200
     8.538    23.442     0.200
     8.538    29.747     0.200
     8.635    25.123     0.200
     8.660    25.615     0.200
     8.674    26.109     0.200
     8.794    26.637     0.200
     8.824    26.285     0.200
     9.314    32.748     0.200
     9.314    29.764     0.200
     9.610    27.724     0.200
     9.807    28.782     0.200
     9.818    28.839     0.200
    10.063    29.134     0.200
    10.874    34.058     0.200
    10.907    34.429     0.200
    10.907    29.140     0.200
    10.917    29.904     0.200
    10.958    29.603     0.200
    11.330    31.173     0.200
    11.381    35.399     0.200
    11.952    37.323     0.200
    13.303    38.243     0.200
    13.580    36.059     0.200
    13.610    35.215     0.200
    13.668    34.387     0.200
    15.284    38.497     0.200
    15.487    37.834     0.200
    15.570    42.053     0.200
    16.700    40.069     0.200
    16.926    38.687     0.200
    16.944    41.428     0.200
    16.987    38.796     0.200
    17.088    37.729     0.200
    18.312    42.380     0.200
    18.539    45.363     0.200
    19.447    44.527     0.200
    20.362    42.480     0.200
     1.461     7.991     0.200
     1.698     8.340     0.200
     1.900     8.894     0.200
     1.900     9.044     0.200
     1.958     7.725     0.200
     1.984     9.242     0.200
     1.984     7.922     0.200
     3.186    11.557     0.200
     3.499    11.143     0.200
     3.506    11.045     0.200
     3.685    13.245     0.200
     1.162     7.903     0.200
     1.162     7.451     0.200
     1.453     9.308     0.200
     1.969    10.490     0.200
     2.255    10.717     0.200
     2.572     9.674     0.200
     2.654    11.548     0.200
     2.715    11.780     0.200
     2.596    13.635     0.200
     3.033    15.009     0.200
     3.266    15.780     0.200
     3.266    16.020     0.200
     3.143    12.446     0.200
     3.108    13.243     0.200
     3.203    13.274     0.200
     3.276    13.583     0.200
     3.406    13.998     0.200
     3.406    16.767     0.200
     3.533    16.801     0.200
     3.654    14.360     0.200
     3.710    14.983     0.200
     3.786    15.240     0.200
     3.862    15.236     0.200
     3.854    16.082     0.200
     3.947    14.912     0.200
     4.075    18.555     0.200
     4.039    15.439     0.200
     4.173    15.461     0.200
     4.234    16.035     0.200
     4.243    16.006     0.200
     4.237    16.730     0.200
     4.292    16.329     0.200
     4.543    19.896     0.200
     4.372    16.443     0.200
     4.372    16.442     0.200
     4.582    16.627     0.200
     4.683    17.090     0.200
     4.720    17.340     0.200
     4.753    17.537     0.200
     4.786    16.808     0.200
     4.991    20.711     0.200
     4.894    20.145     0.200
     4.981    18.855     0.200
     4.993    19.153     0.200
     5.175    18.607     0.200
     5.352    19.232     0.200
     5.663    19.174     0.200
    14.816    38.350     0.200
    14.846    37.803     0.200
    14.842    38.695     0.200
    14.943    38.322     0.200
    14.979    35.171     0.200
    14.999    35.310     0.200
    15.002    35.719     0.200
    15.069    36.678     0.200
    15.177    36.134     0.200
    15.261    36.388     0.200
    15.272    36.195     0.200
    15.369    36.928     0.200
    15.463    36.022     0.200
    15.726    37.419     0.200
    16.032    37.339     0.200
    16.743    37.574     0.200
    16.749    38.153     0.200
     1.412     8.922     0.200
     1.477     7.889     0.200
     1.717     8.835     0.200
     1.717     9.054     0.200
     1.842    10.061     0.200
     1.880     9.689     0.200
     1.880     9.898     0.200
     1.955    10.123     0.200
     1.955    10.373     0.200
     1.948     8.666     0.200
     2.248     9.638     0.200
     2.310    10.861     0.200
     2.602    13.224     0.200
     2.602     9.894     0.200
     2.671    14.444     0.200
     2.870    13.389     0.200
     2.901    11.626     0.200
     3.191    13.056     0.200
     3.208    13.602     0.200
     3.208    12.670     0.200
     3.308    13.395     0.200
     3.333    13.895     0.200
     3.483    14.212     0.200
     3.483    13.324     0.200
     3.542    11.729     0.200
     3.542    11.229     0.200
     3.750    15.049     0.200
     3.858    14.635     0.200
     3.932    15.259     0.200
     4.046    15.097     0.200
     4.120    15.338     0.200
     4.138    15.292     0.200
     4.380    16.407     0.200
     4.385    16.690     0.200
     4.426    15.936     0.200
     4.441    16.416     0.200
     4.453    14.766     0.200
     4.484    16.369     0.200
     4.541    16.725     0.200
     4.830    18.029     0.200
     4.947    17.458     0.200
     4.957    17.601     0.200
     5.226    17.365     0.200
     5.260    17.785     0.200
     5.670    20.088     0.200
     5.673    19.947     0.200
     5.980    22.373     0.200
     5.994    21.198     0.200
     6.668    21.997     0.200
     6.728    22.285     0.200
     6.755    23.776     0.200
     6.925    24.915     0.200
     7.074    21.106     0.200
     7.148    23.439     0.200
     7.183    23.608     0.200
     7.195    20.920     0.200
     7.467    19.239     0.200
     7.998    23.808     0.200
     8.816    27.275     0.200
     9.335    32.217     0.200
    10.927    33.585     0.200
    13.320    39.214     0.200
    15.031    36.632     0.200
    15.060    38.016     0.200
    15.081    37.646     0.200
    15.105    37.648     0.200
    15.501    39.815     0.200
    15.645    38.119     0.200
    15.690    39.991     0.200
    16.258    38.838     0.200
    16.370    38.216     0.200
    18.559    44.313     0.200
     1.856     8.821     0.200
     1.916     8.093     0.200
     1.943     7.721     0.200
     2.612     8.314     0.200
     2.782    10.434     0.200
     2.902    11.905     0.200
     3.230    13.363     0.200
     3.230    12.592     0.200
     3.455    12.957     0.200
     3.510    13.775     0.200
     3.725    14.854     0.200
     7.968    24.371     0.200
     8.813    22.181     0.200
     1.404     8.783     0.200
     1.467     9.315     0.200
     1.660    10.604     0.200
     1.707    10.004     0.200
     1.843    10.522     0.200
     1.877    10.560     0.200
     1.877    10.672     0.200
     1.943     9.541     0.200
     1.955    11.021     0.200
     1.955    10.890     0.200
     2.238    11.552     0.200
     2.307    11.179     0.200
     2.601    11.885     0.200
     2.601     9.566     0.200
     2.812    12.013     0.200
     2.668    14.188     0.200
     2.872    13.338     0.200
     2.872    12.178     0.200
     2.872    11.758     0.200
     2.864    12.036     0.200
     2.891    12.907     0.200
     3.210    14.012     0.200
     3.210    12.893     0.200
     3.189    12.858     0.200
     3.300    12.799     0.200
     3.328    12.790     0.200
     3.479    12.787     0.200
     3.479    14.938     0.200
     3.532    13.627     0.200
     3.532    15.185     0.200
     3.686    12.561     0.200
     3.716    15.873     0.200
     3.746    14.071     0.200
     3.855    14.018     0.200
     3.924    14.232     0.200
     4.039    14.584     0.200
     4.110    14.937     0.200
     4.150    15.176     0.200
     4.134    14.776     0.200
     4.374    15.621     0.200
     4.380    15.869     0.200
     4.380    16.979     0.200
     4.443    15.940     0.200
     4.420    15.373     0.200
     4.433    15.522     0.200
     4.479    15.608     0.200
     4.535    15.787     0.200
     4.820    16.700     0.200
     4.824    16.783     0.200
     4.889    16.340     0.200
     4.947    17.096     0.200
     4.938    17.063     0.200
     4.948    16.931     0.200
     5.042    20.157     0.200
     5.217    17.587     0.200
     5.250    17.586     0.200
     5.335    17.836     0.200
     5.316    17.217     0.200
     5.467    17.571     0.200
     5.639    19.236     0.200
     5.663    18.150     0.200
     5.660    18.302     0.200
     5.667    17.380     0.200
     5.698    17.545     0.200
     5.799    17.839     0.200
     5.970    21.434     0.200
     5.984    21.481     0.200
     5.993    19.957     0.200
     7.989    25.625     0.200
     8.811    27.226     0.200
     9.328    29.857     0.200
    10.918    33.357     0.200
    13.310    36.433     0.200
    13.873    37.575     0.200
    14.951    36.374     0.200
    14.995    35.411     0.200
    15.021    36.641     0.200
    15.050    36.535     0.200
    15.072    37.174     0.200
    15.095    37.376     0.200
    15.161    36.655     0.200
    15.192    37.099     0.200
    15.220    37.178     0.200
    15.217    36.567     0.200
    15.250    37.192     0.200
    15.295    37.091     0.200
    15.401    37.225     0.200
    15.459    36.940     0.200
    15.474    37.748     0.200
    15.493    37.066     0.200
    15.495    37.198     0.200
    15.558    37.573     0.200
    15.544    37.364     0.200
    15.631    37.784     0.200
    15.636    37.663     0.200
    15.682    37.971     0.200
    16.250    38.677     0.200
    16.324    38.620     0.200
    16.253    40.159     0.200
    16.629    38.942     0.200
    17.623    39.488     0.200
    18.551    42.089     0.200
    19.130    40.183     0.200
     1.920     9.258     0.200
     1.920     8.937     0.200
     1.988     7.534     0.200
     1.993     9.389     0.200
     3.523    12.495     0.200
     3.539    11.919     0.200
     3.614    12.014     0.200
     3.682    13.895     0.200
     1.408     8.508     0.200
     1.502     8.300     0.200
     1.740     9.247     0.200
     1.811    10.895     0.200
     1.911     9.731     0.200
     1.981     8.535     0.200
     1.982     9.849     0.200
     2.576    12.962     0.200
     2.834    14.998     0.200
     3.177    13.582     0.200
     3.515    15.339     0.200
     3.547    13.864     0.200
     3.606    14.715     0.200
     3.693    16.112     0.200
     4.418    18.854     0.200
     8.001    25.236     0.200
     8.796    27.608     0.200
     9.366    32.354     0.200
    10.955    35.174     0.200
    13.341    38.590     0.200
    18.588    44.189     0.200
     1.374     7.633     0.200
     1.482     7.749     0.200
     1.625    10.035     0.200
     1.718     8.793     0.200
     1.718     8.629     0.200
     1.798    10.096     0.200
     1.921     9.862     0.200
     1.921     9.643     0.200
     2.001     9.708     0.200
     2.001     9.419     0.200
     2.239    10.154     0.200
     2.350    10.006     0.200
     2.555    13.383     0.200
     2.555    11.180     0.200
     2.555    10.469     0.200
     2.710    12.638     0.200
     2.909    12.066     0.200
     2.838    13.519     0.200
     2.838    13.667     0.200
     3.165    12.997     0.200
     3.165    14.044     0.200
     3.232    13.568     0.200
     3.328    13.195     0.200
     3.366    13.840     0.200
     3.521    14.665     0.200
     3.521    12.587     0.200
     3.514    14.288     0.200
     3.514    13.242     0.200
     3.611    13.433     0.200
     3.647    14.120     0.200
     3.671    15.453     0.200
     3.787    13.830     0.200
     3.897    15.413     0.200
     3.947    15.224     0.200
     3.979    16.386     0.200
     4.070    15.466     0.200
     4.120    15.698     0.200
     4.117    15.934     0.200
     4.174    15.347     0.200
     4.410    15.055     0.200
     4.416    16.067     0.200
     4.416    15.535     0.200
     4.416    19.348     0.200
     4.436    16.167     0.200
     4.461    15.801     0.200
     4.519    17.886     0.200
     4.568    16.216     0.200
     4.795    17.113     0.200
     4.860    16.393     0.200
     4.946    17.118     0.200
     4.976    15.935     0.200
     5.235    16.972     0.200
     5.239    16.203     0.200
     5.260    18.824     0.200
     5.318    18.555     0.200
     5.654    18.663     0.200
     5.663    20.627     0.200
     5.707    18.888     0.200
     5.738    20.925     0.200
     5.744    18.877     0.200
     5.979    20.503     0.200
     5.986    21.115     0.200
     6.026    20.602     0.200
     6.298    20.675     0.200
     6.403    21.858     0.200
     6.425    22.377     0.200
     6.437    21.518     0.200
     6.531    20.382     0.200
     6.667    23.058     0.200
     6.720    22.410     0.200
     6.744    21.268     0.200
     6.783    20.979     0.200
     6.952    21.048     0.200
     7.041    22.195     0.200
     7.153    22.776     0.200
     7.163    22.737     0.200
     7.186    23.774     0.200
     7.609    24.122     0.200
     7.685    24.960     0.200
     7.742    23.789     0.200
     7.968    24.020     0.200
     8.653    26.328     0.200
     8.748    26.679     0.200
     8.769    25.914     0.200
     8.769    27.265     0.200
     9.360    29.581     0.200
    10.168    29.662     0.200
    10.423    30.421     0.200
    10.940    33.725     0.200
    10.928    31.249     0.200
    11.346    31.375     0.200
    11.535    33.452     0.200
    13.316    38.140     0.200
    13.316    37.304     0.200
    14.193    37.644     0.200
    15.241    37.202     0.200
    15.644    41.350     0.200
    15.674    36.582     0.200
    17.461    41.800     0.200
     1.406     8.322     0.200
     1.492     8.161     0.200
     1.632     9.926     0.200
     1.731     9.085     0.200
     1.819    10.069     0.200
     1.903     9.754     0.200
     1.903    10.066     0.200
     1.971     8.673     0.200
     1.976    10.330     0.200
     1.976    10.041     0.200
     2.258    10.680     0.200
     2.333    10.618     0.200
     2.582    12.614     0.200
     2.582    11.043     0.200
     2.582    10.121     0.200
     2.841    12.811     0.200
     2.694    13.205     0.200
     2.844    12.584     0.200
     2.893    12.221     0.200
     2.917    12.229     0.200
     3.185    12.430     0.200
     3.328    14.005     0.200
     3.356    14.645     0.200
     3.506    14.203     0.200
     3.506    13.977     0.200
     3.542    15.296     0.200
     3.542    14.632     0.200
     3.597    15.182     0.200
     3.774    14.204     0.200
     3.951    13.742     0.200
     4.067    15.213     0.200
     4.134    15.838     0.200
     4.149    15.016     0.200
     4.161    15.553     0.200
     4.403    16.557     0.200
     4.408    16.708     0.200
     4.408    19.482     0.200
     4.449    16.131     0.200
     4.462    16.372     0.200
     4.459    16.869     0.200
     4.507    17.701     0.200
     4.563    16.971     0.200
     4.825    18.142     0.200
     4.853    16.230     0.200
     4.917    17.212     0.200
     4.965    16.944     0.200
     5.236    17.977     0.200
     5.243    18.219     0.200
     5.273    18.507     0.200
     5.346    18.864     0.200
     5.495    18.095     0.200
     5.681    20.196     0.200
     5.678    19.189     0.200
     5.694    19.860     0.200
     5.776    19.410     0.200
     5.993    21.030     0.200
     6.004    19.618     0.200
     6.401    20.874     0.200
     6.417    21.116     0.200
     6.431    20.676     0.200
     6.523    22.304     0.200
     6.526    22.964     0.200
     6.682    23.485     0.200
     6.709    23.068     0.200
     6.748    22.350     0.200
     6.777    21.865     0.200
     6.783    21.245     0.200
     7.071    22.705     0.200
     7.102    23.506     0.200
     7.164    23.901     0.200
     7.198    24.422     0.200
     7.193    23.594     0.200
     7.490    20.052     0.200
     7.388    24.105     0.200
     7.439    24.032     0.200
     7.512    22.119     0.200
     7.600    23.444     0.200
     7.640    24.954     0.200
     7.691    26.571     0.200
     7.997    25.392     0.200
     7.997    24.095     0.200
     7.997    24.235     0.200
     8.798    27.245     0.200
     8.799    24.759     0.200
     8.799    27.236     0.200
     9.357    31.786     0.200
    10.945    33.940     0.200
    10.960    30.714     0.200
    12.094    34.458     0.200
    13.332    39.251     0.200
    15.474    39.798     0.200
    18.578    43.517     0.200
    20.570    42.445     0.200
     1.096     6.062     0.200
     1.090     6.911     0.200
     1.300     7.210     0.200
     1.515     8.043     0.200
     1.998     9.780     0.200
     2.155     9.802     0.200
     3.504    13.940     0.200
     1.432     8.175     0.200
     1.671     9.322     0.200
     1.849     9.537     0.200
     1.868     9.708     0.200
     1.868     9.927     0.200
     1.903    11.153     0.200
     1.924     8.597     0.200
     1.958    10.213     0.200
     2.597    12.996     0.200
     2.597    10.445     0.200
     3.218    14.179     0.200
     3.218    12.890     0.200
     3.466    13.132     0.200
     3.497    13.552     0.200
     3.708    15.242     0.200
     4.031    17.048     0.200
     5.022    18.544     0.200
     5.643    19.730     0.200
     7.954    24.528     0.200
     8.796    25.707     0.200
    13.272    38.950     0.200
    18.518    44.142     0.200
     0.631     5.993     0.200
     3.267    14.185     0.200
     3.390    13.752     0.200
     3.617    15.125     0.200
     3.707    15.846     0.200
     1.417     7.470     0.200
     2.005     9.503     0.200
     2.016     9.382     0.200
     3.547    12.326     0.200
     3.677    14.517     0.200
     3.639    12.649     0.200
     1.393     8.413     0.200
     1.496     8.146     0.200
     1.985     7.939     0.200
     1.994     9.797     0.200
     2.564    10.339     0.200
     2.831    12.535     0.200
     3.522    13.921     0.200
     3.612    13.603     0.200
     3.681    15.845     0.200
     9.368    32.145     0.200
     1.548     8.285     0.200
     1.790     9.187     0.200
     1.790     8.742     0.200
     1.899     8.263     0.200
     1.951     9.696     0.200
     1.987     9.338     0.200
     2.324    10.338     0.200
     2.332    10.829     0.200
     2.614    10.915     0.200
     2.614    11.064     0.200
     2.969     9.998     0.200
     3.210    12.480     0.200
     3.194    14.214     0.200
     3.365    11.974     0.200
     3.373    12.846     0.200
     3.508    13.408     0.200
     3.614    12.709     0.200
     3.614    15.435     0.200
     3.736    13.793     0.200
     4.215    13.910     0.200
     4.427    13.786     0.200
     4.896    15.000     0.200
     4.927    17.643     0.200
     5.034    15.860     0.200
     5.090    15.951     0.200
     5.418    15.526     0.200
     5.844    16.679     0.200
     6.069    16.913     0.200
     7.264    19.334     0.200
     7.501    21.232     0.200
     7.652    20.673     0.200
     7.698    21.884     0.200
     8.835    23.919     0.200
     8.848    24.427     0.200
    12.270    32.223     0.200
    14.736    35.444     0.200
    14.889    34.093     0.200
    15.259    35.686     0.200
    15.290    35.206     0.200
    15.515    35.738     0.200
    15.563    37.031     0.200
    15.602    35.753     0.200
    15.751    35.078     0.200
    15.897    37.214     0.200
     1.447     6.891     0.200
     1.602     9.651     0.200
     1.780     6.369     0.200
     1.813    10.283     0.200
     1.916     9.232     0.200
     1.974     8.242     0.200
     1.974     9.195     0.200
     1.998     7.771     0.200
     2.589     9.845     0.200
     3.175    12.763     0.200
     3.524    12.557     0.200
     3.708    16.084     0.200
     5.061    19.029     0.200
     8.044    23.403     0.200
     9.391    26.425     0.200
    13.382    33.764     0.200
     1.894     9.002     0.200
     2.597    11.134     0.200
     2.841    14.208     0.200
     3.562    16.381     0.200
     3.698    17.237     0.200
     5.053    20.293     0.200
     5.626    20.152     0.200
     8.017    26.051     0.200
     8.818    24.435     0.200
     0.975     5.400     0.200
     1.460     6.316     0.200
     1.524     6.866     0.200
     1.632    10.366     0.200
     1.766     7.799     0.200
     1.766     7.682     0.200
     1.885     8.922     0.200
     1.885     8.203     0.200
     1.943     8.793     0.200
     1.943     8.238     0.200
     1.968     7.437     0.200
     2.301     8.838     0.200
     2.317     9.582     0.200
     2.619    11.736     0.200
     2.619     9.963     0.200
     2.843    11.363     0.200
     2.843    12.223     0.200
     2.846    11.473     0.200
     2.682    13.151     0.200
     3.207    13.720     0.200
     3.354    12.188     0.200
     3.493    11.828     0.200
     3.493    13.953     0.200
     3.595    12.764     0.200
     3.595    13.225     0.200
     3.764    11.740     0.200
     3.971    13.817     0.200
     4.204    13.741     0.200
     4.408    13.689     0.200
     4.476    14.522     0.200
     4.507    15.778     0.200
     4.880    17.538     0.200
     5.010    15.796     0.200
     5.084    17.455     0.200
     5.308    17.943     0.200
     5.642    18.481     0.200
     5.830    17.405     0.200
     6.029    18.302     0.200
     6.046    17.862     0.200
     6.717    19.790     0.200
     7.125    20.407     0.200
     7.194    20.135     0.200
     7.230    20.920     0.200
     7.247    20.861     0.200
     7.479    19.258     0.200
     7.627    21.097     0.200
     7.643    21.701     0.200
     7.692    22.638     0.200
     8.051    23.305     0.200
     8.051    22.687     0.200
     8.604    24.227     0.200
     8.710    25.145     0.200
     8.830    25.845     0.200
     8.845    25.868     0.200
     8.846    25.859     0.200
     8.846    26.304     0.200
    12.281    30.791     0.200
    13.180    32.419     0.200
    14.543    36.980     0.200
    14.876    37.103     0.200
    15.529    38.076     0.200
    15.549    37.219     0.200
    15.597    38.477     0.200
     1.912     9.603     0.200
     1.928    10.015     0.200
     1.439     7.542     0.200
     1.521     6.901     0.200
     1.620     8.816     0.200
     1.761     8.025     0.200
     1.761     7.845     0.200
     1.825     8.385     0.200
     1.902     8.582     0.200
     1.902     8.712     0.200
     1.980     8.336     0.200
     1.964     8.071     0.200
     1.964     8.701     0.200
     2.291     9.438     0.200
     2.333     8.886     0.200
     2.596    10.717     0.200
     2.596     9.856     0.200
     2.854    11.804     0.200
     2.697    11.521     0.200
     2.906    10.608     0.200
     2.944    10.373     0.200
     3.188    12.603     0.200
     3.347    10.774     0.200
     3.366    11.468     0.200
     3.508    12.714     0.200
     3.508    12.935     0.200
     3.578    12.436     0.200
     3.578    12.726     0.200
     3.716    13.014     0.200
     3.778    13.082     0.200
     3.973    13.666     0.200
     4.084    14.485     0.200
     4.167    13.992     0.200
     4.419    14.221     0.200
     4.419    14.785     0.200
     4.860    15.492     0.200
     4.988    16.114     0.200
     4.995    15.055     0.200
     5.061    17.168     0.200
     5.809    17.393     0.200
     5.846    15.907     0.200
     5.941    21.791     0.200
     6.037    18.135     0.200
     6.557    20.292     0.200
     6.718    20.209     0.200
     6.770    19.394     0.200
     7.105    21.536     0.200
     7.228    20.401     0.200
     7.494    17.830     0.200
     7.627    22.253     0.200
     7.645    22.442     0.200
     7.668    22.940     0.200
     7.704    21.855     0.200
     7.723    21.979     0.200
     8.032    23.537     0.200
     8.032    23.368     0.200
     8.345    21.995     0.200
     8.592    24.170     0.200
     8.806    25.567     0.200
     8.822    25.523     0.200
     8.822    25.168     0.200
     9.356    25.410     0.200
     9.372    28.086     0.200
    10.211    26.983     0.200
    10.212    28.012     0.200
    10.464    29.226     0.200
    10.485    28.994     0.200
    10.699    29.276     0.200
    10.969    31.171     0.200
    10.977    28.670     0.200
    10.987    29.763     0.200
    12.163    32.048     0.200
    12.261    31.826     0.200
    12.616    33.596     0.200
    13.276    32.672     0.200
    13.363    33.651     0.200
    13.605    34.793     0.200
    13.611    35.021     0.200
    13.688    34.129     0.200
    13.834    34.937     0.200
    13.913    38.424     0.200
    14.030    36.134     0.200
    14.094    34.308     0.200
    14.108    33.921     0.200
    14.319    35.774     0.200
    14.520    35.007     0.200
    14.608    37.131     0.200
    14.658    36.380     0.200
    14.811    37.874     0.200
    14.811    38.536     0.200
    14.840    36.570     0.200
    14.855    37.441     0.200
    14.964    37.072     0.200
    15.049    35.985     0.200
    15.058    37.347     0.200
    15.075    36.203     0.200
    15.125    36.166     0.200
    15.135    37.857     0.200
    15.195    37.906     0.200
    15.225    36.805     0.200
    15.255    36.768     0.200
    15.267    37.454     0.200
    15.407    37.407     0.200
    15.490    39.943     0.200
    15.528    38.596     0.200
    15.574    37.450     0.200
    15.588    38.705     0.200
    15.658    39.371     0.200
    15.716    38.038     0.200
    15.845    37.920     0.200
    15.987    38.770     0.200
    15.978    39.208     0.200
    16.284    39.248     0.200
    16.355    39.662     0.200
    16.390    40.110     0.200
    16.674    39.189     0.200
    16.901    39.246     0.200
    16.941    39.586     0.200
    16.954    39.149     0.200
    16.988    39.379     0.200
    17.016    37.972     0.200
    17.049    39.159     0.200
    17.151    38.748     0.200
    17.374    39.469     0.200
    17.526    38.932     0.200
    17.672    40.025     0.200
    17.737    40.861     0.200
    17.813    40.288     0.200
    18.601    42.875     0.200
     1.393     8.629     0.200
     1.492     8.511     0.200
     1.624    11.296     0.200
     1.730     9.456     0.200
     1.730     9.267     0.200
     1.806    10.865     0.200
     1.915     9.665     0.200
     1.980     8.460     0.200
     1.990     9.845     0.200
     2.253    10.718     0.200
     2.567    14.652     0.200
     2.567    11.361     0.200
     2.918    12.891     0.200
     3.532    14.985     0.200
     3.684    14.443     0.200
     4.132    16.732     0.200
     4.136    16.279     0.200
     4.452    16.939     0.200
     4.813    18.580     0.200
     4.961    17.644     0.200
     5.271    20.204     0.200
     5.336    18.472     0.200
     5.670    19.171     0.200
     5.677    20.140     0.200
     5.763    19.360     0.200
     5.991    21.770     0.200
     6.000    20.733     0.200
     6.680    22.851     0.200
     6.751    24.192     0.200
     6.788    25.421     0.200
     7.059    21.245     0.200
     7.181    21.488     0.200
     7.197    23.884     0.200
     7.500    20.912     0.200
     7.392    27.013     0.200
     7.425    22.336     0.200
     7.601    25.467     0.200
     7.624    25.736     0.200
     7.626    23.150     0.200
     7.695    24.886     0.200
     7.677    25.922     0.200
     7.753    25.756     0.200
     7.983    22.764     0.200
     7.983    22.874     0.200
     7.986    24.757     0.200
     7.986    23.762     0.200
     8.381    23.707     0.200
     8.643    24.827     0.200
     8.670    24.908     0.200
     8.783    26.639     0.200
     8.784    27.111     0.200
     8.784    26.412     0.200
     9.363    33.034     0.200
    10.945    33.541     0.200
    13.329    38.533     0.200
    13.705    35.470     0.200
    15.247    36.663     0.200
    15.481    38.602     0.200
    15.533    39.361     0.200
    15.626    38.857     0.200
    15.670    39.004     0.200
    16.345    39.526     0.200
    16.626    39.455     0.200
    17.479    40.247     0.200
     1.416     8.352     0.200
     1.512     7.883     0.200
     1.751     8.616     0.200
     1.915     8.371     0.200
     1.915     9.812     0.200
     1.983     9.390     0.200
     1.983     9.640     0.200
     1.987    10.299     0.200
     2.577    10.555     0.200
     2.827    11.213     0.200
     3.557    14.061     0.200
     3.695    13.976     0.200
     5.037    17.742     0.200
     5.606    18.857     0.200
     1.437     8.496     0.200
     1.548     7.681     0.200
     1.586    11.428     0.200
     1.787     8.586     0.200
     1.794     8.664     0.200
     1.935     8.949     0.200
     1.935     9.558     0.200
     1.993     9.437     0.200
     2.015     8.337     0.200
     2.312    10.012     0.200
     2.367    10.308     0.200
     2.570    11.291     0.200
     2.570    10.573     0.200
     2.731    14.298     0.200
     2.973    11.697     0.200
     3.156    12.718     0.200
     3.542    13.962     0.200
     3.585    13.423     0.200
     3.585    13.161     0.200
     3.634    14.942     0.200
     3.693    13.988     0.200
     3.691    13.719     0.200
     4.005    15.048     0.200
     4.176    15.626     0.200
     4.453    19.269     0.200
     4.509    16.164     0.200
     4.861    17.263     0.200
     5.020    17.398     0.200
     5.046    18.228     0.200
     5.591    17.708     0.200
     5.807    19.206     0.200
     6.058    18.336     0.200
     6.801    21.747     0.200
     6.824    19.721     0.200
     7.231    22.559     0.200
     7.528    20.136     0.200
     7.460    23.313     0.200
     7.654    23.700     0.200
     7.677    22.764     0.200
     7.677    25.955     0.200
     8.038    24.310     0.200
     8.038    23.986     0.200
     8.038    24.658     0.200
     8.608    26.503     0.200
     8.791    26.887     0.200
     8.804    25.653     0.200
     8.804    26.450     0.200
     9.406    30.630     0.200
    10.413    32.651     0.200
    11.000    34.472     0.200
    10.971    32.334     0.200
    11.409    31.017     0.200
    11.928    35.002     0.200
    12.019    33.054     0.200
    12.105    34.138     0.200
    12.230    36.391     0.200
    12.230    35.918     0.200
    12.655    34.803     0.200
    13.128    37.933     0.200
    13.218    36.029     0.200
    13.387    37.738     0.200
    13.387    36.309     0.200
    13.601    35.628     0.200
    13.702    39.022     0.200
    14.111    37.003     0.200
    15.558    39.637     0.200
    18.632    43.349     0.200
    18.632    44.521     0.200
    19.504    42.028     0.200
     1.939    10.147     0.200
     2.017     9.088     0.200
     2.000    10.378     0.200
     2.889    13.388     0.200
     3.150    11.907     0.200
     3.575    11.522     0.200
     3.546    16.550     0.200
     8.794    26.603     0.200
     1.425     6.905     0.200
     1.917     8.808     0.200
     1.917     9.035     0.200
     1.992     7.328     0.200
     2.579     9.907     0.200
     2.822    13.147     0.200
     3.172    11.673     0.200
     3.522    14.252     0.200
     3.567    13.357     0.200
     5.044    15.982     0.200
     0.957     5.458     0.200
     1.447     7.872     0.200
     1.675     9.644     0.200
     1.869     9.409     0.200
     1.849    10.112     0.200
     1.930     7.956     0.200
     1.953     9.794     0.200
     1.953     8.466     0.200
     2.602    12.099     0.200
     3.218    14.069     0.200
     3.469    11.517     0.200
     3.515    13.364     0.200
     3.678    15.594     0.200
     3.715    14.476     0.200
     5.035    18.223     0.200
     8.806    26.120     0.200
    18.531    44.127     0.200
     0.860     7.194     0.200
     0.860     7.092     0.200
     1.422     8.129     0.200
     1.583    10.264     0.200
     1.942     9.272     0.200
     2.018     8.275     0.200
     2.004     9.683     0.200
     2.558    11.023     0.200
     2.795    14.322     0.200
     3.147    12.536     0.200
     3.571    11.581     0.200
     3.548    14.858     0.200
     3.678    12.427     0.200
     5.031    16.712     0.200
     0.881     4.572     0.200
     0.881     5.252     0.200
     1.923     9.114     0.200
     1.923     9.304     0.200
     1.997     7.000     0.200
     1.989     9.560     0.200
     3.563    14.027     0.200
     3.691    14.247     0.200
     5.037    14.407     0.200
     1.299     8.232     0.200
     1.404     7.564     0.200
     1.637     8.490     0.200
     1.673    10.403     0.200
     1.911     8.436     0.200
     1.911     9.537     0.200
     2.017     9.406     0.200
     2.017     9.688     0.200
     3.177    13.116     0.200
     3.428    13.510     0.200
     3.501    14.946     0.200
     3.591    15.567     0.200
     4.948    20.234     0.200
     5.595    20.606     0.200
     7.884    24.013     0.200
     8.725    25.753     0.200
    10.869    29.756     0.200
    13.231    35.863     0.200
     2.592    10.665     0.200
     3.246    11.394     0.200
     3.398    13.630     0.200
     3.428    15.039     0.200
     3.516    13.239     0.200
     1.419     8.184     0.200
     1.758     9.148     0.200
     1.920     9.985     0.200
     1.920     8.895     0.200
     1.986    11.411     0.200
     2.574    13.144     0.200
     2.821    13.841     0.200
     3.169    15.809     0.200
     3.561    16.290     0.200
     0.910     4.015     0.200
     1.444     6.895     0.200
     1.505     8.387     0.200
     1.643     7.572     0.200
     1.746     9.114     0.200
     1.847     9.035     0.200
     1.880     9.277     0.200
     1.944     9.482     0.200
     1.958     9.613     0.200
     2.311     9.165     0.200
     2.280    10.132     0.200
     2.615    12.799     0.200
     2.675    12.304     0.200
     2.926    11.833     0.200
     3.191    11.537     0.200
     3.343    11.328     0.200
     3.486    11.548     0.200
     3.486    14.548     0.200
     3.576    14.912     0.200
     3.954    12.919     0.200
     4.063    13.150     0.200
     4.144    13.367     0.200
     4.149    14.758     0.200
     4.188    15.119     0.200
     4.396    13.047     0.200
     4.491    13.871     0.200
     4.487    14.478     0.200
     4.974    14.269     0.200
     4.990    16.340     0.200
     5.073    16.355     0.200
     5.252    17.121     0.200
     5.289    17.743     0.200
     5.379    17.354     0.200
     5.813    16.369     0.200
     6.009    19.329     0.200
     6.025    19.022     0.200
     7.107    20.364     0.200
     7.228    20.063     0.200
     7.478    19.005     0.200
     7.626    22.627     0.200
     7.706    23.404     0.200
     8.032    25.425     0.200
     8.724    25.179     0.200
     8.837    22.909     0.200
     8.837    25.675     0.200
    10.198    27.549     0.200
    15.060    38.369     0.200
    15.110    38.262     0.200
    15.230    38.487     0.200
    15.441    37.214     0.200
    15.513    37.944     0.200
    15.533    37.196     0.200
    15.671    37.953     0.200
    15.676    37.509     0.200
    15.992    38.034     0.200
    16.289    38.722     0.200
    16.398    39.428     0.200
     0.901     5.341     0.200
     0.901     5.638     0.200
     1.414     8.426     0.200
     1.504     8.126     0.200
     1.743     8.563     0.200
     1.908    10.208     0.200
     1.908     9.571     0.200
     1.816     9.259     0.200
     1.977    10.834     0.200
     1.977     9.084     0.200
     1.979     9.478     0.200
     2.338    10.524     0.200
     2.269    10.166     0.200
     2.581    11.799     0.200
     2.581    11.338     0.200
     2.581     9.838     0.200
     2.700    13.880     0.200
     2.836    14.398     0.200
     2.836    13.527     0.200
     2.928    11.958     0.200
     3.219    11.955     0.200
     3.181    14.083     0.200
     3.364    13.916     0.200
     3.338    13.330     0.200
     3.512    12.532     0.200
     3.512    14.341     0.200
     3.603    15.086     0.200
     3.552    12.447     0.200
     3.552    14.959     0.200
     3.552    15.248     0.200
     3.780    14.029     0.200
     3.961    14.193     0.200
     4.077    14.598     0.200
     4.168    14.361     0.200
     4.145    14.199     0.200
     4.156    14.536     0.200
     4.416    15.558     0.200
     4.416    19.183     0.200
     4.470    14.676     0.200
     4.834    15.548     0.200
     4.986    16.518     0.200
     4.978    16.839     0.200
     5.038    19.224     0.200
     5.285    15.649     0.200
     5.356    17.318     0.200
     5.612    19.257     0.200
     5.732    16.450     0.200
     5.784    18.814     0.200
     5.937    20.474     0.200
     6.015    19.350     0.200
     6.532    19.874     0.200
     6.785    18.936     0.200
     6.758    20.559     0.200
     6.792    20.209     0.200
     7.496    17.942     0.200
     7.445    22.611     0.200
     7.445    23.837     0.200
     7.707    21.365     0.200
     7.645    23.063     0.200
     7.690    22.426     0.200
     7.690    26.984     0.200
     7.764    22.050     0.200
     8.007    24.352     0.200
     8.007    23.075     0.200
     8.007    25.645     0.200
     8.007    22.152     0.200
     8.401    23.718     0.200
     8.784    25.240     0.200
     8.829    29.008     0.200
     8.801    25.098     0.200
     8.802    26.249     0.200
     9.365    31.807     0.200
    10.956    34.715     0.200
    10.937    30.172     0.200
    11.385    28.855     0.200
    12.139    30.251     0.200
    12.252    36.887     0.200
    12.595    32.210     0.200
    12.656    32.591     0.200
    13.084    32.082     0.200
    13.580    37.764     0.200
    14.496    35.797     0.200
    14.975    35.938     0.200
    14.956    36.171     0.200
    15.260    37.024     0.200
    15.465    36.320     0.200
    15.502    36.580     0.200
    15.552    41.092     0.200
    15.552    39.881     0.200
    16.261    39.447     0.200
    16.647    37.693     0.200
    16.875    38.392     0.200
    18.588    44.313     0.200
    18.588    44.915     0.200
    19.468    44.125     0.200
    19.468    43.477     0.200
    20.367    43.181     0.200
    20.367    42.791     0.200
     1.414     8.131     0.200
     1.733     8.625     0.200
     1.896     9.175     0.200
     1.968     9.442     0.200
     1.967     7.493     0.200
     2.262    10.214     0.200
     2.327    10.044     0.200
     2.590    12.014     0.200
     2.688    12.141     0.200
     2.918    11.551     0.200
     3.326    12.809     0.200
     3.352    10.994     0.200
     3.500    12.258     0.200
     3.549    13.059     0.200
     3.707    13.986     0.200
     3.688    12.018     0.200
     3.768    12.011     0.200
     3.950    13.105     0.200
     4.158    14.477     0.200
     4.136    15.214     0.200
     4.404    13.609     0.200
     4.404    18.117     0.200
     4.460    14.549     0.200
     4.833    15.505     0.200
     4.971    16.915     0.200
     5.275    17.257     0.200
     5.353    18.348     0.200
     5.684    18.336     0.200
     5.784    18.103     0.200
     6.008    19.046     0.200
     6.534    19.557     0.200
     6.943    19.823     0.200
     7.078    21.374     0.200
     7.200    20.921     0.200
     7.199    21.053     0.200
     7.484    18.282     0.200
     7.448    22.475     0.200
     7.649    22.895     0.200
     7.621    22.367     0.200
     8.004    21.402     0.200
     8.004    22.761     0.200
     8.789    25.845     0.200
     8.808    26.060     0.200
     8.808    23.715     0.200
     8.808    26.473     0.200
     9.354    29.328     0.200
     9.447    26.766     0.200
     9.602    28.623     0.200
    10.945    31.874     0.200
    13.335    36.009     0.200
    14.767    35.408     0.200
    15.097    36.305     0.200
    15.201    35.766     0.200
    15.321    35.122     0.200
    18.577    43.563     0.200
     0.936     5.561     0.200
     1.443     7.199     0.200
     1.565     8.226     0.200
     1.783    10.835     0.200
     1.804     8.163     0.200
     1.949     8.473     0.200
     1.949     8.653     0.200
     2.003     9.009     0.200
     2.031     8.381     0.200
     2.381    11.669     0.200
     2.562    12.560     0.200
     2.746    13.490     0.200
     2.990    12.447     0.200
     3.143    13.341     0.200
     3.398    11.931     0.200
     3.417    14.022     0.200
     3.557    14.496     0.200
     3.595    12.326     0.200
     3.595    13.785     0.200
     3.685    14.492     0.200
     3.828    14.622     0.200
     4.023    14.968     0.200
     4.216    15.461     0.200
     4.206    15.418     0.200
     4.180    16.183     0.200
     4.470    15.043     0.200
     4.523    16.922     0.200
     5.046    21.029     0.200
     5.813    18.651     0.200
     6.074    20.110     0.200
     7.271    24.524     0.200
     7.240    21.844     0.200
     7.655    25.075     0.200
     8.047    23.007     0.200
     8.047    23.652     0.200
     8.700    26.185     0.200
     8.796    30.419     0.200
     8.801    23.997     0.200
     8.801    26.211     0.200
    10.973    28.822     0.200
    11.842    34.870     0.200
    13.403    39.258     0.200
    15.196    38.714     0.200
    15.225    39.351     0.200
    15.316    36.854     0.200
    15.394    37.924     0.200
    15.399    40.092     0.200
    15.498    36.356     0.200
    15.507    40.374     0.200
    15.531    41.212     0.200
    15.556    40.330     0.200
    15.718    40.103     0.200
    15.863    36.745     0.200
    17.884    39.187     0.200
    18.650    44.497     0.200
     0.932     5.980     0.200
     1.398     8.506     0.200
     1.471     7.802     0.200
     1.652    11.166     0.200
     1.711     9.057     0.200
     1.711     9.897     0.200
     1.833    10.665     0.200
     1.888     9.633     0.200
     1.888     9.485     0.200
     1.952     9.509     0.200
     1.966     9.841     0.200
     2.239    11.723     0.200
     2.317    11.563     0.200
     2.591    14.376     0.200
     2.591    10.990     0.200
     2.677    15.016     0.200
     2.896    13.056     0.200
     3.199    13.311     0.200
     3.199    12.546     0.200
     3.307    13.229     0.200
     3.337    13.389     0.200
     3.489    14.154     0.200
     3.489    14.264     0.200
     3.529    14.520     0.200
     3.529    14.688     0.200
     3.529    14.067     0.200
     3.706    14.574     0.200
     3.756    14.240     0.200
     3.930    15.223     0.200
     4.047    15.777     0.200
     4.113    15.712     0.200
     4.143    17.007     0.200
     4.144    15.715     0.200
     4.388    18.050     0.200
     4.388    16.628     0.200
     4.388    15.499     0.200
     4.440    16.084     0.200
     4.442    16.212     0.200
     5.034    18.329     0.200
     5.628    15.612     0.200
     5.767    19.584     0.200
     5.985    20.567     0.200
     7.435    23.782     0.200
     7.435    23.911     0.200
     7.639    24.028     0.200
     7.701    25.942     0.200
     7.701    27.263     0.200
     7.701    26.712     0.200
     7.985    24.128     0.200
     7.985    24.398     0.200
     7.985    24.757     0.200
     7.985    24.996     0.200
     7.985    23.636     0.200
     7.985    24.046     0.200
     8.540    27.942     0.200
     8.780    26.246     0.200
     8.801    26.103     0.200
     8.802    25.914     0.200
     8.838    26.195     0.200
     8.985    26.983     0.200
     9.306    28.303     0.200
     9.332    28.146     0.200
     9.336    30.378     0.200
     9.336    28.960     0.200
    10.098    29.362     0.200
    10.414    30.477     0.200
    10.650    29.980     0.200
    10.924    32.663     0.200
    10.959    31.208     0.200
    11.377    32.009     0.200
    11.441    31.997     0.200
    11.561    33.859     0.200
    12.269    34.242     0.200
    12.269    37.589     0.200
    13.294    35.395     0.200
    13.312    32.931     0.200
    13.312    37.334     0.200
    13.312    35.131     0.200
    13.566    38.018     0.200
    13.882    38.061     0.200
    13.914    37.025     0.200
    14.003    38.410     0.200
    14.069    37.586     0.200
    14.801    38.340     0.200
    14.930    38.784     0.200
    14.941    38.856     0.200
    15.020    38.398     0.200
    15.549    40.099     0.200
    15.549    41.368     0.200
    15.549    40.528     0.200
    15.676    40.776     0.200
    15.824    39.747     0.200
    16.019    41.015     0.200
    16.193    39.772     0.200
    16.244    41.034     0.200
    16.317    42.041     0.200
    16.633    40.782     0.200
    16.636    41.237     0.200
    16.909    40.648     0.200
    17.629    41.835     0.200
    18.556    42.748     0.200
    19.443    43.777     0.200
    19.930    42.159     0.200
    20.350    42.834     0.200
     1.616     8.151     0.200
     1.746     7.518     0.200
     1.807     8.885     0.200
     1.917     7.712     0.200
     1.987     7.193     0.200
     1.987     9.535     0.200
     1.987     9.715     0.200
     2.270     9.833     0.200
     2.347     9.641     0.200
     2.572    11.121     0.200
     2.572     8.351     0.200
     2.856    13.143     0.200
     2.709    12.946     0.200
     2.828    13.704     0.200
     2.932    11.247     0.200
     3.228    12.659     0.200
     3.171    13.068     0.200
     3.171    12.538     0.200
     3.344    12.905     0.200
     3.372    13.501     0.200
     3.549    13.069     0.200
     3.549    14.159     0.200
     3.611    16.415     0.200
     3.690    13.687     0.200
     3.788    13.898     0.200
     3.967    13.646     0.200
     4.148    14.444     0.200
     4.176    14.131     0.200
     4.150    15.133     0.200
     4.424    14.586     0.200
     4.424    17.411     0.200
     4.464    14.732     0.200
     4.469    15.920     0.200
     4.868    15.947     0.200
     4.979    17.529     0.200
     5.031    17.440     0.200
     5.258    16.113     0.200
     5.287    17.264     0.200
     5.353    18.406     0.200
     5.603    17.294     0.200
     5.694    18.491     0.200
     5.688    18.382     0.200
     5.779    19.693     0.200
     7.076    22.047     0.200
     7.505    18.539     0.200
     7.438    23.273     0.200
     7.438    23.885     0.200
     7.438    23.434     0.200
     7.637    22.301     0.200
     7.638    22.057     0.200
     7.681    21.739     0.200
     7.681    27.258     0.200
     7.681    23.700     0.200
     7.681    26.999     0.200
     8.003    24.384     0.200
     8.003    22.499     0.200
     8.003    24.880     0.200
     8.003    24.540     0.200
     8.003    22.499     0.200
     8.568    26.773     0.200
     8.683    25.571     0.200
     8.793    26.725     0.200
     8.794    25.927     0.200
     8.820    23.314     0.200
    10.093    28.992     0.200
    10.961    34.224     0.200
    10.957    27.998     0.200
    11.838    30.503     0.200
    12.070    28.861     0.200
    12.373    32.891     0.200
    12.587    31.131     0.200
    12.797    32.588     0.200
    13.346    37.995     0.200
    13.328    32.370     0.200
    13.574    37.626     0.200
    13.734    31.618     0.200
    13.768    31.882     0.200
    14.489    34.620     0.200
    14.686    34.513     0.200
    14.692    32.930     0.200
    15.134    34.905     0.200
    15.164    36.799     0.200
    15.194    35.998     0.200
    15.397    35.770     0.200
    15.476    36.873     0.200
    15.544    37.338     0.200
    15.685    37.770     0.200
    16.253    38.591     0.200
    16.324    38.365     0.200
    18.176    38.910     0.200
    18.593    43.698     0.200
    18.593    44.223     0.200
    19.466    43.286     0.200
    20.362    42.509     0.200
     1.536     7.385     0.200
     1.935     8.725     0.200
     2.010     7.369     0.200
     1.997     9.254     0.200
     1.997     9.094     0.200
     2.564     7.923     0.200
     3.155     9.692     0.200
     3.540    13.953     0.200
     3.632    10.907     0.200
     3.682    13.784     0.200
     3.685    13.771     0.200
     5.589    17.259     0.200
     8.023    24.170     0.200
     8.794    22.676     0.200
    13.374    38.260     0.200
    18.622    44.281     0.200
     1.792     8.831     0.200
     1.946     9.209     0.200
     2.004     9.551     0.200
     2.025     9.163     0.200
     2.560     9.976     0.200
     2.788    13.046     0.200
     3.145    13.836     0.200
     3.583    13.857     0.200
     3.553    14.942     0.200
     5.038    20.249     0.200
     1.744     8.828     0.200
     1.921     9.504     0.200
     1.990     8.390     0.200
     1.992     9.723     0.200
     2.826    14.457     0.200
     2.826    14.296     0.200
     3.167    14.878     0.200
     3.524    14.633     0.200
     3.544    14.407     0.200
     3.684    15.701     0.200
     3.981    17.052     0.200
     5.024    19.522     0.200
     5.598    21.358     0.200
     7.998    26.433     0.200
     8.788    25.938     0.200
     9.374    32.223     0.200
    13.343    39.302     0.200
     2.683    12.555     0.200
     2.683    11.595     0.200
     3.347    14.703     0.200
     3.347    12.253     0.200
     3.397    11.960     0.200
     3.414    13.369     0.200
     3.669    16.216     0.200
     3.779    14.873     0.200
     1.792     8.310     0.200
     2.671    12.364     0.200
     2.671    12.555     0.200
     3.347    12.510     0.200
     3.435    14.174     0.200
     3.328    14.390     0.200
     3.328    12.469     0.200
     3.415    13.656     0.200
     3.770    14.909     0.200
     1.375     8.325     0.200
     1.447     7.475     0.200
     1.685     8.412     0.200
     1.685     8.889     0.200
     1.666    10.896     0.200
     1.884     9.430     0.200
     1.941     8.105     0.200
     1.834    10.640     0.200
     1.970     9.787     0.200
     1.970    10.060     0.200
     1.888    11.050     0.200
     2.212    10.758     0.200
     2.312    11.394     0.200
     2.585    12.172     0.200
     2.585    10.945     0.200
     2.805    13.318     0.200
     2.872    12.136     0.200
     2.878    13.161     0.200
     2.878    13.911     0.200
     2.878    15.818     0.200
     3.288    12.957     0.200
     3.202    12.792     0.200
     3.202    11.159     0.200
     3.325    13.633     0.200
     3.482    13.345     0.200
     3.502    14.347     0.200
     3.572    13.967     0.200
     3.660    13.872     0.200
     3.747    14.159     0.200
     3.698    14.615     0.200
     4.016    16.293     0.200
     4.121    15.756     0.200
     4.375    16.306     0.200
     4.375    18.041     0.200
     4.421    16.389     0.200
     4.395    16.067     0.200
     4.839    16.690     0.200
     5.017    16.323     0.200
     5.227    18.124     0.200
     5.305    18.937     0.200
     5.634    19.139     0.200
     5.744    20.471     0.200
     5.958    18.166     0.200
     5.986    18.365     0.200
     6.705    19.867     0.200
     6.743    22.000     0.200
     7.155    23.066     0.200
     7.348    20.901     0.200
     7.556    22.232     0.200
     7.622    23.344     0.200
     7.959    23.176     0.200
     7.959    24.520     0.200
     8.776    24.549     0.200
     8.764    25.461     0.200
     8.787    26.560     0.200
     8.788    27.027     0.200
     8.788    26.746     0.200
     8.845    27.828     0.200
     9.320    26.116     0.200
    10.902    31.908     0.200
    12.578    33.268     0.200
    13.286    36.918     0.200
    18.535    44.380     0.200
     1.667     9.443     0.200
     1.833     9.916     0.200
     1.972     8.234     0.200
     2.583    11.602     0.200
     3.202    13.174     0.200
     3.656    12.751     0.200
     3.695    14.096     0.200
     0.890     5.156     0.200
     1.407     7.827     0.200
     1.511     6.355     0.200
     1.749     7.874     0.200
     1.923     8.638     0.200
     1.923     8.896     0.200
     1.993     8.904     0.200
     1.993     9.521     0.200
     1.993     7.506     0.200
     2.273     9.959     0.200
     2.353     9.435     0.200
     2.567     9.502     0.200
     2.567    11.783     0.200
     2.862    10.032     0.200
     2.715    12.547     0.200
     2.937    11.343     0.200
     3.234    11.553     0.200
     3.165    13.056     0.200
     3.165    12.477     0.200
     3.350    12.067     0.200
     3.378    13.375     0.200
     3.527    12.617     0.200
     3.618    11.336     0.200
     3.549    12.691     0.200
     3.549    12.464     0.200
     3.685    14.117     0.200
     3.795    13.379     0.200
     3.902    13.725     0.200
     3.972    14.381     0.200
     4.183    15.344     0.200
     4.152    14.667     0.200
     4.483    15.910     0.200
     4.986    16.506     0.200
     5.777    18.592     0.200
     7.435    22.559     0.200
     7.634    22.529     0.200
     7.715    22.742     0.200
     8.003    23.512     0.200
     8.003    23.012     0.200
     8.679    24.896     0.200
     8.788    24.267     0.200
     8.789    25.172     0.200
    10.966    33.411     0.200
    13.349    38.492     0.200
    13.724    34.901     0.200
    15.342    38.065     0.200
    15.405    37.751     0.200
    15.457    37.624     0.200
    15.474    37.913     0.200
    15.540    37.049     0.200
    15.495    37.718     0.200
    15.676    38.355     0.200
    15.835    37.325     0.200
    15.830    35.611     0.200
    15.954    37.444     0.200
    16.251    38.408     0.200
    16.254    37.792     0.200
    16.639    38.950     0.200
    16.870    39.509     0.200
    18.598    43.682     0.200
     1.489     7.569     0.200
     1.728     8.453     0.200
     1.819     9.068     0.200
     1.903     9.473     0.200
     1.970     7.966     0.200
     1.977     9.985     0.200
     1.977     9.635     0.200
     2.581    10.410     0.200
     2.581     9.390     0.200
     3.185    13.339     0.200
     3.185    13.189     0.200
     3.505    14.480     0.200
     3.538    13.875     0.200
     3.676    14.967     0.200
     3.676    16.508     0.200
     3.697    13.910     0.200
     5.031    15.911     0.200
     5.615    17.529     0.200
     1.656     8.795     0.200
     1.882     9.702     0.200
     1.838    11.179     0.200
     1.948     8.415     0.200
     1.864    10.696     0.200
     1.960     9.754     0.200
     2.596    10.536     0.200
     3.205    14.320     0.200
     3.205    12.539     0.200
     3.484    11.330     0.200
     3.532    14.531     0.200
     3.683    15.528     0.200
     3.711    14.727     0.200
     5.039    18.307     0.200
     5.634    16.731     0.200
     0.945     5.675     0.200
     1.482     8.321     0.200
     1.653     9.942     0.200
     1.879     9.657     0.200
     1.843    10.600     0.200
     1.949     8.704     0.200
     1.952    10.074     0.200
     2.606    12.675     0.200
     2.865    14.340     0.200
     3.209    14.146     0.200
     3.573    16.292     0.200
     3.698    15.353     0.200
     3.698    16.591     0.200
     3.722    15.429     0.200
     8.005    24.259     0.200
     8.820    25.097     0.200
     9.337    31.295     0.200
    10.931    33.292     0.200
    13.325    38.232     0.200
     1.555     9.028     0.200
     1.586     9.727     0.200
     1.621     8.544     0.200
     1.866     9.373     0.200
     1.904    10.112     0.200
     1.904     9.971     0.200
     1.929     9.336     0.200
     1.929     9.477     0.200
     2.016     8.885     0.200
     2.650    12.368     0.200
     2.650    10.860     0.200
     2.793    13.080     0.200
     3.202    13.930     0.200
     3.614    11.893     0.200
     3.700    14.246     0.200
     3.777    14.854     0.200
     5.646    18.349     0.200
     8.155    25.368     0.200
     8.904    28.939     0.200
    11.053    34.856     0.200
     1.929     9.210     0.200
     2.003     7.456     0.200
     1.995     7.795     0.200
     2.565    12.103     0.200
     3.561    15.797     0.200
     3.534    14.543     0.200
     3.677    14.662     0.200
     3.677    15.982     0.200
     3.684    14.713     0.200
     5.592    21.200     0.200
     1.460     7.636     0.200
     1.559     7.091     0.200
     1.799     7.957     0.200
     1.925     9.484     0.200
     1.925     7.484     0.200
     2.011     5.982     0.200
     2.588    12.072     0.200
     2.588    10.122     0.200
     2.800    12.312     0.200
     3.168    13.744     0.200
     3.168     9.754     0.200
     3.534    12.677     0.200
     3.626     9.210     0.200
     3.606    13.168     0.200
     3.710    14.815     0.200
     3.715    13.693     0.200
     4.450    17.739     0.200
     8.059    23.647     0.200
     8.824    26.149     0.200
     9.406    30.535     0.200
    18.638    43.325     0.200
     1.436     7.705     0.200
     1.933     9.261     0.200
     1.991     9.483     0.200
     2.012     7.524     0.200
     2.571    10.055     0.200
     2.801    12.981     0.200
     3.158    12.571     0.200
     3.540    15.707     0.200
     3.583    14.528     0.200
     3.631    14.946     0.200
     1.650     9.634     0.200
     1.917    10.895     0.200
     1.917    10.665     0.200
     1.964     9.199     0.200
     2.011    10.631     0.200
     2.011    10.081     0.200
     2.343    11.647     0.200
     2.543    11.966     0.200
     2.543    10.716     0.200
     2.700    12.491     0.200
     2.868    10.966     0.200
     2.862    12.577     0.200
     2.862    14.428     0.200
     3.169    13.158     0.200
     3.227    11.412     0.200
     3.296    11.639     0.200
     3.346    11.692     0.200
     3.511    12.796     0.200
     3.466    13.646     0.200
     3.466    13.876     0.200
     3.601    14.375     0.200
     3.614    16.118     0.200
     3.774    13.023     0.200
     3.888    14.909     0.200
     3.912    14.048     0.200
     4.076    14.351     0.200
     4.971    18.098     0.200
     5.195    16.224     0.200
     5.215    17.068     0.200
     5.270    17.165     0.200
     5.592    19.445     0.200
     5.605    17.669     0.200
     5.701    18.193     0.200
     5.938    17.955     0.200
     6.995    21.438     0.200
     7.491    19.492     0.200
     7.370    25.172     0.200
     7.576    22.017     0.200
     7.655    22.423     0.200
     7.655    24.363     0.200
     7.921    26.262     0.200
     7.921    21.968     0.200
     8.620    23.998     0.200
     8.742    24.238     0.200
     8.743    27.704     0.200
     8.743    24.119     0.200
     8.808    23.043     0.200
    15.063    35.239     0.200
    15.420    35.869     0.200
    15.486    37.238     0.200
    15.880    36.949     0.200
    16.178    37.143     0.200
     1.420     7.683     0.200
     1.630    10.790     0.200
     1.741     8.310     0.200
     1.824    11.053     0.200
     1.900     7.943     0.200
     1.972     7.787     0.200
     1.969     9.176     0.200
     1.969     8.955     0.200
     2.590    10.256     0.200
     3.189    12.329     0.200
     3.504    12.910     0.200
     3.556    11.861     0.200
     3.595    14.666     0.200
     8.011    23.849     0.200
     8.810    25.604     0.200
     9.360    31.140     0.200
    13.343    37.913     0.200
    18.585    44.003     0.200
     1.107     6.923     0.200
     1.278     8.171     0.200
     1.550     9.021     0.200
     1.550     8.821     0.200
     4.190    17.516     0.200
     0.975     5.454     0.200
     1.312     7.330     0.200
     3.349    13.413     0.200
     3.399    15.124     0.200
     3.805    15.524     0.200
     1.196     8.459     0.200
     1.753     8.937     0.200
     1.752     9.775     0.200
     1.908     9.123     0.200
     1.908     9.633     0.200
     2.663    12.374     0.200
     3.325    10.817     0.200
     3.408    13.985     0.200
     3.619    16.096     0.200
     3.752    14.689     0.200
     4.980    16.334     0.200
     1.206     8.245     0.200
     1.762     9.312     0.200
     1.771     9.851     0.200
     1.934    10.462     0.200
     1.934     9.911     0.200
     1.884    11.411     0.200
     1.958    12.375     0.200
     2.185     9.927     0.200
     2.612    10.964     0.200
     2.651    11.307     0.200
     2.642    11.233     0.200
     2.642    12.526     0.200
     3.051    12.520     0.200
     3.072    12.359     0.200
     3.136    12.192     0.200
     3.094    12.239     0.200
     3.336    13.024     0.200
     3.336    13.813     0.200
     3.293    13.125     0.200
     3.293    15.504     0.200
     3.421    15.657     0.200
     3.336    13.993     0.200
     3.585    13.097     0.200
     3.659    13.339     0.200
     3.588    14.535     0.200
     3.716    13.248     0.200
     3.803    13.615     0.200
     3.728    15.643     0.200
     3.823    13.840     0.200
     3.881    13.507     0.200
     3.969    13.793     0.200
     3.989    14.388     0.200
     4.178    17.834     0.200
     4.182    14.869     0.200
     4.170    14.757     0.200
     4.303    14.888     0.200
     4.310    14.659     0.200
     4.618    15.494     0.200
     4.671    16.229     0.200
     4.609    15.243     0.200
     4.698    16.073     0.200
     4.664    15.687     0.200
     4.717    16.306     0.200
     4.939    16.281     0.200
     4.963    17.131     0.200
     4.950    19.364     0.200
     5.090    16.997     0.200
     7.305    24.561     0.200
     7.756    24.818     0.200
     7.756    25.717     0.200
     7.752    27.290     0.200
     8.265    28.337     0.200
     9.096    30.618     0.200
    10.647    33.794     0.200
    13.022    37.278     0.200
    13.397    38.714     0.200
    15.029    34.388     0.200
    15.023    36.080     0.200
    15.033    35.767     0.200
    15.058    35.542     0.200
    15.115    36.195     0.200
    15.161    35.528     0.200
    15.212    36.638     0.200
    15.310    36.067     0.200
    15.348    36.678     0.200
    15.298    36.397     0.200
    15.306    36.632     0.200
    15.405    36.838     0.200
    15.433    36.446     0.200
    15.438    37.002     0.200
    15.471    36.679     0.200
    15.498    36.743     0.200
    15.673    36.680     0.200
    15.656    38.021     0.200
    15.753    37.323     0.200
    15.913    37.702     0.200
    16.544    37.882     0.200
    16.467    37.551     0.200
    16.637    38.373     0.200
    16.712    37.830     0.200
    16.844    38.288     0.200
    16.862    37.898     0.200
    17.071    37.921     0.200
    17.362    39.013     0.200
    17.436    38.857     0.200
    17.505    38.859     0.200
    17.550    39.302     0.200
    17.612    39.729     0.200
    17.735    38.919     0.200
    17.822    40.127     0.200
    18.083    38.759     0.200
    18.105    39.248     0.200
    19.189    44.580     0.200
    20.161    43.074     0.200
     1.741     8.500     0.200
     1.896     8.264     0.200
     1.896     9.245     0.200
     3.329    13.018     0.200
     4.991    17.001     0.200
     0.884     5.682     0.200
     1.023     7.598     0.200
     1.318     7.318     0.200
     1.371     7.289     0.200
     1.608     8.494     0.200
     1.860     9.782     0.200
     1.860     9.438     0.200
     1.897     8.574     0.200
     1.970    10.075     0.200
     1.055     6.270     0.200
     1.478     9.104     0.200
     1.515     9.584     0.200
     1.613    10.747     0.200
     2.648     9.579     0.200
     2.727    12.441     0.200
     3.291    10.041     0.200
     7.730    23.485     0.200
     8.398    28.195     0.200
     9.212    25.479     0.200
     1.537     5.983     0.200
     2.960     9.087     0.200
     3.266    12.495     0.200
     4.022    14.477     0.200
     2.244     8.332     0.200
     3.271    11.062     0.200
     3.078    11.854     0.200
     1.209     8.044     0.200
     1.273     7.631     0.200
     1.428     8.186     0.200
     1.739     8.310     0.200
     1.740     8.831     0.200
     1.740     8.612     0.200
     1.899     9.120     0.200
     1.897    10.859     0.200
     2.674     9.922     0.200
     3.309    12.464     0.200
     3.395    13.593     0.200
     3.362    12.553     0.200
     1.164     7.955     0.200
     1.164     7.736     0.200
     1.233     7.193     0.200
     1.290     7.755     0.200
     1.474     7.941     0.200
     1.762     9.667     0.200
     1.762     9.126     0.200
     1.773     8.392     0.200
     1.856    10.905     0.200
     1.907     9.680     0.200
     1.958    11.299     0.200
     2.659    12.978     0.200
     2.659    10.699     0.200
     3.338    13.399     0.200
     3.354    12.882     0.200
     3.335    14.361     0.200
     3.335    11.592     0.200
     3.424    15.622     0.200
     3.631    14.640     0.200
     3.751    14.678     0.200
     4.196    18.354     0.200
     7.817    23.637     0.200
     8.792    26.920     0.200
     9.124    28.983     0.200
    13.077    37.063     0.200
     1.450     7.878     0.200
     1.735     8.860     0.200
     3.300    14.235     0.200
     3.354    13.743     0.200
     3.372    12.874     0.200
     1.302     7.269     0.200
     1.388     7.601     0.200
     1.399     8.134     0.200
     1.683     8.618     0.200
     1.683     8.821     0.200
     2.106    11.200     0.200
     2.899    13.938     0.200
     2.977    13.833     0.200
     3.027    14.936     0.200
     3.180    11.781     0.200
     8.606    29.458     0.200
    10.181    31.602     0.200
    12.637    36.982     0.200
     1.184     6.883     0.200
     1.209     7.377     0.200
     1.392     7.861     0.200
     1.406     7.967     0.200
     1.436     8.427     0.200
     1.669     8.801     0.200
     2.225     9.677     0.200
     2.975    12.935     0.200
     2.971    12.159     0.200
     3.279    11.854     0.200
     1.686     8.319     0.200
     2.301    10.800     0.200
     2.995    11.507     0.200
     2.951    10.958     0.200
     2.951    13.079     0.200
     3.078    12.173     0.200
     4.015    14.136     0.200
     1.722     8.932     0.200
     3.026    11.906     0.200
     2.917    11.746     0.200
     3.249     9.891     0.200
     1.284     6.689     0.200
     1.294     7.288     0.200
     1.522     6.938     0.200
     1.802     8.397     0.200
     1.802     8.237     0.200
     1.821     6.749     0.200
     1.934     8.670     0.200
     1.934     8.449     0.200
     1.804     8.902     0.200
     1.915    10.352     0.200
     2.055     8.802     0.200
     2.222     9.121     0.200
     2.723    10.571     0.200
     2.571    12.102     0.200
     2.710    10.212     0.200
     2.626    10.871     0.200
     2.626    10.133     0.200
     2.626    11.133     0.200
     3.137    12.260     0.200
     3.016     9.900     0.200
     3.201    11.510     0.200
     3.291    12.726     0.200
     3.379    12.372     0.200
     3.379    11.411     0.200
     3.379    12.671     0.200
     3.469    15.016     0.200
     3.469     9.137     0.200
     3.638    12.364     0.200
     3.623    14.302     0.200
     3.752    13.889     0.200
     3.946    13.354     0.200
     3.925    13.800     0.200
     4.024    15.183     0.200
     4.047    14.491     0.200
     4.246    14.716     0.200
     4.246    15.368     0.200
     4.269    15.078     0.200
     4.269    14.617     0.200
     4.268    14.818     0.200
     4.387    16.104     0.200
     4.775    16.269     0.200
     4.685    15.876     0.200
     4.765    16.526     0.200
     4.983    17.547     0.200
     4.983    16.887     0.200
     5.346    18.826     0.200
     5.634    17.304     0.200
     5.701    17.113     0.200
     5.799    20.025     0.200
     6.137    19.080     0.200
     7.356    23.034     0.200
     7.356    22.663     0.200
     7.582    23.451     0.200
     7.840    23.707     0.200
     7.840    23.816     0.200
     7.840    21.951     0.200
     7.831    21.055     0.200
     8.248    22.224     0.200
     8.363    23.683     0.200
     8.363    23.972     0.200
     8.363    27.202     0.200
     8.776    26.392     0.200
     8.776    25.891     0.200
     8.776    26.090     0.200
     8.776    25.874     0.200
     8.877    25.143     0.200
     8.916    23.796     0.200
     9.093    25.800     0.200
     9.165    23.253     0.200
     9.177    27.812     0.200
     9.760    26.258     0.200
     9.972    27.257     0.200
    10.149    26.380     0.200
    10.059    26.438     0.200
    10.497    29.061     0.200
    10.742    33.340     0.200
    10.742    29.949     0.200
    10.738    27.948     0.200
    10.902    28.553     0.200
    11.779    31.255     0.200
    12.308    31.636     0.200
    12.344    34.872     0.200
    12.557    31.831     0.200
    13.124    34.855     0.200
    13.498    34.458     0.200
    13.461    35.613     0.200
    13.461    34.723     0.200
    13.735    36.006     0.200
    13.814    36.493     0.200
    13.898    34.208     0.200
    14.556    36.228     0.200
    14.773    37.220     0.200
    14.694    38.058     0.200
    14.871    37.135     0.200
    14.887    37.606     0.200
    14.920    37.923     0.200
    15.045    36.226     0.200
    15.045    38.904     0.200
    15.128    39.281     0.200
    15.217    37.674     0.200
    15.312    38.507     0.200
    15.363    37.378     0.200
    15.280    39.199     0.200
    15.297    37.000     0.200
    15.316    39.192     0.200
    15.374    40.594     0.200
    15.513    38.955     0.200
    15.504    39.564     0.200
    15.504    40.674     0.200
    15.504    39.375     0.200
    15.763    38.721     0.200
    16.013    37.491     0.200
    16.135    38.282     0.200
    16.273    37.610     0.200
    16.472    39.963     0.200
    16.452    37.896     0.200
    16.530    38.672     0.200
    16.755    39.587     0.200
    16.717    38.561     0.200
    16.862    38.478     0.200
    17.608    40.010     0.200
    17.721    40.589     0.200
    17.820    40.210     0.200
    18.005    39.799     0.200
    18.069    39.713     0.200
    18.376    39.687     0.200
    20.232    41.042     0.200
     1.235     6.973     0.200
     1.288     7.323     0.200
     1.475     8.004     0.200
     1.475     7.254     0.200
     1.765     8.341     0.200
     1.765     8.031     0.200
     1.775     7.429     0.200
     1.854     9.805     0.200
     1.910     8.689     0.200
     1.910     9.039     0.200
     1.955     9.982     0.200
     2.013     8.991     0.200
     2.183     9.220     0.200
     2.661    10.769     0.200
     2.674    10.777     0.200
     2.529    11.952     0.200
     2.656    10.121     0.200
     2.656    10.721     0.200
     3.070    11.636     0.200
     3.087    10.468     0.200
     3.065    13.708     0.200
     3.154    11.731     0.200
     3.340    12.134     0.200
     3.332    11.986     0.200
     3.354    10.898     0.200
     3.354    13.058     0.200
     3.427    12.217     0.200
     3.594    13.311     0.200
     3.701    11.588     0.200
     3.720    13.430     0.200
     3.877    13.009     0.200
     3.899    13.798     0.200
     3.980    14.854     0.200
     4.041    14.569     0.200
     4.199    13.781     0.200
     4.198    15.597     0.200
     4.219    14.247     0.200
     4.232    14.902     0.200
     4.317    15.251     0.200
     4.724    14.850     0.200
     4.987    16.402     0.200
     5.017    15.375     0.200
     5.738    19.602     0.200
     5.756    18.303     0.200
     6.164    20.930     0.200
     6.426    20.916     0.200
     6.497    20.262     0.200
     6.802    21.951     0.200
     6.775    21.009     0.200
     6.906    21.201     0.200
     6.905    20.643     0.200
     6.941    20.458     0.200
     7.022    21.261     0.200
     7.344    21.195     0.200
     7.354    22.670     0.200
     7.354    23.629     0.200
     7.438    21.273     0.200
     7.587    23.563     0.200
     7.709    21.927     0.200
     7.817    23.369     0.200
     7.817    22.535     0.200
     7.817    25.426     0.200
     8.090    24.591     0.200
     8.326    25.983     0.200
     8.589    25.499     0.200
     8.629    25.750     0.200
     8.740    26.151     0.200
     8.789    26.683     0.200
     8.789    25.800     0.200
     8.789    27.681     0.200
     8.790    25.823     0.200
     8.790    26.381     0.200
     9.126    28.349     0.200
     9.355    24.947     0.200
     9.528    26.999     0.200
    10.068    29.405     0.200
    10.101    31.195     0.200
    10.692    31.424     0.200
    10.692    26.732     0.200
    10.907    30.864     0.200
    11.743    33.630     0.200
    12.051    32.376     0.200
    12.381    32.320     0.200
    13.079    36.342     0.200
    13.079    31.641     0.200
    13.448    36.346     0.200
    13.451    35.304     0.200
    13.475    34.937     0.200
    14.284    36.268     0.200
    14.567    36.492     0.200
    14.839    35.466     0.200
    15.068    38.441     0.200
    15.184    37.486     0.200
    15.313    36.787     0.200
    15.352    36.209     0.200
    15.395    37.239     0.200
    15.511    38.909     0.200
    15.511    40.429     0.200
    15.712    34.780     0.200
    15.973    36.467     0.200
    16.209    38.867     0.200
    16.705    37.741     0.200
    16.905    39.232     0.200
    16.923    39.067     0.200
    17.563    38.433     0.200
    17.667    40.018     0.200
    17.770    39.836     0.200
    18.115    39.887     0.200
    18.325    39.523     0.200
    19.251    42.110     0.200
    20.218    41.145     0.200
     1.307     6.707     0.200
     1.327     7.622     0.200
     1.548     7.581     0.200
     1.792     7.983     0.200
     1.822     6.891     0.200
     1.915     8.675     0.200
     1.915     8.796     0.200
     2.643    12.540     0.200
     3.378    13.869     0.200
     3.298    12.801     0.200
     3.465     9.914     0.200
     3.413    12.643     0.200
     4.250    18.156     0.200
     7.875    23.112     0.200
     8.802    25.002     0.200
     9.186    27.630     0.200
    10.761    30.008     0.200
    13.151    36.077     0.200
     1.176     7.876     0.200
     1.176     8.306     0.200
     1.746     9.780     0.200
     1.746    10.733     0.200
     1.757    10.200     0.200
     1.893    10.295     0.200
     1.893    10.744     0.200
     1.871    10.689     0.200
     1.974    11.049     0.200
     2.674    12.411     0.200
     3.356    13.291     0.200
     3.642    16.043     0.200
     3.766    14.587     0.200
     5.003    18.064     0.200
     0.942     6.770     0.200
     1.145     6.320     0.200
     1.756     9.441     0.200
     1.756     9.593     0.200
     1.776     8.454     0.200
     1.845    10.287     0.200
     1.892     9.811     0.200
     1.892     9.670     0.200
     2.670    12.535     0.200
     3.337    12.203     0.200
     3.385    15.481     0.200
     3.337    14.008     0.200
     3.424    11.711     0.200
     4.203    17.257     0.200
     7.848    21.488     0.200
     8.813    22.676     0.200
     9.136    28.570     0.200
    10.709    31.827     0.200
    13.104    36.672     0.200
     2.675    10.242     0.200
     3.344    12.081     0.200
     3.329    12.552     0.200
     3.379    13.815     0.200
     1.169     6.876     0.200
     1.226     8.391     0.200
     1.262     7.648     0.200
     1.730     9.439     0.200
     1.737     9.111     0.200
     1.737     9.461     0.200
     1.902    10.380     0.200
     1.902     9.810     0.200
     4.148    17.117     0.200
     7.769    22.828     0.200
     8.785    25.804     0.200
     9.070    28.353     0.200
    10.628    32.418     0.200
    13.013    36.473     0.200
     0.940     6.281     0.200
     1.267     7.957     0.200
     1.236     7.489     0.200
     1.401     8.566     0.200
     1.718     8.658     0.200
     1.726     9.922     0.200
     1.726     9.541     0.200
     1.892    10.560     0.200
     1.892     9.429     0.200
     1.922    12.163     0.200
     2.003    10.869     0.200
     3.291    12.774     0.200
     3.305    14.576     0.200
     3.381    15.218     0.200
     7.769    24.165     0.200
     8.793    25.469     0.200
     1.055     5.581     0.200
     1.475     8.374     0.200
     1.475     8.785     0.200
     1.516     8.937     0.200
     1.615     7.191     0.200
     2.648    11.475     0.200
     2.656    12.356     0.200
     3.295    13.524     0.200
     1.193     7.928     0.200
     1.406     8.107     0.200
     1.452     8.661     0.200
     1.391     9.170     0.200
     1.530     8.950     0.200
     1.530     9.399     0.200
     1.685     9.461     0.200
     1.685     9.311     0.200
     2.307    11.799     0.200
     3.071    12.908     0.200
     0.886     6.407     0.200
     1.144     6.565     0.200
     1.182     8.108     0.200
     1.182     7.718     0.200
     1.154     7.858     0.200
     1.448     8.790     0.200
     1.465    10.130     0.200
     1.622    10.547     0.200
     1.732    10.615     0.200
     1.732    10.358     0.200
     2.576    12.174     0.200
     3.382    11.298     0.200
     4.286    15.883     0.200
     9.220    29.984     0.200
     1.220     6.691     0.200
     1.342     8.236     0.200
     1.352     8.150     0.200
     1.360     8.443     0.200
     1.385     7.314     0.200
     1.397     8.168     0.200
     1.386     7.909     0.200
     1.593     8.968     0.200
     1.593     8.298     0.200
     1.594     8.831     0.200
     1.626     7.644     0.200
     1.748     7.500     0.200
     1.748     7.240     0.200
     1.995     9.683     0.200
     2.117     9.836     0.200
     2.117     9.105     0.200
     2.173     9.133     0.200
     2.246    10.385     0.200
     2.285     9.749     0.200
     2.336    10.462     0.200
     2.474    10.160     0.200
     2.646    10.508     0.200
     2.685    11.384     0.200
     2.728    11.052     0.200
     2.749    11.100     0.200
     2.749    12.300     0.200
     2.847    11.748     0.200
     2.938    10.549     0.200
     3.148    11.789     0.200
     3.264    12.168     0.200
     3.509    12.671     0.200
     3.805    14.175     0.200
     3.806    14.149     0.200
     3.853    16.272     0.200
     4.531    17.406     0.200
     4.718    17.861     0.200
     5.602    16.630     0.200
     6.929    19.818     0.200
     7.543    22.220     0.200
     7.629    22.719     0.200
     9.251    26.518     0.200
     9.279    25.785     0.200
     9.484    27.804     0.200
     1.342     8.721     0.200
     1.337     8.663     0.200
     1.337     9.552     0.200
     1.378     8.615     0.200
     1.419     8.340     0.200
     1.506     8.569     0.200
     1.506     8.059     0.200
     1.481     9.620     0.200
     2.428    13.243     0.200
     2.963    12.940     0.200
     3.060    13.030     0.200
     3.178    14.190     0.200
     1.082     6.699     0.200
     1.209     8.567     0.200
     1.209     6.657     0.200
     3.135     9.765     0.200
     3.900    18.262     0.200
     5.259    16.126     0.200
     1.196     6.845     0.200
     1.545     8.214     0.200
     1.545     8.884     0.200
     1.526    10.290     0.200
     1.655     8.575     0.200
     2.783    10.482     0.200
     3.151    11.673     0.200
     3.290    13.192     0.200
     0.972     5.117     0.200
     1.195     7.571     0.200
     1.195     8.430     0.200
     1.312     7.463     0.200
     1.358     7.022     0.200
     1.356     7.764     0.200
     1.416     7.552     0.200
     1.472     7.733     0.200
     1.567     7.995     0.200
     2.084     9.582     0.200
     2.122     8.918     0.200
     2.251    10.002     0.200
     2.223     9.518     0.200
     2.306    10.059     0.200
     2.440    10.184     0.200
     2.464    10.625     0.200
     2.484    10.327     0.200
     2.612    10.557     0.200
     2.678     9.965     0.200
     2.702    10.783     0.200
     2.816    10.905     0.200
     2.904    10.346     0.200
     5.581    18.441     0.200
     5.626    19.184     0.200
     5.894    20.041     0.200
     7.599    22.026     0.200
     9.228    27.121     0.200
     9.515    26.222     0.200
    11.864    34.833     0.200
    12.175    35.912     0.200
    15.370    36.062     0.200
    15.395    36.782     0.200
    16.856    36.989     0.200
    17.049    38.067     0.200
     0.945     4.691     0.200
     1.283     7.285     0.200
     1.331     6.690     0.200
     1.337     8.903     0.200
     1.423     7.227     0.200
     1.540     7.604     0.200
     2.061     8.900     0.200
     2.116     8.431     0.200
     2.198     9.342     0.200
     2.225     9.192     0.200
     2.277     9.762     0.200
     2.412    10.163     0.200
     2.585    11.302     0.200
     2.662    10.884     0.200
     2.674    10.084     0.200
     2.687    10.180     0.200
     2.787    11.599     0.200
     2.876    11.625     0.200
     3.186    11.614     0.200
     3.176    11.114     0.200
     3.295    12.614     0.200
     3.569    13.225     0.200
     3.777    13.232     0.200
     3.797    14.203     0.200
     3.854    12.953     0.200
     4.245    13.593     0.200
     4.503    16.591     0.200
     4.897    16.557     0.200
     5.176    17.997     0.200
     5.611    19.057     0.200
     5.917    19.869     0.200
     1.014     5.998     0.200
     1.084     6.707     0.200
     1.250     8.110     0.200
     1.250     7.458     0.200
     1.331     8.568     0.200
     1.370     7.584     0.200
     1.409     7.436     0.200
     1.494     8.734     0.200
     1.543     8.699     0.200
     1.578     8.842     0.200
     1.832     7.354     0.200
     2.188     9.195     0.200
     2.297    10.200     0.200
     2.325    10.147     0.200
     2.712    11.401     0.200
     2.840    12.261     0.200
     3.114    11.679     0.200
     3.114    14.917     0.200
     1.036     7.656     0.200
     1.067     7.775     0.200
     1.224     8.435     0.200
     1.344     7.840     0.200
     1.464     8.411     0.200
     1.515     8.475     0.200
     2.155     7.090     0.200
     2.203    10.514     0.200
     2.263     9.950     0.200
     2.687    11.401     0.200
     3.137    10.319     0.200
     0.802     4.729     0.200
     0.987     5.353     0.200
     1.183     6.579     0.200
     1.197     6.939     0.200
     1.197     6.228     0.200
     1.312     7.252     0.200
     1.357     7.471     0.200
     1.358     6.822     0.200
     1.349     6.715     0.200
     1.357     7.315     0.200
     1.414     7.243     0.200
     1.472     7.412     0.200
     1.527     7.340     0.200
     1.567     7.636     0.200
     1.593     6.563     0.200
     1.791     6.400     0.200
     1.840     7.410     0.200
     2.086     8.324     0.200
     2.141     8.683     0.200
     2.150     8.741     0.200
     2.223     9.451     0.200
     2.306     9.868     0.200
     2.441     9.996     0.200
     2.466    10.649     0.200
     2.484     9.613     0.200
     2.670    10.762     0.200
     2.701    10.568     0.200
     2.717     9.602     0.200
     2.716     9.330     0.200
     3.166    11.419     0.200
     3.166    12.138     0.200
     3.166    12.419     0.200
     3.240    11.717     0.200
     3.590    13.161     0.200
     3.805    13.822     0.200
     3.857    12.819     0.200
     3.886    12.489     0.200
     3.886    12.926     0.200
     4.311    13.497     0.200
     4.380    16.077     0.200
     4.370    14.974     0.200
     4.519    16.375     0.200
     4.590    14.728     0.200
     4.713    17.268     0.200
     4.766    14.768     0.200
     4.735    16.014     0.200
     4.785    16.063     0.200
     4.918    16.751     0.200
     5.046    16.918     0.200
     5.444    16.411     0.200
     5.630    18.630     0.200
     5.700    18.142     0.200
     5.940    19.237     0.200
     6.151    20.103     0.200
     6.704    19.792     0.200
     6.784    18.719     0.200
     7.041    20.674     0.200
     7.250    20.797     0.200
     7.476    24.092     0.200
     7.476    23.264     0.200
     7.471    22.660     0.200
     7.471    21.761     0.200
     7.471    22.324     0.200
     7.599    21.127     0.200
     7.848    23.100     0.200
     8.096    23.837     0.200
     8.439    24.604     0.200
     8.747    26.849     0.200
     8.888    29.484     0.200
     9.104    26.519     0.200
     9.227    26.929     0.200
     9.247    25.794     0.200
     9.306    27.088     0.200
     9.512    26.305     0.200
     9.513    26.569     0.200
     9.513    26.327     0.200
     9.939    28.252     0.200
    10.085    28.996     0.200
    10.094    27.264     0.200
    10.673    29.893     0.200
    11.373    27.213     0.200
    11.795    31.987     0.200
    11.863    29.149     0.200
    12.018    33.857     0.200
    12.175    32.573     0.200
    12.260    30.580     0.200
    12.559    31.121     0.200
    12.562    31.566     0.200
    13.038    31.325     0.200
    13.153    33.441     0.200
    13.179    36.004     0.200
    13.717    37.080     0.200
    13.892    32.655     0.200
    14.199    33.855     0.200
    14.215    33.210     0.200
    14.223    35.279     0.200
    14.345    35.653     0.200
    14.414    34.389     0.200
    14.419    36.493     0.200
    14.489    33.156     0.200
    14.519    38.348     0.200
    14.589    35.437     0.200
    14.722    35.370     0.200
    14.964    35.376     0.200
    14.986    36.072     0.200
    15.001    35.843     0.200
    15.722    39.022     0.200
    16.037    38.898     0.200
    16.037    37.148     0.200
    16.288    38.883     0.200
    16.695    39.355     0.200
    17.229    39.207     0.200
    18.058    39.033     0.200
    18.319    39.059     0.200
    18.577    42.621     0.200
    19.021    40.685     0.200
    19.865    39.663     0.200
    20.071    40.434     0.200
     0.958     5.121     0.200
     1.053     8.669     0.200
     1.321     9.180     0.200
     1.331     7.306     0.200
     1.356     8.625     0.200
     1.401     9.280     0.200
     1.447     7.764     0.200
     1.500     7.750     0.200
     1.539     8.019     0.200
     2.078     8.943     0.200
     2.103    10.800     0.200
     2.194    10.462     0.200
     2.241     9.438     0.200
     2.281    10.133     0.200
     2.423    11.177     0.200
     2.461    12.229     0.200
     2.599    10.439     0.200
     2.648    10.595     0.200
     2.674    11.351     0.200
     2.792    11.885     0.200
     2.889    12.905     0.200
     3.125    12.752     0.200
     3.155    12.568     0.200
     3.211    13.133     0.200
     3.308    13.309     0.200
     3.561    13.998     0.200
     3.780    14.051     0.200
     3.857    13.725     0.200
     4.253    15.532     0.200
     4.353    16.318     0.200
     4.491    17.702     0.200
     4.686    16.466     0.200
     4.888    17.970     0.200
     4.980    17.393     0.200
     5.554    16.194     0.200
     5.598    18.801     0.200
     5.601    19.295     0.200
     5.690    18.327     0.200
     5.865    19.926     0.200
     5.910    20.245     0.200
     6.042    20.762     0.200
     6.121    20.874     0.200
     6.122    20.541     0.200
     6.689    22.092     0.200
     6.978    22.521     0.200
     7.217    21.895     0.200
     8.172    26.770     0.200
     1.232     8.335     0.200
     1.278     7.995     0.200
     1.292     8.433     0.200
     1.319     8.800     0.200
     1.392     8.360     0.200
     1.446     8.417     0.200
     1.419     8.295     0.200
     1.487     8.823     0.200
     2.032     9.996     0.200
     2.146     9.984     0.200
     2.190    10.127     0.200
     2.226    10.786     0.200
     2.368    10.684     0.200
     2.622    11.982     0.200
     2.621    13.572     0.200
     2.641    12.795     0.200
     2.737    12.501     0.200
     2.835    13.327     0.200
     3.174    13.081     0.200
     3.254    14.786     0.200
     3.519    13.917     0.200
     3.765    14.527     0.200
     4.459    15.658     0.200
     4.663    16.228     0.200
     0.923     5.561     0.200
     1.050     6.653     0.200
     1.050     7.559     0.200
     1.250     7.999     0.200
     1.296     7.754     0.200
     1.301     8.154     0.200
     1.331     9.292     0.200
     1.331     9.065     0.200
     1.411     8.365     0.200
     1.464     8.217     0.200
     1.412     8.292     0.200
     1.505     8.669     0.200
     2.048     9.573     0.200
     2.162    10.287     0.200
     2.207     9.164     0.200
     2.244    10.434     0.200
     2.386    11.415     0.200
     2.565    10.825     0.200
     2.639    11.391     0.200
     2.629    11.290     0.200
     2.660    12.095     0.200
     3.167    12.512     0.200
     3.167    12.035     0.200
     4.469    15.578     0.200
     4.670    16.294     0.200
     4.758    15.250     0.200
     0.951     5.357     0.200
     1.047     7.054     0.200
     1.348     7.628     0.200
     1.408     8.214     0.200
     1.535     7.706     0.200
     2.070     9.614     0.200
     2.096    10.225     0.200
     2.191     9.374     0.200
     2.233     9.756     0.200
     2.276    10.146     0.200
     2.416     9.939     0.200
     2.455    10.166     0.200
     2.592     9.938     0.200
     2.670    11.046     0.200
     2.690    11.382     0.200
     2.649    11.844     0.200
     2.786    11.186     0.200
     3.161    12.690     0.200
     3.560    12.953     0.200
     4.491    16.960     0.200
     4.688    14.537     0.200
     4.887    15.917     0.200
     4.977    16.616     0.200
     5.165    17.523     0.200
     5.594    16.111     0.200
     5.601    17.811     0.200
     5.697    17.345     0.200
     5.909    18.781     0.200
     1.197     6.961     0.200
     1.567     8.583     0.200
     2.001    10.373     0.200
     2.788    13.125     0.200
     2.869    12.408     0.200
     3.142    13.067     0.200
     3.263    10.926     0.200
     5.256    16.396     0.200
     1.102     6.454     0.200
     1.222     6.653     0.200
     1.327     8.696     0.200
     1.349     7.084     0.200
     1.457     7.549     0.200
     1.614     8.042     0.200
     1.676     8.236     0.200
     1.924    11.508     0.200
     2.275    11.076     0.200
     2.335    11.168     0.200
     2.770    11.986     0.200
     3.083    11.076     0.200
     3.083    14.146     0.200
     0.554     3.669     0.200
     1.068     6.688     0.200
     1.249     6.893     0.200
     1.417     6.710     0.200
     1.433     6.991     0.200
     1.635     8.441     0.200
     1.603     6.641     0.200
     2.003     8.942     0.200
     2.053     9.349     0.200
     2.093     9.283     0.200
     2.172     8.109     0.200
     2.322     9.172     0.200
     2.353    10.289     0.200
     2.508    11.531     0.200
     2.579     9.736     0.200
     2.567     9.635     0.200
     2.593    11.803     0.200
     2.655    11.036     0.200
     2.684    10.956     0.200
     3.080    10.123     0.200
     3.173     9.194     0.200
     3.468    12.416     0.200
     3.689    12.157     0.200
     3.733    12.202     0.200
     4.142    14.234     0.200
     4.414    14.140     0.200
     4.625    13.344     0.200
     4.800    15.614     0.200
     5.085    16.401     0.200
     5.814    18.068     0.200
     1.270     7.347     0.200
     1.251     8.107     0.200
     1.443     8.405     0.200
     1.529     7.774     0.200
     1.579     7.726     0.200
     1.520     7.683     0.200
     1.788     8.079     0.200
     1.903     9.729     0.200
     2.327    10.763     0.200
     2.417    10.336     0.200
     2.439    11.248     0.200
     2.525    11.194     0.200
     2.785    10.748     0.200
     2.848    13.252     0.200
     2.919    12.528     0.200
     2.922    12.641     0.200
     2.989    13.502     0.200
     3.089    13.541     0.200
     3.175    15.027     0.200
     3.647    14.794     0.200
     3.936    14.828     0.200
     4.051    15.986     0.200
     4.316    17.694     0.200
     4.471    17.077     0.200
     4.620    18.068     0.200
     4.700    17.729     0.200
     4.824    17.089     0.200
     5.377    19.116     0.200
     1.256     7.173     0.200
     1.444     7.366     0.200
     1.519     7.382     0.200
     1.520     8.071     0.200
     1.772     8.141     0.200
     1.887     8.551     0.200
     2.214     9.444     0.200
     2.277     8.715     0.200
     2.311     9.691     0.200
     2.402     9.987     0.200
     2.425     8.759     0.200
     2.621    10.279     0.200
     2.682     8.863     0.200
     2.771    11.203     0.200
     2.903    11.154     0.200
     3.074    11.240     0.200
     3.178    11.142     0.200
     3.178    11.482     0.200
     3.336    11.869     0.200
     3.493    12.455     0.200
     3.644    12.979     0.200
     3.681    13.938     0.200
     3.784    12.631     0.200
     3.829    14.150     0.200
     3.930    14.383     0.200
     4.324    14.558     0.200
     4.455    15.824     0.200
     4.624    15.645     0.200
     4.824    16.920     0.200
     4.879    15.975     0.200
     4.910    15.831     0.200
     5.104    17.237     0.200
     5.550    17.019     0.200
     1.172     8.005     0.200
     1.280     7.003     0.200
     1.382     9.274     0.200
     1.439     7.790     0.200
     1.535     7.663     0.200
     1.799     8.266     0.200
     1.916     7.830     0.200
     2.240     9.671     0.200
     2.304    11.069     0.200
     2.449     9.938     0.200
     2.430    10.337     0.200
     2.537    11.796     0.200
     2.650    10.799     0.200
     2.711    10.835     0.200
     2.798    11.787     0.200
     2.933    11.355     0.200
     2.932    11.540     0.200
     3.102    11.630     0.200
     3.169    12.119     0.200
     3.365    13.103     0.200
     3.709    13.410     0.200
     3.938    13.767     0.200
     4.064    14.509     0.200
     4.820    16.635     0.200
     1.185     5.609     0.200
     1.299     6.697     0.200
     1.260     8.269     0.200
     1.450     7.321     0.200
     1.390     7.157     0.200
     1.554     7.558     0.200
     1.513     8.261     0.200
     1.482     9.060     0.200
     1.817     8.351     0.200
     1.928     8.069     0.200
     2.248    10.369     0.200
     2.312     9.468     0.200
     2.354     9.416     0.200
     2.468     9.423     0.200
     2.440     9.738     0.200
     2.555     9.847     0.200
     2.663    10.254     0.200
     2.727     9.646     0.200
     2.871    10.670     0.200
     2.809    10.358     0.200
     2.952    10.600     0.200
     2.946    10.734     0.200
     2.946     9.860     0.200
     3.017    10.656     0.200
     3.060    11.065     0.200
     3.177    11.818     0.200
     3.114    12.095     0.200
     3.380    11.825     0.200
     3.464    11.019     0.200
     3.533    12.863     0.200
     3.660    12.787     0.200
     3.824    12.856     0.200
     7.847    20.325     0.200
    12.075    29.386     0.200
    14.113    32.342     0.200
    14.346    32.647     0.200
    14.379    33.884     0.200
     1.170     5.609     0.200
     1.345     9.220     0.200
     1.413     7.509     0.200
     1.875     9.460     0.200
     2.236     9.879     0.200
     2.281     8.941     0.200
     2.341     9.366     0.200
     2.409    10.830     0.200
     2.600    11.379     0.200
     2.771    11.765     0.200
     2.836    10.531     0.200
     2.875    11.508     0.200
     2.968    12.045     0.200
     3.064    13.942     0.200
     3.086    13.603     0.200
     3.086    13.044     0.200
     3.358    12.939     0.200
     3.535    12.556     0.200
     3.688    13.237     0.200
     3.856    13.680     0.200
     4.255    15.054     0.200
     4.420    15.792     0.200
     4.535    13.949     0.200
     4.583    16.343     0.200
     4.721    16.189     0.200
     4.748    15.027     0.200
     5.004    17.488     0.200
     5.261    18.714     0.200
     5.713    19.672     0.200
     6.001    20.160     0.200
     6.014    19.666     0.200
     1.095     6.428     0.200
     1.095     6.578     0.200
     1.165     6.797     0.200
     1.301     6.848     0.200
     1.416     8.111     0.200
     1.436     7.613     0.200
     1.427     7.425     0.200
     1.473     7.790     0.200
     1.581     7.704     0.200
     1.587     8.007     0.200
     1.681     8.275     0.200
     1.816     8.089     0.200
     1.966     7.916     0.200
     2.182    10.497     0.200
     2.164    10.565     0.200
     2.231    12.704     0.200
     2.224    10.119     0.200
     2.333     9.797     0.200
     2.421    10.803     0.200
     2.546    12.433     0.200
     2.597    11.215     0.200
     2.707    11.545     0.200
     2.816    10.995     0.200
     2.825    12.439     0.200
     2.885    11.244     0.200
     2.929    12.608     0.200
     3.160    11.690     0.200
     3.160    12.130     0.200
     3.256    15.489     0.200
     3.351    12.680     0.200
     3.594    12.632     0.200
     3.694    14.395     0.200
     3.788    12.794     0.200
     3.788    17.663     0.200
     3.865    14.341     0.200
     3.881    14.844     0.200
     3.962    17.280     0.200
     4.332    15.304     0.200
     4.388    16.139     0.200
     4.456    16.521     0.200
     4.609    16.087     0.200
     4.608    17.872     0.200
     4.789    16.440     0.200
     4.786    17.232     0.200
     4.752    15.153     0.200
     4.827    17.398     0.200
     5.017    18.119     0.200
     5.121    17.926     0.200
     5.284    19.065     0.200
     5.343    18.347     0.200
     5.460    20.127     0.200
     5.574    19.220     0.200
     5.538    18.892     0.200
     5.686    17.856     0.200
     5.657    19.439     0.200
     5.728    19.966     0.200
     6.011    20.561     0.200
     6.005    20.108     0.200
     6.045    20.087     0.200
     6.651    19.074     0.200
     6.712    20.990     0.200
     6.846    23.805     0.200
     7.152    18.783     0.200
     7.492    22.798     0.200
     7.537    23.383     0.200
     8.053    25.377     0.200
     8.289    25.664     0.200
     8.637    26.567     0.200
     9.065    28.106     0.200
     9.260    26.967     0.200
     9.338    28.961     0.200
     9.455    25.109     0.200
     9.456    27.554     0.200
     9.456    26.640     0.200
     9.553    26.491     0.200
    10.011    27.702     0.200
    11.955    36.506     0.200
     0.896     5.222     0.200
     1.059     5.967     0.200
     1.145     7.251     0.200
     1.209     7.509     0.200
     1.292     6.964     0.200
     1.408     8.685     0.200
     1.418     7.456     0.200
     1.453     7.963     0.200
     1.409     7.887     0.200
     1.413     8.457     0.200
     1.567     8.388     0.200
     1.623     8.386     0.200
     1.619     8.050     0.200
     1.662     8.677     0.200
     1.662     8.552     0.200
     1.601     7.108     0.200
     1.802     7.827     0.200
     1.802     8.054     0.200
     1.925     8.515     0.200
     2.156    10.289     0.200
     2.163    10.408     0.200
     2.214     7.056     0.200
     3.154    11.516     0.200
     1.228     7.449     0.200
     1.382     7.529     0.200
     1.409     6.990     0.200
     2.312    11.842     0.200
     1.059     6.102     0.200
     1.148     7.342     0.200
     1.291     6.998     0.200
     1.410     8.179     0.200
     1.421     7.609     0.200
     1.455     8.039     0.200
     1.570     8.361     0.200
     1.625     8.436     0.200
     1.563     8.654     0.200
     1.617     8.439     0.200
     1.664     8.693     0.200
     1.802     7.637     0.200
     1.925     8.663     0.200
     2.165     9.724     0.200
     2.155    10.050     0.200
     2.216    10.738     0.200
     2.214    10.081     0.200
     2.316    10.105     0.200
     2.331    10.105     0.200
     2.532    10.249     0.200
     2.581    10.814     0.200
     2.695    10.520     0.200
     2.799    11.044     0.200
     2.810    14.751     0.200
     2.913    11.636     0.200
     2.991    12.736     0.200
     3.158    11.924     0.200
     3.158    11.784     0.200
     3.577    13.204     0.200
     3.586    13.479     0.200
     3.678    14.236     0.200
     3.866    15.565     0.200
     3.853    14.534     0.200
     3.801    14.293     0.200
     3.801    15.426     0.200
     3.981    13.839     0.200
     4.164    15.056     0.200
     4.229    14.262     0.200
     4.443    16.536     0.200
     4.593    17.655     0.200
     4.493    19.174     0.200
     4.607    14.956     0.200
     4.773    17.105     0.200
     4.783    16.704     0.200
     4.818    17.331     0.200
     5.001    18.665     0.200
     5.104    18.645     0.200
     5.268    19.509     0.200
     5.333    19.020     0.200
     5.641    19.980     0.200
     5.670    18.254     0.200
     5.580    20.705     0.200
     5.685    18.714     0.200
     5.988    19.487     0.200
     6.029    19.920     0.200
     6.635    20.769     0.200
     6.708    21.507     0.200
     7.137    23.057     0.200
     7.486    21.954     0.200
     7.525    24.205     0.200
     7.697    26.360     0.200
     8.056    23.267     0.200
     8.274    24.464     0.200
     8.834    28.153     0.200
     9.321    27.472     0.200
     9.264    26.390     0.200
     9.461    26.650     0.200
     9.462    26.363     0.200
     9.462    28.293     0.200
    11.939    34.270     0.200
     7.484    21.611     0.200
     1.266     6.792     0.200
     1.896     9.616     0.200
     2.290     9.490     0.200
     2.821    11.869     0.200
     2.917    13.116     0.200
     1.015     6.792     0.200
     1.541     8.854     0.200
     1.541     8.684     0.200
     2.171     9.456     0.200
     2.232    10.129     0.200
     1.024     6.677     0.200
     1.199     7.704     0.200
     1.465     7.653     0.200
     1.547     8.764     0.200
     2.187    12.650     0.200
     2.217    13.512     0.200
     2.367    13.172     0.200
     2.786    11.645     0.200
     2.857    16.304     0.200
     2.918    14.261     0.200
     2.964    15.438     0.200
     3.034    16.436     0.200
     3.161    10.704     0.200
     3.385    14.052     0.200
     3.909    15.561     0.200
     4.636    16.731     0.200
     5.313    17.967     0.200
     1.088     7.490     0.200
     1.167     6.625     0.200
     1.243     8.402     0.200
     1.314     8.776     0.200
     1.433     7.110     0.200
     1.568     8.250     0.200
     1.568     8.398     0.200
     1.686     8.105     0.200
     1.827     7.616     0.200
     2.187     9.402     0.200
     2.178     9.090     0.200
     2.241     9.639     0.200
     2.237     9.284     0.200
     2.335     9.859     0.200
     2.355     9.440     0.200
     2.428     9.822     0.200
     2.557     9.477     0.200
     2.605    10.980     0.200
     2.755    11.268     0.200
     2.719    10.773     0.200
     2.820    10.840     0.200
     2.886    11.103     0.200
     2.835     9.951     0.200
     2.937    11.842     0.200
     3.147    10.627     0.200
     3.147    11.717     0.200
     3.016    10.806     0.200
     3.265    11.817     0.200
     3.353    12.270     0.200
     3.584    12.426     0.200
     3.601    12.525     0.200
     3.694    13.621     0.200
     3.753    13.466     0.200
     3.857    14.187     0.200
     3.878    14.811     0.200
     3.972    13.032     0.200
     4.004    12.896     0.200
     4.319    15.994     0.200
     4.254    17.621     0.200
     4.451    16.423     0.200
     4.395    15.498     0.200
     4.389    14.560     0.200
     4.596    15.728     0.200
     4.604    17.367     0.200
     4.777    16.441     0.200
     4.780    16.848     0.200
     4.817    16.865     0.200
     4.839    18.862     0.200
     5.016    18.198     0.200
     5.124    16.934     0.200
     5.142    18.716     0.200
     5.163    19.788     0.200
     5.176    16.214     0.200
     5.281    19.246     0.200
     5.335    18.727     0.200
     5.673    18.057     0.200
     5.550    16.619     0.200
     5.656    19.318     0.200
     5.727    20.150     0.200
     5.701    19.003     0.200
     6.011    18.656     0.200
     6.008    18.915     0.200
     6.046    19.578     0.200
     6.324    21.131     0.200
     6.546    20.113     0.200
     6.700    20.741     0.200
     6.659    20.287     0.200
     6.844    22.608     0.200
     7.114    22.120     0.200
     7.148    21.939     0.200
     7.529    23.749     0.200
     7.721    27.678     0.200
     7.919    27.026     0.200
     8.039    25.057     0.200
     8.192    25.336     0.200
     8.208    23.831     0.200
     8.249    24.610     0.200
     8.285    23.245     0.200
     8.416    25.359     0.200
     8.845    27.855     0.200
     9.340    30.224     0.200
     9.442    24.785     0.200
    11.952    35.131     0.200
    12.201    31.858     0.200
     1.032     6.315     0.200
     1.193     6.360     0.200
     1.193     6.790     0.200
     1.457     7.030     0.200
     1.556     8.376     0.200
     1.712     7.938     0.200
     1.847    10.052     0.200
     2.213    10.858     0.200
     2.191     9.388     0.200
     2.263    13.412     0.200
     2.251     9.683     0.200
     2.362     9.394     0.200
     2.371    10.285     0.200
     2.452    10.395     0.200
     2.577    12.223     0.200
     2.629    12.703     0.200
     2.778    11.655     0.200
     2.736    12.570     0.200
     2.846    11.215     0.200
     2.856    12.027     0.200
     2.912    11.715     0.200
     2.961    12.074     0.200
     3.035    13.856     0.200
     3.153    12.808     0.200
     3.153    11.620     0.200
     3.288    14.736     0.200
     3.599    14.591     0.200
     3.720    14.731     0.200
     3.759    15.276     0.200
     3.776    15.070     0.200
     3.877    13.354     0.200
     3.901    14.932     0.200
     4.029    14.514     0.200
     4.317    15.676     0.200
     4.420    15.768     0.200
     4.473    16.546     0.200
     4.601    16.001     0.200
     4.628    17.081     0.200
     4.788    17.513     0.200
     4.802    16.324     0.200
     4.833    16.983     0.200
     4.843    18.828     0.200
     5.041    17.649     0.200
     5.150    18.360     0.200
     5.167    17.522     0.200
     5.305    18.679     0.200
     5.352    17.923     0.200
     5.677    17.741     0.200
     5.681    18.939     0.200
     5.726    20.493     0.200
     5.752    19.588     0.200
     6.036    20.769     0.200
     6.034    20.196     0.200
     6.072    20.073     0.200
     6.199    19.881     0.200
     6.868    23.792     0.200
     7.171    23.084     0.200
     7.548    23.888     0.200
     8.286    25.674     0.200
     8.289    26.178     0.200
     1.262     6.812     0.200
     1.578     8.591     0.200
     2.206     9.252     0.200
     2.265    10.908     0.200
     3.131    12.219     0.200
     1.246     6.614     0.200
     1.454     6.781     0.200
     1.479     7.697     0.200
     1.465     8.265     0.200
     1.690     8.458     0.200
     1.843     8.838     0.200
     2.229     9.312     0.200
     2.387     9.395     0.200
     2.830    11.287     0.200
     2.927    11.507     0.200
     2.927    11.717     0.200
     3.030    11.268     0.200
     3.271    14.254     0.200
     3.287    11.946     0.200
     3.310    12.555     0.200
     3.310    12.655     0.200
     3.400    13.069     0.200
     3.514    11.358     0.200
     3.575    13.818     0.200
     3.783    15.107     0.200
     3.906    13.770     0.200
     3.918    14.700     0.200
     4.120    14.612     0.200
     4.545    15.188     0.200
     4.670    15.408     0.200
     5.088    16.212     0.200
     5.334    16.383     0.200
     5.410    17.284     0.200
     5.501    18.522     0.200
     5.674    18.420     0.200
     6.187    20.394     0.200
     6.890    21.048     0.200
     6.994    21.742     0.200
     7.454    22.680     0.200
     7.780    22.862     0.200
     7.774    23.209     0.200
     7.774    23.930     0.200
     7.774    23.399     0.200
     7.774    23.759     0.200
     8.805    29.363     0.200
     8.974    25.994     0.200
    10.398    31.804     0.200
    17.956    39.054     0.200
     1.129     6.849     0.200
     1.209     7.794     0.200
     1.351     7.301     0.200
     1.577     8.254     0.200
     1.729     7.432     0.200
     2.078     8.666     0.200
     2.100     7.495     0.200
     2.136     9.107     0.200
     2.156     7.866     0.200
     2.230     8.556     0.200
     2.267     9.012     0.200
     2.317    10.159     0.200
     2.455     9.323     0.200
     2.496    10.071     0.200
     2.627    10.275     0.200
     2.711    10.058     0.200
     2.730    10.344     0.200
     2.785    11.189     0.200
     2.828    11.430     0.200
     2.919    11.140     0.200
     3.159    11.189     0.200
     3.224    12.370     0.200
     3.596    12.221     0.200
     3.802    12.506     0.200
     3.871    12.474     0.200
     3.894    12.084     0.200
     4.077    13.589     0.200
     4.286    15.147     0.200
     4.521    17.639     0.200
     4.712    17.036     0.200
     0.928     4.568     0.200
     0.834     4.822     0.200
     0.962     5.150     0.200
     1.059     5.102     0.200
     1.226     5.784     0.200
     1.311     6.265     0.200
     1.322     6.303     0.200
     1.435     6.721     0.200
     1.425     8.647     0.200
     1.476     6.714     0.200
     1.939     8.796     0.200
     1.925     8.117     0.200
     1.957     9.086     0.200
     1.978     7.788     0.200
     2.112     9.801     0.200
     2.085     8.794     0.200
     2.158     8.715     0.200
     2.127     8.493     0.200
     2.260    18.620     0.200
     2.273    10.180     0.200
     2.444     9.642     0.200
     2.568     9.838     0.200
     2.551    11.161     0.200
     2.702    10.925     0.200
     2.660    11.677     0.200
     2.736    13.342     0.200
     2.982    12.779     0.200
     3.078    11.318     0.200
     3.266    11.337     0.200
     3.291    15.655     0.200
     3.501    13.482     0.200
     3.809    13.907     0.200
     3.736    12.371     0.200
     3.933    15.451     0.200
     4.467    16.915     0.200
     4.691    16.299     0.200
     4.839    17.122     0.200
     4.887    16.593     0.200
     4.873    14.689     0.200
     5.136    17.823     0.200
     5.473    18.471     0.200
     5.488    18.598     0.200
     5.557    18.914     0.200
     5.687    19.176     0.200
     5.775    19.169     0.200
     5.829    19.599     0.200
     5.843    19.162     0.200
     6.083    20.860     0.200
     0.634     4.019     0.200
     0.802     4.651     0.200
     0.828     4.414     0.200
     0.816     4.785     0.200
     0.928     4.571     0.200
     1.159     5.890     0.200
     1.219     5.786     0.200
     1.305     6.679     0.200
     1.379     6.243     0.200
     1.429     6.613     0.200
     1.477     7.234     0.200
     1.542     6.530     0.200
     1.933     8.838     0.200
     1.952     8.712     0.200
     1.923     8.180     0.200
     1.975     8.074     0.200
     2.106     8.705     0.200
     2.082     8.618     0.200
     2.152     8.863     0.200
     2.321    10.222     0.200
     2.441     9.441     0.200
     2.562     9.749     0.200
     2.546    11.316     0.200
     2.654    10.871     0.200
     2.696    11.171     0.200
     2.977    10.676     0.200
     3.072    11.289     0.200
     3.264    11.153     0.200
     3.495    12.905     0.200
     3.468    11.738     0.200
     3.730    12.130     0.200
     3.804    13.552     0.200
     4.461    16.703     0.200
     4.686    16.361     0.200
     4.729    14.724     0.200
     4.814    16.376     0.200
     4.836    16.201     0.200
     4.833    17.244     0.200
     4.880    16.636     0.200
     5.312    18.359     0.200
     5.466    18.263     0.200
     5.481    18.608     0.200
     5.550    19.015     0.200
     5.769    19.172     0.200
     5.805    17.870     0.200
     5.836    18.866     0.200
     5.977    21.001     0.200
     6.077    21.161     0.200
     0.945     5.982     0.200
     1.047     5.975     0.200
     1.351     6.738     0.200
     1.391     9.292     0.200
     1.437     9.437     0.200
     1.510     7.230     0.200
     1.505     9.728     0.200
     1.539     9.775     0.200
     1.582    10.142     0.200
     1.662    10.255     0.200
     1.689     9.814     0.200
     1.712    10.934     0.200
     1.723    10.648     0.200
     1.845     9.896     0.200
     1.942    10.431     0.200
     2.081    11.229     0.200
     2.060    11.476     0.200
     2.085    11.271     0.200
     2.244    11.445     0.200
     2.374    11.793     0.200
     2.423    12.117     0.200
     2.695    12.037     0.200
     2.688    12.384     0.200
     2.848    12.919     0.200
     2.902    12.518     0.200
     3.071    12.076     0.200
     3.109    12.509     0.200
     3.181    12.741     0.200
     3.516    12.737     0.200
     3.538    12.871     0.200
     3.664    13.450     0.200
     3.912    14.081     0.200
     4.053    14.795     0.200
     4.436    15.700     0.200
     4.578    17.077     0.200
     4.785    16.870     0.200
     4.927    15.395     0.200
     4.876    17.870     0.200
     4.890    16.254     0.200
     5.113    16.122     0.200
     5.192    15.915     0.200
     1.030     5.664     0.200
     1.123     6.499     0.200
     1.225     7.516     0.200
     1.349     6.874     0.200
     1.485     7.279     0.200
     1.683    10.427     0.200
     1.875     8.452     0.200
     1.929    12.294     0.200
     1.963    11.461     0.200
     1.968    10.706     0.200
     2.042    12.880     0.200
     2.251    12.835     0.200
     2.267    12.287     0.200
     2.357    14.850     0.200
     2.404    12.981     0.200
     0.840     4.907     0.200
     0.912     4.937     0.200
     1.078     5.344     0.200
     1.182     6.459     0.200
     1.241     6.068     0.200
     1.280     8.328     0.200
     1.230     6.630     0.200
     1.314     6.816     0.200
     1.339     6.738     0.200
     1.401     6.680     0.200
     1.445     9.261     0.200
     1.450     7.261     0.200
     1.566     6.576     0.200
     1.954     8.910     0.200
     1.944     8.478     0.200
     1.977     8.914     0.200
     1.997     8.215     0.200
     2.105     8.737     0.200
     2.124     9.333     0.200
     2.175     9.002     0.200
     2.293     8.473     0.200
     2.345     9.080     0.200
     2.464     9.724     0.200
     2.570    10.378     0.200
     2.584     9.835     0.200
     2.678    10.850     0.200
     2.696    10.739     0.200
     2.706    10.623     0.200
     2.756     9.823     0.200
     3.001    10.978     0.200
     3.009    13.508     0.200
     3.094    11.451     0.200
     3.140    11.421     0.200
     3.246    11.302     0.200
     3.253    11.430     0.200
     3.345    11.959     0.200
     3.492    12.433     0.200
     3.511    13.152     0.200
     3.592    12.345     0.200
     3.709    12.908     0.200
     3.753    12.718     0.200
     3.808    13.521     0.200
     3.994    14.282     0.200
     4.125    14.736     0.200
     4.137    13.727     0.200
     4.813    15.374     0.200
     4.901    16.526     0.200
     5.565    18.927     0.200
     5.838    19.307     0.200
     7.466    25.633     0.200
     7.796    22.190     0.200
     9.643    26.913     0.200
    11.807    33.962     0.200
     0.913     4.933     0.200
     1.075     5.392     0.200
     1.174     6.239     0.200
     1.174     6.110     0.200
     1.233     6.179     0.200
     1.307     6.776     0.200
     1.442     7.146     0.200
     1.561     6.690     0.200
     1.946     8.975     0.200
     1.970     8.860     0.200
     1.941     8.729     0.200
     1.994     8.290     0.200
     2.116     8.636     0.200
     2.101     8.970     0.200
     2.167     9.309     0.200
     2.287    10.027     0.200
     2.337     9.464     0.200
     2.459     9.513     0.200
     2.575    10.161     0.200
     2.564    10.456     0.200
     2.671    10.958     0.200
     2.687    10.919     0.200
     2.699    10.684     0.200
     2.750    10.890     0.200
     2.994    11.247     0.200
     3.132    11.435     0.200
     3.240    11.167     0.200
     3.252    11.876     0.200
     3.337    11.608     0.200
     3.503    13.055     0.200
     3.588    12.275     0.200
     3.703    12.809     0.200
     3.745    12.576     0.200
     3.802    13.616     0.200
     4.129    13.584     0.200
     4.119    13.788     0.200
     4.350    14.293     0.200
     4.465    16.323     0.200
     4.487    15.146     0.200
     4.687    16.023     0.200
     4.744    14.527     0.200
     4.809    15.585     0.200
     5.134    18.144     0.200
     5.308    17.813     0.200
     5.792    17.728     0.200
     1.095     6.047     0.200
     1.122     6.985     0.200
     1.179     7.224     0.200
     1.234     7.013     0.200
     1.250     7.247     0.200
     1.337     7.434     0.200
     1.293     7.629     0.200
     1.397     7.372     0.200
     1.443     7.782     0.200
     1.576     7.133     0.200
     1.702     7.609     0.200
     1.744     8.825     0.200
     1.765     8.277     0.200
     1.960     9.123     0.200
     1.963     8.773     0.200
     1.946     9.523     0.200
     1.982    10.515     0.200
     2.013     8.941     0.200
     2.090     9.528     0.200
     2.118     9.239     0.200
     2.113     9.987     0.200
     2.161     9.469     0.200
     2.191     9.615     0.200
     2.173     9.658     0.200
     2.205     9.606     0.200
     2.289     9.977     0.200
     2.300     9.285     0.200
     2.345     9.891     0.200
     2.346     9.865     0.200
     2.396     9.996     0.200
     2.445    10.391     0.200
     2.476     9.954     0.200
     2.492    10.185     0.200
     2.575     9.983     0.200
     2.643    10.842     0.200
     2.678    11.744     0.200
     2.682    11.544     0.200
     2.687    11.587     0.200
     2.765    10.280     0.200
     2.803    10.524     0.200
     2.934    11.191     0.200
     3.005    12.129     0.200
     3.088    11.524     0.200
     3.229    11.814     0.200
     3.344    12.128     0.200
     3.750    13.097     0.200
     4.137    14.443     0.200
     4.428    15.207     0.200
     4.465    15.074     0.200
     4.789    16.160     0.200
     4.892    17.274     0.200
     5.779    19.657     0.200
     5.841    19.899     0.200
     6.591    20.670     0.200
     7.464    24.999     0.200
     7.501    22.220     0.200
     8.124    25.155     0.200
     9.624    27.752     0.200
     9.624    27.342     0.200
    11.789    33.729     0.200
     0.959     6.931     0.200
     1.160     6.795     0.200
     1.134     5.824     0.200
     1.198     6.837     0.200
     1.291     7.056     0.200
     1.247     7.156     0.200
     1.279     8.110     0.200
     1.358     7.380     0.200
     1.456     8.025     0.200
     1.609     7.387     0.200
     1.999     8.425     0.200
     1.958     8.992     0.200
     2.011     8.621     0.200
     2.051     8.731     0.200
     2.155     8.811     0.200
     2.119     9.448     0.200
     2.192     9.383     0.200
     2.332     9.433     0.200
     2.370     9.721     0.200
     2.512     9.711     0.200
     2.605    10.067     0.200
     2.590    10.196     0.200
     2.701    10.489     0.200
     2.683    10.459     0.200
     2.675    10.843     0.200
     2.799    10.022     0.200
     3.033    10.843     0.200
     3.102    11.042     0.200
     3.136    11.380     0.200
     3.192    12.160     0.200
     3.496    12.819     0.200
     3.538    12.424     0.200
     3.748    11.523     0.200
     3.762    13.544     0.200
     3.956    13.049     0.200
     4.319    14.753     0.200
     4.425    14.505     0.200
     4.444    14.818     0.200
     4.772    14.148     0.200
     5.732    16.398     0.200
     5.820    17.287     0.200
     0.924     5.123     0.200
     1.369     7.299     0.200
     1.416     8.078     0.200
     1.417     7.666     0.200
     1.538     7.052     0.200
     1.923     9.175     0.200
     1.922     9.485     0.200
     2.080     9.261     0.200
     2.093     9.280     0.200
     2.142     9.699     0.200
     2.551    10.631     0.200
     2.683    11.371     0.200
     3.482    12.890     0.200
     0.902     5.125     0.200
     1.113     6.269     0.200
     1.168     6.559     0.200
     1.238     4.675     0.200
     1.224     6.171     0.200
     1.238     6.585     0.200
     1.292     6.609     0.200
     1.326     6.324     0.200
     1.386     6.697     0.200
     1.433     6.928     0.200
     1.483     7.333     0.200
     1.562     6.268     0.200
     1.688     6.976     0.200
     1.947     8.564     0.200
     1.937     9.080     0.200
     1.999     8.357     0.200
     2.105     8.614     0.200
     2.106     9.341     0.200
     2.161     8.913     0.200
     2.287     9.578     0.200
     2.463     9.360     0.200
     2.562     9.303     0.200
     2.567    10.158     0.200
     2.676    10.912     0.200
     2.685     9.682     0.200
     2.752    10.532     0.200
     3.239    11.528     0.200
     3.491    13.469     0.200
     3.573    13.321     0.200
     3.739    12.440     0.200
     3.787    14.062     0.200
     4.451    16.318     0.200
     4.692    17.449     0.200
     4.813    17.373     0.200
     5.121    18.698     0.200
     5.462    18.657     0.200
     5.544    18.208     0.200
     5.780    17.806     0.200
     5.834    20.302     0.200
     6.069    21.218     0.200
     1.264     7.418     0.200
     1.387     8.489     0.200
     1.308     8.225     0.200
     1.308     7.995     0.200
     1.503     8.639     0.200
     1.415     7.483     0.200
     1.585     8.223     0.200
     1.490     8.323     0.200
     1.519     9.127     0.200
     1.706    10.064     0.200
     1.793     9.205     0.200
     1.938    12.338     0.200
     2.293    12.358     0.200
     2.276    10.557     0.200
     2.354    13.666     0.200
     2.434    12.505     0.200
     2.337    12.495     0.200
     2.460    10.877     0.200
     2.669    14.669     0.200
     2.718    13.647     0.200
     2.896    12.855     0.200
     2.927    11.753     0.200
     2.948    15.381     0.200
     3.117    12.794     0.200
     3.050    13.915     0.200
     3.126    14.332     0.200
     3.379    15.673     0.200
     3.452    14.468     0.200
     3.669    16.559     0.200
     3.782    16.124     0.200
     3.894    15.433     0.200
     4.258    16.717     0.200
     4.562    17.628     0.200
     4.508    16.260     0.200
     4.502    19.266     0.200
     4.673    17.482     0.200
     4.769    17.329     0.200
     4.833    16.602     0.200
     4.831    17.179     0.200
     4.933    19.138     0.200
     4.952    19.668     0.200
     5.226    20.769     0.200
     5.253    21.132     0.200
     5.358    19.130     0.200
     5.351    19.846     0.200
     5.634    18.447     0.200
     5.573    23.907     0.200
     5.740    19.129     0.200
     5.806    17.416     0.200
     5.923    21.511     0.200
     6.094    21.765     0.200
     6.108    21.275     0.200
     6.136    19.203     0.200
     6.317    21.807     0.200
     6.529    21.428     0.200
     6.682    20.575     0.200
     6.920    21.799     0.200
     7.097    24.086     0.200
     7.205    23.210     0.200
     7.282    22.406     0.200
     7.423    24.237     0.200
     7.474    23.859     0.200
     7.565    23.065     0.200
     7.588    22.932     0.200
     7.973    24.251     0.200
     1.050     5.817     0.200
     1.300     7.333     0.200
     1.538     8.298     0.200
     1.827     8.801     0.200
     2.029     9.021     0.200
     2.356    10.685     0.200
     2.414    11.214     0.200
     2.647    11.350     0.200
     2.879    12.456     0.200
     2.865    13.112     0.200
     2.857    14.371     0.200
     2.999    14.912     0.200
     3.275    11.441     0.200
     3.157    15.222     0.200
     3.261    12.053     0.200
     3.260    14.704     0.200
     3.403    13.499     0.200
     3.453    16.110     0.200
     3.922    14.150     0.200
     4.221    14.859     0.200
     4.304    15.666     0.200
     4.333    16.391     0.200
     4.669    16.285     0.200
     4.997    17.756     0.200
     5.284    18.891     0.200
     5.707    19.158     0.200
     6.406    19.909     0.200
     6.634    21.865     0.200
     6.672    21.350     0.200
     6.854    22.293     0.200
     7.566    23.221     0.200
     7.699    23.123     0.200
     7.699    25.863     0.200
     7.640    23.744     0.200
     7.694    23.329     0.200
     7.885    24.625     0.200
     7.759    25.887     0.200
     7.785    25.693     0.200
     8.313    26.013     0.200
     8.677    27.300     0.200
     8.762    27.621     0.200
     8.845    26.746     0.200
     9.195    25.045     0.200
     9.195    26.705     0.200
     9.129    25.426     0.200
     9.193    27.613     0.200
    10.431    28.852     0.200
    11.195    31.261     0.200
    12.533    36.999     0.200
    14.978    38.075     0.200
    15.550    40.352     0.200
    15.561    39.315     0.200
    15.681    39.515     0.200
    15.835    37.322     0.200
     7.697    25.422     0.200
     0.864     5.044     0.200
     1.018     6.742     0.200
     1.039     5.445     0.200
     1.092     7.013     0.200
     1.072     6.206     0.200
     1.372     7.885     0.200
     1.361     7.935     0.200
     1.366     8.081     0.200
     1.406     7.792     0.200
     1.420     8.525     0.200
     1.614     8.503     0.200
     1.781     7.253     0.200
     2.114    10.478     0.200
     2.151     9.476     0.200
     2.207    12.803     0.200
     2.261    10.171     0.200
     2.360     9.699     0.200
     2.758    11.842     0.200
     2.810    11.734     0.200
     2.873    11.990     0.200
     3.121    11.722     0.200
     3.619    14.152     0.200
     3.796    14.396     0.200
     4.314    15.023     0.200
     1.349     7.692     0.200
     1.602     7.856     0.200
     2.174    10.513     0.200
     2.348    10.197     0.200
     2.798    10.737     0.200
     2.862    11.694     0.200
     3.527    13.850     0.200
     3.606    12.034     0.200
     3.787    14.215     0.200
     4.319    14.544     0.200
     4.372    15.672     0.200
     4.521    17.189     0.200
     4.703    15.534     0.200
     4.757    16.810     0.200
     4.929    15.931     0.200
     4.929    17.820     0.200
     5.920    20.017     0.200
     5.958    20.569     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.615    20.054     0.200
     7.039    54.394     0.200
     3.516    28.511     0.200
     4.035    30.267     0.200
     5.284    42.276     0.200
     6.860    52.424     0.200
     4.077    33.258     0.200
     6.045    44.887     0.200
     6.770    53.776     0.200
     7.697    62.212     0.200
     4.185    27.496     0.200
     5.011    32.446     0.200
     3.583    23.456     0.200
     6.440    51.044     0.200
     7.446    51.336     0.200
     7.680    60.739     0.200
     2.960    22.736     0.200
     3.828    27.770     0.200
     4.922    35.650     0.200
     5.307    39.267     0.200
     5.596    41.383     0.200
     7.484    52.477     0.200
     5.148    38.811     0.200
     2.635    17.598     0.200
     2.729    22.669     0.200
     2.989    19.401     0.200
     3.181    20.851     0.200
     3.585    25.522     0.200
     3.946    27.901     0.200
     4.681    32.560     0.200
     4.894    35.358     0.200
     5.700    41.384     0.200
     5.730    41.438     0.200
     6.123    44.729     0.200
     6.214    45.353     0.200
     2.764    18.503     0.200
     2.936    20.131     0.200
     3.283    21.469     0.200
     4.099    31.779     0.200
     2.530    16.344     0.200
     3.160    20.925     0.200
     3.167    21.068     0.200
     3.920    26.081     0.200
     4.710    32.076     0.200
     5.598    38.420     0.200
     5.864    37.649     0.200
     6.075    41.661     0.200
     7.625    57.261     0.200
     7.794    58.361     0.200
     3.907    30.447     0.200
     4.605    33.514     0.200
     2.810    18.778     0.200
     2.692    24.641     0.200
     2.754    22.508     0.200
     2.807    20.161     0.200
     3.477    25.776     0.200
     3.911    27.483     0.200
     3.899    26.608     0.200
     8.088    59.251     0.200
     3.598    23.966     0.200
     2.702    21.729     0.200
     3.085    24.412     0.200
     7.568    57.164     0.200
     2.994    20.223     0.200
     7.513    50.737     0.200
     3.420    23.146     0.200
     3.908    28.797     0.200
     2.921    24.849     0.200
     3.260    22.226     0.200
     4.229    31.424     0.200
     2.789    18.149     0.200
     4.225    30.053     0.200
     3.294    23.084     0.200
     3.496    25.963     0.200
     3.648    28.884     0.200
     4.463    38.102     0.200
     2.786    18.457     0.200
     4.442    30.028     0.200
     3.713    28.581     0.200
     4.401    36.545     0.200
     4.409    36.800     0.200
     4.389    33.796     0.200
     3.260    22.384     0.200
     4.447    37.955     0.200
     4.337    32.603     0.200
     4.371    38.040     0.200
     4.347    33.373     0.200
     4.388    36.544     0.200
     4.347    37.091     0.200
     4.420    32.321     0.200
     4.450    34.008     0.200
     4.400    33.173     0.200
     4.372    35.937     0.200
     4.460    34.285     0.200
     4.394    37.829     0.200
     4.435    32.736     0.200
     4.365    35.173     0.200
     4.385    34.374     0.200
     4.380    32.674     0.200
     2.565    19.504     0.200
     4.418    34.760     0.200
     4.416    35.723     0.200
     9.360    67.135     0.200
     4.408    34.904     0.200
     4.358    36.366     0.200
     2.608    18.828     0.200
     4.421    35.867     0.200
     4.437    31.976     0.200
     4.408    34.697     0.200
     3.530    24.296     0.200
     3.702    26.524     0.200
     4.419    31.460     0.200
     2.836    22.228     0.200
     2.836    19.910     0.200
     3.226    23.841     0.200
     3.365    22.183     0.200
     3.664    25.402     0.200
     4.416    30.445     0.200
     2.798    18.595     0.200
     2.798    21.615     0.200
     2.798    18.427     0.200
     4.453    35.296     0.200
     4.365    33.794     0.200
     3.591    27.802     0.200
     3.645    31.877     0.200
     4.375    33.186     0.200
     4.396    28.602     0.200
     4.416    29.179     0.200
     4.416    34.656     0.200
     7.716    53.941     0.200
     4.404    34.484     0.200
     2.781    19.018     0.200
     3.693    25.772     0.200
     4.470    37.056     0.200
     4.388    32.159     0.200
     4.424    34.485     0.200
     4.448    38.817     0.200
     4.426    35.871     0.200
     4.375    32.619     0.200
     4.430    35.508     0.200
     2.868    18.699     0.200
     4.386    35.009     0.200
     2.793    19.502     0.200
     4.458    36.627     0.200
     4.450    35.289     0.200
     4.395    38.035     0.200
     4.409    34.544     0.200
     2.716    18.234     0.200
     2.591    17.364     0.200
     2.594    19.563     0.200
     3.310    21.211     0.200
     2.585    21.072     0.200
     3.227    25.736     0.200
     3.431    25.261     0.200
     3.538    26.850     0.200
     3.464    30.947     0.200
     8.398    64.246     0.200
     2.984    19.402     0.200
     4.196    32.729     0.200
     4.158    35.880     0.200
     9.088    70.215     0.200
     3.108    22.199     0.200
     3.016    19.512     0.200
     4.250    32.480     0.200
     2.674    17.841     0.200
     4.203    32.101     0.200
     2.675    20.901     0.200
     3.303    27.028     0.200
     3.388    26.487     0.200
     3.616    25.914     0.200
     4.148    32.809     0.200
     2.956    20.496     0.200
     3.571    23.681     0.200
     3.571    31.334     0.200
     3.954    31.916     0.200
     8.520    66.983     0.200
     7.460    53.295     0.200
     9.251    66.835     0.200
     2.798    18.859     0.200
     2.716    21.958     0.200
     7.599    56.425     0.200
     3.177    22.947     0.200
     2.825    24.265     0.200
     7.492    52.221     0.200
     7.714    58.943     0.200
     3.161    23.044     0.200
     2.835    24.191     0.200
     7.481    49.947     0.200
     7.721    57.725     0.200
     9.340    70.048     0.200
    11.952    82.682     0.200
     3.873    32.899     0.200
     7.466    51.692     0.200
     2.575    20.200     0.200
     7.464    55.124     0.200
     7.699    53.798     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.551     4.049     0.200
     1.877    12.590     0.200
     1.994    13.390     0.200
     0.614     4.337     0.200
     1.077     6.927     0.200
     1.032     7.199     0.200
     1.045     7.538     0.200
     0.643     5.063     0.200
     1.974    14.284     0.200
     0.655     4.968     0.200
     1.117     8.096     0.200
     1.986    14.640     0.200
     0.655     5.085     0.200
     1.095     8.095     0.200
     0.542     3.728     0.200
     1.046     6.827     0.200
     2.615    15.234     0.200
     0.570     3.861     0.200
     1.067     7.867     0.200
     1.399     8.542     0.200
     1.399     8.722     0.200
     3.942    23.596     0.200
     0.830     6.483     0.200
     0.895     8.447     0.200
     3.826    23.493     0.200
     3.871    23.694     0.200
     4.496    27.902     0.200
     5.111    32.414     0.200
     6.272    34.540     0.200
     2.104    18.567     0.200
     3.583    19.667     0.200
     0.512     3.653     0.200
     0.879     6.484     0.200
     1.036     6.548     0.200
     1.036     6.407     0.200
     1.037     6.465     0.200
     1.037     6.309     0.200
     1.008     6.244     0.200
     4.187    25.010     0.200
     1.441     9.440     0.200
     1.987    13.600     0.200
     2.803    18.120     0.200
     1.186     7.156     0.200
     1.188     7.832     0.200
     1.207     7.313     0.200
     1.272     7.511     0.200
     1.272     7.331     0.200
     1.274     8.355     0.200
     1.274     8.503     0.200
     1.487     9.485     0.200
     0.743     5.878     0.200
     0.833     7.215     0.200
     0.929     6.672     0.200
     1.043     7.024     0.200
     1.042     7.036     0.200
     1.087     7.991     0.200
     2.490    15.930     0.200
     2.334    11.725     0.200
     2.475    15.264     0.200
     3.229    19.842     0.200
     3.385    21.422     0.200
     5.355    31.993     0.200
     0.609     4.163     0.200
     0.626     5.359     0.200
     0.753     5.781     0.200
     1.004     6.894     0.200
     1.065     7.200     0.200
     2.000    11.780     0.200
     2.015    12.902     0.200
     0.570     4.352     0.200
     0.686     5.020     0.200
     0.796     5.697     0.200
     0.936     7.283     0.200
     1.052     7.078     0.200
     1.155     8.737     0.200
     1.398     9.906     0.200
     1.694    10.216     0.200
     0.345     3.567     0.200
     1.353     7.953     0.200
     1.362     8.703     0.200
     1.443     8.301     0.200
     1.727    10.454     0.200
     2.058    10.343     0.200
     2.155    11.970     0.200
     3.114    15.650     0.200
     3.638    22.689     0.200
     3.911    21.682     0.200
     0.640     4.311     0.200
     0.735     4.958     0.200
     1.052     6.774     0.200
     1.364     8.017     0.200
     1.406     9.633     0.200
     1.669    10.933     0.200
     1.886    10.951     0.200
     1.918     9.902     0.200
     1.940    10.179     0.200
     2.185    14.595     0.200
     2.333    15.400     0.200
     2.888    16.756     0.200
     0.615     4.973     0.200
     0.875     6.133     0.200
     0.913     5.941     0.200
     1.123     6.985     0.200
     1.123     7.651     0.200
     1.699    13.355     0.200
     3.288    18.212     0.200
     0.591     4.507     0.200
     0.839     5.397     0.200
     1.018     6.459     0.200
     1.061     6.245     0.200
     1.061     6.347     0.200
     1.595     8.496     0.200
     1.652     9.656     0.200
     0.619     5.231     0.200
     0.880     6.753     0.200
     0.880     6.253     0.200
     1.112     7.171     0.200
     1.112     7.989     0.200
     1.768    12.336     0.200
     2.148    15.405     0.200
     2.163    14.127     0.200
     2.268    15.349     0.200
     4.023    24.897     0.200
     0.600     4.926     0.200
     0.866     5.734     0.200
     1.522     8.456     0.200
     1.533     9.920     0.200
     1.555     9.491     0.200
     0.720     5.654     0.200
     0.975     6.364     0.200
     1.338     8.907     0.200
     0.613     4.986     0.200
     0.632     4.826     0.200
     0.807     6.260     0.200
     0.988     6.527     0.200
     0.988     6.647     0.200
     1.026     7.871     0.200
     1.193     7.478     0.200
     1.235     7.673     0.200
     1.235     7.872     0.200
     2.931    15.827     0.200
     0.661     4.455     0.200
     0.616     4.835     0.200
     0.826     5.969     0.200
     0.981     6.133     0.200
     0.981     6.514     0.200
     1.382     9.150     0.200
     1.454    10.478     0.200
     0.609     4.263     0.200
     0.612     4.156     0.200
     0.773     5.508     0.200
     1.095     6.563     0.200
     1.423     7.757     0.200
     2.528    15.737     0.200
     3.164    17.488     0.200
     0.708     5.213     0.200
     0.816     5.683     0.200
     0.923     7.621     0.200
     0.930     6.529     0.200
     0.941     5.981     0.200
     1.038     7.118     0.200
     1.135     8.472     0.200
     0.585     4.377     0.200
     0.673     4.420     0.200
     0.790     5.430     0.200
     0.801     5.427     0.200
     1.012     6.510     0.200
     1.270     7.443     0.200
     1.382     9.613     0.200
     1.414     8.273     0.200
     1.442     8.434     0.200
     1.415     8.991     0.200
     1.500     8.405     0.200
     1.504     8.886     0.200
     1.654     8.917     0.200
     0.705     5.540     0.200
     0.952     6.990     0.200
     0.973     6.422     0.200
     1.554     8.631     0.200
     3.498    21.047     0.200
     0.665     5.082     0.200
     1.352     8.880     0.200
     1.598     8.755     0.200
     1.786     9.282     0.200
     2.053    12.723     0.200
     2.137    11.450     0.200
     2.346    12.932     0.200
     0.390     3.493     0.200
     0.819     6.133     0.200
     0.819     6.246     0.200
     1.607    12.008     0.200
     2.683    13.860     0.200
     3.128    19.807     0.200
     0.395     3.349     0.200
     3.086    17.894     0.200
     4.046    23.230     0.200
     0.449     3.863     0.200
     2.384    12.835     0.200
     3.949    19.910     0.200
     0.810     6.151     0.200
     1.078     7.167     0.200
     0.769     5.598     0.200
     1.037     6.733     0.200
     1.037     6.834     0.200
     1.939    13.776     0.200
     2.236    25.384     0.200
     0.519     4.133     0.200
     0.753     5.530     0.200
     0.787     5.243     0.200
     0.939     7.169     0.200
     0.933     6.721     0.200
     0.954     7.389     0.200
     0.963     6.703     0.200
     1.105     7.727     0.200
     1.097     8.270     0.200
     1.157     7.613     0.200
     1.491     9.023     0.200
     0.510     4.756     0.200
     0.778     5.602     0.200
     0.756     4.943     0.200
     0.926     5.826     0.200
     0.945     7.220     0.200
     0.955     6.488     0.200
     0.978     6.658     0.200
     0.941     6.162     0.200
     1.415     7.847     0.200
     1.465     8.206     0.200
     1.495     8.583     0.200
     3.262    16.326     0.200
     3.262    16.686     0.200
     0.532     4.352     0.200
     0.799     5.299     0.200
     0.941     5.891     0.200
     0.967     6.007     0.200
     0.976     5.729     0.200
     0.999     6.796     0.200
     1.353    10.218     0.200
     1.897    12.508     0.200
     2.106    13.821     0.200
     0.476     4.451     0.200
     0.743     5.848     0.200
     0.934     5.467     0.200
     0.934     5.627     0.200
     0.890     5.516     0.200
     0.919     6.079     0.200
     0.947     6.473     0.200
     1.083     6.022     0.200
     1.053     8.847     0.200
     0.215     2.134     0.200
     0.204     2.438     0.200
     1.022     6.621     0.200
     1.817    11.227     0.200
     2.473    12.699     0.200
     4.037    20.563     0.200
     4.253    26.165     0.200
     0.402     3.556     0.200
     0.513     3.798     0.200
     0.778     5.315     0.200
     0.871     5.886     0.200
     0.862     5.633     0.200
     1.025     6.156     0.200
     1.055     7.765     0.200
     1.140     6.579     0.200
     4.409    21.981     0.200
     0.547     4.374     0.200
     0.707     5.298     0.200
     0.752     5.214     0.200
     1.051     7.385     0.200
     0.447     3.750     0.200
     1.250     8.025     0.200
     1.470     9.071     0.200
     1.570     9.531     0.200
     2.236    12.378     0.200
     0.600     4.334     0.200
     0.718     5.309     0.200
     0.794     5.485     0.200
     1.180     7.184     0.200
     1.225     7.383     0.200
     1.224     7.182     0.200
     1.347     8.245     0.200
     1.439    10.044     0.200
     1.674     9.284     0.200
     2.044    10.284     0.200
     2.186    11.583     0.200
     0.716     5.480     0.200
     1.104     7.287     0.200
     1.492    11.156     0.200
     1.948    14.084     0.200
     2.736    17.839     0.200
     3.378    17.979     0.200
     0.737     5.497     0.200
     0.959     7.350     0.200
     1.003     7.026     0.200
     1.128     7.521     0.200
     1.128     7.622     0.200
     3.420    18.310     0.200
     0.321     3.462     0.200
     0.466     3.790     0.200
     0.593     4.555     0.200
     0.761     4.986     0.200
     0.787     5.394     0.200
     0.827     5.321     0.200
     0.863     5.681     0.200
     0.906     6.516     0.200
     0.947     6.065     0.200
     0.947     5.956     0.200
     0.998     6.161     0.200
     1.082     6.396     0.200
     0.503     4.160     0.200
     0.736     4.947     0.200
     0.736     5.708     0.200
     0.883     5.980     0.200
     0.949     6.181     0.200
     1.044     6.355     0.200
     1.044     6.485     0.200
     1.108     6.827     0.200
     0.213     3.127     0.200
     1.045     6.437     0.200
     1.045     6.312     0.200
     2.698    15.767     0.200
     3.357    20.671     0.200
     0.802     6.016     0.200
     0.979     7.415     0.200
     0.414     3.144     0.200
     0.459     4.608     0.200
     0.823     5.418     0.200
     0.860     5.238     0.200
     0.894     5.688     0.200
     0.948     5.932     0.200
     1.046     6.494     0.200
     1.082     6.606     0.200
     1.208     7.899     0.200
     1.466     7.929     0.200
     1.946     9.767     0.200
     0.456     3.820     0.200
     0.815     6.723     0.200
     0.452     3.858     0.200
     1.070     6.875     0.200
     1.102     6.926     0.200
     1.473     8.707     0.200
     1.602     8.741     0.200
     1.844    13.239     0.200
     0.427     3.785     0.200
     1.314     7.658     0.200
     1.507     8.849     0.200
     1.569     8.635     0.200
     1.718     9.440     0.200
     1.718     9.340     0.200
     1.912    12.168     0.200
     2.038    10.621     0.200
     2.838    17.640     0.200
     3.123    18.426     0.200
     3.547    17.315     0.200
     0.448     3.937     0.200
     1.077     6.746     0.200
     1.109     6.733     0.200
     1.109     6.543     0.200
     1.347     8.248     0.200
     1.477     8.688     0.200
     1.598     9.125     0.200
     1.775     9.060     0.200
     1.852    13.217     0.200
     1.996    12.310     0.200
     2.037    13.802     0.200
     3.540    19.315     0.200
     0.560     4.941     0.200
     0.560     4.322     0.200
     0.591     3.655     0.200
     0.645     4.736     0.200
     0.771     5.125     0.200
     0.835     5.625     0.200
     0.835     6.105     0.200
     1.020     6.532     0.200
     1.050     6.241     0.200
     1.221     7.315     0.200
     1.214     7.593     0.200
     0.315     2.930     0.200
     1.050     7.236     0.200
     0.337     3.339     0.200
     1.114     7.051     0.200
     1.114     6.941     0.200
     1.403     8.717     0.200
     1.619     9.228     0.200
     1.619     9.028     0.200
     1.589     9.486     0.200
     1.686     8.978     0.200
     1.659     9.280     0.200
     0.739     5.796     0.200
     1.006     6.760     0.200
     1.138     7.898     0.200
     1.138     7.347     0.200
     1.509    10.055     0.200
     1.627    10.293     0.200
     1.799    10.990     0.200
     2.621    16.369     0.200
     2.700    16.699     0.200
     0.706     5.375     0.200
     0.974     6.389     0.200
     0.964     6.957     0.200
     1.066     6.624     0.200
     1.066     7.085     0.200
     2.665    16.783     0.200
     0.704     5.476     0.200
     0.981     7.134     0.200
     0.971     6.421     0.200
     1.028     6.753     0.200
     1.028     7.554     0.200
     1.157     7.195     0.200
     1.157     7.504     0.200
     0.733     5.817     0.200
     0.929     7.073     0.200
     1.002     7.015     0.200
     1.002     6.757     0.200
     1.205     7.617     0.200
     1.579    10.883     0.200
     0.618     5.001     0.200
     0.616     4.732     0.200
     0.801     5.652     0.200
     0.992     6.594     0.200
     0.992     6.764     0.200
     1.228     7.651     0.200
     1.306     9.928     0.200
     1.443     9.296     0.200
     3.195    17.092     0.200
     0.573     4.482     0.200
     0.863     5.771     0.200
     0.863     6.511     0.200
     0.922     6.141     0.200
     1.422     8.049     0.200
     1.539     9.315     0.200
     1.586    10.765     0.200
     1.787    10.643     0.200
     0.563     4.511     0.200
     0.859     6.288     0.200
     0.933     6.966     0.200
     1.434     8.556     0.200
     1.587    11.008     0.200
     1.545    10.101     0.200
     1.793    12.476     0.200
     1.784    11.576     0.200
     1.994    12.431     0.200
     1.994    11.881     0.200
     2.014    12.312     0.200
     0.550     4.629     0.200
     0.905     5.941     0.200
     0.905     5.761     0.200
     0.939     6.620     0.200
     1.422     8.674     0.200
     1.502     8.704     0.200
     1.826    11.263     0.200
     1.967    12.194     0.200
     2.592    12.940     0.200
     0.583     4.741     0.200
     0.913     6.942     0.200
     0.854     6.944     0.200
     1.417     8.990     0.200
     4.463    23.126     0.200
     0.569     4.642     0.200
     0.847     6.595     0.200
     0.929     7.071     0.200
     4.465    28.516     0.200
     0.536     4.380     0.200
     0.861     6.095     0.200
     0.861     5.716     0.200
     0.960     6.179     0.200
     1.597    10.239     0.200
     1.815    10.828     0.200
     2.003    11.873     0.200
     0.533     4.301     0.200
     0.893     6.244     0.200
     0.958     6.435     0.200
     1.445     8.566     0.200
     1.626    11.435     0.200
     1.833    11.830     0.200
     2.604    14.308     0.200
     0.540     4.504     0.200
     0.909     5.782     0.200
     0.909     5.294     0.200
     0.949     6.012     0.200
     1.638    10.591     0.200
     1.833    10.803     0.200
     1.836    11.068     0.200
     1.889    10.098     0.200
     1.956    10.070     0.200
     1.956     9.750     0.200
     2.850    13.777     0.200
     0.511     4.187     0.200
     0.890     5.622     0.200
     0.890     5.794     0.200
     1.804     9.793     0.200
     2.841    14.351     0.200
     2.848    16.805     0.200
     0.568     4.666     0.200
     0.920     6.277     0.200
     0.942     6.479     0.200
     0.942     6.589     0.200
     4.381    22.465     0.200
     0.542     4.430     0.200
     0.924     6.857     0.200
     0.946     6.582     0.200
     0.549     4.367     0.200
     0.900     6.916     0.200
     0.941     7.032     0.200
     1.425     9.594     0.200
     1.508    10.052     0.200
     1.626    10.818     0.200
     1.748    10.902     0.200
     1.824    11.350     0.200
     1.901    10.784     0.200
     1.968    11.398     0.200
     2.591    14.253     0.200
     2.591    13.487     0.200
     3.563    21.144     0.200
     3.695    19.805     0.200
     0.580     4.612     0.200
     0.854     7.007     0.200
     0.854     6.866     0.200
     0.916     6.947     0.200
     1.420     8.744     0.200
     1.576     9.708     0.200
     1.777    11.087     0.200
     2.011    12.137     0.200
     2.551    14.370     0.200
     3.556    21.440     0.200
     0.549     4.418     0.200
     0.946     6.414     0.200
     1.006     5.927     0.200
     1.387     8.589     0.200
     1.403     8.103     0.200
     1.724     9.722     0.200
     1.827    10.957     0.200
     1.890    10.140     0.200
     1.882    10.130     0.200
     1.920    10.353     0.200
     1.920    10.913     0.200
     0.613     4.866     0.200
     0.901     6.895     0.200
     0.901     7.153     0.200
     1.364     8.812     0.200
     1.776    11.136     0.200
     2.534    13.042     0.200
     0.588     4.700     0.200
     0.944     6.968     0.200
     1.368     9.124     0.200
     1.453     8.847     0.200
     1.654    10.101     0.200
     1.691    10.465     0.200
     1.820    11.632     0.200
     1.897    12.377     0.200
     1.983    11.718     0.200
     1.983    12.689     0.200
     3.495    20.945     0.200
     3.585    23.255     0.200
     0.555     4.417     0.200
     0.933     5.684     0.200
     0.933     5.544     0.200
     0.933     5.871     0.200
     1.654     9.998     0.200
     1.838    10.932     0.200
     1.959     9.781     0.200
     0.959     6.930     0.200
     0.948     6.996     0.200
     1.424     9.204     0.200
     1.465     8.560     0.200
     1.676    10.200     0.200
     1.707    10.719     0.200
     1.866    11.095     0.200
     1.856    10.702     0.200
     1.856    11.300     0.200
     1.926    11.340     0.200
     1.931    11.528     0.200
     1.931    11.399     0.200
     0.591     4.596     0.200
     0.897     6.053     0.200
     0.941     6.079     0.200
     0.941     6.457     0.200
     1.366     8.210     0.200
     1.456     8.174     0.200
     1.650     9.379     0.200
     1.693     9.727     0.200
     1.816     9.501     0.200
     0.541     4.367     0.200
     0.949     6.691     0.200
     0.898     6.801     0.200
     0.898     6.310     0.200
     1.627    10.527     0.200
     1.752    11.226     0.200
     1.897    11.049     0.200
     3.704    19.640     0.200
     0.586     4.684     0.200
     0.903     6.353     0.200
     0.949     6.458     0.200
     0.949     6.178     0.200
     1.826    11.241     0.200
     1.948    12.158     0.200
     3.653    19.191     0.200
     0.584     4.670     0.200
     0.906     6.242     0.200
     0.898     5.845     0.200
     0.898     6.056     0.200
     1.392     8.152     0.200
     1.500     8.606     0.200
     1.737     9.427     0.200
     4.426    25.145     0.200
     0.580     4.549     0.200
     0.872     5.819     0.200
     0.872     6.987     0.200
     0.913     5.921     0.200
     0.596     4.833     0.200
     0.899     5.862     0.200
     1.003     6.097     0.200
     1.342     8.285     0.200
     1.394     8.534     0.200
     1.632     9.758     0.200
     1.707    10.129     0.200
     1.861    10.884     0.200
     1.861    10.214     0.200
     1.854    10.486     0.200
     1.942    11.463     0.200
     0.582     4.615     0.200
     0.906     6.543     0.200
     0.949     6.768     0.200
     0.562     4.317     0.200
     0.927     6.879     0.200
     0.952     7.387     0.200
     0.952     8.168     0.200
     3.676    22.170     0.200
     0.581     4.630     0.200
     0.911     6.162     0.200
     0.986     5.963     0.200
     1.853    11.398     0.200
     2.775    15.690     0.200
     0.593     4.717     0.200
     0.895     6.433     0.200
     0.960     6.907     0.200
     0.960     7.227     0.200
     1.667    10.533     0.200
     1.827    11.074     0.200
     0.475     4.416     0.200
     0.474     4.399     0.200
     0.543     3.579     0.200
     0.717     4.651     0.200
     0.749     5.614     0.200
     0.749     5.214     0.200
     0.825     5.081     0.200
     0.917     6.007     0.200
     0.917     5.983     0.200
     1.032     6.523     0.200
     1.032     6.792     0.200
     1.013     6.159     0.200
     1.062     7.409     0.200
     1.174     6.586     0.200
     1.130     7.541     0.200
     0.460     5.132     0.200
     0.459     4.153     0.200
     0.540     4.232     0.200
     0.540     4.062     0.200
     0.734     5.128     0.200
     0.734     5.878     0.200
     0.727     5.155     0.200
     0.830     5.595     0.200
     0.902     7.051     0.200
     0.909     6.082     0.200
     0.920     5.980     0.200
     0.960     6.437     0.200
     0.960     6.677     0.200
     0.999     6.763     0.200
     1.170     6.935     0.200
     1.170     7.235     0.200
     1.309     7.760     0.200
     1.532    10.201     0.200
     0.595     4.600     0.200
     0.893     5.857     0.200
     0.946     6.788     0.200
     3.644    20.332     0.200
     0.578     4.615     0.200
     0.913     6.385     0.200
     0.984     6.494     0.200
     0.984     6.611     0.200
     1.364     8.265     0.200
     1.416     8.539     0.200
     1.655     9.118     0.200
     1.695     9.676     0.200
     1.854    10.473     0.200
     0.567     4.607     0.200
     0.927     6.135     0.200
     0.995     5.996     0.200
     0.995     6.316     0.200
     1.372     7.985     0.200
     1.408     9.045     0.200
     1.648     9.414     0.200
     1.709     9.316     0.200
     1.870    10.248     0.200
     1.846     9.704     0.200
     1.941    10.509     0.200
     1.941    10.289     0.200
     2.614    12.428     0.200
     2.614    14.398     0.200
     0.583     4.619     0.200
     0.906     6.409     0.200
     0.905     6.633     0.200
     0.905     7.513     0.200
     0.581     4.629     0.200
     0.869     7.447     0.200
     0.869     7.226     0.200
     0.912     6.058     0.200
     1.589    12.303     0.200
     2.802    15.298     0.200
     0.585     4.846     0.200
     0.902     6.434     0.200
     3.655    19.304     0.200
     0.595     4.656     0.200
     0.894     5.890     0.200
     0.478     3.951     0.200
     0.847     6.121     0.200
     1.027     7.057     0.200
     1.529     9.117     0.200
     1.603    11.200     0.200
     1.744    11.980     0.200
     1.853    11.686     0.200
     2.644    13.665     0.200
     0.507     4.213     0.200
     0.859     6.917     0.200
     0.992     7.065     0.200
     1.604    10.659     0.200
     1.836    11.126     0.200
     0.473     3.930     0.200
     0.822     6.143     0.200
     1.044     6.980     0.200
     1.584    10.109     0.200
     1.713    10.707     0.200
     1.849    11.409     0.200
     0.584     4.666     0.200
     0.904     6.096     0.200
     0.935     6.553     0.200
     1.376     7.940     0.200
     1.463     9.222     0.200
     1.648    10.070     0.200
     1.818    10.637     0.200
     4.394    22.954     0.200
     0.571     4.514     0.200
     0.883     5.638     0.200
     0.883     6.677     0.200
     0.921     5.762     0.200
     1.604    12.557     0.200
     1.799    12.040     0.200
     0.541     4.221     0.200
     0.950     6.689     0.200
     0.950     7.712     0.200
     4.365    24.712     0.200
     0.586     4.592     0.200
     0.902     5.995     0.200
     0.937     5.854     0.200
     0.937     6.734     0.200
     1.373     8.137     0.200
     1.818    11.375     0.200
     0.731     5.701     0.200
     1.825    12.335     0.200
     1.887    14.023     0.200
     1.831    12.634     0.200
     2.001    12.551     0.200
     2.001    12.250     0.200
     2.572    16.215     0.200
     2.572    14.324     0.200
     3.033    15.900     0.200
     3.660    20.200     0.200
     0.548     4.441     0.200
     0.930     7.598     0.200
     0.940     7.256     0.200
     1.654    10.208     0.200
     0.555     4.563     0.200
     0.935     6.102     0.200
     0.971     6.689     0.200
     0.971     6.330     0.200
     1.391     8.282     0.200
     1.435     8.505     0.200
     1.675    10.011     0.200
     1.690     9.963     0.200
     1.856    10.331     0.200
     1.862    10.533     0.200
     1.943    10.381     0.200
     2.612    12.542     0.200
     4.351    23.559     0.200
     0.553     4.578     0.200
     0.939     6.497     0.200
     0.939     7.836     0.200
     0.578     4.745     0.200
     0.898     7.214     0.200
     0.898     6.996     0.200
     0.911     6.321     0.200
     1.398     8.239     0.200
     1.501     9.666     0.200
     1.616    10.917     0.200
     1.739    11.365     0.200
     1.802    11.394     0.200
     1.993    11.541     0.200
     2.565    13.707     0.200
     0.566     4.522     0.200
     0.901     6.868     0.200
     0.901     6.611     0.200
     0.923     6.697     0.200
     1.622    12.043     0.200
     0.595     4.765     0.200
     0.893     6.175     0.200
     0.914     7.109     0.200
     0.914     6.195     0.200
     0.564     4.486     0.200
     0.925     6.746     0.200
     0.911     6.840     0.200
     0.911     8.168     0.200
     2.844    18.420     0.200
     0.678     5.240     0.200
     1.096     9.281     0.200
     1.736     9.868     0.200
     1.977    12.558     0.200
     1.998    12.741     0.200
     2.155    12.525     0.200
     2.415    15.865     0.200
     2.915    16.832     0.200
     3.115    18.398     0.200
     3.223    19.628     0.200
     3.399    21.824     0.200
     4.759    25.448     0.200
     0.572     4.675     0.200
     0.917     6.606     0.200
     0.970     6.657     0.200
     0.970     6.767     0.200
     1.374     8.454     0.200
     1.683    10.968     0.200
     0.890     6.471     0.200
     1.084     8.405     0.200
     1.084     8.224     0.200
     1.295     8.426     0.200
     1.310     8.907     0.200
     1.547     9.908     0.200
     1.776    10.844     0.200
     1.824    11.015     0.200
     1.824    10.865     0.200
     1.848    10.401     0.200
     1.892    11.463     0.200
     1.951    11.208     0.200
     1.951    11.098     0.200
     2.608    13.337     0.200
     0.577     4.711     0.200
     0.863     6.247     0.200
     0.863     6.977     0.200
     0.918     5.942     0.200
     1.586    11.766     0.200
     1.538    10.110     0.200
     1.785    12.417     0.200
     2.005    11.483     0.200
     2.556    15.118     0.200
     2.798    15.242     0.200
     3.147    15.822     0.200
     0.581     4.679     0.200
     0.903     6.581     0.200
     0.903     6.761     0.200
     0.908     6.690     0.200
     1.619    12.132     0.200
     1.802    12.110     0.200
     0.515     4.197     0.200
     0.871     6.051     0.200
     0.980     6.807     0.200
     1.474     8.687     0.200
     1.835    10.259     0.200
     1.899    10.888     0.200
     1.951    10.493     0.200
     2.823    13.697     0.200
     0.543     4.412     0.200
     0.870     5.330     0.200
     0.870     6.025     0.200
     0.951     6.135     0.200
     0.545     4.274     0.200
     0.906     6.422     0.200
     1.426     9.184     0.200
     1.503     9.182     0.200
     1.743    11.332     0.200
     1.633    10.918     0.200
     1.894    11.549     0.200
     1.830    14.042     0.200
     1.962    12.459     0.200
     2.845    17.064     0.200
     3.499    17.656     0.200
     0.516     4.318     0.200
     0.894     6.080     0.200
     0.894     5.940     0.200
     1.845    10.858     0.200
     0.535     4.509     0.200
     0.954     6.630     0.200
     0.966     6.651     0.200
     1.411     8.501     0.200
     1.445     9.544     0.200
     1.687    10.264     0.200
     1.691    10.624     0.200
     1.847    11.175     0.200
     1.873    11.223     0.200
     1.928    10.175     0.200
     2.627    13.726     0.200
     3.240    16.567     0.200
     0.540     4.404     0.200
     0.890     5.913     0.200
     0.890     6.123     0.200
     0.951     6.018     0.200
     3.706    19.542     0.200
     0.579     4.558     0.200
     0.908     6.609     0.200
     0.908     6.439     0.200
     0.910     6.943     0.200
     3.517    22.199     0.200
     3.784    23.484     0.200
     4.073    21.967     0.200
     4.860    24.099     0.200
     0.563     4.610     0.200
     0.892     6.929     0.200
     0.928     6.272     0.200
     1.615    11.538     0.200
     1.809    12.340     0.200
     3.683    19.177     0.200
     0.560     4.560     0.200
     0.858     7.071     0.200
     0.936     6.533     0.200
     4.453    25.241     0.200
     0.570     4.484     0.200
     0.926     7.119     0.200
     0.860     6.960     0.200
     1.426     8.713     0.200
     1.585    12.318     0.200
     1.788    12.835     0.200
     1.939    11.788     0.200
     4.454    26.569     0.200
     0.558     4.369     0.200
     0.884     5.532     0.200
     0.884     6.282     0.200
     0.934     6.105     0.200
     1.610    11.779     0.200
     1.809    10.122     0.200
     1.981    11.291     0.200
     3.690    21.375     0.200
     0.560     4.463     0.200
     0.929     5.831     0.200
     0.957     6.524     0.200
     1.390     8.173     0.200
     1.687     9.703     0.200
     0.574     4.669     0.200
     0.921     6.358     0.200
     1.785    11.913     0.200
     1.942    11.850     0.200
     0.565     4.668     0.200
     0.927     6.221     0.200
     1.420     8.402     0.200
     1.802    12.278     0.200
     0.647     5.141     0.200
     0.846     6.007     0.200
     0.985     7.080     0.200
     0.985     7.877     0.200
     2.538    14.262     0.200
     0.633     4.993     0.200
     0.879     5.889     0.200
     1.061     6.236     0.200
     1.295     8.013     0.200
     1.331     8.015     0.200
     1.753    10.456     0.200
     1.844    10.502     0.200
     1.844    10.092     0.200
     1.966    10.319     0.200
     0.564     4.481     0.200
     0.885     7.387     0.200
     0.928     6.715     0.200
     1.609    10.869     0.200
     2.865    16.788     0.200
     3.683    23.697     0.200
     0.525     4.190     0.200
     0.910     7.023     0.200
     0.964     6.458     0.200
     2.854    13.502     0.200
     3.718    18.980     0.200
     0.560     4.459     0.200
     0.929     6.520     0.200
     2.836    16.605     0.200
     0.554     4.452     0.200
     0.912     6.240     0.200
     0.934     6.194     0.200
     1.636    11.044     0.200
     1.826    11.131     0.200
     3.688    22.213     0.200
     0.565     4.581     0.200
     0.840     5.444     0.200
     0.840     6.694     0.200
     0.562     4.603     0.200
     0.926     6.767     0.200
     1.863    13.508     0.200
     2.864    17.531     0.200
     3.678    20.241     0.200
     0.569     4.603     0.200
     0.895     6.544     0.200
     0.895     6.406     0.200
     0.921     6.579     0.200
     1.408     8.392     0.200
     2.856    17.374     0.200
     2.828    16.264     0.200
     2.828    17.034     0.200
     3.676    19.258     0.200
     0.569     4.461     0.200
     0.867     6.615     0.200
     0.925     6.322     0.200
     1.423     8.221     0.200
     1.591     9.780     0.200
     1.792    10.015     0.200
     2.882    14.964     0.200
     3.570    18.926     0.200
     4.448    23.342     0.200
     0.570     4.610     0.200
     0.849     6.028     0.200
     0.849     6.876     0.200
     0.928     6.585     0.200
     1.433     8.538     0.200
     1.576     9.119     0.200
     1.783    10.016     0.200
     0.575     4.621     0.200
     0.895     6.326     0.200
     0.895     7.037     0.200
     0.915     6.690     0.200
     1.403     8.880     0.200
     1.614    10.584     0.200
     1.802    11.560     0.200
     2.567    14.164     0.200
     3.167    16.738     0.200
     3.670    20.211     0.200
     0.595     4.743     0.200
     0.956     5.887     0.200
     1.147     7.328     0.200
     1.147     7.588     0.200
     1.259     8.040     0.200
     1.331     8.370     0.200
     1.502     8.935     0.200
     1.744     9.060     0.200
     1.744    10.050     0.200
     1.851    10.797     0.200
     1.879     9.895     0.200
     1.972    11.045     0.200
     0.585     4.662     0.200
     0.951     6.138     0.200
     1.117     7.036     0.200
     1.117     7.657     0.200
     1.289     8.054     0.200
     1.340     8.235     0.200
     1.531     9.035     0.200
     1.762     9.400     0.200
     1.888     9.761     0.200
     1.824    10.150     0.200
     1.953    10.401     0.200
     0.578     4.734     0.200
     0.911     6.859     0.200
     0.581     4.559     0.200
     0.907     6.062     0.200
     0.956     6.347     0.200
     1.370     8.814     0.200
     1.443     8.680     0.200
     1.681     9.752     0.200
     1.884    10.853     0.200
     0.573     4.537     0.200
     0.890     6.781     0.200
     0.917     5.876     0.200
     1.610     9.830     0.200
     1.800    10.536     0.200
     0.566     4.652     0.200
     0.922     6.291     0.200
     0.914     6.843     0.200
     0.914     6.722     0.200
     1.402     8.303     0.200
     1.634     9.980     0.200
     0.557     4.572     0.200
     0.931     6.302     0.200
     0.935     5.997     0.200
     0.935     6.970     0.200
     1.470     9.000     0.200
     3.683    20.919     0.200
     0.543     4.337     0.200
     0.927     6.385     0.200
     0.927     6.982     0.200
     0.471     3.943     0.200
     0.824     6.131     0.200
     1.045     6.722     0.200
     1.714    10.428     0.200
     1.851    10.996     0.200
     4.458    24.557     0.200
     0.571     4.488     0.200
     0.877     6.142     0.200
     0.921     6.107     0.200
     1.416     8.424     0.200
     1.599     9.921     0.200
     1.763    10.049     0.200
     1.796    10.365     0.200
     1.995    11.154     0.200
     2.565    13.923     0.200
     3.159    15.935     0.200
     0.540     4.414     0.200
     0.958     5.969     0.200
     1.589    10.477     0.200
     1.808    10.671     0.200
     1.978    10.070     0.200
     0.559     4.564     0.200
     0.860     6.313     0.200
     0.860     6.983     0.200
     0.936     6.258     0.200
     1.545     9.861     0.200
     1.589    12.063     0.200
     1.796    10.941     0.200
     0.624     4.964     0.200
     0.952     7.000     0.200
     1.674    10.798     0.200
     1.674    10.488     0.200
     1.799    12.055     0.200
     4.395    22.734     0.200
     0.552     4.378     0.200
     0.905     5.863     0.200
     0.905     6.343     0.200
     0.937     6.037     0.200
     0.840     5.889     0.200
     0.804     6.284     0.200
     1.278     9.140     0.200
     1.372     9.736     0.200
     1.520    10.231     0.200
     2.497    13.219     0.200
     2.801    15.354     0.200
     2.882    16.692     0.200
     3.136    16.420     0.200
     3.912    21.580     0.200
     0.627     5.002     0.200
     1.184     7.755     0.200
     1.222     8.960     0.200
     1.222     8.601     0.200
     1.428     8.957     0.200
     1.700    10.542     0.200
     1.700     9.995     0.200
     1.921    11.526     0.200
     1.856    10.596     0.200
     2.022    13.785     0.200
     0.661     5.230     0.200
     0.923     6.456     0.200
     1.199     8.160     0.200
     1.196     8.598     0.200
     1.270     8.130     0.200
     1.439     8.915     0.200
     1.883    11.510     0.200
     1.972    13.285     0.200
     3.349    20.761     0.200
     0.694     5.545     0.200
     0.654     5.004     0.200
     0.935     5.997     0.200
     1.194     7.602     0.200
     1.203     7.682     0.200
     1.280     7.837     0.200
     1.435     8.396     0.200
     1.740     9.148     0.200
     1.893    10.430     0.200
     1.984    10.978     0.200
     3.362    18.993     0.200
     0.616     5.017     0.200
     1.023     7.465     0.200
     1.720    10.927     0.200
     1.854    11.316     0.200
     1.970    10.606     0.200
     0.757     5.909     0.200
     0.923     6.882     0.200
     1.025     6.836     0.200
     1.156     8.009     0.200
     1.156     7.519     0.200
     0.743     5.540     0.200
     1.197     7.592     0.200
     0.917     6.237     0.200
     1.537     9.644     0.200
     1.176     7.365     0.200
     1.448     8.335     0.200
     1.448     8.194     0.200
     1.391     7.924     0.200
     1.400     9.204     0.200
     1.684     9.099     0.200
     0.734     5.468     0.200
     1.188     7.385     0.200
     0.929     6.115     0.200
     1.388     8.391     0.200
     1.188     7.517     0.200
     1.523     9.232     0.200
     1.413     7.991     0.200
     1.457     7.991     0.200
     1.457     8.241     0.200
     1.688     8.685     0.200
     2.229    11.918     0.200
     2.301    12.399     0.200
     2.995    14.769     0.200
     0.661     5.048     0.200
     0.932     5.840     0.200
     1.188     7.318     0.200
     1.985    12.723     0.200
     0.637     5.108     0.200
     0.925     6.831     0.200
     0.628     4.928     0.200
     0.955     5.856     0.200
     1.196     7.595     0.200
     1.196     7.974     0.200
     1.207     7.497     0.200
     1.305     8.505     0.200
     1.726     9.957     0.200
     1.726     9.438     0.200
     1.876     9.873     0.200
     1.893    10.650     0.200
     1.995    11.523     0.200
     0.777     5.919     0.200
     0.871     6.848     0.200
     1.039     7.215     0.200
     1.264     8.722     0.200
     1.678    10.555     0.200
     1.678    11.470     0.200
     0.733     5.421     0.200
     0.924     5.868     0.200
     1.537    10.341     0.200
     2.321    15.029     0.200
     2.321    15.568     0.200
     2.971    15.448     0.200
     0.932     6.180     0.200
     0.731     5.414     0.200
     1.190     7.530     0.200
     1.189     7.428     0.200
     1.391     8.074     0.200
     1.456     8.416     0.200
     1.456     8.596     0.200
     1.521     8.156     0.200
     1.521     8.957     0.200
     1.686     8.948     0.200
     0.746     5.885     0.200
     0.929     6.618     0.200
     1.185     7.673     0.200
     1.155     7.678     0.200
     1.490     8.438     0.200
     1.356     8.235     0.200
     1.508     8.473     0.200
     2.917    16.344     0.200
     0.630     4.868     0.200
     0.903     5.996     0.200
     1.111     6.956     0.200
     2.668    15.316     0.200
     0.639     4.932     0.200
     0.923     5.842     0.200
     1.162     6.800     0.200
     1.162     6.470     0.200
     2.619    13.964     0.200
     3.354    20.908     0.200
     0.598     4.705     0.200
     0.926     6.001     0.200
     1.093     6.577     0.200
     1.093     7.367     0.200
     1.796    10.220     0.200
     1.923    12.201     0.200
     0.632     5.010     0.200
     0.939     7.180     0.200
     1.224     8.033     0.200
     1.298     8.768     0.200
     1.465     9.207     0.200
     3.350    18.330     0.200
     0.609     4.970     0.200
     1.257     8.243     0.200
     1.317     8.279     0.200
     1.499     8.903     0.200
     1.961    11.177     0.200
     3.057    18.765     0.200
     0.612     5.001     0.200
     0.945     6.020     0.200
     1.155     6.666     0.200
     1.155     7.037     0.200
     1.247     8.086     0.200
     1.315     8.209     0.200
     1.489     9.091     0.200
     1.749     9.182     0.200
     1.749     9.553     0.200
     1.855     9.811     0.200
     1.888     9.560     0.200
     1.888     9.880     0.200
     1.968    12.217     0.200
     0.675     5.360     0.200
     0.930     6.380     0.200
     1.910    11.431     0.200
     3.369    19.910     0.200
     0.673     5.382     0.200
     1.161     7.605     0.200
     1.236     8.329     0.200
     2.686    15.942     0.200
     0.761     5.259     0.200
     1.029     6.247     0.200
     0.919     6.272     0.200
     1.154     7.153     0.200
     1.154     6.903     0.200
     1.887    10.017     0.200
     3.279    19.734     0.200
     0.738     5.842     0.200
     0.924     6.515     0.200
     1.182     7.546     0.200
     0.780     6.101     0.200
     1.144     7.753     0.200
     0.560     5.424     0.200
     0.589     4.471     0.200
     0.589     4.660     0.200
     0.646     4.857     0.200
     0.773     5.332     0.200
     0.773     4.851     0.200
     0.835     5.729     0.200
     0.996     7.138     0.200
     1.048     6.610     0.200
     1.059     6.901     0.200
     1.079     6.636     0.200
     1.667    10.658     0.200
     4.282    25.002     0.200
     0.242     2.047     0.200
     0.828     6.356     0.200
     0.815     6.163     0.200
     1.283     8.251     0.200
     1.283     8.098     0.200
     1.508     9.570     0.200
     1.563     8.914     0.200
     1.671     9.987     0.200
     2.879    17.217     0.200
     3.276    17.245     0.200
     0.822     5.889     0.200
     0.824     6.214     0.200
     1.089     6.838     0.200
     1.196     7.714     0.200
     1.266     8.486     0.200
     1.266     7.937     0.200
     2.864    16.834     0.200
     0.528     4.915     0.200
     0.528     4.936     0.200
     0.564     4.180     0.200
     0.564     3.087     0.200
     0.677     4.923     0.200
     0.802     5.547     0.200
     0.802     5.715     0.200
     0.798     5.365     0.200
     0.970     6.136     0.200
     0.970     6.636     0.200
     0.969     6.322     0.200
     0.987     5.931     0.200
     1.034     6.302     0.200
     1.028     7.036     0.200
     1.058     6.476     0.200
     1.104     7.290     0.200
     1.584     8.950     0.200
     2.716    13.532     0.200
     0.498     4.442     0.200
     0.552     3.539     0.200
     0.551     3.547     0.200
     0.699     4.775     0.200
     0.813     5.085     0.200
     0.940     6.493     0.200
     0.940     5.845     0.200
     0.958     5.690     0.200
     1.034     6.135     0.200
     1.032     6.519     0.200
     1.032     6.648     0.200
     1.183     6.848     0.200
     1.337     7.512     0.200
     0.558     5.678     0.200
     0.619     4.157     0.200
     0.619     4.946     0.200
     1.055     7.088     0.200
     1.084     7.356     0.200
     1.328     8.471     0.200
     1.630    10.014     0.200
     0.593     4.500     0.200
     0.592     4.546     0.200
     1.321     8.726     0.200
     1.302     8.156     0.200
     1.378    10.964     0.200
     1.618    10.467     0.200
     0.528     4.650     0.200
     0.528     4.680     0.200
     0.566     3.956     0.200
     0.565     3.932     0.200
     0.676     5.413     0.200
     0.802     5.432     0.200
     0.797     5.804     0.200
     0.797     5.375     0.200
     0.970     5.873     0.200
     0.968     6.458     0.200
     0.968     6.661     0.200
     1.036     6.509     0.200
     1.028     6.444     0.200
     1.057     6.396     0.200
     1.105     7.126     0.200
     1.116     6.668     0.200
     1.586     8.721     0.200
     0.507     4.994     0.200
     0.507     4.352     0.200
     0.573     3.699     0.200
     0.573     3.676     0.200
     0.680     5.067     0.200
     0.792     5.744     0.200
     0.792     5.127     0.200
     0.968     7.186     0.200
     1.053     6.903     0.200
     1.028     6.723     0.200
     1.163     8.962     0.200
     1.204     7.792     0.200
     1.204     8.432     0.200
     1.286     7.667     0.200
     1.356     9.102     0.200
     1.606     9.387     0.200
     0.551     4.335     0.200
     0.550     4.304     0.200
     0.726     5.408     0.200
     0.824     5.901     0.200
     0.824     5.612     0.200
     0.888     7.390     0.200
     0.906     5.807     0.200
     0.949     7.956     0.200
     0.983     7.472     0.200
     1.048     7.444     0.200
     1.610    10.181     0.200
     0.558     4.188     0.200
     0.558     4.187     0.200
     0.710     5.526     0.200
     0.813     5.853     0.200
     0.998     7.388     0.200
     1.609     9.232     0.200
     0.500     5.217     0.200
     0.566     4.134     0.200
     0.566     4.106     0.200
     0.688     5.500     0.200
     0.799     5.894     0.200
     0.799     5.495     0.200
     1.026     6.922     0.200
     1.281     7.950     0.200
     1.322     7.739     0.200
     1.442     8.304     0.200
     1.602     9.422     0.200
     0.796     5.964     0.200
     1.063     6.856     0.200
     1.197     7.211     0.200
     1.279     8.105     0.200
     1.279     7.785     0.200
     1.665     9.716     0.200
     1.732    11.492     0.200
     0.514     4.086     0.200
     0.690     4.951     0.200
     0.708     4.697     0.200
     1.102     7.494     0.200
     1.326    10.242     0.200
     1.412     8.868     0.200
     1.614     9.462     0.200
     0.402     3.597     0.200
     0.757     5.275     0.200
     0.840     5.523     0.200
     0.834     5.988     0.200
     0.867     5.317     0.200
     0.931     5.779     0.200
     0.991     7.630     0.200
     1.068     6.173     0.200
     1.179     6.485     0.200
     1.569     8.368     0.200
     0.593     4.835     0.200
     0.642     4.926     0.200
     0.642     4.805     0.200
     0.740     6.011     0.200
     0.780     5.475     0.200
     1.013     6.715     0.200
     1.159     7.584     0.200
     1.251     7.627     0.200
     1.251     8.627     0.200
     1.322    10.894     0.200
     1.466    10.010     0.200
     1.520     8.655     0.200
     2.228    13.146     0.200
     2.291    15.823     0.200
     0.630     4.686     0.200
     0.630     4.417     0.200
     0.601     4.277     0.200
     0.724     5.839     0.200
     0.784     5.741     0.200
     1.008     6.627     0.200
     1.008     6.108     0.200
     1.242     7.646     0.200
     1.355     8.255     0.200
     1.454     9.482     0.200
     1.597     8.861     0.200
     1.629     8.616     0.200
     2.465    15.560     0.200
     0.584     4.841     0.200
     0.654     4.507     0.200
     0.653     4.644     0.200
     0.774     5.528     0.200
     1.019     6.600     0.200
     1.261     7.404     0.200
     1.335    10.569     0.200
     1.335    11.026     0.200
     1.382     8.641     0.200
     1.478    10.829     0.200
     1.524     8.491     0.200
     0.588     4.661     0.200
     0.657     4.339     0.200
     0.656     4.359     0.200
     0.783     5.225     0.200
     0.783     5.456     0.200
     0.769     6.530     0.200
     0.768     5.481     0.200
     1.039     7.736     0.200
     1.013     6.421     0.200
     1.013     6.281     0.200
     1.260     7.101     0.200
     1.350     9.432     0.200
     1.513     8.140     0.200
     2.946    17.235     0.200
     0.539     4.416     0.200
     0.682     4.212     0.200
     0.682     4.223     0.200
     0.696     5.125     0.200
     0.685     5.795     0.200
     0.685     5.805     0.200
     1.099     7.104     0.200
     1.099     7.303     0.200
     1.108     7.534     0.200
     1.132     7.554     0.200
     1.146     7.620     0.200
     1.306     8.232     0.200
     0.616     4.944     0.200
     0.605     4.784     0.200
     0.604     4.811     0.200
     0.640     4.999     0.200
     0.640     5.081     0.200
     0.772     5.559     0.200
     0.913     6.123     0.200
     1.026     6.715     0.200
     1.142     7.256     0.200
     1.216     7.839     0.200
     1.229     7.486     0.200
     1.418     8.962     0.200
     1.557     8.749     0.200
     1.557     8.630     0.200
     0.623     5.704     0.200
     0.602     4.723     0.200
     0.602     4.614     0.200
     0.603     4.574     0.200
     0.620     4.715     0.200
     0.769     5.420     0.200
     1.033     6.451     0.200
     1.145     7.134     0.200
     1.229     7.351     0.200
     1.292     8.003     0.200
     2.575    15.984     0.200
     0.348     2.916     0.200
     1.192     7.981     0.200
     1.382     9.420     0.200
     1.480    10.832     0.200
     2.815    16.512     0.200
     2.913    14.577     0.200
     0.624     5.684     0.200
     0.624     5.796     0.200
     0.601     4.874     0.200
     0.600     4.913     0.200
     0.621     4.892     0.200
     0.772     5.640     0.200
     0.897     6.714     0.200
     1.066     7.514     0.200
     1.066     7.693     0.200
     1.080     6.864     0.200
     1.030     6.857     0.200
     1.126     7.309     0.200
     1.226     7.544     0.200
     1.411     8.566     0.200
     1.563     8.892     0.200
     2.573    15.881     0.200
     4.643    26.528     0.200
     0.369     3.401     0.200
     1.201     7.612     0.200
     1.201     7.873     0.200
     1.365     8.294     0.200
     1.350     9.096     0.200
     1.638     8.935     0.200
     1.572     9.012     0.200
     0.603     4.645     0.200
     0.603     4.535     0.200
     0.618     5.047     0.200
     0.658     5.016     0.200
     0.780     5.368     0.200
     1.225     8.322     0.200
     1.309     8.550     0.200
     1.421    10.554     0.200
     1.561     9.986     0.200
     0.618     4.370     0.200
     0.618     4.526     0.200
     0.618     4.417     0.200
     0.604     4.640     0.200
     0.770     5.384     0.200
     0.770     5.494     0.200
     1.024     7.536     0.200
     1.238     8.420     0.200
     1.258    10.585     0.200
     1.325     8.840     0.200
     1.716    12.258     0.200
     2.248    12.600     0.200
     0.602     4.566     0.200
     0.758     5.302     0.200
     0.648     5.337     0.200
     0.648     5.276     0.200
     0.619     4.300     0.200
     0.618     4.328     0.200
     0.618     4.218     0.200
     1.088     7.670     0.200
     1.039     6.278     0.200
     1.235     8.666     0.200
     1.243     7.121     0.200
     1.314     8.123     0.200
     2.550    15.320     0.200
     0.597     4.934     0.200
     0.624     4.171     0.200
     0.623     4.155     0.200
     0.671     4.977     0.200
     0.762     5.164     0.200
     1.257     8.957     0.200
     1.245     7.930     0.200
     1.245     8.320     0.200
     1.328     8.266     0.200
     0.578     4.684     0.200
     0.643     4.152     0.200
     0.675     5.532     0.200
     0.740     5.030     0.200
     1.054     6.981     0.200
     1.054     7.121     0.200
     1.265     8.092     0.200
     1.342     8.759     0.200
     1.655     9.763     0.200
     0.683     5.087     0.200
     0.988     6.249     0.200
     1.167     7.242     0.200
     1.886    10.066     0.200
     3.114    14.659     0.200
     0.541     5.242     0.200
     0.541     5.220     0.200
     0.578     3.680     0.200
     0.816     5.415     0.200
     0.784     4.973     0.200
     0.978     6.844     0.200
     0.983     6.810     0.200
     1.001     6.285     0.200
     1.040     6.593     0.200
     1.040     6.792     0.200
     1.064     6.961     0.200
     1.044     5.931     0.200
     1.044     6.771     0.200
     1.209     7.666     0.200
     1.371     7.391     0.200
     1.404     7.450     0.200
     0.368     3.521     0.200
     0.368     3.493     0.200
     0.462     3.438     0.200
     0.461     3.435     0.200
     0.639     4.459     0.200
     0.821     5.020     0.200
     0.982     5.734     0.200
     0.362     3.537     0.200
     0.363     3.565     0.200
     0.464     3.456     0.200
     0.464     3.393     0.200
     0.634     4.399     0.200
     0.828     5.284     0.200
     0.956     5.743     0.200
     0.986     5.764     0.200
     0.986     5.904     0.200
     1.212     6.538     0.200
     0.236     1.928     0.200
     0.354     3.559     0.200
     0.354     3.550     0.200
     0.460     4.345     0.200
     0.460     4.166     0.200
     0.565     4.238     0.200
     0.593     4.838     0.200
     0.642     4.305     0.200
     0.755     5.279     0.200
     0.725     4.890     0.200
     0.739     4.901     0.200
     0.742     5.854     0.200
     0.743     6.152     0.200
     0.785     5.722     0.200
     0.945     6.423     0.200
     1.088     6.936     0.200
     1.103     7.217     0.200
     1.146     8.052     0.200
     1.198     7.676     0.200
     1.268     8.886     0.200
     1.305     8.295     0.200
     1.403     9.063     0.200
     1.437     9.007     0.200
     1.414     9.090     0.200
     0.238     2.024     0.200
     0.238     2.016     0.200
     0.330     3.997     0.200
     0.599     4.485     0.200
     0.726     4.915     0.200
     0.771     5.169     0.200
     0.824     5.360     0.200
     0.824     5.770     0.200
     1.126     7.195     0.200
     1.225     7.344     0.200
     1.334     8.088     0.200
     1.430     8.961     0.200
     1.475     8.652     0.200
     0.387     3.843     0.200
     0.387     3.973     0.200
     0.472     3.614     0.200
     0.473     3.658     0.200
     0.658     4.794     0.200
     0.826     5.524     0.200
     0.840     5.106     0.200
     0.849     5.284     0.200
     0.849     5.663     0.200
     0.892     5.523     0.200
     0.971     6.246     0.200
     0.972     5.590     0.200
     1.036     7.943     0.200
     0.987     5.964     0.200
     1.099     6.485     0.200
     0.379     3.927     0.200
     0.475     3.570     0.200
     0.474     3.565     0.200
     0.651     4.955     0.200
     0.819     5.196     0.200
     0.841     5.516     0.200
     0.834     5.004     0.200
     0.884     5.504     0.200
     0.964     5.704     0.200
     0.956     6.032     0.200
     0.956     6.173     0.200
     0.964     6.905     0.200
     0.992     6.022     0.200
     0.992     5.882     0.200
     1.100     6.369     0.200
     1.229     6.635     0.200
     0.497     4.146     0.200
     0.829     5.980     0.200
     0.846     5.684     0.200
     0.842     6.470     0.200
     0.891     6.451     0.200
     0.891     6.318     0.200
     0.975     6.945     0.200
     0.890     5.918     0.200
     0.958     6.643     0.200
     1.012     6.515     0.200
     1.094     7.742     0.200
     1.179     7.262     0.200
     0.415     4.646     0.200
     0.415     4.668     0.200
     0.533     3.994     0.200
     0.534     3.979     0.200
     0.690     5.566     0.200
     0.857     5.989     0.200
     0.857     5.700     0.200
     0.877     5.605     0.200
     0.856     6.784     0.200
     0.914     6.312     0.200
     1.042     6.359     0.200
     1.117     7.936     0.200
     0.354     3.072     0.200
     0.810     5.577     0.200
     0.810     5.858     0.200
     0.943     6.358     0.200
     0.997     6.089     0.200
     1.095     6.747     0.200
     1.149     7.168     0.200
     1.216     7.104     0.200
     1.306     7.282     0.200
     1.292     7.276     0.200
     0.376     3.732     0.200
     0.376     3.793     0.200
     0.489     3.421     0.200
     0.488     3.400     0.200
     0.833     5.176     0.200
     0.952     5.657     0.200
     1.007     6.441     0.200
     1.007     6.308     0.200
     0.762     6.185     0.200
     0.696     5.222     0.200
     1.197     8.398     0.200
     1.071     7.272     0.200
     1.203     7.811     0.200
     1.415     9.132     0.200
     0.953     7.103     0.200
     0.725     5.308     0.200
     1.167     7.309     0.200
     1.514    10.091     0.200
     1.564    10.290     0.200
     1.845    10.637     0.200
     0.612     4.892     0.200
     0.589     4.444     0.200
     0.589     5.346     0.200
     0.620     4.095     0.200
     1.018     7.343     0.200
     1.072     7.096     0.200
     1.250     8.112     0.200
     1.420    11.075     0.200
     0.619     3.756     0.200
     0.617     4.871     0.200
     1.075     6.548     0.200
     1.005     7.284     0.200
     1.040     7.127     0.200
     1.079     6.547     0.200
     1.250     7.926     0.200
     1.416    10.350     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.009    20.340     0.200
     2.207    39.898     0.200
     2.679    42.886     0.200
     0.901    18.340     0.200
     1.581    28.353     0.200
     2.327    38.957     0.200
     1.073    20.373     0.200
     1.398    26.455     0.200
     1.666    30.346     0.200
     1.953    32.083     0.200
     2.161    37.715     0.200
     2.232    37.655     0.200
     2.413    39.943     0.200
     2.399    40.546     0.200
     2.486    41.916     0.200
     2.783    44.852     0.200
     2.718    45.092     0.200
     2.800    45.773     0.200
     2.857    46.308     0.200
     3.004    49.384     0.200
     3.081    50.901     0.200
     3.227    51.453     0.200
     3.328    52.876     0.200
     3.524    54.395     0.200
     3.497    56.253     0.200
     3.664    57.272     0.200
     3.683    58.028     0.200
     3.819    60.113     0.200
     3.866    59.529     0.200
     3.966    61.985     0.200
     4.209    64.138     0.200
     4.642    70.622     0.200
     4.712    72.440     0.200
     4.710    73.138     0.200
     4.743    73.594     0.200
     4.779    72.909     0.200
     5.246    79.650     0.200
     1.084    20.630     0.200
     1.392    26.457     0.200
     1.668    30.806     0.200
     1.961    32.933     0.200
     2.150    37.183     0.200
     2.416    40.019     0.200
     2.395    40.566     0.200
     2.575    43.291     0.200
     2.978    47.482     0.200
     2.996    48.341     0.200
     3.216    51.782     0.200
     3.327    52.952     0.200
     3.392    54.229     0.200
     3.489    55.804     0.200
     3.661    57.102     0.200
     3.651    56.758     0.200
     3.671    57.031     0.200
     3.810    60.223     0.200
     3.854    59.831     0.200
     3.892    60.059     0.200
     3.954    61.213     0.200
     4.211    63.708     0.200
     4.298    64.956     0.200
     4.319    65.098     0.200
     4.630    70.238     0.200
     4.706    71.979     0.200
     4.735    72.589     0.200
     4.926    74.024     0.200
     1.094    21.227     0.200
     1.094    22.496     0.200
     1.370    26.628     0.200
     1.646    31.202     0.200
     2.372    40.959     0.200
     2.779    46.315     0.200
     3.504    55.300     0.200
     3.657    58.511     0.200
     3.791    60.460     0.200
     3.670    58.688     0.200
     3.846    60.248     0.200
     1.067    21.547     0.200
     1.399    26.284     0.200
     1.280    24.382     0.200
     1.488    28.203     0.200
     2.143    38.035     0.200
     2.230    37.629     0.200
     2.625    42.310     0.200
     3.343    53.093     0.200
     3.750    59.654     0.200
     0.947    19.134     0.200
     1.783    31.120     0.200
     3.436    52.944     0.200
     4.166    59.990     0.200
     5.936    85.490     0.200
     9.819   138.052     0.200
     1.601    27.563     0.200
     2.534    43.067     0.200
     2.653    40.894     0.200
     2.694    40.782     0.200
     2.942    45.911     0.200
     3.077    47.122     0.200
     3.221    49.286     0.200
     3.662    60.284     0.200
     8.289   120.166     0.200
     2.922    42.354     0.200
     3.074    48.038     0.200
     3.080    51.343     0.200
     3.080    45.695     0.200
     3.183    51.455     0.200
     3.383    52.844     0.200
     3.640    56.272     0.200
     5.145    78.426     0.200
     5.174    81.815     0.200
     5.323    80.907     0.200
     6.379    94.241     0.200
     6.869    99.799     0.200
     7.120   104.834     0.200
     7.636   106.646     0.200
     8.787   119.584     0.200
     8.905   120.618     0.200
     1.287    22.467     0.200
     1.367    24.610     0.200
     1.367    22.977     0.200
     2.879    42.756     0.200
     3.050    50.878     0.200
     3.050    47.886     0.200
     2.959    43.722     0.200
     3.689    60.274     0.200
     4.071    65.379     0.200
     4.574    75.556     0.200
     4.710    76.821     0.200
     4.801    77.877     0.200
     4.818    79.086     0.200
     7.680   108.434     0.200
     9.024   124.976     0.200
     9.134   164.357     0.200
    14.490   202.378     0.200
    15.266   213.050     0.200
    17.253   231.586     0.200
    20.140   270.591     0.200
     1.465    25.758     0.200
     1.946    33.177     0.200
     2.960    46.552     0.200
     3.013    47.223     0.200
     3.621    57.963     0.200
     1.378    24.177     0.200
     2.960    45.787     0.200
     3.038    47.575     0.200
     3.451    49.979     0.200
     7.942   110.044     0.200
     9.127   127.047     0.200
     1.188    21.371     0.200
     2.844    43.812     0.200
     3.219    50.354     0.200
     3.605    55.319     0.200
     3.916    59.187     0.200
     4.061    59.856     0.200
     5.423    78.773     0.200
     9.260   129.421     0.200
     2.925    48.666     0.200
     3.133    50.286     0.200
     3.538    51.700     0.200
     5.342    82.290     0.200
     0.743    17.988     0.200
     1.216    23.297     0.200
     1.484    27.790     0.200
     2.081    35.447     0.200
     2.471    40.867     0.200
     2.598    43.620     0.200
     3.683    56.770     0.200
     9.668   134.099     0.200
     2.182    35.691     0.200
     2.334    38.455     0.200
     2.918    45.476     0.200
     3.012    46.193     0.200
     7.647   117.260     0.200
     7.820   123.053     0.200
     9.296   125.708     0.200
     2.171    34.809     0.200
     2.344    38.923     0.200
     2.936    47.203     0.200
     3.029    47.785     0.200
     3.134    44.562     0.200
     3.377    46.993     0.200
     3.880    57.522     0.200
     5.403    85.703     0.200
     6.034    96.830     0.200
     6.516    78.028     0.200
     7.632   118.037     0.200
     8.135   114.867     0.200
     9.273   126.616     0.200
    22.001   288.694     0.200
     1.716    28.528     0.200
     2.813    40.402     0.200
     0.626    14.328     0.200
     1.379    25.319     0.200
     1.601    28.780     0.200
     2.000    33.749     0.200
     2.192    35.083     0.200
     2.346    38.340     0.200
     3.129    50.204     0.200
     0.796    18.498     0.200
     1.052    20.578     0.200
     1.403    25.903     0.200
     0.345     9.326     0.200
     3.058    47.538     0.200
     0.735    16.218     0.200
     1.669    27.912     0.200
     2.068    33.557     0.200
     2.218    34.350     0.200
     2.309    36.742     0.200
     3.751    56.897     0.200
     0.314     8.262     0.200
     1.395    22.346     0.200
     1.395    25.557     0.200
     1.474    26.319     0.200
     1.316    21.622     0.200
     2.421    36.330     0.200
     3.008    43.685     0.200
     3.081    51.410     0.200
     3.301    53.508     0.200
     1.549    26.147     0.200
     1.699    29.464     0.200
     2.519    42.397     0.200
     4.029    63.613     0.200
     5.378    76.475     0.200
     0.591    14.147     0.200
     0.591    14.561     0.200
     1.061    18.839     0.200
     1.518    26.313     0.200
     1.595    26.942     0.200
     1.729    29.121     0.200
     2.505    36.632     0.200
     2.625    43.947     0.200
     3.198    49.408     0.200
     3.484    51.951     0.200
     4.081    59.474     0.200
     4.284    65.834     0.200
     5.426    77.735     0.200
     2.604    45.119     0.200
     4.023    63.405     0.200
     5.676    82.735     0.200
     0.866    16.954     0.200
     0.995    17.776     0.200
     1.177    20.315     0.200
     1.089    20.481     0.200
     1.588    27.718     0.200
     2.601    40.909     0.200
     1.112    20.649     0.200
     1.338    24.497     0.200
     1.453    24.633     0.200
     1.533    27.717     0.200
     2.873    42.536     0.200
     3.159    49.270     0.200
     3.262    53.680     0.200
     3.597    55.136     0.200
     3.723    57.762     0.200
     5.086    76.450     0.200
     5.619    80.624     0.200
     7.395   103.148     0.200
     7.976   105.611     0.200
     0.632    13.717     0.200
     0.632    15.837     0.200
     0.807    17.670     0.200
     4.220    64.410     0.200
     5.717    81.502     0.200
     6.857    95.720     0.200
     0.826    17.880     0.200
     0.612    15.057     0.200
     0.773    16.388     0.200
     1.546    27.006     0.200
     2.180    36.755     0.200
     1.038    20.899     0.200
     1.135    21.831     0.200
     0.585    13.150     0.200
     0.585    13.838     0.200
     0.673    13.951     0.200
     0.673    15.033     0.200
     2.335    37.350     0.200
     3.183    49.687     0.200
     1.103    19.555     0.200
     1.226    22.938     0.200
     1.554    27.760     0.200
     6.908   102.674     0.200
     3.260    51.882     0.200
     3.490    54.673     0.200
     3.911    65.096     0.200
     4.046    60.457     0.200
     8.167   112.645     0.200
     0.449    11.156     0.200
     1.202    20.798     0.200
     1.464    25.133     0.200
     3.939    57.996     0.200
     1.078    19.738     0.200
     2.774    46.232     0.200
     2.855    44.360     0.200
     7.535   106.420     0.200
     3.225    50.010     0.200
     3.225    49.557     0.200
     3.279    51.782     0.200
     3.519    53.450     0.200
     5.316    78.946     0.200
     6.351    95.215     0.200
     7.559   107.021     0.200
     7.723   108.341     0.200
     7.723   111.872     0.200
     7.992   115.914     0.200
     8.242   120.793     0.200
     8.312   123.087     0.200
     8.515   124.753     0.200
     8.830   124.238     0.200
     9.052   128.944     0.200
     9.170   126.955     0.200
    10.150   147.466     0.200
    11.389   164.839     0.200
    12.347   171.706     0.200
    12.992   178.848     0.200
    13.213   181.956     0.200
    13.645   186.444     0.200
    14.198   192.823     0.200
     0.939    21.380     0.200
     0.954    21.369     0.200
     1.401    25.938     0.200
     2.080    36.241     0.200
     3.931    56.130     0.200
     4.388    64.020     0.200
     7.568   105.511     0.200
     7.778   118.432     0.200
     0.941    17.611     0.200
     1.670    28.103     0.200
     2.015    34.088     0.200
     2.074    33.997     0.200
     4.392    66.262     0.200
     0.941    17.202     0.200
     1.491    25.800     0.200
     1.690    27.734     0.200
     3.245    53.550     0.200
     3.341    54.578     0.200
     3.490    53.045     0.200
     4.022    57.325     0.200
     8.245   117.355     0.200
     1.579    27.462     0.200
     0.676    15.415     0.200
     0.752    16.794     0.200
     1.235    23.396     0.200
     1.515    25.946     0.200
     2.983    48.016     0.200
     3.137    49.183     0.200
     3.295    54.225     0.200
     3.538    53.400     0.200
     3.936    60.057     0.200
     5.299    76.957     0.200
     6.053    88.447     0.200
     0.718    14.699     0.200
     0.794    16.735     0.200
     0.975    19.197     0.200
     0.997    20.214     0.200
     2.651    41.419     0.200
     3.280    49.043     0.200
     4.037    62.568     0.200
     4.114    66.665     0.200
     1.013    19.980     0.200
     2.688    45.300     0.200
     3.420    53.345     0.200
     4.019    64.038     0.200
     9.234   130.257     0.200
     0.466    11.451     0.200
     0.935    17.398     0.200
     3.270    43.235     0.200
     4.491    61.712     0.200
     8.432   113.246     0.200
     8.964   115.919     0.200
     9.089   120.977     0.200
     9.458   127.339     0.200
    11.975   156.454     0.200
    13.868   181.713     0.200
    15.575   203.088     0.200
    15.596   203.359     0.200
    15.610   203.791     0.200
    15.855   207.127     0.200
     0.503    12.439     0.200
     0.861    16.613     0.200
     0.949    18.300     0.200
     1.044    19.175     0.200
     1.882    32.572     0.200
     1.929    31.447     0.200
     2.921    41.950     0.200
     3.260    51.992     0.200
     3.792    59.743     0.200
     4.024    55.172     0.200
     0.537    13.984     0.200
     0.811    18.491     0.200
     1.364    24.733     0.200
     1.579    27.952     0.200
     0.459    11.886     0.200
     1.919    34.031     0.200
     2.665    42.903     0.200
     3.209    53.840     0.200
     8.181   116.114     0.200
     8.923   125.254     0.200
     0.452    11.760     0.200
     1.757    28.733     0.200
     1.783    30.695     0.200
     2.771    42.580     0.200
     3.289    50.517     0.200
     3.398    49.772     0.200
     3.539    53.990     0.200
     3.878    59.002     0.200
     5.160    74.343     0.200
     5.823    80.512     0.200
     1.164    19.900     0.200
     1.687    29.094     0.200
     3.218    52.605     0.200
     1.109    18.602     0.200
     1.749    29.988     0.200
     1.775    29.710     0.200
     2.779    42.400     0.200
     3.371    50.431     0.200
     3.406    54.696     0.200
     5.831    79.524     0.200
     0.560    13.400     0.200
     0.560    12.232     0.200
     0.645    14.006     0.200
     0.645    14.896     0.200
     1.593    26.736     0.200
     2.174    33.277     0.200
     1.783    31.134     0.200
     1.783    30.194     0.200
     4.225    68.528     0.200
     9.058   127.916     0.200
     1.686    30.578     0.200
     1.721    29.523     0.200
     3.230    51.640     0.200
     0.739    17.546     0.200
     0.739    18.114     0.200
     1.026    20.315     0.200
     0.706    15.250     0.200
     1.066    19.452     0.200
     0.704    15.808     0.200
     0.704    16.000     0.200
     1.157    22.016     0.200
     1.500    25.587     0.200
     2.627    43.751     0.200
     0.733    15.875     0.200
     1.094    20.504     0.200
     1.205    23.016     0.200
     1.526    27.747     0.200
     1.526    27.490     0.200
     1.579    28.352     0.200
     2.039    34.635     0.200
     2.769    39.868     0.200
     9.162   129.476     0.200
     1.228    23.671     0.200
     1.480    26.889     0.200
     2.205    38.298     0.200
     2.269    38.514     0.200
     3.730    60.325     0.200
     4.231    67.115     0.200
     1.940    32.061     0.200
     2.015    31.798     0.200
     2.560    39.987     0.200
     3.570    52.628     0.200
     3.680    58.562     0.200
     2.014    32.462     0.200
     3.155    53.075     0.200
     3.581    50.001     0.200
     3.689    59.041     0.200
     3.690    55.173     0.200
     5.043    69.750     0.200
     0.550    12.988     0.200
     0.905    16.629     0.200
     1.898    32.919     0.200
     1.971    32.637     0.200
     3.503    53.287     0.200
     0.854    18.854     0.200
     2.026    32.936     0.200
     2.013    33.116     0.200
     2.549    44.319     0.200
     2.549    41.788     0.200
     2.788    47.086     0.200
     3.138    52.010     0.200
     3.670    59.319     0.200
     3.669    58.663     0.200
     3.952    64.161     0.200
     8.020   113.225     0.200
     0.847    18.513     0.200
     0.929    21.040     0.200
     1.947    33.497     0.200
     1.947    33.075     0.200
     2.026    32.727     0.200
     2.004    36.147     0.200
     2.560    43.952     0.200
     2.560    41.393     0.200
     3.585    52.677     0.200
     3.554    56.420     0.200
     3.686    59.863     0.200
     3.686    57.722     0.200
     3.681    57.831     0.200
     5.039    71.247     0.200
     1.971    29.637     0.200
     2.593    36.602     0.200
     3.717    52.674     0.200
     1.975    32.911     0.200
     3.195    49.441     0.200
     3.582    53.009     0.200
     3.723    60.524     0.200
     0.540    12.536     0.200
     2.850    46.437     0.200
     2.836    44.399     0.200
     3.564    57.429     0.200
     3.720    60.064     0.200
     5.058    78.890     0.200
     2.622    44.038     0.200
     3.208    47.518     0.200
     3.603    56.788     0.200
     3.743    58.263     0.200
     3.736    57.700     0.200
     5.090    79.766     0.200
     8.058   113.841     0.200
     1.946    31.095     0.200
     1.966    32.562     0.200
     2.590    44.077     0.200
     2.590    38.499     0.200
     3.202    50.826     0.200
     3.518    55.919     0.200
     3.671    59.627     0.200
     3.704    56.818     0.200
     5.027    73.136     0.200
     0.924    17.764     0.200
     1.420    25.814     0.200
     1.485    26.530     0.200
     1.726    29.801     0.200
     1.880    31.820     0.200
     1.952    30.942     0.200
     1.953    33.056     0.200
     3.207    52.164     0.200
     3.484    53.589     0.200
     3.551    55.207     0.200
     3.722    59.085     0.200
     8.007   116.969     0.200
     8.821   121.334     0.200
     1.901    33.909     0.200
     1.968    33.750     0.200
     1.975    33.863     0.200
     3.506    57.061     0.200
     0.854    19.358     0.200
     0.854    18.374     0.200
     1.547    28.458     0.200
     1.784    31.962     0.200
     2.011    34.879     0.200
     2.551    42.558     0.200
     3.140    52.149     0.200
     3.571    58.375     0.200
     3.673    57.890     0.200
     3.260    51.104     0.200
     3.424    56.617     0.200
     3.514    53.879     0.200
     3.744    58.173     0.200
     0.876    18.862     0.200
     0.901    19.958     0.200
     0.901    20.450     0.200
     2.534    41.565     0.200
     3.144    51.286     0.200
     3.144    48.700     0.200
     3.509    56.370     0.200
     3.650    58.403     0.200
     0.900    19.809     0.200
     1.953    32.610     0.200
     1.983    34.898     0.200
     3.189    53.078     0.200
     3.685    59.974     0.200
     0.555    12.838     0.200
     1.949    32.177     0.200
     2.597    37.480     0.200
     3.205    52.524     0.200
     3.685    58.560     0.200
     3.685    57.419     0.200
     3.712    59.285     0.200
     0.529    13.562     0.200
     1.926    33.930     0.200
     2.625    43.012     0.200
     2.625    41.551     0.200
     3.232    51.627     0.200
     3.459    56.021     0.200
     3.546    52.641     0.200
     3.550    57.979     0.200
     3.709    58.072     0.200
     3.740    60.729     0.200
     1.901    32.378     0.200
     1.958    31.660     0.200
     3.185    49.399     0.200
     3.499    55.190     0.200
     3.500    55.536     0.200
     3.590    52.936     0.200
     3.647    58.491     0.200
     3.681    58.517     0.200
     1.434    25.969     0.200
     1.897    31.110     0.200
     1.974    31.395     0.200
     2.598    44.308     0.200
     3.192    49.735     0.200
     3.503    50.390     0.200
     3.704    60.451     0.200
     3.717    60.044     0.200
     1.892    33.102     0.200
     1.948    32.068     0.200
     2.576    43.820     0.200
     3.195    52.006     0.200
     3.490    54.122     0.200
     3.653    59.871     0.200
     5.009    78.012     0.200
     1.924    31.376     0.200
     1.990    32.576     0.200
     2.560    43.056     0.200
     2.560    42.306     0.200
     2.827    46.933     0.200
     2.827    44.013     0.200
     3.163    49.936     0.200
     3.163    49.426     0.200
     3.526    56.677     0.200
     3.660    58.345     0.200
     3.677    57.331     0.200
     3.977    63.331     0.200
     5.015    76.535     0.200
     7.988   109.425     0.200
     1.938    29.773     0.200
     2.010    30.264     0.200
     2.804    43.628     0.200
     2.880    41.324     0.200
     3.150    48.542     0.200
     3.150    48.054     0.200
     3.557    57.430     0.200
     3.669    57.735     0.200
     3.675    55.660     0.200
     7.664   109.597     0.200
     8.009   113.857     0.200
     1.905    32.415     0.200
     3.699    60.200     0.200
     1.946    30.940     0.200
     2.580    43.215     0.200
     3.197    50.671     0.200
     3.693    59.547     0.200
     4.010    64.929     0.200
     0.927    19.469     0.200
     1.391    26.333     0.200
     1.452    26.167     0.200
     1.692    30.399     0.200
     1.874    32.681     0.200
     1.874    31.732     0.200
     1.935    30.687     0.200
     2.598    45.258     0.200
     2.598    41.899     0.200
     2.882    49.302     0.200
     2.882    49.021     0.200
     3.212    47.105     0.200
     3.517    58.203     0.200
     3.676    56.689     0.200
     3.712    60.314     0.200
     4.399    69.289     0.200
     1.863    32.178     0.200
     1.914    31.103     0.200
     2.597    40.460     0.200
     3.480    55.521     0.200
     3.548    54.082     0.200
     5.014    72.381     0.200
     0.895    18.751     0.200
     1.890    32.980     0.200
     1.942    32.241     0.200
     2.574    41.345     0.200
     2.880    45.903     0.200
     3.197    50.608     0.200
     3.485    56.511     0.200
     3.576    56.404     0.200
     3.686    60.713     0.200
     4.010    66.019     0.200
     0.475    11.906     0.200
     0.474    11.918     0.200
     0.543    11.619     0.200
     0.717    14.541     0.200
     1.590    27.108     0.200
     2.099    33.763     0.200
     2.096    32.806     0.200
     0.734    17.378     0.200
     0.727    15.445     0.200
     0.830    17.035     0.200
     1.165    21.845     0.200
     1.727    29.807     0.200
     3.184    49.696     0.200
     1.900    32.359     0.200
     1.954    31.934     0.200
     2.567    41.485     0.200
     2.867    46.218     0.200
     2.867    43.408     0.200
     3.186    49.970     0.200
     3.493    55.782     0.200
     3.680    59.910     0.200
     3.841    61.165     0.200
     4.827    73.931     0.200
     0.984    16.924     0.200
     1.914    32.046     0.200
     1.956    33.051     0.200
     3.224    51.963     0.200
     3.708    60.518     0.200
     0.567    12.947     0.200
     1.899    31.968     0.200
     2.614    41.818     0.200
     3.240    53.448     0.200
     3.487    50.520     0.200
     3.671    57.430     0.200
     3.723    59.997     0.200
     1.494    26.256     0.200
     1.920    32.800     0.200
     1.985    32.401     0.200
     1.995    35.239     0.200
     1.995    34.369     0.200
     2.563    44.476     0.200
     2.832    45.106     0.200
     3.167    52.966     0.200
     3.167    51.506     0.200
     3.530    52.171     0.200
     3.660    60.637     0.200
     3.809    63.284     0.200
     4.349    68.225     0.200
     1.530    26.343     0.200
     1.941    33.400     0.200
     1.941    32.159     0.200
     2.007    34.342     0.200
     2.007    31.522     0.200
     2.013    30.658     0.200
     2.554    41.989     0.200
     3.148    51.438     0.200
     3.558    55.843     0.200
     3.558    53.602     0.200
     3.637    52.220     0.200
     3.668    56.580     0.200
     3.673    57.854     0.200
     4.450    68.682     0.200
     8.782   122.016     0.200
     1.470    26.705     0.200
     1.707    30.102     0.200
     1.906    33.617     0.200
     1.906    32.239     0.200
     1.966    31.097     0.200
     1.987    33.111     0.200
     2.569    42.650     0.200
     3.181    53.696     0.200
     3.181    51.356     0.200
     3.655    57.554     0.200
     3.655    55.085     0.200
     3.683    59.683     0.200
     3.829    61.335     0.200
     3.994    64.152     0.200
     4.370    67.663     0.200
     4.814    74.040     0.200
     5.010    73.865     0.200
     5.608    85.226     0.200
     5.616    81.984     0.200
     1.888    32.469     0.200
     1.939    31.039     0.200
     1.981    34.300     0.200
     3.198    49.364     0.200
     3.198    50.914     0.200
     3.642    58.026     0.200
     3.685    55.806     0.200
     4.011    63.472     0.200
     4.843    73.063     0.200
     0.847    17.680     0.200
     1.590    28.745     0.200
     1.835    32.220     0.200
     1.893    33.668     0.200
     1.928    34.416     0.200
     3.207    48.556     0.200
     3.670    55.799     0.200
     3.785    60.666     0.200
     3.769    62.644     0.200
     0.859    18.144     0.200
     0.859    18.874     0.200
     3.194    53.250     0.200
     3.632    56.426     0.200
     3.749    60.551     0.200
     3.742    61.834     0.200
     3.795    60.597     0.200
     0.822    17.885     0.200
     1.622    28.743     0.200
     2.648    38.022     0.200
     3.200    53.110     0.200
     3.200    52.032     0.200
     3.700    52.835     0.200
     3.775    60.687     0.200
     3.802    61.500     0.200
     3.802    61.055     0.200
     4.750    72.095     0.200
     5.153    72.449     0.200
     1.900    32.235     0.200
     1.959    31.295     0.200
     1.983    33.933     0.200
     2.573    39.176     0.200
     2.860    47.652     0.200
     3.186    49.912     0.200
     3.509    52.687     0.200
     3.656    50.065     0.200
     3.687    57.355     0.200
     5.012    72.603     0.200
     0.571    12.819     0.200
     1.926    31.949     0.200
     1.993    32.306     0.200
     1.998    30.645     0.200
     2.567    40.590     0.200
     2.868    42.269     0.200
     3.163    47.372     0.200
     3.557    53.157     0.200
     3.677    54.571     0.200
     3.686    58.518     0.200
     5.031    71.768     0.200
     5.595    79.548     0.200
     5.919    87.062     0.200
     0.947    18.915     0.200
     1.700    28.911     0.200
     1.861    33.451     0.200
     1.861    33.670     0.200
     1.928    33.030     0.200
     1.940    34.034     0.200
     1.940    34.432     0.200
     2.616    44.453     0.200
     3.226    51.481     0.200
     3.463    52.873     0.200
     3.535    54.552     0.200
     3.554    56.635     0.200
     3.698    57.170     0.200
     4.039    67.213     0.200
     4.404    69.876     0.200
     4.847    75.862     0.200
     5.985    86.044     0.200
     1.900    31.434     0.200
     1.958    31.195     0.200
     1.984    31.262     0.200
     3.186    49.367     0.200
     3.499    53.803     0.200
     3.506    53.115     0.200
     3.685    56.975     0.200
     1.162    21.631     0.200
     2.572    44.965     0.200
     3.033    52.169     0.200
     3.033    46.239     0.200
     3.266    53.149     0.200
     3.266    52.540     0.200
     3.406    58.267     0.200
     3.533    59.942     0.200
     3.660    61.729     0.200
     4.075    68.135     0.200
     4.991    77.760     0.200
     4.894    79.235     0.200
     5.663    85.084     0.200
     1.880    33.808     0.200
     1.880    32.189     0.200
     1.955    35.054     0.200
     1.955    33.853     0.200
     1.948    31.826     0.200
     2.602    45.185     0.200
     2.602    40.984     0.200
     3.208    50.461     0.200
     3.208    48.711     0.200
     3.483    54.093     0.200
     3.542    50.719     0.200
     7.998   115.683     0.200
     1.916    31.503     0.200
     1.943    31.651     0.200
     2.782    43.123     0.200
     2.902    48.135     0.200
     3.230    51.953     0.200
     3.230    50.723     0.200
     3.455    52.238     0.200
     3.510    53.824     0.200
     3.725    58.764     0.200
     1.943    33.781     0.200
     2.601    38.566     0.200
     2.872    45.328     0.200
     3.210    47.653     0.200
     3.479    54.988     0.200
     3.532    56.027     0.200
     3.686    52.800     0.200
     3.716    60.754     0.200
     5.042    75.346     0.200
     5.639    77.057     0.200
     7.989   116.559     0.200
     1.920    32.269     0.200
     1.993    32.889     0.200
     2.565    41.367     0.200
     3.523    51.855     0.200
     3.539    53.548     0.200
     3.614    58.635     0.200
     0.923    19.537     0.200
     1.502    27.589     0.200
     1.740    31.786     0.200
     1.982    35.400     0.200
     1.982    34.088     0.200
     3.693    60.253     0.200
     4.418    74.420     0.200
     0.914    18.102     0.200
     1.482    26.811     0.200
     1.921    31.432     0.200
     2.001    35.419     0.200
     2.001    33.607     0.200
     2.555    40.860     0.200
     2.846    46.719     0.200
     2.838    48.386     0.200
     3.165    53.169     0.200
     3.521    57.298     0.200
     3.514    52.171     0.200
     3.611    53.456     0.200
     3.647    59.058     0.200
     3.671    58.992     0.200
     3.979    65.949     0.200
     4.416    64.348     0.200
     7.968   111.418     0.200
     0.925    19.481     0.200
     0.911    20.645     0.200
     0.911    20.363     0.200
     1.492    27.622     0.200
     1.731    31.335     0.200
     1.903    34.551     0.200
     1.971    32.955     0.200
     1.976    34.932     0.200
     1.976    35.080     0.200
     2.582    41.809     0.200
     2.844    46.811     0.200
     3.185    53.695     0.200
     3.506    57.883     0.200
     3.542    54.632     0.200
     3.597    58.963     0.200
     1.096    20.531     0.200
     1.300    24.480     0.200
     1.712    31.180     0.200
     1.977    35.285     0.200
     1.998    35.140     0.200
     2.155    36.576     0.200
     3.504    56.850     0.200
     1.868    32.606     0.200
     1.924    31.866     0.200
     1.958    34.522     0.200
     2.895    46.030     0.200
     3.218    50.191     0.200
     3.466    54.773     0.200
     3.497    54.666     0.200
     3.665    58.029     0.200
     3.708    60.613     0.200
     5.022    74.243     0.200
     5.643    88.409     0.200
     0.631    15.683     0.200
     0.890    18.261     0.200
     3.267    53.874     0.200
     3.390    51.481     0.200
     3.617    56.365     0.200
     3.617    56.205     0.200
     3.707    57.756     0.200
     4.977    75.335     0.200
     2.005    32.823     0.200
     2.016    31.221     0.200
     2.798    45.323     0.200
     3.547    56.285     0.200
     3.677    58.687     0.200
     3.639    55.989     0.200
     0.908    18.719     0.200
     1.496    27.716     0.200
     1.985    31.898     0.200
     1.994    34.348     0.200
     2.564    40.079     0.200
     2.831    47.734     0.200
     3.522    59.350     0.200
     3.612    60.242     0.200
     3.681    58.566     0.200
     0.515    11.736     0.200
     1.951    33.423     0.200
     1.987    32.041     0.200
     3.194    51.269     0.200
     3.508    56.447     0.200
     3.614    55.560     0.200
     3.736    58.754     0.200
     5.090    77.834     0.200
     1.780    30.439     0.200
     1.916    32.083     0.200
     1.974    33.602     0.200
     1.998    31.811     0.200
     2.589    40.744     0.200
     3.175    49.654     0.200
     3.524    55.057     0.200
     3.590    57.239     0.200
     3.708    58.568     0.200
     5.061    78.131     0.200
     1.743    29.200     0.200
     2.597    42.978     0.200
     2.845    47.244     0.200
     3.499    58.547     0.200
     3.562    58.733     0.200
     3.698    59.456     0.200
     5.053    75.426     0.200
     5.626    84.628     0.200
     0.516    12.013     0.200
     1.460    25.106     0.200
     1.524    26.233     0.200
     1.766    29.908     0.200
     1.968    31.539     0.200
     2.619    38.486     0.200
     2.843    42.488     0.200
     3.207    49.806     0.200
     3.493    56.148     0.200
     3.595    56.842     0.200
     3.730    56.612     0.200
     5.084    74.994     0.200
     5.642    79.176     0.200
     0.966    17.191     0.200
     1.928    32.106     0.200
     2.627    41.816     0.200
     3.240    54.617     0.200
     3.448    57.488     0.200
     0.540    12.473     0.200
     1.964    31.061     0.200
     3.716    57.414     0.200
     4.419    65.460     0.200
     0.908    19.759     0.200
     0.908    20.298     0.200
     0.910    19.372     0.200
     1.915    33.054     0.200
     1.980    33.191     0.200
     1.990    34.235     0.200
     2.567    39.261     0.200
     2.836    45.019     0.200
     3.684    57.212     0.200
     0.563    12.630     0.200
     1.512    26.601     0.200
     1.915    33.191     0.200
     1.983    34.511     0.200
     1.983    33.530     0.200
     2.577    42.457     0.200
     2.827    42.732     0.200
     3.519    56.217     0.200
     3.557    57.233     0.200
     3.683    59.947     0.200
     3.695    57.176     0.200
     5.037    80.922     0.200
     0.858    17.778     0.200
     0.858    18.079     0.200
     1.794    31.766     0.200
     1.935    32.089     0.200
     1.993    32.569     0.200
     2.015    32.634     0.200
     2.570    42.662     0.200
     2.798    47.666     0.200
     3.156    49.135     0.200
     3.542    55.513     0.200
     3.585    58.173     0.200
     3.634    53.032     0.200
     3.693    60.890     0.200
     3.691    56.661     0.200
     5.046    75.228     0.200
     5.591    89.279     0.200
     5.908    93.090     0.200
     7.677   111.014     0.200
     8.038   116.560     0.200
     0.926    19.279     0.200
     2.889    47.728     0.200
     3.150    51.067     0.200
     3.575    49.253     0.200
     3.546    59.601     0.200
     3.683    62.196     0.200
     1.917    31.918     0.200
     1.981    31.189     0.200
     1.992    31.129     0.200
     2.579    40.708     0.200
     3.172    46.431     0.200
     3.522    55.709     0.200
     3.567    52.807     0.200
     3.690    55.766     0.200
     5.044    78.443     0.200
     1.930    31.507     0.200
     2.602    40.806     0.200
     3.218    50.268     0.200
     3.469    54.189     0.200
     3.515    53.274     0.200
     5.035    76.755     0.200
     1.422    26.270     0.200
     1.942    32.162     0.200
     2.018    31.572     0.200
     2.004    34.152     0.200
     2.558    39.538     0.200
     3.147    49.801     0.200
     3.571    58.643     0.200
     3.548    52.655     0.200
     3.678    56.326     0.200
     5.031    76.478     0.200
     0.881    15.272     0.200
     1.923    32.394     0.200
     1.997    31.180     0.200
     1.989    33.560     0.200
     1.989    33.870     0.200
     2.572    37.437     0.200
     3.563    54.177     0.200
     3.683    49.799     0.200
     3.691    59.517     0.200
     5.037    71.587     0.200
     0.647    15.789     0.200
     1.404    25.025     0.200
     1.637    29.060     0.200
     1.911    33.045     0.200
     1.911    32.842     0.200
     2.017    34.938     0.200
     3.501    53.844     0.200
     7.884   117.365     0.200
     8.725   124.269     0.200
     0.633    13.803     0.200
     1.061    19.266     0.200
     2.592    39.474     0.200
     3.246    48.234     0.200
     3.398    53.050     0.200
     3.428    53.890     0.200
     3.516    54.409     0.200
     0.928    19.984     0.200
     1.758    31.316     0.200
     1.805    31.115     0.200
     1.920    34.294     0.200
     1.920    34.485     0.200
     1.986    35.129     0.200
     3.169    50.930     0.200
     3.525    58.334     0.200
     1.643    27.954     0.200
     3.486    56.705     0.200
     1.908    33.458     0.200
     1.816    31.720     0.200
     1.977    32.916     0.200
     1.979    32.877     0.200
     2.581    43.877     0.200
     3.512    54.489     0.200
     1.896    32.082     0.200
     1.968    33.301     0.200
     1.967    31.220     0.200
     3.549    48.708     0.200
     3.707    58.619     0.200
     8.004   113.886     0.200
     1.949    34.303     0.200
     1.949    31.834     0.200
     2.003    34.949     0.200
     2.003    31.129     0.200
     3.685    59.841     0.200
     0.932    17.832     0.200
     1.888    32.613     0.200
     1.952    32.098     0.200
     2.591    42.017     0.200
     3.199    48.355     0.200
     3.489    56.885     0.200
     3.529    54.270     0.200
     3.678    56.393     0.200
     3.706    59.273     0.200
     5.034    73.848     0.200
     7.985   116.292     0.200
     8.802   124.086     0.200
     1.917    32.554     0.200
     1.987    31.263     0.200
     1.987    33.955     0.200
     2.572    40.560     0.200
     2.856    41.823     0.200
     2.856    45.374     0.200
     3.171    49.308     0.200
     3.549    49.120     0.200
     3.611    55.376     0.200
     3.676    56.359     0.200
     3.690    57.286     0.200
     5.031    72.251     0.200
     5.603    88.423     0.200
     5.928    88.995     0.200
     7.707   109.132     0.200
     8.003   114.685     0.200
    10.929   148.573     0.200
    12.070   169.932     0.200
    12.243   162.733     0.200
    12.875   175.076     0.200
    13.606   189.884     0.200
    14.686   203.474     0.200
    14.692   199.051     0.200
     1.935    31.254     0.200
     2.010    30.920     0.200
     1.997    33.853     0.200
     2.564    40.183     0.200
     3.155    50.983     0.200
     3.570    54.105     0.200
     3.682    53.213     0.200
     3.685    58.371     0.200
     5.589    75.728     0.200
     7.672   108.896     0.200
     8.023   114.644     0.200
     1.946    32.779     0.200
     2.004    31.891     0.200
     2.025    31.854     0.200
     2.560    41.054     0.200
     3.145    50.407     0.200
     3.583    53.920     0.200
     3.685    59.659     0.200
     5.038    73.917     0.200
     5.580    81.467     0.200
     0.895    19.636     0.200
     0.915    19.661     0.200
     1.921    32.875     0.200
     1.990    34.331     0.200
     1.992    34.213     0.200
     2.567    44.575     0.200
     2.826    44.507     0.200
     3.167    49.269     0.200
     3.524    57.094     0.200
     3.544    54.538     0.200
     3.670    61.160     0.200
     3.981    66.902     0.200
     5.024    77.892     0.200
     5.598    84.738     0.200
     7.998   115.959     0.200
     0.595    13.443     0.200
     2.683    41.355     0.200
     3.347    54.883     0.200
     3.347    49.653     0.200
     3.397    54.450     0.200
     3.414    53.139     0.200
     3.669    54.726     0.200
     3.779    60.034     0.200
     1.762    28.570     0.200
     1.792    29.639     0.200
     1.888    30.771     0.200
     3.347    50.849     0.200
     3.435    50.185     0.200
     3.328    53.719     0.200
     3.328    49.200     0.200
     3.770    59.058     0.200
     1.447    25.920     0.200
     1.685    29.795     0.200
     1.884    33.055     0.200
     1.884    32.625     0.200
     1.941    32.246     0.200
     1.970    34.982     0.200
     2.585    39.555     0.200
     2.805    42.068     0.200
     2.878    48.888     0.200
     3.202    50.792     0.200
     3.202    48.565     0.200
     3.482    54.416     0.200
     3.502    49.534     0.200
     3.572    56.561     0.200
     3.660    60.145     0.200
     3.660    53.083     0.200
     3.698    60.076     0.200
     4.016    65.637     0.200
     4.395    68.224     0.200
     5.017    73.565     0.200
     7.959   111.598     0.200
     8.845   129.110     0.200
     0.581    13.551     0.200
     1.940    28.880     0.200
     1.972    33.234     0.200
     2.583    43.313     0.200
     3.202    51.627     0.200
     3.482    48.829     0.200
     3.572    52.585     0.200
     3.656    53.423     0.200
     0.890    16.273     0.200
     1.511    25.370     0.200
     1.749    29.890     0.200
     1.993    34.115     0.200
     2.567    43.291     0.200
     3.165    52.259     0.200
     0.566    12.582     0.200
     1.489    26.150     0.200
     1.728    29.994     0.200
     1.903    31.624     0.200
     1.970    31.767     0.200
     1.977    32.276     0.200
     2.581    37.169     0.200
     3.185    51.349     0.200
     3.538    57.754     0.200
     5.031    75.071     0.200
     5.615    80.419     0.200
     1.882    32.702     0.200
     1.960    32.825     0.200
     2.596    42.158     0.200
     3.205    52.840     0.200
     3.484    56.119     0.200
     3.532    57.422     0.200
     3.683    59.220     0.200
     3.683    52.720     0.200
     3.711    60.094     0.200
     5.039    76.717     0.200
     5.634    83.743     0.200
     0.945    18.382     0.200
     1.879    31.317     0.200
     1.949    34.333     0.200
     1.952    33.792     0.200
     3.209    54.353     0.200
     3.573    53.870     0.200
     3.698    59.720     0.200
     3.698    55.650     0.200
     3.722    60.648     0.200
     8.005   116.235     0.200
     0.824    17.756     0.200
     1.929    32.899     0.200
     2.016    33.440     0.200
     2.650    41.930     0.200
     2.793    44.158     0.200
     3.202    52.024     0.200
     3.614    53.737     0.200
     3.777    60.697     0.200
     0.571    13.370     0.200
     1.929    31.601     0.200
     2.003    31.464     0.200
     1.995    29.896     0.200
     2.565    41.033     0.200
     3.561    53.266     0.200
     3.534    52.949     0.200
     5.592    85.325     0.200
     1.559    25.951     0.200
     1.799    29.857     0.200
     1.925    31.614     0.200
     2.011    32.512     0.200
     2.588    39.072     0.200
     2.800    44.062     0.200
     3.168    52.134     0.200
     3.168    49.094     0.200
     3.534    57.857     0.200
     3.626    55.430     0.200
     3.606    59.328     0.200
     3.710    60.235     0.200
     3.715    57.603     0.200
     1.933    32.491     0.200
     1.991    33.784     0.200
     1.991    33.903     0.200
     2.012    31.223     0.200
     2.571    40.485     0.200
     2.801    45.661     0.200
     3.158    50.620     0.200
     3.540    56.066     0.200
     3.631    57.416     0.200
     1.964    33.338     0.200
     2.011    35.421     0.200
     2.862    44.178     0.200
     3.169    51.698     0.200
     3.511    56.616     0.200
     3.466    54.256     0.200
     3.614    55.848     0.200
     4.971    69.348     0.200
     5.592    82.476     0.200
     7.655   111.903     0.200
     8.808   129.003     0.200
     1.900    32.434     0.200
     1.900    31.663     0.200
     1.972    30.897     0.200
     2.590    40.196     0.200
     2.842    42.025     0.200
     3.189    48.100     0.200
     3.504    54.910     0.200
     3.556    53.331     0.200
     3.595    53.107     0.200
     1.107    21.913     0.200
     1.550    28.711     0.200
     2.882    50.012     0.200
     3.136    46.910     0.200
     3.912    66.000     0.200
     4.190    67.966     0.200
     0.627    14.432     0.200
     0.975    18.443     0.200
     1.312    24.291     0.200
     3.349    54.331     0.200
     3.805    60.731     0.200
     1.753    30.607     0.200
     1.752    30.784     0.200
     1.908    33.994     0.200
     1.908    33.324     0.200
     3.322    51.621     0.200
     3.325    56.096     0.200
     3.408    55.034     0.200
     3.349    52.800     0.200
     3.752    60.039     0.200
     4.980    69.514     0.200
     0.694    16.354     0.200
     1.762    31.012     0.200
     1.771    31.468     0.200
     1.934    33.841     0.200
     1.953    32.828     0.200
     2.594    40.543     0.200
     2.612    41.363     0.200
     3.336    52.876     0.200
     3.293    54.703     0.200
     3.336    52.876     0.200
     3.728    62.213     0.200
     4.950    72.434     0.200
     7.752   116.141     0.200
     0.654    14.602     0.200
     1.741    29.610     0.200
     1.896    32.413     0.200
     1.896    30.483     0.200
     3.310    53.102     0.200
     3.329    52.877     0.200
     3.362    53.833     0.200
     3.629    58.727     0.200
     4.991    71.064     0.200
     0.616    14.298     0.200
     1.371    24.968     0.200
     1.608    28.549     0.200
     1.860    32.383     0.200
     1.897    31.144     0.200
     1.970    33.458     0.200
     1.025    19.965     0.200
     2.648    40.809     0.200
     3.291    45.920     0.200
     3.278    53.972     0.200
     0.743    15.851     0.200
     2.960    42.737     0.200
     3.066    47.943     0.200
     3.266    50.866     0.200
     4.022    63.166     0.200
     0.734    15.659     0.200
     3.271    50.832     0.200
     0.661    14.142     0.200
     0.661    14.947     0.200
     1.739    29.700     0.200
     1.899    32.198     0.200
     3.362    50.787     0.200
     1.233    22.774     0.200
     1.474    27.191     0.200
     1.762    31.325     0.200
     1.762    31.196     0.200
     1.773    30.342     0.200
     1.907    33.369     0.200
     2.659    45.619     0.200
     2.659    42.988     0.200
     3.338    55.328     0.200
     3.354    51.862     0.200
     3.335    55.361     0.200
     3.335    51.221     0.200
     3.424    55.302     0.200
     3.751    60.049     0.200
     1.735    29.812     0.200
     3.300    51.924     0.200
     3.354    54.423     0.200
     3.372    53.025     0.200
     0.871    18.598     0.200
     1.302    23.175     0.200
     1.399    26.189     0.200
     1.683    29.915     0.200
     1.683    29.649     0.200
     2.106    36.786     0.200
     2.899    48.103     0.200
     2.977    46.919     0.200
     3.027    49.444     0.200
     3.180    49.539     0.200
     3.788    60.120     0.200
     7.637   113.309     0.200
     0.733    16.069     0.200
     1.392    24.939     0.200
     2.225    36.372     0.200
     2.975    46.857     0.200
     3.279    53.229     0.200
     0.731    15.746     0.200
     1.686    28.659     0.200
     2.301    36.479     0.200
     2.995    47.284     0.200
     2.951    48.309     0.200
     3.078    47.001     0.200
     3.274    49.994     0.200
     1.722    29.842     0.200
     1.722    30.229     0.200
     3.108    49.969     0.200
     2.917    45.125     0.200
     0.630    13.707     0.200
     1.522    26.077     0.200
     1.802    30.108     0.200
     1.821    28.339     0.200
     1.934    33.250     0.200
     1.934    30.731     0.200
     2.668    40.465     0.200
     2.626    43.893     0.200
     2.626    43.432     0.200
     3.382    48.210     0.200
     3.291    52.457     0.200
     3.379    52.792     0.200
     3.469    51.426     0.200
     4.983    76.246     0.200
     5.701    85.632     0.200
     7.840   112.400     0.200
     8.776   124.581     0.200
     8.916   129.116     0.200
     0.639    13.963     0.200
     1.765    30.582     0.200
     1.765    29.742     0.200
     1.775    29.077     0.200
     1.910    30.758     0.200
     2.656    40.262     0.200
     3.065    47.897     0.200
     3.354    52.259     0.200
     3.427    50.867     0.200
     7.817   113.045     0.200
     8.790   124.772     0.200
     0.598    13.385     0.200
     1.792    29.393     0.200
     1.822    28.933     0.200
     1.915    31.726     0.200
     2.643    43.443     0.200
     3.378    54.459     0.200
     3.465    52.223     0.200
     7.875   112.936     0.200
     8.802   123.369     0.200
     0.632    15.729     0.200
     1.224    23.623     0.200
     1.746    32.041     0.200
     1.757    30.958     0.200
     1.893    34.205     0.200
     1.893    33.858     0.200
     2.674    45.849     0.200
     3.356    54.780     0.200
     3.350    54.271     0.200
     3.642    57.832     0.200
     3.766    60.908     0.200
     5.003    75.494     0.200
     1.145    21.449     0.200
     1.776    29.607     0.200
     1.892    32.592     0.200
     2.670    41.735     0.200
     3.337    49.203     0.200
     3.385    53.012     0.200
     3.337    52.457     0.200
     3.424    50.141     0.200
     8.813   122.454     0.200
     3.344    54.499     0.200
     3.329    51.634     0.200
     1.169    22.296     0.200
     1.730    29.928     0.200
     1.737    31.211     0.200
     1.737    30.771     0.200
     1.902    32.759     0.200
     7.769   114.466     0.200
     1.236    23.519     0.200
     1.718    29.777     0.200
     1.726    31.492     0.200
     1.726    30.971     0.200
     1.892    32.909     0.200
     3.291    52.155     0.200
     3.305    54.317     0.200
     3.381    57.148     0.200
     1.029    19.055     0.200
     1.615    27.951     0.200
     1.887    31.918     0.200
     2.648    42.995     0.200
     2.727    43.156     0.200
     3.295    50.065     0.200
     1.406    23.426     0.200
     2.237    36.792     0.200
     2.989    48.810     0.200
     3.071    49.860     0.200
     3.270    53.517     0.200
     0.780    17.609     0.200
     0.886    18.938     0.200
     1.144    20.913     0.200
     1.732    30.127     0.200
     2.002    32.188     0.200
     2.718    42.147     0.200
     7.830   118.706     0.200
     0.560    13.853     0.200
     0.589    12.871     0.200
     0.646    14.158     0.200
     0.773    16.001     0.200
     0.773    16.841     0.200
     0.835    17.450     0.200
     2.173    34.463     0.200
     3.148    49.850     0.200
     4.282    62.402     0.200
     5.602    81.399     0.200
     3.060    50.970     0.200
     3.178    53.930     0.200
     0.828    18.856     0.200
     1.563    27.672     0.200
     3.135    49.594     0.200
     3.900    65.082     0.200
     0.822    17.088     0.200
     0.822    17.859     0.200
     1.196    21.865     0.200
     1.545    27.643     0.200
     2.783    46.200     0.200
     2.864    45.875     0.200
     3.151    50.793     0.200
     0.528    12.858     0.200
     0.564    12.137     0.200
     0.677    14.071     0.200
     0.677    15.505     0.200
     0.802    17.184     0.200
     0.802    16.984     0.200
     0.798    15.744     0.200
     0.798    17.326     0.200
     0.498    12.452     0.200
     0.699    14.304     0.200
     0.699    15.644     0.200
     2.116    34.521     0.200
     0.625    16.188     0.200
     0.744    16.128     0.200
     1.578    28.483     0.200
     0.771    17.655     0.200
     1.067    19.134     0.200
     1.302    24.766     0.200
     1.344    25.278     0.200
     1.464    27.251     0.200
     2.155    34.890     0.200
     3.137    48.499     0.200
     0.528    12.150     0.200
     0.565    12.455     0.200
     0.676    15.147     0.200
     1.567    26.690     0.200
     2.141    35.574     0.200
     3.166    51.083     0.200
     3.886    57.160     0.200
     4.311    63.162     0.200
     4.735    68.999     0.200
     5.630    83.849     0.200
     7.041    99.518     0.200
     9.247   131.184     0.200
     9.513   132.991     0.200
    11.863   154.750     0.200
     0.680    15.598     0.200
     0.792    16.744     0.200
     0.792    17.385     0.200
     0.792    17.658     0.200
     1.331    24.423     0.200
     1.539    27.910     0.200
     0.726    16.760     0.200
     0.888    19.547     0.200
     0.894    20.571     0.200
     0.710    15.440     0.200
     0.813    16.924     0.200
     1.296    24.137     0.200
     1.464    26.560     0.200
     1.505    27.208     0.200
     3.167    49.879     0.200
     3.167    50.270     0.200
     0.500    13.017     0.200
     0.500    14.166     0.200
     0.688    15.080     0.200
     0.688    16.330     0.200
     0.799    17.015     0.200
     0.799    17.134     0.200
     0.951    18.577     0.200
     0.796    17.304     0.200
     1.732    29.202     0.200
     2.869    47.969     0.200
     3.142    51.327     0.200
     3.263    47.756     0.200
     5.256    78.915     0.200
     6.266    93.442     0.200
     0.738    17.136     0.200
     1.614    26.662     0.200
     2.275    38.346     0.200
     2.335    39.829     0.200
     3.083    52.206     0.200
     0.402    10.058     0.200
     0.402    10.918     0.200
     2.003    33.544     0.200
     2.053    32.998     0.200
     0.593    13.593     0.200
     0.780    16.776     0.200
     0.780    17.417     0.200
     1.013    19.895     0.200
     1.251    23.826     0.200
     1.520    25.542     0.200
     0.724    16.620     0.200
     0.784    16.920     0.200
     1.008    18.768     0.200
     1.520    25.450     0.200
     2.214    33.745     0.200
     2.277    35.785     0.200
     3.178    50.681     0.200
     5.550    86.120     0.200
     0.653    15.636     0.200
     0.774    16.638     0.200
     1.335    24.467     0.200
     1.524    26.472     0.200
     2.240    36.729     0.200
     2.304    37.139     0.200
     0.588    12.899     0.200
     0.588    14.090     0.200
     0.657    13.500     0.200
     0.656    13.488     0.200
     0.656    13.297     0.200
     0.783    16.546     0.200
     0.783    16.647     0.200
     0.769    16.100     0.200
     0.768    16.520     0.200
     1.013    18.460     0.200
     1.350    23.584     0.200
     1.817    30.870     0.200
     2.248    32.131     0.200
     2.312    34.398     0.200
     2.354    37.248     0.200
     2.440    40.390     0.200
     0.539    13.045     0.200
     0.696    14.817     0.200
     0.685    15.865     0.200
     0.685    15.437     0.200
     1.099    20.131     0.200
     1.622    27.147     0.200
     1.622    25.905     0.200
     2.236    37.027     0.200
     2.294    38.459     0.200
     0.616    13.483     0.200
     0.616    14.393     0.200
     0.616    14.703     0.200
     0.605    13.464     0.200
     0.772    16.117     0.200
     0.772    17.088     0.200
     1.229    22.986     0.200
     1.436    25.924     0.200
     1.966    33.188     0.200
     2.164    34.805     0.200
     2.224    37.889     0.200
     7.492   111.897     0.200
     9.456   130.156     0.200
     0.623    15.102     0.200
     0.620    14.465     0.200
     0.769    16.670     0.200
     0.769    17.326     0.200
     1.033    19.451     0.200
     1.567    27.326     0.200
     1.567    27.998     0.200
     1.619    28.941     0.200
     2.156    35.609     0.200
     2.214    35.548     0.200
     3.154    50.079     0.200
     1.228    22.699     0.200
     1.228    22.441     0.200
     1.382    25.768     0.200
     1.480    26.191     0.200
     1.409    25.677     0.200
     2.312    39.393     0.200
     2.815    47.332     0.200
     2.913    49.878     0.200
     0.600    14.350     0.200
     0.600    14.804     0.200
     0.621    14.470     0.200
     0.621    14.622     0.200
     0.772    16.238     0.200
     0.772    17.550     0.200
     1.059    20.160     0.200
     1.030    19.385     0.200
     1.291    23.919     0.200
     1.421    25.808     0.200
     1.563    28.064     0.200
     1.664    29.295     0.200
     2.155    37.706     0.200
     2.214    37.659     0.200
     2.331    38.785     0.200
     1.266    21.902     0.200
     1.266    20.852     0.200
     2.821    42.400     0.200
     2.917    43.516     0.200
     1.015    20.032     0.200
     1.541    28.063     0.200
     2.171    36.507     0.200
     2.232    35.389     0.200
     1.024    20.485     0.200
     1.024    19.727     0.200
     1.199    22.646     0.200
     1.258    23.053     0.200
     1.465    27.481     0.200
     1.547    27.862     0.200
     2.187    37.220     0.200
     2.248    36.159     0.200
     0.758    15.834     0.200
     0.758    16.463     0.200
     0.648    15.235     0.200
     1.039    19.008     0.200
     2.178    36.668     0.200
     2.237    34.616     0.200
     0.597    13.958     0.200
     0.597    14.364     0.200
     0.671    14.837     0.200
     0.762    16.554     0.200
     0.762    16.125     0.200
     1.032    19.706     0.200
     1.257    22.308     0.200
     2.191    34.880     0.200
     2.251    35.746     0.200
     0.578    13.883     0.200
     0.643    14.433     0.200
     0.675    15.450     0.200
     1.262    22.351     0.200
     1.578    28.962     0.200
     1.578    26.532     0.200
     2.206    34.365     0.200
     2.265    34.548     0.200
     3.131    52.430     0.200
     1.454    24.162     0.200
     2.927    46.257     0.200
     3.030    48.167     0.200
     3.114    50.319     0.200
     3.310    50.485     0.200
     3.783    56.778     0.200
     0.541    13.582     0.200
     1.044    19.060     0.200
     1.196    17.761     0.200
     2.100    32.085     0.200
     2.156    32.155     0.200
     4.297    67.064     0.200
     0.462    10.138     0.200
     0.461    10.185     0.200
     0.461    10.855     0.200
     0.639    14.189     0.200
     0.639    14.429     0.200
     1.435    24.931     0.200
     1.925    32.227     0.200
     1.978    31.958     0.200
     3.266    46.997     0.200
     0.362     9.817     0.200
     0.363     9.835     0.200
     0.464    10.196     0.200
     0.464    10.163     0.200
     0.464    10.693     0.200
     0.956    16.533     0.200
     1.219    20.946     0.200
     1.379    23.143     0.200
     1.429    24.403     0.200
     1.923    32.200     0.200
     1.975    31.674     0.200
     3.264    46.643     0.200
     0.565    15.519     0.200
     0.725    15.480     0.200
     0.739    16.123     0.200
     0.742    16.374     0.200
     0.743    16.422     0.200
     0.785    16.484     0.200
     0.785    16.836     0.200
     0.785    18.043     0.200
     1.047    19.663     0.200
     1.198    22.894     0.200
     0.726    15.891     0.200
     0.759    17.045     0.200
     0.771    15.497     0.200
     0.824    16.449     0.200
     0.824    17.567     0.200
     0.824    16.988     0.200
     1.123    20.756     0.200
     0.472    10.536     0.200
     0.658    14.903     0.200
     0.658    14.634     0.200
     1.450    25.195     0.200
     1.997    32.406     0.200
     2.105    34.006     0.200
     2.124    33.853     0.200
     2.175    34.611     0.200
     0.379    10.451     0.200
     0.475    10.640     0.200
     0.474    10.565     0.200
     0.913    16.816     0.200
     1.233    21.398     0.200
     1.307    22.245     0.200
     1.442    24.838     0.200
     1.561    25.972     0.200
     1.946    32.124     0.200
     1.941    32.576     0.200
     1.994    32.439     0.200
     2.116    34.047     0.200
     2.101    34.259     0.200
     2.287    35.984     0.200
     2.459    39.400     0.200
     0.497    11.544     0.200
     0.829    17.718     0.200
     0.958    17.323     0.200
     1.250    22.798     0.200
     1.293    23.379     0.200
     1.443    25.942     0.200
     1.576    26.601     0.200
     1.960    33.673     0.200
     2.013    32.691     0.200
     0.415    10.646     0.200
     0.415    11.078     0.200
     0.415    11.597     0.200
     0.690    15.777     0.200
     0.690    15.675     0.200
     0.959    17.642     0.200
     1.456    25.665     0.200
     1.999    32.972     0.200
     2.051    32.200     0.200
     3.192    48.332     0.200
     0.810    18.436     0.200
     1.095    20.536     0.200
     1.208    22.081     0.200
     1.417    25.318     0.200
     1.923    33.117     0.200
     0.376    10.201     0.200
     0.376    10.383     0.200
     0.488    10.439     0.200
     0.649    14.912     0.200
     1.113    19.750     0.200
     1.238    21.796     0.200
     1.238    22.085     0.200
     1.433    25.088     0.200
     1.688    27.284     0.200
     1.999    32.424     0.200
     2.105    33.602     0.200
     2.106    31.802     0.200
     3.239    50.090     0.200
     0.722    16.543     0.200
     0.722    16.363     0.200
     0.762    17.103     0.200
     0.696    16.570     0.200
     1.071    21.511     0.200
     1.308    25.245     0.200
     1.490    27.277     0.200
     2.276    39.127     0.200
     0.725    15.728     0.200
     1.050    19.956     0.200
     1.300    24.452     0.200
     9.195   125.820     0.200
     0.612    13.652     0.200
     0.612    14.812     0.200
     0.589    14.764     0.200
     0.589    15.116     0.200
     0.620    14.335     0.200
     1.246    21.560     0.200
     2.151    36.167     0.200
     2.207    36.023     0.200
     3.121    47.133     0.200
     0.617    13.541     0.200
     0.617    15.121     0.200
     0.578    15.151     0.200
     1.349    23.942     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.531    52.956     0.200
     2.711    55.068     0.200
     3.131    61.998     0.200
     3.231    64.794     0.200
     3.499    70.236     0.200
     3.873    75.640     0.200
     2.954    58.387     0.200
     3.180    62.351     0.200
     3.228    63.027     0.200
     3.366    66.175     0.200
     3.442    67.259     0.200
     3.113    63.302     0.200
     2.615    51.531     0.200
     7.039   143.480     0.200
     7.428   150.734     0.200
     8.139   161.490     0.200
     9.127   182.000     0.200
     9.573   192.202     0.200
     3.942    76.174     0.200
     4.035    80.274     0.200
     3.826    73.583     0.200
     4.077    82.138     0.200
     4.813    98.125     0.200
     4.907   100.201     0.200
     5.234   105.201     0.200
     5.463   111.847     0.200
     5.977   123.292     0.200
     6.770   140.816     0.200
     6.970   141.754     0.200
     7.414   150.436     0.200
     7.697   153.933     0.200
     7.979   158.994     0.200
     9.136   184.869     0.200
     9.819   198.329     0.200
     4.185    83.447     0.200
     6.721   139.099     0.200
     8.289   163.496     0.200
     9.160   186.392     0.200
     7.636   148.122     0.200
     9.025   181.594     0.200
     9.025   181.594     0.200
    10.131   209.528     0.200
    12.601   256.089     0.200
     3.689    73.290     0.200
     5.385   109.410     0.200
     7.225   151.861     0.200
     7.680   154.833     0.200
     7.680   155.434     0.200
     8.608   178.399     0.200
     9.024   178.726     0.200
    12.666   248.317     0.200
    13.172   268.834     0.200
     2.876    56.820     0.200
     3.229    63.159     0.200
     3.398    69.924     0.200
     3.828    78.063     0.200
     4.187    80.987     0.200
     4.789   102.077     0.200
     5.307   102.131     0.200
     7.073   140.922     0.200
     7.860   153.473     0.200
     8.775   176.709     0.200
     9.075   179.547     0.200
    10.399   208.078     0.200
    24.098   486.060     0.200
     3.244    65.297     0.200
     3.625    71.851     0.200
     3.851    79.560     0.200
     4.787    94.416     0.200
     4.938    96.362     0.200
     5.315   103.588     0.200
     5.614   109.414     0.200
     5.655   110.513     0.200
     5.798   112.018     0.200
     7.623   157.525     0.200
     7.942   155.919     0.200
     8.810   176.467     0.200
     9.127   179.947     0.200
    12.960   250.864     0.200
    13.346   251.511     0.200
    18.081   358.516     0.200
     3.645    74.066     0.200
     8.609   175.835     0.200
     9.260   187.772     0.200
    12.831   251.424     0.200
    13.140   250.944     0.200
    17.901   351.890     0.200
    26.003   521.920     0.200
     2.758    55.319     0.200
     3.111    62.618     0.200
     3.500    67.114     0.200
     3.713    74.798     0.200
     4.068    77.466     0.200
     8.669   185.571     0.200
     7.373   158.074     0.200
     7.484   148.129     0.200
     9.025   187.825     0.200
     9.668   189.361     0.200
     3.866    75.615     0.200
     5.985   124.861     0.200
     6.221   129.280     0.200
     6.479   136.547     0.200
     7.037   140.312     0.200
     8.151   153.137     0.200
     8.853   178.923     0.200
     9.296   180.933     0.200
    10.557   209.867     0.200
    13.118   259.192     0.200
     3.880    77.597     0.200
     3.880    77.997     0.200
     4.204    81.472     0.200
     4.753    93.398     0.200
     4.945    96.743     0.200
     5.628   108.353     0.200
     7.023   138.990     0.200
     8.135   157.642     0.200
     8.864   178.508     0.200
     9.273   179.737     0.200
    10.561   210.603     0.200
    13.114   254.364     0.200
    13.377   261.857     0.200
    22.001   438.794     0.200
    26.129   514.249     0.200
     3.391    66.541     0.200
     3.585    75.124     0.200
     7.840   162.242     0.200
     9.219   184.401     0.200
    12.722   255.376     0.200
     2.735    54.622     0.200
     2.936    57.335     0.200
     3.067    58.903     0.200
     3.283    64.134     0.200
     3.160    60.706     0.200
     3.167    60.996     0.200
     2.981    56.617     0.200
     3.328    61.842     0.200
     3.690    78.654     0.200
     3.956    76.155     0.200
     4.710    87.798     0.200
     5.279    98.975     0.200
     5.905   119.707     0.200
     5.983   120.965     0.200
     6.075   113.888     0.200
     6.037   124.479     0.200
     6.320   128.542     0.200
     6.276   127.093     0.200
     6.516   122.651     0.200
     6.947   143.457     0.200
     8.155   155.008     0.200
     8.941   174.967     0.200
     9.240   179.367     0.200
     9.298   180.390     0.200
     9.720   195.713     0.200
    12.285   245.955     0.200
     3.300    71.605     0.200
     9.240   187.316     0.200
     9.833   202.796     0.200
    12.378   261.590     0.200
     3.167    61.490     0.200
     7.005   140.236     0.200
     7.727   147.090     0.200
     8.915   165.159     0.200
    10.404   218.573     0.200
     2.931    59.781     0.200
     7.559   144.618     0.200
     9.433   177.230     0.200
     9.471   201.761     0.200
    12.082   245.782     0.200
     7.588   160.533     0.200
     9.416   190.753     0.200
     3.498    75.797     0.200
     9.138   168.893     0.200
    10.023   196.701     0.200
     7.771   156.384     0.200
     8.886   174.545     0.200
     3.128    62.455     0.200
     3.899    77.006     0.200
     7.001   130.759     0.200
     8.088   167.477     0.200
     9.219   184.969     0.200
    10.558   214.388     0.200
    13.093   266.973     0.200
     3.939    78.121     0.200
     6.959   133.495     0.200
     8.006   160.256     0.200
     8.905   175.209     0.200
     9.123   178.353     0.200
    10.557   207.767     0.200
    13.059   257.325     0.200
     7.734   155.418     0.200
     8.529   174.360     0.200
     9.127   180.017     0.200
    10.144   207.148     0.200
     3.085    59.287     0.200
     3.519    72.098     0.200
     7.723   152.435     0.200
     9.170   175.681     0.200
    10.071   195.641     0.200
     2.693    60.164     0.200
     7.568   148.738     0.200
     7.600   158.546     0.200
     9.261   193.492     0.200
     9.593   193.341     0.200
    11.927   248.409     0.200
     4.211    81.533     0.200
     9.199   177.948     0.200
     9.152   169.540     0.200
     4.253    83.390     0.200
     9.158   180.274     0.200
     2.994    67.473     0.200
     7.513   149.762     0.200
     7.889   171.583     0.200
     9.360   183.990     0.200
     9.503   195.724     0.200
    12.087   248.643     0.200
     3.378    67.682     0.200
     7.710   154.298     0.200
     9.253   187.951     0.200
     2.609    51.270     0.200
     9.234   185.781     0.200
     7.401   144.845     0.200
     7.525   145.861     0.200
     8.432   176.225     0.200
     9.065   178.824     0.200
     9.684   193.397     0.200
    11.761   234.506     0.200
    11.969   238.577     0.200
    16.680   328.566     0.200
    23.195   456.076     0.200
     4.229    85.971     0.200
     6.679   135.553     0.200
     8.257   159.738     0.200
     9.150   172.589     0.200
     9.217   185.537     0.200
     4.464    89.476     0.200
     6.436   127.467     0.200
     8.181   161.061     0.200
     8.923   176.401     0.200
     9.435   193.088     0.200
    11.068   223.985     0.200
    13.493   266.963     0.200
    24.613   495.580     0.200
     4.225    85.528     0.200
     8.151   169.643     0.200
     9.058   182.541     0.200
     7.693   156.062     0.200
     8.423   174.957     0.200
     9.162   179.703     0.200
    12.556   258.776     0.200
     3.648    73.615     0.200
     4.463   100.079     0.200
     8.020   156.549     0.200
     8.781   163.403     0.200
     9.413   198.760     0.200
    11.001   228.239     0.200
    13.381   270.571     0.200
     8.037   159.945     0.200
     8.795   171.883     0.200
     9.417   190.406     0.200
     4.442    89.653     0.200
     8.057   159.218     0.200
     8.828   172.751     0.200
     3.713    73.040     0.200
     8.020   161.471     0.200
     8.823   163.649     0.200
     9.354   204.246     0.200
    13.344   275.203     0.200
     4.409    94.573     0.200
     8.058   154.841     0.200
     8.852   166.941     0.200
     9.367   193.240     0.200
    10.973   220.563     0.200
    13.376   264.586     0.200
     4.381    99.816     0.200
     7.974   159.742     0.200
     8.797   167.985     0.200
    10.913   225.799     0.200
    13.300   270.518     0.200
     4.389    93.648     0.200
     8.007   159.922     0.200
     3.585    70.265     0.200
     4.426   104.995     0.200
     8.779   158.745     0.200
     9.372   198.403     0.200
    10.956   223.790     0.200
     8.783   167.550     0.200
     4.337    92.705     0.200
     7.916   158.804     0.200
     8.778   169.810     0.200
     8.784   174.214     0.200
     4.371    96.415     0.200
     7.973   158.470     0.200
     8.804   167.308     0.200
     4.347    95.475     0.200
     7.938   158.188     0.200
     8.790   166.125     0.200
     7.948   158.471     0.200
     8.771   166.628     0.200
     4.347   100.091     0.200
     7.941   160.153     0.200
     8.792   168.500     0.200
     4.420    96.172     0.200
     7.985   157.888     0.200
     8.780   165.851     0.200
     9.366   197.066     0.200
    10.950   227.872     0.200
    13.330   275.352     0.200
     2.802    57.647     0.200
     2.802    55.747     0.200
     4.450    90.858     0.200
     8.010   158.110     0.200
     8.782   167.593     0.200
     9.399   191.834     0.200
    10.986   221.515     0.200
     4.400    90.997     0.200
     7.967   157.620     0.200
     8.779   168.288     0.200
     9.345   185.127     0.200
    10.926   215.422     0.200
    13.306   268.189     0.200
     4.372   100.062     0.200
     7.938   162.753     0.200
     8.772   167.657     0.200
     4.460    96.231     0.200
     8.154   165.473     0.200
     8.902   173.325     0.200
     7.964   153.606     0.200
     8.781   166.244     0.200
     4.435    96.884     0.200
     8.010   164.184     0.200
     8.792   169.444     0.200
     8.824   170.839     0.200
    10.907   220.281     0.200
     4.243    91.352     0.200
     8.694   178.893     0.200
     9.156   191.826     0.200
    13.047   273.771     0.200
     4.385    96.874     0.200
     7.998   159.308     0.200
     8.816   169.298     0.200
    13.320   274.357     0.200
     8.813   160.382     0.200
     9.297   202.689     0.200
    13.278   277.610     0.200
     7.989   156.184     0.200
     8.811   166.505     0.200
    10.918   220.556     0.200
    13.310   264.687     0.200
     4.418    97.498     0.200
     8.001   165.220     0.200
     8.796   166.585     0.200
     9.366   196.081     0.200
    10.955   227.678     0.200
    13.341   277.015     0.200
     4.416    90.926     0.200
     7.968   157.418     0.200
     8.769   168.984     0.200
    10.940   223.975     0.200
    13.316   269.788     0.200
     4.408    97.255     0.200
     7.997   165.564     0.200
     8.799   171.486     0.200
    10.945   230.096     0.200
    13.332   279.618     0.200
     3.223    64.147     0.200
     2.597    50.906     0.200
     4.358    99.265     0.200
     7.954   157.001     0.200
     8.796   165.383     0.200
    13.272   270.532     0.200
     2.608    53.317     0.200
     7.988   167.448     0.200
     8.782   172.233     0.200
     4.437    89.874     0.200
     8.044   157.255     0.200
     8.820   168.850     0.200
     4.406   104.761     0.200
     8.017   162.325     0.200
     8.818   166.099     0.200
     9.358   202.952     0.200
    10.952   235.203     0.200
    13.345   279.209     0.200
     8.051   160.133     0.200
     8.846   168.914     0.200
     9.364   198.146     0.200
    13.370   274.216     0.200
     3.530    70.036     0.200
     4.419    88.760     0.200
     8.032   150.837     0.200
     8.822   169.123     0.200
     9.372   188.761     0.200
    10.969   216.821     0.200
    13.363   263.234     0.200
     4.416    96.145     0.200
     7.986   153.682     0.200
     8.784   167.236     0.200
     4.453    97.421     0.200
     8.038   159.662     0.200
     8.804   167.235     0.200
     8.027   169.444     0.200
     8.794   171.279     0.200
     4.365   100.521     0.200
     7.972   170.455     0.200
     8.806   171.471     0.200
     3.428    69.580     0.200
     3.591    71.575     0.200
     3.591    72.692     0.200
     3.645    77.330     0.200
     4.375    88.710     0.200
     4.948    99.336     0.200
     7.884   159.865     0.200
     8.725   173.332     0.200
    10.869   217.162     0.200
    13.231   267.316     0.200
     2.574    54.093     0.200
     8.032   159.199     0.200
     3.683    76.885     0.200
     4.416    95.558     0.200
     5.937   123.681     0.200
     8.802   168.578     0.200
     9.365   195.080     0.200
    10.956   225.942     0.200
     4.404    94.874     0.200
     8.004   154.808     0.200
     8.808   164.317     0.200
     3.557    72.966     0.200
     3.595    76.535     0.200
     4.470   100.882     0.200
     7.655   155.375     0.200
     8.047   161.932     0.200
     8.796   194.959     0.200
     8.801   168.771     0.200
     9.423   199.985     0.200
    10.104   211.837     0.200
    11.018   229.847     0.200
    13.403   276.754     0.200
     4.388    94.062     0.200
     7.985   157.925     0.200
     8.802   169.082     0.200
     9.336   190.320     0.200
    10.924   218.038     0.200
    13.312   265.803     0.200
     8.003   159.833     0.200
     8.794   166.716     0.200
    13.346   261.898     0.200
     4.448   100.667     0.200
     8.023   160.246     0.200
     8.794   160.658     0.200
     7.998   161.410     0.200
     8.788   166.426     0.200
     4.375    90.494     0.200
     7.959   152.997     0.200
     8.788   168.645     0.200
     8.003   164.137     0.200
     4.386    98.685     0.200
     8.005   160.509     0.200
     8.820   166.948     0.200
     4.458    95.252     0.200
     8.155   159.297     0.200
     8.904   170.697     0.200
     8.059   165.172     0.200
     8.824   167.857     0.200
     3.583    72.338     0.200
     7.921   160.512     0.200
     8.743   170.980     0.200
     8.011   160.624     0.200
     8.810   168.788     0.200
     4.178    96.560     0.200
     7.756   157.795     0.200
     9.096   192.013     0.200
    10.647   218.771     0.200
    13.022   264.403     0.200
     2.585    53.900     0.200
     3.431    75.206     0.200
     3.538    71.983     0.200
     3.464    76.871     0.200
     7.730   149.936     0.200
     4.196    88.780     0.200
     7.817   154.561     0.200
     8.792   167.900     0.200
     4.158   100.855     0.200
     7.818   157.516     0.200
     8.818   165.810     0.200
     3.695    80.487     0.200
     7.637   156.457     0.200
     8.606   191.833     0.200
    12.637   266.084     0.200
     4.246    87.593     0.200
     7.840   153.775     0.200
     8.776   169.507     0.200
    10.742   213.914     0.200
    13.124   261.625     0.200
     4.198    89.648     0.200
     7.817   157.443     0.200
     8.790   171.846     0.200
     7.875   158.686     0.200
     8.802   170.662     0.200
    10.761   217.309     0.200
    13.151   269.476     0.200
     4.203    96.351     0.200
     7.848   161.113     0.200
     8.813   170.715     0.200
    10.709   222.921     0.200
    13.104   265.583     0.200
     2.675    55.501     0.200
     3.616    72.474     0.200
     4.148    92.765     0.200
     7.769   155.399     0.200
     8.785   170.306     0.200
    13.013   261.571     0.200
     4.136    99.192     0.200
     7.769   157.564     0.200
     8.793   168.412     0.200
     2.956    60.848     0.200
     3.571    81.209     0.200
     7.830   160.956     0.200
     9.220   176.542     0.200
     2.749    56.076     0.200
     7.460   149.295     0.200
     7.629   151.840     0.200
     9.251   184.159     0.200
     9.484   188.603     0.200
    11.876   240.997     0.200
     2.798    54.668     0.200
     2.716    54.634     0.200
     9.515   192.175     0.200
    11.864   242.923     0.200
     7.471   142.535     0.200
     7.599   149.526     0.200
     9.227   179.031     0.200
     9.513   188.764     0.200
    11.863   231.297     0.200
    16.849   333.033     0.200
     2.946    59.786     0.200
     3.177    61.420     0.200
     7.537   147.757     0.200
     7.847   153.900     0.200
     9.408   178.180     0.200
     9.473   190.921     0.200
    12.075   244.988     0.200
     3.086    60.095     0.200
     2.825    67.714     0.200
     7.492   147.247     0.200
     7.714   164.563     0.200
     9.338   193.260     0.200
     9.456   181.980     0.200
     2.573    53.424     0.200
     3.158    62.034     0.200
     7.486   146.153     0.200
     9.321   184.132     0.200
     9.462   182.441     0.200
     3.161    61.728     0.200
     2.835    66.066     0.200
     3.776    72.800     0.200
     7.481   145.447     0.200
     7.721   160.948     0.200
     9.340   189.599     0.200
     9.442   181.012     0.200
    11.952   239.975     0.200
     3.153    60.503     0.200
     3.759    72.096     0.200
     7.774   156.179     0.200
     8.974   176.129     0.200
    10.398   216.498     0.200
    12.851   259.632     0.200
     2.731    52.025     0.200
     2.903    55.632     0.200
     7.466   151.352     0.200
     9.643   187.526     0.200
    11.807   238.669     0.200
     2.575    57.899     0.200
     7.464   156.823     0.200
     7.501   146.501     0.200
     9.624   188.779     0.200
    11.789   240.640     0.200
     3.453    84.481     0.200
     7.699   150.148     0.200
     8.381   183.118     0.200
     9.195   171.670     0.200
    10.003   206.175     0.200
    12.533   254.150     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.551    10.718     0.200
     1.801    39.054     0.200
     1.877    36.320     0.200
     1.962    37.778     0.200
     1.994    38.580     0.200
     2.087    40.164     0.200
     2.255    45.394     0.200
     2.367    48.678     0.200
     0.614    12.665     0.200
     0.901    19.340     0.200
     1.077    21.896     0.200
     1.032    21.738     0.200
     1.368    27.148     0.200
     2.179    44.842     0.200
     2.325    47.214     0.200
     0.643    13.461     0.200
     1.117    22.637     0.200
     1.482    30.293     0.200
     1.482    30.133     0.200
     1.368    26.613     0.200
     0.655    13.468     0.200
     1.117    22.752     0.200
     1.493    30.520     0.200
     1.356    26.781     0.200
     1.986    37.461     0.200
     1.986    39.890     0.200
     1.095    24.084     0.200
     1.486    30.850     0.200
     1.347    26.915     0.200
     1.984    41.690     0.200
     2.101    40.616     0.200
     0.542    10.446     0.200
     0.570    11.658     0.200
     0.570    11.815     0.200
     1.117    24.396     0.200
     0.830    17.273     0.200
     0.829    17.124     0.200
     0.895    19.798     0.200
     1.962    37.519     0.200
     2.477    48.784     0.200
     2.477    48.430     0.200
     3.436    62.623     0.200
     3.871    68.624     0.200
     4.496    82.492     0.200
     5.111    96.834     0.200
     1.599    30.934     0.200
     1.246    24.187     0.200
     1.287    25.288     0.200
     1.367    33.766     0.200
     1.369    26.063     0.200
     1.694    33.107     0.200
     2.757    50.245     0.200
     3.112    55.897     0.200
     3.223    56.933     0.200
     6.440   146.786     0.200
     0.512    10.520     0.200
     1.036    19.798     0.200
     1.037    19.856     0.200
     1.037    20.348     0.200
     1.008    21.182     0.200
     1.676    33.444     0.200
     1.481     9.071     0.200
     1.291    25.552     0.200
     1.397    26.713     0.200
     1.393    27.005     0.200
     1.395    26.673     0.200
     1.905    35.648     0.200
     4.910    92.157     0.200
     1.987    38.114     0.200
     3.038    54.675     0.200
     3.038    52.985     0.200
     4.605   103.082     0.200
     4.625   102.586     0.200
     5.967   130.504     0.200
     7.047   155.823     0.200
     1.188    24.203     0.200
     1.278    25.014     0.200
     1.403    27.311     0.200
     1.403    29.080     0.200
     1.272    24.237     0.200
     1.274    24.526     0.200
     1.487    28.376     0.200
     0.929    18.883     0.200
     1.043    21.446     0.200
     1.043    21.345     0.200
     1.042    21.516     0.200
     1.042    21.298     0.200
     1.042    22.036     0.200
     1.238    24.894     0.200
     1.352    26.125     0.200
     1.484    28.099     0.200
     1.953    39.557     0.200
     1.982    39.980     0.200
     2.490    54.105     0.200
     3.238    59.884     0.200
     1.406    28.347     0.200
     4.930    91.815     0.200
     5.290    98.095     0.200
     5.613   104.507     0.200
     1.393    28.456     0.200
     5.463    93.972     0.200
     6.190   114.642     0.200
     1.188    24.103     0.200
     1.818    35.395     0.200
     3.385    62.609     0.200
     3.946    73.440     0.200
     0.609    12.502     0.200
     0.753    16.000     0.200
     0.753    16.101     0.200
     1.004    22.355     0.200
     1.065    21.181     0.200
     1.352    26.732     0.200
     1.513    28.847     0.200
     1.564    29.142     0.200
     1.608    31.952     0.200
     1.608    32.514     0.200
     1.642    34.803     0.200
     1.765    36.165     0.200
     2.000    39.261     0.200
     2.136    38.136     0.200
     2.303    46.479     0.200
     0.570    12.302     0.200
     0.686    14.460     0.200
     0.796    17.098     0.200
     0.943    18.155     0.200
     1.201    24.025     0.200
     1.534    28.952     0.200
     1.606    30.526     0.200
     2.068    37.848     0.200
     1.353    24.783     0.200
     1.727    32.264     0.200
     1.786    37.551     0.200
     3.638    68.773     0.200
     4.234    78.574     0.200
     0.640    13.971     0.200
     0.735    14.678     0.200
     1.052    20.315     0.200
     1.052    21.835     0.200
     0.994    19.990     0.200
     1.364    25.356     0.200
     1.669    30.053     0.200
     1.886    35.441     0.200
     1.918    35.553     0.200
     1.940    36.080     0.200
     1.940    38.000     0.200
     2.185    41.462     0.200
     2.530    47.875     0.200
     2.888    53.030     0.200
     3.481    65.248     0.200
     0.875    17.188     0.200
     0.913    18.363     0.200
     1.443    27.788     0.200
     1.501    28.644     0.200
     3.397    57.918     0.200
     0.591    13.194     0.200
     0.826    16.617     0.200
     0.839    17.319     0.200
     1.018    20.444     0.200
     1.061    20.659     0.200
     1.286    24.784     0.200
     1.518    27.743     0.200
     1.595    28.465     0.200
     2.434    41.623     0.200
     0.619    13.676     0.200
     0.924    19.196     0.200
     0.880    18.019     0.200
     1.112    22.069     0.200
     1.503    28.464     0.200
     1.553    29.184     0.200
     1.693    34.135     0.200
     2.530    47.866     0.200
     3.206    55.841     0.200
     0.600    12.676     0.200
     0.995    19.346     0.200
     0.995    19.816     0.200
     1.177    22.895     0.200
     1.533    29.390     0.200
     1.555    31.901     0.200
     1.774    33.049     0.200
     0.720    15.554     0.200
     0.975    20.074     0.200
     1.112    23.519     0.200
     1.112    23.679     0.200
     1.228    24.168     0.200
     1.338    25.147     0.200
     1.813    35.405     0.200
     0.613    13.656     0.200
     0.988    19.966     0.200
     0.988    20.117     0.200
     1.235    25.992     0.200
     1.235    24.652     0.200
     1.472    29.420     0.200
     1.490    28.511     0.200
     1.490    31.502     0.200
     2.290    45.257     0.200
     0.661    14.635     0.200
     0.616    13.235     0.200
     0.616    14.255     0.200
     0.826    17.030     0.200
     0.981    19.583     0.200
     0.981    19.474     0.200
     0.981    20.873     0.200
     1.250    24.521     0.200
     1.467    28.305     0.200
     1.467    29.624     0.200
     1.467    30.555     0.200
     1.631    30.589     0.200
     2.330    42.570     0.200
     2.988    56.488     0.200
     0.609    13.203     0.200
     0.612    12.896     0.200
     1.021    19.689     0.200
     1.021    19.390     0.200
     1.021    20.709     0.200
     1.546    29.876     0.200
     1.546    30.576     0.200
     1.622    29.714     0.200
     2.241    45.068     0.200
     3.164    58.048     0.200
     4.239    74.965     0.200
     5.566    96.487     0.200
     0.708    14.944     0.200
     0.708    15.791     0.200
     0.816    16.761     0.200
     0.923    18.453     0.200
     1.038    22.868     0.200
     1.135    22.714     0.200
     1.182    25.153     0.200
     1.182    26.903     0.200
     1.596    29.864     0.200
     1.596    33.048     0.200
     1.596    33.157     0.200
     2.254    47.068     0.200
     0.585    12.150     0.200
     0.790    16.020     0.200
     1.012    20.318     0.200
     1.012    20.838     0.200
     1.270    26.834     0.200
     1.382    26.574     0.200
     1.504    28.398     0.200
     1.866    34.537     0.200
     2.269    42.397     0.200
     0.705    15.470     0.200
     0.973    19.871     0.200
     1.540    30.094     0.200
     0.665    14.672     0.200
     1.067    21.613     0.200
     1.317    24.628     0.200
     1.330    25.356     0.200
     1.598    28.443     0.200
     2.137    38.372     0.200
     0.390     8.981     0.200
     0.819    16.926     0.200
     0.819    17.383     0.200
     1.667    30.418     0.200
     1.667    30.699     0.200
     1.607    33.637     0.200
     1.662    32.867     0.200
     1.863    36.144     0.200
     1.921    37.543     0.200
     2.011    36.489     0.200
     0.395     8.810     0.200
     1.474    27.881     0.200
     1.474    29.881     0.200
     1.474    30.732     0.200
     1.793    37.621     0.200
     1.793    37.738     0.200
     2.073    37.249     0.200
     1.435    26.768     0.200
     1.566    29.193     0.200
     2.149    37.225     0.200
     2.101    39.203     0.200
     0.810    16.891     0.200
     1.078    21.718     0.200
     1.078    23.228     0.200
     1.261    25.105     0.200
     1.261    25.586     0.200
     1.545    28.787     0.200
     1.648    33.364     0.200
     1.648    33.685     0.200
     1.983    36.938     0.200
     3.918    68.769     0.200
     0.769    16.715     0.200
     1.037    19.600     0.200
     1.037    21.225     0.200
     1.512    28.376     0.200
     1.745    33.133     0.200
     2.532    48.071     0.200
     2.702    45.487     0.200
     2.782    46.979     0.200
     0.753    15.749     0.200
     0.753    17.050     0.200
     0.939    19.188     0.200
     0.939    19.477     0.200
     0.933    19.319     0.200
     0.987    23.174     0.200
     1.105    23.016     0.200
     1.097    23.879     0.200
     1.097    24.961     0.200
     1.342    29.344     0.200
     1.491    28.554     0.200
     1.561    34.481     0.200
     1.677    35.417     0.200
     1.797    37.736     0.200
     2.020    36.902     0.200
     0.756    15.373     0.200
     0.941    18.713     0.200
     1.088    20.518     0.200
     1.104    21.251     0.200
     1.495    27.910     0.200
     3.262    61.006     0.200
     0.967    19.369     0.200
     0.999    21.626     0.200
     1.039    21.095     0.200
     1.112    22.704     0.200
     1.112    21.868     0.200
     1.353    24.161     0.200
     1.491    29.910     0.200
     1.897    36.883     0.200
     0.476    11.201     0.200
     0.743    16.237     0.200
     0.934    17.887     0.200
     0.934    19.326     0.200
     0.890    17.676     0.200
     1.083    20.303     0.200
     1.493    26.430     0.200
     1.493    29.520     0.200
     1.475    26.950     0.200
     1.983    35.276     0.200
     2.041    34.908     0.200
     0.215     5.524     0.200
     1.063    21.125     0.200
     1.624    30.453     0.200
     1.624    31.903     0.200
     1.642    30.705     0.200
     0.204     5.807     0.200
     1.022    22.041     0.200
     1.656    30.171     0.200
     1.658    30.640     0.200
     0.402    10.962     0.200
     0.513    10.704     0.200
     0.778    16.221     0.200
     0.871    16.660     0.200
     0.852    17.008     0.200
     0.862    17.742     0.200
     0.903    18.875     0.200
     1.025    20.336     0.200
     1.592    28.315     0.200
     1.592    31.033     0.200
     0.547    11.523     0.200
     0.707    15.907     0.200
     0.752    15.804     0.200
     1.051    21.984     0.200
     1.307    26.681     0.200
     1.317    27.821     0.200
     0.447    10.711     0.200
     1.330    26.896     0.200
     1.330    28.037     0.200
     1.452    26.601     0.200
     1.581    31.133     0.200
     1.581    32.834     0.200
     0.600    12.084     0.200
     1.109    20.885     0.200
     1.088    22.054     0.200
     1.674    30.594     0.200
     0.716    14.960     0.200
     1.104    23.408     0.200
     1.948    38.771     0.200
     3.348    62.314     0.200
     0.737    15.509     0.200
     0.959    21.342     0.200
     1.003    20.104     0.200
     1.128    23.579     0.200
     1.553    31.425     0.200
     0.321     8.392     0.200
     0.321     8.672     0.200
     0.466    10.180     0.200
     0.761    15.877     0.200
     0.777    16.256     0.200
     0.787    16.874     0.200
     0.827    16.631     0.200
     0.827    17.251     0.200
     0.863    19.540     0.200
     0.906    19.176     0.200
     0.970    18.944     0.200
     1.029    20.009     0.200
     1.265    25.294     0.200
     1.895    34.733     0.200
     1.946    35.937     0.200
     2.506    46.105     0.200
     0.503    11.031     0.200
     0.548    13.540     0.200
     0.736    16.348     0.200
     0.883    19.441     0.200
     0.883    19.601     0.200
     1.044    20.985     0.200
     1.882    36.943     0.200
     1.929    37.438     0.200
     0.213     7.330     0.200
     1.045    20.874     0.200
     1.546    30.407     0.200
     1.651    31.533     0.200
     3.036    50.810     0.200
     3.357    61.515     0.200
     0.802    16.813     0.200
     0.979    21.150     0.200
     1.038    22.256     0.200
     1.323    26.099     0.200
     1.483    28.264     0.200
     0.414     8.792     0.200
     0.414     8.601     0.200
     0.823    16.836     0.200
     0.894    18.618     0.200
     0.948    19.303     0.200
     1.046    20.302     0.200
     1.082    21.067     0.200
     1.082    23.208     0.200
     1.208    24.848     0.200
     1.466    26.191     0.200
     1.466    28.648     0.200
     1.466    29.460     0.200
     1.466    26.460     0.200
     1.946    36.107     0.200
     2.005    34.900     0.200
     0.456     9.670     0.200
     0.815    18.103     0.200
     1.581    31.748     0.200
     1.583    32.293     0.200
     1.640    30.926     0.200
     1.696    33.641     0.200
     1.861    35.067     0.200
     1.919    34.271     0.200
     2.021    38.852     0.200
     0.452    10.229     0.200
     1.070    21.613     0.200
     1.102    21.562     0.200
     1.102    21.223     0.200
     1.351    26.129     0.200
     1.473    28.047     0.200
     1.602    30.498     0.200
     1.783    31.023     0.200
     1.844    37.399     0.200
     0.427    10.205     0.200
     1.127    22.750     0.200
     1.164    22.410     0.200
     1.314    26.567     0.200
     1.507    30.129     0.200
     1.569    30.425     0.200
     1.718    31.600     0.200
     1.718    31.380     0.200
     1.912    37.328     0.200
     2.038    36.431     0.200
     2.838    51.980     0.200
     3.123    53.536     0.200
     3.547    61.065     0.200
     0.448     9.786     0.200
     1.109    23.272     0.200
     1.347    27.148     0.200
     1.477    29.848     0.200
     1.598    29.965     0.200
     1.852    37.435     0.200
     1.996    37.201     0.200
     2.626    49.184     0.200
     3.281    58.880     0.200
     3.540    60.506     0.200
     0.591    11.676     0.200
     0.771    15.886     0.200
     0.771    15.455     0.200
     0.835    17.035     0.200
     1.002    20.809     0.200
     1.050    20.401     0.200
     1.050    20.200     0.200
     1.077    20.966     0.200
     1.221    23.636     0.200
     1.221    24.095     0.200
     1.341    25.038     0.200
     0.315     7.450     0.200
     1.050    21.166     0.200
     1.612    29.574     0.200
     1.668    30.877     0.200
     1.714    30.734     0.200
     1.714    30.904     0.200
     3.282    59.202     0.200
     3.377    59.643     0.200
     0.337     7.659     0.200
     0.337     8.539     0.200
     1.114    21.711     0.200
     1.114    22.191     0.200
     1.619    29.348     0.200
     1.589    31.256     0.200
     3.323    58.204     0.200
     0.739    15.966     0.200
     0.951    20.369     0.200
     1.006    20.499     0.200
     1.026    21.024     0.200
     1.026    21.386     0.200
     1.138    23.658     0.200
     1.138    23.428     0.200
     1.471    28.532     0.200
     1.471    30.061     0.200
     1.509    30.533     0.200
     1.509    32.613     0.200
     1.509    34.123     0.200
     1.627    32.203     0.200
     1.799    35.091     0.200
     2.621    48.389     0.200
     2.700    49.728     0.200
     0.974    19.654     0.200
     0.964    20.184     0.200
     1.191    22.954     0.200
     1.191    24.798     0.200
     1.191    24.267     0.200
     1.573    30.780     0.200
     1.559    30.791     0.200
     2.665    49.041     0.200
     0.704    14.839     0.200
     0.981    21.016     0.200
     0.971    19.710     0.200
     1.028    21.191     0.200
     1.157    23.023     0.200
     1.500    28.774     0.200
     1.523    30.519     0.200
     1.606    32.402     0.200
     1.843    33.992     0.200
     2.705    51.494     0.200
     3.250    57.059     0.200
     0.929    19.752     0.200
     1.002    20.526     0.200
     1.205    24.848     0.200
     1.563    29.760     0.200
     3.233    58.114     0.200
     3.995    72.027     0.200
     0.618    13.300     0.200
     0.616    12.953     0.200
     0.801    16.642     0.200
     0.992    20.335     0.200
     0.992    20.794     0.200
     1.228    27.030     0.200
     1.306    28.088     0.200
     1.502    28.085     0.200
     1.502    32.156     0.200
     1.502    29.046     0.200
     3.195    58.213     0.200
     0.573    12.482     0.200
     0.863    16.921     0.200
     0.922    18.421     0.200
     1.422    26.889     0.200
     1.539    29.886     0.200
     1.586    32.125     0.200
     1.940    35.131     0.200
     2.002    35.943     0.200
     0.563    12.191     0.200
     0.859    17.628     0.200
     0.933    20.245     0.200
     1.434    28.225     0.200
     1.587    31.788     0.200
     1.793    36.007     0.200
     1.994    38.321     0.200
     1.994    37.502     0.200
     2.568    48.543     0.200
     0.905    18.652     0.200
     0.939    19.002     0.200
     1.422    27.760     0.200
     1.502    30.071     0.200
     1.826    34.974     0.200
     1.898    33.426     0.200
     1.967    37.741     0.200
     1.967    36.061     0.200
     3.710    69.990     0.200
     0.583    12.362     0.200
     0.913    19.173     0.200
     1.417    27.611     0.200
     1.545    29.610     0.200
     1.576    30.102     0.200
     1.782    33.292     0.200
     1.776    33.791     0.200
     1.951    37.010     0.200
     2.013    36.796     0.200
     3.557    63.502     0.200
     0.569    12.271     0.200
     1.434    27.806     0.200
     1.556    30.447     0.200
     1.574    30.868     0.200
     1.783    34.268     0.200
     1.779    35.772     0.200
     2.004    38.635     0.200
     0.536    11.427     0.200
     0.861    17.255     0.200
     0.960    19.296     0.200
     1.459    27.497     0.200
     1.552    29.550     0.200
     1.597    31.559     0.200
     1.815    34.597     0.200
     1.918    35.247     0.200
     1.971    35.118     0.200
     2.808    50.814     0.200
     0.533    12.371     0.200
     0.893    19.014     0.200
     0.893    18.344     0.200
     0.958    19.725     0.200
     1.445    27.496     0.200
     1.626    33.985     0.200
     1.833    36.600     0.200
     1.895    36.461     0.200
     1.957    35.149     0.200
     1.957    38.079     0.200
     3.502    63.230     0.200
     0.909    19.493     0.200
     0.909    18.661     0.200
     0.949    19.305     0.200
     1.430    27.203     0.200
     1.501    28.175     0.200
     1.638    32.181     0.200
     1.833    35.483     0.200
     1.742    31.957     0.200
     1.836    35.018     0.200
     1.889    35.630     0.200
     1.889    33.501     0.200
     1.956    36.590     0.200
     1.956    34.070     0.200
     2.602    44.289     0.200
     2.602    45.320     0.200
     2.850    48.777     0.200
     3.494    59.718     0.200
     0.511    11.578     0.200
     0.890    17.614     0.200
     0.890    18.751     0.200
     0.981    18.729     0.200
     1.468    26.786     0.200
     1.530    28.262     0.200
     1.630    29.332     0.200
     1.772    31.843     0.200
     1.847    33.047     0.200
     1.884    34.627     0.200
     1.940    35.290     0.200
     1.940    34.388     0.200
     0.568    12.814     0.200
     0.920    18.933     0.200
     0.942    19.448     0.200
     0.942    19.198     0.200
     1.388    26.438     0.200
     1.460    27.191     0.200
     1.699    31.410     0.200
     1.659    31.872     0.200
     1.835    34.302     0.200
     1.884    35.166     0.200
     1.884    33.268     0.200
     1.966    36.733     0.200
     0.542    12.156     0.200
     0.924    19.685     0.200
     0.946    18.871     0.200
     1.650    31.976     0.200
     1.842    34.393     0.200
     1.849    35.050     0.200
     1.880    36.055     0.200
     1.953    34.892     0.200
     0.549    12.718     0.200
     0.900    19.580     0.200
     0.941    20.047     0.200
     1.425    28.414     0.200
     1.508    30.216     0.200
     1.626    33.224     0.200
     1.748    34.503     0.200
     1.824    35.725     0.200
     1.901    37.034     0.200
     1.968    37.625     0.200
     2.591    46.128     0.200
     2.591    47.573     0.200
     3.563    63.159     0.200
     3.695    66.891     0.200
     0.580    12.706     0.200
     0.916    19.135     0.200
     1.420    26.861     0.200
     1.576    31.153     0.200
     1.777    33.837     0.200
     2.011    38.480     0.200
     2.551    44.511     0.200
     3.556    62.635     0.200
     0.549    12.238     0.200
     0.946    19.184     0.200
     1.006    19.177     0.200
     1.387    26.259     0.200
     1.403    27.282     0.200
     1.724    31.563     0.200
     1.827    34.647     0.200
     1.827    34.097     0.200
     1.890    34.780     0.200
     1.882    33.950     0.200
     1.920    34.813     0.200
     1.920    35.343     0.200
     2.634    44.542     0.200
     2.634    45.863     0.200
     3.260    60.484     0.200
     0.613    13.351     0.200
     1.364    26.695     0.200
     1.492    28.299     0.200
     1.607    31.297     0.200
     1.776    34.214     0.200
     1.942    36.339     0.200
     2.001    38.654     0.200
     2.022    36.367     0.200
     2.022    37.188     0.200
     2.534    44.581     0.200
     0.588    12.649     0.200
     0.944    19.619     0.200
     0.944    20.248     0.200
     1.368    27.983     0.200
     1.453    28.726     0.200
     1.654    31.560     0.200
     1.691    33.446     0.200
     1.820    35.333     0.200
     1.897    36.088     0.200
     1.983    36.599     0.200
     3.495    65.164     0.200
     0.933    19.973     0.200
     0.933    20.528     0.200
     0.933    18.847     0.200
     1.405    26.632     0.200
     1.473    27.315     0.200
     1.654    31.826     0.200
     1.712    31.165     0.200
     1.838    34.361     0.200
     1.959    36.461     0.200
     1.959    35.633     0.200
     2.597    44.964     0.200
     2.867    49.296     0.200
     3.485    60.015     0.200
     0.959    19.680     0.200
     0.948    20.035     0.200
     0.948    19.336     0.200
     1.424    27.415     0.200
     1.465    29.201     0.200
     1.676    31.829     0.200
     1.707    32.149     0.200
     1.866    34.505     0.200
     1.856    36.222     0.200
     1.856    34.030     0.200
     1.931    37.000     0.200
     1.931    35.559     0.200
     0.591    12.866     0.200
     0.897    18.293     0.200
     0.941    19.547     0.200
     0.941    19.678     0.200
     1.366    26.320     0.200
     1.456    28.235     0.200
     1.650    30.998     0.200
     1.693    32.278     0.200
     1.816    33.831     0.200
     1.901    36.007     0.200
     2.568    44.628     0.200
     0.541    13.047     0.200
     0.949    19.191     0.200
     0.898    17.980     0.200
     1.512    27.541     0.200
     1.627    32.467     0.200
     1.752    33.576     0.200
     1.897    36.010     0.200
     0.586    13.744     0.200
     0.903    18.703     0.200
     0.949    19.928     0.200
     0.949    19.478     0.200
     1.369    26.206     0.200
     1.449    27.111     0.200
     1.686    30.647     0.200
     1.660    32.515     0.200
     1.892    35.012     0.200
     1.826    35.111     0.200
     2.576    44.260     0.200
     0.584    12.391     0.200
     0.906    18.281     0.200
     0.898    17.614     0.200
     0.898    17.136     0.200
     1.392    27.412     0.200
     1.500    29.375     0.200
     1.614    30.561     0.200
     1.737    33.036     0.200
     1.836    33.894     0.200
     1.924    35.436     0.200
     0.580    12.428     0.200
     0.872    18.268     0.200
     0.913    18.464     0.200
     1.410    26.785     0.200
     1.528    28.679     0.200
     1.592    29.716     0.200
     1.765    32.685     0.200
     1.808    34.517     0.200
     1.938    35.766     0.200
     2.556    44.542     0.200
     2.556    43.320     0.200
     2.804    50.128     0.200
     0.596    13.362     0.200
     0.899    18.632     0.200
     1.003    19.408     0.200
     1.003    20.937     0.200
     1.342    26.545     0.200
     1.394    26.714     0.200
     1.632    31.489     0.200
     1.707    33.898     0.200
     1.861    35.863     0.200
     1.861    32.884     0.200
     1.854    35.596     0.200
     1.942    37.463     0.200
     0.582    13.384     0.200
     0.906    18.535     0.200
     0.949    19.968     0.200
     0.949    20.526     0.200
     1.372    26.348     0.200
     1.450    27.624     0.200
     1.688    31.655     0.200
     1.661    31.090     0.200
     1.889    36.356     0.200
     1.828    33.686     0.200
     1.886    35.718     0.200
     0.562    12.657     0.200
     0.952    21.399     0.200
     1.670    33.079     0.200
     1.845    35.985     0.200
     1.882    35.418     0.200
     0.581    12.669     0.200
     0.911    19.262     0.200
     0.986    20.823     0.200
     0.986    19.364     0.200
     1.361    26.388     0.200
     1.853    36.879     0.200
     2.908    51.030     0.200
     3.224    56.617     0.200
     0.593    13.047     0.200
     0.960    20.458     0.200
     0.960    21.538     0.200
     1.357    26.604     0.200
     1.436    27.460     0.200
     1.674    31.481     0.200
     1.667    32.732     0.200
     1.827    36.383     0.200
     2.574    45.304     0.200
     0.543    11.119     0.200
     0.543    10.979     0.200
     0.749    16.154     0.200
     0.749    16.414     0.200
     0.825    16.022     0.200
     0.917    19.377     0.200
     0.917    19.033     0.200
     0.917    19.873     0.200
     0.934    18.532     0.200
     1.032    20.673     0.200
     1.032    20.213     0.200
     1.013    19.770     0.200
     1.062    22.099     0.200
     1.174    23.036     0.200
     1.130    23.980     0.200
     1.259    26.321     0.200
     1.590    28.928     0.200
     1.541    31.842     0.200
     0.459    10.954     0.200
     0.540    11.491     0.200
     0.540    11.171     0.200
     0.830    16.586     0.200
     0.902    20.442     0.200
     0.909    18.442     0.200
     0.920    18.431     0.200
     0.960    19.118     0.200
     0.960    20.387     0.200
     1.034    20.644     0.200
     1.244    23.951     0.200
     1.314    26.234     0.200
     1.595    28.905     0.200
     1.595    28.785     0.200
     1.650    30.297     0.200
     2.224    38.765     0.200
     0.595    12.910     0.200
     0.893    18.027     0.200
     0.946    20.408     0.200
     0.946    18.949     0.200
     1.361    25.160     0.200
     1.450    25.853     0.200
     1.687    30.139     0.200
     1.654    32.187     0.200
     1.817    33.808     0.200
     1.887    35.284     0.200
     1.988    34.891     0.200
     2.567    44.254     0.200
     3.644    63.123     0.200
     0.578    12.877     0.200
     0.913    18.658     0.200
     0.984    19.631     0.200
     1.364    26.058     0.200
     1.416    27.015     0.200
     1.655    31.317     0.200
     1.695    30.739     0.200
     1.854    34.582     0.200
     2.598    44.564     0.200
     0.927    18.345     0.200
     0.995    20.196     0.200
     0.995    19.516     0.200
     1.372    26.975     0.200
     1.648    31.854     0.200
     1.709    32.436     0.200
     1.870    35.128     0.200
     1.846    33.224     0.200
     1.846    32.964     0.200
     1.941    36.519     0.200
     1.941    34.259     0.200
     2.614    45.698     0.200
     3.240    59.018     0.200
     0.583    12.669     0.200
     0.906    19.090     0.200
     0.905    19.793     0.200
     0.905    20.133     0.200
     1.390    26.399     0.200
     1.731    32.056     0.200
     1.620    31.554     0.200
     1.801    35.100     0.200
     1.842    35.315     0.200
     0.581    12.889     0.200
     0.869    19.036     0.200
     0.912    18.509     0.200
     1.410    25.791     0.200
     1.589    33.354     0.200
     1.784    32.373     0.200
     1.806    33.948     0.200
     2.554    43.989     0.200
     0.585    12.647     0.200
     0.902    18.652     0.200
     1.377    26.113     0.200
     1.641    32.465     0.200
     1.813    35.056     0.200
     1.987    35.143     0.200
     1.866    36.584     0.200
     2.569    44.341     0.200
     0.595    13.019     0.200
     0.894    18.328     0.200
     1.354    25.649     0.200
     1.432    26.296     0.200
     1.670    30.661     0.200
     1.670    32.608     0.200
     1.888    34.836     0.200
     1.828    34.590     0.200
     1.904    35.768     0.200
     1.981    35.257     0.200
     2.574    44.774     0.200
     0.478     9.764     0.200
     1.027    21.826     0.200
     1.529    29.254     0.200
     1.603    34.040     0.200
     1.744    35.863     0.200
     1.928    37.166     0.200
     1.998    39.307     0.200
     1.853    37.416     0.200
     2.644    47.173     0.200
     0.507    10.674     0.200
     0.992    20.296     0.200
     1.490    29.416     0.200
     1.564    29.313     0.200
     1.604    31.729     0.200
     1.807    34.381     0.200
     1.769    34.496     0.200
     1.836    35.286     0.200
     1.902    34.749     0.200
     1.948    35.626     0.200
     1.948    35.216     0.200
     1.995    37.825     0.200
     2.619    46.214     0.200
     3.194    55.532     0.200
     0.473    10.375     0.200
     1.044    21.488     0.200
     1.555    29.294     0.200
     1.584    32.023     0.200
     1.713    33.246     0.200
     1.849    35.589     0.200
     1.906    35.166     0.200
     1.931    34.563     0.200
     1.931    38.102     0.200
     2.648    46.084     0.200
     3.775    68.038     0.200
     0.584    12.576     0.200
     0.904    19.147     0.200
     0.935    18.813     0.200
     0.935    18.993     0.200
     1.376    26.170     0.200
     1.376    35.090     0.200
     1.463    28.612     0.200
     1.701    30.388     0.200
     1.648    31.769     0.200
     1.818    34.176     0.200
     1.983    34.644     0.200
     0.883    17.138     0.200
     0.883    16.927     0.200
     0.921    17.762     0.200
     1.413    26.409     0.200
     1.519    27.152     0.200
     1.604    34.128     0.200
     1.799    35.767     0.200
     1.993    36.423     0.200
     0.541    12.799     0.200
     0.950    20.259     0.200
     1.675    33.290     0.200
     1.859    34.821     0.200
     1.875    36.912     0.200
     2.887    51.433     0.200
     3.226    58.989     0.200
     0.586    12.962     0.200
     0.902    17.945     0.200
     0.937    18.054     0.200
     0.937    19.754     0.200
     1.373    26.287     0.200
     1.461    27.441     0.200
     1.698    30.720     0.200
     1.649    34.621     0.200
     1.818    34.765     0.200
     1.984    34.382     0.200
     1.825    35.314     0.200
     1.887    38.912     0.200
     1.831    37.515     0.200
     2.001    38.750     0.200
     2.001    37.141     0.200
     2.572    49.535     0.200
     3.276    58.554     0.200
     7.737   163.652     0.200
     0.548    11.402     0.200
     0.930    19.428     0.200
     0.940    20.237     0.200
     1.412    28.262     0.200
     1.477    28.437     0.200
     1.654    32.419     0.200
     1.717    32.085     0.200
     1.842    36.132     0.200
     1.955    36.043     0.200
     0.555    11.883     0.200
     0.935    19.153     0.200
     0.971    19.320     0.200
     0.971    19.080     0.200
     1.391    26.833     0.200
     1.435    27.396     0.200
     1.675    29.861     0.200
     1.690    31.784     0.200
     1.856    34.530     0.200
     1.862    34.434     0.200
     1.943    36.020     0.200
     2.612    45.372     0.200
     0.553    11.787     0.200
     0.935    20.340     0.200
     0.939    18.696     0.200
     0.939    20.327     0.200
     1.404    27.823     0.200
     1.660    32.514     0.200
     1.707    33.364     0.200
     1.843    35.391     0.200
     1.877    35.181     0.200
     1.877    33.861     0.200
     1.955    36.069     0.200
     1.955    35.749     0.200
     2.812    52.142     0.200
     0.578    12.405     0.200
     0.898    19.222     0.200
     0.898    18.624     0.200
     0.911    19.372     0.200
     1.398    28.067     0.200
     1.501    30.119     0.200
     1.616    32.878     0.200
     1.739    33.435     0.200
     1.802    35.866     0.200
     1.920    37.449     0.200
     1.993    38.189     0.200
     2.565    46.195     0.200
     0.566    12.542     0.200
     0.901    18.880     0.200
     1.408    27.387     0.200
     1.622    33.164     0.200
     1.811    34.845     0.200
     1.811    38.325     0.200
     1.911    34.989     0.200
     0.595    13.171     0.200
     0.893    18.886     0.200
     1.374    25.805     0.200
     1.625    32.644     0.200
     1.718    31.801     0.200
     1.798    34.627     0.200
     2.555    44.540     0.200
     2.838    50.003     0.200
     0.564    12.220     0.200
     1.406    26.744     0.200
     1.632    33.668     0.200
     1.819    34.499     0.200
     2.582    45.473     0.200
     0.678    14.650     0.200
     1.096    23.550     0.200
     1.090    22.298     0.200
     1.515    28.903     0.200
     1.736    33.356     0.200
     3.115    55.320     0.200
     3.399    63.145     0.200
     0.572    11.823     0.200
     0.917    18.895     0.200
     0.970    20.505     0.200
     0.970    19.587     0.200
     1.374    26.833     0.200
     1.432    26.823     0.200
     1.671    30.744     0.200
     1.683    33.929     0.200
     1.849    34.311     0.200
     1.958    35.452     0.200
     1.084    23.264     0.200
     1.084    21.714     0.200
     1.295    25.447     0.200
     1.310    25.997     0.200
     1.547    30.477     0.200
     1.776    33.674     0.200
     1.824    36.035     0.200
     1.824    33.895     0.200
     1.892    35.284     0.200
     1.951    37.998     0.200
     1.951    35.668     0.200
     2.608    45.528     0.200
     0.577    12.852     0.200
     0.863    16.776     0.200
     0.918    18.311     0.200
     1.417    26.621     0.200
     1.586    32.016     0.200
     1.538    31.100     0.200
     1.785    35.347     0.200
     2.556    48.140     0.200
     3.147    55.941     0.200
     3.566    61.766     0.200
     0.581    12.590     0.200
     0.903    19.232     0.200
     1.393    26.731     0.200
     1.619    33.822     0.200
     1.802    36.081     0.200
     1.994    35.938     0.200
     0.871    17.770     0.200
     0.871    17.442     0.200
     0.980    20.018     0.200
     1.474    28.445     0.200
     1.548    28.730     0.200
     1.612    33.820     0.200
     1.790    32.702     0.200
     1.835    34.235     0.200
     1.899    36.115     0.200
     1.899    33.959     0.200
     1.951    36.056     0.200
     1.951    35.524     0.200
     0.543    11.615     0.200
     0.870    16.845     0.200
     0.870    19.455     0.200
     0.951    18.932     0.200
     1.447    26.422     0.200
     1.602    31.190     0.200
     1.813    35.002     0.200
     1.974    34.258     0.200
     0.545    12.852     0.200
     0.906    19.141     0.200
     1.426    27.504     0.200
     1.894    35.409     0.200
     1.962    35.491     0.200
     0.894    17.588     0.200
     0.975    18.697     0.200
     0.975    18.861     0.200
     1.632    33.928     0.200
     1.845    36.085     0.200
     1.943    33.574     0.200
     1.943    33.684     0.200
     0.535    11.539     0.200
     0.954    19.370     0.200
     1.411    27.351     0.200
     1.445    28.814     0.200
     1.691    33.194     0.200
     1.847    33.666     0.200
     1.873    36.024     0.200
     1.912    34.882     0.200
     1.928    35.505     0.200
     3.702    69.384     0.200
     0.890    17.183     0.200
     0.951    19.029     0.200
     1.439    26.972     0.200
     1.620    30.016     0.200
     1.761    31.465     0.200
     1.825    31.995     0.200
     1.902    33.972     0.200
     1.964    33.781     0.200
     0.579    12.888     0.200
     1.393    27.170     0.200
     1.492    28.271     0.200
     1.624    32.626     0.200
     1.730    32.276     0.200
     1.915    34.954     0.200
     0.892    16.788     0.200
     0.928    18.261     0.200
     1.416    26.922     0.200
     1.615    33.428     0.200
     1.751    31.205     0.200
     1.987    36.678     0.200
     0.560    12.618     0.200
     0.858    16.797     0.200
     0.936    19.052     0.200
     1.437    28.398     0.200
     1.548    30.220     0.200
     1.586    31.158     0.200
     1.993    36.538     0.200
     1.426    27.956     0.200
     1.585    31.478     0.200
     1.788    34.335     0.200
     1.939    38.397     0.200
     1.939    36.948     0.200
     2.000    38.976     0.200
     2.000    38.777     0.200
     0.558    12.299     0.200
     0.884    17.383     0.200
     0.884    19.231     0.200
     0.934    18.855     0.200
     1.425    26.155     0.200
     1.610    32.790     0.200
     1.809    33.802     0.200
     1.981    37.463     0.200
     2.822    50.397     0.200
     0.560    11.873     0.200
     0.929    18.389     0.200
     0.957    20.887     0.200
     1.390    27.020     0.200
     1.447    27.282     0.200
     1.687    32.484     0.200
     1.675    31.964     0.200
     1.953    35.474     0.200
     1.953    34.146     0.200
     0.574    12.676     0.200
     0.921    19.350     0.200
     1.583    32.100     0.200
     1.780    35.238     0.200
     1.785    36.093     0.200
     1.942    37.162     0.200
     2.004    36.363     0.200
     2.795    49.815     0.200
     0.565    12.618     0.200
     0.927    19.261     0.200
     0.881    18.412     0.200
     1.420    27.752     0.200
     1.605    32.182     0.200
     1.802    34.328     0.200
     1.923    33.784     0.200
     0.846    17.148     0.200
     0.985    20.986     0.200
     0.985    20.510     0.200
     1.299    24.842     0.200
     1.673    32.349     0.200
     3.177    55.116     0.200
     0.879    17.649     0.200
     1.061    19.796     0.200
     1.295    24.983     0.200
     1.331    25.735     0.200
     1.753    32.796     0.200
     1.844    33.142     0.200
     1.844    32.731     0.200
     1.966    34.600     0.200
     1.966    34.750     0.200
     0.564    12.263     0.200
     0.885    17.536     0.200
     1.419    27.184     0.200
     1.609    33.326     0.200
     2.821    52.334     0.200
     3.683    68.447     0.200
     0.525    12.190     0.200
     0.910    19.249     0.200
     0.964    19.059     0.200
     1.444    26.465     0.200
     1.505    29.348     0.200
     1.847    32.293     0.200
     1.880    35.660     0.200
     1.944    33.786     0.200
     1.958    35.637     0.200
     0.929    19.469     0.200
     1.414    28.985     0.200
     1.504    30.794     0.200
     1.624    32.301     0.200
     1.624    32.473     0.200
     1.908    37.188     0.200
     1.977    37.873     0.200
     2.836    50.105     0.200
     3.552    64.830     0.200
     3.683    65.065     0.200
     0.554    11.881     0.200
     0.912    17.490     0.200
     0.912    18.412     0.200
     0.934    18.413     0.200
     1.414    27.491     0.200
     1.636    32.544     0.200
     1.826    34.318     0.200
     1.968    36.129     0.200
     3.688    66.620     0.200
     0.565    12.522     0.200
     0.936    18.802     0.200
     1.443    26.958     0.200
     1.565    29.575     0.200
     1.569    33.498     0.200
     1.783    34.035     0.200
     0.562    11.736     0.200
     0.926    19.708     0.200
     0.932    19.980     0.200
     1.398    27.377     0.200
     1.471    28.021     0.200
     1.652    32.686     0.200
     1.711    32.249     0.200
     1.833    34.946     0.200
     1.863    37.609     0.200
     1.966    35.852     0.200
     0.569    12.403     0.200
     0.895    19.214     0.200
     0.895    18.374     0.200
     0.921    19.159     0.200
     1.408    26.863     0.200
     1.507    27.970     0.200
     1.616    29.670     0.200
     1.807    32.635     0.200
     1.987    34.705     0.200
     2.828    50.653     0.200
     3.520    61.457     0.200
     0.569    12.952     0.200
     0.867    17.695     0.200
     0.867    17.936     0.200
     0.925    19.004     0.200
     1.423    28.071     0.200
     1.536    28.414     0.200
     1.591    30.530     0.200
     1.792    32.935     0.200
     1.997    35.363     0.200
     3.540    61.793     0.200
     0.570    13.411     0.200
     0.849    17.438     0.200
     0.849    18.907     0.200
     0.928    18.683     0.200
     1.433    27.198     0.200
     1.576    29.837     0.200
     1.783    33.126     0.200
     2.004    35.751     0.200
     2.788    49.605     0.200
     0.895    18.687     0.200
     1.403    27.690     0.200
     1.614    33.654     0.200
     1.802    36.270     0.200
     2.826    50.658     0.200
     3.167    54.968     0.200
     0.956    19.067     0.200
     1.147    23.158     0.200
     1.147    21.218     0.200
     1.259    25.090     0.200
     1.331    25.730     0.200
     1.744    32.460     0.200
     1.744    31.690     0.200
     1.851    34.708     0.200
     1.879    34.545     0.200
     1.879    33.464     0.200
     1.972    36.965     0.200
     2.683    46.455     0.200
     0.585    12.822     0.200
     0.951    18.668     0.200
     1.117    21.926     0.200
     1.117    21.777     0.200
     1.289    25.004     0.200
     1.340    26.124     0.200
     1.531    28.804     0.200
     1.762    31.541     0.200
     1.824    33.820     0.200
     1.953    36.482     0.200
     2.671    45.274     0.200
     2.671    47.944     0.200
     3.415    61.396     0.200
     0.578    12.695     0.200
     0.911    19.851     0.200
     1.375    26.255     0.200
     1.685    30.740     0.200
     1.666    34.740     0.200
     1.834    35.078     0.200
     1.970    35.553     0.200
     1.888    37.034     0.200
     2.312    41.105     0.200
     2.585    45.875     0.200
     2.878    49.943     0.200
     0.907    17.687     0.200
     0.956    18.918     0.200
     1.370    25.970     0.200
     1.443    27.609     0.200
     1.681    31.549     0.200
     1.667    30.349     0.200
     1.884    35.814     0.200
     1.833    33.596     0.200
     1.972    35.968     0.200
     0.573    11.896     0.200
     0.890    19.547     0.200
     0.917    18.486     0.200
     1.407    25.999     0.200
     1.610    31.361     0.200
     4.430    81.508     0.200
     0.922    18.611     0.200
     0.914    20.074     0.200
     1.402    25.803     0.200
     1.634    31.480     0.200
     1.819    34.429     0.200
     1.903    33.884     0.200
     1.977    34.965     0.200
     2.581    44.781     0.200
     0.557    12.583     0.200
     0.931    18.860     0.200
     0.935    19.399     0.200
     0.935    18.739     0.200
     1.470    28.922     0.200
     1.656    32.135     0.200
     1.838    34.757     0.200
     1.864    35.743     0.200
     0.543    12.286     0.200
     0.927    19.443     0.200
     0.927    20.412     0.200
     1.482    28.020     0.200
     1.653    32.684     0.200
     1.843    35.479     0.200
     2.606    49.753     0.200
     2.865    51.098     0.200
     0.471    10.537     0.200
     1.045    21.511     0.200
     1.555    29.301     0.200
     1.586    30.954     0.200
     1.621    30.685     0.200
     1.714    33.296     0.200
     1.851    35.129     0.200
     1.866    34.685     0.200
     1.904    35.033     0.200
     1.929    35.782     0.200
     2.650    46.258     0.200
     2.793    49.158     0.200
     0.877    18.157     0.200
     0.921    18.232     0.200
     1.416    26.916     0.200
     1.599    30.686     0.200
     1.763    33.088     0.200
     1.796    32.771     0.200
     1.995    38.802     0.200
     2.565    43.790     0.200
     3.159    56.099     0.200
     5.031    89.315     0.200
     0.540    11.674     0.200
     0.958    18.739     0.200
     1.460    25.786     0.200
     1.589    32.817     0.200
     1.808    35.151     0.200
     1.925    34.255     0.200
     1.978    35.290     0.200
     2.588    44.262     0.200
     0.559    12.344     0.200
     0.936    19.209     0.200
     1.436    27.175     0.200
     1.545    31.381     0.200
     1.589    32.863     0.200
     1.796    34.611     0.200
     0.952    21.360     0.200
     1.650    31.394     0.200
     1.674    33.588     0.200
     1.799    36.225     0.200
     1.917    35.645     0.200
     2.011    35.911     0.200
     0.552    12.078     0.200
     0.905    17.453     0.200
     0.905    19.473     0.200
     0.937    18.688     0.200
     1.420    26.593     0.200
     1.630    32.439     0.200
     1.741    32.031     0.200
     1.824    34.993     0.200
     1.969    35.285     0.200
     1.969    36.315     0.200
     0.840    17.179     0.200
     0.804    17.124     0.200
     1.278    24.991     0.200
     1.372    27.606     0.200
     1.520    30.580     0.200
     2.497    45.199     0.200
     2.801    52.274     0.200
     1.184    23.786     0.200
     1.222    25.581     0.200
     1.222    26.203     0.200
     1.428    27.707     0.200
     1.700    33.694     0.200
     1.700    32.073     0.200
     1.921    36.315     0.200
     1.856    35.775     0.200
     1.856    33.885     0.200
     2.022    39.496     0.200
     3.399    61.155     0.200
     0.661    14.701     0.200
     0.923    19.157     0.200
     1.199    23.970     0.200
     1.196    24.778     0.200
     1.196    23.508     0.200
     1.270    25.120     0.200
     1.439    27.595     0.200
     1.883    35.841     0.200
     1.972    39.395     0.200
     2.591    49.153     0.200
     2.663    49.935     0.200
     3.619    63.406     0.200
     1.184    24.991     0.200
     1.206    24.795     0.200
     1.206    24.975     0.200
     1.238    26.208     0.200
     1.421    29.066     0.200
     1.421    27.734     0.200
     1.934    35.282     0.200
     1.884    37.872     0.200
     1.958    38.258     0.200
     2.642    46.046     0.200
     0.935    19.028     0.200
     1.194    23.446     0.200
     1.203    24.362     0.200
     1.203    23.182     0.200
     1.280    25.266     0.200
     1.435    27.505     0.200
     1.740    30.671     0.200
     1.893    34.672     0.200
     1.984    35.728     0.200
     0.884    18.213     0.200
     1.023    21.137     0.200
     1.318    24.615     0.200
     1.720    34.622     0.200
     1.860    33.790     0.200
     1.854    36.011     0.200
     1.970    36.239     0.200
     0.757    15.989     0.200
     0.923    20.222     0.200
     1.156    23.390     0.200
     1.478    28.306     0.200
     1.478    30.325     0.200
     1.515    30.314     0.200
     1.613    32.958     0.200
     2.727    49.702     0.200
     1.197    23.751     0.200
     0.917    18.787     0.200
     1.537    29.773     0.200
     1.176    23.074     0.200
     1.448    27.354     0.200
     1.448    27.245     0.200
     1.391    26.443     0.200
     1.684    30.608     0.200
     1.684    29.987     0.200
     2.312    45.684     0.200
     2.984    53.870     0.200
     1.188    23.412     0.200
     0.929    18.955     0.200
     1.388    27.134     0.200
     1.413    28.210     0.200
     1.457    27.850     0.200
     1.688    30.161     0.200
     2.229    40.508     0.200
     2.301    42.297     0.200
     3.078    53.905     0.200
     0.932    18.934     0.200
     1.188    22.936     0.200
     1.209    24.012     0.200
     1.209    24.817     0.200
     1.273    24.568     0.200
     1.428    27.975     0.200
     1.899    33.956     0.200
     1.897    36.085     0.200
     1.985    38.707     0.200
     2.674    49.118     0.200
     3.309    57.128     0.200
     0.637    13.669     0.200
     0.925    19.911     0.200
     1.164    24.336     0.200
     1.164    23.805     0.200
     1.290    25.143     0.200
     1.856    35.444     0.200
     1.958    37.379     0.200
     0.628    13.739     0.200
     0.955    19.467     0.200
     1.196    24.634     0.200
     1.196    24.314     0.200
     1.207    23.238     0.200
     1.305    25.534     0.200
     1.450    27.628     0.200
     1.726    32.348     0.200
     1.726    31.168     0.200
     1.876    33.055     0.200
     1.893    35.970     0.200
     1.995    36.952     0.200
     0.777    16.435     0.200
     1.039    20.809     0.200
     1.264    25.714     0.200
     1.388    26.382     0.200
     1.399    28.204     0.200
     0.924    18.149     0.200
     0.924    20.274     0.200
     1.184    22.422     0.200
     1.209    23.573     0.200
     1.406    26.412     0.200
     1.436    27.224     0.200
     1.436    26.701     0.200
     1.537    31.669     0.200
     1.669    30.746     0.200
     1.669    29.879     0.200
     2.321    44.060     0.200
     2.971    51.260     0.200
     0.932    18.731     0.200
     1.190    22.912     0.200
     1.189    22.776     0.200
     1.189    24.385     0.200
     1.391    25.554     0.200
     1.456    26.127     0.200
     1.456    27.014     0.200
     1.686    30.659     0.200
     0.746    16.053     0.200
     0.929    19.868     0.200
     1.185    23.763     0.200
     1.155    23.287     0.200
     1.490    27.290     0.200
     1.490    27.157     0.200
     1.356    26.185     0.200
     1.722    31.440     0.200
     1.508    27.454     0.200
     3.026    56.105     0.200
     3.249    56.770     0.200
     0.903    18.205     0.200
     1.111    22.398     0.200
     1.111    22.187     0.200
     1.294    24.128     0.200
     1.802    31.407     0.200
     1.804    32.761     0.200
     3.623    61.872     0.200
     0.923    18.463     0.200
     1.162    21.990     0.200
     1.162    22.671     0.200
     1.235    23.774     0.200
     1.288    24.543     0.200
     1.475    27.225     0.200
     1.854    34.195     0.200
     1.910    33.098     0.200
     1.955    35.123     0.200
     3.340    57.694     0.200
     3.332    58.466     0.200
     0.926    18.794     0.200
     1.093    20.546     0.200
     1.093    21.175     0.200
     1.307    24.286     0.200
     1.327    25.110     0.200
     1.548    28.312     0.200
     1.796    33.208     0.200
     1.915    33.316     0.200
     1.923    36.850     0.200
     3.298    60.551     0.200
     4.250    72.957     0.200
     0.632    13.608     0.200
     0.939    20.039     0.200
     1.176    23.376     0.200
     1.176    25.548     0.200
     1.298    25.498     0.200
     1.746    32.350     0.200
     1.871    35.377     0.200
     1.974    36.830     0.200
     2.674    49.329     0.200
     0.609    13.540     0.200
     0.942    20.040     0.200
     1.145    22.609     0.200
     1.257    24.454     0.200
     1.317    26.123     0.200
     1.499    28.345     0.200
     1.756    31.613     0.200
     1.845    34.287     0.200
     1.892    33.799     0.200
     1.961    36.657     0.200
     0.612    13.458     0.200
     0.945    18.840     0.200
     1.155    21.756     0.200
     1.155    23.138     0.200
     1.247    24.817     0.200
     1.315    25.409     0.200
     1.489    29.122     0.200
     1.749    31.725     0.200
     1.749    31.155     0.200
     1.855    33.921     0.200
     1.855    37.858     0.200
     1.888    33.790     0.200
     1.888    33.200     0.200
     1.968    36.979     0.200
     2.675    45.558     0.200
     3.379    58.803     0.200
     0.675    14.500     0.200
     0.930    19.940     0.200
     1.226    26.101     0.200
     1.226    26.381     0.200
     1.262    25.358     0.200
     1.910    37.601     0.200
     1.902    34.989     0.200
     3.388    61.627     0.200
     0.673    14.202     0.200
     0.940    19.842     0.200
     1.161    23.374     0.200
     1.267    25.518     0.200
     1.401    27.867     0.200
     1.892    35.189     0.200
     1.922    37.213     0.200
     2.003    36.949     0.200
     2.686    50.731     0.200
     0.761    15.220     0.200
     1.055    20.061     0.200
     0.919    19.391     0.200
     1.154    22.923     0.200
     1.475    28.183     0.200
     1.475    29.423     0.200
     1.516    28.796     0.200
     3.279    59.324     0.200
     4.034    70.653     0.200
     0.738    16.111     0.200
     0.924    19.144     0.200
     1.182    23.335     0.200
     1.193    23.938     0.200
     1.452    27.219     0.200
     1.452    26.889     0.200
     1.391    27.690     0.200
     1.685    30.840     0.200
     1.685    33.471     0.200
     1.685    30.612     0.200
     2.307    41.049     0.200
     1.144    24.022     0.200
     1.182    24.518     0.200
     1.182    24.878     0.200
     1.154    23.296     0.200
     1.448    28.110     0.200
     1.448    27.712     0.200
     1.465    29.529     0.200
     1.622    31.496     0.200
     0.589    12.741     0.200
     0.996    21.327     0.200
     1.048    20.591     0.200
     1.059    21.391     0.200
     1.079    21.487     0.200
     1.220    24.990     0.200
     1.342    25.896     0.200
     1.352    28.471     0.200
     1.593    29.938     0.200
     1.593    28.858     0.200
     1.667    32.118     0.200
     2.117    39.387     0.200
     0.242     5.637     0.200
     1.342    26.691     0.200
     1.342    26.821     0.200
     1.337    26.663     0.200
     1.337    27.132     0.200
     1.378    26.475     0.200
     1.378    29.166     0.200
     1.378    26.995     0.200
     1.419    27.800     0.200
     1.506    29.159     0.200
     1.506    30.309     0.200
     1.481    30.240     0.200
     2.428    46.313     0.200
     2.963    55.720     0.200
     0.815    16.546     0.200
     1.082    21.418     0.200
     1.209    24.407     0.200
     1.209    24.657     0.200
     1.283    24.590     0.200
     1.508    30.609     0.200
     1.563    28.824     0.200
     1.563    33.101     0.200
     1.671    31.194     0.200
     2.879    52.924     0.200
     3.276    58.456     0.200
     0.824    17.544     0.200
     1.089    21.489     0.200
     1.196    23.685     0.200
     1.266    25.816     0.200
     1.266    23.976     0.200
     1.545    28.354     0.200
     1.526    29.981     0.200
     1.655    30.444     0.200
     3.290    57.582     0.200
     0.564    11.376     0.200
     0.798    15.295     0.200
     0.972    20.507     0.200
     0.970    19.496     0.200
     0.970    19.597     0.200
     0.969    19.970     0.200
     0.987    21.380     0.200
     1.034    20.294     0.200
     1.028    20.724     0.200
     1.058    20.965     0.200
     1.104    23.068     0.200
     1.195    23.418     0.200
     1.195    24.008     0.200
     1.312    24.604     0.200
     1.584    29.540     0.200
     0.552    11.068     0.200
     0.551    11.146     0.200
     0.813    16.845     0.200
     0.813    16.714     0.200
     0.940    20.134     0.200
     0.941    20.192     0.200
     0.945    17.992     0.200
     0.958    19.882     0.200
     0.958    20.501     0.200
     1.034    20.475     0.200
     1.032    20.099     0.200
     1.032    20.529     0.200
     1.183    23.867     0.200
     1.283    24.285     0.200
     1.331    24.571     0.200
     1.337    26.913     0.200
     1.763    32.040     0.200
     0.558    13.178     0.200
     0.619    12.688     0.200
     0.619    13.004     0.200
     1.014    20.580     0.200
     1.055    22.068     0.200
     1.084    21.414     0.200
     1.084    21.945     0.200
     1.250    24.700     0.200
     1.250    25.426     0.200
     1.268    25.852     0.200
     1.331    25.826     0.200
     1.370    25.912     0.200
     1.409    29.987     0.200
     1.630    30.740     0.200
     1.630    31.924     0.200
     1.832    33.745     0.200
     2.006    36.844     0.200
     2.188    39.414     0.200
     3.114    56.609     0.200
     0.526    12.969     0.200
     0.658    13.186     0.200
     0.593    11.937     0.200
     0.592    11.824     0.200
     1.036    21.355     0.200
     1.067    21.627     0.200
     1.224    24.185     0.200
     1.224    24.525     0.200
     1.235    25.189     0.200
     1.618    31.076     0.200
     1.596    32.638     0.200
     0.566    11.487     0.200
     0.565    11.541     0.200
     0.802    16.596     0.200
     0.797    17.015     0.200
     0.797    15.945     0.200
     0.970    19.318     0.200
     0.968    19.817     0.200
     0.968    20.325     0.200
     0.987    20.939     0.200
     1.036    21.056     0.200
     1.028    20.772     0.200
     1.057    21.419     0.200
     1.105    23.173     0.200
     1.116    23.113     0.200
     1.197    22.525     0.200
     1.197    24.400     0.200
     1.414    25.407     0.200
     1.586    29.588     0.200
     1.586    32.362     0.200
     0.507    12.815     0.200
     0.573    11.363     0.200
     0.573    12.722     0.200
     0.573    11.363     0.200
     0.680    14.489     0.200
     0.958    20.644     0.200
     1.053    21.020     0.200
     1.053    20.559     0.200
     1.028    20.809     0.200
     1.204    23.737     0.200
     1.212    24.828     0.200
     1.286    25.174     0.200
     1.321    26.211     0.200
     1.356    29.578     0.200
     1.606    30.387     0.200
     1.606    30.137     0.200
     1.776    34.396     0.200
     0.551    11.468     0.200
     0.550    11.773     0.200
     0.550    12.179     0.200
     0.726    14.838     0.200
     0.824    17.034     0.200
     0.824    16.550     0.200
     0.949    21.722     0.200
     0.983    21.417     0.200
     1.048    21.381     0.200
     1.232    24.632     0.200
     1.278    24.800     0.200
     1.392    26.805     0.200
     1.610    30.939     0.200
     1.724    33.993     0.200
     0.558    11.438     0.200
     0.558    11.554     0.200
     0.813    16.791     0.200
     0.923    19.850     0.200
     0.923    20.093     0.200
     0.998    21.114     0.200
     1.050    21.122     0.200
     1.050    20.942     0.200
     1.250    24.812     0.200
     1.331    26.229     0.200
     1.411    26.709     0.200
     1.609    30.630     0.200
     3.167    58.520     0.200
     0.566    11.694     0.200
     0.566    11.686     0.200
     0.943    19.741     0.200
     0.951    20.247     0.200
     1.026    21.552     0.200
     1.047    21.084     0.200
     1.281    25.260     0.200
     1.442    27.744     0.200
     1.602    30.072     0.200
     1.063    21.716     0.200
     1.197    23.741     0.200
     1.197    23.561     0.200
     1.279    25.795     0.200
     1.279    25.136     0.200
     1.567    29.324     0.200
     1.567    28.853     0.200
     2.001    36.464     0.200
     2.788    48.375     0.200
     0.514    11.097     0.200
     0.690    14.441     0.200
     0.690    14.561     0.200
     0.708    14.497     0.200
     1.102    22.074     0.200
     1.102    21.934     0.200
     1.222    23.463     0.200
     1.327    26.316     0.200
     1.327    26.996     0.200
     1.326    25.742     0.200
     1.412    28.198     0.200
     1.550    30.748     0.200
     1.614    31.042     0.200
     0.554    11.309     0.200
     0.757    16.158     0.200
     0.678    15.052     0.200
     0.840    17.273     0.200
     0.834    18.199     0.200
     0.845    17.719     0.200
     0.867    18.051     0.200
     0.931    17.967     0.200
     0.991    21.137     0.200
     1.068    20.360     0.200
     1.068    21.024     0.200
     1.179    21.642     0.200
     1.635    29.613     0.200
     0.593    12.745     0.200
     0.642    13.977     0.200
     0.642    13.723     0.200
     0.642    13.293     0.200
     1.013    20.297     0.200
     1.270    24.409     0.200
     1.251    28.248     0.200
     1.251    25.716     0.200
     1.251    25.978     0.200
     1.322    25.812     0.200
     1.466    30.213     0.200
     1.520    28.374     0.200
     2.228    41.665     0.200
     2.291    41.772     0.200
     3.175    56.296     0.200
     0.630    13.847     0.200
     0.630    11.640     0.200
     0.601    12.867     0.200
     1.008    19.877     0.200
     1.242    24.192     0.200
     1.520    27.852     0.200
     0.654    13.906     0.200
     0.653    13.913     0.200
     0.653    13.117     0.200
     1.019    20.092     0.200
     1.280    24.784     0.200
     1.261    23.712     0.200
     1.261    26.071     0.200
     1.382    26.852     0.200
     1.524    27.933     0.200
     3.169    54.747     0.200
     1.039    22.115     0.200
     1.013    20.152     0.200
     1.299    23.955     0.200
     1.260    23.832     0.200
     1.260    26.121     0.200
     1.260    28.050     0.200
     1.450    26.001     0.200
     1.390    25.786     0.200
     1.513    27.050     0.200
     1.513    27.730     0.200
     1.513    26.831     0.200
     0.539    11.639     0.200
     0.682    13.692     0.200
     0.682    13.704     0.200
     0.960    20.034     0.200
     1.099    21.252     0.200
     1.108    22.932     0.200
     1.132    22.984     0.200
     1.128    22.520     0.200
     1.170    22.449     0.200
     1.371    27.517     0.200
     1.495    28.681     0.200
     0.604    12.731     0.200
     0.604    12.993     0.200
     1.026    20.394     0.200
     1.026    20.605     0.200
     1.165    22.987     0.200
     1.229    23.105     0.200
     1.416    26.111     0.200
     1.557    28.380     0.200
     1.816    32.929     0.200
     0.602    13.324     0.200
     0.602    12.942     0.200
     0.603    13.020     0.200
     0.620    13.379     0.200
     0.769    15.647     0.200
     1.064    22.492     0.200
     1.079    21.213     0.200
     1.033    20.365     0.200
     1.033    21.154     0.200
     1.145    23.790     0.200
     1.209    24.111     0.200
     1.229    23.421     0.200
     1.229    25.109     0.200
     1.292    25.394     0.200
     1.408    28.622     0.200
     1.453    26.573     0.200
     1.413    27.543     0.200
     1.567    31.451     0.200
     0.348     7.627     0.200
     0.348     7.885     0.200
     1.228    24.359     0.200
     1.228    25.398     0.200
     1.192    23.633     0.200
     1.192    23.352     0.200
     1.382    27.858     0.200
     0.624    14.366     0.200
     0.601    11.425     0.200
     0.600    13.304     0.200
     0.621    13.591     0.200
     1.065    22.416     0.200
     1.066    22.264     0.200
     1.066    22.385     0.200
     1.030    20.357     0.200
     1.126    23.117     0.200
     1.148    23.162     0.200
     1.210    25.936     0.200
     1.226    23.376     0.200
     1.226    23.865     0.200
     1.410    28.992     0.200
     1.411    27.683     0.200
     1.570    30.861     0.200
     1.563    28.763     0.200
     1.563    31.954     0.200
     1.617    31.510     0.200
     3.801    69.575     0.200
     4.643    81.099     0.200
     0.369     8.302     0.200
     0.369     8.782     0.200
     1.201    23.133     0.200
     1.201    23.833     0.200
     1.201    22.663     0.200
     1.266    23.512     0.200
     1.266    24.252     0.200
     1.365    26.533     0.200
     1.365    27.304     0.200
     1.350    26.636     0.200
     1.638    29.995     0.200
     1.638    33.464     0.200
     1.638    34.134     0.200
     1.572    31.352     0.200
     1.896    33.656     0.200
     0.603    13.106     0.200
     0.618    13.246     0.200
     0.780    15.717     0.200
     1.015    20.634     0.200
     1.225    25.011     0.200
     1.225    25.773     0.200
     1.225    26.722     0.200
     1.242    27.126     0.200
     1.309    26.589     0.200
     1.421    30.835     0.200
     1.541    29.914     0.200
     1.561    31.117     0.200
     0.618    13.081     0.200
     0.618    12.776     0.200
     0.604    13.362     0.200
     0.770    15.904     0.200
     1.238    24.967     0.200
     1.238    27.479     0.200
     1.238    25.260     0.200
     1.325    26.511     0.200
     1.547    30.053     0.200
     1.547    31.713     0.200
     0.602    12.843     0.200
     0.619    13.007     0.200
     0.618    12.996     0.200
     1.088    23.670     0.200
     1.039    20.387     0.200
     1.039    21.086     0.200
     1.090    21.256     0.200
     1.167    23.196     0.200
     1.235    26.373     0.200
     1.243    24.672     0.200
     1.243    27.371     0.200
     1.243    25.222     0.200
     1.314    26.174     0.200
     1.568    29.187     0.200
     1.568    29.718     0.200
     2.550    46.859     0.200
     3.147    58.146     0.200
     0.597    13.168     0.200
     0.624    12.889     0.200
     0.623    12.726     0.200
     0.762    15.570     0.200
     1.032    21.167     0.200
     1.032    20.948     0.200
     1.193    23.102     0.200
     1.245    24.547     0.200
     1.245    25.211     0.200
     1.556    28.400     0.200
     1.556    28.806     0.200
     0.578    12.544     0.200
     0.643    13.015     0.200
     0.643    12.914     0.200
     0.740    15.198     0.200
     1.054    20.809     0.200
     1.054    21.090     0.200
     1.265    25.010     0.200
     1.265    26.529     0.200
     1.342    27.076     0.200
     1.578    32.239     0.200
     1.655    31.794     0.200
     1.925    36.249     0.200
     0.683    14.617     0.200
     0.988    19.919     0.200
     1.167    22.622     0.200
     1.246    22.983     0.200
     1.479    26.597     0.200
     1.479    27.107     0.200
     1.465    28.495     0.200
     1.690    29.778     0.200
     1.690    30.088     0.200
     1.886    33.706     0.200
     0.578    11.633     0.200
     0.578    11.652     0.200
     0.816    17.224     0.200
     0.784    16.020     0.200
     0.978    20.715     0.200
     0.983    18.650     0.200
     0.983    19.509     0.200
     1.001    20.422     0.200
     1.040    21.452     0.200
     1.040    21.331     0.200
     1.064    21.059     0.200
     1.044    20.642     0.200
     1.209    23.697     0.200
     1.209    24.064     0.200
     1.209    25.435     0.200
     1.371    27.130     0.200
     2.037    39.287     0.200
     0.368     9.813     0.200
     0.928    17.668     0.200
     0.928    18.278     0.200
     0.834    16.962     0.200
     0.807    16.722     0.200
     0.821    17.380     0.200
     0.962    17.930     0.200
     0.944    19.670     0.200
     0.951    20.576     0.200
     0.982    19.934     0.200
     0.982    19.824     0.200
     1.059    22.302     0.200
     1.169    23.396     0.200
     1.671    32.987     0.200
     1.752    35.084     0.200
     1.849    36.511     0.200
     1.930    37.524     0.200
     2.085    40.754     0.200
     2.127    40.693     0.200
     2.157    41.972     0.200
     2.174    42.379     0.200
     2.260    43.900     0.200
     2.312    45.100     0.200
     2.319    44.551     0.200
     2.444    46.632     0.200
     3.291    58.915     0.200
     0.802    16.261     0.200
     0.828    16.994     0.200
     0.816    17.125     0.200
     0.928    16.421     0.200
     0.928    17.591     0.200
     0.986    19.744     0.200
     0.986    19.634     0.200
     1.305    23.199     0.200
     1.477    28.344     0.200
     1.542    28.530     0.200
     0.236     5.319     0.200
     0.354     9.519     0.200
     0.565    12.609     0.200
     0.642    12.786     0.200
     0.755    15.510     0.200
     0.945    19.361     0.200
     1.088    21.425     0.200
     1.088    21.194     0.200
     1.351    26.328     0.200
     1.437    27.648     0.200
     1.662    31.243     0.200
     1.689    31.955     0.200
     0.238     5.575     0.200
     0.238     5.594     0.200
     0.967    19.280     0.200
     1.123    21.139     0.200
     1.225    22.836     0.200
     1.334    24.471     0.200
     1.430    27.141     0.200
     1.475    27.824     0.200
     1.929    36.134     0.200
     1.963    35.789     0.200
     0.387     8.784     0.200
     0.473     8.255     0.200
     0.826    17.176     0.200
     0.840    17.798     0.200
     0.849    18.343     0.200
     0.849    17.905     0.200
     0.892    18.316     0.200
     0.971    20.718     0.200
     0.972    18.672     0.200
     0.912    18.359     0.200
     0.912    18.917     0.200
     1.036    21.283     0.200
     0.987    20.394     0.200
     0.987    19.664     0.200
     0.987    20.945     0.200
     1.099    20.454     0.200
     1.230    27.541     0.200
     1.314    24.437     0.200
     1.954    33.789     0.200
     0.651    14.974     0.200
     0.841    17.958     0.200
     0.834    18.152     0.200
     0.884    18.371     0.200
     0.964    18.103     0.200
     0.964    18.634     0.200
     0.956    20.173     0.200
     0.913    18.066     0.200
     0.913    18.644     0.200
     0.964    19.955     0.200
     0.992    20.112     0.200
     0.992    19.323     0.200
     1.075    21.650     0.200
     1.174    22.200     0.200
     1.100    20.580     0.200
     1.100    20.138     0.200
     1.100    22.689     0.200
     1.229    22.077     0.200
     0.497    10.833     0.200
     0.846    17.895     0.200
     0.842    18.931     0.200
     0.891    19.029     0.200
     0.891    19.170     0.200
     0.965    20.433     0.200
     0.965    20.703     0.200
     0.890    17.570     0.200
     1.012    20.745     0.200
     1.094    22.339     0.200
     1.094    24.652     0.200
     1.122    21.004     0.200
     1.122    23.414     0.200
     1.122    23.864     0.200
     1.179    23.403     0.200
     0.533    10.795     0.200
     0.534    11.049     0.200
     0.857    18.548     0.200
     0.857    18.091     0.200
     0.877    18.707     0.200
     0.856    19.194     0.200
     0.850    18.471     0.200
     0.914    18.601     0.200
     1.042    20.621     0.200
     0.991    20.704     0.200
     1.160    22.904     0.200
     1.160    22.635     0.200
     1.160    23.377     0.200
     1.134    22.996     0.200
     1.117    22.756     0.200
     1.279    25.110     0.200
     0.794    16.256     0.200
     0.924    17.920     0.200
     0.924    18.061     0.200
     0.924    18.901     0.200
     0.943    18.897     0.200
     0.997    20.441     0.200
     0.997    19.832     0.200
     1.095    22.927     0.200
     1.095    23.368     0.200
     1.095    24.028     0.200
     1.149    22.590     0.200
     1.216    22.736     0.200
     1.216    23.244     0.200
     1.216    22.584     0.200
     1.306    24.544     0.200
     1.292    25.557     0.200
     0.489    10.299     0.200
     0.817    17.055     0.200
     0.833    17.834     0.200
     0.902    16.086     0.200
     0.902    16.914     0.200
     0.902    18.535     0.200
     0.952    18.848     0.200
     1.007    20.398     0.200
     1.007    19.800     0.200
     1.113    21.640     0.200
     1.113    23.742     0.200
     1.292    23.969     0.200
     1.433    25.908     0.200
     1.483    26.306     0.200
     1.947    39.615     0.200
     0.762    16.011     0.200
     0.696    14.659     0.200
     1.197    25.148     0.200
     1.197    24.570     0.200
     1.071    21.940     0.200
     1.071    22.811     0.200
     1.264    25.605     0.200
     1.387    29.309     0.200
     1.308    25.956     0.200
     1.308    27.065     0.200
     1.415    27.733     0.200
     1.415    27.882     0.200
     1.519    32.256     0.200
     2.337    43.065     0.200
     0.953    21.414     0.200
     0.725    14.478     0.200
     1.167    22.919     0.200
     1.514    30.370     0.200
     1.598    33.370     0.200
     1.564    30.231     0.200
     1.845    35.747     0.200
     0.620    12.875     0.200
     1.018    23.102     0.200
     1.018    20.182     0.200
     1.032    20.198     0.200
     1.039    21.876     0.200
     1.092    21.842     0.200
     1.072    21.126     0.200
     1.072    21.756     0.200
     1.072    20.666     0.200
     1.086    22.089     0.200
     1.250    24.972     0.200
     1.250    25.742     0.200
     1.250    26.043     0.200
     1.250    24.202     0.200
     1.286    26.116     0.200
     0.619    12.045     0.200
     1.075    20.778     0.200
     1.075    21.839     0.200
     1.005    22.754     0.200
     1.040    21.857     0.200
     1.079    21.457     0.200
     1.250    24.537     0.200
     1.250    26.606     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
