#!/bin/bash
gmt begin penasco2.16_tt5s_local_DOCTX pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance penasco2.16'
# Station code
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.200   110.000 Single station: DOCTX
EOF
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    10.947
     0.600    12.367
     0.700    13.786
     0.800    15.206
     0.900    16.626
     1.000    18.046
     1.100    19.466
     1.200    20.885
     1.300    22.305
     1.400    23.725
     1.500    25.145
     1.600    26.565
     1.700    27.984
     1.800    29.404
     1.900    30.824
     2.000    32.244
     2.100    33.664
     2.200    35.083
     2.300    36.503
     2.400    37.923
     2.500    39.343
     2.600    40.763
     2.700    42.182
     2.800    43.602
     2.900    45.022
     3.000    46.442
     3.100    47.862
     3.200    49.282
     3.300    50.701
     3.400    52.121
     3.500    53.541
     3.600    54.961
     3.700    56.380
     3.800    57.800
     3.900    59.219
     4.000    60.638
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    52.961 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.753
     0.200     4.311
     0.300     6.077
     0.400     7.913
     0.500     9.779
     0.600    11.661
     0.700    13.395
     0.800    15.101
     0.900    16.808
     1.000    18.515
     1.100    20.221
     1.200    21.928
     1.300    23.634
     1.400    25.341
     1.500    27.048
     1.600    28.754
     1.700    30.461
     1.800    32.167
     1.900    33.874
     2.000    35.580
     2.100    37.287
     2.200    38.993
     2.300    40.700
     2.400    42.406
     2.500    44.113
     2.600    45.819
     2.700    47.525
     2.800    49.231
     2.900    50.938
     3.000    52.644
     3.100    54.350
     3.200    56.056
     3.300    57.762
     3.400    59.468
     3.500    61.174
     3.600    62.880
     3.700    64.586
     3.800    66.292
     3.900    67.998
     4.000    69.704
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    61.880 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    18.970
     0.600    21.442
     0.700    23.913
     0.800    26.385
     0.900    28.857
     1.000    31.329
     1.100    33.801
     1.200    36.273
     1.300    38.745
     1.400    41.217
     1.500    43.689
     1.600    46.161
     1.700    48.632
     1.800    51.104
     1.900    53.576
     2.000    56.048
     2.100    58.520
     2.200    60.992
     2.300    63.464
     2.400    65.936
     2.500    68.408
     2.600    70.880
     2.700    73.351
     2.800    75.823
     2.900    78.295
     3.000    80.767
     3.100    83.239
     3.200    85.711
     3.300    88.182
     3.400    90.653
     3.500    93.124
     3.600    95.595
     3.700    98.065
     3.800   100.535
     3.900   103.006
     4.000   105.476
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    93.595 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.766
     0.200     7.464
     0.300    10.521
     0.400    13.700
     0.500    16.931
     0.600    20.190
     0.700    23.203
     0.800    26.161
     0.900    29.119
     1.000    32.078
     1.100    35.036
     1.200    37.994
     1.300    40.952
     1.400    43.910
     1.500    46.868
     1.600    49.826
     1.700    52.784
     1.800    55.743
     1.900    58.701
     2.000    61.659
     2.100    64.616
     2.200    67.574
     2.300    70.532
     2.400    73.490
     2.500    76.448
     2.600    79.405
     2.700    82.363
     2.800    85.321
     2.900    88.279
     3.000    91.236
     3.100    94.193
     3.200    97.150
     3.300   100.107
     3.400   103.065
     3.500   106.022
     3.600   108.979
     3.700   111.935
     3.800   114.892
     3.900   117.849
     4.000   120.806
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   107.979 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.600    13.694
     0.700    15.114
     0.800    16.534
     0.900    17.953
     1.000    19.373
     1.100    20.793
     1.200    22.213
     1.300    23.633
     1.400    25.052
     1.500    26.472
     1.600    27.892
     1.700    29.312
     1.800    30.731
     1.900    32.151
     2.000    33.571
     2.100    34.991
     2.200    36.411
     2.300    37.830
     2.400    39.250
     2.500    40.670
     2.600    42.090
     2.700    43.510
     2.800    44.929
     2.900    46.349
     3.000    47.769
     3.100    49.189
     3.200    50.609
     3.300    52.028
     3.400    53.448
     3.500    54.868
     3.600    56.288
     3.700    57.708
     3.800    59.127
     3.900    60.547
     4.000    61.966
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.917
     0.200     3.834
     0.300     5.751
     0.400     7.668
     0.500     9.585
     0.600    11.503
     0.700    13.420
     0.800    15.337
     0.900    17.254
     1.000    19.171
     1.100    21.088
     1.200    22.825
     1.300    24.532
     1.400    26.238
     1.500    27.945
     1.600    29.652
     1.700    31.358
     1.800    33.065
     1.900    34.772
     2.000    36.478
     2.100    38.185
     2.200    39.891
     2.300    41.598
     2.400    43.304
     2.500    45.010
     2.600    46.717
     2.700    48.423
     2.800    50.130
     2.900    51.836
     3.000    53.542
     3.100    55.249
     3.200    56.955
     3.300    58.661
     3.400    60.367
     3.500    62.073
     3.600    63.779
     3.700    65.485
     3.800    67.191
     3.900    68.897
     4.000    70.603
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.600    23.724
     0.700    26.195
     0.800    28.667
     0.900    31.139
     1.000    33.611
     1.100    36.083
     1.200    38.555
     1.300    41.027
     1.400    43.499
     1.500    45.970
     1.600    48.442
     1.700    50.914
     1.800    53.386
     1.900    55.858
     2.000    58.330
     2.100    60.802
     2.200    63.274
     2.300    65.746
     2.400    68.217
     2.500    70.689
     2.600    73.161
     2.700    75.633
     2.800    78.105
     2.900    80.577
     3.000    83.049
     3.100    85.521
     3.200    87.992
     3.300    90.464
     3.400    92.936
     3.500    95.407
     3.600    97.878
     3.700   100.348
     3.800   102.819
     3.900   105.289
     4.000   107.760
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.319
     0.200     6.638
     0.300     9.957
     0.400    13.277
     0.500    16.596
     0.600    19.915
     0.700    23.234
     0.800    26.553
     0.900    29.872
     1.000    33.191
     1.100    36.511
     1.200    39.541
     1.300    42.499
     1.400    45.458
     1.500    48.416
     1.600    51.374
     1.700    54.332
     1.800    57.290
     1.900    60.248
     2.000    63.206
     2.100    66.164
     2.200    69.122
     2.300    72.080
     2.400    75.038
     2.500    77.996
     2.600    80.953
     2.700    83.911
     2.800    86.869
     2.900    89.826
     3.000    92.784
     3.100    95.742
     3.200    98.699
     3.300   101.657
     3.400   104.614
     3.500   107.571
     3.600   110.528
     3.700   113.486
     3.800   116.442
     3.900   119.399
     4.000   122.356
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100     4.847
     0.200     5.736
     0.300     6.949
     0.400     8.308
     0.500     9.710
     0.600    11.122
     0.700    12.538
     0.800    13.955
     0.900    15.373
     1.000    16.791
     1.100    18.210
     1.200    19.629
     1.300    21.048
     1.400    22.467
     1.500    23.887
     1.600    25.306
     1.700    26.725
     1.800    28.145
     1.900    29.564
     2.000    30.983
     2.100    32.402
     2.200    33.821
     2.300    35.241
     2.400    36.660
     2.500    38.079
     2.600    39.498
     2.700    40.917
     2.800    42.336
     2.900    43.755
     3.000    45.174
     3.100    46.594
     3.200    48.013
     3.300    49.432
     3.400    50.851
     3.500    52.270
     3.600    53.689
     3.700    55.108
     3.800    56.527
     3.900    57.947
     4.000    59.366
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100     8.399
     0.200     9.941
     0.300    12.047
     0.400    14.408
     0.500    16.847
     0.600    19.305
     0.700    21.770
     0.800    24.237
     0.900    26.706
     1.000    29.175
     1.100    31.645
     1.200    34.115
     1.300    36.586
     1.400    39.056
     1.500    41.527
     1.600    43.997
     1.700    46.468
     1.800    48.939
     1.900    51.410
     2.000    53.880
     2.100    56.351
     2.200    58.821
     2.300    61.291
     2.400    63.762
     2.500    66.232
     2.600    68.703
     2.700    71.173
     2.800    73.643
     2.900    76.114
     3.000    78.584
     3.100    81.054
     3.200    83.525
     3.300    85.995
     3.400    88.466
     3.500    90.936
     3.600    93.406
     3.700    95.877
     3.800    98.347
     3.900   100.816
     4.000   103.285
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.560    11.479     0.200
     0.475     9.954     0.200
     0.460    10.495     0.200
     0.560    11.963     0.200
     0.528    11.074     0.200
     0.528    10.844     0.200
     0.507    10.266     0.200
     0.769    15.500     0.200
     0.685    13.789     0.200
     0.640    12.465     0.200
     0.624    12.965     0.200
     0.648    12.844     0.200
     0.541    11.535     0.200
     0.368     7.819     0.200
     0.363     7.796     0.200
     0.354     7.688     0.200
     0.330     7.852     0.200
     0.387     8.355     0.200
     0.415     9.488     0.200
     0.354     7.207     0.200
     0.376     8.117     0.200
     0.589    11.322     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.560    19.938     0.200
     0.475    17.444     0.200
     0.560    20.393     0.200
     0.769    25.070     0.200
     0.685    23.859     0.200
     0.363    14.066     0.200
     0.415    15.488     0.200
     0.376    14.586     0.200
     0.589    21.643     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.387    13.297     0.200
     0.762    24.902     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.387    13.297     0.200
     0.762    24.902     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
