#!/bin/bash
gmt begin penasco2.16_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance penasco2.16'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    10.947
     0.600    12.367
     0.700    13.786
     0.800    15.206
     0.900    16.626
     1.000    18.046
     1.100    19.466
     1.200    20.885
     1.300    22.305
     1.400    23.725
     1.500    25.145
     1.600    26.565
     1.700    27.984
     1.800    29.404
     1.900    30.824
     2.000    32.244
     2.100    33.664
     2.200    35.083
     2.300    36.503
     2.400    37.923
     2.500    39.343
     2.600    40.763
     2.700    42.182
     2.800    43.602
     2.900    45.022
     3.000    46.442
     3.100    47.862
     3.200    49.282
     3.300    50.701
     3.400    52.121
     3.500    53.541
     3.600    54.961
     3.700    56.380
     3.800    57.800
     3.900    59.219
     4.000    60.638
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    52.961 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.753
     0.200     4.311
     0.300     6.077
     0.400     7.913
     0.500     9.779
     0.600    11.661
     0.700    13.395
     0.800    15.101
     0.900    16.808
     1.000    18.515
     1.100    20.221
     1.200    21.928
     1.300    23.634
     1.400    25.341
     1.500    27.048
     1.600    28.754
     1.700    30.461
     1.800    32.167
     1.900    33.874
     2.000    35.580
     2.100    37.287
     2.200    38.993
     2.300    40.700
     2.400    42.406
     2.500    44.113
     2.600    45.819
     2.700    47.525
     2.800    49.231
     2.900    50.938
     3.000    52.644
     3.100    54.350
     3.200    56.056
     3.300    57.762
     3.400    59.468
     3.500    61.174
     3.600    62.880
     3.700    64.586
     3.800    66.292
     3.900    67.998
     4.000    69.704
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    61.880 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    18.970
     0.600    21.442
     0.700    23.913
     0.800    26.385
     0.900    28.857
     1.000    31.329
     1.100    33.801
     1.200    36.273
     1.300    38.745
     1.400    41.217
     1.500    43.689
     1.600    46.161
     1.700    48.632
     1.800    51.104
     1.900    53.576
     2.000    56.048
     2.100    58.520
     2.200    60.992
     2.300    63.464
     2.400    65.936
     2.500    68.408
     2.600    70.880
     2.700    73.351
     2.800    75.823
     2.900    78.295
     3.000    80.767
     3.100    83.239
     3.200    85.711
     3.300    88.182
     3.400    90.653
     3.500    93.124
     3.600    95.595
     3.700    98.065
     3.800   100.535
     3.900   103.006
     4.000   105.476
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    93.595 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.766
     0.200     7.464
     0.300    10.521
     0.400    13.700
     0.500    16.931
     0.600    20.190
     0.700    23.203
     0.800    26.161
     0.900    29.119
     1.000    32.078
     1.100    35.036
     1.200    37.994
     1.300    40.952
     1.400    43.910
     1.500    46.868
     1.600    49.826
     1.700    52.784
     1.800    55.743
     1.900    58.701
     2.000    61.659
     2.100    64.616
     2.200    67.574
     2.300    70.532
     2.400    73.490
     2.500    76.448
     2.600    79.405
     2.700    82.363
     2.800    85.321
     2.900    88.279
     3.000    91.236
     3.100    94.193
     3.200    97.150
     3.300   100.107
     3.400   103.065
     3.500   106.022
     3.600   108.979
     3.700   111.935
     3.800   114.892
     3.900   117.849
     4.000   120.806
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   107.979 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.600    13.694
     0.700    15.114
     0.800    16.534
     0.900    17.953
     1.000    19.373
     1.100    20.793
     1.200    22.213
     1.300    23.633
     1.400    25.052
     1.500    26.472
     1.600    27.892
     1.700    29.312
     1.800    30.731
     1.900    32.151
     2.000    33.571
     2.100    34.991
     2.200    36.411
     2.300    37.830
     2.400    39.250
     2.500    40.670
     2.600    42.090
     2.700    43.510
     2.800    44.929
     2.900    46.349
     3.000    47.769
     3.100    49.189
     3.200    50.609
     3.300    52.028
     3.400    53.448
     3.500    54.868
     3.600    56.288
     3.700    57.708
     3.800    59.127
     3.900    60.547
     4.000    61.966
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.917
     0.200     3.834
     0.300     5.751
     0.400     7.668
     0.500     9.585
     0.600    11.503
     0.700    13.420
     0.800    15.337
     0.900    17.254
     1.000    19.171
     1.100    21.088
     1.200    22.825
     1.300    24.532
     1.400    26.238
     1.500    27.945
     1.600    29.652
     1.700    31.358
     1.800    33.065
     1.900    34.772
     2.000    36.478
     2.100    38.185
     2.200    39.891
     2.300    41.598
     2.400    43.304
     2.500    45.010
     2.600    46.717
     2.700    48.423
     2.800    50.130
     2.900    51.836
     3.000    53.542
     3.100    55.249
     3.200    56.955
     3.300    58.661
     3.400    60.367
     3.500    62.073
     3.600    63.779
     3.700    65.485
     3.800    67.191
     3.900    68.897
     4.000    70.603
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.600    23.724
     0.700    26.195
     0.800    28.667
     0.900    31.139
     1.000    33.611
     1.100    36.083
     1.200    38.555
     1.300    41.027
     1.400    43.499
     1.500    45.970
     1.600    48.442
     1.700    50.914
     1.800    53.386
     1.900    55.858
     2.000    58.330
     2.100    60.802
     2.200    63.274
     2.300    65.746
     2.400    68.217
     2.500    70.689
     2.600    73.161
     2.700    75.633
     2.800    78.105
     2.900    80.577
     3.000    83.049
     3.100    85.521
     3.200    87.992
     3.300    90.464
     3.400    92.936
     3.500    95.407
     3.600    97.878
     3.700   100.348
     3.800   102.819
     3.900   105.289
     4.000   107.760
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.319
     0.200     6.638
     0.300     9.957
     0.400    13.277
     0.500    16.596
     0.600    19.915
     0.700    23.234
     0.800    26.553
     0.900    29.872
     1.000    33.191
     1.100    36.511
     1.200    39.541
     1.300    42.499
     1.400    45.458
     1.500    48.416
     1.600    51.374
     1.700    54.332
     1.800    57.290
     1.900    60.248
     2.000    63.206
     2.100    66.164
     2.200    69.122
     2.300    72.080
     2.400    75.038
     2.500    77.996
     2.600    80.953
     2.700    83.911
     2.800    86.869
     2.900    89.826
     3.000    92.784
     3.100    95.742
     3.200    98.699
     3.300   101.657
     3.400   104.614
     3.500   107.571
     3.600   110.528
     3.700   113.486
     3.800   116.442
     3.900   119.399
     4.000   122.356
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100     4.847
     0.200     5.736
     0.300     6.949
     0.400     8.308
     0.500     9.710
     0.600    11.122
     0.700    12.538
     0.800    13.955
     0.900    15.373
     1.000    16.791
     1.100    18.210
     1.200    19.629
     1.300    21.048
     1.400    22.467
     1.500    23.887
     1.600    25.306
     1.700    26.725
     1.800    28.145
     1.900    29.564
     2.000    30.983
     2.100    32.402
     2.200    33.821
     2.300    35.241
     2.400    36.660
     2.500    38.079
     2.600    39.498
     2.700    40.917
     2.800    42.336
     2.900    43.755
     3.000    45.174
     3.100    46.594
     3.200    48.013
     3.300    49.432
     3.400    50.851
     3.500    52.270
     3.600    53.689
     3.700    55.108
     3.800    56.527
     3.900    57.947
     4.000    59.366
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100     8.399
     0.200     9.941
     0.300    12.047
     0.400    14.408
     0.500    16.847
     0.600    19.305
     0.700    21.770
     0.800    24.237
     0.900    26.706
     1.000    29.175
     1.100    31.645
     1.200    34.115
     1.300    36.586
     1.400    39.056
     1.500    41.527
     1.600    43.997
     1.700    46.468
     1.800    48.939
     1.900    51.410
     2.000    53.880
     2.100    56.351
     2.200    58.821
     2.300    61.291
     2.400    63.762
     2.500    66.232
     2.600    68.703
     2.700    71.173
     2.800    73.643
     2.900    76.114
     3.000    78.584
     3.100    81.054
     3.200    83.525
     3.300    85.995
     3.400    88.466
     3.500    90.936
     3.600    93.406
     3.700    95.877
     3.800    98.347
     3.900   100.816
     4.000   103.285
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
     3.067   831.907     0.150
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.009    18.590     0.200
     1.379    23.900     0.200
     1.596    27.580     0.200
     1.801    29.700     0.200
     1.962    32.340     0.200
     2.087    34.630     0.200
     2.207    37.403     0.200
     2.238    37.659     0.200
     2.367    39.469     0.200
     2.679    41.998     0.200
     2.711    44.497     0.200
     3.131    49.954     0.200
     3.231    52.092     0.200
     3.499    55.983     0.200
     3.873    60.684     0.200
     0.901    15.773     0.200
     1.368    24.586     0.200
     1.333    23.914     0.200
     1.581    26.992     0.200
     1.879    30.055     0.200
     2.140    35.383     0.200
     2.179    36.039     0.200
     2.228    36.336     0.200
     2.235    35.117     0.200
     2.325    38.117     0.200
     2.327    37.445     0.200
     2.498    40.328     0.200
     2.658    42.961     0.200
     2.715    42.266     0.200
     2.715    43.023     0.200
     2.841    44.828     0.200
     2.954    46.859     0.200
     3.012    47.383     0.200
     3.092    49.062     0.200
     3.180    49.836     0.200
     3.228    50.484     0.200
     3.246    50.156     0.200
     3.442    53.383     0.200
     3.438    52.945     0.200
     3.587    55.445     0.200
     3.681    56.484     0.200
     3.657    56.828     0.200
     3.712    57.172     0.200
     3.700    56.297     0.200
     3.869    59.273     0.200
     4.299    65.562     0.200
     4.445    67.766     0.200
     1.073    19.680     0.200
     1.368    24.805     0.200
     1.398    25.395     0.200
     1.666    28.711     0.200
     1.974    35.832     0.200
     1.953    31.762     0.200
     2.060    35.832     0.200
     2.092    37.531     0.200
     2.309    37.508     0.200
     2.363    37.910     0.200
     2.161    36.449     0.200
     2.232    37.125     0.200
     2.310    37.922     0.200
     2.413    39.434     0.200
     2.399    39.336     0.200
     2.472    40.359     0.200
     2.486    40.242     0.200
     2.830    48.441     0.200
     2.718    43.871     0.200
     2.800    44.801     0.200
     2.926    46.184     0.200
     2.990    47.582     0.200
     3.004    47.652     0.200
     3.113    48.789     0.200
     3.168    50.594     0.200
     3.243    51.965     0.200
     3.227    50.707     0.200
     3.402    53.320     0.200
     3.497    55.246     0.200
     3.664    57.473     0.200
     3.663    57.102     0.200
     3.683    57.234     0.200
     3.819    59.883     0.200
     3.866    59.711     0.200
     3.896    61.535     0.200
     4.097    64.875     0.200
     4.299    67.027     0.200
     4.384    67.211     0.200
     4.291    65.902     0.200
     4.298    68.035     0.200
     4.318    67.996     0.200
     4.331    65.980     0.200
     4.407    69.012     0.200
     4.441    67.402     0.200
     4.642    71.820     0.200
     4.712    73.961     0.200
     4.710    73.445     0.200
     4.779    73.371     0.200
     4.969    76.996     0.200
     4.982    76.410     0.200
     5.050    78.324     0.200
     5.246    81.344     0.200
     5.296    81.344     0.200
     5.506    84.270     0.200
     5.574    85.215     0.200
     5.604    86.246     0.200
     5.785    89.035     0.200
     5.835    89.340     0.200
     5.993    91.984     0.200
     6.135    93.184     0.200
     6.169    93.723     0.200
     6.114    93.020     0.200
     6.181    94.602     0.200
     6.251    96.254     0.200
     6.650   101.504     0.200
     6.819   103.988     0.200
     6.844   103.012     0.200
     6.972   104.922     0.200
     6.928   105.176     0.200
     7.491   112.328     0.200
     7.558   113.844     0.200
     7.815   118.418     0.200
     1.084    19.973     0.200
     1.356    24.879     0.200
     1.392    25.418     0.200
     1.668    28.770     0.200
     1.986    36.375     0.200
     1.961    32.637     0.200
     2.103    37.914     0.200
     2.150    36.461     0.200
     2.224    37.355     0.200
     2.309    38.355     0.200
     2.416    39.574     0.200
     2.395    39.770     0.200
     2.460    40.332     0.200
     2.473    40.273     0.200
     2.575    42.168     0.200
     2.712    44.125     0.200
     2.802    45.004     0.200
     2.978    47.309     0.200
     2.996    48.090     0.200
     3.216    50.508     0.200
     3.237    51.602     0.200
     3.392    53.453     0.200
     3.661    57.508     0.200
     3.651    57.031     0.200
     3.671    57.129     0.200
     3.810    59.762     0.200
     3.854    59.496     0.200
     3.892    61.059     0.200
     3.954    61.723     0.200
     4.091    64.430     0.200
     4.110    64.641     0.200
     4.279    65.754     0.200
     4.294    67.488     0.200
     4.311    67.664     0.200
     4.405    68.730     0.200
     4.429    67.570     0.200
     4.706    73.910     0.200
     4.701    73.465     0.200
     4.735    73.578     0.200
     4.768    73.137     0.200
     4.966    76.570     0.200
     4.980    76.641     0.200
     4.926    75.777     0.200
     5.046    78.598     0.200
     5.241    81.570     0.200
     5.286    81.504     0.200
     5.373    83.316     0.200
     5.571    85.453     0.200
     5.595    85.867     0.200
     5.692    87.602     0.200
     5.780    89.227     0.200
     5.835    89.551     0.200
     5.987    92.109     0.200
     6.133    95.086     0.200
     6.104    93.109     0.200
     6.172    94.676     0.200
     6.245    96.199     0.200
     6.644   101.512     0.200
     6.833   102.965     0.200
     1.094    20.000     0.200
     1.370    25.338     0.200
     1.646    28.859     0.200
     1.347    24.787     0.200
     2.286    38.375     0.200
     2.204    37.234     0.200
     2.372    39.561     0.200
     2.780    44.783     0.200
     2.449    40.463     0.200
     2.467    40.270     0.200
     2.557    42.418     0.200
     2.690    44.113     0.200
     2.976    47.764     0.200
     3.141    50.709     0.200
     2.975    47.895     0.200
     3.215    52.260     0.200
     3.207    51.066     0.200
     3.375    53.766     0.200
     3.468    55.578     0.200
     3.657    57.080     0.200
     3.647    57.014     0.200
     3.869    61.402     0.200
     3.791    59.713     0.200
     3.670    57.455     0.200
     3.846    60.098     0.200
     3.944    61.764     0.200
     4.093    64.209     0.200
     4.271    67.652     0.200
     4.381    69.266     0.200
     4.290    67.562     0.200
     4.278    66.258     0.200
     4.684    73.750     0.200
     4.682    73.037     0.200
     4.715    73.494     0.200
     4.753    73.908     0.200
     4.957    76.875     0.200
     4.943    76.838     0.200
     5.023    78.377     0.200
     5.269    81.730     0.200
     5.352    83.273     0.200
     5.548    85.824     0.200
     5.479    84.418     0.200
     5.577    85.979     0.200
     5.812    89.684     0.200
     5.757    89.264     0.200
     6.087    92.959     0.200
     6.153    94.680     0.200
     6.223    96.473     0.200
     1.314    22.109     0.200
     1.567    26.273     0.200
     1.699    27.594     0.200
     1.839    30.711     0.200
     1.951    32.164     0.200
     2.011    32.891     0.200
     7.039   104.273     0.200
     7.428   109.023     0.200
     8.139   119.055     0.200
     9.127   134.750     0.200
     9.573   140.688     0.200
    11.783   171.867     0.200
     1.117    20.266     0.200
     1.352    23.312     0.200
     1.280    23.500     0.200
     1.600    26.766     0.200
     1.488    26.336     0.200
     1.874    30.570     0.200
     2.049    33.742     0.200
     2.141    35.375     0.200
     2.143    35.852     0.200
     2.205    35.211     0.200
     2.143    35.680     0.200
     2.230    36.672     0.200
     2.625    41.922     0.200
     2.609    42.289     0.200
     2.651    44.141     0.200
     2.623    42.320     0.200
     2.743    44.055     0.200
     3.161    50.336     0.200
     3.343    52.281     0.200
     3.602    55.859     0.200
     3.750    58.758     0.200
     3.836    57.906     0.200
     4.028    61.664     0.200
     4.380    67.312     0.200
     4.200    64.359     0.200
     4.200    64.531     0.200
     4.650    72.180     0.200
     4.930    75.922     0.200
     5.121    79.547     0.200
     5.246    79.930     0.200
     5.363    80.141     0.200
     5.692    85.375     0.200
     5.692    85.859     0.200
     5.994    91.656     0.200
     6.220    94.219     0.200
     6.500    96.828     0.200
     6.799   101.852     0.200
     6.799   102.242     0.200
     6.860   101.102     0.200
     7.420   110.992     0.200
     7.690   111.117     0.200
     8.136   121.688     0.200
     1.783    30.163     0.200
     1.962    32.213     0.200
     2.477    38.638     0.200
     2.477    39.232     0.200
     3.484    52.973     0.200
     3.826    57.343     0.200
     3.871    58.463     0.200
     4.166    62.553     0.200
     4.077    64.203     0.200
     4.496    67.933     0.200
     4.813    70.953     0.200
     4.907    75.152     0.200
     5.111    76.493     0.200
     5.234    75.913     0.200
     5.936    87.812     0.200
     5.977    89.263     0.200
     6.045    88.923     0.200
     6.970   104.133     0.200
     7.414   111.062     0.200
     7.610   113.013     0.200
     7.697   112.524     0.200
     7.697   112.152     0.200
     7.979   117.423     0.200
     9.136   134.164     0.200
     9.819   143.888     0.200
    11.960   175.241     0.200
    16.744   236.620     0.200
     1.599    26.414     0.200
     1.599    26.264     0.200
     1.601    26.324     0.200
     1.744    26.713     0.200
     2.424    38.564     0.200
     2.534    39.314     0.200
     2.653    41.725     0.200
     2.694    41.123     0.200
     2.942    45.703     0.200
     3.077    47.475     0.200
     3.194    48.814     0.200
     3.194    48.445     0.200
     3.210    48.135     0.200
     3.221    49.053     0.200
     3.343    49.625     0.200
     3.505    53.174     0.200
     3.553    53.381     0.200
     3.898    58.217     0.200
     4.185    62.014     0.200
     4.185    61.814     0.200
     4.376    65.160     0.200
     4.502    66.465     0.200
     4.841    70.658     0.200
     4.939    73.256     0.200
     5.176    76.186     0.200
     5.244    77.164     0.200
     5.248    76.902     0.200
     5.431    80.213     0.200
     5.457    80.293     0.200
     5.599    81.592     0.200
     5.830    86.914     0.200
     5.830    85.684     0.200
     5.909    86.893     0.200
     5.929    87.426     0.200
     6.082    90.592     0.200
     6.079    89.936     0.200
     6.079    91.043     0.200
     6.067    89.613     0.200
     6.185    90.598     0.200
     6.304    92.156     0.200
     6.412    95.664     0.200
     6.527    94.904     0.200
     6.532    96.633     0.200
     6.643    98.713     0.200
     6.746    97.814     0.200
     6.721   100.283     0.200
     6.795   100.197     0.200
     6.930   100.504     0.200
     6.980   103.814     0.200
     7.189   107.213     0.200
     7.225   106.002     0.200
     7.244   107.713     0.200
     7.244   106.365     0.200
     7.236   107.074     0.200
     7.331   109.203     0.200
     7.302   106.740     0.200
     7.301   107.078     0.200
     7.444   109.984     0.200
     7.463   109.154     0.200
     7.566   112.135     0.200
     7.663   113.953     0.200
     7.679   111.725     0.200
     7.762   112.994     0.200
     7.770   113.049     0.200
     7.770   113.514     0.200
     7.894   116.713     0.200
     8.067   120.844     0.200
     8.245   122.004     0.200
     8.235   119.064     0.200
     8.235   120.213     0.200
     8.289   124.645     0.200
     8.512   124.670     0.200
     8.512   124.824     0.200
     8.634   127.242     0.200
     8.617   128.293     0.200
     8.676   127.873     0.200
     8.692   126.707     0.200
     8.692   127.434     0.200
     8.750   130.414     0.200
     9.173   137.434     0.200
     9.173   135.738     0.200
     9.160   130.664     0.200
     9.180   137.414     0.200
     9.437   137.764     0.200
     9.464   139.744     0.200
     9.538   140.773     0.200
     9.616   140.814     0.200
     9.670   142.414     0.200
     9.688   144.053     0.200
     9.924   143.838     0.200
     9.924   144.463     0.200
     9.960   147.943     0.200
    10.180   150.404     0.200
    10.179   146.396     0.200
    10.228   150.613     0.200
    10.334   154.014     0.200
    10.334   150.512     0.200
    10.362   149.797     0.200
    10.363   149.207     0.200
    10.499   151.779     0.200
    10.499   154.123     0.200
    10.601   153.109     0.200
    10.613   152.791     0.200
    10.637   153.852     0.200
    10.637   155.674     0.200
    10.641   153.145     0.200
    10.758   159.213     0.200
    10.802   158.814     0.200
    10.813   155.408     0.200
    10.881   157.904     0.200
    10.881   159.934     0.200
    10.876   156.311     0.200
    10.892   156.752     0.200
    10.950   162.395     0.200
    10.991   160.213     0.200
    11.043   163.193     0.200
    11.074   160.934     0.200
    11.173   164.303     0.200
    11.126   159.764     0.200
    11.137   160.150     0.200
    11.145   160.525     0.200
    11.178   160.861     0.200
    11.210   160.799     0.200
    11.307   163.488     0.200
    11.307   164.674     0.200
    11.293   161.939     0.200
    11.334   162.781     0.200
    11.419   168.725     0.200
    11.392   163.438     0.200
    11.420   165.230     0.200
    11.416   164.041     0.200
    11.472   168.984     0.200
    11.495   166.023     0.200
    11.515   166.156     0.200
    11.616   167.318     0.200
    11.617   166.918     0.200
    11.622   167.400     0.200
    11.666   167.895     0.200
    11.666   169.074     0.200
    11.709   169.969     0.200
    11.750   169.033     0.200
    11.767   170.875     0.200
    11.781   169.609     0.200
    11.824   174.424     0.200
    11.811   169.734     0.200
    11.836   169.957     0.200
    11.874   174.543     0.200
    11.911   174.713     0.200
    11.927   175.934     0.200
    11.912   172.166     0.200
    11.927   172.834     0.200
    11.925   171.566     0.200
    11.956   172.129     0.200
    12.104   176.281     0.200
    12.070   173.438     0.200
    12.116   176.914     0.200
    12.116   176.395     0.200
    12.109   174.383     0.200
    12.141   174.824     0.200
    12.167   176.064     0.200
    12.183   175.914     0.200
    12.208   177.717     0.200
    12.267   180.664     0.200
    12.367   177.951     0.200
    12.367   177.828     0.200
    12.449   181.504     0.200
    12.491   181.145     0.200
    12.433   178.461     0.200
    12.446   178.277     0.200
    12.448   178.811     0.200
    12.453   179.246     0.200
    12.489   179.520     0.200
    12.512   179.932     0.200
    12.514   180.096     0.200
    12.520   180.182     0.200
    12.576   182.934     0.200
    12.594   181.953     0.200
    12.657   183.713     0.200
    12.618   182.248     0.200
    12.623   181.465     0.200
    12.632   181.719     0.200
    12.723   182.246     0.200
    12.723   182.574     0.200
    12.752   182.887     0.200
    12.765   183.543     0.200
    12.853   185.338     0.200
    12.919   187.975     0.200
    12.901   184.809     0.200
    12.964   188.453     0.200
    12.946   185.814     0.200
    13.018   189.514     0.200
    12.976   186.232     0.200
    13.051   188.729     0.200
    13.016   186.320     0.200
    13.037   186.719     0.200
    13.046   187.088     0.200
    13.077   191.184     0.200
    13.056   186.980     0.200
    13.110   189.273     0.200
    13.104   188.000     0.200
    13.106   187.646     0.200
    13.123   188.256     0.200
    13.156   190.174     0.200
    13.156   191.213     0.200
    13.158   188.881     0.200
    13.159   188.270     0.200
    13.275   193.764     0.200
    13.249   190.203     0.200
    13.265   189.498     0.200
    13.276   189.758     0.200
    13.304   190.484     0.200
    13.328   190.492     0.200
    13.384   194.854     0.200
    13.367   192.803     0.200
    13.367   194.164     0.200
    13.435   195.154     0.200
    13.396   193.953     0.200
    13.392   192.082     0.200
    13.391   192.074     0.200
    13.458   194.908     0.200
    13.431   192.129     0.200
    13.557   197.023     0.200
    13.542   195.113     0.200
    13.559   193.801     0.200
    13.610   196.029     0.200
    13.641   198.123     0.200
    13.641   198.773     0.200
    13.610   194.148     0.200
    13.618   194.475     0.200
    13.626   194.340     0.200
    13.682   197.705     0.200
    13.682   198.414     0.200
    13.657   195.545     0.200
    13.669   196.129     0.200
    13.699   199.453     0.200
    13.728   196.213     0.200
    13.760   196.551     0.200
    13.764   196.121     0.200
    13.770   197.078     0.200
    13.783   196.527     0.200
    13.811   199.654     0.200
    13.798   196.719     0.200
    13.819   197.246     0.200
    13.868   201.033     0.200
    13.895   202.113     0.200
    13.877   198.213     0.200
    13.911   198.434     0.200
    13.942   203.043     0.200
    13.921   198.545     0.200
    13.921   198.166     0.200
    13.979   199.805     0.200
    14.027   200.283     0.200
    14.024   199.350     0.200
    14.036   200.797     0.200
    14.088   204.445     0.200
    14.047   200.271     0.200
    14.056   200.117     0.200
    14.092   204.453     0.200
    14.084   201.908     0.200
    14.097   201.527     0.200
    14.133   202.963     0.200
    14.133   203.734     0.200
    14.133   202.936     0.200
    14.209   206.463     0.200
    14.219   204.084     0.200
    14.241   203.326     0.200
    14.251   203.443     0.200
    14.271   204.023     0.200
    14.274   203.281     0.200
    14.307   204.393     0.200
    14.407   207.211     0.200
    14.352   204.387     0.200
    14.384   205.586     0.200
    14.379   204.891     0.200
    14.393   205.055     0.200
    14.427   205.660     0.200
    14.430   205.135     0.200
    14.463   210.074     0.200
    14.444   205.947     0.200
    14.507   208.391     0.200
    14.490   205.521     0.200
    14.513   206.184     0.200
    14.550   208.010     0.200
    14.597   208.082     0.200
    14.585   206.971     0.200
    14.592   206.904     0.200
    14.596   207.979     0.200
    14.606   206.941     0.200
    14.632   207.787     0.200
    14.632   207.326     0.200
    14.754   212.525     0.200
    14.726   209.098     0.200
    14.750   211.500     0.200
    14.742   210.779     0.200
    14.810   210.566     0.200
    14.810   212.123     0.200
    14.815   210.264     0.200
    14.828   210.846     0.200
    14.853   210.629     0.200
    14.858   210.414     0.200
    14.858   211.074     0.200
    14.890   212.389     0.200
    14.883   212.104     0.200
    14.940   212.750     0.200
    14.935   212.105     0.200
    14.962   211.264     0.200
    14.936   212.336     0.200
    14.955   213.154     0.200
    14.991   212.561     0.200
    15.008   213.691     0.200
    15.025   213.779     0.200
    15.032   212.715     0.200
    15.061   214.713     0.200
    15.087   213.895     0.200
    15.090   213.949     0.200
    15.133   217.234     0.200
    15.150   216.094     0.200
    15.186   215.520     0.200
    15.188   215.359     0.200
    15.188   216.674     0.200
    15.240   215.701     0.200
    15.302   219.373     0.200
    15.282   216.137     0.200
    15.346   220.029     0.200
    15.317   216.486     0.200
    15.350   217.086     0.200
    15.373   217.441     0.200
    15.373   219.674     0.200
    15.435   218.154     0.200
    15.497   221.955     0.200
    15.470   219.756     0.200
    15.467   220.232     0.200
    15.473   218.977     0.200
    15.478   219.992     0.200
    15.476   219.012     0.200
    15.485   218.578     0.200
    15.498   220.422     0.200
    15.497   218.961     0.200
    15.508   219.566     0.200
    15.531   221.266     0.200
    15.516   220.037     0.200
    15.597   222.551     0.200
    15.596   220.701     0.200
    15.683   224.389     0.200
    15.693   223.029     0.200
    15.704   222.445     0.200
    15.734   223.357     0.200
    15.800   226.314     0.200
    15.778   223.803     0.200
    15.790   224.172     0.200
    15.810   224.592     0.200
    15.800   224.125     0.200
    15.819   224.344     0.200
    15.810   223.352     0.200
    15.843   224.807     0.200
    15.870   224.857     0.200
    15.875   225.100     0.200
    15.895   224.332     0.200
    15.902   224.414     0.200
    15.973   226.420     0.200
    15.962   225.283     0.200
    15.979   225.176     0.200
    16.008   226.041     0.200
    16.036   226.795     0.200
    16.060   227.623     0.200
    16.150   227.148     0.200
    16.161   227.820     0.200
    16.170   228.082     0.200
    16.180   228.215     0.200
    16.185   227.162     0.200
    16.228   231.293     0.200
    16.230   229.061     0.200
    16.256   231.293     0.200
    16.262   228.848     0.200
    16.348   232.113     0.200
    16.302   228.783     0.200
    16.322   231.014     0.200
    16.310   229.646     0.200
    16.315   230.203     0.200
    16.358   231.250     0.200
    16.397   231.227     0.200
    16.409   231.916     0.200
    16.398   231.299     0.200
    16.412   231.242     0.200
    16.479   231.164     0.200
    16.494   232.854     0.200
    16.500   233.275     0.200
    16.539   233.137     0.200
    16.545   232.510     0.200
    16.550   232.977     0.200
    16.550   234.484     0.200
    16.574   233.332     0.200
    16.593   235.650     0.200
    16.645   234.123     0.200
    16.689   234.701     0.200
    16.729   236.135     0.200
    16.732   235.275     0.200
    16.735   235.209     0.200
    16.753   235.867     0.200
    16.777   235.531     0.200
    16.796   236.449     0.200
    16.807   235.947     0.200
    16.884   238.877     0.200
    16.836   236.281     0.200
    16.850   236.814     0.200
    16.865   236.990     0.200
    16.862   236.729     0.200
    16.862   237.104     0.200
    16.907   239.230     0.200
    16.913   238.637     0.200
    16.940   237.229     0.200
    16.948   237.426     0.200
    16.981   239.436     0.200
    16.998   239.869     0.200
    16.985   237.834     0.200
    17.029   238.914     0.200
    17.031   238.852     0.200
    17.052   238.895     0.200
    17.072   239.453     0.200
    17.112   241.131     0.200
    17.118   239.477     0.200
    17.118   241.225     0.200
    17.132   240.496     0.200
    17.178   240.883     0.200
    17.214   241.691     0.200
    17.240   243.174     0.200
    17.283   242.391     0.200
    17.297   242.953     0.200
    17.330   243.580     0.200
    17.357   242.902     0.200
    17.356   243.299     0.200
    17.382   243.398     0.200
    17.399   244.148     0.200
    17.411   243.211     0.200
    17.436   244.893     0.200
    17.462   245.998     0.200
    17.463   245.938     0.200
    17.474   244.342     0.200
    17.486   245.482     0.200
    17.511   244.502     0.200
    17.517   244.766     0.200
    17.577   246.859     0.200
    17.547   245.201     0.200
    17.573   245.037     0.200
    17.581   244.922     0.200
    17.583   245.062     0.200
    17.623   245.693     0.200
    17.721   247.207     0.200
    17.735   247.834     0.200
    17.774   248.109     0.200
    17.789   247.803     0.200
    17.808   248.938     0.200
    17.870   250.629     0.200
    17.866   250.438     0.200
    17.862   249.008     0.200
    17.862   249.035     0.200
    17.895   250.838     0.200
    18.009   250.930     0.200
    18.024   251.113     0.200
    18.024   250.844     0.200
    18.044   251.652     0.200
    18.060   251.502     0.200
    18.143   252.811     0.200
    18.186   253.535     0.200
    18.201   254.387     0.200
    18.255   255.064     0.200
    18.308   254.824     0.200
    18.323   254.273     0.200
    18.349   255.459     0.200
    18.418   258.254     0.200
    18.418   259.734     0.200
    18.405   257.211     0.200
    18.482   258.113     0.200
    18.482   259.314     0.200
    18.574   259.527     0.200
    18.582   260.207     0.200
    19.013   264.654     0.200
    19.064   264.574     0.200
    19.326   267.844     0.200
    19.423   272.314     0.200
    20.062   276.074     0.200
     1.246    20.754     0.200
     2.124    33.684     0.200
     2.473    40.203     0.200
     2.510    38.887     0.200
     2.510    38.434     0.200
     2.710    42.375     0.200
     2.776    43.215     0.200
     2.844    43.941     0.200
     2.922    44.793     0.200
     3.067    48.656     0.200
     3.074    46.723     0.200
     3.074    46.391     0.200
     3.133    47.875     0.200
     3.133    48.102     0.200
     3.080    50.512     0.200
     3.080    49.434     0.200
     3.257    49.441     0.200
     3.183    48.344     0.200
     3.383    52.551     0.200
     3.488    52.914     0.200
     3.635    57.004     0.200
     3.638    54.895     0.200
     3.638    54.621     0.200
     3.642    54.750     0.200
     3.640    55.902     0.200
     4.025    63.004     0.200
     4.148    62.281     0.200
     4.086    61.602     0.200
     4.369    65.539     0.200
     4.443    67.504     0.200
     4.543    70.691     0.200
     4.674    72.004     0.200
     4.971    78.953     0.200
     5.053    75.656     0.200
     5.145    77.301     0.200
     5.174    77.844     0.200
     5.323    80.160     0.200
     5.323    80.664     0.200
     5.587    84.094     0.200
     5.598    82.707     0.200
     5.598    82.914     0.200
     5.743    87.270     0.200
     5.705    84.801     0.200
     5.705    85.402     0.200
     5.930    88.602     0.200
     5.935    89.711     0.200
     6.151    92.918     0.200
     6.272    96.758     0.200
     6.272    92.492     0.200
     6.291    96.297     0.200
     6.383    95.641     0.200
     6.379    95.164     0.200
     6.528    98.184     0.200
     6.569    98.832     0.200
     6.569    97.484     0.200
     6.726   102.211     0.200
     6.723   102.578     0.200
     6.881   105.523     0.200
     6.907   103.152     0.200
     6.938   104.355     0.200
     6.869   100.070     0.200
     6.869   101.293     0.200
     6.869    99.934     0.200
     6.873   100.973     0.200
     6.919   103.734     0.200
     6.971   104.211     0.200
     7.120   104.672     0.200
     7.192   105.371     0.200
     7.312   108.191     0.200
     7.311   111.125     0.200
     7.428   106.500     0.200
     7.428   108.602     0.200
     7.524   112.961     0.200
     7.636   110.613     0.200
     7.636   110.789     0.200
     7.636   111.363     0.200
     7.801   115.164     0.200
     7.871   114.672     0.200
     7.882   114.953     0.200
     7.969   114.953     0.200
     7.986   119.062     0.200
     7.967   116.984     0.200
     7.967   117.281     0.200
     8.157   118.672     0.200
     8.550   124.551     0.200
     8.550   127.914     0.200
     8.698   126.281     0.200
     8.716   126.953     0.200
     8.787   130.453     0.200
     8.905   131.273     0.200
     8.922   132.332     0.200
     8.913   127.512     0.200
     9.048   135.844     0.200
     9.082   130.453     0.200
     9.024   129.211     0.200
     9.025   129.141     0.200
     9.025   129.137     0.200
     9.195   132.641     0.200
     9.221   135.328     0.200
     9.221   137.312     0.200
     9.381   136.984     0.200
     9.416   137.184     0.200
     9.464   137.801     0.200
     9.541   139.004     0.200
     9.575   141.758     0.200
     9.575   140.422     0.200
     9.610   143.992     0.200
     9.960   145.125     0.200
     9.960   144.941     0.200
    10.068   145.742     0.200
    10.086   146.473     0.200
    10.033   144.371     0.200
    10.033   142.801     0.200
    10.057   145.684     0.200
    10.131   148.137     0.200
    10.143   145.633     0.200
    10.186   145.582     0.200
    10.287   146.574     0.200
    10.262   146.102     0.200
    10.579   155.621     0.200
    10.554   153.914     0.200
    10.554   152.812     0.200
    10.654   153.223     0.200
    11.011   158.723     0.200
    11.062   162.191     0.200
    11.154   162.453     0.200
    11.169   159.801     0.200
    11.398   164.449     0.200
    11.398   164.164     0.200
    11.549   169.883     0.200
    12.116   173.133     0.200
    12.208   175.082     0.200
    12.208   173.812     0.200
    12.312   174.891     0.200
    12.348   177.312     0.200
    12.419   177.664     0.200
    12.364   176.922     0.200
    12.364   176.531     0.200
    12.497   179.375     0.200
    12.601   182.352     0.200
    12.601   180.043     0.200
    12.601   178.832     0.200
    12.601   181.062     0.200
    12.601   179.191     0.200
    12.797   186.559     0.200
    12.833   187.402     0.200
    12.905   189.020     0.200
    12.916   184.824     0.200
    12.899   187.176     0.200
    12.899   184.262     0.200
    12.849   183.012     0.200
    12.934   184.734     0.200
    12.903   182.984     0.200
    13.046   189.621     0.200
    13.117   190.172     0.200
    13.117   190.312     0.200
    13.178   190.551     0.200
    13.327   193.074     0.200
    13.380   192.027     0.200
    13.484   197.191     0.200
    13.497   191.574     0.200
    13.422   191.152     0.200
    13.422   191.531     0.200
    13.726   196.602     0.200
    13.882   201.246     0.200
    13.985   201.547     0.200
    14.148   205.762     0.200
    14.094   200.812     0.200
    14.178   203.914     0.200
    14.245   204.148     0.200
    14.737   212.887     0.200
    14.684   207.898     0.200
    14.860   214.340     0.200
    14.814   208.480     0.200
    14.917   213.945     0.200
    14.964   212.195     0.200
    15.040   216.316     0.200
    15.040   215.621     0.200
    14.977   210.023     0.200
    15.041   211.184     0.200
    15.041   212.734     0.200
    15.110   213.586     0.200
    15.214   215.598     0.200
    15.303   216.039     0.200
    15.349   217.773     0.200
    15.440   219.824     0.200
    15.479   218.902     0.200
    15.578   222.148     0.200
    15.578   221.363     0.200
    15.557   218.621     0.200
    15.578   220.500     0.200
    15.635   221.086     0.200
    15.679   221.102     0.200
    15.747   223.020     0.200
    15.793   222.676     0.200
    15.782   222.961     0.200
    15.861   223.566     0.200
    15.925   224.316     0.200
    15.925   224.934     0.200
    16.073   225.785     0.200
    16.073   226.812     0.200
    16.161   227.371     0.200
    16.150   226.785     0.200
    16.150   227.223     0.200
    16.192   228.367     0.200
    16.196   228.398     0.200
    16.196   228.004     0.200
    16.200   228.184     0.200
    16.224   228.156     0.200
    16.309   230.113     0.200
    16.242   229.059     0.200
    16.320   229.344     0.200
    16.319   229.652     0.200
    16.534   231.531     0.200
    16.534   232.223     0.200
    16.556   233.023     0.200
    16.556   234.703     0.200
    16.581   230.164     0.200
    16.590   232.051     0.200
    16.605   231.793     0.200
    16.725   235.094     0.200
    16.788   234.617     0.200
    16.839   236.113     0.200
    16.920   236.754     0.200
    16.968   237.801     0.200
    16.990   238.504     0.200
    17.081   238.961     0.200
    17.021   237.809     0.200
    17.054   239.734     0.200
    17.107   241.512     0.200
    17.072   239.219     0.200
    17.131   239.977     0.200
    17.118   240.430     0.200
    17.158   240.223     0.200
    17.166   239.207     0.200
    17.378   244.281     0.200
    17.305   241.430     0.200
    17.332   242.684     0.200
    17.450   243.492     0.200
    17.418   243.734     0.200
    17.477   243.844     0.200
    17.537   245.777     0.200
    17.528   245.375     0.200
    17.535   245.234     0.200
    17.654   248.074     0.200
    17.611   245.949     0.200
    17.618   247.613     0.200
    17.649   246.371     0.200
    17.645   246.262     0.200
    17.762   247.641     0.200
    17.709   247.875     0.200
    17.739   247.227     0.200
    17.760   246.977     0.200
    17.798   248.320     0.200
    17.846   248.039     0.200
    17.869   248.242     0.200
    17.996   251.859     0.200
    17.989   250.938     0.200
    17.989   250.055     0.200
    18.002   250.305     0.200
    18.032   252.168     0.200
    18.041   250.852     0.200
    18.124   252.879     0.200
    18.112   252.531     0.200
    18.112   252.941     0.200
    18.145   252.664     0.200
    18.159   252.961     0.200
    18.213   253.297     0.200
    18.233   253.789     0.200
    18.261   254.207     0.200
    18.332   253.379     0.200
    18.392   254.543     0.200
    18.341   254.562     0.200
    18.434   258.699     0.200
    18.663   264.191     0.200
    19.002   265.176     0.200
    19.300   268.102     0.200
    20.090   276.934     0.200
    20.568   282.551     0.200
     1.287    20.469     0.200
     1.369    23.008     0.200
     2.572    39.773     0.200
     2.572    39.625     0.200
     2.757    42.758     0.200
     2.828    42.664     0.200
     2.879    45.766     0.200
     2.879    44.367     0.200
     2.879    44.469     0.200
     3.050    47.656     0.200
     3.050    47.469     0.200
     2.959    45.383     0.200
     3.112    47.938     0.200
     3.115    47.648     0.200
     3.223    49.727     0.200
     3.223    48.102     0.200
     3.197    48.773     0.200
     3.527    53.547     0.200
     3.527    53.500     0.200
     3.668    54.820     0.200
     3.687    56.094     0.200
     3.689    56.094     0.200
     3.689    55.281     0.200
     4.104    62.328     0.200
     4.071    60.977     0.200
     4.441    66.953     0.200
     4.509    67.680     0.200
     4.574    70.219     0.200
     4.684    69.414     0.200
     4.710    70.734     0.200
     4.801    72.477     0.200
     4.818    73.242     0.200
     4.986    74.336     0.200
     5.016    78.562     0.200
     5.200    75.891     0.200
     5.279    78.297     0.200
     5.279    77.625     0.200
     5.385    80.844     0.200
     5.385    80.664     0.200
     5.627    83.609     0.200
     5.566    84.320     0.200
     5.647    83.188     0.200
     5.682    85.641     0.200
     5.760    86.359     0.200
     5.760    85.773     0.200
     5.797    85.086     0.200
     5.884    86.570     0.200
     6.000    89.734     0.200
     5.994    89.453     0.200
     6.107    91.438     0.200
     6.194    90.414     0.200
     6.208    91.453     0.200
     6.323    96.195     0.200
     6.323    93.352     0.200
     6.350    93.320     0.200
     6.506    96.812     0.200
     6.445    95.547     0.200
     6.440    97.336     0.200
     6.631    99.305     0.200
     6.631    97.875     0.200
     6.778    99.328     0.200
     6.775    98.812     0.200
     6.914   102.133     0.200
     6.915   102.438     0.200
     6.924   101.148     0.200
     6.973   103.945     0.200
     6.985   105.109     0.200
     6.997   102.820     0.200
     7.038   104.594     0.200
     7.159   105.188     0.200
     7.225   109.273     0.200
     7.232   107.273     0.200
     7.446   109.750     0.200
     7.446   108.844     0.200
     7.356   114.109     0.200
     7.371   119.195     0.200
     7.590   113.555     0.200
     7.677   111.367     0.200
     7.680   112.602     0.200
     7.680   113.289     0.200
     7.680   111.203     0.200
     7.680   112.375     0.200
     7.826   117.547     0.200
     7.865   115.758     0.200
     7.937   116.133     0.200
     7.939   128.008     0.200
     8.026   118.336     0.200
     8.026   116.477     0.200
     8.051   119.664     0.200
     8.141   121.883     0.200
     8.108   118.750     0.200
     8.162   123.523     0.200
     8.205   115.117     0.200
     8.211   125.047     0.200
     8.369   124.016     0.200
     8.495   133.664     0.200
     8.608   128.508     0.200
     8.608   128.906     0.200
     8.675   127.719     0.200
     8.724   130.164     0.200
     8.741   131.055     0.200
     8.746   130.438     0.200
     8.758   128.914     0.200
     8.775   131.328     0.200
     8.777   124.562     0.200
     8.780   131.039     0.200
     8.819   132.117     0.200
     8.766   128.633     0.200
     8.849   131.195     0.200
     8.854   131.680     0.200
     8.862   132.828     0.200
     8.963   132.898     0.200
     9.023   131.508     0.200
     9.024   131.055     0.200
     8.970   129.656     0.200
     8.988   132.906     0.200
     9.100   136.734     0.200
     9.107   135.500     0.200
     9.134   135.227     0.200
     9.277   132.562     0.200
     9.260   136.656     0.200
     9.482   141.766     0.200
     9.529   140.359     0.200
     9.607   142.758     0.200
     9.641   142.797     0.200
     9.641   138.836     0.200
     9.667   144.656     0.200
     9.861   148.453     0.200
     9.865   147.719     0.200
    10.012   145.719     0.200
    10.012   143.531     0.200
    10.063   148.625     0.200
    10.063   143.711     0.200
    10.126   150.898     0.200
    10.139   151.180     0.200
    10.181   149.406     0.200
    10.209   150.414     0.200
    10.252   151.148     0.200
    10.290   152.453     0.200
    10.290   149.586     0.200
    10.321   151.133     0.200
    10.353   152.516     0.200
    10.616   155.203     0.200
    10.616   153.555     0.200
    10.635   157.633     0.200
    10.720   158.133     0.200
    10.778   158.523     0.200
    11.066   157.047     0.200
    11.202   162.828     0.200
    11.202   161.461     0.200
    11.175   163.750     0.200
    11.220   164.508     0.200
    11.455   166.398     0.200
    11.455   163.242     0.200
    11.603   167.656     0.200
    11.971   171.547     0.200
    12.012   176.773     0.200
    12.217   175.805     0.200
    12.217   175.516     0.200
    12.177   175.172     0.200
    12.168   179.195     0.200
    12.384   178.328     0.200
    12.384   177.492     0.200
    12.354   179.797     0.200
    12.378   179.656     0.200
    12.398   181.227     0.200
    12.410   181.188     0.200
    12.469   183.609     0.200
    12.547   184.023     0.200
    12.547   179.328     0.200
    12.557   181.945     0.200
    12.666   182.258     0.200
    12.666   179.977     0.200
    12.666   182.758     0.200
    12.666   182.805     0.200
    12.666   182.148     0.200
    12.721   190.414     0.200
    12.816   188.109     0.200
    12.900   182.227     0.200
    12.853   187.531     0.200
    12.898   187.828     0.200
    12.965   188.336     0.200
    12.965   188.203     0.200
    12.959   188.852     0.200
    13.000   187.938     0.200
    12.968   189.539     0.200
    13.110   188.750     0.200
    13.112   189.516     0.200
    13.130   184.484     0.200
    13.172   191.688     0.200
    13.172   192.328     0.200
    13.244   191.680     0.200
    13.251   192.305     0.200
    13.282   191.367     0.200
    13.329   194.930     0.200
    13.393   193.094     0.200
    13.451   192.125     0.200
    13.451   191.594     0.200
    13.442   193.359     0.200
    13.442   192.102     0.200
    13.406   195.555     0.200
    13.510   195.234     0.200
    13.542   196.234     0.200
    13.727   198.250     0.200
    14.030   201.633     0.200
    13.941   201.688     0.200
    14.105   202.406     0.200
    14.105   201.469     0.200
    14.051   200.828     0.200
    14.159   202.305     0.200
    14.159   202.008     0.200
    14.194   202.930     0.200
    14.194   202.336     0.200
    14.206   204.695     0.200
    14.244   205.633     0.200
    14.291   204.117     0.200
    14.291   203.758     0.200
    14.253   206.516     0.200
    14.303   205.375     0.200
    14.368   209.000     0.200
    14.397   208.078     0.200
    14.367   206.469     0.200
    14.490   209.016     0.200
    14.795   212.406     0.200
    14.860   213.062     0.200
    14.920   215.328     0.200
    14.924   215.906     0.200
    14.982   214.312     0.200
    15.065   215.242     0.200
    15.106   217.336     0.200
    15.106   217.117     0.200
    15.201   218.609     0.200
    15.266   219.586     0.200
    15.499   222.555     0.200
    15.540   223.273     0.200
    15.545   222.102     0.200
    15.580   223.125     0.200
    15.639   221.969     0.200
    15.639   221.203     0.200
    15.687   222.219     0.200
    15.603   221.891     0.200
    15.734   224.453     0.200
    15.802   226.273     0.200
    15.917   228.133     0.200
    16.105   228.609     0.200
    16.105   227.914     0.200
    16.194   231.164     0.200
    16.227   231.055     0.200
    16.227   230.688     0.200
    16.239   231.500     0.200
    16.328   231.414     0.200
    16.363   232.695     0.200
    16.372   233.133     0.200
    16.373   232.859     0.200
    16.571   234.609     0.200
    16.571   233.453     0.200
    16.576   233.562     0.200
    16.576   232.898     0.200
    16.726   237.078     0.200
    16.726   234.758     0.200
    16.895   238.977     0.200
    17.008   240.383     0.200
    17.192   240.789     0.200
    17.171   241.664     0.200
    17.171   240.977     0.200
    17.332   241.469     0.200
    17.253   243.719     0.200
    17.294   243.492     0.200
    17.496   244.281     0.200
    17.440   245.883     0.200
    17.563   246.109     0.200
    17.514   246.758     0.200
    17.636   246.977     0.200
    17.650   246.750     0.200
    17.666   246.008     0.200
    17.720   248.781     0.200
    17.790   247.164     0.200
    17.822   248.516     0.200
    17.860   249.211     0.200
    17.881   250.266     0.200
    17.953   250.781     0.200
    18.029   250.406     0.200
    18.049   250.320     0.200
    18.060   250.078     0.200
    18.140   253.430     0.200
    18.140   252.070     0.200
    18.165   252.750     0.200
    18.118   253.297     0.200
    18.196   252.625     0.200
    18.238   254.773     0.200
    18.238   252.852     0.200
    18.217   253.703     0.200
    18.266   253.836     0.200
    18.224   254.977     0.200
    18.373   255.242     0.200
    18.330   255.156     0.200
    18.440   256.258     0.200
    18.458   258.594     0.200
    18.442   258.297     0.200
    18.578   260.430     0.200
    18.786   261.773     0.200
    18.803   262.008     0.200
    18.813   263.078     0.200
    18.960   265.125     0.200
    18.970   263.500     0.200
    19.023   264.320     0.200
    19.063   266.219     0.200
    19.094   267.375     0.200
    19.088   264.906     0.200
    19.095   264.812     0.200
    19.364   268.398     0.200
    19.456   269.359     0.200
    19.442   269.453     0.200
    19.933   275.906     0.200
    19.937   274.453     0.200
    20.007   275.328     0.200
    20.081   277.656     0.200
    20.140   277.656     0.200
    20.146   277.289     0.200
    20.168   277.117     0.200
    20.519   281.094     0.200
    20.658   283.055     0.200
    20.773   285.203     0.200
    20.777   284.156     0.200
    20.784   287.656     0.200
    20.912   285.461     0.200
    21.034   288.750     0.200
     1.256    21.883     0.200
     1.401    23.938     0.200
     1.465    24.633     0.200
     1.676    27.000     0.200
     1.946    31.328     0.200
     1.946    31.633     0.200
     2.097    33.383     0.200
     2.071    33.891     0.200
     2.133    34.398     0.200
     2.517    39.422     0.200
     2.543    41.688     0.200
     2.535    40.094     0.200
     2.585    41.406     0.200
     3.220    49.297     0.200
     3.220    49.609     0.200
     3.251    50.039     0.200
     3.454    54.086     0.200
     3.753    58.266     0.200
     3.926    58.703     0.200
     4.099    61.766     0.200
     4.636    68.031     0.200
     4.850    72.812     0.200
     5.084    77.867     0.200
     5.425    79.516     0.200
     5.507    84.156     0.200
     5.937    86.836     0.200
     6.032    92.023     0.200
     6.631   100.664     0.200
     9.631   137.945     0.200
     1.291    21.551     0.200
     1.397    23.078     0.200
     1.393    24.641     0.200
     1.393    24.438     0.200
     1.395    24.391     0.200
     1.395    24.500     0.200
     1.591    27.629     0.200
     1.807    30.828     0.200
     1.905    31.488     0.200
     1.905    31.082     0.200
     2.121    35.770     0.200
     2.258    38.570     0.200
     2.756    43.520     0.200
     2.756    43.891     0.200
     2.876    45.699     0.200
     2.960    47.641     0.200
     2.960    47.031     0.200
     2.971    46.859     0.200
     3.013    47.738     0.200
     3.013    47.168     0.200
     3.214    50.539     0.200
     3.214    50.180     0.200
     3.229    50.715     0.200
     3.396    53.059     0.200
     3.396    52.824     0.200
     3.398    52.211     0.200
     3.398    52.840     0.200
     3.488    53.855     0.200
     3.426    54.418     0.200
     3.621    55.848     0.200
     3.668    56.711     0.200
     3.712    57.598     0.200
     3.712    58.031     0.200
     3.825    58.938     0.200
     3.828    59.230     0.200
     3.828    58.801     0.200
     3.828    58.641     0.200
     3.891    59.680     0.200
     3.925    60.320     0.200
     3.981    61.062     0.200
     4.221    64.918     0.200
     4.413    66.996     0.200
     4.609    69.664     0.200
     4.601    70.879     0.200
     4.635    70.355     0.200
     4.720    71.621     0.200
     4.849    73.418     0.200
     5.128    82.918     0.200
     5.162    78.418     0.200
     5.405    81.820     0.200
     5.439    82.598     0.200
     5.439    81.547     0.200
     5.605    85.250     0.200
     5.605    84.555     0.200
     5.789    87.898     0.200
     5.771    87.141     0.200
     5.771    86.410     0.200
     5.771    86.168     0.200
     5.942    90.121     0.200
     5.969    90.371     0.200
     5.969    89.930     0.200
     6.191    93.430     0.200
     6.220    94.230     0.200
     6.364    94.508     0.200
     6.456    97.219     0.200
     6.456    96.938     0.200
     6.660    99.430     0.200
     6.709   101.449     0.200
     6.815   102.160     0.200
     6.815   101.715     0.200
     6.929   103.703     0.200
     7.079   104.930     0.200
     7.073   107.520     0.200
     7.187   107.910     0.200
     7.204   108.688     0.200
     7.253   108.781     0.200
     7.461   112.961     0.200
     7.555   111.910     0.200
     7.555   109.703     0.200
     7.808   117.168     0.200
     7.860   115.293     0.200
     7.860   115.719     0.200
     7.860   114.762     0.200
     8.062   120.270     0.200
     8.062   119.043     0.200
     8.119   120.090     0.200
     8.147   121.230     0.200
     8.120   117.930     0.200
     8.120   118.449     0.200
     8.239   122.430     0.200
     8.239   121.113     0.200
     8.270   124.160     0.200
     8.312   125.250     0.200
     8.327   123.840     0.200
     8.361   123.758     0.200
     8.713   130.320     0.200
     8.729   128.531     0.200
     8.775   130.855     0.200
     8.775   129.238     0.200
     8.851   131.348     0.200
     8.892   131.199     0.200
     8.942   131.121     0.200
     8.959   132.668     0.200
     8.964   131.461     0.200
     8.974   133.219     0.200
     8.986   132.629     0.200
     8.992   132.801     0.200
     8.993   132.309     0.200
     8.995   130.430     0.200
     8.999   132.168     0.200
     9.027   133.738     0.200
     9.036   133.680     0.200
     9.062   134.199     0.200
     9.068   134.160     0.200
     9.072   134.539     0.200
     9.074   134.148     0.200
     9.074   134.160     0.200
     9.075   133.285     0.200
     9.075   133.738     0.200
     9.190   136.281     0.200
     9.187   135.871     0.200
     9.207   136.750     0.200
     9.202   136.461     0.200
     9.230   136.840     0.200
     9.253   136.918     0.200
     9.272   135.910     0.200
     9.280   137.348     0.200
     9.480   138.469     0.200
     9.484   139.660     0.200
     9.484   138.480     0.200
     9.598   140.719     0.200
     9.700   142.668     0.200
     9.823   143.379     0.200
     9.825   144.559     0.200
     9.856   144.680     0.200
    10.011   145.648     0.200
    10.022   144.770     0.200
    10.214   150.109     0.200
    10.214   148.090     0.200
    10.208   150.090     0.200
    10.280   148.871     0.200
    10.289   149.121     0.200
    10.399   152.840     0.200
    10.399   151.750     0.200
    10.428   151.789     0.200
    10.470   152.199     0.200
    10.482   152.621     0.200
    10.482   157.281     0.200
    10.567   154.801     0.200
    10.813   158.520     0.200
    10.835   158.840     0.200
    10.835   157.125     0.200
    10.938   160.871     0.200
    11.360   165.840     0.200
    11.356   164.828     0.200
    11.393   167.488     0.200
    11.434   166.609     0.200
    11.667   170.938     0.200
    12.299   177.559     0.200
    12.393   179.469     0.200
    12.500   178.871     0.200
    12.565   183.680     0.200
    12.573   182.168     0.200
    12.592   184.949     0.200
    12.596   184.008     0.200
    12.745   178.797     0.200
    12.755   186.008     0.200
    12.886   186.098     0.200
    12.886   184.750     0.200
    12.886   188.359     0.200
    12.886   186.238     0.200
    12.937   185.570     0.200
    12.947   188.188     0.200
    13.099   189.609     0.200
    13.101   188.301     0.200
    13.103   188.762     0.200
    13.218   190.680     0.200
    13.320   194.078     0.200
    13.320   194.738     0.200
    13.331   189.770     0.200
    13.437   190.000     0.200
    13.462   193.461     0.200
    13.561   193.691     0.200
    13.594   195.270     0.200
    13.661   197.258     0.200
    13.728   197.770     0.200
    13.924   200.289     0.200
    14.109   201.598     0.200
    14.269   207.758     0.200
    14.322   204.500     0.200
    14.462   210.188     0.200
    14.475   209.508     0.200
    14.482   209.969     0.200
    14.476   206.551     0.200
    14.533   210.531     0.200
    14.567   211.340     0.200
    14.615   210.898     0.200
    14.579   207.551     0.200
    14.633   210.180     0.200
    14.685   212.391     0.200
    14.821   212.609     0.200
    14.957   214.461     0.200
    15.202   218.711     0.200
    15.213   218.891     0.200
    15.388   220.969     0.200
    15.719   224.379     0.200
    15.777   224.938     0.200
    15.775   225.051     0.200
    15.765   225.398     0.200
    15.856   225.238     0.200
    15.963   226.949     0.200
    15.988   229.121     0.200
    16.254   232.348     0.200
    16.311   232.609     0.200
    16.437   233.109     0.200
    16.460   234.711     0.200
    16.559   234.801     0.200
    16.563   234.840     0.200
    17.391   244.090     0.200
    17.391   242.484     0.200
    17.488   244.238     0.200
    17.709   248.488     0.200
    17.768   248.051     0.200
    17.937   250.898     0.200
    18.056   252.418     0.200
    18.504   258.297     0.200
    18.668   261.688     0.200
    18.807   263.109     0.200
    19.016   267.379     0.200
    19.618   271.070     0.200
     1.414    22.823     0.200
     1.376    24.012     0.200
     1.378    24.012     0.200
     1.545    27.012     0.200
     1.987    32.142     0.200
     2.290    36.662     0.200
     2.310    36.682     0.200
     2.803    44.032     0.200
     2.803    43.567     0.200
     2.892    46.914     0.200
     2.960    47.272     0.200
     2.998    47.576     0.200
     3.038    47.932     0.200
     3.038    47.752     0.200
     3.038    49.172     0.200
     3.221    50.892     0.200
     3.244    51.475     0.200
     3.451    54.742     0.200
     3.451    53.533     0.200
     3.479    53.432     0.200
     3.479    52.812     0.200
     3.479    52.534     0.200
     3.527    54.917     0.200
     3.400    57.032     0.200
     3.625    55.702     0.200
     3.625    57.250     0.200
     3.849    59.333     0.200
     3.851    59.228     0.200
     3.851    60.162     0.200
     3.938    60.213     0.200
     3.985    61.208     0.200
     4.015    63.377     0.200
     3.942    60.372     0.200
     4.291    65.593     0.200
     4.469    69.112     0.200
     4.652    71.421     0.200
     4.681    72.182     0.200
     4.783    73.142     0.200
     4.787    73.170     0.200
     4.884    77.146     0.200
     4.938    76.887     0.200
     5.139    78.532     0.200
     5.171    79.722     0.200
     5.472    83.132     0.200
     5.472    83.614     0.200
     5.488    83.032     0.200
     5.683    85.932     0.200
     5.798    87.762     0.200
     5.865    90.002     0.200
     5.846    87.122     0.200
     5.846    87.365     0.200
     5.967    92.698     0.200
     6.052    90.762     0.200
     6.052    91.124     0.200
     6.244    93.562     0.200
     6.292    94.583     0.200
     6.395    97.688     0.200
     6.476    97.132     0.200
     6.476    98.223     0.200
     6.633   100.315     0.200
     6.727   100.562     0.200
     6.778   101.732     0.200
     6.860   102.432     0.200
     6.860   103.980     0.200
     6.917   108.002     0.200
     7.160   105.892     0.200
     7.160   106.082     0.200
     7.201   110.228     0.200
     7.252   107.642     0.200
     7.275   109.382     0.200
     7.047   108.715     0.200
     7.320   109.472     0.200
     7.469   108.062     0.200
     7.623   108.552     0.200
     7.623   112.008     0.200
     7.879   118.103     0.200
     7.942   115.827     0.200
     7.942   116.732     0.200
     7.942   116.372     0.200
     7.942   116.110     0.200
     8.114   119.882     0.200
     8.127   119.412     0.200
     8.210   121.662     0.200
     8.148   118.912     0.200
     8.320   123.648     0.200
     8.340   124.872     0.200
     8.340   118.073     0.200
     8.396   124.333     0.200
     8.388   127.452     0.200
     8.792   132.593     0.200
     8.810   132.062     0.200
     8.810   134.232     0.200
     8.925   132.312     0.200
     8.882   130.632     0.200
     8.973   132.952     0.200
     9.044   133.612     0.200
     9.055   133.843     0.200
     9.066   134.252     0.200
     9.062   132.042     0.200
     9.142   135.262     0.200
     9.126   131.343     0.200
     9.127   132.751     0.200
     9.127   133.132     0.200
     9.567   141.882     0.200
     9.923   148.271     0.200
    10.297   154.458     0.200
    10.284   151.652     0.200
    10.284   153.406     0.200
    10.455   151.094     0.200
    10.455   153.333     0.200
    10.564   157.626     0.200
    10.616   156.372     0.200
    10.914   159.882     0.200
    11.433   168.432     0.200
    11.749   175.755     0.200
    11.772   176.129     0.200
    12.359   174.932     0.200
    12.359   181.917     0.200
    12.652   177.212     0.200
    12.828   188.132     0.200
    12.960   188.552     0.200
    12.960   188.452     0.200
    12.960   187.199     0.200
    12.768   183.552     0.200
    12.997   192.797     0.200
    13.155   192.232     0.200
    13.288   194.172     0.200
    13.346   194.301     0.200
    13.401   195.692     0.200
    13.531   188.412     0.200
    13.740   198.632     0.200
    13.798   200.892     0.200
    14.400   201.122     0.200
    14.551   202.692     0.200
    14.558   209.315     0.200
    14.602   204.162     0.200
    14.652   202.812     0.200
    14.659   203.742     0.200
    14.702   204.532     0.200
    14.649   209.603     0.200
    14.743   204.442     0.200
    15.028   207.312     0.200
    15.064   210.532     0.200
    15.289   212.412     0.200
    15.761   219.692     0.200
    15.765   220.802     0.200
    16.611   230.182     0.200
    16.830   232.353     0.200
    16.897   233.992     0.200
    17.005   239.462     0.200
    17.257   235.122     0.200
    17.393   240.472     0.200
    17.467   241.162     0.200
    17.472   243.932     0.200
    17.565   242.853     0.200
    17.669   241.902     0.200
    17.761   246.823     0.200
    17.801   245.142     0.200
    17.875   250.093     0.200
    18.127   252.652     0.200
    18.311   251.112     0.200
    18.353   255.642     0.200
    18.648   261.552     0.200
    18.747   262.164     0.200
    18.880   263.323     0.200
    18.948   266.877     0.200
    19.041   267.612     0.200
    18.998   264.132     0.200
    19.225   266.853     0.200
    19.308   267.888     0.200
    19.389   269.002     0.200
    19.507   270.912     0.200
    19.661   272.702     0.200
    19.658   274.083     0.200
    19.697   272.002     0.200
    19.905   273.752     0.200
    20.047   276.073     0.200
    20.098   278.872     0.200
    20.275   278.182     0.200
    20.405   280.135     0.200
    20.649   282.722     0.200
    20.765   284.580     0.200
    21.056   287.002     0.200
     1.186    20.734     0.200
     1.186    20.844     0.200
     1.278    21.676     0.200
     1.278    21.266     0.200
     1.403    25.195     0.200
     1.953    33.543     0.200
     1.925    31.781     0.200
     2.088    33.246     0.200
     2.088    33.453     0.200
     2.105    33.824     0.200
     2.134    34.516     0.200
     2.324    37.094     0.200
     2.488    40.715     0.200
     2.631    41.043     0.200
     2.614    41.070     0.200
     2.614    41.484     0.200
     2.685    41.539     0.200
     2.793    42.668     0.200
     2.844    45.273     0.200
     2.897    45.645     0.200
     3.015    47.555     0.200
     3.037    47.234     0.200
     3.219    50.086     0.200
     3.330    51.340     0.200
     3.420    52.730     0.200
     3.420    53.164     0.200
     3.485    52.230     0.200
     3.485    53.465     0.200
     3.605    55.977     0.200
     3.645    55.977     0.200
     3.645    54.875     0.200
     3.645    56.754     0.200
     3.748    57.117     0.200
     3.813    58.508     0.200
     3.916    59.836     0.200
     3.993    60.656     0.200
     4.061    61.934     0.200
     4.291    65.031     0.200
     4.399    67.297     0.200
     4.428    67.980     0.200
     4.458    67.508     0.200
     4.585    70.391     0.200
     4.594    70.215     0.200
     4.683    71.434     0.200
     4.708    71.129     0.200
     4.731    70.973     0.200
     4.932    77.355     0.200
     4.965    76.266     0.200
     4.959    74.098     0.200
     5.109    76.516     0.200
     5.142    76.789     0.200
     5.270    79.762     0.200
     5.270    80.695     0.200
     5.407    82.336     0.200
     5.423    81.844     0.200
     5.592    83.359     0.200
     5.579    83.918     0.200
     5.579    84.324     0.200
     5.668    84.695     0.200
     5.762    86.980     0.200
     5.893    87.758     0.200
     5.893    88.203     0.200
     6.029    92.664     0.200
     5.992    89.758     0.200
     5.992    90.715     0.200
     6.076    92.941     0.200
     6.062    91.434     0.200
     6.191    93.348     0.200
     6.269    93.934     0.200
     6.361    94.688     0.200
     6.428    96.215     0.200
     6.574    98.516     0.200
     6.632    99.504     0.200
     6.667    99.953     0.200
     6.667   100.074     0.200
     6.710   100.266     0.200
     6.753   100.656     0.200
     6.825   102.043     0.200
     6.945   103.953     0.200
     7.001   104.148     0.200
     7.136   107.836     0.200
     7.168   107.555     0.200
     7.171   106.629     0.200
     7.263   108.184     0.200
     7.349   109.234     0.200
     7.706   113.730     0.200
     7.706   113.074     0.200
     7.739   116.445     0.200
     7.921   117.035     0.200
     7.931   117.363     0.200
     7.938   115.395     0.200
     7.938   116.477     0.200
     8.085   119.789     0.200
     8.184   122.633     0.200
     8.198   121.496     0.200
     8.250   123.926     0.200
     8.247   122.219     0.200
     8.273   121.754     0.200
     8.609   127.836     0.200
     8.609   127.285     0.200
     8.676   126.965     0.200
     8.632   126.215     0.200
     8.699   130.773     0.200
     8.795   131.324     0.200
     8.883   131.406     0.200
     8.920   131.195     0.200
     8.945   132.035     0.200
     8.968   132.574     0.200
     8.978   133.004     0.200
     8.980   131.574     0.200
     8.980   132.934     0.200
     8.983   133.074     0.200
     9.191   135.285     0.200
     9.217   136.555     0.200
     9.259   134.906     0.200
     9.259   134.906     0.200
     9.260   134.156     0.200
     9.260   134.863     0.200
     9.427   139.055     0.200
     9.509   137.211     0.200
     9.769   144.207     0.200
     9.769   145.496     0.200
    10.278   150.977     0.200
    10.254   150.852     0.200
    10.254   151.477     0.200
    10.330   151.113     0.200
    10.359   153.453     0.200
    10.542   155.648     0.200
    10.813   157.004     0.200
    11.300   163.422     0.200
    11.319   167.023     0.200
    11.468   166.184     0.200
    11.468   167.555     0.200
    11.566   167.562     0.200
    11.679   168.691     0.200
    11.919   172.457     0.200
    12.390   178.547     0.200
    12.517   181.625     0.200
    12.468   181.289     0.200
    12.646   182.570     0.200
    12.834   184.824     0.200
    12.794   184.273     0.200
    12.830   184.230     0.200
    12.831   186.098     0.200
    12.831   185.496     0.200
    12.922   188.309     0.200
    12.962   190.805     0.200
    13.064   189.266     0.200
    13.140   191.301     0.200
    13.134   191.379     0.200
    13.385   194.031     0.200
    13.717   197.574     0.200
    13.870   199.246     0.200
    13.944   201.297     0.200
    14.197   206.164     0.200
    14.336   205.520     0.200
    14.454   206.609     0.200
    14.454   207.125     0.200
    14.546   207.777     0.200
    14.546   208.766     0.200
    14.788   212.977     0.200
    14.830   212.301     0.200
    14.930   214.305     0.200
    15.046   215.418     0.200
    15.139   216.863     0.200
    15.237   219.062     0.200
    15.541   221.488     0.200
    15.844   224.867     0.200
    15.844   226.316     0.200
    15.854   226.625     0.200
    15.937   227.613     0.200
    16.324   232.184     0.200
    16.332   232.805     0.200
    16.383   233.133     0.200
    16.371   231.613     0.200
    16.830   237.168     0.200
    16.836   238.004     0.200
    16.973   238.410     0.200
    16.973   240.484     0.200
    17.013   239.895     0.200
    17.307   243.992     0.200
    17.347   244.617     0.200
    17.829   249.742     0.200
    18.297   256.035     0.200
    18.446   257.938     0.200
    18.847   264.824     0.200
    19.069   265.480     0.200
    19.221   269.105     0.200
    19.263   267.453     0.200
    19.327   267.855     0.200
    19.545   270.840     0.200
    19.901   274.773     0.200
    20.400   280.523     0.200
     1.265    22.703     0.200
     2.012    33.836     0.200
     2.183    34.727     0.200
     2.198    35.258     0.200
     2.198    36.430     0.200
     2.342    37.875     0.200
     2.441    40.133     0.200
     2.573    41.047     0.200
     2.661    42.758     0.200
     2.705    42.180     0.200
     2.758    43.945     0.200
     2.859    45.125     0.200
     2.925    47.797     0.200
     2.976    46.109     0.200
     3.093    48.648     0.200
     3.111    48.250     0.200
     3.133    49.828     0.200
     3.133    51.430     0.200
     3.133    51.617     0.200
     3.385    53.195     0.200
     3.500    52.586     0.200
     3.500    54.625     0.200
     3.434    54.695     0.200
     3.619    57.055     0.200
     3.538    53.414     0.200
     3.538    57.477     0.200
     3.711    56.414     0.200
     3.713    57.680     0.200
     3.713    57.008     0.200
     3.873    60.180     0.200
     3.833    61.844     0.200
     4.068    61.109     0.200
     4.648    72.438     0.200
     5.009    80.359     0.200
     5.025    74.555     0.200
     5.042    75.617     0.200
     5.187    73.852     0.200
     5.331    80.984     0.200
     5.331    79.867     0.200
     5.342    83.039     0.200
     5.479    80.555     0.200
     5.574    85.383     0.200
     5.574    83.414     0.200
     5.669    83.273     0.200
     5.829    88.797     0.200
     5.967    90.141     0.200
     5.967    89.766     0.200
     6.103    90.719     0.200
     6.169    94.828     0.200
     6.254    94.984     0.200
     6.340    94.500     0.200
     6.340    92.883     0.200
     6.417    98.180     0.200
     6.595    99.164     0.200
     6.650   100.789     0.200
     6.717   100.836     0.200
     6.717   100.469     0.200
     6.783   101.461     0.200
     6.818   101.602     0.200
     6.904   100.320     0.200
     6.984   104.219     0.200
     7.120   107.859     0.200
     7.149   108.188     0.200
     7.119   105.445     0.200
     7.125   104.289     0.200
     7.341   107.328     0.200
     7.369   110.047     0.200
     7.633    98.109     0.200
     7.633   115.094     0.200
     7.753   117.758     0.200
     7.891   117.508     0.200
     7.973   118.305     0.200
     7.999   114.859     0.200
     8.022   116.445     0.200
     8.074   118.586     0.200
     8.201   119.664     0.200
     8.199   120.023     0.200
     8.213   119.406     0.200
     8.249   121.648     0.200
     8.228   119.508     0.200
     8.228   123.594     0.200
     8.575   127.953     0.200
     8.561   122.578     0.200
     8.669   133.438     0.200
     8.669   123.789     0.200
     8.754   124.938     0.200
     8.804   127.844     0.200
     8.871   127.797     0.200
     8.921   132.555     0.200
     8.919   129.117     0.200
     8.941   133.805     0.200
     8.955   128.703     0.200
     8.963   131.844     0.200
     8.969   130.203     0.200
     8.970   130.227     0.200
     8.971   131.109     0.200
     8.974   134.992     0.200
     9.014   132.883     0.200
     9.038   133.539     0.200
     9.047   131.680     0.200
     9.157   130.719     0.200
     9.148   135.430     0.200
     9.177   136.898     0.200
     9.158   134.047     0.200
     9.156   134.539     0.200
     9.167   135.703     0.200
     9.180   135.234     0.200
     9.207   135.656     0.200
     9.175   133.695     0.200
     9.175   133.703     0.200
     9.176   136.750     0.200
     9.176   133.836     0.200
     9.434   136.789     0.200
     9.489   135.297     0.200
     9.483   135.367     0.200
     9.483   134.344     0.200
     9.641   138.688     0.200
     9.713   138.367     0.200
     9.791   144.594     0.200
     9.791   144.914     0.200
     9.899   145.992     0.200
    10.165   146.953     0.200
    10.181   150.438     0.200
    10.222   144.992     0.200
    10.222   149.617     0.200
    10.316   150.055     0.200
    10.267   149.844     0.200
    10.373   153.242     0.200
    10.412   148.492     0.200
    10.499   152.344     0.200
    10.502   148.359     0.200
    10.502   155.406     0.200
    10.882   155.156     0.200
    10.930   156.844     0.200
    10.958   154.344     0.200
    11.335   162.023     0.200
    11.408   164.445     0.200
    11.658   165.555     0.200
    12.017   169.898     0.200
    12.195   169.859     0.200
    12.479   179.688     0.200
    12.389   180.117     0.200
    12.494   180.844     0.200
    12.539   181.633     0.200
    12.544   181.148     0.200
    12.575   180.125     0.200
    12.758   179.648     0.200
    12.839   181.016     0.200
    12.839   181.047     0.200
    12.839   190.312     0.200
    12.839   186.242     0.200
    12.920   184.492     0.200
    12.985   182.859     0.200
    12.990   184.664     0.200
    12.876   189.664     0.200
    13.015   187.953     0.200
    13.096   190.938     0.200
    13.096   187.977     0.200
    13.050   187.844     0.200
    13.161   187.406     0.200
    13.207   191.273     0.200
    13.274   187.133     0.200
    13.391   188.859     0.200
    13.404   186.617     0.200
    13.450   192.477     0.200
    13.572   190.797     0.200
    13.670   194.117     0.200
    13.653   193.984     0.200
    14.003   204.211     0.200
    14.422   209.109     0.200
    14.516   208.539     0.200
    14.522   209.875     0.200
    14.532   210.203     0.200
    14.650   208.898     0.200
    14.850   212.992     0.200
    14.785   211.562     0.200
    14.817   209.359     0.200
    14.902   214.688     0.200
    14.976   216.078     0.200
    15.015   216.258     0.200
    15.010   214.844     0.200
    15.056   213.680     0.200
    15.150   212.148     0.200
    15.807   224.938     0.200
    15.833   224.727     0.200
    15.857   225.055     0.200
    16.071   227.133     0.200
    16.037   227.617     0.200
    16.362   232.125     0.200
    16.362   230.492     0.200
    16.385   229.547     0.200
    16.310   229.977     0.200
    16.376   232.125     0.200
    16.464   232.234     0.200
    16.469   230.938     0.200
    16.533   231.633     0.200
    16.688   233.344     0.200
    16.755   234.508     0.200
    16.755   233.227     0.200
    16.788   236.977     0.200
    16.937   236.703     0.200
    16.993   238.562     0.200
    17.115   239.484     0.200
    17.279   241.367     0.200
    17.363   243.250     0.200
    17.316   241.945     0.200
    17.350   243.109     0.200
    17.350   241.438     0.200
    17.527   245.398     0.200
    17.543   242.984     0.200
    17.619   243.688     0.200
    17.781   245.867     0.200
    17.764   248.148     0.200
    17.879   249.906     0.200
    17.835   236.609     0.200
    17.835   248.266     0.200
    18.255   252.203     0.200
    18.324   253.445     0.200
    18.350   252.094     0.200
    19.232   269.289     0.200
     0.956    17.547     0.200
     0.956    17.258     0.200
     1.216    20.836     0.200
     1.238    20.816     0.200
     1.231    22.797     0.200
     1.305    23.176     0.200
     1.352    23.910     0.200
     1.352    24.105     0.200
     1.484    25.922     0.200
     1.620    27.797     0.200
     1.628    26.312     0.200
     1.626    27.191     0.200
     1.820    30.375     0.200
     1.905    31.816     0.200
     1.953    32.188     0.200
     1.982    32.344     0.200
     2.051    33.695     0.200
     2.081    34.344     0.200
     2.280    37.676     0.200
     2.471    39.891     0.200
     2.485    40.070     0.200
     2.560    41.898     0.200
     3.200    50.012     0.200
     3.238    50.828     0.200
     3.238    49.887     0.200
     3.414    54.266     0.200
     3.683    55.520     0.200
     3.739    58.688     0.200
     4.102    62.297     0.200
     4.102    61.227     0.200
     4.496    68.297     0.200
     4.614    71.660     0.200
     4.614    71.926     0.200
     4.757    72.676     0.200
     4.803    73.777     0.200
     5.051    78.195     0.200
     5.251    80.340     0.200
     5.251    80.059     0.200
     5.386    82.488     0.200
     5.470    84.277     0.200
     5.690    87.195     0.200
     5.781    86.699     0.200
     5.781    86.367     0.200
     6.596    99.559     0.200
     6.670   100.438     0.200
     6.806    98.195     0.200
     7.073   103.625     0.200
     7.403   110.375     0.200
     7.403   110.258     0.200
     7.797   114.293     0.200
     9.025   135.820     0.200
     9.667   140.957     0.200
     9.667   140.969     0.200
     9.668   140.340     0.200
     9.668   140.695     0.200
     2.014    33.687     0.200
     2.182    34.667     0.200
     2.182    34.429     0.200
     2.364    38.157     0.200
     2.612    40.977     0.200
     2.617    43.127     0.200
     2.618    42.597     0.200
     2.618    42.847     0.200
     2.807    44.827     0.200
     2.808    44.797     0.200
     2.837    46.017     0.200
     2.885    45.327     0.200
     2.885    46.367     0.200
     2.885    44.599     0.200
     2.891    46.437     0.200
     2.891    44.121     0.200
     2.918    45.817     0.200
     3.023    45.518     0.200
     3.012    45.447     0.200
     3.075    48.107     0.200
     3.195    49.617     0.200
     3.195    49.837     0.200
     3.237    49.576     0.200
     3.392    52.427     0.200
     3.553    56.107     0.200
     3.592    55.767     0.200
     3.592    54.492     0.200
     3.689    54.857     0.200
     3.689    56.087     0.200
     3.689    55.251     0.200
     3.866    59.237     0.200
     3.866    58.997     0.200
     3.866    57.425     0.200
     3.898    59.847     0.200
     3.783    55.687     0.200
     4.057    60.360     0.200
     4.188    62.821     0.200
     4.123    59.577     0.200
     4.344    65.747     0.200
     4.491    67.207     0.200
     4.570    68.388     0.200
     4.556    67.459     0.200
     4.735    69.941     0.200
     4.867    73.917     0.200
     4.907    74.707     0.200
     4.930    73.660     0.200
     5.290    78.360     0.200
     5.510    83.457     0.200
     5.510    80.361     0.200
     5.486    80.577     0.200
     5.688    84.767     0.200
     5.774    84.652     0.200
     5.848    88.417     0.200
     5.859    87.477     0.200
     5.859    86.839     0.200
     5.925    86.126     0.200
     6.054    89.757     0.200
     6.054    88.517     0.200
     6.054    89.378     0.200
     6.221    90.576     0.200
     6.249    92.977     0.200
     6.249    92.388     0.200
     6.295    94.897     0.200
     6.337    95.247     0.200
     6.397    96.117     0.200
     6.427    93.931     0.200
     6.447    96.987     0.200
     6.479    97.697     0.200
     6.479    94.850     0.200
     6.861   102.357     0.200
     6.921   103.847     0.200
     6.930   103.447     0.200
     6.930   101.468     0.200
     6.982   101.446     0.200
     7.037   103.287     0.200
     7.223   107.407     0.200
     7.247   108.797     0.200
     7.383   109.857     0.200
     7.369   107.677     0.200
     7.369   108.016     0.200
     7.424   110.437     0.200
     7.455   110.897     0.200
     7.440   109.737     0.200
     7.528   112.057     0.200
     7.550   113.377     0.200
     7.582   110.002     0.200
     7.619   110.677     0.200
     7.647   111.857     0.200
     7.820   113.147     0.200
     7.820   115.107     0.200
     7.820   113.306     0.200
     8.027   119.377     0.200
     8.099   118.917     0.200
     8.151   117.662     0.200
     8.151   118.077     0.200
     8.151   118.369     0.200
     8.205   121.707     0.200
     8.205   119.669     0.200
     8.331   124.077     0.200
     8.362   123.547     0.200
     8.269   119.877     0.200
     8.487   126.647     0.200
     8.493   124.957     0.200
     8.512   124.557     0.200
     8.512   123.585     0.200
     8.538   127.387     0.200
     8.853   130.604     0.200
     8.854   130.187     0.200
     8.939   133.267     0.200
     9.082   134.077     0.200
     9.104   134.897     0.200
     9.157   135.007     0.200
     9.256   134.167     0.200
     9.255   135.527     0.200
     9.299   137.047     0.200
     9.333   136.747     0.200
     9.295   133.417     0.200
     9.295   133.967     0.200
     9.296   133.184     0.200
     9.296   133.387     0.200
     9.429   138.637     0.200
     9.436   137.987     0.200
     9.453   139.247     0.200
     9.466   138.397     0.200
     9.714   141.187     0.200
     9.765   142.217     0.200
     9.765   140.623     0.200
     9.883   144.497     0.200
     9.912   143.387     0.200
     9.973   144.647     0.200
     9.988   145.457     0.200
    10.056   145.867     0.200
    10.056   144.578     0.200
    10.084   148.077     0.200
    10.223   150.427     0.200
    10.361   152.297     0.200
    10.488   153.347     0.200
    10.499   152.147     0.200
    10.499   150.041     0.200
    10.491   151.547     0.200
    10.491   151.172     0.200
    10.557   151.467     0.200
    10.557   153.677     0.200
    10.647   155.337     0.200
    10.684   155.467     0.200
    10.762   157.847     0.200
    10.771   156.027     0.200
    10.771   155.394     0.200
    10.807   157.287     0.200
    10.846   158.937     0.200
    11.054   160.307     0.200
    11.092   160.727     0.200
    11.554   166.277     0.200
    11.554   164.582     0.200
    11.607   167.677     0.200
    11.642   167.477     0.200
    11.786   171.447     0.200
    11.943   171.787     0.200
    11.943   171.307     0.200
    12.605   182.237     0.200
    12.543   179.727     0.200
    12.543   178.843     0.200
    12.645   183.037     0.200
    12.662   182.927     0.200
    12.702   184.337     0.200
    12.733   183.857     0.200
    12.811   183.297     0.200
    12.768   182.817     0.200
    12.768   182.448     0.200
    12.830   183.697     0.200
    12.958   186.617     0.200
    12.853   184.807     0.200
    13.052   187.907     0.200
    13.033   187.647     0.200
    13.064   189.307     0.200
    13.117   188.187     0.200
    13.117   185.180     0.200
    13.118   188.567     0.200
    13.118   188.837     0.200
    13.118   189.027     0.200
    13.120   189.407     0.200
    13.141   189.827     0.200
    13.141   188.107     0.200
    13.206   190.647     0.200
    13.162   188.987     0.200
    13.162   187.690     0.200
    13.254   192.147     0.200
    13.346   191.707     0.200
    13.346   188.070     0.200
    13.363   192.675     0.200
    13.363   191.747     0.200
    13.434   193.237     0.200
    13.479   192.627     0.200
    13.542   194.867     0.200
    13.547   195.617     0.200
    13.554   194.567     0.200
    13.576   194.557     0.200
    13.615   197.057     0.200
    13.615   191.274     0.200
    13.827   199.047     0.200
    13.917   199.437     0.200
    13.917   199.727     0.200
    13.875   198.087     0.200
    13.875   197.522     0.200
    14.160   203.247     0.200
    14.188   201.353     0.200
    14.435   207.057     0.200
    14.464   208.237     0.200
    14.484   207.687     0.200
    14.442   206.077     0.200
    14.437   207.327     0.200
    14.558   208.694     0.200
    14.562   210.097     0.200
    14.602   207.807     0.200
    14.657   210.977     0.200
    14.648   208.737     0.200
    14.648   209.424     0.200
    14.693   209.907     0.200
    14.781   211.877     0.200
    14.790   209.757     0.200
    14.767   210.497     0.200
    14.767   208.627     0.200
    14.804   210.437     0.200
    14.825   212.167     0.200
    14.826   211.947     0.200
    14.842   212.547     0.200
    15.027   213.681     0.200
    15.178   214.326     0.200
    15.277   216.563     0.200
    15.274   217.537     0.200
    15.426   221.057     0.200
    15.426   221.390     0.200
    15.509   221.587     0.200
    15.524   221.817     0.200
    15.674   221.817     0.200
    15.920   225.267     0.200
    15.959   223.797     0.200
    16.007   226.037     0.200
    16.119   228.577     0.200
    16.119   227.729     0.200
    16.168   229.717     0.200
    16.276   229.807     0.200
    16.568   230.407     0.200
    16.538   233.577     0.200
    16.538   232.933     0.200
    16.608   235.117     0.200
    16.615   232.477     0.200
    16.615   233.336     0.200
    16.635   232.927     0.200
    16.635   233.473     0.200
    16.589   233.917     0.200
    16.679   235.997     0.200
    16.730   235.647     0.200
    16.932   240.097     0.200
    16.932   236.270     0.200
    17.045   239.547     0.200
    17.045   239.261     0.200
    17.215   242.537     0.200
    17.210   242.347     0.200
    17.210   240.810     0.200
    17.277   242.177     0.200
    17.556   246.467     0.200
    17.595   247.257     0.200
    17.632   246.844     0.200
    17.847   248.947     0.200
    18.083   251.607     0.200
    18.177   253.611     0.200
    18.222   253.827     0.200
    18.328   254.417     0.200
    18.706   260.567     0.200
    18.846   262.107     0.200
    18.934   263.887     0.200
    19.107   265.407     0.200
    19.510   269.757     0.200
    19.510   270.012     0.200
    19.829   273.407     0.200
     2.053    33.613     0.200
     2.344    37.813     0.200
     2.369    37.193     0.200
     2.610    41.273     0.200
     2.611    41.453     0.200
     2.628    43.663     0.200
     2.637    43.273     0.200
     2.637    41.703     0.200
     2.821    44.703     0.200
     2.821    44.143     0.200
     2.851    45.573     0.200
     2.891    45.343     0.200
     2.891    44.593     0.200
     2.905    44.383     0.200
     2.936    45.533     0.200
     2.936    45.663     0.200
     2.936    45.893     0.200
     3.035    45.786     0.200
     3.029    47.133     0.200
     3.092    47.303     0.200
     3.134    47.063     0.200
     3.134    45.273     0.200
     3.212    49.773     0.200
     3.252    49.769     0.200
     3.377    52.463     0.200
     3.377    55.483     0.200
     3.557    54.793     0.200
     3.595    54.314     0.200
     3.609    55.153     0.200
     3.609    54.598     0.200
     3.672    56.633     0.200
     3.672    54.571     0.200
     3.895    59.233     0.200
     3.873    57.728     0.200
     3.880    58.773     0.200
     3.880    59.763     0.200
     3.880    58.279     0.200
     4.023    60.193     0.200
     4.068    61.503     0.200
     4.204    63.579     0.200
     4.360    66.633     0.200
     4.470    68.573     0.200
     4.574    68.534     0.200
     4.576    68.646     0.200
     4.633    68.541     0.200
     4.727    70.652     0.200
     4.753    71.799     0.200
     4.858    73.133     0.200
     4.908    75.043     0.200
     4.939    75.309     0.200
     4.945    75.686     0.200
     5.165    78.003     0.200
     5.307    80.642     0.200
     5.410    81.437     0.200
     5.403    81.528     0.200
     5.463    79.593     0.200
     5.522    84.023     0.200
     5.522    82.226     0.200
     5.628    84.590     0.200
     5.675    84.043     0.200
     5.790    86.713     0.200
     5.852    87.433     0.200
     5.852    87.159     0.200
     5.862    88.933     0.200
     5.934    88.792     0.200
     6.034    89.703     0.200
     6.034    88.873     0.200
     6.034    88.254     0.200
     6.237    92.613     0.200
     6.237    92.160     0.200
     6.237    92.348     0.200
     6.190    90.283     0.200
     6.305    95.373     0.200
     6.342    96.313     0.200
     6.443    96.363     0.200
     6.439    95.333     0.200
     6.414    95.643     0.200
     6.493    97.883     0.200
     6.493    96.125     0.200
     6.621    98.317     0.200
     6.516   100.003     0.200
     6.861   102.083     0.200
     6.919   103.673     0.200
     6.938   104.233     0.200
     6.938   102.015     0.200
     6.926   102.737     0.200
     6.994   104.400     0.200
     7.023   103.598     0.200
     7.258   109.763     0.200
     7.258   108.349     0.200
     7.352   107.753     0.200
     7.360   103.953     0.200
     7.383   110.593     0.200
     7.421   111.083     0.200
     7.455   111.063     0.200
     7.457   110.813     0.200
     7.535   112.453     0.200
     7.561   112.973     0.200
     7.601   110.563     0.200
     7.798   117.043     0.200
     7.798   113.187     0.200
     8.025   119.663     0.200
     8.135   117.348     0.200
     8.135   118.233     0.200
     8.116   119.153     0.200
     8.210   120.883     0.200
     8.210   119.416     0.200
     8.233   121.893     0.200
     8.332   122.723     0.200
     8.246   120.883     0.200
     8.246   117.023     0.200
     8.375   124.713     0.200
     8.485   125.123     0.200
     8.502   125.403     0.200
     8.502   124.064     0.200
     8.537   126.533     0.200
     8.510   125.943     0.200
     8.765   129.773     0.200
     8.864   130.641     0.200
     8.864   131.813     0.200
     8.871   130.753     0.200
     8.948   130.993     0.200
     9.079   134.553     0.200
     9.115   135.103     0.200
     9.148   135.753     0.200
     9.248   134.943     0.200
     9.325   137.593     0.200
     9.272   133.713     0.200
     9.272   133.473     0.200
     9.273   133.149     0.200
     9.273   133.443     0.200
     9.313   136.623     0.200
     9.380   137.883     0.200
     9.424   137.633     0.200
     9.432   138.423     0.200
     9.444   138.973     0.200
     9.457   138.843     0.200
     9.675   142.243     0.200
     9.710   143.063     0.200
     9.753   143.713     0.200
     9.753   140.934     0.200
     9.911   144.943     0.200
     9.895   144.983     0.200
     9.984   144.743     0.200
     9.986   144.553     0.200
    10.056   147.753     0.200
    10.056   145.721     0.200
    10.073   147.423     0.200
    10.096   147.873     0.200
    10.236   149.653     0.200
    10.372   151.563     0.200
    10.486   153.623     0.200
    10.486   152.150     0.200
    10.471   152.953     0.200
    10.471   151.311     0.200
    10.496   153.733     0.200
    10.561   152.153     0.200
    10.561   154.073     0.200
    10.644   155.973     0.200
    10.682   156.203     0.200
    10.756   157.333     0.200
    10.756   155.042     0.200
    10.762   156.793     0.200
    10.797   157.703     0.200
    10.858   157.743     0.200
    11.049   160.583     0.200
    11.085   161.263     0.200
    11.085   159.343     0.200
    11.057   160.633     0.200
    11.092   161.423     0.200
    11.542   166.635     0.200
    11.605   168.133     0.200
    11.622   170.053     0.200
    11.622   167.431     0.200
    11.799   172.033     0.200
    11.799   171.342     0.200
    11.932   173.353     0.200
    11.932   171.406     0.200
    12.142   174.373     0.200
    12.154   172.453     0.200
    12.520   178.623     0.200
    12.520   178.364     0.200
    12.652   182.293     0.200
    12.652   181.670     0.200
    12.621   180.863     0.200
    12.656   182.873     0.200
    12.710   183.743     0.200
    12.746   182.852     0.200
    12.747   184.023     0.200
    12.810   185.013     0.200
    12.822   184.173     0.200
    12.832   184.483     0.200
    12.974   184.503     0.200
    13.018   187.353     0.200
    13.018   187.707     0.200
    13.051   189.283     0.200
    13.077   187.803     0.200
    13.077   189.311     0.200
    13.114   188.783     0.200
    13.114   188.005     0.200
    13.114   189.023     0.200
    13.114   188.443     0.200
    13.114   188.233     0.200
    13.135   189.613     0.200
    13.154   189.853     0.200
    13.154   189.522     0.200
    13.196   189.763     0.200
    13.139   188.025     0.200
    13.258   190.773     0.200
    13.349   192.763     0.200
    13.349   191.785     0.200
    13.377   194.351     0.200
    13.377   193.303     0.200
    13.432   193.643     0.200
    13.494   194.233     0.200
    13.541   194.583     0.200
    13.545   195.073     0.200
    13.562   194.823     0.200
    13.587   196.013     0.200
    13.628   196.033     0.200
    13.628   197.063     0.200
    13.781   198.105     0.200
    13.826   198.903     0.200
    13.855   198.123     0.200
    13.910   198.483     0.200
    14.103   203.233     0.200
    14.103   203.553     0.200
    14.159   204.413     0.200
    14.199   204.004     0.200
    14.419   205.147     0.200
    14.447   207.173     0.200
    14.483   208.223     0.200
    14.483   206.078     0.200
    14.473   208.693     0.200
    14.497   207.343     0.200
    14.538   207.793     0.200
    14.538   206.565     0.200
    14.572   208.563     0.200
    14.581   208.943     0.200
    14.635   208.254     0.200
    14.658   211.193     0.200
    14.677   210.713     0.200
    14.691   210.503     0.200
    14.751   211.213     0.200
    14.751   210.472     0.200
    14.779   212.433     0.200
    14.790   212.673     0.200
    14.757   211.333     0.200
    14.825   212.963     0.200
    14.841   212.823     0.200
    14.831   213.233     0.200
    14.829   211.503     0.200
    14.935   213.553     0.200
    15.038   215.471     0.200
    15.066   214.353     0.200
    15.066   216.484     0.200
    15.083   215.483     0.200
    15.084   216.733     0.200
    15.257   218.533     0.200
    15.424   220.023     0.200
    15.424   220.312     0.200
    15.524   221.907     0.200
    15.517   221.693     0.200
    15.674   223.933     0.200
    15.757   224.233     0.200
    15.792   225.537     0.200
    15.818   226.253     0.200
    16.111   228.963     0.200
    16.257   229.963     0.200
    16.290   230.113     0.200
    16.518   232.893     0.200
    16.645   235.200     0.200
    16.696   235.053     0.200
    16.708   236.253     0.200
    16.909   237.667     0.200
    16.956   239.193     0.200
    17.028   239.853     0.200
    17.028   239.617     0.200
    17.196   241.293     0.200
    17.196   241.623     0.200
    17.222   242.273     0.200
    17.960   250.549     0.200
    18.063   251.473     0.200
    18.199   254.113     0.200
    18.306   254.743     0.200
    18.504   258.123     0.200
    18.553   258.073     0.200
    18.531   258.575     0.200
    18.607   259.583     0.200
    18.604   261.054     0.200
    18.623   259.249     0.200
    18.694   260.143     0.200
    18.704   261.143     0.200
    18.849   262.733     0.200
    18.915   262.653     0.200
    18.934   263.073     0.200
    18.934   263.422     0.200
    19.115   265.353     0.200
    19.197   266.607     0.200
    19.417   268.073     0.200
    19.417   269.363     0.200
    19.438   269.143     0.200
    19.478   269.843     0.200
    19.497   269.393     0.200
    19.577   271.213     0.200
    19.682   272.213     0.200
    19.824   273.493     0.200
    19.824   272.649     0.200
    20.098   276.643     0.200
    20.267   278.663     0.200
    20.429   279.833     0.200
    20.595   281.853     0.200
    20.595   281.550     0.200
    20.607   281.433     0.200
    20.607   281.689     0.200
    21.025   285.973     0.200
     1.157    18.398     0.200
     1.188    20.379     0.200
     1.188    20.078     0.200
     1.622    25.777     0.200
     1.622    25.887     0.200
     1.716    26.578     0.200
     1.716    26.859     0.200
     1.818    28.828     0.200
     1.818    28.527     0.200
     1.818    28.941     0.200
     1.818    29.047     0.200
     1.917    31.438     0.200
     1.996    31.828     0.200
     2.218    34.547     0.200
     2.310    36.547     0.200
     2.475    38.680     0.200
     2.527    38.797     0.200
     2.527    39.180     0.200
     2.538    40.398     0.200
     2.537    40.918     0.200
     2.582    39.168     0.200
     2.635    41.695     0.200
     2.729    42.309     0.200
     2.729    42.520     0.200
     2.729    42.707     0.200
     2.813    43.598     0.200
     2.861    43.977     0.200
     2.977    44.996     0.200
     2.977    46.797     0.200
     2.989    46.180     0.200
     3.110    47.789     0.200
     3.179    48.539     0.200
     3.251    50.383     0.200
     3.221    49.289     0.200
     3.221    51.117     0.200
     3.391    50.996     0.200
     3.391    50.617     0.200
     3.391    51.602     0.200
     3.503    53.238     0.200
     3.578    53.742     0.200
     3.579    54.246     0.200
     3.585    56.539     0.200
     3.585    55.539     0.200
     3.585    54.152     0.200
     3.661    55.047     0.200
     3.741    57.219     0.200
     3.668    58.867     0.200
     4.111    61.617     0.200
     4.297    64.078     0.200
     4.484    67.066     0.200
     4.519    68.469     0.200
     4.924    73.477     0.200
     5.068    76.230     0.200
     5.199    77.398     0.200
     5.330    79.148     0.200
     5.469    81.598     0.200
     5.582    82.719     0.200
     5.811    85.637     0.200
     5.811    86.344     0.200
     5.884    86.887     0.200
     5.966    86.996     0.200
     5.970    90.066     0.200
     6.051    90.738     0.200
     6.184    90.496     0.200
     6.214    89.859     0.200
     6.469    96.188     0.200
     6.583    96.867     0.200
     6.688   100.145     0.200
     6.852   100.949     0.200
     6.926   100.297     0.200
     6.993   104.039     0.200
     7.028   104.379     0.200
     7.063   104.719     0.200
     7.168   103.059     0.200
     7.223   103.688     0.200
     7.232   104.938     0.200
     7.632   112.840     0.200
     7.639   110.996     0.200
     7.639   111.375     0.200
     7.839   113.969     0.200
     7.839   113.590     0.200
     7.840   114.762     0.200
     7.840   111.887     0.200
     7.840   115.414     0.200
     7.888   112.688     0.200
     7.920   115.047     0.200
     7.945   115.719     0.200
     8.077   121.699     0.200
     8.092   119.828     0.200
     8.144   119.238     0.200
     8.137   119.430     0.200
     8.137   118.520     0.200
     8.405   120.559     0.200
     8.442   122.207     0.200
     8.536   127.148     0.200
     8.536   123.469     0.200
     8.687   127.129     0.200
     8.788   126.066     0.200
     8.772   127.316     0.200
     8.869   129.008     0.200
     8.870   127.809     0.200
     8.945   131.277     0.200
     9.029   128.918     0.200
     9.043   129.129     0.200
     9.034   132.289     0.200
     9.040   132.969     0.200
     9.054   130.840     0.200
     9.081   132.527     0.200
     9.106   131.566     0.200
     9.126   132.148     0.200
     9.218   134.566     0.200
     9.218   134.156     0.200
     9.219   134.316     0.200
     9.318   134.969     0.200
     9.357   133.656     0.200
     9.401   136.707     0.200
     9.401   137.066     0.200
     9.518   137.098     0.200
     9.582   137.117     0.200
     9.593   138.777     0.200
     9.649   139.508     0.200
     9.665   139.707     0.200
     9.665   140.148     0.200
     9.683   136.496     0.200
     9.927   140.988     0.200
    10.049   146.590     0.200
    10.138   145.719     0.200
    10.148   146.867     0.200
    10.148   147.996     0.200
    10.183   147.043     0.200
    10.183   146.340     0.200
    10.251   146.918     0.200
    10.246   147.867     0.200
    10.246   149.703     0.200
    10.290   147.957     0.200
    10.372   147.188     0.200
    10.429   149.848     0.200
    10.439   153.738     0.200
    10.439   152.367     0.200
    10.660   154.238     0.200
    10.703   154.688     0.200
    10.703   154.578     0.200
    10.760   155.680     0.200
    11.212   161.840     0.200
    11.241   161.109     0.200
    11.381   163.098     0.200
    11.381   163.656     0.200
    11.570   165.637     0.200
    11.570   166.098     0.200
    12.280   176.996     0.200
    12.327   179.008     0.200
    12.360   176.738     0.200
    12.417   178.316     0.200
    12.440   177.457     0.200
    12.413   177.848     0.200
    12.576   179.156     0.200
    12.576   180.938     0.200
    12.689   179.637     0.200
    12.722   185.277     0.200
    12.722   182.715     0.200
    12.722   183.609     0.200
    12.722   184.137     0.200
    12.722   183.039     0.200
    12.825   183.637     0.200
    12.882   187.129     0.200
    12.965   185.488     0.200
    12.965   185.160     0.200
    13.039   186.547     0.200
    12.976   185.840     0.200
    13.148   187.996     0.200
    13.095   186.430     0.200
    13.152   185.059     0.200
    13.206   188.078     0.200
    13.258   189.629     0.200
    13.281   189.969     0.200
    13.319   188.789     0.200
    13.324   190.168     0.200
    13.433   191.777     0.200
    13.527   192.738     0.200
    13.527   193.309     0.200
    13.547   192.566     0.200
    13.513   193.488     0.200
    13.634   193.918     0.200
    13.634   194.602     0.200
    13.870   199.477     0.200
    13.933   199.719     0.200
    13.944   196.898     0.200
    14.127   200.828     0.200
    14.238   200.059     0.200
    14.268   201.898     0.200
    14.289   202.969     0.200
    14.301   202.258     0.200
    14.386   204.270     0.200
    14.388   204.188     0.200
    14.462   204.637     0.200
    14.446   203.938     0.200
    14.558   205.379     0.200
    14.718   208.668     0.200
    14.681   207.859     0.200
    14.792   209.258     0.200
    14.880   209.777     0.200
    14.920   211.770     0.200
    14.940   211.840     0.200
    14.965   212.090     0.200
    14.986   212.508     0.200
    15.031   212.207     0.200
    15.031   212.715     0.200
    15.010   212.629     0.200
    15.132   213.902     0.200
    15.099   213.477     0.200
    15.102   213.648     0.200
    15.428   216.047     0.200
    15.474   218.918     0.200
    15.599   220.020     0.200
    15.588   219.477     0.200
    15.673   221.973     0.200
    15.635   220.430     0.200
    15.733   222.109     0.200
    15.733   222.859     0.200
    15.713   222.137     0.200
    16.003   224.227     0.200
    16.208   227.027     0.200
    16.217   226.969     0.200
    16.232   227.609     0.200
    16.232   228.965     0.200
    16.330   228.758     0.200
    16.286   227.219     0.200
    16.286   230.387     0.200
    16.532   231.777     0.200
    16.739   234.719     0.200
    16.766   234.629     0.200
    16.952   237.098     0.200
    17.149   237.109     0.200
    17.237   241.398     0.200
    17.239   241.387     0.200
    17.485   243.059     0.200
    17.526   242.477     0.200
    17.517   241.906     0.200
    17.647   242.457     0.200
    17.831   246.578     0.200
    18.196   250.090     0.200
    18.463   256.879     0.200
    19.104   263.969     0.200
    19.156   264.449     0.200
    19.156   265.367     0.200
    19.336   266.449     0.200
    19.435   267.848     0.200
    19.435   268.320     0.200
    19.629   269.777     0.200
    20.275   277.434     0.200
    20.299   277.148     0.200
    20.299   278.453     0.200
    20.565   280.480     0.200
     1.023    17.496     0.200
     1.065    19.793     0.200
     1.239    22.434     0.200
     1.228    23.125     0.200
     1.352    24.094     0.200
     1.355    23.855     0.200
     1.379    24.043     0.200
     1.379    23.895     0.200
     1.460    25.535     0.200
     1.513    26.004     0.200
     1.564    26.633     0.200
     1.608    27.664     0.200
     1.601    27.285     0.200
     1.765    28.074     0.200
     1.841    31.066     0.200
     1.890    30.234     0.200
     1.955    30.934     0.200
     2.000    31.203     0.200
     2.136    34.586     0.200
     2.192    34.793     0.200
     2.201    35.473     0.200
     2.249    36.516     0.200
     2.303    36.605     0.200
     2.346    38.023     0.200
     2.460    39.684     0.200
     2.679    43.336     0.200
     2.723    43.074     0.200
     2.735    43.434     0.200
     2.858    45.934     0.200
     2.970    47.145     0.200
     3.129    49.473     0.200
     3.129    48.484     0.200
     3.373    52.035     0.200
     3.609    56.926     0.200
     3.718    57.203     0.200
     4.237    63.285     0.200
     4.325    64.523     0.200
     4.316    64.746     0.200
     4.710    70.176     0.200
     4.766    72.504     0.200
     5.039    74.566     0.200
     5.661    83.016     0.200
     5.660    84.215     0.200
     5.921    88.105     0.200
     6.168    90.406     0.200
     6.517    96.996     0.200
     9.464   135.895     0.200
     9.464   135.625     0.200
     0.943    17.061     0.200
     0.952    17.091     0.200
     1.201    21.661     0.200
     1.281    23.021     0.200
     1.318    23.891     0.200
     1.403    24.531     0.200
     1.441    25.561     0.200
     1.494    26.101     0.200
     1.534    27.041     0.200
     1.606    27.601     0.200
     1.694    28.851     0.200
     1.770    28.981     0.200
     2.073    33.371     0.200
     2.068    35.641     0.200
     2.189    36.671     0.200
     2.235    35.671     0.200
     2.655    42.521     0.200
     2.645    43.051     0.200
     2.690    42.331     0.200
     3.157    49.601     0.200
     3.302    51.041     0.200
     3.557    56.271     0.200
     4.175    64.991     0.200
     4.371    66.861     0.200
     4.684    71.101     0.200
     4.763    72.571     0.200
     4.989    74.801     0.200
     5.271    79.791     0.200
     5.593    82.841     0.200
     5.598    83.021     0.200
     5.693    84.981     0.200
     5.859    87.601     0.200
     6.117    90.971     0.200
     7.025   103.471     0.200
     1.298    21.105     0.200
     1.362    22.686     0.200
     1.395    21.785     0.200
     1.469    23.775     0.200
     1.564    25.216     0.200
     1.727    27.216     0.200
     2.141    34.006     0.200
     2.151    33.436     0.200
     2.189    34.315     0.200
     2.189    34.116     0.200
     2.214    34.785     0.200
     3.058    48.205     0.200
     5.875    86.510     0.200
     0.952    16.785     0.200
     0.994    18.176     0.200
     1.145    20.086     0.200
     1.389    23.705     0.200
     1.669    26.875     0.200
     2.068    33.680     0.200
     2.068    33.535     0.200
     2.110    34.826     0.200
     2.218    35.125     0.200
     2.149    34.025     0.200
     2.309    35.975     0.200
     3.751    57.436     0.200
     3.766    56.916     0.200
     5.892    87.564     0.200
     0.314     6.145     0.200
     1.327    20.906     0.200
     1.395    22.508     0.200
     1.474    23.758     0.200
     1.316    21.906     0.200
     1.316    22.055     0.200
     1.514    22.918     0.200
     1.369    21.617     0.200
     1.593    25.078     0.200
     1.593    24.965     0.200
     1.829    28.828     0.200
     1.717    26.707     0.200
     1.717    26.977     0.200
     2.213    33.637     0.200
     2.213    33.984     0.200
     2.377    36.016     0.200
     2.421    38.055     0.200
     2.463    37.168     0.200
     2.332    35.516     0.200
     2.706    40.258     0.200
     2.676    40.027     0.200
     2.927    42.527     0.200
     2.966    44.395     0.200
     2.981    44.270     0.200
     3.008    45.285     0.200
     3.008    45.137     0.200
     3.112    45.816     0.200
     3.165    47.688     0.200
     3.081    46.945     0.200
     3.081    46.555     0.200
     3.286    49.734     0.200
     3.328    49.344     0.200
     3.380    51.367     0.200
     3.301    48.305     0.200
     3.629    54.516     0.200
     3.682    55.445     0.200
     3.682    53.715     0.200
     3.690    54.957     0.200
     3.690    55.215     0.200
     3.690    54.637     0.200
     3.690    55.465     0.200
     3.956    57.719     0.200
     3.956    58.602     0.200
     3.956    62.465     0.200
     3.956    58.047     0.200
     3.955    58.688     0.200
     4.098    60.879     0.200
     4.279    61.188     0.200
     4.186    62.336     0.200
     4.462    66.355     0.200
     4.803    71.121     0.200
     4.906    73.098     0.200
     4.977    74.348     0.200
     5.043    74.805     0.200
     5.616    82.465     0.200
     5.712    84.336     0.200
     5.905    87.617     0.200
     5.905    88.055     0.200
     6.091    89.566     0.200
     6.037    88.785     0.200
     6.037    88.336     0.200
     6.276    93.168     0.200
     6.416    94.598     0.200
     6.487    94.965     0.200
     6.516    95.883     0.200
     6.505    95.875     0.200
     6.569    94.375     0.200
     6.946   102.965     0.200
     6.928   101.668     0.200
     6.984   103.027     0.200
     7.014   103.777     0.200
     6.947   105.703     0.200
     7.301   107.215     0.200
     7.484   108.055     0.200
     7.522   110.477     0.200
     7.588   111.395     0.200
     7.609   112.316     0.200
     7.556   112.477     0.200
     7.556   112.668     0.200
     7.786   116.125     0.200
     8.088   118.438     0.200
     8.031   115.395     0.200
     8.155   117.855     0.200
     8.155   117.332     0.200
     8.155   119.215     0.200
     8.284   120.625     0.200
     8.284   118.625     0.200
     8.327   121.965     0.200
     8.194   118.297     0.200
     8.194   121.145     0.200
     8.548   124.477     0.200
     8.546   124.047     0.200
     8.546   125.172     0.200
     8.546   125.707     0.200
     8.860   128.547     0.200
     8.914   128.965     0.200
     8.941   131.734     0.200
     9.139   132.977     0.200
     9.188   133.105     0.200
     9.240   132.348     0.200
     9.240   133.977     0.200
     9.972   147.555     0.200
    10.062   149.188     0.200
    10.106   146.867     0.200
    10.124   150.137     0.200
    10.124   147.004     0.200
    10.124   148.637     0.200
    10.449   153.938     0.200
    10.519   152.184     0.200
    10.634   155.207     0.200
    10.634   152.781     0.200
    10.747   156.246     0.200
    10.830   158.645     0.200
    10.783   155.637     0.200
    10.783   156.008     0.200
    10.842   158.965     0.200
    11.137   160.586     0.200
    11.217   161.996     0.200
    11.263   164.035     0.200
    11.699   169.266     0.200
    12.874   184.945     0.200
    12.875   184.465     0.200
    12.769   182.984     0.200
    12.769   185.945     0.200
    13.174   189.066     0.200
    13.174   187.117     0.200
    13.174   189.098     0.200
    13.453   193.223     0.200
    13.890   196.508     0.200
    13.856   194.496     0.200
    13.869   196.445     0.200
    14.300   201.996     0.200
    14.547   206.746     0.200
    14.562   206.418     0.200
    14.523   206.008     0.200
    14.580   206.418     0.200
    14.567   205.566     0.200
    14.844   209.867     0.200
    14.906   207.445     0.200
    15.028   213.078     0.200
    15.085   212.484     0.200
    15.276   213.836     0.200
    15.486   218.734     0.200
    15.476   217.527     0.200
    15.727   218.746     0.200
    15.882   222.895     0.200
    16.000   222.055     0.200
    15.959   224.305     0.200
    16.160   226.176     0.200
    16.522   230.195     0.200
    16.522   229.777     0.200
    17.046   236.188     0.200
    17.225   239.938     0.200
    18.298   252.156     0.200
    18.923   260.367     0.200
    19.431   267.176     0.200
    19.531   269.098     0.200
    19.880   273.168     0.200
    20.603   279.656     0.200
    20.631   280.918     0.200
    20.989   283.984     0.200
     1.106    19.414     0.200
     1.443    24.992     0.200
     1.517    25.562     0.200
     1.549    25.859     0.200
     1.549    26.094     0.200
     1.501    26.055     0.200
     1.664    28.258     0.200
     1.682    28.969     0.200
     1.699    28.273     0.200
     2.519    41.812     0.200
     3.205    49.180     0.200
     3.397    53.766     0.200
     4.029    61.734     0.200
     4.029    62.289     0.200
     4.187    66.758     0.200
     5.378    80.617     0.200
     5.677    84.984     0.200
     8.204   123.562     0.200
     9.247   135.984     0.200
     9.821   143.297     0.200
    12.368   181.086     0.200
     0.826    14.672     0.200
     1.214    19.734     0.200
     1.286    22.164     0.200
     1.378    23.633     0.200
     1.378    23.344     0.200
     1.416    24.195     0.200
     1.472    24.773     0.200
     1.490    25.109     0.200
     1.525    25.992     0.200
     1.518    24.977     0.200
     1.518    25.188     0.200
     1.590    26.016     0.200
     1.595    26.305     0.200
     1.646    28.617     0.200
     1.652    27.484     0.200
     1.652    28.188     0.200
     1.756    28.977     0.200
     1.729    27.078     0.200
     1.769    29.219     0.200
     1.814    29.984     0.200
     1.896    32.062     0.200
     1.972    31.727     0.200
     2.030    32.633     0.200
     2.049    32.312     0.200
     2.070    33.438     0.200
     2.139    33.375     0.200
     2.157    34.039     0.200
     2.216    34.344     0.200
     2.216    35.406     0.200
     2.239    35.289     0.200
     2.239    36.289     0.200
     2.247    36.672     0.200
     2.268    35.828     0.200
     2.323    36.031     0.200
     2.434    38.984     0.200
     2.434    38.719     0.200
     2.505    39.484     0.200
     2.535    39.555     0.200
     2.625    41.406     0.200
     2.646    41.039     0.200
     2.716    41.594     0.200
     2.807    43.883     0.200
     2.818    44.039     0.200
     3.062    47.828     0.200
     3.062    47.562     0.200
     3.071    47.414     0.200
     3.174    48.906     0.200
     3.178    48.570     0.200
     3.185    48.766     0.200
     3.185    48.602     0.200
     3.185    50.938     0.200
     3.185    49.422     0.200
     3.205    49.086     0.200
     3.198    48.445     0.200
     3.198    49.500     0.200
     3.198    48.219     0.200
     3.198    48.727     0.200
     3.310    51.094     0.200
     3.484    52.812     0.200
     3.484    52.625     0.200
     3.582    53.812     0.200
     3.733    56.688     0.200
     3.754    56.117     0.200
     3.925    59.539     0.200
     4.060    60.586     0.200
     4.081    60.898     0.200
     4.108    62.477     0.200
     4.147    64.352     0.200
     4.174    62.789     0.200
     4.259    65.430     0.200
     4.253    64.812     0.200
     4.307    65.133     0.200
     4.284    63.406     0.200
     4.478    67.023     0.200
     4.572    68.078     0.200
     4.610    69.445     0.200
     4.629    69.758     0.200
     4.704    69.492     0.200
     4.769    71.383     0.200
     4.769    71.625     0.200
     5.010    74.898     0.200
     5.066    75.789     0.200
     5.066    76.406     0.200
     5.141    77.906     0.200
     5.181    76.547     0.200
     5.289    79.609     0.200
     5.385    79.688     0.200
     5.426    80.477     0.200
     5.508    82.953     0.200
     5.522    81.805     0.200
     5.547    83.172     0.200
     5.547    83.344     0.200
     5.612    83.383     0.200
     5.698    86.320     0.200
     5.685    84.523     0.200
     5.685    83.969     0.200
     5.820    86.484     0.200
     5.820    87.523     0.200
     5.840    86.383     0.200
     6.014    88.359     0.200
     6.063    90.758     0.200
     6.076    89.953     0.200
     6.269    94.117     0.200
     6.277    94.352     0.200
     6.445    98.289     0.200
     6.488    95.203     0.200
     6.488    97.133     0.200
     6.535    96.484     0.200
     6.584    95.547     0.200
     6.608    97.648     0.200
     6.643    98.812     0.200
     6.708    98.336     0.200
     6.732    98.406     0.200
     6.872   101.906     0.200
     6.872   103.836     0.200
     7.034   102.562     0.200
     7.138   103.984     0.200
     7.187   106.367     0.200
     7.378   106.547     0.200
     7.378   108.023     0.200
     7.440   107.836     0.200
     7.460   109.273     0.200
     7.484   109.328     0.200
     7.528   109.812     0.200
     7.594   111.156     0.200
     7.594   110.492     0.200
     7.602   111.938     0.200
     7.602   111.438     0.200
     7.602   113.203     0.200
     7.630   112.562     0.200
     7.644   112.492     0.200
     7.702   112.516     0.200
     7.694   112.578     0.200
     7.735   110.312     0.200
     7.775   114.016     0.200
     7.775   114.312     0.200
     7.775   115.062     0.200
     7.913   115.492     0.200
     7.942   115.289     0.200
     7.947   117.273     0.200
     7.998   116.766     0.200
     8.010   117.398     0.200
     8.051   117.523     0.200
     8.099   117.188     0.200
     8.099   122.016     0.200
     8.145   118.203     0.200
     8.251   119.758     0.200
     8.281   119.695     0.200
     8.336   122.812     0.200
     8.336   123.672     0.200
     8.352   120.094     0.200
     8.540   125.883     0.200
     8.590   123.695     0.200
     8.599   124.289     0.200
     8.606   125.805     0.200
     8.629   124.727     0.200
     8.885   128.039     0.200
     8.882   129.359     0.200
     8.928   128.125     0.200
     9.068   129.125     0.200
     9.156   131.977     0.200
     9.142   132.875     0.200
     9.165   133.094     0.200
     9.203   132.125     0.200
     9.209   133.016     0.200
     9.209   132.633     0.200
     9.209   135.398     0.200
     9.265   132.523     0.200
     9.297   135.016     0.200
     9.298   135.156     0.200
     9.298   134.859     0.200
     9.506   136.062     0.200
     9.616   137.148     0.200
     9.633   138.016     0.200
     9.682   137.727     0.200
     9.720   139.453     0.200
     9.720   144.148     0.200
     9.840   141.414     0.200
     9.833   141.469     0.200
     9.833   143.531     0.200
     9.828   142.188     0.200
     9.886   141.648     0.200
     9.914   142.609     0.200
    10.022   145.516     0.200
    10.106   146.133     0.200
    10.106   148.109     0.200
    10.160   146.109     0.200
    10.160   147.883     0.200
    10.299   147.594     0.200
    10.299   149.219     0.200
    10.313   147.188     0.200
    10.349   148.359     0.200
    10.460   149.258     0.200
    10.500   151.516     0.200
    10.763   159.266     0.200
    10.763   153.758     0.200
    10.783   154.156     0.200
    10.855   155.078     0.200
    10.975   157.617     0.200
    10.988   158.578     0.200
    11.210   162.242     0.200
    11.210   164.883     0.200
    11.215   163.062     0.200
    11.881   170.422     0.200
    11.900   171.344     0.200
    11.968   171.047     0.200
    11.968   175.562     0.200
    12.285   175.422     0.200
    12.285   178.562     0.200
    12.326   175.258     0.200
    12.388   176.508     0.200
    12.388   176.383     0.200
    12.411   177.914     0.200
    12.464   177.148     0.200
    12.423   178.328     0.200
    12.423   179.367     0.200
    12.445   178.086     0.200
    12.502   178.805     0.200
    12.502   178.695     0.200
    12.506   178.922     0.200
    12.506   179.586     0.200
    12.591   179.555     0.200
    12.663   181.555     0.200
    12.698   181.859     0.200
    12.704   182.062     0.200
    12.751   182.117     0.200
    12.823   182.469     0.200
    12.820   184.148     0.200
    12.831   183.398     0.200
    12.896   184.047     0.200
    12.984   185.219     0.200
    13.032   187.453     0.200
    13.044   185.062     0.200
    13.008   186.922     0.200
    13.097   185.414     0.200
    13.180   191.734     0.200
    13.495   193.219     0.200
    13.495   193.367     0.200
    13.856   197.062     0.200
    13.936   197.375     0.200
    13.943   197.617     0.200
    13.981   198.969     0.200
    13.996   198.164     0.200
    14.029   198.547     0.200
    14.173   201.758     0.200
    14.184   200.375     0.200
    14.184   202.344     0.200
    14.280   202.164     0.200
    14.295   203.523     0.200
    14.295   204.602     0.200
    14.351   202.008     0.200
    14.343   203.727     0.200
    14.364   203.953     0.200
    14.412   204.383     0.200
    14.404   205.219     0.200
    14.484   205.375     0.200
    14.558   205.703     0.200
    14.565   207.148     0.200
    14.588   206.727     0.200
    14.588   207.039     0.200
    14.567   207.688     0.200
    14.677   208.344     0.200
    14.677   207.352     0.200
    14.684   208.055     0.200
    14.722   209.625     0.200
    15.339   217.398     0.200
    15.898   226.055     0.200
    16.129   228.477     0.200
    16.498   231.594     0.200
    16.498   232.008     0.200
    16.569   233.734     0.200
    16.665   233.969     0.200
    16.747   235.383     0.200
    16.726   236.719     0.200
    16.809   235.805     0.200
    17.305   241.102     0.200
    17.711   248.016     0.200
    19.012   264.484     0.200
    20.029   274.953     0.200
    20.175   276.227     0.200
    20.543   281.516     0.200
     0.924    16.531     0.200
     1.136    20.281     0.200
     1.452    25.281     0.200
     1.503    26.531     0.200
     1.553    26.430     0.200
     1.693    29.141     0.200
     1.656    28.352     0.200
     1.813    30.828     0.200
     1.854    30.938     0.200
     1.867    30.633     0.200
     1.931    32.289     0.200
     2.012    34.539     0.200
     2.187    35.594     0.200
     2.187    34.969     0.200
     2.268    36.703     0.200
     2.322    37.641     0.200
     2.322    38.000     0.200
     2.326    38.547     0.200
     2.325    35.758     0.200
     2.377    38.664     0.200
     2.438    39.055     0.200
     2.530    41.250     0.200
     2.530    40.461     0.200
     2.604    41.000     0.200
     2.638    41.820     0.200
     2.734    43.922     0.200
     2.749    44.508     0.200
     2.749    44.320     0.200
     2.829    45.242     0.200
     2.914    46.227     0.200
     2.925    45.836     0.200
     3.165    49.211     0.200
     3.165    49.953     0.200
     3.161    50.242     0.200
     3.206    52.102     0.200
     3.206    51.930     0.200
     3.206    50.797     0.200
     3.290    52.258     0.200
     3.293    50.883     0.200
     3.300    53.000     0.200
     3.300    50.867     0.200
     3.300    54.492     0.200
     3.322    50.781     0.200
     3.365    52.297     0.200
     3.428    54.023     0.200
     3.386    55.367     0.200
     3.691    57.664     0.200
     3.863    60.062     0.200
     4.166    64.148     0.200
     4.175    64.742     0.200
     4.222    66.328     0.200
     4.292    67.234     0.200
     4.419    68.555     0.200
     4.680    70.562     0.200
     4.727    71.859     0.200
     4.818    73.844     0.200
     4.887    74.328     0.200
     4.887    73.461     0.200
     5.058    76.922     0.200
     5.144    78.320     0.200
     5.144    77.320     0.200
     5.303    79.523     0.200
     5.295    79.609     0.200
     5.503    82.844     0.200
     5.622    84.359     0.200
     5.601    85.008     0.200
     5.601    85.312     0.200
     5.640    84.641     0.200
     5.726    86.625     0.200
     5.706    85.320     0.200
     5.676    86.359     0.200
     5.676    85.922     0.200
     5.935    87.711     0.200
     5.935    89.164     0.200
     5.947    87.133     0.200
     6.117    90.406     0.200
     6.168    93.180     0.200
     6.176    91.406     0.200
     6.193    91.633     0.200
     6.390    95.688     0.200
     6.552    98.070     0.200
     6.606    97.422     0.200
     6.640    97.711     0.200
     6.680    98.656     0.200
     6.711    99.531     0.200
     6.824   100.852     0.200
     6.850   101.672     0.200
     6.885   103.320     0.200
     7.152   104.492     0.200
     7.284   107.188     0.200
     7.493   109.844     0.200
     7.493   111.688     0.200
     7.546   110.609     0.200
     7.592   109.477     0.200
     7.565   113.727     0.200
     7.625   112.203     0.200
     7.728   113.688     0.200
     7.743   112.906     0.200
     7.838   114.133     0.200
     7.838   115.867     0.200
     7.905   116.672     0.200
     8.053   117.148     0.200
     8.110   117.523     0.200
     8.128   117.820     0.200
     8.343   122.250     0.200
     8.470   123.789     0.200
     8.525   124.438     0.200
     8.546   124.617     0.200
     8.549   123.008     0.200
     8.598   124.578     0.200
     8.619   125.688     0.200
     8.625   124.789     0.200
     8.695   126.133     0.200
     8.717   126.039     0.200
     8.744   125.258     0.200
     8.733   127.539     0.200
     8.757   128.211     0.200
     8.765   127.930     0.200
     8.848   128.641     0.200
     9.096   132.578     0.200
     9.274   133.102     0.200
     9.254   134.078     0.200
     9.239   135.500     0.200
     9.240   136.070     0.200
     9.240   136.273     0.200
     9.312   136.812     0.200
     9.833   140.367     0.200
     9.980   144.094     0.200
     9.997   145.977     0.200
    10.196   148.203     0.200
    12.067   172.430     0.200
    12.439   175.547     0.200
    12.382   177.500     0.200
    12.532   177.852     0.200
    12.579   177.891     0.200
    12.689   180.102     0.200
    12.938   184.133     0.200
    12.931   184.359     0.200
    13.014   183.977     0.200
    13.083   186.039     0.200
    13.492   192.078     0.200
    13.492   193.945     0.200
    14.082   200.758     0.200
    14.208   201.148     0.200
    14.403   203.633     0.200
    14.780   208.477     0.200
    14.780   209.227     0.200
    15.153   212.547     0.200
    15.110   213.578     0.200
    15.208   214.781     0.200
    15.414   217.281     0.200
    15.414   219.398     0.200
    15.600   219.508     0.200
    15.826   223.531     0.200
    15.856   223.883     0.200
    15.990   224.547     0.200
    16.085   225.344     0.200
    16.139   227.570     0.200
    16.215   227.047     0.200
    16.328   230.000     0.200
    16.865   235.469     0.200
    16.898   236.828     0.200
    17.206   239.141     0.200
    17.316   240.820     0.200
    17.357   241.500     0.200
    17.406   241.969     0.200
    18.927   263.156     0.200
    19.099   266.102     0.200
    20.167   277.195     0.200
     0.995    17.313     0.200
     1.177    21.333     0.200
     1.177    21.173     0.200
     1.763    29.473     0.200
     2.601    41.523     0.200
     1.112    19.288     0.200
     1.228    22.358     0.200
     1.338    22.868     0.200
     1.453    25.538     0.200
     1.533    26.978     0.200
     1.813    30.748     0.200
     2.219    36.958     0.200
     2.873    43.598     0.200
     3.076    49.098     0.200
     3.159    51.268     0.200
     3.262    51.468     0.200
     3.597    56.218     0.200
     3.723    58.788     0.200
     5.086    76.028     0.200
     5.619    84.908     0.200
     7.727   113.762     0.200
     8.915   130.393     0.200
     1.336    24.923     0.200
     1.396    25.263     0.200
     1.472    26.152     0.200
     1.472    25.492     0.200
     1.472    25.612     0.200
     1.490    25.862     0.200
     1.563    26.992     0.200
     1.552    27.412     0.200
     1.545    26.503     0.200
     1.638    28.562     0.200
     1.798    29.232     0.200
     1.812    30.503     0.200
     1.908    29.393     0.200
     1.911    31.833     0.200
     1.976    31.723     0.200
     2.027    32.883     0.200
     2.027    33.587     0.200
     2.067    33.303     0.200
     2.062    33.923     0.200
     2.225    36.123     0.200
     2.225    34.952     0.200
     2.290    37.412     0.200
     2.312    38.263     0.200
     2.384    38.394     0.200
     2.467    39.713     0.200
     2.545    40.543     0.200
     2.608    41.612     0.200
     2.838    44.572     0.200
     2.838    45.438     0.200
     2.882    45.942     0.200
     2.924    44.976     0.200
     2.931    45.513     0.200
     2.931    44.958     0.200
     2.931    47.212     0.200
     2.946    45.937     0.200
     3.049    47.473     0.200
     3.202    47.849     0.200
     3.202    52.303     0.200
     3.339    51.520     0.200
     3.484    53.570     0.200
     3.514    53.982     0.200
     3.664    56.319     0.200
     3.827    59.893     0.200
     3.913    58.920     0.200
     3.945    61.940     0.200
     4.041    63.306     0.200
     4.060    61.512     0.200
     4.123    64.229     0.200
     4.220    63.553     0.200
     4.218    63.527     0.200
     4.336    66.973     0.200
     4.349    66.087     0.200
     4.454    68.213     0.200
     4.479    69.887     0.200
     4.507    67.513     0.200
     4.507    68.930     0.200
     4.529    68.393     0.200
     4.646    71.362     0.200
     4.879    76.744     0.200
     4.901    74.293     0.200
     4.901    75.465     0.200
     4.915    74.513     0.200
     4.929    73.263     0.200
     5.031    78.969     0.200
     5.218    80.063     0.200
     5.369    81.906     0.200
     5.411    81.562     0.200
     5.438    83.162     0.200
     5.437    84.791     0.200
     5.506    83.459     0.200
     5.566    85.376     0.200
     5.580    85.688     0.200
     5.602    83.633     0.200
     5.717    85.532     0.200
     5.717    86.218     0.200
     5.717    85.213     0.200
     5.789    87.143     0.200
     5.859    88.753     0.200
     5.869    89.994     0.200
     6.009    90.021     0.200
     6.026    91.459     0.200
     6.138    91.833     0.200
     6.226    91.587     0.200
     6.307    93.702     0.200
     6.374    95.652     0.200
     6.384    95.293     0.200
     6.544    94.980     0.200
     6.614    98.032     0.200
     6.596    94.857     0.200
     6.712    99.912     0.200
     6.953   102.583     0.200
     7.105   104.822     0.200
     7.124   104.190     0.200
     7.338   108.338     0.200
     7.559   110.293     0.200
     7.559   113.992     0.200
     7.642   113.303     0.200
     7.642   113.542     0.200
     7.642   115.192     0.200
     7.668   113.242     0.200
     7.668   111.173     0.200
     7.668   113.393     0.200
     7.700   112.373     0.200
     8.049   119.282     0.200
     8.050   118.583     0.200
     8.398   122.503     0.200
     8.414   122.612     0.200
     8.596   128.152     0.200
     8.596   127.272     0.200
     8.740   131.043     0.200
     8.740   132.062     0.200
     8.945   129.411     0.200
     8.981   130.987     0.200
     8.981   134.572     0.200
     9.471   142.918     0.200
     9.735   143.103     0.200
     9.735   139.651     0.200
     9.917   144.333     0.200
    10.086   147.923     0.200
    10.087   144.133     0.200
    10.122   146.072     0.200
    10.122   143.653     0.200
    10.129   148.022     0.200
    10.129   147.433     0.200
    10.545   156.902     0.200
    10.740   155.027     0.200
    11.077   160.862     0.200
    11.214   160.948     0.200
    11.647   171.572     0.200
    11.750   169.917     0.200
    11.751   166.853     0.200
    11.751   172.272     0.200
    12.082   173.209     0.200
    12.082   173.152     0.200
    12.082   178.242     0.200
    12.260   174.343     0.200
    12.260   175.932     0.200
    12.260   179.393     0.200
    12.299   174.773     0.200
    12.521   181.513     0.200
    12.521   179.431     0.200
    12.561   180.172     0.200
    13.265   189.463     0.200
    13.315   191.253     0.200
    13.315   190.904     0.200
    13.486   194.543     0.200
    13.486   195.793     0.200
    13.510   192.333     0.200
    13.510   191.681     0.200
    13.510   195.562     0.200
    13.630   195.022     0.200
    13.686   195.583     0.200
    14.121   199.215     0.200
    14.258   203.253     0.200
    14.383   204.908     0.200
    14.379   202.772     0.200
    14.379   203.691     0.200
    14.410   205.812     0.200
    14.410   206.062     0.200
    14.450   204.362     0.200
    14.450   205.262     0.200
    14.840   210.202     0.200
    15.086   214.053     0.200
    15.177   215.753     0.200
    15.177   215.954     0.200
    15.462   220.272     0.200
    15.530   218.782     0.200
    15.796   223.853     0.200
    15.839   224.103     0.200
    15.997   225.293     0.200
    16.132   228.691     0.200
    16.449   230.996     0.200
    16.796   236.770     0.200
    17.086   239.583     0.200
    17.086   239.315     0.200
    17.094   239.486     0.200
    17.675   247.683     0.200
    17.739   246.532     0.200
    17.739   246.250     0.200
    17.857   249.901     0.200
    19.790   272.902     0.200
    19.958   274.601     0.200
    20.141   276.651     0.200
    20.281   278.731     0.200
     1.250    21.604     0.200
     1.467    25.533     0.200
     1.498    25.434     0.200
     1.583    26.184     0.200
     1.631    27.594     0.200
     1.623    26.903     0.200
     1.877    30.033     0.200
     1.963    30.653     0.200
     2.026    31.684     0.200
     2.089    33.724     0.200
     2.263    36.424     0.200
     2.330    37.193     0.200
     2.355    36.943     0.200
     2.533    41.823     0.200
     2.881    45.123     0.200
     2.940    46.894     0.200
     2.988    47.424     0.200
     2.988    47.207     0.200
     3.218    50.153     0.200
     3.564    53.943     0.200
     3.892    61.073     0.200
     4.019    61.693     0.200
     4.332    64.974     0.200
     4.660    70.354     0.200
     4.955    75.563     0.200
     5.321    80.104     0.200
     5.481    82.833     0.200
     5.651    83.844     0.200
     5.727    84.943     0.200
     5.853    87.764     0.200
     6.436    95.913     0.200
     7.588   112.857     0.200
     7.690   113.304     0.200
     7.900   120.249     0.200
     9.032   133.123     0.200
     9.242   134.054     0.200
     9.416   137.363     0.200
    12.463   182.741     0.200
    18.768   260.203     0.200
     1.021    17.139     0.200
     1.546    24.958     0.200
     1.622    26.648     0.200
     1.950    30.438     0.200
     2.180    35.198     0.200
     2.241    36.198     0.200
     5.566    80.599     0.200
     1.135    20.125     0.200
     1.182    22.035     0.200
     1.182    20.855     0.200
     1.184    20.617     0.200
     1.264    23.535     0.200
     1.330    24.105     0.200
     1.318    24.234     0.200
     1.424    25.758     0.200
     1.479    26.324     0.200
     1.520    27.234     0.200
     1.520    27.625     0.200
     1.574    27.117     0.200
     1.596    27.656     0.200
     1.672    28.047     0.200
     1.672    27.746     0.200
     1.732    29.895     0.200
     1.748    28.785     0.200
     1.938    32.895     0.200
     2.050    34.516     0.200
     2.050    34.168     0.200
     2.111    34.406     0.200
     2.178    35.816     0.200
     2.254    37.047     0.200
     2.646    42.965     0.200
     2.670    43.336     0.200
     3.175    50.266     0.200
     3.280    51.484     0.200
     3.550    56.395     0.200
     3.785    59.945     0.200
     4.164    62.438     0.200
     4.627    70.848     0.200
     4.687    68.887     0.200
     4.773    71.965     0.200
     4.964    75.215     0.200
     4.973    74.996     0.200
     5.159    79.637     0.200
     5.517    84.574     0.200
     5.578    85.227     0.200
     5.593    86.168     0.200
     5.711    85.324     0.200
     5.848    89.305     0.200
     6.489    97.348     0.200
     6.833   102.707     0.200
     7.415   110.246     0.200
     8.118   118.676     0.200
     1.851    29.578     0.200
     1.866    28.688     0.200
     1.866    29.289     0.200
     2.269    36.910     0.200
     2.335    35.020     0.200
     3.183    51.340     0.200
     4.182    63.949     0.200
     1.103    18.441     0.200
     1.226    21.320     0.200
     1.595    26.500     0.200
     1.540    26.531     0.200
     1.725    29.422     0.200
     2.030    33.832     0.200
     2.386    37.801     0.200
     2.462    38.172     0.200
     2.702    43.102     0.200
     2.818    43.941     0.200
     3.021    48.859     0.200
     3.219    50.543     0.200
     3.220    49.441     0.200
     3.220    50.133     0.200
     3.313    52.699     0.200
     3.498    52.762     0.200
     4.289    66.223     0.200
     4.346    66.652     0.200
     4.624    70.422     0.200
     4.868    76.520     0.200
     5.011    76.383     0.200
     5.088    75.633     0.200
     5.138    77.852     0.200
     5.274    78.473     0.200
     5.500    85.242     0.200
     5.659    84.762     0.200
     5.816    88.383     0.200
     5.841    85.902     0.200
     5.863    87.223     0.200
     6.133    91.762     0.200
     6.131    92.449     0.200
     6.291    94.152     0.200
     6.344    95.512     0.200
     6.393    95.180     0.200
     6.445    93.609     0.200
     6.568    96.980     0.200
     6.694    99.223     0.200
     6.816   101.633     0.200
     6.843   102.320     0.200
     6.884   101.699     0.200
     7.051   102.980     0.200
     7.353   109.641     0.200
     7.457   109.691     0.200
     7.447   111.473     0.200
     7.687   112.230     0.200
     7.689   114.242     0.200
     7.773   112.570     0.200
     7.830   112.859     0.200
     7.893   115.871     0.200
     7.970   116.051     0.200
     8.418   128.219     0.200
     8.787   127.973     0.200
     9.014   132.211     0.200
     9.138   130.277     0.200
     9.475   140.262     0.200
     9.582   139.742     0.200
     9.823   146.109     0.200
    10.023   147.121     0.200
    12.533   180.777     0.200
    12.776   185.711     0.200
    13.751   197.422     0.200
    13.988   201.180     0.200
    14.399   206.961     0.200
    14.604   206.621     0.200
    14.641   207.191     0.200
    14.738   206.902     0.200
    15.678   219.660     0.200
     1.067    19.449     0.200
     1.317    23.102     0.200
     1.330    22.961     0.200
     1.582    25.852     0.200
     2.008    33.121     0.200
     2.320    38.281     0.200
     6.908   101.918     0.200
     7.771   114.145     0.200
     8.927   133.500     0.200
     8.886   129.145     0.200
    12.926   188.512     0.200
     1.667    28.375     0.200
     1.667    28.215     0.200
     1.684    28.238     0.200
     1.662    29.215     0.200
     1.868    31.656     0.200
     1.934    31.996     0.200
     1.863    30.746     0.200
     1.921    32.906     0.200
     2.011    32.246     0.200
     2.306    37.926     0.200
     2.736    42.926     0.200
     2.754    43.277     0.200
     3.260    51.508     0.200
     3.490    54.438     0.200
     3.490    54.586     0.200
     3.775    57.406     0.200
     1.363    24.125     0.200
     1.474    25.320     0.200
     1.512    26.273     0.200
     1.512    26.445     0.200
     1.793    29.773     0.200
     1.793    30.352     0.200
     2.073    34.625     0.200
     2.189    37.305     0.200
     2.330    36.758     0.200
     2.399    38.594     0.200
     2.595    41.375     0.200
     2.842    44.297     0.200
     2.893    46.094     0.200
     2.968    46.516     0.200
     3.121    48.844     0.200
     3.354    56.008     0.200
     3.553    55.406     0.200
     3.624    56.062     0.200
     3.873    60.203     0.200
     3.899    58.625     0.200
     3.899    59.836     0.200
     4.387    66.562     0.200
     5.541    80.516     0.200
     5.824    87.258     0.200
     6.444    96.688     0.200
     6.903   102.016     0.200
     7.379   109.211     0.200
     7.552   111.805     0.200
     7.609   114.141     0.200
     7.997   118.086     0.200
     8.088   119.211     0.200
     8.167   117.242     0.200
     8.877   131.164     0.200
     9.158   135.352     0.200
     9.219   135.734     0.200
     9.219   135.438     0.200
    10.490   152.375     0.200
    10.558   155.391     0.200
    14.480   203.688     0.200
    14.832   207.156     0.200
    14.932   209.602     0.200
    15.423   217.305     0.200
    16.228   227.672     0.200
    16.576   230.820     0.200
    16.610   232.203     0.200
    16.692   231.336     0.200
    16.700   232.203     0.200
    16.817   233.734     0.200
    16.871   234.711     0.200
    16.914   234.391     0.200
    16.980   237.062     0.200
    17.547   243.227     0.200
    17.603   244.055     0.200
    18.133   250.320     0.200
    20.411   279.016     0.200
     1.202    19.512     0.200
     1.435    23.793     0.200
     1.435    23.953     0.200
     1.464    23.742     0.200
     1.464    23.555     0.200
     1.566    26.102     0.200
     1.861    30.492     0.200
     2.149    34.582     0.200
     2.101    36.543     0.200
     2.384    36.582     0.200
     2.386    37.262     0.200
     2.191    36.234     0.200
     2.574    39.715     0.200
     2.885    45.305     0.200
     2.903    45.371     0.200
     3.030    48.305     0.200
     3.120    47.402     0.200
     2.999    49.012     0.200
     3.553    55.684     0.200
     3.541    53.453     0.200
     3.541    52.012     0.200
     3.841    58.781     0.200
     3.939    59.672     0.200
     3.939    59.512     0.200
     4.321    65.305     0.200
     4.440    67.484     0.200
     4.772    71.531     0.200
     4.894    73.172     0.200
     5.569    82.352     0.200
     5.778    86.602     0.200
     5.890    87.371     0.200
     6.392    95.324     0.200
     6.502    97.984     0.200
     6.718    98.824     0.200
     6.829   101.562     0.200
     6.880   102.402     0.200
     6.982   102.703     0.200
     6.959   100.738     0.200
     7.226   106.562     0.200
     7.218   105.953     0.200
     7.227   105.633     0.200
     7.293   105.691     0.200
     7.466   108.172     0.200
     7.566   114.273     0.200
     7.900   115.812     0.200
     8.006   115.781     0.200
     8.006   115.887     0.200
     8.408   120.934     0.200
     8.905   129.969     0.200
     8.893   129.973     0.200
     9.164   131.012     0.200
     9.061   131.934     0.200
     9.245   131.832     0.200
     9.122   132.621     0.200
     9.123   132.762     0.200
     9.123   132.492     0.200
    10.557   154.191     0.200
    11.220   161.113     0.200
    13.435   193.090     0.200
    15.225   214.242     0.200
    15.330   216.332     0.200
    15.609   220.004     0.200
    15.588   220.992     0.200
    16.028   223.805     0.200
    16.897   236.023     0.200
     1.078    19.457     0.200
     1.261    22.197     0.200
     1.261    22.977     0.200
     1.545    26.986     0.200
     1.648    29.607     0.200
     1.648    30.598     0.200
     1.983    33.688     0.200
     2.157    35.717     0.200
     2.503    40.996     0.200
     2.534    41.707     0.200
     2.557    41.188     0.200
     2.774    43.496     0.200
     2.855    42.236     0.200
     3.141    50.396     0.200
     3.158    53.547     0.200
     3.157    49.047     0.200
     3.284    51.496     0.200
     3.284    51.227     0.200
     3.431    54.146     0.200
     4.140    63.217     0.200
     4.193    64.637     0.200
     4.394    67.598     0.200
     4.468    68.447     0.200
     4.677    71.688     0.200
     5.230    79.537     0.200
     5.386    80.598     0.200
     5.981    91.047     0.200
     6.218    92.418     0.200
     6.412    95.467     0.200
     6.464    97.627     0.200
     6.594    99.076     0.200
     6.733    99.816     0.200
     6.815   102.246     0.200
     6.962   104.557     0.200
     6.970   103.668     0.200
     7.054   104.406     0.200
     7.139   105.277     0.200
     7.221   106.746     0.200
     7.310   106.701     0.200
     7.535   111.566     0.200
     7.566   111.977     0.200
     7.734   115.018     0.200
     7.734   115.176     0.200
     7.804   114.906     0.200
     7.807   115.197     0.200
     7.837   115.307     0.200
     8.044   119.646     0.200
     8.769   128.617     0.200
     8.783   127.986     0.200
     8.803   130.338     0.200
     8.872   132.207     0.200
     8.953   130.947     0.200
     9.017   132.447     0.200
     9.126   135.066     0.200
     9.127   134.387     0.200
     9.127   133.781     0.200
     9.518   138.566     0.200
     9.975   146.838     0.200
    10.363   150.906     0.200
    11.733   168.918     0.200
    12.314   177.527     0.200
    12.471   179.957     0.200
    12.844   182.107     0.200
    12.922   186.008     0.200
    14.521   206.277     0.200
    14.859   210.746     0.200
    15.468   218.557     0.200
    15.605   220.787     0.200
    16.632   234.688     0.200
    16.663   236.156     0.200
    17.161   240.807     0.200
     1.512    25.805     0.200
     1.583    27.320     0.200
     1.583    27.617     0.200
     1.745    29.156     0.200
     1.883    31.766     0.200
     1.897    33.820     0.200
     1.939    32.977     0.200
     1.923    32.594     0.200
     2.034    32.789     0.200
     2.092    34.305     0.200
     2.479    40.180     0.200
     2.467    40.148     0.200
     2.532    38.797     0.200
     2.601    42.859     0.200
     2.702    43.750     0.200
     2.702    43.555     0.200
     2.678    43.398     0.200
     2.782    44.078     0.200
     3.067    48.344     0.200
     3.225    49.266     0.200
     3.225    48.953     0.200
     3.225    53.859     0.200
     3.279    50.266     0.200
     3.373    52.938     0.200
     3.519    55.438     0.200
     3.519    54.992     0.200
     3.519    55.109     0.200
     3.745    59.734     0.200
     3.745    55.805     0.200
     3.959    59.555     0.200
     3.959    59.688     0.200
     3.979    60.180     0.200
     3.979    59.336     0.200
     4.063    62.938     0.200
     4.215    63.609     0.200
     4.269    63.750     0.200
     4.399    66.680     0.200
     4.680    70.141     0.200
     4.784    75.438     0.200
     4.878    74.078     0.200
     5.057    76.125     0.200
     5.117    77.695     0.200
     5.202    78.484     0.200
     5.316    79.594     0.200
     5.876    86.930     0.200
     6.142    92.039     0.200
     6.151    91.844     0.200
     6.401    95.227     0.200
     6.351    93.297     0.200
     6.430    94.938     0.200
     6.485    97.398     0.200
     6.615    97.273     0.200
     6.775   101.828     0.200
     6.775   105.734     0.200
     6.965   102.789     0.200
     7.051   103.516     0.200
     7.384   109.477     0.200
     7.389   110.492     0.200
     7.389   110.680     0.200
     7.559   110.164     0.200
     7.559   110.820     0.200
     7.723   113.234     0.200
     7.723   113.492     0.200
     7.723   112.617     0.200
     7.723   114.039     0.200
     7.826   114.234     0.200
     7.870   115.031     0.200
     7.992   117.875     0.200
     7.992   115.984     0.200
     7.992   118.508     0.200
     8.006   117.430     0.200
     8.006   119.398     0.200
     8.242   119.648     0.200
     8.312   122.570     0.200
     8.312   123.234     0.200
     8.450   127.070     0.200
     8.515   127.734     0.200
     8.738   126.484     0.200
     8.830   128.719     0.200
     8.830   129.266     0.200
     9.032   131.969     0.200
     9.052   131.688     0.200
     9.170   131.773     0.200
     9.170   133.523     0.200
     9.542   138.695     0.200
     9.558   142.945     0.200
     9.970   145.289     0.200
    10.021   145.180     0.200
    10.071   146.078     0.200
    10.071   147.219     0.200
    10.316   149.438     0.200
    11.086   164.297     0.200
    11.188   161.219     0.200
    11.389   164.797     0.200
    11.439   164.070     0.200
    11.773   168.148     0.200
    12.290   180.617     0.200
    12.347   176.305     0.200
    12.347   177.469     0.200
    12.592   177.203     0.200
    12.592   179.648     0.200
    12.592   182.094     0.200
    12.995   185.227     0.200
    13.005   188.734     0.200
    12.992   186.266     0.200
    12.992   188.156     0.200
    12.992   189.430     0.200
    13.213   191.953     0.200
    13.535   192.688     0.200
    13.535   193.219     0.200
    13.622   193.555     0.200
    13.645   194.875     0.200
    13.840   196.945     0.200
    14.027   200.117     0.200
    14.160   201.141     0.200
    14.198   202.188     0.200
    14.260   200.609     0.200
    14.326   202.898     0.200
    14.591   210.297     0.200
    14.695   206.617     0.200
    14.670   211.625     0.200
    14.810   209.086     0.200
    14.902   210.867     0.200
    14.899   210.430     0.200
    14.863   212.953     0.200
    15.819   222.430     0.200
    15.827   223.734     0.200
    15.895   222.273     0.200
    16.229   227.727     0.200
    16.445   231.008     0.200
    16.622   233.117     0.200
    16.688   234.648     0.200
    17.107   239.773     0.200
    17.102   238.758     0.200
    17.379   242.195     0.200
    17.728   246.641     0.200
    17.730   247.086     0.200
    18.075   250.695     0.200
    18.086   250.734     0.200
    18.270   251.977     0.200
    18.959   265.055     0.200
    19.143   268.953     0.200
    19.271   270.547     0.200
    19.301   268.359     0.200
    19.322   269.625     0.200
    19.462   271.539     0.200
    19.601   272.766     0.200
    19.936   275.859     0.200
    20.027   276.625     0.200
    20.403   287.148     0.200
    20.456   288.430     0.200
     0.987    17.953     0.200
     1.097    19.641     0.200
     1.157    20.980     0.200
     1.157    20.902     0.200
     1.342    23.633     0.200
     1.318    23.840     0.200
     1.496    26.242     0.200
     1.422    25.230     0.200
     1.474    25.781     0.200
     1.651    27.191     0.200
     1.539    26.672     0.200
     1.561    26.320     0.200
     1.588    26.633     0.200
     1.677    27.832     0.200
     1.746    27.590     0.200
     1.797    30.242     0.200
     1.887    31.910     0.200
     1.875    30.520     0.200
     2.020    34.402     0.200
     2.020    34.191     0.200
     2.080    34.512     0.200
     2.094    34.531     0.200
     2.154    35.551     0.200
     2.199    36.383     0.200
     2.235    37.020     0.200
     2.260    36.090     0.200
     2.402    38.312     0.200
     2.498    40.582     0.200
     2.693    42.531     0.200
     2.693    42.910     0.200
     2.751    44.043     0.200
     3.262    50.242     0.200
     3.283    51.371     0.200
     3.641    55.840     0.200
     3.931    62.113     0.200
     3.931    60.961     0.200
     3.893    60.230     0.200
     4.102    62.551     0.200
     4.242    64.391     0.200
     4.269    66.230     0.200
     4.459    67.781     0.200
     4.714    71.043     0.200
     4.698    70.250     0.200
     4.793    71.742     0.200
     4.879    74.660     0.200
     5.026    80.082     0.200
     5.039    78.090     0.200
     5.260    82.301     0.200
     5.610    86.281     0.200
     5.641    84.551     0.200
     5.690    88.070     0.200
     5.926    90.051     0.200
     5.989    92.633     0.200
     6.235    91.461     0.200
     6.231    97.301     0.200
     6.535   101.211     0.200
     6.645   100.680     0.200
     6.642   102.363     0.200
     6.872   103.520     0.200
     6.907   105.121     0.200
     7.053   105.422     0.200
     7.141   106.430     0.200
     7.249   111.000     0.200
     7.499   109.480     0.200
     7.568   113.320     0.200
     7.568   112.602     0.200
     7.568   112.723     0.200
     7.568   111.441     0.200
     7.563   110.723     0.200
     7.600   114.871     0.200
     7.600   114.766     0.200
     7.778   113.750     0.200
     7.899   118.781     0.200
     7.934   119.832     0.200
     8.182   122.961     0.200
     8.158   121.293     0.200
     8.193   122.492     0.200
     8.205   120.000     0.200
     8.207   121.980     0.200
     8.217   124.152     0.200
     8.272   123.691     0.200
     8.279   124.391     0.200
     8.279   124.422     0.200
     8.385   124.922     0.200
     8.434   125.863     0.200
     8.448   127.312     0.200
     8.831   131.012     0.200
     9.261   138.262     0.200
     9.391   139.621     0.200
     9.592   142.762     0.200
     9.593   142.891     0.200
     9.593   141.266     0.200
    10.373   153.070     0.200
    11.956   174.621     0.200
    12.164   178.910     0.200
    12.439   180.031     0.200
    13.586   194.902     0.200
    14.319   204.570     0.200
    14.664   211.941     0.200
    15.110   215.762     0.200
    20.100   276.301     0.200
     1.104    19.012     0.200
     1.104    20.250     0.200
     1.149    21.832     0.200
     1.151    20.082     0.200
     1.336    22.949     0.200
     1.495    25.730     0.200
     1.579    26.520     0.200
     1.670    27.430     0.200
     1.670    27.059     0.200
     1.789    29.352     0.200
     1.883    30.250     0.200
     2.015    33.359     0.200
     2.015    33.242     0.200
     2.074    33.930     0.200
     2.088    34.262     0.200
     2.251    36.109     0.200
     2.396    38.070     0.200
     2.684    40.141     0.200
     2.744    43.840     0.200
     3.633    55.621     0.200
     4.461    67.219     0.200
     4.714    72.309     0.200
     4.787    70.910     0.200
     5.253    79.570     0.200
     5.364    78.621     0.200
     5.602    84.820     0.200
     5.682    84.180     0.200
     5.917    88.070     0.200
     6.643    98.629     0.200
     6.987   104.609     0.200
     7.134   106.121     0.200
     0.946    16.090     0.200
     1.039    18.350     0.200
     1.112    19.520     0.200
     1.112    19.389     0.200
     1.112    19.996     0.200
     1.169    19.539     0.200
     1.170    19.939     0.200
     1.170    20.270     0.200
     1.353    22.230     0.200
     1.331    22.459     0.200
     1.491    24.900     0.200
     1.503    24.939     0.200
     1.428    24.059     0.200
     1.487    24.539     0.200
     1.551    25.270     0.200
     1.574    25.480     0.200
     1.599    26.180     0.200
     1.690    26.889     0.200
     1.809    28.840     0.200
     1.897    30.430     0.200
     2.032    32.580     0.200
     2.032    33.311     0.200
     2.106    33.580     0.200
     2.270    36.459     0.200
     2.706    40.990     0.200
     2.757    43.389     0.200
     3.296    49.389     0.200
     3.257    49.629     0.200
     3.257    49.490     0.200
     3.650    56.449     0.200
     3.895    58.939     0.200
     4.451    66.369     0.200
     4.709    70.820     0.200
     4.798    72.900     0.200
     4.879    74.129     0.200
     5.038    73.799     0.200
     5.050    75.369     0.200
     5.267    78.799     0.200
     5.619    83.920     0.200
     5.653    81.010     0.200
     5.698    85.230     0.200
     6.985   101.270     0.200
     7.147   105.980     0.200
     7.566   111.520     0.200
     7.771   112.059     0.200
     7.906   114.330     0.200
     8.162   119.719     0.200
     8.167   118.949     0.200
     8.210   116.629     0.200
     1.083    19.145     0.200
     1.118    19.824     0.200
     1.113    19.664     0.200
     1.304    21.955     0.200
     1.493    24.875     0.200
     1.475    24.914     0.200
     1.401    22.904     0.200
     1.548    25.295     0.200
     1.634    26.484     0.200
     1.855    29.725     0.200
     1.983    32.744     0.200
     1.983    32.205     0.200
     2.041    33.096     0.200
     2.224    35.275     0.200
     2.649    40.355     0.200
     2.730    42.176     0.200
     3.240    47.285     0.200
     3.277    48.705     0.200
     3.609    55.654     0.200
     3.882    57.895     0.200
     4.204    62.334     0.200
     4.484    68.414     0.200
     4.776    71.584     0.200
     4.875    72.426     0.200
     5.235    78.715     0.200
     5.579    83.285     0.200
     5.661    85.125     0.200
     1.063    18.535     0.200
     1.063    18.766     0.200
     1.275    21.516     0.200
     1.528    25.945     0.200
     1.624    28.125     0.200
     1.624    27.785     0.200
     1.642    28.045     0.200
     2.061    34.416     0.200
     2.622    41.715     0.200
     2.720    42.846     0.200
     2.907    45.406     0.200
     2.930    47.285     0.200
     2.928    45.645     0.200
     3.151    48.816     0.200
     3.220    50.455     0.200
     3.245    51.266     0.200
     3.245    51.035     0.200
     3.341    51.885     0.200
     3.408    53.096     0.200
     3.614    56.215     0.200
     3.780    58.566     0.200
     3.780    58.215     0.200
     3.879    59.895     0.200
     4.172    64.305     0.200
     4.211    64.246     0.200
     4.211    63.949     0.200
     4.465    68.336     0.200
     4.680    71.066     0.200
     5.085    76.695     0.200
     5.100    77.906     0.200
     5.217    77.486     0.200
     5.856    88.285     0.200
     5.867    89.115     0.200
     5.856    88.215     0.200
     6.099    92.686     0.200
     6.190    89.295     0.200
     6.639   100.916     0.200
     6.668   100.236     0.200
     6.723   102.045     0.200
     6.726   101.105     0.200
     6.850   101.965     0.200
     7.162   107.795     0.200
     7.213   108.676     0.200
     7.206   107.215     0.200
     7.270   109.105     0.200
     7.441   110.455     0.200
     7.453   110.166     0.200
     7.306   109.256     0.200
     7.510   111.045     0.200
     7.551   113.316     0.200
     7.592   111.475     0.200
     7.687   112.785     0.200
     7.769   114.605     0.200
     7.864   116.406     0.200
     7.984   117.695     0.200
     8.123   116.635     0.200
     8.033   121.506     0.200
     8.245   119.605     0.200
     8.245   120.416     0.200
     8.245   119.875     0.200
     8.245   120.250     0.200
     8.255   118.775     0.200
     8.567   123.965     0.200
     8.644   124.285     0.200
     8.710   125.186     0.200
     8.995   132.625     0.200
     9.106   130.326     0.200
     9.199   132.072     0.200
     9.127   133.805     0.200
     9.151   133.506     0.200
     9.152   133.516     0.200
     9.152   131.266     0.200
     9.227   136.246     0.200
     9.376   134.066     0.200
     9.428   135.545     0.200
     9.455   136.816     0.200
     9.383   138.105     0.200
     9.479   135.285     0.200
     9.449   134.525     0.200
     9.940   142.086     0.200
     9.932   144.455     0.200
    10.215   149.055     0.200
    10.447   152.266     0.200
    10.884   157.156     0.200
    11.304   164.035     0.200
    12.722   183.875     0.200
    13.389   194.436     0.200
    13.389   189.586     0.200
    14.598   209.846     0.200
    14.773   209.816     0.200
    14.815   210.945     0.200
    15.118   213.375     0.200
    15.113   215.986     0.200
    15.896   226.256     0.200
    16.296   228.365     0.200
    16.554   233.926     0.200
    16.932   235.596     0.200
    17.134   237.756     0.200
    17.223   241.426     0.200
    18.026   251.055     0.200
    18.078   249.215     0.200
    18.098   251.695     0.200
    18.324   252.355     0.200
    19.440   268.326     0.200
    19.426   269.355     0.200
    19.662   270.105     0.200
    20.501   280.496     0.200
    20.531   280.455     0.200
     1.285    21.371     0.200
     1.579    25.633     0.200
     1.656    27.973     0.200
     1.658    27.941     0.200
     1.813    28.803     0.200
     2.095    34.701     0.200
     2.095    34.281     0.200
     2.340    37.812     0.200
     2.660    41.611     0.200
     2.921    45.611     0.200
     2.921    44.633     0.200
     2.958    45.791     0.200
     3.193    48.893     0.200
     3.269    48.691     0.200
     3.279    51.062     0.200
     3.445    53.393     0.200
     3.819    59.133     0.200
     3.929    59.973     0.200
     4.222    63.742     0.200
     4.253    64.320     0.200
     4.490    68.082     0.200
     4.717    71.312     0.200
     5.134    77.291     0.200
     5.901    87.912     0.200
     5.917    88.492     0.200
     6.149    92.553     0.200
     6.718   100.352     0.200
     7.267   108.941     0.200
     8.283   120.096     0.200
     8.695   126.803     0.200
     9.013   132.322     0.200
     9.158   133.762     0.200
     9.158   132.178     0.200
     9.244   136.352     0.200
     9.949   144.963     0.200
    10.300   147.723     0.200
    10.457   152.121     0.200
    10.934   158.693     0.200
    11.318   164.053     0.200
    13.440   193.652     0.200
     0.852    14.836     0.200
     1.288    22.562     0.200
     1.307    21.789     0.200
     1.456    24.984     0.200
     1.450    24.688     0.200
     1.592    26.734     0.200
     1.593    25.180     0.200
     1.877    29.586     0.200
     1.979    32.117     0.200
     2.036    32.742     0.200
     2.117    34.539     0.200
     2.316    37.383     0.200
     2.357    37.406     0.200
     2.494    39.312     0.200
     2.574    41.195     0.200
     2.590    40.508     0.200
     2.617    42.016     0.200
     3.212    48.688     0.200
     3.498    51.906     0.200
     3.733    56.242     0.200
     3.775    57.898     0.200
     3.951    59.805     0.200
     4.008    58.695     0.200
     3.971    60.273     0.200
     4.020    61.156     0.200
     4.149    63.125     0.200
     4.446    66.094     0.200
     4.665    70.125     0.200
     4.665    70.836     0.200
     4.762    70.578     0.200
     4.777    71.555     0.200
     4.898    73.078     0.200
     4.899    73.328     0.200
     5.121    78.695     0.200
     5.278    79.336     0.200
     5.467    81.555     0.200
     5.507    82.188     0.200
     5.548    84.227     0.200
     5.785    86.758     0.200
     5.980    86.195     0.200
     6.063    88.539     0.200
     6.412    93.203     0.200
     6.574    95.844     0.200
     6.767   100.383     0.200
     6.799    98.758     0.200
     6.920   101.359     0.200
     6.909   100.648     0.200
     7.005   102.930     0.200
     7.356   107.695     0.200
     7.443   107.938     0.200
     7.754   113.414     0.200
     7.806   114.648     0.200
     8.002   116.086     0.200
     8.065   116.984     0.200
     8.075   115.953     0.200
     8.079   118.789     0.200
     8.080   114.609     0.200
     8.104   117.695     0.200
     1.235    20.605     0.200
     1.256    23.225     0.200
     1.307    23.234     0.200
     1.317    25.074     0.200
     1.541    27.266     0.200
     7.513   114.064     0.200
     7.889   120.650     0.200
     9.360   135.869     0.200
     9.503   141.096     0.200
    12.461   181.783     0.200
     1.330    23.826     0.200
     1.330    23.928     0.200
     1.452    24.996     0.200
     1.515    24.477     0.200
     1.581    26.717     0.200
     1.878    31.336     0.200
     2.166    35.727     0.200
     2.084    35.207     0.200
     2.275    36.277     0.200
     2.179    36.678     0.200
     2.262    38.008     0.200
     3.047    47.598     0.200
     2.983    47.277     0.200
     3.137    49.086     0.200
     3.295    54.146     0.200
     3.538    55.787     0.200
     3.635    56.518     0.200
     3.936    61.777     0.200
     5.299    80.527     0.200
     6.053    88.467     0.200
     1.109    20.183     0.200
     1.088    18.342     0.200
     1.225    20.902     0.200
     1.371    23.192     0.200
     1.376    22.962     0.200
     1.439    24.053     0.200
     1.636    26.162     0.200
     2.089    32.612     0.200
     2.192    35.763     0.200
     2.352    37.572     0.200
     2.552    40.322     0.200
     2.544    39.143     0.200
     2.601    41.252     0.200
     2.619    40.992     0.200
     2.686    41.922     0.200
     3.126    46.763     0.200
     3.244    48.103     0.200
     3.698    56.013     0.200
     4.595    66.853     0.200
     0.975    17.426     0.200
     0.981    17.957     0.200
     0.997    17.797     0.200
     1.229    22.637     0.200
     1.456    25.625     0.200
     1.468    25.297     0.200
     1.605    28.605     0.200
     1.587    27.707     0.200
     1.649    27.445     0.200
     1.658    27.125     0.200
     1.771    31.266     0.200
     1.818    30.625     0.200
     1.851    32.387     0.200
     1.902    31.375     0.200
     1.948    34.023     0.200
     1.983    32.637     0.200
     2.291    37.363     0.200
     2.339    38.105     0.200
     2.348    38.113     0.200
     2.348    37.906     0.200
     2.573    41.727     0.200
     2.573    41.414     0.200
     2.651    41.945     0.200
     2.804    44.566     0.200
     2.939    46.707     0.200
     3.022    47.746     0.200
     3.082    48.875     0.200
     3.184    50.535     0.200
     3.217    50.145     0.200
     3.276    51.934     0.200
     3.280    51.055     0.200
     3.280    49.195     0.200
     3.370    53.863     0.200
     3.348    53.316     0.200
     3.348    52.625     0.200
     3.378    52.426     0.200
     3.425    54.305     0.200
     3.926    60.227     0.200
     3.937    61.395     0.200
     4.037    61.484     0.200
     4.114    64.957     0.200
     4.977    75.305     0.200
     5.256    80.516     0.200
     5.730    86.094     0.200
     5.822    88.895     0.200
     6.292    94.875     0.200
     7.608   111.855     0.200
     7.710   114.504     0.200
     7.710   114.363     0.200
     7.934   116.695     0.200
     8.165   120.207     0.200
     8.310   125.609     0.200
     8.627   127.215     0.200
     9.122   133.797     0.200
     9.253   134.762     0.200
     9.253   135.504     0.200
     9.943   147.109     0.200
    10.042   146.273     0.200
    10.167   148.246     0.200
    10.415   151.914     0.200
    10.473   152.164     0.200
    11.081   161.516     0.200
    11.288   163.594     0.200
    12.493   184.137     0.200
    13.556   195.137     0.200
    14.291   204.656     0.200
    15.046   214.406     0.200
    15.501   218.875     0.200
    15.526   220.645     0.200
    18.900   262.816     0.200
     1.013    18.062     0.200
     1.003    18.145     0.200
     1.272    21.773     0.200
     1.464    26.285     0.200
     1.498    25.926     0.200
     1.535    26.355     0.200
     1.553    26.965     0.200
     1.646    28.074     0.200
     1.702    28.402     0.200
     1.700    28.766     0.200
     1.780    29.773     0.200
     1.787    30.145     0.200
     1.806    32.203     0.200
     1.844    31.293     0.200
     1.893    32.914     0.200
     1.893    31.293     0.200
     1.939    32.273     0.200
     2.020    33.055     0.200
     2.334    37.883     0.200
     2.380    38.926     0.200
     2.380    39.504     0.200
     2.609    42.215     0.200
     2.609    42.414     0.200
     2.609    42.555     0.200
     2.688    42.984     0.200
     2.842    45.266     0.200
     2.980    47.234     0.200
     3.065    48.605     0.200
     3.123    50.516     0.200
     3.223    52.223     0.200
     3.254    51.465     0.200
     3.287    51.895     0.200
     3.287    50.574     0.200
     3.287    51.453     0.200
     3.311    52.355     0.200
     3.315    52.414     0.200
     3.412    53.965     0.200
     3.420    55.805     0.200
     3.468    54.984     0.200
     4.019    61.363     0.200
     4.019    61.613     0.200
     5.287    81.254     0.200
     5.737    87.836     0.200
     6.329    95.926     0.200
     6.879   102.242     0.200
     7.600   112.016     0.200
     7.600   110.523     0.200
     7.721   113.332     0.200
     7.721   115.684     0.200
     7.721   114.805     0.200
     7.921   117.375     0.200
     8.689   130.445     0.200
     8.876   130.883     0.200
     9.234   135.113     0.200
     9.234   134.945     0.200
     9.466   142.152     0.200
     9.985   144.590     0.200
    10.036   148.676     0.200
    10.142   150.305     0.200
    10.305   151.703     0.200
    10.458   152.445     0.200
    10.521   155.113     0.200
    11.015   163.164     0.200
    11.230   164.074     0.200
    12.169   179.203     0.200
    12.529   179.562     0.200
    12.766   186.973     0.200
    13.557   194.883     0.200
    13.557   195.086     0.200
    15.555   221.633     0.200
    15.655   223.145     0.200
    15.871   225.902     0.200
     0.765    13.178     0.200
     0.777    13.798     0.200
     0.935    15.708     0.200
     0.970    16.518     0.200
     1.030    17.228     0.200
     1.029    17.728     0.200
     1.117    19.208     0.200
     1.194    20.348     0.200
     1.210    20.208     0.200
     1.210    20.027     0.200
     1.217    19.468     0.200
     1.265    20.758     0.200
     1.274    21.128     0.200
     1.279    22.027     0.200
     1.337    21.888     0.200
     1.351    22.138     0.200
     1.382    25.138     0.200
     1.388    22.947     0.200
     1.394    22.607     0.200
     1.471    24.288     0.200
     1.485    23.817     0.200
     1.515    25.438     0.200
     1.531    24.298     0.200
     1.574    26.567     0.200
     1.608    25.447     0.200
     1.632    24.808     0.200
     1.800    29.027     0.200
     1.845    29.508     0.200
     1.895    30.317     0.200
     1.946    30.638     0.200
     2.000    30.628     0.200
     2.050    32.107     0.200
     2.067    32.938     0.200
     2.081    31.897     0.200
     2.110    33.208     0.200
     2.253    34.888     0.200
     2.230    33.867     0.200
     2.272    35.998     0.200
     2.326    35.758     0.200
     2.407    36.897     0.200
     2.470    38.008     0.200
     2.491    37.447     0.200
     2.506    38.526     0.200
     2.506    37.848     0.200
     2.521    39.018     0.200
     2.535    38.708     0.200
     2.607    40.958     0.200
     2.859    43.518     0.200
     3.030    46.447     0.200
     3.114    46.498     0.200
     3.228    51.008     0.200
     3.232    48.907     0.200
     3.270    49.538     0.200
     3.270    49.357     0.200
     3.458    52.857     0.200
     3.615    54.107     0.200
     3.680    54.208     0.200
     3.743    58.308     0.200
     3.785    57.897     0.200
     3.933    57.808     0.200
     3.935    58.308     0.200
     4.095    60.607     0.200
     4.095    60.907     0.200
     4.491    66.768     0.200
     4.519    67.697     0.200
     4.556    66.838     0.200
     4.662    70.527     0.200
     4.791    73.848     0.200
     4.802    72.067     0.200
     4.946    73.228     0.200
     5.801    86.208     0.200
     7.401   107.808     0.200
     7.401   107.647     0.200
     7.450   110.777     0.200
     7.450   110.308     0.200
     7.525   110.552     0.200
     7.525   110.008     0.200
     7.525   111.808     0.200
     7.823   113.758     0.200
     7.823   112.987     0.200
     7.823   113.928     0.200
     8.249   120.407     0.200
     8.432   125.252     0.200
     8.432   120.038     0.200
     8.616   128.128     0.200
     8.682   125.918     0.200
     9.032   133.718     0.200
     9.032   131.348     0.200
     9.089   130.577     0.200
     9.089   132.277     0.200
     9.561   137.638     0.200
     9.684   139.683     0.200
     9.869   143.128     0.200
    10.196   148.088     0.200
    10.196   149.728     0.200
    10.432   147.478     0.200
    10.832   156.748     0.200
    10.881   158.777     0.200
    10.881   158.498     0.200
    11.216   163.958     0.200
    11.404   166.628     0.200
    11.761   168.907     0.200
    11.761   169.367     0.200
    11.864   173.258     0.200
    11.969   174.336     0.200
    12.227   174.848     0.200
    12.302   176.018     0.200
    12.445   179.197     0.200
    12.710   179.038     0.200
    13.320   189.188     0.200
    13.562   192.808     0.200
    13.562   195.708     0.200
    13.868   196.447     0.200
    13.868   196.048     0.200
    13.868   201.098     0.200
    13.880   193.938     0.200
    14.042   197.107     0.200
    14.555   205.678     0.200
    14.553   204.407     0.200
    14.848   206.478     0.200
    14.908   211.258     0.200
    14.927   211.548     0.200
    15.138   216.378     0.200
    15.575   217.867     0.200
    15.596   217.298     0.200
    15.610   217.348     0.200
    15.855   220.737     0.200
    16.089   227.508     0.200
    16.127   224.447     0.200
    16.185   228.147     0.200
    16.749   230.388     0.200
    16.953   237.048     0.200
    17.595   243.098     0.200
    17.953   246.938     0.200
    17.954   246.938     0.200
    17.948   247.718     0.200
    18.245   250.258     0.200
    18.272   251.458     0.200
    18.305   252.327     0.200
    18.467   257.018     0.200
    18.491   257.147     0.200
    18.573   259.027     0.200
    18.584   259.567     0.200
    18.620   258.388     0.200
    18.671   258.867     0.200
    18.722   259.268     0.200
    19.092   264.407     0.200
    19.123   266.088     0.200
    19.142   263.958     0.200
    19.143   264.518     0.200
    19.189   265.418     0.200
    19.506   267.548     0.200
    20.186   277.617     0.200
    20.186   275.378     0.200
    20.222   277.168     0.200
    20.383   278.348     0.200
    20.385   278.058     0.200
    20.496   279.758     0.200
    20.812   283.638     0.200
    20.932   284.748     0.200
     1.019    17.744     0.200
     1.882    30.693     0.200
     1.929    31.354     0.200
     1.719    27.375     0.200
     1.805    29.508     0.200
     1.805    29.094     0.200
     2.077    33.867     0.200
     2.639    41.016     0.200
     2.739    42.383     0.200
     2.921    47.188     0.200
     2.921    42.414     0.200
     2.926    45.414     0.200
     2.945    45.703     0.200
     3.036    47.359     0.200
     3.240    48.508     0.200
     3.629    54.766     0.200
     3.912    60.297     0.200
     4.229    61.703     0.200
     4.229    62.359     0.200
     4.697    69.484     0.200
     5.472    79.430     0.200
     6.444    94.695     0.200
     6.742    99.758     0.200
     7.181   104.117     0.200
     7.232   103.516     0.200
     7.267   104.484     0.200
     7.611   111.297     0.200
     7.707   112.523     0.200
     8.257   118.922     0.200
     9.030   132.609     0.200
     9.128   133.086     0.200
     9.150   131.852     0.200
     9.150   133.930     0.200
     9.175   132.469     0.200
     9.217   132.336     0.200
     9.373   135.656     0.200
     9.472   137.273     0.200
     9.935   145.469     0.200
    10.268   147.227     0.200
    10.725   153.906     0.200
    10.881   158.594     0.200
    10.903   161.500     0.200
    10.903   153.539     0.200
    11.015   155.469     0.200
    11.209   159.547     0.200
    11.306   164.383     0.200
    11.916   169.859     0.200
    12.442   179.906     0.200
    13.119   183.898     0.200
    13.143   188.445     0.200
    13.364   190.484     0.200
    13.408   191.430     0.200
    13.602   191.414     0.200
    13.685   193.867     0.200
    13.861   196.375     0.200
    13.904   197.375     0.200
    13.984   197.383     0.200
    14.024   197.836     0.200
    13.978   196.453     0.200
    14.269   204.289     0.200
    14.349   203.898     0.200
    14.497   205.945     0.200
    14.605   207.359     0.200
    14.636   206.008     0.200
    14.792   208.805     0.200
    14.820   209.547     0.200
    14.825   208.773     0.200
    14.984   210.617     0.200
    15.004   211.766     0.200
    15.120   213.977     0.200
    15.090   211.164     0.200
    15.237   215.984     0.200
    15.479   217.234     0.200
    15.433   217.414     0.200
    15.532   219.227     0.200
    15.724   221.828     0.200
    15.897   223.555     0.200
    17.038   238.109     0.200
    17.260   240.984     0.200
    18.527   258.523     0.200
    18.981   263.586     0.200
    19.959   273.758     0.200
     1.038    19.625     0.200
     1.189    21.180     0.200
     1.323    23.836     0.200
     1.410    24.422     0.200
     1.364    23.648     0.200
     1.483    25.836     0.200
     1.538    25.414     0.200
     1.579    26.562     0.200
     1.721    28.062     0.200
     1.964    32.016     0.200
     2.087    34.359     0.200
     2.256    36.469     0.200
     2.236    35.734     0.200
     2.317    36.953     0.200
     2.448    38.836     0.200
     2.724    42.891     0.200
     2.714    42.586     0.200
     2.691    42.562     0.200
     2.826    44.664     0.200
     3.174    49.516     0.200
     3.605    55.492     0.200
     3.818    58.984     0.200
     4.727    71.812     0.200
     4.798    72.852     0.200
     5.032    74.312     0.200
     5.208    78.625     0.200
     5.570    82.398     0.200
     5.638    81.703     0.200
     5.645    82.719     0.200
     6.086    90.750     0.200
     6.165    92.430     0.200
     1.466    24.520     0.200
     2.005    32.809     0.200
     1.581    27.640     0.200
     1.583    29.180     0.200
     1.640    27.640     0.200
     1.696    30.360     0.200
     1.861    31.220     0.200
     1.886    31.300     0.200
     1.919    31.780     0.200
     1.919    31.580     0.200
     2.021    32.390     0.200
     2.021    31.700     0.200
     2.338    38.270     0.200
     2.593    41.800     0.200
     2.665    41.970     0.200
     2.665    42.670     0.200
     2.789    46.440     0.200
     2.711    45.580     0.200
     2.962    46.550     0.200
     3.055    48.050     0.200
     3.210    50.350     0.200
     3.209    50.960     0.200
     3.406    52.390     0.200
     3.428    52.710     0.200
     3.519    54.170     0.200
     3.726    57.130     0.200
     3.726    57.800     0.200
     3.799    58.760     0.200
     3.890    60.520     0.200
     4.067    62.240     0.200
     4.154    64.130     0.200
     4.152    64.710     0.200
     4.189    64.110     0.200
     4.288    65.170     0.200
     4.318    64.920     0.200
     4.464    67.530     0.200
     4.464    70.625     0.200
     4.464    71.271     0.200
     4.499    68.780     0.200
     4.542    69.170     0.200
     4.640    70.520     0.200
     5.006    76.270     0.200
     5.140    78.390     0.200
     5.177    80.880     0.200
     5.428    82.850     0.200
     5.530    83.720     0.200
     5.848    86.850     0.200
     5.860    87.560     0.200
     5.951    88.750     0.200
     6.173    94.280     0.200
     6.173    91.680     0.200
     6.436    96.869     0.200
     6.582    97.730     0.200
     6.688    98.800     0.200
     6.838   101.800     0.200
     7.081   104.460     0.200
     7.252   107.380     0.200
     7.307   107.550     0.200
     7.486   110.050     0.200
     7.573   110.660     0.200
     7.598   112.000     0.200
     7.598   113.255     0.200
     7.764   115.060     0.200
     7.764   116.093     0.200
     7.786   115.250     0.200
     8.181   120.531     0.200
     8.181   119.270     0.200
     8.181   120.900     0.200
     8.327   122.970     0.200
     8.361   121.890     0.200
     8.737   127.040     0.200
     8.737   130.380     0.200
     8.832   128.570     0.200
     8.919   130.390     0.200
     8.923   130.580     0.200
     8.923   131.162     0.200
     8.923   130.400     0.200
     9.435   140.605     0.200
     9.461   136.390     0.200
    10.373   150.300     0.200
    10.502   151.700     0.200
    10.502   155.510     0.200
    10.634   154.190     0.200
    11.068   161.100     0.200
    11.068   164.080     0.200
    12.025   176.385     0.200
    12.150   175.867     0.200
    12.290   178.443     0.200
    13.226   191.309     0.200
    13.263   193.594     0.200
    13.493   191.610     0.200
    13.493   193.702     0.200
    13.493   192.230     0.200
    13.836   201.470     0.200
    13.961   201.607     0.200
    14.456   205.280     0.200
    14.979   212.700     0.200
    15.117   215.350     0.200
    15.139   216.510     0.200
    15.170   217.050     0.200
    15.247   217.240     0.200
    15.283   218.460     0.200
    15.334   216.400     0.200
    15.358   218.470     0.200
    15.444   218.520     0.200
    15.579   222.030     0.200
    15.685   222.250     0.200
    15.685   223.363     0.200
    16.001   226.130     0.200
    16.204   230.090     0.200
    16.388   231.290     0.200
    16.388   232.413     0.200
    16.424   231.880     0.200
    16.518   232.990     0.200
    17.048   239.620     0.200
    17.666   246.060     0.200
    18.125   251.650     0.200
    18.335   255.040     0.200
    18.466   256.480     0.200
    18.697   261.338     0.200
    18.697   262.991     0.200
    19.642   272.480     0.200
    20.958   290.080     0.200
     1.351    23.414     0.200
     1.757    27.875     0.200
     1.783    29.684     0.200
     1.991    33.555     0.200
     2.029    34.184     0.200
     2.771    43.035     0.200
     3.289    51.812     0.200
     3.398    52.934     0.200
     3.539    54.145     0.200
     3.878    58.023     0.200
     5.160    78.332     0.200
     5.823    86.805     0.200
     1.127    19.025     0.200
     1.164    19.226     0.200
     1.164    19.436     0.200
     1.687    27.916     0.200
     2.100    34.565     0.200
     3.218    49.635     0.200
     3.469    52.055     0.200
     1.749    28.635     0.200
     1.775    29.385     0.200
     2.626    40.025     0.200
     2.779    40.465     0.200
     3.371    52.236     0.200
     5.831    86.416     0.200
     1.002    18.287     0.200
     1.050    18.328     0.200
     1.077    18.898     0.200
     1.221    21.719     0.200
     1.216    23.059     0.200
     1.358    23.059     0.200
     1.341    23.188     0.200
     1.387    23.047     0.200
     1.595    27.047     0.200
     1.593    26.027     0.200
     1.749    27.287     0.200
     2.118    33.318     0.200
     2.174    33.008     0.200
     2.245    35.828     0.200
     2.286    35.889     0.200
     2.646    40.787     0.200
     2.683    42.309     0.200
     2.727    42.207     0.200
     2.749    44.098     0.200
     2.847    44.508     0.200
     2.938    45.178     0.200
     3.357    51.729     0.200
     3.548    53.059     0.200
     3.608    55.707     0.200
     3.804    57.027     0.200
     3.803    57.047     0.200
     4.357    65.117     0.200
     4.529    67.508     0.200
     4.716    70.877     0.200
     5.032    75.457     0.200
     5.204    78.578     0.200
     5.572    83.318     0.200
     5.678    82.797     0.200
     5.645    84.889     0.200
     5.741    85.457     0.200
     5.871    87.707     0.200
     5.916    88.617     0.200
     5.958    88.207     0.200
     8.084   117.957     0.200
     1.470    25.177     0.200
     1.612    27.317     0.200
     1.668    28.297     0.200
     1.714    28.927     0.200
     1.714    28.787     0.200
     1.726    29.147     0.200
     1.783    28.837     0.200
     2.532    40.127     0.200
     2.623    41.447     0.200
     3.282    49.577     0.200
     3.431    53.877     0.200
     3.687    57.477     0.200
     4.225    63.436     0.200
     8.151   119.886     0.200
     9.058   131.908     0.200
    13.332   192.617     0.200
     1.721    28.396     0.200
     2.570    41.186     0.200
     3.230    50.396     0.200
     3.323    53.286     0.200
     0.951    17.475     0.200
     1.026    18.176     0.200
     1.026    18.336     0.200
     1.471    25.666     0.200
     1.191    20.492     0.200
     1.191    21.922     0.200
     1.573    28.562     0.200
     1.559    27.992     0.200
     2.665    42.227     0.200
     1.500    25.770     0.200
     1.500    25.211     0.200
     1.523    27.438     0.200
     1.843    30.008     0.200
     1.910    29.809     0.200
     2.627    42.148     0.200
     2.705    44.551     0.200
     3.250    49.770     0.200
     1.094    19.094     0.200
     1.526    26.016     0.200
     1.579    26.895     0.200
     1.563    26.734     0.200
     1.656    28.426     0.200
     1.913    30.887     0.200
     1.913    31.484     0.200
     1.969    33.523     0.200
     1.887    33.004     0.200
     2.056    33.324     0.200
     2.395    38.145     0.200
     2.461    39.387     0.200
     2.691    42.953     0.200
     2.691    43.875     0.200
     2.769    43.496     0.200
     2.923    45.637     0.200
     3.034    47.934     0.200
     3.132    48.625     0.200
     3.233    53.605     0.200
     3.233    51.637     0.200
     3.251    50.574     0.200
     3.251    51.035     0.200
     3.304    51.113     0.200
     3.336    52.324     0.200
     3.487    53.836     0.200
     3.496    53.477     0.200
     3.496    55.367     0.200
     3.529    54.145     0.200
     3.545    54.754     0.200
     3.630    56.887     0.200
     3.632    56.727     0.200
     3.936    59.613     0.200
     3.927    60.305     0.200
     3.949    60.156     0.200
     4.046    61.797     0.200
     4.043    61.945     0.200
     3.995    64.574     0.200
     4.051    62.516     0.200
     4.198    64.344     0.200
     4.316    66.586     0.200
     4.364    66.727     0.200
     4.475    69.387     0.200
     4.607    70.934     0.200
     4.823    73.895     0.200
     4.861    74.363     0.200
     4.895    74.137     0.200
     4.957    75.797     0.200
     4.993    75.824     0.200
     5.168    77.895     0.200
     5.201    79.746     0.200
     5.300    80.824     0.200
     5.306    78.215     0.200
     5.397    81.266     0.200
     5.506    83.176     0.200
     5.690    85.523     0.200
     5.813    86.824     0.200
     5.827    87.395     0.200
     5.853    87.535     0.200
     6.363    93.297     0.200
     7.542   110.727     0.200
     7.714   113.984     0.200
     7.693   113.969     0.200
     7.693   113.363     0.200
     7.857   115.836     0.200
     8.423   127.348     0.200
     8.913   128.684     0.200
     8.938   129.895     0.200
     9.162   134.055     0.200
     9.162   133.676     0.200
     9.568   140.125     0.200
     9.979   146.215     0.200
    10.037   149.801     0.200
    10.159   147.676     0.200
    10.972   160.887     0.200
    11.167   162.586     0.200
    11.171   162.895     0.200
    11.251   163.645     0.200
    11.385   164.445     0.200
    12.556   184.234     0.200
    12.897   187.566     0.200
    12.981   190.395     0.200
    12.980   188.184     0.200
    13.171   190.934     0.200
    15.565   221.645     0.200
    16.079   226.746     0.200
    16.997   238.254     0.200
    19.284   268.535     0.200
    20.033   274.836     0.200
    20.209   277.145     0.200
     1.140    19.795     0.200
     1.231    21.695     0.200
     1.347    23.295     0.200
     1.480    24.705     0.200
     1.502    25.967     0.200
     1.586    27.137     0.200
     2.205    36.387     0.200
     2.269    37.336     0.200
     3.730    60.756     0.200
     4.231    66.605     0.200
     1.940    31.628     0.200
     2.002    32.918     0.200
     2.002    32.578     0.200
     2.015    32.908     0.200
     2.560    40.128     0.200
     3.570    54.878     0.200
     3.680    56.738     0.200
     2.568    41.886     0.200
     3.155    51.316     0.200
     3.581    53.156     0.200
     3.689    57.586     0.200
     3.690    55.267     0.200
     1.898    29.781     0.200
     1.898    31.156     0.200
     1.967    32.266     0.200
     1.971    31.406     0.200
     2.592    38.055     0.200
     3.503    52.258     0.200
     3.558    52.805     0.200
     1.545    26.812     0.200
     1.576    28.332     0.200
     1.782    30.613     0.200
     1.776    31.145     0.200
     1.951    32.973     0.200
     2.026    32.973     0.200
     2.013    34.094     0.200
     2.013    32.504     0.200
     2.549    41.441     0.200
     2.549    38.152     0.200
     2.788    45.344     0.200
     3.138    49.562     0.200
     3.138    49.152     0.200
     3.557    56.121     0.200
     3.670    58.133     0.200
     3.669    57.324     0.200
     3.952    62.461     0.200
     8.020   118.242     0.200
     8.781   127.598     0.200
    18.634   262.617     0.200
     1.434    25.473     0.200
     1.556    27.914     0.200
     1.574    28.605     0.200
     1.794    31.184     0.200
     1.783    31.332     0.200
     1.947    31.543     0.200
     1.947    32.184     0.200
     2.026    32.195     0.200
     2.004    33.402     0.200
     2.004    32.953     0.200
     2.317    37.754     0.200
     2.379    39.105     0.200
     2.560    41.285     0.200
     2.560    44.125     0.200
     2.560    40.125     0.200
     2.743    47.742     0.200
     2.981    48.152     0.200
     3.144    49.832     0.200
     3.412    55.082     0.200
     3.585    56.172     0.200
     3.554    56.125     0.200
     3.686    58.516     0.200
     3.681    56.945     0.200
     4.015    61.785     0.200
     4.171    64.805     0.200
     4.196    65.035     0.200
     4.213    65.633     0.200
     4.465    70.766     0.200
     4.465    67.664     0.200
     4.512    70.082     0.200
     4.860    74.715     0.200
     4.969    78.172     0.200
     5.024    76.082     0.200
     5.038    77.945     0.200
     5.039    77.375     0.200
     5.307    81.324     0.200
     5.336    81.004     0.200
     5.390    81.984     0.200
     5.730    87.215     0.200
     5.804    87.203     0.200
     6.064    91.074     0.200
     6.744   101.355     0.200
     7.227   106.172     0.200
     7.230   104.805     0.200
     7.261   108.645     0.200
     7.540   107.883     0.200
     7.454   110.324     0.200
     7.648   113.582     0.200
     7.685   114.434     0.200
     8.037   117.836     0.200
     8.037   118.023     0.200
     8.693   127.445     0.200
     8.797   129.844     0.200
     8.784   130.074     0.200
     8.794   129.465     0.200
     8.795   128.840     0.200
     8.795   130.652     0.200
     9.211   136.742     0.200
     9.135   137.094     0.200
     9.381   136.973     0.200
     9.417   136.270     0.200
     9.653   143.094     0.200
    11.009   158.141     0.200
    11.406   165.883     0.200
    11.437   166.062     0.200
    11.589   169.254     0.200
    11.936   174.363     0.200
    12.098   174.484     0.200
    12.219   177.355     0.200
    12.808   184.805     0.200
    12.998   189.492     0.200
    13.229   193.215     0.200
    13.393   191.016     0.200
    13.393   190.484     0.200
    13.712   200.125     0.200
    13.768   201.023     0.200
    13.766   197.914     0.200
    14.009   201.742     0.200
    14.070   204.355     0.200
    14.100   203.312     0.200
    14.270   205.016     0.200
    14.309   203.855     0.200
    14.655   209.094     0.200
    14.691   208.594     0.200
    14.807   210.422     0.200
    14.832   209.773     0.200
    14.847   211.004     0.200
    15.040   215.016     0.200
    15.108   214.723     0.200
    15.187   215.254     0.200
    15.522   220.035     0.200
    15.709   221.285     0.200
    15.979   226.645     0.200
    18.642   259.488     0.200
    18.642   260.922     0.200
    18.687   259.414     0.200
    20.289   278.125     0.200
     1.459    24.875     0.200
     1.552    25.887     0.200
     1.782    30.684     0.200
     1.918    31.863     0.200
     1.918    31.254     0.200
     1.971    32.555     0.200
     1.971    31.363     0.200
     3.175    46.547     0.200
     3.526    54.516     0.200
     3.717    55.336     0.200
     8.057   117.168     0.200
     8.828   129.324     0.200
     9.398   134.758     0.200
    10.999   158.227     0.200
    13.394   192.984     0.200
     0.893    16.116     0.200
     1.519    25.756     0.200
     1.760    29.366     0.200
     1.895    31.556     0.200
     1.895    31.686     0.200
     1.975    31.646     0.200
     1.957    32.626     0.200
     3.195    50.826     0.200
     3.502    55.236     0.200
     3.582    55.866     0.200
     3.723    58.786     0.200
     1.430    25.152     0.200
     1.742    29.820     0.200
     1.742    29.141     0.200
     2.273    36.910     0.200
     2.602    40.070     0.200
     2.602    41.492     0.200
     2.602    40.691     0.200
     2.850    46.242     0.200
     2.683    42.922     0.200
     2.924    46.090     0.200
     3.200    49.641     0.200
     3.349    51.391     0.200
     3.494    52.012     0.200
     3.564    55.520     0.200
     3.720    57.293     0.200
     3.763    56.363     0.200
     3.954    58.762     0.200
     4.151    62.410     0.200
     4.144    63.332     0.200
     4.441    66.293     0.200
     4.462    66.590     0.200
     4.477    67.953     0.200
     4.849    72.812     0.200
     4.982    74.711     0.200
     5.058    76.941     0.200
     5.249    77.652     0.200
     5.284    78.660     0.200
     5.367    80.102     0.200
     5.694    83.570     0.200
     5.697    84.340     0.200
     5.800    84.992     0.200
     6.004    87.883     0.200
     6.018    89.051     0.200
     7.094   102.203     0.200
     7.172   104.953     0.200
     7.207   105.020     0.200
     7.479   105.531     0.200
     7.464   107.312     0.200
     7.665   109.730     0.200
     7.711   116.422     0.200
     8.020   118.059     0.200
     8.020   116.062     0.200
     8.020   116.113     0.200
     8.020   115.883     0.200
    14.311   199.723     0.200
    15.186   211.230     0.200
    15.217   213.133     0.200
    15.246   212.730     0.200
    15.326   214.422     0.200
    15.428   215.801     0.200
    15.499   215.801     0.200
    15.519   217.281     0.200
    15.572   216.992     0.200
    15.978   221.262     0.200
    16.245   225.500     0.200
    16.384   229.312     0.200
     0.981    16.992     0.200
     1.468    24.762     0.200
     1.530    25.734     0.200
     1.630    26.781     0.200
     1.772    29.152     0.200
     1.772    29.602     0.200
     1.847    30.883     0.200
     1.884    31.293     0.200
     1.884    31.754     0.200
     1.940    32.004     0.200
     1.970    31.883     0.200
     2.316    36.781     0.200
     2.308    37.074     0.200
     2.622    40.613     0.200
     2.841    47.043     0.200
     2.682    44.383     0.200
     2.950    45.691     0.200
     3.208    49.402     0.200
     3.346    51.582     0.200
     3.493    53.082     0.200
     3.493    54.043     0.200
     3.603    55.473     0.200
     3.603    54.352     0.200
     3.743    57.023     0.200
     3.736    60.512     0.200
     3.765    56.602     0.200
     3.975    59.984     0.200
     4.153    61.793     0.200
     4.174    62.672     0.200
     4.211    64.562     0.200
     4.409    65.832     0.200
     4.480    66.891     0.200
     4.514    68.582     0.200
     4.887    75.113     0.200
     4.910    71.844     0.200
     5.017    75.074     0.200
     5.090    76.914     0.200
     5.275    77.562     0.200
     5.314    78.352     0.200
     5.406    81.754     0.200
     5.728    85.062     0.200
     5.735    85.504     0.200
     5.838    86.844     0.200
     6.035    87.914     0.200
     6.052    89.621     0.200
     6.586    98.301     0.200
     6.771    97.453     0.200
     7.132   104.934     0.200
     7.199   103.812     0.200
     7.236   104.613     0.200
     7.254   106.742     0.200
     7.480   107.113     0.200
     7.499   110.332     0.200
     7.633   110.191     0.200
     7.698   113.094     0.200
     7.731   111.754     0.200
     8.056   116.941     0.200
     8.058   117.633     0.200
     8.058   117.434     0.200
     8.058   117.664     0.200
     8.058   117.891     0.200
     8.229   120.543     0.200
     8.412   120.473     0.200
     8.456   124.543     0.200
     8.612   124.613     0.200
     8.716   127.094     0.200
     8.743   127.512     0.200
     8.716   124.504     0.200
     8.836   129.113     0.200
     8.851   129.043     0.200
     8.852   128.133     0.200
     9.087   131.852     0.200
     9.367   140.164     0.200
    10.152   148.121     0.200
    10.149   145.832     0.200
    10.225   145.961     0.200
    10.508   150.953     0.200
    10.724   153.402     0.200
    10.973   160.086     0.200
    11.017   159.562     0.200
    11.008   159.473     0.200
    11.395   162.773     0.200
    11.439   163.852     0.200
    11.511   165.004     0.200
    11.629   167.742     0.200
    12.150   174.664     0.200
    12.193   175.012     0.200
    12.283   174.352     0.200
    12.617   180.844     0.200
    12.857   184.953     0.200
    13.376   192.812     0.200
    13.376   188.992     0.200
    13.640   194.602     0.200
    13.735   193.234     0.200
    13.802   196.793     0.200
    14.137   201.172     0.200
    14.216   202.941     0.200
    14.247   200.312     0.200
    14.348   204.441     0.200
    14.388   203.512     0.200
    14.637   208.543     0.200
    14.732   209.223     0.200
    14.805   208.043     0.200
    14.869   211.633     0.200
    15.085   211.801     0.200
    15.113   211.863     0.200
    15.135   212.613     0.200
    15.159   212.844     0.200
    15.223   215.211     0.200
    15.254   216.914     0.200
    15.284   217.391     0.200
    15.268   213.742     0.200
    15.314   216.051     0.200
    15.349   214.711     0.200
    15.466   218.941     0.200
    15.508   220.074     0.200
    15.520   220.344     0.200
    15.536   219.691     0.200
    15.557   220.441     0.200
    15.556   218.613     0.200
    15.597   221.332     0.200
    15.686   221.152     0.200
    15.701   221.801     0.200
    15.745   222.461     0.200
    15.892   225.043     0.200
    16.016   226.453     0.200
    16.090   227.762     0.200
    16.097   224.734     0.200
    16.264   228.082     0.200
    16.313   229.242     0.200
    16.384   230.832     0.200
    16.701   235.074     0.200
    18.215   251.121     0.200
    18.292   252.641     0.200
    18.604   260.883     0.200
    18.941   262.051     0.200
    19.191   264.594     0.200
    19.998   273.754     0.200
    20.008   273.754     0.200
    20.261   276.914     0.200
    20.719   281.953     0.200
     1.388    24.320     0.200
     1.460    25.055     0.200
     1.699    29.031     0.200
     1.659    29.891     0.200
     1.835    32.336     0.200
     1.884    31.727     0.200
     1.946    30.320     0.200
     1.966    33.289     0.200
     1.966    32.484     0.200
     2.590    42.359     0.200
     2.590    39.320     0.200
     3.202    49.875     0.200
     3.485    53.781     0.200
     3.518    54.727     0.200
     3.671    58.984     0.200
     3.704    56.695     0.200
     5.027    76.445     0.200
     7.974   117.820     0.200
     8.797   129.055     0.200
     1.420    24.539     0.200
     1.485    25.039     0.200
     1.650    29.805     0.200
     1.726    28.141     0.200
     1.842    32.195     0.200
     1.849    32.367     0.200
     1.880    31.320     0.200
     1.952    30.867     0.200
     1.953    32.227     0.200
     3.207    50.586     0.200
     3.484    52.516     0.200
     3.551    55.656     0.200
     3.722    58.055     0.200
     4.389    70.414     0.200
     8.007   117.016     0.200
     8.821   128.625     0.200
     9.340   141.000     0.200
    10.934   161.148     0.200
     1.968    33.406     0.200
     1.975    33.109     0.200
     1.547    26.039     0.200
     1.784    30.289     0.200
     1.950    32.242     0.200
     1.950    32.500     0.200
     2.011    33.602     0.200
     2.551    42.492     0.200
     3.140    50.492     0.200
     3.571    55.211     0.200
     3.673    57.438     0.200
     2.634    43.133     0.200
     3.260    51.123     0.200
     3.424    53.843     0.200
     3.514    52.753     0.200
     3.744    57.973     0.200
     0.876    17.000     0.200
     1.492    25.867     0.200
     1.607    27.609     0.200
     1.727    29.195     0.200
     1.942    32.461     0.200
     1.942    32.305     0.200
     2.001    33.320     0.200
     2.022    34.570     0.200
     2.022    34.719     0.200
     2.534    42.094     0.200
     3.144    49.586     0.200
     3.144    49.359     0.200
     3.509    54.797     0.200
     3.650    56.820     0.200
     0.900    17.887     0.200
     1.897    32.246     0.200
     3.189    51.486     0.200
     3.685    58.516     0.200
     1.405    24.453     0.200
     1.473    24.953     0.200
     1.712    28.703     0.200
     1.959    32.523     0.200
     1.949    30.312     0.200
     2.597    42.961     0.200
     2.597    39.008     0.200
     2.867    46.695     0.200
     3.205    50.328     0.200
     3.205    50.641     0.200
     3.535    52.859     0.200
     3.685    57.180     0.200
     3.685    56.039     0.200
     3.712    58.055     0.200
     5.041    78.219     0.200
     0.529    11.840     0.200
     2.625    43.637     0.200
     2.625    43.250     0.200
     3.232    51.539     0.200
     3.459    56.387     0.200
     3.546    56.406     0.200
     3.709    58.949     0.200
     3.740    59.156     0.200
     1.901    31.605     0.200
     1.958    30.807     0.200
     2.568    42.166     0.200
     3.185    49.367     0.200
     3.499    54.195     0.200
     3.500    54.916     0.200
     3.590    56.166     0.200
     3.647    57.525     0.200
     3.681    56.766     0.200
     1.434    24.307     0.200
     1.512    25.227     0.200
     1.897    30.988     0.200
     1.974    31.908     0.200
     2.598    42.928     0.200
     3.503    54.418     0.200
     3.717    58.387     0.200
     1.369    24.067     0.200
     1.449    24.897     0.200
     1.686    28.457     0.200
     1.660    29.687     0.200
     1.892    32.267     0.200
     1.892    31.557     0.200
     2.576    42.837     0.200
     2.576    42.147     0.200
     3.195    51.227     0.200
     3.195    50.617     0.200
     3.490    52.937     0.200
     3.689    58.047     0.200
     5.009    76.357     0.200
     1.614    27.520     0.200
     1.797    30.900     0.200
     1.836    31.461     0.200
     1.924    32.311     0.200
     1.924    30.420     0.200
     1.990    30.990     0.200
     2.560    41.471     0.200
     2.560    41.590     0.200
     2.827    45.391     0.200
     2.827    44.141     0.200
     3.163    49.811     0.200
     3.163    48.531     0.200
     3.534    55.090     0.200
     3.660    57.621     0.200
     3.677    57.100     0.200
     3.977    62.100     0.200
     5.015    76.670     0.200
     7.988   116.520     0.200
     8.779   126.051     0.200
     1.410    24.438     0.200
     1.528    25.645     0.200
     1.592    27.637     0.200
     1.765    29.816     0.200
     1.808    31.246     0.200
     1.786    30.074     0.200
     1.938    31.895     0.200
     1.938    31.996     0.200
     2.010    30.887     0.200
     2.556    41.324     0.200
     2.556    40.527     0.200
     2.804    44.797     0.200
     2.804    44.156     0.200
     2.880    43.824     0.200
     3.150    49.715     0.200
     3.150    46.695     0.200
     3.557    54.984     0.200
     3.669    58.227     0.200
     3.675    56.617     0.200
     4.765    72.547     0.200
     8.009   117.504     0.200
     8.783   128.461     0.200
     1.003    17.602     0.200
     1.905    31.791     0.200
     3.226    51.881     0.200
     3.226    50.191     0.200
     3.699    58.561     0.200
     4.337    68.441     0.200
     7.916   116.422     0.200
     8.778   128.074     0.200
     9.276   137.109     0.200
    13.232   189.623     0.200
     1.372    24.742     0.200
     1.450    25.230     0.200
     1.688    29.031     0.200
     1.661    28.641     0.200
     1.889    31.461     0.200
     1.889    32.094     0.200
     1.828    31.953     0.200
     1.946    31.633     0.200
     1.886    33.062     0.200
     2.580    41.773     0.200
     3.197    49.973     0.200
     3.693    57.094     0.200
     4.010    62.363     0.200
     8.784   129.023     0.200
     9.324   138.172     0.200
     1.391    24.762     0.200
     1.452    24.652     0.200
     1.692    28.523     0.200
     1.692    29.504     0.200
     1.670    30.004     0.200
     1.874    30.652     0.200
     1.874    33.203     0.200
     1.935    32.363     0.200
     1.845    31.902     0.200
     1.882    33.594     0.200
     2.221    37.223     0.200
     2.303    39.113     0.200
     2.598    42.363     0.200
     2.598    41.980     0.200
     2.598    41.344     0.200
     2.662    46.434     0.200
     2.877    47.293     0.200
     2.882    47.242     0.200
     2.882    46.754     0.200
     2.882    48.262     0.200
     3.288    51.652     0.200
     3.212    52.012     0.200
     3.212    51.723     0.200
     3.320    52.492     0.200
     3.517    55.773     0.200
     3.712    58.383     0.200
     4.028    61.512     0.200
     4.094    63.902     0.200
     4.421    68.082     0.200
     4.426    68.812     0.200
     4.399    68.523     0.200
     4.805    72.230     0.200
     4.883    75.004     0.200
     4.931    74.871     0.200
     5.033    78.344     0.200
     5.202    80.973     0.200
     5.234    80.184     0.200
     5.319    81.664     0.200
     7.973   119.195     0.200
     8.804   130.602     0.200
    10.904   163.152     0.200
    16.351   229.934     0.200
     1.361    24.274     0.200
     1.653    28.075     0.200
     1.863    30.886     0.200
     1.863    31.095     0.200
     1.914    30.806     0.200
     2.182    35.345     0.200
     2.290    36.685     0.200
     2.597    40.726     0.200
     2.597    42.556     0.200
     2.647    43.815     0.200
     2.828    45.685     0.200
     2.839    44.976     0.200
     2.908    47.075     0.200
     2.908    48.306     0.200
     3.173    47.944     0.200
     3.224    49.706     0.200
     3.297    51.126     0.200
     3.480    52.716     0.200
     3.480    54.815     0.200
     3.548    56.466     0.200
     3.657    58.185     0.200
     3.722    56.786     0.200
     3.876    58.165     0.200
     4.055    61.706     0.200
     4.109    63.396     0.200
     4.110    61.845     0.200
     4.341    65.216     0.200
     4.347    65.075     0.200
     4.389    66.575     0.200
     4.387    66.694     0.200
     4.497    67.595     0.200
     4.790    71.845     0.200
     4.772    71.466     0.200
     4.863    72.854     0.200
     4.891    73.476     0.200
     5.014    76.774     0.200
     5.195    76.694     0.200
     5.283    78.194     0.200
     5.438    80.546     0.200
     5.608    83.546     0.200
     5.729    84.915     0.200
     5.915    86.745     0.200
     5.927    87.325     0.200
     6.603    96.636     0.200
     7.119   104.616     0.200
     7.136   103.386     0.200
     7.407   107.495     0.200
     7.546   110.505     0.200
     7.618   111.024     0.200
     7.709   111.165     0.200
     7.709   116.585     0.200
     7.938   116.675     0.200
     7.938   114.835     0.200
     8.662   125.175     0.200
     8.762   126.056     0.200
     8.790   126.806     0.200
     8.880   127.636     0.200
     9.289   137.610     0.200
    10.383   149.216     0.200
    13.094   187.825     0.200
    13.254   191.509     0.200
    13.880   196.255     0.200
    14.033   199.146     0.200
    14.246   200.425     0.200
    14.778   207.854     0.200
    15.150   211.556     0.200
    15.177   214.896     0.200
    16.207   228.956     0.200
    18.502   259.175     0.200
     1.357    24.162     0.200
     1.436    25.562     0.200
     1.674    28.861     0.200
     1.890    32.361     0.200
     1.942    32.031     0.200
     2.574    41.361     0.200
     2.880    47.732     0.200
     3.197    51.902     0.200
     3.197    51.201     0.200
     3.485    55.643     0.200
     3.576    56.822     0.200
     3.686    58.332     0.200
     4.010    62.832     0.200
     0.934    16.114     0.200
     1.062    19.284     0.200
     1.321    22.374     0.200
     1.320    22.475     0.200
     1.428    24.164     0.200
     1.590    26.685     0.200
     1.590    26.194     0.200
     1.516    25.185     0.200
     1.664    25.994     0.200
     2.099    32.005     0.200
     2.096    32.725     0.200
     2.204    34.435     0.200
     2.176    34.755     0.200
     2.253    35.765     0.200
     2.421    37.755     0.200
     2.651    41.364     0.200
     2.648    41.744     0.200
     2.762    43.584     0.200
     2.853    44.055     0.200
     3.182    48.704     0.200
     1.034    18.305     0.200
     1.113    20.135     0.200
     1.115    20.515     0.200
     1.165    19.685     0.200
     1.244    22.095     0.200
     1.244    22.035     0.200
     1.292    22.365     0.200
     1.314    22.915     0.200
     1.404    24.095     0.200
     1.459    24.755     0.200
     1.430    24.755     0.200
     1.501    25.595     0.200
     1.501    25.725     0.200
     1.595    26.895     0.200
     1.650    26.355     0.200
     1.748    29.545     0.200
     2.162    34.895     0.200
     2.192    34.945     0.200
     2.224    36.745     0.200
     2.238    36.085     0.200
     2.551    40.175     0.200
     2.635    41.845     0.200
     2.638    42.195     0.200
     2.747    43.405     0.200
     3.184    49.105     0.200
     1.361    23.441     0.200
     1.450    23.992     0.200
     1.687    27.992     0.200
     1.687    28.432     0.200
     1.654    27.812     0.200
     1.900    31.301     0.200
     1.900    31.412     0.200
     1.817    30.301     0.200
     1.954    30.611     0.200
     1.887    32.051     0.200
     1.988    32.691     0.200
     1.988    32.551     0.200
     2.209    36.041     0.200
     2.328    37.461     0.200
     2.567    40.621     0.200
     2.567    41.602     0.200
     2.567    40.322     0.200
     2.816    43.922     0.200
     2.686    45.211     0.200
     2.877    45.252     0.200
     2.867    46.402     0.200
     2.867    46.672     0.200
     3.186    49.922     0.200
     3.186    50.131     0.200
     3.297    51.332     0.200
     3.338    51.812     0.200
     3.493    53.922     0.200
     3.493    54.551     0.200
     3.762    57.041     0.200
     3.680    56.002     0.200
     3.916    58.992     0.200
     3.841    59.611     0.200
     4.039    61.352     0.200
     3.999    61.791     0.200
     4.089    62.121     0.200
     4.149    63.291     0.200
     4.107    63.102     0.200
     4.388    66.211     0.200
     4.430    66.902     0.200
     4.409    67.143     0.200
     4.383    67.172     0.200
     4.778    72.312     0.200
     4.827    73.232     0.200
     4.944    74.092     0.200
     4.918    74.031     0.200
     5.000    76.492     0.200
     5.203    77.643     0.200
     5.228    78.152     0.200
     5.296    79.143     0.200
     5.633    83.102     0.200
     5.628    83.342     0.200
     5.730    85.621     0.200
     5.947    87.451     0.200
     5.997    88.611     0.200
     5.956    87.041     0.200
     5.951    91.182     0.200
     6.485    95.201     0.200
     6.636    96.801     0.200
     6.712    96.162     0.200
     7.023   103.221     0.200
     7.121   103.562     0.200
     7.154   104.361     0.200
     7.144   104.521     0.200
     7.479   105.332     0.200
     7.399   107.871     0.200
     7.560   110.271     0.200
     7.585   110.871     0.200
     7.653   111.211     0.200
     7.605   111.412     0.200
     7.943   115.471     0.200
     7.946   115.131     0.200
     7.945   115.471     0.200
     7.948   117.301     0.200
     7.948   115.852     0.200
     7.948   115.512     0.200
     7.948   115.621     0.200
     8.747   127.371     0.200
     8.770   127.381     0.200
     8.771   128.730     0.200
     8.771   127.732     0.200
     9.505   136.881     0.200
    10.132   143.721     0.200
    12.060   169.291     0.200
    13.285   193.525     0.200
    15.117   214.631     0.200
    15.209   213.982     0.200
    15.148   213.412     0.200
    15.177   214.602     0.200
    15.207   215.602     0.200
    15.284   215.072     0.200
    15.431   217.451     0.200
    15.450   218.072     0.200
    15.515   218.871     0.200
    15.593   220.012     0.200
    15.639   220.762     0.200
    15.910   223.102     0.200
    16.207   228.441     0.200
    16.596   232.342     0.200
    17.448   242.982     0.200
     1.862    30.883     0.200
     1.914    29.363     0.200
     1.956    32.793     0.200
     2.598    42.664     0.200
     3.224    51.246     0.200
     3.708    56.844     0.200
     7.941   118.172     0.200
     8.792   129.406     0.200
     1.899    30.919     0.200
     3.240    51.499     0.200
     3.240    51.379     0.200
     3.487    53.909     0.200
     3.671    56.789     0.200
     3.723    58.029     0.200
     1.390    24.541     0.200
     1.494    25.181     0.200
     1.731    29.551     0.200
     1.620    29.761     0.200
     1.801    31.931     0.200
     1.920    32.221     0.200
     1.920    32.400     0.200
     1.842    32.721     0.200
     1.985    31.581     0.200
     1.995    33.480     0.200
     1.995    33.681     0.200
     2.254    37.281     0.200
     2.349    38.320     0.200
     2.563    42.221     0.200
     2.563    42.531     0.200
     2.851    46.190     0.200
     2.710    44.841     0.200
     2.920    46.521     0.200
     2.832    46.980     0.200
     3.167    50.851     0.200
     3.336    52.781     0.200
     3.369    52.661     0.200
     3.530    55.851     0.200
     3.530    54.161     0.200
     3.660    57.771     0.200
     3.788    58.501     0.200
     3.809    60.011     0.200
     3.957    61.181     0.200
     3.981    63.480     0.200
     4.134    64.650     0.200
     4.133    64.631     0.200
     4.420    67.465     0.200
     4.349    67.581     0.200
     4.452    68.871     0.200
     4.811    73.871     0.200
     4.962    76.480     0.200
     7.622   113.690     0.200
     7.985   116.277     0.200
     7.985   117.061     0.200
     8.667   127.070     0.200
     8.780   128.284     0.200
     9.366   140.385     0.200
    10.950   161.088     0.200
    13.330   191.317     0.200
    14.700   209.480     0.200
    16.235   226.121     0.200
    16.666   234.271     0.200
    18.583   260.460     0.200
     1.410    24.252     0.200
     1.530    24.592     0.200
     1.768    28.252     0.200
     1.784    29.621     0.200
     1.806    31.441     0.200
     1.941    31.082     0.200
     1.941    31.461     0.200
     2.007    32.061     0.200
     2.289    35.682     0.200
     2.372    37.361     0.200
     2.554    40.342     0.200
     2.554    40.561     0.200
     2.554    38.451     0.200
     2.802    44.881     0.200
     2.802    42.922     0.200
     2.883    44.441     0.200
     2.734    45.002     0.200
     2.935    46.691     0.200
     2.956    45.201     0.200
     3.148    49.902     0.200
     3.252    50.691     0.200
     3.370    52.191     0.200
     3.398    50.672     0.200
     3.558    54.322     0.200
     3.558    52.861     0.200
     3.558    54.711     0.200
     3.637    54.752     0.200
     3.668    56.291     0.200
     3.668    59.332     0.200
     3.673    56.852     0.200
     3.814    58.891     0.200
     3.992    61.262     0.200
     4.110    62.461     0.200
     4.170    63.061     0.200
     4.149    63.791     0.200
     4.202    64.631     0.200
     4.445    68.572     0.200
     4.450    67.441     0.200
     4.450    66.881     0.200
     4.450    68.531     0.200
     4.450    69.691     0.200
     4.484    67.721     0.200
     4.504    68.551     0.200
     4.548    69.842     0.200
     4.606    71.031     0.200
     4.834    74.082     0.200
     4.895    75.061     0.200
     4.958    76.342     0.200
     5.018    76.412     0.200
     5.780    86.162     0.200
     6.717    99.422     0.200
     7.434   109.922     0.200
     7.630   112.121     0.200
     7.662   115.311     0.200
     7.662   115.881     0.200
     8.010   117.215     0.200
     8.010   117.381     0.200
     8.583   126.891     0.200
     8.767   128.061     0.200
     8.782   128.297     0.200
     9.399   140.113     0.200
     9.624   141.482     0.200
    10.469   153.951     0.200
    10.986   161.896     0.200
    10.949   158.742     0.200
    11.113   163.561     0.200
    12.220   179.371     0.200
    13.109   191.422     0.200
    13.366   193.773     0.200
    13.366   193.441     0.200
    13.536   193.582     0.200
    13.574   193.881     0.200
    13.574   195.291     0.200
    13.992   199.592     0.200
    14.050   201.941     0.200
    14.287   205.221     0.200
    14.952   212.932     0.200
    15.000   213.121     0.200
    15.056   214.191     0.200
    15.081   214.352     0.200
    15.098   214.092     0.200
    15.111   215.061     0.200
    15.132   214.912     0.200
    15.156   215.232     0.200
    15.164   215.652     0.200
    15.193   216.672     0.200
    15.225   217.242     0.200
    15.286   216.582     0.200
    15.256   217.342     0.200
    15.362   218.402     0.200
    15.371   219.121     0.200
    15.458   219.621     0.200
    15.475   219.691     0.200
    15.498   220.172     0.200
    15.559   220.602     0.200
    15.534   217.182     0.200
    15.615   220.611     0.200
    15.628   222.051     0.200
    15.638   222.381     0.200
    15.643   222.221     0.200
    15.714   221.742     0.200
    15.686   222.592     0.200
    15.854   224.152     0.200
    15.831   224.672     0.200
    15.956   226.391     0.200
    15.999   225.852     0.200
    16.033   227.332     0.200
    16.239   229.742     0.200
    16.254   229.922     0.200
    16.338   230.502     0.200
    16.256   229.641     0.200
    16.700   234.631     0.200
    16.876   237.541     0.200
    17.001   238.711     0.200
    17.059   239.072     0.200
    17.171   240.732     0.200
    17.396   239.482     0.200
    18.619   260.840     0.200
    18.619   260.521     0.200
    18.687   260.092     0.200
    19.095   264.402     0.200
    19.266   265.531     0.200
    19.247   266.191     0.200
    19.307   266.502     0.200
    19.477   270.941     0.200
    19.588   269.652     0.200
    19.937   273.461     0.200
    20.041   274.742     0.200
    20.202   276.262     0.200
    20.363   280.432     0.200
    20.946   284.541     0.200
     1.377    23.676     0.200
     1.470    24.656     0.200
     1.707    28.246     0.200
     1.707    28.453     0.200
     1.641    30.066     0.200
     1.906    31.984     0.200
     1.906    30.605     0.200
     1.813    30.824     0.200
     1.966    30.965     0.200
     1.987    33.016     0.200
     1.866    32.793     0.200
     2.230    36.203     0.200
     2.334    37.574     0.200
     2.569    41.395     0.200
     2.569    42.434     0.200
     2.569    40.254     0.200
     2.830    45.035     0.200
     2.830    44.336     0.200
     2.694    44.266     0.200
     2.883    45.523     0.200
     2.896    45.645     0.200
     3.217    49.023     0.200
     3.313    51.836     0.200
     3.181    50.203     0.200
     3.181    49.727     0.200
     3.350    52.203     0.200
     3.512    55.125     0.200
     3.512    54.574     0.200
     3.655    56.184     0.200
     3.771    57.227     0.200
     3.683    56.906     0.200
     3.881    58.613     0.200
     3.933    61.426     0.200
     4.055    61.855     0.200
     4.109    63.465     0.200
     3.994    62.004     0.200
     4.158    63.375     0.200
     4.122    63.953     0.200
     4.400    66.734     0.200
     4.400    66.848     0.200
     4.430    67.977     0.200
     4.446    67.715     0.200
     4.370    67.086     0.200
     4.796    72.895     0.200
     4.844    72.664     0.200
     4.939    74.996     0.200
     4.961    75.414     0.200
     4.814    72.914     0.200
     5.010    76.496     0.200
     5.222    79.656     0.200
     5.249    79.945     0.200
     5.316    80.855     0.200
     5.654    85.586     0.200
     5.649    85.043     0.200
     5.608    83.164     0.200
     5.747    86.293     0.200
     5.616    83.855     0.200
     5.968    90.293     0.200
     5.977    90.336     0.200
     6.011    90.504     0.200
     6.657    99.863     0.200
     6.730   100.156     0.200
     7.041   104.074     0.200
     7.141   106.316     0.200
     7.174   107.266     0.200
     7.163   106.164     0.200
     7.488   106.734     0.200
     7.413   109.555     0.200
     7.579   111.477     0.200
     7.603   111.016     0.200
     7.673   112.805     0.200
     7.616   112.055     0.200
     7.730   114.184     0.200
     7.679   112.555     0.200
     7.967   117.449     0.200
     7.967   116.785     0.200
     7.967   116.676     0.200
     8.661   126.266     0.200
     8.757   128.125     0.200
     8.778   129.004     0.200
     8.779   128.711     0.200
     8.779   127.836     0.200
     9.345   139.211     0.200
     9.415   136.895     0.200
     9.509   138.766     0.200
     9.567   140.246     0.200
    10.153   148.645     0.200
    10.075   146.254     0.200
    10.926   158.781     0.200
    10.936   158.383     0.200
    11.303   163.316     0.200
    11.824   170.535     0.200
    12.071   173.555     0.200
    12.105   172.543     0.200
    12.570   178.074     0.200
    13.306   191.633     0.200
    14.644   207.984     0.200
    14.779   209.273     0.200
    15.042   212.996     0.200
    15.071   213.316     0.200
    15.133   215.176     0.200
    15.655   221.426     0.200
    15.802   222.594     0.200
    15.926   224.285     0.200
    16.223   228.645     0.200
    16.295   229.895     0.200
    16.333   229.133     0.200
    16.612   232.945     0.200
    18.559   260.047     0.200
     1.354    23.555     0.200
     1.432    23.965     0.200
     1.670    27.895     0.200
     1.670    29.555     0.200
     1.888    31.172     0.200
     1.828    32.465     0.200
     1.939    31.613     0.200
     1.904    32.742     0.200
     1.981    32.555     0.200
     2.574    42.414     0.200
     3.198    49.633     0.200
     3.642    56.672     0.200
     3.685    57.055     0.200
     4.011    63.434     0.200
     4.843    73.543     0.200
     7.938   116.988     0.200
     8.772   127.645     0.200
     1.590    27.102     0.200
     1.835    30.902     0.200
     1.893    32.043     0.200
     1.893    32.184     0.200
     1.928    31.953     0.200
     1.998    32.023     0.200
     3.670    57.441     0.200
     3.785    60.613     0.200
     3.769    59.371     0.200
     1.490    26.629     0.200
     1.564    27.281     0.200
     1.807    30.910     0.200
     1.769    31.379     0.200
     1.902    32.441     0.200
     1.902    32.941     0.200
     1.948    33.301     0.200
     1.948    32.559     0.200
     1.995    32.359     0.200
     2.619    43.609     0.200
     3.194    51.488     0.200
     3.194    52.930     0.200
     3.632    56.289     0.200
     3.749    58.898     0.200
     3.742    59.141     0.200
     3.795    60.031     0.200
     1.555    26.812     0.200
     1.622    27.258     0.200
     1.867    30.922     0.200
     1.906    32.008     0.200
     1.906    32.227     0.200
     1.931    31.891     0.200
     1.931    32.227     0.200
     2.018    32.016     0.200
     2.648    44.188     0.200
     3.200    52.141     0.200
     3.200    52.820     0.200
     3.700    57.477     0.200
     3.775    58.992     0.200
     3.802    59.344     0.200
     3.802    61.672     0.200
     4.750    75.188     0.200
     5.153    79.164     0.200
     8.154   120.406     0.200
     8.902   131.688     0.200
     9.429   141.508     0.200
    13.473   197.516     0.200
     1.701    28.008     0.200
     1.900    31.178     0.200
     1.959    30.996     0.200
     1.983    32.627     0.200
     2.573    40.896     0.200
     2.860    47.326     0.200
     3.186    49.268     0.200
     3.509    52.457     0.200
     3.656    54.326     0.200
     3.687    56.678     0.200
     5.012    74.246     0.200
     7.964   116.852     0.200
     8.781   128.357     0.200
    10.919   161.332     0.200
    13.300   194.152     0.200
     1.413    23.938     0.200
     1.519    24.102     0.200
     1.758    27.812     0.200
     1.926    30.633     0.200
     1.993    32.812     0.200
     1.993    31.922     0.200
     1.998    30.031     0.200
     2.281    35.609     0.200
     2.356    36.359     0.200
     2.567    40.289     0.200
     2.567    39.188     0.200
     2.868    44.508     0.200
     2.719    43.562     0.200
     2.945    45.594     0.200
     3.163    48.219     0.200
     3.356    50.938     0.200
     3.383    51.609     0.200
     3.557    54.703     0.200
     3.557    54.133     0.200
     3.686    56.703     0.200
     3.799    55.844     0.200
     3.979    59.977     0.200
     4.096    61.664     0.200
     4.160    62.891     0.200
     4.187    62.742     0.200
     4.154    63.500     0.200
     4.435    66.789     0.200
     4.490    67.609     0.200
     4.479    68.094     0.200
     4.533    66.992     0.200
     4.836    73.273     0.200
     4.989    74.727     0.200
     5.031    76.172     0.200
     5.271    77.281     0.200
     5.299    79.789     0.200
     5.361    80.539     0.200
     5.595    84.938     0.200
     5.705    84.922     0.200
     5.697    84.719     0.200
     5.783    85.914     0.200
     5.919    91.680     0.200
     6.028    90.062     0.200
     7.082   104.344     0.200
     7.225   105.617     0.200
     7.204   105.203     0.200
     7.638   112.461     0.200
     8.010   116.492     0.200
     8.010   116.617     0.200
     8.792   124.773     0.200
     8.792   128.070     0.200
     9.385   139.547     0.200
    10.204   147.727     0.200
    10.679   154.422     0.200
    10.973   159.094     0.200
    10.950   157.844     0.200
    13.357   192.742     0.200
    13.929   201.445     0.200
    15.197   214.898     0.200
    16.685   234.398     0.200
    17.136   239.758     0.200
    18.606   259.625     0.200
     1.411    24.023     0.200
     1.459    23.766     0.200
     1.700    28.273     0.200
     1.700    29.164     0.200
     1.675    29.695     0.200
     1.861    30.891     0.200
     1.861    32.086     0.200
     1.859    31.891     0.200
     1.875    32.859     0.200
     1.928    32.750     0.200
     1.940    33.133     0.200
     1.940    32.734     0.200
     2.234    37.312     0.200
     2.291    37.781     0.200
     2.616    44.781     0.200
     2.616    42.250     0.200
     2.652    45.148     0.200
     2.882    45.680     0.200
     2.887    46.523     0.200
     2.887    48.336     0.200
     2.887    49.484     0.200
     3.173    49.016     0.200
     3.226    49.922     0.200
     3.226    50.945     0.200
     3.287    51.453     0.200
     3.463    52.953     0.200
     3.463    53.352     0.200
     3.535    55.492     0.200
     3.535    52.555     0.200
     3.554    57.375     0.200
     3.698    57.414     0.200
     3.731    56.812     0.200
     3.731    58.414     0.200
     3.912    59.250     0.200
     4.025    61.555     0.200
     4.039    61.820     0.200
     4.102    62.516     0.200
     4.118    64.375     0.200
     4.365    66.625     0.200
     4.405    66.781     0.200
     4.441    66.859     0.200
     4.404    67.266     0.200
     4.464    71.586     0.200
     4.825    74.562     0.200
     4.847    73.719     0.200
     4.943    74.672     0.200
     5.207    78.875     0.200
     5.242    80.086     0.200
     5.337    80.633     0.200
     5.654    86.031     0.200
     5.662    85.203     0.200
     5.780    86.148     0.200
     5.963    90.711     0.200
     5.979    89.820     0.200
     5.985    88.664     0.200
     6.537    97.641     0.200
     6.651    99.453     0.200
     6.708    99.664     0.200
     6.734   101.148     0.200
     6.741   101.234     0.200
     6.904   103.602     0.200
     7.069   103.641     0.200
     7.129   104.969     0.200
     7.165   105.539     0.200
     7.190   105.789     0.200
     7.453   111.281     0.200
     7.565   110.945     0.200
     7.727   117.930     0.200
     7.950   116.500     0.200
     7.992   118.164     0.200
     8.357   121.586     0.200
     8.407   123.195     0.200
     8.489   123.172     0.200
     8.538   123.086     0.200
     8.538   129.391     0.200
     8.635   125.891     0.200
     8.660   126.672     0.200
     8.674   127.336     0.200
     8.794   129.266     0.200
     8.824   129.266     0.200
     9.314   141.445     0.200
     9.314   138.461     0.200
     9.610   139.875     0.200
     9.807   143.234     0.200
     9.818   143.414     0.200
    10.063   146.570     0.200
    10.874   160.961     0.200
    10.907   161.719     0.200
    10.907   156.430     0.200
    10.917   157.305     0.200
    10.958   157.484     0.200
    11.330   163.398     0.200
    11.381   168.219     0.200
    11.952   176.805     0.200
    13.303   193.492     0.200
    13.580   194.539     0.200
    13.610   194.039     0.200
    13.668   193.891     0.200
    15.284   216.859     0.200
    15.487   218.562     0.200
    15.570   223.750     0.200
    16.700   234.961     0.200
    16.926   236.211     0.200
    16.944   239.164     0.200
    16.987   237.031     0.200
    17.088   237.148     0.200
    18.312   256.086     0.200
    18.539   261.719     0.200
    19.447   271.469     0.200
    20.362   280.109     0.200
     1.461    25.039     0.200
     1.698    28.159     0.200
     1.900    31.069     0.200
     1.900    31.219     0.200
     1.958    30.579     0.200
     1.984    32.399     0.200
     1.984    31.079     0.200
     3.186    48.739     0.200
     3.499    51.979     0.200
     3.506    51.959     0.200
     3.685    56.249     0.200
     1.162    21.469     0.200
     1.162    21.018     0.200
     1.453    26.268     0.200
     1.969    33.469     0.200
     2.255    37.039     0.200
     2.572    39.688     0.200
     2.654    42.518     0.200
     2.715    43.469     0.200
     2.596    43.928     0.200
     3.033    50.408     0.200
     3.266    53.889     0.200
     3.266    54.129     0.200
     3.143    49.129     0.200
     3.108    49.508     0.200
     3.203    50.658     0.200
     3.276    51.818     0.200
     3.406    53.748     0.200
     3.406    56.518     0.200
     3.533    58.027     0.200
     3.654    57.008     0.200
     3.710    58.277     0.200
     3.786    59.428     0.200
     3.862    60.309     0.200
     3.854    61.059     0.200
     3.947    60.979     0.200
     4.075    66.107     0.200
     4.039    62.568     0.200
     4.173    64.158     0.200
     4.234    65.447     0.200
     4.243    65.527     0.200
     4.237    66.178     0.200
     4.292    66.418     0.200
     4.543    72.908     0.200
     4.372    67.459     0.200
     4.372    67.459     0.200
     4.582    70.098     0.200
     4.683    71.738     0.200
     4.720    72.428     0.200
     4.753    73.008     0.200
     4.786    72.658     0.200
     4.991    78.959     0.200
     4.894    77.258     0.200
     4.981    76.979     0.200
     4.993    77.418     0.200
     5.175    78.998     0.200
     5.352    81.688     0.200
     5.663    85.258     0.200
    14.816   211.258     0.200
    14.846   211.059     0.200
    14.842   211.898     0.200
    14.943   212.709     0.200
    14.979   209.979     0.200
    14.999   210.348     0.200
    15.002   210.789     0.200
    15.069   212.539     0.200
    15.177   213.248     0.200
    15.261   214.479     0.200
    15.272   214.418     0.200
    15.369   216.289     0.200
    15.463   216.479     0.200
    15.726   220.938     0.200
    16.032   224.438     0.200
    16.743   232.959     0.200
    16.749   233.617     0.200
     1.412    25.404     0.200
     1.477    25.125     0.200
     1.717    28.875     0.200
     1.717    29.094     0.200
     1.842    31.555     0.200
     1.880    31.625     0.200
     1.880    31.834     0.200
     1.955    32.934     0.200
     1.955    33.184     0.200
     1.948    31.404     0.200
     2.248    35.875     0.200
     2.310    37.814     0.200
     2.602    43.594     0.200
     2.602    40.264     0.200
     2.671    45.615     0.200
     2.870    46.885     0.200
     2.901    45.475     0.200
     3.191    50.295     0.200
     3.208    51.035     0.200
     3.208    50.104     0.200
     3.308    51.994     0.200
     3.333    52.795     0.200
     3.483    54.854     0.200
     3.483    53.965     0.200
     3.542    53.064     0.200
     3.542    52.564     0.200
     3.750    58.814     0.200
     3.858    59.654     0.200
     3.932    61.145     0.200
     4.046    62.314     0.200
     4.120    63.414     0.200
     4.138    63.584     0.200
     4.380    67.523     0.200
     4.385    67.865     0.200
     4.426    67.584     0.200
     4.441    68.244     0.200
     4.453    66.734     0.200
     4.484    68.693     0.200
     4.541    69.725     0.200
     4.830    74.395     0.200
     4.947    75.184     0.200
     4.957    75.455     0.200
     5.226    78.354     0.200
     5.260    79.164     0.200
     5.670    86.254     0.200
     5.673    86.154     0.200
     5.980    92.154     0.200
     5.994    91.145     0.200
     6.668    99.814     0.200
     6.728   100.805     0.200
     6.755   102.604     0.200
     6.925   105.725     0.200
     7.074   103.654     0.200
     7.148   106.854     0.200
     7.183   107.434     0.200
     7.195   104.885     0.200
     7.467   106.375     0.200
     7.998   117.148     0.200
     8.816   130.154     0.200
     9.335   141.154     0.200
    10.927   161.104     0.200
    13.320   194.654     0.200
    15.031   212.045     0.200
    15.060   213.764     0.200
    15.081   213.645     0.200
    15.105   213.924     0.200
    15.501   220.715     0.200
    15.645   220.693     0.200
    15.690   223.094     0.200
    16.258   228.574     0.200
    16.370   229.254     0.200
    18.559   260.898     0.200
     1.856    30.480     0.200
     1.916    30.449     0.200
     1.943    30.391     0.200
     2.612    38.801     0.200
     2.782    42.900     0.200
     2.902    45.770     0.200
     3.230    51.061     0.200
     3.230    50.289     0.200
     3.455    53.279     0.200
     3.510    54.740     0.200
     3.725    58.320     0.200
     7.968   117.359     0.200
     8.813   125.029     0.200
     1.404    25.170     0.200
     1.467    26.439     0.200
     1.660    29.979     0.200
     1.707    29.930     0.200
     1.843    32.029     0.200
     1.877    32.469     0.200
     1.877    32.580     0.200
     1.943    32.219     0.200
     1.955    33.840     0.200
     1.955    33.709     0.200
     2.238    37.670     0.200
     2.307    38.100     0.200
     2.601    42.238     0.200
     2.601    39.920     0.200
     2.812    44.830     0.200
     2.668    45.318     0.200
     2.872    46.859     0.200
     2.872    45.699     0.200
     2.872    45.279     0.200
     2.864    45.459     0.200
     2.891    46.648     0.200
     3.210    51.469     0.200
     3.210    50.350     0.200
     3.189    50.068     0.200
     3.300    51.309     0.200
     3.328    51.629     0.200
     3.479    53.389     0.200
     3.479    55.539     0.200
     3.532    54.850     0.200
     3.532    56.408     0.200
     3.686    55.580     0.200
     3.716    59.238     0.200
     3.746    57.789     0.200
     3.855    59.000     0.200
     3.924    60.020     0.200
     4.039    61.719     0.200
     4.110    62.898     0.200
     4.150    63.609     0.200
     4.134    63.020     0.200
     4.374    66.670     0.200
     4.380    66.979     0.200
     4.380    68.088     0.200
     4.443    67.789     0.200
     4.420    66.959     0.200
     4.433    67.260     0.200
     4.479    67.879     0.200
     4.535    68.709     0.200
     4.820    72.949     0.200
     4.824    73.080     0.200
     4.889    73.398     0.200
     4.947    74.830     0.200
     4.938    74.689     0.200
     4.948    74.670     0.200
     5.042    79.000     0.200
     5.217    78.469     0.200
     5.250    78.850     0.200
     5.335    80.100     0.200
     5.316    79.260     0.200
     5.467    81.369     0.200
     5.639    85.039     0.200
     5.663    84.238     0.200
     5.660    84.350     0.200
     5.667    83.510     0.200
     5.698    84.039     0.200
     5.799    85.510     0.200
     5.970    91.100     0.200
     5.984    91.309     0.200
     5.993    89.898     0.200
     7.989   118.855     0.200
     8.811   130.055     0.200
     9.328   138.715     0.200
    10.918   160.773     0.200
    13.310   191.756     0.200
    13.873   199.477     0.200
    14.951   210.850     0.200
    14.995   210.408     0.200
    15.021   211.939     0.200
    15.050   212.170     0.200
    15.072   213.059     0.200
    15.095   213.539     0.200
    15.161   213.580     0.200
    15.192   214.389     0.200
    15.220   214.799     0.200
    15.217   214.148     0.200
    15.250   215.158     0.200
    15.295   215.580     0.200
    15.401   216.959     0.200
    15.459   217.350     0.200
    15.474   218.330     0.200
    15.493   217.869     0.200
    15.495   218.029     0.200
    15.558   219.129     0.200
    15.544   218.760     0.200
    15.631   220.199     0.200
    15.636   220.139     0.200
    15.682   220.979     0.200
    16.250   228.318     0.200
    16.324   229.119     0.200
    16.253   229.830     0.200
    16.629   233.000     0.200
    17.623   245.148     0.200
    18.551   258.574     0.200
    19.130   263.430     0.200
     1.920    31.668     0.200
     1.920    31.348     0.200
     1.988    30.730     0.200
     1.993    32.648     0.200
     3.523    53.609     0.200
     3.539    53.219     0.200
     3.614    54.188     0.200
     3.682    56.867     0.200
     1.408    24.934     0.200
     1.502    25.824     0.200
     1.740    29.555     0.200
     1.811    32.035     0.200
     1.911    32.035     0.200
     1.981    31.652     0.200
     1.982    32.984     0.200
     2.576    43.023     0.200
     2.834    48.074     0.200
     3.177    50.652     0.200
     3.515    56.355     0.200
     3.547    55.254     0.200
     3.606    56.793     0.200
     3.693    59.215     0.200
     4.418    70.406     0.200
     8.001   118.609     0.200
     8.796   130.258     0.200
     9.366   141.660     0.200
    10.955   163.020     0.200
    13.341   194.273     0.200
    18.588   261.105     0.200
     1.374    23.672     0.200
     1.482    25.039     0.200
     1.625    29.000     0.200
     1.718    28.844     0.200
     1.718    28.680     0.200
     1.798    31.078     0.200
     1.921    32.281     0.200
     1.921    32.062     0.200
     2.001    33.062     0.200
     2.001    32.773     0.200
     2.239    36.281     0.200
     2.350    37.430     0.200
     2.555    43.203     0.200
     2.555    41.000     0.200
     2.555    40.289     0.200
     2.710    44.258     0.200
     2.909    46.008     0.200
     2.838    46.633     0.200
     2.838    46.781     0.200
     3.165    49.938     0.200
     3.165    50.984     0.200
     3.232    51.289     0.200
     3.328    52.031     0.200
     3.366    53.117     0.200
     3.521    55.758     0.200
     3.521    53.680     0.200
     3.514    55.297     0.200
     3.514    54.250     0.200
     3.611    55.578     0.200
     3.647    56.680     0.200
     3.671    58.289     0.200
     3.787    58.023     0.200
     3.897    60.891     0.200
     3.947    61.289     0.200
     3.979    62.820     0.200
     4.070    62.961     0.200
     4.120    63.781     0.200
     4.117    63.984     0.200
     4.174    64.062     0.200
     4.410    66.523     0.200
     4.416    67.602     0.200
     4.416    67.070     0.200
     4.416    70.883     0.200
     4.436    67.930     0.200
     4.461    67.859     0.200
     4.519    70.617     0.200
     4.568    69.523     0.200
     4.795    73.070     0.200
     4.860    73.109     0.200
     4.946    74.844     0.200
     4.976    74.000     0.200
     5.235    78.062     0.200
     5.239    77.344     0.200
     5.260    80.203     0.200
     5.318    80.617     0.200
     5.654    84.641     0.200
     5.663    86.719     0.200
     5.707    85.484     0.200
     5.738    87.891     0.200
     5.744    85.914     0.200
     5.979    90.273     0.200
     5.986    90.969     0.200
     6.026    90.930     0.200
     6.298    94.172     0.200
     6.403    96.578     0.200
     6.425    97.359     0.200
     6.437    96.641     0.200
     6.531    96.594     0.200
     6.667   100.867     0.200
     6.720   100.828     0.200
     6.744    99.969     0.200
     6.783   100.141     0.200
     6.952   102.180     0.200
     7.041   104.359     0.200
     7.153   106.250     0.200
     7.163   106.328     0.200
     7.186   107.633     0.200
     7.609   112.914     0.200
     7.685   114.648     0.200
     7.742   114.141     0.200
     7.968   117.008     0.200
     8.653   127.312     0.200
     8.748   128.773     0.200
     8.769   128.242     0.200
     8.769   129.594     0.200
     9.360   138.812     0.200
    10.168   148.328     0.200
    10.423   152.062     0.200
    10.940   161.391     0.200
    10.928   158.781     0.200
    11.346   163.781     0.200
    11.535   168.070     0.200
    13.316   193.539     0.200
    13.316   192.703     0.200
    14.193   203.281     0.200
    15.241   215.062     0.200
    15.644   223.914     0.200
    15.674   219.500     0.200
    17.461   245.570     0.200
     1.406    24.727     0.200
     1.492    25.578     0.200
     1.632    28.969     0.200
     1.731    29.289     0.200
     1.819    31.297     0.200
     1.903    31.961     0.200
     1.903    32.273     0.200
     1.971    31.680     0.200
     1.976    33.391     0.200
     1.976    33.102     0.200
     2.258    37.031     0.200
     2.333    37.844     0.200
     2.582    42.742     0.200
     2.582    41.172     0.200
     2.582    40.250     0.200
     2.841    45.961     0.200
     2.694    44.648     0.200
     2.844    45.773     0.200
     2.893    45.977     0.200
     2.917    46.273     0.200
     3.185    49.594     0.200
     3.328    52.844     0.200
     3.356    53.812     0.200
     3.506    55.117     0.200
     3.506    54.891     0.200
     3.542    56.633     0.200
     3.542    55.969     0.200
     3.597    57.156     0.200
     3.774    58.242     0.200
     3.951    59.852     0.200
     4.067    62.680     0.200
     4.134    64.078     0.200
     4.149    63.438     0.200
     4.161    64.117     0.200
     4.403    67.938     0.200
     4.408    68.148     0.200
     4.408    70.922     0.200
     4.449    68.047     0.200
     4.462    68.438     0.200
     4.459    68.906     0.200
     4.507    70.297     0.200
     4.563    70.227     0.200
     4.825    74.453     0.200
     4.853    72.859     0.200
     4.917    74.594     0.200
     4.965    74.891     0.200
     5.236    79.078     0.200
     5.243    79.406     0.200
     5.273    80.047     0.200
     5.346    81.250     0.200
     5.495    82.219     0.200
     5.681    86.492     0.200
     5.678    85.453     0.200
     5.694    86.312     0.200
     5.776    86.812     0.200
     5.993    90.969     0.200
     6.004    89.688     0.200
     6.401    95.578     0.200
     6.417    96.000     0.200
     6.431    95.727     0.200
     6.523    98.430     0.200
     6.526    99.117     0.200
     6.682   101.461     0.200
     6.709   101.367     0.200
     6.748   101.094     0.200
     6.777   100.953     0.200
     6.783   100.398     0.200
     7.071   105.219     0.200
     7.102   106.383     0.200
     7.164   107.500     0.200
     7.198   108.422     0.200
     7.193   107.531     0.200
     7.490   107.461     0.200
     7.388   110.320     0.200
     7.439   110.844     0.200
     7.512   109.781     0.200
     7.600   112.141     0.200
     7.640   114.117     0.200
     7.691   116.328     0.200
     7.997   118.719     0.200
     7.997   117.422     0.200
     7.997   117.562     0.200
     8.798   129.922     0.200
     8.799   127.445     0.200
     8.799   129.922     0.200
     9.357   140.977     0.200
    10.945   161.672     0.200
    10.960   158.617     0.200
    12.094   175.594     0.200
    13.332   194.836     0.200
    15.474   220.383     0.200
    18.578   260.320     0.200
    20.570   282.500     0.200
     1.096    18.848     0.200
     1.090    19.629     0.200
     1.300    22.379     0.200
     1.515    25.727     0.200
     1.998    33.098     0.200
     2.155    34.945     0.200
     3.504    54.836     0.200
     1.432    24.883     0.200
     1.671    28.820     0.200
     1.849    31.109     0.200
     1.868    31.512     0.200
     1.868    31.730     0.200
     1.903    33.359     0.200
     1.924    31.051     0.200
     1.958    33.062     0.200
     2.597    43.301     0.200
     2.597    40.750     0.200
     3.218    51.730     0.200
     3.218    50.441     0.200
     3.466    53.582     0.200
     3.497    54.359     0.200
     3.708    58.520     0.200
     4.031    64.090     0.200
     5.022    77.152     0.200
     5.643    85.582     0.200
     7.954   117.352     0.200
     8.796   128.355     0.200
    13.272   193.836     0.200
    18.518   260.250     0.200
     0.631    13.352     0.200
     3.267    52.312     0.200
     3.390    53.312     0.200
     3.617    57.331     0.200
     3.707    59.111     0.200
     1.417    24.012     0.200
     2.005    32.902     0.200
     2.016    32.912     0.200
     3.547    53.723     0.200
     3.677    57.422     0.200
     3.639    55.111     0.200
     1.393    24.668     0.200
     1.496    25.607     0.200
     1.985    31.107     0.200
     1.994    33.066     0.200
     2.564    40.258     0.200
     2.831    45.578     0.200
     3.522    55.018     0.200
     3.612    55.758     0.200
     3.681    58.797     0.200
     9.368   141.467     0.200
     1.548    26.352     0.200
     1.790    30.078     0.200
     1.790    29.633     0.200
     1.899    30.422     0.200
     1.951    32.461     0.200
     1.987    32.531     0.200
     2.324    37.461     0.200
     2.332    38.039     0.200
     2.614    41.422     0.200
     2.614    41.570     0.200
     2.969    44.648     0.200
     3.210    49.938     0.200
     3.194    51.492     0.200
     3.365    51.242     0.200
     3.373    52.211     0.200
     3.508    54.352     0.200
     3.614    54.883     0.200
     3.614    57.609     0.200
     3.736    57.391     0.200
     4.215    63.102     0.200
     4.427    65.453     0.200
     4.896    72.133     0.200
     4.927    75.141     0.200
     5.034    74.602     0.200
     5.090    75.352     0.200
     5.418    78.750     0.200
     5.844    84.883     0.200
     6.069    87.742     0.200
     7.264   104.102     0.200
     7.501   108.773     0.200
     7.652   109.969     0.200
     7.698   111.719     0.200
     8.835   127.023     0.200
     8.848   127.688     0.200
    12.270   175.414     0.200
    14.736   207.414     0.200
    14.889   207.852     0.200
    15.259   213.758     0.200
    15.290   213.641     0.200
    15.515   216.797     0.200
    15.563   218.648     0.200
    15.602   217.828     0.200
    15.751   218.891     0.200
    15.897   222.734     0.200
     1.447    23.773     0.200
     1.602    28.352     0.200
     1.780    27.141     0.200
     1.813    31.445     0.200
     1.916    31.594     0.200
     1.974    31.281     0.200
     1.974    32.234     0.200
     1.998    31.086     0.200
     2.589    40.055     0.200
     3.175    49.812     0.200
     3.524    53.680     0.200
     3.708    59.352     0.200
     5.061    78.094     0.200
     8.044   117.273     0.200
     9.391   136.016     0.200
    13.382   189.930     0.200
     1.894    31.109     0.200
     2.597    41.438     0.200
     2.841    47.359     0.200
     3.562    57.945     0.200
     3.698    60.398     0.200
     5.053    79.266     0.200
     5.626    85.812     0.200
     8.017   119.609     0.200
     8.818   127.336     0.200
     0.975    16.773     0.200
     1.460    23.359     0.200
     1.524    24.648     0.200
     1.632    29.406     0.200
     1.766    28.406     0.200
     1.766    28.289     0.200
     1.885    30.914     0.200
     1.885    30.195     0.200
     1.943    31.469     0.200
     1.943    30.914     0.200
     1.968    30.406     0.200
     2.301    35.688     0.200
     2.317    36.617     0.200
     2.619    42.297     0.200
     2.619    40.523     0.200
     2.843    44.539     0.200
     2.843    45.398     0.200
     2.846    44.680     0.200
     2.682    44.445     0.200
     3.207    51.141     0.200
     3.354    51.328     0.200
     3.493    52.586     0.200
     3.493    54.711     0.200
     3.595    54.719     0.200
     3.595    55.180     0.200
     3.764    55.664     0.200
     3.971    60.156     0.200
     4.204    62.797     0.200
     4.408    65.125     0.200
     4.476    66.758     0.200
     4.507    68.375     0.200
     4.880    74.484     0.200
     5.010    74.266     0.200
     5.084    76.789     0.200
     5.308    79.891     0.200
     5.642    84.320     0.200
     5.830    85.445     0.200
     6.029    88.656     0.200
     6.046    88.414     0.200
     6.717    98.180     0.200
     7.125   103.555     0.200
     7.194   104.086     0.200
     7.230   105.297     0.200
     7.247   105.430     0.200
     7.479   106.539     0.200
     7.627   110.109     0.200
     7.643   110.891     0.200
     7.692   112.398     0.200
     8.051   117.258     0.200
     8.051   116.641     0.200
     8.604   124.641     0.200
     8.710   126.789     0.200
     8.830   128.891     0.200
     8.845   129.094     0.200
     8.846   129.094     0.200
     8.846   129.539     0.200
    12.281   174.109     0.200
    13.180   186.227     0.200
    14.543   206.695     0.200
    14.876   210.711     0.200
    15.529   219.297     0.200
    15.549   218.680     0.200
    15.597   220.500     0.200
     1.912    31.917     0.200
     1.928    32.517     0.200
     1.439    24.336     0.200
     1.521    24.646     0.200
     1.620    27.726     0.200
     1.761    28.576     0.200
     1.761    28.396     0.200
     1.825    29.686     0.200
     1.902    30.776     0.200
     1.902    30.906     0.200
     1.980    31.446     0.200
     1.964    30.996     0.200
     1.964    31.626     0.200
     2.291    36.176     0.200
     2.333    36.116     0.200
     2.596    41.016     0.200
     2.596    40.156     0.200
     2.854    45.116     0.200
     2.697    42.996     0.200
     2.906    44.516     0.200
     2.944    44.726     0.200
     3.188    49.806     0.200
     3.347    49.836     0.200
     3.366    50.746     0.200
     3.508    53.656     0.200
     3.508    53.876     0.200
     3.578    54.186     0.200
     3.578    54.476     0.200
     3.716    56.376     0.200
     3.778    57.176     0.200
     3.973    60.036     0.200
     4.084    62.146     0.200
     4.167    62.616     0.200
     4.419    65.786     0.200
     4.419    66.350     0.200
     4.860    72.206     0.200
     4.988    74.326     0.200
     4.995    73.346     0.200
     5.061    76.226     0.200
     5.809    85.186     0.200
     5.846    84.136     0.200
     5.941    91.126     0.200
     6.037    88.586     0.200
     6.557    96.806     0.200
     6.718    98.606     0.200
     6.770    98.396     0.200
     7.105   104.456     0.200
     7.228   104.746     0.200
     7.494   105.286     0.200
     7.627   111.256     0.200
     7.645   111.656     0.200
     7.668   112.426     0.200
     7.704   111.766     0.200
     7.723   112.106     0.200
     8.032   117.275     0.200
     8.032   117.106     0.200
     8.345   119.376     0.200
     8.592   124.436     0.200
     8.806   128.336     0.200
     8.822   128.481     0.200
     8.822   128.126     0.200
     9.356   134.596     0.200
     9.372   137.456     0.200
    10.211   146.146     0.200
    10.212   147.186     0.200
    10.464   151.336     0.200
    10.485   151.356     0.200
    10.699   154.136     0.200
    10.969   159.181     0.200
    10.977   156.776     0.200
    10.987   157.986     0.200
    12.163   173.996     0.200
    12.261   174.916     0.200
    12.616   180.826     0.200
    13.276   187.606     0.200
    13.363   189.600     0.200
    13.605   193.566     0.200
    13.611   193.856     0.200
    13.688   193.866     0.200
    13.834   196.386     0.200
    13.913   200.794     0.200
    14.030   199.866     0.200
    14.094   198.786     0.200
    14.108   198.566     0.200
    14.319   202.876     0.200
    14.520   204.456     0.200
    14.608   207.606     0.200
    14.658   207.436     0.200
    14.811   210.716     0.200
    14.811   211.386     0.200
    14.840   209.756     0.200
    14.855   210.796     0.200
    14.964   211.706     0.200
    15.049   211.606     0.200
    15.058   213.076     0.200
    15.075   212.126     0.200
    15.125   212.676     0.200
    15.135   214.486     0.200
    15.195   215.226     0.200
    15.225   214.476     0.200
    15.255   214.796     0.200
    15.267   215.616     0.200
    15.407   217.206     0.200
    15.490   220.716     0.200
    15.528   219.806     0.200
    15.574   219.196     0.200
    15.588   220.616     0.200
    15.658   222.096     0.200
    15.716   221.446     0.200
    15.845   222.836     0.200
    15.987   225.336     0.200
    15.978   225.666     0.200
    16.284   229.286     0.200
    16.355   230.526     0.200
    16.390   231.376     0.200
    16.674   233.776     0.200
    16.901   236.476     0.200
    16.941   237.286     0.200
    16.954   237.006     0.200
    16.988   237.626     0.200
    17.016   236.546     0.200
    17.049   238.116     0.200
    17.151   238.896     0.200
    17.374   242.226     0.200
    17.526   243.456     0.200
    17.672   246.256     0.200
    17.737   247.856     0.200
    17.813   248.166     0.200
    18.601   259.950     0.200
     1.393    24.881     0.200
     1.492    25.922     0.200
     1.624    30.250     0.200
     1.730    29.641     0.200
     1.730    29.451     0.200
     1.806    31.941     0.200
     1.915    32.012     0.200
     1.980    31.570     0.200
     1.990    33.070     0.200
     2.253    37.012     0.200
     2.567    44.611     0.200
     2.567    41.320     0.200
     2.918    46.941     0.200
     3.532    56.201     0.200
     3.684    57.432     0.200
     4.132    64.951     0.200
     4.136    64.541     0.200
     4.452    68.891     0.200
     4.813    74.750     0.200
     4.961    75.541     0.200
     5.271    81.721     0.200
     5.336    80.740     0.200
     5.670    85.342     0.200
     5.677    86.391     0.200
     5.763    86.611     0.200
     5.991    91.682     0.200
     6.000    90.750     0.200
     6.680   100.801     0.200
     6.751   102.971     0.200
     6.788   104.641     0.200
     7.059   103.621     0.200
     7.181   105.291     0.200
     7.197   107.871     0.200
     7.500   108.441     0.200
     7.392   113.281     0.200
     7.425   108.980     0.200
     7.601   114.172     0.200
     7.624   114.711     0.200
     7.626   112.141     0.200
     7.695   114.691     0.200
     7.677   115.512     0.200
     7.753   116.230     0.200
     7.983   115.932     0.200
     7.983   116.041     0.200
     7.986   117.955     0.200
     7.986   116.961     0.200
     8.381   121.512     0.200
     8.643   125.691     0.200
     8.670   126.092     0.200
     8.783   129.141     0.200
     8.784   129.621     0.200
     8.784   128.922     0.200
     9.363   142.297     0.200
    10.945   161.271     0.200
    13.329   194.082     0.200
    13.705   195.410     0.200
    15.247   214.602     0.200
    15.481   219.271     0.200
    15.533   220.631     0.200
    15.626   221.211     0.200
    15.670   221.871     0.200
    16.345   230.271     0.200
    16.626   233.480     0.200
    17.479   244.230     0.200
     1.416    24.875     0.200
     1.512    25.527     0.200
     1.751    29.047     0.200
     1.915    30.715     0.200
     1.915    32.156     0.200
     1.983    32.527     0.200
     1.983    32.777     0.200
     1.987    33.488     0.200
     2.577    40.625     0.200
     2.827    44.207     0.200
     3.557    55.566     0.200
     3.695    57.098     0.200
     5.037    76.527     0.200
     5.606    84.277     0.200
     1.437    25.266     0.200
     1.548    25.746     0.200
     1.586    29.938     0.200
     1.787    29.438     0.200
     1.794    29.605     0.200
     1.935    31.527     0.200
     1.935    32.137     0.200
     1.993    32.695     0.200
     2.015    31.848     0.200
     2.312    36.988     0.200
     2.367    37.926     0.200
     2.570    41.285     0.200
     2.570    40.566     0.200
     2.731    46.168     0.200
     2.973    46.387     0.200
     3.156    49.547     0.200
     3.542    55.297     0.200
     3.585    55.258     0.200
     3.585    54.996     0.200
     3.634    57.348     0.200
     3.693    57.086     0.200
     3.691    56.797     0.200
     4.005    61.785     0.200
     4.176    64.355     0.200
     4.453    71.234     0.200
     4.509    68.785     0.200
     4.861    73.996     0.200
     5.020    75.977     0.200
     5.046    77.117     0.200
     5.591    82.957     0.200
     5.807    86.977     0.200
     6.058    89.035     0.200
     6.801   101.117     0.200
     6.824    99.355     0.200
     7.231   106.945     0.200
     7.528   107.988     0.200
     7.460   110.367     0.200
     7.654   113.027     0.200
     7.677   112.355     0.200
     7.677   115.547     0.200
     8.038   118.109     0.200
     8.038   117.785     0.200
     8.038   118.457     0.200
     8.608   126.957     0.200
     8.791   129.477     0.200
     8.804   128.391     0.200
     8.804   129.188     0.200
     9.406   140.395     0.200
    10.413   154.176     0.200
    11.000   162.840     0.200
    10.971   160.367     0.200
    11.409   164.156     0.200
    11.928   174.207     0.200
    12.019   173.316     0.200
    12.105   175.406     0.200
    12.230   179.117     0.200
    12.230   178.645     0.200
    12.655   182.488     0.200
    13.128   191.137     0.200
    13.218   190.285     0.200
    13.387   193.965     0.200
    13.387   192.535     0.200
    13.601   194.348     0.200
    13.702   198.926     0.200
    14.111   201.676     0.200
    15.558   221.195     0.200
    18.632   260.785     0.200
    18.632   261.957     0.200
    19.504   269.637     0.200
     1.939    32.781     0.200
     2.017    32.621     0.200
     2.000    33.723     0.200
     2.889    47.102     0.200
     3.150    48.672     0.200
     3.575    53.242     0.200
     3.546    57.930     0.200
     8.794   129.227     0.200
     1.425    23.535     0.200
     1.917    31.176     0.200
     1.917    31.402     0.200
     1.992    30.574     0.200
     2.579    40.004     0.200
     2.822    46.074     0.200
     3.172    48.695     0.200
     3.522    55.355     0.200
     3.567    54.984     0.200
     5.044    74.844     0.200
     0.957    16.629     0.200
     1.447    24.758     0.200
     1.675    29.195     0.200
     1.869    31.219     0.200
     1.849    31.695     0.200
     1.930    30.477     0.200
     1.953    32.586     0.200
     1.953    31.258     0.200
     2.602    42.469     0.200
     3.218    51.617     0.200
     3.469    51.996     0.200
     3.515    54.379     0.200
     3.678    58.516     0.200
     3.715    57.836     0.200
     5.035    76.977     0.200
     8.806   128.891     0.200
    18.531   260.387     0.200
     0.860    17.227     0.200
     0.860    17.125     0.200
     1.422    24.727     0.200
     1.583    28.742     0.200
     1.942    31.938     0.200
     2.018    31.828     0.200
     2.004    33.070     0.200
     2.558    40.875     0.200
     2.795    46.945     0.200
     3.147    49.266     0.200
     3.571    53.258     0.200
     3.548    56.266     0.200
     3.678    55.352     0.200
     5.031    75.430     0.200
     0.881    14.848     0.200
     0.881    15.528     0.200
     1.923    31.558     0.200
     1.923    31.748     0.200
     1.997    30.308     0.200
     1.989    32.768     0.200
     3.563    55.608     0.200
     3.691    57.318     0.200
     5.037    73.188     0.200
     1.299    23.391     0.200
     1.404    23.945     0.200
     1.637    27.594     0.200
     1.673    29.930     0.200
     1.911    30.734     0.200
     1.911    31.836     0.200
     2.017    32.945     0.200
     2.017    33.227     0.200
     3.177    50.188     0.200
     3.428    53.516     0.200
     3.501    55.797     0.200
     3.591    57.469     0.200
     4.948    77.977     0.200
     5.595    85.898     0.200
     7.884   116.016     0.200
     8.725   127.570     0.200
    10.869   156.594     0.200
    13.231   190.273     0.200
     2.592    40.908     0.200
     3.246    49.278     0.200
     3.398    53.288     0.200
     3.428    55.048     0.200
     3.516    54.269     0.200
     1.419    24.738     0.200
     1.758    29.660     0.200
     1.920    32.391     0.200
     1.920    31.301     0.200
     1.986    34.590     0.200
     2.574    43.180     0.200
     2.821    46.758     0.200
     3.169    52.789     0.200
     3.561    57.848     0.200
     0.910    14.633     0.200
     1.444    23.742     0.200
     1.505    25.945     0.200
     1.643    26.742     0.200
     1.746    29.492     0.200
     1.847    30.586     0.200
     1.880    31.211     0.200
     1.944    32.172     0.200
     1.958    32.461     0.200
     2.311    36.133     0.200
     2.280    36.742     0.200
     2.615    43.320     0.200
     2.675    43.516     0.200
     2.926    45.984     0.200
     3.191    48.773     0.200
     3.343    50.344     0.200
     3.486    52.227     0.200
     3.486    55.227     0.200
     3.576    56.641     0.200
     3.954    59.062     0.200
     4.063    60.562     0.200
     4.144    61.727     0.200
     4.149    63.172     0.200
     4.188    63.992     0.200
     4.396    64.352     0.200
     4.491    66.281     0.200
     4.487    66.836     0.200
     4.974    72.320     0.200
     4.990    74.570     0.200
     5.073    75.555     0.200
     5.252    78.406     0.200
     5.289    79.461     0.200
     5.379    80.125     0.200
     5.813    84.211     0.200
     6.009    89.453     0.200
     6.025    89.336     0.200
     7.107   103.297     0.200
     7.228   104.414     0.200
     7.478   106.273     0.200
     7.626   111.617     0.200
     7.706   113.336     0.200
     8.032   119.156     0.200
     8.724   126.992     0.200
     8.837   126.039     0.200
     8.837   128.805     0.200
    10.198   146.562     0.200
    15.060   214.117     0.200
    15.110   214.594     0.200
    15.230   216.227     0.200
    15.441   217.414     0.200
    15.513   218.977     0.200
    15.533   218.461     0.200
    15.671   220.836     0.200
    15.676   220.453     0.200
    15.992   224.664     0.200
    16.289   228.820     0.200
    16.398   230.797     0.200
     0.901    15.852     0.200
     0.901    16.148     0.200
     1.414    24.922     0.200
     1.504    25.672     0.200
     1.743    28.898     0.200
     1.908    32.469     0.200
     1.908    31.832     0.200
     1.816    30.449     0.200
     1.977    33.910     0.200
     1.977    32.160     0.200
     1.979    32.570     0.200
     2.338    37.809     0.200
     2.269    36.648     0.200
     2.581    41.922     0.200
     2.581    41.461     0.200
     2.581    39.961     0.200
     2.700    45.391     0.200
     2.836    47.492     0.200
     2.836    46.621     0.200
     2.928    46.129     0.200
     3.219    49.520     0.200
     3.181    51.199     0.200
     3.364    53.172     0.200
     3.338    52.281     0.200
     3.512    53.512     0.200
     3.512    55.320     0.200
     3.603    57.129     0.200
     3.552    53.898     0.200
     3.552    56.410     0.200
     3.552    56.699     0.200
     3.780    58.141     0.200
     3.961    60.422     0.200
     4.077    62.172     0.200
     4.168    63.000     0.200
     4.145    62.570     0.200
     4.156    63.039     0.200
     4.416    67.090     0.200
     4.416    70.715     0.200
     4.470    66.840     0.200
     4.834    71.961     0.200
     4.986    74.699     0.200
     4.978    74.930     0.200
     5.038    78.020     0.200
     5.285    77.320     0.200
     5.356    79.820     0.200
     5.612    84.750     0.200
     5.732    83.340     0.200
     5.784    86.309     0.200
     5.937    89.762     0.200
     6.015    89.551     0.200
     6.532    96.102     0.200
     6.785    98.121     0.200
     6.758    99.422     0.200
     6.792    99.469     0.200
     7.496   105.422     0.200
     7.445   109.492     0.200
     7.445   110.719     0.200
     7.707   111.301     0.200
     7.645   112.281     0.200
     7.690   112.172     0.200
     7.690   116.730     0.200
     7.764   112.660     0.200
     8.007   117.789     0.200
     8.007   116.512     0.200
     8.007   119.082     0.200
     8.007   115.590     0.200
     8.401   121.762     0.200
     8.784   127.750     0.200
     8.829   132.039     0.200
     8.801   127.809     0.200
     8.802   128.969     0.200
     9.365   141.102     0.200
    10.956   162.570     0.200
    10.937   157.809     0.200
    11.385   161.719     0.200
    12.139   171.910     0.200
    12.252   179.871     0.200
    12.595   179.191     0.200
    12.656   180.281     0.200
    13.084   184.770     0.200
    13.580   196.242     0.200
    14.496   204.961     0.200
    14.975   210.699     0.200
    14.956   210.711     0.200
    15.260   215.109     0.200
    15.465   216.801     0.200
    15.502   217.492     0.200
    15.552   222.582     0.200
    15.552   221.371     0.200
    16.261   229.219     0.200
    16.647   231.961     0.200
    16.875   235.320     0.200
    18.588   261.238     0.200
    18.588   261.840     0.200
    19.468   271.320     0.200
    19.468   270.672     0.200
    20.367   280.859     0.200
    20.367   280.469     0.200
     1.414    24.633     0.200
     1.733    28.852     0.200
     1.896    31.305     0.200
     1.968    32.406     0.200
     1.967    30.445     0.200
     2.262    36.609     0.200
     2.327    37.195     0.200
     2.590    42.242     0.200
     2.688    43.516     0.200
     2.918    45.602     0.200
     3.326    51.625     0.200
     3.352    50.109     0.200
     3.500    53.102     0.200
     3.549    54.477     0.200
     3.707    57.250     0.200
     3.688    55.055     0.200
     3.768    55.984     0.200
     3.950    59.203     0.200
     4.158    63.000     0.200
     4.136    63.477     0.200
     4.404    65.000     0.200
     4.404    69.508     0.200
     4.460    66.594     0.200
     4.833    71.906     0.200
     4.971    74.922     0.200
     5.275    78.820     0.200
     5.353    80.812     0.200
     5.684    84.664     0.200
     5.784    85.602     0.200
     6.008    89.156     0.200
     6.534    95.812     0.200
     6.943   100.852     0.200
     7.078   103.977     0.200
     7.200   104.945     0.200
     7.199   105.070     0.200
     7.484   105.625     0.200
     7.448   109.391     0.200
     7.649   112.164     0.200
     7.621   111.305     0.200
     8.004   114.812     0.200
     8.004   116.172     0.200
     8.789   128.414     0.200
     8.808   128.844     0.200
     8.808   126.508     0.200
     8.808   129.266     0.200
     9.354   138.484     0.200
     9.447   137.016     0.200
     9.602   140.680     0.200
    10.945   159.602     0.200
    13.335   191.625     0.200
    14.767   207.742     0.200
    15.097   212.492     0.200
    15.201   213.156     0.200
    15.321   213.922     0.200
    18.577   260.359     0.200
     0.936    16.482     0.200
     1.443    24.043     0.200
     1.565    26.493     0.200
     1.783    31.643     0.200
     1.804    29.213     0.200
     1.949    31.213     0.200
     1.949    31.393     0.200
     2.003    32.383     0.200
     2.031    32.083     0.200
     2.381    39.453     0.200
     2.562    42.463     0.200
     2.746    45.533     0.200
     2.990    47.343     0.200
     3.143    50.022     0.200
     3.398    51.583     0.200
     3.417    53.893     0.200
     3.557    56.003     0.200
     3.595    54.283     0.200
     3.595    55.743     0.200
     3.685    57.493     0.200
     3.828    59.293     0.200
     4.023    61.913     0.200
     4.216    64.663     0.200
     4.206    64.503     0.200
     4.180    64.963     0.200
     4.470    67.203     0.200
     4.523    69.703     0.200
     5.046    79.913     0.200
     5.813    86.493     0.200
     6.074    90.993     0.200
     7.271   109.373     0.200
     7.240   106.333     0.200
     7.655   114.403     0.200
     8.047   116.917     0.200
     8.047   117.562     0.200
     8.700   127.713     0.200
     8.796   133.073     0.200
     8.801   126.699     0.200
     8.801   128.913     0.200
    10.973   156.883     0.200
    11.842   173.062     0.200
    13.403   195.677     0.200
    15.196   216.053     0.200
    15.225   217.022     0.200
    15.316   215.593     0.200
    15.394   217.573     0.200
    15.399   219.793     0.200
    15.498   217.213     0.200
    15.507   221.343     0.200
    15.531   222.453     0.200
    15.556   221.873     0.200
    15.718   223.533     0.200
    15.863   221.863     0.200
    17.884   247.893     0.200
    18.650   262.142     0.200
     0.932    16.859     0.200
     1.398    24.820     0.200
     1.471    24.973     0.200
     1.652    30.441     0.200
     1.711    29.020     0.200
     1.711    29.859     0.200
     1.833    32.051     0.200
     1.888    31.660     0.200
     1.888    31.512     0.200
     1.952    32.293     0.200
     1.966    32.781     0.200
     2.239    37.852     0.200
     2.317    38.602     0.200
     2.591    44.609     0.200
     2.591    41.223     0.200
     2.677    46.262     0.200
     2.896    46.852     0.200
     3.199    50.641     0.200
     3.199    49.883     0.200
     3.307    51.820     0.200
     3.337    52.332     0.200
     3.489    54.871     0.200
     3.489    54.980     0.200
     3.529    55.703     0.200
     3.529    55.871     0.200
     3.529    55.250     0.200
     3.706    57.820     0.200
     3.756    58.070     0.200
     3.930    61.082     0.200
     4.047    63.000     0.200
     4.113    63.711     0.200
     4.143    65.359     0.200
     4.144    64.070     0.200
     4.388    69.262     0.200
     4.388    67.840     0.200
     4.388    66.711     0.200
     4.440    67.902     0.200
     4.442    68.051     0.200
     5.034    77.070     0.200
     5.628    81.293     0.200
     5.767    86.891     0.200
     5.985    90.410     0.200
     7.435   110.551     0.200
     7.435   110.680     0.200
     7.639   113.180     0.200
     7.701   115.812     0.200
     7.701   117.133     0.200
     7.701   116.582     0.200
     7.985   117.312     0.200
     7.985   117.582     0.200
     7.985   117.941     0.200
     7.985   118.180     0.200
     7.985   116.820     0.200
     7.985   117.230     0.200
     8.540   127.602     0.200
     8.780   128.711     0.200
     8.801   128.812     0.200
     8.802   128.633     0.200
     8.838   129.332     0.200
     8.985   131.840     0.200
     9.306   136.902     0.200
     9.332   137.051     0.200
     9.336   139.328     0.200
     9.336   137.910     0.200
    10.098   147.211     0.200
    10.414   152.012     0.200
    10.650   154.270     0.200
    10.924   160.145     0.200
    10.959   159.102     0.200
    11.377   164.781     0.200
    11.441   165.512     0.200
    11.561   168.781     0.200
    12.269   177.422     0.200
    12.269   180.770     0.200
    13.294   190.531     0.200
    13.312   188.281     0.200
    13.312   192.684     0.200
    13.312   190.480     0.200
    13.566   196.332     0.200
    13.882   200.062     0.200
    13.914   199.402     0.200
    14.003   201.820     0.200
    14.069   201.770     0.200
    14.801   211.062     0.200
    14.930   213.012     0.200
    14.941   213.223     0.200
    15.020   213.680     0.200
    15.549   221.551     0.200
    15.549   222.820     0.200
    15.549   221.980     0.200
    15.676   223.711     0.200
    15.824   224.410     0.200
    16.019   227.953     0.200
    16.193   228.750     0.200
    16.244   230.602     0.200
    16.317   232.461     0.200
    16.633   234.891     0.200
    16.636   235.383     0.200
    16.909   237.980     0.200
    17.629   247.570     0.200
    18.556   259.301     0.200
    19.443   270.680     0.200
    19.930   274.742     0.200
    20.350   280.320     0.200
     1.616    27.010     0.200
     1.746    27.889     0.200
     1.807    29.969     0.200
     1.917    30.078     0.200
     1.987    30.379     0.200
     1.987    32.719     0.200
     1.987    32.898     0.200
     2.270    36.328     0.200
     2.347    37.029     0.200
     2.572    41.139     0.200
     2.572    38.369     0.200
     2.856    46.479     0.200
     2.709    44.559     0.200
     2.828    46.709     0.200
     2.932    45.469     0.200
     3.228    50.328     0.200
     3.171    50.078     0.200
     3.171    49.549     0.200
     3.344    51.930     0.200
     3.372    52.850     0.200
     3.549    54.488     0.200
     3.549    55.578     0.200
     3.611    58.559     0.200
     3.690    56.750     0.200
     3.788    58.109     0.200
     3.967    59.939     0.200
     4.148    62.850     0.200
     4.176    62.869     0.200
     4.150    63.568     0.200
     4.424    66.209     0.200
     4.424    69.033     0.200
     4.464    66.828     0.200
     4.469    68.078     0.200
     4.868    72.760     0.200
     4.979    75.629     0.200
     5.031    76.148     0.200
     5.258    77.479     0.200
     5.287    78.969     0.200
     5.353    80.879     0.200
     5.603    82.680     0.200
     5.694    84.939     0.200
     5.688    84.760     0.200
     5.779    87.129     0.200
     7.076   104.619     0.200
     7.505   106.119     0.200
     7.438   110.078     0.200
     7.438   110.689     0.200
     7.438   110.238     0.200
     7.637   111.430     0.200
     7.638   111.189     0.200
     7.681   111.379     0.200
     7.681   116.898     0.200
     7.681   113.340     0.200
     7.681   116.639     0.200
     8.003   117.783     0.200
     8.003   115.898     0.200
     8.003   118.279     0.200
     8.003   117.939     0.200
     8.003   115.898     0.200
     8.568   126.760     0.200
     8.683   126.898     0.200
     8.793   129.340     0.200
     8.794   128.551     0.200
     8.820   126.238     0.200
    10.093   146.779     0.200
    10.961   162.139     0.200
    10.957   155.869     0.200
    11.838   168.648     0.200
    12.070   169.719     0.200
    12.373   177.279     0.200
    12.587   178.020     0.200
    12.797   181.930     0.200
    13.346   193.738     0.200
    13.328   187.908     0.200
    13.574   196.039     0.200
    13.734   191.898     0.200
    13.768   192.559     0.200
    14.489   203.709     0.200
    14.686   205.898     0.200
    14.692   204.389     0.200
    15.134   211.520     0.200
    15.164   213.760     0.200
    15.194   213.309     0.200
    15.397   215.449     0.200
    15.476   217.479     0.200
    15.544   218.738     0.200
    15.685   220.818     0.200
    16.253   228.270     0.200
    16.324   228.869     0.200
    18.176   251.029     0.200
    18.593   260.684     0.200
    18.593   261.209     0.200
    19.466   270.459     0.200
    20.362   280.129     0.200
     1.536    25.311     0.200
     1.935    31.301     0.200
     2.010    30.830     0.200
     1.997    32.561     0.200
     1.997    32.400     0.200
     2.564    37.850     0.200
     3.155    46.510     0.200
     3.540    55.270     0.200
     3.632    53.291     0.200
     3.682    56.750     0.200
     3.685    56.770     0.200
     5.589    82.480     0.200
     8.023   117.799     0.200
     8.794   125.305     0.200
    13.374   194.332     0.200
    18.622   261.600     0.200
     1.792    29.746     0.200
     1.946    31.918     0.200
     2.004    32.938     0.200
     2.025    32.797     0.200
     2.560    39.848     0.200
     2.788    45.578     0.200
     3.145    50.535     0.200
     3.583    55.676     0.200
     3.553    56.406     0.200
     5.038    79.047     0.200
     1.744    29.178     0.200
     1.921    31.918     0.200
     1.990    31.607     0.200
     1.992    32.969     0.200
     2.826    47.438     0.200
     2.826    47.277     0.200
     3.167    51.838     0.200
     3.524    55.758     0.200
     3.544    55.768     0.200
     3.684    58.697     0.200
     3.981    63.508     0.200
     5.024    78.158     0.200
     5.598    86.688     0.200
     7.998   119.771     0.200
     8.788   128.490     0.200
     9.374   141.617     0.200
    13.343   195.018     0.200
     2.683    43.868     0.200
     2.683    42.908     0.200
     3.347    53.768     0.200
     3.347    51.318     0.200
     3.397    51.598     0.200
     3.414    53.208     0.200
     3.669    59.038     0.200
     3.779    58.978     0.200
     1.792    29.225     0.200
     2.671    43.534     0.200
     2.671    43.725     0.200
     3.347    51.574     0.200
     3.435    54.264     0.200
     3.328    53.225     0.200
     3.328    51.304     0.200
     3.415    53.514     0.200
     3.770    58.904     0.200
     1.375    24.367     0.200
     1.447    24.359     0.200
     1.685    28.078     0.200
     1.685    28.555     0.200
     1.666    30.336     0.200
     1.884    31.414     0.200
     1.941    30.758     0.200
     1.834    32.039     0.200
     1.970    32.781     0.200
     1.970    33.055     0.200
     1.888    33.086     0.200
     2.212    36.570     0.200
     2.312    38.375     0.200
     2.585    42.336     0.200
     2.585    41.109     0.200
     2.805    46.055     0.200
     2.872    45.656     0.200
     2.878    46.750     0.200
     2.878    47.500     0.200
     2.878    49.406     0.200
     3.288    51.328     0.200
     3.202    50.164     0.200
     3.202    48.531     0.200
     3.325    52.438     0.200
     3.482    53.984     0.200
     3.502    55.219     0.200
     3.572    55.656     0.200
     3.660    56.586     0.200
     3.747    57.891     0.200
     3.698    57.766     0.200
     4.016    63.156     0.200
     4.121    63.852     0.200
     4.375    67.367     0.200
     4.375    69.102     0.200
     4.421    67.984     0.200
     4.395    67.352     0.200
     4.839    73.156     0.200
     5.017    74.867     0.200
     5.227    79.125     0.200
     5.305    80.852     0.200
     5.634    84.891     0.200
     5.744    87.500     0.200
     5.958    87.695     0.200
     5.986    88.219     0.200
     6.705    98.117     0.200
     6.743   100.688     0.200
     7.155   106.570     0.200
     7.348   106.648     0.200
     7.556   110.406     0.200
     7.622   112.289     0.200
     7.959   116.055     0.200
     7.959   117.398     0.200
     8.776   126.961     0.200
     8.764   127.734     0.200
     8.787   129.109     0.200
     8.788   129.586     0.200
     8.788   129.305     0.200
     8.845   131.047     0.200
     9.320   134.875     0.200
    10.902   159.133     0.200
    12.578   180.055     0.200
    13.286   191.961     0.200
    18.535   260.680     0.200
     1.667    28.898     0.200
     1.833    31.305     0.200
     1.972    31.250     0.200
     2.583    41.742     0.200
     3.202    50.539     0.200
     3.656    55.422     0.200
     3.695    57.219     0.200
     0.890    15.539     0.200
     1.407    24.242     0.200
     1.511    23.992     0.200
     1.749    28.289     0.200
     1.923    31.078     0.200
     1.923    31.336     0.200
     1.993    32.156     0.200
     1.993    32.773     0.200
     1.993    30.766     0.200
     2.273    36.484     0.200
     2.353    36.898     0.200
     2.567    39.453     0.200
     2.567    41.734     0.200
     2.862    43.438     0.200
     2.715    44.234     0.200
     2.937    45.617     0.200
     3.234    49.297     0.200
     3.165    49.992     0.200
     3.165    49.414     0.200
     3.350    51.156     0.200
     3.378    52.797     0.200
     3.527    53.773     0.200
     3.618    53.555     0.200
     3.549    54.109     0.200
     3.549    53.883     0.200
     3.685    57.117     0.200
     3.795    57.664     0.200
     3.902    59.258     0.200
     3.972    60.734     0.200
     4.183    64.156     0.200
     4.152    63.117     0.200
     4.483    68.227     0.200
     4.986    74.695     0.200
     5.777    86.008     0.200
     7.435   109.328     0.200
     7.634   111.617     0.200
     7.715   112.773     0.200
     8.003   116.906     0.200
     8.003   116.406     0.200
     8.679   126.180     0.200
     8.788   126.828     0.200
     8.789   127.742     0.200
    10.966   161.383     0.200
    13.349   194.273     0.200
    13.724   195.062     0.200
    15.342   217.109     0.200
    15.405   217.523     0.200
    15.457   218.008     0.200
    15.474   218.492     0.200
    15.540   218.398     0.200
    15.495   218.547     0.200
    15.676   221.297     0.200
    15.835   222.125     0.200
    15.830   220.344     0.200
    15.954   223.625     0.200
    16.251   228.062     0.200
    16.254   227.477     0.200
    16.639   233.125     0.200
    16.870   236.383     0.200
    18.598   260.727     0.200
     1.489    24.945     0.200
     1.728    28.615     0.200
     1.819    30.295     0.200
     1.903    31.676     0.200
     1.970    30.955     0.200
     1.977    33.055     0.200
     1.977    32.705     0.200
     2.581    40.525     0.200
     2.581    39.506     0.200
     3.185    50.506     0.200
     3.185    50.355     0.200
     3.505    55.385     0.200
     3.538    55.166     0.200
     3.676    57.865     0.200
     3.676    59.406     0.200
     3.697    57.055     0.200
     5.031    74.625     0.200
     5.615    83.055     0.200
     1.656    28.117     0.200
     1.882    31.668     0.200
     1.838    32.629     0.200
     1.948    31.148     0.200
     1.864    32.449     0.200
     1.960    32.629     0.200
     2.596    40.836     0.200
     3.205    51.719     0.200
     3.205    49.938     0.200
     3.484    51.988     0.200
     3.532    55.746     0.200
     3.683    58.508     0.200
     3.711    58.039     0.200
     5.039    77.109     0.200
     5.634    82.477     0.200
     0.945    16.703     0.200
     1.482    25.613     0.200
     1.653    29.230     0.200
     1.879    31.582     0.200
     1.843    32.113     0.200
     1.949    31.453     0.200
     1.952    32.852     0.200
     2.606    43.082     0.200
     2.865    47.773     0.200
     3.209    51.594     0.200
     3.573    57.992     0.200
     3.698    58.504     0.200
     3.698    59.742     0.200
     3.722    58.863     0.200
     8.005   117.676     0.200
     8.820   128.031     0.200
     9.337   140.258     0.200
    10.931   160.855     0.200
    13.325   193.734     0.200
     1.555    27.180     0.200
     1.586    28.234     0.200
     1.621    27.461     0.200
     1.866    31.148     0.200
     1.904    32.328     0.200
     1.904    32.188     0.200
     1.929    31.852     0.200
     1.929    31.992     0.200
     2.016    32.414     0.200
     2.650    43.289     0.200
     2.650    41.781     0.200
     2.793    45.680     0.200
     3.202    51.297     0.200
     3.614    54.070     0.200
     3.700    57.430     0.200
     3.777    58.930     0.200
     5.646    84.242     0.200
     8.155   120.531     0.200
     8.904   132.844     0.200
    11.053   163.844     0.200
     1.929    31.727     0.200
     2.003    30.828     0.200
     1.995    31.078     0.200
     2.565    42.039     0.200
     3.561    57.352     0.200
     3.534    55.789     0.200
     3.677    57.578     0.200
     3.677    58.898     0.200
     3.684    57.711     0.200
     5.592    86.461     0.200
     1.460    24.669     0.200
     1.559    25.279     0.200
     1.799    28.949     0.200
     1.925    31.949     0.200
     1.925    29.949     0.200
     2.011    29.449     0.200
     2.588    42.269     0.200
     2.588    40.319     0.200
     2.800    44.989     0.200
     3.168    50.709     0.200
     3.168    46.719     0.200
     3.534    53.919     0.200
     3.626    51.529     0.200
     3.606    55.249     0.200
     3.710    58.109     0.200
     3.715    57.049     0.200
     4.450    69.673     0.200
     8.059   117.698     0.200
     8.824   129.129     0.200
     9.406   140.304     0.200
    18.638   260.836     0.200
     1.436    24.464     0.200
     1.933    31.814     0.200
     1.991    32.724     0.200
     2.012    31.004     0.200
     2.571    40.064     0.200
     2.801    45.664     0.200
     3.158    49.424     0.200
     3.540    57.014     0.200
     3.583    56.344     0.200
     3.631    57.324     0.200
     1.650    28.885     0.200
     1.917    33.265     0.200
     1.917    33.035     0.200
     1.964    32.115     0.200
     2.011    34.104     0.200
     2.011    33.555     0.200
     2.343    38.995     0.200
     2.543    41.645     0.200
     2.543    40.395     0.200
     2.700    43.995     0.200
     2.868    44.435     0.200
     2.862    45.975     0.200
     2.862    47.825     0.200
     3.169    50.145     0.200
     3.227    49.075     0.200
     3.296    50.104     0.200
     3.346    50.745     0.200
     3.511    53.774     0.200
     3.466    54.095     0.200
     3.466    54.325     0.200
     3.601    56.395     0.200
     3.614    58.295     0.200
     3.774    57.064     0.200
     3.888    60.285     0.200
     3.912    59.695     0.200
     4.076    61.915     0.200
     4.971    76.104     0.200
     5.195    76.845     0.200
     5.215    77.925     0.200
     5.270    78.665     0.200
     5.592    84.705     0.200
     5.605    83.075     0.200
     5.701    84.725     0.200
     5.938    87.255     0.200
     6.995   103.064     0.200
     7.491   106.915     0.200
     7.370   111.175     0.200
     7.576   110.425     0.200
     7.655   111.755     0.200
     7.655   113.695     0.200
     7.921   118.699     0.200
     7.921   114.405     0.200
     8.620   124.595     0.200
     8.742   126.255     0.200
     8.743   129.729     0.200
     8.743   126.145     0.200
     8.808   125.835     0.200
    15.063   211.024     0.200
    15.420   215.825     0.200
    15.486   217.965     0.200
    15.880   222.274     0.200
    16.178   225.935     0.200
     1.420    24.251     0.200
     1.630    29.812     0.200
     1.741    28.631     0.200
     1.824    32.341     0.200
     1.900    30.111     0.200
     1.972    30.801     0.200
     1.969    32.151     0.200
     1.969    31.931     0.200
     2.590    40.481     0.200
     3.189    49.541     0.200
     3.504    53.801     0.200
     3.556    53.361     0.200
     3.595    56.621     0.200
     8.011   117.340     0.200
     8.810   128.421     0.200
     9.360   140.371     0.200
    13.343   193.625     0.200
    18.585   260.888     0.200
     1.107    19.839     0.200
     1.278    23.089     0.200
     1.550    27.108     0.200
     1.550    26.909     0.200
     4.190    66.409     0.200
     0.975    16.836     0.200
     1.312    22.645     0.200
     3.349    52.496     0.200
     3.399    54.793     0.200
     3.805    59.926     0.200
     1.196    22.416     0.200
     1.753    29.395     0.200
     1.752    30.225     0.200
     1.908    31.395     0.200
     1.908    31.904     0.200
     2.663    43.455     0.200
     3.325    49.615     0.200
     3.408    53.756     0.200
     3.619    58.324     0.200
     3.752    58.475     0.200
     4.980    74.455     0.200
     1.206    22.324     0.200
     1.762    29.875     0.200
     1.771    30.516     0.200
     1.934    33.035     0.200
     1.934    32.484     0.200
     1.884    33.395     0.200
     1.958    35.223     0.200
     2.185    35.422     0.200
     2.612    41.445     0.200
     2.651    42.242     0.200
     2.642    42.062     0.200
     2.642    43.355     0.200
     3.051    48.125     0.200
     3.072    48.215     0.200
     3.136    48.793     0.200
     3.094    48.344     0.200
     3.336    51.953     0.200
     3.336    52.742     0.200
     3.293    51.555     0.200
     3.293    53.934     0.200
     3.421    55.574     0.200
     3.336    52.922     0.200
     3.585    54.934     0.200
     3.659    56.043     0.200
     3.588    56.402     0.200
     3.716    56.613     0.200
     3.803    57.992     0.200
     3.728    59.145     0.200
     3.823    58.453     0.200
     3.881    58.793     0.200
     3.969    60.113     0.200
     3.989    60.945     0.200
     4.178    66.586     0.200
     4.182    63.672     0.200
     4.170    63.422     0.200
     4.303    65.105     0.200
     4.310    64.953     0.200
     4.618    69.383     0.200
     4.671    70.742     0.200
     4.609    69.035     0.200
     4.698    70.895     0.200
     4.664    70.113     0.200
     4.717    71.355     0.200
     4.939    73.914     0.200
     4.963    75.043     0.200
     4.950    77.125     0.200
     5.090    76.402     0.200
     7.305   109.812     0.200
     7.756   115.336     0.200
     7.756   116.234     0.200
     7.752   117.754     0.200
     8.265   124.785     0.200
     9.096   136.770     0.200
    10.647   158.043     0.200
    13.022   189.242     0.200
    13.397   195.055     0.200
    15.029   209.773     0.200
    15.023   211.402     0.200
    15.033   211.203     0.200
    15.058   211.266     0.200
    15.115   212.582     0.200
    15.161   212.453     0.200
    15.212   214.164     0.200
    15.310   214.734     0.200
    15.348   215.793     0.200
    15.298   214.922     0.200
    15.306   215.254     0.200
    15.405   216.613     0.200
    15.433   216.555     0.200
    15.438   217.164     0.200
    15.471   217.223     0.200
    15.498   217.605     0.200
    15.673   219.582     0.200
    15.656   220.723     0.200
    15.753   221.164     0.200
    15.913   223.402     0.200
    16.544   230.953     0.200
    16.467   229.723     0.200
    16.637   232.523     0.200
    16.712   232.863     0.200
    16.844   234.863     0.200
    16.862   234.672     0.200
    17.071   237.145     0.200
    17.362   241.633     0.200
    17.436   242.332     0.200
    17.505   243.145     0.200
    17.550   244.105     0.200
    17.612   245.266     0.200
    17.735   245.883     0.200
    17.822   248.113     0.200
    18.083   249.793     0.200
    18.105   250.535     0.200
    19.189   268.516     0.200
    20.161   278.355     0.200
     1.741    28.820     0.200
     1.896    30.391     0.200
     1.896    31.371     0.200
     3.329    51.871     0.200
     4.991    75.250     0.200
     0.884    16.000     0.200
     1.023    19.531     0.200
     1.318    22.703     0.200
     1.371    23.289     0.200
     1.608    27.258     0.200
     1.860    31.492     0.200
     1.860    31.148     0.200
     1.897    30.711     0.200
     1.970    33.070     0.200
     1.055    18.578     0.200
     1.478    26.348     0.200
     1.515    27.268     0.200
     1.613    29.568     0.200
     2.648    40.479     0.200
     2.727    44.268     0.200
     3.291    48.449     0.200
     7.730   113.697     0.200
     8.398   126.203     0.200
     9.212   132.979     0.200
     1.537    23.918     0.200
     2.960    43.627     0.200
     3.266    50.607     0.200
     4.022    61.408     0.200
     2.244    34.516     0.200
     3.271    49.234     0.200
     3.078    47.773     0.200
     1.209    22.148     0.200
     1.273    22.492     0.200
     1.428    24.852     0.200
     1.739    28.609     0.200
     1.740    29.141     0.200
     1.740    28.922     0.200
     1.899    31.281     0.200
     1.897    32.992     0.200
     2.674    41.133     0.200
     3.309    51.086     0.200
     3.395    53.211     0.200
     3.362    51.789     0.200
     1.164    21.537     0.200
     1.164    21.318     0.200
     1.233    21.588     0.200
     1.290    22.809     0.200
     1.474    25.137     0.200
     1.762    30.229     0.200
     1.762    29.688     0.200
     1.773    29.078     0.200
     1.856    32.568     0.200
     1.907    31.938     0.200
     1.958    34.148     0.200
     2.659    44.008     0.200
     2.659    41.729     0.200
     3.338    52.348     0.200
     3.354    52.027     0.200
     3.335    53.277     0.200
     3.335    50.508     0.200
     3.424    55.578     0.200
     3.631    57.018     0.200
     3.751    58.457     0.200
     4.196    67.316     0.200
     7.817   114.867     0.200
     8.792   129.523     0.200
     9.124   135.459     0.200
    13.077   189.676     0.200
     1.450    24.797     0.200
     1.735    29.105     0.200
     3.300    52.746     0.200
     3.354    52.887     0.200
     3.372    52.227     0.200
     1.302    22.461     0.200
     1.388    23.797     0.200
     1.399    24.461     0.200
     1.683    28.258     0.200
     1.683    28.461     0.200
     2.106    35.781     0.200
     2.899    47.766     0.200
     2.977    48.578     0.200
     3.027    50.258     0.200
     3.180    48.891     0.200
     8.606   129.891     0.200
    10.181   150.414     0.200
    12.637   184.461     0.200
     1.184    20.695     0.200
     1.209    21.484     0.200
     1.392    24.109     0.200
     1.406    24.375     0.200
     1.436    25.188     0.200
     1.669    28.281     0.200
     2.225    35.648     0.200
     2.975    47.648     0.200
     2.971    46.836     0.200
     3.279    50.125     0.200
     1.686    28.000     0.200
     2.301    37.648     0.200
     2.995    46.461     0.200
     2.951    45.398     0.200
     2.951    47.520     0.200
     3.078    48.090     0.200
     4.015    60.988     0.200
     1.722    29.023     0.200
     3.026    47.223     0.200
     2.917    45.793     0.200
     3.249    47.812     0.200
     1.284    21.672     0.200
     1.294    22.393     0.200
     1.522    24.703     0.200
     1.802    29.422     0.200
     1.802    29.262     0.200
     1.821    28.002     0.200
     1.934    31.242     0.200
     1.934    31.021     0.200
     1.804    29.953     0.200
     1.915    32.703     0.200
     2.055    32.783     0.200
     2.222    35.053     0.200
     2.723    42.352     0.200
     2.571    42.102     0.200
     2.710    41.842     0.200
     2.626    41.521     0.200
     2.626    40.783     0.200
     2.626    41.783     0.200
     3.137    48.873     0.200
     3.016    45.092     0.200
     3.201    48.863     0.200
     3.291    51.133     0.200
     3.379    51.803     0.200
     3.379    50.842     0.200
     3.379    52.102     0.200
     3.469    55.502     0.200
     3.469    49.623     0.200
     3.638    54.822     0.200
     3.623    56.582     0.200
     3.752    57.672     0.200
     3.946    59.402     0.200
     3.925    59.602     0.200
     4.024    62.143     0.200
     4.047    61.723     0.200
     4.246    64.271     0.200
     4.246    64.922     0.200
     4.269    64.902     0.200
     4.269    64.441     0.200
     4.268    64.623     0.200
     4.387    67.303     0.200
     4.775    71.992     0.200
     4.685    70.553     0.200
     4.765    72.133     0.200
     4.983    75.703     0.200
     4.983    75.043     0.200
     5.346    81.213     0.200
     5.634    83.053     0.200
     5.701    83.643     0.200
     5.799    87.703     0.200
     6.137    90.703     0.200
     7.356   108.873     0.200
     7.356   108.502     0.200
     7.582   111.932     0.200
     7.840   115.203     0.200
     7.840   115.312     0.200
     7.840   113.447     0.200
     7.831   112.441     0.200
     8.248   118.473     0.200
     8.363   121.283     0.200
     8.363   121.572     0.200
     8.363   124.803     0.200
     8.776   128.803     0.200
     8.776   128.303     0.200
     8.776   128.502     0.200
     8.776   128.295     0.200
     8.877   128.742     0.200
     8.916   127.842     0.200
     9.093   131.912     0.200
     9.165   130.203     0.200
     9.177   134.902     0.200
     9.760   140.152     0.200
     9.972   143.633     0.200
    10.149   144.822     0.200
    10.059   143.822     0.200
    10.497   151.562     0.200
    10.742   158.703     0.200
    10.742   155.312     0.200
    10.738   153.262     0.200
    10.902   155.783     0.200
    11.779   168.713     0.200
    12.308   175.271     0.200
    12.344   178.932     0.200
    12.557   178.373     0.200
    13.124   188.014     0.200
    13.498   191.982     0.200
    13.461   192.703     0.200
    13.461   191.812     0.200
    13.735   196.291     0.200
    13.814   197.703     0.200
    13.898   196.393     0.200
    14.556   206.102     0.200
    14.773   209.623     0.200
    14.694   209.533     0.200
    14.871   210.682     0.200
    14.887   211.332     0.200
    14.920   212.033     0.200
    15.045   211.803     0.200
    15.045   214.482     0.200
    15.128   215.822     0.200
    15.217   215.252     0.200
    15.312   217.203     0.200
    15.363   216.662     0.200
    15.280   217.512     0.200
    15.297   215.512     0.200
    15.316   217.932     0.200
    15.374   220.012     0.200
    15.513   219.992     0.200
    15.504   220.492     0.200
    15.504   221.602     0.200
    15.504   220.303     0.200
    15.763   222.672     0.200
    16.013   224.363     0.200
    16.135   226.572     0.200
    16.273   227.521     0.200
    16.472   232.191     0.200
    16.452   229.893     0.200
    16.530   231.582     0.200
    16.755   235.113     0.200
    16.717   233.652     0.200
    16.862   235.252     0.200
    17.608   245.492     0.200
    17.721   247.393     0.200
    17.820   248.172     0.200
    18.005   249.912     0.200
    18.069   250.582     0.200
    18.376   254.133     0.200
    20.232   277.152     0.200
     1.235    21.387     0.200
     1.288    22.357     0.200
     1.475    25.217     0.200
     1.475    24.467     0.200
     1.765    28.938     0.200
     1.765    28.627     0.200
     1.775    28.148     0.200
     1.854    31.438     0.200
     1.910    30.979     0.200
     1.910    31.328     0.200
     1.955    32.797     0.200
     2.013    32.488     0.200
     2.183    34.697     0.200
     2.661    41.818     0.200
     2.674    41.988     0.200
     2.529    41.467     0.200
     2.656    41.117     0.200
     2.656    41.717     0.200
     3.070    47.467     0.200
     3.087    46.488     0.200
     3.065    49.479     0.200
     3.154    48.537     0.200
     3.340    51.117     0.200
     3.332    50.867     0.200
     3.354    50.037     0.200
     3.354    52.197     0.200
     3.427    52.207     0.200
     3.594    55.258     0.200
     3.701    54.777     0.200
     3.720    56.838     0.200
     3.877    58.258     0.200
     3.899    59.297     0.200
     3.980    61.297     0.200
     4.041    61.729     0.200
     4.199    62.777     0.200
     4.198    64.592     0.200
     4.219    63.479     0.200
     4.232    64.287     0.200
     4.317    65.627     0.200
     4.724    69.979     0.200
     4.987    74.598     0.200
     5.017    73.928     0.200
     5.738    86.559     0.200
     5.756    85.479     0.200
     6.164    92.867     0.200
     6.426    95.908     0.200
     6.497    96.088     0.200
     6.802   101.328     0.200
     6.775   100.068     0.200
     6.906   101.797     0.200
     6.905   101.229     0.200
     6.941   101.457     0.200
     7.022   103.207     0.200
     7.344   106.898     0.200
     7.354   108.488     0.200
     7.354   109.447     0.200
     7.438   108.078     0.200
     7.587   112.098     0.200
     7.709   111.887     0.200
     7.817   114.592     0.200
     7.817   113.758     0.200
     7.817   116.648     0.200
     8.090   118.998     0.200
     8.326   123.148     0.200
     8.589   125.729     0.200
     8.629   126.447     0.200
     8.740   128.148     0.200
     8.789   129.248     0.200
     8.789   128.367     0.200
     8.789   130.248     0.200
     8.790   128.398     0.200
     8.790   128.957     0.200
     9.126   134.855     0.200
     9.355   134.117     0.200
     9.528   138.188     0.200
    10.068   146.898     0.200
    10.101   149.068     0.200
    10.692   156.197     0.200
    10.692   151.508     0.200
    10.907   158.148     0.200
    11.743   170.668     0.200
    12.051   173.008     0.200
    12.381   176.809     0.200
    13.079   188.969     0.200
    13.079   184.268     0.200
    13.448   193.287     0.200
    13.451   192.277     0.200
    13.475   192.188     0.200
    14.284   202.967     0.200
    14.567   206.488     0.200
    14.839   208.637     0.200
    15.068   214.287     0.200
    15.184   214.688     0.200
    15.313   215.488     0.200
    15.352   215.367     0.200
    15.395   216.898     0.200
    15.511   219.928     0.200
    15.511   221.447     0.200
    15.712   218.137     0.200
    15.973   222.877     0.200
    16.209   228.027     0.200
    16.705   232.688     0.200
    16.905   236.508     0.200
    16.923   236.559     0.200
    17.563   243.398     0.200
    17.667   246.197     0.200
    17.770   247.207     0.200
    18.115   251.287     0.200
    18.325   253.377     0.200
    19.251   266.768     0.200
    20.218   277.088     0.200
     1.307    21.965     0.200
     1.327    23.105     0.200
     1.548    25.645     0.200
     1.792    28.895     0.200
     1.822    28.152     0.200
     1.915    31.023     0.200
     1.915    31.145     0.200
     2.643    43.383     0.200
     3.378    53.285     0.200
     3.298    51.285     0.200
     3.465    50.355     0.200
     3.413    52.473     0.200
     4.250    67.758     0.200
     7.875   115.008     0.200
     8.802   127.723     0.200
     9.186   134.832     0.200
    10.761   155.590     0.200
    13.151   189.555     0.200
     1.176    21.602     0.200
     1.176    22.031     0.200
     1.746    30.160     0.200
     1.746    31.113     0.200
     1.757    30.703     0.200
     1.893    32.391     0.200
     1.893    32.840     0.200
     1.871    32.523     0.200
     1.974    34.082     0.200
     2.674    43.613     0.200
     3.356    52.453     0.200
     3.642    58.543     0.200
     3.766    58.531     0.200
     5.003    76.453     0.200
     0.942    17.766     0.200
     1.145    19.684     0.200
     1.756    29.934     0.200
     1.756    30.086     0.200
     1.776    29.184     0.200
     1.845    31.824     0.200
     1.892    31.895     0.200
     1.892    31.754     0.200
     2.670    43.695     0.200
     3.337    51.145     0.200
     3.385    54.984     0.200
     3.337    52.945     0.200
     3.424    51.664     0.200
     4.203    66.301     0.200
     7.848   113.074     0.200
     8.813   125.520     0.200
     9.136   135.184     0.200
    10.709   156.805     0.200
    13.104   189.594     0.200
     2.675    41.461     0.200
     3.344    51.109     0.200
     3.329    51.398     0.200
     3.379    53.250     0.200
     1.169    20.523     0.200
     1.226    22.693     0.200
     1.262    22.373     0.200
     1.730    29.633     0.200
     1.737    29.383     0.200
     1.737    29.733     0.200
     1.902    32.573     0.200
     1.902    32.003     0.200
     4.148    65.523     0.200
     7.769   113.493     0.200
     8.785   128.325     0.200
     9.070   134.195     0.200
    10.628   156.443     0.200
    13.013   188.338     0.200
     0.940    17.250     0.200
     1.267    22.740     0.200
     1.236    21.910     0.200
     1.401    24.920     0.200
     1.718    28.711     0.200
     1.726    30.061     0.200
     1.726    29.680     0.200
     1.892    32.641     0.200
     1.892    31.510     0.200
     1.922    34.590     0.200
     2.003    34.240     0.200
     3.291    51.180     0.200
     3.305    53.141     0.200
     3.381    54.670     0.200
     7.769   114.830     0.200
     8.793   128.086     0.200
     1.055    17.895     0.200
     1.475    25.586     0.200
     1.475    25.996     0.200
     1.516    26.625     0.200
     1.615    26.035     0.200
     2.648    42.375     0.200
     2.656    43.346     0.200
     3.295    51.975     0.200
     1.193    21.854     0.200
     1.406    24.514     0.200
     1.452    25.604     0.200
     1.391    25.402     0.200
     1.530    26.803     0.200
     1.530    27.252     0.200
     1.685    29.123     0.200
     1.685    28.973     0.200
     2.307    38.723     0.200
     3.071    48.752     0.200
     0.886    16.742     0.200
     1.144    19.914     0.200
     1.182    21.902     0.200
     1.182    21.512     0.200
     1.154    21.324     0.200
     1.448    25.691     0.200
     1.465    27.223     0.200
     1.622    29.473     0.200
     1.732    30.832     0.200
     1.732    30.574     0.200
     2.576    42.234     0.200
     3.382    50.762     0.200
     4.286    65.902     0.200
     9.220   137.578     0.200
     1.220    20.924     0.200
     1.342    23.893     0.200
     1.352    23.934     0.200
     1.360    24.312     0.200
     1.385    23.482     0.200
     1.397    24.473     0.200
     1.386    24.084     0.200
     1.593    27.562     0.200
     1.593    26.893     0.200
     1.594    27.434     0.200
     1.626    26.623     0.200
     1.748    27.902     0.200
     1.748    27.643     0.200
     1.995    32.963     0.200
     2.117    34.543     0.200
     2.117    33.812     0.200
     2.173    34.494     0.200
     2.246    36.594     0.200
     2.285    36.414     0.200
     2.336    37.723     0.200
     2.474    39.033     0.200
     2.646    41.383     0.200
     2.685    42.723     0.200
     2.728    42.893     0.200
     2.749    43.184     0.200
     2.749    44.383     0.200
     2.847    44.973     0.200
     2.938    44.834     0.200
     3.148    48.523     0.200
     3.264    50.254     0.200
     3.509    53.623     0.200
     3.805    58.574     0.200
     3.806    58.562     0.200
     3.853    61.232     0.200
     4.531    70.283     0.200
     4.718    72.924     0.200
     5.602    82.004     0.200
     6.929   100.684     0.200
     7.543   110.244     0.200
     7.629   111.754     0.200
     9.251   134.473     0.200
     9.279   134.074     0.200
     9.484   138.488     0.200
     1.342    24.377     0.200
     1.337    24.267     0.200
     1.337    25.157     0.200
     1.378    24.697     0.200
     1.419    24.897     0.200
     1.506    26.147     0.200
     1.506    25.637     0.200
     1.481    26.907     0.200
     2.428    41.577     0.200
     2.963    47.517     0.200
     3.060    48.737     0.200
     3.178    51.277     0.200
     1.082    19.332     0.200
     1.209    22.680     0.200
     1.209    20.770     0.200
     3.135    46.352     0.200
     3.900    63.770     0.200
     5.259    77.500     0.200
     1.196    20.799     0.200
     1.545    26.248     0.200
     1.545    26.918     0.200
     1.526    28.098     0.200
     1.655    27.889     0.200
     2.783    42.959     0.200
     3.151    48.449     0.200
     3.290    51.588     0.200
     0.972    16.465     0.200
     1.195    21.516     0.200
     1.195    22.375     0.200
     1.312    22.773     0.200
     1.358    22.875     0.200
     1.356    23.586     0.200
     1.416    24.074     0.200
     1.472    24.914     0.200
     1.567    26.285     0.200
     2.084    33.906     0.200
     2.122    33.684     0.200
     2.251    36.273     0.200
     2.223    35.465     0.200
     2.306    36.973     0.200
     2.440    38.664     0.200
     2.464    39.383     0.200
     2.484    39.312     0.200
     2.612    41.035     0.200
     2.678    41.215     0.200
     2.702    42.312     0.200
     2.816    43.766     0.200
     2.904    44.234     0.200
     5.581    83.574     0.200
     5.626    84.836     0.200
     5.894    88.824     0.200
     7.599   110.711     0.200
     9.228   134.809     0.200
     9.515   137.258     0.200
    11.864   173.285     0.200
    12.175   177.992     0.200
    15.370   215.434     0.200
    15.395   216.445     0.200
    16.856   233.695     0.200
    17.049   237.023     0.200
     0.945    15.719     0.200
     1.283    22.260     0.200
     1.331    22.219     0.200
     1.337    24.500     0.200
     1.423    23.830     0.200
     1.540    25.570     0.200
     2.061    32.949     0.200
     2.116    33.119     0.200
     2.198    34.990     0.200
     2.225    35.160     0.200
     2.277    36.340     0.200
     2.412    38.311     0.200
     2.585    41.469     0.200
     2.662    41.949     0.200
     2.674    41.289     0.200
     2.687    41.539     0.200
     2.787    44.119     0.200
     2.876    45.189     0.200
     3.186    48.799     0.200
     3.176    48.180     0.200
     3.295    51.070     0.200
     3.569    54.869     0.200
     3.777    57.311     0.200
     3.797    58.520     0.200
     3.854    57.930     0.200
     4.245    63.129     0.200
     4.503    69.141     0.200
     4.897    73.709     0.200
     5.176    78.400     0.200
     5.611    84.539     0.200
     5.917    88.920     0.200
     1.014    17.832     0.200
     1.084    19.355     0.200
     1.250    22.695     0.200
     1.250    22.043     0.200
     1.331    24.105     0.200
     1.370    23.574     0.200
     1.409    23.883     0.200
     1.494    26.164     0.200
     1.543    26.703     0.200
     1.578    27.262     0.200
     1.832    28.734     0.200
     2.188    34.734     0.200
     2.297    37.004     0.200
     2.325    37.285     0.200
     2.712    43.055     0.200
     2.840    45.402     0.200
     3.114    48.023     0.200
     3.114    51.262     0.200
     1.036    19.746     0.200
     1.067    20.227     0.200
     1.224    22.715     0.200
     1.344    23.527     0.200
     1.464    25.496     0.200
     1.515    26.156     0.200
     2.155    32.234     0.200
     2.203    36.227     0.200
     2.263    36.355     0.200
     2.687    42.758     0.200
     3.137    46.926     0.200
     0.802    14.094     0.200
     0.987    16.875     0.200
     1.183    20.383     0.200
     1.197    20.906     0.200
     1.197    20.195     0.200
     1.312    22.562     0.200
     1.357    23.312     0.200
     1.358    22.672     0.200
     1.349    22.461     0.200
     1.357    23.156     0.200
     1.414    23.742     0.200
     1.472    24.594     0.200
     1.527    25.156     0.200
     1.567    25.922     0.200
     1.593    25.156     0.200
     1.791    27.297     0.200
     1.840    28.883     0.200
     2.086    32.664     0.200
     2.141    33.672     0.200
     2.150    33.836     0.200
     2.223    35.391     0.200
     2.306    36.781     0.200
     2.441    38.484     0.200
     2.466    39.422     0.200
     2.484    38.602     0.200
     2.670    41.922     0.200
     2.701    42.094     0.200
     2.717    41.305     0.200
     2.716    41.031     0.200
     3.166    48.367     0.200
     3.166    49.086     0.200
     3.166    49.367     0.200
     3.240    49.531     0.200
     3.590    55.062     0.200
     3.805    58.227     0.200
     3.857    57.836     0.200
     3.886    57.836     0.200
     3.886    58.273     0.200
     4.311    63.812     0.200
     4.380    67.195     0.200
     4.370    65.977     0.200
     4.519    69.117     0.200
     4.590    68.297     0.200
     4.713    72.266     0.200
     4.766    70.391     0.200
     4.735    71.273     0.200
     4.785    71.906     0.200
     4.918    74.141     0.200
     5.046    75.805     0.200
     5.444    79.938     0.200
     5.630    84.336     0.200
     5.700    84.664     0.200
     5.940    88.555     0.200
     6.151    91.891     0.200
     6.704    98.031     0.200
     6.784    97.891     0.200
     7.041   102.844     0.200
     7.250   105.406     0.200
     7.476   111.336     0.200
     7.476   110.508     0.200
     7.471   109.852     0.200
     7.471   108.953     0.200
     7.471   109.516     0.200
     7.599   109.812     0.200
     7.848   114.688     0.200
     8.096   118.312     0.200
     8.439   123.086     0.200
     8.747   128.922     0.200
     8.888   133.211     0.200
     9.104   132.766     0.200
     9.227   134.609     0.200
     9.247   133.703     0.200
     9.306   135.688     0.200
     9.512   137.312     0.200
     9.513   137.586     0.200
     9.513   137.344     0.200
     9.939   144.242     0.200
    10.085   146.688     0.200
    10.094   145.062     0.200
    10.673   154.445     0.200
    11.373   159.938     0.200
    11.795   169.641     0.200
    11.863   167.586     0.200
    12.018   174.102     0.200
    12.175   174.656     0.200
    12.260   173.656     0.200
    12.559   177.688     0.200
    12.562   178.164     0.200
    13.038   183.477     0.200
    13.153   186.938     0.200
    13.179   189.805     0.200
    13.717   197.156     0.200
    13.892   194.773     0.200
    14.199   199.562     0.200
    14.215   199.102     0.200
    14.223   201.258     0.200
    14.345   203.055     0.200
    14.414   202.602     0.200
    14.419   204.758     0.200
    14.489   202.242     0.200
    14.519   207.781     0.200
    14.589   205.695     0.200
    14.722   207.172     0.200
    14.964   210.008     0.200
    14.986   210.961     0.200
    15.001   210.906     0.200
    15.722   222.492     0.200
    16.037   226.055     0.200
    16.037   224.305     0.200
    16.288   228.961     0.200
    16.695   234.188     0.200
    17.229   240.266     0.200
    18.058   249.773     0.200
    18.319   252.836     0.200
    18.577   259.414     0.200
    19.021   262.664     0.200
    19.865   271.492     0.200
    20.071   274.664     0.200
     0.958    16.305     0.200
     1.053    20.953     0.200
     1.321    24.594     0.200
     1.331    22.836     0.200
     1.356    24.453     0.200
     1.401    25.633     0.200
     1.447    24.656     0.200
     1.500    25.258     0.200
     1.539    25.984     0.200
     2.078    33.195     0.200
     2.103    35.336     0.200
     2.194    36.062     0.200
     2.241    35.586     0.200
     2.281    36.750     0.200
     2.423    39.453     0.200
     2.461    40.945     0.200
     2.599    40.773     0.200
     2.648    41.500     0.200
     2.674    42.555     0.200
     2.792    44.469     0.200
     2.889    46.617     0.200
     3.125    49.219     0.200
     3.155    49.383     0.200
     3.211    50.609     0.200
     3.308    51.914     0.200
     3.561    55.555     0.200
     3.780    58.164     0.200
     3.857    58.734     0.200
     4.253    65.164     0.200
     4.353    67.117     0.200
     4.491    70.109     0.200
     4.686    71.148     0.200
     4.888    75.016     0.200
     4.980    75.508     0.200
     5.554    81.008     0.200
     5.598    84.133     0.200
     5.601    84.664     0.200
     5.690    84.734     0.200
     5.865    88.367     0.200
     5.910    89.219     0.200
     6.042    91.273     0.200
     6.121    92.305     0.200
     6.122    91.984     0.200
     6.689   100.156     0.200
     6.978   103.953     0.200
     7.217   106.117     0.200
     8.172   122.133     0.200
     1.232    22.711     0.200
     1.278    22.914     0.200
     1.292    23.508     0.200
     1.319    24.188     0.200
     1.392    24.609     0.200
     1.446    25.297     0.200
     1.419    24.852     0.200
     1.487    26.180     0.200
     2.032    33.711     0.200
     2.146    35.031     0.200
     2.190    35.688     0.200
     2.226    36.766     0.200
     2.368    38.320     0.200
     2.622    42.578     0.200
     2.621    44.156     0.200
     2.641    43.617     0.200
     2.737    44.438     0.200
     2.835    46.414     0.200
     3.174    50.117     0.200
     3.254    52.766     0.200
     3.519    54.984     0.200
     3.765    58.469     0.200
     4.459    67.695     0.200
     4.663    70.648     0.200
     0.923    16.336     0.200
     1.050    18.906     0.200
     1.050    19.812     0.200
     1.250    22.586     0.200
     1.296    22.875     0.200
     1.301    23.336     0.200
     1.331    24.828     0.200
     1.331    24.602     0.200
     1.411    24.828     0.200
     1.464    25.305     0.200
     1.412    24.773     0.200
     1.505    26.227     0.200
     2.048    33.469     0.200
     2.162    35.516     0.200
     2.207    34.922     0.200
     2.244    36.625     0.200
     2.386    39.266     0.200
     2.565    40.758     0.200
     2.639    42.188     0.200
     2.629    41.977     0.200
     2.660    43.133     0.200
     3.167    49.469     0.200
     3.167    48.992     0.200
     4.469    67.734     0.200
     4.670    70.797     0.200
     4.758    70.781     0.200
     0.951    16.453     0.200
     1.047    19.273     0.200
     1.348    23.364     0.200
     1.408    24.643     0.200
     1.535    25.624     0.200
     2.070    33.773     0.200
     2.096    34.683     0.200
     2.191    34.943     0.200
     2.233    35.813     0.200
     2.276    36.703     0.200
     2.416    38.133     0.200
     2.455    38.813     0.200
     2.592    40.183     0.200
     2.670    42.203     0.200
     2.690    42.773     0.200
     2.649    42.763     0.200
     2.786    43.703     0.200
     3.161    49.583     0.200
     3.560    54.493     0.200
     4.491    69.374     0.200
     4.688    69.243     0.200
     4.887    72.953     0.200
     4.977    74.693     0.200
     5.165    77.793     0.200
     5.594    81.393     0.200
     5.601    83.173     0.200
     5.697    83.833     0.200
     5.909    87.733     0.200
     1.197    20.936     0.200
     1.567    26.865     0.200
     2.001    33.725     0.200
     2.788    45.665     0.200
     2.869    45.885     0.200
     3.142    49.735     0.200
     3.263    49.005     0.200
     5.256    77.735     0.200
     1.102    19.318     0.200
     1.222    20.918     0.200
     1.327    24.178     0.200
     1.349    22.828     0.200
     1.457    24.548     0.200
     1.614    26.878     0.200
     1.676    27.798     0.200
     1.924    33.958     0.200
     2.275    37.628     0.200
     2.335    38.418     0.200
     2.770    44.308     0.200
     3.083    47.058     0.200
     3.083    50.128     0.200
     0.554    10.133     0.200
     1.068    19.148     0.200
     1.249    21.469     0.200
     1.417    23.250     0.200
     1.433    23.711     0.200
     1.635    27.523     0.200
     1.603    25.344     0.200
     2.003    32.312     0.200
     2.053    33.305     0.200
     2.093    33.703     0.200
     2.172    33.461     0.200
     2.322    36.273     0.200
     2.353    37.750     0.200
     2.508    40.805     0.200
     2.579    39.828     0.200
     2.567    39.594     0.200
     2.593    42.062     0.200
     2.655    42.016     0.200
     2.684    42.281     0.200
     3.080    46.062     0.200
     3.173    46.219     0.200
     3.468    52.883     0.200
     3.689    55.203     0.200
     3.733    55.766     0.200
     4.142    62.570     0.200
     4.414    65.648     0.200
     4.625    67.312     0.200
     4.800    71.625     0.200
     5.085    75.742     0.200
     5.814    85.922     0.200
     1.270    22.172     0.200
     1.251    22.703     0.200
     1.443    25.242     0.200
     1.529    25.621     0.200
     1.579    26.152     0.200
     1.520    25.422     0.200
     1.788    28.941     0.200
     1.903    31.934     0.200
     2.327    37.914     0.200
     2.417    38.543     0.200
     2.439    39.711     0.200
     2.525    40.664     0.200
     2.785    43.254     0.200
     2.848    46.484     0.200
     2.919    46.594     0.200
     2.922    46.742     0.200
     2.989    48.383     0.200
     3.089    49.594     0.200
     3.175    52.074     0.200
     3.647    57.352     0.200
     3.936    60.762     0.200
     4.051    63.262     0.200
     4.316    68.062     0.200
     4.471    69.254     0.200
     4.620    71.984     0.200
     4.700    72.582     0.200
     4.824    73.383     0.200
     5.377    81.871     0.200
     1.256    21.836     0.200
     1.444    24.215     0.200
     1.519    25.105     0.200
     1.520    25.805     0.200
     1.772    28.824     0.200
     1.887    30.574     0.200
     2.214    35.285     0.200
     2.277    35.293     0.200
     2.311    36.656     0.200
     2.402    38.023     0.200
     2.425    37.055     0.200
     2.621    40.863     0.200
     2.682    40.164     0.200
     2.771    43.535     0.200
     2.903    45.035     0.200
     3.074    47.113     0.200
     3.178    48.227     0.200
     3.178    48.566     0.200
     3.336    50.805     0.200
     3.493    53.215     0.200
     3.644    55.504     0.200
     3.681    56.895     0.200
     3.784    56.785     0.200
     3.829    58.836     0.200
     3.930    60.246     0.200
     4.324    65.016     0.200
     4.455    67.816     0.200
     4.624    69.605     0.200
     4.824    73.215     0.200
     4.879    72.914     0.200
     4.910    73.125     0.200
     5.104    76.805     0.200
     5.550    81.785     0.200
     1.172    21.688     0.200
     1.280    21.938     0.200
     1.382    25.398     0.200
     1.439    24.578     0.200
     1.535    25.578     0.200
     1.799    29.258     0.200
     1.916    30.188     0.200
     2.240    35.816     0.200
     2.304    37.957     0.200
     2.449    38.516     0.200
     2.430    38.695     0.200
     2.537    41.406     0.200
     2.650    41.719     0.200
     2.711    42.469     0.200
     2.798    44.445     0.200
     2.933    45.586     0.200
     2.932    45.758     0.200
     3.102    47.836     0.200
     3.169    49.098     0.200
     3.365    52.375     0.200
     3.709    56.695     0.200
     3.938    59.719     0.200
     4.064    61.938     0.200
     4.820    72.887     0.200
     1.185    19.438     0.200
     1.299    21.859     0.200
     1.260    22.977     0.200
     1.450    24.238     0.200
     1.390    23.379     0.200
     1.554    25.699     0.200
     1.513    25.918     0.200
     1.482    26.359     0.200
     1.817    29.559     0.200
     1.928    30.570     0.200
     2.248    36.598     0.200
     2.312    36.449     0.200
     2.354    36.887     0.200
     2.468    38.227     0.200
     2.440    38.207     0.200
     2.555    39.660     0.200
     2.663    41.328     0.200
     2.727    41.469     0.200
     2.871    44.180     0.200
     2.809    43.137     0.200
     2.952    45.047     0.200
     2.946    45.117     0.200
     2.946    44.242     0.200
     3.017    45.867     0.200
     3.060    46.777     0.200
     3.177    48.898     0.200
     3.114    48.438     0.200
     3.380    51.270     0.200
     3.464    51.449     0.200
     3.533    54.090     0.200
     3.660    55.500     0.200
     3.824    57.488     0.200
     7.847   111.898     0.200
    12.075   170.297     0.200
    14.113   197.047     0.200
    14.346   200.070     0.200
    14.379   201.688     0.200
     1.170    19.258     0.200
     1.345    24.918     0.200
     1.413    23.996     0.200
     1.875    31.336     0.200
     2.236    35.969     0.200
     2.281    35.559     0.200
     2.341    36.680     0.200
     2.409    38.938     0.200
     2.600    41.727     0.200
     2.771    44.098     0.200
     2.836    43.629     0.200
     2.875    45.059     0.200
     2.968    46.680     0.200
     3.064    49.699     0.200
     3.086    49.617     0.200
     3.086    49.059     0.200
     3.358    52.129     0.200
     3.535    53.809     0.200
     3.688    56.277     0.200
     3.856    58.680     0.200
     4.255    64.707     0.200
     4.420    67.379     0.200
     4.535    66.867     0.200
     4.583    69.828     0.200
     4.721    71.289     0.200
     4.748    70.438     0.200
     5.004    75.887     0.200
     5.261    80.109     0.200
     5.713    86.348     0.200
     6.001    90.188     0.200
     6.014    89.848     0.200
     1.095    19.203     0.200
     1.095    19.354     0.200
     1.165    20.395     0.200
     1.301    22.033     0.200
     1.416    24.635     0.200
     1.436    24.373     0.200
     1.427    24.074     0.200
     1.473    24.975     0.200
     1.581    26.154     0.200
     1.587    26.523     0.200
     1.681    27.895     0.200
     1.816    29.283     0.200
     1.966    30.863     0.200
     2.182    35.965     0.200
     2.164    35.824     0.200
     2.231    38.744     0.200
     2.224    36.074     0.200
     2.333    37.023     0.200
     2.421    39.055     0.200
     2.546    42.145     0.200
     2.597    41.523     0.200
     2.707    43.135     0.200
     2.816    43.854     0.200
     2.825    45.404     0.200
     2.885    44.914     0.200
     2.929    46.795     0.200
     3.160    48.564     0.200
     3.160    49.004     0.200
     3.256    53.484     0.200
     3.351    51.783     0.200
     3.594    54.574     0.200
     3.694    57.504     0.200
     3.788    57.004     0.200
     3.788    61.873     0.200
     3.865    59.443     0.200
     3.881    60.135     0.200
     3.962    63.514     0.200
     4.332    65.863     0.200
     4.388    67.344     0.200
     4.456    68.523     0.200
     4.609    69.873     0.200
     4.608    71.645     0.200
     4.789    72.324     0.200
     4.786    73.084     0.200
     4.752    70.613     0.200
     4.827    73.725     0.200
     5.017    76.664     0.200
     5.121    77.684     0.200
     5.284    80.725     0.200
     5.343    80.703     0.200
     5.460    83.844     0.200
     5.574    84.273     0.200
     5.538    83.523     0.200
     5.686    84.215     0.200
     5.657    85.453     0.200
     5.728    86.814     0.200
     6.011    90.715     0.200
     6.005    90.184     0.200
     6.045    90.635     0.200
     6.651    96.693     0.200
     6.712    99.324     0.200
     6.846   103.693     0.200
     7.152   102.244     0.200
     7.492   110.229     0.200
     7.537   111.334     0.200
     8.053   119.354     0.200
     8.289   122.395     0.200
     8.637   127.363     0.200
     9.065   133.895     0.200
     9.260   135.033     0.200
     9.338   137.934     0.200
     9.455   135.453     0.200
     9.456   137.908     0.200
     9.456   136.994     0.200
     9.553   137.975     0.200
    10.011   144.533     0.200
    11.955   176.016     0.200
     0.896    15.680     0.200
     1.059    18.328     0.200
     1.145    20.617     0.200
     1.209    21.617     0.200
     1.292    22.039     0.200
     1.408    25.117     0.200
     1.418    24.000     0.200
     1.453    24.922     0.200
     1.409    24.328     0.200
     1.413    24.945     0.200
     1.567    26.672     0.200
     1.623    27.320     0.200
     1.619    26.945     0.200
     1.662    28.070     0.200
     1.662    27.945     0.200
     1.601    25.789     0.200
     1.802    28.859     0.200
     1.802    29.086     0.200
     1.925    30.977     0.200
     2.156    35.445     0.200
     2.163    35.648     0.200
     2.214    32.898     0.200
     3.154    48.328     0.200
     1.228    21.781     0.200
     1.382    23.652     0.200
     1.409    23.434     0.200
     2.312    38.820     0.200
     1.059    18.465     0.200
     1.148    20.742     0.200
     1.291    22.062     0.200
     1.410    24.633     0.200
     1.421    24.195     0.200
     1.455    25.023     0.200
     1.570    26.684     0.200
     1.625    27.395     0.200
     1.563    26.895     0.200
     1.617    27.305     0.200
     1.664    28.113     0.200
     1.802    28.672     0.200
     1.925    31.125     0.200
     2.165    34.992     0.200
     2.155    35.195     0.200
     2.216    36.602     0.200
     2.214    35.914     0.200
     2.316    37.133     0.200
     2.331    37.305     0.200
     2.532    39.793     0.200
     2.581    40.934     0.200
     2.695    41.965     0.200
     2.799    43.703     0.200
     2.810    47.539     0.200
     2.913    45.633     0.200
     2.991    47.645     0.200
     3.158    48.773     0.200
     3.158    48.633     0.200
     3.577    54.945     0.200
     3.586    55.324     0.200
     3.678    57.152     0.200
     3.866    60.684     0.200
     3.853    59.504     0.200
     3.801    58.652     0.200
     3.801    59.785     0.200
     3.981    60.293     0.200
     4.164    63.652     0.200
     4.229    63.613     0.200
     4.443    68.383     0.200
     4.593    71.254     0.200
     4.493    71.602     0.200
     4.607    68.723     0.200
     4.773    72.805     0.200
     4.783    72.523     0.200
     4.818    73.555     0.200
     5.001    77.023     0.200
     5.104    78.203     0.200
     5.268    80.992     0.200
     5.333    81.262     0.200
     5.641    85.805     0.200
     5.670    84.422     0.200
     5.580    85.824     0.200
     5.685    85.062     0.200
     5.988    89.363     0.200
     6.029    90.273     0.200
     6.635    98.195     0.200
     6.708    99.793     0.200
     7.137   106.352     0.200
     7.486   109.316     0.200
     7.525   112.023     0.200
     7.697   116.188     0.200
     8.056   117.285     0.200
     8.274   121.023     0.200
     8.834   131.242     0.200
     9.321   136.246     0.200
     9.264   134.504     0.200
     9.461   137.062     0.200
     9.462   136.785     0.200
     9.462   138.715     0.200
    11.939   173.602     0.200
     7.484   108.945     0.200
     1.266    21.562     0.200
     1.896    31.742     0.200
     2.290    36.212     0.200
     2.821    44.792     0.200
     2.917    47.162     0.200
     1.015    18.633     0.200
     1.541    26.834     0.200
     1.541    26.664     0.200
     2.171    34.793     0.200
     2.232    36.174     0.200
     1.024    18.625     0.200
     1.199    21.695     0.200
     1.465    24.746     0.200
     1.547    26.816     0.200
     2.187    38.176     0.200
     2.217    39.387     0.200
     2.367    40.797     0.200
     2.786    44.156     0.200
     2.857    49.645     0.200
     2.918    48.316     0.200
     2.964    50.023     0.200
     3.034    51.844     0.200
     3.161    47.594     0.200
     3.385    53.555     0.200
     3.909    61.184     0.200
     4.636    70.836     0.200
     5.313    79.965     0.200
     1.088    20.191     0.200
     1.167    20.242     0.200
     1.243    22.902     0.200
     1.314    24.113     0.200
     1.433    23.832     0.200
     1.568    26.543     0.200
     1.568    26.691     0.200
     1.686    27.781     0.200
     1.827    28.941     0.200
     2.187    34.922     0.200
     2.178    34.504     0.200
     2.241    35.793     0.200
     2.237    35.391     0.200
     2.335    37.113     0.200
     2.355    36.922     0.200
     2.428    38.152     0.200
     2.557    39.312     0.200
     2.605    41.383     0.200
     2.755    43.414     0.200
     2.719    42.504     0.200
     2.820    43.754     0.200
     2.886    44.781     0.200
     2.835    43.031     0.200
     2.937    46.121     0.200
     3.147    47.352     0.200
     3.147    48.441     0.200
     3.016    46.004     0.200
     3.265    49.922     0.200
     3.353    51.402     0.200
     3.584    54.254     0.200
     3.601    54.543     0.200
     3.694    56.730     0.200
     3.753    57.262     0.200
     3.857    59.203     0.200
     3.878    60.062     0.200
     3.972    59.391     0.200
     4.004    59.621     0.200
     4.319    66.391     0.200
     4.254    67.262     0.200
     4.451    68.363     0.200
     4.395    66.793     0.200
     4.389    65.781     0.200
     4.596    69.363     0.200
     4.604    71.102     0.200
     4.777    72.191     0.200
     4.780    72.633     0.200
     4.817    73.082     0.200
     4.839    75.332     0.200
     5.016    76.730     0.200
     5.124    76.730     0.200
     5.142    78.723     0.200
     5.163    80.043     0.200
     5.176    76.621     0.200
     5.281    80.871     0.200
     5.335    80.980     0.200
     5.673    84.262     0.200
     5.550    81.391     0.200
     5.656    85.324     0.200
     5.727    86.980     0.200
     5.701    85.531     0.200
     6.011    88.801     0.200
     6.008    89.023     0.200
     6.046    90.133     0.200
     6.324    94.934     0.200
     6.546    96.504     0.200
     6.700    98.934     0.200
     6.659    97.992     0.200
     6.844   102.473     0.200
     7.114   105.141     0.200
     7.148   105.352     0.200
     7.529   111.613     0.200
     7.721   117.781     0.200
     7.919   119.441     0.200
     8.039   118.871     0.200
     8.192   120.941     0.200
     8.208   119.621     0.200
     8.249   120.871     0.200
     8.285   119.934     0.200
     8.416   123.574     0.200
     8.845   131.074     0.200
     9.340   139.227     0.200
     9.442   134.977     0.200
    11.952   174.609     0.200
    12.201   174.242     0.200
     1.032    18.359     0.200
     1.193    20.281     0.200
     1.193    20.711     0.200
     1.457    24.031     0.200
     1.556    26.531     0.200
     1.712    27.914     0.200
     1.847    31.602     0.200
     2.213    36.680     0.200
     2.191    34.953     0.200
     2.263    39.820     0.200
     2.251    35.953     0.200
     2.362    36.953     0.200
     2.371    37.953     0.200
     2.452    39.016     0.200
     2.577    42.297     0.200
     2.629    43.383     0.200
     2.778    44.070     0.200
     2.736    44.500     0.200
     2.846    44.430     0.200
     2.856    45.359     0.200
     2.912    45.695     0.200
     2.961    46.633     0.200
     3.035    49.273     0.200
     3.153    49.602     0.200
     3.153    48.414     0.200
     3.288    53.102     0.200
     3.599    56.594     0.200
     3.720    58.141     0.200
     3.759    59.141     0.200
     3.776    59.141     0.200
     3.877    58.594     0.200
     3.901    60.461     0.200
     4.029    61.531     0.200
     4.317    66.055     0.200
     4.420    67.344     0.200
     4.473    68.742     0.200
     4.601    69.695     0.200
     4.628    71.094     0.200
     4.788    73.391     0.200
     4.802    72.359     0.200
     4.833    73.383     0.200
     4.843    75.352     0.200
     5.041    76.477     0.200
     5.150    78.461     0.200
     5.167    77.820     0.200
     5.305    80.586     0.200
     5.352    80.375     0.200
     5.677    83.992     0.200
     5.681    85.242     0.200
     5.726    87.320     0.200
     5.752    86.711     0.200
     6.036    91.211     0.200
     6.034    90.609     0.200
     6.072    90.930     0.200
     6.199    92.227     0.200
     6.868   103.945     0.200
     7.171   106.766     0.200
     7.548   111.977     0.200
     8.286   122.375     0.200
     8.289   122.906     0.200
     1.262    21.543     0.200
     1.578    27.004     0.200
     2.206    34.992     0.200
     2.265    37.344     0.200
     3.131    48.754     0.200
     1.246    21.153     0.200
     1.454    23.752     0.200
     1.479    24.963     0.200
     1.465    25.363     0.200
     1.690    28.183     0.200
     1.843    30.343     0.200
     2.229    35.323     0.200
     2.387    37.252     0.200
     2.830    44.312     0.200
     2.927    45.663     0.200
     2.927    45.873     0.200
     3.030    46.633     0.200
     3.271    52.423     0.200
     3.287    50.303     0.200
     3.310    51.183     0.200
     3.310    51.283     0.200
     3.400    52.743     0.200
     3.514    52.363     0.200
     3.575    55.533     0.200
     3.783    59.252     0.200
     3.906    59.353     0.200
     3.918    60.423     0.200
     4.120    62.693     0.200
     4.545    68.232     0.200
     4.670    69.913     0.200
     5.088    75.593     0.200
     5.334    78.633     0.200
     5.410    80.423     0.200
     5.501    82.713     0.200
     5.674    84.633     0.200
     6.187    92.603     0.200
     6.890   101.453     0.200
     6.994   103.363     0.200
     7.454   109.663     0.200
     7.780   113.653     0.200
     7.774   113.932     0.200
     7.774   114.653     0.200
     7.774   114.123     0.200
     7.774   114.482     0.200
     8.805   132.115     0.200
     8.974   130.727     0.200
    10.398   153.154     0.200
    17.956   248.603     0.200
     1.129    20.023     0.200
     1.209    21.902     0.200
     1.351    23.062     0.200
     1.577    26.652     0.200
     1.729    27.613     0.200
     2.078    32.914     0.200
     2.100    32.004     0.200
     2.136    34.035     0.200
     2.156    33.023     0.200
     2.230    34.582     0.200
     2.267    35.465     0.200
     2.317    37.203     0.200
     2.455    37.973     0.200
     2.496    39.203     0.200
     2.627    40.934     0.200
     2.711    41.695     0.200
     2.730    42.203     0.200
     2.785    43.695     0.200
     2.828    44.434     0.200
     2.919    45.203     0.200
     3.159    48.055     0.200
     3.224    49.992     0.200
     3.596    54.184     0.200
     3.802    56.875     0.200
     3.871    57.652     0.200
     3.894    57.523     0.200
     4.077    61.164     0.200
     4.286    65.164     0.200
     4.521    70.402     0.200
     4.712    72.023     0.200
     0.928    15.399     0.200
     0.834    14.559     0.200
     0.962    16.379     0.200
     1.059    17.459     0.200
     1.226    20.089     0.200
     1.311    21.559     0.200
     1.322    21.729     0.200
     1.435    23.469     0.200
     1.425    25.279     0.200
     1.476    23.939     0.200
     1.939    31.429     0.200
     1.925    30.579     0.200
     1.957    31.929     0.200
     1.978    30.869     0.200
     2.112    34.449     0.200
     2.085    33.129     0.200
     2.158    33.899     0.200
     2.127    33.319     0.200
     2.260    44.989     0.200
     2.273    36.709     0.200
     2.444    38.169     0.200
     2.568    39.809     0.200
     2.551    40.929     0.200
     2.702    42.459     0.200
     2.660    42.719     0.200
     2.736    45.269     0.200
     2.982    47.579     0.200
     3.078    47.239     0.200
     3.266    49.449     0.200
     3.291    54.059     0.200
     3.501    54.339     0.200
     3.809    58.359     0.200
     3.736    55.969     0.200
     3.933    61.349     0.200
     4.467    69.049     0.200
     4.691    71.049     0.200
     4.839    73.599     0.200
     4.887    73.619     0.200
     4.873    71.559     0.200
     5.136    77.759     0.200
     5.473    82.339     0.200
     5.488    82.639     0.200
     5.557    83.759     0.200
     5.687    85.539     0.200
     5.775    86.569     0.200
     5.829    87.619     0.200
     5.843    87.349     0.200
     6.083    91.849     0.200
     0.634    11.416     0.200
     0.802    14.006     0.200
     0.828    14.076     0.200
     0.816    14.306     0.200
     0.928    15.406     0.200
     1.159    19.416     0.200
     1.219    20.016     0.200
     1.305    21.906     0.200
     1.379    22.336     0.200
     1.429    23.286     0.200
     1.477    24.476     0.200
     1.542    24.526     0.200
     1.933    31.396     0.200
     1.952    31.496     0.200
     1.923    30.616     0.200
     1.975    31.126     0.200
     2.106    33.276     0.200
     2.082    32.916     0.200
     2.152    33.976     0.200
     2.321    37.306     0.200
     2.441    37.926     0.200
     2.562    39.646     0.200
     2.546    41.026     0.200
     2.654    41.846     0.200
     2.696    42.636     0.200
     2.977    45.416     0.200
     3.072    47.136     0.200
     3.264    49.246     0.200
     3.495    53.686     0.200
     3.468    52.206     0.200
     3.730    55.656     0.200
     3.804    57.946     0.200
     4.461    68.766     0.200
     4.686    71.046     0.200
     4.729    69.906     0.200
     4.814    72.556     0.200
     4.836    72.636     0.200
     4.833    73.646     0.200
     4.880    73.586     0.200
     5.312    80.346     0.200
     5.466    82.056     0.200
     5.481    82.576     0.200
     5.550    83.786     0.200
     5.769    86.496     0.200
     5.805    85.616     0.200
     5.836    86.976     0.200
     5.977    90.756     0.200
     6.077    92.076     0.200
     0.945    17.008     0.200
     1.047    18.199     0.200
     1.351    22.500     0.200
     1.391    25.520     0.200
     1.437    26.207     0.200
     1.510    24.848     0.200
     1.505    27.297     0.200
     1.539    27.738     0.200
     1.582    28.609     0.200
     1.662    29.648     0.200
     1.689    29.527     0.200
     1.712    30.918     0.200
     1.723    30.750     0.200
     1.845    31.430     0.200
     1.942    33.098     0.200
     2.081    35.520     0.200
     2.060    35.520     0.200
     2.085    35.598     0.200
     2.244    37.629     0.200
     2.374    39.500     0.200
     2.423    40.398     0.200
     2.695    43.488     0.200
     2.688    43.758     0.200
     2.848    46.160     0.200
     2.902    46.379     0.200
     3.071    47.910     0.200
     3.109    48.789     0.200
     3.181    49.859     0.200
     3.516    53.770     0.200
     3.538    54.160     0.200
     3.664    56.207     0.200
     3.912    59.730     0.200
     4.053    62.090     0.200
     4.436    67.469     0.200
     4.578    70.508     0.200
     4.785    72.707     0.200
     4.927    72.898     0.200
     4.876    74.770     0.200
     4.890    73.320     0.200
     5.113    75.789     0.200
     5.192    76.500     0.200
     1.030    17.680     0.200
     1.123    19.602     0.200
     1.225    21.812     0.200
     1.349    22.621     0.200
     1.485    24.609     0.200
     1.683    30.070     0.200
     1.875    30.332     0.200
     1.929    34.801     0.200
     1.963    34.371     0.200
     1.968    33.672     0.200
     2.042    36.711     0.200
     2.251    39.109     0.200
     2.267    38.742     0.200
     2.357    42.359     0.200
     2.404    41.031     0.200
     0.840    14.715     0.200
     0.912    15.574     0.200
     1.078    17.926     0.200
     1.182    20.254     0.200
     1.241    20.547     0.200
     1.280    23.266     0.200
     1.230    20.984     0.200
     1.314    22.145     0.200
     1.339    22.367     0.200
     1.401    23.035     0.200
     1.445    26.125     0.200
     1.450    24.184     0.200
     1.566    24.855     0.200
     1.954    31.715     0.200
     1.944    31.164     0.200
     1.977    31.984     0.200
     1.997    31.523     0.200
     2.105    33.305     0.200
     2.124    34.125     0.200
     2.175    34.387     0.200
     2.293    35.234     0.200
     2.345    36.445     0.200
     2.464    38.484     0.200
     2.570    40.375     0.200
     2.584    39.984     0.200
     2.678    42.105     0.200
     2.696    42.195     0.200
     2.706    42.207     0.200
     2.756    41.984     0.200
     3.001    46.004     0.200
     3.009    48.625     0.200
     3.094    47.555     0.200
     3.140    48.066     0.200
     3.246    49.184     0.200
     3.253    49.395     0.200
     3.345    50.996     0.200
     3.492    53.184     0.200
     3.511    54.125     0.200
     3.592    54.266     0.200
     3.709    56.195     0.200
     3.753    56.516     0.200
     3.808    57.957     0.200
     3.994    60.887     0.200
     4.125    62.875     0.200
     4.137    62.004     0.200
     4.813    71.547     0.200
     4.901    73.715     0.200
     5.565    83.867     0.200
     5.838    87.434     0.200
     7.466   112.762     0.200
     7.796   113.164     0.200
     9.643   139.445     0.200
    11.807   171.746     0.200
     0.913    15.582     0.200
     1.075    17.934     0.200
     1.174    19.941     0.200
     1.174    19.812     0.200
     1.233    20.562     0.200
     1.307    22.023     0.200
     1.442    23.973     0.200
     1.561    24.902     0.200
     1.946    31.684     0.200
     1.970    31.852     0.200
     1.941    31.375     0.200
     1.994    31.555     0.200
     2.116    33.332     0.200
     2.101    33.484     0.200
     2.167    34.602     0.200
     2.287    36.715     0.200
     2.337    36.742     0.200
     2.459    38.215     0.200
     2.575    40.215     0.200
     2.564    40.375     0.200
     2.671    42.125     0.200
     2.687    42.281     0.200
     2.699    42.184     0.200
     2.750    42.984     0.200
     2.994    46.191     0.200
     3.132    47.984     0.200
     3.240    48.973     0.200
     3.252    49.824     0.200
     3.337    50.555     0.200
     3.503    53.934     0.200
     3.588    54.145     0.200
     3.703    56.023     0.200
     3.745    56.281     0.200
     3.802    57.984     0.200
     4.129    61.773     0.200
     4.119    61.852     0.200
     4.350    65.055     0.200
     4.465    68.434     0.200
     4.487    67.512     0.200
     4.687    70.715     0.200
     4.744    69.895     0.200
     4.809    71.703     0.200
     5.134    78.062     0.200
     5.308    79.754     0.200
     5.792    85.324     0.200
     1.095    18.820     0.200
     1.122    20.082     0.200
     1.179    20.980     0.200
     1.234    21.410     0.200
     1.250    21.840     0.200
     1.337    23.039     0.200
     1.293    22.719     0.200
     1.397    23.672     0.200
     1.443    24.621     0.200
     1.576    25.520     0.200
     1.702    27.469     0.200
     1.744    29.180     0.200
     1.765    28.879     0.200
     1.960    32.000     0.200
     1.963    31.680     0.200
     1.946    32.238     0.200
     1.982    33.641     0.200
     2.013    32.430     0.200
     2.090    33.922     0.200
     2.118    33.961     0.200
     2.113    34.648     0.200
     2.161    34.691     0.200
     2.191    35.180     0.200
     2.173    35.012     0.200
     2.205    35.340     0.200
     2.289    36.691     0.200
     2.300    36.129     0.200
     2.345    37.262     0.200
     2.346    37.238     0.200
     2.396    37.961     0.200
     2.445    38.922     0.200
     2.476    38.852     0.200
     2.492    39.262     0.200
     2.575    40.039     0.200
     2.643    41.680     0.200
     2.678    43.000     0.200
     2.682    42.840     0.200
     2.687    42.941     0.200
     2.765    42.551     0.200
     2.803    43.230     0.200
     2.934    45.430     0.200
     3.005    47.199     0.200
     3.088    47.559     0.200
     3.229    49.500     0.200
     3.344    51.148     0.200
     3.750    56.859     0.200
     4.137    62.719     0.200
     4.428    66.879     0.200
     4.465    67.180     0.200
     4.789    72.051     0.200
     4.892    74.359     0.200
     5.779    87.102     0.200
     5.841    88.059     0.200
     6.591    97.582     0.200
     7.464   112.109     0.200
     7.501   109.754     0.200
     8.124   119.961     0.200
     9.624   140.059     0.200
     9.624   139.648     0.200
    11.789   171.309     0.200
     0.959    18.117     0.200
     1.160    20.336     0.200
     1.134    19.055     0.200
     1.198    20.816     0.200
     1.291    22.117     0.200
     1.247    21.707     0.200
     1.279    23.035     0.200
     1.358    23.227     0.200
     1.456    25.016     0.200
     1.609    26.168     0.200
     1.999    31.758     0.200
     1.958    31.848     0.200
     2.011    32.086     0.200
     2.051    32.668     0.200
     2.155    33.965     0.200
     2.119    34.176     0.200
     2.192    34.965     0.200
     2.332    36.645     0.200
     2.370    37.375     0.200
     2.512    39.027     0.200
     2.605    40.465     0.200
     2.590    40.426     0.200
     2.701    42.016     0.200
     2.683    41.766     0.200
     2.675    42.055     0.200
     2.799    42.688     0.200
     3.033    46.238     0.200
     3.102    47.246     0.200
     3.136    47.977     0.200
     3.192    49.406     0.200
     3.496    53.617     0.200
     3.538    53.715     0.200
     3.748    55.266     0.200
     3.762    57.445     0.200
     3.956    59.215     0.200
     4.319    65.156     0.200
     4.425    66.145     0.200
     4.444    66.676     0.200
     4.772    69.836     0.200
     5.732    83.285     0.200
     5.820    85.207     0.200
     0.924    15.910     0.200
     1.369    23.270     0.200
     1.416    24.598     0.200
     1.417    24.207     0.200
     1.538    25.000     0.200
     1.923    31.617     0.200
     1.922    31.910     0.200
     2.080    33.539     0.200
     2.093    33.707     0.200
     2.142    34.699     0.200
     2.551    40.398     0.200
     2.683    42.680     0.200
     3.482    53.520     0.200
     0.902    15.656     0.200
     1.113    19.254     0.200
     1.168    20.188     0.200
     1.238    19.125     0.200
     1.224    20.457     0.200
     1.238    21.035     0.200
     1.292    21.688     0.200
     1.326    21.797     0.200
     1.386    22.875     0.200
     1.433    23.656     0.200
     1.483    24.645     0.200
     1.562    24.496     0.200
     1.688    26.676     0.200
     1.947    31.285     0.200
     1.937    31.688     0.200
     1.999    31.688     0.200
     2.105    33.176     0.200
     2.106    33.914     0.200
     2.161    34.137     0.200
     2.287    36.266     0.200
     2.463    38.098     0.200
     2.562    39.207     0.200
     2.567    40.117     0.200
     2.676    42.137     0.200
     2.685    41.016     0.200
     2.752    42.645     0.200
     3.239    49.324     0.200
     3.491    54.207     0.200
     3.573    55.016     0.200
     3.739    56.074     0.200
     3.787    58.254     0.200
     4.451    68.266     0.200
     4.692    72.207     0.200
     4.813    73.535     0.200
     5.121    78.457     0.200
     5.462    82.395     0.200
     5.544    82.906     0.200
     5.780    85.254     0.200
     5.834    88.387     0.200
     6.069    92.047     0.200
     1.264    22.164     0.200
     1.387    24.672     0.200
     1.308    23.492     0.200
     1.308    23.262     0.200
     1.503    26.184     0.200
     1.415    23.992     0.200
     1.585    26.723     0.200
     1.490    25.711     0.200
     1.519    26.852     0.200
     1.706    29.973     0.200
     1.793    30.133     0.200
     1.938    34.953     0.200
     2.293    39.113     0.200
     2.276    37.113     0.200
     2.354    41.141     0.200
     2.434    40.914     0.200
     2.337    39.773     0.200
     2.460    39.582     0.200
     2.669    45.812     0.200
     2.718    45.371     0.200
     2.896    46.652     0.200
     2.927    45.914     0.200
     2.948    49.781     0.200
     3.117    49.164     0.200
     3.050    49.512     0.200
     3.126    50.812     0.200
     3.379    55.102     0.200
     3.452    54.754     0.200
     3.669    59.371     0.200
     3.782    60.262     0.200
     3.894    60.871     0.200
     4.258    66.402     0.200
     4.562    70.863     0.200
     4.508    68.871     0.200
     4.502    71.801     0.200
     4.673    72.012     0.200
     4.769    72.980     0.200
     4.833    73.004     0.200
     4.831    73.551     0.200
     4.933    76.711     0.200
     4.952    77.461     0.200
     5.226    81.754     0.200
     5.253    82.434     0.200
     5.358    81.652     0.200
     5.351    82.293     0.200
     5.634    84.191     0.200
     5.573    88.941     0.200
     5.740    86.113     0.200
     5.806    85.172     0.200
     5.923    90.633     0.200
     6.094    92.883     0.200
     6.108    92.551     0.200
     6.136    90.812     0.200
     6.317    95.531     0.200
     6.529    97.621     0.200
     6.682    98.551     0.200
     6.920   102.551     0.200
     7.097   106.914     0.200
     7.205   107.293     0.200
     7.282   107.391     0.200
     7.423   110.863     0.200
     7.474   111.082     0.200
     7.565   111.344     0.200
     7.588   111.480     0.200
     7.973   117.293     0.200
     1.050    18.074     0.200
     1.300    22.504     0.200
     1.538    26.244     0.200
     1.827    30.123     0.200
     2.029    32.693     0.200
     2.356    38.184     0.200
     2.414    39.383     0.200
     2.647    42.244     0.200
     2.879    46.053     0.200
     2.865    46.543     0.200
     2.857    47.713     0.200
     2.999    49.904     0.200
     3.275    49.664     0.200
     3.157    52.064     0.200
     3.261    50.113     0.200
     3.260    52.744     0.200
     3.403    53.213     0.200
     3.453    56.404     0.200
     3.922    59.924     0.200
     4.221    64.123     0.200
     4.304    65.893     0.200
     4.333    66.953     0.200
     4.669    70.773     0.200
     4.997    76.074     0.200
     5.284    80.553     0.200
     5.707    85.754     0.200
     6.406    94.664     0.200
     6.634    99.283     0.200
     6.672    99.213     0.200
     6.854   102.273     0.200
     7.566   111.514     0.200
     7.699   112.973     0.200
     7.699   115.713     0.200
     7.640   112.904     0.200
     7.694   113.113     0.200
     7.885   116.643     0.200
     7.759   116.434     0.200
     7.785   116.543     0.200
     8.313   123.023     0.200
     8.677   128.564     0.200
     8.762   129.873     0.200
     8.845   129.973     0.200
     9.195   132.354     0.200
     9.195   134.014     0.200
     9.129   131.963     0.200
     9.193   134.893     0.200
    10.431   150.584     0.200
    11.195   161.904     0.200
    12.533   183.254     0.200
    14.978   212.863     0.200
    15.550   221.824     0.200
    15.561   220.914     0.200
    15.681   222.514     0.200
    15.835   222.113     0.200
     7.697   115.244     0.200
     0.864    15.133     0.200
     1.018    18.622     0.200
     1.039    17.572     0.200
     1.092    19.753     0.200
     1.072    18.713     0.200
     1.372    23.893     0.200
     1.361    23.812     0.200
     1.366    24.022     0.200
     1.406    24.202     0.200
     1.420    25.093     0.200
     1.614    27.343     0.200
     1.781    28.032     0.200
     2.114    35.152     0.200
     2.151    34.582     0.200
     2.207    38.562     0.200
     2.261    36.553     0.200
     2.360    37.242     0.200
     2.758    44.022     0.200
     2.810    44.532     0.200
     2.873    45.522     0.200
     3.121    48.143     0.200
     3.619    56.383     0.200
     3.796    58.692     0.200
     4.314    65.362     0.200
     1.349    23.438     0.200
     1.602    26.549     0.200
     2.174    35.889     0.200
     2.348    37.598     0.200
     2.798    43.389     0.200
     2.862    45.088     0.200
     3.527    55.008     0.200
     3.606    54.119     0.200
     3.787    58.408     0.200
     4.319    64.947     0.200
     4.372    66.697     0.200
     4.521    69.947     0.200
     4.703    70.418     0.200
     4.757    72.328     0.200
     4.929    73.447     0.200
     4.929    75.338     0.200
     5.920    89.107     0.200
     5.958    90.098     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.615    50.570     0.200
     7.039   136.539     0.200
     3.516    69.539     0.200
     4.035    77.359     0.200
     5.284   103.945     0.200
     6.860   132.477     0.200
     4.077    80.833     0.200
     6.045   115.433     0.200
     6.770   132.782     0.200
     7.697   152.032     0.200
     4.185    76.338     0.200
     5.011    90.922     0.200
     3.583    65.266     0.200
     6.440   126.195     0.200
     7.446   138.227     0.200
     7.680   150.359     0.200
     2.960    57.281     0.200
     3.828    72.438     0.200
     4.922    93.094     0.200
     5.307   101.195     0.200
     5.596   106.691     0.200
     7.484   139.816     0.200
     5.148    98.887     0.200
     2.635    48.348     0.200
     2.729    54.520     0.200
     2.989    54.277     0.200
     3.181    57.977     0.200
     3.585    67.363     0.200
     3.946    73.953     0.200
     4.681    87.191     0.200
     4.894    92.477     0.200
     5.700   107.898     0.200
     5.730   108.305     0.200
     6.123   116.184     0.200
     6.214   117.867     0.200
     2.764    50.754     0.200
     2.936    54.396     0.200
     3.283    59.781     0.200
     4.099    79.619     0.200
     2.530    45.873     0.200
     3.160    57.801     0.200
     3.167    58.025     0.200
     3.920    71.822     0.200
     4.710    87.039     0.200
     5.598   103.754     0.200
     5.864   106.082     0.200
     6.075   112.559     0.200
     7.625   146.250     0.200
     7.794   149.312     0.200
     3.907    76.037     0.200
     4.605    87.258     0.200
     2.810    51.570     0.200
     2.692    56.059     0.200
     2.754    54.648     0.200
     2.807    52.918     0.200
     3.477    66.355     0.200
     3.911    73.125     0.200
     3.899    72.109     0.200
     8.088   153.633     0.200
     3.598    65.951     0.200
     2.702    53.266     0.200
     3.085    60.414     0.200
     7.568   145.484     0.200
     2.994    55.164     0.200
     7.513   138.414     0.200
     3.420    63.059     0.200
     3.908    74.407     0.200
     2.921    58.938     0.200
     3.260    60.273     0.200
     4.229    80.773     0.200
     2.789    50.702     0.200
     4.225    79.361     0.200
     3.294    61.520     0.200
     3.496    66.766     0.200
     3.648    71.461     0.200
     4.463    90.191     0.200
     2.786    50.973     0.200
     4.442    81.867     0.200
     3.713    71.916     0.200
     4.401    87.910     0.200
     4.409    88.258     0.200
     4.389    85.016     0.200
     3.260    60.423     0.200
     4.447    89.855     0.200
     4.337    83.213     0.200
     4.371    89.047     0.200
     4.347    84.099     0.200
     4.388    87.750     0.200
     4.347    87.824     0.200
     4.420    83.904     0.200
     4.450    85.941     0.200
     4.400    84.523     0.200
     4.372    86.961     0.200
     4.460    86.336     0.200
     4.394    89.102     0.200
     4.435    84.492     0.200
     4.365    86.109     0.200
     4.385    85.549     0.200
     4.380    83.783     0.200
     2.565    49.438     0.200
     4.418    86.312     0.200
     4.416    87.258     0.200
     9.360   176.367     0.200
     4.408    86.344     0.200
     4.358    87.227     0.200
     2.608    49.262     0.200
     4.421    87.461     0.200
     4.437    83.750     0.200
     4.408    86.133     0.200
     3.530    65.487     0.200
     3.702    69.727     0.200
     4.419    83.025     0.200
     2.836    55.330     0.200
     2.836    53.012     0.200
     3.226    61.490     0.200
     3.365    61.451     0.200
     3.664    68.160     0.200
     4.416    81.980     0.200
     2.798    51.246     0.200
     2.798    54.266     0.200
     2.798    51.078     0.200
     4.453    87.262     0.200
     4.365    84.734     0.200
     3.591    69.703     0.200
     3.645    74.414     0.200
     4.375    84.242     0.200
     4.396    79.906     0.200
     4.416    80.711     0.200
     4.416    86.188     0.200
     7.716   143.992     0.200
     4.404    85.875     0.200
     2.781    51.473     0.200
     3.693    68.873     0.200
     4.470    89.217     0.200
     4.388    83.371     0.200
     4.424    86.107     0.200
     4.448    90.725     0.200
     4.426    87.521     0.200
     4.375    83.680     0.200
     4.430    87.203     0.200
     2.868    52.168     0.200
     4.386    86.199     0.200
     2.793    52.102     0.200
     4.458    88.656     0.200
     4.450    87.223     0.200
     4.395    89.324     0.200
     4.409    86.001     0.200
     2.716    49.934     0.200
     2.591    47.605     0.200
     2.594    49.832     0.200
     3.310    59.840     0.200
     2.585    51.234     0.200
     3.227    63.398     0.200
     3.431    65.305     0.200
     3.538    68.141     0.200
     3.464    71.373     0.200
     8.398   162.254     0.200
     2.984    54.229     0.200
     4.196    81.691     0.200
     4.158    84.406     0.200
     9.088   176.271     0.200
     3.108    58.473     0.200
     3.016    54.703     0.200
     4.250    82.082     0.200
     2.674    49.043     0.200
     4.203    81.145     0.200
     2.675    52.123     0.200
     3.303    65.573     0.200
     3.388    66.023     0.200
     3.616    68.113     0.200
     4.148    81.215     0.200
     2.956    54.992     0.200
     3.571    65.355     0.200
     3.571    73.008     0.200
     3.954    78.062     0.200
     8.520   166.414     0.200
     7.460   140.357     0.200
     9.251   174.789     0.200
     2.798    51.512     0.200
     2.716    53.652     0.200
     7.599   145.109     0.200
     3.177    60.027     0.200
     2.825    57.229     0.200
     7.492   139.652     0.200
     7.714   148.965     0.200
     3.161    59.934     0.200
     2.835    57.270     0.200
     7.481   137.246     0.200
     7.721   147.828     0.200
     9.340   179.051     0.200
    11.952   222.160     0.200
     3.873    78.103     0.200
     7.466   138.820     0.200
     2.575    50.254     0.200
     7.464   142.234     0.200
     7.699   143.648     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.551    10.480     0.200
     1.877    34.500     0.200
     1.994    36.660     0.200
     0.614    11.500     0.200
     1.077    19.492     0.200
     1.032    19.242     0.200
     1.045    19.734     0.200
     0.643    12.570     0.200
     1.974    37.320     0.200
     0.655    12.613     0.200
     1.117    21.137     0.200
     1.986    37.812     0.200
     0.655    12.730     0.200
     1.095    20.873     0.200
     0.542    10.047     0.200
     1.046    19.039     0.200
     2.615    45.750     0.200
     0.570    10.516     0.200
     1.067    20.320     0.200
     1.399    24.867     0.200
     1.399    25.047     0.200
     3.942    69.602     0.200
     0.830    16.173     0.200
     0.895    18.893     0.200
     3.826    68.143     0.200
     3.871    68.862     0.200
     4.496    80.373     0.200
     5.111    92.062     0.200
     6.272   107.734     0.200
     2.104    43.117     0.200
     3.583    61.477     0.200
     0.512     9.625     0.200
     0.879    16.742     0.200
     1.036    18.633     0.200
     1.036    18.492     0.200
     1.037    18.562     0.200
     1.037    18.406     0.200
     1.008    18.008     0.200
     4.187    73.867     0.200
     1.441    26.252     0.200
     1.987    36.792     0.200
     2.803    50.833     0.200
     1.186    20.996     0.200
     1.188    21.695     0.200
     1.207    21.395     0.200
     1.272    22.359     0.200
     1.272    22.180     0.200
     1.274    23.227     0.200
     1.274    23.375     0.200
     1.487    26.836     0.200
     0.743    14.547     0.200
     0.833    16.938     0.200
     0.929    17.508     0.200
     1.043    19.195     0.200
     1.042    19.195     0.200
     1.087    20.676     0.200
     2.490    44.992     0.200
     2.334    38.967     0.200
     2.475    44.148     0.200
     3.229    57.520     0.200
     3.385    60.930     0.200
     5.355    94.480     0.200
     0.609    11.266     0.200
     0.626    12.664     0.200
     0.753    14.574     0.200
     1.004    18.613     0.200
     1.065    19.633     0.200
     2.000    35.125     0.200
     2.015    36.414     0.200
     0.570    11.001     0.200
     0.686    13.021     0.200
     0.796    14.981     0.200
     0.936    18.201     0.200
     1.052    19.351     0.200
     1.155    22.221     0.200
     1.398    26.221     0.200
     1.694    29.981     0.200
     0.345     7.596     0.200
     1.353    23.745     0.200
     1.362    24.596     0.200
     1.443    25.136     0.200
     1.727    30.605     0.200
     2.058    34.355     0.200
     2.155    37.115     0.200
     3.114    51.985     0.200
     3.638    65.146     0.200
     3.911    67.321     0.200
     0.640    11.785     0.200
     0.735    13.535     0.200
     1.052    19.055     0.200
     1.364    23.936     0.200
     1.406    26.045     0.200
     1.669    30.416     0.200
     1.886    32.965     0.200
     1.918    32.285     0.200
     1.940    32.814     0.200
     2.185    40.098     0.200
     2.333    42.621     0.200
     2.888    50.455     0.200
     0.615    12.148     0.200
     0.875    16.344     0.200
     0.913    16.594     0.200
     1.123    20.094     0.200
     1.123    20.758     0.200
     1.699    33.180     0.200
     3.288    56.578     0.200
     0.591    11.398     0.200
     0.839    15.188     0.200
     1.018    18.344     0.200
     1.061    18.633     0.200
     1.061    18.734     0.200
     1.595    27.109     0.200
     1.652    28.938     0.200
     0.619    12.453     0.200
     0.880    17.023     0.200
     0.880    16.523     0.200
     1.112    20.148     0.200
     1.112    20.969     0.200
     1.768    32.969     0.200
     2.148    40.469     0.200
     2.163    39.367     0.200
     2.268    41.820     0.200
     4.023    71.844     0.200
     0.600    11.933     0.200
     0.866    15.843     0.200
     1.522    26.213     0.200
     1.533    27.813     0.200
     1.555    27.643     0.200
     0.720    14.058     0.200
     0.975    17.738     0.200
     1.338    24.518     0.200
     0.613    12.143     0.200
     0.632    12.202     0.200
     0.807    15.683     0.200
     0.988    18.053     0.200
     0.988    18.173     0.200
     1.026    19.843     0.200
     1.193    21.402     0.200
     1.235    22.083     0.200
     1.235    22.282     0.200
     2.931    50.032     0.200
     0.661    12.174     0.200
     0.616    12.023     0.200
     0.826    15.613     0.200
     0.981    17.583     0.200
     0.981    17.964     0.200
     1.382    25.273     0.200
     1.454    27.443     0.200
     0.609    11.368     0.200
     0.612    11.298     0.200
     0.773    14.528     0.200
     1.095    19.338     0.200
     1.423    24.358     0.200
     2.528    45.238     0.200
     3.164    54.408     0.200
     0.708    13.477     0.200
     0.816    15.207     0.200
     0.923    18.395     0.200
     0.930    17.387     0.200
     0.941    16.965     0.200
     1.038    19.234     0.200
     1.135    21.715     0.200
     0.585    11.207     0.200
     0.673    12.277     0.200
     0.790    14.648     0.200
     0.801    14.777     0.200
     1.012    18.320     0.200
     1.270    22.270     0.200
     1.382    25.738     0.200
     1.414    24.770     0.200
     1.442    25.258     0.200
     1.415    25.508     0.200
     1.500    25.910     0.200
     1.504    26.438     0.200
     1.654    28.219     0.200
     0.705    13.770     0.200
     0.952    18.102     0.200
     0.973    17.781     0.200
     1.554    26.762     0.200
     3.498    61.863     0.200
     0.665    12.840     0.200
     1.352    24.660     0.200
     1.598    27.402     0.200
     1.786    30.121     0.200
     2.053    36.680     0.200
     2.137    36.391     0.200
     2.346    40.312     0.200
     0.390     8.047     0.200
     0.819    15.695     0.200
     0.819    15.809     0.200
     1.607    30.758     0.200
     2.683    45.176     0.200
     3.128    56.316     0.200
     0.395     7.961     0.200
     3.086    53.906     0.200
     4.046    70.445     0.200
     0.449     9.102     0.200
     2.384    40.652     0.200
     3.949    65.992     0.200
     0.810    15.607     0.200
     1.078    19.746     0.200
     0.769    14.570     0.200
     1.037    18.836     0.200
     1.037    18.938     0.200
     1.939    36.398     0.200
     2.236    51.477     0.200
     0.519    10.191     0.200
     0.753    14.312     0.200
     0.787    14.422     0.200
     0.939    18.121     0.200
     0.933    17.613     0.200
     0.954    18.520     0.200
     0.963    17.941     0.200
     1.105    20.621     0.200
     1.097    21.070     0.200
     1.157    21.113     0.200
     1.491    26.422     0.200
     0.510    10.711     0.200
     0.778    14.680     0.200
     0.756    13.770     0.200
     0.926    16.629     0.200
     0.945    18.250     0.200
     0.955    17.629     0.200
     0.978    18.070     0.200
     0.941    17.141     0.200
     1.415    24.359     0.200
     1.465    25.309     0.200
     1.495    26.031     0.200
     3.262    54.391     0.200
     3.262    54.750     0.200
     0.532    10.559     0.200
     0.799    14.629     0.200
     0.941    16.869     0.200
     0.967    17.289     0.200
     0.976    17.119     0.200
     0.999    18.449     0.200
     1.353    26.006     0.200
     1.897    34.646     0.200
     2.106    38.402     0.200
     0.476    10.006     0.200
     0.743    14.516     0.200
     0.934    16.365     0.200
     0.934    16.525     0.200
     0.890    15.904     0.200
     0.919    16.805     0.200
     0.947    17.525     0.200
     1.083    18.664     0.200
     1.053    21.135     0.200
     0.215     4.645     0.200
     0.204     4.822     0.200
     1.022    18.553     0.200
     1.817    32.432     0.200
     2.473    41.562     0.200
     4.037    67.672     0.200
     4.253    75.797     0.200
     0.402     8.242     0.200
     0.513     9.789     0.200
     0.778    14.398     0.200
     0.871    16.055     0.200
     0.862    15.688     0.200
     1.025    18.117     0.200
     1.055    20.078     0.200
     1.140    19.883     0.200
     4.409    73.430     0.200
     0.547    10.756     0.200
     0.707    13.545     0.200
     0.752    13.994     0.200
     1.051    19.645     0.200
     0.447     8.967     0.200
     1.250    22.617     0.200
     1.470    26.227     0.200
     1.570    27.848     0.200
     2.236    38.467     0.200
     0.600    11.332     0.200
     0.718    13.683     0.200
     0.794    14.752     0.200
     1.180    20.952     0.200
     1.225    21.683     0.200
     1.224    21.462     0.200
     1.347    23.962     0.200
     1.439    26.832     0.200
     1.674    28.822     0.200
     2.044    34.143     0.200
     2.186    37.092     0.200
     0.716    13.836     0.200
     1.104    20.176     0.200
     1.492    28.566     0.200
     1.948    36.816     0.200
     2.736    49.773     0.200
     3.378    57.402     0.200
     0.737    14.094     0.200
     0.959    18.543     0.200
     1.003    18.734     0.200
     1.128    20.684     0.200
     1.128    20.785     0.200
     3.420    58.223     0.200
     0.321     7.208     0.200
     0.466     9.228     0.200
     0.593    11.478     0.200
     0.761    13.867     0.200
     0.787    14.577     0.200
     0.827    14.968     0.200
     0.863    15.758     0.200
     0.906    17.088     0.200
     0.947    17.117     0.200
     0.947    17.008     0.200
     0.998    17.808     0.200
     1.082    19.027     0.200
     0.503    10.033     0.200
     0.736    13.533     0.200
     0.736    14.293     0.200
     0.883    16.283     0.200
     0.949    17.254     0.200
     1.044    18.543     0.200
     1.044    18.674     0.200
     1.108    19.754     0.200
     0.213     5.617     0.200
     1.045    18.633     0.200
     1.045    18.508     0.200
     2.698    47.250     0.200
     3.357    59.844     0.200
     0.802    15.375     0.200
     0.979    18.836     0.200
     0.414     7.980     0.200
     0.459     9.961     0.200
     0.823    15.020     0.200
     0.860    15.277     0.200
     0.894    16.121     0.200
     0.948    17.000     0.200
     1.046    18.699     0.200
     1.082    19.238     0.200
     1.208    22.000     0.200
     1.466    25.039     0.200
     1.946    32.480     0.200
     0.456     9.140     0.200
     0.815    16.230     0.200
     0.452     9.133     0.200
     1.070    19.363     0.200
     1.102    19.785     0.200
     1.473    25.895     0.200
     1.602    27.434     0.200
     1.844    34.754     0.200
     0.427     8.766     0.200
     1.314    22.996     0.200
     1.507    26.436     0.200
     1.569    26.945     0.200
     1.718    29.485     0.200
     1.718    29.385     0.200
     1.912    34.485     0.200
     2.038    34.405     0.200
     2.838    50.755     0.200
     3.123    54.875     0.200
     3.547    58.706     0.200
     0.448     9.166     0.200
     1.077    19.316     0.200
     1.109    19.676     0.200
     1.109    19.486     0.200
     1.347    23.965     0.200
     1.477    25.926     0.200
     1.598    27.775     0.200
     1.775    29.775     0.200
     1.852    34.826     0.200
     1.996    35.605     0.200
     2.037    37.576     0.200
     3.540    60.625     0.200
     0.560    11.479     0.200
     0.560    10.857     0.200
     0.591    10.547     0.200
     0.645    12.258     0.200
     0.771    14.127     0.200
     0.835    15.367     0.200
     0.835    15.848     0.200
     1.020    18.438     0.200
     1.050    18.498     0.200
     1.221    21.568     0.200
     1.214    21.758     0.200
     0.315     6.607     0.200
     1.050    19.487     0.200
     0.337     7.276     0.200
     1.114    20.056     0.200
     1.114    19.946     0.200
     1.403    25.086     0.200
     1.619    28.126     0.200
     1.619    27.926     0.200
     1.589    28.026     0.200
     1.686    28.656     0.200
     1.659    28.646     0.200
     0.739    14.426     0.200
     1.006    18.506     0.200
     1.138    21.176     0.200
     1.138    20.625     0.200
     1.509    27.666     0.200
     1.627    29.285     0.200
     1.799    31.984     0.200
     2.621    46.955     0.200
     2.700    48.205     0.200
     0.706    13.609     0.200
     0.974    17.750     0.200
     0.964    18.203     0.200
     1.066    19.062     0.200
     1.066    19.523     0.200
     2.665    47.883     0.200
     0.704    13.688     0.200
     0.981    18.578     0.200
     0.971    17.750     0.200
     1.028    18.750     0.200
     1.028    19.551     0.200
     1.157    20.699     0.200
     1.157    21.008     0.200
     0.733    14.375     0.200
     0.929    17.914     0.200
     1.002    18.703     0.200
     1.002    18.445     0.200
     1.205    21.676     0.200
     1.579    29.305     0.200
     0.618    12.217     0.200
     0.616    11.916     0.200
     0.801    14.996     0.200
     0.992    18.166     0.200
     0.992    18.336     0.200
     1.228    21.977     0.200
     1.306    25.166     0.200
     1.443    26.137     0.200
     3.195    54.375     0.200
     0.573    11.168     0.200
     0.863    15.838     0.200
     0.863    16.578     0.200
     0.922    16.898     0.200
     1.422    24.638     0.200
     1.539    27.278     0.200
     1.586    29.278     0.200
     1.787    31.498     0.200
     0.563    11.076     0.200
     0.859    16.316     0.200
     0.933    17.856     0.200
     1.434    25.286     0.200
     1.587    29.526     0.200
     1.545    28.136     0.200
     1.793    33.406     0.200
     1.784    32.396     0.200
     1.994    35.706     0.200
     1.994    35.156     0.200
     2.014    35.816     0.200
     0.550    11.047     0.200
     0.905    16.500     0.200
     0.905    16.320     0.200
     0.939    17.578     0.200
     1.422    25.266     0.200
     1.502    26.234     0.200
     1.826    32.570     0.200
     1.967    35.148     0.200
     2.592    43.188     0.200
     0.583    11.543     0.200
     0.913    17.602     0.200
     0.854    16.914     0.200
     1.417    25.523     0.200
     4.463    75.215     0.200
     0.569    11.285     0.200
     0.847    16.484     0.200
     0.929    17.914     0.200
     4.465    80.617     0.200
     0.536    10.637     0.200
     0.861    16.145     0.200
     0.861    15.766     0.200
     0.960    17.387     0.200
     1.597    28.875     0.200
     1.815    32.004     0.200
     2.003    35.246     0.200
     0.533    10.516     0.200
     0.893    16.666     0.200
     0.958    17.616     0.200
     1.445    25.426     0.200
     1.626    30.406     0.200
     1.833    33.216     0.200
     2.604    44.696     0.200
     0.540    10.801     0.200
     0.909    16.391     0.200
     0.909    15.902     0.200
     0.949    17.090     0.200
     1.638    29.703     0.200
     1.833    32.191     0.200
     1.836    32.492     0.200
     1.889    32.141     0.200
     1.956    32.902     0.200
     1.956    32.582     0.200
     2.850    47.031     0.200
     0.511    10.152     0.200
     0.890    16.012     0.200
     0.890    16.184     0.200
     1.804    30.844     0.200
     2.841    47.504     0.200
     2.848    50.043     0.200
     0.568    11.289     0.200
     0.920    17.016     0.200
     0.942    17.477     0.200
     0.942    17.586     0.200
     4.381    73.594     0.200
     0.542    10.758     0.200
     0.924    17.641     0.200
     0.946    17.617     0.200
     0.549    10.773     0.200
     0.900    17.414     0.200
     0.941    18.008     0.200
     1.425    26.227     0.200
     1.508    27.648     0.200
     1.626    29.797     0.200
     1.748    31.297     0.200
     1.824    32.633     0.200
     1.901    32.969     0.200
     1.968    34.367     0.200
     2.591    44.492     0.200
     2.591    43.727     0.200
     3.563    62.719     0.200
     3.695    62.930     0.200
     0.580    11.383     0.200
     0.854    16.969     0.200
     0.854    16.828     0.200
     0.916    17.641     0.200
     1.420    25.312     0.200
     1.576    28.102     0.200
     1.777    31.828     0.200
     2.011    35.609     0.200
     2.551    44.141     0.200
     3.556    62.938     0.200
     0.549    10.823     0.200
     0.946    17.453     0.200
     1.006    17.663     0.200
     1.387    24.773     0.200
     1.403    24.473     0.200
     1.724    29.843     0.200
     1.827    32.273     0.200
     1.890    32.193     0.200
     1.882    32.093     0.200
     1.920    32.763     0.200
     1.920    33.323     0.200
     0.613    12.016     0.200
     0.901    17.406     0.200
     0.901    17.664     0.200
     1.364    24.727     0.200
     1.776    31.867     0.200
     2.534    42.617     0.200
     0.588    11.566     0.200
     0.944    17.986     0.200
     1.368    25.086     0.200
     1.453    25.807     0.200
     1.654    29.406     0.200
     1.691    30.195     0.200
     1.820    32.875     0.200
     1.897    34.516     0.200
     1.983    34.865     0.200
     1.983    35.836     0.200
     3.495    61.736     0.200
     3.585    65.096     0.200
     0.555    10.891     0.200
     0.933    16.570     0.200
     0.933    16.430     0.200
     0.933    16.758     0.200
     1.654    29.305     0.200
     1.838    32.383     0.200
     1.959    32.648     0.200
     0.959    18.117     0.200
     0.948    18.059     0.200
     1.424    25.816     0.200
     1.465    25.656     0.200
     1.676    29.758     0.200
     1.707    30.637     0.200
     1.866    32.867     0.200
     1.856    32.359     0.200
     1.856    32.957     0.200
     1.926    33.816     0.200
     1.931    34.066     0.200
     1.931    33.938     0.200
     0.591    11.496     0.200
     0.897    16.516     0.200
     0.941    17.057     0.200
     0.941    17.436     0.200
     1.366    24.156     0.200
     1.456    25.166     0.200
     1.650    28.637     0.200
     1.693    29.486     0.200
     1.816    30.695     0.200
     0.541    10.678     0.200
     0.949    17.768     0.200
     0.898    17.277     0.200
     0.898    16.787     0.200
     1.627    29.518     0.200
     1.752    31.678     0.200
     1.897    33.188     0.200
     3.704    62.867     0.200
     0.586    11.517     0.200
     0.903    16.887     0.200
     0.949    17.537     0.200
     0.949    17.257     0.200
     1.826    32.547     0.200
     1.948    34.887     0.200
     3.653    61.817     0.200
     0.584    11.480     0.200
     0.906    16.811     0.200
     0.898    16.330     0.200
     0.898    16.541     0.200
     1.392    24.400     0.200
     1.500    26.111     0.200
     1.737    29.701     0.200
     4.426    76.795     0.200
     0.580    11.316     0.200
     0.872    15.996     0.200
     0.872    17.164     0.200
     0.913    16.574     0.200
     0.596    11.791     0.200
     0.899    16.352     0.200
     1.003    17.801     0.200
     1.342    23.941     0.200
     1.394    24.801     0.200
     1.632    28.801     0.200
     1.707    30.051     0.200
     1.861    32.602     0.200
     1.861    31.932     0.200
     1.854    32.121     0.200
     1.942    34.121     0.200
     0.582    11.402     0.200
     0.906    17.121     0.200
     0.949    17.844     0.200
     0.562    10.871     0.200
     0.927    17.691     0.200
     0.952    18.492     0.200
     0.952    19.273     0.200
     3.676    65.074     0.200
     0.581    11.405     0.200
     0.911    16.796     0.200
     0.986    17.466     0.200
     1.853    33.024     0.200
     2.775    48.075     0.200
     0.593    11.643     0.200
     0.895    16.883     0.200
     0.960    18.111     0.200
     0.960    18.432     0.200
     1.667    29.992     0.200
     1.827    32.393     0.200
     0.475     9.954     0.200
     0.474     9.935     0.200
     0.543     9.914     0.200
     0.717    13.015     0.200
     0.749    14.354     0.200
     0.749    13.954     0.200
     0.825    14.704     0.200
     0.917    16.704     0.200
     0.917    16.685     0.200
     1.032    18.564     0.200
     1.032    18.834     0.200
     1.013    17.984     0.200
     1.062    19.805     0.200
     1.174    20.284     0.200
     1.130    20.725     0.200
     0.460    10.495     0.200
     0.459     9.515     0.200
     0.540    10.535     0.200
     0.540    10.365     0.200
     0.734    13.695     0.200
     0.734    14.445     0.200
     0.727    13.635     0.200
     0.830    15.285     0.200
     0.902    17.575     0.200
     0.909    16.695     0.200
     0.920    16.715     0.200
     0.960    17.635     0.200
     0.960    17.875     0.200
     0.999    18.425     0.200
     1.170    20.595     0.200
     1.170    20.895     0.200
     1.309    23.035     0.200
     1.532    28.085     0.200
     0.595    11.541     0.200
     0.893    16.281     0.200
     0.946    17.832     0.200
     3.644    62.852     0.200
     0.578    11.363     0.200
     0.913    17.043     0.200
     0.984    17.977     0.200
     0.984    18.094     0.200
     1.364    24.184     0.200
     1.416    25.066     0.200
     1.655    28.434     0.200
     1.695    29.453     0.200
     1.854    32.105     0.200
     0.567    11.219     0.200
     0.927    16.949     0.200
     0.995    17.609     0.200
     0.995    17.929     0.200
     1.372    23.999     0.200
     1.408    25.479     0.200
     1.648    28.649     0.200
     1.709    29.259     0.200
     1.870    32.069     0.200
     1.846    31.249     0.200
     1.941    33.159     0.200
     1.941    32.939     0.200
     2.614    42.929     0.200
     2.614    44.899     0.200
     0.583    11.421     0.200
     0.906    16.980     0.200
     0.905    17.190     0.200
     0.905    18.070     0.200
     0.581    11.412     0.200
     0.869    17.592     0.200
     0.869    17.371     0.200
     0.912    16.701     0.200
     1.589    30.852     0.200
     2.802    47.992     0.200
     0.585    11.676     0.200
     0.902    16.965     0.200
     3.655    61.953     0.200
     0.595    11.602     0.200
     0.894    16.324     0.200
     0.478     9.531     0.200
     0.847    16.004     0.200
     1.027    19.043     0.200
     1.529    26.965     0.200
     1.603    29.902     0.200
     1.744    32.332     0.200
     1.853    33.312     0.200
     2.644    44.523     0.200
     0.507    10.129     0.200
     0.859    16.941     0.200
     0.992    18.641     0.200
     1.604    29.379     0.200
     1.836    32.551     0.200
     0.473     9.445     0.200
     0.822    15.734     0.200
     1.044    19.164     0.200
     1.584    28.594     0.200
     1.713    30.695     0.200
     1.849    32.992     0.200
     0.584    11.477     0.200
     0.904    16.646     0.200
     0.935    17.467     0.200
     1.376    23.996     0.200
     1.463    26.297     0.200
     1.648    29.297     0.200
     1.818    31.857     0.200
     4.394    74.227     0.200
     0.571    11.172     0.200
     0.883    15.938     0.200
     0.883    16.977     0.200
     0.921    16.508     0.200
     1.604    31.281     0.200
     1.799    33.031     0.200
     0.541    10.531     0.200
     0.950    17.781     0.200
     0.950    18.805     0.200
     4.365    75.648     0.200
     0.586    11.429     0.200
     0.902    16.519     0.200
     0.937    16.789     0.200
     0.937    17.669     0.200
     1.373    24.159     0.200
     1.818    32.589     0.200
     0.731    14.229     0.200
     1.825    33.629     0.200
     1.887    36.049     0.200
     1.831    33.998     0.200
     2.001    35.898     0.200
     2.001    35.598     0.200
     2.572    46.229     0.200
     2.572    44.338     0.200
     3.033    51.299     0.200
     3.660    62.908     0.200
     0.548    10.834     0.200
     0.930    18.455     0.200
     0.940    18.225     0.200
     1.654    29.514     0.200
     0.555    11.039     0.200
     0.935    17.010     0.200
     0.971    18.020     0.200
     0.971    17.660     0.200
     1.391    24.510     0.200
     1.435    25.250     0.200
     1.675    29.561     0.200
     1.690    29.680     0.200
     1.856    31.990     0.200
     1.862    32.260     0.200
     1.943    33.051     0.200
     2.612    43.029     0.200
     4.351    74.334     0.200
     0.553    11.029     0.200
     0.939    17.449     0.200
     0.939    18.789     0.200
     0.578    11.488     0.200
     0.898    17.699     0.200
     0.898    17.480     0.200
     0.911    16.957     0.200
     1.398    24.551     0.200
     1.501    27.188     0.200
     1.616    29.777     0.200
     1.739    31.660     0.200
     1.802    32.418     0.200
     1.993    34.801     0.200
     2.565    43.641     0.200
     0.566    11.133     0.200
     0.901    17.383     0.200
     0.901    17.125     0.200
     0.923    17.465     0.200
     1.622    30.973     0.200
     0.595    11.703     0.200
     0.893    16.602     0.200
     0.914    17.781     0.200
     0.914    16.867     0.200
     0.564    11.062     0.200
     0.925    17.539     0.200
     0.911    17.469     0.200
     0.911    18.797     0.200
     2.844    51.609     0.200
     0.678    13.156     0.200
     1.096    22.066     0.200
     1.736    30.129     0.200
     1.977    35.629     0.200
     1.998    36.059     0.200
     2.155    37.668     0.200
     2.415    44.047     0.200
     2.915    50.848     0.200
     3.115    54.746     0.200
     3.223    57.238     0.200
     3.399    61.496     0.200
     4.759    80.988     0.200
     0.572    11.352     0.200
     0.917    17.312     0.200
     0.970    17.973     0.200
     0.970    18.082     0.200
     1.374    24.492     0.200
     1.683    30.609     0.200
     0.890    16.861     0.200
     1.084    21.052     0.200
     1.084    20.871     0.200
     1.295    23.541     0.200
     1.310    24.191     0.200
     1.547    27.962     0.200
     1.776    31.571     0.200
     1.824    32.302     0.200
     1.824    32.151     0.200
     1.848    31.962     0.200
     1.892    33.541     0.200
     1.951    33.972     0.200
     1.951    33.861     0.200
     2.608    43.771     0.200
     0.577    11.441     0.200
     0.863    16.322     0.200
     0.863    17.053     0.200
     0.918    16.652     0.200
     1.586    30.271     0.200
     1.538    28.053     0.200
     1.785    33.242     0.200
     2.005    34.883     0.200
     2.556    44.951     0.200
     2.798    47.893     0.200
     3.147    52.553     0.200
     0.581    11.457     0.200
     0.903    17.117     0.200
     0.903    17.297     0.200
     0.908    17.287     0.200
     1.619    31.027     0.200
     1.802    33.137     0.200
     0.515    10.211     0.200
     0.871    16.219     0.200
     0.980    18.242     0.200
     1.474    25.891     0.200
     1.835    31.672     0.200
     1.899    33.047     0.200
     1.951    33.258     0.200
     2.823    46.641     0.200
     0.543    10.750     0.200
     0.870    15.484     0.200
     0.870    16.180     0.200
     0.951    17.234     0.200
     0.545    10.633     0.200
     0.906    16.992     0.200
     1.426    25.828     0.200
     1.503    26.719     0.200
     1.743    31.672     0.200
     1.633    29.977     0.200
     1.894    33.656     0.200
     1.830    35.398     0.200
     1.962    35.359     0.200
     2.845    50.266     0.200
     3.499    58.492     0.200
     0.516    10.344     0.200
     0.894    16.516     0.200
     0.894    16.375     0.200
     1.845    32.391     0.200
     0.535    10.757     0.200
     0.954    17.757     0.200
     0.966    17.927     0.200
     1.411    24.967     0.200
     1.445    26.407     0.200
     1.687    29.947     0.200
     1.691    30.357     0.200
     1.847    32.727     0.200
     1.873    33.077     0.200
     1.928    32.677     0.200
     2.627    44.387     0.200
     3.240    54.377     0.200
     0.540    10.706     0.200
     0.890    16.296     0.200
     0.890    16.506     0.200
     0.951    17.116     0.200
     3.706    62.796     0.200
     0.579    11.311     0.200
     0.908    17.201     0.200
     0.908    17.031     0.200
     0.910    17.561     0.200
     3.517    63.240     0.200
     3.784    67.641     0.200
     4.073    69.500     0.200
     4.860    80.820     0.200
     0.563    11.176     0.200
     0.892    17.336     0.200
     0.928    17.098     0.200
     1.615    30.387     0.200
     1.809    33.457     0.200
     3.683    62.156     0.200
     0.560    11.098     0.200
     0.858    17.078     0.200
     0.936    17.457     0.200
     4.453    77.207     0.200
     0.570    11.133     0.200
     0.926    17.922     0.200
     0.860    16.992     0.200
     1.426    25.359     0.200
     1.585    30.812     0.200
     1.788    33.703     0.200
     1.939    34.422     0.200
     4.454    78.551     0.200
     0.558    10.875     0.200
     0.884    15.844     0.200
     0.884    16.594     0.200
     0.934    17.004     0.200
     1.610    30.562     0.200
     1.809    31.234     0.200
     1.981    34.414     0.200
     3.690    64.434     0.200
     0.560    10.996     0.200
     0.929    16.668     0.200
     0.957    17.695     0.200
     1.390    24.398     0.200
     1.687    29.387     0.200
     0.574    11.367     0.200
     0.921    17.109     0.200
     1.785    32.742     0.200
     1.942    34.516     0.200
     0.565    11.258     0.200
     0.927    17.038     0.200
     1.420    24.968     0.200
     1.802    33.308     0.200
     0.647    12.688     0.200
     0.846    15.875     0.200
     0.985    18.570     0.200
     0.985    19.367     0.200
     2.538    43.875     0.200
     0.633    12.378     0.200
     0.879    16.148     0.200
     1.061    18.618     0.200
     1.295    23.128     0.200
     1.331    23.548     0.200
     1.753    30.908     0.200
     1.844    32.019     0.200
     1.844    31.608     0.200
     1.966    33.258     0.200
     0.564    11.059     0.200
     0.885    17.711     0.200
     0.928    17.539     0.200
     1.609    29.641     0.200
     2.865    50.219     0.200
     3.683    66.680     0.200
     0.525    10.320     0.200
     0.910    17.641     0.200
     0.964    17.703     0.200
     2.854    46.812     0.200
     3.718    62.367     0.200
     0.560    11.000     0.200
     0.929    17.359     0.200
     2.836    49.699     0.200
     0.554    10.922     0.200
     0.912    16.883     0.200
     0.934    17.094     0.200
     1.636    30.133     0.200
     1.826    32.445     0.200
     3.688    65.250     0.200
     0.565    11.173     0.200
     0.840    15.243     0.200
     0.840    16.493     0.200
     0.562    11.160     0.200
     0.926    17.570     0.200
     1.863    35.250     0.200
     2.864    50.953     0.200
     3.678    63.160     0.200
     0.569    11.238     0.200
     0.895    16.988     0.200
     0.895    16.850     0.200
     0.921    17.328     0.200
     1.408    24.828     0.200
     2.856    50.709     0.200
     2.828    49.270     0.200
     2.828    50.039     0.200
     3.676    62.158     0.200
     0.569    11.100     0.200
     0.867    16.730     0.200
     0.925    17.119     0.200
     1.423    24.830     0.200
     1.591    28.350     0.200
     1.792    30.930     0.200
     2.882    48.600     0.200
     3.570    60.590     0.200
     4.448    75.250     0.200
     0.570    11.258     0.200
     0.849    15.938     0.200
     0.849    16.785     0.200
     0.928    17.418     0.200
     1.433    25.258     0.200
     1.576    27.508     0.200
     1.783    30.828     0.200
     0.575    11.328     0.200
     0.895    16.768     0.200
     0.895    17.479     0.200
     0.915    17.367     0.200
     1.403    25.248     0.200
     1.614    29.418     0.200
     1.802    32.588     0.200
     2.567    44.117     0.200
     3.167    53.697     0.200
     3.670    63.039     0.200
     0.595    11.688     0.200
     0.956    17.048     0.200
     1.147    20.708     0.200
     1.147    20.968     0.200
     1.259    22.738     0.200
     1.331    23.908     0.200
     1.502    26.468     0.200
     1.744    29.418     0.200
     1.744    30.408     0.200
     1.851    32.398     0.200
     1.879    31.818     0.200
     1.972    34.058     0.200
     0.585    11.484     0.200
     0.951    17.234     0.200
     1.117    20.074     0.200
     1.117    20.694     0.200
     1.289    23.094     0.200
     1.340    23.874     0.200
     1.531    26.904     0.200
     1.762    29.964     0.200
     1.888    31.794     0.200
     1.824    31.435     0.200
     1.953    33.194     0.200
     0.578    11.477     0.200
     0.911    17.484     0.200
     0.581    11.344     0.200
     0.907    16.648     0.200
     0.956    17.500     0.200
     1.370    24.805     0.200
     1.443    25.523     0.200
     1.681    29.375     0.200
     1.884    32.844     0.200
     0.573    11.227     0.200
     0.890    17.164     0.200
     0.917    16.578     0.200
     1.610    28.617     0.200
     1.800    31.547     0.200
     0.566    11.256     0.200
     0.922    17.055     0.200
     0.914    17.506     0.200
     0.914    17.385     0.200
     1.402    24.666     0.200
     1.634    29.045     0.200
     0.557    11.066     0.200
     0.931    17.168     0.200
     0.935    16.906     0.200
     0.935    17.879     0.200
     1.470    26.156     0.200
     3.683    63.898     0.200
     0.543    10.672     0.200
     0.927    17.203     0.200
     0.927    17.801     0.200
     0.471     9.438     0.200
     0.824    15.742     0.200
     1.045    18.922     0.200
     1.714    30.430     0.200
     1.851    32.602     0.200
     4.458    76.586     0.200
     0.571    11.148     0.200
     0.877    16.375     0.200
     0.921    16.859     0.200
     1.416    24.945     0.200
     1.599    28.586     0.200
     1.763    30.625     0.200
     1.796    31.320     0.200
     1.995    34.438     0.200
     2.565    43.859     0.200
     3.159    52.805     0.200
     0.540    10.719     0.200
     0.958    17.149     0.200
     1.589    29.019     0.200
     1.808    31.769     0.200
     1.978    33.149     0.200
     0.559    11.094     0.200
     0.860    16.354     0.200
     0.860    17.024     0.200
     0.936    17.184     0.200
     1.545    27.894     0.200
     1.589    30.604     0.200
     1.796    31.904     0.200
     0.624    12.245     0.200
     0.952    18.104     0.200
     1.674    30.335     0.200
     1.674    30.024     0.200
     1.799    33.045     0.200
     4.395    74.023     0.200
     0.552    10.821     0.200
     0.905    16.421     0.200
     0.905    16.901     0.200
     0.937    16.971     0.200
     0.840    15.688     0.200
     0.804    15.669     0.200
     1.278    24.059     0.200
     1.372    25.749     0.200
     1.520    27.969     0.200
     2.497    42.358     0.200
     2.801    48.039     0.200
     2.882    50.329     0.200
     3.136    53.019     0.200
     3.912    67.229     0.200
     0.627    12.324     0.200
     1.184    21.574     0.200
     1.222    23.223     0.200
     1.222    22.863     0.200
     1.428    25.625     0.200
     1.700    30.383     0.200
     1.700    29.836     0.200
     1.921    33.945     0.200
     1.856    32.254     0.200
     2.022    37.383     0.200
     0.661    12.945     0.200
     0.923    17.225     0.200
     1.199    22.154     0.200
     1.196    22.555     0.200
     1.270    22.955     0.200
     1.439    25.705     0.200
     1.883    33.484     0.200
     1.972    36.295     0.200
     3.349    59.846     0.200
     0.694    13.645     0.200
     0.654    12.633     0.200
     0.935    16.910     0.200
     1.194    21.539     0.200
     1.203    21.723     0.200
     1.280    22.770     0.200
     1.435    25.141     0.200
     1.740    29.449     0.200
     1.893    32.520     0.200
     1.984    34.133     0.200
     3.362    58.223     0.200
     0.616    12.203     0.200
     1.023    19.398     0.200
     1.720    31.000     0.200
     1.854    32.953     0.200
     1.970    33.602     0.200
     0.757    14.748     0.200
     0.923    17.648     0.200
     1.025    18.799     0.200
     1.156    21.498     0.200
     1.156    21.008     0.200
     0.743    14.217     0.200
     1.197    21.559     0.200
     0.917    16.938     0.200
     1.537    27.578     0.200
     1.176    21.088     0.200
     1.448    25.238     0.200
     1.448    25.098     0.200
     1.391    24.158     0.200
     1.400    25.547     0.200
     1.684    28.748     0.200
     0.734    14.035     0.200
     1.188    21.246     0.200
     0.929    16.957     0.200
     1.388    24.594     0.200
     1.188    21.375     0.200
     1.523    27.004     0.200
     1.413    24.477     0.200
     1.457    24.996     0.200
     1.457    25.246     0.200
     1.688    28.387     0.200
     2.229    37.934     0.200
     2.301    39.246     0.200
     2.995    49.727     0.200
     0.661    12.758     0.200
     0.932    16.719     0.200
     1.188    21.180     0.200
     1.985    35.883     0.200
     0.637    12.547     0.200
     0.925    17.627     0.200
     0.628    12.256     0.200
     0.955    17.006     0.200
     1.196    21.547     0.200
     1.196    21.926     0.200
     1.207    21.586     0.200
     1.305    23.736     0.200
     1.726    30.096     0.200
     1.726    29.576     0.200
     1.876    31.766     0.200
     1.893    32.736     0.200
     1.995    34.807     0.200
     0.777    14.984     0.200
     0.871    17.008     0.200
     1.039    19.336     0.200
     1.264    23.469     0.200
     1.678    30.141     0.200
     1.678    31.055     0.200
     0.733    13.977     0.200
     0.924    16.648     0.200
     1.537    28.281     0.200
     2.321    42.117     0.200
     2.321    42.656     0.200
     2.971    50.125     0.200
     0.932    17.051     0.200
     0.731    13.949     0.200
     1.190    21.418     0.200
     1.189    21.301     0.200
     1.391    24.301     0.200
     1.456    25.410     0.200
     1.456    25.590     0.200
     1.521    25.910     0.200
     1.521    26.711     0.200
     1.686    28.629     0.200
     0.746    14.594     0.200
     0.929    17.461     0.200
     1.185    21.504     0.200
     1.155    21.152     0.200
     1.490    25.832     0.200
     1.356    24.062     0.200
     1.508    26.070     0.200
     2.917    50.391     0.200
     0.630    12.223     0.200
     0.903    16.533     0.200
     1.111    19.922     0.200
     2.668    46.453     0.200
     0.639    12.387     0.200
     0.923    16.607     0.200
     1.162    20.357     0.200
     1.162    20.027     0.200
     2.619    44.527     0.200
     3.354    60.047     0.200
     0.598    11.684     0.200
     0.926    16.812     0.200
     1.093    19.336     0.200
     1.093    20.125     0.200
     1.796    31.176     0.200
     1.923    34.645     0.200
     0.632    12.383     0.200
     0.939    18.133     0.200
     1.224    22.312     0.200
     1.298    23.910     0.200
     1.465    26.301     0.200
     3.350    57.430     0.200
     0.609    12.074     0.200
     1.257    22.914     0.200
     1.317    23.652     0.200
     1.499    26.395     0.200
     1.961    34.062     0.200
     3.057    54.445     0.200
     0.612    12.141     0.200
     0.945    17.051     0.200
     1.155    20.148     0.200
     1.155    20.520     0.200
     1.247    22.641     0.200
     1.315    23.559     0.200
     1.489    26.469     0.200
     1.749    29.598     0.200
     1.749    29.969     0.200
     1.855    31.461     0.200
     1.888    31.598     0.200
     1.888    31.918     0.200
     1.968    35.188     0.200
     0.675    13.243     0.200
     0.930    17.233     0.200
     1.910    33.723     0.200
     3.369    59.223     0.200
     0.673    13.240     0.200
     1.161    21.150     0.200
     1.236    22.750     0.200
     2.686    47.291     0.200
     0.761    14.145     0.200
     1.029    18.256     0.200
     0.919    16.996     0.200
     1.154    20.625     0.200
     1.154    20.375     0.200
     1.887    32.035     0.200
     3.279    57.996     0.200
     0.738    14.453     0.200
     0.924    17.293     0.200
     1.182    21.344     0.200
     0.780    15.203     0.200
     1.144    21.102     0.200
     0.560    11.963     0.200
     0.589    11.344     0.200
     0.589    11.533     0.200
     0.646    12.393     0.200
     0.773    14.354     0.200
     0.773    13.873     0.200
     0.835    15.473     0.200
     0.996    18.764     0.200
     1.048    18.844     0.200
     1.059    19.264     0.200
     1.079    19.223     0.200
     1.667    30.113     0.200
     4.282    74.973     0.200
     0.242     4.867     0.200
     0.828    16.020     0.200
     0.815    15.680     0.200
     1.283    23.223     0.200
     1.283    23.070     0.200
     1.508    27.172     0.200
     1.563    27.152     0.200
     1.671    29.492     0.200
     2.879    50.812     0.200
     3.276    55.480     0.200
     0.822    15.479     0.200
     0.824    15.828     0.200
     1.089    19.549     0.200
     1.196    21.668     0.200
     1.266    23.258     0.200
     1.266    22.709     0.200
     2.864    50.258     0.200
     0.528    11.074     0.200
     0.528    11.094     0.200
     0.564    10.766     0.200
     0.564     9.664     0.200
     0.677    12.824     0.200
     0.802    14.906     0.200
     0.802    15.074     0.200
     0.798    14.684     0.200
     0.970    17.453     0.200
     0.970    17.953     0.200
     0.969    17.625     0.200
     0.987    17.445     0.200
     1.034    18.363     0.200
     1.028    19.035     0.200
     1.058    18.824     0.200
     1.104    20.176     0.200
     1.584    27.434     0.200
     2.716    45.227     0.200
     0.498    10.260     0.200
     0.552     9.980     0.200
     0.551     9.980     0.200
     0.699    12.930     0.200
     0.813    14.570     0.200
     0.940    17.469     0.200
     0.940    16.820     0.200
     0.958    16.869     0.200
     1.034    18.199     0.200
     1.032    18.561     0.200
     1.032    18.689     0.200
     1.183    20.650     0.200
     1.337    23.109     0.200
     0.558    12.195     0.200
     0.619    11.383     0.200
     0.619    12.164     0.200
     1.055    19.402     0.200
     1.084    20.004     0.200
     1.328    23.965     0.200
     1.630    29.035     0.200
     0.593    11.418     0.200
     0.592    11.457     0.200
     1.321    24.137     0.200
     1.302    23.355     0.200
     1.378    27.047     0.200
     1.618    29.348     0.200
     0.528    10.812     0.200
     0.528    10.844     0.200
     0.566    10.562     0.200
     0.565    10.531     0.200
     0.676    13.297     0.200
     0.802    14.797     0.200
     0.797    15.102     0.200
     0.797    14.672     0.200
     0.970    17.195     0.200
     0.968    17.758     0.200
     0.968    17.961     0.200
     1.036    18.594     0.200
     1.028    18.445     0.200
     1.057    18.734     0.200
     1.105    20.016     0.200
     1.116    19.688     0.200
     1.586    27.227     0.200
     0.507    10.906     0.200
     0.507    10.266     0.200
     0.573    10.383     0.200
     0.573    10.367     0.200
     0.680    13.008     0.200
     0.792    14.984     0.200
     0.792    14.367     0.200
     0.968    18.484     0.200
     1.053    19.188     0.200
     1.028    18.719     0.200
     1.163    22.539     0.200
     1.204    21.844     0.200
     1.204    22.484     0.200
     1.286    22.680     0.200
     1.356    24.930     0.200
     1.606    28.133     0.200
     0.551    10.766     0.200
     0.550    10.727     0.200
     0.726    13.875     0.200
     0.824    15.516     0.200
     0.824    15.227     0.200
     0.888    17.758     0.200
     0.906    16.375     0.200
     0.949    19.031     0.200
     0.983    18.945     0.200
     1.048    19.680     0.200
     1.610    28.969     0.200
     0.558    10.703     0.200
     0.558    10.695     0.200
     0.710    13.812     0.200
     0.813    15.336     0.200
     0.998    19.031     0.200
     1.609    28.008     0.200
     0.500    11.053     0.200
     0.566    10.733     0.200
     0.566    10.713     0.200
     0.688    13.533     0.200
     0.799    15.223     0.200
     0.799    14.823     0.200
     1.026    18.893     0.200
     1.281    22.903     0.200
     1.322    23.163     0.200
     1.442    25.133     0.200
     1.602    28.114     0.200
     0.796    15.255     0.200
     1.063    19.265     0.200
     1.197    21.186     0.200
     1.279    23.035     0.200
     1.279    22.715     0.200
     1.665    29.146     0.200
     1.732    31.705     0.200
     0.514    10.088     0.200
     0.690    12.998     0.200
     0.708    12.958     0.200
     1.102    20.358     0.200
     1.326    25.718     0.200
     1.412    25.348     0.200
     1.614    28.298     0.200
     0.402     8.289     0.200
     0.757    14.109     0.200
     0.840    15.320     0.200
     0.834    15.719     0.200
     0.867    15.430     0.200
     0.931    16.641     0.200
     0.991    19.195     0.200
     1.068    18.633     0.200
     1.179    20.242     0.200
     1.569    26.680     0.200
     0.593    11.754     0.200
     0.642    12.422     0.200
     0.642    12.293     0.200
     0.740    14.645     0.200
     0.780    14.582     0.200
     1.013    18.531     0.200
     1.159    21.113     0.200
     1.251    22.223     0.200
     1.251    23.223     0.200
     1.322    26.324     0.200
     1.466    27.121     0.200
     1.520    26.395     0.200
     2.228    39.145     0.200
     2.291    42.562     0.200
     0.630    12.043     0.200
     0.630    11.773     0.200
     0.601    11.285     0.200
     0.724    14.285     0.200
     0.784    14.887     0.200
     1.008    18.395     0.200
     1.008    17.875     0.200
     1.242    22.137     0.200
     1.355    24.066     0.200
     1.454    26.453     0.200
     1.597    27.496     0.200
     1.629    27.625     0.200
     2.465    44.324     0.200
     0.584    11.656     0.200
     0.654    12.137     0.200
     0.653    12.266     0.200
     0.774    14.566     0.200
     1.019    18.496     0.200
     1.261    22.117     0.200
     1.335    26.148     0.200
     1.335    26.605     0.200
     1.382    24.766     0.200
     1.478    28.078     0.200
     1.524    26.277     0.200
     0.588    11.520     0.200
     0.657    12.008     0.200
     0.656    12.020     0.200
     0.783    14.367     0.200
     0.783    14.598     0.200
     0.769    15.500     0.200
     0.768    14.449     0.200
     1.039    19.859     0.200
     1.013    18.238     0.200
     1.013    18.098     0.200
     1.260    21.809     0.200
     1.350    25.188     0.200
     1.513    25.797     0.200
     2.946    51.617     0.200
     0.539    10.707     0.200
     0.682    12.168     0.200
     0.682    12.188     0.200
     0.696    13.246     0.200
     0.685    13.789     0.200
     0.685    13.797     0.200
     1.099    19.930     0.200
     1.099    20.129     0.200
     1.108    20.469     0.200
     1.132    20.770     0.200
     1.146    20.996     0.200
     1.306    23.477     0.200
     0.616    12.135     0.200
     0.605    11.844     0.200
     0.604    11.863     0.200
     0.640    12.465     0.200
     0.640    12.545     0.200
     0.772    14.564     0.200
     0.913    16.773     0.200
     1.026    18.693     0.200
     1.142    20.584     0.200
     1.216    22.033     0.200
     1.229    21.824     0.200
     1.418    25.514     0.200
     1.557    26.914     0.200
     1.557    26.795     0.200
     0.623    12.969     0.200
     0.602    11.750     0.200
     0.602    11.641     0.200
     0.603    11.609     0.200
     0.620    11.945     0.200
     0.769    14.391     0.200
     1.033    18.508     0.200
     1.145    20.500     0.200
     1.229    21.688     0.200
     1.292    23.078     0.200
     2.575    46.031     0.200
     0.348     6.973     0.200
     1.192    21.891     0.200
     1.382    25.543     0.200
     1.480    28.102     0.200
     2.815    49.363     0.200
     2.913    48.570     0.200
     0.624    12.965     0.200
     0.624    13.074     0.200
     0.601    11.883     0.200
     0.600    11.914     0.200
     0.621    12.145     0.200
     0.772    14.645     0.200
     0.897    17.184     0.200
     1.066    19.953     0.200
     1.066    20.133     0.200
     1.080    19.465     0.200
     1.030    18.875     0.200
     1.126    20.445     0.200
     1.226    21.852     0.200
     1.411    25.035     0.200
     1.563    27.133     0.200
     2.573    45.902     0.200
     4.643    80.715     0.200
     0.369     7.712     0.200
     1.201    21.632     0.200
     1.201    21.893     0.200
     1.365    24.223     0.200
     1.350    24.853     0.200
     1.638    28.053     0.200
     1.572    27.362     0.200
     0.603    11.684     0.200
     0.603    11.574     0.200
     0.618    12.254     0.200
     0.658    12.693     0.200
     0.780    14.475     0.200
     1.225    22.613     0.200
     1.309    23.824     0.200
     1.421    27.133     0.200
     1.561    28.203     0.200
     0.618    11.586     0.200
     0.618    11.734     0.200
     0.618    11.625     0.200
     0.604    11.684     0.200
     0.770    14.367     0.200
     0.770    14.477     0.200
     1.024    19.484     0.200
     1.238    22.867     0.200
     1.258    25.266     0.200
     1.325    24.305     0.200
     1.716    32.285     0.200
     2.248    38.836     0.200
     0.602    11.594     0.200
     0.758    14.152     0.200
     0.648    12.902     0.200
     0.648    12.844     0.200
     0.619    11.523     0.200
     0.618    11.543     0.200
     0.618    11.434     0.200
     1.088    20.371     0.200
     1.039    18.402     0.200
     1.235    23.074     0.200
     1.243    21.621     0.200
     1.314    23.461     0.200
     2.550    45.082     0.200
     0.597    11.906     0.200
     0.624    11.453     0.200
     0.623    11.430     0.200
     0.671    12.812     0.200
     0.762    14.055     0.200
     1.257    23.625     0.200
     1.245    22.453     0.200
     1.245    22.844     0.200
     1.328    23.766     0.200
     0.578    11.426     0.200
     0.643    11.652     0.200
     0.675    13.414     0.200
     0.740    13.664     0.200
     1.054    19.285     0.200
     1.054    19.426     0.200
     1.265    22.855     0.200
     1.342    24.426     0.200
     1.655    29.074     0.200
     0.683    13.053     0.200
     0.988    17.783     0.200
     1.167    20.863     0.200
     1.886    32.073     0.200
     3.114    51.002     0.200
     0.541    11.555     0.200
     0.541    11.535     0.200
     0.578    10.422     0.200
     0.816    14.934     0.200
     0.784    14.125     0.200
     0.978    18.262     0.200
     0.983    18.285     0.200
     1.001    17.965     0.200
     1.040    18.734     0.200
     1.040    18.934     0.200
     1.064    19.375     0.200
     1.044    18.113     0.200
     1.044    18.953     0.200
     1.209    21.773     0.200
     1.371    23.395     0.200
     1.404    23.832     0.200
     0.368     7.819     0.200
     0.368     7.789     0.200
     0.462     8.829     0.200
     0.461     8.819     0.200
     0.639    11.919     0.200
     0.821    14.599     0.200
     0.982    17.189     0.200
     0.362     7.766     0.200
     0.363     7.796     0.200
     0.464     8.876     0.200
     0.464     8.806     0.200
     0.634    11.796     0.200
     0.828    14.946     0.200
     0.956    16.896     0.200
     0.986    17.266     0.200
     0.986    17.406     0.200
     1.212    20.686     0.200
     0.236     4.688     0.200
     0.354     7.688     0.200
     0.354     7.680     0.200
     0.460     9.719     0.200
     0.460     9.539     0.200
     0.565    10.828     0.200
     0.593    11.758     0.200
     0.642    11.797     0.200
     0.755    14.090     0.200
     0.725    13.348     0.200
     0.739    13.527     0.200
     0.742    14.508     0.200
     0.743    14.828     0.200
     0.785    14.887     0.200
     0.945    17.449     0.200
     1.088    19.629     0.200
     1.103    20.090     0.200
     1.146    21.430     0.200
     1.198    21.660     0.200
     1.268    23.688     0.200
     1.305    23.527     0.200
     1.403    25.438     0.200
     1.437    25.777     0.200
     1.414    25.590     0.200
     0.238     4.801     0.200
     0.238     4.793     0.200
     0.330     7.852     0.200
     0.599    11.480     0.200
     0.726    13.383     0.200
     0.771    14.172     0.200
     0.824    14.973     0.200
     0.824    15.383     0.200
     1.126    20.340     0.200
     1.225    21.641     0.200
     1.334    23.660     0.200
     1.430    25.652     0.200
     1.475    25.871     0.200
     0.387     8.355     0.200
     0.387     8.484     0.200
     0.472     9.125     0.200
     0.473     9.176     0.200
     0.658    12.477     0.200
     0.826    15.164     0.200
     0.840    14.914     0.200
     0.849    15.195     0.200
     0.849    15.574     0.200
     0.892    15.934     0.200
     0.971    17.574     0.200
     0.972    16.934     0.200
     1.036    20.035     0.200
     0.987    17.484     0.200
     1.099    19.305     0.200
     0.379     8.352     0.200
     0.475     9.113     0.200
     0.474     9.102     0.200
     0.651    12.555     0.200
     0.819    14.754     0.200
     0.841    15.332     0.200
     0.834    14.734     0.200
     0.884    15.824     0.200
     0.964    16.953     0.200
     0.956    17.184     0.200
     0.956    17.324     0.200
     0.964    18.152     0.200
     0.992    17.594     0.200
     0.992    17.453     0.200
     1.100    19.203     0.200
     1.229    20.973     0.200
     0.497     9.941     0.200
     0.829    15.660     0.200
     0.846    15.559     0.200
     0.842    16.301     0.200
     0.891    16.852     0.200
     0.891    16.719     0.200
     0.975    18.320     0.200
     0.890    16.309     0.200
     0.958    17.820     0.200
     1.012    18.320     0.200
     1.094    20.512     0.200
     1.179    21.020     0.200
     0.415     9.488     0.200
     0.415     9.508     0.200
     0.533    10.215     0.200
     0.534    10.207     0.200
     0.690    13.617     0.200
     0.857    15.996     0.200
     0.857    15.707     0.200
     0.877    15.836     0.200
     0.856    16.777     0.200
     0.914    16.977     0.200
     1.042    18.516     0.200
     1.117    20.977     0.200
     0.354     7.207     0.200
     0.810    15.027     0.200
     0.810    15.309     0.200
     0.943    17.359     0.200
     0.997    17.727     0.200
     1.095    19.527     0.200
     1.149    20.578     0.200
     1.216    21.297     0.200
     1.306    22.527     0.200
     1.292    22.348     0.200
     0.376     8.117     0.200
     0.376     8.176     0.200
     0.489     9.125     0.200
     0.488     9.098     0.200
     0.833    14.895     0.200
     0.952    16.766     0.200
     1.007    18.188     0.200
     1.007    18.055     0.200
     0.762    15.074     0.200
     0.696    13.344     0.200
     1.197    22.371     0.200
     1.071    19.773     0.200
     1.203    21.852     0.200
     1.415    25.641     0.200
     0.953    18.223     0.200
     0.725    13.764     0.200
     1.167    20.934     0.200
     1.514    27.754     0.200
     1.564    28.543     0.200
     1.845    32.164     0.200
     0.612    12.032     0.200
     0.589    11.322     0.200
     0.589    12.223     0.200
     0.620    11.332     0.200
     1.018    19.223     0.200
     1.072    19.603     0.200
     1.250    22.702     0.200
     1.420    27.643     0.200
     0.619    10.979     0.200
     0.617    12.068     0.200
     1.075    19.098     0.200
     1.005    19.018     0.200
     1.040    19.268     0.200
     1.079    19.139     0.200
     1.250    22.508     0.200
     1.416    26.869     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.009    32.110     0.200
     2.207    65.659     0.200
     2.679    74.147     0.200
     0.901    28.859     0.200
     1.581    46.805     0.200
     2.327    66.117     0.200
     1.073    32.891     0.200
     1.398    42.770     0.200
     1.666    49.793     0.200
     1.953    54.871     0.200
     2.161    62.930     0.200
     2.232    63.699     0.200
     2.413    68.102     0.200
     2.399    68.543     0.200
     2.486    70.922     0.200
     2.783    77.328     0.200
     2.718    76.816     0.200
     2.800    78.453     0.200
     2.857    79.648     0.200
     3.004    84.438     0.200
     3.081    86.852     0.200
     3.227    89.117     0.200
     3.328    91.711     0.200
     3.524    95.520     0.200
     3.497    97.059     0.200
     3.664   100.031     0.200
     3.683   101.004     0.200
     3.819   104.680     0.200
     3.866   104.645     0.200
     3.966   108.266     0.200
     4.209   113.254     0.200
     4.642   124.789     0.200
     4.712   127.434     0.200
     4.710   128.102     0.200
     4.743   128.941     0.200
     4.779   128.676     0.200
     5.246   140.871     0.200
     1.084    33.285     0.200
     1.392    42.707     0.200
     1.668    50.270     0.200
     1.961    55.816     0.200
     2.150    62.273     0.200
     2.416    68.215     0.200
     2.395    68.520     0.200
     2.575    73.336     0.200
     2.978    82.238     0.200
     2.996    83.301     0.200
     3.216    89.309     0.200
     3.327    91.777     0.200
     3.392    93.816     0.200
     3.489    96.523     0.200
     3.661    99.828     0.200
     3.651    99.367     0.200
     3.671    99.867     0.200
     3.810   104.688     0.200
     3.854   104.809     0.200
     3.892   105.473     0.200
     3.954   107.359     0.200
     4.211   112.848     0.200
     4.298   115.113     0.200
     4.319   115.496     0.200
     4.630   124.270     0.200
     4.706   126.902     0.200
     4.735   127.848     0.200
     4.926   131.516     0.200
     1.094    33.990     0.200
     1.094    35.260     0.200
     1.370    42.617     0.200
     1.646    50.406     0.200
     2.372    68.643     0.200
     2.779    78.748     0.200
     3.504    96.193     0.200
     3.657   101.184     0.200
     3.791   104.705     0.200
     3.670   101.512     0.200
     3.846   105.129     0.200
     1.067    34.000     0.200
     1.399    42.609     0.200
     1.280    39.320     0.200
     1.488    45.570     0.200
     2.143    63.039     0.200
     2.230    63.656     0.200
     2.625    72.945     0.200
     3.343    92.109     0.200
     3.750   103.414     0.200
     0.947    30.183     0.200
     1.783    51.933     0.200
     3.436    93.043     0.200
     4.166   108.603     0.200
     5.936   154.763     0.200
     9.819   252.637     0.200
     1.601    46.244     0.200
     2.534    72.633     0.200
     2.653    71.854     0.200
     2.694    72.225     0.200
     2.942    80.244     0.200
     3.077    83.033     0.200
     3.221    86.873     0.200
     3.662   103.023     0.200
     8.289   216.895     0.200
     2.922    76.453     0.200
     3.074    83.914     0.200
     3.080    87.281     0.200
     3.080    81.633     0.200
     3.183    88.602     0.200
     3.383    92.324     0.200
     3.640    98.754     0.200
     5.145   138.473     0.200
     5.174   142.191     0.200
     5.323   143.023     0.200
     6.379   168.684     0.200
     6.869   179.961     0.200
     7.120   187.922     0.200
     7.636   195.762     0.200
     8.787   222.133     0.200
     8.905   224.543     0.200
     1.287    37.484     0.200
     1.367    40.562     0.200
     1.367    38.930     0.200
     2.879    76.359     0.200
     3.050    86.477     0.200
     3.050    83.484     0.200
     2.959    78.258     0.200
     3.689   103.328     0.200
     4.071   112.883     0.200
     4.574   128.938     0.200
     4.710   131.789     0.200
     4.801   133.906     0.200
     4.818   135.312     0.200
     7.680   198.055     0.200
     9.024   230.281     0.200
     9.134   270.953     0.200
    14.490   371.477     0.200
    15.266   391.203     0.200
    17.253   432.930     0.200
    20.140   505.625     0.200
     1.465    42.852     0.200
     1.946    55.883     0.200
     2.960    81.098     0.200
     3.013    82.391     0.200
     3.621   100.215     0.200
     1.378    40.262     0.200
     2.960    80.333     0.200
     3.038    83.032     0.200
     3.451    90.252     0.200
     7.942   202.728     0.200
     9.127   233.557     0.200
     1.188    35.234     0.200
     2.844    77.004     0.200
     3.219    87.926     0.200
     3.605    97.395     0.200
     3.916   104.883     0.200
     4.061   107.246     0.200
     5.423   142.055     0.200
     9.260   237.480     0.200
     2.925    82.797     0.200
     3.133    86.844     0.200
     3.538    92.992     0.200
     5.342   144.625     0.200
     0.743    26.656     0.200
     1.216    37.488     0.200
     1.484    45.105     0.200
     2.081    59.730     0.200
     2.471    69.703     0.200
     2.598    73.938     0.200
     3.683    99.746     0.200
     9.668   246.922     0.200
     2.182    61.157     0.200
     2.334    65.697     0.200
     2.918    79.527     0.200
     3.012    81.337     0.200
     7.647   206.497     0.200
     7.820   214.307     0.200
     9.296   234.192     0.200
     2.171    60.143     0.200
     2.344    66.283     0.200
     2.936    81.463     0.200
     3.029    83.133     0.200
     3.134    81.133     0.200
     3.377    86.403     0.200
     3.880   102.798     0.200
     5.403   148.755     0.200
     6.034   167.243     0.200
     6.516   154.073     0.200
     7.632   207.103     0.200
     8.135   209.798     0.200
     9.273   234.828     0.200
    22.001   545.448     0.200
     1.716    48.559     0.200
     2.813    73.227     0.200
     0.626    21.633     0.200
     1.379    41.414     0.200
     1.601    47.465     0.200
     2.000    57.094     0.200
     2.192    60.664     0.200
     2.346    65.715     0.200
     3.129    86.723     0.200
     0.796    27.781     0.200
     1.052    32.851     0.200
     1.403    42.281     0.200
     0.345    13.355     0.200
     3.058    83.226     0.200
     0.735    24.795     0.200
     1.669    47.395     0.200
     2.068    57.686     0.200
     2.218    60.234     0.200
     2.309    63.686     0.200
     3.751   100.676     0.200
     0.314    11.926     0.200
     1.395    38.625     0.200
     1.395    41.836     0.200
     1.474    43.516     0.200
     1.316    36.984     0.200
     2.421    64.586     0.200
     3.008    78.785     0.200
     3.081    87.367     0.200
     3.301    92.035     0.200
     1.549    44.227     0.200
     1.699    49.289     0.200
     2.519    71.797     0.200
     4.029   110.633     0.200
     5.378   139.242     0.200
     0.591    21.039     0.200
     0.591    21.453     0.200
     1.061    31.227     0.200
     1.518    44.023     0.200
     1.595    45.555     0.200
     1.729    49.297     0.200
     2.505    65.867     0.200
     2.625    74.578     0.200
     3.198    86.734     0.200
     3.484    92.609     0.200
     4.081   107.094     0.200
     4.284   115.828     0.200
     5.426   141.055     0.200
     2.604    75.508     0.200
     4.023   110.352     0.200
     5.676   148.977     0.200
     0.866    27.063     0.200
     0.995    29.383     0.200
     1.177    34.053     0.200
     1.089    33.193     0.200
     1.588    46.253     0.200
     2.601    71.263     0.200
     1.112    33.628     0.200
     1.338    40.108     0.200
     1.453    41.588     0.200
     1.533    45.608     0.200
     2.873    76.068     0.200
     3.159    86.138     0.200
     3.262    91.748     0.200
     3.597    97.118     0.200
     3.723   101.208     0.200
     5.086   135.798     0.200
     5.619   146.198     0.200
     7.395   189.448     0.200
     7.976   198.688     0.200
     0.632    21.093     0.200
     0.632    23.213     0.200
     0.807    27.093     0.200
     4.220   113.662     0.200
     5.717   148.223     0.200
     6.857   175.742     0.200
     0.826    27.523     0.200
     0.612    22.198     0.200
     0.773    25.408     0.200
     1.546    45.048     0.200
     2.180    62.198     0.200
     1.038    33.016     0.200
     1.135    35.074     0.200
     0.585    19.980     0.200
     0.585    20.668     0.200
     0.673    21.809     0.200
     0.673    22.891     0.200
     2.335    64.598     0.200
     3.183    86.828     0.200
     1.103    32.422     0.200
     1.226    37.242     0.200
     1.554    45.891     0.200
     6.908   183.293     0.200
     3.260    89.926     0.200
     3.490    95.398     0.200
     3.911   110.738     0.200
     4.046   107.672     0.200
     8.167   207.953     0.200
     0.449    16.395     0.200
     1.202    34.824     0.200
     1.464    42.223     0.200
     3.939   103.961     0.200
     1.078    32.316     0.200
     2.774    78.607     0.200
     2.855    77.678     0.200
     7.535   194.357     0.200
     3.225    87.648     0.200
     3.225    87.195     0.200
     3.279    90.047     0.200
     3.519    94.516     0.200
     5.316   140.984     0.200
     6.351   169.336     0.200
     7.559   195.234     0.200
     7.723   198.469     0.200
     7.723   202.000     0.200
     7.992   209.180     0.200
     8.242   216.977     0.200
     8.312   220.094     0.200
     8.515   224.117     0.200
     8.830   227.289     0.200
     9.052   234.586     0.200
     9.170   233.969     0.200
    10.150   265.914     0.200
    11.389   297.750     0.200
    12.347   315.797     0.200
    12.992   330.469     0.200
    13.213   336.156     0.200
    13.645   345.680     0.200
    14.198   358.508     0.200
     0.939    32.332     0.200
     0.954    32.500     0.200
     1.401    42.293     0.200
     2.080    60.512     0.200
     3.931   102.000     0.200
     4.388   115.230     0.200
     7.568   193.832     0.200
     7.778   209.203     0.200
     0.941    28.590     0.200
     1.670    47.590     0.200
     2.015    57.602     0.200
     2.074    58.199     0.200
     4.392   117.520     0.200
     0.941    28.180     0.200
     1.491    43.199     0.200
     1.690    47.459     0.200
     3.245    91.416     0.200
     3.341    93.566     0.200
     3.490    93.775     0.200
     4.022   104.266     0.200
     8.245   213.574     0.200
     1.579    45.883     0.200
     0.676    23.305     0.200
     0.752    25.574     0.200
     1.235    37.805     0.200
     1.515    43.627     0.200
     2.983    82.826     0.200
     3.137    85.797     0.200
     3.295    92.678     0.200
     3.538    94.688     0.200
     3.936   105.996     0.200
     5.299   138.797     0.200
     6.053   159.086     0.200
     0.718    23.072     0.200
     0.794    26.002     0.200
     0.975    30.574     0.200
     0.997    31.844     0.200
     2.651    72.355     0.200
     3.280    87.324     0.200
     4.037   109.684     0.200
     4.114   114.676     0.200
     1.013    31.805     0.200
     2.688    76.664     0.200
     3.420    93.258     0.200
     4.019   110.945     0.200
     9.234   238.016     0.200
     0.466    16.888     0.200
     0.935    28.308     0.200
     3.270    81.397     0.200
     4.491   114.117     0.200
     8.432   211.647     0.200
     8.964   220.527     0.200
     9.089   227.048     0.200
     9.458   237.708     0.200
    11.975   296.197     0.200
    13.868   343.558     0.200
    15.575   384.848     0.200
    15.596   385.367     0.200
    15.610   385.958     0.200
    15.855   392.157     0.200
     0.503    18.312     0.200
     0.861    26.664     0.200
     0.949    29.373     0.200
     1.044    31.363     0.200
     1.882    54.533     0.200
     1.929    53.963     0.200
     2.921    76.039     0.200
     3.260    90.039     0.200
     3.792   104.000     0.200
     4.024   102.133     0.200
     0.537    20.250     0.200
     0.811    27.953     0.200
     1.364    40.648     0.200
     1.579    46.383     0.200
     0.459    17.238     0.200
     1.919    56.430     0.200
     2.665    74.000     0.200
     3.209    91.290     0.200
     8.181   211.582     0.200
     8.923   229.390     0.200
     0.452    17.035     0.200
     1.757    49.234     0.200
     1.783    51.504     0.200
     2.771    74.922     0.200
     3.289    88.902     0.200
     3.398    89.422     0.200
     3.539    95.285     0.200
     3.878   104.262     0.200
     5.160   134.562     0.200
     5.823   148.465     0.200
     1.164    33.485     0.200
     1.687    48.786     0.200
     3.218    90.155     0.200
     1.109    31.545     0.200
     1.749    50.395     0.200
     1.775    50.426     0.200
     2.779    74.836     0.200
     3.371    89.775     0.200
     3.406    94.445     0.200
     5.831   147.576     0.200
     0.560    19.938     0.200
     0.560    18.768     0.200
     0.645    21.527     0.200
     0.645    22.418     0.200
     1.593    45.328     0.200
     2.174    58.648     0.200
     1.783    51.937     0.200
     1.783    50.997     0.200
     4.225   117.836     0.200
     9.058   233.617     0.200
     1.686    50.256     0.200
     1.721    49.606     0.200
     3.230    89.336     0.200
     0.739    26.176     0.200
     0.739    26.744     0.200
     1.026    32.285     0.200
     0.706    23.484     0.200
     1.066    31.891     0.200
     0.704    24.020     0.200
     0.704    24.211     0.200
     1.157    35.520     0.200
     1.500    43.090     0.200
     2.627    74.410     0.200
     0.733    24.434     0.200
     1.094    33.273     0.200
     1.205    37.074     0.200
     1.526    45.555     0.200
     1.526    45.297     0.200
     1.579    46.773     0.200
     2.039    58.426     0.200
     2.769    72.184     0.200
     9.162   236.398     0.200
     1.228    37.996     0.200
     1.480    44.166     0.200
     2.205    64.035     0.200
     2.269    64.996     0.200
     3.730   103.855     0.200
     4.231   116.496     0.200
     1.940    54.698     0.200
     2.015    55.318     0.200
     2.560    69.858     0.200
     3.570    94.288     0.200
     3.680   101.508     0.200
     2.014    55.966     0.200
     3.155    89.896     0.200
     3.581    91.796     0.200
     3.689   102.096     0.200
     3.690    98.236     0.200
     5.043   128.606     0.200
     0.550    19.406     0.200
     0.905    27.188     0.200
     1.898    55.070     0.200
     1.971    55.641     0.200
     3.503    94.164     0.200
     0.854    28.824     0.200
     2.026    56.582     0.200
     2.013    56.613     0.200
     2.549    74.062     0.200
     2.549    71.531     0.200
     2.788    79.621     0.200
     3.138    88.633     0.200
     3.670   102.152     0.200
     3.669   101.484     0.200
     3.952   110.281     0.200
     8.020   206.816     0.200
     0.847    28.402     0.200
     0.929    31.883     0.200
     1.947    56.215     0.200
     1.947    55.793     0.200
     2.026    56.375     0.200
     2.004    59.535     0.200
     2.560    73.824     0.200
     2.560    71.266     0.200
     3.585    94.516     0.200
     3.554    97.895     0.200
     3.686   102.883     0.200
     3.686   100.742     0.200
     3.681   100.793     0.200
     5.039   130.055     0.200
     1.971    52.645     0.200
     2.593    66.863     0.200
     3.717    96.055     0.200
     1.975    55.956     0.200
     3.195    86.726     0.200
     3.582    94.806     0.200
     3.723   103.976     0.200
     0.540    18.832     0.200
     2.850    79.691     0.200
     2.836    77.500     0.200
     3.564    99.020     0.200
     3.720   103.480     0.200
     5.058   137.922     0.200
     2.622    74.641     0.200
     3.208    84.953     0.200
     3.603    98.832     0.200
     3.743   101.941     0.200
     3.736   101.301     0.200
     5.090   139.172     0.200
     8.058   207.883     0.200
     1.946    53.805     0.200
     1.966    55.508     0.200
     2.590    74.297     0.200
     2.590    68.719     0.200
     3.202    88.195     0.200
     3.518    96.969     0.200
     3.671   102.469     0.200
     3.704   100.039     0.200
     5.027   131.805     0.200
     0.924    28.547     0.200
     1.420    42.391     0.200
     1.485    43.859     0.200
     1.726    49.938     0.200
     1.880    53.766     0.200
     1.952    53.719     0.200
     1.953    55.844     0.200
     3.207    89.594     0.200
     3.484    94.250     0.200
     3.551    96.648     0.200
     3.722   102.516     0.200
     8.007   210.414     0.200
     8.821   224.273     0.200
     1.901    56.094     0.200
     1.968    56.719     0.200
     1.975    56.914     0.200
     3.506    97.977     0.200
     0.854    29.320     0.200
     0.854    28.336     0.200
     1.547    46.508     0.200
     1.784    52.781     0.200
     2.011    58.352     0.200
     2.551    72.328     0.200
     3.140    88.789     0.200
     3.571   100.047     0.200
     3.673   100.758     0.200
     3.260    89.143     0.200
     3.424    96.573     0.200
     3.514    94.883     0.200
     3.744   101.863     0.200
     0.876    29.086     0.200
     0.901    30.469     0.200
     0.901    30.961     0.200
     2.534    71.141     0.200
     3.144    87.977     0.200
     3.144    85.391     0.200
     3.509    97.320     0.200
     3.650   101.000     0.200
     0.900    30.307     0.200
     1.953    55.406     0.200
     1.983    58.045     0.200
     3.189    90.295     0.200
     3.685   102.977     0.200
     0.555    19.312     0.200
     1.949    54.922     0.200
     2.597    67.789     0.200
     3.205    89.922     0.200
     3.685   101.562     0.200
     3.685   100.422     0.200
     3.712   102.609     0.200
     0.529    19.738     0.200
     1.926    56.406     0.200
     2.625    73.648     0.200
     2.625    72.188     0.200
     3.232    89.340     0.200
     3.459    96.387     0.200
     3.546    94.027     0.200
     3.550    99.406     0.200
     3.709   101.359     0.200
     3.740   104.379     0.200
     1.901    54.566     0.200
     1.958    54.506     0.200
     3.185    86.566     0.200
     3.499    96.025     0.200
     3.500    96.377     0.200
     3.590    94.826     0.200
     3.647   101.057     0.200
     3.681   101.477     0.200
     1.434    42.707     0.200
     1.897    53.248     0.200
     1.974    54.428     0.200
     2.598    74.627     0.200
     3.192    86.988     0.200
     3.503    91.268     0.200
     3.704   103.678     0.200
     3.717   103.418     0.200
     1.892    55.177     0.200
     1.948    54.797     0.200
     2.576    73.887     0.200
     3.195    89.287     0.200
     3.490    94.847     0.200
     3.653   102.497     0.200
     5.009   136.467     0.200
     1.924    53.830     0.200
     1.990    55.801     0.200
     2.560    72.930     0.200
     2.560    72.180     0.200
     2.827    79.920     0.200
     2.827    77.000     0.200
     3.163    86.850     0.200
     3.163    86.340     0.200
     3.526    97.830     0.200
     3.660   101.061     0.200
     3.677   100.240     0.200
     3.977   109.740     0.200
     5.015   135.061     0.200
     7.988   202.645     0.200
     1.938    52.395     0.200
     2.010    53.727     0.200
     2.804    76.355     0.200
     2.880    74.938     0.200
     3.150    85.305     0.200
     3.150    84.816     0.200
     3.557    98.938     0.200
     3.669   100.555     0.200
     3.675    98.547     0.200
     7.664   199.035     0.200
     8.009   207.328     0.200
     1.905    54.650     0.200
     3.699   103.371     0.200
     1.946    53.652     0.200
     2.580    73.320     0.200
     3.197    87.980     0.200
     3.693   102.641     0.200
     4.010   111.730     0.200
     0.927    30.281     0.200
     1.391    42.562     0.200
     1.452    43.113     0.200
     1.692    50.141     0.200
     1.874    54.551     0.200
     1.874    53.602     0.200
     1.935    53.273     0.200
     2.598    75.582     0.200
     2.598    72.223     0.200
     2.882    82.934     0.200
     2.882    82.652     0.200
     3.212    84.594     0.200
     3.517    99.242     0.200
     3.676    99.594     0.200
     3.712   103.633     0.200
     4.399   120.621     0.200
     1.863    53.915     0.200
     1.914    53.435     0.200
     2.597    70.765     0.200
     3.480    96.136     0.200
     3.548    95.485     0.200
     5.014   130.896     0.200
     0.895    29.201     0.200
     1.890    55.031     0.200
     1.942    54.902     0.200
     2.574    71.383     0.200
     2.880    79.512     0.200
     3.197    87.912     0.200
     3.485    97.182     0.200
     3.576    98.133     0.200
     3.686   103.723     0.200
     4.010   112.812     0.200
     0.475    17.444     0.200
     0.474    17.454     0.200
     0.543    17.954     0.200
     0.717    22.904     0.200
     1.590    45.664     0.200
     2.099    58.255     0.200
     2.096    57.265     0.200
     0.734    25.945     0.200
     0.727    23.925     0.200
     0.830    26.725     0.200
     1.165    35.445     0.200
     1.727    49.965     0.200
     3.184    86.855     0.200
     1.900    54.531     0.200
     1.954    54.742     0.200
     2.567    71.441     0.200
     2.867    79.672     0.200
     2.867    76.861     0.200
     3.186    87.152     0.200
     3.493    96.541     0.200
     3.680   102.852     0.200
     3.841   105.992     0.200
     4.827   130.262     0.200
     0.984    28.406     0.200
     1.914    54.383     0.200
     1.956    55.883     0.200
     3.224    89.586     0.200
     3.708   103.793     0.200
     0.567    19.559     0.200
     1.899    54.129     0.200
     2.614    72.319     0.200
     3.240    91.259     0.200
     3.487    91.208     0.200
     3.671   100.269     0.200
     3.723   103.449     0.200
     1.494    43.690     0.200
     1.920    55.201     0.200
     1.985    55.561     0.200
     1.995    58.521     0.200
     1.995    57.650     0.200
     2.563    74.381     0.200
     2.832    78.161     0.200
     3.167    89.931     0.200
     3.167    88.471     0.200
     3.530    93.371     0.200
     3.660   103.351     0.200
     3.809   107.730     0.200
     4.349   118.980     0.200
     1.530    44.201     0.200
     1.941    56.051     0.200
     1.941    54.811     0.200
     2.007    57.762     0.200
     2.007    54.941     0.200
     2.013    54.152     0.200
     2.554    71.791     0.200
     3.148    88.172     0.200
     3.558    97.361     0.200
     3.558    95.121     0.200
     3.637    94.662     0.200
     3.668    99.391     0.200
     3.673   100.721     0.200
     4.450   120.615     0.200
     8.782   224.498     0.200
     1.470    43.855     0.200
     1.707    50.023     0.200
     1.906    55.855     0.200
     1.906    54.477     0.200
     1.966    54.035     0.200
     1.987    56.305     0.200
     2.569    72.625     0.200
     3.181    90.816     0.200
     3.181    88.477     0.200
     3.655   100.203     0.200
     3.655    97.734     0.200
     3.683   102.664     0.200
     3.829   106.016     0.200
     3.994   110.766     0.200
     4.370   118.656     0.200
     4.814   130.215     0.200
     5.010   132.336     0.200
     5.608   150.676     0.200
     5.616   147.523     0.200
     1.888    54.504     0.200
     1.939    53.672     0.200
     1.981    57.414     0.200
     3.198    86.684     0.200
     3.198    88.234     0.200
     3.642   100.531     0.200
     3.685    98.812     0.200
     4.011   110.281     0.200
     4.843   129.582     0.200
     0.847    27.562     0.200
     1.590    47.305     0.200
     1.835    53.633     0.200
     1.893    55.762     0.200
     1.928    56.922     0.200
     3.207    85.984     0.200
     3.670    98.633     0.200
     3.785   104.832     0.200
     3.769   106.633     0.200
     0.859    28.168     0.200
     0.859    28.898     0.200
     3.194    90.520     0.200
     3.632    98.809     0.200
     3.749   104.301     0.200
     3.742   105.508     0.200
     3.795   104.891     0.200
     0.822    27.477     0.200
     1.622    47.672     0.200
     2.648    68.922     0.200
     3.200    90.453     0.200
     3.200    89.375     0.200
     3.700    96.016     0.200
     3.775   104.742     0.200
     3.802   105.867     0.200
     3.802   105.422     0.200
     4.750   127.523     0.200
     5.153   132.586     0.200
     1.900    54.406     0.200
     1.959    54.156     0.200
     1.983    57.076     0.200
     2.573    69.197     0.200
     2.860    81.027     0.200
     3.186    87.098     0.200
     3.509    93.637     0.200
     3.656    92.727     0.200
     3.687   100.377     0.200
     5.012   131.088     0.200
     0.571    19.477     0.200
     1.926    54.422     0.200
     1.993    55.562     0.200
     1.998    53.961     0.200
     2.567    70.547     0.200
     2.868    75.742     0.200
     3.163    84.281     0.200
     3.557    94.664     0.200
     3.677    97.477     0.200
     3.686   101.531     0.200
     5.031   130.477     0.200
     5.595   144.844     0.200
     5.919   156.133     0.200
     0.947    29.969     0.200
     1.700    48.750     0.200
     1.861    55.172     0.200
     1.861    55.391     0.200
     1.928    55.531     0.200
     1.940    56.672     0.200
     1.940    57.070     0.200
     2.616    74.984     0.200
     3.226    89.125     0.200
     3.463    93.289     0.200
     3.535    95.805     0.200
     3.554    98.109     0.200
     3.698   100.320     0.200
     4.039   114.352     0.200
     4.404   121.273     0.200
     4.847   132.430     0.200
     5.985   155.891     0.200
     1.900    53.609     0.200
     1.958    54.049     0.200
     1.984    54.419     0.200
     3.186    86.549     0.200
     3.499    94.639     0.200
     3.506    94.029     0.200
     3.685    99.979     0.200
     1.162    35.197     0.200
     2.572    74.979     0.200
     3.033    87.568     0.200
     3.033    81.639     0.200
     3.266    91.258     0.200
     3.266    90.648     0.200
     3.406    98.018     0.200
     3.533   101.168     0.200
     3.660   104.438     0.200
     4.075   115.688     0.200
     4.991   136.008     0.200
     4.894   136.348     0.200
     5.663   151.168     0.200
     1.880    55.744     0.200
     1.880    54.125     0.200
     1.955    57.865     0.200
     1.955    56.664     0.200
     1.948    54.564     0.200
     2.602    75.555     0.200
     2.602    71.354     0.200
     3.208    87.895     0.200
     3.208    86.145     0.200
     3.483    94.734     0.200
     3.542    92.055     0.200
     7.998   209.023     0.200
     1.916    53.859     0.200
     1.943    54.320     0.200
     2.782    75.590     0.200
     2.902    82.000     0.200
     3.230    89.650     0.200
     3.230    88.420     0.200
     3.455    92.561     0.200
     3.510    94.789     0.200
     3.725   102.230     0.200
     1.943    56.459     0.200
     2.601    68.920     0.200
     2.872    78.850     0.200
     3.210    85.109     0.200
     3.479    95.590     0.200
     3.532    97.250     0.200
     3.686    95.818     0.200
     3.716   104.119     0.200
     5.042   134.189     0.200
     5.639   142.859     0.200
     7.989   209.789     0.200
     1.920    54.680     0.200
     1.993    56.148     0.200
     2.565    71.301     0.200
     3.523    92.969     0.200
     3.539    94.848     0.200
     3.614   100.809     0.200
     0.923    30.305     0.200
     1.502    45.113     0.200
     1.740    52.094     0.200
     1.982    58.535     0.200
     1.982    57.223     0.200
     3.693   103.355     0.200
     4.418   125.973     0.200
     0.914    28.773     0.200
     1.482    44.102     0.200
     1.921    53.852     0.200
     2.001    58.773     0.200
     2.001    56.961     0.200
     2.555    70.680     0.200
     2.846    79.930     0.200
     2.838    81.500     0.200
     3.165    90.109     0.200
     3.521    98.391     0.200
     3.514    93.180     0.200
     3.611    95.602     0.200
     3.647   101.617     0.200
     3.671   101.828     0.200
     3.979   112.383     0.200
     4.416   115.883     0.200
     7.968   204.406     0.200
     0.925    30.273     0.200
     0.911    31.273     0.200
     0.911    30.992     0.200
     1.492    45.039     0.200
     1.731    51.539     0.200
     1.903    56.758     0.200
     1.971    55.961     0.200
     1.976    57.992     0.200
     1.976    58.141     0.200
     2.582    71.938     0.200
     2.844    80.000     0.200
     3.185    90.859     0.200
     3.506    98.797     0.200
     3.542    95.969     0.200
     3.597   100.938     0.200
     1.096    33.316     0.200
     1.300    39.648     0.200
     1.712    51.156     0.200
     1.977    58.355     0.200
     1.998    58.457     0.200
     2.155    61.719     0.200
     3.504    97.746     0.200
     1.868    54.410     0.200
     1.924    54.320     0.200
     1.958    57.371     0.200
     2.895    79.820     0.200
     3.218    87.742     0.200
     3.466    95.223     0.200
     3.497    95.473     0.200
     3.665   100.801     0.200
     3.708   103.891     0.200
     5.022   132.852     0.200
     5.643   154.262     0.200
     0.631    23.041     0.200
     0.890    28.651     0.200
     3.267    92.001     0.200
     3.390    91.041     0.200
     3.617    98.571     0.200
     3.617    98.411     0.200
     3.707   101.021     0.200
     4.977   133.411     0.200
     2.005    56.223     0.200
     2.016    54.752     0.200
     2.798    77.973     0.200
     3.547    97.682     0.200
     3.677   101.592     0.200
     3.639    98.451     0.200
     0.908    29.316     0.200
     1.496    45.178     0.200
     1.985    55.066     0.200
     1.994    57.617     0.200
     2.564    69.998     0.200
     2.831    80.777     0.200
     3.522   100.447     0.200
     3.612   102.396     0.200
     3.681   101.518     0.200
     0.515    17.750     0.200
     1.951    56.188     0.200
     1.987    55.234     0.200
     3.194    88.547     0.200
     3.508    97.391     0.200
     3.614    97.734     0.200
     3.736   102.352     0.200
     5.090   137.234     0.200
     1.780    51.211     0.200
     1.916    54.445     0.200
     1.974    56.641     0.200
     1.998    55.125     0.200
     2.589    70.953     0.200
     3.175    86.703     0.200
     3.524    96.180     0.200
     3.590    99.133     0.200
     3.708   101.836     0.200
     5.061   137.195     0.200
     1.743    49.539     0.200
     2.597    73.281     0.200
     2.845    80.445     0.200
     3.499    99.383     0.200
     3.562   100.297     0.200
     3.698   102.617     0.200
     5.053   134.398     0.200
     5.626   150.289     0.200
     0.516    18.039     0.200
     1.460    42.148     0.200
     1.524    44.016     0.200
     1.766    50.516     0.200
     1.968    54.508     0.200
     2.619    69.047     0.200
     2.843    75.664     0.200
     3.207    87.227     0.200
     3.493    96.906     0.200
     3.595    98.797     0.200
     3.730   100.141     0.200
     5.084   134.328     0.200
     5.642   145.016     0.200
     0.966    28.467     0.200
     1.928    54.607     0.200
     2.627    72.477     0.200
     3.240    92.427     0.200
     3.448    97.727     0.200
     0.540    18.776     0.200
     1.964    53.986     0.200
     3.716   100.776     0.200
     4.419   117.025     0.200
     0.908    30.352     0.200
     0.908    30.891     0.200
     0.910    29.990     0.200
     1.915    55.400     0.200
     1.980    56.301     0.200
     1.990    57.461     0.200
     2.567    69.221     0.200
     2.836    78.121     0.200
     3.684   100.201     0.200
     0.563    19.195     0.200
     1.512    44.246     0.200
     1.915    55.535     0.200
     1.983    57.648     0.200
     1.983    56.668     0.200
     2.577    72.527     0.200
     2.827    75.727     0.200
     3.519    97.285     0.200
     3.557    98.738     0.200
     3.683   102.926     0.200
     3.695   100.297     0.200
     5.037   139.707     0.200
     0.858    27.785     0.200
     0.858    28.086     0.200
     1.794    52.707     0.200
     1.935    54.668     0.200
     1.993    55.828     0.200
     2.015    56.145     0.200
     2.570    72.656     0.200
     2.798    80.316     0.200
     3.156    85.965     0.200
     3.542    96.848     0.200
     3.585   100.008     0.200
     3.634    95.438     0.200
     3.693   103.988     0.200
     3.691    99.738     0.200
     5.046   134.117     0.200
     5.591   154.527     0.200
     5.908   162.035     0.200
     7.677   200.605     0.200
     8.038   210.359     0.200
     0.926    30.082     0.200
     2.889    81.441     0.200
     3.150    87.832     0.200
     3.575    90.973     0.200
     3.546   100.980     0.200
     3.683   105.172     0.200
     1.917    54.285     0.200
     1.981    54.312     0.200
     1.992    54.375     0.200
     2.579    70.805     0.200
     3.172    83.453     0.200
     3.522    96.812     0.200
     3.567    94.434     0.200
     3.690    98.824     0.200
     5.044   137.305     0.200
     1.930    54.027     0.200
     2.602    71.176     0.200
     3.218    87.816     0.200
     3.469    94.668     0.200
     3.515    94.289     0.200
     5.035   135.508     0.200
     1.422    42.867     0.200
     1.942    54.828     0.200
     2.018    55.125     0.200
     2.004    57.539     0.200
     2.558    69.391     0.200
     3.147    86.531     0.200
     3.571   100.320     0.200
     3.548    94.062     0.200
     3.678    99.250     0.200
     5.031   135.195     0.200
     0.881    25.548     0.200
     1.923    54.838     0.200
     1.997    54.488     0.200
     1.989    56.768     0.200
     1.989    57.078     0.200
     2.572    67.448     0.200
     3.563    95.758     0.200
     3.683    92.778     0.200
     3.691   102.588     0.200
     5.037   130.368     0.200
     0.647    23.336     0.200
     1.404    41.406     0.200
     1.637    48.164     0.200
     1.911    55.344     0.200
     1.911    55.141     0.200
     2.017    58.477     0.200
     3.501    94.695     0.200
     7.884   209.367     0.200
     8.725   226.086     0.200
     0.633    21.188     0.200
     1.061    31.648     0.200
     2.592    69.718     0.200
     3.246    86.118     0.200
     3.398    92.708     0.200
     3.428    93.898     0.200
     3.516    95.438     0.200
     0.928    30.809     0.200
     1.758    51.828     0.200
     1.805    52.180     0.200
     1.920    56.699     0.200
     1.920    56.891     0.200
     1.986    58.309     0.200
     3.169    87.910     0.200
     3.525    99.469     0.200
     1.643    47.125     0.200
     3.486    97.383     0.200
     1.908    55.719     0.200
     1.816    52.910     0.200
     1.977    55.992     0.200
     1.979    55.969     0.200
     2.581    74.000     0.200
     3.512    95.469     0.200
     1.896    54.211     0.200
     1.968    56.266     0.200
     1.967    54.172     0.200
     3.549    90.125     0.200
     3.707   101.883     0.200
     8.004   207.297     0.200
     1.949    57.043     0.200
     1.949    54.573     0.200
     2.003    58.323     0.200
     2.003    54.503     0.200
     3.685   102.843     0.200
     0.932    28.711     0.200
     1.888    54.641     0.200
     1.952    54.883     0.200
     2.591    72.250     0.200
     3.199    85.691     0.200
     3.489    97.602     0.200
     3.529    95.453     0.200
     3.678    99.312     0.200
     3.706   102.520     0.200
     5.034   132.590     0.200
     7.985   209.477     0.200
     8.802   226.805     0.200
     1.917    54.920     0.200
     1.987    54.449     0.200
     1.987    57.139     0.200
     2.572    70.578     0.200
     2.856    75.158     0.200
     2.856    78.709     0.200
     3.171    86.318     0.200
     3.549    90.539     0.200
     3.611    97.520     0.200
     3.676    99.260     0.200
     3.690   100.350     0.200
     5.031   130.959     0.200
     5.603   153.809     0.200
     5.928   158.180     0.200
     7.707   199.078     0.200
     8.003   208.084     0.200
    10.929   276.109     0.200
    12.070   310.789     0.200
    12.243   305.609     0.200
    12.875   325.328     0.200
    13.606   348.670     0.200
    14.686   374.859     0.200
    14.692   370.510     0.200
     1.935    53.830     0.200
     2.010    54.381     0.200
     1.997    57.160     0.200
     2.564    70.109     0.200
     3.155    87.801     0.200
     3.570    95.770     0.200
     3.682    96.180     0.200
     3.685   101.369     0.200
     5.589   140.949     0.200
     7.672   198.430     0.200
     8.023   208.273     0.200
     1.946    55.488     0.200
     2.004    55.277     0.200
     2.025    55.488     0.200
     2.560    70.926     0.200
     3.145    87.105     0.200
     3.583    95.738     0.200
     3.685   102.668     0.200
     5.038   132.715     0.200
     5.580   146.586     0.200
     0.895    30.078     0.200
     0.915    30.338     0.200
     1.921    55.289     0.200
     1.990    57.549     0.200
     1.992    57.459     0.200
     2.567    74.527     0.200
     2.826    77.488     0.200
     3.167    86.229     0.200
     3.524    98.219     0.200
     3.544    95.898     0.200
     3.670   103.988     0.200
     3.981   113.357     0.200
     5.024   136.527     0.200
     5.598   150.068     0.200
     7.998   209.297     0.200
     0.595    20.388     0.200
     2.683    72.668     0.200
     3.347    93.948     0.200
     3.347    88.718     0.200
     3.397    94.087     0.200
     3.414    92.978     0.200
     3.669    97.548     0.200
     3.779   104.138     0.200
     1.762    49.134     0.200
     1.792    50.554     0.200
     1.888    52.804     0.200
     3.347    89.914     0.200
     3.435    90.274     0.200
     3.328    92.554     0.200
     3.328    88.034     0.200
     3.770   103.054     0.200
     1.447    42.805     0.200
     1.685    49.461     0.200
     1.884    55.039     0.200
     1.884    54.609     0.200
     1.941    54.898     0.200
     1.970    57.977     0.200
     2.585    69.719     0.200
     2.805    74.805     0.200
     2.878    82.477     0.200
     3.202    88.164     0.200
     3.202    85.938     0.200
     3.482    95.055     0.200
     3.502    90.406     0.200
     3.572    98.250     0.200
     3.660   102.859     0.200
     3.660    95.797     0.200
     3.698   103.227     0.200
     4.016   112.500     0.200
     4.395   119.508     0.200
     5.017   132.109     0.200
     7.959   204.477     0.200
     8.845   232.328     0.200
     0.581    20.336     0.200
     1.940    51.523     0.200
     1.972    56.250     0.200
     2.583    73.453     0.200
     3.202    88.992     0.200
     3.482    89.469     0.200
     3.572    94.273     0.200
     3.656    96.094     0.200
     0.890    26.656     0.200
     1.511    43.008     0.200
     1.749    50.305     0.200
     1.993    57.367     0.200
     2.567    73.242     0.200
     3.165    89.195     0.200
     0.566    19.186     0.200
     1.489    43.525     0.200
     1.728    50.156     0.200
     1.903    53.826     0.200
     1.970    54.756     0.200
     1.977    55.346     0.200
     2.581    67.285     0.200
     3.185    88.516     0.200
     3.538    99.045     0.200
     5.031   133.785     0.200
     5.615   145.945     0.200
     1.882    54.668     0.200
     1.960    55.699     0.200
     2.596    72.457     0.200
     3.205    90.238     0.200
     3.484    96.777     0.200
     3.532    98.637     0.200
     3.683   102.199     0.200
     3.683    95.699     0.200
     3.711   103.406     0.200
     5.039   135.520     0.200
     5.634   149.488     0.200
     0.945    29.410     0.200
     1.879    53.242     0.200
     1.949    57.082     0.200
     1.952    56.570     0.200
     3.209    91.801     0.200
     3.573    95.570     0.200
     3.698   102.871     0.200
     3.698    98.801     0.200
     3.722   104.082     0.200
     8.005   209.652     0.200
     0.824    27.367     0.200
     1.929    55.414     0.200
     2.016    56.969     0.200
     2.650    72.852     0.200
     2.793    76.758     0.200
     3.202    89.391     0.200
     3.614    95.914     0.200
     3.777   104.773     0.200
     0.571    20.031     0.200
     1.929    54.117     0.200
     2.003    54.836     0.200
     1.995    53.180     0.200
     2.565    70.969     0.200
     3.561    94.820     0.200
     3.534    94.195     0.200
     5.592   150.586     0.200
     1.559    44.139     0.200
     1.799    50.849     0.200
     1.925    54.079     0.200
     2.011    55.979     0.200
     2.588    69.269     0.200
     2.800    76.739     0.200
     3.168    89.099     0.200
     3.168    86.059     0.200
     3.534    99.099     0.200
     3.626    97.749     0.200
     3.606   101.409     0.200
     3.710   103.529     0.200
     3.715   100.959     0.200
     1.933    55.044     0.200
     1.991    57.024     0.200
     1.991    57.144     0.200
     2.012    54.704     0.200
     2.571    70.494     0.200
     2.801    78.344     0.200
     3.158    87.474     0.200
     3.540    97.374     0.200
     3.631    99.794     0.200
     1.964    56.255     0.200
     2.011    58.895     0.200
     2.862    77.575     0.200
     3.169    88.685     0.200
     3.511    97.595     0.200
     3.466    94.705     0.200
     3.614    98.024     0.200
     4.971   127.354     0.200
     5.592   147.735     0.200
     7.655   201.235     0.200
     8.808   231.795     0.200
     1.900    54.602     0.200
     1.900    53.831     0.200
     1.972    53.911     0.200
     2.590    70.421     0.200
     2.842    75.191     0.200
     3.189    85.312     0.200
     3.504    95.801     0.200
     3.556    94.831     0.200
     3.595    95.062     0.200
     1.107    34.829     0.200
     1.550    46.799     0.200
     2.882    83.648     0.200
     3.136    83.509     0.200
     3.912   111.648     0.200
     4.190   116.858     0.200
     0.627    21.754     0.200
     0.975    29.824     0.200
     1.312    39.605     0.200
     3.349    93.414     0.200
     3.805   105.133     0.200
     1.753    51.064     0.200
     1.752    51.234     0.200
     1.908    56.266     0.200
     1.908    55.596     0.200
     3.322    90.395     0.200
     3.325    94.895     0.200
     3.408    94.805     0.200
     3.349    91.885     0.200
     3.752   103.824     0.200
     4.980   127.635     0.200
     0.694    24.453     0.200
     1.762    51.574     0.200
     1.771    52.133     0.200
     1.934    56.414     0.200
     1.953    55.625     0.200
     2.594    70.812     0.200
     2.612    71.844     0.200
     3.336    91.805     0.200
     3.293    93.133     0.200
     3.336    91.805     0.200
     3.728   105.715     0.200
     4.950   130.195     0.200
     7.752   206.605     0.200
     0.654    22.230     0.200
     1.741    49.930     0.200
     1.896    54.539     0.200
     1.896    52.609     0.200
     3.310    91.730     0.200
     3.329    91.730     0.200
     3.362    93.062     0.200
     3.629   101.082     0.200
     4.991   129.312     0.200
     0.616    21.484     0.200
     1.371    40.969     0.200
     1.608    47.312     0.200
     1.860    54.094     0.200
     1.897    53.281     0.200
     1.970    56.453     0.200
     1.025    31.928     0.200
     2.648    71.709     0.200
     3.291    84.328     0.200
     3.278    92.229     0.200
     0.743    24.527     0.200
     2.960    77.277     0.200
     3.066    83.729     0.200
     3.266    88.979     0.200
     4.022   110.098     0.200
     0.734    24.227     0.200
     3.271    89.004     0.200
     0.661    21.852     0.200
     0.661    22.656     0.200
     1.739    50.000     0.200
     1.899    54.359     0.200
     3.362    90.023     0.200
     1.233    37.168     0.200
     1.474    44.387     0.200
     1.762    51.887     0.200
     1.762    51.758     0.200
     1.773    51.027     0.200
     1.907    55.627     0.200
     2.659    76.648     0.200
     2.659    74.018     0.200
     3.338    94.277     0.200
     3.354    91.008     0.200
     3.335    94.277     0.200
     3.335    90.137     0.200
     3.424    95.258     0.200
     3.751   103.828     0.200
     1.735    50.057     0.200
     3.300    90.436     0.200
     3.354    93.566     0.200
     3.372    92.377     0.200
     0.871    28.758     0.200
     1.302    38.367     0.200
     1.399    42.516     0.200
     1.683    49.555     0.200
     1.683    49.289     0.200
     2.106    61.367     0.200
     2.899    81.930     0.200
     2.977    81.664     0.200
     3.027    84.766     0.200
     3.180    86.648     0.200
     3.788   104.320     0.200
     7.637   202.430     0.200
     0.733    24.625     0.200
     1.392    41.188     0.200
     2.225    62.344     0.200
     2.975    81.570     0.200
     3.279    91.500     0.200
     0.731    24.281     0.200
     1.686    48.340     0.200
     2.301    63.328     0.200
     2.995    82.238     0.200
     2.951    82.750     0.200
     3.078    82.918     0.200
     3.274    88.199     0.200
     1.722    49.934     0.200
     1.722    50.320     0.200
     3.108    86.242     0.200
     2.917    79.172     0.200
     0.630    21.062     0.200
     1.522    43.842     0.200
     1.802    51.133     0.200
     1.821    49.592     0.200
     1.934    55.822     0.200
     1.934    53.303     0.200
     2.668    71.602     0.200
     2.626    74.543     0.200
     2.626    74.082     0.200
     3.382    87.682     0.200
     3.291    90.863     0.200
     3.379    92.223     0.200
     3.469    91.912     0.200
     4.983   134.402     0.200
     5.701   152.162     0.200
     7.840   203.896     0.200
     8.776   227.002     0.200
     8.916   233.162     0.200
     0.639    21.418     0.200
     1.765    51.178     0.200
     1.765    50.338     0.200
     1.775    49.797     0.200
     1.910    53.047     0.200
     2.656    71.258     0.200
     3.065    83.668     0.200
     3.354    91.398     0.200
     3.427    90.857     0.200
     7.817   204.268     0.200
     8.790   227.348     0.200
     0.598    20.363     0.200
     1.792    50.305     0.200
     1.822    50.195     0.200
     1.915    54.074     0.200
     2.643    74.285     0.200
     3.378    93.875     0.200
     3.465    92.664     0.200
     7.875   204.832     0.200
     8.802   226.090     0.200
     0.632    23.102     0.200
     1.224    37.902     0.200
     1.746    52.422     0.200
     1.757    51.461     0.200
     1.893    56.301     0.200
     1.893    55.953     0.200
     2.674    77.051     0.200
     3.356    93.941     0.200
     3.350    93.371     0.200
     3.642   100.332     0.200
     3.766   104.852     0.200
     5.003   133.883     0.200
     1.145    34.812     0.200
     1.776    50.336     0.200
     1.892    54.676     0.200
     2.670    72.895     0.200
     3.337    88.145     0.200
     3.385    92.516     0.200
     3.337    91.395     0.200
     3.424    90.094     0.200
     8.813   225.297     0.200
     3.344    93.527     0.200
     3.329    90.480     0.200
     1.169    35.943     0.200
     1.730    50.123     0.200
     1.737    51.483     0.200
     1.737    51.043     0.200
     1.902    54.953     0.200
     7.769   205.131     0.200
     1.236    37.939     0.200
     1.718    49.830     0.200
     1.726    51.631     0.200
     1.726    51.109     0.200
     1.892    54.990     0.200
     3.291    90.561     0.200
     3.305    92.881     0.200
     3.381    96.600     0.200
     1.029    31.064     0.200
     1.615    46.795     0.200
     1.887    53.936     0.200
     2.648    73.895     0.200
     2.727    74.984     0.200
     3.295    88.516     0.200
     1.406    39.832     0.200
     2.237    62.893     0.200
     2.989    83.693     0.200
     3.071    85.703     0.200
     3.270    91.672     0.200
     0.780    26.711     0.200
     0.886    29.273     0.200
     1.144    34.262     0.200
     1.732    50.344     0.200
     2.002    55.551     0.200
     2.718    73.871     0.200
     7.830   210.082     0.200
     0.560    20.393     0.200
     0.589    19.744     0.200
     0.646    21.693     0.200
     0.773    25.023     0.200
     0.773    25.863     0.200
     0.835    27.193     0.200
     2.173    59.824     0.200
     3.148    86.584     0.200
     4.282   112.373     0.200
     5.602   146.773     0.200
     3.060    86.677     0.200
     3.178    91.017     0.200
     0.828    28.520     0.200
     1.563    45.910     0.200
     3.135    86.180     0.200
     3.900   110.590     0.200
     0.822    26.678     0.200
     0.822    27.449     0.200
     1.196    35.818     0.200
     1.545    45.678     0.200
     2.783    78.678     0.200
     2.864    79.299     0.200
     3.151    87.568     0.200
     0.528    19.016     0.200
     0.564    18.723     0.200
     0.677    21.973     0.200
     0.677    23.406     0.200
     0.802    26.543     0.200
     0.802    26.344     0.200
     0.798    25.062     0.200
     0.798    26.645     0.200
     0.498    18.270     0.200
     0.699    22.459     0.200
     0.699    23.799     0.200
     2.116    59.209     0.200
     0.625    23.484     0.200
     0.744    24.805     0.200
     1.578    46.902     0.200
     0.771    26.656     0.200
     1.067    31.586     0.200
     1.302    39.965     0.200
     1.344    40.965     0.200
     1.464    44.336     0.200
     2.155    60.035     0.200
     3.137    85.105     0.200
     0.528    18.312     0.200
     0.565    19.055     0.200
     0.676    23.031     0.200
     1.567    44.977     0.200
     2.141    60.562     0.200
     3.166    88.031     0.200
     3.886   102.508     0.200
     4.311   113.477     0.200
     4.735   124.258     0.200
     5.630   149.555     0.200
     7.041   181.688     0.200
     9.247   239.094     0.200
     9.513   244.008     0.200
    11.863   293.188     0.200
     0.680    23.539     0.200
     0.792    25.984     0.200
     0.792    26.625     0.200
     0.792    26.898     0.200
     1.331    39.953     0.200
     1.539    45.875     0.200
     0.726    25.227     0.200
     0.888    29.914     0.200
     0.894    31.000     0.200
     0.710    23.727     0.200
     0.813    26.406     0.200
     1.296    39.258     0.200
     1.464    43.648     0.200
     1.505    44.766     0.200
     3.167    86.836     0.200
     3.167    87.227     0.200
     0.500    18.854     0.200
     0.500    20.003     0.200
     0.688    23.114     0.200
     0.688    24.364     0.200
     0.799    26.344     0.200
     0.799    26.463     0.200
     0.951    29.673     0.200
     0.796    26.595     0.200
     1.732    49.415     0.200
     2.869    81.445     0.200
     3.142    87.995     0.200
     3.263    85.835     0.200
     5.256   140.255     0.200
     6.266   166.565     0.200
     0.738    25.748     0.200
     1.614    45.498     0.200
     2.275    64.898     0.200
     2.335    67.078     0.200
     3.083    88.188     0.200
     0.402    14.750     0.200
     0.402    15.609     0.200
     2.003    56.914     0.200
     2.053    56.953     0.200
     0.593    20.512     0.200
     0.780    25.883     0.200
     0.780    26.523     0.200
     1.013    31.711     0.200
     1.251    38.422     0.200
     1.520    43.281     0.200
     0.724    25.066     0.200
     0.784    26.066     0.200
     1.008    30.535     0.200
     1.520    43.184     0.200
     2.214    59.586     0.200
     2.277    62.363     0.200
     3.178    87.766     0.200
     5.550   150.887     0.200
     0.653    23.258     0.200
     0.774    25.676     0.200
     1.335    40.047     0.200
     1.524    44.258     0.200
     2.240    62.875     0.200
     2.304    64.027     0.200
     0.588    19.758     0.200
     0.588    20.949     0.200
     0.657    21.168     0.200
     0.656    21.148     0.200
     0.656    20.957     0.200
     0.783    25.688     0.200
     0.783    25.789     0.200
     0.769    25.070     0.200
     0.768    25.488     0.200
     1.013    30.277     0.200
     1.350    39.340     0.200
     1.817    52.078     0.200
     2.248    58.359     0.200
     2.312    61.379     0.200
     2.354    64.719     0.200
     2.440    68.859     0.200
     0.539    19.336     0.200
     0.696    22.938     0.200
     0.685    23.859     0.200
     0.685    23.430     0.200
     1.099    32.957     0.200
     1.622    46.078     0.200
     1.622    44.836     0.200
     2.236    63.117     0.200
     2.294    65.227     0.200
     0.616    20.674     0.200
     0.616    21.584     0.200
     0.616    21.895     0.200
     0.605    20.523     0.200
     0.772    25.123     0.200
     0.772    26.094     0.200
     1.229    37.324     0.200
     1.436    42.684     0.200
     1.966    56.135     0.200
     2.164    60.064     0.200
     2.224    63.844     0.200
     7.492   199.328     0.200
     9.456   240.510     0.200
     0.623    22.367     0.200
     0.620    21.695     0.200
     0.769    25.641     0.200
     0.769    26.297     0.200
     1.033    31.508     0.200
     1.567    45.609     0.200
     1.567    46.281     0.200
     1.619    47.836     0.200
     2.156    60.766     0.200
     2.214    61.391     0.200
     3.154    86.891     0.200
     1.228    37.031     0.200
     1.228    36.773     0.200
     1.382    41.891     0.200
     1.480    43.461     0.200
     1.409    42.121     0.200
     2.312    66.371     0.200
     2.815    80.184     0.200
     2.913    83.871     0.200
     0.600    21.352     0.200
     0.600    21.805     0.200
     0.621    21.723     0.200
     0.621    21.875     0.200
     0.772    25.242     0.200
     0.772    26.555     0.200
     1.059    32.523     0.200
     1.030    31.402     0.200
     1.291    38.984     0.200
     1.421    42.395     0.200
     1.563    46.305     0.200
     1.664    48.715     0.200
     2.155    62.852     0.200
     2.214    63.492     0.200
     2.331    65.984     0.200
     1.266    36.672     0.200
     1.266    35.622     0.200
     2.821    75.322     0.200
     2.917    77.562     0.200
     1.015    31.873     0.200
     1.541    46.043     0.200
     2.171    61.844     0.200
     2.232    61.434     0.200
     1.024    32.434     0.200
     1.024    31.676     0.200
     1.199    36.637     0.200
     1.258    37.734     0.200
     1.465    44.574     0.200
     1.547    45.914     0.200
     2.187    62.746     0.200
     2.248    62.395     0.200
     0.758    24.684     0.200
     0.758    25.312     0.200
     0.648    22.801     0.200
     1.039    31.133     0.200
     2.178    62.082     0.200
     2.237    60.723     0.200
     0.597    20.930     0.200
     0.597    21.336     0.200
     0.671    22.672     0.200
     0.762    25.445     0.200
     0.762    25.016     0.200
     1.032    31.750     0.200
     1.257    36.977     0.200
     2.191    60.445     0.200
     2.251    62.016     0.200
     0.578    20.625     0.200
     0.643    21.934     0.200
     0.675    23.332     0.200
     1.262    37.082     0.200
     1.578    47.375     0.200
     1.578    44.945     0.200
     2.206    60.105     0.200
     2.265    60.984     0.200
     3.131    88.965     0.200
     1.454    41.133     0.200
     2.927    80.413     0.200
     3.030    83.533     0.200
     3.114    86.663     0.200
     3.310    89.113     0.200
     3.783   100.923     0.200
     0.541    19.895     0.200
     1.044    31.242     0.200
     1.196    31.723     0.200
     2.100    56.594     0.200
     2.156    57.312     0.200
     4.297   117.215     0.200
     0.462    15.529     0.200
     0.461    15.569     0.200
     0.461    16.239     0.200
     0.639    21.649     0.200
     0.639    21.889     0.200
     1.435    41.679     0.200
     1.925    54.689     0.200
     1.978    55.039     0.200
     3.266    85.109     0.200
     0.362    14.046     0.200
     0.363    14.066     0.200
     0.464    15.616     0.200
     0.464    15.576     0.200
     0.464    16.106     0.200
     0.956    27.686     0.200
     1.219    35.176     0.200
     1.379    39.236     0.200
     1.429    41.076     0.200
     1.923    54.636     0.200
     1.975    54.726     0.200
     3.264    84.736     0.200
     0.565    22.109     0.200
     0.725    23.938     0.200
     0.739    24.750     0.200
     0.742    25.027     0.200
     0.743    25.098     0.200
     0.785    25.648     0.200
     0.785    26.000     0.200
     0.785    27.207     0.200
     1.047    31.887     0.200
     1.198    36.879     0.200
     0.726    24.359     0.200
     0.759    25.902     0.200
     0.771    24.500     0.200
     0.824    26.062     0.200
     0.824    27.180     0.200
     0.824    26.602     0.200
     1.123    33.859     0.200
     0.472    16.047     0.200
     0.658    22.586     0.200
     0.658    22.316     0.200
     1.450    42.117     0.200
     1.997    55.715     0.200
     2.105    58.574     0.200
     2.124    58.645     0.200
     2.175    59.996     0.200
     0.379    14.875     0.200
     0.475    16.184     0.200
     0.474    16.102     0.200
     0.913    27.465     0.200
     1.233    35.781     0.200
     1.307    37.492     0.200
     1.442    41.664     0.200
     1.561    44.184     0.200
     1.946    54.832     0.200
     1.941    55.223     0.200
     1.994    55.703     0.200
     2.116    58.742     0.200
     2.101    58.773     0.200
     2.287    62.672     0.200
     2.459    68.102     0.200
     0.497    17.340     0.200
     0.829    27.398     0.200
     0.958    28.500     0.200
     1.250    37.391     0.200
     1.293    38.469     0.200
     1.443    42.781     0.200
     1.576    44.988     0.200
     1.960    56.551     0.200
     2.013    56.180     0.200
     0.415    15.488     0.200
     0.415    15.918     0.200
     0.415    16.438     0.200
     0.690    23.828     0.200
     0.690    23.727     0.200
     0.959    28.828     0.200
     1.456    42.656     0.200
     1.999    56.305     0.200
     2.051    56.137     0.200
     3.192    85.578     0.200
     0.810    27.887     0.200
     1.095    33.316     0.200
     1.208    36.180     0.200
     1.417    41.859     0.200
     1.923    55.559     0.200
     0.376    14.586     0.200
     0.376    14.766     0.200
     0.488    16.137     0.200
     0.649    22.484     0.200
     1.113    32.734     0.200
     1.238    36.246     0.200
     1.238    36.535     0.200
     1.433    41.816     0.200
     1.688    46.984     0.200
     1.999    55.754     0.200
     2.105    58.164     0.200
     2.106    56.375     0.200
     3.239    87.887     0.200
     0.722    24.973     0.200
     0.722    24.793     0.200
     0.762    25.992     0.200
     0.696    24.691     0.200
     1.071    34.012     0.200
     1.308    40.512     0.200
     1.490    44.664     0.200
     2.276    65.684     0.200
     0.725    24.184     0.200
     1.050    32.213     0.200
     1.300    39.623     0.200
     9.195   233.129     0.200
     0.612    20.792     0.200
     0.612    21.952     0.200
     0.589    21.643     0.200
     0.589    21.992     0.200
     0.620    21.572     0.200
     1.246    36.103     0.200
     2.151    61.272     0.200
     2.207    61.782     0.200
     3.121    83.553     0.200
     0.617    20.738     0.200
     0.617    22.318     0.200
     0.578    21.898     0.200
     1.349    39.688     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.551    17.150     0.200
     1.801    60.070     0.200
     1.877    58.230     0.200
     1.962    60.680     0.200
     1.994    61.850     0.200
     2.087    64.520     0.200
     2.255    71.705     0.200
     2.367    76.300     0.200
     0.614    19.828     0.200
     0.901    29.859     0.200
     1.077    34.461     0.200
     1.032    33.781     0.200
     1.368    43.117     0.200
     2.179    70.273     0.200
     2.325    74.352     0.200
     0.643    20.969     0.200
     1.117    35.668     0.200
     1.482    47.590     0.200
     1.482    47.430     0.200
     1.368    42.578     0.200
     0.655    21.113     0.200
     1.117    35.793     0.200
     1.493    47.941     0.200
     1.356    42.609     0.200
     1.986    60.633     0.200
     1.986    63.062     0.200
     1.095    36.861     0.200
     1.486    48.191     0.200
     1.347    42.633     0.200
     1.984    64.840     0.200
     2.101    65.131     0.200
     0.542    16.766     0.200
     0.570    18.312     0.200
     0.570    18.469     0.200
     1.117    37.430     0.200
     0.830    26.963     0.200
     0.829    26.803     0.200
     0.895    30.243     0.200
     1.962    60.413     0.200
     2.477    77.688     0.200
     2.477    77.333     0.200
     3.436   102.723     0.200
     3.871   113.793     0.200
     4.496   134.963     0.200
     5.111   156.482     0.200
     1.599    49.594     0.200
     1.246    38.723     0.200
     1.287    40.305     0.200
     1.367    49.719     0.200
     1.369    42.039     0.200
     1.694    52.875     0.200
     2.757    82.414     0.200
     3.112    92.219     0.200
     3.223    94.547     0.200
     6.440   221.938     0.200
     0.512    16.492     0.200
     1.036    31.883     0.200
     1.037    31.953     0.200
     1.037    32.445     0.200
     1.008    32.945     0.200
     1.676    53.008     0.200
     1.481    26.359     0.200
     1.291    40.621     0.200
     1.397    43.020     0.200
     1.393    43.258     0.200
     1.395    42.949     0.200
     1.905    57.883     0.200
     4.910   149.453     0.200
     1.987    61.306     0.200
     3.038    90.132     0.200
     3.038    88.442     0.200
     4.605   156.819     0.200
     4.625   156.562     0.200
     5.967   200.142     0.200
     7.047   238.064     0.200
     1.188    38.066     0.200
     1.278    39.934     0.200
     1.403    43.684     0.200
     1.403    45.453     0.200
     1.272    39.086     0.200
     1.274    39.398     0.200
     1.487    45.727     0.200
     0.929    29.719     0.200
     1.043    33.617     0.200
     1.043    33.516     0.200
     1.042    33.676     0.200
     1.042    33.457     0.200
     1.042    34.195     0.200
     1.238    39.336     0.200
     1.352    41.898     0.200
     1.484    45.414     0.200
     1.953    62.348     0.200
     1.982    63.109     0.200
     2.490    83.168     0.200
     3.238    97.668     0.200
     1.406    44.757     0.200
     4.930   149.348     0.200
     5.290   159.834     0.200
     5.613   170.010     0.200
     1.393    44.713     0.200
     5.463   157.723     0.200
     6.190   186.883     0.200
     1.188    37.969     0.200
     1.818    56.609     0.200
     3.385   102.117     0.200
     3.946   119.492     0.200
     0.609    19.605     0.200
     0.753    24.793     0.200
     0.753    24.895     0.200
     1.004    34.074     0.200
     1.065    33.613     0.200
     1.352    42.504     0.200
     1.513    46.504     0.200
     1.564    47.395     0.200
     1.608    50.723     0.200
     1.608    51.285     0.200
     1.642    53.965     0.200
     1.765    56.766     0.200
     2.000    62.605     0.200
     2.136    63.066     0.200
     2.303    73.355     0.200
     0.570    18.951     0.200
     0.686    22.461     0.200
     0.796    26.381     0.200
     0.943    29.161     0.200
     1.201    38.041     0.200
     1.534    46.851     0.200
     1.606    49.271     0.200
     2.068    61.981     0.200
     1.353    40.575     0.200
     1.727    52.416     0.200
     1.786    58.396     0.200
     3.638   111.229     0.200
     4.234   127.988     0.200
     0.640    21.445     0.200
     0.735    23.256     0.200
     1.052    32.596     0.200
     1.052    34.115     0.200
     0.994    31.596     0.200
     1.364    41.275     0.200
     1.669    49.535     0.200
     1.886    57.455     0.200
     1.918    57.936     0.200
     1.940    58.715     0.200
     1.940    60.635     0.200
     2.185    66.965     0.200
     2.530    77.404     0.200
     2.888    86.729     0.200
     3.481   105.867     0.200
     0.875    27.398     0.200
     0.913    29.016     0.200
     1.443    44.633     0.200
     1.501    46.164     0.200
     3.397    97.562     0.200
     0.591    20.086     0.200
     0.826    26.258     0.200
     0.839    27.109     0.200
     1.018    32.328     0.200
     1.061    33.047     0.200
     1.286    39.789     0.200
     1.518    45.453     0.200
     1.595    47.078     0.200
     2.434    70.023     0.200
     0.619    20.898     0.200
     0.924    29.977     0.200
     0.880    28.289     0.200
     1.112    35.047     0.200
     1.503    46.008     0.200
     1.553    47.312     0.200
     1.693    53.891     0.200
     2.530    77.391     0.200
     3.206    93.250     0.200
     0.600    19.683     0.200
     0.995    30.953     0.200
     0.995    31.423     0.200
     1.177    36.633     0.200
     1.533    47.283     0.200
     1.555    50.053     0.200
     1.774    53.753     0.200
     0.720    23.958     0.200
     0.975    31.448     0.200
     1.112    36.498     0.200
     1.112    36.658     0.200
     1.228    38.498     0.200
     1.338    40.758     0.200
     1.813    56.558     0.200
     0.613    20.812     0.200
     0.988    31.492     0.200
     0.988    31.643     0.200
     1.235    40.402     0.200
     1.235    39.062     0.200
     1.472    46.603     0.200
     1.490    45.902     0.200
     1.490    48.893     0.200
     2.290    71.982     0.200
     0.661    22.354     0.200
     0.616    20.424     0.200
     0.616    21.443     0.200
     0.826    26.674     0.200
     0.981    31.033     0.200
     0.981    30.924     0.200
     0.981    32.323     0.200
     1.250    39.104     0.200
     1.467    45.424     0.200
     1.467    46.743     0.200
     1.467    47.674     0.200
     1.631    49.623     0.200
     2.330    69.764     0.200
     2.988    91.357     0.200
     0.609    20.309     0.200
     0.612    20.038     0.200
     1.021    31.608     0.200
     1.021    31.309     0.200
     1.021    32.628     0.200
     1.546    47.918     0.200
     1.546    48.618     0.200
     1.622    48.648     0.200
     2.241    71.219     0.200
     3.164    94.969     0.200
     4.239   124.429     0.200
     5.566   161.438     0.200
     0.708    23.207     0.200
     0.708    24.055     0.200
     0.816    26.285     0.200
     0.923    29.227     0.200
     1.038    34.984     0.200
     1.135    35.957     0.200
     1.182    38.945     0.200
     1.182    40.695     0.200
     1.596    48.484     0.200
     1.596    51.668     0.200
     1.596    51.777     0.200
     2.254    73.375     0.200
     0.585    18.980     0.200
     0.790    25.238     0.200
     1.012    32.129     0.200
     1.012    32.648     0.200
     1.270    41.660     0.200
     1.382    42.699     0.200
     1.504    45.949     0.200
     1.866    56.309     0.200
     2.269    68.879     0.200
     0.705    23.699     0.200
     0.973    31.230     0.200
     1.540    48.062     0.200
     0.665    22.430     0.200
     1.067    34.070     0.200
     1.317    40.000     0.200
     1.330    40.871     0.200
     1.598    47.090     0.200
     2.137    63.312     0.200
     0.390    13.535     0.200
     0.819    26.488     0.200
     0.819    26.945     0.200
     1.667    49.867     0.200
     1.667    50.148     0.200
     1.607    52.387     0.200
     1.662    52.258     0.200
     1.863    57.887     0.200
     1.921    59.957     0.200
     2.011    59.957     0.200
     0.395    13.422     0.200
     1.474    45.086     0.200
     1.474    47.086     0.200
     1.474    47.938     0.200
     1.793    58.547     0.200
     1.793    58.664     0.200
     2.073    61.438     0.200
     1.435    43.512     0.200
     1.566    47.465     0.200
     2.149    62.305     0.200
     2.101    63.723     0.200
     0.810    26.348     0.200
     1.078    34.297     0.200
     1.078    35.807     0.200
     1.261    39.816     0.200
     1.261    40.297     0.200
     1.545    46.816     0.200
     1.648    52.598     0.200
     1.648    52.918     0.200
     1.983    60.076     0.200
     3.918   114.496     0.200
     0.769    25.688     0.200
     1.037    31.703     0.200
     1.037    33.328     0.200
     1.512    46.016     0.200
     1.745    53.500     0.200
     2.532    77.625     0.200
     2.702    77.023     0.200
     2.782    79.445     0.200
     0.753    24.531     0.200
     0.753    25.832     0.200
     0.939    30.141     0.200
     0.939    30.430     0.200
     0.933    30.211     0.200
     0.987    34.691     0.200
     1.105    35.910     0.200
     1.097    36.680     0.200
     1.097    37.762     0.200
     1.342    45.000     0.200
     1.491    45.953     0.200
     1.561    52.703     0.200
     1.677    54.992     0.200
     1.797    58.703     0.200
     2.020    60.480     0.200
     0.756    24.199     0.200
     0.941    29.691     0.200
     1.088    33.219     0.200
     1.104    34.129     0.200
     1.495    45.352     0.200
     3.262    99.070     0.200
     0.967    30.650     0.200
     0.999    33.279     0.200
     1.039    33.219     0.200
     1.112    35.680     0.200
     1.112    34.844     0.200
     1.353    39.949     0.200
     1.491    47.309     0.200
     1.897    59.021     0.200
     0.476    16.756     0.200
     0.743    24.904     0.200
     0.934    28.785     0.200
     0.934    30.225     0.200
     0.890    28.064     0.200
     1.083    32.945     0.200
     1.493    43.855     0.200
     1.493    46.945     0.200
     1.475    44.164     0.200
     1.983    58.414     0.200
     2.041    58.725     0.200
     0.215     8.035     0.200
     1.063    33.525     0.200
     1.624    49.406     0.200
     1.624    50.855     0.200
     1.642    49.865     0.200
     0.204     8.191     0.200
     1.022    33.973     0.200
     1.656    49.502     0.200
     1.658    49.992     0.200
     0.402    15.648     0.200
     0.513    16.695     0.200
     0.778    25.305     0.200
     0.871    26.828     0.200
     0.852    26.953     0.200
     0.862    27.797     0.200
     0.903    29.414     0.200
     1.025    32.297     0.200
     1.592    46.898     0.200
     1.592    49.617     0.200
     0.547    17.904     0.200
     0.707    24.154     0.200
     0.752    24.584     0.200
     1.051    34.244     0.200
     1.307    41.936     0.200
     1.317    43.186     0.200
     0.447    15.928     0.200
     1.330    42.416     0.200
     1.330    43.557     0.200
     1.452    43.547     0.200
     1.581    49.586     0.200
     1.581    51.287     0.200
     0.600    19.082     0.200
     1.109    33.832     0.200
     1.088    34.752     0.200
     1.674    50.132     0.200
     0.716    23.316     0.200
     1.104    36.297     0.200
     1.948    61.504     0.200
     3.348   101.387     0.200
     0.737    24.105     0.200
     0.959    32.535     0.200
     1.003    31.812     0.200
     1.128    36.742     0.200
     1.553    49.543     0.200
     0.321    12.138     0.200
     0.321    12.418     0.200
     0.466    15.617     0.200
     0.761    24.758     0.200
     0.777    25.317     0.200
     0.787    26.058     0.200
     0.827    26.277     0.200
     0.827    26.897     0.200
     0.863    29.617     0.200
     0.906    29.748     0.200
     0.970    30.268     0.200
     1.029    32.018     0.200
     1.265    40.058     0.200
     1.895    56.848     0.200
     1.946    58.647     0.200
     2.506    75.352     0.200
     0.503    16.904     0.200
     0.548    19.934     0.200
     0.736    24.934     0.200
     0.883    29.744     0.200
     0.883    29.904     0.200
     1.044    33.174     0.200
     1.882    58.904     0.200
     1.929    59.953     0.200
     0.213     9.820     0.200
     1.045    33.070     0.200
     1.546    48.453     0.200
     1.651    50.805     0.200
     3.036    86.234     0.200
     3.357   100.688     0.200
     0.802    26.172     0.200
     0.979    32.570     0.200
     1.038    34.375     0.200
     1.323    41.539     0.200
     1.483    45.570     0.200
     0.414    13.629     0.200
     0.414    13.438     0.200
     0.823    26.438     0.200
     0.894    29.051     0.200
     0.948    30.371     0.200
     1.046    32.508     0.200
     1.082    33.699     0.200
     1.082    35.840     0.200
     1.208    38.949     0.200
     1.466    43.301     0.200
     1.466    45.758     0.200
     1.466    46.570     0.200
     1.466    43.570     0.200
     1.946    58.820     0.200
     2.005    58.301     0.200
     0.456    14.990     0.200
     0.815    27.610     0.200
     1.581    50.200     0.200
     1.583    50.770     0.200
     1.640    50.070     0.200
     1.696    53.430     0.200
     1.861    56.790     0.200
     1.919    56.670     0.200
     2.021    62.440     0.200
     0.452    15.504     0.200
     1.070    34.102     0.200
     1.102    34.422     0.200
     1.102    34.082     0.200
     1.351    41.895     0.200
     1.473    45.234     0.200
     1.602    49.191     0.200
     1.783    51.832     0.200
     1.844    58.914     0.200
     0.427    15.186     0.200
     1.127    35.905     0.200
     1.164    35.996     0.200
     1.314    41.905     0.200
     1.507    47.715     0.200
     1.569    48.735     0.200
     1.718    51.646     0.200
     1.718    51.425     0.200
     1.912    59.646     0.200
     2.038    60.215     0.200
     2.838    85.095     0.200
     3.123    89.985     0.200
     3.547   102.456     0.200
     0.448    15.016     0.200
     1.109    36.215     0.200
     1.347    42.865     0.200
     1.477    47.086     0.200
     1.598    48.615     0.200
     1.852    59.045     0.200
     1.996    60.496     0.200
     2.626    79.826     0.200
     3.281    97.166     0.200
     3.540   101.816     0.200
     0.591    18.568     0.200
     0.771    24.889     0.200
     0.771    24.457     0.200
     0.835    26.777     0.200
     1.002    32.508     0.200
     1.050    32.658     0.200
     1.050    32.457     0.200
     1.077    33.537     0.200
     1.221    37.889     0.200
     1.221    38.348     0.200
     1.341    40.688     0.200
     0.315    11.127     0.200
     1.050    33.417     0.200
     1.612    48.387     0.200
     1.668    50.337     0.200
     1.714    50.737     0.200
     1.714    50.907     0.200
     3.282    97.507     0.200
     3.377    99.047     0.200
     0.337    11.596     0.200
     0.337    12.476     0.200
     1.114    34.716     0.200
     1.114    35.196     0.200
     1.619    48.246     0.200
     1.589    49.796     0.200
     3.323    96.986     0.200
     0.739    24.596     0.200
     0.951    31.465     0.200
     1.006    32.244     0.200
     1.026    32.994     0.200
     1.026    33.355     0.200
     1.138    36.936     0.200
     1.138    36.705     0.200
     1.471    45.695     0.200
     1.471    47.225     0.200
     1.509    48.145     0.200
     1.509    50.225     0.200
     1.509    51.734     0.200
     1.627    51.195     0.200
     1.799    56.086     0.200
     2.621    78.975     0.200
     2.700    81.234     0.200
     0.974    31.016     0.200
     0.964    31.430     0.200
     1.191    36.852     0.200
     1.191    38.695     0.200
     1.191    38.164     0.200
     1.573    49.141     0.200
     1.559    48.984     0.200
     2.665    80.141     0.200
     0.704    23.051     0.200
     0.981    32.461     0.200
     0.971    31.039     0.200
     1.028    33.188     0.200
     1.157    36.527     0.200
     1.500    46.277     0.200
     1.523    48.289     0.200
     1.606    51.141     0.200
     1.843    55.500     0.200
     2.705    83.059     0.200
     3.250    94.988     0.200
     0.929    30.594     0.200
     1.002    32.215     0.200
     1.205    38.906     0.200
     1.563    48.004     0.200
     3.233    95.844     0.200
     3.995   118.645     0.200
     0.618    20.516     0.200
     0.616    20.137     0.200
     0.801    25.986     0.200
     0.992    31.906     0.200
     0.992    32.365     0.200
     1.228    41.355     0.200
     1.306    43.326     0.200
     1.502    45.615     0.200
     1.502    49.686     0.200
     1.502    46.576     0.200
     3.195    95.496     0.200
     0.573    19.168     0.200
     0.863    26.988     0.200
     0.922    29.178     0.200
     1.422    43.478     0.200
     1.539    47.848     0.200
     1.586    50.638     0.200
     1.940    57.768     0.200
     2.002    59.308     0.200
     0.563    18.756     0.200
     0.859    27.656     0.200
     0.933    31.136     0.200
     1.434    44.956     0.200
     1.587    50.307     0.200
     1.793    56.937     0.200
     1.994    61.596     0.200
     1.994    60.776     0.200
     2.568    78.517     0.200
     0.905    29.211     0.200
     0.939    29.961     0.200
     1.422    44.352     0.200
     1.502    47.602     0.200
     1.826    56.281     0.200
     1.898    55.578     0.200
     1.967    60.695     0.200
     1.967    59.016     0.200
     3.710   113.281     0.200
     0.583    19.164     0.200
     0.913    29.832     0.200
     1.417    44.145     0.200
     1.545    47.645     0.200
     1.576    48.492     0.200
     1.782    54.094     0.200
     1.776    54.512     0.200
     1.951    59.781     0.200
     2.013    60.293     0.200
     3.557   105.012     0.200
     0.569    18.914     0.200
     1.434    44.543     0.200
     1.556    48.605     0.200
     1.574    49.242     0.200
     1.783    55.074     0.200
     1.779    56.535     0.200
     2.004    62.023     0.200
     0.536    17.684     0.200
     0.861    27.305     0.200
     0.960    30.504     0.200
     1.459    44.523     0.200
     1.552    47.656     0.200
     1.597    50.195     0.200
     1.815    55.773     0.200
     1.918    57.625     0.200
     1.971    58.125     0.200
     2.808    83.586     0.200
     0.533    18.586     0.200
     0.893    29.436     0.200
     0.893    28.766     0.200
     0.958    30.906     0.200
     1.445    44.356     0.200
     1.626    52.956     0.200
     1.833    57.986     0.200
     1.895    58.576     0.200
     1.957    57.986     0.200
     1.957    60.916     0.200
     3.502   104.096     0.200
     0.909    30.102     0.200
     0.909    29.270     0.200
     0.949    30.383     0.200
     1.430    43.891     0.200
     1.501    45.691     0.200
     1.638    51.293     0.200
     1.833    56.871     0.200
     1.742    52.281     0.200
     1.836    56.441     0.200
     1.889    57.672     0.200
     1.889    55.543     0.200
     1.956    59.422     0.200
     1.956    56.902     0.200
     2.602    74.660     0.200
     2.602    75.691     0.200
     2.850    82.031     0.200
     3.494   100.492     0.200
     0.511    17.543     0.200
     0.890    28.004     0.200
     0.890    29.141     0.200
     0.981    30.172     0.200
     1.468    43.914     0.200
     1.530    46.113     0.200
     1.630    48.352     0.200
     1.772    52.523     0.200
     1.847    54.602     0.200
     1.884    56.613     0.200
     1.940    57.934     0.200
     1.940    57.031     0.200
     0.568    19.438     0.200
     0.920    29.672     0.200
     0.942    30.445     0.200
     0.942    30.195     0.200
     1.388    42.641     0.200
     1.460    44.227     0.200
     1.699    51.234     0.200
     1.659    51.234     0.200
     1.835    55.711     0.200
     1.884    57.156     0.200
     1.884    55.258     0.200
     1.966    59.680     0.200
     0.542    18.484     0.200
     0.924    30.469     0.200
     0.946    29.906     0.200
     1.650    51.234     0.200
     1.842    55.891     0.200
     1.849    56.625     0.200
     1.880    58.000     0.200
     1.953    57.680     0.200
     0.549    19.125     0.200
     0.900    30.078     0.200
     0.941    31.023     0.200
     1.425    45.047     0.200
     1.508    47.812     0.200
     1.626    52.203     0.200
     1.748    54.898     0.200
     1.824    57.008     0.200
     1.901    59.219     0.200
     1.968    60.594     0.200
     2.591    76.367     0.200
     2.591    77.812     0.200
     3.563   104.734     0.200
     3.695   110.016     0.200
     0.580    19.477     0.200
     0.916    29.828     0.200
     1.420    43.430     0.200
     1.576    49.547     0.200
     1.777    54.578     0.200
     2.011    61.953     0.200
     2.551    74.281     0.200
     3.556   104.133     0.200
     0.549    18.643     0.200
     0.946    30.223     0.200
     1.006    30.913     0.200
     1.387    42.443     0.200
     1.403    43.653     0.200
     1.724    51.683     0.200
     1.827    55.963     0.200
     1.827    55.413     0.200
     1.890    56.833     0.200
     1.882    55.913     0.200
     1.920    57.223     0.200
     1.920    57.753     0.200
     2.634    75.283     0.200
     2.634    76.603     0.200
     3.260    98.523     0.200
     0.613    20.500     0.200
     1.364    42.609     0.200
     1.492    45.711     0.200
     1.607    50.047     0.200
     1.776    54.945     0.200
     1.942    59.008     0.200
     2.001    62.008     0.200
     2.022    59.969     0.200
     2.022    60.789     0.200
     2.534    74.156     0.200
     0.588    19.516     0.200
     0.944    30.637     0.200
     0.944    31.266     0.200
     1.368    43.945     0.200
     1.453    45.686     0.200
     1.654    50.865     0.200
     1.691    53.176     0.200
     1.820    56.576     0.200
     1.897    58.227     0.200
     1.983    59.746     0.200
     3.495   105.955     0.200
     0.933    30.859     0.200
     0.933    31.414     0.200
     0.933    29.734     0.200
     1.405    43.023     0.200
     1.473    44.500     0.200
     1.654    51.133     0.200
     1.712    51.148     0.200
     1.838    55.812     0.200
     1.959    59.328     0.200
     1.959    58.500     0.200
     2.597    75.273     0.200
     2.867    82.750     0.200
     3.485   100.680     0.200
     0.959    30.867     0.200
     0.948    31.098     0.200
     0.948    30.398     0.200
     1.424    44.027     0.200
     1.465    46.297     0.200
     1.676    51.387     0.200
     1.707    52.066     0.200
     1.866    56.277     0.200
     1.856    57.879     0.200
     1.856    55.688     0.200
     1.931    59.539     0.200
     1.931    58.098     0.200
     0.591    19.766     0.200
     0.897    28.756     0.200
     0.941    30.525     0.200
     0.941    30.656     0.200
     1.366    42.266     0.200
     1.456    45.227     0.200
     1.650    50.256     0.200
     1.693    52.037     0.200
     1.816    55.025     0.200
     1.901    58.195     0.200
     2.568    74.596     0.200
     0.541    19.357     0.200
     0.949    30.268     0.200
     0.898    28.457     0.200
     1.512    45.188     0.200
     1.627    51.457     0.200
     1.752    54.027     0.200
     1.897    58.148     0.200
     0.586    20.577     0.200
     0.903    29.237     0.200
     0.949    31.007     0.200
     0.949    30.557     0.200
     1.369    42.177     0.200
     1.449    44.017     0.200
     1.686    50.327     0.200
     1.660    51.887     0.200
     1.892    57.087     0.200
     1.826    56.417     0.200
     2.576    74.327     0.200
     0.584    19.201     0.200
     0.906    28.850     0.200
     0.898    28.100     0.200
     0.898    27.621     0.200
     1.392    43.660     0.200
     1.500    46.881     0.200
     1.614    49.400     0.200
     1.737    53.311     0.200
     1.836    55.320     0.200
     1.924    57.891     0.200
     0.580    19.195     0.200
     0.872    28.445     0.200
     0.913    29.117     0.200
     1.410    43.234     0.200
     1.528    46.508     0.200
     1.592    48.297     0.200
     1.765    53.285     0.200
     1.808    55.617     0.200
     1.938    58.387     0.200
     2.556    74.367     0.200
     2.556    73.145     0.200
     2.804    82.855     0.200
     0.596    20.320     0.200
     0.899    29.121     0.200
     1.003    31.111     0.200
     1.003    32.641     0.200
     1.342    42.201     0.200
     1.394    42.980     0.200
     1.632    50.531     0.200
     1.707    53.820     0.200
     1.861    57.580     0.200
     1.861    54.602     0.200
     1.854    57.230     0.200
     1.942    60.121     0.200
     0.582    20.172     0.200
     0.906    29.113     0.200
     0.949    31.043     0.200
     0.949    31.602     0.200
     1.372    42.363     0.200
     1.450    44.543     0.200
     1.688    51.352     0.200
     1.661    50.473     0.200
     1.889    58.402     0.200
     1.828    55.023     0.200
     1.886    57.723     0.200
     0.562    19.211     0.200
     0.952    32.504     0.200
     1.670    52.562     0.200
     1.845    57.512     0.200
     1.882    57.383     0.200
     0.581    19.444     0.200
     0.911    29.896     0.200
     0.986    32.325     0.200
     0.986    30.866     0.200
     1.361    42.274     0.200
     1.853    58.505     0.200
     2.908    84.966     0.200
     3.224    94.235     0.200
     0.593    19.973     0.200
     0.960    31.662     0.200
     0.960    32.742     0.200
     1.357    42.441     0.200
     1.436    44.223     0.200
     1.674    51.012     0.200
     1.667    52.191     0.200
     1.827    57.701     0.200
     2.574    75.342     0.200
     0.543    17.454     0.200
     0.543    17.314     0.200
     0.749    24.895     0.200
     0.749    25.154     0.200
     0.825    25.645     0.200
     0.917    30.074     0.200
     0.917    29.734     0.200
     0.917    30.574     0.200
     0.934    29.435     0.200
     1.032    32.715     0.200
     1.032    32.255     0.200
     1.013    31.595     0.200
     1.062    34.494     0.200
     1.174    36.734     0.200
     1.130    37.164     0.200
     1.259    41.015     0.200
     1.590    47.484     0.200
     1.541    49.824     0.200
     0.459    16.315     0.200
     0.540    17.795     0.200
     0.540    17.475     0.200
     0.830    26.275     0.200
     0.902    30.965     0.200
     0.909    29.055     0.200
     0.920    29.165     0.200
     0.960    30.315     0.200
     0.960    31.585     0.200
     1.034    32.715     0.200
     1.244    38.465     0.200
     1.314    41.565     0.200
     1.595    47.515     0.200
     1.595    47.395     0.200
     1.650    49.555     0.200
     2.224    64.725     0.200
     0.595    19.852     0.200
     0.893    28.451     0.200
     0.946    31.451     0.200
     0.946    29.992     0.200
     1.361    41.041     0.200
     1.450    42.771     0.200
     1.687    49.822     0.200
     1.654    51.492     0.200
     1.817    55.012     0.200
     1.887    57.301     0.200
     1.988    58.092     0.200
     2.567    74.211     0.200
     3.644   105.643     0.200
     0.578    19.625     0.200
     0.913    29.316     0.200
     0.984    31.113     0.200
     1.364    41.977     0.200
     1.416    43.543     0.200
     1.655    50.633     0.200
     1.695    50.516     0.200
     1.854    56.215     0.200
     2.598    74.883     0.200
     0.927    29.159     0.200
     0.995    31.809     0.200
     0.995    31.129     0.200
     1.372    42.989     0.200
     1.648    51.089     0.200
     1.709    52.379     0.200
     1.870    56.949     0.200
     1.846    54.769     0.200
     1.846    54.509     0.200
     1.941    59.169     0.200
     1.941    56.909     0.200
     2.614    76.199     0.200
     3.240    96.829     0.200
     0.583    19.471     0.200
     0.906    29.661     0.200
     0.905    30.351     0.200
     0.905    30.690     0.200
     1.390    42.621     0.200
     1.731    52.261     0.200
     1.620    50.461     0.200
     1.801    56.121     0.200
     1.842    56.811     0.200
     0.581    19.672     0.200
     0.869    29.182     0.200
     0.912    29.152     0.200
     1.410    42.242     0.200
     1.589    51.902     0.200
     1.784    53.191     0.200
     1.806    55.021     0.200
     2.554    73.791     0.200
     0.585    19.477     0.200
     0.902    29.184     0.200
     1.377    42.184     0.200
     1.641    51.613     0.200
     1.813    56.215     0.200
     1.987    58.336     0.200
     1.866    58.363     0.200
     2.569    74.316     0.200
     0.595    19.965     0.200
     0.894    28.762     0.200
     1.354    41.453     0.200
     1.432    43.012     0.200
     1.670    50.145     0.200
     1.670    52.102     0.200
     1.888    56.871     0.200
     1.828    55.922     0.200
     1.904    57.984     0.200
     1.981    58.371     0.200
     2.574    74.812     0.200
     0.478    15.344     0.200
     1.027    33.812     0.200
     1.529    47.102     0.200
     1.603    52.742     0.200
     1.744    56.215     0.200
     1.928    59.672     0.200
     1.998    62.621     0.200
     1.853    59.043     0.200
     2.644    78.031     0.200
     0.507    16.590     0.200
     0.992    31.871     0.200
     1.490    46.809     0.200
     1.564    47.570     0.200
     1.604    50.449     0.200
     1.807    55.469     0.200
     1.769    55.141     0.200
     1.836    56.711     0.200
     1.902    56.941     0.200
     1.948    58.359     0.200
     1.948    57.949     0.200
     1.995    61.109     0.200
     2.619    76.781     0.200
     3.194    92.801     0.200
     0.473    15.891     0.200
     1.044    33.672     0.200
     1.555    47.438     0.200
     1.584    50.508     0.200
     1.713    53.234     0.200
     1.849    57.172     0.200
     1.906    57.406     0.200
     1.931    57.102     0.200
     1.931    60.641     0.200
     2.648    76.984     0.200
     3.775   112.094     0.200
     0.584    19.387     0.200
     0.904    29.697     0.200
     0.935    29.727     0.200
     0.935    29.906     0.200
     1.376    42.227     0.200
     1.376    51.146     0.200
     1.463    45.688     0.200
     1.701    50.236     0.200
     1.648    50.996     0.200
     1.818    55.396     0.200
     1.983    57.787     0.200
     0.883    27.438     0.200
     0.883    27.227     0.200
     0.921    28.508     0.200
     1.413    42.898     0.200
     1.519    44.883     0.200
     1.604    52.852     0.200
     1.799    56.758     0.200
     1.993    59.680     0.200
     0.541    19.109     0.200
     0.950    31.352     0.200
     1.675    52.836     0.200
     1.859    56.516     0.200
     1.875    58.789     0.200
     2.887    85.125     0.200
     3.226    96.633     0.200
     0.586    19.799     0.200
     0.902    28.469     0.200
     0.937    28.989     0.200
     0.937    30.689     0.200
     1.373    42.309     0.200
     1.461    44.489     0.200
     1.698    50.539     0.200
     1.649    53.859     0.200
     1.818    55.979     0.200
     1.984    57.539     0.200
     1.825    56.607     0.200
     1.887    60.938     0.200
     1.831    58.879     0.200
     2.001    62.098     0.200
     2.001    60.488     0.200
     2.572    79.549     0.200
     3.276    96.789     0.200
     7.737   253.947     0.200
     0.548    17.795     0.200
     0.930    30.285     0.200
     0.940    31.205     0.200
     1.412    44.744     0.200
     1.477    45.674     0.200
     1.654    51.725     0.200
     1.717    52.125     0.200
     1.842    57.625     0.200
     1.955    58.854     0.200
     0.555    18.359     0.200
     0.935    30.061     0.200
     0.971    30.650     0.200
     0.971    30.410     0.200
     1.391    43.061     0.200
     1.435    44.141     0.200
     1.675    49.410     0.200
     1.690    51.500     0.200
     1.856    56.189     0.200
     1.862    56.160     0.200
     1.943    58.689     0.200
     2.612    75.859     0.200
     0.553    18.238     0.200
     0.935    31.250     0.200
     0.939    29.648     0.200
     0.939    31.279     0.200
     1.404    44.209     0.200
     1.660    51.889     0.200
     1.707    53.289     0.200
     1.843    56.898     0.200
     1.877    57.090     0.200
     1.877    55.770     0.200
     1.955    58.889     0.200
     1.955    58.568     0.200
     2.812    84.959     0.200
     0.578    19.148     0.200
     0.898    29.707     0.200
     0.898    29.109     0.200
     0.911    30.008     0.200
     1.398    44.379     0.200
     1.501    47.641     0.200
     1.616    51.738     0.200
     1.739    53.730     0.200
     1.802    56.891     0.200
     1.920    59.859     0.200
     1.993    61.449     0.200
     2.565    76.129     0.200
     0.566    19.152     0.200
     0.901    29.395     0.200
     1.408    43.812     0.200
     1.622    52.094     0.200
     1.811    55.984     0.200
     1.811    59.465     0.200
     1.911    57.293     0.200
     0.595    20.109     0.200
     0.893    29.312     0.200
     1.374    41.844     0.200
     1.625    51.609     0.200
     1.718    51.852     0.200
     1.798    55.609     0.200
     2.555    74.359     0.200
     2.838    83.117     0.200
     0.564    18.797     0.200
     1.406    43.148     0.200
     1.632    52.711     0.200
     1.819    55.727     0.200
     2.582    75.602     0.200
     0.678    22.566     0.200
     1.096    36.336     0.200
     1.090    35.016     0.200
     1.515    46.586     0.200
     1.736    53.617     0.200
     3.115    91.668     0.200
     3.399   102.816     0.200
     0.572    18.500     0.200
     0.917    29.602     0.200
     0.970    31.820     0.200
     0.970    30.902     0.200
     1.374    42.871     0.200
     1.432    43.531     0.200
     1.671    50.242     0.200
     1.683    53.570     0.200
     1.849    55.883     0.200
     1.958    58.301     0.200
     1.084    35.911     0.200
     1.084    34.361     0.200
     1.295    40.562     0.200
     1.310    41.281     0.200
     1.547    48.531     0.200
     1.776    54.401     0.200
     1.824    57.321     0.200
     1.824    55.182     0.200
     1.892    57.361     0.200
     1.951    60.762     0.200
     1.951    58.432     0.200
     2.608    75.962     0.200
     0.577    19.582     0.200
     0.863    26.852     0.200
     0.918    29.021     0.200
     1.417    43.162     0.200
     1.586    50.521     0.200
     1.538    49.043     0.200
     1.785    56.172     0.200
     2.556    77.973     0.200
     3.147    92.672     0.200
     3.566   103.383     0.200
     0.581    19.367     0.200
     0.903    29.768     0.200
     1.393    42.986     0.200
     1.619    52.717     0.200
     1.802    57.107     0.200
     1.994    59.207     0.200
     0.871    27.938     0.200
     0.871    27.609     0.200
     0.980    31.453     0.200
     1.474    45.648     0.200
     1.548    46.797     0.200
     1.612    52.633     0.200
     1.790    53.594     0.200
     1.835    55.648     0.200
     1.899    58.273     0.200
     1.899    56.117     0.200
     1.951    58.820     0.200
     1.951    58.289     0.200
     0.543    17.953     0.200
     0.870    27.000     0.200
     0.870    29.609     0.200
     0.951    30.031     0.200
     1.447    43.305     0.200
     1.602    49.891     0.200
     1.813    56.164     0.200
     1.974    57.297     0.200
     0.545    19.211     0.200
     0.906    29.711     0.200
     1.426    44.148     0.200
     1.894    57.516     0.200
     1.962    58.391     0.200
     0.894    28.023     0.200
     0.975    30.070     0.200
     0.975    30.234     0.200
     1.632    52.969     0.200
     1.845    57.617     0.200
     1.943    56.250     0.200
     1.943    56.359     0.200
     0.535    17.787     0.200
     0.954    30.497     0.200
     1.411    43.817     0.200
     1.445    45.677     0.200
     1.691    52.927     0.200
     1.847    55.217     0.200
     1.873    57.877     0.200
     1.912    57.197     0.200
     1.928    58.007     0.200
     3.702   112.587     0.200
     0.890    27.566     0.200
     0.951    30.126     0.200
     1.439    43.766     0.200
     1.620    48.926     0.200
     1.761    52.016     0.200
     1.825    53.296     0.200
     1.902    56.166     0.200
     1.964    56.706     0.200
     0.579    19.641     0.200
     1.393    43.422     0.200
     1.492    45.682     0.200
     1.624    51.580     0.200
     1.730    52.461     0.200
     1.915    57.301     0.200
     0.892    27.195     0.200
     0.928    29.086     0.200
     1.416    43.445     0.200
     1.615    52.277     0.200
     1.751    51.637     0.200
     1.987    59.867     0.200
     0.560    19.156     0.200
     0.858    26.805     0.200
     0.936    29.977     0.200
     1.437    45.168     0.200
     1.548    48.285     0.200
     1.586    49.668     0.200
     1.993    59.797     0.200
     1.426    44.602     0.200
     1.585    49.973     0.200
     1.788    55.203     0.200
     1.939    61.031     0.200
     1.939    59.582     0.200
     2.000    62.320     0.200
     2.000    62.121     0.200
     0.558    18.805     0.200
     0.884    27.695     0.200
     0.884    29.543     0.200
     0.934    29.754     0.200
     1.425    42.785     0.200
     1.610    51.574     0.200
     1.809    54.914     0.200
     1.981    60.586     0.200
     2.822    83.324     0.200
     0.560    18.406     0.200
     0.929    29.227     0.200
     0.957    32.059     0.200
     1.390    43.246     0.200
     1.447    44.168     0.200
     1.687    52.168     0.200
     1.675    51.516     0.200
     1.953    58.266     0.200
     1.953    56.938     0.200
     0.574    19.375     0.200
     0.921    30.102     0.200
     1.583    50.578     0.200
     1.780    56.008     0.200
     1.785    56.922     0.200
     1.942    59.828     0.200
     2.004    59.750     0.200
     2.795    82.438     0.200
     0.565    19.208     0.200
     0.927    30.078     0.200
     0.881    28.688     0.200
     1.420    44.318     0.200
     1.605    50.908     0.200
     1.802    55.358     0.200
     1.923    56.228     0.200
     0.846    27.016     0.200
     0.985    32.477     0.200
     0.985    32.000     0.200
     1.299    40.000     0.200
     1.673    51.875     0.200
     3.177    92.188     0.200
     0.879    27.908     0.200
     1.061    32.178     0.200
     1.295    40.099     0.200
     1.331    41.269     0.200
     1.753    53.248     0.200
     1.844    54.658     0.200
     1.844    54.248     0.200
     1.966    57.538     0.200
     1.966    57.688     0.200
     0.564    18.840     0.200
     0.885    27.859     0.200
     1.419    43.738     0.200
     1.609    52.098     0.200
     2.821    85.250     0.200
     3.683   111.430     0.200
     0.525    18.320     0.200
     0.910    29.867     0.200
     0.964    30.305     0.200
     1.444    43.312     0.200
     1.505    46.906     0.200
     1.847    53.844     0.200
     1.880    57.594     0.200
     1.944    56.477     0.200
     1.958    58.484     0.200
     0.929    30.309     0.200
     1.414    45.480     0.200
     1.504    48.340     0.200
     1.624    51.250     0.200
     1.624    51.422     0.200
     1.908    59.449     0.200
     1.977    60.949     0.200
     2.836    83.199     0.200
     3.552   106.281     0.200
     3.683   108.051     0.200
     0.554    18.352     0.200
     0.912    28.133     0.200
     0.912    29.055     0.200
     0.934    29.312     0.200
     1.414    43.992     0.200
     1.636    51.633     0.200
     1.826    55.633     0.200
     1.968    59.094     0.200
     3.688   109.656     0.200
     0.565    19.113     0.200
     0.936    29.723     0.200
     1.443    43.803     0.200
     1.565    47.843     0.200
     1.569    51.812     0.200
     1.783    54.843     0.200
     0.562    18.293     0.200
     0.926    30.512     0.200
     0.932    30.859     0.200
     1.398    43.691     0.200
     1.471    45.191     0.200
     1.652    51.961     0.200
     1.711    52.211     0.200
     1.833    56.332     0.200
     1.863    59.352     0.200
     1.966    58.793     0.200
     0.569    19.039     0.200
     0.895    29.658     0.200
     0.895    28.818     0.200
     0.921    29.908     0.200
     1.408    43.299     0.200
     1.507    45.559     0.200
     1.616    48.529     0.200
     1.807    53.719     0.200
     1.987    57.889     0.200
     2.828    83.658     0.200
     3.520   102.539     0.200
     0.569    19.590     0.200
     0.867    27.811     0.200
     0.867    28.051     0.200
     0.925    29.801     0.200
     1.423    44.680     0.200
     1.536    46.340     0.200
     1.591    49.100     0.200
     1.792    53.850     0.200
     1.997    58.670     0.200
     3.540   103.109     0.200
     0.570    20.059     0.200
     0.849    27.348     0.200
     0.849    28.816     0.200
     0.928    29.516     0.200
     1.433    43.918     0.200
     1.576    48.227     0.200
     1.783    53.938     0.200
     2.004    59.137     0.200
     2.788    82.137     0.200
     0.895    29.129     0.200
     1.403    44.059     0.200
     1.614    52.488     0.200
     1.802    57.299     0.200
     2.826    83.639     0.200
     3.167    91.928     0.200
     0.956    30.228     0.200
     1.147    36.538     0.200
     1.147    34.598     0.200
     1.259    39.788     0.200
     1.331    41.268     0.200
     1.744    52.818     0.200
     1.744    52.048     0.200
     1.851    56.308     0.200
     1.879    56.468     0.200
     1.879    55.388     0.200
     1.972    59.978     0.200
     2.683    77.768     0.200
     0.585    19.645     0.200
     0.951    29.764     0.200
     1.117    34.964     0.200
     1.117    34.814     0.200
     1.289    40.044     0.200
     1.340    41.764     0.200
     1.531    46.674     0.200
     1.762    52.104     0.200
     1.824    55.104     0.200
     1.953    59.274     0.200
     2.671    76.444     0.200
     2.671    79.114     0.200
     3.415   101.254     0.200
     0.578    19.438     0.200
     0.911    30.477     0.200
     1.375    42.297     0.200
     1.685    50.406     0.200
     1.666    54.180     0.200
     1.834    56.477     0.200
     1.970    58.547     0.200
     1.888    59.070     0.200
     2.312    68.086     0.200
     2.585    76.039     0.200
     2.878    83.531     0.200
     0.907    28.273     0.200
     0.956    30.070     0.200
     1.370    41.961     0.200
     1.443    44.453     0.200
     1.681    51.172     0.200
     1.667    49.805     0.200
     1.884    57.805     0.200
     1.833    54.984     0.200
     1.972    58.984     0.200
     0.573    18.586     0.200
     0.890    29.930     0.200
     0.917    29.188     0.200
     1.407    42.414     0.200
     1.610    50.148     0.200
     4.430   133.203     0.200
     0.922    29.375     0.200
     0.914    30.736     0.200
     1.402    42.166     0.200
     1.634    50.545     0.200
     1.819    55.656     0.200
     1.903    56.086     0.200
     1.977    58.035     0.200
     2.581    74.896     0.200
     0.557    19.078     0.200
     0.931    29.727     0.200
     0.935    30.309     0.200
     0.935    29.648     0.200
     1.470    46.078     0.200
     1.656    51.457     0.200
     1.838    56.207     0.200
     1.864    57.496     0.200
     0.543    18.621     0.200
     0.927    30.262     0.200
     0.927    31.230     0.200
     1.482    45.312     0.200
     1.653    51.973     0.200
     1.843    56.992     0.200
     2.606    80.160     0.200
     2.865    84.531     0.200
     0.471    16.031     0.200
     1.045    33.711     0.200
     1.555    47.453     0.200
     1.586    49.461     0.200
     1.621    49.602     0.200
     1.714    53.297     0.200
     1.851    56.734     0.200
     1.866    56.461     0.200
     1.904    57.250     0.200
     1.929    58.297     0.200
     2.650    77.180     0.200
     2.793    81.758     0.200
     0.877    28.391     0.200
     0.921    28.984     0.200
     1.416    43.438     0.200
     1.599    49.352     0.200
     1.763    53.664     0.200
     1.796    53.727     0.200
     1.995    62.086     0.200
     2.565    73.727     0.200
     3.159    92.969     0.200
     5.031   148.031     0.200
     0.540    17.979     0.200
     0.958    29.919     0.200
     1.460    42.819     0.200
     1.589    51.359     0.200
     1.808    56.249     0.200
     1.925    56.719     0.200
     1.978    58.369     0.200
     2.588    74.459     0.200
     0.559    18.874     0.200
     0.936    30.134     0.200
     1.436    43.934     0.200
     1.545    49.414     0.200
     1.589    51.404     0.200
     1.796    55.574     0.200
     0.952    32.465     0.200
     1.650    50.645     0.200
     1.674    53.125     0.200
     1.799    57.215     0.200
     1.917    58.015     0.200
     2.011    59.385     0.200
     0.552    18.521     0.200
     0.905    28.011     0.200
     0.905    30.031     0.200
     0.937    29.621     0.200
     1.420    43.161     0.200
     1.630    51.461     0.200
     1.741    52.352     0.200
     1.824    56.281     0.200
     1.969    58.261     0.200
     1.969    59.291     0.200
     0.840    26.979     0.200
     0.804    26.509     0.200
     1.278    39.909     0.200
     1.372    43.619     0.200
     1.520    48.318     0.200
     2.497    74.339     0.200
     2.801    84.959     0.200
     1.184    37.605     0.200
     1.222    39.844     0.200
     1.222    40.465     0.200
     1.428    44.375     0.200
     1.700    53.535     0.200
     1.700    51.914     0.200
     1.921    58.734     0.200
     1.856    57.434     0.200
     1.856    55.543     0.200
     2.022    63.094     0.200
     3.399   100.824     0.200
     0.661    22.416     0.200
     0.923    29.926     0.200
     1.199    37.965     0.200
     1.196    38.734     0.200
     1.196    37.465     0.200
     1.270    39.945     0.200
     1.439    44.385     0.200
     1.883    57.814     0.200
     1.972    62.404     0.200
     2.591    79.395     0.200
     2.663    81.016     0.200
     3.619   105.635     0.200
     1.184    38.805     0.200
     1.206    38.875     0.200
     1.206    39.055     0.200
     1.238    40.652     0.200
     1.421    45.645     0.200
     1.421    44.312     0.200
     1.934    57.855     0.200
     1.884    59.855     0.200
     1.958    61.105     0.200
     2.642    76.875     0.200
     0.935    29.941     0.200
     1.194    37.383     0.200
     1.203    38.402     0.200
     1.203    37.223     0.200
     1.280    40.199     0.200
     1.435    44.250     0.200
     1.740    50.973     0.200
     1.893    56.762     0.200
     1.984    58.883     0.200
     0.884    28.531     0.200
     1.023    33.070     0.200
     1.318    40.000     0.200
     1.720    54.695     0.200
     1.860    55.500     0.200
     1.854    57.648     0.200
     1.970    59.234     0.200
     0.757    24.828     0.200
     0.923    30.988     0.200
     1.156    36.879     0.200
     1.478    45.549     0.200
     1.478    47.568     0.200
     1.515    47.998     0.200
     1.613    51.779     0.200
     2.727    81.529     0.200
     1.197    37.717     0.200
     0.917    29.488     0.200
     1.537    47.707     0.200
     1.176    36.797     0.200
     1.448    44.258     0.200
     1.448    44.148     0.200
     1.391    42.678     0.200
     1.684    50.258     0.200
     1.684    49.637     0.200
     2.312    72.668     0.200
     2.984    88.697     0.200
     1.188    37.273     0.200
     0.929    29.797     0.200
     1.388    43.336     0.200
     1.413    44.695     0.200
     1.457    44.855     0.200
     1.688    49.863     0.200
     2.229    66.523     0.200
     2.301    69.145     0.200
     3.078    89.824     0.200
     0.932    29.812     0.200
     1.188    36.797     0.200
     1.209    38.117     0.200
     1.209    38.922     0.200
     1.273    39.430     0.200
     1.428    44.641     0.200
     1.899    56.117     0.200
     1.897    58.219     0.200
     1.985    61.867     0.200
     2.674    80.328     0.200
     3.309    95.750     0.200
     0.637    21.107     0.200
     0.925    30.707     0.200
     1.164    37.918     0.200
     1.164    37.387     0.200
     1.290    40.197     0.200
     1.856    57.107     0.200
     1.958    60.229     0.200
     0.628    21.066     0.200
     0.955    30.617     0.200
     1.196    38.586     0.200
     1.196    38.266     0.200
     1.207    37.326     0.200
     1.305    40.766     0.200
     1.450    44.547     0.200
     1.726    52.486     0.200
     1.726    51.307     0.200
     1.876    54.947     0.200
     1.893    58.057     0.200
     1.995    60.236     0.200
     0.777    25.500     0.200
     1.039    32.930     0.200
     1.264    40.461     0.200
     1.388    42.578     0.200
     1.399    44.531     0.200
     0.924    28.930     0.200
     0.924    31.055     0.200
     1.184    36.234     0.200
     1.209    37.680     0.200
     1.406    42.820     0.200
     1.436    43.984     0.200
     1.436    43.461     0.200
     1.537    49.609     0.200
     1.669    50.227     0.200
     1.669    49.359     0.200
     2.321    71.148     0.200
     2.971    85.938     0.200
     0.932    29.602     0.200
     1.190    36.801     0.200
     1.189    36.648     0.200
     1.189    38.258     0.200
     1.391    41.781     0.200
     1.456    43.121     0.200
     1.456    44.008     0.200
     1.686    50.340     0.200
     0.746    24.762     0.200
     0.929    30.711     0.200
     1.185    37.594     0.200
     1.155    36.762     0.200
     1.490    44.684     0.200
     1.490    44.551     0.200
     1.356    42.012     0.200
     1.722    51.531     0.200
     1.508    45.051     0.200
     3.026    91.422     0.200
     3.249    94.691     0.200
     0.903    28.742     0.200
     1.111    35.363     0.200
     1.111    35.152     0.200
     1.294    39.232     0.200
     1.802    52.432     0.200
     1.804    53.812     0.200
     3.623   104.152     0.200
     0.923    29.229     0.200
     1.162    35.547     0.200
     1.162    36.229     0.200
     1.235    38.188     0.200
     1.288    39.578     0.200
     1.475    44.438     0.200
     1.854    55.828     0.200
     1.910    55.387     0.200
     1.955    57.938     0.200
     3.340    96.678     0.200
     3.332    97.348     0.200
     0.926    29.605     0.200
     1.093    33.305     0.200
     1.093    33.934     0.200
     1.307    39.543     0.200
     1.327    40.594     0.200
     1.548    46.375     0.200
     1.796    54.164     0.200
     1.915    55.664     0.200
     1.923    59.293     0.200
     3.298    99.035     0.200
     4.250   122.559     0.200
     0.632    20.980     0.200
     0.939    30.992     0.200
     1.176    37.102     0.200
     1.176    39.273     0.200
     1.298    40.641     0.200
     1.746    52.730     0.200
     1.871    57.211     0.200
     1.974    59.863     0.200
     2.674    80.531     0.200
     0.609    20.645     0.200
     0.942    31.035     0.200
     1.145    35.973     0.200
     1.257    39.125     0.200
     1.317    41.496     0.200
     1.499    45.836     0.200
     1.756    52.105     0.200
     1.845    55.824     0.200
     1.892    55.883     0.200
     1.961    59.543     0.200
     0.612    20.598     0.200
     0.945    29.871     0.200
     1.155    35.238     0.200
     1.155    36.621     0.200
     1.247    39.371     0.200
     1.315    40.758     0.200
     1.489    46.500     0.200
     1.749    52.141     0.200
     1.749    51.570     0.200
     1.855    55.570     0.200
     1.855    59.508     0.200
     1.888    55.828     0.200
     1.888    55.238     0.200
     1.968    59.949     0.200
     2.675    76.777     0.200
     3.379    98.238     0.200
     0.675    22.383     0.200
     0.930    30.793     0.200
     1.226    40.403     0.200
     1.226    40.683     0.200
     1.262    40.083     0.200
     1.910    59.893     0.200
     1.902    57.183     0.200
     3.388   101.163     0.200
     0.673    22.061     0.200
     0.940    30.811     0.200
     1.161    36.920     0.200
     1.267    40.301     0.200
     1.401    44.221     0.200
     1.892    57.270     0.200
     1.922    59.641     0.200
     2.003    60.320     0.200
     2.686    82.080     0.200
     0.761    24.105     0.200
     1.055    32.375     0.200
     0.919    30.115     0.200
     1.154    36.395     0.200
     1.475    45.395     0.200
     1.475    46.635     0.200
     1.516    46.484     0.200
     3.279    97.586     0.200
     4.034   117.725     0.200
     0.738    24.723     0.200
     0.924    29.922     0.200
     1.182    37.133     0.200
     1.193    37.863     0.200
     1.452    44.162     0.200
     1.452    43.832     0.200
     1.391    43.922     0.200
     1.685    50.502     0.200
     1.685    53.133     0.200
     1.685    50.273     0.200
     2.307    67.973     0.200
     1.144    37.371     0.200
     1.182    38.312     0.200
     1.182    38.672     0.200
     1.154    36.762     0.200
     1.448    45.012     0.200
     1.448    44.613     0.200
     1.465    46.621     0.200
     1.622    50.422     0.200
     0.589    19.613     0.200
     0.996    32.953     0.200
     1.048    32.824     0.200
     1.059    33.754     0.200
     1.079    34.074     0.200
     1.220    39.223     0.200
     1.342    41.553     0.200
     1.352    44.254     0.200
     1.593    48.533     0.200
     1.593    47.453     0.200
     1.667    51.574     0.200
     2.117    64.094     0.200
     0.242     8.457     0.200
     1.342    42.347     0.200
     1.342    42.477     0.200
     1.337    42.267     0.200
     1.337    42.737     0.200
     1.378    42.557     0.200
     1.378    45.247     0.200
     1.378    43.077     0.200
     1.419    44.357     0.200
     1.506    46.737     0.200
     1.506    47.887     0.200
     1.481    47.527     0.200
     2.428    74.647     0.200
     2.963    90.297     0.200
     0.815    26.062     0.200
     1.082    34.051     0.200
     1.209    38.520     0.200
     1.209    38.770     0.200
     1.283    39.562     0.200
     1.508    48.211     0.200
     1.563    47.062     0.200
     1.563    51.340     0.200
     1.671    50.699     0.200
     2.879    86.520     0.200
     3.276    96.691     0.200
     0.824    27.158     0.200
     1.089    34.199     0.200
     1.196    37.639     0.200
     1.266    40.588     0.200
     1.266    38.748     0.200
     1.545    46.389     0.200
     1.526    47.789     0.200
     1.655    49.758     0.200
     3.290    95.979     0.200
     0.564    17.953     0.200
     0.798    24.613     0.200
     0.972    31.855     0.200
     0.970    30.812     0.200
     0.970    30.914     0.200
     0.969    31.273     0.200
     0.987    32.895     0.200
     1.034    32.355     0.200
     1.028    32.723     0.200
     1.058    33.312     0.200
     1.104    35.953     0.200
     1.195    37.363     0.200
     1.195    37.953     0.200
     1.312    39.914     0.200
     1.584    48.023     0.200
     0.552    17.510     0.200
     0.551    17.580     0.200
     0.813    26.330     0.200
     0.813    26.199     0.200
     0.940    31.109     0.200
     0.941    31.170     0.200
     0.945    29.020     0.200
     0.958    31.061     0.200
     0.958    31.680     0.200
     1.034    32.539     0.200
     1.032    32.141     0.200
     1.032    32.570     0.200
     1.183    37.670     0.200
     1.283    39.260     0.200
     1.331    40.100     0.200
     1.337    42.510     0.200
     1.763    52.609     0.200
     0.558    19.695     0.200
     0.619    19.914     0.200
     0.619    20.223     0.200
     1.014    32.414     0.200
     1.055    34.383     0.200
     1.084    34.062     0.200
     1.084    34.594     0.200
     1.250    39.285     0.200
     1.250    40.012     0.200
     1.268    40.652     0.200
     1.331    41.363     0.200
     1.370    41.902     0.200
     1.409    46.434     0.200
     1.630    49.762     0.200
     1.630    50.945     0.200
     1.832    55.125     0.200
     2.006    60.254     0.200
     2.188    64.953     0.200
     3.114    92.953     0.200
     0.526    19.105     0.200
     0.658    20.867     0.200
     0.593    18.855     0.200
     0.592    18.734     0.200
     1.036    33.445     0.200
     1.067    34.078     0.200
     1.224    38.465     0.200
     1.224    38.805     0.200
     1.235    39.598     0.200
     1.618    49.957     0.200
     1.596    51.266     0.200
     0.566    18.094     0.200
     0.565    18.141     0.200
     0.802    25.961     0.200
     0.797    26.312     0.200
     0.797    25.242     0.200
     0.970    30.641     0.200
     0.968    31.117     0.200
     0.968    31.625     0.200
     0.987    32.461     0.200
     1.036    33.141     0.200
     1.028    32.773     0.200
     1.057    33.758     0.200
     1.105    36.062     0.200
     1.116    36.133     0.200
     1.197    36.492     0.200
     1.197    38.367     0.200
     1.414    41.906     0.200
     1.586    48.094     0.200
     1.586    50.867     0.200
     0.507    18.727     0.200
     0.573    18.047     0.200
     0.573    19.406     0.200
     0.573    18.055     0.200
     0.680    22.430     0.200
     0.958    31.828     0.200
     1.053    33.305     0.200
     1.053    32.844     0.200
     1.028    32.805     0.200
     1.204    37.789     0.200
     1.212    38.977     0.200
     1.286    40.188     0.200
     1.321    41.625     0.200
     1.356    45.406     0.200
     1.606    49.133     0.200
     1.606    48.883     0.200
     1.776    55.125     0.200
     0.551    17.898     0.200
     0.550    18.195     0.200
     0.550    18.602     0.200
     0.726    23.305     0.200
     0.824    26.648     0.200
     0.824    26.164     0.200
     0.949    32.797     0.200
     0.983    32.891     0.200
     1.048    33.617     0.200
     1.232    39.008     0.200
     1.278    39.719     0.200
     1.392    43.055     0.200
     1.610    49.727     0.200
     1.724    54.109     0.200
     0.558    17.953     0.200
     0.558    18.062     0.200
     0.813    26.273     0.200
     0.923    30.625     0.200
     0.923    30.867     0.200
     0.998    32.758     0.200
     1.050    33.375     0.200
     1.050    33.195     0.200
     1.250    39.398     0.200
     1.331    41.766     0.200
     1.411    43.172     0.200
     1.609    49.406     0.200
     3.167    95.477     0.200
     0.566    18.293     0.200
     0.566    18.293     0.200
     0.943    30.743     0.200
     0.951    31.344     0.200
     1.026    33.523     0.200
     1.047    33.303     0.200
     1.281    40.213     0.200
     1.442    44.573     0.200
     1.602    48.763     0.200
     1.063    34.125     0.200
     1.197    37.715     0.200
     1.197    37.535     0.200
     1.279    40.725     0.200
     1.279    40.065     0.200
     1.567    47.605     0.200
     1.567    47.135     0.200
     2.001    59.815     0.200
     2.788    80.915     0.200
     0.514    17.098     0.200
     0.690    22.488     0.200
     0.690    22.608     0.200
     0.708    22.758     0.200
     1.102    34.938     0.200
     1.102    34.798     0.200
     1.222    37.728     0.200
     1.327    41.798     0.200
     1.327    42.478     0.200
     1.326    41.218     0.200
     1.412    44.678     0.200
     1.550    48.838     0.200
     1.614    49.878     0.200
     0.554    17.773     0.200
     0.757    24.992     0.200
     0.678    22.961     0.200
     0.840    27.070     0.200
     0.834    27.930     0.200
     0.845    27.578     0.200
     0.867    28.164     0.200
     0.931    28.828     0.200
     0.991    32.703     0.200
     1.068    32.820     0.200
     1.068    33.484     0.200
     1.179    35.398     0.200
     1.635    48.695     0.200
     0.593    19.664     0.200
     0.642    21.473     0.200
     0.642    21.211     0.200
     0.642    20.781     0.200
     1.013    32.113     0.200
     1.270    39.234     0.200
     1.251    42.844     0.200
     1.251    40.312     0.200
     1.251    40.574     0.200
     1.322    41.242     0.200
     1.466    47.324     0.200
     1.520    46.113     0.200
     2.228    67.664     0.200
     2.291    68.512     0.200
     3.175    93.344     0.200
     0.630    21.203     0.200
     0.630    18.996     0.200
     0.601    19.875     0.200
     1.008    31.645     0.200
     1.242    38.684     0.200
     1.520    45.586     0.200
     0.654    21.535     0.200
     0.653    21.535     0.200
     0.653    20.738     0.200
     1.019    31.988     0.200
     1.280    39.719     0.200
     1.261    38.426     0.200
     1.261    40.785     0.200
     1.382    42.977     0.200
     1.524    45.719     0.200
     3.169    91.727     0.200
     1.039    34.238     0.200
     1.013    31.969     0.200
     1.299    39.117     0.200
     1.260    38.539     0.200
     1.260    40.828     0.200
     1.260    42.758     0.200
     1.450    42.918     0.200
     1.390    42.008     0.200
     1.513    44.707     0.200
     1.513    45.387     0.200
     1.513    44.488     0.200
     0.539    17.930     0.200
     0.682    21.648     0.200
     0.682    21.668     0.200
     0.960    31.238     0.200
     1.099    34.078     0.200
     1.108    35.867     0.200
     1.132    36.199     0.200
     1.128    35.680     0.200
     1.170    36.098     0.200
     1.371    43.520     0.200
     1.495    46.129     0.200
     0.604    19.783     0.200
     0.604    20.045     0.200
     1.026    32.373     0.200
     1.026    32.584     0.200
     1.165    36.584     0.200
     1.229    37.443     0.200
     1.416    42.635     0.200
     1.557    46.545     0.200
     1.816    54.123     0.200
     0.602    20.352     0.200
     0.602    19.969     0.200
     0.603    20.055     0.200
     0.620    20.609     0.200
     0.769    24.617     0.200
     1.064    34.906     0.200
     1.079    33.805     0.200
     1.033    32.422     0.200
     1.033    33.211     0.200
     1.145    37.156     0.200
     1.209    38.219     0.200
     1.229    37.758     0.200
     1.229    39.445     0.200
     1.292    40.469     0.200
     1.408    45.055     0.200
     1.453    43.531     0.200
     1.413    44.031     0.200
     1.567    49.734     0.200
     0.348    11.684     0.200
     0.348    11.941     0.200
     1.228    38.691     0.200
     1.228    39.730     0.200
     1.192    37.543     0.200
     1.192    37.262     0.200
     1.382    43.980     0.200
     0.624    21.645     0.200
     0.601    18.434     0.200
     0.600    20.305     0.200
     0.621    20.844     0.200
     1.065    34.844     0.200
     1.066    34.703     0.200
     1.066    34.824     0.200
     1.030    32.375     0.200
     1.126    36.254     0.200
     1.148    36.562     0.200
     1.210    40.055     0.200
     1.226    37.684     0.200
     1.226    38.172     0.200
     1.410    45.445     0.200
     1.411    44.152     0.200
     1.570    49.184     0.200
     1.563    47.004     0.200
     1.563    50.195     0.200
     1.617    50.375     0.200
     3.801   113.934     0.200
     4.643   135.285     0.200
     0.369    12.612     0.200
     0.369    13.093     0.200
     1.201    37.152     0.200
     1.201    37.853     0.200
     1.201    36.683     0.200
     1.266    38.282     0.200
     1.266    39.022     0.200
     1.365    42.462     0.200
     1.365    43.232     0.200
     1.350    42.393     0.200
     1.638    49.112     0.200
     1.638    52.582     0.200
     1.638    53.252     0.200
     1.572    49.702     0.200
     1.896    55.782     0.200
     0.603    20.145     0.200
     0.618    20.453     0.200
     0.780    24.824     0.200
     1.015    32.475     0.200
     1.225    39.303     0.200
     1.225    40.064     0.200
     1.225    41.014     0.200
     1.242    41.623     0.200
     1.309    41.863     0.200
     1.421    47.414     0.200
     1.541    47.895     0.200
     1.561    49.334     0.200
     0.618    20.297     0.200
     0.618    19.984     0.200
     0.604    20.406     0.200
     0.770    24.887     0.200
     1.238    39.414     0.200
     1.238    41.926     0.200
     1.238    39.707     0.200
     1.325    41.977     0.200
     1.547    48.105     0.200
     1.547    49.766     0.200
     0.602    19.871     0.200
     0.619    20.230     0.200
     0.618    20.211     0.200
     1.088    36.371     0.200
     1.039    32.512     0.200
     1.039    33.211     0.200
     1.090    33.973     0.200
     1.167    36.812     0.200
     1.235    40.781     0.200
     1.243    39.172     0.200
     1.243    41.871     0.200
     1.243    39.723     0.200
     1.314    41.512     0.200
     1.568    47.480     0.200
     1.568    48.012     0.200
     2.550    76.621     0.200
     3.147    94.871     0.200
     0.597    20.141     0.200
     0.624    20.172     0.200
     0.623    20.000     0.200
     0.762    24.461     0.200
     1.032    33.211     0.200
     1.032    32.992     0.200
     1.193    37.023     0.200
     1.245    39.070     0.200
     1.245    39.734     0.200
     1.556    46.555     0.200
     1.556    46.961     0.200
     0.578    19.285     0.200
     0.643    20.516     0.200
     0.643    20.414     0.200
     0.740    23.832     0.200
     1.054    33.113     0.200
     1.054    33.395     0.200
     1.265    39.773     0.200
     1.265    41.293     0.200
     1.342    42.742     0.200
     1.578    50.652     0.200
     1.655    51.105     0.200
     1.925    58.715     0.200
     0.683    22.583     0.200
     0.988    31.453     0.200
     1.167    36.243     0.200
     1.246    37.522     0.200
     1.479    43.863     0.200
     1.479    44.373     0.200
     1.465    45.593     0.200
     1.690    49.502     0.200
     1.690    49.812     0.200
     1.886    55.713     0.200
     0.578    18.383     0.200
     0.578    18.395     0.200
     0.816    26.742     0.200
     0.784    25.172     0.200
     0.978    32.133     0.200
     0.983    30.125     0.200
     0.983    30.984     0.200
     1.001    32.102     0.200
     1.040    33.594     0.200
     1.040    33.473     0.200
     1.064    33.473     0.200
     1.044    32.824     0.200
     1.209    37.805     0.200
     1.209    38.172     0.200
     1.209    39.543     0.200
     1.371    43.133     0.200
     2.037    63.055     0.200
     0.368    14.109     0.200
     0.928    28.499     0.200
     0.928    29.109     0.200
     0.834    26.699     0.200
     0.807    26.139     0.200
     0.821    26.959     0.200
     0.962    29.159     0.200
     0.944    30.689     0.200
     0.951    31.679     0.200
     0.982    31.389     0.200
     0.982    31.279     0.200
     1.059    34.659     0.200
     1.169    37.039     0.200
     1.671    52.489     0.200
     1.752    55.529     0.200
     1.849    58.089     0.200
     1.930    60.049     0.200
     2.085    65.089     0.200
     2.127    65.519     0.200
     2.157    67.149     0.200
     2.174    67.749     0.200
     2.260    70.269     0.200
     2.312    72.079     0.200
     2.319    71.609     0.200
     2.444    75.159     0.200
     3.291    97.319     0.200
     0.802    25.616     0.200
     0.828    26.656     0.200
     0.816    26.646     0.200
     0.928    27.256     0.200
     0.928    28.426     0.200
     0.986    31.246     0.200
     0.986    31.136     0.200
     1.305    38.426     0.200
     1.477    45.586     0.200
     1.542    46.526     0.200
     0.236     8.078     0.200
     0.354    13.648     0.200
     0.565    19.199     0.200
     0.642    20.277     0.200
     0.755    24.320     0.200
     0.945    30.387     0.200
     1.088    34.117     0.200
     1.088    33.887     0.200
     1.351    42.090     0.200
     1.437    44.418     0.200
     1.662    50.637     0.200
     1.689    51.668     0.200
     0.238     8.352     0.200
     0.238     8.371     0.200
     0.967    30.562     0.200
     1.123    34.242     0.200
     1.225    37.133     0.200
     1.334    40.043     0.200
     1.430    43.832     0.200
     1.475    45.043     0.200
     1.929    58.641     0.200
     1.963    58.699     0.200
     0.387    13.297     0.200
     0.473    13.773     0.200
     0.826    26.816     0.200
     0.840    27.605     0.200
     0.849    28.254     0.200
     0.849    27.816     0.200
     0.892    28.727     0.200
     0.971    32.047     0.200
     0.972    30.016     0.200
     0.912    28.996     0.200
     0.912    29.555     0.200
     1.036    33.375     0.200
     0.987    31.914     0.200
     0.987    31.184     0.200
     0.987    32.465     0.200
     1.099    33.273     0.200
     1.230    41.895     0.200
     1.314    39.766     0.200
     1.954    56.594     0.200
     0.651    22.574     0.200
     0.841    27.773     0.200
     0.834    27.883     0.200
     0.884    28.691     0.200
     0.964    29.352     0.200
     0.964    29.883     0.200
     0.956    31.324     0.200
     0.913    28.715     0.200
     0.913    29.293     0.200
     0.964    31.203     0.200
     0.992    31.684     0.200
     0.992    30.895     0.200
     1.075    34.191     0.200
     1.174    35.902     0.200
     1.100    33.414     0.200
     1.100    32.973     0.200
     1.100    35.523     0.200
     1.229    36.414     0.200
     0.497    16.629     0.200
     0.846    27.770     0.200
     0.842    28.762     0.200
     0.891    29.430     0.200
     0.891    29.570     0.200
     0.965    31.691     0.200
     0.965    31.961     0.200
     0.890    27.961     0.200
     1.012    32.551     0.200
     1.094    35.109     0.200
     1.094    37.422     0.200
     1.122    34.102     0.200
     1.122    36.512     0.200
     1.122    36.961     0.200
     1.179    37.160     0.200
     0.533    17.016     0.200
     0.534    17.277     0.200
     0.857    28.555     0.200
     0.857    28.098     0.200
     0.877    28.938     0.200
     0.856    29.188     0.200
     0.850    28.395     0.200
     0.914    29.266     0.200
     1.042    32.777     0.200
     0.991    32.266     0.200
     1.160    36.445     0.200
     1.160    36.176     0.200
     1.160    36.918     0.200
     1.134    36.227     0.200
     1.117    35.797     0.200
     1.279    40.035     0.200
     0.794    25.527     0.200
     0.924    28.707     0.200
     0.924    28.848     0.200
     0.924    29.688     0.200
     0.943    29.898     0.200
     0.997    32.078     0.200
     0.997    31.469     0.200
     1.095    35.707     0.200
     1.095    36.148     0.200
     1.095    36.809     0.200
     1.149    36.000     0.200
     1.216    36.930     0.200
     1.216    37.438     0.200
     1.216    36.777     0.200
     1.306    39.789     0.200
     1.292    40.629     0.200
     0.489    16.004     0.200
     0.817    26.586     0.200
     0.833    27.555     0.200
     0.902    26.617     0.200
     0.902    27.445     0.200
     0.902    29.066     0.200
     0.952    29.957     0.200
     1.007    32.145     0.200
     1.007    31.547     0.200
     1.113    34.625     0.200
     1.113    36.727     0.200
     1.292    39.047     0.200
     1.433    42.637     0.200
     1.483    43.617     0.200
     1.947    62.336     0.200
     0.762    24.902     0.200
     0.696    22.781     0.200
     1.197    39.121     0.200
     1.197    38.543     0.200
     1.071    34.441     0.200
     1.071    35.312     0.200
     1.264    40.352     0.200
     1.387    45.492     0.200
     1.308    41.223     0.200
     1.308    42.332     0.200
     1.415    44.242     0.200
     1.415    44.391     0.200
     1.519    49.980     0.200
     2.337    70.344     0.200
     0.953    32.533     0.200
     0.725    22.934     0.200
     1.167    36.543     0.200
     1.514    48.033     0.200
     1.598    52.014     0.200
     1.564    48.484     0.200
     1.845    57.273     0.200
     0.620    20.112     0.200
     1.018    34.982     0.200
     1.018    32.062     0.200
     1.032    32.242     0.200
     1.039    34.003     0.200
     1.092    34.582     0.200
     1.072    33.633     0.200
     1.072    34.263     0.200
     1.072    33.173     0.200
     1.086    34.763     0.200
     1.250    39.562     0.200
     1.250    40.332     0.200
     1.250    40.633     0.200
     1.250    38.792     0.200
     1.286    41.122     0.200
     0.619    19.268     0.200
     1.075    33.328     0.200
     1.075    34.389     0.200
     1.005    34.488     0.200
     1.040    33.998     0.200
     1.079    34.049     0.200
     1.250    39.119     0.200
     1.250    41.188     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.531    82.496     0.200
     2.711    86.705     0.200
     3.131    98.539     0.200
     3.231   102.503     0.200
     3.499   111.073     0.200
     3.873   120.837     0.200
     2.954    92.859     0.200
     3.180    99.461     0.200
     3.228   100.695     0.200
     3.366   105.453     0.200
     3.442   107.430     0.200
     3.113    99.629     0.200
     2.615    82.047     0.200
     7.039   225.625     0.200
     7.428   237.414     0.200
     8.139   256.469     0.200
     9.127   288.516     0.200
     9.573   303.914     0.200
     3.942   122.180     0.200
     4.035   127.367     0.200
     3.826   118.232     0.200
     4.077   129.713     0.200
     4.813   154.293     0.200
     4.907   157.463     0.200
     5.234   166.282     0.200
     5.463   175.603     0.200
     5.977   193.043     0.200
     6.770   219.822     0.200
     6.970   223.093     0.200
     7.414   236.963     0.200
     7.697   243.753     0.200
     7.979   252.112     0.200
     9.136   291.487     0.200
     9.819   312.914     0.200
     4.185   132.289     0.200
     6.721   217.533     0.200
     8.289   260.225     0.200
     9.160   293.289     0.200
     7.636   237.238     0.200
     9.025   286.914     0.200
     9.025   286.914     0.200
    10.131   327.762     0.200
    12.601   403.145     0.200
     3.689   116.344     0.200
     5.385   172.258     0.200
     7.225   236.180     0.200
     7.680   244.453     0.200
     7.680   245.055     0.200
     8.608   278.859     0.200
     9.024   284.031     0.200
    12.666   396.133     0.200
    13.172   422.547     0.200
     2.876    90.383     0.200
     3.229   100.844     0.200
     3.398   109.578     0.200
     3.828   122.730     0.200
     4.187   129.844     0.200
     4.789   157.965     0.200
     5.307   164.059     0.200
     7.073   223.469     0.200
     7.860   245.203     0.200
     8.775   279.109     0.200
     9.075   285.453     0.200
    10.399   329.434     0.200
    24.098   767.285     0.200
     3.244   103.152     0.200
     3.625   114.155     0.200
     3.851   124.502     0.200
     4.787   150.276     0.200
     4.938   153.985     0.200
     5.315   165.618     0.200
     5.614   174.933     0.200
     5.655   176.501     0.200
     5.798   179.683     0.200
     7.623   246.480     0.200
     7.942   248.603     0.200
     8.810   279.282     0.200
     9.127   286.458     0.200
    12.960   402.107     0.200
    13.346   407.260     0.200
    18.081   569.523     0.200
     3.645   116.602     0.200
     8.609   276.305     0.200
     9.260   295.832     0.200
    12.831   401.156     0.200
    13.140   404.293     0.200
    17.901   560.793     0.200
    26.003   825.375     0.200
     2.758    87.508     0.200
     3.111    98.922     0.200
     3.500   107.953     0.200
     3.713   118.133     0.200
     4.068   124.938     0.200
     8.669   286.734     0.200
     7.373   244.117     0.200
     7.484   235.469     0.200
     9.025   293.148     0.200
     9.668   302.184     0.200
     3.866   120.737     0.200
     5.985   194.711     0.200
     6.221   201.876     0.200
     6.479   212.156     0.200
     7.037   222.437     0.200
     8.151   248.262     0.200
     8.853   282.242     0.200
     9.296   289.417     0.200
    10.557   333.067     0.200
    13.118   412.273     0.200
     3.880   122.873     0.200
     3.880   123.273     0.200
     4.204   130.533     0.200
     4.753   148.871     0.200
     4.945   154.456     0.200
     5.628   174.030     0.200
     7.023   220.948     0.200
     8.135   252.573     0.200
     8.864   281.953     0.200
     9.273   287.949     0.200
    10.561   333.853     0.200
    13.114   407.403     0.200
    13.377   417.961     0.200
    22.001   695.548     0.200
    26.129   819.172     0.200
     3.391   106.113     0.200
     3.585   116.965     0.200
     7.840   253.738     0.200
     9.219   291.984     0.200
    12.722   403.840     0.200
     2.735    86.543     0.200
     2.936    91.601     0.200
     3.067    94.692     0.200
     3.283   102.446     0.200
     3.160    97.582     0.200
     3.167    97.953     0.200
     2.981    91.410     0.200
     3.328   100.680     0.200
     3.690   121.719     0.200
     3.956   122.324     0.200
     4.710   142.762     0.200
     5.279   160.582     0.200
     5.905   188.621     0.200
     5.983   190.785     0.200
     6.075   184.785     0.200
     6.037   194.926     0.200
     6.320   202.293     0.200
     6.276   200.340     0.200
     6.516   198.688     0.200
     6.947   224.527     0.200
     8.155   250.176     0.200
     8.941   279.309     0.200
     9.240   287.199     0.200
     9.298   288.898     0.200
     9.720   309.148     0.200
    12.285   389.320     0.200
     3.300   110.117     0.200
     9.240   295.148     0.200
     9.833   317.547     0.200
    12.378   406.039     0.200
     3.167    98.453     0.200
     7.005   221.988     0.200
     7.727   237.262     0.200
     8.915   269.193     0.200
    10.404   339.993     0.200
     2.931    93.986     0.200
     7.559   232.837     0.200
     9.433   287.317     0.200
     9.471   312.293     0.200
    12.082   386.782     0.200
     7.588   249.082     0.200
     9.416   300.642     0.200
     3.498   116.613     0.200
     9.138   275.531     0.200
    10.023   313.672     0.200
     7.771   247.070     0.200
     8.886   278.250     0.200
     3.128    98.965     0.200
     3.899   122.508     0.200
     7.001   212.461     0.200
     8.088   261.859     0.200
     9.219   292.555     0.200
    10.558   337.602     0.200
    13.093   419.766     0.200
     3.939   124.086     0.200
     6.959   214.711     0.200
     8.006   253.688     0.200
     8.905   279.125     0.200
     9.123   284.816     0.200
    10.557   330.969     0.200
    13.059   409.727     0.200
     7.734   245.676     0.200
     8.529   273.896     0.200
     9.127   286.525     0.200
    10.144   325.531     0.200
     3.085    95.289     0.200
     3.519   113.164     0.200
     7.723   242.562     0.200
     9.170   282.695     0.200
    10.071   313.172     0.200
     2.693    91.586     0.200
     7.568   237.059     0.200
     7.600   247.242     0.200
     9.261   301.566     0.200
     9.593   305.293     0.200
    11.927   387.602     0.200
     4.211   130.674     0.200
     9.199   285.295     0.200
     9.152   276.342     0.200
     4.253   133.021     0.200
     9.158   287.150     0.200
     2.994   102.414     0.200
     7.513   237.439     0.200
     7.889   263.645     0.200
     9.360   293.223     0.200
     9.503   306.619     0.200
    12.087   389.695     0.200
     3.378   107.105     0.200
     7.710   244.277     0.200
     9.253   295.930     0.200
     2.609    81.715     0.200
     9.234   293.539     0.200
     7.401   231.211     0.200
     7.525   233.677     0.200
     8.432   274.627     0.200
     9.065   284.607     0.200
     9.684   306.407     0.200
    11.761   371.758     0.200
    11.969   378.256     0.200
    16.680   523.227     0.200
    23.195   726.758     0.200
     4.229   135.320     0.200
     6.679   213.492     0.200
     8.257   256.094     0.200
     9.150   279.375     0.200
     9.217   293.102     0.200
     4.464   141.567     0.200
     6.436   202.577     0.200
     8.181   256.529     0.200
     8.923   280.537     0.200
     9.435   303.197     0.200
    11.068   353.148     0.200
    13.493   424.430     0.200
    24.613   782.814     0.200
     4.225   134.836     0.200
     8.151   264.761     0.200
     9.058   288.242     0.200
     7.693   245.844     0.200
     8.423   273.250     0.200
     9.162   286.625     0.200
    12.556   405.301     0.200
     3.648   116.191     0.200
     4.463   152.168     0.200
     8.020   250.141     0.200
     8.781   265.875     0.200
     9.413   308.613     0.200
    11.001   356.621     0.200
    13.381   426.723     0.200
     8.037   253.738     0.200
     8.795   274.523     0.200
     9.417   300.301     0.200
     4.442   141.492     0.200
     8.057   253.242     0.200
     8.828   275.773     0.200
     3.713   116.376     0.200
     8.020   255.059     0.200
     8.823   266.613     0.200
     9.354   313.402     0.200
    13.344   430.930     0.200
     4.409   146.031     0.200
     8.058   248.883     0.200
     8.852   270.238     0.200
     9.367   302.551     0.200
    10.973   348.613     0.200
    13.376   420.688     0.200
     4.381   150.945     0.200
     7.974   252.797     0.200
     8.797   270.648     0.200
    10.913   353.156     0.200
    13.300   425.727     0.200
     4.389   144.867     0.200
     8.007   253.367     0.200
     3.585   112.105     0.200
     4.426   156.645     0.200
     8.779   261.195     0.200
     9.372   307.779     0.200
    10.956   351.650     0.200
     8.783   270.047     0.200
     4.337   143.314     0.200
     7.916   251.182     0.200
     8.778   272.250     0.200
     8.784   276.723     0.200
     4.371   147.422     0.200
     7.973   251.520     0.200
     8.804   270.051     0.200
     4.347   146.200     0.200
     7.938   250.825     0.200
     8.790   268.706     0.200
     7.948   251.227     0.200
     8.771   268.982     0.200
     4.347   150.824     0.200
     7.941   252.824     0.200
     8.792   271.105     0.200
     4.420   147.756     0.200
     7.985   251.067     0.200
     8.780   268.312     0.200
     9.366   306.373     0.200
    10.950   355.659     0.200
    13.330   430.916     0.200
     2.802    90.342     0.200
     2.802    88.441     0.200
     4.450   142.791     0.200
     8.010   251.590     0.200
     8.782   270.074     0.200
     9.399   301.521     0.200
    10.986   349.721     0.200
     4.400   142.348     0.200
     7.967   250.598     0.200
     8.779   270.734     0.200
     9.345   294.180     0.200
    10.926   342.930     0.200
    13.306   423.473     0.200
     4.372   151.086     0.200
     7.938   255.387     0.200
     8.772   270.031     0.200
     4.460   148.281     0.200
     8.154   260.633     0.200
     8.902   277.211     0.200
     7.964   246.551     0.200
     8.781   268.715     0.200
     4.435   148.641     0.200
     8.010   257.664     0.200
     8.792   272.047     0.200
     8.824   273.820     0.200
    10.907   347.570     0.200
     4.243   140.873     0.200
     8.694   280.354     0.200
     9.156   298.678     0.200
    13.047   426.027     0.200
     4.385   148.049     0.200
     7.998   252.648     0.200
     8.816   272.178     0.200
    13.320   429.797     0.200
     8.813   263.230     0.200
     9.297   311.189     0.200
    13.278   432.564     0.200
     7.989   249.414     0.200
     8.811   269.334     0.200
    10.918   347.973     0.200
    13.310   420.010     0.200
     4.418   149.051     0.200
     8.001   258.594     0.200
     8.796   269.234     0.200
     9.366   305.387     0.200
    10.955   355.523     0.200
    13.341   432.699     0.200
     4.416   142.461     0.200
     7.968   250.406     0.200
     8.769   271.312     0.200
    10.940   351.641     0.200
    13.316   425.188     0.200
     4.408   148.695     0.200
     7.997   258.891     0.200
     8.799   274.172     0.200
    10.945   357.828     0.200
    13.332   435.203     0.200
     3.223   101.758     0.200
     2.597    81.211     0.200
     4.358   150.125     0.200
     7.954   249.824     0.200
     8.796   268.031     0.200
    13.272   425.418     0.200
     2.608    83.751     0.200
     7.988   260.662     0.200
     8.782   274.717     0.200
     4.437   141.648     0.200
     8.044   251.125     0.200
     8.820   271.781     0.200
     4.406   156.180     0.200
     8.017   255.883     0.200
     8.818   269.000     0.200
     9.358   312.156     0.200
    10.952   363.016     0.200
    13.345   434.945     0.200
     8.051   254.086     0.200
     8.846   272.148     0.200
     9.364   307.422     0.200
    13.370   430.242     0.200
     3.530   111.227     0.200
     4.419   140.325     0.200
     8.032   244.575     0.200
     8.822   272.081     0.200
     9.372   298.131     0.200
    10.969   344.831     0.200
    13.363   419.183     0.200
     4.416   147.680     0.200
     7.986   246.881     0.200
     8.784   269.746     0.200
     4.453   149.387     0.200
     8.038   253.461     0.200
     8.804   269.973     0.200
     8.027   263.125     0.200
     8.794   273.902     0.200
     4.365   151.461     0.200
     7.972   263.484     0.200
     8.806   274.242     0.200
     3.428   109.586     0.200
     3.591   113.477     0.200
     3.591   114.594     0.200
     3.645   119.867     0.200
     4.375   139.766     0.200
     4.948   157.078     0.200
     7.884   251.867     0.200
     8.725   275.148     0.200
    10.869   344.000     0.200
    13.231   421.727     0.200
     2.574    84.129     0.200
     8.032   252.930     0.200
     3.683   119.871     0.200
     4.416   147.090     0.200
     5.937   192.969     0.200
     8.802   271.297     0.200
     9.365   304.375     0.200
    10.956   353.797     0.200
     4.404   146.266     0.200
     8.004   248.219     0.200
     8.808   267.109     0.200
     3.557   114.473     0.200
     3.595   118.493     0.200
     4.470   153.042     0.200
     7.655   244.703     0.200
     8.047   255.842     0.200
     8.796   297.613     0.200
     8.801   271.474     0.200
     9.423   309.953     0.200
    10.104   329.753     0.200
    11.018   358.423     0.200
    13.403   433.173     0.200
     4.388   145.273     0.200
     7.985   251.109     0.200
     8.802   271.801     0.200
     9.336   299.270     0.200
    10.924   345.520     0.200
    13.312   421.152     0.200
     8.003   253.232     0.200
     8.794   269.340     0.200
    13.346   417.641     0.200
     4.448   152.574     0.200
     8.023   253.875     0.200
     8.794   263.287     0.200
     7.998   254.748     0.200
     8.788   268.979     0.200
     4.375   141.555     0.200
     7.959   245.875     0.200
     8.788   271.203     0.200
     8.003   257.531     0.200
     4.386   149.875     0.200
     8.005   253.926     0.200
     8.820   269.883     0.200
     4.458   147.281     0.200
     8.155   254.461     0.200
     8.904   274.602     0.200
     8.059   259.223     0.200
     8.824   270.837     0.200
     3.583   114.154     0.200
     7.921   252.949     0.200
     8.743   273.005     0.200
     8.011   254.115     0.200
     8.810   271.605     0.200
     4.178   145.312     0.200
     7.756   248.312     0.200
     9.096   298.164     0.200
    10.647   343.020     0.200
    13.022   416.367     0.200
     2.585    84.062     0.200
     3.431   115.250     0.200
     3.538   113.273     0.200
     3.464   117.297     0.200
     7.730   240.148     0.200
     4.196   137.742     0.200
     7.817   245.791     0.200
     8.792   270.504     0.200
     4.158   149.381     0.200
     7.818   248.756     0.200
     8.818   268.719     0.200
     3.695   123.609     0.200
     7.637   245.578     0.200
     8.606   292.266     0.200
    12.637   413.562     0.200
     4.246   137.146     0.200
     7.840   245.271     0.200
     8.776   271.928     0.200
    10.742   339.277     0.200
    13.124   414.783     0.200
     4.198   138.643     0.200
     7.817   248.666     0.200
     8.790   274.422     0.200
     7.875   250.582     0.200
     8.802   273.383     0.200
    10.761   342.891     0.200
    13.151   422.953     0.200
     4.203   145.395     0.200
     7.848   252.699     0.200
     8.813   273.559     0.200
    10.709   347.898     0.200
    13.104   418.504     0.200
     2.675    86.723     0.200
     3.616   114.673     0.200
     4.148   141.171     0.200
     7.769   246.063     0.200
     8.785   272.828     0.200
    13.013   413.436     0.200
     4.136   147.457     0.200
     7.769   248.229     0.200
     8.793   271.029     0.200
     2.956    95.344     0.200
     3.571   122.883     0.200
     7.830   252.332     0.200
     9.220   284.137     0.200
     2.749    88.158     0.200
     7.460   236.357     0.200
     7.629   240.875     0.200
     9.251   292.113     0.200
     9.484   299.287     0.200
    11.876   379.588     0.200
     2.798    87.320     0.200
     2.716    86.328     0.200
     9.515   303.211     0.200
    11.864   381.375     0.200
     7.471   229.727     0.200
     7.599   238.211     0.200
     9.227   286.711     0.200
     9.513   299.781     0.200
    11.863   369.734     0.200
    16.849   529.656     0.200
     2.946    94.168     0.200
     3.177    98.500     0.200
     7.537   235.719     0.200
     7.847   245.473     0.200
     9.408   287.973     0.200
     9.473   301.473     0.200
    12.075   385.898     0.200
     3.086    96.109     0.200
     2.825   100.678     0.200
     7.492   234.678     0.200
     7.714   254.584     0.200
     9.338   302.232     0.200
     9.456   292.334     0.200
     2.573    83.445     0.200
     3.158    98.883     0.200
     7.486   233.516     0.200
     9.321   292.906     0.200
     9.462   292.863     0.200
     3.161    98.617     0.200
     2.835    99.145     0.200
     3.776   116.871     0.200
     7.481   232.746     0.200
     7.721   251.051     0.200
     9.340   298.602     0.200
     9.442   291.203     0.200
    11.952   379.453     0.200
     3.153    97.297     0.200
     3.759   115.961     0.200
     7.774   246.901     0.200
     8.974   280.862     0.200
    10.398   337.848     0.200
    12.851   409.602     0.200
     2.731    83.899     0.200
     2.903    89.509     0.200
     7.466   238.480     0.200
     9.643   300.059     0.200
    11.807   376.453     0.200
     2.575    87.953     0.200
     7.464   243.934     0.200
     7.501   234.035     0.200
     9.624   301.086     0.200
    11.789   378.219     0.200
     3.453   124.773     0.200
     7.699   239.998     0.200
     8.381   280.928     0.200
     9.195   278.979     0.200
    10.003   322.904     0.200
    12.533   400.404     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.551    17.150     0.200
     1.801    60.070     0.200
     1.877    58.230     0.200
     1.962    60.680     0.200
     1.994    61.850     0.200
     2.087    64.520     0.200
     2.255    71.705     0.200
     2.367    76.300     0.200
     0.614    19.828     0.200
     0.901    29.859     0.200
     1.077    34.461     0.200
     1.032    33.781     0.200
     1.368    43.117     0.200
     2.179    70.273     0.200
     2.325    74.352     0.200
     0.643    20.969     0.200
     1.117    35.668     0.200
     1.482    47.590     0.200
     1.482    47.430     0.200
     1.368    42.578     0.200
     0.655    21.113     0.200
     1.117    35.793     0.200
     1.493    47.941     0.200
     1.356    42.609     0.200
     1.986    60.633     0.200
     1.986    63.062     0.200
     1.095    36.861     0.200
     1.486    48.191     0.200
     1.347    42.633     0.200
     1.984    64.840     0.200
     2.101    65.131     0.200
     0.542    16.766     0.200
     0.570    18.312     0.200
     0.570    18.469     0.200
     1.117    37.430     0.200
     0.830    26.963     0.200
     0.829    26.803     0.200
     0.895    30.243     0.200
     1.962    60.413     0.200
     2.477    77.688     0.200
     2.477    77.333     0.200
     3.436   102.723     0.200
     3.871   113.793     0.200
     4.496   134.963     0.200
     5.111   156.482     0.200
     1.599    49.594     0.200
     1.246    38.723     0.200
     1.287    40.305     0.200
     1.367    49.719     0.200
     1.369    42.039     0.200
     1.694    52.875     0.200
     2.757    82.414     0.200
     3.112    92.219     0.200
     3.223    94.547     0.200
     6.440   221.938     0.200
     0.512    16.492     0.200
     1.036    31.883     0.200
     1.037    31.953     0.200
     1.037    32.445     0.200
     1.008    32.945     0.200
     1.676    53.008     0.200
     1.481    26.359     0.200
     1.291    40.621     0.200
     1.397    43.020     0.200
     1.393    43.258     0.200
     1.395    42.949     0.200
     1.905    57.883     0.200
     4.910   149.453     0.200
     1.987    61.306     0.200
     3.038    90.132     0.200
     3.038    88.442     0.200
     4.605   156.819     0.200
     4.625   156.562     0.200
     5.967   200.142     0.200
     7.047   238.064     0.200
     1.188    38.066     0.200
     1.278    39.934     0.200
     1.403    43.684     0.200
     1.403    45.453     0.200
     1.272    39.086     0.200
     1.274    39.398     0.200
     1.487    45.727     0.200
     0.929    29.719     0.200
     1.043    33.617     0.200
     1.043    33.516     0.200
     1.042    33.676     0.200
     1.042    33.457     0.200
     1.042    34.195     0.200
     1.238    39.336     0.200
     1.352    41.898     0.200
     1.484    45.414     0.200
     1.953    62.348     0.200
     1.982    63.109     0.200
     2.490    83.168     0.200
     3.238    97.668     0.200
     1.406    44.757     0.200
     4.930   149.348     0.200
     5.290   159.834     0.200
     5.613   170.010     0.200
     1.393    44.713     0.200
     5.463   157.723     0.200
     6.190   186.883     0.200
     1.188    37.969     0.200
     1.818    56.609     0.200
     3.385   102.117     0.200
     3.946   119.492     0.200
     0.609    19.605     0.200
     0.753    24.793     0.200
     0.753    24.895     0.200
     1.004    34.074     0.200
     1.065    33.613     0.200
     1.352    42.504     0.200
     1.513    46.504     0.200
     1.564    47.395     0.200
     1.608    50.723     0.200
     1.608    51.285     0.200
     1.642    53.965     0.200
     1.765    56.766     0.200
     2.000    62.605     0.200
     2.136    63.066     0.200
     2.303    73.355     0.200
     0.570    18.951     0.200
     0.686    22.461     0.200
     0.796    26.381     0.200
     0.943    29.161     0.200
     1.201    38.041     0.200
     1.534    46.851     0.200
     1.606    49.271     0.200
     2.068    61.981     0.200
     1.353    40.575     0.200
     1.727    52.416     0.200
     1.786    58.396     0.200
     3.638   111.229     0.200
     4.234   127.988     0.200
     0.640    21.445     0.200
     0.735    23.256     0.200
     1.052    32.596     0.200
     1.052    34.115     0.200
     0.994    31.596     0.200
     1.364    41.275     0.200
     1.669    49.535     0.200
     1.886    57.455     0.200
     1.918    57.936     0.200
     1.940    58.715     0.200
     1.940    60.635     0.200
     2.185    66.965     0.200
     2.530    77.404     0.200
     2.888    86.729     0.200
     3.481   105.867     0.200
     0.875    27.398     0.200
     0.913    29.016     0.200
     1.443    44.633     0.200
     1.501    46.164     0.200
     3.397    97.562     0.200
     0.591    20.086     0.200
     0.826    26.258     0.200
     0.839    27.109     0.200
     1.018    32.328     0.200
     1.061    33.047     0.200
     1.286    39.789     0.200
     1.518    45.453     0.200
     1.595    47.078     0.200
     2.434    70.023     0.200
     0.619    20.898     0.200
     0.924    29.977     0.200
     0.880    28.289     0.200
     1.112    35.047     0.200
     1.503    46.008     0.200
     1.553    47.312     0.200
     1.693    53.891     0.200
     2.530    77.391     0.200
     3.206    93.250     0.200
     0.600    19.683     0.200
     0.995    30.953     0.200
     0.995    31.423     0.200
     1.177    36.633     0.200
     1.533    47.283     0.200
     1.555    50.053     0.200
     1.774    53.753     0.200
     0.720    23.958     0.200
     0.975    31.448     0.200
     1.112    36.498     0.200
     1.112    36.658     0.200
     1.228    38.498     0.200
     1.338    40.758     0.200
     1.813    56.558     0.200
     0.613    20.812     0.200
     0.988    31.492     0.200
     0.988    31.643     0.200
     1.235    40.402     0.200
     1.235    39.062     0.200
     1.472    46.603     0.200
     1.490    45.902     0.200
     1.490    48.893     0.200
     2.290    71.982     0.200
     0.661    22.354     0.200
     0.616    20.424     0.200
     0.616    21.443     0.200
     0.826    26.674     0.200
     0.981    31.033     0.200
     0.981    30.924     0.200
     0.981    32.323     0.200
     1.250    39.104     0.200
     1.467    45.424     0.200
     1.467    46.743     0.200
     1.467    47.674     0.200
     1.631    49.623     0.200
     2.330    69.764     0.200
     2.988    91.357     0.200
     0.609    20.309     0.200
     0.612    20.038     0.200
     1.021    31.608     0.200
     1.021    31.309     0.200
     1.021    32.628     0.200
     1.546    47.918     0.200
     1.546    48.618     0.200
     1.622    48.648     0.200
     2.241    71.219     0.200
     3.164    94.969     0.200
     4.239   124.429     0.200
     5.566   161.438     0.200
     0.708    23.207     0.200
     0.708    24.055     0.200
     0.816    26.285     0.200
     0.923    29.227     0.200
     1.038    34.984     0.200
     1.135    35.957     0.200
     1.182    38.945     0.200
     1.182    40.695     0.200
     1.596    48.484     0.200
     1.596    51.668     0.200
     1.596    51.777     0.200
     2.254    73.375     0.200
     0.585    18.980     0.200
     0.790    25.238     0.200
     1.012    32.129     0.200
     1.012    32.648     0.200
     1.270    41.660     0.200
     1.382    42.699     0.200
     1.504    45.949     0.200
     1.866    56.309     0.200
     2.269    68.879     0.200
     0.705    23.699     0.200
     0.973    31.230     0.200
     1.540    48.062     0.200
     0.665    22.430     0.200
     1.067    34.070     0.200
     1.317    40.000     0.200
     1.330    40.871     0.200
     1.598    47.090     0.200
     2.137    63.312     0.200
     0.390    13.535     0.200
     0.819    26.488     0.200
     0.819    26.945     0.200
     1.667    49.867     0.200
     1.667    50.148     0.200
     1.607    52.387     0.200
     1.662    52.258     0.200
     1.863    57.887     0.200
     1.921    59.957     0.200
     2.011    59.957     0.200
     0.395    13.422     0.200
     1.474    45.086     0.200
     1.474    47.086     0.200
     1.474    47.938     0.200
     1.793    58.547     0.200
     1.793    58.664     0.200
     2.073    61.438     0.200
     1.435    43.512     0.200
     1.566    47.465     0.200
     2.149    62.305     0.200
     2.101    63.723     0.200
     0.810    26.348     0.200
     1.078    34.297     0.200
     1.078    35.807     0.200
     1.261    39.816     0.200
     1.261    40.297     0.200
     1.545    46.816     0.200
     1.648    52.598     0.200
     1.648    52.918     0.200
     1.983    60.076     0.200
     3.918   114.496     0.200
     0.769    25.688     0.200
     1.037    31.703     0.200
     1.037    33.328     0.200
     1.512    46.016     0.200
     1.745    53.500     0.200
     2.532    77.625     0.200
     2.702    77.023     0.200
     2.782    79.445     0.200
     0.753    24.531     0.200
     0.753    25.832     0.200
     0.939    30.141     0.200
     0.939    30.430     0.200
     0.933    30.211     0.200
     0.987    34.691     0.200
     1.105    35.910     0.200
     1.097    36.680     0.200
     1.097    37.762     0.200
     1.342    45.000     0.200
     1.491    45.953     0.200
     1.561    52.703     0.200
     1.677    54.992     0.200
     1.797    58.703     0.200
     2.020    60.480     0.200
     0.756    24.199     0.200
     0.941    29.691     0.200
     1.088    33.219     0.200
     1.104    34.129     0.200
     1.495    45.352     0.200
     3.262    99.070     0.200
     0.967    30.650     0.200
     0.999    33.279     0.200
     1.039    33.219     0.200
     1.112    35.680     0.200
     1.112    34.844     0.200
     1.353    39.949     0.200
     1.491    47.309     0.200
     1.897    59.021     0.200
     0.476    16.756     0.200
     0.743    24.904     0.200
     0.934    28.785     0.200
     0.934    30.225     0.200
     0.890    28.064     0.200
     1.083    32.945     0.200
     1.493    43.855     0.200
     1.493    46.945     0.200
     1.475    44.164     0.200
     1.983    58.414     0.200
     2.041    58.725     0.200
     0.215     8.035     0.200
     1.063    33.525     0.200
     1.624    49.406     0.200
     1.624    50.855     0.200
     1.642    49.865     0.200
     0.204     8.191     0.200
     1.022    33.973     0.200
     1.656    49.502     0.200
     1.658    49.992     0.200
     0.402    15.648     0.200
     0.513    16.695     0.200
     0.778    25.305     0.200
     0.871    26.828     0.200
     0.852    26.953     0.200
     0.862    27.797     0.200
     0.903    29.414     0.200
     1.025    32.297     0.200
     1.592    46.898     0.200
     1.592    49.617     0.200
     0.547    17.904     0.200
     0.707    24.154     0.200
     0.752    24.584     0.200
     1.051    34.244     0.200
     1.307    41.936     0.200
     1.317    43.186     0.200
     0.447    15.928     0.200
     1.330    42.416     0.200
     1.330    43.557     0.200
     1.452    43.547     0.200
     1.581    49.586     0.200
     1.581    51.287     0.200
     0.600    19.082     0.200
     1.109    33.832     0.200
     1.088    34.752     0.200
     1.674    50.132     0.200
     0.716    23.316     0.200
     1.104    36.297     0.200
     1.948    61.504     0.200
     3.348   101.387     0.200
     0.737    24.105     0.200
     0.959    32.535     0.200
     1.003    31.812     0.200
     1.128    36.742     0.200
     1.553    49.543     0.200
     0.321    12.138     0.200
     0.321    12.418     0.200
     0.466    15.617     0.200
     0.761    24.758     0.200
     0.777    25.317     0.200
     0.787    26.058     0.200
     0.827    26.277     0.200
     0.827    26.897     0.200
     0.863    29.617     0.200
     0.906    29.748     0.200
     0.970    30.268     0.200
     1.029    32.018     0.200
     1.265    40.058     0.200
     1.895    56.848     0.200
     1.946    58.647     0.200
     2.506    75.352     0.200
     0.503    16.904     0.200
     0.548    19.934     0.200
     0.736    24.934     0.200
     0.883    29.744     0.200
     0.883    29.904     0.200
     1.044    33.174     0.200
     1.882    58.904     0.200
     1.929    59.953     0.200
     0.213     9.820     0.200
     1.045    33.070     0.200
     1.546    48.453     0.200
     1.651    50.805     0.200
     3.036    86.234     0.200
     3.357   100.688     0.200
     0.802    26.172     0.200
     0.979    32.570     0.200
     1.038    34.375     0.200
     1.323    41.539     0.200
     1.483    45.570     0.200
     0.414    13.629     0.200
     0.414    13.438     0.200
     0.823    26.438     0.200
     0.894    29.051     0.200
     0.948    30.371     0.200
     1.046    32.508     0.200
     1.082    33.699     0.200
     1.082    35.840     0.200
     1.208    38.949     0.200
     1.466    43.301     0.200
     1.466    45.758     0.200
     1.466    46.570     0.200
     1.466    43.570     0.200
     1.946    58.820     0.200
     2.005    58.301     0.200
     0.456    14.990     0.200
     0.815    27.610     0.200
     1.581    50.200     0.200
     1.583    50.770     0.200
     1.640    50.070     0.200
     1.696    53.430     0.200
     1.861    56.790     0.200
     1.919    56.670     0.200
     2.021    62.440     0.200
     0.452    15.504     0.200
     1.070    34.102     0.200
     1.102    34.422     0.200
     1.102    34.082     0.200
     1.351    41.895     0.200
     1.473    45.234     0.200
     1.602    49.191     0.200
     1.783    51.832     0.200
     1.844    58.914     0.200
     0.427    15.186     0.200
     1.127    35.905     0.200
     1.164    35.996     0.200
     1.314    41.905     0.200
     1.507    47.715     0.200
     1.569    48.735     0.200
     1.718    51.646     0.200
     1.718    51.425     0.200
     1.912    59.646     0.200
     2.038    60.215     0.200
     2.838    85.095     0.200
     3.123    89.985     0.200
     3.547   102.456     0.200
     0.448    15.016     0.200
     1.109    36.215     0.200
     1.347    42.865     0.200
     1.477    47.086     0.200
     1.598    48.615     0.200
     1.852    59.045     0.200
     1.996    60.496     0.200
     2.626    79.826     0.200
     3.281    97.166     0.200
     3.540   101.816     0.200
     0.591    18.568     0.200
     0.771    24.889     0.200
     0.771    24.457     0.200
     0.835    26.777     0.200
     1.002    32.508     0.200
     1.050    32.658     0.200
     1.050    32.457     0.200
     1.077    33.537     0.200
     1.221    37.889     0.200
     1.221    38.348     0.200
     1.341    40.688     0.200
     0.315    11.127     0.200
     1.050    33.417     0.200
     1.612    48.387     0.200
     1.668    50.337     0.200
     1.714    50.737     0.200
     1.714    50.907     0.200
     3.282    97.507     0.200
     3.377    99.047     0.200
     0.337    11.596     0.200
     0.337    12.476     0.200
     1.114    34.716     0.200
     1.114    35.196     0.200
     1.619    48.246     0.200
     1.589    49.796     0.200
     3.323    96.986     0.200
     0.739    24.596     0.200
     0.951    31.465     0.200
     1.006    32.244     0.200
     1.026    32.994     0.200
     1.026    33.355     0.200
     1.138    36.936     0.200
     1.138    36.705     0.200
     1.471    45.695     0.200
     1.471    47.225     0.200
     1.509    48.145     0.200
     1.509    50.225     0.200
     1.509    51.734     0.200
     1.627    51.195     0.200
     1.799    56.086     0.200
     2.621    78.975     0.200
     2.700    81.234     0.200
     0.974    31.016     0.200
     0.964    31.430     0.200
     1.191    36.852     0.200
     1.191    38.695     0.200
     1.191    38.164     0.200
     1.573    49.141     0.200
     1.559    48.984     0.200
     2.665    80.141     0.200
     0.704    23.051     0.200
     0.981    32.461     0.200
     0.971    31.039     0.200
     1.028    33.188     0.200
     1.157    36.527     0.200
     1.500    46.277     0.200
     1.523    48.289     0.200
     1.606    51.141     0.200
     1.843    55.500     0.200
     2.705    83.059     0.200
     3.250    94.988     0.200
     0.929    30.594     0.200
     1.002    32.215     0.200
     1.205    38.906     0.200
     1.563    48.004     0.200
     3.233    95.844     0.200
     3.995   118.645     0.200
     0.618    20.516     0.200
     0.616    20.137     0.200
     0.801    25.986     0.200
     0.992    31.906     0.200
     0.992    32.365     0.200
     1.228    41.355     0.200
     1.306    43.326     0.200
     1.502    45.615     0.200
     1.502    49.686     0.200
     1.502    46.576     0.200
     3.195    95.496     0.200
     0.573    19.168     0.200
     0.863    26.988     0.200
     0.922    29.178     0.200
     1.422    43.478     0.200
     1.539    47.848     0.200
     1.586    50.638     0.200
     1.940    57.768     0.200
     2.002    59.308     0.200
     0.563    18.756     0.200
     0.859    27.656     0.200
     0.933    31.136     0.200
     1.434    44.956     0.200
     1.587    50.307     0.200
     1.793    56.937     0.200
     1.994    61.596     0.200
     1.994    60.776     0.200
     2.568    78.517     0.200
     0.905    29.211     0.200
     0.939    29.961     0.200
     1.422    44.352     0.200
     1.502    47.602     0.200
     1.826    56.281     0.200
     1.898    55.578     0.200
     1.967    60.695     0.200
     1.967    59.016     0.200
     3.710   113.281     0.200
     0.583    19.164     0.200
     0.913    29.832     0.200
     1.417    44.145     0.200
     1.545    47.645     0.200
     1.576    48.492     0.200
     1.782    54.094     0.200
     1.776    54.512     0.200
     1.951    59.781     0.200
     2.013    60.293     0.200
     3.557   105.012     0.200
     0.569    18.914     0.200
     1.434    44.543     0.200
     1.556    48.605     0.200
     1.574    49.242     0.200
     1.783    55.074     0.200
     1.779    56.535     0.200
     2.004    62.023     0.200
     0.536    17.684     0.200
     0.861    27.305     0.200
     0.960    30.504     0.200
     1.459    44.523     0.200
     1.552    47.656     0.200
     1.597    50.195     0.200
     1.815    55.773     0.200
     1.918    57.625     0.200
     1.971    58.125     0.200
     2.808    83.586     0.200
     0.533    18.586     0.200
     0.893    29.436     0.200
     0.893    28.766     0.200
     0.958    30.906     0.200
     1.445    44.356     0.200
     1.626    52.956     0.200
     1.833    57.986     0.200
     1.895    58.576     0.200
     1.957    57.986     0.200
     1.957    60.916     0.200
     3.502   104.096     0.200
     0.909    30.102     0.200
     0.909    29.270     0.200
     0.949    30.383     0.200
     1.430    43.891     0.200
     1.501    45.691     0.200
     1.638    51.293     0.200
     1.833    56.871     0.200
     1.742    52.281     0.200
     1.836    56.441     0.200
     1.889    57.672     0.200
     1.889    55.543     0.200
     1.956    59.422     0.200
     1.956    56.902     0.200
     2.602    74.660     0.200
     2.602    75.691     0.200
     2.850    82.031     0.200
     3.494   100.492     0.200
     0.511    17.543     0.200
     0.890    28.004     0.200
     0.890    29.141     0.200
     0.981    30.172     0.200
     1.468    43.914     0.200
     1.530    46.113     0.200
     1.630    48.352     0.200
     1.772    52.523     0.200
     1.847    54.602     0.200
     1.884    56.613     0.200
     1.940    57.934     0.200
     1.940    57.031     0.200
     0.568    19.438     0.200
     0.920    29.672     0.200
     0.942    30.445     0.200
     0.942    30.195     0.200
     1.388    42.641     0.200
     1.460    44.227     0.200
     1.699    51.234     0.200
     1.659    51.234     0.200
     1.835    55.711     0.200
     1.884    57.156     0.200
     1.884    55.258     0.200
     1.966    59.680     0.200
     0.542    18.484     0.200
     0.924    30.469     0.200
     0.946    29.906     0.200
     1.650    51.234     0.200
     1.842    55.891     0.200
     1.849    56.625     0.200
     1.880    58.000     0.200
     1.953    57.680     0.200
     0.549    19.125     0.200
     0.900    30.078     0.200
     0.941    31.023     0.200
     1.425    45.047     0.200
     1.508    47.812     0.200
     1.626    52.203     0.200
     1.748    54.898     0.200
     1.824    57.008     0.200
     1.901    59.219     0.200
     1.968    60.594     0.200
     2.591    76.367     0.200
     2.591    77.812     0.200
     3.563   104.734     0.200
     3.695   110.016     0.200
     0.580    19.477     0.200
     0.916    29.828     0.200
     1.420    43.430     0.200
     1.576    49.547     0.200
     1.777    54.578     0.200
     2.011    61.953     0.200
     2.551    74.281     0.200
     3.556   104.133     0.200
     0.549    18.643     0.200
     0.946    30.223     0.200
     1.006    30.913     0.200
     1.387    42.443     0.200
     1.403    43.653     0.200
     1.724    51.683     0.200
     1.827    55.963     0.200
     1.827    55.413     0.200
     1.890    56.833     0.200
     1.882    55.913     0.200
     1.920    57.223     0.200
     1.920    57.753     0.200
     2.634    75.283     0.200
     2.634    76.603     0.200
     3.260    98.523     0.200
     0.613    20.500     0.200
     1.364    42.609     0.200
     1.492    45.711     0.200
     1.607    50.047     0.200
     1.776    54.945     0.200
     1.942    59.008     0.200
     2.001    62.008     0.200
     2.022    59.969     0.200
     2.022    60.789     0.200
     2.534    74.156     0.200
     0.588    19.516     0.200
     0.944    30.637     0.200
     0.944    31.266     0.200
     1.368    43.945     0.200
     1.453    45.686     0.200
     1.654    50.865     0.200
     1.691    53.176     0.200
     1.820    56.576     0.200
     1.897    58.227     0.200
     1.983    59.746     0.200
     3.495   105.955     0.200
     0.933    30.859     0.200
     0.933    31.414     0.200
     0.933    29.734     0.200
     1.405    43.023     0.200
     1.473    44.500     0.200
     1.654    51.133     0.200
     1.712    51.148     0.200
     1.838    55.812     0.200
     1.959    59.328     0.200
     1.959    58.500     0.200
     2.597    75.273     0.200
     2.867    82.750     0.200
     3.485   100.680     0.200
     0.959    30.867     0.200
     0.948    31.098     0.200
     0.948    30.398     0.200
     1.424    44.027     0.200
     1.465    46.297     0.200
     1.676    51.387     0.200
     1.707    52.066     0.200
     1.866    56.277     0.200
     1.856    57.879     0.200
     1.856    55.688     0.200
     1.931    59.539     0.200
     1.931    58.098     0.200
     0.591    19.766     0.200
     0.897    28.756     0.200
     0.941    30.525     0.200
     0.941    30.656     0.200
     1.366    42.266     0.200
     1.456    45.227     0.200
     1.650    50.256     0.200
     1.693    52.037     0.200
     1.816    55.025     0.200
     1.901    58.195     0.200
     2.568    74.596     0.200
     0.541    19.357     0.200
     0.949    30.268     0.200
     0.898    28.457     0.200
     1.512    45.188     0.200
     1.627    51.457     0.200
     1.752    54.027     0.200
     1.897    58.148     0.200
     0.586    20.577     0.200
     0.903    29.237     0.200
     0.949    31.007     0.200
     0.949    30.557     0.200
     1.369    42.177     0.200
     1.449    44.017     0.200
     1.686    50.327     0.200
     1.660    51.887     0.200
     1.892    57.087     0.200
     1.826    56.417     0.200
     2.576    74.327     0.200
     0.584    19.201     0.200
     0.906    28.850     0.200
     0.898    28.100     0.200
     0.898    27.621     0.200
     1.392    43.660     0.200
     1.500    46.881     0.200
     1.614    49.400     0.200
     1.737    53.311     0.200
     1.836    55.320     0.200
     1.924    57.891     0.200
     0.580    19.195     0.200
     0.872    28.445     0.200
     0.913    29.117     0.200
     1.410    43.234     0.200
     1.528    46.508     0.200
     1.592    48.297     0.200
     1.765    53.285     0.200
     1.808    55.617     0.200
     1.938    58.387     0.200
     2.556    74.367     0.200
     2.556    73.145     0.200
     2.804    82.855     0.200
     0.596    20.320     0.200
     0.899    29.121     0.200
     1.003    31.111     0.200
     1.003    32.641     0.200
     1.342    42.201     0.200
     1.394    42.980     0.200
     1.632    50.531     0.200
     1.707    53.820     0.200
     1.861    57.580     0.200
     1.861    54.602     0.200
     1.854    57.230     0.200
     1.942    60.121     0.200
     0.582    20.172     0.200
     0.906    29.113     0.200
     0.949    31.043     0.200
     0.949    31.602     0.200
     1.372    42.363     0.200
     1.450    44.543     0.200
     1.688    51.352     0.200
     1.661    50.473     0.200
     1.889    58.402     0.200
     1.828    55.023     0.200
     1.886    57.723     0.200
     0.562    19.211     0.200
     0.952    32.504     0.200
     1.670    52.562     0.200
     1.845    57.512     0.200
     1.882    57.383     0.200
     0.581    19.444     0.200
     0.911    29.896     0.200
     0.986    32.325     0.200
     0.986    30.866     0.200
     1.361    42.274     0.200
     1.853    58.505     0.200
     2.908    84.966     0.200
     3.224    94.235     0.200
     0.593    19.973     0.200
     0.960    31.662     0.200
     0.960    32.742     0.200
     1.357    42.441     0.200
     1.436    44.223     0.200
     1.674    51.012     0.200
     1.667    52.191     0.200
     1.827    57.701     0.200
     2.574    75.342     0.200
     0.543    17.454     0.200
     0.543    17.314     0.200
     0.749    24.895     0.200
     0.749    25.154     0.200
     0.825    25.645     0.200
     0.917    30.074     0.200
     0.917    29.734     0.200
     0.917    30.574     0.200
     0.934    29.435     0.200
     1.032    32.715     0.200
     1.032    32.255     0.200
     1.013    31.595     0.200
     1.062    34.494     0.200
     1.174    36.734     0.200
     1.130    37.164     0.200
     1.259    41.015     0.200
     1.590    47.484     0.200
     1.541    49.824     0.200
     0.459    16.315     0.200
     0.540    17.795     0.200
     0.540    17.475     0.200
     0.830    26.275     0.200
     0.902    30.965     0.200
     0.909    29.055     0.200
     0.920    29.165     0.200
     0.960    30.315     0.200
     0.960    31.585     0.200
     1.034    32.715     0.200
     1.244    38.465     0.200
     1.314    41.565     0.200
     1.595    47.515     0.200
     1.595    47.395     0.200
     1.650    49.555     0.200
     2.224    64.725     0.200
     0.595    19.852     0.200
     0.893    28.451     0.200
     0.946    31.451     0.200
     0.946    29.992     0.200
     1.361    41.041     0.200
     1.450    42.771     0.200
     1.687    49.822     0.200
     1.654    51.492     0.200
     1.817    55.012     0.200
     1.887    57.301     0.200
     1.988    58.092     0.200
     2.567    74.211     0.200
     3.644   105.643     0.200
     0.578    19.625     0.200
     0.913    29.316     0.200
     0.984    31.113     0.200
     1.364    41.977     0.200
     1.416    43.543     0.200
     1.655    50.633     0.200
     1.695    50.516     0.200
     1.854    56.215     0.200
     2.598    74.883     0.200
     0.927    29.159     0.200
     0.995    31.809     0.200
     0.995    31.129     0.200
     1.372    42.989     0.200
     1.648    51.089     0.200
     1.709    52.379     0.200
     1.870    56.949     0.200
     1.846    54.769     0.200
     1.846    54.509     0.200
     1.941    59.169     0.200
     1.941    56.909     0.200
     2.614    76.199     0.200
     3.240    96.829     0.200
     0.583    19.471     0.200
     0.906    29.661     0.200
     0.905    30.351     0.200
     0.905    30.690     0.200
     1.390    42.621     0.200
     1.731    52.261     0.200
     1.620    50.461     0.200
     1.801    56.121     0.200
     1.842    56.811     0.200
     0.581    19.672     0.200
     0.869    29.182     0.200
     0.912    29.152     0.200
     1.410    42.242     0.200
     1.589    51.902     0.200
     1.784    53.191     0.200
     1.806    55.021     0.200
     2.554    73.791     0.200
     0.585    19.477     0.200
     0.902    29.184     0.200
     1.377    42.184     0.200
     1.641    51.613     0.200
     1.813    56.215     0.200
     1.987    58.336     0.200
     1.866    58.363     0.200
     2.569    74.316     0.200
     0.595    19.965     0.200
     0.894    28.762     0.200
     1.354    41.453     0.200
     1.432    43.012     0.200
     1.670    50.145     0.200
     1.670    52.102     0.200
     1.888    56.871     0.200
     1.828    55.922     0.200
     1.904    57.984     0.200
     1.981    58.371     0.200
     2.574    74.812     0.200
     0.478    15.344     0.200
     1.027    33.812     0.200
     1.529    47.102     0.200
     1.603    52.742     0.200
     1.744    56.215     0.200
     1.928    59.672     0.200
     1.998    62.621     0.200
     1.853    59.043     0.200
     2.644    78.031     0.200
     0.507    16.590     0.200
     0.992    31.871     0.200
     1.490    46.809     0.200
     1.564    47.570     0.200
     1.604    50.449     0.200
     1.807    55.469     0.200
     1.769    55.141     0.200
     1.836    56.711     0.200
     1.902    56.941     0.200
     1.948    58.359     0.200
     1.948    57.949     0.200
     1.995    61.109     0.200
     2.619    76.781     0.200
     3.194    92.801     0.200
     0.473    15.891     0.200
     1.044    33.672     0.200
     1.555    47.438     0.200
     1.584    50.508     0.200
     1.713    53.234     0.200
     1.849    57.172     0.200
     1.906    57.406     0.200
     1.931    57.102     0.200
     1.931    60.641     0.200
     2.648    76.984     0.200
     3.775   112.094     0.200
     0.584    19.387     0.200
     0.904    29.697     0.200
     0.935    29.727     0.200
     0.935    29.906     0.200
     1.376    42.227     0.200
     1.376    51.146     0.200
     1.463    45.688     0.200
     1.701    50.236     0.200
     1.648    50.996     0.200
     1.818    55.396     0.200
     1.983    57.787     0.200
     0.883    27.438     0.200
     0.883    27.227     0.200
     0.921    28.508     0.200
     1.413    42.898     0.200
     1.519    44.883     0.200
     1.604    52.852     0.200
     1.799    56.758     0.200
     1.993    59.680     0.200
     0.541    19.109     0.200
     0.950    31.352     0.200
     1.675    52.836     0.200
     1.859    56.516     0.200
     1.875    58.789     0.200
     2.887    85.125     0.200
     3.226    96.633     0.200
     0.586    19.799     0.200
     0.902    28.469     0.200
     0.937    28.989     0.200
     0.937    30.689     0.200
     1.373    42.309     0.200
     1.461    44.489     0.200
     1.698    50.539     0.200
     1.649    53.859     0.200
     1.818    55.979     0.200
     1.984    57.539     0.200
     1.825    56.607     0.200
     1.887    60.938     0.200
     1.831    58.879     0.200
     2.001    62.098     0.200
     2.001    60.488     0.200
     2.572    79.549     0.200
     3.276    96.789     0.200
     7.737   253.947     0.200
     0.548    17.795     0.200
     0.930    30.285     0.200
     0.940    31.205     0.200
     1.412    44.744     0.200
     1.477    45.674     0.200
     1.654    51.725     0.200
     1.717    52.125     0.200
     1.842    57.625     0.200
     1.955    58.854     0.200
     0.555    18.359     0.200
     0.935    30.061     0.200
     0.971    30.650     0.200
     0.971    30.410     0.200
     1.391    43.061     0.200
     1.435    44.141     0.200
     1.675    49.410     0.200
     1.690    51.500     0.200
     1.856    56.189     0.200
     1.862    56.160     0.200
     1.943    58.689     0.200
     2.612    75.859     0.200
     0.553    18.238     0.200
     0.935    31.250     0.200
     0.939    29.648     0.200
     0.939    31.279     0.200
     1.404    44.209     0.200
     1.660    51.889     0.200
     1.707    53.289     0.200
     1.843    56.898     0.200
     1.877    57.090     0.200
     1.877    55.770     0.200
     1.955    58.889     0.200
     1.955    58.568     0.200
     2.812    84.959     0.200
     0.578    19.148     0.200
     0.898    29.707     0.200
     0.898    29.109     0.200
     0.911    30.008     0.200
     1.398    44.379     0.200
     1.501    47.641     0.200
     1.616    51.738     0.200
     1.739    53.730     0.200
     1.802    56.891     0.200
     1.920    59.859     0.200
     1.993    61.449     0.200
     2.565    76.129     0.200
     0.566    19.152     0.200
     0.901    29.395     0.200
     1.408    43.812     0.200
     1.622    52.094     0.200
     1.811    55.984     0.200
     1.811    59.465     0.200
     1.911    57.293     0.200
     0.595    20.109     0.200
     0.893    29.312     0.200
     1.374    41.844     0.200
     1.625    51.609     0.200
     1.718    51.852     0.200
     1.798    55.609     0.200
     2.555    74.359     0.200
     2.838    83.117     0.200
     0.564    18.797     0.200
     1.406    43.148     0.200
     1.632    52.711     0.200
     1.819    55.727     0.200
     2.582    75.602     0.200
     0.678    22.566     0.200
     1.096    36.336     0.200
     1.090    35.016     0.200
     1.515    46.586     0.200
     1.736    53.617     0.200
     3.115    91.668     0.200
     3.399   102.816     0.200
     0.572    18.500     0.200
     0.917    29.602     0.200
     0.970    31.820     0.200
     0.970    30.902     0.200
     1.374    42.871     0.200
     1.432    43.531     0.200
     1.671    50.242     0.200
     1.683    53.570     0.200
     1.849    55.883     0.200
     1.958    58.301     0.200
     1.084    35.911     0.200
     1.084    34.361     0.200
     1.295    40.562     0.200
     1.310    41.281     0.200
     1.547    48.531     0.200
     1.776    54.401     0.200
     1.824    57.321     0.200
     1.824    55.182     0.200
     1.892    57.361     0.200
     1.951    60.762     0.200
     1.951    58.432     0.200
     2.608    75.962     0.200
     0.577    19.582     0.200
     0.863    26.852     0.200
     0.918    29.021     0.200
     1.417    43.162     0.200
     1.586    50.521     0.200
     1.538    49.043     0.200
     1.785    56.172     0.200
     2.556    77.973     0.200
     3.147    92.672     0.200
     3.566   103.383     0.200
     0.581    19.367     0.200
     0.903    29.768     0.200
     1.393    42.986     0.200
     1.619    52.717     0.200
     1.802    57.107     0.200
     1.994    59.207     0.200
     0.871    27.938     0.200
     0.871    27.609     0.200
     0.980    31.453     0.200
     1.474    45.648     0.200
     1.548    46.797     0.200
     1.612    52.633     0.200
     1.790    53.594     0.200
     1.835    55.648     0.200
     1.899    58.273     0.200
     1.899    56.117     0.200
     1.951    58.820     0.200
     1.951    58.289     0.200
     0.543    17.953     0.200
     0.870    27.000     0.200
     0.870    29.609     0.200
     0.951    30.031     0.200
     1.447    43.305     0.200
     1.602    49.891     0.200
     1.813    56.164     0.200
     1.974    57.297     0.200
     0.545    19.211     0.200
     0.906    29.711     0.200
     1.426    44.148     0.200
     1.894    57.516     0.200
     1.962    58.391     0.200
     0.894    28.023     0.200
     0.975    30.070     0.200
     0.975    30.234     0.200
     1.632    52.969     0.200
     1.845    57.617     0.200
     1.943    56.250     0.200
     1.943    56.359     0.200
     0.535    17.787     0.200
     0.954    30.497     0.200
     1.411    43.817     0.200
     1.445    45.677     0.200
     1.691    52.927     0.200
     1.847    55.217     0.200
     1.873    57.877     0.200
     1.912    57.197     0.200
     1.928    58.007     0.200
     3.702   112.587     0.200
     0.890    27.566     0.200
     0.951    30.126     0.200
     1.439    43.766     0.200
     1.620    48.926     0.200
     1.761    52.016     0.200
     1.825    53.296     0.200
     1.902    56.166     0.200
     1.964    56.706     0.200
     0.579    19.641     0.200
     1.393    43.422     0.200
     1.492    45.682     0.200
     1.624    51.580     0.200
     1.730    52.461     0.200
     1.915    57.301     0.200
     0.892    27.195     0.200
     0.928    29.086     0.200
     1.416    43.445     0.200
     1.615    52.277     0.200
     1.751    51.637     0.200
     1.987    59.867     0.200
     0.560    19.156     0.200
     0.858    26.805     0.200
     0.936    29.977     0.200
     1.437    45.168     0.200
     1.548    48.285     0.200
     1.586    49.668     0.200
     1.993    59.797     0.200
     1.426    44.602     0.200
     1.585    49.973     0.200
     1.788    55.203     0.200
     1.939    61.031     0.200
     1.939    59.582     0.200
     2.000    62.320     0.200
     2.000    62.121     0.200
     0.558    18.805     0.200
     0.884    27.695     0.200
     0.884    29.543     0.200
     0.934    29.754     0.200
     1.425    42.785     0.200
     1.610    51.574     0.200
     1.809    54.914     0.200
     1.981    60.586     0.200
     2.822    83.324     0.200
     0.560    18.406     0.200
     0.929    29.227     0.200
     0.957    32.059     0.200
     1.390    43.246     0.200
     1.447    44.168     0.200
     1.687    52.168     0.200
     1.675    51.516     0.200
     1.953    58.266     0.200
     1.953    56.938     0.200
     0.574    19.375     0.200
     0.921    30.102     0.200
     1.583    50.578     0.200
     1.780    56.008     0.200
     1.785    56.922     0.200
     1.942    59.828     0.200
     2.004    59.750     0.200
     2.795    82.438     0.200
     0.565    19.208     0.200
     0.927    30.078     0.200
     0.881    28.688     0.200
     1.420    44.318     0.200
     1.605    50.908     0.200
     1.802    55.358     0.200
     1.923    56.228     0.200
     0.846    27.016     0.200
     0.985    32.477     0.200
     0.985    32.000     0.200
     1.299    40.000     0.200
     1.673    51.875     0.200
     3.177    92.188     0.200
     0.879    27.908     0.200
     1.061    32.178     0.200
     1.295    40.099     0.200
     1.331    41.269     0.200
     1.753    53.248     0.200
     1.844    54.658     0.200
     1.844    54.248     0.200
     1.966    57.538     0.200
     1.966    57.688     0.200
     0.564    18.840     0.200
     0.885    27.859     0.200
     1.419    43.738     0.200
     1.609    52.098     0.200
     2.821    85.250     0.200
     3.683   111.430     0.200
     0.525    18.320     0.200
     0.910    29.867     0.200
     0.964    30.305     0.200
     1.444    43.312     0.200
     1.505    46.906     0.200
     1.847    53.844     0.200
     1.880    57.594     0.200
     1.944    56.477     0.200
     1.958    58.484     0.200
     0.929    30.309     0.200
     1.414    45.480     0.200
     1.504    48.340     0.200
     1.624    51.250     0.200
     1.624    51.422     0.200
     1.908    59.449     0.200
     1.977    60.949     0.200
     2.836    83.199     0.200
     3.552   106.281     0.200
     3.683   108.051     0.200
     0.554    18.352     0.200
     0.912    28.133     0.200
     0.912    29.055     0.200
     0.934    29.312     0.200
     1.414    43.992     0.200
     1.636    51.633     0.200
     1.826    55.633     0.200
     1.968    59.094     0.200
     3.688   109.656     0.200
     0.565    19.113     0.200
     0.936    29.723     0.200
     1.443    43.803     0.200
     1.565    47.843     0.200
     1.569    51.812     0.200
     1.783    54.843     0.200
     0.562    18.293     0.200
     0.926    30.512     0.200
     0.932    30.859     0.200
     1.398    43.691     0.200
     1.471    45.191     0.200
     1.652    51.961     0.200
     1.711    52.211     0.200
     1.833    56.332     0.200
     1.863    59.352     0.200
     1.966    58.793     0.200
     0.569    19.039     0.200
     0.895    29.658     0.200
     0.895    28.818     0.200
     0.921    29.908     0.200
     1.408    43.299     0.200
     1.507    45.559     0.200
     1.616    48.529     0.200
     1.807    53.719     0.200
     1.987    57.889     0.200
     2.828    83.658     0.200
     3.520   102.539     0.200
     0.569    19.590     0.200
     0.867    27.811     0.200
     0.867    28.051     0.200
     0.925    29.801     0.200
     1.423    44.680     0.200
     1.536    46.340     0.200
     1.591    49.100     0.200
     1.792    53.850     0.200
     1.997    58.670     0.200
     3.540   103.109     0.200
     0.570    20.059     0.200
     0.849    27.348     0.200
     0.849    28.816     0.200
     0.928    29.516     0.200
     1.433    43.918     0.200
     1.576    48.227     0.200
     1.783    53.938     0.200
     2.004    59.137     0.200
     2.788    82.137     0.200
     0.895    29.129     0.200
     1.403    44.059     0.200
     1.614    52.488     0.200
     1.802    57.299     0.200
     2.826    83.639     0.200
     3.167    91.928     0.200
     0.956    30.228     0.200
     1.147    36.538     0.200
     1.147    34.598     0.200
     1.259    39.788     0.200
     1.331    41.268     0.200
     1.744    52.818     0.200
     1.744    52.048     0.200
     1.851    56.308     0.200
     1.879    56.468     0.200
     1.879    55.388     0.200
     1.972    59.978     0.200
     2.683    77.768     0.200
     0.585    19.645     0.200
     0.951    29.764     0.200
     1.117    34.964     0.200
     1.117    34.814     0.200
     1.289    40.044     0.200
     1.340    41.764     0.200
     1.531    46.674     0.200
     1.762    52.104     0.200
     1.824    55.104     0.200
     1.953    59.274     0.200
     2.671    76.444     0.200
     2.671    79.114     0.200
     3.415   101.254     0.200
     0.578    19.438     0.200
     0.911    30.477     0.200
     1.375    42.297     0.200
     1.685    50.406     0.200
     1.666    54.180     0.200
     1.834    56.477     0.200
     1.970    58.547     0.200
     1.888    59.070     0.200
     2.312    68.086     0.200
     2.585    76.039     0.200
     2.878    83.531     0.200
     0.907    28.273     0.200
     0.956    30.070     0.200
     1.370    41.961     0.200
     1.443    44.453     0.200
     1.681    51.172     0.200
     1.667    49.805     0.200
     1.884    57.805     0.200
     1.833    54.984     0.200
     1.972    58.984     0.200
     0.573    18.586     0.200
     0.890    29.930     0.200
     0.917    29.188     0.200
     1.407    42.414     0.200
     1.610    50.148     0.200
     4.430   133.203     0.200
     0.922    29.375     0.200
     0.914    30.736     0.200
     1.402    42.166     0.200
     1.634    50.545     0.200
     1.819    55.656     0.200
     1.903    56.086     0.200
     1.977    58.035     0.200
     2.581    74.896     0.200
     0.557    19.078     0.200
     0.931    29.727     0.200
     0.935    30.309     0.200
     0.935    29.648     0.200
     1.470    46.078     0.200
     1.656    51.457     0.200
     1.838    56.207     0.200
     1.864    57.496     0.200
     0.543    18.621     0.200
     0.927    30.262     0.200
     0.927    31.230     0.200
     1.482    45.312     0.200
     1.653    51.973     0.200
     1.843    56.992     0.200
     2.606    80.160     0.200
     2.865    84.531     0.200
     0.471    16.031     0.200
     1.045    33.711     0.200
     1.555    47.453     0.200
     1.586    49.461     0.200
     1.621    49.602     0.200
     1.714    53.297     0.200
     1.851    56.734     0.200
     1.866    56.461     0.200
     1.904    57.250     0.200
     1.929    58.297     0.200
     2.650    77.180     0.200
     2.793    81.758     0.200
     0.877    28.391     0.200
     0.921    28.984     0.200
     1.416    43.438     0.200
     1.599    49.352     0.200
     1.763    53.664     0.200
     1.796    53.727     0.200
     1.995    62.086     0.200
     2.565    73.727     0.200
     3.159    92.969     0.200
     5.031   148.031     0.200
     0.540    17.979     0.200
     0.958    29.919     0.200
     1.460    42.819     0.200
     1.589    51.359     0.200
     1.808    56.249     0.200
     1.925    56.719     0.200
     1.978    58.369     0.200
     2.588    74.459     0.200
     0.559    18.874     0.200
     0.936    30.134     0.200
     1.436    43.934     0.200
     1.545    49.414     0.200
     1.589    51.404     0.200
     1.796    55.574     0.200
     0.952    32.465     0.200
     1.650    50.645     0.200
     1.674    53.125     0.200
     1.799    57.215     0.200
     1.917    58.015     0.200
     2.011    59.385     0.200
     0.552    18.521     0.200
     0.905    28.011     0.200
     0.905    30.031     0.200
     0.937    29.621     0.200
     1.420    43.161     0.200
     1.630    51.461     0.200
     1.741    52.352     0.200
     1.824    56.281     0.200
     1.969    58.261     0.200
     1.969    59.291     0.200
     0.840    26.979     0.200
     0.804    26.509     0.200
     1.278    39.909     0.200
     1.372    43.619     0.200
     1.520    48.318     0.200
     2.497    74.339     0.200
     2.801    84.959     0.200
     1.184    37.605     0.200
     1.222    39.844     0.200
     1.222    40.465     0.200
     1.428    44.375     0.200
     1.700    53.535     0.200
     1.700    51.914     0.200
     1.921    58.734     0.200
     1.856    57.434     0.200
     1.856    55.543     0.200
     2.022    63.094     0.200
     3.399   100.824     0.200
     0.661    22.416     0.200
     0.923    29.926     0.200
     1.199    37.965     0.200
     1.196    38.734     0.200
     1.196    37.465     0.200
     1.270    39.945     0.200
     1.439    44.385     0.200
     1.883    57.814     0.200
     1.972    62.404     0.200
     2.591    79.395     0.200
     2.663    81.016     0.200
     3.619   105.635     0.200
     1.184    38.805     0.200
     1.206    38.875     0.200
     1.206    39.055     0.200
     1.238    40.652     0.200
     1.421    45.645     0.200
     1.421    44.312     0.200
     1.934    57.855     0.200
     1.884    59.855     0.200
     1.958    61.105     0.200
     2.642    76.875     0.200
     0.935    29.941     0.200
     1.194    37.383     0.200
     1.203    38.402     0.200
     1.203    37.223     0.200
     1.280    40.199     0.200
     1.435    44.250     0.200
     1.740    50.973     0.200
     1.893    56.762     0.200
     1.984    58.883     0.200
     0.884    28.531     0.200
     1.023    33.070     0.200
     1.318    40.000     0.200
     1.720    54.695     0.200
     1.860    55.500     0.200
     1.854    57.648     0.200
     1.970    59.234     0.200
     0.757    24.828     0.200
     0.923    30.988     0.200
     1.156    36.879     0.200
     1.478    45.549     0.200
     1.478    47.568     0.200
     1.515    47.998     0.200
     1.613    51.779     0.200
     2.727    81.529     0.200
     1.197    37.717     0.200
     0.917    29.488     0.200
     1.537    47.707     0.200
     1.176    36.797     0.200
     1.448    44.258     0.200
     1.448    44.148     0.200
     1.391    42.678     0.200
     1.684    50.258     0.200
     1.684    49.637     0.200
     2.312    72.668     0.200
     2.984    88.697     0.200
     1.188    37.273     0.200
     0.929    29.797     0.200
     1.388    43.336     0.200
     1.413    44.695     0.200
     1.457    44.855     0.200
     1.688    49.863     0.200
     2.229    66.523     0.200
     2.301    69.145     0.200
     3.078    89.824     0.200
     0.932    29.812     0.200
     1.188    36.797     0.200
     1.209    38.117     0.200
     1.209    38.922     0.200
     1.273    39.430     0.200
     1.428    44.641     0.200
     1.899    56.117     0.200
     1.897    58.219     0.200
     1.985    61.867     0.200
     2.674    80.328     0.200
     3.309    95.750     0.200
     0.637    21.107     0.200
     0.925    30.707     0.200
     1.164    37.918     0.200
     1.164    37.387     0.200
     1.290    40.197     0.200
     1.856    57.107     0.200
     1.958    60.229     0.200
     0.628    21.066     0.200
     0.955    30.617     0.200
     1.196    38.586     0.200
     1.196    38.266     0.200
     1.207    37.326     0.200
     1.305    40.766     0.200
     1.450    44.547     0.200
     1.726    52.486     0.200
     1.726    51.307     0.200
     1.876    54.947     0.200
     1.893    58.057     0.200
     1.995    60.236     0.200
     0.777    25.500     0.200
     1.039    32.930     0.200
     1.264    40.461     0.200
     1.388    42.578     0.200
     1.399    44.531     0.200
     0.924    28.930     0.200
     0.924    31.055     0.200
     1.184    36.234     0.200
     1.209    37.680     0.200
     1.406    42.820     0.200
     1.436    43.984     0.200
     1.436    43.461     0.200
     1.537    49.609     0.200
     1.669    50.227     0.200
     1.669    49.359     0.200
     2.321    71.148     0.200
     2.971    85.938     0.200
     0.932    29.602     0.200
     1.190    36.801     0.200
     1.189    36.648     0.200
     1.189    38.258     0.200
     1.391    41.781     0.200
     1.456    43.121     0.200
     1.456    44.008     0.200
     1.686    50.340     0.200
     0.746    24.762     0.200
     0.929    30.711     0.200
     1.185    37.594     0.200
     1.155    36.762     0.200
     1.490    44.684     0.200
     1.490    44.551     0.200
     1.356    42.012     0.200
     1.722    51.531     0.200
     1.508    45.051     0.200
     3.026    91.422     0.200
     3.249    94.691     0.200
     0.903    28.742     0.200
     1.111    35.363     0.200
     1.111    35.152     0.200
     1.294    39.232     0.200
     1.802    52.432     0.200
     1.804    53.812     0.200
     3.623   104.152     0.200
     0.923    29.229     0.200
     1.162    35.547     0.200
     1.162    36.229     0.200
     1.235    38.188     0.200
     1.288    39.578     0.200
     1.475    44.438     0.200
     1.854    55.828     0.200
     1.910    55.387     0.200
     1.955    57.938     0.200
     3.340    96.678     0.200
     3.332    97.348     0.200
     0.926    29.605     0.200
     1.093    33.305     0.200
     1.093    33.934     0.200
     1.307    39.543     0.200
     1.327    40.594     0.200
     1.548    46.375     0.200
     1.796    54.164     0.200
     1.915    55.664     0.200
     1.923    59.293     0.200
     3.298    99.035     0.200
     4.250   122.559     0.200
     0.632    20.980     0.200
     0.939    30.992     0.200
     1.176    37.102     0.200
     1.176    39.273     0.200
     1.298    40.641     0.200
     1.746    52.730     0.200
     1.871    57.211     0.200
     1.974    59.863     0.200
     2.674    80.531     0.200
     0.609    20.645     0.200
     0.942    31.035     0.200
     1.145    35.973     0.200
     1.257    39.125     0.200
     1.317    41.496     0.200
     1.499    45.836     0.200
     1.756    52.105     0.200
     1.845    55.824     0.200
     1.892    55.883     0.200
     1.961    59.543     0.200
     0.612    20.598     0.200
     0.945    29.871     0.200
     1.155    35.238     0.200
     1.155    36.621     0.200
     1.247    39.371     0.200
     1.315    40.758     0.200
     1.489    46.500     0.200
     1.749    52.141     0.200
     1.749    51.570     0.200
     1.855    55.570     0.200
     1.855    59.508     0.200
     1.888    55.828     0.200
     1.888    55.238     0.200
     1.968    59.949     0.200
     2.675    76.777     0.200
     3.379    98.238     0.200
     0.675    22.383     0.200
     0.930    30.793     0.200
     1.226    40.403     0.200
     1.226    40.683     0.200
     1.262    40.083     0.200
     1.910    59.893     0.200
     1.902    57.183     0.200
     3.388   101.163     0.200
     0.673    22.061     0.200
     0.940    30.811     0.200
     1.161    36.920     0.200
     1.267    40.301     0.200
     1.401    44.221     0.200
     1.892    57.270     0.200
     1.922    59.641     0.200
     2.003    60.320     0.200
     2.686    82.080     0.200
     0.761    24.105     0.200
     1.055    32.375     0.200
     0.919    30.115     0.200
     1.154    36.395     0.200
     1.475    45.395     0.200
     1.475    46.635     0.200
     1.516    46.484     0.200
     3.279    97.586     0.200
     4.034   117.725     0.200
     0.738    24.723     0.200
     0.924    29.922     0.200
     1.182    37.133     0.200
     1.193    37.863     0.200
     1.452    44.162     0.200
     1.452    43.832     0.200
     1.391    43.922     0.200
     1.685    50.502     0.200
     1.685    53.133     0.200
     1.685    50.273     0.200
     2.307    67.973     0.200
     1.144    37.371     0.200
     1.182    38.312     0.200
     1.182    38.672     0.200
     1.154    36.762     0.200
     1.448    45.012     0.200
     1.448    44.613     0.200
     1.465    46.621     0.200
     1.622    50.422     0.200
     0.589    19.613     0.200
     0.996    32.953     0.200
     1.048    32.824     0.200
     1.059    33.754     0.200
     1.079    34.074     0.200
     1.220    39.223     0.200
     1.342    41.553     0.200
     1.352    44.254     0.200
     1.593    48.533     0.200
     1.593    47.453     0.200
     1.667    51.574     0.200
     2.117    64.094     0.200
     0.242     8.457     0.200
     1.342    42.347     0.200
     1.342    42.477     0.200
     1.337    42.267     0.200
     1.337    42.737     0.200
     1.378    42.557     0.200
     1.378    45.247     0.200
     1.378    43.077     0.200
     1.419    44.357     0.200
     1.506    46.737     0.200
     1.506    47.887     0.200
     1.481    47.527     0.200
     2.428    74.647     0.200
     2.963    90.297     0.200
     0.815    26.062     0.200
     1.082    34.051     0.200
     1.209    38.520     0.200
     1.209    38.770     0.200
     1.283    39.562     0.200
     1.508    48.211     0.200
     1.563    47.062     0.200
     1.563    51.340     0.200
     1.671    50.699     0.200
     2.879    86.520     0.200
     3.276    96.691     0.200
     0.824    27.158     0.200
     1.089    34.199     0.200
     1.196    37.639     0.200
     1.266    40.588     0.200
     1.266    38.748     0.200
     1.545    46.389     0.200
     1.526    47.789     0.200
     1.655    49.758     0.200
     3.290    95.979     0.200
     0.564    17.953     0.200
     0.798    24.613     0.200
     0.972    31.855     0.200
     0.970    30.812     0.200
     0.970    30.914     0.200
     0.969    31.273     0.200
     0.987    32.895     0.200
     1.034    32.355     0.200
     1.028    32.723     0.200
     1.058    33.312     0.200
     1.104    35.953     0.200
     1.195    37.363     0.200
     1.195    37.953     0.200
     1.312    39.914     0.200
     1.584    48.023     0.200
     0.552    17.510     0.200
     0.551    17.580     0.200
     0.813    26.330     0.200
     0.813    26.199     0.200
     0.940    31.109     0.200
     0.941    31.170     0.200
     0.945    29.020     0.200
     0.958    31.061     0.200
     0.958    31.680     0.200
     1.034    32.539     0.200
     1.032    32.141     0.200
     1.032    32.570     0.200
     1.183    37.670     0.200
     1.283    39.260     0.200
     1.331    40.100     0.200
     1.337    42.510     0.200
     1.763    52.609     0.200
     0.558    19.695     0.200
     0.619    19.914     0.200
     0.619    20.223     0.200
     1.014    32.414     0.200
     1.055    34.383     0.200
     1.084    34.062     0.200
     1.084    34.594     0.200
     1.250    39.285     0.200
     1.250    40.012     0.200
     1.268    40.652     0.200
     1.331    41.363     0.200
     1.370    41.902     0.200
     1.409    46.434     0.200
     1.630    49.762     0.200
     1.630    50.945     0.200
     1.832    55.125     0.200
     2.006    60.254     0.200
     2.188    64.953     0.200
     3.114    92.953     0.200
     0.526    19.105     0.200
     0.658    20.867     0.200
     0.593    18.855     0.200
     0.592    18.734     0.200
     1.036    33.445     0.200
     1.067    34.078     0.200
     1.224    38.465     0.200
     1.224    38.805     0.200
     1.235    39.598     0.200
     1.618    49.957     0.200
     1.596    51.266     0.200
     0.566    18.094     0.200
     0.565    18.141     0.200
     0.802    25.961     0.200
     0.797    26.312     0.200
     0.797    25.242     0.200
     0.970    30.641     0.200
     0.968    31.117     0.200
     0.968    31.625     0.200
     0.987    32.461     0.200
     1.036    33.141     0.200
     1.028    32.773     0.200
     1.057    33.758     0.200
     1.105    36.062     0.200
     1.116    36.133     0.200
     1.197    36.492     0.200
     1.197    38.367     0.200
     1.414    41.906     0.200
     1.586    48.094     0.200
     1.586    50.867     0.200
     0.507    18.727     0.200
     0.573    18.047     0.200
     0.573    19.406     0.200
     0.573    18.055     0.200
     0.680    22.430     0.200
     0.958    31.828     0.200
     1.053    33.305     0.200
     1.053    32.844     0.200
     1.028    32.805     0.200
     1.204    37.789     0.200
     1.212    38.977     0.200
     1.286    40.188     0.200
     1.321    41.625     0.200
     1.356    45.406     0.200
     1.606    49.133     0.200
     1.606    48.883     0.200
     1.776    55.125     0.200
     0.551    17.898     0.200
     0.550    18.195     0.200
     0.550    18.602     0.200
     0.726    23.305     0.200
     0.824    26.648     0.200
     0.824    26.164     0.200
     0.949    32.797     0.200
     0.983    32.891     0.200
     1.048    33.617     0.200
     1.232    39.008     0.200
     1.278    39.719     0.200
     1.392    43.055     0.200
     1.610    49.727     0.200
     1.724    54.109     0.200
     0.558    17.953     0.200
     0.558    18.062     0.200
     0.813    26.273     0.200
     0.923    30.625     0.200
     0.923    30.867     0.200
     0.998    32.758     0.200
     1.050    33.375     0.200
     1.050    33.195     0.200
     1.250    39.398     0.200
     1.331    41.766     0.200
     1.411    43.172     0.200
     1.609    49.406     0.200
     3.167    95.477     0.200
     0.566    18.293     0.200
     0.566    18.293     0.200
     0.943    30.743     0.200
     0.951    31.344     0.200
     1.026    33.523     0.200
     1.047    33.303     0.200
     1.281    40.213     0.200
     1.442    44.573     0.200
     1.602    48.763     0.200
     1.063    34.125     0.200
     1.197    37.715     0.200
     1.197    37.535     0.200
     1.279    40.725     0.200
     1.279    40.065     0.200
     1.567    47.605     0.200
     1.567    47.135     0.200
     2.001    59.815     0.200
     2.788    80.915     0.200
     0.514    17.098     0.200
     0.690    22.488     0.200
     0.690    22.608     0.200
     0.708    22.758     0.200
     1.102    34.938     0.200
     1.102    34.798     0.200
     1.222    37.728     0.200
     1.327    41.798     0.200
     1.327    42.478     0.200
     1.326    41.218     0.200
     1.412    44.678     0.200
     1.550    48.838     0.200
     1.614    49.878     0.200
     0.554    17.773     0.200
     0.757    24.992     0.200
     0.678    22.961     0.200
     0.840    27.070     0.200
     0.834    27.930     0.200
     0.845    27.578     0.200
     0.867    28.164     0.200
     0.931    28.828     0.200
     0.991    32.703     0.200
     1.068    32.820     0.200
     1.068    33.484     0.200
     1.179    35.398     0.200
     1.635    48.695     0.200
     0.593    19.664     0.200
     0.642    21.473     0.200
     0.642    21.211     0.200
     0.642    20.781     0.200
     1.013    32.113     0.200
     1.270    39.234     0.200
     1.251    42.844     0.200
     1.251    40.312     0.200
     1.251    40.574     0.200
     1.322    41.242     0.200
     1.466    47.324     0.200
     1.520    46.113     0.200
     2.228    67.664     0.200
     2.291    68.512     0.200
     3.175    93.344     0.200
     0.630    21.203     0.200
     0.630    18.996     0.200
     0.601    19.875     0.200
     1.008    31.645     0.200
     1.242    38.684     0.200
     1.520    45.586     0.200
     0.654    21.535     0.200
     0.653    21.535     0.200
     0.653    20.738     0.200
     1.019    31.988     0.200
     1.280    39.719     0.200
     1.261    38.426     0.200
     1.261    40.785     0.200
     1.382    42.977     0.200
     1.524    45.719     0.200
     3.169    91.727     0.200
     1.039    34.238     0.200
     1.013    31.969     0.200
     1.299    39.117     0.200
     1.260    38.539     0.200
     1.260    40.828     0.200
     1.260    42.758     0.200
     1.450    42.918     0.200
     1.390    42.008     0.200
     1.513    44.707     0.200
     1.513    45.387     0.200
     1.513    44.488     0.200
     0.539    17.930     0.200
     0.682    21.648     0.200
     0.682    21.668     0.200
     0.960    31.238     0.200
     1.099    34.078     0.200
     1.108    35.867     0.200
     1.132    36.199     0.200
     1.128    35.680     0.200
     1.170    36.098     0.200
     1.371    43.520     0.200
     1.495    46.129     0.200
     0.604    19.783     0.200
     0.604    20.045     0.200
     1.026    32.373     0.200
     1.026    32.584     0.200
     1.165    36.584     0.200
     1.229    37.443     0.200
     1.416    42.635     0.200
     1.557    46.545     0.200
     1.816    54.123     0.200
     0.602    20.352     0.200
     0.602    19.969     0.200
     0.603    20.055     0.200
     0.620    20.609     0.200
     0.769    24.617     0.200
     1.064    34.906     0.200
     1.079    33.805     0.200
     1.033    32.422     0.200
     1.033    33.211     0.200
     1.145    37.156     0.200
     1.209    38.219     0.200
     1.229    37.758     0.200
     1.229    39.445     0.200
     1.292    40.469     0.200
     1.408    45.055     0.200
     1.453    43.531     0.200
     1.413    44.031     0.200
     1.567    49.734     0.200
     0.348    11.684     0.200
     0.348    11.941     0.200
     1.228    38.691     0.200
     1.228    39.730     0.200
     1.192    37.543     0.200
     1.192    37.262     0.200
     1.382    43.980     0.200
     0.624    21.645     0.200
     0.601    18.434     0.200
     0.600    20.305     0.200
     0.621    20.844     0.200
     1.065    34.844     0.200
     1.066    34.703     0.200
     1.066    34.824     0.200
     1.030    32.375     0.200
     1.126    36.254     0.200
     1.148    36.562     0.200
     1.210    40.055     0.200
     1.226    37.684     0.200
     1.226    38.172     0.200
     1.410    45.445     0.200
     1.411    44.152     0.200
     1.570    49.184     0.200
     1.563    47.004     0.200
     1.563    50.195     0.200
     1.617    50.375     0.200
     3.801   113.934     0.200
     4.643   135.285     0.200
     0.369    12.612     0.200
     0.369    13.093     0.200
     1.201    37.152     0.200
     1.201    37.853     0.200
     1.201    36.683     0.200
     1.266    38.282     0.200
     1.266    39.022     0.200
     1.365    42.462     0.200
     1.365    43.232     0.200
     1.350    42.393     0.200
     1.638    49.112     0.200
     1.638    52.582     0.200
     1.638    53.252     0.200
     1.572    49.702     0.200
     1.896    55.782     0.200
     0.603    20.145     0.200
     0.618    20.453     0.200
     0.780    24.824     0.200
     1.015    32.475     0.200
     1.225    39.303     0.200
     1.225    40.064     0.200
     1.225    41.014     0.200
     1.242    41.623     0.200
     1.309    41.863     0.200
     1.421    47.414     0.200
     1.541    47.895     0.200
     1.561    49.334     0.200
     0.618    20.297     0.200
     0.618    19.984     0.200
     0.604    20.406     0.200
     0.770    24.887     0.200
     1.238    39.414     0.200
     1.238    41.926     0.200
     1.238    39.707     0.200
     1.325    41.977     0.200
     1.547    48.105     0.200
     1.547    49.766     0.200
     0.602    19.871     0.200
     0.619    20.230     0.200
     0.618    20.211     0.200
     1.088    36.371     0.200
     1.039    32.512     0.200
     1.039    33.211     0.200
     1.090    33.973     0.200
     1.167    36.812     0.200
     1.235    40.781     0.200
     1.243    39.172     0.200
     1.243    41.871     0.200
     1.243    39.723     0.200
     1.314    41.512     0.200
     1.568    47.480     0.200
     1.568    48.012     0.200
     2.550    76.621     0.200
     3.147    94.871     0.200
     0.597    20.141     0.200
     0.624    20.172     0.200
     0.623    20.000     0.200
     0.762    24.461     0.200
     1.032    33.211     0.200
     1.032    32.992     0.200
     1.193    37.023     0.200
     1.245    39.070     0.200
     1.245    39.734     0.200
     1.556    46.555     0.200
     1.556    46.961     0.200
     0.578    19.285     0.200
     0.643    20.516     0.200
     0.643    20.414     0.200
     0.740    23.832     0.200
     1.054    33.113     0.200
     1.054    33.395     0.200
     1.265    39.773     0.200
     1.265    41.293     0.200
     1.342    42.742     0.200
     1.578    50.652     0.200
     1.655    51.105     0.200
     1.925    58.715     0.200
     0.683    22.583     0.200
     0.988    31.453     0.200
     1.167    36.243     0.200
     1.246    37.522     0.200
     1.479    43.863     0.200
     1.479    44.373     0.200
     1.465    45.593     0.200
     1.690    49.502     0.200
     1.690    49.812     0.200
     1.886    55.713     0.200
     0.578    18.383     0.200
     0.578    18.395     0.200
     0.816    26.742     0.200
     0.784    25.172     0.200
     0.978    32.133     0.200
     0.983    30.125     0.200
     0.983    30.984     0.200
     1.001    32.102     0.200
     1.040    33.594     0.200
     1.040    33.473     0.200
     1.064    33.473     0.200
     1.044    32.824     0.200
     1.209    37.805     0.200
     1.209    38.172     0.200
     1.209    39.543     0.200
     1.371    43.133     0.200
     2.037    63.055     0.200
     0.368    14.109     0.200
     0.928    28.499     0.200
     0.928    29.109     0.200
     0.834    26.699     0.200
     0.807    26.139     0.200
     0.821    26.959     0.200
     0.962    29.159     0.200
     0.944    30.689     0.200
     0.951    31.679     0.200
     0.982    31.389     0.200
     0.982    31.279     0.200
     1.059    34.659     0.200
     1.169    37.039     0.200
     1.671    52.489     0.200
     1.752    55.529     0.200
     1.849    58.089     0.200
     1.930    60.049     0.200
     2.085    65.089     0.200
     2.127    65.519     0.200
     2.157    67.149     0.200
     2.174    67.749     0.200
     2.260    70.269     0.200
     2.312    72.079     0.200
     2.319    71.609     0.200
     2.444    75.159     0.200
     3.291    97.319     0.200
     0.802    25.616     0.200
     0.828    26.656     0.200
     0.816    26.646     0.200
     0.928    27.256     0.200
     0.928    28.426     0.200
     0.986    31.246     0.200
     0.986    31.136     0.200
     1.305    38.426     0.200
     1.477    45.586     0.200
     1.542    46.526     0.200
     0.236     8.078     0.200
     0.354    13.648     0.200
     0.565    19.199     0.200
     0.642    20.277     0.200
     0.755    24.320     0.200
     0.945    30.387     0.200
     1.088    34.117     0.200
     1.088    33.887     0.200
     1.351    42.090     0.200
     1.437    44.418     0.200
     1.662    50.637     0.200
     1.689    51.668     0.200
     0.238     8.352     0.200
     0.238     8.371     0.200
     0.967    30.562     0.200
     1.123    34.242     0.200
     1.225    37.133     0.200
     1.334    40.043     0.200
     1.430    43.832     0.200
     1.475    45.043     0.200
     1.929    58.641     0.200
     1.963    58.699     0.200
     0.387    13.297     0.200
     0.473    13.773     0.200
     0.826    26.816     0.200
     0.840    27.605     0.200
     0.849    28.254     0.200
     0.849    27.816     0.200
     0.892    28.727     0.200
     0.971    32.047     0.200
     0.972    30.016     0.200
     0.912    28.996     0.200
     0.912    29.555     0.200
     1.036    33.375     0.200
     0.987    31.914     0.200
     0.987    31.184     0.200
     0.987    32.465     0.200
     1.099    33.273     0.200
     1.230    41.895     0.200
     1.314    39.766     0.200
     1.954    56.594     0.200
     0.651    22.574     0.200
     0.841    27.773     0.200
     0.834    27.883     0.200
     0.884    28.691     0.200
     0.964    29.352     0.200
     0.964    29.883     0.200
     0.956    31.324     0.200
     0.913    28.715     0.200
     0.913    29.293     0.200
     0.964    31.203     0.200
     0.992    31.684     0.200
     0.992    30.895     0.200
     1.075    34.191     0.200
     1.174    35.902     0.200
     1.100    33.414     0.200
     1.100    32.973     0.200
     1.100    35.523     0.200
     1.229    36.414     0.200
     0.497    16.629     0.200
     0.846    27.770     0.200
     0.842    28.762     0.200
     0.891    29.430     0.200
     0.891    29.570     0.200
     0.965    31.691     0.200
     0.965    31.961     0.200
     0.890    27.961     0.200
     1.012    32.551     0.200
     1.094    35.109     0.200
     1.094    37.422     0.200
     1.122    34.102     0.200
     1.122    36.512     0.200
     1.122    36.961     0.200
     1.179    37.160     0.200
     0.533    17.016     0.200
     0.534    17.277     0.200
     0.857    28.555     0.200
     0.857    28.098     0.200
     0.877    28.938     0.200
     0.856    29.188     0.200
     0.850    28.395     0.200
     0.914    29.266     0.200
     1.042    32.777     0.200
     0.991    32.266     0.200
     1.160    36.445     0.200
     1.160    36.176     0.200
     1.160    36.918     0.200
     1.134    36.227     0.200
     1.117    35.797     0.200
     1.279    40.035     0.200
     0.794    25.527     0.200
     0.924    28.707     0.200
     0.924    28.848     0.200
     0.924    29.688     0.200
     0.943    29.898     0.200
     0.997    32.078     0.200
     0.997    31.469     0.200
     1.095    35.707     0.200
     1.095    36.148     0.200
     1.095    36.809     0.200
     1.149    36.000     0.200
     1.216    36.930     0.200
     1.216    37.438     0.200
     1.216    36.777     0.200
     1.306    39.789     0.200
     1.292    40.629     0.200
     0.489    16.004     0.200
     0.817    26.586     0.200
     0.833    27.555     0.200
     0.902    26.617     0.200
     0.902    27.445     0.200
     0.902    29.066     0.200
     0.952    29.957     0.200
     1.007    32.145     0.200
     1.007    31.547     0.200
     1.113    34.625     0.200
     1.113    36.727     0.200
     1.292    39.047     0.200
     1.433    42.637     0.200
     1.483    43.617     0.200
     1.947    62.336     0.200
     0.762    24.902     0.200
     0.696    22.781     0.200
     1.197    39.121     0.200
     1.197    38.543     0.200
     1.071    34.441     0.200
     1.071    35.312     0.200
     1.264    40.352     0.200
     1.387    45.492     0.200
     1.308    41.223     0.200
     1.308    42.332     0.200
     1.415    44.242     0.200
     1.415    44.391     0.200
     1.519    49.980     0.200
     2.337    70.344     0.200
     0.953    32.533     0.200
     0.725    22.934     0.200
     1.167    36.543     0.200
     1.514    48.033     0.200
     1.598    52.014     0.200
     1.564    48.484     0.200
     1.845    57.273     0.200
     0.620    20.112     0.200
     1.018    34.982     0.200
     1.018    32.062     0.200
     1.032    32.242     0.200
     1.039    34.003     0.200
     1.092    34.582     0.200
     1.072    33.633     0.200
     1.072    34.263     0.200
     1.072    33.173     0.200
     1.086    34.763     0.200
     1.250    39.562     0.200
     1.250    40.332     0.200
     1.250    40.633     0.200
     1.250    38.792     0.200
     1.286    41.122     0.200
     0.619    19.268     0.200
     1.075    33.328     0.200
     1.075    34.389     0.200
     1.005    34.488     0.200
     1.040    33.998     0.200
     1.079    34.049     0.200
     1.250    39.119     0.200
     1.250    41.188     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
