#!/bin/bash
gmt begin penasco2.16_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source penasco2.16'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.551    -0.090     0.200
     0.614    -0.342     0.200
     0.643     0.221     0.200
     0.655     0.045     0.200
     0.655     0.170     0.200
     0.542    -0.444     0.200
     0.570    -0.435     0.200
     0.830     0.188     0.200
     0.895     1.742     0.200
     0.512    -0.394     0.200
     0.879     0.329     0.200
     0.743     0.285     0.200
     0.833     0.948     0.200
     0.929    -0.298     0.200
     0.609    -0.499     0.200
     0.626     0.571     0.200
     0.753     0.068     0.200
     0.570     0.017     0.200
     0.686    -0.171     0.200
     0.796    -0.311     0.200
     0.936     0.433     0.200
     0.345     0.211     0.200
     0.640    -0.614     0.200
     0.735    -0.263     0.200
     0.615     0.247     0.200
     0.875    -0.002     0.200
     0.913    -0.394     0.200
     0.591     0.146     0.200
     0.839    -0.309     0.200
     0.619     0.533     0.200
     0.880     0.201     0.200
     0.880    -0.299     0.200
     0.600     0.278     0.200
     0.866    -0.353     0.200
     0.720     0.204     0.200
     0.975    -0.459     0.200
     0.613     0.244     0.200
     0.632    -0.054     0.200
     0.807     0.412     0.200
     0.988    -0.506     0.200
     0.988    -0.386     0.200
     0.661    -0.602     0.200
     0.616     0.072     0.200
     0.826     0.019     0.200
     0.981    -0.865     0.200
     0.981    -0.484     0.200
     0.609    -0.197     0.200
     0.612    -0.322     0.200
     0.773     0.157     0.200
     0.708    -0.112     0.200
     0.816    -0.451     0.200
     0.923     0.688     0.200
     0.930    -0.457     0.200
     0.941    -1.087     0.200
     0.585     0.027     0.200
     0.673    -0.403     0.200
     0.790    -0.021     0.200
     0.801    -0.080     0.200
     0.705     0.171     0.200
     0.952     0.288     0.200
     0.973    -0.400     0.200
     0.665     0.243     0.200
     0.390     0.291     0.200
     0.819     0.302     0.200
     0.819     0.415     0.200
     0.395     0.196     0.200
     0.449     0.181     0.200
     0.810     0.045     0.200
     0.769     0.264     0.200
     0.519     0.228     0.200
     0.753    -0.121     0.200
     0.787    -0.663     0.200
     0.939     0.102     0.200
     0.933    -0.284     0.200
     0.954     0.231     0.200
     0.963    -0.524     0.200
     0.510     0.685     0.200
     0.778     0.074     0.200
     0.756    -0.468     0.200
     0.926    -0.500     0.200
     0.945     0.790     0.200
     0.955     0.007     0.200
     0.978     0.049     0.200
     0.941    -0.462     0.200
     0.532     0.286     0.200
     0.799    -0.199     0.200
     0.941    -0.586     0.200
     0.967    -0.390     0.200
     0.976    -0.718     0.200
     0.999     0.224     0.200
     0.476     0.565     0.200
     0.743     0.600     0.200
     0.934    -1.015     0.200
     0.934    -0.855     0.200
     0.890    -0.511     0.200
     0.919    -0.099     0.200
     0.947     0.142     0.200
     0.215     0.239     0.200
     0.204     0.223     0.200
     0.402     0.210     0.200
     0.513    -0.151     0.200
     0.778    -0.061     0.200
     0.871     0.005     0.200
     0.862    -0.191     0.200
     0.547     0.268     0.200
     0.707    -0.005     0.200
     0.752    -0.432     0.200
     0.447     0.157     0.200
     0.600    -0.157     0.200
     0.718     0.185     0.200
     0.794    -0.057     0.200
     0.716     0.087     0.200
     0.737    -0.042     0.200
     0.959     0.148     0.200
     0.321     0.517     0.200
     0.466     0.087     0.200
     0.593     0.171     0.200
     0.761    -0.299     0.200
     0.787    -0.034     0.200
     0.827    -0.317     0.200
     0.863    -0.156     0.200
     0.906     0.451     0.200
     0.947    -0.227     0.200
     0.947    -0.336     0.200
     0.998    -0.620     0.200
     0.503     0.206     0.200
     0.736    -0.509     0.200
     0.736     0.252     0.200
     0.883    -0.271     0.200
     0.949    -0.430     0.200
     0.213     0.243     0.200
     0.802     0.119     0.200
     0.979     0.571     0.200
     0.414    -0.308     0.200
     0.459     0.929     0.200
     0.823    -0.206     0.200
     0.860    -0.587     0.200
     0.894    -0.318     0.200
     0.948    -0.371     0.200
     0.456     0.269     0.200
     0.815     0.684     0.200
     0.452     0.213     0.200
     0.427     0.272     0.200
     0.448     0.312     0.200
     0.560     0.743     0.200
     0.560     0.124     0.200
     0.591    -0.710     0.200
     0.645     0.083     0.200
     0.771    -0.218     0.200
     0.835    -0.055     0.200
     0.835     0.426     0.200
     0.315     0.280     0.200
     0.337     0.312     0.200
     0.739     0.218     0.200
     0.706     0.004     0.200
     0.974    -0.434     0.200
     0.964     0.193     0.200
     0.704     0.118     0.200
     0.981     0.200     0.200
     0.971    -0.465     0.200
     0.733     0.271     0.200
     0.929     0.261     0.200
     0.618     0.322     0.200
     0.616     0.074     0.200
     0.801    -0.383     0.200
     0.992    -0.850     0.200
     0.992    -0.681     0.200
     0.573     0.197     0.200
     0.863    -0.068     0.200
     0.863     0.672     0.200
     0.922    -0.016     0.200
     0.563     0.246     0.200
     0.859    -0.183     0.200
     0.933     0.051     0.200
     0.550     0.331     0.200
     0.905    -0.273     0.200
     0.905    -0.453     0.200
     0.939     0.220     0.200
     0.583     0.310     0.200
     0.913     0.213     0.200
     0.854     0.534     0.200
     0.569     0.353     0.200
     0.847     0.228     0.200
     0.929     0.094     0.200
     0.536     0.304     0.200
     0.861     0.269     0.200
     0.861    -0.110     0.200
     0.960    -0.182     0.200
     0.533     0.140     0.200
     0.893    -0.062     0.200
     0.958    -0.223     0.200
     0.540     0.359     0.200
     0.909    -0.322     0.200
     0.909    -0.810     0.200
     0.949    -0.308     0.200
     0.511     0.244     0.200
     0.890    -0.361     0.200
     0.890    -0.189     0.200
     0.568     0.223     0.200
     0.920    -0.099     0.200
     0.942    -0.015     0.200
     0.942     0.094     0.200
     0.542     0.199     0.200
     0.924     0.384     0.200
     0.946    -0.009     0.200
     0.549     0.217     0.200
     0.900     0.153     0.200
     0.941    -0.000     0.200
     0.580     0.201     0.200
     0.854     0.600     0.200
     0.854     0.460     0.200
     0.916     0.203     0.200
     0.549     0.273     0.200
     0.946     0.130     0.200
     0.613     0.215     0.200
     0.901     0.235     0.200
     0.901     0.493     0.200
     0.588     0.258     0.200
     0.944    -0.083     0.200
     0.555     0.229     0.200
     0.933    -0.532     0.200
     0.933    -0.673     0.200
     0.933    -0.346     0.200
     0.959     0.113     0.200
     0.948     0.237     0.200
     0.591     0.230     0.200
     0.897     0.038     0.200
     0.941    -0.174     0.200
     0.941     0.205     0.200
     0.541     0.147     0.200
     0.949     0.082     0.200
     0.898     0.469     0.200
     0.898    -0.022     0.200
     0.586     0.141     0.200
     0.903    -0.005     0.200
     0.949    -0.152     0.200
     0.949    -0.432     0.200
     0.584     0.339     0.200
     0.906     0.176     0.200
     0.898    -0.182     0.200
     0.898     0.029     0.200
     0.580     0.246     0.200
     0.872    -0.063     0.200
     0.872     1.105     0.200
     0.913    -0.181     0.200
     0.596     0.285     0.200
     0.899    -0.320     0.200
     0.582     0.127     0.200
     0.906     0.086     0.200
     0.949     0.082     0.200
     0.562     0.074     0.200
     0.927    -0.077     0.200
     0.952     0.296     0.200
     0.952     1.077     0.200
     0.581     0.244     0.200
     0.911    -0.009     0.200
     0.986    -0.609     0.200
     0.593     0.207     0.200
     0.895    -0.199     0.200
     0.960    -0.074     0.200
     0.960     0.247     0.200
     0.475     0.670     0.200
     0.474     0.652     0.200
     0.543    -0.536     0.200
     0.717    -0.395     0.200
     0.749     0.394     0.200
     0.749    -0.006     0.200
     0.825    -0.551     0.200
     0.917    -0.116     0.200
     0.917    -0.145     0.200
     0.460     1.490     0.200
     0.459     0.512     0.200
     0.540     0.015     0.200
     0.540    -0.155     0.200
     0.734    -0.320     0.200
     0.734     0.430     0.200
     0.727    -0.252     0.200
     0.830    -0.376     0.200
     0.902     0.698     0.200
     0.909    -0.311     0.200
     0.920    -0.469     0.200
     0.960    -0.227     0.200
     0.960     0.013     0.200
     0.999    -0.130     0.200
     0.595     0.214     0.200
     0.893    -0.139     0.200
     0.946     0.506     0.200
     0.578     0.243     0.200
     0.913     0.202     0.200
     0.984    -0.069     0.200
     0.984     0.048     0.200
     0.567     0.356     0.200
     0.927    -0.048     0.200
     0.995    -0.556     0.200
     0.995    -0.236     0.200
     0.583     0.188     0.200
     0.906    -0.279     0.200
     0.905    -0.049     0.200
     0.905     0.831     0.200
     0.581     0.163     0.200
     0.869     1.424     0.200
     0.869     1.203     0.200
     0.912    -0.195     0.200
     0.585     0.332     0.200
     0.902    -0.002     0.200
     0.595     0.192     0.200
     0.894    -0.189     0.200
     0.478     0.290     0.200
     0.847    -0.248     0.200
     0.507     0.341     0.200
     0.859     0.482     0.200
     0.992    -0.087     0.200
     0.473     0.259     0.200
     0.822     0.065     0.200
     0.584     0.264     0.200
     0.904    -0.037     0.200
     0.935     0.253     0.200
     0.571     0.227     0.200
     0.883    -0.314     0.200
     0.883     0.725     0.200
     0.921    -0.396     0.200
     0.541     0.118     0.200
     0.950    -0.319     0.200
     0.950     0.705     0.200
     0.586     0.206     0.200
     0.902    -0.071     0.200
     0.937    -0.400     0.200
     0.937     0.480     0.200
     0.731     0.220     0.200
     0.548     0.285     0.200
     0.930     0.699     0.200
     0.940     0.306     0.200
     0.555     0.338     0.200
     0.935    -0.139     0.200
     0.971     0.254     0.200
     0.971    -0.105     0.200
     0.553     0.325     0.200
     0.939    -0.212     0.200
     0.939     1.128     0.200
     0.578     0.309     0.200
     0.898     0.722     0.200
     0.898     0.504     0.200
     0.911    -0.241     0.200
     0.566     0.254     0.200
     0.901     0.101     0.200
     0.901    -0.157     0.200
     0.923    -0.232     0.200
     0.595     0.229     0.200
     0.893    -0.368     0.200
     0.914     0.453     0.200
     0.914    -0.461     0.200
     0.564     0.228     0.200
     0.925    -0.201     0.200
     0.911    -0.007     0.200
     0.911     1.321     0.200
     0.678     0.128     0.200
     0.572     0.281     0.200
     0.917     0.011     0.200
     0.970    -0.219     0.200
     0.970    -0.109     0.200
     0.890    -0.055     0.200
     0.577     0.203     0.200
     0.863     0.178     0.200
     0.863     0.909     0.200
     0.918    -0.420     0.200
     0.581     0.280     0.200
     0.903    -0.169     0.200
     0.903     0.011     0.200
     0.908    -0.089     0.200
     0.515     0.218     0.200
     0.871     0.166     0.200
     0.980     0.337     0.200
     0.543     0.269     0.200
     0.870    -0.557     0.200
     0.870     0.138     0.200
     0.951    -0.187     0.200
     0.545     0.140     0.200
     0.906    -0.344     0.200
     0.516     0.292     0.200
     0.894     0.056     0.200
     0.894    -0.085     0.200
     0.535     0.328     0.200
     0.954    -0.003     0.200
     0.966    -0.050     0.200
     0.540     0.256     0.200
     0.890    -0.087     0.200
     0.890     0.123     0.200
     0.951    -0.310     0.200
     0.579     0.188     0.200
     0.908    -0.215     0.200
     0.908    -0.385     0.200
     0.910     0.102     0.200
     0.563     0.245     0.200
     0.892     0.785     0.200
     0.928    -0.065     0.200
     0.560     0.227     0.200
     0.858     0.878     0.200
     0.936    -0.084     0.200
     0.570     0.180     0.200
     0.926     0.166     0.200
     0.860     0.494     0.200
     0.558     0.178     0.200
     0.884    -0.415     0.200
     0.884     0.335     0.200
     0.934    -0.113     0.200
     0.560     0.268     0.200
     0.929    -0.356     0.200
     0.957     0.183     0.200
     0.574     0.261     0.200
     0.921    -0.258     0.200
     0.565     0.290     0.200
     0.927    -0.113     0.200
     0.647     0.180     0.200
     0.846    -0.121     0.200
     0.985     0.201     0.200
     0.985     0.998     0.200
     0.633     0.404     0.200
     0.879    -0.031     0.200
     0.564     0.235     0.200
     0.885     0.742     0.200
     0.928    -0.251     0.200
     0.525     0.158     0.200
     0.910     0.930     0.200
     0.964     0.075     0.200
     0.560     0.125     0.200
     0.929    -0.058     0.200
     0.554     0.286     0.200
     0.912     0.143     0.200
     0.934    -0.022     0.200
     0.565     0.216     0.200
     0.840    -0.653     0.200
     0.840     0.597     0.200
     0.562     0.343     0.200
     0.926    -0.108     0.200
     0.569     0.282     0.200
     0.895     0.461     0.200
     0.895     0.322     0.200
     0.921     0.354     0.200
     0.569     0.218     0.200
     0.867     0.763     0.200
     0.925     0.153     0.200
     0.570     0.152     0.200
     0.849     0.037     0.200
     0.849     0.885     0.200
     0.928     0.167     0.200
     0.575     0.280     0.200
     0.895    -0.402     0.200
     0.895     0.309     0.200
     0.915    -0.188     0.200
     0.595     0.326     0.200
     0.956    -0.463     0.200
     0.585     0.315     0.200
     0.951    -0.175     0.200
     0.578     0.299     0.200
     0.911     0.301     0.200
     0.581     0.215     0.200
     0.907    -0.023     0.200
     0.956     0.002     0.200
     0.573     0.270     0.200
     0.890     0.804     0.200
     0.917    -0.248     0.200
     0.566     0.269     0.200
     0.922    -0.018     0.200
     0.914     0.582     0.200
     0.914     0.460     0.200
     0.557     0.208     0.200
     0.931    -0.133     0.200
     0.935    -0.457     0.200
     0.935     0.516     0.200
     0.543     0.180     0.200
     0.927    -0.340     0.200
     0.927     0.258     0.200
     0.471     0.222     0.200
     0.824     0.199     0.200
     0.571     0.225     0.200
     0.877     0.231     0.200
     0.921    -0.044     0.200
     0.540     0.266     0.200
     0.958    -0.397     0.200
     0.559     0.210     0.200
     0.860     0.183     0.200
     0.860     0.853     0.200
     0.936    -0.281     0.200
     0.624     0.170     0.200
     0.952     0.299     0.200
     0.552     0.225     0.200
     0.905    -0.195     0.200
     0.905     0.285     0.200
     0.937    -0.194     0.200
     0.840    -0.420     0.200
     0.804     0.241     0.200
     0.627     0.157     0.200
     0.661     0.185     0.200
     0.923    -0.167     0.200
     0.694     0.238     0.200
     0.654     0.296     0.200
     0.935    -0.228     0.200
     0.616     0.282     0.200
     0.757     0.185     0.200
     0.923     0.105     0.200
     0.743     0.276     0.200
     0.917     0.037     0.200
     0.734     0.331     0.200
     0.929    -0.073     0.200
     0.661     0.231     0.200
     0.932    -0.444     0.200
     0.637     0.273     0.200
     0.925     0.038     0.200
     0.628     0.288     0.200
     0.955    -0.554     0.200
     0.777     0.063     0.200
     0.871     0.294     0.200
     0.733     0.135     0.200
     0.924    -0.447     0.200
     0.932    -0.021     0.200
     0.731     0.294     0.200
     0.746     0.373     0.200
     0.929     0.118     0.200
     0.630     0.286     0.200
     0.903    -0.056     0.200
     0.639     0.304     0.200
     0.923    -0.315     0.200
     0.598     0.297     0.200
     0.926    -0.177     0.200
     0.632     0.245     0.200
     0.939     0.158     0.200
     0.609     0.259     0.200
     0.612     0.457     0.200
     0.945    -0.288     0.200
     0.675     0.228     0.200
     0.930    -0.360     0.200
     0.673     0.295     0.200
     0.761    -0.102     0.200
     0.919     0.061     0.200
     0.738     0.231     0.200
     0.924    -0.111     0.200
     0.780     0.231     0.200
     0.560     1.033     0.200
     0.589    -0.117     0.200
     0.589     0.073     0.200
     0.646    -0.035     0.200
     0.773    -0.253     0.200
     0.773    -0.733     0.200
     0.835    -0.184     0.200
     0.996     0.351     0.200
     0.242     0.184     0.200
     0.828     0.168     0.200
     0.815     0.043     0.200
     0.822    -0.109     0.200
     0.824     0.204     0.200
     0.528     0.816     0.200
     0.528     0.837     0.200
     0.564    -0.119     0.200
     0.564    -1.209     0.200
     0.677     0.017     0.200
     0.802    -0.033     0.200
     0.802     0.135     0.200
     0.798    -0.201     0.200
     0.970    -0.349     0.200
     0.970     0.151     0.200
     0.969    -0.160     0.200
     0.987    -0.645     0.200
     0.498     0.578     0.200
     0.552    -0.616     0.200
     0.551    -0.605     0.200
     0.699    -0.170     0.200
     0.813    -0.480     0.200
     0.940     0.241     0.200
     0.940    -0.407     0.200
     0.958    -0.653     0.200
     0.558     1.427     0.200
     0.619    -0.544     0.200
     0.619     0.250     0.200
     0.593     0.011     0.200
     0.592     0.062     0.200
     0.528     0.605     0.200
     0.528     0.634     0.200
     0.566    -0.295     0.200
     0.565    -0.315     0.200
     0.676     0.579     0.200
     0.802    -0.082     0.200
     0.797     0.316     0.200
     0.797    -0.113     0.200
     0.970    -0.543     0.200
     0.968     0.049     0.200
     0.968     0.252     0.200
     0.507     1.077     0.200
     0.507     0.434     0.200
     0.573    -0.700     0.200
     0.573    -0.728     0.200
     0.680    -0.121     0.200
     0.792    -0.176     0.200
     0.792    -0.793     0.200
     0.968     0.320     0.200
     0.551     0.170     0.200
     0.550     0.144     0.200
     0.726    -0.056     0.200
     0.824    -0.297     0.200
     0.824    -0.586     0.200
     0.888     0.711     0.200
     0.906    -1.002     0.200
     0.949     0.879     0.200
     0.983     0.196     0.200
     0.558    -0.084     0.200
     0.558    -0.079     0.200
     0.710     0.137     0.200
     0.813    -0.257     0.200
     0.998     0.268     0.200
     0.500     1.318     0.200
     0.566    -0.238     0.200
     0.566    -0.270     0.200
     0.688     0.233     0.200
     0.799     0.012     0.200
     0.799    -0.388     0.200
     0.796     0.104     0.200
     0.514     0.114     0.200
     0.690    -0.304     0.200
     0.708    -0.692     0.200
     0.402     0.008     0.200
     0.757    -0.067     0.200
     0.840    -0.257     0.200
     0.834     0.240     0.200
     0.867    -0.600     0.200
     0.931    -0.493     0.200
     0.991     1.055     0.200
     0.593     0.329     0.200
     0.642     0.055     0.200
     0.642    -0.061     0.200
     0.740     0.418     0.200
     0.780    -0.420     0.200
     0.630    -0.047     0.200
     0.630    -0.317     0.200
     0.601    -0.294     0.200
     0.724     0.603     0.200
     0.784     0.176     0.200
     0.584     0.337     0.200
     0.654    -0.507     0.200
     0.653    -0.365     0.200
     0.774    -0.220     0.200
     0.588     0.315     0.200
     0.657    -0.382     0.200
     0.656    -0.359     0.200
     0.783    -0.181     0.200
     0.783     0.049     0.200
     0.769     1.209     0.200
     0.768     0.160     0.200
     0.539     0.238     0.200
     0.682    -1.006     0.200
     0.682    -1.000     0.200
     0.696    -0.199     0.200
     0.685     0.554     0.200
     0.685     0.564     0.200
     0.616     0.205     0.200
     0.605     0.126     0.200
     0.604     0.159     0.200
     0.640     0.089     0.200
     0.640     0.172     0.200
     0.772    -0.174     0.200
     0.913    -0.366     0.200
     0.623     0.919     0.200
     0.602     0.086     0.200
     0.602    -0.024     0.200
     0.603    -0.068     0.200
     0.620    -0.048     0.200
     0.769    -0.297     0.200
     0.348     0.232     0.200
     0.624     0.912     0.200
     0.624     1.025     0.200
     0.601     0.271     0.200
     0.600     0.315     0.200
     0.621     0.137     0.200
     0.772    -0.171     0.200
     0.897     0.231     0.200
     0.369     0.340     0.200
     0.603     0.092     0.200
     0.603    -0.017     0.200
     0.618     0.388     0.200
     0.658     0.057     0.200
     0.780    -0.506     0.200
     0.618    -0.272     0.200
     0.618    -0.111     0.200
     0.618    -0.220     0.200
     0.604     0.109     0.200
     0.770    -0.392     0.200
     0.770    -0.283     0.200
     0.602    -0.014     0.200
     0.758    -0.125     0.200
     0.648     0.509     0.200
     0.648     0.448     0.200
     0.619    -0.371     0.200
     0.618    -0.341     0.200
     0.618    -0.450     0.200
     0.597     0.332     0.200
     0.624    -0.626     0.200
     0.623    -0.636     0.200
     0.671    -0.164     0.200
     0.762    -0.517     0.200
     0.578     0.291     0.200
     0.643    -0.723     0.200
     0.675     0.416     0.200
     0.740    -0.565     0.200
     0.683     0.230     0.200
     0.988    -0.258     0.200
     0.541     1.111     0.200
     0.541     1.089     0.200
     0.578    -0.647     0.200
     0.816    -0.178     0.200
     0.784    -0.456     0.200
     0.978     0.375     0.200
     0.983     0.317     0.200
     0.368     0.273     0.200
     0.368     0.245     0.200
     0.462    -0.284     0.200
     0.461    -0.284     0.200
     0.639    -0.192     0.200
     0.821    -0.600     0.200
     0.982    -0.970     0.200
     0.362     0.224     0.200
     0.363     0.253     0.200
     0.464    -0.339     0.200
     0.464    -0.399     0.200
     0.634    -0.260     0.200
     0.828    -0.400     0.200
     0.956    -0.635     0.200
     0.986    -0.981     0.200
     0.986    -0.841     0.200
     0.236    -0.050     0.200
     0.354     0.770     0.200
     0.354     0.761     0.200
     0.460     0.789     0.200
     0.460     0.610     0.200
     0.565    -0.079     0.200
     0.593     0.313     0.200
     0.642    -0.587     0.200
     0.755    -0.495     0.200
     0.725    -0.607     0.200
     0.739    -0.703     0.200
     0.742     0.230     0.200
     0.743     0.514     0.200
     0.785    -0.222     0.200
     0.945    -0.395     0.200
     0.238    -0.207     0.200
     0.238    -0.216     0.200
     0.330     1.196     0.200
     0.599    -0.158     0.200
     0.726    -0.409     0.200
     0.771    -0.619     0.200
     0.824    -0.492     0.200
     0.824    -0.082     0.200
     0.387     0.505     0.200
     0.387     0.635     0.200
     0.472    -0.161     0.200
     0.473    -0.121     0.200
     0.658     0.041     0.200
     0.826    -0.125     0.200
     0.840    -0.619     0.200
     0.849    -0.492     0.200
     0.849    -0.113     0.200
     0.892    -0.479     0.200
     0.971    -0.178     0.200
     0.972    -0.857     0.200
     0.987    -0.769     0.200
     0.379     0.586     0.200
     0.475    -0.246     0.200
     0.474    -0.248     0.200
     0.651     0.224     0.200
     0.819    -0.426     0.200
     0.841    -0.226     0.200
     0.834    -0.697     0.200
     0.884    -0.467     0.200
     0.964    -0.708     0.200
     0.956    -0.320     0.200
     0.956    -0.178     0.200
     0.964     0.510     0.200
     0.992    -0.743     0.200
     0.992    -0.884     0.200
     0.497     0.206     0.200
     0.829     0.096     0.200
     0.846    -0.289     0.200
     0.842     0.514     0.200
     0.891     0.234     0.200
     0.891     0.101     0.200
     0.975     0.278     0.200
     0.890    -0.300     0.200
     0.958     0.051     0.200
     0.415     1.229     0.200
     0.415     1.251     0.200
     0.533    -0.061     0.200
     0.534    -0.080     0.200
     0.690     0.667     0.200
     0.857     0.188     0.200
     0.857    -0.101     0.200
     0.877    -0.300     0.200
     0.856     0.985     0.200
     0.914     0.205     0.200
     0.354     0.060     0.200
     0.810    -0.123     0.200
     0.810     0.158     0.200
     0.943    -0.074     0.200
     0.997    -0.839     0.200
     0.376     0.448     0.200
     0.376     0.509     0.200
     0.489    -0.440     0.200
     0.488    -0.457     0.200
     0.833    -0.511     0.200
     0.952    -0.682     0.200
     0.762     0.459     0.200
     0.696    -0.013     0.200
     0.953     0.085     0.200
     0.725    -0.160     0.200
     0.612     0.184     0.200
     0.589    -0.100     0.200
     0.589     0.804     0.200
     0.620    -0.673     0.200
     0.619    -0.993     0.200
     0.617     0.136     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.901    -1.284     0.200
     0.956    -0.657     0.200
     0.956    -0.947     0.200
     0.943    -0.711     0.200
     0.952    -0.809     0.200
     0.952    -0.304     0.200
     0.994     0.497     0.200
     0.314    -0.992     0.200
     0.826    -0.512     0.200
     0.924    -0.965     0.200
     0.995    -0.610     0.200
     0.987    -0.911     0.200
     0.946    -0.542     0.200
     0.852    -0.630     0.200
     0.975    -1.030     0.200
     0.981    -0.592     0.200
     0.997    -0.949     0.200
     0.765    -0.963     0.200
     0.777    -0.510     0.200
     0.935    -0.850     0.200
     0.970    -0.561     0.200
     0.951    -0.505     0.200
     0.893    -0.471     0.200
     0.981    -0.209     0.200
     0.876     0.185     0.200
     0.900     0.509     0.200
     0.529     0.189     0.200
     0.934    -0.433     0.200
     0.631     0.148     0.200
     0.975    -0.087     0.200
     0.957    -0.409     0.200
     0.860     0.883     0.200
     0.860     0.781     0.200
     0.881    -1.331     0.200
     0.881    -0.651     0.200
     0.910    -1.477     0.200
     0.901    -0.959     0.200
     0.901    -0.662     0.200
     0.936    -0.833     0.200
     0.932    -0.860     0.200
     0.890    -0.540     0.200
     0.945    -0.973     0.200
     0.975    -0.920     0.200
     0.884    -0.580     0.200
     0.942     0.478     0.200
     0.940    -0.582     0.200
     0.886    -0.447     0.200
     0.972    -0.910     0.200
     0.945    -1.150     0.200
     0.802    -0.499     0.200
     0.987    -0.340     0.200
     0.958    -1.448     0.200
     0.923    -1.035     0.200
     0.951    -1.078     0.200
     0.554    -0.491     0.200
     0.896    -1.078     0.200
     0.928    -0.887     0.200
     0.834    -0.410     0.200
     0.962    -0.423     0.200
     0.634    -0.529     0.200
     0.802    -0.320     0.200
     0.828    -0.631     0.200
     0.816    -0.220     0.200
     0.928    -0.713     0.200
     0.945    -0.672     0.200
     0.840    -0.331     0.200
     0.912    -0.476     0.200
     0.913    -0.397     0.200
     0.959     1.110     0.200
     0.924    -0.894     0.200
     0.902    -0.265     0.200
     0.864    -1.175     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.551    -1.153     0.200
     0.614    -0.675     0.200
     0.901     0.231     0.200
     0.643    -0.413     0.200
     0.655    -0.648     0.200
     0.542    -1.398     0.200
     0.570    -0.648     0.200
     0.570    -0.492     0.200
     0.830    -0.834     0.200
     0.829    -0.966     0.200
     0.895     0.533     0.200
     0.512    -0.854     0.200
     0.929    -1.125     0.200
     0.609    -0.764     0.200
     0.753    -0.333     0.200
     0.753    -0.232     0.200
     0.570    -0.067     0.200
     0.686    -0.379     0.200
     0.796    -0.097     0.200
     0.943    -1.838     0.200
     0.640     0.030     0.200
     0.735    -0.647     0.200
     0.994     0.020     0.200
     0.875    -0.918     0.200
     0.913    -0.416     0.200
     0.591     0.593     0.200
     0.826    -0.208     0.200
     0.839     0.261     0.200
     0.619     0.260     0.200
     0.924    -0.452     0.200
     0.880    -0.850     0.200
     0.600    -0.506     0.200
     0.995    -0.898     0.200
     0.995    -0.428     0.200
     0.720    -0.039     0.200
     0.975    -0.078     0.200
     0.613     0.211     0.200
     0.988    -0.597     0.200
     0.988    -0.446     0.200
     0.661     0.225     0.200
     0.616    -0.268     0.200
     0.616     0.751     0.200
     0.826    -0.340     0.200
     0.981    -0.865     0.200
     0.981    -0.974     0.200
     0.981     0.425     0.200
     0.609     0.274     0.200
     0.612    -0.091     0.200
     0.708    -0.321     0.200
     0.708     0.527     0.200
     0.816    -0.828     0.200
     0.923    -1.431     0.200
     0.585    -0.387     0.200
     0.790    -0.176     0.200
     0.705     0.144     0.200
     0.973    -0.266     0.200
     0.665     0.607     0.200
     0.390     0.108     0.200
     0.819    -0.180     0.200
     0.819     0.277     0.200
     0.395    -0.021     0.200
     0.810    -0.596     0.200
     0.769     0.901     0.200
     0.753    -0.459     0.200
     0.753     0.842     0.200
     0.939    -1.214     0.200
     0.939    -0.925     0.200
     0.933    -0.776     0.200
     0.987     1.926     0.200
     0.756    -0.466     0.200
     0.941    -0.742     0.200
     0.967     0.019     0.200
     0.999     1.702     0.200
     0.476     0.403     0.200
     0.743     0.796     0.200
     0.934    -1.268     0.200
     0.934     0.172     0.200
     0.890    -0.376     0.200
     0.215     0.408     0.200
     0.204     0.229     0.200
     0.402     1.737     0.200
     0.513    -0.521     0.200
     0.778     0.254     0.200
     0.871    -0.978     0.200
     0.852    -0.282     0.200
     0.862     0.287     0.200
     0.903     0.675     0.200
     0.547    -0.254     0.200
     0.707     0.692     0.200
     0.752    -0.397     0.200
     0.447     0.676     0.200
     0.600    -0.818     0.200
     0.716    -0.489     0.200
     0.737    -0.368     0.200
     0.959     0.686     0.200
     0.321     0.551     0.200
     0.321     0.832     0.200
     0.466    -0.214     0.200
     0.761     0.214     0.200
     0.777     0.317     0.200
     0.787     0.744     0.200
     0.827    -0.205     0.200
     0.827     0.415     0.200
     0.863     2.045     0.200
     0.906     0.923     0.200
     0.970    -0.481     0.200
     0.503    -0.109     0.200
     0.548     1.470     0.200
     0.736     0.611     0.200
     0.883     1.065     0.200
     0.883     1.226     0.200
     0.213     0.511     0.200
     0.802    -0.254     0.200
     0.979     0.926     0.200
     0.414    -0.726     0.200
     0.414    -0.917     0.200
     0.823     0.059     0.200
     0.894     0.569     0.200
     0.948     0.274     0.200
     0.456    -0.368     0.200
     0.815     0.680     0.200
     0.452     0.053     0.200
     0.427     0.475     0.200
     0.448    -0.320     0.200
     0.591    -0.932     0.200
     0.771     0.037     0.200
     0.771    -0.395     0.200
     0.835     0.057     0.200
     0.315     0.173     0.200
     0.337    -0.463     0.200
     0.337     0.417     0.200
     0.739    -0.004     0.200
     0.951     0.105     0.200
     0.974    -0.485     0.200
     0.964     0.229     0.200
     0.704    -0.443     0.200
     0.981     0.621     0.200
     0.971    -0.515     0.200
     0.929     0.013     0.200
     0.618    -0.079     0.200
     0.616    -0.366     0.200
     0.801    -0.643     0.200
     0.992    -0.973     0.200
     0.992    -0.514     0.200
     0.573     0.162     0.200
     0.863    -0.571     0.200
     0.922    -0.128     0.200
     0.563     0.005     0.200
     0.859    -0.912     0.200
     0.933     0.292     0.200
     0.905     0.152     0.200
     0.939    -0.112     0.200
     0.583    -0.284     0.200
     0.913    -0.289     0.200
     0.569    -0.014     0.200
     0.536    -0.215     0.200
     0.861    -0.202     0.200
     0.960     0.063     0.200
     0.533     0.622     0.200
     0.893     0.455     0.200
     0.893    -0.215     0.200
     0.958    -0.000     0.200
     0.909     1.146     0.200
     0.909     0.314     0.200
     0.949     0.239     0.200
     0.511     0.380     0.200
     0.890    -0.364     0.200
     0.890     0.773     0.200
     0.981    -0.865     0.200
     0.568     0.278     0.200
     0.920     0.021     0.200
     0.942     0.140     0.200
     0.942    -0.110     0.200
     0.542     0.203     0.200
     0.924     0.572     0.200
     0.946    -0.630     0.200
     0.549     0.848     0.200
     0.900     0.192     0.200
     0.941    -0.171     0.200
     0.580     0.116     0.200
     0.916    -0.379     0.200
     0.549     0.368     0.200
     0.946     0.209     0.200
     0.613     0.069     0.200
     0.588    -0.064     0.200
     0.944    -0.663     0.200
     0.944    -0.034     0.200
     0.933     1.228     0.200
     0.933     1.782     0.200
     0.933     0.099     0.200
     0.959    -0.322     0.200
     0.948     0.223     0.200
     0.948    -0.476     0.200
     0.591     0.249     0.200
     0.897     0.207     0.200
     0.941     0.672     0.200
     0.941     0.802     0.200
     0.541     1.124     0.200
     0.949    -0.373     0.200
     0.898    -0.663     0.200
     0.586     0.882     0.200
     0.903    -0.027     0.200
     0.949     0.361     0.200
     0.949    -0.089     0.200
     0.584    -0.099     0.200
     0.906     0.029     0.200
     0.898    -0.510     0.200
     0.898    -0.988     0.200
     0.580     0.018     0.200
     0.872     0.622     0.200
     0.913     0.086     0.200
     0.596     0.391     0.200
     0.899     0.238     0.200
     0.582     0.651     0.200
     0.906    -0.398     0.200
     0.949     0.272     0.200
     0.949     0.830     0.200
     0.562     0.516     0.200
     0.952     0.983     0.200
     0.581     0.111     0.200
     0.911     0.780     0.200
     0.986     1.008     0.200
     0.986    -0.451     0.200
     0.593     0.174     0.200
     0.960     0.159     0.200
     0.960     1.239     0.200
     0.543    -0.647     0.200
     0.543    -0.787     0.200
     0.749     0.708     0.200
     0.749     0.968     0.200
     0.825    -0.785     0.200
     0.917     0.930     0.200
     0.917     0.576     0.200
     0.917     1.416     0.200
     0.934    -0.229     0.200
     0.459     0.729     0.200
     0.540    -0.419     0.200
     0.540    -0.739     0.200
     0.830    -0.855     0.200
     0.902     1.727     0.200
     0.909    -0.409     0.200
     0.920    -0.606     0.200
     0.960    -0.630     0.200
     0.960     0.639     0.200
     0.595     0.230     0.200
     0.893     0.001     0.200
     0.946     1.431     0.200
     0.946    -0.028     0.200
     0.578     0.362     0.200
     0.913     0.139     0.200
     0.984    -0.153     0.200
     0.927    -0.290     0.200
     0.995     0.336     0.200
     0.995    -0.344     0.200
     0.583     0.023     0.200
     0.906    -0.237     0.200
     0.905     0.487     0.200
     0.905     0.827     0.200
     0.581     0.187     0.200
     0.869     1.171     0.200
     0.912    -0.121     0.200
     0.585    -0.163     0.200
     0.902    -0.209     0.200
     0.595     0.201     0.200
     0.894     0.153     0.200
     0.478    -0.657     0.200
     0.507    -0.358     0.200
     0.992    -0.572     0.200
     0.473    -0.014     0.200
     0.584    -0.035     0.200
     0.904     0.793     0.200
     0.935    -0.098     0.200
     0.935     0.082     0.200
     0.883    -0.721     0.200
     0.883    -0.931     0.200
     0.921    -0.780     0.200
     0.541     1.080     0.200
     0.950    -0.002     0.200
     0.586     0.356     0.200
     0.902    -0.275     0.200
     0.937    -0.792     0.200
     0.937     0.907     0.200
     0.548    -0.469     0.200
     0.930    -0.473     0.200
     0.940     0.165     0.200
     0.555    -0.177     0.200
     0.935     0.348     0.200
     0.971    -0.131     0.200
     0.971    -0.371     0.200
     0.553    -0.296     0.200
     0.935     0.764     0.200
     0.939    -0.947     0.200
     0.939     0.684     0.200
     0.578    -0.207     0.200
     0.898     0.297     0.200
     0.898    -0.300     0.200
     0.911     0.215     0.200
     0.566     0.317     0.200
     0.901    -0.528     0.200
     0.595     0.243     0.200
     0.893    -0.085     0.200
     0.564     0.038     0.200
     0.678     0.008     0.200
     0.572    -0.667     0.200
     0.917    -0.371     0.200
     0.970     0.306     0.200
     0.970    -0.612     0.200
     0.577     0.124     0.200
     0.863    -1.117     0.200
     0.918    -0.556     0.200
     0.581     0.015     0.200
     0.903    -0.176     0.200
     0.871     0.124     0.200
     0.871    -0.204     0.200
     0.980     0.430     0.200
     0.543    -0.202     0.200
     0.870    -0.793     0.200
     0.870     1.816     0.200
     0.951    -0.153     0.200
     0.545     1.043     0.200
     0.906    -0.319     0.200
     0.894    -0.495     0.200
     0.975    -0.821     0.200
     0.975    -0.657     0.200
     0.535    -0.270     0.200
     0.954    -0.273     0.200
     0.890    -0.820     0.200
     0.951    -0.067     0.200
     0.579     0.383     0.200
     0.892    -1.480     0.200
     0.928    -0.649     0.200
     0.560     0.336     0.200
     0.858    -1.259     0.200
     0.936    -0.412     0.200
     0.558     0.274     0.200
     0.884    -0.475     0.200
     0.884     1.373     0.200
     0.934     0.097     0.200
     0.560    -0.177     0.200
     0.929    -0.270     0.200
     0.957     1.715     0.200
     0.574     0.147     0.200
     0.921     0.015     0.200
     0.565     0.210     0.200
     0.927     0.363     0.200
     0.881     0.345     0.200
     0.846    -0.695     0.200
     0.985     0.654     0.200
     0.985     0.177     0.200
     0.879    -0.124     0.200
     0.564     0.099     0.200
     0.885    -1.521     0.200
     0.525     0.718     0.200
     0.910     0.914     0.200
     0.964    -0.238     0.200
     0.929     0.135     0.200
     0.554    -0.073     0.200
     0.912    -0.871     0.200
     0.912     0.051     0.200
     0.934    -0.342     0.200
     0.565     0.143     0.200
     0.936    -0.658     0.200
     0.562    -0.436     0.200
     0.926    -0.111     0.200
     0.932     0.046     0.200
     0.569     0.061     0.200
     0.895     1.024     0.200
     0.895     0.184     0.200
     0.921     0.500     0.200
     0.569     0.739     0.200
     0.867     0.145     0.200
     0.867     0.385     0.200
     0.925     0.406     0.200
     0.570     0.831     0.200
     0.849    -0.199     0.200
     0.849     1.270     0.200
     0.928    -0.372     0.200
     0.895    -0.598     0.200
     0.956    -0.112     0.200
     0.585     0.296     0.200
     0.951    -0.401     0.200
     0.578     0.085     0.200
     0.911     0.710     0.200
     0.907    -0.612     0.200
     0.956    -0.247     0.200
     0.573    -0.395     0.200
     0.890     1.585     0.200
     0.917     0.034     0.200
     0.922    -0.204     0.200
     0.914     1.415     0.200
     0.557     0.278     0.200
     0.931    -0.247     0.200
     0.935     0.227     0.200
     0.935    -0.433     0.200
     0.543     0.457     0.200
     0.927    -0.129     0.200
     0.927     0.840     0.200
     0.471     0.076     0.200
     0.877     0.419     0.200
     0.921    -0.303     0.200
     0.540    -0.129     0.200
     0.958    -0.482     0.200
     0.559     0.029     0.200
     0.936    -0.124     0.200
     0.952     1.619     0.200
     0.552     0.165     0.200
     0.905    -0.778     0.200
     0.905     1.242     0.200
     0.937    -0.119     0.200
     0.840    -0.912     0.200
     0.804    -0.202     0.200
     0.661     0.323     0.200
     0.923    -0.203     0.200
     0.935     0.247     0.200
     0.884    -0.321     0.200
     0.757    -0.386     0.200
     0.923     0.598     0.200
     0.917     0.206     0.200
     0.929     0.290     0.200
     0.932     0.077     0.200
     0.637    -0.143     0.200
     0.925     0.238     0.200
     0.628     0.335     0.200
     0.955     0.194     0.200
     0.777    -0.334     0.200
     0.924    -0.688     0.200
     0.924     1.437     0.200
     0.932     0.022     0.200
     0.746     0.127     0.200
     0.929     0.665     0.200
     0.903     0.000     0.200
     0.923    -0.092     0.200
     0.926     0.170     0.200
     0.632    -0.035     0.200
     0.939    -0.145     0.200
     0.609     0.189     0.200
     0.942     0.599     0.200
     0.612     0.358     0.200
     0.945    -0.170     0.200
     0.675    -0.151     0.200
     0.930     0.316     0.200
     0.673    -0.353     0.200
     0.940    -0.231     0.200
     0.761    -0.576     0.200
     0.919     0.774     0.200
     0.738     0.099     0.200
     0.924    -0.229     0.200
     0.589    -0.237     0.200
     0.996     1.053     0.200
     0.242     0.350     0.200
     0.815    -1.025     0.200
     0.824     0.092     0.200
     0.564    -0.880     0.200
     0.798    -1.172     0.200
     0.972     0.931     0.200
     0.970    -0.031     0.200
     0.970     0.070     0.200
     0.969     0.460     0.200
     0.987     1.551     0.200
     0.552    -0.845     0.200
     0.551    -0.755     0.200
     0.813     0.256     0.200
     0.813     0.125     0.200
     0.940     1.261     0.200
     0.941     1.320     0.200
     0.945    -0.958     0.200
     0.958     0.701     0.200
     0.958     1.320     0.200
     0.558     1.051     0.200
     0.619    -0.736     0.200
     0.619    -0.405     0.200
     0.526     1.567     0.200
     0.658    -1.043     0.200
     0.593    -0.896     0.200
     0.592    -0.996     0.200
     0.566    -0.714     0.200
     0.565    -0.648     0.200
     0.802     0.182     0.200
     0.797     0.698     0.200
     0.797    -0.372     0.200
     0.970    -0.094     0.200
     0.968     0.434     0.200
     0.968     0.942     0.200
     0.987     1.222     0.200
     0.507     1.710     0.200
     0.573    -1.142     0.200
     0.573     0.218     0.200
     0.573    -1.156     0.200
     0.680    -0.300     0.200
     0.958     0.649     0.200
     0.551    -0.447     0.200
     0.550    -0.129     0.200
     0.550     0.278     0.200
     0.726    -0.815     0.200
     0.824    -0.733     0.200
     0.824    -1.217     0.200
     0.949     1.353     0.200
     0.983     0.415     0.200
     0.558    -0.723     0.200
     0.558    -0.593     0.200
     0.813    -0.736     0.200
     0.923     0.348     0.200
     0.923     0.590     0.200
     0.998     0.257     0.200
     0.566    -0.701     0.200
     0.566    -0.722     0.200
     0.943     0.159     0.200
     0.951     0.520     0.200
     0.514    -0.171     0.200
     0.690    -0.545     0.200
     0.690    -0.425     0.200
     0.708    -0.876     0.200
     0.554    -0.884     0.200
     0.757     0.431     0.200
     0.678     0.714     0.200
     0.840     0.083     0.200
     0.834     1.112     0.200
     0.845     0.442     0.200
     0.867     0.390     0.200
     0.931    -0.854     0.200
     0.991     1.272     0.200
     0.593    -0.116     0.200
     0.642     0.060     0.200
     0.642    -0.179     0.200
     0.642    -0.609     0.200
     0.630     0.261     0.200
     0.630    -1.946     0.200
     0.601    -0.181     0.200
     0.654    -0.355     0.200
     0.653    -0.333     0.200
     0.653    -1.129     0.200
     0.539    -0.196     0.200
     0.682    -1.162     0.200
     0.682    -1.165     0.200
     0.960     0.142     0.200
     0.604    -0.482     0.200
     0.604    -0.220     0.200
     0.602     0.156     0.200
     0.602    -0.226     0.200
     0.603    -0.163     0.200
     0.620    -0.155     0.200
     0.769    -0.824     0.200
     0.348     0.012     0.200
     0.348     0.270     0.200
     0.624     0.782     0.200
     0.601    -1.671     0.200
     0.600     0.223     0.200
     0.621     0.054     0.200
     0.369    -0.150     0.200
     0.369     0.330     0.200
     0.603     0.074     0.200
     0.618    -0.092     0.200
     0.780    -1.116     0.200
     0.618    -0.236     0.200
     0.618    -0.526     0.200
     0.604     0.365     0.200
     0.770    -0.671     0.200
     0.602    -0.236     0.200
     0.619    -0.373     0.200
     0.618    -0.373     0.200
     0.597     0.101     0.200
     0.624    -0.742     0.200
     0.623    -0.890     0.200
     0.762    -0.779     0.200
     0.578     0.006     0.200
     0.643    -0.911     0.200
     0.643    -1.012     0.200
     0.740    -0.806     0.200
     0.683     0.367     0.200
     0.988     0.193     0.200
     0.578    -0.812     0.200
     0.578    -0.780     0.200
     0.816     0.560     0.200
     0.784    -0.089     0.200
     0.978     1.142     0.200
     0.983    -1.007     0.200
     0.983    -0.148     0.200
     0.368     1.042     0.200
     0.928    -1.010     0.200
     0.928    -0.400     0.200
     0.834    -0.039     0.200
     0.807     0.214     0.200
     0.821     0.626     0.200
     0.962    -1.372     0.200
     0.944     0.713     0.200
     0.951     1.490     0.200
     0.982    -0.012     0.200
     0.982    -0.122     0.200
     0.802    -0.194     0.200
     0.828     0.068     0.200
     0.816     0.417     0.200
     0.928    -2.295     0.200
     0.928    -1.125     0.200
     0.986    -0.308     0.200
     0.986    -0.418     0.200
     0.236    -0.123     0.200
     0.354     1.670     0.200
     0.565     0.315     0.200
     0.642    -1.171     0.200
     0.755    -1.017     0.200
     0.945    -0.526     0.200
     0.238    -0.318     0.200
     0.238    -0.300     0.200
     0.967    -0.461     0.200
     0.387    -0.301     0.200
     0.473    -2.328     0.200
     0.826     0.327     0.200
     0.840     0.693     0.200
     0.849     1.075     0.200
     0.849     0.638     0.200
     0.892     0.289     0.200
     0.971     1.288     0.200
     0.972    -0.805     0.200
     0.912    -0.023     0.200
     0.912     0.536     0.200
     0.987     0.349     0.200
     0.987    -0.381     0.200
     0.987     0.900     0.200
     0.651     1.212     0.200
     0.841     0.819     0.200
     0.834     1.147     0.200
     0.884     0.465     0.200
     0.964    -1.244     0.200
     0.964    -0.713     0.200
     0.956     0.999     0.200
     0.913    -0.349     0.200
     0.913     0.229     0.200
     0.964     0.635     0.200
     0.992    -0.026     0.200
     0.992    -0.815     0.200
     0.497    -0.226     0.200
     0.846     0.313     0.200
     0.842     1.412     0.200
     0.891     0.639     0.200
     0.891     0.780     0.200
     0.965     0.726     0.200
     0.965     0.998     0.200
     0.890    -0.812     0.200
     0.533    -0.784     0.200
     0.534    -0.541     0.200
     0.857     1.165     0.200
     0.857     0.708     0.200
     0.877     0.980     0.200
     0.856     1.827     0.200
     0.850     1.209     0.200
     0.914     0.207     0.200
     0.991     0.934     0.200
     0.794    -0.265     0.200
     0.924    -0.935     0.200
     0.924    -0.794     0.200
     0.924     0.046     0.200
     0.943    -0.302     0.200
     0.997    -0.024     0.200
     0.997    -0.633     0.200
     0.489    -0.564     0.200
     0.817     0.373     0.200
     0.833     0.863     0.200
     0.902    -2.134     0.200
     0.902    -1.306     0.200
     0.902     0.315     0.200
     0.952    -0.270     0.200
     0.762    -0.408     0.200
     0.696    -0.346     0.200
     0.953     1.113     0.200
     0.725    -1.173     0.200
     0.620    -0.673     0.200
     0.619    -1.470     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.901    -0.740     0.200
     0.947    -0.978     0.200
     0.743     0.369     0.200
     0.626    -0.943     0.200
     0.796     0.599     0.200
     0.345     0.090     0.200
     0.735     0.480     0.200
     0.314    -0.434     0.200
     0.591     0.512     0.200
     0.591     0.927     0.200
     0.866    -0.894     0.200
     0.995    -1.735     0.200
     0.632    -1.254     0.200
     0.632     0.866     0.200
     0.807     0.403     0.200
     0.826     0.363     0.200
     0.612     1.147     0.200
     0.773     0.368     0.200
     0.585     0.033     0.200
     0.585     0.721     0.200
     0.673    -0.324     0.200
     0.673     0.758     0.200
     0.449     0.126     0.200
     0.939     0.327     0.200
     0.954     0.598     0.200
     0.941    -1.483     0.200
     0.941    -1.056     0.200
     0.676     0.803     0.200
     0.752    -1.547     0.200
     0.718    -0.771     0.200
     0.794     0.249     0.200
     0.975    -1.452     0.200
     0.997    -0.685     0.200
     0.466    -0.246     0.200
     0.935    -0.444     0.200
     0.503    -0.832     0.200
     0.861    -1.352     0.200
     0.949    -0.801     0.200
     0.537     0.045     0.200
     0.811     0.978     0.200
     0.459     0.398     0.200
     0.452     0.391     0.200
     0.560     0.302     0.200
     0.560    -0.866     0.200
     0.645    -0.169     0.200
     0.645     0.722     0.200
     0.739     0.169     0.200
     0.739     0.738     0.200
     0.706    -0.889     0.200
     0.704    -0.503     0.200
     0.704    -0.312     0.200
     0.733    -1.224     0.200
     0.550    -0.504     0.200
     0.905    -1.488     0.200
     0.854     0.206     0.200
     0.847    -0.642     0.200
     0.929     0.800     0.200
     0.540     0.309     0.200
     0.924    -1.001     0.200
     0.854     0.719     0.200
     0.854    -0.265     0.200
     0.876    -0.088     0.200
     0.901     0.704     0.200
     0.901     1.196     0.200
     0.900     0.156     0.200
     0.555     0.122     0.200
     0.529    -0.452     0.200
     0.927    -0.536     0.200
     0.895    -0.449     0.200
     0.475     0.072     0.200
     0.474     0.084     0.200
     0.543    -1.088     0.200
     0.717    -0.428     0.200
     0.734     1.066     0.200
     0.727    -0.741     0.200
     0.830    -0.523     0.200
     0.984    -2.028     0.200
     0.567     0.078     0.200
     0.847    -0.871     0.200
     0.859    -0.566     0.200
     0.859     0.165     0.200
     0.822     0.058     0.200
     0.571     0.040     0.200
     0.947    -1.162     0.200
     0.923    -0.618     0.200
     0.914    -1.133     0.200
     0.925    -0.503     0.200
     0.911     0.861     0.200
     0.911     0.579     0.200
     0.631     0.152     0.200
     0.890    -0.670     0.200
     0.908    -0.847     0.200
     0.515    -0.469     0.200
     0.516     0.088     0.200
     0.966    -2.124     0.200
     0.540     0.239     0.200
     0.908     0.016     0.200
     0.908     0.555     0.200
     0.910    -0.416     0.200
     0.563    -1.027     0.200
     0.858    -0.317     0.200
     0.858    -0.016     0.200
     0.926    -0.718     0.200
     0.881    -2.528     0.200
     0.647     0.441     0.200
     0.633    -0.368     0.200
     0.928    -0.234     0.200
     0.932    -2.033     0.200
     0.895     0.062     0.200
     0.915    -0.194     0.200
     0.595     0.352     0.200
     0.581     0.634     0.200
     0.890    -1.249     0.200
     0.566    -1.117     0.200
     0.945    -1.266     0.200
     0.824     0.304     0.200
     0.571     0.296     0.200
     0.627    -0.458     0.200
     0.975    -1.000     0.200
     0.694     0.393     0.200
     0.654     0.454     0.200
     0.616    -0.645     0.200
     0.743     0.044     0.200
     0.734     0.319     0.200
     0.661    -0.588     0.200
     0.661     0.217     0.200
     0.871    -0.457     0.200
     0.733     0.200     0.200
     0.731     0.297     0.200
     0.630    -0.136     0.200
     0.639     0.010     0.200
     0.598    -0.037     0.200
     0.632    -0.413     0.200
     0.780    -0.460     0.200
     0.886    -0.548     0.200
     0.560     0.010     0.200
     0.589    -1.329     0.200
     0.646    -0.775     0.200
     0.773    -0.613     0.200
     0.773     0.227     0.200
     0.835     0.022     0.200
     0.828     0.755     0.200
     0.822    -0.570     0.200
     0.822     0.202     0.200
     0.528    -0.164     0.200
     0.564    -1.343     0.200
     0.677    -0.874     0.200
     0.677     0.560     0.200
     0.802     0.583     0.200
     0.802     0.383     0.200
     0.798    -0.803     0.200
     0.798     0.779     0.200
     0.498     0.009     0.200
     0.699    -0.725     0.200
     0.699     0.615     0.200
     0.625     0.529     0.200
     0.744    -1.094     0.200
     0.771    -0.127     0.200
     0.528    -0.238     0.200
     0.565    -0.403     0.200
     0.676     0.860     0.200
     0.680    -0.383     0.200
     0.792    -0.709     0.200
     0.792    -0.068     0.200
     0.792     0.205     0.200
     0.726    -0.605     0.200
     0.888     0.017     0.200
     0.894     0.984     0.200
     0.710    -1.127     0.200
     0.813    -0.998     0.200
     0.500    -0.442     0.200
     0.500     0.708     0.200
     0.688    -0.807     0.200
     0.688     0.443     0.200
     0.799    -0.339     0.200
     0.799    -0.219     0.200
     0.951    -0.757     0.200
     0.796    -0.020     0.200
     0.738     0.376     0.200
     0.402     0.047     0.200
     0.402     0.907     0.200
     0.593    -1.651     0.200
     0.780    -0.933     0.200
     0.780    -0.292     0.200
     0.724     0.839     0.200
     0.784     0.361     0.200
     0.653     0.193     0.200
     0.774    -0.399     0.200
     0.588    -0.688     0.200
     0.588     0.503     0.200
     0.657    -1.003     0.200
     0.656    -1.005     0.200
     0.656    -1.197     0.200
     0.783     0.387     0.200
     0.783     0.488     0.200
     0.769     0.134     0.200
     0.768     0.554     0.200
     0.539    -0.895     0.200
     0.696    -1.190     0.200
     0.685    -0.002     0.200
     0.685    -0.430     0.200
     0.616    -1.465     0.200
     0.616    -0.555     0.200
     0.616    -0.245     0.200
     0.605    -1.347     0.200
     0.772    -0.879     0.200
     0.772     0.092     0.200
     0.623     0.046     0.200
     0.620    -0.526     0.200
     0.769    -0.286     0.200
     0.769     0.370     0.200
     0.600    -0.592     0.200
     0.600    -0.139     0.200
     0.621    -0.745     0.200
     0.621    -0.592     0.200
     0.772    -0.955     0.200
     0.772     0.358     0.200
     0.758    -0.392     0.200
     0.758     0.237     0.200
     0.648     0.440     0.200
     0.597    -0.746     0.200
     0.597    -0.340     0.200
     0.671    -0.857     0.200
     0.762    -0.315     0.200
     0.762    -0.745     0.200
     0.578    -1.158     0.200
     0.643    -1.467     0.200
     0.675    -0.892     0.200
     0.541     1.171     0.200
     0.462    -1.218     0.200
     0.461    -1.163     0.200
     0.461    -0.493     0.200
     0.639     0.496     0.200
     0.639     0.736     0.200
     0.362     0.026     0.200
     0.363     0.044     0.200
     0.464    -0.899     0.200
     0.464    -0.924     0.200
     0.464    -0.394     0.200
     0.956    -1.036     0.200
     0.565     0.816     0.200
     0.725    -1.312     0.200
     0.739    -0.857     0.200
     0.742    -0.666     0.200
     0.743    -0.644     0.200
     0.785    -1.069     0.200
     0.785    -0.717     0.200
     0.785     0.490     0.200
     0.726    -0.118     0.200
     0.759     0.572     0.200
     0.771    -1.580     0.200
     0.824    -0.811     0.200
     0.824     0.306     0.200
     0.824    -0.272     0.200
     0.472    -0.954     0.200
     0.658     0.961     0.200
     0.658     0.691     0.200
     0.379     0.296     0.200
     0.475    -0.739     0.200
     0.474    -0.806     0.200
     0.913    -0.287     0.200
     0.497    -1.445     0.200
     0.829     0.362     0.200
     0.958    -1.749     0.200
     0.415    -0.556     0.200
     0.415    -0.125     0.200
     0.415     0.395     0.200
     0.690     0.984     0.200
     0.690     0.883     0.200
     0.959    -0.697     0.200
     0.810     1.537     0.200
     0.376    -0.053     0.200
     0.376     0.129     0.200
     0.488    -1.259     0.200
     0.649     1.092     0.200
     0.722    -1.006     0.200
     0.722    -1.186     0.200
     0.762    -0.964     0.200
     0.696    -0.626     0.200
     0.725    -1.455     0.200
     0.612    -1.237     0.200
     0.612    -0.077     0.200
     0.589     0.144     0.200
     0.589     0.495     0.200
     0.620    -0.671     0.200
     0.617    -1.013     0.200
     0.617     0.567     0.200
     0.578     1.073     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.037
 1.00    0.037
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -0.553
 1.00   -0.553
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00   -0.0
 1.00   -0.0
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -0.3
 1.00   -0.3
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =   0.0 (solid red line)
     0.050     5.000   Pn = green x; average =  -0.6 (solid green line)
     0.050    -7.500   Sg = red circles; average =  -0.0 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -0.3 (dashed green line)
EOF
gmt end
