#!/bin/bash
gmt begin penasco2.16_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic penasco2.16'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.552
   136.000     1.637
   136.500     1.726
   137.000     1.817
   137.500     1.912
   138.000     2.010
   138.500     2.111
   139.000     2.217
   139.500     2.326
   140.000     2.438
   140.500     2.555
   141.000     2.677
   141.500     2.802
   142.000     2.932
   142.500     3.067
   143.000     3.207
   143.500     3.352
   144.000     3.503
   144.500     3.659
   145.000     3.822
   145.500     3.990
   146.000     4.165
   146.500     4.346
   147.000     4.535
   147.500     4.730
   148.000     4.933
   148.500     5.144
   149.000     5.364
   149.500     5.592
   150.000     5.830
   150.500     6.078
   151.000     6.337
   151.500     6.605
   152.000     6.884
   152.500     7.172
   153.000     7.472
   153.500     7.781
   154.000     8.101
   154.500     8.432
   155.000     8.774
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.687
   145.500     0.276
   146.000     1.303
   146.500     2.373
   147.000     3.477
   147.500     4.611
   148.000     5.772
   148.500     6.958
   149.000     8.168
   149.500     9.401
   150.000    10.655
   150.500    11.931
   151.000    13.228
   151.500    14.544
   152.000    15.879
   152.500    17.233
   153.000    18.604
   153.500    19.993
   154.000    21.400
   154.500    22.824
   155.000    24.266
   155.500    25.724
   156.000    27.200
   156.500    28.692
   157.000    30.201
   157.500    31.726
   158.000    33.268
   158.500    34.827
   159.000    36.402
   159.500    37.994
   160.000    39.601
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.690
   145.500     0.076
   146.000     0.770
   146.500     1.411
   147.000     2.010
   147.500     2.570
   148.000     3.095
   148.500     3.587
   149.000     4.053
   149.500     4.499
   150.000     4.929
   150.500     5.346
   151.000     5.753
   151.500     6.150
   152.000     6.539
   152.500     6.920
   153.000     7.296
   153.500     7.667
   154.000     8.036
   154.500     8.402
   155.000     8.767
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   144.624     1.063     0.200
   144.791     1.024     0.200
   144.665    -0.019     0.200
   144.665     0.352     0.200
   142.628    -0.026     0.200
   144.713    -0.170     0.200
   144.187     0.773     0.200
   144.855     0.488     0.200
   138.538    -5.920     0.200
   142.766    -0.115     0.200
   142.538    -0.339     0.200
   144.848     0.818     0.200
   144.902     0.301     0.200
   145.252     1.467     0.200
   144.356     1.524     0.200
   144.682     0.714     0.200
   145.093     1.197     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   145.117     0.429     0.200
   145.252     0.781     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   144.705     1.680     0.200
   144.777     4.423     0.200
   144.770     3.256     0.200
   144.210     2.025     0.200
   145.093     3.627     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
