#!/bin/bash
gmt begin penasco2.16_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P penasco2.16'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.708
    79.000     8.533
    80.000     7.442
    81.000     6.437
    82.000     5.519
    83.000     4.684
    84.000     3.933
    85.000     3.270
    86.000     2.692
    87.000     2.192
    88.000     1.797
    89.000     1.497
    90.000     1.239
    91.000     1.013
    92.000     0.811
    93.000     0.630
    94.000     0.464
    95.000     0.319
    96.000     0.199
    97.000     0.106
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    16.747     4.093     0.200
    38.744     2.980     0.200
    23.092     0.720     0.200
    30.908     0.932     0.200
    38.672     2.418     0.200
    14.518     5.573     0.200
    14.750     5.498     0.200
    14.780     5.065     0.200
    14.766     7.232     0.200
    14.941     5.324     0.200
    14.943     4.971     0.200
    14.945     6.435     0.200
    14.964     5.704     0.200
    15.045     5.421     0.200
    15.048     5.952     0.200
    15.064     5.522     0.200
    15.153     5.582     0.200
    15.489     4.391     0.200
    15.823     5.975     0.200
    15.956     4.676     0.200
    15.992     4.587     0.200
    16.065     3.594     0.200
    16.068     3.882     0.200
    16.137     4.268     0.200
    16.320     3.529     0.200
    16.348     6.810     0.200
    16.624     3.995     0.200
    16.887     4.845     0.200
    16.907     3.658     0.200
    16.993     3.549     0.200
    17.006     4.011     0.200
    17.215     3.691     0.200
    17.249     3.970     0.200
    17.264     2.802     0.200
    17.327     3.028     0.200
    17.330     2.999     0.200
    17.527     3.782     0.200
    17.587     2.573     0.200
    17.616     4.657     0.200
    17.846     2.757     0.200
    17.870     2.627     0.200
    17.935     3.249     0.200
    17.941     2.604     0.200
    18.052     2.483     0.200
    18.049     2.198     0.200
    18.068     2.895     0.200
    18.089     2.705     0.200
    18.163     2.855     0.200
    18.208     2.402     0.200
    18.298     3.501     0.200
    18.300     2.243     0.200
    18.387     1.212     0.200
    18.482     1.805     0.200
    18.547     0.892     0.200
    18.614     1.041     0.200
    18.718     0.850     0.200
    18.728     1.148     0.200
    18.732     0.696     0.200
    18.736     1.008     0.200
    18.797     1.214     0.200
    18.869     1.501     0.200
    18.898     2.010     0.200
    18.892     0.825     0.200
    18.948     1.831     0.200
    19.061     1.529     0.200
    19.138     1.601     0.200
    19.171     1.823     0.200
    19.189     1.846     0.200
    19.211     1.959     0.200
    19.270     1.537     0.200
    19.319     1.523     0.200
    19.332     1.347     0.200
    19.366     1.404     0.200
    19.379     1.773     0.200
    19.478     1.474     0.200
    19.649     1.472     0.200
    19.682     2.077     0.200
    19.683     1.915     0.200
    19.698     1.546     0.200
    19.744     1.619     0.200
    19.752     1.544     0.200
    19.785     2.098     0.200
    19.848     1.306     0.200
    19.900     2.270     0.200
    19.861     1.608     0.200
    20.062     1.885     0.200
    20.125     1.609     0.200
    20.177     1.270     0.200
    20.186     1.267     0.200
    20.202     1.952     0.200
    20.230     1.674     0.200
    20.242     1.385     0.200
    20.266     1.695     0.200
    20.298     1.734     0.200
    20.401     1.568     0.200
    20.388     0.557     0.200
    20.529     1.120     0.200
    20.600     1.409     0.200
    20.661     0.897     0.200
    20.704     0.720     0.200
    20.726     1.302     0.200
    20.718     1.654     0.200
    20.805     1.706     0.200
    20.914     1.265     0.200
    20.929     1.201     0.200
    20.966     1.483     0.200
    20.959     1.547     0.200
    21.115     1.153     0.200
    21.131     2.393     0.200
    21.148     1.262     0.200
    21.148     0.592     0.200
    21.196     0.662     0.200
    21.330     0.726     0.200
    21.336     1.436     0.200
    21.351     0.897     0.200
    21.436     1.237     0.200
    21.432     1.627     0.200
    21.506     1.200     0.200
    21.570     1.747     0.200
    21.665     2.466     0.200
    21.741     1.009     0.200
    21.745     1.234     0.200
    21.751     1.310     0.200
    21.760     0.366     0.200
    21.765     1.683     0.200
    21.793     1.041     0.200
    21.902     1.161     0.200
    22.109     1.907     0.200
    22.149     0.957     0.200
    22.157     1.134     0.200
    22.227     0.626     0.200
    22.313     0.800     0.200
    22.416     0.549     0.200
    22.543     0.341     0.200
    22.597     0.766     0.200
    22.654     0.961     0.200
    22.725     1.336     0.200
    22.781     1.785     0.200
    22.863     0.639     0.200
    22.886     1.113     0.200
    22.908     2.285     0.200
    23.002     0.781     0.200
    23.124     0.578     0.200
    23.124     1.195     0.200
    23.132     2.718     0.200
    23.178    -0.161     0.200
    23.314     0.503     0.200
    23.362     1.556     0.200
    23.704     0.800     0.200
    24.342     2.084     0.200
    24.398     0.627     0.200
    24.398     1.568     0.200
    24.476     2.280     0.200
    24.540     1.597     0.200
    24.507     1.998     0.200
    24.559     0.742     0.200
    25.068     1.258     0.200
    25.068     1.511     0.200
    25.358     1.746     0.200
    25.510     0.811     0.200
    26.133     1.650     0.200
    26.133     2.426     0.200
    26.321     2.027     0.200
    26.321     1.626     0.200
    26.310    -0.347     0.200
    26.310     2.641     0.200
    26.389     2.422     0.200
    27.406     2.251     0.200
    28.100     0.885     0.200
    28.100     1.680     0.200
    28.151     3.684     0.200
    28.947     3.106     0.200
    29.399     6.096     0.200
    29.451     2.907     0.200
    30.554     2.621     0.200
    30.554     3.041     0.200
    31.287     1.156     0.200
    31.287     2.656     0.200
    32.606     2.276     0.200
    33.501     1.292     0.200
    34.406     2.653     0.200
    34.833     1.581     0.200
    35.281     2.988     0.200
    36.677     4.518     0.200
    37.047     4.448     0.200
    37.181     4.534     0.200
    37.735     3.691     0.200
    37.872     1.252     0.200
    37.867     3.267     0.200
    38.231     4.624     0.200
    38.341     2.777     0.200
    38.440     2.782     0.200
    38.440     3.282     0.200
    38.500     2.864     0.200
    38.727     3.775     0.200
    38.754     3.846     0.200
    38.771     1.684     0.200
    38.953     1.876     0.200
    39.042     2.694     0.200
    39.116     2.716     0.200
    39.437     4.013     0.200
    39.656     3.225     0.200
    39.905     2.667     0.200
    40.013     3.518     0.200
    40.095     1.663     0.200
    40.095     3.663     0.200
    40.161     3.812     0.200
    40.200     3.309     0.200
    40.400     2.233     0.200
    40.431     1.365     0.200
    40.431     1.925     0.200
    40.607     2.099     0.200
    40.634     2.996     0.200
    40.669     2.872     0.200
    40.689     2.457     0.200
    40.802     2.704     0.200
    40.802     3.015     0.200
    41.045     2.383     0.200
    41.233     4.056     0.200
    41.313     1.898     0.200
    41.336     2.093     0.200
    41.422     1.587     0.200
    41.436     2.688     0.200
    41.836     2.516     0.200
    41.844     1.225     0.200
    41.844     1.799     0.200
    42.287     3.696     0.200
    42.528     1.469     0.200
    43.099     4.130     0.200
    43.419     1.629     0.200
    43.883     1.422     0.200
    44.260     5.657     0.200
    44.598     0.052     0.200
    44.946     2.596     0.200
    44.973     3.842     0.200
    45.004    -0.284     0.200
    45.004     1.896     0.200
    45.081     3.449     0.200
    45.081     1.246     0.200
    45.439     1.590     0.200
    50.361     3.808     0.200
    52.552     1.849     0.200
    52.552     0.169     0.200
    57.492     1.038     0.200
    57.492     1.676     0.200
    58.686     1.170     0.200
    59.895     1.951     0.200
    59.895     2.898     0.200
    62.396    -0.455     0.200
    62.391     0.944     0.200
    65.349     2.245     0.200
    65.624     2.217     0.200
    65.624     2.641     0.200
    67.177     2.471     0.200
    75.113     1.691     0.200
    75.125     2.220     0.200
    76.403     1.212     0.200
    76.621     2.151     0.200
    78.025     2.156     0.200
    78.025     3.107     0.200
    78.151     2.759     0.200
    79.122     2.662     0.200
    79.136     1.382     0.200
    79.136     0.558     0.200
    80.494     0.219     0.200
    81.820     3.463     0.200
    82.111     2.832     0.200
    82.854     2.857     0.200
    83.101     3.277     0.200
    83.134     2.406     0.200
    83.215     3.185     0.200
    83.275     3.678     0.200
    83.686     3.563     0.200
    83.742     0.179     0.200
    83.732    -0.973     0.200
    83.970     3.812     0.200
    84.025     4.530     0.200
    84.051     2.596     0.200
    84.717     2.547     0.200
    85.191     2.016     0.200
    85.216     2.216     0.200
    85.280     2.171     0.200
    85.281     2.391     0.200
    85.281     1.690     0.200
    88.806     4.376     0.200
    88.846     0.282     0.200
    88.880     1.734     0.200
    91.359     0.368     0.200
    91.682     2.968     0.200
    92.238     3.995     0.200
    92.238     2.576     0.200
    92.418     2.265     0.200
    93.462     3.051     0.200
    93.796     2.413     0.200
    94.196     2.277     0.200
    94.196     2.956     0.200
    94.460     3.633     0.200
    94.474     3.221     0.200
    94.897     1.981     0.200
    94.897     2.186     0.200
    94.962     1.262     0.200
    95.885    -1.149     0.200
    96.147    -0.040     0.200
    96.499    -0.443     0.200
    14.814     7.621     0.200
    15.137     5.409     0.200
    15.127     7.303     0.200
    15.268     6.911     0.200
    15.295     6.381     0.200
    15.515     4.276     0.200
    15.461     6.987     0.200
    15.673     4.809     0.200
    15.922     5.080     0.200
    16.161     3.915     0.200
    16.175     4.188     0.200
    16.310     3.857     0.200
    16.831     3.303     0.200
    17.654     3.574     0.200
    17.762     2.958     0.200
    17.762     3.282     0.200
    18.055     4.363     0.200
    18.161     2.791     0.200
    18.161     3.321     0.200
    18.410     0.011     0.200
    18.432    -0.631     0.200
    18.451     0.923     0.200
    18.513     2.227     0.200
    18.492     0.746     0.200
    18.564     1.277     0.200
    18.628     0.475     0.200
    18.661     1.413     0.200
    18.661    -0.018     0.200
    18.690     1.549     0.200
    18.682    -0.217     0.200
    18.707     1.534     0.200
    18.759     0.787     0.200
    18.776     0.060     0.200
    18.838     1.668     0.200
    18.847    -0.106     0.200
    18.862     1.217     0.200
    18.915     1.692     0.200
    18.929     2.127     0.200
    18.929     1.201     0.200
    18.942     2.218     0.200
    18.970     2.032     0.200
    18.970     1.481     0.200
    19.054     1.834     0.200
    19.088     1.366     0.200
    19.076     2.473     0.200
    19.127     1.317     0.200
    19.161     1.293     0.200
    19.212     0.680     0.200
    19.244     2.701     0.200
    19.228     0.549     0.200
    19.257     1.894     0.200
    19.308     1.886     0.200
    19.378     0.799     0.200
    19.419     0.647     0.200
    19.440     1.308     0.200
    19.472     0.264     0.200
    19.493     0.871     0.200
    19.493    -0.634     0.200
    19.560    -3.179     0.200
    19.599     1.061     0.200
    19.632     1.059     0.200
    19.656     2.414     0.200
    19.740    -0.351     0.200
    19.775    -0.168     0.200
    19.771    -1.378     0.200
    19.821     0.369     0.200
    19.847     1.906     0.200
    19.869    -0.428     0.200
    19.892     1.656     0.200
    19.928    -0.327     0.200
    19.967     1.791     0.200
    20.064    -2.115     0.200
    20.064     3.217     0.200
    20.100     1.513     0.200
    20.093    -0.576     0.200
    20.133     1.998     0.200
    20.133     1.662     0.200
    20.141     2.971     0.200
    20.131    -1.415     0.200
    20.193     2.558     0.200
    20.237     1.962     0.200
    20.298     1.372     0.200
    20.338     1.440     0.200
    20.376     0.797     0.200
    20.407     2.803     0.200
    20.388     1.285     0.200
    20.409     1.062     0.200
    20.455     1.936     0.200
    20.436     1.478     0.200
    20.492    -0.111     0.200
    20.574     2.030     0.200
    20.553     2.165     0.200
    20.614     0.373     0.200
    20.664    -0.404     0.200
    20.656     1.489     0.200
    20.806     2.272     0.200
    20.735     0.935     0.200
    20.742     0.986     0.200
    20.752     2.515     0.200
    20.785     0.315     0.200
    20.899    -1.974     0.200
    20.889     2.961     0.200
    20.921    -0.975     0.200
    21.013     0.895     0.200
    21.006     1.992     0.200
    21.010     1.201     0.200
    21.028     3.570     0.200
    21.038     2.685     0.200
    21.033     1.435     0.200
    21.033     2.142     0.200
    21.041     1.804     0.200
    21.085     1.806     0.200
    21.083    -0.627     0.200
    21.171     2.040     0.200
    21.191     0.487     0.200
    21.205     0.791     0.200
    21.234     1.701     0.200
    21.234     0.551     0.200
    21.251     3.041     0.200
    21.250     0.756     0.200
    21.266     0.029     0.200
    21.288    -0.684     0.200
    21.340     3.723     0.200
    21.379     2.665     0.200
    21.424     3.199     0.200
    21.460     1.282     0.200
    21.510     3.406     0.200
    21.504     1.218     0.200
    21.510     2.375     0.200
    21.533     0.520     0.200
    21.599     2.164     0.200
    21.583     1.210     0.200
    21.616     1.809     0.200
    21.631     3.620     0.200
    21.682     1.295     0.200
    21.704     3.089     0.200
    21.698     2.208     0.200
    21.688     3.617     0.200
    21.715     1.749     0.200
    21.751     3.378     0.200
    21.743     2.391     0.200
    21.750     3.188     0.200
    21.790     3.164     0.200
    21.832     2.323     0.200
    21.835     1.696     0.200
    21.860     1.549     0.200
    21.858     1.771     0.200
    21.888     2.890     0.200
    21.955     2.339     0.200
    22.001     2.872     0.200
    22.053     2.297     0.200
    22.062     2.372     0.200
    22.010     2.060     0.200
    22.064     2.840     0.200
    22.116     0.917     0.200
    22.105     1.175     0.200
    22.110     1.452     0.200
    22.158     2.018     0.200
    22.160     1.881     0.200
    22.202     0.960     0.200
    22.214     1.135     0.200
    22.276     0.520     0.200
    22.301     0.618     0.200
    22.301     2.056     0.200
    22.299    -0.997     0.200
    22.313     0.383     0.200
    22.349     1.076     0.200
    22.400     1.511     0.200
    22.411     2.317     0.200
    22.403     0.712     0.200
    22.439     2.913     0.200
    22.476     2.831     0.200
    22.465     1.781     0.200
    22.465     1.999     0.200
    22.479     2.218     0.200
    22.511     2.564     0.200
    22.515     2.478     0.200
    22.515     0.279     0.200
    22.512     1.715     0.200
    22.561     0.989     0.200
    22.552     3.356     0.200
    22.543     1.019     0.200
    22.535    -2.413     0.200
    22.540     1.766     0.200
    22.584     2.564     0.200
    22.676     3.879     0.200
    22.688     1.425     0.200
    22.695     1.488     0.200
    22.710     3.025     0.200
    22.781     2.257     0.200
    22.781     1.371     0.200
    22.864     1.744     0.200
    22.864     2.231     0.200
    22.917     1.967     0.200
    22.935     1.643     0.200
    23.006     1.574     0.200
    23.003     3.860     0.200
    22.980     1.162     0.200
    23.012     0.859     0.200
    23.012     0.551     0.200
    23.054     1.795     0.200
    23.057     1.327     0.200
    23.076    -0.229     0.200
    23.064     0.768     0.200
    23.109     1.613     0.200
    23.151     1.458     0.200
    23.152     0.897     0.200
    23.201     2.780     0.200
    23.214     1.228     0.200
    23.248     2.552     0.200
    23.240     0.563     0.200
    23.393     3.227     0.200
    23.400     2.401     0.200
    23.432    -0.247     0.200
    23.478     2.017     0.200
    23.465     1.725     0.200
    23.494     0.255     0.200
    23.543     2.554     0.200
    23.539     2.770     0.200
    23.543     1.368     0.200
    23.575     1.069     0.200
    23.636     2.822     0.200
    23.732     1.945     0.200
    23.822     0.249     0.200
    23.822     0.667     0.200
    23.814     0.524     0.200
    23.851     2.547     0.200
    23.928    -0.559     0.200
    23.929     2.254     0.200
    24.001     1.780     0.200
    23.983     0.950     0.200
    24.015     0.967     0.200
    24.014     1.333     0.200
    24.075     1.074     0.200
    24.134     1.487     0.200
    24.250     0.824     0.200
    24.327     2.013     0.200
    24.355     4.461     0.200
    24.421     3.286     0.200
    24.539     4.130     0.200
    25.555     1.710     0.200
    25.710     2.680     0.200
    25.710     0.973     0.200
    31.862     1.146     0.200
    31.930     5.892     0.200
    38.120     3.793     0.200
    39.398     2.068     0.200
    39.398     5.236     0.200
    39.800     2.156     0.200
    39.800     2.519     0.200
    39.800     3.667     0.200
    40.352     7.212     0.200
    40.583     1.799     0.200
    40.725     3.602     0.200
    42.458     3.840     0.200
    42.793     1.836     0.200
    45.577     0.041     0.200
    45.788     1.792     0.200
    56.731     2.290     0.200
    56.731     1.169     0.200
    65.183     2.514     0.200
    65.184     2.514     0.200
    82.684     4.573     0.200
    84.550     4.849     0.200
    88.143     2.500     0.200
    92.716     3.377     0.200
    93.882     5.600     0.200
    93.882     5.600     0.200
    14.051     6.683     0.200
    14.264     6.990     0.200
    14.317     6.050     0.200
    14.799     7.165     0.200
    14.803     9.537     0.200
    15.650     5.084     0.200
    15.851     9.191     0.200
    16.597     4.114     0.200
    17.056     5.522     0.200
    17.147     3.039     0.200
    17.496     5.739     0.200
    17.597     2.680     0.200
    17.720     3.143     0.200
    17.704     4.008     0.200
    17.827     2.544     0.200
    18.049     2.872     0.200
    18.165     2.338     0.200
    18.492    -0.925     0.200
    18.477     0.183     0.200
    18.486     0.976     0.200
    18.502    -0.976     0.200
    18.523    -0.156     0.200
    18.535    -0.734     0.200
    18.578     1.202     0.200
    18.699     0.615     0.200
    18.750     0.553     0.200
    18.725     0.615     0.200
    18.803     0.070     0.200
    18.869    -1.159     0.200
    18.882     0.008     0.200
    18.884     0.478     0.200
    18.884    -0.559     0.200
    18.962    -0.347     0.200
    18.971    -0.558     0.200
    18.960    -0.394     0.200
    18.970     0.133     0.200
    19.045     0.221     0.200
    19.023     1.733     0.200
    19.089     1.057     0.200
    19.166     1.263     0.200
    19.188     1.402     0.200
    19.204     0.735     0.200
    19.237     0.784     0.200
    19.258     1.001     0.200
    19.273     0.413     0.200
    19.292     1.410     0.200
    19.327     1.968     0.200
    19.353     1.767     0.200
    19.303     2.398     0.200
    19.405     1.766     0.200
    19.364     2.296     0.200
    19.456     0.441     0.200
    19.469     0.591     0.200
    19.480     0.481     0.200
    19.526     0.405     0.200
    19.588     1.188     0.200
    19.643     1.726     0.200
    19.666     1.367     0.200
    19.690     1.033     0.200
    19.705     0.845     0.200
    19.763    -0.398     0.200
    19.813     1.088     0.200
    19.846    -0.007     0.200
    19.894     1.593     0.200
    19.911     0.914     0.200
    19.933     2.290     0.200
    19.944     1.575     0.200
    19.979     1.992     0.200
    20.046    -0.006     0.200
    20.047     1.965     0.200
    20.047     0.707     0.200
    20.081     0.395     0.200
    20.129     1.421     0.200
    20.151     1.362     0.200
    20.155     0.387     0.200
    20.140     0.968     0.200
    20.146     1.570     0.200
    20.168     1.413     0.200
    20.184     2.291     0.200
    20.184     0.674     0.200
    20.267     1.049     0.200
    20.276     1.032     0.200
    20.265    -0.589     0.200
    20.285     1.407     0.200
    20.328     0.223     0.200
    20.339     1.587     0.200
    20.361    -0.013     0.200
    20.426     2.022     0.200
    20.423     1.677     0.200
    20.449     0.770     0.200
    20.443     1.673     0.200
    20.466    -0.386     0.200
    20.467     1.918     0.200
    20.467     0.832     0.200
    20.541    -0.765     0.200
    20.572     1.364     0.200
    20.569     1.208     0.200
    20.615    -0.192     0.200
    20.617     1.740     0.200
    20.627     1.038     0.200
    20.715     0.881     0.200
    20.773     1.165     0.200
    20.777     0.767     0.200
    20.774     2.350     0.200
    20.793     1.360     0.200
    20.784     1.783     0.200
    20.827     2.082     0.200
    20.913     1.823     0.200
    20.914     1.411     0.200
    20.868     2.450     0.200
    20.936     1.688     0.200
    20.954     1.389     0.200
    21.018     0.797     0.200
    21.057     1.056     0.200
    21.057     0.368     0.200
    21.050     1.884     0.200
    21.060     0.976     0.200
    21.065     0.568     0.200
    21.085     5.184     0.200
    21.081     1.116     0.200
    21.080     0.902     0.200
    21.084     2.021     0.200
    21.084     1.256     0.200
    21.156     0.416     0.200
    21.226     0.613     0.200
    21.237     0.000     0.200
    21.267     0.193     0.200
    21.272     2.259     0.200
    21.272     1.704     0.200
    21.275     1.775     0.200
    21.275     2.533     0.200
    21.292     1.349     0.200
    21.306     2.339     0.200
    21.302     1.165     0.200
    21.299     2.023     0.200
    21.399     0.962     0.200
    21.387     3.255     0.200
    21.482     0.823     0.200
    21.538     0.373     0.200
    21.549     1.833     0.200
    21.549     1.004     0.200
    21.570     1.836     0.200
    21.616     1.489     0.200
    21.650     2.247     0.200
    21.656     2.035     0.200
    21.705     0.994     0.200
    21.682     1.463     0.200
    21.740     0.363     0.200
    21.741     1.759     0.200
    21.753     0.935     0.200
    21.773     0.376     0.200
    21.805     0.789     0.200
    21.799     0.896     0.200
    21.870     1.657     0.200
    21.878     1.652     0.200
    21.896     1.227     0.200
    21.901     0.874     0.200
    21.950     2.091     0.200
    21.978     2.914     0.200
    21.969     5.511     0.200
    21.969     1.159     0.200
    21.970    -0.599     0.200
    22.045     0.528     0.200
    22.074     1.348     0.200
    22.130     2.090     0.200
    22.105     2.007     0.200
    22.105     1.475     0.200
    22.115     0.661     0.200
    22.138     1.564     0.200
    22.120     0.873     0.200
    22.165     1.400     0.200
    22.186     2.515     0.200
    22.224     1.617     0.200
    22.243    -0.807     0.200
    22.242     1.633     0.200
    22.321     1.611     0.200
    22.319     0.888     0.200
    22.337     0.972     0.200
    22.349     5.435     0.200
    22.349     0.779     0.200
    22.341     2.359     0.200
    22.341     0.922     0.200
    22.394     0.052     0.200
    22.428     0.207     0.200
    22.450     1.563     0.200
    22.493     3.061     0.200
    22.494     1.578     0.200
    22.491     1.294     0.200
    22.517     0.091     0.200
    22.560     0.370     0.200
    22.560     0.347     0.200
    22.553     0.670     0.200
    22.561     1.515     0.200
    22.561     0.695     0.200
    22.599     0.657     0.200
    22.587     2.029     0.200
    22.635     1.441     0.200
    22.710     2.399     0.200
    22.730     2.501     0.200
    22.726     0.438     0.200
    22.758     0.205     0.200
    22.814     0.379     0.200
    22.820     0.639     0.200
    22.886     0.945     0.200
    22.874     0.621     0.200
    22.911     1.350     0.200
    22.971     1.746     0.200
    22.964    -0.126     0.200
    22.998     1.183     0.200
    23.004     2.755     0.200
    23.004     1.927     0.200
    23.032     2.096     0.200
    23.032     1.346     0.200
    23.071     1.178     0.200
    23.055     0.831     0.200
    23.096     0.195     0.200
    23.109     0.512     0.200
    23.131     1.533     0.200
    23.182     2.650     0.200
    23.182     1.298     0.200
    23.188     2.521     0.200
    23.188     1.193     0.200
    23.219     0.664     0.200
    23.254     1.227     0.200
    23.267     0.746     0.200
    23.250     1.540     0.200
    23.292     1.872     0.200
    23.314     1.714     0.200
    23.314     1.565     0.200
    23.359     0.601     0.200
    23.393     2.159     0.200
    23.420     2.129     0.200
    23.453     2.336     0.200
    23.478     0.153     0.200
    23.516     1.968     0.200
    23.516     0.499     0.200
    23.506     0.611     0.200
    23.531     2.559     0.200
    23.572     1.020     0.200
    23.600     1.214     0.200
    23.612     1.438     0.200
    23.606     1.415     0.200
    23.606     0.407     0.200
    23.683     1.343     0.200
    23.677     1.454     0.200
    23.696     3.418     0.200
    23.686     1.505     0.200
    23.686     0.747     0.200
    23.710     7.189     0.200
    23.710     0.541     0.200
    23.720     0.806     0.200
    23.763     1.517     0.200
    23.768     2.555     0.200
    23.768     1.250     0.200
    23.847     1.921     0.200
    23.867     0.989     0.200
    23.859     2.608     0.200
    23.859     0.702     0.200
    23.866     0.253     0.200
    23.890     1.679     0.200
    23.882    -0.434     0.200
    23.882     0.113     0.200
    23.929     2.331     0.200
    23.929     1.316     0.200
    23.955     3.075     0.200
    24.014     1.770     0.200
    24.016     2.443     0.200
    24.026     3.314     0.200
    23.970     1.862     0.200
    23.970     2.456     0.200
    24.049     1.732     0.200
    24.053     0.411     0.200
    24.080     1.768     0.200
    24.072     0.223     0.200
    24.066     0.974     0.200
    24.107     1.517     0.200
    24.157     2.086     0.200
    24.181     1.115     0.200
    24.286     1.739     0.200
    24.297     1.375     0.200
    24.359     2.256     0.200
    24.373     2.307     0.200
    24.375     2.664     0.200
    24.415     1.939     0.200
    24.445     2.556     0.200
    24.445     1.142     0.200
    24.458     1.903     0.200
    24.427     1.678     0.200
    24.461     3.055     0.200
    24.461     0.969     0.200
    24.508     5.407     0.200
    24.473     1.963     0.200
    24.534     2.135     0.200
    24.554     2.089     0.200
    24.579     1.320     0.200
    24.589     9.139     0.200
    24.589     2.514     0.200
    24.638     0.335     0.200
    24.724     2.334     0.200
    24.722     8.279     0.200
    24.722     2.161     0.200
    24.749     1.035     0.200
    24.771     1.703     0.200
    24.813     2.397     0.200
    24.813     0.967     0.200
    24.849     3.070     0.200
    24.849     2.844     0.200
    24.875     2.633     0.200
    24.875     2.890     0.200
    24.897     1.507     0.200
    24.911     1.439     0.200
    24.918     1.162     0.200
    24.923     0.967     0.200
    24.963     2.509     0.200
    24.963     1.134     0.200
    24.993     1.899     0.200
    24.987     1.444     0.200
    25.118     3.664     0.200
    25.192     1.446     0.200
    25.194     1.512     0.200
    25.233     2.416     0.200
    25.245     1.884     0.200
    25.276     3.660     0.200
    25.276     1.285     0.200
    25.296     1.732     0.200
    25.412     2.668     0.200
    25.471     2.318     0.200
    25.471     0.701     0.200
    25.471     3.087     0.200
    25.501     2.969     0.200
    25.552     1.106     0.200
    25.585     2.463     0.200
    25.590     2.461     0.200
    25.576     1.160     0.200
    25.609     1.285     0.200
    25.620     0.658     0.200
    25.649     1.325     0.200
    25.692     2.263     0.200
    25.710     2.274     0.200
    25.696     1.979     0.200
    25.712     2.542     0.200
    25.737     3.779     0.200
    25.737     4.373     0.200
    25.827     0.510     0.200
    25.870     2.266     0.200
    25.891     4.011     0.200
    25.891     2.261     0.200
    25.897     1.679     0.200
    25.893     1.523     0.200
    25.909     1.304     0.200
    25.924     0.371     0.200
    25.973     2.849     0.200
    25.980     2.503     0.200
    25.980     2.268     0.200
    26.043     0.505     0.200
    26.068     1.129     0.200
    26.109     0.476     0.200
    26.134    -0.668     0.200
    26.181     1.308     0.200
    26.184     2.282     0.200
    26.221     0.712     0.200
    26.219     1.666     0.200
    26.253     1.549     0.200
    26.405     3.145     0.200
    26.420     1.314     0.200
    26.426     0.316     0.200
    26.459     1.142     0.200
    26.471     0.096     0.200
    26.510     1.107     0.200
    26.560     2.440     0.200
    26.580     0.727     0.200
    26.615     1.272     0.200
    26.720    -0.275     0.200
    26.862     1.284     0.200
    26.871     0.693     0.200
    26.902     2.568     0.200
    26.906     3.105     0.200
    26.916     1.536     0.200
    26.916     0.974     0.200
    27.102     0.877     0.200
    27.122     1.910     0.200
    27.303     0.867     0.200
    27.697     0.978     0.200
    27.718     1.255     0.200
    29.290     0.679     0.200
    29.508     6.694     0.200
    29.555     3.969     0.200
    29.627     7.860     0.200
    29.953     3.097     0.200
    29.953     2.832     0.200
    30.257     2.803     0.200
    30.818     4.182     0.200
    30.818     0.830     0.200
    31.928     1.001     0.200
    32.448     2.154     0.200
    32.452     2.163     0.200
    32.717     2.386     0.200
    33.143     3.077     0.200
    33.866     2.143     0.200
    34.312     4.366     0.200
    34.603     6.842     0.200
    35.107     7.307     0.200
    37.143     2.963     0.200
    37.326     4.095     0.200
    37.962     2.924     0.200
    38.230     3.336     0.200
    38.414     3.252     0.200
    38.515     3.103     0.200
    38.581     2.796     0.200
    39.395     5.245     0.200
    39.462     1.643     0.200
    39.462     1.987     0.200
    39.608     3.129     0.200
    39.733     3.009     0.200
    39.844     2.982     0.200
    39.860     1.595     0.200
    39.860     2.353     0.200
    39.860     2.775     0.200
    40.067     1.953     0.200
    40.234     3.694     0.200
    40.508     3.256     0.200
    40.644     3.520     0.200
    40.771     2.110     0.200
    40.784     2.223     0.200
    40.914     2.364     0.200
    41.211     0.108     0.200
    42.518     3.029     0.200
    42.852     1.315     0.200
    43.292     3.423     0.200
    43.292     2.040     0.200
    45.223     3.396     0.200
    45.248     3.601     0.200
    45.320     2.362     0.200
    45.771     2.780     0.200
    45.771     2.046     0.200
    46.999     2.462     0.200
    50.680     2.761     0.200
    51.867     1.085     0.200
    56.795     1.248     0.200
    56.795     1.107     0.200
    59.971     1.091     0.200
    59.971     1.943     0.200
    62.582     0.406     0.200
    65.230     1.930     0.200
    66.791     3.181     0.200
    66.706     1.779     0.200
    67.655     1.235     0.200
    68.789     1.897     0.200
    75.921     0.925     0.200
    76.521    -0.819     0.200
    78.328     2.317     0.200
    78.328     2.442     0.200
    78.445     1.454     0.200
    79.136     0.723     0.200
    79.953     1.573     0.200
    80.764     1.311     0.200
    81.333     2.484     0.200
    81.387     1.571     0.200
    81.387     2.399     0.200
    81.545     2.007     0.200
    81.525     3.762     0.200
    81.579     4.283     0.200
    81.791     4.462     0.200
    81.921     2.406     0.200
    81.921     3.976     0.200
    82.210     2.462     0.200
    82.271     3.037     0.200
    82.710     4.952     0.200
    82.734     3.521     0.200
    82.748     1.277     0.200
    82.884     2.733     0.200
    83.014     1.249     0.200
    83.189    -0.337     0.200
    83.364     1.911     0.200
    84.059     2.224     0.200
    84.322     1.933     0.200
    84.322     1.762     0.200
    84.599     2.210     0.200
    84.623     2.084     0.200
    84.981     4.175     0.200
    84.981     2.636     0.200
    84.980     1.866     0.200
    84.981     5.314     0.200
    86.075     1.186     0.200
    86.634     1.333     0.200
    86.799     2.287     0.200
    87.244     3.064     0.200
    87.782     2.389     0.200
    87.848     1.809     0.200
    87.969     1.309     0.200
    88.046     1.201     0.200
    88.094     1.692     0.200
    88.148     1.658     0.200
    88.149     3.200     0.200
    88.177     0.896     0.200
    88.183     1.421     0.200
    89.147     1.273     0.200
    89.824     0.971     0.200
    90.109     1.524     0.200
    90.282     1.156     0.200
    90.681     1.154     0.200
    90.982     1.358     0.200
    91.438     1.643     0.200
    92.532     2.980     0.200
    92.779     0.747     0.200
    92.904     1.863     0.200
    93.650     1.130     0.200
    93.664     3.563     0.200
    93.926     2.648     0.200
    93.939     3.158     0.200
    94.264     1.127     0.200
    94.505     3.098     0.200
    95.185     0.285     0.200
    95.446     0.894     0.200
    95.799     0.390     0.200
    96.636     2.086     0.200
    96.665     2.353     0.200
    97.383     1.300     0.200
    98.301     1.794     0.200
    98.301     1.372     0.200
    98.403     1.336     0.200
    14.114     5.884     0.200
    14.148     5.188     0.200
    14.211     6.208     0.200
    14.356     5.195     0.200
    14.466     5.452     0.200
    14.584     4.933     0.200
    14.589     5.101     0.200
    14.983     5.274     0.200
    15.667     3.476     0.200
    15.699     5.010     0.200
    16.169     3.907     0.200
    16.433     3.483     0.200
    16.437     3.203     0.200
    16.673     5.898     0.200
    16.784     2.520     0.200
    16.859     2.467     0.200
    17.086     3.242     0.200
    17.222     5.469     0.200
    17.310     3.895     0.200
    17.624     1.933     0.200
    17.765     3.389     0.200
    18.027     2.627     0.200
    17.972     3.029     0.200
    18.283     3.525     0.200
    18.646     0.968     0.200
    18.939     0.046     0.200
    19.225     1.230     0.200
    19.311     0.216     0.200
    19.439     2.289     0.200
    19.584     1.399     0.200
    19.618     2.318     0.200
    19.962     1.402     0.200
    20.033     2.453     0.200
    20.198     1.799     0.200
    20.327     1.566     0.200
    20.684     1.769     0.200
    21.034     1.583     0.200
    21.118     2.045     0.200
    21.281     2.162     0.200
    21.392     1.960     0.200
    21.426     3.330     0.200
    21.733     1.082     0.200
    21.770    -0.924     0.200
    21.921     2.902     0.200
    22.063     2.055     0.200
    22.236     0.297     0.200
    22.247     1.606     0.200
    22.634     2.911     0.200
    22.671     0.541     0.200
    22.768     0.409     0.200
    22.889     0.021     0.200
    22.989     0.587     0.200
    23.131     1.037     0.200
    23.328     0.598     0.200
    23.404    -0.339     0.200
    23.638     1.098     0.200
    23.682     1.430     0.200
    23.776     1.306     0.200
    23.810     0.873     0.200
    23.802     1.806     0.200
    23.835     1.751     0.200
    23.883     1.410     0.200
    23.951     1.693     0.200
    24.048     1.286     0.200
    24.045     2.106     0.200
    24.059     1.437     0.200
    24.046     1.519     0.200
    24.098     0.790     0.200
    24.087     1.896     0.200
    24.140     2.165     0.200
    24.140     1.165     0.200
    24.170     0.857     0.200
    24.186     0.600     0.200
    24.318     0.269     0.200
    24.323     1.203     0.200
    24.590     1.335     0.200
    24.593     1.901     0.200
    24.634     1.280     0.200
    24.672     1.652     0.200
    24.941     2.043     0.200
    24.978     2.500     0.200
    25.051     2.001     0.200
    25.079     1.994     0.200
    25.075     1.389     0.200
    25.122     2.244     0.200
    25.222     1.574     0.200
    25.252     2.573     0.200
    25.593     0.827     0.200
    25.705     0.372     0.200
    25.721     0.671     0.200
    25.777     1.278     0.200
    25.841     1.480     0.200
    25.872     2.317     0.200
    25.872     1.754     0.200
    26.027     0.804     0.200
    26.057     1.309     0.200
    26.098     1.375     0.200
    26.114     1.342     0.200
    26.120     0.998     0.200
    26.340     1.307     0.200
    26.380     1.140     0.200
    26.480     0.943     0.200
    26.548    -0.249     0.200
    26.535     1.046     0.200
    26.513     3.740     0.200
    26.583     1.818     0.200
    26.615    -1.162     0.200
    26.646    -0.123     0.200
    26.879     1.685     0.200
    27.025    -0.254     0.200
    27.020     0.814     0.200
    27.079     0.624     0.200
    27.151     1.818     0.200
    27.292     1.985     0.200
    27.451     1.608     0.200
    27.501     1.874     0.200
    27.563     1.591     0.200
    27.849     2.424     0.200
    27.913     0.527     0.200
    28.556     1.710     0.200
    28.567     1.200     0.200
    28.665     1.592     0.200
    28.794     1.168     0.200
    28.990     1.457     0.200
    29.033     0.900     0.200
    29.361     1.858     0.200
    30.134     3.291     0.200
    30.417     0.494     0.200
    30.916     1.837     0.200
    30.916     1.657     0.200
    32.137     1.965     0.200
    32.815     0.891     0.200
    33.031    -1.676     0.200
    33.320     2.357     0.200
    34.209     2.766     0.200
    34.527     1.120     0.200
    36.399     3.733     0.200
    36.710     2.643     0.200
    37.231     1.956     0.200
    37.321     2.497     0.200
    38.220     4.411     0.200
    38.358     2.495     0.200
    38.373     3.478     0.200
    38.573     2.352     0.200
    38.573     2.176     0.200
    38.669     2.842     0.200
    38.739     3.379     0.200
    39.654     2.898     0.200
    39.654     2.070     0.200
    39.772     3.208     0.200
    39.801     2.773     0.200
    40.009     2.916     0.200
    40.030     2.910     0.200
    40.030     3.269     0.200
    40.030     2.910     0.200
    40.143     2.367     0.200
    40.210     3.734     0.200
    40.236     1.946     0.200
    40.304     2.911     0.200
    40.403     2.527     0.200
    40.471     1.377     0.200
    40.667     2.518     0.200
    40.820     3.040     0.200
    40.948     2.511     0.200
    41.287     2.905     0.200
    41.416     2.055     0.200
    41.441     2.918     0.200
    42.157     2.374     0.200
    42.692     3.458     0.200
    43.019     2.911     0.200
    43.469     3.444     0.200
    45.532     1.755     0.200
    45.769     2.951     0.200
    46.612     2.787     0.200
    47.166     1.555     0.200
    48.997     1.978     0.200
    57.015     1.862     0.200
    59.961     2.111     0.200
    61.915     0.919     0.200
    64.073     2.609     0.200
    64.073     2.429     0.200
    64.996     2.104     0.200
    65.341     1.892     0.200
    65.632     2.299     0.200
    65.853     2.573     0.200
    66.693     2.296     0.200
    66.842     2.010     0.200
    66.842     1.424     0.200
    69.361    -0.169     0.200
    76.140     1.718     0.200
    76.140     1.401     0.200
    78.246     2.041     0.200
    78.246     1.677     0.200
    78.664     2.311     0.200
    78.664     2.311     0.200
    79.335     1.582     0.200
    81.404     2.597     0.200
    81.404     2.128     0.200
    81.512     3.010     0.200
    82.968     2.173     0.200
    82.968    -0.015     0.200
    84.434     1.997     0.200
    84.434     1.814     0.200
    85.062     1.716     0.200
    85.061     1.736     0.200
    92.998     1.150     0.200
    92.998     0.826     0.200
    94.098     3.465     0.200
    94.457     2.176     0.200
    97.521     0.765     0.200
    14.145     7.300     0.200
    14.184     5.201     0.200
    14.339     5.118     0.200
    14.339     5.537     0.200
    14.255     5.398     0.200
    14.255     6.433     0.200
    14.265     7.764     0.200
    14.400     5.623     0.200
    14.447     4.944     0.200
    14.513     7.676     0.200
    14.533     5.558     0.200
    14.541    10.433     0.200
    14.637     5.468     0.200
    14.644     7.720     0.200
    14.737     4.871     0.200
    14.896     6.822     0.200
    14.897     9.272     0.200
    14.991     6.602     0.200
    15.078     5.439     0.200
    15.129     7.677     0.200
    15.274     3.711     0.200
    15.251     9.210     0.200
    15.435     6.250     0.200
    15.545     4.847     0.200
    15.830     4.096     0.200
    15.936     2.957     0.200
    15.995     8.529     0.200
    16.330     3.728     0.200
    16.483     4.523     0.200
    16.498     3.764     0.200
    16.527     4.971     0.200
    16.580     4.795     0.200
    16.739     5.371     0.200
    16.836     1.668     0.200
    17.005     3.356     0.200
    17.135     3.980     0.200
    17.467     2.308     0.200
    17.506     4.427     0.200
    17.775     2.607     0.200
    17.841     3.231     0.200
    17.923     1.243     0.200
    18.007     3.499     0.200
    18.081     1.632     0.200
    18.081     2.187     0.200
    18.034     2.586     0.200
    18.353     1.777     0.200
    18.465    -3.215     0.200
    18.509     0.523     0.200
    18.509     3.234     0.200
    18.729    -0.806     0.200
    18.747    -0.077     0.200
    19.021     1.558     0.200
    19.231    -1.108     0.200
    20.415     1.017     0.200
    20.765     0.075     0.200
    20.743     1.591     0.200
    20.930    -0.219     0.200
    21.101    -1.138     0.200
    21.105     2.157     0.200
    21.183    -3.096     0.200
    21.256     2.344     0.200
    21.257     3.672     0.200
    21.257     3.064     0.200
    21.325     2.046     0.200
    21.318    -0.401     0.200
    21.376     0.860     0.200
    21.364     1.397     0.200
    21.372     1.668     0.200
    21.466     2.264     0.200
    21.487     0.885     0.200
    21.499     2.341     0.200
    21.486     3.153     0.200
    21.532     1.514     0.200
    21.560     0.342     0.200
    21.650     1.497     0.200
    21.815     1.250     0.200
    21.847     0.584     0.200
    21.881     1.054     0.200
    21.909     0.319     0.200
    21.935     2.737     0.200
    22.143     1.722     0.200
    22.314     2.993     0.200
    22.316     2.545     0.200
    22.389     1.650     0.200
    22.389     1.531     0.200
    22.390     1.989     0.200
    22.594     2.418     0.200
    22.594     1.289     0.200
    22.753     1.150     0.200
    22.753     1.041     0.200
    22.708    -2.543     0.200
    22.708     2.864     0.200
    22.830     1.361     0.200
    22.830     1.152     0.200
    22.849     1.259     0.200
    22.968     1.929     0.200
    23.032     1.496     0.200
    23.069     0.778     0.200
    23.134     0.668     0.200
    23.203     2.548     0.200
    23.216     3.138     0.200
    23.216     3.414     0.200
    23.260     1.658     0.200
    23.404     3.076     0.200
    23.478     2.651     0.200
    23.708     3.165     0.200
    23.762    -0.088     0.200
    23.855     0.452     0.200
    23.892     0.103     0.200
    23.869     2.598     0.200
    23.909     2.671     0.200
    23.966     0.844     0.200
    24.130    -0.348     0.200
    24.127    -3.756     0.200
    24.138    -1.624     0.200
    24.138     1.441     0.200
    24.179    -0.129     0.200
    24.176     2.645     0.200
    24.115     1.995     0.200
    24.115     1.891     0.200
    24.160     2.491     0.200
    24.247     2.531     0.200
    24.265     0.813     0.200
    24.398     1.528     0.200
    24.390     0.784     0.200
    24.431     0.907     0.200
    24.479     0.075     0.200
    24.666     1.493     0.200
    24.666     3.219     0.200
    24.716     2.273     0.200
    24.666     1.906     0.200
    24.741     2.270     0.200
    24.815     1.472     0.200
    25.029     1.294     0.200
    25.012     1.950     0.200
    25.012     4.169     0.200
    25.128     0.117     0.200
    25.128     2.122     0.200
    25.158     2.058     0.200
    25.143     2.178     0.200
    25.203     1.887     0.200
    25.207     2.544     0.200
    25.302     1.786     0.200
    25.325     3.039     0.200
    25.472    -0.401     0.200
    25.469     2.560     0.200
    25.487     2.167     0.200
    25.377     1.427     0.200
    25.486     2.849     0.200
    25.541     1.317     0.200
    25.626    -0.438     0.200
    25.637     3.245     0.200
    25.611     2.388     0.200
    25.663     0.246     0.200
    25.663     3.287     0.200
    25.710     2.948     0.200
    25.781     0.880     0.200
    25.785     0.238     0.200
    25.782     0.272     0.200
    25.782     1.450     0.200
    25.794     0.324     0.200
    25.860     1.307     0.200
    25.915     1.006     0.200
    25.955    -0.747     0.200
    25.967     2.019     0.200
    25.945     1.975     0.200
    25.945    -0.970     0.200
    26.100     1.742     0.200
    26.101     1.825     0.200
    26.136     2.223     0.200
    26.136     1.711     0.200
    26.168    -1.486     0.200
    26.168     1.981     0.200
    26.189     0.816     0.200
    26.189     3.495     0.200
    26.186     0.550     0.200
    26.186     5.940     0.200
    26.281    -1.937     0.200
    26.267     0.322     0.200
    26.323     1.929     0.200
    26.363     2.232     0.200
    26.420     1.535     0.200
    26.420     1.754     0.200
    26.447     1.691     0.200
    26.463     0.802     0.200
    26.507     1.700     0.200
    26.505     2.371     0.200
    26.630    -0.687     0.200
    26.630     1.746     0.200
    26.608     2.421     0.200
    26.663     1.730     0.200
    26.661    -1.205     0.200
    26.661     1.826     0.200
    26.531     2.680     0.200
    26.690    -0.233     0.200
    26.710     1.071     0.200
    26.728     1.303     0.200
    26.728     1.110     0.200
    26.728     3.227     0.200
    26.957     1.689     0.200
    27.029     2.188     0.200
    27.082     1.755     0.200
    27.061     2.858     0.200
    27.107     2.159     0.200
    27.107     1.821     0.200
    27.087     1.328     0.200
    27.148     1.690     0.200
    27.158     1.981     0.200
    27.158     1.805     0.200
    27.158     2.211     0.200
    27.234     1.501     0.200
    27.234     1.204     0.200
    27.221     3.414     0.200
    27.326     2.728     0.200
    28.062    -7.403     0.200
    28.062    -4.834     0.200
    27.372     1.957     0.200
    27.367     0.389     0.200
    27.424     1.853     0.200
    27.481     2.652     0.200
    27.496     2.691     0.200
    27.523     0.321     0.200
    27.576     1.629     0.200
    27.640    -0.759     0.200
    27.640     2.635     0.200
    27.699     1.823     0.200
    27.690     1.684     0.200
    27.673     1.607     0.200
    27.834     1.847     0.200
    27.809     2.009     0.200
    27.957     0.985     0.200
    27.921     2.913     0.200
    27.921     2.266     0.200
    27.985     2.313     0.200
    27.998     2.024     0.200
    27.998     1.758     0.200
    27.984     0.679     0.200
    28.027    -0.249     0.200
    28.039     2.607     0.200
    28.033     0.121     0.200
    28.033     2.312     0.200
    28.083     0.588     0.200
    28.132    -1.278     0.200
    28.170     2.479     0.200
    28.197     1.722     0.200
    28.229    -2.476     0.200
    28.229     1.611     0.200
    28.233    -1.681     0.200
    28.233     1.548     0.200
    28.243     2.152     0.200
    28.276     3.710     0.200
    28.374     2.607     0.200
    28.444     1.766     0.200
    28.492     1.838     0.200
    28.519     1.241     0.200
    28.483     2.057     0.200
    28.590     1.633     0.200
    28.636     2.019     0.200
    28.636     1.595     0.200
    28.639     2.069     0.200
    28.720     1.690     0.200
    28.711     0.240     0.200
    28.741    -1.260     0.200
    28.741     2.589     0.200
    28.819     1.606     0.200
    28.873    -1.297     0.200
    28.873     1.340     0.200
    28.947     1.518     0.200
    29.020    -1.719     0.200
    29.020     2.328     0.200
    29.033    -1.154     0.200
    29.067     0.435     0.200
    29.067     3.247     0.200
    29.116     1.644     0.200
    29.111    -2.281     0.200
    29.111     1.893     0.200
    29.169     1.398     0.200
    29.173     3.009     0.200
    29.226     3.466     0.200
    29.360     0.611     0.200
    29.318     0.684     0.200
    29.386     1.995     0.200
    29.434     1.738     0.200
    29.433     1.772     0.200
    29.439    -1.088     0.200
    29.439     1.344     0.200
    29.539     2.116     0.200
    29.527     2.391     0.200
    29.534     1.818     0.200
    29.534     1.707     0.200
    29.572    -0.636     0.200
    29.639     0.626     0.200
    29.758    -2.229     0.200
    29.758     2.327     0.200
    29.870     4.437     0.200
    30.029     0.926     0.200
    30.177     3.184     0.200
    30.191     2.120     0.200
    30.205     1.561     0.200
    30.254     2.912     0.200
    30.272     2.731     0.200
    30.319     3.414     0.200
    30.451     2.718     0.200
    30.450     2.592     0.200
    30.496     3.008     0.200
    30.496     1.754     0.200
    30.532     1.536     0.200
    30.793     1.458     0.200
    30.817     2.544     0.200
    30.824     0.386     0.200
    30.824     1.468     0.200
    30.966     2.206     0.200
    30.966     1.651     0.200
    30.980     0.212     0.200
    30.980     2.101     0.200
    30.998     1.354     0.200
    30.998     1.653     0.200
    31.028     2.416     0.200
    31.059    -2.632     0.200
    31.059     2.191     0.200
    31.169     0.640     0.200
    31.275     0.792     0.200
    31.288    -1.281     0.200
    31.331     1.981     0.200
    31.448     1.864     0.200
    31.550     1.031     0.200
    31.536    -0.455     0.200
    31.536     2.477     0.200
    31.565     0.076     0.200
    31.565     1.585     0.200
    31.639     1.730     0.200
    31.678     0.811     0.200
    31.727     1.646     0.200
    31.721    -0.902     0.200
    31.727     2.494     0.200
    31.760     1.280     0.200
    31.870     2.033     0.200
    31.885     1.290     0.200
    31.892     2.574     0.200
    32.034     1.850     0.200
    32.066     1.253     0.200
    32.052     1.379     0.200
    32.198     2.072     0.200
    32.229     2.936     0.200
    32.253    -0.202     0.200
    32.253     1.662     0.200
    32.290    -0.519     0.200
    32.296     1.628     0.200
    32.399     2.811     0.200
    32.445     2.161     0.200
    32.629     1.613     0.200
    32.689     1.902     0.200
    32.700     2.383     0.200
    32.777     1.978     0.200
    32.783     2.375     0.200
    32.895     3.150     0.200
    32.895     1.887     0.200
    32.903     1.964     0.200
    32.948     1.279     0.200
    32.956    -0.798     0.200
    33.018     2.274     0.200
    33.036    -0.457     0.200
    33.036     1.629     0.200
    33.114    -2.992     0.200
    33.177     2.100     0.200
    33.189     1.633     0.200
    33.235     2.676     0.200
    33.331     1.046     0.200
    33.392     3.268     0.200
    33.534     2.805     0.200
    33.528     2.535     0.200
    33.573     0.984     0.200
    33.595     1.542     0.200
    33.678     2.195     0.200
    33.727     0.714     0.200
    33.976     1.596     0.200
    33.971     2.574     0.200
    34.071     1.321     0.200
    34.101    -1.829     0.200
    34.247     0.421     0.200
    34.240     2.736     0.200
    34.485    -0.697     0.200
    34.474    -0.282     0.200
    34.481     2.077     0.200
    34.552     1.851     0.200
    34.598     2.597     0.200
    34.756     2.837     0.200
    34.804     2.587     0.200
    34.905     2.211     0.200
    35.120     1.712     0.200
    35.192     2.750     0.200
    35.382     0.871     0.200
    35.440     3.230     0.200
    35.564     3.458     0.200
    35.742    -1.684     0.200
    35.785     2.102     0.200
    35.806     1.409     0.200
    35.921     0.078     0.200
    35.955    -0.511     0.200
    35.939     1.896     0.200
    35.939     1.256     0.200
    36.434     3.904     0.200
    36.744     3.860     0.200
    37.269    -3.370     0.200
    37.362     1.604     0.200
    37.629     1.714     0.200
    38.252     0.355     0.200
    38.368     0.780     0.200
    38.372     2.612     0.200
    38.398     2.495     0.200
    38.404     1.583     0.200
    38.610     0.424     0.200
    38.605    -0.340     0.200
    38.619     2.828     0.200
    38.705     2.765     0.200
    38.700     1.173     0.200
    38.697     2.623     0.200
    38.770     1.905     0.200
    38.802     2.011     0.200
    39.081     3.136     0.200
    39.103     2.692     0.200
    39.499     2.573     0.200
    39.499     1.771     0.200
    39.703     1.052     0.200
    39.703     2.402     0.200
    39.806     3.148     0.200
    39.838     2.672     0.200
    40.043     3.073     0.200
    40.067     2.146     0.200
    40.067     0.351     0.200
    40.181     3.187     0.200
    40.246     3.209     0.200
    40.272     2.296     0.200
    40.337     2.641     0.200
    40.440     2.587     0.200
    40.443     4.868     0.200
    40.474     2.348     0.200
    40.698     2.852     0.200
    40.861     3.067     0.200
    40.981     2.255     0.200
    41.089     1.557     0.200
    41.329     0.951     0.200
    41.477     1.071     0.200
    41.498     0.361     0.200
    42.504     3.473     0.200
    42.730     2.194     0.200
    42.921     3.642     0.200
    43.055     0.783     0.200
    43.416     0.132     0.200
    43.283     1.600     0.200
    43.510     2.023     0.200
    43.510     2.330     0.200
    43.456     2.865     0.200
    44.183     1.441     0.200
    44.357     5.380     0.200
    44.400     3.257     0.200
    45.006     4.633     0.200
    45.074     1.189     0.200
    45.061     2.426     0.200
    45.215     4.573     0.200
    45.238     4.563     0.200
    45.267     5.217     0.200
    45.487     1.088     0.200
    45.558     2.905     0.200
    45.558    -0.595     0.200
    45.766     1.312     0.200
    45.803     2.389     0.200
    45.803     1.164     0.200
    46.640     2.302     0.200
    47.201     0.588     0.200
    48.371     0.035     0.200
    52.165     1.091     0.200
    52.165     1.511     0.200
    57.092     1.319     0.200
    61.302     1.954     0.200
    61.988     0.124     0.200
    64.076     4.371     0.200
    64.076     1.546     0.200
    64.669     1.554     0.200
    65.021     1.647     0.200
    65.630    -0.580     0.200
    65.852     5.060     0.200
    66.863     2.331     0.200
    66.863     3.312     0.200
    66.863     3.931     0.200
    67.908     0.628     0.200
    68.216     1.558     0.200
    68.323     1.325     0.200
    69.403     0.760     0.200
    69.730     2.800     0.200
    74.767     3.321     0.200
    76.213     1.398     0.200
    76.213     1.223     0.200
    76.633    -2.460     0.200
    78.250     1.266     0.200
    78.285     3.794     0.200
    78.743     1.538     0.200
    79.119    -1.195     0.200
    79.344     2.472     0.200
    79.344    -0.688     0.200
    79.388     0.808     0.200
    79.388     2.233     0.200
    79.702     5.022     0.200
    81.527     2.635     0.200
    81.381     3.008     0.200
    81.608     3.507     0.200
    81.771     4.748     0.200
    81.800     2.797     0.200
    82.063     3.713     0.200
    82.195     3.716     0.200
    82.481     3.223     0.200
    82.545     3.190     0.200
    82.801     3.656     0.200
    82.826     3.224     0.200
    82.978     3.838     0.200
    83.044     1.216     0.200
    83.044     1.496     0.200
    83.020    -2.223     0.200
    83.133     4.737     0.200
    83.153     3.189     0.200
    83.153     3.629     0.200
    83.157     3.183     0.200
    83.157     3.812     0.200
    83.258     2.958     0.200
    83.286     3.547     0.200
    83.307     3.735     0.200
    83.323     1.056     0.200
    83.343     3.127     0.200
    83.351     3.085     0.200
    83.361     0.249     0.200
    83.377     0.966     0.200
    83.387     1.322     0.200
    83.387     3.823     0.200
    83.463     3.671     0.200
    83.658     3.511     0.200
    83.672     4.059     0.200
    83.701     2.906     0.200
    83.726     3.881     0.200
    83.767     3.435     0.200
    84.213     3.341     0.200
    84.264     3.446     0.200
    84.443     1.129     0.200
    84.443    -0.671     0.200
    84.706     3.998     0.200
    84.768     3.385     0.200
    84.837     3.742     0.200
    84.862     4.130     0.200
    84.875     1.069     0.200
    85.076     3.511     0.200
    85.057     1.848     0.200
    85.384     3.515     0.200
    85.720     3.122     0.200
    85.906     3.662     0.200
    86.647    -0.450     0.200
    86.734     3.945     0.200
    86.757     3.024     0.200
    86.805     2.075     0.200
    86.903     3.796     0.200
    87.788     2.255     0.200
    88.006     1.681     0.200
    88.076     2.600     0.200
    88.091    -0.493     0.200
    88.168     2.214     0.200
    88.267    -1.257     0.200
    88.341     1.756     0.200
    88.334     5.127     0.200
    88.388     1.915     0.200
    88.472     0.673     0.200
    88.479     2.622     0.200
    88.574     1.452     0.200
    88.653     2.734     0.200
    88.901     0.352     0.200
    89.442     2.132     0.200
    89.459     1.990     0.200
    89.526     4.019     0.200
    89.596     1.904     0.200
    89.596     2.369     0.200
    90.026     0.530     0.200
    90.120     1.923     0.200
    90.364     3.007     0.200
    90.405     1.413     0.200
    90.475     1.755     0.200
    90.676     1.481     0.200
    90.959    -2.661     0.200
    90.978     2.348     0.200
    91.118    -2.099     0.200
    91.277     2.262     0.200
    91.735     2.639     0.200
    91.880     3.239     0.200
    91.880     2.670     0.200
    91.880     0.080     0.200
    91.956    -2.514     0.200
    92.052     0.262     0.200
    92.283     1.205     0.200
    93.076     0.618     0.200
    93.076    -1.157     0.200
    93.097     3.247     0.200
    93.105     3.909     0.200
    93.385     2.419     0.200
    93.564    -2.215     0.200
    93.852     4.672     0.200
    93.852     0.142     0.200
    94.249     1.749     0.200
    94.506     0.117     0.200
    94.506     2.467     0.200
    94.506     0.837     0.200
    95.511     2.046     0.200
    95.511     0.201     0.200
    95.286     3.196     0.200
    96.289    -0.670     0.200
    96.900     3.855     0.200
    96.900     3.975     0.200
    14.314     6.521     0.200
    14.359     8.779     0.200
    14.553     5.295     0.200
    14.766     8.259     0.200
    15.037     7.878     0.200
    15.109     6.574     0.200
    15.395     5.660     0.200
    15.584     4.628     0.200
    15.751     4.788     0.200
    15.722     6.949     0.200
    15.792     6.388     0.200
    16.021     4.904     0.200
    16.093     6.585     0.200
    16.422     4.143     0.200
    17.048     4.092     0.200
    17.600     4.212     0.200
    17.862     2.693     0.200
    17.901     2.780     0.200
    17.901     3.144     0.200
    17.931     2.173     0.200
    17.902     2.924     0.200
    18.155     3.592     0.200
    18.345     2.882     0.200
    18.429     0.389     0.200
    18.752     1.375     0.200
    18.789     1.960     0.200
    19.263     2.057     0.200
    20.111     2.660     0.200
    20.342     2.184     0.200
    20.400     1.966     0.200
    20.433     0.798     0.200
    20.433     2.810     0.200
    20.676     1.265     0.200
    21.176     3.975     0.200
    21.322     0.540     0.200
    21.349     2.789     0.200
    21.558     3.153     0.200
    21.568     3.592     0.200
    22.347     1.089     0.200
    22.393     3.269     0.200
    22.603     0.292     0.200
    22.678     1.222     0.200
    22.678     2.132     0.200
    22.759     1.288     0.200
    22.759     3.476     0.200
    22.816     0.240     0.200
    23.009     2.612     0.200
    23.083     2.489     0.200
    23.295     1.453     0.200
    23.355     2.215     0.200
    23.976     2.457     0.200
    24.093     1.063     0.200
    24.093     1.434     0.200
    24.112     3.030     0.200
    24.125     0.630     0.200
    24.153     0.717     0.200
    24.282     1.138     0.200
    24.282     2.755     0.200
    24.660     0.396     0.200
    25.135     2.917     0.200
    25.206     2.389     0.200
    25.735     1.083     0.200
    25.788     1.849     0.200
    25.856     3.164     0.200
    26.003     2.535     0.200
    26.003     4.711     0.200
    26.240     0.750     0.200
    26.243     0.662     0.200
    26.692     1.974     0.200
    26.985     1.071     0.200
    27.085     0.722     0.200
    27.128     1.662     0.200
    27.181     0.544     0.200
    27.284     1.215     0.200
    27.448     2.102     0.200
    27.471     0.270     0.200
    27.493     0.760     0.200
    27.513     0.655     0.200
    27.566     1.472     0.200
    27.677     0.873     0.200
    27.718     0.001     0.200
    27.771    -0.029     0.200
    27.856     0.496     0.200
    27.928     5.224     0.200
    27.983     1.414     0.200
    28.000     0.596     0.200
    28.023     1.041     0.200
    28.073     0.651     0.200
    28.090     1.174     0.200
    28.125     0.892     0.200
    28.237     1.227     0.200
    28.249     0.230     0.200
    28.262     1.013     0.200
    28.263    -0.209     0.200
    28.356     1.309     0.200
    28.414    -0.166     0.200
    28.492     0.617     0.200
    28.516     0.400     0.200
    28.558     0.644     0.200
    28.598     0.773     0.200
    28.651     1.427     0.200
    28.673     0.748     0.200
    28.763     0.890     0.200
    28.778     0.936     0.200
    28.788     0.904     0.200
    28.894     1.229     0.200
    28.977     1.078     0.200
    29.082     0.766     0.200
    29.089     0.908     0.200
    29.106     2.253     0.200
    29.132     1.422     0.200
    29.136     1.451     0.200
    29.207     0.637     0.200
    29.259     0.524     0.200
    29.300     1.477     0.200
    29.464     1.041     0.200
    29.539     0.772     0.200
    29.554     2.317     0.200
    29.624     0.920     0.200
    29.632     1.839     0.200
    29.678     2.379     0.200
    29.706     1.815     0.200
    29.709     1.533     0.200
    29.725     4.092     0.200
    29.754     2.316     0.200
    29.770     1.822     0.200
    30.223     0.394     0.200
    30.239     0.557     0.200
    30.259     1.542     0.200
    30.276     1.414     0.200
    30.284     0.333     0.200
    30.283     1.520     0.200
    30.359     0.632     0.200
    30.506     1.243     0.200
    30.508     1.769     0.200
    30.522     1.957     0.200
    30.550     2.004     0.200
    30.767     1.258     0.200
    30.811     1.787     0.200
    30.814     0.557     0.200
    30.846     0.844     0.200
    30.856     0.802     0.200
    30.869     1.319     0.200
    30.915     1.159     0.200
    30.984     0.750     0.200
    30.985     0.718     0.200
    30.992     2.163     0.200
    31.064     1.229     0.200
    31.068     1.080     0.200
    31.083     1.186     0.200
    31.083     2.354     0.200
    31.222     0.771     0.200
    31.284     1.985     0.200
    31.382     0.740     0.200
    31.327     1.322     0.200
    31.352     1.387     0.200
    31.380     1.932     0.200
    31.405     2.895     0.200
    31.550     2.244     0.200
    31.571     1.336     0.200
    31.727     1.689     0.200
    31.747     2.254     0.200
    31.756     1.180     0.200
    32.005    -0.939     0.200
    31.818     1.756     0.200
    31.858     1.521     0.200
    31.870     1.311     0.200
    31.877     2.350     0.200
    31.992     1.789     0.200
    32.029     1.621     0.200
    32.050     1.128     0.200
    32.054     1.075     0.200
    32.084     1.183     0.200
    32.249     2.400     0.200
    32.260     1.945     0.200
    32.294     1.713     0.200
    32.336     1.791     0.200
    32.410     1.734     0.200
    32.582     0.587     0.200
    32.610     1.256     0.200
    32.713     1.761     0.200
    32.713     1.786     0.200
    32.715     2.579     0.200
    32.777     1.686     0.200
    32.793     1.525     0.200
    32.862     1.189     0.200
    32.895     2.227     0.200
    32.902     1.495     0.200
    32.931     1.769     0.200
    32.947     2.111     0.200
    33.037     1.736     0.200
    33.047     2.135     0.200
    33.162     3.957     0.200
    33.168     1.453     0.200
    33.213     1.953     0.200
    33.239     0.630     0.200
    33.313     0.381     0.200
    33.405     1.269     0.200
    33.408     2.179     0.200
    33.521     1.223     0.200
    33.529     2.090     0.200
    33.538     2.047     0.200
    33.616     0.875     0.200
    33.628     1.692     0.200
    33.652     1.860     0.200
    33.684     2.355     0.200
    33.940     1.432     0.200
    33.984     1.994     0.200
    33.989     2.326     0.200
    34.055     1.875     0.200
    34.126     1.434     0.200
    34.125     1.501     0.200
    34.228     1.827     0.200
    34.310     2.092     0.200
    34.487     1.688     0.200
    34.537     1.604     0.200
    34.595     1.199     0.200
    34.733     2.069     0.200
    34.757     1.623     0.200
    34.772     2.078     0.200
    34.794     2.444     0.200
    34.911     2.169     0.200
    34.924     1.674     0.200
    35.106     2.008     0.200
    35.178     2.702     0.200
    35.190     2.500     0.200
    35.373     2.847     0.200
    35.374     2.682     0.200
    35.442     2.427     0.200
    35.579     2.397     0.200
    35.606     2.215     0.200
    35.699     1.397     0.200
    35.785     1.375     0.200
    35.793     1.985     0.200
    35.897     2.458     0.200
    35.917     0.377     0.200
    35.924     1.770     0.200
    35.943     2.860     0.200
    35.983     2.644     0.200
    36.010     2.259     0.200
    36.049     2.044     0.200
    36.141     2.602     0.200
    36.199     2.409     0.200
    36.377     2.834     0.200
    36.436     3.078     0.200
    36.535     2.842     0.200
    36.859     2.812     0.200
    36.879     3.053     0.200
    37.063     3.029     0.200
    37.279     2.586     0.200
    37.544     3.038     0.200
    37.554     3.009     0.200
    37.617     2.568     0.200
    37.690     1.962     0.200
    37.883     3.652     0.200
    37.915     3.439     0.200
    37.938     2.377     0.200
    37.968     2.989     0.200
    38.125     2.787     0.200
    38.201     3.874     0.200
    38.312     2.791     0.200
    38.362     2.762     0.200
    38.410     3.153     0.200
    38.668     2.352     0.200
    38.691     2.134     0.200
    38.808     5.789     0.200
    38.992     1.486     0.200
    39.098     1.700     0.200
    39.144     2.352     0.200
    39.284     1.935     0.200
    39.487     3.077     0.200
    39.637     3.107     0.200
    39.867     2.890     0.200
    39.867     2.429     0.200
    40.045     3.466     0.200
    40.239     4.720     0.200
    40.242     3.456     0.200
    40.274     3.011     0.200
    40.444     2.660     0.200
    40.883     3.102     0.200
    41.448     1.753     0.200
    41.448     2.116     0.200
    41.981     3.151     0.200
    41.991     3.689     0.200
    41.967     2.834     0.200
    42.531     3.350     0.200
    42.683     2.319     0.200
    43.229     3.125     0.200
    43.313     3.447     0.200
    43.372     1.644     0.200
    43.466     4.164     0.200
    44.367     3.934     0.200
    44.409     1.725     0.200
    44.539     3.877     0.200
    44.804     4.114     0.200
    45.034     4.032     0.200
    45.391     4.430     0.200
    45.391     4.949     0.200
    45.391     2.629     0.200
    45.398     4.477     0.200
    45.447     5.407     0.200
    45.457     5.307     0.200
    45.692     2.686     0.200
    45.737     2.727     0.200
    45.971     2.570     0.200
    45.971     3.480     0.200
    45.971     2.902     0.200
    46.004     3.875     0.200
    55.048     2.573     0.200
    56.977     1.508     0.200
    56.977     2.047     0.200
    60.165     2.155     0.200
    61.036     2.181     0.200
    61.091     0.771     0.200
    62.743     0.945     0.200
    64.277     1.136     0.200
    64.277     2.230     0.200
    64.814     2.424     0.200
    65.144     1.854     0.200
    65.457     2.134     0.200
    65.709     2.127     0.200
    66.452     2.122     0.200
    67.562     2.321     0.200
    67.593     2.262     0.200
    68.420     1.811     0.200
    69.570     1.086     0.200
    69.968     2.054     0.200
    70.856     2.905     0.200
    71.550     2.773     0.200
    74.470     2.670     0.200
    74.888     2.506     0.200
    75.585     1.914     0.200
    76.078     1.217     0.200
    76.177     2.193     0.200
    78.451     2.276     0.200
    78.451     1.858     0.200
    78.468     2.732     0.200
    78.468     4.021     0.200
    78.638     2.240     0.200
    78.638     2.065     0.200
    79.065     3.155     0.200
    79.118     2.276     0.200
    79.205     1.429     0.200
    79.700     2.644     0.200
    80.996     1.936     0.200
    81.039     2.453     0.200
    81.588     2.239     0.200
    81.750     3.060     0.200
    81.776     2.925     0.200
    81.901     2.162     0.200
    82.463     1.219     0.200
    82.523     2.507     0.200
    82.786     2.938     0.200
    82.806     2.035     0.200
    82.922     2.052     0.200
    82.965     3.908     0.200
    83.144     2.979     0.200
    83.144     3.377     0.200
    83.188     2.782     0.200
    83.238     2.224     0.200
    83.264     2.446     0.200
    83.263     2.278     0.200
    83.290     2.096     0.200
    83.372     2.464     0.200
    83.585     2.295     0.200
    83.625     1.924     0.200
    83.712     3.256     0.200
    84.140     2.056     0.200
    84.182     2.346     0.200
    84.236     2.231     0.200
    84.236     1.630     0.200
    84.685     2.222     0.200
    84.680     3.691     0.200
    84.755     2.619     0.200
    84.781     2.320     0.200
    84.857     1.641     0.200
    84.857     2.462     0.200
    84.857     1.130     0.200
    84.857     2.137     0.200
    84.848     2.514     0.200
    85.001     1.969     0.200
    85.305     2.059     0.200
    85.894     2.403     0.200
    86.155     2.338     0.200
    86.241     1.496     0.200
    86.287     1.621     0.200
    86.509     0.331     0.200
    86.511     1.505     0.200
    86.656     2.505     0.200
    86.676     1.867     0.200
    86.721     1.230     0.200
    87.010     1.789     0.200
    87.010     1.075     0.200
    87.050     1.214     0.200
    88.127     1.515     0.200
    88.393     0.688     0.200
    88.393     1.176     0.200
    88.581     1.968     0.200
    89.316     1.612     0.200
    89.360     1.805     0.200
    89.417     1.238     0.200
    90.117     2.466     0.200
    90.321     1.416     0.200
    90.501     0.836     0.200
    90.669     1.224     0.200
    90.891     1.763     0.200
    90.959     1.773     0.200
    92.967     1.457     0.200
    93.226     2.378     0.200
    93.226     2.620     0.200
    93.924     1.628     0.200
    93.924     2.339     0.200
    94.152     2.043     0.200
    94.318     2.311     0.200
    94.318     1.291     0.200
    94.318     1.780     0.200
    95.471     2.737     0.200
    14.056     6.282     0.200
    14.212     6.197     0.200
    14.212     6.729     0.200
    14.259     5.171     0.200
    14.257     7.502     0.200
    14.371     6.544     0.200
    14.281     6.424     0.200
    14.309     6.612     0.200
    14.396     6.535     0.200
    14.368     7.982     0.200
    14.406     5.646     0.200
    14.473     5.907     0.200
    14.509     5.693     0.200
    14.503     5.500     0.200
    14.556     6.701     0.200
    14.572     7.127     0.200
    14.596     6.829     0.200
    14.834    11.244     0.200
    14.878     5.629     0.200
    14.879     5.235     0.200
    14.945     4.743     0.200
    14.988     4.939     0.200
    15.258     5.400     0.200
    15.258     5.071     0.200
    15.293     6.605     0.200
    15.273     6.982     0.200
    15.412     6.575     0.200
    15.561     4.625     0.200
    15.663     4.848     0.200
    15.720     3.667     0.200
    15.779     5.064     0.200
    15.833     4.511     0.200
    16.343     4.102     0.200
    17.659     2.912     0.200
    17.879     2.876     0.200
    17.941     3.612     0.200
    18.358     0.391     0.200
    18.423    -1.184     0.200
    18.507    -2.338     0.200
    18.593    -2.117     0.200
    18.727    -0.561     0.200
    18.760     1.142     0.200
    18.898    -2.293     0.200
    18.873    -0.056     0.200
    18.987     0.922     0.200
    19.003    -0.159     0.200
    19.202    -0.220     0.200
    19.181     0.700     0.200
    19.364     0.001     0.200
    19.516    -0.492     0.200
    19.546    -0.572     0.200
    19.546     1.959     0.200
    19.665     1.167     0.200
    19.855     2.070     0.200
    20.218     0.881     0.200
    20.253     1.206     0.200
    20.268    -1.276     0.200
    20.376    -1.269     0.200
    20.664    -1.507     0.200
    20.723    -0.964     0.200
    20.754    -0.079     0.200
    20.984    -1.013     0.200
    21.106    -0.350     0.200
    21.295     2.163     0.200
    21.293     2.819     0.200
    21.453     2.875     0.200
    21.491     0.381     0.200
    21.823     0.528     0.200
    22.315    -1.503     0.200
    22.552    -1.132     0.200
    22.660     1.674     0.200
    22.695    -1.204     0.200
    22.774    -0.802     0.200
    22.799    -0.504     0.200
    22.938     2.840     0.200
    22.970    -0.541     0.200
    23.110     1.627     0.200
    23.223     3.361     0.200
    23.279     1.745     0.200
    23.386     3.553     0.200
    23.468     1.119     0.200
    23.718    -0.716     0.200
    23.710     2.157     0.200
    23.815     3.170     0.200
    23.822     0.551     0.200
    23.897     3.055     0.200
    23.882     0.131     0.200
    23.897    -0.616     0.200
    24.035     4.004     0.200
    24.035     0.223     0.200
    24.080     3.544     0.200
    24.080     2.427     0.200
    24.071     2.807     0.200
    24.100    -0.950     0.200
    24.153    -0.596     0.200
    24.223    -1.878     0.200
    24.234     2.883     0.200
    24.387    -2.089     0.200
    24.659    -1.962     0.200
    24.746    -0.016     0.200
    24.959     2.651     0.200
    25.010     1.316     0.200
    25.060     3.276     0.200
    25.104     1.953     0.200
    25.127     3.433     0.200
    25.152     3.664     0.200
    25.317     4.037     0.200
    25.665     0.647     0.200
    25.679     1.254     0.200
    25.758     0.271     0.200
    25.937     4.629     0.200
    25.937     4.856     0.200
    26.091     1.436     0.200
    26.383     1.503     0.200
    26.580     0.794     0.200
    26.603     0.911     0.200
    26.928     0.847     0.200
    27.125     0.698     0.200
    27.617     0.182     0.200
    27.661     2.622     0.200
    27.916     1.731     0.200
    27.983     0.791     0.200
    28.636     1.870     0.200
    28.839    -0.530     0.200
    28.945     2.423     0.200
    29.014    -0.589     0.200
    29.045     0.184     0.200
    29.499     0.287     0.200
    30.465     0.849     0.200
    30.496     0.539     0.200
    30.798    -0.650     0.200
    31.692     2.884     0.200
    31.862     5.147     0.200
    32.210    -0.956     0.200
    32.244    -0.688     0.200
    32.357     1.338     0.200
    32.436     1.855     0.200
    32.569     0.643     0.200
    32.852     0.135     0.200
    32.925    -0.245     0.200
    33.218    -0.584     0.200
    33.355     0.527     0.200
    34.216     0.602     0.200
    34.523     4.880     0.200
    35.814     0.927     0.200
    36.829     3.764     0.200
    37.634    -1.251     0.200
    38.256     4.234     0.200
    38.464    -1.002     0.200
    38.646     0.538     0.200
    39.696    -0.559     0.200
    39.925    -0.427     0.200
    39.925     4.643     0.200
    40.105     1.497     0.200
    40.130     1.480     0.200
    40.196     0.657     0.200
    40.364    -0.473     0.200
    40.475     4.224     0.200
    40.840     3.390     0.200
    40.950     0.692     0.200
    41.420     3.591     0.200
    41.420    -1.206     0.200
    42.085     5.905     0.200
    42.588    -0.403     0.200
    43.368     4.242     0.200
    43.380     8.790     0.200
    44.176     1.498     0.200
    44.176     2.381     0.200
    44.718     6.841     0.200
    44.949     6.758     0.200
    45.023     3.536     0.200
    45.151     7.789     0.200
    45.206     4.716     0.200
    45.306     3.916     0.200
    45.306     1.298     0.200
    45.311     7.175     0.200
    45.605     2.431     0.200
    45.650     4.706     0.200
    52.060     3.701     0.200
    52.060    -0.635     0.200
    56.978    -0.554     0.200
    62.657     0.260     0.200
    64.195     4.646     0.200
    65.221     3.430     0.200
    73.625     1.337     0.200
    75.134     0.054     0.200
    75.436     1.050     0.200
    76.090     3.142     0.200
    78.558    -1.538     0.200
    78.634     3.778     0.200
    79.013    -0.076     0.200
    79.247     4.249     0.200
    83.354     5.163     0.200
    84.314    -0.790     0.200
    84.810     4.513     0.200
    84.810    -0.339     0.200
    84.939     2.551     0.200
    84.939    -0.942     0.200
    86.274     3.053     0.200
    86.522     3.230     0.200
    86.639     4.802     0.200
    88.377     0.366     0.200
    90.265     3.243     0.200
    90.307     4.845     0.200
    90.879     3.186     0.200
    92.965     3.202     0.200
    92.965     1.124     0.200
    93.988     5.337     0.200
    94.364     4.491     0.200
    94.364     0.593     0.200
    97.405     0.351     0.200
    28.725     3.549     0.200
    38.625     2.493     0.200
    14.113     7.520     0.200
    14.213     6.705     0.200
    14.499     6.444     0.200
    14.890     6.135     0.200
    14.850     7.924     0.200
    15.053     7.898     0.200
    15.104     7.192     0.200
    16.281     3.387     0.200
    16.901     2.630     0.200
    17.531     2.885     0.200
    17.736     2.200     0.200
    17.981     3.245     0.200
    17.981     2.954     0.200
    18.150     2.240     0.200
    18.177     2.911     0.200
    18.520     1.249     0.200
    18.552     0.913     0.200
    18.552     1.562     0.200
    18.622     0.716     0.200
    18.932     1.228     0.200
    18.954     0.656     0.200
    19.089     1.612     0.200
    19.203    -0.231     0.200
    19.435     0.941     0.200
    19.438     0.617     0.200
    19.487     1.675     0.200
    19.460     1.848     0.200
    19.704     1.007     0.200
    19.829     1.629     0.200
    20.115     1.381     0.200
    20.244     1.874     0.200
    20.290     2.265     0.200
    20.468     1.422     0.200
    20.451     2.128     0.200
    20.451     2.746     0.200
    20.623     1.726     0.200
    20.614     0.712     0.200
    20.614     1.312     0.200
    20.950     2.106     0.200
    20.950     1.358     0.200
    20.950     1.368     0.200
    21.036     1.507     0.200
    21.171     2.904     0.200
    21.135     3.199     0.200
    21.221     1.529     0.200
    21.264     2.152     0.200
    21.305     3.456     0.200
    21.375     0.939     0.200
    21.500     2.787     0.200
    21.463     1.538     0.200
    21.460     2.765     0.200
    21.460     0.636     0.200
    21.534     1.686     0.200
    21.569     1.810     0.200
    21.569     1.475     0.200
    21.682     0.805     0.200
    21.703     2.494     0.200
    21.742     1.427     0.200
    21.767     2.503     0.200
    22.024     1.450     0.200
    22.056     1.821     0.200
    22.089     1.762     0.200
    22.022     0.642     0.200
    22.353     1.843     0.200
    22.524     1.413     0.200
    22.515     2.761     0.200
    22.592     0.286     0.200
    22.593     2.215     0.200
    22.804     2.262     0.200
    22.804     1.274     0.200
    22.945     1.810     0.200
    22.945     0.116     0.200
    22.914     2.368     0.200
    22.914    -0.375     0.200
    23.039     1.598     0.200
    23.039    -0.660     0.200
    23.059     1.728     0.200
    23.177     1.553     0.200
    23.239     2.303     0.200
    23.279     1.848     0.200
    23.405     2.916     0.200
    23.414     1.518     0.200
    23.414     0.919     0.200
    23.611     2.279     0.200
    23.683     2.826     0.200
    23.909     1.979     0.200
    23.972     2.589     0.200
    24.023     2.107     0.200
    24.065     2.292     0.200
    24.094     2.784     0.200
    24.064     2.814     0.200
    24.115     2.829     0.200
    24.171     2.624     0.200
    24.241     1.070     0.200
    24.338     1.640     0.200
    24.336     0.927     0.200
    24.365     0.614     0.200
    24.348     2.296     0.200
    24.348    -0.300     0.200
    24.363     1.568     0.200
    24.456     1.445     0.200
    24.456     1.161     0.200
    24.474     2.570     0.200
    24.592     2.408     0.200
    24.604     2.835     0.200
    24.575     2.408     0.200
    24.869     1.849     0.200
    24.915     0.839     0.200
    24.940     2.955     0.200
    25.234     1.940     0.200
    25.214     1.990     0.200
    25.336     3.261     0.200
    25.340     2.674     0.200
    25.367     1.882     0.200
    25.413     2.457     0.200
    25.414     2.838     0.200
    25.512     1.888     0.200
    25.529     0.875     0.200
    25.751     3.014     0.200
    25.997     2.411     0.200
    26.075     1.727     0.200
    26.150     0.998     0.200
    26.150     1.849     0.200
    26.305     2.133     0.200
    26.346     2.296     0.200
    26.367     2.261     0.200
    26.367    -0.236     0.200
    26.395     1.854     0.200
    26.630     2.578     0.200
    26.668     3.175     0.200
    26.717     1.186     0.200
    26.811     2.401     0.200
    26.839     2.314     0.200
    26.869     3.122     0.200
    26.936     3.020     0.200
    26.932     1.846     0.200
    27.166     1.998     0.200
    27.371     2.018     0.200
    27.368     1.718     0.200
    27.368     0.059     0.200
    27.359     3.084     0.200
    27.534     2.318     0.200
    27.534     1.870     0.200
    27.582     2.013     0.200
    27.689     2.269     0.200
    27.781     1.565     0.200
    27.848     2.682     0.200
    27.899     2.413     0.200
    28.124     2.812     0.200
    28.124     2.404     0.200
    28.208     2.839     0.200
    28.238     3.370     0.200
    28.339     2.602     0.200
    28.442     1.860     0.200
    28.380    -0.117     0.200
    28.701     2.845     0.200
    28.701     3.764     0.200
    28.841     1.565     0.200
    28.912     1.839     0.200
    29.083     2.565     0.200
    29.132     1.501     0.200
    29.274     3.254     0.200
    29.320     1.866     0.200
    29.326     3.406     0.200
    29.326     2.548     0.200
    29.519     2.258     0.200
    29.648     2.974     0.200
    29.648     3.441     0.200
    29.644     3.369     0.200
    29.744     2.145     0.200
    29.744     2.502     0.200
    29.768     3.096     0.200
    29.866     2.822     0.200
    30.237     2.121     0.200
    30.705     2.555     0.200
    30.705     0.068     0.200
    30.742     2.419     0.200
    31.033     2.427     0.200
    31.033     2.831     0.200
    31.190     2.008     0.200
    31.207     2.435     0.200
    31.268     1.858     0.200
    31.268     0.531     0.200
    31.298     3.686     0.200
    31.742     2.008     0.200
    31.746     1.585     0.200
    31.775     2.986     0.200
    31.929     2.961     0.200
    31.936     1.577     0.200
    32.312     1.207     0.200
    32.500     2.569     0.200
    32.899     3.111     0.200
    32.899     2.644     0.200
    32.910     2.835     0.200
    32.910     2.055     0.200
    32.924     2.969     0.200
    33.105     2.704     0.200
    33.321     0.870     0.200
    33.602     1.452     0.200
    34.186     2.508     0.200
    34.346     2.274     0.200
    34.335     2.291     0.200
    34.335     0.631     0.200
    34.471     1.387     0.200
    34.592     1.551     0.200
    34.775     3.006     0.200
    36.813    -0.984     0.200
    37.417     1.911     0.200
    37.417     2.394     0.200
    38.040     1.096     0.200
    38.185     2.050     0.200
    38.431     2.074     0.200
    38.453     1.079     0.200
    38.634    -0.607     0.200
    38.657     1.515     0.200
    38.657     0.889     0.200
    38.687     3.339     0.200
    38.749    -0.085     0.200
    38.881     1.345     0.200
    38.917     0.395     0.200
    38.918     2.872     0.200
    39.597    -0.521     0.200
    39.782     2.139     0.200
    40.080     2.770     0.200
    40.080     3.231     0.200
    40.112     1.930     0.200
    40.112     0.727     0.200
    40.112     1.370     0.200
    40.370     1.286     0.200
    40.514     3.206     0.200
    40.514     3.432     0.200
    40.543     1.894     0.200
    40.686     2.624     0.200
    40.726     3.064     0.200
    40.994     2.915     0.200
    41.016     2.220     0.200
    41.028     0.033     0.200
    41.104     2.420     0.200
    41.145    -0.113     0.200
    41.150     3.596     0.200
    41.150    -0.410     0.200
    41.360     2.231     0.200
    41.360    -1.667     0.200
    41.342     2.878     0.200
    41.387     2.858     0.200
    41.693     3.055     0.200
    41.699     0.490     0.200
    41.699     2.860     0.200
    41.657     2.697     0.200
    42.021     0.754     0.200
    42.181     3.053     0.200
    42.181     0.013     0.200
    42.268    -0.311     0.200
    42.586     3.035     0.200
    42.586    -0.953     0.200
    42.780    -0.700     0.200
    43.309     3.139     0.200
    43.486     1.662     0.200
    43.566     3.005     0.200
    43.566    -0.237     0.200
    44.197     1.596     0.200
    45.208     4.668     0.200
    45.323     2.152     0.200
    45.323     3.957     0.200
    45.623     4.521     0.200
    45.673     2.183     0.200
    45.933     3.259     0.200
    46.084    -1.065     0.200
    46.082     0.091     0.200
    46.661     1.321     0.200
    47.239     2.054     0.200
    48.032     3.628     0.200
    48.032     1.153     0.200
    58.367     2.370     0.200
    64.138     1.712     0.200
    64.138     2.982     0.200
    64.721     3.283     0.200
    65.032     2.120     0.200
    65.320     1.684     0.200
    66.276     2.307     0.200
    66.862     1.408     0.200
    66.862     3.099     0.200
    66.999     2.596     0.200
    69.460     3.075     0.200
    69.765     2.615     0.200
    71.251     2.079     0.200
    71.302     3.314     0.200
    73.511     3.062     0.200
    75.145     4.011     0.200
    76.093     1.822     0.200
    76.116     2.783     0.200
    76.562     2.798     0.200
    78.311     1.168     0.200
    78.311     3.563     0.200
    78.393     3.438     0.200
    78.919     9.191     0.200
    78.919     1.266     0.200
    79.298     1.144     0.200
    81.377     2.401     0.200
    83.208     0.988     0.200
    84.598     3.531     0.200
    84.995     3.080     0.200
    85.081     1.415     0.200
    87.983     7.766     0.200
    88.582     9.648     0.200
    88.662    -0.354     0.200
    88.766     9.484     0.200
    88.846     9.396     0.200
    88.894    11.212     0.200
    89.563    -0.586     0.200
    89.649    10.463     0.200
    93.249     0.263     0.200
    94.154     2.217     0.200
    94.585     0.349     0.200
    97.542     1.666     0.200
    14.114     5.883     0.200
    14.803     4.459     0.200
    15.188     4.471     0.200
    15.524     3.405     0.200
    15.828     3.298     0.200
    15.926     3.097     0.200
    16.012     3.105     0.200
    16.178     3.572     0.200
    16.518     3.264     0.200
    16.574     3.192     0.200
    16.568     3.937     0.200
    16.575     3.172     0.200
    16.608     4.424     0.200
    16.618     2.859     0.200
    16.645     2.524     0.200
    16.686     2.458     0.200
    16.909     2.956     0.200
    16.909     2.966     0.200
    17.262     1.781     0.200
    17.269     2.667     0.200
    17.533     2.627     0.200
    17.581     2.672     0.200
    17.566     2.936     0.200
    17.627     2.775     0.200
    17.627     2.350     0.200
    17.855     2.891     0.200
    17.990     2.404     0.200
    18.149     3.270     0.200
    18.182     1.593     0.200
    18.182     2.049     0.200
    18.424     4.488     0.200
    19.069     2.737     0.200
    19.182     1.081     0.200
    19.497     1.517     0.200
    20.429     2.466     0.200
    21.179     2.513     0.200
    21.201     2.982     0.200
    21.249     2.565     0.200
    21.284     2.644     0.200
    21.352     2.096     0.200
    21.439     3.163     0.200
    21.515     2.835     0.200
    21.510     2.512     0.200
    21.559     3.129     0.200
    21.554     2.665     0.200
    21.651     3.065     0.200
    21.660     4.177     0.200
    21.725     2.359     0.200
    22.007     2.321     0.200
    22.036     3.125     0.200
    22.001     0.278     0.200
    22.505     2.559     0.200
    22.493     2.938     0.200
    22.578     3.068     0.200
    22.578     2.090     0.200
    22.572     3.374     0.200
    22.786     2.356     0.200
    22.786     1.888     0.200
    22.893     3.491     0.200
    22.893     1.411     0.200
    22.935     1.754     0.200
    22.935     1.338     0.200
    23.023     1.753     0.200
    23.023     1.640     0.200
    23.042     1.920     0.200
    23.158     2.990     0.200
    23.224     1.730     0.200
    23.261     1.835     0.200
    23.392     1.570     0.200
    23.430     2.824     0.200
    23.591     4.329     0.200
    23.955     2.545     0.200
    24.012     2.245     0.200
    24.081     3.400     0.200
    24.094     3.373     0.200
    24.225     2.107     0.200
    24.319     3.227     0.200
    24.319     3.082     0.200
    24.330     2.438     0.200
    24.330     1.861     0.200
    24.356     0.083     0.200
    24.342     2.985     0.200
    24.436     3.049     0.200
    24.436     1.276     0.200
    24.455     2.749     0.200
    24.583     3.757     0.200
    24.554     3.050     0.200
    24.903     2.406     0.200
    24.903     2.005     0.200
    25.193     3.419     0.200
    25.669     3.115     0.200
    25.732     1.649     0.200
    25.900     2.156     0.200
    25.925     2.165     0.200
    26.071     1.019     0.200
    26.129     1.948     0.200
    26.129     3.254     0.200
    26.699     2.291     0.200
    26.789     3.437     0.200
    26.822     3.261     0.200
    26.921     2.556     0.200
    26.911     2.589     0.200
    27.147     2.715     0.200
    27.354     2.194     0.200
    27.349     2.152     0.200
    27.349     2.318     0.200
    27.518     2.245     0.200
    27.670     2.988     0.200
    27.705     3.424     0.200
    27.828     3.544     0.200
    27.880     3.130     0.200
    27.880     1.792     0.200
    27.816     2.663     0.200
    28.103     3.426     0.200
    28.103     1.898     0.200
    28.607     2.779     0.200
    28.682     3.129     0.200
    28.682     0.534     0.200
    28.718     1.286     0.200
    28.909     2.861     0.200
    28.927     1.931     0.200
    29.064     2.706     0.200
    29.112     1.695     0.200
    29.255     3.136     0.200
    29.308     3.264     0.200
    29.308     0.897     0.200
    29.628     1.386     0.200
    29.725     0.783     0.200
    29.950     2.983     0.200
    29.950    -0.162     0.200
    30.246     2.434     0.200
    30.246     2.745     0.200
    30.686     2.289     0.200
    30.686     0.840     0.200
    31.015     2.831     0.200
    31.249     0.475     0.200
    31.736     1.231     0.200
    31.757     2.687     0.200
    32.177     3.105     0.200
    32.314     1.238     0.200
    32.314     3.024     0.200
    32.498     3.288     0.200
    32.591     2.547     0.200
    32.673     2.308     0.200
    32.880     1.653     0.200
    32.891     2.115     0.200
    33.088     2.834     0.200
    33.424     2.719     0.200
    33.735     1.958     0.200
    34.318     2.566     0.200
    34.318     0.953     0.200
    34.356     2.668     0.200
    34.453     3.404     0.200
    34.602     1.563     0.200
    34.611     2.595     0.200
    34.757     2.706     0.200
    34.891     1.968     0.200
    35.158     3.675     0.200
    35.617     2.812     0.200
    36.483     3.176     0.200
    36.518     4.426     0.200
    36.791     2.224     0.200
    36.824     1.387     0.200
    37.177     0.940     0.200
    37.327     0.835     0.200
    37.336     1.531     0.200
    37.336     1.317     0.200
    37.427     2.644     0.200
    37.776     2.919     0.200
    37.794     2.446     0.200
    38.130     1.905     0.200
    38.206     2.354     0.200
    38.200     2.790     0.200
    38.419     3.198     0.200
    38.443     2.513     0.200
    38.443     2.734     0.200
    38.452     2.942     0.200
    38.463     2.509     0.200
    38.463     2.023     0.200
    38.564     3.704     0.200
    38.667     2.511     0.200
    38.667     1.929     0.200
    38.695     2.377     0.200
    38.695     2.202     0.200
    38.760     1.952     0.200
    38.760     3.032     0.200
    38.809     2.640     0.200
    38.864     3.013     0.200
    38.843     2.276     0.200
    38.928     3.181     0.200
    38.930     3.570     0.200
    38.898     3.071     0.200
    39.111     3.416     0.200
    39.129     3.399     0.200
    39.129     2.852     0.200
    39.335     1.346     0.200
    39.546     1.884     0.200
    39.602     2.289     0.200
    39.790     0.990     0.200
    39.790     1.781     0.200
    39.853     3.553     0.200
    40.092     2.289     0.200
    40.122     1.765     0.200
    40.127     1.874     0.200
    40.127     2.334     0.200
    40.382     2.632     0.200
    40.494     3.567     0.200
    40.494     2.099     0.200
    40.497     3.121     0.200
    40.497     2.601     0.200
    40.511     2.136     0.200
    40.530     2.837     0.200
    40.527     2.297     0.200
    40.697     2.600     0.200
    40.738     1.751     0.200
    41.006     1.910     0.200
    41.028     1.742     0.200
    41.041     2.809     0.200
    41.148     2.444     0.200
    41.156     2.930     0.200
    41.161     2.565     0.200
    41.161     2.917     0.200
    41.325     3.294     0.200
    41.364     2.594     0.200
    41.373     3.169     0.200
    41.373     2.760     0.200
    41.527     2.714     0.200
    41.527     2.060     0.200
    41.687     0.580     0.200
    41.687     1.570     0.200
    41.705     1.868     0.200
    41.705     2.069     0.200
    42.033     2.372     0.200
    42.193     2.289     0.200
    42.193     2.155     0.200
    42.222     2.286     0.200
    42.272     1.374     0.200
    42.597     1.892     0.200
    42.596     3.107     0.200
    42.790     2.734     0.200
    42.790     2.207     0.200
    43.286     1.505     0.200
    43.498     1.994     0.200
    43.576     2.452     0.200
    43.576     1.128     0.200
    43.759     3.527     0.200
    44.174     1.380     0.200
    44.299     1.341     0.200
    44.443     2.796     0.200
    44.990     0.306     0.200
    45.186     1.806     0.200
    45.300     3.263     0.200
    45.300     3.578     0.200
    45.650    -0.175     0.200
    45.910     2.035     0.200
    46.061     2.011     0.200
    46.674     2.317     0.200
    47.251     1.760     0.200
    47.251     1.309     0.200
    47.628     4.050     0.200
    48.045     0.756     0.200
    49.049     1.630     0.200
    49.049     1.145     0.200
    51.048     1.093     0.200
    58.379     2.198     0.200
    64.118     0.976     0.200
    64.118     2.776     0.200
    64.702     2.502     0.200
    65.337     0.722     0.200
    65.337     1.261     0.200
    65.660     1.387     0.200
    65.883     2.359     0.200
    66.670     2.218     0.200
    66.877     1.272     0.200
    66.877     1.388     0.200
    66.981     2.918     0.200
    67.429     2.616     0.200
    67.906     2.762     0.200
    68.240     2.811     0.200
    68.240     1.646     0.200
    68.797    -1.189     0.200
    69.469     0.482     0.200
    69.747     2.199     0.200
    70.982     3.599     0.200
    71.284     2.755     0.200
    72.066     5.018     0.200
    73.494     3.734     0.200
    75.129     2.743     0.200
    76.002     4.437     0.200
    76.077     3.037     0.200
    76.100     3.309     0.200
    76.146     2.895     0.200
    76.547     3.322     0.200
    78.291     2.187     0.200
    78.912    -0.411     0.200
    81.362     3.439     0.200
    81.362     3.309     0.200
    83.203     0.960     0.200
    83.203     1.315     0.200
    83.414     3.586     0.200
    84.148     2.452     0.200
    84.430     1.626     0.200
    84.430     1.326     0.200
    85.066     0.710     0.200
    85.015     0.474     0.200
    85.528     2.113     0.200
    86.009     1.726     0.200
    86.550     3.061     0.200
    86.795     0.162     0.200
    88.652     0.147     0.200
    91.910     0.771     0.200
    93.243     0.607     0.200
    94.167     2.221     0.200
    94.167     2.575     0.200
    94.592     0.812     0.200
    94.592     2.154     0.200
    14.123     6.323     0.200
    14.167     7.939     0.200
    14.299     6.239     0.200
    14.398     7.129     0.200
    14.448     5.849     0.200
    14.647     7.820     0.200
    14.752     6.421     0.200
    15.132     7.377     0.200
    15.159     5.562     0.200
    15.142     6.770     0.200
    15.284     5.198     0.200
    15.322     6.832     0.200
    15.555     4.555     0.200
    15.511     6.482     0.200
    15.937     3.539     0.200
    16.363     5.499     0.200
    16.739     3.176     0.200
    17.237     3.118     0.200
    17.756     3.530     0.200
    17.756     3.155     0.200
    17.808     3.437     0.200
    17.808     3.070     0.200
    17.808     1.883     0.200
    17.824     2.808     0.200
    17.824     3.343     0.200
    18.190     1.763     0.200
    18.338     2.896     0.200
    18.972     1.604     0.200
    19.135     1.425     0.200
    19.197     1.044     0.200
    19.802     2.099     0.200
    20.275     1.061     0.200
    20.344     1.719     0.200
    20.344     2.203     0.200
    20.565     1.645     0.200
    20.670     1.636     0.200
    20.824     1.530     0.200
    20.934     1.207     0.200
    20.953     1.847     0.200
    21.225     1.455     0.200
    21.258     1.305     0.200
    21.439     2.241     0.200
    21.705     2.071     0.200
    21.795     2.271     0.200
    22.066     2.112     0.200
    22.140     2.303     0.200
    22.241     1.553     0.200
    22.248     2.125     0.200
    22.322     1.205     0.200
    22.373     1.718     0.200
    22.508     1.394     0.200
    22.508     1.886     0.200
    22.568     1.697     0.200
    22.568     1.900     0.200
    22.678     1.988     0.200
    22.678     2.172     0.200
    22.715     1.069     0.200
    22.715     2.108     0.200
    22.746     1.366     0.200
    22.906     1.320     0.200
    22.905     2.118     0.200
    22.989     1.401     0.200
    23.193     1.571     0.200
    23.224     2.464     0.200
    23.364     2.120     0.200
    23.652     1.403     0.200
    23.670     1.262     0.200
    23.707     1.580     0.200
    23.738     1.988     0.200
    23.785     1.985     0.200
    23.828     1.327     0.200
    23.881     2.289     0.200
    24.060     1.283     0.200
    24.060     1.935     0.200
    24.142     2.981     0.200
    24.201     2.126     0.200
    24.365     2.008     0.200
    24.380     2.003     0.200
    24.552     1.260     0.200
    24.552     1.721     0.200
    24.648     2.984     0.200
    24.889     1.875     0.200
    25.002     2.980     0.200
    25.092     1.430     0.200
    25.155     1.573     0.200
    25.169     1.442     0.200
    25.305     3.261     0.200
    25.468     2.560     0.200
    25.924     3.960     0.200
    25.924     4.093     0.200
    26.065    -0.119     0.200
    26.593     0.866     0.200
    26.706     1.987     0.200
    26.896     2.384     0.200
    27.089     1.260     0.200
    27.089     2.182     0.200
    27.591     2.097     0.200
    28.536     1.539     0.200
    29.039     2.299     0.200
    29.900     3.058     0.200
    30.992     0.581     0.200
    31.456     1.918     0.200
    32.196     1.752     0.200
    33.888     1.491     0.200
    34.028     2.431     0.200
    36.494     2.428     0.200
    36.857     2.509     0.200
    37.004     3.256     0.200
    37.086     0.381     0.200
    37.086     2.823     0.200
    37.600     2.784     0.200
    37.859     0.397     0.200
    37.859     0.983     0.200
    37.859     2.010     0.200
    38.062     0.493     0.200
    38.014     1.241     0.200
    38.094     2.324     0.200
    38.132     1.582     0.200
    38.335     2.297     0.200
    38.335     2.097     0.200
    38.342     2.531     0.200
    38.402     1.151     0.200
    38.429     2.361     0.200
    38.431     2.025     0.200
    38.498     2.050     0.200
    38.593     3.702     0.200
    38.593     3.807     0.200
    38.611     3.689     0.200
    38.807     2.114     0.200
    39.076     3.215     0.200
    39.214     2.287     0.200
    39.214     3.647     0.200
    39.217     0.987     0.200
    39.354     2.919     0.200
    39.427     2.789     0.200
    39.427     2.898     0.200
    39.770     2.543     0.200
    39.770     2.410     0.200
    39.792     2.368     0.200
    39.792     3.426     0.200
    39.792     3.254     0.200
    39.840     2.579     0.200
    39.906     3.153     0.200
    39.906     2.833     0.200
    40.063     2.082     0.200
    40.063     2.207     0.200
    40.215     2.394     0.200
    40.222     1.187     0.200
    40.222     1.785     0.200
    40.371     1.349     0.200
    40.371     2.244     0.200
    40.426     3.018     0.200
    40.426     0.999     0.200
    40.530     2.488     0.200
    40.585     1.366     0.200
    40.691     2.178     0.200
    40.691     2.662     0.200
    40.708     1.867     0.200
    40.751     1.862     0.200
    40.828     3.738     0.200
    40.828     2.441     0.200
    40.828     2.738     0.200
    40.841     1.608     0.200
    40.919     2.899     0.200
    41.047     2.164     0.200
    41.053     2.353     0.200
    41.069     2.573     0.200
    41.143     4.011     0.200
    41.202     3.034     0.200
    41.202     2.550     0.200
    41.246     2.114     0.200
    41.308     3.116     0.200
    41.330     2.058     0.200
    41.394     3.015     0.200
    41.394     2.745     0.200
    41.450     3.865     0.200
    41.709     3.031     0.200
    41.709     3.265     0.200
    41.821     2.986     0.200
    41.877     1.199     0.200
    41.877     1.957     0.200
    41.916     2.064     0.200
    41.927     2.118     0.200
    41.953     3.398     0.200
    41.997     2.611     0.200
    42.060     2.400     0.200
    42.273     2.056     0.200
    42.273     3.025     0.200
    42.531     3.550     0.200
    42.550     3.258     0.200
    42.780     2.890     0.200
    42.911     1.476     0.200
    43.018     2.161     0.200
    43.022     3.154     0.200
    43.221     3.279     0.200
    43.234     3.332     0.200
    43.516     3.031     0.200
    43.752     3.538     0.200
    43.766     3.233     0.200
    44.325     3.219     0.200
    45.407     1.793     0.200
    47.802     3.461     0.200
    48.054     0.124     0.200
    55.068     2.069     0.200
    61.104     0.818     0.200
    64.303     3.576     0.200
    66.144     2.474     0.200
    67.572     1.938     0.200
    69.980     1.808     0.200
    75.970     1.008     0.200
    75.970     1.739     0.200
    76.361     3.286     0.200
    78.528     2.114     0.200
    78.528     1.899     0.200
    78.476     1.675     0.200
    78.476     1.910     0.200
    81.672     3.041     0.200
    81.747     3.044     0.200
    82.069     2.454     0.200
    82.361     2.524     0.200
    82.703     2.540     0.200
    82.812     2.272     0.200
    82.812     1.760     0.200
    82.885     2.994     0.200
    83.037     2.254     0.200
    83.079     2.309     0.200
    83.129     3.582     0.200
    83.282     3.100     0.200
    83.399     2.529     0.200
    83.476     1.555     0.200
    83.611     4.150     0.200
    84.195     1.469     0.200
    84.744     2.063     0.200
    84.744     2.547     0.200
    86.177     1.944     0.200
    87.609     3.624     0.200
    88.159     2.351     0.200
    88.208     2.400     0.200
    88.282     0.786     0.200
    88.282     0.973     0.200
    88.391     3.601     0.200
    88.471     3.907     0.200
    89.259     1.906     0.200
    89.411     2.393     0.200
    89.929    -0.028     0.200
    90.285     1.066     0.200
    90.293     0.219     0.200
    90.391     1.071     0.200
    90.489     0.683     0.200
    92.857     1.451     0.200
    94.230     2.333     0.200
    97.279     0.544     0.200
    14.005     5.137     0.200
    14.391     4.785     0.200
    14.952     5.905     0.200
    15.959     4.072     0.200
    16.160     4.044     0.200
    16.307     4.513     0.200
    16.699     4.519     0.200
    16.893     4.844     0.200
    17.685     3.222     0.200
    18.214     1.658     0.200
    18.255     2.942     0.200
    18.179     2.440     0.200
    18.635     1.257     0.200
    18.734     1.214     0.200
    19.526     0.797     0.200
    19.583     0.017     0.200
    19.670     0.261     0.200
    19.898     2.225     0.200
    20.414     2.019     0.200
    20.464     1.311     0.200
    21.064     0.837     0.200
    21.209     1.094     0.200
    21.276     1.334     0.200
    21.335    -0.767     0.200
    21.525     3.397     0.200
    21.644     2.352     0.200
    21.648     2.448     0.200
    21.741     0.803     0.200
    22.029     1.050     0.200
    21.939     4.169     0.200
    22.041     1.000     0.200
    22.075     1.008     0.200
    22.568     1.871     0.200
    22.893     6.599     0.200
    23.096     3.076     0.200
    23.062     0.935     0.200
    23.251     1.828     0.200
    23.377     1.354     0.200
    23.593    -0.192     0.200
    23.879     1.217     0.200
    23.971     0.019     0.200
    24.057     0.320     0.200
    24.027     1.365     0.200
    24.116     3.060     0.200
    24.186     3.795     0.200
    24.246     3.413     0.200
    24.245     0.018     0.200
    24.347     3.642     0.200
    24.404     0.061     0.200
    24.404     1.835     0.200
    24.338     1.472     0.200
    24.464     2.836     0.200
    24.564     1.923     0.200
    24.583     1.725     0.200
    24.844     1.475     0.200
    24.941     0.222     0.200
    25.251     2.596     0.200
    25.199     3.334     0.200
    25.306     1.381     0.200
    26.131     3.090     0.200
    26.131     3.712     0.200
    26.126    -0.153     0.200
    26.126     2.542     0.200
    26.624     2.471     0.200
    26.857     0.338     0.200
    27.359     2.244     0.200
    27.832    -0.230     0.200
    27.956     0.445     0.200
    30.565     5.607     0.200
    31.210     2.657     0.200
    32.386     2.782     0.200
    39.865     5.160     0.200
    40.199     3.433     0.200
    42.740     3.452     0.200
    45.690     5.233     0.200
    58.458     4.042     0.200
    84.216     1.676     0.200
    94.244     5.275     0.200
    17.447     3.706     0.200
    23.661    -0.551     0.200
    31.565     2.199     0.200
    39.456     2.453     0.200
    14.095     6.162     0.200
    14.285     5.733     0.200
    14.703     5.939     0.200
    15.898     2.084     0.200
    16.569     4.028     0.200
    17.345     3.040     0.200
    17.345     3.869     0.200
    17.711     2.661     0.200
    17.986     2.620     0.200
    19.552     1.322     0.200
    19.558     1.598     0.200
    19.832     0.355     0.200
    19.859     1.624     0.200
    19.955     1.347     0.200
    20.157     2.279     0.200
    21.924     2.019     0.200
    22.198     1.787     0.200
    22.198     1.912     0.200
    22.245     1.999     0.200
    22.259     0.684     0.200
    22.282     0.911     0.200
    22.282     3.317     0.200
    22.446     3.682     0.200
    22.540     2.871     0.200
    22.540     3.293     0.200
    23.149     3.262     0.200
    23.596     1.026     0.200
    23.596     0.206     0.200
    23.845     2.478     0.200
    24.020     0.858     0.200
    24.020     2.452     0.200
    24.020     0.155     0.200
    24.025     1.263     0.200
    24.210     1.517     0.200
    24.210     2.384     0.200
    24.223     2.080     0.200
    24.275     0.996     0.200
    24.532     1.690     0.200
    24.580     0.869     0.200
    24.898     1.841     0.200
    25.020     1.511     0.200
    25.023     2.328     0.200
    25.086     2.161     0.200
    25.184     0.978     0.200
    25.244     1.046     0.200
    25.262     0.453     0.200
    25.262     3.633     0.200
    25.464     1.259     0.200
    25.452     1.733     0.200
    25.452     3.709     0.200
    25.560     0.917     0.200
    25.570     0.018     0.200
    25.799     1.114     0.200
    25.862     0.738     0.200
    25.962     1.127     0.200
    25.950     2.668     0.200
    26.024    -0.396     0.200
    26.018     1.658     0.200
    26.018     3.612     0.200
    26.087     3.345     0.200
    26.162     1.617     0.200
    26.162     3.328     0.200
    26.187     1.406     0.200
    26.249     2.559     0.200
    26.422     1.188     0.200
    26.481     0.837     0.200
    26.583     1.251     0.200
    26.707     1.743     0.200
    26.837     1.659     0.200
    26.889     1.434     0.200
    26.889     2.629     0.200
    27.234     2.829     0.200
    27.439     2.897     0.200
    27.582     1.326     0.200
    27.594     0.060     0.200
    27.877     1.975     0.200
    27.882     1.613     0.200
    28.190     1.992     0.200
    28.228     2.743     0.200
    28.368     2.601     0.200
    28.371     1.994     0.200
    28.556     3.002     0.200
    28.597    -0.268     0.200
    28.825     3.107     0.200
    28.855     1.617     0.200
    28.953    -0.026     0.200
    29.450     3.036     0.200
    29.454     3.514     0.200
    29.829     1.887     0.200
    29.858     2.022     0.200
    29.937     1.554     0.200
    30.489     1.150     0.200
    30.526     2.047     0.200
    30.668     2.782     0.200
    30.795     3.155     0.200
    30.872     2.902     0.200
    31.420     1.476     0.200
    31.468     2.035     0.200
    31.705     1.788     0.200
    31.781     3.031     0.200
    31.857     1.592     0.200
    32.405     2.104     0.200
    32.579     2.395     0.200
    32.637    -0.041     0.200
    32.637     3.209     0.200
    32.665     2.109     0.200
    32.806     3.603     0.200
    33.069     2.217     0.200
    33.243     2.260     0.200
    33.448     1.919     0.200
    33.453     2.983     0.200
    33.574     2.805     0.200
    33.805     2.687     0.200
    33.784     2.489     0.200
    33.883     2.657     0.200
    33.913     3.300     0.200
    34.283     3.961     0.200
    34.283     2.397     0.200
    34.496     2.455     0.200
    34.582     3.158     0.200
    34.739     3.000     0.200
    34.855     2.083     0.200
    35.093     3.171     0.200
    35.173     2.685     0.200
    35.223     2.919     0.200
    35.532     0.699     0.200
    35.532     3.887     0.200
    35.701     1.660     0.200
    35.779     3.110     0.200
    35.967     3.526     0.200
    35.990     2.536     0.200
    35.990     0.997     0.200
    36.054     0.040     0.200
    36.054     3.571     0.200
    36.283     1.982     0.200
    36.283     4.052     0.200
    36.423     0.196     0.200
    36.423     3.133     0.200
    36.425     1.316     0.200
    36.443     1.735     0.200
    36.443     3.337     0.200
    36.551     1.453     0.200
    36.561     1.164     0.200
    36.561     3.086     0.200
    36.638     1.154     0.200
    36.638     2.396     0.200
    36.839     1.429     0.200
    36.839     2.569     0.200
    37.006     1.312     0.200
    37.006     3.765     0.200
    37.062     0.324     0.200
    37.164     3.055     0.200
    37.314     3.174     0.200
    37.314     3.255     0.200
    37.361     0.899     0.200
    37.361     4.305     0.200
    37.549     1.073     0.200
    37.549     2.042     0.200
    37.594     1.238     0.200
    37.594     2.738     0.200
    37.657     3.257     0.200
    37.675     3.502     0.200
    37.675     4.213     0.200
    37.705     1.375     0.200
    37.705     2.938     0.200
    37.776     1.925     0.200
    37.871     2.510     0.200
    37.881     2.779     0.200
    37.887     1.026     0.200
    37.887     2.322     0.200
    37.904     3.552     0.200
    38.005     1.665     0.200
    38.005     2.228     0.200
    38.071     1.224     0.200
    38.071     3.568     0.200
    38.103     0.803     0.200
    38.129     0.472     0.200
    38.129     2.535     0.200
    38.149     1.337     0.200
    38.149     2.236     0.200
    38.178     1.948     0.200
    38.233     2.268     0.200
    38.305     1.601     0.200
    38.333     3.732     0.200
    38.372     0.648     0.200
    38.372     3.640     0.200
    38.388     2.795     0.200
    38.438     1.822     0.200
    38.619     2.895     0.200
    38.625     2.013     0.200
    38.627     2.737     0.200
    38.629     3.121     0.200
    38.675     3.741     0.200
    38.762     3.397     0.200
    38.764     1.596     0.200
    38.772     2.615     0.200
    38.772     3.365     0.200
    38.904     3.210     0.200
    38.968     1.176     0.200
    38.968     2.465     0.200
    39.056     2.549     0.200
    39.123     1.490     0.200
    39.123     1.209     0.200
    39.223     0.258     0.200
    39.223     1.508     0.200
    39.239     0.456     0.200
    39.335     0.943     0.200
    39.335     1.685     0.200
    39.340     0.770     0.200
    39.351     0.639     0.200
    39.351     0.920     0.200
    39.351     1.475     0.200
    39.389     1.500     0.200
    39.389     1.367     0.200
    39.440     2.686     0.200
    39.461     1.759     0.200
    39.461     3.571     0.200
    39.533     1.488     0.200
    39.616     2.810     0.200
    39.631     1.041     0.200
    39.631     2.142     0.200
    39.647     2.790     0.200
    39.725     3.618     0.200
    39.758     3.575     0.200
    39.799     3.121     0.200
    39.799     2.750     0.200
    39.844     3.394     0.200
    39.934     1.991     0.200
    39.998     3.183     0.200
    40.037     2.499     0.200
    40.084     2.780     0.200
    40.261     2.653     0.200
    40.274     2.037     0.200
    40.317     2.835     0.200
    40.321     3.376     0.200
    40.338     3.352     0.200
    40.358     0.575     0.200
    40.358     2.685     0.200
    40.385    -0.207     0.200
    40.385     2.637     0.200
    40.389     1.858     0.200
    40.417     1.705     0.200
    40.460     3.473     0.200
    40.466     0.625     0.200
    40.466     2.352     0.200
    40.522     3.640     0.200
    40.603     1.474     0.200
    40.615     2.773     0.200
    40.648     0.022     0.200
    40.648     3.303     0.200
    40.693     4.109     0.200
    40.700     2.985     0.200
    40.765     0.803     0.200
    40.765     3.014     0.200
    40.803     2.890     0.200
    40.835     0.834     0.200
    40.835     3.349     0.200
    40.842     2.563     0.200
    40.863     2.241     0.200
    40.966     0.177     0.200
    40.966     2.810     0.200
    41.001     4.398     0.200
    41.005     1.337     0.200
    41.180     3.576     0.200
    41.272     1.085     0.200
    41.272     3.335     0.200
    41.341     0.557     0.200
    41.341     2.862     0.200
    41.371     0.637     0.200
    41.371     3.926     0.200
    41.412     0.257     0.200
    41.412     3.296     0.200
    41.433     0.344     0.200
    41.433     2.562     0.200
    41.447    -0.456     0.200
    41.447     2.153     0.200
    41.485     3.160     0.200
    41.489     3.029     0.200
    41.492     2.916     0.200
    41.514     3.652     0.200
    41.518     3.802     0.200
    41.550     3.727     0.200
    41.617     3.293     0.200
    41.835    -0.986     0.200
    41.835     3.554     0.200
    41.835     2.040     0.200
    41.835     3.657     0.200
    41.893     0.252     0.200
    41.893     3.056     0.200
    41.912     0.030     0.200
    41.912     3.226     0.200
    41.997     3.224     0.200
    42.011    -0.455     0.200
    42.011     3.147     0.200
    42.038     0.334     0.200
    42.038     2.896     0.200
    42.040     3.177     0.200
    42.103     1.155     0.200
    42.103     4.053     0.200
    42.206     3.026     0.200
    42.308     0.508     0.200
    42.308     1.570     0.200
    42.343     2.305     0.200
    42.353    -0.894     0.200
    42.353     2.278     0.200
    42.401     4.046     0.200
    42.444     3.085     0.200
    42.460    -1.270     0.200
    42.460     3.113     0.200
    42.569     3.553     0.200
    42.786     0.444     0.200
    42.786     2.632     0.200
    42.946     0.402     0.200
    42.946     2.769     0.200
    42.998     0.181     0.200
    42.998     3.064     0.200
    43.011     2.969     0.200
    43.075     0.098     0.200
    43.075     3.098     0.200
    43.304     2.887     0.200
    43.315     2.867     0.200
    43.478     2.587     0.200
    43.503     2.908     0.200
    43.505     3.084     0.200
    43.562     1.325     0.200
    43.562     2.036     0.200
    43.572     2.873     0.200
    43.606     1.291     0.200
    43.606     1.674     0.200
    43.619     2.502     0.200
    43.796     3.224     0.200
    43.803     2.656     0.200
    43.875     0.837     0.200
    43.875     2.408     0.200
    43.890     0.749     0.200
    43.890     2.554     0.200
    43.977     0.351     0.200
    43.977     1.726     0.200
    43.982     1.349     0.200
    44.163    -0.306     0.200
    44.163     2.584     0.200
    44.321     0.900     0.200
    44.321     3.025     0.200
    44.360     2.151     0.200
    44.444     3.235     0.200
    44.516     2.957     0.200
    44.520     3.144     0.200
    44.562     3.666     0.200
    44.685     3.153     0.200
    44.736     3.113     0.200
    44.708     2.282     0.200
    44.835     3.381     0.200
    44.834     3.111     0.200
    44.932     2.306     0.200
    44.932     0.775     0.200
    44.932     2.728     0.200
    45.104     0.211     0.200
    45.104     2.501     0.200
    45.169     0.283     0.200
    45.169     2.314     0.200
    45.171     1.119     0.200
    45.171     2.932     0.200
    45.416     0.442     0.200
    45.416     2.575     0.200
    45.585     2.697     0.200
    45.672     2.798     0.200
    45.628     2.380     0.200
    45.628     0.709     0.200
    45.695     1.862     0.200
    45.740     1.404     0.200
    45.740     3.302     0.200
    45.755     3.056     0.200
    45.812     3.249     0.200
    45.845     2.681     0.200
    45.948     2.739     0.200
    45.950     0.587     0.200
    45.950     2.977     0.200
    46.104     1.459     0.200
    46.104     3.170     0.200
    46.216     2.138     0.200
    46.373     2.247     0.200
    46.387     2.893     0.200
    46.490     2.894     0.200
    46.660     1.805     0.200
    46.762     2.511     0.200
    46.774     2.198     0.200
    46.969     2.046     0.200
    47.313     1.705     0.200
    47.406     1.175     0.200
    47.406     2.644     0.200
    48.054     2.197     0.200
    48.215     1.415     0.200
    48.215     2.407     0.200
    49.850     0.440     0.200
    54.168    -0.125     0.200
    55.889     0.789     0.200
    56.443     0.331     0.200
    56.443     2.159     0.200
    57.641     3.597     0.200
    61.310    -1.061     0.200
    61.310     1.001     0.200
    66.200     1.842     0.200
    68.495     1.558     0.200
    68.678    -0.148     0.200
    75.834     1.444     0.200
    78.116     1.872     0.200
    78.652     0.669     0.200
    78.794    -0.092     0.200
    79.623     0.605     0.200
    82.381     1.050     0.200
    82.525     2.089     0.200
    82.764     3.734     0.200
    82.968     2.577     0.200
    83.190     2.697     0.200
    83.687     3.299     0.200
    83.830     0.661     0.200
    84.190     3.284     0.200
    84.234     1.309     0.200
    84.262     3.354     0.200
    84.293     2.802     0.200
    84.447     1.420     0.200
    84.516     1.992     0.200
    85.791     1.537     0.200
    92.393     3.370     0.200
    92.439     0.283     0.200
    93.429     0.968     0.200
    15.352     4.674     0.200
    15.496     5.497     0.200
    15.515     3.611     0.200
    16.898     3.817     0.200
    17.406     2.789     0.200
    17.459     2.201     0.200
    18.884     0.789     0.200
    19.099     0.755     0.200
    19.446     1.185     0.200
    19.975     1.040     0.200
    20.167     1.036     0.200
    20.381     0.360     0.200
    20.965     0.983     0.200
    21.973     0.625     0.200
    22.265     0.868     0.200
    22.265     2.212     0.200
    22.250     1.599     0.200
    23.742     0.889     0.200
    30.644     0.223     0.200
    30.644     3.387     0.200
    31.538     2.331     0.200
    31.577     2.032     0.200
    31.899     0.496     0.200
    32.697     0.803     0.200
    32.856     2.849     0.200
    34.856     2.971     0.200
    35.211     2.955     0.200
    35.291     0.852     0.200
    35.649     3.150     0.200
    36.172     1.875     0.200
    36.400     2.284     0.200
    36.755     2.689     0.200
    36.957     0.446     0.200
    36.957     1.422     0.200
    37.479     3.084     0.200
    37.793     3.706     0.200
    37.822     3.729     0.200
    37.987     2.648     0.200
    37.999     2.650     0.200
    38.004     0.753     0.200
    38.104     1.640     0.200
    38.189     2.026     0.200
    38.246     2.847     0.200
    38.296     3.068     0.200
    38.743     1.581     0.200
    38.744     2.203     0.200
    38.879     1.352     0.200
    38.877     0.727     0.200
    38.890     2.831     0.200
    39.084    -0.121     0.200
    39.452     3.038     0.200
    39.469     1.538     0.200
    39.507     3.021     0.200
    39.733     2.803     0.200
    39.749     3.865     0.200
    39.876     3.016     0.200
    39.961     2.791     0.200
    40.116     2.182     0.200
    40.155     2.999     0.200
    40.202     2.794     0.200
    40.378     2.801     0.200
    40.435     1.381     0.200
    40.475     2.778     0.200
    40.503     2.785     0.200
    40.507     1.528     0.200
    40.534     1.958     0.200
    40.576     1.347     0.200
    40.583     1.935     0.200
    40.640     2.985     0.200
    40.765     3.848     0.200
    40.811     4.238     0.200
    40.816     4.478     0.200
    40.883     2.366     0.200
    40.952     2.801     0.200
    41.084     2.784     0.200
    41.119     1.497     0.200
    41.297     2.119     0.200
    41.390     1.082     0.200
    41.457     3.203     0.200
    41.488     1.278     0.200
    41.530     2.143     0.200
    41.546     0.428     0.200
    41.565     1.925     0.200
    41.598     1.366     0.200
    41.632     2.126     0.200
    41.668     2.327     0.200
    41.735     1.909     0.200
    41.953     2.329     0.200
    42.010     1.918     0.200
    42.129     2.249     0.200
    42.155     2.127     0.200
    42.157     1.295     0.200
    42.220     2.524     0.200
    42.321     2.994     0.200
    42.426     2.329     0.200
    42.470     2.970     0.200
    42.518     3.987     0.200
    42.562     2.674     0.200
    42.577     4.191     0.200
    42.686     3.134     0.200
    42.697     2.090     0.200
    42.761     1.716     0.200
    42.904     3.006     0.200
    43.063     1.231     0.200
    43.116     1.452     0.200
    43.128     2.929     0.200
    43.332     0.848     0.200
    43.422     1.224     0.200
    43.432     1.855     0.200
    43.595     0.629     0.200
    43.620     1.251     0.200
    43.623     0.400     0.200
    43.680     0.601     0.200
    43.724     0.809     0.200
    43.914     0.580     0.200
    43.993     1.000     0.200
    44.094     0.388     0.200
    44.100     1.221     0.200
    44.281     1.848     0.200
    44.439    -0.266     0.200
    44.633     2.263     0.200
    44.637     2.918     0.200
    44.680     1.409     0.200
    44.853     1.633     0.200
    44.917     2.660     0.200
    44.952     1.823     0.200
    45.050     1.600     0.200
    45.222     2.256     0.200
    45.287     1.185     0.200
    45.289     1.194     0.200
    45.534     1.182     0.200
    45.790     1.602     0.200
    45.872     2.004     0.200
    46.068     0.533     0.200
    46.334     0.742     0.200
    46.505     1.795     0.200
    46.778     2.017     0.200
    46.880     1.774     0.200
    46.892     0.102     0.200
    47.087     0.507     0.200
    47.431     2.639     0.200
    47.524     2.404     0.200
    15.997     2.352     0.200
    16.553     3.948     0.200
    16.615     2.617     0.200
    17.094     5.366     0.200
    17.094     4.462     0.200
    17.739     2.244     0.200
    18.725    -1.384     0.200
    18.823     1.383     0.200
    20.015     0.902     0.200
    20.015     1.940     0.200
    20.060     1.173     0.200
    20.141     1.883     0.200
    20.281     1.305     0.200
    20.545     0.523     0.200
    21.172     1.775     0.200
    21.234     1.561     0.200
    21.820     1.171     0.200
    22.054     0.892     0.200
    22.054     1.280     0.200
    22.054     3.052     0.200
    22.240    -0.606     0.200
    22.375    -1.027     0.200
    22.553     1.708     0.200
    22.553     0.353     0.200
    22.553     3.758     0.200
    23.198     2.467     0.200
    23.325    -0.127     0.200
    23.439     0.912     0.200
    23.724     1.989     0.200
    23.811     2.079     0.200
    24.010     1.534     0.200
    24.087     0.174     0.200
    24.087     3.143     0.200
    24.307     1.546     0.200
    25.042     0.325     0.200
    25.042     2.914     0.200
    25.146     2.606     0.200
    25.232     2.855     0.200
    25.431     2.671     0.200
    25.819    -1.161     0.200
    26.029     2.163     0.200
    26.130     4.080     0.200
    26.226     3.606     0.200
    26.448     2.985     0.200
    26.789     2.023     0.200
    26.863     1.657     0.200
    26.863     1.422     0.200
    26.972     3.000     0.200
    27.420     2.455     0.200
    27.816     2.403     0.200
    28.107     2.002     0.200
    28.204     2.043     0.200
    28.561     1.728     0.200
    28.790     3.004     0.200
    28.902    -0.053     0.200
    29.019     3.675     0.200
    29.176     2.547     0.200
    29.189     3.049     0.200
    29.596     3.254     0.200
    29.675     5.111     0.200
    30.172     3.033     0.200
    30.228     4.034     0.200
    30.266     2.700     0.200
    30.308     3.192     0.200
    30.770     3.380     0.200
    31.159     1.897     0.200
    31.444     2.395     0.200
    31.832     3.625     0.200
    32.319    -0.636     0.200
    32.368     1.930     0.200
    32.376    -0.190     0.200
    32.404    -1.351     0.200
    32.808    -2.234     0.200
    32.981    -0.541     0.200
    33.189     1.300     0.200
    33.307     1.789     0.200
    33.314     0.518     0.200
    33.544     2.872     0.200
    33.590    -0.591     0.200
    33.621    -0.213     0.200
    33.652     0.164     0.200
    33.810    -2.478     0.200
    34.234    -1.393     0.200
    34.320     0.171     0.200
    34.593     1.407     0.200
    34.831     3.650     0.200
    34.911     3.294     0.200
    34.961     0.244     0.200
    35.042     3.543     0.200
    35.270     1.697     0.200
    35.393     2.778     0.200
    35.462     2.199     0.200
    35.559     3.191     0.200
    35.729     1.810     0.200
    35.792     1.507     0.200
    35.792     0.518     0.200
    36.161     0.145     0.200
    36.181     2.141     0.200
    36.290     1.796     0.200
    36.300     1.294     0.200
    36.376     0.373     0.200
    36.555     0.153     0.200
    36.579    -0.045     0.200
    36.593     0.178     0.200
    36.744     1.294     0.200
    36.902     1.684     0.200
    37.052    -0.698     0.200
    37.058     2.522     0.200
    37.100     4.553     0.200
    37.147     1.660     0.200
    37.147     3.900     0.200
    37.199     0.296     0.200
    37.270     2.284     0.200
    37.288     1.498     0.200
    37.338     1.855     0.200
    37.395     1.291     0.200
    37.414     3.587     0.200
    37.414     3.104     0.200
    37.443     1.356     0.200
    37.443     2.909     0.200
    37.518    -1.370     0.200
    37.628     3.048     0.200
    37.631     2.025     0.200
    37.631     1.252     0.200
    37.642     0.112     0.200
    37.810     2.263     0.200
    37.810     4.129     0.200
    37.844     1.942     0.200
    37.869     1.537     0.200
    37.887     2.846     0.200
    37.916     1.713     0.200
    37.988     4.426     0.200
    38.046     1.495     0.200
    38.071     0.620     0.200
    38.111     4.793     0.200
    38.128     3.704     0.200
    38.177     2.701     0.200
    38.285     5.041     0.200
    38.358     3.881     0.200
    38.364     4.010     0.200
    38.367     3.814     0.200
    38.368     2.808     0.200
    38.372     1.810     0.200
    38.415     3.048     0.200
    38.504     0.649     0.200
    38.513     3.037     0.200
    38.510     4.874     0.200
    38.643     3.169     0.200
    38.712     4.327     0.200
    38.723     1.064     0.200
    38.729     4.994     0.200
    38.796     3.874     0.200
    38.861     3.659     0.200
    38.945     3.814     0.200
    38.962     2.544     0.200
    38.982     3.092     0.200
    39.073     1.657     0.200
    39.089     1.512     0.200
    39.089     0.532     0.200
    39.089     3.872     0.200
    39.129     1.107     0.200
    39.182     1.418     0.200
    39.200     1.579     0.200
    39.388     3.129     0.200
    39.496     1.341     0.200
    39.538     1.723     0.200
    39.539     3.485     0.200
    39.585     2.758     0.200
    39.627     3.514     0.200
    39.648     1.824     0.200
    39.672    -0.014     0.200
    39.823     3.260     0.200
    40.012     0.272     0.200
    40.056     0.902     0.200
    40.078     0.134     0.200
    40.099    -0.607     0.200
    40.123    -0.477     0.200
    40.127     0.366     0.200
    40.156     0.065     0.200
    40.206     2.381     0.200
    40.202    -0.241     0.200
    40.260     0.702     0.200
    40.270     0.331     0.200
    40.387     1.293     0.200
    40.439     1.319     0.200
    40.503     3.404     0.200
    40.545     2.717     0.200
    40.576     2.691     0.200
    40.601     3.238     0.200
    40.705     2.886     0.200
    40.740     1.478     0.200
    40.921     3.711     0.200
    41.081     1.718     0.200
    41.152    -0.346     0.200
    41.185    -1.641     0.200
    41.252    -0.081     0.200
    41.260     1.343     0.200
    41.289    -0.147     0.200
    41.356     1.459     0.200
    41.574     1.146     0.200
    41.576     0.685     0.200
    41.631    -0.013     0.200
    41.650     1.178     0.200
    41.738     1.346     0.200
    41.749     4.198     0.200
    41.776     0.819     0.200
    41.779     3.258     0.200
    41.817    -0.242     0.200
    41.841     2.267     0.200
    41.941     1.500     0.200
    41.949     0.155     0.200
    42.048     0.028     0.200
    42.081     0.986     0.200
    42.093     1.283     0.200
    42.139     1.452     0.200
    42.199     1.806     0.200
    42.216     4.627     0.200
    42.309     2.502     0.200
    42.317     2.642     0.200
    42.388     1.499     0.200
    42.492     2.311     0.200
    42.516     2.996     0.200
    42.525     1.570     0.200
    42.676     3.145     0.200
    42.685     1.406     0.200
    42.736     0.261     0.200
    42.749     2.674     0.200
    42.816     2.447     0.200
    42.956     0.051     0.200
    43.043    -1.029     0.200
    43.219     1.796     0.200
    43.243     1.695     0.200
    43.242    -0.010     0.200
    43.300     3.630     0.200
    43.326     0.740     0.200
    43.340     1.309     0.200
    43.344     0.668     0.200
    43.360     0.869     0.200
    43.535     4.511     0.200
    43.542     1.591     0.200
    43.614     2.306     0.200
    43.628     1.428     0.200
    43.715     3.129     0.200
    43.901     1.077     0.200
    44.059     3.264     0.200
    44.182     2.952     0.200
    44.254     1.118     0.200
    44.261     2.748     0.200
    44.300     2.209     0.200
    44.423     2.614     0.200
    44.450     2.457     0.200
    44.475     2.365     0.200
    44.572     0.596     0.200
    44.671     2.280     0.200
    44.843     0.707     0.200
    44.907     1.820     0.200
    44.909     1.483     0.200
    45.154     2.182     0.200
    45.324    -0.101     0.200
    45.410     3.373     0.200
    45.517     1.809     0.200
    45.688     3.011     0.200
    45.842     3.018     0.200
    45.917     3.659     0.200
    45.917     5.309     0.200
    45.954     3.510     0.200
    45.992     3.901     0.200
    46.035     3.750     0.200
    46.112     2.432     0.200
    46.125     2.358     0.200
    46.228     2.153     0.200
    46.399     2.624     0.200
    46.500     1.314     0.200
    46.512     3.707     0.200
    46.636     2.235     0.200
    48.081     3.251     0.200
    48.382     1.978     0.200
    48.382     4.128     0.200
    55.093     0.623     0.200
    55.593     1.707     0.200
    58.238    -0.738     0.200
    61.429     1.337     0.200
    61.599     0.208     0.200
    63.217     1.245     0.200
    68.049     1.603     0.200
    75.316    -0.185     0.200
    76.005     2.149     0.200
    77.936     0.201     0.200
    78.399     0.412     0.200
    78.399     2.108     0.200
    79.442    -0.351     0.200
    82.182     0.485     0.200
    82.182     0.880     0.200
    82.178     2.180     0.200
    83.034     3.220     0.200
    83.530     2.623     0.200
    83.582     1.444     0.200
    83.582     1.814     0.200
    83.582     2.344     0.200
    84.284     1.606     0.200
    84.354     1.394     0.200
    84.354     0.378     0.200
    86.478     0.234     0.200
    87.757     1.605     0.200
    90.270     2.389     0.200
    92.136     1.163     0.200
    92.253     1.967     0.200
    93.168     2.863     0.200
    93.514     0.806     0.200
    93.514     2.106     0.200
    96.619     2.111     0.200
    17.160     3.483     0.200
    20.069    -0.901     0.200
    20.866    -0.026     0.200
    21.862     1.224     0.200
    22.410     0.888     0.200
    23.344     1.464     0.200
    39.153     2.810     0.200
    40.407    -0.726     0.200
    40.448    -0.294     0.200
    40.767     0.335     0.200
    41.141     1.118     0.200
    41.213     0.638     0.200
    41.693     1.366     0.200
    41.838     0.611     0.200
    77.993     0.640     0.200
    82.243     1.434     0.200
    17.651     4.412     0.200
    39.670     2.934     0.200
    18.137     3.638     0.200
    40.179     4.413     0.200
    16.855     1.209     0.200
    18.180     3.013     0.200
    19.456    -0.195     0.200
    19.799    -0.673     0.200
    21.959    -0.127     0.200
    22.900     0.620     0.200
    24.324     0.735     0.200
    24.324     1.618     0.200
    28.164    -0.136     0.200
    32.308     2.174     0.200
    40.135     2.550     0.200
    41.174    -1.046     0.200
    42.270    -2.836     0.200
    85.022     3.327     0.200
    15.374     3.137     0.200
    16.213     1.749     0.200
    22.652     1.315     0.200
    23.948     0.919     0.200
    24.195     2.464     0.200
    24.269     1.079     0.200
    25.104     1.849     0.200
    25.348     0.556     0.200
    40.162     2.533     0.200
    41.578     2.586     0.200
    97.626    -1.333     0.200
    17.772     3.535     0.200
    18.252     1.814     0.200
    19.696     0.404     0.200
    39.783     3.672     0.200
    78.445     0.946     0.200
    97.292     1.194     0.200
    14.619     9.096     0.200
    14.633     8.240     0.200
    14.670     6.404     0.200
    15.819     2.465     0.200
    16.868     3.707     0.200
    17.089     5.105     0.200
    17.698     4.269     0.200
    17.698     5.027     0.200
    17.730     3.376     0.200
    18.220     3.577     0.200
    18.875     0.450     0.200
    19.029     0.198     0.200
    19.271     2.283     0.200
    20.178     1.128     0.200
    20.433     1.020     0.200
    20.540    -0.736     0.200
    20.725     1.383     0.200
    20.846     0.364     0.200
    21.099     0.545     0.200
    21.087     4.067     0.200
    21.136     1.397     0.200
    21.335     8.309     0.200
    21.426     0.890     0.200
    21.888    10.795     0.200
    22.114     0.257     0.200
    22.154     3.490     0.200
    22.154    10.592     0.200
    22.196    10.922     0.200
    22.437     0.663     0.200
    22.437     3.905     0.200
    22.579     0.458     0.200
    22.579     3.904     0.200
    22.594     0.971     0.200
    22.544     3.575     0.200
    23.139     0.439     0.200
    23.215     1.249     0.200
    23.823     1.079     0.200
    23.851     0.863     0.200
    23.851     2.308     0.200
    23.909     0.235     0.200
    24.048     2.007     0.200
    24.089     1.357     0.200
    24.089     3.764     0.200
    24.092     1.618     0.200
    24.288     1.147     0.200
    24.423     1.295     0.200
    24.423     1.756     0.200
    24.683     2.486     0.200
    25.069     1.686     0.200
    25.210     0.698     0.200
    25.549    -0.319     0.200
    25.549     3.868     0.200
    25.577     1.970     0.200
    25.828     1.288     0.200
    26.017     2.194     0.200
    26.084     1.721     0.200
    26.084     3.338     0.200
    26.496     1.195     0.200
    26.500     1.535     0.200
    26.979     1.977     0.200
    27.587     3.177     0.200
    27.603     2.714     0.200
    27.941     2.671     0.200
    28.198     2.491     0.200
    28.588     3.035     0.200
    28.721     2.706     0.200
    28.724     3.614     0.200
    29.157     2.983     0.200
    29.562     1.085     0.200
    29.635     2.966     0.200
    29.728     1.975     0.200
    29.805     1.821     0.200
    29.805     2.540     0.200
    30.184     3.206     0.200
    30.209     3.566     0.200
    30.289     2.316     0.200
    30.844     2.281     0.200
    30.882     3.181     0.200
    30.923     3.086     0.200
    31.024     0.797     0.200
    31.217     0.611     0.200
    31.775     3.158     0.200
    31.813     3.158     0.200
    32.060     2.454     0.200
    32.134     2.351     0.200
    32.213     2.310     0.200
    32.935     2.182     0.200
    32.992     2.830     0.200
    33.018     2.540     0.200
    33.095     2.922     0.200
    33.160     2.872     0.200
    33.424     1.492     0.200
    33.594     1.499     0.200
    33.804     1.445     0.200
    33.806     1.903     0.200
    33.883     2.495     0.200
    33.923     1.996     0.200
    33.930     1.789     0.200
    34.160     1.670     0.200
    34.203     1.110     0.200
    34.237     0.675     0.200
    34.255     1.410     0.200
    34.268     1.677     0.200
    34.684     2.463     0.200
    34.847     1.668     0.200
    34.935     2.148     0.200
    34.930     2.773     0.200
    35.526     1.227     0.200
    35.571     1.549     0.200
    35.886     1.194     0.200
    36.133     1.498     0.200
    36.340     1.615     0.200
    36.407     2.501     0.200
    36.482     2.527     0.200
    36.638     1.573     0.200
    36.638     2.237     0.200
    36.774     2.090     0.200
    36.772     1.725     0.200
    36.796     1.920     0.200
    36.905     1.825     0.200
    36.915     1.912     0.200
    36.998     2.350     0.200
    37.166     2.082     0.200
    37.195     1.305     0.200
    37.203     1.590     0.200
    37.259     2.996     0.200
    37.359     2.240     0.200
    37.516     2.195     0.200
    37.659     1.593     0.200
    37.665     2.051     0.200
    37.666     0.859     0.200
    37.716     1.762     0.200
    37.763     2.541     0.200
    37.793    -0.000     0.200
    37.861     1.596     0.200
    37.899     1.551     0.200
    37.990     1.340     0.200
    37.941     1.420     0.200
    38.009    -0.057     0.200
    38.001     0.357     0.200
    38.019     0.187     0.200
    38.053     2.446     0.200
    38.053     0.540     0.200
    38.116     2.673     0.200
    38.227     2.271     0.200
    38.237     2.754     0.200
    38.243     2.020     0.200
    38.243     3.309     0.200
    38.247     2.243     0.200
    38.247     2.891     0.200
    38.253     1.129     0.200
    38.330     1.785     0.200
    38.343     1.726     0.200
    38.352     2.051     0.200
    38.419     2.039     0.200
    38.425     2.698     0.200
    38.485     2.051     0.200
    38.503     2.533     0.200
    38.588     2.140     0.200
    38.580     2.145     0.200
    38.660     2.036     0.200
    38.685     1.850     0.200
    38.793     2.055     0.200
    38.840     1.778     0.200
    38.966     1.991     0.200
    38.983     1.961     0.200
    38.974     2.336     0.200
    38.984     2.503     0.200
    38.942     7.570     0.200
    39.016     2.337     0.200
    39.115     1.966     0.200
    39.118     1.836     0.200
    39.118     2.015     0.200
    39.125     2.283     0.200
    39.259     2.147     0.200
    39.324     0.772     0.200
    39.324     2.459     0.200
    39.324     5.022     0.200
    39.339     1.604     0.200
    39.334     1.772     0.200
    39.401     0.952     0.200
    39.476     0.681     0.200
    39.570     1.818     0.200
    39.575     1.761     0.200
    39.686     1.145     0.200
    39.704     1.778     0.200
    39.704     2.372     0.200
    39.704     4.028     0.200
    39.745     1.675     0.200
    39.763     1.401     0.200
    39.779     1.068     0.200
    39.816     1.861     0.200
    39.816     0.892     0.200
    39.981     2.156     0.200
    39.987     1.511     0.200
    40.078     2.511     0.200
    40.111     2.552     0.200
    40.106     1.871     0.200
    40.142     2.291     0.200
    40.145     2.396     0.200
    40.198     2.012     0.200
    40.244     2.082     0.200
    40.286     2.270     0.200
    40.286     1.911     0.200
    40.347     2.002     0.200
    40.347     2.502     0.200
    40.392     3.021     0.200
    40.439     2.457     0.200
    40.610     1.370     0.200
    40.610     2.143     0.200
    40.625     2.023     0.200
    40.648     1.869     0.200
    40.662     1.929     0.200
    40.680     2.280     0.200
    40.714     1.162     0.200
    40.739     1.657     0.200
    40.741     1.637     0.200
    40.764     1.360     0.200
    40.799     1.983     0.200
    40.822     0.505     0.200
    40.822     2.083     0.200
    40.842     2.326     0.200
    40.877     2.209     0.200
    40.898     1.489     0.200
    40.959     2.384     0.200
    40.965     2.127     0.200
    40.993     1.574     0.200
    41.048     3.332     0.200
    41.043     2.031     0.200
    41.176     1.353     0.200
    41.179     2.044     0.200
    41.212     3.238     0.200
    41.217     2.204     0.200
    41.242     2.100     0.200
    41.314     2.233     0.200
    41.356     2.983     0.200
    41.536     2.199     0.200
    41.536     2.387     0.200
    41.624     2.097     0.200
    41.683     0.995     0.200
    41.726     2.402     0.200
    41.757     2.234     0.200
    41.739     1.944     0.200
    41.785     1.869     0.200
    41.785     1.643     0.200
    41.796     2.210     0.200
    41.824     2.263     0.200
    41.839     2.521     0.200
    41.858     2.846     0.200
    41.866     2.084     0.200
    41.905     1.876     0.200
    41.971     2.484     0.200
    41.971     2.179     0.200
    42.176     2.533     0.200
    42.187     2.071     0.200
    42.241     1.749     0.200
    42.262     1.968     0.200
    42.335     1.785     0.200
    42.365     2.290     0.200
    42.365     1.485     0.200
    42.385     2.088     0.200
    42.383     1.420     0.200
    42.432     2.021     0.200
    42.457     1.129     0.200
    42.541     0.446     0.200
    42.557     0.363     0.200
    42.653     1.068     0.200
    42.695     0.853     0.200
    42.815     2.450     0.200
    42.815     0.763     0.200
    42.814     0.400     0.200
    42.925     1.439     0.200
    42.932     0.796     0.200
    43.103     1.037     0.200
    43.132     1.232     0.200
    43.141     0.764     0.200
    43.283     0.705     0.200
    43.301     0.918     0.200
    43.351     0.942     0.200
    43.413     0.275     0.200
    43.425     0.876     0.200
    43.556     0.989     0.200
    43.659     1.212     0.200
    43.670     1.204     0.200
    43.821     1.579     0.200
    43.848     0.692     0.200
    43.854     1.007     0.200
    43.885     1.982     0.200
    43.913     0.658     0.200
    43.934     0.942     0.200
    43.959     1.441     0.200
    43.959     1.277     0.200
    44.151     1.799     0.200
    44.151     1.643     0.200
    44.149     1.244     0.200
    44.231     1.065     0.200
    44.244     1.878     0.200
    44.325     1.684     0.200
    44.332     1.449     0.200
    44.515     2.411     0.200
    44.515     0.865     0.200
    44.674     1.420     0.200
    44.797     2.094     0.200
    44.865     1.095     0.200
    44.916     0.490     0.200
    45.036     0.969     0.200
    45.050     1.011     0.200
    45.083     1.211     0.200
    45.188     0.829     0.200
    45.287     0.579     0.200
    45.396     2.064     0.200
    45.396     5.174     0.200
    45.452     0.512     0.200
    45.425     2.298     0.200
    45.425     6.102     0.200
    45.522     2.084     0.200
    45.522     0.819     0.200
    45.726     2.514     0.200
    45.767     0.943     0.200
    45.932    -0.059     0.200
    45.937     2.355     0.200
    46.023     0.827     0.200
    46.095     1.249     0.200
    46.078     2.575     0.200
    46.452     1.170     0.200
    46.522     2.984     0.200
    46.569     0.565     0.200
    46.739     1.257     0.200
    46.841     1.257     0.200
    46.813     2.829     0.200
    47.007     1.389     0.200
    47.115     0.776     0.200
    47.323     1.100     0.200
    47.660     1.722     0.200
    47.758     1.338     0.200
    48.031     1.459     0.200
    48.031     2.819     0.200
    50.747     1.954     0.200
    50.747     4.844     0.200
    54.482    -1.181     0.200
    56.735     2.308     0.200
    56.735     3.152     0.200
    57.988     2.636     0.200
    58.882     3.175     0.200
    60.925    10.534     0.200
    63.530    -7.717     0.200
    64.332     4.027     0.200
    64.937     3.504     0.200
    65.055     3.077     0.200
    65.583     2.044     0.200
    65.904     3.270     0.200
    66.501     2.474     0.200
    69.033     2.193     0.200
    69.993     3.280     0.200
    75.430     3.281     0.200
    75.842     3.143     0.200
    76.200     3.028     0.200
    77.283     1.365     0.200
    78.396     2.278     0.200
    78.506     3.063     0.200
    78.506     3.228     0.200
    79.005     2.534     0.200
    79.005     3.050     0.200
    79.904     1.578     0.200
    81.714     3.536     0.200
    81.714     3.083     0.200
    82.682     1.604     0.200
    82.682     0.455     0.200
    82.682     2.971     0.200
    84.146     3.834     0.200
    84.620     3.958     0.200
    84.803     2.987     0.200
    85.701     6.413     0.200
    90.078     0.746     0.200
    90.398    -0.152     0.200
    92.725     2.832     0.200
    92.729    -5.645     0.200
    92.729    -2.348     0.200
    93.777     4.179     0.200
    94.126     3.692     0.200
    97.213     2.453     0.200
    16.254     4.932     0.200
    16.590     4.230     0.200
    16.879     2.074     0.200
    16.879     4.028     0.200
    17.719     1.864     0.200
    17.806     1.550     0.200
    38.854     0.922     0.200
    82.029     1.077     0.200
    96.380    -1.895     0.200
    15.931     7.428     0.200
    16.341     5.063     0.200
    16.316     4.666     0.200
    16.688     2.393     0.200
    17.891     0.027     0.200
    18.292     2.150     0.200
    18.507     2.782     0.200
    18.883    -0.676     0.200
    21.433     2.199     0.200
    21.703     1.166     0.200
    21.740     5.086     0.200
    22.079     2.090     0.200
    22.113     2.360     0.200
    22.572     2.142     0.200
    22.910     1.970     0.200
    23.366     2.288     0.200
    23.362     2.710     0.200
    24.562     2.974     0.200
    24.849     3.831     0.200
    25.284     3.880     0.200
    38.776     2.764     0.200
    39.002     2.621     0.200
    40.457     2.397     0.200
    41.071     1.027     0.200
    41.705     1.563     0.200
    41.861     0.300     0.200
    41.865     0.943     0.200
    41.994     1.623     0.200
    42.464     1.054     0.200
    42.526     0.737     0.200
    42.966     1.025     0.200
    43.103     0.771     0.200
    43.361     1.072     0.200
    44.556     0.827     0.200
    45.358     3.334     0.200
    72.164     3.625     0.200
    72.473     3.110     0.200
    72.544     4.979     0.200
    85.202     0.221     0.200
    15.564     4.000     0.200
    15.908     1.634     0.200
    40.502     2.951     0.200
    17.127     3.949     0.200
    39.139     1.561     0.200
    17.568     4.657     0.200
    39.565     4.162     0.200
    97.072    -1.202     0.200
    14.235     5.530     0.200
    14.360     5.679     0.200
    14.591     5.806     0.200
    14.618     8.091     0.200
    14.966     7.154     0.200
    15.871     2.127     0.200
    16.123     5.282     0.200
    16.361     2.218     0.200
    16.473     2.536     0.200
    17.610     2.554     0.200
    19.005     2.486     0.200
    22.399     2.462     0.200
    22.602     0.787     0.200
    23.807     3.150     0.200
    25.487     1.890     0.200
    31.731     4.285     0.200
    39.233     3.818     0.200
    39.608     3.896     0.200
    97.114    -1.133     0.200
    14.594     4.632     0.200
    15.070     3.944     0.200
    15.801     3.277     0.200
    16.680     2.836     0.200
    16.680     2.987     0.200
    16.953     4.427     0.200
    17.810     2.970     0.200
    18.220     2.333     0.200
    18.381     3.863     0.200
    18.410     1.867     0.200
    18.445    -0.186     0.200
    18.475    -0.097     0.200
    18.519    -1.218     0.200
    18.520    -0.940     0.200
    18.568     2.199     0.200
    18.615     0.641     0.200
    18.588    -0.427     0.200
    19.074    -0.009     0.200
    19.075    -0.022     0.200
    19.095     1.370     0.200
    19.178     0.955     0.200
    19.242     0.107     0.200
    19.316    -0.047     0.200
    20.137     2.320     0.200
    20.440    -2.632     0.200
    21.330     4.248     0.200
    21.365     3.432     0.200
    21.751     3.770     0.200
    21.751     3.771     0.200
    21.833     1.556     0.200
    21.948     2.632     0.200
    22.251     4.864     0.200
    22.597     3.536     0.200
    22.764     1.410     0.200
    22.764     2.480     0.200
    23.011     3.089     0.200
    23.011     2.755     0.200
    23.195     0.058     0.200
    23.195    -0.392     0.200
    23.383     2.345     0.200
    23.462     1.103     0.200
    23.800     0.399     0.200
    23.903     0.939     0.200
    23.903     1.259     0.200
    24.018     2.235     0.200
    24.017     2.031     0.200
    24.017     1.781     0.200
    24.531     2.748     0.200
    24.719     1.121     0.200
    24.719     1.481     0.200
    25.215     1.673     0.200
    25.452     1.299     0.200
    25.509     3.471     0.200
    26.069     2.184     0.200
    26.536     2.982     0.200
    26.552     3.106     0.200
    27.148     3.323     0.200
    27.148     2.844     0.200
    27.538     3.152     0.200
    27.671     2.833     0.200
    27.673     2.952     0.200
    28.190     2.712     0.200
    28.585     3.398     0.200
    28.669     3.951     0.200
    28.757     3.405     0.200
    29.152     2.269     0.200
    29.159     2.788     0.200
    29.239     2.796     0.200
    29.794     3.023     0.200
    29.832     3.915     0.200
    29.833     3.368     0.200
    29.873     3.235     0.200
    29.980     2.233     0.200
    30.174     2.761     0.200
    30.369     2.303     0.200
    30.523     4.563     0.200
    30.725     2.871     0.200
    30.829     1.408     0.200
    30.829     1.239     0.200
    31.011     2.750     0.200
    31.084     3.561     0.200
    31.084     2.965     0.200
    31.173     2.531     0.200
    31.886     3.054     0.200
    31.942     3.009     0.200
    32.072     2.690     0.200
    32.109     3.255     0.200
    32.373     3.373     0.200
    32.756     2.762     0.200
    32.832     3.581     0.200
    32.873     2.965     0.200
    33.112     3.030     0.200
    33.154     3.284     0.200
    33.186     3.652     0.200
    33.217     3.436     0.200
    33.586     4.094     0.200
    33.634     3.850     0.200
    33.798     4.059     0.200
    33.885     4.054     0.200
    34.044     2.939     0.200
    34.157     3.365     0.200
    34.236     3.582     0.200
    34.415     5.529     0.200
    34.397     3.254     0.200
    34.475     3.470     0.200
    34.606     3.337     0.200
    34.661     3.136     0.200
    34.837     3.402     0.200
    34.957     3.495     0.200
    35.026     3.551     0.200
    35.082     3.308     0.200
    35.274     3.386     0.200
    35.292     3.306     0.200
    35.356     3.883     0.200
    35.591     3.703     0.200
    35.725     3.855     0.200
    35.729     3.724     0.200
    35.745     3.635     0.200
    35.854     2.812     0.200
    35.864     3.236     0.200
    35.943     3.152     0.200
    35.949     3.486     0.200
    36.118     2.930     0.200
    36.149     2.923     0.200
    36.157     3.034     0.200
    36.217     2.921     0.200
    36.309     3.271     0.200
    36.364     3.758     0.200
    36.466     3.551     0.200
    36.616     3.702     0.200
    36.618     2.901     0.200
    36.715     2.238     0.200
    36.767     3.196     0.200
    36.840     4.205     0.200
    36.840     2.846     0.200
    36.851     3.342     0.200
    36.948     2.759     0.200
    36.903     3.743     0.200
    36.959     3.122     0.200
    36.972     3.226     0.200
    36.986     3.750     0.200
    37.007     3.448     0.200
    37.085     3.076     0.200
    37.186     2.634     0.200
    37.188     2.642     0.200
    37.196     3.128     0.200
    37.199     2.343     0.200
    37.206     3.090     0.200
    37.293     1.965     0.200
    37.293     3.063     0.200
    37.308     2.982     0.200
    37.374     3.768     0.200
    37.374     3.188     0.200
    37.418     3.156     0.200
    37.480     3.295     0.200
    37.550     2.449     0.200
    37.618     1.643     0.200
    37.635     3.155     0.200
    37.674     2.865     0.200
    37.692     1.589     0.200
    37.744     2.538     0.200
    37.810     2.136     0.200
    37.849     2.842     0.200
    37.927     2.848     0.200
    37.934     2.754     0.200
    37.982     3.272     0.200
    38.074     3.363     0.200
    38.077     2.649     0.200
    38.102     1.914     0.200
    38.210     2.697     0.200
    38.287     2.322     0.200
    38.287     2.447     0.200
    38.293     2.813     0.200
    38.307     2.340     0.200
    38.360     2.701     0.200
    38.360     2.705     0.200
    38.426     2.268     0.200
    38.515     2.096     0.200
    38.526     2.590     0.200
    38.552     3.009     0.200
    38.636     3.023     0.200
    38.654     2.518     0.200
    38.727     2.449     0.200
    38.749     1.986     0.200
    38.765     3.023     0.200
    38.926     2.486     0.200
    38.933     2.809     0.200
    38.955     2.437     0.200
    39.027     2.538     0.200
    39.027     1.838     0.200
    39.027     2.157     0.200
    39.061     2.814     0.200
    39.089     2.869     0.200
    39.094     2.650     0.200
    39.102     2.900     0.200
    39.104     2.438     0.200
    39.158     2.948     0.200
    39.207     3.072     0.200
    39.216     2.079     0.200
    39.236     2.802     0.200
    39.300     3.342     0.200
    39.343     3.370     0.200
    39.576     2.466     0.200
    39.644     2.415     0.200
    39.688     2.904     0.200
    39.691     2.797     0.200
    39.769     2.517     0.200
    39.776     2.967     0.200
    39.848     2.257     0.200
    39.873     2.052     0.200
    39.910     3.268     0.200
    39.917     2.428     0.200
    39.951     2.981     0.200
    40.000     3.603     0.200
    40.004     2.367     0.200
    40.067     2.920     0.200
    40.117     2.829     0.200
    40.142     2.622     0.200
    40.151     2.386     0.200
    40.167     3.021     0.200
    40.268     2.521     0.200
    40.307     3.708     0.200
    40.493     3.114     0.200
    40.574     2.747     0.200
    40.646     2.834     0.200
    40.678     3.568     0.200
    40.708     1.267     0.200
    40.708    -0.243     0.200
    40.716     2.723     0.200
    40.773     2.482     0.200
    40.801     2.132     0.200
    40.816     2.676     0.200
    40.816     2.976     0.200
    40.826     2.935     0.200
    40.921     2.913     0.200
    41.137     2.613     0.200
    41.142     3.016     0.200
    41.195     2.487     0.200
    41.306     2.574     0.200
    41.314     3.234     0.200
    41.340     2.250     0.200
    41.344     2.470     0.200
    41.387     3.276     0.200
    41.408     3.682     0.200
    41.518     3.698     0.200
    41.612     2.053     0.200
    41.645     2.412     0.200
    41.659     2.797     0.200
    41.705     3.642     0.200
    41.746     2.486     0.200
    41.768     3.131     0.200
    41.783     2.105     0.200
    41.879     3.396     0.200
    41.881     2.700     0.200
    41.957     1.638     0.200
    42.058     3.380     0.200
    42.027     0.974     0.200
    42.055     2.573     0.200
    42.091     3.250     0.200
    42.252     2.924     0.200
    42.301     2.801     0.200
    42.375     2.915     0.200
    42.384     2.083     0.200
    42.517     4.545     0.200
    42.522     1.978     0.200
    42.609     3.570     0.200
    42.622     2.455     0.200
    42.784     2.325     0.200
    42.806     2.093     0.200
    42.807     2.065     0.200
    42.864     1.876     0.200
    42.908     1.607     0.200
    42.912     2.051     0.200
    42.908     2.342     0.200
    42.927     1.839     0.200
    42.997     0.868     0.200
    43.100     3.137     0.200
    43.106     1.957     0.200
    43.182     2.434     0.200
    43.194     2.314     0.200
    43.279     2.168     0.200
    43.284     1.956     0.200
    43.357     3.941     0.200
    43.418     2.649     0.200
    43.465     2.195     0.200
    43.624     2.539     0.200
    43.746     2.676     0.200
    43.818     2.502     0.200
    43.826     2.268     0.200
    43.866     3.141     0.200
    44.017     1.803     0.200
    44.039     2.603     0.200
    44.103     2.632     0.200
    44.137     2.165     0.200
    44.182     2.127     0.200
    44.244     4.507     0.200
    44.238     2.393     0.200
    44.244     1.905     0.200
    44.406     2.681     0.200
    44.472     2.265     0.200
    44.473     2.502     0.200
    44.663     3.357     0.200
    44.718     2.252     0.200
    44.887     2.467     0.200
    44.973     2.357     0.200
    45.045     2.941     0.200
    45.146     4.207     0.200
    45.252     2.340     0.200
    45.252     2.540     0.200
    45.297     1.822     0.200
    45.406     2.648     0.200
    45.498     4.221     0.200
    45.518     1.984     0.200
    45.597     2.297     0.200
    45.597     2.177     0.200
    45.679     2.185     0.200
    45.689     1.991     0.200
    45.791     1.995     0.200
    45.881     3.293     0.200
    45.895     4.378     0.200
    45.953     3.423     0.200
    45.963     2.394     0.200
    46.076     2.155     0.200
    46.168     4.152     0.200
    46.236     5.996     0.200
    46.283     3.321     0.200
    46.296     4.084     0.200
    46.296     3.804     0.200
    46.296     0.664     0.200
    46.272     2.557     0.200
    46.471     4.251     0.200
    46.578     5.204     0.200
    46.610     2.439     0.200
    46.610     2.659     0.200
    46.616     1.958     0.200
    46.708     2.139     0.200
    47.057     3.464     0.200
    47.155    -1.805     0.200
    47.646     1.919     0.200
    48.687     2.932     0.200
    48.935     5.826     0.200
    49.650     0.573     0.200
    49.650     1.863     0.200
    50.815     0.805     0.200
    50.815     1.885     0.200
    51.116    -0.123     0.200
    51.198     0.104     0.200
    51.198     1.763     0.200
    53.618     0.580     0.200
    55.946     1.233     0.200
    55.946     0.633     0.200
    55.946     1.873     0.200
    56.943     2.788     0.200
    56.941     2.252     0.200
    56.941     2.641     0.200
    58.538     1.337     0.200
    58.538     0.377     0.200
    58.930     0.419     0.200
    59.380     4.732     0.200
    60.019     1.565     0.200
    60.769    -0.055     0.200
    60.769     0.584     0.200
    61.756     0.362     0.200
    61.756     0.713     0.200
    63.555    -0.138     0.200
    63.647     2.252     0.200
    64.075     2.338     0.200
    64.075     1.613     0.200
    64.075     1.397     0.200
    65.248     2.576     0.200
    65.248     1.296     0.200
    65.248     2.066     0.200
    65.338     1.924     0.200
    65.502     1.536     0.200
    65.502    -0.044     0.200
    65.512     1.970     0.200
    65.512     0.960     0.200
    65.512     2.270     0.200
    65.512     2.130     0.200
    65.573     0.482     0.200
    65.876     3.620     0.200
    65.876     0.980     0.200
    66.389     0.636     0.200
    66.661    -0.613     0.200
    66.666    -0.462     0.200
    67.984    -0.204     0.200
    67.984     0.806     0.200
    67.984     0.667     0.200
    68.310     1.242     0.200
    68.413     0.725     0.200
    70.108     0.923     0.200
    70.346     1.596     0.200
    70.838     0.527     0.200
    70.838     2.298     0.200
    73.371    -0.188     0.200
    73.371     1.292     0.200
    73.457     2.881     0.200
    73.459     1.969     0.200
    73.629     1.712     0.200
    74.481     2.294     0.200
    74.806     2.129     0.200
    74.974     1.287     0.200
    74.974     0.727     0.200
    75.319     2.451     0.200
    75.377     2.817     0.200
    75.377     0.248     0.200
    75.377     0.517     0.200
    75.377     1.967     0.200
    75.546     2.065     0.200
    75.853     2.158     0.200
    76.068     1.672     0.200
    76.384     2.467     0.200
    76.607     1.947     0.200
    76.607     2.157     0.200
    76.935     0.072     0.200
    76.937     2.143     0.200
    76.937     0.043     0.200
    76.935     1.353     0.200
    77.209     0.434     0.200
    77.552     2.932     0.200
    77.648     2.056     0.200
    77.648     0.531     0.200
    77.890     3.649     0.200
    77.981     0.599     0.200
    77.981     0.139     0.200
    77.981     0.799     0.200
    78.045     2.404     0.200
    78.081     2.648     0.200
    78.160     0.610     0.200
    78.715     2.404     0.200
    79.144     2.907     0.200
    79.152     0.675     0.200
    79.228     2.309     0.200
    79.228     0.919     0.200
    79.421     1.694     0.200
    79.421     1.548     0.200
    79.421     0.114     0.200
    79.421     2.054     0.200
    79.565     1.491     0.200
    79.749     1.195     0.200
    79.954     3.411     0.200
    80.208     2.012     0.200
    80.274     2.437     0.200
    80.493     2.364     0.200
    81.726     2.643     0.200
    81.754     1.757     0.200
    81.748     0.999     0.200
    81.862     0.647     0.200
    81.862     1.446     0.200
    81.862     0.726     0.200
    81.907     2.063     0.200
    81.981     0.071     0.200
    82.744     4.335     0.200
    82.744     1.205     0.200
    83.164     2.658     0.200
    83.485     1.074     0.200
    83.701     2.003     0.200
    83.785     2.676     0.200
    83.891     1.759     0.200
    83.891    -0.059     0.200
    83.892     2.067     0.200
    83.892    -0.172     0.200
    83.892     1.927     0.200
    84.215     1.433     0.200
    84.242     1.682     0.200
    84.242     2.742     0.200
    84.277     1.656     0.200
    84.423     1.673     0.200
    84.558     3.183     0.200
    84.558     1.123     0.200
    84.699     1.472     0.200
    85.381     2.452     0.200
    85.395     1.979     0.200
    85.480    -0.333     0.200
    85.480     0.607     0.200
    86.045    -0.898     0.200
    86.045     0.262     0.200
    86.198     3.738     0.200
    87.027     0.033     0.200
    88.253     1.396     0.200
    88.404     4.185     0.200
    89.087     2.425     0.200
    89.412     1.903     0.200
    89.709     2.311     0.200
    89.709     2.211     0.200
    89.860     2.656     0.200
    89.860     0.646     0.200
    90.072     3.819     0.200
    90.470     1.981     0.200
    90.470     0.743     0.200
    90.470     3.163     0.200
    90.470     2.773     0.200
    91.326     2.683     0.200
    91.697     1.966     0.200
    91.706     2.526     0.200
    91.956     0.341     0.200
    91.956     1.966     0.200
    91.956     2.167     0.200
    92.079     1.092     0.200
    92.079     1.697     0.200
    92.457     0.122     0.200
    92.457     3.852     0.200
    92.457     2.762     0.200
    92.482    -2.163     0.200
    92.731     1.824     0.200
    92.937     0.837     0.200
    93.090     1.279     0.200
    93.302     2.953     0.200
    94.555    -1.607     0.200
    95.527     1.270     0.200
    95.527     2.850     0.200
    95.545     1.118     0.200
    96.188    -0.660     0.200
    96.655     2.721     0.200
    97.052     0.722     0.200
    97.143    -0.089     0.200
    14.997     3.683     0.200
    15.178     5.540     0.200
    15.507     2.374     0.200
    15.801     2.748     0.200
    16.642     4.267     0.200
    18.527     1.282     0.200
    20.509     1.448     0.200
    21.531     0.736     0.200
    21.729     2.158     0.200
    22.132     1.963     0.200
    22.574     2.791     0.200
    22.917     3.422     0.200
    24.594     2.315     0.200
    24.594     1.136     0.200
    40.475     2.595     0.200
    41.183     2.204     0.200
    41.380     2.758     0.200
    41.880     2.311     0.200
    42.634     2.115     0.200
    43.121     2.715     0.200
    43.458     1.446     0.200
    43.540     1.504     0.200
    94.517     1.764     0.200
    15.964     6.218     0.200
    16.388     3.770     0.200
    17.871     1.762     0.200
    18.697     0.038     0.200
    19.299     0.904     0.200
    19.419     1.026     0.200
    19.642     0.773     0.200
    19.642     1.850     0.200
    20.129    -0.063     0.200
    20.164    -0.194     0.200
    20.201     0.329     0.200
    20.436     0.410     0.200
    20.667     1.271     0.200
    21.207    -1.523     0.200
    21.460     0.436     0.200
    21.667     0.698     0.200
    21.732     0.752     0.200
    22.052     0.437     0.200
    22.290     1.104     0.200
    22.453     0.209     0.200
    22.765     3.669     0.200
    22.778    -0.038     0.200
    23.072     1.063     0.200
    23.161    -1.281     0.200
    23.161     1.607     0.200
    23.500     1.380     0.200
    23.810     1.244     0.200
    24.023     1.023     0.200
    24.355     3.916     0.200
    24.397     0.010     0.200
    24.613     1.693     0.200
    24.613     0.291     0.200
    25.129     0.709     0.200
    25.654    -0.364     0.200
    25.981     1.416     0.200
    26.148     2.992     0.200
    26.246     2.428     0.200
    26.440     4.435     0.200
    27.301     0.866     0.200
    27.942     0.276     0.200
    29.157     0.919     0.200
    32.798     1.538     0.200
    32.862     1.768     0.200
    33.552     0.968     0.200
    33.599     6.780     0.200
    40.693     0.923     0.200
    42.782     0.658     0.200
    43.679     1.145     0.200
    46.059     4.522     0.200
    47.063     1.328     0.200
    51.603     2.282     0.200
    57.383     0.961     0.200
    58.257     0.568     0.200
    65.922     1.478     0.200
    67.465     0.368     0.200
    67.465     3.068     0.200
    70.030     0.649     0.200
    70.030     2.775     0.200
    83.689    -0.749     0.200
    84.187     3.133     0.200
    85.150     1.370     0.200
    86.796     1.399     0.200
    94.748     1.738     0.200
    95.888     1.454     0.200
    98.144    -0.170     0.200
    40.459     1.664     0.200
    14.323     8.372     0.200
    14.638     6.507     0.200
    15.806     2.607     0.200
    17.664     3.689     0.200
    19.654     0.009     0.200
    21.294     1.239     0.200
    22.112     0.794     0.200
    22.164     0.568     0.200
    22.402     1.465     0.200
    22.556    -1.525     0.200
    23.120     1.476     0.200
    23.760     3.381     0.200
    23.814     2.847     0.200
    24.370     2.098     0.200
    24.945     3.066     0.200
    24.973     2.681     0.200
    31.778     4.464     0.200
    36.876     0.605     0.200
    39.097     2.747     0.200
    39.658     1.873     0.200
    39.676     3.236     0.200
    39.715     1.535     0.200
    39.954     2.763     0.200
    40.120     1.900     0.200
    40.583     1.650     0.200
    40.597     1.983     0.200
    40.637     3.014     0.200
    40.655     2.314     0.200
    40.738     2.081     0.200
    40.929     3.118     0.200
    42.667     1.861     0.200
    65.036     1.823     0.200
    75.805     0.910     0.200
    78.519     2.317     0.200
    78.519     1.837     0.200
    82.645     2.380     0.200
    84.587     2.269     0.200
    84.790     1.103     0.200
    92.688     1.814     0.200
    94.094     2.225     0.200
    21.381     0.350     0.200
    40.668     4.157     0.200
    68.397     3.933     0.200
    79.082     2.345     0.200
    84.990     1.821     0.200
    17.981     2.762     0.200
    18.192     2.175     0.200
    21.388    -0.342     0.200
    21.807     1.697     0.200
    21.908     1.360     0.200
    22.306     1.569     0.200
    22.632     1.928     0.200
    23.336     1.839     0.200
    23.427     2.301     0.200
    24.250     1.368     0.200
    24.489     1.303     0.200
    24.547     1.293     0.200
    24.877     0.483     0.200
    40.672     0.947     0.200
    43.661     1.805     0.200
    56.336     2.190     0.200
    56.336     2.440     0.200
    65.953     1.803     0.200
    85.007     0.313     0.200
    18.631     0.068     0.200
    24.498     0.868     0.200
    40.654     3.080     0.200
    15.572     4.465     0.200
    16.228     4.950     0.200
    22.622     5.760     0.200
    24.452     3.792     0.200
    40.609     5.735     0.200
    15.603     3.026     0.200
    16.419     4.093     0.200
    17.554     1.746     0.200
    17.767     2.035     0.200
    17.843     3.259     0.200
    18.025     2.177     0.200
    18.237     2.254     0.200
    18.604    -0.984     0.200
    18.724     1.167     0.200
    19.300     1.572     0.200
    20.318     1.678     0.200
    20.602    -0.221     0.200
    21.082     0.540     0.200
    21.452     1.198     0.200
    21.438     1.933     0.200
    21.613     1.224     0.200
    21.842     1.205     0.200
    21.930     1.360     0.200
    22.321     1.325     0.200
    22.658     1.839     0.200
    22.747     2.258     0.200
    23.035     1.397     0.200
    23.396    -0.826     0.200
    24.187     1.889     0.200
    24.488     2.725     0.200
    24.488     0.745     0.200
    25.003     0.775     0.200
    25.121     2.079     0.200
    32.696     3.313     0.200
    40.623     0.594     0.200
    40.623     4.727     0.200
    40.623     0.516     0.200
    85.027     3.050     0.200
    40.582     3.602     0.200
    40.595     3.259     0.200
    24.459     3.636     0.200
    40.651     3.903     0.200
    40.578     0.708     0.200
    16.010     2.725     0.200
    16.516     2.211     0.200
    40.572     4.467     0.200
    20.530    -0.403     0.200
    21.593    -0.084     0.200
    23.321     0.395     0.200
    24.384     2.414     0.200
    40.583     4.555     0.200
    43.574    -0.138     0.200
    44.111     0.242     0.200
    69.908     0.275     0.200
    72.371     1.200     0.200
    40.543     4.744     0.200
    15.479     4.298     0.200
    15.582     2.658     0.200
    15.529     2.393     0.200
    40.621     1.359     0.200
    98.112    -1.388     0.200
    15.534     3.289     0.200
    16.239     3.667     0.200
    16.323     2.412     0.200
    16.354     2.158     0.200
    16.640     1.894     0.200
    16.917     2.073     0.200
    17.495     1.984     0.200
    17.704     1.919     0.200
    17.704     3.620     0.200
    17.797     2.064     0.200
    17.960     1.643     0.200
    18.172     1.605     0.200
    18.310     1.083     0.200
    18.619     0.928     0.200
    20.609     0.526     0.200
    20.659     0.695     0.200
    21.378     2.030     0.200
    21.390     1.236     0.200
    21.457     2.051     0.200
    21.560     1.707     0.200
    21.667     0.528     0.200
    21.881     1.429     0.200
    22.133     1.626     0.200
    22.128     1.534     0.200
    22.282     2.118     0.200
    22.597     3.181     0.200
    22.597     4.533     0.200
    22.606     1.709     0.200
    22.615     1.776     0.200
    23.004     2.200     0.200
    23.046     1.048     0.200
    23.313     2.254     0.200
    23.401     0.000     0.200
    23.650     1.899     0.200
    24.132     1.187     0.200
    24.226     1.791     0.200
    24.290     1.042     0.200
    24.460     0.705     0.200
    24.460     0.051     0.200
    25.522     1.655     0.200
    27.130     1.398     0.200
    28.630     1.638     0.200
    39.196     0.483     0.200
    40.259     1.667     0.200
    40.259     0.148     0.200
    40.654     2.340     0.200
    40.654     0.778     0.200
    41.906     1.415     0.200
    43.136     0.691     0.200
    43.187     1.008     0.200
    43.376     0.123     0.200
    43.644     1.765     0.200
    44.640     1.636     0.200
    44.640     5.184     0.200
    44.701     1.770     0.200
    44.701     1.315     0.200
    45.623     1.506     0.200
    58.933     1.747     0.200
    60.358     1.372     0.200
    65.269     4.077     0.200
    66.830     1.674     0.200
    68.868     1.971     0.200
    70.402     4.984     0.200
    72.895     1.150     0.200
    72.895     2.910     0.200
    74.528     1.668     0.200
    77.771     2.295     0.200
    77.771     1.725     0.200
    78.402     2.330     0.200
    79.069     3.049     0.200
    80.782     0.831     0.200
    80.782     1.751     0.200
    82.182     1.966     0.200
    82.182     3.517     0.200
    84.980     2.429     0.200
    84.980     1.314     0.200
    86.608     4.030     0.200
    93.415     1.621     0.200
    93.415     0.746     0.200
    94.723     3.288     0.200
    94.723    -0.333     0.200
    98.141     0.457     0.200
    20.549     0.388     0.200
    21.609    -0.505     0.200
    22.108     1.308     0.200
    22.248     0.417     0.200
    23.634     0.688     0.200
    24.405     1.487     0.200
    24.405     0.631     0.200
    40.598     3.307     0.200
    43.589     0.697     0.200
    40.567     4.103     0.200
    21.424     3.071     0.200
    40.592     6.269     0.200
    14.990     6.062     0.200
    15.003     5.796     0.200
    15.101     5.540     0.200
    15.122     5.596     0.200
    15.844     4.927     0.200
    17.468     1.325     0.200
    18.606     0.682     0.200
    20.019     0.439     0.200
    22.601     1.499     0.200
    23.442    -0.376     0.200
    24.455     1.760     0.200
    24.531     0.829     0.200
    24.967     1.417     0.200
    30.904    -0.356     0.200
    37.840     0.227     0.200
    38.988    -0.044     0.200
    40.639     3.105     0.200
    40.700     0.423     0.200
    41.892     0.194     0.200
    43.629     1.607     0.200
    45.164     1.568     0.200
    75.347    -0.061     0.200
    79.063     2.394     0.200
    83.412     1.276     0.200
    83.412     2.166     0.200
    85.021     0.410     0.200
    84.980     1.029     0.200
    85.615     1.881     0.200
    98.126     0.377     0.200
    16.928     3.297     0.200
    17.717     3.631     0.200
    18.418     0.093     0.200
    18.539    -0.695     0.200
    21.465     3.077     0.200
    21.550     1.582     0.200
    21.585     2.838     0.200
    21.786     2.297     0.200
    21.865    -0.262     0.200
    22.606     1.500     0.200
    22.606     3.680     0.200
    22.962     4.390     0.200
    23.675     2.530     0.200
    23.803     3.943     0.200
    24.034     2.384     0.200
    24.127     3.046     0.200
    24.187     1.162     0.200
    24.187     4.919     0.200
    24.225     2.211     0.200
    24.249     1.107     0.200
    24.299     2.657     0.200
    24.415     3.408     0.200
    24.415     1.947     0.200
    24.539     3.863     0.200
    24.658     0.632     0.200
    24.930     1.328     0.200
    25.120     1.527     0.200
    25.509     2.752     0.200
    25.518     2.610     0.200
    25.826     2.662     0.200
    25.985     4.386     0.200
    26.005     0.928     0.200
    26.109     2.343     0.200
    26.248     4.826     0.200
    26.475     2.856     0.200
    26.663     1.894     0.200
    27.011     2.025     0.200
    27.127     3.161     0.200
    27.276     6.742     0.200
    27.471     2.308     0.200
    27.733     1.758     0.200
    27.790     2.183     0.200
    27.838     3.674     0.200
    27.916     3.415     0.200
    27.962     0.418     0.200
    28.889     4.169     0.200
    28.992     3.506     0.200
    29.072     3.659     0.200
    29.389     2.729     0.200
    29.423     2.721     0.200
    31.022     2.113     0.200
    31.096     3.681     0.200
    31.846     2.608     0.200
    31.880     2.114     0.200
    32.013     3.094     0.200
    32.395     2.497     0.200
    32.628     4.956     0.200
    32.686     3.873     0.200
    33.376     3.494     0.200
    33.549     3.283     0.200
    37.770     4.027     0.200
    37.984     0.707     0.200
    39.111     4.211     0.200
    40.569     4.140     0.200
    40.569     2.867     0.200
    41.488     3.191     0.200
    41.822     4.502     0.200
    43.559     3.383     0.200
    44.717     4.242     0.200
    46.873     1.617     0.200
    52.421     5.092     0.200
    68.938     4.300     0.200
    80.867     5.510     0.200
    84.960     5.014     0.200
    94.638     6.509     0.200
    21.473     4.645     0.200
    85.508     3.955     0.200
    94.490     4.827     0.200
    15.225     4.973     0.200
    15.303     3.824     0.200
    16.636     1.353     0.200
    18.559    -0.592     0.200
    20.553     0.321     0.200
    21.448    -2.602     0.200
    23.346    -2.364     0.200
    24.427     0.780     0.200
    24.427    -1.996     0.200
    26.264    -1.417     0.200
    65.880     1.426     0.200
    17.708     0.259     0.200
    19.446    -0.740     0.200
    21.449    -1.065     0.200
    22.598    -0.028     0.200
    24.240     0.012     0.200
    24.417     0.631     0.200
    24.417    -0.172     0.200
    24.692     0.279     0.200
    28.985    -0.511     0.200
    31.518    -0.231     0.200
    40.583     3.305     0.200
    40.852    -0.953     0.200
    65.876     1.889     0.200
    76.568     2.444     0.200
    76.568     0.040     0.200
    84.957     2.867     0.200
    84.957    -1.248     0.200
    85.566     2.266     0.200
    85.566    -0.363     0.200
    98.071    -1.550     0.200
    24.441     2.130     0.200
    40.621     2.013     0.200
    15.576     6.097     0.200
    18.573     2.128     0.200
    20.562     2.025     0.200
    21.521     1.475     0.200
    21.624     0.920     0.200
    22.246     1.997     0.200
    22.565    -0.287     0.200
    23.094     1.469     0.200
    23.353     1.647     0.200
    24.412     1.513     0.200
    24.412     0.747     0.200
    24.924     1.528     0.200
    40.614     3.581     0.200
    40.614     1.230     0.200
    43.605     2.257     0.200
    43.826     1.694     0.200
    84.937     2.678     0.200
    85.610     2.871     0.200
    85.610     1.496     0.200
    86.593     2.140     0.200
    98.108     2.136     0.200
    14.950     5.926     0.200
    15.495     3.222     0.200
    17.354     3.431     0.200
    21.625     1.565     0.200
    23.363     0.336     0.200
    26.425     0.977     0.200
    32.664    -0.199     0.200
    40.611     1.590     0.200
    40.611     2.855     0.200
    43.601     2.385     0.200
    49.155    -0.544     0.200
    79.736     1.354     0.200
    83.648     2.167     0.200
    40.556     3.674     0.200
    24.430     3.789     0.200
    40.622     2.976     0.200
    40.646     3.836     0.200
    40.613     5.708     0.200
    16.009     2.681     0.200
    17.850     1.526     0.200
    19.693     0.510     0.200
    20.562    -0.355     0.200
    21.063     0.337     0.200
    21.409     0.814     0.200
    21.431     1.775     0.200
    21.904     1.146     0.200
    22.163     2.066     0.200
    24.469     1.850     0.200
    32.690     2.180     0.200
    37.828     0.634     0.200
    39.170     1.100     0.200
    40.627     3.798     0.200
    41.882     0.768     0.200
    80.814     3.476     0.200
    83.656     2.821     0.200
    85.000     3.504     0.200
    85.591     3.127     0.200
    88.740     1.385     0.200
    98.108     0.212     0.200
    15.391     8.133     0.200
    40.617     4.569     0.200
    17.730     2.244     0.200
    20.390    -1.090     0.200
    20.390     2.242     0.200
    21.400    -0.783     0.200
    21.678     0.083     0.200
    22.623     2.172     0.200
    22.623     2.512     0.200
    22.928     0.583     0.200
    23.029     2.476     0.200
    24.211     3.055     0.200
    24.485     1.320     0.200
    24.485    -0.957     0.200
    24.551     0.163     0.200
    24.940     3.402     0.200
    24.934     3.140     0.200
    26.486    -0.854     0.200
    30.986     0.569     0.200
    31.051     2.361     0.200
    31.557     1.570     0.200
    32.115     1.749     0.200
    32.719     1.803     0.200
    32.719     0.467     0.200
    33.408     1.708     0.200
    33.488     6.529     0.200
    34.014     1.849     0.200
    36.936     2.894     0.200
    40.661     2.925     0.200
    40.661     2.257     0.200
    41.915     3.270     0.200
    44.093     1.230     0.200
    44.649     3.438     0.200
    44.713     2.497     0.200
    46.956     0.664     0.200
    52.810     5.617     0.200
    55.008     1.704     0.200
    67.030     2.917     0.200
    69.238     1.985     0.200
    69.989    -0.482     0.200
    74.704     4.105     0.200
    74.776     2.129     0.200
    75.367     2.372     0.200
    75.367     1.232     0.200
    75.920     2.067     0.200
    85.034     2.350     0.200
    85.034     1.971     0.200
    85.008     2.388     0.200
    85.624     2.499     0.200
    85.624     1.354     0.200
    88.559     6.311     0.200
    98.143    -0.406     0.200
    40.566     2.219     0.200
    40.559     3.595     0.200
    16.223     4.547     0.200
    16.223     3.906     0.200
    16.875     4.121     0.200
    17.713     4.364     0.200
    17.825     3.873     0.200
    18.669    -0.623     0.200
    18.690    -1.729     0.200
    19.106    -1.642     0.200
    19.137    -1.746     0.200
    19.319    -0.886     0.200
    20.006    -1.806     0.200
    21.422    -0.686     0.200
    22.607    -1.186     0.200
    22.607     2.935     0.200
    22.604    -1.128     0.200
    22.604     4.322     0.200
    22.604     3.661     0.200
    22.990     3.461     0.200
    24.134    -1.385     0.200
    24.189     4.064     0.200
    24.189     3.252     0.200
    24.229    -0.885     0.200
    24.243    -1.304     0.200
    24.445     1.662     0.200
    24.534    -0.638     0.200
    25.198     0.199     0.200
    25.501     0.368     0.200
    25.822     0.839     0.200
    26.287     3.199     0.200
    26.470    -0.020     0.200
    27.966     0.164     0.200
    30.369    -0.627     0.200
    32.675     1.508     0.200
    32.675    -0.691     0.200
    32.692     3.815     0.200
    34.071    -0.853     0.200
    34.799    -0.970     0.200
    40.620     3.273     0.200
    40.888     0.047     0.200
    44.734    -1.183     0.200
    44.673     5.055     0.200
    52.453     3.701     0.200
    65.303     4.218     0.200
    68.632     1.465     0.200
    68.898     2.449     0.200
    70.436     4.233     0.200
    70.935     2.186     0.200
    74.150     0.131     0.200
    74.995     2.228     0.200
    75.328     2.909     0.200
    77.232     4.364     0.200
    78.431     2.216     0.200
    79.898     1.888     0.200
    80.816     0.500     0.200
    80.816     0.929     0.200
    80.816     2.546     0.200
    82.559     4.898     0.200
    82.632     3.427     0.200
    82.911     3.838     0.200
    82.984     2.378     0.200
    83.041     3.975     0.200
    83.085     4.117     0.200
    83.085     3.320     0.200
    83.824     3.565     0.200
    84.804     3.837     0.200
    85.002     1.793     0.200
    85.002     0.183     0.200
    84.976     0.553     0.200
    85.023     3.438     0.200
    85.597     2.324     0.200
    85.597     1.293     0.200
    86.573    -2.551     0.200
    98.107    -0.443     0.200
    20.571     0.484     0.200
    21.118    -1.593     0.200
    24.439     0.058     0.200
    32.664     1.932     0.200
    40.608     2.144     0.200
    15.677     4.105     0.200
    20.643     1.125     0.200
    20.964     0.262     0.200
    21.088     0.933     0.200
    22.316    -0.370     0.200
    22.627    -0.345     0.200
    23.436     1.531     0.200
    24.259     1.182     0.200
    24.499     3.246     0.200
    25.011     0.067     0.200
    25.844    -0.702     0.200
    32.737     3.004     0.200
    33.415     3.992     0.200
    40.678     3.138     0.200
    40.678     2.048     0.200
    41.933     2.381     0.200
    43.668     2.354     0.200
    83.458     3.067     0.200
    85.018     2.015     0.200
    14.850     7.198     0.200
    16.193     4.290     0.200
    17.701     3.164     0.200
    19.123     0.858     0.200
    19.203     0.609     0.200
    19.227     0.150     0.200
    19.976     0.270     0.200
    20.350     1.635     0.200
    20.549     0.106     0.200
    20.954     2.625     0.200
    21.012     0.914     0.200
    21.105     1.641     0.200
    21.439    -2.448     0.200
    21.540     0.942     0.200
    22.117     2.008     0.200
    22.130     0.779     0.200
    22.268     0.562     0.200
    22.512     0.350     0.200
    22.588     2.069     0.200
    22.591     2.647     0.200
    22.591     1.905     0.200
    22.591     3.745     0.200
    22.591     2.937     0.200
    22.627     2.171     0.200
    22.676     2.055     0.200
    22.963     2.698     0.200
    22.963     1.999     0.200
    24.174     1.286     0.200
    24.174     2.856     0.200
    24.174     2.196     0.200
    24.213     1.792     0.200
    24.417     1.324     0.200
    24.417     0.648     0.200
    24.417     1.679     0.200
    24.674     0.414     0.200
    24.877     1.510     0.200
    24.877     2.920     0.200
    24.931     0.946     0.200
    25.987     2.606     0.200
    26.072     0.088     0.200
    26.256     0.612     0.200
    26.256     2.362     0.200
    26.256     1.674     0.200
    26.410     1.080     0.200
    26.592     1.393     0.200
    27.115     0.959     0.200
    29.064     3.918     0.200
    29.376     1.002     0.200
    29.412     0.766     0.200
    31.010     1.771     0.200
    31.010     1.392     0.200
    31.010     3.310     0.200
    32.630     0.988     0.200
    32.643     1.611     0.200
    32.642     2.549     0.200
    32.675     3.240     0.200
    37.791     1.060     0.200
    37.999     1.334     0.200
    39.172     2.953     0.200
    40.571     1.311     0.200
    40.577     3.010     0.200
    40.590     1.472     0.200
    40.590     3.003     0.200
    40.590     1.769     0.200
    40.964     4.730     0.200
    40.997     1.183     0.200
    41.171     3.007     0.200
    41.494     0.761     0.200
    41.509     1.222     0.200
    41.509     2.933     0.200
    41.627     1.195     0.200
    41.843     0.622     0.200
    41.874     0.540     0.200
    42.003     0.993     0.200
    43.580     1.138     0.200
    44.691     3.734     0.200
    44.691     4.195     0.200
    44.744     3.516     0.200
    44.744     5.258     0.200
    46.881     1.758     0.200
    52.424     1.411     0.200
    52.424     2.641     0.200
    55.209     2.150     0.200
    55.786     0.941     0.200
    55.786     1.602     0.200
    57.399     0.944     0.200
    57.399     3.014     0.200
    57.399     2.573     0.200
    62.335     1.170     0.200
    62.335     0.760     0.200
    65.871     2.038     0.200
    65.885     0.514     0.200
    65.885     0.826     0.200
    69.917     0.865     0.200
    69.917     1.166     0.200
    70.945     1.881     0.200
    75.299     1.429     0.200
    76.015     2.425     0.200
    76.589     0.437     0.200
    78.443     1.982     0.200
    78.443     2.903     0.200
    79.867     0.310     0.200
    80.843     2.212     0.200
    80.843     2.353     0.200
    81.343     2.263     0.200
    81.834     4.646     0.200
    81.870     3.366     0.200
    82.014     3.658     0.200
    82.181     5.576     0.200
    82.538     3.049     0.200
    82.610     3.151     0.200
    82.747     3.586     0.200
    82.135     6.515     0.200
    82.889     2.768     0.200
    82.963     3.894     0.200
    82.966     3.882     0.200
    83.020     4.509     0.200
    83.063     3.056     0.200
    83.200     3.809     0.200
    83.433     3.616     0.200
    83.448     2.980     0.200
    83.495     2.590     0.200
    83.629     1.860     0.200
    83.715     2.916     0.200
    83.854     1.985     0.200
    84.953     1.234     0.200
    84.953     1.496     0.200
    84.966     1.770     0.200
    84.978     1.419     0.200
    84.978     2.310     0.200
    84.978     1.509     0.200
    84.982     2.191     0.200
    85.576     0.606     0.200
    85.576     1.017     0.200
    85.577     1.146     0.200
    85.577     1.814     0.200
    86.393     1.748     0.200
    86.548     1.714     0.200
    86.599     1.054     0.200
    86.599     1.765     0.200
    87.323     1.995     0.200
    88.629     1.464     0.200
    88.688     1.618     0.200
    88.688     0.899     0.200
    90.633     3.557     0.200
    90.835     2.100     0.200
    91.214     2.263     0.200
    92.733     0.811     0.200
    93.367     1.240     0.200
    93.527     1.247     0.200
    94.384     2.308     0.200
    94.660     3.012     0.200
    94.660     1.606     0.200
    94.998     1.920     0.200
    94.998     0.975     0.200
    15.544     3.756     0.200
    16.223     4.223     0.200
    17.706     2.684     0.200
    19.313    -0.376     0.200
    19.466    -1.198     0.200
    20.260    -1.735     0.200
    20.362    -0.657     0.200
    20.940    -0.753     0.200
    20.954    -1.018     0.200
    21.290    -0.783     0.200
    21.413     2.751     0.200
    22.133    -0.732     0.200
    22.261    -0.666     0.200
    22.602    -1.499     0.200
    22.598     1.035     0.200
    22.598     4.654     0.200
    22.598     5.465     0.200
    22.632    -0.679     0.200
    22.895    -0.620     0.200
    22.924    -1.105     0.200
    22.990     3.160     0.200
    23.378    -1.589     0.200
    24.184     3.765     0.200
    24.184     6.175     0.200
    24.224    -1.166     0.200
    24.237    -0.022     0.200
    24.445     2.263     0.200
    24.445     3.388     0.200
    26.289     3.057     0.200
    26.907     1.900     0.200
    31.022    -0.370     0.200
    31.022     3.720     0.200
    31.526    -1.207     0.200
    32.679     2.714     0.200
    33.378    -0.506     0.200
    40.234    -0.646     0.200
    40.627     3.777     0.200
    42.717    -0.736     0.200
    43.617     0.414     0.200
    44.722     2.424     0.200
    46.915     0.112     0.200
    52.453     3.304     0.200
    63.527     1.965     0.200
    65.072     0.607     0.200
    65.294     4.374     0.200
    65.918     3.022     0.200
    68.889     2.317     0.200
    70.428     4.659     0.200
    74.554     1.969     0.200
    77.224     3.858     0.200
    80.808     2.421     0.200
    81.307     3.913     0.200
    83.400     0.993     0.200
    84.973     2.569     0.200
    85.606     3.029     0.200
    88.562     3.028     0.200
    88.606     3.005     0.200
    90.661     2.879     0.200
    93.398     1.441     0.200
    24.471     1.522     0.200
    40.654     3.676     0.200
    40.628     2.554     0.200
    20.221    -1.313     0.200
    20.525    -1.417     0.200
    21.084     0.479     0.200
    21.439     0.025     0.200
    22.225     1.017     0.200
    22.485    -0.694     0.200
    22.569     1.638     0.200
    22.889     1.326     0.200
    22.935    -0.064     0.200
    23.318     0.292     0.200
    23.997     0.774     0.200
    24.091     1.412     0.200
    24.212    -1.323     0.200
    24.389     1.432     0.200
    24.652    -0.843     0.200
    24.903    -1.173     0.200
    32.619     1.838     0.200
    37.774     0.489     0.200
    38.900     0.689     0.200
    40.283     1.594     0.200
    40.573     3.485     0.200
    40.573    -0.133     0.200
    41.986     0.271     0.200
    42.665     0.571     0.200
    43.393     0.295     0.200
    46.141     0.759     0.200
    46.855     1.291     0.200
    49.834    -0.937     0.200
    52.429    -0.410     0.200
    56.847    -0.216     0.200
    67.360     0.318     0.200
    70.694     0.896     0.200
    80.856     2.856     0.200
    80.856     0.676     0.200
    83.341     2.110     0.200
    84.927     2.593     0.200
    94.645     3.532     0.200
    98.068     0.149     0.200
    15.683     3.694     0.200
    16.225     3.207     0.200
    17.704     1.568     0.200
    24.447     2.198     0.200
    32.684     2.521     0.200
    40.633     2.355     0.200
    32.651     2.856     0.200
    40.592     3.148     0.200
    24.503     3.684     0.200
    32.728     3.290     0.200
    40.662     4.395     0.200
    21.403     3.023     0.200
    40.585     5.259     0.200
    21.430    -2.364     0.200
    32.672     4.137     0.200
    40.615     3.488     0.200
    15.471     4.225     0.200
    15.913     5.054     0.200
    17.550     5.048     0.200
    18.281     5.258     0.200
    18.281     5.762     0.200
    18.481    -1.094     0.200
    18.589    -1.089     0.200
    18.957    -1.092     0.200
    19.016    -0.515     0.200
    19.188    -0.643     0.200
    19.688    -0.879     0.200
    19.925    -0.936     0.200
    20.040    -0.981     0.200
    20.276    -1.063     0.200
    20.265    -1.480     0.200
    20.478    -0.748     0.200
    20.732    -1.450     0.200
    20.849    -0.877     0.200
    20.960    -0.803     0.200
    21.342    -0.474     0.200
    21.342     5.366     0.200
    21.544     0.902     0.200
    21.635    -0.670     0.200
    22.429    -0.799     0.200
    22.657    -1.374     0.200
    22.724    -2.125     0.200
    23.056    -1.241     0.200
    23.993     5.176     0.200
    24.140     2.651     0.200
    24.121    -1.455     0.200
    24.396    -0.822     0.200
    24.617     3.186     0.200
    24.659    -0.662     0.200
    25.966     3.773     0.200
    26.312    -1.115     0.200
    32.359     3.866     0.200
    32.359    -0.115     0.200
    37.544    -0.921     0.200
    37.715    -0.836     0.200
    39.928     4.631     0.200
    40.345    -0.726     0.200
    40.345     5.113     0.200
    41.386     3.131     0.200
    41.386    -1.021     0.200
    42.446    -1.211     0.200
    42.832    -0.980     0.200
    43.002    -1.537     0.200
    44.807    -1.211     0.200
    44.807     5.289     0.200
    45.599     4.575     0.200
    46.591    -1.431     0.200
    52.144     4.114     0.200
    52.607     3.492     0.200
    57.113     4.104     0.200
    62.046     2.689     0.200
    68.990     2.771     0.200
    70.933     5.604     0.200
    75.025     4.009     0.200
    75.128     2.055     0.200
    75.745     3.239     0.200
    75.850     5.281     0.200
    77.870     3.122     0.200
    77.870     2.826     0.200
    83.506     1.601     0.200
    83.716     6.004     0.200
    84.547     3.673     0.200
    84.825     5.234     0.200
    85.438     3.663     0.200
    86.238     4.339     0.200
    86.539     6.610     0.200
    86.699     2.555     0.200
    87.849     5.227     0.200
    91.107     5.697     0.200
    91.832     3.717     0.200
    92.163     4.733     0.200
    92.971     5.672     0.200
    95.073     2.275     0.200
    97.872    -2.013     0.200
    98.740     0.094     0.200
    17.653     5.682     0.200
    31.772     1.647     0.200
    39.653     3.133     0.200
    24.200     1.345     0.200
    32.405     1.722     0.200
    40.375     3.103     0.200
    32.377     2.526     0.200
    39.856     1.695     0.200
    15.119     3.758     0.200
    15.488     3.259     0.200
    15.608     6.973     0.200
    16.013     5.627     0.200
    18.376     2.205     0.200
    18.376     4.175     0.200
    18.547    -1.141     0.200
    19.021     0.210     0.200
    19.094    -0.368     0.200
    19.281     1.563     0.200
    19.977    -0.034     0.200
    21.431     2.193     0.200
    21.512     2.647     0.200
    22.053     0.065     0.200
    22.164     1.290     0.200
    22.487    -0.171     0.200
    22.491     2.865     0.200
    22.491     0.664     0.200
    22.491     5.195     0.200
    22.739    -0.192     0.200
    22.789     2.390     0.200
    22.789    -1.250     0.200
    22.959     1.238     0.200
    23.200     0.869     0.200
    23.689     0.210     0.200
    23.868     0.373     0.200
    23.912     0.175     0.200
    23.989     0.197     0.200
    24.061     2.852     0.200
    24.094     0.201     0.200
    24.239     1.838     0.200
    24.239     0.459     0.200
    24.492    -0.436     0.200
    24.711     1.853     0.200
    24.757     0.167     0.200
    24.768     0.433     0.200
    25.716     2.445     0.200
    25.908     3.483     0.200
    25.972     2.421     0.200
    30.522     2.193     0.200
    30.891     1.838     0.200
    32.445     0.510     0.200
    32.457     2.425     0.200
    32.457     2.312     0.200
    32.549     1.775     0.200
    33.241     3.915     0.200
    33.485     4.506     0.200
    39.095     4.400     0.200
    39.129     3.909     0.200
    39.221     4.064     0.200
    39.325     3.958     0.200
    39.427     3.414     0.200
    39.848     4.538     0.200
    40.020     0.585     0.200
    40.428     1.514     0.200
    40.428     5.174     0.200
    40.428     3.288     0.200
    40.428     3.155     0.200
    40.802     2.666     0.200
    41.011     0.591     0.200
    41.211     0.977     0.200
    41.352     0.612     0.200
    41.461     1.613     0.200
    41.674     1.585     0.200
    41.843     1.418     0.200
    42.043     1.030     0.200
    42.970     1.493     0.200
    43.420     2.300     0.200
    44.772     4.064     0.200
    44.772     1.335     0.200
    44.799     0.540     0.200
    44.886     0.122     0.200
    44.924     1.761     0.200
    45.399     1.590     0.200
    45.593     1.211     0.200
    45.485     1.364     0.200
    45.704     0.977     0.200
    46.493     0.776     0.200
    46.693     0.669     0.200
    51.298     3.102     0.200
    52.244     2.299     0.200
    53.761     1.528     0.200
    54.426     0.775     0.200
    57.214     0.864     0.200
    65.766     3.125     0.200
    65.766     1.533     0.200
    66.949     1.497     0.200
    69.749     1.410     0.200
    69.749     0.367     0.200
    76.417     3.201     0.200
    77.395     3.881     0.200
    77.826     3.378     0.200
    77.826     1.269     0.200
    77.826     2.333     0.200
    80.985     2.862     0.200
    84.858     2.880     0.200
    84.804     1.798     0.200
    85.481     1.913     0.200
    85.481     0.556     0.200
    85.482     2.792     0.200
    85.482     0.401     0.200
    86.235     0.579     0.200
    86.420     3.698     0.200
    86.411     0.233     0.200
    91.521     3.147     0.200
    94.186     3.481     0.200
    94.822     3.287     0.200
    96.290    -0.329     0.200
    98.810    -0.387     0.200
    15.973     3.323     0.200
    15.973     4.383     0.200
    16.320     4.098     0.200
    17.601     2.466     0.200
    17.735     2.587     0.200
    18.325     3.683     0.200
    18.325     4.077     0.200
    18.732     0.150     0.200
    18.797     0.145     0.200
    19.327     0.941     0.200
    20.314     0.408     0.200
    20.793     0.978     0.200
    20.810     1.079     0.200
    20.895     2.234     0.200
    21.247     0.065     0.200
    21.380     4.295     0.200
    21.380     1.545     0.200
    21.549     1.627     0.200
    21.692     0.142     0.200
    21.758    -0.601     0.200
    22.158     0.738     0.200
    22.323    -0.394     0.200
    22.483     3.561     0.200
    22.483    -0.451     0.200
    22.483     4.330     0.200
    22.752     2.699     0.200
    22.752    -0.233     0.200
    24.048     3.243     0.200
    24.048     0.192     0.200
    24.048     4.371     0.200
    24.201     0.932     0.200
    24.201    -0.888     0.200
    24.441    -0.591     0.200
    24.425     0.395     0.200
    24.679     2.325     0.200
    24.721     0.041     0.200
    25.087    -0.531     0.200
    25.709     1.750     0.200
    25.906     2.478     0.200
    25.959    -0.419     0.200
    25.964     2.914     0.200
    26.024     2.520     0.200
    26.213    -0.141     0.200
    28.927     0.048     0.200
    29.155     2.941     0.200
    30.876     2.773     0.200
    30.876     0.623     0.200
    31.118     2.460     0.200
    32.395    -1.048     0.200
    32.407     2.764     0.200
    32.532     3.488     0.200
    33.276     2.339     0.200
    33.660     4.168     0.200
    33.502     5.653     0.200
    33.820     1.585     0.200
    36.946     2.826     0.200
    37.470    -0.010     0.200
    37.577    -0.704     0.200
    38.473     3.698     0.200
    39.969     3.793     0.200
    39.969     5.123     0.200
    40.378     4.837     0.200
    40.378     3.726     0.200
    40.752     3.727     0.200
    40.961    -0.091     0.200
    41.302     0.728     0.200
    41.448     2.041     0.200
    41.448     3.616     0.200
    41.448    -0.515     0.200
    41.624    -0.343     0.200
    41.674    -0.515     0.200
    43.370     0.500     0.200
    44.758     1.849     0.200
    44.809     2.750     0.200
    44.809     1.629     0.200
    44.831     1.984     0.200
    44.924     1.285     0.200
    45.427     2.191     0.200
    45.653     3.056     0.200
    45.742     0.656     0.200
    46.648     0.099     0.200
    52.205     3.297     0.200
    52.205     0.407     0.200
    52.532     3.078     0.200
    55.550     0.271     0.200
    57.172     0.400     0.200
    61.451     3.417     0.200
    62.103     2.969     0.200
    63.693     2.369     0.200
    63.693     1.789     0.200
    63.693     0.609     0.200
    63.758     3.253     0.200
    65.472     2.406     0.200
    65.721     2.757     0.200
    65.848     2.500     0.200
    69.001     1.956     0.200
    69.531     3.527     0.200
    69.698    -0.455     0.200
    74.942     3.439     0.200
    75.130     2.085     0.200
    75.801     3.914     0.200
    76.382     1.915     0.200
    76.653     2.373     0.200
    77.007     3.165     0.200
    77.867     2.758     0.200
    77.867     1.728     0.200
    77.901     2.618     0.200
    78.511     1.025     0.200
    78.542     3.167     0.200
    78.799     2.913     0.200
    79.636     1.848     0.200
    80.195     2.238     0.200
    80.308     2.758     0.200
    80.814     3.339     0.200
    81.033     3.897     0.200
    81.033     2.852     0.200
    81.407     3.250     0.200
    81.538     2.258     0.200
    81.697     3.694     0.200
    82.093     3.406     0.200
    82.124     3.370     0.200
    82.439     3.133     0.200
    82.440     3.310     0.200
    82.719     3.277     0.200
    82.726     1.510     0.200
    82.798     3.703     0.200
    82.894     3.153     0.200
    82.894     3.323     0.200
    82.977     2.626     0.200
    83.346     3.228     0.200
    83.370     3.707     0.200
    83.446     2.697     0.200
    83.511     2.801     0.200
    83.564     3.078     0.200
    83.648     3.237     0.200
    83.699     1.943     0.200
    83.824     2.907     0.200
    84.206     2.867     0.200
    84.608     3.892     0.200
    84.722     3.264     0.200
    84.777     3.556     0.200
    84.779     3.839     0.200
    84.813     2.018     0.200
    84.813     0.395     0.200
    84.778     3.387     0.200
    84.778    -0.668     0.200
    84.846     4.109     0.200
    84.865     3.247     0.200
    84.887     3.785     0.200
    85.355     4.259     0.200
    85.440     1.211     0.200
    85.440     0.222     0.200
    85.441     2.888     0.200
    85.441     0.459     0.200
    85.794     3.765     0.200
    86.206    -0.341     0.200
    86.300     3.974     0.200
    86.374     3.870     0.200
    86.360     2.899     0.200
    86.386     1.801     0.200
    86.761     2.583     0.200
    86.933     2.884     0.200
    87.134     3.723     0.200
    87.251     3.838     0.200
    87.334     3.671     0.200
    87.544     2.388     0.200
    87.652     3.083     0.200
    87.774     4.493     0.200
    88.019     3.597     0.200
    88.294     2.215     0.200
    91.478     2.034     0.200
    92.195     3.943     0.200
    93.142     1.390     0.200
    94.457     3.232     0.200
    94.457    -0.786     0.200
    94.771     2.709     0.200
    32.478     1.785     0.200
    40.439     2.627     0.200
    40.388     2.244     0.200
    40.320     2.791     0.200
    40.308     5.565     0.200
    39.776     3.847     0.200
    16.849     2.868     0.200
    14.538     4.450     0.200
    14.674     4.312     0.200
    14.894     4.738     0.200
    14.979     4.910     0.200
    15.165     3.163     0.200
    15.247     3.928     0.200
    15.292     3.866     0.200
    15.355     6.068     0.200
    15.387     3.278     0.200
    15.810     2.873     0.200
    16.037     2.196     0.200
    16.263     2.625     0.200
    16.435     2.435     0.200
    16.808     2.334     0.200
    16.849     3.445     0.200
    16.849     2.968     0.200
    16.849     1.929     0.200
    17.296     1.279     0.200
    17.710     2.075     0.200
    18.387    -0.120     0.200
    18.740     0.586     0.200
    19.976     0.553     0.200
    20.071     0.102     0.200
    21.697    -1.259     0.200
    21.877     2.305     0.200
    21.877     0.422     0.200
    22.510     3.383     0.200
    23.251     0.289     0.200
    23.251    -0.867     0.200
    23.844    -0.284     0.200
    23.947    -0.039     0.200
    24.822     1.878     0.200
    25.474    -0.591     0.200
    32.477    -1.888     0.200
    33.071    -0.872     0.200
    34.326    -0.977     0.200
    37.172     3.106     0.200
    38.850     3.409     0.200
    38.850    -0.451     0.200
    39.634    -0.593     0.200
    40.470    -0.442     0.200
    40.729     1.948     0.200
    40.729    -1.654     0.200
    40.773     0.005     0.200
    40.949    -0.290     0.200
    41.335    -0.588     0.200
    41.956    -0.570     0.200
    45.237    -0.110     0.200
    46.089    -0.016     0.200
    46.286     0.763     0.200
    49.125     1.209     0.200
    57.143     3.171     0.200
    63.373     4.670     0.200
    64.285     2.215     0.200
    66.858     3.500     0.200
    68.174     1.147     0.200
    81.280     1.540     0.200
    81.964     1.577     0.200
    81.964    -0.524     0.200
    83.944     2.021     0.200
    85.598     2.640     0.200
    86.146     0.403     0.200
    87.102     4.203     0.200
    87.580     2.942     0.200
    87.679     1.058     0.200
    89.683     0.938     0.200
    90.965     3.289     0.200
    92.045     0.382     0.200
    31.091     1.274     0.200
    38.965     2.623     0.200
    92.130     0.593     0.200
    89.662     6.298     0.200
    23.311     0.270     0.200
    31.074     1.436     0.200
    38.948     1.845     0.200
    81.378    -0.057     0.200
    38.971     2.684     0.200
    81.402     0.935     0.200
    18.183     2.354     0.200
    19.338     0.922     0.200
    20.087     0.781     0.200
    20.839    -0.509     0.200
    21.070    -0.718     0.200
    21.841    -0.727     0.200
    40.058     4.059     0.200
    23.207     1.771     0.200
    30.876     1.507     0.200
    38.717     2.394     0.200
    81.147     0.627     0.200
    14.989     2.988     0.200
    23.801     2.470     0.200
    42.626     1.478     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   101.279    -2.539     0.200
   109.587     1.129     0.200
   111.667     3.080     0.200
   100.092     3.383     0.200
   101.600     0.224     0.200
   109.120     1.744     0.200
   111.248     2.785     0.200
   100.196    -0.402     0.200
   100.202     2.461     0.200
   103.581     4.939     0.200
   109.276     1.524     0.200
    99.997     1.886     0.200
   100.460     2.296     0.200
   100.076    -1.402     0.200
   100.165     0.937     0.200
   100.183     3.692     0.200
   108.527     1.898     0.200
    99.959    -1.456     0.200
    99.915     2.352     0.200
   102.362     0.149     0.200
   103.115     1.895     0.200
   100.424     2.329     0.200
   100.424     1.604     0.200
   101.911     4.922     0.200
   102.161     2.308     0.200
   114.008     0.941     0.200
   104.154     3.091     0.200
   104.091     3.160     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    15.902   299.930     0.200
    40.431   124.628     0.200
    97.306     1.707     0.200
    97.335     2.189     0.200
    97.856     2.127     0.200
    97.330     3.380     0.200
    16.576   295.179     0.200
    76.521    11.384     0.200
    97.841     2.438     0.200
    99.033     1.094     0.200
    32.137   169.965     0.200
    92.283     5.605     0.200
    97.542     2.258     0.200
    98.074     4.261     0.200
    98.551     3.320     0.200
    86.287     4.422     0.200
    97.335     3.304     0.200
    83.168     4.538     0.200
    83.218     4.080     0.200
    83.270     4.729     0.200
    83.372     4.853     0.200
    83.566     4.713     0.200
    83.735     4.984     0.200
    84.262     3.722     0.200
    32.312   168.988     0.200
    39.782   128.564     0.200
    45.623    99.921     0.200
    32.314   168.489     0.200
    97.557     2.934     0.200
    16.129   295.213     0.200
    31.468   175.106     0.200
    99.360     4.289     0.200
    73.371    17.192     0.200
    75.377    10.317     0.200
    88.253     2.856     0.200
    97.143     2.311     0.200
    97.245     1.298     0.200
    98.947     1.204     0.200
    97.190     1.089     0.200
    98.154     1.109     0.200
    97.370     5.064     0.200
    97.380     0.736     0.200
    98.159     3.275     0.200
    32.643   166.583     0.200
    40.590   123.296     0.200
    99.134     1.799     0.200
    98.115    -0.139     0.200
    32.619   168.338     0.200
    32.457   170.232     0.200
    98.954     2.998     0.200
    98.903     1.985     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
