#!/bin/bash
gmt begin penasco2.16_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times penasco2.16'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.688
    25.500   328.230
    26.000   332.763
    26.500   337.283
    27.000   341.791
    27.500   346.283
    28.000   350.755
    28.500   355.211
    29.000   359.656
    29.500   364.092
    30.000   368.521
    30.500   372.941
    31.000   377.354
    31.500   381.760
    32.000   386.157
    32.500   390.545
    33.000   394.922
    33.500   399.286
    34.000   403.636
    34.500   407.972
    35.000   412.292
    35.500   416.597
    36.000   420.887
    36.500   425.162
    37.000   429.421
    37.500   433.665
    38.000   437.893
    38.500   442.105
    39.000   446.300
    39.500   450.478
    40.000   454.639
    40.500   458.783
    41.000   462.910
    41.500   467.020
    42.000   471.113
    42.500   475.189
    43.000   479.247
    43.500   483.288
    44.000   487.311
    44.500   491.316
    45.000   495.304
    45.500   499.273
    46.000   503.225
    46.500   507.158
    47.000   511.073
    47.500   514.971
    48.000   518.850
    48.500   522.711
    49.000   526.554
    49.500   530.379
    50.000   534.185
    50.500   537.973
    51.000   541.743
    51.500   545.494
    52.000   549.228
    52.500   552.943
    53.000   556.641
    53.500   560.321
    54.000   563.983
    54.500   567.627
    55.000   571.252
    55.500   574.859
    56.000   578.447
    56.500   582.016
    57.000   585.568
    57.500   589.101
    58.000   592.616
    58.500   596.113
    59.000   599.592
    59.500   603.053
    60.000   606.495
    60.500   609.919
    61.000   613.324
    61.500   616.711
    62.000   620.080
    62.500   623.431
    63.000   626.763
    63.500   630.078
    64.000   633.375
    64.500   636.654
    65.000   639.916
    65.500   643.159
    66.000   646.384
    66.500   649.591
    67.000   652.780
    67.500   655.951
    68.000   659.104
    68.500   662.239
    69.000   665.355
    69.500   668.454
    70.000   671.534
    70.500   674.596
    71.000   677.640
    71.500   680.665
    72.000   683.673
    72.500   686.662
    73.000   689.633
    73.500   692.586
    74.000   695.520
    74.500   698.435
    75.000   701.331
    75.500   704.208
    76.000   707.068
    76.500   709.909
    77.000   712.732
    77.500   715.537
    78.000   718.324
    78.500   721.093
    79.000   723.844
    79.500   726.576
    80.000   729.290
    80.500   731.984
    81.000   734.660
    81.500   737.316
    82.000   739.952
    82.500   742.570
    83.000   745.170
    83.500   747.750
    84.000   750.311
    84.500   752.852
    85.000   755.372
    85.500   757.872
    86.000   760.354
    86.500   762.818
    87.000   765.264
    87.500   767.688
    88.000   770.076
    88.500   772.442
    89.000   774.797
    89.500   777.142
    90.000   779.480
    90.500   781.811
    91.000   784.136
    91.500   786.456
    92.000   788.770
    92.500   791.081
    93.000   793.388
    93.500   795.692
    94.000   797.992
    94.500   800.288
    95.000   802.578
    95.500   804.862
    96.000   807.140
    96.500   809.412
    97.000   811.677
    97.500   813.936
    98.000   816.187
    98.500   818.431
    99.000   820.668
    99.500   822.897
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1121.908
   116.000  1122.870
   116.500  1123.832
   117.000  1124.794
   117.500  1125.756
   118.000  1126.718
   118.500  1127.680
   119.000  1128.641
   119.500  1129.603
   120.000  1130.564
   120.500  1131.525
   121.000  1132.486
   121.500  1133.446
   122.000  1134.407
   122.500  1135.367
   123.000  1136.326
   123.500  1137.285
   124.000  1138.244
   124.500  1139.202
   125.000  1140.160
   125.500  1141.117
   126.000  1142.073
   126.500  1143.029
   127.000  1143.984
   127.500  1144.939
   128.000  1145.893
   128.500  1146.845
   129.000  1147.797
   129.500  1148.748
   130.000  1149.698
   130.500  1150.647
   131.000  1151.594
   131.500  1152.541
   132.000  1153.486
   132.500  1154.429
   133.000  1155.372
   133.500  1156.312
   134.000  1157.251
   134.500  1158.188
   135.000  1159.123
   135.500  1160.057
   136.000  1160.988
   136.500  1161.917
   137.000  1162.843
   137.500  1163.767
   138.000  1164.688
   138.500  1165.607
   139.000  1166.523
   139.500  1167.435
   140.000  1168.345
   140.500  1169.251
   141.000  1170.153
   141.500  1171.052
   142.000  1171.947
   142.500  1172.837
   143.000  1173.723
   143.500  1174.604
   144.000  1175.481
   144.500  1176.352
   145.000  1177.217
   145.500  1178.077
   146.000  1178.931
   146.500  1179.779
   147.000  1180.620
   147.500  1181.454
   148.000  1182.281
   148.500  1183.101
   149.000  1183.912
   149.500  1184.715
   150.000  1185.508
   150.500  1186.291
   151.000  1187.065
   151.500  1187.828
   152.000  1188.582
   152.500  1189.325
   153.000  1190.058
   153.500  1190.781
   154.000  1191.494
   154.500  1192.195
   155.000  1192.886
   155.500  1193.565
   156.000  1194.232
   156.500  1194.887
   157.000  1195.531
   157.500  1196.162
   158.000  1196.782
   158.500  1197.388
   159.000  1197.982
   159.500  1198.564
   160.000  1199.132
   160.500  1199.688
   161.000  1200.230
   161.500  1200.759
   162.000  1201.276
   162.500  1201.779
   163.000  1202.268
   163.500  1202.744
   164.000  1203.206
   164.500  1203.655
   165.000  1204.089
   165.500  1204.510
   166.000  1204.917
   166.500  1205.310
   167.000  1205.689
   167.500  1206.054
   168.000  1206.405
   168.500  1206.742
   169.000  1207.065
   169.500  1207.374
   170.000  1207.668
   170.500  1207.949
   171.000  1208.215
   171.500  1208.467
   172.000  1208.704
   172.500  1208.927
   173.000  1209.136
   173.500  1209.331
   174.000  1209.511
   174.500  1209.677
   175.000  1209.828
   175.500  1209.965
   176.000  1210.088
   176.500  1210.196
   177.000  1210.290
   177.500  1210.370
   178.000  1210.435
   178.500  1210.485
   179.000  1210.521
   179.500  1210.543
   180.000  1210.550
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   992.849
     1.000   992.857
     1.500   992.871
     2.000   992.891
     2.500   992.916
     3.000   992.947
     3.500   992.983
     4.000   993.025
     4.500   993.073
     5.000   993.126
     5.500   993.184
     6.000   993.249
     6.500   993.319
     7.000   993.394
     7.500   993.475
     8.000   993.562
     8.500   993.654
     9.000   993.752
     9.500   993.855
    10.000   993.964
    10.500   994.078
    11.000   994.198
    11.500   994.324
    12.000   994.455
    12.500   994.592
    13.000   994.734
    13.500   994.882
    14.000   995.035
    14.500   995.194
    15.000   995.358
    15.500   995.528
    16.000   995.703
    16.500   995.884
    17.000   996.070
    17.500   996.262
    18.000   996.459
    18.500   996.662
    19.000   996.870
    19.500   997.083
    20.000   997.302
    20.500   997.527
    21.000   997.757
    21.500   997.992
    22.000   998.233
    22.500   998.479
    23.000   998.731
    23.500   998.988
    24.000   999.250
    24.500   999.518
    25.000   999.791
    25.500  1000.070
    26.000  1000.353
    26.500  1000.643
    27.000  1000.937
    27.500  1001.237
    28.000  1001.542
    28.500  1001.852
    29.000  1002.168
    29.500  1002.489
    30.000  1002.815
    30.500  1003.147
    31.000  1003.483
    31.500  1003.825
    32.000  1004.173
    32.500  1004.525
    33.000  1004.883
    33.500  1005.245
    34.000  1005.613
    34.500  1005.986
    35.000  1006.365
    35.500  1006.748
    36.000  1007.137
    36.500  1007.530
    37.000  1007.929
    37.500  1008.333
    38.000  1008.742
    38.500  1009.155
    39.000  1009.574
    39.500  1009.998
    40.000  1010.427
    40.500  1010.861
    41.000  1011.300
    41.500  1011.744
    42.000  1012.193
    42.500  1012.647
    43.000  1013.106
    43.500  1013.570
    44.000  1014.038
    44.500  1014.512
    45.000  1014.990
    45.500  1015.473
    46.000  1015.961
    46.500  1016.454
    47.000  1016.952
    47.500  1017.454
    48.000  1017.961
    48.500  1018.473
    49.000  1018.990
    49.500  1019.511
    50.000  1020.037
    50.500  1020.568
    51.000  1021.103
    51.500  1021.643
    52.000  1022.188
    52.500  1022.738
    53.000  1023.291
    53.500  1023.850
    54.000  1024.413
    54.500  1024.981
    55.000  1025.553
    55.500  1026.130
    56.000  1026.711
    56.500  1027.296
    57.000  1027.886
    57.500  1028.481
    58.000  1029.080
    58.500  1029.683
    59.000  1030.291
    59.500  1030.903
    60.000  1031.519
    60.500  1032.140
    61.000  1032.765
    61.500  1033.394
    62.000  1034.028
    62.500  1034.666
    63.000  1035.308
    63.500  1035.954
    64.000  1036.604
    64.500  1037.259
    65.000  1037.918
    65.500  1038.581
    66.000  1039.248
    66.500  1039.919
    67.000  1040.594
    67.500  1041.273
    68.000  1041.956
    68.500  1042.643
    69.000  1043.334
    69.500  1044.029
    70.000  1044.729
    70.500  1045.431
    71.000  1046.138
    71.500  1046.849
    72.000  1047.564
    72.500  1048.282
    73.000  1049.004
    73.500  1049.730
    74.000  1050.460
    74.500  1051.193
    75.000  1051.931
    75.500  1052.672
    76.000  1053.416
    76.500  1054.165
    77.000  1054.916
    77.500  1055.672
    78.000  1056.431
    78.500  1057.194
    79.000  1057.960
    79.500  1058.730
    80.000  1059.503
    80.500  1060.280
    81.000  1061.060
    81.500  1061.844
    82.000  1062.630
    82.500  1063.421
    83.000  1064.215
    83.500  1065.012
    84.000  1065.812
    84.500  1066.616
    85.000  1067.423
    85.500  1068.233
    86.000  1069.047
    86.500  1069.864
    87.000  1070.683
    87.500  1071.506
    88.000  1072.333
    88.500  1073.162
    89.000  1073.994
    89.500  1074.830
    90.000  1075.668
    90.500  1076.510
    91.000  1077.354
    91.500  1078.202
    92.000  1079.052
    92.500  1079.905
    93.000  1080.762
    93.500  1081.621
    94.000  1082.483
    94.500  1083.348
    95.000  1084.215
    95.500  1085.086
    96.000  1085.959
    96.500  1086.835
    97.000  1087.713
    97.500  1088.594
    98.000  1089.478
    98.500  1090.365
    99.000  1091.254
    99.500  1092.146
   100.000  1093.040
   100.500  1093.937
   101.000  1094.837
   101.500  1095.739
   102.000  1096.643
   102.500  1097.550
   103.000  1098.459
   103.500  1099.371
   104.000  1100.285
   104.500  1101.201
   105.000  1102.120
   105.500  1103.041
   106.000  1103.964
   106.500  1104.890
   107.000  1105.818
   107.500  1106.748
   108.000  1107.680
   108.500  1108.614
   109.000  1109.551
   109.500  1110.489
   110.000  1111.430
   110.500  1112.372
   111.000  1113.317
   111.500  1114.264
   112.000  1115.213
   112.500  1116.163
   113.000  1117.116
   113.500  1118.071
   114.000  1119.027
   114.500  1119.986
   115.000  1120.946
   115.500  1121.908
   116.000  1122.872
   116.500  1123.837
   117.000  1124.805
   117.500  1125.774
   118.000  1126.745
   118.500  1127.717
   119.000  1128.691
   119.500  1129.667
   120.000  1130.644
   120.500  1131.623
   121.000  1132.603
   121.500  1133.585
   122.000  1134.569
   122.500  1135.554
   123.000  1136.540
   123.500  1137.528
   124.000  1138.518
   124.500  1139.508
   125.000  1140.500
   125.500  1141.494
   126.000  1142.489
   126.500  1143.485
   127.000  1144.482
   127.500  1145.481
   128.000  1146.480
   128.500  1147.481
   129.000  1148.484
   129.500  1149.487
   130.000  1150.491
   130.500  1151.497
   131.000  1152.504
   131.500  1153.511
   132.000  1154.520
   132.500  1155.530
   133.000  1156.541
   133.500  1157.553
   134.000  1158.565
   134.500  1159.579
   135.000  1160.593
   135.500  1161.609
   136.000  1162.625
   136.500  1163.642
   137.000  1164.660
   137.500  1165.679
   138.000  1166.698
   138.500  1167.718
   139.000  1168.740
   139.500  1169.761
   140.000  1170.783
   140.500  1171.806
   141.000  1172.830
   141.500  1173.854
   142.000  1174.879
   142.500  1175.904
   143.000  1176.930
   143.500  1177.957
   144.000  1178.984
   144.500  1180.011
   145.000  1181.039
   145.500  1182.067
   146.000  1183.096
   146.500  1184.125
   147.000  1185.155
   147.500  1186.184
   148.000  1187.215
   148.500  1188.245
   149.000  1189.276
   149.500  1190.307
   150.000  1191.338
   150.500  1192.370
   151.000  1193.401
   151.500  1194.433
   152.000  1195.465
   152.500  1196.498
   153.000  1197.530
   153.500  1198.562
   154.000  1199.595
   154.500  1200.627
   155.000  1201.660
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.531
   145.500  1178.354
   146.000  1180.234
   146.500  1182.152
   147.000  1184.097
   147.500  1186.065
   148.000  1188.053
   148.500  1190.059
   149.000  1192.080
   149.500  1194.115
   150.000  1196.163
   150.500  1198.223
   151.000  1200.293
   151.500  1202.372
   152.000  1204.461
   152.500  1206.558
   153.000  1208.663
   153.500  1210.775
   154.000  1212.894
   154.500  1215.020
   155.000  1217.151
   155.500  1219.289
   156.000  1221.432
   156.500  1223.579
   157.000  1225.732
   157.500  1227.889
   158.000  1230.050
   158.500  1232.215
   159.000  1234.384
   159.500  1236.557
   160.000  1238.734
   160.500  1240.913
   161.000  1243.096
   161.500  1245.281
   162.000  1247.469
   162.500  1249.660
   163.000  1251.853
   163.500  1254.049
   164.000  1256.246
   164.500  1258.446
   165.000  1260.647
   165.500  1262.851
   166.000  1265.056
   166.500  1267.263
   167.000  1269.471
   167.500  1271.680
   168.000  1273.891
   168.500  1276.104
   169.000  1278.317
   169.500  1280.531
   170.000  1282.747
   170.500  1284.963
   171.000  1287.180
   171.500  1289.398
   172.000  1291.617
   172.500  1293.837
   173.000  1296.057
   173.500  1298.277
   174.000  1300.498
   174.500  1302.719
   175.000  1304.941
   175.500  1307.163
   176.000  1309.386
   176.500  1311.608
   177.000  1313.831
   177.500  1316.054
   178.000  1318.276
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.528
   145.500  1178.154
   146.000  1179.701
   146.500  1181.190
   147.000  1182.630
   147.500  1184.024
   148.000  1185.376
   148.500  1186.688
   149.000  1187.965
   149.500  1189.214
   150.000  1190.437
   150.500  1191.638
   151.000  1192.818
   151.500  1193.978
   152.000  1195.120
   152.500  1196.245
   153.000  1197.354
   153.500  1198.448
   154.000  1199.529
   154.500  1200.598
   155.000  1201.652
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   509.724
     1.000   509.760
     1.500   509.820
     2.000   509.904
     2.500   510.012
     3.000   510.144
     3.500   510.300
     4.000   510.480
     4.500   510.684
     5.000   510.911
     5.500   511.163
     6.000   511.438
     6.500   511.736
     7.000   512.059
     7.500   512.405
     8.000   512.774
     8.500   513.167
     9.000   513.583
     9.500   514.023
    10.000   514.485
    10.500   514.971
    11.000   515.480
    11.500   516.011
    12.000   516.566
    12.500   517.143
    13.000   517.743
    13.500   518.365
    14.000   519.010
    14.500   519.677
    15.000   520.366
    15.500   521.077
    16.000   521.810
    16.500   522.565
    17.000   523.342
    17.500   524.140
    18.000   524.959
    18.500   525.799
    19.000   526.661
    19.500   527.543
    20.000   528.447
    20.500   529.371
    21.000   530.315
    21.500   531.280
    22.000   532.264
    22.500   533.269
    23.000   534.294
    23.500   535.338
    24.000   536.402
    24.500   537.485
    25.000   538.587
    25.500   539.708
    26.000   540.848
    26.500   542.007
    27.000   543.184
    27.500   544.379
    28.000   545.592
    28.500   546.824
    29.000   548.073
    29.500   549.339
    30.000   550.623
    30.500   551.924
    31.000   553.242
    31.500   554.577
    32.000   555.929
    32.500   557.297
    33.000   558.681
    33.500   560.081
    34.000   561.498
    34.500   562.930
    35.000   564.377
    35.500   565.840
    36.000   567.318
    36.500   568.810
    37.000   570.318
    37.500   571.840
    38.000   573.377
    38.500   574.927
    39.000   576.492
    39.500   578.071
    40.000   579.663
    40.500   581.269
    41.000   582.888
    41.500   584.520
    42.000   586.165
    42.500   587.823
    43.000   589.493
    43.500   591.176
    44.000   592.870
    44.500   594.577
    45.000   596.296
    45.500   598.026
    46.000   599.768
    46.500   601.522
    47.000   603.286
    47.500   605.061
    48.000   606.847
    48.500   608.644
    49.000   610.451
    49.500   612.269
    50.000   614.096
    50.500   615.934
    51.000   617.781
    51.500   619.638
    52.000   621.505
    52.500   623.380
    53.000   625.265
    53.500   627.159
    54.000   629.062
    54.500   630.973
    55.000   632.893
    55.500   634.821
    56.000   636.758
    56.500   638.702
    57.000   640.655
    57.500   642.615
    58.000   644.583
    58.500   646.558
    59.000   648.541
    59.500   650.531
    60.000   652.528
    60.500   654.531
    61.000   656.542
    61.500   658.559
    62.000   660.583
    62.500   662.613
    63.000   664.649
    63.500   666.692
    64.000   668.740
    64.500   670.794
    65.000   672.854
    65.500   674.919
    66.000   676.990
    66.500   679.067
    67.000   681.148
    67.500   683.235
    68.000   685.326
    68.500   687.423
    69.000   689.524
    69.500   691.630
    70.000   693.740
    70.500   695.855
    71.000   697.974
    71.500   700.097
    72.000   702.224
    72.500   704.355
    73.000   706.491
    73.500   708.629
    74.000   710.772
    74.500   712.918
    75.000   715.068
    75.500   717.220
    76.000   719.377
    76.500   721.536
    77.000   723.698
    77.500   725.864
    78.000   728.032
    78.500   730.203
    79.000   732.377
    79.500   734.553
    80.000   736.732
    80.500   738.913
    81.000   741.097
    81.500   743.283
    82.000   745.471
    82.500   747.661
    83.000   749.854
    83.500   752.048
    84.000   754.244
    84.500   756.442
    85.000   758.642
    85.500   760.843
    86.000   763.046
    86.500   765.251
    87.000   767.457
    87.500   769.664
    88.000   771.873
    88.500   774.083
    89.000   776.294
    89.500   778.506
    90.000   780.719
    90.500   782.934
    91.000   785.149
    91.500   787.365
    92.000   789.582
    92.500   791.799
    93.000   794.018
    93.500   796.237
    94.000   798.456
    94.500   800.677
    95.000   802.897
    95.500   805.118
    96.000   807.340
    96.500   809.562
    97.000   811.784
    97.500   814.006
    98.000   816.229
    98.500   818.451
    99.000   820.674
    99.500   822.897
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.534
    29.000   425.091
    29.500   430.648
    30.000   436.204
    30.500   441.759
    31.000   447.313
    31.500   452.865
    32.000   458.415
    32.500   463.962
    33.000   469.506
    33.500   475.047
    34.000   480.585
    34.500   486.118
    35.000   491.647
    35.500   497.171
    36.000   502.689
    36.500   508.201
    37.000   513.706
    37.500   519.204
    38.000   524.695
    38.500   530.177
    39.000   535.650
    39.500   541.114
    40.000   546.568
    40.500   552.012
    41.000   557.444
    41.500   562.864
    42.000   568.273
    42.500   573.668
    43.000   579.050
    43.500   584.418
    44.000   589.772
    44.500   595.110
    45.000   600.434
    45.500   605.742
    46.000   611.034
    46.500   616.309
    47.000   621.567
    47.500   626.309
    48.000   630.879
    48.500   635.445
    49.000   640.007
    49.500   644.563
    50.000   649.115
    50.500   653.661
    51.000   658.202
    51.500   662.738
    52.000   667.268
    52.500   671.792
    53.000   676.310
    53.500   680.822
    54.000   685.327
    54.500   689.825
    55.000   694.313
    55.500   698.791
    56.000   703.258
    56.500   707.718
    57.000   712.172
    57.500   716.620
    58.000   721.064
    58.500   725.502
    59.000   729.937
    59.500   734.368
    60.000   738.795
    60.500   743.218
    61.000   747.637
    61.500   752.052
    62.000   756.464
    62.500   760.872
    63.000   765.275
    63.500   769.675
    64.000   774.070
    64.500   778.461
    65.000   782.847
    65.500   787.227
    66.000   791.602
    66.500   795.971
    67.000   800.332
    67.500   804.687
    68.000   809.034
    68.500   813.374
    69.000   817.707
    69.500   822.032
    70.000   826.349
    70.500   830.659
    71.000   834.961
    71.500   839.255
    72.000   843.543
    72.500   847.822
    73.000   852.094
    73.500   856.358
    74.000   860.615
    74.500   864.863
    75.000   869.104
    75.500   873.336
    76.000   877.561
    76.500   881.777
    77.000   885.986
    77.500   890.186
    78.000   894.378
    78.500   898.561
    79.000   902.736
    79.500   906.902
    80.000   911.060
    80.500   915.209
    81.000   919.350
    81.500   923.482
    82.000   927.606
    82.500   931.721
    83.000   935.827
    83.500   939.925
    84.000   944.015
    84.500   948.096
    85.000   952.168
    85.500   956.232
    86.000   960.286
    86.500   964.332
    87.000   968.369
    87.500   972.398
    88.000   976.417
    88.500   980.428
    89.000   984.429
    89.500   988.422
    90.000   992.406
    90.500   996.381
    91.000  1000.346
    91.500  1004.303
    92.000  1008.251
    92.500  1012.190
    93.000  1016.120
    93.500  1020.040
    94.000  1023.952
    94.500  1027.855
    95.000  1031.748
    95.500  1035.633
    96.000  1039.508
    96.500  1043.375
    97.000  1047.232
    97.500  1051.080
    98.000  1054.919
    98.500  1058.750
    99.000  1062.570
    99.500  1066.382
   100.000  1070.185
   100.500  1073.978
   101.000  1077.763
   101.500  1081.538
   102.000  1085.304
   102.500  1089.061
   103.000  1092.808
   103.500  1096.547
   104.000  1100.277
   104.500  1103.998
   105.000  1107.710
   105.500  1111.413
   106.000  1115.107
   106.500  1118.792
   107.000  1122.469
   107.500  1126.136
   108.000  1129.794
   108.500  1133.443
   109.000  1137.083
   109.500  1140.713
   110.000  1144.335
   110.500  1147.947
   111.000  1151.549
   111.500  1155.143
   112.000  1158.727
   112.500  1162.302
   113.000  1165.868
   113.500  1169.425
   114.000  1172.972
   114.500  1176.511
   115.000  1180.040
   115.500  1183.561
   116.000  1187.072
   116.500  1190.574
   117.000  1194.068
   117.500  1197.552
   118.000  1201.027
   118.500  1204.493
   119.000  1207.950
   119.500  1211.397
   120.000  1214.836
   120.500  1218.265
   121.000  1221.685
   121.500  1225.095
   122.000  1228.497
   122.500  1231.889
   123.000  1235.272
   123.500  1238.646
   124.000  1242.011
   124.500  1245.367
   125.000  1248.714
   125.500  1252.052
   126.000  1255.381
   126.500  1258.701
   127.000  1262.012
   127.500  1265.314
   128.000  1268.608
   128.500  1271.892
   129.000  1275.167
   129.500  1278.434
   130.000  1281.691
   130.500  1284.939
   131.000  1288.179
   131.500  1291.409
   132.000  1294.631
   132.500  1297.843
   133.000  1301.046
   133.500  1304.240
   134.000  1307.426
   134.500  1310.602
   135.000  1313.769
   135.500  1316.927
   136.000  1320.076
   136.500  1323.216
   137.000  1326.346
   137.500  1329.468
   138.000  1332.581
   138.500  1335.684
   139.000  1338.778
   139.500  1341.864
   140.000  1344.940
   140.500  1348.007
   141.000  1351.065
   141.500  1354.114
   142.000  1357.154
   142.500  1360.185
   143.000  1363.207
   143.500  1366.220
   144.000  1369.224
   144.500  1372.218
   145.000  1375.204
   145.500  1378.180
   146.000  1381.147
   146.500  1384.105
   147.000  1387.053
   147.500  1389.992
   148.000  1392.922
   148.500  1395.842
   149.000  1398.753
   149.500  1401.654
   150.000  1404.547
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.120
   100.500   827.342
   101.000   829.565
   101.500   831.788
   102.000   834.011
   102.500   836.234
   103.000   838.457
   103.500   840.679
   104.000   842.902
   104.500   845.125
   105.000   847.348
   105.500   849.571
   106.000   851.794
   106.500   854.016
   107.000   856.239
   107.500   858.462
   108.000   860.685
   108.500   862.908
   109.000   865.131
   109.500   867.353
   110.000   869.576
   110.500   871.799
   111.000   874.022
   111.500   876.245
   112.000   878.468
   112.500   880.690
   113.000   882.913
   113.500   885.136
   114.000   887.359
   114.500   889.582
   115.000   891.805
   115.500   894.027
   116.000   896.250
   116.500   898.473
   117.000   900.696
   117.500   902.919
   118.000   905.142
   118.500   907.364
   119.000   909.587
   119.500   911.810
   120.000   914.033
   120.500   916.256
   121.000   918.479
   121.500   920.701
   122.000   922.924
   122.500   925.147
   123.000   927.370
   123.500   929.593
   124.000   931.816
   124.500   934.039
   125.000   936.261
   125.500   938.484
   126.000   940.707
   126.500   942.930
   127.000   945.153
   127.500   947.375
   128.000   949.598
   128.500   951.821
   129.000   954.044
   129.500   956.267
   130.000   958.490
   130.500   960.713
   131.000   962.935
   131.500   965.158
   132.000   967.381
   132.500   969.604
   133.000   971.827
   133.500   974.050
   134.000   976.272
   134.500   978.495
   135.000   980.718
   135.500   982.941
   136.000   985.164
   136.500   987.386
   137.000   989.609
   137.500   991.832
   138.000   994.055
   138.500   996.278
   139.000   998.501
   139.500  1000.724
   140.000  1002.946
   140.500  1005.169
   141.000  1007.392
   141.500  1009.615
   142.000  1011.838
   142.500  1014.061
   143.000  1016.283
   143.500  1018.506
   144.000  1020.729
   144.500  1022.952
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   385.402
    15.000   395.640
    15.500   405.875
    16.000   416.103
    16.500   426.320
    17.000   436.523
    17.500   446.708
    18.000   456.870
    18.500   467.003
    19.000   477.103
    19.500   487.164
    20.000   497.178
    20.500   507.141
    21.000   517.047
    21.500   526.889
    22.000   536.664
    22.500   546.366
    23.000   555.029
    23.500   563.171
    24.000   571.280
    24.500   579.357
    25.000   587.389
    25.500   595.342
    26.000   603.254
    26.500   611.154
    27.000   619.045
    27.500   626.929
    28.000   634.806
    28.500   642.676
    29.000   650.540
    29.500   658.397
    30.000   666.247
    30.500   674.089
    31.000   681.921
    31.500   689.741
    32.000   697.549
    32.500   705.343
    33.000   713.122
    33.500   720.883
    34.000   728.627
    34.500   736.352
    35.000   744.058
    35.500   751.745
    36.000   759.412
    36.500   767.059
    37.000   774.686
    37.500   782.292
    38.000   789.877
    38.500   797.440
    39.000   804.981
    39.500   812.500
    40.000   819.996
    40.500   827.469
    41.000   834.918
    41.500   842.344
    42.000   849.746
    42.500   857.124
    43.000   864.477
    43.500   871.806
    44.000   879.110
    44.500   886.389
    45.000   893.643
    45.500   900.872
    46.000   908.075
    46.500   915.252
    47.000   922.403
    47.500   929.528
    48.000   936.626
    48.500   943.698
    49.000   950.742
    49.500   957.759
    50.000   964.749
    50.500   971.713
    51.000   978.649
    51.500   985.557
    52.000   992.438
    52.500   999.291
    53.000  1006.117
    53.500  1012.917
    54.000  1019.692
    54.500  1026.440
    55.000  1033.161
    55.500  1039.855
    56.000  1046.522
    56.500  1053.161
    57.000  1059.771
    57.500  1066.354
    58.000  1072.909
    58.500  1079.436
    59.000  1085.935
    59.500  1092.406
    60.000  1098.850
    60.500  1105.266
    61.000  1111.655
    61.500  1118.015
    62.000  1124.347
    62.500  1130.651
    63.000  1136.926
    63.500  1143.172
    64.000  1149.390
    64.500  1155.580
    65.000  1161.742
    65.500  1167.875
    66.000  1173.980
    66.500  1180.057
    67.000  1186.106
    67.500  1192.126
    68.000  1198.117
    68.500  1204.080
    69.000  1210.014
    69.500  1215.920
    70.000  1221.797
    70.500  1227.645
    71.000  1233.464
    71.500  1239.255
    72.000  1245.016
    72.500  1250.748
    73.000  1256.450
    73.500  1262.122
    74.000  1267.764
    74.500  1273.376
    75.000  1278.958
    75.500  1284.511
    76.000  1290.035
    76.500  1295.529
    77.000  1300.994
    77.500  1306.429
    78.000  1311.833
    78.500  1317.207
    79.000  1322.551
    79.500  1327.865
    80.000  1333.151
    80.500  1338.406
    81.000  1343.632
    81.500  1348.827
    82.000  1353.989
    82.500  1359.120
    83.000  1364.219
    83.500  1369.286
    84.000  1374.323
    84.500  1379.328
    85.000  1384.302
    85.500  1389.245
    86.000  1394.156
    86.500  1399.036
    87.000  1403.882
    87.500  1408.697
    88.000  1413.478
    88.500  1418.227
    89.000  1422.942
    89.500  1427.623
    90.000  1432.271
    90.500  1436.886
    91.000  1441.466
    91.500  1446.013
    92.000  1450.525
    92.500  1455.004
    93.000  1459.449
    93.500  1463.860
    94.000  1468.245
    94.500  1472.613
    95.000  1476.968
    95.500  1481.311
    96.000  1485.643
    96.500  1489.961
    97.000  1494.263
    97.500  1498.545
    98.000  1502.807
    98.500  1507.049
    99.000  1511.272
    99.500  1515.474
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   720.438
     1.000   720.485
     1.500   720.563
     2.000   720.672
     2.500   720.812
     3.000   720.983
     3.500   721.185
     4.000   721.418
     4.500   721.682
     5.000   721.977
     5.500   722.302
     6.000   722.659
     6.500   723.045
     7.000   723.463
     7.500   723.910
     8.000   724.388
     8.500   724.897
     9.000   725.435
     9.500   726.003
    10.000   726.601
    10.500   727.229
    11.000   727.886
    11.500   728.572
    12.000   729.288
    12.500   730.032
    13.000   730.806
    13.500   731.608
    14.000   732.438
    14.500   733.297
    15.000   734.184
    15.500   735.099
    16.000   736.041
    16.500   737.011
    17.000   738.008
    17.500   739.032
    18.000   740.082
    18.500   741.160
    19.000   742.263
    19.500   743.393
    20.000   744.548
    20.500   745.729
    21.000   746.934
    21.500   748.165
    22.000   749.421
    22.500   750.701
    23.000   752.005
    23.500   753.334
    24.000   754.685
    24.500   756.060
    25.000   757.459
    25.500   758.879
    26.000   760.323
    26.500   761.788
    27.000   763.275
    27.500   764.784
    28.000   766.314
    28.500   767.864
    29.000   769.436
    29.500   771.027
    30.000   772.639
    30.500   774.270
    31.000   775.920
    31.500   777.590
    32.000   779.278
    32.500   780.984
    33.000   782.709
    33.500   784.451
    34.000   786.210
    34.500   787.987
    35.000   789.780
    35.500   791.589
    36.000   793.415
    36.500   795.256
    37.000   797.112
    37.500   798.984
    38.000   800.870
    38.500   802.771
    39.000   804.685
    39.500   806.613
    40.000   808.555
    40.500   810.509
    41.000   812.476
    41.500   814.456
    42.000   816.447
    42.500   818.450
    43.000   820.465
    43.500   822.490
    44.000   824.526
    44.500   826.573
    45.000   828.629
    45.500   830.695
    46.000   832.771
    46.500   834.855
    47.000   836.948
    47.500   839.050
    48.000   841.160
    48.500   843.277
    49.000   845.402
    49.500   847.534
    50.000   849.673
    50.500   851.819
    51.000   853.970
    51.500   856.128
    52.000   858.291
    52.500   860.460
    53.000   862.634
    53.500   864.812
    54.000   866.995
    54.500   869.183
    55.000   871.374
    55.500   873.569
    56.000   875.768
    56.500   877.969
    57.000   880.174
    57.500   882.381
    58.000   884.591
    58.500   886.803
    59.000   889.017
    59.500   891.233
    60.000   893.450
    60.500   895.669
    61.000   897.889
    61.500   900.110
    62.000   902.332
    62.500   904.554
    63.000   906.777
    63.500   908.999
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   932.492
     1.000   932.559
     1.500   932.670
     2.000   932.825
     2.500   933.024
     3.000   933.267
     3.500   933.555
     4.000   933.886
     4.500   934.262
     5.000   934.682
     5.500   935.145
     6.000   935.652
     6.500   936.203
     7.000   936.798
     7.500   937.436
     8.000   938.117
     8.500   938.842
     9.000   939.610
     9.500   940.420
    10.000   941.274
    10.500   942.170
    11.000   943.108
    11.500   944.089
    12.000   945.112
    12.500   946.177
    13.000   947.284
    13.500   948.432
    14.000   949.621
    14.500   950.852
    15.000   952.124
    15.500   953.436
    16.000   954.789
    16.500   956.182
    17.000   957.615
    17.500   959.087
    18.000   960.599
    18.500   962.151
    19.000   963.741
    19.500   965.370
    20.000   967.037
    20.500   968.743
    21.000   970.486
    21.500   972.267
    22.000   974.085
    22.500   975.941
    23.000   977.833
    23.500   979.761
    24.000   981.725
    24.500   983.726
    25.000   985.761
    25.500   987.832
    26.000   989.938
    26.500   992.078
    27.000   994.253
    27.500   996.461
    28.000   998.703
    28.500  1000.978
    29.000  1003.287
    29.500  1005.627
    30.000  1008.000
    30.500  1010.405
    31.000  1012.842
    31.500  1015.310
    32.000  1017.808
    32.500  1020.338
    33.000  1022.897
    33.500  1025.487
    34.000  1028.106
    34.500  1030.754
    35.000  1033.432
    35.500  1036.137
    36.000  1038.872
    36.500  1041.634
    37.000  1044.423
    37.500  1047.240
    38.000  1050.083
    38.500  1052.954
    39.000  1055.850
    39.500  1058.772
    40.000  1061.720
    40.500  1064.693
    41.000  1067.691
    41.500  1070.714
    42.000  1073.761
    42.500  1076.831
    43.000  1079.926
    43.500  1083.043
    44.000  1086.183
    44.500  1089.347
    45.000  1092.532
    45.500  1095.739
    46.000  1098.968
    46.500  1102.218
    47.000  1105.490
    47.500  1108.782
    48.000  1112.094
    48.500  1115.426
    49.000  1118.779
    49.500  1122.151
    50.000  1125.541
    50.500  1128.951
    51.000  1132.380
    51.500  1135.826
    52.000  1139.291
    52.500  1142.773
    53.000  1146.273
    53.500  1149.790
    54.000  1153.324
    54.500  1156.874
    55.000  1160.440
    55.500  1164.023
    56.000  1167.621
    56.500  1171.235
    57.000  1174.864
    57.500  1178.508
    58.000  1182.166
    58.500  1185.839
    59.000  1189.526
    59.500  1193.227
    60.000  1196.942
    60.500  1200.669
    61.000  1204.410
    61.500  1208.164
    62.000  1211.930
    62.500  1215.709
    63.000  1219.500
    63.500  1223.302
    64.000  1227.117
    64.500  1230.943
    65.000  1234.779
    65.500  1238.627
    66.000  1242.486
    66.500  1246.355
    67.000  1250.234
    67.500  1254.124
    68.000  1258.023
    68.500  1261.931
    69.000  1265.850
    69.500  1269.777
    70.000  1273.713
    70.500  1277.658
    71.000  1281.612
    71.500  1285.574
    72.000  1289.544
    72.500  1293.522
    73.000  1297.508
    73.500  1301.501
    74.000  1305.502
    74.500  1309.510
    75.000  1313.525
    75.500  1317.547
    76.000  1321.576
    76.500  1325.610
    77.000  1329.652
    77.500  1333.699
    78.000  1337.752
    78.500  1341.811
    79.000  1345.875
    79.500  1349.945
    80.000  1354.021
    80.500  1358.101
    81.000  1362.186
    81.500  1366.276
    82.000  1370.370
    82.500  1374.469
    83.000  1378.573
    83.500  1382.680
    84.000  1386.791
    84.500  1390.906
    85.000  1395.026
    85.500  1399.148
    86.000  1403.274
    86.500  1407.403
    87.000  1411.535
    87.500  1415.670
    88.000  1419.808
    88.500  1423.949
    89.000  1428.093
    89.500  1432.238
    90.000  1436.386
    90.500  1440.537
    91.000  1444.689
    91.500  1448.844
    92.000  1453.000
    92.500  1457.158
    93.000  1461.317
    93.500  1465.478
    94.000  1469.641
    94.500  1473.804
    95.000  1477.969
    95.500  1482.135
    96.000  1486.302
    96.500  1490.469
    97.000  1494.637
    97.500  1498.806
    98.000  1502.976
    98.500  1507.145
    99.000  1511.315
    99.500  1515.485
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   773.356
    29.500   783.595
    30.000   793.833
    30.500   804.070
    31.000   814.304
    31.500   824.534
    32.000   834.760
    32.500   844.982
    33.000   855.197
    33.500   865.406
    34.000   875.606
    34.500   885.798
    35.000   895.980
    35.500   906.150
    36.000   916.308
    36.500   926.451
    37.000   936.580
    37.500   946.692
    38.000   956.786
    38.500   966.533
    39.000   976.914
    39.500   986.944
    40.000   996.950
    40.500  1006.931
    41.000  1016.885
    41.500  1026.810
    42.000  1036.706
    42.500  1046.570
    43.000  1056.401
    43.500  1066.199
    44.000  1075.962
    44.500  1085.688
    45.000  1095.377
    45.500  1104.741
    46.000  1112.911
    46.500  1121.064
    47.000  1129.200
    47.500  1137.320
    48.000  1145.423
    48.500  1153.510
    49.000  1161.579
    49.500  1169.628
    50.000  1177.651
    50.500  1185.636
    51.000  1193.567
    51.500  1201.483
    52.000  1209.392
    52.500  1217.295
    53.000  1225.193
    53.500  1233.087
    54.000  1240.977
    54.500  1248.863
    55.000  1256.745
    55.500  1264.624
    56.000  1272.500
    56.500  1280.372
    57.000  1288.242
    57.500  1296.107
    58.000  1303.970
    58.500  1311.829
    59.000  1319.685
    59.500  1327.537
    60.000  1335.386
    60.500  1343.230
    61.000  1351.070
    61.500  1358.905
    62.000  1366.735
    62.500  1374.560
    63.000  1382.378
    63.500  1390.190
    64.000  1397.995
    64.500  1405.794
    65.000  1413.585
    65.500  1421.368
    66.000  1429.143
    66.500  1436.910
    67.000  1444.668
    67.500  1452.418
    68.000  1460.158
    68.500  1467.889
    69.000  1475.611
    69.500  1483.323
    70.000  1491.025
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     0.867    15.540     0.150
     0.867    26.170     0.150
     0.867    38.100     0.150
     1.596    27.500     0.150
     1.596    52.031     0.150
     2.238    67.796     0.150
     0.901    30.734     0.150
     2.779    44.438     0.150
     0.580    17.020     0.150
     0.580    25.621     0.150
     1.295    27.621     0.150
     1.295    64.242     0.150
     1.482    28.219     0.150
     1.482    28.219     0.150
     1.482    57.250     0.150
     1.666    28.781     0.150
     2.363    47.230     0.150
     3.786   102.559     0.150
     5.380    83.555     0.150
     0.568    17.062     0.150
     0.568    25.762     0.150
     1.302    28.633     0.150
     1.302    55.164     0.150
     1.493    30.332     0.150
     1.493    57.344     0.150
     2.103    63.973     0.150
     1.486    57.670     0.150
     3.769   103.316     0.150
     0.542    17.664     0.150
     0.542    34.570     0.150
     0.773    12.734     0.150
     0.773    22.094     0.150
     0.773    12.734     0.150
     0.773    22.094     0.150
     0.773    25.188     0.150
     0.773    43.641     0.150
     1.080    17.656     0.150
     1.080    30.109     0.150
     1.080    65.609     0.150
     1.080    71.289     0.150
     1.046    33.219     0.150
     1.046    44.664     0.150
     1.046    48.117     0.150
     1.314    22.109     0.150
     1.314    51.805     0.150
     1.314    52.516     0.150
     1.699    27.594     0.150
     1.951    32.164     0.150
     2.615    45.742     0.150
     2.615    50.570     0.150
     2.615    82.039     0.150
     9.127   134.742     0.150
     9.127   288.516     0.150
     9.573   140.695     0.150
     9.573   303.914     0.150
    11.783   171.875     0.150
    16.747   238.867     0.150
    38.744   447.516     0.150
     0.570    10.516     0.150
     0.570    18.312     0.150
     1.067    42.195     0.150
     1.117    66.828     0.150
     1.117    20.266     0.150
     1.117    37.430     0.150
     1.352    42.156     0.150
     1.352    44.352     0.150
     1.352    53.930     0.150
     1.352    23.312     0.150
     1.352    42.156     0.150
     1.488    31.648     0.150
     1.488    54.812     0.150
     1.488    26.414     0.150
     1.874    30.570     0.150
     2.049    33.742     0.150
     2.701    43.930     0.150
     0.830    16.173     0.150
     0.830    26.963     0.150
     0.829    15.973     0.150
     0.947    18.923     0.150
     1.450    24.933     0.150
     1.450    30.133     0.150
     1.450    53.133     0.150
     1.681    28.853     0.150
     1.681    50.862     0.150
     1.783    30.163     0.150
     1.783    51.933     0.150
     2.477    50.562     0.150
     2.477    77.683     0.150
     3.436    53.343     0.150
     3.484   127.553     0.150
     4.166    62.553     0.150
     4.166   108.603     0.150
     5.111    92.062     0.150
     5.463    82.522     0.150
     5.936    87.812     0.150
     5.936   154.763     0.150
     6.045   200.532     0.150
     6.770    98.223     0.150
     6.970   141.362     0.150
     7.610   241.862     0.150
     7.697   243.753     0.150
     7.697   251.232     0.150
     1.599    46.383     0.150
     1.599    51.584     0.150
     1.601    26.324     0.150
     1.601    46.244     0.150
     1.744    74.254     0.150
     2.361    36.855     0.150
     2.534   101.283     0.150
     2.694    39.953     0.150
     2.694   133.303     0.150
     2.942    45.703     0.150
     2.942    80.244     0.150
     3.077    47.475     0.150
     3.077    83.033     0.150
     3.194    48.844     0.150
     3.221    49.053     0.150
     3.221    86.873     0.150
     3.221    49.074     0.150
     3.903    58.566     0.150
     4.185    62.016     0.150
     4.328    64.570     0.150
     4.393    65.750     0.150
     5.034    74.479     0.150
     5.431    80.254     0.150
     5.509    80.824     0.150
     5.718    83.275     0.150
     5.830    86.924     0.150
     6.067    87.750     0.150
     6.412    94.455     0.150
     6.894   100.541     0.150
     6.980   103.783     0.150
     7.189   107.184     0.150
     7.244   107.664     0.150
     7.294   108.734     0.150
     7.432   107.752     0.150
     7.894   116.703     0.150
     8.750   130.395     0.150
     9.160   138.713     0.150
     9.160   138.703     0.150
     9.616   140.773     0.150
     9.670   142.453     0.150
    10.334   153.984     0.150
    10.758   159.184     0.150
    10.802   158.803     0.150
    11.911   174.734     0.150
    12.116   176.873     0.150
    12.657   183.744     0.150
    12.853   187.914     0.150
    13.018   189.475     0.150
    13.682   198.395     0.150
    13.808   201.213     0.150
    13.877   198.213     0.150
    13.982   202.814     0.150
    14.426   209.043     0.150
    14.497   205.381     0.150
    14.497   206.475     0.150
    14.721   214.314     0.150
    14.795   211.900     0.150
    14.795   213.764     0.150
    14.858   210.443     0.150
    14.943   216.203     0.150
    15.683   224.414     0.150
    15.800   226.334     0.150
    15.902   224.363     0.150
    16.348   232.084     0.150
    16.322   231.004     0.150
    17.249   244.924     0.150
    17.824   252.154     0.150
    17.846   251.104     0.150
    18.024   251.113     0.150
    18.482   259.324     0.150
    19.649   270.225     0.150
    20.030   275.523     0.150
    21.432   289.824     0.150
    21.570   291.395     0.150
    22.725   303.324     0.150
    22.908   306.234     0.150
    23.132   308.975     0.150
    23.314   308.703     0.150
    24.476   321.414     0.150
    24.507   321.395     0.150
    26.133   336.584     0.150
    26.321   337.953     0.150
    28.151   355.963     0.150
    28.947   362.553     0.150
    38.440   444.594     0.150
    38.727   448.014     0.150
    38.739   448.475     0.150
    38.754   539.113     0.150
    38.760   448.264     0.150
    38.953   448.043     0.150
    39.000   451.553     0.150
    39.116   450.193     0.150
    40.095   459.334     0.150
    40.161   460.033     0.150
    40.400   460.404     0.150
    42.528   477.074     0.150
    45.238   496.744     0.150
    52.552   555.414     0.150
    56.377  1068.414     0.150
    57.492   590.314     0.150
    62.396   622.514     0.150
    65.349   642.713     0.150
    78.025   721.803     0.150
    78.151   724.613     0.150
    78.151   724.654     0.150
    80.494  1024.713     0.150
    80.494  1858.014     0.150
    81.823   738.514     0.150
    85.281   759.395     0.150
    86.750   769.514     0.150
    86.750   963.514     0.150
    86.750   769.514     0.150
    86.750   963.514     0.150
    86.750  1410.514     0.150
    86.750  1488.514     0.150
    86.750  2136.514     0.150
    88.880   776.213     0.150
    91.359   786.414     0.150
    91.682  2031.514     0.150
    92.418   793.213     0.150
    93.796  1434.514     0.150
    93.796   799.713     0.150
   110.300  1117.514     0.150
   114.836  1123.914     0.150
   119.686  1132.514     0.150
   144.705  1178.639     0.150
     1.350    20.992     0.150
     1.350    40.102     0.150
     1.350    58.914     0.150
     1.352    20.852     0.150
     1.352    36.004     0.150
     1.352    21.023     0.150
     1.352    20.852     0.150
     1.352    36.004     0.150
     2.106   124.703     0.150
     3.080    87.281     0.150
     3.183    43.875     0.150
     3.651    55.047     0.150
     5.174    77.844     0.150
     5.174   142.191     0.150
     5.419    82.707     0.150
     6.494    98.785     0.150
     6.971   116.254     0.150
     7.636   195.762     0.150
     7.636   237.223     0.150
     7.801   115.074     0.150
     8.434   122.102     0.150
     8.502   122.094     0.150
     9.044   136.172     0.150
    10.118   144.391     0.150
    10.242   142.562     0.150
    10.817   154.781     0.150
    11.169   159.832     0.150
    12.118   171.844     0.150
    12.338   175.832     0.150
    12.504   184.445     0.150
    13.044   189.254     0.150
    13.830   201.641     0.150
    13.941   198.512     0.150
    14.181   214.871     0.150
    14.178   199.934     0.150
    14.178   201.273     0.150
    14.917   219.363     0.150
    17.192   243.453     0.150
    17.643   247.043     0.150
    17.611   245.992     0.150
    18.663   264.191     0.150
    19.560   264.410     0.150
    19.919   271.910     0.150
    20.015   271.562     0.150
    20.407   282.352     0.150
    20.533   277.254     0.150
    21.033   287.797     0.150
    22.008   296.312     0.150
    22.053   299.762     0.150
    22.038   292.770     0.150
    22.400   299.742     0.150
    22.832   305.035     0.150
    23.266   311.672     0.150
    31.930   391.352     0.150
    37.082   436.383     0.150
    38.524   447.883     0.150
    39.786   458.121     0.150
    40.083   461.172     0.150
    40.174   462.484     0.150
    40.352   464.684     0.150
    40.451   464.512     0.150
    41.215   470.023     0.150
    45.788   501.871     0.150
    50.544   542.652     0.150
    56.731   609.062     0.150
    58.937  1069.863     0.150
    64.795   642.988     0.150
    82.684   748.012     0.150
   100.047   829.961     0.150
   109.588   876.164     0.150
   109.588  1153.164     0.150
   114.345  1124.664     0.150
     1.367    22.125     0.150
     1.367    52.508     0.150
     1.367    22.086     0.150
     1.367    49.719     0.150
     1.367    22.016     0.150
     1.369    23.008     0.150
     1.369    50.828     0.150
     1.369    22.984     0.150
     1.369    38.562     0.150
     2.104    43.117     0.150
     2.104    73.914     0.150
     2.104    43.117     0.150
     2.104    73.914     0.150
     2.572    39.758     0.150
     2.879    76.359     0.150
     3.050    47.633     0.150
     3.050    83.484     0.150
     3.223    49.758     0.150
     3.223    94.555     0.150
     3.197    48.570     0.150
     3.316    50.195     0.150
     3.527   101.328     0.150
     3.689    70.406     0.150
     3.689    56.055     0.150
     3.717    56.156     0.150
     3.820    57.414     0.150
     4.430    65.734     0.150
     4.430   122.680     0.150
     4.684   132.062     0.150
     5.055    84.375     0.150
     5.115    75.359     0.150
     5.279    78.258     0.150
     5.385   103.117     0.150
     5.421    84.445     0.150
     5.421    80.102     0.150
     5.468    80.656     0.150
     5.760   176.117     0.150
     6.323    96.156     0.150
     6.440   221.938     0.150
     6.440    97.359     0.150
     6.535    95.828     0.150
     6.631    99.359     0.150
     7.446   233.273     0.150
     7.356   114.109     0.150
     7.371   119.195     0.150
     7.680   198.055     0.150
     7.680   244.453     0.150
     7.680   113.258     0.150
     7.680   198.055     0.150
     7.865   114.336     0.150
     7.939   128.008     0.150
     8.026   248.000     0.150
     8.013   122.578     0.150
     8.051   119.656     0.150
     8.205   115.117     0.150
     8.495   133.664     0.150
     8.561   128.680     0.150
     8.715   131.086     0.150
     8.750   129.008     0.150
     8.768   131.875     0.150
     8.777   124.562     0.150
     8.766   128.656     0.150
     8.970   129.656     0.150
     9.134   270.953     0.150
     9.134   135.258     0.150
     9.277   141.906     0.150
     9.438   141.578     0.150
     9.641   142.758     0.150
    10.181   149.453     0.150
    10.870   159.844     0.150
    10.870   159.859     0.150
    11.220   164.555     0.150
    11.455   166.359     0.150
    12.217   175.859     0.150
    12.177   177.109     0.150
    12.168   179.156     0.150
    12.410   181.156     0.150
    12.666   396.133     0.150
    12.721   190.414     0.150
    12.900   194.156     0.150
    13.074   191.125     0.150
    13.172   422.547     0.150
    13.451   192.156     0.150
    13.996   202.797     0.150
    14.244   205.656     0.150
    14.291   204.156     0.150
    14.490   209.055     0.150
    14.490   371.453     0.150
    15.106   217.359     0.150
    15.556   223.719     0.150
    15.639   221.953     0.150
    15.687   222.258     0.150
    15.802   226.258     0.150
    17.253   243.758     0.150
    17.253   432.953     0.150
    17.636   246.953     0.150
    17.636   246.961     0.150
    17.827   571.133     0.150
    17.827   250.578     0.150
    17.827   571.133     0.150
    17.827   250.555     0.150
    18.674   262.430     0.150
    20.007   273.227     0.150
    20.168   277.156     0.150
    20.777   284.156     0.150
    21.057   285.258     0.150
    21.085   289.656     0.150
    21.306   293.406     0.150
    22.165   302.609     0.150
    22.561   301.758     0.150
    22.587   302.602     0.150
    22.723   301.891     0.150
    22.904   311.250     0.150
    23.267   311.406     0.150
    23.506   315.406     0.150
    23.710   319.328     0.150
    23.890   320.328     0.150
    23.882   313.859     0.150
    24.016   317.359     0.150
    24.026   318.359     0.150
    24.375   325.258     0.150
    24.589   329.305     0.150
    24.722   329.656     0.150
    24.771   328.055     0.150
    25.590   333.773     0.150
    25.620   330.258     0.150
    25.737   334.953     0.150
    25.980   335.359     0.150
    26.097   333.188     0.150
    26.520   342.773     0.150
    26.520   338.172     0.150
    28.356   362.219     0.150
    29.290   369.805     0.150
    29.508   371.078     0.150
    29.627   373.305     0.150
    32.224   395.750     0.150
    32.448   397.328     0.150
    32.452   397.828     0.150
    32.839   397.953     0.150
    33.866   407.438     0.150
    34.005   410.078     0.150
    34.603   415.930     0.150
    35.107   420.750     0.150
    38.414   444.859     0.150
    38.581   445.859     0.150
    39.462   452.359     0.150
    39.608   454.758     0.150
    40.234   460.453     0.150
    45.248   501.156     0.150
     5.070   502.273     0.150
    56.795   585.453     0.150
    62.582   624.656     0.150
    69.182   671.055     0.150
    78.445   722.156     0.150
    81.230   736.453     0.150
    82.884   747.453     0.150
    83.457   749.258     0.150
    84.059   752.297     0.150
    84.059   753.055     0.150
    84.981   760.359     0.150
    86.075   762.156     0.150
    86.075  1400.156     0.150
    86.799   766.859     0.150
    87.495   768.156     0.150
    87.969   771.453     0.150
    89.163   776.359     0.150
    89.301   778.305     0.150
    90.109   781.758     0.150
    90.179   779.805     0.150
    90.381   781.906     0.150
    90.681   784.055     0.150
    90.982  1410.555     0.150
    91.438   788.055     0.150
    93.106   795.625     0.150
    93.106   795.555     0.150
   114.395  1123.156     0.150
   118.132  1129.156     0.150
     1.036    18.633     0.150
     1.036    31.883     0.150
     1.037    18.562     0.150
     1.037    31.953     0.150
     1.401    24.023     0.150
     1.946    31.328     0.150
     1.946    55.883     0.150
     2.540    41.695     0.150
     4.467    60.312     0.150
     4.763    69.625     0.150
     1.481    26.359     0.150
     0.793    16.109     0.150
     0.793    28.988     0.150
     1.393    57.098     0.150
     1.393    24.438     0.150
     1.395    24.500     0.150
     1.395    42.949     0.150
     1.591    60.289     0.150
     1.905    31.430     0.150
     2.258    38.570     0.150
     2.960   120.258     0.150
     2.960    47.031     0.150
     3.046    42.438     0.150
     3.046    42.438     0.150
     3.013    47.719     0.150
     3.013    47.168     0.150
     3.013    66.281     0.150
     3.398    52.859     0.150
     3.398    52.199     0.150
     3.398   109.543     0.150
     3.621    55.824     0.150
     5.474    83.699     0.150
     6.629    97.949     0.150
     8.120   117.930     0.150
     8.932   130.711     0.150
     8.968   132.730     0.150
    11.011   162.938     0.150
    12.745   178.797     0.150
    13.328   191.500     0.150
    13.945   203.598     0.150
    14.193   206.469     0.150
    14.299   207.070     0.150
    14.672   210.891     0.150
    15.013   216.621     0.150
    17.467   242.914     0.150
    17.799   246.520     0.150
    18.027   249.746     0.150
    18.427   255.031     0.150
    18.676   259.301     0.150
    18.939   260.879     0.150
    25.039   326.430     0.150
    26.655   340.141     0.150
    32.877   398.180     0.150
    40.592   463.188     0.150
    41.416   469.270     0.150
   109.256   867.008     0.150
     0.794    15.772     0.150
     1.370    21.492     0.150
     1.376    24.042     0.150
     1.376    41.052     0.150
     1.376    24.042     0.150
     1.376    41.052     0.150
     1.378    24.073     0.150
     1.378    24.073     0.150
     1.378    40.262     0.150
     1.987    55.962     0.150
     1.987    31.414     0.150
     2.290    62.272     0.150
     2.290    36.662     0.150
     2.338   123.583     0.150
     2.803    44.032     0.150
     2.892    94.910     0.150
     2.960    47.272     0.150
     3.038    47.752     0.150
     3.479    53.472     0.150
     3.625    71.218     0.150
     3.741    54.992     0.150
     3.851    59.170     0.150
     4.200   132.361     0.150
     4.605   156.819     0.150
     4.625   156.562     0.150
     5.139    78.522     0.150
     5.337    82.765     0.150
     5.472    83.152     0.150
     5.461    80.742     0.150
     5.683    85.911     0.150
     5.846   148.302     0.150
     5.967   200.142     0.150
     6.476    97.083     0.150
     6.778   101.702     0.150
     6.860   102.392     0.150
     7.047   238.064     0.150
     7.623   108.552     0.150
     8.114   119.796     0.150
     8.320   117.823     0.150
     8.340   118.073     0.150
     8.765   131.172     0.150
     8.882   130.672     0.150
     9.126   130.182     0.150
     9.127   153.432     0.150
     9.127   130.323     0.150
    10.455   316.942     0.150
    10.455   153.353     0.150
    10.914   159.958     0.150
    11.749   175.755     0.150
    11.772   176.129     0.150
    12.359   174.932     0.150
    12.474   182.497     0.150
    12.569   177.083     0.150
    12.569   184.337     0.150
    12.652   177.212     0.150
    12.723   187.982     0.150
    12.828   188.140     0.150
    12.960   188.562     0.150
    12.960   179.422     0.150
    13.038   193.917     0.150
    12.997   192.797     0.150
    13.128   194.110     0.150
    13.346   197.402     0.150
    13.398   186.902     0.150
    13.531   188.412     0.150
    13.590   200.646     0.150
    13.669   199.932     0.150
    13.669   199.882     0.150
    13.740   199.532     0.150
    13.735   202.531     0.150
    14.015   203.902     0.150
    14.184   206.812     0.150
    14.400   201.122     0.150
    14.366   201.833     0.150
    14.366   206.703     0.150
    14.447   201.093     0.150
    14.396   201.422     0.150
    14.533   211.952     0.150
    14.551   202.692     0.150
    14.558   201.732     0.150
    14.558   201.772     0.150
    14.652   202.812     0.150
    14.659   203.742     0.150
    14.684   207.162     0.150
    14.702   204.532     0.150
    14.737   214.052     0.150
    14.743   204.442     0.150
    15.028   207.312     0.150
    15.274   220.157     0.150
    15.289   212.412     0.150
    15.703   215.833     0.150
    15.743   230.152     0.150
    15.846   217.502     0.150
    15.825   220.632     0.150
    15.825   220.612     0.150
    15.936   221.632     0.150
    15.936   221.672     0.150
    15.949   231.176     0.150
    16.067   223.302     0.150
    16.214   224.202     0.150
    16.330   225.922     0.150
    16.475   225.792     0.150
    16.498   233.843     0.150
    16.606   228.642     0.150
    16.530   229.603     0.150
    16.739   231.622     0.150
    16.830   232.353     0.150
    17.070   233.573     0.150
    17.257   235.122     0.150
    17.416   240.492     0.150
    17.472   243.892     0.150
    17.669   241.902     0.150
    17.775   246.502     0.150
    17.841   246.032     0.150
    17.841   246.073     0.150
    18.007   254.708     0.150
    18.081   254.182     0.150
    18.081   254.136     0.150
    18.465   253.502     0.150
    18.441   259.702     0.150
    18.441   262.448     0.150
    18.543   262.004     0.150
    18.725   257.593     0.150
    18.741   263.242     0.150
    19.013   266.688     0.150
    19.302   266.772     0.150
    19.308   262.682     0.150
    19.661   272.650     0.150
    20.038   277.802     0.150
    20.405   274.732     0.150
    20.405   274.742     0.150
    21.183   283.262     0.150
    21.257   290.853     0.150
    21.325   289.922     0.150
    22.708   300.083     0.150
    22.830   305.353     0.150
    24.032   313.962     0.150
    24.127   313.103     0.150
    24.179   739.032     0.150
    24.179   313.732     0.150
    24.179   313.702     0.150
    24.176   315.002     0.150
    24.247   314.732     0.150
    24.247   314.682     0.150
    24.265   318.902     0.150
    24.716   319.362     0.150
    25.044   322.012     0.150
    25.122   325.282     0.150
    25.158   325.583     0.150
    25.203   325.853     0.150
    25.302   329.357     0.150
    25.915   330.222     0.150
    25.945   794.802     0.150
    25.945   332.382     0.150
    26.168   333.952     0.150
    26.267   341.986     0.150
    26.296   339.910     0.150
    26.420   335.222     0.150
    26.957   344.198     0.150
    27.161   342.833     0.150
    27.161   342.802     0.150
    27.326   345.482     0.150
    28.062   345.042     0.150
    28.062   347.612     0.150
    27.372   346.942     0.150
    27.576   351.083     0.150
    27.984   352.402     0.150
    28.590   358.857     0.150
    28.741   357.232     0.150
    29.087   360.522     0.150
    29.318   367.980     0.150
    29.548   364.042     0.150
    29.540   365.152     0.150
    29.874   368.392     0.150
    29.874   371.393     0.150
    30.532   375.912     0.150
    30.824   376.752     0.150
    31.088   379.642     0.150
    31.727   383.902     0.150
    31.985   386.472     0.150
    32.499   390.343     0.150
    32.486   391.012     0.150
    32.629   394.339     0.150
    32.700   392.422     0.150
    33.114   394.073     0.150
    33.976   402.062     0.150
    34.101   403.843     0.150
    34.261   406.862     0.150
    37.269   429.492     0.150
    38.252   441.552     0.150
    38.368   442.902     0.150
    38.405   439.772     0.150
    38.619   442.532     0.150
    38.770   447.392     0.150
    39.703   455.682     0.150
    39.806   457.333     0.150
    39.838   457.030     0.150
    40.043   459.232     0.150
    40.067   453.732     0.150
    40.067   453.732     0.150
    40.440   462.052     0.150
    40.625   463.632     0.150
    41.498   464.552     0.150
    43.054   479.142     0.150
    45.487   497.032     0.150
    45.487   497.032     0.150
    46.640   511.712     0.150
    48.371   522.912     0.150
    50.901   541.583     0.150
    52.165   552.732     0.150
    57.092   584.932     0.150
    57.092   584.892     0.150
    58.339   600.432     0.150
    58.339   595.782     0.150
    59.992   607.542     0.150
    61.302   618.532     0.150
    61.988   621.333     0.150
    62.553   630.532     0.150
    62.553   630.552     0.150
    64.076   636.583     0.150
    65.021   644.433     0.150
    66.690   651.723     0.150
    68.216   663.262     0.150
    69.403   669.792     0.150
    71.084  5279.090     0.150
    71.090  5279.343     0.150
    71.102  5279.080     0.150
    76.213   707.152     0.150
    78.420   719.913     0.150
    78.250   720.333     0.150
    78.250   720.353     0.150
    78.285   726.532     0.150
    78.285   726.572     0.150
    78.743   724.632     0.150
    78.743   724.632     0.150
    79.119   724.502     0.150
    80.928   738.333     0.150
    81.381   740.933     0.150
    82.195   739.192     0.150
    83.044   744.302     0.150
    83.044   744.572     0.150
    83.020   744.292     0.150
    83.153   750.333     0.150
    83.157   750.333     0.150
    83.443   752.132     0.150
    83.726   747.873     0.150
    84.352   756.742     0.150
    84.352   756.683     0.150
    84.352   752.433     0.150
    84.352   752.413     0.150
    84.443   753.083     0.150
    84.706   759.152     0.150
    85.057   758.732     0.150
    86.372   765.757     0.150
    86.372   765.732     0.150
    86.647   764.333     0.150
    86.903   769.833     0.150
    87.095   766.232     0.150
    88.006   773.032     0.150
    88.168   774.333     0.150
    88.267   771.292     0.150
    88.472   770.183     0.150
    88.901   775.933     0.150
    89.526   782.562     0.150
    90.364   785.433     0.150
    90.405   784.032     0.150
    90.475   784.751     0.150
    90.577   785.238     0.150
    90.978   787.632     0.150
    91.735   791.433     0.150
    93.076   792.433     0.150
    93.076   792.453     0.150
    93.076   793.842     0.150
    93.385   793.862     0.150
    94.249   797.723     0.150
    96.289   809.042     0.150
   103.108   830.732     0.150
   114.538  1128.833     0.150
   117.972  1130.183     0.150
   119.816  1132.462     0.150
     0.590    14.203     0.150
     0.590    14.145     0.150
     0.590    24.375     0.150
     0.590    26.094     0.150
     0.590    26.125     0.150
     1.186    44.664     0.150
     1.186    49.023     0.150
     1.188    21.703     0.150
     1.207    39.496     0.150
     1.403    48.656     0.150
     1.925    31.715     0.150
     2.134    34.613     0.150
     2.134   106.164     0.150
     2.378    50.555     0.150
     3.136    51.227     0.150
     3.219    50.145     0.150
     3.219    50.164     0.150
     3.485    53.414     0.150
     3.605    56.035     0.150
     3.818    58.031     0.150
     3.916    59.914     0.150
     7.171   106.645     0.150
     7.968   119.395     0.150
    13.140   192.793     0.150
    13.638   196.172     0.150
    14.196   205.422     0.150
    18.136   256.695     0.150
    18.503   257.840     0.150
    20.342   280.406     0.150
    26.720   340.629     0.150
    27.627   348.953     0.150
    28.624   357.520     0.150
    29.891   369.973     0.150
    36.317   426.207     0.150
    44.263   492.605     0.150
    45.238   501.234     0.150
    45.292   498.625     0.150
    68.420   666.727     0.150
    78.638   724.504     0.150
    79.019   727.914     0.150
    83.373   750.105     0.150
    84.282   755.395     0.150
    84.282   754.496     0.150
    84.848   757.504     0.150
    86.287   763.871     0.150
    89.521   778.816     0.150
   142.800  1170.719     0.150
     0.671    14.766     0.150
     0.671    14.977     0.150
     0.671    25.539     0.150
     0.671    28.133     0.150
     1.272    22.305     0.150
     1.265    22.719     0.150
     1.487    55.680     0.150
     1.899    32.930     0.150
     1.899    32.680     0.150
     2.198   117.430     0.150
     2.661    43.430     0.150
     3.218    48.266     0.150
     3.713    56.914     0.150
     3.796    59.297     0.150
     3.849    60.328     0.150
     4.329    68.102     0.150
     4.510    68.828     0.150
     4.581    70.555     0.150
     5.194    79.211     0.150
     5.829    88.719     0.150
     6.508    95.211     0.150
     7.189   108.914     0.150
     7.633    98.109     0.150
     7.891   111.812     0.150
     7.973   118.945     0.150
     8.267   117.867     0.150
     8.623   124.266     0.150
     8.669   133.438     0.150
     8.910   131.977     0.150
     8.935   128.109     0.150
     8.947   129.523     0.150
     9.143   130.406     0.150
     9.176   300.109     0.150
     9.483   134.344     0.150
    10.502   148.359     0.150
    10.772   158.266     0.150
    10.807   159.742     0.150
    10.896   156.336     0.150
    10.958   154.344     0.150
    11.368   161.578     0.150
    12.195   169.859     0.150
    12.376   175.586     0.150
    12.460   179.109     0.150
    12.839   190.312     0.150
    13.207   186.758     0.150
    13.270   188.203     0.150
    13.341   187.094     0.150
    13.404   186.617     0.150
    13.445   190.609     0.150
    13.632   196.562     0.150
    13.632   197.367     0.150
    13.888   201.195     0.150
    14.037   198.125     0.150
    14.380   206.398     0.150
    14.617   209.664     0.150
    15.689   227.094     0.150
    17.835   236.609     0.150
    17.941   247.719     0.150
    18.401   254.461     0.150
    18.436   253.984     0.150
    18.695   257.258     0.150
    19.232   259.695     0.150
    20.022   271.828     0.150
    20.116   273.359     0.150
    20.358   273.977     0.150
    20.996   282.258     0.150
    21.201   284.156     0.150
    21.487   291.812     0.150
    21.495   287.164     0.150
    21.761   289.688     0.150
    22.271   297.109     0.150
    22.322   295.727     0.150
    22.384   295.945     0.150
    23.031   303.523     0.150
    23.200   311.703     0.150
    23.739   311.703     0.150
    25.157   325.164     0.150
    25.190   329.367     0.150
    25.263   329.156     0.150
    25.795   328.992     0.150
    25.933   337.367     0.150
    26.175   331.336     0.150
    26.634   344.312     0.150
    26.720   344.656     0.150
    27.158   347.062     0.150
    30.034   373.539     0.150
    30.034   368.867     0.150
    31.521   381.336     0.150
    32.662   389.867     0.150
    32.996   400.016     0.150
    33.933   403.508     0.150
    35.893   419.375     0.150
    36.267   429.727     0.150
    36.602   431.883     0.150
    38.254   438.336     0.150
    38.263   438.383     0.150
    38.564   442.289     0.150
    38.662   442.273     0.150
    39.902   453.609     0.150
    40.484   459.109     0.150
    40.558   457.805     0.150
    42.046   471.258     0.150
    43.380   491.180     0.150
    44.280   496.453     0.150
    44.718   499.969     0.150
    44.949   501.727     0.150
    45.023   499.094     0.150
    45.151   504.367     0.150
    45.311   505.023     0.150
     5.161   500.805     0.150
    45.884   507.008     0.150
    45.884   501.367     0.150
    47.059   511.078     0.150
    56.978   589.633     0.150
    64.882   643.078     0.150
    65.221   641.047     0.150
    75.207   700.234     0.150
    78.312   725.430     0.150
    78.368   724.914     0.150
    78.368   719.555     0.150
    78.381   726.570     0.150
    78.381   719.484     0.150
    78.634   726.039     0.150
    78.634   726.039     0.150
    82.926   748.789     0.150
    82.926   749.227     0.150
    83.352   745.023     0.150
    84.262   755.680     0.150
    86.274  2012.836     0.150
    86.274  2126.836     0.150
    86.997   769.469     0.150
    88.377   775.281     0.150
    93.988   795.023     0.150
   119.804  1134.281     0.150
   123.654  1141.883     0.150
   138.538  1159.836     0.150
     0.856    13.016     0.150
     0.856    22.688     0.150
     0.856    13.016     0.150
     0.856    22.848     0.150
     0.743    14.637     0.150
     0.929    17.527     0.150
     1.043    19.195     0.150
     1.043    33.617     0.150
     1.043    19.125     0.150
     1.042    19.188     0.150
     1.352    41.988     0.150
     1.352    24.078     0.150
     1.484    25.855     0.150
     1.484    25.855     0.150
     1.484    45.105     0.150
     1.905    31.906     0.150
     1.905    66.918     0.150
     1.953    32.188     0.150
     1.953    62.348     0.150
     2.471    39.867     0.150
     2.490    83.168     0.150
     2.490    45.047     0.150
     3.238    49.809     0.150
     3.238    97.668     0.150
     7.373   114.297     0.150
     7.797   114.387     0.150
    11.714   176.270     0.150
     0.784    17.217     0.150
     0.784    31.877     0.150
     0.784    17.437     0.150
     0.784    32.197     0.150
     1.406    21.337     0.150
     1.406    36.907     0.150
     1.406    21.437     0.150
     2.045    38.147     0.150
     2.182    63.167     0.150
     2.182    34.657     0.150
     2.182    34.607     0.150
     2.203    39.097     0.150
     2.334    58.007     0.150
     2.334    32.637     0.150
     2.334    58.007     0.150
     2.375    39.947     0.150
     2.375   121.837     0.150
     2.375   141.517     0.150
     2.918    45.757     0.150
     2.918    79.527     0.150
     2.918    45.857     0.150
     3.012    45.447     0.150
     3.012    81.337     0.150
     3.290    54.567     0.150
     3.392    49.487     0.150
     3.586    53.845     0.150
     3.783    52.927     0.150
     4.016    59.833     0.150
     4.103    61.173     0.150
     4.719    69.114     0.150
     5.382    81.517     0.150
     5.382    79.279     0.150
     5.486    80.577     0.150
     5.613    81.647     0.150
     6.054   186.187     0.150
     6.054   186.187     0.150
     6.054   197.729     0.150
     6.143    92.837     0.150
     7.377   105.157     0.150
     7.647   110.557     0.150
     7.647   109.397     0.150
     7.647   206.497     0.150
     7.820   214.307     0.150
     8.151   203.762     0.150
     8.224   124.427     0.150
    11.043   161.027     0.150
    11.092   160.631     0.150
    11.642   167.512     0.150
    12.733   182.339     0.150
    13.064   180.786     0.150
    13.719   198.237     0.150
    14.199   205.027     0.150
    14.560   210.537     0.150
    15.994   230.737     0.150
    17.981   249.449     0.150
    18.177   253.537     0.150
    18.546   254.607     0.150
    18.644   256.627     0.150
    18.644   258.365     0.150
    19.218   265.297     0.150
    19.218   265.618     0.150
    19.597   269.887     0.150
    20.623   279.890     0.150
    22.550   302.327     0.150
    24.915   323.910     0.150
    25.690   329.377     0.150
    25.990   336.567     0.150
    25.947   333.917     0.150
    26.063   333.537     0.150
    27.899   348.361     0.150
    28.798   361.047     0.150
    29.758   369.437     0.150
    30.084   369.170     0.150
    39.118   446.517     0.150
    39.535   448.798     0.150
    40.498   456.946     0.150
    40.686   459.263     0.150
    40.726   459.817     0.150
    40.994   461.780     0.150
    41.016   460.765     0.150
    41.135   461.476     0.150
    41.352   463.990     0.150
    41.516   465.836     0.150
    41.693   467.247     0.150
    42.209   472.731     0.150
    44.289   491.157     0.150
    44.466   498.387     0.150
    46.487   510.827     0.150
    46.661   511.987     0.150
    49.035   525.023     0.150
    78.393   723.947     0.150
    78.919   732.667     0.150
    87.983   777.837     0.150
    88.269   779.612     0.150
    88.582   782.554     0.150
    88.672   782.142     0.150
    88.766   783.260     0.150
    88.846   783.548     0.150
    88.894   785.587     0.150
    89.563   776.927     0.150
    89.563   776.927     0.150
    89.563  1104.577     0.150
    89.563  2000.107     0.150
    89.635   786.850     0.150
    89.649   788.380     0.150
    89.788   787.438     0.150
    90.309   789.674     0.150
    90.768   791.087     0.150
    90.867   791.969     0.150
   108.515   868.867     0.150
   108.515   879.567     0.150
   108.515   883.067     0.150
     0.797    16.573     0.150
     0.797    31.603     0.150
     0.797    16.693     0.150
     0.797    30.483     0.150
     1.393    20.243     0.150
     1.393    37.063     0.150
     1.393    20.543     0.150
     2.034    33.013     0.150
     2.171    33.653     0.150
     2.171    33.563     0.150
     2.171    60.143     0.150
     2.171    33.383     0.150
     2.171    33.410     0.150
     2.213    38.003     0.150
     2.386    40.543     0.150
     2.891    43.717     0.150
     2.936    81.463     0.150
     3.029    47.133     0.150
     3.029    83.133     0.150
     3.309    54.333     0.150
     3.377    86.403     0.150
     3.762    54.343     0.150
     4.105    60.917     0.150
     5.403    81.943     0.150
     5.463   157.723     0.150
     5.463    79.593     0.150
     5.463   157.723     0.150
     6.034   167.243     0.150
     6.034   167.243     0.150
     6.153    93.073     0.150
     6.516   154.073     0.150
     7.352   106.542     0.150
     7.360   103.953     0.150
     7.632   107.893     0.150
     7.632   207.103     0.150
     7.632   107.893     0.150
     7.632   207.103     0.150
     7.632   110.283     0.150
     8.135   116.314     0.150
     8.246   233.053     0.150
     8.246   117.023     0.150
     8.246   233.053     0.150
     8.821   131.793     0.150
    12.747   183.971     0.150
    13.717   197.653     0.150
    13.855   198.023     0.150
    13.910   200.238     0.150
    14.212   205.263     0.150
    14.419   213.563     0.150
    14.447   207.186     0.150
    14.635   209.433     0.150
    14.888   213.783     0.150
    15.992   228.363     0.150
    16.111   229.032     0.150
    16.618   235.789     0.150
    18.182   562.347     0.150
    18.182   254.499     0.150
    18.623   258.823     0.150
    18.694   260.119     0.150
    18.910   262.783     0.150
    20.941   285.273     0.150
    20.941   285.125     0.150
    22.537   302.343     0.150
    23.383   312.323     0.150
    26.049   335.443     0.150
    26.612   342.023     0.150
    27.338   348.333     0.150
    27.761   352.243     0.150
    28.779   360.893     0.150
    28.828   361.463     0.150
    30.066   372.573     0.150
    30.066   368.819     0.150
    35.354   416.658     0.150
    35.528   420.783     0.150
    35.528   419.358     0.150
    36.483   428.229     0.150
    36.824   429.343     0.150
    37.427   435.753     0.150
    38.419   444.718     0.150
    38.809   447.481     0.150
    40.092   457.758     0.150
    40.530   461.877     0.150
    42.222   475.224     0.150
    44.267   489.483     0.150
    45.155   496.663     0.150
    46.674   509.477     0.150
    65.046   641.028     0.150
    75.071   705.143     0.150
    86.550  1400.203     0.150
    86.550  1483.203     0.150
    86.550  1970.203     0.150
   144.210  1177.953     0.150
     0.567    12.789     0.150
     0.567    12.438     0.150
     0.567    22.859     0.150
     1.188    23.816     0.150
     1.188    26.059     0.150
     1.622    30.930     0.150
     1.622    33.758     0.150
     1.716    35.699     0.150
     1.716    32.258     0.150
     1.716    34.949     0.150
     1.818    56.555     0.150
     1.880    32.117     0.150
     2.527    38.711     0.150
     3.385    53.438     0.150
     3.718    56.891     0.150
     4.375    68.074     0.150
     5.469    81.691     0.150
     5.822    84.309     0.150
     5.884    86.984     0.150
     8.490   121.059     0.150
     9.070   130.008     0.150
    10.548   149.199     0.150
    12.280   175.598     0.150
    13.766   196.609     0.150
    14.289   204.488     0.150
    14.301   205.941     0.150
    14.857   217.668     0.150
    15.304   215.617     0.150
    15.841   226.809     0.150
    18.662   258.477     0.150
    20.175   275.566     0.150
    22.193   297.418     0.150
    25.221   325.270     0.150
    38.122   437.297     0.150
    38.122   437.719     0.150
    40.115   457.277     0.150
    40.352   457.867     0.150
    40.486   461.395     0.150
    41.330   467.891     0.150
    82.794   745.816     0.150
    83.037   746.418     0.150
    83.629   749.719     0.150
    84.173   751.188     0.150
    84.173   753.430     0.150
    88.297   772.559     0.150
    89.270   780.617     0.150
     0.711    11.914     0.150
     0.711    20.465     0.150
     0.711    11.965     0.150
     0.711    20.504     0.150
     0.711    12.066     0.150
     0.711    20.266     0.150
     0.711    20.926     0.150
     0.753    14.574     0.150
     1.004    18.516     0.150
     1.065    33.645     0.150
     1.162    23.555     0.150
     1.228    67.293     0.150
     1.228    68.773     0.150
     1.352    24.164     0.150
     1.379    41.344     0.150
     1.379    24.066     0.150
     1.890    63.535     0.150
     2.136    34.625     0.150
     2.303    35.285     0.150
     6.161    89.633     0.150
     0.570    20.351     0.150
     0.742    12.121     0.150
     0.742    20.561     0.150
     0.742    12.111     0.150
     0.742    20.591     0.150
     0.796    14.951     0.150
     0.796    26.381     0.150
     1.155    71.611     0.150
     1.155    74.891     0.150
     1.403    24.521     0.150
     1.534    27.011     0.150
     0.828    17.575     0.150
     0.828    30.365     0.150
     0.828    41.916     0.150
     0.828    17.575     0.150
     0.828    30.355     0.150
     1.353    23.705     0.150
     1.362    39.896     0.150
     1.469    55.336     0.150
     1.786    29.876     0.150
     2.214    71.355     0.150
     2.417   107.176     0.150
     2.417   116.756     0.150
     0.117     5.314     0.150
     0.117     9.076     0.150
     0.117     9.266     0.150
     0.117     5.275     0.150
     0.117     9.105     0.150
     0.640    20.115     0.150
     0.640    11.756     0.150
     0.640    20.195     0.150
     0.952    28.805     0.150
     0.952    36.715     0.150
     0.994    33.605     0.150
     1.406    49.904     0.150
     1.051    16.688     0.150
     1.051    16.535     0.150
     1.051    29.227     0.150
     1.051    16.625     0.150
     1.051    29.578     0.150
     1.051    33.605     0.150
     1.395    22.578     0.150
     1.717    54.016     0.150
     2.213    33.719     0.150
     2.463    97.367     0.150
     2.463   111.297     0.150
     2.898    51.688     0.150
     3.301    57.176     0.150
     3.682   110.395     0.150
     3.949    56.781     0.150
     3.956    69.051     0.150
     4.279   128.215     0.150
     4.434    68.355     0.150
     4.824   140.516     0.150
     4.963   145.879     0.150
     5.021   150.969     0.150
     5.238    89.105     0.150
     5.381   161.961     0.150
     5.703   171.039     0.150
     5.864   174.211     0.150
     5.938    94.645     0.150
     5.983   105.938     0.150
     6.311   188.773     0.150
     6.381    96.984     0.150
     6.569   197.363     0.150
     7.014   103.715     0.150
     8.155   117.375     0.150
     8.155   191.750     0.150
    10.313   153.156     0.150
    10.519   147.715     0.150
    10.779   157.465     0.150
    11.107   160.316     0.150
    11.670   172.176     0.150
    11.974   176.328     0.150
    12.699   182.105     0.150
    12.786   186.445     0.150
    12.786   186.406     0.150
    12.874   187.426     0.150
    13.332   193.316     0.150
    13.420   195.215     0.150
    13.420   195.156     0.150
    13.638   197.707     0.150
    13.780   197.465     0.150
    14.005   201.637     0.150
    14.890   206.176     0.150
    15.008   220.438     0.150
    16.688   238.098     0.150
    19.531   270.105     0.150
    20.603   282.418     0.150
    22.572   297.625     0.150
    22.611   303.047     0.150
    22.893   307.965     0.150
    22.978   308.578     0.150
    23.046   300.797     0.150
    42.346   479.137     0.150
    43.182   486.855     0.150
     9.072   653.867     0.150
    74.883   704.898     0.150
    97.632   820.758     0.150
   100.255   832.555     0.150
   122.080  1139.445     0.150
     0.581    11.336     0.150
     0.581    18.984     0.150
     0.581    11.438     0.150
     0.581    19.078     0.150
     0.581    20.578     0.150
     0.581    21.188     0.150
     0.875    38.508     0.150
     0.913    64.383     0.150
     0.913    65.727     0.150
     1.106    27.195     0.150
     1.106    19.445     0.150
     1.123    60.055     0.150
     1.123    68.117     0.150
     1.443    55.414     0.150
     1.443    64.039     0.150
     1.501    49.859     0.150
     1.664    37.273     0.150
     1.682    86.453     0.150
     1.682    99.594     0.150
     1.699    33.180     0.150
     3.397    97.562     0.150
     5.677   143.258     0.150
     0.534    10.289     0.150
     0.534    17.164     0.150
     0.534    10.516     0.150
     0.534    17.992     0.150
     0.534    10.297     0.150
     0.534    17.484     0.150
     0.534    20.344     0.150
     0.826    29.727     0.150
     0.839    15.273     0.150
     0.839    31.797     0.150
     0.839    36.859     0.150
     1.061    37.539     0.150
     1.061    37.844     0.150
     1.214    55.617     0.150
     1.214    59.438     0.150
     1.378    61.172     0.150
     1.378    62.242     0.150
     1.490    56.547     0.150
     1.518    25.109     0.150
     1.518    25.188     0.150
     2.070    33.438     0.150
     2.216    97.719     0.150
     3.257    50.586     0.150
     4.969    76.258     0.150
     5.002    73.703     0.150
     5.685    84.438     0.150
     5.685   159.875     0.150
     6.872   104.062     0.150
     7.594   111.188     0.150
     8.448   128.945     0.150
     8.540   129.414     0.150
    10.234   147.312     0.150
    10.363   148.477     0.150
    11.907   175.867     0.150
    12.502   184.188     0.150
    12.572   176.633     0.150
    12.876   183.328     0.150
    13.121   186.445     0.150
    13.262   193.578     0.150
    13.495   193.438     0.150
    13.634   195.523     0.150
    13.957   197.508     0.150
    13.957   198.984     0.150
    14.554   205.258     0.150
    15.339   218.477     0.150
    17.345   245.406     0.150
    20.157   278.828     0.150
    27.053   343.562     0.150
    28.359   354.164     0.150
    32.741   393.562     0.150
    34.869   413.445     0.150
    35.967   421.344     0.150
    36.036   421.266     0.150
    36.134   425.344     0.150
    36.903   429.195     0.150
    36.903   431.133     0.150
    37.675   435.648     0.150
    37.871   437.273     0.150
    37.881   436.812     0.150
    37.987   440.898     0.150
    38.305   440.523     0.150
    38.629   443.836     0.150
    38.968   447.938     0.150
    40.389   455.984     0.150
    40.405   456.625     0.150
    41.180   462.984     0.150
    41.492   465.672     0.150
    42.579   476.375     0.150
    42.579   478.117     0.150
    42.646   478.375     0.150
    43.011   479.758     0.150
    44.799   494.078     0.150
    44.799   496.008     0.150
    45.881   500.625     0.150
    55.889   579.469     0.150
    79.623   727.258     0.150
     0.588    11.570     0.150
     0.588    19.820     0.150
     0.588    11.703     0.150
     0.588    20.852     0.150
     0.588    11.711     0.150
     0.588    19.289     0.150
     0.588    21.898     0.150
     0.619    23.352     0.150
     0.924    28.859     0.150
     0.924    37.641     0.150
     0.880    38.992     0.150
     0.880    45.852     0.150
     1.112    33.188     0.150
     1.112    20.070     0.150
     1.112    40.547     0.150
     1.112    57.273     0.150
     1.452    27.438     0.150
     1.452    28.289     0.150
     1.452    53.844     0.150
     1.452    56.297     0.150
     1.503    50.539     0.150
     1.503    51.688     0.150
     1.553    50.617     0.150
     1.553    26.398     0.150
     1.553    51.078     0.150
     1.553    26.383     0.150
     1.553    51.281     0.150
     1.553    26.500     0.150
     1.693    62.078     0.150
     1.712    34.133     0.150
     1.712    45.453     0.150
     1.656    55.742     0.150
     4.042    63.289     0.150
     4.023    71.844     0.150
     4.023   110.352     0.150
     8.217   126.172     0.150
     8.544   124.828     0.150
     9.833   149.852     0.150
    10.322   149.281     0.150
    12.378   185.383     0.150
    12.798   180.977     0.150
    14.819   208.453     0.150
    16.794   232.047     0.150
    17.459   241.812     0.150
    21.916   293.328     0.150
    23.769   311.031     0.150
    32.424   390.680     0.150
    36.085   425.859     0.150
    36.252   423.508     0.150
    37.020   430.438     0.150
    39.021   447.891     0.150
    44.561   493.078     0.150
    46.608   509.242     0.150
     0.600    23.983     0.150
     0.655    12.903     0.150
     0.655    20.853     0.150
     0.655    12.893     0.150
     0.655    21.083     0.150
     0.655    21.713     0.150
     0.866    36.073     0.150
     0.866    39.663     0.150
     1.177    39.463     0.150
     1.177    39.493     0.150
     1.089    22.203     0.150
     1.588    29.733     0.150
     1.774    37.083     0.150
     1.763    57.563     0.150
     1.763    61.653     0.150
     1.832    76.393     0.150
     3.167    64.503     0.150
     0.720    25.738     0.150
     1.076    35.828     0.150
     1.228    49.318     0.150
     1.228    57.588     0.150
     1.453    25.528     0.150
     1.813    30.708     0.150
     2.323    61.068     0.150
     2.323    67.918     0.150
     7.395   104.548     0.150
     7.922   214.318     0.150
     8.829   142.760     0.150
    12.836   193.718     0.150
     0.496     9.942     0.150
     0.496    10.572     0.150
     0.496    17.083     0.150
     0.496     9.793     0.150
     0.496    16.853     0.150
     0.496    23.553     0.150
     0.496    23.822     0.150
     0.807    15.772     0.150
     0.988    35.282     0.150
     0.988    38.402     0.150
     1.235    46.583     0.150
     1.336    27.732     0.150
     1.447    54.912     0.150
     1.490    53.763     0.150
     1.769    28.253     0.150
     1.812    30.564     0.150
     2.427    35.173     0.150
     3.019    45.452     0.150
     3.202    44.593     0.150
     3.679    57.554     0.150
     3.970    62.473     0.150
     4.220    60.843     0.150
     4.718    72.797     0.150
     4.804    78.090     0.150
     4.958    78.589     0.150
     5.438    80.365     0.150
     5.554    75.923     0.150
     5.830    89.810     0.150
     6.851    97.496     0.150
     6.857    95.423     0.150
     7.559   107.532     0.150
     7.559   108.137     0.150
     7.837   123.442     0.150
     8.596   116.923     0.150
     9.433   129.343     0.150
    12.403   184.240     0.150
    12.481   176.513     0.150
    12.949   184.723     0.150
    12.949   184.641     0.150
    13.845   196.443     0.150
    15.177   217.452     0.150
    15.530   218.807     0.150
    18.725   263.232     0.150
    20.141   280.083     0.150
    22.636   294.687     0.150
    32.488   388.870     0.150
    32.544   389.219     0.150
    33.728   400.447     0.150
    34.477   411.293     0.150
    35.706   419.283     0.150
    35.872   420.881     0.150
    36.022   419.920     0.150
    36.376   423.388     0.150
    37.053   435.089     0.150
    37.414   432.178     0.150
    37.613   432.928     0.150
    37.621   436.683     0.150
    37.621   433.490     0.150
    39.356   448.381     0.150
    39.477   455.397     0.150
    39.776   455.173     0.150
    40.012   454.005     0.150
    40.432   457.735     0.150
    40.584   459.307     0.150
    40.627   463.180     0.150
    41.232   463.433     0.150
    42.182   472.597     0.150
    43.720   487.466     0.150
    47.144   516.964     0.150
    64.853   635.393     0.150
    79.027   720.593     0.150
    92.136     7.300     0.150
   133.499  1162.442     0.150
     0.474     7.873     0.150
     0.474    12.434     0.150
     0.474     9.094     0.150
     0.474     9.394     0.150
     0.474    15.743     0.150
     0.474    16.243     0.150
     0.474    22.233     0.150
     0.661    20.544     0.150
     0.661    27.754     0.150
     0.826    15.604     0.150
     0.981    33.953     0.150
    22.105   293.294     0.150
     0.559     8.719     0.150
     0.559    15.398     0.150
     0.559     8.828     0.150
     0.559    15.498     0.150
     1.021    17.179     0.150
     1.250    29.248     0.150
     1.250    52.278     0.150
     1.950    66.668     0.150
     2.528    88.059     0.150
     4.239    84.068     0.150
     4.605   150.448     0.150
     5.566   161.438     0.150
     0.481    12.035     0.150
     0.481    20.316     0.150
     0.481    21.355     0.150
     0.646    12.574     0.150
     0.646    21.336     0.150
     0.646    12.625     0.150
     0.646    21.574     0.150
     0.646    22.035     0.150
     0.708    24.145     0.150
     0.816    25.855     0.150
     0.816    15.297     0.150
     0.921    32.645     0.150
     0.941    29.418     0.150
     1.038    35.996     0.150
     1.135    71.707     0.150
     1.182    40.777     0.150
     0.510    10.348     0.150
     0.510    18.551     0.150
     0.510    10.430     0.150
     0.510    17.918     0.150
     0.510    19.379     0.150
     0.510    20.098     0.150
     0.673    22.957     0.150
     0.801    38.500     0.150
     0.801    47.000     0.150
     1.012    18.309     0.150
     2.386    40.199     0.150
     4.182   118.801     0.150
     0.722    13.152     0.150
     0.722    13.332     0.150
     0.722    22.961     0.150
     0.722    32.992     0.150
     0.722    33.500     0.150
     0.705    23.223     0.150
     0.952    42.590     0.150
     0.952    43.262     0.150
     0.973    17.871     0.150
     1.103    44.461     0.150
     1.103    53.562     0.150
     1.226    48.770     0.150
     1.337   102.691     0.150
     1.554    59.281     0.150
     1.554    60.641     0.150
     1.540    62.891     0.150
     1.540    67.582     0.150
     1.967    34.422     0.150
     3.085    46.230     0.150
     4.051    63.930     0.150
     7.662   108.539     0.150
     7.662   227.641     0.150
     9.138   125.770     0.150
    12.443   175.859     0.150
    12.980   185.961     0.150
    12.980   193.160     0.150
    15.017   212.000     0.150
    15.715   218.012     0.150
     1.155    20.211     0.150
     1.155    33.172     0.150
     1.317    52.262     0.150
     1.582    87.062     0.150
     1.786    67.590     0.150
     1.847    41.223     0.150
     1.847    85.090     0.150
     1.847    85.320     0.150
     2.227    36.980     0.150
     3.515   136.621     0.150
     1.548    26.027     0.150
     1.548    47.047     0.150
     1.548    26.047     0.150
     1.548    46.375     0.150
     1.684    49.809     0.150
     1.868    55.586     0.150
     1.868    31.656     0.150
     1.868    63.285     0.150
     0.395    14.570     0.150
     0.395    15.641     0.150
     0.997    17.992     0.150
     0.997    18.195     0.150
     0.997    31.320     0.150
     0.997    33.188     0.150
     0.997    34.633     0.150
     1.363    46.391     0.150
     1.363    53.844     0.150
     2.062    35.297     0.150
     2.189    79.617     0.150
     2.189    83.992     0.150
     2.399   111.992     0.150
     2.399   112.727     0.150
    10.697   151.266     0.150
    13.093   192.594     0.150
    21.676   290.383     0.150
    40.662   456.266     0.150
     1.045    17.234     0.150
     1.045    16.762     0.150
     1.045    17.152     0.150
     1.045    31.402     0.150
     1.045    44.383     0.150
     1.566    52.965     0.150
     1.566    53.645     0.150
     3.030    39.172     0.150
     2.999    35.871     0.150
     3.652    52.762     0.150
     3.949    53.613     0.150
     8.077   109.762     0.150
    10.393   155.293     0.150
    12.369   181.133     0.150
    13.059   190.488     0.150
    14.652   216.172     0.150
    14.838   220.492     0.150
     0.778    14.156     0.150
     0.778    24.977     0.150
     0.778    14.838     0.150
     0.778    25.807     0.150
     0.778    14.668     0.150
     0.778    25.758     0.150
     0.778    35.598     0.150
     0.778    45.197     0.150
     0.810    32.977     0.150
     1.261    53.146     0.150
     1.545    59.236     0.150
     1.648    64.547     0.150
     2.018    30.178     0.150
     2.108    36.857     0.150
     2.774    40.826     0.150
     8.529   131.781     0.150
    10.144   153.156     0.150
    12.650   187.357     0.150
     0.769    27.195     0.150
     0.711    13.914     0.150
     0.711    25.477     0.150
     0.711    14.477     0.150
     0.711    24.516     0.150
     0.711    14.320     0.150
     0.711    25.320     0.150
     0.711    14.484     0.150
     0.711    26.773     0.150
     1.037    18.914     0.150
     1.037    34.836     0.150
     1.203    21.891     0.150
     1.203    39.125     0.150
     1.203    22.164     0.150
     1.369    25.328     0.150
     1.369    44.680     0.150
     1.512    59.508     0.150
     1.583    28.688     0.150
     1.798    35.641     0.150
     1.923    60.805     0.150
     1.992    34.156     0.150
     1.992    45.516     0.150
     2.034    35.680     0.150
     2.236    51.477     0.150
     2.426    39.406     0.150
     2.467    41.039     0.150
     2.824    45.375     0.150
     3.225    48.906     0.150
     3.279    50.188     0.150
     3.279    50.258     0.150
     5.246    78.258     0.150
     6.775   105.734     0.150
     6.965   103.781     0.150
     8.312   123.195     0.150
     9.052   131.750     0.150
     9.542   143.750     0.150
     9.558   250.719     0.150
    11.389   297.750     0.150
    12.263   181.367     0.150
    12.849   188.867     0.150
    13.197   187.266     0.150
    15.194   215.680     0.150
    18.035   251.070     0.150
    18.025   255.359     0.150
    19.029   266.516     0.150
    19.271   270.547     0.150
    20.403   287.148     0.150
    20.456   288.430     0.150
    21.335   294.305     0.150
    21.888   302.734     0.150
    22.154   305.367     0.150
    22.196   306.148     0.150
    31.224   379.758     0.150
    34.636   410.156     0.150
    35.094   413.922     0.150
    35.447   416.078     0.150
    36.322   424.836     0.150
    36.322   424.781     0.150
    38.942   452.367     0.150
    39.259   448.820     0.150
    39.449   450.508     0.150
    39.570   451.898     0.150
    40.058   456.898     0.150
    40.200   456.578     0.150
    41.159   465.023     0.150
    41.212   470.969     0.150
    42.755   476.570     0.150
    42.795   476.352     0.150
    42.982   479.055     0.150
    43.361   481.711     0.150
    44.863   493.750     0.150
    45.153   496.773     0.150
    46.728   508.680     0.150
    56.166   576.234     0.150
    56.735   590.438     0.150
    57.121  1067.695     0.150
    60.925   622.297     0.150
    61.788   626.336     0.150
    63.530   621.500     0.150
    67.582   658.328     0.150
    85.701   764.195     0.150
    86.045  1399.797     0.150
    86.045  2125.797     0.150
    90.648   780.594     0.150
    92.729   785.398     0.150
   119.880  1133.523     0.150
   138.771  1003.797     0.150
     0.539    10.871     0.150
     0.539    18.070     0.150
     0.539    11.020     0.150
     0.539    17.863     0.150
     0.539    11.020     0.150
     0.539    18.082     0.150
     0.539    19.711     0.150
     0.539    20.590     0.150
     0.753    33.703     0.150
     0.939    18.062     0.150
     1.105    20.711     0.150
     1.157    40.410     0.150
     1.157    41.973     0.150
     1.157    67.383     0.150
     1.318    44.832     0.150
     1.651    78.281     0.150
     1.875    37.750     0.150
     2.235    45.301     0.150
     4.388    72.051     0.150
     4.592    76.613     0.150
     4.604    69.543     0.150
     5.328    85.363     0.150
     7.054   110.672     0.150
     7.136   102.461     0.150
     7.510   106.883     0.150
     7.568   116.410     0.150
     7.778   113.730     0.150
     8.129   115.660     0.150
     8.162   116.820     0.150
     8.207   122.082     0.150
     8.209   117.223     0.150
     9.261   141.918     0.150
     9.525   141.852     0.150
    11.927   178.590     0.150
     0.545     9.941     0.150
     0.545    15.070     0.150
     0.545    10.039     0.150
     0.545    17.160     0.150
     0.545    10.031     0.150
     0.545    23.301     0.150
     0.778    48.531     0.150
     0.778    49.180     0.150
     0.941    17.129     0.150
     0.941    35.891     0.150
     0.941    36.109     0.150
     1.088    22.012     0.150
     1.088    22.070     0.150
     1.088    33.281     0.150
     1.104    40.402     0.150
     1.530    27.531     0.150
     1.495    59.289     0.150
     1.579    27.402     0.150
     3.262    53.902     0.150
     3.887    57.320     0.150
     4.392    73.242     0.150
     4.875    70.520     0.150
     7.134   110.789     0.150
     8.235   114.289     0.150
     0.535     9.439     0.150
     0.535    17.000     0.150
     0.535     9.859     0.150
     0.535    16.959     0.150
     0.535    17.309     0.150
     0.535    18.369     0.150
     0.535    10.154     0.150
     0.535    17.102     0.150
     0.941    31.389     0.150
     0.967    23.879     0.150
     0.999    22.877     0.150
     1.170    65.299     0.150
     1.170    25.840     0.150
     1.412    34.855     0.150
     2.414    46.500     0.150
     6.870   103.449     0.150
     0.556     9.395     0.150
     0.556     9.334     0.150
     0.556    16.125     0.150
     0.556     9.516     0.150
     0.556    16.506     0.150
     0.556    17.994     0.150
     0.934    28.695     0.150
     1.053    21.824     0.150
     1.053    36.904     0.150
     1.053    37.324     0.150
     1.113    41.734     0.150
     1.305    22.635     0.150
     1.305    22.666     0.150
     1.305    39.775     0.150
     1.305    22.576     0.150
     1.305    39.545     0.150
     1.063    33.506     0.150
     1.275    38.846     0.150
     1.528    45.816     0.150
     3.052    56.285     0.150
     4.022    55.885     0.150
     8.245   244.600     0.150
     8.760   125.055     0.150
     9.156   130.496     0.150
     9.354   132.645     0.150
     9.418   134.736     0.150
     9.483   133.725     0.150
     9.691   137.465     0.150
     9.641   136.635     0.150
     9.711   137.635     0.150
    10.329   146.045     0.150
    10.358   146.205     0.150
    10.996   154.695     0.150
    11.326   159.826     0.150
    13.894   202.445     0.150
    15.793   229.365     0.150
    18.441   253.115     0.150
    18.507   253.096     0.150
    18.622   258.656     0.150
    41.003   465.766     0.150
    41.823   470.426     0.150
     1.022    18.652     0.150
     1.348    22.473     0.150
     1.348    22.432     0.150
     1.348    39.291     0.150
     1.813    52.303     0.150
     4.037   115.451     0.150
     6.656   102.797     0.150
    15.227   213.973     0.150
    15.308   217.553     0.150
     0.669    12.430     0.150
     0.669    21.227     0.150
     0.669    12.523     0.150
     0.669    21.055     0.150
     0.669    22.336     0.150
     0.669    22.414     0.150
     0.778    27.234     0.150
     0.871    16.078     0.150
     0.871    29.062     0.150
     0.871    29.875     0.150
     1.140    19.883     0.150
     1.592    59.547     0.150
     3.134    44.445     0.150
     3.201    45.234     0.150
     4.409    73.430     0.150
     4.409   123.547     0.150
     8.030   115.703     0.150
     8.080   117.188     0.150
     0.547    11.766     0.150
     0.547    19.605     0.150
     0.547    21.545     0.150
     0.547    19.355     0.150
     0.547    20.195     0.150
     0.707    42.115     0.150
     1.085    63.824     0.150
     1.235    67.596     0.150
     1.235    67.834     0.150
    12.087   180.100     0.150
     0.447    17.736     0.150
     1.062    18.707     0.150
     1.062    18.797     0.150
     1.062    31.938     0.150
     1.250    51.416     0.150
     1.330    49.656     0.150
     1.452    24.967     0.150
     1.570    70.857     0.150
     0.430    11.592     0.150
     0.737    11.042     0.150
     0.737    20.683     0.150
     0.737    12.732     0.150
     0.737    21.002     0.150
     0.794    21.853     0.150
     0.794    15.382     0.150
     0.842    19.002     0.150
     0.842    32.553     0.150
     0.916    19.152     0.150
     2.573    42.292     0.150
     2.611    42.433     0.150
     4.367    61.393     0.150
     0.595    12.125     0.150
     0.595    12.004     0.150
     0.595    20.445     0.150
     0.981    17.945     0.150
     1.104    20.145     0.150
     1.468    25.305     0.150
     3.426    55.895     0.150
     3.518    56.684     0.150
     7.708   116.156     0.150
    12.864   190.684     0.150
    13.051   192.977     0.150
    17.521   245.977     0.150
     1.128    20.684     0.150
     1.128    36.742     0.150
     1.498    25.855     0.150
     1.840    36.305     0.150
     1.905    27.836     0.150
     2.609    81.715     0.150
     2.688    42.984     0.150
     2.688    76.664     0.150
     3.315    47.652     0.150
     3.420    57.934     0.150
     3.561    57.766     0.150
     3.843    54.203     0.150
     4.019    61.363     0.150
     4.019   110.945     0.150
     4.075    57.945     0.150
     7.488   130.031     0.150
     7.488   227.773     0.150
     7.488   264.246     0.150
     7.600   112.004     0.150
     7.721   228.406     0.150
     8.090   118.723     0.150
     8.353   128.891     0.150
     9.985   299.660     0.150
    12.399   174.953     0.150
    12.399   174.953     0.150
    12.907   190.531     0.150
    13.084   182.992     0.150
     0.321     7.208     0.150
     0.466    23.518     0.150
     0.593    11.487     0.150
     0.685    12.958     0.150
     0.685    22.317     0.150
     0.685    12.978     0.150
     0.685    12.808     0.150
     0.685    22.317     0.150
     0.761    13.857     0.150
     0.761    24.708     0.150
     0.761    13.907     0.150
     0.787    14.548     0.150
     0.827    14.968     0.150
     0.947    17.117     0.150
     0.998    32.558     0.150
     0.998    17.867     0.150
     0.998    17.808     0.150
     0.998    32.558     0.150
     0.998    17.907     0.150
     0.970    16.478     0.150
     0.970    45.147     0.150
     1.030    44.538     0.150
     1.082    19.098     0.150
     1.210    52.067     0.150
     1.210    52.208     0.150
     1.217    50.838     0.150
     1.388    22.968     0.150
     1.388    22.907     0.150
     1.388    21.808     0.150
     1.800    29.038     0.150
     1.895    30.397     0.150
     1.895    56.848     0.150
     1.946    30.638     0.150
     1.946    58.647     0.150
     1.946    30.708     0.150
     2.050    32.107     0.150
     2.506    37.907     0.150
     2.506    37.907     0.150
     2.506    37.968     0.150
     2.521    39.008     0.150
     2.859    43.518     0.150
     3.270    49.508     0.150
     3.270    49.607     0.150
     3.270    49.668     0.150
     4.491    66.768     0.150
     4.791    76.928     0.150
     4.946   123.478     0.150
     7.525   111.867     0.150
     8.432   120.038     0.150
     8.964   125.147     0.150
     8.964   125.147     0.150
     9.089   127.668     0.150
     9.458   131.088     0.150
     9.458   131.088     0.150
     9.674   138.768     0.150
     9.674   138.808     0.150
    10.432   147.478     0.150
    10.432   260.827     0.150
    10.881   158.808     0.150
    11.119   154.228     0.150
    11.119   154.228     0.150
    11.975   167.527     0.150
    11.975   167.527     0.150
    12.710   179.008     0.150
    12.710   179.038     0.150
    13.562   192.808     0.150
    13.880   193.938     0.150
    14.042   197.107     0.150
    14.337   206.798     0.150
    14.908   211.258     0.150
    14.927   211.508     0.150
    14.927   211.498     0.150
    16.089   227.508     0.150
    16.127   224.447     0.150
    16.185   228.208     0.150
    16.185   228.067     0.150
    16.749   230.388     0.150
    17.595   243.098     0.150
    18.220   254.357     0.150
    18.245   250.258     0.150
    18.272   251.458     0.150
    18.381   257.817     0.150
    18.410   256.138     0.150
    18.445   254.468     0.150
    18.467   257.018     0.150
    18.491   257.147     0.150
    18.519   254.258     0.150
    18.519   455.197     0.150
    18.573   259.027     0.150
    18.584   259.567     0.150
    18.615   257.168     0.150
    18.620   258.388     0.150
    18.671   258.867     0.150
    18.722   259.268     0.150
    18.923   259.958     0.150
    18.923   259.958     0.150
    18.923   462.827     0.150
    19.095   263.178     0.150
    19.242   263.518     0.150
    19.506   267.548     0.150
    20.222   277.168     0.150
    20.383   278.348     0.150
    20.385   278.058     0.150
    20.440   273.838     0.150
    20.440   273.838     0.150
    20.496   279.758     0.150
    20.812   283.638     0.150
    20.932   284.748     0.150
    21.330   290.338     0.150
    21.365   289.897     0.150
    21.948   295.348     0.150
    23.011   306.768     0.150
    23.099   311.878     0.150
    23.383   310.277     0.150
    24.017   315.907     0.150
    24.719   321.407     0.150
    35.436   419.008     0.150
    35.436   418.831     0.150
    39.027   448.268     0.150
    41.314   467.936     0.150
    44.179   489.178     0.150
    45.597   501.508     0.150
    45.960   505.407     0.150
    46.296   508.508     0.150
    46.296   508.808     0.150
    46.468   510.107     0.150
    46.610   507.668     0.150
    55.946   578.407     0.150
    60.969   614.708     0.150
    65.248   643.183     0.150
    65.248   641.907     0.150
    68.413   660.838     0.150
    70.346   674.348     0.150
    74.974   701.008     0.150
    76.607   709.978     0.150
    79.144   723.998     0.150
    79.228   725.107     0.150
    79.421   725.308     0.150
    79.954   731.468     0.150
    81.748     2.899     0.150
    81.862   739.008     0.150
    82.744   749.907     0.150
    83.164   747.808     0.150
    83.891   748.808     0.150
    83.892   748.708     0.150
    85.381   758.808     0.150
    85.381  1154.808     0.150
    85.381  1390.808     0.150
    85.381  1934.808     0.150
    85.381  2108.808     0.150
    86.045   758.808     0.150
    87.027     6.300     0.150
    88.253   771.748     0.150
    88.253   771.748     0.150
    88.253  1094.478     0.150
    88.253  1981.978     0.150
    88.253   771.708     0.150
    88.253   978.907     0.150
    88.253  1094.407     0.150
    88.253  1399.907     0.150
    88.253  1767.808     0.150
    88.253  1981.907     0.150
    89.412   777.708     0.150
    89.860   778.508     0.150
    92.731   793.088     0.150
    92.731   793.107     0.150
    93.864   806.208     0.150
    94.555     4.800     0.150
    97.052     4.800     0.150
    97.052     7.100     0.150
    97.297   820.407     0.150
     3.067   831.907     0.150
     3.067  1083.808     0.150
     3.067  1470.308     0.150
     3.067  1957.308     0.150
     3.067  2192.508     0.150
   103.924   838.508     0.150
   103.924  1229.607     0.150
   114.008  1169.708     0.150
   131.353  1459.708     0.150
   131.353  2636.108     0.150
     0.273     7.123     0.150
     0.273    12.014     0.150
     0.746    13.734     0.150
     0.746    23.543     0.150
     0.746    24.453     0.150
     0.746    24.533     0.150
     0.746    13.773     0.150
     0.746    20.664     0.150
     0.746    17.504     0.150
     0.746    23.504     0.150
     0.736    26.404     0.150
     0.736    26.424     0.150
     0.861    19.324     0.150
     0.861    23.123     0.150
     0.861    39.254     0.150
     1.044    23.443     0.150
     1.882    38.893     0.150
     1.929    38.264     0.150
     1.045    18.508     0.150
     1.045    33.070     0.150
     1.275    21.547     0.150
     1.275    43.859     0.150
     1.323    22.578     0.150
     1.323    38.547     0.150
     1.323    21.289     0.150
     1.323    21.969     0.150
     1.323    39.273     0.150
     1.546    28.656     0.150
     1.651    28.609     0.150
     2.129    41.016     0.150
     2.698    75.477     0.150
     3.036    50.727     0.150
     3.036    86.234     0.150
     3.357    59.844     0.150
     3.357   100.688     0.150
     3.478    48.180     0.150
     3.478    81.664     0.150
     3.792    50.969     0.150
     4.024    55.625     0.150
     6.679   102.672     0.150
     7.726   110.328     0.150
     9.150   149.328     0.150
     9.217   140.125     0.150
    13.408   195.227     0.150
    14.468   202.805     0.150
    15.195   213.164     0.150
    15.278   220.195     0.150
    40.475   464.430     0.150
    94.517   807.227     0.150
     0.537    12.125     0.150
     0.414     7.918     0.150
     0.459    18.078     0.150
     0.459    18.230     0.150
     0.542    10.270     0.150
     0.542    17.559     0.150
     0.542    17.879     0.150
     0.542    17.969     0.150
     0.542    10.430     0.150
     0.542    17.180     0.150
     0.894    32.750     0.150
     1.208    42.770     0.150
     0.456    17.440     0.150
     1.561    26.080     0.150
     1.561    47.310     0.150
     1.561    25.980     0.150
     1.561    25.740     0.150
     1.561    49.790     0.150
     1.581    60.360     0.150
     1.581    60.550     0.150
     1.583    58.910     0.150
     1.696    58.160     0.150
     1.919    64.170     0.150
     1.919    65.640     0.150
     2.021    59.260     0.150
     2.021    83.220     0.150
     2.338    38.300     0.150
     2.789    48.680     0.150
     3.209   126.760     0.150
     3.209   137.300     0.150
    60.460   108.890     0.150
    19.620   120.280     0.150
    62.519   123.570     0.150
    67.055   134.350     0.150
    13.226   194.280     0.150
    13.836   202.880     0.150
    96.317   206.010     0.150
    14.800   209.260     0.150
    84.865   215.460     0.150
    76.752   216.790     0.150
    15.297   215.720     0.150
   103.992   221.340     0.150
    16.743   242.880     0.150
    18.098   258.380     0.150
    18.569   256.930     0.150
    18.697   264.280     0.150
    19.122   270.580     0.150
    19.762   277.880     0.150
    20.285   282.880     0.150
    21.506   296.080     0.150
    27.158   343.700     0.150
    33.599   407.306     0.150
    65.655   499.060     0.150
    85.277   774.910     0.150
     0.452    17.773     0.150
     1.070    19.363     0.150
     1.070    36.262     0.150
     1.102    36.984     0.150
     1.102    19.703     0.150
     1.305    22.055     0.150
     1.305    39.191     0.150
     1.305    22.035     0.150
     1.305    38.254     0.150
     1.473    58.875     0.150
     1.783    29.684     0.150
     1.991    79.984     0.150
     3.878   137.395     0.150
     0.427    16.936     0.150
     0.427    17.206     0.150
     1.127    35.916     0.150
     1.235    21.396     0.150
     1.235    38.325     0.150
     1.235    21.195     0.150
     1.235    37.445     0.150
     1.507    58.505     0.150
     1.507    63.805     0.150
     1.718    56.465     0.150
     2.038    79.675     0.150
     3.469    97.215     0.150
     3.547    58.706     0.150
     0.448    17.336     0.150
     1.077    36.525     0.150
     1.077    46.195     0.150
     1.297    22.275     0.150
     1.297    38.275     0.150
     1.297    51.625     0.150
     1.297    22.086     0.150
     1.297    37.945     0.150
     1.477    60.695     0.150
     1.775    63.285     0.150
     1.775    65.275     0.150
     1.775    57.406     0.150
     1.852    62.086     0.150
     1.996    75.215     0.150
     3.063    37.215     0.150
     3.281    54.645     0.150
     3.406    55.965     0.150
     0.560    20.729     0.150
     0.591    10.537     0.150
     0.591    18.297     0.150
     0.626    11.318     0.150
     0.626    19.867     0.150
     0.626    20.408     0.150
     0.626    11.697     0.150
     0.626    19.648     0.150
     0.626    11.297     0.150
     0.626    19.588     0.150
     0.771    14.037     0.150
     0.835    26.797     0.150
     1.020    28.447     0.150
     1.050    18.328     0.150
     1.050    32.457     0.150
     1.214    53.018     0.150
     1.387    46.229     0.150
     1.595    27.047     0.150
     2.118    33.389     0.150
     2.174    33.008     0.150
     3.146    44.877     0.150
    21.085    95.248     0.150
     0.315    13.267     0.150
     1.322    22.477     0.150
     1.322    40.167     0.150
     1.322    22.447     0.150
     1.322    38.797     0.150
     1.612    76.597     0.150
     1.714    56.627     0.150
     1.783    28.797     0.150
     3.377    42.787     0.150
     1.114    43.536     0.150
     1.114    43.866     0.150
     1.262    22.216     0.150
     1.262    39.356     0.150
     1.262    58.816     0.150
     1.262    22.216     0.150
     1.262    39.116     0.150
     1.619    49.256     0.150
     1.619    53.726     0.150
     1.619    53.766     0.150
     1.589    61.776     0.150
     1.589    65.436     0.150
     1.686    28.636     0.150
     1.686    52.076     0.150
     1.721    72.706     0.150
     1.721    81.456     0.150
     1.721    28.296     0.150
     0.635    12.666     0.150
     0.635    21.215     0.150
     0.635    25.355     0.150
     0.635    12.775     0.150
     0.635    22.234     0.150
     0.951    47.555     0.150
     1.026    32.275     0.150
     1.471    49.635     0.150
     1.471    25.666     0.150
     1.627    59.846     0.150
     1.627    62.355     0.150
     0.706    13.641     0.150
     0.706    33.570     0.150
     0.706    34.672     0.150
     0.685    12.602     0.150
     0.685    22.305     0.150
     0.685    23.727     0.150
     0.685    44.180     0.150
     0.685    12.602     0.150
     0.685    28.070     0.150
     0.685    12.695     0.150
     0.685    22.430     0.150
     0.974    50.680     0.150
     0.964    48.156     0.150
     1.066    37.555     0.150
     1.066    19.586     0.150
     1.191    46.945     0.150
     1.191    20.445     0.150
     1.573    60.133     0.150
     1.573    62.125     0.150
     2.665    82.961     0.150
     0.649    12.879     0.150
     0.649    21.879     0.150
     0.649    31.301     0.150
     0.649    12.949     0.150
     0.649    21.930     0.150
     1.028    43.230     0.150
     1.028    33.219     0.150
     1.500    57.930     0.150
     1.500    61.168     0.150
     1.606    29.559     0.150
     1.606    69.488     0.150
     1.606    73.461     0.150
     1.910    55.500     0.150
     0.705    13.324     0.150
     0.705    20.055     0.150
     0.705    23.555     0.150
     0.705    13.734     0.150
     0.705    13.645     0.150
     0.705    23.555     0.150
     0.733    35.094     0.150
     0.929    50.863     0.150
     0.929    51.797     0.150
     1.094    19.156     0.150
     1.205    55.516     0.150
     1.205    21.613     0.150
     1.205    21.613     0.150
     1.205    38.906     0.150
     1.526    61.754     0.150
     1.526    26.066     0.150
     1.526    26.066     0.150
     1.526    45.297     0.150
     1.579    59.734     0.150
     1.563    64.156     0.150
     1.841    27.297     0.150
     1.913    31.484     0.150
     2.039    33.035     0.150
     2.769    43.496     0.150
     3.074    51.047     0.150
     3.496    66.770     0.150
     3.949   112.934     0.150
     5.306   150.066     0.150
     6.363   182.203     0.150
     6.792   187.773     0.150
     9.568   265.465     0.150
    11.062   161.816     0.150
    12.985   186.227     0.150
    13.359   190.504     0.150
    20.177   276.215     0.150
    23.814   316.305     0.150
    86.009  2662.375     0.150
    86.009  2722.375     0.150
     0.509     9.945     0.150
     0.509    16.516     0.150
     0.618    12.166     0.150
     0.618    20.955     0.150
     0.616    49.455     0.150
     0.616    49.637     0.150
     0.801    46.076     0.150
     0.992    33.525     0.150
     1.306    28.236     0.150
     1.502    25.986     0.150
     0.573    20.798     0.150
     0.573    20.798     0.150
     0.922    30.878     0.150
     1.422    47.698     0.150
     1.422    58.028     0.150
     1.539    63.778     0.150
     1.564    27.428     0.150
     1.564    48.678     0.150
     1.564    59.288     0.150
     1.564    27.218     0.150
     1.564    45.308     0.150
     1.586    63.788     0.150
     1.940    31.938     0.150
     2.002    53.258     0.150
     3.546    57.198     0.150
     3.680   127.998     0.150
     3.680   139.548     0.150
     0.563    23.696     0.150
     0.859    16.316     0.150
     0.859    27.586     0.150
     0.933    35.526     0.150
     1.434    58.956     0.150
     1.434    60.966     0.150
     1.562    28.366     0.150
     1.562    27.826     0.150
     1.562    47.937     0.150
     3.689   134.456     0.150
     5.043    72.767     0.150
     0.550    20.664     0.150
     0.905    33.125     0.150
     0.939    47.469     0.150
     1.422    55.805     0.150
     1.422    60.625     0.150
     1.520    24.797     0.150
     1.520    44.719     0.150
     1.826    66.305     0.150
     2.592    64.531     0.150
     3.190    42.766     0.150
     3.190    78.688     0.150
     3.710    60.336     0.150
     3.710   105.531     0.150
     3.710   125.820     0.150
     1.575    26.793     0.150
     1.575    49.004     0.150
     1.951    32.883     0.150
     1.951    58.281     0.150
     2.788    59.051     0.150
     2.788   110.102     0.150
     3.138   110.352     0.150
     9.413   144.348     0.150
    11.001   164.598     0.150
    13.381   196.121     0.150
    13.958   208.180     0.150
     0.569    21.133     0.150
     0.847    27.984     0.150
     0.847    16.465     0.150
     1.434    65.695     0.150
     1.574    28.355     0.150
     1.574    25.074     0.150
     1.574    45.312     0.150
     1.779    33.695     0.150
     3.144    79.172     0.150
     3.391    55.215     0.150
     3.554    50.715     0.150
     3.686   130.805     0.150
     3.686   146.723     0.150
     3.686    58.535     0.150
     3.681   142.664     0.150
     3.681   143.004     0.150
     3.824    60.562     0.150
     4.460    72.922     0.150
     4.524    72.742     0.150
     4.623    74.133     0.150
     5.548    88.465     0.150
    19.566   123.035     0.150
    17.260   167.703     0.150
    14.100   199.895     0.150
    96.289   204.422     0.150
    14.483   206.703     0.150
    99.262   207.805     0.150
    76.652   213.824     0.150
   103.861   218.883     0.150
    40.672   460.398     0.150
    65.688   497.742     0.150
   131.365  1142.465     0.150
     0.536    19.945     0.150
     0.536    20.145     0.150
     0.861    32.234     0.150
     0.861    31.156     0.150
     1.459    66.875     0.150
     1.459    70.023     0.150
     1.549    21.086     0.150
     1.549    42.664     0.150
     1.918    55.965     0.150
     2.593    34.484     0.150
     2.808    39.504     0.150
     3.603    47.926     0.150
     1.445    56.956     0.150
     1.445    67.306     0.150
     1.522    25.356     0.150
     1.522    45.426     0.150
     1.895    56.016     0.150
     1.957    32.616     0.150
     2.604    89.836     0.150
     3.723   126.646     0.150
     0.909    15.902     0.150
     1.512    24.770     0.150
     1.512    44.781     0.150
     1.512    25.660     0.150
     1.512    45.293     0.150
     1.501    26.250     0.150
     1.889    31.551     0.150
     1.889    31.551     0.150
     1.889    55.543     0.150
     1.956    32.582     0.150
     1.956    56.902     0.150
     1.964    36.121     0.150
     2.602    74.660     0.150
     2.850    41.262     0.150
     2.850    57.480     0.150
     2.850    79.691     0.150
     2.836    47.352     0.150
     3.200    90.750     0.150
     3.200    49.680     0.150
     3.328    52.250     0.150
     3.494    55.953     0.150
     3.494   100.492     0.150
     3.564    74.070     0.150
     3.564    55.461     0.150
     3.564    99.020     0.150
     5.058    76.941     0.150
     8.575   130.812     0.150
     8.823   124.617     0.150
     9.354   142.266     0.150
    10.950   163.840     0.150
    13.166   194.262     0.150
    13.344   195.391     0.150
    13.710   202.891     0.150
    99.283   205.441     0.150
    14.696   204.582     0.150
    76.603   211.211     0.150
   103.829   215.863     0.150
    15.663   217.973     0.150
    17.731   252.262     0.150
    19.479   274.492     0.150
    22.998   308.562     0.150
    40.609   464.090     0.150
    98.092   810.941     0.150
     0.890    16.184     0.150
     0.890    29.141     0.150
     1.516    25.344     0.150
     1.516    25.582     0.150
     1.516    44.953     0.150
     1.884    62.543     0.150
     1.884    31.754     0.150
     1.884    62.543     0.150
     1.940    33.012     0.150
     1.940    33.012     0.150
     1.940    57.031     0.150
     1.970    56.863     0.150
     2.622    40.613     0.150
     3.493    99.273     0.150
     3.736    60.512     0.150
     3.736   101.301     0.150
     4.409    71.105     0.150
     5.090    76.914     0.150
     5.090   139.172     0.150
     6.723    97.352     0.150
     7.647   109.961     0.150
    62.401   121.551     0.150
    65.101   127.422     0.150
    67.079   133.203     0.150
    93.121   146.312     0.150
    76.911   178.711     0.150
    13.905   204.371     0.150
    99.244   209.293     0.150
    76.635   214.762     0.150
   103.867   219.242     0.150
    18.456   254.562     0.150
    31.842   383.914     0.150
    84.986   759.402     0.150
     1.388    52.945     0.150
     1.498    25.570     0.150
     1.498    44.281     0.150
     1.884    31.805     0.150
     2.812    38.016     0.150
     3.485    87.922     0.150
     4.381    89.898     0.150
     9.327   142.602     0.150
    10.913   164.102     0.150
    13.300   195.375     0.150
     0.924    17.578     0.150
     1.501    24.609     0.150
     1.501    42.414     0.150
     1.880    31.289     0.150
     1.953    32.234     0.150
     3.207    46.656     0.150
     3.207    82.844     0.150
     0.900    18.367     0.150
     0.900    31.117     0.150
     0.941    32.680     0.150
     1.425    57.305     0.150
     1.524    27.180     0.150
     1.524    45.336     0.150
     1.824    71.766     0.150
     1.901    32.969     0.150
     3.506    58.695     0.150
     0.916    47.727     0.150
     1.420    57.531     0.150
     1.574    30.398     0.150
     1.574    53.188     0.150
     1.777    67.430     0.150
     1.950    57.539     0.150
     1.950    66.031     0.150
     2.026    37.977     0.150
     2.026    64.883     0.150
     1.006    20.723     0.150
     1.006    34.463     0.150
     1.435    26.613     0.150
     1.435    45.393     0.150
     1.827    32.303     0.150
     2.634    43.043     0.150
     3.496    56.903     0.150
     1.364    52.859     0.150
     1.554    27.406     0.150
     1.554    49.414     0.150
     0.944    20.316     0.150
     1.368    66.396     0.150
     1.368    70.615     0.150
     1.507    32.406     0.150
     1.507    52.396     0.150
     1.897    57.176     0.150
     1.953    38.816     0.150
     3.189    65.717     0.150
     3.685   147.025     0.150
     1.499    24.578     0.150
     1.499    44.961     0.150
     3.485    57.031     0.150
     3.535   100.672     0.150
     0.948    17.977     0.150
     1.424    69.027     0.150
     1.475    27.438     0.150
     1.475    44.039     0.150
     3.550    59.387     0.150
     1.511    24.156     0.150
     1.511    42.996     0.150
     1.901    31.627     0.150
     0.541    24.867     0.150
     0.949    45.848     0.150
     1.434    58.688     0.150
     1.434    65.338     0.150
     1.522    24.938     0.150
     1.522    43.268     0.150
     1.627    59.148     0.150
     1.829    36.037     0.150
     1.829    60.707     0.150
     1.829    70.758     0.150
     1.829    74.307     0.150
     3.192    52.848     0.150
     3.571    59.098     0.150
     3.571   102.018     0.150
     3.717   148.588     0.150
     3.717   149.598     0.150
     1.369    79.127     0.150
     1.501    25.697     0.150
     1.501    42.117     0.150
     2.872    78.517     0.150
     3.689   135.287     0.150
     1.392   124.201     0.150
     1.541    24.211     0.150
     1.541    42.150     0.150
     3.526    51.420     0.150
     3.534   100.951     0.150
     3.617    49.711     0.150
     4.426    91.570     0.150
     7.669   152.850     0.150
     7.988   239.945     0.150
     8.778   133.051     0.150
     8.779   218.826     0.150
     9.372   143.176     0.150
    10.956   163.475     0.150
    40.627   468.400     0.150
     0.872    30.477     0.150
     1.410    54.816     0.150
     1.410    55.297     0.150
     1.560    23.285     0.150
     1.560    42.266     0.150
     3.543    50.996     0.150
     3.543    89.797     0.150
     4.447    72.879     0.150
     5.023    79.914     0.150
     5.023   141.336     0.150
     7.686   210.895     0.150
     9.396   142.395     0.150
    10.983   164.285     0.150
    13.364   195.277     0.150
     1.461    25.371     0.150
     1.461    43.830     0.150
     3.226    92.012     0.150
     0.949    17.902     0.150
     1.499    25.230     0.150
     1.499    42.223     0.150
     1.889    56.133     0.150
    13.288   195.523     0.150
     0.952    32.562     0.150
     0.952    19.273     0.150
     0.952    32.562     0.150
     1.487    26.543     0.150
     1.487    45.102     0.150
     1.487    26.551     0.150
     1.487    45.102     0.150
     1.874    33.203     0.150
     1.874    53.602     0.150
     2.598    72.223     0.150
     2.882    82.652     0.150
     3.517    55.773     0.150
     3.517    99.242     0.150
     3.676    65.074     0.150
     3.676    99.594     0.150
     5.033    78.344     0.150
     9.317   142.973     0.150
    13.293   196.160     0.150
    15.102   213.902     0.150
     0.581    53.155     0.150
     0.986    70.366     0.150
     0.986    76.876     0.150
     0.986    17.376     0.150
     0.986    17.376     0.150
     0.986    30.866     0.150
     1.361    82.915     0.150
     1.361    83.126     0.150
     1.468    24.376     0.150
     1.468    42.604     0.150
     1.468    25.515     0.150
     1.468    42.604     0.150
     1.863    53.854     0.150
     1.863    31.095     0.150
     1.863    53.854     0.150
     2.597    70.765     0.150
     2.775    48.075     0.150
     2.908    84.966     0.150
     3.480    96.136     0.150
     3.548    56.466     0.150
     3.548    95.485     0.150
     3.657   104.116     0.150
     3.657    58.185     0.150
     3.657   104.116     0.150
     5.014    76.774     0.150
     5.014   130.896     0.150
     7.709   116.585     0.150
     8.790   126.876     0.150
    76.963   177.056     0.150
     1.496    25.963     0.150
     1.496    43.822     0.150
     1.890    56.652     0.150
     1.890    32.281     0.150
     2.574    41.373     0.150
     3.686   136.082     0.150
     3.686   145.883     0.150
     0.543     9.925     0.150
     0.643    11.715     0.150
     0.643    20.614     0.150
     0.643    11.834     0.150
     0.643    20.425     0.150
     0.643    11.885     0.150
     0.643    20.534     0.150
     0.825    14.734     0.150
     0.825    25.564     0.150
     0.917    16.725     0.150
     0.934    32.545     0.150
     0.934    33.015     0.150
     1.032    42.295     0.150
     1.032    42.645     0.150
     1.032    18.834     0.150
     1.032    32.255     0.150
     1.062    19.284     0.150
     1.062    34.494     0.150
     1.321    43.114     0.150
     1.419    45.854     0.150
     1.590    26.194     0.150
     1.590    45.664     0.150
     2.096    32.725     0.150
     2.096    57.265     0.150
     0.652    12.075     0.150
     0.652    20.845     0.150
     0.652    12.485     0.150
     0.652    21.075     0.150
     0.652    12.595     0.150
     0.652    21.475     0.150
     0.734    24.005     0.150
     0.830    15.385     0.150
     1.047    16.525     0.150
     1.047    29.595     0.150
     1.314    22.925     0.150
     1.595    26.895     0.150
     1.595    26.895     0.150
     1.595    47.395     0.150
     3.184    49.105     0.150
     0.946    17.771     0.150
     0.946    17.771     0.150
     0.946    29.992     0.150
     1.508    24.381     0.150
     1.508    42.781     0.150
     1.508    25.262     0.150
     1.900    56.182     0.150
     1.900    31.412     0.150
     1.900    54.531     0.150
     1.988    32.551     0.150
     1.988    50.191     0.150
     2.867    48.871     0.150
     3.493    96.541     0.150
     4.388    71.500     0.150
     4.388   125.951     0.150
     4.383   119.672     0.150
     5.000    76.492     0.150
     5.000   141.701     0.150
     5.951   163.682     0.150
     7.479   105.332     0.150
    65.093   124.732     0.150
    67.076   130.381     0.150
     9.330   140.756     0.150
    93.013   144.643     0.150
   103.760   216.982     0.150
    65.627   496.572     0.150
     1.468    24.855     0.150
     1.468    43.965     0.150
     1.862    55.266     0.150
     1.862    30.965     0.150
     1.862    54.816     0.150
     1.956    32.746     0.150
     4.347    72.773     0.150
     9.290   142.805     0.150
    13.256   195.883     0.150
    18.504   262.074     0.150
     1.408    43.359     0.150
     1.453    24.669     0.150
     1.453    41.169     0.150
     1.846    31.219     0.150
     0.905    18.070     0.150
     0.905    30.690     0.150
     1.536    25.501     0.150
     1.536    43.831     0.150
     1.536    25.211     0.150
     1.536    43.831     0.150
     1.731    29.480     0.150
     1.920    57.661     0.150
     1.920    32.400     0.150
     1.920    55.201     0.150
     1.995    33.681     0.150
     1.995    57.650     0.150
     2.851    75.150     0.150
     2.832    46.980     0.150
     2.832    78.161     0.150
     3.167    50.860     0.150
     3.660    57.771     0.150
     3.660   103.351     0.150
     3.981   106.851     0.150
     4.469    69.641     0.150
    10.652   148.650     0.150
   103.801   219.761     0.150
    23.365   305.261     0.150
    44.737   493.661     0.150
     0.581    22.031     0.150
     0.869    33.461     0.150
     0.869    30.422     0.150
     0.869    17.371     0.150
     0.869    30.422     0.150
     1.410    51.322     0.150
     1.530    62.732     0.150
     1.563    24.891     0.150
     1.563    43.451     0.150
     1.563    25.152     0.150
     1.563    43.451     0.150
     1.589    66.902     0.150
     1.941    31.461     0.150
     1.941    54.811     0.150
     2.007    32.092     0.150
     2.007    32.092     0.150
     2.007    54.941     0.150
     2.013    29.252     0.150
     2.554    73.791     0.150
     2.883    44.441     0.150
     3.637    54.752     0.150
     3.637    94.662     0.150
     3.668    99.422     0.150
     3.668    59.332     0.150
     3.668    99.422     0.150
     8.010   117.152     0.150
     8.782   224.502     0.150
    10.396   157.221     0.150
    11.909   176.361     0.150
    11.994   178.861     0.150
    12.220   180.781     0.150
    13.209   193.291     0.150
    13.577   189.121     0.150
    13.744   201.121     0.150
    13.944   203.035     0.150
    13.944   203.031     0.150
    15.177   215.152     0.150
   103.832   219.141     0.150
    76.162   464.682     0.150
    65.679   497.631     0.150
    79.069   727.021     0.150
     1.518    24.945     0.150
     1.518    43.785     0.150
     1.518    24.984     0.150
     1.906    30.605     0.150
     1.906    54.477     0.150
     1.987    32.977     0.150
     1.987    32.977     0.150
     1.987    56.305     0.150
     2.830    45.035     0.150
     2.830    73.746     0.150
     2.830    81.453     0.150
     3.512    87.836     0.150
     3.829    62.914     0.150
     4.947    75.465     0.150
     5.010    76.496     0.150
     5.608    83.164     0.150
    19.607   118.863     0.150
    67.336   135.254     0.150
    14.132   200.184     0.150
    14.396   204.184     0.150
    99.335   206.734     0.150
    14.939   210.984     0.150
    22.097   294.816     0.150
    65.636   496.156     0.150
     1.494    25.004     0.150
     1.494    43.254     0.150
     1.888    31.223     0.150
     1.981    32.621     0.150
     3.198    49.555     0.150
     9.313   142.191     0.150
    10.890   163.992     0.150
    13.269   195.844     0.150
     1.540    25.922     0.150
     1.540    48.734     0.150
     1.529    66.484     0.150
     1.893    60.742     0.150
     1.928    31.941     0.150
     3.207    46.082     0.150
     3.769   137.434     0.150
     0.859    15.598     0.150
     1.540    27.789     0.150
     1.540    51.859     0.150
     1.902    57.461     0.150
     0.822    28.664     0.150
     0.822    15.672     0.150
     1.559    25.586     0.150
     1.559    50.758     0.150
     1.867    70.734     0.150
     1.906    60.812     0.150
     2.018    64.781     0.150
     2.648    38.070     0.150
     3.775    61.492     0.150
     0.904    37.457     0.150
     0.935    17.438     0.150
     1.376    51.146     0.150
     1.376    51.348     0.150
     1.511    23.986     0.150
     1.511    42.178     0.150
     1.648    66.217     0.150
     1.983    32.547     0.150
     3.687   135.768     0.150
     3.687   141.428     0.150
     9.338   141.758     0.150
    18.552   261.051     0.150
    40.592   465.416     0.150
     0.921    40.617     0.150
     1.413    54.273     0.150
     1.547    24.078     0.150
     1.547    23.797     0.150
     1.547    42.617     0.150
     1.604    31.281     0.150
     1.799    69.078     0.150
     1.799    74.703     0.150
     1.926    55.938     0.150
     1.926    30.672     0.150
     3.677    60.609     0.150
     3.686   129.344     0.150
     3.686   131.664     0.150
     4.435    66.789     0.150
    93.081   148.203     0.150
   103.829   217.477     0.150
    24.455   319.352     0.150
    65.663   496.938     0.150
    85.021   754.641     0.150
    84.980   755.047     0.150
    85.615   759.070     0.150
     0.947    16.555     0.150
     0.950    31.375     0.150
     0.950    18.805     0.150
     0.950    31.375     0.150
     1.411    41.570     0.150
     1.459    41.883     0.150
     1.478    25.953     0.150
     1.478    43.836     0.150
     1.478    26.219     0.150
     1.861    32.086     0.150
     1.861    55.391     0.150
     1.940    33.133     0.150
     1.940    56.672     0.150
     3.535    58.734     0.150
     3.554    57.375     0.150
     3.554    98.109     0.150
     3.731   107.672     0.150
     4.159    66.633     0.150
     4.421    66.180     0.150
     4.809    76.391     0.150
     5.979    92.734     0.150
     7.992   121.039     0.150
    19.651   118.633     0.150
    65.128   126.695     0.150
    78.568   142.398     0.150
    93.049   145.523     0.150
    10.324   155.516     0.150
    38.624   159.969     0.150
    17.221   164.609     0.150
    11.841   176.641     0.150
    13.041   192.500     0.150
    13.125   193.492     0.150
    13.668   201.461     0.150
    13.859   204.367     0.150
    18.539   262.164     0.150
    18.539   255.859     0.150
    23.327   312.383     0.150
    25.117   328.312     0.150
    25.202   329.414     0.150
    26.608   343.203     0.150
    27.276   351.852     0.150
    87.603   383.422     0.150
    79.850   734.445     0.150
    85.550   764.852     0.150
    91.212   794.867     0.150
    91.212   808.641     0.150
    94.638   808.344     0.150
    97.370   819.320     0.150
    98.056   823.242     0.150
   122.519  1142.945     0.150
     0.902    37.869     0.150
     1.373    50.809     0.150
     1.373    51.719     0.150
     1.461    61.719     0.150
     1.511    24.679     0.150
     1.511    42.569     0.150
     1.649    32.489     0.150
     1.900    55.549     0.150
     3.685   130.819     0.150
     3.685   131.419     0.150
     0.731    22.598     0.150
     0.831    20.299     0.150
     0.831    32.979     0.150
     1.162    33.168     0.150
     1.162    21.018     0.150
     1.162    33.168     0.150
     1.194    27.758     0.150
     1.194    45.678     0.150
     1.222    28.068     0.150
     1.222    46.289     0.150
     1.405    27.709     0.150
     1.405    47.418     0.150
     1.405    24.988     0.150
     1.453    31.777     0.150
     1.453    53.469     0.150
     1.842    34.408     0.150
     1.842    58.818     0.150
     1.842    34.328     0.150
     1.842    58.879     0.150
     1.842    34.328     0.150
     1.842    58.879     0.150
     2.001    35.598     0.150
     2.001    60.488     0.150
     3.033    45.328     0.150
     3.276    58.088     0.150
     3.533    58.027     0.150
     3.533   101.168     0.150
     4.243    70.896     0.150
     4.243    87.822     0.150
     4.543   127.318     0.150
     4.677    70.918     0.150
     5.077    76.518     0.150
     7.737   120.697     0.150
     7.737   211.172     0.150
     8.694   133.986     0.150
     8.694   234.729     0.150
     9.156   141.004     0.150
    10.693   163.254     0.150
    13.047   195.629     0.150
    13.725   204.336     0.150
   103.526   213.428     0.150
    15.249   213.549     0.150
    15.406   215.129     0.150
    15.375   217.148     0.150
    15.463   216.518     0.150
   122.314   223.697     0.150
    16.429   228.697     0.150
    16.446   229.107     0.150
    16.614   231.389     0.150
    18.328   264.623     0.150
    24.146   325.879     0.150
    40.404   466.178     0.150
    65.778   651.904     0.150
    97.937   813.629     0.150
     0.930    18.424     0.150
     0.930    18.424     0.150
     0.930    32.035     0.150
     1.498    25.914     0.150
     1.498    25.254     0.150
     1.498    43.594     0.150
     1.880    31.834     0.150
     1.880    54.125     0.150
     1.955    33.184     0.150
     2.866    39.154     0.150
     4.158    59.943     0.150
     4.385    71.723     0.150
     4.829    70.715     0.150
     5.782    83.904     0.150
     6.621   100.375     0.150
     7.467   106.375     0.150
     7.450   105.705     0.150
    13.879   203.342     0.150
   103.805   214.834     0.150
    21.448   286.324     0.150
    25.825   328.455     0.150
    65.880   644.604     0.150
     1.468    24.811     0.150
     1.468    43.270     0.150
     1.856    53.520     0.150
     4.351    90.334     0.150
     9.297   142.309     0.150
    13.278   195.332     0.150
     0.935    18.439     0.150
     0.939    18.789     0.150
     0.939    31.279     0.150
     1.494    26.068     0.150
     1.494    26.250     0.150
     1.494    44.459     0.150
     1.707    29.959     0.150
     1.877    56.049     0.150
     1.877    32.580     0.150
     1.955    33.709     0.150
     1.955    58.568     0.150
     5.773    88.408     0.150
    13.873   199.479     0.150
    76.568   211.699     0.150
   103.795   217.080     0.150
    30.598   228.520     0.150
    21.014   283.199     0.150
    40.583   459.080     0.150
    65.876   645.580     0.150
    86.600  2703.369     0.150
    97.380   814.539     0.150
     1.398    52.207     0.150
     1.398    52.391     0.150
     1.538    24.680     0.150
     1.538    42.758     0.150
     1.988    43.391     0.150
     3.682   105.250     0.150
     0.566    20.785     0.150
     0.901    35.402     0.150
     0.901    28.383     0.150
     1.408    56.543     0.150
     1.408    63.133     0.150
     1.531    25.312     0.150
     1.531    43.484     0.150
     1.911    31.965     0.150
     1.982    68.664     0.150
     1.982    32.945     0.150
     3.693   135.082     0.150
     0.914    32.070     0.150
     0.914    16.867     0.150
     0.914    28.773     0.150
     1.534    42.539     0.150
     1.534    25.367     0.150
     1.534    25.344     0.150
     1.534    42.539     0.150
     1.921    57.047     0.150
     1.921    32.062     0.150
     1.921    53.852     0.150
     2.001    32.773     0.150
     2.001    56.961     0.150
     2.555    70.680     0.150
     2.846    49.500     0.150
     2.838    46.781     0.150
     2.838    81.500     0.150
     3.165    81.773     0.150
     3.521    98.391     0.150
     3.514    93.180     0.150
     3.611    55.578     0.150
     3.611    95.602     0.150
     4.458    69.859     0.150
     4.929    72.133     0.150
     5.506    98.578     0.150
     7.968   117.078     0.150
    17.193   161.672     0.150
    84.937   758.312     0.150
     0.911    18.797     0.150
     0.911    30.992     0.150
     1.522    44.477     0.150
     1.522    25.078     0.150
     1.522    25.562     0.150
     1.522    44.477     0.150
     1.731    29.242     0.150
     1.903    57.008     0.150
     1.903    32.273     0.150
     1.903    56.758     0.150
     1.976    33.391     0.150
     1.976    57.992     0.150
     2.582    71.938     0.150
     2.844    45.773     0.150
     2.844    80.000     0.150
     3.214    52.992     0.150
     3.506    98.797     0.150
     3.542    95.969     0.150
     3.597    57.156     0.150
     3.597   100.938     0.150
     9.357   142.648     0.150
    17.223   165.906     0.150
    13.332   194.844     0.150
   103.810   219.930     0.150
    30.053   367.062     0.150
    32.664   392.781     0.150
     0.844    13.738     0.150
     0.844    24.988     0.150
     1.090    56.285     0.150
     1.557    29.316     0.150
     1.557    47.727     0.150
     2.155    61.688     0.150
     2.415    75.605     0.150
     3.504   148.746     0.150
     4.759   138.207     0.150
     0.917    37.883     0.150
     0.917    41.191     0.150
     1.374    52.242     0.150
     1.477    24.672     0.150
     1.477    43.453     0.150
     1.868    55.562     0.150
     1.958    33.109     0.150
     3.708   129.820     0.150
     4.358    72.227     0.150
     9.302   141.000     0.150
     1.410    26.581     0.150
     1.410    45.781     0.150
     1.848    54.852     0.150
     3.617    60.142     0.150
     0.577    23.432     0.150
     0.863    30.383     0.150
     1.417    52.393     0.150
     1.417    54.281     0.150
     1.565    27.271     0.150
     1.565    47.361     0.150
     1.785    66.713     0.150
     1.785    74.082     0.150
     2.005    65.262     0.150
     3.566    59.121     0.150
     0.581    20.656     0.150
     1.393    54.037     0.150
     1.393    55.027     0.150
     1.536    25.547     0.150
     1.536    44.717     0.150
     1.994    33.078     0.150
     3.681   133.498     0.150
     3.681   134.227     0.150
     7.988   120.936     0.150
     8.782   132.242     0.150
    13.333   197.268     0.150
    18.585   262.936     0.150
     0.515    28.008     0.150
     0.871    48.812     0.150
     0.871    16.172     0.150
     0.871    16.172     0.150
     0.871    27.609     0.150
     1.474    59.562     0.150
     1.533    25.578     0.150
     1.533    43.820     0.150
     1.533    25.758     0.150
     1.533    45.172     0.150
     1.612    31.492     0.150
     1.899    30.422     0.150
     1.899    56.117     0.150
     1.951    32.461     0.150
     1.951    56.188     0.150
     1.951    58.289     0.150
     2.698    46.141     0.150
     3.508    56.273     0.150
     3.614    97.734     0.150
     3.736   153.539     0.150
     3.736   171.523     0.150
     5.090    75.352     0.150
     5.749    83.164     0.150
     7.141   101.984     0.150
    17.294   163.078     0.150
    13.590   190.109     0.150
   103.881   217.664     0.150
    22.196   293.414     0.150
     0.543    20.805     0.150
     1.447    54.047     0.150
     1.447    54.695     0.150
     1.545    26.070     0.150
     1.545    44.555     0.150
     3.590    58.383     0.150
     3.709   132.695     0.150
     8.820   131.891     0.150
     0.545    26.180     0.150
     0.944    13.719     0.150
     0.944    28.883     0.150
     0.944    43.859     0.150
     0.906    35.242     0.150
     0.906    16.906     0.150
     1.426    60.195     0.150
     1.503    41.102     0.150
     1.517    26.750     0.150
     1.517    47.391     0.150
     1.633    57.312     0.150
     1.633    69.781     0.150
     1.894    51.477     0.150
     1.968    33.492     0.150
     1.968    58.039     0.150
     1.830    63.719     0.150
     1.830    83.227     0.150
     1.962    30.906     0.150
     1.962    53.891     0.150
     2.841    82.383     0.150
     3.499    58.492     0.150
     3.715   141.367     0.150
     4.406    74.258     0.150
     4.406    91.586     0.150
     9.358   145.336     0.150
    10.952   166.414     0.150
     0.516    20.234     0.150
     0.894    30.484     0.150
     1.460    54.938     0.150
     1.460    57.195     0.150
     1.515    24.711     0.150
     1.515    23.875     0.150
     1.515    43.445     0.150
     1.632    64.141     0.150
     1.845    77.859     0.150
     1.885    54.461     0.150
     1.885    54.094     0.150
     2.846    78.297     0.150
     9.364   141.195     0.150
    10.968   164.391     0.150
    13.370   195.945     0.150
   103.859   218.250     0.150
     0.954    32.217     0.150
     0.966     8.627     0.150
     0.966    21.938     0.150
     1.411    55.237     0.150
     1.411    57.177     0.150
     1.463    26.797     0.150
     1.463    44.577     0.150
     1.847    32.647     0.150
     3.448    57.037     0.150
     0.890    31.526     0.150
     0.890    25.486     0.150
     1.439    53.076     0.150
     1.439    54.786     0.150
     1.521    44.666     0.150
     1.528    24.116     0.150
     1.528    24.216     0.150
     1.528    42.776     0.150
     1.902    44.046     0.150
     1.964    72.006     0.150
     2.832    40.766     0.150
     3.716   135.006     0.150
     3.716   135.966     0.150
     7.494   105.286     0.150
     7.781   111.226     0.150
     8.032   143.800     0.150
    19.611   117.726     0.150
   110.215   200.906     0.150
    14.186   202.486     0.150
     5.371   205.596     0.150
    14.450   204.406     0.150
    99.269   207.346     0.150
    84.720   211.776     0.150
   103.845   217.696     0.150
     0.579    34.531     0.150
     0.908    41.521     0.150
     0.908    49.230     0.150
     0.910    53.131     0.150
     1.393    58.000     0.150
     1.492    86.891     0.150
     1.624    79.871     0.150
     1.806    80.500     0.150
     1.915    30.381     0.150
     1.990    31.471     0.150
     1.990    57.361     0.150
     3.333    58.291     0.150
     3.664    91.080     0.150
     3.954    66.070     0.150
     4.416    72.779     0.150
     4.466    72.852     0.150
     4.860    80.820     0.150
     4.968    78.881     0.150
   103.802   226.031     0.150
    18.580   263.830     0.150
     0.563    21.195     0.150
     0.892    17.266     0.150
     1.416    56.375     0.150
     1.416    56.695     0.150
     1.536    26.695     0.150
     1.536    46.605     0.150
     1.915    57.098     0.150
     3.519    58.387     0.150
     3.695   154.195     0.150
     0.858    17.086     0.150
     0.936    39.156     0.150
     1.437    56.727     0.150
     1.437    57.008     0.150
     1.562    25.355     0.150
     1.562    45.035     0.150
     1.562    25.777     0.150
     1.562    44.828     0.150
     1.548    64.617     0.150
     1.794    67.188     0.150
     1.794    78.477     0.150
     1.993    32.637     0.150
     2.889    43.477     0.150
     3.542    58.547     0.150
     3.585    55.328     0.150
     3.691   136.555     0.150
     3.691   139.445     0.150
     3.812    60.395     0.150
    13.218   194.238     0.150
    13.759   200.777     0.150
    13.948   204.086     0.150
    14.476   207.086     0.150
    33.488   405.938     0.150
    39.163   460.516     0.150
    43.650   483.246     0.150
    65.676   498.395     0.150
    52.410   564.637     0.150
    52.810   561.086     0.150
    58.939   599.336     0.150
    88.559   779.277     0.150
    89.865   785.707     0.150
     0.570    21.652     0.150
     0.570    37.160     0.150
     0.926    43.652     0.150
     0.860    26.109     0.150
     0.860    17.691     0.150
     0.860    31.891     0.150
     1.426    61.062     0.150
     1.426    73.031     0.150
     1.585    69.711     0.150
     1.565    26.852     0.150
     1.565    47.801     0.150
     1.788    84.820     0.150
     2.000    90.020     0.150
     2.000    37.711     0.150
     3.683    60.410     0.150
     3.683   153.281     0.150
     3.683   164.793     0.150
     4.454    92.688     0.150
     8.027   122.102     0.150
     9.406   145.031     0.150
    10.997   167.582     0.150
    13.381   199.430     0.150
     0.558    20.484     0.150
     0.934    38.555     0.150
     1.425    52.824     0.150
     1.425    54.543     0.150
     1.541    23.875     0.150
     1.541    43.293     0.150
     1.981    30.375     0.150
     0.929    46.766     0.150
     1.390    54.578     0.150
     1.482    24.539     0.150
     1.482    43.648     0.150
     1.869    54.418     0.150
     3.678   104.797     0.150
     3.715   137.996     0.150
     7.972   120.785     0.150
     9.311   141.418     0.150
    10.899   164.492     0.150
    13.289   196.270     0.150
     0.860    38.852     0.150
     0.860    30.922     0.150
     1.422    55.367     0.150
     1.567    25.836     0.150
     1.567    44.711     0.150
     1.780    33.297     0.150
     2.004    33.031     0.150
     3.679   146.195     0.150
     5.581    75.016     0.150
     5.581   135.367     0.150
     0.927    31.488     0.150
     1.420    55.078     0.150
     1.420    55.328     0.150
     1.546    24.338     0.150
     1.546    45.098     0.150
     1.605    31.838     0.150
     1.802    41.178     0.150
     1.989    32.678     0.150
     2.572    36.318     0.150
     3.683    49.638     0.150
     3.691   130.778     0.150
     0.647    21.797     0.150
     0.846    35.594     0.150
     1.299    50.195     0.150
     1.299    51.078     0.150
     1.404    53.969     0.150
     1.506    29.453     0.150
     1.506    43.039     0.150
     1.804    36.094     0.150
     1.804    60.430     0.150
     1.804    72.570     0.150
     1.804    78.414     0.150
     1.947    41.070     0.150
     1.947    64.188     0.150
     2.017    53.438     0.150
     2.538    90.789     0.150
     3.645   136.516     0.150
     3.645   144.219     0.150
     5.595   189.289     0.150
     0.633    22.678     0.150
     1.061    18.648     0.150
     1.295    44.968     0.150
     1.295    51.678     0.150
     1.432    25.548     0.150
     1.432    43.298     0.150
     1.872    36.349     0.150
     1.872    60.309     0.150
     1.872    72.158     0.150
     1.966    33.198     0.150
     0.885    17.641     0.150
     0.928    49.617     0.150
     1.419    57.910     0.150
     1.543    30.500     0.150
     1.543    51.660     0.150
     1.805    28.199     0.150
     2.865    84.699     0.150
     3.525    58.789     0.150
     3.561   122.379     0.150
     3.693   147.609     0.150
     3.693   148.391     0.150
     0.525    21.203     0.150
     0.910    25.812     0.150
     0.910    17.641     0.150
     0.910    29.867     0.150
     1.444    57.875     0.150
     1.444    58.891     0.150
     1.506    24.391     0.150
     1.506    27.844     0.150
     1.506    45.953     0.150
     1.880    31.211     0.150
     1.944    32.172     0.150
     1.944    56.477     0.150
     2.854    46.812     0.150
     3.718   105.617     0.150
     4.436    64.617     0.150
     4.842    69.211     0.150
     4.900    69.570     0.150
     5.073    75.555     0.150
     5.073   140.758     0.150
     5.480    77.883     0.150
     7.724   227.672     0.150
    65.107   126.875     0.150
     8.837   259.539     0.150
     9.350   145.836     0.150
   103.839   219.633     0.150
    40.606   466.578     0.150
     0.560    21.492     0.150
     0.901    25.160     0.150
     0.901    26.590     0.150
     1.528    26.059     0.150
     1.528    26.059     0.150
     1.528    45.480     0.150
     1.414    57.230     0.150
     1.504    81.539     0.150
     1.624    32.020     0.150
     1.624    65.359     0.150
     1.908    31.832     0.150
     1.908    55.719     0.150
     1.816    79.191     0.150
     1.816    87.172     0.150
     1.977    32.160     0.150
     1.977    55.992     0.150
     2.581    98.230     0.150
     2.581    91.512     0.150
     2.849    65.789     0.150
     2.836    83.199     0.150
     3.181    98.941     0.150
     3.512    95.469     0.150
     3.603   122.051     0.150
     3.552   106.281     0.150
     3.683    62.449     0.150
     3.683   142.141     0.150
     3.683   142.410     0.150
     3.683    61.762     0.150
     4.456    65.770     0.150
     5.038   170.730     0.150
     5.254    76.359     0.150
     5.612    84.750     0.150
     5.612   189.992     0.150
     5.937    89.762     0.150
     6.294    91.660     0.150
     7.209   103.422     0.150
     7.496   105.422     0.150
     7.690   119.512     0.150
     7.690   253.469     0.150
     7.716   256.871     0.150
    65.080   125.441     0.150
     8.829   291.242     0.150
     9.347   142.469     0.150
     9.373   143.270     0.150
    10.369   158.141     0.150
    10.369   156.172     0.150
    10.937   157.809     0.150
    11.884   178.141     0.150
    12.252   180.961     0.150
    76.899   176.711     0.150
    13.084   192.941     0.150
    13.084   192.371     0.150
    13.176   194.691     0.150
    13.343   196.570     0.150
    13.343   195.621     0.150
    13.615   215.969     0.150
    76.602   212.242     0.150
    17.825     3.500     0.150
    18.588   262.969     0.150
    24.189     2.902     0.150
    13.134   411.859     0.150
    82.156   747.781     0.150
    85.002   756.012     0.150
    86.627  2660.070     0.150
    86.627  2780.070     0.150
     0.554    21.805     0.150
     0.912    16.930     0.150
     0.912    16.930     0.150
     0.912    29.055     0.150
     1.516    24.781     0.150
     1.516    24.641     0.150
     1.516    43.273     0.150
     1.636    61.852     0.150
     1.896    31.305     0.150
     1.896    54.211     0.150
     1.968    29.766     0.150
     1.968    32.406     0.150
     1.968    59.094     0.150
     2.590    35.266     0.150
     2.590    62.531     0.150
     3.192    45.180     0.150
     3.192    80.750     0.150
     3.549    50.250     0.150
     3.707   130.836     0.150
     3.688   139.680     0.150
     3.688    90.945     0.150
     7.484   105.625     0.150
     0.840    25.873     0.150
     0.840    29.033     0.150
     0.840    29.033     0.150
     0.936    39.503     0.150
     1.443    58.033     0.150
     1.578    45.953     0.150
     1.578    26.623     0.150
     1.578    25.543     0.150
     1.578    45.953     0.150
     1.569    31.603     0.150
     1.949    31.393     0.150
     1.949    54.573     0.150
     2.003    32.383     0.150
     2.003    32.383     0.150
     2.003    54.503     0.150
     2.031    69.293     0.150
     2.327    36.113     0.150
     2.562    94.893     0.150
     2.781    57.903     0.150
     2.781   102.383     0.150
     2.906    73.883     0.150
     2.906    73.883     0.150
     3.143   109.153     0.150
     3.260    54.223     0.150
     3.557    56.003     0.150
     3.649    61.213     0.150
     3.649   125.873     0.150
     3.649    61.213     0.150
     3.685   137.713     0.150
     3.693    68.873     0.150
     3.693   127.723     0.150
     4.135    64.663     0.150
     4.470    73.792     0.150
     4.531    70.633     0.150
     5.046   154.343     0.150
     5.046    79.913     0.150
     5.046   154.343     0.150
     5.580   159.283     0.150
     5.580   159.283     0.150
     5.894   129.062     0.150
     5.894   215.343     0.150
     7.668   133.833     0.150
     7.668   234.133     0.150
     7.668   133.833     0.150
     7.668   234.133     0.150
     8.796   133.073     0.150
     8.796   297.613     0.150
     9.423   143.147     0.150
    11.018   164.272     0.150
    11.018   164.272     0.150
    13.965   205.361     0.150
    13.965   205.363     0.150
    84.750   217.703     0.150
    76.662   216.243     0.150
    16.278   227.243     0.150
    16.725   232.833     0.150
    21.388   282.592     0.150
    25.844   330.863     0.150
    32.737   395.843     0.150
    83.458   750.843     0.150
    85.018   757.723     0.150
     0.926    46.703     0.150
     0.932    16.891     0.150
     0.932    30.859     0.150
     1.398    55.910     0.150
     1.398    57.621     0.150
     1.503    24.871     0.150
     1.503    43.270     0.150
     1.503    26.543     0.150
     1.888    56.852     0.150
     1.888    31.512     0.150
     1.888    54.641     0.150
     1.966    32.723     0.150
     1.966    46.359     0.150
     1.966    32.723     0.150
     1.966    46.359     0.150
     2.864    59.062     0.150
     3.678    63.160     0.150
     3.678    99.312     0.150
     3.706   136.480     0.150
     3.706   137.242     0.150
     4.429    69.520     0.150
     5.034    77.070     0.150
     5.034   132.590     0.150
     5.628    81.293     0.150
     5.628   129.082     0.150
     8.802   128.633     0.150
     8.802   226.801     0.150
    10.337   156.402     0.150
    93.054   154.691     0.150
    11.852   177.973     0.150
    13.052   193.230     0.150
    13.145   193.602     0.150
    13.683   201.602     0.150
    14.023   199.293     0.150
    84.668   213.980     0.150
    76.571   214.602     0.150
    19.935   274.711     0.150
    20.047   277.020     0.150
    26.994   344.512     0.150
    32.643   559.211     0.150
    32.643   394.312     0.150
    40.590   462.191     0.150
    40.796   462.652     0.150
    65.621   499.832     0.150
     5.806   500.531     0.150
    79.867   729.781     0.150
    80.843   732.539     0.150
    82.135   748.082     0.150
    83.802   753.930     0.150
    84.543   757.082     0.150
    84.782   756.980     0.150
     0.569    20.879     0.150
     0.569    20.930     0.150
     0.895    30.479     0.150
     0.921    38.809     0.150
     0.921    38.949     0.150
     1.408    56.389     0.150
     1.408    57.359     0.150
     1.507    25.709     0.150
     1.507    66.129     0.150
     1.537    25.078     0.150
     1.537    43.459     0.150
     1.537    24.939     0.150
     1.537    43.459     0.150
     1.616    64.209     0.150
     1.616    64.699     0.150
     1.746    82.879     0.150
     1.917    54.920     0.150
     1.987    32.898     0.150
     1.987    57.139     0.150
     2.828    83.658     0.150
     3.520    50.709     0.150
     3.520   102.539     0.150
     3.549    50.010     0.150
     3.611    97.520     0.150
     3.676    99.260     0.150
     3.690   133.590     0.150
     3.690   135.459     0.150
     4.424   125.584     0.150
     5.031    76.148     0.150
     5.031   130.959     0.150
     5.928    84.559     0.150
     5.928   158.180     0.150
     7.681   206.969     0.150
     7.707   108.359     0.150
    19.596   119.590     0.150
     8.568   133.340     0.150
    65.072   124.309     0.150
     8.820   226.219     0.150
     9.372   141.275     0.150
    10.373   158.059     0.150
    12.070   310.789     0.150
    12.243   180.729     0.150
    12.243   171.078     0.150
    12.243   180.639     0.150
    12.373   177.279     0.150
    12.875   176.879     0.150
    13.087   193.010     0.150
    13.182   194.039     0.150
    13.720   201.959     0.150
    13.917   202.326     0.150
    96.244   201.260     0.150
    14.692   370.510     0.150
   103.819   217.600     0.150
    16.223   233.840     0.150
    20.362   282.039     0.150
    21.875   291.270     0.150
    24.184   322.039     0.150
    25.990   340.539     0.150
    87.639   379.129     0.150
    65.653   496.180     0.150
    88.297   773.074     0.150
    88.700   775.523     0.150
     0.867    16.740     0.150
     0.925    38.631     0.150
     1.423    54.641     0.150
     1.423    55.250     0.150
     1.559    24.420     0.150
     1.559    46.029     0.150
     3.632   103.631     0.150
     3.685   135.189     0.150
     3.685   135.990     0.150
     9.399   141.957     0.150
     0.849    35.238     0.150
     1.433    59.758     0.150
     1.433    64.766     0.150
     1.573    25.227     0.150
     1.573    44.727     0.150
     2.004    32.918     0.150
     3.685    60.809     0.150
     0.575    17.947     0.150
     1.403    55.678     0.150
     1.540    25.559     0.150
     1.540    44.178     0.150
     1.992    33.059     0.150
     1.992    57.518     0.150
     3.684   105.879     0.150
     5.925   199.559     0.150
     1.331    51.298     0.150
     1.329    23.638     0.150
     1.329    40.438     0.150
     1.768    29.328     0.150
     1.768    51.578     0.150
     1.879    31.878     0.150
     3.779   133.627     0.150
     1.352    23.145     0.150
     1.352    37.294     0.150
     1.762    29.924     0.150
     1.792   251.145     0.150
     1.888    31.764     0.150
     3.770   144.254     0.150
     1.494    24.977     0.150
     1.494    24.648     0.150
     1.494    43.578     0.150
     1.884    31.508     0.150
     1.884    31.508     0.150
     1.970    33.055     0.150
     1.970    58.547     0.150
     2.585    41.086     0.150
     2.805    41.648     0.150
     2.805    46.055     0.150
     2.805    81.445     0.150
     2.878    83.531     0.150
     3.482    53.914     0.150
     3.482    95.055     0.150
     3.502    51.016     0.150
     3.572    55.656     0.150
     3.572    98.250     0.150
     3.660    56.531     0.150
     3.660    56.531     0.150
     4.839   135.086     0.150
     8.845   131.047     0.150
     9.320   141.656     0.150
    13.774   202.648     0.150
    17.940   246.805     0.150
    20.984   280.461     0.150
    21.783   288.984     0.150
    22.234   296.008     0.150
    65.613   497.781     0.150
     0.956    11.422     0.150
     0.956    34.141     0.150
     1.493    24.391     0.150
     1.493    40.875     0.150
     1.884    24.922     0.150
     1.884    55.086     0.150
     1.940    24.141     0.150
     1.972    33.344     0.150
     3.202    32.086     0.150
     3.482    43.484     0.150
     3.572    46.609     0.150
     3.695    96.602     0.150
     0.890    15.539     0.150
     0.890    26.656     0.150
     1.543    24.492     0.150
     1.543    23.516     0.150
     1.543    40.633     0.150
     1.749    28.297     0.150
     1.923    55.523     0.150
     1.923    50.180     0.150
     1.923    31.336     0.150
     1.923    50.180     0.150
     1.993    49.438     0.150
     1.993    32.773     0.150
     1.993    49.438     0.150
     1.993    50.664     0.150
     3.527    50.727     0.150
     3.618    78.180     0.150
     3.618    53.555     0.150
     4.430    71.656     0.150
     9.378   141.305     0.150
    93.073   146.516     0.150
   103.821   217.719     0.150
     0.914    27.205     0.150
     1.520    25.016     0.150
     1.520    44.305     0.150
     1.903    31.625     0.150
     3.676   105.477     0.150
     1.499    24.867     0.150
     1.499    43.719     0.150
     1.948    52.098     0.150
     1.499    25.973     0.150
     1.499    44.160     0.150
     0.824    15.789     0.150
     0.824    27.359     0.150
     1.558    26.062     0.150
     1.558    44.750     0.150
     1.904    56.117     0.150
     9.427   143.211     0.150
    13.472   197.367     0.150
    18.683   264.234     0.150
     0.877    17.500     0.150
     0.877    29.711     0.150
     1.552    25.047     0.150
     1.552    45.180     0.150
     3.677   105.078     0.150
     5.031    81.867     0.150
     0.853    17.899     0.150
     0.853    29.409     0.150
     0.853    10.649     0.150
     0.853    21.229     0.150
     1.460    55.089     0.150
     1.557    25.439     0.150
     1.557    44.139     0.150
     1.978    28.539     0.150
     1.978    50.429     0.150
     0.860    24.944     0.150
     0.860    35.014     0.150
     0.860    30.304     0.150
     1.436    55.833     0.150
     1.436    56.944     0.150
     1.560    25.174     0.150
     1.560    44.814     0.150
     1.991    30.774     0.150
     0.624    19.305     0.150
     0.865    18.295     0.150
     0.865    31.865     0.150
     0.952    25.915     0.150
     0.952    39.945     0.150
     0.952    18.115     0.150
     0.952    18.115     0.150
     0.952    32.465     0.150
     1.331    25.925     0.150
     1.331    45.035     0.150
     1.331    65.635     0.150
     1.331    66.695     0.150
     1.439    29.515     0.150
     1.439    49.265     0.150
     1.439    80.225     0.150
     1.520    26.695     0.150
     1.520    45.064     0.150
     1.520    26.695     0.150
     1.520    45.064     0.150
     1.650    65.265     0.150
     1.799    79.845     0.150
     1.917    56.375     0.150
     1.917    33.035     0.150
     1.917    56.375     0.150
     2.011    33.555     0.150
     2.011    58.895     0.150
     2.191    33.064     0.150
     3.511    57.755     0.150
     3.601    56.395     0.150
     3.614    58.295     0.150
     4.077    60.005     0.150
     4.898    70.595     0.150
     4.971    76.104     0.150
     5.592    84.705     0.150
     8.591   123.415     0.150
     8.808   125.835     0.150
     9.333   144.330     0.150
    13.270   196.255     0.150
    15.083   209.814     0.150
     0.905    35.201     0.150
     0.937    38.141     0.150
     1.420    54.941     0.150
     1.521    24.301     0.150
     1.521    43.071     0.150
     1.900    28.721     0.150
     2.842    40.181     0.150
     3.708   134.001     0.150
     3.708   135.771     0.150
     4.409    71.106     0.150
     0.803    16.209     0.150
     0.803    27.429     0.150
     0.804    38.869     0.150
     0.804    46.039     0.150
     1.278    42.379     0.150
     1.372    51.778     0.150
     1.520    66.198     0.150
     1.520    69.759     0.150
     1.550    59.778     0.150
     1.550    46.829     0.150
     4.190   155.119     0.150
     4.190   159.249     0.150
     0.975    37.145     0.150
     1.184    47.594     0.150
     1.222    47.254     0.150
     1.312    50.863     0.150
     1.273    22.984     0.150
     1.273    40.215     0.150
     1.856    71.273     0.150
     1.856    32.184     0.150
     2.022    84.473     0.150
     2.716    83.785     0.150
     3.805   128.945     0.150
     3.805   142.004     0.150
     0.661    24.256     0.150
     0.923    38.445     0.150
     1.199    48.045     0.150
     1.270    50.336     0.150
     1.322    23.545     0.150
     1.322    39.445     0.150
     3.322    55.746     0.150
     3.752   132.295     0.150
     3.752   142.234     0.150
     0.694    22.625     0.150
     0.897    18.105     0.150
     0.897    31.273     0.150
     0.897    39.035     0.150
     1.184    22.945     0.150
     1.184    49.035     0.150
     1.206    52.543     0.150
     1.206    22.402     0.150
     1.206    22.402     0.150
     1.206    39.055     0.150
     1.335    23.766     0.150
     1.335    41.582     0.150
     1.335    23.695     0.150
     1.335    41.152     0.150
     1.238    24.285     0.150
     1.238    51.504     0.150
     1.421    26.645     0.150
     1.421    56.074     0.150
     1.421    26.402     0.150
     1.771    30.516     0.150
     1.771    52.133     0.150
     1.934    81.863     0.150
     1.934    32.484     0.150
     1.934    56.414     0.150
     1.953    33.922     0.150
     2.185    62.395     0.150
     2.594    70.812     0.150
     3.421    98.355     0.150
     3.421    98.355     0.150
     3.588    56.402     0.150
     3.588   102.305     0.150
     3.728   134.016     0.150
     3.728   142.223     0.150
     4.950   130.195     0.150
    11.562   172.484     0.150
    11.681   174.555     0.150
    13.662   201.473     0.150
    18.281   252.715     0.150
    18.715   257.172     0.150
    19.764   269.016     0.150
    21.327   285.453     0.150
    21.916   292.465     0.150
    22.872   302.113     0.150
    24.617   318.934     0.150
    37.624   434.434     0.150
    40.332   456.184     0.150
    40.345   456.434     0.150
    40.719   466.672     0.150
    41.761   468.195     0.150
    43.339   481.062     0.150
    65.448   500.555     0.150
    83.716   755.105     0.150
    86.539   769.863     0.150
     0.935    31.410     0.150
     1.203    21.660     0.150
     1.310    22.172     0.150
     1.310    38.852     0.150
     2.676    52.750     0.150
     2.676    81.770     0.150
     3.629    59.922     0.150
     3.765   129.691     0.150
     3.765   131.590     0.150
     1.023    34.609     0.150
     1.318    50.883     0.150
     1.318    56.852     0.150
     1.371    72.125     0.150
     1.455    24.828     0.150
     1.455    42.859     0.150
     3.227   119.062     0.150
     3.450    70.000     0.150
     3.450   118.508     0.150
     3.690   142.570     0.150
     3.690   148.141     0.150
     0.659    13.318     0.150
     0.659    22.498     0.150
     0.757    35.449     0.150
     1.055    26.508     0.150
     1.156    38.379     0.150
     1.478    49.549     0.150
     1.478    26.268     0.150
     1.515    54.908     0.150
     1.613    63.479     0.150
     1.613    65.248     0.150
     3.278    47.389     0.150
     3.464    60.947     0.150
     0.984    17.979     0.150
     0.984    33.328     0.150
     1.197    45.809     0.150
     1.537    39.107     0.150
     1.448    56.887     0.150
     1.391    53.867     0.150
     1.400    46.447     0.150
     1.684    64.717     0.150
     1.684    28.697     0.150
     2.312    43.318     0.150
     2.312    87.068     0.150
     2.312    87.178     0.150
     3.066    42.748     0.150
     4.022   139.158     0.150
     1.188    40.066     0.150
     0.995    18.004     0.150
     0.995    33.855     0.150
     1.388    55.645     0.150
     1.388    65.016     0.150
     1.523    20.074     0.150
     1.523    37.227     0.150
     1.457    47.375     0.150
     1.688    71.586     0.150
     1.688    28.477     0.150
     1.688    49.805     0.150
     2.950    38.996     0.150
     2.950    72.316     0.150
     2.995    85.016     0.150
     3.679    88.734     0.150
     0.932    37.336     0.150
     1.188    47.078     0.150
     1.209    22.141     0.150
     1.273    50.898     0.150
     1.309    22.922     0.150
     1.309    22.477     0.150
     1.309    39.383     0.150
     1.309    23.406     0.150
     1.740    50.938     0.150
     1.740    50.891     0.150
     1.899    31.359     0.150
     3.395    96.570     0.150
     3.362   130.547     0.150
     3.762   142.148     0.150
     1.338    22.648     0.150
     1.338    40.018     0.150
     1.338    23.457     0.150
     1.338    40.678     0.150
     1.907    31.988     0.150
     1.907    55.668     0.150
     8.792   150.998     0.150
     1.301    22.996     0.150
     1.301    40.207     0.150
     1.301    22.506     0.150
     1.301    38.996     0.150
     1.876    31.666     0.150
     1.876    54.986     0.150
     9.088   137.771     0.150
    13.056   192.164     0.150
     0.910    16.336     0.150
     0.910    28.039     0.150
     0.910    40.141     0.150
     0.910    16.828     0.150
     0.910    29.859     0.150
     1.399    24.367     0.150
     1.678    60.250     0.150
     3.695    63.984     0.150
     3.695    77.055     0.150
     3.788    62.484     0.150
     7.637   109.453     0.150
     8.987   121.266     0.150
     8.987   263.555     0.150
    10.181   343.883     0.150
    31.909   384.922     0.150
     0.974    17.000     0.150
     0.974    30.266     0.150
     0.974    18.375     0.150
     0.974    30.156     0.150
     1.406    54.648     0.150
     1.436    25.211     0.150
     1.669    64.086     0.150
     1.669    28.367     0.150
     0.995    15.840     0.150
     0.995    26.031     0.150
     0.995    17.738     0.150
     0.995    30.859     0.150
     1.391    56.539     0.150
     1.521    49.719     0.150
     1.686    72.051     0.150
     3.274    53.441     0.150
     1.027    16.562     0.150
     1.027    28.141     0.150
     1.027    19.230     0.150
     1.027    32.973     0.150
     1.155    38.512     0.150
     1.490    25.793     0.150
     1.356    54.641     0.150
     1.356    57.973     0.150
     1.722    29.023     0.150
     1.508    29.004     0.150
     1.508    50.223     0.150
     2.917    89.754     0.150
     0.630    23.133     0.150
     0.630    23.213     0.150
     1.111    39.652     0.150
     1.111    39.842     0.150
     1.111    19.941     0.150
     1.111    19.941     0.150
     1.111    35.152     0.150
     1.284    38.482     0.150
     1.284    50.322     0.150
     1.384    22.162     0.150
     1.384    40.102     0.150
     1.384    21.973     0.150
     1.384    21.973     0.150
     1.384    36.162     0.150
     1.294    50.883     0.150
     1.294    52.703     0.150
     1.522    24.732     0.150
     1.522    24.613     0.150
     1.802    29.262     0.150
     1.802    51.133     0.150
     1.934    31.021     0.150
     1.934    53.303     0.150
     1.915    77.203     0.150
     2.668    38.432     0.150
     2.668    38.432     0.150
     2.626    74.082     0.150
     3.137    50.902     0.150
     3.016    51.982     0.150
     3.016    50.812     0.150
     3.016    50.812     0.150
     3.016    74.293     0.150
     3.299    53.902     0.150
     3.382    49.143     0.150
     3.382    49.143     0.150
     3.382    87.682     0.150
     3.379    51.863     0.150
     3.379    51.803     0.150
     3.379    92.223     0.150
     3.469    49.623     0.150
     3.469    91.912     0.150
     3.623    56.582     0.150
     3.623   104.152     0.150
     4.246    64.271     0.150
     4.246    68.602     0.150
     4.997    76.303     0.150
     4.983    75.043     0.150
     4.983   134.402     0.150
     5.701    83.643     0.150
     5.701   152.162     0.150
     7.840   115.303     0.150
     7.831   211.553     0.150
     7.831   112.441     0.150
     7.831   211.553     0.150
     8.776   227.002     0.150
     8.916   127.842     0.150
     8.916   233.162     0.150
    10.744   160.502     0.150
    10.742   158.803     0.150
    12.344   184.803     0.150
    12.966   190.803     0.150
    13.498   198.203     0.150
    13.735   203.803     0.150
    76.383   212.021     0.150
    30.648   228.033     0.150
    16.472   236.402     0.150
    86.279   239.252     0.150
    19.827   266.713     0.150
     8.305   283.172     0.150
    21.715   289.223     0.150
    24.061   323.102     0.150
    32.457   559.553     0.150
    40.020   460.102     0.150
    83.915   482.262     0.150
    65.504   498.652     0.150
    65.504   496.713     0.150
    80.985   736.533     0.150
    84.858   756.623     0.150
    84.804   755.262     0.150
    86.423   967.402     0.150
    97.941   811.902     0.150
     0.639    23.037     0.150
     0.923    37.408     0.150
     1.162    39.967     0.150
     1.235    48.168     0.150
     1.288    51.729     0.150
     1.288    57.678     0.150
     1.341    22.297     0.150
     1.341    39.838     0.150
     1.341    22.758     0.150
     1.341    22.238     0.150
     1.341    38.387     0.150
     1.854    75.217     0.150
     1.955    75.768     0.150
     2.619    44.188     0.150
     2.619    75.178     0.150
     2.619    75.348     0.150
     3.065    49.479     0.150
     3.340    51.207     0.150
     4.714    68.547     0.150
     8.326   127.248     0.150
    65.251   124.877     0.150
     9.109   140.648     0.150
    92.846   146.527     0.150
    10.692   160.248     0.150
    10.985   156.357     0.150
    12.381   184.447     0.150
    13.079   197.648     0.150
    13.686   199.096     0.150
    14.403   202.078     0.150
     8.260   282.158     0.150
    26.492   336.979     0.150
    26.905   340.518     0.150
    37.660   433.447     0.150
   110.383   447.467     0.150
    40.378   455.658     0.150
    40.408   455.887     0.150
    42.643   475.047     0.150
    83.872   481.617     0.150
    65.459   498.768     0.150
    65.459   496.547     0.150
    70.610   677.248     0.150
    60.068   705.957     0.150
    77.867   718.473     0.150
    81.968   745.547     0.150
    82.798   746.988     0.150
    82.894   744.748     0.150
    84.338   754.768     0.150
    90.478   784.008     0.150
     0.926    31.234     0.150
     1.093    40.383     0.150
     1.382    21.445     0.150
     1.382    39.883     0.150
     1.382    22.184     0.150
     1.382    32.855     0.150
     1.327    53.133     0.150
     1.327    53.473     0.150
     3.413    83.586     0.150
     4.250   122.559     0.150
     1.322    23.250     0.150
     1.322    40.492     0.150
     1.322    24.320     0.150
     1.322    41.832     0.150
     1.298    52.863     0.150
     1.145    19.633     0.150
     1.339    23.023     0.150
     1.339    22.883     0.150
     1.339    40.266     0.150
     3.057    93.586     0.150
     0.612    22.211     0.150
     0.945    31.258     0.150
     1.315    52.160     0.150
     1.315    56.398     0.150
     1.331    23.180     0.150
     1.331    40.758     0.150
     1.331    23.230     0.150
     1.331    40.328     0.150
     1.768    29.398     0.150
     1.768    51.250     0.150
     0.930    37.683     0.150
     1.169    46.663     0.150
     1.226    22.673     0.150
     1.262    49.513     0.150
     1.262    53.083     0.150
     1.302    22.383     0.150
     1.302    39.413     0.150
     1.302    22.703     0.150
     1.302    39.803     0.150
     3.303   110.543     0.150
     3.369   112.013     0.150
     0.673    24.020     0.150
     0.673    34.041     0.150
     1.290    22.920     0.150
     1.290    40.180     0.150
     1.290    22.621     0.150
     1.290    39.301     0.150
     1.267    52.600     0.150
     1.267    56.570     0.150
     1.236    44.131     0.150
     1.892    62.910     0.150
     2.003    77.920     0.150
     4.136    85.330     0.150
     9.058   139.395     0.150
    13.006   191.645     0.150
     0.658    12.625     0.150
     0.658    22.195     0.150
     0.658    12.734     0.150
     0.658    22.365     0.150
     0.919    51.865     0.150
     0.919    53.625     0.150
     1.154    47.895     0.150
     1.154    38.506     0.150
     1.475    61.734     0.150
     1.516    54.145     0.150
     1.615    59.916     0.150
     1.615    63.445     0.150
     1.858    36.055     0.150
     1.858    65.295     0.150
     2.727    37.775     0.150
     2.656    75.775     0.150
     4.321   147.375     0.150
     4.321   151.775     0.150
     0.989    17.973     0.150
     0.989    30.523     0.150
     0.989    42.094     0.150
     0.989    18.373     0.150
     0.989    27.992     0.150
     1.182    48.412     0.150
     1.452    25.623     0.150
     1.391    58.273     0.150
     1.530    55.152     0.150
     3.270    54.492     0.150
     4.019   141.623     0.150
     0.717    14.254     0.150
     0.717    24.453     0.150
     0.717    13.703     0.150
     0.717    24.172     0.150
     1.448    25.711     0.150
     2.002    30.781     0.150
     2.718    47.324     0.150
     7.830   120.531     0.150
     8.520   133.125     0.150
     0.624    11.594     0.150
     0.624    19.873     0.150
     0.624    22.223     0.150
     0.624    11.523     0.150
     0.624    20.133     0.150
     0.624    11.084     0.150
     0.624    20.244     0.150
     1.048    18.863     0.150
     1.048    32.883     0.150
     1.048    18.844     0.150
     1.048    32.824     0.150
     1.593    27.562     0.150
     1.593    48.533     0.150
     1.667    71.533     0.150
     2.117    64.094     0.150
     2.173    34.494     0.150
     2.173    59.824     0.150
     2.849    44.873     0.150
     3.148    48.584     0.150
     3.148    86.584     0.150
     3.853   110.354     0.150
     3.853    61.232     0.150
     3.853   110.354     0.150
     4.282    74.973     0.150
     4.282   112.373     0.150
     4.702   131.174     0.150
     5.602    82.004     0.150
     5.602   146.773     0.150
     5.952   100.123     0.150
     9.484   138.553     0.150
    11.876   217.541     0.150
     0.242    11.587     0.150
     0.242    13.177     0.150
     1.041    19.327     0.150
     1.041    33.567     0.150
     1.041    37.597     0.150
     1.041    42.167     0.150
     1.041    19.347     0.150
     1.041    33.557     0.150
     1.342    24.467     0.150
     1.337    45.777     0.150
     1.378    49.967     0.150
     1.378    24.637     0.150
     1.481    57.217     0.150
     0.802    14.941     0.150
     0.802    25.281     0.150
     0.802    37.992     0.150
     0.802    15.832     0.150
     0.802    26.742     0.150
     1.283    41.660     0.150
     1.508    66.223     0.150
     1.508    68.711     0.150
     1.563    27.223     0.150
     5.259   145.672     0.150
     0.786    15.027     0.150
     0.786    26.158     0.150
     0.786    14.758     0.150
     0.786    26.238     0.150
     0.822    27.527     0.150
     1.545    51.748     0.150
     1.526    57.449     0.150
     1.526    66.129     0.150
     1.720    34.418     0.150
     1.720    60.098     0.150
     0.622    11.926     0.150
     0.622    20.562     0.150
     0.622    11.656     0.150
     0.622    20.562     0.150
     0.677    23.973     0.150
     0.798    26.723     0.150
     0.798    14.664     0.150
     0.969    31.203     0.150
     1.195    48.414     0.150
     1.195    48.684     0.150
     1.182    20.613     0.150
     2.157    34.715     0.150
    16.849   234.234     0.150
     0.498    19.439     0.150
     0.498    20.230     0.150
     0.633    11.900     0.150
     0.633    20.189     0.150
     0.633    21.070     0.150
     0.633    11.891     0.150
     0.633    20.209     0.150
     0.813    14.510     0.150
     0.945    15.699     0.150
     1.032    18.689     0.150
     1.032    32.570     0.150
     2.129    34.219     0.150
     0.625    14.512     0.150
     0.625    25.992     0.150
     0.619    19.734     0.150
     0.660    13.195     0.150
     0.660    21.605     0.150
     0.744    11.414     0.150
     1.084    19.355     0.150
     1.084    34.594     0.150
     1.630    30.203     0.150
     2.006    33.965     0.150
     2.006    87.344     0.150
     2.188    34.734     0.150
     2.188    64.953     0.150
     3.114    92.953     0.150
     0.526    16.215     0.150
     0.526    12.055     0.150
     0.658    10.785     0.150
     0.658    25.555     0.150
     0.656    13.227     0.150
     0.656    21.617     0.150
     0.656    22.355     0.150
     0.656    12.516     0.150
     0.656    21.496     0.150
     0.771    12.656     0.150
     1.067    16.328     0.150
     1.224    26.008     0.150
     0.624    12.305     0.150
     0.624    20.805     0.150
     0.624    21.258     0.150
     0.624    11.883     0.150
     0.624    19.516     0.150
     0.676    24.477     0.150
     0.797    27.352     0.150
     0.797    28.555     0.150
     1.036    18.547     0.150
     1.036    33.695     0.150
     1.036    18.547     0.150
     1.036    33.695     0.150
     1.116    19.688     0.150
     1.116    36.133     0.150
     1.358    40.117     0.150
     1.791    27.266     0.150
     1.842    30.555     0.150
     2.141    33.672     0.150
     2.141    60.562     0.150
     2.158    33.797     0.150
     2.670    74.805     0.150
     2.670    41.922     0.150
     2.670    74.805     0.150
     2.709   834.984     0.150
     3.166    88.031     0.150
     3.886   102.508     0.150
     4.311    63.812     0.150
     4.311   113.477     0.150
     5.630    84.336     0.150
     7.041   102.844     0.150
     7.041   181.688     0.150
     7.547   105.273     0.150
     8.229   128.102     0.150
    66.641   128.836     0.150
     8.888   235.625     0.150
     9.247   133.703     0.150
    68.658   138.438     0.150
    92.030   151.453     0.150
    92.024   153.117     0.150
    11.305   159.922     0.150
    11.559   165.242     0.150
    11.795   169.641     0.150
    11.795   312.125     0.150
    11.863   167.586     0.150
    11.863   293.188     0.150
    13.608   192.461     0.150
     4.127   197.516     0.150
    85.918   197.953     0.150
   100.103   209.078     0.150
    83.501   204.977     0.150
    16.083   210.445     0.150
    14.986   209.656     0.150
    85.322   224.211     0.150
    16.202   229.164     0.150
    16.244   230.156     0.150
    21.273   284.703     0.150
    25.092   323.516     0.150
    36.561   421.008     0.150
    64.032   507.656     0.150
    64.032   505.117     0.150
    64.285   631.984     0.150
    65.039   643.781     0.150
    82.537   748.836     0.150
     5.340   765.375     0.150
    87.679  1090.453     0.150
     1.560   777.406     0.150
     0.573    29.586     0.150
     0.649    11.938     0.150
     0.649    20.469     0.150
     0.649    21.109     0.150
     0.649    30.875     0.150
     0.649    11.758     0.150
     0.649    20.594     0.150
     0.792    25.938     0.150
     1.053    44.203     0.150
     1.053    18.086     0.150
     1.053    32.844     0.150
     1.212    22.578     0.150
     1.606    58.945     0.150
     1.606    28.047     0.150
     1.776    25.500     0.150
     2.142    35.008     0.150
     5.164    75.258     0.150
     0.451    18.688     0.150
     0.669    12.398     0.150
     0.669    21.070     0.150
     0.669    21.930     0.150
     0.669    12.328     0.150
     0.669    21.047     0.150
     1.048    19.688     0.150
     1.048    33.695     0.150
     1.048    19.688     0.150
     1.048    33.695     0.150
     2.088    34.438     0.150
     2.548    43.750     0.150
     0.662    12.438     0.150
     0.662    21.281     0.150
     0.662    21.734     0.150
     0.662    12.336     0.150
     0.662    21.078     0.150
     0.813    15.242     0.150
     0.923    16.352     0.150
     1.050    19.812     0.150
     1.050    33.195     0.150
     1.609    27.953     0.150
     1.609    49.445     0.150
     2.106    35.781     0.150
     0.647    12.513     0.150
     0.647    20.864     0.150
     0.647    21.614     0.150
     0.647    12.094     0.150
     0.647    20.844     0.150
     0.951    16.413     0.150
     1.197    18.993     0.150
     2.134    33.793     0.150
     0.794    15.385     0.150
     0.794    26.785     0.150
     0.794    15.175     0.150
     0.794    26.905     0.150
     0.848    14.285     0.150
     0.848    25.896     0.150
     0.848    37.436     0.150
     0.848    44.825     0.150
     1.567    26.835     0.150
     0.514    18.628     0.150
     0.621    11.668     0.150
     0.621    19.938     0.150
     0.621    11.648     0.150
     0.621    20.228     0.150
     0.621    20.998     0.150
     0.621    11.668     0.150
     0.621    19.938     0.150
     0.690    12.968     0.150
     0.708    12.428     0.150
     0.708    22.268     0.150
     1.102    20.358     0.150
     1.102    34.798     0.150
     1.327    24.168     0.150
     1.550    25.428     0.150
     1.614    26.878     0.150
     1.614    45.498     0.150
     1.758    31.588     0.150
     2.275    37.628     0.150
     2.275    64.898     0.150
     2.335    38.418     0.150
     2.335    67.078     0.150
     3.083    88.188     0.150
     0.554    10.094     0.150
     0.554    17.742     0.150
     0.708    12.898     0.150
     0.708    22.469     0.150
     0.708    12.891     0.150
     0.708    22.461     0.150
     0.708    12.891     0.150
     0.708    22.461     0.150
     1.068    19.148     0.150
     1.068    33.484     0.150
     1.635    27.523     0.150
     1.635    48.695     0.150
     2.003    32.312     0.150
     2.003    56.914     0.150
     2.044    33.031     0.150
     2.053    33.305     0.150
     2.053    56.953     0.150
     0.526    10.574     0.150
     0.526    17.242     0.150
     0.526    18.594     0.150
     0.526    10.512     0.150
     0.526    17.055     0.150
     0.526    10.562     0.150
     0.526    17.395     0.150
     0.642    12.262     0.150
     0.780    14.594     0.150
     0.780    25.922     0.150
     1.013    18.562     0.150
     1.520    26.414     0.150
     0.527     9.914     0.150
     0.527    17.066     0.150
     0.527    19.523     0.150
     0.527     9.914     0.150
     0.527    15.785     0.150
     0.527     9.914     0.150
     0.527    15.785     0.150
     0.630    29.766     0.150
     1.008    17.875     0.150
     1.008    30.535     0.150
     1.242    48.977     0.150
     1.306    31.137     0.150
     1.306    42.965     0.150
     1.520    25.746     0.150
     1.520    25.746     0.150
     2.214    35.285     0.150
     2.277    35.293     0.150
     2.465    44.324     0.150
     2.838    42.844     0.150
     5.550    81.785     0.150
     0.530    10.457     0.150
     0.530    17.488     0.150
     0.530    18.816     0.150
     0.530    10.547     0.150
     0.530    17.309     0.150
     0.530    10.547     0.150
     0.530    17.309     0.150
     0.584    19.707     0.150
     0.653    12.297     0.150
     1.019    18.527     0.150
     1.019    31.938     0.150
     1.019    18.527     0.150
     1.019    31.938     0.150
     1.335    40.047     0.150
     1.335    44.445     0.150
     1.478    48.516     0.150
     1.524    26.227     0.150
     1.524    26.227     0.150
     2.240    35.816     0.150
     2.240    62.875     0.150
     2.304    37.957     0.150
     2.304    64.027     0.150
     3.044    46.066     0.150
     3.169    57.578     0.150
     0.518    10.078     0.150
     0.518    16.930     0.150
     0.518    18.938     0.150
     0.518    10.098     0.150
     0.518    16.820     0.150
     0.518    10.078     0.150
     0.518    16.848     0.150
     0.656    12.020     0.150
     1.013    33.590     0.150
     1.206    23.578     0.150
     1.350    30.387     0.150
     1.350    52.879     0.150
     1.412    27.117     0.150
     1.554    45.520     0.150
     1.513    25.918     0.150
     2.420    50.078     0.150
     2.420    82.020     0.150
     7.537   107.543     0.150
     7.537   134.844     0.150
     9.408   129.797     0.150
     9.473   133.723     0.150
    14.385   198.867     0.150
    31.225   376.148     0.150
    39.099   443.898     0.150
     0.633    11.520     0.150
     0.633    19.508     0.150
     0.633    20.520     0.150
     0.633    21.078     0.150
     0.633    11.586     0.150
     0.633    19.418     0.150
     0.633    11.586     0.150
     0.633    19.418     0.150
     0.682    12.199     0.150
     0.682    19.918     0.150
     0.696    13.246     0.150
     0.696    22.949     0.150
     1.099    20.129     0.150
     1.099    32.957     0.150
     1.495    26.727     0.150
     1.622    24.699     0.150
     1.622    25.039     0.150
     1.622    25.039     0.150
     1.622    44.836     0.150
     1.703    33.348     0.150
     2.236    35.969     0.150
     2.236    63.117     0.150
     2.294    44.898     0.150
     2.294    44.898     0.150
     2.294    65.227     0.150
     3.086    59.848     0.150
     3.086    96.109     0.150
    58.758    54.867     0.150
     3.818    57.270     0.150
     4.027    62.188     0.150
     0.573    11.113     0.150
     0.573    18.715     0.150
     0.573    11.084     0.150
     0.573    18.693     0.150
     0.573    11.084     0.150
     0.573    18.693     0.150
     0.604    11.863     0.150
     0.772    14.564     0.150
     0.772    24.623     0.150
     0.913    28.295     0.150
     1.026    18.674     0.150
     1.026    18.674     0.150
     1.026    32.584     0.150
     1.080    18.373     0.150
     1.095    33.953     0.150
     1.225    24.453     0.150
     1.225    24.453     0.150
     1.229    48.234     0.150
     1.229    51.773     0.150
     1.229    21.824     0.150
     1.581    47.244     0.150
     1.557    46.484     0.150
     1.557    26.795     0.150
     1.557    46.484     0.150
     2.164    35.824     0.150
     2.164    60.064     0.150
     2.224    36.074     0.150
     2.224    63.844     0.150
     2.260    37.434     0.150
     2.342    39.334     0.150
     2.825    49.604     0.150
    58.756    55.773     0.150
     3.997    62.203     0.150
     4.746    73.604     0.150
     5.574    84.273     0.150
     6.019   101.514     0.150
     7.714   118.309     0.150
    79.881   120.584     0.150
    68.553   138.504     0.150
     0.585    11.047     0.150
     0.585    18.516     0.150
     0.585    10.961     0.150
     0.585    18.484     0.150
     0.585    10.961     0.150
     0.585    18.484     0.150
     0.620    21.719     0.150
     0.769    14.398     0.150
     1.033    18.531     0.150
     1.033    18.531     0.150
     1.033    31.508     0.150
     1.209    21.617     0.150
     1.209    27.148     0.150
     1.209    38.219     0.150
     1.209    43.117     0.150
     1.229    21.602     0.150
     1.413    46.867     0.150
     1.567    26.688     0.150
     1.567    59.258     0.150
     1.567    26.672     0.150
     1.567    45.609     0.150
     2.156    35.445     0.150
     2.156    60.766     0.150
     2.215    40.297     0.150
     2.214    32.898     0.150
     2.214    61.391     0.150
     2.575    46.031     0.150
     3.154    48.328     0.150
     3.154    86.891     0.150
     0.603    11.641     0.150
     0.603    19.969     0.150
     0.917    17.441     0.150
     0.917    30.211     0.150
     0.917    32.891     0.150
     0.917    17.363     0.150
     0.917    29.742     0.150
     1.228    21.820     0.150
     1.192    39.723     0.150
     1.192    21.883     0.150
     2.913    48.570     0.150
    89.662   785.113     0.150
    89.662   785.113     0.150
    89.662   785.113     0.150
    89.662   800.102     0.150
    89.662   950.512     0.150
    89.662  1055.973     0.150
    89.662  1356.320     0.150
    89.662  1642.621     0.150
    89.662  1844.352     0.150
     0.600    11.922     0.150
     0.600    18.273     0.150
     0.582    11.324     0.150
     0.582    18.984     0.150
     0.582    20.062     0.150
     0.582    11.324     0.150
     0.582    18.984     0.150
     0.582    11.324     0.150
     0.582    18.984     0.150
     0.772    14.645     0.150
     0.772    24.973     0.150
     1.059    18.562     0.150
     1.059    32.602     0.150
     1.080    22.492     0.150
     1.080    37.434     0.150
     1.080    81.824     0.150
     1.080    37.203     0.150
     1.030    43.223     0.150
     1.030    18.844     0.150
     1.030    18.844     0.150
     1.030    31.402     0.150
     1.126    20.492     0.150
     1.126    36.285     0.150
     1.210    24.672     0.150
     1.210    24.672     0.150
     1.210    25.535     0.150
     1.210    42.992     0.150
     1.226    43.922     0.150
     1.226    48.555     0.150
     1.226    21.832     0.150
     1.291    55.793     0.150
     1.411    25.043     0.150
     1.563    26.895     0.150
     1.563    46.305     0.150
     2.155    35.195     0.150
     2.155    62.852     0.150
     2.214    35.914     0.150
     2.214    63.492     0.150
     2.573    45.902     0.150
    58.739    52.625     0.150
     4.493    71.602     0.150
     5.580    85.824     0.150
     5.580   154.672     0.150
     6.955    98.414     0.150
     6.955   194.203     0.150
     7.455   246.754     0.150
     8.814   271.375     0.150
    10.141   287.332     0.150
     0.899    17.272     0.150
     0.899    29.393     0.150
     0.899    31.263     0.150
     0.899    17.372     0.150
     0.899    29.332     0.150
     1.266    21.572     0.150
     1.365    24.183     0.150
     1.481    28.922     0.150
     1.481    49.492     0.150
     2.290    76.553     0.150
     0.554    10.984     0.150
     0.554    18.754     0.150
     0.554    19.725     0.150
     0.554    10.975     0.150
     0.554    18.564     0.150
     0.603    19.334     0.150
     0.618    21.463     0.150
     0.618    21.684     0.150
     1.015    18.574     0.150
     1.242    26.053     0.150
     0.559    10.824     0.150
     0.559    18.535     0.150
     0.559    19.605     0.150
     0.559    19.715     0.150
     0.559    10.914     0.150
     0.559    18.484     0.150
     0.559    10.914     0.150
     0.559    18.484     0.150
     0.618    18.066     0.150
     0.604    31.066     0.150
     0.770    24.934     0.150
     1.024    19.484     0.150
     1.024    31.676     0.150
     1.103    18.316     0.150
     1.103    32.344     0.150
     1.547    30.785     0.150
     1.547    30.785     0.150
     1.547    45.914     0.150
     1.846    36.754     0.150
     2.187    38.176     0.150
     2.187    62.746     0.150
     2.248    38.836     0.150
     2.248    62.395     0.150
     2.264    41.637     0.150
     2.290    43.297     0.150
     2.369    46.523     0.150
     2.456    43.484     0.150
     2.577    46.457     0.150
     2.631    45.477     0.150
     2.851    48.367     0.150
     3.161    59.934     0.150
     3.161    98.617     0.150
    58.790    59.234     0.150
     3.885    57.406     0.150
     4.324    64.023     0.150
     0.602    30.531     0.150
     0.582    10.832     0.150
     0.582    18.473     0.150
     0.582    19.523     0.150
     0.582    19.531     0.150
     0.582    10.832     0.150
     0.582    18.344     0.150
     0.582    10.832     0.150
     0.582    18.344     0.150
     0.758    15.121     0.150
     0.648    24.402     0.150
     0.618    18.152     0.150
     1.088    36.371     0.150
     1.039    18.441     0.150
     1.039    18.441     0.150
     1.039    31.133     0.150
     1.235    26.793     0.150
     1.235    42.883     0.150
     1.243    55.941     0.150
     1.568    26.691     0.150
     1.568    48.012     0.150
     2.178    34.504     0.150
     2.178    62.082     0.150
     2.237    35.391     0.150
     2.237    60.723     0.150
     2.271    35.121     0.150
     2.835    50.223     0.150
    58.758    52.473     0.150
     3.776    53.262     0.150
     3.776    74.961     0.150
     6.030   101.312     0.150
     0.567    10.914     0.150
     0.567    18.516     0.150
     0.567    19.656     0.150
     0.567    20.641     0.150
     0.567    10.852     0.150
     0.567    18.445     0.150
     0.567    10.852     0.150
     0.567    18.445     0.150
     0.623    11.445     0.150
     0.623    19.414     0.150
     0.762    14.047     0.150
     1.032    18.383     0.150
     1.032    18.383     0.150
     1.032    32.992     0.150
     1.556    58.945     0.150
     1.556    59.844     0.150
     1.556    26.484     0.150
     1.556    26.484     0.150
     1.556    46.961     0.150
     2.191    34.953     0.150
     2.191    60.445     0.150
     2.251    35.953     0.150
     2.251    62.016     0.150
     2.290    40.031     0.150
    58.784    54.305     0.150
     0.589    11.176     0.150
     0.589    19.203     0.150
     0.589    19.895     0.150
     0.589    20.125     0.150
     0.589    11.176     0.150
     0.589    19.164     0.150
     0.643    11.363     0.150
     0.643    21.723     0.150
     1.578    25.652     0.150
     0.683    25.022     0.150
     0.988    39.763     0.150
     0.988    46.463     0.150
     1.029    18.203     0.150
     1.029    32.383     0.150
     1.029    18.533     0.150
     1.029    32.453     0.150
     1.029    44.343     0.150
     1.029    18.203     0.150
     1.029    32.383     0.150
     1.167    45.103     0.150
     1.167    53.613     0.150
     1.454    29.393     0.150
     1.454    48.482     0.150
     1.479    24.973     0.150
     1.479    24.963     0.150
     1.479    43.863     0.150
     1.465    25.363     0.150
     1.465    45.593     0.150
     1.690    28.232     0.150
     1.690    70.812     0.150
     1.690    28.183     0.150
     1.690    49.502     0.150
     2.772    45.843     0.150
     3.030    46.633     0.150
     3.030    83.533     0.150
     3.114    51.002     0.150
     3.114    51.002     0.150
     3.114    86.663     0.150
     3.269    48.263     0.150
     3.783    59.252     0.150
     3.783   100.923     0.150
     3.873    67.340     0.150
    12.851   187.931     0.150
     0.627    11.262     0.150
     0.627    19.562     0.150
     0.627    11.445     0.150
     0.627    19.945     0.150
     0.627    20.305     0.150
     0.784    24.652     0.150
     0.784    14.172     0.150
     1.196    18.773     0.150
     1.368    40.344     0.150
     1.371    58.883     0.150
     2.037    37.863     0.150
     4.380    63.543     0.150
     4.358    61.273     0.150
     4.763    67.504     0.150
     0.368    14.799     0.150
     0.461    26.669     0.150
     0.648    11.699     0.150
     0.648    20.539     0.150
     0.648    11.709     0.150
     0.648    20.849     0.150
     0.648    31.569     0.150
     0.648    32.389     0.150
     0.928    26.969     0.150
     0.928    15.359     0.150
     0.821    14.559     0.150
     0.821    26.999     0.150
     0.821    28.239     0.150
     0.821    28.859     0.150
     0.951    19.479     0.150
     0.982    17.199     0.150
     1.311    36.429     0.150
     1.546    28.529     0.150
     1.989    34.439     0.150
     2.260    44.989     0.150
     2.326    40.939     0.150
     4.743    83.189     0.150
     4.818    68.299     0.150
     0.634    19.186     0.150
     0.634    21.906     0.150
     0.654    11.816     0.150
     0.654    20.736     0.150
     0.654    11.796     0.150
     0.654    20.826     0.150
     0.654    21.556     0.150
     0.828    26.686     0.150
     0.928    15.396     0.150
     0.946    20.516     0.150
     0.946    31.606     0.150
     0.986    40.946     0.150
     1.212    35.746     0.150
     1.985    32.146     0.150
     0.688    12.699     0.150
     0.688    22.129     0.150
     0.688    23.609     0.150
     0.565    10.840     0.150
     0.642    11.770     0.150
     0.725    13.348     0.150
     0.742    27.230     0.150
     0.742    29.777     0.150
     0.785    27.207     0.150
     0.785    14.910     0.150
     0.945    29.777     0.150
     1.088    19.547     0.150
     1.327    24.547     0.150
     1.639    28.738     0.150
     1.639    50.609     0.150
     2.443    40.539     0.150
     0.330    13.793     0.150
     0.677    13.020     0.150
     0.677    22.902     0.150
     0.677    12.891     0.150
     0.677    22.570     0.150
     0.677    23.281     0.150
     0.678    11.922     0.150
     0.678    20.949     0.150
     0.678    11.891     0.150
     0.678    20.672     0.150
     1.126    34.602     0.150
     1.150    33.293     0.150
     1.722    30.281     0.150
     1.982    35.109     0.150
     2.092    36.520     0.150
     2.367    42.812     0.150
     2.448    41.332     0.150
     2.475    44.480     0.150
     0.387    14.824     0.150
     0.658    12.457     0.150
     0.644    11.867     0.150
     0.644    20.996     0.150
     0.644    21.926     0.150
     0.644    11.887     0.150
     0.644    21.117     0.150
     0.840    29.023     0.150
     0.912    15.625     0.150
     0.912    28.906     0.150
     0.987    17.516     0.150
     1.099    19.273     0.150
     2.009    31.785     0.150
     2.669    44.367     0.150
     0.651    12.543     0.150
     0.651    11.941     0.150
     0.651    21.102     0.150
     0.651    11.852     0.150
     0.651    20.492     0.150
     0.651    21.441     0.150
     0.651    21.453     0.150
     0.834    14.742     0.150
     0.834    29.242     0.150
     0.884    15.824     0.150
     0.913    15.531     0.150
     1.075    17.941     0.150
     1.075    36.062     0.150
     1.174    41.852     0.150
     1.100    19.203     0.150
     2.004    33.055     0.150
     2.004    57.031     0.150
     0.388     9.148     0.150
     0.388    15.738     0.150
     0.388    16.020     0.150
     0.664    12.699     0.150
     0.664    21.711     0.150
     0.664    22.379     0.150
     0.664    22.488     0.150
     0.846    29.840     0.150
     0.846    29.852     0.150
     0.891    31.270     0.150
     0.975    33.832     0.150
     1.012    18.281     0.150
     1.012    32.488     0.150
     1.095    18.801     0.150
     1.122    20.051     0.150
     1.443    41.852     0.150
     1.443    24.691     0.150
     2.018    32.309     0.150
     2.575    45.230     0.150
    95.791    46.082     0.150
    16.732   239.355     0.150
     0.678    12.926     0.150
     0.678    22.008     0.150
     0.678    12.996     0.150
     0.678    21.438     0.150
     0.678    22.746     0.150
     0.678    23.457     0.150
     0.690    13.617     0.150
     0.877    15.836     0.150
     0.877    29.035     0.150
     0.877    30.355     0.150
     0.850    16.617     0.150
     0.850    16.625     0.150
     0.850    29.777     0.150
     0.850    30.367     0.150
     0.850    30.406     0.150
     0.914    31.578     0.150
     1.042    18.547     0.150
     1.042    32.746     0.150
     1.160    20.328     0.150
     1.291    37.438     0.150
     2.052    32.645     0.150
     4.761    69.816     0.150
     0.354     8.719     0.150
     0.354    15.168     0.150
     0.668    12.129     0.150
     0.668    21.188     0.150
     0.668    12.180     0.150
     0.668    20.727     0.150
     0.668    21.738     0.150
     0.924    15.879     0.150
     0.997    17.789     0.150
     1.095    19.547     0.150
     1.216    21.348     0.150
     1.416    49.930     0.150
     0.665    11.984     0.150
     0.665    21.266     0.150
     0.665    11.926     0.150
     0.665    20.938     0.150
     0.902    15.617     0.150
     1.113    19.316     0.150
     1.238    36.285     0.150
     1.562    49.285     0.150
     4.794    73.715     0.150
     0.722    14.863     0.150
     0.722    14.824     0.150
     0.581    12.004     0.150
     0.581    19.652     0.150
     0.581    21.004     0.150
     0.581    11.980     0.150
     0.581    19.691     0.150
     1.035    28.133     0.150
     1.071    19.832     0.150
     1.071    38.664     0.150
     1.519    53.801     0.150
     2.381    41.453     0.150
     2.539    43.211     0.150
     2.826    47.801     0.150
     3.713    60.141     0.150
     4.115    64.281     0.150
     4.084    68.281     0.150
     4.479    72.980     0.150
     5.119    83.762     0.150
     5.284    88.254     0.150
     5.414    86.844     0.150
     5.853    93.312     0.150
     6.140   102.062     0.150
     0.664    12.904     0.150
     0.664    20.764     0.150
     0.664    33.113     0.150
     0.664    12.393     0.150
     0.664    22.914     0.150
     0.953    44.953     0.150
     0.953    54.654     0.150
     1.050    42.463     0.150
     1.167    48.414     0.150
     1.167    20.854     0.150
     1.514    57.244     0.150
     1.514    58.094     0.150
     1.300    83.004     0.150
     1.300    95.053     0.150
     1.598    30.453     0.150
     1.598    75.203     0.150
     1.538    62.324     0.150
     1.564    84.793     0.150
     1.564    97.883     0.150
     1.871    33.633     0.150
     2.855    47.443     0.150
     3.091    51.703     0.150
     3.453    58.998     0.150
     4.016    63.283     0.150
     8.381   130.924     0.150
     8.381   166.307     0.150
     8.381   232.652     0.150
    10.003   151.777     0.150
    16.955   152.834     0.150
    31.746   390.504     0.150
    39.635   459.453     0.150
    82.065   747.482     0.150
    82.624   749.029     0.150
     0.589    23.702     0.150
     0.637    11.812     0.150
     0.637    20.072     0.150
     0.637    20.942     0.150
     0.637    11.782     0.150
     0.637    20.003     0.150
     0.864    27.532     0.150
     1.032    24.192     0.150
     1.178    25.843     0.150
     1.178    40.292     0.150
     1.250    22.673     0.150
     1.286    23.992     0.150
     2.223    33.103     0.150
     2.319    34.253     0.150
     0.644    11.398     0.150
     0.644    19.758     0.150
     0.578    13.248     0.150
     1.416    46.598     0.150
     1.416    47.049     0.150
     2.746    41.908     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.551    10.480     0.150
     0.551    17.150     0.150
     1.009    18.590     0.150
     1.009    32.110     0.150
     1.379    23.900     0.150
     1.596    27.580     0.150
     1.801    29.700     0.150
     1.801    60.070     0.150
     1.877    34.500     0.150
     1.877    58.230     0.150
     1.962    32.340     0.150
     1.962    60.680     0.150
     1.994    36.660     0.150
     1.994    61.850     0.150
     2.087    34.630     0.150
     2.087    64.520     0.150
     2.255    71.705     0.150
     2.207    37.403     0.150
     2.207    65.659     0.150
     2.238    37.659     0.150
     2.367    39.469     0.150
     2.367    76.300     0.150
     2.531    82.496     0.150
     2.679    41.998     0.150
     2.679    74.147     0.150
     2.711    44.497     0.150
     2.711    86.705     0.150
     3.131    49.954     0.150
     3.131    98.539     0.150
     3.231    52.092     0.150
     3.231   102.503     0.150
     3.499    55.983     0.150
     3.499   111.073     0.150
     3.873    60.684     0.150
     3.873   120.837     0.150
     0.614    11.500     0.150
     0.614    19.828     0.150
     0.901    15.773     0.150
     0.901    28.859     0.150
     0.901    29.859     0.150
     1.077    19.492     0.150
     1.077    34.461     0.150
     1.032    19.242     0.150
     1.032    33.781     0.150
     1.045    19.734     0.150
     1.368    24.586     0.150
     1.368    43.117     0.150
     1.333    23.914     0.150
     1.581    26.992     0.150
     1.581    46.805     0.150
     1.879    30.055     0.150
     2.140    35.383     0.150
     2.179    36.039     0.150
     2.179    70.273     0.150
     2.228    36.336     0.150
     2.235    35.117     0.150
     2.325    38.117     0.150
     2.325    74.352     0.150
     2.327    37.445     0.150
     2.327    66.117     0.150
     2.498    40.328     0.150
     2.658    42.961     0.150
     2.715    42.266     0.150
     2.715    43.023     0.150
     2.841    44.828     0.150
     2.954    46.859     0.150
     2.954    92.859     0.150
     3.012    47.383     0.150
     3.092    49.062     0.150
     3.180    49.836     0.150
     3.180    99.461     0.150
     3.228    50.484     0.150
     3.228   100.695     0.150
     3.246    50.156     0.150
     3.366   105.453     0.150
     3.442    53.383     0.150
     3.442   107.430     0.150
     3.438    52.945     0.150
     3.587    55.445     0.150
     3.681    56.484     0.150
     3.657    56.828     0.150
     3.712    57.172     0.150
     3.700    56.297     0.150
     3.869    59.273     0.150
     4.299    65.562     0.150
     4.445    67.766     0.150
     0.643    12.570     0.150
     0.643    20.969     0.150
     1.073    19.680     0.150
     1.073    32.891     0.150
     1.117    35.668     0.150
     1.482    47.590     0.150
     1.482    47.430     0.150
     1.368    24.805     0.150
     1.368    42.578     0.150
     1.398    25.395     0.150
     1.398    42.770     0.150
     1.666    28.711     0.150
     1.666    49.793     0.150
     1.974    35.832     0.150
     1.974    37.320     0.150
     1.953    31.762     0.150
     1.953    54.871     0.150
     2.060    35.832     0.150
     2.092    37.531     0.150
     2.309    37.508     0.150
     2.363    37.910     0.150
     2.161    36.449     0.150
     2.161    62.930     0.150
     2.232    37.125     0.150
     2.232    63.699     0.150
     2.310    37.922     0.150
     2.413    39.434     0.150
     2.413    68.102     0.150
     2.399    39.336     0.150
     2.399    68.543     0.150
     2.472    40.359     0.150
     2.486    40.242     0.150
     2.486    70.922     0.150
     2.783    77.328     0.150
     2.830    48.441     0.150
     2.718    43.871     0.150
     2.718    76.816     0.150
     2.800    44.801     0.150
     2.800    78.453     0.150
     2.926    46.184     0.150
     2.857    79.648     0.150
     2.990    47.582     0.150
     3.004    47.652     0.150
     3.004    84.438     0.150
     3.081    86.852     0.150
     3.113    48.789     0.150
     3.113    99.629     0.150
     3.168    50.594     0.150
     3.243    51.965     0.150
     3.227    50.707     0.150
     3.227    89.117     0.150
     3.328    91.711     0.150
     3.402    53.320     0.150
     3.524    95.520     0.150
     3.497    55.246     0.150
     3.497    97.059     0.150
     3.664    57.473     0.150
     3.664   100.031     0.150
     3.663    57.102     0.150
     3.683    57.234     0.150
     3.683   101.004     0.150
     3.819    59.883     0.150
     3.819   104.680     0.150
     3.866    59.711     0.150
     3.866   104.645     0.150
     3.896    61.535     0.150
     3.966   108.266     0.150
     4.097    64.875     0.150
     4.209   113.254     0.150
     4.299    67.027     0.150
     4.384    67.211     0.150
     4.291    65.902     0.150
     4.298    68.035     0.150
     4.318    67.996     0.150
     4.331    65.980     0.150
     4.407    69.012     0.150
     4.441    67.402     0.150
     4.642    71.820     0.150
     4.642   124.789     0.150
     4.712    73.961     0.150
     4.712   127.434     0.150
     4.710    73.445     0.150
     4.710   128.102     0.150
     4.743   128.941     0.150
     4.779    73.371     0.150
     4.779   128.676     0.150
     4.969    76.996     0.150
     4.982    76.410     0.150
     5.050    78.324     0.150
     5.246    81.344     0.150
     5.246   140.871     0.150
     5.296    81.344     0.150
     5.506    84.270     0.150
     5.574    85.215     0.150
     5.604    86.246     0.150
     5.785    89.035     0.150
     5.835    89.340     0.150
     5.993    91.984     0.150
     6.135    93.184     0.150
     6.169    93.723     0.150
     6.114    93.020     0.150
     6.181    94.602     0.150
     6.251    96.254     0.150
     6.650   101.504     0.150
     6.819   103.988     0.150
     6.844   103.012     0.150
     6.972   104.922     0.150
     6.928   105.176     0.150
     7.491   112.328     0.150
     7.558   113.844     0.150
     7.815   118.418     0.150
     0.655    12.613     0.150
     0.655    21.113     0.150
     1.084    19.973     0.150
     1.084    33.285     0.150
     1.117    21.137     0.150
     1.117    35.793     0.150
     1.493    47.941     0.150
     1.356    24.879     0.150
     1.356    42.609     0.150
     1.392    25.418     0.150
     1.392    42.707     0.150
     1.668    28.770     0.150
     1.668    50.270     0.150
     1.986    36.375     0.150
     1.986    37.812     0.150
     1.986    60.633     0.150
     1.986    63.062     0.150
     1.961    32.637     0.150
     1.961    55.816     0.150
     2.103    37.914     0.150
     2.150    36.461     0.150
     2.150    62.273     0.150
     2.224    37.355     0.150
     2.309    38.355     0.150
     2.416    39.574     0.150
     2.416    68.215     0.150
     2.395    39.770     0.150
     2.395    68.520     0.150
     2.460    40.332     0.150
     2.473    40.273     0.150
     2.575    42.168     0.150
     2.575    73.336     0.150
     2.712    44.125     0.150
     2.802    45.004     0.150
     2.978    47.309     0.150
     2.978    82.238     0.150
     2.996    48.090     0.150
     2.996    83.301     0.150
     3.216    50.508     0.150
     3.216    89.309     0.150
     3.237    51.602     0.150
     3.327    91.777     0.150
     3.392    53.453     0.150
     3.392    93.816     0.150
     3.489    96.523     0.150
     3.661    57.508     0.150
     3.661    99.828     0.150
     3.651    57.031     0.150
     3.651    99.367     0.150
     3.671    57.129     0.150
     3.671    99.867     0.150
     3.810    59.762     0.150
     3.810   104.688     0.150
     3.854    59.496     0.150
     3.854   104.809     0.150
     3.892    61.059     0.150
     3.892   105.473     0.150
     3.954    61.723     0.150
     3.954   107.359     0.150
     4.091    64.430     0.150
     4.211   112.848     0.150
     4.110    64.641     0.150
     4.298   115.113     0.150
     4.279    65.754     0.150
     4.294    67.488     0.150
     4.319   115.496     0.150
     4.311    67.664     0.150
     4.405    68.730     0.150
     4.429    67.570     0.150
     4.630   124.270     0.150
     4.706    73.910     0.150
     4.706   126.902     0.150
     4.701    73.465     0.150
     4.735    73.578     0.150
     4.735   127.848     0.150
     4.768    73.137     0.150
     4.966    76.570     0.150
     4.980    76.641     0.150
     4.926    75.777     0.150
     4.926   131.516     0.150
     5.046    78.598     0.150
     5.241    81.570     0.150
     5.286    81.504     0.150
     5.373    83.316     0.150
     5.571    85.453     0.150
     5.595    85.867     0.150
     5.692    87.602     0.150
     5.780    89.227     0.150
     5.835    89.551     0.150
     5.987    92.109     0.150
     6.133    95.086     0.150
     6.104    93.109     0.150
     6.172    94.676     0.150
     6.245    96.199     0.150
     6.644   101.512     0.150
     6.833   102.965     0.150
     0.655    12.730     0.150
     1.094    20.000     0.150
     1.094    33.990     0.150
     1.094    35.260     0.150
     1.095    20.873     0.150
     1.095    36.861     0.150
     1.486    48.191     0.150
     1.370    25.338     0.150
     1.370    42.617     0.150
     1.646    28.859     0.150
     1.646    50.406     0.150
     1.347    24.787     0.150
     1.347    42.633     0.150
     1.984    64.840     0.150
     2.101    65.131     0.150
     2.286    38.375     0.150
     2.204    37.234     0.150
     2.372    39.561     0.150
     2.372    68.643     0.150
     2.780    44.783     0.150
     2.449    40.463     0.150
     2.779    78.748     0.150
     2.467    40.270     0.150
     2.557    42.418     0.150
     2.690    44.113     0.150
     2.976    47.764     0.150
     3.141    50.709     0.150
     2.975    47.895     0.150
     3.215    52.260     0.150
     3.504    96.193     0.150
     3.207    51.066     0.150
     3.375    53.766     0.150
     3.468    55.578     0.150
     3.657    57.080     0.150
     3.657   101.184     0.150
     3.647    57.014     0.150
     3.869    61.402     0.150
     3.791    59.713     0.150
     3.791   104.705     0.150
     3.670    57.455     0.150
     3.670   101.512     0.150
     3.846    60.098     0.150
     3.846   105.129     0.150
     3.944    61.764     0.150
     4.093    64.209     0.150
     4.271    67.652     0.150
     4.381    69.266     0.150
     4.290    67.562     0.150
     4.278    66.258     0.150
     4.684    73.750     0.150
     4.682    73.037     0.150
     4.715    73.494     0.150
     4.753    73.908     0.150
     4.957    76.875     0.150
     4.943    76.838     0.150
     5.023    78.377     0.150
     5.269    81.730     0.150
     5.352    83.273     0.150
     5.548    85.824     0.150
     5.479    84.418     0.150
     5.577    85.979     0.150
     5.812    89.684     0.150
     5.757    89.264     0.150
     6.087    92.959     0.150
     6.153    94.680     0.150
     6.223    96.473     0.150
     0.542    10.047     0.150
     0.542    16.766     0.150
     1.046    19.039     0.150
     1.314    22.109     0.150
     1.567    26.273     0.150
     1.699    27.594     0.150
     1.839    30.711     0.150
     1.951    32.164     0.150
     2.011    32.891     0.150
     2.615    45.750     0.150
     2.615    50.570     0.150
     2.615    82.047     0.150
     7.039   104.273     0.150
     7.039   136.539     0.150
     7.039   225.625     0.150
     7.428   109.023     0.150
     7.428   237.414     0.150
     8.139   119.055     0.150
     8.139   256.469     0.150
     9.127   134.750     0.150
     9.127   288.516     0.150
     9.573   140.688     0.150
     9.573   303.914     0.150
    11.783   171.867     0.150
    16.747   238.867     0.150
    38.744   447.516     0.150
     0.570    10.516     0.150
     0.570    18.312     0.150
     0.570    18.469     0.150
     1.067    20.320     0.150
     1.067    34.000     0.150
     1.117    20.266     0.150
     1.117    37.430     0.150
     1.352    23.312     0.150
     1.399    24.867     0.150
     1.399    25.047     0.150
     1.399    42.609     0.150
     1.280    23.500     0.150
     1.280    39.320     0.150
     1.600    26.766     0.150
     1.488    26.336     0.150
     1.488    45.570     0.150
     1.874    30.570     0.150
     2.049    33.742     0.150
     2.141    35.375     0.150
     2.143    35.852     0.150
     2.143    63.039     0.150
     2.205    35.211     0.150
     2.143    35.680     0.150
     2.230    36.672     0.150
     2.230    63.656     0.150
     2.625    41.922     0.150
     2.625    72.945     0.150
     2.609    42.289     0.150
     2.651    44.141     0.150
     2.623    42.320     0.150
     2.743    44.055     0.150
     3.161    50.336     0.150
     3.343    52.281     0.150
     3.343    92.109     0.150
     3.516    69.539     0.150
     3.602    55.859     0.150
     3.942    69.602     0.150
     3.942   122.180     0.150
     3.750    58.758     0.150
     3.750   103.414     0.150
     3.836    57.906     0.150
     4.035    77.359     0.150
     4.035   127.367     0.150
     4.028    61.664     0.150
     4.380    67.312     0.150
     4.200    64.359     0.150
     4.200    64.531     0.150
     4.650    72.180     0.150
     4.930    75.922     0.150
     5.121    79.547     0.150
     5.246    79.930     0.150
     5.284   103.945     0.150
     5.363    80.141     0.150
     5.692    85.375     0.150
     5.692    85.859     0.150
     5.994    91.656     0.150
     6.220    94.219     0.150
     6.500    96.828     0.150
     6.799   101.852     0.150
     6.799   102.242     0.150
     6.860   101.102     0.150
     6.860   132.477     0.150
     7.420   110.992     0.150
     7.690   111.117     0.150
     8.136   121.688     0.150
     0.830    16.173     0.150
     0.830    26.963     0.150
     0.829    26.803     0.150
     0.895    18.893     0.150
     0.895    30.243     0.150
     0.947    30.183     0.150
     1.783    30.163     0.150
     1.783    51.933     0.150
     1.962    32.213     0.150
     1.962    60.413     0.150
     2.477    38.638     0.150
     2.477    77.688     0.150
     2.477    39.232     0.150
     2.477    77.333     0.150
     3.436    93.043     0.150
     3.436   102.723     0.150
     3.484    52.973     0.150
     3.826    57.343     0.150
     3.826    68.143     0.150
     3.826   118.232     0.150
     3.871    58.463     0.150
     3.871    68.862     0.150
     3.871   113.793     0.150
     4.166    62.553     0.150
     4.166   108.603     0.150
     4.077    64.203     0.150
     4.077    80.833     0.150
     4.077   129.713     0.150
     4.496    67.933     0.150
     4.496    80.373     0.150
     4.496   134.963     0.150
     4.813    70.953     0.150
     4.813   154.293     0.150
     4.907    75.152     0.150
     4.907   157.463     0.150
     5.111    76.493     0.150
     5.111   156.482     0.150
     5.234    75.913     0.150
     5.234   166.282     0.150
     5.463   175.603     0.150
     5.936    87.812     0.150
     5.936   154.763     0.150
     5.977    89.263     0.150
     5.977   193.043     0.150
     6.045    88.923     0.150
     6.045   115.433     0.150
     6.770   132.782     0.150
     6.770   219.822     0.150
     6.970   104.133     0.150
     6.970   223.093     0.150
     7.414   111.062     0.150
     7.414   236.963     0.150
     7.610   113.013     0.150
     7.697   112.524     0.150
     7.697   243.753     0.150
     7.697   112.152     0.150
     7.697   152.032     0.150
     7.979   117.423     0.150
     7.979   252.112     0.150
     9.136   134.164     0.150
     9.136   291.487     0.150
     9.819   143.888     0.150
     9.819   252.637     0.150
     9.819   312.914     0.150
    11.960   175.241     0.150
    16.744   236.620     0.150
    23.092   307.173     0.150
    30.908   378.313     0.150
    38.672   446.812     0.150
     1.599    26.414     0.150
     1.599    26.264     0.150
     1.599    49.594     0.150
     1.601    26.324     0.150
     1.601    46.244     0.150
     1.744    26.713     0.150
     2.424    38.564     0.150
     2.534    39.314     0.150
     2.534    72.633     0.150
     2.653    41.725     0.150
     2.653    71.854     0.150
     2.694    41.123     0.150
     2.694    72.225     0.150
     2.942    45.703     0.150
     2.942    80.244     0.150
     3.077    47.475     0.150
     3.077    83.033     0.150
     3.194    48.814     0.150
     3.194    48.445     0.150
     3.210    48.135     0.150
     3.221    49.053     0.150
     3.221    86.873     0.150
     3.343    49.625     0.150
     3.505    53.174     0.150
     3.553    53.381     0.150
     3.662   103.023     0.150
     3.898    58.217     0.150
     4.185    62.014     0.150
     4.185    76.338     0.150
     4.185   132.289     0.150
     4.185    61.814     0.150
     4.376    65.160     0.150
     4.502    66.465     0.150
     4.841    70.658     0.150
     4.939    73.256     0.150
     5.176    76.186     0.150
     5.244    77.164     0.150
     5.248    76.902     0.150
     5.431    80.213     0.150
     5.457    80.293     0.150
     5.599    81.592     0.150
     5.830    86.914     0.150
     5.830    85.684     0.150
     5.909    86.893     0.150
     5.929    87.426     0.150
     6.082    90.592     0.150
     6.079    89.936     0.150
     6.079    91.043     0.150
     6.067    89.613     0.150
     6.185    90.598     0.150
     6.304    92.156     0.150
     6.412    95.664     0.150
     6.527    94.904     0.150
     6.532    96.633     0.150
     6.643    98.713     0.150
     6.746    97.814     0.150
     6.721   100.283     0.150
     6.721   217.533     0.150
     6.795   100.197     0.150
     6.930   100.504     0.150
     6.980   103.814     0.150
     7.189   107.213     0.150
     7.225   106.002     0.150
     7.244   107.713     0.150
     7.244   106.365     0.150
     7.236   107.074     0.150
     7.331   109.203     0.150
     7.302   106.740     0.150
     7.301   107.078     0.150
     7.444   109.984     0.150
     7.463   109.154     0.150
     7.566   112.135     0.150
     7.663   113.953     0.150
     7.679   111.725     0.150
     7.762   112.994     0.150
     7.770   113.049     0.150
     7.770   113.514     0.150
     7.894   116.713     0.150
     8.067   120.844     0.150
     8.245   122.004     0.150
     8.235   119.064     0.150
     8.235   120.213     0.150
     8.289   124.645     0.150
     8.289   216.895     0.150
     8.289   260.225     0.150
     8.512   124.670     0.150
     8.512   124.824     0.150
     8.634   127.242     0.150
     8.617   128.293     0.150
     8.676   127.873     0.150
     8.692   126.707     0.150
     8.692   127.434     0.150
     8.750   130.414     0.150
     9.173   137.434     0.150
     9.173   135.738     0.150
     9.160   130.664     0.150
     9.160   293.289     0.150
     9.180   137.414     0.150
     9.437   137.764     0.150
     9.464   139.744     0.150
     9.538   140.773     0.150
     9.616   140.814     0.150
     9.670   142.414     0.150
     9.688   144.053     0.150
     9.924   143.838     0.150
     9.924   144.463     0.150
     9.960   147.943     0.150
    10.180   150.404     0.150
    10.179   146.396     0.150
    10.228   150.613     0.150
    10.334   154.014     0.150
    10.334   150.512     0.150
    10.362   149.797     0.150
    10.363   149.207     0.150
    10.499   151.779     0.150
    10.499   154.123     0.150
    10.601   153.109     0.150
    10.613   152.791     0.150
    10.637   153.852     0.150
    10.637   155.674     0.150
    10.641   153.145     0.150
    10.758   159.213     0.150
    10.802   158.814     0.150
    10.813   155.408     0.150
    10.881   157.904     0.150
    10.881   159.934     0.150
    10.876   156.311     0.150
    10.892   156.752     0.150
    10.950   162.395     0.150
    10.991   160.213     0.150
    11.043   163.193     0.150
    11.074   160.934     0.150
    11.173   164.303     0.150
    11.126   159.764     0.150
    11.137   160.150     0.150
    11.145   160.525     0.150
    11.178   160.861     0.150
    11.210   160.799     0.150
    11.307   163.488     0.150
    11.307   164.674     0.150
    11.293   161.939     0.150
    11.334   162.781     0.150
    11.419   168.725     0.150
    11.392   163.438     0.150
    11.420   165.230     0.150
    11.416   164.041     0.150
    11.472   168.984     0.150
    11.495   166.023     0.150
    11.515   166.156     0.150
    11.616   167.318     0.150
    11.617   166.918     0.150
    11.622   167.400     0.150
    11.666   167.895     0.150
    11.666   169.074     0.150
    11.709   169.969     0.150
    11.750   169.033     0.150
    11.767   170.875     0.150
    11.781   169.609     0.150
    11.824   174.424     0.150
    11.811   169.734     0.150
    11.836   169.957     0.150
    11.874   174.543     0.150
    11.911   174.713     0.150
    11.927   175.934     0.150
    11.912   172.166     0.150
    11.927   172.834     0.150
    11.925   171.566     0.150
    11.956   172.129     0.150
    12.104   176.281     0.150
    12.070   173.438     0.150
    12.116   176.914     0.150
    12.116   176.395     0.150
    12.109   174.383     0.150
    12.141   174.824     0.150
    12.167   176.064     0.150
    12.183   175.914     0.150
    12.208   177.717     0.150
    12.267   180.664     0.150
    12.367   177.951     0.150
    12.367   177.828     0.150
    12.449   181.504     0.150
    12.491   181.145     0.150
    12.433   178.461     0.150
    12.446   178.277     0.150
    12.448   178.811     0.150
    12.453   179.246     0.150
    12.489   179.520     0.150
    12.512   179.932     0.150
    12.514   180.096     0.150
    12.520   180.182     0.150
    12.576   182.934     0.150
    12.594   181.953     0.150
    12.657   183.713     0.150
    12.618   182.248     0.150
    12.623   181.465     0.150
    12.632   181.719     0.150
    12.723   182.246     0.150
    12.723   182.574     0.150
    12.752   182.887     0.150
    12.765   183.543     0.150
    12.853   185.338     0.150
    12.919   187.975     0.150
    12.901   184.809     0.150
    12.964   188.453     0.150
    12.946   185.814     0.150
    13.018   189.514     0.150
    12.976   186.232     0.150
    13.051   188.729     0.150
    13.016   186.320     0.150
    13.037   186.719     0.150
    13.046   187.088     0.150
    13.077   191.184     0.150
    13.056   186.980     0.150
    13.110   189.273     0.150
    13.104   188.000     0.150
    13.106   187.646     0.150
    13.123   188.256     0.150
    13.156   190.174     0.150
    13.156   191.213     0.150
    13.158   188.881     0.150
    13.159   188.270     0.150
    13.275   193.764     0.150
    13.249   190.203     0.150
    13.265   189.498     0.150
    13.276   189.758     0.150
    13.304   190.484     0.150
    13.328   190.492     0.150
    13.384   194.854     0.150
    13.367   192.803     0.150
    13.367   194.164     0.150
    13.435   195.154     0.150
    13.396   193.953     0.150
    13.392   192.082     0.150
    13.391   192.074     0.150
    13.458   194.908     0.150
    13.431   192.129     0.150
    13.557   197.023     0.150
    13.542   195.113     0.150
    13.559   193.801     0.150
    13.610   196.029     0.150
    13.641   198.123     0.150
    13.641   198.773     0.150
    13.610   194.148     0.150
    13.618   194.475     0.150
    13.626   194.340     0.150
    13.682   197.705     0.150
    13.682   198.414     0.150
    13.657   195.545     0.150
    13.669   196.129     0.150
    13.699   199.453     0.150
    13.728   196.213     0.150
    13.760   196.551     0.150
    13.764   196.121     0.150
    13.770   197.078     0.150
    13.783   196.527     0.150
    13.811   199.654     0.150
    13.798   196.719     0.150
    13.819   197.246     0.150
    13.868   201.033     0.150
    13.895   202.113     0.150
    13.877   198.213     0.150
    13.911   198.434     0.150
    13.942   203.043     0.150
    13.921   198.545     0.150
    13.921   198.166     0.150
    13.979   199.805     0.150
    14.027   200.283     0.150
    14.024   199.350     0.150
    14.036   200.797     0.150
    14.088   204.445     0.150
    14.047   200.271     0.150
    14.056   200.117     0.150
    14.092   204.453     0.150
    14.084   201.908     0.150
    14.097   201.527     0.150
    14.133   202.963     0.150
    14.133   203.734     0.150
    14.133   202.936     0.150
    14.209   206.463     0.150
    14.219   204.084     0.150
    14.241   203.326     0.150
    14.251   203.443     0.150
    14.271   204.023     0.150
    14.274   203.281     0.150
    14.307   204.393     0.150
    14.407   207.211     0.150
    14.352   204.387     0.150
    14.384   205.586     0.150
    14.379   204.891     0.150
    14.393   205.055     0.150
    14.427   205.660     0.150
    14.430   205.135     0.150
    14.463   210.074     0.150
    14.444   205.947     0.150
    14.507   208.391     0.150
    14.518   211.014     0.150
    14.490   205.521     0.150
    14.513   206.184     0.150
    14.550   208.010     0.150
    14.597   208.082     0.150
    14.585   206.971     0.150
    14.592   206.904     0.150
    14.596   207.979     0.150
    14.606   206.941     0.150
    14.632   207.787     0.150
    14.632   207.326     0.150
    14.754   212.525     0.150
    14.726   209.098     0.150
    14.750   211.500     0.150
    14.750   214.104     0.150
    14.742   210.779     0.150
    14.780   214.084     0.150
    14.766   216.064     0.150
    14.810   210.566     0.150
    14.810   212.123     0.150
    14.815   210.264     0.150
    14.828   210.846     0.150
    14.853   210.629     0.150
    14.858   210.414     0.150
    14.858   211.074     0.150
    14.890   212.389     0.150
    14.883   212.104     0.150
    14.941   216.533     0.150
    14.943   216.213     0.150
    14.945   217.703     0.150
    14.940   212.750     0.150
    14.935   212.105     0.150
    14.962   211.264     0.150
    14.964   217.225     0.150
    14.936   212.336     0.150
    14.955   213.154     0.150
    14.991   212.561     0.150
    15.008   213.691     0.150
    15.025   213.779     0.150
    15.045   218.053     0.150
    15.048   218.613     0.150
    15.032   212.715     0.150
    15.064   218.395     0.150
    15.061   214.713     0.150
    15.087   213.895     0.150
    15.090   213.949     0.150
    15.133   217.234     0.150
    15.153   219.633     0.150
    15.150   216.094     0.150
    15.186   215.520     0.150
    15.188   215.359     0.150
    15.188   216.674     0.150
    15.240   215.701     0.150
    15.302   219.373     0.150
    15.282   216.137     0.150
    15.346   220.029     0.150
    15.317   216.486     0.150
    15.350   217.086     0.150
    15.373   217.441     0.150
    15.373   219.674     0.150
    15.435   218.154     0.150
    15.497   221.955     0.150
    15.489   222.844     0.150
    15.470   219.756     0.150
    15.467   220.232     0.150
    15.473   218.977     0.150
    15.478   219.992     0.150
    15.476   219.012     0.150
    15.485   218.578     0.150
    15.498   220.422     0.150
    15.497   218.961     0.150
    15.508   219.566     0.150
    15.531   221.266     0.150
    15.516   220.037     0.150
    15.597   222.551     0.150
    15.596   220.701     0.150
    15.683   224.389     0.150
    15.693   223.029     0.150
    15.704   222.445     0.150
    15.734   223.357     0.150
    15.800   226.314     0.150
    15.778   223.803     0.150
    15.823   228.783     0.150
    15.790   224.172     0.150
    15.810   224.592     0.150
    15.800   224.125     0.150
    15.819   224.344     0.150
    15.810   223.352     0.150
    15.843   224.807     0.150
    15.870   224.857     0.150
    15.875   225.100     0.150
    15.895   224.332     0.150
    15.902   224.414     0.150
    15.902   523.764     0.150
    15.956   229.203     0.150
    15.992   229.584     0.150
    15.973   226.420     0.150
    15.962   225.283     0.150
    15.979   225.176     0.150
    16.008   226.041     0.150
    16.065   229.533     0.150
    16.068   229.854     0.150
    16.036   226.795     0.150
    16.060   227.623     0.150
    16.137   231.133     0.150
    16.150   227.148     0.150
    16.161   227.820     0.150
    16.170   228.082     0.150
    16.180   228.215     0.150
    16.185   227.162     0.150
    16.228   231.293     0.150
    16.230   229.061     0.150
    16.256   231.293     0.150
    16.262   228.848     0.150
    16.320   232.746     0.150
    16.348   232.113     0.150
    16.348   236.383     0.150
    16.302   228.783     0.150
    16.322   231.014     0.150
    16.310   229.646     0.150
    16.315   230.203     0.150
    16.358   231.250     0.150
    16.397   231.227     0.150
    16.409   231.916     0.150
    16.398   231.299     0.150
    16.412   231.242     0.150
    16.479   231.164     0.150
    16.494   232.854     0.150
    16.500   233.275     0.150
    16.539   233.137     0.150
    16.545   232.510     0.150
    16.550   232.977     0.150
    16.550   234.484     0.150
    16.574   233.332     0.150
    16.624   237.074     0.150
    16.593   235.650     0.150
    16.645   234.123     0.150
    16.689   234.701     0.150
    16.729   236.135     0.150
    16.732   235.275     0.150
    16.735   235.209     0.150
    16.753   235.867     0.150
    16.777   235.531     0.150
    16.796   236.449     0.150
    16.807   235.947     0.150
    16.884   238.877     0.150
    16.836   236.281     0.150
    16.850   236.814     0.150
    16.887   241.244     0.150
    16.865   236.990     0.150
    16.862   236.729     0.150
    16.862   237.104     0.150
    16.907   239.230     0.150
    16.907   240.314     0.150
    16.913   238.637     0.150
    16.940   237.229     0.150
    16.948   237.426     0.150
    16.993   241.283     0.150
    16.981   239.436     0.150
    17.006   241.914     0.150
    16.998   239.869     0.150
    16.985   237.834     0.150
    17.029   238.914     0.150
    17.031   238.852     0.150
    17.052   238.895     0.150
    17.072   239.453     0.150
    17.112   241.131     0.150
    17.118   239.477     0.150
    17.118   241.225     0.150
    17.132   240.496     0.150
    17.215   244.213     0.150
    17.178   240.883     0.150
    17.249   244.914     0.150
    17.214   241.691     0.150
    17.264   243.934     0.150
    17.240   243.174     0.150
    17.283   242.391     0.150
    17.297   242.953     0.150
    17.327   244.943     0.150
    17.330   243.580     0.150
    17.330   244.953     0.150
    17.357   242.902     0.150
    17.356   243.299     0.150
    17.382   243.398     0.150
    17.399   244.148     0.150
    17.411   243.211     0.150
    17.436   244.893     0.150
    17.462   245.998     0.150
    17.463   245.938     0.150
    17.474   244.342     0.150
    17.527   248.184     0.150
    17.486   245.482     0.150
    17.511   244.502     0.150
    17.517   244.766     0.150
    17.577   246.859     0.150
    17.547   245.201     0.150
    17.587   247.725     0.150
    17.616   250.164     0.150
    17.573   245.037     0.150
    17.581   244.922     0.150
    17.583   245.062     0.150
    17.623   245.693     0.150
    17.721   247.207     0.150
    17.735   247.834     0.150
    17.774   248.109     0.150
    17.789   247.803     0.150
    17.808   248.938     0.150
    17.846   251.113     0.150
    17.870   250.629     0.150
    17.870   251.283     0.150
    17.866   250.438     0.150
    17.862   249.008     0.150
    17.862   249.035     0.150
    17.895   250.838     0.150
    17.935   252.703     0.150
    17.941   252.133     0.150
    18.009   250.930     0.150
    18.052   253.373     0.150
    18.024   251.113     0.150
    18.024   250.844     0.150
    18.049   253.051     0.150
    18.044   251.652     0.150
    18.068   253.988     0.150
    18.089   254.053     0.150
    18.060   251.502     0.150
    18.163   255.113     0.150
    18.143   252.811     0.150
    18.186   253.535     0.150
    18.201   254.387     0.150
    18.208   255.215     0.150
    18.255   255.064     0.150
    18.298   257.414     0.150
    18.300   256.184     0.150
    18.308   254.824     0.150
    18.323   254.273     0.150
    18.349   255.459     0.150
    18.387   256.211     0.150
    18.418   258.254     0.150
    18.418   259.734     0.150
    18.405   257.211     0.150
    18.482   258.113     0.150
    18.482   259.314     0.150
    18.482   257.854     0.150
    18.547   257.664     0.150
    18.574   259.527     0.150
    18.582   260.207     0.150
    18.614   258.545     0.150
    18.718   259.502     0.150
    18.728   259.900     0.150
    18.732   259.494     0.150
    18.736   259.857     0.150
    18.797   260.725     0.150
    18.869   261.807     0.150
    18.898   262.639     0.150
    18.892   261.381     0.150
    18.948   263.002     0.150
    19.013   264.654     0.150
    19.061   263.941     0.150
    19.064   264.574     0.150
    19.138   264.859     0.150
    19.171   265.447     0.150
    19.189   265.662     0.150
    19.211   266.020     0.150
    19.270   266.242     0.150
    19.326   267.844     0.150
    19.319   266.758     0.150
    19.332   266.734     0.150
    19.366   267.162     0.150
    19.379   267.674     0.150
    19.423   272.314     0.150
    19.478   268.455     0.150
    19.649   270.318     0.150
    19.682   271.287     0.150
    19.683   271.137     0.150
    19.698   270.934     0.150
    19.744   271.510     0.150
    19.752   271.516     0.150
    19.785   272.434     0.150
    19.848   272.328     0.150
    19.900   273.857     0.150
    19.861   272.777     0.150
    20.062   275.238     0.150
    20.062   276.074     0.150
    20.125   275.654     0.150
    20.177   275.877     0.150
    20.186   275.971     0.150
    20.202   276.834     0.150
    20.230   276.861     0.150
    20.242   276.703     0.150
    20.266   277.266     0.150
    20.298   277.652     0.150
    20.401   278.605     0.150
    20.388   277.461     0.150
    20.529   279.547     0.150
    20.600   280.607     0.150
    20.661   280.764     0.150
    20.704   281.049     0.150
    20.726   281.871     0.150
    20.718   282.133     0.150
    20.805   283.131     0.150
    20.914   283.869     0.150
    20.929   283.963     0.150
    20.966   284.641     0.150
    20.959   284.633     0.150
    21.115   285.924     0.150
    21.131   287.334     0.150
    21.148   286.383     0.150
    21.148   285.713     0.150
    21.196   286.301     0.150
    21.330   287.811     0.150
    21.336   288.584     0.150
    21.351   288.215     0.150
    21.436   289.465     0.150
    21.432   289.814     0.150
    21.506   290.186     0.150
    21.570   291.414     0.150
    21.665   293.154     0.150
    21.741   292.510     0.150
    21.745   292.779     0.150
    21.751   292.920     0.150
    21.760   292.072     0.150
    21.765   293.443     0.150
    21.793   293.105     0.150
    21.902   294.383     0.150
    22.109   297.344     0.150
    22.149   296.818     0.150
    22.157   297.082     0.150
    22.227   297.322     0.150
    22.313   298.412     0.150
    22.416   299.266     0.150
    22.543   300.402     0.150
    22.597   301.404     0.150
    22.654   302.201     0.150
    22.725   303.324     0.150
    22.781   304.373     0.150
    22.863   304.094     0.150
    22.886   304.812     0.150
    22.908   306.213     0.150
    23.002   305.703     0.150
    23.124   306.787     0.150
    23.124   307.404     0.150
    23.132   309.014     0.150
    23.178   306.617     0.150
    23.314   308.713     0.150
    23.362   310.273     0.150
    23.704   312.889     0.150
    24.342   320.004     0.150
    24.398   319.053     0.150
    24.398   319.994     0.150
    24.476   321.414     0.150
    24.540   321.314     0.150
    24.507   321.414     0.150
    24.559   320.639     0.150
    25.068   325.789     0.150
    25.068   326.043     0.150
    25.358   328.914     0.150
    25.510   329.354     0.150
    26.133   335.838     0.150
    26.133   336.613     0.150
    26.321   337.914     0.150
    26.321   337.514     0.150
    26.310   335.445     0.150
    26.310   338.434     0.150
    26.389   338.924     0.150
    27.406   347.914     0.150
    28.100   352.758     0.150
    28.100   353.553     0.150
    28.151   356.014     0.150
    28.947   362.514     0.150
    29.399   369.514     0.150
    29.451   366.793     0.150
    30.554   376.264     0.150
    30.554   376.684     0.150
    31.287   381.264     0.150
    31.287   382.764     0.150
    32.606   393.971     0.150
    33.501   400.814     0.150
    34.406   410.033     0.150
    34.833   412.654     0.150
    34.833   494.234     0.150
    35.281   417.924     0.150
    36.677   431.414     0.150
    37.047   434.494     0.150
    37.181   435.725     0.150
    37.735   439.574     0.150
    37.872   438.293     0.150
    37.867   440.264     0.150
    38.231   444.693     0.150
    38.341   443.773     0.150
    38.440   444.613     0.150
    38.440   445.113     0.150
    38.500   445.193     0.150
    38.727   448.014     0.150
    38.739   805.953     0.150
    38.754   448.314     0.150
    38.771   446.293     0.150
    38.953   448.014     0.150
    39.042   449.574     0.150
    39.116   450.213     0.150
    39.437   454.193     0.150
    39.656   455.234     0.150
    39.656   807.453     0.150
    39.905   456.744     0.150
    40.013   458.494     0.150
    40.095   457.314     0.150
    40.095   459.314     0.150
    40.161   460.014     0.150
    40.200   459.834     0.150
    40.400   460.414     0.150
    40.431   459.803     0.150
    40.431   460.363     0.150
    40.431   583.066     0.150
    40.607   461.994     0.150
    40.634   463.113     0.150
    40.669   463.283     0.150
    40.689   463.033     0.150
    40.802   464.213     0.150
    40.802   464.523     0.150
    41.045   465.895     0.150
    41.233   469.113     0.150
    41.313   467.613     0.150
    41.336   467.994     0.150
    41.422   468.193     0.150
    41.436   469.414     0.150
    41.836   472.514     0.150
    41.844   471.289     0.150
    41.844   471.863     0.150
    42.287   477.383     0.150
    42.528   477.113     0.150
    43.099   484.404     0.150
    43.419   484.494     0.150
    43.883   488.023     0.150
    44.260   495.283     0.150
    44.598   492.383     0.150
    44.946   497.703     0.150
    44.973   499.164     0.150
    45.004   495.283     0.150
    45.004   497.463     0.150
    45.081   499.627     0.150
    45.081   497.424     0.150
    45.439   500.613     0.150
    50.361   540.963     0.150
    52.552   555.414     0.150
    52.552   553.734     0.150
    57.492   590.314     0.150
    57.492   590.953     0.150
    58.254  1092.613     0.150
    58.686   598.814     0.150
    58.686     4.398     0.150
    59.895   607.957     0.150
    59.895   608.904     0.150
    62.396   622.514     0.150
    62.391   623.883     0.150
    65.349   644.664     0.150
    65.624   646.414     0.150
    65.624   646.838     0.150
    67.177   656.613     0.150
    75.113   703.914     0.150
    75.125   704.514     0.150
    76.403   710.814     0.150
    76.403  1296.314     0.150
    76.403  1316.514     0.150
    76.621   712.988     0.150
    78.025   720.863     0.150
    78.025   721.814     0.150
    78.151   722.164     0.150
    79.122   727.414     0.150
    79.136   726.213     0.150
    79.136   725.389     0.150
    80.494   732.414     0.150
    80.494     3.500     0.150
    80.494     4.600     0.150
    80.494   915.314     0.150
    80.494  1339.213     0.150
    80.494  1345.014     0.150
    80.494  1651.414     0.150
    81.820   742.713     0.150
    82.111   743.613     0.150
    82.418  1681.014     0.150
    82.854   747.514     0.150
    83.101   749.213     0.150
    83.134   748.514     0.150
    83.215   749.713     0.150
    83.275   750.514     0.150
    83.686   752.514     0.150
    83.742   749.414     0.150
    83.732   748.213     0.150
    83.970   754.213     0.150
    84.025   755.213     0.150
    84.051   753.414     0.150
    84.717   756.738     0.150
    85.191   758.588     0.150
    85.216   758.914     0.150
    85.280   759.189     0.150
    85.281   759.414     0.150
    85.281   758.713     0.150
    86.750  1470.514     0.150
    86.750  1830.514     0.150
    88.806   778.504     0.150
    88.846   774.602     0.150
    88.880   776.213     0.150
    91.359   786.414     0.150
    91.682   790.514     0.150
    91.682     2.199     0.150
    91.682     3.301     0.150
    91.682  1006.113     0.150
    92.238   794.113     0.150
    92.238   792.693     0.150
    92.418   793.213     0.150
    93.462   798.814     0.150
    93.796   799.713     0.150
    93.796  1020.914     0.150
    94.196   801.414     0.150
    94.196   802.094     0.150
    94.460   803.984     0.150
    94.460  1028.844     0.150
    94.474   803.633     0.150
    94.897   804.334     0.150
    94.897   804.539     0.150
    94.962   803.914     0.150
    95.885   805.713     0.150
    96.147   808.014     0.150
    96.499   809.213     0.150
    97.306   815.014     0.150
    97.335   815.625     0.150
    97.856   817.914     0.150
    97.856   823.914     0.150
    97.856  1058.814     0.150
    97.856  1499.914     0.150
    97.856  1901.314     0.150
   101.279   828.514     0.150
   109.587   869.113     0.150
   109.587  1142.314     0.150
   109.587  1600.014     0.150
   109.587  2065.014     0.150
   110.300  1156.914     0.150
   110.300  1543.814     0.150
   110.300  2083.814     0.150
   111.667   880.314     0.150
   111.667  1116.514     0.150
   111.667  1161.814     0.150
   114.836  1128.814     0.150
   114.836  1185.314     0.150
   115.473  1124.814     0.150
   115.473  1184.514     0.150
   117.867  1128.664     0.150
   119.646  1132.053     0.150
   119.686  1132.463     0.150
   119.744  1132.213     0.150
   122.299  1138.213     0.150
   123.419  1138.379     0.150
   124.777  1141.197     0.150
     1.246    20.754     0.150
     1.246    38.723     0.150
     2.124    33.684     0.150
     2.473    40.203     0.150
     2.510    38.887     0.150
     2.510    38.434     0.150
     2.710    42.375     0.150
     2.776    43.215     0.150
     2.844    43.941     0.150
     2.922    44.793     0.150
     2.922    76.453     0.150
     3.067    48.656     0.150
     3.074    46.723     0.150
     3.074    46.391     0.150
     3.074    83.914     0.150
     3.133    47.875     0.150
     3.133    48.102     0.150
     3.080    50.512     0.150
     3.080    87.281     0.150
     3.080    49.434     0.150
     3.080    81.633     0.150
     3.257    49.441     0.150
     3.183    48.344     0.150
     3.183    88.602     0.150
     3.383    52.551     0.150
     3.383    92.324     0.150
     3.488    52.914     0.150
     3.635    57.004     0.150
     3.638    54.895     0.150
     3.638    54.621     0.150
     3.642    54.750     0.150
     3.640    55.902     0.150
     3.640    98.754     0.150
     4.025    63.004     0.150
     4.148    62.281     0.150
     4.086    61.602     0.150
     4.369    65.539     0.150
     4.443    67.504     0.150
     4.543    70.691     0.150
     4.674    72.004     0.150
     4.971    78.953     0.150
     5.011    90.922     0.150
     5.053    75.656     0.150
     5.145    77.301     0.150
     5.145   138.473     0.150
     5.174    77.844     0.150
     5.174   142.191     0.150
     5.323    80.160     0.150
     5.323    80.664     0.150
     5.323   143.023     0.150
     5.587    84.094     0.150
     5.598    82.707     0.150
     5.598    82.914     0.150
     5.743    87.270     0.150
     5.705    84.801     0.150
     5.705    85.402     0.150
     5.930    88.602     0.150
     5.935    89.711     0.150
     6.151    92.918     0.150
     6.272    96.758     0.150
     6.272    92.492     0.150
     6.272   107.734     0.150
     6.291    96.297     0.150
     6.383    95.641     0.150
     6.379    95.164     0.150
     6.379   168.684     0.150
     6.528    98.184     0.150
     6.569    98.832     0.150
     6.569    97.484     0.150
     6.726   102.211     0.150
     6.723   102.578     0.150
     6.881   105.523     0.150
     6.907   103.152     0.150
     6.938   104.355     0.150
     6.869   100.070     0.150
     6.869   101.293     0.150
     6.869   179.961     0.150
     6.869    99.934     0.150
     6.873   100.973     0.150
     6.919   103.734     0.150
     6.971   104.211     0.150
     7.120   104.672     0.150
     7.120   187.922     0.150
     7.192   105.371     0.150
     7.312   108.191     0.150
     7.311   111.125     0.150
     7.428   106.500     0.150
     7.428   108.602     0.150
     7.524   112.961     0.150
     7.636   110.613     0.150
     7.636   195.762     0.150
     7.636   237.238     0.150
     7.636   110.789     0.150
     7.636   111.363     0.150
     7.801   115.164     0.150
     7.871   114.672     0.150
     7.882   114.953     0.150
     7.969   114.953     0.150
     7.986   119.062     0.150
     7.967   116.984     0.150
     7.967   117.281     0.150
     8.157   118.672     0.150
     8.550   124.551     0.150
     8.550   127.914     0.150
     8.698   126.281     0.150
     8.716   126.953     0.150
     8.787   130.453     0.150
     8.787   222.133     0.150
     8.905   131.273     0.150
     8.905   224.543     0.150
     8.922   132.332     0.150
     8.913   127.512     0.150
     9.048   135.844     0.150
     9.082   130.453     0.150
     9.024   129.211     0.150
     9.025   129.141     0.150
     9.025   286.914     0.150
     9.025   129.137     0.150
     9.025   286.914     0.150
     9.195   132.641     0.150
     9.221   135.328     0.150
     9.221   137.312     0.150
     9.381   136.984     0.150
     9.416   137.184     0.150
     9.464   137.801     0.150
     9.541   139.004     0.150
     9.575   141.758     0.150
     9.575   140.422     0.150
     9.610   143.992     0.150
     9.960   145.125     0.150
     9.960   144.941     0.150
    10.068   145.742     0.150
    10.086   146.473     0.150
    10.033   144.371     0.150
    10.033   142.801     0.150
    10.057   145.684     0.150
    10.131   148.137     0.150
    10.131   327.762     0.150
    10.143   145.633     0.150
    10.186   145.582     0.150
    10.287   146.574     0.150
    10.262   146.102     0.150
    10.579   155.621     0.150
    10.554   153.914     0.150
    10.554   152.812     0.150
    10.654   153.223     0.150
    11.011   158.723     0.150
    11.062   162.191     0.150
    11.154   162.453     0.150
    11.169   159.801     0.150
    11.398   164.449     0.150
    11.398   164.164     0.150
    11.549   169.883     0.150
    12.116   173.133     0.150
    12.208   175.082     0.150
    12.208   173.812     0.150
    12.312   174.891     0.150
    12.348   177.312     0.150
    12.419   177.664     0.150
    12.364   176.922     0.150
    12.364   176.531     0.150
    12.497   179.375     0.150
    12.601   182.352     0.150
    12.601   180.043     0.150
    12.601   178.832     0.150
    12.601   181.062     0.150
    12.601   403.145     0.150
    12.601   179.191     0.150
    12.797   186.559     0.150
    12.833   187.402     0.150
    12.905   189.020     0.150
    12.916   184.824     0.150
    12.899   187.176     0.150
    12.899   184.262     0.150
    12.849   183.012     0.150
    12.934   184.734     0.150
    12.903   182.984     0.150
    13.046   189.621     0.150
    13.117   190.172     0.150
    13.117   190.312     0.150
    13.178   190.551     0.150
    13.327   193.074     0.150
    13.380   192.027     0.150
    13.484   197.191     0.150
    13.497   191.574     0.150
    13.422   191.152     0.150
    13.422   191.531     0.150
    13.726   196.602     0.150
    13.882   201.246     0.150
    13.985   201.547     0.150
    14.148   205.762     0.150
    14.094   200.812     0.150
    14.178   203.914     0.150
    14.245   204.148     0.150
    14.737   212.887     0.150
    14.684   207.898     0.150
    14.860   214.340     0.150
    14.814   208.480     0.150
    14.814   216.863     0.150
    14.917   213.945     0.150
    14.964   212.195     0.150
    15.040   216.316     0.150
    15.040   215.621     0.150
    14.977   210.023     0.150
    15.041   211.184     0.150
    15.041   212.734     0.150
    15.137   219.004     0.150
    15.110   213.586     0.150
    15.127   220.762     0.150
    15.214   215.598     0.150
    15.268   222.223     0.150
    15.295   222.043     0.150
    15.303   216.039     0.150
    15.349   217.773     0.150
    15.440   219.824     0.150
    15.479   218.902     0.150
    15.515   222.824     0.150
    15.461   224.824     0.150
    15.578   222.148     0.150
    15.578   221.363     0.150
    15.557   218.621     0.150
    15.578   220.500     0.150
    15.673   225.418     0.150
    15.635   221.086     0.150
    15.679   221.102     0.150
    15.747   223.020     0.150
    15.793   222.676     0.150
    15.782   222.961     0.150
    15.922   228.914     0.150
    15.861   223.566     0.150
    15.925   224.316     0.150
    15.925   224.934     0.150
    16.073   225.785     0.150
    16.073   226.812     0.150
    16.161   230.832     0.150
    16.161   227.371     0.150
    16.175   231.281     0.150
    16.150   226.785     0.150
    16.150   227.223     0.150
    16.192   228.367     0.150
    16.196   228.398     0.150
    16.196   228.004     0.150
    16.200   228.184     0.150
    16.224   228.156     0.150
    16.309   230.113     0.150
    16.310   232.684     0.150
    16.242   229.059     0.150
    16.320   229.344     0.150
    16.319   229.652     0.150
    16.534   231.531     0.150
    16.534   232.223     0.150
    16.556   233.023     0.150
    16.556   234.703     0.150
    16.581   230.164     0.150
    16.590   232.051     0.150
    16.605   231.793     0.150
    16.725   235.094     0.150
    16.831   238.742     0.150
    16.788   234.617     0.150
    16.839   236.113     0.150
    16.920   236.754     0.150
    16.968   237.801     0.150
    16.990   238.504     0.150
    17.081   238.961     0.150
    17.021   237.809     0.150
    17.054   239.734     0.150
    17.107   241.512     0.150
    17.072   239.219     0.150
    17.131   239.977     0.150
    17.118   240.430     0.150
    17.158   240.223     0.150
    17.166   239.207     0.150
    17.378   244.281     0.150
    17.305   241.430     0.150
    17.332   242.684     0.150
    17.450   243.492     0.150
    17.418   243.734     0.150
    17.477   243.844     0.150
    17.537   245.777     0.150
    17.528   245.375     0.150
    17.535   245.234     0.150
    17.654   249.289     0.150
    17.654   248.074     0.150
    17.611   245.949     0.150
    17.618   247.613     0.150
    17.649   246.371     0.150
    17.645   246.262     0.150
    17.762   250.012     0.150
    17.762   250.336     0.150
    17.762   247.641     0.150
    17.709   247.875     0.150
    17.739   247.227     0.150
    17.760   246.977     0.150
    17.798   248.320     0.150
    17.846   248.039     0.150
    17.869   248.242     0.150
    18.055   255.035     0.150
    17.996   251.859     0.150
    17.989   250.938     0.150
    17.989   250.055     0.150
    18.002   250.305     0.150
    18.032   252.168     0.150
    18.041   250.852     0.150
    18.161   254.754     0.150
    18.124   252.879     0.150
    18.112   252.531     0.150
    18.112   252.941     0.150
    18.161   255.293     0.150
    18.145   252.664     0.150
    18.159   252.961     0.150
    18.213   253.297     0.150
    18.233   253.789     0.150
    18.261   254.207     0.150
    18.332   253.379     0.150
    18.392   254.543     0.150
    18.341   254.562     0.150
    18.434   258.699     0.150
    18.410   254.992     0.150
    18.432   254.586     0.150
    18.451   256.352     0.150
    18.513   258.344     0.150
    18.492   256.621     0.150
    18.564   257.949     0.150
    18.628   257.848     0.150
    18.661   259.152     0.150
    18.661   257.723     0.150
    18.751   266.684     0.150
    18.690   259.609     0.150
    18.682   257.758     0.150
    18.707   259.781     0.150
    18.759   259.602     0.150
    18.776   259.059     0.150
    18.838   261.348     0.150
    18.847   259.680     0.150
    18.862   261.160     0.150
    18.915   262.223     0.150
    18.929   262.809     0.150
    18.929   261.883     0.150
    18.942   263.043     0.150
    18.970   263.164     0.150
    18.970   262.613     0.150
    19.002   265.176     0.150
    19.054   263.887     0.150
    19.088   263.797     0.150
    19.076   264.766     0.150
    19.127   264.172     0.150
    19.161   264.523     0.150
    19.212   264.465     0.150
    19.244   266.836     0.150
    19.228   264.508     0.150
    19.300   268.102     0.150
    19.257   266.172     0.150
    19.308   266.727     0.150
    19.378   266.398     0.150
    19.419   266.703     0.150
    19.440   267.590     0.150
    19.472   266.895     0.150
    19.493   267.734     0.150
    19.493   266.227     0.150
    19.599   269.082     0.150
    19.632   269.441     0.150
    19.656   271.059     0.150
    19.740   269.211     0.150
    19.775   269.770     0.150
    19.771   268.516     0.150
    19.821   270.816     0.150
    19.847   272.633     0.150
    19.869   270.543     0.150
    19.892   272.879     0.150
    19.928   271.281     0.150
    19.967   273.832     0.150
    20.090   276.934     0.150
    20.064   270.980     0.150
    20.064   276.312     0.150
    20.100   274.992     0.150
    20.093   272.836     0.150
    20.133   275.840     0.150
    20.133   275.504     0.150
    20.141   276.902     0.150
    20.131   272.402     0.150
    20.193   277.059     0.150
    20.237   276.934     0.150
    20.298   277.008     0.150
    20.338   277.516     0.150
    20.376   277.285     0.150
    20.407   279.625     0.150
    20.388   277.906     0.150
    20.409   277.906     0.150
    20.455   279.281     0.150
    20.436   278.613     0.150
    20.492   277.637     0.150
    20.568   282.551     0.150
    20.574   280.668     0.150
    20.553   280.574     0.150
    20.614   279.441     0.150
    20.664   279.207     0.150
    20.656   281.016     0.150
    20.806   283.414     0.150
    20.735   281.312     0.150
    20.742   281.441     0.150
    20.752   283.082     0.150
    20.785   281.230     0.150
    20.899   280.176     0.150
    20.889   285.008     0.150
    20.921   281.414     0.150
    21.013   284.277     0.150
    21.006   285.297     0.150
    21.010   284.551     0.150
    21.028   287.121     0.150
    21.038   286.336     0.150
    21.033   285.035     0.150
    21.033   285.742     0.150
    21.041   285.488     0.150
    21.085   285.969     0.150
    21.083   283.512     0.150
    21.171   287.133     0.150
    21.191   285.789     0.150
    21.205   286.250     0.150
    21.234   287.465     0.150
    21.234   286.316     0.150
    21.251   288.992     0.150
    21.250   286.699     0.150
    21.266   286.145     0.150
    21.288   285.664     0.150
    21.340   290.633     0.150
    21.379   289.996     0.150
    21.424   291.016     0.150
    21.460   289.480     0.150
    21.510   292.141     0.150
    21.504   289.891     0.150
    21.510   291.113     0.150
    21.533   289.504     0.150
    21.599   291.859     0.150
    21.583   290.734     0.150
    21.616   291.684     0.150
    21.631   293.652     0.150
    21.682   291.883     0.150
    21.704   293.906     0.150
    21.698   292.969     0.150
    21.688   294.266     0.150
    21.715   292.691     0.150
    21.751   294.699     0.150
    21.743   293.633     0.150
    21.750   294.504     0.150
    21.790   294.906     0.150
    21.832   294.516     0.150
    21.835   293.922     0.150
    21.860   294.039     0.150
    21.858   294.238     0.150
    21.888   295.684     0.150
    21.955   295.852     0.150
    22.001   296.871     0.150
    22.053   296.855     0.150
    22.062   297.027     0.150
    22.010   296.156     0.150
    22.064   297.516     0.150
    22.116   296.148     0.150
    22.105   296.285     0.150
    22.110   296.617     0.150
    22.158   297.695     0.150
    22.160   297.582     0.150
    22.202   297.109     0.150
    22.214   297.406     0.150
    22.276   297.453     0.150
    22.301   297.816     0.150
    22.301   299.254     0.150
    22.299   296.180     0.150
    22.313   297.711     0.150
    22.349   298.785     0.150
    22.400   299.766     0.150
    22.411   300.691     0.150
    22.403   299.000     0.150
    22.439   301.578     0.150
    22.476   301.891     0.150
    22.465   300.723     0.150
    22.465   300.941     0.150
    22.479   301.316     0.150
    22.511   302.000     0.150
    22.515   301.961     0.150
    22.515   299.762     0.150
    22.512   301.156     0.150
    22.561   300.953     0.150
    22.552   303.227     0.150
    22.543   300.793     0.150
    22.535   297.277     0.150
    22.540   301.504     0.150
    22.584   302.777     0.150
    22.676   305.062     0.150
    22.688   302.734     0.150
    22.695   302.871     0.150
    22.710   304.570     0.150
    22.781   304.559     0.150
    22.781   303.672     0.150
    22.864   304.926     0.150
    22.864   305.410     0.150
    22.917   305.703     0.150
    22.935   305.570     0.150
    23.006   306.258     0.150
    23.003   308.508     0.150
    22.980   305.570     0.150
    23.012   305.602     0.150
    23.012   305.293     0.150
    23.054   306.984     0.150
    23.057   306.547     0.150
    23.076   305.184     0.150
    23.064   306.062     0.150
    23.109   307.379     0.150
    23.151   307.664     0.150
    23.152   307.113     0.150
    23.201   309.512     0.150
    23.214   308.102     0.150
    23.248   309.785     0.150
    23.240   307.711     0.150
    23.393   311.984     0.150
    23.400   311.230     0.150
    23.432   308.922     0.150
    23.478   311.664     0.150
    23.465   311.234     0.150
    23.494   310.070     0.150
    23.543   312.867     0.150
    23.539   313.047     0.150
    23.543   311.676     0.150
    23.575   311.676     0.150
    23.636   313.984     0.150
    23.732   313.984     0.150
    23.822   313.113     0.150
    23.822   313.531     0.150
    23.814   313.312     0.150
    23.851   315.680     0.150
    23.928   313.270     0.150
    23.929   316.094     0.150
    24.001   316.277     0.150
    23.983   315.281     0.150
    24.015   315.590     0.150
    24.014   315.953     0.150
    24.075   316.250     0.150
    24.134   317.203     0.150
    24.250   317.598     0.150
    24.327   319.492     0.150
    24.355   322.191     0.150
    24.421   321.617     0.150
    24.539   323.535     0.150
    25.555   330.363     0.150
    25.710   332.738     0.150
    25.710   331.031     0.150
    31.862   386.008     0.150
    38.120   442.613     0.150
    39.398   451.613     0.150
    39.398   454.781     0.150
    39.800   455.051     0.150
    39.800   455.414     0.150
    39.800   456.562     0.150
    40.583   461.184     0.150
    40.725   464.164     0.150
    42.458   478.602     0.150
    42.793   479.324     0.150
    45.577   499.844     0.150
    45.788   503.258     0.150
    56.731   585.863     0.150
    56.731   584.742     0.150
    65.183   643.531     0.150
    65.184   643.539     0.150
    82.684   748.012     0.150
    84.550   757.863     0.150
    88.143   773.164     0.150
    92.716   795.363     0.150
    93.882   802.961     0.150
    93.882   802.961     0.150
    97.330   816.461     0.150
   109.588  1605.363     0.150
   109.588  2073.461     0.150
   144.777  1181.164     0.150
     1.287    20.469     0.150
     1.287    37.484     0.150
     1.287    40.305     0.150
     1.367    40.562     0.150
     1.367    38.930     0.150
     1.369    23.008     0.150
     1.369    42.039     0.150
     1.694    52.875     0.150
     2.572    39.773     0.150
     2.572    39.625     0.150
     2.757    42.758     0.150
     2.757    82.414     0.150
     2.828    42.664     0.150
     2.879    45.766     0.150
     2.879    44.367     0.150
     2.879    76.359     0.150
     2.879    44.469     0.150
     3.050    47.656     0.150
     3.050    86.477     0.150
     3.050    83.484     0.150
     3.050    47.469     0.150
     2.959    45.383     0.150
     2.959    78.258     0.150
     3.112    47.938     0.150
     3.112    92.219     0.150
     3.115    47.648     0.150
     3.223    49.727     0.150
     3.223    94.547     0.150
     3.223    48.102     0.150
     3.197    48.773     0.150
     3.583    61.477     0.150
     3.583    65.266     0.150
     3.527    53.547     0.150
     3.527    53.500     0.150
     3.668    54.820     0.150
     3.687    56.094     0.150
     3.689    56.094     0.150
     3.689   116.344     0.150
     3.689    55.281     0.150
     3.689   103.328     0.150
     4.104    62.328     0.150
     4.071    60.977     0.150
     4.071   112.883     0.150
     4.441    66.953     0.150
     4.509    67.680     0.150
     4.574    70.219     0.150
     4.574   128.938     0.150
     4.684    69.414     0.150
     4.710    70.734     0.150
     4.710   131.789     0.150
     4.801    72.477     0.150
     4.801   133.906     0.150
     4.818    73.242     0.150
     4.818   135.312     0.150
     4.986    74.336     0.150
     5.016    78.562     0.150
     5.200    75.891     0.150
     5.279    78.297     0.150
     5.279    77.625     0.150
     5.385    80.844     0.150
     5.385   172.258     0.150
     5.385    80.664     0.150
     5.627    83.609     0.150
     5.566    84.320     0.150
     5.647    83.188     0.150
     5.682    85.641     0.150
     5.760    86.359     0.150
     5.760    85.773     0.150
     5.797    85.086     0.150
     5.884    86.570     0.150
     6.000    89.734     0.150
     5.994    89.453     0.150
     6.107    91.438     0.150
     6.194    90.414     0.150
     6.208    91.453     0.150
     6.323    96.195     0.150
     6.323    93.352     0.150
     6.350    93.320     0.150
     6.506    96.812     0.150
     6.445    95.547     0.150
     6.440    97.336     0.150
     6.440   126.195     0.150
     6.631    99.305     0.150
     6.631    97.875     0.150
     6.778    99.328     0.150
     6.775    98.812     0.150
     6.914   102.133     0.150
     6.915   102.438     0.150
     6.924   101.148     0.150
     6.973   103.945     0.150
     6.985   105.109     0.150
     6.997   102.820     0.150
     7.038   104.594     0.150
     7.159   105.188     0.150
     7.225   109.273     0.150
     7.225   236.180     0.150
     7.232   107.273     0.150
     7.446   109.750     0.150
     7.446   138.227     0.150
     7.446   108.844     0.150
     7.590   113.555     0.150
     7.677   111.367     0.150
     7.680   112.602     0.150
     7.680   198.055     0.150
     7.680   244.453     0.150
     7.680   113.289     0.150
     7.680   150.359     0.150
     7.680   245.055     0.150
     7.680   111.203     0.150
     7.680   112.375     0.150
     7.826   117.547     0.150
     7.865   115.758     0.150
     7.937   116.133     0.150
     8.026   118.336     0.150
     8.026   116.477     0.150
     8.051   119.664     0.150
     8.141   121.883     0.150
     8.108   118.750     0.150
     8.162   123.523     0.150
     8.211   125.047     0.150
     8.369   124.016     0.150
     8.608   128.508     0.150
     8.608   128.906     0.150
     8.608   278.859     0.150
     8.675   127.719     0.150
     8.724   130.164     0.150
     8.741   131.055     0.150
     8.746   130.438     0.150
     8.758   128.914     0.150
     8.775   131.328     0.150
     8.780   131.039     0.150
     8.819   132.117     0.150
     8.766   128.633     0.150
     8.849   131.195     0.150
     8.854   131.680     0.150
     8.862   132.828     0.150
     8.963   132.898     0.150
     9.023   131.508     0.150
     9.024   131.055     0.150
     9.024   230.281     0.150
     9.024   284.031     0.150
     8.970   129.656     0.150
     8.988   132.906     0.150
     9.100   136.734     0.150
     9.107   135.500     0.150
     9.134   135.227     0.150
     9.277   132.562     0.150
     9.260   136.656     0.150
     9.482   141.766     0.150
     9.529   140.359     0.150
     9.607   142.758     0.150
     9.641   142.797     0.150
     9.641   138.836     0.150
     9.667   144.656     0.150
     9.861   148.453     0.150
     9.865   147.719     0.150
    10.012   145.719     0.150
    10.012   143.531     0.150
    10.063   148.625     0.150
    10.063   143.711     0.150
    10.126   150.898     0.150
    10.139   151.180     0.150
    10.181   149.406     0.150
    10.209   150.414     0.150
    10.252   151.148     0.150
    10.290   152.453     0.150
    10.290   149.586     0.150
    10.321   151.133     0.150
    10.353   152.516     0.150
    10.616   155.203     0.150
    10.616   153.555     0.150
    10.635   157.633     0.150
    10.720   158.133     0.150
    10.778   158.523     0.150
    11.066   157.047     0.150
    11.202   162.828     0.150
    11.202   161.461     0.150
    11.175   163.750     0.150
    11.220   164.508     0.150
    11.455   166.398     0.150
    11.455   163.242     0.150
    11.603   167.656     0.150
    11.971   171.547     0.150
    12.012   176.773     0.150
    12.217   175.805     0.150
    12.217   175.516     0.150
    12.177   175.172     0.150
    12.168   179.195     0.150
    12.384   178.328     0.150
    12.384   177.492     0.150
    12.354   179.797     0.150
    12.378   179.656     0.150
    12.398   181.227     0.150
    12.410   181.188     0.150
    12.469   183.609     0.150
    12.547   184.023     0.150
    12.547   179.328     0.150
    12.557   181.945     0.150
    12.666   182.258     0.150
    12.666   179.977     0.150
    12.666   182.758     0.150
    12.666   182.805     0.150
    12.666   396.133     0.150
    12.666   182.148     0.150
    12.816   188.109     0.150
    12.900   182.227     0.150
    12.853   187.531     0.150
    12.898   187.828     0.150
    12.965   188.336     0.150
    12.965   188.203     0.150
    12.959   188.852     0.150
    13.000   187.938     0.150
    12.968   189.539     0.150
    13.110   188.750     0.150
    13.112   189.516     0.150
    13.130   184.484     0.150
    13.172   191.688     0.150
    13.172   422.547     0.150
    13.172   192.328     0.150
    13.244   191.680     0.150
    13.251   192.305     0.150
    13.282   191.367     0.150
    13.329   194.930     0.150
    13.393   193.094     0.150
    13.451   192.125     0.150
    13.451   191.594     0.150
    13.442   193.359     0.150
    13.442   192.102     0.150
    13.406   195.555     0.150
    13.510   195.234     0.150
    13.542   196.234     0.150
    13.727   198.250     0.150
    14.030   201.633     0.150
    13.941   201.688     0.150
    14.105   202.406     0.150
    14.105   201.469     0.150
    14.051   205.758     0.150
    14.051   200.828     0.150
    14.159   202.305     0.150
    14.159   202.008     0.150
    14.194   202.930     0.150
    14.194   202.336     0.150
    14.206   204.695     0.150
    14.244   205.633     0.150
    14.291   204.117     0.150
    14.291   203.758     0.150
    14.253   206.516     0.150
    14.264   208.977     0.150
    14.317   208.750     0.150
    14.303   205.375     0.150
    14.368   209.000     0.150
    14.397   208.078     0.150
    14.367   206.469     0.150
    14.490   209.016     0.150
    14.490   371.477     0.150
    14.799   216.445     0.150
    14.795   212.406     0.150
    14.803   218.867     0.150
    14.860   213.062     0.150
    14.920   215.328     0.150
    14.924   215.906     0.150
    14.982   214.312     0.150
    15.065   215.242     0.150
    15.106   217.336     0.150
    15.106   217.117     0.150
    15.201   218.609     0.150
    15.266   219.586     0.150
    15.266   391.203     0.150
    15.499   222.555     0.150
    15.540   223.273     0.150
    15.545   222.102     0.150
    15.650   225.648     0.150
    15.580   223.125     0.150
    15.639   221.969     0.150
    15.639   221.203     0.150
    15.687   222.219     0.150
    15.603   221.891     0.150
    15.734   224.453     0.150
    15.851   232.359     0.150
    15.802   226.273     0.150
    15.917   228.133     0.150
    15.917   416.453     0.150
    16.105   228.609     0.150
    16.105   227.914     0.150
    16.194   231.164     0.150
    16.227   231.055     0.150
    16.227   230.688     0.150
    16.239   231.500     0.150
    16.328   231.414     0.150
    16.363   232.695     0.150
    16.372   233.133     0.150
    16.372   424.289     0.150
    16.373   232.859     0.150
    16.571   234.609     0.150
    16.571   233.453     0.150
    16.576   233.562     0.150
    16.576   527.656     0.150
    16.576   232.898     0.150
    16.597   236.859     0.150
    16.726   237.078     0.150
    16.726   234.758     0.150
    16.895   238.977     0.150
    17.008   240.383     0.150
    17.056   244.055     0.150
    17.192   240.789     0.150
    17.147   242.703     0.150
    17.171   241.664     0.150
    17.171   240.977     0.150
    17.332   248.953     0.150
    17.332   241.469     0.150
    17.253   243.719     0.150
    17.253   432.930     0.150
    17.294   243.492     0.150
    17.496   249.758     0.150
    17.496   244.281     0.150
    17.440   245.883     0.150
    17.563   246.109     0.150
    17.514   246.758     0.150
    17.636   246.977     0.150
    17.650   246.750     0.150
    17.666   246.008     0.150
    17.597   247.953     0.150
    17.720   249.938     0.150
    17.720   248.781     0.150
    17.704   250.609     0.150
    17.790   247.164     0.150
    17.822   248.516     0.150
    17.860   249.211     0.150
    17.881   250.266     0.150
    17.827   250.664     0.150
    17.953   250.781     0.150
    18.029   250.406     0.150
    18.049   253.727     0.150
    18.049   250.320     0.150
    18.060   250.078     0.150
    18.140   253.430     0.150
    18.140   252.070     0.150
    18.165   254.625     0.150
    18.165   252.750     0.150
    18.118   253.297     0.150
    18.196   252.625     0.150
    18.238   254.773     0.150
    18.238   252.852     0.150
    18.217   253.703     0.150
    18.266   253.836     0.150
    18.224   254.977     0.150
    18.373   255.242     0.150
    18.330   255.156     0.150
    18.440   256.258     0.150
    18.492   255.242     0.150
    18.477   256.180     0.150
    18.486   257.078     0.150
    18.502   255.297     0.150
    18.458   258.594     0.150
    18.442   258.297     0.150
    18.523   256.344     0.150
    18.535   255.898     0.150
    18.578   260.430     0.150
    18.578   258.312     0.150
    18.699   259.055     0.150
    18.750   259.555     0.150
    18.786   261.773     0.150
    18.725   259.336     0.150
    18.803   262.008     0.150
    18.803   259.648     0.150
    18.869   259.148     0.150
    18.882   260.461     0.150
    18.813   263.078     0.150
    18.884   260.953     0.150
    18.884   259.914     0.150
    18.962   260.984     0.150
    18.971   260.867     0.150
    18.960   265.125     0.150
    18.960   260.906     0.150
    18.970   263.500     0.150
    18.970   261.547     0.150
    19.045   262.461     0.150
    19.023   263.727     0.150
    19.023   264.320     0.150
    19.063   266.219     0.150
    19.094   267.375     0.150
    19.088   264.906     0.150
    19.095   264.812     0.150
    19.089   263.773     0.150
    19.166   264.828     0.150
    19.188   265.211     0.150
    19.204   264.711     0.150
    19.237   265.125     0.150
    19.258   265.578     0.150
    19.273   265.148     0.150
    19.292   266.352     0.150
    19.327   267.297     0.150
    19.353   267.383     0.150
    19.303   267.461     0.150
    19.405   267.945     0.150
    19.364   268.398     0.150
    19.364   268.031     0.150
    19.456   269.359     0.150
    19.456   267.180     0.150
    19.469   267.477     0.150
    19.480   267.484     0.150
    19.442   269.453     0.150
    19.526   267.906     0.150
    19.588   269.375     0.150
    19.643   270.508     0.150
    19.666   270.406     0.150
    19.690   270.328     0.150
    19.705   270.305     0.150
    19.763   269.695     0.150
    19.813   271.727     0.150
    19.846   270.992     0.150
    19.894   273.117     0.150
    19.911   272.625     0.150
    19.933   275.906     0.150
    19.933   274.242     0.150
    19.944   273.648     0.150
    19.937   274.453     0.150
    19.979   274.445     0.150
    20.007   275.328     0.150
    20.046   273.172     0.150
    20.047   275.156     0.150
    20.047   273.898     0.150
    20.081   277.656     0.150
    20.081   273.961     0.150
    20.129   275.508     0.150
    20.151   275.688     0.150
    20.155   274.750     0.150
    20.140   277.656     0.150
    20.140   505.625     0.150
    20.140   275.172     0.150
    20.146   277.289     0.150
    20.146   275.836     0.150
    20.168   277.117     0.150
    20.168   275.922     0.150
    20.184   276.977     0.150
    20.184   275.359     0.150
    20.267   276.633     0.150
    20.276   276.711     0.150
    20.265   274.977     0.150
    20.285   277.188     0.150
    20.328   276.469     0.150
    20.339   277.953     0.150
    20.361   276.594     0.150
    20.426   279.336     0.150
    20.423   278.953     0.150
    20.449   278.336     0.150
    20.443   279.172     0.150
    20.466   277.359     0.150
    20.467   279.680     0.150
    20.467   278.594     0.150
    20.519   281.094     0.150
    20.541   277.797     0.150
    20.572   280.258     0.150
    20.569   280.070     0.150
    20.615   279.172     0.150
    20.617   281.125     0.150
    20.627   280.531     0.150
    20.658   283.055     0.150
    20.715   281.328     0.150
    20.773   285.203     0.150
    20.773   282.242     0.150
    20.777   281.883     0.150
    20.777   284.156     0.150
    20.774   283.438     0.150
    20.793   282.656     0.150
    20.784   287.656     0.150
    20.784   282.977     0.150
    20.827   283.742     0.150
    20.913   284.406     0.150
    20.914   284.008     0.150
    20.912   285.461     0.150
    20.868   284.555     0.150
    20.936   284.523     0.150
    20.954   284.422     0.150
    21.018   284.523     0.150
    21.034   288.750     0.150
    21.057   285.203     0.150
    21.057   284.516     0.150
    21.050   285.953     0.150
    21.060   285.156     0.150
    21.065   284.797     0.150
    21.085   289.625     0.150
    21.081   285.523     0.150
    21.080   285.297     0.150
    21.084   286.453     0.150
    21.084   285.688     0.150
    21.156   285.625     0.150
    21.226   286.578     0.150
    21.237   286.086     0.150
    21.267   286.602     0.150
    21.272   288.727     0.150
    21.272   288.172     0.150
    21.275   288.273     0.150
    21.275   289.031     0.150
    21.292   288.031     0.150
    21.306   289.172     0.150
    21.302   287.953     0.150
    21.299   288.781     0.150
    21.399   288.797     0.150
    21.387   290.953     0.150
    21.482   289.547     0.150
    21.538   289.695     0.150
    21.549   291.273     0.150
    21.549   290.445     0.150
    21.570   291.500     0.150
    21.616   291.656     0.150
    21.650   292.773     0.150
    21.656   292.625     0.150
    21.705   292.109     0.150
    21.682   292.328     0.150
    21.740   291.852     0.150
    21.741   293.266     0.150
    21.753   292.570     0.150
    21.773   292.219     0.150
    21.805   292.977     0.150
    21.799   293.016     0.150
    21.870   294.539     0.150
    21.878   294.625     0.150
    21.896   294.391     0.150
    21.901   294.094     0.150
    21.950   295.828     0.150
    21.978   296.953     0.150
    21.969   299.453     0.150
    21.969   295.102     0.150
    21.970   293.352     0.150
    22.045   295.289     0.150
    22.074   296.414     0.150
    22.130   297.758     0.150
    22.105   297.406     0.150
    22.105   296.875     0.150
    22.115   296.164     0.150
    22.138   297.312     0.150
    22.120   296.430     0.150
    22.165   297.438     0.150
    22.186   298.773     0.150
    22.224   298.289     0.150
    22.243   296.062     0.150
    22.242   298.492     0.150
    22.321   299.312     0.150
    22.319   298.562     0.150
    22.337   298.844     0.150
    22.349   303.430     0.150
    22.349   298.773     0.150
    22.341   300.273     0.150
    22.341   298.836     0.150
    22.394   298.531     0.150
    22.428   299.047     0.150
    22.450   300.641     0.150
    22.493   302.594     0.150
    22.494   301.117     0.150
    22.491   300.805     0.150
    22.517   299.875     0.150
    22.560   300.609     0.150
    22.560   300.594     0.150
    22.553   300.836     0.150
    22.561   301.773     0.150
    22.561   300.953     0.150
    22.599   301.312     0.150
    22.587   302.555     0.150
    22.635   302.484     0.150
    22.710   304.234     0.150
    22.730   304.547     0.150
    22.726   302.438     0.150
    22.758   302.547     0.150
    22.814   303.312     0.150
    22.820   303.641     0.150
    22.886   304.648     0.150
    22.874   304.195     0.150
    22.911   305.312     0.150
    22.971   306.344     0.150
    22.964   304.398     0.150
    22.998   306.070     0.150
    23.004   307.703     0.150
    23.004   306.875     0.150
    23.032   307.336     0.150
    23.032   306.586     0.150
    23.071   306.828     0.150
    23.055   306.320     0.150
    23.096   306.117     0.150
    23.109   306.570     0.150
    23.131   307.820     0.150
    23.182   309.477     0.150
    23.182   308.125     0.150
    23.188   309.406     0.150
    23.188   308.078     0.150
    23.219   307.875     0.150
    23.254   308.812     0.150
    23.267   308.469     0.150
    23.250   309.078     0.150
    23.292   309.852     0.150
    23.314   309.930     0.150
    23.314   309.781     0.150
    23.359   309.289     0.150
    23.393   311.203     0.150
    23.420   311.461     0.150
    23.453   312.016     0.150
    23.478   310.094     0.150
    23.516   312.305     0.150
    23.516   310.836     0.150
    23.506   310.844     0.150
    23.531   313.055     0.150
    23.572   311.898     0.150
    23.600   312.352     0.150
    23.612   312.688     0.150
    23.606   312.609     0.150
    23.606   311.602     0.150
    23.683   313.234     0.150
    23.677   313.297     0.150
    23.696   315.430     0.150
    23.686   313.430     0.150
    23.686   312.672     0.150
    23.710   312.680     0.150
    23.720   313.039     0.150
    23.763   314.141     0.150
    23.768   315.227     0.150
    23.768   313.922     0.150
    23.847   315.320     0.150
    23.867   314.570     0.150
    23.859   316.109     0.150
    23.859   314.203     0.150
    23.866   313.820     0.150
    23.890   315.469     0.150
    23.882   313.281     0.150
    23.882   313.828     0.150
    23.929   316.477     0.150
    23.929   315.461     0.150
    23.955   317.453     0.150
    24.014   316.695     0.150
    24.016   317.383     0.150
    24.026   318.344     0.150
    23.970   316.383     0.150
    23.970   316.977     0.150
    24.049   316.977     0.150
    24.053   315.688     0.150
    24.080   317.289     0.150
    24.072   315.672     0.150
    24.066   316.367     0.150
    24.107   317.289     0.150
    24.157   318.312     0.150
    24.181   317.562     0.150
    24.286   319.148     0.150
    24.297   318.883     0.150
    24.359   320.328     0.150
    24.373   320.508     0.150
    24.375   320.883     0.150
    24.415   320.523     0.150
    24.445   321.406     0.150
    24.445   319.992     0.150
    24.458   320.875     0.150
    24.427   320.367     0.150
    24.461   322.055     0.150
    24.461   319.969     0.150
    24.508   324.836     0.150
    24.473   321.070     0.150
    24.534   321.805     0.150
    24.554   321.938     0.150
    24.579   321.398     0.150
    24.589   322.680     0.150
    24.638   320.945     0.150
    24.724   323.734     0.150
    24.722   323.539     0.150
    24.749   322.656     0.150
    24.771   323.531     0.150
    24.813   324.609     0.150
    24.813   323.180     0.150
    24.849   325.609     0.150
    24.849   325.383     0.150
    24.875   325.406     0.150
    24.875   325.664     0.150
    24.897   324.484     0.150
    24.911   324.539     0.150
    24.918   324.328     0.150
    24.923   324.180     0.150
    24.963   326.078     0.150
    24.963   324.703     0.150
    24.993   325.742     0.150
    24.987   325.234     0.150
    25.118   328.648     0.150
    25.192   327.102     0.150
    25.194   327.188     0.150
    25.233   328.445     0.150
    25.245   328.023     0.150
    25.276   330.078     0.150
    25.276   327.703     0.150
    25.296   328.336     0.150
    25.412   330.320     0.150
    25.471   330.508     0.150
    25.471   328.891     0.150
    25.471   331.273     0.150
    25.501   331.430     0.150
    25.552   330.031     0.150
    25.585   331.688     0.150
    25.590   331.734     0.150
    25.576   330.305     0.150
    25.609   330.727     0.150
    25.620   330.203     0.150
    25.649   331.133     0.150
    25.692   332.461     0.150
    25.710   332.633     0.150
    25.696   332.211     0.150
    25.712   332.914     0.150
    25.737   334.383     0.150
    25.737   334.977     0.150
    25.827   331.930     0.150
    25.870   334.070     0.150
    25.891   336.008     0.150
    25.891   334.258     0.150
    25.897   333.734     0.150
    25.893   333.539     0.150
    25.909   333.469     0.150
    25.924   332.664     0.150
    25.973   335.594     0.150
    25.980   335.305     0.150
    25.980   335.070     0.150
    26.043   333.875     0.150
    26.068   334.727     0.150
    26.109   334.445     0.150
    26.134   333.531     0.150
    26.181   335.930     0.150
    26.184   336.930     0.150
    26.221   335.695     0.150
    26.219   336.633     0.150
    26.253   336.820     0.150
    26.405   339.797     0.150
    26.420   338.102     0.150
    26.426   337.156     0.150
    26.459   338.281     0.150
    26.471   337.336     0.150
    26.510   338.703     0.150
    26.560   340.484     0.150
    26.580   338.953     0.150
    26.615   339.812     0.150
    26.720   339.219     0.150
    26.862   342.055     0.150
    26.871   341.547     0.150
    26.902   343.703     0.150
    26.906   344.273     0.150
    26.916   342.797     0.150
    26.916   342.234     0.150
    27.102   343.805     0.150
    27.122   345.023     0.150
    27.303   345.609     0.150
    27.697   349.250     0.150
    27.718   349.711     0.150
    29.290   363.133     0.150
    29.555   368.773     0.150
    29.953   371.430     0.150
    29.953   371.164     0.150
    30.257   373.820     0.150
    30.818   380.156     0.150
    30.818   376.805     0.150
    31.928   386.750     0.150
    32.448   392.469     0.150
    32.452   392.508     0.150
    32.717   395.055     0.150
    33.143   399.477     0.150
    33.866   404.844     0.150
    34.312   410.938     0.150
    37.143   433.828     0.150
    37.326   436.516     0.150
    37.962   440.727     0.150
    38.230   443.398     0.150
    38.414   444.859     0.150
    38.515   445.562     0.150
    38.581   445.812     0.150
    39.395   455.078     0.150
    39.462   452.031     0.150
    39.462   452.375     0.150
    39.608   454.734     0.150
    39.733   455.656     0.150
    39.844   456.555     0.150
    39.860   455.297     0.150
    39.860   456.055     0.150
    39.860   456.477     0.150
    40.067   457.375     0.150
    40.067   819.375     0.150
    40.234   460.500     0.150
    40.508   462.336     0.150
    40.644   463.719     0.150
    40.771   463.359     0.150
    40.784   463.578     0.150
    40.784   834.055     0.150
    40.914   464.797     0.150
    41.211   464.984     0.150
    42.518   478.594     0.150
    42.852   479.594     0.150
    43.292   485.258     0.150
    43.292   483.875     0.150
    45.223   500.703     0.150
    45.248   501.109     0.150
    45.320   500.438     0.150
    45.771   504.430     0.150
    45.771   503.695     0.150
    46.999   513.758     0.150
    50.680   542.328     0.150
    51.867   549.555     0.150
    56.795   585.594     0.150
    56.795   585.453     0.150
    58.883  1091.453     0.150
    59.971   607.625     0.150
    59.971   608.477     0.150
    62.582   624.625     0.150
    63.519  1149.359     0.150
    65.230   643.578     0.150
    66.791   654.867     0.150
    66.706   652.922     0.150
    67.655   658.406     0.150
    68.789   666.180     0.150
    75.921   707.781     0.150
    76.521   709.453     0.150
    76.521   721.656     0.150
    78.328   722.703     0.150
    78.328   722.828     0.150
    78.445   722.484     0.150
    79.136   725.555     0.150
    79.953   730.852     0.150
    80.764   734.953     0.150
    81.333   739.156     0.150
    81.387   738.531     0.150
    81.387   739.359     0.150
    81.545   739.805     0.150
    81.525   741.453     0.150
    81.579   742.258     0.150
    81.791   743.555     0.150
    81.921   742.188     0.150
    81.921   743.758     0.150
    82.210   743.758     0.150
    82.271   744.656     0.150
    82.710   748.859     0.150
    82.734   747.555     0.150
    82.748   745.383     0.150
    82.884   747.547     0.150
    82.884  1366.438     0.150
    83.014   746.734     0.150
    83.189   746.055     0.150
    83.364   749.203     0.150
    84.059   753.078     0.150
    84.322   754.125     0.150
    84.322   753.953     0.150
    84.599   755.805     0.150
    84.623   755.805     0.150
    84.981   759.695     0.150
    84.981   758.156     0.150
    84.980   757.383     0.150
    84.981   760.836     0.150
    86.075   762.156     0.150
    86.075  1400.156     0.150
    86.634   765.055     0.150
    86.799   766.812     0.150
    87.244   769.758     0.150
    87.709  1416.656     0.150
    87.782   771.672     0.150
    87.848   771.406     0.150
    87.871  1417.656     0.150
    87.912  1416.656     0.150
    87.969   771.484     0.150
    88.046   771.742     0.150
    88.094   772.461     0.150
    88.148   772.680     0.150
    88.149   774.227     0.150
    88.177   772.055     0.150
    88.183   772.609     0.150
    88.203  1418.359     0.150
    89.147   777.008     0.150
    89.824   779.875     0.150
    90.109   781.758     0.150
    90.282   782.195     0.150
    90.681   784.055     0.150
    90.982   785.656     0.150
    90.982  1512.359     0.150
    91.438   788.055     0.150
    92.532   794.453     0.150
    92.779   793.359     0.150
    92.904   795.055     0.150
    93.106  1018.953     0.150
    93.106  1429.453     0.150
    93.106  1530.758     0.150
    93.106  1538.656     0.150
    93.106  1833.453     0.150
    93.650   797.758     0.150
    93.664   800.258     0.150
    93.926   800.547     0.150
    93.939   801.117     0.150
    94.264   800.578     0.150
    94.505   803.656     0.150
    95.185   803.953     0.150
    95.446   805.758     0.150
    95.799   806.859     0.150
    96.636   812.359     0.150
    96.665   812.758     0.150
    97.383   814.953     0.150
    97.841   818.156     0.150
    98.301   819.578     0.150
    98.301   819.156     0.150
    98.403   819.578     0.150
    99.033   822.156     0.150
   100.092   829.156     0.150
   101.600   832.703     0.150
   109.120   867.656     0.150
   111.248   878.156     0.150
   111.248  1115.953     0.150
   111.248  1159.156     0.150
   118.132  1129.109     0.150
   119.992  1131.305     0.150
   123.221  1138.547     0.150
   123.714  1139.812     0.150
   125.348  1142.711     0.150
   125.348  1141.547     0.150
   125.348  1143.758     0.150
   144.624  1177.883     0.150
   144.791  1178.133     0.150
     0.512     9.625     0.150
     0.512    16.492     0.150
     0.879    16.742     0.150
     1.036    18.633     0.150
     1.036    31.883     0.150
     1.036    18.492     0.150
     1.037    18.562     0.150
     1.037    31.953     0.150
     1.037    18.406     0.150
     1.037    32.445     0.150
     1.008    18.008     0.150
     1.008    32.945     0.150
     1.256    21.883     0.150
     1.401    23.938     0.150
     1.465    24.633     0.150
     1.465    42.852     0.150
     1.676    27.000     0.150
     1.676    53.008     0.150
     1.946    31.328     0.150
     1.946    55.883     0.150
     1.946    31.633     0.150
     2.097    33.383     0.150
     2.071    33.891     0.150
     2.133    34.398     0.150
     2.517    39.422     0.150
     2.543    41.688     0.150
     2.535    40.094     0.150
     2.585    41.406     0.150
     3.220    49.297     0.150
     3.220    49.609     0.150
     3.251    50.039     0.150
     3.454    54.086     0.150
     3.753    58.266     0.150
     3.926    58.703     0.150
     4.099    61.766     0.150
     4.636    68.031     0.150
     4.850    72.812     0.150
     5.084    77.867     0.150
     5.425    79.516     0.150
     5.507    84.156     0.150
     5.937    86.836     0.150
     6.032    92.023     0.150
     6.631   100.664     0.150
     9.631   137.945     0.150
     1.291    21.551     0.150
     1.291    40.621     0.150
     1.397    23.078     0.150
     1.397    43.020     0.150
     1.393    24.641     0.150
     1.393    43.258     0.150
     1.393    24.438     0.150
     1.395    24.391     0.150
     1.395    24.500     0.150
     1.395    42.949     0.150
     1.591    27.629     0.150
     1.807    30.828     0.150
     1.905    31.488     0.150
     1.905    31.082     0.150
     1.905    57.883     0.150
     2.121    35.770     0.150
     2.258    38.570     0.150
     2.756    43.520     0.150
     2.756    43.891     0.150
     2.876    45.699     0.150
     2.876    90.383     0.150
     2.960    47.641     0.150
     2.960    47.031     0.150
     2.960    81.098     0.150
     2.960    57.281     0.150
     2.971    46.859     0.150
     3.013    47.738     0.150
     3.013    47.168     0.150
     3.013    82.391     0.150
     3.214    50.539     0.150
     3.214    50.180     0.150
     3.229    50.715     0.150
     3.229   100.844     0.150
     3.396    53.059     0.150
     3.396    52.824     0.150
     3.398    52.211     0.150
     3.398    52.840     0.150
     3.398   109.578     0.150
     3.488    53.855     0.150
     3.426    54.418     0.150
     3.621    55.848     0.150
     3.621   100.215     0.150
     3.668    56.711     0.150
     3.712    57.598     0.150
     3.712    58.031     0.150
     3.825    58.938     0.150
     3.828    59.230     0.150
     3.828    72.438     0.150
     3.828   122.730     0.150
     3.828    58.801     0.150
     3.828    58.641     0.150
     3.891    59.680     0.150
     3.925    60.320     0.150
     3.981    61.062     0.150
     4.187    73.867     0.150
     4.187   129.844     0.150
     4.221    64.918     0.150
     4.413    66.996     0.150
     4.609    69.664     0.150
     4.601    70.879     0.150
     4.635    70.355     0.150
     4.720    71.621     0.150
     4.789   157.965     0.150
     4.849    73.418     0.150
     4.910   149.453     0.150
     4.922    93.094     0.150
     5.128    82.918     0.150
     5.162    78.418     0.150
     5.307   101.195     0.150
     5.307   164.059     0.150
     5.405    81.820     0.150
     5.439    82.598     0.150
     5.439    81.547     0.150
     5.596   106.691     0.150
     5.605    85.250     0.150
     5.605    84.555     0.150
     5.789    87.898     0.150
     5.771    87.141     0.150
     5.771    86.410     0.150
     5.771    86.168     0.150
     5.942    90.121     0.150
     5.969    90.371     0.150
     5.969    89.930     0.150
     6.191    93.430     0.150
     6.220    94.230     0.150
     6.364    94.508     0.150
     6.456    97.219     0.150
     6.456    96.938     0.150
     6.660    99.430     0.150
     6.709   101.449     0.150
     6.815   102.160     0.150
     6.815   101.715     0.150
     6.929   103.703     0.150
     7.079   104.930     0.150
     7.073   107.520     0.150
     7.073   223.469     0.150
     7.187   107.910     0.150
     7.204   108.688     0.150
     7.253   108.781     0.150
     7.461   112.961     0.150
     7.555   111.910     0.150
     7.555   109.703     0.150
     7.808   117.168     0.150
     7.860   115.293     0.150
     7.860   245.203     0.150
     7.860   115.719     0.150
     7.860   114.762     0.150
     8.062   120.270     0.150
     8.062   119.043     0.150
     8.119   120.090     0.150
     8.147   121.230     0.150
     8.120   117.930     0.150
     8.120   118.449     0.150
     8.239   122.430     0.150
     8.239   121.113     0.150
     8.270   124.160     0.150
     8.312   125.250     0.150
     8.327   123.840     0.150
     8.361   123.758     0.150
     8.713   130.320     0.150
     8.729   128.531     0.150
     8.775   130.855     0.150
     8.775   279.109     0.150
     8.775   129.238     0.150
     8.851   131.348     0.150
     8.892   131.199     0.150
     8.942   131.121     0.150
     8.959   132.668     0.150
     8.964   131.461     0.150
     8.974   133.219     0.150
     8.986   132.629     0.150
     8.992   132.801     0.150
     8.993   132.309     0.150
     8.995   130.430     0.150
     8.999   132.168     0.150
     9.027   133.738     0.150
     9.036   133.680     0.150
     9.062   134.199     0.150
     9.068   134.160     0.150
     9.072   134.539     0.150
     9.074   134.148     0.150
     9.074   134.160     0.150
     9.075   133.285     0.150
     9.075   285.453     0.150
     9.075   133.738     0.150
     9.190   136.281     0.150
     9.187   135.871     0.150
     9.207   136.750     0.150
     9.202   136.461     0.150
     9.230   136.840     0.150
     9.253   136.918     0.150
     9.272   135.910     0.150
     9.280   137.348     0.150
     9.480   138.469     0.150
     9.484   139.660     0.150
     9.484   138.480     0.150
     9.598   140.719     0.150
     9.700   142.668     0.150
     9.823   143.379     0.150
     9.825   144.559     0.150
     9.856   144.680     0.150
    10.011   145.648     0.150
    10.022   144.770     0.150
    10.214   150.109     0.150
    10.214   148.090     0.150
    10.208   150.090     0.150
    10.280   148.871     0.150
    10.289   149.121     0.150
    10.399   152.840     0.150
    10.399   329.434     0.150
    10.399   151.750     0.150
    10.428   151.789     0.150
    10.470   152.199     0.150
    10.482   152.621     0.150
    10.482   157.281     0.150
    10.567   154.801     0.150
    10.813   158.520     0.150
    10.835   158.840     0.150
    10.835   157.125     0.150
    10.938   160.871     0.150
    11.360   165.840     0.150
    11.356   164.828     0.150
    11.393   167.488     0.150
    11.434   166.609     0.150
    11.667   170.938     0.150
    12.299   177.559     0.150
    12.393   179.469     0.150
    12.500   178.871     0.150
    12.565   183.680     0.150
    12.573   182.168     0.150
    12.592   184.949     0.150
    12.596   184.008     0.150
    12.755   186.008     0.150
    12.886   186.098     0.150
    12.886   184.750     0.150
    12.886   188.359     0.150
    12.886   186.238     0.150
    12.937   185.570     0.150
    12.947   188.188     0.150
    13.099   189.609     0.150
    13.101   188.301     0.150
    13.103   188.762     0.150
    13.218   190.680     0.150
    13.320   194.078     0.150
    13.320   194.738     0.150
    13.331   189.770     0.150
    13.437   190.000     0.150
    13.462   193.461     0.150
    13.561   193.691     0.150
    13.594   195.270     0.150
    13.661   197.258     0.150
    13.728   197.770     0.150
    13.924   200.289     0.150
    14.109   201.598     0.150
    14.114   206.301     0.150
    14.148   206.078     0.150
    14.269   207.758     0.150
    14.211   207.949     0.150
    14.356   208.918     0.150
    14.322   204.500     0.150
    14.462   210.188     0.150
    14.466   210.668     0.150
    14.475   209.508     0.150
    14.482   209.969     0.150
    14.476   206.551     0.150
    14.533   210.531     0.150
    14.567   211.340     0.150
    14.584   211.770     0.150
    14.589   212.000     0.150
    14.615   210.898     0.150
    14.579   207.551     0.150
    14.633   210.180     0.150
    14.685   212.391     0.150
    14.821   212.609     0.150
    14.957   214.461     0.150
    14.983   217.539     0.150
    15.202   218.711     0.150
    15.213   218.891     0.150
    15.388   220.969     0.150
    15.667   224.758     0.150
    15.719   224.379     0.150
    15.699   226.711     0.150
    15.777   224.938     0.150
    15.775   225.051     0.150
    15.765   225.398     0.150
    15.856   225.238     0.150
    15.963   226.949     0.150
    15.988   229.121     0.150
    16.169   231.688     0.150
    16.254   232.348     0.150
    16.311   232.609     0.150
    16.433   234.648     0.150
    16.437   234.418     0.150
    16.437   233.109     0.150
    16.460   234.711     0.150
    16.559   234.801     0.150
    16.563   234.840     0.150
    16.673   240.121     0.150
    16.784   238.141     0.150
    16.859   239.039     0.150
    17.086   242.668     0.150
    17.222   246.598     0.150
    17.310   246.121     0.150
    17.391   244.090     0.150
    17.391   242.484     0.150
    17.488   244.238     0.150
    17.624   248.070     0.150
    17.709   248.488     0.150
    17.765   251.270     0.150
    17.768   248.051     0.150
    17.937   250.898     0.150
    18.027   253.738     0.150
    17.972   253.461     0.150
    18.056   252.418     0.150
    18.283   257.789     0.150
    18.504   258.297     0.150
    18.668   261.688     0.150
    18.646   259.391     0.150
    18.807   263.109     0.150
    18.939   261.688     0.150
    19.016   267.379     0.150
    19.225   266.008     0.150
    19.311   265.938     0.150
    19.439   269.410     0.150
    19.584   270.109     0.150
    19.618   271.070     0.150
    19.618   271.398     0.150
    19.962   274.238     0.150
    20.033   276.059     0.150
    20.198   277.199     0.150
    20.327   278.371     0.150
    20.684   282.449     0.150
    21.034   286.051     0.150
    21.118   287.418     0.150
    21.281   289.289     0.150
    21.392   290.281     0.150
    21.426   292.020     0.150
    21.733   293.070     0.150
    21.770   291.461     0.150
    21.921   296.906     0.150
    22.063   297.578     0.150
    22.236   297.660     0.150
    22.247   299.090     0.150
    22.634   304.508     0.150
    22.671   302.539     0.150
    22.768   303.430     0.150
    22.889   304.328     0.150
    22.989   305.949     0.150
    23.131   307.898     0.150
    23.328   309.539     0.150
    23.404   309.398     0.150
    23.638   313.188     0.150
    23.682   313.918     0.150
    23.776   314.660     0.150
    23.810   314.531     0.150
    23.802   315.398     0.150
    23.835   315.641     0.150
    23.883   315.738     0.150
    23.951   316.641     0.150
    24.048   317.121     0.150
    24.045   317.918     0.150
    24.059   317.371     0.150
    24.046   317.340     0.150
    24.098   317.086     0.150
    24.098   767.285     0.150
    24.087   318.090     0.150
    24.140   318.840     0.150
    24.140   317.840     0.150
    24.170   317.809     0.150
    24.186   317.699     0.150
    24.318   318.570     0.150
    24.323   319.551     0.150
    24.590   322.121     0.150
    24.593   322.711     0.150
    24.634   322.461     0.150
    24.672   323.180     0.150
    24.941   326.020     0.150
    24.978   326.820     0.150
    25.051   326.980     0.150
    25.079   327.230     0.150
    25.075   326.590     0.150
    25.122   327.871     0.150
    25.222   328.109     0.150
    25.252   329.379     0.150
    25.593   330.730     0.150
    25.705   331.289     0.150
    25.721   331.738     0.150
    25.777   332.848     0.150
    25.841   333.629     0.150
    25.872   334.750     0.150
    25.872   334.188     0.150
    26.027   334.641     0.150
    26.057   335.418     0.150
    26.098   335.859     0.150
    26.114   335.969     0.150
    26.120   335.680     0.150
    26.340   337.980     0.150
    26.380   338.168     0.150
    26.480   338.879     0.150
    26.548   338.301     0.150
    26.535   339.480     0.150
    26.513   341.977     0.150
    26.583   340.680     0.150
    26.615   337.988     0.150
    26.646   339.309     0.150
    26.879   343.219     0.150
    27.025   342.598     0.150
    27.020   343.621     0.150
    27.079   343.961     0.150
    27.151   345.801     0.150
    27.292   347.230     0.150
    27.451   348.289     0.150
    27.501   349.000     0.150
    27.563   349.270     0.150
    27.849   352.660     0.150
    27.913   351.340     0.150
    28.556   358.258     0.150
    28.567   357.840     0.150
    28.665   359.109     0.150
    28.794   359.828     0.150
    28.990   361.859     0.150
    29.033   361.680     0.150
    29.361   365.551     0.150
    30.134   373.832     0.150
    30.417   373.539     0.150
    30.916   379.289     0.150
    30.916   379.109     0.150
    32.137   390.160     0.150
    32.137   558.160     0.150
    32.815   395.031     0.150
    33.031   394.359     0.150
    33.320   400.910     0.150
    34.209   409.059     0.150
    34.527   410.168     0.150
    36.399   428.879     0.150
    36.710   430.438     0.150
    37.231   434.188     0.150
    37.321   435.488     0.150
    38.220   445.008     0.150
    38.358   444.250     0.150
    38.373   445.359     0.150
    38.573   445.918     0.150
    38.573   445.738     0.150
    38.669   447.211     0.150
    38.739   448.340     0.150
    39.654   455.508     0.150
    39.654   454.680     0.150
    39.772   456.801     0.150
    39.801   456.609     0.150
    40.009   458.480     0.150
    40.030   458.648     0.150
    40.030   459.008     0.150
    40.030   458.648     0.150
    40.143   459.039     0.150
    40.210   460.969     0.150
    40.236   459.391     0.150
    40.304   460.918     0.150
    40.403   461.359     0.150
    40.471   460.770     0.150
    40.667   463.531     0.150
    40.820   465.320     0.150
    40.948   465.840     0.150
    41.287   469.031     0.150
    41.416   469.234     0.150
    41.441   470.309     0.150
    42.157   475.621     0.150
    42.692   481.059     0.150
    43.019   483.168     0.150
    43.469   487.340     0.150
    45.532   502.141     0.150
    45.769   505.211     0.150
    46.612   511.680     0.150
    47.166   514.781     0.150
    48.997   529.371     0.150
    57.015   588.410     0.150
    59.961   609.219     0.150
    61.915   621.309     0.150
    64.073   637.348     0.150
    64.073   637.168     0.150
    64.996   642.879     0.150
    65.341   644.910     0.150
    65.632   647.199     0.150
    65.853   648.898     0.150
    66.693   654.008     0.150
    66.842   654.676     0.150
    66.842   654.090     0.150
    69.361   668.320     0.150
    76.140   710.484     0.150
    76.140   710.168     0.150
    78.246   722.633     0.150
    78.246   722.270     0.150
    78.664   725.211     0.150
    78.664   725.211     0.150
    79.335   728.160     0.150
    81.404   740.309     0.150
    81.404   739.840     0.150
    81.512   741.297     0.150
    82.968   748.086     0.150
    82.968   745.898     0.150
    84.434   755.422     0.150
    84.434   755.238     0.150
    85.062   758.309     0.150
    85.061   758.324     0.150
    92.998   795.445     0.150
    92.998   795.121     0.150
    94.098   802.820     0.150
    94.457   803.180     0.150
    97.521   815.711     0.150
   100.196   826.508     0.150
   116.530  1126.074     0.150
   116.530  1125.809     0.150
   118.036  1129.609     0.150
   118.036  1129.211     0.150
   119.883  1132.758     0.150
   119.883  1132.230     0.150
   121.991  1137.148     0.150
   121.991  1138.410     0.150
   121.991  1137.289     0.150
   123.053  1136.598     0.150
   123.814  1139.375     0.150
   125.178  1142.020     0.150
   144.665  1177.559     0.150
   144.665  1177.930     0.150
     1.441    26.252     0.150
     1.414    22.823     0.150
     1.376    24.012     0.150
     1.378    24.012     0.150
     1.378    40.262     0.150
     1.545    27.012     0.150
     1.987    32.142     0.150
     1.987    36.792     0.150
     1.987    61.306     0.150
     2.290    36.662     0.150
     2.310    36.682     0.150
     2.803    44.032     0.150
     2.803    43.567     0.150
     2.803    50.833     0.150
     2.892    46.914     0.150
     2.960    47.272     0.150
     2.960    80.333     0.150
     2.998    47.576     0.150
     3.038    47.932     0.150
     3.038    47.752     0.150
     3.038    83.032     0.150
     3.038    90.132     0.150
     3.038    49.172     0.150
     3.038    88.442     0.150
     3.221    50.892     0.150
     3.244    51.475     0.150
     3.244   103.152     0.150
     3.451    54.742     0.150
     3.451    90.252     0.150
     3.451    53.533     0.150
     3.479    53.432     0.150
     3.479    52.812     0.150
     3.479    52.534     0.150
     3.527    54.917     0.150
     3.400    57.032     0.150
     3.625    55.702     0.150
     3.625    57.250     0.150
     3.625   114.155     0.150
     3.849    59.333     0.150
     3.851    59.228     0.150
     3.851   124.502     0.150
     3.851    60.162     0.150
     3.938    60.213     0.150
     3.985    61.208     0.150
     4.015    63.377     0.150
     3.942    60.372     0.150
     4.291    65.593     0.150
     4.469    69.112     0.150
     4.652    71.421     0.150
     4.681    72.182     0.150
     4.783    73.142     0.150
     4.787    73.170     0.150
     4.787   150.276     0.150
     4.884    77.146     0.150
     4.938    76.887     0.150
     4.938   153.985     0.150
     5.139    78.532     0.150
     5.171    79.722     0.150
     5.315   165.618     0.150
     5.472    83.132     0.150
     5.472    83.614     0.150
     5.488    83.032     0.150
     5.614   174.933     0.150
     5.683    85.932     0.150
     5.655   176.501     0.150
     5.798    87.762     0.150
     5.798   179.683     0.150
     5.865    90.002     0.150
     5.846    87.122     0.150
     5.846    87.365     0.150
     5.967    92.698     0.150
     6.052    90.762     0.150
     6.052    91.124     0.150
     6.244    93.562     0.150
     6.292    94.583     0.150
     6.395    97.688     0.150
     6.476    97.132     0.150
     6.476    98.223     0.150
     6.633   100.315     0.150
     6.727   100.562     0.150
     6.778   101.732     0.150
     6.860   102.432     0.150
     6.860   103.980     0.150
     6.917   108.002     0.150
     7.160   105.892     0.150
     7.160   106.082     0.150
     7.201   110.228     0.150
     7.252   107.642     0.150
     7.275   109.382     0.150
     7.047   108.715     0.150
     7.320   109.472     0.150
     7.469   108.062     0.150
     7.623   112.008     0.150
     7.623   246.480     0.150
     7.879   118.103     0.150
     7.942   115.827     0.150
     7.942   202.728     0.150
     7.942   248.603     0.150
     7.942   116.732     0.150
     7.942   116.372     0.150
     7.942   116.110     0.150
     8.114   119.882     0.150
     8.127   119.412     0.150
     8.210   121.662     0.150
     8.148   118.912     0.150
     8.320   123.648     0.150
     8.340   124.872     0.150
     8.396   124.333     0.150
     8.388   127.452     0.150
     8.792   132.593     0.150
     8.810   132.062     0.150
     8.810   279.282     0.150
     8.810   134.232     0.150
     8.925   132.312     0.150
     8.882   130.632     0.150
     8.973   132.952     0.150
     9.044   133.612     0.150
     9.055   133.843     0.150
     9.066   134.252     0.150
     9.062   132.042     0.150
     9.142   135.262     0.150
     9.126   131.343     0.150
     9.127   132.751     0.150
     9.127   233.557     0.150
     9.127   286.458     0.150
     9.127   133.132     0.150
     9.567   141.882     0.150
     9.923   148.271     0.150
    10.297   154.458     0.150
    10.284   151.652     0.150
    10.284   153.406     0.150
    10.455   151.094     0.150
    10.455   153.333     0.150
    10.564   157.626     0.150
    10.616   156.372     0.150
    10.914   159.882     0.150
    11.433   168.432     0.150
    12.359   174.932     0.150
    12.359   181.917     0.150
    12.828   188.132     0.150
    12.960   188.552     0.150
    12.960   188.452     0.150
    12.960   187.199     0.150
    12.960   402.107     0.150
    12.768   183.552     0.150
    13.155   192.232     0.150
    13.288   194.172     0.150
    13.346   194.301     0.150
    13.346   407.260     0.150
    13.401   195.692     0.150
    13.740   198.632     0.150
    13.798   200.892     0.150
    14.145   208.382     0.150
    14.339   208.853     0.150
    14.339   209.271     0.150
    14.255   207.982     0.150
    14.255   209.017     0.150
    14.265   210.482     0.150
    14.400   210.190     0.150
    14.447   210.151     0.150
    14.513   213.782     0.150
    14.533   211.932     0.150
    14.541   216.924     0.150
    14.558   209.315     0.150
    14.602   204.162     0.150
    14.637   213.262     0.150
    14.644   215.612     0.150
    14.649   209.603     0.150
    14.737   214.032     0.150
    14.896   218.152     0.150
    14.897   220.612     0.150
    14.991   219.221     0.150
    15.078   219.242     0.150
    15.064   210.532     0.150
    15.129   222.167     0.150
    15.274   220.103     0.150
    15.251   225.295     0.150
    15.435   224.762     0.150
    15.545   224.792     0.150
    15.761   219.692     0.150
    15.830   227.752     0.150
    15.765   220.802     0.150
    15.936   227.993     0.150
    15.995   234.333     0.150
    16.330   233.841     0.150
    16.483   236.593     0.150
    16.498   236.021     0.150
    16.527   237.589     0.150
    16.580   238.093     0.150
    16.611   230.182     0.150
    16.739   240.682     0.150
    16.836   238.204     0.150
    16.897   233.992     0.150
    17.005   239.462     0.150
    17.005   242.023     0.150
    17.070   438.432     0.150
    17.135   244.282     0.150
    17.393   240.472     0.150
    17.467   241.162     0.150
    17.467   246.757     0.150
    17.472   243.932     0.150
    17.506   249.354     0.150
    17.565   242.853     0.150
    17.761   246.823     0.150
    17.801   245.142     0.150
    17.775   250.878     0.150
    17.841   252.316     0.150
    17.923   251.343     0.150
    17.875   250.093     0.150
    18.007   254.632     0.150
    18.081   253.677     0.150
    18.081   569.523     0.150
    18.081   254.232     0.150
    18.034   254.052     0.150
    18.127   252.652     0.150
    18.311   251.112     0.150
    18.353   255.642     0.150
    18.353   257.158     0.150
    18.509   257.722     0.150
    18.509   260.433     0.150
    18.648   261.552     0.150
    18.729   258.812     0.150
    18.747   259.732     0.150
    18.747   262.164     0.150
    18.880   263.323     0.150
    18.948   266.877     0.150
    19.041   267.612     0.150
    18.998   264.132     0.150
    19.021   264.382     0.150
    19.225   266.853     0.150
    19.231   264.022     0.150
    19.308   267.888     0.150
    19.389   269.002     0.150
    19.507   270.912     0.150
    19.661   272.702     0.150
    19.658   274.083     0.150
    19.697   272.002     0.150
    19.905   273.752     0.150
    20.047   276.073     0.150
    20.098   278.872     0.150
    20.275   278.182     0.150
    20.415   279.062     0.150
    20.405   280.135     0.150
    20.649   282.722     0.150
    20.765   281.912     0.150
    20.765   284.580     0.150
    20.743   283.192     0.150
    20.930   283.402     0.150
    21.056   287.002     0.150
    21.101   284.333     0.150
    21.105   287.672     0.150
    21.256   289.492     0.150
    21.257   290.833     0.150
    21.257   290.225     0.150
    21.325   289.932     0.150
    21.318   287.412     0.150
    21.376   289.302     0.150
    21.364   289.702     0.150
    21.372   290.062     0.150
    21.466   291.672     0.150
    21.487   290.522     0.150
    21.499   292.103     0.150
    21.486   292.772     0.150
    21.532   291.632     0.150
    21.560   290.762     0.150
    21.650   292.882     0.150
    21.815   294.402     0.150
    21.847   294.083     0.150
    21.881   294.912     0.150
    21.909   294.482     0.150
    21.935   297.177     0.150
    22.143   298.382     0.150
    22.314   301.482     0.150
    22.316   301.052     0.150
    22.389   300.932     0.150
    22.389   300.812     0.150
    22.390   301.282     0.150
    22.594   303.882     0.150
    22.594   302.753     0.150
    22.753   304.302     0.150
    22.753   304.193     0.150
    22.708   300.132     0.150
    22.708   305.539     0.150
    22.830   305.333     0.150
    22.830   305.124     0.150
    22.849   305.432     0.150
    22.968   307.353     0.150
    23.032   307.603     0.150
    23.069   307.272     0.150
    23.134   307.853     0.150
    23.203   310.452     0.150
    23.216   311.182     0.150
    23.216   311.458     0.150
    23.260   310.172     0.150
    23.404   313.103     0.150
    23.478   313.452     0.150
    23.708   316.202     0.150
    23.762   313.442     0.150
    23.855   314.833     0.150
    23.892   314.823     0.150
    23.869   317.103     0.150
    23.909   317.542     0.150
    23.966   316.232     0.150
    24.130   316.542     0.150
    24.138   315.343     0.150
    24.138   318.407     0.150
    24.179   317.208     0.150
    24.176   319.958     0.150
    24.115   318.752     0.150
    24.115   318.648     0.150
    24.160   319.652     0.150
    24.247   320.492     0.150
    24.265   318.932     0.150
    24.398   320.862     0.150
    24.390   320.042     0.150
    24.431   320.542     0.150
    24.479   320.152     0.150
    24.666   323.272     0.150
    24.666   324.999     0.150
    24.716   324.510     0.150
    24.666   323.682     0.150
    24.741   324.732     0.150
    24.815   324.610     0.150
    25.029   326.382     0.150
    25.012   326.882     0.150
    25.012   329.101     0.150
    25.128   326.103     0.150
    25.128   328.107     0.150
    25.158   328.313     0.150
    25.143   328.302     0.150
    25.203   328.553     0.150
    25.207   329.247     0.150
    25.302   329.353     0.150
    25.325   330.812     0.150
    25.472   328.712     0.150
    25.469   331.639     0.150
    25.487   331.417     0.150
    25.377   329.672     0.150
    25.486   332.083     0.150
    25.541   331.053     0.150
    25.626   330.073     0.150
    25.637   333.851     0.150
    25.611   332.762     0.150
    25.663   331.093     0.150
    25.663   334.133     0.150
    25.710   334.215     0.150
    25.781   332.792     0.150
    25.785   332.183     0.150
    25.782   332.192     0.150
    25.782   333.370     0.150
    25.794   332.353     0.150
    25.860   333.932     0.150
    25.915   334.132     0.150
    25.955   332.742     0.150
    25.967   335.618     0.150
    25.945   335.377     0.150
    25.945   332.432     0.150
    26.100   336.546     0.150
    26.101   336.632     0.150
    26.136   337.353     0.150
    26.136   336.840     0.150
    26.168   333.932     0.150
    26.168   337.399     0.150
    26.189   336.422     0.150
    26.189   339.101     0.150
    26.186   336.132     0.150
    26.186   341.522     0.150
    26.281   334.502     0.150
    26.267   336.632     0.150
    26.323   338.747     0.150
    26.363   339.416     0.150
    26.420   339.233     0.150
    26.420   339.447     0.150
    26.447   339.630     0.150
    26.463   338.882     0.150
    26.507   340.182     0.150
    26.505   340.833     0.150
    26.630   338.902     0.150
    26.630   341.335     0.150
    26.608   341.812     0.150
    26.663   341.616     0.150
    26.661   338.662     0.150
    26.661   341.693     0.150
    26.531   341.382     0.150
    26.690   339.902     0.150
    26.710   341.388     0.150
    26.728   341.782     0.150
    26.728   341.589     0.150
    26.728   343.702     0.150
    26.957   344.232     0.150
    27.029   345.379     0.150
    27.082   345.422     0.150
    27.061   346.335     0.150
    27.107   346.052     0.150
    27.107   345.714     0.150
    27.087   345.042     0.150
    27.148   345.949     0.150
    27.158   346.333     0.150
    27.158   346.156     0.150
    27.158   346.562     0.150
    27.234   346.532     0.150
    27.234   346.235     0.150
    27.221   348.333     0.150
    27.326   348.584     0.150
    27.372   348.225     0.150
    27.367   346.612     0.150
    27.424   348.595     0.150
    27.481   349.897     0.150
    27.496   350.073     0.150
    27.523   347.952     0.150
    27.576   349.728     0.150
    27.640   347.912     0.150
    27.640   351.306     0.150
    27.699   351.030     0.150
    27.690   350.805     0.150
    27.673   350.578     0.150
    27.834   352.254     0.150
    27.809   352.193     0.150
    27.957   352.497     0.150
    27.921   354.103     0.150
    27.921   353.455     0.150
    27.985   354.069     0.150
    27.998   353.902     0.150
    27.998   353.636     0.150
    27.984   352.432     0.150
    28.027   351.882     0.150
    28.039   354.847     0.150
    28.033   352.312     0.150
    28.033   354.503     0.150
    28.083   353.222     0.150
    28.132   351.792     0.150
    28.170   355.888     0.150
    28.197   355.369     0.150
    28.229   351.462     0.150
    28.229   355.549     0.150
    28.233   352.292     0.150
    28.233   355.521     0.150
    28.243   356.209     0.150
    28.276   358.068     0.150
    28.374   357.835     0.150
    28.444   357.620     0.150
    28.492   358.115     0.150
    28.519   357.763     0.150
    28.483   358.257     0.150
    28.590   358.782     0.150
    28.636   359.583     0.150
    28.636   359.158     0.150
    28.639   359.652     0.150
    28.720   359.995     0.150
    28.711   358.472     0.150
    28.741   357.232     0.150
    28.741   361.082     0.150
    28.819   360.794     0.150
    28.873   358.372     0.150
    28.873   361.010     0.150
    28.947   361.844     0.150
    29.020   359.252     0.150
    29.020   363.299     0.150
    29.033   359.932     0.150
    29.067   361.823     0.150
    29.067   364.635     0.150
    29.116   363.472     0.150
    29.111   359.502     0.150
    29.111   363.677     0.150
    29.169   363.692     0.150
    29.173   365.344     0.150
    29.226   366.267     0.150
    29.360   364.600     0.150
    29.318   364.302     0.150
    29.386   366.218     0.150
    29.434   366.383     0.150
    29.433   366.414     0.150
    29.439   363.603     0.150
    29.439   366.034     0.150
    29.539   367.699     0.150
    29.527   367.860     0.150
    29.534   367.353     0.150
    29.534   367.241     0.150
    29.572   365.231     0.150
    29.639   367.093     0.150
    29.758   365.292     0.150
    29.758   369.848     0.150
    29.870   372.952     0.150
    30.029   370.846     0.150
    30.177   374.407     0.150
    30.191   373.475     0.150
    30.205   373.039     0.150
    30.254   374.819     0.150
    30.272   374.797     0.150
    30.319   375.899     0.150
    30.451   376.366     0.150
    30.450   376.235     0.150
    30.496   377.052     0.150
    30.496   375.798     0.150
    30.532   375.902     0.150
    30.793   378.125     0.150
    30.817   379.426     0.150
    30.824   377.333     0.150
    30.824   378.414     0.150
    30.966   380.402     0.150
    30.966   379.846     0.150
    30.980   378.532     0.150
    30.980   380.421     0.150
    30.998   379.833     0.150
    30.998   380.132     0.150
    31.028   381.162     0.150
    31.059   376.382     0.150
    31.059   381.205     0.150
    31.169   380.631     0.150
    31.275   381.716     0.150
    31.288   379.758     0.150
    31.331   383.392     0.150
    31.448   384.306     0.150
    31.550   384.370     0.150
    31.536   382.762     0.150
    31.536   385.694     0.150
    31.565   383.552     0.150
    31.565   385.062     0.150
    31.639   385.853     0.150
    31.678   385.282     0.150
    31.727   386.545     0.150
    31.721   383.942     0.150
    31.727   387.397     0.150
    31.760   386.468     0.150
    31.870   388.191     0.150
    31.885   387.583     0.150
    31.892   388.922     0.150
    32.034   389.451     0.150
    32.066   389.130     0.150
    32.052   389.139     0.150
    32.198   391.107     0.150
    32.229   392.250     0.150
    32.253   389.323     0.150
    32.253   391.187     0.150
    32.290   389.333     0.150
    32.296   391.524     0.150
    32.399   393.617     0.150
    32.445   393.365     0.150
    32.629   394.432     0.150
    32.689   395.249     0.150
    32.700   395.823     0.150
    32.777   396.093     0.150
    32.783   396.545     0.150
    32.895   398.302     0.150
    32.895   397.039     0.150
    32.903   397.184     0.150
    32.948   396.892     0.150
    32.956   394.882     0.150
    33.018   398.496     0.150
    33.036   395.922     0.150
    33.036   398.008     0.150
    33.177   399.716     0.150
    33.189   399.353     0.150
    33.235   400.795     0.150
    33.331   400.001     0.150
    33.392   402.760     0.150
    33.534   403.534     0.150
    33.528   403.214     0.150
    33.573   402.054     0.150
    33.595   402.802     0.150
    33.678   404.177     0.150
    33.727   403.119     0.150
    33.976   406.168     0.150
    33.971   407.107     0.150
    34.071   406.719     0.150
    34.101   403.833     0.150
    34.247   407.353     0.150
    34.240   409.606     0.150
    34.485   408.292     0.150
    34.474   408.612     0.150
    34.481   411.030     0.150
    34.552   411.417     0.150
    34.598   412.563     0.150
    34.756   414.174     0.150
    34.804   414.337     0.150
    34.905   414.832     0.150
    35.120   416.187     0.150
    35.192   417.844     0.150
    35.382   417.607     0.150
    35.440   420.459     0.150
    35.564   421.752     0.150
    35.742   418.142     0.150
    35.785   422.301     0.150
    35.806   421.788     0.150
    35.921   421.442     0.150
    35.955   421.142     0.150
    35.939   423.412     0.150
    35.939   422.771     0.150
    36.434   429.652     0.150
    36.744   432.252     0.150
    37.362   435.252     0.150
    37.629   437.627     0.150
    38.252   441.532     0.150
    38.368   442.932     0.150
    38.372   444.796     0.150
    38.398   444.902     0.150
    38.404   444.032     0.150
    38.610   444.612     0.150
    38.605   443.802     0.150
    38.619   447.086     0.150
    38.705   447.752     0.150
    38.700   446.112     0.150
    38.697   447.541     0.150
    38.770   447.432     0.150
    38.802   447.812     0.150
    39.081   451.272     0.150
    39.103   451.014     0.150
    39.499   454.202     0.150
    39.499   453.400     0.150
    39.703   454.382     0.150
    39.703   455.732     0.150
    39.806   457.333     0.150
    39.838   457.122     0.150
    40.043   459.232     0.150
    40.067   458.502     0.150
    40.067   456.708     0.150
    40.181   460.492     0.150
    40.246   461.052     0.150
    40.272   460.353     0.150
    40.337   461.232     0.150
    40.440   462.032     0.150
    40.443   464.340     0.150
    40.474   462.082     0.150
    40.698   464.432     0.150
    40.861   465.992     0.150
    40.981   466.172     0.150
    41.089   466.362     0.150
    41.329   467.732     0.150
    41.477   469.062     0.150
    41.498   468.532     0.150
    42.504   479.862     0.150
    42.730   480.422     0.150
    42.921   483.412     0.150
    43.055   481.642     0.150
    43.416   483.912     0.150
    43.283   484.302     0.150
    43.510   486.562     0.150
    43.510   486.869     0.150
    43.456   486.962     0.150
    44.183   491.392     0.150
    44.357   496.722     0.150
    44.400   494.942     0.150
    45.006   501.152     0.150
    45.074   498.252     0.150
    45.061   499.382     0.150
    45.215   502.757     0.150
    45.238   502.932     0.150
    45.267   503.812     0.150
    45.487   501.432     0.150
    45.558   503.812     0.150
    45.558   500.312     0.150
    45.766   503.862     0.150
    45.803   505.228     0.150
    45.803   504.002     0.150
    46.280   915.232     0.150
    46.640   511.732     0.150
    47.201   514.402     0.150
    48.371   522.932     0.150
    49.022   530.452     0.150
    52.165   552.732     0.150
    52.165   553.152     0.150
    57.092   588.732     0.150
    58.339   727.933     0.150
    58.339  1081.833     0.150
    58.339  1306.232     0.150
    61.302   618.532     0.150
    61.988   621.333     0.150
    62.489   626.072     0.150
    64.076   639.458     0.150
    64.076   636.632     0.150
    64.669   640.522     0.150
    65.021   642.907     0.150
    65.630   644.632     0.150
    65.852   651.703     0.150
    66.863   655.452     0.150
    66.863   656.433     0.150
    66.863   657.052     0.150
    67.943   663.333     0.150
    67.908   660.373     0.150
    68.216   663.232     0.150
    68.323   663.672     0.150
    69.403   669.833     0.150
    69.730   673.893     0.150
    74.767   704.532     0.150
    76.213   710.907     0.150
    76.213   710.732     0.150
    76.633   709.433     0.150
    78.250   722.208     0.150
    78.285   724.933     0.150
    78.743   725.202     0.150
    79.119   724.532     0.150
    79.344   729.433     0.150
    79.344   726.272     0.150
    79.388   728.007     0.150
    79.388   729.433     0.150
    79.702   733.933     0.150
    81.527   741.333     0.150
    81.381   740.933     0.150
    81.608   742.632     0.150
    81.771   744.732     0.150
    81.800   742.933     0.150
    82.063   745.232     0.150
    82.195   745.933     0.150
    82.481   746.933     0.150
    82.545   747.232     0.150
    82.801   749.032     0.150
    82.826   748.732     0.150
    82.978   750.132     0.150
    83.044   747.853     0.150
    83.044   748.132     0.150
    83.133   751.833     0.150
    83.153   750.393     0.150
    83.153   750.833     0.150
    83.157   750.402     0.150
    83.157   751.032     0.150
    83.258   750.703     0.150
    83.286   751.433     0.150
    83.307   751.732     0.150
    83.323   749.132     0.150
    83.343   751.307     0.150
    83.351   751.307     0.150
    83.361   748.522     0.150
    83.361     2.640     0.150
    83.377   749.322     0.150
    83.387   749.732     0.150
    83.387   752.232     0.150
    83.463   752.473     0.150
    83.658   753.312     0.150
    83.672   753.933     0.150
    83.701   752.931     0.150
    83.726   754.032     0.150
    83.767   753.796     0.150
    84.213   755.980     0.150
    84.264   756.345     0.150
    84.443   754.933     0.150
    84.443   753.132     0.150
    84.706   759.132     0.150
    84.768   758.831     0.150
    84.837   759.538     0.150
    84.862   760.050     0.150
    84.875   757.054     0.150
    85.076   760.508     0.150
    85.057   758.750     0.150
    85.384   762.052     0.150
    85.720   763.333     0.150
    85.906   764.793     0.150
    86.372   765.732     0.150
    86.372   766.402     0.150
    86.647   764.333     0.150
    86.734   769.155     0.150
    86.757   768.349     0.150
    86.805   767.632     0.150
    86.903   769.833     0.150
    87.788   772.572     0.150
    88.006   773.032     0.150
    88.076   774.283     0.150
    88.091   771.262     0.150
    88.168   774.333     0.150
    88.267   771.333     0.150
    88.341   774.692     0.150
    88.334   778.032     0.150
    88.388   775.077     0.150
    88.472   774.232     0.150
    88.479   776.213     0.150
    88.574   775.489     0.150
    88.653   777.147     0.150
    88.901   775.933     0.150
    89.442   780.250     0.150
    89.459   780.187     0.150
    89.526   782.532     0.150
    89.596   780.745     0.150
    89.596   781.210     0.150
    90.026   781.382     0.150
    90.120   783.212     0.150
    90.364   785.433     0.150
    90.405   784.032     0.150
    90.475   784.697     0.150
    90.676   785.361     0.150
    90.959   782.532     0.150
    90.978   787.632     0.150
    91.118   783.833     0.150
    91.277   788.933     0.150
    91.277  1004.833     0.150
    91.277  1424.333     0.150
    91.735   791.433     0.150
    91.880   792.702     0.150
    91.880   792.132     0.150
    91.880  1423.732     0.150
    91.880  1452.833     0.150
    91.880   789.542     0.150
    91.956   787.302     0.150
    92.052   790.522     0.150
    92.283   792.532     0.150
    92.283   796.933     0.150
    93.076   795.607     0.150
    93.076   793.833     0.150
    93.097   798.333     0.150
    93.105   799.032     0.150
    93.385   798.833     0.150
    93.385  1020.833     0.150
    93.385  1432.333     0.150
    93.385  1839.833     0.150
    93.564   795.022     0.150
    93.852   803.232     0.150
    93.852   798.703     0.150
    94.249   802.132     0.150
    94.506   801.683     0.150
    94.506   804.032     0.150
    94.506   802.402     0.150
    95.511   808.208     0.150
    95.511   806.362     0.150
    95.286   808.333     0.150
    96.289   809.032     0.150
    96.900   816.333     0.150
    96.900   816.453     0.150
    97.542   817.632     0.150
    98.074   822.032     0.150
    98.551   823.232     0.150
   100.202   829.732     0.150
   103.581   847.232     0.150
   104.151  1104.933     0.150
   109.276   869.132     0.150
   111.381  1119.032     0.150
   111.381  1162.032     0.150
   114.538  2128.532     0.150
   115.228  1125.132     0.150
   115.228  1183.833     0.150
   115.228  2141.833     0.150
   117.972  1130.417     0.150
   117.972  1130.232     0.150
   119.816  1132.914     0.150
   119.816  1132.433     0.150
   122.006  1137.792     0.150
   142.628  1174.320     0.150
   144.713  1177.833     0.150
     1.186    20.734     0.150
     1.186    20.996     0.150
     1.186    20.844     0.150
     1.188    21.695     0.150
     1.188    35.234     0.150
     1.188    38.066     0.150
     1.207    21.395     0.150
     1.278    21.676     0.150
     1.278    21.266     0.150
     1.278    39.934     0.150
     1.403    25.195     0.150
     1.403    43.684     0.150
     1.403    45.453     0.150
     1.953    33.543     0.150
     1.925    31.781     0.150
     2.088    33.246     0.150
     2.088    33.453     0.150
     2.105    33.824     0.150
     2.134    34.516     0.150
     2.324    37.094     0.150
     2.488    40.715     0.150
     2.631    41.043     0.150
     2.614    41.070     0.150
     2.614    41.484     0.150
     2.685    41.539     0.150
     2.793    42.668     0.150
     2.844    45.273     0.150
     2.844    77.004     0.150
     2.897    45.645     0.150
     3.015    47.555     0.150
     3.037    47.234     0.150
     3.219    50.086     0.150
     3.219    87.926     0.150
     3.330    51.340     0.150
     3.420    52.730     0.150
     3.420    53.164     0.150
     3.485    52.230     0.150
     3.485    53.465     0.150
     3.605    55.977     0.150
     3.605    97.395     0.150
     3.645    55.977     0.150
     3.645   116.602     0.150
     3.645    54.875     0.150
     3.645    56.754     0.150
     3.748    57.117     0.150
     3.813    58.508     0.150
     3.916    59.836     0.150
     3.916   104.883     0.150
     3.993    60.656     0.150
     4.061    61.934     0.150
     4.061   107.246     0.150
     4.291    65.031     0.150
     4.399    67.297     0.150
     4.428    67.980     0.150
     4.458    67.508     0.150
     4.585    70.391     0.150
     4.594    70.215     0.150
     4.683    71.434     0.150
     4.708    71.129     0.150
     4.731    70.973     0.150
     4.932    77.355     0.150
     4.965    76.266     0.150
     4.959    74.098     0.150
     5.109    76.516     0.150
     5.142    76.789     0.150
     5.270    79.762     0.150
     5.270    80.695     0.150
     5.407    82.336     0.150
     5.423    81.844     0.150
     5.423   142.055     0.150
     5.592    83.359     0.150
     5.579    83.918     0.150
     5.579    84.324     0.150
     5.668    84.695     0.150
     5.762    86.980     0.150
     5.893    87.758     0.150
     5.893    88.203     0.150
     6.029    92.664     0.150
     5.992    89.758     0.150
     5.992    90.715     0.150
     6.076    92.941     0.150
     6.062    91.434     0.150
     6.191    93.348     0.150
     6.269    93.934     0.150
     6.361    94.688     0.150
     6.428    96.215     0.150
     6.574    98.516     0.150
     6.632    99.504     0.150
     6.667    99.953     0.150
     6.667   100.074     0.150
     6.710   100.266     0.150
     6.753   100.656     0.150
     6.825   102.043     0.150
     6.945   103.953     0.150
     7.001   104.148     0.150
     7.136   107.836     0.150
     7.168   107.555     0.150
     7.171   106.629     0.150
     7.263   108.184     0.150
     7.349   109.234     0.150
     7.706   113.730     0.150
     7.706   113.074     0.150
     7.739   116.445     0.150
     7.921   117.035     0.150
     7.931   117.363     0.150
     7.938   115.395     0.150
     7.938   116.477     0.150
     8.085   119.789     0.150
     8.184   122.633     0.150
     8.198   121.496     0.150
     8.250   123.926     0.150
     8.247   122.219     0.150
     8.273   121.754     0.150
     8.609   127.836     0.150
     8.609   276.305     0.150
     8.609   127.285     0.150
     8.676   126.965     0.150
     8.632   126.215     0.150
     8.699   130.773     0.150
     8.795   131.324     0.150
     8.883   131.406     0.150
     8.920   131.195     0.150
     8.945   132.035     0.150
     8.968   132.574     0.150
     8.978   133.004     0.150
     8.980   131.574     0.150
     8.980   132.934     0.150
     8.983   133.074     0.150
     9.191   135.285     0.150
     9.217   136.555     0.150
     9.259   134.906     0.150
     9.259   134.906     0.150
     9.260   134.156     0.150
     9.260   237.480     0.150
     9.260   295.832     0.150
     9.260   134.863     0.150
     9.427   139.055     0.150
     9.509   137.211     0.150
     9.769   144.207     0.150
     9.769   145.496     0.150
    10.278   150.977     0.150
    10.254   150.852     0.150
    10.254   151.477     0.150
    10.330   151.113     0.150
    10.359   153.453     0.150
    10.542   155.648     0.150
    10.813   157.004     0.150
    11.300   163.422     0.150
    11.319   167.023     0.150
    11.468   166.184     0.150
    11.468   167.555     0.150
    11.566   167.562     0.150
    11.679   168.691     0.150
    11.919   172.457     0.150
    12.390   178.547     0.150
    12.517   181.625     0.150
    12.468   181.289     0.150
    12.646   182.570     0.150
    12.834   184.824     0.150
    12.794   184.273     0.150
    12.830   184.230     0.150
    12.831   186.098     0.150
    12.831   401.156     0.150
    12.831   185.496     0.150
    12.922   188.309     0.150
    12.962   190.805     0.150
    13.064   189.266     0.150
    13.140   191.301     0.150
    13.140   404.293     0.150
    13.134   191.379     0.150
    13.385   194.031     0.150
    13.717   197.574     0.150
    13.870   199.246     0.150
    13.944   201.297     0.150
    14.197   206.164     0.150
    14.314   209.305     0.150
    14.336   205.520     0.150
    14.359   212.176     0.150
    14.454   206.609     0.150
    14.454   207.125     0.150
    14.553   211.336     0.150
    14.546   207.777     0.150
    14.546   208.766     0.150
    14.766   217.203     0.150
    14.788   212.977     0.150
    14.830   212.301     0.150
    14.930   214.305     0.150
    15.046   215.418     0.150
    15.037   220.516     0.150
    15.109   220.176     0.150
    15.139   216.863     0.150
    15.237   219.062     0.150
    15.395   223.016     0.150
    15.541   221.488     0.150
    15.584   224.449     0.150
    15.751   226.785     0.150
    15.722   228.574     0.150
    15.792   228.926     0.150
    15.844   224.867     0.150
    15.844   226.316     0.150
    15.854   226.625     0.150
    15.937   227.613     0.150
    16.021   230.395     0.150
    16.093   233.016     0.150
    16.324   232.184     0.150
    16.332   232.805     0.150
    16.383   233.133     0.150
    16.371   231.613     0.150
    16.422   234.785     0.150
    16.830   237.168     0.150
    16.836   238.004     0.150
    16.973   238.410     0.150
    16.973   240.484     0.150
    17.013   239.895     0.150
    17.055   244.746     0.150
    17.048   242.656     0.150
    17.307   243.992     0.150
    17.347   244.617     0.150
    17.600   249.656     0.150
    17.829   249.742     0.150
    17.862   251.379     0.150
    17.901   251.945     0.150
    17.901   560.793     0.150
    17.901   252.309     0.150
    17.931   251.703     0.150
    17.902   252.102     0.150
    18.155   255.879     0.150
    18.297   256.035     0.150
    18.345   257.496     0.150
    18.429   255.996     0.150
    18.446   257.938     0.150
    18.752   260.539     0.150
    18.789   261.527     0.150
    18.847   264.824     0.150
    19.069   265.480     0.150
    19.221   269.105     0.150
    19.263   266.824     0.150
    19.263   267.453     0.150
    19.327   267.855     0.150
    19.545   270.840     0.150
    19.901   274.773     0.150
    20.111   276.691     0.150
    20.342   278.727     0.150
    20.400   279.141     0.150
    20.400   280.523     0.150
    20.433   278.332     0.150
    20.433   280.344     0.150
    20.676   281.426     0.150
    21.176   289.543     0.150
    21.322   287.688     0.150
    21.349   290.227     0.150
    21.558   292.836     0.150
    21.568   293.383     0.150
    22.347   299.215     0.150
    22.393   301.883     0.150
    22.603   301.133     0.150
    22.678   302.863     0.150
    22.678   303.773     0.150
    22.759   303.789     0.150
    22.759   305.977     0.150
    22.816   303.344     0.150
    23.009   307.754     0.150
    23.083   308.414     0.150
    23.295   309.605     0.150
    23.355   311.000     0.150
    23.976   317.180     0.150
    24.093   316.855     0.150
    24.093   317.227     0.150
    24.112   318.996     0.150
    24.125   316.715     0.150
    24.153   317.062     0.150
    24.282   318.656     0.150
    24.282   320.273     0.150
    24.660   321.363     0.150
    25.135   328.203     0.150
    25.206   328.324     0.150
    25.735   331.824     0.150
    25.788   333.066     0.150
    25.856   334.996     0.150
    26.003   335.699     0.150
    26.003   610.000     0.150
    26.003   825.375     0.150
    26.003   337.875     0.150
    26.240   336.055     0.150
    26.243   336.000     0.150
    26.692   341.363     0.150
    26.985   343.105     0.150
    27.085   343.656     0.150
    27.128   344.977     0.150
    27.181   344.336     0.150
    27.284   345.934     0.150
    27.448   348.293     0.150
    27.471   346.668     0.150
    27.493   347.352     0.150
    27.513   347.434     0.150
    27.566   348.727     0.150
    27.677   349.121     0.150
    27.718   348.609     0.150
    27.771   349.055     0.150
    27.856   350.344     0.150
    27.928   355.715     0.150
    27.983   352.395     0.150
    28.000   351.723     0.150
    28.023   352.375     0.150
    28.073   352.434     0.150
    28.090   353.109     0.150
    28.125   353.141     0.150
    28.237   354.469     0.150
    28.249   353.578     0.150
    28.262   354.480     0.150
    28.263   353.266     0.150
    28.356   355.613     0.150
    28.414   354.652     0.150
    28.492   356.133     0.150
    28.516   356.129     0.150
    28.558   356.750     0.150
    28.598   357.234     0.150
    28.651   358.355     0.150
    28.673   357.875     0.150
    28.763   358.812     0.150
    28.778   358.996     0.150
    28.788   359.051     0.150
    28.894   360.316     0.150
    28.977   360.902     0.150
    29.082   361.523     0.150
    29.089   361.727     0.150
    29.106   363.227     0.150
    29.132   362.629     0.150
    29.136   362.695     0.150
    29.207   362.512     0.150
    29.259   362.859     0.150
    29.300   364.176     0.150
    29.464   365.191     0.150
    29.539   365.590     0.150
    29.554   367.266     0.150
    29.624   366.492     0.150
    29.632   367.480     0.150
    29.678   368.426     0.150
    29.706   368.113     0.150
    29.709   367.852     0.150
    29.725   370.555     0.150
    29.754   369.035     0.150
    29.770   368.684     0.150
    30.223   371.262     0.150
    30.239   371.570     0.150
    30.259   372.727     0.150
    30.276   372.754     0.150
    30.284   371.738     0.150
    30.283   372.922     0.150
    30.359   372.707     0.150
    30.506   374.617     0.150
    30.508   375.156     0.150
    30.522   375.469     0.150
    30.550   375.762     0.150
    30.767   376.938     0.150
    30.811   377.855     0.150
    30.814   376.652     0.150
    30.846   377.219     0.150
    30.856   377.266     0.150
    30.869   377.895     0.150
    30.915   378.145     0.150
    30.984   378.340     0.150
    30.985   378.320     0.150
    30.992   379.828     0.150
    31.064   379.527     0.150
    31.068   379.414     0.150
    31.083   379.648     0.150
    31.083   380.816     0.150
    31.222   380.461     0.150
    31.284   382.219     0.150
    31.382   381.836     0.150
    31.327   381.938     0.150
    31.352   382.223     0.150
    31.380   383.012     0.150
    31.405   384.199     0.150
    31.550   384.820     0.150
    31.571   384.102     0.150
    31.727   385.820     0.150
    31.747   386.562     0.150
    31.756   385.566     0.150
    32.005   385.641     0.150
    31.818   386.691     0.150
    31.858   386.812     0.150
    31.870   386.703     0.150
    31.877   387.805     0.150
    31.992   388.250     0.150
    32.029   388.410     0.150
    32.050   388.102     0.150
    32.054   388.082     0.150
    32.084   388.457     0.150
    32.249   391.125     0.150
    32.260   390.766     0.150
    32.294   390.828     0.150
    32.336   391.273     0.150
    32.410   391.871     0.150
    32.582   392.227     0.150
    32.610   393.145     0.150
    32.713   394.547     0.150
    32.713   394.574     0.150
    32.715   395.383     0.150
    32.777   395.039     0.150
    32.793   395.012     0.150
    32.862   395.285     0.150
    32.895   396.609     0.150
    32.902   395.941     0.150
    32.931   396.465     0.150
    32.947   396.949     0.150
    33.037   397.363     0.150
    33.047   397.848     0.150
    33.162   400.676     0.150
    33.168   398.223     0.150
    33.213   399.117     0.150
    33.239   398.016     0.150
    33.313   398.414     0.150
    33.405   400.105     0.150
    33.408   401.039     0.150
    33.521   401.074     0.150
    33.529   402.008     0.150
    33.538   402.043     0.150
    33.616   401.555     0.150
    33.628   402.469     0.150
    33.652   402.848     0.150
    33.684   403.621     0.150
    33.940   404.926     0.150
    33.984   405.867     0.150
    33.989   406.242     0.150
    34.055   406.371     0.150
    34.126   406.543     0.150
    34.125   406.602     0.150
    34.228   407.824     0.150
    34.310   408.801     0.150
    34.487   409.926     0.150
    34.537   410.273     0.150
    34.595   410.375     0.150
    34.733   412.434     0.150
    34.757   412.199     0.150
    34.772   412.777     0.150
    34.794   413.336     0.150
    34.911   414.074     0.150
    34.924   413.691     0.150
    35.106   415.594     0.150
    35.178   416.910     0.150
    35.190   416.812     0.150
    35.373   418.734     0.150
    35.374   418.578     0.150
    35.442   418.906     0.150
    35.579   420.055     0.150
    35.606   420.105     0.150
    35.699   420.082     0.150
    35.785   420.797     0.150
    35.793   421.480     0.150
    35.897   422.844     0.150
    35.917   420.938     0.150
    35.924   422.387     0.150
    35.943   423.637     0.150
    35.983   423.770     0.150
    36.010   423.609     0.150
    36.049   423.730     0.150
    36.141   425.078     0.150
    36.199   425.379     0.150
    36.377   427.328     0.150
    36.436   428.078     0.150
    36.535   428.684     0.150
    36.859   431.414     0.150
    36.879   431.828     0.150
    37.063   433.367     0.150
    37.279   434.762     0.150
    37.544   437.461     0.150
    37.554   437.512     0.150
    37.617   437.609     0.150
    37.690   437.613     0.150
    37.883   440.938     0.150
    37.915   441.000     0.150
    37.938   440.125     0.150
    37.968   440.996     0.150
    38.125   442.117     0.150
    38.201   443.844     0.150
    38.312   443.695     0.150
    38.362   444.086     0.150
    38.410   444.887     0.150
    38.668   446.254     0.150
    38.691   446.227     0.150
    38.808   450.863     0.150
    38.992   448.105     0.150
    39.098   449.199     0.150
    39.144   450.242     0.150
    39.284   450.992     0.150
    39.487   453.832     0.150
    39.637   455.109     0.150
    39.867   456.805     0.150
    39.867   456.344     0.150
    40.045   458.863     0.150
    40.239   461.727     0.150
    40.242   460.488     0.150
    40.274   460.309     0.150
    40.444   461.367     0.150
    40.883   465.434     0.150
    41.448   468.730     0.150
    41.448   469.094     0.150
    41.981   474.496     0.150
    41.991   475.109     0.150
    41.967   474.066     0.150
    42.531   479.180     0.150
    42.683   479.383     0.150
    43.229   484.613     0.150
    43.313   485.613     0.150
    43.372   484.285     0.150
    43.466   487.566     0.150
    44.367   494.574     0.150
    44.409   492.703     0.150
    44.539   495.895     0.150
    44.804   498.246     0.150
    45.034   499.996     0.150
    45.391   503.227     0.150
    45.391   503.746     0.150
    45.391   501.426     0.150
    45.398   503.328     0.150
    45.447   504.645     0.150
    45.457   504.625     0.150
    45.692   503.863     0.150
    45.737   504.266     0.150
    45.971   505.953     0.150
    45.971   506.863     0.150
    45.971   506.285     0.150
    46.004   507.516     0.150
    55.048   574.566     0.150
    56.977   587.305     0.150
    56.977   587.844     0.150
    58.646  1078.703     0.150
    60.165   610.176     0.150
    61.036   616.145     0.150
    61.091   615.113     0.150
    62.743   626.395     0.150
    62.743     4.238     0.150
    64.277   636.730     0.150
    64.277   637.824     0.150
    64.814   641.531     0.150
    65.144   643.105     0.150
    65.457   645.414     0.150
    65.709   647.035     0.150
    65.709     2.691     0.150
    66.452   651.805     0.150
    66.452     3.531     0.150
    67.562   659.066     0.150
    67.593   659.203     0.150
    68.420   663.953     0.150
    68.420     3.172     0.150
    69.570   670.375     0.150
    69.968   673.793     0.150
    70.856   680.074     0.150
    71.550   684.145     0.150
    74.470   701.336     0.150
    74.888   703.594     0.150
    75.585   707.016     0.150
    76.078   709.137     0.150
    76.177   710.676     0.150
    78.451   723.504     0.150
    78.451   723.086     0.150
    78.468   724.055     0.150
    78.468   725.344     0.150
    78.638   724.504     0.150
    78.638   724.328     0.150
    79.065   727.766     0.150
    79.118   727.176     0.150
    79.205   726.805     0.150
    79.700   730.715     0.150
    80.996   736.984     0.150
    81.039   737.727     0.150
    81.588   740.430     0.150
    81.750   742.105     0.150
    81.776   742.105     0.150
    81.901   742.004     0.150
    82.463   744.004     0.150
    82.523   745.605     0.150
    82.786   747.406     0.150
    82.806   746.605     0.150
    82.922   747.227     0.150
    82.965   749.305     0.150
    83.144   749.305     0.150
    83.144   749.703     0.150
    83.188   749.336     0.150
    83.238   749.035     0.150
    83.264   749.391     0.150
    83.263   749.219     0.150
    83.290   749.176     0.150
    83.372   749.965     0.150
    83.585   750.895     0.150
    83.625   750.727     0.150
    83.712   752.504     0.150
    84.140   753.488     0.150
    84.182   753.992     0.150
    84.236   754.156     0.150
    84.236   753.555     0.150
    84.685   756.418     0.150
    84.680   757.863     0.150
    84.755   757.172     0.150
    84.781   757.004     0.150
    84.857   756.703     0.150
    84.857   757.523     0.150
    84.857   756.195     0.150
    84.857   757.203     0.150
    84.857  1384.703     0.150
    84.848   757.531     0.150
    85.001   757.758     0.150
    85.305   759.371     0.150
    85.894   762.645     0.150
    86.155   763.871     0.150
    86.241   763.453     0.150
    86.287   763.805     0.150
    86.287   766.605     0.150
    86.509   763.605     0.150
    86.511   764.789     0.150
    86.656   766.500     0.150
    86.676   765.961     0.150
    86.721   765.543     0.150
    87.010   767.516     0.150
    87.010   766.801     0.150
    87.050   767.133     0.150
    88.127   772.605     0.150
    88.393   773.035     0.150
    88.393   773.523     0.150
    88.581   775.203     0.150
    89.316   778.305     0.150
    89.360   778.703     0.150
    89.417   778.406     0.150
    90.117   782.906     0.150
    90.321   782.805     0.150
    90.501   783.062     0.150
    90.669   784.234     0.150
    90.891   785.805     0.150
    90.959   786.133     0.150
    92.967   795.105     0.150
    93.226   797.223     0.150
    93.226   797.465     0.150
    93.924   799.684     0.150
    93.924   800.395     0.150
    94.152   801.145     0.150
    94.318   802.176     0.150
    94.318   801.156     0.150
    94.318   801.645     0.150
    95.471   807.879     0.150
    97.335   816.906     0.150
    99.997   827.406     0.150
   100.460   829.875     0.150
   117.874  1128.469     0.150
   119.731  1132.355     0.150
   121.799  1137.703     0.150
   121.799  1136.945     0.150
   123.218  1137.695     0.150
   123.714  1138.785     0.150
   123.980  1139.449     0.150
   125.341  1141.992     0.150
   125.341  1142.156     0.150
   142.800  1175.992     0.150
   144.187  1177.004     0.150
   144.855  1177.879     0.150
     1.272    22.359     0.150
     1.272    22.180     0.150
     1.272    39.086     0.150
     1.274    23.227     0.150
     1.274    23.375     0.150
     1.274    39.398     0.150
     1.265    22.703     0.150
     1.487    26.836     0.150
     1.487    45.727     0.150
     2.012    33.836     0.150
     2.183    34.727     0.150
     2.198    35.258     0.150
     2.198    36.430     0.150
     2.342    37.875     0.150
     2.441    40.133     0.150
     2.573    41.047     0.150
     2.661    42.758     0.150
     2.705    42.180     0.150
     2.758    43.945     0.150
     2.758    87.508     0.150
     2.859    45.125     0.150
     2.925    47.797     0.150
     2.925    82.797     0.150
     2.976    46.109     0.150
     3.093    48.648     0.150
     3.111    48.250     0.150
     3.111    98.922     0.150
     3.133    49.828     0.150
     3.133    86.844     0.150
     3.133    51.430     0.150
     3.133    51.617     0.150
     3.385    53.195     0.150
     3.500    52.586     0.150
     3.500   107.953     0.150
     3.500    54.625     0.150
     3.434    54.695     0.150
     3.619    57.055     0.150
     3.538    53.414     0.150
     3.538    92.992     0.150
     3.538    57.477     0.150
     3.711    56.414     0.150
     3.713    57.680     0.150
     3.713   118.133     0.150
     3.713    57.008     0.150
     3.873    60.180     0.150
     3.833    61.844     0.150
     4.068    61.109     0.150
     4.068   124.938     0.150
     4.648    72.438     0.150
     5.009    80.359     0.150
     5.025    74.555     0.150
     5.042    75.617     0.150
     5.187    73.852     0.150
     5.331    80.984     0.150
     5.331    79.867     0.150
     5.342    83.039     0.150
     5.342   144.625     0.150
     5.479    80.555     0.150
     5.574    85.383     0.150
     5.574    83.414     0.150
     5.669    83.273     0.150
     5.829    88.797     0.150
     5.967    90.141     0.150
     5.967    89.766     0.150
     6.103    90.719     0.150
     6.169    94.828     0.150
     6.254    94.984     0.150
     6.340    94.500     0.150
     6.340    92.883     0.150
     6.417    98.180     0.150
     6.595    99.164     0.150
     6.650   100.789     0.150
     6.717   100.836     0.150
     6.717   100.469     0.150
     6.783   101.461     0.150
     6.818   101.602     0.150
     6.904   100.320     0.150
     6.984   104.219     0.150
     7.120   107.859     0.150
     7.149   108.188     0.150
     7.119   105.445     0.150
     7.125   104.289     0.150
     7.341   107.328     0.150
     7.369   110.047     0.150
     7.633   115.094     0.150
     7.753   117.758     0.150
     7.891   117.508     0.150
     7.973   118.305     0.150
     7.999   114.859     0.150
     8.022   116.445     0.150
     8.074   118.586     0.150
     8.201   119.664     0.150
     8.199   120.023     0.150
     8.213   119.406     0.150
     8.249   121.648     0.150
     8.228   119.508     0.150
     8.228   123.594     0.150
     8.575   127.953     0.150
     8.561   122.578     0.150
     8.669   286.734     0.150
     8.669   123.789     0.150
     8.754   124.938     0.150
     8.804   127.844     0.150
     8.871   127.797     0.150
     8.921   132.555     0.150
     8.919   129.117     0.150
     8.941   133.805     0.150
     8.955   128.703     0.150
     8.963   131.844     0.150
     8.969   130.203     0.150
     8.970   130.227     0.150
     8.971   131.109     0.150
     8.974   134.992     0.150
     9.014   132.883     0.150
     9.038   133.539     0.150
     9.047   131.680     0.150
     9.157   130.719     0.150
     9.148   135.430     0.150
     9.177   136.898     0.150
     9.158   134.047     0.150
     9.156   134.539     0.150
     9.167   135.703     0.150
     9.180   135.234     0.150
     9.207   135.656     0.150
     9.175   133.695     0.150
     9.175   133.703     0.150
     9.176   136.750     0.150
     9.176   133.836     0.150
     9.434   136.789     0.150
     9.489   135.297     0.150
     9.483   135.367     0.150
     9.641   138.688     0.150
     9.713   138.367     0.150
     9.791   144.594     0.150
     9.791   144.914     0.150
     9.899   145.992     0.150
    10.165   146.953     0.150
    10.181   150.438     0.150
    10.222   144.992     0.150
    10.222   149.617     0.150
    10.316   150.055     0.150
    10.267   149.844     0.150
    10.373   153.242     0.150
    10.412   148.492     0.150
    10.499   152.344     0.150
    10.502   155.406     0.150
    10.882   155.156     0.150
    10.930   156.844     0.150
    11.335   162.023     0.150
    11.408   164.445     0.150
    11.658   165.555     0.150
    12.017   169.898     0.150
    12.479   179.688     0.150
    12.389   180.117     0.150
    12.494   180.844     0.150
    12.539   181.633     0.150
    12.544   181.148     0.150
    12.575   180.125     0.150
    12.758   179.648     0.150
    12.839   181.016     0.150
    12.839   181.047     0.150
    12.839   186.242     0.150
    12.920   184.492     0.150
    12.985   182.859     0.150
    12.990   184.664     0.150
    12.876   189.664     0.150
    13.015   187.953     0.150
    13.096   190.938     0.150
    13.096   187.977     0.150
    13.050   187.844     0.150
    13.161   187.406     0.150
    13.207   191.273     0.150
    13.274   187.133     0.150
    13.391   188.859     0.150
    13.450   192.477     0.150
    13.572   190.797     0.150
    13.670   194.117     0.150
    13.653   193.984     0.150
    14.003   204.211     0.150
    14.056   205.305     0.150
    14.212   207.352     0.150
    14.212   207.883     0.150
    14.259   206.969     0.150
    14.257   209.273     0.150
    14.371   209.867     0.150
    14.281   208.516     0.150
    14.309   209.094     0.150
    14.396   210.203     0.150
    14.368   211.258     0.150
    14.406   209.445     0.150
    14.422   209.109     0.150
    14.473   210.617     0.150
    14.509   210.898     0.150
    14.516   208.539     0.150
    14.522   209.875     0.150
    14.532   210.203     0.150
    14.503   210.617     0.150
    14.556   212.539     0.150
    14.572   213.195     0.150
    14.596   213.219     0.150
    14.650   208.898     0.150
    14.834   220.875     0.150
    14.850   212.992     0.150
    14.785   211.562     0.150
    14.817   209.359     0.150
    14.902   214.688     0.150
    14.878   215.859     0.150
    14.879   215.477     0.150
    14.945   215.883     0.150
    14.988   216.664     0.150
    14.976   216.078     0.150
    15.015   216.258     0.150
    15.010   214.844     0.150
    15.056   213.680     0.150
    15.150   212.148     0.150
    15.258   220.703     0.150
    15.258   220.375     0.150
    15.293   222.375     0.150
    15.273   222.484     0.150
    15.412   223.898     0.150
    15.561   223.898     0.150
    15.663   225.445     0.150
    15.720   225.016     0.150
    15.807   224.938     0.150
    15.779   227.180     0.150
    15.833   224.727     0.150
    15.833   227.328     0.150
    15.857   225.055     0.150
    16.071   227.133     0.150
    16.037   227.617     0.150
    16.343   233.484     0.150
    16.362   232.125     0.150
    16.362   230.492     0.150
    16.385   229.547     0.150
    16.310   229.977     0.150
    16.376   232.125     0.150
    16.464   232.234     0.150
    16.469   230.938     0.150
    16.533   231.633     0.150
    16.688   233.344     0.150
    16.755   234.508     0.150
    16.755   233.227     0.150
    16.788   236.977     0.150
    16.937   236.703     0.150
    16.993   238.562     0.150
    17.115   239.484     0.150
    17.279   241.367     0.150
    17.363   243.250     0.150
    17.316   241.945     0.150
    17.350   243.109     0.150
    17.350   241.438     0.150
    17.527   245.398     0.150
    17.543   242.984     0.150
    17.619   243.688     0.150
    17.659   248.828     0.150
    17.781   245.867     0.150
    17.764   248.148     0.150
    17.879   251.508     0.150
    17.879   249.906     0.150
    17.835   248.266     0.150
    17.941   253.008     0.150
    18.255   252.203     0.150
    18.324   253.445     0.150
    18.350   252.094     0.150
    18.358   254.898     0.150
    18.423   254.078     0.150
    18.507   253.844     0.150
    18.593   255.016     0.150
    18.727   258.047     0.150
    18.760   260.109     0.150
    18.898   258.195     0.150
    18.873   260.148     0.150
    18.987   262.383     0.150
    19.003   261.477     0.150
    19.202   263.594     0.150
    19.181   264.289     0.150
    19.232   269.289     0.150
    19.364   265.594     0.150
    19.516   266.758     0.150
    19.546   267.016     0.150
    19.546   269.547     0.150
    19.665   270.047     0.150
    19.855   273.023     0.150
    20.218   275.789     0.150
    20.253   276.492     0.150
    20.268   274.180     0.150
    20.376   275.359     0.150
    20.664   278.242     0.150
    20.723   279.430     0.150
    20.754   280.648     0.150
    20.984   282.203     0.150
    21.106   284.180     0.150
    21.295   288.727     0.150
    21.293   289.367     0.150
    21.453   291.148     0.150
    21.491   289.062     0.150
    21.823   292.766     0.150
    22.315   295.992     0.150
    22.552   298.883     0.150
    22.660   302.836     0.150
    22.695   300.328     0.150
    22.774   301.562     0.150
    22.799   302.125     0.150
    22.938   306.945     0.150
    22.970   303.898     0.150
    23.110   307.547     0.150
    23.223   310.469     0.150
    23.279   309.445     0.150
    23.386   312.383     0.150
    23.468   310.805     0.150
    23.718   311.344     0.150
    23.710   314.148     0.150
    23.815   316.125     0.150
    23.822   313.562     0.150
    23.897   316.758     0.150
    23.882   313.695     0.150
    23.897   313.086     0.150
    24.035   318.961     0.150
    24.035   315.180     0.150
    24.080   318.914     0.150
    24.080   317.797     0.150
    24.071   318.094     0.150
    24.100   314.609     0.150
    24.153   315.445     0.150
    24.223   314.797     0.150
    24.234   319.664     0.150
    24.387   316.086     0.150
    24.659   318.695     0.150
    24.746   321.430     0.150
    24.959   326.039     0.150
    25.010   325.164     0.150
    25.060   327.578     0.150
    25.104   326.656     0.150
    25.127   328.344     0.150
    25.152   328.805     0.150
    25.317   330.680     0.150
    25.665   330.445     0.150
    25.679   331.180     0.150
    25.758   330.914     0.150
    25.937   336.891     0.150
    25.937   337.117     0.150
    26.091   335.094     0.150
    26.383   337.797     0.150
    26.580   338.867     0.150
    26.603   339.195     0.150
    26.928   342.062     0.150
    27.125   343.688     0.150
    27.617   347.586     0.150
    27.661   350.414     0.150
    27.916   351.805     0.150
    27.983   351.469     0.150
    28.636   358.359     0.150
    28.839   357.766     0.150
    28.945   361.664     0.150
    29.014   359.266     0.150
    29.045   360.312     0.150
    29.499   364.445     0.150
    30.465   373.555     0.150
    30.496   373.516     0.150
    30.798   374.992     0.150
    31.692   386.406     0.150
    31.862   390.164     0.150
    32.210   387.117     0.150
    32.244   387.688     0.150
    32.357   390.703     0.150
    32.436   391.906     0.150
    32.569   391.867     0.150
    32.852   393.836     0.150
    32.925   394.094     0.150
    33.218   396.312     0.150
    33.355   398.617     0.150
    34.216   406.188     0.150
    34.523   413.125     0.150
    35.814   420.289     0.150
    36.829   431.805     0.150
    37.634   433.625     0.150
    38.256   444.359     0.150
    38.464   440.875     0.150
    38.646   443.938     0.150
    39.696   451.625     0.150
    39.925   453.664     0.150
    39.925   458.734     0.150
    40.105   457.078     0.150
    40.130   457.273     0.150
    40.196   456.992     0.150
    40.364   457.258     0.150
    40.475   462.875     0.150
    40.840   465.055     0.150
    40.950   463.266     0.150
    41.420   470.023     0.150
    41.420   465.227     0.150
    42.085   477.789     0.150
    42.588   475.578     0.150
    43.368   486.539     0.150
    44.176   490.297     0.150
    44.176   491.180     0.150
    45.023   499.094     0.150
    45.206   501.727     0.150
    45.306   501.727     0.150
    45.306   499.109     0.150
    45.605   502.609     0.150
    45.650   505.242     0.150
    52.060   553.453     0.150
    52.060   549.117     0.150
    56.978   584.930     0.150
    58.675  1090.438     0.150
    62.657   624.812     0.150
    63.314  1150.539     0.150
    64.195   639.375     0.150
    65.221   644.859     0.150
    73.625   694.734     0.150
    75.134   702.234     0.150
    75.436   704.969     0.150
    76.090   710.797     0.150
    78.558   719.953     0.150
    78.634   725.688     0.150
    79.013   723.914     0.150
    79.247   729.523     0.150
    83.168   750.656     0.150
    83.218   750.453     0.150
    83.270   751.375     0.150
    83.352     4.586     0.150
    83.354   752.242     0.150
    83.372   752.023     0.150
    83.566   752.883     0.150
    83.735   754.016     0.150
    84.262   755.445     0.150
    84.314   751.195     0.150
    84.810   759.008     0.150
    84.810   754.156     0.150
    84.939   757.695     0.150
    84.939   754.203     0.150
    86.274   764.836     0.150
    86.274  1400.836     0.150
    86.274  1742.836     0.150
    86.522   766.234     0.150
    86.639   768.383     0.150
    88.377   772.305     0.150
    90.265   784.039     0.150
    90.307   785.836     0.150
    90.879   786.836     0.150
    92.965   796.508     0.150
    92.965   794.430     0.150
    93.988   803.352     0.150
    94.364   804.234     0.150
    94.364   800.336     0.150
    97.405   813.938     0.150
   100.076   824.133     0.150
   117.951  1130.211     0.150
   121.873  1138.148     0.150
   123.158  1139.484     0.150
   123.920  1138.922     0.150
   125.282  1143.500     0.150
   142.766  1173.273     0.150
   144.770  1180.156     0.150
     0.743    14.547     0.150
     0.743    26.656     0.150
     0.833    16.938     0.150
     0.929    17.508     0.150
     0.929    29.719     0.150
     0.956    17.547     0.150
     0.956    17.258     0.150
     1.043    19.195     0.150
     1.043    33.617     0.150
     1.043    33.516     0.150
     1.042    19.195     0.150
     1.042    33.676     0.150
     1.042    33.457     0.150
     1.042    34.195     0.150
     1.087    20.676     0.150
     1.216    20.836     0.150
     1.216    37.488     0.150
     1.238    20.816     0.150
     1.238    39.336     0.150
     1.231    22.797     0.150
     1.305    23.176     0.150
     1.352    23.910     0.150
     1.352    41.898     0.150
     1.352    24.105     0.150
     1.484    25.922     0.150
     1.484    45.414     0.150
     1.484    45.105     0.150
     1.620    27.797     0.150
     1.628    26.312     0.150
     1.626    27.191     0.150
     1.820    30.375     0.150
     1.905    31.816     0.150
     1.953    32.188     0.150
     1.953    62.348     0.150
     1.982    32.344     0.150
     1.982    63.109     0.150
     2.051    33.695     0.150
     2.081    34.344     0.150
     2.081    59.730     0.150
     2.280    37.676     0.150
     2.471    39.891     0.150
     2.471    69.703     0.150
     2.490    44.992     0.150
     2.485    40.070     0.150
     2.560    41.898     0.150
     2.598    73.938     0.150
     3.200    50.012     0.150
     3.238    50.828     0.150
     3.238    49.887     0.150
     3.238    97.668     0.150
     3.414    54.266     0.150
     3.683    55.520     0.150
     3.683    99.746     0.150
     3.739    58.688     0.150
     4.102    62.297     0.150
     4.102    61.227     0.150
     4.496    68.297     0.150
     4.614    71.660     0.150
     4.614    71.926     0.150
     4.757    72.676     0.150
     4.803    73.777     0.150
     5.051    78.195     0.150
     5.251    80.340     0.150
     5.251    80.059     0.150
     5.386    82.488     0.150
     5.470    84.277     0.150
     5.690    87.195     0.150
     5.781    86.699     0.150
     5.781    86.367     0.150
     6.596    99.559     0.150
     6.670   100.438     0.150
     6.806    98.195     0.150
     7.073   103.625     0.150
     7.373   244.117     0.150
     7.403   110.375     0.150
     7.403   110.258     0.150
     7.484   139.816     0.150
     7.484   235.469     0.150
     7.797   114.293     0.150
     9.025   135.820     0.150
     9.025   293.148     0.150
     9.667   140.957     0.150
     9.667   140.969     0.150
     9.668   140.340     0.150
     9.668   246.922     0.150
     9.668   302.184     0.150
     9.668   140.695     0.150
    28.725   361.746     0.150
    38.625   446.648     0.150
     1.406    44.757     0.150
     2.014    33.687     0.150
     2.182    34.667     0.150
     2.182    61.157     0.150
     2.182    34.429     0.150
     2.334    38.967     0.150
     2.334    65.697     0.150
     2.364    38.157     0.150
     2.612    40.977     0.150
     2.617    43.127     0.150
     2.618    42.597     0.150
     2.618    42.847     0.150
     2.807    44.827     0.150
     2.808    44.797     0.150
     2.837    46.017     0.150
     2.885    45.327     0.150
     2.885    46.367     0.150
     2.885    44.599     0.150
     2.891    46.437     0.150
     2.891    44.121     0.150
     2.918    79.527     0.150
     2.918    45.817     0.150
     3.023    45.518     0.150
     3.012    45.447     0.150
     3.012    81.337     0.150
     3.075    48.107     0.150
     3.195    49.617     0.150
     3.195    49.837     0.150
     3.237    49.576     0.150
     3.392    52.427     0.150
     3.553    56.107     0.150
     3.592    55.767     0.150
     3.592    54.492     0.150
     3.689    54.857     0.150
     3.689    56.087     0.150
     3.689    55.251     0.150
     3.866    59.237     0.150
     3.866   120.737     0.150
     3.866    58.997     0.150
     3.866    57.425     0.150
     3.898    59.847     0.150
     3.783    55.687     0.150
     4.057    60.360     0.150
     4.188    62.821     0.150
     4.123    59.577     0.150
     4.344    65.747     0.150
     4.491    67.207     0.150
     4.570    68.388     0.150
     4.556    67.459     0.150
     4.735    69.941     0.150
     4.867    73.917     0.150
     4.907    74.707     0.150
     4.930    73.660     0.150
     4.930   149.348     0.150
     5.148    98.887     0.150
     5.290    78.360     0.150
     5.290   159.834     0.150
     5.510    83.457     0.150
     5.510    80.361     0.150
     5.486    80.577     0.150
     5.613   170.010     0.150
     5.688    84.767     0.150
     5.774    84.652     0.150
     5.848    88.417     0.150
     5.859    87.477     0.150
     5.859    86.839     0.150
     5.925    86.126     0.150
     5.985   194.711     0.150
     6.054    89.757     0.150
     6.054    88.517     0.150
     6.054    89.378     0.150
     6.221    90.576     0.150
     6.221   201.876     0.150
     6.249    92.977     0.150
     6.249    92.388     0.150
     6.295    94.897     0.150
     6.337    95.247     0.150
     6.397    96.117     0.150
     6.427    93.931     0.150
     6.447    96.987     0.150
     6.479    97.697     0.150
     6.479    94.850     0.150
     6.479   212.156     0.150
     6.861   102.357     0.150
     6.921   103.847     0.150
     6.930   103.447     0.150
     6.930   101.468     0.150
     6.982   101.446     0.150
     7.037   103.287     0.150
     7.037   222.437     0.150
     7.223   107.407     0.150
     7.247   108.797     0.150
     7.383   109.857     0.150
     7.369   107.677     0.150
     7.369   108.016     0.150
     7.424   110.437     0.150
     7.455   110.897     0.150
     7.440   109.737     0.150
     7.528   112.057     0.150
     7.550   113.377     0.150
     7.582   110.002     0.150
     7.619   110.677     0.150
     7.647   111.857     0.150
     7.820   113.147     0.150
     7.820   115.107     0.150
     7.820   113.306     0.150
     8.027   119.377     0.150
     8.099   118.917     0.150
     8.151   117.662     0.150
     8.151   248.262     0.150
     8.151   118.077     0.150
     8.151   118.369     0.150
     8.205   121.707     0.150
     8.205   119.669     0.150
     8.331   124.077     0.150
     8.362   123.547     0.150
     8.269   119.877     0.150
     8.487   126.647     0.150
     8.493   124.957     0.150
     8.512   124.557     0.150
     8.512   123.585     0.150
     8.538   127.387     0.150
     8.853   130.604     0.150
     8.853   282.242     0.150
     8.854   130.187     0.150
     8.939   133.267     0.150
     9.082   134.077     0.150
     9.104   134.897     0.150
     9.157   135.007     0.150
     9.256   134.167     0.150
     9.255   135.527     0.150
     9.299   137.047     0.150
     9.333   136.747     0.150
     9.295   133.417     0.150
     9.295   133.967     0.150
     9.296   133.184     0.150
     9.296   234.192     0.150
     9.296   289.417     0.150
     9.296   133.387     0.150
     9.429   138.637     0.150
     9.436   137.987     0.150
     9.453   139.247     0.150
     9.466   138.397     0.150
     9.714   141.187     0.150
     9.765   142.217     0.150
     9.765   140.623     0.150
     9.883   144.497     0.150
     9.912   143.387     0.150
     9.973   144.647     0.150
     9.988   145.457     0.150
    10.056   145.867     0.150
    10.056   144.578     0.150
    10.084   148.077     0.150
    10.223   150.427     0.150
    10.361   152.297     0.150
    10.488   153.347     0.150
    10.499   152.147     0.150
    10.499   150.041     0.150
    10.491   151.547     0.150
    10.491   151.172     0.150
    10.557   151.467     0.150
    10.557   333.067     0.150
    10.557   153.677     0.150
    10.647   155.337     0.150
    10.684   155.467     0.150
    10.762   157.847     0.150
    10.771   156.027     0.150
    10.771   155.394     0.150
    10.807   157.287     0.150
    10.846   158.937     0.150
    11.054   160.307     0.150
    11.092   160.727     0.150
    11.554   166.277     0.150
    11.554   164.582     0.150
    11.607   167.677     0.150
    11.642   167.477     0.150
    11.786   171.447     0.150
    11.943   171.787     0.150
    11.943   171.307     0.150
    12.605   182.237     0.150
    12.543   179.727     0.150
    12.543   178.843     0.150
    12.645   183.037     0.150
    12.662   182.927     0.150
    12.702   184.337     0.150
    12.733   183.857     0.150
    12.811   183.297     0.150
    12.768   182.817     0.150
    12.768   182.448     0.150
    12.830   183.697     0.150
    12.958   186.617     0.150
    12.853   184.807     0.150
    13.052   187.907     0.150
    13.033   187.647     0.150
    13.064   189.307     0.150
    13.117   188.187     0.150
    13.117   185.180     0.150
    13.118   188.567     0.150
    13.118   188.837     0.150
    13.118   412.273     0.150
    13.118   189.027     0.150
    13.120   189.407     0.150
    13.141   189.827     0.150
    13.141   188.107     0.150
    13.206   190.647     0.150
    13.162   188.987     0.150
    13.162   187.690     0.150
    13.254   192.147     0.150
    13.346   191.707     0.150
    13.346   188.070     0.150
    13.363   192.675     0.150
    13.363   191.747     0.150
    13.434   193.237     0.150
    13.479   192.627     0.150
    13.542   194.867     0.150
    13.547   195.617     0.150
    13.554   194.567     0.150
    13.576   194.557     0.150
    13.615   197.057     0.150
    13.615   191.274     0.150
    13.827   199.047     0.150
    13.917   199.437     0.150
    13.917   199.727     0.150
    13.875   198.087     0.150
    13.875   197.522     0.150
    14.113   207.317     0.150
    14.160   203.247     0.150
    14.188   201.353     0.150
    14.213   207.867     0.150
    14.435   207.057     0.150
    14.464   208.237     0.150
    14.484   207.687     0.150
    14.499   211.507     0.150
    14.442   206.077     0.150
    14.437   207.327     0.150
    14.558   208.694     0.150
    14.562   210.097     0.150
    14.602   207.807     0.150
    14.657   210.977     0.150
    14.648   208.737     0.150
    14.648   209.424     0.150
    14.693   209.907     0.150
    14.781   211.877     0.150
    14.790   209.757     0.150
    14.767   210.497     0.150
    14.767   208.627     0.150
    14.804   210.437     0.150
    14.825   212.167     0.150
    14.826   211.947     0.150
    14.842   212.547     0.150
    14.890   216.537     0.150
    14.850   217.777     0.150
    15.027   213.681     0.150
    15.053   220.507     0.150
    15.104   220.477     0.150
    15.178   214.326     0.150
    15.277   216.563     0.150
    15.274   217.537     0.150
    15.426   221.057     0.150
    15.426   221.390     0.150
    15.509   221.587     0.150
    15.524   221.817     0.150
    15.674   221.817     0.150
    15.920   225.267     0.150
    15.959   223.797     0.150
    16.007   226.037     0.150
    16.119   228.577     0.150
    16.119   227.729     0.150
    16.168   229.717     0.150
    16.281   231.977     0.150
    16.276   229.807     0.150
    16.568   230.407     0.150
    16.538   233.577     0.150
    16.538   232.933     0.150
    16.608   235.117     0.150
    16.615   232.477     0.150
    16.615   233.336     0.150
    16.635   232.927     0.150
    16.635   233.473     0.150
    16.589   233.917     0.150
    16.679   235.997     0.150
    16.730   235.647     0.150
    16.901   239.077     0.150
    16.932   240.097     0.150
    16.932   236.270     0.150
    17.045   239.547     0.150
    17.045   239.261     0.150
    17.215   242.537     0.150
    17.210   242.347     0.150
    17.210   240.810     0.150
    17.277   242.177     0.150
    17.531   247.207     0.150
    17.556   246.467     0.150
    17.595   247.257     0.150
    17.632   246.844     0.150
    17.736   249.067     0.150
    17.847   248.947     0.150
    17.981   253.127     0.150
    17.981   252.837     0.150
    18.083   251.607     0.150
    18.150   254.206     0.150
    18.177   253.611     0.150
    18.177   255.201     0.150
    18.222   253.827     0.150
    18.328   254.417     0.150
    18.520   257.577     0.150
    18.552   257.597     0.150
    18.552   258.247     0.150
    18.622   258.167     0.150
    18.706   260.567     0.150
    18.846   262.107     0.150
    18.934   263.887     0.150
    18.932   262.087     0.150
    18.954   261.755     0.150
    19.107   265.407     0.150
    19.089   264.187     0.150
    19.203   263.597     0.150
    19.435   267.307     0.150
    19.438   267.017     0.150
    19.487   268.617     0.150
    19.460   268.487     0.150
    19.510   269.757     0.150
    19.510   270.012     0.150
    19.704   270.317     0.150
    19.829   273.407     0.150
    19.829   272.306     0.150
    20.115   275.167     0.150
    20.244   277.067     0.150
    20.290   277.957     0.150
    20.468   279.047     0.150
    20.451   279.567     0.150
    20.451   280.185     0.150
    20.623   281.037     0.150
    20.614   279.927     0.150
    20.614   280.527     0.150
    20.950   284.947     0.150
    20.950   284.199     0.150
    20.950   284.217     0.150
    21.036   285.287     0.150
    21.171   288.137     0.150
    21.135   288.047     0.150
    21.221   287.297     0.150
    21.264   288.387     0.150
    21.305   290.137     0.150
    21.375   288.367     0.150
    21.500   291.557     0.150
    21.463   289.917     0.150
    21.460   291.107     0.150
    21.460   288.978     0.150
    21.534   290.827     0.150
    21.569   291.327     0.150
    21.569   290.987     0.150
    21.682   291.537     0.150
    21.703   293.447     0.150
    21.742   292.797     0.150
    21.767   294.137     0.150
    22.024   295.837     0.150
    22.056   296.547     0.150
    22.089   296.847     0.150
    22.022   295.012     0.150
    22.353   299.737     0.150
    22.524   301.127     0.150
    22.515   302.377     0.150
    22.592   300.726     0.150
    22.593   302.667     0.150
    22.804   304.947     0.150
    22.804   303.959     0.150
    22.945   305.987     0.150
    22.945   304.293     0.150
    22.914   306.217     0.150
    22.914   303.474     0.150
    23.039   306.767     0.150
    23.039   304.509     0.150
    23.059   307.107     0.150
    23.177   308.177     0.150
    23.239   309.587     0.150
    23.279   309.547     0.150
    23.405   311.937     0.150
    23.414   310.637     0.150
    23.414   310.038     0.150
    23.611   313.367     0.150
    23.683   314.567     0.150
    23.909   315.787     0.150
    23.972   316.977     0.150
    24.023   316.957     0.150
    24.065   317.527     0.150
    24.094   318.287     0.150
    24.064   318.037     0.150
    24.115   318.517     0.150
    24.171   318.827     0.150
    24.241   317.917     0.150
    24.338   319.367     0.150
    24.336   318.637     0.150
    24.365   318.592     0.150
    24.348   320.117     0.150
    24.348   317.521     0.150
    24.363   319.527     0.150
    24.456   320.247     0.150
    24.456   319.963     0.150
    24.474   321.537     0.150
    24.592   322.447     0.150
    24.604   322.987     0.150
    24.575   322.297     0.150
    24.869   324.417     0.150
    24.915   323.827     0.150
    24.940   326.167     0.150
    25.234   327.827     0.150
    25.214   327.697     0.150
    25.336   330.077     0.150
    25.340   329.527     0.150
    25.367   328.977     0.150
    25.413   329.967     0.150
    25.414   330.357     0.150
    25.512   330.297     0.150
    25.529   329.437     0.150
    25.751   333.590     0.150
    25.997   335.217     0.150
    26.075   335.237     0.150
    26.150   335.186     0.150
    26.150   336.037     0.150
    26.305   337.727     0.150
    26.346   338.257     0.150
    26.367   338.417     0.150
    26.367   335.920     0.150
    26.395   338.257     0.150
    26.630   341.107     0.150
    26.668   342.047     0.150
    26.717   340.497     0.150
    26.811   342.557     0.150
    26.839   342.727     0.150
    26.869   343.807     0.150
    26.936   344.307     0.150
    26.932   343.097     0.150
    27.166   345.357     0.150
    27.371   347.217     0.150
    27.368   346.887     0.150
    27.368   345.228     0.150
    27.359   348.177     0.150
    27.534   348.977     0.150
    27.534   348.529     0.150
    27.582   349.097     0.150
    27.689   350.317     0.150
    27.781   350.437     0.150
    27.848   352.147     0.150
    27.899   352.337     0.150
    28.124   354.747     0.150
    28.124   354.339     0.150
    28.208   355.517     0.150
    28.238   356.317     0.150
    28.339   356.447     0.150
    28.442   356.627     0.150
    28.380   354.097     0.150
    28.701   359.917     0.150
    28.701   360.836     0.150
    28.841   359.877     0.150
    28.912   360.787     0.150
    29.083   363.027     0.150
    29.132   362.403     0.150
    29.274   365.417     0.150
    29.320   364.437     0.150
    29.326   366.027     0.150
    29.326   365.169     0.150
    29.519   366.587     0.150
    29.648   368.447     0.150
    29.648   368.914     0.150
    29.644   368.807     0.150
    29.744   368.467     0.150
    29.744   368.824     0.150
    29.768   369.637     0.150
    29.866   370.227     0.150
    30.237   372.808     0.150
    30.705   377.377     0.150
    30.705   374.890     0.150
    30.742   377.567     0.150
    31.033   380.147     0.150
    31.033   380.547     0.150
    31.190   381.107     0.150
    31.207   381.687     0.150
    31.268   381.647     0.150
    31.268   380.320     0.150
    31.298   383.737     0.150
    31.742   385.967     0.150
    31.746   385.577     0.150
    31.775   387.237     0.150
    31.929   388.567     0.150
    31.936   387.247     0.150
    32.312   390.171     0.150
    32.312   557.952     0.150
    32.500   393.187     0.150
    32.899   397.217     0.150
    32.899   396.750     0.150
    32.910   397.037     0.150
    32.910   396.257     0.150
    32.924   397.297     0.150
    33.105   398.617     0.150
    33.321   398.667     0.150
    33.602   401.697     0.150
    34.186   407.827     0.150
    34.346   408.985     0.150
    34.335   408.907     0.150
    34.335   407.247     0.150
    34.471   409.177     0.150
    34.592   410.394     0.150
    34.775   413.427     0.150
    36.813   426.918     0.150
    37.417   434.947     0.150
    37.417   435.430     0.150
    38.040   439.399     0.150
    38.185   441.577     0.150
    38.431   443.668     0.150
    38.453   442.860     0.150
    38.634   442.696     0.150
    38.657   445.007     0.150
    38.657   444.381     0.150
    38.687   447.085     0.150
    38.749   444.185     0.150
    38.881   446.717     0.150
    38.917   446.074     0.150
    38.918   448.555     0.150
    39.597   450.838     0.150
    39.782   455.042     0.150
    39.782   581.467     0.150
    40.080   458.147     0.150
    40.080   458.608     0.150
    40.112   457.567     0.150
    40.112   456.364     0.150
    40.112   457.007     0.150
    40.370   459.065     0.150
    40.514   462.177     0.150
    40.514   462.403     0.150
    40.543   461.107     0.150
    40.686   463.017     0.150
    40.726   463.787     0.150
    40.994   465.847     0.150
    41.016   465.337     0.150
    41.028   463.246     0.150
    41.104   466.257     0.150
    41.145   464.061     0.150
    41.150   467.817     0.150
    41.150   463.811     0.150
    41.360   468.177     0.150
    41.360   464.279     0.150
    41.342   468.677     0.150
    41.387   469.027     0.150
    41.693   471.727     0.150
    41.699   469.217     0.150
    41.699   471.587     0.150
    41.657   471.077     0.150
    42.021   472.115     0.150
    42.181   475.717     0.150
    42.181   472.677     0.150
    42.268   473.059     0.150
    42.586   478.997     0.150
    42.586   475.009     0.150
    42.780   476.835     0.150
    43.309   484.957     0.150
    43.486   484.908     0.150
    43.566   486.897     0.150
    43.566   483.655     0.150
    44.197   490.557     0.150
    45.208   501.697     0.150
    45.323   500.092     0.150
    45.323   501.897     0.150
    45.623   504.842     0.150
    45.623   600.242     0.150
    45.673   502.897     0.150
    45.933   506.027     0.150
    46.084   502.897     0.150
    46.082   915.767     0.150
    46.082   504.037     0.150
    46.661   509.814     0.150
    47.239   515.068     0.150
    48.032   522.797     0.150
    48.032   520.322     0.150
    58.367   597.627     0.150
    58.395  1084.267     0.150
    64.138   636.067     0.150
    64.138   637.337     0.150
    64.721   641.457     0.150
    65.032   642.317     0.150
    65.320   643.753     0.150
    66.276   650.537     0.150
    66.862   653.386     0.150
    66.862   655.077     0.150
    66.999   655.447     0.150
    69.460   671.357     0.150
    69.765   672.777     0.150
    71.251   681.317     0.150
    71.302   682.857     0.150
    73.511   695.787     0.150
    75.145   706.257     0.150
    76.093   709.497     0.150
    76.116   710.587     0.150
    76.562   713.137     0.150
    78.311   721.292     0.150
    78.311   723.687     0.150
    78.393   724.017     0.150
    78.919   724.742     0.150
    79.298   726.697     0.150
    81.377   739.142     0.150
    83.208   747.309     0.150
    84.598   756.957     0.150
    84.995   758.506     0.150
    85.081   757.273     0.150
    88.662   772.931     0.150
    89.563   776.927     0.150
    89.563   988.037     0.150
    89.563  1406.697     0.150
    93.249   794.878     0.150
    94.154   800.996     0.150
    94.585   801.104     0.150
    97.542   815.867     0.150
    97.542  1492.367     0.150
   100.165   826.867     0.150
   108.515  1130.367     0.150
   108.515  1547.867     0.150
   108.515  2055.567     0.150
   113.900  1120.067     0.150
   115.179  1124.867     0.150
   115.179  1182.367     0.150
   115.179  2140.067     0.150
   117.782  1128.891     0.150
   119.621  1132.815     0.150
   121.989  1138.331     0.150
     1.393    44.713     0.150
     2.053    33.613     0.150
     2.171    60.143     0.150
     2.344    37.813     0.150
     2.344    66.283     0.150
     2.369    37.193     0.150
     2.610    41.273     0.150
     2.611    41.453     0.150
     2.628    43.663     0.150
     2.637    43.273     0.150
     2.637    41.703     0.150
     2.821    44.703     0.150
     2.821    44.143     0.150
     2.851    45.573     0.150
     2.891    45.343     0.150
     2.891    44.593     0.150
     2.905    44.383     0.150
     2.936    81.463     0.150
     2.936    45.533     0.150
     2.936    45.663     0.150
     2.936    45.893     0.150
     3.035    45.786     0.150
     3.029    47.133     0.150
     3.029    83.133     0.150
     3.092    47.303     0.150
     3.134    47.063     0.150
     3.134    45.273     0.150
     3.134    81.133     0.150
     3.212    49.773     0.150
     3.252    49.769     0.150
     3.377    52.463     0.150
     3.377    86.403     0.150
     3.377    55.483     0.150
     3.557    54.793     0.150
     3.595    54.314     0.150
     3.609    55.153     0.150
     3.609    54.598     0.150
     3.672    56.633     0.150
     3.672    54.571     0.150
     3.895    59.233     0.150
     3.873    57.728     0.150
     3.880    58.773     0.150
     3.880   102.798     0.150
     3.880   122.873     0.150
     3.880    59.763     0.150
     3.880    58.279     0.150
     3.880   123.273     0.150
     4.023    60.193     0.150
     4.068    61.503     0.150
     4.204    63.579     0.150
     4.204   130.533     0.150
     4.360    66.633     0.150
     4.470    68.573     0.150
     4.574    68.534     0.150
     4.576    68.646     0.150
     4.633    68.541     0.150
     4.727    70.652     0.150
     4.753    71.799     0.150
     4.753   148.871     0.150
     4.858    73.133     0.150
     4.908    75.043     0.150
     4.939    75.309     0.150
     4.945    75.686     0.150
     4.945   154.456     0.150
     5.165    78.003     0.150
     5.307    80.642     0.150
     5.410    81.437     0.150
     5.403    81.528     0.150
     5.403   148.755     0.150
     5.463    79.593     0.150
     5.522    84.023     0.150
     5.522    82.226     0.150
     5.628    84.590     0.150
     5.628   174.030     0.150
     5.675    84.043     0.150
     5.790    86.713     0.150
     5.852    87.433     0.150
     5.852    87.159     0.150
     5.862    88.933     0.150
     5.934    88.792     0.150
     6.034    89.703     0.150
     6.034    88.873     0.150
     6.034    88.254     0.150
     6.237    92.613     0.150
     6.237    92.160     0.150
     6.237    92.348     0.150
     6.190    90.283     0.150
     6.190   186.883     0.150
     6.305    95.373     0.150
     6.342    96.313     0.150
     6.443    96.363     0.150
     6.439    95.333     0.150
     6.414    95.643     0.150
     6.493    97.883     0.150
     6.493    96.125     0.150
     6.621    98.317     0.150
     6.516   100.003     0.150
     6.861   102.083     0.150
     6.919   103.673     0.150
     6.938   104.233     0.150
     6.938   102.015     0.150
     6.926   102.737     0.150
     6.994   104.400     0.150
     7.023   103.598     0.150
     7.023   220.948     0.150
     7.258   109.763     0.150
     7.258   108.349     0.150
     7.352   107.753     0.150
     7.383   110.593     0.150
     7.421   111.083     0.150
     7.455   111.063     0.150
     7.457   110.813     0.150
     7.535   112.453     0.150
     7.561   112.973     0.150
     7.601   110.563     0.150
     7.798   117.043     0.150
     7.798   113.187     0.150
     8.025   119.663     0.150
     8.135   117.348     0.150
     8.135   209.798     0.150
     8.135   252.573     0.150
     8.135   118.233     0.150
     8.116   119.153     0.150
     8.210   120.883     0.150
     8.210   119.416     0.150
     8.233   121.893     0.150
     8.332   122.723     0.150
     8.246   120.883     0.150
     8.375   124.713     0.150
     8.485   125.123     0.150
     8.502   125.403     0.150
     8.502   124.064     0.150
     8.537   126.533     0.150
     8.510   125.943     0.150
     8.765   129.773     0.150
     8.864   130.641     0.150
     8.864   281.953     0.150
     8.864   131.813     0.150
     8.871   130.753     0.150
     8.948   130.993     0.150
     9.079   134.553     0.150
     9.115   135.103     0.150
     9.148   135.753     0.150
     9.248   134.943     0.150
     9.325   137.593     0.150
     9.272   133.713     0.150
     9.272   133.473     0.150
     9.273   133.149     0.150
     9.273   234.828     0.150
     9.273   287.949     0.150
     9.273   133.443     0.150
     9.313   136.623     0.150
     9.380   137.883     0.150
     9.424   137.633     0.150
     9.432   138.423     0.150
     9.444   138.973     0.150
     9.457   138.843     0.150
     9.675   142.243     0.150
     9.710   143.063     0.150
     9.753   143.713     0.150
     9.753   140.934     0.150
     9.911   144.943     0.150
     9.895   144.983     0.150
     9.984   144.743     0.150
     9.986   144.553     0.150
    10.056   147.753     0.150
    10.056   145.721     0.150
    10.073   147.423     0.150
    10.096   147.873     0.150
    10.236   149.653     0.150
    10.372   151.563     0.150
    10.486   153.623     0.150
    10.486   152.150     0.150
    10.471   152.953     0.150
    10.471   151.311     0.150
    10.496   153.733     0.150
    10.561   152.153     0.150
    10.561   333.853     0.150
    10.561   154.073     0.150
    10.644   155.973     0.150
    10.682   156.203     0.150
    10.756   157.333     0.150
    10.756   155.042     0.150
    10.762   156.793     0.150
    10.797   157.703     0.150
    10.858   157.743     0.150
    11.049   160.583     0.150
    11.085   161.263     0.150
    11.085   159.343     0.150
    11.057   160.633     0.150
    11.092   161.423     0.150
    11.542   166.635     0.150
    11.605   168.133     0.150
    11.622   170.053     0.150
    11.622   167.431     0.150
    11.799   172.033     0.150
    11.799   171.342     0.150
    11.932   173.353     0.150
    11.932   171.406     0.150
    12.142   174.373     0.150
    12.154   172.453     0.150
    12.520   178.623     0.150
    12.520   178.364     0.150
    12.652   182.293     0.150
    12.652   181.670     0.150
    12.621   180.863     0.150
    12.656   182.873     0.150
    12.710   183.743     0.150
    12.746   182.852     0.150
    12.747   184.023     0.150
    12.810   185.013     0.150
    12.822   184.173     0.150
    12.832   184.483     0.150
    12.974   184.503     0.150
    13.018   187.353     0.150
    13.018   187.707     0.150
    13.051   189.283     0.150
    13.077   187.803     0.150
    13.077   189.311     0.150
    13.114   188.783     0.150
    13.114   188.005     0.150
    13.114   189.023     0.150
    13.114   188.443     0.150
    13.114   407.403     0.150
    13.114   188.233     0.150
    13.135   189.613     0.150
    13.154   189.853     0.150
    13.154   189.522     0.150
    13.196   189.763     0.150
    13.139   188.025     0.150
    13.258   190.773     0.150
    13.349   192.763     0.150
    13.349   191.785     0.150
    13.377   194.351     0.150
    13.377   417.961     0.150
    13.377   193.303     0.150
    13.432   193.643     0.150
    13.494   194.233     0.150
    13.541   194.583     0.150
    13.545   195.073     0.150
    13.562   194.823     0.150
    13.587   196.013     0.150
    13.628   196.033     0.150
    13.628   197.063     0.150
    13.781   198.105     0.150
    13.826   198.903     0.150
    13.855   198.123     0.150
    13.910   198.483     0.150
    14.114   205.703     0.150
    14.103   203.233     0.150
    14.103   203.553     0.150
    14.159   204.413     0.150
    14.199   204.004     0.150
    14.419   205.147     0.150
    14.447   207.173     0.150
    14.483   208.223     0.150
    14.483   206.078     0.150
    14.473   208.693     0.150
    14.497   207.343     0.150
    14.538   207.793     0.150
    14.538   206.565     0.150
    14.572   208.563     0.150
    14.581   208.943     0.150
    14.635   208.254     0.150
    14.658   211.193     0.150
    14.677   210.713     0.150
    14.691   210.503     0.150
    14.751   211.213     0.150
    14.751   210.472     0.150
    14.779   212.433     0.150
    14.790   212.673     0.150
    14.757   211.333     0.150
    14.803   213.663     0.150
    14.825   212.963     0.150
    14.841   212.823     0.150
    14.831   213.233     0.150
    14.829   211.503     0.150
    14.935   213.553     0.150
    15.038   215.471     0.150
    15.066   214.353     0.150
    15.066   216.484     0.150
    15.083   215.483     0.150
    15.084   216.733     0.150
    15.188   218.860     0.150
    15.257   218.533     0.150
    15.424   220.023     0.150
    15.424   220.312     0.150
    15.524   222.193     0.150
    15.524   221.907     0.150
    15.517   221.693     0.150
    15.674   223.933     0.150
    15.757   224.233     0.150
    15.792   225.537     0.150
    15.828   226.045     0.150
    15.926   227.113     0.150
    15.818   226.253     0.150
    16.012   228.232     0.150
    16.111   228.963     0.150
    16.178   230.833     0.150
    16.257   229.963     0.150
    16.290   230.113     0.150
    16.518   234.873     0.150
    16.518   232.893     0.150
    16.574   235.513     0.150
    16.568   236.183     0.150
    16.575   235.510     0.150
    16.608   237.173     0.150
    16.618   235.733     0.150
    16.645   235.743     0.150
    16.645   235.200     0.150
    16.686   236.203     0.150
    16.696   235.053     0.150
    16.708   236.253     0.150
    16.909   239.503     0.150
    16.909   239.523     0.150
    16.909   237.667     0.150
    16.956   239.193     0.150
    17.028   239.853     0.150
    17.028   239.617     0.150
    17.196   241.293     0.150
    17.196   241.623     0.150
    17.222   242.273     0.150
    17.262   242.753     0.150
    17.269   243.731     0.150
    17.533   246.983     0.150
    17.581   247.623     0.150
    17.566   247.694     0.150
    17.627   248.293     0.150
    17.627   247.868     0.150
    17.855   251.223     0.150
    17.960   250.549     0.150
    17.990   252.403     0.150
    18.063   251.473     0.150
    18.149   255.220     0.150
    18.182   253.947     0.150
    18.182   254.403     0.150
    18.199   254.113     0.150
    18.306   254.743     0.150
    18.424   259.760     0.150
    18.504   258.123     0.150
    18.553   258.073     0.150
    18.531   258.575     0.150
    18.607   259.583     0.150
    18.604   261.054     0.150
    18.623   259.249     0.150
    18.694   260.143     0.150
    18.704   261.143     0.150
    18.849   262.733     0.150
    18.915   262.653     0.150
    18.934   263.073     0.150
    18.934   263.422     0.150
    19.115   265.353     0.150
    19.069   265.093     0.150
    19.182   264.683     0.150
    19.197   266.607     0.150
    19.417   268.073     0.150
    19.417   269.363     0.150
    19.438   269.143     0.150
    19.478   269.843     0.150
    19.497   269.393     0.150
    19.497   268.565     0.150
    19.577   271.213     0.150
    19.682   272.213     0.150
    19.824   273.493     0.150
    19.824   272.649     0.150
    20.098   276.643     0.150
    20.267   278.663     0.150
    20.429   279.833     0.150
    20.429   279.665     0.150
    20.595   281.853     0.150
    20.595   281.550     0.150
    20.607   281.433     0.150
    20.607   281.689     0.150
    21.025   285.973     0.150
    21.179   287.833     0.150
    21.201   288.543     0.150
    21.249   288.633     0.150
    21.284   289.093     0.150
    21.352   289.283     0.150
    21.439   291.277     0.150
    21.515   291.773     0.150
    21.510   291.393     0.150
    21.559   292.533     0.150
    21.554   292.023     0.150
    21.651   293.463     0.150
    21.660   294.673     0.150
    21.725   293.543     0.150
    22.007   296.533     0.150
    22.036   297.643     0.150
    22.001   294.423     0.150
    22.001   545.448     0.150
    22.001   695.548     0.150
    22.505   302.073     0.150
    22.493   302.323     0.150
    22.578   303.363     0.150
    22.578   302.385     0.150
    22.572   303.603     0.150
    22.786   304.853     0.150
    22.786   304.385     0.150
    22.893   307.123     0.150
    22.893   305.043     0.150
    22.935   305.823     0.150
    22.935   305.407     0.150
    23.023   306.753     0.150
    23.023   306.640     0.150
    23.042   307.123     0.150
    23.158   309.413     0.150
    23.224   308.853     0.150
    23.261   309.343     0.150
    23.392   310.460     0.150
    23.430   312.110     0.150
    23.591   315.233     0.150
    23.955   316.773     0.150
    24.012   316.993     0.150
    24.081   318.783     0.150
    24.094   318.873     0.150
    24.225   318.803     0.150
    24.319   320.783     0.150
    24.319   320.638     0.150
    24.330   320.093     0.150
    24.330   319.516     0.150
    24.356   317.978     0.150
    24.356   581.403     0.150
    24.356   756.328     0.150
    24.342   320.753     0.150
    24.436   321.673     0.150
    24.436   319.900     0.150
    24.455   321.543     0.150
    24.583   323.723     0.150
    24.554   322.743     0.150
    24.903   325.283     0.150
    24.903   324.882     0.150
    25.193   328.933     0.150
    25.669   332.953     0.150
    25.732   332.057     0.150
    25.900   334.086     0.150
    25.925   334.323     0.150
    26.071   334.493     0.150
    26.129   335.947     0.150
    26.129   819.172     0.150
    26.129   337.253     0.150
    26.699   341.443     0.150
    26.789   343.403     0.150
    26.822   343.523     0.150
    26.921   343.703     0.150
    26.911   343.653     0.150
    27.147   345.903     0.150
    27.354   347.236     0.150
    27.349   347.153     0.150
    27.349   347.319     0.150
    27.518   348.761     0.150
    27.670   350.863     0.150
    27.705   351.613     0.150
    27.828   352.833     0.150
    27.880   352.883     0.150
    27.880   351.545     0.150
    27.816   351.843     0.150
    28.103   355.173     0.150
    28.103   353.645     0.150
    28.607   359.010     0.150
    28.682   360.033     0.150
    28.682   357.438     0.150
    28.718   358.511     0.150
    28.909   361.783     0.150
    28.927   361.010     0.150
    29.064   363.003     0.150
    29.112   362.415     0.150
    29.255   365.123     0.150
    29.308   365.723     0.150
    29.308   363.356     0.150
    29.628   366.689     0.150
    29.725   366.940     0.150
    29.950   371.133     0.150
    29.950   367.988     0.150
    30.246   373.203     0.150
    30.246   373.513     0.150
    30.686   376.943     0.150
    30.686   375.494     0.150
    31.015   380.393     0.150
    31.249   380.098     0.150
    31.736   385.143     0.150
    31.757   386.783     0.150
    32.177   390.893     0.150
    32.314   390.227     0.150
    32.314   557.478     0.150
    32.314  1021.426     0.150
    32.314   392.013     0.150
    32.498   393.887     0.150
    32.591   393.963     0.150
    32.673   394.439     0.150
    32.880   395.595     0.150
    32.891   396.158     0.150
    33.088   398.593     0.150
    33.424   401.412     0.150
    33.735   403.363     0.150
    34.318   409.033     0.150
    34.318   407.420     0.150
    34.356   409.464     0.150
    34.453   411.043     0.150
    34.602   410.486     0.150
    34.611   411.603     0.150
    34.757   412.973     0.150
    34.891   413.393     0.150
    35.158   417.403     0.150
    35.617   420.483     0.150
    36.483   428.263     0.150
    36.518   429.813     0.150
    36.791   429.943     0.150
    36.824   429.383     0.150
    37.177   431.941     0.150
    37.327   433.103     0.150
    37.336   433.883     0.150
    37.336   433.669     0.150
    37.427   435.763     0.150
    37.776   438.993     0.150
    37.794   438.673     0.150
    38.130   440.966     0.150
    38.206   442.061     0.150
    38.200   442.444     0.150
    38.419   444.693     0.150
    38.443   444.213     0.150
    38.443   444.434     0.150
    38.452   444.713     0.150
    38.463   444.373     0.150
    38.463   443.887     0.150
    38.564   446.423     0.150
    38.667   446.093     0.150
    38.667   445.511     0.150
    38.695   446.193     0.150
    38.695   446.018     0.150
    38.760   446.313     0.150
    38.760   447.393     0.150
    38.809   447.413     0.150
    38.864   448.243     0.150
    38.843   447.333     0.150
    38.928   448.947     0.150
    38.930   449.353     0.150
    38.898   448.593     0.150
    39.111   450.720     0.150
    39.129   450.853     0.150
    39.129   450.306     0.150
    39.335   450.523     0.150
    39.546   452.818     0.150
    39.602   453.689     0.150
    39.790   453.953     0.150
    39.790   454.744     0.150
    39.853   457.043     0.150
    40.092   457.763     0.150
    40.122   457.493     0.150
    40.127   457.643     0.150
    40.127   458.102     0.150
    40.382   460.510     0.150
    40.494   462.373     0.150
    40.494   460.905     0.150
    40.497   461.953     0.150
    40.497   461.433     0.150
    40.511   461.086     0.150
    40.530   461.943     0.150
    40.527   461.376     0.150
    40.697   463.087     0.150
    40.738   462.577     0.150
    41.006   464.943     0.150
    41.028   464.956     0.150
    41.041   466.131     0.150
    41.148   466.647     0.150
    41.156   467.195     0.150
    41.161   466.873     0.150
    41.161   467.225     0.150
    41.325   468.953     0.150
    41.364   468.572     0.150
    41.373   469.223     0.150
    41.373   468.814     0.150
    41.527   470.033     0.150
    41.527   469.378     0.150
    41.687   469.203     0.150
    41.687   470.193     0.150
    41.705   470.643     0.150
    41.705   470.844     0.150
    42.033   473.826     0.150
    42.193   475.053     0.150
    42.193   474.919     0.150
    42.222   475.283     0.150
    42.272   474.783     0.150
    42.597   477.947     0.150
    42.596   479.153     0.150
    42.790   480.353     0.150
    42.790   479.826     0.150
    43.286   483.143     0.150
    43.498   485.339     0.150
    43.576   486.423     0.150
    43.576   485.098     0.150
    43.759   488.973     0.150
    44.174   490.163     0.150
    44.299   491.123     0.150
    44.443   493.733     0.150
    44.990   495.603     0.150
    45.186   498.663     0.150
    45.300   501.028     0.150
    45.300   501.343     0.150
    45.650   500.363     0.150
    45.910   504.623     0.150
    46.061   505.793     0.150
    46.094   913.803     0.150
    46.674   510.913     0.150
    47.251   514.863     0.150
    47.251   514.412     0.150
    47.628   520.093     0.150
    48.045   520.025     0.150
    49.049   528.633     0.150
    49.049   528.148     0.150
    51.048   543.273     0.150
    58.379   597.543     0.150
    64.118   635.203     0.150
    64.118   637.003     0.150
    64.702   640.553     0.150
    65.337   642.904     0.150
    65.337   643.443     0.150
    65.660   645.653     0.150
    65.883   648.063     0.150
    66.670   652.973     0.150
    66.877   653.347     0.150
    66.877   653.463     0.150
    66.981   655.653     0.150
    67.429   658.193     0.150
    67.906   661.353     0.150
    68.240   663.498     0.150
    68.240   662.333     0.150
    68.797   662.983     0.150
    69.469   668.823     0.150
    69.747   672.253     0.150
    70.982   681.203     0.150
    71.284   682.193     0.150
    72.066   689.163     0.150
    73.494   696.363     0.150
    75.129   704.893     0.150
    76.002   711.593     0.150
    76.077   710.623     0.150
    76.100   711.023     0.150
    76.146   710.873     0.150
    76.547   713.573     0.150
    78.291   722.203     0.150
    78.912   723.028     0.150
    81.362   740.103     0.150
    81.362   739.973     0.150
    83.203   747.258     0.150
    83.203   747.613     0.150
    83.414   750.973     0.150
    84.148   753.593     0.150
    84.430   754.203     0.150
    84.430   753.903     0.150
    85.066   756.493     0.150
    85.015   755.999     0.150
    85.528   760.203     0.150
    85.528  1389.203     0.150
    86.009   762.203     0.150
    86.550   766.203     0.150
    86.550  1461.203     0.150
    86.550  1736.203     0.150
    86.795   764.503     0.150
    88.652   773.386     0.150
    91.910   789.203     0.150
    93.243   795.194     0.150
    94.167   801.059     0.150
    94.167   801.413     0.150
    94.592   801.601     0.150
    94.592   802.943     0.150
    97.557   817.203     0.150
   100.183   829.703     0.150
   108.527   865.003     0.150
   108.527  2052.003     0.150
   113.916  1121.203     0.150
   117.805  1127.740     0.150
   119.643  1131.029     0.150
   142.538  1172.646     0.150
   144.848  1177.853     0.150
   145.117  1177.927     0.150
     1.157    18.398     0.150
     1.188    20.379     0.150
     1.188    37.969     0.150
     1.188    20.078     0.150
     1.622    25.777     0.150
     1.622    25.887     0.150
     1.716    26.578     0.150
     1.716    48.559     0.150
     1.716    26.859     0.150
     1.818    28.828     0.150
     1.818    28.527     0.150
     1.818    56.609     0.150
     1.818    28.941     0.150
     1.818    29.047     0.150
     1.917    31.438     0.150
     1.996    31.828     0.150
     2.218    34.547     0.150
     2.310    36.547     0.150
     2.475    38.680     0.150
     2.475    44.148     0.150
     2.527    38.797     0.150
     2.527    39.180     0.150
     2.538    40.398     0.150
     2.537    40.918     0.150
     2.582    39.168     0.150
     2.635    41.695     0.150
     2.635    48.348     0.150
     2.729    42.309     0.150
     2.729    42.520     0.150
     2.729    42.707     0.150
     2.729    54.520     0.150
     2.813    43.598     0.150
     2.813    73.227     0.150
     2.861    43.977     0.150
     2.977    44.996     0.150
     2.977    46.797     0.150
     2.989    46.180     0.150
     2.989    54.277     0.150
     3.110    47.789     0.150
     3.181    57.977     0.150
     3.179    48.539     0.150
     3.229    57.520     0.150
     3.251    50.383     0.150
     3.221    49.289     0.150
     3.221    51.117     0.150
     3.385    60.930     0.150
     3.385   102.117     0.150
     3.391    50.996     0.150
     3.391    50.617     0.150
     3.391    51.602     0.150
     3.391   106.113     0.150
     3.503    53.238     0.150
     3.578    53.742     0.150
     3.579    54.246     0.150
     3.585    56.539     0.150
     3.585    67.363     0.150
     3.585   116.965     0.150
     3.585    55.539     0.150
     3.585    54.152     0.150
     3.661    55.047     0.150
     3.741    57.219     0.150
     3.668    58.867     0.150
     3.946    73.953     0.150
     3.946   119.492     0.150
     4.111    61.617     0.150
     4.297    64.078     0.150
     4.484    67.066     0.150
     4.519    68.469     0.150
     4.681    87.191     0.150
     4.894    92.477     0.150
     4.924    73.477     0.150
     5.068    76.230     0.150
     5.199    77.398     0.150
     5.355    94.480     0.150
     5.330    79.148     0.150
     5.469    81.598     0.150
     5.582    82.719     0.150
     5.700   107.898     0.150
     5.730   108.305     0.150
     5.811    85.637     0.150
     5.811    86.344     0.150
     5.884    86.887     0.150
     5.966    86.996     0.150
     5.970    90.066     0.150
     6.051    90.738     0.150
     6.123   116.184     0.150
     6.184    90.496     0.150
     6.214    89.859     0.150
     6.214   117.867     0.150
     6.469    96.188     0.150
     6.583    96.867     0.150
     6.688   100.145     0.150
     6.852   100.949     0.150
     6.926   100.297     0.150
     6.993   104.039     0.150
     7.028   104.379     0.150
     7.063   104.719     0.150
     7.168   103.059     0.150
     7.223   103.688     0.150
     7.232   104.938     0.150
     7.632   112.840     0.150
     7.639   110.996     0.150
     7.639   111.375     0.150
     7.839   113.969     0.150
     7.839   113.590     0.150
     7.840   114.762     0.150
     7.840   253.738     0.150
     7.840   111.887     0.150
     7.840   115.414     0.150
     7.888   112.688     0.150
     7.920   115.047     0.150
     7.945   115.719     0.150
     8.077   121.699     0.150
     8.092   119.828     0.150
     8.144   119.238     0.150
     8.137   119.430     0.150
     8.137   118.520     0.150
     8.405   120.559     0.150
     8.442   122.207     0.150
     8.536   127.148     0.150
     8.536   123.469     0.150
     8.687   127.129     0.150
     8.788   126.066     0.150
     8.772   127.316     0.150
     8.869   129.008     0.150
     8.870   127.809     0.150
     8.945   131.277     0.150
     9.029   128.918     0.150
     9.043   129.129     0.150
     9.034   132.289     0.150
     9.040   132.969     0.150
     9.054   130.840     0.150
     9.081   132.527     0.150
     9.106   131.566     0.150
     9.126   132.148     0.150
     9.218   134.566     0.150
     9.218   134.156     0.150
     9.219   134.316     0.150
     9.219   291.984     0.150
     9.318   134.969     0.150
     9.357   133.656     0.150
     9.401   136.707     0.150
     9.401   137.066     0.150
     9.518   137.098     0.150
     9.582   137.117     0.150
     9.593   138.777     0.150
     9.649   139.508     0.150
     9.665   139.707     0.150
     9.665   140.148     0.150
     9.683   136.496     0.150
     9.927   140.988     0.150
    10.049   146.590     0.150
    10.138   145.719     0.150
    10.148   146.867     0.150
    10.148   147.996     0.150
    10.183   147.043     0.150
    10.183   146.340     0.150
    10.251   146.918     0.150
    10.246   147.867     0.150
    10.246   149.703     0.150
    10.290   147.957     0.150
    10.372   147.188     0.150
    10.429   149.848     0.150
    10.439   153.738     0.150
    10.439   152.367     0.150
    10.660   154.238     0.150
    10.703   154.688     0.150
    10.703   154.578     0.150
    10.760   155.680     0.150
    11.212   161.840     0.150
    11.241   161.109     0.150
    11.381   163.098     0.150
    11.381   163.656     0.150
    11.570   165.637     0.150
    11.570   166.098     0.150
    12.280   176.996     0.150
    12.327   179.008     0.150
    12.360   176.738     0.150
    12.417   178.316     0.150
    12.440   177.457     0.150
    12.413   177.848     0.150
    12.576   179.156     0.150
    12.576   180.938     0.150
    12.689   179.637     0.150
    12.722   185.277     0.150
    12.722   182.715     0.150
    12.722   183.609     0.150
    12.722   184.137     0.150
    12.722   403.840     0.150
    12.722   183.039     0.150
    12.825   183.637     0.150
    12.882   187.129     0.150
    12.965   185.488     0.150
    12.965   185.160     0.150
    13.039   186.547     0.150
    12.976   185.840     0.150
    13.148   187.996     0.150
    13.095   186.430     0.150
    13.152   185.059     0.150
    13.206   188.078     0.150
    13.258   189.629     0.150
    13.281   189.969     0.150
    13.319   188.789     0.150
    13.324   190.168     0.150
    13.433   191.777     0.150
    13.527   192.738     0.150
    13.527   193.309     0.150
    13.547   192.566     0.150
    13.513   193.488     0.150
    13.634   193.918     0.150
    13.634   194.602     0.150
    13.870   199.477     0.150
    13.933   199.719     0.150
    13.944   196.898     0.150
    14.123   205.297     0.150
    14.127   200.828     0.150
    14.167   207.508     0.150
    14.238   200.059     0.150
    14.268   201.898     0.150
    14.299   207.609     0.150
    14.289   202.969     0.150
    14.301   202.258     0.150
    14.386   204.270     0.150
    14.398   209.848     0.150
    14.388   204.188     0.150
    14.448   209.258     0.150
    14.462   204.637     0.150
    14.446   203.938     0.150
    14.558   205.379     0.150
    14.647   213.930     0.150
    14.718   208.668     0.150
    14.681   207.859     0.150
    14.752   213.969     0.150
    14.792   209.258     0.150
    14.880   209.777     0.150
    14.920   211.770     0.150
    14.940   211.840     0.150
    14.965   212.090     0.150
    14.986   212.508     0.150
    15.031   212.207     0.150
    15.031   212.715     0.150
    15.010   212.629     0.150
    15.132   220.027     0.150
    15.132   213.902     0.150
    15.099   213.477     0.150
    15.102   213.648     0.150
    15.159   218.566     0.150
    15.142   219.547     0.150
    15.284   219.848     0.150
    15.322   221.969     0.150
    15.428   216.047     0.150
    15.474   218.918     0.150
    15.555   222.746     0.150
    15.511   224.090     0.150
    15.599   220.020     0.150
    15.588   219.477     0.150
    15.673   221.973     0.150
    15.635   220.430     0.150
    15.733   222.109     0.150
    15.733   222.859     0.150
    15.713   222.137     0.150
    15.937   226.680     0.150
    16.003   224.227     0.150
    16.208   227.027     0.150
    16.217   226.969     0.150
    16.232   227.609     0.150
    16.232   228.965     0.150
    16.330   228.758     0.150
    16.286   227.219     0.150
    16.286   230.387     0.150
    16.363   234.109     0.150
    16.532   231.777     0.150
    16.739   234.719     0.150
    16.739   236.543     0.150
    16.766   234.629     0.150
    16.952   237.098     0.150
    17.149   237.109     0.150
    17.237   241.398     0.150
    17.237   242.738     0.150
    17.239   241.387     0.150
    17.485   243.059     0.150
    17.526   242.477     0.150
    17.517   241.906     0.150
    17.647   242.457     0.150
    17.756   249.590     0.150
    17.756   249.215     0.150
    17.808   250.137     0.150
    17.808   249.770     0.150
    17.808   248.582     0.150
    17.824   249.707     0.150
    17.824   250.242     0.150
    17.831   246.578     0.150
    18.190   253.156     0.150
    18.196   250.090     0.150
    18.338   256.090     0.150
    18.463   256.879     0.150
    18.972   261.770     0.150
    19.104   263.969     0.150
    19.135   263.379     0.150
    19.156   264.449     0.150
    19.156   265.367     0.150
    19.197   263.680     0.150
    19.336   266.449     0.150
    19.435   267.848     0.150
    19.435   268.320     0.150
    19.629   269.777     0.150
    19.802   271.348     0.150
    20.275   275.457     0.150
    20.275   277.434     0.150
    20.299   277.148     0.150
    20.299   278.453     0.150
    20.344   276.859     0.150
    20.344   277.344     0.150
    20.565   279.188     0.150
    20.565   280.480     0.150
    20.670   280.316     0.150
    20.824   281.879     0.150
    20.934   282.746     0.150
    20.953   283.590     0.150
    21.225   286.129     0.150
    21.258   286.340     0.150
    21.439   289.219     0.150
    21.705   291.906     0.150
    21.795   293.066     0.150
    22.066   295.809     0.150
    22.140   296.789     0.150
    22.241   297.117     0.150
    22.248   297.758     0.150
    22.322   297.629     0.150
    22.373   298.688     0.150
    22.508   299.789     0.150
    22.508   300.281     0.150
    22.568   300.738     0.150
    22.568   300.941     0.150
    22.678   302.188     0.150
    22.678   302.371     0.150
    22.715   301.668     0.150
    22.715   302.707     0.150
    22.746   302.289     0.150
    22.906   303.938     0.150
    22.905   304.727     0.150
    22.989   304.898     0.150
    23.193   307.219     0.150
    23.224   308.434     0.150
    23.364   309.566     0.150
    23.652   311.648     0.150
    23.670   311.680     0.150
    23.707   312.328     0.150
    23.738   313.027     0.150
    23.785   313.449     0.150
    23.828   313.188     0.150
    23.881   314.629     0.150
    24.060   315.258     0.150
    24.060   315.910     0.150
    24.142   317.707     0.150
    24.201   317.387     0.150
    24.365   318.770     0.150
    24.380   318.898     0.150
    24.552   319.727     0.150
    24.552   320.188     0.150
    24.648   322.328     0.150
    24.889   323.406     0.150
    25.002   325.547     0.150
    25.092   324.816     0.150
    25.155   325.527     0.150
    25.169   325.527     0.150
    25.305   328.578     0.150
    25.468   329.355     0.150
    25.924   334.887     0.150
    25.924   335.020     0.150
    26.065   332.090     0.150
    26.593   337.848     0.150
    26.706   339.988     0.150
    26.896   342.090     0.150
    27.089   342.707     0.150
    27.089   343.629     0.150
    27.591   348.047     0.150
    28.536   355.918     0.150
    29.039   361.148     0.150
    29.900   369.543     0.150
    30.992   376.711     0.150
    31.456   382.137     0.150
    32.196   388.477     0.150
    33.888   402.996     0.150
    34.028   405.156     0.150
    36.494   426.379     0.150
    36.857   429.551     0.150
    37.004   431.547     0.150
    37.086   429.367     0.150
    37.086   431.809     0.150
    37.600   436.133     0.150
    37.859   435.934     0.150
    37.859   436.520     0.150
    37.859   437.547     0.150
    38.062   437.746     0.150
    38.014   438.086     0.150
    38.094   439.844     0.150
    38.132   439.422     0.150
    38.335   441.848     0.150
    38.335   441.648     0.150
    38.342   442.141     0.150
    38.402   441.262     0.150
    38.429   442.703     0.150
    38.431   442.379     0.150
    38.498   442.973     0.150
    38.593   445.418     0.150
    38.593   445.523     0.150
    38.611   445.559     0.150
    38.807   445.633     0.150
    39.076   448.980     0.150
    39.214   449.207     0.150
    39.214   450.566     0.150
    39.217   447.938     0.150
    39.354   451.008     0.150
    39.427   451.492     0.150
    39.427   451.602     0.150
    39.770   454.098     0.150
    39.770   453.965     0.150
    39.792   454.109     0.150
    39.792   455.168     0.150
    39.792   454.996     0.150
    39.840   454.723     0.150
    39.906   455.840     0.150
    39.906   455.520     0.150
    40.063   456.078     0.150
    40.063   456.203     0.150
    40.215   457.645     0.150
    40.222   456.496     0.150
    40.222   457.094     0.150
    40.371   457.898     0.150
    40.371   458.793     0.150
    40.426   460.020     0.150
    40.426   458.000     0.150
    40.530   460.352     0.150
    40.585   459.680     0.150
    40.691   461.367     0.150
    40.691   461.852     0.150
    40.708   461.195     0.150
    40.751   461.547     0.150
    40.828   464.059     0.150
    40.828   462.762     0.150
    40.828   463.059     0.150
    40.841   462.035     0.150
    40.919   463.973     0.150
    41.047   464.289     0.150
    41.053   464.527     0.150
    41.069   464.883     0.150
    41.143   466.930     0.150
    41.202   466.438     0.150
    41.202   465.953     0.150
    41.246   465.879     0.150
    41.308   467.387     0.150
    41.330   466.508     0.150
    41.394   467.988     0.150
    41.394   467.719     0.150
    41.450   469.301     0.150
    41.709   470.590     0.150
    41.709   470.824     0.150
    41.821   471.461     0.150
    41.877   470.137     0.150
    41.877   470.895     0.150
    41.916   471.312     0.150
    41.927   471.461     0.150
    41.953   472.953     0.150
    41.997   472.527     0.150
    42.060   472.832     0.150
    42.273   474.219     0.150
    42.273   475.188     0.150
    42.531   477.812     0.150
    42.550   477.680     0.150
    42.780   479.180     0.150
    42.911   478.828     0.150
    43.018   480.379     0.150
    43.022   481.406     0.150
    43.221   483.137     0.150
    43.234   483.297     0.150
    43.516   485.270     0.150
    43.752   487.676     0.150
    43.766   487.484     0.150
    44.325   491.957     0.150
    45.407   499.148     0.150
    47.802   519.590     0.150
    48.054   518.207     0.150
    55.068   572.609     0.150
    61.104   613.637     0.150
    64.303   637.719     0.150
    66.144   648.559     0.150
    67.572   657.117     0.150
    69.980   671.988     0.150
    75.970   706.668     0.150
    75.970   707.398     0.150
    76.361   711.168     0.150
    78.528   722.117     0.150
    78.528   721.902     0.150
    78.476   721.395     0.150
    78.476   721.629     0.150
    81.672   740.020     0.150
    81.747   740.418     0.150
    82.069   741.520     0.150
    82.361   743.117     0.150
    82.703   744.918     0.150
    82.812   745.219     0.150
    82.812   744.707     0.150
    82.885   746.316     0.150
    83.037   746.367     0.150
    83.079   746.637     0.150
    83.129   748.168     0.150
    83.282   748.477     0.150
    83.399   748.508     0.150
    83.476   747.930     0.150
    83.611   751.219     0.150
    84.195   751.520     0.150
    84.744   754.895     0.150
    84.744   755.379     0.150
    86.177   761.918     0.150
    86.177   962.918     0.150
    87.609   770.578     0.150
    88.159   771.922     0.150
    88.208   772.203     0.150
    88.282   770.941     0.150
    88.282   771.129     0.150
    88.391   774.270     0.150
    88.471   774.953     0.150
    89.259   776.660     0.150
    89.411   777.859     0.150
    89.929   777.859     0.150
    90.285   780.617     0.150
    90.293   779.809     0.150
    90.391   781.113     0.150
    90.489   781.184     0.150
    92.857   792.918     0.150
    94.230   800.121     0.150
    97.279   812.219     0.150
    99.959   822.219     0.150
   123.291  1136.105     0.150
   123.291  1139.766     0.150
   124.053  1137.688     0.150
   124.053  1140.738     0.150
   125.416  1140.391     0.150
   125.416  1143.578     0.150
   126.985  1144.113     0.150
     0.609    11.266     0.150
     0.609    19.605     0.150
     0.626    12.664     0.150
     0.626    21.633     0.150
     0.753    14.574     0.150
     0.753    24.793     0.150
     0.753    24.895     0.150
     1.004    18.613     0.150
     1.004    34.074     0.150
     1.023    17.496     0.150
     1.065    19.793     0.150
     1.065    33.613     0.150
     1.065    19.633     0.150
     1.239    22.434     0.150
     1.228    23.125     0.150
     1.352    24.094     0.150
     1.352    42.504     0.150
     1.355    23.855     0.150
     1.379    24.043     0.150
     1.379    41.414     0.150
     1.379    23.895     0.150
     1.460    25.535     0.150
     1.513    26.004     0.150
     1.513    46.504     0.150
     1.564    26.633     0.150
     1.564    47.395     0.150
     1.608    27.664     0.150
     1.608    50.723     0.150
     1.608    51.285     0.150
     1.601    27.285     0.150
     1.601    47.465     0.150
     1.642    53.965     0.150
     1.765    28.074     0.150
     1.765    56.766     0.150
     1.841    31.066     0.150
     1.890    30.234     0.150
     1.955    30.934     0.150
     2.000    31.203     0.150
     2.000    57.094     0.150
     2.000    62.605     0.150
     2.000    35.125     0.150
     2.015    36.414     0.150
     2.136    34.586     0.150
     2.136    63.066     0.150
     2.192    34.793     0.150
     2.192    60.664     0.150
     2.201    35.473     0.150
     2.249    36.516     0.150
     2.303    73.355     0.150
     2.303    36.605     0.150
     2.346    38.023     0.150
     2.346    65.715     0.150
     2.460    39.684     0.150
     2.679    43.336     0.150
     2.723    43.074     0.150
     2.735    43.434     0.150
     2.735    86.543     0.150
     2.764    50.754     0.150
     2.858    45.934     0.150
     2.970    47.145     0.150
     3.129    49.473     0.150
     3.129    48.484     0.150
     3.129    86.723     0.150
     3.373    52.035     0.150
     3.609    56.926     0.150
     3.718    57.203     0.150
     4.237    63.285     0.150
     4.325    64.523     0.150
     4.316    64.746     0.150
     4.710    70.176     0.150
     4.766    72.504     0.150
     5.039    74.566     0.150
     5.661    83.016     0.150
     5.660    84.215     0.150
     5.921    88.105     0.150
     6.168    90.406     0.150
     6.517    96.996     0.150
     9.464   135.895     0.150
     9.464   135.625     0.150
     0.570    11.001     0.150
     0.570    18.951     0.150
     0.686    13.021     0.150
     0.686    22.461     0.150
     0.796    14.981     0.150
     0.796    26.381     0.150
     0.796    27.781     0.150
     0.936    18.201     0.150
     0.943    17.061     0.150
     0.943    29.161     0.150
     0.952    17.091     0.150
     1.052    19.351     0.150
     1.052    32.851     0.150
     1.155    22.221     0.150
     1.201    21.661     0.150
     1.201    38.041     0.150
     1.281    23.021     0.150
     1.318    23.891     0.150
     1.398    26.221     0.150
     1.403    24.531     0.150
     1.403    42.281     0.150
     1.441    25.561     0.150
     1.494    26.101     0.150
     1.534    27.041     0.150
     1.534    46.851     0.150
     1.606    27.601     0.150
     1.606    49.271     0.150
     1.694    28.851     0.150
     1.694    29.981     0.150
     1.770    28.981     0.150
     2.073    33.371     0.150
     2.068    35.641     0.150
     2.068    61.981     0.150
     2.189    36.671     0.150
     2.235    35.671     0.150
     2.655    42.521     0.150
     2.645    43.051     0.150
     2.690    42.331     0.150
     3.157    49.601     0.150
     3.302    51.041     0.150
     3.557    56.271     0.150
     4.175    64.991     0.150
     4.371    66.861     0.150
     4.684    71.101     0.150
     4.763    72.571     0.150
     4.989    74.801     0.150
     5.271    79.791     0.150
     5.593    82.841     0.150
     5.598    83.021     0.150
     5.693    84.981     0.150
     5.859    87.601     0.150
     6.117    90.971     0.150
     7.025   103.471     0.150
     0.345     7.596     0.150
     0.345    13.355     0.150
     1.298    21.105     0.150
     1.353    23.745     0.150
     1.353    40.575     0.150
     1.362    22.686     0.150
     1.362    24.596     0.150
     1.395    21.785     0.150
     1.469    23.775     0.150
     1.443    25.136     0.150
     1.564    25.216     0.150
     1.727    27.216     0.150
     1.727    30.605     0.150
     1.727    52.416     0.150
     1.786    58.396     0.150
     2.058    34.355     0.150
     2.141    34.006     0.150
     2.151    33.436     0.150
     2.189    34.315     0.150
     2.189    34.116     0.150
     2.155    37.115     0.150
     2.214    34.785     0.150
     2.936    54.396     0.150
     2.936    91.601     0.150
     3.067    94.692     0.150
     3.058    48.205     0.150
     3.058    83.226     0.150
     3.114    51.985     0.150
     3.283    59.781     0.150
     3.283   102.446     0.150
     3.638    65.146     0.150
     3.638   111.229     0.150
     3.911    67.321     0.150
     4.099    79.619     0.150
     4.234   127.988     0.150
     5.875    86.510     0.150
     0.640    11.785     0.150
     0.640    21.445     0.150
     0.735    13.535     0.150
     0.735    23.256     0.150
     0.735    24.795     0.150
     0.952    16.785     0.150
     1.052    19.055     0.150
     1.052    32.596     0.150
     1.052    34.115     0.150
     0.994    18.176     0.150
     0.994    31.596     0.150
     1.145    20.086     0.150
     1.364    23.936     0.150
     1.364    41.275     0.150
     1.406    26.045     0.150
     1.389    23.705     0.150
     1.669    26.875     0.150
     1.669    30.416     0.150
     1.669    47.395     0.150
     1.669    49.535     0.150
     1.886    32.965     0.150
     1.886    57.455     0.150
     1.918    32.285     0.150
     1.918    57.936     0.150
     1.940    32.814     0.150
     1.940    58.715     0.150
     1.940    60.635     0.150
     2.068    33.680     0.150
     2.068    33.535     0.150
     2.068    57.686     0.150
     2.185    40.098     0.150
     2.185    66.965     0.150
     2.110    34.826     0.150
     2.218    35.125     0.150
     2.218    60.234     0.150
     2.149    34.025     0.150
     2.309    35.975     0.150
     2.309    63.686     0.150
     2.333    42.621     0.150
     2.530    45.873     0.150
     2.530    77.404     0.150
     2.888    50.455     0.150
     2.888    86.729     0.150
     3.160    57.801     0.150
     3.160    97.582     0.150
     3.167    58.025     0.150
     3.167    97.953     0.150
     3.481   105.867     0.150
     3.751    57.436     0.150
     3.751   100.676     0.150
     3.766    56.916     0.150
     3.920    71.822     0.150
     5.892    87.564     0.150
     0.314     6.145     0.150
     0.314    11.926     0.150
     1.327    20.906     0.150
     1.395    22.508     0.150
     1.395    38.625     0.150
     1.395    41.836     0.150
     1.474    23.758     0.150
     1.474    43.516     0.150
     1.316    21.906     0.150
     1.316    36.984     0.150
     1.316    22.055     0.150
     1.514    22.918     0.150
     1.369    21.617     0.150
     1.593    25.078     0.150
     1.593    24.965     0.150
     1.829    28.828     0.150
     1.717    26.707     0.150
     1.717    26.977     0.150
     2.213    33.637     0.150
     2.213    33.984     0.150
     2.377    36.016     0.150
     2.421    38.055     0.150
     2.421    64.586     0.150
     2.463    37.168     0.150
     2.332    35.516     0.150
     2.706    40.258     0.150
     2.676    40.027     0.150
     2.927    42.527     0.150
     2.966    44.395     0.150
     2.981    44.270     0.150
     2.981    91.410     0.150
     3.008    45.285     0.150
     3.008    45.137     0.150
     3.008    78.785     0.150
     3.112    45.816     0.150
     3.165    47.688     0.150
     3.081    46.945     0.150
     3.081    46.555     0.150
     3.081    87.367     0.150
     3.286    49.734     0.150
     3.328    49.344     0.150
     3.328   100.680     0.150
     3.380    51.367     0.150
     3.301    48.305     0.150
     3.301    92.035     0.150
     3.629    54.516     0.150
     3.682    55.445     0.150
     3.682    53.715     0.150
     3.690    54.957     0.150
     3.690    55.215     0.150
     3.690    54.637     0.150
     3.690   121.719     0.150
     3.690    55.465     0.150
     3.956    57.719     0.150
     3.956    58.602     0.150
     3.956   122.324     0.150
     3.956    62.465     0.150
     3.956    58.047     0.150
     3.955    58.688     0.150
     4.098    60.879     0.150
     4.279    61.188     0.150
     4.186    62.336     0.150
     4.462    66.355     0.150
     4.710    87.039     0.150
     4.710   142.762     0.150
     4.803    71.121     0.150
     4.906    73.098     0.150
     4.977    74.348     0.150
     5.043    74.805     0.150
     5.279   160.582     0.150
     5.598   103.754     0.150
     5.616    82.465     0.150
     5.712    84.336     0.150
     5.864   106.082     0.150
     5.905    87.617     0.150
     5.905    88.055     0.150
     5.905   188.621     0.150
     5.983   190.785     0.150
     6.075   112.559     0.150
     6.075   184.785     0.150
     6.091    89.566     0.150
     6.037    88.785     0.150
     6.037    88.336     0.150
     6.037   194.926     0.150
     6.320   202.293     0.150
     6.276    93.168     0.150
     6.276   200.340     0.150
     6.416    94.598     0.150
     6.487    94.965     0.150
     6.516    95.883     0.150
     6.516   198.688     0.150
     6.505    95.875     0.150
     6.569    94.375     0.150
     6.946   102.965     0.150
     6.928   101.668     0.150
     6.984   103.027     0.150
     7.014   103.777     0.150
     6.947   105.703     0.150
     6.947   224.527     0.150
     7.301   107.215     0.150
     7.484   108.055     0.150
     7.522   110.477     0.150
     7.588   111.395     0.150
     7.609   112.316     0.150
     7.556   112.477     0.150
     7.556   112.668     0.150
     7.786   116.125     0.150
     8.088   118.438     0.150
     8.031   115.395     0.150
     8.155   117.855     0.150
     8.155   117.332     0.150
     8.155   250.176     0.150
     8.155   119.215     0.150
     8.284   120.625     0.150
     8.284   118.625     0.150
     8.327   121.965     0.150
     8.194   118.297     0.150
     8.194   121.145     0.150
     8.548   124.477     0.150
     8.546   124.047     0.150
     8.546   125.172     0.150
     8.546   125.707     0.150
     8.860   128.547     0.150
     8.914   128.965     0.150
     8.941   131.734     0.150
     8.941   279.309     0.150
     9.139   132.977     0.150
     9.188   133.105     0.150
     9.240   132.348     0.150
     9.240   133.977     0.150
     9.240   287.199     0.150
     9.972   147.555     0.150
    10.062   149.188     0.150
    10.106   146.867     0.150
    10.124   150.137     0.150
    10.124   147.004     0.150
    10.124   148.637     0.150
    10.449   153.938     0.150
    10.519   152.184     0.150
    10.634   155.207     0.150
    10.634   152.781     0.150
    10.747   156.246     0.150
    10.830   158.645     0.150
    10.783   155.637     0.150
    10.783   156.008     0.150
    10.842   158.965     0.150
    11.137   160.586     0.150
    11.217   161.996     0.150
    11.263   164.035     0.150
    11.699   169.266     0.150
    12.874   184.945     0.150
    12.875   184.465     0.150
    12.769   182.984     0.150
    12.769   185.945     0.150
    13.174   189.066     0.150
    13.174   187.117     0.150
    13.174   189.098     0.150
    13.453   193.223     0.150
    13.890   196.508     0.150
    13.856   194.496     0.150
    13.869   196.445     0.150
    14.391   206.547     0.150
    14.300   201.996     0.150
    14.547   206.746     0.150
    14.562   206.418     0.150
    14.523   206.008     0.150
    14.580   206.418     0.150
    14.567   205.566     0.150
    14.844   209.867     0.150
    14.906   207.445     0.150
    14.952   215.277     0.150
    15.028   213.078     0.150
    15.085   212.484     0.150
    15.276   213.836     0.150
    15.486   218.734     0.150
    15.476   217.527     0.150
    15.727   218.746     0.150
    15.882   222.895     0.150
    16.000   222.055     0.150
    15.959   224.305     0.150
    15.959   226.566     0.150
    16.160   226.176     0.150
    16.160   229.117     0.150
    16.307   231.457     0.150
    16.522   230.195     0.150
    16.522   229.777     0.150
    16.699   236.426     0.150
    16.893   239.195     0.150
    17.046   236.188     0.150
    17.225   239.938     0.150
    17.685   247.426     0.150
    18.214   252.355     0.150
    18.255   254.148     0.150
    18.179   252.715     0.150
    18.298   252.156     0.150
    18.635   256.645     0.150
    18.734   257.688     0.150
    18.923   260.367     0.150
    19.431   267.176     0.150
    19.526   265.945     0.150
    19.531   269.098     0.150
    19.583   265.785     0.150
    19.670   266.977     0.150
    19.880   273.168     0.150
    19.898   271.426     0.150
    20.414   276.836     0.150
    20.464   276.668     0.150
    20.603   279.656     0.150
    20.631   280.918     0.150
    20.989   283.984     0.150
    21.064   282.676     0.150
    21.209   284.496     0.150
    21.276   285.457     0.150
    21.335   283.996     0.150
    21.525   290.195     0.150
    21.644   290.426     0.150
    21.648   290.566     0.150
    21.741   289.926     0.150
    22.029   293.246     0.150
    21.939   295.398     0.150
    22.041   293.328     0.150
    22.075   293.695     0.150
    22.568   299.797     0.150
    23.096   306.586     0.150
    23.062   304.086     0.150
    23.251   306.965     0.150
    23.377   307.816     0.150
    23.593   308.328     0.150
    23.879   312.348     0.150
    23.971   311.996     0.150
    24.057   313.078     0.150
    24.027   313.848     0.150
    24.116   316.355     0.150
    24.186   317.734     0.150
    24.246   317.895     0.150
    24.245   314.496     0.150
    24.347   319.047     0.150
    24.404   315.984     0.150
    24.404   317.758     0.150
    24.338   316.797     0.150
    24.464   319.305     0.150
    24.564   319.305     0.150
    24.583   319.285     0.150
    24.844   321.406     0.150
    24.941   321.035     0.150
    25.251   326.227     0.150
    25.199   326.496     0.150
    25.306   325.516     0.150
    26.131   334.695     0.150
    26.131   335.316     0.150
    26.126   331.406     0.150
    26.126   334.102     0.150
    26.624   338.535     0.150
    26.857   338.496     0.150
    27.359   344.918     0.150
    27.832   346.676     0.150
    27.956   348.457     0.150
    30.565   376.766     0.150
    31.210   379.508     0.150
    32.386   389.961     0.150
    39.865   456.277     0.150
    40.199   457.324     0.150
    42.740   478.176     0.150
    45.690   503.578     0.150
    58.458   597.367     0.150
    84.216   750.496     0.150
    86.597  1402.156     0.150
    86.597  1455.156     0.150
    94.244   801.773     0.150
     0.615    12.148     0.150
     0.875    16.344     0.150
     0.875    27.398     0.150
     0.913    16.594     0.150
     0.913    29.016     0.150
     1.123    20.094     0.150
     1.106    19.414     0.150
     1.123    20.758     0.150
     1.443    24.992     0.150
     1.443    44.633     0.150
     1.517    25.562     0.150
     1.549    25.859     0.150
     1.549    44.227     0.150
     1.549    26.094     0.150
     1.501    26.055     0.150
     1.501    46.164     0.150
     1.664    28.258     0.150
     1.682    28.969     0.150
     1.699    28.273     0.150
     1.699    49.289     0.150
     2.519    41.812     0.150
     2.519    71.797     0.150
     3.205    49.180     0.150
     3.288    56.578     0.150
     3.397    53.766     0.150
     4.029    61.734     0.150
     4.029    62.289     0.150
     4.029   110.633     0.150
     4.187    66.758     0.150
     5.378    80.617     0.150
     5.378   139.242     0.150
     5.677    84.984     0.150
     8.204   123.562     0.150
     9.247   135.984     0.150
     9.821   143.297     0.150
    12.368   181.086     0.150
    17.447   246.852     0.150
    23.661   310.836     0.150
    31.565   384.453     0.150
    39.456   452.484     0.150
     0.591    11.398     0.150
     0.591    20.086     0.150
     0.591    21.039     0.150
     0.591    21.453     0.150
     0.826    14.672     0.150
     0.826    26.258     0.150
     0.839    15.188     0.150
     0.839    27.109     0.150
     1.018    18.344     0.150
     1.018    32.328     0.150
     1.061    18.633     0.150
     1.061    31.227     0.150
     1.061    18.734     0.150
     1.061    33.047     0.150
     1.214    19.734     0.150
     1.286    22.164     0.150
     1.286    39.789     0.150
     1.378    23.633     0.150
     1.378    23.344     0.150
     1.416    24.195     0.150
     1.472    24.773     0.150
     1.490    25.109     0.150
     1.525    25.992     0.150
     1.518    24.977     0.150
     1.518    25.188     0.150
     1.518    44.023     0.150
     1.518    45.453     0.150
     1.590    26.016     0.150
     1.595    26.305     0.150
     1.595    27.109     0.150
     1.595    45.555     0.150
     1.595    47.078     0.150
     1.646    28.617     0.150
     1.652    27.484     0.150
     1.652    28.938     0.150
     1.652    28.188     0.150
     1.756    28.977     0.150
     1.729    27.078     0.150
     1.729    49.297     0.150
     1.769    29.219     0.150
     1.814    29.984     0.150
     1.896    32.062     0.150
     1.972    31.727     0.150
     2.030    32.633     0.150
     2.049    32.312     0.150
     2.070    33.438     0.150
     2.139    33.375     0.150
     2.157    34.039     0.150
     2.216    34.344     0.150
     2.216    35.406     0.150
     2.239    35.289     0.150
     2.239    36.289     0.150
     2.247    36.672     0.150
     2.268    35.828     0.150
     2.323    36.031     0.150
     2.434    38.984     0.150
     2.434    38.719     0.150
     2.434    70.023     0.150
     2.505    39.484     0.150
     2.505    65.867     0.150
     2.535    39.555     0.150
     2.625    41.406     0.150
     2.625    74.578     0.150
     2.646    41.039     0.150
     2.716    41.594     0.150
     2.807    43.883     0.150
     2.818    44.039     0.150
     3.062    47.828     0.150
     3.062    47.562     0.150
     3.071    47.414     0.150
     3.174    48.906     0.150
     3.178    48.570     0.150
     3.185    48.766     0.150
     3.185    48.602     0.150
     3.185    50.938     0.150
     3.185    49.422     0.150
     3.205    49.086     0.150
     3.198    48.445     0.150
     3.198    49.500     0.150
     3.198    48.219     0.150
     3.198    86.734     0.150
     3.198    48.727     0.150
     3.310    51.094     0.150
     3.484    52.812     0.150
     3.484    52.625     0.150
     3.484    92.609     0.150
     3.582    53.812     0.150
     3.733    56.688     0.150
     3.754    56.117     0.150
     3.925    59.539     0.150
     4.060    60.586     0.150
     4.081    60.898     0.150
     4.081   107.094     0.150
     4.108    62.477     0.150
     4.147    64.352     0.150
     4.174    62.789     0.150
     4.259    65.430     0.150
     4.253    64.812     0.150
     4.307    65.133     0.150
     4.284    63.406     0.150
     4.284   115.828     0.150
     4.478    67.023     0.150
     4.572    68.078     0.150
     4.610    69.445     0.150
     4.629    69.758     0.150
     4.704    69.492     0.150
     4.769    71.383     0.150
     4.769    71.625     0.150
     5.010    74.898     0.150
     5.066    75.789     0.150
     5.066    76.406     0.150
     5.141    77.906     0.150
     5.181    76.547     0.150
     5.289    79.609     0.150
     5.385    79.688     0.150
     5.426    80.477     0.150
     5.426   141.055     0.150
     5.508    82.953     0.150
     5.522    81.805     0.150
     5.547    83.172     0.150
     5.547    83.344     0.150
     5.612    83.383     0.150
     5.698    86.320     0.150
     5.685    84.523     0.150
     5.685    83.969     0.150
     5.820    86.484     0.150
     5.820    87.523     0.150
     5.840    86.383     0.150
     6.014    88.359     0.150
     6.063    90.758     0.150
     6.076    89.953     0.150
     6.269    94.117     0.150
     6.277    94.352     0.150
     6.445    98.289     0.150
     6.488    95.203     0.150
     6.488    97.133     0.150
     6.535    96.484     0.150
     6.584    95.547     0.150
     6.608    97.648     0.150
     6.643    98.812     0.150
     6.708    98.336     0.150
     6.732    98.406     0.150
     6.872   101.906     0.150
     6.872   103.836     0.150
     7.034   102.562     0.150
     7.138   103.984     0.150
     7.187   106.367     0.150
     7.378   106.547     0.150
     7.378   108.023     0.150
     7.440   107.836     0.150
     7.460   109.273     0.150
     7.484   109.328     0.150
     7.528   109.812     0.150
     7.594   111.156     0.150
     7.594   110.492     0.150
     7.602   111.938     0.150
     7.602   111.438     0.150
     7.602   113.203     0.150
     7.630   112.562     0.150
     7.644   112.492     0.150
     7.702   112.516     0.150
     7.694   112.578     0.150
     7.735   110.312     0.150
     7.775   114.016     0.150
     7.775   114.312     0.150
     7.775   115.062     0.150
     7.913   115.492     0.150
     7.942   115.289     0.150
     7.947   117.273     0.150
     7.998   116.766     0.150
     8.010   117.398     0.150
     8.051   117.523     0.150
     8.099   117.188     0.150
     8.099   122.016     0.150
     8.145   118.203     0.150
     8.251   119.758     0.150
     8.281   119.695     0.150
     8.336   122.812     0.150
     8.336   123.672     0.150
     8.352   120.094     0.150
     8.540   125.883     0.150
     8.590   123.695     0.150
     8.599   124.289     0.150
     8.606   125.805     0.150
     8.629   124.727     0.150
     8.885   128.039     0.150
     8.882   129.359     0.150
     8.928   128.125     0.150
     9.068   129.125     0.150
     9.156   131.977     0.150
     9.142   132.875     0.150
     9.165   133.094     0.150
     9.203   132.125     0.150
     9.209   133.016     0.150
     9.209   132.633     0.150
     9.209   135.398     0.150
     9.265   132.523     0.150
     9.297   135.016     0.150
     9.298   135.156     0.150
     9.298   134.859     0.150
     9.298   288.898     0.150
     9.506   136.062     0.150
     9.616   137.148     0.150
     9.633   138.016     0.150
     9.682   137.727     0.150
     9.720   139.453     0.150
     9.720   144.148     0.150
     9.720   309.148     0.150
     9.840   141.414     0.150
     9.833   141.469     0.150
     9.833   143.531     0.150
     9.828   142.188     0.150
     9.886   141.648     0.150
     9.914   142.609     0.150
    10.022   145.516     0.150
    10.106   146.133     0.150
    10.106   148.109     0.150
    10.160   146.109     0.150
    10.160   147.883     0.150
    10.299   147.594     0.150
    10.299   149.219     0.150
    10.313   147.188     0.150
    10.349   148.359     0.150
    10.460   149.258     0.150
    10.500   151.516     0.150
    10.763   159.266     0.150
    10.763   153.758     0.150
    10.783   154.156     0.150
    10.855   155.078     0.150
    10.975   157.617     0.150
    10.988   158.578     0.150
    11.210   162.242     0.150
    11.210   164.883     0.150
    11.215   163.062     0.150
    11.881   170.422     0.150
    11.900   171.344     0.150
    11.968   171.047     0.150
    11.968   175.562     0.150
    12.285   175.422     0.150
    12.285   178.562     0.150
    12.285   389.320     0.150
    12.326   175.258     0.150
    12.388   176.508     0.150
    12.388   176.383     0.150
    12.411   177.914     0.150
    12.464   177.148     0.150
    12.423   178.328     0.150
    12.423   179.367     0.150
    12.445   178.086     0.150
    12.502   178.805     0.150
    12.502   178.695     0.150
    12.506   178.922     0.150
    12.506   179.586     0.150
    12.591   179.555     0.150
    12.663   181.555     0.150
    12.698   181.859     0.150
    12.704   182.062     0.150
    12.751   182.117     0.150
    12.823   182.469     0.150
    12.820   184.148     0.150
    12.831   183.398     0.150
    12.896   184.047     0.150
    12.984   185.219     0.150
    13.032   187.453     0.150
    13.044   185.062     0.150
    13.008   186.922     0.150
    13.097   185.414     0.150
    13.180   191.734     0.150
    13.495   193.219     0.150
    13.495   193.367     0.150
    13.856   197.062     0.150
    13.936   197.375     0.150
    13.943   197.617     0.150
    13.981   198.969     0.150
    13.996   198.164     0.150
    14.029   198.547     0.150
    14.095   205.234     0.150
    14.173   201.758     0.150
    14.184   200.375     0.150
    14.184   202.344     0.150
    14.285   207.398     0.150
    14.280   202.164     0.150
    14.295   203.523     0.150
    14.295   204.602     0.150
    14.351   202.008     0.150
    14.343   203.727     0.150
    14.364   203.953     0.150
    14.412   204.383     0.150
    14.404   205.219     0.150
    14.484   205.375     0.150
    14.558   205.703     0.150
    14.565   207.148     0.150
    14.588   206.727     0.150
    14.588   207.039     0.150
    14.567   207.688     0.150
    14.677   208.344     0.150
    14.677   207.352     0.150
    14.703   213.297     0.150
    14.684   208.055     0.150
    14.722   209.625     0.150
    15.339   217.398     0.150
    15.898   226.055     0.150
    15.898   225.227     0.150
    16.129   521.336     0.150
    16.129   228.477     0.150
    16.498   231.594     0.150
    16.498   232.008     0.150
    16.569   235.773     0.150
    16.569   233.734     0.150
    16.665   233.969     0.150
    16.747   235.383     0.150
    16.726   236.719     0.150
    16.809   235.805     0.150
    17.305   241.102     0.150
    17.345   244.531     0.150
    17.345   245.359     0.150
    17.711   248.016     0.150
    17.711   248.688     0.150
    17.986   252.039     0.150
    19.012   264.484     0.150
    19.552   268.398     0.150
    19.558   268.742     0.150
    19.832   270.492     0.150
    19.859   272.062     0.150
    19.955   272.828     0.150
    20.029   274.953     0.150
    20.157   275.961     0.150
    20.175   276.227     0.150
    20.543   281.516     0.150
    21.924   294.766     0.150
    22.198   297.461     0.150
    22.198   297.586     0.150
    22.245   298.172     0.150
    22.259   297.008     0.150
    22.282   297.477     0.150
    22.282   299.883     0.150
    22.446   301.992     0.150
    22.540   302.188     0.150
    22.540   302.609     0.150
    23.149   309.023     0.150
    23.596   311.367     0.150
    23.596   748.766     0.150
    23.596   310.547     0.150
    23.845   315.102     0.150
    24.020   315.078     0.150
    24.020   316.672     0.150
    24.020   314.375     0.150
    24.025   315.523     0.150
    24.210   317.469     0.150
    24.210   318.336     0.150
    24.223   318.156     0.150
    24.275   317.547     0.150
    24.532   320.578     0.150
    24.580   320.195     0.150
    24.898   324.062     0.150
    25.020   324.844     0.150
    25.023   325.688     0.150
    25.086   326.094     0.150
    25.184   325.805     0.150
    25.244   326.414     0.150
    25.262   325.984     0.150
    25.262   329.164     0.150
    25.464   328.625     0.150
    25.452   328.992     0.150
    25.452   330.969     0.150
    25.560   329.156     0.150
    25.570   328.344     0.150
    25.799   331.523     0.150
    25.862   331.719     0.150
    25.962   333.008     0.150
    25.950   334.438     0.150
    26.024   332.047     0.150
    26.018   334.047     0.150
    26.018   336.000     0.150
    26.087   336.359     0.150
    26.162   335.312     0.150
    26.162   337.023     0.150
    26.187   335.328     0.150
    26.249   337.039     0.150
    26.422   337.227     0.150
    26.481   337.414     0.150
    26.583   338.742     0.150
    26.707   340.359     0.150
    26.837   341.445     0.150
    26.889   341.688     0.150
    26.889   342.883     0.150
    27.234   346.188     0.150
    27.439   348.094     0.150
    27.582   347.805     0.150
    27.594   346.648     0.150
    27.877   351.094     0.150
    27.882   350.773     0.150
    28.190   353.898     0.150
    28.228   354.992     0.150
    28.368   356.102     0.150
    28.371   355.516     0.150
    28.556   358.172     0.150
    28.597   355.266     0.150
    28.825   360.672     0.150
    28.855   359.445     0.150
    28.953   358.672     0.150
    29.450   366.141     0.150
    29.454   366.656     0.150
    29.829   368.352     0.150
    29.858   368.742     0.150
    29.937   368.977     0.150
    30.489   373.453     0.150
    30.526   374.680     0.150
    30.668   376.664     0.150
    30.795   378.156     0.150
    30.872   378.586     0.150
    31.420   381.992     0.150
    31.468   382.969     0.150
    31.468   556.039     0.150
    31.705   384.812     0.150
    31.781   386.719     0.150
    31.857   385.953     0.150
    32.405   391.273     0.150
    32.579   393.094     0.150
    32.637   391.164     0.150
    32.637   394.414     0.150
    32.665   393.562     0.150
    32.806   396.289     0.150
    33.069   397.203     0.150
    33.243   398.758     0.150
    33.448   400.211     0.150
    33.453   401.320     0.150
    33.574   402.195     0.150
    33.805   404.086     0.150
    33.784   403.703     0.150
    33.883   404.734     0.150
    33.913   405.641     0.150
    34.283   409.508     0.150
    34.283   407.945     0.150
    34.496   409.852     0.150
    34.582   411.297     0.150
    34.739   412.492     0.150
    34.855   412.578     0.150
    35.093   415.719     0.150
    35.173   415.922     0.150
    35.223   416.586     0.150
    35.532   417.023     0.150
    35.532   420.211     0.150
    35.701   419.438     0.150
    35.779   421.562     0.150
    35.967   423.586     0.150
    35.990   422.797     0.150
    35.990   421.258     0.150
    36.054   420.844     0.150
    36.054   424.375     0.150
    36.283   424.742     0.150
    36.283   426.812     0.150
    36.423   424.156     0.150
    36.423   427.094     0.150
    36.425   425.297     0.150
    36.443   425.867     0.150
    36.443   427.469     0.150
    36.551   426.508     0.150
    36.561   426.305     0.150
    36.561   428.227     0.150
    36.638   426.945     0.150
    36.638   428.188     0.150
    36.839   428.938     0.150
    36.839   430.078     0.150
    37.006   430.242     0.150
    37.006   432.695     0.150
    37.062   429.727     0.150
    37.164   433.328     0.150
    37.314   434.719     0.150
    37.314   434.797     0.150
    37.361   432.844     0.150
    37.361   436.250     0.150
    37.549   434.609     0.150
    37.549   435.578     0.150
    37.594   435.156     0.150
    37.594   436.656     0.150
    37.657   437.703     0.150
    37.675   438.102     0.150
    37.675   438.812     0.150
    37.705   436.227     0.150
    37.705   437.789     0.150
    37.776   437.383     0.150
    37.871   438.766     0.150
    37.881   439.125     0.150
    37.887   437.422     0.150
    37.887   438.719     0.150
    37.904   440.086     0.150
    38.005   439.055     0.150
    38.005   439.617     0.150
    38.071   439.172     0.150
    38.071   441.516     0.150
    38.103   439.016     0.150
    38.129   438.906     0.150
    38.129   440.969     0.150
    38.149   439.938     0.150
    38.149   440.836     0.150
    38.178   440.797     0.150
    38.233   441.578     0.150
    38.305   441.516     0.150
    38.333   443.883     0.150
    38.372   441.133     0.150
    38.372   444.125     0.150
    38.388   443.414     0.150
    38.438   442.859     0.150
    38.619   445.453     0.150
    38.625   444.625     0.150
    38.627   445.359     0.150
    38.629   445.766     0.150
    38.675   446.766     0.150
    38.762   447.156     0.150
    38.764   445.367     0.150
    38.772   446.453     0.150
    38.772   447.203     0.150
    38.904   448.156     0.150
    38.968   446.664     0.150
    38.968   447.953     0.150
    39.056   448.773     0.150
    39.123   448.273     0.150
    39.123   447.992     0.150
    39.223   447.875     0.150
    39.223   449.125     0.150
    39.239   448.211     0.150
    39.335   449.492     0.150
    39.335   450.234     0.150
    39.340   449.367     0.150
    39.351   449.328     0.150
    39.351   449.609     0.150
    39.351   450.164     0.150
    39.389   450.508     0.150
    39.389   450.375     0.150
    39.440   452.117     0.150
    39.461   451.367     0.150
    39.461   453.180     0.150
    39.533   451.695     0.150
    39.616   453.703     0.150
    39.631   452.062     0.150
    39.631   453.164     0.150
    39.647   453.945     0.150
    39.725   455.422     0.150
    39.758   455.656     0.150
    39.799   455.539     0.150
    39.799   455.172     0.150
    39.844   456.188     0.150
    39.934   455.531     0.150
    39.998   457.258     0.150
    40.037   456.898     0.150
    40.084   457.570     0.150
    40.261   458.906     0.150
    40.274   458.398     0.150
    40.317   459.555     0.150
    40.321   460.133     0.150
    40.338   460.242     0.150
    40.358   457.633     0.150
    40.358   459.742     0.150
    40.385   457.078     0.150
    40.385   459.922     0.150
    40.389   459.172     0.150
    40.417   459.250     0.150
    40.460   461.375     0.150
    40.466   458.578     0.150
    40.466   460.305     0.150
    40.522   462.055     0.150
    40.603   460.562     0.150
    40.615   461.961     0.150
    40.648   459.477     0.150
    40.648   462.758     0.150
    40.693   463.938     0.150
    40.700   462.867     0.150
    40.765   461.227     0.150
    40.765   463.438     0.150
    40.803   463.625     0.150
    40.835   461.836     0.150
    40.835   464.352     0.150
    40.842   463.617     0.150
    40.863   463.469     0.150
    40.966   462.258     0.150
    40.966   464.891     0.150
    41.001   466.766     0.150
    41.005   463.742     0.150
    41.180   467.422     0.150
    41.272   465.688     0.150
    41.272   467.938     0.150
    41.341   465.719     0.150
    41.341   468.023     0.150
    41.371   466.047     0.150
    41.371   469.336     0.150
    41.412   466.008     0.150
    41.412   469.047     0.150
    41.433   466.266     0.150
    41.433   468.484     0.150
    41.447   465.578     0.150
    41.447   468.188     0.150
    41.485   469.508     0.150
    41.489   469.406     0.150
    41.492   469.320     0.150
    41.514   470.234     0.150
    41.518   470.422     0.150
    41.550   470.609     0.150
    41.617   470.727     0.150
    41.835   468.227     0.150
    41.835   472.766     0.150
    41.835   471.258     0.150
    41.835   472.875     0.150
    41.893   469.938     0.150
    41.893   472.742     0.150
    41.912   469.875     0.150
    41.912   473.070     0.150
    41.997   473.758     0.150
    42.011   470.195     0.150
    42.011   473.797     0.150
    42.038   471.203     0.150
    42.038   473.766     0.150
    42.040   474.062     0.150
    42.103   472.555     0.150
    42.103   475.453     0.150
    42.206   475.266     0.150
    42.308   473.586     0.150
    42.308   474.648     0.150
    42.343   475.664     0.150
    42.353   472.547     0.150
    42.353   475.719     0.150
    42.401   477.875     0.150
    42.444   477.266     0.150
    42.460   473.039     0.150
    42.460   477.422     0.150
    42.569   478.750     0.150
    42.786   477.406     0.150
    42.786   479.594     0.150
    42.946   478.656     0.150
    42.946   481.023     0.150
    42.998   478.859     0.150
    42.998   481.742     0.150
    43.011   481.750     0.150
    43.075   479.398     0.150
    43.075   482.398     0.150
    43.304   484.039     0.150
    43.315   484.109     0.150
    43.478   485.148     0.150
    43.503   485.664     0.150
    43.505   485.859     0.150
    43.562   484.562     0.150
    43.562   485.273     0.150
    43.572   486.188     0.150
    43.606   484.883     0.150
    43.606   485.266     0.150
    43.619   486.195     0.150
    43.796   488.344     0.150
    43.803   487.828     0.150
    43.875   486.594     0.150
    43.875   488.164     0.150
    43.890   486.625     0.150
    43.890   488.430     0.150
    43.977   486.922     0.150
    43.977   488.297     0.150
    43.982   487.961     0.150
    44.163   487.758     0.150
    44.163   490.648     0.150
    44.321   490.234     0.150
    44.321   492.359     0.150
    44.360   491.797     0.150
    44.444   493.547     0.150
    44.516   493.844     0.150
    44.520   494.070     0.150
    44.562   494.922     0.150
    44.685   495.391     0.150
    44.736   495.758     0.150
    44.708   494.703     0.150
    44.835   496.820     0.150
    44.834   496.539     0.150
    44.932   496.516     0.150
    44.932   494.984     0.150
    44.932   496.938     0.150
    45.104   495.789     0.150
    45.104   498.078     0.150
    45.169   496.375     0.150
    45.169   498.406     0.150
    45.171   497.227     0.150
    45.171   499.039     0.150
    45.416   498.492     0.150
    45.416   500.625     0.150
    45.585   502.086     0.150
    45.672   502.875     0.150
    45.628   502.109     0.150
    45.628   500.438     0.150
    45.695   502.125     0.150
    45.740   502.023     0.150
    45.740   503.922     0.150
    45.755   503.789     0.150
    45.812   504.438     0.150
    45.845   504.125     0.150
    45.948   505.000     0.150
    45.950   502.859     0.150
    45.950   505.250     0.150
    46.104   504.945     0.150
    46.104   506.656     0.150
    46.216   506.508     0.150
    46.373   507.852     0.150
    46.387   508.609     0.150
    46.490   509.414     0.150
    46.660   509.664     0.150
    46.762   511.164     0.150
    46.774   510.945     0.150
    46.969   512.320     0.150
    47.313   514.664     0.150
    47.406   514.859     0.150
    47.406   516.328     0.150
    48.054   520.906     0.150
    48.215   521.367     0.150
    48.215   522.359     0.150
    49.850   532.922     0.150
    54.168   564.523     0.150
    55.889   577.875     0.150
    56.443   581.375     0.150
    56.443   583.203     0.150
    57.641   593.125     0.150
    61.310   613.797     0.150
    61.310   615.859     0.150
    66.200   648.938     0.150
    68.495   663.188     0.150
    68.678   662.625     0.150
    75.834   706.984     0.150
    78.116   720.258     0.150
    78.652   722.016     0.150
    78.794   722.039     0.150
    79.623   727.266     0.150
    82.381   742.414     0.150
    82.525   744.203     0.150
    82.764   747.094     0.150
    82.968   746.992     0.150
    83.190   748.266     0.150
    83.687   751.422     0.150
    83.830   749.516     0.150
    84.190   753.977     0.150
    84.234   752.227     0.150
    84.262   754.414     0.150
    84.293   754.016     0.150
    84.447   753.414     0.150
    84.516   754.336     0.150
    85.791   760.266     0.150
    92.393   793.367     0.150
    92.439   790.492     0.150
    93.429   795.742     0.150
   121.367  1135.562     0.150
   144.902  1176.742     0.150
     0.619    12.453     0.150
     0.619    20.898     0.150
     0.924    16.531     0.150
     0.924    29.977     0.150
     0.880    17.023     0.150
     0.880    16.523     0.150
     0.880    28.289     0.150
     1.112    20.148     0.150
     1.112    35.047     0.150
     1.136    20.281     0.150
     1.112    20.969     0.150
     1.452    25.281     0.150
     1.503    26.531     0.150
     1.503    46.008     0.150
     1.553    26.430     0.150
     1.553    47.312     0.150
     1.693    29.141     0.150
     1.693    53.891     0.150
     1.656    28.352     0.150
     1.768    32.969     0.150
     1.813    30.828     0.150
     1.854    30.938     0.150
     1.867    30.633     0.150
     1.931    32.289     0.150
     2.012    34.539     0.150
     2.148    40.469     0.150
     2.163    39.367     0.150
     2.187    35.594     0.150
     2.187    34.969     0.150
     2.268    41.820     0.150
     2.268    36.703     0.150
     2.322    37.641     0.150
     2.322    38.000     0.150
     2.326    38.547     0.150
     2.325    35.758     0.150
     2.377    38.664     0.150
     2.438    39.055     0.150
     2.530    41.250     0.150
     2.530    40.461     0.150
     2.530    77.391     0.150
     2.604    41.000     0.150
     2.604    75.508     0.150
     2.638    41.820     0.150
     2.734    43.922     0.150
     2.749    44.508     0.150
     2.749    44.320     0.150
     2.829    45.242     0.150
     2.914    46.227     0.150
     2.925    45.836     0.150
     3.165    49.211     0.150
     3.165    49.953     0.150
     3.161    50.242     0.150
     3.206    52.102     0.150
     3.206    51.930     0.150
     3.206    50.797     0.150
     3.206    93.250     0.150
     3.290    52.258     0.150
     3.293    50.883     0.150
     3.300    53.000     0.150
     3.300    50.867     0.150
     3.300    54.492     0.150
     3.300   110.117     0.150
     3.322    50.781     0.150
     3.365    52.297     0.150
     3.428    54.023     0.150
     3.386    55.367     0.150
     3.691    57.664     0.150
     3.863    60.062     0.150
     4.023    71.844     0.150
     4.023   110.352     0.150
     4.166    64.148     0.150
     4.175    64.742     0.150
     4.222    66.328     0.150
     4.292    67.234     0.150
     4.419    68.555     0.150
     4.680    70.562     0.150
     4.727    71.859     0.150
     4.818    73.844     0.150
     4.887    74.328     0.150
     4.887    73.461     0.150
     5.058    76.922     0.150
     5.144    78.320     0.150
     5.144    77.320     0.150
     5.303    79.523     0.150
     5.295    79.609     0.150
     5.503    82.844     0.150
     5.622    84.359     0.150
     5.601    85.008     0.150
     5.601    85.312     0.150
     5.640    84.641     0.150
     5.726    86.625     0.150
     5.706    85.320     0.150
     5.676    86.359     0.150
     5.676    85.922     0.150
     5.676   148.977     0.150
     5.935    87.711     0.150
     5.935    89.164     0.150
     5.947    87.133     0.150
     6.117    90.406     0.150
     6.168    93.180     0.150
     6.176    91.406     0.150
     6.193    91.633     0.150
     6.390    95.688     0.150
     6.552    98.070     0.150
     6.606    97.422     0.150
     6.640    97.711     0.150
     6.680    98.656     0.150
     6.711    99.531     0.150
     6.824   100.852     0.150
     6.850   101.672     0.150
     6.885   103.320     0.150
     7.152   104.492     0.150
     7.284   107.188     0.150
     7.493   109.844     0.150
     7.493   111.688     0.150
     7.546   110.609     0.150
     7.592   109.477     0.150
     7.565   113.727     0.150
     7.625   112.203     0.150
     7.625   146.250     0.150
     7.728   113.688     0.150
     7.743   112.906     0.150
     7.794   149.312     0.150
     7.838   114.133     0.150
     7.838   115.867     0.150
     7.905   116.672     0.150
     8.053   117.148     0.150
     8.110   117.523     0.150
     8.128   117.820     0.150
     8.343   122.250     0.150
     8.470   123.789     0.150
     8.525   124.438     0.150
     8.546   124.617     0.150
     8.549   123.008     0.150
     8.598   124.578     0.150
     8.619   125.688     0.150
     8.625   124.789     0.150
     8.695   126.133     0.150
     8.717   126.039     0.150
     8.744   125.258     0.150
     8.733   127.539     0.150
     8.757   128.211     0.150
     8.765   127.930     0.150
     8.848   128.641     0.150
     9.096   132.578     0.150
     9.274   133.102     0.150
     9.254   134.078     0.150
     9.239   135.500     0.150
     9.240   136.070     0.150
     9.240   136.273     0.150
     9.240   295.148     0.150
     9.312   136.812     0.150
     9.833   140.367     0.150
     9.833   317.547     0.150
     9.980   144.094     0.150
     9.997   145.977     0.150
    10.196   148.203     0.150
    12.067   172.430     0.150
    12.378   406.039     0.150
    12.439   175.547     0.150
    12.382   177.500     0.150
    12.532   177.852     0.150
    12.579   177.891     0.150
    12.689   180.102     0.150
    12.938   184.133     0.150
    12.931   184.359     0.150
    13.014   183.977     0.150
    13.083   186.039     0.150
    13.492   192.078     0.150
    13.492   193.945     0.150
    14.082   200.758     0.150
    14.208   201.148     0.150
    14.403   203.633     0.150
    14.780   208.477     0.150
    14.780   209.227     0.150
    15.153   212.547     0.150
    15.110   213.578     0.150
    15.208   214.781     0.150
    15.352   221.719     0.150
    15.414   217.281     0.150
    15.414   219.398     0.150
    15.496   224.430     0.150
    15.515   222.781     0.150
    15.600   219.508     0.150
    15.826   223.531     0.150
    15.856   223.883     0.150
    15.990   224.547     0.150
    16.085   225.344     0.150
    16.139   227.570     0.150
    16.215   227.047     0.150
    16.328   230.000     0.150
    16.865   235.469     0.150
    16.898   236.828     0.150
    16.898   240.750     0.150
    17.206   239.141     0.150
    17.316   240.820     0.150
    17.357   241.500     0.150
    17.406   241.969     0.150
    17.406   246.078     0.150
    17.459   246.156     0.150
    18.884   261.680     0.150
    18.927   263.156     0.150
    19.099   264.008     0.150
    19.099   266.102     0.150
    19.446   268.242     0.150
    19.975   273.867     0.150
    20.167   275.961     0.150
    20.167   277.195     0.150
    20.381   277.609     0.150
    20.965   284.562     0.150
    21.973   295.039     0.150
    22.265   298.398     0.150
    22.265   299.742     0.150
    22.250   298.969     0.150
    23.742   313.781     0.150
    30.644   375.117     0.150
    30.644   378.281     0.150
    31.538   385.109     0.150
    31.577   385.156     0.150
    31.899   386.445     0.150
    32.697   393.758     0.150
    32.856   397.195     0.150
    34.856   414.711     0.150
    35.211   417.750     0.150
    35.291   416.336     0.150
    35.649   421.719     0.150
    36.172   424.922     0.150
    36.400   427.281     0.150
    36.755   430.719     0.150
    36.957   430.188     0.150
    36.957   431.164     0.150
    37.479   437.266     0.150
    37.793   440.539     0.150
    37.822   440.812     0.150
    37.987   441.125     0.150
    37.999   441.227     0.150
    38.004   439.375     0.150
    38.104   441.102     0.150
    38.189   442.203     0.150
    38.246   443.508     0.150
    38.296   444.148     0.150
    38.743   446.422     0.150
    38.744   447.047     0.150
    38.879   447.328     0.150
    38.877   446.688     0.150
    38.890   448.898     0.150
    39.084   447.578     0.150
    39.452   453.812     0.150
    39.469   452.453     0.150
    39.507   454.250     0.150
    39.733   455.914     0.150
    39.749   457.109     0.150
    39.876   457.320     0.150
    39.961   457.797     0.150
    40.116   458.477     0.150
    40.155   459.617     0.150
    40.202   459.805     0.150
    40.378   461.273     0.150
    40.435   460.320     0.150
    40.475   462.047     0.150
    40.503   462.289     0.150
    40.507   461.062     0.150
    40.534   461.719     0.150
    40.576   461.453     0.150
    40.583   462.102     0.150
    40.640   463.617     0.150
    40.765   465.516     0.150
    40.811   466.281     0.150
    40.816   466.570     0.150
    40.883   465.008     0.150
    40.952   466.008     0.150
    41.084   467.078     0.150
    41.119   466.078     0.150
    41.297   468.172     0.150
    41.390   467.898     0.150
    41.457   470.570     0.150
    41.488   468.898     0.150
    41.530   470.102     0.150
    41.546   468.523     0.150
    41.565   470.172     0.150
    41.598   469.883     0.150
    41.632   470.922     0.150
    41.668   471.422     0.150
    41.735   471.555     0.150
    41.953   473.758     0.150
    42.010   473.812     0.150
    42.129   475.109     0.150
    42.155   475.203     0.150
    42.157   474.383     0.150
    42.220   476.133     0.150
    42.321   477.422     0.150
    42.426   477.609     0.150
    42.470   478.609     0.150
    42.518   480.023     0.150
    42.562   479.062     0.150
    42.577   480.703     0.150
    42.686   480.531     0.150
    42.697   479.578     0.150
    42.761   479.727     0.150
    42.904   482.172     0.150
    43.063   481.688     0.150
    43.116   482.336     0.150
    43.128   483.914     0.150
    43.332   483.477     0.150
    43.422   484.578     0.150
    43.432   485.297     0.150
    43.595   485.383     0.150
    43.620   486.203     0.150
    43.623   485.375     0.150
    43.680   486.039     0.150
    43.724   486.602     0.150
    43.914   487.898     0.150
    43.993   488.953     0.150
    44.094   489.156     0.150
    44.100   490.031     0.150
    44.281   492.109     0.150
    44.439   491.266     0.150
    44.633   495.344     0.150
    44.637   496.031     0.150
    44.680   494.859     0.150
    44.853   496.469     0.150
    44.917   498.000     0.150
    44.952   497.445     0.150
    45.050   498.000     0.150
    45.222   500.023     0.150
    45.287   499.469     0.150
    45.289   499.492     0.150
    45.534   501.422     0.150
    45.790   503.867     0.150
    45.872   504.922     0.150
    46.068   504.992     0.150
    46.334   507.297     0.150
    46.505   509.695     0.150
    46.778   512.055     0.150
    46.880   512.609     0.150
    46.892   511.031     0.150
    47.087   512.961     0.150
    47.431   517.773     0.150
    47.524   518.266     0.150
     0.600    11.933     0.150
     0.600    19.683     0.150
     0.866    15.843     0.150
     0.866    27.063     0.150
     0.995    17.313     0.150
     0.995    29.383     0.150
     0.995    30.953     0.150
     0.995    31.423     0.150
     1.177    21.333     0.150
     1.177    34.053     0.150
     1.177    21.173     0.150
     1.177    36.633     0.150
     1.089    33.193     0.150
     1.522    26.213     0.150
     1.533    27.813     0.150
     1.533    47.283     0.150
     1.555    27.643     0.150
     1.555    50.053     0.150
     1.588    46.253     0.150
     1.774    53.753     0.150
     1.763    29.473     0.150
     2.601    41.523     0.150
     2.601    71.263     0.150
     3.167    98.453     0.150
     0.720    14.058     0.150
     0.720    23.958     0.150
     0.975    17.738     0.150
     0.975    31.448     0.150
     1.112    19.288     0.150
     1.112    33.628     0.150
     1.112    36.498     0.150
     1.112    36.658     0.150
     1.228    22.358     0.150
     1.228    38.498     0.150
     1.338    24.518     0.150
     1.338    40.758     0.150
     1.338    22.868     0.150
     1.338    40.108     0.150
     1.453    25.538     0.150
     1.453    41.588     0.150
     1.533    26.978     0.150
     1.533    45.608     0.150
     1.813    30.748     0.150
     1.813    56.558     0.150
     2.219    36.958     0.150
     2.873    43.598     0.150
     2.873    76.068     0.150
     3.076    49.098     0.150
     3.159    51.268     0.150
     3.159    86.138     0.150
     3.262    51.468     0.150
     3.262    91.748     0.150
     3.597    56.218     0.150
     3.597    97.118     0.150
     3.723    58.788     0.150
     3.723   101.208     0.150
     3.907    76.037     0.150
     5.086    76.028     0.150
     5.086   135.798     0.150
     5.619    84.908     0.150
     5.619   146.198     0.150
     7.005   221.988     0.150
     7.395   189.448     0.150
     7.727   113.762     0.150
     7.727   237.262     0.150
     7.976   198.688     0.150
     8.915   130.393     0.150
     8.915   269.193     0.150
    10.404   339.993     0.150
     0.613    12.143     0.150
     0.613    20.812     0.150
     0.632    12.202     0.150
     0.632    21.093     0.150
     0.632    23.213     0.150
     0.807    15.683     0.150
     0.807    27.093     0.150
     0.988    18.053     0.150
     0.988    31.492     0.150
     0.988    18.173     0.150
     0.988    31.643     0.150
     1.026    19.843     0.150
     1.193    21.402     0.150
     1.235    22.083     0.150
     1.235    40.402     0.150
     1.235    22.282     0.150
     1.235    39.062     0.150
     1.336    24.923     0.150
     1.396    25.263     0.150
     1.472    26.152     0.150
     1.472    25.492     0.150
     1.472    25.612     0.150
     1.472    46.603     0.150
     1.490    25.862     0.150
     1.490    45.902     0.150
     1.490    48.893     0.150
     1.563    26.992     0.150
     1.552    27.412     0.150
     1.545    26.503     0.150
     1.638    28.562     0.150
     1.798    29.232     0.150
     1.812    30.503     0.150
     1.908    29.393     0.150
     1.911    31.833     0.150
     1.976    31.723     0.150
     2.027    32.883     0.150
     2.027    33.587     0.150
     2.067    33.303     0.150
     2.062    33.923     0.150
     2.225    36.123     0.150
     2.225    34.952     0.150
     2.290    37.412     0.150
     2.290    71.982     0.150
     2.312    38.263     0.150
     2.384    38.394     0.150
     2.467    39.713     0.150
     2.545    40.543     0.150
     2.608    41.612     0.150
     2.838    44.572     0.150
     2.838    45.438     0.150
     2.882    45.942     0.150
     2.924    44.976     0.150
     2.931    45.513     0.150
     2.931    44.958     0.150
     2.931    47.212     0.150
     2.931    93.986     0.150
     2.931    50.032     0.150
     2.946    45.937     0.150
     3.049    47.473     0.150
     3.202    47.849     0.150
     3.202    52.303     0.150
     3.339    51.520     0.150
     3.484    53.570     0.150
     3.514    53.982     0.150
     3.664    56.319     0.150
     3.827    59.893     0.150
     3.913    58.920     0.150
     3.945    61.940     0.150
     4.041    63.306     0.150
     4.060    61.512     0.150
     4.123    64.229     0.150
     4.220    63.553     0.150
     4.220   113.662     0.150
     4.218    63.527     0.150
     4.336    66.973     0.150
     4.349    66.087     0.150
     4.454    68.213     0.150
     4.479    69.887     0.150
     4.507    67.513     0.150
     4.507    68.930     0.150
     4.529    68.393     0.150
     4.646    71.362     0.150
     4.879    76.744     0.150
     4.901    74.293     0.150
     4.901    75.465     0.150
     4.915    74.513     0.150
     4.929    73.263     0.150
     5.031    78.969     0.150
     5.218    80.063     0.150
     5.369    81.906     0.150
     5.411    81.562     0.150
     5.438    83.162     0.150
     5.437    84.791     0.150
     5.506    83.459     0.150
     5.566    85.376     0.150
     5.580    85.688     0.150
     5.602    83.633     0.150
     5.717    85.532     0.150
     5.717    86.218     0.150
     5.717    85.213     0.150
     5.717   148.223     0.150
     5.789    87.143     0.150
     5.859    88.753     0.150
     5.869    89.994     0.150
     6.009    90.021     0.150
     6.026    91.459     0.150
     6.138    91.833     0.150
     6.226    91.587     0.150
     6.307    93.702     0.150
     6.374    95.652     0.150
     6.384    95.293     0.150
     6.544    94.980     0.150
     6.614    98.032     0.150
     6.596    94.857     0.150
     6.712    99.912     0.150
     6.857   175.742     0.150
     6.953   102.583     0.150
     7.105   104.822     0.150
     7.124   104.190     0.150
     7.338   108.338     0.150
     7.559   110.293     0.150
     7.559   232.837     0.150
     7.559   113.992     0.150
     7.642   113.303     0.150
     7.642   113.542     0.150
     7.642   115.192     0.150
     7.668   113.242     0.150
     7.668   111.173     0.150
     7.668   113.393     0.150
     7.700   112.373     0.150
     8.049   119.282     0.150
     8.050   118.583     0.150
     8.398   122.503     0.150
     8.414   122.612     0.150
     8.596   128.152     0.150
     8.596   127.272     0.150
     8.740   131.043     0.150
     8.740   132.062     0.150
     8.945   129.411     0.150
     8.981   130.987     0.150
     8.981   134.572     0.150
     9.433   287.317     0.150
     9.471   142.918     0.150
     9.471   312.293     0.150
     9.735   143.103     0.150
     9.735   139.651     0.150
     9.917   144.333     0.150
    10.086   147.923     0.150
    10.087   144.133     0.150
    10.122   146.072     0.150
    10.122   143.653     0.150
    10.129   148.022     0.150
    10.129   147.433     0.150
    10.545   156.902     0.150
    10.740   155.027     0.150
    11.077   160.862     0.150
    11.214   160.948     0.150
    11.647   171.572     0.150
    11.750   169.917     0.150
    11.751   166.853     0.150
    11.751   172.272     0.150
    12.082   173.209     0.150
    12.082   173.152     0.150
    12.082   178.242     0.150
    12.082   386.782     0.150
    12.260   174.343     0.150
    12.260   175.932     0.150
    12.260   179.393     0.150
    12.299   174.773     0.150
    12.521   181.513     0.150
    12.521   179.431     0.150
    12.561   180.172     0.150
    13.265   189.463     0.150
    13.315   191.253     0.150
    13.315   190.904     0.150
    13.486   194.543     0.150
    13.486   195.793     0.150
    13.510   192.333     0.150
    13.510   191.681     0.150
    13.510   195.562     0.150
    13.630   195.022     0.150
    13.686   195.583     0.150
    14.121   199.215     0.150
    14.258   203.253     0.150
    14.383   204.908     0.150
    14.379   202.772     0.150
    14.379   203.691     0.150
    14.410   205.812     0.150
    14.410   206.062     0.150
    14.450   204.362     0.150
    14.450   205.262     0.150
    14.840   210.202     0.150
    15.086   214.053     0.150
    15.177   215.753     0.150
    15.177   215.954     0.150
    15.462   220.272     0.150
    15.530   218.782     0.150
    15.796   223.853     0.150
    15.839   224.103     0.150
    15.997   225.293     0.150
    15.997   227.282     0.150
    16.132   228.691     0.150
    16.449   230.996     0.150
    16.553   236.003     0.150
    16.615   235.457     0.150
    16.796   236.770     0.150
    17.086   239.583     0.150
    17.086   239.315     0.150
    17.094   239.486     0.150
    17.094   244.236     0.150
    17.094   243.333     0.150
    17.675   247.683     0.150
    17.739   246.532     0.150
    17.739   246.250     0.150
    17.739   249.143     0.150
    17.857   249.901     0.150
    18.725   257.201     0.150
    18.823   261.039     0.150
    19.790   272.902     0.150
    19.958   274.601     0.150
    20.015   273.603     0.150
    20.015   274.641     0.150
    20.060   274.362     0.150
    20.141   275.952     0.150
    20.141   276.651     0.150
    20.281   276.902     0.150
    20.281   278.731     0.150
    20.545   278.982     0.150
    21.172   287.013     0.150
    21.234   287.473     0.150
    21.820   293.376     0.150
    22.054   295.603     0.150
    22.054   295.991     0.150
    22.054   297.763     0.150
    22.240   296.086     0.150
    22.375   297.104     0.150
    22.553   301.732     0.150
    22.553   300.377     0.150
    22.553   303.782     0.150
    23.198   309.319     0.150
    23.325   308.053     0.150
    23.439   310.293     0.150
    23.724   314.105     0.150
    23.811   314.991     0.150
    24.010   316.271     0.150
    24.087   315.614     0.150
    24.087   318.583     0.150
    24.307   318.992     0.150
    25.042   324.463     0.150
    25.042   327.053     0.150
    25.146   327.692     0.150
    25.232   328.723     0.150
    25.431   330.342     0.150
    25.819   330.036     0.150
    26.029   335.257     0.150
    26.130   338.092     0.150
    26.226   338.479     0.150
    26.448   339.873     0.150
    26.789   341.988     0.150
    26.863   342.283     0.150
    26.863   342.054     0.150
    26.972   344.611     0.150
    27.420   348.087     0.150
    27.816   351.584     0.150
    28.107   353.778     0.150
    28.204   354.687     0.150
    28.561   357.556     0.150
    28.790   360.869     0.150
    28.902   358.800     0.150
    29.019   363.571     0.150
    29.176   363.836     0.150
    29.189   364.453     0.150
    29.596   368.266     0.150
    29.675   370.825     0.150
    30.172   373.143     0.150
    30.228   374.640     0.150
    30.266   373.641     0.150
    30.308   374.511     0.150
    30.770   378.773     0.150
    31.159   380.723     0.150
    31.444   383.735     0.150
    31.832   388.379     0.150
    32.319   388.390     0.150
    32.368   391.389     0.150
    32.376   389.337     0.150
    32.404   388.420     0.150
    32.808   391.077     0.150
    32.981   394.282     0.150
    33.189   397.945     0.150
    33.307   399.464     0.150
    33.314   398.254     0.150
    33.544   402.616     0.150
    33.590   399.551     0.150
    33.621   400.200     0.150
    33.652   400.844     0.150
    33.810   399.578     0.150
    34.234   404.350     0.150
    34.320   406.657     0.150
    34.593   410.254     0.150
    34.831   414.558     0.150
    34.911   414.888     0.150
    34.961   412.273     0.150
    35.042   416.269     0.150
    35.270   416.390     0.150
    35.393   418.524     0.150
    35.462   418.544     0.150
    35.559   420.371     0.150
    35.729   420.443     0.150
    35.792   420.683     0.150
    35.792   419.693     0.150
    36.161   422.484     0.150
    36.181   424.651     0.150
    36.290   425.232     0.150
    36.300   424.816     0.150
    36.376   424.553     0.150
    36.555   425.854     0.150
    36.579   425.867     0.150
    36.593   426.209     0.150
    36.744   428.613     0.150
    36.902   430.348     0.150
    37.052   429.241     0.150
    37.058   432.507     0.150
    37.100   434.896     0.150
    37.147   432.402     0.150
    37.147   434.643     0.150
    37.199   431.477     0.150
    37.270   434.070     0.150
    37.288   433.435     0.150
    37.338   434.217     0.150
    37.395   434.138     0.150
    37.414   436.593     0.150
    37.414   436.115     0.150
    37.443   434.612     0.150
    37.443   436.166     0.150
    37.518   432.519     0.150
    37.628   437.870     0.150
    37.631   436.873     0.150
    37.631   436.101     0.150
    37.642   435.054     0.150
    37.810   438.623     0.150
    37.810   440.488     0.150
    37.844   438.591     0.150
    37.869   438.396     0.150
    37.887   439.857     0.150
    37.916   438.973     0.150
    37.988   442.293     0.150
    38.046   439.847     0.150
    38.071   439.183     0.150
    38.111   443.690     0.150
    38.128   442.748     0.150
    38.177   442.159     0.150
    38.285   445.408     0.150
    38.358   444.863     0.150
    38.364   445.040     0.150
    38.367   444.874     0.150
    38.368   443.874     0.150
    38.372   442.907     0.150
    38.415   444.514     0.150
    38.504   442.858     0.150
    38.513   445.324     0.150
    38.510   447.133     0.150
    38.643   446.547     0.150
    38.712   448.281     0.150
    38.723   445.112     0.150
    38.729   449.094     0.150
    38.796   448.535     0.150
    38.861   448.869     0.150
    38.945   449.722     0.150
    38.962   448.596     0.150
    38.982   449.317     0.150
    39.073   448.638     0.150
    39.089   448.633     0.150
    39.089   447.652     0.150
    39.089   450.992     0.150
    39.129   448.558     0.150
    39.182   449.311     0.150
    39.200   449.623     0.150
    39.388   452.746     0.150
    39.496   451.861     0.150
    39.538   452.593     0.150
    39.539   454.359     0.150
    39.585   454.020     0.150
    39.627   455.126     0.150
    39.648   453.606     0.150
    39.672   451.968     0.150
    39.823   456.499     0.150
    40.012   455.083     0.150
    40.056   456.081     0.150
    40.078   455.493     0.150
    40.099   454.925     0.150
    40.123   455.260     0.150
    40.127   456.131     0.150
    40.156   456.068     0.150
    40.206   458.804     0.150
    40.202   456.144     0.150
    40.260   457.574     0.150
    40.270   457.278     0.150
    40.387   459.213     0.150
    40.439   459.673     0.150
    40.503   462.285     0.150
    40.545   461.941     0.150
    40.576   462.176     0.150
    40.601   462.929     0.150
    40.705   463.433     0.150
    40.740   462.315     0.150
    40.921   466.047     0.150
    41.081   465.366     0.150
    41.152   463.887     0.150
    41.185   462.866     0.150
    41.252   464.974     0.150
    41.260   466.462     0.150
    41.289   465.213     0.150
    41.356   467.368     0.150
    41.574   468.842     0.150
    41.576   468.398     0.150
    41.631   468.156     0.150
    41.650   469.504     0.150
    41.738   470.393     0.150
    41.749   473.332     0.150
    41.776   470.177     0.150
    41.779   472.640     0.150
    41.817   469.447     0.150
    41.841   472.156     0.150
    41.941   472.206     0.150
    41.949   470.923     0.150
    42.048   471.604     0.150
    42.081   472.833     0.150
    42.093   473.231     0.150
    42.139   473.775     0.150
    42.199   474.618     0.150
    42.216   477.576     0.150
    42.309   476.210     0.150
    42.317   476.415     0.150
    42.388   475.853     0.150
    42.492   477.505     0.150
    42.516   478.388     0.150
    42.525   477.035     0.150
    42.676   479.836     0.150
    42.685   478.169     0.150
    42.736   477.441     0.150
    42.749   479.957     0.150
    42.816   480.279     0.150
    42.956   479.014     0.150
    43.043   478.637     0.150
    43.219   482.885     0.150
    43.243   482.983     0.150
    43.242   481.268     0.150
    43.300   485.379     0.150
    43.326   482.698     0.150
    43.340   483.375     0.150
    43.344   482.772     0.150
    43.360   483.101     0.150
    43.535   488.151     0.150
    43.542   485.287     0.150
    43.614   486.590     0.150
    43.628   485.824     0.150
    43.715   488.225     0.150
    43.901   487.665     0.150
    44.059   491.125     0.150
    44.182   491.794     0.150
    44.254   490.539     0.150
    44.261   492.223     0.150
    44.300   492.000     0.150
    44.423   493.387     0.150
    44.450   493.450     0.150
    44.475   493.551     0.150
    44.572   492.562     0.150
    44.671   495.036     0.150
    44.843   494.831     0.150
    44.907   496.457     0.150
    44.909   496.136     0.150
    45.154   498.781     0.150
    45.324   497.847     0.150
    45.410   502.005     0.150
    45.517   501.290     0.150
    45.688   503.844     0.150
    45.842   505.071     0.150
    45.917   506.303     0.150
    45.917   507.952     0.150
    45.954   506.444     0.150
    45.992   507.136     0.150
    46.035   507.322     0.150
    46.112   506.612     0.150
    46.125   506.643     0.150
    46.228   507.244     0.150
    46.399   509.062     0.150
    46.500   508.543     0.150
    46.512   511.030     0.150
    46.636   510.532     0.150
    48.081   522.800     0.150
    48.382   523.853     0.150
    48.382   526.003     0.150
    55.093   572.623     0.150
    55.593   577.312     0.150
    58.238   593.623     0.150
    61.429   617.643     0.150
    61.599   617.662     0.150
    63.217   629.522     0.150
    68.049   661.093     0.150
    75.316   703.043     0.150
    76.005   709.322     0.150
    77.936   718.246     0.150
    78.399   721.022     0.150
    78.399   722.718     0.150
    79.442   725.984     0.150
    82.182   741.473     0.150
    82.182   741.867     0.150
    82.178   743.143     0.150
    83.034   748.643     0.150
    83.530   750.603     0.150
    83.582   749.692     0.150
    83.582   750.062     0.150
    83.582   750.593     0.150
    84.284   753.442     0.150
    84.354   753.583     0.150
    84.354   752.567     0.150
    86.478   763.022     0.150
    87.757   770.603     0.150
    90.270   783.208     0.150
    92.136   790.643     0.150
    92.253   791.987     0.150
    93.168   797.103     0.150
    93.514   796.643     0.150
    93.514   797.942     0.150
    96.619   812.143     0.150
    99.360   826.643     0.150
     0.661    12.174     0.150
     0.661    22.354     0.150
     0.616    12.023     0.150
     0.616    20.424     0.150
     0.616    21.443     0.150
     0.826    15.613     0.150
     0.826    27.523     0.150
     0.826    26.674     0.150
     0.981    17.583     0.150
     0.981    31.033     0.150
     0.981    17.964     0.150
     0.981    30.924     0.150
     0.981    32.323     0.150
     1.250    21.604     0.150
     1.250    39.104     0.150
     1.382    25.273     0.150
     1.467    25.533     0.150
     1.467    45.424     0.150
     1.467    46.743     0.150
     1.467    47.674     0.150
     1.454    27.443     0.150
     1.498    25.434     0.150
     1.583    26.184     0.150
     1.631    27.594     0.150
     1.631    49.623     0.150
     1.623    26.903     0.150
     1.877    30.033     0.150
     1.963    30.653     0.150
     2.026    31.684     0.150
     2.089    33.724     0.150
     2.263    36.424     0.150
     2.330    37.193     0.150
     2.330    69.764     0.150
     2.355    36.943     0.150
     2.533    41.823     0.150
     2.881    45.123     0.150
     2.940    46.894     0.150
     2.988    47.424     0.150
     2.988    47.207     0.150
     2.988    91.357     0.150
     3.218    50.153     0.150
     3.564    53.943     0.150
     3.892    61.073     0.150
     4.019    61.693     0.150
     4.332    64.974     0.150
     4.660    70.354     0.150
     4.955    75.563     0.150
     5.321    80.104     0.150
     5.481    82.833     0.150
     5.651    83.844     0.150
     5.727    84.943     0.150
     5.853    87.764     0.150
     6.436    95.913     0.150
     7.588   112.857     0.150
     7.588   249.082     0.150
     7.690   113.304     0.150
     7.900   120.249     0.150
     9.032   133.123     0.150
     9.242   134.054     0.150
     9.416   137.363     0.150
     9.416   300.642     0.150
    12.463   182.741     0.150
    17.160   243.183     0.150
    18.768   260.203     0.150
    20.069   272.384     0.150
    20.866   281.913     0.150
    21.862   293.884     0.150
    22.410   299.394     0.150
    23.344   309.844     0.150
    39.153   450.464     0.150
    40.407   457.363     0.150
    40.448   458.134     0.150
    40.767   461.394     0.150
    41.141   465.264     0.150
    41.213   465.373     0.150
    41.693   470.044     0.150
    41.838   470.474     0.150
    77.993   719.004     0.150
    82.243   742.738     0.150
     0.609    11.368     0.150
     0.609    20.309     0.150
     0.612    11.298     0.150
     0.612    20.038     0.150
     0.612    22.198     0.150
     0.773    14.528     0.150
     0.773    25.408     0.150
     1.021    17.139     0.150
     1.021    31.608     0.150
     1.021    31.309     0.150
     1.021    32.628     0.150
     1.095    19.338     0.150
     1.423    24.358     0.150
     1.546    24.958     0.150
     1.546    45.048     0.150
     1.546    47.918     0.150
     1.546    48.618     0.150
     1.622    26.648     0.150
     1.622    48.648     0.150
     1.950    30.438     0.150
     2.180    35.198     0.150
     2.180    62.198     0.150
     2.241    36.198     0.150
     2.241    71.219     0.150
     2.528    45.238     0.150
     3.164    54.408     0.150
     3.164    94.969     0.150
     4.239   124.429     0.150
     4.605    87.258     0.150
     5.566    80.599     0.150
     0.708    13.477     0.150
     0.708    23.207     0.150
     0.708    24.055     0.150
     0.816    15.207     0.150
     0.816    26.285     0.150
     0.923    18.395     0.150
     0.923    29.227     0.150
     0.930    17.387     0.150
     0.941    16.965     0.150
     1.038    19.234     0.150
     1.038    33.016     0.150
     1.038    34.984     0.150
     1.135    21.715     0.150
     1.135    35.957     0.150
     1.135    20.125     0.150
     1.135    35.074     0.150
     1.182    22.035     0.150
     1.182    38.945     0.150
     1.182    20.855     0.150
     1.182    40.695     0.150
     1.184    20.617     0.150
     1.264    23.535     0.150
     1.330    24.105     0.150
     1.318    24.234     0.150
     1.424    25.758     0.150
     1.479    26.324     0.150
     1.520    27.234     0.150
     1.520    27.625     0.150
     1.574    27.117     0.150
     1.596    27.656     0.150
     1.596    48.484     0.150
     1.596    51.668     0.150
     1.596    51.777     0.150
     1.672    28.047     0.150
     1.672    27.746     0.150
     1.732    29.895     0.150
     1.748    28.785     0.150
     1.938    32.895     0.150
     2.050    34.516     0.150
     2.050    34.168     0.150
     2.111    34.406     0.150
     2.178    35.816     0.150
     2.254    37.047     0.150
     2.254    73.375     0.150
     2.646    42.965     0.150
     2.670    43.336     0.150
     3.175    50.266     0.150
     3.280    51.484     0.150
     3.550    56.395     0.150
     3.785    59.945     0.150
     4.164    62.438     0.150
     4.627    70.848     0.150
     4.687    68.887     0.150
     4.773    71.965     0.150
     4.964    75.215     0.150
     4.973    74.996     0.150
     5.159    79.637     0.150
     5.517    84.574     0.150
     5.578    85.227     0.150
     5.593    86.168     0.150
     5.711    85.324     0.150
     5.848    89.305     0.150
     6.489    97.348     0.150
     6.833   102.707     0.150
     7.415   110.246     0.150
     8.118   118.676     0.150
     0.585    11.207     0.150
     0.585    18.980     0.150
     0.585    19.980     0.150
     0.585    20.668     0.150
     0.673    12.277     0.150
     0.673    21.809     0.150
     0.673    22.891     0.150
     0.790    14.648     0.150
     0.790    25.238     0.150
     0.801    14.777     0.150
     1.012    18.320     0.150
     1.012    32.129     0.150
     1.012    32.648     0.150
     1.270    22.270     0.150
     1.270    41.660     0.150
     1.382    25.738     0.150
     1.382    42.699     0.150
     1.414    24.770     0.150
     1.442    25.258     0.150
     1.415    25.508     0.150
     1.500    25.910     0.150
     1.504    26.438     0.150
     1.504    45.949     0.150
     1.654    28.219     0.150
     1.851    29.578     0.150
     1.866    28.688     0.150
     1.866    56.309     0.150
     1.866    29.289     0.150
     2.269    36.910     0.150
     2.269    68.879     0.150
     2.335    35.020     0.150
     2.335    64.598     0.150
     3.183    51.340     0.150
     3.183    86.828     0.150
     4.182    63.949     0.150
     0.705    13.770     0.150
     0.705    23.699     0.150
     0.952    18.102     0.150
     0.973    17.781     0.150
     0.973    31.230     0.150
     1.103    18.441     0.150
     1.103    32.422     0.150
     1.226    21.320     0.150
     1.226    37.242     0.150
     1.554    26.762     0.150
     1.554    45.891     0.150
     1.595    26.500     0.150
     1.540    26.531     0.150
     1.540    48.062     0.150
     1.725    29.422     0.150
     2.030    33.832     0.150
     2.386    37.801     0.150
     2.462    38.172     0.150
     2.702    43.102     0.150
     2.818    43.941     0.150
     3.021    48.859     0.150
     3.219    50.543     0.150
     3.220    49.441     0.150
     3.220    50.133     0.150
     3.313    52.699     0.150
     3.498    52.762     0.150
     3.498    61.863     0.150
     3.498   116.613     0.150
     4.289    66.223     0.150
     4.346    66.652     0.150
     4.624    70.422     0.150
     4.868    76.520     0.150
     5.011    76.383     0.150
     5.088    75.633     0.150
     5.138    77.852     0.150
     5.274    78.473     0.150
     5.500    85.242     0.150
     5.659    84.762     0.150
     5.816    88.383     0.150
     5.841    85.902     0.150
     5.863    87.223     0.150
     6.133    91.762     0.150
     6.131    92.449     0.150
     6.291    94.152     0.150
     6.344    95.512     0.150
     6.393    95.180     0.150
     6.445    93.609     0.150
     6.568    96.980     0.150
     6.694    99.223     0.150
     6.816   101.633     0.150
     6.843   102.320     0.150
     6.884   101.699     0.150
     7.051   102.980     0.150
     7.353   109.641     0.150
     7.457   109.691     0.150
     7.447   111.473     0.150
     7.687   112.230     0.150
     7.689   114.242     0.150
     7.773   112.570     0.150
     7.830   112.859     0.150
     7.893   115.871     0.150
     7.970   116.051     0.150
     8.418   128.219     0.150
     8.787   127.973     0.150
     9.014   132.211     0.150
     9.138   130.277     0.150
     9.138   275.531     0.150
     9.475   140.262     0.150
     9.582   139.742     0.150
     9.823   146.109     0.150
    10.023   147.121     0.150
    10.023   313.672     0.150
    12.533   180.777     0.150
    12.776   185.711     0.150
    13.751   197.422     0.150
    13.988   201.180     0.150
    14.399   206.961     0.150
    14.604   206.621     0.150
    14.641   207.191     0.150
    14.738   206.902     0.150
    15.678   219.660     0.150
    17.651   250.359     0.150
    39.670   455.059     0.150
     0.665    12.840     0.150
     0.665    22.430     0.150
     1.067    19.449     0.150
     1.067    34.070     0.150
     1.317    23.102     0.150
     1.317    40.000     0.150
     1.352    24.660     0.150
     1.330    22.961     0.150
     1.330    40.871     0.150
     1.582    25.852     0.150
     1.598    27.402     0.150
     1.598    47.090     0.150
     1.786    30.121     0.150
     2.008    33.121     0.150
     2.053    36.680     0.150
     2.137    36.391     0.150
     2.137    63.312     0.150
     2.320    38.281     0.150
     2.346    40.312     0.150
     2.810    51.570     0.150
     6.908   101.918     0.150
     6.908   183.293     0.150
     7.771   114.145     0.150
     7.771   247.070     0.150
     8.927   133.500     0.150
     8.886   129.145     0.150
     8.886   278.250     0.150
    12.926   188.512     0.150
    18.137   255.043     0.150
    40.179   460.145     0.150
     0.390     8.047     0.150
     0.390    13.535     0.150
     0.819    15.695     0.150
     0.819    26.488     0.150
     0.819    15.809     0.150
     0.819    26.945     0.150
     1.667    28.375     0.150
     1.667    49.867     0.150
     1.667    28.215     0.150
     1.667    50.148     0.150
     1.607    30.758     0.150
     1.607    52.387     0.150
     1.684    28.238     0.150
     1.662    29.215     0.150
     1.662    52.258     0.150
     1.868    31.656     0.150
     1.934    31.996     0.150
     1.863    30.746     0.150
     1.863    57.887     0.150
     1.921    32.906     0.150
     1.921    59.957     0.150
     2.011    32.246     0.150
     2.011    59.957     0.150
     2.306    37.926     0.150
     2.692    56.059     0.150
     2.683    45.176     0.150
     2.736    42.926     0.150
     2.754    43.277     0.150
     2.754    54.648     0.150
     2.807    52.918     0.150
     3.128    56.316     0.150
     3.128    98.965     0.150
     3.260    51.508     0.150
     3.260    89.926     0.150
     3.477    66.355     0.150
     3.490    54.438     0.150
     3.490    95.398     0.150
     3.490    54.586     0.150
     3.775    57.406     0.150
     3.911    73.125     0.150
     3.911   110.738     0.150
     0.395     7.961     0.150
     0.395    13.422     0.150
     1.363    24.125     0.150
     1.474    25.320     0.150
     1.474    45.086     0.150
     1.474    47.086     0.150
     1.474    47.938     0.150
     1.512    26.273     0.150
     1.512    26.445     0.150
     1.793    29.773     0.150
     1.793    30.352     0.150
     1.793    58.547     0.150
     1.793    58.664     0.150
     2.073    34.625     0.150
     2.073    61.438     0.150
     2.189    37.305     0.150
     2.330    36.758     0.150
     2.399    38.594     0.150
     2.595    41.375     0.150
     2.842    44.297     0.150
     2.893    46.094     0.150
     2.968    46.516     0.150
     3.121    48.844     0.150
     3.086    53.906     0.150
     3.354    56.008     0.150
     3.553    55.406     0.150
     3.624    56.062     0.150
     3.873    60.203     0.150
     3.899    58.625     0.150
     3.899    59.836     0.150
     3.899    72.109     0.150
     3.899   122.508     0.150
     4.046    70.445     0.150
     4.046   107.672     0.150
     4.387    66.562     0.150
     5.541    80.516     0.150
     5.824    87.258     0.150
     6.444    96.688     0.150
     6.903   102.016     0.150
     7.001   212.461     0.150
     7.379   109.211     0.150
     7.552   111.805     0.150
     7.609   114.141     0.150
     7.997   118.086     0.150
     8.088   119.211     0.150
     8.088   153.633     0.150
     8.088   261.859     0.150
     8.167   117.242     0.150
     8.167   207.953     0.150
     8.877   131.164     0.150
     9.158   135.352     0.150
     9.219   135.734     0.150
     9.219   135.438     0.150
     9.219   292.555     0.150
    10.490   152.375     0.150
    10.558   155.391     0.150
    10.558   337.602     0.150
    13.093   419.766     0.150
    14.480   203.688     0.150
    14.832   207.156     0.150
    14.932   209.602     0.150
    15.423   217.305     0.150
    16.228   227.672     0.150
    16.576   230.820     0.150
    16.610   232.203     0.150
    16.692   231.336     0.150
    16.700   232.203     0.150
    16.817   233.734     0.150
    16.871   234.711     0.150
    16.855   237.211     0.150
    16.914   234.391     0.150
    16.980   237.062     0.150
    17.547   243.227     0.150
    17.603   244.055     0.150
    18.133   250.320     0.150
    18.180   255.484     0.150
    19.456   266.547     0.150
    19.799   269.812     0.150
    20.411   279.016     0.150
    21.959   293.711     0.150
    22.900   304.461     0.150
    24.324   318.484     0.150
    24.324   319.367     0.150
    28.164   352.305     0.150
    32.308   391.258     0.150
    40.135   458.539     0.150
    41.174   463.523     0.150
    42.270   470.711     0.150
    85.022   759.055     0.150
     0.449     9.102     0.150
     0.449    16.395     0.150
     1.202    19.512     0.150
     1.202    34.824     0.150
     1.435    23.793     0.150
     1.435    23.953     0.150
     1.435    43.512     0.150
     1.464    23.742     0.150
     1.464    23.555     0.150
     1.464    42.223     0.150
     1.566    26.102     0.150
     1.566    47.465     0.150
     1.861    30.492     0.150
     2.149    34.582     0.150
     2.149    62.305     0.150
     2.101    36.543     0.150
     2.101    63.723     0.150
     2.384    36.582     0.150
     2.384    40.652     0.150
     2.386    37.262     0.150
     2.191    36.234     0.150
     2.574    39.715     0.150
     2.885    45.305     0.150
     2.903    45.371     0.150
     3.030    48.305     0.150
     3.120    47.402     0.150
     2.999    49.012     0.150
     3.553    55.684     0.150
     3.541    53.453     0.150
     3.541    52.012     0.150
     3.841    58.781     0.150
     3.939    59.672     0.150
     3.939    59.512     0.150
     3.939   103.961     0.150
     3.939   124.086     0.150
     3.949    65.992     0.150
     4.321    65.305     0.150
     4.440    67.484     0.150
     4.772    71.531     0.150
     4.894    73.172     0.150
     5.569    82.352     0.150
     5.778    86.602     0.150
     5.890    87.371     0.150
     6.392    95.324     0.150
     6.502    97.984     0.150
     6.718    98.824     0.150
     6.829   101.562     0.150
     6.880   102.402     0.150
     6.982   102.703     0.150
     6.959   100.738     0.150
     6.959   214.711     0.150
     7.226   106.562     0.150
     7.218   105.953     0.150
     7.227   105.633     0.150
     7.293   105.691     0.150
     7.466   108.172     0.150
     7.566   114.273     0.150
     7.900   115.812     0.150
     8.006   115.781     0.150
     8.006   115.887     0.150
     8.006   253.688     0.150
     8.408   120.934     0.150
     8.905   129.969     0.150
     8.905   279.125     0.150
     8.893   129.973     0.150
     9.164   131.012     0.150
     9.061   131.934     0.150
     9.245   131.832     0.150
     9.122   132.621     0.150
     9.123   132.762     0.150
     9.123   132.492     0.150
     9.123   284.816     0.150
    10.557   154.191     0.150
    10.557   330.969     0.150
    11.220   161.113     0.150
    13.059   409.727     0.150
    13.435   193.090     0.150
    15.225   214.242     0.150
    15.374   218.832     0.150
    15.330   216.332     0.150
    15.609   220.004     0.150
    15.588   220.992     0.150
    16.028   223.805     0.150
    16.213   228.305     0.150
    16.897   236.023     0.150
    22.652   301.102     0.150
    23.948   313.723     0.150
    24.195   317.523     0.150
    24.269   316.812     0.150
    25.104   325.191     0.150
    25.348   326.113     0.150
    40.162   457.191     0.150
    41.578   468.918     0.150
    97.626   811.742     0.150
     0.810    15.607     0.150
     0.810    26.348     0.150
     1.078    19.457     0.150
     1.078    32.316     0.150
     1.078    19.746     0.150
     1.078    34.297     0.150
     1.078    35.807     0.150
     1.261    22.197     0.150
     1.261    39.816     0.150
     1.261    22.977     0.150
     1.261    40.297     0.150
     1.545    26.986     0.150
     1.545    46.816     0.150
     1.648    29.607     0.150
     1.648    52.598     0.150
     1.648    30.598     0.150
     1.648    52.918     0.150
     1.983    33.688     0.150
     1.983    60.076     0.150
     2.157    35.717     0.150
     2.503    40.996     0.150
     2.534    41.707     0.150
     2.557    41.188     0.150
     2.774    43.496     0.150
     2.774    78.607     0.150
     2.855    42.236     0.150
     2.855    77.678     0.150
     3.141    50.396     0.150
     3.158    53.547     0.150
     3.157    49.047     0.150
     3.284    51.496     0.150
     3.284    51.227     0.150
     3.431    54.146     0.150
     3.598    65.951     0.150
     3.918   114.496     0.150
     4.140    63.217     0.150
     4.193    64.637     0.150
     4.394    67.598     0.150
     4.468    68.447     0.150
     4.677    71.688     0.150
     5.230    79.537     0.150
     5.386    80.598     0.150
     5.981    91.047     0.150
     6.218    92.418     0.150
     6.412    95.467     0.150
     6.464    97.627     0.150
     6.594    99.076     0.150
     6.733    99.816     0.150
     6.815   102.246     0.150
     6.962   104.557     0.150
     6.970   103.668     0.150
     7.054   104.406     0.150
     7.139   105.277     0.150
     7.221   106.746     0.150
     7.310   106.701     0.150
     7.535   111.566     0.150
     7.535   194.357     0.150
     7.566   111.977     0.150
     7.734   115.018     0.150
     7.734   115.176     0.150
     7.734   245.676     0.150
     7.804   114.906     0.150
     7.807   115.197     0.150
     7.837   115.307     0.150
     8.044   119.646     0.150
     8.529   273.896     0.150
     8.769   128.617     0.150
     8.783   127.986     0.150
     8.803   130.338     0.150
     8.872   132.207     0.150
     8.953   130.947     0.150
     9.017   132.447     0.150
     9.126   135.066     0.150
     9.127   134.387     0.150
     9.127   133.781     0.150
     9.127   286.525     0.150
     9.518   138.566     0.150
     9.975   146.838     0.150
    10.144   325.531     0.150
    10.363   150.906     0.150
    11.733   168.918     0.150
    12.314   177.527     0.150
    12.471   179.957     0.150
    12.844   182.107     0.150
    12.922   186.008     0.150
    14.521   206.277     0.150
    14.859   210.746     0.150
    15.468   218.557     0.150
    15.605   220.787     0.150
    16.632   234.688     0.150
    16.663   236.156     0.150
    17.161   240.807     0.150
    17.772   251.502     0.150
    18.252   255.688     0.150
    19.696   270.338     0.150
    39.783   457.357     0.150
    78.445   722.641     0.150
    97.292   815.107     0.150
     0.769    14.570     0.150
     0.769    25.688     0.150
     1.037    18.836     0.150
     1.037    31.703     0.150
     1.037    18.938     0.150
     1.037    33.328     0.150
     1.512    25.805     0.150
     1.512    46.016     0.150
     1.583    27.320     0.150
     1.583    27.617     0.150
     1.745    29.156     0.150
     1.745    53.500     0.150
     1.883    31.766     0.150
     1.897    33.820     0.150
     1.939    32.977     0.150
     1.939    36.398     0.150
     1.923    32.594     0.150
     2.034    32.789     0.150
     2.092    34.305     0.150
     2.479    40.180     0.150
     2.467    40.148     0.150
     2.532    38.797     0.150
     2.532    77.625     0.150
     2.601    42.859     0.150
     2.702    43.750     0.150
     2.702    43.555     0.150
     2.702    77.023     0.150
     2.702    53.266     0.150
     2.678    43.398     0.150
     2.782    44.078     0.150
     2.782    79.445     0.150
     3.067    48.344     0.150
     3.085    60.414     0.150
     3.085    95.289     0.150
     3.225    49.266     0.150
     3.225    48.953     0.150
     3.225    87.648     0.150
     3.225    87.195     0.150
     3.225    53.859     0.150
     3.279    50.266     0.150
     3.279    90.047     0.150
     3.373    52.938     0.150
     3.519    55.438     0.150
     3.519    54.992     0.150
     3.519    94.516     0.150
     3.519   113.164     0.150
     3.519    55.109     0.150
     3.745    59.734     0.150
     3.745    55.805     0.150
     3.959    59.555     0.150
     3.959    59.688     0.150
     3.979    60.180     0.150
     3.979    59.336     0.150
     4.063    62.938     0.150
     4.215    63.609     0.150
     4.269    63.750     0.150
     4.399    66.680     0.150
     4.680    70.141     0.150
     4.784    75.438     0.150
     4.878    74.078     0.150
     5.057    76.125     0.150
     5.117    77.695     0.150
     5.202    78.484     0.150
     5.316    79.594     0.150
     5.316   140.984     0.150
     5.876    86.930     0.150
     6.142    92.039     0.150
     6.151    91.844     0.150
     6.401    95.227     0.150
     6.351    93.297     0.150
     6.351   169.336     0.150
     6.430    94.938     0.150
     6.485    97.398     0.150
     6.615    97.273     0.150
     6.775   101.828     0.150
     6.965   102.789     0.150
     7.051   103.516     0.150
     7.384   109.477     0.150
     7.389   110.492     0.150
     7.389   110.680     0.150
     7.559   110.164     0.150
     7.559   195.234     0.150
     7.559   110.820     0.150
     7.723   113.234     0.150
     7.723   113.492     0.150
     7.723   198.469     0.150
     7.723   242.562     0.150
     7.723   112.617     0.150
     7.723   202.000     0.150
     7.723   114.039     0.150
     7.826   114.234     0.150
     7.870   115.031     0.150
     7.992   117.875     0.150
     7.992   115.984     0.150
     7.992   209.180     0.150
     7.992   118.508     0.150
     8.006   117.430     0.150
     8.006   119.398     0.150
     8.242   119.648     0.150
     8.242   216.977     0.150
     8.312   122.570     0.150
     8.312   123.234     0.150
     8.312   220.094     0.150
     8.450   127.070     0.150
     8.515   127.734     0.150
     8.515   224.117     0.150
     8.738   126.484     0.150
     8.830   128.719     0.150
     8.830   129.266     0.150
     8.830   227.289     0.150
     9.032   131.969     0.150
     9.052   131.688     0.150
     9.052   234.586     0.150
     9.170   131.773     0.150
     9.170   133.523     0.150
     9.170   233.969     0.150
     9.170   282.695     0.150
     9.542   138.695     0.150
     9.558   142.945     0.150
     9.970   145.289     0.150
    10.021   145.180     0.150
    10.071   146.078     0.150
    10.071   147.219     0.150
    10.071   313.172     0.150
    10.150   265.914     0.150
    10.316   149.438     0.150
    11.086   164.297     0.150
    11.188   161.219     0.150
    11.389   164.797     0.150
    11.439   164.070     0.150
    11.773   168.148     0.150
    12.290   180.617     0.150
    12.347   176.305     0.150
    12.347   177.469     0.150
    12.347   315.797     0.150
    12.592   177.203     0.150
    12.592   179.648     0.150
    12.592   182.094     0.150
    12.995   185.227     0.150
    13.005   188.734     0.150
    12.992   186.266     0.150
    12.992   188.156     0.150
    12.992   330.469     0.150
    12.992   189.430     0.150
    13.213   191.953     0.150
    13.213   336.156     0.150
    13.535   192.688     0.150
    13.535   193.219     0.150
    13.622   193.555     0.150
    13.645   194.875     0.150
    13.645   345.680     0.150
    13.840   196.945     0.150
    14.027   200.117     0.150
    14.160   201.141     0.150
    14.198   202.188     0.150
    14.198   358.508     0.150
    14.260   200.609     0.150
    14.326   202.898     0.150
    14.591   210.297     0.150
    14.619   214.953     0.150
    14.695   206.617     0.150
    14.633   214.289     0.150
    14.670   212.953     0.150
    14.670   211.625     0.150
    14.810   209.086     0.150
    14.902   210.867     0.150
    14.899   210.430     0.150
    14.863   212.953     0.150
    15.819   222.430     0.150
    15.819   224.203     0.150
    15.827   223.734     0.150
    15.895   222.273     0.150
    16.229   227.727     0.150
    16.445   231.008     0.150
    16.622   233.117     0.150
    16.688   234.648     0.150
    16.868   238.836     0.150
    17.107   239.773     0.150
    17.102   238.758     0.150
    17.089   243.008     0.150
    17.379   242.195     0.150
    17.698   249.742     0.150
    17.698   250.500     0.150
    17.728   246.641     0.150
    17.730   247.086     0.150
    17.730   249.250     0.150
    18.075   250.695     0.150
    18.086   250.734     0.150
    18.058   258.289     0.150
    18.190   259.789     0.150
    18.220   255.477     0.150
    18.270   251.977     0.150
    18.875   259.695     0.150
    18.959   265.055     0.150
    19.029   261.125     0.150
    19.143   268.953     0.150
    19.271   265.867     0.150
    19.301   268.359     0.150
    19.322   269.625     0.150
    19.462   271.539     0.150
    19.601   272.766     0.150
    19.936   275.859     0.150
    20.027   276.625     0.150
    20.178   274.609     0.150
    20.433   277.273     0.150
    20.540   276.680     0.150
    20.725   280.797     0.150
    20.846   281.094     0.150
    21.099   284.008     0.150
    21.087   287.398     0.150
    21.136   285.258     0.150
    21.426   287.875     0.150
    22.114   294.609     0.150
    22.154   298.266     0.150
    22.437   298.453     0.150
    22.437   301.695     0.150
    22.579   299.758     0.150
    22.579   303.203     0.150
    22.594   300.430     0.150
    22.544   302.500     0.150
    23.139   305.656     0.150
    23.215   307.266     0.150
    23.823   313.039     0.150
    23.851   313.078     0.150
    23.851   314.523     0.150
    23.909   312.984     0.150
    24.048   316.023     0.150
    24.089   315.750     0.150
    24.089   318.156     0.150
    24.092   316.039     0.150
    24.288   317.359     0.150
    24.423   318.734     0.150
    24.423   319.195     0.150
    24.683   322.297     0.150
    25.069   325.008     0.150
    25.210   325.305     0.150
    25.549   327.367     0.150
    25.549   331.555     0.150
    25.577   329.906     0.150
    25.828   331.500     0.150
    26.017   334.117     0.150
    26.084   334.250     0.150
    26.084   335.867     0.150
    26.496   337.453     0.150
    26.500   337.828     0.150
    26.979   342.586     0.150
    27.587   349.242     0.150
    27.603   348.922     0.150
    27.941   351.898     0.150
    28.198   354.016     0.150
    28.588   358.031     0.150
    28.721   358.883     0.150
    28.724   359.820     0.150
    29.157   363.039     0.150
    29.562   364.727     0.150
    29.635   367.258     0.150
    29.728   367.094     0.150
    29.805   367.617     0.150
    29.805   368.336     0.150
    30.184   372.352     0.150
    30.209   372.938     0.150
    30.289   372.398     0.150
    30.844   377.258     0.150
    30.882   378.492     0.150
    30.923   378.766     0.150
    31.024   377.359     0.150
    31.217   378.875     0.150
    31.775   386.336     0.150
    31.813   386.672     0.150
    32.060   388.141     0.150
    32.134   388.688     0.150
    32.213   389.336     0.150
    32.935   395.531     0.150
    32.992   396.680     0.150
    33.018   396.617     0.150
    33.095   397.672     0.150
    33.160   398.188     0.150
    33.424   399.109     0.150
    33.594   400.602     0.150
    33.804   402.375     0.150
    33.806   402.852     0.150
    33.883   404.109     0.150
    33.923   403.961     0.150
    33.930   403.812     0.150
    34.160   405.695     0.150
    34.203   405.508     0.150
    34.237   405.359     0.150
    34.255   406.258     0.150
    34.268   406.633     0.150
    34.684   411.023     0.150
    34.847   411.633     0.150
    34.935   412.875     0.150
    34.930   413.453     0.150
    35.526   417.039     0.150
    35.571   417.750     0.150
    35.886   420.102     0.150
    36.133   422.516     0.150
    36.340   424.406     0.150
    36.407   425.859     0.150
    36.482   426.531     0.150
    36.638   426.906     0.150
    36.638   427.570     0.150
    36.774   428.578     0.150
    36.772   428.195     0.150
    36.796   428.594     0.150
    36.905   429.430     0.150
    36.915   429.602     0.150
    36.998   430.742     0.150
    37.166   431.906     0.150
    37.195   431.375     0.150
    37.203   431.727     0.150
    37.259   433.609     0.150
    37.359   433.703     0.150
    37.516   434.984     0.150
    37.659   435.594     0.150
    37.665   436.102     0.150
    37.666   434.922     0.150
    37.716   436.242     0.150
    37.763   437.422     0.150
    37.793   435.133     0.150
    37.861   437.305     0.150
    37.899   437.578     0.150
    37.990   438.141     0.150
    37.941   437.805     0.150
    38.009   436.898     0.150
    38.001   437.250     0.150
    38.019   437.227     0.150
    38.053   439.773     0.150
    38.053   437.867     0.150
    38.116   440.531     0.150
    38.227   441.062     0.150
    38.237   441.633     0.150
    38.243   440.953     0.150
    38.243   442.242     0.150
    38.247   441.203     0.150
    38.247   441.852     0.150
    38.253   440.141     0.150
    38.330   441.445     0.150
    38.343   441.500     0.150
    38.352   441.898     0.150
    38.419   442.453     0.150
    38.425   443.164     0.150
    38.485   443.016     0.150
    38.503   443.648     0.150
    38.588   443.977     0.150
    38.580   443.906     0.150
    38.660   444.477     0.150
    38.685   444.500     0.150
    38.793   445.609     0.150
    38.840   445.727     0.150
    38.966   446.992     0.150
    38.983   447.102     0.150
    38.974   447.406     0.150
    38.984   447.656     0.150
    39.016   447.758     0.150
    39.115   448.219     0.150
    39.118   448.109     0.150
    39.118   448.289     0.150
    39.125   448.617     0.150
    39.259   449.602     0.150
    39.324   448.766     0.150
    39.324   450.453     0.150
    39.324   453.016     0.150
    39.339   449.727     0.150
    39.334   449.852     0.150
    39.401   449.594     0.150
    39.476   449.945     0.150
    39.570   451.867     0.150
    39.575   451.852     0.150
    39.686   452.156     0.150
    39.704   452.945     0.150
    39.704   453.539     0.150
    39.704   455.195     0.150
    39.745   453.180     0.150
    39.763   453.055     0.150
    39.779   452.859     0.150
    39.816   453.953     0.150
    39.816   452.984     0.150
    39.981   455.625     0.150
    39.987   455.031     0.150
    40.078   456.781     0.150
    40.111   457.102     0.150
    40.106   456.375     0.150
    40.142   457.094     0.150
    40.145   457.227     0.150
    40.198   457.281     0.150
    40.244   457.727     0.150
    40.286   458.266     0.150
    40.286   457.906     0.150
    40.347   458.500     0.150
    40.347   459.000     0.150
    40.392   459.898     0.150
    40.439   459.719     0.150
    40.610   460.047     0.150
    40.610   460.820     0.150
    40.625   460.820     0.150
    40.648   460.859     0.150
    40.662   461.039     0.150
    40.680   461.531     0.150
    40.714   460.695     0.150
    40.739   461.398     0.150
    40.741   461.398     0.150
    40.764   461.305     0.150
    40.799   462.219     0.150
    40.822   460.930     0.150
    40.822   462.508     0.150
    40.842   462.922     0.150
    40.877   463.086     0.150
    40.898   462.539     0.150
    40.959   463.938     0.150
    40.965   463.734     0.150
    40.993   463.414     0.150
    41.048   465.625     0.150
    41.043   464.281     0.150
    41.176   464.695     0.150
    41.179   465.414     0.150
    41.212   466.875     0.150
    41.217   465.883     0.150
    41.242   465.984     0.150
    41.314   466.711     0.150
    41.356   467.805     0.150
    41.536   468.500     0.150
    41.536   468.688     0.150
    41.624   469.117     0.150
    41.683   468.500     0.150
    41.726   470.258     0.150
    41.757   470.344     0.150
    41.739   469.906     0.150
    41.785   470.203     0.150
    41.785   469.977     0.150
    41.796   470.641     0.150
    41.824   470.922     0.150
    41.839   471.297     0.150
    41.858   471.781     0.150
    41.866   471.086     0.150
    41.905   471.195     0.150
    41.971   472.344     0.150
    41.971   472.039     0.150
    42.176   474.062     0.150
    42.187   473.695     0.150
    42.241   473.812     0.150
    42.262   474.203     0.150
    42.335   474.609     0.150
    42.365   475.359     0.150
    42.365   474.555     0.150
    42.385   475.320     0.150
    42.383   474.641     0.150
    42.432   475.641     0.150
    42.457   474.953     0.150
    42.541   474.945     0.150
    42.557   474.992     0.150
    42.653   476.484     0.150
    42.695   476.609     0.150
    42.815   479.180     0.150
    42.815   477.492     0.150
    42.814   477.117     0.150
    42.925   479.055     0.150
    42.932   478.469     0.150
    43.103   480.094     0.150
    43.132   480.523     0.150
    43.141   480.133     0.150
    43.283   481.219     0.150
    43.301   481.578     0.150
    43.351   482.008     0.150
    43.413   481.844     0.150
    43.425   482.539     0.150
    43.556   483.711     0.150
    43.659   484.758     0.150
    43.670   484.844     0.150
    43.821   486.430     0.150
    43.848   485.758     0.150
    43.854   486.125     0.150
    43.885   487.344     0.150
    43.913   486.250     0.150
    43.934   486.703     0.150
    43.959   487.398     0.150
    43.959   487.234     0.150
    44.151   489.297     0.150
    44.151   489.141     0.150
    44.149   488.727     0.150
    44.231   489.203     0.150
    44.244   490.125     0.150
    44.325   490.578     0.150
    44.332   490.398     0.150
    44.515   492.820     0.150
    44.515   491.273     0.150
    44.674   493.102     0.150
    44.797   494.758     0.150
    44.865   494.297     0.150
    44.916   494.102     0.150
    45.036   495.531     0.150
    45.050   495.688     0.150
    45.083   496.148     0.150
    45.188   496.602     0.150
    45.287   497.141     0.150
    45.396   499.484     0.150
    45.396   502.594     0.150
    45.452   498.383     0.150
    45.425   499.953     0.150
    45.425   503.758     0.150
    45.522   500.508     0.150
    45.522   499.242     0.150
    45.726   502.547     0.150
    45.767   501.305     0.150
    45.932   501.602     0.150
    45.937   504.055     0.150
    46.023   503.203     0.150
    46.095   504.195     0.150
    46.078   505.391     0.150
    46.452   506.922     0.150
    46.522   509.289     0.150
    46.569   507.234     0.150
    46.580   917.195     0.150
    46.739   509.258     0.150
    46.841   510.062     0.150
    46.813   511.414     0.150
    47.007   511.492     0.150
    47.115   511.719     0.150
    47.323   513.664     0.150
    47.660   516.906     0.150
    47.758   517.281     0.150
    48.031   519.516     0.150
    48.031   520.875     0.150
    50.747   540.758     0.150
    50.747   543.648     0.150
    54.482   565.273     0.150
    56.735   584.953     0.150
    56.735   585.797     0.150
    57.121  1288.797     0.150
    57.988   594.117     0.150
    58.882   600.898     0.150
    58.882  1087.398     0.150
    58.882  1319.094     0.150
    63.530  1145.898     0.150
    64.332   638.523     0.150
    64.937   641.953     0.150
    65.055   642.289     0.150
    65.583   644.680     0.150
    65.904   647.977     0.150
    66.501   651.008     0.150
    69.033   666.688     0.150
    69.993   673.703     0.150
    75.430   706.016     0.150
    75.842   708.234     0.150
    76.200   710.156     0.150
    77.283   714.609     0.150
    78.396   721.719     0.150
    78.506   723.109     0.150
    78.506   723.273     0.150
    79.005   725.328     0.150
    79.005   725.844     0.150
    79.904   729.266     0.150
    81.714   740.898     0.150
    81.714   740.445     0.150
    82.682   744.039     0.150
    82.682   742.891     0.150
    82.682   745.406     0.150
    84.146   753.805     0.150
    84.620   756.328     0.150
    84.803   756.281     0.150
    90.078   779.500     0.150
    90.398   780.094     0.150
    90.648   994.898     0.150
    92.725   793.859     0.150
    92.729   788.695     0.150
    93.777   800.055     0.150
    94.126   801.172     0.150
    97.213   814.000     0.150
    99.915   826.000     0.150
   113.585  1119.797     0.150
   120.537  1134.039     0.150
   121.694  1134.367     0.150
   121.694  1137.930     0.150
   138.771  1001.594     0.150
     0.519    10.191     0.150
     0.753    14.312     0.150
     0.753    24.531     0.150
     0.753    25.832     0.150
     0.787    14.422     0.150
     0.939    18.121     0.150
     0.939    30.141     0.150
     0.939    30.430     0.150
     0.939    32.332     0.150
     0.933    17.613     0.150
     0.933    30.211     0.150
     0.954    18.520     0.150
     0.954    32.500     0.150
     0.963    17.941     0.150
     0.987    34.691     0.150
     0.987    17.953     0.150
     1.105    20.621     0.150
     1.105    35.910     0.150
     1.097    19.641     0.150
     1.097    21.070     0.150
     1.097    36.680     0.150
     1.097    37.762     0.150
     1.157    20.980     0.150
     1.157    21.113     0.150
     1.157    20.902     0.150
     1.342    23.633     0.150
     1.342    45.000     0.150
     1.318    23.840     0.150
     1.491    26.422     0.150
     1.491    45.953     0.150
     1.401    42.293     0.150
     1.496    26.242     0.150
     1.422    25.230     0.150
     1.474    25.781     0.150
     1.651    27.191     0.150
     1.539    26.672     0.150
     1.561    26.320     0.150
     1.561    52.703     0.150
     1.588    26.633     0.150
     1.677    27.832     0.150
     1.677    54.992     0.150
     1.746    27.590     0.150
     1.797    30.242     0.150
     1.797    58.703     0.150
     1.887    31.910     0.150
     1.875    30.520     0.150
     2.020    34.402     0.150
     2.020    34.191     0.150
     2.020    60.480     0.150
     2.080    34.512     0.150
     2.080    60.512     0.150
     2.094    34.531     0.150
     2.154    35.551     0.150
     2.199    36.383     0.150
     2.235    37.020     0.150
     2.260    36.090     0.150
     2.402    38.312     0.150
     2.498    40.582     0.150
     2.693    42.531     0.150
     2.693    42.910     0.150
     2.693    91.586     0.150
     2.751    44.043     0.150
     3.262    50.242     0.150
     3.283    51.371     0.150
     3.641    55.840     0.150
     3.931    62.113     0.150
     3.931    60.961     0.150
     3.931   102.000     0.150
     3.893    60.230     0.150
     4.102    62.551     0.150
     4.242    64.391     0.150
     4.269    66.230     0.150
     4.388   115.230     0.150
     4.459    67.781     0.150
     4.714    71.043     0.150
     4.698    70.250     0.150
     4.793    71.742     0.150
     4.879    74.660     0.150
     5.026    80.082     0.150
     5.039    78.090     0.150
     5.260    82.301     0.150
     5.610    86.281     0.150
     5.641    84.551     0.150
     5.690    88.070     0.150
     5.926    90.051     0.150
     5.989    92.633     0.150
     6.235    91.461     0.150
     6.231    97.301     0.150
     6.535   101.211     0.150
     6.645   100.680     0.150
     6.642   102.363     0.150
     6.872   103.520     0.150
     6.907   105.121     0.150
     7.053   105.422     0.150
     7.141   106.430     0.150
     7.249   111.000     0.150
     7.499   109.480     0.150
     7.568   113.320     0.150
     7.568   112.602     0.150
     7.568   112.723     0.150
     7.568   145.484     0.150
     7.568   237.059     0.150
     7.568   111.441     0.150
     7.568   193.832     0.150
     7.563   110.723     0.150
     7.600   114.871     0.150
     7.600   114.766     0.150
     7.600   247.242     0.150
     7.778   113.750     0.150
     7.778   209.203     0.150
     7.899   118.781     0.150
     7.934   119.832     0.150
     8.182   122.961     0.150
     8.158   121.293     0.150
     8.193   122.492     0.150
     8.205   120.000     0.150
     8.207   121.980     0.150
     8.217   124.152     0.150
     8.272   123.691     0.150
     8.279   124.391     0.150
     8.279   124.422     0.150
     8.385   124.922     0.150
     8.434   125.863     0.150
     8.448   127.312     0.150
     8.831   131.012     0.150
     9.261   138.262     0.150
     9.261   301.566     0.150
     9.391   139.621     0.150
     9.592   142.762     0.150
     9.593   142.891     0.150
     9.593   141.266     0.150
     9.593   305.293     0.150
    10.373   153.070     0.150
    11.927   387.602     0.150
    11.956   174.621     0.150
    12.164   178.910     0.150
    12.439   180.031     0.150
    13.586   194.902     0.150
    14.319   204.570     0.150
    14.664   211.941     0.150
    15.110   215.762     0.150
    16.254   234.191     0.150
    16.590   237.781     0.150
    16.879   239.281     0.150
    16.879   241.234     0.150
    17.719   249.570     0.150
    17.806   250.340     0.150
    20.100   276.301     0.150
    38.854   447.312     0.150
    82.029   742.586     0.150
    96.380   808.391     0.150
   102.362   837.191     0.150
     0.510    10.711     0.150
     0.778    14.680     0.150
     0.756    13.770     0.150
     0.756    24.199     0.150
     0.926    16.629     0.150
     0.945    18.250     0.150
     0.955    17.629     0.150
     0.978    18.070     0.150
     0.941    17.141     0.150
     0.941    28.590     0.150
     0.941    29.691     0.150
     1.088    33.219     0.150
     1.104    19.012     0.150
     1.104    34.129     0.150
     1.104    20.250     0.150
     1.149    21.832     0.150
     1.151    20.082     0.150
     1.336    22.949     0.150
     1.415    24.359     0.150
     1.465    25.309     0.150
     1.495    26.031     0.150
     1.495    25.730     0.150
     1.495    45.352     0.150
     1.579    26.520     0.150
     1.670    27.430     0.150
     1.670    47.590     0.150
     1.670    27.059     0.150
     1.789    29.352     0.150
     1.883    30.250     0.150
     2.015    33.359     0.150
     2.015    33.242     0.150
     2.015    57.602     0.150
     2.074    33.930     0.150
     2.074    58.199     0.150
     2.088    34.262     0.150
     2.251    36.109     0.150
     2.396    38.070     0.150
     2.684    40.141     0.150
     2.744    43.840     0.150
     3.262    54.391     0.150
     3.262    54.750     0.150
     3.262    99.070     0.150
     3.633    55.621     0.150
     4.392   117.520     0.150
     4.461    67.219     0.150
     4.714    72.309     0.150
     4.787    70.910     0.150
     5.253    79.570     0.150
     5.364    78.621     0.150
     5.602    84.820     0.150
     5.682    84.180     0.150
     5.917    88.070     0.150
     6.643    98.629     0.150
     6.987   104.609     0.150
     7.134   106.121     0.150
     0.532    10.559     0.150
     0.799    14.629     0.150
     0.941    16.869     0.150
     0.941    28.180     0.150
     0.946    16.090     0.150
     0.967    17.289     0.150
     0.967    30.650     0.150
     0.976    17.119     0.150
     0.999    33.279     0.150
     0.999    18.449     0.150
     1.039    18.350     0.150
     1.039    33.219     0.150
     1.112    19.520     0.150
     1.112    35.680     0.150
     1.112    19.389     0.150
     1.112    19.996     0.150
     1.112    34.844     0.150
     1.169    19.539     0.150
     1.170    19.939     0.150
     1.170    20.270     0.150
     1.353    22.230     0.150
     1.353    39.949     0.150
     1.353    26.006     0.150
     1.331    22.459     0.150
     1.491    24.900     0.150
     1.491    43.199     0.150
     1.491    47.309     0.150
     1.503    24.939     0.150
     1.428    24.059     0.150
     1.487    24.539     0.150
     1.551    25.270     0.150
     1.574    25.480     0.150
     1.599    26.180     0.150
     1.690    26.889     0.150
     1.690    47.459     0.150
     1.809    28.840     0.150
     1.897    30.430     0.150
     1.897    34.646     0.150
     1.897    59.021     0.150
     2.032    32.580     0.150
     2.032    33.311     0.150
     2.106    33.580     0.150
     2.106    38.402     0.150
     2.270    36.459     0.150
     2.706    40.990     0.150
     2.757    43.389     0.150
     3.296    49.389     0.150
     3.257    49.629     0.150
     3.257    49.490     0.150
     3.650    56.449     0.150
     3.895    58.939     0.150
     4.451    66.369     0.150
     4.709    70.820     0.150
     4.798    72.900     0.150
     4.879    74.129     0.150
     5.038    73.799     0.150
     5.050    75.369     0.150
     5.267    78.799     0.150
     5.619    83.920     0.150
     5.653    81.010     0.150
     5.698    85.230     0.150
     6.985   101.270     0.150
     7.147   105.980     0.150
     7.566   111.520     0.150
     7.771   112.059     0.150
     7.906   114.330     0.150
     8.162   119.719     0.150
     8.167   118.949     0.150
     8.210   116.629     0.150
     0.476    10.006     0.150
     0.476    16.756     0.150
     0.743    14.516     0.150
     0.743    24.904     0.150
     0.934    16.365     0.150
     0.934    28.785     0.150
     0.934    16.525     0.150
     0.934    30.225     0.150
     0.890    15.904     0.150
     0.890    28.064     0.150
     0.919    16.805     0.150
     0.947    17.525     0.150
     1.083    18.664     0.150
     1.083    19.145     0.150
     1.083    32.945     0.150
     1.053    21.135     0.150
     1.118    19.824     0.150
     1.113    19.664     0.150
     1.304    21.955     0.150
     1.493    24.875     0.150
     1.493    43.855     0.150
     1.493    46.945     0.150
     1.475    24.914     0.150
     1.475    44.164     0.150
     1.401    22.904     0.150
     1.548    25.295     0.150
     1.634    26.484     0.150
     1.855    29.725     0.150
     1.983    32.744     0.150
     1.983    32.205     0.150
     1.983    58.414     0.150
     2.041    33.096     0.150
     2.041    58.725     0.150
     2.224    35.275     0.150
     2.649    40.355     0.150
     2.730    42.176     0.150
     3.240    47.285     0.150
     3.277    48.705     0.150
     3.609    55.654     0.150
     3.882    57.895     0.150
     4.204    62.334     0.150
     4.484    68.414     0.150
     4.776    71.584     0.150
     4.875    72.426     0.150
     5.235    78.715     0.150
     5.579    83.285     0.150
     5.661    85.125     0.150
     0.215     4.645     0.150
     0.215     8.035     0.150
     1.063    18.535     0.150
     1.063    33.525     0.150
     1.063    18.766     0.150
     1.275    21.516     0.150
     1.528    25.945     0.150
     1.624    28.125     0.150
     1.624    49.406     0.150
     1.624    27.785     0.150
     1.624    50.855     0.150
     1.642    28.045     0.150
     1.642    49.865     0.150
     2.061    34.416     0.150
     2.622    41.715     0.150
     2.720    42.846     0.150
     2.907    45.406     0.150
     2.930    47.285     0.150
     2.928    45.645     0.150
     3.151    48.816     0.150
     3.220    50.455     0.150
     3.245    51.266     0.150
     3.245    51.035     0.150
     3.245    91.416     0.150
     3.341    51.885     0.150
     3.341    93.566     0.150
     3.408    53.096     0.150
     3.614    56.215     0.150
     3.490    93.775     0.150
     3.780    58.566     0.150
     3.780    58.215     0.150
     3.879    59.895     0.150
     4.022   104.266     0.150
     4.172    64.305     0.150
     4.211    64.246     0.150
     4.211    63.949     0.150
     4.211   130.674     0.150
     4.465    68.336     0.150
     4.680    71.066     0.150
     5.085    76.695     0.150
     5.100    77.906     0.150
     5.217    77.486     0.150
     5.856    88.285     0.150
     5.867    89.115     0.150
     5.856    88.215     0.150
     6.099    92.686     0.150
     6.190    89.295     0.150
     6.639   100.916     0.150
     6.668   100.236     0.150
     6.723   102.045     0.150
     6.726   101.105     0.150
     6.850   101.965     0.150
     7.162   107.795     0.150
     7.213   108.676     0.150
     7.206   107.215     0.150
     7.270   109.105     0.150
     7.441   110.455     0.150
     7.453   110.166     0.150
     7.306   109.256     0.150
     7.510   111.045     0.150
     7.551   113.316     0.150
     7.592   111.475     0.150
     7.687   112.785     0.150
     7.769   114.605     0.150
     7.864   116.406     0.150
     7.984   117.695     0.150
     8.123   116.635     0.150
     8.033   121.506     0.150
     8.245   119.605     0.150
     8.245   120.416     0.150
     8.245   119.875     0.150
     8.245   120.250     0.150
     8.245   213.574     0.150
     8.255   118.775     0.150
     8.567   123.965     0.150
     8.644   124.285     0.150
     8.710   125.186     0.150
     8.995   132.625     0.150
     9.106   130.326     0.150
     9.199   132.072     0.150
     9.199   285.295     0.150
     9.127   133.805     0.150
     9.151   133.506     0.150
     9.152   133.516     0.150
     9.152   131.266     0.150
     9.152   276.342     0.150
     9.227   136.246     0.150
     9.376   134.066     0.150
     9.428   135.545     0.150
     9.455   136.816     0.150
     9.383   138.105     0.150
     9.479   135.285     0.150
     9.449   134.525     0.150
     9.940   142.086     0.150
     9.932   144.455     0.150
    10.215   149.055     0.150
    10.447   152.266     0.150
    10.884   157.156     0.150
    11.304   164.035     0.150
    12.722   183.875     0.150
    13.389   194.436     0.150
    13.389   189.586     0.150
    14.598   209.846     0.150
    14.773   209.816     0.150
    14.815   210.945     0.150
    15.118   213.375     0.150
    15.113   215.986     0.150
    15.931   231.766     0.150
    15.896   226.256     0.150
    16.296   228.365     0.150
    16.341   234.666     0.150
    16.316   233.955     0.150
    16.554   233.926     0.150
    16.688   236.416     0.150
    16.932   235.596     0.150
    17.134   237.756     0.150
    17.223   241.426     0.150
    17.891   249.076     0.150
    18.026   251.055     0.150
    18.078   249.215     0.150
    18.098   251.695     0.150
    18.324   252.355     0.150
    18.292   256.115     0.150
    18.507   259.256     0.150
    18.883   259.926     0.150
    19.440   268.326     0.150
    19.426   269.355     0.150
    19.662   270.105     0.150
    20.501   280.496     0.150
    20.531   280.455     0.150
    21.433   290.535     0.150
    21.703   292.406     0.150
    21.740   296.725     0.150
    22.079   297.355     0.150
    22.113   297.986     0.150
    22.572   302.656     0.150
    22.910   306.066     0.150
    23.366   311.195     0.150
    23.362   311.576     0.150
    24.562   323.045     0.150
    24.849   326.516     0.150
    25.284   330.525     0.150
    38.776   447.566     0.150
    39.002   449.316     0.150
    40.457   461.205     0.150
    41.071   464.906     0.150
    41.705   470.645     0.150
    41.861   470.666     0.150
    41.865   471.336     0.150
    41.994   473.076     0.150
    42.464   476.336     0.150
    42.526   476.525     0.150
    42.966   480.385     0.150
    43.103   481.236     0.150
    43.361   483.625     0.150
    44.556   492.975     0.150
    45.358   501.865     0.150
    72.164   688.686     0.150
    72.473   690.016     0.150
    72.544   692.305     0.150
    85.202   757.016     0.150
     0.204     4.822     0.150
     0.204     8.191     0.150
     1.022    18.553     0.150
     1.022    33.973     0.150
     1.285    21.371     0.150
     1.579    25.633     0.150
     1.579    45.883     0.150
     1.656    27.973     0.150
     1.656    49.502     0.150
     1.658    27.941     0.150
     1.658    49.992     0.150
     1.813    28.803     0.150
     1.817    32.432     0.150
     2.095    34.701     0.150
     2.095    34.281     0.150
     2.340    37.812     0.150
     2.473    41.562     0.150
     2.660    41.611     0.150
     2.921    45.611     0.150
     2.921    44.633     0.150
     2.958    45.791     0.150
     3.193    48.893     0.150
     3.269    48.691     0.150
     3.279    51.062     0.150
     3.445    53.393     0.150
     3.819    59.133     0.150
     3.929    59.973     0.150
     4.037    67.672     0.150
     4.222    63.742     0.150
     4.253    64.320     0.150
     4.253    75.797     0.150
     4.253   133.021     0.150
     4.490    68.082     0.150
     4.717    71.312     0.150
     5.134    77.291     0.150
     5.901    87.912     0.150
     5.917    88.492     0.150
     6.149    92.553     0.150
     6.718   100.352     0.150
     7.267   108.941     0.150
     8.283   120.096     0.150
     8.695   126.803     0.150
     9.013   132.322     0.150
     9.158   133.762     0.150
     9.158   132.178     0.150
     9.158   287.150     0.150
     9.244   136.352     0.150
     9.949   144.963     0.150
    10.300   147.723     0.150
    10.457   152.121     0.150
    10.934   158.693     0.150
    11.318   164.053     0.150
    13.440   193.652     0.150
    15.564   222.932     0.150
    15.908   225.031     0.150
    40.502   461.354     0.150
     0.402     8.242     0.150
     0.402    15.648     0.150
     0.513     9.789     0.150
     0.513    16.695     0.150
     0.676    23.305     0.150
     0.778    14.398     0.150
     0.778    25.305     0.150
     0.871    16.055     0.150
     0.871    26.828     0.150
     0.852    14.836     0.150
     0.852    26.953     0.150
     0.862    15.688     0.150
     0.862    27.797     0.150
     0.903    29.414     0.150
     1.025    18.117     0.150
     1.025    32.297     0.150
     1.055    20.078     0.150
     1.140    19.883     0.150
     1.288    22.562     0.150
     1.307    21.789     0.150
     1.456    24.984     0.150
     1.450    24.688     0.150
     1.592    26.734     0.150
     1.592    46.898     0.150
     1.592    49.617     0.150
     1.593    25.180     0.150
     1.877    29.586     0.150
     1.979    32.117     0.150
     2.036    32.742     0.150
     2.117    34.539     0.150
     2.316    37.383     0.150
     2.357    37.406     0.150
     2.494    39.312     0.150
     2.574    41.195     0.150
     2.590    40.508     0.150
     2.617    42.016     0.150
     3.212    48.688     0.150
     3.498    51.906     0.150
     3.733    56.242     0.150
     3.775    57.898     0.150
     3.951    59.805     0.150
     4.008    58.695     0.150
     3.971    60.273     0.150
     4.020    61.156     0.150
     4.149    63.125     0.150
     4.446    66.094     0.150
     4.665    70.125     0.150
     4.665    70.836     0.150
     4.762    70.578     0.150
     4.777    71.555     0.150
     4.898    73.078     0.150
     4.899    73.328     0.150
     5.121    78.695     0.150
     5.278    79.336     0.150
     5.467    81.555     0.150
     5.507    82.188     0.150
     5.548    84.227     0.150
     5.785    86.758     0.150
     5.980    86.195     0.150
     6.063    88.539     0.150
     6.412    93.203     0.150
     6.574    95.844     0.150
     6.767   100.383     0.150
     6.799    98.758     0.150
     6.920   101.359     0.150
     6.909   100.648     0.150
     7.005   102.930     0.150
     7.356   107.695     0.150
     7.443   107.938     0.150
     7.754   113.414     0.150
     7.806   114.648     0.150
     8.002   116.086     0.150
     8.065   116.984     0.150
     8.075   115.953     0.150
     8.079   118.789     0.150
     8.080   114.609     0.150
     8.104   117.695     0.150
     0.547    10.756     0.150
     0.547    17.904     0.150
     0.707    13.545     0.150
     0.707    24.154     0.150
     0.752    13.994     0.150
     0.752    24.584     0.150
     0.752    25.574     0.150
     1.051    19.645     0.150
     1.051    34.244     0.150
     1.235    20.605     0.150
     1.235    37.805     0.150
     1.256    23.225     0.150
     1.307    23.234     0.150
     1.307    41.936     0.150
     1.317    25.074     0.150
     1.317    43.186     0.150
     1.541    27.266     0.150
     2.994    55.164     0.150
     2.994   102.414     0.150
     7.513   114.064     0.150
     7.513   138.414     0.150
     7.513   237.439     0.150
     7.889   120.650     0.150
     7.889   263.645     0.150
     9.360   135.869     0.150
     9.360   293.223     0.150
     9.503   141.096     0.150
     9.503   306.619     0.150
    12.087   389.695     0.150
    12.461   181.783     0.150
    17.127   244.414     0.150
    39.139   450.494     0.150
     0.447     8.967     0.150
     0.447    15.928     0.150
     1.250    22.617     0.150
     1.330    23.826     0.150
     1.330    42.416     0.150
     1.330    23.928     0.150
     1.330    43.557     0.150
     1.452    24.996     0.150
     1.452    43.547     0.150
     1.470    26.227     0.150
     1.515    24.477     0.150
     1.515    43.627     0.150
     1.581    26.717     0.150
     1.581    49.586     0.150
     1.581    51.287     0.150
     1.570    27.848     0.150
     1.878    31.336     0.150
     2.166    35.727     0.150
     2.084    35.207     0.150
     2.236    38.467     0.150
     2.275    36.277     0.150
     2.179    36.678     0.150
     2.262    38.008     0.150
     3.047    47.598     0.150
     2.983    47.277     0.150
     2.983    82.826     0.150
     3.137    49.086     0.150
     3.137    85.797     0.150
     3.295    54.146     0.150
     3.295    92.678     0.150
     3.538    55.787     0.150
     3.538    94.688     0.150
     3.635    56.518     0.150
     3.936    61.777     0.150
     3.936   105.996     0.150
     5.299    80.527     0.150
     5.299   138.797     0.150
     6.053    88.467     0.150
     6.053   159.086     0.150
     0.600    11.332     0.150
     0.600    19.082     0.150
     0.718    13.683     0.150
     0.718    23.072     0.150
     0.794    14.752     0.150
     0.794    26.002     0.150
     1.109    20.183     0.150
     1.109    33.832     0.150
     1.088    18.342     0.150
     1.088    34.752     0.150
     1.180    20.952     0.150
     1.225    20.902     0.150
     1.225    21.683     0.150
     1.224    21.462     0.150
     1.371    23.192     0.150
     1.347    23.962     0.150
     1.376    22.962     0.150
     1.439    24.053     0.150
     1.439    26.832     0.150
     1.674    28.822     0.150
     1.674    50.132     0.150
     1.636    26.162     0.150
     2.044    34.143     0.150
     2.089    32.612     0.150
     2.192    35.763     0.150
     2.186    37.092     0.150
     2.352    37.572     0.150
     2.552    40.322     0.150
     2.544    39.143     0.150
     2.601    41.252     0.150
     2.619    40.992     0.150
     2.686    41.922     0.150
     3.126    46.763     0.150
     3.244    48.103     0.150
     3.698    56.013     0.150
     4.595    66.853     0.150
     0.716    13.836     0.150
     0.716    23.316     0.150
     0.975    17.426     0.150
     0.975    30.574     0.150
     0.981    17.957     0.150
     0.997    17.797     0.150
     0.997    31.844     0.150
     1.104    20.176     0.150
     1.104    36.297     0.150
     1.229    22.637     0.150
     1.456    25.625     0.150
     1.468    25.297     0.150
     1.492    28.566     0.150
     1.605    28.605     0.150
     1.587    27.707     0.150
     1.649    27.445     0.150
     1.658    27.125     0.150
     1.771    31.266     0.150
     1.818    30.625     0.150
     1.851    32.387     0.150
     1.902    31.375     0.150
     1.948    36.816     0.150
     1.948    34.023     0.150
     1.948    61.504     0.150
     1.983    32.637     0.150
     2.291    37.363     0.150
     2.339    38.105     0.150
     2.348    38.113     0.150
     2.348    37.906     0.150
     2.573    41.727     0.150
     2.573    41.414     0.150
     2.651    41.945     0.150
     2.651    72.355     0.150
     2.736    49.773     0.150
     2.804    44.566     0.150
     2.939    46.707     0.150
     3.022    47.746     0.150
     3.082    48.875     0.150
     3.184    50.535     0.150
     3.217    50.145     0.150
     3.276    51.934     0.150
     3.280    51.055     0.150
     3.280    49.195     0.150
     3.280    87.324     0.150
     3.370    53.863     0.150
     3.348    53.316     0.150
     3.348    52.625     0.150
     3.348   101.387     0.150
     3.378    57.402     0.150
     3.378   107.105     0.150
     3.378    52.426     0.150
     3.425    54.305     0.150
     3.926    60.227     0.150
     3.937    61.395     0.150
     4.037    61.484     0.150
     4.037   109.684     0.150
     4.114    64.957     0.150
     4.114   114.676     0.150
     4.977    75.305     0.150
     5.256    80.516     0.150
     5.730    86.094     0.150
     5.822    88.895     0.150
     6.292    94.875     0.150
     7.608   111.855     0.150
     7.710   114.504     0.150
     7.710   244.277     0.150
     7.710   114.363     0.150
     7.934   116.695     0.150
     8.165   120.207     0.150
     8.310   125.609     0.150
     8.627   127.215     0.150
     9.122   133.797     0.150
     9.253   134.762     0.150
     9.253   295.930     0.150
     9.253   135.504     0.150
     9.943   147.109     0.150
    10.042   146.273     0.150
    10.167   148.246     0.150
    10.415   151.914     0.150
    10.473   152.164     0.150
    11.081   161.516     0.150
    11.288   163.594     0.150
    12.493   184.137     0.150
    13.556   195.137     0.150
    14.291   204.656     0.150
    15.046   214.406     0.150
    15.501   218.875     0.150
    15.526   220.645     0.150
    17.568   250.230     0.150
    18.900   262.816     0.150
    39.565   456.184     0.150
    97.072   811.887     0.150
     0.737    14.094     0.150
     0.737    24.105     0.150
     0.959    18.543     0.150
     0.959    32.535     0.150
     1.013    18.062     0.150
     1.013    31.805     0.150
     1.003    18.734     0.150
     1.003    18.145     0.150
     1.003    31.812     0.150
     1.128    20.684     0.150
     1.128    36.742     0.150
     1.128    20.785     0.150
     1.272    21.773     0.150
     1.464    26.285     0.150
     1.498    25.926     0.150
     1.535    26.355     0.150
     1.553    26.965     0.150
     1.553    49.543     0.150
     1.646    28.074     0.150
     1.702    28.402     0.150
     1.700    28.766     0.150
     1.780    29.773     0.150
     1.787    30.145     0.150
     1.806    32.203     0.150
     1.844    31.293     0.150
     1.893    32.914     0.150
     1.893    31.293     0.150
     1.939    32.273     0.150
     2.020    33.055     0.150
     2.334    37.883     0.150
     2.380    38.926     0.150
     2.380    39.504     0.150
     2.609    42.215     0.150
     2.609    81.715     0.150
     2.609    42.414     0.150
     2.609    42.555     0.150
     2.688    42.984     0.150
     2.688    76.664     0.150
     2.842    45.266     0.150
     2.980    47.234     0.150
     3.065    48.605     0.150
     3.123    50.516     0.150
     3.223    52.223     0.150
     3.254    51.465     0.150
     3.287    51.895     0.150
     3.287    50.574     0.150
     3.287    51.453     0.150
     3.311    52.355     0.150
     3.315    52.414     0.150
     3.412    53.965     0.150
     3.420    63.059     0.150
     3.420    93.258     0.150
     3.420    55.805     0.150
     3.420    58.223     0.150
     3.468    54.984     0.150
     4.019    61.363     0.150
     4.019   110.945     0.150
     4.019    61.613     0.150
     5.287    81.254     0.150
     5.737    87.836     0.150
     6.329    95.926     0.150
     6.879   102.242     0.150
     7.600   112.016     0.150
     7.600   110.523     0.150
     7.721   113.332     0.150
     7.721   115.684     0.150
     7.721   114.805     0.150
     7.921   117.375     0.150
     8.689   130.445     0.150
     8.876   130.883     0.150
     9.234   135.113     0.150
     9.234   238.016     0.150
     9.234   293.539     0.150
     9.234   134.945     0.150
     9.466   142.152     0.150
     9.985   144.590     0.150
    10.036   148.676     0.150
    10.142   150.305     0.150
    10.305   151.703     0.150
    10.458   152.445     0.150
    10.521   155.113     0.150
    11.015   163.164     0.150
    11.230   164.074     0.150
    12.169   179.203     0.150
    12.529   179.562     0.150
    12.766   186.973     0.150
    13.557   194.883     0.150
    13.557   195.086     0.150
    14.235   207.844     0.150
    14.360   209.695     0.150
    14.591   212.973     0.150
    14.618   215.625     0.150
    14.966   219.434     0.150
    15.555   221.633     0.150
    15.655   223.145     0.150
    15.871   225.902     0.150
    15.871   226.324     0.150
    16.123   232.734     0.150
    16.361   232.723     0.150
    16.473   234.473     0.150
    17.610   248.781     0.150
    19.005   265.133     0.150
    22.399   301.855     0.150
    22.602   302.336     0.150
    23.807   317.090     0.150
    25.487   331.133     0.150
    31.731   389.219     0.150
    39.233   453.223     0.150
    39.608   456.434     0.150
    46.613   917.715     0.150
    58.909  1087.914     0.150
    58.909  1321.113     0.150
    63.563  1390.715     0.150
    97.114   812.312     0.150
   103.115   842.113     0.150
     0.321     7.208     0.150
     0.321    12.138     0.150
     0.321    12.418     0.150
     0.466     9.228     0.150
     0.466    15.617     0.150
     0.466    16.888     0.150
     0.593    11.478     0.150
     0.765    13.178     0.150
     0.761    13.867     0.150
     0.761    24.758     0.150
     0.777    13.798     0.150
     0.777    25.317     0.150
     0.787    14.577     0.150
     0.787    26.058     0.150
     0.827    14.968     0.150
     0.827    26.277     0.150
     0.827    26.897     0.150
     0.863    15.758     0.150
     0.863    29.617     0.150
     0.906    17.088     0.150
     0.906    29.748     0.150
     0.947    17.117     0.150
     0.947    17.008     0.150
     0.935    15.708     0.150
     0.935    28.308     0.150
     0.998    17.808     0.150
     0.970    16.518     0.150
     0.970    30.268     0.150
     1.030    17.228     0.150
     1.029    17.728     0.150
     1.029    32.018     0.150
     1.082    19.027     0.150
     1.117    19.208     0.150
     1.194    20.348     0.150
     1.210    20.208     0.150
     1.210    20.027     0.150
     1.217    19.468     0.150
     1.265    20.758     0.150
     1.265    40.058     0.150
     1.274    21.128     0.150
     1.279    22.027     0.150
     1.337    21.888     0.150
     1.351    22.138     0.150
     1.382    25.138     0.150
     1.388    22.947     0.150
     1.394    22.607     0.150
     1.471    24.288     0.150
     1.485    23.817     0.150
     1.515    25.438     0.150
     1.531    24.298     0.150
     1.574    26.567     0.150
     1.608    25.447     0.150
     1.632    24.808     0.150
     1.800    29.027     0.150
     1.845    29.508     0.150
     1.895    56.848     0.150
     1.895    30.317     0.150
     1.946    30.638     0.150
     1.946    58.647     0.150
     2.000    30.628     0.150
     2.050    32.107     0.150
     2.067    32.938     0.150
     2.081    31.897     0.150
     2.110    33.208     0.150
     2.253    34.888     0.150
     2.230    33.867     0.150
     2.272    35.998     0.150
     2.326    35.758     0.150
     2.407    36.897     0.150
     2.470    38.008     0.150
     2.491    37.447     0.150
     2.506    38.526     0.150
     2.506    75.352     0.150
     2.506    37.848     0.150
     2.521    39.018     0.150
     2.535    38.708     0.150
     2.607    40.958     0.150
     2.859    43.518     0.150
     3.030    46.447     0.150
     3.114    46.498     0.150
     3.228    51.008     0.150
     3.232    48.907     0.150
     3.270    49.538     0.150
     3.270    49.357     0.150
     3.270    81.397     0.150
     3.458    52.857     0.150
     3.615    54.107     0.150
     3.680    54.208     0.150
     3.743    58.308     0.150
     3.785    57.897     0.150
     3.908    74.407     0.150
     3.933    57.808     0.150
     3.935    58.308     0.150
     4.095    60.607     0.150
     4.095    60.907     0.150
     4.491    66.768     0.150
     4.491   114.117     0.150
     4.519    67.697     0.150
     4.556    66.838     0.150
     4.662    70.527     0.150
     4.791    73.848     0.150
     4.802    72.067     0.150
     4.946    73.228     0.150
     5.801    86.208     0.150
     7.401   107.808     0.150
     7.401   231.211     0.150
     7.401   107.647     0.150
     7.450   110.777     0.150
     7.450   110.308     0.150
     7.525   110.552     0.150
     7.525   233.677     0.150
     7.525   110.008     0.150
     7.525   111.808     0.150
     7.823   113.758     0.150
     7.823   112.987     0.150
     7.823   113.928     0.150
     8.249   120.407     0.150
     8.432   125.252     0.150
     8.432   274.627     0.150
     8.432   120.038     0.150
     8.432   211.647     0.150
     8.616   128.128     0.150
     8.682   125.918     0.150
     9.032   133.718     0.150
     9.032   131.348     0.150
     8.964   220.527     0.150
     9.089   130.577     0.150
     9.089   227.048     0.150
     9.089   132.277     0.150
     9.065   284.607     0.150
     9.458   237.708     0.150
     9.561   137.638     0.150
     9.684   139.683     0.150
     9.684   306.407     0.150
     9.869   143.128     0.150
    10.196   148.088     0.150
    10.196   149.728     0.150
    10.432   147.478     0.150
    10.832   156.748     0.150
    10.881   158.777     0.150
    10.881   158.498     0.150
    11.216   163.958     0.150
    11.404   166.628     0.150
    11.761   168.907     0.150
    11.761   371.758     0.150
    11.761   169.367     0.150
    11.864   173.258     0.150
    11.975   296.197     0.150
    11.969   174.336     0.150
    11.969   378.256     0.150
    12.227   174.848     0.150
    12.302   176.018     0.150
    12.445   179.197     0.150
    12.710   179.038     0.150
    13.320   189.188     0.150
    13.562   192.808     0.150
    13.562   195.708     0.150
    13.868   196.447     0.150
    13.868   196.048     0.150
    13.868   343.558     0.150
    13.868   201.098     0.150
    13.880   193.938     0.150
    14.042   197.107     0.150
    14.555   205.678     0.150
    14.553   204.407     0.150
    14.594   210.268     0.150
    14.848   206.478     0.150
    14.908   211.258     0.150
    14.927   211.548     0.150
    15.070   216.027     0.150
    15.138   216.378     0.150
    15.575   217.867     0.150
    15.575   384.848     0.150
    15.596   217.298     0.150
    15.596   385.367     0.150
    15.610   217.348     0.150
    15.610   385.958     0.150
    15.801   224.918     0.150
    15.855   220.737     0.150
    15.855   392.157     0.150
    16.089   227.508     0.150
    16.127   224.447     0.150
    16.185   228.147     0.150
    16.680   235.727     0.150
    16.680   523.227     0.150
    16.680   235.878     0.150
    16.749   230.388     0.150
    16.953   240.748     0.150
    16.953   237.048     0.150
    17.595   243.098     0.150
    17.810   249.958     0.150
    17.953   246.938     0.150
    17.954   246.938     0.150
    17.948   247.718     0.150
    18.220   254.357     0.150
    18.245   250.258     0.150
    18.272   251.458     0.150
    18.305   252.327     0.150
    18.381   257.817     0.150
    18.410   256.138     0.150
    18.445   254.468     0.150
    18.467   257.018     0.150
    18.475   254.888     0.150
    18.491   257.147     0.150
    18.519   254.258     0.150
    18.520   254.548     0.150
    18.573   259.027     0.150
    18.584   259.567     0.150
    18.568   258.208     0.150
    18.615   257.168     0.150
    18.620   258.388     0.150
    18.588   255.808     0.150
    18.671   258.867     0.150
    18.722   259.268     0.150
    19.074   261.558     0.150
    19.075   261.558     0.150
    19.092   264.407     0.150
    19.095   263.168     0.150
    19.123   266.088     0.150
    19.142   263.958     0.150
    19.143   264.518     0.150
    19.178   263.657     0.150
    19.189   265.418     0.150
    19.242   263.518     0.150
    19.316   264.168     0.150
    19.506   267.548     0.150
    20.137   275.498     0.150
    20.186   277.617     0.150
    20.186   275.378     0.150
    20.222   277.168     0.150
    20.383   278.348     0.150
    20.385   278.058     0.150
    20.496   279.758     0.150
    20.812   283.638     0.150
    20.932   284.748     0.150
    21.330   290.338     0.150
    21.365   289.897     0.150
    21.751   294.378     0.150
    21.751   294.378     0.150
    21.833   293.048     0.150
    21.948   295.348     0.150
    22.251   300.817     0.150
    22.597   303.168     0.150
    22.764   302.808     0.150
    22.764   303.878     0.150
    23.011   307.102     0.150
    23.011   306.768     0.150
    23.195   306.008     0.150
    23.195   558.907     0.150
    23.195   726.758     0.150
    23.195   305.558     0.150
    23.383   310.277     0.150
    23.462   309.867     0.150
    23.800   312.308     0.150
    23.903   313.788     0.150
    23.903   314.107     0.150
    24.018   316.128     0.150
    24.017   315.918     0.150
    24.017   315.668     0.150
    24.531   321.327     0.150
    24.719   321.407     0.150
    24.719   321.768     0.150
    25.215   326.478     0.150
    25.452   328.258     0.150
    25.509   330.947     0.150
    26.069   334.728     0.150
    26.536   339.752     0.150
    26.552   340.021     0.150
    27.148   345.607     0.150
    27.148   345.128     0.150
    27.538   348.933     0.150
    27.671   349.801     0.150
    27.673   349.945     0.150
    28.190   354.314     0.150
    28.585   358.523     0.150
    28.669   359.817     0.150
    28.757   360.054     0.150
    29.152   362.429     0.150
    29.159   363.015     0.150
    29.239   363.729     0.150
    29.794   368.874     0.150
    29.832   370.107     0.150
    29.833   369.568     0.150
    29.873   369.784     0.150
    29.980   369.728     0.150
    30.174   371.973     0.150
    30.369   373.240     0.150
    30.523   376.857     0.150
    30.725   376.950     0.150
    30.829   376.407     0.150
    30.829   376.237     0.150
    31.011   379.357     0.150
    31.084   380.808     0.150
    31.084   380.211     0.150
    31.173   380.561     0.150
    31.886   387.366     0.150
    31.942   387.808     0.150
    32.072   388.628     0.150
    32.109   389.522     0.150
    32.373   391.958     0.150
    32.756   394.698     0.150
    32.832   396.186     0.150
    32.873   395.930     0.150
    33.112   398.083     0.150
    33.154   398.700     0.150
    33.186   399.349     0.150
    33.217   399.407     0.150
    33.586   403.277     0.150
    33.634   403.454     0.150
    33.798   405.091     0.150
    33.885   405.838     0.150
    34.044   406.107     0.150
    34.157   407.512     0.150
    34.236   408.413     0.150
    34.415   411.918     0.150
    34.397   409.481     0.150
    34.475   410.376     0.150
    34.606   411.372     0.150
    34.661   411.653     0.150
    34.837   413.433     0.150
    34.957   414.564     0.150
    35.026   415.217     0.150
    35.082   415.458     0.150
    35.274   417.183     0.150
    35.292   417.265     0.150
    35.356   418.392     0.150
    35.591   420.232     0.150
    35.725   421.531     0.150
    35.729   421.433     0.150
    35.745   421.486     0.150
    35.854   421.598     0.150
    35.864   422.107     0.150
    35.943   422.697     0.150
    35.949   423.083     0.150
    36.118   423.977     0.150
    36.149   424.232     0.150
    36.157   424.413     0.150
    36.217   424.808     0.150
    36.309   425.946     0.150
    36.364   426.907     0.150
    36.466   427.571     0.150
    36.616   429.001     0.150
    36.618   428.215     0.150
    36.715   428.383     0.150
    36.767   429.780     0.150
    36.840   431.407     0.150
    36.840   430.049     0.150
    36.851   430.644     0.150
    36.948   430.887     0.150
    36.903   431.485     0.150
    36.959   431.338     0.150
    36.972   431.551     0.150
    36.986   432.197     0.150
    37.007   432.075     0.150
    37.085   432.365     0.150
    37.186   432.782     0.150
    37.188   432.808     0.150
    37.196   433.358     0.150
    37.199   432.599     0.150
    37.206   433.406     0.150
    37.293   433.021     0.150
    37.293   434.115     0.150
    37.308   434.165     0.150
    37.374   435.508     0.150
    37.374   434.928     0.150
    37.418   435.273     0.150
    37.480   435.936     0.150
    37.550   435.683     0.150
    37.618   435.449     0.150
    37.635   437.107     0.150
    37.674   437.150     0.150
    37.692   436.027     0.150
    37.744   437.411     0.150
    37.810   437.566     0.150
    37.849   438.603     0.150
    37.927   439.271     0.150
    37.934   439.232     0.150
    37.982   440.153     0.150
    38.074   441.027     0.150
    38.077   440.334     0.150
    38.102   439.808     0.150
    38.210   441.508     0.150
    38.287   441.782     0.150
    38.287   441.907     0.150
    38.293   442.316     0.150
    38.307   441.965     0.150
    38.360   442.773     0.150
    38.360   442.774     0.150
    38.426   442.890     0.150
    38.515   443.471     0.150
    38.526   444.054     0.150
    38.552   444.690     0.150
    38.636   445.416     0.150
    38.654   445.058     0.150
    38.727   445.606     0.150
    38.749   445.323     0.150
    38.765   446.496     0.150
    38.926   447.308     0.150
    38.933   447.688     0.150
    38.955   447.499     0.150
    39.027   448.208     0.150
    39.027   447.508     0.150
    39.027   447.827     0.150
    39.061   448.765     0.150
    39.089   449.060     0.150
    39.094   448.878     0.150
    39.102   449.200     0.150
    39.104   448.752     0.150
    39.158   449.708     0.150
    39.207   450.242     0.150
    39.216   449.324     0.150
    39.236   450.216     0.150
    39.300   451.296     0.150
    39.343   451.683     0.150
    39.576   452.716     0.150
    39.644   453.232     0.150
    39.688   454.092     0.150
    39.691   454.008     0.150
    39.769   454.375     0.150
    39.776   454.883     0.150
    39.848   454.771     0.150
    39.873   454.773     0.150
    39.910   456.298     0.150
    39.917   455.521     0.150
    39.951   456.356     0.150
    40.000   457.383     0.150
    40.004   456.183     0.150
    40.067   457.256     0.150
    40.117   457.583     0.150
    40.142   457.583     0.150
    40.151   457.423     0.150
    40.167   458.183     0.150
    40.268   458.526     0.150
    40.307   460.032     0.150
    40.493   460.977     0.150
    40.574   461.285     0.150
    40.646   461.966     0.150
    40.678   462.958     0.150
    40.708   460.907     0.150
    40.708   459.397     0.150
    40.716   462.435     0.150
    40.773   462.657     0.150
    40.801   462.539     0.150
    40.816   463.208     0.150
    40.816   463.508     0.150
    40.826   463.554     0.150
    40.921   464.308     0.150
    41.137   465.793     0.150
    41.142   466.232     0.150
    41.195   466.141     0.150
    41.306   467.141     0.150
    41.314   467.867     0.150
    41.340   467.099     0.150
    41.344   467.351     0.150
    41.387   468.508     0.150
    41.408   469.083     0.150
    41.518   470.007     0.150
    41.612   469.133     0.150
    41.645   469.758     0.150
    41.659   470.258     0.150
    41.705   471.482     0.150
    41.746   470.657     0.150
    41.768   471.482     0.150
    41.783   470.582     0.150
    41.879   472.657     0.150
    41.881   471.980     0.150
    41.957   471.536     0.150
    42.058   474.107     0.150
    42.027   471.447     0.150
    42.055   473.275     0.150
    42.091   474.248     0.150
    42.252   475.230     0.150
    42.301   475.503     0.150
    42.375   476.221     0.150
    42.384   475.463     0.150
    42.517   479.008     0.150
    42.522   476.482     0.150
    42.609   478.782     0.150
    42.622   477.775     0.150
    42.784   478.958     0.150
    42.806   478.907     0.150
    42.807   478.883     0.150
    42.864   479.157     0.150
    42.908   479.242     0.150
    42.912   479.719     0.150
    42.908   479.982     0.150
    42.927   479.629     0.150
    42.997   479.228     0.150
    43.100   482.333     0.150
    43.106   481.196     0.150
    43.182   482.288     0.150
    43.194   482.265     0.150
    43.279   482.808     0.150
    43.284   482.633     0.150
    43.357   485.208     0.150
    43.418   484.407     0.150
    43.465   484.333     0.150
    43.624   485.958     0.150
    43.746   487.083     0.150
    43.818   487.482     0.150
    43.826   487.315     0.150
    43.866   488.508     0.150
    44.017   488.385     0.150
    44.039   489.357     0.150
    44.103   489.907     0.150
    44.137   489.710     0.150
    44.182   490.029     0.150
    44.244   492.907     0.150
    44.238   490.748     0.150
    44.244   490.307     0.150
    44.406   492.383     0.150
    44.472   492.487     0.150
    44.473   492.732     0.150
    44.663   495.107     0.150
    44.718   494.438     0.150
    44.887   496.008     0.150
    44.973   496.582     0.150
    45.045   497.732     0.150
    45.146   499.808     0.150
    45.252   498.775     0.150
    45.252   498.982     0.150
    45.297   498.617     0.150
    45.406   500.308     0.150
    45.498   502.607     0.150
    45.518   500.532     0.150
    45.597   501.468     0.150
    45.597   501.348     0.150
    45.679   502.008     0.150
    45.689   501.892     0.150
    45.791   502.705     0.150
    45.881   504.708     0.150
    45.895   505.907     0.150
    45.953   505.407     0.150
    45.963   504.458     0.150
    46.076   505.107     0.150
    46.168   507.833     0.150
    46.236   510.208     0.150
    46.283   507.907     0.150
    46.296   508.768     0.150
    46.296   508.487     0.150
    46.296   505.348     0.150
    46.272   507.058     0.150
    46.471   510.308     0.150
    46.578   512.107     0.150
    46.610   509.588     0.150
    46.610   509.808     0.150
    46.616   509.155     0.150
    46.708   510.058     0.150
    47.057   514.107     0.150
    47.155   509.607     0.150
    47.155   927.808     0.150
    47.646   517.155     0.150
    48.687   526.208     0.150
    48.935   531.008     0.150
    49.650   531.218     0.150
    49.650   532.508     0.150
    50.815   540.277     0.150
    50.815   541.357     0.150
    51.116   541.617     0.150
    51.198   542.458     0.150
    51.198   544.117     0.150
    53.618   560.888     0.150
    55.946   578.407     0.150
    55.946   577.808     0.150
    55.946   579.048     0.150
    56.943   587.067     0.150
    56.941   586.518     0.150
    56.941   586.907     0.150
    58.538   596.827     0.150
    58.538   595.867     0.150
    58.930   598.638     0.150
    59.380   606.067     0.150
    59.398  1086.808     0.150
    59.398  1325.708     0.150
    60.019   607.298     0.150
    60.769   610.808     0.150
    60.769   611.447     0.150
    61.756   617.907     0.150
    61.756   618.258     0.150
    63.555   629.407     0.150
    63.555  1140.607     0.150
    63.647   632.407     0.150
    64.105  1151.107     0.150
    64.105  1394.708     0.150
    64.075   635.308     0.150
    64.075   634.583     0.150
    64.075   634.367     0.150
    65.248   643.208     0.150
    65.248   641.928     0.150
    65.248   642.697     0.150
    65.338   643.138     0.150
    65.502   643.808     0.150
    65.502   642.228     0.150
    65.512   644.308     0.150
    65.512   643.298     0.150
    65.512   644.607     0.150
    65.512   644.468     0.150
    65.573   643.218     0.150
    65.876   648.308     0.150
    65.876   645.668     0.150
    66.389   648.617     0.150
    66.661   649.107     0.150
    66.666   649.288     0.150
    67.984   657.897     0.150
    67.984   658.907     0.150
    67.984   658.768     0.150
    68.310   661.388     0.150
    68.413   661.518     0.150
    70.108   672.218     0.150
    70.346   674.348     0.150
    70.838   676.277     0.150
    70.838   678.048     0.150
    73.371   690.728     0.150
    73.371   692.208     0.150
    73.371     3.300     0.150
    73.371   708.107     0.150
    73.371   855.508     0.150
    73.371  1261.808     0.150
    73.371  1300.607     0.150
    73.371  1545.407     0.150
    73.457   694.308     0.150
    73.459   693.407     0.150
    73.459  1257.607     0.150
    73.629   694.147     0.150
    74.481   699.708     0.150
    74.806   701.428     0.150
    74.974   701.558     0.150
    74.974   700.998     0.150
    75.319   704.708     0.150
    75.377   705.407     0.150
    75.377   702.838     0.150
    75.377   703.107     0.150
    75.377   712.907     0.150
    75.377   871.708     0.150
    75.377  1278.508     0.150
    75.377  1314.808     0.150
    75.377   704.558     0.150
    75.546   705.628     0.150
    75.853   707.478     0.150
    76.068   708.218     0.150
    76.384   710.808     0.150
    76.607   711.548     0.150
    76.607   711.758     0.150
    76.935   711.527     0.150
    76.937   713.607     0.150
    76.937   711.508     0.150
    76.935   712.808     0.150
    77.209   713.428     0.150
    77.552   717.848     0.150
    77.648   717.508     0.150
    77.648   715.982     0.150
    77.890   720.447     0.150
    77.981   717.907     0.150
    77.981   717.447     0.150
    77.981   718.107     0.150
    78.045   720.067     0.150
    78.081   720.508     0.150
    78.160   718.907     0.150
    78.715   723.768     0.150
    79.144   726.628     0.150
    79.152   724.439     0.150
    79.228   726.487     0.150
    79.228   725.098     0.150
    79.421   726.928     0.150
    79.421   726.782     0.150
    79.421   725.348     0.150
    79.421   727.288     0.150
    79.565   727.508     0.150
    79.565  1328.508     0.150
    79.749   728.208     0.150
    79.954   731.538     0.150
    80.208   731.508     0.150
    80.274   732.288     0.150
    80.493   733.397     0.150
    81.726   740.237     0.150
    81.754   739.498     0.150
    81.748   738.708     0.150
    81.748  1353.308     0.150
    81.862   738.958     0.150
    81.862   739.758     0.150
    81.862   739.038     0.150
    81.907   740.607     0.150
    81.981   739.008     0.150
    82.744   747.258     0.150
    82.744   744.128     0.150
    83.164   747.758     0.150
    83.485   747.827     0.150
    83.701   749.867     0.150
    83.785   750.968     0.150
    83.891   750.596     0.150
    83.891   748.777     0.150
    83.892   750.907     0.150
    83.892   748.668     0.150
    83.892   750.768     0.150
    84.215   751.921     0.150
    84.242   752.308     0.150
    84.242   948.708     0.150
    84.242  1381.407     0.150
    84.242   753.367     0.150
    84.277   752.458     0.150
    84.423   753.218     0.150
    84.558   755.407     0.150
    84.558   753.348     0.150
    84.699   754.407     0.150
    84.699  1378.208     0.150
    85.381   758.808     0.150
    85.381  1390.808     0.150
    85.381  1444.808     0.150
    85.381  1721.808     0.150
    85.395   758.407     0.150
    85.395  1382.708     0.150
    85.480   756.518     0.150
    85.480   757.458     0.150
    86.045   758.758     0.150
    86.045   759.918     0.150
    86.198   764.147     0.150
    87.027   764.508     0.150
    87.027  1400.208     0.150
    88.253   771.748     0.150
    88.253   978.968     0.150
    88.253  1399.998     0.150
    88.253  1767.808     0.150
    88.253   773.208     0.150
    88.404   775.248     0.150
    89.087   776.708     0.150
    89.412   777.708     0.150
    89.709   779.508     0.150
    89.709   779.407     0.150
    89.860   780.558     0.150
    89.860   778.548     0.150
    90.072   782.708     0.150
    90.072   993.008     0.150
    90.072  1413.907     0.150
    90.072  1792.808     0.150
    90.470   782.726     0.150
    90.470   781.487     0.150
    90.470   783.907     0.150
    90.470   783.518     0.150
    91.326   787.407     0.150
    91.697   788.407     0.150
    91.706   789.008     0.150
    91.706  1008.508     0.150
    91.706  1446.708     0.150
    91.956   787.982     0.150
    91.956   789.607     0.150
    91.956   789.808     0.150
    92.079   789.302     0.150
    92.079   789.907     0.150
    92.079  1007.308     0.150
    92.079  1421.808     0.150
    92.079  1523.008     0.150
    92.457   790.077     0.150
    92.457   793.808     0.150
    92.457   792.718     0.150
    92.482   787.907     0.150
    92.482  1425.607     0.150
    92.482  1452.008     0.150
    92.536  1824.607     0.150
    92.731   793.048     0.150
    92.731  1008.907     0.150
    92.937   793.008     0.150
    93.090   794.157     0.150
    93.090  1016.357     0.150
    93.302   796.808     0.150
    94.555   798.008     0.150
    94.555  1026.808     0.150
    94.555  1431.407     0.150
    94.555  1465.808     0.150
    94.555  1851.107     0.150
    95.527   805.327     0.150
    95.527   806.907     0.150
    95.545   805.258     0.150
    96.188   806.407     0.150
    96.188  1440.407     0.150
    96.188  1482.208     0.150
    96.188  1491.008     0.150
    96.655   811.907     0.150
    97.052   811.708     0.150
    97.052  1450.407     0.150
    97.052  1491.308     0.150
    97.052  1500.208     0.150
    97.052  1886.808     0.150
    97.143   811.308     0.150
    97.143   813.708     0.150
    97.245   813.157     0.150
    97.245  1047.107     0.150
    97.297  1053.407     0.150
    97.297  1503.708     0.150
    98.947   820.708     0.150
   100.424   828.407     0.150
   100.424   827.683     0.150
   100.424  1072.732     0.150
   101.911   837.607     0.150
   102.161   836.107     0.150
   103.924  1097.708     0.150
   103.924  1476.708     0.150
   103.924  1649.208     0.150
   103.924  1983.107     0.150
   112.567  1114.708     0.150
   114.008   887.407     0.150
   117.770  1126.316     0.150
   119.705  1130.208     0.150
   119.705  1744.607     0.150
   131.353  1151.508     0.150
   131.353  1290.208     0.150
   131.353  1583.008     0.150
   131.353  2344.708     0.150
   145.252  1177.482     0.150
   145.252  1178.168     0.150
     0.503    10.033     0.150
     0.503    16.904     0.150
     0.503    18.312     0.150
     0.548    19.934     0.150
     0.736    13.533     0.150
     0.736    14.293     0.150
     0.736    24.934     0.150
     0.883    16.283     0.150
     0.883    29.744     0.150
     0.883    29.904     0.150
     0.861    26.664     0.150
     0.949    17.254     0.150
     0.949    29.373     0.150
     1.044    18.543     0.150
     1.044    18.674     0.150
     1.044    31.363     0.150
     1.044    33.174     0.150
     1.019    17.744     0.150
     1.108    19.754     0.150
     1.882    30.693     0.150
     1.882    54.533     0.150
     1.882    58.904     0.150
     1.929    31.354     0.150
     1.929    53.963     0.150
     1.929    59.953     0.150
     0.213     5.617     0.150
     0.213     9.820     0.150
     1.045    18.633     0.150
     1.045    18.508     0.150
     1.045    33.070     0.150
     1.546    48.453     0.150
     1.719    27.375     0.150
     1.651    50.805     0.150
     1.805    29.508     0.150
     1.805    29.094     0.150
     2.077    33.867     0.150
     2.639    41.016     0.150
     2.698    47.250     0.150
     2.739    42.383     0.150
     2.921    58.938     0.150
     2.921    47.188     0.150
     2.921    42.414     0.150
     2.921    76.039     0.150
     2.926    45.414     0.150
     2.945    45.703     0.150
     3.036    47.359     0.150
     3.240    48.508     0.150
     3.260    60.273     0.150
     3.260    90.039     0.150
     3.357    59.844     0.150
     3.357   100.688     0.150
     3.629    54.766     0.150
     3.792   104.000     0.150
     3.912    60.297     0.150
     4.024   102.133     0.150
     4.229    61.703     0.150
     4.229    80.773     0.150
     4.229   135.320     0.150
     4.229    62.359     0.150
     4.697    69.484     0.150
     5.472    79.430     0.150
     6.444    94.695     0.150
     6.742    99.758     0.150
     6.679   213.492     0.150
     7.181   104.117     0.150
     7.232   103.516     0.150
     7.267   104.484     0.150
     7.611   111.297     0.150
     7.707   112.523     0.150
     8.257   118.922     0.150
     8.257   256.094     0.150
     9.030   132.609     0.150
     9.128   133.086     0.150
     9.150   131.852     0.150
     9.150   279.375     0.150
     9.150   133.930     0.150
     9.175   132.469     0.150
     9.217   293.102     0.150
     9.217   132.336     0.150
     9.373   135.656     0.150
     9.472   137.273     0.150
     9.935   145.469     0.150
    10.268   147.227     0.150
    10.725   153.906     0.150
    10.881   158.594     0.150
    10.903   161.500     0.150
    10.903   153.539     0.150
    11.015   155.469     0.150
    11.209   159.547     0.150
    11.306   164.383     0.150
    11.916   169.859     0.150
    12.442   179.906     0.150
    13.119   183.898     0.150
    13.143   188.445     0.150
    13.364   190.484     0.150
    13.408   191.430     0.150
    13.602   191.414     0.150
    13.685   193.867     0.150
    13.861   196.375     0.150
    13.904   197.375     0.150
    13.984   197.383     0.150
    14.024   197.836     0.150
    13.978   196.453     0.150
    14.269   204.289     0.150
    14.349   203.898     0.150
    14.497   205.945     0.150
    14.605   207.359     0.150
    14.636   206.008     0.150
    14.792   208.805     0.150
    14.820   209.547     0.150
    14.825   208.773     0.150
    14.997   214.227     0.150
    14.984   210.617     0.150
    15.004   211.766     0.150
    15.120   213.977     0.150
    15.090   211.164     0.150
    15.178   218.477     0.150
    15.237   215.984     0.150
    15.507   219.609     0.150
    15.479   217.234     0.150
    15.433   217.414     0.150
    15.532   219.227     0.150
    15.724   221.828     0.150
    15.801   223.805     0.150
    15.897   223.555     0.150
    16.642   236.078     0.150
    17.038   238.109     0.150
    17.260   240.984     0.150
    18.527   258.523     0.150
    18.527   256.180     0.150
    18.981   263.586     0.150
    19.959   273.758     0.150
    20.509   278.000     0.150
    21.531   288.320     0.150
    21.729   291.867     0.150
    22.132   295.977     0.150
    22.574   301.508     0.150
    22.917   305.766     0.150
    24.594   320.750     0.150
    24.594   319.570     0.150
    40.475   459.578     0.150
    41.183   465.023     0.150
    41.380   467.195     0.150
    41.880   470.844     0.150
    42.634   476.789     0.150
    43.121   481.336     0.150
    43.458   482.789     0.150
    43.540   483.508     0.150
    86.783  1405.227     0.150
    94.517   800.406     0.150
     0.537    20.250     0.150
     0.811    27.953     0.150
     0.802    15.375     0.150
     0.802    26.172     0.150
     0.979    18.836     0.150
     0.979    32.570     0.150
     1.038    19.625     0.150
     1.038    34.375     0.150
     1.189    21.180     0.150
     1.323    23.836     0.150
     1.323    41.539     0.150
     1.410    24.422     0.150
     1.364    23.648     0.150
     1.364    40.648     0.150
     1.483    25.836     0.150
     1.483    45.570     0.150
     1.538    25.414     0.150
     1.579    26.562     0.150
     1.579    46.383     0.150
     1.721    28.062     0.150
     1.964    32.016     0.150
     2.087    34.359     0.150
     2.256    36.469     0.150
     2.236    35.734     0.150
     2.317    36.953     0.150
     2.448    38.836     0.150
     2.724    42.891     0.150
     2.714    42.586     0.150
     2.691    42.562     0.150
     2.826    44.664     0.150
     3.174    49.516     0.150
     3.605    55.492     0.150
     3.818    58.984     0.150
     4.727    71.812     0.150
     4.798    72.852     0.150
     5.032    74.312     0.150
     5.208    78.625     0.150
     5.570    82.398     0.150
     5.638    81.703     0.150
     5.645    82.719     0.150
     6.086    90.750     0.150
     6.165    92.430     0.150
     0.414     7.980     0.150
     0.414    13.629     0.150
     0.414    13.438     0.150
     0.459     9.961     0.150
     0.459    17.238     0.150
     0.823    15.020     0.150
     0.823    26.438     0.150
     0.860    15.277     0.150
     0.894    16.121     0.150
     0.894    29.051     0.150
     0.948    17.000     0.150
     0.948    30.371     0.150
     1.046    18.699     0.150
     1.046    32.508     0.150
     1.082    19.238     0.150
     1.082    33.699     0.150
     1.082    35.840     0.150
     1.208    22.000     0.150
     1.208    38.949     0.150
     1.466    25.039     0.150
     1.466    43.301     0.150
     1.466    45.758     0.150
     1.466    46.570     0.150
     1.466    24.520     0.150
     1.466    43.570     0.150
     1.946    32.480     0.150
     1.946    58.820     0.150
     2.005    32.809     0.150
     2.005    58.301     0.150
     0.456     9.140     0.150
     0.456    14.990     0.150
     0.815    16.230     0.150
     0.815    27.610     0.150
     1.581    27.640     0.150
     1.581    50.200     0.150
     1.583    29.180     0.150
     1.583    50.770     0.150
     1.640    27.640     0.150
     1.640    50.070     0.150
     1.696    30.360     0.150
     1.696    53.430     0.150
     1.861    31.220     0.150
     1.861    56.790     0.150
     1.886    31.300     0.150
     1.919    31.780     0.150
     1.919    56.670     0.150
     1.919    31.580     0.150
     1.919    56.430     0.150
     2.021    32.390     0.150
     2.021    31.700     0.150
     2.021    62.440     0.150
     2.338    38.270     0.150
     2.593    41.800     0.150
     2.665    41.970     0.150
     2.665    42.670     0.150
     2.665    74.000     0.150
     2.789    46.440     0.150
     2.789    50.702     0.150
     2.711    45.580     0.150
     2.962    46.550     0.150
     3.055    48.050     0.150
     3.210    50.350     0.150
     3.209    50.960     0.150
     3.209    91.290     0.150
     3.406    52.390     0.150
     3.428    52.710     0.150
     3.519    54.170     0.150
     3.726    57.130     0.150
     3.726    57.800     0.150
     3.799    58.760     0.150
     3.890    60.520     0.150
     4.067    62.240     0.150
     4.154    64.130     0.150
     4.152    64.710     0.150
     4.189    64.110     0.150
     4.288    65.170     0.150
     4.318    64.920     0.150
     4.464    67.530     0.150
     4.464    70.625     0.150
     4.464    71.271     0.150
     4.464   141.567     0.150
     4.499    68.780     0.150
     4.542    69.170     0.150
     4.640    70.520     0.150
     5.006    76.270     0.150
     5.140    78.390     0.150
     5.177    80.880     0.150
     5.428    82.850     0.150
     5.530    83.720     0.150
     5.848    86.850     0.150
     5.860    87.560     0.150
     5.951    88.750     0.150
     6.173    94.280     0.150
     6.173    91.680     0.150
     6.436    96.869     0.150
     6.436   202.577     0.150
     6.582    97.730     0.150
     6.688    98.800     0.150
     6.838   101.800     0.150
     7.081   104.460     0.150
     7.252   107.380     0.150
     7.307   107.550     0.150
     7.486   110.050     0.150
     7.573   110.660     0.150
     7.598   112.000     0.150
     7.598   113.255     0.150
     7.764   115.060     0.150
     7.764   116.093     0.150
     7.786   115.250     0.150
     8.181   120.531     0.150
     8.181   211.582     0.150
     8.181   256.529     0.150
     8.181   119.270     0.150
     8.181   120.900     0.150
     8.327   122.970     0.150
     8.361   121.890     0.150
     8.737   127.040     0.150
     8.737   130.380     0.150
     8.832   128.570     0.150
     8.919   130.390     0.150
     8.923   130.580     0.150
     8.923   131.162     0.150
     8.923   229.390     0.150
     8.923   280.537     0.150
     8.923   130.400     0.150
     9.435   140.605     0.150
     9.435   303.197     0.150
     9.461   136.390     0.150
    10.373   150.300     0.150
    10.502   151.700     0.150
    10.502   155.510     0.150
    10.634   154.190     0.150
    11.068   161.100     0.150
    11.068   353.148     0.150
    11.068   164.080     0.150
    12.025   176.385     0.150
    12.150   175.867     0.150
    12.290   178.443     0.150
    13.226   191.309     0.150
    13.263   193.594     0.150
    13.493   191.610     0.150
    13.493   193.702     0.150
    13.493   424.430     0.150
    13.493   192.230     0.150
    13.836   201.470     0.150
    13.961   201.607     0.150
    14.456   205.280     0.150
    14.979   212.700     0.150
    15.117   215.350     0.150
    15.139   216.510     0.150
    15.170   217.050     0.150
    15.247   217.240     0.150
    15.283   218.460     0.150
    15.334   216.400     0.150
    15.358   218.470     0.150
    15.444   218.520     0.150
    15.579   222.030     0.150
    15.685   222.250     0.150
    15.685   223.363     0.150
    15.964   230.980     0.150
    16.001   226.130     0.150
    16.204   230.090     0.150
    16.388   233.980     0.150
    16.388   231.290     0.150
    16.388   232.413     0.150
    16.424   231.880     0.150
    16.518   232.990     0.150
    17.048   239.620     0.150
    17.231   248.780     0.150
    17.666   246.060     0.150
    17.871   250.556     0.150
    18.125   251.650     0.150
    18.335   255.040     0.150
    18.466   256.480     0.150
    18.697   261.338     0.150
    18.697   258.600     0.150
    18.697   262.991     0.150
    19.299   266.070     0.150
    19.419   267.500     0.150
    19.642   272.480     0.150
    19.642   269.690     0.150
    19.642   270.767     0.150
    20.129   274.160     0.150
    20.164   274.410     0.150
    20.201   275.340     0.150
    20.436   277.970     0.150
    20.667   281.340     0.150
    20.958   290.080     0.150
    21.207   284.380     0.150
    21.460   289.063     0.150
    21.667   291.550     0.150
    21.732   292.300     0.150
    22.052   295.410     0.150
    22.290   298.620     0.150
    22.453   299.460     0.150
    22.765   306.231     0.150
    22.778   302.660     0.150
    23.072   306.870     0.150
    23.161   305.460     0.150
    23.161   308.348     0.150
    23.500   311.690     0.150
    23.810   314.450     0.150
    24.023   316.180     0.150
    24.355   322.100     0.150
    24.397   318.580     0.150
    24.613   322.232     0.150
    24.613   782.814     0.150
    24.613   320.830     0.150
    25.129   325.940     0.150
    25.654   329.640     0.150
    25.981   334.380     0.150
    26.148   337.466     0.150
    26.246   337.790     0.150
    26.440   341.550     0.150
    27.301   345.740     0.150
    27.942   350.890     0.150
    29.157   362.350     0.150
    32.798   395.071     0.150
    32.862   395.865     0.150
    33.552   401.090     0.150
    40.693   461.683     0.150
    42.782   478.520     0.150
    43.679   486.260     0.150
    46.059   508.600     0.150
    47.063   513.280     0.150
    51.603   548.935     0.150
    57.383   589.630     0.150
    58.257   595.380     0.150
    58.263  1079.880     0.150
    65.922   647.762     0.150
    67.465   656.500     0.150
    67.465   659.200     0.150
    70.030   672.770     0.150
    70.030   674.896     0.150
    83.689   748.380     0.150
    84.187   754.807     0.150
    85.150   757.905     0.150
    86.796   766.080     0.150
    94.748   803.575     0.150
    95.888   808.500     0.150
    98.144   817.080     0.150
     0.452     9.133     0.150
     0.452    15.504     0.150
     0.452    17.035     0.150
     1.070    19.363     0.150
     1.070    34.102     0.150
     1.102    19.785     0.150
     1.102    34.422     0.150
     1.102    34.082     0.150
     1.351    23.414     0.150
     1.351    41.895     0.150
     1.473    25.895     0.150
     1.473    45.234     0.150
     1.602    27.434     0.150
     1.602    49.191     0.150
     1.757    27.875     0.150
     1.757    49.234     0.150
     1.783    29.684     0.150
     1.783    51.832     0.150
     1.783    51.504     0.150
     1.844    34.754     0.150
     1.844    58.914     0.150
     1.991    33.555     0.150
     2.029    34.184     0.150
     2.771    43.035     0.150
     2.771    74.922     0.150
     3.289    51.812     0.150
     3.289    88.902     0.150
     3.398    52.934     0.150
     3.398    89.422     0.150
     3.539    54.145     0.150
     3.539    95.285     0.150
     3.878    58.023     0.150
     3.878   104.262     0.150
     5.160    78.332     0.150
     5.160   134.562     0.150
     5.823    86.805     0.150
     5.823   148.465     0.150
     0.427     8.766     0.150
     0.427    15.186     0.150
     1.127    19.025     0.150
     1.127    35.905     0.150
     1.164    19.226     0.150
     1.164    35.996     0.150
     1.164    19.436     0.150
     1.164    33.485     0.150
     1.314    22.996     0.150
     1.314    41.905     0.150
     1.507    26.436     0.150
     1.507    47.715     0.150
     1.569    26.945     0.150
     1.569    48.735     0.150
     1.687    27.916     0.150
     1.687    48.786     0.150
     1.718    29.485     0.150
     1.718    51.646     0.150
     1.718    29.385     0.150
     1.718    51.425     0.150
     1.912    34.485     0.150
     1.912    59.646     0.150
     2.100    34.565     0.150
     2.038    34.405     0.150
     2.038    60.215     0.150
     2.838    50.755     0.150
     2.838    85.095     0.150
     3.123    54.875     0.150
     3.123    89.985     0.150
     3.218    49.635     0.150
     3.218    90.155     0.150
     3.469    52.055     0.150
     3.547   102.456     0.150
     0.448     9.166     0.150
     0.448    15.016     0.150
     1.077    19.316     0.150
     1.109    19.676     0.150
     1.109    36.215     0.150
     1.109    19.486     0.150
     1.109    31.545     0.150
     1.347    23.965     0.150
     1.347    42.865     0.150
     1.477    25.926     0.150
     1.477    47.086     0.150
     1.598    27.775     0.150
     1.598    48.615     0.150
     1.749    28.635     0.150
     1.749    50.395     0.150
     1.775    29.775     0.150
     1.775    50.426     0.150
     1.775    29.385     0.150
     1.852    34.826     0.150
     1.852    59.045     0.150
     1.996    35.605     0.150
     1.996    60.496     0.150
     2.037    37.576     0.150
     2.626    40.025     0.150
     2.626    79.826     0.150
     2.779    40.465     0.150
     2.779    74.836     0.150
     3.281    97.166     0.150
     3.371    52.236     0.150
     3.371    89.775     0.150
     3.406    94.445     0.150
     3.540    60.625     0.150
     3.540   101.816     0.150
     5.831    86.416     0.150
     5.831   147.576     0.150
     0.560    11.479     0.150
     0.560    19.938     0.150
     0.560    10.857     0.150
     0.560    18.768     0.150
     0.591    10.547     0.150
     0.591    18.568     0.150
     0.645    12.258     0.150
     0.645    21.527     0.150
     0.645    22.418     0.150
     0.771    14.127     0.150
     0.771    24.889     0.150
     0.771    24.457     0.150
     0.835    15.367     0.150
     0.835    26.777     0.150
     0.835    15.848     0.150
     1.002    18.287     0.150
     1.002    32.508     0.150
     1.020    18.438     0.150
     1.050    18.498     0.150
     1.050    32.658     0.150
     1.050    18.328     0.150
     1.050    32.457     0.150
     1.077    18.898     0.150
     1.077    33.537     0.150
     1.221    21.568     0.150
     1.221    37.889     0.150
     1.221    21.719     0.150
     1.221    38.348     0.150
     1.214    21.758     0.150
     1.216    23.059     0.150
     1.358    23.059     0.150
     1.341    23.188     0.150
     1.341    40.688     0.150
     1.387    23.047     0.150
     1.595    27.047     0.150
     1.593    26.027     0.150
     1.593    45.328     0.150
     1.749    27.287     0.150
     2.118    33.318     0.150
     2.174    33.008     0.150
     2.174    58.648     0.150
     2.245    35.828     0.150
     2.286    35.889     0.150
     2.646    40.787     0.150
     2.683    42.309     0.150
     2.727    42.207     0.150
     2.749    44.098     0.150
     2.847    44.508     0.150
     2.938    45.178     0.150
     3.357    51.729     0.150
     3.548    53.059     0.150
     3.608    55.707     0.150
     3.804    57.027     0.150
     3.803    57.047     0.150
     4.357    65.117     0.150
     4.529    67.508     0.150
     4.716    70.877     0.150
     5.032    75.457     0.150
     5.204    78.578     0.150
     5.572    83.318     0.150
     5.678    82.797     0.150
     5.645    84.889     0.150
     5.741    85.457     0.150
     5.871    87.707     0.150
     5.916    88.617     0.150
     5.958    88.207     0.150
     8.084   117.957     0.150
     0.315     6.607     0.150
     0.315    11.127     0.150
     1.050    19.487     0.150
     1.050    33.417     0.150
     1.470    25.177     0.150
     1.612    27.317     0.150
     1.612    48.387     0.150
     1.668    28.297     0.150
     1.668    50.337     0.150
     1.714    28.927     0.150
     1.714    50.737     0.150
     1.714    28.787     0.150
     1.714    50.907     0.150
     1.726    29.147     0.150
     1.783    28.837     0.150
     1.783    51.937     0.150
     1.783    50.997     0.150
     2.532    40.127     0.150
     2.623    41.447     0.150
     3.282    49.577     0.150
     3.282    97.507     0.150
     3.377    99.047     0.150
     3.431    53.877     0.150
     3.687    57.477     0.150
     4.225    63.436     0.150
     4.225    79.361     0.150
     4.225   117.836     0.150
     4.225   134.836     0.150
     8.151   119.886     0.150
     8.151   264.761     0.150
     9.058   131.908     0.150
     9.058   233.617     0.150
     9.058   288.242     0.150
    13.332   192.617     0.150
    40.459   460.181     0.150
     0.337     7.276     0.150
     0.337    11.596     0.150
     0.337    12.476     0.150
     1.114    20.056     0.150
     1.114    34.716     0.150
     1.114    19.946     0.150
     1.114    35.196     0.150
     1.403    25.086     0.150
     1.619    28.126     0.150
     1.619    27.926     0.150
     1.619    48.246     0.150
     1.589    28.026     0.150
     1.589    49.796     0.150
     1.686    28.656     0.150
     1.686    50.256     0.150
     1.659    28.646     0.150
     1.721    28.396     0.150
     1.721    49.606     0.150
     2.570    41.186     0.150
     3.230    50.396     0.150
     3.230    89.336     0.150
     3.323    53.286     0.150
     3.323    96.986     0.150
     0.739    14.426     0.150
     0.739    24.596     0.150
     0.739    26.176     0.150
     0.739    26.744     0.150
     0.951    17.475     0.150
     0.951    31.465     0.150
     1.006    18.506     0.150
     1.006    32.244     0.150
     1.026    18.176     0.150
     1.026    32.285     0.150
     1.026    32.994     0.150
     1.026    33.355     0.150
     1.026    18.336     0.150
     1.138    21.176     0.150
     1.138    36.936     0.150
     1.138    20.625     0.150
     1.138    36.705     0.150
     1.471    25.666     0.150
     1.471    45.695     0.150
     1.471    47.225     0.150
     1.509    27.666     0.150
     1.509    48.145     0.150
     1.509    50.225     0.150
     1.509    51.734     0.150
     1.627    29.285     0.150
     1.627    51.195     0.150
     1.799    31.984     0.150
     1.799    56.086     0.150
     2.621    46.955     0.150
     2.621    78.975     0.150
     2.700    48.205     0.150
     2.700    81.234     0.150
     0.706    13.609     0.150
     0.706    23.484     0.150
     0.974    17.750     0.150
     0.974    31.016     0.150
     0.964    18.203     0.150
     0.964    31.430     0.150
     1.066    19.062     0.150
     1.066    19.523     0.150
     1.066    31.891     0.150
     1.191    20.492     0.150
     1.191    36.852     0.150
     1.191    38.695     0.150
     1.191    21.922     0.150
     1.191    38.164     0.150
     1.573    28.562     0.150
     1.573    49.141     0.150
     1.559    27.992     0.150
     1.559    48.984     0.150
     2.665    42.227     0.150
     2.665    80.141     0.150
     2.665    47.883     0.150
     0.704    13.688     0.150
     0.704    23.051     0.150
     0.704    24.020     0.150
     0.704    24.211     0.150
     0.981    18.578     0.150
     0.981    32.461     0.150
     0.971    17.750     0.150
     0.971    31.039     0.150
     1.028    18.750     0.150
     1.028    33.188     0.150
     1.028    19.551     0.150
     1.157    20.699     0.150
     1.157    36.527     0.150
     1.157    21.008     0.150
     1.157    35.520     0.150
     1.500    25.770     0.150
     1.500    46.277     0.150
     1.500    25.211     0.150
     1.500    43.090     0.150
     1.523    27.438     0.150
     1.523    48.289     0.150
     1.606    51.141     0.150
     1.843    30.008     0.150
     1.843    55.500     0.150
     1.910    29.809     0.150
     2.627    42.148     0.150
     2.627    74.410     0.150
     2.705    44.551     0.150
     2.705    83.059     0.150
     3.250    49.770     0.150
     3.250    94.988     0.150
     3.294    61.520     0.150
     0.733    14.375     0.150
     0.733    24.434     0.150
     0.929    17.914     0.150
     0.929    30.594     0.150
     1.002    18.703     0.150
     1.002    32.215     0.150
     1.002    18.445     0.150
     1.094    19.094     0.150
     1.094    33.273     0.150
     1.205    21.676     0.150
     1.205    37.074     0.150
     1.205    38.906     0.150
     1.526    26.016     0.150
     1.526    45.555     0.150
     1.526    45.297     0.150
     1.579    26.895     0.150
     1.579    46.773     0.150
     1.579    29.305     0.150
     1.563    26.734     0.150
     1.563    48.004     0.150
     1.656    28.426     0.150
     1.913    30.887     0.150
     1.913    31.484     0.150
     1.969    33.523     0.150
     1.887    33.004     0.150
     2.039    58.426     0.150
     2.056    33.324     0.150
     2.395    38.145     0.150
     2.461    39.387     0.150
     2.691    42.953     0.150
     2.691    43.875     0.150
     2.769    43.496     0.150
     2.769    72.184     0.150
     2.923    45.637     0.150
     3.034    47.934     0.150
     3.132    48.625     0.150
     3.233    53.605     0.150
     3.233    51.637     0.150
     3.233    95.844     0.150
     3.251    50.574     0.150
     3.251    51.035     0.150
     3.304    51.113     0.150
     3.336    52.324     0.150
     3.487    53.836     0.150
     3.496    53.477     0.150
     3.496    66.766     0.150
     3.496    55.367     0.150
     3.529    54.145     0.150
     3.545    54.754     0.150
     3.630    56.887     0.150
     3.632    56.727     0.150
     3.936    59.613     0.150
     3.927    60.305     0.150
     3.949    60.156     0.150
     4.046    61.797     0.150
     4.043    61.945     0.150
     3.995    64.574     0.150
     3.995   118.645     0.150
     4.051    62.516     0.150
     4.198    64.344     0.150
     4.316    66.586     0.150
     4.364    66.727     0.150
     4.475    69.387     0.150
     4.607    70.934     0.150
     4.823    73.895     0.150
     4.861    74.363     0.150
     4.895    74.137     0.150
     4.957    75.797     0.150
     4.993    75.824     0.150
     5.168    77.895     0.150
     5.201    79.746     0.150
     5.300    80.824     0.150
     5.306    78.215     0.150
     5.397    81.266     0.150
     5.506    83.176     0.150
     5.690    85.523     0.150
     5.813    86.824     0.150
     5.827    87.395     0.150
     5.853    87.535     0.150
     6.363    93.297     0.150
     7.542   110.727     0.150
     7.714   113.984     0.150
     7.693   113.969     0.150
     7.693   245.844     0.150
     7.693   113.363     0.150
     7.857   115.836     0.150
     8.423   127.348     0.150
     8.423   273.250     0.150
     8.913   128.684     0.150
     8.938   129.895     0.150
     9.162   134.055     0.150
     9.162   236.398     0.150
     9.162   286.625     0.150
     9.162   133.676     0.150
     9.568   140.125     0.150
     9.979   146.215     0.150
    10.037   149.801     0.150
    10.159   147.676     0.150
    10.972   160.887     0.150
    11.167   162.586     0.150
    11.171   162.895     0.150
    11.251   163.645     0.150
    11.385   164.445     0.150
    12.556   184.234     0.150
    12.556   405.301     0.150
    12.897   187.566     0.150
    12.981   190.395     0.150
    12.980   188.184     0.150
    13.171   190.934     0.150
    14.323   211.523     0.150
    14.638   213.953     0.150
    15.565   221.645     0.150
    15.806   225.574     0.150
    16.079   226.746     0.150
    16.997   238.254     0.150
    17.664   250.195     0.150
    19.284   268.535     0.150
    19.654   269.336     0.150
    20.033   274.836     0.150
    20.209   277.145     0.150
    21.294   288.363     0.150
    22.112   296.695     0.150
    22.164   297.020     0.150
    22.402   300.453     0.150
    22.556   299.105     0.150
    23.120   308.074     0.150
    23.760   316.434     0.150
    23.814   316.398     0.150
    24.370   320.727     0.150
    24.945   326.934     0.150
    24.973   326.805     0.150
    31.778   389.355     0.150
    36.876   429.664     0.150
    39.097   450.547     0.150
    39.658   454.363     0.150
    39.676   455.875     0.150
    39.715   454.496     0.150
    39.954   457.715     0.150
    40.120   458.227     0.150
    40.583   461.816     0.150
    40.597   462.266     0.150
    40.637   463.625     0.150
    40.655   463.074     0.150
    40.738   463.523     0.150
    40.929   466.137     0.150
    42.667   479.105     0.150
    65.036   642.699     0.150
    75.805   707.602     0.150
    78.519   724.254     0.150
    78.519   723.773     0.150
    82.645   746.449     0.150
    84.587   756.305     0.150
    84.790   756.160     0.150
    92.688   794.512     0.150
    94.094   801.398     0.150
    97.190   814.375     0.150
   118.028  1128.270     0.150
   119.899  1131.551     0.150
   119.899  1131.805     0.150
   121.673  1136.715     0.150
     0.618    12.217     0.150
     0.618    20.516     0.150
     0.616    11.916     0.150
     0.616    20.137     0.150
     0.801    14.996     0.150
     0.801    25.986     0.150
     0.992    18.166     0.150
     0.992    31.906     0.150
     0.992    18.336     0.150
     0.992    32.365     0.150
     1.140    19.795     0.150
     1.228    21.977     0.150
     1.228    37.996     0.150
     1.228    41.355     0.150
     1.231    21.695     0.150
     1.306    25.166     0.150
     1.306    43.326     0.150
     1.347    23.295     0.150
     1.443    26.137     0.150
     1.480    24.705     0.150
     1.480    44.166     0.150
     1.502    25.967     0.150
     1.502    45.615     0.150
     1.502    49.686     0.150
     1.502    46.576     0.150
     1.586    27.137     0.150
     2.205    36.387     0.150
     2.205    64.035     0.150
     2.269    37.336     0.150
     2.269    64.996     0.150
     3.195    54.375     0.150
     3.195    95.496     0.150
     3.730    60.756     0.150
     3.730   103.855     0.150
     4.231    66.605     0.150
     4.231   116.496     0.150
     0.573    11.168     0.150
     0.573    19.168     0.150
     0.863    15.838     0.150
     0.863    16.578     0.150
     0.863    26.988     0.150
     0.922    16.898     0.150
     0.922    29.178     0.150
     1.422    24.638     0.150
     1.422    43.478     0.150
     1.539    27.278     0.150
     1.539    47.848     0.150
     1.586    29.278     0.150
     1.586    50.638     0.150
     1.787    31.498     0.150
     1.940    57.768     0.150
     1.940    31.628     0.150
     1.940    54.698     0.150
     2.002    32.918     0.150
     2.002    59.308     0.150
     2.002    32.578     0.150
     2.015    32.908     0.150
     2.015    55.318     0.150
     2.560    40.128     0.150
     2.560    69.858     0.150
     3.570    54.878     0.150
     3.570    94.288     0.150
     3.680    56.738     0.150
     3.680   101.508     0.150
     0.563    11.076     0.150
     0.563    18.756     0.150
     0.859    16.316     0.150
     0.859    27.656     0.150
     0.933    17.856     0.150
     0.933    31.136     0.150
     1.434    25.286     0.150
     1.434    44.956     0.150
     1.587    29.526     0.150
     1.587    50.307     0.150
     1.545    28.136     0.150
     1.793    33.406     0.150
     1.793    56.937     0.150
     1.784    32.396     0.150
     1.994    35.706     0.150
     1.994    61.596     0.150
     1.994    35.156     0.150
     1.994    60.776     0.150
     2.014    35.816     0.150
     2.014    55.966     0.150
     2.568    41.886     0.150
     2.568    78.517     0.150
     3.155    51.316     0.150
     3.155    89.896     0.150
     3.581    53.156     0.150
     3.581    91.796     0.150
     3.689    57.586     0.150
     3.689   102.096     0.150
     3.690    55.267     0.150
     3.690    98.236     0.150
     5.043   128.606     0.150
     0.550    11.047     0.150
     0.550    19.406     0.150
     0.905    16.500     0.150
     0.905    27.188     0.150
     0.905    16.320     0.150
     0.905    29.211     0.150
     0.939    17.578     0.150
     0.939    29.961     0.150
     1.422    25.266     0.150
     1.422    44.352     0.150
     1.502    26.234     0.150
     1.502    47.602     0.150
     1.826    32.570     0.150
     1.826    56.281     0.150
     1.898    29.781     0.150
     1.898    55.578     0.150
     1.898    31.156     0.150
     1.898    55.070     0.150
     1.967    35.148     0.150
     1.967    60.695     0.150
     1.967    32.266     0.150
     1.967    59.016     0.150
     1.971    31.406     0.150
     1.971    55.641     0.150
     2.592    43.188     0.150
     2.592    38.055     0.150
     3.503    52.258     0.150
     3.503    94.164     0.150
     3.558    52.805     0.150
     3.710   113.281     0.150
     0.583    11.543     0.150
     0.583    19.164     0.150
     0.913    17.602     0.150
     0.913    29.832     0.150
     0.854    16.914     0.150
     0.854    28.824     0.150
     1.417    25.523     0.150
     1.417    44.145     0.150
     1.545    26.812     0.150
     1.545    47.645     0.150
     1.576    28.332     0.150
     1.576    48.492     0.150
     1.782    30.613     0.150
     1.782    54.094     0.150
     1.776    31.145     0.150
     1.776    54.512     0.150
     1.951    32.973     0.150
     1.951    59.781     0.150
     2.026    32.973     0.150
     2.026    56.582     0.150
     2.013    34.094     0.150
     2.013    60.293     0.150
     2.013    32.504     0.150
     2.013    56.613     0.150
     2.549    41.441     0.150
     2.549    74.062     0.150
     2.549    38.152     0.150
     2.549    71.531     0.150
     2.788    45.344     0.150
     2.788    79.621     0.150
     3.138    49.562     0.150
     3.138    88.633     0.150
     3.138    49.152     0.150
     3.557    56.121     0.150
     3.557   105.012     0.150
     3.648    71.461     0.150
     3.648   116.191     0.150
     3.670    58.133     0.150
     3.670   102.152     0.150
     3.669    57.324     0.150
     3.669   101.484     0.150
     3.952    62.461     0.150
     3.952   110.281     0.150
     4.463    75.215     0.150
     4.463    90.191     0.150
     4.463   152.168     0.150
     8.020   118.242     0.150
     8.020   206.816     0.150
     8.020   250.141     0.150
     8.781   127.598     0.150
     8.781   265.875     0.150
     9.413   308.613     0.150
    11.001   356.621     0.150
    13.381   426.723     0.150
    18.634   262.617     0.150
    21.381   288.418     0.150
    40.668   465.023     0.150
    68.397   666.258     0.150
    79.082   727.379     0.150
    84.990   757.887     0.150
     0.569    11.285     0.150
     0.569    18.914     0.150
     0.847    16.484     0.150
     0.847    28.402     0.150
     0.929    17.914     0.150
     0.929    31.883     0.150
     1.434    25.473     0.150
     1.434    44.543     0.150
     1.556    27.914     0.150
     1.556    48.605     0.150
     1.574    28.605     0.150
     1.574    49.242     0.150
     1.794    31.184     0.150
     1.783    31.332     0.150
     1.783    55.074     0.150
     1.779    56.535     0.150
     1.947    31.543     0.150
     1.947    56.215     0.150
     1.947    32.184     0.150
     1.947    55.793     0.150
     2.026    32.195     0.150
     2.026    56.375     0.150
     2.004    33.402     0.150
     2.004    59.535     0.150
     2.004    32.953     0.150
     2.004    62.023     0.150
     2.317    37.754     0.150
     2.379    39.105     0.150
     2.560    41.285     0.150
     2.560    73.824     0.150
     2.560    44.125     0.150
     2.560    40.125     0.150
     2.560    71.266     0.150
     2.786    50.973     0.150
     2.743    47.742     0.150
     2.981    48.152     0.150
     3.144    49.832     0.150
     3.412    55.082     0.150
     3.585    56.172     0.150
     3.585    94.516     0.150
     3.554    56.125     0.150
     3.554    97.895     0.150
     3.686    58.516     0.150
     3.686   102.883     0.150
     3.686   100.742     0.150
     3.681    56.945     0.150
     3.681   100.793     0.150
     4.015    61.785     0.150
     4.171    64.805     0.150
     4.196    65.035     0.150
     4.213    65.633     0.150
     4.465    70.766     0.150
     4.465    67.664     0.150
     4.465    80.617     0.150
     4.512    70.082     0.150
     4.860    74.715     0.150
     4.969    78.172     0.150
     5.024    76.082     0.150
     5.038    77.945     0.150
     5.039    77.375     0.150
     5.039   130.055     0.150
     5.307    81.324     0.150
     5.336    81.004     0.150
     5.390    81.984     0.150
     5.730    87.215     0.150
     5.804    87.203     0.150
     6.064    91.074     0.150
     6.744   101.355     0.150
     7.227   106.172     0.150
     7.230   104.805     0.150
     7.261   108.645     0.150
     7.540   107.883     0.150
     7.454   110.324     0.150
     7.648   113.582     0.150
     7.685   114.434     0.150
     8.037   117.836     0.150
     8.037   253.738     0.150
     8.037   118.023     0.150
     8.693   127.445     0.150
     8.797   129.844     0.150
     8.784   130.074     0.150
     8.794   129.465     0.150
     8.795   128.840     0.150
     8.795   274.523     0.150
     8.795   130.652     0.150
     9.211   136.742     0.150
     9.135   137.094     0.150
     9.381   136.973     0.150
     9.417   136.270     0.150
     9.417   300.301     0.150
     9.653   143.094     0.150
    11.009   158.141     0.150
    11.406   165.883     0.150
    11.437   166.062     0.150
    11.589   169.254     0.150
    11.936   174.363     0.150
    12.098   174.484     0.150
    12.219   177.355     0.150
    12.808   184.805     0.150
    12.998   189.492     0.150
    13.229   193.215     0.150
    13.393   191.016     0.150
    13.393   190.484     0.150
    13.712   200.125     0.150
    13.768   201.023     0.150
    13.766   197.914     0.150
    14.009   201.742     0.150
    14.070   204.355     0.150
    14.100   203.312     0.150
    14.270   205.016     0.150
    14.309   203.855     0.150
    14.655   209.094     0.150
    14.691   208.594     0.150
    14.807   210.422     0.150
    14.832   209.773     0.150
    14.847   211.004     0.150
    15.040   215.016     0.150
    15.108   214.723     0.150
    15.187   215.254     0.150
    15.522   220.035     0.150
    15.709   221.285     0.150
    15.979   226.645     0.150
    17.981   253.574     0.150
    18.192   255.582     0.150
    18.642   259.488     0.150
    18.642   260.922     0.150
    18.687   259.414     0.150
    20.289   278.125     0.150
    21.388   288.230     0.150
    21.807   294.766     0.150
    21.908   295.504     0.150
    22.306   299.973     0.150
    22.632   303.793     0.150
    23.336   311.145     0.150
    23.427   312.562     0.150
    24.250   319.355     0.150
    24.489   321.469     0.150
    24.547   321.984     0.150
    24.877   324.184     0.150
    40.672   462.312     0.150
    43.661   487.562     0.150
    56.336   584.234     0.150
    56.336   584.484     0.150
    65.953   649.098     0.150
    85.007   756.965     0.150
    98.154   819.242     0.150
   134.721  1161.504     0.150
     0.536    10.637     0.150
     0.536    17.684     0.150
     0.861    16.145     0.150
     0.861    27.305     0.150
     0.861    15.766     0.150
     0.960    17.387     0.150
     0.960    30.504     0.150
     1.459    24.875     0.150
     1.459    44.523     0.150
     1.552    25.887     0.150
     1.552    47.656     0.150
     1.597    28.875     0.150
     1.597    50.195     0.150
     1.815    32.004     0.150
     1.815    55.773     0.150
     1.782    30.684     0.150
     1.918    31.863     0.150
     1.918    57.625     0.150
     1.918    31.254     0.150
     1.971    32.555     0.150
     1.971    58.125     0.150
     1.971    31.363     0.150
     1.971    52.645     0.150
     2.003    35.246     0.150
     2.593    66.863     0.150
     2.808    83.586     0.150
     3.175    46.547     0.150
     3.526    54.516     0.150
     3.717    55.336     0.150
     3.717    96.055     0.150
     4.442    81.867     0.150
     4.442   141.492     0.150
     8.057   117.168     0.150
     8.057   253.242     0.150
     8.828   129.324     0.150
     8.828   275.773     0.150
     9.398   134.758     0.150
    10.999   158.227     0.150
    13.394   192.984     0.150
    18.631   256.770     0.150
    24.498   319.148     0.150
    40.654   462.273     0.150
     0.533    10.516     0.150
     0.533    18.586     0.150
     0.893    16.116     0.150
     0.893    29.436     0.150
     0.893    16.666     0.150
     0.893    28.766     0.150
     0.958    17.616     0.150
     0.958    30.906     0.150
     1.445    25.426     0.150
     1.445    44.356     0.150
     1.519    25.756     0.150
     1.626    30.406     0.150
     1.626    52.956     0.150
     1.760    29.366     0.150
     1.833    33.216     0.150
     1.833    57.986     0.150
     1.895    31.556     0.150
     1.895    31.686     0.150
     1.895    58.576     0.150
     1.975    31.646     0.150
     1.975    55.956     0.150
     1.957    32.626     0.150
     1.957    57.986     0.150
     1.957    60.916     0.150
     2.604    44.696     0.150
     3.195    50.826     0.150
     3.195    86.726     0.150
     3.502    55.236     0.150
     3.502   104.096     0.150
     3.582    55.866     0.150
     3.582    94.806     0.150
     3.713    71.916     0.150
     3.713   116.376     0.150
     3.723    58.786     0.150
     3.723   103.976     0.150
     0.540    10.801     0.150
     0.540    18.832     0.150
     0.909    16.391     0.150
     0.909    30.102     0.150
     0.909    15.902     0.150
     0.909    29.270     0.150
     0.949    17.090     0.150
     0.949    30.383     0.150
     1.430    25.152     0.150
     1.430    43.891     0.150
     1.501    45.691     0.150
     1.638    29.703     0.150
     1.638    51.293     0.150
     1.833    32.191     0.150
     1.833    56.871     0.150
     1.742    29.820     0.150
     1.742    52.281     0.150
     1.742    29.141     0.150
     1.836    32.492     0.150
     1.836    56.441     0.150
     1.889    32.141     0.150
     1.889    57.672     0.150
     1.889    55.543     0.150
     1.956    32.902     0.150
     1.956    59.422     0.150
     1.956    32.582     0.150
     1.956    56.902     0.150
     2.273    36.910     0.150
     2.602    40.070     0.150
     2.602    74.660     0.150
     2.602    41.492     0.150
     2.602    75.691     0.150
     2.602    40.691     0.150
     2.850    47.031     0.150
     2.850    82.031     0.150
     2.850    79.691     0.150
     2.850    46.242     0.150
     2.683    42.922     0.150
     2.836    77.500     0.150
     2.924    46.090     0.150
     3.200    49.641     0.150
     3.349    51.391     0.150
     3.494    52.012     0.150
     3.494   100.492     0.150
     3.564    55.520     0.150
     3.564    99.020     0.150
     3.720    57.293     0.150
     3.720   103.480     0.150
     3.763    56.363     0.150
     3.954    58.762     0.150
     4.151    62.410     0.150
     4.144    63.332     0.150
     4.401    87.910     0.150
     4.441    66.293     0.150
     4.462    66.590     0.150
     4.477    67.953     0.150
     4.849    72.812     0.150
     4.982    74.711     0.150
     5.058    76.941     0.150
     5.058   137.922     0.150
     5.249    77.652     0.150
     5.284    78.660     0.150
     5.367    80.102     0.150
     5.694    83.570     0.150
     5.697    84.340     0.150
     5.800    84.992     0.150
     6.004    87.883     0.150
     6.018    89.051     0.150
     7.094   102.203     0.150
     7.172   104.953     0.150
     7.207   105.020     0.150
     7.479   105.531     0.150
     7.464   107.312     0.150
     7.665   109.730     0.150
     7.711   116.422     0.150
     8.020   118.059     0.150
     8.020   255.059     0.150
     8.020   116.062     0.150
     8.020   116.113     0.150
     8.020   115.883     0.150
     8.823   266.613     0.150
     9.354   313.402     0.150
    13.344   430.930     0.150
    14.311   199.723     0.150
    15.186   211.230     0.150
    15.217   213.133     0.150
    15.246   212.730     0.150
    15.326   214.422     0.150
    15.428   215.801     0.150
    15.499   215.801     0.150
    15.519   217.281     0.150
    15.572   216.992     0.150
    15.572   222.750     0.150
    15.978   221.262     0.150
    16.245   225.500     0.150
    16.228   231.703     0.150
    16.384   229.312     0.150
    22.622   305.223     0.150
    24.452   321.191     0.150
     0.511    10.152     0.150
     0.511    17.543     0.150
     0.890    16.012     0.150
     0.890    28.004     0.150
     0.890    16.184     0.150
     0.890    29.141     0.150
     0.981    16.992     0.150
     0.981    30.172     0.150
     1.468    24.762     0.150
     1.468    43.914     0.150
     1.530    25.734     0.150
     1.530    46.113     0.150
     1.630    26.781     0.150
     1.630    48.352     0.150
     1.804    30.844     0.150
     1.772    29.152     0.150
     1.772    52.523     0.150
     1.772    29.602     0.150
     1.847    30.883     0.150
     1.847    54.602     0.150
     1.884    31.293     0.150
     1.884    56.613     0.150
     1.884    31.754     0.150
     1.940    32.004     0.150
     1.940    57.934     0.150
     1.940    57.031     0.150
     1.970    31.883     0.150
     2.316    36.781     0.150
     2.308    37.074     0.150
     2.622    40.613     0.150
     2.622    74.641     0.150
     2.841    47.504     0.150
     2.841    47.043     0.150
     2.682    44.383     0.150
     2.848    50.043     0.150
     2.950    45.691     0.150
     3.208    49.402     0.150
     3.208    84.953     0.150
     3.346    51.582     0.150
     3.493    53.082     0.150
     3.493    54.043     0.150
     3.603    55.473     0.150
     3.603    54.352     0.150
     3.603    98.832     0.150
     3.743    57.023     0.150
     3.743   101.941     0.150
     3.736    60.512     0.150
     3.736   101.301     0.150
     3.765    56.602     0.150
     3.975    59.984     0.150
     4.153    61.793     0.150
     4.174    62.672     0.150
     4.211    64.562     0.150
     4.409    65.832     0.150
     4.409    88.258     0.150
     4.409   146.031     0.150
     4.480    66.891     0.150
     4.514    68.582     0.150
     4.887    75.113     0.150
     4.910    71.844     0.150
     5.017    75.074     0.150
     5.090    76.914     0.150
     5.090   139.172     0.150
     5.275    77.562     0.150
     5.314    78.352     0.150
     5.406    81.754     0.150
     5.728    85.062     0.150
     5.735    85.504     0.150
     5.838    86.844     0.150
     6.035    87.914     0.150
     6.052    89.621     0.150
     6.586    98.301     0.150
     6.771    97.453     0.150
     7.132   104.934     0.150
     7.199   103.812     0.150
     7.236   104.613     0.150
     7.254   106.742     0.150
     7.480   107.113     0.150
     7.499   110.332     0.150
     7.633   110.191     0.150
     7.698   113.094     0.150
     7.731   111.754     0.150
     8.056   116.941     0.150
     8.058   117.633     0.150
     8.058   207.883     0.150
     8.058   248.883     0.150
     8.058   117.434     0.150
     8.058   117.664     0.150
     8.058   117.891     0.150
     8.229   120.543     0.150
     8.412   120.473     0.150
     8.456   124.543     0.150
     8.612   124.613     0.150
     8.716   127.094     0.150
     8.743   127.512     0.150
     8.716   124.504     0.150
     8.836   129.113     0.150
     8.851   129.043     0.150
     8.852   128.133     0.150
     8.852   270.238     0.150
     9.087   131.852     0.150
     9.367   140.164     0.150
     9.367   302.551     0.150
    10.152   148.121     0.150
    10.149   145.832     0.150
    10.225   145.961     0.150
    10.508   150.953     0.150
    10.724   153.402     0.150
    10.973   160.086     0.150
    10.973   348.613     0.150
    11.017   159.562     0.150
    11.008   159.473     0.150
    11.395   162.773     0.150
    11.439   163.852     0.150
    11.511   165.004     0.150
    11.629   167.742     0.150
    12.150   174.664     0.150
    12.193   175.012     0.150
    12.283   174.352     0.150
    12.617   180.844     0.150
    12.857   184.953     0.150
    13.376   192.812     0.150
    13.376   420.688     0.150
    13.376   188.992     0.150
    13.640   194.602     0.150
    13.735   193.234     0.150
    13.802   196.793     0.150
    14.137   201.172     0.150
    14.216   202.941     0.150
    14.247   200.312     0.150
    14.348   204.441     0.150
    14.388   203.512     0.150
    14.637   208.543     0.150
    14.732   209.223     0.150
    14.805   208.043     0.150
    14.869   211.633     0.150
    15.085   211.801     0.150
    15.113   211.863     0.150
    15.135   212.613     0.150
    15.159   212.844     0.150
    15.223   215.211     0.150
    15.254   216.914     0.150
    15.284   217.391     0.150
    15.268   213.742     0.150
    15.314   216.051     0.150
    15.349   214.711     0.150
    15.466   218.941     0.150
    15.508   220.074     0.150
    15.520   220.344     0.150
    15.536   219.691     0.150
    15.557   220.441     0.150
    15.556   218.613     0.150
    15.603   222.094     0.150
    15.597   221.332     0.150
    15.686   221.152     0.150
    15.701   221.801     0.150
    15.745   222.461     0.150
    15.892   225.043     0.150
    16.016   226.453     0.150
    16.090   227.762     0.150
    16.097   224.734     0.150
    16.264   228.082     0.150
    16.313   229.242     0.150
    16.384   230.832     0.150
    16.419   233.672     0.150
    16.701   235.074     0.150
    17.554   245.574     0.150
    17.767   248.492     0.150
    17.843   250.652     0.150
    18.025   251.812     0.150
    18.237   254.492     0.150
    18.215   251.121     0.150
    18.292   252.641     0.150
    18.604   260.883     0.150
    18.604   255.422     0.150
    18.724   258.891     0.150
    18.941   262.051     0.150
    19.191   264.594     0.150
    19.300   265.613     0.150
    19.998   273.754     0.150
    20.008   273.754     0.150
    20.261   276.914     0.150
    20.318   276.824     0.150
    20.602   278.012     0.150
    20.719   281.953     0.150
    21.082   283.961     0.150
    21.452   288.605     0.150
    21.438   289.184     0.150
    21.613   290.352     0.150
    21.842   292.793     0.150
    21.930   293.891     0.150
    22.321   298.023     0.150
    22.658   302.121     0.150
    22.747   303.484     0.150
    23.035   305.664     0.150
    23.396   307.242     0.150
    24.187   317.332     0.150
    24.488   320.914     0.150
    24.488   318.934     0.150
    25.003   323.652     0.150
    25.121   326.031     0.150
    32.696   394.727     0.150
    40.623   459.531     0.150
    40.623   463.664     0.150
    40.623   459.453     0.150
    85.027   757.637     0.150
     0.568    11.289     0.150
     0.568    19.438     0.150
     0.920    17.016     0.150
     0.920    29.672     0.150
     0.942    17.477     0.150
     0.942    30.445     0.150
     0.942    17.586     0.150
     0.942    30.195     0.150
     1.388    24.320     0.150
     1.388    42.641     0.150
     1.460    25.055     0.150
     1.460    44.227     0.150
     1.699    29.031     0.150
     1.699    51.234     0.150
     1.659    29.891     0.150
     1.659    51.234     0.150
     1.835    32.336     0.150
     1.835    55.711     0.150
     1.884    31.727     0.150
     1.884    57.156     0.150
     1.884    55.258     0.150
     1.946    30.320     0.150
     1.946    53.805     0.150
     1.966    33.289     0.150
     1.966    59.680     0.150
     1.966    32.484     0.150
     1.966    55.508     0.150
     2.590    42.359     0.150
     2.590    74.297     0.150
     2.590    39.320     0.150
     2.590    68.719     0.150
     3.202    49.875     0.150
     3.202    88.195     0.150
     3.485    53.781     0.150
     3.518    54.727     0.150
     3.518    96.969     0.150
     3.671    58.984     0.150
     3.671   102.469     0.150
     3.704    56.695     0.150
     3.704   100.039     0.150
     4.381    73.594     0.150
     4.381   150.945     0.150
     5.027    76.445     0.150
     5.027   131.805     0.150
     7.974   117.820     0.150
     7.974   252.797     0.150
     8.797   129.055     0.150
     8.797   270.648     0.150
    10.913   353.156     0.150
    13.300   425.727     0.150
    40.582   462.977     0.150
     0.542    10.758     0.150
     0.542    18.484     0.150
     0.924    17.641     0.150
     0.924    30.469     0.150
     0.924    28.547     0.150
     0.946    17.617     0.150
     0.946    29.906     0.150
     1.420    24.539     0.150
     1.420    42.391     0.150
     1.485    25.039     0.150
     1.485    43.859     0.150
     1.650    29.805     0.150
     1.650    51.234     0.150
     1.726    28.141     0.150
     1.726    49.938     0.150
     1.842    32.195     0.150
     1.842    55.891     0.150
     1.849    32.367     0.150
     1.849    56.625     0.150
     1.880    31.320     0.150
     1.880    58.000     0.150
     1.880    53.766     0.150
     1.952    30.867     0.150
     1.952    53.719     0.150
     1.953    32.227     0.150
     1.953    57.680     0.150
     1.953    55.844     0.150
     3.207    50.586     0.150
     3.207    89.594     0.150
     3.484    52.516     0.150
     3.484    94.250     0.150
     3.551    55.656     0.150
     3.551    96.648     0.150
     3.722    58.055     0.150
     3.722   102.516     0.150
     4.389    70.414     0.150
     4.389    85.016     0.150
     4.389   144.867     0.150
     8.007   117.016     0.150
     8.007   210.414     0.150
     8.007   253.367     0.150
     8.821   128.625     0.150
     8.821   224.273     0.150
     9.340   141.000     0.150
    10.934   161.148     0.150
    40.595   462.898     0.150
     0.549    10.773     0.150
     0.549    19.125     0.150
     0.900    17.414     0.150
     0.900    30.078     0.150
     0.941    18.008     0.150
     0.941    31.023     0.150
     1.425    26.227     0.150
     1.425    45.047     0.150
     1.508    27.648     0.150
     1.508    47.812     0.150
     1.626    29.797     0.150
     1.626    52.203     0.150
     1.748    31.297     0.150
     1.748    54.898     0.150
     1.824    32.633     0.150
     1.824    57.008     0.150
     1.901    32.969     0.150
     1.901    59.219     0.150
     1.901    56.094     0.150
     1.968    34.367     0.150
     1.968    60.594     0.150
     1.968    33.406     0.150
     1.968    56.719     0.150
     1.975    33.109     0.150
     1.975    56.914     0.150
     2.591    44.492     0.150
     2.591    76.367     0.150
     2.591    43.727     0.150
     2.591    77.812     0.150
     3.506    97.977     0.150
     3.563    62.719     0.150
     3.563   104.734     0.150
     3.695    62.930     0.150
     3.695   110.016     0.150
     0.580    11.383     0.150
     0.580    19.477     0.150
     0.854    16.969     0.150
     0.854    29.320     0.150
     0.854    16.828     0.150
     0.854    28.336     0.150
     0.916    17.641     0.150
     0.916    29.828     0.150
     1.420    25.312     0.150
     1.420    43.430     0.150
     1.547    26.039     0.150
     1.547    46.508     0.150
     1.576    28.102     0.150
     1.576    49.547     0.150
     1.784    30.289     0.150
     1.784    52.781     0.150
     1.777    31.828     0.150
     1.777    54.578     0.150
     1.950    32.242     0.150
     1.950    32.500     0.150
     2.011    33.602     0.150
     2.011    58.352     0.150
     2.011    35.609     0.150
     2.011    61.953     0.150
     2.551    42.492     0.150
     2.551    74.281     0.150
     2.551    44.141     0.150
     2.551    72.328     0.150
     3.140    50.492     0.150
     3.140    88.789     0.150
     3.556    62.938     0.150
     3.556   104.133     0.150
     3.571    55.211     0.150
     3.571   100.047     0.150
     3.673    57.438     0.150
     3.673   100.758     0.150
     0.549    10.823     0.150
     0.549    18.643     0.150
     0.946    17.453     0.150
     0.946    30.223     0.150
     1.006    17.663     0.150
     1.006    30.913     0.150
     1.387    24.773     0.150
     1.387    42.443     0.150
     1.403    24.473     0.150
     1.403    43.653     0.150
     1.724    29.843     0.150
     1.724    51.683     0.150
     1.827    32.273     0.150
     1.827    55.963     0.150
     1.827    55.413     0.150
     1.890    32.193     0.150
     1.890    56.833     0.150
     1.882    32.093     0.150
     1.882    55.913     0.150
     1.920    32.763     0.150
     1.920    57.223     0.150
     1.920    33.323     0.150
     1.920    57.753     0.150
     2.634    43.133     0.150
     2.634    75.283     0.150
     2.634    76.603     0.150
     3.260    51.123     0.150
     3.260    89.143     0.150
     3.260    60.423     0.150
     3.260    98.523     0.150
     3.424    53.843     0.150
     3.424    96.573     0.150
     3.514    52.753     0.150
     3.514    94.883     0.150
     3.744    57.973     0.150
     3.744   101.863     0.150
     0.613    12.016     0.150
     0.613    20.500     0.150
     0.876    17.000     0.150
     0.876    29.086     0.150
     0.901    17.406     0.150
     0.901    30.469     0.150
     0.901    17.664     0.150
     0.901    30.961     0.150
     1.364    24.727     0.150
     1.364    42.609     0.150
     1.492    25.867     0.150
     1.492    45.711     0.150
     1.607    27.609     0.150
     1.607    50.047     0.150
     1.727    29.195     0.150
     1.776    31.867     0.150
     1.776    54.945     0.150
     1.942    32.461     0.150
     1.942    32.305     0.150
     1.942    59.008     0.150
     2.001    33.320     0.150
     2.001    62.008     0.150
     2.022    34.570     0.150
     2.022    59.969     0.150
     2.022    34.719     0.150
     2.022    60.789     0.150
     2.534    42.094     0.150
     2.534    74.156     0.150
     2.534    42.617     0.150
     2.534    71.141     0.150
     3.144    49.586     0.150
     3.144    87.977     0.150
     3.144    49.359     0.150
     3.144    85.391     0.150
     3.509    54.797     0.150
     3.509    97.320     0.150
     3.650    56.820     0.150
     3.650   101.000     0.150
     0.588    11.566     0.150
     0.588    19.516     0.150
     0.900    17.887     0.150
     0.900    30.307     0.150
     0.944    17.986     0.150
     0.944    30.637     0.150
     0.944    31.266     0.150
     1.368    25.086     0.150
     1.368    43.945     0.150
     1.453    25.807     0.150
     1.453    45.686     0.150
     1.654    29.406     0.150
     1.654    50.865     0.150
     1.691    30.195     0.150
     1.691    53.176     0.150
     1.820    32.875     0.150
     1.820    56.576     0.150
     1.897    32.246     0.150
     1.897    34.516     0.150
     1.897    58.227     0.150
     1.953    55.406     0.150
     1.983    34.865     0.150
     1.983    59.746     0.150
     1.983    35.836     0.150
     1.983    58.045     0.150
     3.189    51.486     0.150
     3.189    90.295     0.150
     3.495    61.736     0.150
     3.495   105.955     0.150
     3.585    65.096     0.150
     3.585   112.105     0.150
     3.685    58.516     0.150
     3.685   102.977     0.150
     0.555    10.891     0.150
     0.555    19.312     0.150
     0.933    16.570     0.150
     0.933    30.859     0.150
     0.933    16.430     0.150
     0.933    31.414     0.150
     0.933    16.758     0.150
     0.933    29.734     0.150
     1.405    24.453     0.150
     1.405    43.023     0.150
     1.473    24.953     0.150
     1.473    44.500     0.150
     1.654    29.305     0.150
     1.654    51.133     0.150
     1.712    28.703     0.150
     1.712    51.148     0.150
     1.838    32.383     0.150
     1.838    55.812     0.150
     1.959    32.648     0.150
     1.959    59.328     0.150
     1.959    32.523     0.150
     1.959    58.500     0.150
     1.949    30.312     0.150
     1.949    54.922     0.150
     2.597    42.961     0.150
     2.597    75.273     0.150
     2.597    39.008     0.150
     2.597    67.789     0.150
     2.867    46.695     0.150
     2.867    82.750     0.150
     3.205    50.328     0.150
     3.205    89.922     0.150
     3.205    50.641     0.150
     3.485   100.680     0.150
     3.535    52.859     0.150
     3.685    57.180     0.150
     3.685   101.562     0.150
     3.685    56.039     0.150
     3.685   100.422     0.150
     3.712    58.055     0.150
     3.712   102.609     0.150
     5.041    78.219     0.150
     0.529    11.840     0.150
     0.529    19.738     0.150
     0.959    18.117     0.150
     0.959    30.867     0.150
     0.948    18.059     0.150
     0.948    31.098     0.150
     0.948    30.398     0.150
     1.424    25.816     0.150
     1.424    44.027     0.150
     1.465    25.656     0.150
     1.465    46.297     0.150
     1.676    29.758     0.150
     1.676    51.387     0.150
     1.707    30.637     0.150
     1.707    52.066     0.150
     1.866    32.867     0.150
     1.866    56.277     0.150
     1.856    32.359     0.150
     1.856    57.879     0.150
     1.856    32.957     0.150
     1.856    55.688     0.150
     1.926    33.816     0.150
     1.926    56.406     0.150
     1.931    34.066     0.150
     1.931    59.539     0.150
     1.931    33.938     0.150
     1.931    58.098     0.150
     2.625    43.637     0.150
     2.625    73.648     0.150
     2.625    43.250     0.150
     2.625    72.188     0.150
     3.232    51.539     0.150
     3.232    89.340     0.150
     3.459    56.387     0.150
     3.459    96.387     0.150
     3.546    56.406     0.150
     3.546    94.027     0.150
     3.550    99.406     0.150
     3.709    58.949     0.150
     3.709   101.359     0.150
     3.740    59.156     0.150
     3.740   104.379     0.150
     0.591    11.496     0.150
     0.591    19.766     0.150
     0.897    16.516     0.150
     0.897    28.756     0.150
     0.941    17.057     0.150
     0.941    30.525     0.150
     0.941    17.436     0.150
     0.941    30.656     0.150
     1.366    24.156     0.150
     1.366    42.266     0.150
     1.456    25.166     0.150
     1.456    45.227     0.150
     1.650    28.637     0.150
     1.650    50.256     0.150
     1.693    29.486     0.150
     1.693    52.037     0.150
     1.816    30.695     0.150
     1.816    55.025     0.150
     1.901    31.605     0.150
     1.901    58.195     0.150
     1.901    54.566     0.150
     1.958    30.807     0.150
     1.958    54.506     0.150
     2.568    42.166     0.150
     2.568    74.596     0.150
     3.185    49.367     0.150
     3.185    86.566     0.150
     3.499    54.195     0.150
     3.499    96.025     0.150
     3.500    54.916     0.150
     3.500    96.377     0.150
     3.590    56.166     0.150
     3.590    94.826     0.150
     3.647    57.525     0.150
     3.647   101.057     0.150
     3.681    56.766     0.150
     3.681   101.477     0.150
     0.541    10.678     0.150
     0.541    19.357     0.150
     0.949    17.768     0.150
     0.949    30.268     0.150
     0.898    17.277     0.150
     0.898    16.787     0.150
     0.898    28.457     0.150
     1.434    24.307     0.150
     1.434    42.707     0.150
     1.512    25.227     0.150
     1.512    45.188     0.150
     1.627    29.518     0.150
     1.627    51.457     0.150
     1.752    31.678     0.150
     1.752    54.027     0.150
     1.897    33.188     0.150
     1.897    58.148     0.150
     1.897    30.988     0.150
     1.897    53.248     0.150
     1.974    31.908     0.150
     1.974    54.428     0.150
     2.598    42.928     0.150
     2.598    74.627     0.150
     3.192    86.988     0.150
     3.503    54.418     0.150
     3.503    91.268     0.150
     3.704    62.867     0.150
     3.704   103.678     0.150
     3.717    58.387     0.150
     3.717   103.418     0.150
     0.586    11.517     0.150
     0.586    20.577     0.150
     0.903    16.887     0.150
     0.903    29.237     0.150
     0.949    17.537     0.150
     0.949    31.007     0.150
     0.949    17.257     0.150
     0.949    30.557     0.150
     1.369    24.067     0.150
     1.369    42.177     0.150
     1.449    24.897     0.150
     1.449    44.017     0.150
     1.686    28.457     0.150
     1.686    50.327     0.150
     1.660    29.687     0.150
     1.660    51.887     0.150
     1.892    32.267     0.150
     1.892    57.087     0.150
     1.892    31.557     0.150
     1.892    55.177     0.150
     1.826    32.547     0.150
     1.826    56.417     0.150
     1.948    34.887     0.150
     1.948    54.797     0.150
     2.576    42.837     0.150
     2.576    74.327     0.150
     2.576    42.147     0.150
     2.576    73.887     0.150
     3.195    51.227     0.150
     3.195    50.617     0.150
     3.195    89.287     0.150
     3.490    52.937     0.150
     3.490    94.847     0.150
     3.653    61.817     0.150
     3.653   102.497     0.150
     3.689    58.047     0.150
     5.009    76.357     0.150
     5.009   136.467     0.150
     0.584    11.480     0.150
     0.584    19.201     0.150
     0.906    16.811     0.150
     0.906    28.850     0.150
     0.898    16.330     0.150
     0.898    28.100     0.150
     0.898    16.541     0.150
     0.898    27.621     0.150
     1.392    24.400     0.150
     1.392    43.660     0.150
     1.500    26.111     0.150
     1.500    46.881     0.150
     1.614    27.520     0.150
     1.614    49.400     0.150
     1.737    29.701     0.150
     1.737    53.311     0.150
     1.797    30.900     0.150
     1.836    31.461     0.150
     1.836    55.320     0.150
     1.924    32.311     0.150
     1.924    57.891     0.150
     1.924    30.420     0.150
     1.924    53.830     0.150
     1.990    30.990     0.150
     1.990    55.801     0.150
     2.560    41.471     0.150
     2.560    72.930     0.150
     2.560    41.590     0.150
     2.560    72.180     0.150
     2.827    45.391     0.150
     2.827    79.920     0.150
     2.827    44.141     0.150
     2.827    77.000     0.150
     3.163    49.811     0.150
     3.163    86.850     0.150
     3.163    48.531     0.150
     3.163    86.340     0.150
     3.526    97.830     0.150
     3.534    55.090     0.150
     3.660    57.621     0.150
     3.660   101.061     0.150
     3.677    57.100     0.150
     3.677   100.240     0.150
     3.977    62.100     0.150
     3.977   109.740     0.150
     4.426    76.795     0.150
     4.426   156.645     0.150
     5.015    76.670     0.150
     5.015   135.061     0.150
     7.988   116.520     0.150
     7.988   202.645     0.150
     8.779   126.051     0.150
     8.779   261.195     0.150
     9.372   307.779     0.150
    10.956   351.650     0.150
     0.580    11.316     0.150
     0.580    19.195     0.150
     0.872    15.996     0.150
     0.872    28.445     0.150
     0.872    17.164     0.150
     0.913    16.574     0.150
     0.913    29.117     0.150
     1.410    24.438     0.150
     1.410    43.234     0.150
     1.528    25.645     0.150
     1.528    46.508     0.150
     1.592    27.637     0.150
     1.592    48.297     0.150
     1.765    29.816     0.150
     1.765    53.285     0.150
     1.808    31.246     0.150
     1.808    55.617     0.150
     1.786    30.074     0.150
     1.938    31.895     0.150
     1.938    58.387     0.150
     1.938    31.996     0.150
     1.938    52.395     0.150
     2.010    30.887     0.150
     2.010    53.727     0.150
     2.556    41.324     0.150
     2.556    74.367     0.150
     2.556    40.527     0.150
     2.556    73.145     0.150
     2.804    44.797     0.150
     2.804    82.855     0.150
     2.804    44.156     0.150
     2.804    76.355     0.150
     2.880    43.824     0.150
     2.880    74.938     0.150
     3.150    49.715     0.150
     3.150    85.305     0.150
     3.150    46.695     0.150
     3.150    84.816     0.150
     3.557    54.984     0.150
     3.557    98.938     0.150
     3.669    58.227     0.150
     3.669   100.555     0.150
     3.675    56.617     0.150
     3.675    98.547     0.150
     4.447    89.855     0.150
     4.765    72.547     0.150
     7.664   199.035     0.150
     8.009   117.504     0.150
     8.009   207.328     0.150
     8.783   128.461     0.150
     8.783   270.047     0.150
    24.459   321.859     0.150
    40.651   463.383     0.150
     0.596    11.791     0.150
     0.596    20.320     0.150
     0.899    16.352     0.150
     0.899    29.121     0.150
     1.003    17.602     0.150
     1.003    31.111     0.150
     1.003    17.801     0.150
     1.003    32.641     0.150
     1.342    23.941     0.150
     1.342    42.201     0.150
     1.394    24.801     0.150
     1.394    42.980     0.150
     1.632    28.801     0.150
     1.632    50.531     0.150
     1.707    30.051     0.150
     1.707    53.820     0.150
     1.861    32.602     0.150
     1.861    57.580     0.150
     1.861    31.932     0.150
     1.861    54.602     0.150
     1.854    32.121     0.150
     1.854    57.230     0.150
     1.905    31.791     0.150
     1.905    54.650     0.150
     1.942    34.121     0.150
     1.942    60.121     0.150
     3.226    51.881     0.150
     3.226    50.191     0.150
     3.699    58.561     0.150
     3.699   103.371     0.150
     4.337    68.441     0.150
     4.337    83.213     0.150
     4.337   143.314     0.150
     7.916   116.422     0.150
     7.916   251.182     0.150
     8.778   128.074     0.150
     8.778   272.250     0.150
     9.276   137.109     0.150
    13.232   189.623     0.150
     0.582    11.402     0.150
     0.582    20.172     0.150
     0.906    17.121     0.150
     0.906    29.113     0.150
     0.949    17.844     0.150
     0.949    31.043     0.150
     0.949    31.602     0.150
     1.372    24.742     0.150
     1.372    42.363     0.150
     1.450    25.230     0.150
     1.450    44.543     0.150
     1.688    29.031     0.150
     1.688    51.352     0.150
     1.661    28.641     0.150
     1.661    50.473     0.150
     1.889    31.461     0.150
     1.889    32.094     0.150
     1.889    58.402     0.150
     1.828    31.953     0.150
     1.828    55.023     0.150
     1.946    31.633     0.150
     1.946    53.652     0.150
     1.886    33.062     0.150
     1.886    57.723     0.150
     2.580    41.773     0.150
     2.580    73.320     0.150
     3.197    49.973     0.150
     3.197    87.980     0.150
     3.693    57.094     0.150
     3.693   102.641     0.150
     4.010    62.363     0.150
     4.010   111.730     0.150
     8.784   129.023     0.150
     8.784   276.723     0.150
     9.324   138.172     0.150
    40.578   460.363     0.150
     0.562    10.871     0.150
     0.562    19.211     0.150
     0.927    17.691     0.150
     0.927    30.281     0.150
     0.952    18.492     0.150
     0.952    32.504     0.150
     0.952    19.273     0.150
     1.391    24.762     0.150
     1.391    42.562     0.150
     1.452    24.652     0.150
     1.452    43.113     0.150
     1.692    28.523     0.150
     1.692    50.141     0.150
     1.692    29.504     0.150
     1.670    30.004     0.150
     1.670    52.562     0.150
     1.874    30.652     0.150
     1.874    54.551     0.150
     1.874    33.203     0.150
     1.874    53.602     0.150
     1.935    32.363     0.150
     1.935    53.273     0.150
     1.845    31.902     0.150
     1.845    57.512     0.150
     1.882    33.594     0.150
     1.882    57.383     0.150
     2.221    37.223     0.150
     2.303    39.113     0.150
     2.598    42.363     0.150
     2.598    75.582     0.150
     2.598    72.223     0.150
     2.598    41.980     0.150
     2.598    41.344     0.150
     2.662    46.434     0.150
     2.877    47.293     0.150
     2.882    47.242     0.150
     2.882    82.934     0.150
     2.882    82.652     0.150
     2.882    46.754     0.150
     2.882    48.262     0.150
     3.288    51.652     0.150
     3.212    52.012     0.150
     3.212    51.723     0.150
     3.212    84.594     0.150
     3.320    52.492     0.150
     3.517    55.773     0.150
     3.517    99.242     0.150
     3.676    65.074     0.150
     3.676    99.594     0.150
     3.712    58.383     0.150
     3.712   103.633     0.150
     4.028    61.512     0.150
     4.094    63.902     0.150
     4.371    89.047     0.150
     4.371   147.422     0.150
     4.421    68.082     0.150
     4.426    68.812     0.150
     4.399    68.523     0.150
     4.399   120.621     0.150
     4.805    72.230     0.150
     4.883    75.004     0.150
     4.931    74.871     0.150
     5.033    78.344     0.150
     5.202    80.973     0.150
     5.234    80.184     0.150
     5.319    81.664     0.150
     7.973   119.195     0.150
     7.973   251.520     0.150
     8.804   130.602     0.150
     8.804   270.051     0.150
    10.904   163.152     0.150
    16.010   228.594     0.150
    16.351   229.934     0.150
    16.516   234.562     0.150
    40.572   464.848     0.150
     0.581    11.405     0.150
     0.581    19.444     0.150
     0.911    16.796     0.150
     0.911    29.896     0.150
     0.986    17.466     0.150
     0.986    32.325     0.150
     0.986    30.866     0.150
     1.361    24.274     0.150
     1.361    42.274     0.150
     1.653    28.075     0.150
     1.863    30.886     0.150
     1.863    53.915     0.150
     1.863    31.095     0.150
     1.853    33.024     0.150
     1.853    58.505     0.150
     1.914    30.806     0.150
     1.914    53.435     0.150
     2.182    35.345     0.150
     2.290    36.685     0.150
     2.597    40.726     0.150
     2.597    70.765     0.150
     2.597    42.556     0.150
     2.775    48.075     0.150
     2.647    43.815     0.150
     2.828    45.685     0.150
     2.839    44.976     0.150
     2.908    47.075     0.150
     2.908    84.966     0.150
     2.908    48.306     0.150
     3.173    47.944     0.150
     3.224    49.706     0.150
     3.224    94.235     0.150
     3.297    51.126     0.150
     3.480    52.716     0.150
     3.480    96.136     0.150
     3.480    54.815     0.150
     3.548    56.466     0.150
     3.548    95.485     0.150
     3.657    58.185     0.150
     3.722    56.786     0.150
     3.876    58.165     0.150
     4.055    61.706     0.150
     4.109    63.396     0.150
     4.110    61.845     0.150
     4.341    65.216     0.150
     4.347    65.075     0.150
     4.347    84.099     0.150
     4.347   146.200     0.150
     4.389    66.575     0.150
     4.387    66.694     0.150
     4.497    67.595     0.150
     4.790    71.845     0.150
     4.772    71.466     0.150
     4.863    72.854     0.150
     4.891    73.476     0.150
     5.014    76.774     0.150
     5.014   130.896     0.150
     5.195    76.694     0.150
     5.283    78.194     0.150
     5.438    80.546     0.150
     5.608    83.546     0.150
     5.729    84.915     0.150
     5.915    86.745     0.150
     5.927    87.325     0.150
     6.603    96.636     0.150
     7.119   104.616     0.150
     7.136   103.386     0.150
     7.407   107.495     0.150
     7.546   110.505     0.150
     7.618   111.024     0.150
     7.709   111.165     0.150
     7.709   116.585     0.150
     7.938   116.675     0.150
     7.938   250.825     0.150
     7.938   114.835     0.150
     8.662   125.175     0.150
     8.762   126.056     0.150
     8.790   126.806     0.150
     8.790   268.706     0.150
     8.880   127.636     0.150
     9.289   137.610     0.150
    10.383   149.216     0.150
    13.094   187.825     0.150
    13.254   191.509     0.150
    13.880   196.255     0.150
    14.033   199.146     0.150
    14.246   200.425     0.150
    14.778   207.854     0.150
    15.150   211.556     0.150
    15.177   214.896     0.150
    16.207   228.956     0.150
    18.502   259.175     0.150
     0.593    11.643     0.150
     0.593    19.973     0.150
     0.895    16.883     0.150
     0.895    29.201     0.150
     0.960    18.111     0.150
     0.960    31.662     0.150
     0.960    18.432     0.150
     0.960    32.742     0.150
     1.357    24.162     0.150
     1.357    42.441     0.150
     1.436    25.562     0.150
     1.436    44.223     0.150
     1.674    28.861     0.150
     1.674    51.012     0.150
     1.667    29.992     0.150
     1.667    52.191     0.150
     1.827    32.393     0.150
     1.827    57.701     0.150
     1.890    32.361     0.150
     1.890    55.031     0.150
     1.942    32.031     0.150
     1.942    54.902     0.150
     2.574    41.361     0.150
     2.574    75.342     0.150
     2.574    71.383     0.150
     2.880    47.732     0.150
     2.880    79.512     0.150
     3.197    51.902     0.150
     3.197    51.201     0.150
     3.197    87.912     0.150
     3.485    55.643     0.150
     3.485    97.182     0.150
     3.576    56.822     0.150
     3.576    98.133     0.150
     3.686    58.332     0.150
     3.686   103.723     0.150
     4.010    62.832     0.150
     4.010   112.812     0.150
     0.475     9.954     0.150
     0.475    17.444     0.150
     0.474     9.935     0.150
     0.474    17.454     0.150
     0.543     9.914     0.150
     0.543    17.454     0.150
     0.543    17.954     0.150
     0.543    17.314     0.150
     0.717    13.015     0.150
     0.717    22.904     0.150
     0.749    14.354     0.150
     0.749    24.895     0.150
     0.749    13.954     0.150
     0.749    25.154     0.150
     0.825    14.704     0.150
     0.825    25.645     0.150
     0.917    16.704     0.150
     0.917    30.074     0.150
     0.917    16.685     0.150
     0.917    29.734     0.150
     0.917    30.574     0.150
     0.934    16.114     0.150
     0.934    29.435     0.150
     1.032    18.564     0.150
     1.032    32.715     0.150
     1.032    18.834     0.150
     1.032    32.255     0.150
     1.013    17.984     0.150
     1.013    31.595     0.150
     1.062    19.284     0.150
     1.062    34.494     0.150
     1.062    19.805     0.150
     1.174    36.734     0.150
     1.174    20.284     0.150
     1.130    20.725     0.150
     1.130    37.164     0.150
     1.259    41.015     0.150
     1.321    22.374     0.150
     1.320    22.475     0.150
     1.428    24.164     0.150
     1.590    26.685     0.150
     1.590    47.484     0.150
     1.590    26.194     0.150
     1.590    45.664     0.150
     1.516    25.185     0.150
     1.541    49.824     0.150
     1.664    25.994     0.150
     2.099    32.005     0.150
     2.099    58.255     0.150
     2.096    32.725     0.150
     2.096    57.265     0.150
     2.204    34.435     0.150
     2.176    34.755     0.150
     2.253    35.765     0.150
     2.421    37.755     0.150
     2.651    41.364     0.150
     2.648    41.744     0.150
     2.762    43.584     0.150
     2.853    44.055     0.150
     3.182    48.704     0.150
     0.460    10.495     0.150
     0.459     9.515     0.150
     0.459    16.315     0.150
     0.540    10.535     0.150
     0.540    17.795     0.150
     0.540    10.365     0.150
     0.540    17.475     0.150
     0.734    13.695     0.150
     0.734    14.445     0.150
     0.734    25.945     0.150
     0.727    13.635     0.150
     0.727    23.925     0.150
     0.830    15.285     0.150
     0.830    26.725     0.150
     0.830    26.275     0.150
     0.902    17.575     0.150
     0.902    30.965     0.150
     0.909    16.695     0.150
     0.909    29.055     0.150
     0.920    16.715     0.150
     0.920    29.165     0.150
     0.960    17.635     0.150
     0.960    30.315     0.150
     0.960    17.875     0.150
     0.960    31.585     0.150
     0.999    18.425     0.150
     1.034    18.305     0.150
     1.034    32.715     0.150
     1.113    20.135     0.150
     1.115    20.515     0.150
     1.165    19.685     0.150
     1.165    35.445     0.150
     1.170    20.595     0.150
     1.170    20.895     0.150
     1.244    22.095     0.150
     1.244    22.035     0.150
     1.244    38.465     0.150
     1.292    22.365     0.150
     1.309    23.035     0.150
     1.314    22.915     0.150
     1.314    41.565     0.150
     1.404    24.095     0.150
     1.459    24.755     0.150
     1.430    24.755     0.150
     1.501    25.595     0.150
     1.501    25.725     0.150
     1.532    28.085     0.150
     1.595    26.895     0.150
     1.595    47.515     0.150
     1.595    47.395     0.150
     1.650    49.555     0.150
     1.650    26.355     0.150
     1.727    49.965     0.150
     1.748    29.545     0.150
     2.162    34.895     0.150
     2.192    34.945     0.150
     2.224    36.745     0.150
     2.224    64.725     0.150
     2.238    36.085     0.150
     2.551    40.175     0.150
     2.635    41.845     0.150
     2.638    42.195     0.150
     2.747    43.405     0.150
     3.184    49.105     0.150
     3.184    86.855     0.150
     0.595    11.541     0.150
     0.595    19.852     0.150
     0.893    16.281     0.150
     0.893    28.451     0.150
     0.946    17.832     0.150
     0.946    31.451     0.150
     0.946    29.992     0.150
     1.361    23.441     0.150
     1.361    41.041     0.150
     1.450    23.992     0.150
     1.450    42.771     0.150
     1.687    27.992     0.150
     1.687    49.822     0.150
     1.687    28.432     0.150
     1.654    27.812     0.150
     1.654    51.492     0.150
     1.900    31.301     0.150
     1.900    31.412     0.150
     1.900    54.531     0.150
     1.817    30.301     0.150
     1.817    55.012     0.150
     1.954    30.611     0.150
     1.954    54.742     0.150
     1.887    32.051     0.150
     1.887    57.301     0.150
     1.988    32.691     0.150
     1.988    58.092     0.150
     1.988    32.551     0.150
     2.209    36.041     0.150
     2.328    37.461     0.150
     2.567    40.621     0.150
     2.567    74.211     0.150
     2.567    41.602     0.150
     2.567    40.322     0.150
     2.567    71.441     0.150
     2.816    43.922     0.150
     2.686    45.211     0.150
     2.877    45.252     0.150
     2.867    46.402     0.150
     2.867    79.672     0.150
     2.867    46.672     0.150
     2.867    76.861     0.150
     3.186    49.922     0.150
     3.186    50.131     0.150
     3.186    87.152     0.150
     3.297    51.332     0.150
     3.338    51.812     0.150
     3.493    53.922     0.150
     3.493    96.541     0.150
     3.493    54.551     0.150
     3.762    57.041     0.150
     3.644    62.852     0.150
     3.644   105.643     0.150
     3.680    56.002     0.150
     3.680   102.852     0.150
     3.916    58.992     0.150
     3.841    59.611     0.150
     3.841   105.992     0.150
     4.039    61.352     0.150
     3.999    61.791     0.150
     4.089    62.121     0.150
     4.149    63.291     0.150
     4.107    63.102     0.150
     4.388    66.211     0.150
     4.388    87.750     0.150
     4.430    66.902     0.150
     4.409    67.143     0.150
     4.383    67.172     0.150
     4.778    72.312     0.150
     4.827    73.232     0.150
     4.827   130.262     0.150
     4.944    74.092     0.150
     4.918    74.031     0.150
     5.000    76.492     0.150
     5.203    77.643     0.150
     5.228    78.152     0.150
     5.296    79.143     0.150
     5.633    83.102     0.150
     5.628    83.342     0.150
     5.730    85.621     0.150
     5.947    87.451     0.150
     5.997    88.611     0.150
     5.956    87.041     0.150
     5.951    91.182     0.150
     6.485    95.201     0.150
     6.636    96.801     0.150
     6.712    96.162     0.150
     7.023   103.221     0.150
     7.121   103.562     0.150
     7.154   104.361     0.150
     7.144   104.521     0.150
     7.399   107.871     0.150
     7.560   110.271     0.150
     7.585   110.871     0.150
     7.653   111.211     0.150
     7.605   111.412     0.150
     7.943   115.471     0.150
     7.946   115.131     0.150
     7.945   115.471     0.150
     7.948   117.301     0.150
     7.948   251.227     0.150
     7.948   115.852     0.150
     7.948   115.512     0.150
     7.948   115.621     0.150
     8.747   127.371     0.150
     8.770   127.381     0.150
     8.771   128.730     0.150
     8.771   268.982     0.150
     8.771   127.732     0.150
     9.505   136.881     0.150
    10.132   143.721     0.150
    12.060   169.291     0.150
    13.285   193.525     0.150
    15.117   214.631     0.150
    15.209   213.982     0.150
    15.148   213.412     0.150
    15.177   214.602     0.150
    15.207   215.602     0.150
    15.284   215.072     0.150
    15.431   217.451     0.150
    15.450   218.072     0.150
    15.515   218.871     0.150
    15.593   220.012     0.150
    15.639   220.762     0.150
    15.910   223.102     0.150
    16.207   228.441     0.150
    16.596   232.342     0.150
    17.448   242.982     0.150
    20.530   277.182     0.150
    21.593   288.971     0.150
    23.321   307.822     0.150
    24.384   319.807     0.150
    40.583   463.322     0.150
    43.574   483.041     0.150
    44.111   487.732     0.150
    69.908   670.502     0.150
    72.371   686.352     0.150
     0.578    11.363     0.150
     0.578    19.625     0.150
     0.913    17.043     0.150
     0.913    29.316     0.150
     0.984    17.977     0.150
     0.984    31.113     0.150
     0.984    18.094     0.150
     0.984    28.406     0.150
     1.364    24.184     0.150
     1.364    41.977     0.150
     1.416    25.066     0.150
     1.416    43.543     0.150
     1.655    28.434     0.150
     1.655    50.633     0.150
     1.695    29.453     0.150
     1.695    50.516     0.150
     1.854    32.105     0.150
     1.854    56.215     0.150
     1.862    30.883     0.150
     1.914    29.363     0.150
     1.914    54.383     0.150
     1.956    32.793     0.150
     1.956    55.883     0.150
     2.598    42.664     0.150
     2.598    74.883     0.150
     3.224    51.246     0.150
     3.224    89.586     0.150
     3.708    56.844     0.150
     3.708   103.793     0.150
     4.347    87.824     0.150
     4.347   150.824     0.150
     7.941   118.172     0.150
     7.941   252.824     0.150
     8.792   129.406     0.150
     8.792   271.105     0.150
    40.543   463.492     0.150
     0.567    11.219     0.150
     0.567    19.559     0.150
     0.927    16.949     0.150
     0.927    29.159     0.150
     0.995    17.609     0.150
     0.995    31.809     0.150
     0.995    17.929     0.150
     0.995    31.129     0.150
     1.372    23.999     0.150
     1.372    42.989     0.150
     1.408    25.479     0.150
     1.648    28.649     0.150
     1.648    51.089     0.150
     1.709    29.259     0.150
     1.709    52.379     0.150
     1.870    32.069     0.150
     1.870    56.949     0.150
     1.846    31.249     0.150
     1.846    54.769     0.150
     1.846    54.509     0.150
     1.899    30.919     0.150
     1.899    54.129     0.150
     1.941    33.159     0.150
     1.941    59.169     0.150
     1.941    32.939     0.150
     1.941    56.909     0.150
     2.614    42.929     0.150
     2.614    76.199     0.150
     2.614    44.899     0.150
     2.614    72.319     0.150
     3.240    51.499     0.150
     3.240    91.259     0.150
     3.240    51.379     0.150
     3.240    96.829     0.150
     3.487    53.909     0.150
     3.487    91.208     0.150
     3.671    56.789     0.150
     3.671   100.269     0.150
     3.723    58.029     0.150
     3.723   103.449     0.150
     0.583    11.421     0.150
     0.583    19.471     0.150
     0.906    16.980     0.150
     0.906    29.661     0.150
     0.905    17.190     0.150
     0.905    30.351     0.150
     0.905    18.070     0.150
     0.905    30.690     0.150
     1.390    24.541     0.150
     1.390    42.621     0.150
     1.494    25.181     0.150
     1.494    43.690     0.150
     1.731    29.551     0.150
     1.731    52.261     0.150
     1.620    29.761     0.150
     1.620    50.461     0.150
     1.801    31.931     0.150
     1.801    56.121     0.150
     1.920    32.221     0.150
     1.920    32.400     0.150
     1.920    55.201     0.150
     1.842    32.721     0.150
     1.842    56.811     0.150
     1.985    31.581     0.150
     1.985    55.561     0.150
     1.995    33.480     0.150
     1.995    58.521     0.150
     1.995    33.681     0.150
     1.995    57.650     0.150
     2.254    37.281     0.150
     2.349    38.320     0.150
     2.563    42.221     0.150
     2.563    74.381     0.150
     2.563    42.531     0.150
     2.851    46.190     0.150
     2.710    44.841     0.150
     2.920    46.521     0.150
     2.832    46.980     0.150
     2.832    78.161     0.150
     3.167    50.851     0.150
     3.167    89.931     0.150
     3.167    88.471     0.150
     3.336    52.781     0.150
     3.369    52.661     0.150
     3.530    55.851     0.150
     3.530    54.161     0.150
     3.530    93.371     0.150
     3.660    57.771     0.150
     3.660   103.351     0.150
     3.788    58.501     0.150
     3.809    60.011     0.150
     3.809   107.730     0.150
     3.957    61.181     0.150
     3.981    63.480     0.150
     4.134    64.650     0.150
     4.133    64.631     0.150
     4.420    67.465     0.150
     4.420    83.904     0.150
     4.420   147.756     0.150
     4.349    67.581     0.150
     4.349   118.980     0.150
     4.452    68.871     0.150
     4.811    73.871     0.150
     4.962    76.480     0.150
     7.622   113.690     0.150
     7.985   116.277     0.150
     7.985   251.067     0.150
     7.985   117.061     0.150
     8.667   127.070     0.150
     8.780   128.284     0.150
     8.780   268.312     0.150
     9.366   140.385     0.150
     9.366   306.373     0.150
    10.950   161.088     0.150
    10.950   355.659     0.150
    13.330   191.317     0.150
    13.330   430.916     0.150
    14.700   209.480     0.150
    15.479   223.001     0.150
    15.582   222.711     0.150
    15.529   221.751     0.150
    16.235   226.121     0.150
    16.666   234.271     0.150
    18.583   260.460     0.150
    40.621   461.834     0.150
    98.112   816.051     0.150
     0.581    11.412     0.150
     0.581    19.672     0.150
     0.869    17.592     0.150
     0.869    29.182     0.150
     0.869    17.371     0.150
     0.912    16.701     0.150
     0.912    29.152     0.150
     1.410    24.252     0.150
     1.410    42.242     0.150
     1.530    24.592     0.150
     1.530    44.201     0.150
     1.589    30.852     0.150
     1.589    51.902     0.150
     1.768    28.252     0.150
     1.784    29.621     0.150
     1.784    53.191     0.150
     1.806    31.441     0.150
     1.806    55.021     0.150
     1.941    31.082     0.150
     1.941    56.051     0.150
     1.941    31.461     0.150
     1.941    54.811     0.150
     2.007    32.061     0.150
     2.007    57.762     0.150
     2.007    54.941     0.150
     2.013    54.152     0.150
     2.289    35.682     0.150
     2.372    37.361     0.150
     2.554    40.342     0.150
     2.554    71.791     0.150
     2.554    40.561     0.150
     2.554    73.791     0.150
     2.554    38.451     0.150
     2.802    44.881     0.150
     2.802    90.342     0.150
     2.802    47.992     0.150
     2.802    42.922     0.150
     2.802    88.441     0.150
     2.883    44.441     0.150
     2.734    45.002     0.150
     2.935    46.691     0.150
     2.956    45.201     0.150
     3.148    49.902     0.150
     3.148    88.172     0.150
     3.252    50.691     0.150
     3.370    52.191     0.150
     3.398    50.672     0.150
     3.558    54.322     0.150
     3.558    97.361     0.150
     3.558    52.861     0.150
     3.558    54.711     0.150
     3.558    95.121     0.150
     3.637    54.752     0.150
     3.637    94.662     0.150
     3.668    56.291     0.150
     3.668    99.391     0.150
     3.668    59.332     0.150
     3.673    56.852     0.150
     3.673   100.721     0.150
     3.814    58.891     0.150
     3.992    61.262     0.150
     4.110    62.461     0.150
     4.170    63.061     0.150
     4.149    63.791     0.150
     4.202    64.631     0.150
     4.445    68.572     0.150
     4.450    67.441     0.150
     4.450    66.881     0.150
     4.450    68.531     0.150
     4.450    69.691     0.150
     4.450    85.941     0.150
     4.450   120.615     0.150
     4.450   142.791     0.150
     4.484    67.721     0.150
     4.504    68.551     0.150
     4.548    69.842     0.150
     4.606    71.031     0.150
     4.834    74.082     0.150
     4.895    75.061     0.150
     4.958    76.342     0.150
     5.018    76.412     0.150
     5.780    86.162     0.150
     6.717    99.422     0.150
     7.434   109.922     0.150
     7.630   112.121     0.150
     7.662   115.311     0.150
     7.662   115.881     0.150
     8.010   117.215     0.150
     8.010   251.590     0.150
     8.010   117.381     0.150
     8.583   126.891     0.150
     8.767   128.061     0.150
     8.782   128.297     0.150
     8.782   224.498     0.150
     8.782   270.074     0.150
     9.399   140.113     0.150
     9.399   301.521     0.150
     9.624   141.482     0.150
    10.469   153.951     0.150
    10.986   161.896     0.150
    10.986   349.721     0.150
    10.949   158.742     0.150
    11.113   163.561     0.150
    12.220   179.371     0.150
    13.109   191.422     0.150
    13.366   193.773     0.150
    13.366   193.441     0.150
    13.536   193.582     0.150
    13.574   193.881     0.150
    13.574   195.291     0.150
    13.992   199.592     0.150
    14.050   201.941     0.150
    14.287   205.221     0.150
    14.952   212.932     0.150
    15.000   213.121     0.150
    15.056   214.191     0.150
    15.081   214.352     0.150
    15.098   214.092     0.150
    15.111   215.061     0.150
    15.132   214.912     0.150
    15.156   215.232     0.150
    15.164   215.652     0.150
    15.193   216.672     0.150
    15.225   217.242     0.150
    15.286   216.582     0.150
    15.256   217.342     0.150
    15.362   218.402     0.150
    15.371   219.121     0.150
    15.458   219.621     0.150
    15.475   219.691     0.150
    15.498   220.172     0.150
    15.559   220.602     0.150
    15.534   217.182     0.150
    15.534   221.961     0.150
    15.615   220.611     0.150
    15.628   222.051     0.150
    15.638   222.381     0.150
    15.643   222.221     0.150
    15.714   221.742     0.150
    15.686   222.592     0.150
    15.854   224.152     0.150
    15.831   224.672     0.150
    15.956   226.391     0.150
    15.999   225.852     0.150
    16.033   227.332     0.150
    16.239   229.742     0.150
    16.239   231.461     0.150
    16.254   229.922     0.150
    16.338   230.502     0.150
    16.323   231.271     0.150
    16.354   231.422     0.150
    16.256   229.641     0.150
    16.640   234.791     0.150
    16.700   234.631     0.150
    16.876   237.541     0.150
    16.917   238.461     0.150
    17.001   238.711     0.150
    17.059   239.072     0.150
    17.171   240.732     0.150
    17.396   239.482     0.150
    17.495   245.602     0.150
    17.704   248.121     0.150
    17.704   249.822     0.150
    17.797   249.422     0.150
    17.960   251.012     0.150
    18.172   253.572     0.150
    18.310   254.742     0.150
    18.619   260.840     0.150
    18.619   258.061     0.150
    18.619   260.521     0.150
    18.687   260.092     0.150
    19.095   264.402     0.150
    19.266   265.531     0.150
    19.247   266.191     0.150
    19.307   266.502     0.150
    19.477   270.941     0.150
    19.588   269.652     0.150
    19.937   273.461     0.150
    20.041   274.742     0.150
    20.202   276.262     0.150
    20.363   280.432     0.150
    20.609   279.402     0.150
    20.659   280.111     0.150
    20.946   284.541     0.150
    21.378   289.211     0.150
    21.390   288.541     0.150
    21.457   290.082     0.150
    21.560   290.842     0.150
    21.667   290.811     0.150
    21.881   294.002     0.150
    22.133   296.891     0.150
    22.128   296.742     0.150
    22.282   298.971     0.150
    22.597   303.381     0.150
    22.597   304.732     0.150
    22.606   302.012     0.150
    22.615   302.172     0.150
    23.004   306.711     0.150
    23.046   306.002     0.150
    23.313   310.021     0.150
    23.401   308.701     0.150
    23.650   313.041     0.150
    24.132   316.732     0.150
    24.226   318.191     0.150
    24.290   318.031     0.150
    24.460   319.246     0.150
    24.460   318.592     0.150
    25.522   329.852     0.150
    27.130   344.121     0.150
    28.630   357.771     0.150
    39.196   448.182     0.150
    40.259   458.221     0.150
    40.259   456.701     0.150
    40.654   462.154     0.150
    40.654   460.592     0.150
    41.906   471.521     0.150
    43.136   480.801     0.150
    43.187   481.531     0.150
    43.376   482.172     0.150
    43.644   485.971     0.150
    44.640   493.832     0.150
    44.640   497.381     0.150
    44.701   494.447     0.150
    44.701   493.992     0.150
    45.623   501.512     0.150
    58.933   600.631     0.150
    60.358   610.072     0.150
    65.269   645.492     0.150
    66.830   653.121     0.150
    68.868   666.252     0.150
    70.402   678.732     0.150
    72.895   689.912     0.150
    72.895   691.672     0.150
    74.528   700.012     0.150
    77.771   719.092     0.150
    77.771   718.521     0.150
    78.402   722.631     0.150
    79.069   727.018     0.150
    80.782   734.072     0.150
    80.782   734.992     0.150
    82.182   742.621     0.150
    82.182   744.172     0.150
    84.980   757.447     0.150
    84.980   756.332     0.150
    86.608   767.121     0.150
    93.415   796.666     0.150
    93.415   795.791     0.150
    94.723   804.342     0.150
    94.723   800.721     0.150
    98.141   817.021     0.150
   104.154   846.422     0.150
     0.585    11.676     0.150
     0.585    19.477     0.150
     0.902    16.965     0.150
     0.902    29.184     0.150
     1.377    23.676     0.150
     1.377    42.184     0.150
     1.470    24.656     0.150
     1.470    43.855     0.150
     1.707    28.246     0.150
     1.707    50.023     0.150
     1.707    28.453     0.150
     1.641    30.066     0.150
     1.641    51.613     0.150
     1.906    31.984     0.150
     1.906    55.855     0.150
     1.906    30.605     0.150
     1.906    54.477     0.150
     1.813    30.824     0.150
     1.813    56.215     0.150
     1.966    30.965     0.150
     1.966    54.035     0.150
     1.987    33.016     0.150
     1.987    58.336     0.150
     1.987    56.305     0.150
     1.866    32.793     0.150
     1.866    58.363     0.150
     2.230    36.203     0.150
     2.334    37.574     0.150
     2.569    41.395     0.150
     2.569    42.434     0.150
     2.569    74.316     0.150
     2.569    40.254     0.150
     2.569    72.625     0.150
     2.830    45.035     0.150
     2.830    44.336     0.150
     2.694    44.266     0.150
     2.883    45.523     0.150
     2.896    45.645     0.150
     3.217    49.023     0.150
     3.313    51.836     0.150
     3.181    50.203     0.150
     3.181    90.816     0.150
     3.181    49.727     0.150
     3.181    88.477     0.150
     3.350    52.203     0.150
     3.512    55.125     0.150
     3.512    54.574     0.150
     3.655    56.184     0.150
     3.655   100.203     0.150
     3.655    61.953     0.150
     3.655    97.734     0.150
     3.771    57.227     0.150
     3.683    56.906     0.150
     3.683   102.664     0.150
     3.881    58.613     0.150
     3.933    61.426     0.150
     3.829   106.016     0.150
     4.055    61.855     0.150
     4.109    63.465     0.150
     3.994    62.004     0.150
     3.994   110.766     0.150
     4.158    63.375     0.150
     4.122    63.953     0.150
     4.400    66.734     0.150
     4.400    66.848     0.150
     4.400    84.523     0.150
     4.400   142.348     0.150
     4.430    67.977     0.150
     4.446    67.715     0.150
     4.370    67.086     0.150
     4.370   118.656     0.150
     4.796    72.895     0.150
     4.844    72.664     0.150
     4.939    74.996     0.150
     4.961    75.414     0.150
     4.814    72.914     0.150
     4.814   130.215     0.150
     5.010    76.496     0.150
     5.010   132.336     0.150
     5.222    79.656     0.150
     5.249    79.945     0.150
     5.316    80.855     0.150
     5.654    85.586     0.150
     5.649    85.043     0.150
     5.608    83.164     0.150
     5.608   150.676     0.150
     5.747    86.293     0.150
     5.616    83.855     0.150
     5.616   147.523     0.150
     5.968    90.293     0.150
     5.977    90.336     0.150
     6.011    90.504     0.150
     6.657    99.863     0.150
     6.730   100.156     0.150
     7.041   104.074     0.150
     7.141   106.316     0.150
     7.174   107.266     0.150
     7.163   106.164     0.150
     7.488   106.734     0.150
     7.413   109.555     0.150
     7.579   111.477     0.150
     7.603   111.016     0.150
     7.673   112.805     0.150
     7.616   112.055     0.150
     7.730   114.184     0.150
     7.679   112.555     0.150
     7.967   117.449     0.150
     7.967   250.598     0.150
     7.967   116.785     0.150
     7.967   116.676     0.150
     8.661   126.266     0.150
     8.757   128.125     0.150
     8.778   129.004     0.150
     8.779   128.711     0.150
     8.779   270.734     0.150
     8.779   127.836     0.150
     9.345   139.211     0.150
     9.345   294.180     0.150
     9.415   136.895     0.150
     9.509   138.766     0.150
     9.567   140.246     0.150
    10.153   148.645     0.150
    10.075   146.254     0.150
    10.926   158.781     0.150
    10.926   342.930     0.150
    10.936   158.383     0.150
    11.303   163.316     0.150
    11.824   170.535     0.150
    12.071   173.555     0.150
    12.105   172.543     0.150
    12.570   178.074     0.150
    13.306   191.633     0.150
    13.306   423.473     0.150
    14.644   207.984     0.150
    14.779   209.273     0.150
    15.042   212.996     0.150
    15.071   213.316     0.150
    15.133   215.176     0.150
    15.655   221.426     0.150
    15.802   222.594     0.150
    15.926   224.285     0.150
    16.223   228.645     0.150
    16.295   229.895     0.150
    16.333   229.133     0.150
    16.612   232.945     0.150
    18.559   260.047     0.150
    20.549   279.035     0.150
    21.609   289.586     0.150
    22.108   296.734     0.150
    22.248   297.336     0.150
    23.634   312.133     0.150
    24.405   319.980     0.150
    24.405   319.125     0.150
    40.598   463.133     0.150
    43.589   484.934     0.150
     0.595    11.602     0.150
     0.595    19.965     0.150
     0.894    16.324     0.150
     0.894    28.762     0.150
     1.354    23.555     0.150
     1.354    41.453     0.150
     1.432    23.965     0.150
     1.432    43.012     0.150
     1.670    27.895     0.150
     1.670    50.145     0.150
     1.670    29.555     0.150
     1.670    52.102     0.150
     1.888    31.172     0.150
     1.888    56.871     0.150
     1.888    54.504     0.150
     1.828    32.465     0.150
     1.828    55.922     0.150
     1.939    31.613     0.150
     1.939    53.672     0.150
     1.904    32.742     0.150
     1.904    57.984     0.150
     1.981    32.555     0.150
     1.981    58.371     0.150
     1.981    57.414     0.150
     2.574    42.414     0.150
     2.574    74.812     0.150
     3.198    49.633     0.150
     3.198    86.684     0.150
     3.198    88.234     0.150
     3.642    56.672     0.150
     3.642   100.531     0.150
     3.685    57.055     0.150
     3.685    98.812     0.150
     4.011    63.434     0.150
     4.011   110.281     0.150
     4.372    86.961     0.150
     4.372   151.086     0.150
     4.843    73.543     0.150
     4.843   129.582     0.150
     7.938   116.988     0.150
     7.938   255.387     0.150
     8.772   127.645     0.150
     8.772   270.031     0.150
    40.567   463.043     0.150
     0.478     9.531     0.150
     0.478    15.344     0.150
     0.847    16.004     0.150
     0.847    27.562     0.150
     1.027    19.043     0.150
     1.027    33.812     0.150
     1.590    27.102     0.150
     1.590    47.305     0.150
     1.529    26.965     0.150
     1.529    47.102     0.150
     1.603    29.902     0.150
     1.603    52.742     0.150
     1.835    30.902     0.150
     1.835    53.633     0.150
     1.893    32.043     0.150
     1.893    55.762     0.150
     1.893    32.184     0.150
     1.744    32.332     0.150
     1.744    56.215     0.150
     1.928    31.953     0.150
     1.928    56.922     0.150
     1.928    59.672     0.150
     1.998    32.023     0.150
     1.998    62.621     0.150
     1.853    33.312     0.150
     1.853    59.043     0.150
     2.644    44.523     0.150
     2.644    78.031     0.150
     3.207    85.984     0.150
     3.670    57.441     0.150
     3.670    98.633     0.150
     3.785    60.613     0.150
     3.785   104.832     0.150
     3.769    59.371     0.150
     3.769   106.633     0.150
     0.507    10.129     0.150
     0.507    16.590     0.150
     0.859    16.941     0.150
     0.859    28.168     0.150
     0.859    28.898     0.150
     0.992    18.641     0.150
     0.992    31.871     0.150
     1.490    26.629     0.150
     1.490    46.809     0.150
     1.564    27.281     0.150
     1.564    47.570     0.150
     1.604    29.379     0.150
     1.604    50.449     0.150
     1.807    30.910     0.150
     1.807    55.469     0.150
     1.769    31.379     0.150
     1.769    55.141     0.150
     1.836    32.551     0.150
     1.836    56.711     0.150
     1.902    32.441     0.150
     1.902    32.941     0.150
     1.902    56.941     0.150
     1.948    33.301     0.150
     1.948    58.359     0.150
     1.948    32.559     0.150
     1.948    57.949     0.150
     1.995    32.359     0.150
     1.995    61.109     0.150
     2.619    43.609     0.150
     2.619    76.781     0.150
     3.194    51.488     0.150
     3.194    90.520     0.150
     3.194    52.930     0.150
     3.194    92.801     0.150
     3.632    56.289     0.150
     3.632    98.809     0.150
     3.749    58.898     0.150
     3.749   104.301     0.150
     3.742    59.141     0.150
     3.742   105.508     0.150
     3.795    60.031     0.150
     3.795   104.891     0.150
     0.473     9.445     0.150
     0.473    15.891     0.150
     0.822    15.734     0.150
     0.822    27.477     0.150
     1.044    19.164     0.150
     1.044    33.672     0.150
     1.555    26.812     0.150
     1.555    47.438     0.150
     1.584    28.594     0.150
     1.584    50.508     0.150
     1.622    27.258     0.150
     1.622    47.672     0.150
     1.713    30.695     0.150
     1.713    53.234     0.150
     1.867    30.922     0.150
     1.849    32.992     0.150
     1.849    57.172     0.150
     1.906    32.008     0.150
     1.906    57.406     0.150
     1.906    32.227     0.150
     1.931    31.891     0.150
     1.931    57.102     0.150
     1.931    32.227     0.150
     1.931    60.641     0.150
     2.018    32.016     0.150
     2.648    44.188     0.150
     2.648    76.984     0.150
     2.648    68.922     0.150
     3.200    52.141     0.150
     3.200    90.453     0.150
     3.200    52.820     0.150
     3.200    89.375     0.150
     3.700    57.477     0.150
     3.700    96.016     0.150
     3.775    58.992     0.150
     3.775   104.742     0.150
     3.775   112.094     0.150
     3.802    59.344     0.150
     3.802   105.867     0.150
     3.802    61.672     0.150
     3.802   105.422     0.150
     4.460    86.336     0.150
     4.460   148.281     0.150
     4.750    75.188     0.150
     4.750   127.523     0.150
     5.153    79.164     0.150
     5.153   132.586     0.150
     8.154   120.406     0.150
     8.154   260.633     0.150
     8.902   131.688     0.150
     8.902   277.211     0.150
     9.429   141.508     0.150
    13.473   197.516     0.150
     0.584    11.477     0.150
     0.584    19.387     0.150
     0.904    16.646     0.150
     0.904    29.697     0.150
     0.935    17.467     0.150
     0.935    29.727     0.150
     0.935    29.906     0.150
     1.376    23.996     0.150
     1.376    42.227     0.150
     1.463    26.297     0.150
     1.463    45.688     0.150
     1.701    28.008     0.150
     1.701    50.236     0.150
     1.648    29.297     0.150
     1.648    50.996     0.150
     1.818    31.857     0.150
     1.818    55.396     0.150
     1.900    31.178     0.150
     1.900    54.406     0.150
     1.959    30.996     0.150
     1.959    54.156     0.150
     1.983    32.627     0.150
     1.983    57.787     0.150
     1.983    57.076     0.150
     2.573    40.896     0.150
     2.573    69.197     0.150
     2.860    47.326     0.150
     2.860    81.027     0.150
     3.186    49.268     0.150
     3.186    87.098     0.150
     3.509    52.457     0.150
     3.509    93.637     0.150
     3.656    54.326     0.150
     3.656    92.727     0.150
     3.687    56.678     0.150
     3.687   100.377     0.150
     4.394    74.227     0.150
     4.394    89.102     0.150
     5.012    74.246     0.150
     5.012   131.088     0.150
     7.964   116.852     0.150
     7.964   246.551     0.150
     8.781   128.357     0.150
     8.781   268.715     0.150
    10.919   161.332     0.150
    13.300   194.152     0.150
    21.424   290.602     0.150
     0.571    11.172     0.150
     0.571    19.477     0.150
     0.883    15.938     0.150
     0.883    27.438     0.150
     0.883    16.977     0.150
     0.883    27.227     0.150
     0.921    16.508     0.150
     0.921    28.508     0.150
     1.413    23.938     0.150
     1.413    42.898     0.150
     1.519    24.102     0.150
     1.519    44.883     0.150
     1.604    52.852     0.150
     1.758    27.812     0.150
     1.799    33.031     0.150
     1.799    56.758     0.150
     1.926    30.633     0.150
     1.926    54.422     0.150
     1.993    32.812     0.150
     1.993    59.680     0.150
     1.993    31.922     0.150
     1.993    55.562     0.150
     1.998    30.031     0.150
     1.998    53.961     0.150
     2.281    35.609     0.150
     2.356    36.359     0.150
     2.567    40.289     0.150
     2.567    39.188     0.150
     2.567    70.547     0.150
     2.868    44.508     0.150
     2.868    75.742     0.150
     2.719    43.562     0.150
     2.945    45.594     0.150
     3.163    48.219     0.150
     3.163    84.281     0.150
     3.356    50.938     0.150
     3.383    51.609     0.150
     3.557    54.703     0.150
     3.557    54.133     0.150
     3.557    94.664     0.150
     3.677    97.477     0.150
     3.686    56.703     0.150
     3.686   101.531     0.150
     3.799    55.844     0.150
     3.979    59.977     0.150
     4.096    61.664     0.150
     4.160    62.891     0.150
     4.187    62.742     0.150
     4.154    63.500     0.150
     4.435    66.789     0.150
     4.435    84.492     0.150
     4.435   148.641     0.150
     4.490    67.609     0.150
     4.479    68.094     0.150
     4.533    66.992     0.150
     4.836    73.273     0.150
     4.989    74.727     0.150
     5.031    76.172     0.150
     5.031   130.477     0.150
     5.271    77.281     0.150
     5.299    79.789     0.150
     5.361    80.539     0.150
     5.595    84.938     0.150
     5.595   144.844     0.150
     5.705    84.922     0.150
     5.697    84.719     0.150
     5.783    85.914     0.150
     5.919    91.680     0.150
     5.919   156.133     0.150
     6.028    90.062     0.150
     7.082   104.344     0.150
     7.225   105.617     0.150
     7.204   105.203     0.150
     7.638   112.461     0.150
     8.010   116.492     0.150
     8.010   257.664     0.150
     8.010   116.617     0.150
     8.792   124.773     0.150
     8.792   272.047     0.150
     8.792   128.070     0.150
     9.385   139.547     0.150
    10.204   147.727     0.150
    10.679   154.422     0.150
    10.973   159.094     0.150
    10.950   157.844     0.150
    13.357   192.742     0.150
    13.929   201.445     0.150
    14.990   216.844     0.150
    15.003   216.750     0.150
    15.101   217.781     0.150
    15.122   218.109     0.150
    15.197   214.898     0.150
    15.844   226.859     0.150
    16.685   234.398     0.150
    17.136   239.758     0.150
    17.468   243.812     0.150
    18.606   259.625     0.150
    18.606   256.828     0.150
    20.019   272.047     0.150
    22.601   300.891     0.150
    23.442   307.891     0.150
    24.455   319.344     0.150
    24.531   319.102     0.150
    24.967   323.664     0.150
    30.904   375.000     0.150
    37.840   435.602     0.150
    38.988   444.992     0.150
    40.639   461.867     0.150
    40.700   459.688     0.150
    41.892   469.250     0.150
    43.629   484.758     0.150
    45.164   496.992     0.150
    75.347   702.031     0.150
    79.063   725.336     0.150
    83.412   747.320     0.150
    83.412   748.211     0.150
    85.021   754.633     0.150
    84.980   755.047     0.150
    85.615   759.070     0.150
    98.126   815.867     0.150
     0.541    10.531     0.150
     0.541    19.109     0.150
     0.947    29.969     0.150
     0.950    17.781     0.150
     0.950    31.352     0.150
     0.950    18.805     0.150
     1.411    24.023     0.150
     1.459    23.766     0.150
     1.700    28.273     0.150
     1.700    48.750     0.150
     1.700    29.164     0.150
     1.675    29.695     0.150
     1.675    52.836     0.150
     1.861    30.891     0.150
     1.861    55.172     0.150
     1.861    32.086     0.150
     1.861    55.391     0.150
     1.859    31.891     0.150
     1.859    56.516     0.150
     1.875    32.859     0.150
     1.875    58.789     0.150
     1.928    32.750     0.150
     1.928    55.531     0.150
     1.940    33.133     0.150
     1.940    56.672     0.150
     1.940    32.734     0.150
     1.940    57.070     0.150
     2.234    37.312     0.150
     2.291    37.781     0.150
     2.616    44.781     0.150
     2.616    42.250     0.150
     2.616    74.984     0.150
     2.652    45.148     0.150
     2.882    45.680     0.150
     2.887    46.523     0.150
     2.887    85.125     0.150
     2.887    48.336     0.150
     2.887    49.484     0.150
     3.173    49.016     0.150
     3.226    49.922     0.150
     3.226    89.125     0.150
     3.226    50.945     0.150
     3.226    96.633     0.150
     3.287    51.453     0.150
     3.463    52.953     0.150
     3.463    53.352     0.150
     3.463    93.289     0.150
     3.535    55.492     0.150
     3.535    52.555     0.150
     3.535    95.805     0.150
     3.554    57.375     0.150
     3.554    98.109     0.150
     3.698    57.414     0.150
     3.698   100.320     0.150
     3.731    56.812     0.150
     3.731    58.414     0.150
     3.912    59.250     0.150
     4.025    61.555     0.150
     4.039    61.820     0.150
     4.039   114.352     0.150
     4.102    62.516     0.150
     4.118    64.375     0.150
     4.365    66.625     0.150
     4.365    75.648     0.150
     4.365    86.109     0.150
     4.405    66.781     0.150
     4.441    66.859     0.150
     4.404    67.266     0.150
     4.404   121.273     0.150
     4.464    71.586     0.150
     4.825    74.562     0.150
     4.847    73.719     0.150
     4.847   132.430     0.150
     4.943    74.672     0.150
     5.207    78.875     0.150
     5.242    80.086     0.150
     5.337    80.633     0.150
     5.654    86.031     0.150
     5.662    85.203     0.150
     5.780    86.148     0.150
     5.963    90.711     0.150
     5.979    89.820     0.150
     5.985    88.664     0.150
     5.985   155.891     0.150
     6.537    97.641     0.150
     6.651    99.453     0.150
     6.708    99.664     0.150
     6.734   101.148     0.150
     6.741   101.234     0.150
     6.904   103.602     0.150
     7.069   103.641     0.150
     7.129   104.969     0.150
     7.165   105.539     0.150
     7.190   105.789     0.150
     7.453   111.281     0.150
     7.565   110.945     0.150
     7.727   117.930     0.150
     7.950   116.500     0.150
     7.992   118.164     0.150
     8.357   121.586     0.150
     8.407   123.195     0.150
     8.489   123.172     0.150
     8.538   123.086     0.150
     8.538   129.391     0.150
     8.635   125.891     0.150
     8.660   126.672     0.150
     8.674   127.336     0.150
     8.794   129.266     0.150
     8.824   129.266     0.150
     8.824   273.820     0.150
     9.314   141.445     0.150
     9.314   138.461     0.150
     9.610   139.875     0.150
     9.807   143.234     0.150
     9.818   143.414     0.150
    10.063   146.570     0.150
    10.874   160.961     0.150
    10.907   161.719     0.150
    10.907   347.570     0.150
    10.907   156.430     0.150
    10.917   157.305     0.150
    10.958   157.484     0.150
    11.330   163.398     0.150
    11.381   168.219     0.150
    11.952   176.805     0.150
    13.303   193.492     0.150
    13.580   194.539     0.150
    13.610   194.039     0.150
    13.668   193.891     0.150
    15.284   216.859     0.150
    15.487   218.562     0.150
    15.570   223.750     0.150
    16.700   234.961     0.150
    16.926   236.211     0.150
    16.928   240.734     0.150
    16.944   239.164     0.150
    16.987   237.031     0.150
    17.088   237.148     0.150
    17.717   250.914     0.150
    18.312   256.086     0.150
    18.418   256.000     0.150
    18.539   256.555     0.150
    18.539   261.719     0.150
    18.889   271.633     0.150
    19.447   271.469     0.150
    20.362   280.109     0.150
    21.465   292.188     0.150
    21.550   291.602     0.150
    21.585   293.234     0.150
    21.786   294.852     0.150
    21.865   293.141     0.150
    22.606   302.805     0.150
    22.606   304.984     0.150
    22.962   309.469     0.150
    23.675   314.961     0.150
    23.803   317.539     0.150
    24.034   318.094     0.150
    24.127   319.602     0.150
    24.187   318.266     0.150
    24.187   322.023     0.150
    24.225   319.664     0.150
    24.249   318.781     0.150
    24.299   320.789     0.150
    24.415   322.594     0.150
    24.415   321.133     0.150
    24.539   324.180     0.150
    24.658   322.031     0.150
    24.930   325.211     0.150
    25.120   327.133     0.150
    25.509   331.891     0.150
    25.518   331.836     0.150
    25.826   334.680     0.150
    25.985   337.844     0.150
    26.005   334.562     0.150
    26.109   336.922     0.150
    26.248   340.664     0.150
    26.475   340.742     0.150
    26.663   341.484     0.150
    27.011   344.742     0.150
    27.127   346.930     0.150
    27.471   349.164     0.150
    27.733   350.961     0.150
    27.790   351.898     0.150
    27.838   353.812     0.150
    27.916   354.250     0.150
    27.962   351.664     0.150
    28.889   363.672     0.150
    28.992   363.930     0.150
    29.072   364.789     0.150
    29.389   366.672     0.150
    29.423   366.969     0.150
    31.022   380.500     0.150
    31.096   382.719     0.150
    31.846   388.250     0.150
    31.880   388.055     0.150
    32.013   390.203     0.150
    32.395   392.961     0.150
    32.628   397.461     0.150
    32.686   396.883     0.150
    33.376   402.539     0.150
    33.549   403.836     0.150
    37.770   440.820     0.150
    37.984   439.312     0.150
    39.111   452.289     0.150
    40.569   464.344     0.150
    40.569   463.070     0.150
    41.488   470.961     0.150
    41.822   475.016     0.150
    43.559   488.000     0.150
    44.717   498.148     0.150
    46.873   512.555     0.150
    52.421   558.320     0.150
    68.938   670.164     0.150
    80.867   740.367     0.150
    84.960   761.094     0.150
    97.370   819.328     0.150
     0.586    11.429     0.150
     0.586    19.799     0.150
     0.902    16.519     0.150
     0.902    28.469     0.150
     0.937    16.789     0.150
     0.937    28.989     0.150
     0.937    17.669     0.150
     0.937    30.689     0.150
     1.373    24.159     0.150
     1.373    42.309     0.150
     1.461    25.039     0.150
     1.461    44.489     0.150
     1.698    28.159     0.150
     1.698    50.539     0.150
     1.649    53.859     0.150
     1.818    32.589     0.150
     1.818    55.979     0.150
     1.900    31.069     0.150
     1.900    31.219     0.150
     1.900    53.609     0.150
     1.958    30.579     0.150
     1.958    54.049     0.150
     1.984    32.399     0.150
     1.984    57.539     0.150
     1.984    31.079     0.150
     1.984    54.419     0.150
     3.186    48.739     0.150
     3.186    86.549     0.150
     3.499    51.979     0.150
     3.499    94.639     0.150
     3.506    51.959     0.150
     3.506    94.029     0.150
     3.685    56.249     0.150
     3.685    99.979     0.150
     0.731    14.229     0.150
     1.162    21.469     0.150
     1.162    35.197     0.150
     1.162    21.018     0.150
     1.453    26.268     0.150
     1.825    33.629     0.150
     1.825    56.607     0.150
     1.887    36.049     0.150
     1.887    60.938     0.150
     1.831    33.998     0.150
     1.831    58.879     0.150
     2.001    35.898     0.150
     2.001    62.098     0.150
     2.001    35.598     0.150
     2.001    60.488     0.150
     1.969    33.469     0.150
     2.255    37.039     0.150
     2.572    46.229     0.150
     2.572    79.549     0.150
     2.572    39.688     0.150
     2.572    44.338     0.150
     2.572    74.979     0.150
     2.654    42.518     0.150
     2.715    43.469     0.150
     2.596    43.928     0.150
     3.033    51.299     0.150
     3.033    87.568     0.150
     3.033    50.408     0.150
     3.033    81.639     0.150
     3.266    53.889     0.150
     3.266    91.258     0.150
     3.266    54.129     0.150
     3.266    90.648     0.150
     3.143    49.129     0.150
     3.108    49.508     0.150
     3.203    50.658     0.150
     3.276    51.818     0.150
     3.276    96.789     0.150
     3.406    53.748     0.150
     3.406    56.518     0.150
     3.406    98.018     0.150
     3.533    58.027     0.150
     3.533   101.168     0.150
     3.660    62.908     0.150
     3.660   104.438     0.150
     3.654    57.008     0.150
     3.710    58.277     0.150
     3.786    59.428     0.150
     3.862    60.309     0.150
     3.854    61.059     0.150
     3.947    60.979     0.150
     4.075    66.107     0.150
     4.075   115.688     0.150
     4.039    62.568     0.150
     4.173    64.158     0.150
     4.234    65.447     0.150
     4.243    65.527     0.150
     4.243   140.873     0.150
     4.237    66.178     0.150
     4.292    66.418     0.150
     4.543    72.908     0.150
     4.372    67.459     0.150
     4.372    67.459     0.150
     4.582    70.098     0.150
     4.683    71.738     0.150
     4.720    72.428     0.150
     4.753    73.008     0.150
     4.786    72.658     0.150
     4.991    78.959     0.150
     4.991   136.008     0.150
     4.894    77.258     0.150
     4.894   136.348     0.150
     4.981    76.979     0.150
     4.993    77.418     0.150
     5.175    78.998     0.150
     5.352    81.688     0.150
     5.663    85.258     0.150
     5.663   151.168     0.150
     7.737   253.947     0.150
     8.694   280.354     0.150
     9.156   298.678     0.150
    13.047   426.027     0.150
    14.816   211.258     0.150
    14.846   211.059     0.150
    14.842   211.898     0.150
    14.943   212.709     0.150
    14.979   209.979     0.150
    14.999   210.348     0.150
    15.002   210.789     0.150
    15.069   212.539     0.150
    15.177   213.248     0.150
    15.261   214.479     0.150
    15.272   214.418     0.150
    15.369   216.289     0.150
    15.463   216.479     0.150
    15.726   220.938     0.150
    16.032   224.438     0.150
    16.743   232.959     0.150
    16.749   233.617     0.150
    21.473   294.697     0.150
    85.508   763.777     0.150
    94.490   806.988     0.150
     0.548    10.834     0.150
     0.548    17.795     0.150
     0.930    18.455     0.150
     0.930    30.285     0.150
     0.940    18.225     0.150
     0.940    31.205     0.150
     1.412    25.404     0.150
     1.412    44.744     0.150
     1.477    25.125     0.150
     1.477    45.674     0.150
     1.654    29.514     0.150
     1.654    51.725     0.150
     1.717    28.875     0.150
     1.717    52.125     0.150
     1.717    29.094     0.150
     1.842    31.555     0.150
     1.842    57.625     0.150
     1.880    31.625     0.150
     1.880    55.744     0.150
     1.880    31.834     0.150
     1.880    54.125     0.150
     1.955    32.934     0.150
     1.955    57.865     0.150
     1.955    33.184     0.150
     1.955    56.664     0.150
     1.955    58.854     0.150
     1.948    31.404     0.150
     1.948    54.564     0.150
     2.248    35.875     0.150
     2.310    37.814     0.150
     2.602    43.594     0.150
     2.602    75.555     0.150
     2.602    40.264     0.150
     2.602    71.354     0.150
     2.671    45.615     0.150
     2.870    46.885     0.150
     2.901    45.475     0.150
     3.191    50.295     0.150
     3.208    51.035     0.150
     3.208    87.895     0.150
     3.208    50.104     0.150
     3.208    86.145     0.150
     3.308    51.994     0.150
     3.333    52.795     0.150
     3.483    54.854     0.150
     3.483    53.965     0.150
     3.483    94.734     0.150
     3.542    53.064     0.150
     3.542    52.564     0.150
     3.542    92.055     0.150
     3.750    58.814     0.150
     3.858    59.654     0.150
     3.932    61.145     0.150
     4.046    62.314     0.150
     4.120    63.414     0.150
     4.138    63.584     0.150
     4.380    67.523     0.150
     4.385    67.865     0.150
     4.385    85.549     0.150
     4.385   148.049     0.150
     4.426    67.584     0.150
     4.441    68.244     0.150
     4.453    66.734     0.150
     4.484    68.693     0.150
     4.541    69.725     0.150
     4.830    74.395     0.150
     4.947    75.184     0.150
     4.957    75.455     0.150
     5.226    78.354     0.150
     5.260    79.164     0.150
     5.670    86.254     0.150
     5.673    86.154     0.150
     5.980    92.154     0.150
     5.994    91.145     0.150
     6.668    99.814     0.150
     6.728   100.805     0.150
     6.755   102.604     0.150
     6.925   105.725     0.150
     7.074   103.654     0.150
     7.148   106.854     0.150
     7.183   107.434     0.150
     7.195   104.885     0.150
     7.998   117.148     0.150
     7.998   209.023     0.150
     7.998   252.648     0.150
     8.816   130.154     0.150
     8.816   272.178     0.150
     9.335   141.154     0.150
    10.927   161.104     0.150
    13.320   194.654     0.150
    13.320   429.797     0.150
    15.031   212.045     0.150
    15.060   213.764     0.150
    15.081   213.645     0.150
    15.105   213.924     0.150
    15.225   220.475     0.150
    15.303   220.354     0.150
    15.501   220.715     0.150
    15.645   220.693     0.150
    15.690   223.094     0.150
    16.258   228.574     0.150
    16.370   229.254     0.150
    16.636   235.104     0.150
    18.559   260.898     0.150
    18.559   256.875     0.150
    20.553   279.584     0.150
    23.346   306.764     0.150
    24.427   320.080     0.150
    24.427   317.305     0.150
    26.264   334.564     0.150
    65.880   647.922     0.150
     0.555    11.039     0.150
     0.555    18.359     0.150
     0.935    17.010     0.150
     0.935    30.061     0.150
     0.971    18.020     0.150
     0.971    30.650     0.150
     0.971    17.660     0.150
     0.971    30.410     0.150
     1.391    24.510     0.150
     1.391    43.061     0.150
     1.435    25.250     0.150
     1.435    44.141     0.150
     1.675    29.561     0.150
     1.675    49.410     0.150
     1.690    29.680     0.150
     1.690    51.500     0.150
     1.856    31.990     0.150
     1.856    56.189     0.150
     1.856    30.480     0.150
     1.862    32.260     0.150
     1.862    56.160     0.150
     1.916    30.449     0.150
     1.916    53.859     0.150
     1.943    33.051     0.150
     1.943    58.689     0.150
     1.943    30.391     0.150
     1.943    54.320     0.150
     2.612    43.029     0.150
     2.612    75.859     0.150
     2.612    38.801     0.150
     2.782    42.900     0.150
     2.782    75.590     0.150
     2.902    45.770     0.150
     2.902    82.000     0.150
     3.230    51.061     0.150
     3.230    89.650     0.150
     3.230    50.289     0.150
     3.230    88.420     0.150
     3.455    53.279     0.150
     3.455    92.561     0.150
     3.510    54.740     0.150
     3.510    94.789     0.150
     3.725    58.320     0.150
     3.725   102.230     0.150
     4.351    74.334     0.150
     7.968   117.359     0.150
     8.813   125.029     0.150
     8.813   263.230     0.150
     9.297   311.189     0.150
    13.278   432.564     0.150
     0.553    11.029     0.150
     0.553    18.238     0.150
     0.935    31.250     0.150
     0.939    17.449     0.150
     0.939    29.648     0.150
     0.939    18.789     0.150
     0.939    31.279     0.150
     1.404    25.170     0.150
     1.404    44.209     0.150
     1.467    26.439     0.150
     1.660    29.979     0.150
     1.660    51.889     0.150
     1.707    29.930     0.150
     1.707    53.289     0.150
     1.843    32.029     0.150
     1.843    56.898     0.150
     1.877    32.469     0.150
     1.877    57.090     0.150
     1.877    32.580     0.150
     1.877    55.770     0.150
     1.943    32.219     0.150
     1.943    56.459     0.150
     1.955    33.840     0.150
     1.955    58.889     0.150
     1.955    33.709     0.150
     1.955    58.568     0.150
     2.238    37.670     0.150
     2.307    38.100     0.150
     2.601    42.238     0.150
     2.601    39.920     0.150
     2.601    68.920     0.150
     2.812    44.830     0.150
     2.812    84.959     0.150
     2.668    45.318     0.150
     2.872    46.859     0.150
     2.872    45.699     0.150
     2.872    45.279     0.150
     2.872    78.850     0.150
     2.864    45.459     0.150
     2.891    46.648     0.150
     3.210    51.469     0.150
     3.210    50.350     0.150
     3.210    85.109     0.150
     3.189    50.068     0.150
     3.300    51.309     0.150
     3.328    51.629     0.150
     3.479    53.389     0.150
     3.479    55.539     0.150
     3.479    95.590     0.150
     3.532    54.850     0.150
     3.532    56.408     0.150
     3.532    97.250     0.150
     3.686    55.580     0.150
     3.686    95.818     0.150
     3.716    59.238     0.150
     3.716   104.119     0.150
     3.746    57.789     0.150
     3.855    59.000     0.150
     3.924    60.020     0.150
     4.039    61.719     0.150
     4.110    62.898     0.150
     4.150    63.609     0.150
     4.134    63.020     0.150
     4.374    66.670     0.150
     4.380    66.979     0.150
     4.380    68.088     0.150
     4.380    83.783     0.150
     4.443    67.789     0.150
     4.420    66.959     0.150
     4.433    67.260     0.150
     4.479    67.879     0.150
     4.535    68.709     0.150
     4.820    72.949     0.150
     4.824    73.080     0.150
     4.889    73.398     0.150
     4.947    74.830     0.150
     4.938    74.689     0.150
     4.948    74.670     0.150
     5.042    79.000     0.150
     5.042   134.189     0.150
     5.217    78.469     0.150
     5.250    78.850     0.150
     5.335    80.100     0.150
     5.316    79.260     0.150
     5.467    81.369     0.150
     5.639    85.039     0.150
     5.639   142.859     0.150
     5.663    84.238     0.150
     5.660    84.350     0.150
     5.667    83.510     0.150
     5.698    84.039     0.150
     5.799    85.510     0.150
     5.970    91.100     0.150
     5.984    91.309     0.150
     5.993    89.898     0.150
     7.989   118.855     0.150
     7.989   209.789     0.150
     7.989   249.414     0.150
     8.811   130.055     0.150
     8.811   269.334     0.150
     9.328   138.715     0.150
    10.918   160.773     0.150
    10.918   347.973     0.150
    13.310   191.756     0.150
    13.310   420.010     0.150
    13.873   199.477     0.150
    14.951   210.850     0.150
    14.995   210.408     0.150
    15.021   211.939     0.150
    15.050   212.170     0.150
    15.072   213.059     0.150
    15.095   213.539     0.150
    15.161   213.580     0.150
    15.192   214.389     0.150
    15.220   214.799     0.150
    15.217   214.148     0.150
    15.250   215.158     0.150
    15.295   215.580     0.150
    15.401   216.959     0.150
    15.459   217.350     0.150
    15.474   218.330     0.150
    15.493   217.869     0.150
    15.495   218.029     0.150
    15.558   219.129     0.150
    15.544   218.760     0.150
    15.631   220.199     0.150
    15.636   220.139     0.150
    15.682   220.979     0.150
    16.250   228.318     0.150
    16.324   229.119     0.150
    16.253   229.830     0.150
    16.629   233.000     0.150
    17.623   245.148     0.150
    17.708   247.039     0.150
    18.551   258.574     0.150
    19.130   263.430     0.150
    19.446   266.029     0.150
    21.449   287.445     0.150
    22.598   300.760     0.150
    24.240   317.148     0.150
    24.417   319.383     0.150
    24.417   318.580     0.150
    24.692   321.539     0.150
    28.985   359.389     0.150
    31.518   382.068     0.150
    40.583   463.154     0.150
    40.852   461.119     0.150
    65.876   647.873     0.150
    76.568   713.143     0.150
    76.568   710.738     0.150
    84.957   758.434     0.150
    84.957   754.318     0.150
    85.566   760.879     0.150
    85.566   758.250     0.150
    97.380   814.543     0.150
    98.071   815.369     0.150
   144.356  1178.049     0.150
     0.578    11.488     0.150
     0.578    19.148     0.150
     0.898    17.699     0.150
     0.898    29.707     0.150
     0.898    17.480     0.150
     0.898    29.109     0.150
     0.911    16.957     0.150
     0.911    30.008     0.150
     1.398    24.551     0.150
     1.398    44.379     0.150
     1.501    27.188     0.150
     1.501    47.641     0.150
     1.616    29.777     0.150
     1.616    51.738     0.150
     1.739    31.660     0.150
     1.739    53.730     0.150
     1.802    32.418     0.150
     1.802    56.891     0.150
     1.920    31.668     0.150
     1.920    59.859     0.150
     1.920    31.348     0.150
     1.920    54.680     0.150
     1.988    30.730     0.150
     1.993    34.801     0.150
     1.993    61.449     0.150
     1.993    32.648     0.150
     1.993    56.148     0.150
     2.565    43.641     0.150
     2.565    76.129     0.150
     2.565    49.438     0.150
     2.565    71.301     0.150
     3.523    53.609     0.150
     3.523    92.969     0.150
     3.539    53.219     0.150
     3.539    94.848     0.150
     3.614    54.188     0.150
     3.614   100.809     0.150
     3.682    56.867     0.150
     0.566    11.133     0.150
     0.566    19.152     0.150
     0.901    17.383     0.150
     0.901    29.395     0.150
     0.901    17.125     0.150
     0.923    17.465     0.150
     0.923    30.305     0.150
     1.408    24.934     0.150
     1.408    43.812     0.150
     1.502    25.824     0.150
     1.502    45.113     0.150
     1.622    30.973     0.150
     1.622    52.094     0.150
     1.740    29.555     0.150
     1.740    52.094     0.150
     1.811    32.035     0.150
     1.811    55.984     0.150
     1.811    59.465     0.150
     1.911    32.035     0.150
     1.911    57.293     0.150
     1.981    31.652     0.150
     1.982    32.984     0.150
     1.982    58.535     0.150
     1.982    57.223     0.150
     2.576    43.023     0.150
     2.834    48.074     0.150
     3.177    50.652     0.150
     3.515    56.355     0.150
     3.547    55.254     0.150
     3.606    56.793     0.150
     3.693    59.215     0.150
     3.693   103.355     0.150
     4.418    70.406     0.150
     4.418    86.312     0.150
     4.418   125.973     0.150
     4.418   149.051     0.150
     8.001   118.609     0.150
     8.001   258.594     0.150
     8.796   130.258     0.150
     8.796   269.234     0.150
     9.366   141.660     0.150
     9.366   305.387     0.150
    10.955   163.020     0.150
    10.955   355.523     0.150
    13.341   194.273     0.150
    13.341   432.699     0.150
    18.588   261.105     0.150
    24.441   321.859     0.150
    40.621   462.957     0.150
     0.595    11.703     0.150
     0.595    20.109     0.150
     0.893    16.602     0.150
     0.893    29.312     0.150
     0.914    17.781     0.150
     0.914    16.867     0.150
     0.914    28.773     0.150
     1.374    23.672     0.150
     1.374    41.844     0.150
     1.482    25.039     0.150
     1.482    44.102     0.150
     1.625    29.000     0.150
     1.625    51.609     0.150
     1.718    28.844     0.150
     1.718    51.852     0.150
     1.718    28.680     0.150
     1.798    31.078     0.150
     1.798    55.609     0.150
     1.921    32.281     0.150
     1.921    32.062     0.150
     1.921    53.852     0.150
     2.001    33.062     0.150
     2.001    58.773     0.150
     2.001    32.773     0.150
     2.001    56.961     0.150
     2.239    36.281     0.150
     2.350    37.430     0.150
     2.555    43.203     0.150
     2.555    74.359     0.150
     2.555    70.680     0.150
     2.555    41.000     0.150
     2.555    40.289     0.150
     2.846    79.930     0.150
     2.710    44.258     0.150
     2.909    46.008     0.150
     2.838    46.633     0.150
     2.838    83.117     0.150
     2.838    46.781     0.150
     2.838    81.500     0.150
     3.165    49.938     0.150
     3.165    90.109     0.150
     3.165    50.984     0.150
     3.232    51.289     0.150
     3.328    52.031     0.150
     3.366    53.117     0.150
     3.521    55.758     0.150
     3.521    98.391     0.150
     3.521    53.680     0.150
     3.514    55.297     0.150
     3.514    93.180     0.150
     3.514    54.250     0.150
     3.611    55.578     0.150
     3.611    95.602     0.150
     3.647    56.680     0.150
     3.647   101.617     0.150
     3.671    58.289     0.150
     3.671   101.828     0.150
     3.787    58.023     0.150
     3.897    60.891     0.150
     3.947    61.289     0.150
     3.979    62.820     0.150
     3.979   112.383     0.150
     4.070    62.961     0.150
     4.120    63.781     0.150
     4.117    63.984     0.150
     4.174    64.062     0.150
     4.410    66.523     0.150
     4.416    67.602     0.150
     4.416    67.070     0.150
     4.416    70.883     0.150
     4.416    87.258     0.150
     4.416   115.883     0.150
     4.416   142.461     0.150
     4.436    67.930     0.150
     4.461    67.859     0.150
     4.519    70.617     0.150
     4.568    69.523     0.150
     4.795    73.070     0.150
     4.860    73.109     0.150
     4.946    74.844     0.150
     4.976    74.000     0.150
     5.235    78.062     0.150
     5.239    77.344     0.150
     5.260    80.203     0.150
     5.318    80.617     0.150
     5.654    84.641     0.150
     5.663    86.719     0.150
     5.707    85.484     0.150
     5.738    87.891     0.150
     5.744    85.914     0.150
     5.979    90.273     0.150
     5.986    90.969     0.150
     6.026    90.930     0.150
     6.298    94.172     0.150
     6.403    96.578     0.150
     6.425    97.359     0.150
     6.437    96.641     0.150
     6.531    96.594     0.150
     6.667   100.867     0.150
     6.720   100.828     0.150
     6.744    99.969     0.150
     6.783   100.141     0.150
     6.952   102.180     0.150
     7.041   104.359     0.150
     7.153   106.250     0.150
     7.163   106.328     0.150
     7.186   107.633     0.150
     7.609   112.914     0.150
     7.685   114.648     0.150
     7.742   114.141     0.150
     7.968   117.008     0.150
     7.968   204.406     0.150
     7.968   250.406     0.150
     8.653   127.312     0.150
     8.748   128.773     0.150
     8.769   128.242     0.150
     8.769   271.312     0.150
     8.769   129.594     0.150
     9.360   138.812     0.150
     9.360   176.367     0.150
    10.168   148.328     0.150
    10.423   152.062     0.150
    10.940   161.391     0.150
    10.940   351.641     0.150
    10.928   158.781     0.150
    11.346   163.781     0.150
    11.535   168.070     0.150
    13.316   193.539     0.150
    13.316   425.188     0.150
    13.316   192.703     0.150
    14.193   203.281     0.150
    15.241   215.062     0.150
    15.576   225.938     0.150
    15.644   223.914     0.150
    15.674   219.500     0.150
    17.461   245.570     0.150
    18.573   259.461     0.150
    20.562   281.094     0.150
    21.521   290.898     0.150
    21.624   291.453     0.150
    22.246   299.180     0.150
    22.565   300.297     0.150
    23.094   307.648     0.150
    23.353   310.562     0.150
    24.412   320.367     0.150
    24.412   319.602     0.150
    24.924   325.047     0.150
    40.614   463.844     0.150
    40.614   461.492     0.150
    43.605   486.930     0.150
    43.826   488.148     0.150
    84.937   758.312     0.150
    85.610   761.867     0.150
    85.610   760.492     0.150
    86.593   765.992     0.150
    98.108   819.391     0.150
     0.564    11.062     0.150
     0.564    18.797     0.150
     0.925    17.539     0.150
     0.925    30.273     0.150
     0.911    17.469     0.150
     0.911    31.273     0.150
     0.911    18.797     0.150
     0.911    30.992     0.150
     1.406    24.727     0.150
     1.406    43.148     0.150
     1.492    25.578     0.150
     1.492    45.039     0.150
     1.632    28.969     0.150
     1.632    52.711     0.150
     1.731    29.289     0.150
     1.731    51.539     0.150
     1.819    31.297     0.150
     1.819    55.727     0.150
     1.903    31.961     0.150
     1.903    32.273     0.150
     1.903    56.758     0.150
     1.971    31.680     0.150
     1.971    55.961     0.150
     1.976    33.391     0.150
     1.976    57.992     0.150
     1.976    33.102     0.150
     1.976    58.141     0.150
     2.258    37.031     0.150
     2.333    37.844     0.150
     2.582    42.742     0.150
     2.582    75.602     0.150
     2.582    71.938     0.150
     2.582    41.172     0.150
     2.582    40.250     0.150
     2.841    45.961     0.150
     2.694    44.648     0.150
     2.844    51.609     0.150
     2.844    80.000     0.150
     2.844    45.773     0.150
     2.893    45.977     0.150
     2.917    46.273     0.150
     3.185    49.594     0.150
     3.185    90.859     0.150
     3.328    52.844     0.150
     3.356    53.812     0.150
     3.506    55.117     0.150
     3.506    98.797     0.150
     3.506    54.891     0.150
     3.542    56.633     0.150
     3.542    95.969     0.150
     3.542    55.969     0.150
     3.597    57.156     0.150
     3.597   100.938     0.150
     3.774    58.242     0.150
     3.951    59.852     0.150
     4.067    62.680     0.150
     4.134    64.078     0.150
     4.149    63.438     0.150
     4.161    64.117     0.150
     4.403    67.938     0.150
     4.408    68.148     0.150
     4.408    70.922     0.150
     4.408    86.344     0.150
     4.408   148.695     0.150
     4.449    68.047     0.150
     4.462    68.438     0.150
     4.459    68.906     0.150
     4.507    70.297     0.150
     4.563    70.227     0.150
     4.825    74.453     0.150
     4.853    72.859     0.150
     4.917    74.594     0.150
     4.965    74.891     0.150
     5.236    79.078     0.150
     5.243    79.406     0.150
     5.273    80.047     0.150
     5.346    81.250     0.150
     5.495    82.219     0.150
     5.681    86.492     0.150
     5.678    85.453     0.150
     5.694    86.312     0.150
     5.776    86.812     0.150
     5.993    90.969     0.150
     6.004    89.688     0.150
     6.401    95.578     0.150
     6.417    96.000     0.150
     6.431    95.727     0.150
     6.523    98.430     0.150
     6.526    99.117     0.150
     6.682   101.461     0.150
     6.709   101.367     0.150
     6.748   101.094     0.150
     6.777   100.953     0.150
     6.783   100.398     0.150
     7.071   105.219     0.150
     7.102   106.383     0.150
     7.164   107.500     0.150
     7.198   108.422     0.150
     7.193   107.531     0.150
     7.490   107.461     0.150
     7.388   110.320     0.150
     7.439   110.844     0.150
     7.512   109.781     0.150
     7.600   112.141     0.150
     7.640   114.117     0.150
     7.691   116.328     0.150
     7.997   118.719     0.150
     7.997   258.891     0.150
     7.997   117.422     0.150
     7.997   117.562     0.150
     8.798   129.922     0.150
     8.799   127.445     0.150
     8.799   274.172     0.150
     8.799   129.922     0.150
     9.357   140.977     0.150
    10.945   161.672     0.150
    10.945   357.828     0.150
    10.960   158.617     0.150
    12.094   175.594     0.150
    13.332   194.836     0.150
    13.332   435.203     0.150
    14.950   217.867     0.150
    15.474   220.383     0.150
    15.495   222.383     0.150
    17.354   246.344     0.150
    18.578   260.320     0.150
    20.570   282.500     0.150
    21.625   292.539     0.150
    23.363   309.781     0.150
    26.425   338.570     0.150
    32.664   392.773     0.150
    40.611   462.297     0.150
    40.611   463.562     0.150
    43.601   487.500     0.150
    49.155   528.219     0.150
    79.736   730.281     0.150
    83.648   751.750     0.150
     0.678    13.156     0.150
     0.678    22.566     0.150
     1.096    18.848     0.150
     1.096    33.316     0.150
     1.096    22.066     0.150
     1.096    36.336     0.150
     1.090    19.629     0.150
     1.090    35.016     0.150
     1.300    22.379     0.150
     1.300    39.648     0.150
     1.515    25.727     0.150
     1.515    46.586     0.150
     1.712    51.156     0.150
     1.736    30.129     0.150
     1.736    53.617     0.150
     1.977    35.629     0.150
     1.977    58.355     0.150
     1.998    33.098     0.150
     1.998    36.059     0.150
     1.998    58.457     0.150
     2.155    34.945     0.150
     2.155    61.719     0.150
     2.155    37.668     0.150
     2.415    44.047     0.150
     2.915    50.848     0.150
     3.115    54.746     0.150
     3.115    91.668     0.150
     3.223    57.238     0.150
     3.223   101.758     0.150
     3.399    61.496     0.150
     3.399   102.816     0.150
     3.504    54.836     0.150
     3.504    97.746     0.150
     4.759    80.988     0.150
     0.572    11.352     0.150
     0.572    18.500     0.150
     0.917    17.312     0.150
     0.917    29.602     0.150
     0.970    17.973     0.150
     0.970    31.820     0.150
     0.970    18.082     0.150
     0.970    30.902     0.150
     1.374    24.492     0.150
     1.374    42.871     0.150
     1.432    24.883     0.150
     1.432    43.531     0.150
     1.671    28.820     0.150
     1.671    50.242     0.150
     1.683    30.609     0.150
     1.683    53.570     0.150
     1.849    31.109     0.150
     1.849    55.883     0.150
     1.868    31.512     0.150
     1.868    31.730     0.150
     1.868    54.410     0.150
     1.903    33.359     0.150
     1.924    31.051     0.150
     1.924    54.320     0.150
     1.958    33.062     0.150
     1.958    58.301     0.150
     1.958    57.371     0.150
     2.597    43.301     0.150
     2.597    40.750     0.150
     2.597    81.211     0.150
     2.895    79.820     0.150
     3.218    51.730     0.150
     3.218    50.441     0.150
     3.218    87.742     0.150
     3.466    53.582     0.150
     3.466    95.223     0.150
     3.497    54.359     0.150
     3.497    95.473     0.150
     3.665   100.801     0.150
     3.708    58.520     0.150
     3.708   103.891     0.150
     4.031    64.090     0.150
     4.358    87.227     0.150
     4.358   150.125     0.150
     5.022    77.152     0.150
     5.022   132.852     0.150
     5.643    85.582     0.150
     5.643   154.262     0.150
     7.954   117.352     0.150
     7.954   249.824     0.150
     8.796   128.355     0.150
     8.796   268.031     0.150
    13.272   193.836     0.150
    13.272   425.418     0.150
    18.518   260.250     0.150
    40.556   463.305     0.150
     0.631    13.352     0.150
     0.631    23.041     0.150
     0.890    16.861     0.150
     0.890    28.651     0.150
     1.084    21.052     0.150
     1.084    35.911     0.150
     1.084    20.871     0.150
     1.084    34.361     0.150
     1.295    23.541     0.150
     1.295    40.562     0.150
     1.310    24.191     0.150
     1.310    41.281     0.150
     1.547    27.962     0.150
     1.547    48.531     0.150
     1.776    31.571     0.150
     1.776    54.401     0.150
     1.824    32.302     0.150
     1.824    57.321     0.150
     1.824    32.151     0.150
     1.824    55.182     0.150
     1.848    31.962     0.150
     1.892    33.541     0.150
     1.892    57.361     0.150
     1.951    33.972     0.150
     1.951    60.762     0.150
     1.951    33.861     0.150
     1.951    58.432     0.150
     2.608    43.771     0.150
     2.608    75.962     0.150
     2.608    49.262     0.150
     2.608    83.751     0.150
     3.267    52.312     0.150
     3.267    92.001     0.150
     3.390    53.312     0.150
     3.390    91.041     0.150
     3.617    57.331     0.150
     3.617    98.571     0.150
     3.617    98.411     0.150
     3.707    59.111     0.150
     3.707   101.021     0.150
     4.977   133.411     0.150
     0.577    11.441     0.150
     0.577    19.582     0.150
     0.863    16.322     0.150
     0.863    26.852     0.150
     0.863    17.053     0.150
     0.918    16.652     0.150
     0.918    29.021     0.150
     1.417    24.012     0.150
     1.417    43.162     0.150
     1.586    30.271     0.150
     1.586    50.521     0.150
     1.538    28.053     0.150
     1.538    49.043     0.150
     1.785    33.242     0.150
     1.785    56.172     0.150
     2.005    34.883     0.150
     2.005    32.902     0.150
     2.005    56.223     0.150
     2.016    32.912     0.150
     2.016    54.752     0.150
     2.556    44.951     0.150
     2.556    77.973     0.150
     2.798    47.893     0.150
     2.798    77.973     0.150
     3.147    52.553     0.150
     3.147    92.672     0.150
     3.566   103.383     0.150
     3.547    53.723     0.150
     3.547    97.682     0.150
     3.677    57.422     0.150
     3.677   101.592     0.150
     3.639    55.111     0.150
     3.639    98.451     0.150
     0.581    11.457     0.150
     0.581    19.367     0.150
     0.903    17.117     0.150
     0.903    17.297     0.150
     0.903    29.768     0.150
     0.908    17.287     0.150
     0.908    29.316     0.150
     1.393    24.668     0.150
     1.393    42.986     0.150
     1.496    25.607     0.150
     1.496    45.178     0.150
     1.619    31.027     0.150
     1.619    52.717     0.150
     1.802    33.137     0.150
     1.802    57.107     0.150
     1.985    31.107     0.150
     1.985    55.066     0.150
     1.994    33.066     0.150
     1.994    59.207     0.150
     1.994    57.617     0.150
     2.564    40.258     0.150
     2.564    69.998     0.150
     2.831    45.578     0.150
     2.831    80.777     0.150
     3.522    55.018     0.150
     3.522   100.447     0.150
     3.612    55.758     0.150
     3.612   102.396     0.150
     3.681    58.797     0.150
     3.681   101.518     0.150
     4.421    87.461     0.150
     7.988   260.662     0.150
     8.782   274.717     0.150
     9.368   141.467     0.150
    24.430   323.117     0.150
    40.622   463.617     0.150
     0.515    10.211     0.150
     0.515    17.750     0.150
     0.871    16.219     0.150
     0.871    27.938     0.150
     0.871    27.609     0.150
     0.980    18.242     0.150
     0.980    31.453     0.150
     1.474    25.891     0.150
     1.474    45.648     0.150
     1.548    26.352     0.150
     1.548    46.797     0.150
     1.612    52.633     0.150
     1.790    30.078     0.150
     1.790    53.594     0.150
     1.790    29.633     0.150
     1.835    31.672     0.150
     1.835    55.648     0.150
     1.899    33.047     0.150
     1.899    58.273     0.150
     1.899    30.422     0.150
     1.899    56.117     0.150
     1.951    33.258     0.150
     1.951    58.820     0.150
     1.951    32.461     0.150
     1.951    56.188     0.150
     1.951    58.289     0.150
     1.987    32.531     0.150
     1.987    55.234     0.150
     2.324    37.461     0.150
     2.332    38.039     0.150
     2.614    41.422     0.150
     2.614    41.570     0.150
     2.823    46.641     0.150
     2.969    44.648     0.150
     3.210    49.938     0.150
     3.194    51.492     0.150
     3.194    88.547     0.150
     3.365    51.242     0.150
     3.373    52.211     0.150
     3.508    54.352     0.150
     3.508    97.391     0.150
     3.614    54.883     0.150
     3.614    97.734     0.150
     3.614    57.609     0.150
     3.736    57.391     0.150
     3.736   102.352     0.150
     4.215    63.102     0.150
     4.427    65.453     0.150
     4.896    72.133     0.150
     4.927    75.141     0.150
     5.034    74.602     0.150
     5.090    75.352     0.150
     5.090   137.234     0.150
     5.418    78.750     0.150
     5.844    84.883     0.150
     6.069    87.742     0.150
     7.264   104.102     0.150
     7.501   108.773     0.150
     7.652   109.969     0.150
     7.698   111.719     0.150
     8.835   127.023     0.150
     8.848   127.688     0.150
    12.270   175.414     0.150
    14.736   207.414     0.150
    14.889   207.852     0.150
    15.259   213.758     0.150
    15.290   213.641     0.150
    15.515   216.797     0.150
    15.563   218.648     0.150
    15.602   217.828     0.150
    15.751   218.891     0.150
    15.897   222.734     0.150
     0.543    10.750     0.150
     0.543    17.953     0.150
     0.870    15.484     0.150
     0.870    27.000     0.150
     0.870    16.180     0.150
     0.870    29.609     0.150
     0.951    17.234     0.150
     0.951    30.031     0.150
     1.447    23.773     0.150
     1.447    43.305     0.150
     1.602    28.352     0.150
     1.602    49.891     0.150
     1.780    27.141     0.150
     1.780    51.211     0.150
     1.813    31.445     0.150
     1.813    56.164     0.150
     1.916    31.594     0.150
     1.916    54.445     0.150
     1.974    31.281     0.150
     1.974    57.297     0.150
     1.974    32.234     0.150
     1.974    56.641     0.150
     1.998    31.086     0.150
     1.998    55.125     0.150
     2.589    40.055     0.150
     2.589    70.953     0.150
     3.175    49.812     0.150
     3.175    86.703     0.150
     3.524    53.680     0.150
     3.524    96.180     0.150
     3.590    99.133     0.150
     3.708    59.352     0.150
     3.708   101.836     0.150
     4.437    83.750     0.150
     4.437   141.648     0.150
     5.061    78.094     0.150
     5.061   137.195     0.150
     8.044   117.273     0.150
     8.044   251.125     0.150
     8.820   271.781     0.150
     9.391   136.016     0.150
    13.382   189.930     0.150
    40.646   462.656     0.150
     0.545    10.633     0.150
     0.545    19.211     0.150
     0.906    16.992     0.150
     0.906    29.711     0.150
     1.426    25.828     0.150
     1.426    44.148     0.150
     1.503    26.719     0.150
     1.743    31.672     0.150
     1.743    49.539     0.150
     1.633    29.977     0.150
     1.894    31.109     0.150
     1.894    33.656     0.150
     1.894    57.516     0.150
     1.830    35.398     0.150
     1.962    35.359     0.150
     1.962    58.391     0.150
     2.597    41.438     0.150
     2.597    73.281     0.150
     2.841    47.359     0.150
     2.845    50.266     0.150
     2.845    80.445     0.150
     3.499    99.383     0.150
     3.562    57.945     0.150
     3.562   100.297     0.150
     3.698    60.398     0.150
     3.698   102.617     0.150
     4.406   156.180     0.150
     5.053    79.266     0.150
     5.053   134.398     0.150
     5.626    85.812     0.150
     5.626   150.289     0.150
     8.017   119.609     0.150
     8.017   255.883     0.150
     8.818   127.336     0.150
     8.818   269.000     0.150
     9.358   312.156     0.150
    10.952   363.016     0.150
    13.345   434.945     0.150
    40.613   466.273     0.150
     0.516    10.344     0.150
     0.516    18.039     0.150
     0.894    16.516     0.150
     0.894    16.375     0.150
     0.894    28.023     0.150
     0.975    16.773     0.150
     0.975    30.070     0.150
     0.975    30.234     0.150
     1.460    23.359     0.150
     1.460    42.148     0.150
     1.524    24.648     0.150
     1.524    44.016     0.150
     1.632    29.406     0.150
     1.632    52.969     0.150
     1.766    28.406     0.150
     1.766    50.516     0.150
     1.766    28.289     0.150
     1.845    32.391     0.150
     1.845    57.617     0.150
     1.885    30.914     0.150
     1.885    30.195     0.150
     1.943    31.469     0.150
     1.943    56.250     0.150
     1.943    30.914     0.150
     1.943    56.359     0.150
     1.968    30.406     0.150
     1.968    54.508     0.150
     2.301    35.688     0.150
     2.317    36.617     0.150
     2.619    42.297     0.150
     2.619    40.523     0.150
     2.619    69.047     0.150
     2.843    44.539     0.150
     2.843    45.398     0.150
     2.843    75.664     0.150
     2.846    44.680     0.150
     2.682    44.445     0.150
     3.207    51.141     0.150
     3.207    87.227     0.150
     3.354    51.328     0.150
     3.493    52.586     0.150
     3.493    54.711     0.150
     3.493    96.906     0.150
     3.595    54.719     0.150
     3.595    55.180     0.150
     3.595    98.797     0.150
     3.730   100.141     0.150
     3.764    55.664     0.150
     3.971    60.156     0.150
     4.204    62.797     0.150
     4.408    65.125     0.150
     4.408    86.133     0.150
     4.476    66.758     0.150
     4.507    68.375     0.150
     4.880    74.484     0.150
     5.010    74.266     0.150
     5.084    76.789     0.150
     5.084   134.328     0.150
     5.308    79.891     0.150
     5.642    84.320     0.150
     5.642   145.016     0.150
     5.830    85.445     0.150
     6.029    88.656     0.150
     6.046    88.414     0.150
     6.717    98.180     0.150
     7.125   103.555     0.150
     7.194   104.086     0.150
     7.230   105.297     0.150
     7.247   105.430     0.150
     7.479   106.539     0.150
     7.627   110.109     0.150
     7.643   110.891     0.150
     7.692   112.398     0.150
     8.051   117.258     0.150
     8.051   254.086     0.150
     8.051   116.641     0.150
     8.604   124.641     0.150
     8.710   126.789     0.150
     8.830   128.891     0.150
     8.845   129.094     0.150
     8.846   129.094     0.150
     8.846   272.148     0.150
     8.846   129.539     0.150
     9.364   307.422     0.150
    12.281   174.109     0.150
    13.180   186.227     0.150
    13.370   430.242     0.150
    14.543   206.695     0.150
    14.876   210.711     0.150
    15.529   219.297     0.150
    15.549   218.680     0.150
    15.597   220.500     0.150
    16.009   226.617     0.150
    17.850   248.609     0.150
     0.535    10.757     0.150
     0.535    17.787     0.150
     0.954    17.757     0.150
     0.954    30.497     0.150
     0.966    17.927     0.150
     0.966    28.467     0.150
     1.411    24.967     0.150
     1.411    43.817     0.150
     1.445    26.407     0.150
     1.445    45.677     0.150
     1.687    29.947     0.150
     1.691    30.357     0.150
     1.691    52.927     0.150
     1.847    32.727     0.150
     1.847    55.217     0.150
     1.873    33.077     0.150
     1.873    57.877     0.150
     1.912    31.917     0.150
     1.912    57.197     0.150
     1.928    32.677     0.150
     1.928    58.007     0.150
     1.928    32.517     0.150
     1.928    54.607     0.150
     2.627    44.387     0.150
     2.627    72.477     0.150
     3.240    54.377     0.150
     3.240    92.427     0.150
     3.448    97.727     0.150
     3.530    65.487     0.150
     3.530   111.227     0.150
     3.702    69.727     0.150
     3.702   112.587     0.150
     0.540    10.706     0.150
     0.540    18.776     0.150
     0.890    16.296     0.150
     0.890    27.566     0.150
     0.890    16.506     0.150
     0.951    17.116     0.150
     0.951    30.126     0.150
     1.439    24.336     0.150
     1.439    43.766     0.150
     1.521    24.646     0.150
     1.620    27.726     0.150
     1.620    48.926     0.150
     1.761    28.576     0.150
     1.761    52.016     0.150
     1.761    28.396     0.150
     1.825    29.686     0.150
     1.825    53.296     0.150
     1.902    30.776     0.150
     1.902    56.166     0.150
     1.902    30.906     0.150
     1.980    31.446     0.150
     1.964    30.996     0.150
     1.964    56.706     0.150
     1.964    31.626     0.150
     1.964    53.986     0.150
     2.291    36.176     0.150
     2.333    36.116     0.150
     2.596    41.016     0.150
     2.596    40.156     0.150
     2.854    45.116     0.150
     2.697    42.996     0.150
     2.906    44.516     0.150
     2.944    44.726     0.150
     3.188    49.806     0.150
     3.347    49.836     0.150
     3.366    50.746     0.150
     3.508    53.656     0.150
     3.508    53.876     0.150
     3.578    54.186     0.150
     3.578    54.476     0.150
     3.706    62.796     0.150
     3.716    56.376     0.150
     3.716   100.776     0.150
     3.778    57.176     0.150
     3.973    60.036     0.150
     4.084    62.146     0.150
     4.167    62.616     0.150
     4.419    65.786     0.150
     4.419    66.350     0.150
     4.419    83.025     0.150
     4.419   117.025     0.150
     4.419   140.325     0.150
     4.860    72.206     0.150
     4.988    74.326     0.150
     4.995    73.346     0.150
     5.061    76.226     0.150
     5.809    85.186     0.150
     5.846    84.136     0.150
     5.941    91.126     0.150
     6.037    88.586     0.150
     6.557    96.806     0.150
     6.718    98.606     0.150
     6.770    98.396     0.150
     7.105   104.456     0.150
     7.228   104.746     0.150
     7.627   111.256     0.150
     7.645   111.656     0.150
     7.668   112.426     0.150
     7.704   111.766     0.150
     7.723   112.106     0.150
     8.032   117.275     0.150
     8.032   244.575     0.150
     8.032   117.106     0.150
     8.345   119.376     0.150
     8.592   124.436     0.150
     8.806   128.336     0.150
     8.822   128.481     0.150
     8.822   272.081     0.150
     8.822   128.126     0.150
     9.356   134.596     0.150
     9.372   137.456     0.150
     9.372   298.131     0.150
    10.211   146.146     0.150
    10.212   147.186     0.150
    10.464   151.336     0.150
    10.485   151.356     0.150
    10.699   154.136     0.150
    10.969   159.181     0.150
    10.969   344.831     0.150
    10.977   156.776     0.150
    10.987   157.986     0.150
    12.163   173.996     0.150
    12.261   174.916     0.150
    12.616   180.826     0.150
    13.276   187.606     0.150
    13.363   189.600     0.150
    13.363   419.183     0.150
    13.605   193.566     0.150
    13.611   193.856     0.150
    13.688   193.866     0.150
    13.834   196.386     0.150
    13.913   200.794     0.150
    14.030   199.866     0.150
    14.094   198.786     0.150
    14.108   198.566     0.150
    14.319   202.876     0.150
    14.520   204.456     0.150
    14.608   207.606     0.150
    14.658   207.436     0.150
    14.811   210.716     0.150
    14.811   211.386     0.150
    14.840   209.756     0.150
    14.855   210.796     0.150
    14.964   211.706     0.150
    15.049   211.606     0.150
    15.058   213.076     0.150
    15.075   212.126     0.150
    15.125   212.676     0.150
    15.135   214.486     0.150
    15.195   215.226     0.150
    15.225   214.476     0.150
    15.255   214.796     0.150
    15.267   215.616     0.150
    15.407   217.206     0.150
    15.490   220.716     0.150
    15.528   219.806     0.150
    15.574   219.196     0.150
    15.588   220.616     0.150
    15.658   222.096     0.150
    15.716   221.446     0.150
    15.845   222.836     0.150
    15.987   225.336     0.150
    15.978   225.666     0.150
    16.284   229.286     0.150
    16.355   230.526     0.150
    16.390   231.376     0.150
    16.674   233.776     0.150
    16.901   236.476     0.150
    16.941   237.286     0.150
    16.954   237.006     0.150
    16.988   237.626     0.150
    17.016   236.546     0.150
    17.049   238.116     0.150
    17.151   238.896     0.150
    17.374   242.226     0.150
    17.526   243.456     0.150
    17.672   246.256     0.150
    17.737   247.856     0.150
    17.813   248.166     0.150
    18.601   259.950     0.150
    19.693   268.426     0.150
    20.562   277.016     0.150
    21.063   283.126     0.150
    21.409   287.326     0.150
    21.431   288.525     0.150
    21.904   292.966     0.150
    22.163   296.656     0.150
    24.469   319.406     0.150
    32.690   393.081     0.150
    37.828   435.756     0.150
    39.170   447.496     0.150
    40.627   462.306     0.150
    41.882   469.586     0.150
    80.814   735.731     0.150
    83.656   749.956     0.150
    85.000   757.456     0.150
    85.591   760.031     0.150
    88.740   773.531     0.150
    98.108   815.456     0.150
     0.579    11.311     0.150
     0.579    19.641     0.150
     0.908    17.201     0.150
     0.908    30.352     0.150
     0.908    17.031     0.150
     0.908    30.891     0.150
     0.910    17.561     0.150
     0.910    29.990     0.150
     1.393    24.881     0.150
     1.393    43.422     0.150
     1.492    25.922     0.150
     1.492    45.682     0.150
     1.624    30.250     0.150
     1.624    51.580     0.150
     1.730    29.641     0.150
     1.730    52.461     0.150
     1.730    29.451     0.150
     1.806    31.941     0.150
     1.915    55.400     0.150
     1.915    32.012     0.150
     1.915    57.301     0.150
     1.980    31.570     0.150
     1.980    56.301     0.150
     1.990    57.461     0.150
     1.990    33.070     0.150
     2.253    37.012     0.150
     2.567    44.611     0.150
     2.567    41.320     0.150
     2.567    69.221     0.150
     2.836    55.330     0.150
     2.836    53.012     0.150
     2.836    78.121     0.150
     2.918    46.941     0.150
     3.226    61.490     0.150
     3.365    61.451     0.150
     3.517    63.240     0.150
     3.532    56.201     0.150
     3.664    68.160     0.150
     3.684    57.432     0.150
     3.684   100.201     0.150
     3.784    67.641     0.150
     4.073    69.500     0.150
     4.132    64.951     0.150
     4.136    64.541     0.150
     4.416    81.980     0.150
     4.416   147.680     0.150
     4.452    68.891     0.150
     4.813    74.750     0.150
     4.961    75.541     0.150
     5.271    81.721     0.150
     5.336    80.740     0.150
     5.670    85.342     0.150
     5.677    86.391     0.150
     5.763    86.611     0.150
     5.991    91.682     0.150
     6.000    90.750     0.150
     6.680   100.801     0.150
     6.751   102.971     0.150
     6.788   104.641     0.150
     7.059   103.621     0.150
     7.181   105.291     0.150
     7.197   107.871     0.150
     7.500   108.441     0.150
     7.392   113.281     0.150
     7.425   108.980     0.150
     7.601   114.172     0.150
     7.624   114.711     0.150
     7.626   112.141     0.150
     7.695   114.691     0.150
     7.677   115.512     0.150
     7.753   116.230     0.150
     7.983   115.932     0.150
     7.983   116.041     0.150
     7.986   117.955     0.150
     7.986   246.881     0.150
     7.986   116.961     0.150
     8.381   121.512     0.150
     8.643   125.691     0.150
     8.670   126.092     0.150
     8.783   129.141     0.150
     8.784   129.621     0.150
     8.784   269.746     0.150
     8.784   128.922     0.150
     9.363   142.297     0.150
    10.945   161.271     0.150
    13.329   194.082     0.150
    13.705   195.410     0.150
    15.247   214.602     0.150
    15.391   225.932     0.150
    15.481   219.271     0.150
    15.533   220.631     0.150
    15.626   221.211     0.150
    15.670   221.871     0.150
    16.345   230.271     0.150
    16.626   233.480     0.150
    17.479   244.230     0.150
    40.617   465.324     0.150
     0.563    11.176     0.150
     0.563    19.195     0.150
     0.892    17.336     0.150
     0.892    27.195     0.150
     0.928    17.098     0.150
     0.928    29.086     0.150
     1.416    24.875     0.150
     1.416    43.445     0.150
     1.512    25.527     0.150
     1.512    44.246     0.150
     1.615    30.387     0.150
     1.615    52.277     0.150
     1.751    29.047     0.150
     1.751    51.637     0.150
     1.809    33.457     0.150
     1.915    30.715     0.150
     1.915    55.535     0.150
     1.915    32.156     0.150
     1.983    32.527     0.150
     1.983    57.648     0.150
     1.983    32.777     0.150
     1.983    56.668     0.150
     1.987    33.488     0.150
     1.987    59.867     0.150
     2.577    40.625     0.150
     2.577    72.527     0.150
     2.827    44.207     0.150
     2.827    75.727     0.150
     3.519    97.285     0.150
     3.557    55.566     0.150
     3.557    98.738     0.150
     3.683    62.156     0.150
     3.683   102.926     0.150
     3.695    57.098     0.150
     3.695   100.297     0.150
     5.037    76.527     0.150
     5.037   139.707     0.150
     5.606    84.277     0.150
     0.560    11.098     0.150
     0.560    19.156     0.150
     0.858    17.078     0.150
     0.858    26.805     0.150
     0.858    27.785     0.150
     0.858    28.086     0.150
     0.936    17.457     0.150
     0.936    29.977     0.150
     1.437    25.266     0.150
     1.437    45.168     0.150
     1.548    25.746     0.150
     1.548    48.285     0.150
     1.586    29.938     0.150
     1.586    49.668     0.150
     1.787    29.438     0.150
     1.794    29.605     0.150
     1.794    52.707     0.150
     1.935    31.527     0.150
     1.935    32.137     0.150
     1.935    54.668     0.150
     1.993    32.695     0.150
     1.993    59.797     0.150
     1.993    55.828     0.150
     2.015    31.848     0.150
     2.015    56.145     0.150
     2.312    36.988     0.150
     2.367    37.926     0.150
     2.570    41.285     0.150
     2.570    40.566     0.150
     2.570    72.656     0.150
     2.798    51.246     0.150
     2.798    54.266     0.150
     2.798    51.078     0.150
     2.798    80.316     0.150
     2.731    46.168     0.150
     2.973    46.387     0.150
     3.156    49.547     0.150
     3.156    85.965     0.150
     3.542    55.297     0.150
     3.542    96.848     0.150
     3.585    55.258     0.150
     3.585    54.996     0.150
     3.585   100.008     0.150
     3.634    57.348     0.150
     3.634    95.438     0.150
     3.693    57.086     0.150
     3.693   103.988     0.150
     3.691    56.797     0.150
     3.691    99.738     0.150
     4.005    61.785     0.150
     4.176    64.355     0.150
     4.453    77.207     0.150
     4.453    71.234     0.150
     4.453    87.262     0.150
     4.453   149.387     0.150
     4.509    68.785     0.150
     4.861    73.996     0.150
     5.020    75.977     0.150
     5.046    77.117     0.150
     5.046   134.117     0.150
     5.591    82.957     0.150
     5.591   154.527     0.150
     5.807    86.977     0.150
     5.908   162.035     0.150
     6.058    89.035     0.150
     6.801   101.117     0.150
     6.824    99.355     0.150
     7.231   106.945     0.150
     7.528   107.988     0.150
     7.460   110.367     0.150
     7.654   113.027     0.150
     7.677   112.355     0.150
     7.677   200.605     0.150
     7.677   115.547     0.150
     8.038   118.109     0.150
     8.038   210.359     0.150
     8.038   253.461     0.150
     8.038   117.785     0.150
     8.038   118.457     0.150
     8.608   126.957     0.150
     8.791   129.477     0.150
     8.804   128.391     0.150
     8.804   269.973     0.150
     8.804   129.188     0.150
     9.406   140.395     0.150
    10.413   154.176     0.150
    11.000   162.840     0.150
    10.971   160.367     0.150
    11.409   164.156     0.150
    11.928   174.207     0.150
    12.019   173.316     0.150
    12.105   175.406     0.150
    12.230   179.117     0.150
    12.230   178.645     0.150
    12.655   182.488     0.150
    13.128   191.137     0.150
    13.218   190.285     0.150
    13.387   193.965     0.150
    13.387   192.535     0.150
    13.601   194.348     0.150
    13.702   198.926     0.150
    14.111   201.676     0.150
    15.558   221.195     0.150
    17.730   249.168     0.150
    18.632   260.785     0.150
    18.632   261.957     0.150
    19.504   269.637     0.150
    20.390   275.836     0.150
    20.390   279.168     0.150
    21.400   287.059     0.150
    21.678   290.906     0.150
    22.623   303.086     0.150
    22.623   303.426     0.150
    22.928   304.727     0.150
    23.029   307.688     0.150
    24.211   319.777     0.150
    24.485   320.543     0.150
    24.485   318.266     0.150
    24.551   319.988     0.150
    24.940   326.766     0.150
    24.934   326.445     0.150
    26.486   336.527     0.150
    30.986   378.027     0.150
    31.051   380.387     0.150
    31.557   384.055     0.150
    32.115   389.145     0.150
    32.719   394.492     0.150
    32.719   393.156     0.150
    33.408   400.418     0.150
    34.014   405.836     0.150
    36.936   431.996     0.150
    40.661   463.266     0.150
    40.661   462.598     0.150
    41.915   473.918     0.150
    44.093   489.516     0.150
    44.649   496.176     0.150
    44.713   495.746     0.150
    46.956   511.625     0.150
    55.008   573.246     0.150
    67.030   656.125     0.150
    69.238   669.055     0.150
    69.989   671.227     0.150
    74.704   703.965     0.150
    74.776   702.406     0.150
    75.367   706.059     0.150
    75.367   704.918     0.150
    75.920   708.918     0.150
    85.034   758.137     0.150
    85.034   757.758     0.150
    85.008   758.043     0.150
    85.624   761.230     0.150
    85.624   760.086     0.150
    98.143   816.668     0.150
   120.012  1132.562     0.150
   120.012  1132.375     0.150
     0.570    11.133     0.150
     0.926    17.922     0.150
     0.926    30.082     0.150
     0.860    16.992     0.150
     1.426    25.359     0.150
     1.426    44.602     0.150
     1.585    30.812     0.150
     1.585    49.973     0.150
     1.788    33.703     0.150
     1.788    55.203     0.150
     1.939    32.781     0.150
     1.939    61.031     0.150
     1.939    34.422     0.150
     1.939    59.582     0.150
     2.017    32.621     0.150
     2.000    33.723     0.150
     2.000    62.320     0.150
     2.000    62.121     0.150
     2.889    47.102     0.150
     2.889    81.441     0.150
     3.150    48.672     0.150
     3.150    87.832     0.150
     3.575    53.242     0.150
     3.575    90.973     0.150
     3.546    57.930     0.150
     3.546   100.980     0.150
     3.683   105.172     0.150
     4.454    78.551     0.150
     8.027   263.125     0.150
     8.794   129.227     0.150
     8.794   273.902     0.150
     0.558    10.875     0.150
     0.558    18.805     0.150
     0.884    15.844     0.150
     0.884    27.695     0.150
     0.884    16.594     0.150
     0.884    29.543     0.150
     0.934    17.004     0.150
     0.934    29.754     0.150
     1.425    23.535     0.150
     1.425    42.785     0.150
     1.610    30.562     0.150
     1.610    51.574     0.150
     1.809    31.234     0.150
     1.809    54.914     0.150
     1.917    31.176     0.150
     1.917    31.402     0.150
     1.917    54.285     0.150
     1.981    34.414     0.150
     1.981    60.586     0.150
     1.981    54.312     0.150
     1.992    30.574     0.150
     1.992    54.375     0.150
     2.579    40.004     0.150
     2.579    70.805     0.150
     2.822    46.074     0.150
     2.822    83.324     0.150
     3.172    48.695     0.150
     3.172    83.453     0.150
     3.522    55.355     0.150
     3.522    96.812     0.150
     3.567    54.984     0.150
     3.567    94.434     0.150
     3.690    64.434     0.150
     3.690    98.824     0.150
     5.044    74.844     0.150
     5.044   137.305     0.150
     0.560    10.996     0.150
     0.560    18.406     0.150
     0.929    16.668     0.150
     0.929    29.227     0.150
     0.957    16.629     0.150
     0.957    17.695     0.150
     0.957    32.059     0.150
     1.390    24.398     0.150
     1.390    43.246     0.150
     1.447    24.758     0.150
     1.447    44.168     0.150
     1.687    29.387     0.150
     1.687    52.168     0.150
     1.675    29.195     0.150
     1.675    51.516     0.150
     1.869    31.219     0.150
     1.849    31.695     0.150
     1.930    30.477     0.150
     1.930    54.027     0.150
     1.953    32.586     0.150
     1.953    58.266     0.150
     1.953    31.258     0.150
     1.953    56.938     0.150
     2.602    42.469     0.150
     2.602    71.176     0.150
     3.218    51.617     0.150
     3.218    87.816     0.150
     3.469    51.996     0.150
     3.469    94.668     0.150
     3.515    54.379     0.150
     3.515    94.289     0.150
     3.678    58.516     0.150
     3.715    57.836     0.150
     4.365    84.734     0.150
     4.365   151.461     0.150
     5.035    76.977     0.150
     5.035   135.508     0.150
     7.972   263.484     0.150
     8.806   128.891     0.150
     8.806   274.242     0.150
    18.531   260.387     0.150
    40.566   460.996     0.150
     0.574    11.367     0.150
     0.574    19.375     0.150
     0.921    17.109     0.150
     0.921    30.102     0.150
     0.860    17.227     0.150
     0.860    17.125     0.150
     1.422    24.727     0.150
     1.422    42.867     0.150
     1.583    28.742     0.150
     1.583    50.578     0.150
     1.780    56.008     0.150
     1.785    32.742     0.150
     1.785    56.922     0.150
     1.942    34.516     0.150
     1.942    59.828     0.150
     1.942    31.938     0.150
     1.942    54.828     0.150
     2.018    31.828     0.150
     2.018    55.125     0.150
     2.004    33.070     0.150
     2.004    59.750     0.150
     2.004    57.539     0.150
     2.558    40.875     0.150
     2.558    69.391     0.150
     2.795    46.945     0.150
     2.795    82.438     0.150
     3.147    49.266     0.150
     3.147    86.531     0.150
     3.571    53.258     0.150
     3.571   100.320     0.150
     3.548    56.266     0.150
     3.548    94.062     0.150
     3.678    55.352     0.150
     3.678    99.250     0.150
     5.031    75.430     0.150
     5.031   135.195     0.150
     0.565    11.258     0.150
     0.565    19.208     0.150
     0.927    17.038     0.150
     0.927    30.078     0.150
     0.881    14.848     0.150
     0.881    25.548     0.150
     0.881    15.528     0.150
     0.881    28.688     0.150
     1.420    24.968     0.150
     1.420    44.318     0.150
     1.605    50.908     0.150
     1.802    33.308     0.150
     1.802    55.358     0.150
     1.923    31.558     0.150
     1.923    56.228     0.150
     1.923    31.748     0.150
     1.923    54.838     0.150
     1.997    30.308     0.150
     1.997    54.488     0.150
     1.989    32.768     0.150
     1.989    56.768     0.150
     1.989    57.078     0.150
     2.572    67.448     0.150
     3.563    55.608     0.150
     3.563    95.758     0.150
     3.683    92.778     0.150
     3.691    57.318     0.150
     3.691   102.588     0.150
     5.037    73.188     0.150
     5.037   130.368     0.150
     0.647    12.688     0.150
     0.647    23.336     0.150
     0.846    15.875     0.150
     0.846    27.016     0.150
     0.985    18.570     0.150
     0.985    32.477     0.150
     0.985    19.367     0.150
     0.985    32.000     0.150
     1.299    23.391     0.150
     1.299    40.000     0.150
     1.404    23.945     0.150
     1.404    41.406     0.150
     1.637    27.594     0.150
     1.637    48.164     0.150
     1.673    29.930     0.150
     1.673    51.875     0.150
     1.911    30.734     0.150
     1.911    55.344     0.150
     1.911    31.836     0.150
     1.911    55.141     0.150
     2.017    32.945     0.150
     2.017    58.477     0.150
     2.017    33.227     0.150
     2.538    43.875     0.150
     3.177    50.188     0.150
     3.177    92.188     0.150
     3.428    53.516     0.150
     3.428   109.586     0.150
     3.501    55.797     0.150
     3.501    94.695     0.150
     3.591    69.703     0.150
     3.591   113.477     0.150
     3.591    57.469     0.150
     3.591   114.594     0.150
     3.645    74.414     0.150
     3.645   119.867     0.150
     4.375    84.242     0.150
     4.375   139.766     0.150
     4.948    77.977     0.150
     4.948   157.078     0.150
     5.595    85.898     0.150
     7.884   116.016     0.150
     7.884   209.367     0.150
     7.884   251.867     0.150
     8.725   127.570     0.150
     8.725   226.086     0.150
     8.725   275.148     0.150
    10.869   156.594     0.150
    10.869   344.000     0.150
    13.231   190.273     0.150
    13.231   421.727     0.150
    40.559   463.094     0.150
     0.633    12.378     0.150
     0.633    21.188     0.150
     0.879    16.148     0.150
     0.879    27.908     0.150
     1.061    18.618     0.150
     1.061    32.178     0.150
     1.061    31.648     0.150
     1.295    23.128     0.150
     1.295    40.099     0.150
     1.331    23.548     0.150
     1.331    41.269     0.150
     1.753    30.908     0.150
     1.753    53.248     0.150
     1.844    32.019     0.150
     1.844    54.658     0.150
     1.844    31.608     0.150
     1.844    54.248     0.150
     1.966    33.258     0.150
     1.966    57.538     0.150
     1.966    57.688     0.150
     2.592    40.908     0.150
     2.592    69.718     0.150
     3.246    49.278     0.150
     3.246    86.118     0.150
     3.398    53.288     0.150
     3.398    92.708     0.150
     3.428    55.048     0.150
     3.428    93.898     0.150
     3.516    54.269     0.150
     3.516    95.438     0.150
     0.564    11.059     0.150
     0.564    18.840     0.150
     0.885    17.711     0.150
     0.885    27.859     0.150
     0.928    17.539     0.150
     0.928    30.809     0.150
     1.419    24.738     0.150
     1.419    43.738     0.150
     1.609    29.641     0.150
     1.609    52.098     0.150
     1.758    29.660     0.150
     1.758    51.828     0.150
     1.805    52.180     0.150
     1.920    32.391     0.150
     1.920    56.699     0.150
     1.920    31.301     0.150
     1.920    56.891     0.150
     1.986    34.590     0.150
     1.986    58.309     0.150
     2.574    43.180     0.150
     2.574    84.129     0.150
     2.821    46.758     0.150
     2.821    85.250     0.150
     2.865    50.219     0.150
     3.169    52.789     0.150
     3.169    87.910     0.150
     3.525    99.469     0.150
     3.561    57.848     0.150
     3.683    66.680     0.150
     3.683   111.430     0.150
     0.525    10.320     0.150
     0.525    18.320     0.150
     0.910    14.633     0.150
     0.910    17.641     0.150
     0.910    29.867     0.150
     0.964    17.703     0.150
     0.964    30.305     0.150
     1.444    23.742     0.150
     1.444    43.312     0.150
     1.505    25.945     0.150
     1.505    46.906     0.150
     1.643    26.742     0.150
     1.643    47.125     0.150
     1.746    29.492     0.150
     1.847    30.586     0.150
     1.847    53.844     0.150
     1.880    31.211     0.150
     1.880    57.594     0.150
     1.944    32.172     0.150
     1.944    56.477     0.150
     1.958    32.461     0.150
     1.958    58.484     0.150
     2.311    36.133     0.150
     2.280    36.742     0.150
     2.615    43.320     0.150
     2.675    43.516     0.150
     2.926    45.984     0.150
     3.191    48.773     0.150
     3.343    50.344     0.150
     3.486    52.227     0.150
     3.486    55.227     0.150
     3.486    97.383     0.150
     3.576    56.641     0.150
     3.718    62.367     0.150
     3.954    59.062     0.150
     4.063    60.562     0.150
     4.144    61.727     0.150
     4.149    63.172     0.150
     4.188    63.992     0.150
     4.396    64.352     0.150
     4.396    79.906     0.150
     4.491    66.281     0.150
     4.487    66.836     0.150
     4.974    72.320     0.150
     4.990    74.570     0.150
     5.073    75.555     0.150
     5.252    78.406     0.150
     5.289    79.461     0.150
     5.379    80.125     0.150
     5.813    84.211     0.150
     6.009    89.453     0.150
     6.025    89.336     0.150
     7.107   103.297     0.150
     7.228   104.414     0.150
     7.478   106.273     0.150
     7.626   111.617     0.150
     7.706   113.336     0.150
     8.032   119.156     0.150
     8.032   252.930     0.150
     8.724   126.992     0.150
     8.837   126.039     0.150
     8.837   128.805     0.150
    10.198   146.562     0.150
    15.060   214.117     0.150
    15.110   214.594     0.150
    15.230   216.227     0.150
    15.441   217.414     0.150
    15.513   218.977     0.150
    15.533   218.461     0.150
    15.671   220.836     0.150
    15.676   220.453     0.150
    15.992   224.664     0.150
    16.289   228.820     0.150
    16.398   230.797     0.150
     0.560    11.000     0.150
     0.901    15.852     0.150
     0.901    16.148     0.150
     0.929    17.359     0.150
     0.929    30.309     0.150
     1.414    24.922     0.150
     1.414    45.480     0.150
     1.504    25.672     0.150
     1.504    48.340     0.150
     1.624    51.250     0.150
     1.624    51.422     0.150
     1.743    28.898     0.150
     1.908    32.469     0.150
     1.908    59.449     0.150
     1.908    31.832     0.150
     1.908    55.719     0.150
     1.816    30.449     0.150
     1.816    52.910     0.150
     1.977    33.910     0.150
     1.977    60.949     0.150
     1.977    32.160     0.150
     1.977    55.992     0.150
     1.979    32.570     0.150
     1.979    55.969     0.150
     2.338    37.809     0.150
     2.269    36.648     0.150
     2.581    41.922     0.150
     2.581    74.000     0.150
     2.581    41.461     0.150
     2.581    39.961     0.150
     2.700    45.391     0.150
     2.836    47.492     0.150
     2.836    83.199     0.150
     2.836    49.699     0.150
     2.836    46.621     0.150
     2.928    46.129     0.150
     3.219    49.520     0.150
     3.181    51.199     0.150
     3.364    53.172     0.150
     3.338    52.281     0.150
     3.512    53.512     0.150
     3.512    95.469     0.150
     3.512    55.320     0.150
     3.603    57.129     0.150
     3.552    53.898     0.150
     3.552   106.281     0.150
     3.552    56.410     0.150
     3.552    56.699     0.150
     3.780    58.141     0.150
     3.683   108.051     0.150
     3.683   119.871     0.150
     3.961    60.422     0.150
     4.077    62.172     0.150
     4.168    63.000     0.150
     4.145    62.570     0.150
     4.156    63.039     0.150
     4.416    67.090     0.150
     4.416    80.711     0.150
     4.416    70.715     0.150
     4.416    86.188     0.150
     4.416   147.090     0.150
     4.470    66.840     0.150
     4.834    71.961     0.150
     4.986    74.699     0.150
     4.978    74.930     0.150
     5.038    78.020     0.150
     5.285    77.320     0.150
     5.356    79.820     0.150
     5.612    84.750     0.150
     5.732    83.340     0.150
     5.784    86.309     0.150
     5.937    89.762     0.150
     5.937   192.969     0.150
     6.015    89.551     0.150
     6.532    96.102     0.150
     6.785    98.121     0.150
     6.758    99.422     0.150
     6.792    99.469     0.150
     7.445   109.492     0.150
     7.445   110.719     0.150
     7.707   111.301     0.150
     7.645   112.281     0.150
     7.690   112.172     0.150
     7.690   116.730     0.150
     7.716   143.992     0.150
     7.764   112.660     0.150
     8.007   117.789     0.150
     8.007   116.512     0.150
     8.007   119.082     0.150
     8.007   115.590     0.150
     8.401   121.762     0.150
     8.784   127.750     0.150
     8.829   132.039     0.150
     8.801   127.809     0.150
     8.802   128.969     0.150
     8.802   271.297     0.150
     9.365   141.102     0.150
     9.365   304.375     0.150
    10.956   162.570     0.150
    10.956   353.797     0.150
    10.937   157.809     0.150
    11.385   161.719     0.150
    12.139   171.910     0.150
    12.252   179.871     0.150
    12.595   179.191     0.150
    12.656   180.281     0.150
    13.084   184.770     0.150
    13.580   196.242     0.150
    14.496   204.961     0.150
    14.975   210.699     0.150
    14.956   210.711     0.150
    15.260   215.109     0.150
    15.465   216.801     0.150
    15.502   217.492     0.150
    15.552   222.582     0.150
    15.552   221.371     0.150
    16.223   232.512     0.150
    16.223   231.871     0.150
    16.261   229.219     0.150
    16.647   231.961     0.150
    16.875   235.320     0.150
    16.875   240.371     0.150
    17.713   251.070     0.150
    17.825   251.969     0.150
    18.588   261.238     0.150
    18.588   261.840     0.150
    18.669   257.492     0.150
    18.690   256.609     0.150
    19.106   261.262     0.150
    19.137   261.500     0.150
    19.319   264.359     0.150
    19.468   271.320     0.150
    19.468   270.672     0.150
    20.006   270.941     0.150
    20.367   280.859     0.150
    20.367   280.469     0.150
    21.422   287.391     0.150
    22.607   299.551     0.150
    22.607   303.672     0.150
    22.604   299.582     0.150
    22.604   305.031     0.150
    22.604   304.371     0.150
    22.990   308.262     0.150
    24.134   314.629     0.150
    24.189   320.582     0.150
    24.189   319.770     0.150
    24.229   316.000     0.150
    24.243   315.711     0.150
    24.445   320.520     0.150
    24.534   319.031     0.150
    25.198   325.910     0.150
    25.501   328.832     0.150
    25.822   332.215     0.150
    26.287   338.781     0.150
    26.470   337.211     0.150
    27.966   350.840     0.150
    30.369   371.379     0.150
    32.675   393.809     0.150
    32.675   391.609     0.150
    32.692   396.270     0.150
    34.071   403.621     0.150
    34.799   409.809     0.150
    40.620   463.277     0.150
    40.888   462.262     0.150
    44.734   492.230     0.150
    44.673   497.980     0.150
    52.453   556.531     0.150
    65.303   646.340     0.150
    68.632   664.770     0.150
    68.898   667.410     0.150
    70.436   678.680     0.150
    70.935   679.672     0.150
    70.935     4.098     0.150
    74.150   696.770     0.150
    74.995   703.770     0.150
    75.328   706.371     0.150
    77.232   718.641     0.150
    78.431   723.172     0.150
    78.431     4.098     0.150
    79.898   730.871     0.150
    80.816   734.422     0.150
    80.816   734.852     0.150
    80.816   736.469     0.150
    82.559   748.020     0.150
    82.632   746.930     0.150
    82.911   748.789     0.150
    82.984   747.711     0.150
    83.041   749.602     0.150
    83.085   749.969     0.150
    83.085   749.172     0.150
    83.824   753.219     0.150
    84.804   758.469     0.150
    85.002   757.418     0.150
    85.002   755.809     0.150
    84.976   756.047     0.150
    85.023   759.172     0.150
    85.597   760.922     0.150
    85.597   759.891     0.150
    86.573   760.871     0.150
    98.107   816.469     0.150
     0.554    10.922     0.150
     0.554    18.352     0.150
     0.912    16.883     0.150
     0.912    28.133     0.150
     0.912    29.055     0.150
     0.934    17.094     0.150
     0.934    29.312     0.150
     1.414    24.633     0.150
     1.414    43.992     0.150
     1.636    30.133     0.150
     1.636    51.633     0.150
     1.733    28.852     0.150
     1.826    32.445     0.150
     1.826    55.633     0.150
     1.896    31.305     0.150
     1.896    54.211     0.150
     1.968    56.266     0.150
     1.968    32.406     0.150
     1.968    59.094     0.150
     1.967    30.445     0.150
     1.967    54.172     0.150
     2.262    36.609     0.150
     2.327    37.195     0.150
     2.590    42.242     0.150
     2.688    43.516     0.150
     2.918    45.602     0.150
     3.326    51.625     0.150
     3.352    50.109     0.150
     3.500    53.102     0.150
     3.549    54.477     0.150
     3.549    90.125     0.150
     3.707    57.250     0.150
     3.707   101.883     0.150
     3.688    65.250     0.150
     3.688   109.656     0.150
     3.688    55.055     0.150
     3.768    55.984     0.150
     3.950    59.203     0.150
     4.158    63.000     0.150
     4.136    63.477     0.150
     4.404    65.000     0.150
     4.404    69.508     0.150
     4.404    85.875     0.150
     4.404   146.266     0.150
     4.460    66.594     0.150
     4.833    71.906     0.150
     4.971    74.922     0.150
     5.275    78.820     0.150
     5.353    80.812     0.150
     5.684    84.664     0.150
     5.784    85.602     0.150
     6.008    89.156     0.150
     6.534    95.812     0.150
     6.943   100.852     0.150
     7.078   103.977     0.150
     7.200   104.945     0.150
     7.199   105.070     0.150
     7.448   109.391     0.150
     7.649   112.164     0.150
     7.621   111.305     0.150
     8.004   114.812     0.150
     8.004   207.297     0.150
     8.004   248.219     0.150
     8.004   116.172     0.150
     8.789   128.414     0.150
     8.808   128.844     0.150
     8.808   126.508     0.150
     8.808   267.109     0.150
     8.808   129.266     0.150
     9.354   138.484     0.150
     9.447   137.016     0.150
     9.602   140.680     0.150
    10.945   159.602     0.150
    13.335   191.625     0.150
    14.767   207.742     0.150
    15.097   212.492     0.150
    15.201   213.156     0.150
    15.321   213.922     0.150
    18.577   260.359     0.150
    20.571   278.656     0.150
    21.118   282.500     0.150
    24.439   318.102     0.150
    32.664   393.375     0.150
    40.608   461.273     0.150
     0.565    11.173     0.150
     0.565    19.113     0.150
     0.840    15.243     0.150
     0.840    16.493     0.150
     0.936    16.482     0.150
     0.936    29.723     0.150
     1.443    24.043     0.150
     1.443    43.803     0.150
     1.565    26.493     0.150
     1.565    47.843     0.150
     1.569    51.812     0.150
     1.783    31.643     0.150
     1.783    54.843     0.150
     1.804    29.213     0.150
     1.949    31.213     0.150
     1.949    57.043     0.150
     1.949    31.393     0.150
     1.949    54.573     0.150
     2.003    32.383     0.150
     2.003    58.323     0.150
     2.003    54.503     0.150
     2.031    32.083     0.150
     2.381    39.453     0.150
     2.562    42.463     0.150
     2.781    51.473     0.150
     2.746    45.533     0.150
     2.990    47.343     0.150
     3.143    50.022     0.150
     3.398    51.583     0.150
     3.417    53.893     0.150
     3.557    56.003     0.150
     3.557   114.473     0.150
     3.595    54.283     0.150
     3.595    55.743     0.150
     3.595   118.493     0.150
     3.685    57.493     0.150
     3.685   102.843     0.150
     3.693    68.873     0.150
     3.828    59.293     0.150
     4.023    61.913     0.150
     4.216    64.663     0.150
     4.206    64.503     0.150
     4.180    64.963     0.150
     4.470    67.203     0.150
     4.470    89.217     0.150
     4.470   153.042     0.150
     4.523    69.703     0.150
     5.046    79.913     0.150
     5.813    86.493     0.150
     6.074    90.993     0.150
     7.271   109.373     0.150
     7.240   106.333     0.150
     7.655   244.703     0.150
     7.655   114.403     0.150
     8.047   116.917     0.150
     8.047   255.842     0.150
     8.047   117.562     0.150
     8.700   127.713     0.150
     8.796   133.073     0.150
     8.796   297.613     0.150
     8.801   126.699     0.150
     8.801   271.474     0.150
     8.801   128.913     0.150
     9.423   309.953     0.150
    10.104   329.753     0.150
    11.018   358.423     0.150
    10.973   156.883     0.150
    11.842   173.062     0.150
    13.403   195.677     0.150
    13.403   433.173     0.150
    15.196   216.053     0.150
    15.225   217.022     0.150
    15.316   215.593     0.150
    15.394   217.573     0.150
    15.399   219.793     0.150
    15.498   217.213     0.150
    15.507   221.343     0.150
    15.531   222.453     0.150
    15.556   221.873     0.150
    15.677   225.013     0.150
    15.718   223.533     0.150
    15.863   221.863     0.150
    17.884   247.893     0.150
    18.650   262.142     0.150
    20.643   280.793     0.150
    20.964   283.403     0.150
    21.088   285.413     0.150
    22.316   297.272     0.150
    22.627   300.613     0.150
    23.436   311.022     0.150
    24.259   318.343     0.150
    24.499   322.598     0.150
    25.011   324.073     0.150
    25.844   330.867     0.150
    32.737   395.848     0.150
    33.415   402.763     0.150
    40.678   463.623     0.150
    40.678   462.533     0.150
    41.933   473.173     0.150
    43.668   487.223     0.150
    83.458   750.843     0.150
    85.018   757.719     0.150
    98.159   820.423     0.150
     0.562    11.160     0.150
     0.562    18.293     0.150
     0.926    17.570     0.150
     0.926    30.512     0.150
     0.932    16.859     0.150
     0.932    28.711     0.150
     0.932    30.859     0.150
     1.398    24.820     0.150
     1.398    43.691     0.150
     1.471    24.973     0.150
     1.471    45.191     0.150
     1.652    30.441     0.150
     1.652    51.961     0.150
     1.711    29.020     0.150
     1.711    52.211     0.150
     1.711    29.859     0.150
     1.833    32.051     0.150
     1.833    56.332     0.150
     1.863    35.250     0.150
     1.863    59.352     0.150
     1.888    31.660     0.150
     1.888    31.512     0.150
     1.888    54.641     0.150
     1.952    32.293     0.150
     1.952    54.883     0.150
     1.966    32.781     0.150
     1.966    58.793     0.150
     2.239    37.852     0.150
     2.317    38.602     0.150
     2.591    44.609     0.150
     2.591    41.223     0.150
     2.591    72.250     0.150
     2.677    46.262     0.150
     2.864    50.953     0.150
     2.896    46.852     0.150
     3.199    50.641     0.150
     3.199    49.883     0.150
     3.199    85.691     0.150
     3.307    51.820     0.150
     3.337    52.332     0.150
     3.489    54.871     0.150
     3.489    54.980     0.150
     3.489    97.602     0.150
     3.529    55.703     0.150
     3.529    55.871     0.150
     3.529    55.250     0.150
     3.529    95.453     0.150
     3.678    63.160     0.150
     3.678    99.312     0.150
     3.706    57.820     0.150
     3.706   102.520     0.150
     3.756    58.070     0.150
     3.930    61.082     0.150
     4.047    63.000     0.150
     4.113    63.711     0.150
     4.143    65.359     0.150
     4.144    64.070     0.150
     4.388    69.262     0.150
     4.388    67.840     0.150
     4.388    66.711     0.150
     4.388    83.371     0.150
     4.388   145.273     0.150
     4.440    67.902     0.150
     4.442    68.051     0.150
     5.034    77.070     0.150
     5.034   132.590     0.150
     5.628    81.293     0.150
     5.767    86.891     0.150
     5.985    90.410     0.150
     7.435   110.551     0.150
     7.435   110.680     0.150
     7.639   113.180     0.150
     7.701   115.812     0.150
     7.701   117.133     0.150
     7.701   116.582     0.150
     7.985   117.312     0.150
     7.985   209.477     0.150
     7.985   251.109     0.150
     7.985   117.582     0.150
     7.985   117.941     0.150
     7.985   118.180     0.150
     7.985   116.820     0.150
     7.985   117.230     0.150
     8.540   127.602     0.150
     8.780   128.711     0.150
     8.801   128.812     0.150
     8.802   128.633     0.150
     8.802   226.805     0.150
     8.802   271.801     0.150
     8.838   129.332     0.150
     8.985   131.840     0.150
     9.306   136.902     0.150
     9.332   137.051     0.150
     9.336   139.328     0.150
     9.336   299.270     0.150
     9.336   137.910     0.150
    10.098   147.211     0.150
    10.414   152.012     0.150
    10.650   154.270     0.150
    10.924   160.145     0.150
    10.924   345.520     0.150
    10.959   159.102     0.150
    11.377   164.781     0.150
    11.441   165.512     0.150
    11.561   168.781     0.150
    12.269   177.422     0.150
    12.269   180.770     0.150
    13.294   190.531     0.150
    13.312   188.281     0.150
    13.312   192.684     0.150
    13.312   421.152     0.150
    13.312   190.480     0.150
    13.566   196.332     0.150
    13.882   200.062     0.150
    13.914   199.402     0.150
    14.003   201.820     0.150
    14.069   201.770     0.150
    14.801   211.062     0.150
    14.850   217.660     0.150
    14.930   213.012     0.150
    14.941   213.223     0.150
    15.020   213.680     0.150
    15.549   221.551     0.150
    15.549   222.820     0.150
    15.549   221.980     0.150
    15.676   223.711     0.150
    15.824   224.410     0.150
    16.019   227.953     0.150
    16.193   228.750     0.150
    16.193   232.391     0.150
    16.244   230.602     0.150
    16.317   232.461     0.150
    16.633   234.891     0.150
    16.636   235.383     0.150
    16.909   237.980     0.150
    17.629   247.570     0.150
    17.701   250.250     0.150
    18.556   259.301     0.150
    19.123   264.520     0.150
    19.203   265.141     0.150
    19.227   264.953     0.150
    19.443   270.680     0.150
    19.930   274.742     0.150
    19.976   273.250     0.150
    20.350   278.691     0.150
    20.350   280.320     0.150
    20.549   279.320     0.150
    20.954   286.230     0.150
    21.012   285.141     0.150
    21.105   286.871     0.150
    21.439   286.379     0.150
    21.540   290.859     0.150
    22.117   298.102     0.150
    22.130   297.020     0.150
    22.268   298.270     0.150
    22.512   300.660     0.150
    22.588   303.180     0.150
    22.591   303.793     0.150
    22.591   303.051     0.150
    22.591   304.891     0.150
    22.591   304.082     0.150
    22.627   303.703     0.150
    22.676   304.102     0.150
    22.963   307.781     0.150
    22.963   307.082     0.150
    24.174   318.270     0.150
    24.174   319.840     0.150
    24.174   319.180     0.150
    24.213   319.133     0.150
    24.417   320.527     0.150
    24.417   319.852     0.150
    24.417   320.883     0.150
    24.674   321.961     0.150
    24.877   324.910     0.150
    24.877   326.320     0.150
    24.931   324.832     0.150
    25.987   336.082     0.150
    26.072   334.332     0.150
    26.256   336.520     0.150
    26.256   338.270     0.150
    26.256   337.582     0.150
    26.410   338.383     0.150
    26.592   340.340     0.150
    27.115   344.621     0.150
    29.064   364.980     0.150
    29.376   364.832     0.150
    29.412   364.910     0.150
    31.010   380.051     0.150
    31.010   379.672     0.150
    31.010   381.590     0.150
    32.630   393.512     0.150
    32.643   394.242     0.150
    32.643   559.215     0.150
    32.642   395.180     0.150
    32.675   396.152     0.150
    37.791   438.031     0.150
    37.999   440.062     0.150
    39.172   451.543     0.150
    40.571   461.531     0.150
    40.577   463.281     0.150
    40.577     3.699     0.150
    40.590   461.852     0.150
    40.590   463.383     0.150
    40.590   462.148     0.150
    40.590   583.676     0.150
    40.964   468.191     0.150
    40.997   464.922     0.150
    41.171   468.180     0.150
    41.494   468.582     0.150
    41.509   469.172     0.150
    41.509   470.883     0.150
    41.627   470.109     0.150
    41.843   471.301     0.150
    41.874   471.473     0.150
    42.003   472.980     0.150
    43.580   485.930     0.150
    44.691   497.430     0.150
    44.691   497.891     0.150
    44.744   497.641     0.150
    44.744   499.383     0.150
    46.881   512.762     0.150
    52.424   554.660     0.150
    52.424   555.891     0.150
    55.209   575.781     0.150
    55.786   578.730     0.150
    55.786   579.391     0.150
    57.399   590.211     0.150
    57.399   592.281     0.150
    57.399   591.840     0.150
    62.335   624.383     0.150
    62.335   623.973     0.150
    65.871   648.480     0.150
    65.885   647.047     0.150
    65.885   647.359     0.150
    69.917   672.781     0.150
    69.917   673.082     0.150
    70.945   680.082     0.150
    75.299   705.383     0.150
    76.015   710.480     0.150
    76.589   711.750     0.150
    78.443   723.660     0.150
    78.443   724.582     0.150
    79.867   729.781     0.150
    80.843   736.941     0.150
    80.843   737.082     0.150
    81.343   739.652     0.150
    81.834   744.633     0.150
    81.870   743.543     0.150
    82.014   744.590     0.150
    82.181   747.383     0.150
    82.538   746.723     0.150
    82.610   747.203     0.150
    82.747   748.352     0.150
    82.889   748.270     0.150
    82.963   749.781     0.150
    82.966   749.781     0.150
    83.020   750.691     0.150
    83.063   749.461     0.150
    83.200   750.922     0.150
    83.433   751.930     0.150
    83.448   751.371     0.150
    83.495   751.223     0.150
    83.629   751.180     0.150
    83.715   752.680     0.150
    83.854   752.461     0.150
    84.953   757.281     0.150
    84.953   757.543     0.150
    84.966   757.883     0.150
    84.978   757.590     0.150
    84.978   758.480     0.150
    84.978   757.680     0.150
    84.982   758.383     0.150
    85.576   759.770     0.150
    85.576   760.180     0.150
    85.577   760.312     0.150
    85.577   760.980     0.150
    86.393   764.953     0.150
    86.548   765.680     0.150
    86.599   765.270     0.150
    86.599   765.980     0.150
    87.323   769.742     0.150
    88.629   775.430     0.150
    88.688   775.859     0.150
    88.688   775.141     0.150
    90.633   786.902     0.150
    90.835   786.383     0.150
    91.214   788.305     0.150
    92.733   793.883     0.150
    93.367   797.234     0.150
    93.527   797.980     0.150
    94.384   802.980     0.150
    94.660   804.949     0.150
    94.660   803.543     0.150
    94.998   805.406     0.150
    94.998   804.461     0.150
    99.134   823.980     0.150
    99.134  1064.523     0.150
   104.091   847.383     0.150
   119.711  1132.051     0.150
   120.030  1132.941     0.150
   132.000  1155.680     0.150
     0.569    11.238     0.150
     0.569    19.039     0.150
     0.895    16.988     0.150
     0.895    29.658     0.150
     0.895    16.850     0.150
     0.895    28.818     0.150
     0.921    17.328     0.150
     0.921    29.908     0.150
     1.408    24.828     0.150
     1.408    43.299     0.150
     1.507    45.559     0.150
     1.616    27.010     0.150
     1.616    48.529     0.150
     1.746    27.889     0.150
     1.807    29.969     0.150
     1.807    53.719     0.150
     1.917    54.920     0.150
     1.917    30.078     0.150
     1.987    30.379     0.150
     1.987    54.449     0.150
     1.987    32.719     0.150
     1.987    57.889     0.150
     1.987    32.898     0.150
     1.987    57.139     0.150
     2.270    36.328     0.150
     2.347    37.029     0.150
     2.572    41.139     0.150
     2.572    38.369     0.150
     2.572    70.578     0.150
     2.856    46.479     0.150
     2.856    50.709     0.150
     2.856    75.158     0.150
     2.856    78.709     0.150
     2.709    44.559     0.150
     2.828    46.709     0.150
     2.828    83.658     0.150
     2.828    49.270     0.150
     2.828    50.039     0.150
     2.932    45.469     0.150
     3.228    50.328     0.150
     3.171    50.078     0.150
     3.171    49.549     0.150
     3.171    86.318     0.150
     3.344    51.930     0.150
     3.372    52.850     0.150
     3.520   102.539     0.150
     3.549    54.488     0.150
     3.549    55.578     0.150
     3.549    90.539     0.150
     3.611    58.559     0.150
     3.611    97.520     0.150
     3.676    99.260     0.150
     3.676    62.158     0.150
     3.690    56.750     0.150
     3.690   100.350     0.150
     3.788    58.109     0.150
     3.967    59.939     0.150
     4.148    62.850     0.150
     4.176    62.869     0.150
     4.150    63.568     0.150
     4.424    66.209     0.150
     4.424    69.033     0.150
     4.424    86.107     0.150
     4.464    66.828     0.150
     4.469    68.078     0.150
     4.868    72.760     0.150
     4.979    75.629     0.150
     5.031    76.148     0.150
     5.031   130.959     0.150
     5.258    77.479     0.150
     5.287    78.969     0.150
     5.353    80.879     0.150
     5.603    82.680     0.150
     5.603   153.809     0.150
     5.694    84.939     0.150
     5.688    84.760     0.150
     5.779    87.129     0.150
     5.928   158.180     0.150
     7.076   104.619     0.150
     7.505   106.119     0.150
     7.438   110.078     0.150
     7.438   110.689     0.150
     7.438   110.238     0.150
     7.637   111.430     0.150
     7.638   111.189     0.150
     7.681   111.379     0.150
     7.681   116.898     0.150
     7.681   113.340     0.150
     7.681   116.639     0.150
     7.707   199.078     0.150
     8.003   117.783     0.150
     8.003   208.084     0.150
     8.003   253.232     0.150
     8.003   115.898     0.150
     8.003   118.279     0.150
     8.003   117.939     0.150
     8.003   115.898     0.150
     8.568   126.760     0.150
     8.683   126.898     0.150
     8.793   129.340     0.150
     8.794   128.551     0.150
     8.794   269.340     0.150
     8.820   126.238     0.150
    10.093   146.779     0.150
    10.961   162.139     0.150
    10.929   276.109     0.150
    10.957   155.869     0.150
    11.838   168.648     0.150
    12.070   310.789     0.150
    12.070   169.719     0.150
    12.243   305.609     0.150
    12.373   177.279     0.150
    12.587   178.020     0.150
    12.797   181.930     0.150
    12.875   325.328     0.150
    13.346   193.738     0.150
    13.346   417.641     0.150
    13.328   187.908     0.150
    13.574   196.039     0.150
    13.606   348.670     0.150
    13.734   191.898     0.150
    13.768   192.559     0.150
    14.489   203.709     0.150
    14.686   205.898     0.150
    14.686   374.859     0.150
    14.692   370.510     0.150
    14.692   204.389     0.150
    15.134   211.520     0.150
    15.164   213.760     0.150
    15.194   213.309     0.150
    15.397   215.449     0.150
    15.476   217.479     0.150
    15.544   218.738     0.150
    15.544   222.430     0.150
    15.685   220.818     0.150
    16.223   231.680     0.150
    16.253   228.270     0.150
    16.324   228.869     0.150
    17.706   248.789     0.150
    18.176   251.029     0.150
    18.593   260.684     0.150
    18.593   261.209     0.150
    19.313   264.229     0.150
    19.466   265.090     0.150
    19.466   270.459     0.150
    20.260   273.209     0.150
    20.362   275.389     0.150
    20.362   280.129     0.150
    20.940   281.559     0.150
    20.954   281.439     0.150
    21.290   285.309     0.150
    21.413   290.158     0.150
    22.133   294.389     0.150
    22.261   295.818     0.150
    22.602   298.619     0.150
    22.598   301.109     0.150
    22.598   304.729     0.150
    22.598   305.539     0.150
    22.632   299.750     0.150
    22.895   302.600     0.150
    22.924   302.420     0.150
    22.990   307.379     0.150
    23.378   306.719     0.150
    24.184   319.629     0.150
    24.224   315.068     0.150
    24.237   316.328     0.150
    24.445   320.514     0.150
    24.445   321.639     0.150
    26.289   338.049     0.150
    26.907   342.469     0.150
    31.022   376.789     0.150
    31.022   380.879     0.150
    31.526   380.398     0.150
    32.679   394.439     0.150
    33.378   397.328     0.150
    40.234   455.539     0.150
    40.627   463.217     0.150
    42.717   475.818     0.150
    43.617   484.250     0.150
    44.722   495.113     0.150
    46.915   510.119     0.150
    52.453   555.500     0.150
    63.527   631.814     0.150
    65.072   640.578     0.150
    65.294   645.789     0.150
    65.918   648.465     0.150
    68.889   666.568     0.150
    70.428   678.398     0.150
    74.554   700.299     0.150
    77.224   717.430     0.150
    80.808   735.639     0.150
    81.307   739.789     0.150
    83.400   747.811     0.150
    84.973   757.383     0.150
    85.606   761.006     0.150
    88.562   775.340     0.150
    88.606   775.523     0.150
    90.661   785.016     0.150
    93.398   796.238     0.150
    98.115   816.139     0.150
     0.569    11.100     0.150
     0.569    19.590     0.150
     0.867    16.730     0.150
     0.867    27.811     0.150
     0.867    28.051     0.150
     0.925    17.119     0.150
     0.925    29.801     0.150
     1.423    24.830     0.150
     1.423    44.680     0.150
     1.536    25.311     0.150
     1.536    46.340     0.150
     1.591    28.350     0.150
     1.591    49.100     0.150
     1.792    30.930     0.150
     1.792    53.850     0.150
     1.935    31.301     0.150
     1.935    53.830     0.150
     2.010    30.830     0.150
     2.010    54.381     0.150
     1.997    32.561     0.150
     1.997    58.670     0.150
     1.997    32.400     0.150
     1.997    57.160     0.150
     2.564    37.850     0.150
     2.564    70.109     0.150
     2.882    48.600     0.150
     3.155    46.510     0.150
     3.155    87.801     0.150
     3.540    55.270     0.150
     3.540   103.109     0.150
     3.570    60.590     0.150
     3.570    95.770     0.150
     3.632    53.291     0.150
     3.682    56.750     0.150
     3.682    96.180     0.150
     3.685    56.770     0.150
     3.685   101.369     0.150
     4.448    75.250     0.150
     4.448    90.725     0.150
     4.448   152.574     0.150
     5.589    82.480     0.150
     5.589   140.949     0.150
     7.672   198.430     0.150
     8.023   117.799     0.150
     8.023   208.273     0.150
     8.023   253.875     0.150
     8.794   125.305     0.150
     8.794   263.287     0.150
    13.374   194.332     0.150
    18.622   261.600     0.150
    24.471   319.855     0.150
    40.654   463.180     0.150
     0.570    11.258     0.150
     0.570    20.059     0.150
     0.849    15.938     0.150
     0.849    27.348     0.150
     0.849    16.785     0.150
     0.849    28.816     0.150
     0.928    17.418     0.150
     0.928    29.516     0.150
     1.433    25.258     0.150
     1.433    43.918     0.150
     1.576    27.508     0.150
     1.576    48.227     0.150
     1.783    30.828     0.150
     1.783    53.938     0.150
     1.792    29.746     0.150
     1.946    31.918     0.150
     1.946    55.488     0.150
     2.004    32.938     0.150
     2.004    59.137     0.150
     2.004    55.277     0.150
     2.025    32.797     0.150
     2.025    55.488     0.150
     2.560    39.848     0.150
     2.560    70.926     0.150
     2.788    45.578     0.150
     2.788    82.137     0.150
     3.145    50.535     0.150
     3.145    87.105     0.150
     3.583    55.676     0.150
     3.583    95.738     0.150
     3.553    56.406     0.150
     3.685   102.668     0.150
     5.038    79.047     0.150
     5.038   132.715     0.150
     5.580   146.586     0.150
     0.575    11.328     0.150
     0.895    16.768     0.150
     0.895    30.078     0.150
     0.895    17.479     0.150
     0.895    29.129     0.150
     0.915    17.367     0.150
     0.915    30.338     0.150
     1.403    25.248     0.150
     1.403    44.059     0.150
     1.614    29.418     0.150
     1.614    52.488     0.150
     1.744    29.178     0.150
     1.921    31.918     0.150
     1.921    55.289     0.150
     1.802    32.588     0.150
     1.802    57.299     0.150
     1.990    31.607     0.150
     1.990    57.549     0.150
     1.992    32.969     0.150
     1.992    57.459     0.150
     2.567    44.117     0.150
     2.567    74.527     0.150
     2.826    47.438     0.150
     2.826    83.639     0.150
     2.826    47.277     0.150
     2.826    77.488     0.150
     3.167    51.838     0.150
     3.167    91.928     0.150
     3.167    53.697     0.150
     3.167    86.229     0.150
     3.524    55.758     0.150
     3.524    98.219     0.150
     3.544    55.768     0.150
     3.544    95.898     0.150
     3.670    63.039     0.150
     3.670   103.988     0.150
     3.684    58.697     0.150
     3.981    63.508     0.150
     3.981   113.357     0.150
     4.426    87.521     0.150
     5.024    78.158     0.150
     5.024   136.527     0.150
     5.598    86.688     0.150
     5.598   150.068     0.150
     7.998   119.771     0.150
     7.998   209.297     0.150
     7.998   254.748     0.150
     8.788   128.490     0.150
     8.788   268.979     0.150
     9.374   141.617     0.150
    13.343   195.018     0.150
    40.628   463.404     0.150
     0.595    11.688     0.150
     0.595    20.388     0.150
     0.956    17.048     0.150
     0.956    30.228     0.150
     1.147    20.708     0.150
     1.147    36.538     0.150
     1.147    20.968     0.150
     1.147    34.598     0.150
     1.259    22.738     0.150
     1.259    39.788     0.150
     1.331    23.908     0.150
     1.331    41.268     0.150
     1.502    26.468     0.150
     1.744    29.418     0.150
     1.744    52.818     0.150
     1.744    30.408     0.150
     1.744    52.048     0.150
     1.851    32.398     0.150
     1.851    56.308     0.150
     1.879    31.818     0.150
     1.879    56.468     0.150
     1.879    55.388     0.150
     1.972    34.058     0.150
     1.972    59.978     0.150
     2.683    43.868     0.150
     2.683    77.768     0.150
     2.683    42.908     0.150
     2.683    72.668     0.150
     3.347    53.768     0.150
     3.347    93.948     0.150
     3.347    51.318     0.150
     3.347    88.718     0.150
     3.397    51.598     0.150
     3.397    94.087     0.150
     3.414    53.208     0.150
     3.414    92.978     0.150
     3.669    59.038     0.150
     3.669    97.548     0.150
     3.779    58.978     0.150
     3.779   104.138     0.150
     0.585    11.484     0.150
     0.585    19.645     0.150
     0.951    17.234     0.150
     0.951    29.764     0.150
     1.117    20.074     0.150
     1.117    34.964     0.150
     1.117    20.694     0.150
     1.117    34.814     0.150
     1.289    23.094     0.150
     1.289    40.044     0.150
     1.340    23.874     0.150
     1.340    41.764     0.150
     1.531    26.904     0.150
     1.531    46.674     0.150
     1.762    29.964     0.150
     1.762    52.104     0.150
     1.762    49.134     0.150
     1.792    29.225     0.150
     1.792    50.554     0.150
     1.888    31.794     0.150
     1.888    52.804     0.150
     1.824    31.435     0.150
     1.824    55.104     0.150
     1.953    33.194     0.150
     1.953    59.274     0.150
     2.671    43.534     0.150
     2.671    76.444     0.150
     2.671    43.725     0.150
     2.671    79.114     0.150
     3.347    51.574     0.150
     3.347    89.914     0.150
     3.435    54.264     0.150
     3.435    90.274     0.150
     3.328    53.225     0.150
     3.328    92.554     0.150
     3.328    51.304     0.150
     3.328    88.034     0.150
     3.415    53.514     0.150
     3.415   101.254     0.150
     3.770    58.904     0.150
     3.770   103.054     0.150
     0.578    11.477     0.150
     0.578    19.438     0.150
     0.911    17.484     0.150
     0.911    30.477     0.150
     1.375    24.367     0.150
     1.375    42.297     0.150
     1.447    24.359     0.150
     1.447    42.805     0.150
     1.685    28.078     0.150
     1.685    49.461     0.150
     1.685    28.555     0.150
     1.685    50.406     0.150
     1.666    30.336     0.150
     1.666    54.180     0.150
     1.884    31.414     0.150
     1.884    55.039     0.150
     1.884    54.609     0.150
     1.941    30.758     0.150
     1.941    54.898     0.150
     1.834    32.039     0.150
     1.834    56.477     0.150
     1.970    32.781     0.150
     1.970    57.977     0.150
     1.970    33.055     0.150
     1.970    58.547     0.150
     1.888    33.086     0.150
     1.888    59.070     0.150
     2.212    36.570     0.150
     2.312    38.375     0.150
     2.312    68.086     0.150
     2.585    42.336     0.150
     2.585    76.039     0.150
     2.585    41.109     0.150
     2.585    69.719     0.150
     2.805    46.055     0.150
     2.805    74.805     0.150
     2.872    45.656     0.150
     2.878    46.750     0.150
     2.878    82.477     0.150
     2.878    83.531     0.150
     2.878    47.500     0.150
     2.878    49.406     0.150
     3.288    51.328     0.150
     3.202    50.164     0.150
     3.202    88.164     0.150
     3.202    48.531     0.150
     3.202    85.938     0.150
     3.325    52.438     0.150
     3.482    95.055     0.150
     3.482    53.984     0.150
     3.502    55.219     0.150
     3.502    90.406     0.150
     3.572    55.656     0.150
     3.572    98.250     0.150
     3.660    56.586     0.150
     3.660   102.859     0.150
     3.660    95.797     0.150
     3.747    57.891     0.150
     3.698    57.766     0.150
     3.698   103.227     0.150
     4.016    63.156     0.150
     4.016   112.500     0.150
     4.121    63.852     0.150
     4.375    67.367     0.150
     4.375    69.102     0.150
     4.375    83.680     0.150
     4.375   141.555     0.150
     4.421    67.984     0.150
     4.395    67.352     0.150
     4.395   119.508     0.150
     4.839    73.156     0.150
     5.017    74.867     0.150
     5.017   132.109     0.150
     5.227    79.125     0.150
     5.305    80.852     0.150
     5.634    84.891     0.150
     5.744    87.500     0.150
     5.958    87.695     0.150
     5.986    88.219     0.150
     6.705    98.117     0.150
     6.743   100.688     0.150
     7.155   106.570     0.150
     7.348   106.648     0.150
     7.556   110.406     0.150
     7.622   112.289     0.150
     7.959   116.055     0.150
     7.959   204.477     0.150
     7.959   245.875     0.150
     7.959   117.398     0.150
     8.776   126.961     0.150
     8.764   127.734     0.150
     8.787   129.109     0.150
     8.788   129.586     0.150
     8.788   271.203     0.150
     8.788   129.305     0.150
     8.845   131.047     0.150
     8.845   232.328     0.150
     9.320   134.875     0.150
    10.902   159.133     0.150
    12.578   180.055     0.150
    13.286   191.961     0.150
    18.535   260.680     0.150
    20.221   273.914     0.150
    20.525   277.117     0.150
    21.084   285.055     0.150
    21.439   288.430     0.150
    22.225   297.836     0.150
    22.485   298.898     0.150
    22.569   302.117     0.150
    22.889   305.195     0.150
    22.935   304.297     0.150
    23.318   308.688     0.150
    23.997   315.688     0.150
    24.091   317.188     0.150
    24.212   315.555     0.150
    24.389   319.930     0.150
    24.652   320.047     0.150
    24.903   322.008     0.150
    32.619   393.805     0.150
    32.619   560.305     0.150
    37.774   436.852     0.150
    38.900   446.531     0.150
    40.283   458.961     0.150
    40.573   463.258     0.150
    40.573   459.641     0.150
    41.986   471.656     0.150
    42.665   477.484     0.150
    43.393   483.109     0.150
    46.141   505.484     0.150
    46.855   511.617     0.150
    49.834   532.375     0.150
    52.429   552.398     0.150
    56.847   584.664     0.150
    67.360   655.781     0.150
    70.694   677.078     0.150
    80.856   737.156     0.150
    80.856   734.977     0.150
    83.341   749.453     0.150
    84.927   758.008     0.150
    94.645   804.898     0.150
    98.068   817.055     0.150
   144.682  1177.805     0.150
     0.581    11.344     0.150
     0.581    20.336     0.150
     0.907    16.648     0.150
     0.907    28.273     0.150
     0.956    17.500     0.150
     0.956    30.070     0.150
     1.370    24.805     0.150
     1.370    41.961     0.150
     1.443    25.523     0.150
     1.443    44.453     0.150
     1.681    29.375     0.150
     1.681    51.172     0.150
     1.667    28.898     0.150
     1.667    49.805     0.150
     1.884    32.844     0.150
     1.884    57.805     0.150
     1.833    31.305     0.150
     1.833    54.984     0.150
     1.940    51.523     0.150
     1.972    58.984     0.150
     1.972    31.250     0.150
     1.972    56.250     0.150
     2.583    41.742     0.150
     2.583    73.453     0.150
     3.202    50.539     0.150
     3.202    88.992     0.150
     3.482    89.469     0.150
     3.572    94.273     0.150
     3.656    55.422     0.150
     3.656    96.094     0.150
     3.695    57.219     0.150
     0.573    11.227     0.150
     0.573    18.586     0.150
     0.890    17.164     0.150
     0.890    29.930     0.150
     0.890    15.539     0.150
     0.890    26.656     0.150
     0.917    16.578     0.150
     0.917    29.188     0.150
     1.407    24.242     0.150
     1.407    42.414     0.150
     1.511    23.992     0.150
     1.511    43.008     0.150
     1.610    28.617     0.150
     1.610    50.148     0.150
     1.749    28.289     0.150
     1.749    50.305     0.150
     1.800    31.547     0.150
     1.923    31.078     0.150
     1.923    31.336     0.150
     1.993    32.156     0.150
     1.993    57.367     0.150
     1.993    32.773     0.150
     1.993    30.766     0.150
     2.273    36.484     0.150
     2.353    36.898     0.150
     2.567    39.453     0.150
     2.567    41.734     0.150
     2.567    73.242     0.150
     2.862    43.438     0.150
     2.715    44.234     0.150
     2.937    45.617     0.150
     3.234    49.297     0.150
     3.165    49.992     0.150
     3.165    89.195     0.150
     3.165    49.414     0.150
     3.350    51.156     0.150
     3.378    52.797     0.150
     3.527    53.773     0.150
     3.618    53.555     0.150
     3.549    54.109     0.150
     3.549    53.883     0.150
     3.685    57.117     0.150
     3.795    57.664     0.150
     3.902    59.258     0.150
     3.972    60.734     0.150
     4.183    64.156     0.150
     4.152    63.117     0.150
     4.430    87.203     0.150
     4.430   133.203     0.150
     4.483    68.227     0.150
     4.986    74.695     0.150
     5.777    86.008     0.150
     7.435   109.328     0.150
     7.634   111.617     0.150
     7.715   112.773     0.150
     8.003   116.906     0.150
     8.003   257.531     0.150
     8.003   116.406     0.150
     8.679   126.180     0.150
     8.788   126.828     0.150
     8.789   127.742     0.150
    10.966   161.383     0.150
    13.349   194.273     0.150
    13.724   195.062     0.150
    15.342   217.109     0.150
    15.405   217.523     0.150
    15.457   218.008     0.150
    15.474   218.492     0.150
    15.540   218.398     0.150
    15.495   218.547     0.150
    15.676   221.297     0.150
    15.683   224.055     0.150
    15.835   222.125     0.150
    15.830   220.344     0.150
    15.954   223.625     0.150
    16.225   230.562     0.150
    16.251   228.062     0.150
    16.254   227.477     0.150
    16.639   233.125     0.150
    16.870   236.383     0.150
    17.704   247.508     0.150
    18.598   260.727     0.150
    24.447   320.312     0.150
    32.684   394.133     0.150
    40.633   461.688     0.150
     0.566    11.256     0.150
     0.566    19.186     0.150
     0.922    17.055     0.150
     0.922    29.375     0.150
     0.914    17.506     0.150
     0.914    30.736     0.150
     0.914    17.385     0.150
     1.402    24.666     0.150
     1.402    42.166     0.150
     1.489    24.945     0.150
     1.489    43.525     0.150
     1.728    28.615     0.150
     1.728    50.156     0.150
     1.634    29.045     0.150
     1.634    50.545     0.150
     1.819    30.295     0.150
     1.819    55.656     0.150
     1.903    31.676     0.150
     1.903    56.086     0.150
     1.903    53.826     0.150
     1.970    30.955     0.150
     1.970    54.756     0.150
     1.977    33.055     0.150
     1.977    58.035     0.150
     1.977    32.705     0.150
     1.977    55.346     0.150
     2.581    40.525     0.150
     2.581    74.896     0.150
     2.581    39.506     0.150
     2.581    67.285     0.150
     3.185    50.506     0.150
     3.185    50.355     0.150
     3.185    88.516     0.150
     3.505    55.385     0.150
     3.538    55.166     0.150
     3.538    99.045     0.150
     3.676    57.865     0.150
     3.676    59.406     0.150
     3.697    57.055     0.150
     5.031    74.625     0.150
     5.031   133.785     0.150
     5.615    83.055     0.150
     5.615   145.945     0.150
     0.557    11.066     0.150
     0.557    19.078     0.150
     0.931    17.168     0.150
     0.931    29.727     0.150
     0.935    16.906     0.150
     0.935    30.309     0.150
     0.935    17.879     0.150
     0.935    29.648     0.150
     1.470    26.156     0.150
     1.470    46.078     0.150
     1.656    28.117     0.150
     1.656    51.457     0.150
     1.882    31.668     0.150
     1.882    54.668     0.150
     1.838    32.629     0.150
     1.838    56.207     0.150
     1.948    31.148     0.150
     1.864    32.449     0.150
     1.864    57.496     0.150
     1.960    32.629     0.150
     1.960    55.699     0.150
     2.596    40.836     0.150
     2.596    72.457     0.150
     2.868    52.168     0.150
     3.205    51.719     0.150
     3.205    49.938     0.150
     3.205    90.238     0.150
     3.484    51.988     0.150
     3.484    96.777     0.150
     3.532    55.746     0.150
     3.532    98.637     0.150
     3.683    58.508     0.150
     3.683   102.199     0.150
     3.683    63.898     0.150
     3.683    95.699     0.150
     3.711    58.039     0.150
     3.711   103.406     0.150
     5.039    77.109     0.150
     5.039   135.520     0.150
     5.634    82.477     0.150
     5.634   149.488     0.150
     0.543    10.672     0.150
     0.543    18.621     0.150
     0.927    17.203     0.150
     0.927    30.262     0.150
     0.927    17.801     0.150
     0.927    31.230     0.150
     0.945    16.703     0.150
     0.945    29.410     0.150
     1.482    25.613     0.150
     1.482    45.312     0.150
     1.653    29.230     0.150
     1.653    51.973     0.150
     1.879    31.582     0.150
     1.879    53.242     0.150
     1.843    32.113     0.150
     1.843    56.992     0.150
     1.949    31.453     0.150
     1.949    57.082     0.150
     1.952    32.852     0.150
     1.952    56.570     0.150
     2.606    43.082     0.150
     2.606    80.160     0.150
     2.865    47.773     0.150
     2.865    84.531     0.150
     3.209    51.594     0.150
     3.209    91.801     0.150
     3.573    57.992     0.150
     3.573    95.570     0.150
     3.698    58.504     0.150
     3.698   102.871     0.150
     3.698    59.742     0.150
     3.698    98.801     0.150
     3.722    58.863     0.150
     3.722   104.082     0.150
     4.386    86.199     0.150
     4.386   149.875     0.150
     8.005   117.676     0.150
     8.005   209.652     0.150
     8.005   253.926     0.150
     8.820   128.031     0.150
     8.820   269.883     0.150
     9.337   140.258     0.150
    10.931   160.855     0.150
    13.325   193.734     0.150
    32.651   395.258     0.150
    40.592   463.230     0.150
     0.471     9.438     0.150
     0.471    16.031     0.150
     0.824    15.742     0.150
     0.824    27.367     0.150
     1.045    18.922     0.150
     1.045    33.711     0.150
     1.555    27.180     0.150
     1.555    47.453     0.150
     1.586    28.234     0.150
     1.586    49.461     0.150
     1.621    27.461     0.150
     1.621    49.602     0.150
     1.714    30.430     0.150
     1.714    53.297     0.150
     1.851    32.602     0.150
     1.851    56.734     0.150
     1.866    31.148     0.150
     1.866    56.461     0.150
     1.904    32.328     0.150
     1.904    57.250     0.150
     1.904    32.188     0.150
     1.929    31.852     0.150
     1.929    58.297     0.150
     1.929    31.992     0.150
     1.929    55.414     0.150
     2.016    32.414     0.150
     2.016    56.969     0.150
     2.650    43.289     0.150
     2.650    77.180     0.150
     2.650    41.781     0.150
     2.650    72.852     0.150
     2.793    45.680     0.150
     2.793    81.758     0.150
     2.793    52.102     0.150
     2.793    76.758     0.150
     3.202    51.297     0.150
     3.202    89.391     0.150
     3.614    54.070     0.150
     3.614    95.914     0.150
     3.700    57.430     0.150
     3.777    58.930     0.150
     3.777   104.773     0.150
     4.458    76.586     0.150
     4.458    88.656     0.150
     4.458   147.281     0.150
     5.646    84.242     0.150
     8.155   120.531     0.150
     8.155   254.461     0.150
     8.904   132.844     0.150
     8.904   274.602     0.150
    11.053   163.844     0.150
     0.571    11.148     0.150
     0.571    20.031     0.150
     0.877    16.375     0.150
     0.877    28.391     0.150
     0.921    16.859     0.150
     0.921    28.984     0.150
     1.416    24.945     0.150
     1.416    43.438     0.150
     1.599    28.586     0.150
     1.599    49.352     0.150
     1.763    30.625     0.150
     1.763    53.664     0.150
     1.796    31.320     0.150
     1.796    53.727     0.150
     1.929    31.727     0.150
     1.929    54.117     0.150
     2.003    30.828     0.150
     2.003    54.836     0.150
     1.995    34.438     0.150
     1.995    62.086     0.150
     1.995    31.078     0.150
     1.995    53.180     0.150
     2.565    42.039     0.150
     2.565    73.727     0.150
     2.565    43.859     0.150
     2.565    70.969     0.150
     3.159    52.805     0.150
     3.159    92.969     0.150
     3.561    57.352     0.150
     3.561    94.820     0.150
     3.534    55.789     0.150
     3.534    94.195     0.150
     3.677    57.578     0.150
     3.677    58.898     0.150
     3.684    57.711     0.150
     5.031   148.031     0.150
     5.592    86.461     0.150
     5.592   150.586     0.150
     0.540    10.719     0.150
     0.540    17.979     0.150
     0.958    17.149     0.150
     0.958    29.919     0.150
     1.460    24.669     0.150
     1.460    42.819     0.150
     1.559    25.279     0.150
     1.559    44.139     0.150
     1.589    29.019     0.150
     1.589    51.359     0.150
     1.799    28.949     0.150
     1.799    50.849     0.150
     1.808    31.769     0.150
     1.808    56.249     0.150
     1.925    31.949     0.150
     1.925    56.719     0.150
     1.925    29.949     0.150
     1.925    54.079     0.150
     1.978    33.149     0.150
     1.978    58.369     0.150
     2.011    29.449     0.150
     2.011    55.979     0.150
     2.588    42.269     0.150
     2.588    74.459     0.150
     2.588    40.319     0.150
     2.588    69.269     0.150
     2.800    44.989     0.150
     2.800    76.739     0.150
     3.168    50.709     0.150
     3.168    89.099     0.150
     3.168    46.719     0.150
     3.168    86.059     0.150
     3.534    53.919     0.150
     3.534    99.099     0.150
     3.626    51.529     0.150
     3.626    97.749     0.150
     3.606    55.249     0.150
     3.606   101.409     0.150
     3.710    58.109     0.150
     3.710   103.529     0.150
     3.715    57.049     0.150
     3.715   100.959     0.150
     4.450    69.673     0.150
     4.450    87.223     0.150
     8.059   117.698     0.150
     8.059   259.223     0.150
     8.824   129.129     0.150
     8.824   270.837     0.150
     9.406   140.304     0.150
    18.638   260.836     0.150
    24.503   321.554     0.150
    32.728   394.523     0.150
    40.662   463.188     0.150
     0.559    11.094     0.150
     0.559    18.874     0.150
     0.860    16.354     0.150
     0.860    17.024     0.150
     0.936    17.184     0.150
     0.936    30.134     0.150
     1.436    24.464     0.150
     1.436    43.934     0.150
     1.545    27.894     0.150
     1.545    49.414     0.150
     1.589    30.604     0.150
     1.589    51.404     0.150
     1.796    31.904     0.150
     1.796    55.574     0.150
     1.933    31.814     0.150
     1.933    55.044     0.150
     1.991    57.024     0.150
     1.991    32.724     0.150
     1.991    57.144     0.150
     2.012    31.004     0.150
     2.012    54.704     0.150
     2.571    40.064     0.150
     2.571    70.494     0.150
     2.801    45.664     0.150
     2.801    78.344     0.150
     3.158    49.424     0.150
     3.158    87.474     0.150
     3.540    57.014     0.150
     3.540    97.374     0.150
     3.583    56.344     0.150
     3.583   114.154     0.150
     3.631    57.324     0.150
     3.631    99.794     0.150
     0.624    12.245     0.150
     0.952    18.104     0.150
     0.952    32.465     0.150
     1.650    28.885     0.150
     1.650    50.645     0.150
     1.674    30.335     0.150
     1.674    53.125     0.150
     1.674    30.024     0.150
     1.799    33.045     0.150
     1.799    57.215     0.150
     1.917    33.265     0.150
     1.917    58.015     0.150
     1.917    33.035     0.150
     1.964    32.115     0.150
     1.964    56.255     0.150
     2.011    34.104     0.150
     2.011    59.385     0.150
     2.011    33.555     0.150
     2.011    58.895     0.150
     2.343    38.995     0.150
     2.543    41.645     0.150
     2.543    40.395     0.150
     2.700    43.995     0.150
     2.868    44.435     0.150
     2.862    45.975     0.150
     2.862    47.825     0.150
     2.862    77.575     0.150
     3.169    50.145     0.150
     3.169    88.685     0.150
     3.227    49.075     0.150
     3.296    50.104     0.150
     3.346    50.745     0.150
     3.511    53.774     0.150
     3.511    97.595     0.150
     3.466    54.095     0.150
     3.466    54.325     0.150
     3.466    94.705     0.150
     3.601    56.395     0.150
     3.614    58.295     0.150
     3.614    98.024     0.150
     3.774    57.064     0.150
     3.888    60.285     0.150
     3.912    59.695     0.150
     4.076    61.915     0.150
     4.395    74.023     0.150
     4.395    89.324     0.150
     4.971    76.104     0.150
     4.971   127.354     0.150
     5.195    76.845     0.150
     5.215    77.925     0.150
     5.270    78.665     0.150
     5.592    84.705     0.150
     5.592   147.735     0.150
     5.605    83.075     0.150
     5.701    84.725     0.150
     5.938    87.255     0.150
     6.995   103.064     0.150
     7.491   106.915     0.150
     7.370   111.175     0.150
     7.576   110.425     0.150
     7.655   111.755     0.150
     7.655   113.695     0.150
     7.655   201.235     0.150
     7.921   118.699     0.150
     7.921   252.949     0.150
     7.921   114.405     0.150
     8.620   124.595     0.150
     8.742   126.255     0.150
     8.743   129.729     0.150
     8.743   273.005     0.150
     8.743   126.145     0.150
     8.808   125.835     0.150
     8.808   231.795     0.150
    15.063   211.024     0.150
    15.420   215.825     0.150
    15.486   217.965     0.150
    15.880   222.274     0.150
    16.178   225.935     0.150
    18.535   265.824     0.150
    21.403   290.898     0.150
    40.585   464.974     0.150
     0.552    10.821     0.150
     0.552    18.521     0.150
     0.905    16.421     0.150
     0.905    28.011     0.150
     0.905    16.901     0.150
     0.905    30.031     0.150
     0.937    16.971     0.150
     0.937    29.621     0.150
     1.420    24.251     0.150
     1.420    43.161     0.150
     1.630    29.812     0.150
     1.630    51.461     0.150
     1.741    28.631     0.150
     1.741    52.352     0.150
     1.824    32.341     0.150
     1.824    56.281     0.150
     1.900    54.602     0.150
     1.900    30.111     0.150
     1.900    53.831     0.150
     1.972    30.801     0.150
     1.972    53.911     0.150
     1.969    32.151     0.150
     1.969    58.261     0.150
     1.969    31.931     0.150
     1.969    59.291     0.150
     2.590    40.481     0.150
     2.590    70.421     0.150
     2.842    75.191     0.150
     3.189    49.541     0.150
     3.189    85.312     0.150
     3.504    53.801     0.150
     3.504    95.801     0.150
     3.556    53.361     0.150
     3.556    94.831     0.150
     3.595    56.621     0.150
     3.595    95.062     0.150
     4.409    86.001     0.150
     8.011   117.340     0.150
     8.011   254.115     0.150
     8.810   128.421     0.150
     8.810   271.605     0.150
     9.360   140.371     0.150
    13.343   193.625     0.150
    18.585   260.888     0.150
    21.430   285.090     0.150
    32.672   395.648     0.150
    40.615   462.671     0.150
     0.840    15.688     0.150
     0.840    26.979     0.150
     0.804    15.669     0.150
     0.804    26.509     0.150
     1.107    19.839     0.150
     1.107    34.829     0.150
     1.278    23.089     0.150
     1.278    39.909     0.150
     1.278    24.059     0.150
     1.372    25.749     0.150
     1.372    43.619     0.150
     1.520    27.969     0.150
     1.520    48.318     0.150
     1.550    27.108     0.150
     1.550    46.799     0.150
     1.550    26.909     0.150
     2.497    42.358     0.150
     2.497    74.339     0.150
     2.801    48.039     0.150
     2.801    84.959     0.150
     2.882    50.329     0.150
     2.882    83.648     0.150
     3.136    53.019     0.150
     3.136    83.509     0.150
     3.912    67.229     0.150
     3.912   111.648     0.150
     4.190    66.409     0.150
     4.190   116.858     0.150
     0.627    12.324     0.150
     0.627    21.754     0.150
     0.975    16.836     0.150
     0.975    29.824     0.150
     1.184    21.574     0.150
     1.184    37.605     0.150
     1.222    23.223     0.150
     1.222    39.844     0.150
     1.222    22.863     0.150
     1.222    40.465     0.150
     1.312    22.645     0.150
     1.312    39.605     0.150
     1.428    25.625     0.150
     1.428    44.375     0.150
     1.700    30.383     0.150
     1.700    53.535     0.150
     1.700    29.836     0.150
     1.700    51.914     0.150
     1.921    33.945     0.150
     1.921    58.734     0.150
     1.856    32.254     0.150
     1.856    57.434     0.150
     1.856    55.543     0.150
     2.022    37.383     0.150
     2.022    63.094     0.150
     2.716    49.934     0.150
     3.349    52.496     0.150
     3.349    93.414     0.150
     3.399    54.793     0.150
     3.399   100.824     0.150
     3.805    59.926     0.150
     3.805   105.133     0.150
     0.661    12.945     0.150
     0.661    22.416     0.150
     0.923    17.225     0.150
     0.923    29.926     0.150
     1.199    22.154     0.150
     1.199    37.965     0.150
     1.196    22.416     0.150
     1.196    38.734     0.150
     1.196    22.555     0.150
     1.196    37.465     0.150
     1.270    22.955     0.150
     1.270    39.945     0.150
     1.439    25.705     0.150
     1.439    44.385     0.150
     1.753    29.395     0.150
     1.753    51.064     0.150
     1.752    30.225     0.150
     1.752    51.234     0.150
     1.908    31.395     0.150
     1.908    56.266     0.150
     1.908    31.904     0.150
     1.908    55.596     0.150
     1.883    33.484     0.150
     1.883    57.814     0.150
     1.972    36.295     0.150
     1.972    62.404     0.150
     2.591    47.605     0.150
     2.591    79.395     0.150
     2.663    43.455     0.150
     2.663    81.016     0.150
     3.322    90.395     0.150
     3.325    49.615     0.150
     3.325    94.895     0.150
     3.408    53.756     0.150
     3.408    94.805     0.150
     3.349    59.846     0.150
     3.349    91.885     0.150
     3.619    58.324     0.150
     3.619   105.635     0.150
     3.752    58.475     0.150
     3.752   103.824     0.150
     4.980    74.455     0.150
     4.980   127.635     0.150
     0.694    13.645     0.150
     0.694    24.453     0.150
     1.184    38.805     0.150
     1.206    22.324     0.150
     1.206    38.875     0.150
     1.206    39.055     0.150
     1.238    40.652     0.150
     1.421    45.645     0.150
     1.421    44.312     0.150
     1.762    29.875     0.150
     1.762    51.574     0.150
     1.771    30.516     0.150
     1.771    52.133     0.150
     1.934    33.035     0.150
     1.934    57.855     0.150
     1.934    32.484     0.150
     1.934    56.414     0.150
     1.884    33.395     0.150
     1.884    59.855     0.150
     1.953    55.625     0.150
     1.958    35.223     0.150
     1.958    61.105     0.150
     2.185    35.422     0.150
     2.594    70.812     0.150
     2.594    49.832     0.150
     2.612    41.445     0.150
     2.612    71.844     0.150
     2.651    42.242     0.150
     2.642    42.062     0.150
     2.642    43.355     0.150
     2.642    76.875     0.150
     3.051    48.125     0.150
     3.072    48.215     0.150
     3.136    48.793     0.150
     3.094    48.344     0.150
     3.336    51.953     0.150
     3.336    52.742     0.150
     3.336    91.805     0.150
     3.293    51.555     0.150
     3.293    53.934     0.150
     3.293    93.133     0.150
     3.421    55.574     0.150
     3.336    52.922     0.150
     3.336    91.805     0.150
     3.585    54.934     0.150
     3.659    56.043     0.150
     3.588    56.402     0.150
     3.716    56.613     0.150
     3.803    57.992     0.150
     3.728    59.145     0.150
     3.728   105.715     0.150
     3.823    58.453     0.150
     3.881    58.793     0.150
     3.969    60.113     0.150
     3.989    60.945     0.150
     4.178    66.586     0.150
     4.178   145.312     0.150
     4.182    63.672     0.150
     4.170    63.422     0.150
     4.303    65.105     0.150
     4.310    64.953     0.150
     4.618    69.383     0.150
     4.671    70.742     0.150
     4.609    69.035     0.150
     4.698    70.895     0.150
     4.664    70.113     0.150
     4.717    71.355     0.150
     4.939    73.914     0.150
     4.963    75.043     0.150
     4.950   130.195     0.150
     4.950    77.125     0.150
     5.090    76.402     0.150
     7.305   109.812     0.150
     7.756   115.336     0.150
     7.756   248.312     0.150
     7.756   116.234     0.150
     7.752   206.605     0.150
     7.752   117.754     0.150
     8.265   124.785     0.150
     9.096   136.770     0.150
     9.096   298.164     0.150
    10.647   158.043     0.150
    10.647   343.020     0.150
    13.022   189.242     0.150
    13.022   416.367     0.150
    13.397   195.055     0.150
    15.029   209.773     0.150
    15.023   211.402     0.150
    15.033   211.203     0.150
    15.058   211.266     0.150
    15.115   212.582     0.150
    15.161   212.453     0.150
    15.212   214.164     0.150
    15.310   214.734     0.150
    15.348   215.793     0.150
    15.298   214.922     0.150
    15.306   215.254     0.150
    15.405   216.613     0.150
    15.433   216.555     0.150
    15.438   217.164     0.150
    15.471   217.223     0.150
    15.471   222.445     0.150
    15.498   217.605     0.150
    15.673   219.582     0.150
    15.656   220.723     0.150
    15.753   221.164     0.150
    15.913   223.402     0.150
    15.913   229.023     0.150
    16.544   230.953     0.150
    16.467   229.723     0.150
    16.637   232.523     0.150
    16.712   232.863     0.150
    16.844   234.863     0.150
    16.862   234.672     0.150
    17.071   237.145     0.150
    17.362   241.633     0.150
    17.436   242.332     0.150
    17.505   243.145     0.150
    17.550   244.105     0.150
    17.550   249.734     0.150
    17.612   245.266     0.150
    17.735   245.883     0.150
    17.822   248.113     0.150
    18.083   249.793     0.150
    18.105   250.535     0.150
    18.281   258.961     0.150
    18.281   259.465     0.150
    18.481   254.953     0.150
    18.589   256.145     0.150
    18.957   260.184     0.150
    19.016   261.402     0.150
    19.189   268.516     0.150
    19.188   263.164     0.150
    19.688   268.395     0.150
    19.925   270.922     0.150
    20.040   272.133     0.150
    20.161   278.355     0.150
    20.276   274.625     0.150
    20.265   274.082     0.150
    20.478   277.125     0.150
    20.732   279.184     0.150
    20.849   281.023     0.150
    20.960   282.293     0.150
    21.342   286.742     0.150
    21.342   292.582     0.150
    21.544   290.289     0.150
    21.635   289.695     0.150
    22.429   298.055     0.150
    22.657   299.902     0.150
    22.724   299.855     0.150
    23.056   304.254     0.150
    23.993   319.902     0.150
    24.140   318.719     0.150
    24.121   314.445     0.150
    24.396   317.582     0.150
    24.617   323.605     0.150
    24.659   320.145     0.150
    25.966   336.453     0.150
    26.312   334.695     0.150
    32.359   393.395     0.150
    32.359   389.414     0.150
    37.544   433.344     0.150
    37.715   434.875     0.150
    39.928   458.902     0.150
    40.345   457.004     0.150
    40.345   462.844     0.150
    41.386   469.445     0.150
    41.386   465.293     0.150
    42.446   473.766     0.150
    42.832   477.133     0.150
    43.002   477.953     0.150
    44.807   492.785     0.150
    44.807   499.285     0.150
    45.599   504.863     0.150
    46.591   506.672     0.150
    52.144   554.645     0.150
    52.607   557.465     0.150
    57.113   590.703     0.150
    62.046   623.312     0.150
    68.990   668.305     0.150
    70.933   683.074     0.150
    75.025   705.723     0.150
    75.128   704.363     0.150
    75.745   709.094     0.150
    75.850   711.734     0.150
    77.870   720.965     0.150
    77.870   720.668     0.150
    83.506   749.625     0.150
    84.547   757.004     0.150
    84.825   759.973     0.150
    85.438   761.473     0.150
    86.238   766.113     0.150
    86.699   766.594     0.150
    87.849   774.832     0.150
    91.107   790.574     0.150
    91.832   791.953     0.150
    92.163   794.504     0.150
    92.971   799.172     0.150
    95.073   805.434     0.150
    97.872   813.844     0.150
    98.740   819.844     0.150
     0.654    12.633     0.150
     0.654    22.230     0.150
     0.935    16.910     0.150
     0.935    29.941     0.150
     1.194    21.539     0.150
     1.194    37.383     0.150
     1.203    21.723     0.150
     1.203    38.402     0.150
     1.203    37.223     0.150
     1.280    22.770     0.150
     1.280    40.199     0.150
     1.435    25.141     0.150
     1.435    44.250     0.150
     1.741    28.820     0.150
     1.741    49.930     0.150
     1.740    29.449     0.150
     1.740    50.973     0.150
     1.893    32.520     0.150
     1.893    56.762     0.150
     1.896    30.391     0.150
     1.896    54.539     0.150
     1.896    31.371     0.150
     1.896    52.609     0.150
     1.984    34.133     0.150
     1.984    58.883     0.150
     3.310    59.840     0.150
     3.310    91.730     0.150
     3.329    51.871     0.150
     3.329    91.730     0.150
     3.362    58.223     0.150
     3.362    93.062     0.150
     3.629   101.082     0.150
     4.991    75.250     0.150
     4.991   129.312     0.150
     0.616    12.203     0.150
     0.616    21.484     0.150
     0.884    16.000     0.150
     0.884    28.531     0.150
     1.023    19.531     0.150
     1.023    19.398     0.150
     1.023    33.070     0.150
     1.318    22.703     0.150
     1.318    40.000     0.150
     1.371    23.289     0.150
     1.371    40.969     0.150
     1.608    27.258     0.150
     1.608    47.312     0.150
     1.720    31.000     0.150
     1.720    54.695     0.150
     1.860    31.492     0.150
     1.860    55.500     0.150
     1.860    31.148     0.150
     1.860    54.094     0.150
     1.897    30.711     0.150
     1.897    53.281     0.150
     1.854    32.953     0.150
     1.854    57.648     0.150
     1.970    33.602     0.150
     1.970    59.234     0.150
     1.970    33.070     0.150
     1.970    56.453     0.150
     2.585    51.234     0.150
     2.585    84.062     0.150
     3.227    63.398     0.150
     3.431    65.305     0.150
     3.431   115.250     0.150
     3.538    68.141     0.150
     3.538   113.273     0.150
     0.757    14.748     0.150
     0.757    24.828     0.150
     0.923    17.648     0.150
     0.923    30.988     0.150
     1.025    18.799     0.150
     1.025    31.928     0.150
     1.055    18.578     0.150
     1.156    21.498     0.150
     1.156    36.879     0.150
     1.156    21.008     0.150
     1.478    26.348     0.150
     1.478    45.549     0.150
     1.478    47.568     0.150
     1.515    27.268     0.150
     1.515    47.998     0.150
     1.613    29.568     0.150
     1.613    51.779     0.150
     2.648    40.479     0.150
     2.648    71.709     0.150
     2.727    44.268     0.150
     2.727    81.529     0.150
     3.291    48.449     0.150
     3.291    84.328     0.150
     3.278    92.229     0.150
     3.464    71.373     0.150
     3.464   117.297     0.150
     7.730   113.697     0.150
     7.730   240.148     0.150
     8.398   126.203     0.150
     8.398   162.254     0.150
     9.212   132.979     0.150
    17.653   252.047     0.150
    31.772   386.484     0.150
    39.653   455.578     0.150
     0.743    14.217     0.150
     0.743    24.527     0.150
     1.197    21.559     0.150
     1.197    37.717     0.150
     0.917    16.938     0.150
     0.917    29.488     0.150
     1.537    27.578     0.150
     1.537    47.707     0.150
     1.537    23.918     0.150
     1.176    21.088     0.150
     1.176    36.797     0.150
     1.448    25.238     0.150
     1.448    44.258     0.150
     1.448    25.098     0.150
     1.448    44.148     0.150
     1.391    24.158     0.150
     1.391    42.678     0.150
     1.400    25.547     0.150
     1.684    28.748     0.150
     1.684    50.258     0.150
     1.684    49.637     0.150
     2.312    72.668     0.150
     2.960    43.627     0.150
     2.960    77.277     0.150
     2.984    54.229     0.150
     2.984    88.697     0.150
     3.066    83.729     0.150
     3.266    50.607     0.150
     3.266    88.979     0.150
     4.022    61.408     0.150
     4.022   110.098     0.150
     0.734    14.035     0.150
     0.734    24.227     0.150
     1.188    21.246     0.150
     1.188    37.273     0.150
     0.929    16.957     0.150
     0.929    29.797     0.150
     1.388    24.594     0.150
     1.388    43.336     0.150
     1.188    21.375     0.150
     1.523    27.004     0.150
     1.413    24.477     0.150
     1.413    44.695     0.150
     1.457    24.996     0.150
     1.457    44.855     0.150
     1.457    25.246     0.150
     1.688    28.387     0.150
     1.688    49.863     0.150
     2.229    37.934     0.150
     2.229    66.523     0.150
     2.301    39.246     0.150
     2.301    69.145     0.150
     2.244    34.516     0.150
     2.995    49.727     0.150
     3.271    49.234     0.150
     3.271    89.004     0.150
     3.078    47.773     0.150
     3.078    89.824     0.150
     0.661    12.758     0.150
     0.661    21.852     0.150
     0.661    22.656     0.150
     0.932    16.719     0.150
     0.932    29.812     0.150
     1.188    21.180     0.150
     1.188    36.797     0.150
     1.209    22.148     0.150
     1.209    38.117     0.150
     1.209    38.922     0.150
     1.273    22.492     0.150
     1.273    39.430     0.150
     1.428    24.852     0.150
     1.428    44.641     0.150
     1.739    28.609     0.150
     1.739    50.000     0.150
     1.740    29.141     0.150
     1.740    28.922     0.150
     1.899    31.281     0.150
     1.899    56.117     0.150
     1.899    54.359     0.150
     1.897    32.992     0.150
     1.897    58.219     0.150
     1.985    35.883     0.150
     1.985    61.867     0.150
     2.674    41.133     0.150
     2.674    80.328     0.150
     3.309    51.086     0.150
     3.309    95.750     0.150
     3.395    53.211     0.150
     3.362    51.789     0.150
     3.362    90.023     0.150
     0.637    12.547     0.150
     0.637    21.107     0.150
     0.925    17.627     0.150
     0.925    30.707     0.150
     1.164    21.537     0.150
     1.164    37.918     0.150
     1.164    21.318     0.150
     1.164    37.387     0.150
     1.233    21.588     0.150
     1.233    37.168     0.150
     1.290    22.809     0.150
     1.290    40.197     0.150
     1.474    25.137     0.150
     1.474    44.387     0.150
     1.762    30.229     0.150
     1.762    51.887     0.150
     1.762    29.688     0.150
     1.762    51.758     0.150
     1.773    29.078     0.150
     1.773    51.027     0.150
     1.856    32.568     0.150
     1.856    57.107     0.150
     1.907    31.938     0.150
     1.907    55.627     0.150
     1.958    34.148     0.150
     1.958    60.229     0.150
     2.659    44.008     0.150
     2.659    76.648     0.150
     2.659    41.729     0.150
     2.659    74.018     0.150
     3.338    52.348     0.150
     3.338    94.277     0.150
     3.354    52.027     0.150
     3.354    91.008     0.150
     3.335    53.277     0.150
     3.335    94.277     0.150
     3.335    50.508     0.150
     3.335    90.137     0.150
     3.424    55.578     0.150
     3.424    95.258     0.150
     3.631    57.018     0.150
     3.751    58.457     0.150
     3.751   103.828     0.150
     4.196    67.316     0.150
     4.196    81.691     0.150
     4.196   137.742     0.150
     7.817   114.867     0.150
     7.817   245.791     0.150
     8.792   129.523     0.150
     8.792   270.504     0.150
     9.124   135.459     0.150
    13.077   189.676     0.150
    24.200   318.422     0.150
    32.405   392.123     0.150
    40.375   461.547     0.150
     0.628    12.256     0.150
     0.628    21.066     0.150
     0.955    17.006     0.150
     0.955    30.617     0.150
     1.196    21.547     0.150
     1.196    38.586     0.150
     1.196    21.926     0.150
     1.196    38.266     0.150
     1.207    21.586     0.150
     1.207    37.326     0.150
     1.305    23.736     0.150
     1.305    40.766     0.150
     1.450    24.797     0.150
     1.450    44.547     0.150
     1.726    30.096     0.150
     1.726    52.486     0.150
     1.726    29.576     0.150
     1.726    51.307     0.150
     1.735    29.105     0.150
     1.735    50.057     0.150
     1.876    31.766     0.150
     1.876    54.947     0.150
     1.893    32.736     0.150
     1.893    58.057     0.150
     1.995    34.807     0.150
     1.995    60.236     0.150
     3.300    52.746     0.150
     3.300    90.436     0.150
     3.354    52.887     0.150
     3.354    93.566     0.150
     3.372    52.227     0.150
     3.372    92.377     0.150
     4.158    84.406     0.150
     4.158   149.381     0.150
     7.818   248.756     0.150
     8.818   268.719     0.150
     9.088   176.271     0.150
    32.377   391.602     0.150
     0.777    14.984     0.150
     0.777    25.500     0.150
     0.871    17.008     0.150
     0.871    28.758     0.150
     1.039    19.336     0.150
     1.039    32.930     0.150
     1.302    22.461     0.150
     1.302    38.367     0.150
     1.264    23.469     0.150
     1.264    40.461     0.150
     1.388    23.797     0.150
     1.388    42.578     0.150
     1.399    24.461     0.150
     1.399    42.516     0.150
     1.399    44.531     0.150
     1.683    28.258     0.150
     1.683    49.555     0.150
     1.683    28.461     0.150
     1.683    49.289     0.150
     1.678    30.141     0.150
     1.678    31.055     0.150
     2.106    35.781     0.150
     2.106    61.367     0.150
     2.899    47.766     0.150
     2.899    81.930     0.150
     2.977    48.578     0.150
     2.977    81.664     0.150
     3.027    50.258     0.150
     3.027    84.766     0.150
     3.180    48.891     0.150
     3.180    86.648     0.150
     3.695   123.609     0.150
     3.788   104.320     0.150
     7.637   202.430     0.150
     7.637   245.578     0.150
     8.606   129.891     0.150
     8.606   292.266     0.150
    10.181   150.414     0.150
    12.637   184.461     0.150
    12.637   413.562     0.150
    39.856   455.984     0.150
     0.733    13.977     0.150
     0.733    24.625     0.150
     0.924    16.648     0.150
     0.924    28.930     0.150
     0.924    31.055     0.150
     1.184    20.695     0.150
     1.184    36.234     0.150
     1.209    21.484     0.150
     1.209    37.680     0.150
     1.392    24.109     0.150
     1.392    41.188     0.150
     1.406    24.375     0.150
     1.406    42.820     0.150
     1.436    25.188     0.150
     1.436    43.984     0.150
     1.436    43.461     0.150
     1.537    28.281     0.150
     1.537    49.609     0.150
     1.669    28.281     0.150
     1.669    50.227     0.150
     1.669    49.359     0.150
     2.225    35.648     0.150
     2.225    62.344     0.150
     2.321    42.117     0.150
     2.321    42.656     0.150
     2.321    71.148     0.150
     2.975    47.648     0.150
     2.975    81.570     0.150
     2.971    46.836     0.150
     2.971    50.125     0.150
     2.971    85.938     0.150
     3.279    50.125     0.150
     3.279    91.500     0.150
     0.932    17.051     0.150
     0.932    29.602     0.150
     0.731    13.949     0.150
     0.731    24.281     0.150
     1.190    21.418     0.150
     1.190    36.801     0.150
     1.189    21.301     0.150
     1.189    36.648     0.150
     1.189    38.258     0.150
     1.391    24.301     0.150
     1.391    41.781     0.150
     1.456    25.410     0.150
     1.456    43.121     0.150
     1.456    25.590     0.150
     1.456    44.008     0.150
     1.521    25.910     0.150
     1.521    26.711     0.150
     1.686    28.000     0.150
     1.686    48.340     0.150
     1.686    28.629     0.150
     1.686    50.340     0.150
     2.301    37.648     0.150
     2.301    63.328     0.150
     2.995    46.461     0.150
     2.995    82.238     0.150
     2.951    45.398     0.150
     2.951    47.520     0.150
     2.951    82.750     0.150
     3.078    48.090     0.150
     3.078    82.918     0.150
     3.274    88.199     0.150
     4.015    60.988     0.150
     0.746    14.594     0.150
     0.746    24.762     0.150
     0.929    17.461     0.150
     0.929    30.711     0.150
     1.185    21.504     0.150
     1.185    37.594     0.150
     1.155    21.152     0.150
     1.155    36.762     0.150
     1.490    25.832     0.150
     1.490    44.684     0.150
     1.490    44.551     0.150
     1.356    24.062     0.150
     1.356    42.012     0.150
     1.722    29.023     0.150
     1.722    49.934     0.150
     1.722    51.531     0.150
     1.722    50.320     0.150
     1.508    26.070     0.150
     1.508    45.051     0.150
     3.026    47.223     0.150
     3.026    91.422     0.150
     3.108    58.473     0.150
     3.108    86.242     0.150
     2.917    45.793     0.150
     2.917    79.172     0.150
     2.917    50.391     0.150
     3.249    47.812     0.150
     3.249    94.691     0.150
     0.630    12.223     0.150
     0.630    21.062     0.150
     0.903    16.533     0.150
     0.903    28.742     0.150
     1.111    19.922     0.150
     1.111    35.363     0.150
     1.111    35.152     0.150
     1.284    21.672     0.150
     1.294    22.393     0.150
     1.294    39.232     0.150
     1.522    24.703     0.150
     1.522    43.842     0.150
     1.802    29.422     0.150
     1.802    52.432     0.150
     1.802    29.262     0.150
     1.802    51.133     0.150
     1.821    28.002     0.150
     1.821    49.592     0.150
     1.934    31.242     0.150
     1.934    55.822     0.150
     1.934    31.021     0.150
     1.934    53.303     0.150
     1.804    29.953     0.150
     1.804    53.812     0.150
     1.915    32.703     0.150
     2.055    32.783     0.150
     2.222    35.053     0.150
     2.668    46.453     0.150
     2.668    71.602     0.150
     2.723    42.352     0.150
     2.571    42.102     0.150
     2.710    41.842     0.150
     2.626    41.521     0.150
     2.626    74.543     0.150
     2.626    74.082     0.150
     2.626    40.783     0.150
     2.626    41.783     0.150
     3.137    48.873     0.150
     3.016    54.703     0.150
     3.016    45.092     0.150
     3.201    48.863     0.150
     3.382    87.682     0.150
     3.291    51.133     0.150
     3.291    90.863     0.150
     3.379    51.803     0.150
     3.379    92.223     0.150
     3.379    50.842     0.150
     3.379    52.102     0.150
     3.469    55.502     0.150
     3.469    49.623     0.150
     3.469    91.912     0.150
     3.638    54.822     0.150
     3.623    56.582     0.150
     3.623   104.152     0.150
     3.752    57.672     0.150
     3.946    59.402     0.150
     3.925    59.602     0.150
     4.024    62.143     0.150
     4.047    61.723     0.150
     4.246    64.271     0.150
     4.246    64.922     0.150
     4.246   137.146     0.150
     4.269    64.902     0.150
     4.269    64.441     0.150
     4.268    64.623     0.150
     4.387    67.303     0.150
     4.775    71.992     0.150
     4.685    70.553     0.150
     4.765    72.133     0.150
     4.983    75.703     0.150
     4.983    75.043     0.150
     4.983   134.402     0.150
     5.346    81.213     0.150
     5.634    83.053     0.150
     5.701    83.643     0.150
     5.701   152.162     0.150
     5.799    87.703     0.150
     6.137    90.703     0.150
     7.356   108.873     0.150
     7.356   108.502     0.150
     7.582   111.932     0.150
     7.840   115.203     0.150
     7.840   115.312     0.150
     7.840   113.447     0.150
     7.840   203.896     0.150
     7.840   245.271     0.150
     7.831   112.441     0.150
     8.248   118.473     0.150
     8.363   121.283     0.150
     8.363   121.572     0.150
     8.363   124.803     0.150
     8.776   128.803     0.150
     8.776   128.303     0.150
     8.776   128.502     0.150
     8.776   128.295     0.150
     8.776   227.002     0.150
     8.776   271.928     0.150
     8.877   128.742     0.150
     8.916   127.842     0.150
     8.916   233.162     0.150
     9.093   131.912     0.150
     9.165   130.203     0.150
     9.177   134.902     0.150
     9.760   140.152     0.150
     9.972   143.633     0.150
    10.149   144.822     0.150
    10.059   143.822     0.150
    10.497   151.562     0.150
    10.742   158.703     0.150
    10.742   155.312     0.150
    10.742   339.277     0.150
    10.738   153.262     0.150
    10.902   155.783     0.150
    11.779   168.713     0.150
    12.308   175.271     0.150
    12.344   178.932     0.150
    12.557   178.373     0.150
    13.124   188.014     0.150
    13.124   414.783     0.150
    13.498   191.982     0.150
    13.461   192.703     0.150
    13.461   191.812     0.150
    13.735   196.291     0.150
    13.814   197.703     0.150
    13.898   196.393     0.150
    14.556   206.102     0.150
    14.773   209.623     0.150
    14.694   209.533     0.150
    14.871   210.682     0.150
    14.887   211.332     0.150
    14.920   212.033     0.150
    15.045   211.803     0.150
    15.119   216.482     0.150
    15.045   214.482     0.150
    15.128   215.822     0.150
    15.217   215.252     0.150
    15.312   217.203     0.150
    15.363   216.662     0.150
    15.280   217.512     0.150
    15.297   215.512     0.150
    15.316   217.932     0.150
    15.374   220.012     0.150
    15.488   220.822     0.150
    15.513   219.992     0.150
    15.504   220.492     0.150
    15.504   221.602     0.150
    15.504   220.303     0.150
    15.608   226.102     0.150
    15.763   222.672     0.150
    16.013   224.363     0.150
    16.013   230.002     0.150
    16.135   226.572     0.150
    16.273   227.521     0.150
    16.472   232.191     0.150
    16.452   229.893     0.150
    16.530   231.582     0.150
    16.755   235.113     0.150
    16.717   233.652     0.150
    16.862   235.252     0.150
    17.608   245.492     0.150
    17.721   247.393     0.150
    17.820   248.172     0.150
    18.005   249.912     0.150
    18.069   250.582     0.150
    18.376   256.102     0.150
    18.376   258.072     0.150
    18.376   254.133     0.150
    18.547   254.643     0.150
    19.021   261.191     0.150
    19.094   261.422     0.150
    19.281   265.402     0.150
    19.977   271.402     0.150
    20.232   277.152     0.150
    21.431   289.373     0.150
    21.512   290.697     0.150
    22.053   293.902     0.150
    22.164   296.312     0.150
    22.487   298.293     0.150
    22.491   301.373     0.150
    22.491   299.172     0.150
    22.491   303.703     0.150
    22.739   300.941     0.150
    22.789   304.053     0.150
    22.789   300.412     0.150
    22.959   304.703     0.150
    23.200   306.873     0.150
    23.689   311.102     0.150
    23.868   312.902     0.150
    23.912   313.102     0.150
    23.989   313.832     0.150
    24.061   317.143     0.150
    24.094   314.793     0.150
    24.239   317.752     0.150
    24.239   316.373     0.150
    24.492   317.783     0.150
    24.711   322.072     0.150
    24.757   320.803     0.150
    24.768   321.172     0.150
    25.716   331.797     0.150
    25.908   334.572     0.150
    25.972   334.092     0.150
    30.522   374.482     0.150
    30.891   377.383     0.150
    32.445   389.723     0.150
    32.457   391.746     0.150
    32.457   559.553     0.150
    32.457   391.633     0.150
    32.549   391.902     0.150
    33.241   400.092     0.150
    33.485   402.812     0.150
    39.095   450.633     0.150
    39.129   450.432     0.150
    39.221   451.352     0.150
    39.325   452.113     0.150
    39.427   452.422     0.150
    39.848   457.053     0.150
    40.020   454.533     0.150
    40.428   458.842     0.150
    40.428   462.502     0.150
    40.428   460.615     0.150
    40.428   460.482     0.150
    40.802   463.082     0.150
    41.011   462.732     0.150
    41.211   464.762     0.150
    41.352   465.553     0.150
    41.461   467.453     0.150
    41.674   469.172     0.150
    41.843   470.383     0.150
    42.043   471.633     0.150
    42.970   479.633     0.150
    43.420   484.082     0.150
    44.772   496.682     0.150
    44.772   493.953     0.150
    44.799   493.373     0.150
    44.886   493.652     0.150
    44.924   495.592     0.150
    45.399   499.191     0.150
    45.593   500.352     0.150
    45.485   499.652     0.150
    45.704   500.992     0.150
    46.493   507.012     0.150
    46.693   508.473     0.150
    51.298   546.203     0.150
    52.244   552.463     0.150
    53.761   562.883     0.150
    54.426   566.982     0.150
    57.214   587.062     0.150
    65.766   647.104     0.150
    65.766   645.512     0.150
    66.949   653.053     0.150
    69.749   670.496     0.150
    69.749   669.453     0.150
    76.417   711.729     0.150
    77.395   717.922     0.150
    77.826   719.822     0.150
    77.826   717.713     0.150
    77.826   718.777     0.150
    80.985   736.527     0.150
    84.858   756.619     0.150
    84.804   755.264     0.150
    85.481   758.770     0.150
    85.481   757.412     0.150
    85.482   759.652     0.150
    85.482   757.262     0.150
    86.235   761.172     0.150
    86.420   765.203     0.150
    86.420  1402.002     0.150
    86.420  1408.002     0.150
    86.411   761.691     0.150
    91.521   788.775     0.150
    94.186   801.402     0.150
    94.822   804.123     0.150
    96.290   807.203     0.150
    98.810   818.502     0.150
    98.954   822.533     0.150
   131.349  1153.373     0.150
   131.349  1582.092     0.150
     0.639    12.387     0.150
     0.639    21.418     0.150
     0.923    16.607     0.150
     0.923    29.229     0.150
     1.162    20.357     0.150
     1.162    35.547     0.150
     1.162    20.027     0.150
     1.162    36.229     0.150
     1.235    21.387     0.150
     1.235    38.188     0.150
     1.288    22.357     0.150
     1.288    39.578     0.150
     1.475    25.217     0.150
     1.475    44.438     0.150
     1.475    24.467     0.150
     1.765    28.938     0.150
     1.765    51.178     0.150
     1.765    28.627     0.150
     1.765    50.338     0.150
     1.775    28.148     0.150
     1.775    49.797     0.150
     1.854    31.438     0.150
     1.854    55.828     0.150
     1.910    30.979     0.150
     1.910    55.387     0.150
     1.910    31.328     0.150
     1.910    53.047     0.150
     1.955    32.797     0.150
     1.955    57.938     0.150
     2.013    32.488     0.150
     2.183    34.697     0.150
     2.619    44.527     0.150
     2.661    41.818     0.150
     2.674    41.988     0.150
     2.529    41.467     0.150
     2.656    41.117     0.150
     2.656    41.717     0.150
     2.656    71.258     0.150
     3.070    47.467     0.150
     3.087    46.488     0.150
     3.065    49.479     0.150
     3.065    83.668     0.150
     3.154    48.537     0.150
     3.340    51.117     0.150
     3.340    96.678     0.150
     3.332    50.867     0.150
     3.332    97.348     0.150
     3.354    50.037     0.150
     3.354    52.197     0.150
     3.354    91.398     0.150
     3.354    60.047     0.150
     3.427    52.207     0.150
     3.427    90.857     0.150
     3.594    55.258     0.150
     3.701    54.777     0.150
     3.720    56.838     0.150
     3.877    58.258     0.150
     3.899    59.297     0.150
     3.980    61.297     0.150
     4.041    61.729     0.150
     4.199    62.777     0.150
     4.198    64.592     0.150
     4.198   138.643     0.150
     4.219    63.479     0.150
     4.232    64.287     0.150
     4.317    65.627     0.150
     4.724    69.979     0.150
     4.987    74.598     0.150
     5.017    73.928     0.150
     5.738    86.559     0.150
     5.756    85.479     0.150
     6.164    92.867     0.150
     6.426    95.908     0.150
     6.497    96.088     0.150
     6.802   101.328     0.150
     6.775   100.068     0.150
     6.906   101.797     0.150
     6.905   101.229     0.150
     6.941   101.457     0.150
     7.022   103.207     0.150
     7.344   106.898     0.150
     7.354   108.488     0.150
     7.354   109.447     0.150
     7.438   108.078     0.150
     7.587   112.098     0.150
     7.709   111.887     0.150
     7.817   114.592     0.150
     7.817   204.268     0.150
     7.817   248.666     0.150
     7.817   113.758     0.150
     7.817   116.648     0.150
     8.090   118.998     0.150
     8.326   123.148     0.150
     8.589   125.729     0.150
     8.629   126.447     0.150
     8.740   128.148     0.150
     8.789   129.248     0.150
     8.789   128.367     0.150
     8.789   130.248     0.150
     8.790   128.398     0.150
     8.790   227.348     0.150
     8.790   274.422     0.150
     8.790   128.957     0.150
     9.126   134.855     0.150
     9.355   134.117     0.150
     9.528   138.188     0.150
    10.068   146.898     0.150
    10.101   149.068     0.150
    10.692   156.197     0.150
    10.692   151.508     0.150
    10.907   158.148     0.150
    11.743   170.668     0.150
    12.051   173.008     0.150
    12.381   176.809     0.150
    13.079   188.969     0.150
    13.079   184.268     0.150
    13.448   193.287     0.150
    13.451   192.277     0.150
    13.475   192.188     0.150
    14.284   202.967     0.150
    14.567   206.488     0.150
    14.839   208.637     0.150
    15.068   214.287     0.150
    15.184   214.688     0.150
    15.313   215.488     0.150
    15.352   215.367     0.150
    15.395   216.898     0.150
    15.511   219.928     0.150
    15.511   221.447     0.150
    15.712   218.137     0.150
    15.973   227.188     0.150
    15.973   222.877     0.150
    15.973   228.248     0.150
    16.209   228.027     0.150
    16.320   232.408     0.150
    16.705   232.688     0.150
    16.905   236.508     0.150
    16.923   236.559     0.150
    17.563   243.398     0.150
    17.601   246.877     0.150
    17.667   246.197     0.150
    17.770   247.207     0.150
    17.735   248.648     0.150
    18.115   251.287     0.150
    18.325   256.998     0.150
    18.325   257.393     0.150
    18.325   253.377     0.150
    18.732   257.967     0.150
    18.797   258.678     0.150
    19.251   266.768     0.150
    19.327   265.277     0.150
    20.218   277.088     0.150
    20.314   275.508     0.150
    20.793   281.277     0.150
    20.810   281.559     0.150
    20.895   283.627     0.150
    21.247   285.258     0.150
    21.380   290.928     0.150
    21.380   288.178     0.150
    21.549   290.066     0.150
    21.692   290.117     0.150
    21.758   290.088     0.150
    22.158   295.697     0.150
    22.323   296.328     0.150
    22.483   301.979     0.150
    22.483   297.967     0.150
    22.483   302.748     0.150
    22.752   303.979     0.150
    22.752   301.047     0.150
    24.048   317.418     0.150
    24.048   314.367     0.150
    24.048   318.547     0.150
    24.201   316.498     0.150
    24.201   314.678     0.150
    24.441   317.168     0.150
    24.425   318.008     0.150
    24.679   322.248     0.150
    24.721   320.348     0.150
    25.087   323.107     0.150
    25.709   331.041     0.150
    25.906   333.547     0.150
    25.959   331.137     0.150
    25.964   334.508     0.150
    26.024   334.658     0.150
    26.213   333.707     0.150
    28.927   358.207     0.150
    29.155   363.127     0.150
    30.876   378.188     0.150
    30.876   376.037     0.150
    31.118   380.008     0.150
    32.395   387.729     0.150
    32.407   391.648     0.150
    32.532   393.467     0.150
    33.276   398.818     0.150
    33.660   403.998     0.150
    33.502   404.107     0.150
    33.820   402.809     0.150
    36.946   430.938     0.150
    37.470   432.547     0.150
    37.577   432.758     0.150
    38.473   444.717     0.150
    39.969   457.318     0.150
    39.969   458.648     0.150
    40.378   461.748     0.150
    40.378   460.637     0.150
    40.752   463.729     0.150
    40.961   461.637     0.150
    41.302   465.258     0.150
    41.448   467.773     0.150
    41.448   469.348     0.150
    41.448   465.217     0.150
    41.624   466.828     0.150
    41.674   467.068     0.150
    43.370   481.877     0.150
    44.758   494.357     0.150
    44.809   495.668     0.150
    44.809   494.547     0.150
    44.831   495.072     0.150
    44.924   495.117     0.150
    45.427   500.018     0.150
    45.653   502.668     0.150
    45.742   500.979     0.150
    46.648   507.547     0.150
    52.205   553.168     0.150
    52.205   550.277     0.150
    52.532   555.377     0.150
    55.550   574.607     0.150
    57.172   586.297     0.150
    61.451   618.908     0.150
    62.103   622.848     0.150
    63.693   632.828     0.150
    63.693   632.248     0.150
    63.693   631.068     0.150
    63.758   634.137     0.150
    65.472   644.488     0.150
    65.721   646.447     0.150
    65.848   647.008     0.150
    69.001   666.418     0.150
    69.531   671.268     0.150
    69.698   668.318     0.150
    74.942   703.527     0.150
    75.130   703.258     0.150
    75.801   708.938     0.150
    76.382   710.242     0.150
    76.653   712.238     0.150
    77.007   715.027     0.150
    77.867   719.428     0.150
    77.867   718.398     0.150
    77.901   719.479     0.150
    78.511   721.268     0.150
    78.542   723.578     0.150
    78.799   724.738     0.150
    79.636   728.248     0.150
    80.195   731.668     0.150
    80.308   732.797     0.150
    80.814   736.088     0.150
    81.033   737.818     0.150
    81.033   736.773     0.150
    81.407   739.158     0.150
    81.538   738.857     0.150
    81.697   741.137     0.150
    82.093   742.928     0.150
    82.124   743.059     0.150
    82.439   744.467     0.150
    82.440   744.648     0.150
    82.719   746.068     0.150
    82.726   744.338     0.150
    82.798   746.908     0.150
    82.894   746.857     0.150
    82.894   747.027     0.150
    82.977   746.758     0.150
    83.346   749.268     0.150
    83.370   749.867     0.150
    83.446   749.248     0.150
    83.511   749.688     0.150
    83.564   750.238     0.150
    83.648   750.828     0.150
    83.699   749.797     0.150
    83.824   751.398     0.150
    84.206   753.309     0.150
    84.608   756.367     0.150
    84.722   756.318     0.150
    84.777   756.887     0.150
    84.779   757.178     0.150
    84.813   755.531     0.150
    84.813   753.908     0.150
    84.778   756.723     0.150
    84.778   752.668     0.150
    84.846   757.787     0.150
    84.865   757.018     0.150
    84.887   757.668     0.150
    85.355   760.488     0.150
    85.440   757.865     0.150
    85.440   756.877     0.150
    85.441   759.547     0.150
    85.441   757.117     0.150
    85.794   762.178     0.150
    86.206   760.107     0.150
    86.300   764.887     0.150
    86.374   765.148     0.150
    86.360   764.107     0.150
    86.386   763.137     0.150
    86.761   765.758     0.150
    86.933   766.898     0.150
    87.134   768.717     0.150
    87.251   769.398     0.150
    87.334   769.637     0.150
    87.544   769.363     0.150
    87.652   770.578     0.150
    87.774   772.568     0.150
    88.019   772.838     0.150
    88.294   772.758     0.150
    91.478   787.461     0.150
    92.195   792.688     0.150
    93.142   794.508     0.150
    94.457   802.395     0.150
    94.457   798.377     0.150
    94.771   803.312     0.150
    98.903   821.293     0.150
    98.903  1062.775     0.150
   118.268  1128.104     0.150
   120.095  1131.824     0.150
   122.368  1136.988     0.150
     0.598    11.684     0.150
     0.598    20.363     0.150
     0.926    16.812     0.150
     0.926    29.605     0.150
     1.093    19.336     0.150
     1.093    33.305     0.150
     1.093    20.125     0.150
     1.093    33.934     0.150
     1.307    21.965     0.150
     1.307    39.543     0.150
     1.327    23.105     0.150
     1.327    40.594     0.150
     1.548    25.645     0.150
     1.548    46.375     0.150
     1.792    28.895     0.150
     1.792    50.305     0.150
     1.822    28.152     0.150
     1.822    50.195     0.150
     1.796    31.176     0.150
     1.796    54.164     0.150
     1.915    31.023     0.150
     1.915    55.664     0.150
     1.915    31.145     0.150
     1.915    54.074     0.150
     1.923    34.645     0.150
     1.923    59.293     0.150
     2.643    43.383     0.150
     2.643    74.285     0.150
     3.378    53.285     0.150
     3.378    93.875     0.150
     3.298    51.285     0.150
     3.298    99.035     0.150
     3.465    50.355     0.150
     3.465    92.664     0.150
     3.413    52.473     0.150
     4.250    67.758     0.150
     4.250    82.082     0.150
     7.875   115.008     0.150
     7.875   204.832     0.150
     7.875   250.582     0.150
     8.802   127.723     0.150
     8.802   226.090     0.150
     8.802   273.383     0.150
     9.186   134.832     0.150
    10.761   155.590     0.150
    10.761   342.891     0.150
    13.151   189.555     0.150
    13.151   422.953     0.150
    32.478   391.293     0.150
    40.439   460.043     0.150
     0.632    12.383     0.150
     0.632    20.980     0.150
     0.632    23.102     0.150
     0.939    18.133     0.150
     0.939    30.992     0.150
     1.176    21.602     0.150
     1.176    37.102     0.150
     1.176    22.031     0.150
     1.176    39.273     0.150
     1.224    22.312     0.150
     1.224    37.902     0.150
     1.298    23.910     0.150
     1.298    40.641     0.150
     1.465    26.301     0.150
     1.746    30.160     0.150
     1.746    52.422     0.150
     1.746    31.113     0.150
     1.746    52.730     0.150
     1.757    30.703     0.150
     1.757    51.461     0.150
     1.893    32.391     0.150
     1.893    56.301     0.150
     1.893    32.840     0.150
     1.893    55.953     0.150
     1.871    32.523     0.150
     1.871    57.211     0.150
     1.974    34.082     0.150
     1.974    59.863     0.150
     2.674    43.613     0.150
     2.674    77.051     0.150
     2.674    49.043     0.150
     2.674    80.531     0.150
     3.356    52.453     0.150
     3.356    93.941     0.150
     3.350    57.430     0.150
     3.350    93.371     0.150
     3.642    58.543     0.150
     3.642   100.332     0.150
     3.766    58.531     0.150
     3.766   104.852     0.150
     5.003    76.453     0.150
     5.003   133.883     0.150
     0.609    12.074     0.150
     0.609    20.645     0.150
     0.942    17.766     0.150
     0.942    31.035     0.150
     1.145    19.684     0.150
     1.145    34.812     0.150
     1.145    35.973     0.150
     1.257    22.914     0.150
     1.257    39.125     0.150
     1.317    23.652     0.150
     1.317    41.496     0.150
     1.499    26.395     0.150
     1.499    45.836     0.150
     1.756    29.934     0.150
     1.756    30.086     0.150
     1.756    52.105     0.150
     1.776    29.184     0.150
     1.776    50.336     0.150
     1.845    31.824     0.150
     1.845    55.824     0.150
     1.892    31.895     0.150
     1.892    55.883     0.150
     1.892    31.754     0.150
     1.892    54.676     0.150
     1.961    34.062     0.150
     1.961    59.543     0.150
     2.670    43.695     0.150
     2.670    72.895     0.150
     3.057    54.445     0.150
     3.337    51.145     0.150
     3.337    88.145     0.150
     3.385    54.984     0.150
     3.385    92.516     0.150
     3.337    52.945     0.150
     3.337    91.395     0.150
     3.424    51.664     0.150
     3.424    90.094     0.150
     4.203    66.301     0.150
     4.203    81.145     0.150
     4.203   145.395     0.150
     7.848   113.074     0.150
     7.848   252.699     0.150
     8.813   125.520     0.150
     8.813   225.297     0.150
     8.813   273.559     0.150
     9.136   135.184     0.150
    10.709   156.805     0.150
    10.709   347.898     0.150
    13.104   189.594     0.150
    13.104   418.504     0.150
    40.388   460.172     0.150
     0.612    12.141     0.150
     0.612    20.598     0.150
     0.945    17.051     0.150
     0.945    29.871     0.150
     1.155    20.148     0.150
     1.155    35.238     0.150
     1.155    20.520     0.150
     1.155    36.621     0.150
     1.247    22.641     0.150
     1.247    39.371     0.150
     1.315    23.559     0.150
     1.315    40.758     0.150
     1.489    26.469     0.150
     1.489    46.500     0.150
     1.749    29.598     0.150
     1.749    52.141     0.150
     1.749    29.969     0.150
     1.749    51.570     0.150
     1.855    31.461     0.150
     1.855    55.570     0.150
     1.855    59.508     0.150
     1.888    31.598     0.150
     1.888    55.828     0.150
     1.888    31.918     0.150
     1.888    55.238     0.150
     1.968    35.188     0.150
     1.968    59.949     0.150
     2.675    41.461     0.150
     2.675    76.777     0.150
     3.344    51.109     0.150
     3.344    93.527     0.150
     3.329    51.398     0.150
     3.329    90.480     0.150
     3.379    53.250     0.150
     3.379    98.238     0.150
     0.675    13.243     0.150
     0.675    22.383     0.150
     0.930    17.233     0.150
     0.930    30.793     0.150
     1.169    20.523     0.150
     1.169    35.943     0.150
     1.226    22.693     0.150
     1.226    40.403     0.150
     1.226    40.683     0.150
     1.262    22.373     0.150
     1.262    40.083     0.150
     1.730    29.633     0.150
     1.730    50.123     0.150
     1.737    29.383     0.150
     1.737    51.483     0.150
     1.737    29.733     0.150
     1.737    51.043     0.150
     1.910    33.723     0.150
     1.910    59.893     0.150
     1.902    32.573     0.150
     1.902    57.183     0.150
     1.902    32.003     0.150
     1.902    54.953     0.150
     2.675    52.123     0.150
     2.675    86.723     0.150
     3.303    65.573     0.150
     3.369    59.223     0.150
     3.388    66.023     0.150
     3.388   101.163     0.150
     3.616    68.113     0.150
     3.616   114.673     0.150
     4.148    65.523     0.150
     4.148    81.215     0.150
     4.148   141.171     0.150
     7.769   113.493     0.150
     7.769   205.131     0.150
     7.769   246.063     0.150
     8.785   128.325     0.150
     8.785   272.828     0.150
     9.070   134.195     0.150
    10.628   156.443     0.150
    13.013   188.338     0.150
    13.013   413.436     0.150
    40.320   460.620     0.150
     0.673    13.240     0.150
     0.673    22.061     0.150
     0.940    17.250     0.150
     0.940    30.811     0.150
     1.161    21.150     0.150
     1.161    36.920     0.150
     1.267    22.740     0.150
     1.267    40.301     0.150
     1.236    21.910     0.150
     1.236    37.939     0.150
     1.236    22.750     0.150
     1.401    24.920     0.150
     1.401    44.221     0.150
     1.718    28.711     0.150
     1.718    49.830     0.150
     1.726    30.061     0.150
     1.726    51.631     0.150
     1.726    29.680     0.150
     1.726    51.109     0.150
     1.892    32.641     0.150
     1.892    57.270     0.150
     1.892    31.510     0.150
     1.892    54.990     0.150
     1.922    34.590     0.150
     1.922    59.641     0.150
     2.003    34.240     0.150
     2.003    60.320     0.150
     2.686    47.291     0.150
     2.686    82.080     0.150
     3.291    51.180     0.150
     3.291    90.561     0.150
     3.305    53.141     0.150
     3.305    92.881     0.150
     3.381    54.670     0.150
     3.381    96.600     0.150
     4.136   147.457     0.150
     7.769   114.830     0.150
     7.769   248.229     0.150
     8.793   128.086     0.150
     8.793   271.029     0.150
    40.308   463.609     0.150
     0.761    14.145     0.150
     0.761    24.105     0.150
     1.029    18.256     0.150
     1.029    31.064     0.150
     1.055    17.895     0.150
     1.055    32.375     0.150
     0.919    16.996     0.150
     0.919    30.115     0.150
     1.154    20.625     0.150
     1.154    36.395     0.150
     1.154    20.375     0.150
     1.475    25.586     0.150
     1.475    45.395     0.150
     1.475    25.996     0.150
     1.475    46.635     0.150
     1.516    26.625     0.150
     1.516    46.484     0.150
     1.615    26.035     0.150
     1.615    46.795     0.150
     1.887    32.035     0.150
     1.887    53.936     0.150
     2.648    42.375     0.150
     2.648    73.895     0.150
     2.727    74.984     0.150
     2.656    43.346     0.150
     3.295    51.975     0.150
     3.295    88.516     0.150
     3.279    57.996     0.150
     3.279    97.586     0.150
     4.034   117.725     0.150
     0.738    14.453     0.150
     0.738    24.723     0.150
     0.924    17.293     0.150
     0.924    29.922     0.150
     1.182    21.344     0.150
     1.182    37.133     0.150
     1.193    21.854     0.150
     1.193    37.863     0.150
     1.406    24.514     0.150
     1.406    39.832     0.150
     1.452    25.604     0.150
     1.452    44.162     0.150
     1.452    43.832     0.150
     1.391    25.402     0.150
     1.391    43.922     0.150
     1.530    26.803     0.150
     1.530    27.252     0.150
     1.685    29.123     0.150
     1.685    50.502     0.150
     1.685    53.133     0.150
     1.685    28.973     0.150
     1.685    50.273     0.150
     2.237    62.893     0.150
     2.307    38.723     0.150
     2.307    67.973     0.150
     2.989    83.693     0.150
     3.071    48.752     0.150
     3.071    85.703     0.150
     2.956    54.992     0.150
     2.956    95.344     0.150
     3.270    91.672     0.150
     0.780    15.203     0.150
     0.780    26.711     0.150
     0.886    16.742     0.150
     0.886    29.273     0.150
     1.144    21.102     0.150
     1.144    37.371     0.150
     1.144    19.914     0.150
     1.144    34.262     0.150
     1.182    21.902     0.150
     1.182    38.312     0.150
     1.182    21.512     0.150
     1.182    38.672     0.150
     1.154    21.324     0.150
     1.154    36.762     0.150
     1.448    25.691     0.150
     1.448    45.012     0.150
     1.448    44.613     0.150
     1.465    27.223     0.150
     1.465    46.621     0.150
     1.622    29.473     0.150
     1.622    50.422     0.150
     1.732    30.832     0.150
     1.732    30.574     0.150
     1.732    50.344     0.150
     2.002    55.551     0.150
     2.576    42.234     0.150
     2.718    73.871     0.150
     3.382    50.762     0.150
     3.571    65.355     0.150
     3.571    73.008     0.150
     3.571   122.883     0.150
     3.954    78.062     0.150
     4.286    65.902     0.150
     7.830   210.082     0.150
     7.830   252.332     0.150
     8.520   166.414     0.150
     9.220   137.578     0.150
     9.220   284.137     0.150
    39.776   457.633     0.150
     0.560    11.963     0.150
     0.560    20.393     0.150
     0.589    11.344     0.150
     0.589    19.744     0.150
     0.589    11.533     0.150
     0.589    19.613     0.150
     0.646    12.393     0.150
     0.646    21.693     0.150
     0.773    14.354     0.150
     0.773    25.023     0.150
     0.773    13.873     0.150
     0.773    25.863     0.150
     0.835    15.473     0.150
     0.835    27.193     0.150
     0.996    18.764     0.150
     0.996    32.953     0.150
     1.048    18.844     0.150
     1.048    32.824     0.150
     1.059    19.264     0.150
     1.059    33.754     0.150
     1.079    19.223     0.150
     1.079    34.074     0.150
     1.220    20.924     0.150
     1.220    39.223     0.150
     1.342    23.893     0.150
     1.342    41.553     0.150
     1.352    23.934     0.150
     1.352    44.254     0.150
     1.360    24.312     0.150
     1.385    23.482     0.150
     1.397    24.473     0.150
     1.386    24.084     0.150
     1.593    27.562     0.150
     1.593    48.533     0.150
     1.593    26.893     0.150
     1.593    47.453     0.150
     1.594    27.434     0.150
     1.626    26.623     0.150
     1.667    30.113     0.150
     1.667    51.574     0.150
     1.748    27.902     0.150
     1.748    27.643     0.150
     1.995    32.963     0.150
     2.117    34.543     0.150
     2.117    64.094     0.150
     2.117    33.812     0.150
     2.173    34.494     0.150
     2.173    59.824     0.150
     2.246    36.594     0.150
     2.285    36.414     0.150
     2.336    37.723     0.150
     2.474    39.033     0.150
     2.646    41.383     0.150
     2.685    42.723     0.150
     2.728    42.893     0.150
     2.749    43.184     0.150
     2.749    44.383     0.150
     2.749    88.158     0.150
     2.847    44.973     0.150
     2.938    44.834     0.150
     3.148    48.523     0.150
     3.148    86.584     0.150
     3.264    50.254     0.150
     3.509    53.623     0.150
     3.805    58.574     0.150
     3.806    58.562     0.150
     3.853    61.232     0.150
     4.282    74.973     0.150
     4.282   112.373     0.150
     4.531    70.283     0.150
     4.718    72.924     0.150
     5.602    82.004     0.150
     5.602   146.773     0.150
     6.929   100.684     0.150
     7.460   140.357     0.150
     7.460   236.357     0.150
     7.543   110.244     0.150
     7.629   111.754     0.150
     7.629   240.875     0.150
     9.251   134.473     0.150
     9.251   174.789     0.150
     9.251   292.113     0.150
     9.279   134.074     0.150
     9.484   138.488     0.150
     9.484   299.287     0.150
    11.876   379.588     0.150
     0.242     4.867     0.150
     0.242     8.457     0.150
     1.342    24.377     0.150
     1.342    42.347     0.150
     1.342    42.477     0.150
     1.337    24.267     0.150
     1.337    42.267     0.150
     1.337    25.157     0.150
     1.337    42.737     0.150
     1.378    24.697     0.150
     1.378    42.557     0.150
     1.378    45.247     0.150
     1.378    43.077     0.150
     1.419    24.897     0.150
     1.419    44.357     0.150
     1.506    26.147     0.150
     1.506    46.737     0.150
     1.506    25.637     0.150
     1.506    47.887     0.150
     1.481    26.907     0.150
     1.481    47.527     0.150
     2.428    41.577     0.150
     2.428    74.647     0.150
     2.963    47.517     0.150
     2.963    90.297     0.150
     3.060    48.737     0.150
     3.060    86.677     0.150
     3.178    51.277     0.150
     3.178    91.017     0.150
     0.828    16.020     0.150
     0.828    28.520     0.150
     0.815    15.680     0.150
     0.815    26.062     0.150
     1.082    19.332     0.150
     1.082    34.051     0.150
     1.209    22.680     0.150
     1.209    38.520     0.150
     1.209    20.770     0.150
     1.209    38.770     0.150
     1.283    23.223     0.150
     1.283    39.562     0.150
     1.283    23.070     0.150
     1.508    27.172     0.150
     1.508    48.211     0.150
     1.563    27.152     0.150
     1.563    47.062     0.150
     1.563    51.340     0.150
     1.563    45.910     0.150
     1.671    29.492     0.150
     1.671    50.699     0.150
     2.798    51.512     0.150
     2.798    87.320     0.150
     2.879    50.812     0.150
     2.879    86.520     0.150
     3.135    46.352     0.150
     3.135    86.180     0.150
     3.276    55.480     0.150
     3.276    96.691     0.150
     3.900    63.770     0.150
     3.900   110.590     0.150
     5.259    77.500     0.150
     0.822    15.479     0.150
     0.822    26.678     0.150
     0.822    27.449     0.150
     0.824    15.828     0.150
     0.824    27.158     0.150
     1.089    19.549     0.150
     1.089    34.199     0.150
     1.196    21.668     0.150
     1.196    37.639     0.150
     1.196    20.799     0.150
     1.196    35.818     0.150
     1.266    23.258     0.150
     1.266    40.588     0.150
     1.266    22.709     0.150
     1.266    38.748     0.150
     1.545    26.248     0.150
     1.545    46.389     0.150
     1.545    26.918     0.150
     1.545    45.678     0.150
     1.526    28.098     0.150
     1.526    47.789     0.150
     1.655    27.889     0.150
     1.655    49.758     0.150
     2.783    42.959     0.150
     2.783    78.678     0.150
     2.864    50.258     0.150
     2.864    79.299     0.150
     3.151    48.449     0.150
     3.151    87.568     0.150
     3.290    51.588     0.150
     3.290    95.979     0.150
     0.528    11.074     0.150
     0.528    11.094     0.150
     0.528    19.016     0.150
     0.564    10.766     0.150
     0.564    18.723     0.150
     0.564     9.664     0.150
     0.564    17.953     0.150
     0.677    12.824     0.150
     0.677    21.973     0.150
     0.677    23.406     0.150
     0.802    14.906     0.150
     0.802    26.543     0.150
     0.802    15.074     0.150
     0.802    26.344     0.150
     0.798    14.684     0.150
     0.798    25.062     0.150
     0.798    26.645     0.150
     0.798    24.613     0.150
     0.972    16.465     0.150
     0.972    31.855     0.150
     0.970    17.453     0.150
     0.970    30.812     0.150
     0.970    17.953     0.150
     0.970    30.914     0.150
     0.969    17.625     0.150
     0.969    31.273     0.150
     0.987    17.445     0.150
     0.987    32.895     0.150
     1.034    18.363     0.150
     1.034    32.355     0.150
     1.028    19.035     0.150
     1.028    32.723     0.150
     1.058    18.824     0.150
     1.058    33.312     0.150
     1.104    20.176     0.150
     1.104    35.953     0.150
     1.195    21.516     0.150
     1.195    37.363     0.150
     1.195    22.375     0.150
     1.195    37.953     0.150
     1.312    22.773     0.150
     1.312    39.914     0.150
     1.358    22.875     0.150
     1.356    23.586     0.150
     1.416    24.074     0.150
     1.472    24.914     0.150
     1.584    27.434     0.150
     1.584    48.023     0.150
     1.567    26.285     0.150
     2.084    33.906     0.150
     2.122    33.684     0.150
     2.251    36.273     0.150
     2.223    35.465     0.150
     2.306    36.973     0.150
     2.440    38.664     0.150
     2.464    39.383     0.150
     2.484    39.312     0.150
     2.612    41.035     0.150
     2.678    41.215     0.150
     2.716    45.227     0.150
     2.716    53.652     0.150
     2.716    86.328     0.150
     2.702    42.312     0.150
     2.816    43.766     0.150
     2.904    44.234     0.150
     5.581    83.574     0.150
     5.626    84.836     0.150
     5.894    88.824     0.150
     7.599   110.711     0.150
     7.599   145.109     0.150
     9.228   134.809     0.150
     9.515   137.258     0.150
     9.515   303.211     0.150
    11.864   173.285     0.150
    11.864   381.375     0.150
    12.175   177.992     0.150
    15.370   215.434     0.150
    15.395   216.445     0.150
    16.849   238.277     0.150
    16.856   233.695     0.150
    17.049   237.023     0.150
     0.498    10.260     0.150
     0.498    18.270     0.150
     0.552     9.980     0.150
     0.552    17.510     0.150
     0.551     9.980     0.150
     0.551    17.580     0.150
     0.699    12.930     0.150
     0.699    22.459     0.150
     0.699    23.799     0.150
     0.813    14.570     0.150
     0.813    26.330     0.150
     0.813    26.199     0.150
     0.940    17.469     0.150
     0.940    31.109     0.150
     0.940    16.820     0.150
     0.941    31.170     0.150
     0.945    15.719     0.150
     0.945    29.020     0.150
     0.958    31.061     0.150
     0.958    16.869     0.150
     0.958    31.680     0.150
     1.034    18.199     0.150
     1.034    32.539     0.150
     1.032    18.561     0.150
     1.032    32.141     0.150
     1.032    18.689     0.150
     1.032    32.570     0.150
     1.183    20.650     0.150
     1.183    37.670     0.150
     1.283    22.260     0.150
     1.283    39.260     0.150
     1.331    22.219     0.150
     1.331    40.100     0.150
     1.337    24.500     0.150
     1.337    42.510     0.150
     1.337    23.109     0.150
     1.423    23.830     0.150
     1.540    25.570     0.150
     1.763    52.609     0.150
     2.061    32.949     0.150
     2.116    33.119     0.150
     2.116    59.209     0.150
     2.198    34.990     0.150
     2.225    35.160     0.150
     2.277    36.340     0.150
     2.412    38.311     0.150
     2.585    41.469     0.150
     2.662    41.949     0.150
     2.674    41.289     0.150
     2.687    41.539     0.150
     2.787    44.119     0.150
     2.876    45.189     0.150
     3.186    48.799     0.150
     3.176    48.180     0.150
     3.295    51.070     0.150
     3.569    54.869     0.150
     3.777    57.311     0.150
     3.797    58.520     0.150
     3.854    57.930     0.150
     4.245    63.129     0.150
     4.503    69.141     0.150
     4.897    73.709     0.150
     5.176    78.400     0.150
     5.611    84.539     0.150
     5.917    88.920     0.150
     0.625    23.484     0.150
     0.558    12.195     0.150
     0.558    19.695     0.150
     0.619    11.383     0.150
     0.619    19.914     0.150
     0.619    12.164     0.150
     0.619    20.223     0.150
     0.744    24.805     0.150
     1.014    17.832     0.150
     1.014    32.414     0.150
     1.055    19.402     0.150
     1.055    34.383     0.150
     1.084    20.004     0.150
     1.084    34.062     0.150
     1.084    19.355     0.150
     1.084    34.594     0.150
     1.250    22.695     0.150
     1.250    39.285     0.150
     1.250    22.043     0.150
     1.250    40.012     0.150
     1.268    40.652     0.150
     1.328    23.965     0.150
     1.331    24.105     0.150
     1.331    41.363     0.150
     1.370    23.574     0.150
     1.370    41.902     0.150
     1.409    23.883     0.150
     1.409    46.434     0.150
     1.494    26.164     0.150
     1.543    26.703     0.150
     1.578    27.262     0.150
     1.578    46.902     0.150
     1.630    29.035     0.150
     1.630    49.762     0.150
     1.630    50.945     0.150
     1.832    28.734     0.150
     1.832    55.125     0.150
     2.006    60.254     0.150
     2.188    34.734     0.150
     2.188    64.953     0.150
     2.297    37.004     0.150
     2.325    37.285     0.150
     2.712    43.055     0.150
     2.840    45.402     0.150
     3.114    48.023     0.150
     3.114    92.953     0.150
     3.114    51.262     0.150
     0.526    19.105     0.150
     0.658    20.867     0.150
     0.593    11.418     0.150
     0.593    18.855     0.150
     0.592    11.457     0.150
     0.592    18.734     0.150
     0.771    26.656     0.150
     1.036    19.746     0.150
     1.036    33.445     0.150
     1.067    20.227     0.150
     1.067    34.078     0.150
     1.067    31.586     0.150
     1.224    22.715     0.150
     1.224    38.465     0.150
     1.224    38.805     0.150
     1.235    39.598     0.150
     1.321    24.137     0.150
     1.302    23.355     0.150
     1.302    39.965     0.150
     1.344    23.527     0.150
     1.344    40.965     0.150
     1.378    27.047     0.150
     1.464    25.496     0.150
     1.464    44.336     0.150
     1.515    26.156     0.150
     1.618    29.348     0.150
     1.618    49.957     0.150
     1.596    51.266     0.150
     2.155    32.234     0.150
     2.155    60.035     0.150
     2.203    36.227     0.150
     2.263    36.355     0.150
     2.687    42.758     0.150
     3.137    46.926     0.150
     3.137    85.105     0.150
     0.528    10.812     0.150
     0.528    18.312     0.150
     0.528    10.844     0.150
     0.566    10.562     0.150
     0.566    18.094     0.150
     0.565    10.531     0.150
     0.565    18.141     0.150
     0.565    19.055     0.150
     0.676    13.297     0.150
     0.676    23.031     0.150
     0.802    14.797     0.150
     0.802    25.961     0.150
     0.802    14.094     0.150
     0.797    15.102     0.150
     0.797    26.312     0.150
     0.797    14.672     0.150
     0.797    25.242     0.150
     0.970    30.641     0.150
     0.970    17.195     0.150
     0.968    17.758     0.150
     0.968    31.117     0.150
     0.968    31.625     0.150
     0.968    17.961     0.150
     0.987    16.875     0.150
     0.987    32.461     0.150
     1.036    18.594     0.150
     1.036    33.141     0.150
     1.028    18.445     0.150
     1.028    32.773     0.150
     1.057    18.734     0.150
     1.057    33.758     0.150
     1.105    20.016     0.150
     1.105    36.062     0.150
     1.116    19.688     0.150
     1.116    36.133     0.150
     1.183    20.383     0.150
     1.197    20.906     0.150
     1.197    36.492     0.150
     1.197    38.367     0.150
     1.197    20.195     0.150
     1.312    22.562     0.150
     1.357    23.312     0.150
     1.358    22.672     0.150
     1.349    22.461     0.150
     1.357    23.156     0.150
     1.414    23.742     0.150
     1.414    41.906     0.150
     1.472    24.594     0.150
     1.527    25.156     0.150
     1.567    25.922     0.150
     1.567    44.977     0.150
     1.586    27.227     0.150
     1.586    48.094     0.150
     1.586    50.867     0.150
     1.593    25.156     0.150
     1.791    27.297     0.150
     1.840    28.883     0.150
     2.086    32.664     0.150
     2.141    33.672     0.150
     2.141    60.562     0.150
     2.150    33.836     0.150
     2.223    35.391     0.150
     2.306    36.781     0.150
     2.441    38.484     0.150
     2.466    39.422     0.150
     2.484    38.602     0.150
     2.670    41.922     0.150
     2.701    42.094     0.150
     2.717    41.305     0.150
     2.716    41.031     0.150
     3.166    48.367     0.150
     3.166    88.031     0.150
     3.166    49.086     0.150
     3.166    49.367     0.150
     3.240    49.531     0.150
     3.590    55.062     0.150
     3.805    58.227     0.150
     3.857    57.836     0.150
     3.886   102.508     0.150
     3.886    57.836     0.150
     3.886    58.273     0.150
     4.311    63.812     0.150
     4.311   113.477     0.150
     4.380    67.195     0.150
     4.370    65.977     0.150
     4.519    69.117     0.150
     4.590    68.297     0.150
     4.713    72.266     0.150
     4.766    70.391     0.150
     4.735    71.273     0.150
     4.735   124.258     0.150
     4.785    71.906     0.150
     4.918    74.141     0.150
     5.046    75.805     0.150
     5.444    79.938     0.150
     5.630    84.336     0.150
     5.630   149.555     0.150
     5.700    84.664     0.150
     5.940    88.555     0.150
     6.151    91.891     0.150
     6.704    98.031     0.150
     6.784    97.891     0.150
     7.041   102.844     0.150
     7.041   181.688     0.150
     7.250   105.406     0.150
     7.476   111.336     0.150
     7.476   110.508     0.150
     7.471   109.852     0.150
     7.471   108.953     0.150
     7.471   229.727     0.150
     7.471   109.516     0.150
     7.599   109.812     0.150
     7.599   238.211     0.150
     7.848   114.688     0.150
     8.096   118.312     0.150
     8.439   123.086     0.150
     8.747   128.922     0.150
     8.888   133.211     0.150
     9.104   132.766     0.150
     9.227   134.609     0.150
     9.227   286.711     0.150
     9.247   133.703     0.150
     9.247   239.094     0.150
     9.306   135.688     0.150
     9.512   137.312     0.150
     9.513   137.586     0.150
     9.513   244.008     0.150
     9.513   299.781     0.150
     9.513   137.344     0.150
     9.939   144.242     0.150
    10.085   146.688     0.150
    10.094   145.062     0.150
    10.673   154.445     0.150
    11.373   159.938     0.150
    11.795   169.641     0.150
    11.863   167.586     0.150
    11.863   293.188     0.150
    11.863   369.734     0.150
    12.018   174.102     0.150
    12.175   174.656     0.150
    12.260   173.656     0.150
    12.559   177.688     0.150
    12.562   178.164     0.150
    13.038   183.477     0.150
    13.153   186.938     0.150
    13.179   189.805     0.150
    13.717   197.156     0.150
    13.892   194.773     0.150
    14.199   199.562     0.150
    14.215   199.102     0.150
    14.223   201.258     0.150
    14.345   203.055     0.150
    14.414   202.602     0.150
    14.419   204.758     0.150
    14.489   202.242     0.150
    14.538   209.195     0.150
    14.519   207.781     0.150
    14.589   205.695     0.150
    14.674   210.922     0.150
    14.722   207.172     0.150
    14.894   214.344     0.150
    14.979   215.672     0.150
    14.964   210.008     0.150
    14.986   210.961     0.150
    15.001   210.906     0.150
    15.165   216.367     0.150
    15.247   218.211     0.150
    15.292   218.734     0.150
    15.355   221.766     0.150
    15.387   219.391     0.150
    15.722   222.492     0.150
    15.810   224.492     0.150
    16.037   226.055     0.150
    16.037   226.758     0.150
    16.037   224.305     0.150
    16.288   228.961     0.150
    16.263   230.078     0.150
    16.435   232.086     0.150
    16.695   234.188     0.150
    16.808   236.703     0.150
    16.849   238.328     0.150
    16.849   237.852     0.150
    16.849   529.656     0.150
    16.849   236.812     0.150
    17.229   240.266     0.150
    17.296   241.758     0.150
    17.710   247.703     0.150
    18.058   249.773     0.150
    18.319   252.836     0.150
    18.387   253.758     0.150
    18.577   259.414     0.150
    18.740   258.352     0.150
    19.021   262.664     0.150
    19.865   271.492     0.150
    19.976   271.836     0.150
    20.071   274.664     0.150
    20.071   272.422     0.150
    21.697   288.633     0.150
    21.877   294.117     0.150
    21.877   292.234     0.150
    22.510   301.945     0.150
    23.251   306.688     0.150
    23.251   305.531     0.150
    23.844   311.875     0.150
    23.947   313.055     0.150
    24.822   322.953     0.150
    25.474   326.414     0.150
    32.477   387.453     0.150
    33.071   393.664     0.150
    34.326   404.484     0.150
    37.172   432.977     0.150
    38.850   447.438     0.150
    38.850   443.578     0.150
    39.634   449.992     0.150
    40.470   457.078     0.150
    40.729   461.609     0.150
    40.729   458.008     0.150
    40.773   460.023     0.150
    40.949   461.188     0.150
    41.335   464.062     0.150
    41.956   469.164     0.150
    45.237   496.055     0.150
    46.089   502.883     0.150
    46.286   505.211     0.150
    49.125   527.688     0.150
    57.143   588.703     0.150
    63.373   632.852     0.150
    64.285   636.406     0.150
    66.858   654.312     0.150
    68.174   660.281     0.150
    81.280   736.609     0.150
    81.964   740.258     0.150
    81.964   738.156     0.150
    83.944   750.961     0.150
    85.598   759.914     0.150
    86.146   760.391     0.150
    87.102   768.875     0.150
    87.580   769.922     0.150
    87.679   768.516     0.150
    87.679     5.781     0.150
    87.679   973.625     0.150
    87.679  1394.484     0.150
    89.683   777.844     0.150
    90.965   786.172     0.150
    92.045   788.266     0.150
   145.093  1179.883     0.150
   145.093  1177.453     0.150
     0.507    10.906     0.150
     0.507    18.727     0.150
     0.507    10.266     0.150
     0.573    10.383     0.150
     0.573    18.047     0.150
     0.573    19.406     0.150
     0.573    10.367     0.150
     0.573    18.055     0.150
     0.680    13.008     0.150
     0.680    22.430     0.150
     0.680    23.539     0.150
     0.792    14.984     0.150
     0.792    25.984     0.150
     0.792    26.625     0.150
     0.792    26.898     0.150
     0.792    14.367     0.150
     0.958    31.828     0.150
     0.958    16.305     0.150
     0.968    18.484     0.150
     1.053    19.188     0.150
     1.053    33.305     0.150
     1.053    20.953     0.150
     1.053    32.844     0.150
     1.028    18.719     0.150
     1.028    32.805     0.150
     1.163    22.539     0.150
     1.204    21.844     0.150
     1.204    37.789     0.150
     1.204    22.484     0.150
     1.212    38.977     0.150
     1.286    22.680     0.150
     1.286    40.188     0.150
     1.321    24.594     0.150
     1.321    41.625     0.150
     1.331    22.836     0.150
     1.331    39.953     0.150
     1.356    24.930     0.150
     1.356    45.406     0.150
     1.356    24.453     0.150
     1.401    25.633     0.150
     1.447    24.656     0.150
     1.500    25.258     0.150
     1.539    45.875     0.150
     1.539    25.984     0.150
     1.606    28.133     0.150
     1.606    49.133     0.150
     1.606    48.883     0.150
     1.776    55.125     0.150
     2.078    33.195     0.150
     2.103    35.336     0.150
     2.194    36.062     0.150
     2.241    35.586     0.150
     2.281    36.750     0.150
     2.423    39.453     0.150
     2.461    40.945     0.150
     2.599    40.773     0.150
     2.648    41.500     0.150
     2.674    42.555     0.150
     2.792    44.469     0.150
     2.889    46.617     0.150
     3.125    49.219     0.150
     3.155    49.383     0.150
     3.211    50.609     0.150
     3.308    51.914     0.150
     3.561    55.555     0.150
     3.780    58.164     0.150
     3.857    58.734     0.150
     4.253    65.164     0.150
     4.353    67.117     0.150
     4.491    70.109     0.150
     4.686    71.148     0.150
     4.888    75.016     0.150
     4.980    75.508     0.150
     5.554    81.008     0.150
     5.598    84.133     0.150
     5.601    84.664     0.150
     5.690    84.734     0.150
     5.865    88.367     0.150
     5.910    89.219     0.150
     6.042    91.273     0.150
     6.121    92.305     0.150
     6.122    91.984     0.150
     6.689   100.156     0.150
     6.978   103.953     0.150
     7.217   106.117     0.150
     8.172   122.133     0.150
     0.551    10.766     0.150
     0.551    17.898     0.150
     0.550    10.727     0.150
     0.550    18.195     0.150
     0.550    18.602     0.150
     0.726    13.875     0.150
     0.726    23.305     0.150
     0.726    25.227     0.150
     0.824    15.516     0.150
     0.824    26.648     0.150
     0.824    15.227     0.150
     0.824    26.164     0.150
     0.888    17.758     0.150
     0.888    29.914     0.150
     0.894    31.000     0.150
     0.906    16.375     0.150
     0.949    19.031     0.150
     0.949    32.797     0.150
     0.983    18.945     0.150
     0.983    32.891     0.150
     1.048    19.680     0.150
     1.048    33.617     0.150
     1.232    22.711     0.150
     1.232    39.008     0.150
     1.278    22.914     0.150
     1.278    39.719     0.150
     1.292    23.508     0.150
     1.319    24.188     0.150
     1.392    24.609     0.150
     1.392    43.055     0.150
     1.446    25.297     0.150
     1.419    24.852     0.150
     1.487    26.180     0.150
     1.610    28.969     0.150
     1.610    49.727     0.150
     1.724    54.109     0.150
     2.032    33.711     0.150
     2.146    35.031     0.150
     2.190    35.688     0.150
     2.226    36.766     0.150
     2.368    38.320     0.150
     2.622    42.578     0.150
     2.621    44.156     0.150
     2.641    43.617     0.150
     2.737    44.438     0.150
     2.835    46.414     0.150
     3.174    50.117     0.150
     3.254    52.766     0.150
     3.519    54.984     0.150
     3.765    58.469     0.150
     4.459    67.695     0.150
     4.663    70.648     0.150
     0.558    10.703     0.150
     0.558    17.953     0.150
     0.558    10.695     0.150
     0.558    18.062     0.150
     0.710    13.812     0.150
     0.710    23.727     0.150
     0.813    15.336     0.150
     0.813    26.273     0.150
     0.813    26.406     0.150
     0.923    16.336     0.150
     0.923    30.625     0.150
     0.923    30.867     0.150
     0.998    19.031     0.150
     0.998    32.758     0.150
     1.050    18.906     0.150
     1.050    33.375     0.150
     1.050    19.812     0.150
     1.050    33.195     0.150
     1.250    22.586     0.150
     1.250    39.398     0.150
     1.296    22.875     0.150
     1.296    39.258     0.150
     1.301    23.336     0.150
     1.331    24.828     0.150
     1.331    41.766     0.150
     1.331    24.602     0.150
     1.411    24.828     0.150
     1.411    43.172     0.150
     1.464    25.305     0.150
     1.464    43.648     0.150
     1.412    24.773     0.150
     1.505    26.227     0.150
     1.505    44.766     0.150
     1.609    28.008     0.150
     1.609    49.406     0.150
     2.048    33.469     0.150
     2.162    35.516     0.150
     2.207    34.922     0.150
     2.244    36.625     0.150
     2.386    39.266     0.150
     2.565    40.758     0.150
     2.639    42.188     0.150
     2.629    41.977     0.150
     2.660    43.133     0.150
     3.167    49.469     0.150
     3.167    48.992     0.150
     3.167    86.836     0.150
     3.167    87.227     0.150
     3.167    95.477     0.150
     4.469    67.734     0.150
     4.670    70.797     0.150
     4.758    70.781     0.150
     0.500    11.053     0.150
     0.500    18.854     0.150
     0.500    20.003     0.150
     0.566    10.733     0.150
     0.566    18.293     0.150
     0.566    10.713     0.150
     0.566    18.293     0.150
     0.688    13.533     0.150
     0.688    23.114     0.150
     0.688    24.364     0.150
     0.799    15.223     0.150
     0.799    26.344     0.150
     0.799    14.823     0.150
     0.799    26.463     0.150
     0.943    30.743     0.150
     0.951    16.453     0.150
     0.951    29.673     0.150
     0.951    31.344     0.150
     1.026    18.893     0.150
     1.026    33.523     0.150
     1.047    19.273     0.150
     1.047    33.303     0.150
     1.281    22.903     0.150
     1.281    40.213     0.150
     1.322    23.163     0.150
     1.348    23.364     0.150
     1.442    25.133     0.150
     1.442    44.573     0.150
     1.408    24.643     0.150
     1.535    25.624     0.150
     1.602    28.114     0.150
     1.602    48.763     0.150
     2.070    33.773     0.150
     2.096    34.683     0.150
     2.191    34.943     0.150
     2.233    35.813     0.150
     2.276    36.703     0.150
     2.416    38.133     0.150
     2.455    38.813     0.150
     2.592    40.183     0.150
     2.670    42.203     0.150
     2.690    42.773     0.150
     2.649    42.763     0.150
     2.786    43.703     0.150
     3.161    49.583     0.150
     3.560    54.493     0.150
     4.491    69.374     0.150
     4.688    69.243     0.150
     4.887    72.953     0.150
     4.977    74.693     0.150
     5.165    77.793     0.150
     5.594    81.393     0.150
     5.601    83.173     0.150
     5.697    83.833     0.150
     5.909    87.733     0.150
     0.796    15.255     0.150
     0.796    26.595     0.150
     1.063    19.265     0.150
     1.063    34.125     0.150
     1.197    20.936     0.150
     1.197    37.715     0.150
     1.197    21.186     0.150
     1.197    37.535     0.150
     1.279    23.035     0.150
     1.279    40.725     0.150
     1.279    22.715     0.150
     1.279    40.065     0.150
     1.567    26.865     0.150
     1.567    47.605     0.150
     1.567    47.135     0.150
     1.665    29.146     0.150
     1.732    31.705     0.150
     1.732    49.415     0.150
     2.001    33.725     0.150
     2.001    59.815     0.150
     2.788    45.665     0.150
     2.788    80.915     0.150
     2.869    45.885     0.150
     2.869    81.445     0.150
     3.142    49.735     0.150
     3.142    87.995     0.150
     3.263    49.005     0.150
     3.263    85.835     0.150
     5.256    77.735     0.150
     5.256   140.255     0.150
     6.266   166.565     0.150
     0.514    10.088     0.150
     0.514    17.098     0.150
     0.690    12.998     0.150
     0.690    22.488     0.150
     0.690    22.608     0.150
     0.708    12.958     0.150
     0.708    22.758     0.150
     0.738    25.748     0.150
     1.102    19.318     0.150
     1.102    34.938     0.150
     1.102    20.358     0.150
     1.102    34.798     0.150
     1.222    20.918     0.150
     1.222    37.728     0.150
     1.327    24.178     0.150
     1.327    41.798     0.150
     1.327    42.478     0.150
     1.349    22.828     0.150
     1.326    25.718     0.150
     1.326    41.218     0.150
     1.412    25.348     0.150
     1.412    44.678     0.150
     1.457    24.548     0.150
     1.550    48.838     0.150
     1.614    26.878     0.150
     1.614    45.498     0.150
     1.614    28.298     0.150
     1.614    49.878     0.150
     1.676    27.798     0.150
     1.924    33.958     0.150
     2.275    37.628     0.150
     2.275    64.898     0.150
     2.335    38.418     0.150
     2.335    67.078     0.150
     2.770    44.308     0.150
     3.083    88.188     0.150
     3.083    47.058     0.150
     3.083    50.128     0.150
     0.402     8.289     0.150
     0.402    14.750     0.150
     0.402    15.609     0.150
     0.554    10.133     0.150
     0.554    17.773     0.150
     0.757    14.109     0.150
     0.757    24.992     0.150
     0.678    22.961     0.150
     0.840    15.320     0.150
     0.840    27.070     0.150
     0.834    15.719     0.150
     0.834    27.930     0.150
     0.845    27.578     0.150
     0.867    15.430     0.150
     0.867    28.164     0.150
     0.931    16.641     0.150
     0.931    28.828     0.150
     0.991    19.195     0.150
     0.991    32.703     0.150
     1.068    18.633     0.150
     1.068    32.820     0.150
     1.068    19.148     0.150
     1.068    33.484     0.150
     1.179    20.242     0.150
     1.179    35.398     0.150
     1.249    21.469     0.150
     1.417    23.250     0.150
     1.433    23.711     0.150
     1.569    26.680     0.150
     1.635    27.523     0.150
     1.635    48.695     0.150
     1.603    25.344     0.150
     2.003    32.312     0.150
     2.003    56.914     0.150
     2.053    33.305     0.150
     2.053    56.953     0.150
     2.093    33.703     0.150
     2.172    33.461     0.150
     2.322    36.273     0.150
     2.353    37.750     0.150
     2.508    40.805     0.150
     2.579    39.828     0.150
     2.567    39.594     0.150
     2.593    42.062     0.150
     2.655    42.016     0.150
     2.684    42.281     0.150
     3.080    46.062     0.150
     3.173    46.219     0.150
     3.468    52.883     0.150
     3.689    55.203     0.150
     3.733    55.766     0.150
     4.142    62.570     0.150
     4.414    65.648     0.150
     4.625    67.312     0.150
     4.800    71.625     0.150
     5.085    75.742     0.150
     5.814    85.922     0.150
     0.593    11.754     0.150
     0.593    19.664     0.150
     0.593    20.512     0.150
     0.642    12.422     0.150
     0.642    21.473     0.150
     0.642    12.293     0.150
     0.642    21.211     0.150
     0.642    20.781     0.150
     0.740    14.645     0.150
     0.780    14.582     0.150
     0.780    25.883     0.150
     0.780    26.523     0.150
     1.013    18.531     0.150
     1.013    32.113     0.150
     1.013    31.711     0.150
     1.159    21.113     0.150
     1.270    22.172     0.150
     1.270    39.234     0.150
     1.251    22.223     0.150
     1.251    38.422     0.150
     1.251    42.844     0.150
     1.251    22.703     0.150
     1.251    23.223     0.150
     1.251    40.312     0.150
     1.251    40.574     0.150
     1.322    26.324     0.150
     1.322    41.242     0.150
     1.443    25.242     0.150
     1.466    27.121     0.150
     1.466    47.324     0.150
     1.529    25.621     0.150
     1.579    26.152     0.150
     1.520    26.395     0.150
     1.520    46.113     0.150
     1.520    25.422     0.150
     1.520    43.281     0.150
     1.788    28.941     0.150
     1.903    31.934     0.150
     2.228    39.145     0.150
     2.228    67.664     0.150
     2.291    42.562     0.150
     2.291    68.512     0.150
     2.327    37.914     0.150
     2.417    38.543     0.150
     2.439    39.711     0.150
     2.525    40.664     0.150
     2.785    43.254     0.150
     2.848    46.484     0.150
     2.919    46.594     0.150
     2.922    46.742     0.150
     2.989    48.383     0.150
     3.089    49.594     0.150
     3.175    52.074     0.150
     3.175    93.344     0.150
     3.647    57.352     0.150
     3.936    60.762     0.150
     4.051    63.262     0.150
     4.316    68.062     0.150
     4.471    69.254     0.150
     4.620    71.984     0.150
     4.700    72.582     0.150
     4.824    73.383     0.150
     5.377    81.871     0.150
     0.630    12.043     0.150
     0.630    21.203     0.150
     0.630    11.773     0.150
     0.630    18.996     0.150
     0.601    11.285     0.150
     0.601    19.875     0.150
     0.724    14.285     0.150
     0.724    25.066     0.150
     0.784    14.887     0.150
     0.784    26.066     0.150
     1.008    18.395     0.150
     1.008    31.645     0.150
     1.008    17.875     0.150
     1.008    30.535     0.150
     1.242    22.137     0.150
     1.242    38.684     0.150
     1.256    21.836     0.150
     1.355    24.066     0.150
     1.454    26.453     0.150
     1.444    24.215     0.150
     1.519    25.105     0.150
     1.520    25.805     0.150
     1.520    45.586     0.150
     1.520    43.184     0.150
     1.597    27.496     0.150
     1.629    27.625     0.150
     1.772    28.824     0.150
     1.887    30.574     0.150
     2.214    35.285     0.150
     2.214    59.586     0.150
     2.277    35.293     0.150
     2.277    62.363     0.150
     2.311    36.656     0.150
     2.402    38.023     0.150
     2.425    37.055     0.150
     2.465    44.324     0.150
     2.621    40.863     0.150
     2.682    40.164     0.150
     2.771    43.535     0.150
     2.903    45.035     0.150
     3.074    47.113     0.150
     3.178    48.227     0.150
     3.178    48.566     0.150
     3.178    87.766     0.150
     3.336    50.805     0.150
     3.493    53.215     0.150
     3.644    55.504     0.150
     3.681    56.895     0.150
     3.784    56.785     0.150
     3.829    58.836     0.150
     3.930    60.246     0.150
     4.324    65.016     0.150
     4.455    67.816     0.150
     4.624    69.605     0.150
     4.824    73.215     0.150
     4.879    72.914     0.150
     4.910    73.125     0.150
     5.104    76.805     0.150
     5.550    81.785     0.150
     5.550   150.887     0.150
     0.584    11.656     0.150
     0.654    12.137     0.150
     0.654    21.535     0.150
     0.653    12.266     0.150
     0.653    21.535     0.150
     0.653    23.258     0.150
     0.653    20.738     0.150
     0.774    14.566     0.150
     0.774    25.676     0.150
     1.019    18.496     0.150
     1.019    31.988     0.150
     1.172    21.688     0.150
     1.280    21.938     0.150
     1.280    39.719     0.150
     1.261    22.117     0.150
     1.261    38.426     0.150
     1.261    40.785     0.150
     1.335    40.047     0.150
     1.335    26.148     0.150
     1.335    26.605     0.150
     1.382    24.766     0.150
     1.382    42.977     0.150
     1.382    25.398     0.150
     1.439    24.578     0.150
     1.478    28.078     0.150
     1.535    25.578     0.150
     1.524    26.277     0.150
     1.524    45.719     0.150
     1.524    44.258     0.150
     1.799    29.258     0.150
     1.916    30.188     0.150
     2.240    35.816     0.150
     2.240    62.875     0.150
     2.304    37.957     0.150
     2.304    64.027     0.150
     2.449    38.516     0.150
     2.430    38.695     0.150
     2.537    41.406     0.150
     2.650    41.719     0.150
     2.711    42.469     0.150
     2.798    44.445     0.150
     2.933    45.586     0.150
     2.932    45.758     0.150
     3.102    47.836     0.150
     3.169    49.098     0.150
     3.169    91.727     0.150
     3.365    52.375     0.150
     3.709    56.695     0.150
     3.938    59.719     0.150
     4.064    61.938     0.150
     4.820    72.887     0.150
     0.588    11.520     0.150
     0.588    19.758     0.150
     0.588    20.949     0.150
     0.657    12.008     0.150
     0.657    21.168     0.150
     0.656    12.020     0.150
     0.656    21.148     0.150
     0.656    20.957     0.150
     0.783    14.367     0.150
     0.783    25.688     0.150
     0.783    14.598     0.150
     0.783    25.789     0.150
     0.769    15.500     0.150
     0.769    25.070     0.150
     0.768    14.449     0.150
     0.768    25.488     0.150
     1.039    19.859     0.150
     1.039    34.238     0.150
     1.013    18.238     0.150
     1.013    31.969     0.150
     1.013    18.098     0.150
     1.013    30.277     0.150
     1.185    19.438     0.150
     1.299    21.859     0.150
     1.299    39.117     0.150
     1.260    21.809     0.150
     1.260    38.539     0.150
     1.260    40.828     0.150
     1.260    42.758     0.150
     1.260    22.977     0.150
     1.350    25.188     0.150
     1.350    39.340     0.150
     1.450    24.238     0.150
     1.450    42.918     0.150
     1.390    23.379     0.150
     1.390    42.008     0.150
     1.554    25.699     0.150
     1.513    25.918     0.150
     1.513    44.707     0.150
     1.513    45.387     0.150
     1.513    25.797     0.150
     1.513    44.488     0.150
     1.482    26.359     0.150
     1.817    29.559     0.150
     1.817    52.078     0.150
     1.928    30.570     0.150
     2.248    36.598     0.150
     2.248    58.359     0.150
     2.312    36.449     0.150
     2.312    61.379     0.150
     2.354    36.887     0.150
     2.354    64.719     0.150
     2.468    38.227     0.150
     2.440    38.207     0.150
     2.440    68.859     0.150
     2.555    39.660     0.150
     2.663    41.328     0.150
     2.727    41.469     0.150
     2.871    44.180     0.150
     2.809    43.137     0.150
     2.952    45.047     0.150
     2.946    45.117     0.150
     2.946    44.242     0.150
     2.946    51.617     0.150
     2.946    94.168     0.150
     3.017    45.867     0.150
     3.060    46.777     0.150
     3.177    48.898     0.150
     3.177    60.027     0.150
     3.177    98.500     0.150
     3.114    48.438     0.150
     3.380    51.270     0.150
     3.464    51.449     0.150
     3.533    54.090     0.150
     3.660    55.500     0.150
     3.824    57.488     0.150
     7.537   235.719     0.150
     7.847   111.898     0.150
     7.847   245.473     0.150
     9.408   287.973     0.150
     9.473   301.473     0.150
    12.075   170.297     0.150
    12.075   385.898     0.150
    14.113   197.047     0.150
    14.346   200.070     0.150
    14.379   201.688     0.150
     0.539    10.707     0.150
     0.539    17.930     0.150
     0.539    19.336     0.150
     0.682    12.168     0.150
     0.682    21.648     0.150
     0.682    12.188     0.150
     0.682    21.668     0.150
     0.696    13.246     0.150
     0.696    22.938     0.150
     0.685    13.789     0.150
     0.685    23.859     0.150
     0.685    13.797     0.150
     0.685    23.430     0.150
     0.960    31.238     0.150
     1.099    19.930     0.150
     1.099    34.078     0.150
     1.099    20.129     0.150
     1.099    32.957     0.150
     1.108    20.469     0.150
     1.108    35.867     0.150
     1.132    20.770     0.150
     1.132    36.199     0.150
     1.128    35.680     0.150
     1.146    20.996     0.150
     1.170    36.098     0.150
     1.170    19.258     0.150
     1.306    23.477     0.150
     1.345    24.918     0.150
     1.371    43.520     0.150
     1.413    23.996     0.150
     1.495    46.129     0.150
     1.622    46.078     0.150
     1.622    44.836     0.150
     1.875    31.336     0.150
     2.236    35.969     0.150
     2.236    63.117     0.150
     2.294    65.227     0.150
     2.281    35.559     0.150
     2.341    36.680     0.150
     2.409    38.938     0.150
     2.600    41.727     0.150
     2.771    44.098     0.150
     2.836    43.629     0.150
     2.875    45.059     0.150
     2.968    46.680     0.150
     3.064    49.699     0.150
     3.086    49.617     0.150
     3.086    49.059     0.150
     3.086    96.109     0.150
     3.358    52.129     0.150
     3.535    53.809     0.150
     3.688    56.277     0.150
     3.856    58.680     0.150
     4.255    64.707     0.150
     4.420    67.379     0.150
     4.535    66.867     0.150
     4.583    69.828     0.150
     4.721    71.289     0.150
     4.748    70.438     0.150
     5.004    75.887     0.150
     5.261    80.109     0.150
     5.713    86.348     0.150
     6.001    90.188     0.150
     6.014    89.848     0.150
     0.616    12.135     0.150
     0.616    20.674     0.150
     0.616    21.584     0.150
     0.616    21.895     0.150
     0.605    11.844     0.150
     0.605    20.523     0.150
     0.604    11.863     0.150
     0.604    19.783     0.150
     0.604    20.045     0.150
     0.640    12.465     0.150
     0.640    12.545     0.150
     0.772    14.564     0.150
     0.772    25.123     0.150
     0.772    26.094     0.150
     0.913    16.773     0.150
     1.026    18.693     0.150
     1.026    32.373     0.150
     1.026    32.584     0.150
     1.095    19.203     0.150
     1.095    19.354     0.150
     1.142    20.584     0.150
     1.165    20.395     0.150
     1.165    36.584     0.150
     1.216    22.033     0.150
     1.229    21.824     0.150
     1.229    37.443     0.150
     1.229    37.324     0.150
     1.301    22.033     0.150
     1.416    24.635     0.150
     1.416    42.635     0.150
     1.436    24.373     0.150
     1.436    42.684     0.150
     1.427    24.074     0.150
     1.473    24.975     0.150
     1.418    25.514     0.150
     1.581    26.154     0.150
     1.557    26.914     0.150
     1.557    46.545     0.150
     1.557    26.795     0.150
     1.587    26.523     0.150
     1.681    27.895     0.150
     1.816    29.283     0.150
     1.816    54.123     0.150
     1.966    30.863     0.150
     1.966    56.135     0.150
     2.182    35.965     0.150
     2.164    35.824     0.150
     2.164    60.064     0.150
     2.231    38.744     0.150
     2.224    36.074     0.150
     2.224    63.844     0.150
     2.333    37.023     0.150
     2.421    39.055     0.150
     2.546    42.145     0.150
     2.597    41.523     0.150
     2.707    43.135     0.150
     2.816    43.854     0.150
     2.825    45.404     0.150
     2.825    57.229     0.150
     2.825   100.678     0.150
     2.885    44.914     0.150
     2.929    46.795     0.150
     3.160    48.564     0.150
     3.160    49.004     0.150
     3.256    53.484     0.150
     3.351    51.783     0.150
     3.594    54.574     0.150
     3.694    57.504     0.150
     3.788    57.004     0.150
     3.788    61.873     0.150
     3.865    59.443     0.150
     3.881    60.135     0.150
     3.962    63.514     0.150
     4.332    65.863     0.150
     4.388    67.344     0.150
     4.456    68.523     0.150
     4.609    69.873     0.150
     4.608    71.645     0.150
     4.789    72.324     0.150
     4.786    73.084     0.150
     4.752    70.613     0.150
     4.827    73.725     0.150
     5.017    76.664     0.150
     5.121    77.684     0.150
     5.284    80.725     0.150
     5.343    80.703     0.150
     5.460    83.844     0.150
     5.574    84.273     0.150
     5.538    83.523     0.150
     5.686    84.215     0.150
     5.657    85.453     0.150
     5.728    86.814     0.150
     6.011    90.715     0.150
     6.005    90.184     0.150
     6.045    90.635     0.150
     6.651    96.693     0.150
     6.712    99.324     0.150
     6.846   103.693     0.150
     7.152   102.244     0.150
     7.492   110.229     0.150
     7.492   139.652     0.150
     7.492   199.328     0.150
     7.492   234.678     0.150
     7.537   111.334     0.150
     7.714   148.965     0.150
     7.714   254.584     0.150
     8.053   119.354     0.150
     8.289   122.395     0.150
     8.637   127.363     0.150
     9.065   133.895     0.150
     9.260   135.033     0.150
     9.338   137.934     0.150
     9.338   302.232     0.150
     9.455   135.453     0.150
     9.456   137.908     0.150
     9.456   240.510     0.150
     9.456   292.334     0.150
     9.456   136.994     0.150
     9.553   137.975     0.150
    10.011   144.533     0.150
    11.955   176.016     0.150
    31.091   379.658     0.150
    38.965   448.854     0.150
    92.130   790.209     0.150
     0.623    12.969     0.150
     0.623    22.367     0.150
     0.602    11.750     0.150
     0.602    20.352     0.150
     0.602    11.641     0.150
     0.602    19.969     0.150
     0.603    11.609     0.150
     0.603    20.055     0.150
     0.620    11.945     0.150
     0.620    20.609     0.150
     0.620    21.695     0.150
     0.769    14.391     0.150
     0.769    25.641     0.150
     0.769    26.297     0.150
     0.769    24.617     0.150
     0.896    15.680     0.150
     1.059    18.328     0.150
     1.064    34.906     0.150
     1.079    33.805     0.150
     1.033    18.508     0.150
     1.033    32.422     0.150
     1.033    33.211     0.150
     1.033    31.508     0.150
     1.145    20.617     0.150
     1.145    37.156     0.150
     1.145    20.500     0.150
     1.209    21.617     0.150
     1.209    38.219     0.150
     1.229    21.688     0.150
     1.229    37.758     0.150
     1.229    39.445     0.150
     1.292    23.078     0.150
     1.292    40.469     0.150
     1.292    22.039     0.150
     1.408    25.117     0.150
     1.408    45.055     0.150
     1.418    24.000     0.150
     1.453    24.922     0.150
     1.453    43.531     0.150
     1.409    24.328     0.150
     1.413    24.945     0.150
     1.413    44.031     0.150
     1.567    26.672     0.150
     1.567    45.609     0.150
     1.623    27.320     0.150
     1.567    46.281     0.150
     1.567    49.734     0.150
     1.619    26.945     0.150
     1.619    47.836     0.150
     1.662    28.070     0.150
     1.662    27.945     0.150
     1.601    25.789     0.150
     1.802    28.859     0.150
     1.802    29.086     0.150
     1.925    30.977     0.150
     2.156    35.445     0.150
     2.156    60.766     0.150
     2.163    35.648     0.150
     2.214    32.898     0.150
     2.214    61.391     0.150
     2.575    46.031     0.150
     3.154    48.328     0.150
     3.154    86.891     0.150
     0.348     6.973     0.150
     0.348    11.684     0.150
     0.348    11.941     0.150
     1.228    21.781     0.150
     1.228    37.031     0.150
     1.228    38.691     0.150
     1.228    39.730     0.150
     1.228    36.773     0.150
     1.192    21.891     0.150
     1.192    37.543     0.150
     1.192    37.262     0.150
     1.382    25.543     0.150
     1.382    43.980     0.150
     1.382    23.652     0.150
     1.382    41.891     0.150
     1.480    28.102     0.150
     1.480    43.461     0.150
     1.409    23.434     0.150
     1.409    42.121     0.150
     2.312    38.820     0.150
     2.312    66.371     0.150
     2.815    49.363     0.150
     2.815    80.184     0.150
     2.913    83.871     0.150
     0.624    12.965     0.150
     0.624    13.074     0.150
     0.624    21.645     0.150
     0.601    11.883     0.150
     0.601    18.434     0.150
     0.600    11.914     0.150
     0.600    20.305     0.150
     0.600    21.352     0.150
     0.600    21.805     0.150
     0.621    12.145     0.150
     0.621    20.844     0.150
     0.621    21.723     0.150
     0.621    21.875     0.150
     0.772    14.645     0.150
     0.772    25.242     0.150
     0.772    26.555     0.150
     0.897    17.184     0.150
     1.059    18.465     0.150
     1.059    32.523     0.150
     1.065    34.844     0.150
     1.066    19.953     0.150
     1.066    34.703     0.150
     1.066    20.133     0.150
     1.066    34.824     0.150
     1.080    19.465     0.150
     1.030    18.875     0.150
     1.030    32.375     0.150
     1.030    31.402     0.150
     1.126    20.445     0.150
     1.126    36.254     0.150
     1.148    20.742     0.150
     1.148    36.562     0.150
     1.210    40.055     0.150
     1.226    21.852     0.150
     1.226    37.684     0.150
     1.226    38.172     0.150
     1.291    22.062     0.150
     1.291    38.984     0.150
     1.410    24.633     0.150
     1.410    45.445     0.150
     1.411    25.035     0.150
     1.411    44.152     0.150
     1.421    24.195     0.150
     1.421    42.395     0.150
     1.455    25.023     0.150
     1.570    26.684     0.150
     1.570    49.184     0.150
     1.625    27.395     0.150
     1.563    27.133     0.150
     1.563    47.004     0.150
     1.563    50.195     0.150
     1.563    26.895     0.150
     1.563    46.305     0.150
     1.617    27.305     0.150
     1.617    50.375     0.150
     1.664    28.113     0.150
     1.664    48.715     0.150
     1.802    28.672     0.150
     1.925    31.125     0.150
     2.165    34.992     0.150
     2.155    35.195     0.150
     2.155    62.852     0.150
     2.216    36.602     0.150
     2.214    35.914     0.150
     2.214    63.492     0.150
     2.316    37.133     0.150
     2.331    37.305     0.150
     2.331    65.984     0.150
     2.532    39.793     0.150
     2.581    40.934     0.150
     2.695    41.965     0.150
     2.573    45.902     0.150
     2.573    83.445     0.150
     2.799    43.703     0.150
     2.810    47.539     0.150
     2.913    45.633     0.150
     2.991    47.645     0.150
     3.158    48.773     0.150
     3.158    48.633     0.150
     3.158    98.883     0.150
     3.577    54.945     0.150
     3.586    55.324     0.150
     3.678    57.152     0.150
     3.866    60.684     0.150
     3.853    59.504     0.150
     3.801    58.652     0.150
     3.801    59.785     0.150
     3.801   113.934     0.150
     3.981    60.293     0.150
     4.164    63.652     0.150
     4.229    63.613     0.150
     4.443    68.383     0.150
     4.593    71.254     0.150
     4.493    71.602     0.150
     4.607    68.723     0.150
     4.643    80.715     0.150
     4.643   135.285     0.150
     4.773    72.805     0.150
     4.783    72.523     0.150
     4.818    73.555     0.150
     5.001    77.023     0.150
     5.104    78.203     0.150
     5.268    80.992     0.150
     5.333    81.262     0.150
     5.641    85.805     0.150
     5.670    84.422     0.150
     5.580    85.824     0.150
     5.685    85.062     0.150
     5.988    89.363     0.150
     6.029    90.273     0.150
     6.635    98.195     0.150
     6.708    99.793     0.150
     7.137   106.352     0.150
     7.486   109.316     0.150
     7.486   233.516     0.150
     7.525   112.023     0.150
     7.697   116.188     0.150
     8.056   117.285     0.150
     8.274   121.023     0.150
     8.834   131.242     0.150
     9.321   136.246     0.150
     9.321   292.906     0.150
     9.264   134.504     0.150
     9.461   137.062     0.150
     9.462   136.785     0.150
     9.462   292.863     0.150
     9.462   138.715     0.150
    11.939   173.602     0.150
    23.311   308.598     0.150
    31.074   379.824     0.150
    38.948   448.090     0.150
    81.378   737.023     0.150
     7.484   108.945     0.150
     0.369     7.712     0.150
     0.369    12.612     0.150
     0.369    13.093     0.150
     1.201    21.632     0.150
     1.201    37.152     0.150
     1.201    37.853     0.150
     1.201    21.893     0.150
     1.201    36.683     0.150
     1.266    21.562     0.150
     1.266    36.672     0.150
     1.266    38.282     0.150
     1.266    39.022     0.150
     1.266    35.622     0.150
     1.365    24.223     0.150
     1.365    42.462     0.150
     1.365    43.232     0.150
     1.350    24.853     0.150
     1.350    42.393     0.150
     1.638    28.053     0.150
     1.638    49.112     0.150
     1.638    52.582     0.150
     1.638    53.252     0.150
     1.572    27.362     0.150
     1.572    49.702     0.150
     1.896    31.742     0.150
     1.896    55.782     0.150
     2.290    36.212     0.150
     2.821    44.792     0.150
     2.821    75.322     0.150
     2.917    47.162     0.150
     2.917    77.562     0.150
     0.603    11.684     0.150
     0.603    20.145     0.150
     0.603    11.574     0.150
     0.618    12.254     0.150
     0.618    20.453     0.150
     0.658    12.693     0.150
     0.780    14.475     0.150
     0.780    24.824     0.150
     1.015    18.633     0.150
     1.015    32.475     0.150
     1.015    31.873     0.150
     1.225    22.613     0.150
     1.225    39.303     0.150
     1.225    40.064     0.150
     1.225    41.014     0.150
     1.242    41.623     0.150
     1.309    23.824     0.150
     1.309    41.863     0.150
     1.421    27.133     0.150
     1.421    47.414     0.150
     1.541    26.834     0.150
     1.541    47.895     0.150
     1.541    26.664     0.150
     1.541    46.043     0.150
     1.561    28.203     0.150
     1.561    49.334     0.150
     2.171    34.793     0.150
     2.171    61.844     0.150
     2.232    36.174     0.150
     2.232    61.434     0.150
     0.618    11.586     0.150
     0.618    20.297     0.150
     0.618    11.734     0.150
     0.618    19.984     0.150
     0.618    11.625     0.150
     0.604    11.684     0.150
     0.604    20.406     0.150
     0.770    14.367     0.150
     0.770    24.887     0.150
     0.770    14.477     0.150
     1.024    18.625     0.150
     1.024    32.434     0.150
     1.024    19.484     0.150
     1.024    31.676     0.150
     1.199    21.695     0.150
     1.199    36.637     0.150
     1.238    22.867     0.150
     1.238    39.414     0.150
     1.238    41.926     0.150
     1.238    39.707     0.150
     1.258    25.266     0.150
     1.258    37.734     0.150
     1.325    24.305     0.150
     1.325    41.977     0.150
     1.465    24.746     0.150
     1.465    44.574     0.150
     1.547    45.914     0.150
     1.547    26.816     0.150
     1.547    48.105     0.150
     1.547    49.766     0.150
     1.716    32.285     0.150
     2.187    38.176     0.150
     2.187    62.746     0.150
     2.217    39.387     0.150
     2.248    38.836     0.150
     2.248    62.395     0.150
     2.367    40.797     0.150
     2.786    44.156     0.150
     2.857    49.645     0.150
     2.918    48.316     0.150
     2.964    50.023     0.150
     3.034    51.844     0.150
     3.161    47.594     0.150
     3.161    59.934     0.150
     3.161    98.617     0.150
     3.385    53.555     0.150
     3.909    61.184     0.150
     4.636    70.836     0.150
     5.313    79.965     0.150
     0.602    11.594     0.150
     0.602    19.871     0.150
     0.758    14.152     0.150
     0.758    24.684     0.150
     0.758    25.312     0.150
     0.648    12.902     0.150
     0.648    22.801     0.150
     0.648    12.844     0.150
     0.619    11.523     0.150
     0.619    20.230     0.150
     0.618    11.543     0.150
     0.618    20.211     0.150
     0.618    11.434     0.150
     1.088    20.371     0.150
     1.088    36.371     0.150
     1.088    20.191     0.150
     1.039    18.402     0.150
     1.039    32.512     0.150
     1.039    33.211     0.150
     1.039    31.133     0.150
     1.090    33.973     0.150
     1.167    20.242     0.150
     1.167    36.812     0.150
     1.235    23.074     0.150
     1.235    40.781     0.150
     1.243    21.621     0.150
     1.243    39.172     0.150
     1.243    41.871     0.150
     1.243    22.902     0.150
     1.243    39.723     0.150
     1.314    23.461     0.150
     1.314    41.512     0.150
     1.314    24.113     0.150
     1.433    23.832     0.150
     1.568    26.543     0.150
     1.568    47.480     0.150
     1.568    26.691     0.150
     1.568    48.012     0.150
     1.686    27.781     0.150
     1.827    28.941     0.150
     2.187    34.922     0.150
     2.178    34.504     0.150
     2.178    62.082     0.150
     2.241    35.793     0.150
     2.237    35.391     0.150
     2.237    60.723     0.150
     2.335    37.113     0.150
     2.355    36.922     0.150
     2.428    38.152     0.150
     2.550    45.082     0.150
     2.550    76.621     0.150
     2.557    39.312     0.150
     2.605    41.383     0.150
     2.755    43.414     0.150
     2.719    42.504     0.150
     2.820    43.754     0.150
     2.886    44.781     0.150
     2.835    43.031     0.150
     2.835    57.270     0.150
     2.835    99.145     0.150
     2.937    46.121     0.150
     3.147    47.352     0.150
     3.147    48.441     0.150
     3.147    94.871     0.150
     3.016    46.004     0.150
     3.265    49.922     0.150
     3.353    51.402     0.150
     3.584    54.254     0.150
     3.601    54.543     0.150
     3.694    56.730     0.150
     3.776   116.871     0.150
     3.753    57.262     0.150
     3.857    59.203     0.150
     3.878    60.062     0.150
     3.972    59.391     0.150
     4.004    59.621     0.150
     4.319    66.391     0.150
     4.254    67.262     0.150
     4.451    68.363     0.150
     4.395    66.793     0.150
     4.389    65.781     0.150
     4.596    69.363     0.150
     4.604    71.102     0.150
     4.777    72.191     0.150
     4.780    72.633     0.150
     4.817    73.082     0.150
     4.839    75.332     0.150
     5.016    76.730     0.150
     5.124    76.730     0.150
     5.142    78.723     0.150
     5.163    80.043     0.150
     5.176    76.621     0.150
     5.281    80.871     0.150
     5.335    80.980     0.150
     5.673    84.262     0.150
     5.550    81.391     0.150
     5.656    85.324     0.150
     5.727    86.980     0.150
     5.701    85.531     0.150
     6.011    88.801     0.150
     6.008    89.023     0.150
     6.046    90.133     0.150
     6.324    94.934     0.150
     6.546    96.504     0.150
     6.700    98.934     0.150
     6.659    97.992     0.150
     6.844   102.473     0.150
     7.114   105.141     0.150
     7.148   105.352     0.150
     7.481   137.246     0.150
     7.481   232.746     0.150
     7.529   111.613     0.150
     7.721   117.781     0.150
     7.721   147.828     0.150
     7.721   251.051     0.150
     7.919   119.441     0.150
     8.039   118.871     0.150
     8.192   120.941     0.150
     8.208   119.621     0.150
     8.249   120.871     0.150
     8.285   119.934     0.150
     8.416   123.574     0.150
     8.845   131.074     0.150
     9.340   139.227     0.150
     9.340   179.051     0.150
     9.340   298.602     0.150
     9.442   134.977     0.150
     9.442   291.203     0.150
    11.952   174.609     0.150
    11.952   222.160     0.150
    11.952   379.453     0.150
    12.201   174.242     0.150
    38.971   448.504     0.150
    81.402   737.477     0.150
     0.597    11.906     0.150
     0.597    20.141     0.150
     0.597    20.930     0.150
     0.597    21.336     0.150
     0.624    11.453     0.150
     0.624    20.172     0.150
     0.623    11.430     0.150
     0.623    20.000     0.150
     0.671    12.812     0.150
     0.671    22.672     0.150
     0.762    14.055     0.150
     0.762    24.461     0.150
     0.762    25.445     0.150
     0.762    25.016     0.150
     1.032    18.359     0.150
     1.032    31.750     0.150
     1.032    33.211     0.150
     1.032    32.992     0.150
     1.193    20.281     0.150
     1.193    20.711     0.150
     1.193    37.023     0.150
     1.257    23.625     0.150
     1.257    36.977     0.150
     1.245    22.453     0.150
     1.245    39.070     0.150
     1.245    22.844     0.150
     1.245    39.734     0.150
     1.328    23.766     0.150
     1.457    24.031     0.150
     1.556    26.531     0.150
     1.556    46.555     0.150
     1.556    46.961     0.150
     1.712    27.914     0.150
     1.847    31.602     0.150
     2.213    36.680     0.150
     2.191    34.953     0.150
     2.191    60.445     0.150
     2.263    39.820     0.150
     2.251    35.953     0.150
     2.251    62.016     0.150
     2.362    36.953     0.150
     2.371    37.953     0.150
     2.452    39.016     0.150
     2.577    42.297     0.150
     2.629    43.383     0.150
     2.778    44.070     0.150
     2.736    44.500     0.150
     2.846    44.430     0.150
     2.856    45.359     0.150
     2.912    45.695     0.150
     2.961    46.633     0.150
     3.035    49.273     0.150
     3.153    49.602     0.150
     3.153    48.414     0.150
     3.153    97.297     0.150
     3.288    53.102     0.150
     3.599    56.594     0.150
     3.720    58.141     0.150
     3.759    59.141     0.150
     3.759   115.961     0.150
     3.776    59.141     0.150
     3.877    58.594     0.150
     3.901    60.461     0.150
     4.029    61.531     0.150
     4.317    66.055     0.150
     4.420    67.344     0.150
     4.473    68.742     0.150
     4.601    69.695     0.150
     4.628    71.094     0.150
     4.788    73.391     0.150
     4.802    72.359     0.150
     4.833    73.383     0.150
     4.843    75.352     0.150
     5.041    76.477     0.150
     5.150    78.461     0.150
     5.167    77.820     0.150
     5.305    80.586     0.150
     5.352    80.375     0.150
     5.677    83.992     0.150
     5.681    85.242     0.150
     5.726    87.320     0.150
     5.752    86.711     0.150
     6.036    91.211     0.150
     6.034    90.609     0.150
     6.072    90.930     0.150
     6.199    92.227     0.150
     6.868   103.945     0.150
     7.171   106.766     0.150
     7.548   111.977     0.150
     8.286   122.375     0.150
     8.289   122.906     0.150
     0.578    11.426     0.150
     0.578    19.285     0.150
     0.578    20.625     0.150
     0.643    20.516     0.150
     0.643    21.934     0.150
     0.643    11.652     0.150
     0.643    20.414     0.150
     0.675    13.414     0.150
     0.675    23.332     0.150
     0.740    13.664     0.150
     0.740    23.832     0.150
     1.054    19.285     0.150
     1.054    33.113     0.150
     1.054    19.426     0.150
     1.054    33.395     0.150
     1.265    22.855     0.150
     1.265    39.773     0.150
     1.265    41.293     0.150
     1.262    21.543     0.150
     1.262    37.082     0.150
     1.342    24.426     0.150
     1.342    42.742     0.150
     1.578    27.004     0.150
     1.578    47.375     0.150
     1.578    50.652     0.150
     1.578    44.945     0.150
     1.655    29.074     0.150
     1.655    51.105     0.150
     1.925    58.715     0.150
     2.206    34.992     0.150
     2.206    60.105     0.150
     2.265    37.344     0.150
     2.265    60.984     0.150
     3.131    48.754     0.150
     3.131    88.965     0.150
     0.683    13.053     0.150
     0.683    22.583     0.150
     0.988    17.783     0.150
     0.988    31.453     0.150
     1.167    20.863     0.150
     1.167    36.243     0.150
     1.246    21.153     0.150
     1.246    37.522     0.150
     1.454    23.752     0.150
     1.454    41.133     0.150
     1.479    24.963     0.150
     1.479    43.863     0.150
     1.479    44.373     0.150
     1.465    25.363     0.150
     1.465    45.593     0.150
     1.690    28.183     0.150
     1.690    49.502     0.150
     1.690    49.812     0.150
     1.886    32.073     0.150
     1.886    55.713     0.150
     1.843    30.343     0.150
     2.229    35.323     0.150
     2.387    37.252     0.150
     2.830    44.312     0.150
     2.927    45.663     0.150
     2.927    45.873     0.150
     2.927    80.413     0.150
     3.030    46.633     0.150
     3.030    83.533     0.150
     3.114    86.663     0.150
     3.271    52.423     0.150
     3.287    50.303     0.150
     3.310    51.183     0.150
     3.310    51.283     0.150
     3.310    89.113     0.150
     3.400    52.743     0.150
     3.514    52.363     0.150
     3.575    55.533     0.150
     3.783    59.252     0.150
     3.783   100.923     0.150
     3.873    78.103     0.150
     3.906    59.353     0.150
     3.918    60.423     0.150
     4.120    62.693     0.150
     4.545    68.232     0.150
     4.670    69.913     0.150
     5.088    75.593     0.150
     5.334    78.633     0.150
     5.410    80.423     0.150
     5.501    82.713     0.150
     5.674    84.633     0.150
     6.187    92.603     0.150
     6.890   101.453     0.150
     6.994   103.363     0.150
     7.454   109.663     0.150
     7.780   113.653     0.150
     7.774   113.932     0.150
     7.774   246.901     0.150
     7.774   114.653     0.150
     7.774   114.123     0.150
     7.774   114.482     0.150
     8.805   132.115     0.150
     8.974   130.727     0.150
     8.974   280.862     0.150
    10.398   153.154     0.150
    10.398   337.848     0.150
    12.851   409.602     0.150
    17.956   248.603     0.150
    18.183   254.193     0.150
    19.338   265.663     0.150
    20.087   273.703     0.150
    20.839   280.573     0.150
    21.070   282.853     0.150
    21.841   291.136     0.150
    40.058   458.628     0.150
     0.541    11.555     0.150
     0.541    19.895     0.150
     0.541    11.535     0.150
     0.578    18.383     0.150
     0.578    10.422     0.150
     0.578    18.395     0.150
     0.816    14.934     0.150
     0.816    26.742     0.150
     0.784    14.125     0.150
     0.784    25.172     0.150
     0.978    18.262     0.150
     0.978    32.133     0.150
     0.983    18.285     0.150
     0.983    30.125     0.150
     0.983    30.984     0.150
     1.001    17.965     0.150
     1.001    32.102     0.150
     1.040    18.734     0.150
     1.040    33.594     0.150
     1.040    18.934     0.150
     1.040    33.473     0.150
     1.064    19.375     0.150
     1.064    33.473     0.150
     1.044    18.113     0.150
     1.044    31.242     0.150
     1.044    18.953     0.150
     1.044    32.824     0.150
     1.129    20.023     0.150
     1.196    31.723     0.150
     1.209    21.902     0.150
     1.209    37.805     0.150
     1.209    21.773     0.150
     1.209    38.172     0.150
     1.209    39.543     0.150
     1.351    23.062     0.150
     1.371    23.395     0.150
     1.371    43.133     0.150
     1.404    23.832     0.150
     1.577    26.652     0.150
     1.729    27.613     0.150
     2.078    32.914     0.150
     2.100    32.004     0.150
     2.100    56.594     0.150
     2.136    34.035     0.150
     2.156    33.023     0.150
     2.156    57.312     0.150
     2.037    63.055     0.150
     2.230    34.582     0.150
     2.267    35.465     0.150
     2.317    37.203     0.150
     2.455    37.973     0.150
     2.496    39.203     0.150
     2.627    40.934     0.150
     2.711    41.695     0.150
     2.730    42.203     0.150
     2.785    43.695     0.150
     2.828    44.434     0.150
     2.919    45.203     0.150
     3.159    48.055     0.150
     3.224    49.992     0.150
     3.596    54.184     0.150
     3.802    56.875     0.150
     3.871    57.652     0.150
     3.894    57.523     0.150
     4.077    61.164     0.150
     4.286    65.164     0.150
     4.297   117.215     0.150
     4.521    70.402     0.150
     4.712    72.023     0.150
     0.368     7.819     0.150
     0.368     7.789     0.150
     0.368    14.109     0.150
     0.462     8.829     0.150
     0.462    15.529     0.150
     0.461     8.819     0.150
     0.461    15.569     0.150
     0.461    16.239     0.150
     0.639    11.919     0.150
     0.639    21.649     0.150
     0.639    21.889     0.150
     0.928    15.399     0.150
     0.928    28.499     0.150
     0.928    29.109     0.150
     0.834    14.559     0.150
     0.834    26.699     0.150
     0.807    26.139     0.150
     0.821    14.599     0.150
     0.821    26.959     0.150
     0.962    16.379     0.150
     0.962    29.159     0.150
     0.944    30.689     0.150
     0.951    31.679     0.150
     0.982    17.189     0.150
     0.982    31.389     0.150
     0.982    31.279     0.150
     1.059    17.459     0.150
     1.059    34.659     0.150
     1.169    37.039     0.150
     1.226    20.089     0.150
     1.311    21.559     0.150
     1.322    21.729     0.150
     1.435    23.469     0.150
     1.435    41.679     0.150
     1.425    25.279     0.150
     1.476    23.939     0.150
     1.671    52.489     0.150
     1.752    55.529     0.150
     1.849    58.089     0.150
     1.939    31.429     0.150
     1.925    30.579     0.150
     1.925    54.689     0.150
     1.930    60.049     0.150
     1.957    31.929     0.150
     1.978    30.869     0.150
     1.978    55.039     0.150
     2.112    34.449     0.150
     2.085    33.129     0.150
     2.085    65.089     0.150
     2.158    33.899     0.150
     2.127    33.319     0.150
     2.127    65.519     0.150
     2.157    67.149     0.150
     2.174    67.749     0.150
     2.260    70.269     0.150
     2.273    36.709     0.150
     2.312    72.079     0.150
     2.319    71.609     0.150
     2.444    38.169     0.150
     2.444    75.159     0.150
     2.568    39.809     0.150
     2.551    40.929     0.150
     2.702    42.459     0.150
     2.660    42.719     0.150
     2.736    45.269     0.150
     2.731    83.899     0.150
     2.903    89.509     0.150
     2.982    47.579     0.150
     3.078    47.239     0.150
     3.266    49.449     0.150
     3.266    85.109     0.150
     3.291    54.059     0.150
     3.291    97.319     0.150
     3.501    54.339     0.150
     3.809    58.359     0.150
     3.736    55.969     0.150
     3.933    61.349     0.150
     4.467    69.049     0.150
     4.691    71.049     0.150
     4.839    73.599     0.150
     4.887    73.619     0.150
     4.873    71.559     0.150
     5.136    77.759     0.150
     5.473    82.339     0.150
     5.488    82.639     0.150
     5.557    83.759     0.150
     5.687    85.539     0.150
     5.775    86.569     0.150
     5.829    87.619     0.150
     5.843    87.349     0.150
     6.083    91.849     0.150
     0.362     7.766     0.150
     0.362    14.046     0.150
     0.363     7.796     0.150
     0.363    14.066     0.150
     0.464     8.876     0.150
     0.464    15.616     0.150
     0.464     8.806     0.150
     0.464    15.576     0.150
     0.464    16.106     0.150
     0.634    11.416     0.150
     0.634    11.796     0.150
     0.802    14.006     0.150
     0.802    25.616     0.150
     0.828    14.076     0.150
     0.828    26.656     0.150
     0.828    14.946     0.150
     0.816    14.306     0.150
     0.816    26.646     0.150
     0.928    15.406     0.150
     0.928    27.256     0.150
     0.928    28.426     0.150
     0.956    16.896     0.150
     0.956    27.686     0.150
     0.986    17.266     0.150
     0.986    31.246     0.150
     0.986    17.406     0.150
     0.986    31.136     0.150
     1.159    19.416     0.150
     1.219    20.016     0.150
     1.219    35.176     0.150
     1.305    21.906     0.150
     1.305    38.426     0.150
     1.212    20.686     0.150
     1.379    22.336     0.150
     1.379    39.236     0.150
     1.429    23.286     0.150
     1.429    41.076     0.150
     1.477    24.476     0.150
     1.477    45.586     0.150
     1.542    24.526     0.150
     1.542    46.526     0.150
     1.933    31.396     0.150
     1.952    31.496     0.150
     1.923    30.616     0.150
     1.923    54.636     0.150
     1.975    31.126     0.150
     1.975    54.726     0.150
     2.106    33.276     0.150
     2.082    32.916     0.150
     2.152    33.976     0.150
     2.321    37.306     0.150
     2.441    37.926     0.150
     2.562    39.646     0.150
     2.546    41.026     0.150
     2.654    41.846     0.150
     2.696    42.636     0.150
     2.977    45.416     0.150
     3.072    47.136     0.150
     3.264    84.736     0.150
     3.264    49.246     0.150
     3.495    53.686     0.150
     3.468    52.206     0.150
     3.730    55.656     0.150
     3.804    57.946     0.150
     4.461    68.766     0.150
     4.686    71.046     0.150
     4.729    69.906     0.150
     4.814    72.556     0.150
     4.836    72.636     0.150
     4.833    73.646     0.150
     4.880    73.586     0.150
     5.312    80.346     0.150
     5.466    82.056     0.150
     5.481    82.576     0.150
     5.550    83.786     0.150
     5.769    86.496     0.150
     5.805    85.616     0.150
     5.836    86.976     0.150
     5.977    90.756     0.150
     6.077    92.076     0.150
     0.236     4.688     0.150
     0.236     8.078     0.150
     0.354     7.688     0.150
     0.354     7.680     0.150
     0.354    13.648     0.150
     0.460     9.719     0.150
     0.460     9.539     0.150
     0.565    10.828     0.150
     0.565    19.199     0.150
     0.565    22.109     0.150
     0.593    11.758     0.150
     0.642    11.797     0.150
     0.642    20.277     0.150
     0.755    14.090     0.150
     0.755    24.320     0.150
     0.725    13.348     0.150
     0.725    23.938     0.150
     0.739    13.527     0.150
     0.739    24.750     0.150
     0.742    14.508     0.150
     0.742    25.027     0.150
     0.743    14.828     0.150
     0.743    25.098     0.150
     0.785    14.887     0.150
     0.785    25.648     0.150
     0.785    26.000     0.150
     0.785    27.207     0.150
     0.945    17.008     0.150
     0.945    17.449     0.150
     0.945    30.387     0.150
     1.047    18.199     0.150
     1.047    31.887     0.150
     1.088    19.629     0.150
     1.088    34.117     0.150
     1.088    33.887     0.150
     1.103    20.090     0.150
     1.146    21.430     0.150
     1.198    21.660     0.150
     1.198    36.879     0.150
     1.268    23.688     0.150
     1.305    23.527     0.150
     1.351    22.500     0.150
     1.351    42.090     0.150
     1.391    25.520     0.150
     1.403    25.438     0.150
     1.437    26.207     0.150
     1.437    25.777     0.150
     1.437    44.418     0.150
     1.414    25.590     0.150
     1.510    24.848     0.150
     1.505    27.297     0.150
     1.539    27.738     0.150
     1.582    28.609     0.150
     1.662    29.648     0.150
     1.662    50.637     0.150
     1.689    29.527     0.150
     1.689    51.668     0.150
     1.712    30.918     0.150
     1.723    30.750     0.150
     1.845    31.430     0.150
     1.942    33.098     0.150
     2.081    35.520     0.150
     2.060    35.520     0.150
     2.085    35.598     0.150
     2.244    37.629     0.150
     2.374    39.500     0.150
     2.423    40.398     0.150
     2.695    43.488     0.150
     2.688    43.758     0.150
     2.848    46.160     0.150
     2.902    46.379     0.150
     3.071    47.910     0.150
     3.109    48.789     0.150
     3.181    49.859     0.150
     3.516    53.770     0.150
     3.538    54.160     0.150
     3.664    56.207     0.150
     3.912    59.730     0.150
     4.053    62.090     0.150
     4.436    67.469     0.150
     4.578    70.508     0.150
     4.785    72.707     0.150
     4.927    72.898     0.150
     4.876    74.770     0.150
     4.890    73.320     0.150
     5.113    75.789     0.150
     5.192    76.500     0.150
     0.238     4.801     0.150
     0.238     8.352     0.150
     0.238     4.793     0.150
     0.238     8.371     0.150
     0.330     7.852     0.150
     0.599    11.480     0.150
     0.726    13.383     0.150
     0.726    24.359     0.150
     0.759    25.902     0.150
     0.771    14.172     0.150
     0.771    24.500     0.150
     0.824    14.973     0.150
     0.824    26.062     0.150
     0.824    27.180     0.150
     0.824    15.383     0.150
     0.824    26.602     0.150
     0.967    30.562     0.150
     1.030    17.680     0.150
     1.123    33.859     0.150
     1.123    19.602     0.150
     1.123    34.242     0.150
     1.126    20.340     0.150
     1.225    21.641     0.150
     1.225    21.812     0.150
     1.225    37.133     0.150
     1.349    22.621     0.150
     1.334    23.660     0.150
     1.334    40.043     0.150
     1.430    25.652     0.150
     1.430    43.832     0.150
     1.485    24.609     0.150
     1.475    25.871     0.150
     1.475    45.043     0.150
     1.683    30.070     0.150
     1.875    30.332     0.150
     1.929    34.801     0.150
     1.929    58.641     0.150
     1.963    34.371     0.150
     1.963    58.699     0.150
     1.968    33.672     0.150
     2.042    36.711     0.150
     2.251    39.109     0.150
     2.267    38.742     0.150
     2.357    42.359     0.150
     2.404    41.031     0.150
     0.387     8.355     0.150
     0.387    13.297     0.150
     0.387     8.484     0.150
     0.472     9.125     0.150
     0.472    16.047     0.150
     0.473     9.176     0.150
     0.473    13.773     0.150
     0.658    12.477     0.150
     0.658    22.586     0.150
     0.658    22.316     0.150
     0.826    15.164     0.150
     0.826    26.816     0.150
     0.840    14.715     0.150
     0.840    14.914     0.150
     0.840    27.605     0.150
     0.849    15.195     0.150
     0.849    28.254     0.150
     0.849    15.574     0.150
     0.849    27.816     0.150
     0.892    15.934     0.150
     0.892    28.727     0.150
     0.971    17.574     0.150
     0.971    32.047     0.150
     0.972    16.934     0.150
     0.972    30.016     0.150
     0.912    15.574     0.150
     0.912    28.996     0.150
     0.912    29.555     0.150
     1.036    20.035     0.150
     1.036    33.375     0.150
     0.987    17.484     0.150
     0.987    31.914     0.150
     0.987    31.184     0.150
     0.987    32.465     0.150
     1.078    17.926     0.150
     1.099    19.305     0.150
     1.099    33.273     0.150
     1.182    20.254     0.150
     1.241    20.547     0.150
     1.280    23.266     0.150
     1.230    20.984     0.150
     1.230    41.895     0.150
     1.314    22.145     0.150
     1.314    39.766     0.150
     1.339    22.367     0.150
     1.401    23.035     0.150
     1.445    26.125     0.150
     1.450    24.184     0.150
     1.450    42.117     0.150
     1.566    24.855     0.150
     1.954    31.715     0.150
     1.954    56.594     0.150
     1.944    31.164     0.150
     1.977    31.984     0.150
     1.997    31.523     0.150
     1.997    55.715     0.150
     2.105    33.305     0.150
     2.105    58.574     0.150
     2.124    34.125     0.150
     2.124    58.645     0.150
     2.175    34.387     0.150
     2.175    59.996     0.150
     2.293    35.234     0.150
     2.345    36.445     0.150
     2.464    38.484     0.150
     2.570    40.375     0.150
     2.584    39.984     0.150
     2.678    42.105     0.150
     2.696    42.195     0.150
     2.706    42.207     0.150
     2.756    41.984     0.150
     3.001    46.004     0.150
     3.009    48.625     0.150
     3.094    47.555     0.150
     3.140    48.066     0.150
     3.246    49.184     0.150
     3.253    49.395     0.150
     3.345    50.996     0.150
     3.492    53.184     0.150
     3.511    54.125     0.150
     3.592    54.266     0.150
     3.709    56.195     0.150
     3.753    56.516     0.150
     3.808    57.957     0.150
     3.994    60.887     0.150
     4.125    62.875     0.150
     4.137    62.004     0.150
     4.813    71.547     0.150
     4.901    73.715     0.150
     5.565    83.867     0.150
     5.838    87.434     0.150
     7.466   112.762     0.150
     7.466   138.820     0.150
     7.466   238.480     0.150
     7.796   113.164     0.150
     9.643   139.445     0.150
     9.643   300.059     0.150
    11.807   171.746     0.150
    11.807   376.453     0.150
     0.379     8.352     0.150
     0.379    14.875     0.150
     0.475     9.113     0.150
     0.475    16.184     0.150
     0.474     9.102     0.150
     0.474    16.102     0.150
     0.651    12.555     0.150
     0.651    22.574     0.150
     0.819    14.754     0.150
     0.841    15.332     0.150
     0.841    27.773     0.150
     0.834    14.734     0.150
     0.834    27.883     0.150
     0.884    15.824     0.150
     0.884    28.691     0.150
     0.964    29.352     0.150
     0.964    16.953     0.150
     0.964    29.883     0.150
     0.956    17.184     0.150
     0.956    17.324     0.150
     0.956    31.324     0.150
     0.913    15.582     0.150
     0.913    27.465     0.150
     0.913    28.715     0.150
     0.913    29.293     0.150
     0.964    18.152     0.150
     0.964    31.203     0.150
     0.992    17.594     0.150
     0.992    31.684     0.150
     0.992    17.453     0.150
     0.992    30.895     0.150
     1.075    17.934     0.150
     1.075    34.191     0.150
     1.174    19.941     0.150
     1.174    19.812     0.150
     1.174    35.902     0.150
     1.100    19.203     0.150
     1.100    33.414     0.150
     1.100    32.973     0.150
     1.100    35.523     0.150
     1.233    20.562     0.150
     1.233    35.781     0.150
     1.307    22.023     0.150
     1.307    37.492     0.150
     1.229    20.973     0.150
     1.229    36.414     0.150
     1.442    23.973     0.150
     1.442    41.664     0.150
     1.561    24.902     0.150
     1.561    44.184     0.150
     1.946    31.684     0.150
     1.946    54.832     0.150
     1.970    31.852     0.150
     1.941    31.375     0.150
     1.941    55.223     0.150
     1.994    31.555     0.150
     1.994    55.703     0.150
     2.116    33.332     0.150
     2.116    58.742     0.150
     2.101    33.484     0.150
     2.101    58.773     0.150
     2.167    34.602     0.150
     2.287    36.715     0.150
     2.287    62.672     0.150
     2.337    36.742     0.150
     2.459    38.215     0.150
     2.459    68.102     0.150
     2.575    40.215     0.150
     2.564    40.375     0.150
     2.671    42.125     0.150
     2.687    42.281     0.150
     2.699    42.184     0.150
     2.750    42.984     0.150
     2.994    46.191     0.150
     3.132    47.984     0.150
     3.240    48.973     0.150
     3.252    49.824     0.150
     3.337    50.555     0.150
     3.503    53.934     0.150
     3.588    54.145     0.150
     3.703    56.023     0.150
     3.745    56.281     0.150
     3.802    57.984     0.150
     4.129    61.773     0.150
     4.119    61.852     0.150
     4.350    65.055     0.150
     4.465    68.434     0.150
     4.487    67.512     0.150
     4.687    70.715     0.150
     4.744    69.895     0.150
     4.809    71.703     0.150
     5.134    78.062     0.150
     5.308    79.754     0.150
     5.792    85.324     0.150
     0.497     9.941     0.150
     0.497    16.629     0.150
     0.497    17.340     0.150
     0.829    15.660     0.150
     0.829    27.398     0.150
     0.846    15.559     0.150
     0.846    27.770     0.150
     0.842    16.301     0.150
     0.842    28.762     0.150
     0.891    16.852     0.150
     0.891    29.430     0.150
     0.891    16.719     0.150
     0.891    29.570     0.150
     0.965    31.691     0.150
     0.965    31.961     0.150
     0.975    18.320     0.150
     0.890    16.309     0.150
     0.890    27.961     0.150
     0.958    17.820     0.150
     0.958    28.500     0.150
     1.012    18.320     0.150
     1.012    32.551     0.150
     1.095    18.820     0.150
     1.094    20.512     0.150
     1.094    35.109     0.150
     1.094    37.422     0.150
     1.122    20.082     0.150
     1.122    34.102     0.150
     1.122    36.512     0.150
     1.122    36.961     0.150
     1.179    20.980     0.150
     1.179    21.020     0.150
     1.179    37.160     0.150
     1.234    21.410     0.150
     1.250    21.840     0.150
     1.250    37.391     0.150
     1.337    23.039     0.150
     1.293    22.719     0.150
     1.293    38.469     0.150
     1.397    23.672     0.150
     1.443    24.621     0.150
     1.443    42.781     0.150
     1.576    25.520     0.150
     1.576    44.988     0.150
     1.702    27.469     0.150
     1.744    29.180     0.150
     1.765    28.879     0.150
     1.960    32.000     0.150
     1.960    56.551     0.150
     1.963    31.680     0.150
     1.946    32.238     0.150
     1.982    33.641     0.150
     2.013    32.430     0.150
     2.013    56.180     0.150
     2.090    33.922     0.150
     2.118    33.961     0.150
     2.113    34.648     0.150
     2.161    34.691     0.150
     2.191    35.180     0.150
     2.173    35.012     0.150
     2.205    35.340     0.150
     2.289    36.691     0.150
     2.300    36.129     0.150
     2.345    37.262     0.150
     2.346    37.238     0.150
     2.396    37.961     0.150
     2.445    38.922     0.150
     2.476    38.852     0.150
     2.492    39.262     0.150
     2.575    40.039     0.150
     2.575    50.254     0.150
     2.575    87.953     0.150
     2.643    41.680     0.150
     2.678    43.000     0.150
     2.682    42.840     0.150
     2.687    42.941     0.150
     2.765    42.551     0.150
     2.803    43.230     0.150
     2.934    45.430     0.150
     3.005    47.199     0.150
     3.088    47.559     0.150
     3.229    49.500     0.150
     3.344    51.148     0.150
     3.750    56.859     0.150
     4.137    62.719     0.150
     4.428    66.879     0.150
     4.465    67.180     0.150
     4.789    72.051     0.150
     4.892    74.359     0.150
     5.779    87.102     0.150
     5.841    88.059     0.150
     6.591    97.582     0.150
     7.464   112.109     0.150
     7.464   142.234     0.150
     7.464   243.934     0.150
     7.501   109.754     0.150
     7.501   234.035     0.150
     8.124   119.961     0.150
     9.624   140.059     0.150
     9.624   301.086     0.150
     9.624   139.648     0.150
    11.789   171.309     0.150
    11.789   378.219     0.150
    23.207   308.574     0.150
    30.876   377.684     0.150
    38.717   446.234     0.150
    81.147   735.980     0.150
     0.415     9.488     0.150
     0.415    15.488     0.150
     0.415     9.508     0.150
     0.415    15.918     0.150
     0.415    16.438     0.150
     0.533    10.215     0.150
     0.533    17.016     0.150
     0.534    10.207     0.150
     0.534    17.277     0.150
     0.690    13.617     0.150
     0.690    23.828     0.150
     0.690    23.727     0.150
     0.857    15.996     0.150
     0.857    28.555     0.150
     0.857    15.707     0.150
     0.857    28.098     0.150
     0.877    15.836     0.150
     0.877    28.938     0.150
     0.856    16.777     0.150
     0.856    29.188     0.150
     0.850    28.395     0.150
     0.914    16.977     0.150
     0.914    29.266     0.150
     1.042    18.516     0.150
     1.042    32.777     0.150
     0.991    32.266     0.150
     0.959    18.117     0.150
     0.959    28.828     0.150
     1.160    20.336     0.150
     1.160    36.445     0.150
     1.160    36.176     0.150
     1.160    36.918     0.150
     1.134    19.055     0.150
     1.134    36.227     0.150
     1.117    20.977     0.150
     1.117    35.797     0.150
     1.198    20.816     0.150
     1.291    22.117     0.150
     1.247    21.707     0.150
     1.279    23.035     0.150
     1.279    40.035     0.150
     1.358    23.227     0.150
     1.456    25.016     0.150
     1.456    42.656     0.150
     1.609    26.168     0.150
     1.999    31.758     0.150
     1.999    56.305     0.150
     1.958    31.848     0.150
     2.011    32.086     0.150
     2.051    32.668     0.150
     2.051    56.137     0.150
     2.155    33.965     0.150
     2.119    34.176     0.150
     2.192    34.965     0.150
     2.332    36.645     0.150
     2.370    37.375     0.150
     2.512    39.027     0.150
     2.605    40.465     0.150
     2.590    40.426     0.150
     2.701    42.016     0.150
     2.683    41.766     0.150
     2.675    42.055     0.150
     2.799    42.688     0.150
     3.033    46.238     0.150
     3.102    47.246     0.150
     3.136    47.977     0.150
     3.192    49.406     0.150
     3.192    85.578     0.150
     3.496    53.617     0.150
     3.538    53.715     0.150
     3.748    55.266     0.150
     3.762    57.445     0.150
     3.956    59.215     0.150
     4.319    65.156     0.150
     4.425    66.145     0.150
     4.444    66.676     0.150
     4.772    69.836     0.150
     5.732    83.285     0.150
     5.820    85.207     0.150
     0.354     7.207     0.150
     0.794    25.527     0.150
     0.810    15.027     0.150
     0.810    15.309     0.150
     0.810    27.887     0.150
     0.924    15.910     0.150
     0.924    28.707     0.150
     0.924    28.848     0.150
     0.924    29.688     0.150
     0.943    17.359     0.150
     0.943    29.898     0.150
     0.997    17.727     0.150
     0.997    32.078     0.150
     0.997    31.469     0.150
     1.095    19.527     0.150
     1.095    33.316     0.150
     1.095    35.707     0.150
     1.095    36.148     0.150
     1.095    36.809     0.150
     1.149    20.578     0.150
     1.149    36.000     0.150
     1.216    21.297     0.150
     1.216    36.930     0.150
     1.216    37.438     0.150
     1.208    36.180     0.150
     1.216    36.777     0.150
     1.306    22.527     0.150
     1.306    39.789     0.150
     1.292    22.348     0.150
     1.292    40.629     0.150
     1.369    23.270     0.150
     1.416    24.598     0.150
     1.417    24.207     0.150
     1.417    41.859     0.150
     1.538    25.000     0.150
     1.923    31.617     0.150
     1.923    55.559     0.150
     1.922    31.910     0.150
     2.080    33.539     0.150
     2.093    33.707     0.150
     2.142    34.699     0.150
     2.551    40.398     0.150
     2.683    42.680     0.150
     3.482    53.520     0.150
     0.376     8.117     0.150
     0.376    14.586     0.150
     0.376     8.176     0.150
     0.376    14.766     0.150
     0.489     9.125     0.150
     0.489    16.004     0.150
     0.488     9.098     0.150
     0.488    16.137     0.150
     0.649    22.484     0.150
     0.817    26.586     0.150
     0.833    27.555     0.150
     0.833    14.895     0.150
     0.902    15.656     0.150
     0.902    26.617     0.150
     0.902    27.445     0.150
     0.902    29.066     0.150
     0.952    16.766     0.150
     0.952    29.957     0.150
     1.007    18.188     0.150
     1.007    32.145     0.150
     1.007    18.055     0.150
     1.007    31.547     0.150
     1.113    19.254     0.150
     1.113    32.734     0.150
     1.113    34.625     0.150
     1.113    36.727     0.150
     1.168    20.188     0.150
     1.238    19.125     0.150
     1.238    36.246     0.150
     1.238    36.535     0.150
     1.224    20.457     0.150
     1.238    21.035     0.150
     1.292    21.688     0.150
     1.292    39.047     0.150
     1.326    21.797     0.150
     1.386    22.875     0.150
     1.433    23.656     0.150
     1.433    41.816     0.150
     1.433    42.637     0.150
     1.483    24.645     0.150
     1.483    43.617     0.150
     1.562    24.496     0.150
     1.688    26.676     0.150
     1.688    46.984     0.150
     1.947    31.285     0.150
     1.947    62.336     0.150
     1.937    31.688     0.150
     1.999    31.688     0.150
     1.999    55.754     0.150
     2.105    33.176     0.150
     2.105    58.164     0.150
     2.106    33.914     0.150
     2.106    56.375     0.150
     2.161    34.137     0.150
     2.287    36.266     0.150
     2.463    38.098     0.150
     2.562    39.207     0.150
     2.567    40.117     0.150
     2.676    42.137     0.150
     2.685    41.016     0.150
     2.752    42.645     0.150
     3.239    49.324     0.150
     3.239    87.887     0.150
     3.491    54.207     0.150
     3.573    55.016     0.150
     3.739    56.074     0.150
     3.787    58.254     0.150
     4.451    68.266     0.150
     4.692    72.207     0.150
     4.813    73.535     0.150
     5.121    78.457     0.150
     5.462    82.395     0.150
     5.544    82.906     0.150
     5.780    85.254     0.150
     5.834    88.387     0.150
     6.069    92.047     0.150
     0.722    24.973     0.150
     0.722    24.793     0.150
     0.762    15.074     0.150
     0.762    25.992     0.150
     0.762    24.902     0.150
     0.696    13.344     0.150
     0.696    22.781     0.150
     0.696    24.691     0.150
     1.197    39.121     0.150
     1.197    22.371     0.150
     1.197    38.543     0.150
     1.071    19.773     0.150
     1.071    34.441     0.150
     1.071    34.012     0.150
     1.071    35.312     0.150
     1.203    21.852     0.150
     1.264    22.164     0.150
     1.264    40.352     0.150
     1.387    24.672     0.150
     1.387    45.492     0.150
     1.308    23.492     0.150
     1.308    41.223     0.150
     1.308    23.262     0.150
     1.308    40.512     0.150
     1.308    42.332     0.150
     1.503    26.184     0.150
     1.415    23.992     0.150
     1.415    44.242     0.150
     1.415    25.641     0.150
     1.415    44.391     0.150
     1.585    26.723     0.150
     1.490    25.711     0.150
     1.490    44.664     0.150
     1.519    26.852     0.150
     1.519    49.980     0.150
     1.706    29.973     0.150
     1.793    30.133     0.150
     1.938    34.953     0.150
     2.293    39.113     0.150
     2.276    37.113     0.150
     2.276    65.684     0.150
     2.354    41.141     0.150
     2.434    40.914     0.150
     2.337    39.773     0.150
     2.337    70.344     0.150
     2.460    39.582     0.150
     2.669    45.812     0.150
     2.718    45.371     0.150
     2.896    46.652     0.150
     2.927    45.914     0.150
     2.948    49.781     0.150
     3.117    49.164     0.150
     3.050    49.512     0.150
     3.126    50.812     0.150
     3.379    55.102     0.150
     3.452    54.754     0.150
     3.669    59.371     0.150
     3.782    60.262     0.150
     3.894    60.871     0.150
     4.258    66.402     0.150
     4.562    70.863     0.150
     4.508    68.871     0.150
     4.502    71.801     0.150
     4.673    72.012     0.150
     4.769    72.980     0.150
     4.833    73.004     0.150
     4.831    73.551     0.150
     4.933    76.711     0.150
     4.952    77.461     0.150
     5.226    81.754     0.150
     5.253    82.434     0.150
     5.358    81.652     0.150
     5.351    82.293     0.150
     5.634    84.191     0.150
     5.573    88.941     0.150
     5.740    86.113     0.150
     5.806    85.172     0.150
     5.923    90.633     0.150
     6.094    92.883     0.150
     6.108    92.551     0.150
     6.136    90.812     0.150
     6.317    95.531     0.150
     6.529    97.621     0.150
     6.682    98.551     0.150
     6.920   102.551     0.150
     7.097   106.914     0.150
     7.205   107.293     0.150
     7.282   107.391     0.150
     7.423   110.863     0.150
     7.474   111.082     0.150
     7.565   111.344     0.150
     7.588   111.480     0.150
     7.973   117.293     0.150
     0.953    18.223     0.150
     0.953    32.533     0.150
     0.725    13.764     0.150
     0.725    22.934     0.150
     0.725    24.184     0.150
     1.050    18.074     0.150
     1.050    32.213     0.150
     1.167    20.934     0.150
     1.167    36.543     0.150
     1.514    27.754     0.150
     1.514    48.033     0.150
     1.300    22.504     0.150
     1.300    39.623     0.150
     1.598    52.014     0.150
     1.538    26.244     0.150
     1.564    28.543     0.150
     1.564    48.484     0.150
     1.845    32.164     0.150
     1.845    57.273     0.150
     1.827    30.123     0.150
     2.029    32.693     0.150
     2.356    38.184     0.150
     2.414    39.383     0.150
     2.647    42.244     0.150
     2.879    46.053     0.150
     2.865    46.543     0.150
     2.857    47.713     0.150
     2.999    49.904     0.150
     3.275    49.664     0.150
     3.157    52.064     0.150
     3.261    50.113     0.150
     3.260    52.744     0.150
     3.403    53.213     0.150
     3.453    56.404     0.150
     3.453   124.773     0.150
     3.922    59.924     0.150
     4.221    64.123     0.150
     4.304    65.893     0.150
     4.333    66.953     0.150
     4.669    70.773     0.150
     4.997    76.074     0.150
     5.284    80.553     0.150
     5.707    85.754     0.150
     6.406    94.664     0.150
     6.634    99.283     0.150
     6.672    99.213     0.150
     6.854   102.273     0.150
     7.566   111.514     0.150
     7.699   112.973     0.150
     7.699   143.648     0.150
     7.699   239.998     0.150
     7.699   115.713     0.150
     7.640   112.904     0.150
     7.694   113.113     0.150
     7.885   116.643     0.150
     7.759   116.434     0.150
     7.785   116.543     0.150
     8.313   123.023     0.150
     8.381   280.928     0.150
     8.677   128.564     0.150
     8.762   129.873     0.150
     8.845   129.973     0.150
     9.195   132.354     0.150
     9.195   233.129     0.150
     9.195   278.979     0.150
     9.195   134.014     0.150
     9.129   131.963     0.150
     9.193   134.893     0.150
    10.003   322.904     0.150
    10.431   150.584     0.150
    11.195   161.904     0.150
    12.533   183.254     0.150
    12.533   400.404     0.150
    14.978   212.863     0.150
    14.989   215.334     0.150
    15.550   221.824     0.150
    15.561   220.914     0.150
    15.681   222.514     0.150
    15.835   222.113     0.150
    17.629   253.223     0.150
    23.801   316.053     0.150
     7.697   115.244     0.150
    42.626   478.543     0.150
     0.612    12.032     0.150
     0.612    20.792     0.150
     0.612    21.952     0.150
     0.589    11.322     0.150
     0.589    21.643     0.150
     0.589    12.223     0.150
     0.589    21.992     0.150
     0.620    11.332     0.150
     0.620    20.112     0.150
     0.620    21.572     0.150
     0.864    15.133     0.150
     1.018    19.223     0.150
     1.018    34.982     0.150
     1.018    18.622     0.150
     1.018    32.062     0.150
     1.032    32.242     0.150
     1.039    17.572     0.150
     1.039    34.003     0.150
     1.092    19.753     0.150
     1.092    34.582     0.150
     1.072    19.603     0.150
     1.072    33.633     0.150
     1.072    34.263     0.150
     1.072    18.713     0.150
     1.072    33.173     0.150
     1.086    34.763     0.150
     1.246    36.103     0.150
     1.250    22.702     0.150
     1.250    39.562     0.150
     1.250    40.332     0.150
     1.250    40.633     0.150
     1.250    38.792     0.150
     1.372    23.893     0.150
     1.286    41.122     0.150
     1.361    23.812     0.150
     1.366    24.022     0.150
     1.406    24.202     0.150
     1.420    27.643     0.150
     1.420    25.093     0.150
     1.614    27.343     0.150
     1.781    28.032     0.150
     2.114    35.152     0.150
     2.151    34.582     0.150
     2.151    61.272     0.150
     2.207    38.562     0.150
     2.207    61.782     0.150
     2.261    36.553     0.150
     2.360    37.242     0.150
     2.758    44.022     0.150
     2.810    44.532     0.150
     2.873    45.522     0.150
     3.121    48.143     0.150
     3.121    83.553     0.150
     3.619    56.383     0.150
     3.796    58.692     0.150
     4.314    65.362     0.150
     0.619    10.979     0.150
     0.619    19.268     0.150
     0.617    12.068     0.150
     0.617    20.738     0.150
     0.617    22.318     0.150
     0.578    21.898     0.150
     1.075    19.098     0.150
     1.075    33.328     0.150
     1.075    34.389     0.150
     1.005    19.018     0.150
     1.005    34.488     0.150
     1.040    19.268     0.150
     1.040    33.998     0.150
     1.079    19.139     0.150
     1.079    34.049     0.150
     1.250    22.508     0.150
     1.250    39.119     0.150
     1.250    41.188     0.150
     1.416    26.869     0.150
     1.349    23.438     0.150
     1.349    39.688     0.150
     1.602    26.549     0.150
     2.174    35.889     0.150
     2.348    37.598     0.150
     2.798    43.389     0.150
     2.862    45.088     0.150
     3.527    55.008     0.150
     3.606    54.119     0.150
     3.787    58.408     0.150
     4.319    64.947     0.150
     4.372    66.697     0.150
     4.521    69.947     0.150
     4.703    70.418     0.150
     4.757    72.328     0.150
     4.929    73.447     0.150
     4.929    75.338     0.150
     5.920    89.107     0.150
     5.958    90.098     0.150
EOF
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jBL  << EOF
    60.000   140.000 P phases in red
EOF
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL  << EOF
    60.000   100.000 S phases in green
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL  << EOF
    60.000    60.000 Readings used for cluster vectors in black
EOF
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    60.000    20.000 Readings not used for cluster vectors in cyan
EOF
gmt end
