#!/bin/bash
gmt begin penasco2.16_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-33/33/-33/33
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation penasco2.16'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     9.662     9.662
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.039     4.929
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.316    -5.732
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.751   -11.116
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -14.751   -11.116 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.782   -12.331
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -15.782   -12.331 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -25.791     5.954
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -25.791     5.954 5
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.663     6.430
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.663     6.430 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.169   -22.302
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.169   -22.302 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.271    -7.769
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.357    -0.458
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.929     3.021
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.615    -2.618
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.432    -3.227
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.684     6.506
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.172    15.456
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.172    15.456 14
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.340    -1.410
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.733     4.902
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.372    -2.693
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.314     8.983
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.556    10.733
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.556    10.733 19
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.246     3.362
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.154    -2.948
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.138     0.695
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.464     2.611
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.751     2.526
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.716     8.597
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.716     8.597 25
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.141     5.045
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.584     0.741
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.529     1.646
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.277     9.087
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.654    -2.195
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.826     0.701
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.660    -4.857
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.673   -11.901
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.673   -11.901 33
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.970    -2.286
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.427     3.039
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.262    -4.415
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.647     0.571
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.850     4.737
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.106     6.089
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.868    11.904
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.868    11.904 40
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.560     1.455
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.124     5.411
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.111    -7.018
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.259     4.391
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.204    -3.285
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.681    -6.275
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.505    20.019
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.505    20.019 47
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.624     8.176
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.624     8.176 48
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000    -3.435
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.318    -3.029
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.876     7.132
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.646    -6.315
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.645     0.599
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.373     0.761
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.052    -2.997
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.533    -7.885
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.062     5.885
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.062     5.885 57
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.596     0.728
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.839    -3.771
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.107     2.173
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.347     2.829
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.734     3.132
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.734     3.132 62
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.497    -2.592
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.666    -2.961
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.615     2.798
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.213    -2.240
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.167     0.857
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.007    -0.282
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.304    -0.289
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.293     1.901
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.469    -3.720
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.734     0.358
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.133    -4.012
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.738    -6.486
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.108     5.492
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.607     5.591
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.102     1.317
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.174     2.759
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.138    -6.138
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.379    -5.420
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.243     3.474
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.799     1.060
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.683     1.341
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.758     5.107
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000    -3.269
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.426     2.185
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.921    -1.240
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.260    -2.787
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.460     0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.117    -0.029
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.342     7.521
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.767     4.853
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.034     4.480
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.444     1.755
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.509    -1.222
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.891     3.557
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.579     4.750
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.809    -3.012
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.282     2.684
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.143    -6.482
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.983     4.453
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.123     2.453
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.589    -1.306
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.536    -0.271
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.949     6.325
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.076     2.388
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.591    11.274
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.591    11.274 107
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.969     5.494
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.602    10.460
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.602    10.460 109
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.859     2.496
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.308     1.499
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.448     6.412
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.273     3.161
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.042     2.429
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.130     2.932
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.460   -13.177
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.460   -13.177 116
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.158    -0.565
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.451     2.321
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.545     0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.483     1.290
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.586     0.338
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.680     4.296
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     2.329
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.295    -1.518
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.476     1.640
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.485     1.132
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.771    -8.332
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.402     4.274
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.925     4.351
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.798     2.568
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.950    13.877
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.950    13.877 131
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.474     0.130
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.244     1.257
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.139     2.461
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.716     0.764
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.868     2.582
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.077     2.236
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.044     4.472
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.044     4.472 138
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.917     0.948
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.449     3.653
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.405    11.313
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.405    11.313 141
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.334    12.762
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    16.334    12.762 142
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.884     5.154
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.821    -3.864
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.172    -2.498
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.151    -8.026
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.465    -3.505
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.465    -3.505 147
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.102    -5.865
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.889    -1.689
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.390     1.016
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.908     4.092
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.568     5.405
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.362     1.674
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.917     5.804
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.357     0.494
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.476    -1.501
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.430     8.214
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.293     8.164
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.708    -0.469
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.575     6.569
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.999     4.765
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.418     2.025
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.868     0.542
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.644     0.859
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.872    -0.514
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.424     0.979
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.860    -0.338
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.114     0.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.450     3.205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.026    -1.537
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.205     5.857
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.875     4.114
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.279     0.652
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.740     4.670
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.793     4.439
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.477   -30.997
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.477   -30.997 176
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.590   -17.388
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.590   -17.388 177
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.230     4.385
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.044     2.547
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.296    -1.126
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.195     8.500
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.942     3.515
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.047    14.567
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.047    14.567 183
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.484     5.040
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -16.484     5.040 184
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.591     4.789
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.913     0.306
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.150     1.291
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.162     1.149
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.727     2.152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.321    -2.968
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.399    -0.639
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.136     3.961
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.775    11.130
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.775    11.130 193
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.462    10.512
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.462    10.512 194
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.510     0.431
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.602    -0.770
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.088    -0.054
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.138    -3.118
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.612     4.946
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.034    -1.682
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.154     8.831
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.877    -1.808
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.057    -2.576
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.976     0.104
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.321    -2.289
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.273     5.204
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.753     6.184
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.126     4.005
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.176     2.961
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.877    -5.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.513    -4.626
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.626     6.068
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.121     3.030
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.484     2.912
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.157     3.611
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.710    -5.049
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.934     0.606
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.159     5.257
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.506    -5.656
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.834     8.373
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.834     8.373 220
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.046    -6.123
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.046    -6.123 221
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.714    -0.446
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.093     3.483
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.771     0.000
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.771     0.000 224
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.507     3.782
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.294    -4.205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.110    -0.144
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.161     7.207
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.429    -2.854
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.429    -2.854 229
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.121     4.945
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.987    -6.864
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.032    -0.927
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.475     6.127
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.908     7.396
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.254     1.559
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.576    -5.919
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.991    -0.609
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.453    -1.718
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.040     7.565
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.040     7.565 239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.092   -19.905
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.092   -19.905 240
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.531    -0.802
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.812    -7.847
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -0.799     1.080     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -31.000    31.000 Author: all ( 242 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -31.000   -31.000 Average =   1.3 km at 323.5 deg; median =    4.8 km
EOF
gmt end
