#!/bin/bash
gmt begin penasco2.16_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-23/19/0/42
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya25f5+lCounts -BWeSn+t'Focal Depth Mislocation penasco2.16' << EOF
    13.000
     1.000
     5.000
     3.000
     3.000
     2.000
     8.000
     2.100
    -1.700
    -2.000
    -0.000
     4.500
     4.000
    -2.800
    -2.400
    -7.200
    -1.900
    -1.500
    -7.200
    -6.600
    -2.600
     3.500
   -15.800
    -1.200
   -18.000
    -8.900
   -11.200
    -3.600
    -0.400
     4.300
    -8.000
    -7.600
    -3.100
    11.600
    -0.500
    -0.000
   -13.800
    -0.000
    -0.000
   -17.500
    -3.000
   -11.800
    -1.300
    -3.900
     4.000
    -2.200
    -8.400
   -11.200
    -0.000
     0.100
    -2.100
    -4.000
    -2.200
     2.100
    -6.400
    -4.500
   -15.900
    -0.000
     2.000
    -5.600
    -2.700
    -8.000
     3.900
     1.400
    -1.600
     3.000
    -4.500
     5.200
    -0.200
     3.000
     0.400
   -11.000
     4.000
    -3.000
    -5.800
    -2.400
   -10.200
     5.600
   -12.700
    -3.000
    -4.700
    -0.300
    -4.800
    11.900
     1.900
     3.300
    10.000
   -14.900
     9.300
    -0.500
    -9.000
    -2.200
    -8.300
    -5.100
   -10.500
     1.700
     8.600
    -3.800
     1.800
    -0.200
    -0.500
     0.300
    -7.900
    -5.800
     2.800
   -10.800
    -4.600
    -0.300
     4.300
    -1.700
     3.200
    -6.300
    -2.100
    -1.200
    -5.700
    14.200
    10.400
   -13.700
    -0.000
    -6.600
    -3.000
    -5.700
    -2.000
    10.000
     1.800
     7.200
     0.200
    -5.900
    -9.800
   -12.400
     4.300
    -2.800
    -5.900
   -18.000
    -2.200
     3.200
    -8.700
     3.000
    -1.500
    -3.900
     5.600
    -3.000
    -3.900
     5.000
    13.900
   -13.000
    -0.400
     0.300
     1.900
    -1.000
   -12.400
    -7.400
    -6.700
     0.100
    -5.500
    -8.000
    -3.800
    -5.000
     0.200
     7.000
    -7.400
     2.000
     1.900
    -5.600
   -16.300
     4.400
     2.600
    -3.300
     4.900
     2.600
     1.500
    -6.800
    -2.100
     9.600
    -6.300
    -4.000
    -6.000
    -0.200
    -5.100
    -9.400
    -5.700
     0.900
    -5.000
    -8.900
    -2.400
    -7.000
   -12.900
     4.600
    -2.100
    -2.300
     0.400
    -2.200
    -4.400
    -1.700
     4.100
     2.200
     3.600
     0.400
     1.400
    -6.400
    -5.000
     0.500
     0.300
    -5.600
     1.000
     5.000
     2.000
    -0.000
    -0.000
     4.000
     4.400
     3.000
    -3.000
    -0.000
    -5.000
    -0.000
    -0.000
    -0.000
    -0.900
     1.000
     5.100
    -0.200
     6.900
     0.300
    -0.000
     3.000
    -5.000
    -9.000
    -9.000
   -11.000
     2.000
     2.100
    -9.000
   -10.000
    -2.000
    -6.000
    -3.000
    -9.000
     6.000
     4.000
    -0.000
     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -1.550    37.205 Median =  -1.6 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -1.6  0.
 -1.6  36.5
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -22.000    39.795 Author: all ( 242 samples)
EOF
gmt end
