#!/bin/bash
gmt begin penasco2.16_dcal pdf,ps
proj=-JM16.0c+
reg=-R-117.2/-111.3/27.8/33.6
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration penasco2.16'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -115.051    31.472
  -114.407    31.491
>
  -115.051    31.472
  -114.407    31.491
>
  -115.051    31.472
  -114.336    31.522
>
  -115.051    31.472
  -114.336    31.522
>
  -115.242    31.988
  -114.336    31.522
>
  -115.242    31.988
  -114.336    31.522
>
  -115.242    31.988
  -114.336    31.522
>
  -115.051    31.472
  -114.300    31.441
>
  -115.051    31.472
  -114.300    31.441
>
  -115.051    31.472
  -114.286    31.443
>
  -115.051    31.472
  -114.286    31.443
>
  -115.051    31.472
  -114.285    31.467
>
  -115.051    31.472
  -114.443    31.621
>
  -115.051    31.472
  -114.443    31.621
>
  -115.051    31.472
  -114.402    31.603
>
  -115.051    31.472
  -114.402    31.603
>
  -115.051    31.472
  -114.402    31.603
>
  -115.466    31.046
  -114.741    31.599
>
  -115.466    31.046
  -114.741    31.599
>
  -115.464    31.045
  -114.741    31.599
>
  -115.198    32.407
  -114.741    31.599
>
  -115.198    32.407
  -114.741    31.599
>
  -115.304    32.418
  -114.741    31.599
>
  -115.051    31.472
  -114.501    31.674
>
  -115.051    31.472
  -114.501    31.674
>
  -114.545    32.555
  -114.501    31.674
>
  -115.076    32.303
  -114.533    31.719
>
  -115.076    32.303
  -114.533    31.719
>
  -114.545    32.555
  -114.533    31.719
>
  -113.460    31.560
  -114.533    31.719
>
  -113.460    31.560
  -114.533    31.719
>
  -115.304    32.418
  -114.533    31.719
>
  -115.304    32.418
  -114.533    31.719
>
  -115.051    31.472
  -114.340    31.500
>
  -115.051    31.472
  -114.340    31.500
>
  -113.633    31.335
  -114.340    31.500
>
  -113.633    31.335
  -114.340    31.500
>
  -113.460    31.560
  -114.340    31.500
>
  -113.460    31.560
  -114.340    31.500
>
  -113.460    31.560
  -114.340    31.500
>
  -115.051    31.472
  -114.392    31.558
>
  -115.051    31.472
  -114.392    31.558
>
  -113.633    31.335
  -114.392    31.558
>
  -113.633    31.335
  -114.392    31.558
>
  -113.460    31.560
  -114.392    31.558
>
  -113.460    31.560
  -114.392    31.558
>
  -113.460    31.560
  -114.392    31.558
>
  -114.705    32.458
  -114.392    31.558
>
  -115.076    32.303
  -114.392    31.558
>
  -115.076    32.303
  -114.392    31.558
>
  -115.284    32.135
  -114.392    31.558
>
  -114.404    29.830
  -114.277    30.158
>
  -114.404    29.830
  -114.277    30.158
>
  -115.466    31.046
  -114.794    30.768
>
  -115.466    31.046
  -114.794    30.768
>
  -115.051    31.472
  -114.794    30.768
>
  -115.051    31.472
  -114.794    30.768
>
  -115.051    31.472
  -114.794    30.768
>
  -115.876    30.576
  -114.794    30.768
>
  -114.404    29.830
  -114.794    30.768
>
  -114.404    29.830
  -114.794    30.768
>
  -114.404    29.830
  -114.256    30.117
>
  -114.404    29.830
  -114.256    30.117
>
  -113.633    31.335
  -114.184    30.940
>
  -113.460    31.560
  -114.184    30.940
>
  -113.460    31.560
  -114.184    30.940
>
  -115.051    31.472
  -114.184    30.940
>
  -115.051    31.472
  -114.184    30.940
>
  -113.633    31.335
  -114.230    31.038
>
  -113.633    31.335
  -114.230    31.038
>
  -113.633    31.335
  -114.230    31.038
>
  -113.633    31.335
  -114.230    31.038
>
  -115.051    31.472
  -114.230    31.038
>
  -115.051    31.472
  -114.230    31.038
>
  -113.460    31.560
  -114.230    31.038
>
  -113.460    31.560
  -114.230    31.038
>
  -113.633    31.335
  -114.179    30.928
>
  -113.633    31.335
  -114.179    30.928
>
  -115.051    31.472
  -114.179    30.928
>
  -115.051    31.472
  -114.179    30.928
>
  -113.460    31.560
  -114.179    30.928
>
  -113.460    31.560
  -114.179    30.928
>
  -113.460    31.560
  -114.179    30.928
>
  -113.633    31.335
  -114.108    30.892
>
  -113.633    31.335
  -114.108    30.892
>
  -113.460    31.560
  -114.108    30.892
>
  -113.460    31.560
  -114.108    30.892
>
  -115.051    31.472
  -114.108    30.892
>
  -115.051    31.472
  -114.108    30.892
>
  -115.051    31.472
  -114.108    30.892
>
  -115.051    31.472
  -114.108    30.892
>
  -114.404    29.830
  -113.863    30.378
>
  -114.404    29.830
  -113.863    30.378
>
  -113.633    31.335
  -113.863    30.378
>
  -113.633    31.335
  -113.863    30.378
>
  -113.633    31.335
  -114.347    31.281
>
  -113.633    31.335
  -114.347    31.281
>
  -115.051    31.472
  -114.347    31.281
>
  -115.051    31.472
  -114.347    31.281
>
  -115.051    31.472
  -114.347    31.281
>
  -113.460    31.560
  -114.347    31.281
>
  -113.460    31.560
  -114.347    31.281
>
  -115.466    31.046
  -114.347    31.281
>
  -115.466    31.046
  -114.347    31.281
>
  -115.466    31.046
  -114.347    31.281
>
  -115.466    31.046
  -114.347    31.281
>
  -115.051    31.472
  -114.339    31.215
>
  -115.051    31.472
  -114.339    31.215
>
  -113.633    31.335
  -114.339    31.215
>
  -113.633    31.335
  -114.339    31.215
>
  -113.633    31.335
  -114.339    31.215
>
  -113.460    31.560
  -114.339    31.215
>
  -113.460    31.560
  -114.339    31.215
>
  -113.460    31.560
  -114.339    31.215
>
  -115.466    31.046
  -114.339    31.215
>
  -115.466    31.046
  -114.339    31.215
>
  -115.466    31.046
  -114.339    31.215
>
  -115.466    31.046
  -114.339    31.215
>
  -115.466    31.046
  -114.339    31.215
>
  -113.633    31.335
  -114.343    31.388
>
  -113.633    31.335
  -114.343    31.388
>
  -115.051    31.472
  -114.343    31.388
>
  -115.051    31.472
  -114.343    31.388
>
  -115.051    31.472
  -114.343    31.388
>
  -113.460    31.560
  -114.343    31.388
>
  -113.460    31.560
  -114.343    31.388
>
  -113.633    31.335
  -114.417    31.567
>
  -113.633    31.335
  -114.417    31.567
>
  -113.633    31.335
  -114.417    31.567
>
  -113.460    31.560
  -114.417    31.567
>
  -113.460    31.560
  -114.417    31.567
>
  -115.076    32.303
  -114.417    31.567
>
  -115.076    32.303
  -114.417    31.567
>
  -115.284    32.135
  -114.417    31.567
>
  -115.161    32.266
  -114.417    31.567
>
  -113.633    31.335
  -114.310    31.248
>
  -113.633    31.335
  -114.310    31.248
>
  -113.633    31.335
  -114.310    31.248
>
  -113.633    31.335
  -114.310    31.248
>
  -115.051    31.472
  -114.310    31.248
>
  -115.051    31.472
  -114.310    31.248
>
  -115.051    31.472
  -114.310    31.248
>
  -113.460    31.560
  -114.310    31.248
>
  -113.460    31.560
  -114.310    31.248
>
  -114.745    31.959
  -114.310    31.248
>
  -113.633    31.335
  -114.084    30.744
>
  -113.633    31.335
  -114.084    30.744
>
  -114.404    29.830
  -114.084    30.744
>
  -113.460    31.560
  -114.084    30.744
>
  -113.460    31.560
  -114.084    30.744
>
  -114.404    29.830
  -113.838    30.279
>
  -114.404    29.830
  -113.838    30.279
>
  -114.404    29.830
  -113.992    29.675
>
  -114.404    29.830
  -113.992    29.675
>
  -113.562    28.944
  -113.992    29.675
>
  -113.562    28.944
  -113.992    29.675
>
  -113.562    28.944
  -113.992    29.675
>
  -113.562    28.944
  -113.992    29.675
>
  -114.404    29.830
  -114.228    30.196
>
  -114.404    29.830
  -114.228    30.196
>
  -114.404    29.830
  -114.117    30.204
>
  -114.404    29.830
  -114.117    30.204
>
  -113.633    31.335
  -114.086    30.622
>
  -113.633    31.335
  -114.086    30.622
>
  -113.633    31.335
  -114.128    30.693
>
  -113.633    31.335
  -114.128    30.693
>
  -114.745    31.959
  -114.497    31.484
>
  -113.633    31.335
  -114.497    31.484
>
  -113.633    31.335
  -114.497    31.484
>
  -113.633    31.335
  -114.497    31.484
>
  -114.961    32.166
  -114.497    31.484
>
  -115.466    31.046
  -114.497    31.484
>
  -115.466    31.046
  -114.497    31.484
>
  -115.466    31.046
  -114.497    31.484
>
  -115.466    31.046
  -114.497    31.484
>
  -115.284    32.135
  -114.497    31.484
>
  -115.284    32.135
  -114.497    31.484
>
  -115.076    32.303
  -114.497    31.484
>
  -115.076    32.303
  -114.497    31.484
>
  -115.161    32.266
  -114.497    31.484
>
  -114.705    32.458
  -114.497    31.484
>
  -114.705    32.458
  -114.497    31.484
>
  -114.745    31.959
  -114.499    31.493
>
  -114.961    32.166
  -114.499    31.493
>
  -113.633    31.335
  -114.499    31.493
>
  -113.633    31.335
  -114.499    31.493
>
  -115.284    32.135
  -114.499    31.493
>
  -115.076    32.303
  -114.499    31.493
>
  -115.161    32.266
  -114.499    31.493
>
  -114.705    32.458
  -114.499    31.493
>
  -115.466    31.046
  -114.499    31.493
>
  -115.466    31.046
  -114.499    31.493
>
  -115.466    31.046
  -114.499    31.493
>
  -114.745    31.959
  -114.488    31.474
>
  -114.961    32.166
  -114.488    31.474
>
  -115.466    31.046
  -114.488    31.474
>
  -115.466    31.046
  -114.488    31.474
>
  -115.284    32.135
  -114.488    31.474
>
  -115.076    32.303
  -114.488    31.474
>
  -115.076    32.303
  -114.488    31.474
>
  -115.161    32.266
  -114.488    31.474
>
  -114.705    32.458
  -114.488    31.474
>
  -114.705    32.458
  -114.488    31.474
>
  -114.745    31.959
  -114.526    31.520
>
  -114.745    31.959
  -114.526    31.520
>
  -114.961    32.166
  -114.526    31.520
>
  -114.961    32.166
  -114.526    31.520
>
  -115.466    31.046
  -114.526    31.520
>
  -115.466    31.046
  -114.526    31.520
>
  -115.466    31.046
  -114.526    31.520
>
  -115.466    31.046
  -114.526    31.520
>
  -115.284    32.135
  -114.526    31.520
>
  -115.284    32.135
  -114.526    31.520
>
  -115.161    32.266
  -114.526    31.520
>
  -114.705    32.458
  -114.526    31.520
>
  -114.404    29.830
  -114.162    29.873
>
  -114.404    29.830
  -114.162    29.873
>
  -114.404    29.830
  -114.170    29.822
>
  -114.404    29.830
  -114.170    29.822
>
  -114.745    31.959
  -114.479    31.627
>
  -114.745    31.959
  -114.479    31.627
>
  -115.051    31.472
  -114.479    31.627
>
  -115.051    31.472
  -114.479    31.627
>
  -114.961    32.166
  -114.479    31.627
>
  -113.633    31.335
  -114.479    31.627
>
  -113.633    31.335
  -114.479    31.627
>
  -113.460    31.560
  -114.479    31.627
>
  -113.460    31.560
  -114.479    31.627
>
  -115.284    32.135
  -114.479    31.627
>
  -115.284    32.135
  -114.479    31.627
>
  -115.161    32.266
  -114.479    31.627
>
  -115.161    32.266
  -114.479    31.627
>
  -114.964    32.433
  -114.479    31.627
>
  -113.633    31.335
  -114.265    31.255
>
  -113.633    31.335
  -114.265    31.255
>
  -115.051    31.472
  -114.265    31.255
>
  -115.051    31.472
  -114.265    31.255
>
  -113.460    31.560
  -114.265    31.255
>
  -113.460    31.560
  -114.265    31.255
>
  -113.460    31.560
  -114.265    31.255
>
  -114.404    29.830
  -114.102    30.193
>
  -114.404    29.830
  -114.102    30.193
>
  -115.051    31.472
  -114.384    31.658
>
  -115.051    31.472
  -114.384    31.658
>
  -113.633    31.335
  -114.384    31.658
>
  -113.633    31.335
  -114.384    31.658
>
  -113.460    31.560
  -114.384    31.658
>
  -113.460    31.560
  -114.384    31.658
>
  -113.633    31.335
  -114.209    30.816
>
  -113.633    31.335
  -114.209    30.816
>
  -115.051    31.472
  -114.209    30.816
>
  -115.051    31.472
  -114.209    30.816
>
  -113.460    31.560
  -114.209    30.816
>
  -114.404    29.830
  -114.209    30.816
>
  -114.404    29.830
  -114.209    30.816
>
  -113.633    31.335
  -114.193    30.774
>
  -113.633    31.335
  -114.193    30.774
>
  -114.404    29.830
  -114.193    30.774
>
  -114.404    29.830
  -114.193    30.774
>
  -114.745    31.959
  -114.562    31.678
>
  -114.745    31.959
  -114.562    31.678
>
  -114.745    31.959
  -114.562    31.678
>
  -115.051    31.472
  -114.562    31.678
>
  -115.051    31.472
  -114.562    31.678
>
  -115.051    31.472
  -114.562    31.678
>
  -114.961    32.166
  -114.562    31.678
>
  -115.284    32.135
  -114.562    31.678
>
  -115.076    32.303
  -114.562    31.678
>
  -115.076    32.303
  -114.562    31.678
>
  -115.161    32.266
  -114.562    31.678
>
  -115.161    32.266
  -114.562    31.678
>
  -114.705    32.458
  -114.562    31.678
>
  -114.705    32.458
  -114.562    31.678
>
  -114.964    32.433
  -114.562    31.678
>
  -114.964    32.433
  -114.562    31.678
>
  -114.964    32.433
  -114.562    31.678
>
  -113.633    31.335
  -114.562    31.678
>
  -113.633    31.335
  -114.562    31.678
>
  -115.198    32.407
  -114.562    31.678
>
  -115.198    32.407
  -114.562    31.678
>
  -113.460    31.560
  -114.562    31.678
>
  -113.460    31.560
  -114.562    31.678
>
  -115.145    32.473
  -114.562    31.678
>
  -115.145    32.473
  -114.562    31.678
>
  -115.466    31.046
  -114.562    31.678
>
  -115.304    32.418
  -114.562    31.678
>
  -115.304    32.418
  -114.562    31.678
>
  -115.051    31.472
  -114.553    31.741
>
  -115.051    31.472
  -114.553    31.741
>
  -115.051    31.472
  -114.553    31.741
>
  -114.961    32.166
  -114.553    31.741
>
  -115.284    32.135
  -114.553    31.741
>
  -115.161    32.266
  -114.553    31.741
>
  -115.161    32.266
  -114.553    31.741
>
  -113.633    31.335
  -114.553    31.741
>
  -113.633    31.335
  -114.553    31.741
>
  -113.633    31.335
  -114.553    31.741
>
  -115.198    32.407
  -114.553    31.741
>
  -113.460    31.560
  -114.553    31.741
>
  -113.460    31.560
  -114.553    31.741
>
  -114.404    29.830
  -114.160    29.853
>
  -114.404    29.830
  -114.160    29.853
>
  -114.745    31.959
  -114.398    31.510
>
  -114.961    32.166
  -114.398    31.510
>
  -113.460    31.560
  -114.398    31.510
>
  -113.460    31.560
  -114.398    31.510
>
  -115.076    32.303
  -114.398    31.510
>
  -115.076    32.303
  -114.398    31.510
>
  -115.051    31.472
  -114.571    31.524
>
  -115.051    31.472
  -114.571    31.524
>
  -115.051    31.472
  -114.571    31.524
>
  -114.745    31.959
  -114.571    31.524
>
  -114.745    31.959
  -114.571    31.524
>
  -113.633    31.335
  -114.571    31.524
>
  -113.633    31.335
  -114.571    31.524
>
  -115.284    32.135
  -114.571    31.524
>
  -115.161    32.266
  -114.571    31.524
>
  -115.161    32.266
  -114.571    31.524
>
  -113.460    31.560
  -114.571    31.524
>
  -113.460    31.560
  -114.571    31.524
>
  -114.404    29.830
  -113.900    29.706
>
  -114.404    29.830
  -113.900    29.706
>
  -113.562    28.944
  -113.900    29.706
>
  -113.562    28.944
  -113.900    29.706
>
  -114.404    29.830
  -113.924    30.004
>
  -114.404    29.830
  -113.924    30.004
>
  -114.404    29.830
  -113.924    30.004
>
  -114.404    29.830
  -113.985    30.052
>
  -114.404    29.830
  -113.985    30.052
>
  -114.404    29.830
  -113.931    30.009
>
  -114.404    29.830
  -113.931    30.009
>
  -114.745    31.960
  -114.362    31.503
>
  -114.745    31.960
  -114.362    31.503
>
  -114.745    31.959
  -114.362    31.503
>
  -114.745    31.959
  -114.362    31.503
>
  -115.051    31.472
  -114.362    31.503
>
  -115.051    31.472
  -114.362    31.503
>
  -113.633    31.335
  -114.362    31.503
>
  -113.633    31.335
  -114.362    31.503
>
  -113.633    31.335
  -114.362    31.503
>
  -113.460    31.560
  -114.362    31.503
>
  -113.460    31.560
  -114.362    31.503
>
  -113.460    31.560
  -114.362    31.503
>
  -114.961    32.166
  -114.362    31.503
>
  -114.961    32.166
  -114.362    31.503
>
  -114.961    32.166
  -114.362    31.503
>
  -114.404    29.830
  -114.053    29.906
>
  -114.404    29.830
  -114.053    29.906
>
  -114.404    29.830
  -114.054    29.976
>
  -114.404    29.830
  -114.054    29.976
>
  -114.404    29.830
  -114.054    29.976
>
  -113.633    31.335
  -114.184    30.764
>
  -113.633    31.335
  -114.184    30.764
>
  -113.633    31.335
  -114.184    30.764
>
  -113.633    31.335
  -114.184    30.764
>
  -114.404    29.830
  -114.184    30.764
>
  -114.404    29.830
  -114.184    30.764
>
  -113.633    31.335
  -114.120    30.765
>
  -113.633    31.335
  -114.120    30.765
>
  -113.460    31.560
  -114.120    30.765
>
  -113.460    31.560
  -114.120    30.765
>
  -114.404    29.830
  -114.120    30.765
>
  -114.404    29.830
  -114.120    30.765
>
  -113.633    31.335
  -114.153    30.789
>
  -113.633    31.335
  -114.153    30.789
>
  -113.633    31.335
  -114.153    30.789
>
  -113.633    31.335
  -114.153    30.789
>
  -114.404    29.830
  -114.153    30.789
>
  -114.404    29.830
  -114.153    30.789
>
  -113.460    31.560
  -114.153    30.789
>
  -113.460    31.560
  -114.153    30.789
>
  -113.633    31.335
  -114.115    30.727
>
  -113.633    31.335
  -114.115    30.727
>
  -114.404    29.830
  -114.115    30.727
>
  -114.404    29.830
  -114.115    30.727
>
  -115.051    31.472
  -114.352    31.315
>
  -115.051    31.472
  -114.352    31.315
>
  -113.633    31.335
  -114.352    31.315
>
  -113.633    31.335
  -114.352    31.315
>
  -113.460    31.560
  -114.352    31.315
>
  -113.460    31.560
  -114.352    31.315
>
  -115.466    31.046
  -114.352    31.315
>
  -115.466    31.046
  -114.352    31.315
>
  -115.466    31.046
  -114.352    31.315
>
  -115.466    31.046
  -114.352    31.315
>
  -114.404    29.830
  -113.747    29.795
>
  -114.404    29.830
  -113.747    29.795
>
  -113.562    28.944
  -113.747    29.795
>
  -113.562    28.944
  -113.747    29.795
>
  -113.562    28.944
  -113.747    29.795
>
  -112.694    29.915
  -113.747    29.795
>
  -112.694    29.915
  -113.747    29.795
>
  -114.404    29.830
  -113.759    29.789
>
  -114.404    29.830
  -113.759    29.789
>
  -113.562    28.944
  -113.759    29.789
>
  -113.562    28.944
  -113.759    29.789
>
  -112.694    29.915
  -113.759    29.789
>
  -112.694    29.915
  -113.759    29.789
>
  -114.404    29.830
  -113.772    29.834
>
  -114.404    29.830
  -113.772    29.834
>
  -113.562    28.944
  -113.772    29.834
>
  -113.562    28.944
  -113.772    29.834
>
  -113.562    28.944
  -113.772    29.834
>
  -113.562    28.944
  -113.772    29.834
>
  -112.694    29.915
  -113.772    29.834
>
  -112.694    29.915
  -113.772    29.834
>
  -114.404    29.830
  -113.736    29.788
>
  -114.404    29.830
  -113.736    29.788
>
  -112.694    29.915
  -113.736    29.788
>
  -112.694    29.915
  -113.736    29.788
>
  -113.562    28.944
  -113.736    29.788
>
  -113.562    28.944
  -113.736    29.788
>
  -114.404    29.830
  -113.752    29.778
>
  -114.404    29.830
  -113.752    29.778
>
  -113.562    28.944
  -113.752    29.778
>
  -113.562    28.944
  -113.752    29.778
>
  -112.694    29.915
  -113.752    29.778
>
  -112.694    29.915
  -113.752    29.778
>
  -114.404    29.830
  -113.790    29.785
>
  -114.404    29.830
  -113.790    29.785
>
  -113.562    28.944
  -113.790    29.785
>
  -113.562    28.944
  -113.790    29.785
>
  -113.562    28.944
  -113.790    29.785
>
  -112.694    29.915
  -113.790    29.785
>
  -112.694    29.915
  -113.790    29.785
>
  -114.404    29.830
  -113.792    29.818
>
  -114.404    29.830
  -113.792    29.818
>
  -113.562    28.944
  -113.792    29.818
>
  -113.562    28.944
  -113.792    29.818
>
  -113.562    28.944
  -113.792    29.818
>
  -113.562    28.944
  -113.792    29.818
>
  -112.694    29.915
  -113.792    29.818
>
  -112.694    29.915
  -113.792    29.818
>
  -114.404    29.830
  -113.784    29.836
>
  -114.404    29.830
  -113.784    29.836
>
  -113.562    28.944
  -113.784    29.836
>
  -113.562    28.944
  -113.784    29.836
>
  -113.562    28.944
  -113.784    29.836
>
  -113.562    28.944
  -113.784    29.836
>
  -112.694    29.915
  -113.784    29.836
>
  -112.694    29.915
  -113.784    29.836
>
  -114.404    29.830
  -113.817    29.810
>
  -114.404    29.830
  -113.817    29.810
>
  -113.562    28.944
  -113.817    29.810
>
  -113.562    28.944
  -113.817    29.810
>
  -113.562    28.944
  -113.817    29.810
>
  -113.562    28.944
  -113.817    29.810
>
  -112.694    29.915
  -113.817    29.810
>
  -112.694    29.915
  -113.817    29.810
>
  -114.404    29.830
  -113.753    29.875
>
  -114.404    29.830
  -113.753    29.875
>
  -112.694    29.915
  -113.753    29.875
>
  -112.694    29.915
  -113.753    29.875
>
  -113.562    28.944
  -113.753    29.875
>
  -113.562    28.944
  -113.753    29.875
>
  -113.562    28.944
  -113.753    29.875
>
  -113.562    28.944
  -113.753    29.875
>
  -114.404    29.830
  -113.781    29.851
>
  -114.404    29.830
  -113.781    29.851
>
  -113.562    28.944
  -113.781    29.851
>
  -113.562    28.944
  -113.781    29.851
>
  -113.562    28.944
  -113.781    29.851
>
  -112.694    29.915
  -113.781    29.851
>
  -112.694    29.915
  -113.781    29.851
>
  -114.404    29.830
  -113.773    29.828
>
  -114.404    29.830
  -113.773    29.828
>
  -113.562    28.944
  -113.773    29.828
>
  -113.562    28.944
  -113.773    29.828
>
  -112.694    29.915
  -113.773    29.828
>
  -112.694    29.915
  -113.773    29.828
>
  -114.404    29.830
  -113.739    29.787
>
  -114.404    29.830
  -113.739    29.787
>
  -113.562    28.944
  -113.739    29.787
>
  -113.562    28.944
  -113.739    29.787
>
  -113.562    28.944
  -113.739    29.787
>
  -113.562    28.944
  -113.739    29.787
>
  -112.694    29.915
  -113.739    29.787
>
  -112.694    29.915
  -113.739    29.787
>
  -114.404    29.830
  -113.784    29.934
>
  -114.404    29.830
  -113.784    29.934
>
  -112.694    29.915
  -113.784    29.934
>
  -112.694    29.915
  -113.784    29.934
>
  -114.404    29.830
  -113.700    29.840
>
  -114.404    29.830
  -113.700    29.840
>
  -112.694    29.915
  -113.700    29.840
>
  -112.694    29.915
  -113.700    29.840
>
  -113.562    28.944
  -113.700    29.840
>
  -113.562    28.944
  -113.700    29.840
>
  -113.562    28.944
  -113.700    29.840
>
  -113.562    28.944
  -113.700    29.840
>
  -114.404    29.830
  -113.730    29.880
>
  -114.404    29.830
  -113.730    29.880
>
  -112.694    29.915
  -113.730    29.880
>
  -112.694    29.915
  -113.730    29.880
>
  -113.562    28.944
  -113.730    29.880
>
  -113.562    28.944
  -113.730    29.880
>
  -113.562    28.944
  -113.730    29.880
>
  -114.404    29.830
  -113.767    29.863
>
  -114.404    29.830
  -113.767    29.863
>
  -113.562    28.944
  -113.767    29.863
>
  -113.562    28.944
  -113.767    29.863
>
  -113.562    28.944
  -113.767    29.863
>
  -113.562    28.944
  -113.767    29.863
>
  -112.694    29.915
  -113.767    29.863
>
  -112.694    29.915
  -113.767    29.863
>
  -114.404    29.830
  -113.797    29.873
>
  -114.404    29.830
  -113.797    29.873
>
  -112.694    29.915
  -113.797    29.873
>
  -112.694    29.915
  -113.797    29.873
>
  -113.562    28.944
  -113.797    29.873
>
  -113.562    28.944
  -113.797    29.873
>
  -113.562    28.944
  -113.797    29.873
>
  -114.404    29.830
  -113.726    29.877
>
  -114.404    29.830
  -113.726    29.877
>
  -112.694    29.915
  -113.726    29.877
>
  -112.694    29.915
  -113.726    29.877
>
  -113.562    28.944
  -113.726    29.877
>
  -113.562    28.944
  -113.726    29.877
>
  -113.562    28.944
  -113.726    29.877
>
  -113.562    28.944
  -113.726    29.877
>
  -114.404    29.830
  -113.782    29.824
>
  -114.404    29.830
  -113.782    29.824
>
  -112.694    29.915
  -113.782    29.824
>
  -112.694    29.915
  -113.782    29.824
>
  -113.562    28.944
  -113.782    29.824
>
  -113.562    28.944
  -113.782    29.824
>
  -113.562    28.944
  -113.782    29.824
>
  -114.404    29.830
  -113.734    29.885
>
  -114.404    29.830
  -113.734    29.885
>
  -112.694    29.915
  -113.734    29.885
>
  -112.694    29.915
  -113.734    29.885
>
  -113.562    28.944
  -113.734    29.885
>
  -113.562    28.944
  -113.734    29.885
>
  -113.562    28.944
  -113.734    29.885
>
  -113.562    28.944
  -113.734    29.885
>
  -114.404    29.830
  -113.733    29.833
>
  -114.404    29.830
  -113.733    29.833
>
  -112.694    29.915
  -113.733    29.833
>
  -112.694    29.915
  -113.733    29.833
>
  -113.562    28.944
  -113.733    29.833
>
  -113.562    28.944
  -113.733    29.833
>
  -113.562    28.944
  -113.733    29.833
>
  -113.562    28.944
  -113.733    29.833
>
  -114.404    29.830
  -113.738    29.806
>
  -114.404    29.830
  -113.738    29.806
>
  -113.562    28.944
  -113.738    29.806
>
  -113.562    28.944
  -113.738    29.806
>
  -113.562    28.944
  -113.738    29.806
>
  -112.694    29.915
  -113.738    29.806
>
  -112.694    29.915
  -113.738    29.806
>
  -114.404    29.830
  -113.730    29.940
>
  -114.404    29.830
  -113.730    29.940
>
  -112.694    29.915
  -113.730    29.940
>
  -112.694    29.915
  -113.730    29.940
>
  -114.404    29.830
  -113.738    29.884
>
  -114.404    29.830
  -113.738    29.884
>
  -112.694    29.915
  -113.738    29.884
>
  -112.694    29.915
  -113.738    29.884
>
  -113.562    28.944
  -113.738    29.884
>
  -113.562    28.944
  -113.738    29.884
>
  -113.562    28.944
  -113.738    29.884
>
  -114.404    29.830
  -113.761    29.883
>
  -114.404    29.830
  -113.761    29.883
>
  -112.694    29.915
  -113.761    29.883
>
  -112.694    29.915
  -113.761    29.883
>
  -113.562    28.944
  -113.761    29.883
>
  -113.562    28.944
  -113.761    29.883
>
  -113.562    28.944
  -113.761    29.883
>
  -114.404    29.830
  -113.744    29.921
>
  -114.404    29.830
  -113.744    29.921
>
  -112.694    29.915
  -113.744    29.921
>
  -112.694    29.915
  -113.744    29.921
>
  -113.562    28.944
  -113.744    29.921
>
  -113.562    28.944
  -113.744    29.921
>
  -113.562    28.944
  -113.744    29.921
>
  -114.404    29.830
  -113.726    29.897
>
  -114.404    29.830
  -113.726    29.897
>
  -112.694    29.915
  -113.726    29.897
>
  -112.694    29.915
  -113.726    29.897
>
  -113.562    28.944
  -113.726    29.897
>
  -113.562    28.944
  -113.726    29.897
>
  -113.562    28.944
  -113.726    29.897
>
  -113.562    28.944
  -113.726    29.897
>
  -114.745    31.960
  -114.427    31.569
>
  -114.745    31.960
  -114.427    31.569
>
  -114.745    31.959
  -114.427    31.569
>
  -114.745    31.959
  -114.427    31.569
>
  -115.051    31.472
  -114.427    31.569
>
  -115.051    31.472
  -114.427    31.569
>
  -115.051    31.472
  -114.427    31.569
>
  -115.051    31.472
  -114.427    31.569
>
  -113.633    31.335
  -114.427    31.569
>
  -113.633    31.335
  -114.427    31.569
>
  -114.961    32.166
  -114.427    31.569
>
  -114.961    32.166
  -114.427    31.569
>
  -114.961    32.166
  -114.427    31.569
>
  -114.961    32.166
  -114.427    31.569
>
  -113.460    31.560
  -114.427    31.569
>
  -113.460    31.560
  -114.427    31.569
>
  -115.076    32.303
  -114.427    31.569
>
  -115.076    32.303
  -114.427    31.569
>
  -114.705    32.458
  -114.427    31.569
>
  -114.705    32.458
  -114.427    31.569
>
  -114.705    32.458
  -114.427    31.569
>
  -115.161    32.266
  -114.427    31.569
>
  -115.161    32.266
  -114.427    31.569
>
  -114.745    31.960
  -114.433    31.584
>
  -114.745    31.959
  -114.433    31.584
>
  -114.745    31.959
  -114.433    31.584
>
  -115.051    31.472
  -114.433    31.584
>
  -115.051    31.472
  -114.433    31.584
>
  -115.051    31.472
  -114.433    31.584
>
  -115.051    31.472
  -114.433    31.584
>
  -114.961    32.166
  -114.433    31.584
>
  -114.961    32.166
  -114.433    31.584
>
  -114.961    32.166
  -114.433    31.584
>
  -113.633    31.335
  -114.433    31.584
>
  -113.633    31.335
  -114.433    31.584
>
  -113.460    31.560
  -114.433    31.584
>
  -113.460    31.560
  -114.433    31.584
>
  -113.460    31.560
  -114.433    31.584
>
  -115.076    32.303
  -114.433    31.584
>
  -114.705    32.458
  -114.433    31.584
>
  -115.284    32.135
  -114.433    31.584
>
  -115.284    32.135
  -114.433    31.584
>
  -115.161    32.266
  -114.433    31.584
>
  -115.161    32.266
  -114.433    31.584
>
  -114.964    32.433
  -114.433    31.584
>
  -114.964    32.433
  -114.433    31.584
>
  -114.964    32.433
  -114.433    31.584
>
  -114.964    32.433
  -114.433    31.584
>
  -114.356    32.584
  -114.433    31.584
>
  -114.404    29.830
  -113.723    29.884
>
  -114.404    29.830
  -113.723    29.884
>
  -112.694    29.915
  -113.723    29.884
>
  -112.694    29.915
  -113.723    29.884
>
  -113.562    28.944
  -113.723    29.884
>
  -113.562    28.944
  -113.723    29.884
>
  -113.562    28.944
  -113.723    29.884
>
  -114.404    29.830
  -113.747    29.918
>
  -114.404    29.830
  -113.747    29.918
>
  -112.694    29.915
  -113.747    29.918
>
  -112.694    29.915
  -113.747    29.918
>
  -113.562    28.944
  -113.747    29.918
>
  -113.562    28.944
  -113.747    29.918
>
  -113.562    28.944
  -113.747    29.918
>
  -113.562    28.944
  -113.747    29.918
>
  -114.404    29.830
  -113.762    29.927
>
  -114.404    29.830
  -113.762    29.927
>
  -112.694    29.915
  -113.762    29.927
>
  -112.694    29.915
  -113.762    29.927
>
  -113.562    28.944
  -113.762    29.927
>
  -113.562    28.944
  -113.762    29.927
>
  -113.562    28.944
  -113.762    29.927
>
  -113.562    28.944
  -113.762    29.927
>
  -114.404    29.830
  -113.734    29.840
>
  -114.404    29.830
  -113.734    29.840
>
  -112.694    29.915
  -113.734    29.840
>
  -112.694    29.915
  -113.734    29.840
>
  -113.562    28.944
  -113.734    29.840
>
  -113.562    28.944
  -113.734    29.840
>
  -113.562    28.944
  -113.734    29.840
>
  -113.562    28.944
  -113.734    29.840
>
  -114.404    29.830
  -113.736    29.803
>
  -114.404    29.830
  -113.736    29.803
>
  -113.562    28.944
  -113.736    29.803
>
  -113.562    28.944
  -113.736    29.803
>
  -113.562    28.944
  -113.736    29.803
>
  -112.694    29.915
  -113.736    29.803
>
  -112.694    29.915
  -113.736    29.803
>
  -114.404    29.830
  -113.732    29.864
>
  -114.404    29.830
  -113.732    29.864
>
  -112.694    29.915
  -113.732    29.864
>
  -112.694    29.915
  -113.732    29.864
>
  -114.404    29.830
  -113.724    29.901
>
  -114.404    29.830
  -113.724    29.901
>
  -112.694    29.915
  -113.724    29.901
>
  -112.694    29.915
  -113.724    29.901
>
  -114.404    29.830
  -113.862    29.753
>
  -114.404    29.830
  -113.862    29.753
>
  -113.562    28.944
  -113.862    29.753
>
  -113.562    28.944
  -113.862    29.753
>
  -114.404    29.830
  -113.825    29.775
>
  -114.404    29.830
  -113.825    29.775
>
  -113.562    28.944
  -113.825    29.775
>
  -113.562    28.944
  -113.825    29.775
>
  -113.562    28.944
  -113.825    29.775
>
  -112.694    29.915
  -113.825    29.775
>
  -112.694    29.915
  -113.825    29.775
>
  -114.404    29.830
  -113.875    29.722
>
  -114.404    29.830
  -113.875    29.722
>
  -113.562    28.944
  -113.875    29.722
>
  -113.562    28.944
  -113.875    29.722
>
  -114.404    29.830
  -113.734    29.871
>
  -114.404    29.830
  -113.734    29.871
>
  -112.694    29.915
  -113.734    29.871
>
  -112.694    29.915
  -113.734    29.871
>
  -113.562    28.944
  -113.734    29.871
>
  -113.562    28.944
  -113.734    29.871
>
  -113.562    28.944
  -113.734    29.871
>
  -114.404    29.830
  -113.748    29.815
>
  -114.404    29.830
  -113.748    29.815
>
  -113.562    28.944
  -113.748    29.815
>
  -113.562    28.944
  -113.748    29.815
>
  -113.562    28.944
  -113.748    29.815
>
  -113.562    28.944
  -113.748    29.815
>
  -112.694    29.915
  -113.748    29.815
>
  -112.694    29.915
  -113.748    29.815
>
  -114.404    29.830
  -113.785    29.878
>
  -114.404    29.830
  -113.785    29.878
>
  -112.694    29.915
  -113.785    29.878
>
  -113.562    28.944
  -113.785    29.878
>
  -113.562    28.944
  -113.785    29.878
>
  -113.562    28.944
  -113.785    29.878
>
  -114.404    29.830
  -113.732    29.873
>
  -114.404    29.830
  -113.732    29.873
>
  -112.694    29.915
  -113.732    29.873
>
  -112.694    29.915
  -113.732    29.873
>
  -113.562    28.944
  -113.732    29.873
>
  -113.562    28.944
  -113.732    29.873
>
  -113.562    28.944
  -113.732    29.873
>
  -113.562    28.944
  -113.732    29.873
>
  -114.404    29.830
  -113.626    30.109
>
  -114.404    29.830
  -113.775    29.859
>
  -114.404    29.830
  -113.775    29.859
>
  -113.562    28.944
  -113.775    29.859
>
  -113.562    28.944
  -113.775    29.859
>
  -112.694    29.915
  -113.775    29.859
>
  -112.694    29.915
  -113.775    29.859
>
  -114.404    29.830
  -113.771    29.901
>
  -114.404    29.830
  -113.771    29.901
>
  -112.694    29.915
  -113.771    29.901
>
  -112.694    29.915
  -113.771    29.901
>
  -113.562    28.944
  -113.771    29.901
>
  -113.562    28.944
  -113.771    29.901
>
  -113.562    28.944
  -113.771    29.901
>
  -113.562    28.944
  -113.771    29.901
>
  -114.404    29.830
  -113.770    29.869
>
  -114.404    29.830
  -113.770    29.869
>
  -112.694    29.915
  -113.770    29.869
>
  -113.562    28.944
  -113.770    29.869
>
  -113.562    28.944
  -113.770    29.869
>
  -113.562    28.944
  -113.770    29.869
>
  -113.562    28.944
  -113.770    29.869
>
  -114.404    29.830
  -113.740    29.832
>
  -114.404    29.830
  -113.740    29.832
>
  -113.562    28.944
  -113.740    29.832
>
  -113.562    28.944
  -113.740    29.832
>
  -113.562    28.944
  -113.740    29.832
>
  -113.562    28.944
  -113.740    29.832
>
  -112.694    29.915
  -113.740    29.832
>
  -112.694    29.915
  -113.740    29.832
>
  -114.404    29.830
  -113.753    29.833
>
  -114.404    29.830
  -113.753    29.833
>
  -113.562    28.944
  -113.753    29.833
>
  -113.562    28.944
  -113.753    29.833
>
  -113.562    28.944
  -113.753    29.833
>
  -112.694    29.915
  -113.753    29.833
>
  -112.694    29.915
  -113.753    29.833
>
  -114.404    29.830
  -113.721    29.852
>
  -114.404    29.830
  -113.721    29.852
>
  -112.694    29.915
  -113.721    29.852
>
  -112.694    29.915
  -113.721    29.852
>
  -113.562    28.944
  -113.721    29.852
>
  -113.562    28.944
  -113.721    29.852
>
  -113.562    28.944
  -113.721    29.852
>
  -114.404    29.830
  -113.756    29.842
>
  -114.404    29.830
  -113.756    29.842
>
  -112.694    29.915
  -113.756    29.842
>
  -112.694    29.915
  -113.756    29.842
>
  -113.562    28.944
  -113.756    29.842
>
  -113.562    28.944
  -113.756    29.842
>
  -113.562    28.944
  -113.756    29.842
>
  -113.562    28.944
  -113.756    29.842
>
  -112.694    29.915
  -113.463    30.040
>
  -112.694    29.915
  -113.463    30.040
>
  -114.404    29.830
  -113.751    29.903
>
  -114.404    29.830
  -113.751    29.903
>
  -112.694    29.915
  -113.751    29.903
>
  -112.694    29.915
  -113.751    29.903
>
  -113.562    28.944
  -113.751    29.903
>
  -113.562    28.944
  -113.751    29.903
>
  -113.562    28.944
  -113.751    29.903
>
  -113.562    28.944
  -113.751    29.903
>
  -114.404    29.830
  -113.713    30.024
>
  -114.404    29.830
  -113.713    30.024
>
  -112.694    29.915
  -113.713    30.024
>
  -112.694    29.915
  -113.713    30.024
>
  -114.404    29.830
  -113.742    29.796
>
  -114.404    29.830
  -113.742    29.796
>
  -113.562    28.944
  -113.742    29.796
>
  -113.562    28.944
  -113.742    29.796
>
  -113.562    28.944
  -113.742    29.796
>
  -112.694    29.915
  -113.742    29.796
>
  -112.694    29.915
  -113.742    29.796
>
  -114.404    29.830
  -113.736    29.837
>
  -114.404    29.830
  -113.736    29.837
>
  -113.562    28.944
  -113.736    29.837
>
  -113.562    28.944
  -113.736    29.837
>
  -113.562    28.944
  -113.736    29.837
>
  -112.694    29.915
  -113.736    29.837
>
  -112.694    29.915
  -113.736    29.837
>
  -114.404    29.830
  -113.813    29.791
>
  -114.404    29.830
  -113.813    29.791
>
  -113.562    28.944
  -113.813    29.791
>
  -113.562    28.944
  -113.813    29.791
>
  -113.562    28.944
  -113.813    29.791
>
  -112.694    29.915
  -113.813    29.791
>
  -112.694    29.915
  -113.813    29.791
>
  -114.404    29.830
  -113.781    29.796
>
  -114.404    29.830
  -113.781    29.796
>
  -113.562    28.944
  -113.781    29.796
>
  -113.562    28.944
  -113.781    29.796
>
  -113.562    28.944
  -113.781    29.796
>
  -113.562    28.944
  -113.781    29.796
>
  -112.694    29.915
  -113.781    29.796
>
  -112.694    29.915
  -113.781    29.796
>
  -114.404    29.830
  -113.778    29.834
>
  -114.404    29.830
  -113.778    29.834
>
  -113.562    28.944
  -113.778    29.834
>
  -113.562    28.944
  -113.778    29.834
>
  -114.404    29.830
  -113.811    29.815
>
  -114.404    29.830
  -113.811    29.815
>
  -113.562    28.944
  -113.811    29.815
>
  -113.562    28.944
  -113.811    29.815
>
  -113.562    28.944
  -113.811    29.815
>
  -112.694    29.915
  -113.811    29.815
>
  -112.694    29.915
  -113.811    29.815
>
  -112.694    29.915
  -113.811    29.815
>
  -114.404    29.830
  -113.792    29.893
>
  -114.404    29.830
  -113.792    29.893
>
  -112.694    29.915
  -113.792    29.893
>
  -112.694    29.915
  -113.792    29.893
>
  -113.562    28.944
  -113.792    29.893
>
  -113.562    28.944
  -113.792    29.893
>
  -114.404    29.830
  -113.783    29.816
>
  -114.404    29.830
  -113.783    29.816
>
  -113.562    28.944
  -113.783    29.816
>
  -113.562    28.944
  -113.783    29.816
>
  -113.562    28.944
  -113.783    29.816
>
  -112.694    29.915
  -113.783    29.816
>
  -112.694    29.915
  -113.783    29.816
>
  -114.404    29.830
  -113.739    29.842
>
  -114.404    29.830
  -113.739    29.842
>
  -113.562    28.944
  -113.739    29.842
>
  -113.562    28.944
  -113.739    29.842
>
  -113.562    28.944
  -113.739    29.842
>
  -113.562    28.944
  -113.739    29.842
>
  -112.694    29.915
  -113.739    29.842
>
  -112.694    29.915
  -113.739    29.842
>
  -114.404    29.830
  -113.757    29.823
>
  -114.404    29.830
  -113.757    29.823
>
  -113.562    28.944
  -113.757    29.823
>
  -113.562    28.944
  -113.757    29.823
>
  -112.694    29.915
  -113.757    29.823
>
  -112.694    29.915
  -113.757    29.823
>
  -114.404    29.830
  -113.762    29.787
>
  -114.404    29.830
  -113.762    29.787
>
  -113.562    28.944
  -113.762    29.787
>
  -113.562    28.944
  -113.762    29.787
>
  -113.562    28.944
  -113.762    29.787
>
  -113.562    28.944
  -113.762    29.787
>
  -112.694    29.915
  -113.762    29.787
>
  -112.694    29.915
  -113.762    29.787
>
  -114.404    29.830
  -113.751    29.791
>
  -112.694    29.915
  -113.751    29.791
>
  -112.694    29.915
  -113.751    29.791
>
  -113.562    28.944
  -113.751    29.791
>
  -114.404    29.830
  -113.763    29.813
>
  -114.404    29.830
  -113.763    29.813
>
  -113.562    28.944
  -113.763    29.813
>
  -113.562    28.944
  -113.763    29.813
>
  -113.562    28.944
  -113.763    29.813
>
  -113.562    28.944
  -113.763    29.813
>
  -112.694    29.915
  -113.763    29.813
>
  -112.694    29.915
  -113.763    29.813
>
  -114.404    29.830
  -113.764    29.889
>
  -114.404    29.830
  -113.764    29.889
>
  -112.694    29.915
  -113.764    29.889
>
  -112.694    29.915
  -113.764    29.889
>
  -113.562    28.944
  -113.764    29.889
>
  -113.562    28.944
  -113.764    29.889
>
  -113.562    28.944
  -113.764    29.889
>
  -114.404    29.830
  -113.746    29.792
>
  -114.404    29.830
  -113.746    29.792
>
  -112.694    29.915
  -113.746    29.792
>
  -112.694    29.915
  -113.746    29.792
>
  -113.562    28.944
  -113.746    29.792
>
  -113.562    28.944
  -113.746    29.792
>
  -114.404    29.830
  -113.755    29.812
>
  -114.404    29.830
  -113.755    29.812
>
  -112.694    29.915
  -113.755    29.812
>
  -112.694    29.915
  -113.755    29.812
>
  -113.562    28.944
  -113.755    29.812
>
  -113.562    28.944
  -113.755    29.812
>
  -113.562    28.944
  -113.755    29.812
>
  -113.562    28.944
  -113.755    29.812
>
  -114.404    29.830
  -113.669    29.928
>
  -114.404    29.830
  -113.669    29.928
>
  -112.694    29.915
  -113.669    29.928
>
  -112.694    29.915
  -113.669    29.928
>
  -113.562    28.944
  -113.669    29.928
>
  -113.562    28.944
  -113.669    29.928
>
  -113.562    28.944
  -113.669    29.928
>
  -113.562    28.944
  -113.669    29.928
>
  -114.404    29.830
  -113.703    30.002
>
  -114.404    29.830
  -113.703    30.002
>
  -112.694    29.915
  -113.703    30.002
>
  -112.694    29.915
  -113.703    30.002
>
  -114.404    29.830
  -113.756    29.816
>
  -114.404    29.830
  -113.756    29.816
>
  -113.562    28.944
  -113.756    29.816
>
  -113.562    28.944
  -113.756    29.816
>
  -112.694    29.915
  -113.756    29.816
>
  -112.694    29.915
  -113.756    29.816
>
  -114.404    29.830
  -113.800    29.833
>
  -114.404    29.830
  -113.800    29.833
>
  -113.562    28.944
  -113.800    29.833
>
  -113.562    28.944
  -113.800    29.833
>
  -113.562    28.944
  -113.800    29.833
>
  -112.694    29.915
  -113.800    29.833
>
  -112.694    29.915
  -113.800    29.833
>
  -114.404    29.830
  -113.760    29.831
>
  -113.562    28.944
  -113.760    29.831
>
  -113.562    28.944
  -113.760    29.831
>
  -112.694    29.915
  -113.760    29.831
>
  -112.694    29.915
  -113.760    29.831
>
  -114.404    29.830
  -113.767    29.842
>
  -114.404    29.830
  -113.767    29.842
>
  -113.562    28.944
  -113.767    29.842
>
  -113.562    28.944
  -113.767    29.842
>
  -113.562    28.944
  -113.767    29.842
>
  -112.694    29.915
  -113.767    29.842
>
  -112.694    29.915
  -113.767    29.842
>
  -114.404    29.830
  -113.759    29.769
>
  -114.404    29.830
  -113.759    29.769
>
  -113.562    28.944
  -113.759    29.769
>
  -113.562    28.944
  -113.759    29.769
>
  -112.694    29.915
  -113.759    29.769
>
  -112.694    29.915
  -113.759    29.769
>
  -114.404    29.830
  -113.759    29.864
>
  -114.404    29.830
  -113.759    29.864
>
  -112.694    29.915
  -113.759    29.864
>
  -112.694    29.915
  -113.759    29.864
>
  -113.562    28.944
  -113.759    29.864
>
  -113.562    28.944
  -113.759    29.864
>
  -113.562    28.944
  -113.759    29.864
>
  -114.404    29.830
  -113.750    29.827
>
  -114.404    29.830
  -113.750    29.827
>
  -113.562    28.944
  -113.750    29.827
>
  -113.562    28.944
  -113.750    29.827
>
  -113.562    28.944
  -113.750    29.827
>
  -113.562    28.944
  -113.750    29.827
>
  -112.694    29.915
  -113.750    29.827
>
  -112.694    29.915
  -113.750    29.827
>
  -114.404    29.830
  -113.751    29.798
>
  -114.404    29.830
  -113.751    29.798
>
  -113.562    28.944
  -113.751    29.798
>
  -113.562    28.944
  -113.751    29.798
>
  -113.562    28.944
  -113.751    29.798
>
  -112.694    29.915
  -113.751    29.798
>
  -112.694    29.915
  -113.751    29.798
>
  -114.404    29.830
  -113.752    29.780
>
  -114.404    29.830
  -113.752    29.780
>
  -113.562    28.944
  -113.752    29.780
>
  -113.562    28.944
  -113.752    29.780
>
  -113.562    28.944
  -113.752    29.780
>
  -113.562    28.944
  -113.752    29.780
>
  -112.694    29.915
  -113.752    29.780
>
  -112.694    29.915
  -113.752    29.780
>
  -114.404    29.830
  -113.743    29.828
>
  -113.562    28.944
  -113.743    29.828
>
  -113.562    28.944
  -113.743    29.828
>
  -113.562    28.944
  -113.743    29.828
>
  -113.562    28.944
  -113.743    29.828
>
  -112.694    29.915
  -113.743    29.828
>
  -112.694    29.915
  -113.743    29.828
>
  -114.404    29.830
  -113.781    30.079
>
  -114.404    29.830
  -113.781    30.079
>
  -112.694    29.915
  -113.781    30.079
>
  -112.694    29.915
  -113.781    30.079
>
  -114.404    29.830
  -113.780    30.049
>
  -114.404    29.830
  -113.780    30.049
>
  -112.694    29.915
  -113.780    30.049
>
  -112.694    29.915
  -113.780    30.049
>
  -114.404    29.830
  -113.743    29.887
>
  -114.404    29.830
  -113.743    29.887
>
  -112.694    29.915
  -113.743    29.887
>
  -112.694    29.915
  -113.743    29.887
>
  -114.404    29.830
  -113.739    29.891
>
  -114.404    29.830
  -113.739    29.891
>
  -112.694    29.915
  -113.739    29.891
>
  -112.694    29.915
  -113.739    29.891
>
  -113.562    28.944
  -113.739    29.891
>
  -113.562    28.944
  -113.739    29.891
>
  -114.404    29.830
  -113.745    29.823
>
  -114.404    29.830
  -113.745    29.823
>
  -113.562    28.944
  -113.745    29.823
>
  -113.562    28.944
  -113.745    29.823
>
  -113.562    28.944
  -113.745    29.823
>
  -113.562    28.944
  -113.745    29.823
>
  -112.694    29.915
  -113.745    29.823
>
  -112.694    29.915
  -113.745    29.823
>
  -114.404    29.830
  -113.754    29.846
>
  -114.404    29.830
  -113.754    29.846
>
  -112.694    29.915
  -113.754    29.846
>
  -112.694    29.915
  -113.754    29.846
>
  -113.562    28.944
  -113.754    29.846
>
  -113.562    28.944
  -113.754    29.846
>
  -113.562    28.944
  -113.754    29.846
>
  -114.404    29.830
  -113.765    29.865
>
  -114.404    29.830
  -113.765    29.865
>
  -112.694    29.915
  -113.765    29.865
>
  -112.694    29.915
  -113.765    29.865
>
  -113.562    28.944
  -113.765    29.865
>
  -113.562    28.944
  -113.765    29.865
>
  -113.562    28.944
  -113.765    29.865
>
  -113.562    28.944
  -113.765    29.865
>
  -114.404    29.830
  -113.780    29.855
>
  -114.404    29.830
  -113.780    29.855
>
  -113.562    28.944
  -113.780    29.855
>
  -113.562    28.944
  -113.780    29.855
>
  -113.562    28.944
  -113.780    29.855
>
  -113.562    28.944
  -113.780    29.855
>
  -112.694    29.915
  -113.780    29.855
>
  -112.694    29.915
  -113.780    29.855
>
  -114.404    29.830
  -113.877    29.723
>
  -114.404    29.830
  -113.877    29.723
>
  -113.562    28.944
  -113.877    29.723
>
  -113.562    28.944
  -113.877    29.723
>
  -114.404    29.830
  -113.748    29.809
>
  -114.404    29.830
  -113.748    29.809
>
  -113.562    28.944
  -113.748    29.809
>
  -113.562    28.944
  -113.748    29.809
>
  -112.694    29.915
  -113.748    29.809
>
  -112.694    29.915
  -113.748    29.809
>
  -114.404    29.830
  -113.786    29.778
>
  -114.404    29.830
  -113.786    29.778
>
  -112.694    29.915
  -113.786    29.778
>
  -112.694    29.915
  -113.786    29.778
>
  -114.404    29.830
  -113.763    29.790
>
  -114.404    29.830
  -113.763    29.790
>
  -113.562    28.944
  -113.763    29.790
>
  -113.562    28.944
  -113.763    29.790
>
  -112.694    29.915
  -113.763    29.790
>
  -112.694    29.915
  -113.763    29.790
>
  -114.404    29.830
  -113.690    29.893
>
  -113.562    28.944
  -113.690    29.893
>
  -113.562    28.944
  -113.690    29.893
>
  -114.404    29.830
  -113.769    29.834
>
  -114.404    29.830
  -113.769    29.834
>
  -113.562    28.944
  -113.769    29.834
>
  -113.562    28.944
  -113.769    29.834
>
  -113.562    28.944
  -113.769    29.834
>
  -113.562    28.944
  -113.769    29.834
>
  -112.694    29.915
  -113.769    29.834
>
  -112.694    29.915
  -113.769    29.834
>
  -113.633    31.335
  -114.080    30.586
>
  -113.633    31.335
  -114.080    30.586
>
  -114.404    29.830
  -114.080    30.586
>
  -114.404    29.830
  -114.080    30.586
>
  -114.404    29.830
  -113.785    30.155
>
  -114.404    29.830
  -113.785    30.155
>
  -112.694    29.915
  -113.785    30.155
>
  -112.694    29.915
  -113.785    30.155
>
  -114.404    29.830
  -113.728    30.135
>
  -114.404    29.830
  -113.728    30.135
>
  -112.694    29.915
  -113.728    30.135
>
  -112.694    29.915
  -113.728    30.135
>
  -114.404    29.830
  -113.694    30.149
>
  -114.404    29.830
  -113.694    30.149
>
  -114.404    29.830
  -113.741    30.141
>
  -114.404    29.830
  -113.741    30.141
>
  -112.694    29.915
  -113.741    30.141
>
  -112.694    29.915
  -113.741    30.141
>
  -114.404    29.830
  -113.712    29.962
>
  -114.404    29.830
  -113.712    29.962
>
  -112.694    29.915
  -113.712    29.962
>
  -112.694    29.915
  -113.712    29.962
>
  -113.633    31.335
  -114.172    30.733
>
  -113.633    31.335
  -114.172    30.733
>
  -114.404    29.830
  -114.172    30.733
>
  -114.404    29.830
  -114.172    30.733
>
  -114.404    29.830
  -113.931    30.452
>
  -114.404    29.830
  -113.931    30.452
>
  -113.633    31.335
  -113.931    30.452
>
  -113.633    31.335
  -113.931    30.452
>
  -114.404    29.830
  -113.927    30.438
>
  -114.404    29.830
  -113.927    30.438
>
  -113.633    31.335
  -113.927    30.438
>
  -113.633    31.335
  -113.927    30.438
>
  -114.404    29.830
  -113.736    30.147
>
  -114.404    29.830
  -113.736    30.147
>
  -114.404    29.830
  -113.736    30.147
>
  -112.694    29.915
  -113.736    30.147
>
  -112.694    29.915
  -113.736    30.147
>
  -114.404    29.830
  -113.740    30.102
>
  -114.404    29.830
  -113.740    30.102
>
  -112.694    29.915
  -113.740    30.102
>
  -112.694    29.915
  -113.740    30.102
>
  -114.404    29.830
  -113.768    30.130
>
  -114.404    29.830
  -113.768    30.130
>
  -112.694    29.915
  -113.768    30.130
>
  -112.694    29.915
  -113.768    30.130
>
  -113.633    31.335
  -113.925    30.598
>
  -113.633    31.335
  -113.925    30.598
>
  -114.404    29.830
  -113.925    30.598
>
  -114.404    29.830
  -113.925    30.598
>
  -114.404    29.830
  -113.948    30.449
>
  -114.404    29.830
  -113.948    30.449
>
  -113.633    31.335
  -113.948    30.449
>
  -113.633    31.335
  -113.948    30.449
>
  -113.633    31.335
  -113.948    30.449
>
  -113.633    31.335
  -113.929    30.436
>
  -113.633    31.335
  -113.929    30.436
>
  -114.404    29.830
  -113.929    30.436
>
  -114.404    29.830
  -113.929    30.436
>
  -114.404    29.830
  -113.889    30.430
>
  -114.404    29.830
  -113.889    30.430
>
  -113.633    31.335
  -113.889    30.430
>
  -113.633    31.335
  -113.889    30.430
>
  -114.404    29.830
  -113.724    30.050
>
  -114.404    29.830
  -113.724    30.050
>
  -112.694    29.915
  -113.724    30.050
>
  -112.694    29.915
  -113.724    30.050
>
  -114.404    29.830
  -113.737    30.100
>
  -114.404    29.830
  -113.737    30.100
>
  -112.694    29.915
  -113.737    30.100
>
  -112.694    29.915
  -113.737    30.100
>
  -114.404    29.830
  -113.754    30.028
>
  -114.404    29.830
  -113.754    30.028
>
  -112.694    29.915
  -113.754    30.028
>
  -112.694    29.915
  -113.754    30.028
>
  -114.404    29.830
  -113.753    30.112
>
  -114.404    29.830
  -113.753    30.112
>
  -114.404    29.830
  -113.753    30.112
>
  -112.694    29.915
  -113.753    30.112
>
  -112.694    29.915
  -113.753    30.112
>
  -114.404    29.830
  -113.764    30.080
>
  -114.404    29.830
  -113.764    30.080
>
  -112.694    29.915
  -113.764    30.080
>
  -112.694    29.915
  -113.764    30.080
>
  -114.404    29.830
  -113.766    30.090
>
  -114.404    29.830
  -113.766    30.090
>
  -112.694    29.915
  -113.766    30.090
>
  -112.694    29.915
  -113.766    30.090
>
  -114.404    29.830
  -113.728    30.165
>
  -114.404    29.830
  -113.728    30.165
>
  -112.694    29.915
  -113.728    30.165
>
  -112.694    29.915
  -113.728    30.165
>
  -114.404    29.830
  -113.737    30.175
>
  -114.404    29.830
  -113.737    30.175
>
  -112.694    29.915
  -113.737    30.175
>
  -112.694    29.915
  -113.737    30.175
>
  -113.633    31.335
  -114.174    30.730
>
  -113.633    31.335
  -114.174    30.730
>
  -114.404    29.830
  -114.174    30.730
>
  -114.404    29.830
  -114.174    30.730
>
  -114.404    29.830
  -113.930    30.445
>
  -114.404    29.830
  -113.930    30.445
>
  -113.633    31.335
  -113.930    30.445
>
  -113.633    31.335
  -113.930    30.445
>
  -114.404    29.830
  -114.197    30.591
>
  -114.404    29.830
  -114.197    30.591
>
  -113.633    31.335
  -114.197    30.591
>
  -113.633    31.335
  -114.197    30.591
>
  -114.745    31.960
  -114.363    31.502
>
  -114.745    31.960
  -114.363    31.502
>
  -115.051    31.472
  -114.363    31.502
>
  -115.051    31.472
  -114.363    31.502
>
  -115.051    31.472
  -114.363    31.502
>
  -115.051    31.472
  -114.363    31.502
>
  -113.633    31.335
  -114.363    31.502
>
  -113.633    31.335
  -114.363    31.502
>
  -113.460    31.560
  -114.363    31.502
>
  -113.460    31.560
  -114.363    31.502
>
  -113.460    31.560
  -114.363    31.502
>
  -113.460    31.560
  -114.363    31.502
>
  -114.961    32.166
  -114.363    31.502
>
  -114.961    32.166
  -114.363    31.502
>
  -114.705    32.458
  -114.363    31.502
>
  -114.705    32.458
  -114.363    31.502
>
  -114.404    29.830
  -114.393    30.072
>
  -114.404    29.830
  -114.393    30.072
>
  -114.404    29.830
  -114.065    30.606
>
  -114.404    29.830
  -114.065    30.606
>
  -113.633    31.335
  -114.065    30.606
>
  -113.633    31.335
  -114.065    30.606
>
  -113.633    31.335
  -114.085    30.608
>
  -113.633    31.335
  -114.085    30.608
>
  -113.633    31.335
  -114.085    30.608
>
  -114.404    29.830
  -114.085    30.608
>
  -114.404    29.830
  -114.085    30.608
>
  -114.745    31.960
  -114.395    31.523
>
  -114.745    31.959
  -114.395    31.523
>
  -114.745    31.959
  -114.395    31.523
>
  -115.052    31.472
  -114.395    31.523
>
  -115.052    31.472
  -114.395    31.523
>
  -115.051    31.472
  -114.395    31.523
>
  -115.051    31.472
  -114.395    31.523
>
  -113.633    31.335
  -114.395    31.523
>
  -113.633    31.335
  -114.395    31.523
>
  -113.633    31.335
  -114.395    31.523
>
  -114.961    32.166
  -114.395    31.523
>
  -114.961    32.166
  -114.395    31.523
>
  -114.961    32.166
  -114.395    31.523
>
  -114.961    32.166
  -114.395    31.523
>
  -113.460    31.560
  -114.395    31.523
>
  -113.460    31.560
  -114.395    31.523
>
  -113.460    31.560
  -114.395    31.523
>
  -113.460    31.560
  -114.395    31.523
>
  -115.284    32.135
  -114.395    31.523
>
  -115.284    32.135
  -114.395    31.523
>
  -115.076    32.303
  -114.395    31.523
>
  -115.076    32.303
  -114.395    31.523
>
  -115.076    32.303
  -114.395    31.523
>
  -115.076    32.303
  -114.395    31.523
>
  -114.705    32.458
  -114.395    31.523
>
  -114.705    32.458
  -114.395    31.523
>
  -115.161    32.266
  -114.395    31.523
>
  -115.161    32.266
  -114.395    31.523
>
  -114.745    31.959
  -114.413    31.548
>
  -114.745    31.959
  -114.413    31.548
>
  -115.052    31.472
  -114.413    31.548
>
  -115.052    31.472
  -114.413    31.548
>
  -115.051    31.472
  -114.413    31.548
>
  -115.051    31.472
  -114.413    31.548
>
  -113.633    31.335
  -114.413    31.548
>
  -113.633    31.335
  -114.413    31.548
>
  -113.633    31.335
  -114.413    31.548
>
  -113.460    31.560
  -114.413    31.548
>
  -113.460    31.560
  -114.413    31.548
>
  -113.460    31.560
  -114.413    31.548
>
  -114.705    32.458
  -114.413    31.548
>
  -114.705    32.458
  -114.413    31.548
>
  -114.705    32.458
  -114.413    31.548
>
  -115.076    32.303
  -114.413    31.548
>
  -115.284    32.135
  -114.413    31.548
>
  -115.284    32.135
  -114.413    31.548
>
  -115.161    32.266
  -114.413    31.548
>
  -115.161    32.266
  -114.413    31.548
>
  -115.161    32.266
  -114.413    31.548
>
  -113.633    31.335
  -114.331    31.526
>
  -114.745    31.959
  -114.331    31.526
>
  -114.745    31.959
  -114.331    31.526
>
  -115.052    31.472
  -114.331    31.526
>
  -115.052    31.472
  -114.331    31.526
>
  -115.051    31.472
  -114.331    31.526
>
  -115.051    31.472
  -114.331    31.526
>
  -113.460    31.560
  -114.331    31.526
>
  -114.745    31.959
  -114.364    31.544
>
  -113.633    31.335
  -114.364    31.544
>
  -115.052    31.472
  -114.364    31.544
>
  -115.052    31.472
  -114.364    31.544
>
  -115.051    31.472
  -114.364    31.544
>
  -115.051    31.472
  -114.364    31.544
>
  -113.460    31.560
  -114.364    31.544
>
  -114.745    31.959
  -114.393    31.524
>
  -114.745    31.959
  -114.393    31.524
>
  -114.745    31.960
  -114.393    31.524
>
  -115.052    31.472
  -114.393    31.524
>
  -115.052    31.472
  -114.393    31.524
>
  -115.051    31.472
  -114.393    31.524
>
  -115.051    31.472
  -114.393    31.524
>
  -115.051    31.472
  -114.393    31.524
>
  -113.633    31.335
  -114.393    31.524
>
  -113.633    31.335
  -114.393    31.524
>
  -114.961    32.166
  -114.393    31.524
>
  -114.961    32.166
  -114.393    31.524
>
  -114.961    32.166
  -114.393    31.524
>
  -113.460    31.560
  -114.393    31.524
>
  -113.460    31.560
  -114.393    31.524
>
  -113.460    31.560
  -114.393    31.524
>
  -113.460    31.560
  -114.393    31.524
>
  -115.076    32.303
  -114.393    31.524
>
  -115.076    32.303
  -114.393    31.524
>
  -114.705    32.458
  -114.393    31.524
>
  -114.705    32.458
  -114.393    31.524
>
  -114.705    32.458
  -114.393    31.524
>
  -114.705    32.458
  -114.393    31.524
>
  -115.161    32.266
  -114.393    31.524
>
  -115.161    32.266
  -114.393    31.524
>
  -114.745    31.959
  -114.388    31.553
>
  -114.745    31.959
  -114.388    31.553
>
  -114.745    31.960
  -114.388    31.553
>
  -115.051    31.472
  -114.388    31.553
>
  -115.051    31.472
  -114.388    31.553
>
  -115.051    31.472
  -114.388    31.553
>
  -115.052    31.472
  -114.388    31.553
>
  -115.052    31.472
  -114.388    31.553
>
  -113.633    31.335
  -114.388    31.553
>
  -113.633    31.335
  -114.388    31.553
>
  -113.633    31.335
  -114.388    31.553
>
  -113.460    31.560
  -114.388    31.553
>
  -113.460    31.560
  -114.388    31.553
>
  -113.460    31.560
  -114.388    31.553
>
  -113.460    31.560
  -114.388    31.553
>
  -113.460    31.560
  -114.388    31.553
>
  -115.284    32.135
  -114.388    31.553
>
  -115.284    32.135
  -114.388    31.553
>
  -115.161    32.266
  -114.388    31.553
>
  -115.052    31.472
  -114.425    31.599
>
  -115.052    31.472
  -114.425    31.599
>
  -115.051    31.472
  -114.425    31.599
>
  -115.051    31.472
  -114.425    31.599
>
  -115.051    31.472
  -114.425    31.599
>
  -113.633    31.335
  -114.425    31.599
>
  -113.633    31.335
  -114.425    31.599
>
  -113.633    31.335
  -114.425    31.599
>
  -113.460    31.560
  -114.425    31.599
>
  -113.460    31.560
  -114.425    31.599
>
  -113.460    31.560
  -114.425    31.599
>
  -113.460    31.560
  -114.425    31.599
>
  -114.705    32.458
  -114.425    31.599
>
  -114.705    32.458
  -114.425    31.599
>
  -115.076    32.303
  -114.425    31.599
>
  -115.284    32.135
  -114.425    31.599
>
  -114.964    32.433
  -114.425    31.599
>
  -114.964    32.433
  -114.425    31.599
>
  -114.356    32.584
  -114.425    31.599
>
  -114.356    32.584
  -114.425    31.599
>
  -115.052    31.472
  -114.412    31.584
>
  -115.052    31.472
  -114.412    31.584
>
  -115.051    31.472
  -114.412    31.584
>
  -115.051    31.472
  -114.412    31.584
>
  -113.633    31.335
  -114.412    31.584
>
  -113.633    31.335
  -114.412    31.584
>
  -113.460    31.560
  -114.412    31.584
>
  -113.460    31.560
  -114.412    31.584
>
  -113.460    31.560
  -114.412    31.584
>
  -115.284    32.135
  -114.412    31.584
>
  -115.284    32.135
  -114.412    31.584
>
  -115.284    32.135
  -114.412    31.584
>
  -114.356    32.584
  -114.412    31.584
>
  -114.356    32.584
  -114.412    31.584
>
  -114.745    31.959
  -114.397    31.555
>
  -114.745    31.959
  -114.397    31.555
>
  -114.745    31.959
  -114.397    31.555
>
  -115.051    31.472
  -114.397    31.555
>
  -115.051    31.472
  -114.397    31.555
>
  -115.052    31.472
  -114.397    31.555
>
  -115.052    31.472
  -114.397    31.555
>
  -113.633    31.335
  -114.397    31.555
>
  -113.633    31.335
  -114.397    31.555
>
  -113.633    31.335
  -114.397    31.555
>
  -113.460    31.560
  -114.397    31.555
>
  -113.460    31.560
  -114.397    31.555
>
  -113.460    31.560
  -114.397    31.555
>
  -113.460    31.560
  -114.397    31.555
>
  -115.076    32.303
  -114.397    31.555
>
  -115.284    32.135
  -114.397    31.555
>
  -115.284    32.135
  -114.397    31.555
>
  -115.284    32.135
  -114.397    31.555
>
  -113.633    31.335
  -114.061    30.627
>
  -113.633    31.335
  -114.061    30.627
>
  -113.633    31.335
  -114.234    31.362
>
  -113.633    31.335
  -114.234    31.362
>
  -113.460    31.560
  -114.234    31.362
>
  -113.460    31.560
  -114.234    31.362
>
  -113.460    31.560
  -114.234    31.362
>
  -115.051    31.472
  -114.234    31.362
>
  -115.051    31.472
  -114.234    31.362
>
  -114.745    31.959
  -114.234    31.362
>
  -114.745    31.959
  -114.438    31.653
>
  -114.745    31.959
  -114.438    31.653
>
  -114.745    31.959
  -114.438    31.653
>
  -115.051    31.472
  -114.438    31.653
>
  -115.051    31.472
  -114.438    31.653
>
  -113.633    31.335
  -114.438    31.653
>
  -113.633    31.335
  -114.438    31.653
>
  -114.961    32.166
  -114.438    31.653
>
  -113.460    31.560
  -114.438    31.653
>
  -113.460    31.560
  -114.438    31.653
>
  -114.705    32.458
  -114.438    31.653
>
  -114.705    32.458
  -114.438    31.653
>
  -115.076    32.303
  -114.438    31.653
>
  -115.161    32.266
  -114.438    31.653
>
  -115.161    32.266
  -114.438    31.653
>
  -114.356    32.584
  -114.438    31.653
>
  -114.356    32.584
  -114.438    31.653
>
  -115.198    32.407
  -114.438    31.653
>
  -115.198    32.407
  -114.438    31.653
>
  -113.633    31.335
  -114.326    31.310
>
  -113.633    31.335
  -114.326    31.310
>
  -113.633    31.335
  -114.326    31.310
>
  -115.052    31.472
  -114.326    31.310
>
  -115.052    31.472
  -114.326    31.310
>
  -115.051    31.472
  -114.326    31.310
>
  -115.051    31.472
  -114.326    31.310
>
  -115.051    31.472
  -114.326    31.310
>
  -114.745    31.959
  -114.326    31.310
>
  -113.460    31.560
  -114.326    31.310
>
  -113.460    31.560
  -114.326    31.310
>
  -113.460    31.560
  -114.326    31.310
>
  -115.051    31.472
  -114.335    31.324
>
  -115.051    31.472
  -114.335    31.324
>
  -115.051    31.472
  -114.335    31.324
>
  -115.051    31.472
  -114.335    31.324
>
  -113.633    31.335
  -114.335    31.324
>
  -113.633    31.335
  -114.335    31.324
>
  -114.745    31.959
  -114.335    31.324
>
  -114.745    31.959
  -114.335    31.324
>
  -113.460    31.560
  -114.335    31.324
>
  -113.460    31.560
  -114.335    31.324
>
  -113.633    31.335
  -114.315    31.301
>
  -115.052    31.472
  -114.315    31.301
>
  -115.052    31.472
  -114.315    31.301
>
  -115.051    31.472
  -114.315    31.301
>
  -115.051    31.472
  -114.315    31.301
>
  -115.051    31.472
  -114.315    31.301
>
  -115.051    31.472
  -114.315    31.301
>
  -113.460    31.560
  -114.315    31.301
>
  -113.460    31.560
  -114.315    31.301
>
  -113.633    31.335
  -114.317    31.281
>
  -113.633    31.335
  -114.317    31.281
>
  -113.633    31.335
  -114.317    31.281
>
  -115.052    31.472
  -114.317    31.281
>
  -115.052    31.472
  -114.317    31.281
>
  -115.051    31.472
  -114.317    31.281
>
  -115.051    31.472
  -114.317    31.281
>
  -115.051    31.472
  -114.317    31.281
>
  -113.460    31.560
  -114.317    31.281
>
  -113.460    31.560
  -114.317    31.281
>
  -113.460    31.560
  -114.317    31.281
>
  -113.460    31.560
  -114.317    31.281
>
  -114.745    31.960
  -114.317    31.281
>
  -114.745    31.960
  -114.317    31.281
>
  -114.745    31.959
  -114.317    31.281
>
  -114.745    31.959
  -114.317    31.281
>
  -113.633    31.335
  -114.257    31.414
>
  -113.633    31.335
  -114.257    31.414
>
  -113.633    31.335
  -114.257    31.414
>
  -115.051    31.472
  -114.257    31.414
>
  -115.051    31.472
  -114.257    31.414
>
  -115.052    31.472
  -114.257    31.414
>
  -115.052    31.472
  -114.257    31.414
>
  -113.460    31.560
  -114.257    31.414
>
  -113.460    31.560
  -114.257    31.414
>
  -114.745    31.960
  -114.257    31.414
>
  -114.745    31.960
  -114.257    31.414
>
  -114.745    31.959
  -114.257    31.414
>
  -114.745    31.959
  -114.257    31.414
>
  -114.961    32.166
  -114.257    31.414
>
  -113.633    31.335
  -114.348    31.415
>
  -113.633    31.335
  -114.348    31.415
>
  -113.633    31.335
  -114.348    31.415
>
  -113.633    31.335
  -114.348    31.415
>
  -115.052    31.472
  -114.348    31.415
>
  -115.052    31.472
  -114.348    31.415
>
  -115.051    31.472
  -114.348    31.415
>
  -115.051    31.472
  -114.348    31.415
>
  -115.051    31.472
  -114.348    31.415
>
  -114.745    31.960
  -114.348    31.415
>
  -114.745    31.959
  -114.348    31.415
>
  -113.460    31.560
  -114.348    31.415
>
  -113.460    31.560
  -114.348    31.415
>
  -113.460    31.560
  -114.348    31.415
>
  -114.961    32.166
  -114.348    31.415
>
  -114.745    31.959
  -114.349    31.435
>
  -114.745    31.959
  -114.349    31.435
>
  -115.051    31.472
  -114.349    31.435
>
  -115.051    31.472
  -114.349    31.435
>
  -115.051    31.472
  -114.349    31.435
>
  -115.051    31.472
  -114.349    31.435
>
  -115.052    31.472
  -114.349    31.435
>
  -115.052    31.472
  -114.349    31.435
>
  -113.633    31.335
  -114.349    31.435
>
  -113.633    31.335
  -114.349    31.435
>
  -113.633    31.335
  -114.349    31.435
>
  -113.460    31.560
  -114.349    31.435
>
  -113.460    31.560
  -114.349    31.435
>
  -113.460    31.560
  -114.349    31.435
>
  -113.460    31.560
  -114.349    31.435
>
  -114.961    32.166
  -114.349    31.435
>
  -114.404    29.830
  -114.540    30.158
>
  -114.404    29.830
  -114.540    30.158
>
  -114.404    29.830
  -114.540    30.158
>
  -114.745    31.960
  -114.351    31.432
>
  -114.745    31.959
  -114.351    31.432
>
  -114.745    31.959
  -114.351    31.432
>
  -115.052    31.472
  -114.351    31.432
>
  -115.052    31.472
  -114.351    31.432
>
  -115.051    31.472
  -114.351    31.432
>
  -115.051    31.472
  -114.351    31.432
>
  -115.051    31.472
  -114.351    31.432
>
  -115.051    31.472
  -114.351    31.432
>
  -113.633    31.335
  -114.351    31.432
>
  -113.633    31.335
  -114.351    31.432
>
  -113.633    31.335
  -114.351    31.432
>
  -113.633    31.335
  -114.351    31.432
>
  -113.460    31.560
  -114.351    31.432
>
  -113.460    31.560
  -114.351    31.432
>
  -113.460    31.560
  -114.351    31.432
>
  -114.961    32.166
  -114.351    31.432
>
  -114.404    29.830
  -114.480    30.195
>
  -114.404    29.830
  -114.480    30.195
>
  -114.404    29.830
  -114.480    30.195
>
  -115.051    31.472
  -114.352    31.391
>
  -115.051    31.472
  -114.352    31.391
>
  -115.051    31.472
  -114.352    31.391
>
  -113.633    31.335
  -114.352    31.391
>
  -113.633    31.335
  -114.352    31.391
>
  -114.745    31.959
  -114.352    31.391
>
  -113.460    31.560
  -114.352    31.391
>
  -113.460    31.560
  -114.352    31.391
>
  -115.052    31.472
  -114.337    31.381
>
  -115.052    31.472
  -114.337    31.381
>
  -115.051    31.472
  -114.337    31.381
>
  -115.051    31.472
  -114.337    31.381
>
  -115.051    31.472
  -114.337    31.381
>
  -113.633    31.335
  -114.337    31.381
>
  -113.633    31.335
  -114.337    31.381
>
  -113.460    31.560
  -114.337    31.381
>
  -113.460    31.560
  -114.337    31.381
>
  -113.460    31.560
  -114.337    31.381
>
  -113.633    31.335
  -114.332    31.414
>
  -113.633    31.335
  -114.332    31.414
>
  -113.460    31.560
  -114.332    31.414
>
  -113.460    31.560
  -114.332    31.414
>
  -113.460    31.560
  -114.332    31.414
>
  -114.745    31.959
  -114.332    31.414
>
  -114.745    31.959
  -114.332    31.414
>
  -114.745    31.960
  -114.332    31.414
>
  -115.052    31.472
  -114.332    31.414
>
  -115.052    31.472
  -114.332    31.414
>
  -115.051    31.472
  -114.332    31.414
>
  -115.051    31.472
  -114.332    31.414
>
  -115.051    31.472
  -114.332    31.414
>
  -113.633    31.335
  -114.329    31.387
>
  -113.633    31.335
  -114.329    31.387
>
  -113.633    31.335
  -114.329    31.387
>
  -113.633    31.335
  -114.329    31.387
>
  -115.052    31.472
  -114.329    31.387
>
  -115.052    31.472
  -114.329    31.387
>
  -115.051    31.472
  -114.329    31.387
>
  -115.051    31.472
  -114.329    31.387
>
  -114.745    31.959
  -114.329    31.387
>
  -114.745    31.959
  -114.329    31.387
>
  -113.460    31.560
  -114.329    31.387
>
  -113.460    31.560
  -114.329    31.387
>
  -113.460    31.560
  -114.329    31.387
>
  -113.460    31.560
  -114.329    31.387
>
  -113.633    31.335
  -114.305    31.396
>
  -113.633    31.335
  -114.305    31.396
>
  -113.633    31.335
  -114.305    31.396
>
  -115.051    31.472
  -114.305    31.396
>
  -115.051    31.472
  -114.305    31.396
>
  -115.051    31.472
  -114.305    31.396
>
  -115.051    31.472
  -114.305    31.396
>
  -114.745    31.959
  -114.305    31.396
>
  -114.745    31.959
  -114.305    31.396
>
  -113.460    31.560
  -114.305    31.396
>
  -113.460    31.560
  -114.305    31.396
>
  -114.404    29.830
  -113.932    30.378
>
  -114.404    29.830
  -113.932    30.378
>
  -113.633    31.335
  -113.932    30.378
>
  -113.633    31.335
  -113.932    30.378
>
  -114.745    31.959
  -114.378    31.517
>
  -114.745    31.959
  -114.378    31.517
>
  -114.745    31.960
  -114.378    31.517
>
  -115.052    31.472
  -114.378    31.517
>
  -115.051    31.472
  -114.378    31.517
>
  -115.051    31.472
  -114.378    31.517
>
  -114.961    32.166
  -114.378    31.517
>
  -114.961    32.166
  -114.378    31.517
>
  -113.460    31.560
  -114.378    31.517
>
  -113.460    31.560
  -114.378    31.517
>
  -114.705    32.458
  -114.378    31.517
>
  -114.705    32.458
  -114.378    31.517
>
  -115.076    32.303
  -114.378    31.517
>
  -115.076    32.303
  -114.378    31.517
>
  -115.076    32.303
  -114.378    31.517
>
  -114.745    31.960
  -114.545    31.632
>
  -114.745    31.959
  -114.545    31.632
>
  -114.745    31.959
  -114.545    31.632
>
  -115.052    31.472
  -114.545    31.632
>
  -115.052    31.472
  -114.545    31.632
>
  -115.051    31.472
  -114.545    31.632
>
  -115.051    31.472
  -114.545    31.632
>
  -115.051    31.472
  -114.545    31.632
>
  -114.961    32.166
  -114.545    31.632
>
  -114.961    32.166
  -114.545    31.632
>
  -114.961    32.166
  -114.545    31.632
>
  -113.460    31.560
  -114.545    31.632
>
  -113.460    31.560
  -114.545    31.632
>
  -113.460    31.560
  -114.545    31.632
>
  -114.705    32.458
  -114.545    31.632
>
  -114.705    32.458
  -114.545    31.632
>
  -115.076    32.303
  -114.545    31.632
>
  -115.161    32.266
  -114.545    31.632
>
  -115.161    32.266
  -114.545    31.632
>
  -114.356    32.584
  -114.545    31.632
>
  -114.356    32.584
  -114.545    31.632
>
  -115.109    32.448
  -114.545    31.632
>
  -115.198    32.407
  -114.545    31.632
>
  -115.466    31.046
  -114.545    31.632
>
  -115.466    31.046
  -114.545    31.632
>
  -115.466    31.046
  -114.545    31.632
>
  -114.745    31.959
  -114.545    31.639
>
  -114.745    31.959
  -114.545    31.639
>
  -114.745    31.960
  -114.545    31.639
>
  -114.745    31.960
  -114.545    31.639
>
  -115.052    31.472
  -114.545    31.639
>
  -115.052    31.472
  -114.545    31.639
>
  -115.051    31.472
  -114.545    31.639
>
  -115.051    31.472
  -114.545    31.639
>
  -115.051    31.472
  -114.545    31.639
>
  -114.961    32.166
  -114.545    31.639
>
  -114.961    32.166
  -114.545    31.639
>
  -115.076    32.303
  -114.545    31.639
>
  -115.076    32.303
  -114.545    31.639
>
  -114.705    32.458
  -114.545    31.639
>
  -114.705    32.458
  -114.545    31.639
>
  -114.705    32.458
  -114.545    31.639
>
  -115.161    32.266
  -114.545    31.639
>
  -115.161    32.266
  -114.545    31.639
>
  -113.460    31.560
  -114.545    31.639
>
  -113.460    31.560
  -114.545    31.639
>
  -113.460    31.560
  -114.545    31.639
>
  -114.356    32.584
  -114.545    31.639
>
  -114.356    32.584
  -114.545    31.639
>
  -115.466    31.046
  -114.545    31.639
>
  -115.466    31.046
  -114.545    31.639
>
  -115.466    31.046
  -114.545    31.639
>
  -115.466    31.046
  -114.545    31.639
>
  -115.051    31.472
  -115.040    31.708
>
  -115.051    31.472
  -115.040    31.708
>
  -114.745    31.960
  -115.040    31.708
>
  -114.745    31.959
  -115.040    31.708
>
  -114.745    31.959
  -115.040    31.708
>
  -114.961    32.166
  -115.040    31.708
>
  -114.961    32.166
  -115.040    31.708
>
  -115.161    32.266
  -115.040    31.708
>
  -115.161    32.266
  -115.040    31.708
>
  -115.161    32.266
  -115.040    31.708
>
  -115.076    32.303
  -115.040    31.708
>
  -115.708    32.007
  -115.040    31.708
>
  -115.708    32.007
  -115.040    31.708
>
  -115.466    31.046
  -115.040    31.708
>
  -115.466    31.046
  -115.040    31.708
>
  -114.964    32.433
  -115.040    31.708
>
  -114.964    32.433
  -115.040    31.708
>
  -115.109    32.448
  -115.040    31.708
>
  -115.109    32.448
  -115.040    31.708
>
  -115.304    32.418
  -115.040    31.708
>
  -115.304    32.418
  -115.040    31.708
>
  -115.305    32.420
  -115.040    31.708
>
  -115.305    32.420
  -115.040    31.708
>
  -115.959    31.763
  -115.040    31.708
>
  -115.959    31.763
  -115.040    31.708
>
  -115.959    31.763
  -115.040    31.708
>
  -115.959    31.763
  -115.040    31.708
>
  -115.581    32.537
  -115.040    31.708
>
  -115.581    32.537
  -115.040    31.708
>
  -115.581    32.537
  -115.040    31.708
>
  -115.051    31.472
  -114.995    31.705
>
  -115.051    31.472
  -114.995    31.705
>
  -115.052    31.472
  -114.995    31.705
>
  -115.052    31.472
  -114.995    31.705
>
  -114.745    31.960
  -114.995    31.705
>
  -115.076    32.303
  -114.995    31.705
>
  -114.964    32.433
  -114.995    31.705
>
  -114.964    32.433
  -114.995    31.705
>
  -115.305    32.420
  -114.995    31.705
>
  -115.466    31.046
  -114.995    31.705
>
  -115.466    31.046
  -114.995    31.705
>
  -115.959    31.763
  -114.995    31.705
>
  -115.959    31.763
  -114.995    31.705
>
  -115.959    31.763
  -114.995    31.705
>
  -115.959    31.763
  -114.995    31.705
>
  -115.959    31.763
  -114.995    31.705
>
  -115.581    32.537
  -114.995    31.705
>
  -114.745    31.960
  -114.526    31.620
>
  -114.745    31.960
  -114.526    31.620
>
  -114.745    31.959
  -114.526    31.620
>
  -115.051    31.472
  -114.526    31.620
>
  -115.051    31.472
  -114.526    31.620
>
  -115.052    31.472
  -114.526    31.620
>
  -115.052    31.472
  -114.526    31.620
>
  -114.961    32.166
  -114.526    31.620
>
  -114.961    32.166
  -114.526    31.620
>
  -114.961    32.166
  -114.526    31.620
>
  -115.076    32.303
  -114.526    31.620
>
  -115.076    32.303
  -114.526    31.620
>
  -115.161    32.266
  -114.526    31.620
>
  -115.161    32.266
  -114.526    31.620
>
  -115.161    32.266
  -114.526    31.620
>
  -114.705    32.458
  -114.526    31.620
>
  -114.705    32.458
  -114.526    31.620
>
  -114.705    32.458
  -114.526    31.620
>
  -114.705    32.458
  -114.526    31.620
>
  -114.964    32.433
  -114.526    31.620
>
  -114.964    32.433
  -114.526    31.620
>
  -115.198    32.407
  -114.526    31.620
>
  -115.198    32.407
  -114.526    31.620
>
  -114.356    32.584
  -114.526    31.620
>
  -114.356    32.584
  -114.526    31.620
>
  -113.460    31.560
  -114.526    31.620
>
  -113.460    31.560
  -114.526    31.620
>
  -113.460    31.560
  -114.526    31.620
>
  -115.466    31.046
  -114.526    31.620
>
  -115.466    31.046
  -114.526    31.620
>
  -115.466    31.046
  -114.526    31.620
>
  -115.466    31.046
  -114.526    31.620
>
  -114.745    31.959
  -114.527    31.628
>
  -114.745    31.959
  -114.527    31.628
>
  -115.052    31.472
  -114.527    31.628
>
  -115.052    31.472
  -114.527    31.628
>
  -115.051    31.472
  -114.527    31.628
>
  -115.051    31.472
  -114.527    31.628
>
  -114.961    32.166
  -114.527    31.628
>
  -114.961    32.166
  -114.527    31.628
>
  -115.076    32.303
  -114.527    31.628
>
  -114.705    32.458
  -114.527    31.628
>
  -114.705    32.458
  -114.527    31.628
>
  -115.161    32.266
  -114.527    31.628
>
  -115.161    32.266
  -114.527    31.628
>
  -114.964    32.433
  -114.527    31.628
>
  -114.964    32.433
  -114.527    31.628
>
  -114.356    32.584
  -114.527    31.628
>
  -114.356    32.584
  -114.527    31.628
>
  -114.356    32.584
  -114.527    31.628
>
  -115.109    32.448
  -114.527    31.628
>
  -115.109    32.448
  -114.527    31.628
>
  -115.109    32.448
  -114.527    31.628
>
  -113.460    31.560
  -114.527    31.628
>
  -113.460    31.560
  -114.527    31.628
>
  -113.460    31.560
  -114.527    31.628
>
  -113.460    31.560
  -114.527    31.628
>
  -115.198    32.407
  -114.527    31.628
>
  -115.198    32.407
  -114.527    31.628
>
  -115.466    31.046
  -114.527    31.628
>
  -115.466    31.046
  -114.527    31.628
>
  -115.466    31.046
  -114.527    31.628
>
  -115.466    31.046
  -114.527    31.628
>
  -115.051    31.472
  -114.501    31.631
>
  -115.051    31.472
  -114.501    31.631
>
  -115.051    31.472
  -114.501    31.631
>
  -115.076    32.303
  -114.501    31.631
>
  -115.076    32.303
  -114.501    31.631
>
  -115.161    32.266
  -114.501    31.631
>
  -115.161    32.266
  -114.501    31.631
>
  -114.705    32.458
  -114.501    31.631
>
  -114.705    32.458
  -114.501    31.631
>
  -114.964    32.433
  -114.501    31.631
>
  -114.964    32.433
  -114.501    31.631
>
  -114.964    32.433
  -114.501    31.631
>
  -114.964    32.433
  -114.501    31.631
>
  -115.109    32.448
  -114.501    31.631
>
  -115.109    32.448
  -114.501    31.631
>
  -115.198    32.407
  -114.501    31.631
>
  -113.460    31.560
  -114.501    31.631
>
  -113.460    31.560
  -114.501    31.631
>
  -114.356    32.584
  -114.501    31.631
>
  -114.356    32.584
  -114.501    31.631
>
  -114.745    31.960
  -114.454    31.626
>
  -114.745    31.960
  -114.454    31.626
>
  -114.745    31.959
  -114.454    31.626
>
  -114.745    31.959
  -114.454    31.626
>
  -114.745    31.959
  -114.454    31.626
>
  -115.051    31.472
  -114.454    31.626
>
  -115.051    31.472
  -114.454    31.626
>
  -115.052    31.472
  -114.454    31.626
>
  -115.052    31.472
  -114.454    31.626
>
  -114.961    32.166
  -114.454    31.626
>
  -114.961    32.166
  -114.454    31.626
>
  -114.961    32.166
  -114.454    31.626
>
  -115.076    32.303
  -114.454    31.626
>
  -115.076    32.303
  -114.454    31.626
>
  -115.076    32.303
  -114.454    31.626
>
  -115.076    32.303
  -114.454    31.626
>
  -115.161    32.266
  -114.454    31.626
>
  -115.161    32.266
  -114.454    31.626
>
  -114.705    32.458
  -114.454    31.626
>
  -114.705    32.458
  -114.454    31.626
>
  -113.460    31.560
  -114.454    31.626
>
  -114.964    32.433
  -114.454    31.626
>
  -114.964    32.433
  -114.454    31.626
>
  -115.109    32.448
  -114.454    31.626
>
  -114.356    32.584
  -114.454    31.626
>
  -114.356    32.584
  -114.454    31.626
>
  -114.745    31.960
  -114.539    31.651
>
  -115.076    32.303
  -114.539    31.651
>
  -115.161    32.266
  -114.539    31.651
>
  -115.161    32.266
  -114.539    31.651
>
  -115.161    32.266
  -114.539    31.651
>
  -113.460    31.560
  -114.539    31.651
>
  -113.460    31.560
  -114.539    31.651
>
  -113.460    31.560
  -114.539    31.651
>
  -113.460    31.560
  -114.539    31.651
>
  -114.356    32.584
  -114.539    31.651
>
  -114.356    32.584
  -114.539    31.651
>
  -115.466    31.046
  -114.539    31.651
>
  -115.466    31.046
  -114.539    31.651
>
  -115.466    31.046
  -114.539    31.651
>
  -114.745    31.960
  -114.514    31.638
>
  -114.745    31.960
  -114.514    31.638
>
  -114.745    31.959
  -114.514    31.638
>
  -114.745    31.959
  -114.514    31.638
>
  -115.052    31.472
  -114.514    31.638
>
  -115.052    31.472
  -114.514    31.638
>
  -115.051    31.472
  -114.514    31.638
>
  -115.051    31.472
  -114.514    31.638
>
  -114.961    32.166
  -114.514    31.638
>
  -115.076    32.303
  -114.514    31.638
>
  -115.161    32.266
  -114.514    31.638
>
  -114.705    32.458
  -114.514    31.638
>
  -113.460    31.560
  -114.514    31.638
>
  -113.460    31.560
  -114.514    31.638
>
  -113.460    31.560
  -114.514    31.638
>
  -113.460    31.560
  -114.514    31.638
>
  -114.356    32.584
  -114.514    31.638
>
  -114.356    32.584
  -114.514    31.638
>
  -113.460    31.560
  -114.258    31.319
>
  -113.460    31.560
  -114.258    31.319
>
  -114.745    31.959
  -114.258    31.319
>
  -114.745    31.959
  -114.258    31.319
>
  -114.745    31.960
  -114.258    31.319
>
  -115.051    31.472
  -114.258    31.319
>
  -115.051    31.472
  -114.258    31.319
>
  -115.051    31.472
  -114.258    31.319
>
  -114.404    29.830
  -114.149    30.760
>
  -114.404    29.830
  -114.149    30.760
>
  -113.633    31.335
  -114.149    30.760
>
  -113.633    31.335
  -114.149    30.760
>
  -113.633    31.335
  -114.149    30.760
>
  -113.633    31.335
  -114.326    31.489
>
  -113.633    31.335
  -114.326    31.489
>
  -113.633    31.335
  -114.326    31.489
>
  -114.745    31.960
  -114.326    31.489
>
  -114.745    31.960
  -114.326    31.489
>
  -114.745    31.959
  -114.326    31.489
>
  -114.745    31.959
  -114.326    31.489
>
  -115.051    31.472
  -114.326    31.489
>
  -115.051    31.472
  -114.326    31.489
>
  -115.051    31.472
  -114.326    31.489
>
  -114.961    32.166
  -114.326    31.489
>
  -115.051    31.472
  -114.328    31.502
>
  -115.051    31.472
  -114.328    31.502
>
  -113.633    31.335
  -114.328    31.502
>
  -113.633    31.335
  -114.328    31.502
>
  -113.633    31.335
  -114.328    31.502
>
  -114.745    31.959
  -114.328    31.502
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -115.051    31.472     0.300
  -115.242    31.988     0.300
  -115.466    31.046     0.300
  -115.464    31.045     0.300
  -115.198    32.407     0.300
  -115.304    32.418     0.300
  -114.545    32.555     0.300
  -115.076    32.303     0.300
  -113.460    31.560     0.300
  -113.633    31.335     0.300
  -114.705    32.458     0.300
  -115.284    32.135     0.300
  -114.404    29.830     0.300
  -115.876    30.576     0.300
  -115.161    32.266     0.300
  -114.745    31.959     0.300
  -113.562    28.944     0.300
  -114.961    32.166     0.300
  -114.964    32.433     0.300
  -115.145    32.473     0.300
  -114.745    31.960     0.300
  -112.694    29.915     0.300
  -114.356    32.584     0.300
  -115.052    31.472     0.300
  -115.109    32.448     0.300
  -115.708    32.007     0.300
  -115.109    32.448     0.300
  -115.305    32.420     0.300
  -115.959    31.763     0.300
  -115.581    32.537     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -114.407    31.491     0.200
>
  -114.336    31.522     0.200
>
  -114.300    31.441     0.200
>
  -114.286    31.443     0.200
>
  -114.285    31.467     0.200
>
  -114.443    31.621     0.200
>
  -114.402    31.603     0.200
>
  -114.741    31.599     0.200
>
  -114.171    29.897     0.200
>
  -113.964    30.645     0.200
>
  -113.970    30.578     0.200
>
  -114.501    31.674     0.200
>
  -114.050    30.369     0.200
>
  -114.114    30.308     0.200
>
  -114.255    30.475     0.200
>
  -114.161    30.444     0.200
>
  -114.533    31.719     0.200
>
  -114.317    30.192     0.200
>
  -114.290    30.189     0.200
>
  -114.198    30.574     0.200
>
  -114.340    31.500     0.200
>
  -114.392    31.558     0.200
>
  -114.277    30.158     0.200
>
  -114.794    30.768     0.200
>
  -114.256    30.117     0.200
>
  -114.184    30.940     0.200
>
  -114.230    31.038     0.200
>
  -114.179    30.928     0.200
>
  -114.108    30.892     0.200
>
  -113.863    30.378     0.200
>
  -114.347    31.281     0.200
>
  -114.339    31.215     0.200
>
  -114.343    31.388     0.200
>
  -114.417    31.567     0.200
>
  -114.310    31.248     0.200
>
  -114.084    30.744     0.200
>
  -113.838    30.279     0.200
>
  -113.992    29.675     0.200
>
  -114.228    30.196     0.200
>
  -114.117    30.204     0.200
>
  -114.086    30.622     0.200
>
  -114.128    30.693     0.200
>
  -114.497    31.484     0.200
>
  -114.499    31.493     0.200
>
  -114.488    31.474     0.200
>
  -114.526    31.520     0.200
>
  -114.162    29.873     0.200
>
  -114.170    29.822     0.200
>
  -114.479    31.627     0.200
>
  -114.265    31.255     0.200
>
  -114.102    30.193     0.200
>
  -114.384    31.658     0.200
>
  -114.209    30.816     0.200
>
  -114.193    30.774     0.200
>
  -114.562    31.678     0.200
>
  -114.553    31.741     0.200
>
  -114.160    29.853     0.200
>
  -114.398    31.510     0.200
>
  -114.571    31.524     0.200
>
  -113.900    29.706     0.200
>
  -113.924    30.004     0.200
>
  -113.985    30.052     0.200
>
  -113.931    30.009     0.200
>
  -114.362    31.503     0.200
>
  -114.053    29.906     0.200
>
  -114.054    29.976     0.200
>
  -114.184    30.764     0.200
>
  -114.120    30.765     0.200
>
  -114.153    30.789     0.200
>
  -114.115    30.727     0.200
>
  -114.352    31.315     0.200
>
  -113.747    29.795     0.200
>
  -113.759    29.789     0.200
>
  -113.772    29.834     0.200
>
  -113.736    29.788     0.200
>
  -113.752    29.778     0.200
>
  -113.790    29.785     0.200
>
  -113.792    29.818     0.200
>
  -113.784    29.836     0.200
>
  -113.817    29.810     0.200
>
  -113.753    29.875     0.200
>
  -113.781    29.851     0.200
>
  -113.773    29.828     0.200
>
  -113.739    29.787     0.200
>
  -113.784    29.934     0.200
>
  -113.700    29.840     0.200
>
  -113.730    29.880     0.200
>
  -113.767    29.863     0.200
>
  -113.797    29.873     0.200
>
  -113.726    29.877     0.200
>
  -113.782    29.824     0.200
>
  -113.734    29.885     0.200
>
  -113.733    29.833     0.200
>
  -113.738    29.806     0.200
>
  -113.730    29.940     0.200
>
  -113.738    29.884     0.200
>
  -113.761    29.883     0.200
>
  -113.744    29.921     0.200
>
  -113.726    29.897     0.200
>
  -114.427    31.569     0.200
>
  -114.433    31.584     0.200
>
  -113.723    29.884     0.200
>
  -113.747    29.918     0.200
>
  -113.762    29.927     0.200
>
  -113.734    29.840     0.200
>
  -113.736    29.803     0.200
>
  -113.732    29.864     0.200
>
  -113.724    29.901     0.200
>
  -113.862    29.753     0.200
>
  -113.825    29.775     0.200
>
  -113.875    29.722     0.200
>
  -113.734    29.871     0.200
>
  -113.748    29.815     0.200
>
  -113.785    29.878     0.200
>
  -113.732    29.873     0.200
>
  -113.626    30.109     0.200
>
  -113.775    29.859     0.200
>
  -113.771    29.901     0.200
>
  -113.770    29.869     0.200
>
  -113.740    29.832     0.200
>
  -113.753    29.833     0.200
>
  -113.721    29.852     0.200
>
  -113.756    29.842     0.200
>
  -113.463    30.040     0.200
>
  -113.751    29.903     0.200
>
  -113.713    30.024     0.200
>
  -113.742    29.796     0.200
>
  -113.736    29.837     0.200
>
  -113.813    29.791     0.200
>
  -113.781    29.796     0.200
>
  -113.778    29.834     0.200
>
  -113.811    29.815     0.200
>
  -113.792    29.893     0.200
>
  -113.783    29.816     0.200
>
  -113.739    29.842     0.200
>
  -113.757    29.823     0.200
>
  -113.762    29.787     0.200
>
  -113.751    29.791     0.200
>
  -113.763    29.813     0.200
>
  -113.764    29.889     0.200
>
  -113.746    29.792     0.200
>
  -113.755    29.812     0.200
>
  -113.669    29.928     0.200
>
  -113.703    30.002     0.200
>
  -113.756    29.816     0.200
>
  -113.800    29.833     0.200
>
  -113.760    29.831     0.200
>
  -113.767    29.842     0.200
>
  -113.759    29.769     0.200
>
  -113.759    29.864     0.200
>
  -113.750    29.827     0.200
>
  -113.751    29.798     0.200
>
  -113.752    29.780     0.200
>
  -113.743    29.828     0.200
>
  -113.781    30.079     0.200
>
  -113.780    30.049     0.200
>
  -113.743    29.887     0.200
>
  -113.739    29.891     0.200
>
  -113.745    29.823     0.200
>
  -113.754    29.846     0.200
>
  -113.765    29.865     0.200
>
  -113.780    29.855     0.200
>
  -113.877    29.723     0.200
>
  -113.748    29.809     0.200
>
  -113.786    29.778     0.200
>
  -113.763    29.790     0.200
>
  -113.690    29.893     0.200
>
  -113.769    29.834     0.200
>
  -114.080    30.586     0.200
>
  -113.785    30.155     0.200
>
  -113.728    30.135     0.200
>
  -113.694    30.149     0.200
>
  -113.741    30.141     0.200
>
  -113.712    29.962     0.200
>
  -114.172    30.733     0.200
>
  -113.931    30.452     0.200
>
  -113.927    30.438     0.200
>
  -113.736    30.147     0.200
>
  -113.740    30.102     0.200
>
  -113.768    30.130     0.200
>
  -113.925    30.598     0.200
>
  -113.948    30.449     0.200
>
  -113.929    30.436     0.200
>
  -113.889    30.430     0.200
>
  -113.724    30.050     0.200
>
  -113.737    30.100     0.200
>
  -113.754    30.028     0.200
>
  -113.753    30.112     0.200
>
  -113.764    30.080     0.200
>
  -113.766    30.090     0.200
>
  -113.728    30.165     0.200
>
  -113.737    30.175     0.200
>
  -114.174    30.730     0.200
>
  -113.930    30.445     0.200
>
  -114.197    30.591     0.200
>
  -114.363    31.502     0.200
>
  -114.393    30.072     0.200
>
  -114.065    30.606     0.200
>
  -114.085    30.608     0.200
>
  -114.395    31.523     0.200
>
  -114.413    31.548     0.200
>
  -114.331    31.526     0.200
>
  -114.364    31.544     0.200
>
  -114.393    31.524     0.200
>
  -114.388    31.553     0.200
>
  -114.425    31.599     0.200
>
  -114.412    31.584     0.200
>
  -114.397    31.555     0.200
>
  -114.061    30.627     0.200
>
  -114.234    31.362     0.200
>
  -114.438    31.653     0.200
>
  -114.326    31.310     0.200
>
  -114.335    31.324     0.200
>
  -114.315    31.301     0.200
>
  -114.317    31.281     0.200
>
  -114.257    31.414     0.200
>
  -114.348    31.415     0.200
>
  -114.349    31.435     0.200
>
  -114.540    30.158     0.200
>
  -114.351    31.432     0.200
>
  -114.480    30.195     0.200
>
  -114.352    31.391     0.200
>
  -114.337    31.381     0.200
>
  -114.332    31.414     0.200
>
  -114.329    31.387     0.200
>
  -114.305    31.396     0.200
>
  -113.932    30.378     0.200
>
  -114.378    31.517     0.200
>
  -114.545    31.632     0.200
>
  -114.545    31.639     0.200
>
  -115.040    31.708     0.200
>
  -114.995    31.705     0.200
>
  -114.526    31.620     0.200
>
  -114.527    31.628     0.200
>
  -114.501    31.631     0.200
>
  -114.454    31.626     0.200
>
  -114.539    31.651     0.200
>
  -114.514    31.638     0.200
>
  -114.258    31.319     0.200
>
  -114.149    30.760     0.200
>
  -114.326    31.489     0.200
>
  -114.328    31.502     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -114.039    30.493     0.000   222.000   222.000
  -114.039    30.493     0.000   444.000   444.000
EOF
gmt end
