#!/bin/bash
gmt begin penasco2.16_base pdf,ps
proj=-JM16.0c+
reg=-R-115.1/-113.4/29.6/31.8
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map penasco2.16'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -114.407    31.491 1
  -114.336    31.522 2
  -114.300    31.441 3
  -114.286    31.443 4
  -114.285    31.467 5
  -114.443    31.621 6
  -114.402    31.603 7
  -114.741    31.599 8
  -114.171    29.897 9
  -113.964    30.645 10
  -113.970    30.578 11
  -114.501    31.674 12
  -114.050    30.369 13
  -114.114    30.308 14
  -114.255    30.475 15
  -114.161    30.444 16
  -114.533    31.719 17
  -114.317    30.192 18
  -114.290    30.189 19
  -114.198    30.574 20
  -114.340    31.500 21
  -114.392    31.558 22
  -114.277    30.158 23
  -114.794    30.768 24
  -114.256    30.117 25
  -114.184    30.940 26
  -114.230    31.038 27
  -114.179    30.928 28
  -114.108    30.892 29
  -113.863    30.378 30
  -114.347    31.281 31
  -114.339    31.215 32
  -114.343    31.388 33
  -114.417    31.567 34
  -114.310    31.248 35
  -114.084    30.744 36
  -113.838    30.279 37
  -113.992    29.675 38
  -114.228    30.196 39
  -114.117    30.204 40
  -114.086    30.622 41
  -114.128    30.693 42
  -114.497    31.484 43
  -114.499    31.493 44
  -114.488    31.474 45
  -114.526    31.520 46
  -114.162    29.873 47
  -114.170    29.822 48
  -114.479    31.627 49
  -114.265    31.255 50
  -114.102    30.193 51
  -114.384    31.658 52
  -114.209    30.816 53
  -114.193    30.774 54
  -114.562    31.678 55
  -114.553    31.741 56
  -114.160    29.853 57
  -114.398    31.510 58
  -114.571    31.524 59
  -113.900    29.706 60
  -113.924    30.004 61
  -113.985    30.052 62
  -113.931    30.009 63
  -114.362    31.503 64
  -114.053    29.906 65
  -114.054    29.976 66
  -114.184    30.764 67
  -114.120    30.765 68
  -114.153    30.789 69
  -114.115    30.727 70
  -114.352    31.315 71
  -113.747    29.795 72
  -113.759    29.789 73
  -113.772    29.834 74
  -113.736    29.788 75
  -113.752    29.778 76
  -113.790    29.785 77
  -113.792    29.818 78
  -113.784    29.836 79
  -113.817    29.810 80
  -113.753    29.875 81
  -113.781    29.851 82
  -113.773    29.828 83
  -113.739    29.787 84
  -113.784    29.934 85
  -113.700    29.840 86
  -113.730    29.880 87
  -113.767    29.863 88
  -113.797    29.873 89
  -113.726    29.877 90
  -113.782    29.824 91
  -113.734    29.885 92
  -113.733    29.833 93
  -113.738    29.806 94
  -113.730    29.940 95
  -113.738    29.884 96
  -113.761    29.883 97
  -113.744    29.921 98
  -113.726    29.897 99
  -114.427    31.569 100
  -114.433    31.584 101
  -113.723    29.884 102
  -113.747    29.918 103
  -113.762    29.927 104
  -113.734    29.840 105
  -113.736    29.803 106
  -113.732    29.864 107
  -113.724    29.901 108
  -113.862    29.753 109
  -113.825    29.775 110
  -113.875    29.722 111
  -113.734    29.871 112
  -113.748    29.815 113
  -113.785    29.878 114
  -113.732    29.873 115
  -113.626    30.109 116
  -113.775    29.859 117
  -113.771    29.901 118
  -113.770    29.869 119
  -113.740    29.832 120
  -113.753    29.833 121
  -113.721    29.852 122
  -113.756    29.842 123
  -113.463    30.040 124
  -113.751    29.903 125
  -113.713    30.024 126
  -113.742    29.796 127
  -113.736    29.837 128
  -113.813    29.791 129
  -113.781    29.796 130
  -113.778    29.834 131
  -113.811    29.815 132
  -113.792    29.893 133
  -113.783    29.816 134
  -113.739    29.842 135
  -113.757    29.823 136
  -113.762    29.787 137
  -113.751    29.791 138
  -113.763    29.813 139
  -113.764    29.889 140
  -113.746    29.792 141
  -113.755    29.812 142
  -113.669    29.928 143
  -113.703    30.002 144
  -113.756    29.816 145
  -113.800    29.833 146
  -113.760    29.831 147
  -113.767    29.842 148
  -113.759    29.769 149
  -113.759    29.864 150
  -113.750    29.827 151
  -113.751    29.798 152
  -113.752    29.780 153
  -113.743    29.828 154
  -113.781    30.079 155
  -113.780    30.049 156
  -113.743    29.887 157
  -113.739    29.891 158
  -113.745    29.823 159
  -113.754    29.846 160
  -113.765    29.865 161
  -113.780    29.855 162
  -113.877    29.723 163
  -113.748    29.809 164
  -113.786    29.778 165
  -113.763    29.790 166
  -113.690    29.893 167
  -113.769    29.834 168
  -114.080    30.586 169
  -113.785    30.155 170
  -113.728    30.135 171
  -113.694    30.149 172
  -113.741    30.141 173
  -113.712    29.962 174
  -114.172    30.733 175
  -113.931    30.452 176
  -113.927    30.438 177
  -113.736    30.147 178
  -113.740    30.102 179
  -113.768    30.130 180
  -113.925    30.598 181
  -113.948    30.449 182
  -113.929    30.436 183
  -113.889    30.430 184
  -113.724    30.050 185
  -113.737    30.100 186
  -113.754    30.028 187
  -113.753    30.112 188
  -113.764    30.080 189
  -113.766    30.090 190
  -113.728    30.165 191
  -113.737    30.175 192
  -114.174    30.730 193
  -113.930    30.445 194
  -114.197    30.591 195
  -114.363    31.502 196
  -114.393    30.072 197
  -114.065    30.606 198
  -114.085    30.608 199
  -114.395    31.523 200
  -114.413    31.548 201
  -114.331    31.526 202
  -114.364    31.544 203
  -114.393    31.524 204
  -114.388    31.553 205
  -114.425    31.599 206
  -114.412    31.584 207
  -114.397    31.555 208
  -114.061    30.627 209
  -114.234    31.362 210
  -114.438    31.653 211
  -114.326    31.310 212
  -114.335    31.324 213
  -114.315    31.301 214
  -114.317    31.281 215
  -114.257    31.414 216
  -114.348    31.415 217
  -114.349    31.435 218
  -114.540    30.158 219
  -114.351    31.432 220
  -114.480    30.195 221
  -114.352    31.391 222
  -114.337    31.381 223
  -114.332    31.414 224
  -114.329    31.387 225
  -114.305    31.396 226
  -113.932    30.378 227
  -114.378    31.517 228
  -114.545    31.632 229
  -114.545    31.639 230
  -115.040    31.708 231
  -114.995    31.705 232
  -114.526    31.620 233
  -114.527    31.628 234
  -114.501    31.631 235
  -114.454    31.626 236
  -114.539    31.651 237
  -114.514    31.638 238
  -114.258    31.319 239
  -114.149    30.760 240
  -114.326    31.489 241
  -114.328    31.502 242
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -114.481    31.536
  -114.407    31.491
>
  -114.311    31.470
  -114.336    31.522
>
  -114.455    31.341
  -114.300    31.441
>
  -114.452    31.332
  -114.286    31.443
>
  -114.557    31.519
  -114.285    31.467
>
  -114.524    31.679
  -114.443    31.621
>
  -114.390    31.402
  -114.402    31.603
>
  -114.744    31.529
  -114.741    31.599
>
  -114.216    29.893
  -114.171    29.897
>
  -114.026    30.672
  -113.964    30.645
>
  -113.912    30.555
  -113.970    30.578
>
  -114.526    31.645
  -114.501    31.674
>
  -114.057    30.427
  -114.050    30.369
>
  -114.091    30.447
  -114.114    30.308
>
  -114.300    30.463
  -114.255    30.475
>
  -114.210    30.488
  -114.161    30.444
>
  -114.548    31.694
  -114.533    31.719
>
  -114.320    30.273
  -114.317    30.192
>
  -114.242    30.286
  -114.290    30.189
>
  -114.232    30.604
  -114.198    30.574
>
  -114.339    31.473
  -114.340    31.500
>
  -114.415    31.564
  -114.392    31.558
>
  -114.241    30.181
  -114.277    30.158
>
  -114.844    30.791
  -114.794    30.768
>
  -114.326    30.195
  -114.256    30.117
>
  -114.162    30.986
  -114.184    30.940
>
  -114.257    31.045
  -114.230    31.038
>
  -114.215    30.944
  -114.179    30.928
>
  -114.121    30.974
  -114.108    30.892
>
  -113.825    30.358
  -113.863    30.378
>
  -114.328    31.287
  -114.347    31.281
>
  -114.378    31.171
  -114.339    31.215
>
  -114.326    31.281
  -114.343    31.388
>
  -114.427    31.547
  -114.417    31.567
>
  -114.305    31.275
  -114.310    31.248
>
  -114.139    30.704
  -114.084    30.744
>
  -113.886    30.285
  -113.838    30.279
>
  -113.932    29.717
  -113.992    29.675
>
  -114.227    30.250
  -114.228    30.196
>
  -114.156    30.312
  -114.117    30.204
>
  -114.070    30.635
  -114.086    30.622
>
  -114.095    30.742
  -114.128    30.693
>
  -114.509    31.421
  -114.497    31.484
>
  -114.512    31.532
  -114.499    31.493
>
  -114.532    31.444
  -114.488    31.474
>
  -114.544    31.464
  -114.526    31.520
>
  -114.096    30.054
  -114.162    29.873
>
  -114.090    29.895
  -114.170    29.822
>
  -114.479    31.596
  -114.479    31.627
>
  -114.262    31.228
  -114.265    31.255
>
  -114.110    30.257
  -114.102    30.193
>
  -114.345    31.602
  -114.384    31.658
>
  -114.227    30.821
  -114.209    30.816
>
  -114.207    30.781
  -114.193    30.774
>
  -114.562    31.651
  -114.562    31.678
>
  -114.568    31.670
  -114.553    31.741
>
  -114.067    29.906
  -114.160    29.853
>
  -114.446    31.517
  -114.398    31.510
>
  -114.590    31.490
  -114.571    31.524
>
  -113.888    29.726
  -113.900    29.706
>
  -113.927    30.029
  -113.924    30.004
>
  -113.832    30.082
  -113.985    30.052
>
  -113.947    29.986
  -113.931    30.009
>
  -114.333    31.477
  -114.362    31.503
>
  -114.070    29.932
  -114.053    29.906
>
  -114.098    29.956
  -114.054    29.976
>
  -114.182    30.772
  -114.184    30.764
>
  -114.099    30.762
  -114.120    30.765
>
  -114.188    30.787
  -114.153    30.789
>
  -114.149    30.744
  -114.115    30.727
>
  -114.389    31.281
  -114.352    31.315
>
  -113.739    29.798
  -113.747    29.795
>
  -113.781    29.753
  -113.759    29.789
>
  -113.754    29.775
  -113.772    29.834
>
  -113.714    29.838
  -113.736    29.788
>
  -113.725    29.829
  -113.752    29.778
>
  -113.758    29.797
  -113.790    29.785
>
  -113.759    29.843
  -113.792    29.818
>
  -113.847    29.780
  -113.784    29.836
>
  -113.820    29.761
  -113.817    29.810
>
  -113.751    29.906
  -113.753    29.875
>
  -113.789    29.861
  -113.781    29.851
>
  -113.780    29.840
  -113.773    29.828
>
  -113.757    29.833
  -113.739    29.787
>
  -113.784    29.905
  -113.784    29.934
>
  -113.674    29.860
  -113.700    29.840
>
  -113.760    29.869
  -113.730    29.880
>
  -113.843    29.838
  -113.767    29.863
>
  -113.772    29.873
  -113.797    29.873
>
  -113.725    29.877
  -113.726    29.877
>
  -113.737    29.892
  -113.782    29.824
>
  -113.752    29.929
  -113.734    29.885
>
  -113.744    29.874
  -113.733    29.833
>
  -113.773    29.822
  -113.738    29.806
>
  -113.745    29.929
  -113.730    29.940
>
  -113.757    29.916
  -113.738    29.884
>
  -113.798    29.926
  -113.761    29.883
>
  -113.773    29.893
  -113.744    29.921
>
  -113.729    29.921
  -113.726    29.897
>
  -114.439    31.511
  -114.427    31.569
>
  -114.453    31.624
  -114.433    31.584
>
  -113.796    29.906
  -113.723    29.884
>
  -113.709    29.907
  -113.747    29.918
>
  -113.746    29.925
  -113.762    29.927
>
  -113.764    29.897
  -113.734    29.840
>
  -113.758    29.825
  -113.736    29.803
>
  -113.738    29.966
  -113.732    29.864
>
  -113.734    29.951
  -113.724    29.901
>
  -113.899    29.847
  -113.862    29.753
>
  -113.816    29.797
  -113.825    29.775
>
  -113.899    29.736
  -113.875    29.722
>
  -113.730    29.928
  -113.734    29.871
>
  -113.782    29.843
  -113.748    29.815
>
  -113.784    29.900
  -113.785    29.878
>
  -113.754    29.899
  -113.732    29.873
>
  -113.631    29.990
  -113.626    30.109
>
  -113.787    29.854
  -113.775    29.859
>
  -113.776    29.922
  -113.771    29.901
>
  -113.743    29.869
  -113.770    29.869
>
  -113.755    29.844
  -113.740    29.832
>
  -113.759    29.836
  -113.753    29.833
>
  -113.728    29.890
  -113.721    29.852
>
  -113.756    29.864
  -113.756    29.842
>
  -113.518    30.027
  -113.463    30.040
>
  -113.736    29.918
  -113.751    29.903
>
  -113.677    30.034
  -113.713    30.024
>
  -113.724    29.721
  -113.742    29.796
>
  -113.813    29.876
  -113.736    29.837
>
  -113.804    29.830
  -113.813    29.791
>
  -113.799    29.820
  -113.781    29.796
>
  -113.757    29.959
  -113.778    29.834
>
  -113.785    29.816
  -113.811    29.815
>
  -113.795    29.904
  -113.792    29.893
>
  -113.761    29.838
  -113.783    29.816
>
  -113.757    29.849
  -113.739    29.842
>
  -113.787    29.846
  -113.757    29.823
>
  -113.794    29.807
  -113.762    29.787
>
  -113.647    29.831
  -113.751    29.791
>
  -113.794    29.822
  -113.763    29.813
>
  -113.759    29.921
  -113.764    29.889
>
  -113.722    29.894
  -113.746    29.792
>
  -113.585    29.926
  -113.755    29.812
>
  -113.708    29.975
  -113.669    29.928
>
  -113.694    29.967
  -113.703    30.002
>
  -113.779    29.793
  -113.756    29.816
>
  -113.822    29.761
  -113.800    29.833
>
  -113.879    29.801
  -113.760    29.831
>
  -113.765    29.789
  -113.767    29.842
>
  -113.819    29.754
  -113.759    29.769
>
  -113.755    29.873
  -113.759    29.864
>
  -113.770    29.864
  -113.750    29.827
>
  -113.745    29.847
  -113.751    29.798
>
  -113.707    29.796
  -113.752    29.780
>
  -113.815    29.881
  -113.743    29.828
>
  -113.767    30.083
  -113.781    30.079
>
  -113.878    30.035
  -113.780    30.049
>
  -113.747    29.962
  -113.743    29.887
>
  -113.726    29.964
  -113.739    29.891
>
  -113.814    29.819
  -113.745    29.823
>
  -113.760    29.905
  -113.754    29.846
>
  -113.807    29.908
  -113.765    29.865
>
  -113.795    29.873
  -113.780    29.855
>
  -113.886    29.728
  -113.877    29.723
>
  -113.721    29.817
  -113.748    29.809
>
  -113.847    29.774
  -113.786    29.778
>
  -113.737    29.798
  -113.763    29.790
>
  -113.730    29.889
  -113.690    29.893
>
  -113.758    29.839
  -113.769    29.834
>
  -114.075    30.615
  -114.080    30.586
>
  -113.733    30.141
  -113.785    30.155
>
  -113.730    30.188
  -113.728    30.135
>
  -113.754    30.187
  -113.694    30.149
>
  -113.728    30.147
  -113.741    30.141
>
  -113.719    30.004
  -113.712    29.962
>
  -114.190    30.773
  -114.172    30.733
>
  -114.032    30.173
  -113.931    30.452
>
  -113.776    30.281
  -113.927    30.438
>
  -113.739    30.187
  -113.736    30.147
>
  -113.740    30.125
  -113.740    30.102
>
  -113.823    30.120
  -113.768    30.130
>
  -113.912    30.674
  -113.925    30.598
>
  -113.939    30.481
  -113.948    30.449
>
  -113.909    30.568
  -113.929    30.436
>
  -114.061    30.475
  -113.889    30.430
>
  -113.792    30.093
  -113.724    30.050
>
  -113.767    30.103
  -113.737    30.100
>
  -113.839    30.040
  -113.754    30.028
>
  -113.775    30.123
  -113.753    30.112
>
  -113.726    30.099
  -113.764    30.080
>
  -113.752    30.063
  -113.766    30.090
>
  -113.724    30.160
  -113.728    30.165
>
  -113.748    30.210
  -113.737    30.175
>
  -114.145    30.830
  -114.174    30.730
>
  -113.977    30.540
  -113.930    30.445
>
  -114.234    30.595
  -114.197    30.591
>
  -114.370    31.495
  -114.363    31.502
>
  -114.425    30.071
  -114.393    30.072
>
  -114.022    30.578
  -114.065    30.606
>
  -114.133    30.653
  -114.085    30.608
>
  -114.427    31.508
  -114.395    31.523
>
  -114.414    31.628
  -114.413    31.548
>
  -114.290    31.509
  -114.331    31.526
>
  -114.311    31.521
  -114.364    31.544
>
  -114.424    31.525
  -114.393    31.524
>
  -114.402    31.532
  -114.388    31.553
>
  -114.428    31.646
  -114.425    31.599
>
  -114.441    31.640
  -114.412    31.584
>
  -114.451    31.591
  -114.397    31.555
>
  -114.028    30.654
  -114.061    30.627
>
  -114.214    31.313
  -114.234    31.362
>
  -114.380    31.611
  -114.438    31.653
>
  -114.343    31.364
  -114.326    31.310
>
  -114.357    31.351
  -114.335    31.324
>
  -114.299    31.327
  -114.315    31.301
>
  -114.263    31.313
  -114.317    31.281
>
  -114.264    31.368
  -114.257    31.414
>
  -114.296    31.420
  -114.348    31.415
>
  -114.382    31.482
  -114.349    31.435
>
  -114.618    30.107
  -114.540    30.158
>
  -114.403    31.507
  -114.351    31.432
>
  -114.595    30.140
  -114.480    30.195
>
  -114.345    31.387
  -114.352    31.391
>
  -114.359    31.413
  -114.337    31.381
>
  -114.229    31.414
  -114.332    31.414
>
  -114.282    31.422
  -114.329    31.387
>
  -114.308    31.358
  -114.305    31.396
>
  -113.975    30.377
  -113.932    30.378
>
  -114.422    31.582
  -114.378    31.517
>
  -114.403    31.607
  -114.545    31.632
>
  -114.491    31.683
  -114.545    31.639
>
  -114.987    31.646
  -115.040    31.708
>
  -114.963    31.697
  -114.995    31.705
>
  -114.552    31.675
  -114.526    31.620
>
  -114.518    31.694
  -114.527    31.628
>
  -114.567    31.645
  -114.501    31.631
>
  -114.534    31.572
  -114.454    31.626
>
  -114.560    31.645
  -114.539    31.651
>
  -114.540    31.623
  -114.514    31.638
>
  -114.153    31.388
  -114.258    31.319
>
  -114.171    30.580
  -114.149    30.760
>
  -114.258    31.482
  -114.326    31.489
>
  -114.348    31.431
  -114.328    31.502
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -114.406    31.492
  -114.407    31.491
>
  -114.335    31.522
  -114.336    31.522
>
  -114.299    31.441
  -114.300    31.441
>
  -114.285    31.442
  -114.286    31.443
>
  -114.284    31.467
  -114.285    31.467
>
  -114.443    31.621
  -114.443    31.621
>
  -114.398    31.600
  -114.402    31.603
>
  -114.742    31.602
  -114.741    31.599
>
  -114.169    29.897
  -114.171    29.897
>
  -113.963    30.645
  -113.964    30.645
>
  -113.968    30.580
  -113.970    30.578
>
  -114.498    31.673
  -114.501    31.674
>
  -114.050    30.367
  -114.050    30.369
>
  -114.113    30.309
  -114.114    30.308
>
  -114.254    30.477
  -114.255    30.475
>
  -114.160    30.447
  -114.161    30.444
>
  -114.537    31.719
  -114.533    31.719
>
  -114.316    30.191
  -114.317    30.192
>
  -114.288    30.187
  -114.290    30.189
>
  -114.197    30.573
  -114.198    30.574
>
  -114.339    31.500
  -114.340    31.500
>
  -114.391    31.557
  -114.392    31.558
>
  -114.277    30.157
  -114.277    30.158
>
  -114.793    30.768
  -114.794    30.768
>
  -114.256    30.118
  -114.256    30.117
>
  -114.177    30.941
  -114.184    30.940
>
  -114.229    31.038
  -114.230    31.038
>
  -114.178    30.929
  -114.179    30.928
>
  -114.107    30.891
  -114.108    30.892
>
  -113.862    30.379
  -113.863    30.378
>
  -114.346    31.281
  -114.347    31.281
>
  -114.339    31.215
  -114.339    31.215
>
  -114.341    31.388
  -114.343    31.388
>
  -114.417    31.566
  -114.417    31.567
>
  -114.309    31.248
  -114.310    31.248
>
  -114.084    30.744
  -114.084    30.744
>
  -113.837    30.279
  -113.838    30.279
>
  -113.992    29.675
  -113.992    29.675
>
  -114.229    30.196
  -114.228    30.196
>
  -114.117    30.205
  -114.117    30.204
>
  -114.085    30.622
  -114.086    30.622
>
  -114.127    30.693
  -114.128    30.693
>
  -114.496    31.484
  -114.497    31.484
>
  -114.499    31.494
  -114.499    31.493
>
  -114.486    31.473
  -114.488    31.474
>
  -114.524    31.520
  -114.526    31.520
>
  -114.161    29.872
  -114.162    29.873
>
  -114.169    29.822
  -114.170    29.822
>
  -114.478    31.627
  -114.479    31.627
>
  -114.265    31.254
  -114.265    31.255
>
  -114.101    30.193
  -114.102    30.193
>
  -114.383    31.659
  -114.384    31.658
>
  -114.209    30.817
  -114.209    30.816
>
  -114.192    30.774
  -114.193    30.774
>
  -114.561    31.678
  -114.562    31.678
>
  -114.552    31.741
  -114.553    31.741
>
  -114.159    29.853
  -114.160    29.853
>
  -114.397    31.510
  -114.398    31.510
>
  -114.571    31.523
  -114.571    31.524
>
  -113.899    29.707
  -113.900    29.706
>
  -113.923    30.003
  -113.924    30.004
>
  -113.984    30.052
  -113.985    30.052
>
  -113.930    30.008
  -113.931    30.009
>
  -114.360    31.504
  -114.362    31.503
>
  -114.052    29.906
  -114.053    29.906
>
  -114.054    29.976
  -114.054    29.976
>
  -114.184    30.765
  -114.184    30.764
>
  -114.120    30.765
  -114.120    30.765
>
  -114.153    30.789
  -114.153    30.789
>
  -114.115    30.728
  -114.115    30.727
>
  -114.352    31.315
  -114.352    31.315
>
  -113.746    29.794
  -113.747    29.795
>
  -113.759    29.790
  -113.759    29.789
>
  -113.771    29.833
  -113.772    29.834
>
  -113.735    29.788
  -113.736    29.788
>
  -113.751    29.779
  -113.752    29.778
>
  -113.789    29.785
  -113.790    29.785
>
  -113.791    29.817
  -113.792    29.818
>
  -113.783    29.835
  -113.784    29.836
>
  -113.816    29.809
  -113.817    29.810
>
  -113.753    29.875
  -113.753    29.875
>
  -113.780    29.851
  -113.781    29.851
>
  -113.772    29.828
  -113.773    29.828
>
  -113.738    29.787
  -113.739    29.787
>
  -113.784    29.934
  -113.784    29.934
>
  -113.699    29.839
  -113.700    29.840
>
  -113.729    29.880
  -113.730    29.880
>
  -113.766    29.863
  -113.767    29.863
>
  -113.797    29.872
  -113.797    29.873
>
  -113.726    29.877
  -113.726    29.877
>
  -113.782    29.824
  -113.782    29.824
>
  -113.733    29.885
  -113.734    29.885
>
  -113.733    29.832
  -113.733    29.833
>
  -113.737    29.806
  -113.738    29.806
>
  -113.729    29.939
  -113.730    29.940
>
  -113.737    29.884
  -113.738    29.884
>
  -113.760    29.884
  -113.761    29.883
>
  -113.744    29.920
  -113.744    29.921
>
  -113.725    29.897
  -113.726    29.897
>
  -114.426    31.571
  -114.427    31.569
>
  -114.432    31.583
  -114.433    31.584
>
  -113.722    29.883
  -113.723    29.884
>
  -113.746    29.918
  -113.747    29.918
>
  -113.761    29.927
  -113.762    29.927
>
  -113.733    29.840
  -113.734    29.840
>
  -113.736    29.804
  -113.736    29.803
>
  -113.730    29.863
  -113.732    29.864
>
  -113.724    29.901
  -113.724    29.901
>
  -113.861    29.752
  -113.862    29.753
>
  -113.824    29.775
  -113.825    29.775
>
  -113.875    29.722
  -113.875    29.722
>
  -113.734    29.871
  -113.734    29.871
>
  -113.747    29.814
  -113.748    29.815
>
  -113.784    29.878
  -113.785    29.878
>
  -113.731    29.873
  -113.732    29.873
>
  -113.626    30.109
  -113.626    30.109
>
  -113.774    29.858
  -113.775    29.859
>
  -113.771    29.901
  -113.771    29.901
>
  -113.769    29.868
  -113.770    29.869
>
  -113.739    29.833
  -113.740    29.832
>
  -113.752    29.832
  -113.753    29.833
>
  -113.720    29.846
  -113.721    29.852
>
  -113.756    29.842
  -113.756    29.842
>
  -113.463    30.041
  -113.463    30.040
>
  -113.750    29.903
  -113.751    29.903
>
  -113.713    30.024
  -113.713    30.024
>
  -113.741    29.797
  -113.742    29.796
>
  -113.735    29.834
  -113.736    29.837
>
  -113.813    29.791
  -113.813    29.791
>
  -113.780    29.796
  -113.781    29.796
>
  -113.777    29.833
  -113.778    29.834
>
  -113.810    29.814
  -113.811    29.815
>
  -113.792    29.893
  -113.792    29.893
>
  -113.783    29.815
  -113.783    29.816
>
  -113.738    29.841
  -113.739    29.842
>
  -113.756    29.822
  -113.757    29.823
>
  -113.761    29.787
  -113.762    29.787
>
  -113.750    29.791
  -113.751    29.791
>
  -113.763    29.813
  -113.763    29.813
>
  -113.763    29.888
  -113.764    29.889
>
  -113.745    29.792
  -113.746    29.792
>
  -113.755    29.812
  -113.755    29.812
>
  -113.668    29.928
  -113.669    29.928
>
  -113.702    30.001
  -113.703    30.002
>
  -113.755    29.815
  -113.756    29.816
>
  -113.799    29.833
  -113.800    29.833
>
  -113.759    29.831
  -113.760    29.831
>
  -113.766    29.842
  -113.767    29.842
>
  -113.757    29.769
  -113.759    29.769
>
  -113.758    29.864
  -113.759    29.864
>
  -113.750    29.826
  -113.750    29.827
>
  -113.751    29.799
  -113.751    29.798
>
  -113.751    29.781
  -113.752    29.780
>
  -113.742    29.830
  -113.743    29.828
>
  -113.780    30.078
  -113.781    30.079
>
  -113.779    30.049
  -113.780    30.049
>
  -113.743    29.887
  -113.743    29.887
>
  -113.739    29.890
  -113.739    29.891
>
  -113.744    29.823
  -113.745    29.823
>
  -113.753    29.846
  -113.754    29.846
>
  -113.765    29.865
  -113.765    29.865
>
  -113.780    29.855
  -113.780    29.855
>
  -113.876    29.723
  -113.877    29.723
>
  -113.748    29.809
  -113.748    29.809
>
  -113.785    29.777
  -113.786    29.778
>
  -113.762    29.790
  -113.763    29.790
>
  -113.689    29.892
  -113.690    29.893
>
  -113.768    29.834
  -113.769    29.834
>
  -114.079    30.586
  -114.080    30.586
>
  -113.785    30.155
  -113.785    30.155
>
  -113.728    30.135
  -113.728    30.135
>
  -113.692    30.148
  -113.694    30.149
>
  -113.741    30.140
  -113.741    30.141
>
  -113.711    29.962
  -113.712    29.962
>
  -114.172    30.733
  -114.172    30.733
>
  -113.930    30.452
  -113.931    30.452
>
  -113.927    30.439
  -113.927    30.438
>
  -113.735    30.147
  -113.736    30.147
>
  -113.739    30.102
  -113.740    30.102
>
  -113.768    30.130
  -113.768    30.130
>
  -113.925    30.598
  -113.925    30.598
>
  -113.947    30.449
  -113.948    30.449
>
  -113.929    30.437
  -113.929    30.436
>
  -113.889    30.430
  -113.889    30.430
>
  -113.723    30.050
  -113.724    30.050
>
  -113.736    30.099
  -113.737    30.100
>
  -113.754    30.028
  -113.754    30.028
>
  -113.752    30.112
  -113.753    30.112
>
  -113.764    30.079
  -113.764    30.080
>
  -113.765    30.089
  -113.766    30.090
>
  -113.727    30.166
  -113.728    30.165
>
  -113.736    30.174
  -113.737    30.175
>
  -114.175    30.730
  -114.174    30.730
>
  -113.930    30.445
  -113.930    30.445
>
  -114.198    30.591
  -114.197    30.591
>
  -114.364    31.504
  -114.363    31.502
>
  -114.393    30.072
  -114.393    30.072
>
  -114.064    30.607
  -114.065    30.606
>
  -114.085    30.609
  -114.085    30.608
>
  -114.394    31.521
  -114.395    31.523
>
  -114.410    31.549
  -114.413    31.548
>
  -114.326    31.527
  -114.331    31.526
>
  -114.362    31.542
  -114.364    31.544
>
  -114.391    31.522
  -114.393    31.524
>
  -114.385    31.554
  -114.388    31.553
>
  -114.426    31.594
  -114.425    31.599
>
  -114.411    31.585
  -114.412    31.584
>
  -114.395    31.559
  -114.397    31.555
>
  -114.060    30.627
  -114.061    30.627
>
  -114.234    31.356
  -114.234    31.362
>
  -114.438    31.652
  -114.438    31.653
>
  -114.328    31.303
  -114.326    31.310
>
  -114.335    31.330
  -114.335    31.324
>
  -114.314    31.299
  -114.315    31.301
>
  -114.322    31.278
  -114.317    31.281
>
  -114.256    31.415
  -114.257    31.414
>
  -114.347    31.414
  -114.348    31.415
>
  -114.350    31.441
  -114.349    31.435
>
  -114.541    30.157
  -114.540    30.158
>
  -114.350    31.431
  -114.351    31.432
>
  -114.479    30.195
  -114.480    30.195
>
  -114.352    31.393
  -114.352    31.391
>
  -114.338    31.385
  -114.337    31.381
>
  -114.332    31.412
  -114.332    31.414
>
  -114.328    31.384
  -114.329    31.387
>
  -114.305    31.397
  -114.305    31.396
>
  -113.933    30.387
  -113.932    30.378
>
  -114.376    31.516
  -114.378    31.517
>
  -114.546    31.634
  -114.545    31.632
>
  -114.545    31.639
  -114.545    31.639
>
  -115.039    31.709
  -115.040    31.708
>
  -114.994    31.704
  -114.995    31.705
>
  -114.524    31.621
  -114.526    31.620
>
  -114.530    31.626
  -114.527    31.628
>
  -114.503    31.629
  -114.501    31.631
>
  -114.456    31.624
  -114.454    31.626
>
  -114.534    31.654
  -114.539    31.651
>
  -114.515    31.637
  -114.514    31.638
>
  -114.257    31.319
  -114.258    31.319
>
  -114.154    30.765
  -114.149    30.760
>
  -114.326    31.488
  -114.326    31.489
>
  -114.327    31.500
  -114.328    31.502
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -114.407    31.491    65.691     1.924     4.620
  -114.336    31.522    57.701     2.172     2.790
  -114.300    31.441    71.311     1.358     2.325
  -114.286    31.443    71.801     1.331     2.219
  -114.285    31.467    69.984     1.367     2.641
  -114.443    31.621   -40.714     0.457     5.736
  -114.402    31.603    62.789     1.978     3.769
  -114.741    31.599    57.741     2.636     3.710
  -114.171    29.897   -65.334     1.875     3.436
  -113.964    30.645   -60.580     2.057     5.617
  -113.970    30.578   -69.609     1.650     2.619
  -114.501    31.674    45.871     2.402     5.043
  -114.050    30.369   -69.952     1.657     3.031
  -114.114    30.308   -57.703     1.738     3.155
  -114.255    30.475   -67.863     1.622     2.769
  -114.161    30.444   -71.712     2.549     5.055
  -114.533    31.719    59.774     2.100     2.528
  -114.317    30.192   -61.618     2.157     3.361
  -114.290    30.189   -53.852     1.760     3.287
  -114.198    30.574   -62.761     1.605     3.207
  -114.340    31.500   -59.078     1.645     3.286
  -114.392    31.558   -81.846     2.495     4.055
  -114.277    30.158   -16.893     1.677     3.200
  -114.794    30.768   -49.316     2.059     3.028
  -114.256    30.117   -51.861     2.710     3.353
  -114.184    30.940    20.345     2.518     4.056
  -114.230    31.038   -72.111     1.352     2.866
  -114.179    30.928    13.354     1.796     2.354
  -114.108    30.892   -77.619     2.808     4.770
  -113.863    30.378    63.453     2.214     4.227
  -114.347    31.281   -84.779     1.898     3.908
  -114.339    31.215    45.431     2.327     2.650
  -114.343    31.388   -79.219     3.458     6.783
  -114.417    31.567   -73.203     2.650     4.728
  -114.310    31.248   -42.864     2.248     3.016
  -114.084    30.744    20.236     2.365     4.698
  -113.838    30.279    32.768     3.433     5.155
  -113.992    29.675   -45.860     2.534     4.931
  -114.228    30.196    18.283     2.230     4.121
  -114.117    30.204    23.917     2.116     3.900
  -114.086    30.622    86.276     3.104     5.498
  -114.128    30.693   -34.998     2.129     2.621
  -114.497    31.484   -74.113     1.976     3.578
  -114.499    31.493   -76.734     2.920     3.861
  -114.488    31.474    72.512     2.785     3.724
  -114.526    31.520    40.757     3.403     4.943
  -114.162    29.873    73.148     2.062     4.463
  -114.170    29.822    77.652     2.769     4.615
  -114.479    31.627   -81.768     2.241     3.103
  -114.265    31.255   -87.801     3.263     7.228
  -114.102    30.193    49.410     2.243     3.329
  -114.384    31.658    89.839     2.695     3.894
  -114.209    30.816   -69.028     3.486     3.885
  -114.193    30.774     4.964     1.656     2.566
  -114.562    31.678   -50.874     1.415     2.344
  -114.553    31.741   -62.514     2.887     4.541
  -114.160    29.853    80.866     2.416     4.336
  -114.398    31.510   -66.787     3.303     5.337
  -114.571    31.524   -75.491     2.520     4.090
  -113.900    29.706   -81.900     1.688     2.437
  -113.924    30.004    74.399     2.238     3.725
  -113.985    30.052    58.609     3.031     4.881
  -113.931    30.009    64.642     2.794     4.493
  -114.362    31.503   -70.728     2.414     3.291
  -114.053    29.906    66.481     3.294     5.010
  -114.054    29.976    50.759     3.139     5.038
  -114.184    30.764   -83.932     2.638     3.361
  -114.120    30.765    14.690     2.876     4.895
  -114.153    30.789    12.293     2.291     3.401
  -114.115    30.727    17.855     1.659     1.989
  -114.352    31.315    87.968     2.098     4.947
  -113.747    29.795    87.775     1.769     3.763
  -113.759    29.789    87.791     2.525     5.613
  -113.772    29.834    87.051     3.056     6.216
  -113.736    29.788    89.967     1.795     4.317
  -113.752    29.778    87.491     1.772     4.216
  -113.790    29.785   -79.309     2.290     3.723
  -113.792    29.818   -89.879     1.836     4.645
  -113.784    29.836    89.472     2.452     3.924
  -113.817    29.810    85.953     1.705     3.321
  -113.753    29.875    89.388     1.882     3.852
  -113.781    29.851    82.036     1.462     2.733
  -113.773    29.828    85.404     1.679     3.381
  -113.739    29.787    89.840     1.669     4.105
  -113.784    29.934    88.672     2.438     4.461
  -113.700    29.840   -89.311     2.197     4.048
  -113.730    29.880    76.366     2.555     4.101
  -113.767    29.863   -88.364     2.424     4.763
  -113.797    29.873   -70.191     3.001     4.818
  -113.726    29.877    83.518     1.941     3.366
  -113.782    29.824    81.708     1.960     4.510
  -113.734    29.885    89.500     1.941     3.865
  -113.733    29.833    87.007     2.181     3.011
  -113.738    29.806   -83.274     2.005     3.137
  -113.730    29.940    82.017     2.153     3.453
  -113.738    29.884   -87.655     1.899     3.253
  -113.761    29.883    79.045     1.956     3.031
  -113.744    29.921    81.908     2.087     3.762
  -113.726    29.897    89.120     1.613     3.267
  -114.427    31.569   -56.833     1.520     2.431
  -114.433    31.584   -77.386     1.981     2.608
  -113.723    29.884    87.804     1.783     2.268
  -113.747    29.918    80.900     2.339     4.180
  -113.762    29.927    85.991     2.329     3.948
  -113.734    29.840   -81.007     1.634     2.317
  -113.736    29.803    88.695     1.559     2.434
  -113.732    29.864    87.471     1.322     1.892
  -113.724    29.901   -88.408     1.815     3.159
  -113.862    29.753   -87.263     2.187     5.118
  -113.825    29.775   -74.450     1.893     3.178
  -113.875    29.722   -82.753     1.967     4.818
  -113.734    29.871    84.598     1.996     3.895
  -113.748    29.815    85.573     1.930     3.366
  -113.785    29.878    83.092     2.313     2.969
  -113.732    29.873    86.716     2.207     4.477
  -113.626    30.109    43.571     3.215     3.921
  -113.775    29.859    80.452     2.007     3.588
  -113.771    29.901    85.170     2.111     3.541
  -113.770    29.869    79.342     2.279     3.487
  -113.740    29.832    85.625     2.064     3.878
  -113.753    29.833   -89.070     2.069     4.516
  -113.721    29.852    86.652     1.553     2.857
  -113.756    29.842    84.172     1.679     2.899
  -113.463    30.040   -57.782     3.285     5.233
  -113.751    29.903    87.876     1.666     2.885
  -113.713    30.024   -65.544     2.410     3.465
  -113.742    29.796   -89.095     2.462     5.338
  -113.736    29.837   -88.847     2.397     5.726
  -113.813    29.791    89.212     2.541     5.100
  -113.781    29.796   -86.811     2.443     5.542
  -113.778    29.834    73.094     3.807     7.052
  -113.811    29.815    81.938     1.859     4.057
  -113.792    29.893    82.364     2.172     4.280
  -113.783    29.816    89.089     1.547     2.889
  -113.739    29.842    82.598     2.048     4.008
  -113.757    29.823    89.955     2.864     5.864
  -113.762    29.787   -89.899     1.526     3.324
  -113.751    29.791   -88.840     3.015     8.131
  -113.763    29.813   -85.283     2.119     4.960
  -113.764    29.889    82.005     2.110     4.361
  -113.746    29.792    84.541     1.636     4.876
  -113.755    29.812    89.171     2.552     7.463
  -113.669    29.928    85.974     1.959     4.107
  -113.703    30.002    84.588     2.525     4.536
  -113.756    29.816   -88.850     2.627     6.705
  -113.800    29.833    89.663     2.590     4.377
  -113.760    29.831   -75.417     2.692     4.927
  -113.767    29.842    84.971     1.926     3.908
  -113.759    29.769    85.826     2.314     5.090
  -113.759    29.864   -82.535     1.640     2.913
  -113.750    29.827   -88.988     1.892     3.522
  -113.751    29.798    89.838     2.282     5.211
  -113.752    29.780   -87.789     1.982     4.742
  -113.743    29.828   -88.502     1.702     3.788
  -113.781    30.079    81.871     2.335     3.536
  -113.780    30.049    78.438     2.096     3.259
  -113.743    29.887   -87.754     1.890     2.812
  -113.739    29.891    82.630     2.254     4.085
  -113.745    29.823    86.067     1.685     3.238
  -113.754    29.846    89.123     2.085     4.560
  -113.765    29.865   -85.580     1.876     3.087
  -113.780    29.855   -80.641     2.589     4.706
  -113.877    29.723   -82.909     1.621     3.572
  -113.748    29.809    87.720     2.425     5.328
  -113.786    29.778   -88.700     2.890     7.677
  -113.763    29.790    89.766     2.129     4.814
  -113.690    29.893    78.262     3.024     4.194
  -113.769    29.834   -88.433     1.937     4.110
  -114.080    30.586    45.056     3.285     4.398
  -113.785    30.155    65.896     1.960     3.254
  -113.728    30.135    71.699     1.931     3.139
  -113.694    30.149    40.102     2.359     3.486
  -113.741    30.141    73.833     2.491     3.641
  -113.712    29.962    84.072     2.514     4.240
  -114.172    30.733    20.873     3.464     4.741
  -113.931    30.452    56.225     2.297     2.673
  -113.927    30.438    59.091     2.819     3.118
  -113.736    30.147    78.145     2.318     3.606
  -113.740    30.102    80.717     1.532     2.981
  -113.768    30.130    79.367     2.356     3.476
  -113.925    30.598    32.777     2.261     3.124
  -113.948    30.449    32.629     2.915     3.766
  -113.929    30.436    71.330     2.268     2.749
  -113.889    30.430    52.752     2.744     3.667
  -113.724    30.050   -89.861     1.730     2.387
  -113.737    30.100    77.307     1.679     2.398
  -113.754    30.028    84.971     1.901     3.321
  -113.753    30.112    73.494     1.885     3.338
  -113.764    30.080    63.418     2.257     3.757
  -113.766    30.090    78.754     2.741     3.999
  -113.728    30.165    80.486     1.682     3.261
  -113.737    30.175    63.206     2.518     3.731
  -114.174    30.730    61.790     2.610     3.019
  -113.930    30.445    32.160     2.359     3.664
  -114.197    30.591    -6.021     3.289     4.244
  -114.363    31.502   -17.673     1.413     2.169
  -114.393    30.072   -11.814     2.203     3.967
  -114.065    30.606     5.624     3.180     4.034
  -114.085    30.608    11.339     2.290     3.697
  -114.395    31.523   -69.348     2.074     2.725
  -114.413    31.548   -88.475     1.892     2.451
  -114.331    31.526    45.537     2.986     4.291
  -114.364    31.544    41.048     3.567     5.463
  -114.393    31.524   -65.304     1.753     2.911
  -114.388    31.553    88.514     2.002     2.481
  -114.425    31.599   -79.046     2.609     3.908
  -114.412    31.584   -68.890     2.163     2.321
  -114.397    31.555   -75.064     2.135     3.184
  -114.061    30.627    81.669     3.535     5.239
  -114.234    31.362    89.405     2.511     5.518
  -114.438    31.653   -79.137     2.743     3.313
  -114.326    31.310    84.738     2.246     4.932
  -114.335    31.324   -89.968     2.623     5.318
  -114.315    31.301    88.200     2.567     5.982
  -114.317    31.281    89.945     2.618     3.831
  -114.257    31.414   -81.109     2.692     4.402
  -114.348    31.415   -84.749     1.608     2.556
  -114.349    31.435   -89.888     2.042     3.280
  -114.540    30.158   -24.663     2.394     8.744
  -114.351    31.432   -88.368     1.693     2.314
  -114.480    30.195   -22.934     2.762     5.077
  -114.352    31.391   -84.489     2.507     6.601
  -114.337    31.381    78.736     3.307     6.194
  -114.332    31.414    86.042     1.908     3.203
  -114.329    31.387    88.941     2.071     4.513
  -114.305    31.396   -85.270     2.538     5.999
  -113.932    30.378    34.516     2.592     3.498
  -114.378    31.517    77.707     3.233     3.850
  -114.545    31.632    43.835     2.811     3.479
  -114.545    31.639    26.491     2.230     2.935
  -115.040    31.708    54.614     2.181     2.937
  -114.995    31.705     6.913     1.951     2.476
  -114.526    31.620    39.697     2.357     2.913
  -114.527    31.628    44.045     1.616     2.006
  -114.501    31.631   -82.720     1.650     1.901
  -114.454    31.626    53.350     3.326     3.687
  -114.539    31.651    40.902     1.832     3.097
  -114.514    31.638    49.145     2.286     3.180
  -114.258    31.319    77.289     2.694     4.255
  -114.149    30.760     7.503     2.619     3.747
  -114.326    31.489   -75.199     2.544     3.321
  -114.328    31.502    65.141     2.949     3.936
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -115.078    29.629   -64.713     1.039     1.329
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -115.055    29.629   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -115.078    29.629     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -115.078    29.629     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -115.078    29.584   5 km
EOF
gmt end
