#!/bin/bash
gmt begin novy1.66_tt8_rdp_summary pdf,ps
proj=-JX18/12
reg=-R25/102/0/20
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1+l'Time Difference (s)' -BWeSn+t'Relative Depth Phase Summary novy1.66'
gmt plot $proj $reg -Wthick,green << EOF
    25.000     3.035
    26.000     3.039
    27.000     3.044
    28.000     3.051
    29.000     3.055
    30.000     3.058
    31.000     3.061
    32.000     3.064
    33.000     3.068
    34.000     3.073
    35.000     3.079
    36.000     3.084
    37.000     3.090
    38.000     3.095
    39.000     3.101
    40.000     3.107
    41.000     3.113
    42.000     3.119
    43.000     3.125
    44.000     3.131
    45.000     3.136
    46.000     3.142
    47.000     3.148
    48.000     3.154
    49.000     3.160
    50.000     3.165
    51.000     3.171
    52.000     3.177
    53.000     3.182
    54.000     3.188
    55.000     3.193
    56.000     3.198
    57.000     3.204
    58.000     3.209
    59.000     3.214
    60.000     3.219
    61.000     3.224
    62.000     3.229
    63.000     3.234
    64.000     3.239
    65.000     3.243
    66.000     3.248
    67.000     3.253
    68.000     3.257
    69.000     3.262
    70.000     3.266
    71.000     3.271
    72.000     3.275
    73.000     3.279
    74.000     3.284
    75.000     3.288
    76.000     3.292
    77.000     3.296
    78.000     3.300
    79.000     3.304
    80.000     3.308
    81.000     3.312
    82.000     3.316
    83.000     3.320
    84.000     3.324
    85.000     3.328
    86.000     3.331
    87.000     3.335
    88.000     3.341
    89.000     3.343
    90.000     3.344
    91.000     3.345
    92.000     3.346
    93.000     3.347
    94.000     3.348
    95.000     3.349
    96.000     3.350
    97.000     3.351
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000     3.351  10
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000     6.068
    26.000     6.076
    27.000     6.086
    28.000     6.100
    29.000     6.109
    30.000     6.115
    31.000     6.121
    32.000     6.127
    33.000     6.135
    34.000     6.145
    35.000     6.156
    36.000     6.167
    37.000     6.178
    38.000     6.189
    39.000     6.201
    40.000     6.213
    41.000     6.225
    42.000     6.236
    43.000     6.248
    44.000     6.260
    45.000     6.272
    46.000     6.284
    47.000     6.295
    48.000     6.307
    49.000     6.318
    50.000     6.330
    51.000     6.341
    52.000     6.352
    53.000     6.363
    54.000     6.374
    55.000     6.385
    56.000     6.396
    57.000     6.406
    58.000     6.417
    59.000     6.427
    60.000     6.437
    61.000     6.447
    62.000     6.457
    63.000     6.467
    64.000     6.476
    65.000     6.486
    66.000     6.495
    67.000     6.504
    68.000     6.513
    69.000     6.523
    70.000     6.531
    71.000     6.540
    72.000     6.549
    73.000     6.558
    74.000     6.566
    75.000     6.575
    76.000     6.583
    77.000     6.591
    78.000     6.599
    79.000     6.607
    80.000     6.615
    81.000     6.623
    82.000     6.631
    83.000     6.639
    84.000     6.647
    85.000     6.655
    86.000     6.662
    87.000     6.669
    88.000     6.681
    89.000     6.685
    90.000     6.688
    91.000     6.690
    92.000     6.692
    93.000     6.693
    94.000     6.695
    95.000     6.697
    96.000     6.699
    97.000     6.701
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000     6.701  20
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000     8.669
    26.000     8.682
    27.000     8.698
    28.000     8.721
    29.000     8.735
    30.000     8.744
    31.000     8.753
    32.000     8.763
    33.000     8.776
    34.000     8.792
    35.000     8.809
    36.000     8.827
    37.000     8.844
    38.000     8.862
    39.000     8.880
    40.000     8.899
    41.000     8.918
    42.000     8.936
    43.000     8.955
    44.000     8.974
    45.000     8.992
    46.000     9.011
    47.000     9.030
    48.000     9.048
    49.000     9.066
    50.000     9.084
    51.000     9.102
    52.000     9.120
    53.000     9.136
    54.000     9.154
    55.000     9.171
    56.000     9.188
    57.000     9.204
    58.000     9.221
    59.000     9.237
    60.000     9.253
    61.000     9.269
    62.000     9.285
    63.000     9.300
    64.000     9.315
    65.000     9.330
    66.000     9.344
    67.000     9.359
    68.000     9.373
    69.000     9.387
    70.000     9.401
    71.000     9.415
    72.000     9.429
    73.000     9.443
    74.000     9.456
    75.000     9.470
    76.000     9.483
    77.000     9.495
    78.000     9.508
    79.000     9.520
    80.000     9.533
    81.000     9.546
    82.000     9.558
    83.000     9.570
    84.000     9.582
    85.000     9.595
    86.000     9.607
    87.000     9.618
    88.000     9.636
    89.000     9.643
    90.000     9.647
    91.000     9.651
    92.000     9.654
    93.000     9.656
    94.000     9.658
    95.000     9.661
    96.000     9.664
    97.000     9.668
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000     9.668  30
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    10.902
    26.000    10.921
    27.000    10.944
    28.000    10.976
    29.000    10.996
    30.000    11.010
    31.000    11.023
    32.000    11.037
    33.000    11.055
    34.000    11.079
    35.000    11.104
    36.000    11.129
    37.000    11.154
    38.000    11.180
    39.000    11.206
    40.000    11.233
    41.000    11.260
    42.000    11.286
    43.000    11.313
    44.000    11.340
    45.000    11.366
    46.000    11.393
    47.000    11.419
    48.000    11.446
    49.000    11.471
    50.000    11.497
    51.000    11.523
    52.000    11.548
    53.000    11.572
    54.000    11.596
    55.000    11.621
    56.000    11.645
    57.000    11.669
    58.000    11.692
    59.000    11.715
    60.000    11.738
    61.000    11.761
    62.000    11.783
    63.000    11.805
    64.000    11.826
    65.000    11.847
    66.000    11.868
    67.000    11.888
    68.000    11.909
    69.000    11.929
    70.000    11.949
    71.000    11.968
    72.000    11.988
    73.000    12.007
    74.000    12.026
    75.000    12.046
    76.000    12.064
    77.000    12.082
    78.000    12.100
    79.000    12.117
    80.000    12.135
    81.000    12.153
    82.000    12.171
    83.000    12.188
    84.000    12.205
    85.000    12.223
    86.000    12.239
    87.000    12.255
    88.000    12.280
    89.000    12.290
    90.000    12.297
    91.000    12.302
    92.000    12.305
    93.000    12.308
    94.000    12.311
    95.000    12.315
    96.000    12.320
    97.000    12.325
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    12.325  40
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000     4.289
    26.000     4.292
    27.000     4.296
    28.000     4.302
    29.000     4.305
    30.000     4.307
    31.000     4.310
    32.000     4.312
    33.000     4.315
    34.000     4.319
    35.000     4.323
    36.000     4.328
    37.000     4.332
    38.000     4.336
    39.000     4.341
    40.000     4.345
    41.000     4.350
    42.000     4.354
    43.000     4.359
    44.000     4.364
    45.000     4.368
    46.000     4.373
    47.000     4.377
    48.000     4.382
    49.000     4.387
    50.000     4.391
    51.000     4.395
    52.000     4.400
    53.000     4.404
    54.000     4.408
    55.000     4.412
    56.000     4.417
    57.000     4.421
    58.000     4.425
    59.000     4.429
    60.000     4.433
    61.000     4.437
    62.000     4.441
    63.000     4.445
    64.000     4.448
    65.000     4.452
    66.000     4.456
    67.000     4.459
    68.000     4.463
    69.000     4.466
    70.000     4.470
    71.000     4.473
    72.000     4.477
    73.000     4.480
    74.000     4.484
    75.000     4.487
    76.000     4.490
    77.000     4.493
    78.000     4.497
    79.000     4.500
    80.000     4.503
    81.000     4.506
    82.000     4.509
    83.000     4.512
    84.000     4.515
    85.000     4.518
    86.000     4.521
    87.000     4.524
    88.000     4.529
    89.000     4.531
    90.000     4.532
    91.000     4.533
    92.000     4.533
    93.000     4.534
    94.000     4.534
    95.000     4.535
    96.000     4.536
    97.000     4.537
    98.000     4.538
    99.000     4.539
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000     4.539  10
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000     8.577
    26.000     8.583
    27.000     8.591
    28.000     8.602
    29.000     8.609
    30.000     8.614
    31.000     8.618
    32.000     8.623
    33.000     8.629
    34.000     8.637
    35.000     8.646
    36.000     8.654
    37.000     8.663
    38.000     8.672
    39.000     8.681
    40.000     8.690
    41.000     8.699
    42.000     8.708
    43.000     8.717
    44.000     8.726
    45.000     8.736
    46.000     8.745
    47.000     8.754
    48.000     8.763
    49.000     8.772
    50.000     8.781
    51.000     8.790
    52.000     8.799
    53.000     8.807
    54.000     8.815
    55.000     8.824
    56.000     8.832
    57.000     8.841
    58.000     8.849
    59.000     8.857
    60.000     8.865
    61.000     8.873
    62.000     8.881
    63.000     8.888
    64.000     8.896
    65.000     8.903
    66.000     8.911
    67.000     8.918
    68.000     8.925
    69.000     8.932
    70.000     8.939
    71.000     8.946
    72.000     8.953
    73.000     8.960
    74.000     8.967
    75.000     8.973
    76.000     8.980
    77.000     8.986
    78.000     8.993
    79.000     8.999
    80.000     9.005
    81.000     9.012
    82.000     9.018
    83.000     9.024
    84.000     9.030
    85.000     9.037
    86.000     9.042
    87.000     9.048
    88.000     9.057
    89.000     9.061
    90.000     9.063
    91.000     9.065
    92.000     9.066
    93.000     9.067
    94.000     9.068
    95.000     9.070
    96.000     9.071
    97.000     9.073
    98.000     9.075
    99.000     9.077
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000     9.077  20
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    12.342
    26.000    12.352
    27.000    12.365
    28.000    12.382
    29.000    12.392
    30.000    12.400
    31.000    12.407
    32.000    12.414
    33.000    12.424
    34.000    12.437
    35.000    12.450
    36.000    12.464
    37.000    12.477
    38.000    12.491
    39.000    12.505
    40.000    12.520
    41.000    12.534
    42.000    12.549
    43.000    12.563
    44.000    12.578
    45.000    12.592
    46.000    12.607
    47.000    12.621
    48.000    12.635
    49.000    12.649
    50.000    12.664
    51.000    12.678
    52.000    12.691
    53.000    12.704
    54.000    12.718
    55.000    12.731
    56.000    12.744
    57.000    12.757
    58.000    12.770
    59.000    12.783
    60.000    12.795
    61.000    12.808
    62.000    12.820
    63.000    12.832
    64.000    12.844
    65.000    12.855
    66.000    12.867
    67.000    12.878
    68.000    12.889
    69.000    12.901
    70.000    12.912
    71.000    12.923
    72.000    12.933
    73.000    12.944
    74.000    12.955
    75.000    12.965
    76.000    12.976
    77.000    12.986
    78.000    12.996
    79.000    13.005
    80.000    13.015
    81.000    13.025
    82.000    13.035
    83.000    13.045
    84.000    13.054
    85.000    13.064
    86.000    13.073
    87.000    13.082
    88.000    13.096
    89.000    13.102
    90.000    13.105
    91.000    13.108
    92.000    13.110
    93.000    13.112
    94.000    13.114
    95.000    13.116
    96.000    13.119
    97.000    13.122
    98.000    13.125
    99.000    13.128
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    13.128  30
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    15.728
    26.000    15.743
    27.000    15.760
    28.000    15.785
    29.000    15.800
    30.000    15.810
    31.000    15.820
    32.000    15.831
    33.000    15.845
    34.000    15.863
    35.000    15.882
    36.000    15.901
    37.000    15.921
    38.000    15.940
    39.000    15.961
    40.000    15.981
    41.000    16.002
    42.000    16.022
    43.000    16.043
    44.000    16.063
    45.000    16.084
    46.000    16.104
    47.000    16.125
    48.000    16.145
    49.000    16.165
    50.000    16.185
    51.000    16.205
    52.000    16.224
    53.000    16.242
    54.000    16.261
    55.000    16.280
    56.000    16.299
    57.000    16.317
    58.000    16.335
    59.000    16.353
    60.000    16.371
    61.000    16.389
    62.000    16.406
    63.000    16.423
    64.000    16.439
    65.000    16.456
    66.000    16.472
    67.000    16.488
    68.000    16.504
    69.000    16.519
    70.000    16.535
    71.000    16.550
    72.000    16.565
    73.000    16.581
    74.000    16.596
    75.000    16.611
    76.000    16.625
    77.000    16.639
    78.000    16.653
    79.000    16.667
    80.000    16.681
    81.000    16.695
    82.000    16.709
    83.000    16.722
    84.000    16.735
    85.000    16.750
    86.000    16.762
    87.000    16.775
    88.000    16.795
    89.000    16.802
    90.000    16.807
    91.000    16.811
    92.000    16.814
    93.000    16.816
    94.000    16.819
    95.000    16.822
    96.000    16.826
    97.000    16.830
    98.000    16.834
    99.000    16.839
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    16.839  40
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.902     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.058     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.338     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.313     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.182     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.579     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.357     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    57.181     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.018     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.486     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.942    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.141     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    85.443     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    87.088     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.878     7.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.065     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.807     5.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.923     7.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.106     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    57.124     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.339     7.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.339    10.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    75.743     6.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    75.836     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    76.229     6.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    76.671     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    77.261     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    83.076     8.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    83.878     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.570     4.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    76.399     4.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    85.289     4.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    85.400     5.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.268    10.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.860    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.434     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.980     4.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.009     6.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.334     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.560     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.921     4.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.142     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.946     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.131    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    46.606    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.644     8.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.709     4.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.578     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.714     4.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.696     6.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.887     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    42.114     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    44.022     5.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    44.268     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.165     5.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.168     5.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.926     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.437     7.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.013     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.038     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.121     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.189     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.188     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.188     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.579     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    56.637     7.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    57.234     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    57.295     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.598     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.688     8.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    59.365     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.731     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.136     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.102     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.149     6.621     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.895     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.132     6.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.222     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    49.994     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.898     3.080     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.879     6.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.842     6.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.842     6.369     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.920     8.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.997     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.305     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.318     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.814     7.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    56.076     8.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.377     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.538     6.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    56.962     6.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.099     5.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.290     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.303     6.658     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.304     6.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.395     6.670     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.585     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.154     7.488     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.358     7.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.193     6.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.414     7.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.053     6.621     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.809     7.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.430     6.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.539     7.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.319     6.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.467     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.724     7.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.135     7.350     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.289     7.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    75.419     8.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    75.455     7.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    75.480     7.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    76.000     7.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.535     8.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    77.752     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    77.987     8.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.174     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.539     6.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.982     8.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.087     7.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.857     6.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.923     7.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    85.183     6.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    85.661     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    86.210     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    87.664     8.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    88.864     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    88.998     7.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    89.200     6.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    90.438     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    94.625     7.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    95.624     6.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    42.540     8.395     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.072     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.072    12.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.629     4.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    40.996     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.732     6.387     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.751     7.332     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.537     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.611     5.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.611     5.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.602     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.874     5.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.800     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.587     5.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.737     4.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.911     3.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.257     3.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.278     3.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.487     4.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.889     4.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.902     4.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.979     4.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.282     5.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.300     4.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.400     3.598     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.016     3.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.058     4.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.358     3.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.945     4.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.945     4.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.732     6.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.030     6.990     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.444     5.125     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.605     6.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.463     3.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.734     5.650     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.719     5.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.026     5.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.391     5.650     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.396     5.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.676     4.924     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.008     6.010     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.225     5.539     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.359     5.920     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.932     5.330     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.372     5.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.324     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.765     6.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.897     4.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.920     5.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.538     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.558     5.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.558     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.643     5.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.643     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.643     8.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.946     4.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.724     5.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.003     5.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.126     5.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.156     5.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.161     5.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.606     5.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.606     5.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.612     5.770     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.075     4.361     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.003     6.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.424     6.230     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.472     6.051     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.932     5.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.193     5.689     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.202     6.719     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.649     5.824     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.049     5.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.920     7.170     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.494     5.650     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.586     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.271     5.859     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.323     5.820     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.939     6.359     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.948     5.779     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.105     5.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.113     6.221     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.197     5.818     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.259     6.361     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.446     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.187     6.049     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.243     6.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.447     6.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.643     6.270     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.253     5.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.620     6.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.953     6.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.914     6.270     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.542     6.090     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.702     6.670     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.557     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    77.557     8.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.564     5.625     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.057     6.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.200     6.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.542     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.640     6.141     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.147     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.232     6.176     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.328     6.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.751     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.780     6.359     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    89.398     6.674     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    89.890     6.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    90.982     5.871     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    90.982     5.725     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.317     3.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.251     7.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    41.457     9.406     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.535     7.305     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.807     9.594     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.141     5.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.806     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.943     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.204     5.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.271     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.551     9.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.694     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.825     6.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.825     9.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.870     6.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.870     9.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.908     6.305     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.908     9.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.919     6.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.919     9.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.955     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.955     9.695     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.029     6.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.029     9.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.258     5.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.293     6.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.293     9.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.409     9.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.410     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.451     6.305     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.451     9.406     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.564     6.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.564     9.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.298     6.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.711     6.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    26.413     2.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.371     2.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.468     2.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.822     4.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.826     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.848     4.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.930     4.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.990     9.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.335     8.305     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.376     7.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.483     5.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.959     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    51.701     3.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.606     2.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    85.372     1.710     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.979     5.900     0.200
EOF
# Legend
gmt text $proj $reg -F+f12p,Helvetica,green+a0.+jBL << EOF
    26.000    18.800 Green for pP-P
EOF
gmt text $proj $reg -F+f12p,Helvetica,red+a0.+jBL << EOF
    26.000    17.600 Red for sP-P
EOF
gmt end
