#!/bin/bash
gmt begin novy1.66_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases novy1.66'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    -2.515
     2.500    -2.671
     3.000    -2.827
     3.500    -2.983
     4.000    -3.139
     4.500    -3.295
     5.000    -3.452
     5.500    -3.608
     6.000    -3.764
     6.500    -3.920
     7.000    -4.076
     7.500    -4.232
     8.000    -4.388
     8.500    -4.545
     9.000    -4.701
     9.500    -4.857
    10.000    -5.013
    10.500    -5.169
    11.000    -5.325
    11.500    -5.481
    12.000    -5.638
    12.500    -5.794
    13.000    -5.950
    13.500    -6.106
    14.000    -6.262
    14.500    -6.418
    15.000    -6.575
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000    -2.950 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000     5.545
     1.500     1.566
     2.000    -2.413
     2.500    -6.392
     3.000   -10.371
     3.500   -14.351
     4.000   -18.333
     4.500   -22.316
     5.000   -26.300
     5.500   -30.286
     6.000   -34.276
     6.500   -38.266
     7.000   -42.260
     7.500   -46.256
     8.000   -50.255
     8.500   -54.258
     9.000   -58.263
     9.500   -62.273
    10.000   -66.286
    10.500   -70.303
    11.000   -74.326
    11.500   -78.352
    12.000   -82.383
    12.500   -86.419
    13.000   -90.460
    13.500   -94.508
    14.000   -98.560
    14.500  -102.619
    15.000  -106.684
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -87.460 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     0.796
     1.000     1.131
     1.500     0.055
     2.000    -1.211
     2.500    -2.477
     3.000    -3.745
     3.500    -5.014
     4.000    -6.285
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000    -9.285 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.438    -2.962     0.200
     3.643    -0.990     0.200
     2.229    -2.949     0.200
     2.372    -1.870     0.200
     2.275    -1.591     0.200
     2.758    -0.309     0.200
     3.068     0.841     0.200
     4.190    -1.612     0.200
     4.190    -1.409     0.200
     4.297    -3.316     0.200
     5.429    -2.693     0.200
     5.820    -1.870     0.200
     6.645    -3.139     0.200
     8.473    -5.870     0.200
     2.307    -3.468     0.200
     3.135     1.877     0.200
     4.321    -2.516     0.200
     5.503    -5.988     0.200
     5.890    -2.657     0.200
     6.794    -3.489     0.200
     6.794    -7.290     0.200
     7.879    -6.786     0.200
     8.546    -6.728     0.200
     8.736    -7.066     0.200
     8.736    -7.566     0.200
     8.852    -5.037     0.200
     3.509    -2.434     0.200
     4.335    -4.605     0.200
     5.253    -4.413     0.200
     5.632    -1.710     0.200
     6.359    -6.750     0.200
     7.232    -7.442     0.200
     7.232    -7.542     0.200
     2.165    -3.505     0.200
     3.738    -3.248     0.200
     4.224    -1.873     0.200
     6.208    -3.138     0.200
     2.467    -3.437     0.200
     3.036    -1.665     0.200
     3.713    -1.409     0.200
     3.707    -2.542     0.200
     3.707    -1.746     0.200
     4.392    -4.442     0.200
     4.713    -1.110     0.200
     4.713    -1.610     0.200
     4.781    -5.267     0.200
     4.781    -2.267     0.200
     5.690    -3.598     0.200
     6.351    -7.053     0.200
     6.788    -7.596     0.200
     7.433    -6.341     0.200
     7.433    -4.638     0.200
    21.051   -15.096     0.200
     3.322    -2.395     0.200
     3.666    -2.311     0.200
     5.621    -3.378     0.200
     6.965    -2.891     0.200
     3.181    -1.158     0.200
     4.166    -1.364     0.200
     4.497    -1.660     0.200
     6.300    -5.809     0.200
     7.379    -6.509     0.200
     8.068    -5.867     0.200
     2.870    -3.069     0.200
     2.870    -0.870     0.200
     3.470    -0.871     0.200
     3.595    -1.454     0.200
     4.099    -1.329     0.200
     4.726    -4.189     0.200
     5.852    -2.384     0.200
     6.174    -2.614     0.200
     7.178    -3.918     0.200
     8.861    -4.371     0.200
     9.170    -5.081     0.200
     9.345    -7.334     0.200
     9.438    -2.582     0.200
     2.054    -3.067     0.200
     3.516    -3.399     0.200
     4.244    -4.280     0.200
     4.769    -4.123     0.200
     4.836    -3.137     0.200
     4.836    -2.937     0.200
     5.207    -3.901     0.200
     6.026    -5.386     0.200
     6.026    -4.986     0.200
     6.476    -3.824     0.200
     6.698    -6.984     0.200
     7.089    -4.675     0.200
     3.413    -2.261     0.200
     3.684    -1.663     0.200
     4.134    -1.216     0.200
     4.134    -1.013     0.200
     4.571    -3.093     0.200
     4.571    -3.296     0.200
     4.831    -3.928     0.200
     4.922    -1.992     0.200
     5.831    -5.240     0.200
     6.335    -2.809     0.200
     6.503    -6.415     0.200
     6.898    -4.439     0.200
     7.625    -5.295     0.200
     7.746    -5.226     0.200
     2.104    -3.076     0.200
     2.230    -0.167     0.200
     2.231    -2.107     0.200
     2.665    -2.656     0.200
     3.453    -2.748     0.200
     3.692    -2.317     0.200
     3.692    -2.419     0.200
     4.237    -1.684     0.200
     4.237    -2.481     0.200
     4.613    -4.215     0.200
     4.613    -3.012     0.200
     4.983    -2.634     0.200
     5.062    -3.836     0.200
     5.863    -6.027     0.200
     5.898    -5.851     0.200
     6.434    -4.955     0.200
     6.434    -3.057     0.200
     6.536    -6.172     0.200
     7.668    -5.452     0.200
     7.764    -5.493     0.200
     7.850    -5.214     0.200
     3.299    -1.912     0.200
     3.888    -1.381     0.200
     3.888    -1.580     0.200
     4.093    -3.171     0.200
     4.093    -0.773     0.200
     4.361    -4.170     0.200
     5.500    -2.776     0.200
     5.587    -3.619     0.200
     6.470    -3.406     0.200
     6.811    -4.616     0.200
     7.468    -8.653     0.200
     8.528    -5.166     0.200
     2.120    -1.931     0.200
     2.887    -2.349     0.200
     3.095    -3.163     0.200
     4.100    -4.020     0.200
     4.099    -2.685     0.200
     4.183    -3.144     0.200
     5.101    -2.339     0.200
     5.103    -2.393     0.200
     5.247    -2.868     0.200
     5.381    -2.820     0.200
     5.835    -3.216     0.200
     6.438    -1.930     0.200
     6.537    -6.461     0.200
     6.545    -4.304     0.200
     7.206    -7.184     0.200
     7.637    -5.442     0.200
     8.286    -4.291     0.200
     8.500    -5.688     0.200
     8.635    -7.179     0.200
     2.527    -1.877     0.200
     3.199    -1.880     0.200
     3.288    -2.706     0.200
     3.853    -2.600     0.200
     4.189    -4.552     0.200
     4.189    -2.453     0.200
     4.433    -3.701     0.200
     4.434    -3.713     0.200
     4.448    -3.076     0.200
     4.448    -4.076     0.200
     4.744    -3.650     0.200
     5.094    -3.759     0.200
     5.164    -2.863     0.200
     5.481    -5.904     0.200
     5.695    -4.802     0.200
     5.733    -5.490     0.200
     6.354    -4.090     0.200
     6.369    -5.854     0.200
     6.369    -6.454     0.200
     6.752    -5.015     0.200
     7.503    -6.421     0.200
     7.595    -7.043     0.200
     2.236    -1.771     0.200
     2.835    -0.955     0.200
     2.835    -2.256     0.200
     3.024    -1.252     0.200
     3.985    -2.216     0.200
     3.985    -3.415     0.200
     3.884    -1.421     0.200
     3.884    -2.121     0.200
     4.098    -4.384     0.200
     4.098    -3.884     0.200
     5.042    -4.908     0.200
     5.044    -4.982     0.200
     5.233    -4.278     0.200
     5.774    -3.531     0.200
     6.242    -5.043     0.200
     7.204    -7.144     0.200
     7.650    -6.411     0.200
     8.258    -5.049     0.200
     8.529    -7.766     0.200
     8.697    -7.481     0.200
     2.828    -1.014     0.200
     3.094    -1.333     0.200
     3.094    -1.632     0.200
     3.882    -3.322     0.200
     4.021    -1.812     0.200
     4.021    -2.113     0.200
     4.074    -1.805     0.200
     4.074    -2.704     0.200
     4.131    -3.415     0.200
     5.273    -5.617     0.200
     6.371    -3.129     0.200
     6.563    -4.696     0.200
     7.238    -7.304     0.200
     7.679    -7.774     0.200
     8.695    -6.579     0.200
     2.206    -3.357     0.200
     2.828    -2.751     0.200
     2.828    -1.751     0.200
     2.962    -2.012     0.200
     3.625    -2.919     0.200
     3.625    -2.419     0.200
     3.641    -3.635     0.200
     3.926    -2.676     0.200
     3.926    -2.477     0.200
     3.954    -3.639     0.200
     3.954    -3.139     0.200
     4.852    -2.824     0.200
     5.077    -4.842     0.200
     5.355    -3.271     0.200
     5.401    -3.641     0.200
     5.580    -2.788     0.200
     6.361    -4.870     0.200
     6.405    -5.363     0.200
     8.606    -6.628     0.200
     2.694    -1.295     0.200
     3.486    -2.703     0.200
     3.662    -1.682     0.200
     3.662    -2.382     0.200
     4.250    -0.218     0.200
     4.250    -3.218     0.200
     4.618    -3.900     0.200
     4.646    -3.266     0.200
     4.964    -2.160     0.200
     4.964    -3.859     0.200
     5.058    -4.636     0.200
     5.350    -4.493     0.200
     5.931    -4.606     0.200
     2.449    -1.548     0.200
     2.501    -1.479     0.200
     2.501    -1.377     0.200
     3.241    -3.030     0.200
     3.241    -3.131     0.200
     3.914    -2.586     0.200
     4.203    -2.448     0.200
     4.203    -2.647     0.200
     4.271    -2.480     0.200
     4.401    -4.008     0.200
     4.401    -4.207     0.200
     4.396    -3.543     0.200
     4.826    -4.584     0.200
     4.860    -3.477     0.200
     4.862    -4.835     0.200
     5.154    -2.269     0.200
     5.154    -3.469     0.200
     5.643    -4.691     0.200
     5.643    -5.793     0.200
     5.684    -5.189     0.200
     6.317    -7.167     0.200
     6.317    -6.065     0.200
     6.355    -5.051     0.200
     6.698    -6.014     0.200
     7.456    -8.555     0.200
     7.456    -7.555     0.200
     2.483    -1.226     0.200
     2.483    -0.827     0.200
     2.499    -1.530     0.200
     3.205    -3.306     0.200
     3.205    -2.306     0.200
     3.963    -2.147     0.200
     4.218    -1.425     0.200
     4.218    -3.022     0.200
     4.239    -2.392     0.200
     4.365    -3.979     0.200
     4.365    -4.780     0.200
     4.368    -2.779     0.200
     4.795    -5.018     0.200
     5.202    -3.712     0.200
     5.202    -3.912     0.200
     5.603    -4.143     0.200
     5.647    -5.830     0.200
     6.278    -6.535     0.200
     6.358    -4.577     0.200
     6.358    -3.378     0.200
     6.655    -5.686     0.200
     7.420    -5.428     0.200
     7.487    -5.155     0.200
     9.615    -8.120     0.200
     2.479    -2.081     0.200
     2.517    -1.497     0.200
     2.517    -1.302     0.200
     3.237    -2.216     0.200
     3.941    -2.553     0.200
     3.941    -2.350     0.200
     4.243    -3.620     0.200
     4.243    -2.714     0.200
     4.272    -3.637     0.200
     4.397    -4.187     0.200
     4.397    -4.085     0.200
     4.402    -3.048     0.200
     4.829    -5.173     0.200
     5.196    -3.633     0.200
     5.196    -3.735     0.200
     5.679    -6.131     0.200
     6.309    -4.902     0.200
     6.388    -4.712     0.200
     6.684    -4.292     0.200
     7.452    -4.532     0.200
     7.468    -6.740     0.200
     7.523    -6.691     0.200
     9.637    -9.293     0.200
     2.299    -3.519     0.200
     2.464    -1.537     0.200
     2.512    -1.060     0.200
     3.241    -2.967     0.200
     3.241    -2.666     0.200
     3.927    -2.236     0.200
     3.927    -2.134     0.200
     4.226    -4.715     0.200
     4.226    -2.613     0.200
     4.274    -1.613     0.200
     4.401    -3.242     0.200
     4.401    -3.141     0.200
     4.401    -2.552     0.200
     4.829    -3.333     0.200
     5.131    -3.280     0.200
     5.176    -2.523     0.200
     6.315    -7.719     0.200
     6.315    -6.121     0.200
     6.375    -5.318     0.200
     6.375    -5.115     0.200
     6.692    -5.479     0.200
     7.456    -4.387     0.200
     9.651    -9.267     0.200
     3.224    -3.151     0.200
     3.224    -2.151     0.200
     3.957    -1.768     0.200
     4.261    -2.112     0.200
     4.245    -3.902     0.200
     4.245    -2.701     0.200
     4.384    -2.925     0.200
     4.817    -3.846     0.200
     5.120    -3.457     0.200
     5.210    -2.995     0.200
     5.666    -3.257     0.200
     6.296    -4.816     0.200
     6.386    -5.592     0.200
     6.386    -5.092     0.200
     6.670    -4.983     0.200
     7.587    -5.755     0.200
     9.622    -7.855     0.200
     2.299    -3.252     0.200
     2.451    -2.587     0.200
     2.451    -2.286     0.200
     2.506    -1.035     0.200
     2.506    -2.236     0.200
     3.243    -4.301     0.200
     3.243    -3.602     0.200
     3.915    -1.709     0.200
     3.915    -3.510     0.200
     4.211    -2.673     0.200
     4.211    -3.071     0.200
     4.274    -3.977     0.200
     4.403    -4.977     0.200
     4.400    -4.859     0.200
     4.830    -3.486     0.200
     5.130    -4.695     0.200
     5.158    -4.009     0.200
     5.158    -3.609     0.200
     5.687    -6.351     0.200
     6.319    -6.016     0.200
     6.319    -6.616     0.200
     6.699    -6.037     0.200
     2.314    -2.927     0.200
     2.506    -2.200     0.200
     2.506    -1.496     0.200
     3.158    -1.376     0.200
     3.224    -3.054     0.200
     3.953    -1.991     0.200
     3.953    -2.491     0.200
     4.238    -1.913     0.200
     4.238    -3.311     0.200
     4.259    -1.591     0.200
     4.389    -3.909     0.200
     4.384    -4.532     0.200
     4.384    -5.133     0.200
     4.815    -3.222     0.200
     5.118    -3.116     0.200
     5.204    -3.925     0.200
     5.621    -3.845     0.200
     5.621    -4.142     0.200
     5.666    -3.968     0.200
     6.296    -7.043     0.200
     6.380    -2.228     0.200
     6.380    -4.627     0.200
     6.671    -4.242     0.200
     7.439    -4.580     0.200
     7.439    -8.080     0.200
     7.589    -5.358     0.200
     8.497    -7.716     0.200
    16.351    -4.509     0.200
    20.191    -3.380     0.200
     2.301    -2.749     0.200
     2.462    -1.445     0.200
     2.462    -2.047     0.200
     2.509    -1.629     0.200
     2.509    -1.332     0.200
     3.239    -3.402     0.200
     3.926    -3.454     0.200
     3.926    -0.555     0.200
     4.221    -2.322     0.200
     4.272    -1.631     0.200
     4.400    -4.475     0.200
     4.400    -5.373     0.200
     4.399    -3.258     0.200
     4.828    -3.247     0.200
     4.862    -4.127     0.200
     4.862    -4.026     0.200
     5.172    -4.468     0.200
     5.172    -4.273     0.200
     5.129    -3.480     0.200
     5.640    -4.386     0.200
     5.682    -5.036     0.200
     6.314    -5.772     0.200
     6.370    -2.743     0.200
     6.692    -5.452     0.200
     7.455    -5.221     0.200
     7.455    -7.026     0.200
     7.533    -5.191     0.200
     7.615    -6.299     0.200
     8.471    -4.515     0.200
    20.219    -1.860     0.200
     3.206    -2.476     0.200
     3.206    -3.273     0.200
     3.980    -3.236     0.200
     3.980    -0.834     0.200
     4.250    -3.376     0.200
     4.366    -3.545     0.200
     4.366    -3.947     0.200
     4.377    -3.189     0.200
     4.801    -4.639     0.200
     5.105    -4.190     0.200
     5.232    -3.419     0.200
     5.232    -4.517     0.200
     5.600    -3.275     0.200
     5.647    -4.663     0.200
     6.276    -7.088     0.200
     6.386    -4.897     0.200
     6.386    -3.698     0.200
     6.649    -4.214     0.200
     6.649    -4.515     0.200
     7.421    -4.989     0.200
     7.421    -7.590     0.200
     7.487    -5.691     0.200
     7.564    -5.526     0.200
     8.517    -2.856     0.200
    15.301    -0.559     0.200
     2.443    -1.572     0.200
     2.500    -1.191     0.200
     2.500    -2.386     0.200
     3.164    -1.018     0.200
     3.243    -3.248     0.200
     3.908    -4.015     0.200
     3.908    -2.116     0.200
     4.198    -1.910     0.200
     4.198    -3.808     0.200
     4.273    -2.369     0.200
     4.404    -4.523     0.200
     4.397    -3.503     0.200
     4.828    -4.063     0.200
     5.146    -3.850     0.200
     5.146    -3.748     0.200
     5.687    -5.304     0.200
     6.321    -6.399     0.200
     6.321    -7.102     0.200
     6.351    -4.761     0.200
     6.702    -4.672     0.200
     7.459    -5.769     0.200
     7.544    -5.065     0.200
     7.597    -4.956     0.200
     9.670    -7.867     0.200
     2.499    -3.544     0.200
     2.659    -2.319     0.200
     2.659    -2.523     0.200
     3.082    -1.208     0.200
     3.082    -1.411     0.200
     3.326    -1.758     0.200
     3.326    -3.359     0.200
     3.489    -1.039     0.200
     3.854    -3.387     0.200
     3.825    -1.472     0.200
     3.825    -1.769     0.200
     4.686    -4.081     0.200
     4.683    -2.560     0.200
     4.956    -4.534     0.200
     4.956    -5.335     0.200
     5.198    -3.594     0.200
     5.246    -1.336     0.200
     5.405    -1.950     0.200
     5.689    -3.779     0.200
     6.234    -2.837     0.200
     6.234    -7.037     0.200
     6.300    -6.635     0.200
     6.939    -3.687     0.200
     7.436    -7.144     0.200
     7.436    -7.644     0.200
     7.940    -5.029     0.200
     8.326    -7.069     0.200
     8.497    -5.014     0.200
     8.564    -7.910     0.200
     2.126    -3.557     0.200
     2.860    -1.806     0.200
     2.934    -2.647     0.200
     3.696    -2.611     0.200
     3.696    -2.111     0.200
     3.871    -1.552     0.200
     3.871    -1.851     0.200
     3.747    -1.528     0.200
     4.938    -1.687     0.200
     4.958    -3.022     0.200
     5.181    -6.081     0.200
     5.181    -5.281     0.200
     5.461    -2.965     0.200
     5.686    -2.883     0.200
     6.062    -4.014     0.200
     6.062    -4.214     0.200
     6.466    -5.823     0.200
     6.466    -6.123     0.200
     7.158    -8.444     0.200
     8.191    -2.715     0.200
     8.507    -5.931     0.200
     8.701    -5.866     0.200
     9.059    -2.832     0.200
     2.611    -0.738     0.200
     3.253    -2.785     0.200
     3.861    -1.658     0.200
     4.027    -1.720     0.200
     4.328    -3.265     0.200
     5.274    -2.952     0.200
     5.465    -4.390     0.200
     6.004    -4.088     0.200
     6.405    -3.579     0.200
     6.753    -4.035     0.200
     7.435    -4.538     0.200
     2.466    -1.302     0.200
     2.466    -0.602     0.200
     2.499    -0.962     0.200
     2.499    -1.162     0.200
     3.232    -1.466     0.200
     3.930    -3.421     0.200
     3.930    -2.421     0.200
     4.214    -3.203     0.200
     4.214    -2.804     0.200
     4.263    -2.383     0.200
     4.392    -3.742     0.200
     4.392    -3.542     0.200
     4.390    -3.196     0.200
     5.120    -4.229     0.200
     5.172    -3.193     0.200
     5.172    -2.693     0.200
     5.674    -5.710     0.200
     6.307    -6.355     0.200
     6.307    -5.656     0.200
     6.362    -5.591     0.200
     6.362    -5.091     0.200
     6.685    -6.351     0.200
     7.447    -3.691     0.200
     7.526    -8.507     0.200
     7.609    -7.244     0.200
     9.648    -8.162     0.200
     2.459    -3.313     0.200
     2.783    -1.081     0.200
     2.783    -2.984     0.200
     2.954    -1.825     0.200
     2.954    -1.926     0.200
     3.358    -3.037     0.200
     3.616    -1.288     0.200
     3.702    -2.720     0.200
     3.702    -2.821     0.200
     3.987    -3.355     0.200
     3.987    -3.554     0.200
     4.804    -2.669     0.200
     5.087    -5.326     0.200
     5.087    -5.724     0.200
     5.322    -2.186     0.200
     5.371    -2.443     0.200
     5.525    -2.507     0.200
     5.738    -4.576     0.200
     5.986    -3.224     0.200
     6.363    -4.289     0.200
     6.432    -6.573     0.200
     7.070    -7.689     0.200
     7.070    -6.787     0.200
     7.569    -6.423     0.200
     7.569    -7.622     0.200
     8.066    -8.480     0.200
     8.460    -7.568     0.200
     8.700    -6.650     0.200
     2.105    -3.113     0.200
     2.679    -1.116     0.200
     3.355    -0.837     0.200
     3.441    -2.781     0.200
     3.735    -2.483     0.200
     3.992    -2.222     0.200
     4.287    -1.597     0.200
     4.601    -4.055     0.200
     4.589    -4.360     0.200
     5.045    -2.124     0.200
     5.045    -2.925     0.200
     5.320    -3.325     0.200
     6.476    -3.567     0.200
     6.897    -5.220     0.200
     7.737    -6.243     0.200
     7.814    -8.096     0.200
     2.371    -3.250     0.200
     2.371    -3.148     0.200
     3.108    -1.326     0.200
     3.165    -2.025     0.200
     3.740    -2.257     0.200
     4.019    -1.593     0.200
     4.019    -1.992     0.200
     4.237    -2.505     0.200
     4.237    -2.606     0.200
     4.325    -3.898     0.200
     4.338    -4.111     0.200
     5.066    -3.404     0.200
     5.257    -2.761     0.200
     5.257    -2.964     0.200
     5.559    -4.513     0.200
     5.606    -5.113     0.200
     6.364    -4.557     0.200
     6.364    -4.354     0.200
     6.607    -5.255     0.200
     6.607    -7.950     0.200
     7.380    -6.841     0.200
     7.446    -5.837     0.200
     2.332    -4.005     0.200
     3.366    -3.177     0.200
     4.094    -1.880     0.200
     4.297    -2.492     0.200
     4.364    -1.925     0.200
     5.513    -5.036     0.200
     5.853    -2.234     0.200
     6.106    -3.441     0.200
     6.657    -3.208     0.200
     7.893    -4.900     0.200
     8.872    -5.538     0.200
     2.357    -3.456     0.200
     2.357    -3.058     0.200
     2.352    -1.095     0.200
     2.352    -3.095     0.200
     2.801    -2.553     0.200
     2.801    -2.053     0.200
     2.948    -2.889     0.200
     2.948    -2.690     0.200
     3.463    -2.217     0.200
     3.628    -1.950     0.200
     3.628     1.750     0.200
     3.782    -1.353     0.200
     3.782    -1.955     0.200
     3.977    -4.310     0.200
     4.261    -3.632     0.200
     4.826    -3.127     0.200
     5.086    -5.582     0.200
     2.838    -0.904     0.200
     2.838    -1.404     0.200
     3.128    -0.697     0.200
     3.566    -1.560     0.200
     3.566    -1.458     0.200
     3.494    -2.783     0.200
     3.494    -2.682     0.200
     4.086    -2.239     0.200
     4.086    -1.637     0.200
     4.384    -1.399     0.200
     4.694    -2.422     0.200
     4.694    -2.125     0.200
     5.021    -1.902     0.200
     5.576    -1.399     0.200
     5.591    -3.155     0.200
     5.820    -3.732     0.200
     5.820    -3.533     0.200
     5.844    -3.591     0.200
     5.762    -3.571     0.200
     5.786    -1.952     0.200
     6.144    -1.299     0.200
     6.193    -1.836     0.200
     6.409    -5.285     0.200
     7.106    -5.678     0.200
     7.796    -7.895     0.200
     8.830    -4.244     0.200
     8.830    -3.841     0.200
     9.138    -6.401     0.200
     9.313    -5.748     0.200
     9.646    -2.960     0.200
    11.400   -10.197     0.200
    17.129    -8.099     0.200
     2.544    -1.359     0.200
     3.211    -0.786     0.200
     3.292    -2.866     0.200
     3.866    -2.842     0.200
     3.866    -2.249     0.200
     4.220    -2.974     0.200
     4.321    -3.675     0.200
     4.452    -2.742     0.200
     4.444    -3.180     0.200
     4.756    -3.671     0.200
     4.797    -3.460     0.200
     5.121    -2.637     0.200
     6.369    -7.216     0.200
     6.382    -3.703     0.200
     7.675    -8.401     0.200
     2.484    -0.676     0.200
     2.484    -0.778     0.200
     3.143    -0.953     0.200
     3.217    -2.524     0.200
     3.939    -2.913     0.200
     3.939    -2.812     0.200
     4.249    -2.718     0.200
     4.378    -3.995     0.200
     4.375    -2.325     0.200
     4.689    -2.761     0.200
     4.870    -2.809     0.200
     5.174    -3.843     0.200
     5.619    -3.848     0.200
     6.293    -6.430     0.200
     6.293    -6.633     0.200
     6.348    -3.555     0.200
     6.673    -6.056     0.200
     6.673    -5.954     0.200
     7.433    -7.343     0.200
     7.514    -7.125     0.200
     7.599    -6.315     0.200
     2.325    -3.476     0.200
     3.187    -1.899     0.200
     3.961    -2.661     0.200
     4.032    -2.104     0.200
     4.243    -3.097     0.200
     5.383    -4.513     0.200
     5.474    -3.215     0.200
     5.696    -3.442     0.200
     5.935    -2.341     0.200
     6.398    -5.096     0.200
     7.350    -4.681     0.200
     8.818    -6.505     0.200
     2.233    -1.004     0.200
     2.844    -1.967     0.200
     2.844    -1.367     0.200
     3.010    -1.738     0.200
     3.751    -4.222     0.200
     3.811    -2.306     0.200
     3.868    -1.919     0.200
     3.982    -2.251     0.200
     3.982    -3.950     0.200
     4.087    -4.468     0.200
     4.087    -3.468     0.200
     5.222    -5.441     0.200
     5.222    -4.441     0.200
     5.297    -4.240     0.200
     5.525    -3.154     0.200
     6.538    -5.967     0.200
     8.520    -5.898     0.200
     8.690    -8.274     0.200
     9.172    -1.345     0.200
    16.550    -8.411     0.200
    20.844    -4.106     0.200
     2.296    -3.170     0.200
     3.291    -3.212     0.200
     3.291    -1.912     0.200
     3.625    -1.005     0.200
     4.072    -2.565     0.200
     4.082    -2.585     0.200
     4.082    -2.185     0.200
     4.218    -1.289     0.200
     4.218    -0.489     0.200
     4.301    -3.931     0.200
     4.301    -3.531     0.200
     5.448    -5.486     0.200
     5.448    -4.886     0.200
     5.577    -3.297     0.200
     5.783    -3.608     0.200
     5.825    -3.454     0.200
     6.033    -3.338     0.200
     6.310    -3.506     0.200
     6.308    -4.663     0.200
     6.413    -3.874     0.200
     6.576    -2.542     0.200
     6.738    -6.281     0.200
     6.745    -4.899     0.200
     6.745    -5.599     0.200
     7.407    -8.282     0.200
     7.407    -5.891     0.200
     7.836    -5.989     0.200
     7.836    -7.189     0.200
     8.486    -4.103     0.200
     8.486    -5.603     0.200
     8.697    -5.992     0.200
     8.826    -5.369     0.200
     9.487    -0.657     0.200
    21.119     5.573     0.200
    21.345     2.754     0.200
     2.571    -0.185     0.200
     2.776    -2.783     0.200
     2.727    -2.045     0.200
     2.885    -3.247     0.200
     3.675    -3.886     0.200
     3.710    -0.290     0.200
     3.881    -3.805     0.200
     3.881    -4.101     0.200
     4.111    -2.701     0.200
     4.247    -2.116     0.200
     4.297    -2.596     0.200
     4.541    -3.724     0.200
     5.166    -2.654     0.200
     5.166    -3.855     0.200
     5.166    -5.660     0.200
     5.170    -4.086     0.200
     5.758    -4.522     0.200
     5.758    -3.928     0.200
     5.831    -5.619     0.200
     5.831    -7.017     0.200
     6.007    -4.996     0.200
     6.257    -5.943     0.200
     6.929    -3.444     0.200
     7.123    -5.179     0.200
     7.123    -7.679     0.200
     8.139     0.064     0.200
    15.278    -4.197     0.200
    17.428    -3.729     0.200
    19.998    -2.937     0.200
    20.090    -5.867     0.200
    21.246     0.362     0.200
    21.246     0.360     0.200
    26.882    -8.469     0.200
     2.107    -2.762     0.200
     2.663    -1.803     0.200
     3.360    -3.794     0.200
     3.349    -1.738     0.200
     3.698    -2.712     0.200
     3.698    -2.512     0.200
     4.240    -2.972     0.200
     4.609    -5.980     0.200
     4.630    -3.151     0.200
     4.892    -3.561     0.200
     4.990    -3.549     0.200
     5.058    -3.926     0.200
     5.894    -5.914     0.200
     6.436    -6.199     0.200
     6.531    -7.422     0.200
     3.303    -2.040     0.200
     3.605    -1.431     0.200
     4.062    -1.710     0.200
     4.062    -2.108     0.200
     4.216    -0.281     0.200
     4.317    -2.990     0.200
     4.498    -2.223     0.200
     5.260    -2.578     0.200
     5.463    -4.130     0.200
     5.590    -3.533     0.200
     5.839    -3.444     0.200
     6.046    -2.794     0.200
     6.289    -3.107     0.200
     6.753    -3.922     0.200
     7.423    -5.756     0.200
     7.853    -5.787     0.200
     8.501    -6.125     0.200
     8.715    -5.105     0.200
     8.845    -9.624     0.200
     8.845    -5.624     0.200
     2.289    -1.566     0.200
     2.742    -1.338     0.200
     2.742    -1.440     0.200
     3.158    -2.526     0.200
     3.158    -2.928     0.200
     3.658    -3.286     0.200
     4.026    -1.337     0.200
     3.992    -0.975     0.200
     4.210    -2.369     0.200
     4.210    -5.471     0.200
     4.531    -3.759     0.200
     5.133    -2.327     0.200
     5.350    -4.308     0.200
     5.446    -4.043     0.200
     5.906    -2.645     0.200
     6.387    -2.800     0.200
     6.310    -3.159     0.200
     6.659    -4.002     0.200
     7.317    -6.554     0.200
     7.761    -5.738     0.200
     8.380    -5.751     0.200
     8.629    -5.165     0.200
     8.782    -5.800     0.200
     3.314    -1.425     0.200
     3.438    -1.645     0.200
     3.774    -1.480     0.200
     3.774    -1.883     0.200
     4.026    -2.393     0.200
     4.026    -2.690     0.200
     4.304    -2.194     0.200
     4.405    -3.090     0.200
     4.405    -4.188     0.200
     5.308    -1.232     0.200
     5.538    -4.626     0.200
     5.881    -2.578     0.200
     6.066    -2.257     0.200
     6.102    -3.488     0.200
     6.148    -2.953     0.200
     6.413    -3.548     0.200
     6.413    -3.845     0.200
     6.826    -4.246     0.200
     6.856    -6.093     0.200
     6.856    -4.991     0.200
     6.856    -4.593     0.200
     7.510    -8.242     0.200
     7.510    -5.836     0.200
     7.621    -6.760     0.200
     7.621    -2.459     0.200
     7.965    -7.846     0.200
     8.559    -6.488     0.200
     8.837    -7.004     0.200
     9.002    -7.811     0.200
     9.227    -4.266     0.200
    17.806    -9.620     0.200
    20.415    -9.324     0.200
     3.299    -1.734     0.200
     3.299    -3.140     0.200
     3.609    -0.861     0.200
     4.081    -2.735     0.200
     4.064    -1.788     0.200
     4.064    -2.288     0.200
     4.213    -1.925     0.200
     4.213     0.075     0.200
     4.313    -4.184     0.200
     4.313    -4.286     0.200
     4.725    -2.148     0.200
     5.256    -3.769     0.200
     5.459    -5.422     0.200
     5.459    -6.219     0.200
     5.835    -1.440     0.200
     5.867    -2.945     0.200
     6.042    -3.288     0.200
     6.370    -3.894     0.200
     6.292    -3.005     0.200
     6.574    -3.142     0.200
     6.749    -5.917     0.200
     6.757    -5.168     0.200
     7.419    -6.752     0.200
     7.849    -6.079     0.200
     8.497    -4.015     0.200
     8.711    -7.101     0.200
     8.711    -6.703     0.200
     8.841    -6.722     0.200
     2.808    -2.180     0.200
     2.808    -2.281     0.200
     3.466    -3.053     0.200
     3.466    -3.256     0.200
     3.651    -3.204     0.200
     3.651    -3.505     0.200
     4.239    -2.251     0.200
     4.239    -2.849     0.200
     4.398    -4.292     0.200
     4.655    -1.952     0.200
     4.757    -4.070     0.200
     4.790    -3.118     0.200
     4.790    -3.419     0.200
     4.809    -4.531     0.200
     4.809    -6.230     0.200
     5.058    -3.325     0.200
     5.243    -3.286     0.200
     5.255    -4.149     0.200
     5.299    -5.148     0.200
     5.727    -4.632     0.200
     6.096    -5.135     0.200
     6.322    -6.371     0.200
     6.480    -4.387     0.200
     6.741    -6.565     0.200
     7.092    -5.394     0.200
     7.134    -7.331     0.200
     7.863    -7.225     0.200
     7.981    -6.965     0.200
     8.073    -6.201     0.200
     9.068    -2.778     0.200
    10.737   -11.260     0.200
    13.735    -8.735     0.200
     2.346    -0.580     0.200
     2.704    -1.010     0.200
     2.704    -1.310     0.200
     3.161    -2.912     0.200
     3.161    -0.712     0.200
     3.161    -2.810     0.200
     3.518    -4.739     0.200
     3.615    -2.805     0.200
     3.915    -1.923     0.200
     3.973    -1.844     0.200
     4.234    -3.826     0.200
     4.234    -3.228     0.200
     4.481    -3.142     0.200
     5.146    -2.033     0.200
     5.181    -2.056     0.200
     5.370    -4.248     0.200
     5.370    -6.045     0.200
     5.448    -3.509     0.200
     5.720    -2.840     0.200
     6.275    -3.736     0.200
     6.342    -4.048     0.200
     6.659    -4.090     0.200
     6.898    -5.566     0.200
     7.340    -6.195     0.200
     7.669    -4.399     0.200
     7.791    -7.287     0.200
     8.395    -6.934     0.200
     8.663    -5.309     0.200
     8.824    -6.243     0.200
     9.102    -3.241     0.200
    12.870    -9.895     0.200
     2.717    -1.479     0.200
     2.717    -2.175     0.200
     3.398    -3.068     0.200
     3.478    -2.311     0.200
     3.440    -1.706     0.200
     3.591    -2.377     0.200
     4.083    -3.079     0.200
     4.124    -4.292     0.200
     4.124     0.301     0.200
     4.406    -2.732     0.200
     4.583    -3.949     0.200
     4.737    -1.230     0.200
     4.737    -2.934     0.200
     4.677    -3.420     0.200
     4.747    -3.750     0.200
     4.747    -5.547     0.200
     4.975    -3.265     0.200
     5.298    -4.593     0.200
     5.170    -3.856     0.200
     5.410    -3.869     0.200
     6.018    -5.216     0.200
     6.036    -5.698     0.200
     6.263    -6.409     0.200
     6.687    -6.623     0.200
     6.687    -6.724     0.200
     7.089    -4.885     0.200
     7.799    -5.085     0.200
     8.050    -6.156     0.200
    10.325    -6.065     0.200
     2.268    -3.023     0.200
     2.268    -1.824     0.200
     2.790    -1.968     0.200
     2.790    -2.371     0.200
     3.078    -2.718     0.200
     3.078    -2.820     0.200
     3.547    -3.889     0.200
     3.700    -2.734     0.200
     3.877    -3.225     0.200
     3.931    -2.333     0.200
     3.972    -2.058     0.200
     3.972    -1.859     0.200
     4.147    -3.906     0.200
     4.147    -3.707     0.200
     4.519    -2.578     0.200
     4.564    -4.297     0.200
     5.284    -5.135     0.200
     5.828    -2.991     0.200
     6.291    -4.561     0.200
     6.336    -3.884     0.200
     6.390    -3.809     0.200
     6.572    -4.378     0.200
     6.598    -4.683     0.200
     7.254    -5.472     0.200
     7.673    -3.271     0.200
     7.705    -9.264     0.200
     8.576    -8.592     0.200
     8.739    -8.471     0.200
     9.029    -6.140     0.200
     9.243    -1.396     0.200
    12.922    -5.899     0.200
     2.711    -2.011     0.200
     2.711    -2.311     0.200
     3.339    -3.015     0.200
     3.410    -1.946     0.200
     3.525    -1.597     0.200
     3.604    -3.320     0.200
     3.604    -3.219     0.200
     4.050    -2.732     0.200
     4.226    -3.732     0.200
     4.226    -0.732     0.200
     4.226    -0.931     0.200
     4.537    -3.792     0.200
     4.536    -3.447     0.200
     4.646    -4.038     0.200
     4.684    -4.245     0.200
     4.684    -3.444     0.200
     4.902    -3.267     0.200
     4.902    -3.566     0.200
     4.951    -3.605     0.200
     5.126    -3.651     0.200
     5.134    -2.922     0.200
     5.435    -5.663     0.200
     5.603    -4.861     0.200
     5.939    -7.027     0.200
     5.970    -4.317     0.200
     8.974    -3.435     0.200
    13.841    -5.920     0.200
    15.647    -4.219     0.200
    17.151   -10.752     0.200
    17.466    -3.648     0.200
     3.478    -2.534     0.200
     3.818    -3.936     0.200
     3.932    -1.835     0.200
     4.101    -2.980     0.200
     4.075    -2.263     0.200
     4.109    -3.148     0.200
     4.109    -3.447     0.200
     4.514    -4.282     0.200
     4.550    -1.022     0.200
     4.558    -2.870     0.200
     4.806    -1.946     0.200
     5.027    -4.353     0.200
     5.173    -1.369     0.200
     5.173    -1.969     0.200
     5.372    -3.992     0.200
     5.372    -5.293     0.200
     5.396    -3.749     0.200
     5.622    -6.196     0.200
     5.895    -5.255     0.200
     6.045    -3.829     0.200
     6.045    -5.829     0.200
     6.042    -4.833     0.200
     6.042    -6.964     0.200
     7.421    -6.149     0.200
     8.425    -3.957     0.200
    11.437   -14.386     0.200
    14.053    -7.898     0.200
    15.292    -7.709     0.200
    17.319   -12.361     0.200
     2.615    -3.164     0.200
     3.479    -1.863     0.200
     3.819    -2.527     0.200
     3.929    -0.934     0.200
     4.097    -2.542     0.200
     4.076    -2.090     0.200
     4.111    -2.805     0.200
     4.385    -2.880     0.200
     4.516    -4.021     0.200
     4.808    -3.075     0.200
     5.168    -1.708     0.200
     5.168    -2.607     0.200
     5.399    -4.409     0.200
     5.624    -4.159     0.200
     6.045    -5.202     0.200
     6.045    -6.432     0.200
     6.044    -2.960     0.200
     6.448    -6.167     0.200
     7.301    -5.629     0.200
     7.425    -6.147     0.200
     8.426    -1.680     0.200
    11.434   -12.985     0.200
    14.049    -7.162     0.200
    15.297    -4.276     0.200
    17.322   -10.389     0.200
    17.680    -8.976     0.200
     2.769    -1.766     0.200
     3.318    -3.167     0.200
     3.480    -1.713     0.200
     3.500    -2.661     0.200
     3.610    -2.052     0.200
     4.215    -2.532     0.200
     4.431    -3.575     0.200
     4.615    -2.789     0.200
     4.769    -3.673     0.200
     4.807    -2.677     0.200
     5.018    -3.080     0.200
     5.330    -4.377     0.200
     5.449    -4.349     0.200
     5.687    -5.078     0.200
     6.281    -5.120     0.200
     6.701    -6.622     0.200
     7.095    -5.720     0.200
     7.119    -4.265     0.200
     7.822    -5.967     0.200
     7.942    -6.767     0.200
     8.037    -5.676     0.200
    10.078    -8.173     0.200
     3.322    -2.120     0.200
     3.464    -4.301     0.200
     3.452    -2.028     0.200
     3.452     0.072     0.200
     3.812    -1.748     0.200
     4.062    -0.970     0.200
     4.125    -1.081     0.200
     4.323    -1.634     0.200
     4.401    -1.832     0.200
     5.311    -3.072     0.200
     5.344    -1.709     0.200
     5.537    -4.240     0.200
     5.609    -3.397     0.200
     5.840    -5.232     0.200
     5.926    -3.848     0.200
     6.073    -3.934     0.200
     6.120    -3.296     0.200
     6.442    -3.919     0.200
     6.446    -2.831     0.200
     7.065    -3.361     0.200
     7.958    -3.887     0.200
     8.829    -6.992     0.200
    12.289    -9.460     0.200
    12.464    -8.014     0.200
     3.288    -1.750     0.200
     3.480    -2.638     0.200
     3.480    -0.638     0.200
     3.486    -4.111     0.200
     3.821    -2.151     0.200
     4.034    -1.890     0.200
     4.034    -4.487     0.200
     4.092    -2.820     0.200
     4.369    -2.326     0.200
     4.369    -3.826     0.200
     4.348    -3.564     0.200
     5.505    -3.716     0.200
     5.574    -3.924     0.200
     6.039    -4.266     0.200
     6.146    -3.345     0.200
     6.409    -3.886     0.200
     6.416    -2.694     0.200
     6.416    -4.694     0.200
     6.793    -5.748     0.200
     6.820    -6.213     0.200
     6.820    -5.213     0.200
     7.032    -6.240     0.200
     7.475    -5.685     0.200
     7.475    -6.716     0.200
     7.654    -4.250     0.200
     7.927    -7.011     0.200
     8.528    -6.949     0.200
     8.799    -6.735     0.200
     8.959    -5.533     0.200
     9.432    -1.597     0.200
    10.087   -12.109     0.200
    11.039    -9.865     0.200
    12.262    -9.425     0.200
    12.780    -5.099     0.200
     3.295    -1.275     0.200
     3.477    -3.920     0.200
     3.476    -1.207     0.200
     3.824    -1.927     0.200
     4.043    -2.176     0.200
     4.098    -3.531     0.200
     4.346    -2.971     0.200
     4.375    -2.294     0.200
     5.582    -2.152     0.200
     6.047    -4.082     0.200
     6.143    -2.842     0.200
     6.415    -4.872     0.200
     6.425    -2.680     0.200
     6.799    -4.234     0.200
     7.038    -3.219     0.200
     7.481    -4.359     0.200
     7.932    -6.360     0.200
     8.534    -6.146     0.200
     8.803    -6.880     0.200
     8.963    -5.640     0.200
     2.490    -3.811     0.200
     3.300    -1.080     0.200
     3.300    -2.181     0.200
     3.464    -0.808     0.200
     3.489    -3.584     0.200
     3.806    -0.833     0.200
     3.806    -1.138     0.200
     4.035    -1.484     0.200
     4.035    -2.984     0.200
     4.104    -1.681     0.200
     4.332    -1.017     0.200
     4.383    -3.731     0.200
     4.383    -3.434     0.200
     5.290    -2.385     0.200
     5.518    -3.013     0.200
     5.518    -5.810     0.200
     5.586    -2.649     0.200
     5.864    -4.656     0.200
     5.905    -3.673     0.200
     6.130    -2.805     0.200
     6.051    -3.199     0.200
     6.418    -3.234     0.200
     6.418    -3.633     0.200
     6.806    -5.038     0.200
     6.806    -6.640     0.200
     6.834    -5.626     0.200
     6.834    -5.923     0.200
     7.046    -5.633     0.200
     7.489    -6.992     0.200
     7.489    -7.938     0.200
     7.489    -5.992     0.200
     7.646    -3.154     0.200
     7.942    -6.239     0.200
     8.541    -4.329     0.200
     8.813    -6.370     0.200
     8.975    -5.594     0.200
     9.441    -0.331     0.200
     9.466     0.323     0.200
    10.075   -10.705     0.200
    12.278    -9.094     0.200
    16.503    -6.510     0.200
    16.784    -3.420     0.200
    16.897    -5.774     0.200
    20.434   -12.578     0.200
    21.658    -1.929     0.200
    25.758     4.384     0.200
     3.314    -1.128     0.200
     3.314    -1.230     0.200
     3.462    -2.013     0.200
     3.464    -4.272     0.200
     3.820    -0.877     0.200
     4.059    -2.757     0.200
     4.117    -1.374     0.200
     4.392    -3.306     0.200
     4.332    -1.816     0.200
     5.302    -4.866     0.200
     5.528    -3.117     0.200
     5.600    -3.108     0.200
     5.876    -2.850     0.200
     6.129    -2.480     0.200
     6.442    -2.391     0.200
     6.442    -6.086     0.200
     6.816    -3.557     0.200
     7.056    -4.444     0.200
     7.498    -5.976     0.200
     7.949    -6.352     0.200
     8.552    -6.081     0.200
     8.820    -6.361     0.200
     8.978    -7.180     0.200
     9.459    -3.012     0.200
    11.056    -6.754     0.200
     3.313    -1.817     0.200
     3.463    -2.260     0.200
     3.462    -1.838     0.200
     3.821    -1.014     0.200
     3.821    -2.311     0.200
     4.116    -2.365     0.200
     4.333    -2.253     0.200
     4.391    -2.386     0.200
     5.302    -2.746     0.200
     5.527    -3.503     0.200
     5.600    -3.696     0.200
     6.065    -3.231     0.200
     6.130    -3.612     0.200
     6.432    -4.084     0.200
     6.442    -2.500     0.200
     6.442    -3.898     0.200
     6.816    -5.841     0.200
     7.055    -5.821     0.200
     7.498    -6.657     0.200
     7.948    -6.336     0.200
     8.819    -7.336     0.200
     8.977    -6.558     0.200
     3.305    -2.660     0.200
     3.471    -4.234     0.200
     3.469    -1.560     0.200
     3.821    -1.537     0.200
     4.051    -1.809     0.200
     4.108    -3.218     0.200
     4.339    -2.942     0.200
     4.384    -3.168     0.200
     4.749    -2.447     0.200
     5.519    -4.277     0.200
     5.591    -2.041     0.200
     6.056    -3.572     0.200
     6.136    -4.410     0.200
     6.424    -4.053     0.200
     6.433    -3.931     0.200
     7.047    -3.795     0.200
     7.490    -6.433     0.200
     7.941    -5.031     0.200
     8.543    -4.330     0.200
     8.812    -8.436     0.200
     8.971    -6.784     0.200
    11.050    -7.976     0.200
    12.448    -8.215     0.200
     3.332    -1.738     0.200
     3.332    -2.039     0.200
     3.434    -1.553     0.200
     3.475    -3.860     0.200
     3.790    -0.547     0.200
     3.790    -1.844     0.200
     4.056    -1.189     0.200
     4.137    -2.244     0.200
     4.303    -1.916     0.200
     4.416    -2.593     0.200
     4.416    -3.593     0.200
     4.778    -2.662     0.200
     5.551    -4.674     0.200
     5.618    -2.601     0.200
     5.851    -3.097     0.200
     6.082    -3.792     0.200
     6.084    -3.359     0.200
     6.100    -3.586     0.200
     6.442    -3.518     0.200
     6.455    -4.638     0.200
     6.839    -4.906     0.200
     6.867    -5.783     0.200
     7.079    -6.500     0.200
     7.522    -5.950     0.200
     7.522    -7.982     0.200
     7.650    -5.718     0.200
     8.845    -7.408     0.200
     9.006    -7.595     0.200
     9.251    -4.166     0.200
     9.472    -2.357     0.200
    10.042   -11.535     0.200
    11.085    -9.804     0.200
    12.484    -9.947     0.200
    12.750    -5.257     0.200
    16.495    -2.527     0.200
     2.018    -2.695     0.200
     3.350    -1.511     0.200
     3.412    -1.668     0.200
     3.477    -3.859     0.200
     3.770    -1.735     0.200
     3.770    -2.235     0.200
     4.155    -2.446     0.200
     4.436    -3.157     0.200
     4.436    -3.259     0.200
     4.281    -2.020     0.200
     4.796    -3.261     0.200
     5.342    -3.975     0.200
     5.571    -4.023     0.200
     5.635    -2.565     0.200
     5.870    -4.100     0.200
     5.915    -4.230     0.200
     5.957    -2.759     0.200
     6.101    -3.539     0.200
     6.078    -3.493     0.200
     6.448    -3.621     0.200
     6.448    -5.621     0.200
     6.475    -3.177     0.200
     6.859    -3.650     0.200
     6.887    -3.851     0.200
     7.099    -5.851     0.200
     7.542    -5.912     0.200
     7.641    -6.349     0.200
     7.995    -7.271     0.200
     8.593    -6.619     0.200
     8.867    -6.203     0.200
     9.028    -4.909     0.200
    11.107    -6.929     0.200
     2.502    -3.278     0.200
     3.472    -3.324     0.200
     3.321    -1.743     0.200
     3.321    -2.043     0.200
     3.449    -1.995     0.200
     3.804    -0.965     0.200
     3.804    -1.166     0.200
     4.125    -2.325     0.200
     4.402    -3.625     0.200
     4.402    -4.625     0.200
     4.319    -3.171     0.200
     4.766    -2.450     0.200
     5.311    -2.426     0.200
     5.538    -4.820     0.200
     5.607    -3.015     0.200
     5.884    -3.602     0.200
     5.925    -4.206     0.200
     5.925    -1.505     0.200
     6.072    -4.061     0.200
     6.442    -4.291     0.200
     6.826    -4.654     0.200
     7.508    -6.586     0.200
     7.960    -7.501     0.200
     8.561    -6.456     0.200
     8.831    -6.616     0.200
     8.991    -5.779     0.200
     9.243    -5.273     0.200
     9.463    -2.426     0.200
    10.054   -10.271     0.200
    12.468   -10.816     0.200
    17.769   -12.575     0.200
    21.669    -4.940     0.200
     3.235    -2.101     0.200
     3.440    -3.890     0.200
     3.571    -0.763     0.200
     3.927    -1.949     0.200
     4.032    -1.852     0.200
     4.057    -2.139     0.200
     4.295    -3.096     0.200
     4.446    -3.176     0.200
     4.674    -2.623     0.200
     5.434    -4.299     0.200
     5.828    -4.494     0.200
     5.985    -3.062     0.200
     6.242    -3.616     0.200
     6.340    -3.342     0.200
     6.427    -2.491     0.200
     6.723    -4.565     0.200
     6.961    -5.109     0.200
     7.401    -6.274     0.200
     7.847    -6.000     0.200
     8.462    -5.296     0.200
     8.716    -7.040     0.200
     8.869    -5.486     0.200
    10.944    -6.959     0.200
     3.304    -1.770     0.200
     3.304    -1.969     0.200
     3.463    -2.131     0.200
     3.810    -1.315     0.200
     3.810    -1.514     0.200
     4.042    -2.363     0.200
     4.042    -3.363     0.200
     4.386    -3.074     0.200
     4.386    -4.172     0.200
     4.332    -2.968     0.200
     4.749    -2.779     0.200
     5.521    -3.961     0.200
     5.822    -3.505     0.200
     5.867    -2.232     0.200
     5.909    -3.238     0.200
     6.055    -3.887     0.200
     6.110    -4.726     0.200
     6.130    -3.348     0.200
     6.426    -3.628     0.200
     6.425    -4.310     0.200
     6.425    -4.713     0.200
     6.809    -4.293     0.200
     6.837    -5.263     0.200
     6.837    -5.962     0.200
     7.049    -4.185     0.200
     7.492    -8.135     0.200
     7.492    -6.131     0.200
     7.944    -6.461     0.200
     8.544    -5.391     0.200
     8.815    -5.986     0.200
     8.976    -7.079     0.200
     9.446    -2.539     0.200
    11.056    -9.601     0.200
     2.850    -1.703     0.200
     3.232    -1.405     0.200
     3.392    -4.287     0.200
     3.602    -3.026     0.200
     3.791    -1.529     0.200
     4.080    -0.807     0.200
     4.157    -2.940     0.200
     4.246    -3.352     0.200
     4.492    -2.659     0.200
     4.761    -1.970     0.200
     4.943    -3.962     0.200
     5.044    -3.849     0.200
     5.126    -3.739     0.200
     5.304    -2.408     0.200
     5.345    -2.781     0.200
     5.367    -2.000     0.200
     5.570    -3.835     0.200
     5.858    -2.951     0.200
     6.228    -5.283     0.200
     6.233    -4.152     0.200
     6.368    -3.012     0.200
     6.464    -3.878     0.200
     6.894    -6.884     0.200
     7.311    -5.123     0.200
     7.990    -5.229     0.200
     8.169    -5.408     0.200
     8.292    -6.910     0.200
    10.351    -7.295     0.200
    10.558    -7.546     0.200
    11.740    -9.910     0.200
     2.484    -4.325     0.200
     3.294    -1.983     0.200
     3.470    -1.483     0.200
     3.491    -4.027     0.200
     3.810    -1.444     0.200
     3.810    -2.245     0.200
     4.031    -1.269     0.200
     4.031    -3.667     0.200
     4.098    -1.178     0.200
     4.377    -1.829     0.200
     4.377    -2.029     0.200
     4.338    -2.287     0.200
     4.739    -2.203     0.200
     5.284    -2.787     0.200
     5.512    -4.710     0.200
     5.512    -4.609     0.200
     5.580    -3.053     0.200
     5.813    -4.132     0.200
     5.858    -3.660     0.200
     5.899    -3.371     0.200
     6.115    -4.421     0.200
     6.416    -4.072     0.200
     6.414    -3.106     0.200
     6.800    -5.540     0.200
     6.828    -4.123     0.200
     7.040    -5.334     0.200
     7.483    -6.689     0.200
     7.936    -4.736     0.200
     8.535    -4.425     0.200
     8.807    -5.465     0.200
     8.969    -5.091     0.200
     9.215    -4.500     0.200
    11.050    -8.342     0.200
    11.211    -7.156     0.200
    12.769    -5.745     0.200
    16.506    -6.744     0.200
    16.779    -7.375     0.200
    20.842    -2.086     0.200
    21.618    -1.126     0.200
     2.826    -2.194     0.200
     2.826    -0.795     0.200
     2.910    -1.177     0.200
     3.372    -2.923     0.200
     3.372    -3.626     0.200
     3.659    -2.323     0.200
     3.661     0.033     0.200
     4.032    -2.252     0.200
     4.032    -1.451     0.200
     4.128    -4.569     0.200
     4.288    -2.063     0.200
     4.556    -2.032     0.200
     5.088    -2.608     0.200
     5.132    -4.998     0.200
     5.132    -5.100     0.200
     5.365    -3.004     0.200
     5.567    -2.687     0.200
     5.757    -3.824     0.200
     5.757    -3.324     0.200
     6.017    -4.251     0.200
     6.656    -7.022     0.200
     7.115    -5.864     0.200
     7.113    -2.298     0.200
     7.615    -7.420     0.200
     8.506    -7.574     0.200
     8.625    -5.043     0.200
     8.746    -5.260     0.200
     8.858    -2.514     0.200
     2.730    -1.836     0.200
     3.150    -2.667     0.200
     3.494    -4.358     0.200
     3.947    -1.336     0.200
     3.955    -2.489     0.200
     3.991    -2.726     0.200
     3.991    -3.127     0.200
     4.214    -3.876     0.200
     4.214    -3.676     0.200
     4.512    -4.030     0.200
     4.590    -3.396     0.200
     5.352    -4.850     0.200
     5.352    -5.950     0.200
     5.438    -3.579     0.200
     5.662    -3.374     0.200
     5.900    -3.327     0.200
     6.258    -3.871     0.200
     6.288    -4.144     0.200
     6.310    -4.216     0.200
     6.879    -5.860     0.200
     7.320    -7.984     0.200
     7.320    -6.853     0.200
     7.320    -7.052     0.200
     8.638    -7.036     0.200
     8.796    -6.842     0.200
     9.316    -1.167     0.200
    11.040    -8.380     0.200
    12.276    -9.160     0.200
    12.910    -3.893     0.200
     2.459    -1.067     0.200
     2.459    -1.567     0.200
     2.544    -1.661     0.200
     3.315    -3.024     0.200
     3.455    -2.356     0.200
     3.455    -1.957     0.200
     3.851    -1.796     0.200
     4.269    -2.762     0.200
     4.221    -1.742     0.200
     4.221    -2.840     0.200
     4.251    -2.291     0.200
     4.509    -2.945     0.200
     4.894    -4.161     0.200
     5.650    -5.318     0.200
     5.743    -4.066     0.200
     6.061    -3.861     0.200
     6.059    -4.190     0.200
     6.205    -2.910     0.200
     7.615    -6.640     0.200
     7.615    -5.734     0.200
     8.680    -5.285     0.200
     8.922    -7.042     0.200
     9.063    -7.123     0.200
     9.925   -12.486     0.200
     9.615    -2.386     0.200
    11.127   -10.163     0.200
    11.319    -9.234     0.200
    12.814    -3.998     0.200
    16.592    -1.990     0.200
     2.481    -4.308     0.200
     3.290    -1.550     0.200
     3.492    -4.056     0.200
     3.812    -1.876     0.200
     3.812    -1.681     0.200
     4.029    -2.575     0.200
     4.029    -2.770     0.200
     4.094    -1.740     0.200
     4.341    -1.471     0.200
     4.374    -2.694     0.200
     4.374    -2.998     0.200
     4.736    -2.266     0.200
     5.509    -5.172     0.200
     5.509    -6.773     0.200
     5.576    -2.816     0.200
     5.809    -4.194     0.200
     5.854    -2.426     0.200
     6.118    -3.394     0.200
     6.139    -2.957     0.200
     6.413    -2.935     0.200
     6.412    -3.903     0.200
     6.412    -5.005     0.200
     6.797    -4.603     0.200
     6.825    -4.487     0.200
     7.036    -4.901     0.200
     7.480    -5.752     0.200
     7.645    -5.612     0.200
     7.932    -7.101     0.200
     8.531    -4.793     0.200
     8.804    -5.733     0.200
     8.966    -6.762     0.200
     9.212    -5.673     0.200
    11.046   -10.520     0.200
    11.207    -8.925     0.200
    12.447   -11.309     0.200
     2.499    -0.790     0.200
     2.502    -1.313     0.200
     3.424    -2.814     0.200
     3.892    -2.160     0.200
     4.217    -1.973     0.200
     4.218    -1.799     0.200
     4.315    -2.558     0.200
     4.470    -1.978     0.200
     4.860    -3.852     0.200
     5.612    -3.685     0.200
     5.711    -3.530     0.200
     5.931    -2.894     0.200
     5.975    -3.380     0.200
     6.011    -3.826     0.200
     6.106    -4.053     0.200
     6.104    -3.496     0.200
     6.172    -4.341     0.200
     6.520    -5.475     0.200
     6.598    -3.155     0.200
     6.901    -4.461     0.200
     7.138    -4.567     0.200
     7.577    -6.566     0.200
     8.015    -5.864     0.200
     8.644    -4.496     0.200
     8.880    -5.791     0.200
     9.020    -6.805     0.200
    11.083    -9.709     0.200
    11.277    -9.156     0.200
    12.469    -9.756     0.200
     3.278    -1.676     0.200
     3.495    -4.165     0.200
     3.820    -0.955     0.200
     4.023    -2.487     0.200
     4.082    -1.968     0.200
     4.361    -2.808     0.200
     4.354    -1.265     0.200
     4.723    -3.885     0.200
     4.723    -1.385     0.200
     5.496    -5.381     0.200
     5.564    -2.750     0.200
     5.797    -3.015     0.200
     5.883    -4.954     0.200
     6.030    -3.395     0.200
     6.151    -3.152     0.200
     6.400    -4.147     0.200
     6.405    -3.781     0.200
     6.784    -5.415     0.200
     6.812    -4.296     0.200
     7.024    -4.407     0.200
     7.467    -6.265     0.200
     7.920    -8.706     0.200
     7.920    -4.206     0.200
     8.519    -6.108     0.200
     8.791    -7.940     0.200
     8.953    -6.380     0.200
    11.034    -8.239     0.200
    12.435   -11.435     0.200
     2.585    -3.378     0.200
     3.367    -2.250     0.200
     3.656    -0.829     0.200
     3.656    -1.130     0.200
     3.875    -2.244     0.200
     4.057    -3.124     0.200
     4.057    -4.823     0.200
     4.056    -2.295     0.200
     4.056    -3.197     0.200
     4.420    -2.845     0.200
     4.694    -2.917     0.200
     4.971    -3.589     0.200
     4.964    -3.296     0.200
     4.991    -1.330     0.200
     4.991    -1.529     0.200
     5.579    -5.489     0.200
     5.791    -3.693     0.200
     5.814    -3.930     0.200
     6.012    -4.082     0.200
     6.012    -4.403     0.200
     6.445    -4.718     0.200
     7.102    -4.255     0.200
     7.312    -5.913     0.200
     7.478    -4.668     0.200
     7.569    -5.047     0.200
     9.714    -6.745     0.200
    11.004    -9.357     0.200
    11.489   -12.451     0.200
     3.295    -1.837     0.200
     3.492    -3.387     0.200
     3.469    -0.759     0.200
     3.808    -1.108     0.200
     3.808    -1.608     0.200
     4.031    -2.476     0.200
     4.031    -2.676     0.200
     4.099    -2.337     0.200
     4.336    -1.863     0.200
     4.378    -2.796     0.200
     4.378    -2.897     0.200
     5.285    -3.548     0.200
     5.513    -5.373     0.200
     5.513    -6.473     0.200
     5.581    -3.104     0.200
     5.814    -3.989     0.200
     5.859    -3.916     0.200
     5.900    -3.731     0.200
     6.113    -4.194     0.200
     6.418    -4.034     0.200
     6.414    -5.022     0.200
     6.801    -4.601     0.200
     6.829    -4.889     0.200
     6.829    -5.489     0.200
     7.041    -6.097     0.200
     7.484    -7.853     0.200
     7.937    -7.205     0.200
     8.536    -6.586     0.200
     8.809    -7.438     0.200
     8.971    -6.769     0.200
     9.436    -2.719     0.200
    11.051   -10.122     0.200
    12.767    -4.109     0.200
    16.504    -3.963     0.200
    20.439    -6.000     0.200
     3.447    -1.001     0.200
     3.330    -1.178     0.200
     3.330    -1.678     0.200
     3.455    -3.734     0.200
     3.814    -1.024     0.200
     3.814    -1.125     0.200
     4.071    -1.882     0.200
     4.071    -2.882     0.200
     4.319    -2.741     0.200
     4.408    -3.340     0.200
     4.408    -3.239     0.200
     5.544    -4.563     0.200
     5.544    -6.360     0.200
     5.847    -4.578     0.200
     5.892    -4.694     0.200
     6.099    -3.958     0.200
     6.116    -3.788     0.200
     6.081    -3.093     0.200
     6.455    -3.539     0.200
     6.455    -4.039     0.200
     6.449    -5.841     0.200
     6.832    -6.496     0.200
     6.858    -4.722     0.200
     7.071    -4.576     0.200
     7.514    -7.011     0.200
     7.514    -6.105     0.200
     7.964    -6.579     0.200
     8.568    -4.930     0.200
     8.835    -7.675     0.200
     8.992    -7.772     0.200
     9.475    -5.628     0.200
    10.045   -10.365     0.200
    11.237    -7.725     0.200
    12.467    -9.615     0.200
    16.520    -4.191     0.200
    20.408    -8.626     0.200
     2.357    -3.755     0.200
     3.206    -1.863     0.200
     3.465    -4.085     0.200
     3.592    -2.323     0.200
     3.929    -2.306     0.200
     4.003    -1.641     0.200
     4.028    -2.839     0.200
     4.269    -3.059     0.200
     4.464    -3.050     0.200
     5.186    -3.347     0.200
     5.407    -5.445     0.200
     5.407    -3.945     0.200
     5.717    -4.679     0.200
     5.761    -2.883     0.200
     5.955    -3.328     0.200
     6.242    -4.431     0.200
     6.313    -4.371     0.200
     6.398    -4.250     0.200
     6.398    -5.649     0.200
     6.696    -6.699     0.200
     6.718    -5.113     0.200
     6.718    -4.516     0.200
     7.375    -7.637     0.200
     7.822    -7.711     0.200
     7.822    -8.110     0.200
     8.434    -7.512     0.200
     8.692    -6.774     0.200
     8.847    -7.206     0.200
     9.369    -1.013     0.200
    10.173   -10.589     0.200
    16.608    -3.283     0.200
    17.713    -8.586     0.200
    20.544    -8.409     0.200
    20.913    -0.721     0.200
    21.493     0.429     0.200
    21.525    -1.874     0.200
     2.360    -3.220     0.200
     3.222    -1.931     0.200
     3.222    -1.829     0.200
     3.445    -4.208     0.200
     4.018    -2.673     0.200
     3.936    -2.664     0.200
     3.936    -1.961     0.200
     4.049    -2.352     0.200
     4.281    -2.804     0.200
     4.281    -4.105     0.200
     4.459    -3.842     0.200
     5.420    -4.215     0.200
     5.420    -5.914     0.200
     5.732    -4.309     0.200
     5.776    -3.708     0.200
     5.971    -3.084     0.200
     6.326    -4.454     0.200
     6.418    -4.865     0.200
     6.418    -4.763     0.200
     6.709    -5.672     0.200
     6.730    -3.449     0.200
     7.387    -6.885     0.200
     7.833    -6.010     0.200
     8.448    -5.612     0.200
     8.448    -6.011     0.200
     8.702    -6.454     0.200
     8.855    -7.611     0.200
     9.387    -4.797     0.200
    10.158    -8.469     0.200
    12.893    -7.774     0.200
    16.619    -5.876     0.200
     2.373    -3.726     0.200
     2.373    -3.523     0.200
     3.447    -3.479     0.200
     3.924    -1.580     0.200
     4.028    -1.774     0.200
     4.049    -2.260     0.200
     4.292    -2.450     0.200
     4.292    -2.348     0.200
     4.446    -3.837     0.200
     5.210    -2.874     0.200
     5.430    -5.447     0.200
     5.430    -5.549     0.200
     5.742    -3.514     0.200
     5.980    -2.869     0.200
     6.226    -4.560     0.200
     6.337    -3.481     0.200
     6.420    -4.314     0.200
     6.420    -4.615     0.200
     6.719    -5.407     0.200
     6.741    -5.599     0.200
     6.741    -5.798     0.200
     7.398    -8.131     0.200
     7.845    -5.676     0.200
     8.458    -5.334     0.200
     8.714    -6.123     0.200
     8.867    -6.697     0.200
     9.394    -2.067     0.200
    16.609    -2.653     0.200
     2.378    -3.546     0.200
     3.242    -2.252     0.200
     3.242    -1.951     0.200
     3.435    -3.860     0.200
     3.925    -1.285     0.200
     3.925    -2.184     0.200
     4.039    -1.201     0.200
     4.062    -3.433     0.200
     4.062    -1.835     0.200
     4.062    -1.535     0.200
     4.302    -2.530     0.200
     4.302    -2.733     0.200
     4.440    -2.907     0.200
     5.222    -1.491     0.200
     5.441    -4.743     0.200
     5.753    -3.036     0.200
     5.797    -4.639     0.200
     5.835    -2.638     0.200
     5.992    -2.209     0.200
     6.221    -4.458     0.200
     6.348    -4.984     0.200
     6.348    -2.484     0.200
     6.433    -2.200     0.200
     6.730    -4.303     0.200
     6.751    -6.275     0.200
     7.409    -4.217     0.200
     7.854    -9.733     0.200
     7.854    -6.631     0.200
     8.469    -5.443     0.200
     8.723    -6.070     0.200
     8.875    -6.800     0.200
     9.407    -2.021     0.200
    12.173   -10.545     0.200
    12.883    -7.295     0.200
    20.509    -7.290     0.200
    20.931    -1.561     0.200
     3.236    -1.409     0.200
     3.450    -3.206     0.200
     4.033    -1.896     0.200
     3.915    -2.429     0.200
     3.915    -2.530     0.200
     4.048    -1.861     0.200
     4.299    -2.605     0.200
     4.437    -1.495     0.200
     5.217    -3.803     0.200
     5.437    -3.398     0.200
     5.748    -3.033     0.200
     5.830    -3.154     0.200
     5.985    -3.279     0.200
     6.343    -4.525     0.200
     6.217    -3.911     0.200
     6.420    -2.146     0.200
     6.726    -3.852     0.200
     6.748    -6.758     0.200
     6.748    -3.660     0.200
     7.405    -6.086     0.200
     7.405    -5.886     0.200
     7.852    -6.447     0.200
     8.465    -5.570     0.200
     8.721    -5.901     0.200
     8.876    -7.896     0.200
    10.952   -11.605     0.200
    11.122    -8.514     0.200
     3.252    -1.543     0.200
     3.252    -1.743     0.200
     3.438    -3.828     0.200
     3.912    -2.066     0.200
     3.912    -2.465     0.200
     4.063    -2.936     0.200
     4.063    -1.639     0.200
     4.049    -2.517     0.200
     4.314    -3.393     0.200
     4.426    -2.665     0.200
     5.232    -3.619     0.200
     5.452    -3.896     0.200
     5.763    -4.156     0.200
     5.808    -4.057     0.200
     5.846    -4.270     0.200
     6.002    -3.509     0.200
     6.207    -4.009     0.200
     6.359    -4.931     0.200
     6.435    -4.149     0.200
     6.763    -4.943     0.200
     7.420    -5.477     0.200
     7.420    -7.578     0.200
     7.866    -7.714     0.200
     7.866    -5.812     0.200
     8.480    -5.779     0.200
     8.735    -7.055     0.200
     8.888    -6.810     0.200
     9.414    -1.305     0.200
    10.963    -8.886     0.200
    11.136    -7.656     0.200
    12.360    -9.851     0.200
    12.871    -4.009     0.200
    16.603    -3.087     0.200
     3.256    -2.309     0.200
     3.256    -2.410     0.200
     3.425    -3.640     0.200
     3.922    -1.920     0.200
     3.922    -2.022     0.200
     4.053    -2.452     0.200
     4.074    -1.537     0.200
     4.315    -3.253     0.200
     4.315    -4.554     0.200
     4.430    -3.620     0.200
     5.235    -4.135     0.200
     5.454    -4.174     0.200
     5.454    -6.873     0.200
     5.767    -3.787     0.200
     5.849    -4.280     0.200
     6.006    -3.263     0.200
     6.212    -5.293     0.200
     6.361    -3.716     0.200
     6.446    -3.924     0.200
     6.446    -5.225     0.200
     6.743    -4.536     0.200
     7.866    -5.336     0.200
     8.483    -5.582     0.200
     8.734    -7.165     0.200
     8.886    -6.059     0.200
    11.135    -7.146     0.200
     3.219    -1.305     0.200
     3.453    -4.130     0.200
     3.929    -1.903     0.200
     4.016    -2.769     0.200
     4.041    -2.071     0.200
     4.280    -2.648     0.200
     4.280    -4.148     0.200
     4.456    -3.110     0.200
     5.199    -1.869     0.200
     5.419    -5.745     0.200
     5.419    -2.948     0.200
     5.419    -6.046     0.200
     5.730    -3.708     0.200
     5.774    -2.910     0.200
     5.813    -2.820     0.200
     5.969    -3.368     0.200
     6.235    -3.917     0.200
     6.325    -4.579     0.200
     6.411    -3.901     0.200
     6.411    -5.999     0.200
     6.708    -5.103     0.200
     6.730    -5.201     0.200
     7.387    -4.833     0.200
     7.833    -6.779     0.200
     8.447    -5.630     0.200
     8.703    -6.734     0.200
     8.857    -5.722     0.200
     9.383    -1.675     0.200
    10.160    -8.626     0.200
    11.104    -7.943     0.200
    12.886    -4.769     0.200
     3.214    -1.965     0.200
     3.459    -2.225     0.200
     3.927    -0.761     0.200
     4.012    -0.837     0.200
     4.035    -1.793     0.200
     4.277    -2.445     0.200
     4.457    -2.973     0.200
     5.415    -5.132     0.200
     5.415    -3.331     0.200
     5.964    -2.726     0.200
     6.405    -3.217     0.200
     7.383    -5.823     0.200
     9.377    -0.122     0.200
    12.884    -4.087     0.200
     3.241    -1.902     0.200
     3.434    -3.801     0.200
     3.927    -2.547     0.200
     4.038    -2.845     0.200
     4.063    -2.739     0.200
     4.300    -2.560     0.200
     4.442    -4.061     0.200
     5.220    -2.831     0.200
     5.439    -4.777     0.200
     5.991    -3.056     0.200
     6.223    -5.415     0.200
     6.346    -4.019     0.200
     6.434    -3.497     0.200
     7.407    -6.146     0.200
     7.852    -5.758     0.200
     8.468    -6.582     0.200
     8.721    -6.691     0.200
     8.873    -7.516     0.200
    10.947    -9.577     0.200
     3.403    -3.328     0.200
     3.984    -4.619     0.200
     3.984    -0.319     0.200
     3.984    -4.020     0.200
     4.015    -1.513     0.200
     4.084    -3.505     0.200
     4.084    -3.206     0.200
     4.268    -2.252     0.200
     4.268    -2.453     0.200
     5.195    -2.528     0.200
     5.410    -4.532     0.200
     5.410    -4.733     0.200
     5.728    -1.730     0.200
     5.772    -1.413     0.200
     5.970    -2.206     0.200
     6.449    -4.274     0.200
     6.699    -3.905     0.200
     6.717    -4.660     0.200
     6.717    -4.259     0.200
     7.375    -6.495     0.200
     7.375    -8.640     0.200
     8.441    -6.227     0.200
     8.684    -6.110     0.200
     8.831    -6.074     0.200
     9.398    -4.964     0.200
    10.902    -8.628     0.200
    12.942    -8.355     0.200
     2.074    -2.827     0.200
     2.670    -2.011     0.200
     2.670    -2.215     0.200
     3.446    -2.397     0.200
     3.502    -3.377     0.200
     3.502    -2.081     0.200
     3.396    -2.926     0.200
     3.552    -1.772     0.200
     4.039    -3.002     0.200
     4.080    -2.705     0.200
     4.080    -3.010     0.200
     4.428    -3.452     0.200
     4.541    -2.732     0.200
     4.734    -3.531     0.200
     4.734    -4.234     0.200
     4.708    -4.616     0.200
     4.930    -3.651     0.200
     5.316    -5.195     0.200
     5.128    -3.324     0.200
     5.625    -4.579     0.200
     5.981    -6.378     0.200
     5.981    -5.878     0.200
     5.997    -5.778     0.200
     6.225    -4.908     0.200
     6.319    -6.287     0.200
     6.650    -7.567     0.200
     7.109    -5.430     0.200
     7.101    -4.874     0.200
     7.910    -5.818     0.200
     8.024    -5.425     0.200
     8.927    -2.746     0.200
    10.835   -13.331     0.200
    13.667    -4.596     0.200
    15.795    -6.757     0.200
    17.284    -7.634     0.200
    20.664    -8.161     0.200
    21.262   -12.040     0.200
    21.379    -1.250     0.200
     2.861    -2.013     0.200
     2.861    -2.513     0.200
     3.245    -2.594     0.200
     3.608    -2.301     0.200
     3.790    -1.075     0.200
     3.790    -3.276     0.200
     4.172    -2.371     0.200
     4.110    -3.132     0.200
     4.110    -0.732     0.200
     4.252    -3.222     0.200
     4.522    -2.471     0.200
     4.522    -3.371     0.200
     4.765    -2.263     0.200
     4.944    -4.842     0.200
     4.944    -6.241     0.200
     5.061    -3.969     0.200
     5.309    -4.432     0.200
     5.349    -3.394     0.200
     5.577    -3.728     0.200
     6.225    -5.065     0.200
     6.225    -5.465     0.200
     6.233    -3.726     0.200
     6.394    -3.128     0.200
     6.464    -5.626     0.200
     6.853    -5.178     0.200
     6.892    -6.492     0.200
     6.892    -6.293     0.200
     7.306    -5.525     0.200
     7.306    -7.926     0.200
     7.991    -6.548     0.200
     8.086    -6.567     0.200
     8.162    -5.861     0.200
     8.280    -5.815     0.200
     8.914    -6.193     0.200
     9.105    -1.563     0.200
    13.468    -7.580     0.200
    16.035    -5.817     0.200
    17.073    -6.377     0.200
    17.126    -8.081     0.200
    17.361   -13.072     0.200
    19.107    -1.529     0.200
    20.050    -0.980     0.200
    21.019    -8.058     0.200
    21.296    -2.913     0.200
    26.085     3.151     0.200
     2.595    -1.933     0.200
     2.595    -2.933     0.200
     2.560    -1.710     0.200
     2.560    -1.608     0.200
     3.174    -2.081     0.200
     3.174    -2.183     0.200
     3.483    -3.068     0.200
     3.767    -4.875     0.200
     3.639    -0.934     0.200
     3.773    -1.357     0.200
     3.773    -1.958     0.200
     3.995    -1.810     0.200
     4.316    -3.774     0.200
     4.320    -2.220     0.200
     5.189    -2.657     0.200
     5.440    -4.121     0.200
     5.708    -3.701     0.200
     5.755    -3.097     0.200
     6.070    -4.073     0.200
     6.118    -3.507     0.200
     6.166    -4.140     0.200
     6.336    -4.516     0.200
     6.724    -5.210     0.200
     6.772    -4.037     0.200
     6.968    -5.045     0.200
     7.419    -5.948     0.200
     7.895    -6.124     0.200
     8.443    -5.019     0.200
     8.776    -6.858     0.200
     8.973    -6.901     0.200
     9.258    -3.889     0.200
     9.282    -0.147     0.200
    10.205   -12.817     0.200
    11.189    -9.163     0.200
    12.297   -10.869     0.200
    12.586    -7.182     0.200
    16.278    -7.156     0.200
    17.134    -9.792     0.200
     3.081    -1.987     0.200
     3.183    -1.914     0.200
     3.815    -2.635     0.200
     3.915    -1.808     0.200
     3.920    -1.961     0.200
     3.994    -3.018     0.200
     3.994    -0.018     0.200
     4.192    -2.088     0.200
     4.192    -1.588     0.200
     4.051    -2.918     0.200
     4.353    -3.191     0.200
     4.470    -3.502     0.200
     4.504    -2.699     0.200
     4.508    -3.403     0.200
     4.769    -2.986     0.200
     4.936    -3.686     0.200
     5.115    -3.255     0.200
     4.970    -3.744     0.200
     5.281    -3.714     0.200
     5.281    -2.913     0.200
     5.304    -3.838     0.200
     5.304    -4.236     0.200
     5.336    -5.056     0.200
     5.559    -5.826     0.200
     5.992    -4.860     0.200
     5.976    -6.247     0.200
     5.976    -5.141     0.200
     6.083    -3.351     0.200
     6.369    -5.808     0.200
     7.331    -6.916     0.200
     7.789    -5.618     0.200
     8.130    -3.118     0.200
     8.408    -3.359     0.200
    11.500   -12.552     0.200
    14.161    -8.582     0.200
    17.248   -14.886     0.200
    17.651    -5.849     0.200
    19.965    -2.992     0.200
    21.943   -10.080     0.200
     2.450    -1.583     0.200
     2.582    -1.389     0.200
     3.401    -2.340     0.200
     3.363    -2.340     0.200
     3.456    -4.484     0.200
     3.745    -2.550     0.200
     4.094    -1.621     0.200
     4.094    -2.021     0.200
     4.207    -1.986     0.200
     4.235    -3.370     0.200
     4.488    -3.586     0.200
     4.488    -3.987     0.200
     4.599    -2.221     0.200
     4.615    -3.616     0.200
     4.848    -3.599     0.200
     5.394    -3.214     0.200
     5.622    -4.361     0.200
     5.687    -3.491     0.200
     5.921    -3.639     0.200
     5.967    -3.671     0.200
     6.031    -3.722     0.200
     6.153    -3.169     0.200
     6.526    -4.418     0.200
     6.486    -3.825     0.200
     6.910    -4.689     0.200
     6.938    -5.078     0.200
     7.150    -4.787     0.200
     7.388    -3.033     0.200
     7.594    -5.343     0.200
     7.648    -4.486     0.200
     8.645    -6.361     0.200
     8.645    -6.661     0.200
     8.917    -6.501     0.200
     9.076    -8.850     0.200
     9.534    -5.582     0.200
     9.973   -13.118     0.200
    12.707    -5.568     0.200
    16.466    -7.641     0.200
    16.821   -13.859     0.200
    16.868   -10.431     0.200
    17.781   -16.044     0.200
    20.839    -2.568     0.200
    21.351    -0.014     0.200
     3.763    -1.509     0.200
     3.800    -2.186     0.200
     3.865    -2.542     0.200
     3.865    -2.238     0.200
     3.992    -1.077     0.200
     3.992    -1.374     0.200
     4.076    -4.129     0.200
     4.076    -2.730     0.200
     4.203    -2.970     0.200
     4.442    -2.633     0.200
     4.620    -2.590     0.200
     4.985    -2.848     0.200
     5.211    -5.310     0.200
     5.211    -3.810     0.200
     5.287    -3.143     0.200
     5.514    -4.236     0.200
     5.559    -3.651     0.200
     5.599    -4.123     0.200
     5.750    -3.220     0.200
     6.015    -4.119     0.200
     6.115    -4.679     0.200
     6.220    -4.714     0.200
     6.220    -3.410     0.200
     6.420    -3.944     0.200
     6.499    -4.440     0.200
     6.527    -5.223     0.200
     6.527    -5.028     0.200
     6.738    -5.733     0.200
     7.182    -7.341     0.200
     7.182    -5.380     0.200
     7.388    -2.698     0.200
     7.641    -5.342     0.200
     7.636    -5.273     0.200
     8.234    -6.257     0.200
     8.509    -6.751     0.200
     8.678    -5.920     0.200
     8.950    -6.129     0.200
     9.164    -3.175     0.200
    10.767    -9.243     0.200
    16.539    -7.903     0.200
    17.128    -9.677     0.200
    20.847    -2.860     0.200
    21.014     0.265     0.200
    21.335    -5.804     0.200
     2.989    -2.475     0.200
     3.788    -2.220     0.200
     3.786    -1.641     0.200
     3.879    -2.708     0.200
     4.027    -2.273     0.200
     4.027    -1.773     0.200
     4.056    -3.700     0.200
     4.178    -2.173     0.200
     4.186    -3.813     0.200
     4.428    -2.299     0.200
     4.648    -2.674     0.200
     5.192    -4.425     0.200
     5.192    -4.626     0.200
     5.276    -3.089     0.200
     5.500    -4.680     0.200
     5.544    -3.185     0.200
     5.738    -3.230     0.200
     6.098    -5.125     0.200
     6.231    -2.648     0.200
     6.231    -3.248     0.200
     6.448    -4.319     0.200
     6.481    -6.070     0.200
     6.506    -5.982     0.200
     6.720    -5.942     0.200
     7.162    -7.360     0.200
     7.162    -6.166     0.200
     7.417    -2.726     0.200
     7.614    -6.481     0.200
     8.218    -5.341     0.200
     8.486    -6.421     0.200
     8.947    -5.538     0.200
     9.159    -5.165     0.200
    10.390   -11.535     0.200
    10.739    -8.449     0.200
    12.971    -8.751     0.200
    20.877    -1.718     0.200
    21.015     0.308     0.200
    21.306    -0.868     0.200
    21.367    -5.875     0.200
     3.104    -2.090     0.200
     2.982    -2.235     0.200
     2.982    -1.735     0.200
     4.031    -2.895     0.200
     3.929    -3.652     0.200
     3.929    -3.452     0.200
     4.153    -3.166     0.200
     4.153    -3.065     0.200
     4.419    -3.588     0.200
     4.419    -3.987     0.200
     4.924    -3.684     0.200
     4.898    -3.069     0.200
     5.082    -4.686     0.200
     5.082    -4.486     0.200
     5.260    -4.036     0.200
     5.482    -3.871     0.200
     5.706    -3.373     0.200
     5.996    -3.774     0.200
     6.366    -5.093     0.200
     6.371    -4.875     0.200
     6.715    -4.855     0.200
     6.602    -6.100     0.200
     7.448    -5.098     0.200
     8.128    -5.149     0.200
     8.304    -5.148     0.200
     8.422    -5.394     0.200
     9.023    -5.325     0.200
     9.218    -3.262     0.200
    13.372    -7.236     0.200
    16.160   -10.667     0.200
    16.977    -9.839     0.200
    17.057    -5.281     0.200
    17.375   -17.023     0.200
    21.044    -2.943     0.200
     2.910    -2.459     0.200
     2.966    -0.943     0.200
     3.806    -2.258     0.200
     3.820    -2.499     0.200
     3.761    -1.243     0.200
     4.058    -2.854     0.200
     4.058    -4.154     0.200
     4.028    -2.681     0.200
     4.028    -2.581     0.200
     4.159    -3.037     0.200
     4.681    -3.685     0.200
     4.944    -3.430     0.200
     5.165    -4.236     0.200
     5.165    -4.536     0.200
     5.254    -2.260     0.200
     5.519    -2.575     0.200
     5.715    -2.675     0.200
     6.071    -4.553     0.200
     6.228    -4.322     0.200
     6.228    -4.522     0.200
     6.454    -5.187     0.200
     6.478    -5.053     0.200
     6.478    -4.454     0.200
     6.692    -5.249     0.200
     7.134    -8.311     0.200
     7.436    -2.702     0.200
     8.192    -4.493     0.200
     8.455    -6.444     0.200
     8.620    -5.863     0.200
     8.931    -5.218     0.200
     9.142    -2.619     0.200
    10.415   -13.284     0.200
    13.002    -8.246     0.200
    16.473    -6.090     0.200
    17.133    -8.633     0.200
    20.124   -14.236     0.200
    21.002     0.224     0.200
    21.274    -5.091     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
    17.571  -117.238     0.200
    20.366  -137.837     0.200
    20.664  -141.664     0.200
     5.630   -32.990     0.200
     7.541   -49.586     0.200
     5.812   -35.338     0.200
     7.707   -48.128     0.200
     7.707   -47.628     0.200
    16.107  -115.193     0.200
    21.252  -142.894     0.200
     7.815   -50.217     0.200
    20.704  -144.795     0.200
    21.339  -152.724     0.200
     5.272   -26.108     0.200
     6.367   -37.422     0.200
     7.234   -43.319     0.200
     1.296     2.030     0.200
     1.550    -1.227     0.200
     2.372    -6.268     0.200
     6.794   -41.290     0.200
     8.546   -53.427     0.200
    17.314  -109.987     0.200
     2.889   -10.082     0.200
     7.232   -43.442     0.200
     7.232   -43.642     0.200
     1.937    -3.573     0.200
     3.738   -16.151     0.200
    16.902  -117.855     0.200
     1.520     1.087     0.200
     2.285    -6.649     0.200
     2.467    -8.734     0.200
     3.036   -13.861     0.200
     3.707   -17.746     0.200
     4.392   -24.442     0.200
     4.713   -26.610     0.200
     4.713   -27.110     0.200
     5.690   -32.395     0.200
     5.920   -34.394     0.200
     6.351   -36.553     0.200
     6.788   -43.893     0.200
     7.656   -46.698     0.200
     7.656   -47.300     0.200
     7.818   -49.053     0.200
    11.159   -75.964     0.200
    20.153  -140.128     0.200
     2.854    -8.577     0.200
     3.322   -13.895     0.200
     3.666   -18.311     0.200
     6.965   -39.891     0.200
     8.599   -54.186     0.200
    18.221  -127.701     0.200
    19.499  -132.230     0.200
    19.574  -132.594     0.200
     1.810    -2.963     0.200
     6.458   -38.422     0.200
    10.523   -74.183     0.200
    15.652  -111.276     0.200
     3.470   -14.871     0.200
     5.852   -36.083     0.200
     7.828   -47.633     0.200
    17.765  -122.030     0.200
    19.621  -130.289     0.200
    19.621  -129.879     0.200
    19.930  -135.181     0.200
     1.970    -4.189     0.200
     4.836   -29.038     0.200
     6.026   -35.386     0.200
     6.698   -42.184     0.200
     7.823   -50.933     0.200
     7.935   -47.976     0.200
     7.935   -48.876     0.200
     8.025   -52.036     0.200
    16.809  -123.486     0.200
     2.591    -8.603     0.200
     3.413   -12.862     0.200
     3.684   -17.358     0.200
     4.922   -25.992     0.200
     6.898   -39.337     0.200
     7.746   -48.023     0.200
     2.104    -6.076     0.200
     4.613   -23.012     0.200
     5.863   -34.527     0.200
     5.898   -36.250     0.200
     6.536   -40.969     0.200
     6.536   -40.070     0.200
     7.668   -46.655     0.200
     7.764   -49.391     0.200
     7.764   -48.993     0.200
     7.850   -51.417     0.200
     7.850   -51.613     0.200
     3.888   -19.381     0.200
     4.093   -22.773     0.200
     4.361   -23.772     0.200
     1.414     0.041     0.200
     1.763    -3.819     0.200
     2.120    -6.533     0.200
     4.100   -21.020     0.200
     4.183   -23.046     0.200
     6.438   -38.930     0.200
     8.635   -56.577     0.200
     2.261    -8.627     0.200
     2.387    -8.046     0.200
     4.433   -23.501     0.200
     4.434   -23.513     0.200
     4.448   -23.376     0.200
     5.094   -30.159     0.200
     5.695   -32.902     0.200
     5.733   -32.990     0.200
     6.369   -40.154     0.200
     6.752   -41.614     0.200
     7.595   -45.743     0.200
     7.595   -48.043     0.200
     7.684   -49.653     0.200
     8.414   -57.200     0.200
     1.946    -3.782     0.200
     1.946    -5.483     0.200
     2.236    -6.871     0.200
     3.024   -14.051     0.200
     3.884   -19.220     0.200
     6.242   -37.244     0.200
     7.650   -50.361     0.200
     8.529   -53.766     0.200
     8.697   -56.581     0.200
     1.731     0.167     0.200
     1.731    -0.634     0.200
     2.828   -10.014     0.200
     3.094   -12.333     0.200
     3.882   -18.921     0.200
     4.021   -19.812     0.200
     4.074   -19.005     0.200
     4.074   -19.505     0.200
     6.371   -36.228     0.200
     8.695   -51.579     0.200
     8.695   -54.780     0.200
     1.524     0.262     0.200
     2.206    -6.857     0.200
     2.206    -6.654     0.200
     2.226    -4.563     0.200
     2.828    -9.348     0.200
     3.625   -17.720     0.200
     3.641   -17.936     0.200
     3.954   -19.537     0.200
     4.852   -24.426     0.200
     5.077   -26.639     0.200
     5.355   -29.674     0.200
     5.580   -32.186     0.200
     6.361   -38.870     0.200
     7.526   -46.699     0.200
     8.407   -54.422     0.200
     8.407   -51.922     0.200
     8.606   -54.327     0.200
     1.216     3.258     0.200
     2.072    -5.194     0.200
     2.072    -5.295     0.200
     3.486   -15.703     0.200
     4.964   -29.359     0.200
     5.931   -35.606     0.200
     6.953   -43.922     0.200
     7.796   -49.441     0.200
     7.881   -50.131     0.200
     7.881   -49.930     0.200
     2.302    -6.677     0.200
     2.302    -7.677     0.200
     2.449    -8.248     0.200
     3.241   -13.830     0.200
     4.401   -24.105     0.200
     4.396   -22.844     0.200
     4.860   -27.176     0.200
     4.862   -27.534     0.200
     5.154   -30.070     0.200
     5.643   -31.394     0.200
     5.643   -33.992     0.200
     5.684   -32.888     0.200
     6.317   -37.866     0.200
     6.698   -40.413     0.200
     7.456   -46.454     0.200
     7.539   -48.393     0.200
     7.624   -48.393     0.200
     8.451   -55.389     0.200
    10.046   -66.356     0.200
    11.157   -77.196     0.200
    20.230  -137.279     0.200
    20.193  -133.508     0.200
    20.590  -142.602     0.200
    21.060  -143.105     0.200
    22.046  -154.667     0.200
     2.334    -7.814     0.200
     2.334    -6.615     0.200
     2.483    -7.429     0.200
     3.205   -12.403     0.200
     3.963   -19.049     0.200
     4.218   -20.124     0.200
     4.365   -21.878     0.200
     4.368   -21.381     0.200
     4.795   -26.221     0.200
     5.202   -30.412     0.200
     5.647   -32.131     0.200
     6.358   -36.378     0.200
     6.655   -39.085     0.200
     7.495   -47.720     0.200
     7.577   -46.519     0.200
     2.517    -7.903     0.200
     3.237   -14.013     0.200
     4.397   -23.085     0.200
     5.196   -30.930     0.200
     6.684   -38.190     0.200
     7.523   -47.394     0.200
     2.299    -7.320     0.200
     2.299    -6.417     0.200
     2.512    -7.459     0.200
     3.241   -14.365     0.200
     4.401   -22.539     0.200
     6.315   -37.621     0.200
     6.692   -41.580     0.200
     7.532   -47.814     0.200
     7.614   -48.599     0.200
     2.313    -5.763     0.200
     3.224   -13.052     0.200
     3.957   -17.868     0.200
     4.384   -21.025     0.200
     5.120   -28.059     0.200
     5.210   -29.694     0.200
     5.666   -33.658     0.200
     6.296   -37.816     0.200
     6.386   -38.194     0.200
     6.670   -39.483     0.200
     7.587   -46.154     0.200
     2.299    -7.053     0.200
     2.506   -10.035     0.200
     5.158   -30.810     0.200
     7.540   -47.903     0.200
     7.624   -45.967     0.200
     2.314    -6.325     0.200
     2.506    -7.598     0.200
     3.158   -11.673     0.200
     3.224   -13.054     0.200
     4.238   -21.710     0.200
     4.384   -22.735     0.200
     4.384   -22.133     0.200
     5.204   -31.026     0.200
     5.423   -27.093     0.200
     5.621   -31.642     0.200
     5.621   -31.743     0.200
     6.380   -36.228     0.200
     6.671   -39.835     0.200
     7.510   -44.543     0.200
     7.589   -47.155     0.200
    11.180   -81.026     0.200
    15.935  -112.428     0.200
     2.301    -6.545     0.200
     2.509    -5.926     0.200
     4.400   -22.279     0.200
     4.400   -22.576     0.200
     4.399   -22.453     0.200
     5.172   -30.273     0.200
     5.640   -31.589     0.200
     6.314   -38.671     0.200
     6.692   -40.648     0.200
     7.533   -45.191     0.200
     7.615   -45.603     0.200
     8.471   -56.750     0.200
     2.499    -6.478     0.200
     2.518    -6.172     0.200
     3.206   -13.273     0.200
     4.250   -19.876     0.200
     4.366   -20.045     0.200
     4.366   -21.346     0.200
     4.377   -20.092     0.200
     4.801   -25.639     0.200
     5.232   -28.818     0.200
     5.600   -31.975     0.200
     5.647   -31.565     0.200
     6.276   -36.291     0.200
     6.386   -37.596     0.200
     6.649   -37.616     0.200
     6.649   -38.015     0.200
     7.487   -43.789     0.200
     8.517   -53.259     0.200
     2.300    -6.843     0.200
     3.164   -10.916     0.200
     4.404   -23.718     0.200
     5.687   -33.109     0.200
     6.321   -38.399     0.200
     6.702   -40.969     0.200
     7.544   -44.565     0.200
     7.630   -47.386     0.200
     2.305    -6.493     0.200
     2.659   -10.620     0.200
     3.854   -18.184     0.200
     8.564   -53.410     0.200
     8.564   -52.309     0.200
     1.141     3.697     0.200
     1.628    -0.450     0.200
     2.299    -5.513     0.200
     3.871   -18.851     0.200
     3.871   -17.951     0.200
     3.747   -15.628     0.200
     5.181   -28.180     0.200
     2.309    -6.831     0.200
     3.232   -12.068     0.200
     3.930   -17.421     0.200
     5.172   -29.490     0.200
     6.307   -37.254     0.200
     6.685   -39.550     0.200
     6.685   -38.050     0.200
     7.609   -47.846     0.200
     2.428    -6.439     0.200
     2.459    -8.716     0.200
     3.702   -16.423     0.200
     5.087   -27.724     0.200
     8.460   -53.068     0.200
    11.798   -77.465     0.200
     2.105    -4.516     0.200
     2.679    -6.717     0.200
     5.045   -28.124     0.200
     6.476   -36.868     0.200
     7.737   -46.345     0.200
     7.814   -45.998     0.200
     4.325   -19.898     0.200
     4.338   -20.416     0.200
     5.257   -29.566     0.200
     5.559   -31.209     0.200
     5.606   -30.909     0.200
     5.606   -31.409     0.200
     6.607   -40.357     0.200
     7.446   -44.633     0.200
     7.524   -45.913     0.200
     2.332    -4.305     0.200
     3.366   -14.177     0.200
     4.094   -19.780     0.200
     1.537    -0.856     0.200
     1.551    -0.519     0.200
     1.551    -0.718     0.200
     2.352    -6.993     0.200
     2.801   -13.752     0.200
     3.628   -17.450     0.200
     3.782   -19.756     0.200
     1.591     0.548     0.200
     1.591     0.650     0.200
     2.267    -4.883     0.200
     3.128   -11.095     0.200
     3.494   -14.482     0.200
     4.384   -20.700     0.200
     5.684   -30.318     0.200
     6.409   -38.989     0.200
     7.492   -46.630     0.200
     2.252    -6.499     0.200
     3.292   -12.968     0.200
     4.452   -22.438     0.200
     7.591   -43.743     0.200
     7.591   -47.845     0.200
     7.675   -48.596     0.200
     2.324    -6.698     0.200
     3.217   -11.821     0.200
     4.378   -21.995     0.200
     4.375   -22.223     0.200
     5.174   -30.742     0.200
     6.293   -35.133     0.200
     6.293   -39.227     0.200
     6.673   -40.556     0.200
     7.514   -45.727     0.200
     7.514   -45.922     0.200
     7.599   -48.213     0.200
     7.599   -48.518     0.200
     1.382     3.110     0.200
     1.835     0.448     0.200
     1.835     0.346     0.200
     3.961   -16.761     0.200
     7.637   -50.813     0.200
     8.245   -51.686     0.200
     8.690   -56.774     0.200
    17.122  -117.578     0.200
    17.831  -118.644     0.200
    18.821  -128.521     0.200
    20.863  -141.783     0.200
     2.698    -8.328     0.200
     3.625   -15.005     0.200
     4.082   -20.085     0.200
     4.218   -19.689     0.200
     4.218   -16.789     0.200
     5.448   -29.286     0.200
     6.745   -36.699     0.200
     7.407   -42.992     0.200
     7.836   -48.389     0.200
     7.836   -48.288     0.200
     8.697   -50.492     0.200
     8.826   -52.769     0.200
    21.198  -142.581     0.200
     2.571    -7.185     0.200
     2.776   -10.681     0.200
     2.727    -9.146     0.200
     2.885   -10.146     0.200
     3.675   -16.784     0.200
     3.881   -17.203     0.200
     3.881   -18.000     0.200
     5.166   -30.951     0.200
     5.166   -29.957     0.200
     5.170   -28.187     0.200
     5.758   -31.522     0.200
     5.831   -33.915     0.200
     5.831   -34.017     0.200
     6.257   -39.341     0.200
     7.123   -44.077     0.200
     7.123   -44.273     0.200
     8.139   -48.858     0.200
    17.710  -118.788     0.200
    21.376  -146.317     0.200
     1.015     4.061     0.200
     1.234     2.407     0.200
     1.288     0.107     0.200
     1.288     0.102     0.200
     1.288     0.403     0.200
     2.107    -5.863     0.200
     2.663    -9.503     0.200
     4.892   -29.561     0.200
     7.758   -49.020     0.200
     7.844   -48.922     0.200
     1.612     1.463     0.200
     2.316    -3.961     0.200
     4.062   -18.011     0.200
     4.317   -20.791     0.200
     1.800    -2.988     0.200
     1.800    -3.289     0.200
     2.289    -7.164     0.200
     3.992   -20.975     0.200
     1.793     1.799     0.200
     3.774   -16.281     0.200
     3.774   -16.781     0.200
     4.026   -18.690     0.200
     5.538   -30.829     0.200
     6.413   -37.247     0.200
    10.059   -71.150     0.200
     1.377     3.902     0.200
     1.614     0.965     0.200
     4.064   -19.484     0.200
     4.064   -18.390     0.200
     5.459   -30.719     0.200
     1.077     3.377     0.200
     1.414     0.593     0.200
     1.414    -0.005     0.200
     1.939    -5.245     0.200
     3.466   -18.154     0.200
     4.790   -28.419     0.200
     7.981   -48.266     0.200
    10.737   -78.010     0.200
     2.346    -5.779     0.200
     3.161   -13.212     0.200
     3.615   -17.403     0.200
     3.915   -18.524     0.200
     5.370   -29.948     0.200
     8.824   -56.040     0.200
     2.028    -5.139     0.200
     3.398   -16.763     0.200
     3.591   -16.081     0.200
     4.124   -21.292     0.200
     4.737   -26.730     0.200
     7.090   -41.819     0.200
     7.942   -50.317     0.200
     8.050   -51.054     0.200
    10.796   -73.480     0.200
     1.897    -5.954     0.200
     2.268    -6.722     0.200
     6.291   -36.163     0.200
     1.382    -0.061     0.200
     1.382     0.139     0.200
     1.326     0.609     0.200
     2.045    -6.192     0.200
     2.045    -6.892     0.200
     3.339   -16.915     0.200
     3.410   -19.346     0.200
     4.536   -25.747     0.200
     5.939   -35.527     0.200
     6.611   -43.037     0.200
     7.000   -45.072     0.200
     7.316   -46.086     0.200
     7.845   -52.156     0.200
     7.845   -49.256     0.200
     7.935   -50.607     0.200
     7.935   -51.506     0.200
     1.375     4.228     0.200
     2.616    -8.034     0.200
     2.616    -8.434     0.200
     2.627    -6.878     0.200
     2.840    -6.212     0.200
     2.950   -10.221     0.200
     3.478   -15.034     0.200
     3.932   -17.935     0.200
     4.075   -16.763     0.200
     4.109   -16.947     0.200
     4.109   -18.648     0.200
     5.173   -28.169     0.200
     5.173   -27.669     0.200
     7.421   -43.048     0.200
     1.370     4.189     0.200
     2.615    -8.465     0.200
     2.615    -8.265     0.200
     2.624    -6.340     0.200
     2.841    -7.037     0.200
     4.076   -17.291     0.200
     5.168   -27.708     0.200
     5.168   -27.507     0.200
     5.624   -30.459     0.200
     7.301   -41.629     0.200
     7.425   -41.547     0.200
     1.081     3.443     0.200
     1.486    -0.213     0.200
     1.979    -5.327     0.200
     2.769    -9.969     0.200
     3.318   -15.870     0.200
     3.480   -17.307     0.200
     3.500   -16.059     0.200
     3.610   -16.856     0.200
     4.431   -23.778     0.200
     4.615   -25.594     0.200
     4.769   -26.376     0.200
     4.807   -27.279     0.200
     5.018   -28.385     0.200
     5.449   -30.951     0.200
     5.687   -33.476     0.200
     6.281   -38.323     0.200
     6.701   -40.419     0.200
     7.095   -44.915     0.200
     7.822   -48.873     0.200
     7.942   -51.071     0.200
     8.037   -51.270     0.200
     1.554     2.721     0.200
     2.497    -4.663     0.200
     3.464   -13.201     0.200
     3.812   -16.448     0.200
     4.125   -17.181     0.200
     6.446   -34.032     0.200
     1.531     2.459     0.200
     1.952    -2.004     0.200
     1.783     1.247     0.200
     3.480   -15.536     0.200
     3.486   -13.712     0.200
     3.821   -16.952     0.200
     4.034   -18.487     0.200
     4.369   -24.923     0.200
     8.959   -54.932     0.200
    16.902  -125.551     0.200
     1.228     5.155     0.200
     1.532     2.515     0.200
     1.774     1.552     0.200
     3.477   -14.420     0.200
     3.476   -11.410     0.200
     3.824   -17.326     0.200
     6.425   -33.883     0.200
     7.932   -50.165     0.200
     8.803   -52.177     0.200
     8.963   -54.140     0.200
     1.547     2.979     0.200
     2.553    -9.502     0.200
     2.490    -8.608     0.200
     3.806   -16.333     0.200
     4.035   -17.882     0.200
     5.518   -32.107     0.200
     8.975   -56.391     0.200
    10.075   -62.853     0.200
    16.897  -124.720     0.200
    18.374  -123.747     0.200
    19.095  -126.692     0.200
    19.821  -128.110     0.200
    19.952  -128.876     0.200
    20.704  -137.792     0.200
    21.108  -141.011     0.200
     1.238     4.887     0.200
     1.976    -2.227     0.200
     2.487    -5.322     0.200
     3.464   -12.873     0.200
     3.820   -15.573     0.200
     4.059   -21.460     0.200
     1.543     2.392     0.200
     1.758     0.596     0.200
     3.463   -13.956     0.200
     3.821   -16.413     0.200
     4.116   -18.162     0.200
    10.062   -61.234     0.200
     1.234     4.885     0.200
     1.539     2.008     0.200
     4.051   -18.911     0.200
     1.269     5.469     0.200
     1.998    -1.458     0.200
     2.517    -6.011     0.200
     2.517    -6.311     0.200
     3.332   -14.039     0.200
     3.434   -13.756     0.200
     3.790   -16.945     0.200
     4.416   -22.191     0.200
     5.551   -30.076     0.200
     5.618   -29.601     0.200
     6.082   -33.694     0.200
     6.084   -32.660     0.200
     6.442   -37.319     0.200
     6.442   -37.119     0.200
    16.871  -124.861     0.200
     2.540    -6.542     0.200
     3.477   -13.956     0.200
     3.770   -16.735     0.200
     3.770   -16.036     0.200
     7.542   -44.010     0.200
     7.972   -50.939     0.200
     8.867   -52.203     0.200
     1.559     2.010     0.200
     1.985    -1.511     0.200
     8.831   -50.116     0.200
    16.876  -125.616     0.200
     1.182     4.666     0.200
     1.430     2.716     0.200
     3.440   -14.890     0.200
     3.571   -15.567     0.200
     3.571   -13.466     0.200
     5.434   -28.502     0.200
     7.847   -47.398     0.200
     8.716   -50.243     0.200
     8.869   -54.783     0.200
     2.489    -5.648     0.200
     3.810   -17.116     0.200
     3.810   -16.913     0.200
     4.042   -17.663     0.200
     6.425   -38.111     0.200
     8.976   -55.279     0.200
     8.976   -55.079     0.200
     1.455     0.227     0.200
     1.916    -3.206     0.200
     3.392   -16.188     0.200
     8.169   -51.208     0.200
     1.541     1.965     0.200
     2.484    -7.126     0.200
     3.294   -13.983     0.200
     3.470   -14.280     0.200
     3.491   -13.828     0.200
     3.810   -16.342     0.200
     3.810   -16.143     0.200
     4.031   -18.566     0.200
     5.512   -31.210     0.200
     6.414   -35.809     0.200
     7.483   -44.689     0.200
     8.969   -53.392     0.200
    10.081   -65.382     0.200
    10.081   -64.425     0.200
     1.410     1.771     0.200
     1.617     0.426     0.200
     2.445    -8.114     0.200
     3.372   -14.423     0.200
     3.661   -16.365     0.200
     4.032   -21.053     0.200
     4.128   -21.967     0.200
     4.556   -20.532     0.200
     5.132   -25.697     0.200
     5.132   -28.799     0.200
     6.656   -41.522     0.200
     7.972   -48.538     0.200
     8.746   -52.663     0.200
     1.369     1.602     0.200
     1.832    -2.567     0.200
     2.312    -7.892     0.200
     2.312    -4.991     0.200
     2.312    -5.190     0.200
     3.494   -16.858     0.200
     3.947   -19.237     0.200
     3.955   -20.189     0.200
     3.955   -18.589     0.200
     3.991   -19.226     0.200
     4.214   -19.376     0.200
     4.512   -23.231     0.200
     4.590   -25.097     0.200
     5.352   -30.149     0.200
     6.258   -39.371     0.200
     6.879   -41.960     0.200
     7.320   -45.953     0.200
     8.638   -57.235     0.200
     8.796   -57.143     0.200
     8.796   -56.543     0.200
    12.276   -82.361     0.200
     1.605    -1.218     0.200
     2.104    -4.620     0.200
     2.544    -9.762     0.200
     3.315   -17.024     0.200
     3.455   -16.656     0.200
     3.851   -19.999     0.200
     4.269   -22.360     0.200
     4.221   -19.539     0.200
     4.509   -22.945     0.200
     5.650   -33.721     0.200
     6.061   -36.065     0.200
     6.939   -42.392     0.200
     8.056   -50.794     0.200
     2.481    -6.011     0.200
     3.290   -11.949     0.200
     3.812   -15.478     0.200
     4.029   -19.770     0.200
     4.029   -18.770     0.200
     4.094   -19.740     0.200
     4.341   -21.267     0.200
     4.374   -24.092     0.200
     5.509   -31.476     0.200
     5.809   -34.194     0.200
     6.139   -34.855     0.200
     6.797   -41.501     0.200
     7.036   -43.096     0.200
     8.531   -52.793     0.200
    12.447   -82.004     0.200
     1.030     3.473     0.200
     1.561    -0.658     0.200
     1.561     0.742     0.200
     2.499    -6.290     0.200
     6.598   -37.255     0.200
    12.469   -85.056     0.200
     1.527     2.247     0.200
     1.794     0.967     0.200
     3.495   -14.267     0.200
     3.820   -17.158     0.200
     8.953   -53.880     0.200
     1.219     5.544     0.200
     1.343     5.797     0.200
     2.723   -10.555     0.200
     2.744    -7.403     0.200
     2.907    -8.063     0.200
     3.367   -14.051     0.200
     4.057   -18.624     0.200
     4.033   -20.071     0.200
     4.056   -18.697     0.200
     4.694   -23.714     0.200
     4.964   -24.398     0.200
     4.991   -26.330     0.200
     4.991   -26.127     0.200
     5.579   -33.286     0.200
     5.791   -31.490     0.200
     6.445   -39.319     0.200
     7.312   -40.612     0.200
     7.478   -46.567     0.200
     7.478   -42.067     0.200
     1.543     2.282     0.200
     2.486    -6.510     0.200
     2.557    -6.357     0.200
     3.295   -13.737     0.200
     3.492   -15.487     0.200
     3.469   -12.159     0.200
     3.808   -16.308     0.200
     3.808   -15.708     0.200
     4.031   -18.876     0.200
     4.099   -19.636     0.200
     4.378   -23.197     0.200
     5.285   -28.948     0.200
     5.513   -30.072     0.200
     5.513   -29.673     0.200
     5.581   -29.305     0.200
     5.814   -32.189     0.200
     6.113   -34.093     0.200
     6.418   -37.834     0.200
     6.414   -34.622     0.200
     6.414   -33.722     0.200
     7.484   -45.353     0.200
     7.937   -48.604     0.200
     8.018   -47.470     0.200
     8.809   -54.338     0.200
     8.809   -53.938     0.200
     8.971   -57.668     0.200
    10.080   -66.524     0.200
     3.447   -12.798     0.200
     3.455   -15.429     0.200
     3.814   -16.227     0.200
     3.814   -16.024     0.200
     4.071   -18.882     0.200
     4.408   -22.442     0.200
     5.544   -30.063     0.200
     6.116   -33.992     0.200
     6.455   -37.141     0.200
     8.016   -49.620     0.200
     8.992   -57.467     0.200
     9.475   -57.245     0.200
    10.045   -61.747     0.200
    12.774   -87.241     0.200
     1.414     3.236     0.200
     1.858     0.164     0.200
     3.465   -15.484     0.200
     3.592   -15.425     0.200
     3.929   -17.806     0.200
     3.929   -17.204     0.200
     5.407   -29.043     0.200
     5.717   -32.480     0.200
     6.242   -35.431     0.200
     6.313   -35.070     0.200
     6.398   -36.450     0.200
     7.822   -48.410     0.200
     8.146   -47.579     0.200
     8.434   -52.512     0.200
     8.692   -53.774     0.200
     8.847   -55.804     0.200
     1.417     2.866     0.200
     1.872    -1.336     0.200
     2.360    -5.419     0.200
     3.445   -16.407     0.200
     3.936   -17.261     0.200
     5.420   -31.715     0.200
     8.149   -51.916     0.200
     8.855   -55.810     0.200
     8.855   -54.111     0.200
     9.387   -57.297     0.200
    10.158   -63.216     0.200
     1.430     3.258     0.200
     1.770     1.199     0.200
     1.882    -0.158     0.200
     3.447   -14.077     0.200
     3.924   -17.178     0.200
     4.028   -18.274     0.200
     4.049   -19.159     0.200
     4.292   -20.348     0.200
     5.430   -30.748     0.200
     6.420   -37.717     0.200
     8.458   -52.233     0.200
     8.714   -53.724     0.200
     8.867   -55.697     0.200
     8.867   -53.599     0.200
     1.176     4.859     0.200
     1.435     3.230     0.200
     3.435   -13.560     0.200
     3.925   -17.785     0.200
     3.925   -17.484     0.200
     8.875   -55.203     0.200
    10.137   -65.509     0.200
    20.682  -138.905     0.200
     1.439     2.241     0.200
     1.888    -1.190     0.200
     3.915   -18.132     0.200
     1.163     5.280     0.200
     1.449     2.905     0.200
     1.904    -0.603     0.200
     2.392    -5.675     0.200
     2.636    -6.602     0.200
     3.252   -11.844     0.200
     3.438   -13.425     0.200
     3.912   -17.066     0.200
     3.912   -16.965     0.200
     4.063   -18.237     0.200
     4.063   -21.338     0.200
     4.049   -18.618     0.200
     4.314   -20.893     0.200
     4.426   -21.665     0.200
     5.232   -27.518     0.200
     5.452   -28.295     0.200
     6.002   -32.309     0.200
     6.207   -33.907     0.200
     6.435   -36.450     0.200
     7.420   -43.676     0.200
     8.480   -52.682     0.200
     8.735   -53.458     0.200
     8.735   -52.458     0.200
     8.888   -54.509     0.200
    10.127   -63.075     0.200
     1.134     5.073     0.200
     1.164     4.410     0.200
     1.444     3.134     0.200
     1.906    -2.006     0.200
     2.387    -6.236     0.200
     3.256   -12.012     0.200
     3.425   -13.741     0.200
     3.922   -17.721     0.200
     3.922   -17.823     0.200
     4.315   -20.253     0.200
     4.430   -22.722     0.200
     5.454   -28.373     0.200
     5.454   -31.471     0.200
     6.006   -32.864     0.200
     6.446   -35.526     0.200
     8.734   -55.364     0.200
     8.886   -55.860     0.200
     1.116     4.853     0.200
     1.195     4.655     0.200
     1.421     3.196     0.200
     1.870    -0.153     0.200
     2.364    -6.889     0.200
     2.667    -7.619     0.200
     3.219   -11.305     0.200
     3.453   -14.728     0.200
     3.929   -17.403     0.200
     4.016   -18.171     0.200
     4.041   -17.571     0.200
     4.456   -21.911     0.200
     5.419   -29.448     0.200
     5.419   -29.948     0.200
     5.730   -32.509     0.200
     5.813   -32.019     0.200
     5.969   -33.067     0.200
     6.411   -35.800     0.200
     7.833   -47.881     0.200
     8.703   -53.831     0.200
     8.703   -52.535     0.200
     8.857   -55.425     0.200
     1.420     2.723     0.200
     1.866    -0.129     0.200
     5.415   -30.034     0.200
    10.165   -63.794     0.200
    17.709  -120.592     0.200
     1.125     4.802     0.200
     1.433     2.921     0.200
     1.756     0.991     0.200
     3.241   -12.499     0.200
     3.434   -14.801     0.200
     3.927   -17.445     0.200
     4.300   -20.861     0.200
     4.442   -22.061     0.200
     5.439   -29.874     0.200
     5.991   -34.056     0.200
     6.223   -35.615     0.200
     6.434   -36.395     0.200
     7.407   -45.845     0.200
     7.852   -47.059     0.200
     8.468   -51.781     0.200
     8.721   -55.593     0.200
     8.873   -56.418     0.200
     1.865     0.122     0.200
     2.327    -4.296     0.200
     3.223   -11.805     0.200
     4.015   -18.311     0.200
     4.084   -18.306     0.200
     4.268   -20.152     0.200
     5.410   -30.333     0.200
     5.728   -30.429     0.200
     8.192   -49.427     0.200
     8.684   -54.110     0.200
     8.684   -52.810     0.200
     8.831   -54.472     0.200
    10.161   -64.156     0.200
    10.161   -67.554     0.200
    18.551  -126.696     0.200
    19.044  -125.526     0.200
     0.977     3.851     0.200
     1.273     0.277     0.200
     1.498     0.452     0.200
     1.498    -0.048     0.200
     2.074    -5.624     0.200
     2.670    -8.316     0.200
     3.446   -16.093     0.200
     3.502   -17.081     0.200
     3.396   -16.121     0.200
     4.080   -22.010     0.200
     4.541   -25.131     0.200
     4.734   -27.430     0.200
     4.734   -27.531     0.200
     4.708   -25.920     0.200
     4.708   -26.217     0.200
     4.930   -27.956     0.200
     5.316   -30.492     0.200
     5.997   -36.473     0.200
     6.225   -39.111     0.200
     6.650   -41.567     0.200
     7.057   -43.664     0.200
     7.910   -50.716     0.200
     7.910   -50.420     0.200
     8.024   -50.722     0.200
     8.024   -52.527     0.200
     8.990   -59.057     0.200
    10.835   -75.511     0.200
    10.835   -71.729     0.200
    19.800  -131.723     0.200
    20.718  -139.847     0.200
     1.464    -0.040     0.200
     3.365   -14.588     0.200
     4.172   -19.371     0.200
     4.252   -21.822     0.200
     4.522   -23.671     0.200
     4.522   -23.471     0.200
     4.944   -27.141     0.200
     4.944   -26.842     0.200
     6.892   -43.192     0.200
     8.086   -50.167     0.200
     8.162   -50.261     0.200
     8.162   -50.461     0.200
     8.280   -50.915     0.200
     8.280   -49.415     0.200
     1.624    -0.646     0.200
     2.051    -5.590     0.200
     2.560   -10.409     0.200
     3.174   -14.081     0.200
     3.767   -20.375     0.200
     3.639   -17.735     0.200
     3.639   -18.934     0.200
     3.773   -18.857     0.200
     3.773   -15.357     0.200
     3.995   -21.912     0.200
     4.316   -22.176     0.200
     4.320   -22.419     0.200
     5.440   -30.621     0.200
     6.118   -36.507     0.200
     6.724   -41.308     0.200
     7.419   -46.248     0.200
     7.893   -46.671     0.200
     8.776   -53.062     0.200
     9.258   -58.444     0.200
    10.205   -69.853     0.200
    10.205   -67.470     0.200
    15.412  -111.938     0.200
    15.412  -108.235     0.200
    20.892  -141.653     0.200
    21.252  -148.845     0.200
     2.807    -7.583     0.200
     2.891   -12.955     0.200
     3.081   -11.186     0.200
     3.815   -17.635     0.200
     3.994   -16.421     0.200
     4.051   -18.515     0.200
     4.051   -18.117     0.200
     4.470   -23.701     0.200
     4.504   -22.500     0.200
     5.115   -27.056     0.200
     4.970   -26.545     0.200
     5.281   -29.011     0.200
     5.281   -27.413     0.200
     5.304   -27.736     0.200
     5.336   -29.459     0.200
     5.559   -29.928     0.200
     5.992   -34.661     0.200
     5.976   -32.848     0.200
     6.083   -34.448     0.200
     6.369   -36.409     0.200
     7.789   -47.220     0.200
     8.130   -50.470     0.200
     8.248   -52.271     0.200
     8.359   -51.681     0.200
    11.500   -74.052     0.200
    11.500   -76.470     0.200
    19.934  -134.428     0.200
     1.641    -0.751     0.200
     1.641    -2.151     0.200
     1.730    -2.767     0.200
     2.070    -4.735     0.200
     2.582    -8.489     0.200
     4.488   -23.886     0.200
     5.622   -33.261     0.200
     5.622   -30.162     0.200
     6.486   -39.225     0.200
     6.486   -36.925     0.200
     7.648   -48.886     0.200
     9.973   -63.862     0.200
    16.821  -129.009     0.200
    21.574  -148.516     0.200
     1.389     3.428     0.200
     1.282     4.650     0.200
     1.968    -2.020     0.200
     1.968    -1.919     0.200
     2.220    -2.609     0.200
     3.763   -16.009     0.200
     3.800   -16.991     0.200
     3.865   -16.738     0.200
     3.865   -17.542     0.200
     3.992   -17.678     0.200
     3.992   -18.077     0.200
     5.211   -27.607     0.200
     5.211   -28.904     0.200
     5.287   -28.745     0.200
     6.420   -37.444     0.200
     6.499   -38.042     0.200
     7.388   -41.542     0.200
     7.641   -45.740     0.200
     7.636   -46.180     0.200
     8.678   -54.420     0.200
    10.377   -66.080     0.200
    12.936   -89.416     0.200
    16.609  -116.549     0.200
    17.832  -118.699     0.200
     1.642     0.534     0.200
     1.959    -2.223     0.200
     3.788   -17.420     0.200
     4.027   -19.773     0.200
     4.027   -17.673     0.200
     4.428   -21.400     0.200
     5.192   -27.325     0.200
     5.192   -27.024     0.200
     5.276   -27.389     0.200
     6.231   -34.447     0.200
     6.720   -39.842     0.200
     7.162   -42.067     0.200
     7.417   -42.681     0.200
     9.159   -56.034     0.200
    10.130   -62.557     0.200
    10.390   -69.834     0.200
    10.390   -65.404     0.200
    12.971   -90.710     0.200
    18.198  -123.806     0.200
    20.459  -136.973     0.200
    20.857  -137.407     0.200
     1.635    -1.218     0.200
     1.635    -1.019     0.200
     1.796    -3.249     0.200
     1.589    -0.062     0.200
     8.304   -49.648     0.200
     8.422   -54.594     0.200
    10.463   -71.596     0.200
    10.463   -67.589     0.200
    10.538   -66.354     0.200
    16.977  -128.564     0.200
    20.973  -145.060     0.200
     1.216     4.439     0.200
     1.441     2.307     0.200
     1.615     0.185     0.200
     1.615     0.385     0.200
     1.964    -2.073     0.200
     2.156    -3.738     0.200
     2.966   -10.544     0.200
     3.806   -16.358     0.200
     3.761   -17.643     0.200
     4.058   -19.654     0.200
     4.028   -19.781     0.200
     5.165   -26.236     0.200
     7.436   -43.527     0.200
     7.688   -48.718     0.200
     8.455   -53.744     0.200
    20.346  -133.768     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.141    -4.080     0.200
     0.478     0.243     0.200
     0.325     1.917     0.200
     1.302    -0.654     0.200
     1.296    -0.470     0.200
     3.068    -7.159     0.200
     6.645   -19.342     0.200
     1.218     0.954     0.200
     1.512    -0.850     0.200
     2.205    -0.542     0.200
     2.450    -3.000     0.200
     2.679    -0.458     0.200
     3.135    -7.420     0.200
     4.132    -5.323     0.200
     3.949    -6.859     0.200
     2.477    -3.688     0.200
     0.552     0.496     0.200
     0.545     0.506     0.200
     0.545     0.303     0.200
     0.783     0.070     0.200
     0.981    -0.204     0.200
     0.989    -0.683     0.200
     1.005     0.613     0.200
     1.017    -0.354     0.200
     1.017     1.529     0.200
     1.297    -0.116     0.200
     1.419    -0.197     0.200
     1.419    -0.799     0.200
     2.246    -2.415     0.200
     2.285    -0.149     0.200
     6.501   -12.844     0.200
     1.926    -1.158     0.200
     6.965   -14.891     0.200
     0.202     2.904     0.200
     0.397     1.704     0.200
     0.541     0.750     0.200
     0.465     1.755     0.200
     0.592     0.745     0.200
     0.737     0.650     0.200
     0.743     1.064     0.200
     0.750     0.848     0.200
     2.298    -0.939     0.200
     0.192     2.272     0.200
     0.558     1.561     0.200
     1.113    -0.135     0.200
     0.127    -0.103     0.200
     0.374    -0.348     0.200
     0.899    -0.072     0.200
     1.150     0.872     0.200
     1.150     0.474     0.200
     1.206     0.190     0.200
     2.165    -1.505     0.200
     2.216     0.368     0.200
     2.218    -0.489     0.200
     2.591    -0.806     0.200
     0.026     3.387     0.200
     0.389     0.788     0.200
     0.910     0.785     0.200
     1.227     0.606     0.200
     1.288     0.073     0.200
     1.294     0.804     0.200
     1.294    -0.399     0.200
     2.104    -3.279     0.200
     0.150     2.328     0.200
     0.625     0.656     0.200
     1.177     0.159     0.200
     1.490    -1.466     0.200
     1.724    -1.661     0.200
     1.952    -1.388     0.200
     2.432    -2.231     0.200
     2.432    -1.630     0.200
     0.167     3.180     0.200
     0.654     0.419     0.200
     0.862    -0.155     0.200
     1.179    -0.718     0.200
     1.719    -1.321     0.200
     0.221     2.628     0.200
     0.163     2.070     0.200
     1.168     0.708     0.200
     1.135     0.643     0.200
     2.261    -3.827     0.200
     0.222     2.265     0.200
     0.222     1.964     0.200
     0.416     2.134     0.200
     1.368    -1.344     0.200
     1.368    -0.745     0.200
     1.025     0.838     0.200
     1.025     0.637     0.200
     1.946    -2.782     0.200
     0.115     1.581     0.200
     0.162     0.214     0.200
     0.558     0.764     0.200
     1.256     0.130     0.200
     1.355     0.089     0.200
     1.820    -1.740     0.200
     1.820    -1.240     0.200
     2.199    -0.458     0.200
     0.175     1.627     0.200
     0.175     1.827     0.200
     0.483     1.488     0.200
     1.100     0.128     0.200
     1.100     0.526     0.200
     1.305    -0.564     0.200
     1.305    -0.365     0.200
     1.518    -0.237     0.200
     2.206    -3.154     0.200
     2.226    -0.763     0.200
     0.046     2.249     0.200
     0.422     1.231     0.200
     0.422     1.431     0.200
     0.960     1.274     0.200
     0.982     0.570     0.200
     1.216     0.558     0.200
     1.216     0.358     0.200
     1.324     0.132     0.200
     1.324     0.533     0.200
     2.072    -2.895     0.200
     2.201    -1.158     0.200
     0.172     2.231     0.200
     0.216     1.247     0.200
     1.073     0.280     0.200
     1.073    -0.619     0.200
     1.201     1.632     0.200
     1.217     0.324     0.200
     1.369     0.308     0.200
     1.369    -0.992     0.200
     0.144     1.614     0.200
     0.261     1.507     0.200
     1.024     0.426     0.200
     1.147     0.312     0.200
     1.267     0.614     0.200
     1.415    -0.368     0.200
     2.334    -3.217     0.200
     2.334    -2.717     0.200
     2.499    -3.932     0.200
     0.178     1.538     0.200
     0.178     1.335     0.200
     0.236     1.223     0.200
     1.044    -0.118     0.200
     1.044     0.281     0.200
     1.180     0.293     0.200
     1.414    -0.430     0.200
     2.301    -4.549     0.200
     2.301    -3.948     0.200
     0.176     2.170     0.200
     0.224     2.164     0.200
     1.059     0.596     0.200
     1.170     0.178     0.200
     1.170     0.479     0.200
     1.217     1.394     0.200
     1.234     0.549     0.200
     1.393    -0.191     0.200
     0.170     1.478     0.200
     0.170     1.277     0.200
     0.251     1.007     0.200
     0.251     0.806     0.200
     1.029     0.324     0.200
     1.175     1.201     0.200
     1.266     0.231     0.200
     1.426     0.646     0.200
     1.426     0.246     0.200
     2.313    -2.763     0.200
     2.494    -1.498     0.200
     2.494    -1.097     0.200
     2.509    -0.888     0.200
     2.509    -0.388     0.200
     0.176     2.438     0.200
     0.215     2.084     0.200
     0.215     1.783     0.200
     1.071     0.448     0.200
     1.071     0.047     0.200
     1.160     0.630     0.200
     1.219     1.154     0.200
     1.374    -0.257     0.200
     0.166     1.860     0.200
     0.248     1.360     0.200
     0.248     1.165     0.200
     1.033     0.692     0.200
     1.033     0.989     0.200
     1.170    -0.461     0.200
     1.170    -0.961     0.200
     1.261     0.048     0.200
     1.420    -1.173     0.200
     1.420    -0.572     0.200
     0.223     1.916     0.200
     0.223     1.814     0.200
     0.174     1.666     0.200
     1.061     0.367     0.200
     1.166     0.336     0.200
     1.166     0.734     0.200
     1.389    -1.025     0.200
     1.389     0.077     0.200
     0.160     1.369     0.200
     0.160     1.170     0.200
     0.274     0.950     0.200
     1.171     0.927     0.200
     1.171     0.826     0.200
     1.290     0.957     0.200
     1.290     0.754     0.200
     1.447    -0.137     0.200
     1.447     0.062     0.200
     2.330    -2.920     0.200
     2.499    -0.376     0.200
     2.499    -0.779     0.200
     2.518    -0.570     0.200
     0.175     1.526     0.200
     0.175     1.628     0.200
     0.212     1.163     0.200
     0.212     1.663     0.200
     1.152     0.365     0.200
     1.152    -0.237     0.200
     1.361     0.129     0.200
     1.361     0.230     0.200
     2.300    -3.139     0.200
     0.160     2.513     0.200
     1.292    -0.277     0.200
     1.292    -0.476     0.200
     1.436    -0.238     0.200
     2.305    -2.794     0.200
     2.305    -2.392     0.200
     0.409     1.676     0.200
     0.409     1.777     0.200
     0.221     1.131     0.200
     0.221     1.731     0.200
     1.141     0.397     0.200
     1.141    -0.103     0.200
     1.628    -0.950     0.200
     2.126    -2.357     0.200
     2.299    -1.213     0.200
     4.056    -5.733     0.200
     0.171     1.915     0.200
     0.171     1.610     0.200
     0.561     0.561     0.200
     1.184    -0.078     0.200
     1.184     0.422     0.200
     1.485    -1.048     0.200
     1.790    -2.188     0.200
     1.913    -0.706     0.200
     1.913    -1.206     0.200
     2.428    -1.338     0.200
     0.166     1.624     0.200
     0.229     1.900     0.200
     1.157     0.804     0.200
     1.157     0.402     0.200
     1.387     0.491     0.200
     2.309    -2.831     0.200
     0.140     0.894     0.200
     1.380     0.177     0.200
     1.539    -0.869     0.200
     1.539    -1.068     0.200
     1.571    -0.164     0.200
     1.571    -0.566     0.200
     1.569    -0.315     0.200
     2.428    -2.041     0.200
     2.459    -2.614     0.200
     0.040     3.148     0.200
     0.373     0.300     0.200
     1.062     0.948     0.200
     1.062     0.347     0.200
     1.312     1.328     0.200
     1.312     0.930     0.200
     1.293     0.822     0.200
     1.293     0.623     0.200
     2.105    -1.715     0.200
     2.276    -0.432     0.200
     0.131     1.257     0.200
     0.131     1.156     0.200
     0.314     1.750     0.200
     1.144     1.031     0.200
     1.144     0.031     0.200
     1.324     1.017     0.200
     1.469     0.447     0.200
     1.469     0.345     0.200
     2.465    -0.342     0.200
     2.465    -2.741     0.200
     2.555    -0.995     0.200
     0.193     0.398     0.200
     0.822     0.648     0.200
     0.822     1.048     0.200
     1.055     0.769     0.200
     1.055     1.069     0.200
     1.402     0.170     0.200
     1.989    -0.734     0.200
     1.989     0.266     0.200
     1.989    -0.234     0.200
     2.332    -1.105     0.200
     2.332    -0.905     0.200
     2.656    -0.583     0.200
     0.020     4.820     0.200
     0.644     1.123     0.200
     1.273    -0.703     0.200
     1.273    -0.500     0.200
     1.449    -1.789     0.200
     1.449    -1.687     0.200
     0.564    -0.005     0.200
     0.774     0.429     0.200
     0.774     0.531     0.200
     0.774     0.051     0.200
     0.774     0.950     0.200
     1.795    -1.718     0.200
     1.895    -0.812     0.200
     2.267    -1.082     0.200
     2.267    -0.281     0.200
     2.226     0.522     0.200
     6.409   -12.989     0.200
     0.164     2.988     0.200
     0.223     1.411     0.200
     1.173     0.925     0.200
     1.190     0.663     0.200
     2.252    -2.898     0.200
     0.151     1.693     0.200
     0.241     0.722     0.200
     0.241     1.722     0.200
     1.142     0.770     0.200
     1.142     0.668     0.200
     1.241     1.426     0.200
     1.387     0.197     0.200
     1.387     0.096     0.200
     2.324    -2.393     0.200
     0.086     1.276     0.200
     0.557     0.754     0.200
     1.079     0.518     0.200
     1.382     0.110     0.200
     1.790    -1.238     0.200
     1.835    -1.253     0.200
     2.325    -0.076     0.200
     2.325    -1.678     0.200
     2.706    -1.081     0.200
     0.400     2.711     0.200
     1.026     0.057     0.200
     1.026    -0.045     0.200
     1.669    -0.033     0.200
     1.963    -3.547     0.200
     1.963    -3.948     0.200
     5.570   -13.369     0.200
     6.538   -17.467     0.200
     0.113     0.013     0.200
     0.113    -0.187     0.200
     0.744     1.717     0.200
     1.024     0.742     0.200
     1.360     0.582     0.200
     1.360     1.782     0.200
     1.228     0.575     0.200
     1.228     1.075     0.200
     1.613    -1.122     0.200
     1.918    -0.888     0.200
     1.918     0.112     0.200
     1.918     1.312     0.200
     2.698    -1.028     0.200
     2.698    -0.428     0.200
     6.308   -11.763     0.200
     0.484     1.265     0.200
     0.530     1.423     0.200
     0.530     1.025     0.200
     0.796     1.684     0.200
     0.796     1.880     0.200
     0.993     0.837     0.200
     0.993     0.735     0.200
     1.406    -0.562     0.200
     1.406    -0.664     0.200
     1.877    -1.989     0.200
     1.877     0.011     0.200
     1.877    -2.090     0.200
     3.881    -5.703     0.200
     6.929   -15.843     0.200
     0.021     6.171     0.200
     0.384     1.146     0.200
     0.384     1.646     0.200
     1.015     0.561     0.200
     1.234     0.108     0.200
     1.234     0.307     0.200
     1.288     0.407     0.200
     0.112    -0.001     0.200
     0.112    -0.302     0.200
     0.741     1.057     0.200
     1.045     0.940     0.200
     1.045     1.041     0.200
     1.208     0.750     0.200
     1.380     0.805     0.200
     1.931    -0.173     0.200
     1.931    -0.373     0.200
     2.316     0.640     0.200
     2.316     0.539     0.200
     2.679    -0.264     0.200
     2.679    -0.366     0.200
     0.079     3.965     0.200
     0.079     3.567     0.200
     0.552     1.894     0.200
     0.552     0.394     0.200
     1.044     0.294     0.200
     1.044     0.193     0.200
     1.346    -0.877     0.200
     1.346    -0.776     0.200
     1.269    -0.852     0.200
     1.803     0.012     0.200
     1.803    -2.085     0.200
     1.803    -0.886     0.200
     2.289    -3.765     0.200
     0.258     0.847     0.200
     0.581     0.916     0.200
     0.581    -0.186     0.200
     1.060     1.541     0.200
     1.060     0.139     0.200
     1.577    -0.550     0.200
     1.577     1.650     0.200
     1.793    -1.603     0.200
     1.985     0.416     0.200
     1.985     0.517     0.200
     2.520    -0.243     0.200
     2.528    -0.685     0.200
     3.506    -4.484     0.200
     0.110     0.166     0.200
     1.041    -0.268     0.200
     1.041     1.529     0.200
     1.377     0.004     0.200
     1.377     0.801     0.200
     1.212     1.121     0.200
     1.614    -0.738     0.200
     1.928     0.033     0.200
     2.312    -0.164     0.200
     2.683    -0.497     0.200
     2.683    -0.997     0.200
     7.419   -16.252     0.200
     0.242     2.552     0.200
     0.605     0.660     0.200
     0.790     0.084     0.200
     1.077     0.877     0.200
     1.077     0.474     0.200
     1.520    -0.254     0.200
     1.520    -0.653     0.200
     1.939    -3.046     0.200
     2.004    -1.310     0.200
     2.004    -2.009     0.200
     0.151     2.609     0.200
     0.498     1.593     0.200
     0.498     1.093     0.200
     1.112    -0.049     0.200
     1.112     0.349     0.200
     1.234     0.276     0.200
     1.234    -0.224     0.200
     1.403    -0.691     0.200
     1.403    -1.390     0.200
     1.819    -0.370     0.200
     1.819    -2.069     0.200
     1.819    -0.870     0.200
     1.847    -2.157     0.200
     0.269     1.500     0.200
     0.772     0.866     0.200
     0.772     0.561     0.200
     0.994     1.021     0.200
     0.994     0.326     0.200
     1.515    -0.193     0.200
     2.028    -2.740     0.200
     2.010    -2.256     0.200
     0.174     3.255     0.200
     0.174     2.658     0.200
     0.458     1.857     0.200
     0.458     2.158     0.200
     1.044    -0.119     0.200
     1.044     0.081     0.200
     1.325    -1.549     0.200
     1.321    -0.197     0.200
     1.733    -0.972     0.200
     1.733    -1.176     0.200
     1.897    -3.056     0.200
     1.897    -3.255     0.200
     0.108     4.327     0.200
     0.469     1.182     0.200
     0.920     0.469     0.200
     2.045    -3.291     0.200
     2.045    -3.892     0.200
     0.190     0.293     0.200
     0.190     0.193     0.200
     0.516     1.466     0.200
     0.825     1.243     0.200
     0.960     0.468     0.200
     1.375     1.021     0.200
     1.375     0.628     0.200
     2.167    -0.685     0.200
     2.616    -2.133     0.200
     2.616    -3.034     0.200
     2.627    -0.577     0.200
     2.840    -0.512     0.200
     2.950    -1.621     0.200
     2.950    -1.021     0.200
     0.191     0.262     0.200
     0.514     1.429     0.200
     0.825     1.689     0.200
     0.825     0.889     0.200
     0.965     0.346     0.200
     0.965     0.046     0.200
     1.371     2.860     0.200
     1.370     0.889     0.200
     2.167    -0.680     0.200
     2.167    -1.581     0.200
     2.615    -2.365     0.200
     2.624    -0.540     0.200
     2.841    -0.037     0.200
     2.953    -1.380     0.200
     2.953    -0.981     0.200
     0.212     1.876     0.200
     0.567     0.436     0.200
     0.816     0.931     0.200
     1.081     0.841     0.200
     1.376     0.785     0.200
     1.979    -2.725     0.200
     2.037    -0.564     0.200
     0.223     0.625     0.200
     0.608     0.119     0.200
     1.067     1.157     0.200
     1.247     0.154     0.200
     1.554     0.121     0.200
     1.756    -0.271     0.200
     1.985    -0.042     0.200
     2.497    -0.863     0.200
     2.538     0.234     0.200
     6.073   -12.734     0.200
     6.120   -12.596     0.200
     7.065   -10.161     0.200
     0.210     0.910     0.200
     0.210     0.309     0.200
     0.576     0.721     0.200
     1.098     0.276     0.200
     1.228     0.048     0.200
     1.228     0.849     0.200
     1.531    -0.541     0.200
     1.531    -0.740     0.200
     1.952     0.094     0.200
     1.783    -1.452     0.200
     2.474    -1.030     0.200
     2.568    -0.815     0.200
     2.568    -1.514     0.200
     6.146   -12.345     0.200
     8.528   -20.050     0.200
     0.208     1.189     0.200
     0.585     0.439     0.200
     1.093     0.442     0.200
     1.228    -0.048     0.200
     1.532    -0.485     0.200
     1.774    -1.049     0.200
     1.959    -0.094     0.200
     2.475    -1.874     0.200
     2.475     0.220     0.200
     2.563    -0.470     0.200
     7.932   -15.962     0.200
     8.534   -16.943     0.200
     0.226     0.859     0.200
     0.226     0.562     0.200
     0.581     0.709     0.200
     0.581     0.912     0.200
     1.083     0.779     0.200
     1.083     0.576     0.200
     1.244    -0.034     0.200
     1.547    -0.521     0.200
     1.783    -1.110     0.200
     1.966    -0.190     0.200
     1.966    -0.987     0.200
     2.553     0.302     0.200
     2.553    -1.901     0.200
     7.942   -16.137     0.200
     0.214     0.839     0.200
     0.603     0.301     0.200
     1.077     0.882     0.200
     1.238     0.683     0.200
     1.545     0.063     0.200
     1.545    -0.039     0.200
     1.758    -0.611     0.200
     1.758    -0.314     0.200
     1.976    -0.227     0.200
     1.976    -0.829     0.200
     2.487    -0.424     0.200
     2.487    -0.822     0.200
     2.548     0.054     0.200
     2.548    -0.446     0.200
     4.059    -6.656     0.200
     5.528    -7.219     0.200
     0.213     0.672     0.200
     0.213     0.367     0.200
     0.603     0.595     0.200
     1.078     0.849     0.200
     1.078     0.255     0.200
     1.237     0.413     0.200
     1.237     0.616     0.200
     1.543    -0.608     0.200
     1.543     0.087     0.200
     1.758    -0.708     0.200
     1.976    -0.114     0.200
     2.486    -0.392     0.200
     2.549    -0.176     0.200
     2.549    -0.778     0.200
     3.462    -4.338     0.200
     5.527    -8.104     0.200
     6.130   -10.112     0.200
     0.212     0.883     0.200
     0.594    -0.130     0.200
     1.085     0.506     0.200
     1.234     0.084     0.200
     1.539    -0.492     0.200
     1.767    -0.714     0.200
     1.967    -0.576     0.200
     2.482    -2.778     0.200
     2.482    -0.278     0.200
     2.555    -0.512     0.200
     7.941   -15.531     0.200
     0.245     0.421     0.200
     0.245     0.620     0.200
     0.608     0.318     0.200
     0.608     0.618     0.200
     1.051     1.270     0.200
     1.269     0.071     0.200
     1.575    -0.026     0.200
     1.575     0.076     0.200
     1.998    -0.758     0.200
     2.521    -0.223     0.200
     2.521    -0.524     0.200
     2.517    -1.214     0.200
     2.517    -0.913     0.200
     6.084   -13.261     0.200
     0.266     0.329     0.200
     0.266    -0.370     0.200
     0.618     0.386     0.200
     1.030     1.030     0.200
     1.030     0.831     0.200
     1.597     0.346     0.200
     2.018    -0.097     0.200
     2.018    -0.796     0.200
     1.761    -0.933     0.200
     2.540    -1.842     0.200
     2.540    -0.940     0.200
     2.499     0.251     0.200
     2.499    -0.949     0.200
     7.099   -12.250     0.200
     0.230     0.742     0.200
     0.603     0.321     0.200
     1.559     0.309     0.200
     1.763     0.039     0.200
     1.985    -0.111     0.200
     2.502    -0.578     0.200
     2.502    -0.877     0.200
     2.536    -0.052     0.200
     2.536    -0.252     0.200
     6.442   -12.491     0.200
     7.508   -10.804     0.200
     0.105     1.029     0.200
     0.583     0.367     0.200
     1.123     0.163     0.200
     1.182     0.564     0.200
     1.430     0.020     0.200
     1.762    -1.413     0.200
     1.886    -0.523     0.200
     1.886     0.477     0.200
     2.373    -0.859     0.200
     6.242   -13.015     0.200
     0.222     0.913     0.200
     0.222     1.316     0.200
     0.587     0.345     0.200
     1.081     0.089     0.200
     1.081     0.288     0.200
     1.243     0.370     0.200
     1.243     0.472     0.200
     1.546     0.043     0.200
     1.776    -1.635     0.200
     1.969    -0.547     0.200
     1.969    -1.047     0.200
     2.489    -1.546     0.200
     2.489    -0.749     0.200
     2.551    -0.304     0.200
     2.551    -0.804     0.200
     3.304    -4.571     0.200
     4.042    -6.261     0.200
     5.521    -9.261     0.200
     6.130   -13.047     0.200
     7.049   -14.685     0.200
     0.516     0.685     0.200
     0.830     0.045     0.200
     0.796     0.907     0.200
     1.770    -0.261     0.200
     1.760    -0.162     0.200
     7.990   -17.629     0.200
     0.222     0.995     0.200
     0.222     0.796     0.200
     0.576     0.756     0.200
     1.089     1.300     0.200
     1.089     0.901     0.200
     1.541    -0.535     0.200
     1.786    -1.291     0.200
     1.960    -0.188     0.200
     1.960    -0.387     0.200
     2.484    -0.626     0.200
     2.559     0.524     0.200
     2.559    -0.676     0.200
     4.031    -6.566     0.200
     5.899   -10.071     0.200
     0.159     1.129     0.200
     0.753     1.524     0.200
     0.753     1.422     0.200
     1.577    -0.709     0.200
     1.617    -0.273     0.200
     1.530    -0.413     0.200
     2.469    -2.399     0.200
     2.445    -2.614     0.200
     2.445    -2.512     0.200
     5.567   -12.187     0.200
     0.119     2.718     0.200
     0.119     2.517     0.200
     0.516     0.831     0.200
     0.516     1.030     0.200
     1.074    -0.946     0.200
     1.259    -0.198     0.200
     1.259     0.302     0.200
     1.369    -1.398     0.200
     1.802    -0.734     0.200
     1.802    -1.434     0.200
     1.802    -0.334     0.200
     2.312    -0.991     0.200
     5.352    -9.251     0.200
     6.310   -14.315     0.200
     0.269     1.761     0.200
     0.269     1.358     0.200
     0.986     1.033     0.200
     0.986     0.830     0.200
     0.768     0.846     0.200
     0.768     1.846     0.200
     1.598    -2.074     0.200
     1.605    -1.519     0.200
     2.104    -1.417     0.200
     2.104    -1.018     0.200
     7.176   -12.811     0.200
     0.220     0.777     0.200
     0.220     0.675     0.200
     0.573     0.673     0.200
     1.093     1.415     0.200
     1.093     0.915     0.200
     1.538     1.482     0.200
     1.956     0.245     0.200
     1.956     0.347     0.200
     2.481    -1.105     0.200
     2.562     0.239     0.200
     0.227     1.206     0.200
     0.756     1.058     0.200
     1.030    -0.027     0.200
     1.229    -0.959     0.200
     1.599    -1.976     0.200
     2.068    -0.448     0.200
     6.011    -8.626     0.200
     6.106   -13.752     0.200
     7.577   -17.066     0.200
     0.212     1.032     0.200
     0.565     0.735     0.200
     1.105     0.599     0.200
     1.527     0.044     0.200
     1.794    -1.033     0.200
     1.943     0.135     0.200
     2.470    -0.349     0.200
     2.575    -0.475     0.200
     5.797   -12.320     0.200
     6.151   -11.457     0.200
     0.458     0.341     0.200
     0.614     0.927     0.200
     0.688     1.354     0.200
     1.148     0.570     0.200
     1.148     0.672     0.200
     1.219     0.544     0.200
     1.343     1.700     0.200
     1.343     2.001     0.200
     2.002    -0.695     0.200
     2.585    -1.679     0.200
     2.744    -2.403     0.200
     2.744    -2.806     0.200
     2.907    -1.966     0.200
     2.907    -0.266     0.200
     0.224     1.007     0.200
     0.224     0.507     0.200
     0.576     0.934     0.200
     1.088     1.717     0.200
     1.241     0.152     0.200
     1.543    -0.118     0.200
     1.787    -0.938     0.200
     1.787    -0.038     0.200
     1.961    -0.251     0.200
     2.486    -0.610     0.200
     2.557     0.443     0.200
     2.557     0.243     0.200
     0.223     0.618     0.200
     0.617     0.607     0.200
     0.617     0.014     0.200
     1.062     1.116     0.200
     1.062     1.218     0.200
     1.248    -0.090     0.200
     1.248     0.808     0.200
     1.557    -0.176     0.200
     1.747    -0.984     0.200
     1.747    -0.281     0.200
     1.992    -0.770     0.200
     1.992     1.027     0.200
     2.533    -0.520     0.200
     2.533    -0.215     0.200
     2.500    -2.650     0.200
     0.111     0.153     0.200
     0.111     1.251     0.200
     1.112     1.117     0.200
     1.205     0.040     0.200
     1.414     0.037     0.200
     1.414     0.635     0.200
     1.791    -1.834     0.200
     1.858    -0.234     0.200
     1.858    -1.035     0.200
     2.357    -0.852     0.200
     2.357    -1.153     0.200
     2.677    -0.719     0.200
     0.099     0.873     0.200
     0.099     0.772     0.200
     0.575     0.078     0.200
     1.196     0.174     0.200
     1.417    -0.537     0.200
     1.417    -0.236     0.200
     1.771    -1.437     0.200
     1.872    -0.238     0.200
     2.360    -0.919     0.200
     2.669    -1.304     0.200
     2.669    -2.007     0.200
     0.109     0.529     0.200
     0.109     1.431     0.200
     0.576     0.742     0.200
     0.576     0.844     0.200
     1.124     0.061     0.200
     1.124     0.959     0.200
     1.184     1.058     0.200
     1.430     0.559     0.200
     1.770    -1.000     0.200
     1.882    -1.455     0.200
     2.373    -1.023     0.200
     2.657    -0.517     0.200
     2.657    -0.818     0.200
     3.230    -1.707     0.200
     6.337   -10.782     0.200
     0.107     1.247     0.200
     0.107     0.450     0.200
     0.589     0.262     0.200
     0.589     0.062     0.200
     1.127    -0.098     0.200
     1.127     1.504     0.200
     1.176     0.961     0.200
     1.176     0.261     0.200
     1.435     0.628     0.200
     1.756    -1.048     0.200
     1.893    -0.268     0.200
     2.378    -1.448     0.200
     2.378    -0.147     0.200
     2.649    -0.125     0.200
     0.118     0.324     0.200
     0.118     1.023     0.200
     0.575     0.721     0.200
     1.133     2.434     0.200
     1.176     0.773     0.200
     1.439     0.140     0.200
     1.439    -0.059     0.200
     1.888    -0.393     0.200
     1.888    -0.593     0.200
     1.770    -0.857     0.200
     2.382    -0.943     0.200
     2.649     0.101     0.200
     0.120     1.057     0.200
     0.120     0.756     0.200
     0.591     0.222     0.200
     0.591     1.124     0.200
     1.163     0.280     0.200
     1.141     0.276     0.200
     1.141     0.378     0.200
     1.449    -0.298     0.200
     1.755    -1.098     0.200
     1.904    -0.802     0.200
     2.392    -0.773     0.200
     2.636    -1.000     0.200
     2.636    -0.801     0.200
     0.110     0.543     0.200
     1.134     0.374     0.200
     1.164     1.211     0.200
     1.444     0.431     0.200
     1.444    -0.166     0.200
     1.744    -0.960     0.200
     1.906    -0.908     0.200
     1.906     0.291     0.200
     2.387    -1.037     0.200
     2.637    -0.784     0.200
     2.637    -1.483     0.200
     0.106     1.362     0.200
     0.567     0.449     0.200
     1.116     0.251     0.200
     1.195     0.553     0.200
     1.195     0.655     0.200
     1.421    -0.304     0.200
     1.778    -1.623     0.200
     1.870    -1.352     0.200
     2.364    -1.092     0.200
     2.667    -0.819     0.200
     2.667    -0.420     0.200
     0.110     0.646     0.200
     0.561     0.828     0.200
     1.198     2.149     0.200
     1.866    -1.129     0.200
     2.363    -1.266     0.200
     2.363    -0.266     0.200
     2.670    -0.518     0.200
     0.104     1.250     0.200
     0.590     0.063     0.200
     1.178     0.316     0.200
     1.433    -0.677     0.200
     1.756    -1.407     0.200
     1.891    -0.704     0.200
     2.376    -2.053     0.200
     2.651    -1.071     0.200
     0.048     1.231     0.200
     0.609    -0.548     0.200
     0.609     0.153     0.200
     1.072     1.178     0.200
     1.218     0.043     0.200
     1.385     0.460     0.200
     1.385     0.261     0.200
     1.739    -0.264     0.200
     1.865    -1.077     0.200
     2.327     0.102     0.200
     2.327     0.204     0.200
     3.223    -1.805     0.200
     3.223    -1.504     0.200
     4.489    -6.646     0.200
     0.277     1.751     0.200
     0.277     1.251     0.200
     0.557     0.963     0.200
     0.788     0.651     0.200
     0.788     0.448     0.200
     0.977    -0.344     0.200
     2.032    -1.869     0.200
     2.032    -1.072     0.200
     4.708    -7.116     0.200
     0.496     1.855     0.200
     0.496     0.955     0.200
     0.536     0.594     0.200
     0.536     1.194     0.200
     0.814     0.874     0.200
     0.814     1.574     0.200
     0.831     0.027     0.200
     1.752    -0.364     0.200
     1.775    -0.689     0.200
     1.900    -2.654     0.200
     0.449     0.890     0.200
     0.381     1.159     0.200
     1.162     0.082     0.200
     1.162     0.383     0.200
     1.369    -0.058     0.200
     1.624    -1.748     0.200
     2.051    -2.891     0.200
     0.186     0.289     0.200
     0.186     0.391     0.200
     0.566    -0.539     0.200
     0.851     0.414     0.200
     0.851     0.414     0.200
     1.482     0.095     0.200
     2.157    -0.977     0.200
     2.157    -1.180     0.200
     2.658    -3.073     0.200
     2.719    -2.308     0.200
     2.719    -2.710     0.200
     2.807    -0.286     0.200
     2.891    -1.853     0.200
     2.891    -2.353     0.200
     0.303     0.675     0.200
     0.663     1.464     0.200
     0.979     0.425     0.200
     0.979     0.225     0.200
     1.331    -0.425     0.200
     1.331    -0.625     0.200
     2.070    -0.935     0.200
     2.070    -2.435     0.200
     0.245     0.921     0.200
     0.245     2.022     0.200
     0.399     1.216     0.200
     1.389     0.232     0.200
     1.658    -0.300     0.200
     2.220    -1.210     0.200
     2.856    -0.955     0.200
     2.856    -0.556     0.200
     3.000    -1.139     0.200
     6.420   -12.648     0.200
     0.239     2.094     0.200
     0.239     1.393     0.200
     0.984     0.563     0.200
     1.250     2.762     0.200
     1.411     0.034     0.200
     2.189    -2.115     0.200
     2.879    -1.407     0.200
     0.406     1.742     0.200
     0.406     1.641     0.200
     0.794     0.612     0.200
     0.954     1.053     0.200
     1.796    -0.949     0.200
     1.796    -1.649     0.200
     1.889    -0.571     0.200
     0.252     1.811     0.200
     0.252     1.611     0.200
     0.432    -0.190     0.200
     0.952     1.103     0.200
     0.952     0.603     0.200
     1.216     0.339     0.200
     1.441    -0.593     0.200
     1.964    -1.573     0.200
     2.156     0.262     0.200
     2.156    -0.939     0.200
     7.688   -17.617     0.200
EOF
gmt end
